(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    357685,      13344]*)
(*NotebookOutlinePosition[    597561,      18813]*)
(*  CellTagsIndexPosition[    587252,      18547]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Input and Output", "Title"],

Cell[CellGroupData[{

Cell["$Language::noset", "ObjectNameWarningMessages",
  CellTags->"$Language::noset"],

Cell[BoxData[
    RowBox[{\($Language::"noset"\), ":", " ", 
      RowBox[{
      "The", " ", "license", " ", "configuration", " ", "for", " ", "the", 
        " ", "Kernel", " ", "does", " ", "not", " ", "allow", " ", 
        "$Language", " ", "to", " ", "be", " ", "changed", " ", "to", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], ".", " ", "All"}], " ", "messages", " ", "will", " ", "be",
         " ", "displayed", " ", "in", 
        " ", \(\(English\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"$Language::noset"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to change the value of ",
  StyleBox["$Language", "MR"],
  " in a copy of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that is not configured for language changes."
}], "Notes",
  CellTags->"$Language::noset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$Language::noset"],

Cell[TextData[{
  "Most versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " do not support Latin as a value of ",
  StyleBox["$Language", "MR"],
  "."
}], "Text",
  CellTags->"$Language::noset"],

Cell[CellGroupData[{

Cell[BoxData[
    \($Language = "\<Latin\>"\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$Language::noset"],

Cell[BoxData[
    \($Language::"noset" \(\(:\)\(\ \)\) 
      "The license configuration for the Kernel does not allow $Language to \
be changed to \!\(\"Latin\"\). All messages will be displayed in \
English."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$Language::noset"],

Cell[BoxData[
    \("Latin"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$Language::noset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$BoxForms::formset", "ObjectNameWarningMessages",
  CellTags->"$BoxForms::formset"],

Cell[BoxData[
    RowBox[{
      RowBox[{\($BoxForms::"formset"\), \(\(:\)\(\ \)\), \(\(Cannot\ set\)\(\ \
\)\), 
        StyleBox["expr",
          "TI"], " ", "to", " ", 
        StyleBox["val",
          "TI"]}], ";", 
      " ", \(value\ must\ be\ a\ list\ which\ includes\ TraditionalForm\ and\ \
\(\(StandardForm\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"$BoxForms::formset"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to remove either ",
  StyleBox["TraditionalForm", "MR"],
  " or ",
  StyleBox["StandardForm", "MR"],
  " from the forms listed in the value of ",
  StyleBox["$BoxForms", "MR"],
  "."
}], "Notes",
  CellTags->"$BoxForms::formset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$BoxForms::formset"],

Cell[TextData[{
  "You can add elements to the value of ",
  StyleBox["$BoxForms", "MR"],
  ", but you cannot assign a value that does not include both ",
  StyleBox["StandardForm", "MR"],
  " and ",
  StyleBox["TraditionalForm", "MR"],
  ".  When this error occurs, the value of ",
  StyleBox["$BoxForms", "MR"],
  " is left unchanged."
}], "Text",
  CellTags->"$BoxForms::formset"],

Cell[CellGroupData[{

Cell[BoxData[
    \($BoxForms = {StandardForm}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$BoxForms::formset"],

Cell[BoxData[
    \($BoxForms::"formset" \(\(:\)\(\ \)\) 
      "Cannot set \!\($BoxForms\) to \!\({StandardForm}\); value must be a \
list which includes TraditionalForm and StandardForm."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$BoxForms::formset"],

Cell[BoxData[
    \({StandardForm}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$BoxForms::formset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$CharacterEncoding::sjis", "ObjectNameWarningMessages",
  CellTags->"$CharacterEncoding::sjis"],

Cell[BoxData[
    \($CharacterEncoding::"sjis" \(\(:\)\(\ \)\) \(The\ byte\ sequence\ {`1`, \
\ `2`}\ could\ not\ be\ interpreted\ as\ a\ character\ in\ the\ ShiftJIS\ \
character\ \(\(encoding\)\(.\)\)\)\)], "Message",
  CellTags->"$CharacterEncoding::sjis"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"$CharacterEncoding::sjis"]
}, Open  ]],

Cell[CellGroupData[{

Cell["$CharacterEncoding::utf8", "ObjectNameWarningMessages",
  CellTags->"$CharacterEncoding::utf8"],

Cell[BoxData[
    \($CharacterEncoding::"utf8" \(\(:\)\(\ \)\) \(The\ byte\ sequence\ `1`\ \
could\ not\ be\ interpreted\ as\ a\ character\ in\ the\ UTF - 
        8\ character\ \(\(encoding\)\(.\)\)\)\)], "Message",
  CellTags->"$CharacterEncoding::utf8"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"$CharacterEncoding::utf8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["$CharacterEncoding::charcode", "ObjectNameWarningMessages",
  CellTags->"$CharacterEncoding::charcode"],

Cell[BoxData[
    \($CharacterEncoding::"charcode" \(\(:\)\(\ \)\) 
      "`1` is not a valid character encoding. A valid encoding can be the \
name of an encoding file or an empty list."\)], "Message",
  CellLabel->"From In[79]:=",
  CellTags->"$CharacterEncoding::charcode"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to assign ",
  StyleBox["$CharacterEncoding", "MR"],
  " a value which is neither a string nor a list of the indicated form."
}], "Notes",
  CellTags->"$CharacterEncoding::charcode"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$CharacterEncoding::charcode"],

Cell[TextData[{
  "The list ",
  StyleBox["{1,1}", "MR"],
  " does not have the correct form to be used as a value of ",
  StyleBox["$CharacterEncoding", "MR"],
  "."
}], "Text",
  CellTags->"$CharacterEncoding::charcode"],

Cell[CellGroupData[{

Cell[BoxData[
    \($CharacterEncoding = {1, 1}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$CharacterEncoding::charcode"],

Cell[BoxData[
    \($CharacterEncoding::"charcode" \(\(:\)\(\ \)\) 
      "\!\({1, 1}\) is not a valid character encoding. A valid encoding can \
be the name of an encoding file or an empty list."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$CharacterEncoding::charcode"],

Cell[BoxData[
    \({1, 1}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$CharacterEncoding::charcode"]
}, Open  ]],

Cell[TextData[{
  "Some of the valid values for ",
  StyleBox["$CharacterEncoding", "MR"],
  " can be found by looking at the names of the files in the ",
  StyleBox["SystemFiles/CharacterEncodings", "MR"],
  " directory for your copy of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"$CharacterEncoding::charcode"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$CharacterEncoding::charfile", "ObjectNameWarningMessages",
  CellTags->"$CharacterEncoding::charfile"],

Cell[BoxData[
    \($CharacterEncoding::"charfile" \(\(:\)\(\ \)\) 
      "The file `1` contains an invalid character encoding. A valid encoding \
is {\"type\", {{n1, \"c1\"}, ...}}."\)], "Message",
  CellLabel->"From In[79]:=",
  CellTags->"$CharacterEncoding::charfile"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when loading the indicated file does not  \
give a valid character encoding.  A file is loaded as a character encoding \
file when the name of the file is assigned as the value of ",
  StyleBox["$CharacterEncoding", "MR"],
  ".\n\[FilledSmallSquare] This message will normally be generated only if  \
you have added or edited a character encoding file.  This message could also \
be generated if the indicated file is corrupted.\n\[FilledSmallSquare]  \
Character encoding files can be found in the ",
  StyleBox["SystemFiles/CharacterEncodings", "MR"],
  " directory in your copy of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"$CharacterEncoding::charfile"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TableForm::wtfsp", "ObjectNameWarningMessages",
  CellTags->"TableForm::wtfsp"],

Cell[BoxData[
    \(TableForm::"wtfsp" \(\(:\)\(\ \)\) 
      "Warning: TableSpacing value of `1` must be non-negative. Formatting \
will proceed with a value of 0."\)], "Message",
  CellLabel->"From In[79]:=",
  CellTags->"TableForm::wtfsp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["TableSpacing", "MR"],
  " option does not have the indicated form.\n\[FilledSmallSquare] The value \
of the  ",
  StyleBox["TableSpacing", "MR"],
  " option is expected to be ",
  StyleBox["Automatic", "MR"],
  ", a non-negative number, or a list of non-negative numbers."
}], "Notes",
  CellTags->"TableForm::wtfsp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"TableForm::wtfsp"],

Cell[TextData[{
  "A message is generated if the value of the ",
  StyleBox["TableSpacing", "MR"],
  " option includes negative numbers."
}], "Text",
  CellTags->"TableForm::wtfsp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[{{1, 2}, {3, 4}}, TableSpacing -> {0, \(-1\)}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"TableForm::wtfsp"],

Cell[BoxData[
    \(TableForm::"tfsp" \(\(:\)\(\ \)\) 
      "Value of option TableSpacing -> \!\(-1\) should be Automatic or a list \
of machine-size numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"TableForm::wtfsp"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2"},
          {"3", "4"}
          },
        RowSpacings->0,
        ColumnSpacings->0.25,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$, TableSpacing -> {0, -1}]]]], "Output",
  CellLabel->"Out[1]//TableForm=",
  CellTags->"TableForm::wtfsp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrate::intnest", "ObjectNameWarningMessages",
  CellTags->"Integrate::intnest"],

Cell[BoxData[
    \(Integrate::"intnest" \(\(:\)\(\ \)\) 
      "The integral `1` cannot be interpreted. The number of integral \
operators must match the number of differential operators."\)], "Message",
  CellLabel->"From In[79]:=",
  CellTags->"Integrate::intnest"],

Cell["\<\
\[FilledSmallSquare] Generated for incorrect typset input involving \
an unequal number of integral operators and differential operators.
\[FilledSmallSquare] The integral sign \[Integral] is used in typset input to \
indicate integration. A differential operator of the form \[DifferentialD]x \
is used to identify the variable of integration.
\[FilledSmallSquare] Multiple integrals can be entered using repeated \
integral signs and differential operators.\
\>", "Notes",
  CellTags->"Integrate::intnest"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Integrate::intnest"],

Cell["\<\
This input will generate a warning message because it includes one \
integral sign and two differential operators.  When this error occurs, the \
input is not evaluated.\
\>", "Text",
  CellTags->"Integrate::intnest"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]x \[DifferentialD]x \[DifferentialD]x\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::intnest"],

Cell[BoxData[
    \(Integrate::"intnest" \(\(:\)\(\ \)\) 
      "The integral \!\(\[Integral] \(\(x \(\(\[DifferentialD] x\)\) \(\(\
\[DifferentialD] x\)\)\)\)\) cannot be interpreted. The number of integral \
operators must match the number of differential operators."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Integrate::intnest"],

Cell[BoxData[
    StyleBox[
      ErrorBox[\(\[Integral]x \[DifferentialD]x \[DifferentialD]x\)],
      ShowStringCharacters->True]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Integrate::intnest"]
}, Open  ]],

Cell["\<\
A double integral can be indicated using matching integral signs \
and differential operators.\
\>", "Text",
  CellTags->"Integrate::intnest"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\(\[Integral]x \[DifferentialD]x \[DifferentialD]x\)\)], \
"Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::intnest"],

Cell[BoxData[
    \(x\^3\/6\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Integrate::intnest"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
AccountingForm::expint
EngineeringForm::expint
NumberForm::expint
PaddedForm::expint
ScientificForm::expint\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"expint\"\>"}], \(\(:\)\(\ \)\), "Result", " ", 
      StyleBox["expr",
        "TI"], " ", "obtained", " ", "by", " ", "applying", " ", "the", " ", 
      "value", " ", "of", " ", "the", " ", "ExponentFunction", " ", "option", 
      " ", "to", " ", "`2`", " ", "should", " ", "be", " ", "an", " ", 
      "integer", " ", "or", " ", \(\(Null\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["ExponentFunction", "MR"],
  " option does not give the expected result.\n\[FilledSmallSquare] When \
formatting an inexact number, the value of the ",
  StyleBox["ExponentFunction", "MR"],
  " option is applied to the exponent that would be used to format the number \
 in scientific notation.\n\[FilledSmallSquare] The value of the ",
  StyleBox["ExponentFunction", "MR"],
  " option should be a function that takes an integer argument and that \
returns an  integer or ",
  StyleBox["Null", "MR"],
  ".  A return value of ",
  StyleBox["Null", "MR"],
  " causes no exponent to be displayed."
}], "Notes",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],

Cell[TextData[{
  "This input generates a warning message because ",
  StyleBox["Null[", "MR"],
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " evaluates to itself, rather than to an integer or to ",
  StyleBox["Null", "MR"],
  "."
}], "Text",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberForm[0.000000001234, ExponentFunction -> Null]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],

Cell[BoxData[
    \(NumberForm::"expint" \(\(:\)\(\ \)\) 
      "Result \!\(Null[\"-9\"]\) obtained by applying the value of the \
ExponentFunction option to \!\(\"-9\"\) should be an integer or Null."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],

Cell[BoxData[
    TagBox[
      InterpretationBox[\("1.234"\[Times]10\^"-9"\),
        1.2340000000000001*^-09,
        AutoDelete->True],
      (NumberForm[ #, ExponentFunction -> Null]&)]], "Output",
  CellLabel->"Out[1]//NumberForm=",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of the ",
  StyleBox["ExponentFunction", "MR"],
  " option.  The pure function ",
  StyleBox["Null&", "MR"],
  " applied to any argument will return ",
  StyleBox["Null", "MR"],
  ", which causes numbers to be displayed without exponents."
}], "Text",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberForm[0.000000001234, \ 
      ExponentFunction\  -> \((Null\  &)\)]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],

Cell[BoxData[
    TagBox[
      InterpretationBox["\<\"0.000000001234\"\>",
        1.2340000000000001*^-09,
        AutoDelete->True],
      (NumberForm[ #, ExponentFunction -> (Null&)]&)]], "Output",
  CellLabel->"Out[2]//NumberForm=",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::uniopen", "ObjectNameWarningMessages",
  CellTags->"General::uniopen"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"uniopen\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "an", " ", "opening", " ", "matchfix", 
        " ", \(\(operator\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::uniopen"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not seen explicitly in normal use of  \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  If you see this message when it is not expected, please contact \
Technical Support.\n\[FilledSmallSquare] This message is used for displaying \
information about certain typeset operators."
}], "Notes",
  CellTags->"General::uniopen"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::uniclose", "ObjectNameWarningMessages",
  CellTags->"General::uniclose"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"uniclose\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "a", " ", "closing", " ", "matchfix", 
        " ", \(\(operator\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::uniclose"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not seen explicitly in normal use of  \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  If you see this message when it is not expected, please contact \
Technical Support.\n\[FilledSmallSquare] This message is used for  displaying \
information about certain typeset operators."
}], "Notes",
  CellTags->"General::uniclose"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::uniclose"],

Cell["These inputs show some uses of this message.", "Text",
  CellTags->"General::uniclose"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?\[RightDoubleBracket]\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::uniclose"],

Cell[BoxData[
    \("\[RightDoubleBracket] is a closing matchfix operator."\)], "Print",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::uniclose"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<\[RightDoubleBracket]\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::uniclose"],

Cell[BoxData[
    \("\[RightDoubleBracket] is a closing matchfix operator."\)], "Print",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::uniclose"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrate::nodiffd", "ObjectNameWarningMessages",
  CellTags->"Integrate::nodiffd"],

Cell[BoxData[
    \(Integrate::"nodiffd" \(\(:\)\(\ \)\) 
      "`1` cannot be interpreted. Integrals are entered in the form \!\(\
\[Integral]f\[DifferentialD]x\), where \!\(\[DifferentialD]\) is entered as \
\[EscapeKey]dd\[EscapeKey]."\)], "Message",
  CellLabel->"From In[80]:=",
  CellTags->"Integrate::nodiffd"],

Cell["\<\
\[FilledSmallSquare] Generated for typeset input when an \
integration operator is used without a corresponding differential operator.
\[FilledSmallSquare] The integral sign \[Integral] is used in typset input to \
indicate integration. A differential operator of the form \[DifferentialD]x \
is used to identify the variable of integration.
\[FilledSmallSquare] You can use buttons from the Basic Calculations palette, \
the Basic Input pallette, or other palettes to enter integrals.  Standard \
palettes can be accessed by selecting Palettes under the File menu.\
\>", \
"Notes",
  CellTags->"Integrate::nodiffd"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Integrate::nodiffd"],

Cell["\<\
This input generates a message because it includes an integral sign \
without a corresponding differential operator.  When this error occurs, the \
input is not evaluated.\
\>", "Text",
  CellTags->"Integrate::nodiffd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]x\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::nodiffd"],

Cell[BoxData[
    \(Integrate::"nodiffd" \(\(:\)\(\ \)\) 
      "\!\(\[Integral] x\) cannot be interpreted. Integrals are entered in  \
the form \!\(\[Integral]f\[DifferentialD]x\), where \!\(\[DifferentialD]\) is \
 entered as \[EscapeKey]dd\[EscapeKey]."\)], "Message",
  CellTags->"Integrate::nodiffd"],

Cell[BoxData[
    StyleBox[
      ErrorBox[\(\[Integral]x\)],
      ShowStringCharacters->True]], "Message",
  CellTags->"Integrate::nodiffd"]
}, Open  ]],

Cell["This shows a correctly typeset integral.", "Text",
  CellTags->"Integrate::nodiffd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]x\ \[DifferentialD]x\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::nodiffd"],

Cell[BoxData[
    \(x\^2\/2\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Integrate::nodiffd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
AccountingForm::iprf
EngineeringForm::iprf
NumberForm::iprf
PaddedForm::iprf
ScientificForm::iprf\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"iprf\"\>"}], \(\(:\)\(\ \)\), "Formatting", " ", 
      "specification", " ", 
      StyleBox["expr",
        "TI"], " ", "should", " ", "be", " ", "a", " ", "positive", " ", 
      "integer", " ", "or", " ", "a", " ", "pair", " ", "of", " ", "positive",
       " ", \(\(integers\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["AccountingForm", "MR"],
  ", ",
  StyleBox["EngineeringForm", "MR"],
  ", ",
  StyleBox["NumberForm", "MR"],
  ", ",
  StyleBox["PaddedForm", "MR"],
  ", or ",
  StyleBox["ScientificForm", "MR"],
  " does not have the expected form.\n\[FilledSmallSquare] The formatting  \
specification is the second argument in these functions.\n\
\[FilledSmallSquare] The formatting specification is expected to be a  \
positive integer indicating the number of digits to display, or a pair of  \
positive integers indicating the total number of digits and the number of  \
digits to the right of the decimal point."
}], "Notes",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],

Cell[TextData[{
  "This input generates an error because ",
  StyleBox["All", "MR"],
  " is not a valid format specification in ",
  StyleBox["PaddedForm", "MR"],
  "."
}], "Text",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(PaddedForm[ColumnForm[{17.4, \ 22.9, \ 0.031, \ 207.0}], \ 
      All]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],

Cell[BoxData[
    \(PaddedForm::"iprf" \(\(:\)\(\ \)\) 
      "Formatting specification \!\(All\) should be a positive integer or a \
pair of positive integers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],

Cell[BoxData[
    TagBox[
      InterpretationBox[GridBox[{
            {"\<\" 17.4\"\>"},
            {"\<\" 22.9\"\>"},
            {"\<\" 0.031\"\>"},
            {"\<\" 207.\"\>"}
            },
          GridBaseline->{Baseline, {1, 1}},
          ColumnAlignments->{Left}],
        ColumnForm[ {17.399999999999999, 22.899999999999999, 0.031, 207.0}],
        Editable->False],
      (PaddedForm[ #, All]&)]], "Output",
  CellLabel->"Out[1]//PaddedForm=",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of a formatting specification in ",
  StyleBox["PaddedForm", "MR"],
  "."
}], "Text",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(PaddedForm[
      ColumnForm[{17.4, \ 22.9, \ 0.031, \ 207.0}], \ {9, \ 6}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],

Cell[BoxData[
    TagBox[
      InterpretationBox[GridBox[{
            {"\<\"  17.400000\"\>"},
            {"\<\"  22.900000\"\>"},
            {"\<\"   0.031000\"\>"},
            {"\<\" 207.000000\"\>"}
            },
          GridBaseline->{Baseline, {1, 1}},
          ColumnAlignments->{Left}],
        ColumnForm[ {17.399999999999999, 22.899999999999999, 0.031, 207.0}],
        Editable->False],
      (PaddedForm[ #, {9, 6}]&)]], "Output",
  CellLabel->"Out[2]//PaddedForm=",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["BaseForm::basf", "ObjectNameWarningMessages",
  CellTags->"BaseForm::basf"],

Cell[BoxData[
    RowBox[{\(BaseForm::"basf"\), \(\(:\)\(\ \)\), "Requested", " ", "base", 
      " ", 
      StyleBox["n",
        "TI"], " ", "should", " ", "be", " ", "between", " ", "2", " ", "and",
       " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"BaseForm::basf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["BaseForm", "MR"],
  " does not fall within the required range.\n\[FilledSmallSquare] The  \
maximum value of the second argument is determined by the number of  \
characters available to represent digits.  Usually this maximum is 36.\n\
\[FilledSmallSquare] The functions ",
  StyleBox["IntegerDigits", "MR"],
  " and ",
  StyleBox["RealDigits", "MR"],
  " may be helpful for bases outside of this range."
}], "Notes",
  CellTags->"BaseForm::basf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"BaseForm::basf"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["BaseForm", "MR"],
  " is not an integer in the required range."
}], "Text",
  CellTags->"BaseForm::basf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BaseForm[3.14159, \ 40]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"BaseForm::basf"],

Cell[BoxData[
    \(BaseForm::"basf" \(\(:\)\(\ \)\) 
      "Requested base \!\(\"40\"\) should be between 2 and \!\(\"36\"\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"BaseForm::basf"],

Cell[BoxData[
    \(BaseForm[3.14159`, 40]\)], "Output",
  CellLabel->"Out[1]//BaseForm=",
  CellTags->"BaseForm::basf"]
}, Open  ]],

Cell[TextData[{
  "This shows a typical use of ",
  StyleBox["BaseForm", "MR"],
  "."
}], "Text",
  CellTags->"BaseForm::basf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BaseForm[{3.14159, \ 1.414, \ 2.718}, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"BaseForm::basf"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox[\("11.001001000011111101"\_2\),
            3.1415899999999999,
            AutoDelete->True], ",", 
          InterpretationBox[\("1.0110100111111011111"\_2\),
            1.4139999999999999,
            AutoDelete->True], ",", 
          InterpretationBox[\("10.101101111100111011"\_2\),
            2.718,
            AutoDelete->True]}], "}"}],
      (BaseForm[ #, 2]&)]], "Output",
  CellLabel->"Out[2]//BaseForm=",
  CellTags->"BaseForm::basf"]
}, Open  ]],

Cell[TextData[{
  "You can use ",
  StyleBox["RealDigits", "MR"],
  " to get the digits in a base outside of the range used by ",
  StyleBox["BaseForm", "MR"],
  "."
}], "Text",
  CellTags->"BaseForm::basf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RealDigits[3.14159, 40]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"BaseForm::basf"],

Cell[BoxData[
    \({{3, 5, 26, 21, 30, 16, 0, 0, 0, 0}, 1}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"BaseForm::basf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ColumnForm::colmh", "ObjectNameWarningMessages",
  CellTags->"ColumnForm::colmh"],

Cell[BoxData[
    RowBox[{\(ColumnForm::"colmh"\), \(\(:\)\(\ \)\), \(\(Horizontal\)\(\ \
\)\(alignment\)\(\ \)\(specification\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ Left, \ Center, \ 
      or\ \(\(Right\)\(.\)\)\)\)}]], "Message",
  CellTags->"ColumnForm::colmh"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["ColumnForm", "MR"],
  " is an expression other than ",
  StyleBox["Left", "MR"],
  ", ",
  StyleBox["Center", "MR"],
  ", or ",
  StyleBox["Right", "MR"],
  "."
}], "Notes",
  CellTags->"ColumnForm::colmh"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ColumnForm::colmh"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Top", "MR"],
  " is not a valid value for the second argument."
}], "Text",
  CellTags->"ColumnForm::colmh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ColumnForm[{12345678, 12345, 12}, Top]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ColumnForm::colmh"],

Cell[BoxData[
    \(ColumnForm::"colmh" \(\(:\)\(\ \)\) 
      "Horizontal alignment specification \!\(Top\) is not Left, Center, or \
Right."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ColumnForm::colmh"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"12345678"},
          {"12345"},
          {"12"}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      ColumnForm[ {12345678, 12345, 12}, Top],
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ColumnForm::colmh"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the second argument in ",
  StyleBox["ColumnForm", "MR"],
  "."
}], "Text",
  CellTags->"ColumnForm::colmh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ColumnForm[{12345678, 12345, 12}, Right]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ColumnForm::colmh"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"12345678"},
          {"12345"},
          {"12"}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Right}],
      ColumnForm[ {12345678, 12345, 12}, Right],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ColumnForm::colmh"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ColumnForm::colmv", "ObjectNameWarningMessages",
  CellTags->"ColumnForm::colmv"],

Cell[BoxData[
    RowBox[{\(ColumnForm::"colmv"\), \(\(:\)\(\ \)\), \(\(Vertical\)\(\ \
\)\(alignment\)\(\ \)\(specification\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ Below, \ Center, \ 
      or\ \(\(Above\)\(.\)\)\)\)}]], "Message",
  CellTags->"ColumnForm::colmv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third argument in ",
  StyleBox["ColumnForm", "MR"],
  " is an expression other than ",
  StyleBox["Below", "MR"],
  ", ",
  StyleBox["Center", "MR"],
  ", or ",
  StyleBox["Above", "MR"],
  "."
}], "Notes",
  CellTags->"ColumnForm::colmv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ColumnForm::colmv"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Left", "MR"],
  " is not one of the valid values for the third argument."
}], "Text",
  CellTags->"ColumnForm::colmv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ColumnForm[{12345678, 12345, 12}, Right, Left]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ColumnForm::colmv"],

Cell[BoxData[
    \(ColumnForm::"colmv" \(\(:\)\(\ \)\) 
      "Vertical alignment specification \!\(Left\) is not Below, Center, or \
Above."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ColumnForm::colmv"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"12345678"},
          {"12345"},
          {"12"}
          },
        GridBaseline->Baseline,
        ColumnAlignments->{Right}],
      ColumnForm[ {12345678, 12345, 12}, Right, Left],
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ColumnForm::colmv"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ColumnForm", "MR"],
  "."
}], "Text",
  CellTags->"ColumnForm::colmv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ColumnForm[{12345678, 12345, 12}, Right, Center]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ColumnForm::colmv"],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {"12345678"},
          {"12345"},
          {"12"}
          },
        GridBaseline->Center,
        ColumnAlignments->{Right}],
      ColumnForm[ {12345678, 12345, 12}, Right, Center],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ColumnForm::colmv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Context::quote", "ObjectNameWarningMessages",
  CellTags->"Context::quote"],

Cell[BoxData[
    RowBox[{\(Context::"quote"\), \(\(:\)\(\ \)\), \(\(\(Warning\)\(,\)\)\(\ \
\)\), 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", 
      " ", \(context . \ A\), " ", "valid", " ", "context", " ", "uses", " ", 
      "back", " ", "quotes", " ", "instead", " ", "of", " ", "forward", " ", 
      "quotes", " ", "as", " ", "in", " ", 
      RowBox[{
        StyleBox["spec",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Context::quote"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by a syntax error that may be the result of \
 an incorrect context specification.\n\[FilledSmallSquare] This message is  \
currently used only for input in ",
  StyleBox["InputForm", "MR"],
  "."
}], "Notes",
  CellTags->"Context::quote"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Context::quote"],

Cell[TextData[{
  "A warning message suggesting a possible corrected input is generated for  \
this syntax error in ",
  StyleBox["InputForm", "MR"],
  " input."
}], "Text",
  CellTags->"Context::quote"],

Cell[CellGroupData[{

Cell["<<package'", "Input",
  CellLabel->"In[1]:=",
  CellTags->"Context::quote"],

Cell[BoxData[
    \(Context::"quote" \(\(:\)\(\ \)\) 
      "Warning, \!\(\"package'\"\) is not a valid context. A valid context \
uses back quotes instead of forward quotes as in \!\(\"package`\"\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Context::quote"],

Cell["Syntax::sntxf: \"<<package\" cannot be followed by \"'\".", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Context::quote"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Context::quote1", "ObjectNameWarningMessages",
  CellTags->"Context::quote1"],

Cell[BoxData[
    RowBox[{\(Context::"quote1"\), \(\(:\)\(\ \)\), \(\(\(Warning\)\(,\)\)\(\ \
\)\), 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", 
      " ", \(context . \ A\), " ", "valid", " ", "context", " ", "uses", " ", 
      "back", " ", "quotes", " ", "instead", " ", "of", " ", "forward", " ", 
      "quotes", " ", "and", " ", "ends", " ", "in", " ", "a", " ", "back", 
      " ", "quote", " ", "as", " ", "in", " ", 
      RowBox[{
        StyleBox["spec",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Context::quote1"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by a syntax error which may be the result  \
of an incorrect context specification.\n\[FilledSmallSquare] This message is  \
currently used only for input in ",
  StyleBox["InputForm", "MR"],
  "."
}], "Notes",
  CellTags->"Context::quote1"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Context::quote1"],

Cell[TextData[{
  "A warning message suggesting a possible corrected input is generated for  \
this syntax error in ",
  StyleBox["InputForm", "MR"],
  " input."
}], "Text",
  CellTags->"Context::quote1"],

Cell[CellGroupData[{

Cell["<<dir'package", "Input",
  CellLabel->"In[1]:=",
  CellTags->"Context::quote1"],

Cell[BoxData[
    \(Context::"quote1" \(\(:\)\(\ \)\) 
      "Warning, \!\(\"dir'package\"\) is not a valid context. A valid context \
uses back quotes instead of forward quotes and ends in a back quote as in \
\!\(\"dir`package`\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Context::quote1"],

Cell["Syntax::sntxf: \"<<dir\" cannot be followed by \"'package\".", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Context::quote1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Derivative::novar", "ObjectNameWarningMessages",
  CellTags->"Derivative::novar"],

Cell[BoxData[
    \(Derivative::"novar" \(\(:\)\(\ \)\) 
      "`1` cannot be interpreted. A partial derivative requires a subscript \
differentiation variable."\)], "Message",
  CellLabel->"From In[80]:=",
  CellTags->"Derivative::novar"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a typeset partial differentiation  \
operator is used without specifying a variable.\n\[FilledSmallSquare] The \
partial differentiation operator \[PartialD] can be entered using  \
\[AliasIndicator]",
  StyleBox["pd\[AliasIndicator]", "MR"],
  ", \[Backslash]",
  StyleBox["[PartialD]", "MR"],
  ", or a palette. The variable or variables are specified using subscripts."
}], "Notes",
  CellTags->"Derivative::novar"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Derivative::novar"],

Cell["\<\
An error occurs in this example because the \[PartialD] operator is \
used without specifying a variable.\
\>", "Text",
  CellTags->"Derivative::novar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\((3  x)\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Derivative::novar"],

Cell[BoxData[
    \(Derivative::"novar" \(\(:\)\(\ \)\) 
      "\!\(\[PartialD] \(\((3x)\)\)\) cannot be interpreted. A partial \
derivative requires a subscript differentiation variable."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Derivative::novar"],

Cell[BoxData[
    StyleBox[
      ErrorBox[\(\[PartialD]\((3  x)\)\)],
      ShowStringCharacters->True]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Derivative::novar"]
}, Open  ]],

Cell["\<\
This shows a correct use of the partial differentiation operator.\
\
\>", "Text",
  CellTags->"Derivative::novar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[PartialD]\_x\((3  x)\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Derivative::novar"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Derivative::novar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Format::forml
ToBoxForm::forml\
\>", "ObjectNameWarningMessages",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"forml\"\>"}], \(\(:\)\(\ \)\), \(Recursion\ depth\ limit\ \
$RecursionLimit\ exceeded\ while\ formatting\ \(\(output\)\(.\)\)\)}]], \
"Message",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when formatting rules generate infinite  \
recursion, or require recursion depth that exceeds the value of ",
  StyleBox["$RecursionLimit", "MR"],
  ".\n\[FilledSmallSquare] This error can normally be corrected through  \
careful analysis of any formatting or typesetting rules that have been  \
added."
}], "Notes",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell["\<\
An error occurs in this example because the right-hand side of this \
formatting rule involves an expression that matches the rule.\
\>", "Text",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Format[test[p_]] := p\ test[1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(test\)\" is similar to \
existing symbol \"\!\(ftest\)\"."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Format::forml", "ToBoxForm::forml"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OutputForm[test[6]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[BoxData[
    \(Format::"forml" \(\(:\)\(\ \)\) 
      "Recursion depth limit $RecursionLimit exceeded while formatting \
output."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[OutputFormData["\<\
test[6]\
\>", "\<\
6 test[1]\
\>"], "Output",
  CellLabel->"Out[2]//OutputForm=",
  CellTags->{"Format::forml", "ToBoxForm::forml"}]
}, Open  ]],

Cell["\<\
This shows a formatting rule that does not generate infinite \
recursion.\
\>", "Text",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[BoxData[
    \(Format[test[p_]] := p\ "\<test\>"[1]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(OutputForm[test[6]]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[OutputFormData["\<\
test[6]\
\>", "\<\
6 test[1]\
\>"], "Output",
  CellLabel->"Out[4]//OutputForm=",
  CellTags->{"Format::forml", "ToBoxForm::forml"}]
}, Open  ]],

Cell[TextData[{
  "Remove the formatting rule for ",
  StyleBox["test", "MR"],
  "."
}], "Text",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[BoxData[
    \(Format[test[p_]] =. \)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"Format::forml", "ToBoxForm::forml"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Format::fttp", "ObjectNameWarningMessages",
  CellTags->"Format::fttp"],

Cell[BoxData[
    RowBox[{\(Format::"fttp"\), \(\(:\)\(\ \)\), \(\(Format\)\(\ \)\(type\)\(\
\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ \(\(symbol\)\(.\)\)\)\)}]], "Message",
  CellTags->"Format::fttp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Format", "MR"],
  " is not a symbol.\n\[FilledSmallSquare] The second argument in ",
  StyleBox["Format", "MR"],
  " is expected to be a symbol that specifies a format type."
}], "Notes",
  CellTags->"Format::fttp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Format::fttp"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Format", "MR"],
  " is a normal expression rather than a symbol."
}], "Text",
  CellTags->"Format::fttp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Format[FortranForm, test[p_]] := test[p, 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Format::fttp"],

Cell[BoxData[
    \(Format::"fttp" \(\(:\)\(\ \)\) 
      "Format type \!\(test[p_]\) is not a symbol."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Format::fttp"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Format::fttp"]
}, Open  ]],

Cell["This example shows valid arguments in a formatting rule.", "Text",
  CellTags->"Format::fttp"],

Cell[BoxData[
    \(Format[test[p_], FortranForm] := test[p, 0]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Format::fttp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FortranForm[test[7]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Format::fttp"],

Cell["test(7,0)", "Output",
  CellLabel->"Out[3]//FortranForm=",
  CellTags->"Format::fttp"]
}, Open  ]],

Cell[TextData[{
  "Remove the formatting rule for ",
  StyleBox["test", "MR"],
  "."
}], "Text",
  CellTags->"Format::fttp"],

Cell[BoxData[
    \(Format[test[p_], FortranForm] =. \)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Format::fttp"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Format::lcont", "ObjectNameWarningMessages",
  CellTags->"Format::lcont"],

Cell[BoxData[
    \(Format::"lcont" \(\(:\)\(\ \)\) \(Line\ continuation\ print\ object\ \
too\ \(\(wide\)\(.\)\)\)\)], "Message",
  CellTags->"Format::lcont"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the formatted width of ",
  StyleBox["Continuation", "MR"],
  " exceeds half of the page width.\n\[FilledSmallSquare] This message should \
 occur only in the presence of unusual formatting rules for ",
  StyleBox["Continuation", "MR"],
  ".\n\[FilledSmallSquare] If you see this message in an example where it is  \
not expected, please contact Technical Support."
}], "Notes",
  CellTags->"Format::lcont"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Format::toobig", "ObjectNameWarningMessages",
  CellTags->"Format::toobig"],

Cell[BoxData[
    \(Format::"toobig" \(\(:\)\(\ \)\) \(Expression\ too\ big\ for\ \
\(\(output\)\(.\)\)\)\)], "Message",
  CellTags->"Format::toobig"],

Cell["\<\
\[FilledSmallSquare] Generated when the output formatting functions \
are unable to output in the requested format.
\[FilledSmallSquare] This message should occur only under unusual conditions, \
such as when the page width is very small.
\[FilledSmallSquare] If you see this message in an example where it is not \
expected, please contact Technical Support.\
\>", "Notes",
  CellTags->"Format::toobig"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Format::toobig"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["TotalWidth", "MR"],
  " option is too small to permit proper formatting of this expression."
}], "Text",
  CellTags->"Format::toobig"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToString[123.45678, TotalWidth -> 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Format::toobig"],

Cell[BoxData[
    \(Format::"toobig" \(\(:\)\(\ \)\) 
      "Expression too big for output."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Format::toobig"],

Cell[BoxData[
    \(\*"\<\"\"\>"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Format::toobig"]
}, Open  ]],

Cell["\<\
This expression can be formatted without error if the width is \
large enough to accommodate the expression.\
\>", "Text",
  CellTags->"Format::toobig"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToString[123.45678, TotalWidth -> 10]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Format::toobig"],

Cell[BoxData[
    \("123.457"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Format::toobig"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FormatType::ftype", "ObjectNameWarningMessages",
  CellTags->"FormatType::ftype"],

Cell[BoxData[
    RowBox[{\(FormatType::"ftype"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\
\ FormatType\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ \(\(valid\)\(.\)\)\)\)}]], "Message",
  CellTags->"FormatType::ftype"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated value of the ",
  StyleBox["FormatType", "MR"],
  " option is not among the types listed in the value of ",
  StyleBox["$PrintForms", "MR"],
  "."
}], "Notes",
  CellTags->"FormatType::ftype"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FormatType::ftype"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["FormatType", "MR"],
  " option is not among the types listed in the value of ",
  StyleBox["$PrintForms", "MR"],
  "."
}], "Text",
  CellTags->"FormatType::ftype"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{s = OpenWrite["\<TEST\>", FormatType -> cform]}, Write[s, 0]; 
      Close[s]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FormatType::ftype"],

Cell[BoxData[
    \(FormatType::"ftype" \(\(:\)\(\ \)\) 
      "Value of option FormatType -> \!\(cform\) is not valid."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"FormatType::ftype"],

Cell[BoxData[
    \("TEST"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FormatType::ftype"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \($PrintForms\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FormatType::ftype"],

Cell[BoxData[
    \({InputForm, OutputForm, TextForm, CForm, FortranForm, MathMLForm, 
      TeXForm, StandardForm, TraditionalForm}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FormatType::ftype"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["FormatType", "MR"],
  " option."
}], "Text",
  CellTags->"FormatType::ftype"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{s = OpenWrite["\<TEST\>", FormatType -> CForm]}, Write[s, 0]; 
      Close[s]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"FormatType::ftype"],

Cell[BoxData[
    \("TEST"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"FormatType::ftype"]
}, Open  ]],

Cell["Remove the test file.", "Text",
  CellTags->"FormatType::ftype"],

Cell[BoxData[
    \(DeleteFile["\<TEST\>"]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"FormatType::ftype"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::estep", "ObjectNameWarningMessages",
  CellTags->"General::estep"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"estep\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
        "of", " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "positive", 
        " ", \(\(integer\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::estep"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["ExponentStep", "MR"],
  " option is not a positive integer or infinity."
}], "Notes",
  CellTags->"General::estep"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::estep"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["ExponentStep", "MR"],
  " option is an inexact number rather than an integer."
}], "Text",
  CellTags->"General::estep"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberForm[{1.7*^-23, 2.3*^18, 3.9*^35}, 
      ExponentStep -> 5.0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::estep"],

Cell[BoxData[
    \(NumberForm::"estep" \(\(:\)\(\ \)\) 
      "Value of option \!\(ExponentStep\) -> \!\(\"5.\"\) is not a positive \
integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::estep"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox[\("1.7"\[Times]10\^"-23"\),
            1.7*^-23,
            AutoDelete->True], ",", 
          InterpretationBox[\("2.3"\[Times]10\^"18"\),
            2.3*^+18,
            AutoDelete->True], ",", 
          InterpretationBox[\("3.9"\[Times]10\^"35"\),
            3.8999999999999999*^+35,
            AutoDelete->True]}], "}"}],
      (NumberForm[ #, ExponentStep -> 5.0]&)]], "Output",
  CellLabel->"Out[1]//NumberForm=",
  CellTags->"General::estep"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["ExponentStep", "MR"],
  " option."
}], "Text",
  CellTags->"General::estep"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberForm[{1.7*^-23, 2.3*^18, 3.9*^35}, ExponentStep -> 5]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->"General::estep"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox[\("170."\[Times]10\^"-25"\),
            1.7*^-23,
            AutoDelete->True], ",", 
          InterpretationBox[\("2300."\[Times]10\^"15"\),
            2.3*^+18,
            AutoDelete->True], ",", 
          InterpretationBox[\("3.9"\[Times]10\^"35"\),
            3.8999999999999999*^+35,
            AutoDelete->True]}], "}"}],
      (NumberForm[ #, ExponentStep -> 5]&)]], "Output",
  CellLabel->"Out[2]//NumberForm=",
  CellTags->"General::estep"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::fmtval", "ObjectNameWarningMessages",
  CellTags->"General::fmtval"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"fmtval\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", " ", "format",
         " ", \(\(type\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::fmtval"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an unrecognized value for the ",
  StyleBox["FormatType", "MR"],
  " option is encountered.\n\[FilledSmallSquare] The ",
  StyleBox["FormatType", "MR"],
  " option is used by functions such as ",
  StyleBox["OpenWrite", "MR"],
  " and ",
  StyleBox["ToString", "MR"],
  ".\n\[FilledSmallSquare] ",
  "Valid values for the ",
  StyleBox["FormatType", "MR"],
  " option are listed in the values of the global variables ",
  StyleBox["$PrintForms", "MR"],
  " and ",
  StyleBox["$BoxForms", "MR"],
  "."
}], "Notes",
  CellTags->"General::fmtval"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::fmtval"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["FormatType", "MR"],
  " option is not one of the known values."
}], "Text",
  CellTags->"General::fmtval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToString[3.97*^11, FormatType -> Fortran]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::fmtval"],

Cell[BoxData[
    \(ToString::"fmtval" \(\(:\)\(\ \)\) 
      "\!\(Fortran\) is not a valid format type."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::fmtval"],

Cell[BoxData[
    \(ToString[3.97`*^11, FormatType \[Rule] Fortran]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::fmtval"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["FormatType", "MR"],
  " option."
}], "Text",
  CellTags->"General::fmtval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToString[3.97*^11, FormatType -> FortranForm]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::fmtval"],

Cell[BoxData[
    \("3.97e11"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::fmtval"]
}, Open  ]],

Cell[TextData[{
  "Valid values for the ",
  StyleBox["FormatType", "MR"],
  " option are listed in the values of the global variables ",
  StyleBox["$PrintForms", "MR"],
  " and ",
  StyleBox["$BoxForms", "MR"],
  "."
}], "Text",
  CellTags->"General::fmtval"],

Cell[CellGroupData[{

Cell[BoxData[
    \($PrintForms\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::fmtval"],

Cell[BoxData[
    \({InputForm, OutputForm, TextForm, CForm, FortranForm, MathMLForm, 
      TeXForm, StandardForm, TraditionalForm}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::fmtval"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \($BoxForms\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::fmtval"],

Cell[BoxData[
    \({StandardForm, TraditionalForm}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::fmtval"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ifexp", "ObjectNameWarningMessages",
  CellTags->"General::ifexp"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ifexp\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "exponent", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "an", 
      " ", \(\(integer\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ifexp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an exponent ",
  StyleBox["exp", "MR",
    FontSlant->"Italic"],
  " in the notation ",
  StyleBox["digits", "MR",
    FontSlant->"Italic"],
  StyleBox["*^", "MR"],
  StyleBox["exp", "MR",
    FontSlant->"Italic"],
  " for numbers is not an integer.\n\[FilledSmallSquare] This message is not  \
used in current versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", as input that might lead to this message will generate a syntax error  \
before this message can occur."
}], "Notes",
  CellTags->"General::ifexp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ifpa", "ObjectNameWarningMessages",
  CellTags->"General::ifpa"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ifpa\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "precision", " ", "or", " ", "accuracy", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "representable", " ", "as", " ", 
      "a", " ", "machine", " ", \(\(number\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ifpa"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the precision specification ",
  StyleBox["prec", "MR",
    FontSlant->"Italic"],
  " in the notation ",
  StyleBox["digits", "MR",
    FontSlant->"Italic"],
  StyleBox["`", "MR"],
  StyleBox["prec", "MR",
    FontSlant->"Italic"],
  " for numbers, or the accuracy specification acc in ",
  StyleBox["digits", "MR",
    FontSlant->"Italic"],
  StyleBox["`", "MR"],
  StyleBox["acc", "MR",
    FontSlant->"Italic"],
  ", is not a machine number."
}], "Notes",
  CellTags->"General::ifpa"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::ifpa"],

Cell["\<\
An error occurs in this example because the the accuracy \
specification exceeds the largest number that can be represented as a machine \
number on this computer.\
\>", "Text",
  CellTags->"General::ifpa"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<1.3``\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999999999999999999999999999999999999999999999999\
999999999999999999999999999999999\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::ifpa"],

Cell[BoxData[
    \(General::"ifpa" \(\(:\)\(\ \)\) 
      "The precision or accuracy \!\(\"999999999999999999999999999999999\"\
\[Ellipsis]\"999999999999999999999999999999999\"\) is not representable as a \
machine number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::ifpa"],

Cell["\<\
ToExpression::sntx: 
   Syntax error in or before 
    \"                                <<303>>               ^\".\
\>", \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::ifpa"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::ifpa"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::npad", "ObjectNameWarningMessages",
  CellTags->"General::npad"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"npad\"\>"}], \(\(:\)\(\ \)\), \(Value\ for\ option\ \
NumberPadding\)}], " ", "->", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "string", " ", "or",
         " ", "a", " ", "pair", " ", "of", 
        " ", \(\(strings\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::npad"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["NumberPadding", "MR"],
  " option is not a string or a pair of strings."
}], "Notes",
  CellTags->"General::npad"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::npad"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["NumberPadding", "MR"],
  " option is an integer rather than a string."
}], "Text",
  CellTags->"General::npad"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PaddedForm[ColumnForm[{37.58, 1.03, 0.00581}], {8, 5}, 
      NumberPadding -> 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::npad"],

Cell[BoxData[
    \(PaddedForm::"npad" \(\(:\)\(\ \)\) 
      "Value for option NumberPadding -> \!\(\"0.\"\) should be a string or a \
pair of strings."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::npad"],

Cell[BoxData[
    TagBox[
      InterpretationBox[GridBox[{
            {"\<\"37.58\"\>"},
            {"\<\"1.03\"\>"},
            {"\<\"0.00581\"\>"}
            },
          GridBaseline->{Baseline, {1, 1}},
          ColumnAlignments->{Left}],
        ColumnForm[ {37.579999999999998, 1.03, 0.0058100000000000001}],
        Editable->False],
      (PaddedForm[ #, {8, 5}, NumberPadding -> 0]&)]], "Output",
  CellLabel->"Out[1]//PaddedForm=",
  CellTags->"General::npad"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["NumberPadding", "MR"],
  " option."
}], "Text",
  CellTags->"General::npad"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PaddedForm[ColumnForm[{37.58, 1.03, 0.00581}], {8, 5}, 
      NumberPadding -> "\<0\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::npad"],

Cell[BoxData[
    TagBox[
      InterpretationBox[GridBox[{
            {"\<\"0037.58000\"\>"},
            {"\<\"0001.03000\"\>"},
            {"\<\"0000.00581\"\>"}
            },
          GridBaseline->{Baseline, {1, 1}},
          ColumnAlignments->{Left}],
        ColumnForm[ {37.579999999999998, 1.03, 0.0058100000000000001}],
        Editable->False],
      (PaddedForm[ #, {8, 5}, NumberPadding -> "0"]&)]], "Output",
  CellLabel->"Out[2]//PaddedForm=",
  CellTags->"General::npad"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::newl", "ObjectNameWarningMessages",
  CellTags->"General::newl"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"newl\"\>"}], \(\(:\)\(\ \)\), "\<\"The newline character \
after \\\"`1`\\\" is understood as a multiplication operator.`4`\"\>"}]], \
"Message",
  CellLabel->"From In[80]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::newl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when expressions on consecutive lines of  \
input are interpreted as being multiplied together.\n\[FilledSmallSquare]  \
This message is used primarily for non-typeset ",
  StyleBox["InputForm", "MR"],
  " input."
}], "Notes",
  CellTags->"General::newl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::newl"],

Cell[TextData[{
  "A warning message is generated in this example because two of the lines in \
this ",
  StyleBox["InputForm", "MR"],
  " input are multiplied together."
}], "Text",
  CellTags->"General::newl"],

Cell[CellGroupData[{

Cell["\<\
Module[{result},
    Print[\"start\"];
    result = 2 + 2;
    Print[result]
    result
]\
\>", "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::newl"],

Cell["\<\
Syntax::newl: The newline character after \"    Print[result]\"
     is understood as a multiplication operator.\
\>", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::newl"],

Cell[BoxData[
    \("start"\)], "Print",
  CellLabel->"From In[1]:=",
  CellTags->"General::newl"],

Cell[BoxData[
    \(4\)], "Print",
  CellLabel->"From In[1]:=",
  CellTags->"General::newl"],

Cell[BoxData[
    \(4\ Null\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::newl"]
}, Open  ]],

Cell["\<\
A semicolon can be used to indicate that the lines of input are \
elements in a compound expression.\
\>", "Text",
  CellTags->"General::newl"],

Cell[CellGroupData[{

Cell["\<\

Module[{result},
    Print[\"start\"];
    result = 2 + 2;
    Print[result];
    result
]\
\>", "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::newl"],

Cell[BoxData[
    \("start"\)], "Print",
  CellLabel->"From In[2]:=",
  CellTags->"General::newl"],

Cell[BoxData[
    \(4\)], "Print",
  CellLabel->"From In[2]:=",
  CellTags->"General::newl"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::newl"]
}, Open  ]],

Cell["\<\
An explicit multiplication operator (an asterisk) can be included \
if multiplication of separate lines of input is intentional.\
\>", "Text",
  CellTags->"General::newl"],

Cell[CellGroupData[{

Cell["\<\

Module[{result},
    Print[\"start\"];
    result = 2 + 2;
    Print[result] *
    result
]\
\>", "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::newl"],

Cell[BoxData[
    \("start"\)], "Print",
  CellLabel->"From In[3]:=",
  CellTags->"General::newl"],

Cell[BoxData[
    \(4\)], "Print",
  CellLabel->"From In[3]:=",
  CellTags->"General::newl"],

Cell[BoxData[
    \(4\ Null\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::newl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nsgn", "ObjectNameWarningMessages",
  CellTags->"General::nsgn"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"nsgn\"\>"}], \(\(:\)\(\ \)\), \(Value\ for\ option\ \
NumberSigns\)}], " ", "->", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "pair", " ", "of", 
        " ", "strings", " ", "or", " ", "two", " ", "pairs", " ", "of", 
        " ", \(\(strings\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nsgn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["NumberSigns", "MR"],
  " option is not a list of two strings or a list of two such lists."
}], "Notes",
  CellTags->"General::nsgn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::nsgn"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["NumberSigns", "MR"],
  " option is a pair of symbols rather than a pair of strings."
}], "Text",
  CellTags->"General::nsgn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberForm[{\(-23.1\), 67.8}, 
      NumberSigns -> {Negative, Positive}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::nsgn"],

Cell[BoxData[
    \(NumberForm::"nsgn" \(\(:\)\(\ \)\) 
      "Value for option NumberSigns -> \!\({Negative, Positive}\) should be a \
pair of strings or two pairs of strings."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::nsgn"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox["\<\"-23.1\"\>",
            -23.100000000000001,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"67.8\"\>",
            67.799999999999997,
            AutoDelete->True]}], "}"}],
      (NumberForm[ #, NumberSigns -> {Negative, Positive}]&)]], "Output",
  CellLabel->"Out[1]//NumberForm=",
  CellTags->"General::nsgn"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["NumberSigns", "MR"],
  " option."
}], "Text",
  CellTags->"General::nsgn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberForm[{\(-23.1\), 67.8}, 
      NumberSigns -> {"\<-\>", "\<+\>"}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::nsgn"],

Cell[BoxData[
    TagBox[
      RowBox[{"{", 
        RowBox[{
          InterpretationBox["\<\"-23.1\"\>",
            -23.100000000000001,
            AutoDelete->True], ",", 
          InterpretationBox["\<\"+67.8\"\>",
            67.799999999999997,
            AutoDelete->True]}], "}"}],
      (NumberForm[ #, NumberSigns -> {"-", "+"}]&)]], "Output",
  CellLabel->"Out[2]//NumberForm=",
  CellTags->"General::nsgn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::npt", "ObjectNameWarningMessages",
  CellTags->"General::npt"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"npt\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
        "for", " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "is", " ", "expected", " ", "to", " ", "be", " ", "a", 
        " ", \(\(string\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::npt"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["NumberPoint", "MR"],
  " option is not a string."
}], "Notes",
  CellTags->"General::npt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::npt"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["NumberPoint", "MR"],
  " option is a symbol rather than a string."
}], "Text",
  CellTags->"General::npt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberForm[37.93, NumberPoint -> None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::npt"],

Cell[BoxData[
    \(NumberForm::"npt" \(\(:\)\(\ \)\) 
      "Value for option \!\(NumberPoint\) -> \!\(None\) is expected to be a \
string."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::npt"],

Cell[BoxData[
    TagBox[
      InterpretationBox["\<\"37.93\"\>",
        37.93,
        AutoDelete->True],
      (NumberForm[ #, NumberPoint -> None]&)]], "Output",
  CellLabel->"Out[1]//NumberForm=",
  CellTags->"General::npt"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["NumberPoint", "MR"],
  " option."
}], "Text",
  CellTags->"General::npt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberForm[37.93, NumberPoint -> "\<,\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::npt"],

Cell[BoxData[
    TagBox[
      InterpretationBox["\<\"37,93\"\>",
        37.93,
        AutoDelete->True],
      (NumberForm[ #, NumberPoint -> ","]&)]], "Output",
  CellLabel->"Out[2]//NumberForm=",
  CellTags->"General::npt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nspr", "ObjectNameWarningMessages",
  CellTags->"General::nspr"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"nspr\"\>"}], \(\(:\)\(\ \)\), \(Value\ for\ option\ \
NumberSeparator\)}], " ", "->", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "string", " ", "or",
         " ", "a", " ", "pair", " ", "of", 
        " ", \(\(strings\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nspr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["NumberSeparator", "MR"],
  " option is not a string or a list of two strings."
}], "Notes",
  CellTags->"General::nspr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::nspr"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["NumberSeparator", "MR"],
  " option is a symbol rather than a string."
}], "Text",
  CellTags->"General::nspr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberForm[577225159743, NumberSeparator -> Point, 
      DigitBlock -> 3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::nspr"],

Cell[BoxData[
    \(NumberForm::"nspr" \(\(:\)\(\ \)\) 
      "Value for option NumberSeparator -> \!\(Point\) should be a string or \
a pair of strings."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::nspr"],

Cell[BoxData[
    TagBox[
      InterpretationBox["\<\"577,225,159,743\"\>",
        577225159743,
        Editable->False],
      (NumberForm[ #, NumberSeparator -> Point, DigitBlock -> 3]&)]], "Output",\

  CellLabel->"Out[1]//NumberForm=",
  CellTags->"General::nspr"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["NumberSeparator", "MR"],
  " option."
}], "Text",
  CellTags->"General::nspr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberForm[577225159743, NumberSeparator -> "\<.\>", 
      DigitBlock -> 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::nspr"],

Cell[BoxData[
    TagBox[
      InterpretationBox["\<\"577.225.159.743\"\>",
        577225159743,
        Editable->False],
      (NumberForm[ #, NumberSeparator -> ".", DigitBlock -> 3]&)]], "Output",
  CellLabel->"Out[2]//NumberForm=",
  CellTags->"General::nspr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sntue", "ObjectNameWarningMessages",
  CellTags->"General::sntue"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"sntue\"\>"}], \(\(:\)\(\ \)\), "Unexpected", " ", 
      "end", " ", "of", " ", "file", " ", 
      RowBox[{\((probably\ unfinished\ expression)\), ".", 
        StyleBox["n",
          "TI"]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::sntue"],

Cell["\<\
\[FilledSmallSquare] Generated when a file contains a syntax error \
and the error appears to correspond to an incomplete expression.\
\>", "Notes",\

  CellTags->"General::sntue"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sntue"],

Cell["\<\
An error occurs in this example because the expression written to \
the file is not complete.\
\>", "Text",
  CellTags->"General::sntue"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Write["\<TESTFILE\>", OutputForm["\<2+\>"]]; 
    Close["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sntue"],

Cell[BoxData[
    \("TESTFILE"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::sntue"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Get["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::sntue"],

Cell["\<\
Syntax::sntue: 
   Unexpected end of file (probably unfinished expression).
     (line 2 of \"TESTFILE\")\
\>", "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::sntue"]
}, Open  ]],

Cell["Delete the test file.", "Text",
  CellTags->"General::sntue"],

Cell[BoxData[
    \(DeleteFile["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::sntue"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sntup", "ObjectNameWarningMessages",
  CellTags->"General::sntup"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"sntup\"\>"}], \(\(:\)\(\ \)\), "Unexpected", " ", 
      "end", " ", "of", " ", "file", " ", 
      RowBox[{\((probably\ unclosed\ parenthesis)\), ".", 
        StyleBox["n",
          "TI"]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::sntup"],

Cell["\<\
\[FilledSmallSquare] Generated when a file contains a syntax error \
and the error appears to be an unmatched parenthesis or square bracket.\
\>", \
"Notes",
  CellTags->"General::sntup"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sntup"],

Cell["\<\
An error occurs in this example because of an unmatched bracket in \
the test file.\
\>", "Text",
  CellTags->"General::sntup"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Write["\<TESTFILE\>", OutputForm["\<Plus[2,2\>"]]; 
    Close["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sntup"],

Cell[BoxData[
    \("TESTFILE"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::sntup"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Get["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::sntup"],

Cell["\<\
Syntax::sntup: 
   Unexpected end of file (probably unclosed parenthesis).
     (line 2 of \"TESTFILE\")\
\>", "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::sntup"]
}, Open  ]],

Cell["Delete the test file.", "Text",
  CellTags->"General::sntup"],

Cell[BoxData[
    \(DeleteFile["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::sntup"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sntx", "ObjectNameWarningMessages",
  CellTags->"General::sntx"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sntx\"\>"}], \(\(:\)\(\ \)\), "\<\"Syntax error in or \
before \\\"`1`\\\".`4`\"\>"}]], "Message",
  CellLabel->"From In[80]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::sntx"],

Cell["\<\
\[FilledSmallSquare] Generated by a syntax error in input.\
\>", \
"Notes",
  CellTags->"General::sntx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sntx"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["ToExpression", "MR"],
  " does not represent syntactically valid input."
}], "Text",
  CellTags->"General::sntx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<& #\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sntx"],

Cell["\<\
ToExpression::sntx: Syntax error in or before \"& #\".
                                                ^\
\>", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::sntx"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::sntx"]
}, Open  ]],

Cell["This shows a syntactically valid input.", "Text",
  CellTags->"General::sntx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<# &\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::sntx"],

Cell[BoxData[
    \(#1 &\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::sntx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sntxb", "ObjectNameWarningMessages",
  CellTags->"General::sntxb"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sntxb\"\>"}], \(\(:\)\(\ \)\), "\<\"Expression cannot \
begin with \\\"`1`\\\".`4`\"\>"}]], "Message",
  CellLabel->"From In[81]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::sntxb"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by a syntax error in which the first  \
character in the input is not part of any valid syntax.\n\[FilledSmallSquare] \
 This message is used for input in ",
  StyleBox["InputForm", "MR"],
  " format."
}], "Notes",
  CellTags->"General::sntxb"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sntxb"],

Cell[TextData[{
  "An error occurs when processing this ",
  StyleBox["InputForm", "MR"],
  " input because a closing parenthesis cannot be used as the first character \
 in an expression."
}], "Text",
  CellTags->"General::sntxb"],

Cell[CellGroupData[{

Cell[")+2", "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sntxb"],

Cell["Syntax::sntxb: Expression cannot begin with \")\".", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::sntxb"]
}, Open  ]],

Cell[TextData[{
  "This shows syntactically valid input in ",
  StyleBox["InputForm", "MR"],
  "."
}], "Text",
  CellTags->"General::sntxb"],

Cell[CellGroupData[{

Cell["(2)+2", "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sntxb"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::sntxb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sntxc", "ObjectNameWarningMessages",
  CellTags->"General::sntxc"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sntxc\"\>"}], \(\(:\)\(\ \)\), "\<\"The comment starting \
at \\\"`1`\\\" has no closing \\\"*)\\\".`4`\"\>"}]], "Message",
  CellLabel->"From In[81]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::sntxc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by a syntax error involving an unclosed  \
comment delimiter.\n\[FilledSmallSquare] This message is used for input in ",
  StyleBox["InputForm", "MR"],
  " format."
}], "Notes",
  CellTags->"General::sntxc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sntxc"],

Cell[TextData[{
  "An error occurs in this ",
  StyleBox["InputForm", "MR"],
  " input because of the unclosed comment delimiter."
}], "Text",
  CellTags->"General::sntxc"],

Cell[CellGroupData[{

Cell["2 + 2 (* This is a comment", "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sntxc"],

Cell["\<\
Syntax::sntxc: 
   The comment starting at \"2 + 2 (* This is a comment\"
                                   ^
     has no closing \"*)\".\
\>", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::sntxc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sntxf", "ObjectNameWarningMessages",
  CellTags->"General::sntxf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sntxf\"\>"}], \(\(:\)\(\ \)\), "\<\"\\\"`1`\\\" cannot be \
followed by \\\"`2`\\\".`4`\"\>"}]], "Message",
  CellLabel->"From In[81]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::sntxf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by a syntax error in ",
  StyleBox["InputForm", "MR"],
  " input."
}], "Notes",
  CellTags->"General::sntxf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sntxf"],

Cell["\<\
An error occurs in this InputForm input because the syntax is not \
valid.\
\>", "Text",
  CellTags->"General::sntxf"],

Cell[CellGroupData[{

Cell["2 + []", "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sntxf"],

Cell["Syntax::sntxf: \"2 + \" cannot be followed by \"[]\".", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::sntxf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sntxi", "ObjectNameWarningMessages",
  CellTags->"General::sntxi"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"sntxi\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{\(Incomplete\ expression\), ";", " ", 
        RowBox[{"more", " ", "input", " ", "is", " ", 
          RowBox[{"needed", ".", 
            StyleBox["n",
              "TI"]}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::sntxi"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by a syntax error in ",
  StyleBox["InputForm", "MR"],
  " input."
}], "Notes",
  CellTags->"General::sntxi"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sntxi"],

Cell[TextData[{
  "An error occurs in this ",
  StyleBox["InputForm", "MR"],
  " input because the expression is not complete."
}], "Text",
  CellTags->"General::sntxi"],

Cell[CellGroupData[{

Cell["2+", "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sntxi"],

Cell["Syntax::sntxi: Incomplete expression; more input is needed.", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::sntxi"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sntxpi", "ObjectNameWarningMessages",
  CellTags->"General::sntxpi"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"sntxpi\"\>"}], \(\(:\)\(\ \)\), "Incomplete", " ",
       "expression", " ", "in", " ", "result", " ", "of", " ", 
      RowBox[{"$PreRead", ".", 
        StyleBox["n",
          "TI"]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::sntxpi"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the result of applying the value of ",
  StyleBox["$PreRead", "MR"],
  " to ",
  StyleBox["InputForm", "MR"],
  " input is not a syntactically correct expression."
}], "Notes",
  CellTags->"General::sntxpi"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sntxpi"],

Cell[TextData[{
  "An error occurs in this ",
  StyleBox["InputForm", "MR"],
  " input because the value of ",
  StyleBox["$PreRead", "MR"],
  " gives syntactically incomplete input."
}], "Text",
  CellTags->"General::sntxpi"],

Cell[CellGroupData[{

Cell["$PreRead = (If[StringMatchQ[#, \"*2*\"], \"2 + \", #] &)", "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sntxpi"],

Cell[BoxData[
    \(If[StringMatchQ[#1, "*2*"], "2 + ", #1] &\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::sntxpi"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2 + 2", "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::sntxpi"],

Cell["Syntax::sntxpi: Incomplete expression in result of $PreRead.", "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::sntxpi"]
}, Open  ]],

Cell[TextData[{
  "Reset the value of ",
  StyleBox["$PreRead", "MR"],
  "."
}], "Text",
  CellTags->"General::sntxpi"],

Cell["Unset[$PreRead]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::sntxpi"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sntxpr", "ObjectNameWarningMessages",
  CellTags->"General::sntxpr"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sntxpr\"\>"}], \(\(:\)\(\ \)\), \(Syntax\ error\ in\ \
result\ of\ \(\($PreRead\)\(.\)\)\)}]], "Message",
  CellTags->"General::sntxpr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the result of applying the value of ",
  StyleBox["$PreRead", "MR"],
  " to ",
  StyleBox["InputForm", "MR"],
  " input is not a syntactically corrrect expression."
}], "Notes",
  CellTags->"General::sntxpr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sntxpr"],

Cell[TextData[{
  "An error occurs in this ",
  StyleBox["InputForm", "MR"],
  " input because the value of ",
  StyleBox["$PreRead", "MR"],
  " gives input that is not syntactically valid."
}], "Text",
  CellTags->"General::sntxpr"],

Cell[CellGroupData[{

Cell["$PreRead = (If[StringMatchQ[#, \"*2*\"], \"2 () 2\", #] &)", "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sntxpr"],

Cell[BoxData[
    \(If[StringMatchQ[#1, "*2*"], "2 () 2", #1] &\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::sntxpr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["2 + 2", "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::sntxpr"],

Cell[BoxData[
    \(Syntax::"sntxpr" \(\(:\)\(\ \)\) 
      "Syntax error in result of $PreRead."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::sntxpr"],

Cell["Syntax::sntxf: \"2 (\" cannot be followed by \") 2\".", "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::sntxpr"]
}, Open  ]],

Cell[TextData[{
  "Reset the value of ",
  StyleBox["$PreRead", "MR"],
  "."
}], "Text",
  CellTags->"General::sntxpr"],

Cell["Unset[$PreRead]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::sntxpr"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sntxq", "ObjectNameWarningMessages",
  CellTags->"General::sntxq"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sntxq\"\>"}], \(\(:\)\(\ \)\), "\<\"The string starting at \
\\\"`1`\\\" has no closing quote.`4`\"\>"}]], "Message",
  CellLabel->"From In[81]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::sntxq"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by a syntax error involving mismatched  \
quote marks in ",
  StyleBox["InputForm", "MR"],
  " input."
}], "Notes",
  CellTags->"General::sntxq"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sntxq"],

Cell[TextData[{
  "An error occurs in this ",
  StyleBox["InputForm", "MR"],
  " input because the string has no closing quote mark."
}], "Text",
  CellTags->"General::sntxq"],

Cell[CellGroupData[{

Cell["\"this is a string", "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sntxq"],

Cell["\<\
Syntax::sntxq: 
   The string starting at \"\"this is a string\" has no closing quote.
                           ^\
\>", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::sntxq"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::spell", "ObjectNameWarningMessages",
  CellTags->"General::spell"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"spell\"\>"}], \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"`1`\\\" is similar to existing symbols \
`2`.\"\>"}]], "Message",
  CellLabel->"From In[82]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::spell"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the name of a new symbol is similar to \
 the name of an existing symbol.\n\[FilledSmallSquare] This message is a  \
warning only and does not necessarily indicate an error.\n\
\[FilledSmallSquare] You can disable this message by evaluating ",
  StyleBox["Off[General::spell]", "MR"],
  "."
}], "Notes",
  CellTags->"General::spell"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::spell"],

Cell["\<\
Warning messages are generated in these examples because the names \
in the input are very similar.\
\>", "Text",
  CellTags->"General::spell"],

Cell[CellGroupData[{

Cell[BoxData[
    \(xvariable = 2; yvariable = 3\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::spell"],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(yvariable\)\" is \
similar to existing symbol \"\!\(xvariable\)\"."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::spell"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::spell"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Xvariable + Yvariable\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::spell"],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(Xvariable\)\" is \
similar to existing symbol \"\!\(xvariable\)\"."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::spell"],

Cell[BoxData[
    \(General::"spell" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(Yvariable\)\" is \
similar to existing symbols \!\({Xvariable, yvariable}\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::spell"],

Cell[BoxData[
    \(Xvariable + Yvariable\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::spell"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::spell1", "ObjectNameWarningMessages",
  CellTags->"General::spell1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"spell1\"\>"}], \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"`1`\\\" is similar to existing symbol \\\"`2`\\\".\
\"\>"}]], "Message",
  CellLabel->"From In[82]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::spell1"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the name of a new symbol is similar to \
 the name of an existing symbol.\n\[FilledSmallSquare] This message is a  \
warning only and does not necessarily indicate an error.\n\
\[FilledSmallSquare] You can disable this message by evaluating ",
  StyleBox["Off[General::spell1]", "MR"],
  "."
}], "Notes",
  CellTags->"General::spell1"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::spell1"],

Cell["\<\
A warning is generated in this example because the names in the \
input are very similar.\
\>", "Text",
  CellTags->"General::spell1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(xvariable = 2; yvariable = 3\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::spell1"],

Cell[BoxData[
    \(General::"spell1" \(\(:\)\(\ \)\) 
      "Possible spelling error: new symbol name \"\!\(yvariable\)\" is \
similar to existing symbol \"\!\(xvariable\)\"."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::spell1"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::spell1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ssle", "ObjectNameWarningMessages",
  CellTags->"General::ssle"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ssle\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{"Symbol", ",", " ", "string", ",", " ", 
        RowBox[{
        "or", " ", \(HoldPattern[symbol]\), " ", "expected", " ", "at", " ", 
          "position", " ", 
          StyleBox["n",
            "TI"], " ", "in", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ssle"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
does not have the form indicated in the message.\
\>", "Notes",
  CellTags->"General::ssle"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::ssle"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["Context", "MR"],
  " is a list rather than a symbol."
}], "Text",
  CellTags->"General::ssle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Context[{Integrate}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::ssle"],

Cell[BoxData[
    \(Context::"ssle" \(\(:\)\(\ \)\) 
      "Symbol, string, or HoldPattern[symbol] expected at position \!\(1\) in \
\!\(Context[\(\({Integrate}\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::ssle"],

Cell[BoxData[
    \(Context[{Integrate}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::ssle"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["Context", "MR"],
  "."
}], "Text",
  CellTags->"General::ssle"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Context[Integrate]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::ssle"],

Cell[BoxData[
    \("System`"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::ssle"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::tsntxi", "ObjectNameWarningMessages",
  CellTags->"General::tsntxi"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"tsntxi\"\>"}], \(\(:\)\(\ \)\), "\<\"\\\"`1`\\\" is \
incomplete; more input is needed.`4`\"\>"}]], "Message",
  CellLabel->"From In[82]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::tsntxi"],

Cell["\<\
\[FilledSmallSquare] Generated by incomplete typeset input.\
\>", \
"Notes",
  CellTags->"General::tsntxi"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::tsntxi"],

Cell["\<\
An error occurs in this example because the input is not \
complete.\
\>", "Text",
  CellTags->"General::tsntxi"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1 + \((2 + 2)\) + \)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::tsntxi"],

Cell[BoxData[
    \(Syntax::"tsntxi" \(\(:\)\(\ \)\) 
      "\"\!\(1 + \(\((2 + 2)\)\) +\)\" is incomplete; more input is needed.\!\
\(\"\"\)"\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::tsntxi"],

Cell[BoxData[
    StyleBox[
      ErrorBox[\(1 + \((2 + 2)\) + \)],
      ShowStringCharacters->True]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::tsntxi"]
}, Open  ]],

Cell["This shows syntactically valid typeset input.", "Text",
  CellTags->"General::tsntxi"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1 + \((2 + 2)\) + 3\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::tsntxi"],

Cell[BoxData[
    \(8\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::tsntxi"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
HorizontalForm::precd
VerticalForm::precd\
\>", "ObjectNameWarningMessages",
  CellTags->{"HorizontalForm::precd", "VerticalForm::precd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"precd\"\>"}], \(\(:\)\(\ \)\), "Precedence", " ", 
      "list", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "of", " ", "the", " ", "form", 
      " ", \(\({head, \ prec, \ assoc, \  ... }\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"HorizontalForm::precd", "VerticalForm::precd"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an invalid argument in ",
  StyleBox["HorizontalForm", "MR"],
  " or ",
  StyleBox["VerticalForm", "MR"],
  " is encountered when output is formatted.\n\[FilledSmallSquare] ",
  StyleBox["HorizontalForm", "MR"],
  " and ",
  StyleBox["VerticalForm", "MR"],
  " are used internally to format non-typeset output and are not intended to  \
be used directly.\n\[FilledSmallSquare] If you see this message in an example \
where it is not expected, please contact Technical Support."
}], "Notes",
  CellTags->{"HorizontalForm::precd", "VerticalForm::precd"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Infix::group
Postfix::group
Prefix::group\
\>", "ObjectNameWarningMessages",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"group\"\>"}], \(\(:\)\(\ \)\), "Grouping", " ", 
        "specification", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "NonAssociative"}], ",", " ", 
      "None", ",", " ", "Left", ",", 
      " ", \(or\ \(\(Right\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the fourth argument in the indicated  \
function is not one of the symbols included in the message.\n\
\[FilledSmallSquare] The fourth argument in ",
  StyleBox["Infix", "MR"],
  ", ",
  StyleBox["Postfix", "MR"],
  ", and ",
  StyleBox["Prefix", "MR"],
  " is an associativity specification used for parenthesizing the  \
expression."
}], "Notes",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid associativity specification in ",
  StyleBox["Infix", "MR"],
  "."
}], "Text",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(OutputForm[
      Infix[{17, Infix[{11, 5}, "\<+|-\>", 1000, Left]}, "\<+|-\>", 1000, 
        Automatic]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],

Cell[BoxData[
    \(Infix::"group" \(\(:\)\(\ \)\) 
      "Grouping specification \!\(Automatic\) is not NonAssociative, None, \
Left, or Right."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],

Cell[OutputFormData["\<\
Infix[{17, Infix[{11, 5}, \"+|-\", 1000, Left]}, \
\"+|-\", 1000, Automatic]\
\>", "\<\
Infix[{17, (11)+|-(5)}, +|-, 1000, \
Automatic]\
\>"], "Output",
  CellLabel->"Out[1]//OutputForm=",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid associativity specification in ",
  StyleBox["Infix", "MR"],
  "."
}], "Text",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(OutputForm[
      Infix[{17, Infix[{11, 5}, "\<+|-\>", 1000, Left]}, "\<+|-\>", 1000, 
        Left]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],

Cell[OutputFormData["\<\
Infix[{17, Infix[{11, 5}, \"+|-\", 1000, Left]}, \
\"+|-\", 1000, Left]\
\>", "\<\
(17)+|-((11)+|-(5))\
\>"], "Output",
  CellLabel->"Out[2]//OutputForm=",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrate::intmul", "ObjectNameWarningMessages",
  CellTags->"Integrate::intmul"],

Cell[BoxData[
    \(Integrate::"intmul" \(\(:\)\(\ \)\) 
      "The integral operator `1` cannot be nested directly inside of the \
integral operator `2`. Only identical integral operators can be nested inside \
each other without parentheses."\)], "Message",
  CellLabel->"From In[82]:=",
  CellTags->"Integrate::intmul"],

Cell["\<\
\[FilledSmallSquare] Generated for invalid typeset expressions \
involving nested integral operators of different types.
\[FilledSmallSquare] Integration operators include \[Integral], \
\[ContourIntegral], \[DoubleContourIntegral], \[ClockwiseContourIntegral], \
and \[CounterClockwiseContourIntegral].\
\>", "Notes",
  CellTags->"Integrate::intmul"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Integrate::intmul"],

Cell["\<\
An error occurs in this example because the contour integral \
operator is nested within an integral operator.\
\>", "Text",
  CellTags->"Integrate::intmul"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      StyleBox["\[Integral]",
        ScriptLevel->0], 
      RowBox[{
        StyleBox["\[ContourIntegral]",
          ScriptLevel->0], 
        RowBox[{\(f[x, y]\), 
          StyleBox["\[ThinSpace]",
            ScriptLevel->0], 
          StyleBox[\(\[DifferentialD]x\),
            ScriptLevel->0], 
          StyleBox[\(\[DifferentialD]y\),
            ScriptLevel->0]}]}]}]], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::intmul"],

Cell[BoxData[
    \(Integrate::"intmul" \(\(:\)\(\ \)\) 
      "The integral operator \!\(\"\\[ContourIntegral]\"\) cannot be nested \
directly inside of the integral operator \!\(\"\\[Integral]\"\). Only \
identical integral operators can be nested inside each other without \
parentheses."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Integrate::intmul"],

Cell[BoxData[
    StyleBox[
      ErrorBox[\(\[Integral]\(\[ContourIntegral]f[x, 
                y] \[DifferentialD]x \[DifferentialD]y\)\)],
      ShowStringCharacters->True]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Integrate::intmul"]
}, Open  ]],

Cell["Parentheses can be used if this input was intentional.", "Text",
  CellTags->"Integrate::intmul"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      StyleBox["\[Integral]",
        ScriptLevel->0], 
      RowBox[{
        RowBox[{
          StyleBox["(",
            ScriptLevel->0], 
          RowBox[{
            StyleBox["\[ContourIntegral]",
              ScriptLevel->0], 
            RowBox[{\(f[x, y]\), 
              StyleBox["\[ThinSpace]",
                ScriptLevel->0], 
              StyleBox[\(\[DifferentialD]x\),
                ScriptLevel->0]}]}], ")"}], 
        StyleBox[\(\[DifferentialD]y\),
          ScriptLevel->0]}]}]], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::intmul"],

Cell[BoxData[
    \(\[Integral]ContourIntegral[f[x, y], x] \[DifferentialD]y\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Integrate::intmul"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrate::novar", "ObjectNameWarningMessages",
  CellTags->"Integrate::novar"],

Cell[BoxData[
    \(Integrate::"novar" \(\(:\)\(\ \)\) 
      "`1` cannot be interpreted. Integrals are entered in the form \!\(\
\[Integral]f\[DifferentialD]x\), where \!\(\[DifferentialD]\) is entered as \
\[EscapeKey]dd\[EscapeKey]."\)], "Message",
  CellLabel->"From In[83]:=",
  CellTags->"Integrate::novar"],

Cell["\<\
\[FilledSmallSquare] Generated when a typeset integral operator is \
encountered without a valid specification of the variable of \
integration.\
\>", "Notes",
  CellTags->"Integrate::novar"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Integrate::novar"],

Cell["\<\
An error occurs in this example because the variable of integration \
is omitted.\
\>", "Text",
  CellTags->"Integrate::novar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\[DifferentialD]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::novar"],

Cell[BoxData[
    \(Integrate::"novar" \(\(:\)\(\ \)\) 
      "\!\(\[Integral] \[DifferentialD]\) cannot be interpreted. Integrals \
are entered in the form \!\(\[Integral]f\[DifferentialD]x\), where \!\(\
\[DifferentialD]\) is entered as \[EscapeKey]dd\[EscapeKey]."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Integrate::novar"],

Cell[BoxData[
    StyleBox[
      ErrorBox[\(\[Integral]\[DifferentialD]\)],
      ShowStringCharacters->True]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Integrate::novar"]
}, Open  ]],

Cell["This shows a valid typeset specification of an integral.", "Text",
  CellTags->"Integrate::novar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\[DifferentialD]x\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::novar"],

Cell[BoxData[
    \(x\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Integrate::novar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrate::wrongd", "ObjectNameWarningMessages",
  CellTags->"Integrate::wrongd"],

Cell[BoxData[
    \(Integrate::"wrongd" \(\(:\)\(\ \)\) 
      "`1` cannot be interpreted. Integrals use the differential d (entered \
as \[EscapeKey]dd\[EscapeKey]) not an ordinary keyboard d."\)], "Message",
  CellLabel->"From In[83]:=",
  CellTags->"Integrate::wrongd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the character ",
  StyleBox["d", "MR"],
  " is used rather than \[DifferentialD] in a typeset specification of an  \
integral."
}], "Notes",
  CellTags->"Integrate::wrongd"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Integrate::wrongd"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["d", "MR"],
  " is encountered where \[DifferentialD] is expected."
}], "Text",
  CellTags->"Integrate::wrongd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]Cos[x] d\ x\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::wrongd"],

Cell[BoxData[
    \(Integrate::"wrongd" \(\(:\)\(\ \)\) 
      "\!\(\[Integral] \(\(\(\(Cos[x]\)\) dx\)\)\) cannot be interpreted. \
Integrals use the differential d (entered as \[EscapeKey]dd\[EscapeKey]) not \
an ordinary keyboard d."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Integrate::wrongd"],

Cell[BoxData[
    StyleBox[
      ErrorBox[\(\[Integral]Cos[x] d  x\)],
      ShowStringCharacters->True]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Integrate::wrongd"]
}, Open  ]],

Cell["This shows a valid typeset specification of an integral.", "Text",
  CellTags->"Integrate::wrongd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]Cos[x] \[DifferentialD]x\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::wrongd"],

Cell[BoxData[
    \(Sin[x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Integrate::wrongd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::dblk", "ObjectNameWarningMessages",
  CellTags->"General::dblk"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"dblk\"\>"}], \(\(:\)\(\ \)\), \(Value\ for\ option\ \
DigitBlock\ should\ be\ a\ positive\ integer, \ Infinity, \ 
      or\ a\ pair\ of\ positive\ \(\(integers\)\(.\)\)\)}]], "Message",
  CellTags->"General::dblk"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["DigitBlock", "MR"],
  " option does not have the indicated form."
}], "Notes",
  CellTags->"General::dblk"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::dblk"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["DigitBlock", "MR"],
  " option."
}], "Text",
  CellTags->"General::dblk"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberForm[27515078183.951, 14, DigitBlock -> None, 
      ExponentFunction -> \((Null\  &)\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::dblk"],

Cell[BoxData[
    \(NumberForm::"dblk" \(\(:\)\(\ \)\) 
      "Value for option DigitBlock should be a positive integer, Infinity, or \
a pair of positive integers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::dblk"],

Cell[BoxData[
    TagBox[
      InterpretationBox["\<\"27515078183.951\"\>",
        27515078183.951,
        AutoDelete->True],
      (NumberForm[ #, 14, DigitBlock -> None, ExponentFunction -> (
        Null&)]&)]], "Output",
  CellLabel->"Out[1]//NumberForm=",
  CellTags->"General::dblk"]
}, Open  ]],

Cell[TextData[{
  "This shows valid option specifications in ",
  StyleBox["NumberForm", "MR"],
  "."
}], "Text",
  CellTags->"General::dblk"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberForm[27515078183.951, 14, DigitBlock -> 3, 
      ExponentFunction -> \((Null\  &)\)]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::dblk"],

Cell[BoxData[
    TagBox[
      InterpretationBox["\<\"27,515,078,183.951\"\>",
        27515078183.951,
        AutoDelete->True],
      (NumberForm[ #, 14, DigitBlock -> 3, ExponentFunction -> (
        Null&)]&)]], "Output",
  CellLabel->"Out[2]//NumberForm=",
  CellTags->"General::dblk"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NumberForm::sigz", "ObjectNameWarningMessages",
  CellTags->"NumberForm::sigz"],

Cell[BoxData[
    \(NumberForm::"sigz" \(\(:\)\(\ \)\) "\<In addition to the number of \
digits requested, one or more zeros will appear as placeholders.\>"\)], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NumberForm::sigz"],

Cell["\<\
\[FilledSmallSquare] Generated when the number of digits to be \
displayed exceeds the number of digits that are known to be numerically \
reliable.
\[FilledSmallSquare] This message is a warning about a potentially misleading \
display but does not necessarily indicate an error.\
\>", "Notes",
  CellTags->"NumberForm::sigz"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NumberForm::sigz"],

Cell[TextData[{
  "A warning is generated in this example because the first argument in ",
  StyleBox["NumberForm", "MR"],
  " is a machine number, which on this computer has fewer significant digits  \
than the number of digits shown in the display."
}], "Text",
  CellTags->"NumberForm::sigz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumberForm[2.77*^25, ExponentFunction -> \((Null &)\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NumberForm::sigz"],

Cell[BoxData[
    \(NumberForm::"sigz" \(\(:\)\(\ \)\) 
      "In addition to the number of digits requested, one or more zeros will \
appear as placeholders."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NumberForm::sigz"],

Cell[BoxData[
    TagBox[
      InterpretationBox["\<\"27700000000000000000000000.\"\>",
        2.7700000000000001*^+25,
        AutoDelete->True],
      (NumberForm[ #, ExponentFunction -> (Null&)]&)]], "Output",
  CellLabel->"Out[1]//NumberForm=",
  CellTags->"NumberForm::sigz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ParentForm::deflt", "ObjectNameWarningMessages",
  CellTags->"ParentForm::deflt"],

Cell[BoxData[
    RowBox[{\(ParentForm::"deflt"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \
\)\(ParentForm\)\(\ \)\(of\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ defined\ on\ \(\($BoxForms\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"ParentForm::deflt"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a rule is not found for an expression  \
in the indicated format and ",
  StyleBox["ParentForm", "MR"],
  " for that format is not found in the value of ",
  StyleBox["$BoxForms", "MR"],
  "."
}], "Notes",
  CellTags->"ParentForm::deflt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ParentForm::deflt"],

Cell[TextData[{
  "A warning message is generated in this example because ",
  StyleBox["ParentForm", "MR"],
  " for the indicated format has not been defined."
}], "Text",
  CellTags->"ParentForm::deflt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AppendTo[$BoxForms, NewForm]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ParentForm::deflt"],

Cell[BoxData[
    \({StandardForm, TraditionalForm, NewForm}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ParentForm::deflt"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MakeBoxes[2 + 2, NewForm]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ParentForm::deflt"],

Cell[BoxData[
    \(ParentForm::"deflt" \(\(:\)\(\ \)\) 
      "The ParentForm of \!\(ParentForm[NewForm]\) is not defined on \
$BoxForms."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ParentForm::deflt"],

Cell[BoxData[
    \(ParentForm::"deflt" \(\(:\)\(\ \)\) 
      "The ParentForm of \!\(ParentForm[NewForm]\) is not defined on \
$BoxForms."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ParentForm::deflt"],

Cell[BoxData[
    \(ParentForm::"deflt" \(\(:\)\(\ \)\) 
      "The ParentForm of \!\(ParentForm[NewForm]\) is not defined on \
$BoxForms."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ParentForm::deflt"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(ParentForm :: \"deflt\"\) will be suppressed \
during this calculation."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ParentForm::deflt"],

Cell[BoxData[
    \(RowBox[{"2", "+", "2"}]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ParentForm::deflt"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid ",
  StyleBox["ParentForm", "MR"],
  " specification for the new format."
}], "Text",
  CellTags->"ParentForm::deflt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParentForm[NewForm] ^= TraditionalForm\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"ParentForm::deflt"],

Cell[BoxData[
    \(TraditionalForm\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"ParentForm::deflt"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(MakeBoxes[2 + 2, NewForm]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"ParentForm::deflt"],

Cell[BoxData[
    \(RowBox[{"2", "+", "2"}]\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"ParentForm::deflt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Product::prodwarn", "ObjectNameWarningMessages",
  CellTags->"Product::prodwarn"],

Cell[BoxData[
    RowBox[{\(Product::"prodwarn"\), \(\(:\)\(\ \)\), \
\(\(\(Warning\)\(:\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(contains\ a\ capital\ pi; \ 
      use\ \[EscapeKey]prod\[EscapeKey]\ to\ enter\ a\ product\ \(\(sign\)\(.\
\)\)\)\)}]], "Message",
  CellTags->"Product::prodwarn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated in typeset input when a capital pi  \
character \[CapitalPi] is encountered where a product sign \[Product] is  \
expected.\n\[FilledSmallSquare] You can enter a product sign using  \
\[Backslash]",
  StyleBox["[Product]", "MR"],
  ", \[EscapeKey]prod\[EscapeKey], or by selecting the corresponding item  \
from a palette."
}], "Notes",
  CellTags->"Product::prodwarn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Product::prodwarn"],

Cell["\<\
A warning message is generated in this example because of an \
unexpected use of a capital pi character.\
\>", "Text",
  CellTags->"Product::prodwarn"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      StyleBox[\(\[CapitalPi]\+k\%5\),
        ScriptLevel->0], 
      StyleBox[" ",
        ScriptLevel->0], "k"}]], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Product::prodwarn"],

Cell[BoxData[
    \(Product::"prodwarn" \(\(:\)\(\ \)\) 
      "Warning: \!\(\[CapitalPi]\+k\%5\) contains a capital pi; use \
\[EscapeKey]prod\[EscapeKey] to enter a product sign."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Product::prodwarn"],

Cell[BoxData[
    \(k\ \[CapitalPi]\+k\%5\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Product::prodwarn"]
}, Open  ]],

Cell["This shows the expected notation for entering a product.", "Text",
  CellTags->"Product::prodwarn"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      StyleBox[\(\[Product]\+k\%5\),
        ScriptLevel->0], 
      StyleBox[" ",
        ScriptLevel->0], "k"}]], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Product::prodwarn"],

Cell[BoxData[
    \(120\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Product::prodwarn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Short::short", "ObjectNameWarningMessages",
  CellTags->"Short::short"],

Cell[BoxData[
    RowBox[{\(Short::"short"\), \(\(:\)\(\ \)\), \(\(Second\)\(\ \)\(argument\
\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ a\ positive\ real\ \(\(number\)\(.\)\)\)\
\)}]], "Message",
  CellTags->"Short::short"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Short", "MR"],
  " does not have the expected form."
}], "Notes",
  CellTags->"Short::short"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Short::short"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Short", "MR"],
  " is a list rather than a number."
}], "Text",
  CellTags->"Short::short"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Short[1, Table[Range[10], {10}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Short::short"],

Cell[BoxData[
    \(Short::"short" \(\(:\)\(\ \)\) 
      "Second argument \!\({\(\({1, 2, 3, 4, 5, 6, 7, 8, 9, 10}\)\), \(\(\
\[LeftSkeleton] 8 \[RightSkeleton]\)\), \(\({1, 2, 3, 4, 5, 6, 7, 8, 9, 10}\)\
\)}\) should be a positive real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Short::short"],

Cell[BoxData[
    \(Short[
      1, {{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 
          10}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 
          10}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 
          10}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 
          10}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 
          10}}]\)], "Output",
  CellLabel->"Out[1]//Short=",
  CellTags->"Short::short"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Short", "MR"],
  "."
}], "Text",
  CellTags->"Short::short"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Short[Table[Range[10], {10}], 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Short::short"],

Cell[BoxData[
    TagBox[\({{1, 2, 3, 4, 5, 6, 7, 8, 9, 
          10}, \[LeftSkeleton]8\[RightSkeleton], {1, 2, 3, 4, 5, 6, 7, 8, 9, 
          10}}\),
      (Short[ #, 1]&)]], "Output",
  CellLabel->"Out[2]//Short=",
  CellTags->"Short::short"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Splice::splicd", "ObjectNameWarningMessages",
  CellTags->"Splice::splicd"],

Cell[BoxData[
    RowBox[{\(Splice::"splicd"\), \(\(:\)\(\ \)\), \(\(Missing\)\(\ \)\(right\
\)\(\ \)\(delimiter\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "at", " ", "end", " ", "of", " ", "input", " ", "file", 
      " ", 
      RowBox[{
        StyleBox["f",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Splice::splicd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the input processed by ",
  StyleBox["Splice", "MR"],
  " includes mismatched delimiters."
}], "Notes",
  CellTags->"Splice::splicd"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Splice::splicd"],

Cell["\<\
An error occurs in this example because the input file does not \
include a closing delimiter.\
\>", "Text",
  CellTags->"Splice::splicd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{result}, \n\t
      Write["\<TEST.in\>", OutputForm["\<       y = <*Expand[(1+x)^3]\>"]]; 
      Close["\<TEST.in\>"]; 
      Splice["\<TEST.in\>", "\<TEST.out\>", FormatType -> FortranForm]; 
      result = Read["\<TEST.out\>", String]; \n\tClose["\<TEST.out\>"]; \n\t
      result\n]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Splice::splicd"],

Cell[BoxData[
    \(Splice::"splicd" \(\(:\)\(\ \)\) 
      "Missing right delimiter \!\(\"*>\"\) at end of input file \
\!\(\"TEST.in\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Splice::splicd"],

Cell[BoxData[
    \("       y = "\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Splice::splicd"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid input file for ",
  StyleBox["Splice", "MR"],
  "."
}], "Text",
  CellTags->"Splice::splicd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{result}, \n\t
      Write["\<TEST.in\>", OutputForm["\<       y = <*Expand[(1+x)^3]*>\>"]]; 
      Close["\<TEST.in\>"]; 
      Splice["\<TEST.in\>", "\<TEST.out\>", FormatType -> FortranForm]; 
      result = Read["\<TEST.out\>", String]; \n\tClose["\<TEST.out\>"]; \n\t
      result\n]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Splice::splicd"],

Cell[BoxData[
    \("       y = 1 + 3*x + 3*x**2 + x**3"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Splice::splicd"]
}, Open  ]],

Cell["Remove the test files.", "Text",
  CellTags->"Splice::splicd"],

Cell[BoxData[
    \(DeleteFile["\<TEST.in\>"]; DeleteFile["\<TEST.out\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Splice::splicd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Splice::splicf", "ObjectNameWarningMessages",
  CellTags->"Splice::splicf"],

Cell[BoxData[
    RowBox[{\(Splice::"splicf"\), \(\(:\)\(\ \)\), \(\(Cannot\)\(\ \)\(deduce\
\)\(\ \)\(output\)\(\ \)\(file\)\(\ \)\(name\)\(\ \)\(from\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Splice::splicf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Splice", "MR"],
  " is used without specifying the name of the output file and the name of  \
the input file is not of the form ",
  StyleBox["file", "MR",
    FontSlant->"Italic"],
  StyleBox[".m", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] The first argument in ",
  StyleBox["Splice", "MR"],
  " gives the name of the input file, and the optional second argument gives  \
the name of the output file."
}], "Notes",
  CellTags->"Splice::splicf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Splice::splicf"],

Cell["\<\
An error occurs in this example because the name of the input file \
does not have the expected form.\
\>", "Text",
  CellTags->"Splice::splicf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{result}, \n\t
      Write["\<TEST.f\>", 
        OutputForm["\<       y = <*Expand[(1+x)^3]*>\>"]]; \n\t
      Close["\<TEST.f\>"]; \n\tSplice["\<TEST.f\>"]; \n\t
      result = Read["\<TEST.f\>", String]; \n\tClose["\<TEST.f\>"]; \n\t
      result\n\t]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Splice::splicf"],

Cell[BoxData[
    \(Splice::"splicf" \(\(:\)\(\ \)\) 
      "Cannot deduce output file name from \!\(\"TEST.f\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Splice::splicf"],

Cell[BoxData[
    \("       y = <*Expand[(1+x)^3]*>"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Splice::splicf"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Splice", "MR"],
  "."
}], "Text",
  CellTags->"Splice::splicf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{result}, \n\t
      Write["\<TEST.mf\>", 
        OutputForm["\<       y = <*Expand[(1+x)^3]*>\>"]]; \n\t
      Close["\<TEST.mf\>"]; \n\tSplice["\<TEST.mf\>"]; \n\t
      result = Read["\<TEST.f\>", String]; \n\tClose["\<TEST.f\>"]; \n\t
      result\n\t]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Splice::splicf"],

Cell[BoxData[
    \("       y = 1 + 3*x + 3*x**2 + x**3"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Splice::splicf"]
}, Open  ]],

Cell["Remove the test files.", "Text",
  CellTags->"Splice::splicf"],

Cell[BoxData[
    \(DeleteFile["\<TEST.mf\>"]; DeleteFile["\<TEST.f\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Splice::splicf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Splice::splict", "ObjectNameWarningMessages",
  CellTags->"Splice::splict"],

Cell[BoxData[
    RowBox[{\(Splice::"splict"\), \(\(:\)\(\ \)\), \(\(Cannot\)\(\ \)\(deduce\
\)\(\ \)\(output\)\(\ \)\(type\)\(\ \)\(from\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Splice::splict"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["Splice", "MR"],
  " is not a file name of the form ",
  StyleBox["file", "MR",
    FontSlant->"Italic"],
  StyleBox[".m", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  " and the value of the ",
  StyleBox["FormatType", "MR"],
  " option is not specified."
}], "Notes",
  CellTags->"Splice::splict"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Splice::splict"],

Cell[TextData[{
  "An error occurs in this example because the file names do not match the  \
forms that ",
  StyleBox["Splice", "MR"],
  " is designed to recognize automatically."
}], "Text",
  CellTags->"Splice::splict"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{result}, \n\t
      Write["\<TEST.in\>", 
        OutputForm["\<       y = <*Expand[(1+x)^3]*>\>"]]; \n\t
      Close["\<TEST.in\>"]; \n\tSplice["\<TEST.in\>", "\<TEST.out\>"]; \n\t
      result = Read["\<TEST.out\>", String]; \n\tClose["\<TEST.out\>"]; \n\t
      result\n\t]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Splice::splict"],

Cell[BoxData[
    \(Splice::"splict" \(\(:\)\(\ \)\) 
      "Cannot deduce output type from \!\(\"TEST.in\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Splice::splict"],

Cell[BoxData[
    \(Read::"openx" \(\(:\)\(\ \)\) 
      "\!\(\"TEST.out\"\) is not open."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Splice::splict"],

Cell[BoxData[
    \(General::"openx" \(\(:\)\(\ \)\) 
      "\!\(\"TEST.out\"\) is not open."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Splice::splict"],

Cell[BoxData[
    \(Read["TEST.out", String]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Splice::splict"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid format type specification in ",
  StyleBox["Splice", "MR"],
  "."
}], "Text",
  CellTags->"Splice::splict"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{result}, \n\t
      Write["\<TEST.in\>", 
        OutputForm["\<       y = <*Expand[(1+x)^3]*>\>"]]; \n\t
      Close["\<TEST.in\>"]; \n\t
      Splice["\<TEST.in\>", "\<TEST.out\>", FormatType -> FortranForm]; \n\t
      result = Read["\<TEST.out\>", String]; \n\tClose["\<TEST.out\>"]; \n\t
      result\n\t]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Splice::splict"],

Cell[BoxData[
    \("       y = 1 + 3*x + 3*x**2 + x**3"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Splice::splict"]
}, Open  ]],

Cell["Remove the test files.", "Text",
  CellTags->"Splice::splict"],

Cell[BoxData[
    \(DeleteFile["\<TEST.in\>"]; DeleteFile["\<TEST.out\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Splice::splict"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Splice::splicx", "ObjectNameWarningMessages",
  CellTags->"Splice::splicx"],

Cell[BoxData[
    RowBox[{\(Splice::"splicx"\), \(\(:\)\(\ \)\), \(\(Syntax\)\(\ \
\)\(error\)\(\ \)\(in\)\(\ \)\(Mathematica\)\(\ \)\(input\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Splice::splicx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the expressions to be translated by ",
  StyleBox["Splice", "MR"],
  " are not valid ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " input."
}], "Notes",
  CellTags->"Splice::splicx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Splice::splicx"],

Cell[TextData[{
  "An error occurs in this example because the expression between the ",
  StyleBox["Splice", "MR"],
  " delimiters in the input file does not have a closing bracket."
}], "Text",
  CellTags->"Splice::splicx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{result}, \n\t
      Write["\<TEST.in\>", OutputForm["\<       y = <*Expand[(1+x)^3*>\>"]]; 
      Close["\<TEST.in\>"]; 
      Splice["\<TEST.in\>", "\<TEST.out\>", FormatType -> FortranForm]; 
      result = Read["\<TEST.out\>", String]; \n\tClose["\<TEST.out\>"]; \n\t
      result\n]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Splice::splicx"],

Cell[BoxData[
    \(Splice::"splicx" \(\(:\)\(\ \)\) 
      "Syntax error in Mathematica input \!\(\"Expand[(1+x)^3\"\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Splice::splicx"],

Cell[BoxData[
    \("       y = "\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Splice::splicx"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid input file for ",
  StyleBox["Splice", "MR"],
  "."
}], "Text",
  CellTags->"Splice::splicx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{result}, \n\t
      Write["\<TEST.in\>", OutputForm["\<       y = <*Expand[(1+x)^3]*>\>"]]; 
      Close["\<TEST.in\>"]; 
      Splice["\<TEST.in\>", "\<TEST.out\>", FormatType -> FortranForm]; 
      result = Read["\<TEST.out\>", String]; \n\tClose["\<TEST.out\>"]; \n\t
      result\n]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Splice::splicx"],

Cell[BoxData[
    \("       y = 1 + 3*x + 3*x**2 + x**3"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Splice::splicx"]
}, Open  ]],

Cell["Remove the test files.", "Text",
  CellTags->"Splice::splicx"],

Cell[BoxData[
    \(DeleteFile["\<TEST.in\>"]; DeleteFile["\<TEST.out\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Splice::splicx"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringForm::sfr", "ObjectNameWarningMessages",
  CellTags->"StringForm::sfr"],

Cell[BoxData[
    \(StringForm::"sfr" \(\(:\)\(\ \)\) 
      "Item `1` requested in \"`3`\" out of range; `2` items available."\)], \
"Message",
  CellLabel->"From In[83]:=",
  CellTags->"StringForm::sfr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["StringForm", "MR"],
  " is used with an insufficient number of arguments to fill the positions  \
specified in the control string.\n\[FilledSmallSquare] Since ",
  StyleBox["StringForm", "MR"],
  " is used for generating messages, this error can occur when there is a  \
corresponding error in the text of a message."
}], "Notes",
  CellTags->"StringForm::sfr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"StringForm::sfr"],

Cell["\<\
An error occurs in this example because the control string \
specifies three positions to be filled and only two expressions are \
given.\
\>", "Text",
  CellTags->"StringForm::sfr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringForm["\<x1 = `1`; x2 = `2`; x3 = `3`\>", 5, 7]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"StringForm::sfr"],

Cell[BoxData[
    \(StringForm::"sfr" \(\(:\)\(\ \)\) 
      "Item \!\(3\) requested in \"\!\(\"x1 = `1`; x2 = `2`; x3 = `3`\"\)\" \
out of range; \!\(2\) items available."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"StringForm::sfr"],

Cell[BoxData[
    InterpretationBox["\<\"x1 = \\!\\(5\\); x2 = \\!\\(7\\); x3 = `3`\"\>",
      StringForm[ "x1 = `1`; x2 = `2`; x3 = `3`", 5, 7],
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"StringForm::sfr"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["StringForm", "MR"],
  "."
}], "Text",
  CellTags->"StringForm::sfr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringForm["\<x1 = `1`; x2 = `2`; x3 = `3`\>", 5, 7, 9]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"StringForm::sfr"],

Cell[BoxData[
    InterpretationBox["\<\"x1 = \\!\\(5\\); x2 = \\!\\(7\\); x3 = \
\\!\\(9\\)\"\>",
      StringForm[ "x1 = `1`; x2 = `2`; x3 = `3`", 5, 7, 9],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"StringForm::sfr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Subscripted::subn", "ObjectNameWarningMessages",
  CellTags->"Subscripted::subn"],

Cell[BoxData[
    RowBox[{\(Subscripted::"subn"\), \(\(:\)\(\ \)\), \(\(Subscripting\)\(\ \
\)\(specification\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ of\ the\ form\ n\ or\ \(\({n1, \ 
            n2}\)\(.\)\)\)\)}]], "Message",
  CellTags->"Subscripted::subn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Subscripted", "MR"],
  " is not an integer or a list."
}], "Notes",
  CellTags->"Subscripted::subn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Subscripted::subn"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Subscripted", "MR"],
  " does not have the expected form."
}], "Text",
  CellTags->"Subscripted::subn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Subscripted[{2, 3}, C[1, 2, 3, 4, 5]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Subscripted::subn"],

Cell[BoxData[
    \(Subscripted::"subn" \(\(:\)\(\ \)\) 
      "Subscripting specification \!\(C[\(\(1, 2, 3, 4, 5\)\)]\) is not of \
the form n or {n1, n2}."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Subscripted::subn"],

Cell[BoxData[
    \(Subscripted[{2, 3}, C[1, 2, 3, 4, 5]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Subscripted::subn"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Subscripted", "MR"],
  "."
}], "Text",
  CellTags->"Subscripted::subn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Subscripted[C[1, 2, 3, 4, 5], {2, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Subscripted::subn"],

Cell[BoxData[
    InterpretationBox[\(C\_\(2, 3\)[1, 4, 5]\),
      Subscripted[ 
        C[ 1, 2, 3, 4, 5], {2, 3}],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Subscripted::subn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Subscripted::subv", "ObjectNameWarningMessages",
  CellTags->"Subscripted::subv"],

Cell[BoxData[
    \(Subscripted::"subv" \(\(:\)\(\ \)\) \(Specifications\ for\ superscripts\
\ and\ subscripts\ \(\(overlap\)\(.\)\)\)\)], "Message",
  CellTags->"Subscripted::subv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the positions specified in the second  \
argument of ",
  StyleBox["Subscripted", "MR"],
  " overlap with the positions specified in the third argument.\n\
\[FilledSmallSquare] The second argument in ",
  StyleBox["Subscripted", "MR"],
  " identifies elements to be formatted as subscripts, and the third argument \
 identities elements to be formated as superscripts."
}], "Notes",
  CellTags->"Subscripted::subv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Subscripted::subv"],

Cell[TextData[{
  "An error occurs in this example because the second and third arguments in  \
",
  StyleBox["Subscripted", "MR"],
  " give overlapping position specifications."
}], "Text",
  CellTags->"Subscripted::subv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Subscripted[C[1, 2, 3, 4, 5], {2, 3}, {3, 4}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Subscripted::subv"],

Cell[BoxData[
    \(Subscripted::"subv" \(\(:\)\(\ \)\) 
      "Specifications for superscripts and subscripts overlap."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"Subscripted::subv"],

Cell[BoxData[
    InterpretationBox[\(C\_\(2, 3\)\%4[1, 5]\),
      Subscripted[ 
        C[ 1, 2, 3, 4, 5], {2, 3}, {3, 4}],
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Subscripted::subv"]
}, Open  ]],

Cell[TextData[{
  "This shows valid subscript and superscript specifications using ",
  StyleBox["Subscripted", "MR"],
  "."
}], "Text",
  CellTags->"Subscripted::subv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Subscripted[C[1, 2, 3, 4, 5], {2, 3}, {4, 5}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Subscripted::subv"],

Cell[BoxData[
    InterpretationBox[\(C\_\(2, 3\)\%\(4, 5\)[1]\),
      Subscripted[ 
        C[ 1, 2, 3, 4, 5], {2, 3}, {4, 5}],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Subscripted::subv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Subscripted::subx", "ObjectNameWarningMessages",
  CellTags->"Subscripted::subx"],

Cell[BoxData[
    RowBox[{\(Subscripted::"subx"\), \(\(:\)\(\ \)\), "Positions", " ", 
      "specified", " ", "by", " ", 
      StyleBox["spec",
        "TI"], " ", "are", " ", "not", " ", "available", " ", "in", " ", 
      "expression", " ", "of", " ", "length", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Subscripted::subx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the positions specified in the second  \
or third argument of ",
  StyleBox["Subscripted", "MR"],
  " are not available in the expression in the first argument.\n\
\[FilledSmallSquare] The second argument in ",
  StyleBox["Subscripted", "MR"],
  " identifies the elements in the first argument that should be formatted as \
 subscripts and the third argument identifies the elements that should be  \
formatted as superscripts."
}], "Notes",
  CellTags->"Subscripted::subx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Subscripted::subx"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Subscripted", "MR"],
  " specifies positions that are not available in the first argument."
}], "Text",
  CellTags->"Subscripted::subx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Subscripted[C[1, 2, 3], {2, 9}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Subscripted::subx"],

Cell[BoxData[
    \(Subscripted::"subx" \(\(:\)\(\ \)\) 
      "Positions specified by \!\({2, 9}\) are not available in expression of \
length \!\(3\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Subscripted::subx"],

Cell[BoxData[
    InterpretationBox[\(C\_\(2, 3\)[1]\),
      Subscripted[ 
        C[ 1, 2, 3], {2, 9}],
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Subscripted::subx"]
}, Open  ]],

Cell["\<\
This shows a valid subscript specification for this \
expression.\
\>", "Text",
  CellTags->"Subscripted::subx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Subscripted[C[1, 2, 3], {2, \(-1\)}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Subscripted::subx"],

Cell[BoxData[
    InterpretationBox[\(C\_\(2, 3\)[1]\),
      Subscripted[ 
        C[ 1, 2, 3], {2, -1}],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Subscripted::subx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sum::sumwarn", "ObjectNameWarningMessages",
  CellTags->"Sum::sumwarn"],

Cell[BoxData[
    RowBox[{\(Sum::"sumwarn"\), \(\(:\)\(\ \)\), \(\(\(Warning\)\(:\)\)\(\ \)\
\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(contains\ a\ capital\ sigma; \ 
      use\ \[EscapeKey]sum\[EscapeKey]\ to\ enter\ a\ summation\ \
\(\(sign\)\(.\)\)\)\)}]], "Message",
  CellTags->"Sum::sumwarn"],

Cell["\<\
\[FilledSmallSquare] Generated when a capital sigma character \
\[CapitalSigma] is used in a position where a summation sign \[Sum] is \
expected.
\[FilledSmallSquare] This is a warning message about unexpected typeset input \
and does not necessarily indicate an error.\
\>", "Notes",
  CellTags->"Sum::sumwarn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Sum::sumwarn"],

Cell["\<\
A warning message is generated in this example because of the \
unexpected use of the capital sigma character.\
\>", "Text",
  CellTags->"Sum::sumwarn"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      StyleBox[\(\[CapitalSigma]\+\(k = 1\)\%5\),
        ScriptLevel->0], 
      StyleBox[" ",
        ScriptLevel->0], "k"}]], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Sum::sumwarn"],

Cell[BoxData[
    \(Sum::"sumwarn" \(\(:\)\(\ \)\) 
      "Warning: \!\(\[CapitalSigma]\+\(k = 1\)\%5\) contains a capital sigma; \
use \[EscapeKey]sum\[EscapeKey] to enter a summation sign."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Sum::sumwarn"],

Cell[BoxData[
    \(\[CapitalSigma]\+1\%5\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Sum::sumwarn"]
}, Open  ]],

Cell["This shows the expected typeset input for a sum.", "Text",
  CellTags->"Sum::sumwarn"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      StyleBox[\(\[Sum]\+\(k = 1\)\%5\),
        ScriptLevel->0], 
      StyleBox[" ",
        ScriptLevel->0], "k"}]], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Sum::sumwarn"],

Cell[BoxData[
    \(15\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Sum::sumwarn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Syntax::noinfo", "ObjectNameWarningMessages",
  CellTags->"Syntax::noinfo"],

Cell[BoxData[
    \(Syntax::"noinfo" \(\(:\)\(\ \)\) \(Input\ expression\ contains\ \
insufficient\ information\ to\ interpret\ \(\(result\)\(.\)\)\)\)], "Message",\

  CellTags->"Syntax::noinfo"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to make an expression from a  \
",
  StyleBox["TagBox", "MR"],
  " in which the second argument is ",
  StyleBox["False", "MR"],
  ".\n\[FilledSmallSquare] This message can occur if improperly constructed  \
typeset input is evaluated."
}], "Notes",
  CellTags->"Syntax::noinfo"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Syntax::noinfo"],

Cell[TextData[{
  "An error occurs in this example because the second argument ",
  StyleBox["TagBox", "MR"],
  " does not specify how the ",
  StyleBox["RowBox", "MR"],
  " expression should be interpreted."
}], "Text",
  CellTags->"Syntax::noinfo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MakeExpression[
      TagBox[RowBox[{"\<2\>", "\<+\>", "\<2\>"}], False]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Syntax::noinfo"],

Cell[BoxData[
    \(Syntax::"noinfo" \(\(:\)\(\ \)\) 
      "Input expression contains insufficient information to interpret \
result."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Syntax::noinfo"],

Cell[BoxData[
    \(ErrorBox[ErrorBox[TagBox[RowBox[{"2", "+", "2"}], False]]]\)], "Output",\

  CellLabel->"Out[1]=",
  CellTags->"Syntax::noinfo"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid interpretation of a ",
  StyleBox["TagBox", "MR"],
  " expression."
}], "Text",
  CellTags->"Syntax::noinfo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MakeExpression[
      TagBox[RowBox[{"\<2\>", "\<+\>", "\<2\>"}], Identity]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Syntax::noinfo"],

Cell[BoxData[
    \(HoldComplete[Identity[2 + 2]]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Syntax::noinfo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Syntax::snthex", "ObjectNameWarningMessages",
  CellTags->"Syntax::snthex"],

Cell[BoxData[
    \(Syntax::"snthex" \(\(:\)\(\ \)\) 
      "4 hexadecimal digits are required after \\: to construct a 16-bit \
character."\)], "Message",
  CellLabel->"From In[83]:=",
  CellTags->"Syntax::snthex"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the ",
  StyleBox["\[Backslash]:", "MR"],
  StyleBox["dddd", "MR",
    FontSlant->"Italic"],
  " notation for characters is used without the required digits."
}], "Notes",
  CellTags->"Syntax::snthex"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Syntax::snthex"],

Cell[TextData[{
  "An error occurs in this example because the four characters following ",
  StyleBox["\[Backslash]:", "MR"],
  " are not valid hexadecimal digits."
}], "Text",
  CellTags->"Syntax::snthex"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<x\\\>" <> "\<:\>" <> "\<3c0y\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Syntax::snthex"],

Cell[BoxData[
    \(Syntax::"snthex" \(\(:\)\(\ \)\) 
      "4 hexadecimal digits are required after \\: to construct a 16-bit \
character."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Syntax::snthex"],

Cell["\<\
ToExpression::sntx: Syntax error in or before \"x\[Pi]\".
                                                ^\
\>", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Syntax::snthex"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Syntax::snthex"]
}, Open  ]],

Cell["\<\
This shows valid input using the hexadecimal digits of a character.\
\
\>", "Text",
  CellTags->"Syntax::snthex"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<x\\\>" <> "\<:\>" <> "\<03c0y\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Syntax::snthex"],

Cell[BoxData[
    \(x\[Pi]y\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Syntax::snthex"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Syntax::sntoct1", "ObjectNameWarningMessages",
  CellTags->"Syntax::sntoct1"],

Cell[BoxData[
    \(Syntax::"sntoct1" \(\(:\)\(\ \)\) 
      "3 octal digits are required after \\ to construct an 8-bit character."\
\)], "Message",
  CellLabel->"From In[84]:=",
  CellTags->"Syntax::sntoct1"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the ",
  StyleBox["\[Backslash]", "MR"],
  StyleBox["ddd", "MR",
    FontSlant->"Italic"],
  " notation for characters is used without the required digits."
}], "Notes",
  CellTags->"Syntax::sntoct1"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Syntax::sntoct1"],

Cell[TextData[{
  "An error occurs in this example because the three digits following the ",
  StyleBox["\\", "MR"],
  " character are not valid octal digits."
}], "Text",
  CellTags->"Syntax::sntoct1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<\\\>"\  <> \ "\<069\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Syntax::sntoct1"],

Cell[BoxData[
    \(Syntax::"sntoct1" \(\(:\)\(\ \)\) 
      "3 octal digits are required after \\ to construct an 8-bit character."\
\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Syntax::sntoct1"],

Cell["\<\
ToExpression::sntx: Syntax error in or before \"\.06\".
                                                ^\
\>", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Syntax::sntoct1"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Syntax::sntoct1"]
}, Open  ]],

Cell["\<\
This shows valid input using the octal digits of a character.\
\>", \
"Text",
  CellTags->"Syntax::sntoct1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<\\\>"\  <> \ "\<101\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Syntax::sntoct1"],

Cell[BoxData[
    \(A\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Syntax::sntoct1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Syntax::sntoct2", "ObjectNameWarningMessages",
  CellTags->"Syntax::sntoct2"],

Cell[BoxData[
    \(Syntax::"sntoct2" \(\(:\)\(\ \)\) 
      "2 hexadecimal digits are required after \\. to construct an 8-bit \
character."\)], "Message",
  CellLabel->"From In[84]:=",
  CellTags->"Syntax::sntoct2"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the ",
  StyleBox["\[Backslash].", "MR"],
  StyleBox["dd", "MR",
    FontSlant->"Italic"],
  " notation for characters is used without the required digits."
}], "Notes",
  CellTags->"Syntax::sntoct2"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Syntax::sntoct2"],

Cell[TextData[{
  "An error occurs in this example because the characters after ",
  StyleBox["\[Backslash].", "MR"],
  " are not valid hexadecimal characters."
}], "Text",
  CellTags->"Syntax::sntoct2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<x\\\>" <> "\<.\>" <> "\<4\>" <> "\<y\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Syntax::sntoct2"],

Cell[BoxData[
    \(Syntax::"sntoct2" \(\(:\)\(\ \)\) 
      "2 hexadecimal digits are required after \\. to construct an 8-bit \
character."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Syntax::sntoct2"],

Cell["\<\
ToExpression::sntx: Syntax error in or before \"x\.04\".
                                                ^\
\>", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Syntax::sntoct2"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Syntax::sntoct2"]
}, Open  ]],

Cell["\<\
This shows valid input using the hexadecimal digits of a character.\
\
\>", "Text",
  CellTags->"Syntax::sntoct2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<x\\\>" <> "\<.\>" <> "\<34\>" <> "\<y\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Syntax::sntoct2"],

Cell[BoxData[
    \(x4y\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Syntax::sntoct2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Syntax::sntufn", "ObjectNameWarningMessages",
  CellTags->"Syntax::sntufn"],

Cell[BoxData[
    RowBox[{\(Syntax::"sntufn"\), \(\(:\)\(\ \)\), \(\(Unknown\)\(\ \
\)\(unicode\)\(\ \)\(longname\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Syntax::sntufn"],

Cell["\<\
\[FilledSmallSquare] Generated when an unknown name is encountered \
in input where the name of a known character is expected.\
\>", "Notes",
  CellTags->"Syntax::sntufn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Syntax::sntufn"],

Cell["\<\
An error occurs in this example because an unrecognized name is \
encountered where the name of a known character is expected.\
\>", "Text",
  CellTags->"Syntax::sntufn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<2\\\>" <> "\<[pi]\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Syntax::sntufn"],

Cell[BoxData[
    \(Syntax::"sntufn" \(\(:\)\(\ \)\) 
      "Unknown unicode longname \!\(\"pi\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Syntax::sntufn"],

Cell["\<\
ToExpression::sntx: Syntax error in or before \"2\\[pi]\".
                                                ^\
\>", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Syntax::sntufn"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Syntax::sntufn"]
}, Open  ]],

Cell["\<\
This example shows valid input using the name of a character.\
\>", \
"Text",
  CellTags->"Syntax::sntufn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<2\\\>" <> "\<[Pi]\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Syntax::sntufn"],

Cell[BoxData[
    \(2\ \[Pi]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Syntax::sntufn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Syntax::sntunc", "ObjectNameWarningMessages",
  CellTags->"Syntax::sntunc"],

Cell[BoxData[
    RowBox[{\(Syntax::"sntunc"\), \(\(:\)\(\ \)\), \(\(Unicode\)\(\ \
\)\(longname\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(in\ the\ string\ is\ \
\(\(unterminated\)\(.\)\)\)\)}]], "Message",
  CellTags->"Syntax::sntunc"],

Cell["\<\
\[FilledSmallSquare] Generated when an input string ends before a \
closing bracket is encountered after the name of a character.\
\>", "Notes",
  CellTags->"Syntax::sntunc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Syntax::sntunc"],

Cell["\<\
An error occurs in this example because there is no closing bracket \
after the name of the character.\
\>", "Text",
  CellTags->"Syntax::sntunc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<2\"\\\>" <> "\<[Pi\"\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Syntax::sntunc"],

Cell[BoxData[
    \(Syntax::"sntunc" \(\(:\)\(\ \)\) 
      "Unicode longname \!\(\"Pi\"\) in the string is unterminated."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Syntax::sntunc"],

Cell[BoxData[
    \(2\ "\\[Pi"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Syntax::sntunc"]
}, Open  ]],

Cell["This shows valid input using the name of a character.", "Text",
  CellTags->"Syntax::sntunc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<2\"\\\>" <> "\<[Pi]\"\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Syntax::sntunc"],

Cell[BoxData[
    \(2\ "\[Pi]"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Syntax::sntunc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Syntax::syntyp", "ObjectNameWarningMessages",
  CellTags->"Syntax::syntyp"],

Cell[BoxData[
    \(Syntax::"syntyp" \(\(:\)\(\ \)\) 
      "\\ operators can only be used between \( \)."\)], "Message",
  CellLabel->"From In[84]:=",
  CellTags->"Syntax::syntyp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when operators such as ",
  StyleBox["\\^", "MR"],
  " and ",
  StyleBox["\\@", "MR"],
  " used for representing typeset expressions are encountered outside of the  \
",
  StyleBox["\\(", "MR"],
  " ",
  StyleBox["\\)", "MR"],
  " notation which is used for ",
  StyleBox["RowBox", "MR"],
  " expressions."
}], "Notes",
  CellTags->"Syntax::syntyp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Syntax::syntyp"],

Cell[TextData[{
  "An error occurs in this example because the input involves an operator  \
that is meaningful only in a ",
  StyleBox["RowBox", "MR"],
  " expression."
}], "Text",
  CellTags->"Syntax::syntyp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<1 + 2\^3\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Syntax::syntyp"],

Cell[BoxData[
    \(Syntax::"syntyp" \(\(:\)\(\ \)\) 
      "\\ operators can only be used between \( \)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Syntax::syntyp"],

Cell["\<\
ToExpression::sntx: Syntax error in or before \"1 + 2\^3\".
                                                          ^\
\>", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Syntax::syntyp"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Syntax::syntyp"]
}, Open  ]],

Cell[TextData[{
  "This shows valid notation for a ",
  StyleBox["RowBox", "MR"],
  " expression."
}], "Text",
  CellTags->"Syntax::syntyp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<\(1 + 2\^3\)\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Syntax::syntyp"],

Cell[BoxData[
    \(RowBox[{"1", "+", SuperscriptBox["2", "3"]}]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Syntax::syntyp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TableForm::tfal", "ObjectNameWarningMessages",
  CellTags->"TableForm::tfal"],

Cell[BoxData[
    RowBox[{\(TableForm::"tfal"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\ \
TableAlignments\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ a\ list\ of\ alignment\ specifications\ \
\(\((Top, \ Bottom, \ and\ Center\ for\ row\ dimensions, \ or\ Left, \ 
            Right, \ 
            and\ Center\ for\ column\ dimensions)\)\(.\)\)\)\)}]], "Message",
  CellTags->"TableForm::tfal"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["TableAlignments", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->"TableForm::tfal"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"TableForm::tfal"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid alignment specification in the ",
  StyleBox["TableAlignments", "MR"],
  " option."
}], "Text",
  CellTags->"TableForm::tfal"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[{{123456789, 222}, {3, 0}}, 
      TableAlignments -> {Right, Automatic}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"TableForm::tfal"],

Cell[BoxData[
    \(TableForm::"tfal" \(\(:\)\(\ \)\) 
      "Value of option TableAlignments -> \!\(Automatic\) should be a list of \
alignment specifications (Top, Bottom, and Center for row dimensions, or \
Left, Right, and Center for column dimensions)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"TableForm::tfal"],

Cell[BoxData[
    TagBox[GridBox[{
          {"123456789", "222"},
          {"3", "0"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Center,
        ColumnAlignments->{Right}],
      Function[ BoxForm`e$, 
        TableForm[ 
        BoxForm`e$, TableAlignments -> {Right, Automatic}]]]], "Output",
  CellLabel->"Out[1]//TableForm=",
  CellTags->"TableForm::tfal"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["TableAlignments", "MR"],
  " option."
}], "Text",
  CellTags->"TableForm::tfal"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[{{123456789, 222}, {3, 0}}, 
      TableAlignments -> {Right}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"TableForm::tfal"],

Cell[BoxData[
    TagBox[GridBox[{
          {"123456789", "222"},
          {"3", "0"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Right}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$, TableAlignments -> {Right}]]]], "Output",
  CellLabel->"Out[2]//TableForm=",
  CellTags->"TableForm::tfal"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TableForm::tfdir", "ObjectNameWarningMessages",
  CellTags->"TableForm::tfdir"],

Cell[BoxData[
    RowBox[{\(TableForm::"tfdir"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\ \
TableDirections\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ Row, \ Column, \ 
      or\ a\ non - 
        empty\ list\ of\ these\ \(\(values\)\(.\)\)\)\)}]], "Message",
  CellTags->"TableForm::tfdir"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["TableDirections", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->"TableForm::tfdir"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"TableForm::tfdir"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Left", "MR"],
  " is not a valid value for the ",
  StyleBox["TableDirections", "MR"],
  " option."
}], "Text",
  CellTags->"TableForm::tfdir"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[{{1, 2, 3, 4}, {5, 6, 7, 8}}, 
      TableDirections -> Left]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"TableForm::tfdir"],

Cell[BoxData[
    \(TableForm::"tfdir" \(\(:\)\(\ \)\) 
      "Value of option TableDirections -> \!\(Left\) should be Row, Column, \
or a non-empty list of these values."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"TableForm::tfdir"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "2", "3", "4"},
          {"5", "6", "7", "8"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$, TableDirections -> Left]]]], "Output",
  CellLabel->"Out[1]//TableForm=",
  CellTags->"TableForm::tfdir"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["TableDirections", "MR"],
  " option."
}], "Text",
  CellTags->"TableForm::tfdir"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[{{1, 2, 3, 4}, {5, 6, 7, 8}}, 
      TableDirections -> Row]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"TableForm::tfdir"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "5"},
          {"2", "6"},
          {"3", "7"},
          {"4", "8"}
          },
        RowSpacings->3,
        ColumnSpacings->1,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$, TableDirections -> Row]]]], "Output",
  CellLabel->"Out[2]//TableForm=",
  CellTags->"TableForm::tfdir"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TableForm::tfh", "ObjectNameWarningMessages",
  CellTags->"TableForm::tfh"],

Cell[BoxData[
    RowBox[{\(TableForm::"tfh"\), \(\(:\)\(\ \)\), \(\(TableHeadings\)\(\ \
\)\(option\)\(\ \)\(contained\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(,\)\(\ \)\(which\ is\ not\ Automatic\)\(,\)\(\ \
\)\(None\)\(,\)\(\ \)\(or\ a\ list\ of\ \(\(labels\)\(.\)\)\)\)}]], "Message",\

  CellTags->"TableForm::tfh"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["TableHeadings", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->"TableForm::tfh"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"TableForm::tfh"],

Cell[TextData[{
  "An error occurs in this example because a list of strings is not a valid  \
value for the ",
  StyleBox["TableHeadings", "MR"],
  " option."
}], "Text",
  CellTags->"TableForm::tfh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[{{1, 55, 23}, {2, 56, 71}, {3, 77, 23}}, 
      TableHeadings -> {"\<n\>", "\<x\>", "\<y\>"}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"TableForm::tfh"],

Cell[BoxData[
    \(TableForm::"tfh" \(\(:\)\(\ \)\) 
      "TableHeadings option contained \!\(\"n\"\), which is not Automatic, \
None, or a list of labels."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"TableForm::tfh"],

Cell[BoxData[
    \(TableForm::"tfh" \(\(:\)\(\ \)\) 
      "TableHeadings option contained \!\(\"x\"\), which is not Automatic, \
None, or a list of labels."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"TableForm::tfh"],

Cell[BoxData[
    \(TableForm::"tfh" \(\(:\)\(\ \)\) 
      "TableHeadings option contained \!\(\"y\"\), which is not Automatic, \
None, or a list of labels."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"TableForm::tfh"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(TableForm :: \"tfh\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"TableForm::tfh"],

Cell[BoxData[
    TagBox[GridBox[{
          {"1", "55", "23"},
          {"2", "56", "71"},
          {"3", "77", "23"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$, TableHeadings -> {"n", "x", "y"}]]]], "Output",\

  CellLabel->"Out[1]//TableForm=",
  CellTags->"TableForm::tfh"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["TableHeadings", "MR"],
  " option."
}], "Text",
  CellTags->"TableForm::tfh"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TableForm[{{1, 55, 23}, {2, 56, 71}, {3, 77, 23}}, 
      TableHeadings -> {None, {"\<n\>", "\<x\>", "\<y\>"}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"TableForm::tfh"],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"n\"\>", "\<\"x\"\>", "\<\"y\"\>"},
          {"1", "55", "23"},
          {"2", "56", "71"},
          {"3", "77", "23"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ 
        BoxForm`e$, TableHeadings -> {None, {"n", "x", "y"}}]]]], "Output",
  CellLabel->"Out[2]//TableForm=",
  CellTags->"TableForm::tfh"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TableForm::tfsp", "ObjectNameWarningMessages",
  CellTags->"TableForm::tfsp"],

Cell[BoxData[
    RowBox[{\(TableForm::"tfsp"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\ \
TableSpacing\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ Automatic\ or\ a\ list\ of\ machine - 
        size\ \(\(numbers\)\(.\)\)\)\)}]], "Message",
  CellTags->"TableForm::tfsp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["TableSpacing", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->"TableForm::tfsp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"TableForm::tfsp"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["TableSpacing", "MR"],
  " option when ",
  StyleBox["TableForm", "MR"],
  " is formatted in ",
  StyleBox["OutputForm", "MR"],
  "."
}], "Text",
  CellTags->"TableForm::tfsp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OutputForm[
      TableForm[{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}}, 
        TableSpacing -> None]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"TableForm::tfsp"],

Cell[BoxData[
    \(TableForm::"tfsp" \(\(:\)\(\ \)\) 
      "Value of option TableSpacing -> \!\(None\) should be Automatic or a \
list of machine-size numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"TableForm::tfsp"],

Cell[OutputFormData["\<\
{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}}\
\>", \
"\<\
TableForm[{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}}, TableSpacing -> \
None]\
\>"], "Output",
  CellLabel->"Out[1]//OutputForm=",
  CellTags->"TableForm::tfsp"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["TableSpacing", "MR"],
  " option."
}], "Text",
  CellTags->"TableForm::tfsp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OutputForm[
      TableForm[{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}}, 
        TableSpacing -> {2, 0}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"TableForm::tfsp"],

Cell[OutputFormData["\<\
{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}}\
\>", "\<\
123


456


789\
\>"], "Output",
  CellLabel->"Out[2]//OutputForm=",
  LineSpacing->{1, 0},
  CellTags->"TableForm::tfsp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TeXForm::texalign", "ObjectNameWarningMessages",
  CellTags->"TeXForm::texalign"],

Cell[BoxData[
    \(TeXForm::"texalign" \(\(:\)\(\ \)\) 
      "The value for the Alignment options should be one of Center, Left, \
Right, Top, Bottom, and Axis."\)], "Message",
  CellLabel->"From In[632]:=",
  CellTags->"TeXForm::texalign"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["TeXForm", "MR"],
  " is applied to a ",
  StyleBox["GridBox", "MR"],
  " expression in which the ",
  StyleBox["RowAlignments", "MR"],
  " or ",
  StyleBox["ColumnAlignments", "MR"],
  " options have unexpected values."
}], "Notes",
  CellTags->"TeXForm::texalign"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TeXForm::texstyle", "ObjectNameWarningMessages",
  CellTags->"TeXForm::texstyle"],

Cell[BoxData[
    \(TeXForm::"texstyle" \(\(:\)\(\ \)\) 
      "The value for the VerticalPlacement option should be one of \
DisplayStyle, TextStyle, ScriptStyle, ScriptscriptStyle, None, and \
Automatic."\)], "Message",
  CellLabel->"From In[636]:=",
  CellTags->"TeXForm::texstyle"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"TeXForm::texstyle"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TeXForm::texval", "ObjectNameWarningMessages",
  CellTags->"TeXForm::texval"],

Cell[BoxData[
    RowBox[{\(TeXForm::"texval"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \
\)\(value\)\(\ \)\(for\)\(\ \)\(the\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(option\ must\ be\ a\ real\ or\ integer\ \(\(number\)\
\(.\)\)\)\)}]], "Message",
  CellTags->"TeXForm::texval"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"TeXForm::texval"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToExpression::esntx", "ObjectNameWarningMessages",
  CellTags->"ToExpression::esntx"],

Cell[BoxData[
    RowBox[{\(ToExpression::"esntx"\), \(\(:\)\(\ \)\), \(\(Could\)\(\ \
\)\(not\)\(\ \)\(parse\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(as\ Mathematica\ \(\(input\)\(.\)\)\)\)}]], "Message",\

  CellTags->"ToExpression::esntx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["ToExpression", "MR"],
  " is not valid syntax for a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression."
}], "Notes",
  CellTags->"ToExpression::esntx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ToExpression::esntx"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["ToExpression", "MR"],
  " corresponds to an incomplete input."
}], "Text",
  CellTags->"ToExpression::esntx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[RowBox[{"\<2\>", "\<+\>"}], StandardForm]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ToExpression::esntx"],

Cell[BoxData[
    \(Syntax::"tsntxi" \(\(:\)\(\ \)\) 
      "\"\!\(2 +\)\" is incomplete; more input is needed.\!\(\"\"\)"\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"ToExpression::esntx"],

Cell[BoxData[
    \(ToExpression::"esntx" \(\(:\)\(\ \)\) 
      "Could not parse \!\(RowBox[\(\({\"2\", \"+\"}\)\)]\) as Mathematica \
input."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ToExpression::esntx"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ToExpression::esntx"]
}, Open  ]],

Cell[TextData[{
  "This shows a syntactically valid argument in ",
  StyleBox["ToExpression", "MR"],
  "."
}], "Text",
  CellTags->"ToExpression::esntx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[RowBox[{"\<2\>", "\<+\>", "\<Pi\>"}], 
      StandardForm]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ToExpression::esntx"],

Cell[BoxData[
    \(2 + \[Pi]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ToExpression::esntx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToExpression::esntxb", "ObjectNameWarningMessages",
  CellTags->"ToExpression::esntxb"],

Cell[BoxData[
    \(ToExpression::"esntxb" \(\(:\)\(\ \)\) 
      "Expression cannot begin with \"`1`\"."\)], "Message",
  CellLabel->"From In[84]:=",
  CellTags->"ToExpression::esntxb"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by a syntax error in which the first  \
character in the input is not part of any valid syntax.\n\[FilledSmallSquare] \
 This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"ToExpression::esntxb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToExpression::esntxf", "ObjectNameWarningMessages",
  CellTags->"ToExpression::esntxf"],

Cell[BoxData[
    \(ToExpression::"esntxf" \(\(:\)\(\ \)\) 
      "\"`1`\" cannot be followed by \"`2`\"."\)], "Message",
  CellLabel->"From In[85]:=",
  CellTags->"ToExpression::esntxf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by a syntax error in the first argument of  \
",
  StyleBox["ToExpression", "MR"],
  ".\n\[FilledSmallSquare] This message is not used in the current version of \
 ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"ToExpression::esntxf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToExpression::esntxi", "ObjectNameWarningMessages",
  CellTags->"ToExpression::esntxi"],

Cell[BoxData[
    \(ToExpression::"esntxi" \(\(:\)\(\ \)\) 
      "Incomplete expression \"`1`\"."\)], "Message",
  CellLabel->"From In[85]:=",
  CellTags->"ToExpression::esntxi"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by a syntax error in the expression in the  \
first argument of ",
  StyleBox["ToExpression", "MR"],
  ".\n\[FilledSmallSquare] This message is not used in the current version of \
 ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"ToExpression::esntxi"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToString::notype", "ObjectNameWarningMessages",
  CellTags->"ToString::notype"],

Cell[BoxData[
    RowBox[{\(ToString::"notype"\), \(\(:\)\(\ \)\), \(\(FormatType\)\(\ \)\),
       
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ suitable\ for\ string - 
        based\ output . \ Use\ a\ string - 
        based\ format\ such\ as\ \(\(OutputForm\)\(.\)\)\)\)}]], "Message",
  CellTags->"ToString::notype"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"ToString::notype"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::base", "ObjectNameWarningMessages",
  CellTags->"General::base"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"base\"\>"}], \(\(:\)\(\ \)\), "Requested", " ", 
      "base", " ", 
      StyleBox["b",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "should", " ", "be", " ", "between", " ", "2", " ", "and",
       " ", 
      RowBox[{
        StyleBox["max",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::base"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when base in the special form ",
  StyleBox["base", "MR",
    FontSlant->"Italic"],
  StyleBox["^^", "MR"],
  StyleBox["digits", "MR",
    FontSlant->"Italic"],
  " is not in the indicated range."
}], "Notes",
  CellTags->"General::base"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::base"],

Cell["\<\
An error occurs in this example because the number that corresponds \
to the base is not in the required range.\
\>", "Text",
  CellTags->"General::base"],

Cell[CellGroupData[{

Cell[BoxData[
    \(101101^^2\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::base"],

Cell[BoxData[
    \(General::"base" \(\(:\)\(\ \)\) 
      "Requested base \!\(101101\) in \!\(\"101101^^2\"\) should be between 2 \
and \!\(36\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::base"]
}, Open  ]],

Cell["\<\
This shows a valid way to enter a number in the specified \
base.\
\>", "Text",
  CellTags->"General::base"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2^^101101\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::base"],

Cell[BoxData[
    \(45\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::base"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::bktfn", "ObjectNameWarningMessages",
  CellTags->"General::bktfn"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bktfn\"\>"}], \(\(:\)\(\ \)\), "\<\"\\\"`1`\\\" should \
probably be \\\"`2`\\\".`4`\"\>"}]], "Message",
  CellLabel->"From In[85]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::bktfn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated for syntax errors involving mismatched  \
brackets and parentheses.\n\[FilledSmallSquare] The suggested input reflects  \
the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " convention of enclosing function arguments in square brackets.\n\
\[FilledSmallSquare] This message will generally occur only for interactive \
",
  StyleBox["InputForm", "MR"],
  " input."
}], "Notes",
  CellTags->"General::bktfn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::bktfn"],

Cell[TextData[{
  "Entering this input in an ",
  StyleBox["InputForm", "MR"],
  " cell will generate a warning message, and the input will not be  \
evaluated."
}], "Text",
  CellTags->"General::bktfn"],

Cell[CellGroupData[{

Cell["FactorInteger(4]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::bktfn"],

Cell["\<\
Syntax::bktfn: \"FactorInteger(4]\" should probably be \
\"FactorInteger[4]\".\
\>", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::bktfn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::bktmch", "ObjectNameWarningMessages",
  CellTags->"General::bktmch"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bktmch\"\>"}], \(\(:\)\(\ \)\), "\<\"\\\"`1`\\\" must be \
followed by \\\"`2`\\\", not \\\"`3`\\\".`4`\"\>"}]], "Message",
  CellLabel->"From In[85]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::bktmch"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated for syntax errors involving mismatched  \
brackets and parentheses.\n\[FilledSmallSquare] The suggested input indicates \
 the expected closing bracket or parentheses.\n\[FilledSmallSquare] This  \
message will generally occur only for interactive ",
  StyleBox["InputForm", "MR"],
  " input."
}], "Notes",
  CellTags->"General::bktmch"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::bktmch"],

Cell[TextData[{
  "Entering this input in an ",
  StyleBox["InputForm", "MR"],
  " cell will generate a warning message, and the input will not be  \
evaluated."
}], "Text",
  CellTags->"General::bktmch"],

Cell[CellGroupData[{

Cell["FactorInteger[4)", "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::bktmch"],

Cell["\<\
Syntax::bktmch: \"FactorInteger[4\" must be followed by \"]\", not \
\")\".\
\>", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::bktmch"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::bktmcp", "ObjectNameWarningMessages",
  CellTags->"General::bktmcp"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bktmcp\"\>"}], \(\(:\)\(\ \)\), "\<\"Expression \
\\\"`1`\\\" has no closing \\\"`2`\\\".`4`\"\>"}]], "Message",
  CellLabel->"From In[86]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::bktmcp"],

Cell["\<\
\[FilledSmallSquare] Generated by mismatched parentheses in \
input.\
\>", "Notes",
  CellTags->"General::bktmcp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::bktmcp"],

Cell["\<\
An error occurs in this example because of unmatched parentheses in \
the input.\
\>", "Text",
  CellTags->"General::bktmcp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[
      RowBox[{"\<3\>", "\<(\>", "\<2\>", "\<+\>", "\<E\>"}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::bktmcp"],

Cell[BoxData[
    \(Syntax::"bktmcp" \(\(:\)\(\ \)\) 
      "Expression \"\!\(3 (2 + E\)\" has no closing \
\"\!\(\")\"\)\".\!\(\"\"\)"\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::bktmcp"],

Cell[BoxData[
    \(ToExpression::"esntx" \(\(:\)\(\ \)\) 
      "Could not parse \!\(RowBox[\(\({\"3\", \"(\", \"2\", \"+\", \
\"E\"}\)\)]\) as Mathematica input."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::bktmcp"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::bktmcp"]
}, Open  ]],

Cell[TextData[{
  "This shows syntactically correct input in ",
  StyleBox["ToExpression", "MR"],
  "."
}], "Text",
  CellTags->"General::bktmcp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[
      RowBox[{"\<3\>", "\<(\>", "\<2\>", "\<+\>", "\<E\>", "\<)\>"}]]\)], \
"Input",
  CellLabel->"In[2]:=",
  CellTags->"General::bktmcp"],

Cell[BoxData[
    \(3\ \((2 + \[ExponentialE])\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::bktmcp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::bktmop", "ObjectNameWarningMessages",
  CellTags->"General::bktmop"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bktmop\"\>"}], \(\(:\)\(\ \)\), "\<\"Expression \
\\\"`1`\\\" has no opening \\\"`2`\\\".`4`\"\>"}]], "Message",
  CellLabel->"From In[86]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::bktmop"],

Cell["\<\
\[FilledSmallSquare] Generated by mismatched parentheses in \
input.\
\>", "Notes",
  CellTags->"General::bktmop"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::bktmop"],

Cell["\<\
An error occurs in this example because of unmatched parentheses in \
the input.\
\>", "Text",
  CellTags->"General::bktmop"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[
      RowBox[{"\<2\>", \ "\<1\>", \ "\<+\>", \ "\<E\>", \ "\<)\>"}]]\)], \
"Input",
  CellLabel->"In[1]:=",
  CellTags->"General::bktmop"],

Cell[BoxData[
    \(Syntax::"bktmop" \(\(:\)\(\ \)\) 
      "Expression \"\!\(21 + E)\)\" has no opening \
\"\!\(\"(\"\)\".\!\(\"\"\)"\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::bktmop"],

Cell[BoxData[
    \(ToExpression::"esntx" \(\(:\)\(\ \)\) 
      "Could not parse \!\(RowBox[\(\({\"2\", \"1\", \"+\", \"E\", \
\")\"}\)\)]\) as Mathematica input."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::bktmop"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::bktmop"]
}, Open  ]],

Cell[TextData[{
  "This shows syntactically correct input in ",
  StyleBox["ToExpression", "MR"],
  "."
}], "Text",
  CellTags->"General::bktmop"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[
      RowBox[{"\<2\>", \ "\<(\>", "\<1\>", \ "\<+\>", \ "\<E\>", \ "\<)\>"}]]\
\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::bktmop"],

Cell[BoxData[
    \(2\ \((1 + \[ExponentialE])\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::bktmop"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::bktwrn", "ObjectNameWarningMessages",
  CellTags->"General::bktwrn"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bktwrn\"\>"}], \(\(:\)\(\ \)\), "\<\"\\\"`1`\\\" \
represents multiplication; use \\\"`2`\\\" to represent a \
function.`4`\"\>"}]], "Message",
  CellLabel->"From In[86]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::bktwrn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the input is syntactically correct but \
may involve incorrect use of parentheses in place of square brackets.\n\
\[FilledSmallSquare] This message reflects the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " convention of enclosing function arguments in square brackets rather than \
 in parentheses.\n\[FilledSmallSquare] This message will generally occur only \
 for interactive ",
  StyleBox["InputForm", "MR"],
  " input."
}], "Notes",
  CellTags->"General::bktwrn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::bktwrn"],

Cell[TextData[{
  "Entering this input in an ",
  StyleBox["InputForm", "MR"],
  " cell will generate a warning message.  The input will be evaluated, but  \
the result may not be what was intended."
}], "Text",
  CellTags->"General::bktwrn"],

Cell[CellGroupData[{

Cell["FactorInteger(4)", "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::bktwrn"],

Cell["\<\
Syntax::bktwrn: 
   \"FactorInteger(4)\" represents multiplication; use \"FactorInteger[4]\"
     to represent a function.\
\>", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::bktwrn"],

Cell[BoxData[
    \(4\ FactorInteger\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::bktwrn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::bktx", "ObjectNameWarningMessages",
  CellTags->"General::bktx"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bktx\"\>"}], \(\(:\)\(\ \)\), "\<\"\\\"`1`\\\" has extra \
\\\"`2`\\\" after it.`4`\"\>"}]], "Message",
  CellLabel->"From In[86]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::bktx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated for syntax errors involving extra closing  \
brackets, parentheses, or curly braces.\n\[FilledSmallSquare] This message  \
will generally occur only for interactive ",
  StyleBox["InputForm", "MR"],
  " input."
}], "Notes",
  CellTags->"General::bktx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::bktx"],

Cell[TextData[{
  "Entering this input in an ",
  StyleBox["InputForm", "MR"],
  " cell will generate an error message and the input will not be  \
evaluated."
}], "Text",
  CellTags->"General::bktx"],

Cell[CellGroupData[{

Cell["FactorInteger[4]]", "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::bktx"],

Cell["Syntax::bktx: \"FactorInteger[4]\" has extra \"]\" after it.", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::bktx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::continfo", "ObjectNameWarningMessages",
  CellTags->"General::continfo"],

Cell[BoxData[
    \(General::"continfo" \(\(:\)\(\ \)\) 
      "\!\(`1`f\[DifferentialD]x\) is interpreted as \!\(`2`[f, x]\)."\)], \
"Message",
  CellLabel->"From In[87]:=",
  CellTags->"General::continfo"],

Cell["\<\
\[FilledSmallSquare] This is an informational message used for \
\[ContourIntegral]  and related characters.
\[FilledSmallSquare] This is not an error or warning message.\
\>", "Notes",
  CellTags->"General::continfo"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::continfo"],

Cell["This shows a typical use of this message.", "Text",
  CellTags->"General::continfo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?\[ContourIntegral]\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::continfo"],

Cell[BoxData[
    \("\!\(\[ContourIntegral]f\[DifferentialD]x\) is interpreted as  \
\!\(ContourIntegral[f, x]\)."\)], "Print",
  CellTags->"General::continfo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::digit", "ObjectNameWarningMessages",
  CellTags->"General::digit"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"digit\"\>"}], \(\(:\)\(\ \)\), "Digit", " ", "at",
       " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "too", " ", "large", " ", "to", " ", "be", " ",
       "used", " ", "in", " ", "base", " ", 
      RowBox[{
        StyleBox["b",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::digit"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the special notation ",
  StyleBox["base", "TI"],
  StyleBox["^^", "MR"],
  StyleBox["digits", "TI"],
  " is used with an invalid digit."
}], "Notes",
  CellTags->"General::digit"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::digit"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["x", "MR"],
  " is not a valid digit in base ",
  StyleBox["2.", "MR"]
}], "Text",
  CellTags->"General::digit"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2^^x\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::digit"],

Cell[BoxData[
    \(General::"digit" \(\(:\)\(\ \)\) 
      "Digit at position \!\(1\) in \!\(\"x\"\) is too large to be used in \
base \!\(2\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::digit"]
}, Open  ]],

Cell[TextData[{
  "This shows valid syntax for entering a number in base ",
  StyleBox["2.", "MR"]
}], "Text",
  CellTags->"General::digit"],

Cell[CellGroupData[{

Cell[BoxData[
    \(2^^101\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::digit"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::digit"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::existinfo", "ObjectNameWarningMessages",
  CellTags->"General::existinfo"],

Cell[BoxData[
    \(General::"existinfo" \(\(:\)\(\ \)\) 
      "\!\(`1`\_x y\) is interpreted as `2`[x, y]."\)], "Message",
  CellLabel->"From In[87]:=",
  CellTags->"General::existinfo"],

Cell["\<\
\[FilledSmallSquare] This is an information message used for \
\[Exists] and related characters.
\[FilledSmallSquare] This is not an error or warning message.\
\>", "Notes",
  CellTags->"General::existinfo"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::existinfo"],

Cell["This shows a typical use of this message.", "Text",
  CellTags->"General::existinfo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?\[Exists]\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::existinfo"],

Cell[BoxData[
    \("\!\(\[Exists]\_x y\) is interpreted as Exists[x, y]."\)], "Print",
  CellTags->"General::existinfo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::incomma", "ObjectNameWarningMessages",
  CellTags->"General::incomma"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"incomma\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "a", " ", "structural", " ", "element", " ", 
        "which", " ", "is", " ", "interpreted", " ", "as", " ", "an", " ", 
        "ordinary", " ", \(\(comma\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::incomma"],

Cell["\<\
\[FilledSmallSquare] This is an informational message used for \
characters that are interpreted as commas.
\[FilledSmallSquare] This is not an error or warning message.\
\>", "Notes",
  CellTags->"General::incomma"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::incomma"],

Cell["This shows a typical use of this message.", "Text",
  CellTags->"General::incomma"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<\[InvisibleComma]\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::incomma"],

Cell[BoxData[
    \("InvisibleComma is a structural element which is interpreted as an  \
ordinary comma."\)], "Print",
  CellTags->"General::incomma"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::intinfo", "ObjectNameWarningMessages",
  CellTags->"General::intinfo"],

Cell[BoxData[
    \(General::"intinfo" \(\(:\)\(\ \)\) 
      "\!\(\[Integral]f\[DifferentialD]x\) or \!\(\[Integral]f\
\[CapitalDifferentialD]x\) is interpreted as Integrate[f, x]; \!\(\[Integral]\
\^b\%a f\[DifferentialD]x\) or \!\(\[Integral]\^b\%a \
f\[CapitalDifferentialD]x\) is interpreted as Integrate[f, {x,a,b}]."\)], \
"Message",
  CellLabel->"From In[87]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::intinfo"],

Cell["\<\
\[FilledSmallSquare] This is an informational message used for \
\[Integral] and related characters.
\[FilledSmallSquare] This is not an error or warning message.\
\>", "Notes",
  CellTags->"General::intinfo"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::intinfo"],

Cell["This shows a typical use of this message.", "Text",
  CellTags->"General::intinfo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?\[Integral]\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::intinfo"],

Cell[BoxData[
    \("\!\(\[Integral]f\[DifferentialD]x\) or \!\(\[Integral]f \
\[CapitalDifferentialD]x\) is interpreted as Integrate[f, x]; \!\(\[Integral] \
\^b\%a f\[DifferentialD]x\) or \!\(\[Integral]\^b\%a  \
f\[CapitalDifferentialD]x\) is interpreted as Integrate[f, {x,a,b}]."\)], \
"Print",
  CellTags->"General::intinfo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::partialinfo", "ObjectNameWarningMessages",
  CellTags->"General::partialinfo"],

Cell[BoxData[
    \(General::"partialinfo" \(\(:\)\(\ \)\) 
      "\!\(`1`\_x y\) is interpreted as `2`[y, x]."\)], "Message",
  CellLabel->"From In[88]:=",
  CellTags->"General::partialinfo"],

Cell["\<\
\[FilledSmallSquare] This is an informational message used for \
\[PartialD] and related characters.
\[FilledSmallSquare] This is not an error or warning message.\
\>", "Notes",
  CellTags->"General::partialinfo"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::partialinfo"],

Cell["This shows a typical use of this message.", "Text",
  CellTags->"General::partialinfo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?\[PartialD]\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::partialinfo"],

Cell[BoxData[
    \("\!\(\[PartialD]\_x y\) is interpreted as D[y, x]."\)], "Print",
  CellTags->"General::partialinfo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::strbox", "ObjectNameWarningMessages",
  CellTags->"General::strbox"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"strbox\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "an", " ", "operator", " ", "for", " ", 
        "representing", " ", "textual", " ", "boxes", " ", "in", 
        " ", \(\(strings\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::strbox"],

Cell["\<\
\[FilledSmallSquare] This is an informational message used for \
operators that occur in typeset input.
\[FilledSmallSquare] This is not an error or warning message.\
\>", "Notes",
  CellTags->"General::strbox"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::strbox"],

Cell["This shows a typical use of this message.", "Text",
  CellTags->"General::strbox"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<\@\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::strbox"],

Cell[BoxData[
    InterpretationBox["\<\"\\@ is an operator for representing textual boxes \
in strings.\"\>",
      StringForm[ 
      "`1` is an operator for representing textual boxes in strings.", "\@"],
      Editable->False]], "Print",
  CellLabel->"From In[6]:=",
  CellTags->"General::strbox"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::uinfix", "ObjectNameWarningMessages",
  CellTags->"General::uinfix"],

Cell[BoxData[
    \(General::"uinfix" \(\(:\)\(\ \)\) 
      "An infix operator, \!\(x `1` y\) is by default interpreted as \
\!\(`2`[x, y]\)."\)], "Message",
  CellLabel->"From In[88]:=",
  CellTags->"General::uinfix"],

Cell["\<\
\[FilledSmallSquare] This is an informational message used for \
\[CirclePlus] and related characters.
\[FilledSmallSquare] This is not an error or warning message.\
\>", "Notes",
  CellTags->"General::uinfix"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::uinfix"],

Cell["This shows a typical use of this message.", "Text",
  CellTags->"General::uinfix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?\[CirclePlus]\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::uinfix"],

Cell[BoxData[
    \("An infix operator, \!\(x \[CirclePlus] y\) is by default interpreted  \
as \!\(CirclePlus[x, y]\)."\)], "Print",
  CellTags->"General::uinfix"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::uprefix", "ObjectNameWarningMessages",
  CellTags->"General::uprefix"],

Cell[BoxData[
    \(General::"uprefix" \(\(:\)\(\ \)\) 
      "A prefix operator. \!\(`1` x\) is by default interpreted as \!\(`2`[x]\
\)."\)], "Message",
  CellLabel->"From In[88]:=",
  CellTags->"General::uprefix"],

Cell["\<\
\[FilledSmallSquare] This is an informational message used for \
\[Del] and related characters.
\[FilledSmallSquare] This is not an error or warning message.\
\>", "Notes",
  CellTags->"General::uprefix"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::uprefix"],

Cell["This shows a typical use of this message.", "Text",
  CellTags->"General::uprefix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?\[Del]\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::uprefix"],

Cell[BoxData[
    \("A prefix operator. \!\(\[Del] x\) is by default interpreted as  \
\!\(Del[x]\)."\)], "Print",
  CellTags->"General::uprefix"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::upreinfix", "ObjectNameWarningMessages",
  CellTags->"General::upreinfix"],

Cell[BoxData[
    \(General::"upreinfix" \(\(:\)\(\ \)\) 
      "An infix and prefix operator. \!\(x `1` y\) is by default interpreted \
as \!\(`2`[x, y]\) ; \!\(`1` x\) is by default interpreted as \
\!\(`2`[x]\)."\)], "Message",
  CellLabel->"From In[88]:=",
  CellTags->"General::upreinfix"],

Cell["\<\
\[FilledSmallSquare] This is an informational message for operators \
that can be both infix operators or prefix operators.
\[FilledSmallSquare] This is not an error or warning message.\
\>", "Notes",
  CellTags->"General::upreinfix"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::upreinfix"],

Cell["This shows a typical use of this message.", "Text",
  CellTags->"General::upreinfix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Information["\<\[PlusMinus]\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::upreinfix"],

Cell[BoxData[
    \("An infix and prefix operator. \!\(x \[PlusMinus] y\) is by default  \
interpreted as \!\(PlusMinus[x, y]\) ; \!\(\[PlusMinus] x\) is by default  \
interpreted as \!\(PlusMinus[x]\)."\)], "Print",
  CellTags->"General::upreinfix"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::suminfo", "ObjectNameWarningMessages",
  CellTags->"General::suminfo"],

Cell[BoxData[
    \(General::"suminfo" \(\(:\)\(\ \)\) 
      "\!\(`1`\^i\%imax f\) is interpreted as `2`[f, {i,imax}]."\)], "Message",\

  CellLabel->"From In[89]:=",
  CellTags->"General::suminfo"],

Cell["\<\
\[FilledSmallSquare] This is an informational message used for \
\[Sum]  and related characters.
\[FilledSmallSquare] This is not an error or warning message.\
\>", "Notes",
  CellTags->"General::suminfo"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::suminfo"],

Cell["This shows a typical use of this message.", "Text",
  CellTags->"General::suminfo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?\[Sum]\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::suminfo"],

Cell[BoxData[
    \("\!\(\[Sum]\^i\%imax f\) is interpreted as Sum[f, {i,imax}]."\)], \
"Print",
  CellTags->"General::suminfo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Export::chtype
Import::chtype
Experimental`BinaryExport::chtype
Experimental`BinaryImport::chtype\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype", 
    "Experimental`BinaryImport::chtype"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"chtype\"\>"}], \(\(:\)\(\ \)\), "First", " ", 
      "argument", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", " ", "channel", 
      " ", \(\(type\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype", 
    "Experimental`BinaryImport::chtype"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["Export", "MR"],
  " or ",
  StyleBox["Import", "MR"],
  " does not have the expected form.\n\[FilledSmallSquare] The first argument \
 in ",
  StyleBox["Export", "MR"],
  " is expected to be an ",
  StyleBox["OutputStream", "MR"],
  " expression or a string giving the name of a file to which output should  \
be written.\n\[FilledSmallSquare] The first argument in ",
  StyleBox["Import", "MR"],
  " is expected to be either an ",
  StyleBox["InputStream", "MR"],
  " expression or a string giving the name of a file from which input should  \
be read."
}], "Notes",
  CellTags->{
  "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype", 
    "Experimental`BinaryImport::chtype"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::coerce", "ObjectNameWarningMessages",
  CellTags->"Export::coerce"],

Cell[BoxData[
    \(Export::"coerce" \(\(:\)\(\ \)\) 
      "Coercing `1` to `2` zero."\)], "Message",
  CellLabel->"From In[89]:=",
  CellTags->"Export::coerce"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Export", "MR"],
  " writes an unrecognized expression as a zero of the indicated type.\n\
\[FilledSmallSquare] This is a warning message to indicate type coercion and  \
does not necessarily indicate an error.\n\[FilledSmallSquare] In the current  \
version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " this message is used only by the ",
  StyleBox["Experimental`BinaryExport", "MR"],
  " function."
}], "Notes",
  CellTags->"Export::coerce"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Export::coerce"],

Cell[TextData[{
  "A warning message is generated in this example because the second argument \
 in ",
  StyleBox["Experimental`BinaryExport", "MR"],
  " is not recognized in the specified format, and is written as zero."
}], "Text",
  CellTags->"Export::coerce"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Experimental`BinaryExport["\<TESTFILE\>", x, "\<Byte\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Export::coerce"],

Cell[BoxData[
    \(Experimental`BinaryExport::"coerce" \(\(:\)\(\ \)\) 
      "Coercing \!\(x\) to \!\(\"Byte\"\) zero."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Export::coerce"],

Cell[BoxData[
    \("TESTFILE"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Export::coerce"]
}, Open  ]],

Cell["Delete the test file.", "Text",
  CellTags->"Export::coerce"],

Cell[BoxData[
    \(DeleteFile["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Export::coerce"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::dffsr", "ObjectNameWarningMessages",
  CellTags->"Export::dffsr"],

Cell[BoxData[
    \(Export::"dffsr" \(\(:\)\(\ \)\) 
      "Cannot export a sound with multiple sample rates."\)], "Message",
  CellTags->"Export::dffsr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Export", "MR"],
  " is used with a ",
  StyleBox["Sound", "MR"],
  " expression that includes more than one sound channel and in which the  \
channels do not all use the same sample rate.\n\[FilledSmallSquare] The  \
sample rate is specified by the value of the ",
  StyleBox["SampleRate", "MR"],
  " option in a ",
  StyleBox["Sound", "MR"],
  " expression."
}], "Notes",
  CellTags->"Export::dffsr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::bitcon", "ObjectNameWarningMessages",
  CellTags->"Export::bitcon"],

Cell[BoxData[
    RowBox[{\(Export::"bitcon" \(\(:\)\(\ \)\) \(BITPIX\ ConversionOption\)\),
       ",", " ", 
      StyleBox["val1",
        "TI"], ",", " ", \(and\ BITPIX\ in\ header\), ",", " ", 
      StyleBox["val2",
        "TI"], ",", 
      " ", \(have\ conflicting\ values . \ 
          Using\ header\ \(\(value\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Export::bitcon"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::bitcon"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::bitrange", "ObjectNameWarningMessages",
  CellTags->"Export::bitrange"],

Cell[BoxData[
    RowBox[{\(Export::"bitrange"\), \(\(:\)\(\ \)\), "BITPIX", " ", "value", 
      " ", 
      StyleBox["val1",
        "TI"], " ", "does", " ", "not", " ", "cover", " ", "data", 
      " ", \(range . \ Try\), " ", "using", " ", 
      RowBox[{
        StyleBox["val2",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Export::bitrange"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::bitrange"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::bitval", "ObjectNameWarningMessages",
  CellTags->"Export::bitval"],

Cell[BoxData[
    RowBox[{\(Export::"bitval"\), \(\(:\)\(\ \)\), "BITPIX", " ", "value", 
      " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", 
      " ", \(\(value\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Export::bitval"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::bitval"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Export::errfile
Import::errfile\
\>", "ObjectNameWarningMessages",
  CellTags->{"Export::errfile", "Import::errfile"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"errfile\"\>"}], \(\(:\)\(\ \)\), "There", " ", 
      "was", " ", "an", " ", "error", " ", "accessing", " ", "the", " ", 
      RowBox[{"file", ".", " ", 
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Export::errfile", "Import::errfile"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Export::errfile", "Import::errfile"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Export::errstruct
Import::errstruct\
\>", "ObjectNameWarningMessages",
  CellTags->{"Export::errstruct", "Import::errstruct"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"errstruct\"\>"}], \(\(:\)\(\ \)\), "\<\"Data structure \
error. `1`.\"\>"}]], "Message",
  CellLabel->"From In[46]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Export::errstruct", "Import::errstruct"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Export::errstruct", "Import::errstruct"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Export::obs
Import::obs\
\>", "ObjectNameWarningMessages",
  CellTags->{"Export::obs", "Import::obs"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"obs\"\>"}], \(\(:\)\(\ \)\), "\<\"`1` is \
obsolete.\"\>"}]], "Message",
  CellLabel->"From In[17]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Export::obs", "Import::obs"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Export::obs", "Import::obs"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Export::obsalt
Import::obsalt\
\>", "ObjectNameWarningMessages",
  CellTags->{"Export::obsalt", "Import::obsalt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"obsalt\"\>"}], \(\(:\)\(\ \)\), "\<\"`1` is obsolete. \
Instead, use `2`.\"\>"}]], "Message",
  CellLabel->"From In[17]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Export::obsalt", "Import::obsalt"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Export::obsalt", "Import::obsalt"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::no2dgr", "ObjectNameWarningMessages",
  CellTags->"Export::no2dgr"],

Cell[BoxData[
    RowBox[{\(Export::"no2dgr"\), \(\(:\)\(\ \)\), 
      RowBox[{"Two", "-", 
        RowBox[{
        "dimensional", " ", "graphics", " ", "objects", " ", "cannot", " ", 
          "be", " ", "exported", " ", "to", " ", 
          StyleBox["expr",
            "TI"], " ", 
          RowBox[{"format", ".", " ", 
            StyleBox["expr",
              "TI"]}], " ", "format", " ", "may", " ", "be", " ", "used", " ",
           "for", " ", "three"}], 
        "-", \(dimensional\ \(\(graphics\)\(.\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Export::no2dgr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::no2dgr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::nocomp", "ObjectNameWarningMessages",
  CellTags->"Export::nocomp"],

Cell[BoxData[
    RowBox[{\(Export::"nocomp"\), \(\(:\)\(\ \)\), "The", " ", "given", " ", 
      "data", " ", "cannot", " ", "be", " ", "exported", " ", "to", " ", 
      StyleBox["expr",
        "TI"], " ", "format", " ", "in", " ", "compressed", 
      " ", \(form . \ The\), " ", "data", " ", "will", " ", "be", " ", 
      "exported", " ", "without", " ", \(\(compression\)\(.\)\)}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Export::nocomp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::nocomp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::nodir", "ObjectNameWarningMessages",
  CellTags->"Export::nodir"],

Cell[BoxData[
    RowBox[{\(Export::"nodir"\), \(\(:\)\(\ \)\), "Directory", " ", 
      StyleBox["expr",
        "TI"], " ", "does", " ", "not", " ", \(\(exist\)\(.\)\)}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Export::nodir"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::nodir"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::autofix", "ObjectNameWarningMessages",
  CellTags->"Export::autofix"],

Cell[BoxData[
    \(Export::"autofix" \(\(:\)\(\ \)\) \(There\ is\ an\ error\ in\ the\ \
SymbolicXML\ expression\ being\ exported . \ 
          An\ automated\ attempt\ has\ been\ made\ to\ fix\ the\ error, \ 
      however\ the\ fix\ may\ yield\ XML\ different\ to\ that\ desired . \ \ \
The\ function\ XML`SymbolicXMLErrors\ will\ detail\ the\ errors\ in\ the\ \
SymbolicXML\ \(\(expression\)\(.\)\)\)\)], "Message",
  CellTags->"Export::autofix"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::autofix"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::badqte", "ObjectNameWarningMessages",
  CellTags->"Export::badqte"],

Cell[BoxData[
    RowBox[{\(Export::"badqte"\), \(\(:\)\(\ \)\), "The", " ", "quote", " ", 
      "character", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", " ", 
      "attribute", " ", "quoting", " ", \(character . \ Attributes\), " ", 
      "in", " ", "the", " ", "exported", " ", "XML", " ", "will", " ", "be", 
      " ", "surrounded", " ", "with", " ", "single", 
      " ", \(\(quotes\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Export::badqte"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::badqte"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::malsxml", "ObjectNameWarningMessages",
  CellTags->"Export::malsxml"],

Cell[BoxData[
    RowBox[{\(Export::"malsxml"\), ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "a", " ", "malformed", " ", "SymbolicXML", 
        " ", \(expression . \ It\), " ", "may", " ", "cause", " ", "errors", 
        " ", "in", " ", "the", " ", "XML", 
        " ", \(\(file\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Export::malsxml"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::malsxml"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::unrecov", "ObjectNameWarningMessages",
  CellTags->"Export::unrecov"],

Cell[BoxData[
    \(Export::"unrecov" \(\(:\)\(\ \)\) \(An\ unrecoverable\ error\ occurred\ \
while\ exporting\ the\ \(\(SymbolicXML\)\(.\)\)\)\)], "Message",
  CellTags->"Export::unrecov"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::unrecov"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::xmlmal", "ObjectNameWarningMessages",
  CellTags->"Export::xmlmal"],

Cell[BoxData[
    RowBox[{\(Export::"xmlmal"\), \(\(:\)\(\ \)\), "Malformed", " ", 
      "SymbolicXML", " ", "expression", " ", 
      StyleBox["expr",
        "TI"], " ", "encountered", " ", "in", 
      " ", \(\(export\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Export::xmlmal"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::xmlmal"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::xmlnopt", "ObjectNameWarningMessages",
  CellTags->"Export::xmlnopt"],

Cell[BoxData[
    RowBox[{\(Export::"xmlnopt"\), \(\(:\)\(\ \)\), "An", " ", "option", " ", 
      "was", " ", "expected", " ", "instead", " ", "of", " ", 
      StyleBox["expr",
        "TI"], " ", "in", " ", "the", " ", "exporting", " ", "of", " ", "the",
       " ", "SymbolicXML", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Export::xmlnopt"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::xmlnopt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Export::fmterr
Import::fmterr\
\>", "ObjectNameWarningMessages",
  CellTags->{"Export::fmterr", "Import::fmterr"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"fmterr\"\>"}], \(\(:\)\(\ \)\), "Invalid", " ", 
      StyleBox["expr",
        "TI"], " ", \(\(format\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Export::fmterr", "Import::fmterr"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by a variety of errors either in the format \
of an expression that is written using ",
  StyleBox["Export", "MR"],
  " or in the format of a file that is read using ",
  StyleBox["Import", "MR"],
  "."
}], "Notes",
  CellTags->{"Export::fmterr", "Import::fmterr"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Export::fmterr", "Import::fmterr"}],

Cell["\<\
An error occurs in this example because the file to be imported \
does not have the specified format.\
\>", "Text",
  CellTags->{"Export::fmterr", "Import::fmterr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<TESTFILE\>", "\<123\>", "\<Text\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Export::fmterr", "Import::fmterr"}],

Cell[BoxData[
    \("TESTFILE"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Export::fmterr", "Import::fmterr"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Import["\<TESTFILE\>", "\<GIF\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Export::fmterr", "Import::fmterr"}],

Cell[BoxData[
    \(Import::"fmterr" \(\(:\)\(\ \)\) 
      "Invalid \!\(\"GIF\"\) format."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"Export::fmterr", "Import::fmterr"}],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Export::fmterr", "Import::fmterr"}]
}, Open  ]],

Cell["Delete the test file.", "Text",
  CellTags->{"Export::fmterr", "Import::fmterr"}],

Cell[BoxData[
    \(DeleteFile["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Export::fmterr", "Import::fmterr"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Export::format
ExportString::format
Import::format
ImportString::format
Experimental`BinaryExport::format
Experimental`BinaryExportString::format
Experimental`BinaryImport::format
Experimental`BinaryImportString::format\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"format\"\>"}], \(\(:\)\(\ \)\), "\<\"`1` is not a \
recognized ImportString format.\"\>"}]], "Message",
  CellLabel->"From In[89]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the requested format is not supported  \
by the indicated function.\n\[FilledSmallSquare] The format is specified in  \
the third argument of ",
  StyleBox["Export", "MR"],
  " or ",
  StyleBox["Import", "MR"],
  ", and in the second argument of ",
  StyleBox["ExportString", "MR"],
  " or ",
  StyleBox["ImportString", "MR"],
  ".\n\[FilledSmallSquare] Valid export formats are listed in the value of ",
  StyleBox["$ExportFormats", "MR"],
  ".  Valid import formats are listed in the value of ",
  StyleBox["$ImportFormats", "MR"],
  ".\n\[FilledSmallSquare] Valid import and export formats may be different  \
in different versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and on different types of computers."
}], "Notes",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid export format."
}], "Text",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString["\<123\>", Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],

Cell[BoxData[
    \(ExportString::"format" \(\(:\)\(\ \)\) 
      "\!\(Automatic\) is not a recognized ExportString format."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->{
  "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format", "Export::format", 
    "ExportString::format", "Import::format", "ImportString::format"}],

Cell[BoxData[
    \(ExportString["123", Automatic]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format", "Export::format", 
    "ExportString::format", "Import::format", "ImportString::format"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid format in ",
  StyleBox["ExportString", "MR"],
  "."
}], "Text",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString["\<123\>", "\<Text\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],

Cell[BoxData[
    \("123"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format", "Export::format", 
    "ExportString::format", "Import::format", "ImportString::format"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Export::guess
Import::guess\
\>", "ObjectNameWarningMessages",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"guess\"\>"}], \(\(:\)\(\ \)\), "Could", " ", 
      "not", " ", "guess", " ", "format", " ", "from", " ", "channel", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Export::guess", "Import::guess"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Export", "MR"],
  " or ",
  StyleBox["Import", "MR"],
  " is unable to determine the format based on the file extension of the  \
indicated channel.\n\[FilledSmallSquare] The third argument in ",
  StyleBox["Export", "MR"],
  " or ",
  StyleBox["Import", "MR"],
  " can be used to specify the format explicitly.\n\[FilledSmallSquare] This  \
message is used only when ",
  StyleBox["Export", "MR"],
  " or ",
  StyleBox["Import", "MR"],
  " is used with two arguments."
}], "Notes",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Export::guess", "Import::guess"}],

Cell["\<\
An error occurs in this example because the file name does not \
include an extension from which to determine the file format.\
\>", "Text",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<TESTFILE\>", "\<123\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[BoxData[
    \(Export::"guess" \(\(:\)\(\ \)\) 
      "Could not guess format from channel \!\(\"TESTFILE\"\)."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[BoxData[
    \(Export["TESTFILE", "123"]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Export::guess", "Import::guess"}]
}, Open  ]],

Cell["\<\
This example shows the use of a file name with a file extension \
that corresponds to text format.\
\>", "Text",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<TESTFILE.TXT\>", "\<123\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[BoxData[
    \("TESTFILE.TXT"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Export::guess", "Import::guess"}]
}, Open  ]],

Cell[TextData[{
  "The same format is written if the format is specified explicitly using the \
 third argument of ",
  StyleBox["Export", "MR"],
  "."
}], "Text",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<TESTFILE\>", "\<123\>", "\<Text\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[BoxData[
    \("TESTFILE"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"Export::guess", "Import::guess"}]
}, Open  ]],

Cell["Remove the test files.", "Text",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[BoxData[
    \(DeleteFile[{"\<TESTFILE\>", "\<TESTFILE.TXT\>"}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Export::guess", "Import::guess"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Export::ignore
Experimental`BinaryExport::ignore\
\>", "ObjectNameWarningMessages",
  CellTags->{"Export::ignore", "Experimental`BinaryExport::ignore"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ignore\"\>"}], \(\(:\)\(\ \)\), "\<\"Ignoring `1` because \
it does not match the `2` format.\"\>"}]], "Message",
  CellLabel->"From In[89]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Export::ignore", "Experimental`BinaryExport::ignore"}],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->{"Export::ignore", "Experimental`BinaryExport::ignore"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::memavail", "ObjectNameWarningMessages",
  CellTags->"Export::memavail"],

Cell[BoxData[
    \(Export::"memavail" \(\(:\)\(\ \)\) 
      "Could not allocate memory for export of `1` format."\)], "Message",
  CellLabel->"From In[90]:=",
  CellTags->"Export::memavail"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Export::memavail"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::memavail", "ObjectNameWarningMessages",
  CellTags->"Import::memavail"],

Cell[BoxData[
    RowBox[{\(Import::"memavail"\), \(\(:\)\(\ \)\), "Could", " ", "not", " ",
       "allocate", " ", "memory", " ", "for", " ", "import", " ", "of", " ", 
      StyleBox["expr",
        "TI"], " ", \(\(format\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Import::memavail"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Import::memavail"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::nofe", "ObjectNameWarningMessages",
  CellTags->"Export::nofe"],

Cell[BoxData[
    \(Export::"nofe" \(\(:\)\(\ \)\) 
      "A front end is not available; export of `1` requires a front end."\)], \
"Message",
  CellLabel->"From In[90]:=",
  CellTags->"Export::nofe"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel is used without the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook front end and export of the indicated format is handled by the \
notebook front end.\n\[FilledSmallSquare] Formats that are handled by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook front end will be different in different versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and on different types of computers."
}], "Notes",
  CellTags->"Export::nofe"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::nomatch", "ObjectNameWarningMessages",
  CellTags->"Export::nomatch"],

Cell[BoxData[
    RowBox[{\(Export::"nomatch"\), \(\(:\)\(\ \)\), "Expression", " ", 
      StyleBox["expr",
        "TI"], " ", "does", " ", "not", " ", "match", " ", "the", " ", 
      "format", " ", 
      RowBox[{
        StyleBox["f",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Export::nomatch"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Export::nomatch"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::type", "ObjectNameWarningMessages",
  CellTags->"Export::type"],

Cell[BoxData[
    RowBox[{\(Export::"type"\), ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "cannot", " ", "be", " ", "exported", " ", "to", " ", 
        "the", " ", 
        StyleBox["f",
          "TI"], " ", \(\(format\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Export::type"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Export", "MR"],
  " is unable to convert the indicated expression into the specified file  \
format.\n\[FilledSmallSquare] The form of expressions that can be exported is \
 different for different file formats."
}], "Notes",
  CellTags->"Export::type"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Export::type"],

Cell[TextData[{
  "An error occurs in this example because only strings can be exported in ",
  StyleBox["Text", "MR"],
  " format."
}], "Text",
  CellTags->"Export::type"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<TESTFILE\>", 123, "\<Text\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Export::type"],

Cell[BoxData[
    \(Export::"type" \(\(:\)\(\ \)\) 
      "\!\(123\) cannot be exported to the \!\(\"Text\"\) format."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Export::type"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Export::type"]
}, Open  ]],

Cell[TextData[{
  "This example uses ",
  StyleBox["Export", "MR"],
  " to write text to a file."
}], "Text",
  CellTags->"Export::type"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<TESTFILE\>", "\<123\>", "\<Text\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Export::type"],

Cell[BoxData[
    \("TESTFILE"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Export::type"]
}, Open  ]],

Cell["Verify that the expected text was written to the file.", "Text",
  CellTags->"Export::type"],

Cell[BoxData[
    \(DeleteFile["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Export::type"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Export::unsupfmt
Import::unsupfmt\
\>", "ObjectNameWarningMessages",
  CellTags->{"Export::unsupfmt", "Import::unsupfmt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"unsupfmt\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      StyleBox["f",
        "TI"], " ", "format", " ", "is", " ", "not", " ", "currently", " ", 
      "supported", " ", "on", " ", "this", 
      " ", \(\(platform\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Export::unsupfmt", "Import::unsupfmt"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated file format is \
not supported on the type of computer that is in use.
\[FilledSmallSquare] This message is used for system-specific file formats, \
such as PICT (which is normally available only on Macintosh computers) and \
Metafile (which is normally available only on Windows computers).\
\>", \
"Notes",
  CellTags->{"Export::unsupfmt", "Import::unsupfmt"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::createdir", "ObjectNameWarningMessages",
  CellTags->"Export::createdir"],

Cell[BoxData[
    \(Export::"createdir" \(\(:\)\(\ \)\) 
      "Export assumed `1` to be a directory into which to write an index.html \
file, but was unable to create this directory for you. Either create this \
directory and re-run HTMLSave, or choose a different destination for the HTML \
file."\)], "Message",
  CellLabel->"From In[17]:=",
  CellTags->"Export::createdir"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Export", "MR"],
  " is unable to create the indicated directory."
}], "Notes",
  CellTags->"Export::createdir"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get::notencode", "ObjectNameWarningMessages",
  CellTags->"Get::notencode"],

Cell[BoxData[
    \(Get::"notencode" \(\(:\)\(\ \)\) 
      "Warning: the file `1` is not encoded."\)], "Message",
  CellLabel->"From In[90]:=",
  CellTags->"Get::notencode"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Get", "MR"],
  " is used with a second argument and the file named in the first argument  \
is not encoded.\n\[FilledSmallSquare] The second argument in ",
  StyleBox["Get", "MR"],
  " is a key used to decode files created using ",
  StyleBox["Encode", "MR"],
  ".\n\[FilledSmallSquare] When this message is generated, the file is read \
without any decoding."
}], "Notes",
  CellTags->"Get::notencode"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Get::notencode"],

Cell[TextData[{
  "A warning message is generated in this example because the file that is \
loaded using ",
  StyleBox["Get", "MR"],
  " is not encoded, so no decoding key is necessary."
}], "Text",
  CellTags->"Get::notencode"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Write["\<TESTFILE\>", "\<123\>"]; Close["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Get::notencode"],

Cell[BoxData[
    \("TESTFILE"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Get::notencode"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Get["\<TESTFILE\>", 123]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Get::notencode"],

Cell[BoxData[
    \(Get::"notencode" \(\(:\)\(\ \)\) 
      "Warning: the file \!\(\"TESTFILE\"\) is not encoded."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"Get::notencode"],

Cell[BoxData[
    \("123"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Get::notencode"]
}, Open  ]],

Cell["Remove the test file.", "Text",
  CellTags->"Get::notencode"],

Cell[BoxData[
    \(DeleteFile["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Get::notencode"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::fnfnd", "ObjectNameWarningMessages",
  CellTags->"Import::fnfnd"],

Cell[BoxData[
    \(Import::"fnfnd" \(\(:\)\(\ \)\) "`1`: file not found."\)], "Message",
  CellLabel->"From In[91]:=",
  CellTags->"Import::fnfnd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Import", "MR"],
  " is unable to find the indicated file."
}], "Notes",
  CellTags->"Import::fnfnd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::imgsze", "ObjectNameWarningMessages",
  CellTags->"Import::imgsze"],

Cell[BoxData[
    \(Import::"imgsze" \(\(:\)\(\ \)\) 
      "`1` dimensions cannot be determined automatically. Specify the size \
with the Dimensions option."\)], "Message",
  CellLabel->"From In[91]:=",
  CellTags->"Import::imgsze"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Import", "MR"],
  " is unable to determine the size of an image based on information  \
contained in the image file."
}], "Notes",
  CellTags->"Import::imgsze"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::intp", "ObjectNameWarningMessages",
  CellTags->"Import::intp"],

Cell[BoxData[
    \(Import::"intp" \(\(:\)\(\ \)\) 
      "`1` is not a positive integer."\)], "Message",
  CellLabel->"From In[91]:=",
  CellTags->"Import::intp"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Import::intp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::nffil", "ObjectNameWarningMessages",
  CellTags->"Import::nffil"],

Cell[BoxData[
    \(Import::"nffil" \(\(:\)\(\ \)\) 
      "File not found during `1`."\)], "Message",
  CellLabel->"From In[91]:=",
  CellTags->"Import::nffil"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a file needed during evaluation of the \
 indicated expression was not found.\n\[FilledSmallSquare] This message is  \
redundant to the ",
  StyleBox["General::nffil", "MR"],
  " message.\n\[FilledSmallSquare] The directories that are searched in  \
attempting to find an external file are listed in the value of the global  \
variable ",
  StyleBox["$Path", "MR"],
  "."
}], "Notes",
  CellTags->"Import::nffil"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::nlist", "ObjectNameWarningMessages",
  CellTags->"Import::nlist"],

Cell[BoxData[
    \(Import::"nlist" \(\(:\)\(\ \)\) 
      "`1` is not a list of strings."\)], "Message",
  CellLabel->"From In[92]:=",
  CellTags->"Import::nlist"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Import::nlist"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::nlist2", "ObjectNameWarningMessages",
  CellTags->"Import::nlist2"],

Cell[BoxData[
    RowBox[{\(Import::"nlist2"\), ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "list", " ", "of", " ",
         "two", " ", \(\(elements\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Import::nlist2"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Import::nlist2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["ImportString::string", "ObjectNameWarningMessages",
  CellTags->"ImportString::string"],

Cell[BoxData[
    \(ImportString::"string" \(\(:\)\(\ \)\) 
      "First argument `1` is not a string."\)], "Message",
  CellLabel->"From In[92]:=",
  CellTags->"ImportString::string"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["ImportString", "MR"],
  " is not a string."
}], "Notes",
  CellTags->"ImportString::string"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ImportString::string"],

Cell["\<\
An error occurs in this example because the first argument is not a \
string.\
\>", "Text",
  CellTags->"ImportString::string"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString[123, Text]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ImportString::string"],

Cell[BoxData[
    \(ImportString::"string" \(\(:\)\(\ \)\) 
      "First argument \!\(123\) is not a string."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ImportString::string"],

Cell[BoxData[
    \(ImportString[123, Text]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ImportString::string"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ImportString", "MR"],
  "."
}], "Text",
  CellTags->"ImportString::string"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<123\>", "\<Text\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ImportString::string"],

Cell[BoxData[
    \("123"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ImportString::string"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::nodta", "ObjectNameWarningMessages",
  CellTags->"Import::nodta"],

Cell[BoxData[
    \(Import::"nodta" \(\(:\)\(\ \)\) 
      "Insufficient data found for `1` format."\)], "Message",
  CellLabel->"From In[92]:=",
  CellTags->"Import::nodta"],

Cell["\<\
\[FilledSmallSquare] Generated when a file to be imported lacks \
data expected for the indicated format.\
\>", "Notes",
  CellTags->"Import::nodta"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::unsup", "ObjectNameWarningMessages",
  CellTags->"Import::unsup"],

Cell[BoxData[
    \(Import::"unsup" \(\(:\)\(\ \)\) 
      "Unsupported `1` format type."\)], "Message",
  CellLabel->"From In[92]:=",
  CellTags->"Import::unsup"],

Cell["\<\
\[FilledSmallSquare] Generated when a file to be imported is in an \
unsupported format.
\[FilledSmallSquare] This message is generated for files such as bitmap files \
that use an unsupported bit depth or sound files that use an unsupported \
sample rate.\
\>", "Notes",
  CellTags->"Import::unsup"]
}, Open  ]],

Cell[CellGroupData[{

Cell["$NumberMarks::nmarkset", "ObjectNameWarningMessages",
  CellTags->"$NumberMarks::nmarkset"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\($NumberMarks::"nmarkset"\), \(\(:\)\(\ \)\), "Cannot", " ", 
          "set", " ", 
          StyleBox["sym",
            "TI"], " ", "to", " ", 
          StyleBox["val",
            "TI"]}], ";", " ", \(value\ must\ be\ one\ of\ True\)}], ",", " ",
       "False", ",", " ", \(and\ \(\(Automatic\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"$NumberMarks::nmarkset"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set the value of ",
  StyleBox["$NumberMarks", "MR"],
  " to a value other than ",
  StyleBox["True", "MR"],
  ", ",
  StyleBox["False", "MR"],
  ", or ",
  StyleBox["Automatic", "MR"],
  "."
}], "Notes",
  CellTags->"$NumberMarks::nmarkset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$NumberMarks::nmarkset"],

Cell[TextData[{
  "The value of ",
  StyleBox["$NumberMarks", "MR"],
  " cannot be set to ",
  StyleBox["None", "MR"],
  ".  When this error occurs, the value of ",
  StyleBox["$NumberMarks", "MR"],
  " is unchanged."
}], "Text",
  CellTags->"$NumberMarks::nmarkset"],

Cell[CellGroupData[{

Cell[BoxData[
    \($NumberMarks = None\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$NumberMarks::nmarkset"],

Cell[BoxData[
    \($NumberMarks::"nmarkset" \(\(:\)\(\ \)\) 
      "Cannot set \!\($NumberMarks\) to \!\(None\); value must be one of \
True, False, and Automatic."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$NumberMarks::nmarkset"],

Cell[BoxData[
    \(None\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$NumberMarks::nmarkset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Integrate::diffend", "ObjectNameWarningMessages",
  CellTags->"Integrate::diffend"],

Cell[BoxData[
    \(Integrate::"diffend" \(\(:\)\(\ \)\) 
      "`1` cannot be interpreted since `2` is followed by `3`. It may be \
necessary to use parentheses to ensure that `2` appears at the end of the \
integral."\)], "Message",
  CellLabel->"From In[93]:=",
  CellTags->"Integrate::diffend"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the differential used to specify the  \
variable of integration is not the last element in a typeset ",
  StyleBox["Integrate", "MR"],
  " expression."
}], "Notes",
  CellTags->"Integrate::diffend"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Integrate::diffend"],

Cell["\<\
An error occurs in this example because the integrand occurs after \
the differential expression.\
\>", "Text",
  CellTags->"Integrate::diffend"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\[DifferentialD]x\ x\ Cos[x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::diffend"],

Cell[BoxData[
    \(Integrate::"diffend" \(\(:\)\(\ \)\) 
      "\!\(\[Integral] \(\(\(\(\[DifferentialD] x\)\)x\(\(Cos[x]\)\)\)\)\) \
cannot be interpreted since \!\(\[DifferentialD] x\) is followed by \
\!\(x\(\(Cos[x]\)\)\). It may be necessary to use parentheses to ensure that \
\!\(\[DifferentialD] x\) appears at the end of the integral."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Integrate::diffend"],

Cell[BoxData[
    StyleBox[
      ErrorBox[\(\[Integral]\[DifferentialD]x  x  Cos[x]\)],
      ShowStringCharacters->True]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Integrate::diffend"]
}, Open  ]],

Cell["This shows a valid typeset input for an integral.", "Text",
  CellTags->"Integrate::diffend"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]x\ Cos[x] \[DifferentialD]x\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Integrate::diffend"],

Cell[BoxData[
    \(Cos[x] + x\ Sin[x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Integrate::diffend"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToExpression::notstrbox", "ObjectNameWarningMessages",
  CellTags->"ToExpression::notstrbox"],

Cell[BoxData[
    \(ToExpression::"notstrbox" \(\(:\)\(\ \)\) 
      "`1` is not a string or a box. ToExpression can only interpret strings \
or boxes as Mathematica input."\)], "Message",
  CellLabel->"From In[93]:=",
  CellTags->"ToExpression::notstrbox"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["ToExpression", "MR"],
  " is not a string or a typeset box expression."
}], "Notes",
  CellTags->"ToExpression::notstrbox"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ToExpression::notstrbox"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["ToExpression", "MR"],
  " does not have the expected form."
}], "Text",
  CellTags->"ToExpression::notstrbox"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[E + Pi]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ToExpression::notstrbox"],

Cell[BoxData[
    \(ToExpression::"notstrbox" \(\(:\)\(\ \)\) 
      "\!\(\[ExponentialE] + \[Pi]\) is not a string or a box. ToExpression \
can only interpret strings or boxes as Mathematica input."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ToExpression::notstrbox"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ToExpression::notstrbox"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid typeset box expression as the argument in ",
  StyleBox["ToExpression", "MR"],
  "."
}], "Text",
  CellTags->"ToExpression::notstrbox"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[RowBox[{"\<E\>", "\<+\>", "\<Pi\>"}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ToExpression::notstrbox"],

Cell[BoxData[
    \(\[ExponentialE] + \[Pi]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ToExpression::notstrbox"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Syntax::com", "ObjectNameWarningMessages",
  CellTags->"Syntax::com"],

Cell[BoxData[
    \(Syntax::"com" \(\(:\)\(\ \)\) 
      "Warning: comma encountered with no adjacent expression; the expression \
will be treated as Null. `1`"\)], "Message",
  CellLabel->"From In[93]:=",
  CellTags->"Syntax::com"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a comma is encountered in input and  \
the expression before or after the comma is not explicitly included.\n\
\[FilledSmallSquare] This is a warning message to indicate that the input may \
 include an extra comma or a missing expression, but this message does not  \
necessary indicate an error.\n\[FilledSmallSquare] This message is used for \
",
  StyleBox["InputForm", "MR"],
  " input such as input read from a file."
}], "Notes",
  CellTags->"Syntax::com"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Syntax::com"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["ToExpression", "MR"],
  " does not have the expected form."
}], "Text",
  CellTags->"Syntax::com"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<If[True,1,0,]\>", InputForm]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Syntax::com"],

Cell[BoxData[
    \(Syntax::"com" \(\(:\)\(\ \)\) 
      "Warning: comma encountered with no adjacent expression; the expression \
will be treated as Null. \!\(\"\\n\"\)"\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Syntax::com"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Syntax::com"]
}, Open  ]],

Cell["\<\
This message can be avoided by removing the extra comma or by \
explicitly specifying the expressions on both sides of each comma.\
\>", \
"Text",
  CellTags->"Syntax::com"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<If[True,1,0,Null]\>", InputForm]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Syntax::com"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Syntax::com"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`BinaryExport::coerce", "ObjectNameWarningMessages",
  CellTags->"Experimental`BinaryExport::coerce"],

Cell[BoxData[
    \(Experimental`BinaryExport::"coerce" \(\(:\)\(\ \)\) \(Coercing\ `1`\ to\
\ `2`\ \(\(zero\)\(.\)\)\)\)], "Message",
  CellTags->"Experimental`BinaryExport::coerce"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`BinaryExport::coerce"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`BinaryExport::nomatch", "ObjectNameWarningMessages",
  CellTags->"Experimental`BinaryExport::nomatch"],

Cell[BoxData[
    \(Experimental`BinaryExport::"nomatch" \(\(:\)\(\ \)\) \(Expression\ `1`\ \
does\ not\ match\ the\ format\ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"Experimental`BinaryExport::nomatch"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`BinaryExport::nomatch"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`BinaryImport::nffil", "ObjectNameWarningMessages",
  CellTags->"Experimental`BinaryImport::nffil"],

Cell[BoxData[
    \(Experimental`BinaryImport::"nffil" \(\(:\)\(\ \)\) \(File\ not\ found\ \
during\ \(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"Experimental`BinaryImport::nffil"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`BinaryImport::nffil"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::dxfemp", "ObjectNameWarningMessages",
  CellTags->"Import::dxfemp"],

Cell[BoxData[
    \(Import::"dxfemp" \(\(:\)\(\ \)\) \(The\ DXF\ file\ being\ imported\ \
does\ not\ have\ any\ recognizable\ \(\(entities\)\(.\)\)\)\)], "Message",
  CellTags->"Import::dxfemp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::dxfemp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::dxfflg", "ObjectNameWarningMessages",
  CellTags->"Import::dxfflg"],

Cell[BoxData[
    \(Import::"dxfflg" \(\(:\)\(\ \)\) \(No\ flag\ found\ in\ DXF\ POLYLINE\ \
entity . \ Omitting\ this\ \(\(entity\)\(.\)\)\)\)], "Message",
  CellTags->"Import::dxfflg"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::dxfflg"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::dxflin", "ObjectNameWarningMessages",
  CellTags->"Import::dxflin"],

Cell[BoxData[
    \(Import::"dxflin" \(\(:\)\(\ \)\) \(No\ starting\ point\ x\ coordinate\ \
or\ ending\ point\ z\ coordinate\ found\ in\ DXF\ LINE\ entity . \ 
          Omitting\ this\ \(\(entity\)\(.\)\)\)\)], "Message",
  CellTags->"Import::dxflin"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::dxflin"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::dxfply", "ObjectNameWarningMessages",
  CellTags->"Import::dxfply"],

Cell[BoxData[
    \(Import::"dxfply" \(\(:\)\(\ \)\) \(Encountered\ DXF\ POLYLINE\ entity\ \
that\ is\ not\ a\ polyface\ mesh . \ 
          Omitting\ this\ \(\(entity\)\(.\)\)\)\)], "Message",
  CellTags->"Import::dxfply"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::dxfply"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::dxfvbf", "ObjectNameWarningMessages",
  CellTags->"Import::dxfvbf"],

Cell[BoxData[
    \(Import::"dxfvbf" \(\(:\)\(\ \)\) \(Encountered\ DXF\ POLYLINE\ entity\ \
with\ an\ unsupported\ vertex\ bit\ field . \ 
          Omitting\ this\ \(\(vertex\)\(.\)\)\)\)], "Message",
  CellTags->"Import::dxfvbf"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::dxfvbf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::nonintyear", "ObjectNameWarningMessages",
  CellTags->"Import::nonintyear"],

Cell[BoxData[
    \(Import::"nonintyear" \(\(:\)\(\ \)\) 
      "The two-digit-year conversion function produced the non-integer value \
`2` when Import attempted to interpret the field `1` as a date. This field \
will be interpreted as a string instead. Check that the value set for \
\"TwoDigitYearFunction\" in Import's ConversionOptions is correct; typically, \
it is a function that expects an integer from 0 to 99 as the argument and \
returns an integer representing the full year."\)], "Message",
  CellLabel->"From In[93]:=",
  CellTags->"Import::nonintyear"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::nonintyear"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::costr", "ObjectNameWarningMessages",
  CellTags->"Import::costr"],

Cell[BoxData[
    \(Import::"costr" \(\(:\)\(\ \)\) \(`1`\ in\ `2`\ is\ not\ a\ String . \ \
\ ConversionOptions\ must\ be\ specified\ as\ string\ \
\(\(options\)\(.\)\)\)\)], "Message",
  CellTags->"Import::costr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::costr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::malxml", "ObjectNameWarningMessages",
  CellTags->"Import::malxml"],

Cell[BoxData[
    \(Import::"malxml" \(\(:\)\(\ \)\) \(There\ was\ a\ serious\ error\ \
during\ \(parsing\ --\)\ the\ input\ is\ not\ a\ well - 
        formed\ XML\ \(\(document\)\(.\)\)\)\)], "Message",
  CellTags->"Import::malxml"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::malxml"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::pdtder", "ObjectNameWarningMessages",
  CellTags->"Import::pdtder"],

Cell[BoxData[
    \(Import::"pdtder" \(\(:\)\(\ \)\) 
      "There was an error parsing the XML document.  This may be due to \
undeclared entities in the XML document, or an error loading the DTD.  Check \
that entities are correctly declared or use the \"AllowUnrecognizedEntities\" \
conversion option."\)], "Message",
  CellLabel->"From In[94]:=",
  CellTags->"Import::pdtder"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::pdtder"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::unrecxml", "ObjectNameWarningMessages",
  CellTags->"Import::unrecxml"],

Cell[BoxData[
    \(Import::"unrecxml" \(\(:\)\(\ \)\) 
      "The document was not a recognized type of XML.  Try Importing as a \
general \"XML\" document."\)], "Message",
  CellLabel->"From In[94]:=",
  CellTags->"Import::unrecxml"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::unrecxml"]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathMLForm::boxfmt", "ObjectNameWarningMessages",
  CellTags->"MathMLForm::boxfmt"],

Cell[BoxData[
    \(MathMLForm::"boxfmt" \(\(:\)\(\ \)\) \(The\ default\ typesetting\ \
format\ used\ by\ MathMLForm\ is\ set\ in\ Internal`1`$DefaultMathMLBoxFormat \
. \ The\ current\ value\ `2`\ is\ not\ valid; \ 
      it\ must\ be\ a\ member\ of\ $BoxForms . \ 
          MathMLForm\ will\ resort\ to\ \(\(TraditionalForm\)\(.\)\)\)\)], \
"Message",
  CellTags->"MathMLForm::boxfmt"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"MathMLForm::boxfmt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`RegisterConverter::extensions", "ObjectNameWarningMessages",
  CellTags->"Experimental`RegisterConverter::extensions"],

Cell[BoxData[
    \(Experimental`RegisterConverter::"extensions" \(\(:\)\(\ \)\) \(Third\ \
argument\ should\ be\ a\ list\ of\ strings, \ 
      and\ not\ \(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"Experimental`RegisterConverter::extensions"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`RegisterConverter::extensions"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`RegisterConverter::mode", "ObjectNameWarningMessages",
  CellTags->"Experimental`RegisterConverter::mode"],

Cell[BoxData[
    \(Experimental`RegisterConverter::"mode" \(\(:\)\(\ \)\) \(First\ \
argument\ should\ be\ either\ Import\ or\ Export, \ 
      and\ not\ \(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"Experimental`RegisterConverter::mode"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`RegisterConverter::mode"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`RegisterConverter::noexe", "ObjectNameWarningMessages",
  CellTags->"Experimental`RegisterConverter::noexe"],

Cell[BoxData[
    \(Experimental`RegisterConverter::"noexe" \(\(:\)\(\ \)\) \(Could\ not\ \
find\ the\ executable\ `1`\ in\ any\ of\ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"Experimental`RegisterConverter::noexe"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`RegisterConverter::noexe"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`RegisterConverter::source", "ObjectNameWarningMessages",
  CellTags->"Experimental`RegisterConverter::source"],

Cell[BoxData[
    \(Experimental`RegisterConverter::"source" \(\(:\)\(\ \)\) \(Fourth\ \
argument\ should\ be\ a\ string, \ pair\ of\ strings, \ or\ None, \ 
      and\ not\ \(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"Experimental`RegisterConverter::source"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`RegisterConverter::source"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::boxfmt", "ObjectNameWarningMessages",
  CellTags->"General::boxfmt"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"boxfmt\"\>"}], \(\(:\)\(\ \)\), \(`1`\ in\ `2`\ is\ not\ a\
\ box\ formatting\ type . \ 
          A\ box\ formatting\ type\ is\ any\ member\ of\ \(\($BoxForms\)\(.\)\
\)\)}]], "Message",
  CellTags->"General::boxfmt"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated argument is not one of \
the formatting types listed in the value of ",
  StyleBox["$BoxForms", "MR"],
  ".\n\[FilledSmallSquare] This message can be generated by an incorrect \
value for the second argument in ",
  StyleBox["ToBoxes", "MR"],
  "."
}], "Notes",
  CellTags->"General::boxfmt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::boxfmt"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["OutputForm", "MR"],
  " is not a valid formatting type for use in ",
  StyleBox["ToBoxes", "MR"],
  "."
}], "Text",
  CellTags->"General::boxfmt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToBoxes[Cos[1], OutputForm]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::boxfmt"],

Cell[BoxData[
    \(ToBoxes::"boxfmt" \(\(:\)\(\ \)\) 
      "\!\(OutputForm\) in \!\(ToBoxes[\(\(\(\(Cos[1]\)\), OutputForm\)\)]\) \
is not a box formatting type. A box formatting type is any member of \
$BoxForms."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::boxfmt"],

Cell[BoxData[
    \(ToBoxes[Cos[1], OutputForm]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::boxfmt"]
}, Open  ]],

Cell[TextData[{
  "Valid formatting types for use in ",
  StyleBox["ToBoxes", "MR"],
  " are listed in the value of ",
  StyleBox["$BoxForms", "MR"],
  "."
}], "Text",
  CellTags->"General::boxfmt"],

Cell[CellGroupData[{

Cell[BoxData[
    \($BoxForms\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::boxfmt"],

Cell[BoxData[
    \({StandardForm, TraditionalForm, NewForm}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::boxfmt"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ToBoxes", "MR"],
  "."
}], "Text",
  CellTags->"General::boxfmt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToBoxes[Cos[1], TraditionalForm]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::boxfmt"],

Cell[BoxData[
    \(FormBox[RowBox[{"cos", "(", "1", ")"}], TraditionalForm]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::boxfmt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::byteord", "ObjectNameWarningMessages",
  CellTags->"General::byteord"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"byteord\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
ByteOrdering\  -> \ `1`\ should\ be\ 1\ or\  - 1. \)}]], "Message",
  CellTags->"General::byteord"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::byteord"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::conopt", "ObjectNameWarningMessages",
  CellTags->"General::conopt"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"conopt\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
ConversionOptions\  -> \ `1`\ is\ not\ a\ string\ option\ or\ a\ list\ of\ \
string\ \(\(options\)\(.\)\)\)}]], "Message",
  CellTags->"General::conopt"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::conopt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::interpfmt", "ObjectNameWarningMessages",
  CellTags->"General::interpfmt"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"interpfmt\"\>"}], \(\(:\)\(\ \)\), \(`1`\ is\ not\ a\ \
valid\ interpretation\ format . \ 
          Valid\ interpretation\ formats\ include\ InputForm\ and\ any\ \
member\ of\ \(\($BoxForms\)\(.\)\)\)}]], "Message",
  CellTags->"General::interpfmt"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::interpfmt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::notstr", "ObjectNameWarningMessages",
  CellTags->"General::notstr"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"notstr\"\>"}], \(\(:\)\(\ \)\), \(The\ format\ type\ `1`\ \
is\ valid\ only\ for\ string\ \(\(input\)\(.\)\)\)}]], "Message",
  CellTags->"General::notstr"],

Cell[TextData[{
  "\[FilledSmallSquare] This message can be generated when the second \
argument in ",
  StyleBox["ToExpression", "MR"],
  " is ",
  StyleBox["InputForm", "MR"],
  " and the first argument is not a string."
}], "Notes",
  CellTags->"General::notstr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::notstr"],

Cell[TextData[{
  "An error occurs in this example because a ",
  StyleBox["RowBox", "MR"],
  " expression is not valid ",
  StyleBox["InputForm", "MR"],
  " input."
}], "Text",
  CellTags->"General::notstr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[RowBox[{"\<2\>", "\<+\>", "\<Pi\>"}], 
      InputForm]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::notstr"],

Cell[BoxData[
    \(ToExpression::"notstr" \(\(:\)\(\ \)\) 
      "The format type \!\(InputForm\) is valid only for string input."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::notstr"],

Cell[BoxData[
    \(ToExpression[RowBox[{"2", "+", "Pi"}], InputForm]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::notstr"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid ",
  StyleBox["InputForm", "MR"],
  " input."
}], "Text",
  CellTags->"General::notstr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<2 + Pi\>", InputForm]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::notstr"],

Cell[BoxData[
    \(2 + \[Pi]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::notstr"]
}, Open  ]],

Cell[TextData[{
  "A ",
  StyleBox["RowBox", "MR"],
  " expression can be used for typeset input, such as input in ",
  StyleBox["StandardForm", "MR"],
  "."
}], "Text",
  CellTags->"General::notstr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[RowBox[{"\<2\>", "\<+\>", "\<Pi\>"}], 
      StandardForm]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::notstr"],

Cell[BoxData[
    \(2 + \[Pi]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::notstr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MessageName::messg", "ObjectNameWarningMessages",
  CellTags->"MessageName::messg"],

Cell[BoxData[
    RowBox[{\(MessageName::"messg"\), ":", " ", 
      RowBox[{
        StyleBox["lhs",
          "TI"], " ", "cannot", " ", "be", " ", "set", " ", "to", " ", 
        RowBox[{
          StyleBox["rhs",
            "TI"], ".", " ", "It"}], " ", "must", " ", "be", " ", "set", " ", 
        "to", " ", "a", " ", \(\(string\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"MessageName::messg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set a message to a value \
that is not a string.\n\[FilledSmallSquare] ",
  StyleBox["MessageName[", "MR"],
  StyleBox["sym", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["tag", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " is the full notation for ",
  StyleBox["sym", "MR",
    FontSlant->"Italic"],
  StyleBox["::", "MR"],
  StyleBox["tag", "MR",
    FontSlant->"Italic"],
  ", which is used to identify messages associated with symbols."
}], "Notes",
  CellTags->"MessageName::messg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"MessageName::messg"],

Cell[TextData[{
  "A message cannot be set to ",
  StyleBox["Null", "MR"],
  ".  The right-hand side of the assignment must be a string."
}], "Text",
  CellTags->"MessageName::messg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f::err = Null\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"MessageName::messg"],

Cell[BoxData[
    \(MessageName::"messg" \(\(:\)\(\ \)\) 
      "\!\(f :: \"err\"\) cannot be set to \!\(Null\). It must be set to a \
string."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"MessageName::messg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get::enkey", "ObjectNameWarningMessages",
  CellTags->"Get::enkey"],

Cell[BoxData[
    \(Get::"enkey" \(\(:\)\(\ \)\) \(Cannot\ decode\ encoded\ file; \ 
      incorrect\ key\ or\ \(\(machine\)\(.\)\)\)\)], "Message",
  CellTags->"Get::enkey"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the password needed to read an encoded \
file is missing or incorrect or can only be used on a particular computer.\n\
\[FilledSmallSquare] An encoded package file is created using ",
  StyleBox["Encode[\"", "MR"],
  StyleBox["file", "TI"],
  StyleBox["\", \"", "MR"],
  StyleBox["dest", "TI"],
  StyleBox["\", \"", "MR"],
  StyleBox["key", "TI"],
  StyleBox["\"]", "MR"],
  ".\n\[FilledSmallSquare] If you see this message and you believe that you \
are using the correct key, contact the author of the encoded file, or contact \
Technical Support."
}], "Notes",
  CellTags->"Get::enkey"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Save::wtype", "ObjectNameWarningMessages",
  CellTags->"Save::wtype"],

Cell[BoxData[
    \(Save::"wtype" \(\(:\)\(\ \)\) 
      "`1` in `2` must be a symbol, a string or a list of symbols and \
strings."\)], "Message",
  CellLabel->"From In[94]:=",
  CellTags->"Save::wtype"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Save", "MR"],
  " does not have the expected form."
}], "Notes",
  CellTags->"Save::wtype"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Save::wtype"],

Cell[TextData[{
  "The second argument in ",
  StyleBox["Save", "MR"],
  " cannot be a list of numbers."
}], "Text",
  CellTags->"Save::wtype"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Save["\<file\>", {1, 2, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Save::wtype"],

Cell[BoxData[
    \(Save::"wtype" \(\(:\)\(\ \)\) 
      "\!\({1, 2, 3}\) in \!\(Save[\(\(\"file\", \(\({1, 2, 3}\)\)\)\)]\) \
must be a symbol, a string or a list of symbols and strings."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Save::wtype"],

Cell[BoxData[
    \(Save["file", {1, 2, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Save::wtype"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Close::spfile", "ObjectNameWarningMessages",
  CellTags->"Close::spfile"],

Cell[BoxData[
    RowBox[{\(Close::"spfile"\), \(\(:\)\(\ \)\), \(\(Cannot\)\(\ \)\(close\)\
\(\ \)\(special\)\(\ \)\(file\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Close::spfile"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to close a file that must \
remain open.\n\[FilledSmallSquare] Normally the only files that cannot be \
closed are standard input and standard error files that are used by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to communicate with your computer.  The nature of these files is \
different on different types of computers."
}], "Notes",
  CellTags->"Close::spfile"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Close::spfile"],

Cell[TextData[{
  "The first file in the list returned by ",
  StyleBox["Streams[]", "MR"],
  " is normally a file that cannot be closed."
}], "Text",
  CellTags->"Close::spfile"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Close[First[Streams[]]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Close::spfile"],

Cell[BoxData[
    \(Close::"spfile" \(\(:\)\(\ \)\) 
      "Cannot close special file \!\(OutputStream[\(\(\"stdout\", \
1\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Close::spfile"],

Cell[BoxData[
    \(Close[OutputStream["stdout", 1]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Close::spfile"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DumpGet::bgbf", "ObjectNameWarningMessages",
  CellTags->"DumpGet::bgbf"],

Cell[BoxData[
    RowBox[{\(DumpGet::"bgbf"\), \(\(:\)\(\ \)\), \(\(File\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(cannot\ be\ loaded, \ 
      it\ is\ corrupted\ or\ is\ written\ on\ a\ different\ \
\(\(machine\)\(.\)\)\)\)}]], "Message",
  CellTags->"DumpGet::bgbf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated file cannot be loaded \
into the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel using ",
  StyleBox["DumpGet", "MR"],
  ".\n\[FilledSmallSquare] Files loaded using ",
  StyleBox["DumpGet", "MR"],
  " are normally created using ",
  StyleBox["DumpSave", "MR"],
  " on the same computer or on an equivalent computer.  Files created using \
",
  StyleBox["DumpSave", "MR"],
  " are not portable between computers."
}], "Notes",
  CellTags->"DumpGet::bgbf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"DumpGet::bgbf"],

Cell[TextData[{
  "An error occurs in this example because a file created using ",
  StyleBox["Save", "MR"],
  " does not have the correct format to be loaded using ",
  StyleBox["DumpGet", "MR"],
  "."
}], "Text",
  CellTags->"DumpGet::bgbf"],

Cell[BoxData[
    \(dsym\  = \ 99; \ Save["\<dsym.mx\>", \ dsym]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"DumpGet::bgbf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DumpGet["\<dsym.mx\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"DumpGet::bgbf"],

Cell[BoxData[
    \(DumpGet::"bgbf" \(\(:\)\(\ \)\) 
      "File \!\(\"dsym.mx\"\) cannot be loaded, it is corrupted or is written \
on a different machine."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"DumpGet::bgbf"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"DumpGet::bgbf"]
}, Open  ]],

Cell[TextData[{
  "A file created using ",
  StyleBox["DumpSave", "MR"],
  " can be loaded on the same computer using ",
  StyleBox["DumpGet", "MR"],
  "."
}], "Text",
  CellTags->"DumpGet::bgbf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DumpSave["\<dsym.mx\>", \ dsym]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"DumpGet::bgbf"],

Cell[BoxData[
    \({99}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"DumpGet::bgbf"]
}, Open  ]],

Cell[BoxData[
    \(DumpGet["\<dsym.mx\>"]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"DumpGet::bgbf"],

Cell["Delete the file.", "Text",
  CellTags->"DumpGet::bgbf"],

Cell[BoxData[
    \(DeleteFile["\<dsym.mx\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"DumpGet::bgbf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DumpGet::bgchk", "ObjectNameWarningMessages",
  CellTags->"DumpGet::bgchk"],

Cell[BoxData[
    \(DumpGet::"bgchk" \(\(:\)\(\ \)\) 
      "Checksum in binary file `1` does not agree."\)], "Message",
  CellLabel->"From In[94]:=",
  CellTags->"DumpGet::bgchk"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a check on the form of a file to be \
loaded using ",
  StyleBox["DumpGet", "MR"],
  " fails.\n\[FilledSmallSquare] This message is not used in the current \
version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] Files loaded using ",
  StyleBox["DumpGet", "MR"],
  " are normally created using ",
  StyleBox["DumpSave", "MR"],
  " on the same computer or on an equivalent computer.  Files created using \
",
  StyleBox["DumpSave", "MR"],
  " are not portable between computers."
}], "Notes",
  CellTags->"DumpGet::bgchk"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DumpGet::bgcor", "ObjectNameWarningMessages",
  CellTags->"DumpGet::bgcor"],

Cell[BoxData[
    RowBox[{\(DumpGet::"bgcor"\), \(\(:\)\(\ \)\), \(\(Binary\)\(\ \)\(file\)\
\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ \(\(corrupted\)\(.\)\)\)\)}]], "Message",
  CellTags->"DumpGet::bgcor"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a check on the form of a file to be \
loaded using ",
  StyleBox["DumpGet", "MR"],
  " fails.\n\[FilledSmallSquare] Files loaded using ",
  StyleBox["DumpGet", "MR"],
  " are normally created using ",
  StyleBox["DumpSave", "MR"],
  " on the same computer or on an equivalent computer.  Files created using \
",
  StyleBox["DumpSave", "MR"],
  " are not portable between computers."
}], "Notes",
  CellTags->"DumpGet::bgcor"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DumpGet::bgnew", "ObjectNameWarningMessages",
  CellTags->"DumpGet::bgnew"],

Cell[BoxData[
    \(DumpGet::"bgnew" \(\(:\)\(\ \)\) 
      "File `1` has been written by a newer version of DumpSave and cannot be \
loaded."\)], "Message",
  CellLabel->"From In[95]:=",
  CellTags->"DumpGet::bgnew"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a file reading using ",
  StyleBox["DumpGet", "MR"],
  " appears to have been created by a different version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] If you see this message in an example where it is \
not expected, please contact Technical Support."
}], "Notes",
  CellTags->"DumpGet::bgnew"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DumpGet::bgold", "ObjectNameWarningMessages",
  CellTags->"DumpGet::bgold"],

Cell[BoxData[
    \(DumpGet::"bgold" \(\(:\)\(\ \)\) 
      "Warning: file `1` has been written by an older version of \
DumpSave."\)], "Message",
  CellLabel->"From In[95]:=",
  CellTags->"DumpGet::bgold"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"DumpGet::bgold"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DumpGet::valwarn", "ObjectNameWarningMessages",
  CellTags->"DumpGet::valwarn"],

Cell[BoxData[
    RowBox[{\(DumpGet::"valwarn"\), \(\(:\)\(\ \)\), "Symbol", " ", 
      StyleBox["sym",
        "TI"], " ", "already", " ", "has", " ", "definition", " ", "for", " ",
       
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"DumpGet::valwarn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["DumpGet", "MR"],
  " may load conflicting definitions for a symbol.\n\[FilledSmallSquare] This \
message is not used in current versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"DumpGet::valwarn"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DumpSave::bschk", "ObjectNameWarningMessages",
  CellTags->"DumpSave::bschk"],

Cell[BoxData[
    \(DumpSave::"bschk" \(\(:\)\(\ \)\) \(Error\ in\ writing\ output\ \
\(\(file\)\(.\)\)\)\)], "Message",
  CellTags->"DumpSave::bschk"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an internal error while trying to create \
a file using ",
  StyleBox["DumpSave", "MR"],
  ".\n\[FilledSmallSquare] If you see this message in a situation where it is \
not expected, please contact Technical Support."
}], "Notes",
  CellTags->"DumpSave::bschk"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DumpSave::bsnosym", "ObjectNameWarningMessages",
  CellTags->"DumpSave::bsnosym"],

Cell[BoxData[
    RowBox[{\(DumpSave::"bsnosym"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ defined\ as\ a\ symbol\ or\ a\ \
\(\(context\)\(.\)\)\)\)}]], "Message",
  CellTags->"DumpSave::bsnosym"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["DumpSave", "MR"],
  " is not a symbol or string that specifies a symbol or a context."
}], "Notes",
  CellTags->"DumpSave::bsnosym"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"DumpSave::bsnosym"],

Cell[TextData[{
  "An error occurs in this example because a number is not a valid value for \
the second argument in ",
  StyleBox["DumpSave", "MR"],
  "."
}], "Text",
  CellTags->"DumpSave::bsnosym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DumpSave["\<fsym.mx\>", 7]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"DumpSave::bsnosym"],

Cell[BoxData[
    \(DumpSave::"bsnosym" \(\(:\)\(\ \)\) 
      "\!\(7\) is not defined as a symbol or a context."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"DumpSave::bsnosym"],

Cell[BoxData[
    \(DumpSave["fsym.mx", 7]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"DumpSave::bsnosym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DumpSave::bsstm", "ObjectNameWarningMessages",
  CellTags->"DumpSave::bsstm"],

Cell[BoxData[
    RowBox[{\(DumpSave::"bsstm"\), \(\(:\)\(\ \)\), \(\(DumpSave\)\(\ \
\)\(will\)\(\ \)\(not\)\(\ \)\(write\)\(\ \)\(out\)\(\ \)\(stream\)\(\ \
\)\(information\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"DumpSave::bsstm"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"DumpSave::bsstm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DumpSave::outref", "ObjectNameWarningMessages",
  CellTags->"DumpSave::outref"],

Cell[BoxData[
    RowBox[{\(DumpSave::"outref"\), \(\(:\)\(\ \)\), "Symbol", " ", 
      StyleBox["sym",
        "TI"], " ", "references", " ", "an", " ", "external", " ", "object", 
      " ", "such", " ", "as", " ", "a", " ", "file", " ", "which", " ", 
      "will", " ", "not", " ", "be", " ", "saved", " ", "in", " ", "the", 
      " ", \(\(output\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"DumpSave::outref"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a value of the indicated symbol \
includes a reference to an ",
  StyleBox["InputStream", "MR"],
  " or ",
  StyleBox["OutputStream", "MR"],
  " expression or to a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connection.\n\[FilledSmallSquare] Expressions that refer to files or \
links outside of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " cannot in general be saved in an output file since those files or links \
may be different in a new ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session."
}], "Notes",
  CellTags->"DumpSave::outref"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"DumpSave::outref"],

Cell["\<\
A warning message is generated in this example because the stream \
information in the value of the indicated symbol is not saved.\
\>", "Text",
  CellTags->"DumpSave::outref"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s = StringToStream["\<string\>"]}, \n\t
      DumpSave["\<dfile.mx\>", s]; \n\tClose[s]\n]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"DumpSave::outref"],

Cell[BoxData[
    \(DumpSave::"outref" \(\(:\)\(\ \)\) 
      "Symbol \!\(s$29073\) references an external object such as a file \
which will not be saved in the output."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"DumpSave::outref"],

Cell[BoxData[
    \(String\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"DumpSave::outref"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Get::path", "ObjectNameWarningMessages",
  CellTags->"Get::path"],

Cell[BoxData[
    RowBox[{\(Get::"path"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(in\ $Path\ is\ not\ a\ \(\(string\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"Get::path"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Get", "MR"],
  " is used and the value of ",
  StyleBox["$Path", "MR"],
  " includes elements that are not strings.\n\[FilledSmallSquare] This \
message can be generated if ",
  StyleBox["$Path", "MR"],
  " was previously set to an invalid value.\n\[FilledSmallSquare] The value \
of ",
  StyleBox["$Path", "MR"],
  " is expected to be a list of strings that specify directory names."
}], "Notes",
  CellTags->"Get::path"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Get::path"],

Cell[TextData[{
  "An error occurs in this example because the value assigned to ",
  StyleBox["$Path", "MR"],
  " is not a list of strings."
}], "Text",
  CellTags->"Get::path"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$Path = None}, Get["\<TEST\>"]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Get::path"],

Cell[BoxData[
    \(Get::"path" \(\(:\)\(\ \)\) 
      "\!\(None\) in $Path is not a string."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Get::path"],

Cell[BoxData[
    \(Get::"noopen" \(\(:\)\(\ \)\) 
      "Cannot open \!\(\"TEST\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Get::path"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Get::path"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Information::basic", "ObjectNameWarningMessages",
  CellTags->"Information::basic"],

Cell[BoxData[
    \(Information::"basic" \(\(:\)\(\ \)\) \(\(?Name\ gives\ information\ on\ \
Name\), \ \(?Ab*\ on\ all\ symbols\ starting\ with\ Ab.\ ??Name\ gives\ more\ \
information. \)\)\)], "Message",
  CellTags->"Information::basic"],

Cell[TextData[{
  "\[FilledSmallSquare] This is an information message used for ",
  StyleBox["?", "MR"],
  " and related characters.\n\[FilledSmallSquare] This is not an error or \
warning message."
}], "Notes",
  CellTags->"Information::basic"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Information::basic"],

Cell["This shows a typical use of this message.", "Text",
  CellTags->"Information::basic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(?\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Information::basic"],

Cell[BoxData[
    \(Information::"basic" \(\(:\)\(\ \)\) 
      "?Name gives information on Name, ?Ab* on all symbols starting with Ab. \
??Name gives more information."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Information::basic"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Information::nomatch", "ObjectNameWarningMessages",
  CellTags->"Information::nomatch"],

Cell[BoxData[
    RowBox[{\(Information::"nomatch"\), \(\(:\)\(\ \)\), \(\(No\)\(\ \
\)\(symbol\)\(\ \)\(matching\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\(found\)\(.\)\)\)}]], "Message",
  CellTags->"Information::nomatch"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when information is requested using a \
string pattern and there are no symbols that match that pattern.\n\
\[FilledSmallSquare] In an information request, a string pattern is a name \
specification that includes string metacharacters such as ",
  StyleBox["*", "MR"],
  " and ",
  StyleBox["@", "MR"],
  "."
}], "Notes",
  CellTags->"Information::nomatch"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Information::nomatch"],

Cell["\<\
An error occurs in this example because there are no symbols that \
match the indicated string pattern.\
\>", "Text",
  CellTags->"Information::nomatch"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?2*\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Information::nomatch"],

Cell[BoxData[
    \(Information::"nomatch" \(\(:\)\(\ \)\) 
      "No symbol matching \!\(\"2*\"\) found."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Information::nomatch"]
}, Open  ]],

Cell["\<\
This shows all symbols with names that match the indicated pattern.\
\
\>", "Text",
  CellTags->"Information::nomatch"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Z*\)\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Information::nomatch"],

Cell[BoxData[GridBox[{
        {
          StyleBox["System`",
            FontFamily->"Helvetica",
            FontSize->12,
            FontWeight->"Bold"]},
        {GridBox[{
              {
                ButtonBox[
                  StyleBox["ZeroTest",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3261996314-4322568", "System`ZeroTest"},
                  ButtonFrame->"None",
                  ButtonNote->"System`"], 
                ButtonBox[
                  StyleBox["ZeroWidthTimes",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3261996314-4322568", 
                    "System`ZeroWidthTimes"},
                  ButtonFrame->"None",
                  ButtonNote->"System`"], 
                ButtonBox[
                  StyleBox["Zeta",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3261996314-4322568", "System`Zeta"},
                  ButtonFrame->"None",
                  ButtonNote->"System`"], 
                ButtonBox[
                  StyleBox["ZTransform",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3261996314-4322568", "System`ZTransform"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"System`"], ""}
              },
            RowMinHeight->1.05]}
        },
      RowSpacings->{2, 3},
      ColumnAlignments->{Left},
      ColumnsEqual->True]], "Print",
  CellMargins->{{20, Inherited}, {Inherited, Inherited}},
  ShowCellLabel->False,
  CellFrameMargins->{{Inherited, Inherited}, {14, 14}},
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  ButtonBoxOptions->{Active->True},
  CellTags->"Information::nomatch"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Information::notfound1", "ObjectNameWarningMessages",
  CellTags->"Information::notfound1"],

Cell[BoxData[
    RowBox[{\(Information::"notfound1"\), \(\(:\)\(\ \)\), \(\(Symbol\)\(\ \)\
\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(not\ \(\(found\)\(.\)\)\)\)}]], "Message",
  CellTags->"Information::notfound1"],

Cell["\<\
\[FilledSmallSquare] Generated when information is requested for a \
name that is not recognized as the name of a symbol.\
\>", "Notes",
  CellTags->"Information::notfound1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Information::opt", "ObjectNameWarningMessages",
  CellTags->"Information::opt"],

Cell[BoxData[
    RowBox[{\(Information::"opt"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ an\ invalid\ \(\(option\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"Information::opt"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Information::opt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Message::msgl", "ObjectNameWarningMessages",
  CellTags->"Message::msgl"],

Cell[BoxData[
    RowBox[{\(Message::"msgl"\), \(\(:\)\(\ \)\), \(\($MessageList\)\(\ \)\), 
      
      StyleBox["expr",
        "TI"], \(\(\ \)\(not\ a\ list; \ 
      reset\ to\ \(\({}\)\(.\)\)\)\)}]], "Message",
  CellTags->"Message::msgl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated during evaluation of ",
  StyleBox["Message", "MR"],
  " if the value of ",
  StyleBox["$MessageList", "MR"],
  " is not a list.\n\[FilledSmallSquare] The value of ",
  StyleBox["$MessageList", "MR"],
  " is used to accumulate a list of message names and is required to be a \
list when each new name is added."
}], "Notes",
  CellTags->"Message::msgl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Message::msgl"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["$MessageList", "MR"],
  " does not have a value when a message is generated."
}], "Text",
  CellTags->"Message::msgl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MessageList}, Cos[]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Message::msgl"],

Cell[BoxData[
    \(Message::"msgl" \(\(:\)\(\ \)\) 
      "$MessageList \!\($MessageList\) not a list; reset to {}."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"Message::msgl"],

Cell[BoxData[
    \(Cos::"argx" \(\(:\)\(\ \)\) 
      "\!\(Cos\) called with \!\(0\) arguments; 1 argument is expected."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Message::msgl"],

Cell[BoxData[
    \(Cos[]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Message::msgl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Message::name", "ObjectNameWarningMessages",
  CellTags->"Message::name"],

Cell[BoxData[
    RowBox[{\(Message::"name"\), \(\(:\)\(\ \)\), \(\(Message\)\(\ \)\(name\)\
\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ of\ the\ form\ symbol::name\ or\ \
\(\(symbol::name::language\)\(.\)\)\)\)}]], "Message",
  CellTags->"Message::name"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["Message", "MR"],
  " does not have the expected form."
}], "Notes",
  CellTags->"Message::name"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Message::name"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["Message", "MR"],
  " is a symbol rather than a ",
  StyleBox["MessageName", "MR"],
  " expression."
}], "Text",
  CellTags->"Message::name"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Message[Cos, Cos, 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Message::name"],

Cell[BoxData[
    \(Message::"name" \(\(:\)\(\ \)\) 
      "Message name \!\(Cos\) is not of the form symbol::name or \
symbol::name::language."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Message::name"],

Cell[BoxData[
    \(Message[Cos, Cos, 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Message::name"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Message", "MR"],
  " to generate a warning message."
}], "Text",
  CellTags->"Message::name"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Message[Cos::argx, Cos, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Message::name"],

Cell[BoxData[
    \(Cos::"argx" \(\(:\)\(\ \)\) 
      "\!\(Cos\) called with \!\(2\) arguments; 1 argument is expected."\)], \
"Message",
  CellLabel->"From In[2]:=",
  CellTags->"Message::name"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Needs::nocont", "ObjectNameWarningMessages",
  CellTags->"Needs::nocont"],

Cell[BoxData[
    RowBox[{\(Needs::"nocont"\), \(\(:\)\(\ \)\), \(\(Context\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(was\ not\ created\ when\ Needs\ was\ \(\(evaluated\)\
\(.\)\)\)\)}]], "Message",
  CellTags->"Needs::nocont"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a package specified in ",
  StyleBox["Needs", "MR"],
  " either was not loaded or did not introduce the expected context.\n\
\[FilledSmallSquare] If the package was not loaded, there will normally be \
other warning messages to indicate the nature of that error.\n\
\[FilledSmallSquare] This message is a warning intended to report that a \
package does not have the expected format.  This message does not necessarily \
indicate an error.\n\[FilledSmallSquare] Standard package format includes ",
  StyleBox["BeginPackage", "MR"],
  " or other statements that introduce a context corresponding to the name of \
the package file.\n\[FilledSmallSquare] A package is treated as having been \
loaded if the corresponding context is included in the contexts listed in the \
value of ",
  StyleBox["$Packages", "MR"],
  ".\n\[FilledSmallSquare] Since ",
  StyleBox["Needs", "MR"],
  " is called from ",
  StyleBox["BeginPackage", "MR"],
  ", this message can occur when ",
  StyleBox["BeginPackage", "MR"],
  " is evaluated or when packages that contain ",
  StyleBox["BeginPackage", "MR"],
  " are loaded."
}], "Notes",
  CellTags->"Needs::nocont"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Needs::nocont"],

Cell["\<\
An error occurs in this example since the file corresponding to the \
indicated context is not found.  The first message shows that the package was \
not loaded and the second message shows that the expected context was not \
created.\
\>", "Text",
  CellTags->"Needs::nocont"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Needs["\<NOPACKAGE`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Needs::nocont"],

Cell[BoxData[
    \(Get::"noopen" \(\(:\)\(\ \)\) 
      "Cannot open \!\(\"NOPACKAGE`\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Needs::nocont"],

Cell[BoxData[
    \(Needs::"nocont" \(\(:\)\(\ \)\) 
      "Context \!\(\"NOPACKAGE`\"\) was not created when Needs was \
evaluated."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Needs::nocont"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Needs::nocont"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["On::none", "ObjectNameWarningMessages",
  CellTags->"On::none"],

Cell[BoxData[
    RowBox[{\(On::"none"\), \(\(:\)\(\ \)\), \(\(Message\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(not\ \(\(found\)\(.\)\)\)\)}]], "Message",
  CellTags->"On::none"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an argument in ",
  StyleBox["On", "MR"],
  " does not correspond to a known message."
}], "Notes",
  CellTags->"On::none"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"On::none"],

Cell[TextData[{
  "An error occurs in this example because there is no message with this tag \
in the current ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session."
}], "Text",
  CellTags->"On::none"],

Cell[CellGroupData[{

Cell[BoxData[
    \(On[All::msg]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"On::none"],

Cell[BoxData[
    \(On::"none" \(\(:\)\(\ \)\) 
      "Message \!\(All :: \"msg\"\) not found."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"On::none"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Read::readf
ReadList::readf
Skip::readf\
\>", "ObjectNameWarningMessages",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"readf\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", " ", "format",
         " ", \(\(specification\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Read", "MR"],
  ", ",
  StyleBox["ReadList", "MR"],
  ", or ",
  StyleBox["Skip", "MR"],
  " is not a valid format specification.\n\[FilledSmallSquare] Valid format \
specifications include ",
  StyleBox["Expression", "MR"],
  ", ",
  StyleBox["String", "MR"],
  ", ",
  StyleBox["Number", "MR"],
  ", ",
  StyleBox["Real", "MR"],
  ", ",
  StyleBox["Word", "MR"],
  ", ",
  StyleBox["Record", "MR"],
  ", ",
  StyleBox["Byte", "MR"],
  ", ",
  StyleBox["Character", "MR"],
  ", or a list of these specifications."
}], "Notes",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Integer", "MR"],
  " is not a valid format specification."
}], "Text",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s = StringToStream["\<18 19 25\>"], result}, \n\t
      result = ReadList[s, Integer]; \n\tClose[s]; \n\tresult\n\t]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],

Cell[BoxData[
    \(ReadList::"readf" \(\(:\)\(\ \)\) 
      "\!\(Integer\) is not a valid format specification."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}],

Cell[BoxData[
    \(ReadList[InputStream[String, 1541], Integer]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid format specification in ",
  StyleBox["ReadList", "MR"],
  "."
}], "Text",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s = StringToStream["\<18 19 25\>"], result}, \n\t
      result = ReadList[s, Number]; \n\tClose[s]; \n\tresult\n\t]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],

Cell[BoxData[
    \({18, 19, 25}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Read::readn
ReadList::readn
Skip::readn\
\>", "ObjectNameWarningMessages",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"readn\"\>"}], \(\(:\)\(\ \)\), "Syntax", " ", 
      "error", " ", "reading", " ", "a", " ", "real", " ", "number", " ", 
      "from", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when syntax that does not correspond to a \
number is encountered while reading ",
  StyleBox["Number", "MR"],
  " format from the indicated stream."
}], "Notes",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[TextData[{
  "An error occurs in this example because the characters read from the \
stream are not valid in ",
  StyleBox["Number", "MR"],
  " format."
}], "Text",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s = StringToStream["\<{1.7, 3.5, 2.2}\>"], result}, \n\t
      result = ReadList[s, Number]; \n\tClose[s]; \n\tresult\n\t]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[BoxData[
    \(Read::"readn" \(\(:\)\(\ \)\) 
      "Syntax error reading a real number from \
\!\(System`Private`StringTurnedIntoStream[\"{1.7, 3.5, 2.2}\"]\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],

Cell[BoxData[
    \({$Failed}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}]
}, Open  ]],

Cell[TextData[{
  "This stream can be read in ",
  StyleBox["Expression", "MR"],
  " format."
}], "Text",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s = StringToStream["\<{1.7, 3.5, 2.2}\>"], result}, \n\t
      result = ReadList[s, Expression]; \n\tClose[s]; \n\t
      result\n\t]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[BoxData[
    \({{1.7`, 3.5`, 2.2`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}]
}, Open  ]],

Cell[TextData[{
  "An error occurs in this example because the commas in the input stream are \
not valid in ",
  StyleBox["Number", "MR"],
  " format."
}], "Text",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s = StringToStream["\<1.7, 2.4, 3.5\>"], result}, \n\t
      result = ReadList[s, Number]; \n\tClose[s]; \n\tresult\n\t]\)], "Input",\

  CellLabel->"In[3]:=",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[BoxData[
    \(Read::"readn" \(\(:\)\(\ \)\) 
      "Syntax error reading a real number from \
\!\(System`Private`StringTurnedIntoStream[\"1.7, 2.4, 3.5\"]\)."\)], "Message",\

  CellLabel->"From In[3]:=",
  CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],

Cell[BoxData[
    \({1.7`, $Failed}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}]
}, Open  ]],

Cell[TextData[{
  "The numbers in this example can be read in ",
  StyleBox["Word", "MR"],
  " format and converted to numbers using ",
  StyleBox["ToExpression", "MR"],
  "."
}], "Text",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s = StringToStream["\<1.7, 2.4, 3.5\>"], result}, \n\t
      result = ReadList[s, Word, WordSeparators -> "\<,\>"]; \n\t
      Close[s]; \n\tToExpression /@ result\n\t]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[BoxData[
    \({1.7`, 2.4`, 3.5`}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Read::readt
ReadList::readt
Skip::readt\
\>", "ObjectNameWarningMessages",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"readt\"\>"}], \(\(:\)\(\ \)\), "Syntax", " ", 
      "error", " ", "reading", " ", 
      StyleBox["expr",
        "TI"], " ", "from", " ", 
      RowBox[{
        StyleBox["s",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],

Cell["\<\
\[FilledSmallSquare] Generated when a syntax error is encountered \
while reading an expression from an input stream.\
\>", "Notes",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],

Cell[TextData[{
  "An error occurs in this example because the string in the input stream \
does not correspond to syntactically valid ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " input."
}], "Text",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s = StringToStream["\<(1+2+3+)\>"], result}, \n\t
      result = Read[s]; \n\tClose[s]; \n\tresult\n\t]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],

Cell[BoxData[
    \(Read::"readt" \(\(:\)\(\ \)\) 
      "Syntax error reading \!\(\"(1+2+3+)\\n\"\) from \
\!\(System`Private`StringTurnedIntoStream[\"(1+2+3+)\"]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}]
}, Open  ]],

Cell["This shows a syntactically valid input read from a stream.", "Text",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s = StringToStream["\<(1+2+3+4)\>"], result}, \n\t
      result = Read[s]; \n\tClose[s]; \n\tresult\n\t]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],

Cell[BoxData[
    \(10\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Read::readx
ReadList::readx
Skip::readx\
\>", "ObjectNameWarningMessages",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"readx\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "reads", " ", "no", 
        " ", \(\(entries\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Read", "MR"],
  ", ",
  StyleBox["Readlist", "MR"],
  ", or ",
  StyleBox["Skip", "MR"],
  " does not specify anything to read."
}], "Notes",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Readlist", "MR"],
  " does not specify anything to read."
}], "Text",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s = StringToStream["\<one two three\>"], result}, \n\t
      result = ReadList[s, Word[]]; \n\tClose[s]; \n\tresult\n\t]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],

Cell[BoxData[
    \(ReadList::"readx" \(\(:\)\(\ \)\) 
      "\!\(Word[]\) reads no entries."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}],

Cell[BoxData[
    \(ReadList[InputStream[String, 1549], Word[]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid format specification in ",
  StyleBox["Readlist", "MR"],
  "."
}], "Text",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s = StringToStream["\<one two three\>"], result}, \n\t
      result = ReadList[s, Word]; \n\tClose[s]; \n\tresult\n\t]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],

Cell[BoxData[
    \({"one", "two", "three"}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetStreamPosition::sbuf", "ObjectNameWarningMessages",
  CellTags->"SetStreamPosition::sbuf"],

Cell[BoxData[
    RowBox[{\(SetStreamPosition::"sbuf"\), \(\(:\)\(\ \)\), "Requested", " ", 
      "position", " ", 
      StyleBox["pos",
        "TI"], " ", "in", " ", "stream", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ outside\ the\ file\ buffer; \ 
      cannot\ reach\ outside\ the\ file\ buffer\ for\ non - 
        disk\ \(\(files\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SetStreamPosition::sbuf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["SetStreamPosition", "MR"],
  " refers to a position that is not available in the indicated input \
stream."
}], "Notes",
  CellTags->"SetStreamPosition::sbuf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SetStreamPosition::sbuf"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["SetStreamPosition", "MR"],
  " is greater than the number of characters that are available in this input \
stream."
}], "Text",
  CellTags->"SetStreamPosition::sbuf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{s = StringToStream["\<112233445566778899\>"], result}, \n\t
      SetStreamPosition[s, 50]; \n\t
      result = Read[s, {Character, Character, Character}]; \n\tClose[s]; \n\t
      result\n]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SetStreamPosition::sbuf"],

Cell[BoxData[
    \(SetStreamPosition::"sbuf" \(\(:\)\(\ \)\) 
      "Requested position \!\(50\) in stream \!\(InputStream[\(\(String, 1551\
\)\)]\) is outside the file buffer; cannot reach outside the file buffer for \
non-disk files."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SetStreamPosition::sbuf"],

Cell[BoxData[
    \({"1", "1", "2"}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SetStreamPosition::sbuf"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["SetStreamPosition", "MR"],
  "."
}], "Text",
  CellTags->"SetStreamPosition::sbuf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{s = StringToStream["\<112233445566778899\>"], result}, \n\t
      SetStreamPosition[s, 5]; \n\t
      result = Read[s, {Character, Character, Character}]; \n\tClose[s]; \n\t
      result\n]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SetStreamPosition::sbuf"],

Cell[BoxData[
    \({"3", "4", "4"}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SetStreamPosition::sbuf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringForm::sfq", "ObjectNameWarningMessages",
  CellTags->"StringForm::sfq"],

Cell[BoxData[
    RowBox[{\(StringForm::"sfq"\), \(\(:\)\(\ \)\), \(\(Unmatched\)\(\ \
\)\(backquote\)\(\ \)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"StringForm::sfq"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["StringForm", "MR"],
  " includes an odd number of backquote characters."
}], "Notes",
  CellTags->"StringForm::sfq"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"StringForm::sfq"],

Cell[TextData[{
  "An error occurs in this example because of a missing backquote character \
in the first argument of ",
  StyleBox["StringForm", "MR"],
  "."
}], "Text",
  CellTags->"StringForm::sfq"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringForm["\<n1 = `; n2 = ``; n3 = ``\>", 3, 5, 7]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"StringForm::sfq"],

Cell[BoxData[
    \(StringForm::"sfq" \(\(:\)\(\ \)\) 
      "Unmatched backquote in \!\(\"n1 = `; n2 = ``; n3 = ``\"\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"StringForm::sfq"],

Cell[BoxData[
    InterpretationBox["\<\"n1 = `; n2 = ``; n3 = ``\"\>",
      StringForm[ "n1 = `; n2 = ``; n3 = ``", 3, 5, 7],
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"StringForm::sfq"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid control string in ",
  StyleBox["StringForm", "MR"],
  "."
}], "Text",
  CellTags->"StringForm::sfq"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringForm["\<n1 = ``; n2 = ``; n3 = ``\>", 3, 5, 7]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"StringForm::sfq"],

Cell[BoxData[
    InterpretationBox["\<\"n1 = \\!\\(3\\); n2 = \\!\\(5\\); n3 = \
\\!\\(7\\)\"\>",
      StringForm[ "n1 = ``; n2 = ``; n3 = ``", 3, 5, 7],
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"StringForm::sfq"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::aofil", "ObjectNameWarningMessages",
  CellTags->"General::aofil"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"aofil\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["file1",
          "TI"], " ", "already", " ", "open", " ", "as", " ", 
        RowBox[{
          StyleBox["file2",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::aofil"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to open a file that is \
already open.\n\[FilledSmallSquare] This message is caused by using ",
  StyleBox["OpenWrite", "MR"],
  " or ",
  StyleBox["OpenAppend", "MR"],
  " with a file that has already been opened for reading or writing.\n\
\[FilledSmallSquare] ",
  StyleBox["Streams[]", "MR"],
  " gives the list of files that are currently open.\n\[FilledSmallSquare] \
For most files only one output stream may be open to the file at a time."
}], "Notes",
  CellTags->"General::aofil"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::aofil"],

Cell[TextData[{
  "An error occurs in this example when ",
  StyleBox["OpenWrite", "MR"],
  " is used with a file that is already open."
}], "Text",
  CellTags->"General::aofil"],

Cell[CellGroupData[{

Cell[BoxData[
    \(OpenWrite["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::aofil"],

Cell[BoxData[
    \(OutputStream["TESTFILE", 1553]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::aofil"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OpenWrite["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::aofil"],

Cell[BoxData[
    \(General::"aofil" \(\(:\)\(\ \)\) 
      "\!\(\"TESTFILE\"\) already open as \!\(\"TESTFILE\"\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::aofil"],

Cell[BoxData[
    \(OpenWrite::"noopen" \(\(:\)\(\ \)\) 
      "Cannot open \!\(\"TESTFILE\"\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::aofil"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::aofil"]
}, Open  ]],

Cell["Close the file.", "Text",
  CellTags->"General::aofil"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Close["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::aofil"],

Cell[BoxData[
    \("TESTFILE"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::aofil"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::filro", "ObjectNameWarningMessages",
  CellTags->"General::filro"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"filro\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{\(Attempt\ to\ modify\ a\ read\), "-", 
        RowBox[{"only", " ", "file", " ", "during", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::filro"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated operation does \
not have permission to modify a file.
\[FilledSmallSquare] This message is a response to a corresponding message \
generated internally by the operating system of your computer.\
\>", "Notes",
  CellTags->"General::filro"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ioarg", "ObjectNameWarningMessages",
  CellTags->"General::ioarg"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ioarg\"\>"}], \(\(:\)\(\ \)\), "Argument", " ", 
      "in", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "valid", " ", "for", " ", \(I/O\), 
      " ", \(\(operation\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ioarg"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated file operation is \
not valid on your computer.
\[FilledSmallSquare] This message is a response to a corresponding message \
generated internally by the operating system of your computer.\
\>", "Notes",
  CellTags->"General::ioarg"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::ioerr", "ObjectNameWarningMessages",
  CellTags->"General::ioerr"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ioerr\"\>"}], \(\(:\)\(\ \)\), \(I/O\), " ", 
      "error", " ", "occurred", " ", "during", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ioerr"],

Cell["\<\
\[FilledSmallSquare] Generated by an error while manipulating files \
or directories on your computer.
\[FilledSmallSquare] This message is a response to an error generated \
internally by the operating system of your computer.\
\>", "Notes",
  CellTags->"General::ioerr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::isdir", "ObjectNameWarningMessages",
  CellTags->"General::isdir"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"isdir\"\>"}], \(\(:\)\(\ \)\), \(Cannot\ open\ directory\ \
for\ \(\(reading\)\(.\)\)\)}]], "Message",
  CellTags->"General::isdir"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the description of a file to be opened \
for input corresponds to a directory or folder on your computer system.\n\
\[FilledSmallSquare] This message is generated by functions such as ",
  StyleBox["OpenRead", "MR"],
  " and ",
  StyleBox["ReadList", "MR"],
  " that read input from files."
}], "Notes",
  CellTags->"General::isdir"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::noopen", "ObjectNameWarningMessages",
  CellTags->"General::noopen"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"noopen\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "open", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::noopen"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a requested file cannot be opened.\n\
\[FilledSmallSquare] This message often indicates that the indicated file was \
not found.\n\[FilledSmallSquare] The directories that are searched in an \
attempt to find an external file are listed in the value of the global \
variable ",
  StyleBox["$Path", "MR"],
  ".\n\[FilledSmallSquare] If you see this message, check the spelling and \
syntax for the name of the file, and check that the file is present in one of \
the directories listed in the value of ",
  StyleBox["$Path", "MR"],
  "."
}], "Notes",
  CellTags->"General::noopen"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::noopen"],

Cell["\<\
An error occurs in this example if the specified file is not found \
on this computer.\
\>", "Text",
  CellTags->"General::noopen"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Get["\<NOFILE\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::noopen"],

Cell[BoxData[
    \(Get::"noopen" \(\(:\)\(\ \)\) 
      "Cannot open \!\(\"NOFILE\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::noopen"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::noopen"]
}, Open  ]],

Cell["\<\
An error occurs in this example because the context of the package \
is specified using forward quotes rather than backquote characters.\
\>", \
"Text",
  CellTags->"General::noopen"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Get["\<Statistics'DescriptiveStatistics'\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::noopen"],

Cell[BoxData[
    \(Get::"noopen" \(\(:\)\(\ \)\) 
      "Cannot open \!\(\"Statistics'DescriptiveStatistics'\"\)."\)], "Message",\

  CellLabel->"From In[2]:=",
  CellTags->"General::noopen"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::noopen"]
}, Open  ]],

Cell[TextData[{
  "Evaluation of this input will load the ",
  StyleBox["Statistics`DescriptiveStatistics`", "MR"],
  " package if that package has not already been loaded."
}], "Text",
  CellTags->"General::noopen"],

Cell[BoxData[
    \(Needs["\<Statistics`DescriptiveStatistics`\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::noopen"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::notfound", "ObjectNameWarningMessages",
  CellTags->"General::notfound"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"notfound\"\>"}], \(\(:\)\(\ \)\), "Symbol", " ", 
      StyleBox["expr",
        "TI"], " ", "not", " ", \(\(found\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::notfound"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated symbol is not \
recognized.\n\[FilledSmallSquare] This message can appear if the name of the \
symbol is not spelled correctly or if the name given is not a syntactically \
valid symbol name.\n\[FilledSmallSquare] If the context of the symbol is not \
included in ",
  StyleBox["$Context", "MR"],
  " or ",
  StyleBox["$ContextPath", "MR"],
  ", then the context must be included in the name or the symbol will not be \
found."
}], "Notes",
  CellTags->"General::notfound"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::notfound"],

Cell["\<\
An error occurs in this example because the name given is not a \
syntactically valid symbol name (symbol names cannot include square \
brackets).\
\>", "Text",
  CellTags->"General::notfound"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Cos[x]\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::notfound"],

Cell[BoxData[
    \(Information::"notfound" \(\(:\)\(\ \)\) 
      "Symbol \!\(\"Cos[x]\"\) not found."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::notfound"]
}, Open  ]],

Cell["This shows a valid symbol name.", "Text",
  CellTags->"General::notfound"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Cos\)\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::notfound"],

Cell[BoxData[
    \(Cos[z]\ gives\ the\ cosine\ of\ \(\(z\)\(.\)\(\ \)\)\)], "Print",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::notfound"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::openr", "ObjectNameWarningMessages",
  CellTags->"General::openr"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"openr\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "open", " ", "for", 
        " ", \(\(input\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::openr"],

Cell["\<\
\[FilledSmallSquare] Generated by an attempt to write to an input \
stream.\
\>", "Notes",
  CellTags->"General::openr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::openr"],

Cell["It is not possible to write to an input stream.", "Text",
  CellTags->"General::openr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s = StringToStream["\<1 2 3 4 5\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::openr"],

Cell[BoxData[
    \(InputStream[String, 1556]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::openr"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Write[s, 0]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::openr"],

Cell[BoxData[
    \(General::"openr" \(\(:\)\(\ \)\) 
      "\!\(InputStream[\(\(String, 1556\)\)]\) is open for input."\)], \
"Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::openr"],

Cell[BoxData[
    \(Write::"noopen" \(\(:\)\(\ \)\) 
      "Cannot open \!\(InputStream[\(\(String, 1556\)\)]\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::openr"]
}, Open  ]],

Cell["Close the stream.", "Text",
  CellTags->"General::openr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Close[s]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::openr"],

Cell[BoxData[
    \(String\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::openr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::openw", "ObjectNameWarningMessages",
  CellTags->"General::openw"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"openw\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "open", " ", "for", 
        " ", \(\(output\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::openw"],

Cell["\<\
\[FilledSmallSquare] Generated by an attempt to read from an output \
stream.\
\>", "Notes",
  CellTags->"General::openw"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::openw"],

Cell["\<\
It is not possible to read from a file that is open for \
output.\
\>", "Text",
  CellTags->"General::openw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s = OpenAppend["\<file\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::openw"],

Cell[BoxData[
    \(OutputStream["file", 1557]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::openw"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Read[s]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::openw"],

Cell[BoxData[
    \(General::"openw" \(\(:\)\(\ \)\) 
      "\!\(OutputStream[\(\(\"file\", 1557\)\)]\) is open for output."\)], \
"Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::openw"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::openw"]
}, Open  ]],

Cell["Close the stream.", "Text",
  CellTags->"General::openw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Close[s]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::openw"],

Cell[BoxData[
    \("file"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::openw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::openx", "ObjectNameWarningMessages",
  CellTags->"General::openx"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"openx\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", \(\(open\)\(.\)\)}]}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::openx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a file operation is requested for a \
file that is not currently open.\n\[FilledSmallSquare] A file can be opened \
using ",
  StyleBox["OpenRead", "MR"],
  ", ",
  StyleBox["OpenWrite", "MR"],
  ", or ",
  StyleBox["OpenAppend", "MR"],
  "."
}], "Notes",
  CellTags->"General::openx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::openx"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["Read", "MR"],
  " does not correspond to a stream that is open for reading."
}], "Text",
  CellTags->"General::openx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Read["\<DATA\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::openx"],

Cell[BoxData[
    \(Read::"openx" \(\(:\)\(\ \)\) 
      "\!\(\"DATA\"\) is not open."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::openx"],

Cell[BoxData[
    \(Read["DATA"]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::openx"]
}, Open  ]],

Cell[TextData[{
  "An open stream can be created from a string using ",
  StyleBox["StringToStream", "MR"],
  "."
}], "Text",
  CellTags->"General::openx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{s, result}, \n\ts = StringToStream["\<{1,2,3}\>"]; \n\t
      result = Read[s]; \n\tClose[s]; \n\tresult\n\t]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::openx"],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::openx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::readp", "ObjectNameWarningMessages",
  CellTags->"General::readp"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"readp\"\>"}], \(\(:\)\(\ \)\), "Symbol", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "read", 
      " ", \(\(protected\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::readp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an operation that tries to access the \
rules attached to a symbol that has both the ",
  StyleBox["ReadProtected", "MR"],
  " attribute and the ",
  StyleBox["Locked", "MR"],
  " attribute."
}], "Notes",
  CellTags->"General::readp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::readp"],

Cell[TextData[{
  "An error message is generated by the attempt in this example to evaluate \
",
  StyleBox["DownValues", "MR"],
  " for a symbol that has the ",
  StyleBox["ReadProtected", "MR"],
  " and ",
  StyleBox["Locked", "MR"],
  " attributes."
}], "Text",
  CellTags->"General::readp"],

Cell[BoxData[
    \(SetAttributes[rlsym, {ReadProtected, Locked}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::readp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DownValues[rlsym]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::readp"],

Cell[BoxData[
    \(General::"readp" \(\(:\)\(\ \)\) 
      "Symbol \!\(rlsym\) is read protected."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::readp"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::readp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::remote", "ObjectNameWarningMessages",
  CellTags->"General::remote"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"remote\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "cannot", " ", "write", " ", "an", " ", "output", " ", 
        "file", " ", "since", " ", "the", " ", "FrontEnd", " ", "and", " ", 
        "Kernel", " ", "do", " ", "not", " ", "share", " ", "a", " ", 
        "common", " ", "file", " ", \(\(system\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::remote"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel and the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end must access the same file system but are running on different \
computers.\n\[FilledSmallSquare] This message can be generated by ",
  StyleBox["TeXSave", "MR"],
  " and ",
  StyleBox["HTMLSave", "MR"],
  " when using a remote kernel."
}], "Notes",
  CellTags->"General::remote"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::stmtype", "ObjectNameWarningMessages",
  CellTags->"General::stmtype"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"stmtype\"\>"}], \(\(:\)\(\ \)\), "FormatType", 
        " ", "option", " ", "of", " ", "stream", " ", 
        StyleBox["s",
          "TI"], " ", "cannot", " ", "be", " ", "set", " ", "to", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], ".", " ", "Use"}], " ", "a", " ", "string"}], 
      "-", \(based\ format\ such\ as\ \(\(OutputForm\)\(.\)\)\)}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::stmtype"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::stmtype"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::stop", "ObjectNameWarningMessages",
  CellTags->"General::stop"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"stop\"\>"}], \(\(:\)\(\ \)\), "Further", " ", 
      "output", " ", "of", " ", 
      StyleBox["expr",
        "TI"], " ", "will", " ", "be", " ", "suppressed", " ", "during", " ", 
      "this", " ", \(\(calculation\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::stop"],

Cell["\<\
\[FilledSmallSquare] Generated after the indicated message has been \
generated for the third time in a single evaluation.
\[FilledSmallSquare] Messages are suppressed to prevent redundant or \
repetitive messages in long calculations.\
\>", "Notes",
  CellTags->"General::stop"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::stop"],

Cell["\<\
Several errors occur in this example because each element in the \
result is invalid.\
\>", "Text",
  CellTags->"General::stop"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[\((2 /. \ #)\) &, \ {3, 2, 6, 5, 2, 4, 4}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::stop"],

Cell[BoxData[
    \(ReplaceAll::"reps" \(\(:\)\(\ \)\) 
      "\!\({3}\) is neither a list of replacement rules nor a valid dispatch \
table, and so cannot be used for replacing."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::stop"],

Cell[BoxData[
    \(ReplaceAll::"reps" \(\(:\)\(\ \)\) 
      "\!\({2}\) is neither a list of replacement rules nor a valid dispatch \
table, and so cannot be used for replacing."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::stop"],

Cell[BoxData[
    \(ReplaceAll::"reps" \(\(:\)\(\ \)\) 
      "\!\({6}\) is neither a list of replacement rules nor a valid dispatch \
table, and so cannot be used for replacing."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::stop"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(ReplaceAll :: \"reps\"\) will be suppressed \
during this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::stop"],

Cell[BoxData[
    \({2 /. \[InvisibleSpace]3, 2 /. \[InvisibleSpace]2, 
      2 /. \[InvisibleSpace]6, 2 /. \[InvisibleSpace]5, 
      2 /. \[InvisibleSpace]2, 2 /. \[InvisibleSpace]4, 
      2 /. \[InvisibleSpace]4}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::stop"]
}, Open  ]],

Cell["This example shows a valid input.", "Text",
  CellTags->"General::stop"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[\((2 /. \ # -> 0)\) &, \ {3, 2, 6, 5, 2, 4, 4}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::stop"],

Cell[BoxData[
    \({2, 0, 2, 2, 0, 2, 2}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::stop"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::stream", "ObjectNameWarningMessages",
  CellTags->"General::stream"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"stream\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "a", " ", "string"}]}], ",", 
      " ", \(InputStream[\ ]\), ",", 
      " ", \(or\ \(\(OutputStream[\ ]\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::stream"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected \
to be a string or to have a head of ",
  StyleBox["InputStream", "MR"],
  " or ",
  StyleBox["OutputStream", "MR"],
  "."
}], "Notes",
  CellTags->"General::stream"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::stream"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["Read", "MR"],
  " is a symbol rather than a stream."
}], "Text",
  CellTags->"General::stream"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{s}, Print["\<result = \>", \ Read[s]]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::stream"],

Cell[BoxData[
    \(General::"stream" \(\(:\)\(\ \)\) 
      "\!\(s\) is not a string, InputStream[ ], or OutputStream[ ]."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::stream"],

Cell[BoxData[
    InterpretationBox[\("result = "\[InvisibleSpace]Read[s]\),
      SequenceForm[ "result = ", 
        Read[ s]],
      Editable->False]], "Print",
  CellLabel->"From In[1]:=",
  CellTags->"General::stream"]
}, Open  ]],

Cell[TextData[{
  "This shows valid stream arguments in ",
  StyleBox["Read", "MR"],
  " and ",
  StyleBox["Close", "MR"],
  "."
}], "Text",
  CellTags->"General::stream"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{s = StringToStream["\<2 + 2\>"]}, 
      Print["\<result = \>", Read[s]]; Close[s]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::stream"],

Cell[BoxData[
    InterpretationBox[\("result = "\[InvisibleSpace]4\),
      SequenceForm[ "result = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[2]:=",
  CellTags->"General::stream"],

Cell[BoxData[
    \(String\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::stream"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::strmi", "ObjectNameWarningMessages",
  CellTags->"General::strmi"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"strmi\"\>"}], \(\(:\)\(\ \)\), "First", " ", 
      "argument", " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", " ", "file", 
      " ", "or", " ", "string", " ", \(\(identifier\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::strmi"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["InputStream", "MR"],
  " or ",
  StyleBox["OutputStream", "MR"],
  " is neither a string representing the name of a file nor an identifier for \
a string that is used as a stream.\n\[FilledSmallSquare] This message is \
normally seen only when attempting to enter ",
  StyleBox["InputStream", "MR"],
  " or ",
  StyleBox["OutputStream", "MR"],
  " expressions explicitly, rather than using the expressions that have been \
generated by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::strmi"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::strmi"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["OutputStream", "MR"],
  " is not a string."
}], "Text",
  CellTags->"General::strmi"],

Cell[CellGroupData[{

Cell[BoxData[
    \(strm = OpenWrite["\<TEST\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::strmi"],

Cell[BoxData[
    \(OutputStream["TEST", 1560]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::strmi"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Write[OutputStream[TEST, 3], 
      OutputForm["\<output to file\>"]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::strmi"],

Cell[BoxData[
    \(General::"strmi" \(\(:\)\(\ \)\) 
      "First argument in \!\(OutputStream[\(\(TEST, 3\)\)]\) is not a valid \
file or string identifier."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::strmi"],

Cell[BoxData[
    \(Write::"noopen" \(\(:\)\(\ \)\) 
      "Cannot open \!\(OutputStream[\(\(TEST, 3\)\)]\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::strmi"]
}, Open  ]],

Cell[TextData[{
  "Output can be written to the open stream by giving the name of the file or \
by using the corresponding ",
  StyleBox["OutputStream", "MR"],
  " expression."
}], "Text",
  CellTags->"General::strmi"],

Cell[BoxData[
    \(Write[strm, OutputForm["\<output to file\>"]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::strmi"],

Cell[BoxData[
    \(Write["\<TEST\>", OutputForm["\<more output to file\>"]]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::strmi"],

Cell["Close the stream and delete the file.", "Text",
  CellTags->"General::strmi"],

Cell[BoxData[
    \(Close[strm]; DeleteFile["\<TEST\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"General::strmi"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::strml", "ObjectNameWarningMessages",
  CellTags->"General::strml"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"strml\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "a", " ", "string"}]}], ",", 
      " ", "stream", ",", 
      " ", \(or\ list\ of\ strings\ and\ \(\(streams\)\(.\)\)\)}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::strml"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected \
to be a string, an expression with a head of ",
  StyleBox["InputStream", "MR"],
  " or ",
  StyleBox["OutputStream", "MR"],
  ", or a list of expressions of this form."
}], "Notes",
  CellTags->"General::strml"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::strml"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["Write", "MR"],
  " is a symbol rather than a string or a stream."
}], "Text",
  CellTags->"General::strml"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Write[TEST, OutputForm["\<output to file\>"]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::strml"],

Cell[BoxData[
    \(General::"strml" \(\(:\)\(\ \)\) 
      "\!\(TEST\) is not a string, stream, or list of strings and \
streams."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::strml"],

Cell[BoxData[
    \(Write::"noopen" \(\(:\)\(\ \)\) "Cannot open \!\(TEST\)."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"General::strml"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Write", "MR"],
  "."
}], "Text",
  CellTags->"General::strml"],

Cell[BoxData[
    \(Write["\<TEST\>", OutputForm["\<output to file\>"]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::strml"],

Cell["Close the output stream, and remove the file.", "Text",
  CellTags->"General::strml"],

Cell[BoxData[
    \(Close["\<TEST\>"]; DeleteFile["\<TEST\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::strml"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::strmn", "ObjectNameWarningMessages",
  CellTags->"General::strmn"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"strmn\"\>"}], \(\(:\)\(\ \)\), "Requested", " ", 
      "stream", " ", 
      StyleBox["s1",
        "TI"], " ", "does", " ", "not", " ", "match", " ", "existing", " ", 
      "stream", " ", 
      StyleBox["s2",
        "TI"], " ", "with", " ", "the", " ", "same", " ", "stream", 
      " ", \(\(number\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::strmn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a duplicate stream number is \
encountered during input or output.\n\[FilledSmallSquare] Streams are \
assigned a unique number when they are opened.  An error occurs if the same \
number is used with a different stream.\n\[FilledSmallSquare] This error can \
occur when entering ",
  StyleBox["InputStream", "MR"],
  " and ",
  StyleBox["OutputStream", "MR"],
  " expressions.\n\[FilledSmallSquare] The ",
  StyleBox["InputStream", "MR"],
  " and ",
  StyleBox["OutputStream", "MR"],
  " expressions returned by functions such as ",
  StyleBox["OpenAppend", "MR"],
  ", ",
  StyleBox["OpenRead", "MR"],
  ", ",
  StyleBox["OpenTemporary", "MR"],
  ", ",
  StyleBox["OpenWrite", "MR"],
  ", and ",
  StyleBox["StringToStream", "MR"],
  " are generally valid and should be used whenever practical, rather than \
entering a new ",
  StyleBox["InputStream", "MR"],
  " or ",
  StyleBox["OutputStream", "MR"],
  " expression."
}], "Notes",
  CellTags->"General::strmn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::strmn"],

Cell[TextData[{
  "Open a stream to a string.  The stream number is the second element in the \
resulting ",
  StyleBox["InputStream", "MR"],
  " expression."
}], "Text",
  CellTags->"General::strmn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s\  = \ StringToStream["\<abcdefg\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::strmn"],

Cell[BoxData[
    \(InputStream[String, 1562]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::strmn"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(s[\([2]\)]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::strmn"],

Cell[BoxData[
    \(1562\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::strmn"]
}, Open  ]],

Cell["\<\
Attempting to read from a stream with the same number but with a \
different name will generate an error.\
\>", "Text",
  CellTags->"General::strmn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList[InputStream["\<file\>", s[\([2]\)]], Character]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::strmn"],

Cell[BoxData[
    \(General::"strmn" \(\(:\)\(\ \)\) 
      "Requested stream \!\(InputStream[\(\(\"file\", 1562\)\)]\) does not \
match existing stream RowBox[{\"{\", \
RowBox[{\\(System`Private`StringTurnedIntoStream[\"abcdefg\"]\\), \",\", \
\\({}\\), \",\", 0}], \"}\"}] with the same stream number."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::strmn"],

Cell[BoxData[
    \(General::"openx" \(\(:\)\(\ \)\) 
      "\!\(InputStream[\(\(\"file\", 1562\)\)]\) is not open."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::strmn"],

Cell[BoxData[
    \(ReadList::"nffil" \(\(:\)\(\ \)\) 
      "File not found during \!\(ReadList[\(\(\(\(InputStream[\(\(\"file\", \
1562\)\)]\)\), Character\)\)]\)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::strmn"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::strmn"]
}, Open  ]],

Cell["This shows a correct way to read from this stream.", "Text",
  CellTags->"General::strmn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReadList[s, \ Character]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::strmn"],

Cell[BoxData[
    \({"a", "b", "c", "d", "e", "f", "g"}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::strmn"]
}, Open  ]],

Cell["Close the stream.", "Text",
  CellTags->"General::strmn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Close[s]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"General::strmn"],

Cell[BoxData[
    \(String\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"General::strmn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetStreamPosition::stmrng", "ObjectNameWarningMessages",
  CellTags->"SetStreamPosition::stmrng"],

Cell[BoxData[
    \(SetStreamPosition::"stmrng" \(\(:\)\(\ \)\) 
      "Cannot set the current point in stream `2` to position `1`. The \
requested position exceeds the number of characters in the file."\)], \
"Message",
  CellLabel->"From In[95]:=",
  CellTags->"SetStreamPosition::stmrng"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the second argument in ",
  StyleBox["SetStreamPosition", "MR"],
  " corresponds to a position that is outside of the stream specified in the \
first argument."
}], "Notes",
  CellTags->"SetStreamPosition::stmrng"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SetStreamPosition::stmrng"],

Cell[TextData[{
  "An error occurs in this example because the position specified in ",
  StyleBox["SetStreamPosition", "MR"],
  " exceeds the number of characters in the test file."
}], "Text",
  CellTags->"SetStreamPosition::stmrng"],

Cell[BoxData[
    \(Write["\<TESTFILE\>", OutputForm["\<ABCDEFGHOJKLMNOP\>"]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SetStreamPosition::stmrng"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Close["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SetStreamPosition::stmrng"],

Cell[BoxData[
    \("TESTFILE"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SetStreamPosition::stmrng"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{s = 
          OpenRead["\<TESTFILE\>"]}, \[IndentingNewLine]SetStreamPosition[s, 
        100]; \[IndentingNewLine]Print["\<char 101 = \>", 
        Read[s, Character]]; \[IndentingNewLine]Close[
        s]\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"SetStreamPosition::stmrng"],

Cell[BoxData[
    \(SetStreamPosition::"stmrng" \(\(:\)\(\ \)\) 
      "Cannot set the current point in stream \
\!\(InputStream[\(\(\"TESTFILE\", 1564\)\)]\) to position \!\(100\). The \
requested position exceeds the number of characters in the file."\)], \
"Message",
  CellLabel->"From In[3]:=",
  CellTags->"SetStreamPosition::stmrng"],

Cell[BoxData[
    InterpretationBox[\("char 101 = "\[InvisibleSpace]"A"\),
      SequenceForm[ "char 101 = ", "A"],
      Editable->False]], "Print",
  CellLabel->"From In[3]:=",
  CellTags->"SetStreamPosition::stmrng"],

Cell[BoxData[
    \("TESTFILE"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"SetStreamPosition::stmrng"]
}, Open  ]],

Cell["This shows a valid position specification for this file.", "Text",
  CellTags->"SetStreamPosition::stmrng"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{s = 
          OpenRead["\<TESTFILE\>"]}, \[IndentingNewLine]SetStreamPosition[s, 
        10]; \[IndentingNewLine]Print["\<char 11 = \>", 
        Read[s, Character]]; \[IndentingNewLine]Close[
        s]\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"SetStreamPosition::stmrng"],

Cell[BoxData[
    InterpretationBox[\("char 11 = "\[InvisibleSpace]"K"\),
      SequenceForm[ "char 11 = ", "K"],
      Editable->False]], "Print",
  CellLabel->"From In[4]:=",
  CellTags->"SetStreamPosition::stmrng"],

Cell[BoxData[
    \("TESTFILE"\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"SetStreamPosition::stmrng"]
}, Open  ]],

Cell["Delete the test file.", "Text",
  CellTags->"SetStreamPosition::stmrng"],

Cell[BoxData[
    \(DeleteFile["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"SetStreamPosition::stmrng"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$Language::notstr", "ObjectNameWarningMessages",
  CellTags->"$Language::notstr"],

Cell[BoxData[
    \($Language::"notstr" \(\(:\)\(\ \)\) 
      "`1` is not a string. Only strings can be set as the value of \
$Language."\)], "Message",
  CellLabel->"From In[95]:=",
  CellTags->"$Language::notstr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set ",
  StyleBox["$Language", "MR"],
  " to a value that is not a string.\n\[FilledSmallSquare] When this error \
occurs, the value of ",
  StyleBox["$Language", "MR"],
  " is not changed."
}], "Notes",
  CellTags->"$Language::notstr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$Language::notstr"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for ",
  StyleBox["$Language", "MR"],
  "."
}], "Text",
  CellTags->"$Language::notstr"],

Cell[CellGroupData[{

Cell[BoxData[
    \($Language = None\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$Language::notstr"],

Cell[BoxData[
    \($Language::"notstr" \(\(:\)\(\ \)\) 
      "\!\(None\) is not a string. Only strings can be set as the value of \
$Language."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$Language::notstr"],

Cell[BoxData[
    \(None\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$Language::notstr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::guesshb", "ObjectNameWarningMessages",
  CellTags->"Import::guesshb"],

Cell[BoxData[
    \(Import::"guesshb" \(\(:\)\(\ \)\) 
      "Could not guess format from channel `1`. Try using \"HarwellBoeing\" \
format."\)], "Message",
  CellLabel->"From In[10]:=",
  CellTags->"Import::guesshb"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::guesshb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::mpsbv", "ObjectNameWarningMessages",
  CellTags->"Import::mpsbv"],

Cell[BoxData[
    \(Import::"mpsbv" \(\(:\)\(\ \)\) \(Warning : \ 
        binary\ variables\ found\ in\ MPS\ data\ input\ and\ treated\ as\ \
\(\(real\)\(.\)\)\)\)], "Message",
  CellTags->"Import::mpsbv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::mpsbv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::mpsiv", "ObjectNameWarningMessages",
  CellTags->"Import::mpsiv"],

Cell[BoxData[
    \(Import::"mpsiv" \(\(:\)\(\ \)\) \(Warning : \ 
        integer\ variables\ found\ in\ MPS\ data\ input\ and\ treated\ as\ \(\
\(real\)\(.\)\)\)\)], "Message",
  CellTags->"Import::mpsiv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::mpsiv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import::mpsmr", "ObjectNameWarningMessages",
  CellTags->"Import::mpsmr"],

Cell[BoxData[
    \(Import::"mpsmr" \(\(:\)\(\ \)\) \(Warning : \ 
        multiple\ right - hand - 
          side\ found\ in\ MPS\ data\ input . \ 
              Only\ the\ first\ one\ is\ \(\(used\)\(.\)\)\)\)], "Message",
  CellTags->"Import::mpsmr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Import::mpsmr"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1344}, {0, 986}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{637, 590},
WindowMargins->{{-1, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "$Language::noset"->{
    Cell[1834, 57, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$Language::noset"],
    Cell[1922, 60, 592, 13, 33, "Message",
      CellTags->"$Language::noset"],
    Cell[2517, 75, 287, 8, 38, "Notes",
      CellTags->"$Language::noset"],
    Cell[2829, 87, 66, 1, 38, "ExampleSection",
      CellTags->"$Language::noset"],
    Cell[2898, 90, 213, 8, 24, "Text",
      CellTags->"$Language::noset"],
    Cell[3136, 102, 112, 3, 26, "Input",
      CellTags->"$Language::noset"],
    Cell[3251, 107, 286, 6, 47, "Message",
      CellTags->"$Language::noset"],
    Cell[3540, 115, 97, 3, 25, "Output",
      CellTags->"$Language::noset"]},
  "$BoxForms::formset"->{
    Cell[3698, 125, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$BoxForms::formset"],
    Cell[3790, 128, 430, 12, 33, "Message",
      CellTags->"$BoxForms::formset"],
    Cell[4223, 142, 293, 9, 38, "Notes",
      CellTags->"$BoxForms::formset"],
    Cell[4541, 155, 68, 1, 38, "ExampleSection",
      CellTags->"$BoxForms::formset"],
    Cell[4612, 158, 383, 11, 52, "Text",
      CellTags->"$BoxForms::formset"],
    Cell[5020, 173, 117, 3, 26, "Input",
      CellTags->"$BoxForms::formset"],
    Cell[5140, 178, 267, 5, 33, "Message",
      CellTags->"$BoxForms::formset"],
    Cell[5410, 185, 106, 3, 25, "Output",
      CellTags->"$BoxForms::formset"]},
  "$CharacterEncoding::sjis"->{
    Cell[5577, 195, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$CharacterEncoding::sjis"],
    Cell[5681, 198, 259, 4, 33, "Message",
      CellTags->"$CharacterEncoding::sjis"],
    Cell[5943, 204, 135, 4, 22, "Notes",
      CellTags->"$CharacterEncoding::sjis"]},
  "$CharacterEncoding::utf8"->{
    Cell[6115, 213, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$CharacterEncoding::utf8"],
    Cell[6219, 216, 256, 4, 47, "Message",
      CellTags->"$CharacterEncoding::utf8"],
    Cell[6478, 222, 135, 4, 22, "Notes",
      CellTags->"$CharacterEncoding::utf8"]},
  "$CharacterEncoding::charcode"->{
    Cell[6650, 231, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$CharacterEncoding::charcode"],
    Cell[6762, 234, 276, 5, 47, "Message",
      CellTags->"$CharacterEncoding::charcode"],
    Cell[7041, 241, 246, 5, 37, "Notes",
      CellTags->"$CharacterEncoding::charcode"],
    Cell[7312, 250, 78, 1, 38, "ExampleSection",
      CellTags->"$CharacterEncoding::charcode"],
    Cell[7393, 253, 222, 7, 23, "Text",
      CellTags->"$CharacterEncoding::charcode"],
    Cell[7640, 264, 128, 3, 26, "Input",
      CellTags->"$CharacterEncoding::charcode"],
    Cell[7771, 269, 284, 5, 47, "Message",
      CellTags->"$CharacterEncoding::charcode"],
    Cell[8058, 276, 108, 3, 25, "Output",
      CellTags->"$CharacterEncoding::charcode"],
    Cell[8181, 282, 354, 10, 39, "Text",
      CellTags->"$CharacterEncoding::charcode"]},
  "$CharacterEncoding::charfile"->{
    Cell[8584, 298, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$CharacterEncoding::charfile"],
    Cell[8696, 301, 272, 5, 53, "Message",
      CellTags->"$CharacterEncoding::charfile"],
    Cell[8971, 308, 751, 15, 116, "Notes",
      CellTags->"$CharacterEncoding::charfile"]},
  "TableForm::wtfsp"->{
    Cell[9759, 328, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"TableForm::wtfsp"],
    Cell[9847, 331, 242, 5, 37, "Message",
      CellTags->"TableForm::wtfsp"],
    Cell[10092, 338, 404, 10, 62, "Notes",
      CellTags->"TableForm::wtfsp"],
    Cell[10521, 352, 66, 1, 38, "ExampleSection",
      CellTags->"TableForm::wtfsp"],
    Cell[10590, 355, 181, 5, 24, "Text",
      CellTags->"TableForm::wtfsp"],
    Cell[10796, 364, 145, 3, 26, "Input",
      CellTags->"TableForm::wtfsp"],
    Cell[10944, 369, 236, 5, 37, "Message",
      CellTags->"TableForm::wtfsp"],
    Cell[11183, 376, 378, 12, 41, "Output",
      CellTags->"TableForm::wtfsp"]},
  "Integrate::intnest"->{
    Cell[11622, 395, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Integrate::intnest"],
    Cell[11714, 398, 268, 5, 53, "Message",
      CellTags->"Integrate::intnest"],
    Cell[11985, 405, 518, 9, 84, "Notes",
      CellTags->"Integrate::intnest"],
    Cell[12528, 418, 68, 1, 38, "ExampleSection",
      CellTags->"Integrate::intnest"],
    Cell[12599, 421, 227, 5, 40, "Text",
      CellTags->"Integrate::intnest"],
    Cell[12851, 430, 139, 3, 40, "Input",
      CellTags->"Integrate::intnest"],
    Cell[12993, 435, 347, 6, 69, "Message",
      CellTags->"Integrate::intnest"],
    Cell[13343, 443, 207, 5, 35, "Message",
      CellTags->"Integrate::intnest"],
    Cell[13565, 451, 152, 4, 24, "Text",
      CellTags->"Integrate::intnest"],
    Cell[13742, 459, 156, 4, 40, "Input",
      CellTags->"Integrate::intnest"],
    Cell[13901, 465, 99, 3, 39, "Output",
      CellTags->"Integrate::intnest"]},
  "AccountingForm::expint"->{
    Cell[14061, 475, 297, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[14361, 486, 661, 14, 37, "Message",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[15025, 502, 838, 18, 100, "Notes",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[15888, 524, 179, 3, 38, "ExampleSection",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16070, 529, 415, 12, 40, "Text",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16510, 545, 254, 5, 26, "Input",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16767, 552, 392, 8, 53, "Message",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[17162, 562, 382, 9, 35, "Output",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[17559, 574, 440, 11, 40, "Text",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[18024, 589, 275, 6, 26, "Input",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[18302, 597, 382, 9, 33, "Output",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}]},
  "EngineeringForm::expint"->{
    Cell[14061, 475, 297, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[14361, 486, 661, 14, 37, "Message",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[15025, 502, 838, 18, 100, "Notes",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[15888, 524, 179, 3, 38, "ExampleSection",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16070, 529, 415, 12, 40, "Text",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16510, 545, 254, 5, 26, "Input",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16767, 552, 392, 8, 53, "Message",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[17162, 562, 382, 9, 35, "Output",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[17559, 574, 440, 11, 40, "Text",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[18024, 589, 275, 6, 26, "Input",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[18302, 597, 382, 9, 33, "Output",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}]},
  "NumberForm::expint"->{
    Cell[14061, 475, 297, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[14361, 486, 661, 14, 37, "Message",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[15025, 502, 838, 18, 100, "Notes",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[15888, 524, 179, 3, 38, "ExampleSection",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16070, 529, 415, 12, 40, "Text",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16510, 545, 254, 5, 26, "Input",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16767, 552, 392, 8, 53, "Message",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[17162, 562, 382, 9, 35, "Output",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[17559, 574, 440, 11, 40, "Text",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[18024, 589, 275, 6, 26, "Input",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[18302, 597, 382, 9, 33, "Output",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}]},
  "PaddedForm::expint"->{
    Cell[14061, 475, 297, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[14361, 486, 661, 14, 37, "Message",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[15025, 502, 838, 18, 100, "Notes",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[15888, 524, 179, 3, 38, "ExampleSection",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16070, 529, 415, 12, 40, "Text",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16510, 545, 254, 5, 26, "Input",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16767, 552, 392, 8, 53, "Message",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[17162, 562, 382, 9, 35, "Output",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[17559, 574, 440, 11, 40, "Text",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[18024, 589, 275, 6, 26, "Input",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[18302, 597, 382, 9, 33, "Output",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}]},
  "ScientificForm::expint"->{
    Cell[14061, 475, 297, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[14361, 486, 661, 14, 37, "Message",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[15025, 502, 838, 18, 100, "Notes",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[15888, 524, 179, 3, 38, "ExampleSection",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16070, 529, 415, 12, 40, "Text",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16510, 545, 254, 5, 26, "Input",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[16767, 552, 392, 8, 53, "Message",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[17162, 562, 382, 9, 35, "Output",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[17559, 574, 440, 11, 40, "Text",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[18024, 589, 275, 6, 26, "Input",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}],
    Cell[18302, 597, 382, 9, 33, "Output",
      CellTags->{
      "AccountingForm::expint", "EngineeringForm::expint", 
        "NumberForm::expint", "PaddedForm::expint", 
        "ScientificForm::expint"}]},
  "General::uniopen"->{
    Cell[18745, 613, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::uniopen"],
    Cell[18833, 616, 374, 11, 21, "Message",
      CellTags->"General::uniopen"],
    Cell[19210, 629, 392, 9, 62, "Notes",
      CellTags->"General::uniopen"]},
  "General::uniclose"->{
    Cell[19639, 643, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::uniclose"],
    Cell[19729, 646, 375, 11, 21, "Message",
      CellTags->"General::uniclose"],
    Cell[20107, 659, 394, 9, 62, "Notes",
      CellTags->"General::uniclose"],
    Cell[20526, 672, 67, 1, 38, "ExampleSection",
      CellTags->"General::uniclose"],
    Cell[20596, 675, 93, 1, 24, "Text",
      CellTags->"General::uniclose"],
    Cell[20714, 680, 116, 3, 26, "Input",
      CellTags->"General::uniclose"],
    Cell[20833, 685, 173, 4, 21, "Print",
      CellTags->"General::uniclose"],
    Cell[21043, 694, 130, 3, 26, "Input",
      CellTags->"General::uniclose"],
    Cell[21176, 699, 173, 4, 21, "Print",
      CellTags->"General::uniclose"]},
  "Integrate::nodiffd"->{
    Cell[21410, 710, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Integrate::nodiffd"],
    Cell[21502, 713, 317, 6, 68, "Message",
      CellTags->"Integrate::nodiffd"],
    Cell[21822, 721, 626, 11, 100, "Notes",
      CellTags->"Integrate::nodiffd"],
    Cell[22473, 736, 68, 1, 38, "ExampleSection",
      CellTags->"Integrate::nodiffd"],
    Cell[22544, 739, 229, 5, 40, "Text",
      CellTags->"Integrate::nodiffd"],
    Cell[22798, 748, 103, 3, 40, "Input",
      CellTags->"Integrate::nodiffd"],
    Cell[22904, 753, 305, 5, 85, "Message",
      CellTags->"Integrate::nodiffd"],
    Cell[23212, 760, 142, 4, 35, "Message",
      CellTags->"Integrate::nodiffd"],
    Cell[23369, 767, 90, 1, 24, "Text",
      CellTags->"Integrate::nodiffd"],
    Cell[23484, 772, 122, 3, 40, "Input",
      CellTags->"Integrate::nodiffd"],
    Cell[23609, 777, 99, 3, 39, "Output",
      CellTags->"Integrate::nodiffd"]},
  "AccountingForm::iprf"->{
    Cell[23769, 787, 277, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[24049, 798, 589, 14, 37, "Message",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[24641, 814, 843, 20, 116, "Notes",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[25509, 838, 169, 3, 38, "ExampleSection",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[25681, 843, 315, 9, 24, "Text",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26021, 856, 262, 6, 26, "Input",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26286, 864, 340, 7, 33, "Message",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26629, 873, 595, 16, 84, "Output",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27239, 892, 264, 7, 23, "Text",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27528, 903, 267, 6, 26, "Input",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27798, 911, 621, 16, 84, "Output",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}]},
  "EngineeringForm::iprf"->{
    Cell[23769, 787, 277, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[24049, 798, 589, 14, 37, "Message",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[24641, 814, 843, 20, 116, "Notes",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[25509, 838, 169, 3, 38, "ExampleSection",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[25681, 843, 315, 9, 24, "Text",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26021, 856, 262, 6, 26, "Input",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26286, 864, 340, 7, 33, "Message",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26629, 873, 595, 16, 84, "Output",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27239, 892, 264, 7, 23, "Text",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27528, 903, 267, 6, 26, "Input",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27798, 911, 621, 16, 84, "Output",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}]},
  "NumberForm::iprf"->{
    Cell[23769, 787, 277, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[24049, 798, 589, 14, 37, "Message",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[24641, 814, 843, 20, 116, "Notes",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[25509, 838, 169, 3, 38, "ExampleSection",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[25681, 843, 315, 9, 24, "Text",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26021, 856, 262, 6, 26, "Input",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26286, 864, 340, 7, 33, "Message",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26629, 873, 595, 16, 84, "Output",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27239, 892, 264, 7, 23, "Text",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27528, 903, 267, 6, 26, "Input",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27798, 911, 621, 16, 84, "Output",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}]},
  "PaddedForm::iprf"->{
    Cell[23769, 787, 277, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[24049, 798, 589, 14, 37, "Message",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[24641, 814, 843, 20, 116, "Notes",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[25509, 838, 169, 3, 38, "ExampleSection",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[25681, 843, 315, 9, 24, "Text",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26021, 856, 262, 6, 26, "Input",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26286, 864, 340, 7, 33, "Message",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26629, 873, 595, 16, 84, "Output",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27239, 892, 264, 7, 23, "Text",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27528, 903, 267, 6, 26, "Input",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27798, 911, 621, 16, 84, "Output",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}]},
  "ScientificForm::iprf"->{
    Cell[23769, 787, 277, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[24049, 798, 589, 14, 37, "Message",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[24641, 814, 843, 20, 116, "Notes",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[25509, 838, 169, 3, 38, "ExampleSection",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[25681, 843, 315, 9, 24, "Text",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26021, 856, 262, 6, 26, "Input",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26286, 864, 340, 7, 33, "Message",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[26629, 873, 595, 16, 84, "Output",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27239, 892, 264, 7, 23, "Text",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27528, 903, 267, 6, 26, "Input",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}],
    Cell[27798, 911, 621, 16, 84, "Output",
      CellTags->{
      "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
        "PaddedForm::iprf", "ScientificForm::iprf"}]},
  "BaseForm::basf"->{
    Cell[28480, 934, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"BaseForm::basf"],
    Cell[28564, 937, 375, 11, 19, "Message",
      CellTags->"BaseForm::basf"],
    Cell[28942, 950, 541, 12, 77, "Notes",
      CellTags->"BaseForm::basf"],
    Cell[29508, 966, 64, 1, 38, "ExampleSection",
      CellTags->"BaseForm::basf"],
    Cell[29575, 969, 202, 5, 37, "Text",
      CellTags->"BaseForm::basf"],
    Cell[29802, 978, 110, 3, 26, "Input",
      CellTags->"BaseForm::basf"],
    Cell[29915, 983, 203, 5, 19, "Message",
      CellTags->"BaseForm::basf"],
    Cell[30121, 990, 120, 3, 37, "Output",
      CellTags->"BaseForm::basf"],
    Cell[30256, 996, 127, 5, 23, "Text",
      CellTags->"BaseForm::basf"],
    Cell[30408, 1005, 127, 3, 26, "Input",
      CellTags->"BaseForm::basf"],
    Cell[30538, 1010, 541, 15, 37, "Output",
      CellTags->"BaseForm::basf"],
    Cell[31094, 1028, 207, 7, 23, "Text",
      CellTags->"BaseForm::basf"],
    Cell[31326, 1039, 110, 3, 26, "Input",
      CellTags->"BaseForm::basf"],
    Cell[31439, 1044, 127, 3, 25, "Output",
      CellTags->"BaseForm::basf"]},
  "ColumnForm::colmh"->{
    Cell[31627, 1054, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ColumnForm::colmh"],
    Cell[31717, 1057, 295, 6, 37, "Message",
      CellTags->"ColumnForm::colmh"],
    Cell[32015, 1065, 299, 11, 24, "Notes",
      CellTags->"ColumnForm::colmh"],
    Cell[32339, 1080, 67, 1, 38, "ExampleSection",
      CellTags->"ColumnForm::colmh"],
    Cell[32409, 1083, 182, 5, 24, "Text",
      CellTags->"ColumnForm::colmh"],
    Cell[32616, 1092, 128, 3, 26, "Input",
      CellTags->"ColumnForm::colmh"],
    Cell[32747, 1097, 219, 5, 37, "Message",
      CellTags->"ColumnForm::colmh"],
    Cell[32969, 1104, 336, 11, 52, "Output",
      CellTags->"ColumnForm::colmh"],
    Cell[33320, 1118, 156, 5, 24, "Text",
      CellTags->"ColumnForm::colmh"],
    Cell[33501, 1127, 130, 3, 26, "Input",
      CellTags->"ColumnForm::colmh"],
    Cell[33634, 1132, 339, 11, 52, "Output",
      CellTags->"ColumnForm::colmh"]},
  "ColumnForm::colmv"->{
    Cell[34034, 1150, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ColumnForm::colmv"],
    Cell[34124, 1153, 294, 6, 37, "Message",
      CellTags->"ColumnForm::colmv"],
    Cell[34421, 1161, 299, 11, 24, "Notes",
      CellTags->"ColumnForm::colmv"],
    Cell[34745, 1176, 67, 1, 38, "ExampleSection",
      CellTags->"ColumnForm::colmv"],
    Cell[34815, 1179, 192, 5, 24, "Text",
      CellTags->"ColumnForm::colmv"],
    Cell[35032, 1188, 136, 3, 26, "Input",
      CellTags->"ColumnForm::colmv"],
    Cell[35171, 1193, 219, 5, 37, "Message",
      CellTags->"ColumnForm::colmv"],
    Cell[35393, 1200, 335, 11, 50, "Output",
      CellTags->"ColumnForm::colmv"],
    Cell[35743, 1214, 134, 5, 24, "Text",
      CellTags->"ColumnForm::colmv"],
    Cell[35902, 1223, 138, 3, 26, "Input",
      CellTags->"ColumnForm::colmv"],
    Cell[36043, 1228, 335, 11, 50, "Output",
      CellTags->"ColumnForm::colmv"]},
  "Context::quote"->{
    Cell[36439, 1246, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Context::quote"],
    Cell[36523, 1249, 546, 13, 37, "Message",
      CellTags->"Context::quote"],
    Cell[37072, 1264, 289, 7, 46, "Notes",
      CellTags->"Context::quote"],
    Cell[37386, 1275, 64, 1, 38, "ExampleSection",
      CellTags->"Context::quote"],
    Cell[37453, 1278, 203, 6, 24, "Text",
      CellTags->"Context::quote"],
    Cell[37681, 1288, 81, 2, 28, "Input",
      CellTags->"Context::quote"],
    Cell[37765, 1292, 276, 6, 53, "Message",
      CellTags->"Context::quote"],
    Cell[38044, 1300, 135, 2, 21, "Message",
      CellTags->"Context::quote"]},
  "Context::quote1"->{
    Cell[38240, 1309, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Context::quote1"],
    Cell[38326, 1312, 628, 14, 37, "Message",
      CellTags->"Context::quote1"],
    Cell[38957, 1328, 291, 7, 46, "Notes",
      CellTags->"Context::quote1"],
    Cell[39273, 1339, 65, 1, 38, "ExampleSection",
      CellTags->"Context::quote1"],
    Cell[39341, 1342, 204, 6, 24, "Text",
      CellTags->"Context::quote1"],
    Cell[39570, 1352, 85, 2, 28, "Input",
      CellTags->"Context::quote1"],
    Cell[39658, 1356, 310, 6, 69, "Message",
      CellTags->"Context::quote1"],
    Cell[39971, 1364, 139, 2, 21, "Message",
      CellTags->"Context::quote1"]},
  "Derivative::novar"->{
    Cell[40171, 1373, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Derivative::novar"],
    Cell[40261, 1376, 239, 5, 37, "Message",
      CellTags->"Derivative::novar"],
    Cell[40503, 1383, 473, 10, 62, "Notes",
      CellTags->"Derivative::novar"],
    Cell[41001, 1397, 67, 1, 38, "ExampleSection",
      CellTags->"Derivative::novar"],
    Cell[41071, 1400, 162, 4, 24, "Text",
      CellTags->"Derivative::novar"],
    Cell[41258, 1408, 111, 3, 26, "Input",
      CellTags->"Derivative::novar"],
    Cell[41372, 1413, 265, 5, 37, "Message",
      CellTags->"Derivative::novar"],
    Cell[41640, 1420, 179, 5, 21, "Message",
      CellTags->"Derivative::novar"],
    Cell[41834, 1428, 124, 4, 24, "Text",
      CellTags->"Derivative::novar"],
    Cell[41983, 1436, 114, 3, 26, "Input",
      CellTags->"Derivative::novar"],
    Cell[42100, 1441, 92, 3, 21, "Output",
      CellTags->"Derivative::novar"]},
  "Format::forml"->{
    Cell[42253, 1451, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[42382, 1457, 303, 8, 37, "Message",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[42688, 1467, 417, 8, 78, "Notes",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[43130, 1479, 85, 1, 38, "ExampleSection",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[43218, 1482, 206, 4, 40, "Text",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[43449, 1490, 138, 3, 26, "Input",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[43590, 1495, 262, 5, 37, "Message",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[43889, 1505, 127, 3, 26, "Input",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[44019, 1510, 229, 5, 37, "Message",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[44251, 1517, 157, 6, 31, "Output",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[44423, 1526, 148, 4, 24, "Text",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[44574, 1532, 144, 3, 26, "Input",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[44743, 1539, 127, 3, 26, "Input",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[44873, 1544, 157, 6, 31, "Output",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[45045, 1553, 147, 5, 24, "Text",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[45195, 1560, 128, 3, 26, "Input",
      CellTags->{"Format::forml", "ToBoxForm::forml"}]},
  "ToBoxForm::forml"->{
    Cell[42253, 1451, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[42382, 1457, 303, 8, 37, "Message",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[42688, 1467, 417, 8, 78, "Notes",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[43130, 1479, 85, 1, 38, "ExampleSection",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[43218, 1482, 206, 4, 40, "Text",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[43449, 1490, 138, 3, 26, "Input",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[43590, 1495, 262, 5, 37, "Message",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[43889, 1505, 127, 3, 26, "Input",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[44019, 1510, 229, 5, 37, "Message",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[44251, 1517, 157, 6, 31, "Output",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[44423, 1526, 148, 4, 24, "Text",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[44574, 1532, 144, 3, 26, "Input",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[44743, 1539, 127, 3, 26, "Input",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[44873, 1544, 157, 6, 31, "Output",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[45045, 1553, 147, 5, 24, "Text",
      CellTags->{"Format::forml", "ToBoxForm::forml"}],
    Cell[45195, 1560, 128, 3, 26, "Input",
      CellTags->{"Format::forml", "ToBoxForm::forml"}]},
  "Format::fttp"->{
    Cell[45372, 1569, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Format::fttp"],
    Cell[45452, 1572, 228, 5, 21, "Message",
      CellTags->"Format::fttp"],
    Cell[45683, 1579, 308, 7, 46, "Notes",
      CellTags->"Format::fttp"],
    Cell[46016, 1590, 62, 1, 38, "ExampleSection",
      CellTags->"Format::fttp"],
    Cell[46081, 1593, 202, 5, 40, "Text",
      CellTags->"Format::fttp"],
    Cell[46308, 1602, 128, 3, 26, "Input",
      CellTags->"Format::fttp"],
    Cell[46439, 1607, 175, 4, 21, "Message",
      CellTags->"Format::fttp"],
    Cell[46617, 1613, 93, 3, 21, "Output",
      CellTags->"Format::fttp"],
    Cell[46725, 1619, 100, 1, 24, "Text",
      CellTags->"Format::fttp"],
    Cell[46828, 1622, 128, 3, 26, "Input",
      CellTags->"Format::fttp"],
    Cell[46981, 1629, 105, 3, 26, "Input",
      CellTags->"Format::fttp"],
    Cell[47089, 1634, 92, 2, 35, "Output",
      CellTags->"Format::fttp"],
    Cell[47196, 1639, 124, 5, 24, "Text",
      CellTags->"Format::fttp"],
    Cell[47323, 1646, 118, 3, 26, "Input",
      CellTags->"Format::fttp"]},
  "Format::lcont"->{
    Cell[47490, 1655, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Format::lcont"],
    Cell[47572, 1658, 159, 3, 21, "Message",
      CellTags->"Format::lcont"],
    Cell[47734, 1663, 462, 9, 68, "Notes",
      CellTags->"Format::lcont"]},
  "Format::toobig"->{
    Cell[48233, 1677, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Format::toobig"],
    Cell[48317, 1680, 150, 3, 21, "Message",
      CellTags->"Format::toobig"],
    Cell[48470, 1685, 414, 8, 68, "Notes",
      CellTags->"Format::toobig"],
    Cell[48909, 1697, 64, 1, 38, "ExampleSection",
      CellTags->"Format::toobig"],
    Cell[48976, 1700, 225, 5, 40, "Text",
      CellTags->"Format::toobig"],
    Cell[49226, 1709, 123, 3, 26, "Input",
      CellTags->"Format::toobig"],
    Cell[49352, 1714, 166, 4, 21, "Message",
      CellTags->"Format::toobig"],
    Cell[49521, 1720, 100, 3, 21, "Output",
      CellTags->"Format::toobig"],
    Cell[49636, 1726, 162, 4, 24, "Text",
      CellTags->"Format::toobig"],
    Cell[49823, 1734, 124, 3, 26, "Input",
      CellTags->"Format::toobig"],
    Cell[49950, 1739, 97, 3, 21, "Output",
      CellTags->"Format::toobig"]},
  "FormatType::ftype"->{
    Cell[50108, 1749, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FormatType::ftype"],
    Cell[50198, 1752, 259, 5, 21, "Message",
      CellTags->"FormatType::ftype"],
    Cell[50460, 1759, 261, 7, 40, "Notes",
      CellTags->"FormatType::ftype"],
    Cell[50746, 1770, 67, 1, 38, "ExampleSection",
      CellTags->"FormatType::ftype"],
    Cell[50816, 1773, 254, 7, 40, "Text",
      CellTags->"FormatType::ftype"],
    Cell[51095, 1784, 174, 4, 42, "Input",
      CellTags->"FormatType::ftype"],
    Cell[51272, 1790, 199, 5, 21, "Message",
      CellTags->"FormatType::ftype"],
    Cell[51474, 1797, 97, 3, 21, "Output",
      CellTags->"FormatType::ftype"],
    Cell[51608, 1805, 101, 3, 26, "Input",
      CellTags->"FormatType::ftype"],
    Cell[51712, 1810, 203, 4, 37, "Output",
      CellTags->"FormatType::ftype"],
    Cell[51930, 1817, 144, 5, 24, "Text",
      CellTags->"FormatType::ftype"],
    Cell[52099, 1826, 174, 4, 42, "Input",
      CellTags->"FormatType::ftype"],
    Cell[52276, 1832, 97, 3, 21, "Output",
      CellTags->"FormatType::ftype"],
    Cell[52388, 1838, 70, 1, 24, "Text",
      CellTags->"FormatType::ftype"],
    Cell[52461, 1841, 112, 3, 26, "Input",
      CellTags->"FormatType::ftype"]},
  "General::estep"->{
    Cell[52622, 1850, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::estep"],
    Cell[52706, 1853, 500, 15, 21, "Message",
      CellTags->"General::estep"],
    Cell[53209, 1870, 202, 5, 24, "Notes",
      CellTags->"General::estep"],
    Cell[53436, 1879, 64, 1, 38, "ExampleSection",
      CellTags->"General::estep"],
    Cell[53503, 1882, 211, 5, 40, "Text",
      CellTags->"General::estep"],
    Cell[53739, 1891, 155, 4, 26, "Input",
      CellTags->"General::estep"],
    Cell[53897, 1897, 218, 5, 37, "Message",
      CellTags->"General::estep"],
    Cell[54118, 1904, 547, 15, 35, "Output",
      CellTags->"General::estep"],
    Cell[54680, 1922, 143, 5, 24, "Text",
      CellTags->"General::estep"],
    Cell[54848, 1931, 148, 4, 26, "Input",
      CellTags->"General::estep"],
    Cell[54999, 1937, 548, 15, 35, "Output",
      CellTags->"General::estep"]},
  "General::fmtval"->{
    Cell[55608, 1959, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::fmtval"],
    Cell[55694, 1962, 375, 11, 21, "Message",
      CellTags->"General::fmtval"],
    Cell[56072, 1975, 599, 18, 84, "Notes",
      CellTags->"General::fmtval"],
    Cell[56696, 1997, 65, 1, 38, "ExampleSection",
      CellTags->"General::fmtval"],
    Cell[56764, 2000, 197, 5, 24, "Text",
      CellTags->"General::fmtval"],
    Cell[56986, 2009, 129, 3, 26, "Input",
      CellTags->"General::fmtval"],
    Cell[57118, 2014, 180, 4, 21, "Message",
      CellTags->"General::fmtval"],
    Cell[57301, 2020, 136, 3, 23, "Output",
      CellTags->"General::fmtval"],
    Cell[57452, 2026, 142, 5, 24, "Text",
      CellTags->"General::fmtval"],
    Cell[57619, 2035, 133, 3, 26, "Input",
      CellTags->"General::fmtval"],
    Cell[57755, 2040, 98, 3, 21, "Output",
      CellTags->"General::fmtval"],
    Cell[57868, 2046, 261, 9, 40, "Text",
      CellTags->"General::fmtval"],
    Cell[58154, 2059, 99, 3, 26, "Input",
      CellTags->"General::fmtval"],
    Cell[58256, 2064, 201, 4, 37, "Output",
      CellTags->"General::fmtval"],
    Cell[58494, 2073, 97, 3, 26, "Input",
      CellTags->"General::fmtval"],
    Cell[58594, 2078, 120, 3, 21, "Output",
      CellTags->"General::fmtval"]},
  "General::ifexp"->{
    Cell[58775, 2088, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ifexp"],
    Cell[58859, 2091, 368, 11, 21, "Message",
      CellTags->"General::ifexp"],
    Cell[59230, 2104, 585, 17, 62, "Notes",
      CellTags->"General::ifexp"]},
  "General::ifpa"->{
    Cell[59852, 2126, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ifpa"],
    Cell[59934, 2129, 442, 11, 37, "Message",
      CellTags->"General::ifpa"],
    Cell[60379, 2142, 542, 18, 40, "Notes",
      CellTags->"General::ifpa"],
    Cell[60946, 2164, 63, 1, 38, "ExampleSection",
      CellTags->"General::ifpa"],
    Cell[61012, 2167, 216, 5, 40, "Text",
      CellTags->"General::ifpa"],
    Cell[61253, 2176, 466, 8, 122, "Input",
      CellTags->"General::ifpa"],
    Cell[61722, 2186, 297, 6, 69, "Message",
      CellTags->"General::ifpa"],
    Cell[62022, 2194, 202, 7, 51, "Message",
      CellTags->"General::ifpa"],
    Cell[62227, 2203, 94, 3, 21, "Output",
      CellTags->"General::ifpa"]},
  "General::npad"->{
    Cell[62382, 2213, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::npad"],
    Cell[62464, 2216, 515, 15, 37, "Message",
      CellTags->"General::npad"],
    Cell[62982, 2233, 201, 5, 24, "Notes",
      CellTags->"General::npad"],
    Cell[63208, 2242, 63, 1, 38, "ExampleSection",
      CellTags->"General::npad"],
    Cell[63274, 2245, 202, 5, 40, "Text",
      CellTags->"General::npad"],
    Cell[63501, 2254, 167, 4, 42, "Input",
      CellTags->"General::npad"],
    Cell[63671, 2260, 226, 5, 37, "Message",
      CellTags->"General::npad"],
    Cell[63900, 2267, 476, 13, 64, "Output",
      CellTags->"General::npad"],
    Cell[64391, 2283, 143, 5, 24, "Text",
      CellTags->"General::npad"],
    Cell[64559, 2292, 173, 4, 42, "Input",
      CellTags->"General::npad"],
    Cell[64735, 2298, 492, 13, 64, "Output",
      CellTags->"General::npad"]},
  "General::newl"->{
    Cell[65288, 2318, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::newl"],
    Cell[65370, 2321, 364, 11, 37, "Message",
      CellTags->"General::newl"],
    Cell[65737, 2334, 305, 7, 46, "Notes",
      CellTags->"General::newl"],
    Cell[66067, 2345, 63, 1, 38, "ExampleSection",
      CellTags->"General::newl"],
    Cell[66133, 2348, 211, 6, 37, "Text",
      CellTags->"General::newl"],
    Cell[66369, 2358, 167, 9, 113, "Input",
      CellTags->"General::newl"],
    Cell[66539, 2369, 197, 5, 32, "Message",
      CellTags->"General::newl"],
    Cell[66739, 2376, 98, 3, 21, "Print",
      CellTags->"General::newl"],
    Cell[66840, 2381, 92, 3, 21, "Print",
      CellTags->"General::newl"],
    Cell[66935, 2386, 94, 3, 25, "Output",
      CellTags->"General::newl"],
    Cell[67044, 2392, 153, 4, 22, "Text",
      CellTags->"General::newl"],
    Cell[67222, 2400, 169, 10, 130, "Input",
      CellTags->"General::newl"],
    Cell[67394, 2412, 98, 3, 21, "Print",
      CellTags->"General::newl"],
    Cell[67495, 2417, 92, 3, 21, "Print",
      CellTags->"General::newl"],
    Cell[67590, 2422, 88, 3, 25, "Output",
      CellTags->"General::newl"],
    Cell[67693, 2428, 181, 4, 36, "Text",
      CellTags->"General::newl"],
    Cell[67899, 2436, 170, 10, 130, "Input",
      CellTags->"General::newl"],
    Cell[68072, 2448, 98, 3, 21, "Print",
      CellTags->"General::newl"],
    Cell[68173, 2453, 92, 3, 21, "Print",
      CellTags->"General::newl"],
    Cell[68268, 2458, 94, 3, 25, "Output",
      CellTags->"General::newl"]},
  "General::nsgn"->{
    Cell[68423, 2468, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nsgn"],
    Cell[68505, 2471, 541, 15, 37, "Message",
      CellTags->"General::nsgn"],
    Cell[69049, 2488, 219, 5, 24, "Notes",
      CellTags->"General::nsgn"],
    Cell[69293, 2497, 63, 1, 38, "ExampleSection",
      CellTags->"General::nsgn"],
    Cell[69359, 2500, 216, 5, 40, "Text",
      CellTags->"General::nsgn"],
    Cell[69600, 2509, 159, 4, 26, "Input",
      CellTags->"General::nsgn"],
    Cell[69762, 2515, 250, 5, 53, "Message",
      CellTags->"General::nsgn"],
    Cell[70015, 2522, 432, 12, 33, "Output",
      CellTags->"General::nsgn"],
    Cell[70462, 2537, 141, 5, 24, "Text",
      CellTags->"General::nsgn"],
    Cell[70628, 2546, 157, 4, 26, "Input",
      CellTags->"General::nsgn"],
    Cell[70788, 2552, 423, 12, 33, "Output",
      CellTags->"General::nsgn"]},
  "General::npt"->{
    Cell[71272, 2571, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::npt"],
    Cell[71352, 2574, 506, 15, 21, "Message",
      CellTags->"General::npt"],
    Cell[71861, 2591, 177, 5, 24, "Notes",
      CellTags->"General::npt"],
    Cell[72063, 2600, 62, 1, 38, "ExampleSection",
      CellTags->"General::npt"],
    Cell[72128, 2603, 197, 5, 24, "Text",
      CellTags->"General::npt"],
    Cell[72350, 2612, 123, 3, 26, "Input",
      CellTags->"General::npt"],
    Cell[72476, 2617, 213, 5, 37, "Message",
      CellTags->"General::npt"],
    Cell[72692, 2624, 230, 7, 33, "Output",
      CellTags->"General::npt"],
    Cell[72937, 2634, 140, 5, 24, "Text",
      CellTags->"General::npt"],
    Cell[73102, 2643, 126, 3, 26, "Input",
      CellTags->"General::npt"],
    Cell[73231, 2648, 229, 7, 33, "Output",
      CellTags->"General::npt"]},
  "General::nspr"->{
    Cell[73521, 2662, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nspr"],
    Cell[73603, 2665, 517, 15, 37, "Message",
      CellTags->"General::nspr"],
    Cell[74123, 2682, 207, 5, 24, "Notes",
      CellTags->"General::nspr"],
    Cell[74355, 2691, 63, 1, 38, "ExampleSection",
      CellTags->"General::nspr"],
    Cell[74421, 2694, 202, 5, 40, "Text",
      CellTags->"General::nspr"],
    Cell[74648, 2703, 160, 4, 26, "Input",
      CellTags->"General::nspr"],
    Cell[74811, 2709, 227, 5, 37, "Message",
      CellTags->"General::nspr"],
    Cell[75041, 2716, 271, 8, 33, "Output",
      CellTags->"General::nspr"],
    Cell[75327, 2727, 145, 5, 24, "Text",
      CellTags->"General::nspr"],
    Cell[75497, 2736, 162, 4, 26, "Input",
      CellTags->"General::nspr"],
    Cell[75662, 2742, 267, 7, 33, "Output",
      CellTags->"General::nspr"]},
  "General::sntue"->{
    Cell[75990, 2756, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sntue"],
    Cell[76074, 2759, 389, 11, 21, "Message",
      CellTags->"General::sntue"],
    Cell[76466, 2772, 190, 5, 24, "Notes",
      CellTags->"General::sntue"],
    Cell[76681, 2781, 64, 1, 38, "ExampleSection",
      CellTags->"General::sntue"],
    Cell[76748, 2784, 147, 4, 24, "Text",
      CellTags->"General::sntue"],
    Cell[76920, 2792, 158, 4, 26, "Input",
      CellTags->"General::sntue"],
    Cell[77081, 2798, 98, 3, 21, "Output",
      CellTags->"General::sntue"],
    Cell[77216, 2806, 106, 3, 26, "Input",
      CellTags->"General::sntue"],
    Cell[77325, 2811, 191, 6, 51, "Message",
      CellTags->"General::sntue"],
    Cell[77531, 2820, 67, 1, 24, "Text",
      CellTags->"General::sntue"],
    Cell[77601, 2823, 113, 3, 26, "Input",
      CellTags->"General::sntue"]},
  "General::sntup"->{
    Cell[77763, 2832, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sntup"],
    Cell[77847, 2835, 388, 11, 21, "Message",
      CellTags->"General::sntup"],
    Cell[78238, 2848, 197, 5, 40, "Notes",
      CellTags->"General::sntup"],
    Cell[78460, 2857, 64, 1, 38, "ExampleSection",
      CellTags->"General::sntup"],
    Cell[78527, 2860, 137, 4, 24, "Text",
      CellTags->"General::sntup"],
    Cell[78689, 2868, 164, 4, 26, "Input",
      CellTags->"General::sntup"],
    Cell[78856, 2874, 98, 3, 21, "Output",
      CellTags->"General::sntup"],
    Cell[78991, 2882, 106, 3, 26, "Input",
      CellTags->"General::sntup"],
    Cell[79100, 2887, 190, 6, 51, "Message",
      CellTags->"General::sntup"],
    Cell[79305, 2896, 67, 1, 24, "Text",
      CellTags->"General::sntup"],
    Cell[79375, 2899, 113, 3, 26, "Input",
      CellTags->"General::sntup"]},
  "General::sntx"->{
    Cell[79537, 2908, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sntx"],
    Cell[79619, 2911, 317, 10, 21, "Message",
      CellTags->"General::sntx"],
    Cell[79939, 2923, 114, 4, 24, "Notes",
      CellTags->"General::sntx"],
    Cell[80078, 2931, 63, 1, 38, "ExampleSection",
      CellTags->"General::sntx"],
    Cell[80144, 2934, 203, 5, 40, "Text",
      CellTags->"General::sntx"],
    Cell[80372, 2943, 109, 3, 26, "Input",
      CellTags->"General::sntx"],
    Cell[80484, 2948, 189, 5, 36, "Message",
      CellTags->"General::sntx"],
    Cell[80676, 2955, 94, 3, 21, "Output",
      CellTags->"General::sntx"],
    Cell[80785, 2961, 84, 1, 24, "Text",
      CellTags->"General::sntx"],
    Cell[80894, 2966, 109, 3, 26, "Input",
      CellTags->"General::sntx"],
    Cell[81006, 2971, 91, 3, 21, "Output",
      CellTags->"General::sntx"]},
  "General::sntxb"->{
    Cell[81158, 2981, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sntxb"],
    Cell[81242, 2984, 322, 10, 21, "Message",
      CellTags->"General::sntxb"],
    Cell[81567, 2996, 294, 7, 46, "Notes",
      CellTags->"General::sntxb"],
    Cell[81886, 3007, 64, 1, 38, "ExampleSection",
      CellTags->"General::sntxb"],
    Cell[81953, 3010, 231, 6, 40, "Text",
      CellTags->"General::sntxb"],
    Cell[82209, 3020, 74, 2, 28, "Input",
      CellTags->"General::sntxb"],
    Cell[82286, 3024, 128, 2, 21, "Message",
      CellTags->"General::sntxb"],
    Cell[82429, 3029, 140, 5, 23, "Text",
      CellTags->"General::sntxb"],
    Cell[82594, 3038, 76, 2, 28, "Input",
      CellTags->"General::sntxb"],
    Cell[82673, 3042, 89, 3, 25, "Output",
      CellTags->"General::sntxb"]},
  "General::sntxc"->{
    Cell[82823, 3052, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sntxc"],
    Cell[82907, 3055, 343, 10, 19, "Message",
      CellTags->"General::sntxc"],
    Cell[83253, 3067, 257, 6, 42, "Notes",
      CellTags->"General::sntxc"],
    Cell[83535, 3077, 64, 1, 38, "ExampleSection",
      CellTags->"General::sntxc"],
    Cell[83602, 3080, 172, 5, 23, "Text",
      CellTags->"General::sntxc"],
    Cell[83799, 3089, 97, 2, 28, "Input",
      CellTags->"General::sntxc"],
    Cell[83899, 3093, 224, 7, 58, "Message",
      CellTags->"General::sntxc"]},
  "General::sntxf"->{
    Cell[84184, 3107, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sntxf"],
    Cell[84268, 3110, 327, 10, 19, "Message",
      CellTags->"General::sntxf"],
    Cell[84598, 3122, 159, 5, 23, "Notes",
      CellTags->"General::sntxf"],
    Cell[84782, 3131, 64, 1, 38, "ExampleSection",
      CellTags->"General::sntxf"],
    Cell[84849, 3134, 128, 4, 22, "Text",
      CellTags->"General::sntxf"],
    Cell[85002, 3142, 77, 2, 28, "Input",
      CellTags->"General::sntxf"],
    Cell[85082, 3146, 131, 2, 19, "Message",
      CellTags->"General::sntxf"]},
  "General::sntxi"->{
    Cell[85274, 3155, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sntxi"],
    Cell[85358, 3158, 421, 12, 19, "Message",
      CellTags->"General::sntxi"],
    Cell[85782, 3172, 159, 5, 23, "Notes",
      CellTags->"General::sntxi"],
    Cell[85966, 3181, 64, 1, 38, "ExampleSection",
      CellTags->"General::sntxi"],
    Cell[86033, 3184, 169, 5, 23, "Text",
      CellTags->"General::sntxi"],
    Cell[86227, 3193, 73, 2, 28, "Input",
      CellTags->"General::sntxi"],
    Cell[86303, 3197, 137, 2, 21, "Message",
      CellTags->"General::sntxi"]},
  "General::sntxpi"->{
    Cell[86501, 3206, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sntxpi"],
    Cell[86587, 3209, 383, 11, 21, "Message",
      CellTags->"General::sntxpi"],
    Cell[86973, 3222, 262, 7, 40, "Notes",
      CellTags->"General::sntxpi"],
    Cell[87260, 3233, 65, 1, 38, "ExampleSection",
      CellTags->"General::sntxpi"],
    Cell[87328, 3236, 226, 7, 24, "Text",
      CellTags->"General::sntxpi"],
    Cell[87579, 3247, 128, 2, 28, "Input",
      CellTags->"General::sntxpi"],
    Cell[87710, 3251, 130, 3, 21, "Output",
      CellTags->"General::sntxpi"],
    Cell[87877, 3259, 77, 2, 28, "Input",
      CellTags->"General::sntxpi"],
    Cell[87957, 3263, 139, 2, 21, "Message",
      CellTags->"General::sntxpi"],
    Cell[88111, 3268, 119, 5, 24, "Text",
      CellTags->"General::sntxpi"],
    Cell[88233, 3275, 87, 2, 28, "Input",
      CellTags->"General::sntxpi"]},
  "General::sntxpr"->{
    Cell[88369, 3283, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sntxpr"],
    Cell[88455, 3286, 244, 7, 21, "Message",
      CellTags->"General::sntxpr"],
    Cell[88702, 3295, 263, 7, 40, "Notes",
      CellTags->"General::sntxpr"],
    Cell[88990, 3306, 65, 1, 38, "ExampleSection",
      CellTags->"General::sntxpr"],
    Cell[89058, 3309, 233, 7, 40, "Text",
      CellTags->"General::sntxpr"],
    Cell[89316, 3320, 130, 2, 28, "Input",
      CellTags->"General::sntxpr"],
    Cell[89449, 3324, 132, 3, 21, "Output",
      CellTags->"General::sntxpr"],
    Cell[89618, 3332, 77, 2, 28, "Input",
      CellTags->"General::sntxpr"],
    Cell[89698, 3336, 172, 4, 21, "Message",
      CellTags->"General::sntxpr"],
    Cell[89873, 3342, 132, 2, 21, "Message",
      CellTags->"General::sntxpr"],
    Cell[90020, 3347, 119, 5, 24, "Text",
      CellTags->"General::sntxpr"],
    Cell[90142, 3354, 87, 2, 28, "Input",
      CellTags->"General::sntxpr"]},
  "General::sntxq"->{
    Cell[90278, 3362, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sntxq"],
    Cell[90362, 3365, 337, 10, 21, "Message",
      CellTags->"General::sntxq"],
    Cell[90702, 3377, 195, 6, 24, "Notes",
      CellTags->"General::sntxq"],
    Cell[90922, 3387, 64, 1, 38, "ExampleSection",
      CellTags->"General::sntxq"],
    Cell[90989, 3390, 175, 5, 24, "Text",
      CellTags->"General::sntxq"],
    Cell[91189, 3399, 89, 2, 28, "Input",
      CellTags->"General::sntxq"],
    Cell[91281, 3403, 201, 6, 51, "Message",
      CellTags->"General::sntxq"]},
  "General::spell"->{
    Cell[91543, 3416, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::spell"],
    Cell[91627, 3419, 368, 11, 37, "Message",
      CellTags->"General::spell"],
    Cell[91998, 3432, 388, 8, 68, "Notes",
      CellTags->"General::spell"],
    Cell[92411, 3444, 64, 1, 38, "ExampleSection",
      CellTags->"General::spell"],
    Cell[92478, 3447, 153, 4, 24, "Text",
      CellTags->"General::spell"],
    Cell[92656, 3455, 115, 3, 26, "Input",
      CellTags->"General::spell"],
    Cell[92774, 3460, 250, 5, 37, "Message",
      CellTags->"General::spell"],
    Cell[93027, 3467, 89, 3, 21, "Output",
      CellTags->"General::spell"],
    Cell[93153, 3475, 108, 3, 26, "Input",
      CellTags->"General::spell"],
    Cell[93264, 3480, 250, 5, 33, "Message",
      CellTags->"General::spell"],
    Cell[93517, 3487, 259, 5, 33, "Message",
      CellTags->"General::spell"],
    Cell[93779, 3494, 109, 3, 25, "Output",
      CellTags->"General::spell"]},
  "General::spell1"->{
    Cell[93949, 3504, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::spell1"],
    Cell[94035, 3507, 377, 11, 33, "Message",
      CellTags->"General::spell1"],
    Cell[94415, 3520, 390, 8, 62, "Notes",
      CellTags->"General::spell1"],
    Cell[94830, 3532, 65, 1, 38, "ExampleSection",
      CellTags->"General::spell1"],
    Cell[94898, 3535, 144, 4, 22, "Text",
      CellTags->"General::spell1"],
    Cell[95067, 3543, 116, 3, 26, "Input",
      CellTags->"General::spell1"],
    Cell[95186, 3548, 251, 5, 33, "Message",
      CellTags->"General::spell1"],
    Cell[95440, 3555, 90, 3, 25, "Output",
      CellTags->"General::spell1"]},
  "General::ssle"->{
    Cell[95591, 3565, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ssle"],
    Cell[95673, 3568, 542, 16, 19, "Message",
      CellTags->"General::ssle"],
    Cell[96218, 3586, 172, 4, 22, "Notes",
      CellTags->"General::ssle"],
    Cell[96415, 3594, 63, 1, 38, "ExampleSection",
      CellTags->"General::ssle"],
    Cell[96481, 3597, 184, 5, 23, "Text",
      CellTags->"General::ssle"],
    Cell[96690, 3606, 106, 3, 26, "Input",
      CellTags->"General::ssle"],
    Cell[96799, 3611, 242, 5, 33, "Message",
      CellTags->"General::ssle"],
    Cell[97044, 3618, 107, 3, 25, "Output",
      CellTags->"General::ssle"],
    Cell[97166, 3624, 128, 5, 23, "Text",
      CellTags->"General::ssle"],
    Cell[97319, 3633, 104, 3, 26, "Input",
      CellTags->"General::ssle"],
    Cell[97426, 3638, 96, 3, 21, "Output",
      CellTags->"General::ssle"]},
  "General::tsntxi"->{
    Cell[97583, 3648, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::tsntxi"],
    Cell[97669, 3651, 331, 10, 21, "Message",
      CellTags->"General::tsntxi"],
    Cell[98003, 3663, 117, 4, 24, "Notes",
      CellTags->"General::tsntxi"],
    Cell[98145, 3671, 65, 1, 38, "ExampleSection",
      CellTags->"General::tsntxi"],
    Cell[98213, 3674, 123, 4, 24, "Text",
      CellTags->"General::tsntxi"],
    Cell[98361, 3682, 106, 3, 26, "Input",
      CellTags->"General::tsntxi"],
    Cell[98470, 3687, 217, 5, 21, "Message",
      CellTags->"General::tsntxi"],
    Cell[98690, 3694, 174, 5, 21, "Message",
      CellTags->"General::tsntxi"],
    Cell[98879, 3702, 92, 1, 24, "Text",
      CellTags->"General::tsntxi"],
    Cell[98996, 3707, 107, 3, 26, "Input",
      CellTags->"General::tsntxi"],
    Cell[99106, 3712, 90, 3, 21, "Output",
      CellTags->"General::tsntxi"]},
  "HorizontalForm::precd"->{
    Cell[99257, 3722, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"HorizontalForm::precd", "VerticalForm::precd"}],
    Cell[99408, 3728, 453, 11, 37, "Message",
      CellTags->{"HorizontalForm::precd", "VerticalForm::precd"}],
    Cell[99864, 3741, 607, 13, 100, "Notes",
      CellTags->{"HorizontalForm::precd", "VerticalForm::precd"}]},
  "VerticalForm::precd"->{
    Cell[99257, 3722, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"HorizontalForm::precd", "VerticalForm::precd"}],
    Cell[99408, 3728, 453, 11, 37, "Message",
      CellTags->{"HorizontalForm::precd", "VerticalForm::precd"}],
    Cell[99864, 3741, 607, 13, 100, "Notes",
      CellTags->{"HorizontalForm::precd", "VerticalForm::precd"}]},
  "Infix::group"->{
    Cell[100508, 3759, 151, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[100662, 3766, 508, 13, 37, "Message",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[101173, 3781, 468, 12, 78, "Notes",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[101666, 3797, 99, 1, 38, "ExampleSection",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[101768, 3800, 255, 7, 24, "Text",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[102048, 3811, 228, 5, 42, "Input",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[102279, 3818, 254, 5, 37, "Message",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[102536, 3825, 278, 8, 31, "Output",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[102829, 3836, 181, 5, 24, "Text",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[103035, 3845, 223, 5, 42, "Input",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[103261, 3852, 245, 7, 35, "Output",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}]},
  "Postfix::group"->{
    Cell[100508, 3759, 151, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[100662, 3766, 508, 13, 37, "Message",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[101173, 3781, 468, 12, 78, "Notes",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[101666, 3797, 99, 1, 38, "ExampleSection",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[101768, 3800, 255, 7, 24, "Text",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[102048, 3811, 228, 5, 42, "Input",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[102279, 3818, 254, 5, 37, "Message",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[102536, 3825, 278, 8, 31, "Output",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[102829, 3836, 181, 5, 24, "Text",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[103035, 3845, 223, 5, 42, "Input",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[103261, 3852, 245, 7, 35, "Output",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}]},
  "Prefix::group"->{
    Cell[100508, 3759, 151, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[100662, 3766, 508, 13, 37, "Message",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[101173, 3781, 468, 12, 78, "Notes",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[101666, 3797, 99, 1, 38, "ExampleSection",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[101768, 3800, 255, 7, 24, "Text",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[102048, 3811, 228, 5, 42, "Input",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[102279, 3818, 254, 5, 37, "Message",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[102536, 3825, 278, 8, 31, "Output",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[102829, 3836, 181, 5, 24, "Text",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[103035, 3845, 223, 5, 42, "Input",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
    Cell[103261, 3852, 245, 7, 35, "Output",
      CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}]},
  "Integrate::intmul"->{
    Cell[103567, 3866, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Integrate::intmul"],
    Cell[103657, 3869, 322, 6, 61, "Message",
      CellTags->"Integrate::intmul"],
    Cell[103982, 3877, 361, 7, 42, "Notes",
      CellTags->"Integrate::intmul"],
    Cell[104368, 3888, 67, 1, 38, "ExampleSection",
      CellTags->"Integrate::intmul"],
    Cell[104438, 3891, 167, 4, 22, "Text",
      CellTags->"Integrate::intmul"],
    Cell[104630, 3899, 475, 15, 40, "Input",
      CellTags->"Integrate::intmul"],
    Cell[105108, 3916, 368, 7, 65, "Message",
      CellTags->"Integrate::intmul"],
    Cell[105479, 3925, 251, 6, 31, "Message",
      CellTags->"Integrate::intmul"],
    Cell[105745, 3934, 103, 1, 22, "Text",
      CellTags->"Integrate::intmul"],
    Cell[105873, 3939, 598, 19, 40, "Input",
      CellTags->"Integrate::intmul"],
    Cell[106474, 3960, 147, 3, 39, "Output",
      CellTags->"Integrate::intmul"]},
  "Integrate::novar"->{
    Cell[106682, 3970, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Integrate::novar"],
    Cell[106770, 3973, 313, 6, 46, "Message",
      CellTags->"Integrate::novar"],
    Cell[107086, 3981, 201, 5, 36, "Notes",
      CellTags->"Integrate::novar"],
    Cell[107312, 3990, 66, 1, 38, "ExampleSection",
      CellTags->"Integrate::novar"],
    Cell[107381, 3993, 137, 4, 22, "Text",
      CellTags->"Integrate::novar"],
    Cell[107543, 4001, 116, 3, 40, "Input",
      CellTags->"Integrate::novar"],
    Cell[107662, 4006, 343, 6, 85, "Message",
      CellTags->"Integrate::novar"],
    Cell[108008, 4014, 184, 5, 35, "Message",
      CellTags->"Integrate::novar"],
    Cell[108207, 4022, 104, 1, 24, "Text",
      CellTags->"Integrate::novar"],
    Cell[108336, 4027, 117, 3, 40, "Input",
      CellTags->"Integrate::novar"],
    Cell[108456, 4032, 91, 3, 21, "Output",
      CellTags->"Integrate::novar"]},
  "Integrate::wrongd"->{
    Cell[108608, 4042, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Integrate::wrongd"],
    Cell[108698, 4045, 272, 5, 53, "Message",
      CellTags->"Integrate::wrongd"],
    Cell[108973, 4052, 228, 6, 24, "Notes",
      CellTags->"Integrate::wrongd"],
    Cell[109226, 4062, 67, 1, 38, "ExampleSection",
      CellTags->"Integrate::wrongd"],
    Cell[109296, 4065, 185, 5, 24, "Text",
      CellTags->"Integrate::wrongd"],
    Cell[109506, 4074, 112, 3, 40, "Input",
      CellTags->"Integrate::wrongd"],
    Cell[109621, 4079, 313, 6, 69, "Message",
      CellTags->"Integrate::wrongd"],
    Cell[109937, 4087, 180, 5, 35, "Message",
      CellTags->"Integrate::wrongd"],
    Cell[110132, 4095, 105, 1, 24, "Text",
      CellTags->"Integrate::wrongd"],
    Cell[110262, 4100, 125, 3, 40, "Input",
      CellTags->"Integrate::wrongd"],
    Cell[110390, 4105, 97, 3, 21, "Output",
      CellTags->"Integrate::wrongd"]},
  "General::dblk"->{
    Cell[110548, 4115, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::dblk"],
    Cell[110630, 4118, 323, 8, 37, "Message",
      CellTags->"General::dblk"],
    Cell[110956, 4128, 194, 5, 24, "Notes",
      CellTags->"General::dblk"],
    Cell[111175, 4137, 63, 1, 38, "ExampleSection",
      CellTags->"General::dblk"],
    Cell[111241, 4140, 209, 7, 24, "Text",
      CellTags->"General::dblk"],
    Cell[111475, 4151, 180, 4, 42, "Input",
      CellTags->"General::dblk"],
    Cell[111658, 4157, 238, 5, 53, "Message",
      CellTags->"General::dblk"],
    Cell[111899, 4164, 292, 8, 33, "Output",
      CellTags->"General::dblk"],
    Cell[112206, 4175, 142, 5, 24, "Text",
      CellTags->"General::dblk"],
    Cell[112373, 4184, 177, 4, 42, "Input",
      CellTags->"General::dblk"],
    Cell[112553, 4190, 292, 8, 33, "Output",
      CellTags->"General::dblk"]},
  "NumberForm::sigz"->{
    Cell[112906, 4205, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NumberForm::sigz"],
    Cell[112994, 4208, 257, 6, 37, "Message",
      CellTags->"NumberForm::sigz"],
    Cell[113254, 4216, 337, 7, 62, "Notes",
      CellTags->"NumberForm::sigz"],
    Cell[113616, 4227, 66, 1, 38, "ExampleSection",
      CellTags->"NumberForm::sigz"],
    Cell[113685, 4230, 295, 6, 40, "Text",
      CellTags->"NumberForm::sigz"],
    Cell[114005, 4240, 143, 3, 26, "Input",
      CellTags->"NumberForm::sigz"],
    Cell[114151, 4245, 235, 5, 37, "Message",
      CellTags->"NumberForm::sigz"],
    Cell[114389, 4252, 282, 7, 33, "Output",
      CellTags->"NumberForm::sigz"]},
  "ParentForm::deflt"->{
    Cell[114732, 4266, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ParentForm::deflt"],
    Cell[114822, 4269, 268, 6, 21, "Message",
      CellTags->"ParentForm::deflt"],
    Cell[115093, 4277, 293, 8, 40, "Notes",
      CellTags->"ParentForm::deflt"],
    Cell[115411, 4289, 67, 1, 38, "ExampleSection",
      CellTags->"ParentForm::deflt"],
    Cell[115481, 4292, 205, 5, 40, "Text",
      CellTags->"ParentForm::deflt"],
    Cell[115711, 4301, 118, 3, 26, "Input",
      CellTags->"ParentForm::deflt"],
    Cell[115832, 4306, 131, 3, 21, "Output",
      CellTags->"ParentForm::deflt"],
    Cell[116000, 4314, 115, 3, 26, "Input",
      CellTags->"ParentForm::deflt"],
    Cell[116118, 4319, 216, 5, 37, "Message",
      CellTags->"ParentForm::deflt"],
    Cell[116337, 4326, 216, 5, 37, "Message",
      CellTags->"ParentForm::deflt"],
    Cell[116556, 4333, 216, 5, 37, "Message",
      CellTags->"ParentForm::deflt"],
    Cell[116775, 4340, 231, 5, 37, "Message",
      CellTags->"ParentForm::deflt"],
    Cell[117009, 4347, 114, 3, 21, "Output",
      CellTags->"ParentForm::deflt"],
    Cell[117138, 4353, 156, 5, 24, "Text",
      CellTags->"ParentForm::deflt"],
    Cell[117319, 4362, 128, 3, 26, "Input",
      CellTags->"ParentForm::deflt"],
    Cell[117450, 4367, 106, 3, 21, "Output",
      CellTags->"ParentForm::deflt"],
    Cell[117593, 4375, 115, 3, 26, "Input",
      CellTags->"ParentForm::deflt"],
    Cell[117711, 4380, 114, 3, 21, "Output",
      CellTags->"ParentForm::deflt"]},
  "Product::prodwarn"->{
    Cell[117886, 4390, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Product::prodwarn"],
    Cell[117976, 4393, 315, 7, 37, "Message",
      CellTags->"Product::prodwarn"],
    Cell[118294, 4402, 419, 9, 62, "Notes",
      CellTags->"Product::prodwarn"],
    Cell[118738, 4415, 67, 1, 38, "ExampleSection",
      CellTags->"Product::prodwarn"],
    Cell[118808, 4418, 161, 4, 24, "Text",
      CellTags->"Product::prodwarn"],
    Cell[118994, 4426, 210, 7, 40, "Input",
      CellTags->"Product::prodwarn"],
    Cell[119207, 4435, 258, 5, 52, "Message",
      CellTags->"Product::prodwarn"],
    Cell[119468, 4442, 112, 3, 35, "Output",
      CellTags->"Product::prodwarn"],
    Cell[119595, 4448, 105, 1, 24, "Text",
      CellTags->"Product::prodwarn"],
    Cell[119725, 4453, 208, 7, 50, "Input",
      CellTags->"Product::prodwarn"],
    Cell[119936, 4462, 94, 3, 21, "Output",
      CellTags->"Product::prodwarn"]},
  "Short::short"->{
    Cell[120091, 4472, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Short::short"],
    Cell[120171, 4475, 253, 6, 21, "Message",
      CellTags->"Short::short"],
    Cell[120427, 4483, 186, 5, 24, "Notes",
      CellTags->"Short::short"],
    Cell[120638, 4492, 62, 1, 38, "ExampleSection",
      CellTags->"Short::short"],
    Cell[120703, 4495, 188, 5, 24, "Text",
      CellTags->"Short::short"],
    Cell[120916, 4504, 117, 3, 26, "Input",
      CellTags->"Short::short"],
    Cell[121036, 4509, 318, 6, 37, "Message",
      CellTags->"Short::short"],
    Cell[121357, 4517, 495, 9, 85, "Output",
      CellTags->"Short::short"],
    Cell[121867, 4529, 124, 5, 24, "Text",
      CellTags->"Short::short"],
    Cell[122016, 4538, 117, 3, 26, "Input",
      CellTags->"Short::short"],
    Cell[122136, 4543, 246, 6, 21, "Output",
      CellTags->"Short::short"]},
  "Splice::splicd"->{
    Cell[122443, 4556, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Splice::splicd"],
    Cell[122527, 4559, 393, 11, 21, "Message",
      CellTags->"Splice::splicd"],
    Cell[122923, 4572, 188, 5, 24, "Notes",
      CellTags->"Splice::splicd"],
    Cell[123136, 4581, 64, 1, 38, "ExampleSection",
      CellTags->"Splice::splicd"],
    Cell[123203, 4584, 148, 4, 24, "Text",
      CellTags->"Splice::splicd"],
    Cell[123376, 4592, 379, 8, 138, "Input",
      CellTags->"Splice::splicd"],
    Cell[123758, 4602, 214, 5, 37, "Message",
      CellTags->"Splice::splicd"],
    Cell[123975, 4609, 101, 3, 21, "Output",
      CellTags->"Splice::splicd"],
    Cell[124091, 4615, 131, 5, 24, "Text",
      CellTags->"Splice::splicd"],
    Cell[124247, 4624, 381, 8, 138, "Input",
      CellTags->"Splice::splicd"],
    Cell[124631, 4634, 124, 3, 21, "Output",
      CellTags->"Splice::splicd"],
    Cell[124770, 4640, 68, 1, 24, "Text",
      CellTags->"Splice::splicd"],
    Cell[124841, 4643, 140, 3, 26, "Input",
      CellTags->"Splice::splicd"]},
  "Splice::splicf"->{
    Cell[125030, 4652, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Splice::splicf"],
    Cell[125114, 4655, 250, 5, 21, "Message",
      CellTags->"Splice::splicf"],
    Cell[125367, 4662, 556, 15, 78, "Notes",
      CellTags->"Splice::splicf"],
    Cell[125948, 4681, 64, 1, 38, "ExampleSection",
      CellTags->"Splice::splicf"],
    Cell[126015, 4684, 155, 4, 24, "Text",
      CellTags->"Splice::splicf"],
    Cell[126195, 4692, 347, 8, 154, "Input",
      CellTags->"Splice::splicf"],
    Cell[126545, 4702, 189, 4, 21, "Message",
      CellTags->"Splice::splicf"],
    Cell[126737, 4708, 120, 3, 25, "Output",
      CellTags->"Splice::splicf"],
    Cell[126872, 4714, 127, 5, 23, "Text",
      CellTags->"Splice::splicf"],
    Cell[127024, 4723, 350, 8, 154, "Input",
      CellTags->"Splice::splicf"],
    Cell[127377, 4733, 124, 3, 25, "Output",
      CellTags->"Splice::splicf"],
    Cell[127516, 4739, 68, 1, 22, "Text",
      CellTags->"Splice::splicf"],
    Cell[127587, 4742, 138, 3, 26, "Input",
      CellTags->"Splice::splicf"]},
  "Splice::splict"->{
    Cell[127774, 4751, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Splice::splict"],
    Cell[127858, 4754, 236, 5, 19, "Message",
      CellTags->"Splice::splict"],
    Cell[128097, 4761, 401, 13, 38, "Notes",
      CellTags->"Splice::splict"],
    Cell[128523, 4778, 64, 1, 38, "ExampleSection",
      CellTags->"Splice::splict"],
    Cell[128590, 4781, 222, 6, 37, "Text",
      CellTags->"Splice::splict"],
    Cell[128837, 4791, 370, 8, 154, "Input",
      CellTags->"Splice::splict"],
    Cell[129210, 4801, 185, 4, 19, "Message",
      CellTags->"Splice::splict"],
    Cell[129398, 4807, 164, 4, 19, "Message",
      CellTags->"Splice::splict"],
    Cell[129565, 4813, 167, 4, 21, "Message",
      CellTags->"Splice::splict"],
    Cell[129735, 4819, 112, 3, 21, "Output",
      CellTags->"Splice::splict"],
    Cell[129862, 4825, 145, 5, 24, "Text",
      CellTags->"Splice::splict"],
    Cell[130032, 4834, 404, 9, 154, "Input",
      CellTags->"Splice::splict"],
    Cell[130439, 4845, 124, 3, 21, "Output",
      CellTags->"Splice::splict"],
    Cell[130578, 4851, 68, 1, 24, "Text",
      CellTags->"Splice::splict"],
    Cell[130649, 4854, 140, 3, 26, "Input",
      CellTags->"Splice::splict"]},
  "Splice::splicx"->{
    Cell[130838, 4863, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Splice::splicx"],
    Cell[130922, 4866, 239, 5, 21, "Message",
      CellTags->"Splice::splicx"],
    Cell[131164, 4873, 249, 8, 24, "Notes",
      CellTags->"Splice::splicx"],
    Cell[131438, 4885, 64, 1, 38, "ExampleSection",
      CellTags->"Splice::splicx"],
    Cell[131505, 4888, 225, 5, 40, "Text",
      CellTags->"Splice::splicx"],
    Cell[131755, 4897, 380, 8, 138, "Input",
      CellTags->"Splice::splicx"],
    Cell[132138, 4907, 197, 5, 21, "Message",
      CellTags->"Splice::splicx"],
    Cell[132338, 4914, 101, 3, 21, "Output",
      CellTags->"Splice::splicx"],
    Cell[132454, 4920, 131, 5, 24, "Text",
      CellTags->"Splice::splicx"],
    Cell[132610, 4929, 381, 8, 138, "Input",
      CellTags->"Splice::splicx"],
    Cell[132994, 4939, 124, 3, 21, "Output",
      CellTags->"Splice::splicx"],
    Cell[133133, 4945, 68, 1, 24, "Text",
      CellTags->"Splice::splicx"],
    Cell[133204, 4948, 140, 3, 26, "Input",
      CellTags->"Splice::splicx"]},
  "StringForm::sfr"->{
    Cell[133393, 4957, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"StringForm::sfr"],
    Cell[133479, 4960, 205, 5, 37, "Message",
      CellTags->"StringForm::sfr"],
    Cell[133687, 4967, 431, 9, 78, "Notes",
      CellTags->"StringForm::sfr"],
    Cell[134143, 4980, 65, 1, 38, "ExampleSection",
      CellTags->"StringForm::sfr"],
    Cell[134211, 4983, 192, 5, 40, "Text",
      CellTags->"StringForm::sfr"],
    Cell[134428, 4992, 140, 3, 26, "Input",
      CellTags->"StringForm::sfr"],
    Cell[134571, 4997, 247, 5, 37, "Message",
      CellTags->"StringForm::sfr"],
    Cell[134821, 5004, 236, 5, 21, "Output",
      CellTags->"StringForm::sfr"],
    Cell[135072, 5012, 132, 5, 24, "Text",
      CellTags->"StringForm::sfr"],
    Cell[135229, 5021, 143, 3, 26, "Input",
      CellTags->"StringForm::sfr"],
    Cell[135375, 5026, 248, 6, 21, "Output",
      CellTags->"StringForm::sfr"]},
  "Subscripted::subn"->{
    Cell[135684, 5039, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Subscripted::subn"],
    Cell[135774, 5042, 289, 6, 37, "Message",
      CellTags->"Subscripted::subn"],
    Cell[136066, 5050, 193, 5, 24, "Notes",
      CellTags->"Subscripted::subn"],
    Cell[136284, 5059, 67, 1, 38, "ExampleSection",
      CellTags->"Subscripted::subn"],
    Cell[136354, 5062, 200, 5, 40, "Text",
      CellTags->"Subscripted::subn"],
    Cell[136579, 5071, 127, 3, 26, "Input",
      CellTags->"Subscripted::subn"],
    Cell[136709, 5076, 235, 5, 37, "Message",
      CellTags->"Subscripted::subn"],
    Cell[136947, 5083, 128, 3, 21, "Output",
      CellTags->"Subscripted::subn"],
    Cell[137090, 5089, 135, 5, 24, "Text",
      CellTags->"Subscripted::subn"],
    Cell[137250, 5098, 127, 3, 26, "Input",
      CellTags->"Subscripted::subn"],
    Cell[137380, 5103, 209, 6, 22, "Output",
      CellTags->"Subscripted::subn"]},
  "Subscripted::subv"->{
    Cell[137650, 5116, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Subscripted::subv"],
    Cell[137740, 5119, 182, 3, 21, "Message",
      CellTags->"Subscripted::subv"],
    Cell[137925, 5124, 470, 10, 78, "Notes",
      CellTags->"Subscripted::subv"],
    Cell[138420, 5138, 67, 1, 38, "ExampleSection",
      CellTags->"Subscripted::subv"],
    Cell[138490, 5141, 223, 6, 40, "Text",
      CellTags->"Subscripted::subv"],
    Cell[138738, 5151, 135, 3, 26, "Input",
      CellTags->"Subscripted::subv"],
    Cell[138876, 5156, 199, 5, 37, "Message",
      CellTags->"Subscripted::subv"],
    Cell[139078, 5163, 217, 6, 25, "Output",
      CellTags->"Subscripted::subv"],
    Cell[139310, 5172, 169, 5, 24, "Text",
      CellTags->"Subscripted::subv"],
    Cell[139504, 5181, 135, 3, 26, "Input",
      CellTags->"Subscripted::subv"],
    Cell[139642, 5186, 221, 6, 26, "Output",
      CellTags->"Subscripted::subv"]},
  "Subscripted::subx"->{
    Cell[139924, 5199, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Subscripted::subx"],
    Cell[140014, 5202, 434, 11, 19, "Message",
      CellTags->"Subscripted::subx"],
    Cell[140451, 5215, 529, 11, 71, "Notes",
      CellTags->"Subscripted::subx"],
    Cell[141005, 5230, 67, 1, 38, "ExampleSection",
      CellTags->"Subscripted::subx"],
    Cell[141075, 5233, 233, 5, 37, "Text",
      CellTags->"Subscripted::subx"],
    Cell[141333, 5242, 121, 3, 26, "Input",
      CellTags->"Subscripted::subx"],
    Cell[141457, 5247, 230, 5, 33, "Message",
      CellTags->"Subscripted::subx"],
    Cell[141690, 5254, 197, 6, 26, "Output",
      CellTags->"Subscripted::subx"],
    Cell[141902, 5263, 122, 4, 22, "Text",
      CellTags->"Subscripted::subx"],
    Cell[142049, 5271, 126, 3, 26, "Input",
      CellTags->"Subscripted::subx"],
    Cell[142178, 5276, 198, 6, 26, "Output",
      CellTags->"Subscripted::subx"]},
  "Sum::sumwarn"->{
    Cell[142437, 5289, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Sum::sumwarn"],
    Cell[142517, 5292, 309, 7, 33, "Message",
      CellTags->"Sum::sumwarn"],
    Cell[142829, 5301, 323, 7, 42, "Notes",
      CellTags->"Sum::sumwarn"],
    Cell[143177, 5312, 62, 1, 38, "ExampleSection",
      CellTags->"Sum::sumwarn"],
    Cell[143242, 5315, 162, 4, 22, "Text",
      CellTags->"Sum::sumwarn"],
    Cell[143429, 5323, 216, 7, 40, "Input",
      CellTags->"Sum::sumwarn"],
    Cell[143648, 5332, 263, 5, 47, "Message",
      CellTags->"Sum::sumwarn"],
    Cell[143914, 5339, 107, 3, 39, "Output",
      CellTags->"Sum::sumwarn"],
    Cell[144036, 5345, 92, 1, 22, "Text",
      CellTags->"Sum::sumwarn"],
    Cell[144153, 5350, 207, 7, 50, "Input",
      CellTags->"Sum::sumwarn"],
    Cell[144363, 5359, 88, 3, 21, "Output",
      CellTags->"Sum::sumwarn"]},
  "Syntax::noinfo"->{
    Cell[144512, 5369, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Syntax::noinfo"],
    Cell[144596, 5372, 196, 4, 37, "Message",
      CellTags->"Syntax::noinfo"],
    Cell[144795, 5378, 343, 9, 46, "Notes",
      CellTags->"Syntax::noinfo"],
    Cell[145163, 5391, 64, 1, 38, "ExampleSection",
      CellTags->"Syntax::noinfo"],
    Cell[145230, 5394, 250, 7, 40, "Text",
      CellTags->"Syntax::noinfo"],
    Cell[145505, 5405, 160, 4, 26, "Input",
      CellTags->"Syntax::noinfo"],
    Cell[145668, 5411, 209, 5, 37, "Message",
      CellTags->"Syntax::noinfo"],
    Cell[145880, 5418, 148, 4, 21, "Output",
      CellTags->"Syntax::noinfo"],
    Cell[146043, 5425, 147, 5, 24, "Text",
      CellTags->"Syntax::noinfo"],
    Cell[146215, 5434, 163, 4, 26, "Input",
      CellTags->"Syntax::noinfo"],
    Cell[146381, 5440, 117, 3, 21, "Output",
      CellTags->"Syntax::noinfo"]},
  "Syntax::snthex"->{
    Cell[146559, 5450, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Syntax::snthex"],
    Cell[146643, 5453, 215, 5, 37, "Message",
      CellTags->"Syntax::snthex"],
    Cell[146861, 5460, 256, 7, 24, "Notes",
      CellTags->"Syntax::snthex"],
    Cell[147142, 5471, 64, 1, 38, "ExampleSection",
      CellTags->"Syntax::snthex"],
    Cell[147209, 5474, 207, 5, 24, "Text",
      CellTags->"Syntax::snthex"],
    Cell[147441, 5483, 135, 3, 26, "Input",
      CellTags->"Syntax::snthex"],
    Cell[147579, 5488, 214, 5, 37, "Message",
      CellTags->"Syntax::snthex"],
    Cell[147796, 5495, 193, 5, 36, "Message",
      CellTags->"Syntax::snthex"],
    Cell[147992, 5502, 95, 3, 21, "Output",
      CellTags->"Syntax::snthex"],
    Cell[148102, 5508, 123, 4, 24, "Text",
      CellTags->"Syntax::snthex"],
    Cell[148250, 5516, 136, 3, 26, "Input",
      CellTags->"Syntax::snthex"],
    Cell[148389, 5521, 95, 3, 21, "Output",
      CellTags->"Syntax::snthex"]},
  "Syntax::sntoct1"->{
    Cell[148545, 5531, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Syntax::sntoct1"],
    Cell[148631, 5534, 210, 5, 37, "Message",
      CellTags->"Syntax::sntoct1"],
    Cell[148844, 5541, 255, 7, 24, "Notes",
      CellTags->"Syntax::sntoct1"],
    Cell[149124, 5552, 65, 1, 38, "ExampleSection",
      CellTags->"Syntax::sntoct1"],
    Cell[149192, 5555, 202, 5, 24, "Text",
      CellTags->"Syntax::sntoct1"],
    Cell[149419, 5564, 127, 3, 26, "Input",
      CellTags->"Syntax::sntoct1"],
    Cell[149549, 5569, 209, 5, 37, "Message",
      CellTags->"Syntax::sntoct1"],
    Cell[149761, 5576, 192, 5, 36, "Message",
      CellTags->"Syntax::sntoct1"],
    Cell[149956, 5583, 96, 3, 21, "Output",
      CellTags->"Syntax::sntoct1"],
    Cell[150067, 5589, 118, 4, 24, "Text",
      CellTags->"Syntax::sntoct1"],
    Cell[150210, 5597, 127, 3, 26, "Input",
      CellTags->"Syntax::sntoct1"],
    Cell[150340, 5602, 90, 3, 21, "Output",
      CellTags->"Syntax::sntoct1"]},
  "Syntax::sntoct2"->{
    Cell[150491, 5612, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Syntax::sntoct2"],
    Cell[150577, 5615, 217, 5, 37, "Message",
      CellTags->"Syntax::sntoct2"],
    Cell[150797, 5622, 255, 7, 24, "Notes",
      CellTags->"Syntax::sntoct2"],
    Cell[151077, 5633, 65, 1, 38, "ExampleSection",
      CellTags->"Syntax::sntoct2"],
    Cell[151145, 5636, 203, 5, 24, "Text",
      CellTags->"Syntax::sntoct2"],
    Cell[151373, 5645, 144, 3, 26, "Input",
      CellTags->"Syntax::sntoct2"],
    Cell[151520, 5650, 216, 5, 37, "Message",
      CellTags->"Syntax::sntoct2"],
    Cell[151739, 5657, 193, 5, 36, "Message",
      CellTags->"Syntax::sntoct2"],
    Cell[151935, 5664, 96, 3, 21, "Output",
      CellTags->"Syntax::sntoct2"],
    Cell[152046, 5670, 124, 4, 24, "Text",
      CellTags->"Syntax::sntoct2"],
    Cell[152195, 5678, 145, 3, 26, "Input",
      CellTags->"Syntax::sntoct2"],
    Cell[152343, 5683, 92, 3, 21, "Output",
      CellTags->"Syntax::sntoct2"]},
  "Syntax::sntufn"->{
    Cell[152496, 5693, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Syntax::sntufn"],
    Cell[152580, 5696, 212, 5, 21, "Message",
      CellTags->"Syntax::sntufn"],
    Cell[152795, 5703, 181, 4, 24, "Notes",
      CellTags->"Syntax::sntufn"],
    Cell[153001, 5711, 64, 1, 38, "ExampleSection",
      CellTags->"Syntax::sntufn"],
    Cell[153068, 5714, 180, 4, 40, "Text",
      CellTags->"Syntax::sntufn"],
    Cell[153273, 5722, 124, 3, 26, "Input",
      CellTags->"Syntax::sntufn"],
    Cell[153400, 5727, 174, 4, 21, "Message",
      CellTags->"Syntax::sntufn"],
    Cell[153577, 5733, 194, 5, 36, "Message",
      CellTags->"Syntax::sntufn"],
    Cell[153774, 5740, 95, 3, 21, "Output",
      CellTags->"Syntax::sntufn"],
    Cell[153884, 5746, 117, 4, 24, "Text",
      CellTags->"Syntax::sntufn"],
    Cell[154026, 5754, 124, 3, 26, "Input",
      CellTags->"Syntax::sntufn"],
    Cell[154153, 5759, 96, 3, 21, "Output",
      CellTags->"Syntax::sntufn"]},
  "Syntax::sntunc"->{
    Cell[154310, 5769, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Syntax::sntunc"],
    Cell[154394, 5772, 254, 6, 21, "Message",
      CellTags->"Syntax::sntunc"],
    Cell[154651, 5780, 184, 4, 24, "Notes",
      CellTags->"Syntax::sntunc"],
    Cell[154860, 5788, 64, 1, 38, "ExampleSection",
      CellTags->"Syntax::sntunc"],
    Cell[154927, 5791, 156, 4, 24, "Text",
      CellTags->"Syntax::sntunc"],
    Cell[155108, 5799, 127, 3, 26, "Input",
      CellTags->"Syntax::sntunc"],
    Cell[155238, 5804, 198, 5, 21, "Message",
      CellTags->"Syntax::sntunc"],
    Cell[155439, 5811, 98, 3, 21, "Output",
      CellTags->"Syntax::sntunc"],
    Cell[155552, 5817, 99, 1, 24, "Text",
      CellTags->"Syntax::sntunc"],
    Cell[155676, 5822, 128, 3, 26, "Input",
      CellTags->"Syntax::sntunc"],
    Cell[155807, 5827, 98, 3, 21, "Output",
      CellTags->"Syntax::sntunc"]},
  "Syntax::syntyp"->{
    Cell[155966, 5837, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Syntax::syntyp"],
    Cell[156050, 5840, 181, 4, 21, "Message",
      CellTags->"Syntax::syntyp"],
    Cell[156234, 5846, 399, 14, 40, "Notes",
      CellTags->"Syntax::syntyp"],
    Cell[156658, 5864, 64, 1, 38, "ExampleSection",
      CellTags->"Syntax::syntyp"],
    Cell[156725, 5867, 211, 6, 40, "Text",
      CellTags->"Syntax::syntyp"],
    Cell[156961, 5877, 115, 3, 26, "Input",
      CellTags->"Syntax::syntyp"],
    Cell[157079, 5882, 180, 4, 21, "Message",
      CellTags->"Syntax::syntyp"],
    Cell[157262, 5888, 205, 5, 36, "Message",
      CellTags->"Syntax::syntyp"],
    Cell[157470, 5895, 95, 3, 21, "Output",
      CellTags->"Syntax::syntyp"],
    Cell[157580, 5901, 140, 5, 24, "Text",
      CellTags->"Syntax::syntyp"],
    Cell[157745, 5910, 119, 3, 26, "Input",
      CellTags->"Syntax::syntyp"],
    Cell[157867, 5915, 132, 3, 21, "Output",
      CellTags->"Syntax::syntyp"]},
  "TableForm::tfal"->{
    Cell[158060, 5925, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"TableForm::tfal"],
    Cell[158146, 5928, 439, 8, 69, "Message",
      CellTags->"TableForm::tfal"],
    Cell[158588, 5938, 200, 5, 24, "Notes",
      CellTags->"TableForm::tfal"],
    Cell[158813, 5947, 65, 1, 38, "ExampleSection",
      CellTags->"TableForm::tfal"],
    Cell[158881, 5950, 238, 7, 40, "Text",
      CellTags->"TableForm::tfal"],
    Cell[159144, 5961, 171, 4, 42, "Input",
      CellTags->"TableForm::tfal"],
    Cell[159318, 5967, 333, 6, 69, "Message",
      CellTags->"TableForm::tfal"],
    Cell[159654, 5975, 406, 13, 47, "Output",
      CellTags->"TableForm::tfal"],
    Cell[160075, 5991, 147, 5, 24, "Text",
      CellTags->"TableForm::tfal"],
    Cell[160247, 6000, 160, 4, 26, "Input",
      CellTags->"TableForm::tfal"],
    Cell[160410, 6006, 388, 12, 47, "Output",
      CellTags->"TableForm::tfal"]},
  "TableForm::tfdir"->{
    Cell[160859, 6025, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"TableForm::tfdir"],
    Cell[160947, 6028, 336, 7, 37, "Message",
      CellTags->"TableForm::tfdir"],
    Cell[161286, 6037, 201, 5, 24, "Notes",
      CellTags->"TableForm::tfdir"],
    Cell[161512, 6046, 66, 1, 38, "ExampleSection",
      CellTags->"TableForm::tfdir"],
    Cell[161581, 6049, 217, 7, 24, "Text",
      CellTags->"TableForm::tfdir"],
    Cell[161823, 6060, 160, 4, 26, "Input",
      CellTags->"TableForm::tfdir"],
    Cell[161986, 6066, 247, 5, 53, "Message",
      CellTags->"TableForm::tfdir"],
    Cell[162236, 6073, 395, 12, 47, "Output",
      CellTags->"TableForm::tfdir"],
    Cell[162646, 6088, 148, 5, 24, "Text",
      CellTags->"TableForm::tfdir"],
    Cell[162819, 6097, 159, 4, 26, "Input",
      CellTags->"TableForm::tfdir"],
    Cell[162981, 6103, 418, 14, 115, "Output",
      CellTags->"TableForm::tfdir"]},
  "TableForm::tfh"->{
    Cell[163460, 6124, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"TableForm::tfh"],
    Cell[163544, 6127, 333, 7, 37, "Message",
      CellTags->"TableForm::tfh"],
    Cell[163880, 6136, 197, 5, 24, "Notes",
      CellTags->"TableForm::tfh"],
    Cell[164102, 6145, 64, 1, 38, "ExampleSection",
      CellTags->"TableForm::tfh"],
    Cell[164169, 6148, 201, 6, 24, "Text",
      CellTags->"TableForm::tfh"],
    Cell[164395, 6158, 190, 4, 42, "Input",
      CellTags->"TableForm::tfh"],
    Cell[164588, 6164, 232, 5, 37, "Message",
      CellTags->"TableForm::tfh"],
    Cell[164823, 6171, 232, 5, 37, "Message",
      CellTags->"TableForm::tfh"],
    Cell[165058, 6178, 232, 5, 37, "Message",
      CellTags->"TableForm::tfh"],
    Cell[165293, 6185, 225, 5, 37, "Message",
      CellTags->"TableForm::tfh"],
    Cell[165521, 6192, 427, 14, 63, "Output",
      CellTags->"TableForm::tfh"],
    Cell[165963, 6209, 144, 5, 24, "Text",
      CellTags->"TableForm::tfh"],
    Cell[166132, 6218, 198, 4, 42, "Input",
      CellTags->"TableForm::tfh"],
    Cell[166333, 6224, 493, 15, 79, "Output",
      CellTags->"TableForm::tfh"]},
  "TableForm::tfsp"->{
    Cell[166887, 6246, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"TableForm::tfsp"],
    Cell[166973, 6249, 315, 6, 37, "Message",
      CellTags->"TableForm::tfsp"],
    Cell[167291, 6257, 197, 5, 24, "Notes",
      CellTags->"TableForm::tfsp"],
    Cell[167513, 6266, 65, 1, 38, "ExampleSection",
      CellTags->"TableForm::tfsp"],
    Cell[167581, 6269, 311, 11, 40, "Text",
      CellTags->"TableForm::tfsp"],
    Cell[167917, 6284, 182, 5, 42, "Input",
      CellTags->"TableForm::tfsp"],
    Cell[168102, 6291, 237, 5, 37, "Message",
      CellTags->"TableForm::tfsp"],
    Cell[168342, 6298, 224, 8, 31, "Output",
      CellTags->"TableForm::tfsp"],
    Cell[168581, 6309, 144, 5, 24, "Text",
      CellTags->"TableForm::tfsp"],
    Cell[168750, 6318, 184, 5, 42, "Input",
      CellTags->"TableForm::tfsp"],
    Cell[168937, 6325, 192, 13, 109, "Output",
      CellTags->"TableForm::tfsp"]},
  "TeXForm::texalign"->{
    Cell[169190, 6345, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"TeXForm::texalign"],
    Cell[169280, 6348, 242, 5, 37, "Message",
      CellTags->"TeXForm::texalign"],
    Cell[169525, 6355, 335, 11, 40, "Notes",
      CellTags->"TeXForm::texalign"]},
  "TeXForm::texstyle"->{
    Cell[169897, 6371, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"TeXForm::texstyle"],
    Cell[169987, 6374, 285, 6, 47, "Message",
      CellTags->"TeXForm::texstyle"],
    Cell[170275, 6382, 197, 6, 24, "Notes",
      CellTags->"TeXForm::texstyle"]},
  "TeXForm::texval"->{
    Cell[170509, 6393, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"TeXForm::texval"],
    Cell[170595, 6396, 288, 6, 19, "Message",
      CellTags->"TeXForm::texval"],
    Cell[170886, 6404, 195, 6, 24, "Notes",
      CellTags->"TeXForm::texval"]},
  "ToExpression::esntx"->{
    Cell[171118, 6415, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ToExpression::esntx"],
    Cell[171212, 6418, 261, 6, 19, "Message",
      CellTags->"ToExpression::esntx"],
    Cell[171476, 6426, 263, 8, 24, "Notes",
      CellTags->"ToExpression::esntx"],
    Cell[171764, 6438, 69, 1, 38, "ExampleSection",
      CellTags->"ToExpression::esntx"],
    Cell[171836, 6441, 205, 5, 37, "Text",
      CellTags->"ToExpression::esntx"],
    Cell[172066, 6450, 146, 3, 26, "Input",
      CellTags->"ToExpression::esntx"],
    Cell[172215, 6455, 203, 5, 19, "Message",
      CellTags->"ToExpression::esntx"],
    Cell[172421, 6462, 222, 5, 19, "Message",
      CellTags->"ToExpression::esntx"],
    Cell[172646, 6469, 100, 3, 25, "Output",
      CellTags->"ToExpression::esntx"],
    Cell[172761, 6475, 153, 5, 23, "Text",
      CellTags->"ToExpression::esntx"],
    Cell[172939, 6484, 163, 4, 26, "Input",
      CellTags->"ToExpression::esntx"],
    Cell[173105, 6490, 102, 3, 25, "Output",
      CellTags->"ToExpression::esntx"]},
  "ToExpression::esntxb"->{
    Cell[173268, 6500, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ToExpression::esntxb"],
    Cell[173364, 6503, 186, 4, 19, "Message",
      CellTags->"ToExpression::esntxb"],
    Cell[173553, 6509, 331, 8, 42, "Notes",
      CellTags->"ToExpression::esntxb"]},
  "ToExpression::esntxf"->{
    Cell[173921, 6522, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ToExpression::esntxf"],
    Cell[174017, 6525, 187, 4, 19, "Message",
      CellTags->"ToExpression::esntxf"],
    Cell[174207, 6531, 323, 10, 43, "Notes",
      CellTags->"ToExpression::esntxf"]},
  "ToExpression::esntxi"->{
    Cell[174567, 6546, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ToExpression::esntxi"],
    Cell[174663, 6549, 179, 4, 21, "Message",
      CellTags->"ToExpression::esntxi"],
    Cell[174845, 6555, 341, 10, 46, "Notes",
      CellTags->"ToExpression::esntxi"]},
  "ToString::notype"->{
    Cell[175223, 6570, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ToString::notype"],
    Cell[175311, 6573, 334, 7, 37, "Message",
      CellTags->"ToString::notype"],
    Cell[175648, 6582, 196, 6, 24, "Notes",
      CellTags->"ToString::notype"]},
  "General::base"->{
    Cell[175881, 6593, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::base"],
    Cell[175963, 6596, 492, 16, 21, "Message",
      CellTags->"General::base"],
    Cell[176458, 6614, 288, 9, 24, "Notes",
      CellTags->"General::base"],
    Cell[176771, 6627, 63, 1, 38, "ExampleSection",
      CellTags->"General::base"],
    Cell[176837, 6630, 164, 4, 24, "Text",
      CellTags->"General::base"],
    Cell[177026, 6638, 95, 3, 26, "Input",
      CellTags->"General::base"],
    Cell[177124, 6643, 220, 5, 37, "Message",
      CellTags->"General::base"],
    Cell[177359, 6651, 118, 4, 24, "Text",
      CellTags->"General::base"],
    Cell[177502, 6659, 95, 3, 26, "Input",
      CellTags->"General::base"],
    Cell[177600, 6664, 89, 3, 21, "Output",
      CellTags->"General::base"]},
  "General::bktfn"->{
    Cell[177750, 6674, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::bktfn"],
    Cell[177834, 6677, 324, 10, 21, "Message",
      CellTags->"General::bktfn"],
    Cell[178161, 6689, 467, 12, 68, "Notes",
      CellTags->"General::bktfn"],
    Cell[178653, 6705, 64, 1, 38, "ExampleSection",
      CellTags->"General::bktfn"],
    Cell[178720, 6708, 203, 6, 24, "Text",
      CellTags->"General::bktfn"],
    Cell[178948, 6718, 87, 2, 28, "Input",
      CellTags->"General::bktfn"],
    Cell[179038, 6722, 164, 5, 21, "Message",
      CellTags->"General::bktfn"]},
  "General::bktmch"->{
    Cell[179263, 6734, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::bktmch"],
    Cell[179349, 6737, 344, 10, 21, "Message",
      CellTags->"General::bktmch"],
    Cell[179696, 6749, 387, 8, 68, "Notes",
      CellTags->"General::bktmch"],
    Cell[180108, 6761, 65, 1, 38, "ExampleSection",
      CellTags->"General::bktmch"],
    Cell[180176, 6764, 204, 6, 24, "Text",
      CellTags->"General::bktmch"],
    Cell[180405, 6774, 88, 2, 28, "Input",
      CellTags->"General::bktmch"],
    Cell[180496, 6778, 162, 5, 21, "Message",
      CellTags->"General::bktmch"]},
  "General::bktmcp"->{
    Cell[180719, 6790, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::bktmcp"],
    Cell[180805, 6793, 333, 10, 21, "Message",
      CellTags->"General::bktmcp"],
    Cell[181141, 6805, 124, 4, 24, "Notes",
      CellTags->"General::bktmcp"],
    Cell[181290, 6813, 65, 1, 38, "ExampleSection",
      CellTags->"General::bktmcp"],
    Cell[181358, 6816, 135, 4, 24, "Text",
      CellTags->"General::bktmcp"],
    Cell[181518, 6824, 162, 4, 26, "Input",
      CellTags->"General::bktmcp"],
    Cell[181683, 6830, 210, 5, 21, "Message",
      CellTags->"General::bktmcp"],
    Cell[181896, 6837, 239, 5, 37, "Message",
      CellTags->"General::bktmcp"],
    Cell[182138, 6844, 96, 3, 21, "Output",
      CellTags->"General::bktmcp"],
    Cell[182249, 6850, 146, 5, 24, "Text",
      CellTags->"General::bktmcp"],
    Cell[182420, 6859, 173, 5, 26, "Input",
      CellTags->"General::bktmcp"],
    Cell[182596, 6866, 117, 3, 21, "Output",
      CellTags->"General::bktmcp"]},
  "General::bktmop"->{
    Cell[182774, 6876, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::bktmop"],
    Cell[182860, 6879, 333, 10, 21, "Message",
      CellTags->"General::bktmop"],
    Cell[183196, 6891, 124, 4, 24, "Notes",
      CellTags->"General::bktmop"],
    Cell[183345, 6899, 65, 1, 38, "ExampleSection",
      CellTags->"General::bktmop"],
    Cell[183413, 6902, 135, 4, 24, "Text",
      CellTags->"General::bktmop"],
    Cell[183573, 6910, 172, 5, 26, "Input",
      CellTags->"General::bktmop"],
    Cell[183748, 6917, 209, 5, 21, "Message",
      CellTags->"General::bktmop"],
    Cell[183960, 6924, 239, 5, 37, "Message",
      CellTags->"General::bktmop"],
    Cell[184202, 6931, 96, 3, 21, "Output",
      CellTags->"General::bktmop"],
    Cell[184313, 6937, 146, 5, 24, "Text",
      CellTags->"General::bktmop"],
    Cell[184484, 6946, 181, 5, 26, "Input",
      CellTags->"General::bktmop"],
    Cell[184668, 6953, 117, 3, 21, "Output",
      CellTags->"General::bktmop"]},
  "General::bktwrn"->{
    Cell[184846, 6963, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::bktwrn"],
    Cell[184932, 6966, 364, 11, 37, "Message",
      CellTags->"General::bktwrn"],
    Cell[185299, 6979, 537, 12, 100, "Notes",
      CellTags->"General::bktwrn"],
    Cell[185861, 6995, 65, 1, 38, "ExampleSection",
      CellTags->"General::bktwrn"],
    Cell[185929, 6998, 242, 6, 40, "Text",
      CellTags->"General::bktwrn"],
    Cell[186196, 7008, 88, 2, 28, "Input",
      CellTags->"General::bktwrn"],
    Cell[186287, 7012, 209, 6, 51, "Message",
      CellTags->"General::bktwrn"],
    Cell[186499, 7020, 105, 3, 21, "Output",
      CellTags->"General::bktwrn"]},
  "General::bktx"->{
    Cell[186665, 7030, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::bktx"],
    Cell[186747, 7033, 322, 10, 21, "Message",
      CellTags->"General::bktx"],
    Cell[187072, 7045, 302, 7, 46, "Notes",
      CellTags->"General::bktx"],
    Cell[187399, 7056, 63, 1, 38, "ExampleSection",
      CellTags->"General::bktx"],
    Cell[187465, 7059, 200, 6, 24, "Text",
      CellTags->"General::bktx"],
    Cell[187690, 7069, 87, 2, 28, "Input",
      CellTags->"General::bktx"],
    Cell[187780, 7073, 137, 2, 21, "Message",
      CellTags->"General::bktx"]},
  "General::continfo"->{
    Cell[187978, 7082, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::continfo"],
    Cell[188068, 7085, 207, 5, 21, "Message",
      CellTags->"General::continfo"],
    Cell[188278, 7092, 228, 5, 46, "Notes",
      CellTags->"General::continfo"],
    Cell[188531, 7101, 67, 1, 38, "ExampleSection",
      CellTags->"General::continfo"],
    Cell[188601, 7104, 90, 1, 24, "Text",
      CellTags->"General::continfo"],
    Cell[188716, 7109, 113, 3, 28, "Input",
      CellTags->"General::continfo"],
    Cell[188832, 7114, 160, 3, 35, "Print",
      CellTags->"General::continfo"]},
  "General::digit"->{
    Cell[189053, 7124, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::digit"],
    Cell[189137, 7127, 535, 16, 21, "Message",
      CellTags->"General::digit"],
    Cell[189675, 7145, 235, 7, 24, "Notes",
      CellTags->"General::digit"],
    Cell[189935, 7156, 64, 1, 38, "ExampleSection",
      CellTags->"General::digit"],
    Cell[190002, 7159, 185, 6, 24, "Text",
      CellTags->"General::digit"],
    Cell[190212, 7169, 91, 3, 26, "Input",
      CellTags->"General::digit"],
    Cell[190306, 7174, 219, 5, 37, "Message",
      CellTags->"General::digit"],
    Cell[190540, 7182, 140, 4, 24, "Text",
      CellTags->"General::digit"],
    Cell[190705, 7190, 93, 3, 26, "Input",
      CellTags->"General::digit"],
    Cell[190801, 7195, 89, 3, 21, "Output",
      CellTags->"General::digit"]},
  "General::existinfo"->{
    Cell[190951, 7205, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::existinfo"],
    Cell[191043, 7208, 188, 4, 21, "Message",
      CellTags->"General::existinfo"],
    Cell[191234, 7214, 217, 5, 46, "Notes",
      CellTags->"General::existinfo"],
    Cell[191476, 7223, 68, 1, 38, "ExampleSection",
      CellTags->"General::existinfo"],
    Cell[191547, 7226, 91, 1, 24, "Text",
      CellTags->"General::existinfo"],
    Cell[191663, 7231, 105, 3, 26, "Input",
      CellTags->"General::existinfo"],
    Cell[191771, 7236, 121, 2, 21, "Print",
      CellTags->"General::existinfo"]},
  "General::incomma"->{
    Cell[191953, 7245, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::incomma"],
    Cell[192041, 7248, 465, 12, 37, "Message",
      CellTags->"General::incomma"],
    Cell[192509, 7262, 226, 5, 46, "Notes",
      CellTags->"General::incomma"],
    Cell[192760, 7271, 66, 1, 38, "ExampleSection",
      CellTags->"General::incomma"],
    Cell[192829, 7274, 89, 1, 24, "Text",
      CellTags->"General::incomma"],
    Cell[192943, 7279, 125, 3, 26, "Input",
      CellTags->"General::incomma"],
    Cell[193071, 7284, 151, 3, 37, "Print",
      CellTags->"General::incomma"]},
  "General::intinfo"->{
    Cell[193283, 7294, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::intinfo"],
    Cell[193371, 7297, 454, 10, 90, "Message",
      CellTags->"General::intinfo"],
    Cell[193828, 7309, 219, 5, 46, "Notes",
      CellTags->"General::intinfo"],
    Cell[194072, 7318, 66, 1, 38, "ExampleSection",
      CellTags->"General::intinfo"],
    Cell[194141, 7321, 89, 1, 24, "Text",
      CellTags->"General::intinfo"],
    Cell[194255, 7326, 105, 3, 28, "Input",
      CellTags->"General::intinfo"],
    Cell[194363, 7331, 331, 6, 70, "Print",
      CellTags->"General::intinfo"]},
  "General::partialinfo"->{
    Cell[194755, 7344, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::partialinfo"],
    Cell[194851, 7347, 192, 4, 21, "Message",
      CellTags->"General::partialinfo"],
    Cell[195046, 7353, 223, 5, 46, "Notes",
      CellTags->"General::partialinfo"],
    Cell[195294, 7362, 70, 1, 38, "ExampleSection",
      CellTags->"General::partialinfo"],
    Cell[195367, 7365, 93, 1, 24, "Text",
      CellTags->"General::partialinfo"],
    Cell[195485, 7370, 109, 3, 26, "Input",
      CellTags->"General::partialinfo"],
    Cell[195597, 7375, 120, 2, 21, "Print",
      CellTags->"General::partialinfo"]},
  "General::strbox"->{
    Cell[195778, 7384, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::strbox"],
    Cell[195864, 7387, 438, 12, 19, "Message",
      CellTags->"General::strbox"],
    Cell[196305, 7401, 221, 5, 42, "Notes",
      CellTags->"General::strbox"],
    Cell[196551, 7410, 65, 1, 38, "ExampleSection",
      CellTags->"General::strbox"],
    Cell[196619, 7413, 88, 1, 22, "Text",
      CellTags->"General::strbox"],
    Cell[196732, 7418, 109, 3, 26, "Input",
      CellTags->"General::strbox"],
    Cell[196844, 7423, 301, 7, 21, "Print",
      CellTags->"General::strbox"]},
  "General::uinfix"->{
    Cell[197206, 7437, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::uinfix"],
    Cell[197292, 7440, 219, 5, 19, "Message",
      CellTags->"General::uinfix"],
    Cell[197514, 7447, 220, 5, 42, "Notes",
      CellTags->"General::uinfix"],
    Cell[197759, 7456, 65, 1, 38, "ExampleSection",
      CellTags->"General::uinfix"],
    Cell[197827, 7459, 88, 1, 22, "Text",
      CellTags->"General::uinfix"],
    Cell[197940, 7464, 106, 3, 26, "Input",
      CellTags->"General::uinfix"],
    Cell[198049, 7469, 164, 3, 21, "Print",
      CellTags->"General::uinfix"]},
  "General::uprefix"->{
    Cell[198274, 7479, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::uprefix"],
    Cell[198362, 7482, 216, 5, 19, "Message",
      CellTags->"General::uprefix"],
    Cell[198581, 7489, 214, 5, 42, "Notes",
      CellTags->"General::uprefix"],
    Cell[198820, 7498, 66, 1, 38, "ExampleSection",
      CellTags->"General::uprefix"],
    Cell[198889, 7501, 89, 1, 22, "Text",
      CellTags->"General::uprefix"],
    Cell[199003, 7506, 100, 3, 26, "Input",
      CellTags->"General::uprefix"],
    Cell[199106, 7511, 146, 3, 21, "Print",
      CellTags->"General::uprefix"]},
  "General::upreinfix"->{
    Cell[199313, 7521, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::upreinfix"],
    Cell[199405, 7524, 294, 6, 53, "Message",
      CellTags->"General::upreinfix"],
    Cell[199702, 7532, 244, 5, 46, "Notes",
      CellTags->"General::upreinfix"],
    Cell[199971, 7541, 68, 1, 38, "ExampleSection",
      CellTags->"General::upreinfix"],
    Cell[200042, 7544, 91, 1, 24, "Text",
      CellTags->"General::upreinfix"],
    Cell[200158, 7549, 122, 3, 26, "Input",
      CellTags->"General::upreinfix"],
    Cell[200283, 7554, 250, 4, 37, "Print",
      CellTags->"General::upreinfix"]},
  "General::suminfo"->{
    Cell[200594, 7565, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::suminfo"],
    Cell[200682, 7568, 199, 5, 23, "Message",
      CellTags->"General::suminfo"],
    Cell[200884, 7575, 215, 5, 46, "Notes",
      CellTags->"General::suminfo"],
    Cell[201124, 7584, 66, 1, 38, "ExampleSection",
      CellTags->"General::suminfo"],
    Cell[201193, 7587, 89, 1, 24, "Text",
      CellTags->"General::suminfo"],
    Cell[201307, 7592, 100, 3, 26, "Input",
      CellTags->"General::suminfo"],
    Cell[201410, 7597, 128, 3, 29, "Print",
      CellTags->"General::suminfo"]},
  "Export::chtype"->{
    Cell[201599, 7607, 274, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype",
         "Experimental`BinaryImport::chtype"}],
    Cell[201876, 7617, 499, 13, 21, "Message",
      CellTags->{
      "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype",
         "Experimental`BinaryImport::chtype"}],
    Cell[202378, 7632, 791, 20, 100, "Notes",
      CellTags->{
      "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype",
         "Experimental`BinaryImport::chtype"}]},
  "Import::chtype"->{
    Cell[201599, 7607, 274, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype",
         "Experimental`BinaryImport::chtype"}],
    Cell[201876, 7617, 499, 13, 21, "Message",
      CellTags->{
      "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype",
         "Experimental`BinaryImport::chtype"}],
    Cell[202378, 7632, 791, 20, 100, "Notes",
      CellTags->{
      "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype",
         "Experimental`BinaryImport::chtype"}]},
  "Experimental`BinaryExport::chtype"->{
    Cell[201599, 7607, 274, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype",
         "Experimental`BinaryImport::chtype"}],
    Cell[201876, 7617, 499, 13, 21, "Message",
      CellTags->{
      "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype",
         "Experimental`BinaryImport::chtype"}],
    Cell[202378, 7632, 791, 20, 100, "Notes",
      CellTags->{
      "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype",
         "Experimental`BinaryImport::chtype"}]},
  "Experimental`BinaryImport::chtype"->{
    Cell[201599, 7607, 274, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype",
         "Experimental`BinaryImport::chtype"}],
    Cell[201876, 7617, 499, 13, 21, "Message",
      CellTags->{
      "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype",
         "Experimental`BinaryImport::chtype"}],
    Cell[202378, 7632, 791, 20, 100, "Notes",
      CellTags->{
      "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype",
         "Experimental`BinaryImport::chtype"}]},
  "Export::coerce"->{
    Cell[203206, 7657, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::coerce"],
    Cell[203290, 7660, 162, 4, 21, "Message",
      CellTags->"Export::coerce"],
    Cell[203455, 7666, 530, 13, 84, "Notes",
      CellTags->"Export::coerce"],
    Cell[204010, 7683, 64, 1, 38, "ExampleSection",
      CellTags->"Export::coerce"],
    Cell[204077, 7686, 263, 6, 40, "Text",
      CellTags->"Export::coerce"],
    Cell[204365, 7696, 143, 3, 26, "Input",
      CellTags->"Export::coerce"],
    Cell[204511, 7701, 195, 4, 21, "Message",
      CellTags->"Export::coerce"],
    Cell[204709, 7707, 98, 3, 21, "Output",
      CellTags->"Export::coerce"],
    Cell[204822, 7713, 67, 1, 24, "Text",
      CellTags->"Export::coerce"],
    Cell[204892, 7716, 113, 3, 26, "Input",
      CellTags->"Export::coerce"]},
  "Export::dffsr"->{
    Cell[205054, 7725, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::dffsr"],
    Cell[205136, 7728, 154, 3, 21, "Message",
      CellTags->"Export::dffsr"],
    Cell[205293, 7733, 471, 13, 62, "Notes",
      CellTags->"Export::dffsr"]},
  "Export::bitcon"->{
    Cell[205801, 7751, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::bitcon"],
    Cell[205885, 7754, 429, 11, 37, "Message",
      CellTags->"Export::bitcon"],
    Cell[206317, 7767, 125, 4, 24, "Notes",
      CellTags->"Export::bitcon"]},
  "Export::bitrange"->{
    Cell[206479, 7776, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::bitrange"],
    Cell[206567, 7779, 406, 11, 21, "Message",
      CellTags->"Export::bitrange"],
    Cell[206976, 7792, 127, 4, 24, "Notes",
      CellTags->"Export::bitrange"]},
  "Export::bitval"->{
    Cell[207140, 7801, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::bitval"],
    Cell[207224, 7804, 314, 8, 21, "Message",
      CellTags->"Export::bitval"],
    Cell[207541, 7814, 125, 4, 24, "Notes",
      CellTags->"Export::bitval"]},
  "Export::errfile"->{
    Cell[207703, 7823, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::errfile", "Import::errfile"}],
    Cell[207834, 7829, 420, 11, 21, "Message",
      CellTags->{"Export::errfile", "Import::errfile"}],
    Cell[208257, 7842, 147, 4, 24, "Notes",
      CellTags->{"Export::errfile", "Import::errfile"}]},
  "Import::errfile"->{
    Cell[207703, 7823, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::errfile", "Import::errfile"}],
    Cell[207834, 7829, 420, 11, 21, "Message",
      CellTags->{"Export::errfile", "Import::errfile"}],
    Cell[208257, 7842, 147, 4, 24, "Notes",
      CellTags->{"Export::errfile", "Import::errfile"}]},
  "Export::errstruct"->{
    Cell[208441, 7851, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::errstruct", "Import::errstruct"}],
    Cell[208580, 7857, 334, 10, 21, "Message",
      CellTags->{"Export::errstruct", "Import::errstruct"}],
    Cell[208917, 7869, 151, 4, 24, "Notes",
      CellTags->{"Export::errstruct", "Import::errstruct"}]},
  "Import::errstruct"->{
    Cell[208441, 7851, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::errstruct", "Import::errstruct"}],
    Cell[208580, 7857, 334, 10, 21, "Message",
      CellTags->{"Export::errstruct", "Import::errstruct"}],
    Cell[208917, 7869, 151, 4, 24, "Notes",
      CellTags->{"Export::errstruct", "Import::errstruct"}]},
  "Export::obs"->{
    Cell[209105, 7878, 112, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::obs", "Import::obs"}],
    Cell[209220, 7884, 306, 10, 21, "Message",
      CellTags->{"Export::obs", "Import::obs"}],
    Cell[209529, 7896, 139, 4, 24, "Notes",
      CellTags->{"Export::obs", "Import::obs"}]},
  "Import::obs"->{
    Cell[209105, 7878, 112, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::obs", "Import::obs"}],
    Cell[209220, 7884, 306, 10, 21, "Message",
      CellTags->{"Export::obs", "Import::obs"}],
    Cell[209529, 7896, 139, 4, 24, "Notes",
      CellTags->{"Export::obs", "Import::obs"}]},
  "Export::obsalt"->{
    Cell[209705, 7905, 124, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::obsalt", "Import::obsalt"}],
    Cell[209832, 7911, 333, 10, 21, "Message",
      CellTags->{"Export::obsalt", "Import::obsalt"}],
    Cell[210168, 7923, 145, 4, 22, "Notes",
      CellTags->{"Export::obsalt", "Import::obsalt"}]},
  "Import::obsalt"->{
    Cell[209705, 7905, 124, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::obsalt", "Import::obsalt"}],
    Cell[209832, 7911, 333, 10, 21, "Message",
      CellTags->{"Export::obsalt", "Import::obsalt"}],
    Cell[210168, 7923, 145, 4, 22, "Notes",
      CellTags->{"Export::obsalt", "Import::obsalt"}]},
  "Export::no2dgr"->{
    Cell[210350, 7932, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::no2dgr"],
    Cell[210434, 7935, 621, 15, 33, "Message",
      CellTags->"Export::no2dgr"],
    Cell[211058, 7952, 125, 4, 22, "Notes",
      CellTags->"Export::no2dgr"]},
  "Export::nocomp"->{
    Cell[211220, 7961, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::nocomp"],
    Cell[211304, 7964, 484, 10, 33, "Message",
      CellTags->"Export::nocomp"],
    Cell[211791, 7976, 125, 4, 22, "Notes",
      CellTags->"Export::nocomp"]},
  "Export::nodir"->{
    Cell[211953, 7985, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::nodir"],
    Cell[212035, 7988, 267, 7, 19, "Message",
      CellTags->"Export::nodir"],
    Cell[212305, 7997, 124, 4, 22, "Notes",
      CellTags->"Export::nodir"]},
  "Export::autofix"->{
    Cell[212466, 8006, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::autofix"],
    Cell[212552, 8009, 449, 7, 61, "Message",
      CellTags->"Export::autofix"],
    Cell[213004, 8018, 126, 4, 22, "Notes",
      CellTags->"Export::autofix"]},
  "Export::badqte"->{
    Cell[213167, 8027, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::badqte"],
    Cell[213251, 8030, 543, 11, 33, "Message",
      CellTags->"Export::badqte"],
    Cell[213797, 8043, 125, 4, 22, "Notes",
      CellTags->"Export::badqte"]},
  "Export::malsxml"->{
    Cell[213959, 8052, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::malsxml"],
    Cell[214045, 8055, 429, 10, 33, "Message",
      CellTags->"Export::malsxml"],
    Cell[214477, 8067, 126, 4, 22, "Notes",
      CellTags->"Export::malsxml"]},
  "Export::unrecov"->{
    Cell[214640, 8076, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::unrecov"],
    Cell[214726, 8079, 189, 3, 19, "Message",
      CellTags->"Export::unrecov"],
    Cell[214918, 8084, 126, 4, 22, "Notes",
      CellTags->"Export::unrecov"]},
  "Export::xmlmal"->{
    Cell[215081, 8093, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::xmlmal"],
    Cell[215165, 8096, 327, 8, 21, "Message",
      CellTags->"Export::xmlmal"],
    Cell[215495, 8106, 125, 4, 24, "Notes",
      CellTags->"Export::xmlmal"]},
  "Export::xmlnopt"->{
    Cell[215657, 8115, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::xmlnopt"],
    Cell[215743, 8118, 451, 11, 37, "Message",
      CellTags->"Export::xmlnopt"],
    Cell[216197, 8131, 126, 4, 24, "Notes",
      CellTags->"Export::xmlnopt"]},
  "Export::fmterr"->{
    Cell[216360, 8140, 124, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[216487, 8146, 327, 9, 21, "Message",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[216817, 8157, 315, 8, 40, "Notes",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[217157, 8169, 84, 1, 38, "ExampleSection",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[217244, 8172, 175, 4, 24, "Text",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[217444, 8180, 152, 3, 26, "Input",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[217599, 8185, 118, 3, 21, "Output",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[217754, 8193, 140, 3, 26, "Input",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[217897, 8198, 185, 4, 21, "Message",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[218085, 8204, 115, 3, 21, "Output",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[218215, 8210, 87, 1, 24, "Text",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[218305, 8213, 133, 3, 26, "Input",
      CellTags->{"Export::fmterr", "Import::fmterr"}]},
  "Import::fmterr"->{
    Cell[216360, 8140, 124, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[216487, 8146, 327, 9, 21, "Message",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[216817, 8157, 315, 8, 40, "Notes",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[217157, 8169, 84, 1, 38, "ExampleSection",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[217244, 8172, 175, 4, 24, "Text",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[217444, 8180, 152, 3, 26, "Input",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[217599, 8185, 118, 3, 21, "Output",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[217754, 8193, 140, 3, 26, "Input",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[217897, 8198, 185, 4, 21, "Message",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[218085, 8204, 115, 3, 21, "Output",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[218215, 8210, 87, 1, 24, "Text",
      CellTags->{"Export::fmterr", "Import::fmterr"}],
    Cell[218305, 8213, 133, 3, 26, "Input",
      CellTags->{"Export::fmterr", "Import::fmterr"}]},
  "Export::format"->{
    Cell[218487, 8222, 545, 15, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219035, 8239, 574, 15, 21, "Message",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219612, 8256, 1083, 26, 138, "Notes",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[220720, 8286, 315, 6, 38, "ExampleSection",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221038, 8294, 420, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221483, 8308, 372, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221858, 8318, 451, 10, 21, "Message",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222312, 8330, 369, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222696, 8341, 383, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223104, 8355, 373, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223480, 8365, 344, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}]},
  "ExportString::format"->{
    Cell[218487, 8222, 545, 15, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219035, 8239, 574, 15, 21, "Message",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219612, 8256, 1083, 26, 138, "Notes",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[220720, 8286, 315, 6, 38, "ExampleSection",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221038, 8294, 420, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221483, 8308, 372, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221858, 8318, 451, 10, 21, "Message",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222312, 8330, 369, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222696, 8341, 383, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223104, 8355, 373, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223480, 8365, 344, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}]},
  "Import::format"->{
    Cell[218487, 8222, 545, 15, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219035, 8239, 574, 15, 21, "Message",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219612, 8256, 1083, 26, 138, "Notes",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[220720, 8286, 315, 6, 38, "ExampleSection",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221038, 8294, 420, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221483, 8308, 372, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221858, 8318, 451, 10, 21, "Message",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222312, 8330, 369, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222696, 8341, 383, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223104, 8355, 373, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223480, 8365, 344, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}]},
  "ImportString::format"->{
    Cell[218487, 8222, 545, 15, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219035, 8239, 574, 15, 21, "Message",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219612, 8256, 1083, 26, 138, "Notes",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[220720, 8286, 315, 6, 38, "ExampleSection",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221038, 8294, 420, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221483, 8308, 372, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221858, 8318, 451, 10, 21, "Message",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222312, 8330, 369, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222696, 8341, 383, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223104, 8355, 373, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223480, 8365, 344, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}]},
  "Experimental`BinaryExport::format"->{
    Cell[218487, 8222, 545, 15, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219035, 8239, 574, 15, 21, "Message",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219612, 8256, 1083, 26, 138, "Notes",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[220720, 8286, 315, 6, 38, "ExampleSection",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221038, 8294, 420, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221483, 8308, 372, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221858, 8318, 451, 10, 21, "Message",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222312, 8330, 369, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222696, 8341, 383, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223104, 8355, 373, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223480, 8365, 344, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}]},
  "Experimental`BinaryExportString::format"->{
    Cell[218487, 8222, 545, 15, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219035, 8239, 574, 15, 21, "Message",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219612, 8256, 1083, 26, 138, "Notes",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[220720, 8286, 315, 6, 38, "ExampleSection",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221038, 8294, 420, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221483, 8308, 372, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221858, 8318, 451, 10, 21, "Message",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222312, 8330, 369, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222696, 8341, 383, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223104, 8355, 373, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223480, 8365, 344, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}]},
  "Experimental`BinaryImport::format"->{
    Cell[218487, 8222, 545, 15, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219035, 8239, 574, 15, 21, "Message",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219612, 8256, 1083, 26, 138, "Notes",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[220720, 8286, 315, 6, 38, "ExampleSection",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221038, 8294, 420, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221483, 8308, 372, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221858, 8318, 451, 10, 21, "Message",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222312, 8330, 369, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222696, 8341, 383, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223104, 8355, 373, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223480, 8365, 344, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}]},
  "Experimental`BinaryImportString::format"->{
    Cell[218487, 8222, 545, 15, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219035, 8239, 574, 15, 21, "Message",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[219612, 8256, 1083, 26, 138, "Notes",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[220720, 8286, 315, 6, 38, "ExampleSection",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221038, 8294, 420, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221483, 8308, 372, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[221858, 8318, 451, 10, 21, "Message",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222312, 8330, 369, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}],
    Cell[222696, 8341, 383, 10, 24, "Text",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223104, 8355, 373, 8, 26, "Input",
      CellTags->{
      "Export::format", "ExportString::format", "Import::format", 
        "ImportString::format", "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format"}],
    Cell[223480, 8365, 344, 8, 21, "Output",
      CellTags->{
      "Experimental`BinaryExport::format", 
        "Experimental`BinaryExportString::format", 
        "Experimental`BinaryImport::format", 
        "Experimental`BinaryImportString::format", "Export::format", 
        "ExportString::format", "Import::format", "ImportString::format"}]},
  "Export::guess"->{
    Cell[223885, 8380, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[224008, 8386, 399, 11, 21, "Message",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[224410, 8399, 600, 17, 84, "Notes",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[225035, 8420, 82, 1, 38, "ExampleSection",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[225120, 8423, 198, 4, 40, "Text",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[225343, 8431, 138, 3, 26, "Input",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[225484, 8436, 210, 5, 21, "Message",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[225697, 8443, 131, 3, 21, "Output",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[225843, 8449, 170, 4, 24, "Text",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226038, 8457, 142, 3, 26, "Input",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226183, 8462, 120, 3, 21, "Output",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226318, 8468, 211, 6, 24, "Text",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226554, 8478, 150, 3, 26, "Input",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226707, 8483, 116, 3, 21, "Output",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226838, 8489, 86, 1, 24, "Text",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226927, 8492, 153, 3, 26, "Input",
      CellTags->{"Export::guess", "Import::guess"}]},
  "Import::guess"->{
    Cell[223885, 8380, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[224008, 8386, 399, 11, 21, "Message",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[224410, 8399, 600, 17, 84, "Notes",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[225035, 8420, 82, 1, 38, "ExampleSection",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[225120, 8423, 198, 4, 40, "Text",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[225343, 8431, 138, 3, 26, "Input",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[225484, 8436, 210, 5, 21, "Message",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[225697, 8443, 131, 3, 21, "Output",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[225843, 8449, 170, 4, 24, "Text",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226038, 8457, 142, 3, 26, "Input",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226183, 8462, 120, 3, 21, "Output",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226318, 8468, 211, 6, 24, "Text",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226554, 8478, 150, 3, 26, "Input",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226707, 8483, 116, 3, 21, "Output",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226838, 8489, 86, 1, 24, "Text",
      CellTags->{"Export::guess", "Import::guess"}],
    Cell[226927, 8492, 153, 3, 26, "Input",
      CellTags->{"Export::guess", "Import::guess"}]},
  "Export::ignore"->{
    Cell[227129, 8501, 162, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::ignore", "Experimental`BinaryExport::ignore"}],
    Cell[227294, 8507, 372, 10, 21, "Message",
      CellTags->{"Export::ignore", "Experimental`BinaryExport::ignore"}],
    Cell[227669, 8519, 233, 6, 24, "Notes",
      CellTags->{"Export::ignore", "Experimental`BinaryExport::ignore"}]},
  "Experimental`BinaryExport::ignore"->{
    Cell[227129, 8501, 162, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::ignore", "Experimental`BinaryExport::ignore"}],
    Cell[227294, 8507, 372, 10, 21, "Message",
      CellTags->{"Export::ignore", "Experimental`BinaryExport::ignore"}],
    Cell[227669, 8519, 233, 6, 24, "Notes",
      CellTags->{"Export::ignore", "Experimental`BinaryExport::ignore"}]},
  "Export::memavail"->{
    Cell[227939, 8530, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::memavail"],
    Cell[228027, 8533, 192, 4, 21, "Message",
      CellTags->"Export::memavail"],
    Cell[228222, 8539, 196, 6, 24, "Notes",
      CellTags->"Export::memavail"]},
  "Import::memavail"->{
    Cell[228455, 8550, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::memavail"],
    Cell[228543, 8553, 332, 7, 21, "Message",
      CellTags->"Import::memavail"],
    Cell[228878, 8562, 196, 6, 24, "Notes",
      CellTags->"Import::memavail"]},
  "Export::nofe"->{
    Cell[229111, 8573, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::nofe"],
    Cell[229191, 8576, 200, 5, 19, "Message",
      CellTags->"Export::nofe"],
    Cell[229394, 8583, 610, 16, 74, "Notes",
      CellTags->"Export::nofe"]},
  "Export::nomatch"->{
    Cell[230041, 8604, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::nomatch"],
    Cell[230127, 8607, 360, 10, 19, "Message",
      CellTags->"Export::nomatch"],
    Cell[230490, 8619, 195, 6, 24, "Notes",
      CellTags->"Export::nomatch"]},
  "Export::type"->{
    Cell[230722, 8630, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::type"],
    Cell[230802, 8633, 355, 10, 19, "Message",
      CellTags->"Export::type"],
    Cell[231160, 8645, 323, 7, 43, "Notes",
      CellTags->"Export::type"],
    Cell[231508, 8656, 62, 1, 38, "ExampleSection",
      CellTags->"Export::type"],
    Cell[231573, 8659, 172, 5, 23, "Text",
      CellTags->"Export::type"],
    Cell[231770, 8668, 124, 3, 26, "Input",
      CellTags->"Export::type"],
    Cell[231897, 8673, 192, 5, 19, "Message",
      CellTags->"Export::type"],
    Cell[232092, 8680, 93, 3, 25, "Output",
      CellTags->"Export::type"],
    Cell[232200, 8686, 137, 5, 23, "Text",
      CellTags->"Export::type"],
    Cell[232362, 8695, 130, 3, 26, "Input",
      CellTags->"Export::type"],
    Cell[232495, 8700, 96, 3, 25, "Output",
      CellTags->"Export::type"],
    Cell[232606, 8706, 98, 1, 22, "Text",
      CellTags->"Export::type"],
    Cell[232707, 8709, 111, 3, 26, "Input",
      CellTags->"Export::type"]},
  "Export::unsupfmt"->{
    Cell[232867, 8718, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::unsupfmt", "Import::unsupfmt"}],
    Cell[233002, 8724, 440, 11, 19, "Message",
      CellTags->{"Export::unsupfmt", "Import::unsupfmt"}],
    Cell[233445, 8737, 422, 8, 56, "Notes",
      CellTags->{"Export::unsupfmt", "Import::unsupfmt"}]},
  "Import::unsupfmt"->{
    Cell[232867, 8718, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Export::unsupfmt", "Import::unsupfmt"}],
    Cell[233002, 8724, 440, 11, 19, "Message",
      CellTags->{"Export::unsupfmt", "Import::unsupfmt"}],
    Cell[233445, 8737, 422, 8, 56, "Notes",
      CellTags->{"Export::unsupfmt", "Import::unsupfmt"}]},
  "Export::createdir"->{
    Cell[233904, 8750, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::createdir"],
    Cell[233994, 8753, 377, 7, 85, "Message",
      CellTags->"Export::createdir"],
    Cell[234374, 8762, 181, 5, 24, "Notes",
      CellTags->"Export::createdir"]},
  "Get::notencode"->{
    Cell[234592, 8772, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Get::notencode"],
    Cell[234676, 8775, 174, 4, 21, "Message",
      CellTags->"Get::notencode"],
    Cell[234853, 8781, 473, 11, 68, "Notes",
      CellTags->"Get::notencode"],
    Cell[235351, 8796, 64, 1, 38, "ExampleSection",
      CellTags->"Get::notencode"],
    Cell[235418, 8799, 229, 6, 40, "Text",
      CellTags->"Get::notencode"],
    Cell[235672, 8809, 142, 3, 26, "Input",
      CellTags->"Get::notencode"],
    Cell[235817, 8814, 98, 3, 21, "Output",
      CellTags->"Get::notencode"],
    Cell[235952, 8822, 111, 3, 26, "Input",
      CellTags->"Get::notencode"],
    Cell[236066, 8827, 188, 4, 21, "Message",
      CellTags->"Get::notencode"],
    Cell[236257, 8833, 93, 3, 21, "Output",
      CellTags->"Get::notencode"],
    Cell[236365, 8839, 67, 1, 24, "Text",
      CellTags->"Get::notencode"],
    Cell[236435, 8842, 113, 3, 26, "Input",
      CellTags->"Get::notencode"]},
  "Import::fnfnd"->{
    Cell[236597, 8851, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::fnfnd"],
    Cell[236679, 8854, 148, 3, 21, "Message",
      CellTags->"Import::fnfnd"],
    Cell[236830, 8859, 170, 5, 24, "Notes",
      CellTags->"Import::fnfnd"]},
  "Import::imgsze"->{
    Cell[237037, 8869, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::imgsze"],
    Cell[237121, 8872, 234, 5, 37, "Message",
      CellTags->"Import::imgsze"],
    Cell[237358, 8879, 230, 6, 40, "Notes",
      CellTags->"Import::imgsze"]},
  "Import::intp"->{
    Cell[237625, 8890, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::intp"],
    Cell[237705, 8893, 163, 4, 21, "Message",
      CellTags->"Import::intp"],
    Cell[237871, 8899, 192, 6, 24, "Notes",
      CellTags->"Import::intp"]},
  "Import::nffil"->{
    Cell[238100, 8910, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::nffil"],
    Cell[238182, 8913, 161, 4, 21, "Message",
      CellTags->"Import::nffil"],
    Cell[238346, 8919, 468, 11, 84, "Notes",
      CellTags->"Import::nffil"]},
  "Import::nlist"->{
    Cell[238851, 8935, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::nlist"],
    Cell[238933, 8938, 164, 4, 21, "Message",
      CellTags->"Import::nlist"],
    Cell[239100, 8944, 193, 6, 24, "Notes",
      CellTags->"Import::nlist"]},
  "Import::nlist2"->{
    Cell[239330, 8955, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::nlist2"],
    Cell[239414, 8958, 319, 8, 21, "Message",
      CellTags->"Import::nlist2"],
    Cell[239736, 8968, 194, 6, 24, "Notes",
      CellTags->"Import::nlist2"]},
  "ImportString::string"->{
    Cell[239967, 8979, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ImportString::string"],
    Cell[240063, 8982, 184, 4, 21, "Message",
      CellTags->"ImportString::string"],
    Cell[240250, 8988, 184, 5, 24, "Notes",
      CellTags->"ImportString::string"],
    Cell[240459, 8997, 70, 1, 38, "ExampleSection",
      CellTags->"ImportString::string"],
    Cell[240532, 9000, 137, 4, 24, "Text",
      CellTags->"ImportString::string"],
    Cell[240694, 9008, 116, 3, 26, "Input",
      CellTags->"ImportString::string"],
    Cell[240813, 9013, 189, 4, 21, "Message",
      CellTags->"ImportString::string"],
    Cell[241005, 9019, 117, 3, 21, "Output",
      CellTags->"ImportString::string"],
    Cell[241137, 9025, 139, 5, 24, "Text",
      CellTags->"ImportString::string"],
    Cell[241301, 9034, 128, 3, 26, "Input",
      CellTags->"ImportString::string"],
    Cell[241432, 9039, 99, 3, 21, "Output",
      CellTags->"ImportString::string"]},
  "Import::nodta"->{
    Cell[241592, 9049, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::nodta"],
    Cell[241674, 9052, 174, 4, 21, "Message",
      CellTags->"Import::nodta"],
    Cell[241851, 9058, 159, 4, 24, "Notes",
      CellTags->"Import::nodta"]},
  "Import::unsup"->{
    Cell[242047, 9067, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::unsup"],
    Cell[242129, 9070, 163, 4, 21, "Message",
      CellTags->"Import::unsup"],
    Cell[242295, 9076, 310, 7, 62, "Notes",
      CellTags->"Import::unsup"]},
  "$NumberMarks::nmarkset"->{
    Cell[242642, 9088, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$NumberMarks::nmarkset"],
    Cell[242742, 9091, 473, 12, 37, "Message",
      CellTags->"$NumberMarks::nmarkset"],
    Cell[243218, 9105, 309, 11, 40, "Notes",
      CellTags->"$NumberMarks::nmarkset"],
    Cell[243552, 9120, 72, 1, 38, "ExampleSection",
      CellTags->"$NumberMarks::nmarkset"],
    Cell[243627, 9123, 267, 9, 40, "Text",
      CellTags->"$NumberMarks::nmarkset"],
    Cell[243919, 9136, 114, 3, 26, "Input",
      CellTags->"$NumberMarks::nmarkset"],
    Cell[244036, 9141, 247, 5, 37, "Message",
      CellTags->"$NumberMarks::nmarkset"],
    Cell[244286, 9148, 100, 3, 21, "Output",
      CellTags->"$NumberMarks::nmarkset"]},
  "Integrate::diffend"->{
    Cell[244447, 9158, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Integrate::diffend"],
    Cell[244539, 9161, 298, 6, 69, "Message",
      CellTags->"Integrate::diffend"],
    Cell[244840, 9169, 253, 6, 40, "Notes",
      CellTags->"Integrate::diffend"],
    Cell[245118, 9179, 68, 1, 38, "ExampleSection",
      CellTags->"Integrate::diffend"],
    Cell[245189, 9182, 155, 4, 24, "Text",
      CellTags->"Integrate::diffend"],
    Cell[245369, 9190, 130, 3, 40, "Input",
      CellTags->"Integrate::diffend"],
    Cell[245502, 9195, 423, 7, 61, "Message",
      CellTags->"Integrate::diffend"],
    Cell[245928, 9204, 198, 5, 31, "Message",
      CellTags->"Integrate::diffend"],
    Cell[246141, 9212, 99, 1, 22, "Text",
      CellTags->"Integrate::diffend"],
    Cell[246265, 9217, 129, 3, 40, "Input",
      CellTags->"Integrate::diffend"],
    Cell[246397, 9222, 110, 3, 25, "Output",
      CellTags->"Integrate::diffend"]},
  "ToExpression::notstrbox"->{
    Cell[246568, 9232, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ToExpression::notstrbox"],
    Cell[246670, 9235, 257, 5, 33, "Message",
      CellTags->"ToExpression::notstrbox"],
    Cell[246930, 9242, 215, 5, 23, "Notes",
      CellTags->"ToExpression::notstrbox"],
    Cell[247170, 9251, 73, 1, 38, "ExampleSection",
      CellTags->"ToExpression::notstrbox"],
    Cell[247246, 9254, 200, 5, 23, "Text",
      CellTags->"ToExpression::notstrbox"],
    Cell[247471, 9263, 116, 3, 26, "Input",
      CellTags->"ToExpression::notstrbox"],
    Cell[247590, 9268, 282, 5, 33, "Message",
      CellTags->"ToExpression::notstrbox"],
    Cell[247875, 9275, 104, 3, 25, "Output",
      CellTags->"ToExpression::notstrbox"],
    Cell[247994, 9281, 173, 5, 23, "Text",
      CellTags->"ToExpression::notstrbox"],
    Cell[248192, 9290, 146, 3, 26, "Input",
      CellTags->"ToExpression::notstrbox"],
    Cell[248341, 9295, 120, 3, 25, "Output",
      CellTags->"ToExpression::notstrbox"]},
  "Syntax::com"->{
    Cell[248522, 9305, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Syntax::com"],
    Cell[248600, 9308, 232, 5, 33, "Message",
      CellTags->"Syntax::com"],
    Cell[248835, 9315, 518, 10, 90, "Notes",
      CellTags->"Syntax::com"],
    Cell[249378, 9329, 61, 1, 38, "ExampleSection",
      CellTags->"Syntax::com"],
    Cell[249442, 9332, 188, 5, 24, "Text",
      CellTags->"Syntax::com"],
    Cell[249655, 9341, 128, 3, 26, "Input",
      CellTags->"Syntax::com"],
    Cell[249786, 9346, 241, 5, 53, "Message",
      CellTags->"Syntax::com"],
    Cell[250030, 9353, 86, 3, 21, "Output",
      CellTags->"Syntax::com"],
    Cell[250131, 9359, 183, 5, 40, "Text",
      CellTags->"Syntax::com"],
    Cell[250339, 9368, 132, 3, 26, "Input",
      CellTags->"Syntax::com"],
    Cell[250474, 9373, 86, 3, 21, "Output",
      CellTags->"Syntax::com"]},
  "Experimental`BinaryExport::coerce"->{
    Cell[250621, 9383, 119, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`BinaryExport::coerce"],
    Cell[250743, 9386, 183, 3, 21, "Message",
      CellTags->"Experimental`BinaryExport::coerce"],
    Cell[250929, 9391, 144, 4, 24, "Notes",
      CellTags->"Experimental`BinaryExport::coerce"]},
  "Experimental`BinaryExport::nomatch"->{
    Cell[251110, 9400, 121, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`BinaryExport::nomatch"],
    Cell[251234, 9403, 208, 3, 37, "Message",
      CellTags->"Experimental`BinaryExport::nomatch"],
    Cell[251445, 9408, 145, 4, 24, "Notes",
      CellTags->"Experimental`BinaryExport::nomatch"]},
  "Experimental`BinaryImport::nffil"->{
    Cell[251627, 9417, 117, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`BinaryImport::nffil"],
    Cell[251747, 9420, 182, 3, 21, "Message",
      CellTags->"Experimental`BinaryImport::nffil"],
    Cell[251932, 9425, 143, 4, 24, "Notes",
      CellTags->"Experimental`BinaryImport::nffil"]},
  "Import::dxfemp"->{
    Cell[252112, 9434, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::dxfemp"],
    Cell[252196, 9437, 194, 3, 37, "Message",
      CellTags->"Import::dxfemp"],
    Cell[252393, 9442, 125, 4, 24, "Notes",
      CellTags->"Import::dxfemp"]},
  "Import::dxfflg"->{
    Cell[252555, 9451, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::dxfflg"],
    Cell[252639, 9454, 186, 3, 21, "Message",
      CellTags->"Import::dxfflg"],
    Cell[252828, 9459, 125, 4, 24, "Notes",
      CellTags->"Import::dxfflg"]},
  "Import::dxflin"->{
    Cell[252990, 9468, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::dxflin"],
    Cell[253074, 9471, 253, 4, 37, "Message",
      CellTags->"Import::dxflin"],
    Cell[253330, 9477, 125, 4, 24, "Notes",
      CellTags->"Import::dxflin"]},
  "Import::dxfply"->{
    Cell[253492, 9486, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::dxfply"],
    Cell[253576, 9489, 223, 4, 37, "Message",
      CellTags->"Import::dxfply"],
    Cell[253802, 9495, 125, 4, 24, "Notes",
      CellTags->"Import::dxfply"]},
  "Import::dxfvbf"->{
    Cell[253964, 9504, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::dxfvbf"],
    Cell[254048, 9507, 232, 4, 37, "Message",
      CellTags->"Import::dxfvbf"],
    Cell[254283, 9513, 125, 4, 24, "Notes",
      CellTags->"Import::dxfvbf"]},
  "Import::nonintyear"->{
    Cell[254445, 9522, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::nonintyear"],
    Cell[254537, 9525, 568, 9, 117, "Message",
      CellTags->"Import::nonintyear"],
    Cell[255108, 9536, 129, 4, 24, "Notes",
      CellTags->"Import::nonintyear"]},
  "Import::costr"->{
    Cell[255274, 9545, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::costr"],
    Cell[255356, 9548, 215, 4, 37, "Message",
      CellTags->"Import::costr"],
    Cell[255574, 9554, 124, 4, 24, "Notes",
      CellTags->"Import::costr"]},
  "Import::malxml"->{
    Cell[255735, 9563, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::malxml"],
    Cell[255819, 9566, 234, 4, 53, "Message",
      CellTags->"Import::malxml"],
    Cell[256056, 9572, 125, 4, 24, "Notes",
      CellTags->"Import::malxml"]},
  "Import::pdtder"->{
    Cell[256218, 9581, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::pdtder"],
    Cell[256302, 9584, 381, 7, 85, "Message",
      CellTags->"Import::pdtder"],
    Cell[256686, 9593, 125, 4, 24, "Notes",
      CellTags->"Import::pdtder"]},
  "Import::unrecxml"->{
    Cell[256848, 9602, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::unrecxml"],
    Cell[256936, 9605, 235, 5, 37, "Message",
      CellTags->"Import::unrecxml"],
    Cell[257174, 9612, 127, 4, 24, "Notes",
      CellTags->"Import::unrecxml"]},
  "MathMLForm::boxfmt"->{
    Cell[257338, 9621, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"MathMLForm::boxfmt"],
    Cell[257430, 9624, 388, 7, 53, "Message",
      CellTags->"MathMLForm::boxfmt"],
    Cell[257821, 9633, 129, 4, 24, "Notes",
      CellTags->"MathMLForm::boxfmt"]},
  "Experimental`RegisterConverter::extensions"->{
    Cell[257987, 9642, 137, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`RegisterConverter::extensions"],
    Cell[258127, 9645, 246, 4, 37, "Message",
      CellTags->"Experimental`RegisterConverter::extensions"],
    Cell[258376, 9651, 153, 4, 24, "Notes",
      CellTags->"Experimental`RegisterConverter::extensions"]},
  "Experimental`RegisterConverter::mode"->{
    Cell[258566, 9660, 125, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`RegisterConverter::mode"],
    Cell[258694, 9663, 240, 4, 37, "Message",
      CellTags->"Experimental`RegisterConverter::mode"],
    Cell[258937, 9669, 147, 4, 24, "Notes",
      CellTags->"Experimental`RegisterConverter::mode"]},
  "Experimental`RegisterConverter::noexe"->{
    Cell[259121, 9678, 127, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`RegisterConverter::noexe"],
    Cell[259251, 9681, 219, 3, 37, "Message",
      CellTags->"Experimental`RegisterConverter::noexe"],
    Cell[259473, 9686, 148, 4, 24, "Notes",
      CellTags->"Experimental`RegisterConverter::noexe"]},
  "Experimental`RegisterConverter::source"->{
    Cell[259658, 9695, 129, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`RegisterConverter::source"],
    Cell[259790, 9698, 261, 4, 37, "Message",
      CellTags->"Experimental`RegisterConverter::source"],
    Cell[260054, 9704, 149, 4, 24, "Notes",
      CellTags->"Experimental`RegisterConverter::source"]},
  "General::boxfmt"->{
    Cell[260240, 9713, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::boxfmt"],
    Cell[260326, 9716, 326, 9, 37, "Message",
      CellTags->"General::boxfmt"],
    Cell[260655, 9727, 361, 9, 46, "Notes",
      CellTags->"General::boxfmt"],
    Cell[261041, 9740, 65, 1, 38, "ExampleSection",
      CellTags->"General::boxfmt"],
    Cell[261109, 9743, 220, 7, 24, "Text",
      CellTags->"General::boxfmt"],
    Cell[261354, 9754, 115, 3, 26, "Input",
      CellTags->"General::boxfmt"],
    Cell[261472, 9759, 291, 6, 53, "Message",
      CellTags->"General::boxfmt"],
    Cell[261766, 9767, 116, 3, 21, "Output",
      CellTags->"General::boxfmt"],
    Cell[261897, 9773, 198, 7, 24, "Text",
      CellTags->"General::boxfmt"],
    Cell[262120, 9784, 97, 3, 26, "Input",
      CellTags->"General::boxfmt"],
    Cell[262220, 9789, 129, 3, 21, "Output",
      CellTags->"General::boxfmt"],
    Cell[262364, 9795, 129, 5, 24, "Text",
      CellTags->"General::boxfmt"],
    Cell[262518, 9804, 120, 3, 26, "Input",
      CellTags->"General::boxfmt"],
    Cell[262641, 9809, 145, 3, 21, "Output",
      CellTags->"General::boxfmt"]},
  "General::byteord"->{
    Cell[262847, 9819, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::byteord"],
    Cell[262935, 9822, 263, 7, 21, "Message",
      CellTags->"General::byteord"],
    Cell[263201, 9831, 127, 4, 24, "Notes",
      CellTags->"General::byteord"]},
  "General::conopt"->{
    Cell[263365, 9840, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::conopt"],
    Cell[263451, 9843, 316, 8, 37, "Message",
      CellTags->"General::conopt"],
    Cell[263770, 9853, 126, 4, 24, "Notes",
      CellTags->"General::conopt"]},
  "General::interpfmt"->{
    Cell[263933, 9862, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::interpfmt"],
    Cell[264025, 9865, 358, 9, 37, "Message",
      CellTags->"General::interpfmt"],
    Cell[264386, 9876, 129, 4, 24, "Notes",
      CellTags->"General::interpfmt"]},
  "General::notstr"->{
    Cell[264552, 9885, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::notstr"],
    Cell[264638, 9888, 264, 7, 21, "Message",
      CellTags->"General::notstr"],
    Cell[264905, 9897, 266, 8, 40, "Notes",
      CellTags->"General::notstr"],
    Cell[265196, 9909, 65, 1, 38, "ExampleSection",
      CellTags->"General::notstr"],
    Cell[265264, 9912, 208, 7, 24, "Text",
      CellTags->"General::notstr"],
    Cell[265497, 9923, 156, 4, 26, "Input",
      CellTags->"General::notstr"],
    Cell[265656, 9929, 208, 5, 37, "Message",
      CellTags->"General::notstr"],
    Cell[265867, 9936, 138, 3, 21, "Output",
      CellTags->"General::notstr"],
    Cell[266020, 9942, 126, 5, 24, "Text",
      CellTags->"General::notstr"],
    Cell[266171, 9951, 125, 3, 26, "Input",
      CellTags->"General::notstr"],
    Cell[266299, 9956, 98, 3, 25, "Output",
      CellTags->"General::notstr"],
    Cell[266412, 9962, 200, 7, 23, "Text",
      CellTags->"General::notstr"],
    Cell[266637, 9973, 159, 4, 26, "Input",
      CellTags->"General::notstr"],
    Cell[266799, 9979, 98, 3, 25, "Output",
      CellTags->"General::notstr"]},
  "MessageName::messg"->{
    Cell[266958, 9989, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"MessageName::messg"],
    Cell[267050, 9992, 447, 11, 19, "Message",
      CellTags->"MessageName::messg"],
    Cell[267500, 10005, 590, 18, 56, "Notes",
      CellTags->"MessageName::messg"],
    Cell[268115, 10027, 68, 1, 38, "ExampleSection",
      CellTags->"MessageName::messg"],
    Cell[268186, 10030, 183, 5, 23, "Text",
      CellTags->"MessageName::messg"],
    Cell[268394, 10039, 104, 3, 26, "Input",
      CellTags->"MessageName::messg"],
    Cell[268501, 10044, 221, 5, 19, "Message",
      CellTags->"MessageName::messg"]},
  "Get::enkey"->{
    Cell[268783, 10056, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Get::enkey"],
    Cell[268859, 10059, 174, 3, 19, "Message",
      CellTags->"Get::enkey"],
    Cell[269036, 10064, 644, 15, 90, "Notes",
      CellTags->"Get::enkey"]},
  "Save::wtype"->{
    Cell[269717, 10084, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Save::wtype"],
    Cell[269795, 10087, 204, 5, 19, "Message",
      CellTags->"Save::wtype"],
    Cell[270002, 10094, 184, 5, 23, "Notes",
      CellTags->"Save::wtype"],
    Cell[270211, 10103, 61, 1, 38, "ExampleSection",
      CellTags->"Save::wtype"],
    Cell[270275, 10106, 143, 5, 23, "Text",
      CellTags->"Save::wtype"],
    Cell[270443, 10115, 111, 3, 26, "Input",
      CellTags->"Save::wtype"],
    Cell[270557, 10120, 259, 5, 37, "Message",
      CellTags->"Save::wtype"],
    Cell[270819, 10127, 108, 3, 21, "Output",
      CellTags->"Save::wtype"]},
  "Close::spfile"->{
    Cell[270988, 10137, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Close::spfile"],
    Cell[271070, 10140, 220, 5, 21, "Message",
      CellTags->"Close::spfile"],
    Cell[271293, 10147, 447, 9, 78, "Notes",
      CellTags->"Close::spfile"],
    Cell[271765, 10160, 63, 1, 38, "ExampleSection",
      CellTags->"Close::spfile"],
    Cell[271831, 10163, 179, 5, 24, "Text",
      CellTags->"Close::spfile"],
    Cell[272035, 10172, 109, 3, 26, "Input",
      CellTags->"Close::spfile"],
    Cell[272147, 10177, 204, 5, 21, "Message",
      CellTags->"Close::spfile"],
    Cell[272354, 10184, 119, 3, 21, "Output",
      CellTags->"Close::spfile"]},
  "DumpGet::bgbf"->{
    Cell[272534, 10194, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DumpGet::bgbf"],
    Cell[272616, 10197, 286, 6, 37, "Message",
      CellTags->"DumpGet::bgbf"],
    Cell[272905, 10205, 541, 16, 62, "Notes",
      CellTags->"DumpGet::bgbf"],
    Cell[273471, 10225, 63, 1, 38, "ExampleSection",
      CellTags->"DumpGet::bgbf"],
    Cell[273537, 10228, 243, 7, 40, "Text",
      CellTags->"DumpGet::bgbf"],
    Cell[273783, 10237, 130, 3, 26, "Input",
      CellTags->"DumpGet::bgbf"],
    Cell[273938, 10244, 108, 3, 26, "Input",
      CellTags->"DumpGet::bgbf"],
    Cell[274049, 10249, 230, 5, 37, "Message",
      CellTags->"DumpGet::bgbf"],
    Cell[274282, 10256, 94, 3, 21, "Output",
      CellTags->"DumpGet::bgbf"],
    Cell[274391, 10262, 196, 7, 24, "Text",
      CellTags->"DumpGet::bgbf"],
    Cell[274612, 10273, 117, 3, 26, "Input",
      CellTags->"DumpGet::bgbf"],
    Cell[274732, 10278, 91, 3, 25, "Output",
      CellTags->"DumpGet::bgbf"],
    Cell[274838, 10284, 108, 3, 26, "Input",
      CellTags->"DumpGet::bgbf"],
    Cell[274949, 10289, 61, 1, 22, "Text",
      CellTags->"DumpGet::bgbf"],
    Cell[275013, 10292, 111, 3, 26, "Input",
      CellTags->"DumpGet::bgbf"]},
  "DumpGet::bgchk"->{
    Cell[275173, 10301, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DumpGet::bgchk"],
    Cell[275257, 10304, 180, 4, 19, "Message",
      CellTags->"DumpGet::bgchk"],
    Cell[275440, 10310, 615, 17, 78, "Notes",
      CellTags->"DumpGet::bgchk"]},
  "DumpGet::bgcor"->{
    Cell[276092, 10332, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DumpGet::bgcor"],
    Cell[276176, 10335, 227, 5, 19, "Message",
      CellTags->"DumpGet::bgcor"],
    Cell[276406, 10342, 480, 13, 58, "Notes",
      CellTags->"DumpGet::bgcor"]},
  "DumpGet::bgnew"->{
    Cell[276923, 10360, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DumpGet::bgnew"],
    Cell[277007, 10363, 217, 5, 33, "Message",
      CellTags->"DumpGet::bgnew"],
    Cell[277227, 10370, 392, 9, 59, "Notes",
      CellTags->"DumpGet::bgnew"]},
  "DumpGet::bgold"->{
    Cell[277656, 10384, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DumpGet::bgold"],
    Cell[277740, 10387, 206, 5, 19, "Message",
      CellTags->"DumpGet::bgold"],
    Cell[277949, 10394, 194, 6, 24, "Notes",
      CellTags->"DumpGet::bgold"]},
  "DumpGet::valwarn"->{
    Cell[278180, 10405, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DumpGet::valwarn"],
    Cell[278268, 10408, 353, 10, 19, "Message",
      CellTags->"DumpGet::valwarn"],
    Cell[278624, 10420, 315, 9, 43, "Notes",
      CellTags->"DumpGet::valwarn"]},
  "DumpSave::bschk"->{
    Cell[278976, 10434, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DumpSave::bschk"],
    Cell[279062, 10437, 151, 3, 21, "Message",
      CellTags->"DumpSave::bschk"],
    Cell[279216, 10442, 314, 7, 46, "Notes",
      CellTags->"DumpSave::bschk"]},
  "DumpSave::bsnosym"->{
    Cell[279567, 10454, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DumpSave::bsnosym"],
    Cell[279657, 10457, 231, 5, 21, "Message",
      CellTags->"DumpSave::bsnosym"],
    Cell[279891, 10464, 225, 5, 40, "Notes",
      CellTags->"DumpSave::bsnosym"],
    Cell[280141, 10473, 67, 1, 38, "ExampleSection",
      CellTags->"DumpSave::bsnosym"],
    Cell[280211, 10476, 201, 6, 24, "Text",
      CellTags->"DumpSave::bsnosym"],
    Cell[280437, 10486, 116, 3, 26, "Input",
      CellTags->"DumpSave::bsnosym"],
    Cell[280556, 10491, 190, 4, 21, "Message",
      CellTags->"DumpSave::bsnosym"],
    Cell[280749, 10497, 113, 3, 21, "Output",
      CellTags->"DumpSave::bsnosym"]},
  "DumpSave::bsstm"->{
    Cell[280923, 10507, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DumpSave::bsstm"],
    Cell[281009, 10510, 274, 6, 21, "Message",
      CellTags->"DumpSave::bsstm"],
    Cell[281286, 10518, 195, 6, 24, "Notes",
      CellTags->"DumpSave::bsstm"]},
  "DumpSave::outref"->{
    Cell[281518, 10529, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DumpSave::outref"],
    Cell[281606, 10532, 460, 9, 37, "Message",
      CellTags->"DumpSave::outref"],
    Cell[282069, 10543, 635, 19, 78, "Notes",
      CellTags->"DumpSave::outref"],
    Cell[282729, 10566, 66, 1, 38, "ExampleSection",
      CellTags->"DumpSave::outref"],
    Cell[282798, 10569, 186, 4, 40, "Text",
      CellTags->"DumpSave::outref"],
    Cell[283009, 10577, 187, 4, 74, "Input",
      CellTags->"DumpSave::outref"],
    Cell[283199, 10583, 246, 5, 53, "Message",
      CellTags->"DumpSave::outref"],
    Cell[283448, 10590, 96, 3, 21, "Output",
      CellTags->"DumpSave::outref"]},
  "Get::path"->{
    Cell[283605, 10600, 71, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Get::path"],
    Cell[283679, 10603, 197, 5, 19, "Message",
      CellTags->"Get::path"],
    Cell[283879, 10610, 492, 13, 63, "Notes",
      CellTags->"Get::path"],
    Cell[284396, 10627, 59, 1, 38, "ExampleSection",
      CellTags->"Get::path"],
    Cell[284458, 10630, 178, 5, 23, "Text",
      CellTags->"Get::path"],
    Cell[284661, 10639, 120, 3, 26, "Input",
      CellTags->"Get::path"],
    Cell[284784, 10644, 162, 4, 19, "Message",
      CellTags->"Get::path"],
    Cell[284949, 10650, 155, 4, 19, "Message",
      CellTags->"Get::path"],
    Cell[285107, 10656, 90, 3, 25, "Output",
      CellTags->"Get::path"]},
  "Information::basic"->{
    Cell[285258, 10666, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Information::basic"],
    Cell[285350, 10669, 240, 4, 33, "Message",
      CellTags->"Information::basic"],
    Cell[285593, 10675, 246, 6, 43, "Notes",
      CellTags->"Information::basic"],
    Cell[285864, 10685, 68, 1, 38, "ExampleSection",
      CellTags->"Information::basic"],
    Cell[285935, 10688, 91, 1, 22, "Text",
      CellTags->"Information::basic"],
    Cell[286051, 10693, 92, 3, 26, "Input",
      CellTags->"Information::basic"],
    Cell[286146, 10698, 247, 5, 33, "Message",
      CellTags->"Information::basic"]},
  "Information::nomatch"->{
    Cell[286454, 10710, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Information::nomatch"],
    Cell[286550, 10713, 243, 5, 19, "Message",
      CellTags->"Information::nomatch"],
    Cell[286796, 10720, 407, 10, 57, "Notes",
      CellTags->"Information::nomatch"],
    Cell[287228, 10734, 70, 1, 38, "ExampleSection",
      CellTags->"Information::nomatch"],
    Cell[287301, 10737, 163, 4, 22, "Text",
      CellTags->"Information::nomatch"],
    Cell[287489, 10745, 100, 3, 26, "Input",
      CellTags->"Information::nomatch"],
    Cell[287592, 10750, 186, 4, 19, "Message",
      CellTags->"Information::nomatch"],
    Cell[287793, 10757, 129, 4, 24, "Text",
      CellTags->"Information::nomatch"],
    Cell[287947, 10765, 100, 3, 26, "Input",
      CellTags->"Information::nomatch"],
    Cell[288050, 10770, 2701, 66, 73, "Print",
      CellTags->"Information::nomatch"]},
  "Information::notfound1"->{
    Cell[290812, 10843, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Information::notfound1"],
    Cell[290912, 10846, 226, 5, 21, "Message",
      CellTags->"Information::notfound1"],
    Cell[291141, 10853, 184, 4, 24, "Notes",
      CellTags->"Information::notfound1"]},
  "Information::opt"->{
    Cell[291362, 10862, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Information::opt"],
    Cell[291450, 10865, 205, 5, 19, "Message",
      CellTags->"Information::opt"],
    Cell[291658, 10872, 196, 6, 24, "Notes",
      CellTags->"Information::opt"]},
  "Message::msgl"->{
    Cell[291891, 10883, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Message::msgl"],
    Cell[291973, 10886, 245, 6, 19, "Message",
      CellTags->"Message::msgl"],
    Cell[292221, 10894, 403, 10, 57, "Notes",
      CellTags->"Message::msgl"],
    Cell[292649, 10908, 63, 1, 38, "ExampleSection",
      CellTags->"Message::msgl"],
    Cell[292715, 10911, 192, 5, 23, "Text",
      CellTags->"Message::msgl"],
    Cell[292932, 10920, 114, 3, 26, "Input",
      CellTags->"Message::msgl"],
    Cell[293049, 10925, 192, 5, 19, "Message",
      CellTags->"Message::msgl"],
    Cell[293244, 10932, 196, 5, 19, "Message",
      CellTags->"Message::msgl"],
    Cell[293443, 10939, 92, 3, 25, "Output",
      CellTags->"Message::msgl"]},
  "Message::name"->{
    Cell[293596, 10949, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Message::name"],
    Cell[293678, 10952, 279, 6, 19, "Message",
      CellTags->"Message::name"],
    Cell[293960, 10960, 188, 5, 23, "Notes",
      CellTags->"Message::name"],
    Cell[294173, 10969, 63, 1, 38, "ExampleSection",
      CellTags->"Message::name"],
    Cell[294239, 10972, 236, 7, 38, "Text",
      CellTags->"Message::name"],
    Cell[294500, 10983, 106, 3, 26, "Input",
      CellTags->"Message::name"],
    Cell[294609, 10988, 217, 5, 33, "Message",
      CellTags->"Message::name"],
    Cell[294829, 10995, 107, 3, 25, "Output",
      CellTags->"Message::name"],
    Cell[294951, 11001, 157, 5, 23, "Text",
      CellTags->"Message::name"],
    Cell[295133, 11010, 112, 3, 26, "Input",
      CellTags->"Message::name"],
    Cell[295248, 11015, 196, 5, 19, "Message",
      CellTags->"Message::name"]},
  "Needs::nocont"->{
    Cell[295505, 11027, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Needs::nocont"],
    Cell[295587, 11030, 245, 5, 21, "Message",
      CellTags->"Needs::nocont"],
    Cell[295835, 11037, 1199, 25, 198, "Notes",
      CellTags->"Needs::nocont"],
    Cell[297059, 11066, 63, 1, 38, "ExampleSection",
      CellTags->"Needs::nocont"],
    Cell[297125, 11069, 287, 6, 56, "Text",
      CellTags->"Needs::nocont"],
    Cell[297437, 11079, 109, 3, 26, "Input",
      CellTags->"Needs::nocont"],
    Cell[297549, 11084, 165, 4, 21, "Message",
      CellTags->"Needs::nocont"],
    Cell[297717, 11090, 206, 5, 37, "Message",
      CellTags->"Needs::nocont"],
    Cell[297926, 11097, 94, 3, 21, "Output",
      CellTags->"Needs::nocont"]},
  "On::none"->{
    Cell[298081, 11107, 69, 1, 31, "ObjectNameWarningMessages",
      CellTags->"On::none"],
    Cell[298153, 11110, 197, 4, 21, "Message",
      CellTags->"On::none"],
    Cell[298353, 11116, 178, 5, 24, "Notes",
      CellTags->"On::none"],
    Cell[298556, 11125, 58, 1, 38, "ExampleSection",
      CellTags->"On::none"],
    Cell[298617, 11128, 214, 7, 24, "Text",
      CellTags->"On::none"],
    Cell[298856, 11139, 93, 3, 26, "Input",
      CellTags->"On::none"],
    Cell[298952, 11144, 163, 4, 21, "Message",
      CellTags->"On::none"]},
  "Read::readf"->{
    Cell[299176, 11155, 147, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[299326, 11162, 415, 11, 21, "Message",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[299744, 11175, 683, 26, 62, "Notes",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[300452, 11205, 97, 1, 38, "ExampleSection",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[300552, 11208, 207, 5, 24, "Text",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[300784, 11217, 246, 5, 90, "Input",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[301033, 11224, 220, 4, 21, "Message",
      CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}],
    Cell[301256, 11230, 165, 3, 21, "Output",
      CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}],
    Cell[301436, 11236, 175, 5, 23, "Text",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[301636, 11245, 245, 5, 90, "Input",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[301884, 11252, 133, 3, 25, "Output",
      CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}]},
  "ReadList::readf"->{
    Cell[299176, 11155, 147, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[299326, 11162, 415, 11, 21, "Message",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[299744, 11175, 683, 26, 62, "Notes",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[300452, 11205, 97, 1, 38, "ExampleSection",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[300552, 11208, 207, 5, 24, "Text",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[300784, 11217, 246, 5, 90, "Input",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[301033, 11224, 220, 4, 21, "Message",
      CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}],
    Cell[301256, 11230, 165, 3, 21, "Output",
      CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}],
    Cell[301436, 11236, 175, 5, 23, "Text",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[301636, 11245, 245, 5, 90, "Input",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[301884, 11252, 133, 3, 25, "Output",
      CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}]},
  "Skip::readf"->{
    Cell[299176, 11155, 147, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[299326, 11162, 415, 11, 21, "Message",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[299744, 11175, 683, 26, 62, "Notes",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[300452, 11205, 97, 1, 38, "ExampleSection",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[300552, 11208, 207, 5, 24, "Text",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[300784, 11217, 246, 5, 90, "Input",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[301033, 11224, 220, 4, 21, "Message",
      CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}],
    Cell[301256, 11230, 165, 3, 21, "Output",
      CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}],
    Cell[301436, 11236, 175, 5, 23, "Text",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[301636, 11245, 245, 5, 90, "Input",
      CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
    Cell[301884, 11252, 133, 3, 25, "Output",
      CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}]},
  "Read::readn"->{
    Cell[302078, 11262, 147, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[302228, 11269, 433, 12, 19, "Message",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[302664, 11283, 275, 6, 37, "Notes",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[302964, 11293, 97, 1, 38, "ExampleSection",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[303064, 11296, 232, 6, 23, "Text",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[303321, 11306, 252, 5, 90, "Input",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[303576, 11313, 275, 6, 33, "Message",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[303854, 11321, 130, 3, 25, "Output",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[303999, 11327, 168, 5, 23, "Text",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[304192, 11336, 261, 5, 90, "Input",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[304456, 11343, 141, 3, 25, "Output",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[304612, 11349, 227, 6, 23, "Text",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[304864, 11359, 250, 5, 90, "Input",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[305117, 11366, 273, 6, 33, "Message",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[305393, 11374, 136, 3, 25, "Output",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[305544, 11380, 250, 7, 23, "Text",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[305819, 11391, 296, 5, 90, "Input",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[306118, 11398, 139, 3, 25, "Output",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}]},
  "ReadList::readn"->{
    Cell[302078, 11262, 147, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[302228, 11269, 433, 12, 19, "Message",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[302664, 11283, 275, 6, 37, "Notes",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[302964, 11293, 97, 1, 38, "ExampleSection",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[303064, 11296, 232, 6, 23, "Text",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[303321, 11306, 252, 5, 90, "Input",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[303576, 11313, 275, 6, 33, "Message",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[303854, 11321, 130, 3, 25, "Output",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[303999, 11327, 168, 5, 23, "Text",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[304192, 11336, 261, 5, 90, "Input",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[304456, 11343, 141, 3, 25, "Output",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[304612, 11349, 227, 6, 23, "Text",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[304864, 11359, 250, 5, 90, "Input",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[305117, 11366, 273, 6, 33, "Message",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[305393, 11374, 136, 3, 25, "Output",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[305544, 11380, 250, 7, 23, "Text",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[305819, 11391, 296, 5, 90, "Input",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[306118, 11398, 139, 3, 25, "Output",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}]},
  "Skip::readn"->{
    Cell[302078, 11262, 147, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[302228, 11269, 433, 12, 19, "Message",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[302664, 11283, 275, 6, 37, "Notes",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[302964, 11293, 97, 1, 38, "ExampleSection",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[303064, 11296, 232, 6, 23, "Text",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[303321, 11306, 252, 5, 90, "Input",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[303576, 11313, 275, 6, 33, "Message",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[303854, 11321, 130, 3, 25, "Output",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[303999, 11327, 168, 5, 23, "Text",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[304192, 11336, 261, 5, 90, "Input",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[304456, 11343, 141, 3, 25, "Output",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[304612, 11349, 227, 6, 23, "Text",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[304864, 11359, 250, 5, 90, "Input",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[305117, 11366, 273, 6, 33, "Message",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[305393, 11374, 136, 3, 25, "Output",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
    Cell[305544, 11380, 250, 7, 23, "Text",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[305819, 11391, 296, 5, 90, "Input",
      CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
    Cell[306118, 11398, 139, 3, 25, "Output",
      CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}]},
  "Read::readt"->{
    Cell[306318, 11408, 147, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[306468, 11415, 429, 13, 19, "Message",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[306900, 11430, 205, 4, 22, "Notes",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[307130, 11438, 97, 1, 38, "ExampleSection",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[307230, 11441, 276, 7, 38, "Text",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[307531, 11452, 231, 4, 90, "Input",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[307765, 11458, 274, 5, 33, "Message",
      CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}],
    Cell[308042, 11465, 128, 3, 25, "Output",
      CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}],
    Cell[308185, 11471, 137, 1, 22, "Text",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[308347, 11476, 232, 4, 90, "Input",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[308582, 11482, 123, 3, 25, "Output",
      CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}]},
  "ReadList::readt"->{
    Cell[306318, 11408, 147, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[306468, 11415, 429, 13, 19, "Message",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[306900, 11430, 205, 4, 22, "Notes",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[307130, 11438, 97, 1, 38, "ExampleSection",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[307230, 11441, 276, 7, 38, "Text",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[307531, 11452, 231, 4, 90, "Input",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[307765, 11458, 274, 5, 33, "Message",
      CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}],
    Cell[308042, 11465, 128, 3, 25, "Output",
      CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}],
    Cell[308185, 11471, 137, 1, 22, "Text",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[308347, 11476, 232, 4, 90, "Input",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[308582, 11482, 123, 3, 25, "Output",
      CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}]},
  "Skip::readt"->{
    Cell[306318, 11408, 147, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[306468, 11415, 429, 13, 19, "Message",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[306900, 11430, 205, 4, 22, "Notes",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[307130, 11438, 97, 1, 38, "ExampleSection",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[307230, 11441, 276, 7, 38, "Text",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[307531, 11452, 231, 4, 90, "Input",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[307765, 11458, 274, 5, 33, "Message",
      CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}],
    Cell[308042, 11465, 128, 3, 25, "Output",
      CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}],
    Cell[308185, 11471, 137, 1, 22, "Text",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[308347, 11476, 232, 4, 90, "Input",
      CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
    Cell[308582, 11482, 123, 3, 25, "Output",
      CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}]},
  "Read::readx"->{
    Cell[308766, 11492, 147, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[308916, 11499, 372, 11, 19, "Message",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[309291, 11512, 297, 9, 23, "Notes",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[309613, 11525, 97, 1, 38, "ExampleSection",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[309713, 11528, 229, 5, 23, "Text",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[309967, 11537, 250, 5, 90, "Input",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[310220, 11544, 200, 4, 19, "Message",
      CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}],
    Cell[310423, 11550, 164, 3, 25, "Output",
      CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}],
    Cell[310602, 11556, 175, 5, 23, "Text",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[310802, 11565, 246, 4, 90, "Input",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[311051, 11571, 144, 3, 25, "Output",
      CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}]},
  "ReadList::readx"->{
    Cell[308766, 11492, 147, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[308916, 11499, 372, 11, 19, "Message",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[309291, 11512, 297, 9, 23, "Notes",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[309613, 11525, 97, 1, 38, "ExampleSection",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[309713, 11528, 229, 5, 23, "Text",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[309967, 11537, 250, 5, 90, "Input",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[310220, 11544, 200, 4, 19, "Message",
      CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}],
    Cell[310423, 11550, 164, 3, 25, "Output",
      CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}],
    Cell[310602, 11556, 175, 5, 23, "Text",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[310802, 11565, 246, 4, 90, "Input",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[311051, 11571, 144, 3, 25, "Output",
      CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}]},
  "Skip::readx"->{
    Cell[308766, 11492, 147, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[308916, 11499, 372, 11, 19, "Message",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[309291, 11512, 297, 9, 23, "Notes",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[309613, 11525, 97, 1, 38, "ExampleSection",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[309713, 11528, 229, 5, 23, "Text",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[309967, 11537, 250, 5, 90, "Input",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[310220, 11544, 200, 4, 19, "Message",
      CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}],
    Cell[310423, 11550, 164, 3, 25, "Output",
      CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}],
    Cell[310602, 11556, 175, 5, 23, "Text",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[310802, 11565, 246, 4, 90, "Input",
      CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
    Cell[311051, 11571, 144, 3, 25, "Output",
      CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}]},
  "SetStreamPosition::sbuf"->{
    Cell[311256, 11581, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SetStreamPosition::sbuf"],
    Cell[311358, 11584, 472, 11, 33, "Message",
      CellTags->"SetStreamPosition::sbuf"],
    Cell[311833, 11597, 252, 6, 37, "Notes",
      CellTags->"SetStreamPosition::sbuf"],
    Cell[312110, 11607, 73, 1, 38, "ExampleSection",
      CellTags->"SetStreamPosition::sbuf"],
    Cell[312186, 11610, 263, 6, 37, "Text",
      CellTags->"SetStreamPosition::sbuf"],
    Cell[312474, 11620, 293, 6, 106, "Input",
      CellTags->"SetStreamPosition::sbuf"],
    Cell[312770, 11628, 320, 6, 47, "Message",
      CellTags->"SetStreamPosition::sbuf"],
    Cell[313093, 11636, 112, 3, 25, "Output",
      CellTags->"SetStreamPosition::sbuf"],
    Cell[313220, 11642, 143, 5, 23, "Text",
      CellTags->"SetStreamPosition::sbuf"],
    Cell[313388, 11651, 292, 6, 106, "Input",
      CellTags->"SetStreamPosition::sbuf"],
    Cell[313683, 11659, 112, 3, 25, "Output",
      CellTags->"SetStreamPosition::sbuf"]},
  "StringForm::sfq"->{
    Cell[313856, 11669, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"StringForm::sfq"],
    Cell[313942, 11672, 212, 5, 19, "Message",
      CellTags->"StringForm::sfq"],
    Cell[314157, 11679, 208, 5, 23, "Notes",
      CellTags->"StringForm::sfq"],
    Cell[314390, 11688, 65, 1, 38, "ExampleSection",
      CellTags->"StringForm::sfq"],
    Cell[314458, 11691, 202, 6, 24, "Text",
      CellTags->"StringForm::sfq"],
    Cell[314685, 11701, 139, 3, 26, "Input",
      CellTags->"StringForm::sfq"],
    Cell[314827, 11706, 198, 5, 21, "Message",
      CellTags->"StringForm::sfq"],
    Cell[315028, 11713, 217, 5, 21, "Output",
      CellTags->"StringForm::sfq"],
    Cell[315260, 11721, 139, 5, 24, "Text",
      CellTags->"StringForm::sfq"],
    Cell[315424, 11730, 140, 3, 26, "Input",
      CellTags->"StringForm::sfq"],
    Cell[315567, 11735, 245, 6, 21, "Output",
      CellTags->"StringForm::sfq"]},
  "General::aofil"->{
    Cell[315873, 11748, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::aofil"],
    Cell[315957, 11751, 396, 13, 21, "Message",
      CellTags->"General::aofil"],
    Cell[316356, 11766, 553, 12, 106, "Notes",
      CellTags->"General::aofil"],
    Cell[316934, 11782, 64, 1, 38, "ExampleSection",
      CellTags->"General::aofil"],
    Cell[317001, 11785, 178, 5, 24, "Text",
      CellTags->"General::aofil"],
    Cell[317204, 11794, 112, 3, 26, "Input",
      CellTags->"General::aofil"],
    Cell[317319, 11799, 118, 3, 21, "Output",
      CellTags->"General::aofil"],
    Cell[317474, 11807, 112, 3, 26, "Input",
      CellTags->"General::aofil"],
    Cell[317589, 11812, 190, 4, 21, "Message",
      CellTags->"General::aofil"],
    Cell[317782, 11818, 170, 4, 19, "Message",
      CellTags->"General::aofil"],
    Cell[317955, 11824, 95, 3, 25, "Output",
      CellTags->"General::aofil"],
    Cell[318065, 11830, 61, 1, 22, "Text",
      CellTags->"General::aofil"],
    Cell[318151, 11835, 108, 3, 26, "Input",
      CellTags->"General::aofil"],
    Cell[318262, 11840, 98, 3, 25, "Output",
      CellTags->"General::aofil"]},
  "General::filro"->{
    Cell[318421, 11850, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::filro"],
    Cell[318505, 11853, 418, 12, 19, "Message",
      CellTags->"General::filro"],
    Cell[318926, 11867, 299, 6, 56, "Notes",
      CellTags->"General::filro"]},
  "General::ioarg"->{
    Cell[319262, 11878, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ioarg"],
    Cell[319346, 11881, 398, 11, 19, "Message",
      CellTags->"General::ioarg"],
    Cell[319747, 11894, 292, 6, 56, "Notes",
      CellTags->"General::ioarg"]},
  "General::ioerr"->{
    Cell[320076, 11905, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ioerr"],
    Cell[320160, 11908, 357, 11, 19, "Message",
      CellTags->"General::ioerr"],
    Cell[320520, 11921, 282, 6, 42, "Notes",
      CellTags->"General::ioerr"]},
  "General::isdir"->{
    Cell[320839, 11932, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::isdir"],
    Cell[320923, 11935, 240, 7, 19, "Message",
      CellTags->"General::isdir"],
    Cell[321166, 11944, 388, 9, 56, "Notes",
      CellTags->"General::isdir"]},
  "General::noopen"->{
    Cell[321591, 11958, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::noopen"],
    Cell[321677, 11961, 327, 11, 19, "Message",
      CellTags->"General::noopen"],
    Cell[322007, 11974, 635, 13, 112, "Notes",
      CellTags->"General::noopen"],
    Cell[322667, 11991, 65, 1, 38, "ExampleSection",
      CellTags->"General::noopen"],
    Cell[322735, 11994, 141, 4, 22, "Text",
      CellTags->"General::noopen"],
    Cell[322901, 12002, 105, 3, 26, "Input",
      CellTags->"General::noopen"],
    Cell[323009, 12007, 163, 4, 19, "Message",
      CellTags->"General::noopen"],
    Cell[323175, 12013, 96, 3, 25, "Output",
      CellTags->"General::noopen"],
    Cell[323286, 12019, 193, 5, 36, "Text",
      CellTags->"General::noopen"],
    Cell[323504, 12028, 132, 3, 26, "Input",
      CellTags->"General::noopen"],
    Cell[323639, 12033, 192, 5, 19, "Message",
      CellTags->"General::noopen"],
    Cell[323834, 12040, 96, 3, 25, "Output",
      CellTags->"General::noopen"],
    Cell[323945, 12046, 216, 5, 37, "Text",
      CellTags->"General::noopen"],
    Cell[324164, 12053, 134, 3, 26, "Input",
      CellTags->"General::noopen"]},
  "General::notfound"->{
    Cell[324347, 12062, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::notfound"],
    Cell[324437, 12065, 322, 9, 19, "Message",
      CellTags->"General::notfound"],
    Cell[324762, 12076, 542, 12, 90, "Notes",
      CellTags->"General::notfound"],
    Cell[325329, 12092, 67, 1, 38, "ExampleSection",
      CellTags->"General::notfound"],
    Cell[325399, 12095, 203, 5, 36, "Text",
      CellTags->"General::notfound"],
    Cell[325627, 12104, 101, 3, 26, "Input",
      CellTags->"General::notfound"],
    Cell[325731, 12109, 180, 4, 19, "Message",
      CellTags->"General::notfound"],
    Cell[325926, 12116, 80, 1, 22, "Text",
      CellTags->"General::notfound"],
    Cell[326031, 12121, 98, 3, 26, "Input",
      CellTags->"General::notfound"],
    Cell[326132, 12126, 170, 4, 21, "Print",
      CellTags->"General::notfound"]},
  "General::openr"->{
    Cell[326363, 12137, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::openr"],
    Cell[326447, 12140, 348, 11, 19, "Message",
      CellTags->"General::openr"],
    Cell[326798, 12153, 130, 4, 22, "Notes",
      CellTags->"General::openr"],
    Cell[326953, 12161, 64, 1, 38, "ExampleSection",
      CellTags->"General::openr"],
    Cell[327020, 12164, 93, 1, 22, "Text",
      CellTags->"General::openr"],
    Cell[327138, 12169, 122, 3, 26, "Input",
      CellTags->"General::openr"],
    Cell[327263, 12174, 113, 3, 25, "Output",
      CellTags->"General::openr"],
    Cell[327413, 12182, 98, 3, 26, "Input",
      CellTags->"General::openr"],
    Cell[327514, 12187, 196, 5, 19, "Message",
      CellTags->"General::openr"],
    Cell[327713, 12194, 187, 4, 19, "Message",
      CellTags->"General::openr"],
    Cell[327915, 12201, 63, 1, 22, "Text",
      CellTags->"General::openr"],
    Cell[328003, 12206, 95, 3, 26, "Input",
      CellTags->"General::openr"],
    Cell[328101, 12211, 94, 3, 25, "Output",
      CellTags->"General::openr"]},
  "General::openw"->{
    Cell[328256, 12221, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::openw"],
    Cell[328340, 12224, 349, 11, 19, "Message",
      CellTags->"General::openw"],
    Cell[328692, 12237, 132, 4, 22, "Notes",
      CellTags->"General::openw"],
    Cell[328849, 12245, 64, 1, 38, "ExampleSection",
      CellTags->"General::openw"],
    Cell[328916, 12248, 119, 4, 22, "Text",
      CellTags->"General::openw"],
    Cell[329060, 12256, 113, 3, 26, "Input",
      CellTags->"General::openw"],
    Cell[329176, 12261, 114, 3, 25, "Output",
      CellTags->"General::openw"],
    Cell[329327, 12269, 94, 3, 26, "Input",
      CellTags->"General::openw"],
    Cell[329424, 12274, 200, 5, 19, "Message",
      CellTags->"General::openw"],
    Cell[329627, 12281, 95, 3, 25, "Output",
      CellTags->"General::openw"],
    Cell[329737, 12287, 63, 1, 22, "Text",
      CellTags->"General::openw"],
    Cell[329825, 12292, 95, 3, 26, "Input",
      CellTags->"General::openw"],
    Cell[329923, 12297, 94, 3, 25, "Output",
      CellTags->"General::openw"]},
  "General::openx"->{
    Cell[330078, 12307, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::openx"],
    Cell[330162, 12310, 327, 11, 19, "Message",
      CellTags->"General::openx"],
    Cell[330492, 12323, 340, 11, 42, "Notes",
      CellTags->"General::openx"],
    Cell[330857, 12338, 64, 1, 38, "ExampleSection",
      CellTags->"General::openx"],
    Cell[330924, 12341, 208, 5, 37, "Text",
      CellTags->"General::openx"],
    Cell[331157, 12350, 103, 3, 26, "Input",
      CellTags->"General::openx"],
    Cell[331263, 12355, 160, 4, 19, "Message",
      CellTags->"General::openx"],
    Cell[331426, 12361, 100, 3, 25, "Output",
      CellTags->"General::openx"],
    Cell[331541, 12367, 155, 5, 23, "Text",
      CellTags->"General::openx"],
    Cell[331721, 12376, 204, 4, 106, "Input",
      CellTags->"General::openx"],
    Cell[331928, 12382, 97, 3, 25, "Output",
      CellTags->"General::openx"]},
  "General::readp"->{
    Cell[332086, 12392, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::readp"],
    Cell[332170, 12395, 339, 10, 19, "Message",
      CellTags->"General::readp"],
    Cell[332512, 12407, 287, 8, 38, "Notes",
      CellTags->"General::readp"],
    Cell[332824, 12419, 64, 1, 38, "ExampleSection",
      CellTags->"General::readp"],
    Cell[332891, 12422, 294, 10, 38, "Text",
      CellTags->"General::readp"],
    Cell[333188, 12434, 132, 3, 26, "Input",
      CellTags->"General::readp"],
    Cell[333345, 12441, 104, 3, 26, "Input",
      CellTags->"General::readp"],
    Cell[333452, 12446, 173, 4, 19, "Message",
      CellTags->"General::readp"],
    Cell[333628, 12452, 95, 3, 21, "Output",
      CellTags->"General::readp"]},
  "General::remote"->{
    Cell[333784, 12462, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::remote"],
    Cell[333870, 12465, 546, 13, 37, "Message",
      CellTags->"General::remote"],
    Cell[334419, 12480, 481, 14, 62, "Notes",
      CellTags->"General::remote"]},
  "General::stmtype"->{
    Cell[334937, 12499, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::stmtype"],
    Cell[335025, 12502, 591, 16, 37, "Message",
      CellTags->"General::stmtype"],
    Cell[335619, 12520, 196, 6, 24, "Notes",
      CellTags->"General::stmtype"]},
  "General::stop"->{
    Cell[335852, 12531, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::stop"],
    Cell[335934, 12534, 420, 11, 21, "Message",
      CellTags->"General::stop"],
    Cell[336357, 12547, 289, 6, 46, "Notes",
      CellTags->"General::stop"],
    Cell[336671, 12557, 63, 1, 38, "ExampleSection",
      CellTags->"General::stop"],
    Cell[336737, 12560, 138, 4, 24, "Text",
      CellTags->"General::stop"],
    Cell[336900, 12568, 132, 3, 26, "Input",
      CellTags->"General::stop"],
    Cell[337035, 12573, 252, 5, 53, "Message",
      CellTags->"General::stop"],
    Cell[337290, 12580, 252, 5, 53, "Message",
      CellTags->"General::stop"],
    Cell[337545, 12587, 252, 5, 53, "Message",
      CellTags->"General::stop"],
    Cell[337800, 12594, 226, 5, 37, "Message",
      CellTags->"General::stop"],
    Cell[338029, 12601, 283, 6, 21, "Output",
      CellTags->"General::stop"],
    Cell[338327, 12610, 78, 1, 24, "Text",
      CellTags->"General::stop"],
    Cell[338430, 12615, 137, 3, 26, "Input",
      CellTags->"General::stop"],
    Cell[338570, 12620, 108, 3, 21, "Output",
      CellTags->"General::stop"]},
  "General::stream"->{
    Cell[338739, 12630, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::stream"],
    Cell[338825, 12633, 451, 13, 21, "Message",
      CellTags->"General::stream"],
    Cell[339279, 12648, 259, 8, 40, "Notes",
      CellTags->"General::stream"],
    Cell[339563, 12660, 65, 1, 38, "ExampleSection",
      CellTags->"General::stream"],
    Cell[339631, 12663, 185, 5, 24, "Text",
      CellTags->"General::stream"],
    Cell[339841, 12672, 133, 3, 26, "Input",
      CellTags->"General::stream"],
    Cell[339977, 12677, 200, 5, 21, "Message",
      CellTags->"General::stream"],
    Cell[340180, 12684, 223, 6, 21, "Print",
      CellTags->"General::stream"],
    Cell[340418, 12693, 171, 7, 24, "Text",
      CellTags->"General::stream"],
    Cell[340614, 12704, 178, 4, 42, "Input",
      CellTags->"General::stream"],
    Cell[340795, 12710, 201, 5, 21, "Print",
      CellTags->"General::stream"],
    Cell[340999, 12717, 95, 3, 21, "Output",
      CellTags->"General::stream"]},
  "General::strmi"->{
    Cell[341155, 12727, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::strmi"],
    Cell[341239, 12730, 436, 11, 21, "Message",
      CellTags->"General::strmi"],
    Cell[341678, 12743, 631, 17, 78, "Notes",
      CellTags->"General::strmi"],
    Cell[342334, 12764, 64, 1, 38, "ExampleSection",
      CellTags->"General::strmi"],
    Cell[342401, 12767, 181, 5, 24, "Text",
      CellTags->"General::strmi"],
    Cell[342607, 12776, 115, 3, 26, "Input",
      CellTags->"General::strmi"],
    Cell[342725, 12781, 114, 3, 21, "Output",
      CellTags->"General::strmi"],
    Cell[342876, 12789, 156, 4, 26, "Input",
      CellTags->"General::strmi"],
    Cell[343035, 12795, 233, 5, 37, "Message",
      CellTags->"General::strmi"],
    Cell[343271, 12802, 183, 4, 21, "Message",
      CellTags->"General::strmi"],
    Cell[343469, 12809, 218, 6, 40, "Text",
      CellTags->"General::strmi"],
    Cell[343690, 12817, 132, 3, 26, "Input",
      CellTags->"General::strmi"],
    Cell[343825, 12822, 143, 3, 26, "Input",
      CellTags->"General::strmi"],
    Cell[343971, 12827, 83, 1, 24, "Text",
      CellTags->"General::strmi"],
    Cell[344057, 12830, 122, 3, 26, "Input",
      CellTags->"General::strmi"]},
  "General::strml"->{
    Cell[344228, 12839, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::strml"],
    Cell[344312, 12842, 455, 14, 21, "Message",
      CellTags->"General::strml"],
    Cell[344770, 12858, 306, 8, 40, "Notes",
      CellTags->"General::strml"],
    Cell[345101, 12870, 64, 1, 38, "ExampleSection",
      CellTags->"General::strml"],
    Cell[345168, 12873, 203, 5, 24, "Text",
      CellTags->"General::strml"],
    Cell[345396, 12882, 132, 3, 26, "Input",
      CellTags->"General::strml"],
    Cell[345531, 12887, 205, 5, 37, "Message",
      CellTags->"General::strml"],
    Cell[345739, 12894, 153, 4, 21, "Message",
      CellTags->"General::strml"],
    Cell[345907, 12901, 126, 5, 24, "Text",
      CellTags->"General::strml"],
    Cell[346036, 12908, 138, 3, 26, "Input",
      CellTags->"General::strml"],
    Cell[346177, 12913, 91, 1, 24, "Text",
      CellTags->"General::strml"],
    Cell[346271, 12916, 128, 3, 26, "Input",
      CellTags->"General::strml"]},
  "General::strmn"->{
    Cell[346448, 12925, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::strmn"],
    Cell[346532, 12928, 508, 14, 37, "Message",
      CellTags->"General::strmn"],
    Cell[347043, 12944, 1020, 30, 138, "Notes",
      CellTags->"General::strmn"],
    Cell[348088, 12978, 64, 1, 38, "ExampleSection",
      CellTags->"General::strmn"],
    Cell[348155, 12981, 200, 6, 24, "Text",
      CellTags->"General::strmn"],
    Cell[348380, 12991, 124, 3, 26, "Input",
      CellTags->"General::strmn"],
    Cell[348507, 12996, 113, 3, 21, "Output",
      CellTags->"General::strmn"],
    Cell[348657, 13004, 97, 3, 26, "Input",
      CellTags->"General::strmn"],
    Cell[348757, 13009, 92, 3, 21, "Output",
      CellTags->"General::strmn"],
    Cell[348864, 13015, 159, 4, 24, "Text",
      CellTags->"General::strmn"],
    Cell[349048, 13023, 143, 3, 26, "Input",
      CellTags->"General::strmn"],
    Cell[349194, 13028, 378, 7, 69, "Message",
      CellTags->"General::strmn"],
    Cell[349575, 13037, 190, 4, 21, "Message",
      CellTags->"General::strmn"],
    Cell[349768, 13043, 240, 5, 37, "Message",
      CellTags->"General::strmn"],
    Cell[350011, 13050, 95, 3, 21, "Output",
      CellTags->"General::strmn"],
    Cell[350121, 13056, 96, 1, 24, "Text",
      CellTags->"General::strmn"],
    Cell[350242, 13061, 111, 3, 26, "Input",
      CellTags->"General::strmn"],
    Cell[350356, 13066, 123, 3, 21, "Output",
      CellTags->"General::strmn"],
    Cell[350494, 13072, 63, 1, 24, "Text",
      CellTags->"General::strmn"],
    Cell[350582, 13077, 95, 3, 26, "Input",
      CellTags->"General::strmn"],
    Cell[350680, 13082, 94, 3, 21, "Output",
      CellTags->"General::strmn"]},
  "SetStreamPosition::stmrng"->{
    Cell[350835, 13092, 103, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[350941, 13095, 291, 6, 53, "Message",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[351235, 13103, 282, 6, 40, "Notes",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[351542, 13113, 75, 1, 38, "ExampleSection",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[351620, 13116, 235, 5, 40, "Text",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[351858, 13123, 155, 3, 26, "Input",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[352038, 13130, 119, 3, 26, "Input",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[352160, 13135, 109, 3, 21, "Output",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[352306, 13143, 331, 7, 90, "Input",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[352640, 13152, 340, 7, 69, "Message",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[352983, 13161, 219, 5, 21, "Print",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[353205, 13168, 109, 3, 21, "Output",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[353329, 13174, 113, 1, 24, "Text",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[353467, 13179, 329, 7, 90, "Input",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[353799, 13188, 217, 5, 21, "Print",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[354019, 13195, 109, 3, 21, "Output",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[354143, 13201, 78, 1, 24, "Text",
      CellTags->"SetStreamPosition::stmrng"],
    Cell[354224, 13204, 124, 3, 26, "Input",
      CellTags->"SetStreamPosition::stmrng"]},
  "$Language::notstr"->{
    Cell[354397, 13213, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$Language::notstr"],
    Cell[354487, 13216, 216, 5, 37, "Message",
      CellTags->"$Language::notstr"],
    Cell[354706, 13223, 303, 8, 46, "Notes",
      CellTags->"$Language::notstr"],
    Cell[355034, 13235, 67, 1, 38, "ExampleSection",
      CellTags->"$Language::notstr"],
    Cell[355104, 13238, 201, 7, 24, "Text",
      CellTags->"$Language::notstr"],
    Cell[355330, 13249, 106, 3, 26, "Input",
      CellTags->"$Language::notstr"],
    Cell[355439, 13254, 222, 5, 37, "Message",
      CellTags->"$Language::notstr"],
    Cell[355664, 13261, 95, 3, 21, "Output",
      CellTags->"$Language::notstr"]},
  "Import::guesshb"->{
    Cell[355820, 13271, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::guesshb"],
    Cell[355906, 13274, 217, 5, 37, "Message",
      CellTags->"Import::guesshb"],
    Cell[356126, 13281, 126, 4, 24, "Notes",
      CellTags->"Import::guesshb"]},
  "Import::mpsbv"->{
    Cell[356289, 13290, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::mpsbv"],
    Cell[356371, 13293, 206, 4, 37, "Message",
      CellTags->"Import::mpsbv"],
    Cell[356580, 13299, 124, 4, 24, "Notes",
      CellTags->"Import::mpsbv"]},
  "Import::mpsiv"->{
    Cell[356741, 13308, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::mpsiv"],
    Cell[356823, 13311, 207, 4, 37, "Message",
      CellTags->"Import::mpsiv"],
    Cell[357033, 13317, 124, 4, 24, "Notes",
      CellTags->"Import::mpsiv"]},
  "Import::mpsmr"->{
    Cell[357194, 13326, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Import::mpsmr"],
    Cell[357276, 13329, 254, 5, 37, "Message",
      CellTags->"Import::mpsmr"],
    Cell[357533, 13336, 124, 4, 24, "Notes",
      CellTags->"Import::mpsmr"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"$Language::noset", 358353, 13361},
  {"$BoxForms::formset", 359030, 13378},
  {"$CharacterEncoding::sjis", 359736, 13395},
  {"$CharacterEncoding::utf8", 360049, 13402},
  {"$CharacterEncoding::charcode", 360366, 13409},
  {"$CharacterEncoding::charfile", 361245, 13428},
  {"TableForm::wtfsp", 361564, 13435},
  {"Integrate::intnest", 362254, 13452},
  {"AccountingForm::expint", 363207, 13475},
  {"EngineeringForm::expint", 365577, 13531},
  {"NumberForm::expint", 367942, 13587},
  {"PaddedForm::expint", 370307, 13643},
  {"ScientificForm::expint", 372676, 13699},
  {"General::uniopen", 375039, 13755},
  {"General::uniclose", 375324, 13762},
  {"Integrate::nodiffd", 376099, 13781},
  {"AccountingForm::iprf", 377051, 13804},
  {"EngineeringForm::iprf", 379210, 13849},
  {"NumberForm::iprf", 381364, 13894},
  {"PaddedForm::iprf", 383518, 13939},
  {"ScientificForm::iprf", 385676, 13984},
  {"BaseForm::basf", 387828, 14029},
  {"ColumnForm::colmh", 388971, 14058},
  {"ColumnForm::colmv", 389922, 14081},
  {"Context::quote", 390870, 14104},
  {"Context::quote1", 391550, 14121},
  {"Derivative::novar", 392240, 14138},
  {"Format::forml", 393185, 14161},
  {"ToBoxForm::forml", 394827, 14194},
  {"Format::fttp", 396465, 14227},
  {"Format::lcont", 397579, 14256},
  {"Format::toobig", 397854, 14263},
  {"FormatType::ftype", 398768, 14286},
  {"General::estep", 400034, 14317},
  {"General::fmtval", 400950, 14340},
  {"General::ifexp", 402268, 14373},
  {"General::ifpa", 402547, 14380},
  {"General::npad", 403297, 14399},
  {"General::newl", 404200, 14422},
  {"General::nsgn", 405790, 14463},
  {"General::npt", 406692, 14486},
  {"General::nspr", 407582, 14509},
  {"General::sntue", 408484, 14532},
  {"General::sntup", 409394, 14555},
  {"General::sntx", 410303, 14578},
  {"General::sntxb", 411202, 14601},
  {"General::sntxc", 412033, 14622},
  {"General::sntxf", 412632, 14637},
  {"General::sntxi", 413231, 14652},
  {"General::sntxpi", 413831, 14667},
  {"General::sntxpr", 414753, 14690},
  {"General::sntxq", 415754, 14715},
  {"General::spell", 416353, 14730},
  {"General::spell1", 417349, 14755},
  {"General::ssle", 418034, 14772},
  {"General::tsntxi", 418936, 14795},
  {"HorizontalForm::precd", 419866, 14818},
  {"VerticalForm::precd", 420249, 14825},
  {"Infix::group", 420625, 14832},
  {"Postfix::group", 421936, 14855},
  {"Prefix::group", 423246, 14878},
  {"Integrate::intmul", 424560, 14901},
  {"Integrate::novar", 425521, 14924},
  {"Integrate::wrongd", 426469, 14947},
  {"General::dblk", 427424, 14970},
  {"NumberForm::sigz", 428338, 14993},
  {"ParentForm::deflt", 429043, 15010},
  {"Product::prodwarn", 430584, 15047},
  {"Short::short", 431537, 15070},
  {"Splice::splicd", 432438, 15093},
  {"Splice::splicf", 433520, 15120},
  {"Splice::splict", 434602, 15147},
  {"Splice::splicx", 435846, 15178},
  {"StringForm::sfr", 436928, 15205},
  {"Subscripted::subn", 437865, 15228},
  {"Subscripted::subv", 438824, 15251},
  {"Subscripted::subx", 439784, 15274},
  {"Sum::sumwarn", 440740, 15297},
  {"Syntax::noinfo", 441639, 15320},
  {"Syntax::snthex", 442562, 15343},
  {"Syntax::sntoct1", 443565, 15368},
  {"Syntax::sntoct2", 444580, 15393},
  {"Syntax::sntufn", 445594, 15418},
  {"Syntax::sntunc", 446596, 15443},
  {"Syntax::syntyp", 447516, 15466},
  {"TableForm::tfal", 448521, 15491},
  {"TableForm::tfdir", 449459, 15514},
  {"TableForm::tfh", 450407, 15537},
  {"TableForm::tfsp", 451576, 15566},
  {"TeXForm::texalign", 452516, 15589},
  {"TeXForm::texstyle", 452810, 15596},
  {"TeXForm::texval", 453101, 15603},
  {"ToExpression::esntx", 453390, 15610},
  {"ToExpression::esntxb", 454460, 15635},
  {"ToExpression::esntxf", 454765, 15642},
  {"ToExpression::esntxi", 455071, 15649},
  {"ToString::notype", 455373, 15656},
  {"General::base", 455659, 15663},
  {"General::bktfn", 456490, 15684},
  {"General::bktmch", 457098, 15699},
  {"General::bktmcp", 457712, 15714},
  {"General::bktmop", 458729, 15739},
  {"General::bktwrn", 459746, 15764},
  {"General::bktx", 460441, 15781},
  {"General::continfo", 461043, 15796},
  {"General::digit", 461667, 15811},
  {"General::existinfo", 462512, 15832},
  {"General::incomma", 463145, 15847},
  {"General::intinfo", 463765, 15862},
  {"General::partialinfo", 464389, 15877},
  {"General::strbox", 465035, 15892},
  {"General::uinfix", 465647, 15907},
  {"General::uprefix", 466259, 15922},
  {"General::upreinfix", 466880, 15937},
  {"General::suminfo", 467513, 15952},
  {"Export::chtype", 468130, 15967},
  {"Import::chtype", 468745, 15980},
  {"Experimental`BinaryExport::chtype", 469379, 15993},
  {"Experimental`BinaryImport::chtype", 470013, 16006},
  {"Export::coerce", 470628, 16019},
  {"Export::dffsr", 471469, 16040},
  {"Export::bitcon", 471748, 16047},
  {"Export::bitrange", 472032, 16054},
  {"Export::bitval", 472320, 16061},
  {"Export::errfile", 472602, 16068},
  {"Import::errfile", 472952, 16075},
  {"Export::errstruct", 473304, 16082},
  {"Import::errstruct", 473668, 16089},
  {"Export::obs", 474026, 16096},
  {"Import::obs", 474348, 16103},
  {"Export::obsalt", 474673, 16110},
  {"Import::obsalt", 475016, 16117},
  {"Export::no2dgr", 475359, 16124},
  {"Export::nocomp", 475641, 16131},
  {"Export::nodir", 475922, 16138},
  {"Export::autofix", 476201, 16145},
  {"Export::badqte", 476485, 16152},
  {"Export::malsxml", 476768, 16159},
  {"Export::unrecov", 477054, 16166},
  {"Export::xmlmal", 477338, 16173},
  {"Export::xmlnopt", 477620, 16180},
  {"Export::fmterr", 477905, 16187},
  {"Import::fmterr", 479147, 16212},
  {"Export::format", 480389, 16237},
  {"ExportString::format", 484310, 16315},
  {"Import::format", 488225, 16393},
  {"ImportString::format", 492146, 16471},
  {"Experimental`BinaryExport::format", 496080, 16549},
  {"Experimental`BinaryExportString::format", 500020, 16627},
  {"Experimental`BinaryImport::format", 503954, 16705},
  {"Experimental`BinaryImportString::format", 507894, 16783},
  {"Export::guess", 511808, 16861},
  {"Import::guess", 513414, 16894},
  {"Export::ignore", 515021, 16927},
  {"Experimental`BinaryExport::ignore", 515440, 16934},
  {"Export::memavail", 515842, 16941},
  {"Import::memavail", 516131, 16948},
  {"Export::nofe", 516416, 16955},
  {"Export::nomatch", 516693, 16962},
  {"Export::type", 516976, 16969},
  {"Export::unsupfmt", 518030, 16996},
  {"Import::unsupfmt", 518387, 17003},
  {"Export::createdir", 518745, 17010},
  {"Get::notencode", 519035, 17017},
  {"Import::fnfnd", 520034, 17042},
  {"Import::imgsze", 520312, 17049},
  {"Import::intp", 520591, 17056},
  {"Import::nffil", 520865, 17063},
  {"Import::nlist", 521143, 17070},
  {"Import::nlist2", 521421, 17077},
  {"ImportString::string", 521708, 17084},
  {"Import::nodta", 522695, 17107},
  {"Import::unsup", 522972, 17114},
  {"$NumberMarks::nmarkset", 523258, 17121},
  {"Integrate::diffend", 524014, 17138},
  {"ToExpression::notstrbox", 524990, 17161},
  {"Syntax::com", 526009, 17184},
  {"Experimental`BinaryExport::coerce", 526917, 17207},
  {"Experimental`BinaryExport::nomatch", 527276, 17214},
  {"Experimental`BinaryImport::nffil", 527636, 17221},
  {"Import::dxfemp", 527972, 17228},
  {"Import::dxfflg", 528253, 17235},
  {"Import::dxflin", 528534, 17242},
  {"Import::dxfply", 528815, 17249},
  {"Import::dxfvbf", 529096, 17256},
  {"Import::nonintyear", 529381, 17263},
  {"Import::costr", 529674, 17270},
  {"Import::malxml", 529952, 17277},
  {"Import::pdtder", 530233, 17284},
  {"Import::unrecxml", 530516, 17291},
  {"MathMLForm::boxfmt", 530807, 17298},
  {"Experimental`RegisterConverter::extensions", 531128, 17305},
  {"Experimental`RegisterConverter::mode", 531516, 17312},
  {"Experimental`RegisterConverter::noexe", 531887, 17319},
  {"Experimental`RegisterConverter::source", 532262, 17326},
  {"General::boxfmt", 532617, 17333},
  {"General::byteord", 533792, 17362},
  {"General::conopt", 534080, 17369},
  {"General::interpfmt", 534368, 17376},
  {"General::notstr", 534662, 17383},
  {"MessageName::messg", 535838, 17412},
  {"Get::enkey", 536475, 17427},
  {"Save::wtype", 536745, 17434},
  {"Close::spfile", 537414, 17451},
  {"DumpGet::bgbf", 538099, 17468},
  {"DumpGet::bgchk", 539335, 17499},
  {"DumpGet::bgcor", 539620, 17506},
  {"DumpGet::bgnew", 539905, 17513},
  {"DumpGet::bgold", 540189, 17520},
  {"DumpGet::valwarn", 540475, 17527},
  {"DumpSave::bschk", 540767, 17534},
  {"DumpSave::bsnosym", 541057, 17541},
  {"DumpSave::bsstm", 541776, 17558},
  {"DumpSave::outref", 542065, 17565},
  {"Get::path", 542770, 17582},
  {"Information::basic", 543505, 17601},
  {"Information::nomatch", 544150, 17616},
  {"Information::notfound1", 545073, 17637},
  {"Information::opt", 545383, 17644},
  {"Message::msgl", 545672, 17651},
  {"Message::name", 546438, 17670},
  {"Needs::nocont", 547361, 17693},
  {"On::none", 548124, 17712},
  {"Read::readf", 548691, 17727},
  {"ReadList::readf", 549992, 17750},
  {"Skip::readf", 551289, 17773},
  {"Read::readn", 552586, 17796},
  {"ReadList::readn", 554679, 17833},
  {"Skip::readn", 556768, 17870},
  {"Read::readt", 558857, 17907},
  {"ReadList::readt", 560157, 17930},
  {"Skip::readt", 561453, 17953},
  {"Read::readx", 562749, 17976},
  {"ReadList::readx", 564049, 17999},
  {"Skip::readx", 565345, 18022},
  {"SetStreamPosition::sbuf", 566653, 18045},
  {"StringForm::sfq", 567690, 18068},
  {"General::aofil", 568635, 18091},
  {"General::filro", 569812, 18120},
  {"General::ioarg", 570097, 18127},
  {"General::ioerr", 570382, 18134},
  {"General::isdir", 570667, 18141},
  {"General::noopen", 570952, 18148},
  {"General::notfound", 572145, 18177},
  {"General::openr", 573026, 18198},
  {"General::openw", 574118, 18225},
  {"General::openx", 575209, 18252},
  {"General::readp", 576145, 18275},
  {"General::remote", 576921, 18294},
  {"General::stmtype", 577212, 18301},
  {"General::stop", 577502, 18308},
  {"General::stream", 578669, 18337},
  {"General::strmi", 579694, 18362},
  {"General::strml", 580949, 18393},
  {"General::strmn", 581962, 18418},
  {"SetStreamPosition::stmrng", 583709, 18461},
  {"$Language::notstr", 585404, 18498},
  {"Import::guesshb", 586122, 18515},
  {"Import::mpsbv", 586408, 18522},
  {"Import::mpsiv", 586688, 18529},
  {"Import::mpsmr", 586968, 18536}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 33, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1834, 57, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$Language::noset"],
Cell[1922, 60, 592, 13, 33, "Message",
  CellTags->"$Language::noset"],
Cell[2517, 75, 287, 8, 38, "Notes",
  CellTags->"$Language::noset"],

Cell[CellGroupData[{
Cell[2829, 87, 66, 1, 38, "ExampleSection",
  CellTags->"$Language::noset"],
Cell[2898, 90, 213, 8, 24, "Text",
  CellTags->"$Language::noset"],

Cell[CellGroupData[{
Cell[3136, 102, 112, 3, 26, "Input",
  CellTags->"$Language::noset"],
Cell[3251, 107, 286, 6, 47, "Message",
  CellTags->"$Language::noset"],
Cell[3540, 115, 97, 3, 25, "Output",
  CellTags->"$Language::noset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[3698, 125, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$BoxForms::formset"],
Cell[3790, 128, 430, 12, 33, "Message",
  CellTags->"$BoxForms::formset"],
Cell[4223, 142, 293, 9, 38, "Notes",
  CellTags->"$BoxForms::formset"],

Cell[CellGroupData[{
Cell[4541, 155, 68, 1, 38, "ExampleSection",
  CellTags->"$BoxForms::formset"],
Cell[4612, 158, 383, 11, 52, "Text",
  CellTags->"$BoxForms::formset"],

Cell[CellGroupData[{
Cell[5020, 173, 117, 3, 26, "Input",
  CellTags->"$BoxForms::formset"],
Cell[5140, 178, 267, 5, 33, "Message",
  CellTags->"$BoxForms::formset"],
Cell[5410, 185, 106, 3, 25, "Output",
  CellTags->"$BoxForms::formset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5577, 195, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$CharacterEncoding::sjis"],
Cell[5681, 198, 259, 4, 33, "Message",
  CellTags->"$CharacterEncoding::sjis"],
Cell[5943, 204, 135, 4, 22, "Notes",
  CellTags->"$CharacterEncoding::sjis"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6115, 213, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$CharacterEncoding::utf8"],
Cell[6219, 216, 256, 4, 47, "Message",
  CellTags->"$CharacterEncoding::utf8"],
Cell[6478, 222, 135, 4, 22, "Notes",
  CellTags->"$CharacterEncoding::utf8"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6650, 231, 109, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$CharacterEncoding::charcode"],
Cell[6762, 234, 276, 5, 47, "Message",
  CellTags->"$CharacterEncoding::charcode"],
Cell[7041, 241, 246, 5, 37, "Notes",
  CellTags->"$CharacterEncoding::charcode"],

Cell[CellGroupData[{
Cell[7312, 250, 78, 1, 38, "ExampleSection",
  CellTags->"$CharacterEncoding::charcode"],
Cell[7393, 253, 222, 7, 23, "Text",
  CellTags->"$CharacterEncoding::charcode"],

Cell[CellGroupData[{
Cell[7640, 264, 128, 3, 26, "Input",
  CellTags->"$CharacterEncoding::charcode"],
Cell[7771, 269, 284, 5, 47, "Message",
  CellTags->"$CharacterEncoding::charcode"],
Cell[8058, 276, 108, 3, 25, "Output",
  CellTags->"$CharacterEncoding::charcode"]
}, Open  ]],
Cell[8181, 282, 354, 10, 39, "Text",
  CellTags->"$CharacterEncoding::charcode"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8584, 298, 109, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$CharacterEncoding::charfile"],
Cell[8696, 301, 272, 5, 53, "Message",
  CellTags->"$CharacterEncoding::charfile"],
Cell[8971, 308, 751, 15, 116, "Notes",
  CellTags->"$CharacterEncoding::charfile"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9759, 328, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"TableForm::wtfsp"],
Cell[9847, 331, 242, 5, 37, "Message",
  CellTags->"TableForm::wtfsp"],
Cell[10092, 338, 404, 10, 62, "Notes",
  CellTags->"TableForm::wtfsp"],

Cell[CellGroupData[{
Cell[10521, 352, 66, 1, 38, "ExampleSection",
  CellTags->"TableForm::wtfsp"],
Cell[10590, 355, 181, 5, 24, "Text",
  CellTags->"TableForm::wtfsp"],

Cell[CellGroupData[{
Cell[10796, 364, 145, 3, 26, "Input",
  CellTags->"TableForm::wtfsp"],
Cell[10944, 369, 236, 5, 37, "Message",
  CellTags->"TableForm::wtfsp"],
Cell[11183, 376, 378, 12, 41, "Output",
  CellTags->"TableForm::wtfsp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11622, 395, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Integrate::intnest"],
Cell[11714, 398, 268, 5, 53, "Message",
  CellTags->"Integrate::intnest"],
Cell[11985, 405, 518, 9, 84, "Notes",
  CellTags->"Integrate::intnest"],

Cell[CellGroupData[{
Cell[12528, 418, 68, 1, 38, "ExampleSection",
  CellTags->"Integrate::intnest"],
Cell[12599, 421, 227, 5, 40, "Text",
  CellTags->"Integrate::intnest"],

Cell[CellGroupData[{
Cell[12851, 430, 139, 3, 40, "Input",
  CellTags->"Integrate::intnest"],
Cell[12993, 435, 347, 6, 69, "Message",
  CellTags->"Integrate::intnest"],
Cell[13343, 443, 207, 5, 35, "Message",
  CellTags->"Integrate::intnest"]
}, Open  ]],
Cell[13565, 451, 152, 4, 24, "Text",
  CellTags->"Integrate::intnest"],

Cell[CellGroupData[{
Cell[13742, 459, 156, 4, 40, "Input",
  CellTags->"Integrate::intnest"],
Cell[13901, 465, 99, 3, 39, "Output",
  CellTags->"Integrate::intnest"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14061, 475, 297, 9, 111, "ObjectNameWarningMessages",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],
Cell[14361, 486, 661, 14, 37, "Message",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],
Cell[15025, 502, 838, 18, 100, "Notes",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],

Cell[CellGroupData[{
Cell[15888, 524, 179, 3, 38, "ExampleSection",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],
Cell[16070, 529, 415, 12, 40, "Text",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],

Cell[CellGroupData[{
Cell[16510, 545, 254, 5, 26, "Input",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],
Cell[16767, 552, 392, 8, 53, "Message",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],
Cell[17162, 562, 382, 9, 35, "Output",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}]
}, Open  ]],
Cell[17559, 574, 440, 11, 40, "Text",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],

Cell[CellGroupData[{
Cell[18024, 589, 275, 6, 26, "Input",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}],
Cell[18302, 597, 382, 9, 33, "Output",
  CellTags->{
  "AccountingForm::expint", "EngineeringForm::expint", "NumberForm::expint", 
    "PaddedForm::expint", "ScientificForm::expint"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18745, 613, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::uniopen"],
Cell[18833, 616, 374, 11, 21, "Message",
  CellTags->"General::uniopen"],
Cell[19210, 629, 392, 9, 62, "Notes",
  CellTags->"General::uniopen"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19639, 643, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::uniclose"],
Cell[19729, 646, 375, 11, 21, "Message",
  CellTags->"General::uniclose"],
Cell[20107, 659, 394, 9, 62, "Notes",
  CellTags->"General::uniclose"],

Cell[CellGroupData[{
Cell[20526, 672, 67, 1, 38, "ExampleSection",
  CellTags->"General::uniclose"],
Cell[20596, 675, 93, 1, 24, "Text",
  CellTags->"General::uniclose"],

Cell[CellGroupData[{
Cell[20714, 680, 116, 3, 26, "Input",
  CellTags->"General::uniclose"],
Cell[20833, 685, 173, 4, 21, "Print",
  CellTags->"General::uniclose"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21043, 694, 130, 3, 26, "Input",
  CellTags->"General::uniclose"],
Cell[21176, 699, 173, 4, 21, "Print",
  CellTags->"General::uniclose"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21410, 710, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Integrate::nodiffd"],
Cell[21502, 713, 317, 6, 68, "Message",
  CellTags->"Integrate::nodiffd"],
Cell[21822, 721, 626, 11, 100, "Notes",
  CellTags->"Integrate::nodiffd"],

Cell[CellGroupData[{
Cell[22473, 736, 68, 1, 38, "ExampleSection",
  CellTags->"Integrate::nodiffd"],
Cell[22544, 739, 229, 5, 40, "Text",
  CellTags->"Integrate::nodiffd"],

Cell[CellGroupData[{
Cell[22798, 748, 103, 3, 40, "Input",
  CellTags->"Integrate::nodiffd"],
Cell[22904, 753, 305, 5, 85, "Message",
  CellTags->"Integrate::nodiffd"],
Cell[23212, 760, 142, 4, 35, "Message",
  CellTags->"Integrate::nodiffd"]
}, Open  ]],
Cell[23369, 767, 90, 1, 24, "Text",
  CellTags->"Integrate::nodiffd"],

Cell[CellGroupData[{
Cell[23484, 772, 122, 3, 40, "Input",
  CellTags->"Integrate::nodiffd"],
Cell[23609, 777, 99, 3, 39, "Output",
  CellTags->"Integrate::nodiffd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[23769, 787, 277, 9, 111, "ObjectNameWarningMessages",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],
Cell[24049, 798, 589, 14, 37, "Message",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],
Cell[24641, 814, 843, 20, 116, "Notes",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],

Cell[CellGroupData[{
Cell[25509, 838, 169, 3, 38, "ExampleSection",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],
Cell[25681, 843, 315, 9, 24, "Text",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],

Cell[CellGroupData[{
Cell[26021, 856, 262, 6, 26, "Input",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],
Cell[26286, 864, 340, 7, 33, "Message",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],
Cell[26629, 873, 595, 16, 84, "Output",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}]
}, Open  ]],
Cell[27239, 892, 264, 7, 23, "Text",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],

Cell[CellGroupData[{
Cell[27528, 903, 267, 6, 26, "Input",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}],
Cell[27798, 911, 621, 16, 84, "Output",
  CellTags->{
  "AccountingForm::iprf", "EngineeringForm::iprf", "NumberForm::iprf", 
    "PaddedForm::iprf", "ScientificForm::iprf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[28480, 934, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"BaseForm::basf"],
Cell[28564, 937, 375, 11, 19, "Message",
  CellTags->"BaseForm::basf"],
Cell[28942, 950, 541, 12, 77, "Notes",
  CellTags->"BaseForm::basf"],

Cell[CellGroupData[{
Cell[29508, 966, 64, 1, 38, "ExampleSection",
  CellTags->"BaseForm::basf"],
Cell[29575, 969, 202, 5, 37, "Text",
  CellTags->"BaseForm::basf"],

Cell[CellGroupData[{
Cell[29802, 978, 110, 3, 26, "Input",
  CellTags->"BaseForm::basf"],
Cell[29915, 983, 203, 5, 19, "Message",
  CellTags->"BaseForm::basf"],
Cell[30121, 990, 120, 3, 37, "Output",
  CellTags->"BaseForm::basf"]
}, Open  ]],
Cell[30256, 996, 127, 5, 23, "Text",
  CellTags->"BaseForm::basf"],

Cell[CellGroupData[{
Cell[30408, 1005, 127, 3, 26, "Input",
  CellTags->"BaseForm::basf"],
Cell[30538, 1010, 541, 15, 37, "Output",
  CellTags->"BaseForm::basf"]
}, Open  ]],
Cell[31094, 1028, 207, 7, 23, "Text",
  CellTags->"BaseForm::basf"],

Cell[CellGroupData[{
Cell[31326, 1039, 110, 3, 26, "Input",
  CellTags->"BaseForm::basf"],
Cell[31439, 1044, 127, 3, 25, "Output",
  CellTags->"BaseForm::basf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[31627, 1054, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ColumnForm::colmh"],
Cell[31717, 1057, 295, 6, 37, "Message",
  CellTags->"ColumnForm::colmh"],
Cell[32015, 1065, 299, 11, 24, "Notes",
  CellTags->"ColumnForm::colmh"],

Cell[CellGroupData[{
Cell[32339, 1080, 67, 1, 38, "ExampleSection",
  CellTags->"ColumnForm::colmh"],
Cell[32409, 1083, 182, 5, 24, "Text",
  CellTags->"ColumnForm::colmh"],

Cell[CellGroupData[{
Cell[32616, 1092, 128, 3, 26, "Input",
  CellTags->"ColumnForm::colmh"],
Cell[32747, 1097, 219, 5, 37, "Message",
  CellTags->"ColumnForm::colmh"],
Cell[32969, 1104, 336, 11, 52, "Output",
  CellTags->"ColumnForm::colmh"]
}, Open  ]],
Cell[33320, 1118, 156, 5, 24, "Text",
  CellTags->"ColumnForm::colmh"],

Cell[CellGroupData[{
Cell[33501, 1127, 130, 3, 26, "Input",
  CellTags->"ColumnForm::colmh"],
Cell[33634, 1132, 339, 11, 52, "Output",
  CellTags->"ColumnForm::colmh"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[34034, 1150, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ColumnForm::colmv"],
Cell[34124, 1153, 294, 6, 37, "Message",
  CellTags->"ColumnForm::colmv"],
Cell[34421, 1161, 299, 11, 24, "Notes",
  CellTags->"ColumnForm::colmv"],

Cell[CellGroupData[{
Cell[34745, 1176, 67, 1, 38, "ExampleSection",
  CellTags->"ColumnForm::colmv"],
Cell[34815, 1179, 192, 5, 24, "Text",
  CellTags->"ColumnForm::colmv"],

Cell[CellGroupData[{
Cell[35032, 1188, 136, 3, 26, "Input",
  CellTags->"ColumnForm::colmv"],
Cell[35171, 1193, 219, 5, 37, "Message",
  CellTags->"ColumnForm::colmv"],
Cell[35393, 1200, 335, 11, 50, "Output",
  CellTags->"ColumnForm::colmv"]
}, Open  ]],
Cell[35743, 1214, 134, 5, 24, "Text",
  CellTags->"ColumnForm::colmv"],

Cell[CellGroupData[{
Cell[35902, 1223, 138, 3, 26, "Input",
  CellTags->"ColumnForm::colmv"],
Cell[36043, 1228, 335, 11, 50, "Output",
  CellTags->"ColumnForm::colmv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36439, 1246, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Context::quote"],
Cell[36523, 1249, 546, 13, 37, "Message",
  CellTags->"Context::quote"],
Cell[37072, 1264, 289, 7, 46, "Notes",
  CellTags->"Context::quote"],

Cell[CellGroupData[{
Cell[37386, 1275, 64, 1, 38, "ExampleSection",
  CellTags->"Context::quote"],
Cell[37453, 1278, 203, 6, 24, "Text",
  CellTags->"Context::quote"],

Cell[CellGroupData[{
Cell[37681, 1288, 81, 2, 28, "Input",
  CellTags->"Context::quote"],
Cell[37765, 1292, 276, 6, 53, "Message",
  CellTags->"Context::quote"],
Cell[38044, 1300, 135, 2, 21, "Message",
  CellTags->"Context::quote"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[38240, 1309, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Context::quote1"],
Cell[38326, 1312, 628, 14, 37, "Message",
  CellTags->"Context::quote1"],
Cell[38957, 1328, 291, 7, 46, "Notes",
  CellTags->"Context::quote1"],

Cell[CellGroupData[{
Cell[39273, 1339, 65, 1, 38, "ExampleSection",
  CellTags->"Context::quote1"],
Cell[39341, 1342, 204, 6, 24, "Text",
  CellTags->"Context::quote1"],

Cell[CellGroupData[{
Cell[39570, 1352, 85, 2, 28, "Input",
  CellTags->"Context::quote1"],
Cell[39658, 1356, 310, 6, 69, "Message",
  CellTags->"Context::quote1"],
Cell[39971, 1364, 139, 2, 21, "Message",
  CellTags->"Context::quote1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40171, 1373, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Derivative::novar"],
Cell[40261, 1376, 239, 5, 37, "Message",
  CellTags->"Derivative::novar"],
Cell[40503, 1383, 473, 10, 62, "Notes",
  CellTags->"Derivative::novar"],

Cell[CellGroupData[{
Cell[41001, 1397, 67, 1, 38, "ExampleSection",
  CellTags->"Derivative::novar"],
Cell[41071, 1400, 162, 4, 24, "Text",
  CellTags->"Derivative::novar"],

Cell[CellGroupData[{
Cell[41258, 1408, 111, 3, 26, "Input",
  CellTags->"Derivative::novar"],
Cell[41372, 1413, 265, 5, 37, "Message",
  CellTags->"Derivative::novar"],
Cell[41640, 1420, 179, 5, 21, "Message",
  CellTags->"Derivative::novar"]
}, Open  ]],
Cell[41834, 1428, 124, 4, 24, "Text",
  CellTags->"Derivative::novar"],

Cell[CellGroupData[{
Cell[41983, 1436, 114, 3, 26, "Input",
  CellTags->"Derivative::novar"],
Cell[42100, 1441, 92, 3, 21, "Output",
  CellTags->"Derivative::novar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[42253, 1451, 126, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],
Cell[42382, 1457, 303, 8, 37, "Message",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],
Cell[42688, 1467, 417, 8, 78, "Notes",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[CellGroupData[{
Cell[43130, 1479, 85, 1, 38, "ExampleSection",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],
Cell[43218, 1482, 206, 4, 40, "Text",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[CellGroupData[{
Cell[43449, 1490, 138, 3, 26, "Input",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],
Cell[43590, 1495, 262, 5, 37, "Message",
  CellTags->{"Format::forml", "ToBoxForm::forml"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[43889, 1505, 127, 3, 26, "Input",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],
Cell[44019, 1510, 229, 5, 37, "Message",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],
Cell[44251, 1517, 157, 6, 31, "Output",
  CellTags->{"Format::forml", "ToBoxForm::forml"}]
}, Open  ]],
Cell[44423, 1526, 148, 4, 24, "Text",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],
Cell[44574, 1532, 144, 3, 26, "Input",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],

Cell[CellGroupData[{
Cell[44743, 1539, 127, 3, 26, "Input",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],
Cell[44873, 1544, 157, 6, 31, "Output",
  CellTags->{"Format::forml", "ToBoxForm::forml"}]
}, Open  ]],
Cell[45045, 1553, 147, 5, 24, "Text",
  CellTags->{"Format::forml", "ToBoxForm::forml"}],
Cell[45195, 1560, 128, 3, 26, "Input",
  CellTags->{"Format::forml", "ToBoxForm::forml"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[45372, 1569, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Format::fttp"],
Cell[45452, 1572, 228, 5, 21, "Message",
  CellTags->"Format::fttp"],
Cell[45683, 1579, 308, 7, 46, "Notes",
  CellTags->"Format::fttp"],

Cell[CellGroupData[{
Cell[46016, 1590, 62, 1, 38, "ExampleSection",
  CellTags->"Format::fttp"],
Cell[46081, 1593, 202, 5, 40, "Text",
  CellTags->"Format::fttp"],

Cell[CellGroupData[{
Cell[46308, 1602, 128, 3, 26, "Input",
  CellTags->"Format::fttp"],
Cell[46439, 1607, 175, 4, 21, "Message",
  CellTags->"Format::fttp"],
Cell[46617, 1613, 93, 3, 21, "Output",
  CellTags->"Format::fttp"]
}, Open  ]],
Cell[46725, 1619, 100, 1, 24, "Text",
  CellTags->"Format::fttp"],
Cell[46828, 1622, 128, 3, 26, "Input",
  CellTags->"Format::fttp"],

Cell[CellGroupData[{
Cell[46981, 1629, 105, 3, 26, "Input",
  CellTags->"Format::fttp"],
Cell[47089, 1634, 92, 2, 35, "Output",
  CellTags->"Format::fttp"]
}, Open  ]],
Cell[47196, 1639, 124, 5, 24, "Text",
  CellTags->"Format::fttp"],
Cell[47323, 1646, 118, 3, 26, "Input",
  CellTags->"Format::fttp"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47490, 1655, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Format::lcont"],
Cell[47572, 1658, 159, 3, 21, "Message",
  CellTags->"Format::lcont"],
Cell[47734, 1663, 462, 9, 68, "Notes",
  CellTags->"Format::lcont"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48233, 1677, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Format::toobig"],
Cell[48317, 1680, 150, 3, 21, "Message",
  CellTags->"Format::toobig"],
Cell[48470, 1685, 414, 8, 68, "Notes",
  CellTags->"Format::toobig"],

Cell[CellGroupData[{
Cell[48909, 1697, 64, 1, 38, "ExampleSection",
  CellTags->"Format::toobig"],
Cell[48976, 1700, 225, 5, 40, "Text",
  CellTags->"Format::toobig"],

Cell[CellGroupData[{
Cell[49226, 1709, 123, 3, 26, "Input",
  CellTags->"Format::toobig"],
Cell[49352, 1714, 166, 4, 21, "Message",
  CellTags->"Format::toobig"],
Cell[49521, 1720, 100, 3, 21, "Output",
  CellTags->"Format::toobig"]
}, Open  ]],
Cell[49636, 1726, 162, 4, 24, "Text",
  CellTags->"Format::toobig"],

Cell[CellGroupData[{
Cell[49823, 1734, 124, 3, 26, "Input",
  CellTags->"Format::toobig"],
Cell[49950, 1739, 97, 3, 21, "Output",
  CellTags->"Format::toobig"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[50108, 1749, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FormatType::ftype"],
Cell[50198, 1752, 259, 5, 21, "Message",
  CellTags->"FormatType::ftype"],
Cell[50460, 1759, 261, 7, 40, "Notes",
  CellTags->"FormatType::ftype"],

Cell[CellGroupData[{
Cell[50746, 1770, 67, 1, 38, "ExampleSection",
  CellTags->"FormatType::ftype"],
Cell[50816, 1773, 254, 7, 40, "Text",
  CellTags->"FormatType::ftype"],

Cell[CellGroupData[{
Cell[51095, 1784, 174, 4, 42, "Input",
  CellTags->"FormatType::ftype"],
Cell[51272, 1790, 199, 5, 21, "Message",
  CellTags->"FormatType::ftype"],
Cell[51474, 1797, 97, 3, 21, "Output",
  CellTags->"FormatType::ftype"]
}, Open  ]],

Cell[CellGroupData[{
Cell[51608, 1805, 101, 3, 26, "Input",
  CellTags->"FormatType::ftype"],
Cell[51712, 1810, 203, 4, 37, "Output",
  CellTags->"FormatType::ftype"]
}, Open  ]],
Cell[51930, 1817, 144, 5, 24, "Text",
  CellTags->"FormatType::ftype"],

Cell[CellGroupData[{
Cell[52099, 1826, 174, 4, 42, "Input",
  CellTags->"FormatType::ftype"],
Cell[52276, 1832, 97, 3, 21, "Output",
  CellTags->"FormatType::ftype"]
}, Open  ]],
Cell[52388, 1838, 70, 1, 24, "Text",
  CellTags->"FormatType::ftype"],
Cell[52461, 1841, 112, 3, 26, "Input",
  CellTags->"FormatType::ftype"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52622, 1850, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::estep"],
Cell[52706, 1853, 500, 15, 21, "Message",
  CellTags->"General::estep"],
Cell[53209, 1870, 202, 5, 24, "Notes",
  CellTags->"General::estep"],

Cell[CellGroupData[{
Cell[53436, 1879, 64, 1, 38, "ExampleSection",
  CellTags->"General::estep"],
Cell[53503, 1882, 211, 5, 40, "Text",
  CellTags->"General::estep"],

Cell[CellGroupData[{
Cell[53739, 1891, 155, 4, 26, "Input",
  CellTags->"General::estep"],
Cell[53897, 1897, 218, 5, 37, "Message",
  CellTags->"General::estep"],
Cell[54118, 1904, 547, 15, 35, "Output",
  CellTags->"General::estep"]
}, Open  ]],
Cell[54680, 1922, 143, 5, 24, "Text",
  CellTags->"General::estep"],

Cell[CellGroupData[{
Cell[54848, 1931, 148, 4, 26, "Input",
  CellTags->"General::estep"],
Cell[54999, 1937, 548, 15, 35, "Output",
  CellTags->"General::estep"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[55608, 1959, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::fmtval"],
Cell[55694, 1962, 375, 11, 21, "Message",
  CellTags->"General::fmtval"],
Cell[56072, 1975, 599, 18, 84, "Notes",
  CellTags->"General::fmtval"],

Cell[CellGroupData[{
Cell[56696, 1997, 65, 1, 38, "ExampleSection",
  CellTags->"General::fmtval"],
Cell[56764, 2000, 197, 5, 24, "Text",
  CellTags->"General::fmtval"],

Cell[CellGroupData[{
Cell[56986, 2009, 129, 3, 26, "Input",
  CellTags->"General::fmtval"],
Cell[57118, 2014, 180, 4, 21, "Message",
  CellTags->"General::fmtval"],
Cell[57301, 2020, 136, 3, 23, "Output",
  CellTags->"General::fmtval"]
}, Open  ]],
Cell[57452, 2026, 142, 5, 24, "Text",
  CellTags->"General::fmtval"],

Cell[CellGroupData[{
Cell[57619, 2035, 133, 3, 26, "Input",
  CellTags->"General::fmtval"],
Cell[57755, 2040, 98, 3, 21, "Output",
  CellTags->"General::fmtval"]
}, Open  ]],
Cell[57868, 2046, 261, 9, 40, "Text",
  CellTags->"General::fmtval"],

Cell[CellGroupData[{
Cell[58154, 2059, 99, 3, 26, "Input",
  CellTags->"General::fmtval"],
Cell[58256, 2064, 201, 4, 37, "Output",
  CellTags->"General::fmtval"]
}, Open  ]],

Cell[CellGroupData[{
Cell[58494, 2073, 97, 3, 26, "Input",
  CellTags->"General::fmtval"],
Cell[58594, 2078, 120, 3, 21, "Output",
  CellTags->"General::fmtval"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[58775, 2088, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ifexp"],
Cell[58859, 2091, 368, 11, 21, "Message",
  CellTags->"General::ifexp"],
Cell[59230, 2104, 585, 17, 62, "Notes",
  CellTags->"General::ifexp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[59852, 2126, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ifpa"],
Cell[59934, 2129, 442, 11, 37, "Message",
  CellTags->"General::ifpa"],
Cell[60379, 2142, 542, 18, 40, "Notes",
  CellTags->"General::ifpa"],

Cell[CellGroupData[{
Cell[60946, 2164, 63, 1, 38, "ExampleSection",
  CellTags->"General::ifpa"],
Cell[61012, 2167, 216, 5, 40, "Text",
  CellTags->"General::ifpa"],

Cell[CellGroupData[{
Cell[61253, 2176, 466, 8, 122, "Input",
  CellTags->"General::ifpa"],
Cell[61722, 2186, 297, 6, 69, "Message",
  CellTags->"General::ifpa"],
Cell[62022, 2194, 202, 7, 51, "Message",
  CellTags->"General::ifpa"],
Cell[62227, 2203, 94, 3, 21, "Output",
  CellTags->"General::ifpa"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[62382, 2213, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::npad"],
Cell[62464, 2216, 515, 15, 37, "Message",
  CellTags->"General::npad"],
Cell[62982, 2233, 201, 5, 24, "Notes",
  CellTags->"General::npad"],

Cell[CellGroupData[{
Cell[63208, 2242, 63, 1, 38, "ExampleSection",
  CellTags->"General::npad"],
Cell[63274, 2245, 202, 5, 40, "Text",
  CellTags->"General::npad"],

Cell[CellGroupData[{
Cell[63501, 2254, 167, 4, 42, "Input",
  CellTags->"General::npad"],
Cell[63671, 2260, 226, 5, 37, "Message",
  CellTags->"General::npad"],
Cell[63900, 2267, 476, 13, 64, "Output",
  CellTags->"General::npad"]
}, Open  ]],
Cell[64391, 2283, 143, 5, 24, "Text",
  CellTags->"General::npad"],

Cell[CellGroupData[{
Cell[64559, 2292, 173, 4, 42, "Input",
  CellTags->"General::npad"],
Cell[64735, 2298, 492, 13, 64, "Output",
  CellTags->"General::npad"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[65288, 2318, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::newl"],
Cell[65370, 2321, 364, 11, 37, "Message",
  CellTags->"General::newl"],
Cell[65737, 2334, 305, 7, 46, "Notes",
  CellTags->"General::newl"],

Cell[CellGroupData[{
Cell[66067, 2345, 63, 1, 38, "ExampleSection",
  CellTags->"General::newl"],
Cell[66133, 2348, 211, 6, 37, "Text",
  CellTags->"General::newl"],

Cell[CellGroupData[{
Cell[66369, 2358, 167, 9, 113, "Input",
  CellTags->"General::newl"],
Cell[66539, 2369, 197, 5, 32, "Message",
  CellTags->"General::newl"],
Cell[66739, 2376, 98, 3, 21, "Print",
  CellTags->"General::newl"],
Cell[66840, 2381, 92, 3, 21, "Print",
  CellTags->"General::newl"],
Cell[66935, 2386, 94, 3, 25, "Output",
  CellTags->"General::newl"]
}, Open  ]],
Cell[67044, 2392, 153, 4, 22, "Text",
  CellTags->"General::newl"],

Cell[CellGroupData[{
Cell[67222, 2400, 169, 10, 130, "Input",
  CellTags->"General::newl"],
Cell[67394, 2412, 98, 3, 21, "Print",
  CellTags->"General::newl"],
Cell[67495, 2417, 92, 3, 21, "Print",
  CellTags->"General::newl"],
Cell[67590, 2422, 88, 3, 25, "Output",
  CellTags->"General::newl"]
}, Open  ]],
Cell[67693, 2428, 181, 4, 36, "Text",
  CellTags->"General::newl"],

Cell[CellGroupData[{
Cell[67899, 2436, 170, 10, 130, "Input",
  CellTags->"General::newl"],
Cell[68072, 2448, 98, 3, 21, "Print",
  CellTags->"General::newl"],
Cell[68173, 2453, 92, 3, 21, "Print",
  CellTags->"General::newl"],
Cell[68268, 2458, 94, 3, 25, "Output",
  CellTags->"General::newl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[68423, 2468, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nsgn"],
Cell[68505, 2471, 541, 15, 37, "Message",
  CellTags->"General::nsgn"],
Cell[69049, 2488, 219, 5, 24, "Notes",
  CellTags->"General::nsgn"],

Cell[CellGroupData[{
Cell[69293, 2497, 63, 1, 38, "ExampleSection",
  CellTags->"General::nsgn"],
Cell[69359, 2500, 216, 5, 40, "Text",
  CellTags->"General::nsgn"],

Cell[CellGroupData[{
Cell[69600, 2509, 159, 4, 26, "Input",
  CellTags->"General::nsgn"],
Cell[69762, 2515, 250, 5, 53, "Message",
  CellTags->"General::nsgn"],
Cell[70015, 2522, 432, 12, 33, "Output",
  CellTags->"General::nsgn"]
}, Open  ]],
Cell[70462, 2537, 141, 5, 24, "Text",
  CellTags->"General::nsgn"],

Cell[CellGroupData[{
Cell[70628, 2546, 157, 4, 26, "Input",
  CellTags->"General::nsgn"],
Cell[70788, 2552, 423, 12, 33, "Output",
  CellTags->"General::nsgn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[71272, 2571, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::npt"],
Cell[71352, 2574, 506, 15, 21, "Message",
  CellTags->"General::npt"],
Cell[71861, 2591, 177, 5, 24, "Notes",
  CellTags->"General::npt"],

Cell[CellGroupData[{
Cell[72063, 2600, 62, 1, 38, "ExampleSection",
  CellTags->"General::npt"],
Cell[72128, 2603, 197, 5, 24, "Text",
  CellTags->"General::npt"],

Cell[CellGroupData[{
Cell[72350, 2612, 123, 3, 26, "Input",
  CellTags->"General::npt"],
Cell[72476, 2617, 213, 5, 37, "Message",
  CellTags->"General::npt"],
Cell[72692, 2624, 230, 7, 33, "Output",
  CellTags->"General::npt"]
}, Open  ]],
Cell[72937, 2634, 140, 5, 24, "Text",
  CellTags->"General::npt"],

Cell[CellGroupData[{
Cell[73102, 2643, 126, 3, 26, "Input",
  CellTags->"General::npt"],
Cell[73231, 2648, 229, 7, 33, "Output",
  CellTags->"General::npt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[73521, 2662, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nspr"],
Cell[73603, 2665, 517, 15, 37, "Message",
  CellTags->"General::nspr"],
Cell[74123, 2682, 207, 5, 24, "Notes",
  CellTags->"General::nspr"],

Cell[CellGroupData[{
Cell[74355, 2691, 63, 1, 38, "ExampleSection",
  CellTags->"General::nspr"],
Cell[74421, 2694, 202, 5, 40, "Text",
  CellTags->"General::nspr"],

Cell[CellGroupData[{
Cell[74648, 2703, 160, 4, 26, "Input",
  CellTags->"General::nspr"],
Cell[74811, 2709, 227, 5, 37, "Message",
  CellTags->"General::nspr"],
Cell[75041, 2716, 271, 8, 33, "Output",
  CellTags->"General::nspr"]
}, Open  ]],
Cell[75327, 2727, 145, 5, 24, "Text",
  CellTags->"General::nspr"],

Cell[CellGroupData[{
Cell[75497, 2736, 162, 4, 26, "Input",
  CellTags->"General::nspr"],
Cell[75662, 2742, 267, 7, 33, "Output",
  CellTags->"General::nspr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[75990, 2756, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sntue"],
Cell[76074, 2759, 389, 11, 21, "Message",
  CellTags->"General::sntue"],
Cell[76466, 2772, 190, 5, 24, "Notes",
  CellTags->"General::sntue"],

Cell[CellGroupData[{
Cell[76681, 2781, 64, 1, 38, "ExampleSection",
  CellTags->"General::sntue"],
Cell[76748, 2784, 147, 4, 24, "Text",
  CellTags->"General::sntue"],

Cell[CellGroupData[{
Cell[76920, 2792, 158, 4, 26, "Input",
  CellTags->"General::sntue"],
Cell[77081, 2798, 98, 3, 21, "Output",
  CellTags->"General::sntue"]
}, Open  ]],

Cell[CellGroupData[{
Cell[77216, 2806, 106, 3, 26, "Input",
  CellTags->"General::sntue"],
Cell[77325, 2811, 191, 6, 51, "Message",
  CellTags->"General::sntue"]
}, Open  ]],
Cell[77531, 2820, 67, 1, 24, "Text",
  CellTags->"General::sntue"],
Cell[77601, 2823, 113, 3, 26, "Input",
  CellTags->"General::sntue"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[77763, 2832, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sntup"],
Cell[77847, 2835, 388, 11, 21, "Message",
  CellTags->"General::sntup"],
Cell[78238, 2848, 197, 5, 40, "Notes",
  CellTags->"General::sntup"],

Cell[CellGroupData[{
Cell[78460, 2857, 64, 1, 38, "ExampleSection",
  CellTags->"General::sntup"],
Cell[78527, 2860, 137, 4, 24, "Text",
  CellTags->"General::sntup"],

Cell[CellGroupData[{
Cell[78689, 2868, 164, 4, 26, "Input",
  CellTags->"General::sntup"],
Cell[78856, 2874, 98, 3, 21, "Output",
  CellTags->"General::sntup"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78991, 2882, 106, 3, 26, "Input",
  CellTags->"General::sntup"],
Cell[79100, 2887, 190, 6, 51, "Message",
  CellTags->"General::sntup"]
}, Open  ]],
Cell[79305, 2896, 67, 1, 24, "Text",
  CellTags->"General::sntup"],
Cell[79375, 2899, 113, 3, 26, "Input",
  CellTags->"General::sntup"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[79537, 2908, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sntx"],
Cell[79619, 2911, 317, 10, 21, "Message",
  CellTags->"General::sntx"],
Cell[79939, 2923, 114, 4, 24, "Notes",
  CellTags->"General::sntx"],

Cell[CellGroupData[{
Cell[80078, 2931, 63, 1, 38, "ExampleSection",
  CellTags->"General::sntx"],
Cell[80144, 2934, 203, 5, 40, "Text",
  CellTags->"General::sntx"],

Cell[CellGroupData[{
Cell[80372, 2943, 109, 3, 26, "Input",
  CellTags->"General::sntx"],
Cell[80484, 2948, 189, 5, 36, "Message",
  CellTags->"General::sntx"],
Cell[80676, 2955, 94, 3, 21, "Output",
  CellTags->"General::sntx"]
}, Open  ]],
Cell[80785, 2961, 84, 1, 24, "Text",
  CellTags->"General::sntx"],

Cell[CellGroupData[{
Cell[80894, 2966, 109, 3, 26, "Input",
  CellTags->"General::sntx"],
Cell[81006, 2971, 91, 3, 21, "Output",
  CellTags->"General::sntx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[81158, 2981, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sntxb"],
Cell[81242, 2984, 322, 10, 21, "Message",
  CellTags->"General::sntxb"],
Cell[81567, 2996, 294, 7, 46, "Notes",
  CellTags->"General::sntxb"],

Cell[CellGroupData[{
Cell[81886, 3007, 64, 1, 38, "ExampleSection",
  CellTags->"General::sntxb"],
Cell[81953, 3010, 231, 6, 40, "Text",
  CellTags->"General::sntxb"],

Cell[CellGroupData[{
Cell[82209, 3020, 74, 2, 28, "Input",
  CellTags->"General::sntxb"],
Cell[82286, 3024, 128, 2, 21, "Message",
  CellTags->"General::sntxb"]
}, Open  ]],
Cell[82429, 3029, 140, 5, 23, "Text",
  CellTags->"General::sntxb"],

Cell[CellGroupData[{
Cell[82594, 3038, 76, 2, 28, "Input",
  CellTags->"General::sntxb"],
Cell[82673, 3042, 89, 3, 25, "Output",
  CellTags->"General::sntxb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[82823, 3052, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sntxc"],
Cell[82907, 3055, 343, 10, 19, "Message",
  CellTags->"General::sntxc"],
Cell[83253, 3067, 257, 6, 42, "Notes",
  CellTags->"General::sntxc"],

Cell[CellGroupData[{
Cell[83535, 3077, 64, 1, 38, "ExampleSection",
  CellTags->"General::sntxc"],
Cell[83602, 3080, 172, 5, 23, "Text",
  CellTags->"General::sntxc"],

Cell[CellGroupData[{
Cell[83799, 3089, 97, 2, 28, "Input",
  CellTags->"General::sntxc"],
Cell[83899, 3093, 224, 7, 58, "Message",
  CellTags->"General::sntxc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[84184, 3107, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sntxf"],
Cell[84268, 3110, 327, 10, 19, "Message",
  CellTags->"General::sntxf"],
Cell[84598, 3122, 159, 5, 23, "Notes",
  CellTags->"General::sntxf"],

Cell[CellGroupData[{
Cell[84782, 3131, 64, 1, 38, "ExampleSection",
  CellTags->"General::sntxf"],
Cell[84849, 3134, 128, 4, 22, "Text",
  CellTags->"General::sntxf"],

Cell[CellGroupData[{
Cell[85002, 3142, 77, 2, 28, "Input",
  CellTags->"General::sntxf"],
Cell[85082, 3146, 131, 2, 19, "Message",
  CellTags->"General::sntxf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[85274, 3155, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sntxi"],
Cell[85358, 3158, 421, 12, 19, "Message",
  CellTags->"General::sntxi"],
Cell[85782, 3172, 159, 5, 23, "Notes",
  CellTags->"General::sntxi"],

Cell[CellGroupData[{
Cell[85966, 3181, 64, 1, 38, "ExampleSection",
  CellTags->"General::sntxi"],
Cell[86033, 3184, 169, 5, 23, "Text",
  CellTags->"General::sntxi"],

Cell[CellGroupData[{
Cell[86227, 3193, 73, 2, 28, "Input",
  CellTags->"General::sntxi"],
Cell[86303, 3197, 137, 2, 21, "Message",
  CellTags->"General::sntxi"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[86501, 3206, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sntxpi"],
Cell[86587, 3209, 383, 11, 21, "Message",
  CellTags->"General::sntxpi"],
Cell[86973, 3222, 262, 7, 40, "Notes",
  CellTags->"General::sntxpi"],

Cell[CellGroupData[{
Cell[87260, 3233, 65, 1, 38, "ExampleSection",
  CellTags->"General::sntxpi"],
Cell[87328, 3236, 226, 7, 24, "Text",
  CellTags->"General::sntxpi"],

Cell[CellGroupData[{
Cell[87579, 3247, 128, 2, 28, "Input",
  CellTags->"General::sntxpi"],
Cell[87710, 3251, 130, 3, 21, "Output",
  CellTags->"General::sntxpi"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87877, 3259, 77, 2, 28, "Input",
  CellTags->"General::sntxpi"],
Cell[87957, 3263, 139, 2, 21, "Message",
  CellTags->"General::sntxpi"]
}, Open  ]],
Cell[88111, 3268, 119, 5, 24, "Text",
  CellTags->"General::sntxpi"],
Cell[88233, 3275, 87, 2, 28, "Input",
  CellTags->"General::sntxpi"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[88369, 3283, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sntxpr"],
Cell[88455, 3286, 244, 7, 21, "Message",
  CellTags->"General::sntxpr"],
Cell[88702, 3295, 263, 7, 40, "Notes",
  CellTags->"General::sntxpr"],

Cell[CellGroupData[{
Cell[88990, 3306, 65, 1, 38, "ExampleSection",
  CellTags->"General::sntxpr"],
Cell[89058, 3309, 233, 7, 40, "Text",
  CellTags->"General::sntxpr"],

Cell[CellGroupData[{
Cell[89316, 3320, 130, 2, 28, "Input",
  CellTags->"General::sntxpr"],
Cell[89449, 3324, 132, 3, 21, "Output",
  CellTags->"General::sntxpr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[89618, 3332, 77, 2, 28, "Input",
  CellTags->"General::sntxpr"],
Cell[89698, 3336, 172, 4, 21, "Message",
  CellTags->"General::sntxpr"],
Cell[89873, 3342, 132, 2, 21, "Message",
  CellTags->"General::sntxpr"]
}, Open  ]],
Cell[90020, 3347, 119, 5, 24, "Text",
  CellTags->"General::sntxpr"],
Cell[90142, 3354, 87, 2, 28, "Input",
  CellTags->"General::sntxpr"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[90278, 3362, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sntxq"],
Cell[90362, 3365, 337, 10, 21, "Message",
  CellTags->"General::sntxq"],
Cell[90702, 3377, 195, 6, 24, "Notes",
  CellTags->"General::sntxq"],

Cell[CellGroupData[{
Cell[90922, 3387, 64, 1, 38, "ExampleSection",
  CellTags->"General::sntxq"],
Cell[90989, 3390, 175, 5, 24, "Text",
  CellTags->"General::sntxq"],

Cell[CellGroupData[{
Cell[91189, 3399, 89, 2, 28, "Input",
  CellTags->"General::sntxq"],
Cell[91281, 3403, 201, 6, 51, "Message",
  CellTags->"General::sntxq"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[91543, 3416, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::spell"],
Cell[91627, 3419, 368, 11, 37, "Message",
  CellTags->"General::spell"],
Cell[91998, 3432, 388, 8, 68, "Notes",
  CellTags->"General::spell"],

Cell[CellGroupData[{
Cell[92411, 3444, 64, 1, 38, "ExampleSection",
  CellTags->"General::spell"],
Cell[92478, 3447, 153, 4, 24, "Text",
  CellTags->"General::spell"],

Cell[CellGroupData[{
Cell[92656, 3455, 115, 3, 26, "Input",
  CellTags->"General::spell"],
Cell[92774, 3460, 250, 5, 37, "Message",
  CellTags->"General::spell"],
Cell[93027, 3467, 89, 3, 21, "Output",
  CellTags->"General::spell"]
}, Open  ]],

Cell[CellGroupData[{
Cell[93153, 3475, 108, 3, 26, "Input",
  CellTags->"General::spell"],
Cell[93264, 3480, 250, 5, 33, "Message",
  CellTags->"General::spell"],
Cell[93517, 3487, 259, 5, 33, "Message",
  CellTags->"General::spell"],
Cell[93779, 3494, 109, 3, 25, "Output",
  CellTags->"General::spell"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[93949, 3504, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::spell1"],
Cell[94035, 3507, 377, 11, 33, "Message",
  CellTags->"General::spell1"],
Cell[94415, 3520, 390, 8, 62, "Notes",
  CellTags->"General::spell1"],

Cell[CellGroupData[{
Cell[94830, 3532, 65, 1, 38, "ExampleSection",
  CellTags->"General::spell1"],
Cell[94898, 3535, 144, 4, 22, "Text",
  CellTags->"General::spell1"],

Cell[CellGroupData[{
Cell[95067, 3543, 116, 3, 26, "Input",
  CellTags->"General::spell1"],
Cell[95186, 3548, 251, 5, 33, "Message",
  CellTags->"General::spell1"],
Cell[95440, 3555, 90, 3, 25, "Output",
  CellTags->"General::spell1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[95591, 3565, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ssle"],
Cell[95673, 3568, 542, 16, 19, "Message",
  CellTags->"General::ssle"],
Cell[96218, 3586, 172, 4, 22, "Notes",
  CellTags->"General::ssle"],

Cell[CellGroupData[{
Cell[96415, 3594, 63, 1, 38, "ExampleSection",
  CellTags->"General::ssle"],
Cell[96481, 3597, 184, 5, 23, "Text",
  CellTags->"General::ssle"],

Cell[CellGroupData[{
Cell[96690, 3606, 106, 3, 26, "Input",
  CellTags->"General::ssle"],
Cell[96799, 3611, 242, 5, 33, "Message",
  CellTags->"General::ssle"],
Cell[97044, 3618, 107, 3, 25, "Output",
  CellTags->"General::ssle"]
}, Open  ]],
Cell[97166, 3624, 128, 5, 23, "Text",
  CellTags->"General::ssle"],

Cell[CellGroupData[{
Cell[97319, 3633, 104, 3, 26, "Input",
  CellTags->"General::ssle"],
Cell[97426, 3638, 96, 3, 21, "Output",
  CellTags->"General::ssle"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[97583, 3648, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::tsntxi"],
Cell[97669, 3651, 331, 10, 21, "Message",
  CellTags->"General::tsntxi"],
Cell[98003, 3663, 117, 4, 24, "Notes",
  CellTags->"General::tsntxi"],

Cell[CellGroupData[{
Cell[98145, 3671, 65, 1, 38, "ExampleSection",
  CellTags->"General::tsntxi"],
Cell[98213, 3674, 123, 4, 24, "Text",
  CellTags->"General::tsntxi"],

Cell[CellGroupData[{
Cell[98361, 3682, 106, 3, 26, "Input",
  CellTags->"General::tsntxi"],
Cell[98470, 3687, 217, 5, 21, "Message",
  CellTags->"General::tsntxi"],
Cell[98690, 3694, 174, 5, 21, "Message",
  CellTags->"General::tsntxi"]
}, Open  ]],
Cell[98879, 3702, 92, 1, 24, "Text",
  CellTags->"General::tsntxi"],

Cell[CellGroupData[{
Cell[98996, 3707, 107, 3, 26, "Input",
  CellTags->"General::tsntxi"],
Cell[99106, 3712, 90, 3, 21, "Output",
  CellTags->"General::tsntxi"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[99257, 3722, 148, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"HorizontalForm::precd", "VerticalForm::precd"}],
Cell[99408, 3728, 453, 11, 37, "Message",
  CellTags->{"HorizontalForm::precd", "VerticalForm::precd"}],
Cell[99864, 3741, 607, 13, 100, "Notes",
  CellTags->{"HorizontalForm::precd", "VerticalForm::precd"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[100508, 3759, 151, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
Cell[100662, 3766, 508, 13, 37, "Message",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
Cell[101173, 3781, 468, 12, 78, "Notes",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],

Cell[CellGroupData[{
Cell[101666, 3797, 99, 1, 38, "ExampleSection",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
Cell[101768, 3800, 255, 7, 24, "Text",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],

Cell[CellGroupData[{
Cell[102048, 3811, 228, 5, 42, "Input",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
Cell[102279, 3818, 254, 5, 37, "Message",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
Cell[102536, 3825, 278, 8, 31, "Output",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}]
}, Open  ]],
Cell[102829, 3836, 181, 5, 24, "Text",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],

Cell[CellGroupData[{
Cell[103035, 3845, 223, 5, 42, "Input",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}],
Cell[103261, 3852, 245, 7, 35, "Output",
  CellTags->{"Infix::group", "Postfix::group", "Prefix::group"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[103567, 3866, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Integrate::intmul"],
Cell[103657, 3869, 322, 6, 61, "Message",
  CellTags->"Integrate::intmul"],
Cell[103982, 3877, 361, 7, 42, "Notes",
  CellTags->"Integrate::intmul"],

Cell[CellGroupData[{
Cell[104368, 3888, 67, 1, 38, "ExampleSection",
  CellTags->"Integrate::intmul"],
Cell[104438, 3891, 167, 4, 22, "Text",
  CellTags->"Integrate::intmul"],

Cell[CellGroupData[{
Cell[104630, 3899, 475, 15, 40, "Input",
  CellTags->"Integrate::intmul"],
Cell[105108, 3916, 368, 7, 65, "Message",
  CellTags->"Integrate::intmul"],
Cell[105479, 3925, 251, 6, 31, "Message",
  CellTags->"Integrate::intmul"]
}, Open  ]],
Cell[105745, 3934, 103, 1, 22, "Text",
  CellTags->"Integrate::intmul"],

Cell[CellGroupData[{
Cell[105873, 3939, 598, 19, 40, "Input",
  CellTags->"Integrate::intmul"],
Cell[106474, 3960, 147, 3, 39, "Output",
  CellTags->"Integrate::intmul"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[106682, 3970, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Integrate::novar"],
Cell[106770, 3973, 313, 6, 46, "Message",
  CellTags->"Integrate::novar"],
Cell[107086, 3981, 201, 5, 36, "Notes",
  CellTags->"Integrate::novar"],

Cell[CellGroupData[{
Cell[107312, 3990, 66, 1, 38, "ExampleSection",
  CellTags->"Integrate::novar"],
Cell[107381, 3993, 137, 4, 22, "Text",
  CellTags->"Integrate::novar"],

Cell[CellGroupData[{
Cell[107543, 4001, 116, 3, 40, "Input",
  CellTags->"Integrate::novar"],
Cell[107662, 4006, 343, 6, 85, "Message",
  CellTags->"Integrate::novar"],
Cell[108008, 4014, 184, 5, 35, "Message",
  CellTags->"Integrate::novar"]
}, Open  ]],
Cell[108207, 4022, 104, 1, 24, "Text",
  CellTags->"Integrate::novar"],

Cell[CellGroupData[{
Cell[108336, 4027, 117, 3, 40, "Input",
  CellTags->"Integrate::novar"],
Cell[108456, 4032, 91, 3, 21, "Output",
  CellTags->"Integrate::novar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[108608, 4042, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Integrate::wrongd"],
Cell[108698, 4045, 272, 5, 53, "Message",
  CellTags->"Integrate::wrongd"],
Cell[108973, 4052, 228, 6, 24, "Notes",
  CellTags->"Integrate::wrongd"],

Cell[CellGroupData[{
Cell[109226, 4062, 67, 1, 38, "ExampleSection",
  CellTags->"Integrate::wrongd"],
Cell[109296, 4065, 185, 5, 24, "Text",
  CellTags->"Integrate::wrongd"],

Cell[CellGroupData[{
Cell[109506, 4074, 112, 3, 40, "Input",
  CellTags->"Integrate::wrongd"],
Cell[109621, 4079, 313, 6, 69, "Message",
  CellTags->"Integrate::wrongd"],
Cell[109937, 4087, 180, 5, 35, "Message",
  CellTags->"Integrate::wrongd"]
}, Open  ]],
Cell[110132, 4095, 105, 1, 24, "Text",
  CellTags->"Integrate::wrongd"],

Cell[CellGroupData[{
Cell[110262, 4100, 125, 3, 40, "Input",
  CellTags->"Integrate::wrongd"],
Cell[110390, 4105, 97, 3, 21, "Output",
  CellTags->"Integrate::wrongd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[110548, 4115, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::dblk"],
Cell[110630, 4118, 323, 8, 37, "Message",
  CellTags->"General::dblk"],
Cell[110956, 4128, 194, 5, 24, "Notes",
  CellTags->"General::dblk"],

Cell[CellGroupData[{
Cell[111175, 4137, 63, 1, 38, "ExampleSection",
  CellTags->"General::dblk"],
Cell[111241, 4140, 209, 7, 24, "Text",
  CellTags->"General::dblk"],

Cell[CellGroupData[{
Cell[111475, 4151, 180, 4, 42, "Input",
  CellTags->"General::dblk"],
Cell[111658, 4157, 238, 5, 53, "Message",
  CellTags->"General::dblk"],
Cell[111899, 4164, 292, 8, 33, "Output",
  CellTags->"General::dblk"]
}, Open  ]],
Cell[112206, 4175, 142, 5, 24, "Text",
  CellTags->"General::dblk"],

Cell[CellGroupData[{
Cell[112373, 4184, 177, 4, 42, "Input",
  CellTags->"General::dblk"],
Cell[112553, 4190, 292, 8, 33, "Output",
  CellTags->"General::dblk"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[112906, 4205, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NumberForm::sigz"],
Cell[112994, 4208, 257, 6, 37, "Message",
  CellTags->"NumberForm::sigz"],
Cell[113254, 4216, 337, 7, 62, "Notes",
  CellTags->"NumberForm::sigz"],

Cell[CellGroupData[{
Cell[113616, 4227, 66, 1, 38, "ExampleSection",
  CellTags->"NumberForm::sigz"],
Cell[113685, 4230, 295, 6, 40, "Text",
  CellTags->"NumberForm::sigz"],

Cell[CellGroupData[{
Cell[114005, 4240, 143, 3, 26, "Input",
  CellTags->"NumberForm::sigz"],
Cell[114151, 4245, 235, 5, 37, "Message",
  CellTags->"NumberForm::sigz"],
Cell[114389, 4252, 282, 7, 33, "Output",
  CellTags->"NumberForm::sigz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[114732, 4266, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ParentForm::deflt"],
Cell[114822, 4269, 268, 6, 21, "Message",
  CellTags->"ParentForm::deflt"],
Cell[115093, 4277, 293, 8, 40, "Notes",
  CellTags->"ParentForm::deflt"],

Cell[CellGroupData[{
Cell[115411, 4289, 67, 1, 38, "ExampleSection",
  CellTags->"ParentForm::deflt"],
Cell[115481, 4292, 205, 5, 40, "Text",
  CellTags->"ParentForm::deflt"],

Cell[CellGroupData[{
Cell[115711, 4301, 118, 3, 26, "Input",
  CellTags->"ParentForm::deflt"],
Cell[115832, 4306, 131, 3, 21, "Output",
  CellTags->"ParentForm::deflt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[116000, 4314, 115, 3, 26, "Input",
  CellTags->"ParentForm::deflt"],
Cell[116118, 4319, 216, 5, 37, "Message",
  CellTags->"ParentForm::deflt"],
Cell[116337, 4326, 216, 5, 37, "Message",
  CellTags->"ParentForm::deflt"],
Cell[116556, 4333, 216, 5, 37, "Message",
  CellTags->"ParentForm::deflt"],
Cell[116775, 4340, 231, 5, 37, "Message",
  CellTags->"ParentForm::deflt"],
Cell[117009, 4347, 114, 3, 21, "Output",
  CellTags->"ParentForm::deflt"]
}, Open  ]],
Cell[117138, 4353, 156, 5, 24, "Text",
  CellTags->"ParentForm::deflt"],

Cell[CellGroupData[{
Cell[117319, 4362, 128, 3, 26, "Input",
  CellTags->"ParentForm::deflt"],
Cell[117450, 4367, 106, 3, 21, "Output",
  CellTags->"ParentForm::deflt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[117593, 4375, 115, 3, 26, "Input",
  CellTags->"ParentForm::deflt"],
Cell[117711, 4380, 114, 3, 21, "Output",
  CellTags->"ParentForm::deflt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[117886, 4390, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Product::prodwarn"],
Cell[117976, 4393, 315, 7, 37, "Message",
  CellTags->"Product::prodwarn"],
Cell[118294, 4402, 419, 9, 62, "Notes",
  CellTags->"Product::prodwarn"],

Cell[CellGroupData[{
Cell[118738, 4415, 67, 1, 38, "ExampleSection",
  CellTags->"Product::prodwarn"],
Cell[118808, 4418, 161, 4, 24, "Text",
  CellTags->"Product::prodwarn"],

Cell[CellGroupData[{
Cell[118994, 4426, 210, 7, 40, "Input",
  CellTags->"Product::prodwarn"],
Cell[119207, 4435, 258, 5, 52, "Message",
  CellTags->"Product::prodwarn"],
Cell[119468, 4442, 112, 3, 35, "Output",
  CellTags->"Product::prodwarn"]
}, Open  ]],
Cell[119595, 4448, 105, 1, 24, "Text",
  CellTags->"Product::prodwarn"],

Cell[CellGroupData[{
Cell[119725, 4453, 208, 7, 50, "Input",
  CellTags->"Product::prodwarn"],
Cell[119936, 4462, 94, 3, 21, "Output",
  CellTags->"Product::prodwarn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[120091, 4472, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Short::short"],
Cell[120171, 4475, 253, 6, 21, "Message",
  CellTags->"Short::short"],
Cell[120427, 4483, 186, 5, 24, "Notes",
  CellTags->"Short::short"],

Cell[CellGroupData[{
Cell[120638, 4492, 62, 1, 38, "ExampleSection",
  CellTags->"Short::short"],
Cell[120703, 4495, 188, 5, 24, "Text",
  CellTags->"Short::short"],

Cell[CellGroupData[{
Cell[120916, 4504, 117, 3, 26, "Input",
  CellTags->"Short::short"],
Cell[121036, 4509, 318, 6, 37, "Message",
  CellTags->"Short::short"],
Cell[121357, 4517, 495, 9, 85, "Output",
  CellTags->"Short::short"]
}, Open  ]],
Cell[121867, 4529, 124, 5, 24, "Text",
  CellTags->"Short::short"],

Cell[CellGroupData[{
Cell[122016, 4538, 117, 3, 26, "Input",
  CellTags->"Short::short"],
Cell[122136, 4543, 246, 6, 21, "Output",
  CellTags->"Short::short"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[122443, 4556, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Splice::splicd"],
Cell[122527, 4559, 393, 11, 21, "Message",
  CellTags->"Splice::splicd"],
Cell[122923, 4572, 188, 5, 24, "Notes",
  CellTags->"Splice::splicd"],

Cell[CellGroupData[{
Cell[123136, 4581, 64, 1, 38, "ExampleSection",
  CellTags->"Splice::splicd"],
Cell[123203, 4584, 148, 4, 24, "Text",
  CellTags->"Splice::splicd"],

Cell[CellGroupData[{
Cell[123376, 4592, 379, 8, 138, "Input",
  CellTags->"Splice::splicd"],
Cell[123758, 4602, 214, 5, 37, "Message",
  CellTags->"Splice::splicd"],
Cell[123975, 4609, 101, 3, 21, "Output",
  CellTags->"Splice::splicd"]
}, Open  ]],
Cell[124091, 4615, 131, 5, 24, "Text",
  CellTags->"Splice::splicd"],

Cell[CellGroupData[{
Cell[124247, 4624, 381, 8, 138, "Input",
  CellTags->"Splice::splicd"],
Cell[124631, 4634, 124, 3, 21, "Output",
  CellTags->"Splice::splicd"]
}, Open  ]],
Cell[124770, 4640, 68, 1, 24, "Text",
  CellTags->"Splice::splicd"],
Cell[124841, 4643, 140, 3, 26, "Input",
  CellTags->"Splice::splicd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[125030, 4652, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Splice::splicf"],
Cell[125114, 4655, 250, 5, 21, "Message",
  CellTags->"Splice::splicf"],
Cell[125367, 4662, 556, 15, 78, "Notes",
  CellTags->"Splice::splicf"],

Cell[CellGroupData[{
Cell[125948, 4681, 64, 1, 38, "ExampleSection",
  CellTags->"Splice::splicf"],
Cell[126015, 4684, 155, 4, 24, "Text",
  CellTags->"Splice::splicf"],

Cell[CellGroupData[{
Cell[126195, 4692, 347, 8, 154, "Input",
  CellTags->"Splice::splicf"],
Cell[126545, 4702, 189, 4, 21, "Message",
  CellTags->"Splice::splicf"],
Cell[126737, 4708, 120, 3, 25, "Output",
  CellTags->"Splice::splicf"]
}, Open  ]],
Cell[126872, 4714, 127, 5, 23, "Text",
  CellTags->"Splice::splicf"],

Cell[CellGroupData[{
Cell[127024, 4723, 350, 8, 154, "Input",
  CellTags->"Splice::splicf"],
Cell[127377, 4733, 124, 3, 25, "Output",
  CellTags->"Splice::splicf"]
}, Open  ]],
Cell[127516, 4739, 68, 1, 22, "Text",
  CellTags->"Splice::splicf"],
Cell[127587, 4742, 138, 3, 26, "Input",
  CellTags->"Splice::splicf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[127774, 4751, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Splice::splict"],
Cell[127858, 4754, 236, 5, 19, "Message",
  CellTags->"Splice::splict"],
Cell[128097, 4761, 401, 13, 38, "Notes",
  CellTags->"Splice::splict"],

Cell[CellGroupData[{
Cell[128523, 4778, 64, 1, 38, "ExampleSection",
  CellTags->"Splice::splict"],
Cell[128590, 4781, 222, 6, 37, "Text",
  CellTags->"Splice::splict"],

Cell[CellGroupData[{
Cell[128837, 4791, 370, 8, 154, "Input",
  CellTags->"Splice::splict"],
Cell[129210, 4801, 185, 4, 19, "Message",
  CellTags->"Splice::splict"],
Cell[129398, 4807, 164, 4, 19, "Message",
  CellTags->"Splice::splict"],
Cell[129565, 4813, 167, 4, 21, "Message",
  CellTags->"Splice::splict"],
Cell[129735, 4819, 112, 3, 21, "Output",
  CellTags->"Splice::splict"]
}, Open  ]],
Cell[129862, 4825, 145, 5, 24, "Text",
  CellTags->"Splice::splict"],

Cell[CellGroupData[{
Cell[130032, 4834, 404, 9, 154, "Input",
  CellTags->"Splice::splict"],
Cell[130439, 4845, 124, 3, 21, "Output",
  CellTags->"Splice::splict"]
}, Open  ]],
Cell[130578, 4851, 68, 1, 24, "Text",
  CellTags->"Splice::splict"],
Cell[130649, 4854, 140, 3, 26, "Input",
  CellTags->"Splice::splict"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[130838, 4863, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Splice::splicx"],
Cell[130922, 4866, 239, 5, 21, "Message",
  CellTags->"Splice::splicx"],
Cell[131164, 4873, 249, 8, 24, "Notes",
  CellTags->"Splice::splicx"],

Cell[CellGroupData[{
Cell[131438, 4885, 64, 1, 38, "ExampleSection",
  CellTags->"Splice::splicx"],
Cell[131505, 4888, 225, 5, 40, "Text",
  CellTags->"Splice::splicx"],

Cell[CellGroupData[{
Cell[131755, 4897, 380, 8, 138, "Input",
  CellTags->"Splice::splicx"],
Cell[132138, 4907, 197, 5, 21, "Message",
  CellTags->"Splice::splicx"],
Cell[132338, 4914, 101, 3, 21, "Output",
  CellTags->"Splice::splicx"]
}, Open  ]],
Cell[132454, 4920, 131, 5, 24, "Text",
  CellTags->"Splice::splicx"],

Cell[CellGroupData[{
Cell[132610, 4929, 381, 8, 138, "Input",
  CellTags->"Splice::splicx"],
Cell[132994, 4939, 124, 3, 21, "Output",
  CellTags->"Splice::splicx"]
}, Open  ]],
Cell[133133, 4945, 68, 1, 24, "Text",
  CellTags->"Splice::splicx"],
Cell[133204, 4948, 140, 3, 26, "Input",
  CellTags->"Splice::splicx"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[133393, 4957, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"StringForm::sfr"],
Cell[133479, 4960, 205, 5, 37, "Message",
  CellTags->"StringForm::sfr"],
Cell[133687, 4967, 431, 9, 78, "Notes",
  CellTags->"StringForm::sfr"],

Cell[CellGroupData[{
Cell[134143, 4980, 65, 1, 38, "ExampleSection",
  CellTags->"StringForm::sfr"],
Cell[134211, 4983, 192, 5, 40, "Text",
  CellTags->"StringForm::sfr"],

Cell[CellGroupData[{
Cell[134428, 4992, 140, 3, 26, "Input",
  CellTags->"StringForm::sfr"],
Cell[134571, 4997, 247, 5, 37, "Message",
  CellTags->"StringForm::sfr"],
Cell[134821, 5004, 236, 5, 21, "Output",
  CellTags->"StringForm::sfr"]
}, Open  ]],
Cell[135072, 5012, 132, 5, 24, "Text",
  CellTags->"StringForm::sfr"],

Cell[CellGroupData[{
Cell[135229, 5021, 143, 3, 26, "Input",
  CellTags->"StringForm::sfr"],
Cell[135375, 5026, 248, 6, 21, "Output",
  CellTags->"StringForm::sfr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[135684, 5039, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Subscripted::subn"],
Cell[135774, 5042, 289, 6, 37, "Message",
  CellTags->"Subscripted::subn"],
Cell[136066, 5050, 193, 5, 24, "Notes",
  CellTags->"Subscripted::subn"],

Cell[CellGroupData[{
Cell[136284, 5059, 67, 1, 38, "ExampleSection",
  CellTags->"Subscripted::subn"],
Cell[136354, 5062, 200, 5, 40, "Text",
  CellTags->"Subscripted::subn"],

Cell[CellGroupData[{
Cell[136579, 5071, 127, 3, 26, "Input",
  CellTags->"Subscripted::subn"],
Cell[136709, 5076, 235, 5, 37, "Message",
  CellTags->"Subscripted::subn"],
Cell[136947, 5083, 128, 3, 21, "Output",
  CellTags->"Subscripted::subn"]
}, Open  ]],
Cell[137090, 5089, 135, 5, 24, "Text",
  CellTags->"Subscripted::subn"],

Cell[CellGroupData[{
Cell[137250, 5098, 127, 3, 26, "Input",
  CellTags->"Subscripted::subn"],
Cell[137380, 5103, 209, 6, 22, "Output",
  CellTags->"Subscripted::subn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[137650, 5116, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Subscripted::subv"],
Cell[137740, 5119, 182, 3, 21, "Message",
  CellTags->"Subscripted::subv"],
Cell[137925, 5124, 470, 10, 78, "Notes",
  CellTags->"Subscripted::subv"],

Cell[CellGroupData[{
Cell[138420, 5138, 67, 1, 38, "ExampleSection",
  CellTags->"Subscripted::subv"],
Cell[138490, 5141, 223, 6, 40, "Text",
  CellTags->"Subscripted::subv"],

Cell[CellGroupData[{
Cell[138738, 5151, 135, 3, 26, "Input",
  CellTags->"Subscripted::subv"],
Cell[138876, 5156, 199, 5, 37, "Message",
  CellTags->"Subscripted::subv"],
Cell[139078, 5163, 217, 6, 25, "Output",
  CellTags->"Subscripted::subv"]
}, Open  ]],
Cell[139310, 5172, 169, 5, 24, "Text",
  CellTags->"Subscripted::subv"],

Cell[CellGroupData[{
Cell[139504, 5181, 135, 3, 26, "Input",
  CellTags->"Subscripted::subv"],
Cell[139642, 5186, 221, 6, 26, "Output",
  CellTags->"Subscripted::subv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[139924, 5199, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Subscripted::subx"],
Cell[140014, 5202, 434, 11, 19, "Message",
  CellTags->"Subscripted::subx"],
Cell[140451, 5215, 529, 11, 71, "Notes",
  CellTags->"Subscripted::subx"],

Cell[CellGroupData[{
Cell[141005, 5230, 67, 1, 38, "ExampleSection",
  CellTags->"Subscripted::subx"],
Cell[141075, 5233, 233, 5, 37, "Text",
  CellTags->"Subscripted::subx"],

Cell[CellGroupData[{
Cell[141333, 5242, 121, 3, 26, "Input",
  CellTags->"Subscripted::subx"],
Cell[141457, 5247, 230, 5, 33, "Message",
  CellTags->"Subscripted::subx"],
Cell[141690, 5254, 197, 6, 26, "Output",
  CellTags->"Subscripted::subx"]
}, Open  ]],
Cell[141902, 5263, 122, 4, 22, "Text",
  CellTags->"Subscripted::subx"],

Cell[CellGroupData[{
Cell[142049, 5271, 126, 3, 26, "Input",
  CellTags->"Subscripted::subx"],
Cell[142178, 5276, 198, 6, 26, "Output",
  CellTags->"Subscripted::subx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[142437, 5289, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Sum::sumwarn"],
Cell[142517, 5292, 309, 7, 33, "Message",
  CellTags->"Sum::sumwarn"],
Cell[142829, 5301, 323, 7, 42, "Notes",
  CellTags->"Sum::sumwarn"],

Cell[CellGroupData[{
Cell[143177, 5312, 62, 1, 38, "ExampleSection",
  CellTags->"Sum::sumwarn"],
Cell[143242, 5315, 162, 4, 22, "Text",
  CellTags->"Sum::sumwarn"],

Cell[CellGroupData[{
Cell[143429, 5323, 216, 7, 40, "Input",
  CellTags->"Sum::sumwarn"],
Cell[143648, 5332, 263, 5, 47, "Message",
  CellTags->"Sum::sumwarn"],
Cell[143914, 5339, 107, 3, 39, "Output",
  CellTags->"Sum::sumwarn"]
}, Open  ]],
Cell[144036, 5345, 92, 1, 22, "Text",
  CellTags->"Sum::sumwarn"],

Cell[CellGroupData[{
Cell[144153, 5350, 207, 7, 50, "Input",
  CellTags->"Sum::sumwarn"],
Cell[144363, 5359, 88, 3, 21, "Output",
  CellTags->"Sum::sumwarn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[144512, 5369, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Syntax::noinfo"],
Cell[144596, 5372, 196, 4, 37, "Message",
  CellTags->"Syntax::noinfo"],
Cell[144795, 5378, 343, 9, 46, "Notes",
  CellTags->"Syntax::noinfo"],

Cell[CellGroupData[{
Cell[145163, 5391, 64, 1, 38, "ExampleSection",
  CellTags->"Syntax::noinfo"],
Cell[145230, 5394, 250, 7, 40, "Text",
  CellTags->"Syntax::noinfo"],

Cell[CellGroupData[{
Cell[145505, 5405, 160, 4, 26, "Input",
  CellTags->"Syntax::noinfo"],
Cell[145668, 5411, 209, 5, 37, "Message",
  CellTags->"Syntax::noinfo"],
Cell[145880, 5418, 148, 4, 21, "Output",
  CellTags->"Syntax::noinfo"]
}, Open  ]],
Cell[146043, 5425, 147, 5, 24, "Text",
  CellTags->"Syntax::noinfo"],

Cell[CellGroupData[{
Cell[146215, 5434, 163, 4, 26, "Input",
  CellTags->"Syntax::noinfo"],
Cell[146381, 5440, 117, 3, 21, "Output",
  CellTags->"Syntax::noinfo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[146559, 5450, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Syntax::snthex"],
Cell[146643, 5453, 215, 5, 37, "Message",
  CellTags->"Syntax::snthex"],
Cell[146861, 5460, 256, 7, 24, "Notes",
  CellTags->"Syntax::snthex"],

Cell[CellGroupData[{
Cell[147142, 5471, 64, 1, 38, "ExampleSection",
  CellTags->"Syntax::snthex"],
Cell[147209, 5474, 207, 5, 24, "Text",
  CellTags->"Syntax::snthex"],

Cell[CellGroupData[{
Cell[147441, 5483, 135, 3, 26, "Input",
  CellTags->"Syntax::snthex"],
Cell[147579, 5488, 214, 5, 37, "Message",
  CellTags->"Syntax::snthex"],
Cell[147796, 5495, 193, 5, 36, "Message",
  CellTags->"Syntax::snthex"],
Cell[147992, 5502, 95, 3, 21, "Output",
  CellTags->"Syntax::snthex"]
}, Open  ]],
Cell[148102, 5508, 123, 4, 24, "Text",
  CellTags->"Syntax::snthex"],

Cell[CellGroupData[{
Cell[148250, 5516, 136, 3, 26, "Input",
  CellTags->"Syntax::snthex"],
Cell[148389, 5521, 95, 3, 21, "Output",
  CellTags->"Syntax::snthex"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[148545, 5531, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Syntax::sntoct1"],
Cell[148631, 5534, 210, 5, 37, "Message",
  CellTags->"Syntax::sntoct1"],
Cell[148844, 5541, 255, 7, 24, "Notes",
  CellTags->"Syntax::sntoct1"],

Cell[CellGroupData[{
Cell[149124, 5552, 65, 1, 38, "ExampleSection",
  CellTags->"Syntax::sntoct1"],
Cell[149192, 5555, 202, 5, 24, "Text",
  CellTags->"Syntax::sntoct1"],

Cell[CellGroupData[{
Cell[149419, 5564, 127, 3, 26, "Input",
  CellTags->"Syntax::sntoct1"],
Cell[149549, 5569, 209, 5, 37, "Message",
  CellTags->"Syntax::sntoct1"],
Cell[149761, 5576, 192, 5, 36, "Message",
  CellTags->"Syntax::sntoct1"],
Cell[149956, 5583, 96, 3, 21, "Output",
  CellTags->"Syntax::sntoct1"]
}, Open  ]],
Cell[150067, 5589, 118, 4, 24, "Text",
  CellTags->"Syntax::sntoct1"],

Cell[CellGroupData[{
Cell[150210, 5597, 127, 3, 26, "Input",
  CellTags->"Syntax::sntoct1"],
Cell[150340, 5602, 90, 3, 21, "Output",
  CellTags->"Syntax::sntoct1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[150491, 5612, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Syntax::sntoct2"],
Cell[150577, 5615, 217, 5, 37, "Message",
  CellTags->"Syntax::sntoct2"],
Cell[150797, 5622, 255, 7, 24, "Notes",
  CellTags->"Syntax::sntoct2"],

Cell[CellGroupData[{
Cell[151077, 5633, 65, 1, 38, "ExampleSection",
  CellTags->"Syntax::sntoct2"],
Cell[151145, 5636, 203, 5, 24, "Text",
  CellTags->"Syntax::sntoct2"],

Cell[CellGroupData[{
Cell[151373, 5645, 144, 3, 26, "Input",
  CellTags->"Syntax::sntoct2"],
Cell[151520, 5650, 216, 5, 37, "Message",
  CellTags->"Syntax::sntoct2"],
Cell[151739, 5657, 193, 5, 36, "Message",
  CellTags->"Syntax::sntoct2"],
Cell[151935, 5664, 96, 3, 21, "Output",
  CellTags->"Syntax::sntoct2"]
}, Open  ]],
Cell[152046, 5670, 124, 4, 24, "Text",
  CellTags->"Syntax::sntoct2"],

Cell[CellGroupData[{
Cell[152195, 5678, 145, 3, 26, "Input",
  CellTags->"Syntax::sntoct2"],
Cell[152343, 5683, 92, 3, 21, "Output",
  CellTags->"Syntax::sntoct2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[152496, 5693, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Syntax::sntufn"],
Cell[152580, 5696, 212, 5, 21, "Message",
  CellTags->"Syntax::sntufn"],
Cell[152795, 5703, 181, 4, 24, "Notes",
  CellTags->"Syntax::sntufn"],

Cell[CellGroupData[{
Cell[153001, 5711, 64, 1, 38, "ExampleSection",
  CellTags->"Syntax::sntufn"],
Cell[153068, 5714, 180, 4, 40, "Text",
  CellTags->"Syntax::sntufn"],

Cell[CellGroupData[{
Cell[153273, 5722, 124, 3, 26, "Input",
  CellTags->"Syntax::sntufn"],
Cell[153400, 5727, 174, 4, 21, "Message",
  CellTags->"Syntax::sntufn"],
Cell[153577, 5733, 194, 5, 36, "Message",
  CellTags->"Syntax::sntufn"],
Cell[153774, 5740, 95, 3, 21, "Output",
  CellTags->"Syntax::sntufn"]
}, Open  ]],
Cell[153884, 5746, 117, 4, 24, "Text",
  CellTags->"Syntax::sntufn"],

Cell[CellGroupData[{
Cell[154026, 5754, 124, 3, 26, "Input",
  CellTags->"Syntax::sntufn"],
Cell[154153, 5759, 96, 3, 21, "Output",
  CellTags->"Syntax::sntufn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[154310, 5769, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Syntax::sntunc"],
Cell[154394, 5772, 254, 6, 21, "Message",
  CellTags->"Syntax::sntunc"],
Cell[154651, 5780, 184, 4, 24, "Notes",
  CellTags->"Syntax::sntunc"],

Cell[CellGroupData[{
Cell[154860, 5788, 64, 1, 38, "ExampleSection",
  CellTags->"Syntax::sntunc"],
Cell[154927, 5791, 156, 4, 24, "Text",
  CellTags->"Syntax::sntunc"],

Cell[CellGroupData[{
Cell[155108, 5799, 127, 3, 26, "Input",
  CellTags->"Syntax::sntunc"],
Cell[155238, 5804, 198, 5, 21, "Message",
  CellTags->"Syntax::sntunc"],
Cell[155439, 5811, 98, 3, 21, "Output",
  CellTags->"Syntax::sntunc"]
}, Open  ]],
Cell[155552, 5817, 99, 1, 24, "Text",
  CellTags->"Syntax::sntunc"],

Cell[CellGroupData[{
Cell[155676, 5822, 128, 3, 26, "Input",
  CellTags->"Syntax::sntunc"],
Cell[155807, 5827, 98, 3, 21, "Output",
  CellTags->"Syntax::sntunc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[155966, 5837, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Syntax::syntyp"],
Cell[156050, 5840, 181, 4, 21, "Message",
  CellTags->"Syntax::syntyp"],
Cell[156234, 5846, 399, 14, 40, "Notes",
  CellTags->"Syntax::syntyp"],

Cell[CellGroupData[{
Cell[156658, 5864, 64, 1, 38, "ExampleSection",
  CellTags->"Syntax::syntyp"],
Cell[156725, 5867, 211, 6, 40, "Text",
  CellTags->"Syntax::syntyp"],

Cell[CellGroupData[{
Cell[156961, 5877, 115, 3, 26, "Input",
  CellTags->"Syntax::syntyp"],
Cell[157079, 5882, 180, 4, 21, "Message",
  CellTags->"Syntax::syntyp"],
Cell[157262, 5888, 205, 5, 36, "Message",
  CellTags->"Syntax::syntyp"],
Cell[157470, 5895, 95, 3, 21, "Output",
  CellTags->"Syntax::syntyp"]
}, Open  ]],
Cell[157580, 5901, 140, 5, 24, "Text",
  CellTags->"Syntax::syntyp"],

Cell[CellGroupData[{
Cell[157745, 5910, 119, 3, 26, "Input",
  CellTags->"Syntax::syntyp"],
Cell[157867, 5915, 132, 3, 21, "Output",
  CellTags->"Syntax::syntyp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[158060, 5925, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"TableForm::tfal"],
Cell[158146, 5928, 439, 8, 69, "Message",
  CellTags->"TableForm::tfal"],
Cell[158588, 5938, 200, 5, 24, "Notes",
  CellTags->"TableForm::tfal"],

Cell[CellGroupData[{
Cell[158813, 5947, 65, 1, 38, "ExampleSection",
  CellTags->"TableForm::tfal"],
Cell[158881, 5950, 238, 7, 40, "Text",
  CellTags->"TableForm::tfal"],

Cell[CellGroupData[{
Cell[159144, 5961, 171, 4, 42, "Input",
  CellTags->"TableForm::tfal"],
Cell[159318, 5967, 333, 6, 69, "Message",
  CellTags->"TableForm::tfal"],
Cell[159654, 5975, 406, 13, 47, "Output",
  CellTags->"TableForm::tfal"]
}, Open  ]],
Cell[160075, 5991, 147, 5, 24, "Text",
  CellTags->"TableForm::tfal"],

Cell[CellGroupData[{
Cell[160247, 6000, 160, 4, 26, "Input",
  CellTags->"TableForm::tfal"],
Cell[160410, 6006, 388, 12, 47, "Output",
  CellTags->"TableForm::tfal"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[160859, 6025, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"TableForm::tfdir"],
Cell[160947, 6028, 336, 7, 37, "Message",
  CellTags->"TableForm::tfdir"],
Cell[161286, 6037, 201, 5, 24, "Notes",
  CellTags->"TableForm::tfdir"],

Cell[CellGroupData[{
Cell[161512, 6046, 66, 1, 38, "ExampleSection",
  CellTags->"TableForm::tfdir"],
Cell[161581, 6049, 217, 7, 24, "Text",
  CellTags->"TableForm::tfdir"],

Cell[CellGroupData[{
Cell[161823, 6060, 160, 4, 26, "Input",
  CellTags->"TableForm::tfdir"],
Cell[161986, 6066, 247, 5, 53, "Message",
  CellTags->"TableForm::tfdir"],
Cell[162236, 6073, 395, 12, 47, "Output",
  CellTags->"TableForm::tfdir"]
}, Open  ]],
Cell[162646, 6088, 148, 5, 24, "Text",
  CellTags->"TableForm::tfdir"],

Cell[CellGroupData[{
Cell[162819, 6097, 159, 4, 26, "Input",
  CellTags->"TableForm::tfdir"],
Cell[162981, 6103, 418, 14, 115, "Output",
  CellTags->"TableForm::tfdir"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[163460, 6124, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"TableForm::tfh"],
Cell[163544, 6127, 333, 7, 37, "Message",
  CellTags->"TableForm::tfh"],
Cell[163880, 6136, 197, 5, 24, "Notes",
  CellTags->"TableForm::tfh"],

Cell[CellGroupData[{
Cell[164102, 6145, 64, 1, 38, "ExampleSection",
  CellTags->"TableForm::tfh"],
Cell[164169, 6148, 201, 6, 24, "Text",
  CellTags->"TableForm::tfh"],

Cell[CellGroupData[{
Cell[164395, 6158, 190, 4, 42, "Input",
  CellTags->"TableForm::tfh"],
Cell[164588, 6164, 232, 5, 37, "Message",
  CellTags->"TableForm::tfh"],
Cell[164823, 6171, 232, 5, 37, "Message",
  CellTags->"TableForm::tfh"],
Cell[165058, 6178, 232, 5, 37, "Message",
  CellTags->"TableForm::tfh"],
Cell[165293, 6185, 225, 5, 37, "Message",
  CellTags->"TableForm::tfh"],
Cell[165521, 6192, 427, 14, 63, "Output",
  CellTags->"TableForm::tfh"]
}, Open  ]],
Cell[165963, 6209, 144, 5, 24, "Text",
  CellTags->"TableForm::tfh"],

Cell[CellGroupData[{
Cell[166132, 6218, 198, 4, 42, "Input",
  CellTags->"TableForm::tfh"],
Cell[166333, 6224, 493, 15, 79, "Output",
  CellTags->"TableForm::tfh"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[166887, 6246, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"TableForm::tfsp"],
Cell[166973, 6249, 315, 6, 37, "Message",
  CellTags->"TableForm::tfsp"],
Cell[167291, 6257, 197, 5, 24, "Notes",
  CellTags->"TableForm::tfsp"],

Cell[CellGroupData[{
Cell[167513, 6266, 65, 1, 38, "ExampleSection",
  CellTags->"TableForm::tfsp"],
Cell[167581, 6269, 311, 11, 40, "Text",
  CellTags->"TableForm::tfsp"],

Cell[CellGroupData[{
Cell[167917, 6284, 182, 5, 42, "Input",
  CellTags->"TableForm::tfsp"],
Cell[168102, 6291, 237, 5, 37, "Message",
  CellTags->"TableForm::tfsp"],
Cell[168342, 6298, 224, 8, 31, "Output",
  CellTags->"TableForm::tfsp"]
}, Open  ]],
Cell[168581, 6309, 144, 5, 24, "Text",
  CellTags->"TableForm::tfsp"],

Cell[CellGroupData[{
Cell[168750, 6318, 184, 5, 42, "Input",
  CellTags->"TableForm::tfsp"],
Cell[168937, 6325, 192, 13, 109, "Output",
  CellTags->"TableForm::tfsp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[169190, 6345, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"TeXForm::texalign"],
Cell[169280, 6348, 242, 5, 37, "Message",
  CellTags->"TeXForm::texalign"],
Cell[169525, 6355, 335, 11, 40, "Notes",
  CellTags->"TeXForm::texalign"]
}, Open  ]],

Cell[CellGroupData[{
Cell[169897, 6371, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"TeXForm::texstyle"],
Cell[169987, 6374, 285, 6, 47, "Message",
  CellTags->"TeXForm::texstyle"],
Cell[170275, 6382, 197, 6, 24, "Notes",
  CellTags->"TeXForm::texstyle"]
}, Open  ]],

Cell[CellGroupData[{
Cell[170509, 6393, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"TeXForm::texval"],
Cell[170595, 6396, 288, 6, 19, "Message",
  CellTags->"TeXForm::texval"],
Cell[170886, 6404, 195, 6, 24, "Notes",
  CellTags->"TeXForm::texval"]
}, Open  ]],

Cell[CellGroupData[{
Cell[171118, 6415, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ToExpression::esntx"],
Cell[171212, 6418, 261, 6, 19, "Message",
  CellTags->"ToExpression::esntx"],
Cell[171476, 6426, 263, 8, 24, "Notes",
  CellTags->"ToExpression::esntx"],

Cell[CellGroupData[{
Cell[171764, 6438, 69, 1, 38, "ExampleSection",
  CellTags->"ToExpression::esntx"],
Cell[171836, 6441, 205, 5, 37, "Text",
  CellTags->"ToExpression::esntx"],

Cell[CellGroupData[{
Cell[172066, 6450, 146, 3, 26, "Input",
  CellTags->"ToExpression::esntx"],
Cell[172215, 6455, 203, 5, 19, "Message",
  CellTags->"ToExpression::esntx"],
Cell[172421, 6462, 222, 5, 19, "Message",
  CellTags->"ToExpression::esntx"],
Cell[172646, 6469, 100, 3, 25, "Output",
  CellTags->"ToExpression::esntx"]
}, Open  ]],
Cell[172761, 6475, 153, 5, 23, "Text",
  CellTags->"ToExpression::esntx"],

Cell[CellGroupData[{
Cell[172939, 6484, 163, 4, 26, "Input",
  CellTags->"ToExpression::esntx"],
Cell[173105, 6490, 102, 3, 25, "Output",
  CellTags->"ToExpression::esntx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[173268, 6500, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ToExpression::esntxb"],
Cell[173364, 6503, 186, 4, 19, "Message",
  CellTags->"ToExpression::esntxb"],
Cell[173553, 6509, 331, 8, 42, "Notes",
  CellTags->"ToExpression::esntxb"]
}, Open  ]],

Cell[CellGroupData[{
Cell[173921, 6522, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ToExpression::esntxf"],
Cell[174017, 6525, 187, 4, 19, "Message",
  CellTags->"ToExpression::esntxf"],
Cell[174207, 6531, 323, 10, 43, "Notes",
  CellTags->"ToExpression::esntxf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[174567, 6546, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ToExpression::esntxi"],
Cell[174663, 6549, 179, 4, 21, "Message",
  CellTags->"ToExpression::esntxi"],
Cell[174845, 6555, 341, 10, 46, "Notes",
  CellTags->"ToExpression::esntxi"]
}, Open  ]],

Cell[CellGroupData[{
Cell[175223, 6570, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ToString::notype"],
Cell[175311, 6573, 334, 7, 37, "Message",
  CellTags->"ToString::notype"],
Cell[175648, 6582, 196, 6, 24, "Notes",
  CellTags->"ToString::notype"]
}, Open  ]],

Cell[CellGroupData[{
Cell[175881, 6593, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::base"],
Cell[175963, 6596, 492, 16, 21, "Message",
  CellTags->"General::base"],
Cell[176458, 6614, 288, 9, 24, "Notes",
  CellTags->"General::base"],

Cell[CellGroupData[{
Cell[176771, 6627, 63, 1, 38, "ExampleSection",
  CellTags->"General::base"],
Cell[176837, 6630, 164, 4, 24, "Text",
  CellTags->"General::base"],

Cell[CellGroupData[{
Cell[177026, 6638, 95, 3, 26, "Input",
  CellTags->"General::base"],
Cell[177124, 6643, 220, 5, 37, "Message",
  CellTags->"General::base"]
}, Open  ]],
Cell[177359, 6651, 118, 4, 24, "Text",
  CellTags->"General::base"],

Cell[CellGroupData[{
Cell[177502, 6659, 95, 3, 26, "Input",
  CellTags->"General::base"],
Cell[177600, 6664, 89, 3, 21, "Output",
  CellTags->"General::base"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[177750, 6674, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::bktfn"],
Cell[177834, 6677, 324, 10, 21, "Message",
  CellTags->"General::bktfn"],
Cell[178161, 6689, 467, 12, 68, "Notes",
  CellTags->"General::bktfn"],

Cell[CellGroupData[{
Cell[178653, 6705, 64, 1, 38, "ExampleSection",
  CellTags->"General::bktfn"],
Cell[178720, 6708, 203, 6, 24, "Text",
  CellTags->"General::bktfn"],

Cell[CellGroupData[{
Cell[178948, 6718, 87, 2, 28, "Input",
  CellTags->"General::bktfn"],
Cell[179038, 6722, 164, 5, 21, "Message",
  CellTags->"General::bktfn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[179263, 6734, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::bktmch"],
Cell[179349, 6737, 344, 10, 21, "Message",
  CellTags->"General::bktmch"],
Cell[179696, 6749, 387, 8, 68, "Notes",
  CellTags->"General::bktmch"],

Cell[CellGroupData[{
Cell[180108, 6761, 65, 1, 38, "ExampleSection",
  CellTags->"General::bktmch"],
Cell[180176, 6764, 204, 6, 24, "Text",
  CellTags->"General::bktmch"],

Cell[CellGroupData[{
Cell[180405, 6774, 88, 2, 28, "Input",
  CellTags->"General::bktmch"],
Cell[180496, 6778, 162, 5, 21, "Message",
  CellTags->"General::bktmch"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[180719, 6790, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::bktmcp"],
Cell[180805, 6793, 333, 10, 21, "Message",
  CellTags->"General::bktmcp"],
Cell[181141, 6805, 124, 4, 24, "Notes",
  CellTags->"General::bktmcp"],

Cell[CellGroupData[{
Cell[181290, 6813, 65, 1, 38, "ExampleSection",
  CellTags->"General::bktmcp"],
Cell[181358, 6816, 135, 4, 24, "Text",
  CellTags->"General::bktmcp"],

Cell[CellGroupData[{
Cell[181518, 6824, 162, 4, 26, "Input",
  CellTags->"General::bktmcp"],
Cell[181683, 6830, 210, 5, 21, "Message",
  CellTags->"General::bktmcp"],
Cell[181896, 6837, 239, 5, 37, "Message",
  CellTags->"General::bktmcp"],
Cell[182138, 6844, 96, 3, 21, "Output",
  CellTags->"General::bktmcp"]
}, Open  ]],
Cell[182249, 6850, 146, 5, 24, "Text",
  CellTags->"General::bktmcp"],

Cell[CellGroupData[{
Cell[182420, 6859, 173, 5, 26, "Input",
  CellTags->"General::bktmcp"],
Cell[182596, 6866, 117, 3, 21, "Output",
  CellTags->"General::bktmcp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[182774, 6876, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::bktmop"],
Cell[182860, 6879, 333, 10, 21, "Message",
  CellTags->"General::bktmop"],
Cell[183196, 6891, 124, 4, 24, "Notes",
  CellTags->"General::bktmop"],

Cell[CellGroupData[{
Cell[183345, 6899, 65, 1, 38, "ExampleSection",
  CellTags->"General::bktmop"],
Cell[183413, 6902, 135, 4, 24, "Text",
  CellTags->"General::bktmop"],

Cell[CellGroupData[{
Cell[183573, 6910, 172, 5, 26, "Input",
  CellTags->"General::bktmop"],
Cell[183748, 6917, 209, 5, 21, "Message",
  CellTags->"General::bktmop"],
Cell[183960, 6924, 239, 5, 37, "Message",
  CellTags->"General::bktmop"],
Cell[184202, 6931, 96, 3, 21, "Output",
  CellTags->"General::bktmop"]
}, Open  ]],
Cell[184313, 6937, 146, 5, 24, "Text",
  CellTags->"General::bktmop"],

Cell[CellGroupData[{
Cell[184484, 6946, 181, 5, 26, "Input",
  CellTags->"General::bktmop"],
Cell[184668, 6953, 117, 3, 21, "Output",
  CellTags->"General::bktmop"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[184846, 6963, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::bktwrn"],
Cell[184932, 6966, 364, 11, 37, "Message",
  CellTags->"General::bktwrn"],
Cell[185299, 6979, 537, 12, 100, "Notes",
  CellTags->"General::bktwrn"],

Cell[CellGroupData[{
Cell[185861, 6995, 65, 1, 38, "ExampleSection",
  CellTags->"General::bktwrn"],
Cell[185929, 6998, 242, 6, 40, "Text",
  CellTags->"General::bktwrn"],

Cell[CellGroupData[{
Cell[186196, 7008, 88, 2, 28, "Input",
  CellTags->"General::bktwrn"],
Cell[186287, 7012, 209, 6, 51, "Message",
  CellTags->"General::bktwrn"],
Cell[186499, 7020, 105, 3, 21, "Output",
  CellTags->"General::bktwrn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[186665, 7030, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::bktx"],
Cell[186747, 7033, 322, 10, 21, "Message",
  CellTags->"General::bktx"],
Cell[187072, 7045, 302, 7, 46, "Notes",
  CellTags->"General::bktx"],

Cell[CellGroupData[{
Cell[187399, 7056, 63, 1, 38, "ExampleSection",
  CellTags->"General::bktx"],
Cell[187465, 7059, 200, 6, 24, "Text",
  CellTags->"General::bktx"],

Cell[CellGroupData[{
Cell[187690, 7069, 87, 2, 28, "Input",
  CellTags->"General::bktx"],
Cell[187780, 7073, 137, 2, 21, "Message",
  CellTags->"General::bktx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[187978, 7082, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::continfo"],
Cell[188068, 7085, 207, 5, 21, "Message",
  CellTags->"General::continfo"],
Cell[188278, 7092, 228, 5, 46, "Notes",
  CellTags->"General::continfo"],

Cell[CellGroupData[{
Cell[188531, 7101, 67, 1, 38, "ExampleSection",
  CellTags->"General::continfo"],
Cell[188601, 7104, 90, 1, 24, "Text",
  CellTags->"General::continfo"],

Cell[CellGroupData[{
Cell[188716, 7109, 113, 3, 28, "Input",
  CellTags->"General::continfo"],
Cell[188832, 7114, 160, 3, 35, "Print",
  CellTags->"General::continfo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[189053, 7124, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::digit"],
Cell[189137, 7127, 535, 16, 21, "Message",
  CellTags->"General::digit"],
Cell[189675, 7145, 235, 7, 24, "Notes",
  CellTags->"General::digit"],

Cell[CellGroupData[{
Cell[189935, 7156, 64, 1, 38, "ExampleSection",
  CellTags->"General::digit"],
Cell[190002, 7159, 185, 6, 24, "Text",
  CellTags->"General::digit"],

Cell[CellGroupData[{
Cell[190212, 7169, 91, 3, 26, "Input",
  CellTags->"General::digit"],
Cell[190306, 7174, 219, 5, 37, "Message",
  CellTags->"General::digit"]
}, Open  ]],
Cell[190540, 7182, 140, 4, 24, "Text",
  CellTags->"General::digit"],

Cell[CellGroupData[{
Cell[190705, 7190, 93, 3, 26, "Input",
  CellTags->"General::digit"],
Cell[190801, 7195, 89, 3, 21, "Output",
  CellTags->"General::digit"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[190951, 7205, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::existinfo"],
Cell[191043, 7208, 188, 4, 21, "Message",
  CellTags->"General::existinfo"],
Cell[191234, 7214, 217, 5, 46, "Notes",
  CellTags->"General::existinfo"],

Cell[CellGroupData[{
Cell[191476, 7223, 68, 1, 38, "ExampleSection",
  CellTags->"General::existinfo"],
Cell[191547, 7226, 91, 1, 24, "Text",
  CellTags->"General::existinfo"],

Cell[CellGroupData[{
Cell[191663, 7231, 105, 3, 26, "Input",
  CellTags->"General::existinfo"],
Cell[191771, 7236, 121, 2, 21, "Print",
  CellTags->"General::existinfo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[191953, 7245, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::incomma"],
Cell[192041, 7248, 465, 12, 37, "Message",
  CellTags->"General::incomma"],
Cell[192509, 7262, 226, 5, 46, "Notes",
  CellTags->"General::incomma"],

Cell[CellGroupData[{
Cell[192760, 7271, 66, 1, 38, "ExampleSection",
  CellTags->"General::incomma"],
Cell[192829, 7274, 89, 1, 24, "Text",
  CellTags->"General::incomma"],

Cell[CellGroupData[{
Cell[192943, 7279, 125, 3, 26, "Input",
  CellTags->"General::incomma"],
Cell[193071, 7284, 151, 3, 37, "Print",
  CellTags->"General::incomma"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[193283, 7294, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::intinfo"],
Cell[193371, 7297, 454, 10, 90, "Message",
  CellTags->"General::intinfo"],
Cell[193828, 7309, 219, 5, 46, "Notes",
  CellTags->"General::intinfo"],

Cell[CellGroupData[{
Cell[194072, 7318, 66, 1, 38, "ExampleSection",
  CellTags->"General::intinfo"],
Cell[194141, 7321, 89, 1, 24, "Text",
  CellTags->"General::intinfo"],

Cell[CellGroupData[{
Cell[194255, 7326, 105, 3, 28, "Input",
  CellTags->"General::intinfo"],
Cell[194363, 7331, 331, 6, 70, "Print",
  CellTags->"General::intinfo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[194755, 7344, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::partialinfo"],
Cell[194851, 7347, 192, 4, 21, "Message",
  CellTags->"General::partialinfo"],
Cell[195046, 7353, 223, 5, 46, "Notes",
  CellTags->"General::partialinfo"],

Cell[CellGroupData[{
Cell[195294, 7362, 70, 1, 38, "ExampleSection",
  CellTags->"General::partialinfo"],
Cell[195367, 7365, 93, 1, 24, "Text",
  CellTags->"General::partialinfo"],

Cell[CellGroupData[{
Cell[195485, 7370, 109, 3, 26, "Input",
  CellTags->"General::partialinfo"],
Cell[195597, 7375, 120, 2, 21, "Print",
  CellTags->"General::partialinfo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[195778, 7384, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::strbox"],
Cell[195864, 7387, 438, 12, 19, "Message",
  CellTags->"General::strbox"],
Cell[196305, 7401, 221, 5, 42, "Notes",
  CellTags->"General::strbox"],

Cell[CellGroupData[{
Cell[196551, 7410, 65, 1, 38, "ExampleSection",
  CellTags->"General::strbox"],
Cell[196619, 7413, 88, 1, 22, "Text",
  CellTags->"General::strbox"],

Cell[CellGroupData[{
Cell[196732, 7418, 109, 3, 26, "Input",
  CellTags->"General::strbox"],
Cell[196844, 7423, 301, 7, 21, "Print",
  CellTags->"General::strbox"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[197206, 7437, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::uinfix"],
Cell[197292, 7440, 219, 5, 19, "Message",
  CellTags->"General::uinfix"],
Cell[197514, 7447, 220, 5, 42, "Notes",
  CellTags->"General::uinfix"],

Cell[CellGroupData[{
Cell[197759, 7456, 65, 1, 38, "ExampleSection",
  CellTags->"General::uinfix"],
Cell[197827, 7459, 88, 1, 22, "Text",
  CellTags->"General::uinfix"],

Cell[CellGroupData[{
Cell[197940, 7464, 106, 3, 26, "Input",
  CellTags->"General::uinfix"],
Cell[198049, 7469, 164, 3, 21, "Print",
  CellTags->"General::uinfix"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[198274, 7479, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::uprefix"],
Cell[198362, 7482, 216, 5, 19, "Message",
  CellTags->"General::uprefix"],
Cell[198581, 7489, 214, 5, 42, "Notes",
  CellTags->"General::uprefix"],

Cell[CellGroupData[{
Cell[198820, 7498, 66, 1, 38, "ExampleSection",
  CellTags->"General::uprefix"],
Cell[198889, 7501, 89, 1, 22, "Text",
  CellTags->"General::uprefix"],

Cell[CellGroupData[{
Cell[199003, 7506, 100, 3, 26, "Input",
  CellTags->"General::uprefix"],
Cell[199106, 7511, 146, 3, 21, "Print",
  CellTags->"General::uprefix"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[199313, 7521, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::upreinfix"],
Cell[199405, 7524, 294, 6, 53, "Message",
  CellTags->"General::upreinfix"],
Cell[199702, 7532, 244, 5, 46, "Notes",
  CellTags->"General::upreinfix"],

Cell[CellGroupData[{
Cell[199971, 7541, 68, 1, 38, "ExampleSection",
  CellTags->"General::upreinfix"],
Cell[200042, 7544, 91, 1, 24, "Text",
  CellTags->"General::upreinfix"],

Cell[CellGroupData[{
Cell[200158, 7549, 122, 3, 26, "Input",
  CellTags->"General::upreinfix"],
Cell[200283, 7554, 250, 4, 37, "Print",
  CellTags->"General::upreinfix"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[200594, 7565, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::suminfo"],
Cell[200682, 7568, 199, 5, 23, "Message",
  CellTags->"General::suminfo"],
Cell[200884, 7575, 215, 5, 46, "Notes",
  CellTags->"General::suminfo"],

Cell[CellGroupData[{
Cell[201124, 7584, 66, 1, 38, "ExampleSection",
  CellTags->"General::suminfo"],
Cell[201193, 7587, 89, 1, 24, "Text",
  CellTags->"General::suminfo"],

Cell[CellGroupData[{
Cell[201307, 7592, 100, 3, 26, "Input",
  CellTags->"General::suminfo"],
Cell[201410, 7597, 128, 3, 29, "Print",
  CellTags->"General::suminfo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[201599, 7607, 274, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype", 
    "Experimental`BinaryImport::chtype"}],
Cell[201876, 7617, 499, 13, 21, "Message",
  CellTags->{
  "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype", 
    "Experimental`BinaryImport::chtype"}],
Cell[202378, 7632, 791, 20, 100, "Notes",
  CellTags->{
  "Export::chtype", "Import::chtype", "Experimental`BinaryExport::chtype", 
    "Experimental`BinaryImport::chtype"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[203206, 7657, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::coerce"],
Cell[203290, 7660, 162, 4, 21, "Message",
  CellTags->"Export::coerce"],
Cell[203455, 7666, 530, 13, 84, "Notes",
  CellTags->"Export::coerce"],

Cell[CellGroupData[{
Cell[204010, 7683, 64, 1, 38, "ExampleSection",
  CellTags->"Export::coerce"],
Cell[204077, 7686, 263, 6, 40, "Text",
  CellTags->"Export::coerce"],

Cell[CellGroupData[{
Cell[204365, 7696, 143, 3, 26, "Input",
  CellTags->"Export::coerce"],
Cell[204511, 7701, 195, 4, 21, "Message",
  CellTags->"Export::coerce"],
Cell[204709, 7707, 98, 3, 21, "Output",
  CellTags->"Export::coerce"]
}, Open  ]],
Cell[204822, 7713, 67, 1, 24, "Text",
  CellTags->"Export::coerce"],
Cell[204892, 7716, 113, 3, 26, "Input",
  CellTags->"Export::coerce"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[205054, 7725, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::dffsr"],
Cell[205136, 7728, 154, 3, 21, "Message",
  CellTags->"Export::dffsr"],
Cell[205293, 7733, 471, 13, 62, "Notes",
  CellTags->"Export::dffsr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[205801, 7751, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::bitcon"],
Cell[205885, 7754, 429, 11, 37, "Message",
  CellTags->"Export::bitcon"],
Cell[206317, 7767, 125, 4, 24, "Notes",
  CellTags->"Export::bitcon"]
}, Open  ]],

Cell[CellGroupData[{
Cell[206479, 7776, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::bitrange"],
Cell[206567, 7779, 406, 11, 21, "Message",
  CellTags->"Export::bitrange"],
Cell[206976, 7792, 127, 4, 24, "Notes",
  CellTags->"Export::bitrange"]
}, Open  ]],

Cell[CellGroupData[{
Cell[207140, 7801, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::bitval"],
Cell[207224, 7804, 314, 8, 21, "Message",
  CellTags->"Export::bitval"],
Cell[207541, 7814, 125, 4, 24, "Notes",
  CellTags->"Export::bitval"]
}, Open  ]],

Cell[CellGroupData[{
Cell[207703, 7823, 128, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Export::errfile", "Import::errfile"}],
Cell[207834, 7829, 420, 11, 21, "Message",
  CellTags->{"Export::errfile", "Import::errfile"}],
Cell[208257, 7842, 147, 4, 24, "Notes",
  CellTags->{"Export::errfile", "Import::errfile"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[208441, 7851, 136, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Export::errstruct", "Import::errstruct"}],
Cell[208580, 7857, 334, 10, 21, "Message",
  CellTags->{"Export::errstruct", "Import::errstruct"}],
Cell[208917, 7869, 151, 4, 24, "Notes",
  CellTags->{"Export::errstruct", "Import::errstruct"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[209105, 7878, 112, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Export::obs", "Import::obs"}],
Cell[209220, 7884, 306, 10, 21, "Message",
  CellTags->{"Export::obs", "Import::obs"}],
Cell[209529, 7896, 139, 4, 24, "Notes",
  CellTags->{"Export::obs", "Import::obs"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[209705, 7905, 124, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Export::obsalt", "Import::obsalt"}],
Cell[209832, 7911, 333, 10, 21, "Message",
  CellTags->{"Export::obsalt", "Import::obsalt"}],
Cell[210168, 7923, 145, 4, 22, "Notes",
  CellTags->{"Export::obsalt", "Import::obsalt"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[210350, 7932, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::no2dgr"],
Cell[210434, 7935, 621, 15, 33, "Message",
  CellTags->"Export::no2dgr"],
Cell[211058, 7952, 125, 4, 22, "Notes",
  CellTags->"Export::no2dgr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[211220, 7961, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::nocomp"],
Cell[211304, 7964, 484, 10, 33, "Message",
  CellTags->"Export::nocomp"],
Cell[211791, 7976, 125, 4, 22, "Notes",
  CellTags->"Export::nocomp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[211953, 7985, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::nodir"],
Cell[212035, 7988, 267, 7, 19, "Message",
  CellTags->"Export::nodir"],
Cell[212305, 7997, 124, 4, 22, "Notes",
  CellTags->"Export::nodir"]
}, Open  ]],

Cell[CellGroupData[{
Cell[212466, 8006, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::autofix"],
Cell[212552, 8009, 449, 7, 61, "Message",
  CellTags->"Export::autofix"],
Cell[213004, 8018, 126, 4, 22, "Notes",
  CellTags->"Export::autofix"]
}, Open  ]],

Cell[CellGroupData[{
Cell[213167, 8027, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::badqte"],
Cell[213251, 8030, 543, 11, 33, "Message",
  CellTags->"Export::badqte"],
Cell[213797, 8043, 125, 4, 22, "Notes",
  CellTags->"Export::badqte"]
}, Open  ]],

Cell[CellGroupData[{
Cell[213959, 8052, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::malsxml"],
Cell[214045, 8055, 429, 10, 33, "Message",
  CellTags->"Export::malsxml"],
Cell[214477, 8067, 126, 4, 22, "Notes",
  CellTags->"Export::malsxml"]
}, Open  ]],

Cell[CellGroupData[{
Cell[214640, 8076, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::unrecov"],
Cell[214726, 8079, 189, 3, 19, "Message",
  CellTags->"Export::unrecov"],
Cell[214918, 8084, 126, 4, 22, "Notes",
  CellTags->"Export::unrecov"]
}, Open  ]],

Cell[CellGroupData[{
Cell[215081, 8093, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::xmlmal"],
Cell[215165, 8096, 327, 8, 21, "Message",
  CellTags->"Export::xmlmal"],
Cell[215495, 8106, 125, 4, 24, "Notes",
  CellTags->"Export::xmlmal"]
}, Open  ]],

Cell[CellGroupData[{
Cell[215657, 8115, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::xmlnopt"],
Cell[215743, 8118, 451, 11, 37, "Message",
  CellTags->"Export::xmlnopt"],
Cell[216197, 8131, 126, 4, 24, "Notes",
  CellTags->"Export::xmlnopt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[216360, 8140, 124, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Export::fmterr", "Import::fmterr"}],
Cell[216487, 8146, 327, 9, 21, "Message",
  CellTags->{"Export::fmterr", "Import::fmterr"}],
Cell[216817, 8157, 315, 8, 40, "Notes",
  CellTags->{"Export::fmterr", "Import::fmterr"}],

Cell[CellGroupData[{
Cell[217157, 8169, 84, 1, 38, "ExampleSection",
  CellTags->{"Export::fmterr", "Import::fmterr"}],
Cell[217244, 8172, 175, 4, 24, "Text",
  CellTags->{"Export::fmterr", "Import::fmterr"}],

Cell[CellGroupData[{
Cell[217444, 8180, 152, 3, 26, "Input",
  CellTags->{"Export::fmterr", "Import::fmterr"}],
Cell[217599, 8185, 118, 3, 21, "Output",
  CellTags->{"Export::fmterr", "Import::fmterr"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[217754, 8193, 140, 3, 26, "Input",
  CellTags->{"Export::fmterr", "Import::fmterr"}],
Cell[217897, 8198, 185, 4, 21, "Message",
  CellTags->{"Export::fmterr", "Import::fmterr"}],
Cell[218085, 8204, 115, 3, 21, "Output",
  CellTags->{"Export::fmterr", "Import::fmterr"}]
}, Open  ]],
Cell[218215, 8210, 87, 1, 24, "Text",
  CellTags->{"Export::fmterr", "Import::fmterr"}],
Cell[218305, 8213, 133, 3, 26, "Input",
  CellTags->{"Export::fmterr", "Import::fmterr"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[218487, 8222, 545, 15, 171, "ObjectNameWarningMessages",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],
Cell[219035, 8239, 574, 15, 21, "Message",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],
Cell[219612, 8256, 1083, 26, 138, "Notes",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],

Cell[CellGroupData[{
Cell[220720, 8286, 315, 6, 38, "ExampleSection",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],
Cell[221038, 8294, 420, 10, 24, "Text",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],

Cell[CellGroupData[{
Cell[221483, 8308, 372, 8, 26, "Input",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],
Cell[221858, 8318, 451, 10, 21, "Message",
  CellTags->{
  "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format", "Export::format", 
    "ExportString::format", "Import::format", "ImportString::format"}],
Cell[222312, 8330, 369, 8, 21, "Output",
  CellTags->{
  "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format", "Export::format", 
    "ExportString::format", "Import::format", "ImportString::format"}]
}, Open  ]],
Cell[222696, 8341, 383, 10, 24, "Text",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],

Cell[CellGroupData[{
Cell[223104, 8355, 373, 8, 26, "Input",
  CellTags->{
  "Export::format", "ExportString::format", "Import::format", 
    "ImportString::format", "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format"}],
Cell[223480, 8365, 344, 8, 21, "Output",
  CellTags->{
  "Experimental`BinaryExport::format", 
    "Experimental`BinaryExportString::format", 
    "Experimental`BinaryImport::format", 
    "Experimental`BinaryImportString::format", "Export::format", 
    "ExportString::format", "Import::format", "ImportString::format"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[223885, 8380, 120, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Export::guess", "Import::guess"}],
Cell[224008, 8386, 399, 11, 21, "Message",
  CellTags->{"Export::guess", "Import::guess"}],
Cell[224410, 8399, 600, 17, 84, "Notes",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[CellGroupData[{
Cell[225035, 8420, 82, 1, 38, "ExampleSection",
  CellTags->{"Export::guess", "Import::guess"}],
Cell[225120, 8423, 198, 4, 40, "Text",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[CellGroupData[{
Cell[225343, 8431, 138, 3, 26, "Input",
  CellTags->{"Export::guess", "Import::guess"}],
Cell[225484, 8436, 210, 5, 21, "Message",
  CellTags->{"Export::guess", "Import::guess"}],
Cell[225697, 8443, 131, 3, 21, "Output",
  CellTags->{"Export::guess", "Import::guess"}]
}, Open  ]],
Cell[225843, 8449, 170, 4, 24, "Text",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[CellGroupData[{
Cell[226038, 8457, 142, 3, 26, "Input",
  CellTags->{"Export::guess", "Import::guess"}],
Cell[226183, 8462, 120, 3, 21, "Output",
  CellTags->{"Export::guess", "Import::guess"}]
}, Open  ]],
Cell[226318, 8468, 211, 6, 24, "Text",
  CellTags->{"Export::guess", "Import::guess"}],

Cell[CellGroupData[{
Cell[226554, 8478, 150, 3, 26, "Input",
  CellTags->{"Export::guess", "Import::guess"}],
Cell[226707, 8483, 116, 3, 21, "Output",
  CellTags->{"Export::guess", "Import::guess"}]
}, Open  ]],
Cell[226838, 8489, 86, 1, 24, "Text",
  CellTags->{"Export::guess", "Import::guess"}],
Cell[226927, 8492, 153, 3, 26, "Input",
  CellTags->{"Export::guess", "Import::guess"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[227129, 8501, 162, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Export::ignore", "Experimental`BinaryExport::ignore"}],
Cell[227294, 8507, 372, 10, 21, "Message",
  CellTags->{"Export::ignore", "Experimental`BinaryExport::ignore"}],
Cell[227669, 8519, 233, 6, 24, "Notes",
  CellTags->{"Export::ignore", "Experimental`BinaryExport::ignore"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[227939, 8530, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::memavail"],
Cell[228027, 8533, 192, 4, 21, "Message",
  CellTags->"Export::memavail"],
Cell[228222, 8539, 196, 6, 24, "Notes",
  CellTags->"Export::memavail"]
}, Open  ]],

Cell[CellGroupData[{
Cell[228455, 8550, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::memavail"],
Cell[228543, 8553, 332, 7, 21, "Message",
  CellTags->"Import::memavail"],
Cell[228878, 8562, 196, 6, 24, "Notes",
  CellTags->"Import::memavail"]
}, Open  ]],

Cell[CellGroupData[{
Cell[229111, 8573, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::nofe"],
Cell[229191, 8576, 200, 5, 19, "Message",
  CellTags->"Export::nofe"],
Cell[229394, 8583, 610, 16, 74, "Notes",
  CellTags->"Export::nofe"]
}, Open  ]],

Cell[CellGroupData[{
Cell[230041, 8604, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::nomatch"],
Cell[230127, 8607, 360, 10, 19, "Message",
  CellTags->"Export::nomatch"],
Cell[230490, 8619, 195, 6, 24, "Notes",
  CellTags->"Export::nomatch"]
}, Open  ]],

Cell[CellGroupData[{
Cell[230722, 8630, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::type"],
Cell[230802, 8633, 355, 10, 19, "Message",
  CellTags->"Export::type"],
Cell[231160, 8645, 323, 7, 43, "Notes",
  CellTags->"Export::type"],

Cell[CellGroupData[{
Cell[231508, 8656, 62, 1, 38, "ExampleSection",
  CellTags->"Export::type"],
Cell[231573, 8659, 172, 5, 23, "Text",
  CellTags->"Export::type"],

Cell[CellGroupData[{
Cell[231770, 8668, 124, 3, 26, "Input",
  CellTags->"Export::type"],
Cell[231897, 8673, 192, 5, 19, "Message",
  CellTags->"Export::type"],
Cell[232092, 8680, 93, 3, 25, "Output",
  CellTags->"Export::type"]
}, Open  ]],
Cell[232200, 8686, 137, 5, 23, "Text",
  CellTags->"Export::type"],

Cell[CellGroupData[{
Cell[232362, 8695, 130, 3, 26, "Input",
  CellTags->"Export::type"],
Cell[232495, 8700, 96, 3, 25, "Output",
  CellTags->"Export::type"]
}, Open  ]],
Cell[232606, 8706, 98, 1, 22, "Text",
  CellTags->"Export::type"],
Cell[232707, 8709, 111, 3, 26, "Input",
  CellTags->"Export::type"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[232867, 8718, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Export::unsupfmt", "Import::unsupfmt"}],
Cell[233002, 8724, 440, 11, 19, "Message",
  CellTags->{"Export::unsupfmt", "Import::unsupfmt"}],
Cell[233445, 8737, 422, 8, 56, "Notes",
  CellTags->{"Export::unsupfmt", "Import::unsupfmt"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[233904, 8750, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::createdir"],
Cell[233994, 8753, 377, 7, 85, "Message",
  CellTags->"Export::createdir"],
Cell[234374, 8762, 181, 5, 24, "Notes",
  CellTags->"Export::createdir"]
}, Open  ]],

Cell[CellGroupData[{
Cell[234592, 8772, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Get::notencode"],
Cell[234676, 8775, 174, 4, 21, "Message",
  CellTags->"Get::notencode"],
Cell[234853, 8781, 473, 11, 68, "Notes",
  CellTags->"Get::notencode"],

Cell[CellGroupData[{
Cell[235351, 8796, 64, 1, 38, "ExampleSection",
  CellTags->"Get::notencode"],
Cell[235418, 8799, 229, 6, 40, "Text",
  CellTags->"Get::notencode"],

Cell[CellGroupData[{
Cell[235672, 8809, 142, 3, 26, "Input",
  CellTags->"Get::notencode"],
Cell[235817, 8814, 98, 3, 21, "Output",
  CellTags->"Get::notencode"]
}, Open  ]],

Cell[CellGroupData[{
Cell[235952, 8822, 111, 3, 26, "Input",
  CellTags->"Get::notencode"],
Cell[236066, 8827, 188, 4, 21, "Message",
  CellTags->"Get::notencode"],
Cell[236257, 8833, 93, 3, 21, "Output",
  CellTags->"Get::notencode"]
}, Open  ]],
Cell[236365, 8839, 67, 1, 24, "Text",
  CellTags->"Get::notencode"],
Cell[236435, 8842, 113, 3, 26, "Input",
  CellTags->"Get::notencode"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[236597, 8851, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::fnfnd"],
Cell[236679, 8854, 148, 3, 21, "Message",
  CellTags->"Import::fnfnd"],
Cell[236830, 8859, 170, 5, 24, "Notes",
  CellTags->"Import::fnfnd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[237037, 8869, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::imgsze"],
Cell[237121, 8872, 234, 5, 37, "Message",
  CellTags->"Import::imgsze"],
Cell[237358, 8879, 230, 6, 40, "Notes",
  CellTags->"Import::imgsze"]
}, Open  ]],

Cell[CellGroupData[{
Cell[237625, 8890, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::intp"],
Cell[237705, 8893, 163, 4, 21, "Message",
  CellTags->"Import::intp"],
Cell[237871, 8899, 192, 6, 24, "Notes",
  CellTags->"Import::intp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[238100, 8910, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::nffil"],
Cell[238182, 8913, 161, 4, 21, "Message",
  CellTags->"Import::nffil"],
Cell[238346, 8919, 468, 11, 84, "Notes",
  CellTags->"Import::nffil"]
}, Open  ]],

Cell[CellGroupData[{
Cell[238851, 8935, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::nlist"],
Cell[238933, 8938, 164, 4, 21, "Message",
  CellTags->"Import::nlist"],
Cell[239100, 8944, 193, 6, 24, "Notes",
  CellTags->"Import::nlist"]
}, Open  ]],

Cell[CellGroupData[{
Cell[239330, 8955, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::nlist2"],
Cell[239414, 8958, 319, 8, 21, "Message",
  CellTags->"Import::nlist2"],
Cell[239736, 8968, 194, 6, 24, "Notes",
  CellTags->"Import::nlist2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[239967, 8979, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ImportString::string"],
Cell[240063, 8982, 184, 4, 21, "Message",
  CellTags->"ImportString::string"],
Cell[240250, 8988, 184, 5, 24, "Notes",
  CellTags->"ImportString::string"],

Cell[CellGroupData[{
Cell[240459, 8997, 70, 1, 38, "ExampleSection",
  CellTags->"ImportString::string"],
Cell[240532, 9000, 137, 4, 24, "Text",
  CellTags->"ImportString::string"],

Cell[CellGroupData[{
Cell[240694, 9008, 116, 3, 26, "Input",
  CellTags->"ImportString::string"],
Cell[240813, 9013, 189, 4, 21, "Message",
  CellTags->"ImportString::string"],
Cell[241005, 9019, 117, 3, 21, "Output",
  CellTags->"ImportString::string"]
}, Open  ]],
Cell[241137, 9025, 139, 5, 24, "Text",
  CellTags->"ImportString::string"],

Cell[CellGroupData[{
Cell[241301, 9034, 128, 3, 26, "Input",
  CellTags->"ImportString::string"],
Cell[241432, 9039, 99, 3, 21, "Output",
  CellTags->"ImportString::string"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[241592, 9049, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::nodta"],
Cell[241674, 9052, 174, 4, 21, "Message",
  CellTags->"Import::nodta"],
Cell[241851, 9058, 159, 4, 24, "Notes",
  CellTags->"Import::nodta"]
}, Open  ]],

Cell[CellGroupData[{
Cell[242047, 9067, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::unsup"],
Cell[242129, 9070, 163, 4, 21, "Message",
  CellTags->"Import::unsup"],
Cell[242295, 9076, 310, 7, 62, "Notes",
  CellTags->"Import::unsup"]
}, Open  ]],

Cell[CellGroupData[{
Cell[242642, 9088, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$NumberMarks::nmarkset"],
Cell[242742, 9091, 473, 12, 37, "Message",
  CellTags->"$NumberMarks::nmarkset"],
Cell[243218, 9105, 309, 11, 40, "Notes",
  CellTags->"$NumberMarks::nmarkset"],

Cell[CellGroupData[{
Cell[243552, 9120, 72, 1, 38, "ExampleSection",
  CellTags->"$NumberMarks::nmarkset"],
Cell[243627, 9123, 267, 9, 40, "Text",
  CellTags->"$NumberMarks::nmarkset"],

Cell[CellGroupData[{
Cell[243919, 9136, 114, 3, 26, "Input",
  CellTags->"$NumberMarks::nmarkset"],
Cell[244036, 9141, 247, 5, 37, "Message",
  CellTags->"$NumberMarks::nmarkset"],
Cell[244286, 9148, 100, 3, 21, "Output",
  CellTags->"$NumberMarks::nmarkset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[244447, 9158, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Integrate::diffend"],
Cell[244539, 9161, 298, 6, 69, "Message",
  CellTags->"Integrate::diffend"],
Cell[244840, 9169, 253, 6, 40, "Notes",
  CellTags->"Integrate::diffend"],

Cell[CellGroupData[{
Cell[245118, 9179, 68, 1, 38, "ExampleSection",
  CellTags->"Integrate::diffend"],
Cell[245189, 9182, 155, 4, 24, "Text",
  CellTags->"Integrate::diffend"],

Cell[CellGroupData[{
Cell[245369, 9190, 130, 3, 40, "Input",
  CellTags->"Integrate::diffend"],
Cell[245502, 9195, 423, 7, 61, "Message",
  CellTags->"Integrate::diffend"],
Cell[245928, 9204, 198, 5, 31, "Message",
  CellTags->"Integrate::diffend"]
}, Open  ]],
Cell[246141, 9212, 99, 1, 22, "Text",
  CellTags->"Integrate::diffend"],

Cell[CellGroupData[{
Cell[246265, 9217, 129, 3, 40, "Input",
  CellTags->"Integrate::diffend"],
Cell[246397, 9222, 110, 3, 25, "Output",
  CellTags->"Integrate::diffend"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[246568, 9232, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ToExpression::notstrbox"],
Cell[246670, 9235, 257, 5, 33, "Message",
  CellTags->"ToExpression::notstrbox"],
Cell[246930, 9242, 215, 5, 23, "Notes",
  CellTags->"ToExpression::notstrbox"],

Cell[CellGroupData[{
Cell[247170, 9251, 73, 1, 38, "ExampleSection",
  CellTags->"ToExpression::notstrbox"],
Cell[247246, 9254, 200, 5, 23, "Text",
  CellTags->"ToExpression::notstrbox"],

Cell[CellGroupData[{
Cell[247471, 9263, 116, 3, 26, "Input",
  CellTags->"ToExpression::notstrbox"],
Cell[247590, 9268, 282, 5, 33, "Message",
  CellTags->"ToExpression::notstrbox"],
Cell[247875, 9275, 104, 3, 25, "Output",
  CellTags->"ToExpression::notstrbox"]
}, Open  ]],
Cell[247994, 9281, 173, 5, 23, "Text",
  CellTags->"ToExpression::notstrbox"],

Cell[CellGroupData[{
Cell[248192, 9290, 146, 3, 26, "Input",
  CellTags->"ToExpression::notstrbox"],
Cell[248341, 9295, 120, 3, 25, "Output",
  CellTags->"ToExpression::notstrbox"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[248522, 9305, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Syntax::com"],
Cell[248600, 9308, 232, 5, 33, "Message",
  CellTags->"Syntax::com"],
Cell[248835, 9315, 518, 10, 90, "Notes",
  CellTags->"Syntax::com"],

Cell[CellGroupData[{
Cell[249378, 9329, 61, 1, 38, "ExampleSection",
  CellTags->"Syntax::com"],
Cell[249442, 9332, 188, 5, 24, "Text",
  CellTags->"Syntax::com"],

Cell[CellGroupData[{
Cell[249655, 9341, 128, 3, 26, "Input",
  CellTags->"Syntax::com"],
Cell[249786, 9346, 241, 5, 53, "Message",
  CellTags->"Syntax::com"],
Cell[250030, 9353, 86, 3, 21, "Output",
  CellTags->"Syntax::com"]
}, Open  ]],
Cell[250131, 9359, 183, 5, 40, "Text",
  CellTags->"Syntax::com"],

Cell[CellGroupData[{
Cell[250339, 9368, 132, 3, 26, "Input",
  CellTags->"Syntax::com"],
Cell[250474, 9373, 86, 3, 21, "Output",
  CellTags->"Syntax::com"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[250621, 9383, 119, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`BinaryExport::coerce"],
Cell[250743, 9386, 183, 3, 21, "Message",
  CellTags->"Experimental`BinaryExport::coerce"],
Cell[250929, 9391, 144, 4, 24, "Notes",
  CellTags->"Experimental`BinaryExport::coerce"]
}, Open  ]],

Cell[CellGroupData[{
Cell[251110, 9400, 121, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`BinaryExport::nomatch"],
Cell[251234, 9403, 208, 3, 37, "Message",
  CellTags->"Experimental`BinaryExport::nomatch"],
Cell[251445, 9408, 145, 4, 24, "Notes",
  CellTags->"Experimental`BinaryExport::nomatch"]
}, Open  ]],

Cell[CellGroupData[{
Cell[251627, 9417, 117, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`BinaryImport::nffil"],
Cell[251747, 9420, 182, 3, 21, "Message",
  CellTags->"Experimental`BinaryImport::nffil"],
Cell[251932, 9425, 143, 4, 24, "Notes",
  CellTags->"Experimental`BinaryImport::nffil"]
}, Open  ]],

Cell[CellGroupData[{
Cell[252112, 9434, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::dxfemp"],
Cell[252196, 9437, 194, 3, 37, "Message",
  CellTags->"Import::dxfemp"],
Cell[252393, 9442, 125, 4, 24, "Notes",
  CellTags->"Import::dxfemp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[252555, 9451, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::dxfflg"],
Cell[252639, 9454, 186, 3, 21, "Message",
  CellTags->"Import::dxfflg"],
Cell[252828, 9459, 125, 4, 24, "Notes",
  CellTags->"Import::dxfflg"]
}, Open  ]],

Cell[CellGroupData[{
Cell[252990, 9468, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::dxflin"],
Cell[253074, 9471, 253, 4, 37, "Message",
  CellTags->"Import::dxflin"],
Cell[253330, 9477, 125, 4, 24, "Notes",
  CellTags->"Import::dxflin"]
}, Open  ]],

Cell[CellGroupData[{
Cell[253492, 9486, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::dxfply"],
Cell[253576, 9489, 223, 4, 37, "Message",
  CellTags->"Import::dxfply"],
Cell[253802, 9495, 125, 4, 24, "Notes",
  CellTags->"Import::dxfply"]
}, Open  ]],

Cell[CellGroupData[{
Cell[253964, 9504, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::dxfvbf"],
Cell[254048, 9507, 232, 4, 37, "Message",
  CellTags->"Import::dxfvbf"],
Cell[254283, 9513, 125, 4, 24, "Notes",
  CellTags->"Import::dxfvbf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[254445, 9522, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::nonintyear"],
Cell[254537, 9525, 568, 9, 117, "Message",
  CellTags->"Import::nonintyear"],
Cell[255108, 9536, 129, 4, 24, "Notes",
  CellTags->"Import::nonintyear"]
}, Open  ]],

Cell[CellGroupData[{
Cell[255274, 9545, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::costr"],
Cell[255356, 9548, 215, 4, 37, "Message",
  CellTags->"Import::costr"],
Cell[255574, 9554, 124, 4, 24, "Notes",
  CellTags->"Import::costr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[255735, 9563, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::malxml"],
Cell[255819, 9566, 234, 4, 53, "Message",
  CellTags->"Import::malxml"],
Cell[256056, 9572, 125, 4, 24, "Notes",
  CellTags->"Import::malxml"]
}, Open  ]],

Cell[CellGroupData[{
Cell[256218, 9581, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::pdtder"],
Cell[256302, 9584, 381, 7, 85, "Message",
  CellTags->"Import::pdtder"],
Cell[256686, 9593, 125, 4, 24, "Notes",
  CellTags->"Import::pdtder"]
}, Open  ]],

Cell[CellGroupData[{
Cell[256848, 9602, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::unrecxml"],
Cell[256936, 9605, 235, 5, 37, "Message",
  CellTags->"Import::unrecxml"],
Cell[257174, 9612, 127, 4, 24, "Notes",
  CellTags->"Import::unrecxml"]
}, Open  ]],

Cell[CellGroupData[{
Cell[257338, 9621, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"MathMLForm::boxfmt"],
Cell[257430, 9624, 388, 7, 53, "Message",
  CellTags->"MathMLForm::boxfmt"],
Cell[257821, 9633, 129, 4, 24, "Notes",
  CellTags->"MathMLForm::boxfmt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[257987, 9642, 137, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`RegisterConverter::extensions"],
Cell[258127, 9645, 246, 4, 37, "Message",
  CellTags->"Experimental`RegisterConverter::extensions"],
Cell[258376, 9651, 153, 4, 24, "Notes",
  CellTags->"Experimental`RegisterConverter::extensions"]
}, Open  ]],

Cell[CellGroupData[{
Cell[258566, 9660, 125, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`RegisterConverter::mode"],
Cell[258694, 9663, 240, 4, 37, "Message",
  CellTags->"Experimental`RegisterConverter::mode"],
Cell[258937, 9669, 147, 4, 24, "Notes",
  CellTags->"Experimental`RegisterConverter::mode"]
}, Open  ]],

Cell[CellGroupData[{
Cell[259121, 9678, 127, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`RegisterConverter::noexe"],
Cell[259251, 9681, 219, 3, 37, "Message",
  CellTags->"Experimental`RegisterConverter::noexe"],
Cell[259473, 9686, 148, 4, 24, "Notes",
  CellTags->"Experimental`RegisterConverter::noexe"]
}, Open  ]],

Cell[CellGroupData[{
Cell[259658, 9695, 129, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`RegisterConverter::source"],
Cell[259790, 9698, 261, 4, 37, "Message",
  CellTags->"Experimental`RegisterConverter::source"],
Cell[260054, 9704, 149, 4, 24, "Notes",
  CellTags->"Experimental`RegisterConverter::source"]
}, Open  ]],

Cell[CellGroupData[{
Cell[260240, 9713, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::boxfmt"],
Cell[260326, 9716, 326, 9, 37, "Message",
  CellTags->"General::boxfmt"],
Cell[260655, 9727, 361, 9, 46, "Notes",
  CellTags->"General::boxfmt"],

Cell[CellGroupData[{
Cell[261041, 9740, 65, 1, 38, "ExampleSection",
  CellTags->"General::boxfmt"],
Cell[261109, 9743, 220, 7, 24, "Text",
  CellTags->"General::boxfmt"],

Cell[CellGroupData[{
Cell[261354, 9754, 115, 3, 26, "Input",
  CellTags->"General::boxfmt"],
Cell[261472, 9759, 291, 6, 53, "Message",
  CellTags->"General::boxfmt"],
Cell[261766, 9767, 116, 3, 21, "Output",
  CellTags->"General::boxfmt"]
}, Open  ]],
Cell[261897, 9773, 198, 7, 24, "Text",
  CellTags->"General::boxfmt"],

Cell[CellGroupData[{
Cell[262120, 9784, 97, 3, 26, "Input",
  CellTags->"General::boxfmt"],
Cell[262220, 9789, 129, 3, 21, "Output",
  CellTags->"General::boxfmt"]
}, Open  ]],
Cell[262364, 9795, 129, 5, 24, "Text",
  CellTags->"General::boxfmt"],

Cell[CellGroupData[{
Cell[262518, 9804, 120, 3, 26, "Input",
  CellTags->"General::boxfmt"],
Cell[262641, 9809, 145, 3, 21, "Output",
  CellTags->"General::boxfmt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[262847, 9819, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::byteord"],
Cell[262935, 9822, 263, 7, 21, "Message",
  CellTags->"General::byteord"],
Cell[263201, 9831, 127, 4, 24, "Notes",
  CellTags->"General::byteord"]
}, Open  ]],

Cell[CellGroupData[{
Cell[263365, 9840, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::conopt"],
Cell[263451, 9843, 316, 8, 37, "Message",
  CellTags->"General::conopt"],
Cell[263770, 9853, 126, 4, 24, "Notes",
  CellTags->"General::conopt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[263933, 9862, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::interpfmt"],
Cell[264025, 9865, 358, 9, 37, "Message",
  CellTags->"General::interpfmt"],
Cell[264386, 9876, 129, 4, 24, "Notes",
  CellTags->"General::interpfmt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[264552, 9885, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::notstr"],
Cell[264638, 9888, 264, 7, 21, "Message",
  CellTags->"General::notstr"],
Cell[264905, 9897, 266, 8, 40, "Notes",
  CellTags->"General::notstr"],

Cell[CellGroupData[{
Cell[265196, 9909, 65, 1, 38, "ExampleSection",
  CellTags->"General::notstr"],
Cell[265264, 9912, 208, 7, 24, "Text",
  CellTags->"General::notstr"],

Cell[CellGroupData[{
Cell[265497, 9923, 156, 4, 26, "Input",
  CellTags->"General::notstr"],
Cell[265656, 9929, 208, 5, 37, "Message",
  CellTags->"General::notstr"],
Cell[265867, 9936, 138, 3, 21, "Output",
  CellTags->"General::notstr"]
}, Open  ]],
Cell[266020, 9942, 126, 5, 24, "Text",
  CellTags->"General::notstr"],

Cell[CellGroupData[{
Cell[266171, 9951, 125, 3, 26, "Input",
  CellTags->"General::notstr"],
Cell[266299, 9956, 98, 3, 25, "Output",
  CellTags->"General::notstr"]
}, Open  ]],
Cell[266412, 9962, 200, 7, 23, "Text",
  CellTags->"General::notstr"],

Cell[CellGroupData[{
Cell[266637, 9973, 159, 4, 26, "Input",
  CellTags->"General::notstr"],
Cell[266799, 9979, 98, 3, 25, "Output",
  CellTags->"General::notstr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[266958, 9989, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"MessageName::messg"],
Cell[267050, 9992, 447, 11, 19, "Message",
  CellTags->"MessageName::messg"],
Cell[267500, 10005, 590, 18, 56, "Notes",
  CellTags->"MessageName::messg"],

Cell[CellGroupData[{
Cell[268115, 10027, 68, 1, 38, "ExampleSection",
  CellTags->"MessageName::messg"],
Cell[268186, 10030, 183, 5, 23, "Text",
  CellTags->"MessageName::messg"],

Cell[CellGroupData[{
Cell[268394, 10039, 104, 3, 26, "Input",
  CellTags->"MessageName::messg"],
Cell[268501, 10044, 221, 5, 19, "Message",
  CellTags->"MessageName::messg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[268783, 10056, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Get::enkey"],
Cell[268859, 10059, 174, 3, 19, "Message",
  CellTags->"Get::enkey"],
Cell[269036, 10064, 644, 15, 90, "Notes",
  CellTags->"Get::enkey"]
}, Open  ]],

Cell[CellGroupData[{
Cell[269717, 10084, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Save::wtype"],
Cell[269795, 10087, 204, 5, 19, "Message",
  CellTags->"Save::wtype"],
Cell[270002, 10094, 184, 5, 23, "Notes",
  CellTags->"Save::wtype"],

Cell[CellGroupData[{
Cell[270211, 10103, 61, 1, 38, "ExampleSection",
  CellTags->"Save::wtype"],
Cell[270275, 10106, 143, 5, 23, "Text",
  CellTags->"Save::wtype"],

Cell[CellGroupData[{
Cell[270443, 10115, 111, 3, 26, "Input",
  CellTags->"Save::wtype"],
Cell[270557, 10120, 259, 5, 37, "Message",
  CellTags->"Save::wtype"],
Cell[270819, 10127, 108, 3, 21, "Output",
  CellTags->"Save::wtype"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[270988, 10137, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Close::spfile"],
Cell[271070, 10140, 220, 5, 21, "Message",
  CellTags->"Close::spfile"],
Cell[271293, 10147, 447, 9, 78, "Notes",
  CellTags->"Close::spfile"],

Cell[CellGroupData[{
Cell[271765, 10160, 63, 1, 38, "ExampleSection",
  CellTags->"Close::spfile"],
Cell[271831, 10163, 179, 5, 24, "Text",
  CellTags->"Close::spfile"],

Cell[CellGroupData[{
Cell[272035, 10172, 109, 3, 26, "Input",
  CellTags->"Close::spfile"],
Cell[272147, 10177, 204, 5, 21, "Message",
  CellTags->"Close::spfile"],
Cell[272354, 10184, 119, 3, 21, "Output",
  CellTags->"Close::spfile"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[272534, 10194, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DumpGet::bgbf"],
Cell[272616, 10197, 286, 6, 37, "Message",
  CellTags->"DumpGet::bgbf"],
Cell[272905, 10205, 541, 16, 62, "Notes",
  CellTags->"DumpGet::bgbf"],

Cell[CellGroupData[{
Cell[273471, 10225, 63, 1, 38, "ExampleSection",
  CellTags->"DumpGet::bgbf"],
Cell[273537, 10228, 243, 7, 40, "Text",
  CellTags->"DumpGet::bgbf"],
Cell[273783, 10237, 130, 3, 26, "Input",
  CellTags->"DumpGet::bgbf"],

Cell[CellGroupData[{
Cell[273938, 10244, 108, 3, 26, "Input",
  CellTags->"DumpGet::bgbf"],
Cell[274049, 10249, 230, 5, 37, "Message",
  CellTags->"DumpGet::bgbf"],
Cell[274282, 10256, 94, 3, 21, "Output",
  CellTags->"DumpGet::bgbf"]
}, Open  ]],
Cell[274391, 10262, 196, 7, 24, "Text",
  CellTags->"DumpGet::bgbf"],

Cell[CellGroupData[{
Cell[274612, 10273, 117, 3, 26, "Input",
  CellTags->"DumpGet::bgbf"],
Cell[274732, 10278, 91, 3, 25, "Output",
  CellTags->"DumpGet::bgbf"]
}, Open  ]],
Cell[274838, 10284, 108, 3, 26, "Input",
  CellTags->"DumpGet::bgbf"],
Cell[274949, 10289, 61, 1, 22, "Text",
  CellTags->"DumpGet::bgbf"],
Cell[275013, 10292, 111, 3, 26, "Input",
  CellTags->"DumpGet::bgbf"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[275173, 10301, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DumpGet::bgchk"],
Cell[275257, 10304, 180, 4, 19, "Message",
  CellTags->"DumpGet::bgchk"],
Cell[275440, 10310, 615, 17, 78, "Notes",
  CellTags->"DumpGet::bgchk"]
}, Open  ]],

Cell[CellGroupData[{
Cell[276092, 10332, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DumpGet::bgcor"],
Cell[276176, 10335, 227, 5, 19, "Message",
  CellTags->"DumpGet::bgcor"],
Cell[276406, 10342, 480, 13, 58, "Notes",
  CellTags->"DumpGet::bgcor"]
}, Open  ]],

Cell[CellGroupData[{
Cell[276923, 10360, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DumpGet::bgnew"],
Cell[277007, 10363, 217, 5, 33, "Message",
  CellTags->"DumpGet::bgnew"],
Cell[277227, 10370, 392, 9, 59, "Notes",
  CellTags->"DumpGet::bgnew"]
}, Open  ]],

Cell[CellGroupData[{
Cell[277656, 10384, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DumpGet::bgold"],
Cell[277740, 10387, 206, 5, 19, "Message",
  CellTags->"DumpGet::bgold"],
Cell[277949, 10394, 194, 6, 24, "Notes",
  CellTags->"DumpGet::bgold"]
}, Open  ]],

Cell[CellGroupData[{
Cell[278180, 10405, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DumpGet::valwarn"],
Cell[278268, 10408, 353, 10, 19, "Message",
  CellTags->"DumpGet::valwarn"],
Cell[278624, 10420, 315, 9, 43, "Notes",
  CellTags->"DumpGet::valwarn"]
}, Open  ]],

Cell[CellGroupData[{
Cell[278976, 10434, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DumpSave::bschk"],
Cell[279062, 10437, 151, 3, 21, "Message",
  CellTags->"DumpSave::bschk"],
Cell[279216, 10442, 314, 7, 46, "Notes",
  CellTags->"DumpSave::bschk"]
}, Open  ]],

Cell[CellGroupData[{
Cell[279567, 10454, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DumpSave::bsnosym"],
Cell[279657, 10457, 231, 5, 21, "Message",
  CellTags->"DumpSave::bsnosym"],
Cell[279891, 10464, 225, 5, 40, "Notes",
  CellTags->"DumpSave::bsnosym"],

Cell[CellGroupData[{
Cell[280141, 10473, 67, 1, 38, "ExampleSection",
  CellTags->"DumpSave::bsnosym"],
Cell[280211, 10476, 201, 6, 24, "Text",
  CellTags->"DumpSave::bsnosym"],

Cell[CellGroupData[{
Cell[280437, 10486, 116, 3, 26, "Input",
  CellTags->"DumpSave::bsnosym"],
Cell[280556, 10491, 190, 4, 21, "Message",
  CellTags->"DumpSave::bsnosym"],
Cell[280749, 10497, 113, 3, 21, "Output",
  CellTags->"DumpSave::bsnosym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[280923, 10507, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DumpSave::bsstm"],
Cell[281009, 10510, 274, 6, 21, "Message",
  CellTags->"DumpSave::bsstm"],
Cell[281286, 10518, 195, 6, 24, "Notes",
  CellTags->"DumpSave::bsstm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[281518, 10529, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DumpSave::outref"],
Cell[281606, 10532, 460, 9, 37, "Message",
  CellTags->"DumpSave::outref"],
Cell[282069, 10543, 635, 19, 78, "Notes",
  CellTags->"DumpSave::outref"],

Cell[CellGroupData[{
Cell[282729, 10566, 66, 1, 38, "ExampleSection",
  CellTags->"DumpSave::outref"],
Cell[282798, 10569, 186, 4, 40, "Text",
  CellTags->"DumpSave::outref"],

Cell[CellGroupData[{
Cell[283009, 10577, 187, 4, 74, "Input",
  CellTags->"DumpSave::outref"],
Cell[283199, 10583, 246, 5, 53, "Message",
  CellTags->"DumpSave::outref"],
Cell[283448, 10590, 96, 3, 21, "Output",
  CellTags->"DumpSave::outref"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[283605, 10600, 71, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Get::path"],
Cell[283679, 10603, 197, 5, 19, "Message",
  CellTags->"Get::path"],
Cell[283879, 10610, 492, 13, 63, "Notes",
  CellTags->"Get::path"],

Cell[CellGroupData[{
Cell[284396, 10627, 59, 1, 38, "ExampleSection",
  CellTags->"Get::path"],
Cell[284458, 10630, 178, 5, 23, "Text",
  CellTags->"Get::path"],

Cell[CellGroupData[{
Cell[284661, 10639, 120, 3, 26, "Input",
  CellTags->"Get::path"],
Cell[284784, 10644, 162, 4, 19, "Message",
  CellTags->"Get::path"],
Cell[284949, 10650, 155, 4, 19, "Message",
  CellTags->"Get::path"],
Cell[285107, 10656, 90, 3, 25, "Output",
  CellTags->"Get::path"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[285258, 10666, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Information::basic"],
Cell[285350, 10669, 240, 4, 33, "Message",
  CellTags->"Information::basic"],
Cell[285593, 10675, 246, 6, 43, "Notes",
  CellTags->"Information::basic"],

Cell[CellGroupData[{
Cell[285864, 10685, 68, 1, 38, "ExampleSection",
  CellTags->"Information::basic"],
Cell[285935, 10688, 91, 1, 22, "Text",
  CellTags->"Information::basic"],

Cell[CellGroupData[{
Cell[286051, 10693, 92, 3, 26, "Input",
  CellTags->"Information::basic"],
Cell[286146, 10698, 247, 5, 33, "Message",
  CellTags->"Information::basic"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[286454, 10710, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Information::nomatch"],
Cell[286550, 10713, 243, 5, 19, "Message",
  CellTags->"Information::nomatch"],
Cell[286796, 10720, 407, 10, 57, "Notes",
  CellTags->"Information::nomatch"],

Cell[CellGroupData[{
Cell[287228, 10734, 70, 1, 38, "ExampleSection",
  CellTags->"Information::nomatch"],
Cell[287301, 10737, 163, 4, 22, "Text",
  CellTags->"Information::nomatch"],

Cell[CellGroupData[{
Cell[287489, 10745, 100, 3, 26, "Input",
  CellTags->"Information::nomatch"],
Cell[287592, 10750, 186, 4, 19, "Message",
  CellTags->"Information::nomatch"]
}, Open  ]],
Cell[287793, 10757, 129, 4, 24, "Text",
  CellTags->"Information::nomatch"],

Cell[CellGroupData[{
Cell[287947, 10765, 100, 3, 26, "Input",
  CellTags->"Information::nomatch"],
Cell[288050, 10770, 2701, 66, 73, "Print",
  CellTags->"Information::nomatch"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[290812, 10843, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Information::notfound1"],
Cell[290912, 10846, 226, 5, 21, "Message",
  CellTags->"Information::notfound1"],
Cell[291141, 10853, 184, 4, 24, "Notes",
  CellTags->"Information::notfound1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[291362, 10862, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Information::opt"],
Cell[291450, 10865, 205, 5, 19, "Message",
  CellTags->"Information::opt"],
Cell[291658, 10872, 196, 6, 24, "Notes",
  CellTags->"Information::opt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[291891, 10883, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Message::msgl"],
Cell[291973, 10886, 245, 6, 19, "Message",
  CellTags->"Message::msgl"],
Cell[292221, 10894, 403, 10, 57, "Notes",
  CellTags->"Message::msgl"],

Cell[CellGroupData[{
Cell[292649, 10908, 63, 1, 38, "ExampleSection",
  CellTags->"Message::msgl"],
Cell[292715, 10911, 192, 5, 23, "Text",
  CellTags->"Message::msgl"],

Cell[CellGroupData[{
Cell[292932, 10920, 114, 3, 26, "Input",
  CellTags->"Message::msgl"],
Cell[293049, 10925, 192, 5, 19, "Message",
  CellTags->"Message::msgl"],
Cell[293244, 10932, 196, 5, 19, "Message",
  CellTags->"Message::msgl"],
Cell[293443, 10939, 92, 3, 25, "Output",
  CellTags->"Message::msgl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[293596, 10949, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Message::name"],
Cell[293678, 10952, 279, 6, 19, "Message",
  CellTags->"Message::name"],
Cell[293960, 10960, 188, 5, 23, "Notes",
  CellTags->"Message::name"],

Cell[CellGroupData[{
Cell[294173, 10969, 63, 1, 38, "ExampleSection",
  CellTags->"Message::name"],
Cell[294239, 10972, 236, 7, 38, "Text",
  CellTags->"Message::name"],

Cell[CellGroupData[{
Cell[294500, 10983, 106, 3, 26, "Input",
  CellTags->"Message::name"],
Cell[294609, 10988, 217, 5, 33, "Message",
  CellTags->"Message::name"],
Cell[294829, 10995, 107, 3, 25, "Output",
  CellTags->"Message::name"]
}, Open  ]],
Cell[294951, 11001, 157, 5, 23, "Text",
  CellTags->"Message::name"],

Cell[CellGroupData[{
Cell[295133, 11010, 112, 3, 26, "Input",
  CellTags->"Message::name"],
Cell[295248, 11015, 196, 5, 19, "Message",
  CellTags->"Message::name"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[295505, 11027, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Needs::nocont"],
Cell[295587, 11030, 245, 5, 21, "Message",
  CellTags->"Needs::nocont"],
Cell[295835, 11037, 1199, 25, 198, "Notes",
  CellTags->"Needs::nocont"],

Cell[CellGroupData[{
Cell[297059, 11066, 63, 1, 38, "ExampleSection",
  CellTags->"Needs::nocont"],
Cell[297125, 11069, 287, 6, 56, "Text",
  CellTags->"Needs::nocont"],

Cell[CellGroupData[{
Cell[297437, 11079, 109, 3, 26, "Input",
  CellTags->"Needs::nocont"],
Cell[297549, 11084, 165, 4, 21, "Message",
  CellTags->"Needs::nocont"],
Cell[297717, 11090, 206, 5, 37, "Message",
  CellTags->"Needs::nocont"],
Cell[297926, 11097, 94, 3, 21, "Output",
  CellTags->"Needs::nocont"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[298081, 11107, 69, 1, 31, "ObjectNameWarningMessages",
  CellTags->"On::none"],
Cell[298153, 11110, 197, 4, 21, "Message",
  CellTags->"On::none"],
Cell[298353, 11116, 178, 5, 24, "Notes",
  CellTags->"On::none"],

Cell[CellGroupData[{
Cell[298556, 11125, 58, 1, 38, "ExampleSection",
  CellTags->"On::none"],
Cell[298617, 11128, 214, 7, 24, "Text",
  CellTags->"On::none"],

Cell[CellGroupData[{
Cell[298856, 11139, 93, 3, 26, "Input",
  CellTags->"On::none"],
Cell[298952, 11144, 163, 4, 21, "Message",
  CellTags->"On::none"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[299176, 11155, 147, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
Cell[299326, 11162, 415, 11, 21, "Message",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
Cell[299744, 11175, 683, 26, 62, "Notes",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],

Cell[CellGroupData[{
Cell[300452, 11205, 97, 1, 38, "ExampleSection",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
Cell[300552, 11208, 207, 5, 24, "Text",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],

Cell[CellGroupData[{
Cell[300784, 11217, 246, 5, 90, "Input",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
Cell[301033, 11224, 220, 4, 21, "Message",
  CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}],
Cell[301256, 11230, 165, 3, 21, "Output",
  CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}]
}, Open  ]],
Cell[301436, 11236, 175, 5, 23, "Text",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],

Cell[CellGroupData[{
Cell[301636, 11245, 245, 5, 90, "Input",
  CellTags->{"Read::readf", "ReadList::readf", "Skip::readf"}],
Cell[301884, 11252, 133, 3, 25, "Output",
  CellTags->{"ReadList::readf", "Read::readf", "Skip::readf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[302078, 11262, 147, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
Cell[302228, 11269, 433, 12, 19, "Message",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
Cell[302664, 11283, 275, 6, 37, "Notes",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[CellGroupData[{
Cell[302964, 11293, 97, 1, 38, "ExampleSection",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
Cell[303064, 11296, 232, 6, 23, "Text",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[CellGroupData[{
Cell[303321, 11306, 252, 5, 90, "Input",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
Cell[303576, 11313, 275, 6, 33, "Message",
  CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
Cell[303854, 11321, 130, 3, 25, "Output",
  CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}]
}, Open  ]],
Cell[303999, 11327, 168, 5, 23, "Text",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[CellGroupData[{
Cell[304192, 11336, 261, 5, 90, "Input",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
Cell[304456, 11343, 141, 3, 25, "Output",
  CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}]
}, Open  ]],
Cell[304612, 11349, 227, 6, 23, "Text",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[CellGroupData[{
Cell[304864, 11359, 250, 5, 90, "Input",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
Cell[305117, 11366, 273, 6, 33, "Message",
  CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}],
Cell[305393, 11374, 136, 3, 25, "Output",
  CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}]
}, Open  ]],
Cell[305544, 11380, 250, 7, 23, "Text",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],

Cell[CellGroupData[{
Cell[305819, 11391, 296, 5, 90, "Input",
  CellTags->{"Read::readn", "ReadList::readn", "Skip::readn"}],
Cell[306118, 11398, 139, 3, 25, "Output",
  CellTags->{"ReadList::readn", "Read::readn", "Skip::readn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[306318, 11408, 147, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
Cell[306468, 11415, 429, 13, 19, "Message",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
Cell[306900, 11430, 205, 4, 22, "Notes",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],

Cell[CellGroupData[{
Cell[307130, 11438, 97, 1, 38, "ExampleSection",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
Cell[307230, 11441, 276, 7, 38, "Text",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],

Cell[CellGroupData[{
Cell[307531, 11452, 231, 4, 90, "Input",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
Cell[307765, 11458, 274, 5, 33, "Message",
  CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}],
Cell[308042, 11465, 128, 3, 25, "Output",
  CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}]
}, Open  ]],
Cell[308185, 11471, 137, 1, 22, "Text",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],

Cell[CellGroupData[{
Cell[308347, 11476, 232, 4, 90, "Input",
  CellTags->{"Read::readt", "ReadList::readt", "Skip::readt"}],
Cell[308582, 11482, 123, 3, 25, "Output",
  CellTags->{"ReadList::readt", "Read::readt", "Skip::readt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[308766, 11492, 147, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
Cell[308916, 11499, 372, 11, 19, "Message",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
Cell[309291, 11512, 297, 9, 23, "Notes",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],

Cell[CellGroupData[{
Cell[309613, 11525, 97, 1, 38, "ExampleSection",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
Cell[309713, 11528, 229, 5, 23, "Text",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],

Cell[CellGroupData[{
Cell[309967, 11537, 250, 5, 90, "Input",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
Cell[310220, 11544, 200, 4, 19, "Message",
  CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}],
Cell[310423, 11550, 164, 3, 25, "Output",
  CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}]
}, Open  ]],
Cell[310602, 11556, 175, 5, 23, "Text",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],

Cell[CellGroupData[{
Cell[310802, 11565, 246, 4, 90, "Input",
  CellTags->{"Read::readx", "ReadList::readx", "Skip::readx"}],
Cell[311051, 11571, 144, 3, 25, "Output",
  CellTags->{"ReadList::readx", "Read::readx", "Skip::readx"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[311256, 11581, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SetStreamPosition::sbuf"],
Cell[311358, 11584, 472, 11, 33, "Message",
  CellTags->"SetStreamPosition::sbuf"],
Cell[311833, 11597, 252, 6, 37, "Notes",
  CellTags->"SetStreamPosition::sbuf"],

Cell[CellGroupData[{
Cell[312110, 11607, 73, 1, 38, "ExampleSection",
  CellTags->"SetStreamPosition::sbuf"],
Cell[312186, 11610, 263, 6, 37, "Text",
  CellTags->"SetStreamPosition::sbuf"],

Cell[CellGroupData[{
Cell[312474, 11620, 293, 6, 106, "Input",
  CellTags->"SetStreamPosition::sbuf"],
Cell[312770, 11628, 320, 6, 47, "Message",
  CellTags->"SetStreamPosition::sbuf"],
Cell[313093, 11636, 112, 3, 25, "Output",
  CellTags->"SetStreamPosition::sbuf"]
}, Open  ]],
Cell[313220, 11642, 143, 5, 23, "Text",
  CellTags->"SetStreamPosition::sbuf"],

Cell[CellGroupData[{
Cell[313388, 11651, 292, 6, 106, "Input",
  CellTags->"SetStreamPosition::sbuf"],
Cell[313683, 11659, 112, 3, 25, "Output",
  CellTags->"SetStreamPosition::sbuf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[313856, 11669, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"StringForm::sfq"],
Cell[313942, 11672, 212, 5, 19, "Message",
  CellTags->"StringForm::sfq"],
Cell[314157, 11679, 208, 5, 23, "Notes",
  CellTags->"StringForm::sfq"],

Cell[CellGroupData[{
Cell[314390, 11688, 65, 1, 38, "ExampleSection",
  CellTags->"StringForm::sfq"],
Cell[314458, 11691, 202, 6, 24, "Text",
  CellTags->"StringForm::sfq"],

Cell[CellGroupData[{
Cell[314685, 11701, 139, 3, 26, "Input",
  CellTags->"StringForm::sfq"],
Cell[314827, 11706, 198, 5, 21, "Message",
  CellTags->"StringForm::sfq"],
Cell[315028, 11713, 217, 5, 21, "Output",
  CellTags->"StringForm::sfq"]
}, Open  ]],
Cell[315260, 11721, 139, 5, 24, "Text",
  CellTags->"StringForm::sfq"],

Cell[CellGroupData[{
Cell[315424, 11730, 140, 3, 26, "Input",
  CellTags->"StringForm::sfq"],
Cell[315567, 11735, 245, 6, 21, "Output",
  CellTags->"StringForm::sfq"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[315873, 11748, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::aofil"],
Cell[315957, 11751, 396, 13, 21, "Message",
  CellTags->"General::aofil"],
Cell[316356, 11766, 553, 12, 106, "Notes",
  CellTags->"General::aofil"],

Cell[CellGroupData[{
Cell[316934, 11782, 64, 1, 38, "ExampleSection",
  CellTags->"General::aofil"],
Cell[317001, 11785, 178, 5, 24, "Text",
  CellTags->"General::aofil"],

Cell[CellGroupData[{
Cell[317204, 11794, 112, 3, 26, "Input",
  CellTags->"General::aofil"],
Cell[317319, 11799, 118, 3, 21, "Output",
  CellTags->"General::aofil"]
}, Open  ]],

Cell[CellGroupData[{
Cell[317474, 11807, 112, 3, 26, "Input",
  CellTags->"General::aofil"],
Cell[317589, 11812, 190, 4, 21, "Message",
  CellTags->"General::aofil"],
Cell[317782, 11818, 170, 4, 19, "Message",
  CellTags->"General::aofil"],
Cell[317955, 11824, 95, 3, 25, "Output",
  CellTags->"General::aofil"]
}, Open  ]],
Cell[318065, 11830, 61, 1, 22, "Text",
  CellTags->"General::aofil"],

Cell[CellGroupData[{
Cell[318151, 11835, 108, 3, 26, "Input",
  CellTags->"General::aofil"],
Cell[318262, 11840, 98, 3, 25, "Output",
  CellTags->"General::aofil"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[318421, 11850, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::filro"],
Cell[318505, 11853, 418, 12, 19, "Message",
  CellTags->"General::filro"],
Cell[318926, 11867, 299, 6, 56, "Notes",
  CellTags->"General::filro"]
}, Open  ]],

Cell[CellGroupData[{
Cell[319262, 11878, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ioarg"],
Cell[319346, 11881, 398, 11, 19, "Message",
  CellTags->"General::ioarg"],
Cell[319747, 11894, 292, 6, 56, "Notes",
  CellTags->"General::ioarg"]
}, Open  ]],

Cell[CellGroupData[{
Cell[320076, 11905, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ioerr"],
Cell[320160, 11908, 357, 11, 19, "Message",
  CellTags->"General::ioerr"],
Cell[320520, 11921, 282, 6, 42, "Notes",
  CellTags->"General::ioerr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[320839, 11932, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::isdir"],
Cell[320923, 11935, 240, 7, 19, "Message",
  CellTags->"General::isdir"],
Cell[321166, 11944, 388, 9, 56, "Notes",
  CellTags->"General::isdir"]
}, Open  ]],

Cell[CellGroupData[{
Cell[321591, 11958, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::noopen"],
Cell[321677, 11961, 327, 11, 19, "Message",
  CellTags->"General::noopen"],
Cell[322007, 11974, 635, 13, 112, "Notes",
  CellTags->"General::noopen"],

Cell[CellGroupData[{
Cell[322667, 11991, 65, 1, 38, "ExampleSection",
  CellTags->"General::noopen"],
Cell[322735, 11994, 141, 4, 22, "Text",
  CellTags->"General::noopen"],

Cell[CellGroupData[{
Cell[322901, 12002, 105, 3, 26, "Input",
  CellTags->"General::noopen"],
Cell[323009, 12007, 163, 4, 19, "Message",
  CellTags->"General::noopen"],
Cell[323175, 12013, 96, 3, 25, "Output",
  CellTags->"General::noopen"]
}, Open  ]],
Cell[323286, 12019, 193, 5, 36, "Text",
  CellTags->"General::noopen"],

Cell[CellGroupData[{
Cell[323504, 12028, 132, 3, 26, "Input",
  CellTags->"General::noopen"],
Cell[323639, 12033, 192, 5, 19, "Message",
  CellTags->"General::noopen"],
Cell[323834, 12040, 96, 3, 25, "Output",
  CellTags->"General::noopen"]
}, Open  ]],
Cell[323945, 12046, 216, 5, 37, "Text",
  CellTags->"General::noopen"],
Cell[324164, 12053, 134, 3, 26, "Input",
  CellTags->"General::noopen"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[324347, 12062, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::notfound"],
Cell[324437, 12065, 322, 9, 19, "Message",
  CellTags->"General::notfound"],
Cell[324762, 12076, 542, 12, 90, "Notes",
  CellTags->"General::notfound"],

Cell[CellGroupData[{
Cell[325329, 12092, 67, 1, 38, "ExampleSection",
  CellTags->"General::notfound"],
Cell[325399, 12095, 203, 5, 36, "Text",
  CellTags->"General::notfound"],

Cell[CellGroupData[{
Cell[325627, 12104, 101, 3, 26, "Input",
  CellTags->"General::notfound"],
Cell[325731, 12109, 180, 4, 19, "Message",
  CellTags->"General::notfound"]
}, Open  ]],
Cell[325926, 12116, 80, 1, 22, "Text",
  CellTags->"General::notfound"],

Cell[CellGroupData[{
Cell[326031, 12121, 98, 3, 26, "Input",
  CellTags->"General::notfound"],
Cell[326132, 12126, 170, 4, 21, "Print",
  CellTags->"General::notfound"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[326363, 12137, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::openr"],
Cell[326447, 12140, 348, 11, 19, "Message",
  CellTags->"General::openr"],
Cell[326798, 12153, 130, 4, 22, "Notes",
  CellTags->"General::openr"],

Cell[CellGroupData[{
Cell[326953, 12161, 64, 1, 38, "ExampleSection",
  CellTags->"General::openr"],
Cell[327020, 12164, 93, 1, 22, "Text",
  CellTags->"General::openr"],

Cell[CellGroupData[{
Cell[327138, 12169, 122, 3, 26, "Input",
  CellTags->"General::openr"],
Cell[327263, 12174, 113, 3, 25, "Output",
  CellTags->"General::openr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[327413, 12182, 98, 3, 26, "Input",
  CellTags->"General::openr"],
Cell[327514, 12187, 196, 5, 19, "Message",
  CellTags->"General::openr"],
Cell[327713, 12194, 187, 4, 19, "Message",
  CellTags->"General::openr"]
}, Open  ]],
Cell[327915, 12201, 63, 1, 22, "Text",
  CellTags->"General::openr"],

Cell[CellGroupData[{
Cell[328003, 12206, 95, 3, 26, "Input",
  CellTags->"General::openr"],
Cell[328101, 12211, 94, 3, 25, "Output",
  CellTags->"General::openr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[328256, 12221, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::openw"],
Cell[328340, 12224, 349, 11, 19, "Message",
  CellTags->"General::openw"],
Cell[328692, 12237, 132, 4, 22, "Notes",
  CellTags->"General::openw"],

Cell[CellGroupData[{
Cell[328849, 12245, 64, 1, 38, "ExampleSection",
  CellTags->"General::openw"],
Cell[328916, 12248, 119, 4, 22, "Text",
  CellTags->"General::openw"],

Cell[CellGroupData[{
Cell[329060, 12256, 113, 3, 26, "Input",
  CellTags->"General::openw"],
Cell[329176, 12261, 114, 3, 25, "Output",
  CellTags->"General::openw"]
}, Open  ]],

Cell[CellGroupData[{
Cell[329327, 12269, 94, 3, 26, "Input",
  CellTags->"General::openw"],
Cell[329424, 12274, 200, 5, 19, "Message",
  CellTags->"General::openw"],
Cell[329627, 12281, 95, 3, 25, "Output",
  CellTags->"General::openw"]
}, Open  ]],
Cell[329737, 12287, 63, 1, 22, "Text",
  CellTags->"General::openw"],

Cell[CellGroupData[{
Cell[329825, 12292, 95, 3, 26, "Input",
  CellTags->"General::openw"],
Cell[329923, 12297, 94, 3, 25, "Output",
  CellTags->"General::openw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[330078, 12307, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::openx"],
Cell[330162, 12310, 327, 11, 19, "Message",
  CellTags->"General::openx"],
Cell[330492, 12323, 340, 11, 42, "Notes",
  CellTags->"General::openx"],

Cell[CellGroupData[{
Cell[330857, 12338, 64, 1, 38, "ExampleSection",
  CellTags->"General::openx"],
Cell[330924, 12341, 208, 5, 37, "Text",
  CellTags->"General::openx"],

Cell[CellGroupData[{
Cell[331157, 12350, 103, 3, 26, "Input",
  CellTags->"General::openx"],
Cell[331263, 12355, 160, 4, 19, "Message",
  CellTags->"General::openx"],
Cell[331426, 12361, 100, 3, 25, "Output",
  CellTags->"General::openx"]
}, Open  ]],
Cell[331541, 12367, 155, 5, 23, "Text",
  CellTags->"General::openx"],

Cell[CellGroupData[{
Cell[331721, 12376, 204, 4, 106, "Input",
  CellTags->"General::openx"],
Cell[331928, 12382, 97, 3, 25, "Output",
  CellTags->"General::openx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[332086, 12392, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::readp"],
Cell[332170, 12395, 339, 10, 19, "Message",
  CellTags->"General::readp"],
Cell[332512, 12407, 287, 8, 38, "Notes",
  CellTags->"General::readp"],

Cell[CellGroupData[{
Cell[332824, 12419, 64, 1, 38, "ExampleSection",
  CellTags->"General::readp"],
Cell[332891, 12422, 294, 10, 38, "Text",
  CellTags->"General::readp"],
Cell[333188, 12434, 132, 3, 26, "Input",
  CellTags->"General::readp"],

Cell[CellGroupData[{
Cell[333345, 12441, 104, 3, 26, "Input",
  CellTags->"General::readp"],
Cell[333452, 12446, 173, 4, 19, "Message",
  CellTags->"General::readp"],
Cell[333628, 12452, 95, 3, 21, "Output",
  CellTags->"General::readp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[333784, 12462, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::remote"],
Cell[333870, 12465, 546, 13, 37, "Message",
  CellTags->"General::remote"],
Cell[334419, 12480, 481, 14, 62, "Notes",
  CellTags->"General::remote"]
}, Open  ]],

Cell[CellGroupData[{
Cell[334937, 12499, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::stmtype"],
Cell[335025, 12502, 591, 16, 37, "Message",
  CellTags->"General::stmtype"],
Cell[335619, 12520, 196, 6, 24, "Notes",
  CellTags->"General::stmtype"]
}, Open  ]],

Cell[CellGroupData[{
Cell[335852, 12531, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::stop"],
Cell[335934, 12534, 420, 11, 21, "Message",
  CellTags->"General::stop"],
Cell[336357, 12547, 289, 6, 46, "Notes",
  CellTags->"General::stop"],

Cell[CellGroupData[{
Cell[336671, 12557, 63, 1, 38, "ExampleSection",
  CellTags->"General::stop"],
Cell[336737, 12560, 138, 4, 24, "Text",
  CellTags->"General::stop"],

Cell[CellGroupData[{
Cell[336900, 12568, 132, 3, 26, "Input",
  CellTags->"General::stop"],
Cell[337035, 12573, 252, 5, 53, "Message",
  CellTags->"General::stop"],
Cell[337290, 12580, 252, 5, 53, "Message",
  CellTags->"General::stop"],
Cell[337545, 12587, 252, 5, 53, "Message",
  CellTags->"General::stop"],
Cell[337800, 12594, 226, 5, 37, "Message",
  CellTags->"General::stop"],
Cell[338029, 12601, 283, 6, 21, "Output",
  CellTags->"General::stop"]
}, Open  ]],
Cell[338327, 12610, 78, 1, 24, "Text",
  CellTags->"General::stop"],

Cell[CellGroupData[{
Cell[338430, 12615, 137, 3, 26, "Input",
  CellTags->"General::stop"],
Cell[338570, 12620, 108, 3, 21, "Output",
  CellTags->"General::stop"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[338739, 12630, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::stream"],
Cell[338825, 12633, 451, 13, 21, "Message",
  CellTags->"General::stream"],
Cell[339279, 12648, 259, 8, 40, "Notes",
  CellTags->"General::stream"],

Cell[CellGroupData[{
Cell[339563, 12660, 65, 1, 38, "ExampleSection",
  CellTags->"General::stream"],
Cell[339631, 12663, 185, 5, 24, "Text",
  CellTags->"General::stream"],

Cell[CellGroupData[{
Cell[339841, 12672, 133, 3, 26, "Input",
  CellTags->"General::stream"],
Cell[339977, 12677, 200, 5, 21, "Message",
  CellTags->"General::stream"],
Cell[340180, 12684, 223, 6, 21, "Print",
  CellTags->"General::stream"]
}, Open  ]],
Cell[340418, 12693, 171, 7, 24, "Text",
  CellTags->"General::stream"],

Cell[CellGroupData[{
Cell[340614, 12704, 178, 4, 42, "Input",
  CellTags->"General::stream"],
Cell[340795, 12710, 201, 5, 21, "Print",
  CellTags->"General::stream"],
Cell[340999, 12717, 95, 3, 21, "Output",
  CellTags->"General::stream"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[341155, 12727, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::strmi"],
Cell[341239, 12730, 436, 11, 21, "Message",
  CellTags->"General::strmi"],
Cell[341678, 12743, 631, 17, 78, "Notes",
  CellTags->"General::strmi"],

Cell[CellGroupData[{
Cell[342334, 12764, 64, 1, 38, "ExampleSection",
  CellTags->"General::strmi"],
Cell[342401, 12767, 181, 5, 24, "Text",
  CellTags->"General::strmi"],

Cell[CellGroupData[{
Cell[342607, 12776, 115, 3, 26, "Input",
  CellTags->"General::strmi"],
Cell[342725, 12781, 114, 3, 21, "Output",
  CellTags->"General::strmi"]
}, Open  ]],

Cell[CellGroupData[{
Cell[342876, 12789, 156, 4, 26, "Input",
  CellTags->"General::strmi"],
Cell[343035, 12795, 233, 5, 37, "Message",
  CellTags->"General::strmi"],
Cell[343271, 12802, 183, 4, 21, "Message",
  CellTags->"General::strmi"]
}, Open  ]],
Cell[343469, 12809, 218, 6, 40, "Text",
  CellTags->"General::strmi"],
Cell[343690, 12817, 132, 3, 26, "Input",
  CellTags->"General::strmi"],
Cell[343825, 12822, 143, 3, 26, "Input",
  CellTags->"General::strmi"],
Cell[343971, 12827, 83, 1, 24, "Text",
  CellTags->"General::strmi"],
Cell[344057, 12830, 122, 3, 26, "Input",
  CellTags->"General::strmi"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[344228, 12839, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::strml"],
Cell[344312, 12842, 455, 14, 21, "Message",
  CellTags->"General::strml"],
Cell[344770, 12858, 306, 8, 40, "Notes",
  CellTags->"General::strml"],

Cell[CellGroupData[{
Cell[345101, 12870, 64, 1, 38, "ExampleSection",
  CellTags->"General::strml"],
Cell[345168, 12873, 203, 5, 24, "Text",
  CellTags->"General::strml"],

Cell[CellGroupData[{
Cell[345396, 12882, 132, 3, 26, "Input",
  CellTags->"General::strml"],
Cell[345531, 12887, 205, 5, 37, "Message",
  CellTags->"General::strml"],
Cell[345739, 12894, 153, 4, 21, "Message",
  CellTags->"General::strml"]
}, Open  ]],
Cell[345907, 12901, 126, 5, 24, "Text",
  CellTags->"General::strml"],
Cell[346036, 12908, 138, 3, 26, "Input",
  CellTags->"General::strml"],
Cell[346177, 12913, 91, 1, 24, "Text",
  CellTags->"General::strml"],
Cell[346271, 12916, 128, 3, 26, "Input",
  CellTags->"General::strml"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[346448, 12925, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::strmn"],
Cell[346532, 12928, 508, 14, 37, "Message",
  CellTags->"General::strmn"],
Cell[347043, 12944, 1020, 30, 138, "Notes",
  CellTags->"General::strmn"],

Cell[CellGroupData[{
Cell[348088, 12978, 64, 1, 38, "ExampleSection",
  CellTags->"General::strmn"],
Cell[348155, 12981, 200, 6, 24, "Text",
  CellTags->"General::strmn"],

Cell[CellGroupData[{
Cell[348380, 12991, 124, 3, 26, "Input",
  CellTags->"General::strmn"],
Cell[348507, 12996, 113, 3, 21, "Output",
  CellTags->"General::strmn"]
}, Open  ]],

Cell[CellGroupData[{
Cell[348657, 13004, 97, 3, 26, "Input",
  CellTags->"General::strmn"],
Cell[348757, 13009, 92, 3, 21, "Output",
  CellTags->"General::strmn"]
}, Open  ]],
Cell[348864, 13015, 159, 4, 24, "Text",
  CellTags->"General::strmn"],

Cell[CellGroupData[{
Cell[349048, 13023, 143, 3, 26, "Input",
  CellTags->"General::strmn"],
Cell[349194, 13028, 378, 7, 69, "Message",
  CellTags->"General::strmn"],
Cell[349575, 13037, 190, 4, 21, "Message",
  CellTags->"General::strmn"],
Cell[349768, 13043, 240, 5, 37, "Message",
  CellTags->"General::strmn"],
Cell[350011, 13050, 95, 3, 21, "Output",
  CellTags->"General::strmn"]
}, Open  ]],
Cell[350121, 13056, 96, 1, 24, "Text",
  CellTags->"General::strmn"],

Cell[CellGroupData[{
Cell[350242, 13061, 111, 3, 26, "Input",
  CellTags->"General::strmn"],
Cell[350356, 13066, 123, 3, 21, "Output",
  CellTags->"General::strmn"]
}, Open  ]],
Cell[350494, 13072, 63, 1, 24, "Text",
  CellTags->"General::strmn"],

Cell[CellGroupData[{
Cell[350582, 13077, 95, 3, 26, "Input",
  CellTags->"General::strmn"],
Cell[350680, 13082, 94, 3, 21, "Output",
  CellTags->"General::strmn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[350835, 13092, 103, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SetStreamPosition::stmrng"],
Cell[350941, 13095, 291, 6, 53, "Message",
  CellTags->"SetStreamPosition::stmrng"],
Cell[351235, 13103, 282, 6, 40, "Notes",
  CellTags->"SetStreamPosition::stmrng"],

Cell[CellGroupData[{
Cell[351542, 13113, 75, 1, 38, "ExampleSection",
  CellTags->"SetStreamPosition::stmrng"],
Cell[351620, 13116, 235, 5, 40, "Text",
  CellTags->"SetStreamPosition::stmrng"],
Cell[351858, 13123, 155, 3, 26, "Input",
  CellTags->"SetStreamPosition::stmrng"],

Cell[CellGroupData[{
Cell[352038, 13130, 119, 3, 26, "Input",
  CellTags->"SetStreamPosition::stmrng"],
Cell[352160, 13135, 109, 3, 21, "Output",
  CellTags->"SetStreamPosition::stmrng"]
}, Open  ]],

Cell[CellGroupData[{
Cell[352306, 13143, 331, 7, 90, "Input",
  CellTags->"SetStreamPosition::stmrng"],
Cell[352640, 13152, 340, 7, 69, "Message",
  CellTags->"SetStreamPosition::stmrng"],
Cell[352983, 13161, 219, 5, 21, "Print",
  CellTags->"SetStreamPosition::stmrng"],
Cell[353205, 13168, 109, 3, 21, "Output",
  CellTags->"SetStreamPosition::stmrng"]
}, Open  ]],
Cell[353329, 13174, 113, 1, 24, "Text",
  CellTags->"SetStreamPosition::stmrng"],

Cell[CellGroupData[{
Cell[353467, 13179, 329, 7, 90, "Input",
  CellTags->"SetStreamPosition::stmrng"],
Cell[353799, 13188, 217, 5, 21, "Print",
  CellTags->"SetStreamPosition::stmrng"],
Cell[354019, 13195, 109, 3, 21, "Output",
  CellTags->"SetStreamPosition::stmrng"]
}, Open  ]],
Cell[354143, 13201, 78, 1, 24, "Text",
  CellTags->"SetStreamPosition::stmrng"],
Cell[354224, 13204, 124, 3, 26, "Input",
  CellTags->"SetStreamPosition::stmrng"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[354397, 13213, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$Language::notstr"],
Cell[354487, 13216, 216, 5, 37, "Message",
  CellTags->"$Language::notstr"],
Cell[354706, 13223, 303, 8, 46, "Notes",
  CellTags->"$Language::notstr"],

Cell[CellGroupData[{
Cell[355034, 13235, 67, 1, 38, "ExampleSection",
  CellTags->"$Language::notstr"],
Cell[355104, 13238, 201, 7, 24, "Text",
  CellTags->"$Language::notstr"],

Cell[CellGroupData[{
Cell[355330, 13249, 106, 3, 26, "Input",
  CellTags->"$Language::notstr"],
Cell[355439, 13254, 222, 5, 37, "Message",
  CellTags->"$Language::notstr"],
Cell[355664, 13261, 95, 3, 21, "Output",
  CellTags->"$Language::notstr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[355820, 13271, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::guesshb"],
Cell[355906, 13274, 217, 5, 37, "Message",
  CellTags->"Import::guesshb"],
Cell[356126, 13281, 126, 4, 24, "Notes",
  CellTags->"Import::guesshb"]
}, Open  ]],

Cell[CellGroupData[{
Cell[356289, 13290, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::mpsbv"],
Cell[356371, 13293, 206, 4, 37, "Message",
  CellTags->"Import::mpsbv"],
Cell[356580, 13299, 124, 4, 24, "Notes",
  CellTags->"Import::mpsbv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[356741, 13308, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::mpsiv"],
Cell[356823, 13311, 207, 4, 37, "Message",
  CellTags->"Import::mpsiv"],
Cell[357033, 13317, 124, 4, 24, "Notes",
  CellTags->"Import::mpsiv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[357194, 13326, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Import::mpsmr"],
Cell[357276, 13329, 254, 5, 37, "Message",
  CellTags->"Import::mpsmr"],
Cell[357533, 13336, 124, 4, 24, "Notes",
  CellTags->"Import::mpsmr"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

