(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     53621,       1742]*)
(*NotebookOutlinePosition[    140343,       3526]*)
(*  CellTagsIndexPosition[    135047,       3415]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Linear Programming", "Title"],

Cell[CellGroupData[{

Cell["\<\
ConstrainedMax::cmnov
ConstrainedMin::cmnov\
\>", "ObjectNameWarningMessages",
  CellTags->{"ConstrainedMax::cmnov", "ConstrainedMin::cmnov"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"cmnov\"\>"}], \(\(:\)\(\ \)\), \(No\ variables\ \
\(\(found\)\(.\)\)\)}]], "Message",
  CellTags->{"ConstrainedMax::cmnov", "ConstrainedMin::cmnov"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"ConstrainedMax::cmnov", "ConstrainedMin::cmnov"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::lpbd
DualLinearProgramming::lpbd\
\>", "ObjectNameWarningMessages",
  CellTags->{"LinearProgramming::lpbd", "DualLinearProgramming::lpbd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpbd\"\>"}], \(\(:\)\(\ \)\), \(The\ input\ that\ \
specifies\ lower/
          upper\ bounds\ contains\ elements\ that\ are\ not\ real\ \(numbers/
            Infinity\)/\(-\(\(Infinity\)\(.\)\)\)\)}]], "Message",
  CellTags->{"LinearProgramming::lpbd", "DualLinearProgramming::lpbd"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"LinearProgramming::lpbd", "DualLinearProgramming::lpbd"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::lpdim
DualLinearProgramming::lpdim\
\>", "ObjectNameWarningMessages",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpdim\"\>"}], \(\(:\)\(\ \)\), \(Invalid\ \(input : \ 
          dimension\ of\ input\ vectors/
              matrices\ do\ not\ match\ with\ each\ \
\(\(other\)\(.\)\)\)\)}]], "Message",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],

Cell["\<\
An error occurs in this example because the first argument is an \
empty list.\
\>", "Text",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearProgramming[{}, {{2, 1}, {1, 1}}, {5, 7}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],

Cell[BoxData[
    \(LinearProgramming::"lpdim" \(\(:\)\(\ \)\) 
      "Invalid input: dimension of input vectors/matrices do not match with \
each other."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],

Cell[BoxData[
    \(LinearProgramming[{}, {{2, 1}, {1, 1}}, {5, 7}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["LinearProgramming", "MR"],
  "."
}], "Text",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearProgramming[{2, 1}, {{2, 1}, {1, 1}}, {5, 7}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],

Cell[BoxData[
    \({0, 7}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::lpnn
ConstrainedMax::lpnn
ConstrainedMin::lpnn
DualLinearProgramming::lpnn\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lpnn", "ConstrainedMax::lpnn", "ConstrainedMin::lpnn", 
    "DualLinearProgramming::lpnn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpnn\"\>"}], \(\(:\)\(\ \)\), \(Input\ data\ to\ linear\ \
programming\ \(algorithm : \ `1`\ contains\ elements\ that\ are\ not\ real\ \
numbers\), \ or\ it\ contains\ empty\ matrices, \ 
      or\ it\ contains\ other\ non - 
        valid\ vectors/\(\(matrices\)\(.\)\)\)}]], "Message",
  CellTags->{
  "LinearProgramming::lpnn", "ConstrainedMax::lpnn", "ConstrainedMin::lpnn", 
    "DualLinearProgramming::lpnn"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "LinearProgramming::lpnn", "ConstrainedMax::lpnn", "ConstrainedMin::lpnn", 
    "DualLinearProgramming::lpnn"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::cmr
DualLinearProgramming::cmr
ConstrainedMin::cmr
ConstrainedMax::cmr\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
    "ConstrainedMin::cmr", "ConstrainedMax::cmr"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"cmr\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "constraint", " ", "matrix", " ", 
      StyleBox["mat",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(must\ be\ a\ matrix\ of\ real\ \
\(\(numbers\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
    "ConstrainedMin::cmr", "ConstrainedMax::cmr"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["LinearProgramming", "MR"],
  " is not a matrix or includes elements that are not real numbers."
}], "Notes",
  CellTags->{
  "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
    "ConstrainedMin::cmr", "ConstrainedMax::cmr"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::lprank2
DualLinearProgramming::lprank2\
\>", "ObjectNameWarningMessages",
  CellTags->{"LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"lprank2\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", 
        " ", \(\(matrix\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["LinearProgramming", "MR"],
  " is not a matrix."
}], "Notes",
  CellTags->{"LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],

Cell["\<\
An error occurs in this example because the second argument is not \
a matrix.\
\>", "Text",
  CellTags->{"LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearProgramming[{2, \(-3\)}, {{1}, {0, \(-1\)}}, {3, \(-1\)}]\)], \
"Input",
  CellLabel->"In[1]:=",
  CellTags->{"LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],

Cell[BoxData[
    \(LinearProgramming::"lprank2" \(\(:\)\(\ \)\) 
      "\!\({\(\({1}\)\), \(\({0, \(\(-1\)\)}\)\)}\) is not a matrix."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"DualLinearProgramming::lprank2", "LinearProgramming::lprank2"}],

Cell[BoxData[
    \(LinearProgramming[{2, \(-3\)}, {{1}, {0, \(-1\)}}, {3, \(-1\)}]\)], \
"Output",
  CellLabel->"Out[1]=",
  CellTags->{"DualLinearProgramming::lprank2", "LinearProgramming::lprank2"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid input in ",
  StyleBox["LinearProgramming", "MR"],
  "."
}], "Text",
  CellTags->{"LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearProgramming[{2, \(-3\)}, {{1, 
          0}, {0, \(-1\)}}, {3, \(-1\)}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],

Cell[BoxData[
    \({3, 1}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"DualLinearProgramming::lprank2", "LinearProgramming::lprank2"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::lprank1
DualLinearProgramming::lprank1\
\>", "ObjectNameWarningMessages",
  CellTags->{"LinearProgramming::lprank1", "DualLinearProgramming::lprank1"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lprank1\"\>"}], \(\(:\)\(\ \)\), \(`1`\ is\ not\ a\ \
\(\(vector\)\(.\)\)\)}]], "Message",
  CellTags->{"LinearProgramming::lprank1", "DualLinearProgramming::lprank1"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"LinearProgramming::lprank1", "DualLinearProgramming::lprank1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::lprank12
DualLinearProgramming::lprank12\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lprank12", "DualLinearProgramming::lprank12"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lprank12\"\>"}], \(\(:\)\(\ \)\), \(`1`\ must\ be\ either\ \
a\ vector\ or\ a\ matrix\ with\ 2\ columns\)}]], "Message",
  CellTags->{
  "LinearProgramming::lprank12", "DualLinearProgramming::lprank12"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "LinearProgramming::lprank12", "DualLinearProgramming::lprank12"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::lprank012
DualLinearProgramming::lprank012\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lprank012", "DualLinearProgramming::lprank012"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lprank012\"\>"}], \(\(:\)\(\ \)\), \(`1`\ must\ be\ either\
\ a\ scaler, \ or\ a\ vector, \ 
      or\ a\ matrix\ with\ 2\ columns\)}]], "Message",
  CellTags->{
  "LinearProgramming::lprank012", "DualLinearProgramming::lprank012"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "LinearProgramming::lprank012", "DualLinearProgramming::lprank012"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::lpsg
DualLinearProgramming::lpsg\
\>", "ObjectNameWarningMessages",
  CellTags->{"LinearProgramming::lpsg", "DualLinearProgramming::lpsg"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpsg\"\>"}], \(\(:\)\(\ \)\), \(The\ second\ column\ of\ \
`1`\ must\ be\ a\ vector\ consisting\ of\  - 1, \ \ 1, \ 
      or\ 0, \ \(\(indicating\ respectively\ inequalities\ with\)\(\ \)\(<=\)\
\), \ \(\(=\)\(>\)\), \ or\ \(\(equality\)\(.\)\)\)}]], "Message",
  CellTags->{"LinearProgramming::lpsg", "DualLinearProgramming::lpsg"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"LinearProgramming::lpsg", "DualLinearProgramming::lpsg"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::lpmethod
DualLinearProgramming::lpmethod\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lpmethod", "DualLinearProgramming::lpmethod"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpmethod\"\>"}], \(\(:\)\(\ \)\), \(`1`\ is\ not\ a\ valid\
\ method\ for\ linear\ \(\(programming\)\(.\)\)\)}]], "Message",
  CellTags->{
  "LinearProgramming::lpmethod", "DualLinearProgramming::lpmethod"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "LinearProgramming::lpmethod", "DualLinearProgramming::lpmethod"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Optimization`LinearProgramming`Simplex::lpsiter
LinearProgramming::lpsiter
DualLinearProgramming::lpsiter\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsiter", 
    "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpsiter\"\>"}], \(\(:\)\(\ \)\), \(MaxIterations\ `1`\ \
must\ be\ a\ positive\ integer\ or\ \(\(Infinity\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsiter", 
    "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsiter", 
    "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Optimization`LinearProgramming`Simplex::lpsiter1
LinearProgramming::lpsiter1
DualLinearProgramming::lpsiter1\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsiter1", 
    "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpsiter1\"\>"}], \(\(:\)\(\ \)\), \(The\ number\ of\ \
iterations\ taken\ has\ exceeded\ the\ preset\ limit\ of\ MaxIterations\  = \ \
`1` . \ Try\ setting\ the\ MaxIterations\ option\ to\ a\ higher\ \(\(number\)\
\(.\)\)\)}]], "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsiter1", 
    "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsiter1", 
    "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::lpsbnn
DualLinearProgramming::lpsbnn
Optimization`LinearProgramming`Simplex::lpsbnn\
\>", \
"ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
    "Optimization`LinearProgramming`Simplex::lpsbnn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpsbnn\"\>"}], \(\(:\)\(\ \)\), \(Found\ lower\ bound\ and\
\ upper\ bound\ both\ set\ at\ \(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->{
  "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
    "Optimization`LinearProgramming`Simplex::lpsbnn"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
    "Optimization`LinearProgramming`Simplex::lpsbnn"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Optimization`LinearProgramming`Simplex::lpsom
LinearProgramming::lpsom
DualLinearProgramming::lpsom\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsom", "LinearProgramming::lpsom",
     "DualLinearProgramming::lpsom"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpsom\"\>"}], \(\(:\)\(\ \)\), "\<\"Warning: the option \
value of \\\"ScalingMethod\\\"->\\\"Optimal\\\" is not allowed for \
non-machine number problem. Switching to \
\\\"ScalingMethod\\\"->\\\"NormalizeRow\\\" instead.\"\>"}]], "Message",
  CellLabel->"From In[19]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsom", "LinearProgramming::lpsom",
     "DualLinearProgramming::lpsom"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsom", "LinearProgramming::lpsom",
     "DualLinearProgramming::lpsom"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Optimization`LinearProgramming`Simplex::lpsnf
ConstrainedMax::lpsnf
ConstrainedMin::lpsnf
LinearProgramming::lpsnf
DualLinearProgramming::lpsnf\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpsnf\"\>"}], \(\(:\)\(\ \)\), \(No\ solution\ can\ be\ \
found\ that\ satisfies\ the\ \(\(constraints\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function does not \
find a solution.\
\>", "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],

Cell["\<\
An error occurs in this example because the second argument is a \
zero matrix.\
\>", "Text",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearProgramming[{2, \(-3\)}, {{0, 0}, {0, 
          0}}, {3, \(-1\)}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],

Cell[BoxData[
    \(LinearProgramming::"lpsnf" \(\(:\)\(\ \)\) 
      "No solution can be found that satisfies the constraints."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],

Cell[BoxData[
    \(LinearProgramming[{2, \(-3\)}, {{0, 0}, {0, 
          0}}, {3, \(-1\)}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["LinearProgramming", "MR"],
  "."
}], "Text",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearProgramming[{2, \(-3\)}, {{1, 
          0}, {0, \(-1\)}}, {3, \(-1\)}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],

Cell[BoxData[
    \({3, 1}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Optimization`LinearProgramming`Simplex::lpspm
LinearProgramming::lpspm
DualLinearProgramming::lpspm\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpspm", "LinearProgramming::lpspm",
     "DualLinearProgramming::lpspm"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"lpspm\"\>"}], \(\(:\)\(\ \)\), "Pricing", " ", 
      "method", " ", "specification", " ", 
      StyleBox["spec",
        "TI"], " ", "is", " ", \(\(invalid\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpspm", "LinearProgramming::lpspm",
     "DualLinearProgramming::lpspm"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpspm", "LinearProgramming::lpspm",
     "DualLinearProgramming::lpspm"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Optimization`LinearProgramming`Simplex::lpstl
ConstrainedMax::lpstl
ConstrainedMin::lpstl
LinearProgramming::lpstl
DualLinearProgramming::lpstl\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpstl", "ConstrainedMax::lpstl", 
    "ConstrainedMin::lpstl", "LinearProgramming::lpstl", 
    "DualLinearProgramming::lpstl"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"lpstl\"\>"}], \(\(:\)\(\ \)\), "Tolerance", " ", 
      "specification", " ", 
      StyleBox["tol",
        "TI"], " ", "must", " ", "be", " ", "a", " ", "nonnegative", " ", 
      "real", " ", \(\(number\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpstl", "ConstrainedMax::lpstl", 
    "ConstrainedMin::lpstl", "LinearProgramming::lpstl", 
    "DualLinearProgramming::lpstl"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpstl", "ConstrainedMax::lpstl", 
    "ConstrainedMin::lpstl", "LinearProgramming::lpstl", 
    "DualLinearProgramming::lpstl"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Optimization`LinearProgramming`Simplex::lpstl2
ConstrainedMax::lpstl2
ConstrainedMin::lpstl2
LinearProgramming::lpstl2
DualLinearProgramming::lpstl2\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpstl2", "ConstrainedMax::lpstl2", 
    "ConstrainedMin::lpstl2", "LinearProgramming::lpstl2", 
    "DualLinearProgramming::lpstl2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"lpstl2\"\>"}], \(\(:\)\(\ \)\), "Tolerance", 
        " ", "specification", " ", 
        StyleBox["tol",
          "TI"], " ", \(invalid . \ For\), " ", "non"}], 
      "-", \(infinite\ precision\ problems\ tolerance\ must\ be\ a\ positive\ \
real\ \(\(number\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpstl2", "ConstrainedMax::lpstl2", 
    "ConstrainedMin::lpstl2", "LinearProgramming::lpstl2", 
    "DualLinearProgramming::lpstl2"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpstl2", "ConstrainedMax::lpstl2", 
    "ConstrainedMin::lpstl2", "LinearProgramming::lpstl2", 
    "DualLinearProgramming::lpstl2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Optimization`LinearProgramming`Simplex::lpssm
LinearProgramming::lpssm
DualLinearProgramming::lpssm\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpssm", "LinearProgramming::lpssm",
     "DualLinearProgramming::lpssm"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"lpssm\"\>"}], \(\(:\)\(\ \)\), "Scaling", " ", 
      "method", " ", "specification", " ", 
      StyleBox["spec",
        "TI"], " ", "is", " ", \(\(invalid\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpssm", "LinearProgramming::lpssm",
     "DualLinearProgramming::lpssm"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpssm", "LinearProgramming::lpssm",
     "DualLinearProgramming::lpssm"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Optimization`LinearProgramming`Simplex::lpsub
ConstrainedMax::lpsub
ConstrainedMin::lpsub
LinearProgramming::lpsub
DualLinearProgramming::lpsub\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsub", "ConstrainedMax::lpsub", 
    "ConstrainedMin::lpsub", "LinearProgramming::lpsub", 
    "DualLinearProgramming::lpsub"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpsub\"\>"}], \(\(:\)\(\ \)\), \(The\ problem\ is\ \
\(\(unbounded\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsub", "ConstrainedMax::lpsub", 
    "ConstrainedMin::lpsub", "LinearProgramming::lpsub", 
    "DualLinearProgramming::lpsub"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsub", "ConstrainedMax::lpsub", 
    "ConstrainedMin::lpsub", "LinearProgramming::lpsub", 
    "DualLinearProgramming::lpsub"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Optimization`LinearProgramming`Simplex::lpsdm2", \
"ObjectNameWarningMessages",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm2"],

Cell[BoxData[
    \(Optimization`LinearProgramming`Simplex::"lpsdm2" \(\(:\)\(\ \)\) \(The\ \
row\ dimension\ of\ the\ second\ and\ third\ arguments\ of\ the\ input\ does\ \
not\ \(\(match\)\(.\)\)\)\)], "Message",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm2"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Optimization`LinearProgramming`Simplex::lpsdm3", \
"ObjectNameWarningMessages",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm3"],

Cell[BoxData[
    \(Optimization`LinearProgramming`Simplex::"lpsdm3" \(\(:\)\(\ \)\) \(The\ \
row\ dimension\ of\ the\ fourth\ and\ fifth\ arguments\ of\ the\ input\ does\ \
not\ \(\(match\)\(.\)\)\)\)], "Message",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm3"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Optimization`LinearProgramming`Simplex::lpsdm4", \
"ObjectNameWarningMessages",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm4"],

Cell[BoxData[
    \(Optimization`LinearProgramming`Simplex::"lpsdm4" \(\(:\)\(\ \)\) \(The\ \
column\ dimension\ of\ the\ second\ argument\ does\ not\ match\ the\ length\ \
of\ the\ first\ \(\(argument\)\(.\)\)\)\)], "Message",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm4"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Optimization`LinearProgramming`Simplex::lpsdm5", \
"ObjectNameWarningMessages",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm5"],

Cell[BoxData[
    \(Optimization`LinearProgramming`Simplex::"lpsdm5" \(\(:\)\(\ \)\) \(The\ \
length\ of\ the\ first\ argument\ does\ not\ match\ the\ length\ of\ the\ \
lower\ bound\)\)], "Message",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm5"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Optimization`LinearProgramming`Simplex::lpsdm6", \
"ObjectNameWarningMessages",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm6"],

Cell[BoxData[
    \(Optimization`LinearProgramming`Simplex::"lpsdm6" \(\(:\)\(\ \)\) \(The\ \
length\ of\ the\ first\ argument\ does\ not\ match\ the\ length\ of\ the\ \
upper\ bound\)\)], "Message",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm6"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Optimization`LinearProgramming`Simplex::lpsdm7", \
"ObjectNameWarningMessages",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm7"],

Cell[BoxData[
    \(Optimization`LinearProgramming`Simplex::"lpsdm7" \(\(:\)\(\ \)\) \(The\ \
column\ dimensions\ of\ the\ fourth\ argument\ does\ not\ match\ the\ length\ \
of\ the\ first\ argument\)\)], "Message",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm7"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ConstrainedMax::cmcons
ConstrainedMin::cmcons\
\>", "ObjectNameWarningMessages",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"cmcons\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "list", " ", "of", " ",
         "valid", " ", "equalities", " ", "or", 
        " ", \(\(inequalities\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression from the \
second argument in ",
  StyleBox["ConstrainedMin", "MR"],
  " or ",
  StyleBox["ConstrainedMax", "MR"],
  " is not an equation or inequality.\n\[FilledSmallSquare] Equations can be \
entered using the notation ",
  StyleBox["lhs", "TI"],
  StyleBox["==", "MR"],
  StyleBox["rhs", "TI"],
  ", and inequalities can be entered using ",
  StyleBox["lhs", "TI"],
  StyleBox["<", "MR"],
  StyleBox["rhs", "TI"],
  ", ",
  StyleBox["lhs", "TI"],
  StyleBox["<=", "MR"],
  StyleBox["rhs", "TI"],
  ", ",
  StyleBox["lhs", "TI"],
  StyleBox[">", "MR"],
  StyleBox["rhs", "TI"],
  ", and ",
  StyleBox["lhs", "TI"],
  StyleBox[">=", "MR"],
  StyleBox["rhs", "TI"],
  ".\n\[FilledSmallSquare] The notation ",
  StyleBox["lhs", "TI"],
  StyleBox["=", "MR"],
  StyleBox["rhs", "TI"],
  " is used for assignments rather than for equations.  Evaluation of this \
input will attempt to assign a value to ",
  StyleBox["lhs", "TI"],
  "."
}], "Notes",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell["\<\
An error occurs in this example because one of the elements in the \
second argument is not an equation or inequality.\
\>", "Text",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ConstrainedMax[x + y, \ {x < 5, \ y === 1}, \ {x, y}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[BoxData[
    \(ConstrainedMax::"namedep" \(\(:\)\(\ \)\) 
      "The function \!\(\"ConstrainedMax\"\) has been deprecated and will be \
removed in a future version. Use the function \!\(\"NMaximize or Maximize\"\) \
instead."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[BoxData[
    \(ConstrainedMax::"cmcons" \(\(:\)\(\ \)\) 
      "\!\({\(\(x < 5\)\), False}\) is not a list of valid equalities or \
inequalities."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[BoxData[
    \(ConstrainedMax[x + y, {x < 5, False}, {x, y}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid input to ",
  StyleBox["ConstrainedMax", "MR"],
  "."
}], "Text",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ConstrainedMax[x + y, \ {x < 5, \ y == 1}, \ {x, y}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[BoxData[
    \(ConstrainedMax::"namedep" \(\(:\)\(\ \)\) 
      "The function \!\(\"ConstrainedMax\"\) has been deprecated and will be \
removed in a future version. Use the function \!\(\"NMaximize or Maximize\"\) \
instead."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[BoxData[
    \({6, {x \[Rule] 5, y \[Rule] 1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}]
}, Open  ]],

Cell[TextData[{
  "The notation ",
  StyleBox["lhs", "MR",
    FontSlant->"Italic"],
  StyleBox["=", "MR"],
  StyleBox["rhs", "MR",
    FontSlant->"Italic"],
  " is used for assignments rather than for equations.  After this error, the \
right-hand side of the expression may have been assigned a value."
}], "Text",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ConstrainedMax[
      var[1] + var[2], \ {var[1] < 5, \ var[2] = 1}, \ {var[1], 
        var[2]}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[BoxData[
    \(ConstrainedMax::"namedep" \(\(:\)\(\ \)\) 
      "The function \!\(\"ConstrainedMax\"\) has been deprecated and will be \
removed in a future version. Use the function \!\(\"NMaximize or Maximize\"\) \
instead."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[BoxData[
    \(ConstrainedMax::"cmcons" \(\(:\)\(\ \)\) 
      "\!\({\(\(\(\(var[1]\)\) < 5\)\), 1}\) is not a list of valid \
equalities or inequalities."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[BoxData[
    \(ConstrainedMax[
      var[1] + var[2], {var[1] < 5, 1}, {var[1], 1}]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?var\)\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell["Global`var", "Print",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[BoxData[
    InterpretationBox[GridBox[{
          {GridBox[{
                {\(var[2] = 1\)}
                },
              GridBaseline->{Baseline, {1, 1}},
              ColumnWidths->0.999,
              ColumnAlignments->{Left}]}
          },
        GridBaseline->{Baseline, {1, 1}},
        ColumnAlignments->{Left}],
      Definition[ "var"],
      Editable->False]], "Print",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}]
}, Open  ]],

Cell["\<\
The value that was assigned by mistake must be cleared before this \
input will behave as intended.\
\>", "Text",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[BoxData[
    \(Clear[var]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ConstrainedMax[
      var[1] + var[2], \ {var[1] < 5, \ var[2] == 1}, \ {var[1], 
        var[2]}]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[BoxData[
    \(ConstrainedMax::"namedep" \(\(:\)\(\ \)\) 
      "The function \!\(\"ConstrainedMax\"\) has been deprecated and will be \
removed in a future version. Use the function \!\(\"NMaximize or Maximize\"\) \
instead."\)], "Message",
  CellLabel->"From In[6]:=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[BoxData[
    \({6, {var[1] \[Rule] 5, var[2] \[Rule] 1}}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ConstrainedMax::cmfun
ConstrainedMin::cmfun\
\>", "ObjectNameWarningMessages",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"cmfun\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "linear", " ", 
        "function", " ", "of", " ", 
        StyleBox["vars",
          "TI"], " ", "with", " ", "real", 
        " ", \(\(coefficients\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["ConstrainedMax", "MR"],
  " or ",
  StyleBox["ConstrainedMin", "MR"],
  " is not a linear function of the indicated variables or when the \
coefficients are not real numbers.\n\[FilledSmallSquare] ",
  StyleBox["ConstrainedMin", "MR"],
  " and ",
  StyleBox["ConstrainedMax", "MR"],
  " are designed to handle minimization and maximization of a linear function \
subject to linear constraints."
}], "Notes",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],

Cell["\<\
An error occurs in this example because the first argument is not a \
linear function of the variable.\
\>", "Text",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ConstrainedMin[1 + x^2, x > 3, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],

Cell[BoxData[
    \(ConstrainedMin::"namedep" \(\(:\)\(\ \)\) 
      "The function \!\(\"ConstrainedMin\"\) has been deprecated and will be \
removed in a future version. Use the function \!\(\"NMinimize or Minimize\"\) \
instead."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],

Cell[BoxData[
    \(ConstrainedMin::"cmfun" \(\(:\)\(\ \)\) 
      "\!\(1 + x\^2\) is not a linear function of \!\(x\) with real \
coefficients."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],

Cell[BoxData[
    \(ConstrainedMin[1 + x\^2, x > 3, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ConstrainedMax::cmnc
ConstrainedMin::cmnc\
\>", "ObjectNameWarningMessages",
  CellTags->{"ConstrainedMax::cmnc", "ConstrainedMin::cmnc"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"cmnc\"\>"}], \(\(:\)\(\ \)\), "Non"}], "-", 
      RowBox[{"numerical", " ", "constraint", " ", 
        StyleBox["expr",
          "TI"], " ", \(\(encountered\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ConstrainedMax::cmnc", "ConstrainedMin::cmnc"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a constraint from the second argument \
of ",
  StyleBox["ConstrainedMax", "MR"],
  " or ",
  StyleBox["ConstrainedMin", "MR"],
  " contains coefficients that are not numbers."
}], "Notes",
  CellTags->{"ConstrainedMax::cmnc", "ConstrainedMin::cmnc"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::lptol
DualLinearProgramming::lptol
ConstrainedMin::lptol
ConstrainedMax::lptol\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
    "ConstrainedMin::lptol", "ConstrainedMax::lptol"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lptol\"\>"}], \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\ \
Tolerance\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ positive\ real\ number\ or\ \
\(\(Automatic\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
    "ConstrainedMin::lptol", "ConstrainedMax::lptol"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Tolerance", "MR"],
  " option in ",
  StyleBox["LinearProgramming", "MR"],
  " does not have the expected form."
}], "Notes",
  CellTags->{
  "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
    "ConstrainedMin::lptol", "ConstrainedMax::lptol"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::cmz
DualLinearProgramming::cmz
ConstrainedMin::cmz
ConstrainedMax::cmz\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
    "ConstrainedMin::cmz", "ConstrainedMax::cmz"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"cmz\"\>"}], \(\(:\)\(\ \)\), "For", " ", "the", 
      " ", "constraint", " ", "matrix", " ", 
      StyleBox["mat",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(to\ represent\ valid\ constraints, \ 
      each\ row\ must\ have\ length\ greater\ than\ zero\ and\ contain\ at\ \
least\ one\ nonzero\ \(\(entry\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
    "ConstrainedMin::cmz", "ConstrainedMax::cmz"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when all of the entries in the second \
argument of ",
  StyleBox["LinearProgramming", "MR"],
  " are zero."
}], "Notes",
  CellTags->{
  "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
    "ConstrainedMin::cmz", "ConstrainedMax::cmz"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearProgramming::cvr
DualLinearProgramming::cvr
ConstrainedMin::cvr
ConstrainedMax::cvr\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
    "ConstrainedMin::cvr", "ConstrainedMax::cvr"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"cvr\"\>"}], \(\(:\)\(\ \)\), "The", " ", "vector",
       " ", 
      StyleBox["vec",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(must\ be\ a\ nonzero\ length\ vector\ of\ real\ \
\(\(numbers\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
    "ConstrainedMin::cvr", "ConstrainedMax::cvr"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["LinearProgramming", "MR"],
  " has a length of zero or is a list in which not all of the elements are \
real numbers."
}], "Notes",
  CellTags->{
  "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
    "ConstrainedMin::cvr", "ConstrainedMax::cvr"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DualLinearProgramming::lpdinf
LinearProgramming::lpdinf\
\>", "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lpdinf", "LinearProgramming::lpdinf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpdinf\"\>"}], \(\(:\)\(\ \)\), \(The\ dual\ of\ this\ \
problem\ is\ infeasible, \ 
      implying\ that\ the\ problem\ is\ either\ unbounded\ or\ infeasible . \ 
            Setting\ the\ option\ Method -> `1`\ should\ give\ a\ more\ \
definite\ answer, \ 
      though\ it\ may\ take\ longer\ computing\ time\ for\ problem\ of\ large\
\ \(\(size\)\(.\)\)\)}]], "Message",
  CellTags->{"DualLinearProgramming::lpdinf", "LinearProgramming::lpdinf"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DualLinearProgramming::lpdinf", "LinearProgramming::lpdinf"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DualLinearProgramming::lpdinfp
LinearProgramming::lpdinfp\
\>", "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lpdinfp", "LinearProgramming::lpdinfp"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpdinfp\"\>"}], \(\(:\)\(\ \)\), \(The\ dual\ of\ this\ \
problem\ is\ possibly\ infeasible, \ 
      implying\ that\ the\ problem\ is\ either\ unbounded\ or\ infeasible . \ 
            Setting\ the\ option\ Method -> `1`\ should\ give\ a\ more\ \
definite\ answer, \ 
      though\ it\ may\ take\ longer\ computing\ time\ for\ problem\ of\ large\
\ \(\(size\)\(.\)\)\)}]], "Message",
  CellTags->{"DualLinearProgramming::lpdinfp", "LinearProgramming::lpdinfp"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DualLinearProgramming::lpdinfp", "LinearProgramming::lpdinfp"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DualLinearProgramming::lpipcv
LinearProgramming::lpipcv\
\>", "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lpipcv", "LinearProgramming::lpipcv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"lpipcv\"\>"}], \(\(:\)\(\ \)\), \(Warning : \ 
        the\ interior\ point\ algorithm\ can\ not\ converged\ to\ the\ \
tolerance\ of\ `2`, \ the\ best\ residual\ achieved\ is\ `1`, \ 
      the\ solution\ at\ that\ residual\ is\ returned . \ 
            Setting\ the\ option\ Method -> `3`\ should\ give\ a\ more\ \
definite\ answer, \ 
      though\ it\ may\ take\ longer\ computing\ time\ for\ problem\ of\ large\
\ \(\(size\)\(.\)\)\)}]], "Message",
  CellTags->{"DualLinearProgramming::lpipcv", "LinearProgramming::lpipcv"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DualLinearProgramming::lpipcv", "LinearProgramming::lpipcv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DualLinearProgramming::lpipncv
LinearProgramming::lpipncv\
\>", "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lpipncv", "LinearProgramming::lpipncv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpipncv\"\>"}], \(\(:\)\(\ \)\), \(Interior\ point\ can\ \
not\ converge\ to\ the\ tolerance\ of\ `1`, \ 
      the\ best\ residual\ achieved\ is\ `2` . \ 
            This\ may\ be\ because\ the\ problem\ is\ mildly\ infeasible . \ 
            Setting\ the\ option\ Method -> `3`\ should\ give\ a\ more\ \
definite\ answer, \ 
      though\ it\ may\ take\ longer\ computing\ time\ for\ problem\ of\ large\
\ \(\(size\)\(.\)\)\)}]], "Message",
  CellTags->{"DualLinearProgramming::lpipncv", "LinearProgramming::lpipncv"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DualLinearProgramming::lpipncv", "LinearProgramming::lpipncv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DualLinearProgramming::lpipp
LinearProgramming::lpipp\
\>", "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lpipp", "LinearProgramming::lpipp"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpipp\"\>"}], \(\(:\)\(\ \)\), \(Warning : \ Method -> 
        InteriorPoint\ specified\ for\ non - 
          machine\ precision\ problem . \ 
              Machine\ precision\ result\ will\ be\ given . \ 
              If\ a\ result\ of\ non - machine\ precision\ is\ needed, \ 
      set\ the\ option\ to\ Method -> \(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->{"DualLinearProgramming::lpipp", "LinearProgramming::lpipp"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DualLinearProgramming::lpipp", "LinearProgramming::lpipp"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DualLinearProgramming::lpitd
LinearProgramming::lpitd\
\>", "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lpitd", "LinearProgramming::lpitd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpitd\"\>"}], \(\(:\)\(\ \)\), "\<\"Value of option \
TreatDenseColumns->`1` is not True, False or Automatic.\"\>"}]], "Message",
  CellLabel->"From In[12]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"DualLinearProgramming::lpitd", "LinearProgramming::lpitd"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DualLinearProgramming::lpitd", "LinearProgramming::lpitd"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DualLinearProgramming::lplop
LinearProgramming::lplop\
\>", "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lplop", "LinearProgramming::lplop"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lplop\"\>"}], \(\(:\)\(\ \)\), \(For\ problem\ of\ this\ \
size, \ `1`\ uses\ interior\ point\ algorithm, \ 
      which\ only\ returns\ a\ result\ of\ machine\ precision . \ 
            If\ a\ result\ of\ non - machine\ precision\ is\ needed, \ 
      set\ the\ option\ to\ Method -> `2`, \ 
      though\ it\ may\ take\ longer\ computing\ \(\(time\)\(.\)\)\)}]], \
"Message",
  CellTags->{"DualLinearProgramming::lplop", "LinearProgramming::lplop"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DualLinearProgramming::lplop", "LinearProgramming::lplop"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DualLinearProgramming::lpsnfp
LinearProgramming::lpsnfp\
\>", "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lpsnfp", "LinearProgramming::lpsnfp"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lpsnfp\"\>"}], \(\(:\)\(\ \)\), \(The\ problem\ is\ \
probably\ infeasible . \ 
            Setting\ the\ option\ Method -> `1`\ should\ give\ a\ more\ \
definite\ answer, \ 
      though\ it\ may\ take\ longer\ computing\ time\ for\ problem\ of\ large\
\ \(\(size\)\(.\)\)\)}]], "Message",
  CellTags->{"DualLinearProgramming::lpsnfp", "LinearProgramming::lpsnfp"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DualLinearProgramming::lpsnfp", "LinearProgramming::lpsnfp"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DualLinearProgramming::lptols
LinearProgramming::lptols\
\>", "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lptols", "LinearProgramming::lptols"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"lptols\"\>"}], \(\(:\)\(\ \)\), \(Warning : \ 
        the\ supplied\ tolerance\ of\ `1`\ may\ be\ too\ small\ for\ interior\
\ point\ algorithm, \ 
      typically\ a\ reasonable\ tolerance\ for\ interior\ point\ algorithm\ \
is\ `2`\ \(\((square\ root\ of\ the\ machine\ epsilon)\)\(.\)\)\)}]], \
"Message",
  CellTags->{"DualLinearProgramming::lptols", "LinearProgramming::lptols"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"DualLinearProgramming::lptols", "LinearProgramming::lptols"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 975}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{641, 517},
WindowMargins->{{Automatic, 94}, {91, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "ConstrainedMax::cmnov"->{
    Cell[1836, 57, 152, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ConstrainedMax::cmnov", "ConstrainedMin::cmnov"}],
    Cell[1991, 63, 257, 7, 21, "Message",
      CellTags->{"ConstrainedMax::cmnov", "ConstrainedMin::cmnov"}],
    Cell[2251, 72, 159, 4, 24, "Notes",
      CellTags->{"ConstrainedMax::cmnov", "ConstrainedMin::cmnov"}]},
  "ConstrainedMin::cmnov"->{
    Cell[1836, 57, 152, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ConstrainedMax::cmnov", "ConstrainedMin::cmnov"}],
    Cell[1991, 63, 257, 7, 21, "Message",
      CellTags->{"ConstrainedMax::cmnov", "ConstrainedMin::cmnov"}],
    Cell[2251, 72, 159, 4, 24, "Notes",
      CellTags->{"ConstrainedMax::cmnov", "ConstrainedMin::cmnov"}]},
  "LinearProgramming::lpbd"->{
    Cell[2447, 81, 168, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"LinearProgramming::lpbd", "DualLinearProgramming::lpbd"}],
    Cell[2618, 87, 394, 9, 37, "Message",
      CellTags->{"LinearProgramming::lpbd", "DualLinearProgramming::lpbd"}],
    Cell[3015, 98, 167, 4, 24, "Notes",
      CellTags->{"LinearProgramming::lpbd", "DualLinearProgramming::lpbd"}]},
  "DualLinearProgramming::lpbd"->{
    Cell[2447, 81, 168, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"LinearProgramming::lpbd", "DualLinearProgramming::lpbd"}],
    Cell[2618, 87, 394, 9, 37, "Message",
      CellTags->{"LinearProgramming::lpbd", "DualLinearProgramming::lpbd"}],
    Cell[3015, 98, 167, 4, 24, "Notes",
      CellTags->{"LinearProgramming::lpbd", "DualLinearProgramming::lpbd"}]},
  "LinearProgramming::lpdim"->{
    Cell[3219, 107, 172, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[3394, 113, 369, 9, 37, "Message",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[3766, 124, 169, 4, 24, "Notes",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[3960, 132, 108, 1, 38, "ExampleSection",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[4071, 135, 176, 4, 24, "Text",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[4272, 143, 178, 3, 26, "Input",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[4453, 148, 272, 5, 37, "Message",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[4728, 155, 179, 3, 21, "Output",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[4922, 161, 182, 5, 24, "Text",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[5129, 170, 182, 3, 26, "Input",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[5314, 175, 138, 3, 21, "Output",
      CellTags->{
      "LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}]},
  "DualLinearProgramming::lpdim"->{
    Cell[3219, 107, 172, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[3394, 113, 369, 9, 37, "Message",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[3766, 124, 169, 4, 24, "Notes",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[3960, 132, 108, 1, 38, "ExampleSection",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[4071, 135, 176, 4, 24, "Text",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[4272, 143, 178, 3, 26, "Input",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[4453, 148, 272, 5, 37, "Message",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[4728, 155, 179, 3, 21, "Output",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[4922, 161, 182, 5, 24, "Text",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[5129, 170, 182, 3, 26, "Input",
      CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
    
    Cell[5314, 175, 138, 3, 21, "Output",
      CellTags->{
      "LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}]},
  "LinearProgramming::lpnn"->{
    Cell[5513, 185, 266, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lpnn", "ConstrainedMax::lpnn", 
        "ConstrainedMin::lpnn", "DualLinearProgramming::lpnn"}],
    Cell[5782, 195, 523, 12, 69, "Message",
      CellTags->{
      "LinearProgramming::lpnn", "ConstrainedMax::lpnn", 
        "ConstrainedMin::lpnn", "DualLinearProgramming::lpnn"}],
    Cell[6308, 209, 223, 6, 24, "Notes",
      CellTags->{
      "LinearProgramming::lpnn", "ConstrainedMax::lpnn", 
        "ConstrainedMin::lpnn", "DualLinearProgramming::lpnn"}]},
  "ConstrainedMax::lpnn"->{
    Cell[5513, 185, 266, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lpnn", "ConstrainedMax::lpnn", 
        "ConstrainedMin::lpnn", "DualLinearProgramming::lpnn"}],
    Cell[5782, 195, 523, 12, 69, "Message",
      CellTags->{
      "LinearProgramming::lpnn", "ConstrainedMax::lpnn", 
        "ConstrainedMin::lpnn", "DualLinearProgramming::lpnn"}],
    Cell[6308, 209, 223, 6, 24, "Notes",
      CellTags->{
      "LinearProgramming::lpnn", "ConstrainedMax::lpnn", 
        "ConstrainedMin::lpnn", "DualLinearProgramming::lpnn"}]},
  "ConstrainedMin::lpnn"->{
    Cell[5513, 185, 266, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lpnn", "ConstrainedMax::lpnn", 
        "ConstrainedMin::lpnn", "DualLinearProgramming::lpnn"}],
    Cell[5782, 195, 523, 12, 69, "Message",
      CellTags->{
      "LinearProgramming::lpnn", "ConstrainedMax::lpnn", 
        "ConstrainedMin::lpnn", "DualLinearProgramming::lpnn"}],
    Cell[6308, 209, 223, 6, 24, "Notes",
      CellTags->{
      "LinearProgramming::lpnn", "ConstrainedMax::lpnn", 
        "ConstrainedMin::lpnn", "DualLinearProgramming::lpnn"}]},
  "DualLinearProgramming::lpnn"->{
    Cell[5513, 185, 266, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lpnn", "ConstrainedMax::lpnn", 
        "ConstrainedMin::lpnn", "DualLinearProgramming::lpnn"}],
    Cell[5782, 195, 523, 12, 69, "Message",
      CellTags->{
      "LinearProgramming::lpnn", "ConstrainedMax::lpnn", 
        "ConstrainedMin::lpnn", "DualLinearProgramming::lpnn"}],
    Cell[6308, 209, 223, 6, 24, "Notes",
      CellTags->{
      "LinearProgramming::lpnn", "ConstrainedMax::lpnn", 
        "ConstrainedMin::lpnn", "DualLinearProgramming::lpnn"}]},
  "LinearProgramming::cmr"->{
    Cell[6568, 220, 258, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
        "ConstrainedMin::cmr", "ConstrainedMax::cmr"}],
    Cell[6829, 230, 532, 15, 21, "Message",
      CellTags->{
      "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
        "ConstrainedMin::cmr", "ConstrainedMax::cmr"}],
    Cell[7364, 247, 325, 7, 40, "Notes",
      CellTags->{
      "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
        "ConstrainedMin::cmr", "ConstrainedMax::cmr"}]},
  "DualLinearProgramming::cmr"->{
    Cell[6568, 220, 258, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
        "ConstrainedMin::cmr", "ConstrainedMax::cmr"}],
    Cell[6829, 230, 532, 15, 21, "Message",
      CellTags->{
      "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
        "ConstrainedMin::cmr", "ConstrainedMax::cmr"}],
    Cell[7364, 247, 325, 7, 40, "Notes",
      CellTags->{
      "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
        "ConstrainedMin::cmr", "ConstrainedMax::cmr"}]},
  "ConstrainedMin::cmr"->{
    Cell[6568, 220, 258, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
        "ConstrainedMin::cmr", "ConstrainedMax::cmr"}],
    Cell[6829, 230, 532, 15, 21, "Message",
      CellTags->{
      "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
        "ConstrainedMin::cmr", "ConstrainedMax::cmr"}],
    Cell[7364, 247, 325, 7, 40, "Notes",
      CellTags->{
      "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
        "ConstrainedMin::cmr", "ConstrainedMax::cmr"}]},
  "ConstrainedMax::cmr"->{
    Cell[6568, 220, 258, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
        "ConstrainedMin::cmr", "ConstrainedMax::cmr"}],
    Cell[6829, 230, 532, 15, 21, "Message",
      CellTags->{
      "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
        "ConstrainedMin::cmr", "ConstrainedMax::cmr"}],
    Cell[7364, 247, 325, 7, 40, "Notes",
      CellTags->{
      "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
        "ConstrainedMin::cmr", "ConstrainedMax::cmr"}]},
  "LinearProgramming::lprank2"->{
    Cell[7726, 259, 180, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[7909, 265, 396, 11, 21, "Message",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[8308, 278, 232, 5, 24, "Notes",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[8565, 287, 112, 1, 38, "ExampleSection",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[8680, 290, 180, 4, 24, "Text",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[8885, 298, 200, 4, 26, "Input",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[9088, 304, 259, 5, 21, "Message",
      CellTags->{
      "DualLinearProgramming::lprank2", "LinearProgramming::lprank2"}],
    Cell[9350, 311, 201, 4, 21, "Output",
      CellTags->{
      "DualLinearProgramming::lprank2", "LinearProgramming::lprank2"}],
    Cell[9566, 318, 182, 5, 24, "Text",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[9773, 327, 212, 4, 26, "Input",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[9988, 333, 142, 3, 21, "Output",
      CellTags->{
      "DualLinearProgramming::lprank2", "LinearProgramming::lprank2"}]},
  "DualLinearProgramming::lprank2"->{
    Cell[7726, 259, 180, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[7909, 265, 396, 11, 21, "Message",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[8308, 278, 232, 5, 24, "Notes",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[8565, 287, 112, 1, 38, "ExampleSection",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[8680, 290, 180, 4, 24, "Text",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[8885, 298, 200, 4, 26, "Input",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[9088, 304, 259, 5, 21, "Message",
      CellTags->{
      "DualLinearProgramming::lprank2", "LinearProgramming::lprank2"}],
    Cell[9350, 311, 201, 4, 21, "Output",
      CellTags->{
      "DualLinearProgramming::lprank2", "LinearProgramming::lprank2"}],
    Cell[9566, 318, 182, 5, 24, "Text",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[9773, 327, 212, 4, 26, "Input",
      CellTags->{
      "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
    Cell[9988, 333, 142, 3, 21, "Output",
      CellTags->{
      "DualLinearProgramming::lprank2", "LinearProgramming::lprank2"}]},
  "LinearProgramming::lprank1"->{
    Cell[10191, 343, 180, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lprank1", "DualLinearProgramming::lprank1"}],
    Cell[10374, 349, 276, 7, 21, "Message",
      CellTags->{
      "LinearProgramming::lprank1", "DualLinearProgramming::lprank1"}],
    Cell[10653, 358, 173, 4, 24, "Notes",
      CellTags->{
      "LinearProgramming::lprank1", "DualLinearProgramming::lprank1"}]},
  "DualLinearProgramming::lprank1"->{
    Cell[10191, 343, 180, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lprank1", "DualLinearProgramming::lprank1"}],
    Cell[10374, 349, 276, 7, 21, "Message",
      CellTags->{
      "LinearProgramming::lprank1", "DualLinearProgramming::lprank1"}],
    Cell[10653, 358, 173, 4, 24, "Notes",
      CellTags->{
      "LinearProgramming::lprank1", "DualLinearProgramming::lprank1"}]},
  "LinearProgramming::lprank12"->{
    Cell[10863, 367, 187, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lprank12", "DualLinearProgramming::lprank12"}],
    Cell[11053, 374, 311, 8, 21, "Message",
      CellTags->{
      "LinearProgramming::lprank12", "DualLinearProgramming::lprank12"}],
    Cell[11367, 384, 178, 5, 24, "Notes",
      CellTags->{
      "LinearProgramming::lprank12", "DualLinearProgramming::lprank12"}]},
  "DualLinearProgramming::lprank12"->{
    Cell[10863, 367, 187, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lprank12", "DualLinearProgramming::lprank12"}],
    Cell[11053, 374, 311, 8, 21, "Message",
      CellTags->{
      "LinearProgramming::lprank12", "DualLinearProgramming::lprank12"}],
    Cell[11367, 384, 178, 5, 24, "Notes",
      CellTags->{
      "LinearProgramming::lprank12", "DualLinearProgramming::lprank12"}]},
  "LinearProgramming::lprank012"->{
    Cell[11582, 394, 191, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lprank012", "DualLinearProgramming::lprank012"}],
    Cell[11776, 401, 340, 9, 37, "Message",
      CellTags->{
      "LinearProgramming::lprank012", "DualLinearProgramming::lprank012"}],
    Cell[12119, 412, 180, 5, 24, "Notes",
      CellTags->{
      "LinearProgramming::lprank012", "DualLinearProgramming::lprank012"}]},
  "DualLinearProgramming::lprank012"->{
    Cell[11582, 394, 191, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lprank012", "DualLinearProgramming::lprank012"}],
    Cell[11776, 401, 340, 9, 37, "Message",
      CellTags->{
      "LinearProgramming::lprank012", "DualLinearProgramming::lprank012"}],
    Cell[12119, 412, 180, 5, 24, "Notes",
      CellTags->{
      "LinearProgramming::lprank012", "DualLinearProgramming::lprank012"}]},
  "LinearProgramming::lpsg"->{
    Cell[12336, 422, 168, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"LinearProgramming::lpsg", "DualLinearProgramming::lpsg"}],
    Cell[12507, 428, 442, 9, 37, "Message",
      CellTags->{"LinearProgramming::lpsg", "DualLinearProgramming::lpsg"}],
    Cell[12952, 439, 167, 4, 24, "Notes",
      CellTags->{"LinearProgramming::lpsg", "DualLinearProgramming::lpsg"}]},
  "DualLinearProgramming::lpsg"->{
    Cell[12336, 422, 168, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"LinearProgramming::lpsg", "DualLinearProgramming::lpsg"}],
    Cell[12507, 428, 442, 9, 37, "Message",
      CellTags->{"LinearProgramming::lpsg", "DualLinearProgramming::lpsg"}],
    Cell[12952, 439, 167, 4, 24, "Notes",
      CellTags->{"LinearProgramming::lpsg", "DualLinearProgramming::lpsg"}]},
  "LinearProgramming::lpmethod"->{
    Cell[13156, 448, 187, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lpmethod", "DualLinearProgramming::lpmethod"}],
    Cell[13346, 455, 315, 8, 21, "Message",
      CellTags->{
      "LinearProgramming::lpmethod", "DualLinearProgramming::lpmethod"}],
    Cell[13664, 465, 178, 5, 24, "Notes",
      CellTags->{
      "LinearProgramming::lpmethod", "DualLinearProgramming::lpmethod"}]},
  "DualLinearProgramming::lpmethod"->{
    Cell[13156, 448, 187, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lpmethod", "DualLinearProgramming::lpmethod"}],
    Cell[13346, 455, 315, 8, 21, "Message",
      CellTags->{
      "LinearProgramming::lpmethod", "DualLinearProgramming::lpmethod"}],
    Cell[13664, 465, 178, 5, 24, "Notes",
      CellTags->{
      "LinearProgramming::lpmethod", "DualLinearProgramming::lpmethod"}]},
  "Optimization`LinearProgramming`Simplex::lpsiter"->{
    Cell[13879, 475, 287, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter", 
        "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}],
    Cell[14169, 484, 376, 9, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter", 
        "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}],
    Cell[14548, 495, 232, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter", 
        "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}]},
  "LinearProgramming::lpsiter"->{
    Cell[13879, 475, 287, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter", 
        "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}],
    Cell[14169, 484, 376, 9, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter", 
        "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}],
    Cell[14548, 495, 232, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter", 
        "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}]},
  "DualLinearProgramming::lpsiter"->{
    Cell[13879, 475, 287, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter", 
        "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}],
    Cell[14169, 484, 376, 9, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter", 
        "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}],
    Cell[14548, 495, 232, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter", 
        "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}]},
  "Optimization`LinearProgramming`Simplex::lpsiter1"->{
    Cell[14817, 506, 293, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter1", 
        "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}],
    Cell[15113, 515, 486, 11, 53, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter1", 
        "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}],
    Cell[15602, 528, 235, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter1", 
        "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}]},
  "LinearProgramming::lpsiter1"->{
    Cell[14817, 506, 293, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter1", 
        "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}],
    Cell[15113, 515, 486, 11, 53, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter1", 
        "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}],
    Cell[15602, 528, 235, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter1", 
        "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}]},
  "DualLinearProgramming::lpsiter1"->{
    Cell[14817, 506, 293, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter1", 
        "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}],
    Cell[15113, 515, 486, 11, 53, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter1", 
        "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}],
    Cell[15602, 528, 235, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsiter1", 
        "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}]},
  "LinearProgramming::lpsbnn"->{
    Cell[15874, 539, 283, 8, 71, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
        "Optimization`LinearProgramming`Simplex::lpsbnn"}],
    Cell[16160, 549, 366, 9, 21, "Message",
      CellTags->{
      "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
        "Optimization`LinearProgramming`Simplex::lpsbnn"}],
    Cell[16529, 560, 229, 6, 24, "Notes",
      CellTags->{
      "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
        "Optimization`LinearProgramming`Simplex::lpsbnn"}]},
  "DualLinearProgramming::lpsbnn"->{
    Cell[15874, 539, 283, 8, 71, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
        "Optimization`LinearProgramming`Simplex::lpsbnn"}],
    Cell[16160, 549, 366, 9, 21, "Message",
      CellTags->{
      "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
        "Optimization`LinearProgramming`Simplex::lpsbnn"}],
    Cell[16529, 560, 229, 6, 24, "Notes",
      CellTags->{
      "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
        "Optimization`LinearProgramming`Simplex::lpsbnn"}]},
  "Optimization`LinearProgramming`Simplex::lpsbnn"->{
    Cell[15874, 539, 283, 8, 71, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
        "Optimization`LinearProgramming`Simplex::lpsbnn"}],
    Cell[16160, 549, 366, 9, 21, "Message",
      CellTags->{
      "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
        "Optimization`LinearProgramming`Simplex::lpsbnn"}],
    Cell[16529, 560, 229, 6, 24, "Notes",
      CellTags->{
      "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
        "Optimization`LinearProgramming`Simplex::lpsbnn"}]},
  "Optimization`LinearProgramming`Simplex::lpsom"->{
    Cell[16795, 571, 275, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsom", 
        "LinearProgramming::lpsom", "DualLinearProgramming::lpsom"}],
    Cell[17073, 580, 563, 14, 69, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsom", 
        "LinearProgramming::lpsom", "DualLinearProgramming::lpsom"}],
    Cell[17639, 596, 226, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsom", 
        "LinearProgramming::lpsom", "DualLinearProgramming::lpsom"}]},
  "LinearProgramming::lpsom"->{
    Cell[16795, 571, 275, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsom", 
        "LinearProgramming::lpsom", "DualLinearProgramming::lpsom"}],
    Cell[17073, 580, 563, 14, 69, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsom", 
        "LinearProgramming::lpsom", "DualLinearProgramming::lpsom"}],
    Cell[17639, 596, 226, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsom", 
        "LinearProgramming::lpsom", "DualLinearProgramming::lpsom"}]},
  "DualLinearProgramming::lpsom"->{
    Cell[16795, 571, 275, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsom", 
        "LinearProgramming::lpsom", "DualLinearProgramming::lpsom"}],
    Cell[17073, 580, 563, 14, 69, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsom", 
        "LinearProgramming::lpsom", "DualLinearProgramming::lpsom"}],
    Cell[17639, 596, 226, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsom", 
        "LinearProgramming::lpsom", "DualLinearProgramming::lpsom"}]},
  "Optimization`LinearProgramming`Simplex::lpsnf"->{
    Cell[17902, 607, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[18279, 619, 422, 10, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[18704, 631, 297, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19026, 642, 220, 4, 38, "ExampleSection",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19249, 648, 289, 7, 24, "Text",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19563, 659, 315, 7, 26, "Input",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19881, 668, 360, 8, 37, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20244, 678, 316, 7, 21, "Output",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20575, 688, 294, 8, 24, "Text",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20894, 700, 320, 7, 26, "Input",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[21217, 709, 250, 6, 21, "Output",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}]},
  "ConstrainedMax::lpsnf"->{
    Cell[17902, 607, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[18279, 619, 422, 10, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[18704, 631, 297, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19026, 642, 220, 4, 38, "ExampleSection",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19249, 648, 289, 7, 24, "Text",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19563, 659, 315, 7, 26, "Input",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19881, 668, 360, 8, 37, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20244, 678, 316, 7, 21, "Output",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20575, 688, 294, 8, 24, "Text",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20894, 700, 320, 7, 26, "Input",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[21217, 709, 250, 6, 21, "Output",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}]},
  "ConstrainedMin::lpsnf"->{
    Cell[17902, 607, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[18279, 619, 422, 10, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[18704, 631, 297, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19026, 642, 220, 4, 38, "ExampleSection",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19249, 648, 289, 7, 24, "Text",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19563, 659, 315, 7, 26, "Input",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19881, 668, 360, 8, 37, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20244, 678, 316, 7, 21, "Output",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20575, 688, 294, 8, 24, "Text",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20894, 700, 320, 7, 26, "Input",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[21217, 709, 250, 6, 21, "Output",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}]},
  "LinearProgramming::lpsnf"->{
    Cell[17902, 607, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[18279, 619, 422, 10, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[18704, 631, 297, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19026, 642, 220, 4, 38, "ExampleSection",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19249, 648, 289, 7, 24, "Text",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19563, 659, 315, 7, 26, "Input",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19881, 668, 360, 8, 37, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20244, 678, 316, 7, 21, "Output",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20575, 688, 294, 8, 24, "Text",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20894, 700, 320, 7, 26, "Input",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[21217, 709, 250, 6, 21, "Output",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}]},
  "DualLinearProgramming::lpsnf"->{
    Cell[17902, 607, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[18279, 619, 422, 10, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[18704, 631, 297, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19026, 642, 220, 4, 38, "ExampleSection",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19249, 648, 289, 7, 24, "Text",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19563, 659, 315, 7, 26, "Input",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[19881, 668, 360, 8, 37, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20244, 678, 316, 7, 21, "Output",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20575, 688, 294, 8, 24, "Text",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[20894, 700, 320, 7, 26, "Input",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}],
    Cell[21217, 709, 250, 6, 21, "Output",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsnf", 
        "ConstrainedMax::lpsnf", "ConstrainedMin::lpsnf", 
        "LinearProgramming::lpsnf", "DualLinearProgramming::lpsnf"}]},
  "Optimization`LinearProgramming`Simplex::lpspm"->{
    Cell[21528, 722, 275, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpspm", 
        "LinearProgramming::lpspm", "DualLinearProgramming::lpspm"}],
    Cell[21806, 731, 463, 12, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpspm", 
        "LinearProgramming::lpspm", "DualLinearProgramming::lpspm"}],
    Cell[22272, 745, 226, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpspm", 
        "LinearProgramming::lpspm", "DualLinearProgramming::lpspm"}]},
  "LinearProgramming::lpspm"->{
    Cell[21528, 722, 275, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpspm", 
        "LinearProgramming::lpspm", "DualLinearProgramming::lpspm"}],
    Cell[21806, 731, 463, 12, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpspm", 
        "LinearProgramming::lpspm", "DualLinearProgramming::lpspm"}],
    Cell[22272, 745, 226, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpspm", 
        "LinearProgramming::lpspm", "DualLinearProgramming::lpspm"}]},
  "DualLinearProgramming::lpspm"->{
    Cell[21528, 722, 275, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpspm", 
        "LinearProgramming::lpspm", "DualLinearProgramming::lpspm"}],
    Cell[21806, 731, 463, 12, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpspm", 
        "LinearProgramming::lpspm", "DualLinearProgramming::lpspm"}],
    Cell[22272, 745, 226, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpspm", 
        "LinearProgramming::lpspm", "DualLinearProgramming::lpspm"}]},
  "Optimization`LinearProgramming`Simplex::lpstl"->{
    Cell[22535, 756, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}],
    Cell[22912, 768, 566, 14, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}],
    Cell[23481, 784, 281, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}]},
  "ConstrainedMax::lpstl"->{
    Cell[22535, 756, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}],
    Cell[22912, 768, 566, 14, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}],
    Cell[23481, 784, 281, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}]},
  "ConstrainedMin::lpstl"->{
    Cell[22535, 756, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}],
    Cell[22912, 768, 566, 14, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}],
    Cell[23481, 784, 281, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}]},
  "LinearProgramming::lpstl"->{
    Cell[22535, 756, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}],
    Cell[22912, 768, 566, 14, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}],
    Cell[23481, 784, 281, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}]},
  "DualLinearProgramming::lpstl"->{
    Cell[22535, 756, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}],
    Cell[22912, 768, 566, 14, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}],
    Cell[23481, 784, 281, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl", 
        "ConstrainedMax::lpstl", "ConstrainedMin::lpstl", 
        "LinearProgramming::lpstl", "DualLinearProgramming::lpstl"}]},
  "Optimization`LinearProgramming`Simplex::lpstl2"->{
    Cell[23799, 796, 384, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}],
    Cell[24186, 808, 649, 16, 37, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}],
    Cell[24838, 826, 286, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}]},
  "ConstrainedMax::lpstl2"->{
    Cell[23799, 796, 384, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}],
    Cell[24186, 808, 649, 16, 37, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}],
    Cell[24838, 826, 286, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}]},
  "ConstrainedMin::lpstl2"->{
    Cell[23799, 796, 384, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}],
    Cell[24186, 808, 649, 16, 37, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}],
    Cell[24838, 826, 286, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}]},
  "LinearProgramming::lpstl2"->{
    Cell[23799, 796, 384, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}],
    Cell[24186, 808, 649, 16, 37, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}],
    Cell[24838, 826, 286, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}]},
  "DualLinearProgramming::lpstl2"->{
    Cell[23799, 796, 384, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}],
    Cell[24186, 808, 649, 16, 37, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}],
    Cell[24838, 826, 286, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpstl2", 
        "ConstrainedMax::lpstl2", "ConstrainedMin::lpstl2", 
        "LinearProgramming::lpstl2", "DualLinearProgramming::lpstl2"}]},
  "Optimization`LinearProgramming`Simplex::lpssm"->{
    Cell[25161, 838, 275, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpssm", 
        "LinearProgramming::lpssm", "DualLinearProgramming::lpssm"}],
    Cell[25439, 847, 463, 12, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpssm", 
        "LinearProgramming::lpssm", "DualLinearProgramming::lpssm"}],
    Cell[25905, 861, 226, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpssm", 
        "LinearProgramming::lpssm", "DualLinearProgramming::lpssm"}]},
  "LinearProgramming::lpssm"->{
    Cell[25161, 838, 275, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpssm", 
        "LinearProgramming::lpssm", "DualLinearProgramming::lpssm"}],
    Cell[25439, 847, 463, 12, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpssm", 
        "LinearProgramming::lpssm", "DualLinearProgramming::lpssm"}],
    Cell[25905, 861, 226, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpssm", 
        "LinearProgramming::lpssm", "DualLinearProgramming::lpssm"}]},
  "DualLinearProgramming::lpssm"->{
    Cell[25161, 838, 275, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpssm", 
        "LinearProgramming::lpssm", "DualLinearProgramming::lpssm"}],
    Cell[25439, 847, 463, 12, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpssm", 
        "LinearProgramming::lpssm", "DualLinearProgramming::lpssm"}],
    Cell[25905, 861, 226, 6, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpssm", 
        "LinearProgramming::lpssm", "DualLinearProgramming::lpssm"}]},
  "Optimization`LinearProgramming`Simplex::lpsub"->{
    Cell[26168, 872, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}],
    Cell[26545, 884, 386, 10, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}],
    Cell[26934, 896, 281, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}]},
  "ConstrainedMax::lpsub"->{
    Cell[26168, 872, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}],
    Cell[26545, 884, 386, 10, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}],
    Cell[26934, 896, 281, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}]},
  "ConstrainedMin::lpsub"->{
    Cell[26168, 872, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}],
    Cell[26545, 884, 386, 10, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}],
    Cell[26934, 896, 281, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}]},
  "LinearProgramming::lpsub"->{
    Cell[26168, 872, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}],
    Cell[26545, 884, 386, 10, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}],
    Cell[26934, 896, 281, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}]},
  "DualLinearProgramming::lpsub"->{
    Cell[26168, 872, 374, 10, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}],
    Cell[26545, 884, 386, 10, 21, "Message",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}],
    Cell[26934, 896, 281, 7, 24, "Notes",
      CellTags->{
      "Optimization`LinearProgramming`Simplex::lpsub", 
        "ConstrainedMax::lpsub", "ConstrainedMin::lpsub", 
        "LinearProgramming::lpsub", "DualLinearProgramming::lpsub"}]},
  "Optimization`LinearProgramming`Simplex::lpsdm2"->{
    Cell[27252, 908, 147, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm2"],
    Cell[27402, 912, 276, 4, 37, "Message",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm2"],
    Cell[27681, 918, 157, 4, 24, "Notes",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm2"]},
  "Optimization`LinearProgramming`Simplex::lpsdm3"->{
    Cell[27875, 927, 147, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm3"],
    Cell[28025, 931, 276, 4, 37, "Message",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm3"],
    Cell[28304, 937, 157, 4, 24, "Notes",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm3"]},
  "Optimization`LinearProgramming`Simplex::lpsdm4"->{
    Cell[28498, 946, 147, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm4"],
    Cell[28648, 950, 289, 4, 37, "Message",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm4"],
    Cell[28940, 956, 157, 4, 24, "Notes",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm4"]},
  "Optimization`LinearProgramming`Simplex::lpsdm5"->{
    Cell[29134, 965, 147, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm5"],
    Cell[29284, 969, 261, 4, 37, "Message",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm5"],
    Cell[29548, 975, 157, 4, 24, "Notes",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm5"]},
  "Optimization`LinearProgramming`Simplex::lpsdm6"->{
    Cell[29742, 984, 147, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm6"],
    Cell[29892, 988, 261, 4, 37, "Message",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm6"],
    Cell[30156, 994, 157, 4, 24, "Notes",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm6"]},
  "Optimization`LinearProgramming`Simplex::lpsdm7"->{
    Cell[30350, 1003, 147, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm7"],
    Cell[30500, 1007, 277, 4, 37, "Message",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm7"],
    Cell[30780, 1013, 157, 4, 24, "Notes",
      CellTags->"Optimization`LinearProgramming`Simplex::lpsdm7"]},
  "ConstrainedMax::cmcons"->{
    Cell[30974, 1022, 156, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[31133, 1028, 466, 12, 21, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[31602, 1042, 1091, 36, 116, "Notes",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[32718, 1082, 100, 1, 38, "ExampleSection",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[32821, 1085, 208, 4, 40, "Text",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[33054, 1093, 176, 3, 26, "Input",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[33233, 1098, 341, 6, 53, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[33577, 1106, 261, 5, 37, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[33841, 1113, 169, 3, 21, "Output",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[34025, 1119, 167, 5, 24, "Text",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[34217, 1128, 175, 3, 26, "Input",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[34395, 1133, 341, 6, 53, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[34739, 1141, 155, 3, 21, "Output",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[34909, 1147, 382, 10, 40, "Text",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[35316, 1161, 220, 5, 42, "Input",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[35539, 1168, 341, 6, 53, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[35883, 1176, 270, 5, 37, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[36156, 1183, 192, 4, 21, "Output",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[36385, 1192, 131, 3, 26, "Input",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[36519, 1197, 93, 1, 21, "Print",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[36615, 1200, 458, 13, 21, "Print",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[37088, 1216, 189, 4, 24, "Text",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[37280, 1222, 133, 3, 26, "Input",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[37438, 1229, 221, 5, 42, "Input",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[37662, 1236, 341, 6, 53, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[38006, 1244, 165, 3, 21, "Output",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}]},
  "ConstrainedMin::cmcons"->{
    Cell[30974, 1022, 156, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[31133, 1028, 466, 12, 21, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[31602, 1042, 1091, 36, 116, "Notes",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[32718, 1082, 100, 1, 38, "ExampleSection",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[32821, 1085, 208, 4, 40, "Text",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[33054, 1093, 176, 3, 26, "Input",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[33233, 1098, 341, 6, 53, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[33577, 1106, 261, 5, 37, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[33841, 1113, 169, 3, 21, "Output",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[34025, 1119, 167, 5, 24, "Text",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[34217, 1128, 175, 3, 26, "Input",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[34395, 1133, 341, 6, 53, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[34739, 1141, 155, 3, 21, "Output",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[34909, 1147, 382, 10, 40, "Text",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[35316, 1161, 220, 5, 42, "Input",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[35539, 1168, 341, 6, 53, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[35883, 1176, 270, 5, 37, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[36156, 1183, 192, 4, 21, "Output",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[36385, 1192, 131, 3, 26, "Input",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[36519, 1197, 93, 1, 21, "Print",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[36615, 1200, 458, 13, 21, "Print",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[37088, 1216, 189, 4, 24, "Text",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[37280, 1222, 133, 3, 26, "Input",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[37438, 1229, 221, 5, 42, "Input",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[37662, 1236, 341, 6, 53, "Message",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
    Cell[38006, 1244, 165, 3, 21, "Output",
      CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}]},
  "ConstrainedMax::cmfun"->{
    Cell[38232, 1254, 152, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[38387, 1260, 512, 14, 21, "Message",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[38902, 1276, 563, 13, 78, "Notes",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[39490, 1293, 98, 1, 38, "ExampleSection",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[39591, 1296, 190, 4, 24, "Text",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[39806, 1304, 154, 3, 26, "Input",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[39963, 1309, 339, 6, 53, "Message",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[40305, 1317, 253, 5, 39, "Message",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[40561, 1324, 156, 3, 23, "Output",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}]},
  "ConstrainedMin::cmfun"->{
    Cell[38232, 1254, 152, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[38387, 1260, 512, 14, 21, "Message",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[38902, 1276, 563, 13, 78, "Notes",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[39490, 1293, 98, 1, 38, "ExampleSection",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[39591, 1296, 190, 4, 24, "Text",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[39806, 1304, 154, 3, 26, "Input",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[39963, 1309, 339, 6, 53, "Message",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[40305, 1317, 253, 5, 39, "Message",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
    Cell[40561, 1324, 156, 3, 23, "Output",
      CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}]},
  "ConstrainedMax::cmnc"->{
    Cell[40778, 1334, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ConstrainedMax::cmnc", "ConstrainedMin::cmnc"}],
    Cell[40929, 1340, 419, 11, 21, "Message",
      CellTags->{"ConstrainedMax::cmnc", "ConstrainedMin::cmnc"}],
    Cell[41351, 1353, 306, 8, 40, "Notes",
      CellTags->{"ConstrainedMax::cmnc", "ConstrainedMin::cmnc"}]},
  "ConstrainedMin::cmnc"->{
    Cell[40778, 1334, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ConstrainedMax::cmnc", "ConstrainedMin::cmnc"}],
    Cell[40929, 1340, 419, 11, 21, "Message",
      CellTags->{"ConstrainedMax::cmnc", "ConstrainedMin::cmnc"}],
    Cell[41351, 1353, 306, 8, 40, "Notes",
      CellTags->{"ConstrainedMax::cmnc", "ConstrainedMin::cmnc"}]},
  "LinearProgramming::lptol"->{
    Cell[41694, 1366, 274, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
        "ConstrainedMin::lptol", "ConstrainedMax::lptol"}],
    Cell[41971, 1376, 517, 14, 37, "Message",
      CellTags->{
      "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
        "ConstrainedMin::lptol", "ConstrainedMax::lptol"}],
    Cell[42491, 1392, 344, 9, 40, "Notes",
      CellTags->{
      "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
        "ConstrainedMin::lptol", "ConstrainedMax::lptol"}]},
  "DualLinearProgramming::lptol"->{
    Cell[41694, 1366, 274, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
        "ConstrainedMin::lptol", "ConstrainedMax::lptol"}],
    Cell[41971, 1376, 517, 14, 37, "Message",
      CellTags->{
      "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
        "ConstrainedMin::lptol", "ConstrainedMax::lptol"}],
    Cell[42491, 1392, 344, 9, 40, "Notes",
      CellTags->{
      "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
        "ConstrainedMin::lptol", "ConstrainedMax::lptol"}]},
  "ConstrainedMin::lptol"->{
    Cell[41694, 1366, 274, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
        "ConstrainedMin::lptol", "ConstrainedMax::lptol"}],
    Cell[41971, 1376, 517, 14, 37, "Message",
      CellTags->{
      "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
        "ConstrainedMin::lptol", "ConstrainedMax::lptol"}],
    Cell[42491, 1392, 344, 9, 40, "Notes",
      CellTags->{
      "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
        "ConstrainedMin::lptol", "ConstrainedMax::lptol"}]},
  "ConstrainedMax::lptol"->{
    Cell[41694, 1366, 274, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
        "ConstrainedMin::lptol", "ConstrainedMax::lptol"}],
    Cell[41971, 1376, 517, 14, 37, "Message",
      CellTags->{
      "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
        "ConstrainedMin::lptol", "ConstrainedMax::lptol"}],
    Cell[42491, 1392, 344, 9, 40, "Notes",
      CellTags->{
      "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
        "ConstrainedMin::lptol", "ConstrainedMax::lptol"}]},
  "LinearProgramming::cmz"->{
    Cell[42872, 1406, 258, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
        "ConstrainedMin::cmz", "ConstrainedMax::cmz"}],
    Cell[43133, 1416, 646, 16, 53, "Message",
      CellTags->{
      "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
        "ConstrainedMin::cmz", "ConstrainedMax::cmz"}],
    Cell[43782, 1434, 295, 8, 24, "Notes",
      CellTags->{
      "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
        "ConstrainedMin::cmz", "ConstrainedMax::cmz"}]},
  "DualLinearProgramming::cmz"->{
    Cell[42872, 1406, 258, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
        "ConstrainedMin::cmz", "ConstrainedMax::cmz"}],
    Cell[43133, 1416, 646, 16, 53, "Message",
      CellTags->{
      "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
        "ConstrainedMin::cmz", "ConstrainedMax::cmz"}],
    Cell[43782, 1434, 295, 8, 24, "Notes",
      CellTags->{
      "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
        "ConstrainedMin::cmz", "ConstrainedMax::cmz"}]},
  "ConstrainedMin::cmz"->{
    Cell[42872, 1406, 258, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
        "ConstrainedMin::cmz", "ConstrainedMax::cmz"}],
    Cell[43133, 1416, 646, 16, 53, "Message",
      CellTags->{
      "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
        "ConstrainedMin::cmz", "ConstrainedMax::cmz"}],
    Cell[43782, 1434, 295, 8, 24, "Notes",
      CellTags->{
      "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
        "ConstrainedMin::cmz", "ConstrainedMax::cmz"}]},
  "ConstrainedMax::cmz"->{
    Cell[42872, 1406, 258, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
        "ConstrainedMin::cmz", "ConstrainedMax::cmz"}],
    Cell[43133, 1416, 646, 16, 53, "Message",
      CellTags->{
      "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
        "ConstrainedMin::cmz", "ConstrainedMax::cmz"}],
    Cell[43782, 1434, 295, 8, 24, "Notes",
      CellTags->{
      "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
        "ConstrainedMin::cmz", "ConstrainedMax::cmz"}]},
  "LinearProgramming::cvr"->{
    Cell[44114, 1447, 258, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
        "ConstrainedMin::cvr", "ConstrainedMax::cvr"}],
    Cell[44375, 1457, 530, 15, 21, "Message",
      CellTags->{
      "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
        "ConstrainedMin::cvr", "ConstrainedMax::cvr"}],
    Cell[44908, 1474, 347, 8, 40, "Notes",
      CellTags->{
      "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
        "ConstrainedMin::cvr", "ConstrainedMax::cvr"}]},
  "DualLinearProgramming::cvr"->{
    Cell[44114, 1447, 258, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
        "ConstrainedMin::cvr", "ConstrainedMax::cvr"}],
    Cell[44375, 1457, 530, 15, 21, "Message",
      CellTags->{
      "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
        "ConstrainedMin::cvr", "ConstrainedMax::cvr"}],
    Cell[44908, 1474, 347, 8, 40, "Notes",
      CellTags->{
      "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
        "ConstrainedMin::cvr", "ConstrainedMax::cvr"}]},
  "ConstrainedMin::cvr"->{
    Cell[44114, 1447, 258, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
        "ConstrainedMin::cvr", "ConstrainedMax::cvr"}],
    Cell[44375, 1457, 530, 15, 21, "Message",
      CellTags->{
      "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
        "ConstrainedMin::cvr", "ConstrainedMax::cvr"}],
    Cell[44908, 1474, 347, 8, 40, "Notes",
      CellTags->{
      "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
        "ConstrainedMin::cvr", "ConstrainedMax::cvr"}]},
  "ConstrainedMax::cvr"->{
    Cell[44114, 1447, 258, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
        "ConstrainedMin::cvr", "ConstrainedMax::cvr"}],
    Cell[44375, 1457, 530, 15, 21, "Message",
      CellTags->{
      "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
        "ConstrainedMin::cvr", "ConstrainedMax::cvr"}],
    Cell[44908, 1474, 347, 8, 40, "Notes",
      CellTags->{
      "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
        "ConstrainedMin::cvr", "ConstrainedMax::cvr"}]},
  "DualLinearProgramming::lpdinf"->{
    Cell[45292, 1487, 176, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "DualLinearProgramming::lpdinf", "LinearProgramming::lpdinf"}],
    Cell[45471, 1493, 558, 12, 69, "Message",
      CellTags->{
      "DualLinearProgramming::lpdinf", "LinearProgramming::lpdinf"}],
    Cell[46032, 1507, 171, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpdinf", "LinearProgramming::lpdinf"}]},
  "LinearProgramming::lpdinf"->{
    Cell[45292, 1487, 176, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "DualLinearProgramming::lpdinf", "LinearProgramming::lpdinf"}],
    Cell[45471, 1493, 558, 12, 69, "Message",
      CellTags->{
      "DualLinearProgramming::lpdinf", "LinearProgramming::lpdinf"}],
    Cell[46032, 1507, 171, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpdinf", "LinearProgramming::lpdinf"}]},
  "DualLinearProgramming::lpdinfp"->{
    Cell[46240, 1516, 180, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "DualLinearProgramming::lpdinfp", "LinearProgramming::lpdinfp"}],
    Cell[46423, 1522, 571, 12, 69, "Message",
      CellTags->{
      "DualLinearProgramming::lpdinfp", "LinearProgramming::lpdinfp"}],
    Cell[46997, 1536, 173, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpdinfp", "LinearProgramming::lpdinfp"}]},
  "LinearProgramming::lpdinfp"->{
    Cell[46240, 1516, 180, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "DualLinearProgramming::lpdinfp", "LinearProgramming::lpdinfp"}],
    Cell[46423, 1522, 571, 12, 69, "Message",
      CellTags->{
      "DualLinearProgramming::lpdinfp", "LinearProgramming::lpdinfp"}],
    Cell[46997, 1536, 173, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpdinfp", "LinearProgramming::lpdinfp"}]},
  "DualLinearProgramming::lpipcv"->{
    Cell[47207, 1545, 176, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "DualLinearProgramming::lpipcv", "LinearProgramming::lpipcv"}],
    Cell[47386, 1551, 629, 12, 101, "Message",
      CellTags->{
      "DualLinearProgramming::lpipcv", "LinearProgramming::lpipcv"}],
    Cell[48018, 1565, 171, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpipcv", "LinearProgramming::lpipcv"}]},
  "LinearProgramming::lpipcv"->{
    Cell[47207, 1545, 176, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "DualLinearProgramming::lpipcv", "LinearProgramming::lpipcv"}],
    Cell[47386, 1551, 629, 12, 101, "Message",
      CellTags->{
      "DualLinearProgramming::lpipcv", "LinearProgramming::lpipcv"}],
    Cell[48018, 1565, 171, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpipcv", "LinearProgramming::lpipcv"}]},
  "DualLinearProgramming::lpipncv"->{
    Cell[48226, 1574, 180, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "DualLinearProgramming::lpipncv", "LinearProgramming::lpipncv"}],
    Cell[48409, 1580, 630, 13, 85, "Message",
      CellTags->{
      "DualLinearProgramming::lpipncv", "LinearProgramming::lpipncv"}],
    Cell[49042, 1595, 173, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpipncv", "LinearProgramming::lpipncv"}]},
  "LinearProgramming::lpipncv"->{
    Cell[48226, 1574, 180, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "DualLinearProgramming::lpipncv", "LinearProgramming::lpipncv"}],
    Cell[48409, 1580, 630, 13, 85, "Message",
      CellTags->{
      "DualLinearProgramming::lpipncv", "LinearProgramming::lpipncv"}],
    Cell[49042, 1595, 173, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpipncv", "LinearProgramming::lpipncv"}]},
  "DualLinearProgramming::lpipp"->{
    Cell[49252, 1604, 172, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DualLinearProgramming::lpipp", "LinearProgramming::lpipp"}],
    
    Cell[49427, 1610, 535, 11, 69, "Message",
      CellTags->{"DualLinearProgramming::lpipp", "LinearProgramming::lpipp"}],
    
    Cell[49965, 1623, 169, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpipp", "LinearProgramming::lpipp"}]},
  "LinearProgramming::lpipp"->{
    Cell[49252, 1604, 172, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DualLinearProgramming::lpipp", "LinearProgramming::lpipp"}],
    
    Cell[49427, 1610, 535, 11, 69, "Message",
      CellTags->{"DualLinearProgramming::lpipp", "LinearProgramming::lpipp"}],
    
    Cell[49965, 1623, 169, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpipp", "LinearProgramming::lpipp"}]},
  "DualLinearProgramming::lpitd"->{
    Cell[50171, 1632, 172, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DualLinearProgramming::lpitd", "LinearProgramming::lpitd"}],
    
    Cell[50346, 1638, 393, 10, 37, "Message",
      CellTags->{"DualLinearProgramming::lpitd", "LinearProgramming::lpitd"}],
    
    Cell[50742, 1650, 169, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpitd", "LinearProgramming::lpitd"}]},
  "LinearProgramming::lpitd"->{
    Cell[50171, 1632, 172, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DualLinearProgramming::lpitd", "LinearProgramming::lpitd"}],
    
    Cell[50346, 1638, 393, 10, 37, "Message",
      CellTags->{"DualLinearProgramming::lpitd", "LinearProgramming::lpitd"}],
    
    Cell[50742, 1650, 169, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpitd", "LinearProgramming::lpitd"}]},
  "DualLinearProgramming::lplop"->{
    Cell[50948, 1659, 172, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DualLinearProgramming::lplop", "LinearProgramming::lplop"}],
    
    Cell[51123, 1665, 560, 12, 69, "Message",
      CellTags->{"DualLinearProgramming::lplop", "LinearProgramming::lplop"}],
    
    Cell[51686, 1679, 169, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lplop", "LinearProgramming::lplop"}]},
  "LinearProgramming::lplop"->{
    Cell[50948, 1659, 172, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"DualLinearProgramming::lplop", "LinearProgramming::lplop"}],
    
    Cell[51123, 1665, 560, 12, 69, "Message",
      CellTags->{"DualLinearProgramming::lplop", "LinearProgramming::lplop"}],
    
    Cell[51686, 1679, 169, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lplop", "LinearProgramming::lplop"}]},
  "DualLinearProgramming::lpsnfp"->{
    Cell[51892, 1688, 176, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "DualLinearProgramming::lpsnfp", "LinearProgramming::lpsnfp"}],
    Cell[52071, 1694, 474, 11, 53, "Message",
      CellTags->{
      "DualLinearProgramming::lpsnfp", "LinearProgramming::lpsnfp"}],
    Cell[52548, 1707, 171, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpsnfp", "LinearProgramming::lpsnfp"}]},
  "LinearProgramming::lpsnfp"->{
    Cell[51892, 1688, 176, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "DualLinearProgramming::lpsnfp", "LinearProgramming::lpsnfp"}],
    Cell[52071, 1694, 474, 11, 53, "Message",
      CellTags->{
      "DualLinearProgramming::lpsnfp", "LinearProgramming::lpsnfp"}],
    Cell[52548, 1707, 171, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lpsnfp", "LinearProgramming::lpsnfp"}]},
  "DualLinearProgramming::lptols"->{
    Cell[52756, 1716, 176, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "DualLinearProgramming::lptols", "LinearProgramming::lptols"}],
    Cell[52935, 1722, 484, 10, 69, "Message",
      CellTags->{
      "DualLinearProgramming::lptols", "LinearProgramming::lptols"}],
    Cell[53422, 1734, 171, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lptols", "LinearProgramming::lptols"}]},
  "LinearProgramming::lptols"->{
    Cell[52756, 1716, 176, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "DualLinearProgramming::lptols", "LinearProgramming::lptols"}],
    Cell[52935, 1722, 484, 10, 69, "Message",
      CellTags->{
      "DualLinearProgramming::lptols", "LinearProgramming::lptols"}],
    Cell[53422, 1734, 171, 4, 24, "Notes",
      CellTags->{
      "DualLinearProgramming::lptols", "LinearProgramming::lptols"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"ConstrainedMax::cmnov", 54293, 1759},
  {"ConstrainedMin::cmnov", 54672, 1766},
  {"LinearProgramming::lpbd", 55053, 1773},
  {"DualLinearProgramming::lpbd", 55462, 1780},
  {"LinearProgramming::lpdim", 55868, 1787},
  {"DualLinearProgramming::lpdim", 57315, 1821},
  {"LinearProgramming::lpnn", 58757, 1855},
  {"ConstrainedMax::lpnn", 59355, 1868},
  {"ConstrainedMin::lpnn", 59953, 1881},
  {"DualLinearProgramming::lpnn", 60558, 1894},
  {"LinearProgramming::cmr", 61158, 1907},
  {"DualLinearProgramming::cmr", 61750, 1920},
  {"ConstrainedMin::cmr", 62335, 1933},
  {"ConstrainedMax::cmr", 62920, 1946},
  {"LinearProgramming::lprank2", 63512, 1959},
  {"DualLinearProgramming::lprank2", 65026, 1993},
  {"LinearProgramming::lprank1", 66536, 2027},
  {"DualLinearProgramming::lprank1", 66993, 2037},
  {"LinearProgramming::lprank12", 67447, 2047},
  {"DualLinearProgramming::lprank12", 67911, 2057},
  {"LinearProgramming::lprank012", 68372, 2067},
  {"DualLinearProgramming::lprank012", 68843, 2077},
  {"LinearProgramming::lpsg", 69305, 2087},
  {"DualLinearProgramming::lpsg", 69720, 2094},
  {"LinearProgramming::lpmethod", 70135, 2101},
  {"DualLinearProgramming::lpmethod", 70599, 2111},
  {"Optimization`LinearProgramming`Simplex::lpsiter", 71079, 2121},
  {"LinearProgramming::lpsiter", 71712, 2134},
  {"DualLinearProgramming::lpsiter", 72349, 2147},
  {"Optimization`LinearProgramming`Simplex::lpsiter1", 73004, 2160},
  {"LinearProgramming::lpsiter1", 73648, 2173},
  {"DualLinearProgramming::lpsiter1", 74296, 2186},
  {"LinearProgramming::lpsbnn", 74938, 2199},
  {"DualLinearProgramming::lpsbnn", 75565, 2212},
  {"Optimization`LinearProgramming`Simplex::lpsbnn", 76209, 2225},
  {"Optimization`LinearProgramming`Simplex::lpsom", 76852, 2238},
  {"LinearProgramming::lpsom", 77466, 2251},
  {"DualLinearProgramming::lpsom", 78084, 2264},
  {"Optimization`LinearProgramming`Simplex::lpsnf", 78719, 2277},
  {"ConstrainedMax::lpsnf", 81480, 2333},
  {"ConstrainedMin::lpsnf", 84241, 2389},
  {"LinearProgramming::lpsnf", 87005, 2445},
  {"DualLinearProgramming::lpsnf", 89773, 2501},
  {"Optimization`LinearProgramming`Simplex::lpspm", 92558, 2557},
  {"LinearProgramming::lpspm", 93172, 2570},
  {"DualLinearProgramming::lpspm", 93790, 2583},
  {"Optimization`LinearProgramming`Simplex::lpstl", 94425, 2596},
  {"ConstrainedMax::lpstl", 95215, 2612},
  {"ConstrainedMin::lpstl", 96005, 2628},
  {"LinearProgramming::lpstl", 96798, 2644},
  {"DualLinearProgramming::lpstl", 97595, 2660},
  {"Optimization`LinearProgramming`Simplex::lpstl2", 98410, 2676},
  {"ConstrainedMax::lpstl2", 99216, 2692},
  {"ConstrainedMin::lpstl2", 100022, 2708},
  {"LinearProgramming::lpstl2", 100831, 2724},
  {"DualLinearProgramming::lpstl2", 101644, 2740},
  {"Optimization`LinearProgramming`Simplex::lpssm", 102473, 2756},
  {"LinearProgramming::lpssm", 103087, 2769},
  {"DualLinearProgramming::lpssm", 103705, 2782},
  {"Optimization`LinearProgramming`Simplex::lpsub", 104340, 2795},
  {"ConstrainedMax::lpsub", 105130, 2811},
  {"ConstrainedMin::lpsub", 105920, 2827},
  {"LinearProgramming::lpsub", 106713, 2843},
  {"DualLinearProgramming::lpsub", 107510, 2859},
  {"Optimization`LinearProgramming`Simplex::lpsdm2", 108325, 2875},
  {"Optimization`LinearProgramming`Simplex::lpsdm3", 108729, 2882},
  {"Optimization`LinearProgramming`Simplex::lpsdm4", 109133, 2889},
  {"Optimization`LinearProgramming`Simplex::lpsdm5", 109537, 2896},
  {"Optimization`LinearProgramming`Simplex::lpsdm6", 109941, 2903},
  {"Optimization`LinearProgramming`Simplex::lpsdm7", 110345, 2910},
  {"ConstrainedMax::cmcons", 110728, 2917},
  {"ConstrainedMin::cmcons", 113771, 2970},
  {"ConstrainedMax::cmfun", 116813, 3023},
  {"ConstrainedMin::cmfun", 117887, 3042},
  {"ConstrainedMax::cmnc", 118960, 3061},
  {"ConstrainedMin::cmnc", 119342, 3068},
  {"LinearProgramming::lptol", 119728, 3075},
  {"DualLinearProgramming::lptol", 120352, 3088},
  {"ConstrainedMin::lptol", 120969, 3101},
  {"ConstrainedMax::lptol", 121586, 3114},
  {"LinearProgramming::cmz", 122204, 3127},
  {"DualLinearProgramming::cmz", 122802, 3140},
  {"ConstrainedMin::cmz", 123393, 3153},
  {"ConstrainedMax::cmz", 123984, 3166},
  {"LinearProgramming::cvr", 124578, 3179},
  {"DualLinearProgramming::cvr", 125176, 3192},
  {"ConstrainedMin::cvr", 125767, 3205},
  {"ConstrainedMax::cvr", 126358, 3218},
  {"DualLinearProgramming::lpdinf", 126959, 3231},
  {"LinearProgramming::lpdinf", 127409, 3241},
  {"DualLinearProgramming::lpdinfp", 127864, 3251},
  {"LinearProgramming::lpdinfp", 128321, 3261},
  {"DualLinearProgramming::lpipcv", 128781, 3271},
  {"LinearProgramming::lpipcv", 129232, 3281},
  {"DualLinearProgramming::lpipncv", 129688, 3291},
  {"LinearProgramming::lpipncv", 130145, 3301},
  {"DualLinearProgramming::lpipp", 130604, 3311},
  {"LinearProgramming::lpipp", 131043, 3321},
  {"DualLinearProgramming::lpitd", 131486, 3331},
  {"LinearProgramming::lpitd", 131925, 3341},
  {"DualLinearProgramming::lplop", 132368, 3351},
  {"LinearProgramming::lplop", 132807, 3361},
  {"DualLinearProgramming::lpsnfp", 133251, 3371},
  {"LinearProgramming::lpsnfp", 133701, 3381},
  {"DualLinearProgramming::lptols", 134155, 3391},
  {"LinearProgramming::lptols", 134605, 3401}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 35, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1836, 57, 152, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"ConstrainedMax::cmnov", "ConstrainedMin::cmnov"}],
Cell[1991, 63, 257, 7, 21, "Message",
  CellTags->{"ConstrainedMax::cmnov", "ConstrainedMin::cmnov"}],
Cell[2251, 72, 159, 4, 24, "Notes",
  CellTags->{"ConstrainedMax::cmnov", "ConstrainedMin::cmnov"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[2447, 81, 168, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"LinearProgramming::lpbd", "DualLinearProgramming::lpbd"}],
Cell[2618, 87, 394, 9, 37, "Message",
  CellTags->{"LinearProgramming::lpbd", "DualLinearProgramming::lpbd"}],
Cell[3015, 98, 167, 4, 24, "Notes",
  CellTags->{"LinearProgramming::lpbd", "DualLinearProgramming::lpbd"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[3219, 107, 172, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
Cell[3394, 113, 369, 9, 37, "Message",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
Cell[3766, 124, 169, 4, 24, "Notes",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],

Cell[CellGroupData[{
Cell[3960, 132, 108, 1, 38, "ExampleSection",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
Cell[4071, 135, 176, 4, 24, "Text",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],

Cell[CellGroupData[{
Cell[4272, 143, 178, 3, 26, "Input",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
Cell[4453, 148, 272, 5, 37, "Message",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
Cell[4728, 155, 179, 3, 21, "Output",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}]
}, Open  ]],
Cell[4922, 161, 182, 5, 24, "Text",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],

Cell[CellGroupData[{
Cell[5129, 170, 182, 3, 26, "Input",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}],
Cell[5314, 175, 138, 3, 21, "Output",
  CellTags->{"LinearProgramming::lpdim", "DualLinearProgramming::lpdim"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5513, 185, 266, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lpnn", "ConstrainedMax::lpnn", "ConstrainedMin::lpnn", 
    "DualLinearProgramming::lpnn"}],
Cell[5782, 195, 523, 12, 69, "Message",
  CellTags->{
  "LinearProgramming::lpnn", "ConstrainedMax::lpnn", "ConstrainedMin::lpnn", 
    "DualLinearProgramming::lpnn"}],
Cell[6308, 209, 223, 6, 24, "Notes",
  CellTags->{
  "LinearProgramming::lpnn", "ConstrainedMax::lpnn", "ConstrainedMin::lpnn", 
    "DualLinearProgramming::lpnn"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[6568, 220, 258, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
    "ConstrainedMin::cmr", "ConstrainedMax::cmr"}],
Cell[6829, 230, 532, 15, 21, "Message",
  CellTags->{
  "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
    "ConstrainedMin::cmr", "ConstrainedMax::cmr"}],
Cell[7364, 247, 325, 7, 40, "Notes",
  CellTags->{
  "LinearProgramming::cmr", "DualLinearProgramming::cmr", 
    "ConstrainedMin::cmr", "ConstrainedMax::cmr"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[7726, 259, 180, 4, 51, "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
Cell[7909, 265, 396, 11, 21, "Message",
  CellTags->{
  "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
Cell[8308, 278, 232, 5, 24, "Notes",
  CellTags->{
  "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],

Cell[CellGroupData[{
Cell[8565, 287, 112, 1, 38, "ExampleSection",
  CellTags->{
  "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
Cell[8680, 290, 180, 4, 24, "Text",
  CellTags->{
  "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],

Cell[CellGroupData[{
Cell[8885, 298, 200, 4, 26, "Input",
  CellTags->{
  "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
Cell[9088, 304, 259, 5, 21, "Message",
  CellTags->{
  "DualLinearProgramming::lprank2", "LinearProgramming::lprank2"}],
Cell[9350, 311, 201, 4, 21, "Output",
  CellTags->{"DualLinearProgramming::lprank2", "LinearProgramming::lprank2"}]
}, Open  ]],
Cell[9566, 318, 182, 5, 24, "Text",
  CellTags->{
  "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],

Cell[CellGroupData[{
Cell[9773, 327, 212, 4, 26, "Input",
  CellTags->{
  "LinearProgramming::lprank2", "DualLinearProgramming::lprank2"}],
Cell[9988, 333, 142, 3, 21, "Output",
  CellTags->{"DualLinearProgramming::lprank2", "LinearProgramming::lprank2"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10191, 343, 180, 4, 51, "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lprank1", "DualLinearProgramming::lprank1"}],
Cell[10374, 349, 276, 7, 21, "Message",
  CellTags->{
  "LinearProgramming::lprank1", "DualLinearProgramming::lprank1"}],
Cell[10653, 358, 173, 4, 24, "Notes",
  CellTags->{"LinearProgramming::lprank1", "DualLinearProgramming::lprank1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[10863, 367, 187, 5, 51, "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lprank12", "DualLinearProgramming::lprank12"}],
Cell[11053, 374, 311, 8, 21, "Message",
  CellTags->{
  "LinearProgramming::lprank12", "DualLinearProgramming::lprank12"}],
Cell[11367, 384, 178, 5, 24, "Notes",
  CellTags->{
  "LinearProgramming::lprank12", "DualLinearProgramming::lprank12"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11582, 394, 191, 5, 51, "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lprank012", "DualLinearProgramming::lprank012"}],
Cell[11776, 401, 340, 9, 37, "Message",
  CellTags->{
  "LinearProgramming::lprank012", "DualLinearProgramming::lprank012"}],
Cell[12119, 412, 180, 5, 24, "Notes",
  CellTags->{
  "LinearProgramming::lprank012", "DualLinearProgramming::lprank012"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12336, 422, 168, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"LinearProgramming::lpsg", "DualLinearProgramming::lpsg"}],
Cell[12507, 428, 442, 9, 37, "Message",
  CellTags->{"LinearProgramming::lpsg", "DualLinearProgramming::lpsg"}],
Cell[12952, 439, 167, 4, 24, "Notes",
  CellTags->{"LinearProgramming::lpsg", "DualLinearProgramming::lpsg"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13156, 448, 187, 5, 51, "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lpmethod", "DualLinearProgramming::lpmethod"}],
Cell[13346, 455, 315, 8, 21, "Message",
  CellTags->{
  "LinearProgramming::lpmethod", "DualLinearProgramming::lpmethod"}],
Cell[13664, 465, 178, 5, 24, "Notes",
  CellTags->{
  "LinearProgramming::lpmethod", "DualLinearProgramming::lpmethod"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13879, 475, 287, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsiter", 
    "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}],
Cell[14169, 484, 376, 9, 21, "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsiter", 
    "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}],
Cell[14548, 495, 232, 6, 24, "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsiter", 
    "LinearProgramming::lpsiter", "DualLinearProgramming::lpsiter"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[14817, 506, 293, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsiter1", 
    "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}],
Cell[15113, 515, 486, 11, 53, "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsiter1", 
    "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}],
Cell[15602, 528, 235, 6, 24, "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsiter1", 
    "LinearProgramming::lpsiter1", "DualLinearProgramming::lpsiter1"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[15874, 539, 283, 8, 71, "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
    "Optimization`LinearProgramming`Simplex::lpsbnn"}],
Cell[16160, 549, 366, 9, 21, "Message",
  CellTags->{
  "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
    "Optimization`LinearProgramming`Simplex::lpsbnn"}],
Cell[16529, 560, 229, 6, 24, "Notes",
  CellTags->{
  "LinearProgramming::lpsbnn", "DualLinearProgramming::lpsbnn", 
    "Optimization`LinearProgramming`Simplex::lpsbnn"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16795, 571, 275, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsom", "LinearProgramming::lpsom",
     "DualLinearProgramming::lpsom"}],
Cell[17073, 580, 563, 14, 69, "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsom", "LinearProgramming::lpsom",
     "DualLinearProgramming::lpsom"}],
Cell[17639, 596, 226, 6, 24, "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsom", "LinearProgramming::lpsom",
     "DualLinearProgramming::lpsom"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[17902, 607, 374, 10, 111, "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],
Cell[18279, 619, 422, 10, 21, "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],
Cell[18704, 631, 297, 7, 24, "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],

Cell[CellGroupData[{
Cell[19026, 642, 220, 4, 38, "ExampleSection",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],
Cell[19249, 648, 289, 7, 24, "Text",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],

Cell[CellGroupData[{
Cell[19563, 659, 315, 7, 26, "Input",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],
Cell[19881, 668, 360, 8, 37, "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],
Cell[20244, 678, 316, 7, 21, "Output",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}]
}, Open  ]],
Cell[20575, 688, 294, 8, 24, "Text",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],

Cell[CellGroupData[{
Cell[20894, 700, 320, 7, 26, "Input",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}],
Cell[21217, 709, 250, 6, 21, "Output",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsnf", "ConstrainedMax::lpsnf", 
    "ConstrainedMin::lpsnf", "LinearProgramming::lpsnf", 
    "DualLinearProgramming::lpsnf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21528, 722, 275, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpspm", "LinearProgramming::lpspm",
     "DualLinearProgramming::lpspm"}],
Cell[21806, 731, 463, 12, 21, "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpspm", "LinearProgramming::lpspm",
     "DualLinearProgramming::lpspm"}],
Cell[22272, 745, 226, 6, 24, "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpspm", "LinearProgramming::lpspm",
     "DualLinearProgramming::lpspm"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22535, 756, 374, 10, 111, "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpstl", "ConstrainedMax::lpstl", 
    "ConstrainedMin::lpstl", "LinearProgramming::lpstl", 
    "DualLinearProgramming::lpstl"}],
Cell[22912, 768, 566, 14, 21, "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpstl", "ConstrainedMax::lpstl", 
    "ConstrainedMin::lpstl", "LinearProgramming::lpstl", 
    "DualLinearProgramming::lpstl"}],
Cell[23481, 784, 281, 7, 24, "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpstl", "ConstrainedMax::lpstl", 
    "ConstrainedMin::lpstl", "LinearProgramming::lpstl", 
    "DualLinearProgramming::lpstl"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[23799, 796, 384, 10, 111, "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpstl2", "ConstrainedMax::lpstl2", 
    "ConstrainedMin::lpstl2", "LinearProgramming::lpstl2", 
    "DualLinearProgramming::lpstl2"}],
Cell[24186, 808, 649, 16, 37, "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpstl2", "ConstrainedMax::lpstl2", 
    "ConstrainedMin::lpstl2", "LinearProgramming::lpstl2", 
    "DualLinearProgramming::lpstl2"}],
Cell[24838, 826, 286, 7, 24, "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpstl2", "ConstrainedMax::lpstl2", 
    "ConstrainedMin::lpstl2", "LinearProgramming::lpstl2", 
    "DualLinearProgramming::lpstl2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[25161, 838, 275, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpssm", "LinearProgramming::lpssm",
     "DualLinearProgramming::lpssm"}],
Cell[25439, 847, 463, 12, 21, "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpssm", "LinearProgramming::lpssm",
     "DualLinearProgramming::lpssm"}],
Cell[25905, 861, 226, 6, 24, "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpssm", "LinearProgramming::lpssm",
     "DualLinearProgramming::lpssm"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[26168, 872, 374, 10, 111, "ObjectNameWarningMessages",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsub", "ConstrainedMax::lpsub", 
    "ConstrainedMin::lpsub", "LinearProgramming::lpsub", 
    "DualLinearProgramming::lpsub"}],
Cell[26545, 884, 386, 10, 21, "Message",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsub", "ConstrainedMax::lpsub", 
    "ConstrainedMin::lpsub", "LinearProgramming::lpsub", 
    "DualLinearProgramming::lpsub"}],
Cell[26934, 896, 281, 7, 24, "Notes",
  CellTags->{
  "Optimization`LinearProgramming`Simplex::lpsub", "ConstrainedMax::lpsub", 
    "ConstrainedMin::lpsub", "LinearProgramming::lpsub", 
    "DualLinearProgramming::lpsub"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[27252, 908, 147, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm2"],
Cell[27402, 912, 276, 4, 37, "Message",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm2"],
Cell[27681, 918, 157, 4, 24, "Notes",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27875, 927, 147, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm3"],
Cell[28025, 931, 276, 4, 37, "Message",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm3"],
Cell[28304, 937, 157, 4, 24, "Notes",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28498, 946, 147, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm4"],
Cell[28648, 950, 289, 4, 37, "Message",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm4"],
Cell[28940, 956, 157, 4, 24, "Notes",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29134, 965, 147, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm5"],
Cell[29284, 969, 261, 4, 37, "Message",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm5"],
Cell[29548, 975, 157, 4, 24, "Notes",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29742, 984, 147, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm6"],
Cell[29892, 988, 261, 4, 37, "Message",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm6"],
Cell[30156, 994, 157, 4, 24, "Notes",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm6"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30350, 1003, 147, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm7"],
Cell[30500, 1007, 277, 4, 37, "Message",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm7"],
Cell[30780, 1013, 157, 4, 24, "Notes",
  CellTags->"Optimization`LinearProgramming`Simplex::lpsdm7"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30974, 1022, 156, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[31133, 1028, 466, 12, 21, "Message",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[31602, 1042, 1091, 36, 116, "Notes",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[CellGroupData[{
Cell[32718, 1082, 100, 1, 38, "ExampleSection",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[32821, 1085, 208, 4, 40, "Text",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[CellGroupData[{
Cell[33054, 1093, 176, 3, 26, "Input",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[33233, 1098, 341, 6, 53, "Message",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[33577, 1106, 261, 5, 37, "Message",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[33841, 1113, 169, 3, 21, "Output",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}]
}, Open  ]],
Cell[34025, 1119, 167, 5, 24, "Text",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[CellGroupData[{
Cell[34217, 1128, 175, 3, 26, "Input",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[34395, 1133, 341, 6, 53, "Message",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[34739, 1141, 155, 3, 21, "Output",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}]
}, Open  ]],
Cell[34909, 1147, 382, 10, 40, "Text",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[CellGroupData[{
Cell[35316, 1161, 220, 5, 42, "Input",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[35539, 1168, 341, 6, 53, "Message",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[35883, 1176, 270, 5, 37, "Message",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[36156, 1183, 192, 4, 21, "Output",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[36385, 1192, 131, 3, 26, "Input",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[36519, 1197, 93, 1, 21, "Print",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[36615, 1200, 458, 13, 21, "Print",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}]
}, Open  ]],
Cell[37088, 1216, 189, 4, 24, "Text",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[37280, 1222, 133, 3, 26, "Input",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],

Cell[CellGroupData[{
Cell[37438, 1229, 221, 5, 42, "Input",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[37662, 1236, 341, 6, 53, "Message",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}],
Cell[38006, 1244, 165, 3, 21, "Output",
  CellTags->{"ConstrainedMax::cmcons", "ConstrainedMin::cmcons"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[38232, 1254, 152, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
Cell[38387, 1260, 512, 14, 21, "Message",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
Cell[38902, 1276, 563, 13, 78, "Notes",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],

Cell[CellGroupData[{
Cell[39490, 1293, 98, 1, 38, "ExampleSection",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
Cell[39591, 1296, 190, 4, 24, "Text",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],

Cell[CellGroupData[{
Cell[39806, 1304, 154, 3, 26, "Input",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
Cell[39963, 1309, 339, 6, 53, "Message",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
Cell[40305, 1317, 253, 5, 39, "Message",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}],
Cell[40561, 1324, 156, 3, 23, "Output",
  CellTags->{"ConstrainedMax::cmfun", "ConstrainedMin::cmfun"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40778, 1334, 148, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"ConstrainedMax::cmnc", "ConstrainedMin::cmnc"}],
Cell[40929, 1340, 419, 11, 21, "Message",
  CellTags->{"ConstrainedMax::cmnc", "ConstrainedMin::cmnc"}],
Cell[41351, 1353, 306, 8, 40, "Notes",
  CellTags->{"ConstrainedMax::cmnc", "ConstrainedMin::cmnc"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[41694, 1366, 274, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
    "ConstrainedMin::lptol", "ConstrainedMax::lptol"}],
Cell[41971, 1376, 517, 14, 37, "Message",
  CellTags->{
  "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
    "ConstrainedMin::lptol", "ConstrainedMax::lptol"}],
Cell[42491, 1392, 344, 9, 40, "Notes",
  CellTags->{
  "LinearProgramming::lptol", "DualLinearProgramming::lptol", 
    "ConstrainedMin::lptol", "ConstrainedMax::lptol"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[42872, 1406, 258, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
    "ConstrainedMin::cmz", "ConstrainedMax::cmz"}],
Cell[43133, 1416, 646, 16, 53, "Message",
  CellTags->{
  "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
    "ConstrainedMin::cmz", "ConstrainedMax::cmz"}],
Cell[43782, 1434, 295, 8, 24, "Notes",
  CellTags->{
  "LinearProgramming::cmz", "DualLinearProgramming::cmz", 
    "ConstrainedMin::cmz", "ConstrainedMax::cmz"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[44114, 1447, 258, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
    "ConstrainedMin::cvr", "ConstrainedMax::cvr"}],
Cell[44375, 1457, 530, 15, 21, "Message",
  CellTags->{
  "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
    "ConstrainedMin::cvr", "ConstrainedMax::cvr"}],
Cell[44908, 1474, 347, 8, 40, "Notes",
  CellTags->{
  "LinearProgramming::cvr", "DualLinearProgramming::cvr", 
    "ConstrainedMin::cvr", "ConstrainedMax::cvr"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[45292, 1487, 176, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lpdinf", "LinearProgramming::lpdinf"}],
Cell[45471, 1493, 558, 12, 69, "Message",
  CellTags->{"DualLinearProgramming::lpdinf", "LinearProgramming::lpdinf"}],
Cell[46032, 1507, 171, 4, 24, "Notes",
  CellTags->{"DualLinearProgramming::lpdinf", "LinearProgramming::lpdinf"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[46240, 1516, 180, 4, 51, "ObjectNameWarningMessages",
  CellTags->{
  "DualLinearProgramming::lpdinfp", "LinearProgramming::lpdinfp"}],
Cell[46423, 1522, 571, 12, 69, "Message",
  CellTags->{
  "DualLinearProgramming::lpdinfp", "LinearProgramming::lpdinfp"}],
Cell[46997, 1536, 173, 4, 24, "Notes",
  CellTags->{"DualLinearProgramming::lpdinfp", "LinearProgramming::lpdinfp"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[47207, 1545, 176, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lpipcv", "LinearProgramming::lpipcv"}],
Cell[47386, 1551, 629, 12, 101, "Message",
  CellTags->{"DualLinearProgramming::lpipcv", "LinearProgramming::lpipcv"}],
Cell[48018, 1565, 171, 4, 24, "Notes",
  CellTags->{"DualLinearProgramming::lpipcv", "LinearProgramming::lpipcv"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[48226, 1574, 180, 4, 51, "ObjectNameWarningMessages",
  CellTags->{
  "DualLinearProgramming::lpipncv", "LinearProgramming::lpipncv"}],
Cell[48409, 1580, 630, 13, 85, "Message",
  CellTags->{
  "DualLinearProgramming::lpipncv", "LinearProgramming::lpipncv"}],
Cell[49042, 1595, 173, 4, 24, "Notes",
  CellTags->{"DualLinearProgramming::lpipncv", "LinearProgramming::lpipncv"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[49252, 1604, 172, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lpipp", "LinearProgramming::lpipp"}],
Cell[49427, 1610, 535, 11, 69, "Message",
  CellTags->{"DualLinearProgramming::lpipp", "LinearProgramming::lpipp"}],
Cell[49965, 1623, 169, 4, 24, "Notes",
  CellTags->{"DualLinearProgramming::lpipp", "LinearProgramming::lpipp"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[50171, 1632, 172, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lpitd", "LinearProgramming::lpitd"}],
Cell[50346, 1638, 393, 10, 37, "Message",
  CellTags->{"DualLinearProgramming::lpitd", "LinearProgramming::lpitd"}],
Cell[50742, 1650, 169, 4, 24, "Notes",
  CellTags->{"DualLinearProgramming::lpitd", "LinearProgramming::lpitd"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[50948, 1659, 172, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lplop", "LinearProgramming::lplop"}],
Cell[51123, 1665, 560, 12, 69, "Message",
  CellTags->{"DualLinearProgramming::lplop", "LinearProgramming::lplop"}],
Cell[51686, 1679, 169, 4, 24, "Notes",
  CellTags->{"DualLinearProgramming::lplop", "LinearProgramming::lplop"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[51892, 1688, 176, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lpsnfp", "LinearProgramming::lpsnfp"}],
Cell[52071, 1694, 474, 11, 53, "Message",
  CellTags->{"DualLinearProgramming::lpsnfp", "LinearProgramming::lpsnfp"}],
Cell[52548, 1707, 171, 4, 24, "Notes",
  CellTags->{"DualLinearProgramming::lpsnfp", "LinearProgramming::lpsnfp"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[52756, 1716, 176, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"DualLinearProgramming::lptols", "LinearProgramming::lptols"}],
Cell[52935, 1722, 484, 10, 69, "Message",
  CellTags->{"DualLinearProgramming::lptols", "LinearProgramming::lptols"}],
Cell[53422, 1734, 171, 4, 24, "Notes",
  CellTags->{"DualLinearProgramming::lptols", "LinearProgramming::lptols"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

