(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    234442,       8648]*)
(*NotebookOutlinePosition[    446343,      13550]*)
(*  CellTagsIndexPosition[    433625,      13245]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Lists and Matrices", "Title"],

Cell[CellGroupData[{

Cell["Rest::norest", "ObjectNameWarningMessages",
  CellTags->"Rest::norest"],

Cell[BoxData[
    RowBox[{"Rest", "::", 
      RowBox[{"\<\"norest\"\>", ":", " ", 
        RowBox[{\(\(Cannot\)\(\ \)\(take\)\(\ \)\(Rest\)\(\ \)\(of\)\(\ \)\), 
          "expression", " ", 
          StyleBox["expr",
            
            "TI"], \(\(\ \)\(with\ length\ \(\(zero\)\(.\)\)\)\)}]}]}]], \
"Message",
  CellTags->"Rest::norest"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["Rest", "MR"],
  " is a normal expression with no elements."
}], "Notes",
  CellTags->"Rest::norest"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Rest::norest"],

Cell[TextData[{
  StyleBox["Rest", "MR"],
  " will generate an error unless the argument has at least one element."
}], "Text",
  CellTags->"Rest::norest"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Rest[{}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Rest::norest"],

Cell[BoxData[
    \(Rest::"norest" \(\(:\)\(\ \)\) 
      "Cannot take Rest of expression \!\({}\) with length zero."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Rest::norest"],

Cell[BoxData[
    \(Rest[{}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Rest::norest"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Cross::nonn1", "ObjectNameWarningMessages",
  CellTags->"Cross::nonn1"],

Cell[BoxData[
    \(Cross::"nonn1" \(\(:\)\(\ \)\) 
      "The arguments are expected to be vectors of equal length, and the \
number of arguments is expected to be 1 less than their length."\)], "Message",\

  CellTags->"Cross::nonn1"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the arguments in ",
  StyleBox["Cross", "MR"],
  " do not form a valid cross product.\n\[FilledSmallSquare] If ",
  StyleBox["Cross", "MR"],
  " is used with ",
  StyleBox["n",
    FontSlant->"Italic"],
  " arguments, all of the arguments should be vectors of length ",
  StyleBox["n",
    FontSlant->"Italic"],
  "+1.\n\[FilledSmallSquare] An expression is a vector if the expression is a \
list and none of the elements of that list are lists."
}], "Notes",
  CellTags->"Cross::nonn1"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Cross::nonn1"],

Cell["\<\
An error occurs in this example because only one vector is given.\
\
\>", "Text",
  CellTags->"Cross::nonn1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cross[{1, 2, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Cross::nonn1"],

Cell[BoxData[
    \(Cross::"nonn1" \(\(:\)\(\ \)\) 
      "The arguments are expected to be vectors of equal length, and the \
number of arguments is expected to be 1 less than their length."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"Cross::nonn1"],

Cell[BoxData[
    \(Cross[{1, 2, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Cross::nonn1"]
}, Open  ]],

Cell["This shows a valid cross product.", "Text",
  CellTags->"Cross::nonn1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cross[{1, 2, 3}, {4, 5, 6}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Cross::nonn1"],

Cell[BoxData[
    \({\(-3\), 6, \(-3\)}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Cross::nonn1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::mronly", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::mronly"],

Cell[BoxData[
    \(LinearSolve::"mronly" \(\(:\)\(\ \)\) \(Only\ machine\ real\ code\ is\ \
available\ for\ sparse\ matrices . \ If\ your\ matrix\ is\ not\ too\ large, \ 
      consider\ trying\ again\ after\ using\ Normal\ on\ the\ \(\(matrix\)\(.\
\)\)\)\)], "Message",
  CellTags->"LinearSolve::mronly"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::mronly"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::mconly", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::mconly"],

Cell[BoxData[
    \(LinearSolve::"mconly" \(\(:\)\(\ \)\) \(Only\ machine\ number\ code\ is\
\ available\ for\ sparse\ matrices . \ 
          If\ your\ matrix\ is\ not\ too\ large, \ 
      consider\ trying\ again\ after\ using\ Normal\ on\ the\ \(\(matrix\)\(.\
\)\)\)\)], "Message",
  CellTags->"LinearSolve::mconly"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::mconly"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::mcovl", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::mcovl"],

Cell[BoxData[
    \(LinearSolve::"mcovl" \(\(:\)\(\ \)\) \(The\ computation\ encountered\ \
machine\ number\ overflow . \ \ Only\ machine\ number\ code\ is\ available\ \
for\ sparse\ matrices . \ If\ your\ matrix\ is\ not\ too\ large, \ 
      consider\ trying\ again\ after\ using\ Normal\ on\ the\ \(\(matrix\)\(.\
\)\)\)\)], "Message",
  CellTags->"LinearSolve::mcovl"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::mcovl"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::nolib", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::nolib"],

Cell[BoxData[
    \(LinearSolve::"nolib" \(\(:\)\(\ \)\) \(The\ library\ for\ the\ sparse\ \
method\ chosen\ is\ not\ available\ on\ this\ platform . \ \ Try\ choosing\ \
another\ \(\(method\)\(.\)\)\)\)], "Message",
  CellTags->"LinearSolve::nolib"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::nolib"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::lupat", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::lupat"],

Cell[BoxData[
    \(LinearSolve::"lupat" \(\(:\)\(\ \)\) \(Cannot\ compute\ solutions\ for\ \
Pattern\ type\ sparse\ \(\(matrices\)\(.\)\)\)\)], "Message",
  CellTags->"LinearSolve::lupat"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::lupat"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::sqmat", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::sqmat"],

Cell[BoxData[
    RowBox[{\(LinearSolve::"sqmat"\), \(\(:\)\(\ \)\), "The", " ", "matrix", 
      " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", \(square . \ \ A\), " ", "square", 
      " ", "matrix", " ", "is", " ", "needed", " ", "to", " ", "compute", " ",
       "a", " ", \(\(factorization\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::sqmat"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::sqmat"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::npdef", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::npdef"],

Cell[BoxData[
    RowBox[{\(LinearSolve::"npdef"\), \(\(:\)\(\ \)\), "The", " ", "matrix", 
      " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "positive", 
      " ", \(\(definite\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::npdef"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::npdef"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::herm", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::herm"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(LinearSolve::"herm"\), \(\(:\)\(\ \)\), "The", " ", "matrix", 
        " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "Hermitian", " ", "or", " ", 
        "real", " ", "symmetric"}], ",", 
      " ", \(which\ is\ necessary\ for\ Method -> \(\(Cholesky\)\(.\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::herm"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::herm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::tmm", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::tmm"],

Cell[BoxData[
    \(LinearSolve::"tmm" \(\(:\)\(\ \)\) \(Pre - 
        factorization\ analysis\ indicates\ that\ the\ solution\ will\ \
require\ too\ much\ \(\(memory\)\(.\)\)\)\)], "Message",
  CellTags->"LinearSolve::tmm"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::tmm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Experimental`ExtendedLinearSolve::lsvs
Experimental`LinearSolveFunction::lsvs
Developer`SparseLinearSolve::lsvs\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Experimental`ExtendedLinearSolve::lsvs", 
    "Experimental`LinearSolveFunction::lsvs", 
    "Developer`SparseLinearSolve::lsvs"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lsvs\"\>"}], \(\(:\)\(\ \)\), \(Argument\ `1`\ is\ neither\
\ a\ non - empty\ vector\ of\ machine - 
        sized\ numbers\ nor\ a\ list\ of\ same - 
        length\ vectors\ of\ machine - 
        sized\ \(\(numbers\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Experimental`ExtendedLinearSolve::lsvs", 
    "Experimental`LinearSolveFunction::lsvs", 
    "Developer`SparseLinearSolve::lsvs"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Experimental`ExtendedLinearSolve::lsvs", 
    "Experimental`LinearSolveFunction::lsvs", 
    "Developer`SparseLinearSolve::lsvs"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
CholeskyDecomposition::herm
Optimization`ModifiedCholeskyDecomposition::herm\
\>", \
"ObjectNameWarningMessages",
  CellTags->{
  "CholeskyDecomposition::herm", 
    "Optimization`ModifiedCholeskyDecomposition::herm"}],

Cell[BoxData[
    \(CholeskyDecomposition::"herm" \(\(:\)\(\ \)\) \(The\ matrix\ `1`\ is\ \
not\ Hermitian\ or\ real\ and\ \(\(symmetric\)\(.\)\)\)\)], "Message",
  CellTags->{
  "CholeskyDecomposition::herm", 
    "Optimization`ModifiedCholeskyDecomposition::herm"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "CholeskyDecomposition::herm", 
    "Optimization`ModifiedCholeskyDecomposition::herm"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
CholeskyDecomposition::posdef
Optimization`ModifiedCholeskyDecomposition::posdef\
\>", \
"ObjectNameWarningMessages",
  CellTags->{
  "CholeskyDecomposition::posdef", 
    "Optimization`ModifiedCholeskyDecomposition::posdef"}],

Cell[BoxData[
    \(CholeskyDecomposition::"posdef" \(\(:\)\(\ \)\) \(The\ matrix\ `1`\ is\ \
not\ sufficiently\ positive\ definite\ to\ complete\ the\ Cholesky\ \
decomposition\ to\ reasonable\ \(\(accuracy\)\(.\)\)\)\)], "Message",
  CellTags->{
  "CholeskyDecomposition::posdef", 
    "Optimization`ModifiedCholeskyDecomposition::posdef"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "CholeskyDecomposition::posdef", 
    "Optimization`ModifiedCholeskyDecomposition::posdef"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
SingularValues::neqcols
SingularValueList::neqcols
SingularValueDecomposition::neqcols\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "SingularValues::neqcols", "SingularValueList::neqcols", 
    "SingularValueDecomposition::neqcols"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"neqcols\"\>"}], \(\(:\)\(\ \)\), \(The\ matrices\ ' 
        1'\ and\ ' 
        2'\ must\ have\ the\ same\ number\ of\ \(\(columns\)\(.\)\)\)}]], \
"Message",
  CellTags->{
  "SingularValues::neqcols", "SingularValueList::neqcols", 
    "SingularValueDecomposition::neqcols"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "SingularValues::neqcols", "SingularValueList::neqcols", 
    "SingularValueDecomposition::neqcols"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
SingularValueDecomposition::svdf
SingularValueList::svdf
SingularValues::svdf\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"svdf\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["f",
          "TI"], " ", "has", " ", "received", " ", "a", " ", "matrix", " ", 
        "with", " ", "infinite", " ", \(\(precision\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["SingularValueDecomposition", "MR"],
  " or ",
  StyleBox["SingularValueList", "MR"],
  " is a matrix in which all of the elements are integers, rational numbers, \
or exact complex numbers. "
}], "Notes",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],

Cell["\<\
An error occurs in this example because all of the matrix elements \
are integers.\
\>", "Text",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SingularValueDecomposition[{{1, 2}, {4, 2}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],

Cell[BoxData[
    \(SingularValueDecomposition::"svdf" \(\(:\)\(\ \)\) 
      "\!\(SingularValueDecomposition\) has received a matrix with infinite \
precision."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],

Cell[BoxData[
    \(SingularValueDecomposition[{{1, 2}, {4, 2}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}]
}, Open  ]],

Cell["\<\
This computation can be done by converting the matrix elements into \
inexact numbers.\
\>", "Text",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SingularValueDecomposition[N[{{1, 2}, {4, 2}}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],

Cell[BoxData[
    \({{{\(-0.3975291631557806`\), 
          0.9175895402851239`}, {\(-0.9175895402851239`\), \
\(-0.3975291631557806`\)}}, {{4.844156902881103`, 0.`}, {0.`, 
          1.238605627417115`}}, {{\(-0.8397513552620196`\), \
\(-0.5429711422678014`\)}, {\(-0.5429711422678014`\), 
          0.8397513552620198`}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
SingularValueDecomposition::svdn
SingularValueList::svdn
SingularValues::svdn\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"svdn\"\>"}], ":", " ", 
      RowBox[{
        RowBox[{
          StyleBox["f",
            "TI"], " ", "has", " ", "received", " ", "a", " ", "matrix", " ", 
          "with", " ", "non"}], 
        "-", \(numerical\ \(\(elements\)\(.\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["SingularValueDecomposition", "MR"],
  " or ",
  StyleBox["SingularValueList", "MR"],
  " is a matrix in which not all of the elements are numbers."
}], "Notes",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],

Cell["\<\
An error occurs in this example because one of the matrix elements \
is a symbol.\
\>", "Text",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SingularValueDecomposition[{{1.3, 2.5}, {3.7, x}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],

Cell[BoxData[
    \(SingularValueDecomposition::"svdn" \(\(:\)\(\ \)\) 
      "\!\(SingularValueDecomposition\) has received a matrix with \
non-numerical elements."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],

Cell[BoxData[
    \(SingularValueDecomposition[{{1.3`, 2.5`}, {3.7`, x}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["SingularValueDecomposition", "MR"],
  "."
}], "Text",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{x = 1}, 
      SingularValueDecomposition[{{1.3, 2.5}, {3.7, x}}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],

Cell[BoxData[
    \({{{\(-0.5388987308629867`\), 
          0.8423705585276959`}, {\(-0.8423705585276959`\), \
\(-0.5388987308629867`\)}}, {{4.4007390876749835`, 0.`}, {0.`, 
          1.8065147334604146`}}, {{\(-0.8674314338165298`\), \
\(-0.4975567380982792`\)}, {\(-0.49755673809827927`\), 
          0.8674314338165297`}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Developer`LinearExpressionToMatrix::nonlin
Developer`LinearExpressionToSparseMatrix::nonlin\
\>", \
"ObjectNameWarningMessages",
  CellTags->{
  "Developer`LinearExpressionToMatrix::nonlin", 
    "Developer`LinearExpressionToSparseMatrix::nonlin"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nonlin\"\>"}], \(\(:\)\(\ \)\), \(The\ expression\ `1`\ is\
\ not\ linear\ in\ the\ variables\ \(\(`2`\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Developer`LinearExpressionToMatrix::nonlin", 
    "Developer`LinearExpressionToSparseMatrix::nonlin"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Developer`LinearExpressionToMatrix::nonlin", 
    "Developer`LinearExpressionToSparseMatrix::nonlin"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Developer`LinearExpressionToMatrix::lexp
Developer`LinearExpressionToSparseMatrix::lexp\
\>", \
"ObjectNameWarningMessages",
  CellTags->{
  "Developer`LinearExpressionToMatrix::lexp", 
    "Developer`LinearExpressionToSparseMatrix::lexp"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lexp\"\>"}], \(\(:\)\(\ \)\), \(The\ first\ argument\ `1`\ \
is\ not\ a\ list\ of\ expressions\ or\ a\ list\ of\ \
\(\(equations\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Developer`LinearExpressionToMatrix::lexp", 
    "Developer`LinearExpressionToSparseMatrix::lexp"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Developer`LinearExpressionToMatrix::lexp", 
    "Developer`LinearExpressionToSparseMatrix::lexp"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["LUBackSubstitution::singlu", "ObjectNameWarningMessages",
  CellTags->"LUBackSubstitution::singlu"],

Cell[BoxData[
    \(LUBackSubstitution::"singlu" \(\(:\)\(\ \)\) \(The\ LU\ decomposition\ \
matrix\ `1`\ is\ \(\(singular\)\(.\)\)\)\)], "Message",
  CellTags->"LUBackSubstitution::singlu"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LUBackSubstitution::singlu"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray::dims", "ObjectNameWarningMessages",
  CellTags->"SparseArray::dims"],

Cell[BoxData[
    \(SparseArray::"dims" \(\(:\)\(\ \)\) \(The\ dimensions\ `1`\ in\ `2`\ \
are\ not\ a\ list\ of\ positive\ \(\(integers\)\(.\)\)\)\)], "Message",
  CellTags->"SparseArray::dims"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"SparseArray::dims"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray::rect", "ObjectNameWarningMessages",
  CellTags->"SparseArray::rect"],

Cell[BoxData[
    \(SparseArray::"rect" \(\(:\)\(\ \)\) \(Rectangular\ array\ or\ list\ of\ \
rules\ expected\ at\ position\ 1\ \(\(in`1`\)\(.\)\)\)\)], "Message",
  CellTags->"SparseArray::rect"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"SparseArray::rect"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray::exdims", "ObjectNameWarningMessages",
  CellTags->"SparseArray::exdims"],

Cell[BoxData[
    \(SparseArray::"exdims" \(\(:\)\(\ \)\) \(The\ dimensions\ cannot\ be\ \
determined\ from\ the\ positions\ \(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"SparseArray::exdims"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"SparseArray::exdims"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray::pind", "ObjectNameWarningMessages",
  CellTags->"SparseArray::pind"],

Cell[BoxData[
    \(SparseArray::"pind" \(\(:\)\(\ \)\) \(The\ indices\ in\ `1`\ are\ not\ \
all\ \(\(positive\)\(.\)\)\)\)], "Message",
  CellTags->"SparseArray::pind"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"SparseArray::pind"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray::ilist", "ObjectNameWarningMessages",
  CellTags->"SparseArray::ilist"],

Cell[BoxData[
    \(SparseArray::"ilist" \(\(:\)\(\ \)\) \(The\ implicit\ value\ `1`\ in\ \
`2`\ cannot\ be\ a\ \(\(list\)\(.\)\)\)\)], "Message",
  CellTags->"SparseArray::ilist"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"SparseArray::ilist"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray::rule", "ObjectNameWarningMessages",
  CellTags->"SparseArray::rule"],

Cell[BoxData[
    \(SparseArray::"rule" \(\(:\)\(\ \)\) \(`1`\ in\ `2`\ is\ not\ a\ \
replacement\ \(\(rule\)\(.\)\)\)\)], "Message",
  CellTags->"SparseArray::rule"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"SparseArray::rule"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray::rule1", "ObjectNameWarningMessages",
  CellTags->"SparseArray::rule1"],

Cell[BoxData[
    \(SparseArray::"rule1" \(\(:\)\(\ \)\) \(The\ rule\ `1`\ is\ not\ of\ the\
\ form\ indices -> \(\(values\)\(.\)\)\)\)], "Message",
  CellTags->"SparseArray::rule1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"SparseArray::rule1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray::ntb", "ObjectNameWarningMessages",
  CellTags->"SparseArray::ntb"],

Cell[BoxData[
    \(SparseArray::"ntb" \(\(:\)\(\ \)\) \(Cannot\ convert\ the\ sparse\ \
array\ `1`\ to\ an\ ordinary\ array\ because\ the\ `2`\ elements\ required\ \
exceeds\ the\ current\ size\ \(\(limit\)\(.\)\)\)\)], "Message",
  CellTags->"SparseArray::ntb"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"SparseArray::ntb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray::pos", "ObjectNameWarningMessages",
  CellTags->"SparseArray::pos"],

Cell[BoxData[
    \(SparseArray::"pos" \(\(:\)\(\ \)\) \(The\ left\ hand\ side\ of\ `1`\ in\
\ `2`\ is\ not\ a\ position\ or\ pattern\ which\ will\ match\ a\ \(\(position\
\)\(.\)\)\)\)], "Message",
  CellTags->"SparseArray::pos"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"SparseArray::pos"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray::valnl", "ObjectNameWarningMessages",
  CellTags->"SparseArray::valnl"],

Cell[BoxData[
    \(SparseArray::"valnl" \(\(:\)\(\ \)\) \(The\ value\ specified\ by\ the\ \
rule\ `1`\ should\ not\ be\ a\ \(\(List\)\(.\)\)\)\)], "Message",
  CellTags->"SparseArray::valnl"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"SparseArray::valnl"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
SparseArray`SymmetricQ::spmat
SparseArray`HermitianQ::spmat\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "SparseArray`SymmetricQ::spmat", "SparseArray`HermitianQ::spmat"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"spmat\"\>"}], \(\(:\)\(\ \)\), \(`1`\ is\ not\ a\ sparse\ \
\(\(matrix\)\(.\)\)\)}]], "Message",
  CellTags->{
  "SparseArray`SymmetricQ::spmat", "SparseArray`HermitianQ::spmat"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "SparseArray`SymmetricQ::spmat", "SparseArray`HermitianQ::spmat"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sparv", "ObjectNameWarningMessages",
  CellTags->"General::sparv"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sparv\"\>"}], \(\(:\)\(\ \)\), \(Valid\ SparseArray\ \
expected\ at\ position\ `2`\ in\ \(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->"General::sparv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::sparv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::spts", "ObjectNameWarningMessages",
  CellTags->"General::spts"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"spts\"\>"}], \(\(:\)\(\ \)\), \(Scalar, \ 
      rectangular\ tensor, \ 
      or\ valid\ SparseArray\ expected\ at\ position\ `2`\ in\ \(\(`1`\)\(.\)\
\)\)}]], "Message",
  CellTags->"General::spts"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::spts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`SparseLinearSolve::spam", "ObjectNameWarningMessages",
  CellTags->"Developer`SparseLinearSolve::spam"],

Cell[BoxData[
    \(Developer`SparseLinearSolve::"spam" \(\(:\)\(\ \)\) \(The\ sparse\ \
matrix\ `1`\ is\ not\ specified\ in\ the\ form\ {{i1, j1} -> a1, {i2, j2} -> 
              a2,  ... }\ with\ machine - 
        sized\ integer\ position\ indices\ ik\ and\ jk\ and\ machine - 
        sized\ real\ or\ complex\ values\ \(\(ak\)\(.\)\)\)\)], "Message",
  CellTags->"Developer`SparseLinearSolve::spam"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Developer`SparseLinearSolve::spam"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Developer`SparseLinearSolve::deprec", "ObjectNameWarningMessages",
  CellTags->"Developer`SparseLinearSolve::deprec"],

Cell[BoxData[
    \(Developer`SparseLinearSolve::"deprec" \(\(:\)\(\ \)\) 
      "Developer`SparseLinearSolve is deprecated.  Use LinearSolve with \
SparseArray matrices instead."\)], "Message",
  CellLabel->"From In[5]:=",
  CellTags->"Developer`SparseLinearSolve::deprec"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Developer`SparseLinearSolve::deprec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Developer`SparseLinearSolve::fovflw
Experimental`ExtendedLinearSolve::fovflw
Experimental`LinearSolveFunction::fovflw\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Developer`SparseLinearSolve::fovflw", 
    "Experimental`ExtendedLinearSolve::fovflw", 
    "Experimental`LinearSolveFunction::fovflw"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"fovflw\"\>"}], \(\(:\)\(\ \)\), \(Machine\ overflow\ \
encountered\ factoring\ the\ sparse\ \(\(matrix\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Developer`SparseLinearSolve::fovflw", 
    "Experimental`ExtendedLinearSolve::fovflw", 
    "Experimental`LinearSolveFunction::fovflw"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Developer`SparseLinearSolve::fovflw", 
    "Experimental`ExtendedLinearSolve::fovflw", 
    "Experimental`LinearSolveFunction::fovflw"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Developer`SparseLinearSolve::sovflw
Experimental`ExtendedLinearSolve::sovflw
Experimental`LinearSolveFunction::sovflw\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Developer`SparseLinearSolve::sovflw", 
    "Experimental`ExtendedLinearSolve::sovflw", 
    "Experimental`LinearSolveFunction::sovflw"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sovflw\"\>"}], \(\(:\)\(\ \)\), \(Machine\ overflow\ \
encountered\ solving\ the\ sparse\ \(\(system\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Developer`SparseLinearSolve::sovflw", 
    "Experimental`ExtendedLinearSolve::sovflw", 
    "Experimental`LinearSolveFunction::sovflw"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Developer`SparseLinearSolve::sovflw", 
    "Experimental`ExtendedLinearSolve::sovflw", 
    "Experimental`LinearSolveFunction::sovflw"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::mindet", "ObjectNameWarningMessages",
  CellTags->"General::mindet"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"mindet\"\>"}], \(\(:\)\(\ \)\), \(Input\ matrix\ contains\ \
an\ indeterminate\ \(\(entry\)\(.\)\)\)}]], "Message",
  CellTags->"General::mindet"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an element in a matrix used in a \
linear algebra function is ",
  StyleBox["Indeterminate", "MR"],
  ".\n\[FilledSmallSquare] This message can be generated by ",
  StyleBox["Eigenvalues", "MR"],
  ", ",
  StyleBox["Eigenvectors", "MR"],
  ", ",
  StyleBox["Eigensystem", "MR"],
  ", ",
  StyleBox["LUDecomposition", "MR"],
  ", ",
  StyleBox["MatrixExp", "MR"],
  ", and most other matrix functions."
}], "Notes",
  CellTags->"General::mindet"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blnoval", "ObjectNameWarningMessages",
  CellTags->"General::blnoval"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blnoval\"\>"}], \(\(:\)\(\ \)\), \(The\ symbol\ `1`\ at\ \
position\ `2`\ should\ have\ an\ immediate\ value\ \(\(defined\)\(.\)\)\)}]], \
"Message",
  CellTags->"General::blnoval"],

Cell["\<\
\[FilledSmallSquare] This message can be generated by an incorrect \
use of certain internal numerical linear algebra functions.\
\>", "Notes",
  CellTags->"General::blnoval"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::blnoval"],

Cell["\<\
A message is generated in this example because the arguments to \
this internal function are incorrect.\
\>", "Text",
  CellTags->"General::blnoval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearAlgebra`BLAS`ROTG[N, {}, {}, {}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::blnoval"],

Cell[BoxData[
    \(LinearAlgebra`BLAS`ROTG::"blnoval" \(\(:\)\(\ \)\) 
      "The symbol \!\(N\) at position \!\(1\) should have an immediate value \
defined."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::blnoval"],

Cell[BoxData[
    \(LinearAlgebra`BLAS`ROTG[N, {}, {}, {}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::blnoval"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
HermiteNormalForm::latm
LatticeReduce::latm\
\>", "ObjectNameWarningMessages",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"latm\"\>"}], \(\(:\)\(\ \)\), \(Matrix\ contains\ entry\ \
that\ is\ not\ \(\(rational\)\(.\)\)\)}]], "Message",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["HermiteNormalForm", "MR"],
  " or ",
  StyleBox["LatticeReduce", "MR"],
  " is a matrix with at least one element that is neither an exact integer \
nor an exact rational number."
}], "Notes",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],

Cell["\<\
The element 4.5 is a real number rather than an exact integer or a \
rational number.\
\>", "Text",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LatticeReduce[{{1, \ 2}, \ {3, \ 4.5}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],

Cell[BoxData[
    \(LatticeReduce::"latm" \(\(:\)\(\ \)\) 
      "Matrix contains entry that is not rational."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],

Cell[BoxData[
    \(LatticeReduce[{{1, 2}, {3, 4.5`}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}]
}, Open  ]],

Cell[TextData[{
  "The inexact number can be converted to an exact rational number using ",
  StyleBox["Rationalize", "MR"],
  "."
}], "Text",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LatticeReduce[Rationalize[{{1, 2}, {3, 4.5}}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],

Cell[BoxData[
    \({{1, 1\/2}, {\(-1\), 1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::cfail", "ObjectNameWarningMessages",
  CellTags->"General::cfail"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"cfail\"\>"}], \(\(:\)\(\ \)\), "\<\"Algorithm failed to \
converge.\"\>"}]], "Message",
  CellTags->"General::cfail"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated if the iterative singular value \
decomposition algorithm for inexact numbers does not converge.  This \
algorithm is used by ",
  StyleBox["NullSpace", "MR"],
  ", ",
  StyleBox["PseudoInverse", "MR"],
  ", and ",
  StyleBox["SingularValues", "MR"],
  ".\n\[FilledSmallSquare] If you see this message, and there is no obvious \
reason for lack of convergence, please send your example to Technical Support \
so that it can be investigated."
}], "Notes",
  CellTags->"General::cfail"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LUDecomposition::sq", "ObjectNameWarningMessages",
  CellTags->"LUDecomposition::sq"],

Cell[BoxData[
    \(LUDecomposition::"sq" \(\(:\)\(\ \)\) \(LUDecomposition\ accepts\ only\ \
square\ \(\(matrices\)\(.\)\)\)\)], "Message",
  CellTags->"LUDecomposition::sq"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"LUDecomposition::sq"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::tol", "ObjectNameWarningMessages",
  CellTags->"General::tol"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"tol\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
Tolerance\)}], " ", "->", " ", 
      RowBox[{
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "a", " ", "non"}], 
        "-", \(negative\ real\ number\ or\ \(\(Automatic\)\(.\)\)\)}]}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::tol"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated value of the ",
  StyleBox["Tolerance", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->"General::tol"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::tol"],

Cell[TextData[{
  "The value of the ",
  StyleBox["Tolerance", "MR"],
  " option cannot be ",
  StyleBox["None", "MR"],
  "."
}], "Text",
  CellTags->"General::tol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NullSpace[{{1.2, 3.4, 5.6}, {1.2, 3.4, 5.7}, {1.2, 3.4, 5.8}}, 
      Tolerance -> None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::tol"],

Cell[BoxData[
    \(NullSpace::"tol" \(\(:\)\(\ \)\) 
      "Value of option Tolerance -> \!\(None\) is not a non-negative real \
number or Automatic."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::tol"],

Cell[BoxData[
    \(NullSpace[{{1.2`, 3.4`, 5.6`}, {1.2`, 3.4`, 5.7`}, {1.2`, 3.4`, 5.8`}}, 
      Tolerance \[Rule] None]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::tol"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Tolerance", "MR"],
  " option."
}], "Text",
  CellTags->"General::tol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NullSpace[{{1.2, 3.4, 5.6}, {1.2, 3.4, 5.7}, {1.2, 3.4, 5.8}}, 
      Tolerance -> 0.1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::tol"],

Cell[BoxData[
    \({{\(-0.28128375010797524`\), \(-0.7969706253058589`\), 
        0.5345252794066738`}, {\(-0.9429903335828826`\), 
        0.3328201177351564`, \(-1.2517901271830543`*^-14\)}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::tol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Dot::rect
Tr::rect\
\>", "ObjectNameWarningMessages",
  CellTags->{"Dot::rect", "Tr::rect"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"rect\"\>"}], \(\(:\)\(\ \)\), \(Non - 
        rectangular\ tensor\ \(\(encountered\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Dot::rect", "Tr::rect"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an argument in ",
  StyleBox["Dot", "MR"],
  " or the first argument in ",
  StyleBox["Tr", "MR"],
  " includes sublists of different lengths at the same level."
}], "Notes",
  CellTags->{"Dot::rect", "Tr::rect"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Dot::rect", "Tr::rect"}],

Cell["\<\
An error occurs in this example because the first expression is not \
a true matrix.\
\>", "Text",
  CellTags->{"Dot::rect", "Tr::rect"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1}, 2} . {3}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Dot::rect", "Tr::rect"}],

Cell[BoxData[
    \(Dot::"rect" \(\(:\)\(\ \)\) 
      "Non-rectangular tensor encountered."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Dot::rect", "Tr::rect"}],

Cell[BoxData[
    \({{1}, 2} . {3}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Dot::rect", "Tr::rect"}]
}, Open  ]],

Cell["This shows a valid dot product of a vector and a matrix.", "Text",
  CellTags->{"Dot::rect", "Tr::rect"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1}, {2}} . {3}\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Dot::rect", "Tr::rect"}],

Cell[BoxData[
    \({3, 6}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Dot::rect", "Tr::rect"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiagonalMatrix::vec", "ObjectNameWarningMessages",
  CellTags->"DiagonalMatrix::vec"],

Cell[BoxData[
    RowBox[{\(DiagonalMatrix::"vec"\), \(\(:\)\(\ \)\), \(\(Input\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(to\ DiagonalMatrix\ is\ not\ a\ list\ of\ \
\(\(scalars\)\(.\)\)\)\)}]], "Message",
  CellTags->"DiagonalMatrix::vec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["DiagonalMatrix", "MR"],
  " is not a list, or if one or more of the elements in the first argument \
are lists."
}], "Notes",
  CellTags->"DiagonalMatrix::vec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"DiagonalMatrix::vec"],

Cell[TextData[{
  "An error occurs in this example because the elements in the first argument \
of ",
  StyleBox["DiagonalMatrix", "MR"],
  " are lists."
}], "Text",
  CellTags->"DiagonalMatrix::vec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DiagonalMatrix[{{2, 0}, {0, 3}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"DiagonalMatrix::vec"],

Cell[BoxData[
    \(DiagonalMatrix::"vec" \(\(:\)\(\ \)\) 
      "Input \!\({\(\({2, 0}\)\), \(\({0, 3}\)\)}\) to DiagonalMatrix is not \
a list of scalars."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"DiagonalMatrix::vec"],

Cell[BoxData[
    \(DiagonalMatrix[{{2, 0}, {0, 3}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"DiagonalMatrix::vec"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["DiagonalMatrix", "MR"],
  "."
}], "Text",
  CellTags->"DiagonalMatrix::vec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DiagonalMatrix[{2, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"DiagonalMatrix::vec"],

Cell[BoxData[
    \({{2, 0}, {0, 3}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"DiagonalMatrix::vec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dot::dotsh", "ObjectNameWarningMessages",
  CellTags->"Dot::dotsh"],

Cell[BoxData[
    RowBox[{\(Dot::"dotsh"\), \(\(:\)\(\ \)\), "Tensors", " ", 
      StyleBox["m1",
        "TI"], " ", "and", " ", 
      StyleBox["m2",
        "TI"], " ", "have", " ", "incompatible", 
      " ", \(\(shapes\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Dot::dotsh"],

Cell["\<\
\[FilledSmallSquare] Generated when a requested dot product cannot \
be computed because the number of elements in the inner dimension of one \
argument is not the same as the number of elements in the outer dimension of \
the subsequent argument.\
\>", "Notes",
  CellTags->"Dot::dotsh"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Dot::dotsh"],

Cell["\<\
An error occurs in this example because the number of elements in \
each row of the matrix is not the same as the number of elements in the \
vector.\
\>", "Text",
  CellTags->"Dot::dotsh"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1}, {2}, {3}} . {10, 20, 30}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Dot::dotsh"],

Cell[BoxData[
    \(Dot::"dotsh" \(\(:\)\(\ \)\) 
      "Tensors \!\({\(\({1}\)\), \(\({2}\)\), \(\({3}\)\)}\) and \!\({10, 20, \
30}\) have incompatible shapes."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Dot::dotsh"],

Cell[BoxData[
    \({{1}, {2}, {3}} . {10, 20, 30}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Dot::dotsh"]
}, Open  ]],

Cell["\<\
This shows a dot product in which the operands have compatible \
dimensions.\
\>", "Text",
  CellTags->"Dot::dotsh"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1}, {2}, {3}} . {{10, 20, 30}}\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Dot::dotsh"],

Cell[BoxData[
    \({{10, 20, 30}, {20, 40, 60}, {30, 60, 90}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Dot::dotsh"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dot::dotpat", "ObjectNameWarningMessages",
  CellTags->"Dot::dotpat"],

Cell[BoxData[
    \(Dot::"dotpat" \(\(:\)\(\ \)\) 
      "Cannot combine array of pattern type with an ordinary array."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Dot::dotpat"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Dot::dotpat"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::eivn", "ObjectNameWarningMessages",
  CellTags->"General::eivn"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"eivn\"\>"}], \(\(:\)\(\ \)\), "Incorrect", " ", 
      "number", " ", 
      StyleBox["n",
        "TI"], " ", "of", " ", "eigenvectors", " ", "for", " ", "eigenvalue", 
      " ", 
      StyleBox["expr",
        "TI"], " ", "with", " ", "multiplicity", " ", 
      RowBox[{
        StyleBox["m",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::eivn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of eigenvectors found for \
the indicated eigenvalue is zero or exceeds the multiplicity of the \
eigenvalue.\n\[FilledSmallSquare] This message is currently used only in ",
  StyleBox["JordanDecomposition", "MR"],
  " for symbolic matrices.\n\[FilledSmallSquare] This message indicates an \
internal failure that should only occur under unusual conditions, such as \
failure to recognize a combination of symbols that simplifies to zero.\n\
\[FilledSmallSquare] If you see this message in an example where it is not \
expected, please contact Technical Support."
}], "Notes",
  CellTags->"General::eivn"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::eivec", "ObjectNameWarningMessages",
  CellTags->"General::eivec"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"eivec\"\>"}], \(\(:\)\(\ \)\), "Unable", " ", 
      "to", " ", "find", " ", "eigenvector", " ", "for", " ", "eigenvalue", 
      " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::eivec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the algorithm used for computing \
eigenvectors fails to find an eigenvector corresponding to the indicated \
eigenvalue.\n\[FilledSmallSquare] This message is currently used only for ",
  StyleBox["Eigenvectors", "MR"],
  " and ",
  StyleBox["Eigensystem", "MR"],
  " with symbolic matrices.\n\[FilledSmallSquare] This message indicates an \
internal failure that should only occur under unusual conditions, such as \
failure to recognize a combination of symbols that simplifies to zero.\n\
\[FilledSmallSquare] If you see this message in an example where it is not \
expected, please contact Technical Support."
}], "Notes",
  CellTags->"General::eivec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::eival", "ObjectNameWarningMessages",
  CellTags->"General::eival"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"eival\"\>"}], \(\(:\)\(\ \)\), \(Unable\ to\ find\ all\ \
roots\ of\ the\ characteristic\ \(\(polynomial\)\(.\)\)\)}]], "Message",
  CellTags->"General::eival"],

Cell["\<\
\[FilledSmallSquare] Generated when the matrix eigenvalue algorithm \
fails to solve for all of the eigenvalues of a matrix.
\[FilledSmallSquare] This message is currently used only for functions that \
compute eigenvalues of symbolic matrices.
\[FilledSmallSquare] This message indicates an internal failure that should \
only occur under unusual conditions, such as failure to recognize a \
combination of symbols that simplifies to zero.
\[FilledSmallSquare] If you see this message in an example where it is not \
expected, please contact Technical Support.\
\>", "Notes",
  CellTags->"General::eival"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::inf", "ObjectNameWarningMessages",
  CellTags->"General::inf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"inf\"\>"}], \(\(:\)\(\ \)\), \(Input\ matrix\ contains\ an\
\ infinite\ \(\(entry\)\(.\)\)\)}]], "Message",
  CellTags->"General::inf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a matrix used in a linear algebra \
function includes an element with a head of ",
  StyleBox["DirectedInfinity", "MR"],
  ".\n\[FilledSmallSquare] This message can be generated by ",
  StyleBox["Eigenvalues", "MR"],
  ", ",
  StyleBox["Eigenvectors", "MR"],
  ", ",
  StyleBox["Eigensystem", "MR"],
  ", ",
  StyleBox["LUDecomposition", "MR"],
  ", ",
  StyleBox["MatrixExp", "MR"],
  ", and most other matrix functions."
}], "Notes",
  CellTags->"General::inf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::pvec", "ObjectNameWarningMessages",
  CellTags->"General::pvec"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"pvec\"\>"}], \(\(:\)\(\ \)\), "Unable", " ", "to",
       " ", "find", " ", "principal", " ", "vectors", " ", "for", " ", 
      "eigenvalue", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::pvec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by a failure in the algorithm for computing \
",
  StyleBox["JordanDecomposition", "MR"],
  " of a symbolic matrix.\n\[FilledSmallSquare] If you see this message in an \
example where it is not expected, please contact Technical Support."
}], "Notes",
  CellTags->"General::pvec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sing", "ObjectNameWarningMessages",
  CellTags->"General::sing"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"sing\"\>"}], \(\(:\)\(\ \)\), "Matrix", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", \(\(singular\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::sing"],

Cell["\<\
\[FilledSmallSquare] Generated when a computation cannot be \
completed because the indicated matrix is singular.\
\>", "Notes",
  CellTags->"General::sing"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sing"],

Cell["\<\
An error occurs in this example because this matrix does not have \
an inverse.\
\>", "Text",
  CellTags->"General::sing"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inverse[{{0, 0}, {0, 0}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sing"],

Cell[BoxData[
    \(Inverse::"sing" \(\(:\)\(\ \)\) 
      "Matrix \!\({\(\({0, 0}\)\), \(\({0, 0}\)\)}\) is singular."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::sing"],

Cell[BoxData[
    \(Inverse[{{0, 0}, {0, 0}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::sing"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inner::incom", "ObjectNameWarningMessages",
  CellTags->"Inner::incom"],

Cell[BoxData[
    RowBox[{\(Inner::"incom"\), \(\(:\)\(\ \)\), "Length", " ", 
      StyleBox["l1",
        "TI"], " ", "of", " ", "dimension", " ", 
      StyleBox["d1",
        "TI"], " ", "in", " ", 
      StyleBox["e1",
        "TI"], " ", "is", " ", "incommensurate", " ", "with", " ", "length", 
      " ", 
      StyleBox["l2",
        "TI"], " ", "of", " ", "dimension", " ", "1", " ", "in", " ", 
      RowBox[{
        StyleBox["e2",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Inner::incom"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the dimensions to be combined by ",
  StyleBox["Inner", "MR"],
  " do not have the same length."
}], "Notes",
  CellTags->"Inner::incom"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Inner::incom"],

Cell["\<\
An error occurs in this example because the length of the inner \
dimension in the second argument is not the same as the length of the outer \
dimension of the third argument.\
\>", "Text",
  CellTags->"Inner::incom"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inner[Plus, {{30}, {40}}, {2, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Inner::incom"],

Cell[BoxData[
    \(Inner::"incom" \(\(:\)\(\ \)\) 
      "Length \!\(1\) of dimension \!\(2\) in \!\({\(\({30}\)\), \
\(\({40}\)\)}\) is incommensurate with length \!\(2\) of dimension 1 in \
\!\({2, 3}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Inner::incom"],

Cell[BoxData[
    \(Inner[Plus, {{30}, {40}}, {2, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Inner::incom"]
}, Open  ]],

Cell[TextData[{
  "This shows valid input in ",
  StyleBox["Inner", "MR"],
  "."
}], "Text",
  CellTags->"Inner::incom"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inner[Plus, {{30, 40}}, {2, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Inner::incom"],

Cell[BoxData[
    \({75}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Inner::incom"]
}, Open  ]],

Cell[TextData[{
  "Dimensions can be usefully rearranged using ",
  StyleBox["Transpose", "MR"],
  "."
}], "Text",
  CellTags->"Inner::incom"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inner[Plus, Transpose[{{30}, {40}}], {2, 3}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Inner::incom"],

Cell[BoxData[
    \({75}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Inner::incom"]
}, Open  ]],

Cell[TextData[{
  "The optional fifth argument in ",
  StyleBox["Inner", "MR"],
  " can be used to specify which dimension of the second argument should be \
used."
}], "Text",
  CellTags->"Inner::incom"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inner[Plus, {{30}, {40}}, {2, 3}, Times, 1]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Inner::incom"],

Cell[BoxData[
    \({1376}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Inner::incom"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inner::inntf", "ObjectNameWarningMessages",
  CellTags->"Inner::inntf"],

Cell[BoxData[
    RowBox[{\(Inner::"inntf"\), \(\(:\)\(\ \)\), \(\(Transpose\)\(\ \
\)\(failed\)\(\ \)\(for\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Inner::inntf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a transpose used internally to \
evaluate ",
  StyleBox["Inner", "MR"],
  " fails.\n\[FilledSmallSquare] This message should not be seen unless ",
  StyleBox["Transpose", "MR"],
  " has been redefined or the system has been otherwise modified.\n\
\[FilledSmallSquare] If you see this message in an example where it is not \
expected, please contact Technical Support."
}], "Notes",
  CellTags->"Inner::inntf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inner::nolev", "ObjectNameWarningMessages",
  CellTags->"Inner::nolev"],

Cell[BoxData[
    RowBox[{\(Inner::"nolev"\), \(\(:\)\(\ \)\), "Level", " ", 
      StyleBox["n",
        "TI"], " ", "is", " ", "not", " ", "available", " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", 
      RowBox[{
        RowBox[{"(", 
          RowBox[{"dimensions", " ", 
            StyleBox["dims",
              "TI"]}], ")"}], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Inner::nolev"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the level specified in the optional \
fifth argument of ",
  StyleBox["Inner", "MR"],
  " is not present in the indicated argument expression."
}], "Notes",
  CellTags->"Inner::nolev"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Inner::nolev"],

Cell["\<\
An error occurs in this example because the dimensions of the \
second argument do not extend to the level specified in the fifth argument.\
\
\>", "Text",
  CellTags->"Inner::nolev"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inner[Plus, {{{1, 2}, 3}}, {10, 20}, List, 3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Inner::nolev"],

Cell[BoxData[
    \(Inner::"nolev" \(\(:\)\(\ \)\) 
      "Level \!\(3\) is not available in \!\({\({\(\({1, 2}\)\), 3}\)}\) \
(dimensions \!\({1, 2}\))."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Inner::nolev"],

Cell[BoxData[
    \(Inner[Plus, {{{1, 2}, 3}}, {10, 20}, List, 3]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Inner::nolev"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Inner", "MR"],
  "."
}], "Text",
  CellTags->"Inner::nolev"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inner[Plus, {{{1, 2}, {3, 4}}}, {10, 20}, List, 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Inner::nolev"],

Cell[BoxData[
    \({{{11, 22}, {13, 24}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Inner::nolev"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LUBackSubstitution::bpvt", "ObjectNameWarningMessages",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[BoxData[
    RowBox[{\(LUBackSubstitution::"bpvt"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \
\)\(pivot\)\(\ \)\(vector\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ \(\(invalid\)\(.\)\)\)\)}]], "Message",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second element in the data \
expression passed to ",
  StyleBox["LUBackSubstitution", "MR"],
  " is not a list of integers in the required range.\n\[FilledSmallSquare] \
This message can occur if a data expression is entered incorrectly.\n\
\[FilledSmallSquare] A valid data expression can be obtained using ",
  StyleBox["LUDecomposition", "MR"],
  "."
}], "Notes",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"LUBackSubstitution::bpvt"],

Cell["\<\
An error occurs in this example because the second element in the \
data expression is not a list of positive integers.\
\>", "Text",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LUBackSubstitution[{{{1, 2}, {2, 1}}, {0, {}}, 1}, {1, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[BoxData[
    \(LUBackSubstitution::"bpvt" \(\(:\)\(\ \)\) 
      "The pivot vector \!\({0, \(\({}\)\)}\) is invalid."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[BoxData[
    \(LUBackSubstitution[{{{1, 2}, {2, 1}}, {0, {}}, 1}, {1, 1}]\)], "Output",\

  CellLabel->"Out[1]=",
  CellTags->"LUBackSubstitution::bpvt"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid data expression in ",
  StyleBox["LUBackSubstitution", "MR"],
  "."
}], "Text",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LUBackSubstitution[{{{1, 2}, {2, 1}}, {1, 2}, 1}, {1, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[BoxData[
    \({3, \(-1\)}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"LUBackSubstitution::bpvt"]
}, Open  ]],

Cell[TextData[{
  "A valid data expression for use in ",
  StyleBox["LUBackSubstitution", "MR"],
  " can be constructed using ",
  StyleBox["LUDecomposition", "MR"],
  "."
}], "Text",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ludec = LUDecomposition[{{1, 2}, {2, 5}}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[BoxData[
    \({{{1, 2}, {2, 1}}, {1, 2}, 1}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"LUBackSubstitution::bpvt"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LUBackSubstitution[ludec, {1, 1}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[BoxData[
    \({3, \(-1\)}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"LUBackSubstitution::bpvt"]
}, Open  ]],

Cell["\<\
This particular example corresponds to solving a pair of linear \
equations.\
\>", "Text",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[{{1, 2}, {2, 5}}, {1, 1}]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[BoxData[
    \({3, \(-1\)}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"LUBackSubstitution::bpvt"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["ludec", "MR"],
  "."
}], "Text",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[BoxData[
    \(Clear[ludec]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"LUBackSubstitution::bpvt"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::lsfail", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::lsfail"],

Cell[BoxData[
    \(LinearSolve::"lsfail" \(\(:\)\(\ \)\) \(LinearSolve\ could\ not\ find\ \
solutions\ to\ the\ linear\ \(\(system\)\(.\)\)\)\)], "Message",
  CellTags->"LinearSolve::lsfail"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"LinearSolve::lsfail"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::lslc", "ObjectNameWarningMessages",
  CellTags->"General::lslc"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lslc\"\>"}], \(\(:\)\(\ \)\), \(Coefficient\ matrix\ and\ \
target\ vector \((s)\)/
          matrix\ do\ not\ have\ the\ same\ \(\(dimensions\)\(.\)\)\)}]], \
"Message",
  CellTags->"General::lslc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the coefficient matrix is not \
compatible with the target vector in the indicated function.\n\
\[FilledSmallSquare] This message can be generated by ",
  StyleBox["LinearSolve", "MR"],
  " or by ",
  StyleBox["LUBackSubstitution", "MR"],
  "."
}], "Notes",
  CellTags->"General::lslc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::lslc"],

Cell["\<\
An error occurs in this example because the first argument includes \
coefficients for two equations and the second argument gives coefficients for \
four equations.\
\>", "Text",
  CellTags->"General::lslc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[{{2, 1}, {3, 5}}, {1, 1, 2, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::lslc"],

Cell[BoxData[
    \(LinearSolve::"lslc" \(\(:\)\(\ \)\) 
      "Coefficient matrix and target vector(s)/matrix do not have the same \
dimensions."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::lslc"],

Cell[BoxData[
    \(LinearSolve[{{2, 1}, {3, 5}}, {1, 1, 2, 2}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::lslc"]
}, Open  ]],

Cell[TextData[{
  "These examples show valid arguments in ",
  StyleBox["LinearSolve", "MR"],
  "."
}], "Text",
  CellTags->"General::lslc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[{{2, 1}, {3, 5}}, {1, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::lslc"],

Cell[BoxData[
    \({4\/7, \(-\(1\/7\)\)}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::lslc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[{{2, 1}, {3, 5}}, {{1, 2, 7}, {1, 2, 7}}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::lslc"],

Cell[BoxData[
    \({{4\/7, 8\/7, 4}, {\(-\(1\/7\)\), \(-\(2\/7\)\), \(-1\)}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::lslc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::lsv", "ObjectNameWarningMessages",
  CellTags->"General::lsv"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"lsv\"\>"}], \(\(:\)\(\ \)\), "Second", " ", 
        "argument", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "neither", " ", "a", " ", "non"}], 
      "-", \(empty\ vector\ nor\ a\ non\), 
      "-", \(empty\ \(\(matrix\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::lsv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the structure of the indicated \
function argument is not valid.\n\[FilledSmallSquare] This message can be \
generated by ",
  StyleBox["LinearSolve", "MR"],
  " or by ",
  StyleBox["LUBackSubstitution", "MR"],
  "."
}], "Notes",
  CellTags->"General::lsv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::nosol", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::nosol"],

Cell[BoxData[
    \(LinearSolve::"nosol" \(\(:\)\(\ \)\) \(Linear\ equation\ encountered\ \
which\ has\ no\ \(\(solution\)\(.\)\)\)\)], "Message",
  CellTags->"LinearSolve::nosol"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the equations specified in ",
  StyleBox["LinearSolve", "MR"],
  " are inconsistent."
}], "Notes",
  CellTags->"LinearSolve::nosol"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"LinearSolve::nosol"],

Cell["\<\
An error occurs in this example because these equations do not have \
a solution.\
\>", "Text",
  CellTags->"LinearSolve::nosol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[{{1, 3}, {2, 6}}, {1, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"LinearSolve::nosol"],

Cell[BoxData[
    \(LinearSolve::"nosol" \(\(:\)\(\ \)\) 
      "Linear equation encountered which has no solution."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"LinearSolve::nosol"],

Cell[BoxData[
    \(LinearSolve[{{1, 3}, {2, 6}}, {1, 1}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"LinearSolve::nosol"]
}, Open  ]],

Cell[TextData[{
  "This shows equivalent equations using ",
  StyleBox["Solve", "MR"],
  "."
}], "Text",
  CellTags->"LinearSolve::nosol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[{x + 3  y == 1, 2  x + 6  y == 1}, {x, y}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"LinearSolve::nosol"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"LinearSolve::nosol"]
}, Open  ]],

Cell["\<\
This shows a specification of equations that have a solution.\
\>", \
"Text",
  CellTags->"LinearSolve::nosol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinearSolve[{{1, 3}, {1, 6}}, {1, 1}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"LinearSolve::nosol"],

Cell[BoxData[
    \({1, 0}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"LinearSolve::nosol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
RowReduce::rmeth
LinearSolve::rmeth
NullSpace::rmeth
Inverse::rmeth\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], 
            "::", "\<\"rmeth\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
Method\)}], " ", "->", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "should", " ", "be", " ", "CofactorExpansion"}]}], 
      ",", " ", "OneStepRowReduction", ",", " ", "DivisionFreeRowReduction", 
      ",", " ", \(or\ \(\(Automatic\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Method", "MR"],
  " option in the indicated function does not match any of the expected \
values."
}], "Notes",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["LinearSolve", "MR"],
  " is not a valid value for the ",
  StyleBox["Method", "MR"],
  " option in ",
  StyleBox["Inverse", "MR"],
  "."
}], "Text",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inverse[{{e11, e12, e13}, {e21, e22, e23}, {e31, e32, e33}}, 
      Method -> LinearSolve]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],

Cell[BoxData[
    \(Inverse::"rmeth" \(\(:\)\(\ \)\) 
      "Value of option Method -> \!\(LinearSolve\) should be \
CofactorExpansion, OneStepRowReduction, DivisionFreeRowReduction, or \
Automatic."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "RowReduce::rmeth"}],

Cell[BoxData[
    \(Inverse[{{e11, e12, e13}, {e21, e22, e23}, {e31, e32, e33}}, 
      Method \[Rule] LinearSolve]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "RowReduce::rmeth"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Method", "MR"],
  " option in ",
  StyleBox["Inverse", "MR"],
  "."
}], "Text",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Inverse[{{e11, e12, e13}, {e21, e22, e23}, {e31, e32, e33}}, 
      Method -> CofactorExpansion]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],

Cell[BoxData[
    \({{\((\(-e23\)\ e32 + e22\ e33)\)/\((\(-e13\)\ e22\ e31 + 
              e12\ e23\ e31 + e13\ e21\ e32 - e11\ e23\ e32 - e12\ e21\ e33 + 
              e11\ e22\ e33)\), \((e13\ e32 - 
              e12\ e33)\)/\((\(-e13\)\ e22\ e31 + e12\ e23\ e31 + 
              e13\ e21\ e32 - e11\ e23\ e32 - e12\ e21\ e33 + 
              e11\ e22\ e33)\), \((\(-e13\)\ e22 + 
              e12\ e23)\)/\((\(-e13\)\ e22\ e31 + e12\ e23\ e31 + 
              e13\ e21\ e32 - e11\ e23\ e32 - e12\ e21\ e33 + 
              e11\ e22\ e33)\)}, {\((e23\ e31 - 
              e21\ e33)\)/\((\(-e13\)\ e22\ e31 + e12\ e23\ e31 + 
              e13\ e21\ e32 - e11\ e23\ e32 - e12\ e21\ e33 + 
              e11\ e22\ e33)\), \((\(-e13\)\ e31 + 
              e11\ e33)\)/\((\(-e13\)\ e22\ e31 + e12\ e23\ e31 + 
              e13\ e21\ e32 - e11\ e23\ e32 - e12\ e21\ e33 + 
              e11\ e22\ e33)\), \((e13\ e21 - 
              e11\ e23)\)/\((\(-e13\)\ e22\ e31 + e12\ e23\ e31 + 
              e13\ e21\ e32 - e11\ e23\ e32 - e12\ e21\ e33 + 
              e11\ e22\ e33)\)}, {\((\(-e22\)\ e31 + 
              e21\ e32)\)/\((\(-e13\)\ e22\ e31 + e12\ e23\ e31 + 
              e13\ e21\ e32 - e11\ e23\ e32 - e12\ e21\ e33 + 
              e11\ e22\ e33)\), \((e12\ e31 - 
              e11\ e32)\)/\((\(-e13\)\ e22\ e31 + e12\ e23\ e31 + 
              e13\ e21\ e32 - e11\ e23\ e32 - e12\ e21\ e33 + 
              e11\ e22\ e33)\), \((\(-e12\)\ e21 + 
              e11\ e22)\)/\((\(-e13\)\ e22\ e31 + e12\ e23\ e31 + 
              e13\ e21\ e32 - e11\ e23\ e32 - e12\ e21\ e33 + 
              e11\ e22\ e33)\)}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "RowReduce::rmeth"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
SchurDecomposition::schurf
Developer`HessenbergDecomposition::schurf\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "SchurDecomposition::schurf", "Developer`HessenbergDecomposition::schurf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"schurf\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["function",
          "TI"], " ", "has", " ", "received", " ", "a", " ", "matrix", " ", 
        "with", " ", "infinite", " ", \(\(precision\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "SchurDecomposition::schurf", "Developer`HessenbergDecomposition::schurf"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["SchurDecomposition", "MR"],
  " is a matrix in which the elements are integers, rational numbers, or \
exact complex numbers. "
}], "Notes",
  CellTags->{
  "SchurDecomposition::schurf", "Developer`HessenbergDecomposition::schurf"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "SchurDecomposition::schurf", "Developer`HessenbergDecomposition::schurf"}],

Cell["\<\
An error occurs in this example because all of the matrix elements \
are integers.\
\>", "Text",
  CellTags->{
  "SchurDecomposition::schurf", "Developer`HessenbergDecomposition::schurf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchurDecomposition[{{1, 2}, {0, 1}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "SchurDecomposition::schurf", "Developer`HessenbergDecomposition::schurf"}],

Cell[BoxData[
    \(SchurDecomposition::"schurf" \(\(:\)\(\ \)\) 
      "\!\(SchurDecomposition\) has received a matrix with infinite \
precision."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "Developer`HessenbergDecomposition::schurf", "SchurDecomposition::schurf"}],

Cell[BoxData[
    \(SchurDecomposition[{{1, 2}, {0, 1}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "Developer`HessenbergDecomposition::schurf", "SchurDecomposition::schurf"}]
}, Open  ]],

Cell["\<\
This computation can be done by converting the matrix elements into \
inexact numbers.\
\>", "Text",
  CellTags->{
  "SchurDecomposition::schurf", "Developer`HessenbergDecomposition::schurf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchurDecomposition[N[{{1, 2}, {0, 1}}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "SchurDecomposition::schurf", "Developer`HessenbergDecomposition::schurf"}],

Cell[BoxData[
    \({{{1.`, 0.`}, {0.`, 1.`}}, {{1.`, 2.`}, {0.`, 1.`}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "Developer`HessenbergDecomposition::schurf", "SchurDecomposition::schurf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
SchurDecomposition::schurn
Developer`HessenbergDecomposition::schurn\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "SchurDecomposition::schurn", "Developer`HessenbergDecomposition::schurn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"schurn\"\>"}], ":", " ", 
      RowBox[{
        RowBox[{
          StyleBox["f",
            "TI"], " ", "has", " ", "received", " ", "a", " ", "matrix", " ", 
          "with", " ", "non"}], 
        "-", \(numeric\ \(\(elements\)\(.\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "SchurDecomposition::schurn", "Developer`HessenbergDecomposition::schurn"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["SchurDecomposition", "MR"],
  " is a matrix in which not all of the elements are numbers."
}], "Notes",
  CellTags->{
  "SchurDecomposition::schurn", "Developer`HessenbergDecomposition::schurn"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "SchurDecomposition::schurn", "Developer`HessenbergDecomposition::schurn"}],

Cell["\<\
An error occurs in this example because one of the matrix elements \
is a symbol.\
\>", "Text",
  CellTags->{
  "SchurDecomposition::schurn", "Developer`HessenbergDecomposition::schurn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SchurDecomposition[{{1.0, 2.3}, {5, x}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "SchurDecomposition::schurn", "Developer`HessenbergDecomposition::schurn"}],

Cell[BoxData[
    \(SchurDecomposition::"schurn" \(\(:\)\(\ \)\) 
      "\!\(SchurDecomposition\) has received a matrix with non-numeric \
elements."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "Developer`HessenbergDecomposition::schurn", "SchurDecomposition::schurn"}],

Cell[BoxData[
    \(SchurDecomposition[{{1.`, 2.3`}, {5, x}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "Developer`HessenbergDecomposition::schurn", "SchurDecomposition::schurn"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["SchurDecomposition", "MR"],
  "."
}], "Text",
  CellTags->{
  "SchurDecomposition::schurn", "Developer`HessenbergDecomposition::schurn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{x = 1}, SchurDecomposition[{{1.0, 2.3}, {5, x}}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "SchurDecomposition::schurn", "Developer`HessenbergDecomposition::schurn"}],

Cell[BoxData[
    \({{{0.561309623247887`, \(-0.827605888602368`\)}, {0.827605888602368`, 
          0.561309623247887`}}, {{4.3911649915626345`, \(-2.7`\)}, {0.`, \
\(-2.3911649915626336`\)}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "Developer`HessenbergDecomposition::schurn", "SchurDecomposition::schurn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::unpack1", "ObjectNameWarningMessages",
  CellTags->"General::unpack1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"unpack1\"\>"}], \(\(:\)\(\ \)\), \(Unpacking\ \
\(\(array\)\(.\)\)\)}]], "Message",
  CellTags->"General::unpack1"],

Cell["\<\
\[FilledSmallSquare] Generated when an expression that is stored as \
a packed array is unpacked.
\[FilledSmallSquare] This message is intended for diagnostic purposes and \
does not necessarily indicate an error.
\[FilledSmallSquare] This message is generated only if a system option to \
generate this message has been set.\
\>", "Notes",
  CellTags->"General::unpack1"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::unpack1"],

Cell["\<\
This example shows an array that is unpacked when one of the \
elements of the array is modified.\
\>", "Text",
  CellTags->"General::unpack1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<UnpackMessage\>" \[Rule] True]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"General::unpack1"],

Cell[BoxData[
    \("UnpackMessage" \[Rule] True\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::unpack1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{expr = Range[5]}, expr[\([3]\)] = 1.7; expr]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::unpack1"],

Cell[BoxData[
    \(Developer`FromPackedArray::"unpack1" \(\(:\)\(\ \)\) 
      "Unpacking array."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::unpack1"],

Cell[BoxData[
    \({1, 2, 1.7`, 4, 5}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::unpack1"]
}, Open  ]],

Cell["Turn the system option off.", "Text",
  CellTags->"General::unpack1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<UnpackMessage\>" \[Rule] 
        False]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::unpack1"],

Cell[BoxData[
    \("UnpackMessage" \[Rule] False\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::unpack1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::unpack", "ObjectNameWarningMessages",
  CellTags->"General::unpack"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"unpack\"\>"}], \(\(:\)\(\ \)\), "Unpacking", " ", 
      "array", " ", "in", " ", "call", " ", "to", " ", 
      RowBox[{
        StyleBox["f",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::unpack"],

Cell["\<\
\[FilledSmallSquare] Generated when an expression that is stored as \
a packed array is unpacked.
\[FilledSmallSquare] This message is intended for diagnostic purposes and \
does not necessarily indicate an error.
\[FilledSmallSquare] This message is generated only if a system option to \
generate this message has been set.\
\>", "Notes",
  CellTags->"General::unpack"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::unpack"],

Cell["\<\
This example shows an array that is unpacked when a non-numerical \
element is added to the array.\
\>", "Text",
  CellTags->"General::unpack"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<UnpackMessage\>" \[Rule] True]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"General::unpack"],

Cell[BoxData[
    \("UnpackMessage" \[Rule] True\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::unpack"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{expr = Range[5]}, expr + Null]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::unpack"],

Cell[BoxData[
    \(Developer`FromPackedArray::"unpack1" \(\(:\)\(\ \)\) 
      "Unpacking array."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::unpack"],

Cell[BoxData[
    \({1 + Null, 2 + Null, 3 + Null, 4 + Null, 5 + Null}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::unpack"]
}, Open  ]],

Cell["Turn the system option off.", "Text",
  CellTags->"General::unpack"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Developer`SetSystemOptions["\<UnpackMessage\>" \[Rule] 
        False]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::unpack"],

Cell[BoxData[
    \("UnpackMessage" \[Rule] False\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::unpack"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::punpack", "ObjectNameWarningMessages",
  CellTags->"General::punpack"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"punpack\"\>"}], \(\(:\)\(\ \)\), "Unpacking", " ",
       "array", " ", "to", " ", "level", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", "call", " ", "to", " ", 
      RowBox[{
        StyleBox["f",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::punpack"],

Cell["\<\
\[FilledSmallSquare] Generated when an expression that is stored as \
a packed array is partially unpacked.
\[FilledSmallSquare] This message is intended for diagnostic purposes and \
does not necessarily indicate an error.
\[FilledSmallSquare] This message is generated only if a system option to \
generate this message has been set.\
\>", "Notes",
  CellTags->"General::punpack"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::punpack1", "ObjectNameWarningMessages",
  CellTags->"General::punpack1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"punpack1\"\>"}], \(\(:\)\(\ \)\), "Unpacking", 
      " ", "array", " ", "to", " ", "level", " ", 
      RowBox[{
        StyleBox["n",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::punpack1"],

Cell["\<\
\[FilledSmallSquare] Generated when an expression that is stored as \
a packed array is partially unpacked.
\[FilledSmallSquare] This message is intended for diagnostic purposes and \
does not necessarily indicate an error.
\[FilledSmallSquare] This message is generated only if a system option to \
generate this message has been set.\
\>", "Notes",
  CellTags->"General::punpack1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Testing`Internal`MVectorNorm::mrange", "ObjectNameWarningMessages",
  CellTags->"Testing`Internal`MVectorNorm::mrange"],

Cell[BoxData[
    \(Testing`Internal`MVectorNorm::"mrange" \(\(:\)\(\ \)\) \(Either\ a\ \
vector\ element\ or\ a\ norm\ outside\ machine\ precision\ \
\(\(boundaries\)\(.\)\)\)\)], "Message",
  CellTags->"Testing`Internal`MVectorNorm::mrange"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Testing`Internal`MVectorNorm::mrange"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Testing`Internal`MVectorNorm::mvntestp", "ObjectNameWarningMessages",
  CellTags->"Testing`Internal`MVectorNorm::mvntestp"],

Cell[BoxData[
    \(Testing`Internal`MVectorNorm::"mvntestp" \(\(:\)\(\ \)\) \(Incorrect\ p\
\ type\ in\ MTensor_VectorNorm \(()\)\ test\ driver; \ 
      must\ be\ integer\ or\ \(\(real\)\(.\)\)\)\)], "Message",
  CellTags->"Testing`Internal`MVectorNorm::mvntestp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Testing`Internal`MVectorNorm::mvntestp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Testing`Internal`MVectorNorm::mvntestv", "ObjectNameWarningMessages",
  CellTags->"Testing`Internal`MVectorNorm::mvntestv"],

Cell[BoxData[
    \(Testing`Internal`MVectorNorm::"mvntestv" \(\(:\)\(\ \)\) \(Incorrect\ \
vector\ type\ in\ MTensor_VectorNorm \(()\)\ test\ driver; \ 
      must\ be\ real\ or\ \(\(complex\)\(.\)\)\)\)], "Message",
  CellTags->"Testing`Internal`MVectorNorm::mvntestv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Testing`Internal`MVectorNorm::mvntestv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Testing`Internal`MScaledVectorNorm::mrange", "ObjectNameWarningMessages",
  CellTags->"Testing`Internal`MScaledVectorNorm::mrange"],

Cell[BoxData[
    \(Testing`Internal`MScaledVectorNorm::"mrange" \(\(:\)\(\ \)\) \(Either\ \
a\ vector\ element\ or\ a\ norm\ outside\ machine\ precision\ \
\(\(boundaries\)\(.\)\)\)\)], "Message",
  CellTags->"Testing`Internal`MScaledVectorNorm::mrange"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Testing`Internal`MScaledVectorNorm::mrange"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Testing`Internal`MScaledVectorNorm::mvntestp", \
"ObjectNameWarningMessages",
  CellTags->"Testing`Internal`MScaledVectorNorm::mvntestp"],

Cell[BoxData[
    \(Testing`Internal`MScaledVectorNorm::"mvntestp" \(\(:\)\(\ \)\) \
\(Incorrect\ p\ type\ in\ MTensor_VectorNorm \(()\)\ test\ driver; \ 
      must\ be\ integer\ or\ \(\(real\)\(.\)\)\)\)], "Message",
  CellTags->"Testing`Internal`MScaledVectorNorm::mvntestp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Testing`Internal`MScaledVectorNorm::mvntestp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Testing`Internal`MScaledVectorNorm::mvntestv", \
"ObjectNameWarningMessages",
  CellTags->"Testing`Internal`MScaledVectorNorm::mvntestv"],

Cell[BoxData[
    \(Testing`Internal`MScaledVectorNorm::"mvntestv" \(\(:\)\(\ \)\) \
\(Incorrect\ vector\ type\ in\ MTensor_VectorNorm \(()\)\ test\ driver; \ 
      must\ be\ real\ or\ \(\(complex\)\(.\)\)\)\)], "Message",
  CellTags->"Testing`Internal`MScaledVectorNorm::mvntestv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Testing`Internal`MScaledVectorNorm::mvntestv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Inverse::invc", "ObjectNameWarningMessages",
  CellTags->"Inverse::invc"],

Cell[BoxData[
    RowBox[{\(Inverse::"invc"\), \(\(:\)\(\ \)\), \(\(Result\)\(\ \)\(for\)\(\
\ \)\(inverse\)\(\ \)\(of\)\(\ \)\(badly\)\(\ \)\(conditioned\)\(\ \)\(matrix\
\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(may\ contain\ significant\ numerical\ \
\(\(errors\)\(.\)\)\)\)}]], "Message",
  CellTags->"Inverse::invc"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Inverse::invc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
MatrixPower::zvec
MatrixExp::zvec\
\>", "ObjectNameWarningMessages",
  CellTags->{"MatrixPower::zvec", "MatrixExp::zvec"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"zvec\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "compute", " ", 
      StyleBox["expr",
        "TI"], " ", "because", " ", "the", " ", "argument", " ", "matrix", 
      " ", 
      StyleBox["mat",
        "TI"], " ", "has", " ", "a", " ", "zero", 
      " ", \(\(eigenvector\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"MatrixPower::zvec", "MatrixExp::zvec"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated matrix operation \
cannot be computed because the matrix does not have a complete set of \
non-zero eigenvectors.
\[FilledSmallSquare] This message occurs for fractional powers of matrices \
for which the number of non-zero eigenvectors is less than the dimension of \
the matrix.\
\>", "Notes",
  CellTags->{"MatrixPower::zvec", "MatrixExp::zvec"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Range::range", "ObjectNameWarningMessages",
  CellTags->"Range::range"],

Cell[BoxData[
    RowBox[{\(Range::"range"\), \(\(:\)\(\ \)\), \(\(Range\)\(\ \
\)\(specification\)\(\ \)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ machine - 
        size\ \(\(integer\)\(.\)\)\)\)}]], "Message",
  CellTags->"Range::range"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["Range", "MR"],
  " is not a real number or is larger than the largest number that can be \
represented as a machine integer on your computer."
}], "Notes",
  CellTags->"Range::range"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Range::range"],

Cell["\<\
An error occurs in this example because the argument is a complex \
number.\
\>", "Text",
  CellTags->"Range::range"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[3  I]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Range::range"],

Cell[BoxData[
    \(Range::"range" \(\(:\)\(\ \)\) 
      "Range specification in \!\(Range[\(\(3\\ \[ImaginaryI]\)\)]\) is not a \
machine-size integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Range::range"],

Cell[BoxData[
    \(Range[3\ \[ImaginaryI]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Range::range"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["Range", "MR"],
  "."
}], "Text",
  CellTags->"Range::range"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Range[3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Range::range"],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Range::range"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transpose::diagnl", "ObjectNameWarningMessages",
  CellTags->"Transpose::diagnl"],

Cell[BoxData[
    RowBox[{\(Transpose::"diagnl"\), \(\(:\)\(\ \)\), \(\(Level\)\(\ \
\)\(rearrangement\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(would\ require\ collapsing\ dimensions\ of\ unequal\ \
\(\(lengths\)\(.\)\)\)\)}]], "Message",
  CellTags->"Transpose::diagnl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a degenerate permutation specification \
in ",
  StyleBox["Transpose", "MR"],
  " is used to collapse the dimensions of a matrix and the specified \
dimensions do not have the same length."
}], "Notes",
  CellTags->"Transpose::diagnl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Transpose::diagnl"],

Cell["\<\
An error occurs in this example because the dimensions to be \
combined do not have the same length.\
\>", "Text",
  CellTags->"Transpose::diagnl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{{1, 2}, {3, 4}, {5, 6}}, {1, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Transpose::diagnl"],

Cell[BoxData[
    \(Transpose::"diagnl" \(\(:\)\(\ \)\) 
      "Level rearrangement \!\({1, 1}\) would require collapsing dimensions \
of unequal lengths."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Transpose::diagnl"],

Cell[BoxData[
    \(Transpose[{{1, 2}, {3, 4}, {5, 6}}, {1, 1}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Transpose::diagnl"]
}, Open  ]],

Cell["\<\
This permutation specification can be used to pick out the diagonal \
elements in a square matrix.\
\>", "Text",
  CellTags->"Transpose::diagnl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{{1, 2}, {3, 4}}, {1, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Transpose::diagnl"],

Cell[BoxData[
    \({1, 4}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Transpose::diagnl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transpose::newdims", "ObjectNameWarningMessages",
  CellTags->"Transpose::newdims"],

Cell[BoxData[
    RowBox[{\(Transpose::"newdims"\), \(\(:\)\(\ \)\), \(\(Level\)\(\ \
\)\(rearrangement\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "does", " ", "not", " ", "specify", " ", "destination", 
      " ", "for", " ", "level", " ", 
      RowBox[{
        StyleBox["n",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Transpose::newdims"],

Cell["\<\
\[FilledSmallSquare] Generated when a degenerate permutation \
specification does not include all of the outer dimensions of the \
matrix.\
\>", "Notes",
  CellTags->"Transpose::newdims"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Transpose::newdims"],

Cell["\<\
An error occurs in this example because the outer dimension is \
omitted from the permutation specification.\
\>", "Text",
  CellTags->"Transpose::newdims"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{{{1, 2}}, {{3, 4}}}, {3, 3, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Transpose::newdims"],

Cell[BoxData[
    \(Transpose::"newdims" \(\(:\)\(\ \)\) 
      "Level rearrangement \!\({3, 3, 2}\) does not specify destination for \
level \!\(1\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Transpose::newdims"],

Cell[BoxData[
    \(Transpose[{{{1, 2}}, {{3, 4}}}, {3, 3, 2}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Transpose::newdims"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid permutation specification in ",
  StyleBox["Transpose", "MR"],
  "."
}], "Text",
  CellTags->"Transpose::newdims"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{{{1, 2}}, {{3, 4}}}, {1, 3, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Transpose::newdims"],

Cell[BoxData[
    \({{{1}, {2}}, {{3}, {4}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Transpose::newdims"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transpose::nmtx", "ObjectNameWarningMessages",
  CellTags->"Transpose::nmtx"],

Cell[BoxData[
    RowBox[{\(Transpose::"nmtx"\), \(\(:\)\(\ \)\), \(The\ first\ two\ levels\
\ of\ the\ one - \(\(dimensional\)\(\ \)\(list\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(cannot\ be\ \(\(transposed\)\(.\)\)\)\)}]], "Message",\

  CellTags->"Transpose::nmtx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["Transpose", "MR"],
  " is not a matrix."
}], "Notes",
  CellTags->"Transpose::nmtx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Transpose::nmtx"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["Transpose", "MR"],
  " is a vector rather than a matrix."
}], "Text",
  CellTags->"Transpose::nmtx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{1, 2, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Transpose::nmtx"],

Cell[BoxData[
    \(Transpose::"nmtx" \(\(:\)\(\ \)\) 
      "The first two levels of the one-dimensional list \!\({1, 2, 3}\) \
cannot be transposed."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Transpose::nmtx"],

Cell[BoxData[
    \(Transpose[{1, 2, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Transpose::nmtx"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid matrix argument in ",
  StyleBox["Transpose", "MR"],
  "."
}], "Text",
  CellTags->"Transpose::nmtx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{{1, 2, 3}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Transpose::nmtx"],

Cell[BoxData[
    \({{1}, {2}, {3}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Transpose::nmtx"]
}, Open  ]],

Cell[TextData[{
  "You can use the permutation specification ",
  StyleBox["{1}", "MR"],
  " if it is necessary to apply ",
  StyleBox["Transpose", "MR"],
  " to a vector."
}], "Text",
  CellTags->"Transpose::nmtx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{1, 2, 3}, {1}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Transpose::nmtx"],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Transpose::nmtx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transpose::tperm", "ObjectNameWarningMessages",
  CellTags->"Transpose::tperm"],

Cell[BoxData[
    RowBox[{\(Transpose::"tperm"\), \(\(:\)\(\ \)\), \(\(Permutation\)\(\ \
\)\), 
      StyleBox["expr",
        "TI"], " ", "is", " ", "longer", " ", "than", " ", "the", " ", 
      "dimensions", " ", 
      StyleBox["dims",
        "TI"], " ", "of", " ", "the", " ", \(\(array\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Transpose::tperm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the length of the second argument in \
",
  StyleBox["Transpose", "MR"],
  " is greater than the number of matrix dimensions in the first argument."
}], "Notes",
  CellTags->"Transpose::tperm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Transpose::tperm"],

Cell[TextData[{
  "An error occurs in this example because two dimensions are specified in \
the second argument of ",
  StyleBox["Transpose", "MR"],
  " and the first argument has only one dimension."
}], "Text",
  CellTags->"Transpose::tperm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{1, 2, 3}, {2, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Transpose::tperm"],

Cell[BoxData[
    \(Transpose::"tperm" \(\(:\)\(\ \)\) 
      "Permutation \!\({2, 1}\) is longer than the dimensions \!\({3}\) of \
the array."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Transpose::tperm"],

Cell[BoxData[
    \(Transpose[{1, 2, 3}, {2, 1}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Transpose::tperm"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid permutation specification when the first argument in ",
  StyleBox["Transpose", "MR"],
  " is a vector."
}], "Text",
  CellTags->"Transpose::tperm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{1, 2, 3}, {1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Transpose::tperm"],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Transpose::tperm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transpose::perm", "ObjectNameWarningMessages",
  CellTags->"Transpose::perm"],

Cell[BoxData[
    RowBox[{\(Transpose::"perm"\), \(\(:\)\(\ \)\), "The", " ", "length", " ",
       "of", " ", "permutation", " ", 
      StyleBox["perm",
        "TI"], " ", "does", " ", "not", " ", "equal", " ", "the", " ", 
      "depth", " ", "of", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Transpose::perm"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Transpose::perm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transpose::perm1", "ObjectNameWarningMessages",
  CellTags->"Transpose::perm1"],

Cell[BoxData[
    RowBox[{\(Transpose::"perm1"\), \(\(:\)\(\ \)\), "Entry", " ", 
      StyleBox["e",
        "TI"], " ", "in", " ", "permutation", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ positive\ machine\ \
\(\(integer\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Transpose::perm1"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the elements in the second argument of \
",
  StyleBox["Transpose", "MR"],
  " are not all positive integers or are not integers that can be represented \
as machine integers on your computer."
}], "Notes",
  CellTags->"Transpose::perm1"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Transpose::perm1"],

Cell[TextData[{
  "An error occurs in this example because the element in the second argument \
of ",
  StyleBox["Transpose", "MR"],
  " is a list rather than an integer."
}], "Text",
  CellTags->"Transpose::perm1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{{1, 2}, {3, 4}}, {{2, 1}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Transpose::perm1"],

Cell[BoxData[
    \(Transpose::"perm1" \(\(:\)\(\ \)\) 
      "Entry \!\({2, 1}\) in permutation \!\({\({2, 1}\)}\) is not a positive \
machine integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Transpose::perm1"],

Cell[BoxData[
    \(Transpose[{{1, 2}, {3, 4}}, {{2, 1}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Transpose::perm1"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Transpose", "MR"],
  "."
}], "Text",
  CellTags->"Transpose::perm1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{{1, 2}, {3, 4}}, {2, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Transpose::perm1"],

Cell[BoxData[
    \({{1, 3}, {2, 4}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Transpose::perm1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transpose::perm2", "ObjectNameWarningMessages",
  CellTags->"Transpose::perm2"],

Cell[BoxData[
    RowBox[{\(Transpose::"perm2"\), \(\(:\)\(\ \)\), "Entry", " ", 
      StyleBox["e",
        "TI"], " ", "is", " ", "out", " ", "of", " ", "bounds", " ", "for", 
      " ", "permutation", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Transpose::perm2"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated element from the second \
argument of ",
  StyleBox["Transpose", "MR"],
  " includes an element that is greater than the number of dimensions in the \
first argument."
}], "Notes",
  CellTags->"Transpose::perm2"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Transpose::perm2"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Transpose", "MR"],
  " specifies dimensions that are not available in the first argument."
}], "Text",
  CellTags->"Transpose::perm2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{{1, 2}, {3, 4}}, {3, 4}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Transpose::perm2"],

Cell[BoxData[
    \(Transpose::"perm2" \(\(:\)\(\ \)\) 
      "Entry \!\(3\) is out of bounds for permutation \!\({3, 4}\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Transpose::perm2"],

Cell[BoxData[
    \(Transpose[{{1, 2}, {3, 4}}, {3, 4}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Transpose::perm2"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Transpose", "MR"],
  "."
}], "Text",
  CellTags->"Transpose::perm2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{{1, 2}, {3, 4}}, {1, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Transpose::perm2"],

Cell[BoxData[
    \({{1, 2}, {3, 4}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Transpose::perm2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::lconv", "ObjectNameWarningMessages",
  CellTags->"General::lconv"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"lconv\"\>"}], \(\(:\)\(\ \)\), \(QR\ algorithm\ failed\ to\
\ \(\(converge\)\(.\)\)\)}]], "Message",
  CellTags->"General::lconv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by failure in the algorithm that computes \
the QR decomposition of a matrix.\n\[FilledSmallSquare] In current versions \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", this message is used by ",
  StyleBox["Eigensystem", "MR"],
  ", ",
  StyleBox["Eigenvectors", "MR"],
  ", and ",
  StyleBox["Eigenvalues", "MR"],
  ".\n\[FilledSmallSquare] If you see this message in a situation where it is \
not expected, please contact Technical Support."
}], "Notes",
  CellTags->"General::lconv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::luc", "ObjectNameWarningMessages",
  CellTags->"General::luc"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"luc\"\>"}], \(\(:\)\(\ \)\), "Result", " ", "for",
       " ", 
      StyleBox["op",
        "TI"], " ", "of", " ", "badly", " ", "conditioned", " ", "matrix", 
      " ", 
      StyleBox["expr",
        "TI"], " ", "may", " ", "contain", " ", "significant", " ", 
      "numerical", " ", \(\(errors\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::luc"],

Cell["\<\
\[FilledSmallSquare] Generated by a failure in the algorithm that \
is used in computing numerical solutions of linear systems of equations.
\[FilledSmallSquare] If you see this message in an example where it is not \
expected, please contact Technical Support.\
\>", "Notes",
  CellTags->"General::luc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::matrix", "ObjectNameWarningMessages",
  CellTags->"General::matrix"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"matrix\"\>"}], \(\(:\)\(\ \)\), "Argument", " ", 
      StyleBox["expr",
        "TI"], " ", "at", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "nonempty", " ", 
      "rectangular", " ", \(\(matrix\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::matrix"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected \
to be a matrix.\n\[FilledSmallSquare] For the purpose of this message an \
expression is a matrix if the expression is a list with at least one element, \
all of the elements are lists of the same length, and none of the elements of \
the inner lists are lists.\n\[FilledSmallSquare] This message can be \
generated by most linear algebra functions and by graphics functions, such as \
",
  StyleBox["RasterArray", "MR"],
  ", that use matrix arguments."
}], "Notes",
  CellTags->"General::matrix"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::matrix"],

Cell[TextData[{
  "The argument of ",
  StyleBox["PseudoInverse", "MR"],
  " is expected to be a matrix."
}], "Text",
  CellTags->"General::matrix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PseudoInverse[{{1.3, 2.5}, {3.1, {2.7}}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::matrix"],

Cell[BoxData[
    \(PseudoInverse::"matrix" \(\(:\)\(\ \)\) 
      "Argument \!\({\(\({1.3`, 2.5`}\)\), \(\({3.1`, \(\({2.7`}\)\)}\)\)}\) \
at position \!\(1\) is not a nonempty rectangular matrix."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::matrix"],

Cell[BoxData[
    \(PseudoInverse[{{1.3`, 2.5`}, {3.1`, {2.7`}}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::matrix"]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["PseudoInverse", "MR"],
  "."
}], "Text",
  CellTags->"General::matrix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PseudoInverse[{{1.3, 2.5}, {3.1, 2.7}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::matrix"],

Cell[BoxData[
    \({{\(-0.6367924528301887`\), 
        0.589622641509434`}, {0.7311320754716981`, \
\(-0.30660377358490565`\)}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::matrix"]
}, Open  ]],

Cell[BoxData[""], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::matrix"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::matsq", "ObjectNameWarningMessages",
  CellTags->"General::matsq"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"matsq\"\>"}], \(\(:\)\(\ \)\), "Argument", " ", 
      StyleBox["expr",
        "TI"], " ", "at", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "nonempty", " ", 
      "square", " ", \(\(matrix\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::matsq"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression is \
expected to be a square matrix.
\[FilledSmallSquare] A square matrix is a list of lists in which all of the \
sublists have the same length and none of the elements in the sublists are \
lists.\
\>", "Notes",
  CellTags->"General::matsq"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::matsq"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["Det", "MR"],
  " is expected to be a square matrix."
}], "Text",
  CellTags->"General::matsq"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[{{1, 2, 3, 4}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::matsq"],

Cell[BoxData[
    \(Det::"matsq" \(\(:\)\(\ \)\) 
      "Argument \!\({\({1, 2, 3, 4}\)}\) at position \!\(1\) is not a \
nonempty square matrix."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::matsq"],

Cell[BoxData[
    \(Det[{{1, 2, 3, 4}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::matsq"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["Det", "MR"],
  "."
}], "Text",
  CellTags->"General::matsq"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[{{1, 2}, {3, 4}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::matsq"],

Cell[BoxData[
    \(\(-2\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::matsq"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ListConvolve::depth
ListCorrelate::depth\
\>", "ObjectNameWarningMessages",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"depth\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
        "dimension", " ", 
        StyleBox["d",
          "TI"], " ", "of", " ", "the", " ", "overhang", " ", "parameters", 
        " ", "exceeds", " ", "the", " ", "rectangular", " ", "rank", " ", 
        "of", " ", "the", " ", "kernel"}], ",", " ", 
      RowBox[{
        StyleBox["r",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the dimension of the third argument in \
",
  StyleBox["ListConvolve", "MR"],
  " or ",
  StyleBox["ListCorrelate", "MR"],
  " is not the same as the rank of the first argument.\n\[FilledSmallSquare] \
The first argument in ",
  StyleBox["ListConvolve", "MR"],
  " or ",
  StyleBox["ListCorrelate", "MR"],
  " is the kernel of the convolution or correlation, and the third argument \
gives the overhang parameters."
}], "Notes",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],

Cell["\<\
An error occurs in this example because the third argument gives \
overhang parameters for two dimensions, while the first argument has only one \
dimension.\
\>", "Text",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListConvolve[{k1, k2, k3}, {d1, d2, d3, d4, d5, 
        d6}, {{3, 1}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],

Cell[BoxData[
    \(ListConvolve::"depth" \(\(:\)\(\ \)\) 
      "The dimension \!\(2\) of the overhang parameters exceeds the \
rectangular rank of the kernel, \!\(1\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],

Cell[BoxData[
    \(ListConvolve[{k1, k2, k3}, {d1, d2, d3, d4, d5, 
        d6}, {{3, 1}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid specification of overhang parameters in ",
  StyleBox["ListConvolve", "MR"],
  "."
}], "Text",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListConvolve[{k1, k2, k3}, {d1, d2, d3, d4, d5, d6}, {3, 1}]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],

Cell[BoxData[
    \({d3\ k1 + d2\ k2 + d1\ k3, d4\ k1 + d3\ k2 + d2\ k3, 
      d5\ k1 + d4\ k2 + d3\ k3, d6\ k1 + d5\ k2 + d4\ k3}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ListConvolve::kldims
ListCorrelate::kldims\
\>", "ObjectNameWarningMessages",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"kldims\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "kernel", " ", 
      StyleBox["kern",
        "TI"], " ", "and", " ", "list", " ", 
      StyleBox["expr",
        "TI"], " ", "are", " ", "not", " ", "both", " ", "nonempty", " ", 
      "lists", " ", "with", " ", "the", " ", "same", " ", "tensor", 
      " ", \(\(rank\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the tensor rank of the first argument \
in ",
  StyleBox["ListConvolve", "MR"],
  " or ",
  StyleBox["ListCorrelate", "MR"],
  " is not the same as the tensor rank of the second argument."
}], "Notes",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],

Cell["\<\
An error occurs in this example because the tensor rank of the \
first argument is not the same as the tensor rank of the second \
argument.\
\>", "Text",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListConvolve[{k1, k2, k3}, {{d1}, {d2}, {d3}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],

Cell[BoxData[
    \(ListConvolve::"kldims" \(\(:\)\(\ \)\) 
      "The kernel \!\({k1, k2, k3}\) and list \!\({\(\({d1}\)\), \
\(\({d2}\)\), \(\({d3}\)\)}\) are not both nonempty lists with the same \
tensor rank."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],

Cell[BoxData[
    \(ListConvolve[{k1, k2, k3}, {{d1}, {d2}, {d3}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}]
}, Open  ]],

Cell[TextData[{
  "This gives an acyclic convolution, using the seventh argument in ",
  StyleBox["ListConvolve", "MR"],
  " to specify the level to use from the first two arguments."
}], "Text",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListConvolve[{k1, k2, k3}, {{d1}, {d2}, {d3}}, 3, 0, Times, Plus, 
      1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],

Cell[BoxData[
    \({{d3\ k1 + d2\ k2 + d1\ k3}, {d3\ k2 + d2\ k3}, {d3\ k3}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ListConvolve::nlen
ListCorrelate::nlen\
\>", "ObjectNameWarningMessages",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nlen\"\>"}], \(\(:\)\(\ \)\), \(The\ end\ conditions\ \
cannot\ be\ satisfied . \ 
          A\ zero\ length\ list\ will\ be\ \(\(returned\)\(.\)\)\)}]], \
"Message",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third element in ",
  StyleBox["ListConvolve", "MR"],
  " or ",
  StyleBox["ListCorrelate", "MR"],
  " specifies a result that does not have any elements."
}], "Notes",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],

Cell["\<\
An error occurs in this example because the limits specified in the \
third argument do not provide for any elements in the result.\
\>", "Text",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListConvolve[{k1, k2}, {d1, d2}, {4, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],

Cell[BoxData[
    \(ListConvolve::"nlen" \(\(:\)\(\ \)\) 
      "The end conditions cannot be satisfied. A zero length list will be \
returned."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ListConvolve", "MR"],
  "."
}], "Text",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListConvolve[{k1, k2}, {d1, d2}, {1, 4}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],

Cell[BoxData[
    \({d1\ k1 + d2\ k2, d2\ k1 + d1\ k2, d1\ k1 + d2\ k2, d2\ k1 + d1\ k2, 
      d1\ k1 + d2\ k2}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ListConvolve::ohp
ListCorrelate::ohp
Partition::ohp\
\>", "ObjectNameWarningMessages",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], "::", "\<\"ohp\"\>"}], \(\(:\)\(\ \)\), "Overhang", " ", 
          "parameters", " ", "in", " ", 
          StyleBox["expr",
            "TI"], " ", "must", " ", "be", " ", "nonzero", " ", "machine"}], 
        "-", \(size\ integers\)}], ",", 
      " ", \(or\ lists\ of\ nonzero\ machine - 
        size\ \(\(integers\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third argument in ",
  StyleBox["ListConvolve", "MR"],
  " or ",
  StyleBox["ListCorrelate", "MR"],
  ", or the fourth argument in ",
  StyleBox["Partition", "MR"],
  ", does not have the expected form.\n\[FilledSmallSquare] The overhang \
parameters are the integers given in the third argument of ",
  StyleBox["ListConvolve", "MR"],
  " or ",
  StyleBox["ListCorrelate", "MR"],
  ", or in the fourth argument of ",
  StyleBox["Partition", "MR"],
  ".\n\[FilledSmallSquare] The overhang parameters are expected to be \
specified using a non-zero integer, a list of non-zero integers, or a list of \
lists of non-zero integers."
}], "Notes",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],

Cell["\<\
An error occurs in this example because the third argument is not \
non-zero.\
\>", "Text",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListCorrelate[{k1, k2, k3}, {d1, d2, d3}, 0, 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],

Cell[BoxData[
    \(ListCorrelate::"ohp" \(\(:\)\(\ \)\) 
      "Overhang parameters in \!\(0\) must be nonzero machine-size integers, \
or lists of nonzero machine-size integers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],

Cell[BoxData[
    \(ListCorrelate[{k1, k2, k3}, {d1, d2, d3}, 0, 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ListCorrelate", "MR"],
  "."
}], "Text",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListCorrelate[{k1, k2, k3}, {d1, d2, d3}, 2, 0]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],

Cell[BoxData[
    \({d1\ k2 + d2\ k3, d1\ k1 + d2\ k2 + d3\ k3, 
      d2\ k1 + d3\ k2}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Partition::ohpdm", "ObjectNameWarningMessages",
  CellTags->"Partition::ohpdm"],

Cell[BoxData[
    \(Partition::"ohpdm" \(\(:\)\(\ \)\) 
      "`1`-dimensional overhang parameter cannot indicate position in \
`2`-dimensional block."\)], "Message",
  CellLabel->"From In[31]:=",
  CellTags->"Partition::ohpdm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of dimensions described in \
the fourth argument in ",
  StyleBox["Partition", "MR"],
  " is not the same as the number of dimensions in the result.\n\
\[FilledSmallSquare] Overhang parameters are specified using the fourth \
argument in ",
  StyleBox["Partition", "MR"],
  "."
}], "Notes",
  CellTags->"Partition::ohpdm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Partition::ohpdm"],

Cell["\<\
An error occurs in this example because the length of the fourth \
argument is greater than the number of dimensions in the result.\
\>", "Text",\

  CellTags->"Partition::ohpdm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[{1, 2, 3, 4}, 2, 1, {2, 3, 4}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Partition::ohpdm"],

Cell[BoxData[
    \(Partition::"ohpdm" \(\(:\)\(\ \)\) 
      "\!\(3\)-dimensional overhang parameter cannot indicate position in \
\!\(1\)-dimensional block."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Partition::ohpdm"],

Cell[BoxData[
    \(Partition[{1, 2, 3, 4}, 2, 1, {2, 3, 4}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Partition::ohpdm"]
}, Open  ]],

Cell[TextData[{
  "This shows valid overhang parameters in ",
  StyleBox["Partition", "MR"],
  "."
}], "Text",
  CellTags->"Partition::ohpdm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[{1, 2, 3, 4}, 2, 1, {2, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Partition::ohpdm"],

Cell[BoxData[
    \({{4, 1}, {1, 2}, {2, 3}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Partition::ohpdm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blvecmat", "ObjectNameWarningMessages",
  CellTags->"General::blvecmat"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blvecmat\"\>"}], \(\(:\)\(\ \)\), \(Argument\ `1`\ at\ \
position\ `2`\ is\ not\ a\ nonempty\ vector\ or\ \(\(matrix\)\(.\)\)\)}]], \
"Message",
  CellTags->"General::blvecmat"],

Cell["\<\
\[FilledSmallSquare] Generated by certain numerical linear algebra \
functions.\
\>", "Notes",
  CellTags->"General::blvecmat"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::scalar", "ObjectNameWarningMessages",
  CellTags->"General::scalar"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"scalar\"\>"}], \(\(:\)\(\ \)\), \(Argument\ `1`\ at\ \
position\ `2`\ is\ not\ a\ \(\(scalar\)\(.\)\)\)}]], "Message",
  CellTags->"General::scalar"],

Cell["\<\
\[FilledSmallSquare] Generated by certain numerical linear algebra \
functions.\
\>", "Notes",
  CellTags->"General::scalar"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blnotn", "ObjectNameWarningMessages",
  CellTags->"General::blnotn"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blnotn\"\>"}], \(\(:\)\(\ \)\), \(The\ value\ of\ the\ \
argument\ `1`\ in\ position\ `2`\ is\ not\ a\ \(\(number\)\(.\)\)\)}]], \
"Message",
  CellTags->"General::blnotn"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blnotn"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blncorr", "ObjectNameWarningMessages",
  CellTags->"General::blncorr"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blncorr\"\>"}], \(\(:\)\(\ \)\), \(The\ value\ of\ the\ \
argument\ `1`\ in\ position\ `2`\ is\ \(\(incorrect\)\(.\)\)\)}]], "Message",
  CellTags->"General::blncorr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blncorr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blwarg", "ObjectNameWarningMessages",
  CellTags->"General::blwarg"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blwarg\"\>"}], \(\(:\)\(\ \)\), \(The\ output\ argument\ \
`1`\ in\ position\ `2`\ is\ inconsistent\ with\ the\ input\ argument \
\(\((s)\)\(.\)\)\)}]], "Message",
  CellTags->"General::blwarg"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blwarg"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blndim1", "ObjectNameWarningMessages",
  CellTags->"General::blndim1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blndim1\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ in\ \
position\ `2`\ has\ incorrect\ dimension \(\((s)\)\(.\)\)\)}]], "Message",
  CellTags->"General::blndim1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blndim1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blndim2", "ObjectNameWarningMessages",
  CellTags->"General::blndim2"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blndim2\"\>"}], \(\(:\)\(\ \)\), \(The\ arguments\ `1`\ \
and\ `2`\ have\ incorrect\ \(\(dimensions\)\(.\)\)\)}]], "Message",
  CellTags->"General::blndim2"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blndim2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blrank", "ObjectNameWarningMessages",
  CellTags->"General::blrank"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blrank\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ \
evaluates\ to\ rank\ `2` . \ 
          Rank\ `3`\ is\ \(\(expected\)\(.\)\)\)}]], "Message",
  CellTags->"General::blrank"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blrank"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blrank1", "ObjectNameWarningMessages",
  CellTags->"General::blrank1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blrank1\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ \
evaluates\ to\ rank\ `2` . \ 
          Rank\ `3`\ or\ `4`\ is\ \(\(expected\)\(.\)\)\)}]], "Message",
  CellTags->"General::blrank1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blrank1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blnotsym", "ObjectNameWarningMessages",
  CellTags->"General::blnotsym"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blnotsym\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ at\
\ position\ `2`\ should\ not\ contain\ any\ symbol\ for\ which\ no\ numerical\
\ value\ is\ \(\(defined\)\(.\)\)\)}]], "Message",
  CellTags->"General::blnotsym"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blnotsym"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blscas", "ObjectNameWarningMessages",
  CellTags->"General::blscas"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blscas\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ \
should\ be\ a\ symbol\ which\ has\ a\ scalar\ immediate\ \
\(\(value\)\(.\)\)\)}]], "Message",
  CellTags->"General::blscas"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blscas"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::bldim", "ObjectNameWarningMessages",
  CellTags->"General::bldim"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bldim\"\>"}], \(\(:\)\(\ \)\), \(The\ arguments\ `1`\ and\ \
`2`\ in\ `3`\ do\ not\ have\ compatible\ \(\(dimensions\)\(.\)\)\)}]], \
"Message",
  CellTags->"General::bldim"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::bldim"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::bldim1", "ObjectNameWarningMessages",
  CellTags->"General::bldim1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bldim1\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ \
should\ be\ a\ matrix\ of\ dimensions\ `2` - 
        by - \(\(`3`\)\(.\)\)\)}]], "Message",
  CellTags->"General::bldim1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::bldim1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blvec", "ObjectNameWarningMessages",
  CellTags->"General::blvec"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blvec\"\>"}], \(\(:\)\(\ \)\), \(Argument\ `1`\ at\ \
position\ `2`\ is\ not\ a\ nonempty\ \(\(vector\)\(.\)\)\)}]], "Message",
  CellTags->"General::blvec"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blvec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blnotsq", "ObjectNameWarningMessages",
  CellTags->"General::blnotsq"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blnotsq\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ \
does\ not\ have\ the\ first\ dimension\ at\ least\ as\ large\ as\ the\ second\
\ \(\(dimension\)\(.\)\)\)}]], "Message",
  CellTags->"General::blnotsq"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blnotsq"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blnsetst", "ObjectNameWarningMessages",
  CellTags->"General::blnsetst"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blnsetst\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ at\
\ position\ `2`\ is\ not\ a\ string\ starting\ with\ one\ of\ the\ letters\ \
from\ the\ \(set : \ \(\(`3`\)\(.\)\)\)\)}]], "Message",
  CellTags->"General::blnsetst"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blnsetst"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blnulst", "ObjectNameWarningMessages",
  CellTags->"General::blnulst"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blnulst\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ at\ \
position\ `2`\ must\ be\ a\ non - empty\ \(\(string\)\(.\)\)\)}]], "Message",
  CellTags->"General::blnulst"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blnulst"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blreal", "ObjectNameWarningMessages",
  CellTags->"General::blreal"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blreal\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ \
cannot\ be\ of\ complex\ \(\(type\)\(.\)\)\)}]], "Message",
  CellTags->"General::blreal"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blreal"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blnegn", "ObjectNameWarningMessages",
  CellTags->"General::blnegn"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blnegn\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ \
should\ be\ non - \(\(negative\)\(.\)\)\)}]], "Message",
  CellTags->"General::blnegn"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blnegn"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blnmpre", "ObjectNameWarningMessages",
  CellTags->"General::blnmpre"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blnmpre\"\>"}], \(\(:\)\(\ \)\), \(Argument\ in\ `1`\ is\ \
not\ a\ positive\ real\ number\ or\ MachinePrecision\ \
\(\(symbol\)\(.\)\)\)}]], "Message",
  CellTags->"General::blnmpre"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blnmpre"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::spsder", "ObjectNameWarningMessages",
  CellTags->"General::spsder"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"spsder\"\>"}], \(\(:\)\(\ \)\), \(The\ sparsity\ pattern\ \
must\ be\ explicitly\ given\ for\ the\ supplied\ derivative\ value\ function, \
\ \(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->"General::spsder"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::spsder"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sdsh", "ObjectNameWarningMessages",
  CellTags->"General::sdsh"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sdsh\"\>"}], \(\(:\)\(\ \)\), \(The\ sparsity\ pattern\ \
`1`\ is\ inconsistent\ with\ the\ dimensions, \ `2`, \ 
      of\ the\ \(\(derivative\)\(.\)\)\)}]], "Message",
  CellTags->"General::sdsh"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::sdsh"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Partition::pttl", "ObjectNameWarningMessages",
  CellTags->"Partition::pttl"],

Cell[BoxData[
    RowBox[{\(Partition::"pttl"\), \(\(:\)\(\ \)\), \(\(Partition\)\(\ \
\)\(arguments\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(and\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(must\ be\ the\ same\ length\ \(\((since\ both\ are\ \
lists)\)\(.\)\)\)\)}]], "Message",
  CellTags->"Partition::pttl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second and third arguments in ",
  StyleBox["Partition", "MR"],
  " are lists that do not have the same length.\n\[FilledSmallSquare] The \
second argument in ",
  StyleBox["Partition", "MR"],
  " specifies the partitioning in each dimension, and the third argument \
gives the offset in the corresponding dimensions."
}], "Notes",
  CellTags->"Partition::pttl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Partition::pttl"],

Cell[TextData[{
  "This input generates an error because the second and third arguments in ",
  StyleBox["Partition", "MR"],
  " do not have the same length."
}], "Text",
  CellTags->"Partition::pttl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}}, {1, 1}, {2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Partition::pttl"],

Cell[BoxData[
    \(Partition::"pttl" \(\(:\)\(\ \)\) 
      "Partition arguments \!\({1, 1}\) and \!\({2}\) must be the same length \
(since both are lists)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Partition::pttl"],

Cell[BoxData[
    \(Partition[{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}}, {1, 1}, {2}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Partition::pttl"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of the second and third arguments in ",
  StyleBox["Partition", "MR"],
  "."
}], "Text",
  CellTags->"Partition::pttl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[{{1, 2, 3}, {4, 5, 6}, {7, 8, 9}}, {1, 1}, {2, 2}]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->"Partition::pttl"],

Cell[BoxData[
    \({{{{1}}, {{3}}}, {{{7}}, {{9}}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Partition::pttl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Drop::drop", "ObjectNameWarningMessages",
  CellTags->"Drop::drop"],

Cell[BoxData[
    RowBox[{\(Drop::"drop"\), \(\(:\)\(\ \)\), "Cannot", " ", "drop", " ", 
      "positions", " ", 
      StyleBox["n1",
        "TI"], " ", "through", " ", 
      StyleBox["n2",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Drop::drop"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Drop", "MR"],
  " specifies positions that are not available in the indicated expression."
}], "Notes",
  CellTags->"Drop::drop"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Drop::drop"],

Cell[TextData[{
  "An error occurs in this example because the position indicated in the \
second argument of ",
  StyleBox["Drop", "MR"],
  " does not exist in the first argument."
}], "Text",
  CellTags->"Drop::drop"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[{1, 2, 3}, {4}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Drop::drop"],

Cell[BoxData[
    \(Drop::"drop" \(\(:\)\(\ \)\) 
      "Cannot drop positions \!\(4\) through \!\(4\) in \!\({1, 2, 3}\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Drop::drop"],

Cell[BoxData[
    \(Drop[{1, 2, 3}, {4}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Drop::drop"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Drop", "MR"],
  "."
}], "Text",
  CellTags->"Drop::drop"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Drop[{1, 2, 3}, {2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Drop::drop"],

Cell[BoxData[
    \({1, 3}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Drop::drop"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["First::first", "ObjectNameWarningMessages",
  CellTags->"First::first"],

Cell[BoxData[
    RowBox[{\(First::"first"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(has\ a\ length\ of\ zero\ and\ no\ first\ \
\(\(element\)\(.\)\)\)\)}]], "Message",
  CellTags->"First::first"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["First", "MR"],
  " has no first element."
}], "Notes",
  CellTags->"First::first"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"First::first"],

Cell["\<\
An error occurs in this example because the argument evaluates to \
an expression that has a length of zero.\
\>", "Text",
  CellTags->"First::first"],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[{} + {}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"First::first"],

Cell[BoxData[
    \(First::"first" \(\(:\)\(\ \)\) 
      "\!\({}\) has a length of zero and no first element."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"First::first"],

Cell[BoxData[
    \(First[{}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"First::first"]
}, Open  ]],

Cell["\<\
This shows one way to control the evaluation that causes the \
argument to evaluate to another expression.\
\>", "Text",
  CellTags->"First::first"],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[Unevaluated[{} + {}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"First::first"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"First::first"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FlattenAt::flatp", "ObjectNameWarningMessages",
  CellTags->"FlattenAt::flatp"],

Cell[BoxData[
    RowBox[{\(FlattenAt::"flatp"\), \(\(:\)\(\ \)\), "Expression", " ", 
      StyleBox["e",
        "TI"], " ", "at", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "of", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(has\ no\ parts\ and\ cannot\ be\ \
\(\(flattened\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"FlattenAt::flatp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the expression specified in ",
  StyleBox["FlattenAt", "MR"],
  " is an expression such as a symbol, number, or string that does not have \
any parts."
}], "Notes",
  CellTags->"FlattenAt::flatp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FlattenAt::flatp"],

Cell["\<\
An error occurs in this example because the indicated expression is \
an expression that does not have any parts.\
\>", "Text",
  CellTags->"FlattenAt::flatp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FlattenAt[{101, 102, 103}, 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FlattenAt::flatp"],

Cell[BoxData[
    \(FlattenAt::"flatp" \(\(:\)\(\ \)\) 
      "Expression \!\(102\) at position \!\({2}\) of \!\({101, 102, 103}\) \
has no parts and cannot be flattened."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FlattenAt::flatp"],

Cell[BoxData[
    \(FlattenAt[{101, 102, 103}, 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FlattenAt::flatp"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["FlattenAt", "MR"],
  "."
}], "Text",
  CellTags->"FlattenAt::flatp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FlattenAt[{{101}, {102}, {103}}, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FlattenAt::flatp"],

Cell[BoxData[
    \({{101}, 102, {103}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FlattenAt::flatp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Insert::ins", "ObjectNameWarningMessages",
  CellTags->"Insert::ins"],

Cell[BoxData[
    \(Insert::"ins" \(\(:\)\(\ \)\) 
      "Cannot insert at position `1` in `2`"\)], "Message",
  CellLabel->"From In[31]:=",
  CellTags->"Insert::ins"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when third argument in ",
  StyleBox["Insert", "MR"],
  " is not a valid position specification or list of position specifications.\
\n\[FilledSmallSquare] A position specification is an integer or a list of \
integers."
}], "Notes",
  CellTags->"Insert::ins"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Insert::ins"],

Cell["\<\
An error occurs in this example because the arguments are out of \
order.\
\>", "Text",
  CellTags->"Insert::ins"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Insert[99, 6, {5, 3, 3, 1, 7}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Insert::ins"],

Cell[BoxData[
    \(Insert::"ins" \(\(:\)\(\ \)\) 
      "Cannot insert at position \!\({5, 3, 3, 1, 7}\) in \!\(99\)"\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Insert::ins"],

Cell[BoxData[
    \(Insert[99, 6, {5, 3, 3, 1, 7}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Insert::ins"]
}, Open  ]],

Cell[TextData[{
  "These examples show valid arguments in ",
  StyleBox["Insert", "MR"],
  "."
}], "Text",
  CellTags->"Insert::ins"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Insert[{5, 3, 3, 1, 7}, 99, 6]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Insert::ins"],

Cell[BoxData[
    \({5, 3, 3, 1, 7, 99}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Insert::ins"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Insert[{5, 3, 3, 1, 7}, 99, \(-1\)]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Insert::ins"],

Cell[BoxData[
    \({5, 3, 3, 1, 7, 99}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Insert::ins"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Last::nolast", "ObjectNameWarningMessages",
  CellTags->"Last::nolast"],

Cell[BoxData[
    RowBox[{\(Last::"nolast"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(has\ a\ length\ of\ zero\ and\ no\ last\ \(\(element\
\)\(.\)\)\)\)}]], "Message",
  CellTags->"Last::nolast"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression is a \
normal expression with no elements.\
\>", "Notes",
  CellTags->"Last::nolast"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Last::nolast"],

Cell["\<\
An error occurs in this example because the empty list does not \
have a last element.\
\>", "Text",
  CellTags->"Last::nolast"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Last[{}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Last::nolast"],

Cell[BoxData[
    \(Last::"nolast" \(\(:\)\(\ \)\) 
      "\!\({}\) has a length of zero and no last element."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Last::nolast"],

Cell[BoxData[
    \(Last[{}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Last::nolast"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Last", "MR"],
  "."
}], "Text",
  CellTags->"Last::nolast"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Last[{5, 1, 4, 4, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Last::nolast"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Last::nolast"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Partition::pdep", "ObjectNameWarningMessages",
  CellTags->"Partition::pdep"],

Cell[BoxData[
    RowBox[{\(Partition::"pdep"\), \(\(:\)\(\ \)\), "Depth", " ", 
      StyleBox["d",
        "TI"], " ", "requested", " ", "in", " ", "object", " ", "with", " ", 
      "dimensions", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Partition::pdep"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second and third arguments in ",
  StyleBox["Partition", "MR"],
  " correspond to depths that do not exist in the expression that appears in \
the first argument."
}], "Notes",
  CellTags->"Partition::pdep"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Partition::pdep"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["Partition", "MR"],
  " does not have elements at the levels specified in the second and third \
arguments."
}], "Text",
  CellTags->"Partition::pdep"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[{1, 2, 3, 4}, {2, 2}, {1, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Partition::pdep"],

Cell[BoxData[
    \(Partition::"pdep" \(\(:\)\(\ \)\) 
      "Depth \!\(2\) requested in object with dimensions \!\({4}\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Partition::pdep"],

Cell[BoxData[
    \(Partition[{1, 2, 3, 4}, {2, 2}, {1, 1}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Partition::pdep"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Partition", "MR"],
  "."
}], "Text",
  CellTags->"Partition::pdep"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Partition[{{11, 12, 13}, {21, 22, 23}, {31, 32, 33}}, {2, 2}, {1, 
        1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Partition::pdep"],

Cell[BoxData[
    \({{{{11, 12}, {21, 22}}, {{12, 13}, {22, 23}}}, {{{21, 22}, {31, 
            32}}, {{22, 23}, {32, 33}}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Partition::pdep"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
RotateLeft::rotate
RotateRight::rotate\
\>", "ObjectNameWarningMessages",
  CellTags->{"RotateLeft::rotate", "RotateRight::rotate"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"rotate\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "rotate", " ", "atomic", " ", "expression", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"RotateLeft::rotate", "RotateRight::rotate"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["RotateLeft", "MR"],
  " or ",
  StyleBox["RotateRight", "MR"],
  " is a symbol, a number, or a string."
}], "Notes",
  CellTags->{"RotateLeft::rotate", "RotateRight::rotate"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
RotateLeft::rspec
RotateRight::rspec\
\>", "ObjectNameWarningMessages",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"rspec\"\>"}], \(\(:\)\(\ \)\), "Rotation", " ", 
        "specification", " ", 
        StyleBox["expr",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "machine"}], 
      "-", \(size\ integer\ or\ list\ of\ machine\), 
      "-", \(size\ \(\(integers\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["RotateLeft", "MR"],
  " or ",
  StyleBox["RotateRight", "MR"],
  " does not have the expected form."
}], "Notes",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],

Cell["\<\
An error occurs in this example because the second argument is a \
symbol.\
\>", "Text",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(RotateRight[{1, 2, 3, 4, 5, 6, 7}, RotateRight]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],

Cell[BoxData[
    \(RotateRight::"rspec" \(\(:\)\(\ \)\) 
      "Rotation specification \!\({RotateRight}\) should be a machine-size \
integer or list of machine-size integers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],

Cell[BoxData[
    \(RotateRight[{1, 2, 3, 4, 5, 6, 7}, RotateRight]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid rotation specification in ",
  StyleBox["RotateRight", "MR"],
  "."
}], "Text",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(RotateRight[{1, 2, 3, 4, 5, 6, 7}, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],

Cell[BoxData[
    \({6, 7, 1, 2, 3, 4, 5}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Take::take
StringTake::take
Part::take
Set::take
Internal`BagPart::take\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"take\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "take", " ", "positions", " ", 
      StyleBox["n1",
        "TI"], " ", "through", " ", 
      StyleBox["n2",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell["\<\
\[FilledSmallSquare] Generated when the positions specified in the \
second argument of the indicated function are not present in the expression \
given in the first argument.\
\>", "Notes",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell["\<\
An error occurs in this example because the specified positions \
extend beyond the end of the argument expression.\
\>", "Text",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[Range[10], {7, 99}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[BoxData[
    \(Take::"take" \(\(:\)\(\ \)\) 
      "Cannot take positions \!\(7\) through \!\(99\) in \!\({1, 2, 3, 4, 5, \
6, 7, 8, 9, 10}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take", 
    "Take::take"}],

Cell[BoxData[
    \(Take[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, {7, 99}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take", 
    "Take::take"}]
}, Open  ]],

Cell["\<\
This shows valid position specifications for this expression.\
\>", \
"Text",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Take[Range[10], {7, \(-1\)}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[BoxData[
    \({7, 8, 9, 10}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take", 
    "Take::take"}]
}, Open  ]],

Cell["\<\
An error occurs in this example because the specified positions \
extend beyond the end of the argument string.\
\>", "Text",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringTake["\<123456789\>", {5, 10}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[BoxData[
    \(StringTake::"take" \(\(:\)\(\ \)\) 
      "Cannot take positions \!\(5\) through \!\(10\) in \
\!\(\"123456789\"\)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{
  "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take", 
    "Take::take"}],

Cell[BoxData[
    \(StringTake["123456789", {5, 10}]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{
  "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take", 
    "Take::take"}]
}, Open  ]],

Cell["This shows valid position specifications for this string.", "Text",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringTake["\<123456789\>", {5, \(-1\)}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[BoxData[
    \("56789"\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{
  "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take", 
    "Take::take"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Thread::tdlen", "ObjectNameWarningMessages",
  CellTags->"Thread::tdlen"],

Cell[BoxData[
    RowBox[{\(Thread::"tdlen"\), \(\(:\)\(\ \)\), \(\(Objects\)\(\ \)\(of\)\(\
\ \)\(unequal\)\(\ \)\(length\)\(\ \)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(cannot\ be\ \(\(combined\)\(.\)\)\)\)}]], "Message",
  CellTags->"Thread::tdlen"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a threading operation is used with \
expressions that do not have the same length.\n\[FilledSmallSquare] \
Operations with the ",
  StyleBox["Listable", "MR"],
  " attribute, such as ",
  StyleBox["Plus", "MR"],
  " and ",
  StyleBox["Times", "MR"],
  ", automatically thread over arguments that are lists."
}], "Notes",
  CellTags->"Thread::tdlen"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Thread::tdlen"],

Cell["\<\
An error occurs in this example because the argument expressions in \
the test function do not have the same length.\
\>", "Text",
  CellTags->"Thread::tdlen"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Thread[test[{1, 2}, {7, 8, 9}]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Thread::tdlen"],

Cell[BoxData[
    \(Thread::"tdlen" \(\(:\)\(\ \)\) 
      "Objects of unequal length in \!\(test[\(\(\(\({1, 2}\)\), \(\({7, 8, \
9}\)\)\)\)]\) cannot be combined."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Thread::tdlen"],

Cell[BoxData[
    \(test[{1, 2}, {7, 8, 9}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Thread::tdlen"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["Thread", "MR"],
  "."
}], "Text",
  CellTags->"Thread::tdlen"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Thread[test[{1, 2, 3}, {7, 8, 9}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Thread::tdlen"],

Cell[BoxData[
    \({test[1, 7], test[2, 8], test[3, 9]}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Thread::tdlen"]
}, Open  ]],

Cell[TextData[{
  "This message can also be generated when functions with the ",
  StyleBox["Listable", "MR"],
  " attribute, such as ",
  StyleBox["Plus", "MR"],
  ", are used with list arguments that do not all have the same length."
}], "Text",
  CellTags->"Thread::tdlen"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Attributes[Plus]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Thread::tdlen"],

Cell[BoxData[
    \({Flat, Listable, NumericFunction, OneIdentity, Orderless, 
      Protected}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Thread::tdlen"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(10 + {1, 2} + {7, 8, 9}\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Thread::tdlen"],

Cell[BoxData[
    \(Thread::"tdlen" \(\(:\)\(\ \)\) 
      "Objects of unequal length in \!\(10 + \(\({1, 2}\)\) + \(\({7, 8, 9}\)\
\)\) cannot be combined."\)], "Message",
  CellLabel->"From In[4]:=",
  CellTags->"Thread::tdlen"],

Cell[BoxData[
    \(10 + {1, 2} + {7, 8, 9}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Thread::tdlen"]
}, Open  ]],

Cell["\<\
This example shows addition threaded over lists that have the same \
length.\
\>", "Text",
  CellTags->"Thread::tdlen"],

Cell[CellGroupData[{

Cell[BoxData[
    \(10 + {1, 2, 3} + {7, 8, 9}\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"Thread::tdlen"],

Cell[BoxData[
    \({18, 20, 22}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"Thread::tdlen"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Thread::tpos", "ObjectNameWarningMessages",
  CellTags->"Thread::tpos"],

Cell[BoxData[
    RowBox[{\(Thread::"tpos"\), \(\(:\)\(\ \)\), "Cannot", " ", "thread", " ",
       "over", " ", "positions", " ", 
      StyleBox["n1",
        "TI"], " ", "through", " ", 
      StyleBox["n2",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Thread::tpos"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the positions specified in the third \
argument of ",
  StyleBox["Thread", "MR"],
  " are not available in the expression in the first argument."
}], "Notes",
  CellTags->"Thread::tpos"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Thread::tpos"],

Cell[TextData[{
  "An error occurs in this example because the positions specified in the \
third argument of ",
  StyleBox["Thread", "MR"],
  " extend beyond the end of the expression in the first argument."
}], "Text",
  CellTags->"Thread::tpos"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Thread[test[{1, 2}, {3, 4}, {8, 9}], List, {2, 4}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Thread::tpos"],

Cell[BoxData[
    \(Thread::"tpos" \(\(:\)\(\ \)\) 
      "Cannot thread over positions \!\(2\) through \!\(4\) in \
\!\(test[\(\(\(\({1, 2}\)\), \(\({3, 4}\)\), \(\({8, 9}\)\)\)\)]\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Thread::tpos"],

Cell[BoxData[
    \(Thread[test[{1, 2}, {3, 4}, {8, 9}], List, {2, 4}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Thread::tpos"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid position specification in ",
  StyleBox["Thread", "MR"],
  "."
}], "Text",
  CellTags->"Thread::tpos"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Thread[test[{1, 2}, {3, 4}, {8, 9}], List, {2, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Thread::tpos"],

Cell[BoxData[
    \({test[{1, 2}, 3, 8], test[{1, 2}, 4, 9]}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Thread::tpos"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Union::smtst
Intersection::smtst
Complement::smtst\
\>", "ObjectNameWarningMessages",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"smtst\"\>"}], \(\(:\)\(\ \)\), "Application", 
        " ", "of", " ", "the", " ", "SameTest", " ", "yielded", " ", 
        StyleBox["expr",
          "TI"]}], ",", " ", 
      RowBox[{"which", " ", "evaluates", " ", "to", " ", 
        RowBox[{
          StyleBox["val",
            "TI"], ".", " ", "The"}], " ", "SameTest", " ", "must", " ", 
        "evaluate", " ", "to", " ", "True", " ", "or", " ", "False", " ", 
        "at", " ", "every", " ", "pair", " ", "of", 
        " ", \(\(elements\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the result of applying the value of \
the ",
  StyleBox["SameTest", "MR"],
  " option to a pair of elements is not ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  "."
}], "Notes",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],

Cell[TextData[{
  "A warning message is generated in this example because a required \
inequality with an empty list does not evaluate to ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  "."
}], "Text",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[{11, 3, 8, {}, 4, 7, 12}, 
      SameTest -> \((Abs[#1 - #2] < 2 &)\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],

Cell[BoxData[
    \(Union::"smtst" \(\(:\)\(\ \)\) 
      "Application of the SameTest yielded \!\(\(\((\(\(\(\(\(Abs[\(\(#1 - #2\
\)\)]\)\) < 2\)\) &\))\)\)[\(\(\(\({}\)\), 11\)\)]\), which evaluates to \!\(\
\(\({}\)\) < 2\). The SameTest must evaluate to True or False at every pair \
of elements."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],

Cell[BoxData[
    \(Union::"smtst" \(\(:\)\(\ \)\) 
      "Application of the SameTest yielded \!\(\(\((\(\(\(\(\(Abs[\(\(#1 - #2\
\)\)]\)\) < 2\)\) &\))\)\)[\(\(\(\({}\)\), 7\)\)]\), which evaluates to \
\!\(\(\({}\)\) < 2\). The SameTest must evaluate to True or False at every \
pair of elements."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],

Cell[BoxData[
    \(Union::"smtst" \(\(:\)\(\ \)\) 
      "Application of the SameTest yielded \!\(\(\((\(\(\(\(\(Abs[\(\(#1 - #2\
\)\)]\)\) < 2\)\) &\))\)\)[\(\(\(\({}\)\), 3\)\)]\), which evaluates to \
\!\(\(\({}\)\) < 2\). The SameTest must evaluate to True or False at every \
pair of elements."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Union :: \"smtst\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],

Cell[BoxData[
    \({3, 7, 11, {}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}]
}, Open  ]],

Cell[TextData[{
  "This value for the ",
  StyleBox["SameTest", "MR"],
  " option is adequate if all of the elements are integers."
}], "Text",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[{11, 3, 8, 2, 4, 7, 12}, 
      SameTest -> \((Abs[#1 - #2] < 2 &)\)]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],

Cell[BoxData[
    \({2, 4, 7, 11}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::partd", "ObjectNameWarningMessages",
  CellTags->"General::partd"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"partd\"\>"}], \(\(:\)\(\ \)\), "Part", " ", 
      "specification", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "longer", " ", "than", " ", "depth", " ", "of",
       " ", \(\(object\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::partd"],

Cell["\<\
\[FilledSmallSquare] Generated when an expression does not have an \
element in the specified position.\
\>", "Notes",
  CellTags->"General::partd"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::partd"],

Cell["\<\
An error occurs in this example because the requested part does not \
exist in this expression.\
\>", "Text",
  CellTags->"General::partd"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1.2, 3.4, 5.6, 7.8}[\([2, 2]\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::partd"],

Cell[BoxData[
    \(Part::"partd" \(\(:\)\(\ \)\) 
      "Part specification \!\(\(\({1.2`, 3.4`, 5.6`, 7.8`}\)\) \
\[LeftDoubleBracket] \(\(2, 2\)\) \[RightDoubleBracket]\) is longer than \
depth of object."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::partd"],

Cell[BoxData[
    \({1.2`, 3.4`, 5.6`, 7.8`}\[LeftDoubleBracket]2, 
      2\[RightDoubleBracket]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::partd"]
}, Open  ]],

Cell["This shows a valid part specification.", "Text",
  CellTags->"General::partd"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1.2, 3.4}, {5.6, 7.8}}[\([2, 2]\)]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::partd"],

Cell[BoxData[
    \(7.8`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::partd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::partw", "ObjectNameWarningMessages",
  CellTags->"General::partw"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"partw\"\>"}], \(\(:\)\(\ \)\), "Part", " ", 
      StyleBox["spec",
        "TI"], " ", "of", " ", 
      StyleBox["expr",
        "TI"], " ", "does", " ", "not", " ", \(\(exist\)\(.\)\)}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::partw"],

Cell["\<\
\[FilledSmallSquare] Generated when a part specification does not \
fall within the elements of the indicated expression.\
\>", "Notes",
  CellTags->"General::partw"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::partw"],

Cell["\<\
An error occurs in this example because the specified part falls \
beyond the end of the expression in the first argument.\
\>", "Text",
  CellTags->"General::partw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReplacePart[{5, 1, 6, 9}, 0, {6}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::partw"],

Cell[BoxData[
    \(ReplacePart::"partw" \(\(:\)\(\ \)\) 
      "Part \!\({6}\) of \!\({5, 1, 6, 9}\) does not exist."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::partw"],

Cell[BoxData[
    \(ReplacePart[{5, 1, 6, 9}, 0, {6}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::partw"]
}, Open  ]],

Cell["This shows a valid part specification for this expression.", "Text",
  CellTags->"General::partw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ReplacePart[{5, 1, 6, 9}, 0, {3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::partw"],

Cell[BoxData[
    \({5, 1, 0, 9}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::partw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::pspec", "ObjectNameWarningMessages",
  CellTags->"General::pspec"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"pspec\"\>"}], \(\(:\)\(\ \)\), "Part", " ", 
      "specification", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "neither", " ", "an", " ", "integer", " ", 
      "nor", " ", "a", " ", "list", " ", "of", 
      " ", \(\(integers\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::pspec"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated part \
specification does not have the expected form.\
\>", "Notes",
  CellTags->"General::pspec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::pspec"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Part", "MR"],
  " is not an integer or a list of integers."
}], "Text",
  CellTags->"General::pspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[{{11, 22}, {33, 44}}, {{2, 2}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::pspec"],

Cell[BoxData[
    \(Part::"pspec" \(\(:\)\(\ \)\) 
      "Part specification \!\({\({2, 2}\)}\) is neither an integer nor a list \
of integers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::pspec"],

Cell[BoxData[
    \({{11, 22}, {33, 44}}\[LeftDoubleBracket]{{2, 
          2}}\[RightDoubleBracket]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::pspec"]
}, Open  ]],

Cell["These examples show valid part specifications.", "Text",
  CellTags->"General::pspec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[{{11, 22}, {33, 44}}, 2, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::pspec"],

Cell[BoxData[
    \(44\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::pspec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{m = {{11, 22}, {33, 44}}}, m[\([2, 2]\)]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::pspec"],

Cell[BoxData[
    \(44\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::pspec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{m = {{11, 22}, {33, 44}}}, m[\([{1, 2}, 2]\)]]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::pspec"],

Cell[BoxData[
    \({22, 44}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::pspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Array::plen
StringReplacePart::plen\
\>", "ObjectNameWarningMessages",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[BoxData[
    \(Array::"plen" \(\(:\)\(\ \)\) 
      "`1` and `2` should have the same length."\)], "Message",
  CellLabel->"From In[31]:=",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the length of the second argument in \
",
  StyleBox["Array", "MR"],
  " is not the same as the length of the third argument.\n\
\[FilledSmallSquare] Generated when ",
  StyleBox["StringReplacePart", "MR"],
  " is used for multiple replacements and the number of replacement strings \
is not the same as the number of position specifications.\n\
\[FilledSmallSquare] The second argument in ",
  StyleBox["StringReplacePart", "MR"],
  " gives the replacement strings and the third argument gives the position \
specifications."
}], "Notes",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell["\<\
An error occurs in this example because the second and third \
arguments do not have the same length.\
\>", "Text",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[List, {2}, {2, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[BoxData[
    \(Array::"plen" \(\(:\)\(\ \)\) 
      "\!\({2}\) and \!\({2, 3}\) should have the same length."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[BoxData[
    \(Array[List, {2}, {2, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Array::plen", "StringReplacePart::plen"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Array", "MR"],
  "."
}], "Text",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Array[List, {2, 2}, {2, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[BoxData[
    \({{{2, 3}, {2, 4}}, {{3, 3}, {3, 4}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Array::plen", "StringReplacePart::plen"}]
}, Open  ]],

Cell["\<\
An error occurs in this example because the length of the second \
argument is not the same as the length of the third argument.\
\>", "Text",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReplacePart["\<123456789\>", {"\<x\>", "\<y\>", "\<z\>"}, {{1, 
          2}, {4, 5}}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[BoxData[
    \(StringReplacePart::"plen" \(\(:\)\(\ \)\) 
      "\!\({\"x\", \"y\", \"z\"}\) and \!\({\(\({1, 2}\)\), \(\({4, 5}\)\)}\) \
should have the same length."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[BoxData[
    \(StringReplacePart[
      "123456789", {"x", "y", "z"}, {{1, 2}, {4, 5}}]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"Array::plen", "StringReplacePart::plen"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments for multiple string replacements using ",
  StyleBox["StringReplacePart", "MR"],
  "."
}], "Text",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReplacePart["\<123456789\>", {"\<x\>", "\<y\>", "\<z\>"}, {{1, 
          2}, {4, 5}, {7, 7}}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[BoxData[
    \("x3y6z89"\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"Array::plen", "StringReplacePart::plen"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
PadLeft::level
PadRight::level\
\>", "ObjectNameWarningMessages",
  CellTags->{"PadLeft::level", "PadRight::level"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"level\"\>"}], \(\(:\)\(\ \)\), "\<\"The padding \
specification `1` involves `2` levels; the list `3` has only `4` \
level.\"\>"}]], "Message",
  CellLabel->"From In[32]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"PadLeft::level", "PadRight::level"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the length of the second argument in \
",
  StyleBox["PadLeft", "MR"],
  " or ",
  StyleBox["PadRight", "MR"],
  " is greater than the number of dimensions of the expression in the first \
argument."
}], "Notes",
  CellTags->{"PadLeft::level", "PadRight::level"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"PadLeft::level", "PadRight::level"}],

Cell["\<\
An error occurs in this example because the second argument refers \
to two dimensions and the first argument has only one dimension.\
\>", "Text",\

  CellTags->{"PadLeft::level", "PadRight::level"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(PadRight[{1, 2, 3, 4}, {3, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"PadLeft::level", "PadRight::level"}],

Cell[BoxData[
    \(PadRight::"level" \(\(:\)\(\ \)\) 
      "The padding specification \!\({3, 3}\) involves \!\(2\) levels; the \
list \!\({1, 2, 3, 4}\) has only \!\(1\) level."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"PadLeft::level", "PadRight::level"}],

Cell[BoxData[
    \(PadRight[{1, 2, 3, 4}, {3, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"PadLeft::level", "PadRight::level"}]
}, Open  ]],

Cell[TextData[{
  "This shows a use of ",
  StyleBox["PadRight", "MR"],
  " to pad the rows and columns of a matrix."
}], "Text",
  CellTags->{"PadLeft::level", "PadRight::level"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(PadRight[{{1, 2}, {3, 4}}, {3, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"PadLeft::level", "PadRight::level"}],

Cell[BoxData[
    \({{1, 2, 0}, {3, 4, 0}, {0, 0, 0}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"PadLeft::level", "PadRight::level"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
PadLeft::margin
PadRight::margin\
\>", "ObjectNameWarningMessages",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"margin\"\>"}], \(\(:\)\(\ \)\), "\<\"The list of margins \
`1` given in `2` must be of the same length (`3`) as the list of padded \
dimensions `4`\"\>"}]], "Message",
  CellLabel->"From In[32]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"PadLeft::margin", "PadRight::margin"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the length of the second argument in \
",
  StyleBox["PadLeft", "MR"],
  " or ",
  StyleBox["PadRight", "MR"],
  " is not the same as the length of the fourth argument."
}], "Notes",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],

Cell["\<\
An error occurs in this example because the length of the second \
argument is not the same as the length of the fourth argument.\
\>", "Text",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(PadLeft[{1, 2, 3}, 10, 0, {2, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],

Cell[BoxData[
    \(PadLeft::"margin" \(\(:\)\(\ \)\) 
      "The list of margins \!\({2, 2}\) given in \!\(PadLeft[\(\(\(\({1, 2, \
3}\)\), 10, 0, \(\({2, 2}\)\)\)\)]\) must be of the same length (\!\(1\)) as \
the list of padded dimensions \!\({10}\)"\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],

Cell[BoxData[
    \(PadLeft[{1, 2, 3}, 10, 0, {2, 2}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"PadLeft::margin", "PadRight::margin"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["PadLeft", "MR"],
  " with four arguments."
}], "Text",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(PadLeft[{1, 2, 3}, 10, 0, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],

Cell[BoxData[
    \({0, 0, 0, 0, 0, 1, 2, 3, 0, 0}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"PadLeft::margin", "PadRight::margin"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sow::encl", "ObjectNameWarningMessages",
  CellTags->"Sow::encl"],

Cell[BoxData[
    \(Sow::"encl" \(\(:\)\(\ \)\) \(Expression\ `1`\ has\ no\ enclosing\ \
\(\(Reap\)\(.\)\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Sow::encl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when Sow is used outside of ",
  StyleBox["Reap", "MR"],
  ", or if ",
  StyleBox["Sow", "MR"],
  " and ",
  StyleBox["Reap", "MR"],
  " are used with with different tags.\n\[FilledSmallSquare] This message may \
be off by default."
}], "Notes",
  CellTags->"Sow::encl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Sow::encl"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Sow", "MR"],
  " is used outside of ",
  StyleBox["Reap", "MR"],
  "."
}], "Text",
  CellTags->"Sow::encl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Sow[k^2], {k, 5}]; Reap[All]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Sow::encl"],

Cell[BoxData[
    \(Sow::"encl" \(\(:\)\(\ \)\) 
      "Expression \!\(Sow[1]\) has no enclosing Reap."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Sow::encl"],

Cell[BoxData[
    \(Sow::"encl" \(\(:\)\(\ \)\) 
      "Expression \!\(Sow[4]\) has no enclosing Reap."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Sow::encl"],

Cell[BoxData[
    \(Sow::"encl" \(\(:\)\(\ \)\) 
      "Expression \!\(Sow[9]\) has no enclosing Reap."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Sow::encl"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Sow :: \"encl\"\) will be suppressed during this \
calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Sow::encl"],

Cell[BoxData[
    \({All, {}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Sow::encl"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Sow", "MR"],
  " and ",
  StyleBox["Reap", "MR"],
  "."
}], "Text",
  CellTags->"Sow::encl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reap[Do[Sow[k^2], {k, 5}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Sow::encl"],

Cell[BoxData[
    \({Null, {{1, 4, 9, 16, 25}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Sow::encl"]
}, Open  ]],

Cell[TextData[{
  "This message can also be generated if ",
  StyleBox["Sow", "MR"],
  " and ",
  StyleBox["Reap", "MR"],
  " are used with with different (or missing) tags."
}], "Text",
  CellTags->"Sow::encl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reap[Do[Sow[k^2], {k, 5}], "\<tag\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Sow::encl"],

Cell[BoxData[
    \(Sow::"encl" \(\(:\)\(\ \)\) 
      "Expression \!\(Sow[1]\) has no enclosing Reap."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"Sow::encl"],

Cell[BoxData[
    \(Sow::"encl" \(\(:\)\(\ \)\) 
      "Expression \!\(Sow[4]\) has no enclosing Reap."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"Sow::encl"],

Cell[BoxData[
    \(Sow::"encl" \(\(:\)\(\ \)\) 
      "Expression \!\(Sow[9]\) has no enclosing Reap."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"Sow::encl"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Sow :: \"encl\"\) will be suppressed during this \
calculation."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"Sow::encl"],

Cell[BoxData[
    \({Null, {}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Sow::encl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sow::enclt", "ObjectNameWarningMessages",
  CellTags->"Sow::enclt"],

Cell[BoxData[
    \(Sow::"enclt" \(\(:\)\(\ \)\) \(Tag\ `1`\ in\ `2`\ has\ no\ matching\ \(\
\(Reap\)\(.\)\)\)\)], "Message",
  CellTags->"Sow::enclt"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Sow", "MR"],
  " is used with a tag that is not the same as the tag of the enclosing ",
  StyleBox["Reap", "MR"],
  ".\n\[FilledSmallSquare] This message may be off by default."
}], "Notes",
  CellTags->"Sow::enclt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Sow::enclt"],

Cell[TextData[{
  "A message is generated in this example because the tag used in ",
  StyleBox["Sow", "MR"],
  " is not the same as the tag used in the enclosing ",
  StyleBox["Reap", "MR"],
  "."
}], "Text",
  CellTags->"Sow::enclt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reap[Do[Sow[k^2, "\<tag1\>"], {k, 5}], "\<tag2\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Sow::enclt"],

Cell[BoxData[
    \(Sow::"enclt" \(\(:\)\(\ \)\) 
      "Tag \!\(\"tag1\"\) in \!\(Sow[\(\(1, \"tag1\"\)\)]\) has no matching \
Reap."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Sow::enclt"],

Cell[BoxData[
    \(Sow::"enclt" \(\(:\)\(\ \)\) 
      "Tag \!\(\"tag1\"\) in \!\(Sow[\(\(4, \"tag1\"\)\)]\) has no matching \
Reap."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Sow::enclt"],

Cell[BoxData[
    \(Sow::"enclt" \(\(:\)\(\ \)\) 
      "Tag \!\(\"tag1\"\) in \!\(Sow[\(\(9, \"tag1\"\)\)]\) has no matching \
Reap."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Sow::enclt"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Sow :: \"enclt\"\) will be suppressed during \
this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Sow::enclt"],

Cell[BoxData[
    \({Null, {}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Sow::enclt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::dim", "ObjectNameWarningMessages",
  CellTags->"General::dim"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"dim\"\>"}], \(\(:\)\(\ \)\), \(Dimension\ `1`\ is\ not\ a\ \
positive\ integer\ giving\ a\ dimension\ to\ select\ for\ data\ associated\ \
with\ `2`\ \(\(dimensions\)\(.\)\)\)}]], "Message",
  CellTags->"General::dim"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::dim"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nsdims", "ObjectNameWarningMessages",
  CellTags->"General::nsdims"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nsdims\"\>"}], \(\(:\)\(\ \)\), \(Matrices\ `1`\ and\ `2`\ \
must\ have\ the\ same\ number\ of\ rows\ and\ \(\(columns\)\(.\)\)\)}]], \
"Message",
  CellTags->"General::nsdims"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nsdims"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::rect", "ObjectNameWarningMessages",
  CellTags->"General::rect"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"rect\"\>"}], \(\(:\)\(\ \)\), "\<\"Non-rectangular array \
encountered.\"\>"}]], "Message",
  CellLabel->"From In[16]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::rect"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::rect"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::rectn", "ObjectNameWarningMessages",
  CellTags->"General::rectn"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"rectn\"\>"}], \(\(:\)\(\ \)\), "\<\"Rectangular array of \
numerical values is expected.\"\>"}]], "Message",
  CellLabel->"From In[16]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::rectn"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::rectn"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::rectt", "ObjectNameWarningMessages",
  CellTags->"General::rectt"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"rectt\"\>"}], \(\(:\)\(\ \)\), "\<\"Rectangular array \
expected at position `2` in `1`.\"\>"}]], "Message",
  CellLabel->"From In[16]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::rectt"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::rectt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::gfargs", "ObjectNameWarningMessages",
  CellTags->"General::gfargs"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"gfargs\"\>"}], \(\(:\)\(\ \)\), \(Generalized\ `1`\ \
arguments\ accept\ only\ matrices\ with\ machine\ real\ and\ complex\ \
\(\(elements\)\(.\)\)\)}]], "Message",
  CellTags->"General::gfargs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::gfargs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nonnum", "ObjectNameWarningMessages",
  CellTags->"General::nonnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nonnum\"\>"}], \(\(:\)\(\ \)\), \(`1`\ has\ received\ a\ \
matrix\ with\ non - numerical\ \(\(elements\)\(.\)\)\)}]], "Message",
  CellTags->"General::nonnum"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nonnum"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::dvec", "ObjectNameWarningMessages",
  CellTags->"General::dvec"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"dvec\"\>"}], \(\(:\)\(\ \)\), \(The\ dependency\ cannot\ \
be\ found\ for\ individual\ components\ of\ vector\ arguments, \ 
      so\ the\ dependency\ will\ be\ treated\ in\ block\ \
\(\(form\)\(.\)\)\)}]], "Message",
  CellTags->"General::dvec"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::dvec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::svecnm
Eigenvectors::svecnm
Eigensystem::svecnm\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::svecnm", "Eigenvalues::svecnm", "Eigenvectors::svecnm"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"svecnm\"\>"}], \(\(:\)\(\ \)\), "\<\"Value of option \
StartingVector->`1` must be a vector of machine numbers, of the same length \
as the row dimension of the matrix.\"\>"}]], "Message",
  CellLabel->"From In[5]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Eigensystem::svecnm", "Eigenvalues::svecnm", "Eigenvectors::svecnm"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigensystem::svecnm", "Eigenvalues::svecnm", "Eigenvectors::svecnm"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::eslct
Eigenvectors::eslct
Eigensystem::eslct\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"eslct\"\>"}], \(\(:\)\(\ \)\), "\<\"Value of option \
Criteria->`1` must be one of \\\"Magnitude\\\", \\\"RealPart\\\", \
\\\"ImaginaryPart\\\" or \\\"BothEnds\\\", with \\\"BothEnds\\\" appropriate \
for real symmetric eigenvalue problems only.\"\>"}]], "Message",
  CellLabel->"From In[12]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::ssing
Eigenvectors::ssing
Eigensystem::ssing\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ssing\"\>"}], \(\(:\)\(\ \)\), "\<\"Failed to factorize \
the matrix involving the shift. This may be because the shift, `1`, \
corresponds exactly to an eigenvalue, perturb the shift slightly could \
help.\"\>"}]], "Message",
  CellLabel->"From In[12]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::bsing
Eigenvectors::bsing
Eigensystem::bsing\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"bsing\"\>"}], \(\(:\)\(\ \)\), "\<\"The right-hand side \
matrix of the generalized eigenvalue problem is singular.\"\>"}]], "Message",
  CellLabel->"From In[12]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::aribs
Eigenvectors::aribs
Eigensystem::aribs\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"aribs\"\>"}], \(\(:\)\(\ \)\), "\<\"No shifts could be \
applied during a cycle of the implicitly restarted Arnoldi iteration. \
Increase the basis size with the method options Method->{Arnoldi, \
BasisSize->n}, where n is an integer no greater than the dimension of the \
matrix, may help.\"\>"}]], "Message",
  CellLabel->"From In[12]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::mcsgma
Eigenvectors::mcsgma
Eigensystem::mcsgma\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::mcsgma", "Eigenvalues::mcsgma", "Eigenvectors::mcsgma"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"mcsgma\"\>"}], \(\(:\)\(\ \)\), "\<\"Value of option \
Shift->`1` must be a machine number.\"\>"}]], "Message",
  CellLabel->"From In[13]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Eigensystem::mcsgma", "Eigenvalues::mcsgma", "Eigenvectors::mcsgma"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigensystem::mcsgma", "Eigenvalues::mcsgma", "Eigenvectors::mcsgma"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::arconv
Eigenvectors::arconv
Eigensystem::arconv\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::arconv", "Eigenvalues::arconv", "Eigenvectors::arconv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"arconv\"\>"}], \(\(:\)\(\ \)\), "\<\"Could not find any \
eigenvalues to sufficient accuracy.\"\>"}]], "Message",
  CellLabel->"From In[13]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Eigensystem::arconv", "Eigenvalues::arconv", "Eigenvectors::arconv"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigensystem::arconv", "Eigenvalues::arconv", "Eigenvectors::arconv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::maxit
Eigenvectors::maxit
Eigensystem::maxit\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"maxit\"\>"}], \(\(:\)\(\ \)\), "\<\"Maximum number of \
iterations, `1`, has been reached by the Arnoldi algorithm without \
convergence to the specified tolerance.  You can use method options with \
Method->{Arnoldi, opts) to increasing the basis size or the maximum number of \
iterations, reduce the tolerance, or choosing an appropriate shift, any of \
which may help.\"\>"}]], "Message",
  CellLabel->"From In[202]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eigenvalues::take", "ObjectNameWarningMessages",
  CellTags->"Eigenvalues::take"],

Cell[BoxData[
    \(Eigenvalues::"take" \(\(:\)\(\ \)\) \(Cannot\ take\ eigenvalues\ `1`\ \
through\ `2`\ out\ of\ a\ total\ of\ `3`\ \(\(eigenvalues\)\(.\)\)\)\)], \
"Message",
  CellTags->"Eigenvalues::take"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Eigenvalues::take"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eigenvectors::take", "ObjectNameWarningMessages",
  CellTags->"Eigenvectors::take"],

Cell[BoxData[
    \(Eigenvectors::"take" \(\(:\)\(\ \)\) \(Cannot\ take\ eigenvectors\ `1`\ \
through\ `2`\ out\ of\ a\ total\ of\ `3`\ \(\(eigenvectors\)\(.\)\)\)\)], \
"Message",
  CellTags->"Eigenvectors::take"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Eigenvectors::take"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Eigensystem::take", "ObjectNameWarningMessages",
  CellTags->"Eigensystem::take"],

Cell[BoxData[
    \(Eigensystem::"take" \(\(:\)\(\ \)\) \(Cannot\ take\ eigenvectors\ and\ \
eigenvalues\ `1`\ through\ `2`\ out\ of\ a\ total\ of\ `3`\ eigenvectors\ and\
\ \(\(eigenvalues\)\(.\)\)\)\)], "Message",
  CellTags->"Eigensystem::take"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Eigensystem::take"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
SingularValueDecomposition::take
SingularValueList::take\
\>", "ObjectNameWarningMessages",
  CellTags->{"SingularValueDecomposition::take", "SingularValueList::take"}],

Cell[BoxData[
    \(SingularValueList::"take" \(\(:\)\(\ \)\) 
      "Cannot take singular values `1` through `2` out of a total of `3` \
singular values."\)], "Message",
  CellLabel->"From In[25]:=",
  CellTags->{"SingularValueDecomposition::take", "SingularValueList::take"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"SingularValueDecomposition::take", "SingularValueList::take"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blincor", "ObjectNameWarningMessages",
  CellTags->"General::blincor"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blincor\"\>"}], \(\(:\)\(\ \)\), \(The\ arguments\ `1`\ \
and/or\ `2`\ are\ \(\(incorrect\)\(.\)\)\)}]], "Message",
  CellTags->"General::blincor"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blincor"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blintli", "ObjectNameWarningMessages",
  CellTags->"General::blintli"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blintli\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ \
should\ have\ integer\ elements\ \(\(only\)\(.\)\)\)}]], "Message",
  CellTags->"General::blintli"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blintli"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::blveclen", "ObjectNameWarningMessages",
  CellTags->"General::blveclen"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blveclen\"\>"}], \(\(:\)\(\ \)\), \(The\ argument\ `1`\ \
should\ be\ a\ vector\ of\ length\ \(\(`2`\)\(.\)\)\)}]], "Message",
  CellTags->"General::blveclen"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::blveclen"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearAlgebra`LAPACK`GESVX::blinstlu", "ObjectNameWarningMessages",
  CellTags->"LinearAlgebra`LAPACK`GESVX::blinstlu"],

Cell[BoxData[
    \(LinearAlgebra`LAPACK`GESVX::"blinstlu" \(\(:\)\(\ \)\) \(Warning : \ 
        the\ LU\ factorization\ of\ the\ matrix\ `1`\ at\ position\ `2`\ can\ \
be\ unstable, \ 
      and\ the\ solution\ of\ the\ system\ can\ be\ \(\(unreliable\)\(.\)\)\)\
\)], "Message",
  CellTags->"LinearAlgebra`LAPACK`GESVX::blinstlu"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearAlgebra`LAPACK`GESVX::blinstlu"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearAlgebra`LAPACK`LARTG::blneqsym", "ObjectNameWarningMessages",
  CellTags->"LinearAlgebra`LAPACK`LARTG::blneqsym"],

Cell[BoxData[
    \(LinearAlgebra`LAPACK`LARTG::"blneqsym" \(\(:\)\(\ \)\) \(You\ cannot\ \
use\ the\ same\ symbol\ `1`\ in\ positions\ `2`\ and\ \(\(`3`\)\(.\)\)\)\)], \
"Message",
  CellTags->"LinearAlgebra`LAPACK`LARTG::blneqsym"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearAlgebra`LAPACK`LARTG::blneqsym"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Norm::ptype", "ObjectNameWarningMessages",
  CellTags->"Norm::ptype"],

Cell[BoxData[
    \(Norm::"ptype" \(\(:\)\(\ \)\) \(Norm\ type, \ `1`, \ 
      in\ position\ 2\ should\ be\ a\ symbol, \ Infinity, \ 
      or\ a\ real\ number\ greater\ than\ or\ equal\ to\ 1. \)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Norm::ptype"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Norm::ptype"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Norm::symb", "ObjectNameWarningMessages",
  CellTags->"Norm::symb"],

Cell[BoxData[
    \(Norm::"symb" \(\(:\)\(\ \)\) 
      "Norm has received a matrix with symbolic element(s)."\)], "Message",
  CellLabel->"From In[15]:=",
  CellTags->"Norm::symb"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Norm::symb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quantile::nquan", "ObjectNameWarningMessages",
  CellTags->"Quantile::nquan"],

Cell[BoxData[
    \(Quantile::"nquan" \(\(:\)\(\ \)\) \(Quantile\ specification\ `1`\ is\ \
expected\ to\ be\ between\ 0\ and\ 1. \)\)], "Message",
  CellTags->"Quantile::nquan"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Quantile::nquan"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearAlgebra`BLAS`TestArgument::blapos", "ObjectNameWarningMessages",
  CellTags->"LinearAlgebra`BLAS`TestArgument::blapos"],

Cell[BoxData[
    \(LinearAlgebra`BLAS`TestArgument::"blapos" \(\(:\)\(\ \)\) \(The\ second\
\ argument\ `1`\ should\ be\ an\ integer\ which\ gives\ the\ argument\ \
position\ in\ `2`\ to\ \(\(test\)\(.\)\)\)\)], "Message",
  CellTags->"LinearAlgebra`BLAS`TestArgument::blapos"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearAlgebra`BLAS`TestArgument::blapos"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearAlgebra`BLAS`TestArgument::bltrank", "ObjectNameWarningMessages",
  CellTags->"LinearAlgebra`BLAS`TestArgument::bltrank"],

Cell[BoxData[
    \(LinearAlgebra`BLAS`TestArgument::"bltrank" \(\(:\)\(\ \)\) \(The\ \
required\ tensor\ rank\ `1`\ should\ be\ 0, \ 1, \ 2, \ 
      or\ _. \)\)], "Message",
  CellTags->"LinearAlgebra`BLAS`TestArgument::bltrank"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearAlgebra`BLAS`TestArgument::bltrank"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Norm::nvm", "ObjectNameWarningMessages",
  CellTags->"Norm::nvm"],

Cell[BoxData[
    \(Norm::"nvm" \(\(:\)\(\ \)\) \(The\ first\ Norm\ argument\ should\ be\ a\
\ number, \ vector\ or\ \(\(matrix\)\(.\)\)\)\)], "Message",
  CellTags->"Norm::nvm"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Norm::nvm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`ScaledVectorNorm::vinp", "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::vinp"],

Cell[BoxData[
    \(NDSolve`ScaledVectorNorm::"vinp" \(\(:\)\(\ \)\) \(The\ \
ScaledVectorNorm\ argument\ `1`\ at\ position\ 1\ is\ not\ a\ list\ of\ \
\(\(numbers\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`ScaledVectorNorm::vinp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::vinp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Norm::vlen
NDSolve`ScaledVectorNorm::vlen\
\>", "ObjectNameWarningMessages",
  CellTags->{"Norm::vlen", "NDSolve`ScaledVectorNorm::vlen"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"vlen\"\>"}], \(\(:\)\(\ \)\), \(The\ vector\ `1`\ and\ the\
\ weight\ vector\ `2`\ are\ of\ unequal\ \(\(lengths\)\(.\)\)\)}]], "Message",\

  CellTags->{"Norm::vlen", "NDSolve`ScaledVectorNorm::vlen"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Norm::vlen", "NDSolve`ScaledVectorNorm::vlen"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Norm::winp
NDSolve`ScaledVectorNorm::winp\
\>", "ObjectNameWarningMessages",
  CellTags->{"Norm::winp", "NDSolve`ScaledVectorNorm::winp"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"winp\"\>"}], \(\(:\)\(\ \)\), \(The\ weight\ vector\ \
argument\ `1`\ is\ not\ a\ nonempty\ list\ of\ \(\(numbers\)\(.\)\)\)}]], \
"Message",
  CellTags->{"Norm::winp", "NDSolve`ScaledVectorNorm::winp"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Norm::winp", "NDSolve`ScaledVectorNorm::winp"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv
LinearAlgebra`LAPACK`LASWP::blnotpiv\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv", 
    "LinearAlgebra`LAPACK`LASWP::blnotpiv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"blnotpiv\"\>"}], \(\(:\)\(\ \)\), \(The\ pivot\ vector\ \
`1`\ is\ \(\(incorrect\)\(.\)\)\)}]], "Message",
  CellTags->{
  "LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv", 
    "LinearAlgebra`LAPACK`LASWP::blnotpiv"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv", 
    "LinearAlgebra`LAPACK`LASWP::blnotpiv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::arall
Eigenvectors::arall
Eigensystem::arall\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"arall\"\>"}], \(\(:\)\(\ \)\), \(Method -> 
        Arnoldi\ cannot\ be\ used\ to\ compute\ more\ than\ `1`\ out\ of\ the\
\ `2`\ eigenvalues\ and/or\ \(\(eigenvectors\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::arb2
Eigenvectors::arb2
Eigensystem::arb2\
\>", "ObjectNameWarningMessages",
  CellTags->{"Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"arb2\"\>"}], \(\(:\)\(\ \)\), \(With\ the\ Arnoldi\ method\
\ option\ Criteria -> BothEnds, \ 
      you\ need\ to\ have\ requested\ two\ or\ more\ eigenvalues\ and/
          or\ \(\(eigenvectors\)\(.\)\)\)}]], "Message",
  CellTags->{"Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::arbs
Eigenvectors::arbs
Eigensystem::arbs\
\>", "ObjectNameWarningMessages",
  CellTags->{"Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"arbs\"\>"}], \(\(:\)\(\ \)\), "\<\"The values of the \
option BasisSize->`1` should be an integer greater than the requested number \
of eigenvalues and/or eigenvectors plus one, `2`, and at most the dimension \
of the matrix, `3`.\"\>"}]], "Message",
  CellLabel->"From In[209]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::arbss
Eigenvectors::arbss
Eigensystem::arbss\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"arbss\"\>"}], \(\(:\)\(\ \)\), \(The\ values\ of\ the\ \
option\ BasisSize -> `1`\ should\ be\ an\ integer\ greater\ than\ the\ \
requested\ number\ of\ eigenvalues\ and/or\ eigenvectors, \ `2`, \ 
      and\ at\ most\ the\ dimension\ of\ the\ matrix, \ \
\(\(`3`\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::arbsym
Eigenvectors::arbsym
Eigensystem::arbsym\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arbsym", "Eigenvectors::arbsym", "Eigensystem::arbsym"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"arbsym\"\>"}], \(\(:\)\(\ \)\), "\<\"You can only chose \
the Arnoldi method option Criteria->BothEnds for real symmetric \
matrices>\"\>"}]], "Message",
  CellLabel->"From In[33]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Eigenvalues::arbsym", "Eigenvectors::arbsym", "Eigensystem::arbsym"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigenvalues::arbsym", "Eigenvectors::arbsym", "Eigensystem::arbsym"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::arerr
Eigenvectors::arerr
Eigensystem::arerr\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"arerr\"\>"}], \(\(:\)\(\ \)\), \(The\ Arnoldi\ algorithm\ \
has\ encountered\ a\ LAPACK\ error\ which\ prevents\ it\ from\ \(\(continuing\
\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::arfac
Eigenvectors::arfac
Eigensystem::arfac\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"arfac\"\>"}], \(\(:\)\(\ \)\), \(Arnoldi\ algorithm\ \
failed\ because\ it\ could\ not\ build\ an\ Arnoldi\ \(\(factorization\)\(.\)\
\)\)}]], "Message",
  CellTags->{
  "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::argpd
Eigenvectors::argpd
Eigensystem::argpd\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"argpd\"\>"}], \(\(:\)\(\ \)\), \(The\ input\ matrices\ are\
\ sufficiently\ sparse\ that\ it\ is\ likely\ that\ the\ Arnoldi\ method\ \
would\ be\ faster\ for\ computing\ the\ requested\ eigenvalues\ and\ \
eigenvectors . \ \ However, \ 
      the\ algorithm\ requires\ that\ the\ second\ matrix\ be\ positive\ \
definite, \ 
      so\ dense\ methods\ will\ be\ used . \ \ If\ you\ know\ that\ the\ \
second\ matrix\ is\ positive\ definite, \ 
      it\ is\ recommended\ that\ you\ choose\ Method -> 
        Arnoldi\ in\ \(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::arh
Eigenvectors::arh
Eigensystem::arh\
\>", "ObjectNameWarningMessages",
  CellTags->{"Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"arh\"\>"}], \(\(:\)\(\ \)\), \(Because\ finding\ `1`\ out\ \
of\ the\ `2`\ eigenvalues\ and/
          or\ eigenvectors\ is\ likely\ to\ be\ faster\ with\ dense\ matrix\ \
methods, \ 
      the\ sparse\ input\ matrix\ will\ be\ converted . \ \ If\ fewer\ \
eigenvalues\ and/or\ eigenvectors\ would\ be\ sufficient, \ 
      consider\ restricting\ this\ number\ using\ the\ second\ argument\ to\ \
\(\(`3`\)\(.\)\)\)}]], "Message",
  CellTags->{"Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::arhm
Eigenvectors::arhm
Eigensystem::arhm\
\>", "ObjectNameWarningMessages",
  CellTags->{"Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"arhm\"\>"}], \(\(:\)\(\ \)\), \(Because\ finding\ `1`\ out\
\ of\ the\ `2`\ eigenvalues\ and/
          or\ eigenvectors\ is\ likely\ to\ be\ faster\ with\ dense\ matrix\ \
methods, \ 
      the\ sparse\ input\ matrix\ will\ be\ converted . \ \ If\ fewer\ \
eigenvalues\ and/
          or\ eigenvectors\ at\ machine\ precision\ would\ be\ sufficient, \ 
      consider\ using\ N\ on\ the\ matrix\ and\ restricting\ this\ number\ \
using\ the\ second\ argument\ to\ \(\(`3`\)\(.\)\)\)}]], "Message",
  CellTags->{"Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::arm
Eigenvectors::arm
Eigensystem::arm\
\>", "ObjectNameWarningMessages",
  CellTags->{"Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"arm\"\>"}], \(\(:\)\(\ \)\), \(Method -> 
        Arnoldi\ can\ only\ be\ used\ for\ matrices\ of\ machine\ \(\(numbers\
\)\(.\)\)\)}]], "Message",
  CellTags->{"Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::armc
Eigenvectors::armc
Eigensystem::armc\
\>", "ObjectNameWarningMessages",
  CellTags->{"Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"armc\"\>"}], \(\(:\)\(\ \)\), \(The\ Arnoldi\ method\ has\ \
encountered\ an\ intermediate\ value\ which\ is\ not\ a\ machine\ \
\(\(number\)\(.\)\)\)}]], "Message",
  CellTags->{"Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::armw
Eigenvectors::armw
Eigensystem::armw\
\>", "ObjectNameWarningMessages",
  CellTags->{"Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"armw\"\>"}], \(\(:\)\(\ \)\), "\<\"The iterative Arnoldi \
method can only be used for matrices of machine numbers.  `1` will use dense \
matrix methods instead.\"\>"}]], "Message",
  CellLabel->"From In[16]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::ars
Eigenvectors::ars
Eigensystem::ars\
\>", "ObjectNameWarningMessages",
  CellTags->{"Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ars\"\>"}], \(\(:\)\(\ \)\), \(Method -> 
        Arnoldi\ is\ typically\ only\ effective\ to\ find\ a\ few\ \
eigenvalues\ and/
            or\ eigenvectors . \ \ Finding\ the\ requested\ `1`\ out\ of\ the\
\ `2`\ eigenvalues\ and\ eigenvectors\ may\ to\ be\ faster\ with\ dense\ \
matrix\ \(\(methods\)\(.\)\)\)}]], "Message",
  CellTags->{"Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::arstv
Eigenvectors::arstv
Eigensystem::arstv\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"arstv\"\>"}], \(\(:\)\(\ \)\), \(The\ starting\ vector\ \
must\ have\ at\ least\ one\ nonzero\ \(\(component\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::emeth
Eigenvectors::emeth
Eigensystem::emeth\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"emeth\"\>"}], \(\(:\)\(\ \)\), \(The\ method\ specified\ \
by\ Method -> `1`\ should\ be\ either\ Automatic\ or\ \
\(\(Arnoldi\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Eigenvalues::maxit2
Eigenvectors::maxit2
Eigensystem::maxit2\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::maxit2", "Eigenvectors::maxit2", "Eigensystem::maxit2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"maxit2\"\>"}], \(\(:\)\(\ \)\), \(Maximum\ number\ of\ \
iterations, \ `1`, \ 
      has\ been\ reached\ by\ the\ Arnoldi\ algorithm\ without\ convergence\ \
to\ the\ specified\ tolerance, \ 
      but\ the\ current\ best\ computed\ value\ has\ been\ returned . \ \ You\
\ can\ use\ method\ options\ with\ Method -> {Arnoldi, \ 
            opts}\ to\ increasing\ the\ basis\ size\ or\ the\ maximum\ number\
\ of\ iterations, \ reduce\ the\ tolerance, \ 
      or\ using\ the\ estimate\ as\ a\ shift, \ 
      any\ of\ which\ may\ \(\(help\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Eigenvalues::maxit2", "Eigenvectors::maxit2", "Eigensystem::maxit2"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Eigenvalues::maxit2", "Eigenvectors::maxit2", "Eigensystem::maxit2"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::sing1", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::sing1"],

Cell[BoxData[
    \(LinearSolve::"sing1" \(\(:\)\(\ \)\) \(The\ matrix\ `1`\ is\ singular\ \
so\ a\ factorization\ will\ not\ be\ \(\(saved\)\(.\)\)\)\)], "Message",
  CellTags->"LinearSolve::sing1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::sing1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::sqmat1", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::sqmat1"],

Cell[BoxData[
    \(LinearSolve::"sqmat1" \(\(:\)\(\ \)\) \(The\ matrix\ `1`\ is\ not\ \
square\ so\ a\ factorization\ will\ not\ be\ \(\(saved\)\(.\)\)\)\)], \
"Message",
  CellTags->"LinearSolve::sqmat1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::sqmat1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray::posr", "ObjectNameWarningMessages",
  CellTags->"SparseArray::posr"],

Cell[BoxData[
    \(SparseArray::"posr" \(\(:\)\(\ \)\) \(The\ left\ hand\ side\ of\ `1`\ \
in\ `2`\ is\ not\ a\ position\ or\ a\ pattern\ which\ will\ match\ the\ \
position\ of\ an\ element\ in\ an\ array\ of\ rank\ \(\(`3`\)\(.\)\)\)\)], \
"Message",
  CellTags->"SparseArray::posr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"SparseArray::posr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::kryme", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::kryme"],

Cell[BoxData[
    \(LinearSolve::\(kryme : \ `1`\ is\ not\ a\ supported\ Krylov\ \(\(method\
\)\(.\)\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::kryme"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::kryme"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::kryit", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::kryit"],

Cell[BoxData[
    \(LinearSolve::\(kryit : \ 
          Value\ of\ option\ MaxIterations\)\  -> \ `1`\ should\ be\ a\ \
positive\ integer\ or\ \(\(Automatic\)\(.\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::kryit"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::kryit"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::krytol", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krytol"],

Cell[BoxData[
    \(LinearSolve::\(krytol : \ 
          Value\ of\ option\ Tolerance\)\  -> \ `1`\ is\ not\ a\ positive\ \
real\ number\ or\ \(\(Automatic\)\(.\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::krytol"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::krytol"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::krypre", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krypre"],

Cell[BoxData[
    \(LinearSolve::"krypre" \(\(:\)\(\ \)\) 
      "Value of option Preconditioner->`1` is not \"ILU\", or a user defined \
function."\)], "Message",
  CellLabel->"From In[35]:=",
  CellTags->"LinearSolve::krypre"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::krypre"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::krynor", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krynor"],

Cell[BoxData[
    \(LinearSolve::\(krynor : \ 
          Value\ of\ option\ ResidualNormFunction\) -> `1`\ is\ not\ a\ valid\
\ \(\(function\)\(.\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::krynor"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::krynor"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::krynorv", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krynorv"],

Cell[BoxData[
    \(LinearSolve::\(krynorv : \ 
        The\ result\ of\ applying\ user\ specified\ norm\ function\), \ `1`, \
\ is\ not\ a\ valid\ \(\(number\)\(.\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::krynorv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::krynorv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::krydia", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krydia"],

Cell[BoxData[
    \(LinearSolve::\(krydia : \ ILU\ preconditioner\ is\ specified\), \ 
    however\ there\ are\ missing\ diagonal\ entries\ in\ the\ input\ matrix, \
\ therefore\ no\ preconditioner\ is\ \(\(used\)\(.\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::krydia"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::krydia"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::krymit", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krymit"],

Cell[BoxData[
    \(LinearSolve::\(krymit : \ Maximum\ number\ of\ iterations\), \ `1`, \ 
    has\ been\ reached\ by\ the\ Krylov\ algorithm\ without\ convergence\ to\ \
the\ tolerance, \ 
    the\ current\ best\ computed\ solution\ has\ been\ \
\(\(returned\)\(.\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::krymit"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::krymit"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::krypr", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krypr"],

Cell[BoxData[
    \(LinearSolve::\(krypr : \ 
        The\ result\ of\ applying\ user\ specified\ preconditioner\), \ `1`, \
\ should\ be\ a\ list\ with\ the\ length\ equal\ to\ the\ row\ dimension\ of\ \
the\ \(\(matrix\)\(.\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::krypr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::krypr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::kryma", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::kryma"],

Cell[BoxData[
    \(LinearSolve::\(kryma : \ 
        The\ result\ of\ applying\ user\ specified\ matrix\), \ `1`, \ 
    should\ be\ a\ list\ with\ the\ length\ equal\ to\ the\ row\ dimension\ \
of\ the\ \(\(matrix\)\(.\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::kryma"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::kryma"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::krynom", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krynom"],

Cell[BoxData[
    \(LinearSolve::\(krynom : \ 
        Non - numerical\ quantities\ were\ encountered\ during\ Krylov\ \
iteration\), \ 
    this\ may\ be\ because\ the\ linear\ equations\ to\ be\ solved\ have\ no\ \
\(\(solution\)\(.\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::krynom"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::krynom"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::krynum", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krynum"],

Cell[BoxData[
    \(LinearSolve::\(krynum : \ 
        Input\ to\ Krylov\ algorithm\ contains\ elements\ that\ are\ not\ \
explicit\ numbers\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::krynum"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::krynum"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinearSolve::kryinfp", "ObjectNameWarningMessages",
  CellTags->"LinearSolve::kryinfp"],

Cell[BoxData[
    \(LinearSolve::\(kryinfp : \ 
        Input\ to\ Krylov\ algorithm\ is\ of\ infinite\ precision . \ 
            Iterations\ may\ become\ very\ slow\ due\ to\ expression\ size\ \
\(\(growth\)\(.\)\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinearSolve::kryinfp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"LinearSolve::kryinfp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SparseArray::drnk", "ObjectNameWarningMessages",
  CellTags->"SparseArray::drnk"],

Cell[BoxData[
    \(SparseArray::\(drnk : \ The\ requested\ dimensions\), \ `1`, \ 
    have\ length\ inconsistent\ with\ the\ tensor\ rank\ \((`2`)\)\ of\ the\ \
\(\(input\)\(.\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SparseArray::drnk"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"SparseArray::drnk"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 975}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{603, 611},
WindowMargins->{{Automatic, 47}, {Automatic, 42}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Rest::norest"->{
    Cell[1836, 57, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Rest::norest"],
    Cell[1916, 60, 346, 9, 21, "Message",
      CellTags->"Rest::norest"],
    Cell[2265, 71, 186, 5, 24, "Notes",
      CellTags->"Rest::norest"],
    Cell[2476, 80, 62, 1, 38, "ExampleSection",
      CellTags->"Rest::norest"],
    Cell[2541, 83, 155, 4, 24, "Text",
      CellTags->"Rest::norest"],
    Cell[2721, 91, 93, 3, 26, "Input",
      CellTags->"Rest::norest"],
    Cell[2817, 96, 191, 5, 21, "Message",
      CellTags->"Rest::norest"],
    Cell[3011, 103, 94, 3, 21, "Output",
      CellTags->"Rest::norest"]},
  "Cross::nonn1"->{
    Cell[3166, 113, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Cross::nonn1"],
    Cell[3246, 116, 236, 5, 53, "Message",
      CellTags->"Cross::nonn1"],
    Cell[3485, 123, 542, 14, 68, "Notes",
      CellTags->"Cross::nonn1"],
    Cell[4052, 141, 62, 1, 38, "ExampleSection",
      CellTags->"Cross::nonn1"],
    Cell[4117, 144, 119, 4, 24, "Text",
      CellTags->"Cross::nonn1"],
    Cell[4261, 152, 101, 3, 26, "Input",
      CellTags->"Cross::nonn1"],
    Cell[4365, 157, 265, 6, 53, "Message",
      CellTags->"Cross::nonn1"],
    Cell[4633, 165, 102, 3, 21, "Output",
      CellTags->"Cross::nonn1"],
    Cell[4750, 171, 77, 1, 24, "Text",
      CellTags->"Cross::nonn1"],
    Cell[4852, 176, 112, 3, 26, "Input",
      CellTags->"Cross::nonn1"],
    Cell[4967, 181, 105, 3, 21, "Output",
      CellTags->"Cross::nonn1"]},
  "LinearSolve::mronly"->{
    Cell[5133, 191, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::mronly"],
    Cell[5227, 194, 307, 5, 53, "Message",
      CellTags->"LinearSolve::mronly"],
    Cell[5537, 201, 130, 4, 24, "Notes",
      CellTags->"LinearSolve::mronly"]},
  "LinearSolve::mconly"->{
    Cell[5704, 210, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::mconly"],
    Cell[5798, 213, 320, 6, 53, "Message",
      CellTags->"LinearSolve::mconly"],
    Cell[6121, 221, 130, 4, 24, "Notes",
      CellTags->"LinearSolve::mconly"]},
  "LinearSolve::mcovl"->{
    Cell[6288, 230, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::mcovl"],
    Cell[6380, 233, 372, 6, 69, "Message",
      CellTags->"LinearSolve::mcovl"],
    Cell[6755, 241, 129, 4, 24, "Notes",
      CellTags->"LinearSolve::mcovl"]},
  "LinearSolve::nolib"->{
    Cell[6921, 250, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::nolib"],
    Cell[7013, 253, 250, 4, 37, "Message",
      CellTags->"LinearSolve::nolib"],
    Cell[7266, 259, 129, 4, 24, "Notes",
      CellTags->"LinearSolve::nolib"]},
  "LinearSolve::lupat"->{
    Cell[7432, 268, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::lupat"],
    Cell[7524, 271, 189, 3, 37, "Message",
      CellTags->"LinearSolve::lupat"],
    Cell[7716, 276, 129, 4, 24, "Notes",
      CellTags->"LinearSolve::lupat"]},
  "LinearSolve::sqmat"->{
    Cell[7882, 285, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::sqmat"],
    Cell[7974, 288, 429, 9, 37, "Message",
      CellTags->"LinearSolve::sqmat"],
    Cell[8406, 299, 129, 4, 24, "Notes",
      CellTags->"LinearSolve::sqmat"]},
  "LinearSolve::npdef"->{
    Cell[8572, 308, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::npdef"],
    Cell[8664, 311, 316, 8, 21, "Message",
      CellTags->"LinearSolve::npdef"],
    Cell[8983, 321, 129, 4, 24, "Notes",
      CellTags->"LinearSolve::npdef"]},
  "LinearSolve::herm"->{
    Cell[9149, 330, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::herm"],
    Cell[9239, 333, 437, 11, 37, "Message",
      CellTags->"LinearSolve::herm"],
    Cell[9679, 346, 128, 4, 24, "Notes",
      CellTags->"LinearSolve::herm"]},
  "LinearSolve::tmm"->{
    Cell[9844, 355, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::tmm"],
    Cell[9932, 358, 225, 4, 37, "Message",
      CellTags->"LinearSolve::tmm"],
    Cell[10160, 364, 127, 4, 24, "Notes",
      CellTags->"LinearSolve::tmm"]},
  "Experimental`ExtendedLinearSolve::lsvs"->{
    Cell[10324, 373, 304, 8, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Experimental`ExtendedLinearSolve::lsvs", 
        "Experimental`LinearSolveFunction::lsvs", 
        "Developer`SparseLinearSolve::lsvs"}],
    Cell[10631, 383, 499, 13, 53, "Message",
      CellTags->{
      "Experimental`ExtendedLinearSolve::lsvs", 
        "Experimental`LinearSolveFunction::lsvs", 
        "Developer`SparseLinearSolve::lsvs"}],
    Cell[11133, 398, 243, 7, 24, "Notes",
      CellTags->{
      "Experimental`ExtendedLinearSolve::lsvs", 
        "Experimental`LinearSolveFunction::lsvs", 
        "Developer`SparseLinearSolve::lsvs"}]},
  "Experimental`LinearSolveFunction::lsvs"->{
    Cell[10324, 373, 304, 8, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Experimental`ExtendedLinearSolve::lsvs", 
        "Experimental`LinearSolveFunction::lsvs", 
        "Developer`SparseLinearSolve::lsvs"}],
    Cell[10631, 383, 499, 13, 53, "Message",
      CellTags->{
      "Experimental`ExtendedLinearSolve::lsvs", 
        "Experimental`LinearSolveFunction::lsvs", 
        "Developer`SparseLinearSolve::lsvs"}],
    Cell[11133, 398, 243, 7, 24, "Notes",
      CellTags->{
      "Experimental`ExtendedLinearSolve::lsvs", 
        "Experimental`LinearSolveFunction::lsvs", 
        "Developer`SparseLinearSolve::lsvs"}]},
  "Developer`SparseLinearSolve::lsvs"->{
    Cell[10324, 373, 304, 8, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Experimental`ExtendedLinearSolve::lsvs", 
        "Experimental`LinearSolveFunction::lsvs", 
        "Developer`SparseLinearSolve::lsvs"}],
    Cell[10631, 383, 499, 13, 53, "Message",
      CellTags->{
      "Experimental`ExtendedLinearSolve::lsvs", 
        "Experimental`LinearSolveFunction::lsvs", 
        "Developer`SparseLinearSolve::lsvs"}],
    Cell[11133, 398, 243, 7, 24, "Notes",
      CellTags->{
      "Experimental`ExtendedLinearSolve::lsvs", 
        "Experimental`LinearSolveFunction::lsvs", 
        "Developer`SparseLinearSolve::lsvs"}]},
  "CholeskyDecomposition::herm"->{
    Cell[11413, 410, 228, 7, 51, "ObjectNameWarningMessages",
      CellTags->{
      "CholeskyDecomposition::herm", 
        "Optimization`ModifiedCholeskyDecomposition::herm"}],
    Cell[11644, 419, 267, 5, 37, "Message",
      CellTags->{
      "CholeskyDecomposition::herm", 
        "Optimization`ModifiedCholeskyDecomposition::herm"}],
    Cell[11914, 426, 200, 6, 24, "Notes",
      CellTags->{
      "CholeskyDecomposition::herm", 
        "Optimization`ModifiedCholeskyDecomposition::herm"}]},
  "Optimization`ModifiedCholeskyDecomposition::herm"->{
    Cell[11413, 410, 228, 7, 51, "ObjectNameWarningMessages",
      CellTags->{
      "CholeskyDecomposition::herm", 
        "Optimization`ModifiedCholeskyDecomposition::herm"}],
    Cell[11644, 419, 267, 5, 37, "Message",
      CellTags->{
      "CholeskyDecomposition::herm", 
        "Optimization`ModifiedCholeskyDecomposition::herm"}],
    Cell[11914, 426, 200, 6, 24, "Notes",
      CellTags->{
      "CholeskyDecomposition::herm", 
        "Optimization`ModifiedCholeskyDecomposition::herm"}]},
  "CholeskyDecomposition::posdef"->{
    Cell[12151, 437, 236, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "CholeskyDecomposition::posdef", 
        "Optimization`ModifiedCholeskyDecomposition::posdef"}],
    Cell[12390, 446, 342, 6, 53, "Message",
      CellTags->{
      "CholeskyDecomposition::posdef", 
        "Optimization`ModifiedCholeskyDecomposition::posdef"}],
    Cell[12735, 454, 204, 6, 24, "Notes",
      CellTags->{
      "CholeskyDecomposition::posdef", 
        "Optimization`ModifiedCholeskyDecomposition::posdef"}]},
  "Optimization`ModifiedCholeskyDecomposition::posdef"->{
    Cell[12151, 437, 236, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "CholeskyDecomposition::posdef", 
        "Optimization`ModifiedCholeskyDecomposition::posdef"}],
    Cell[12390, 446, 342, 6, 53, "Message",
      CellTags->{
      "CholeskyDecomposition::posdef", 
        "Optimization`ModifiedCholeskyDecomposition::posdef"}],
    Cell[12735, 454, 204, 6, 24, "Notes",
      CellTags->{
      "CholeskyDecomposition::posdef", 
        "Optimization`ModifiedCholeskyDecomposition::posdef"}]},
  "SingularValues::neqcols"->{
    Cell[12976, 465, 249, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "SingularValues::neqcols", "SingularValueList::neqcols", 
        "SingularValueDecomposition::neqcols"}],
    Cell[13228, 474, 385, 11, 37, "Message",
      CellTags->{
      "SingularValues::neqcols", "SingularValueList::neqcols", 
        "SingularValueDecomposition::neqcols"}],
    Cell[13616, 487, 213, 6, 24, "Notes",
      CellTags->{
      "SingularValues::neqcols", "SingularValueList::neqcols", 
        "SingularValueDecomposition::neqcols"}]},
  "SingularValueList::neqcols"->{
    Cell[12976, 465, 249, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "SingularValues::neqcols", "SingularValueList::neqcols", 
        "SingularValueDecomposition::neqcols"}],
    Cell[13228, 474, 385, 11, 37, "Message",
      CellTags->{
      "SingularValues::neqcols", "SingularValueList::neqcols", 
        "SingularValueDecomposition::neqcols"}],
    Cell[13616, 487, 213, 6, 24, "Notes",
      CellTags->{
      "SingularValues::neqcols", "SingularValueList::neqcols", 
        "SingularValueDecomposition::neqcols"}]},
  "SingularValueDecomposition::neqcols"->{
    Cell[12976, 465, 249, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "SingularValues::neqcols", "SingularValueList::neqcols", 
        "SingularValueDecomposition::neqcols"}],
    Cell[13228, 474, 385, 11, 37, "Message",
      CellTags->{
      "SingularValues::neqcols", "SingularValueList::neqcols", 
        "SingularValueDecomposition::neqcols"}],
    Cell[13616, 487, 213, 6, 24, "Notes",
      CellTags->{
      "SingularValues::neqcols", "SingularValueList::neqcols", 
        "SingularValueDecomposition::neqcols"}]},
  "SingularValueDecomposition::svdf"->{
    Cell[13866, 498, 231, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[14100, 507, 475, 13, 21, "Message",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[14578, 522, 405, 10, 40, "Notes",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15008, 536, 143, 3, 38, "ExampleSection",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15154, 541, 215, 6, 24, "Text",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15394, 551, 210, 5, 26, "Input",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15607, 558, 314, 7, 53, "Message",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15924, 567, 211, 5, 21, "Output",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[16150, 575, 219, 6, 24, "Text",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[16394, 585, 213, 5, 26, "Input",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[16610, 592, 470, 10, 53, "Output",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}]},
  "SingularValueList::svdf"->{
    Cell[13866, 498, 231, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[14100, 507, 475, 13, 21, "Message",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[14578, 522, 405, 10, 40, "Notes",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15008, 536, 143, 3, 38, "ExampleSection",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15154, 541, 215, 6, 24, "Text",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15394, 551, 210, 5, 26, "Input",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15607, 558, 314, 7, 53, "Message",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15924, 567, 211, 5, 21, "Output",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[16150, 575, 219, 6, 24, "Text",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[16394, 585, 213, 5, 26, "Input",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[16610, 592, 470, 10, 53, "Output",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}]},
  "SingularValues::svdf"->{
    Cell[13866, 498, 231, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[14100, 507, 475, 13, 21, "Message",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[14578, 522, 405, 10, 40, "Notes",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15008, 536, 143, 3, 38, "ExampleSection",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15154, 541, 215, 6, 24, "Text",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15394, 551, 210, 5, 26, "Input",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15607, 558, 314, 7, 53, "Message",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[15924, 567, 211, 5, 21, "Output",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[16150, 575, 219, 6, 24, "Text",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[16394, 585, 213, 5, 26, "Input",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}],
    Cell[16610, 592, 470, 10, 53, "Output",
      CellTags->{
      "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
        "SingularValues::svdf"}]},
  "SingularValueDecomposition::svdn"->{
    Cell[17141, 609, 231, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[17375, 618, 518, 15, 21, "Message",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[17896, 635, 361, 9, 40, "Notes",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[18282, 648, 143, 3, 38, "ExampleSection",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[18428, 653, 214, 6, 24, "Text",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[18667, 663, 216, 5, 26, "Input",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[18886, 670, 318, 7, 53, "Message",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[19207, 679, 220, 5, 21, "Output",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[19442, 687, 227, 7, 24, "Text",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[19694, 698, 238, 6, 42, "Input",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[19935, 706, 473, 10, 53, "Output",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}]},
  "SingularValueList::svdn"->{
    Cell[17141, 609, 231, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[17375, 618, 518, 15, 21, "Message",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[17896, 635, 361, 9, 40, "Notes",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[18282, 648, 143, 3, 38, "ExampleSection",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[18428, 653, 214, 6, 24, "Text",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[18667, 663, 216, 5, 26, "Input",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[18886, 670, 318, 7, 53, "Message",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[19207, 679, 220, 5, 21, "Output",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[19442, 687, 227, 7, 24, "Text",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[19694, 698, 238, 6, 42, "Input",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[19935, 706, 473, 10, 53, "Output",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}]},
  "SingularValues::svdn"->{
    Cell[17141, 609, 231, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[17375, 618, 518, 15, 21, "Message",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[17896, 635, 361, 9, 40, "Notes",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[18282, 648, 143, 3, 38, "ExampleSection",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[18428, 653, 214, 6, 24, "Text",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[18667, 663, 216, 5, 26, "Input",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[18886, 670, 318, 7, 53, "Message",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[19207, 679, 220, 5, 21, "Output",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[19442, 687, 227, 7, 24, "Text",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[19694, 698, 238, 6, 42, "Input",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}],
    Cell[19935, 706, 473, 10, 53, "Output",
      CellTags->{
      "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
        "SingularValues::svdn"}]},
  "Developer`LinearExpressionToMatrix::nonlin"->{
    Cell[20469, 723, 258, 7, 51, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`LinearExpressionToMatrix::nonlin", 
        "Developer`LinearExpressionToSparseMatrix::nonlin"}],
    Cell[20730, 732, 356, 9, 21, "Message",
      CellTags->{
      "Developer`LinearExpressionToMatrix::nonlin", 
        "Developer`LinearExpressionToSparseMatrix::nonlin"}],
    Cell[21089, 743, 215, 6, 24, "Notes",
      CellTags->{
      "Developer`LinearExpressionToMatrix::nonlin", 
        "Developer`LinearExpressionToSparseMatrix::nonlin"}]},
  "Developer`LinearExpressionToSparseMatrix::nonlin"->{
    Cell[20469, 723, 258, 7, 51, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`LinearExpressionToMatrix::nonlin", 
        "Developer`LinearExpressionToSparseMatrix::nonlin"}],
    Cell[20730, 732, 356, 9, 21, "Message",
      CellTags->{
      "Developer`LinearExpressionToMatrix::nonlin", 
        "Developer`LinearExpressionToSparseMatrix::nonlin"}],
    Cell[21089, 743, 215, 6, 24, "Notes",
      CellTags->{
      "Developer`LinearExpressionToMatrix::nonlin", 
        "Developer`LinearExpressionToSparseMatrix::nonlin"}]},
  "Developer`LinearExpressionToMatrix::lexp"->{
    Cell[21341, 754, 250, 7, 51, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`LinearExpressionToMatrix::lexp", 
        "Developer`LinearExpressionToSparseMatrix::lexp"}],
    Cell[21594, 763, 378, 10, 37, "Message",
      CellTags->{
      "Developer`LinearExpressionToMatrix::lexp", 
        "Developer`LinearExpressionToSparseMatrix::lexp"}],
    Cell[21975, 775, 211, 6, 24, "Notes",
      CellTags->{
      "Developer`LinearExpressionToMatrix::lexp", 
        "Developer`LinearExpressionToSparseMatrix::lexp"}]},
  "Developer`LinearExpressionToSparseMatrix::lexp"->{
    Cell[21341, 754, 250, 7, 51, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`LinearExpressionToMatrix::lexp", 
        "Developer`LinearExpressionToSparseMatrix::lexp"}],
    Cell[21594, 763, 378, 10, 37, "Message",
      CellTags->{
      "Developer`LinearExpressionToMatrix::lexp", 
        "Developer`LinearExpressionToSparseMatrix::lexp"}],
    Cell[21975, 775, 211, 6, 24, "Notes",
      CellTags->{
      "Developer`LinearExpressionToMatrix::lexp", 
        "Developer`LinearExpressionToSparseMatrix::lexp"}]},
  "LUBackSubstitution::singlu"->{
    Cell[22223, 786, 105, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LUBackSubstitution::singlu"],
    Cell[22331, 789, 190, 3, 21, "Message",
      CellTags->"LUBackSubstitution::singlu"],
    Cell[22524, 794, 137, 4, 24, "Notes",
      CellTags->"LUBackSubstitution::singlu"]},
  "SparseArray::dims"->{
    Cell[22698, 803, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SparseArray::dims"],
    Cell[22788, 806, 195, 3, 37, "Message",
      CellTags->"SparseArray::dims"],
    Cell[22986, 811, 128, 4, 24, "Notes",
      CellTags->"SparseArray::dims"]},
  "SparseArray::rect"->{
    Cell[23151, 820, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SparseArray::rect"],
    Cell[23241, 823, 196, 3, 37, "Message",
      CellTags->"SparseArray::rect"],
    Cell[23440, 828, 128, 4, 24, "Notes",
      CellTags->"SparseArray::rect"]},
  "SparseArray::exdims"->{
    Cell[23605, 837, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SparseArray::exdims"],
    Cell[23699, 840, 193, 3, 37, "Message",
      CellTags->"SparseArray::exdims"],
    Cell[23895, 845, 130, 4, 24, "Notes",
      CellTags->"SparseArray::exdims"]},
  "SparseArray::pind"->{
    Cell[24062, 854, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SparseArray::pind"],
    Cell[24152, 857, 169, 3, 21, "Message",
      CellTags->"SparseArray::pind"],
    Cell[24324, 862, 128, 4, 24, "Notes",
      CellTags->"SparseArray::pind"]},
  "SparseArray::ilist"->{
    Cell[24489, 871, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SparseArray::ilist"],
    Cell[24581, 874, 180, 3, 21, "Message",
      CellTags->"SparseArray::ilist"],
    Cell[24764, 879, 129, 4, 24, "Notes",
      CellTags->"SparseArray::ilist"]},
  "SparseArray::rule"->{
    Cell[24930, 888, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SparseArray::rule"],
    Cell[25020, 891, 166, 3, 21, "Message",
      CellTags->"SparseArray::rule"],
    Cell[25189, 896, 128, 4, 24, "Notes",
      CellTags->"SparseArray::rule"]},
  "SparseArray::rule1"->{
    Cell[25354, 905, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SparseArray::rule1"],
    Cell[25446, 908, 182, 3, 21, "Message",
      CellTags->"SparseArray::rule1"],
    Cell[25631, 913, 129, 4, 24, "Notes",
      CellTags->"SparseArray::rule1"]},
  "SparseArray::ntb"->{
    Cell[25797, 922, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SparseArray::ntb"],
    Cell[25885, 925, 263, 4, 37, "Message",
      CellTags->"SparseArray::ntb"],
    Cell[26151, 931, 127, 4, 24, "Notes",
      CellTags->"SparseArray::ntb"]},
  "SparseArray::pos"->{
    Cell[26315, 940, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SparseArray::pos"],
    Cell[26403, 943, 230, 4, 37, "Message",
      CellTags->"SparseArray::pos"],
    Cell[26636, 949, 127, 4, 24, "Notes",
      CellTags->"SparseArray::pos"]},
  "SparseArray::valnl"->{
    Cell[26800, 958, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SparseArray::valnl"],
    Cell[26892, 961, 192, 3, 37, "Message",
      CellTags->"SparseArray::valnl"],
    Cell[27087, 966, 129, 4, 24, "Notes",
      CellTags->"SparseArray::valnl"]},
  "SparseArray`SymmetricQ::spmat"->{
    Cell[27253, 975, 187, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "SparseArray`SymmetricQ::spmat", "SparseArray`HermitianQ::spmat"}],
    Cell[27443, 982, 287, 8, 21, "Message",
      CellTags->{
      "SparseArray`SymmetricQ::spmat", "SparseArray`HermitianQ::spmat"}],
    Cell[27733, 992, 178, 5, 24, "Notes",
      CellTags->{
      "SparseArray`SymmetricQ::spmat", "SparseArray`HermitianQ::spmat"}]},
  "SparseArray`HermitianQ::spmat"->{
    Cell[27253, 975, 187, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "SparseArray`SymmetricQ::spmat", "SparseArray`HermitianQ::spmat"}],
    Cell[27443, 982, 287, 8, 21, "Message",
      CellTags->{
      "SparseArray`SymmetricQ::spmat", "SparseArray`HermitianQ::spmat"}],
    Cell[27733, 992, 178, 5, 24, "Notes",
      CellTags->{
      "SparseArray`SymmetricQ::spmat", "SparseArray`HermitianQ::spmat"}]},
  "General::sparv"->{
    Cell[27948, 1002, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sparv"],
    Cell[28032, 1005, 259, 7, 21, "Message",
      CellTags->"General::sparv"],
    Cell[28294, 1014, 125, 4, 24, "Notes",
      CellTags->"General::sparv"]},
  "General::spts"->{
    Cell[28456, 1023, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::spts"],
    Cell[28538, 1026, 299, 8, 37, "Message",
      CellTags->"General::spts"],
    Cell[28840, 1036, 124, 4, 24, "Notes",
      CellTags->"General::spts"]},
  "Developer`SparseLinearSolve::spam"->{
    Cell[29001, 1045, 119, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Developer`SparseLinearSolve::spam"],
    Cell[29123, 1048, 405, 6, 85, "Message",
      CellTags->"Developer`SparseLinearSolve::spam"],
    Cell[29531, 1056, 144, 4, 24, "Notes",
      CellTags->"Developer`SparseLinearSolve::spam"]},
  "Developer`SparseLinearSolve::deprec"->{
    Cell[29712, 1065, 123, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Developer`SparseLinearSolve::deprec"],
    Cell[29838, 1068, 274, 5, 53, "Message",
      CellTags->"Developer`SparseLinearSolve::deprec"],
    Cell[30115, 1075, 146, 4, 24, "Notes",
      CellTags->"Developer`SparseLinearSolve::deprec"]},
  "Developer`SparseLinearSolve::fovflw"->{
    Cell[30298, 1084, 316, 8, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`SparseLinearSolve::fovflw", 
        "Experimental`ExtendedLinearSolve::fovflw", 
        "Experimental`LinearSolveFunction::fovflw"}],
    Cell[30617, 1094, 390, 10, 21, "Message",
      CellTags->{
      "Developer`SparseLinearSolve::fovflw", 
        "Experimental`ExtendedLinearSolve::fovflw", 
        "Experimental`LinearSolveFunction::fovflw"}],
    Cell[31010, 1106, 249, 7, 24, "Notes",
      CellTags->{
      "Developer`SparseLinearSolve::fovflw", 
        "Experimental`ExtendedLinearSolve::fovflw", 
        "Experimental`LinearSolveFunction::fovflw"}]},
  "Experimental`ExtendedLinearSolve::fovflw"->{
    Cell[30298, 1084, 316, 8, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`SparseLinearSolve::fovflw", 
        "Experimental`ExtendedLinearSolve::fovflw", 
        "Experimental`LinearSolveFunction::fovflw"}],
    Cell[30617, 1094, 390, 10, 21, "Message",
      CellTags->{
      "Developer`SparseLinearSolve::fovflw", 
        "Experimental`ExtendedLinearSolve::fovflw", 
        "Experimental`LinearSolveFunction::fovflw"}],
    Cell[31010, 1106, 249, 7, 24, "Notes",
      CellTags->{
      "Developer`SparseLinearSolve::fovflw", 
        "Experimental`ExtendedLinearSolve::fovflw", 
        "Experimental`LinearSolveFunction::fovflw"}]},
  "Experimental`LinearSolveFunction::fovflw"->{
    Cell[30298, 1084, 316, 8, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`SparseLinearSolve::fovflw", 
        "Experimental`ExtendedLinearSolve::fovflw", 
        "Experimental`LinearSolveFunction::fovflw"}],
    Cell[30617, 1094, 390, 10, 21, "Message",
      CellTags->{
      "Developer`SparseLinearSolve::fovflw", 
        "Experimental`ExtendedLinearSolve::fovflw", 
        "Experimental`LinearSolveFunction::fovflw"}],
    Cell[31010, 1106, 249, 7, 24, "Notes",
      CellTags->{
      "Developer`SparseLinearSolve::fovflw", 
        "Experimental`ExtendedLinearSolve::fovflw", 
        "Experimental`LinearSolveFunction::fovflw"}]},
  "Developer`SparseLinearSolve::sovflw"->{
    Cell[31296, 1118, 316, 8, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`SparseLinearSolve::sovflw", 
        "Experimental`ExtendedLinearSolve::sovflw", 
        "Experimental`LinearSolveFunction::sovflw"}],
    Cell[31615, 1128, 388, 10, 21, "Message",
      CellTags->{
      "Developer`SparseLinearSolve::sovflw", 
        "Experimental`ExtendedLinearSolve::sovflw", 
        "Experimental`LinearSolveFunction::sovflw"}],
    Cell[32006, 1140, 249, 7, 24, "Notes",
      CellTags->{
      "Developer`SparseLinearSolve::sovflw", 
        "Experimental`ExtendedLinearSolve::sovflw", 
        "Experimental`LinearSolveFunction::sovflw"}]},
  "Experimental`ExtendedLinearSolve::sovflw"->{
    Cell[31296, 1118, 316, 8, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`SparseLinearSolve::sovflw", 
        "Experimental`ExtendedLinearSolve::sovflw", 
        "Experimental`LinearSolveFunction::sovflw"}],
    Cell[31615, 1128, 388, 10, 21, "Message",
      CellTags->{
      "Developer`SparseLinearSolve::sovflw", 
        "Experimental`ExtendedLinearSolve::sovflw", 
        "Experimental`LinearSolveFunction::sovflw"}],
    Cell[32006, 1140, 249, 7, 24, "Notes",
      CellTags->{
      "Developer`SparseLinearSolve::sovflw", 
        "Experimental`ExtendedLinearSolve::sovflw", 
        "Experimental`LinearSolveFunction::sovflw"}]},
  "Experimental`LinearSolveFunction::sovflw"->{
    Cell[31296, 1118, 316, 8, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`SparseLinearSolve::sovflw", 
        "Experimental`ExtendedLinearSolve::sovflw", 
        "Experimental`LinearSolveFunction::sovflw"}],
    Cell[31615, 1128, 388, 10, 21, "Message",
      CellTags->{
      "Developer`SparseLinearSolve::sovflw", 
        "Experimental`ExtendedLinearSolve::sovflw", 
        "Experimental`LinearSolveFunction::sovflw"}],
    Cell[32006, 1140, 249, 7, 24, "Notes",
      CellTags->{
      "Developer`SparseLinearSolve::sovflw", 
        "Experimental`ExtendedLinearSolve::sovflw", 
        "Experimental`LinearSolveFunction::sovflw"}]},
  "General::mindet"->{
    Cell[32292, 1152, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::mindet"],
    Cell[32378, 1155, 254, 7, 21, "Message",
      CellTags->"General::mindet"],
    Cell[32635, 1164, 500, 16, 62, "Notes",
      CellTags->"General::mindet"]},
  "General::blnoval"->{
    Cell[33172, 1185, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blnoval"],
    Cell[33260, 1188, 289, 8, 37, "Message",
      CellTags->"General::blnoval"],
    Cell[33552, 1198, 185, 4, 24, "Notes",
      CellTags->"General::blnoval"],
    Cell[33762, 1206, 66, 1, 38, "ExampleSection",
      CellTags->"General::blnoval"],
    Cell[33831, 1209, 159, 4, 24, "Text",
      CellTags->"General::blnoval"],
    Cell[34015, 1217, 127, 3, 26, "Input",
      CellTags->"General::blnoval"],
    Cell[34145, 1222, 236, 5, 37, "Message",
      CellTags->"General::blnoval"],
    Cell[34384, 1229, 128, 3, 21, "Output",
      CellTags->"General::blnoval"]},
  "HermiteNormalForm::latm"->{
    Cell[34573, 1239, 152, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[34728, 1245, 284, 7, 21, "Message",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[35015, 1254, 342, 8, 40, "Notes",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[35382, 1266, 98, 1, 38, "ExampleSection",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[35483, 1269, 173, 4, 24, "Text",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[35681, 1277, 160, 3, 26, "Input",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[35844, 1282, 218, 4, 21, "Message",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[36065, 1288, 156, 3, 21, "Output",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[36236, 1294, 206, 5, 24, "Text",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[36467, 1303, 167, 3, 26, "Input",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[36637, 1308, 146, 3, 36, "Output",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}]},
  "LatticeReduce::latm"->{
    Cell[34573, 1239, 152, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[34728, 1245, 284, 7, 21, "Message",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[35015, 1254, 342, 8, 40, "Notes",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[35382, 1266, 98, 1, 38, "ExampleSection",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[35483, 1269, 173, 4, 24, "Text",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[35681, 1277, 160, 3, 26, "Input",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[35844, 1282, 218, 4, 21, "Message",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[36065, 1288, 156, 3, 21, "Output",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[36236, 1294, 206, 5, 24, "Text",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[36467, 1303, 167, 3, 26, "Input",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
    Cell[36637, 1308, 146, 3, 36, "Output",
      CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}]},
  "General::cfail"->{
    Cell[36844, 1318, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::cfail"],
    Cell[36928, 1321, 225, 7, 21, "Message",
      CellTags->"General::cfail"],
    Cell[37156, 1330, 534, 13, 78, "Notes",
      CellTags->"General::cfail"]},
  "LUDecomposition::sq"->{
    Cell[37727, 1348, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LUDecomposition::sq"],
    Cell[37821, 1351, 175, 3, 21, "Message",
      CellTags->"LUDecomposition::sq"],
    Cell[37999, 1356, 199, 6, 24, "Notes",
      CellTags->"LUDecomposition::sq"]},
  "General::tol"->{
    Cell[38235, 1367, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::tol"],
    Cell[38315, 1370, 507, 16, 37, "Message",
      CellTags->"General::tol"],
    Cell[38825, 1388, 201, 5, 24, "Notes",
      CellTags->"General::tol"],
    Cell[39051, 1397, 62, 1, 38, "ExampleSection",
      CellTags->"General::tol"],
    Cell[39116, 1400, 165, 7, 24, "Text",
      CellTags->"General::tol"],
    Cell[39306, 1411, 173, 4, 42, "Input",
      CellTags->"General::tol"],
    Cell[39482, 1417, 223, 5, 37, "Message",
      CellTags->"General::tol"],
    Cell[39708, 1424, 188, 4, 37, "Output",
      CellTags->"General::tol"],
    Cell[39911, 1431, 138, 5, 24, "Text",
      CellTags->"General::tol"],
    Cell[40074, 1440, 172, 4, 42, "Input",
      CellTags->"General::tol"],
    Cell[40249, 1446, 260, 5, 39, "Output",
      CellTags->"General::tol"]},
  "Dot::rect"->{
    Cell[40570, 1458, 102, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[40675, 1464, 299, 8, 21, "Message",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[40977, 1474, 268, 7, 40, "Notes",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[41270, 1485, 73, 1, 38, "ExampleSection",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[41346, 1488, 147, 4, 24, "Text",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[41518, 1496, 110, 3, 26, "Input",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[41631, 1501, 175, 4, 21, "Message",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[41809, 1507, 111, 3, 21, "Output",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[41935, 1513, 111, 1, 24, "Text",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[42071, 1518, 112, 3, 26, "Input",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[42186, 1523, 103, 3, 21, "Output",
      CellTags->{"Dot::rect", "Tr::rect"}]},
  "Tr::rect"->{
    Cell[40570, 1458, 102, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[40675, 1464, 299, 8, 21, "Message",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[40977, 1474, 268, 7, 40, "Notes",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[41270, 1485, 73, 1, 38, "ExampleSection",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[41346, 1488, 147, 4, 24, "Text",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[41518, 1496, 110, 3, 26, "Input",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[41631, 1501, 175, 4, 21, "Message",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[41809, 1507, 111, 3, 21, "Output",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[41935, 1513, 111, 1, 24, "Text",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[42071, 1518, 112, 3, 26, "Input",
      CellTags->{"Dot::rect", "Tr::rect"}],
    Cell[42186, 1523, 103, 3, 21, "Output",
      CellTags->{"Dot::rect", "Tr::rect"}]},
  "DiagonalMatrix::vec"->{
    Cell[42350, 1533, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DiagonalMatrix::vec"],
    Cell[42444, 1536, 258, 5, 37, "Message",
      CellTags->"DiagonalMatrix::vec"],
    Cell[42705, 1543, 252, 6, 40, "Notes",
      CellTags->"DiagonalMatrix::vec"],
    Cell[42982, 1553, 69, 1, 38, "ExampleSection",
      CellTags->"DiagonalMatrix::vec"],
    Cell[43054, 1556, 200, 6, 40, "Text",
      CellTags->"DiagonalMatrix::vec"],
    Cell[43279, 1566, 124, 3, 26, "Input",
      CellTags->"DiagonalMatrix::vec"],
    Cell[43406, 1571, 236, 5, 37, "Message",
      CellTags->"DiagonalMatrix::vec"],
    Cell[43645, 1578, 125, 3, 21, "Output",
      CellTags->"DiagonalMatrix::vec"],
    Cell[43785, 1584, 136, 5, 24, "Text",
      CellTags->"DiagonalMatrix::vec"],
    Cell[43946, 1593, 114, 3, 26, "Input",
      CellTags->"DiagonalMatrix::vec"],
    Cell[44063, 1598, 109, 3, 21, "Output",
      CellTags->"DiagonalMatrix::vec"]},
  "Dot::dotsh"->{
    Cell[44233, 1608, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Dot::dotsh"],
    Cell[44309, 1611, 326, 9, 21, "Message",
      CellTags->"Dot::dotsh"],
    Cell[44638, 1622, 298, 6, 56, "Notes",
      CellTags->"Dot::dotsh"],
    Cell[44961, 1632, 60, 1, 38, "ExampleSection",
      CellTags->"Dot::dotsh"],
    Cell[45024, 1635, 199, 5, 40, "Text",
      CellTags->"Dot::dotsh"],
    Cell[45248, 1644, 113, 3, 26, "Input",
      CellTags->"Dot::dotsh"],
    Cell[45364, 1649, 232, 5, 37, "Message",
      CellTags->"Dot::dotsh"],
    Cell[45599, 1656, 114, 3, 21, "Output",
      CellTags->"Dot::dotsh"],
    Cell[45728, 1662, 126, 4, 24, "Text",
      CellTags->"Dot::dotsh"],
    Cell[45879, 1670, 115, 3, 26, "Input",
      CellTags->"Dot::dotsh"],
    Cell[45997, 1675, 126, 3, 21, "Output",
      CellTags->"Dot::dotsh"]},
  "Dot::dotpat"->{
    Cell[46184, 1685, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Dot::dotpat"],
    Cell[46262, 1688, 192, 5, 37, "Message",
      CellTags->"Dot::dotpat"],
    Cell[46457, 1695, 122, 4, 24, "Notes",
      CellTags->"Dot::dotpat"]},
  "General::eivn"->{
    Cell[46616, 1704, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::eivn"],
    Cell[46698, 1707, 514, 16, 37, "Message",
      CellTags->"General::eivn"],
    Cell[47215, 1725, 671, 11, 122, "Notes",
      CellTags->"General::eivn"]},
  "General::eivec"->{
    Cell[47923, 1741, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::eivec"],
    Cell[48007, 1744, 394, 12, 21, "Message",
      CellTags->"General::eivec"],
    Cell[48404, 1758, 712, 13, 122, "Notes",
      CellTags->"General::eivec"]},
  "General::eival"->{
    Cell[49153, 1776, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::eival"],
    Cell[49237, 1779, 268, 7, 21, "Message",
      CellTags->"General::eival"],
    Cell[49508, 1788, 616, 11, 106, "Notes",
      CellTags->"General::eival"]},
  "General::inf"->{
    Cell[50161, 1804, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::inf"],
    Cell[50241, 1807, 243, 7, 21, "Message",
      CellTags->"General::inf"],
    Cell[50487, 1816, 518, 16, 78, "Notes",
      CellTags->"General::inf"]},
  "General::pvec"->{
    Cell[51042, 1837, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::pvec"],
    Cell[51124, 1840, 406, 12, 21, "Message",
      CellTags->"General::pvec"],
    Cell[51533, 1854, 330, 7, 46, "Notes",
      CellTags->"General::pvec"]},
  "General::sing"->{
    Cell[51900, 1866, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sing"],
    Cell[51982, 1869, 316, 9, 21, "Message",
      CellTags->"General::sing"],
    Cell[52301, 1880, 167, 4, 24, "Notes",
      CellTags->"General::sing"],
    Cell[52493, 1888, 63, 1, 38, "ExampleSection",
      CellTags->"General::sing"],
    Cell[52559, 1891, 132, 4, 24, "Text",
      CellTags->"General::sing"],
    Cell[52716, 1899, 111, 3, 26, "Input",
      CellTags->"General::sing"],
    Cell[52830, 1904, 194, 5, 21, "Message",
      CellTags->"General::sing"],
    Cell[53027, 1911, 112, 3, 21, "Output",
      CellTags->"General::sing"]},
  "Inner::incom"->{
    Cell[53200, 1921, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Inner::incom"],
    Cell[53280, 1924, 561, 16, 37, "Message",
      CellTags->"Inner::incom"],
    Cell[53844, 1942, 192, 5, 24, "Notes",
      CellTags->"Inner::incom"],
    Cell[54061, 1951, 62, 1, 38, "ExampleSection",
      CellTags->"Inner::incom"],
    Cell[54126, 1954, 228, 5, 40, "Text",
      CellTags->"Inner::incom"],
    Cell[54379, 1963, 118, 3, 26, "Input",
      CellTags->"Inner::incom"],
    Cell[54500, 1968, 279, 6, 37, "Message",
      CellTags->"Inner::incom"],
    Cell[54782, 1976, 119, 3, 21, "Output",
      CellTags->"Inner::incom"],
    Cell[54916, 1982, 120, 5, 24, "Text",
      CellTags->"Inner::incom"],
    Cell[55061, 1991, 116, 3, 26, "Input",
      CellTags->"Inner::incom"],
    Cell[55180, 1996, 90, 3, 21, "Output",
      CellTags->"Inner::incom"],
    Cell[55285, 2002, 142, 5, 24, "Text",
      CellTags->"Inner::incom"],
    Cell[55452, 2011, 129, 3, 26, "Input",
      CellTags->"Inner::incom"],
    Cell[55584, 2016, 90, 3, 21, "Output",
      CellTags->"Inner::incom"],
    Cell[55689, 2022, 204, 6, 40, "Text",
      CellTags->"Inner::incom"],
    Cell[55918, 2032, 128, 3, 26, "Input",
      CellTags->"Inner::incom"],
    Cell[56049, 2037, 92, 3, 21, "Output",
      CellTags->"Inner::incom"]},
  "Inner::inntf"->{
    Cell[56202, 2047, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Inner::inntf"],
    Cell[56282, 2050, 204, 5, 21, "Message",
      CellTags->"Inner::inntf"],
    Cell[56489, 2057, 464, 10, 84, "Notes",
      CellTags->"Inner::inntf"]},
  "Inner::nolev"->{
    Cell[56990, 2072, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Inner::nolev"],
    Cell[57070, 2075, 449, 13, 21, "Message",
      CellTags->"Inner::nolev"],
    Cell[57522, 2090, 239, 6, 40, "Notes",
      CellTags->"Inner::nolev"],
    Cell[57786, 2100, 62, 1, 38, "ExampleSection",
      CellTags->"Inner::nolev"],
    Cell[57851, 2103, 193, 5, 40, "Text",
      CellTags->"Inner::nolev"],
    Cell[58069, 2112, 130, 3, 26, "Input",
      CellTags->"Inner::nolev"],
    Cell[58202, 2117, 226, 5, 37, "Message",
      CellTags->"Inner::nolev"],
    Cell[58431, 2124, 131, 3, 21, "Output",
      CellTags->"Inner::nolev"],
    Cell[58577, 2130, 124, 5, 24, "Text",
      CellTags->"Inner::nolev"],
    Cell[58726, 2139, 135, 3, 26, "Input",
      CellTags->"Inner::nolev"],
    Cell[58864, 2144, 108, 3, 21, "Output",
      CellTags->"Inner::nolev"]},
  "LUBackSubstitution::bpvt"->{
    Cell[59033, 2154, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[59137, 2157, 259, 5, 21, "Message",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[59399, 2164, 465, 10, 84, "Notes",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[59889, 2178, 74, 1, 38, "ExampleSection",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[59966, 2181, 183, 4, 40, "Text",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[60174, 2189, 155, 3, 26, "Input",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[60332, 2194, 206, 4, 21, "Message",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[60541, 2200, 158, 4, 21, "Output",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[60714, 2207, 157, 5, 24, "Text",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[60896, 2216, 154, 3, 26, "Input",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[61053, 2221, 109, 3, 21, "Output",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[61177, 2227, 223, 7, 40, "Text",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[61425, 2238, 138, 3, 26, "Input",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[61566, 2243, 127, 3, 21, "Output",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[61730, 2251, 130, 3, 26, "Input",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[61863, 2256, 109, 3, 21, "Output",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[61987, 2262, 140, 4, 24, "Text",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[62152, 2270, 134, 3, 26, "Input",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[62289, 2275, 109, 3, 21, "Output",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[62413, 2281, 125, 5, 24, "Text",
      CellTags->"LUBackSubstitution::bpvt"],
    Cell[62541, 2288, 109, 3, 26, "Input",
      CellTags->"LUBackSubstitution::bpvt"]},
  "LinearSolve::lsfail"->{
    Cell[62699, 2297, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::lsfail"],
    Cell[62793, 2300, 192, 3, 37, "Message",
      CellTags->"LinearSolve::lsfail"],
    Cell[62988, 2305, 199, 6, 24, "Notes",
      CellTags->"LinearSolve::lsfail"]},
  "General::lslc"->{
    Cell[63224, 2316, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::lslc"],
    Cell[63306, 2319, 307, 9, 37, "Message",
      CellTags->"General::lslc"],
    Cell[63616, 2330, 341, 9, 46, "Notes",
      CellTags->"General::lslc"],
    Cell[63982, 2343, 63, 1, 38, "ExampleSection",
      CellTags->"General::lslc"],
    Cell[64048, 2346, 218, 5, 40, "Text",
      CellTags->"General::lslc"],
    Cell[64291, 2355, 129, 3, 26, "Input",
      CellTags->"General::lslc"],
    Cell[64423, 2360, 219, 5, 37, "Message",
      CellTags->"General::lslc"],
    Cell[64645, 2367, 130, 3, 21, "Output",
      CellTags->"General::lslc"],
    Cell[64790, 2373, 140, 5, 24, "Text",
      CellTags->"General::lslc"],
    Cell[64955, 2382, 123, 3, 26, "Input",
      CellTags->"General::lslc"],
    Cell[65081, 2387, 108, 3, 36, "Output",
      CellTags->"General::lslc"],
    Cell[65226, 2395, 139, 3, 26, "Input",
      CellTags->"General::lslc"],
    Cell[65368, 2400, 144, 3, 36, "Output",
      CellTags->"General::lslc"]},
  "General::lsv"->{
    Cell[65573, 2410, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::lsv"],
    Cell[65653, 2413, 465, 13, 37, "Message",
      CellTags->"General::lsv"],
    Cell[66121, 2428, 312, 9, 46, "Notes",
      CellTags->"General::lsv"]},
  "LinearSolve::nosol"->{
    Cell[66470, 2442, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::nosol"],
    Cell[66562, 2445, 180, 3, 21, "Message",
      CellTags->"LinearSolve::nosol"],
    Cell[66745, 2450, 187, 5, 24, "Notes",
      CellTags->"LinearSolve::nosol"],
    Cell[66957, 2459, 68, 1, 38, "ExampleSection",
      CellTags->"LinearSolve::nosol"],
    Cell[67028, 2462, 139, 4, 24, "Text",
      CellTags->"LinearSolve::nosol"],
    Cell[67192, 2470, 128, 3, 26, "Input",
      CellTags->"LinearSolve::nosol"],
    Cell[67323, 2475, 194, 4, 37, "Message",
      CellTags->"LinearSolve::nosol"],
    Cell[67520, 2481, 129, 3, 21, "Output",
      CellTags->"LinearSolve::nosol"],
    Cell[67664, 2487, 138, 5, 24, "Text",
      CellTags->"LinearSolve::nosol"],
    Cell[67827, 2496, 139, 3, 26, "Input",
      CellTags->"LinearSolve::nosol"],
    Cell[67969, 2501, 94, 3, 21, "Output",
      CellTags->"LinearSolve::nosol"],
    Cell[68078, 2507, 121, 4, 24, "Text",
      CellTags->"LinearSolve::nosol"],
    Cell[68224, 2515, 128, 3, 26, "Input",
      CellTags->"LinearSolve::nosol"],
    Cell[68355, 2520, 98, 3, 21, "Output",
      CellTags->"LinearSolve::nosol"]},
  "RowReduce::rmeth"->{
    Cell[68514, 2530, 214, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[68731, 2540, 652, 18, 53, "Message",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[69386, 2560, 300, 8, 40, "Notes",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[69711, 2572, 136, 3, 38, "ExampleSection",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[69850, 2577, 324, 11, 40, "Text",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[70199, 2592, 249, 6, 42, "Input",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[70451, 2600, 345, 8, 53, "Message",
      CellTags->{
      "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "RowReduce::rmeth"}],
    Cell[70799, 2610, 255, 6, 37, "Output",
      CellTags->{
      "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "RowReduce::rmeth"}],
    Cell[71069, 2619, 248, 9, 24, "Text",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[71342, 2632, 255, 6, 42, "Input",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[71600, 2640, 1769, 31, 293, "Output",
      CellTags->{
      "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "RowReduce::rmeth"}]},
  "LinearSolve::rmeth"->{
    Cell[68514, 2530, 214, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[68731, 2540, 652, 18, 53, "Message",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[69386, 2560, 300, 8, 40, "Notes",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[69711, 2572, 136, 3, 38, "ExampleSection",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[69850, 2577, 324, 11, 40, "Text",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[70199, 2592, 249, 6, 42, "Input",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[70451, 2600, 345, 8, 53, "Message",
      CellTags->{
      "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "RowReduce::rmeth"}],
    Cell[70799, 2610, 255, 6, 37, "Output",
      CellTags->{
      "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "RowReduce::rmeth"}],
    Cell[71069, 2619, 248, 9, 24, "Text",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[71342, 2632, 255, 6, 42, "Input",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[71600, 2640, 1769, 31, 293, "Output",
      CellTags->{
      "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "RowReduce::rmeth"}]},
  "NullSpace::rmeth"->{
    Cell[68514, 2530, 214, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[68731, 2540, 652, 18, 53, "Message",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[69386, 2560, 300, 8, 40, "Notes",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[69711, 2572, 136, 3, 38, "ExampleSection",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[69850, 2577, 324, 11, 40, "Text",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[70199, 2592, 249, 6, 42, "Input",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[70451, 2600, 345, 8, 53, "Message",
      CellTags->{
      "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "RowReduce::rmeth"}],
    Cell[70799, 2610, 255, 6, 37, "Output",
      CellTags->{
      "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "RowReduce::rmeth"}],
    Cell[71069, 2619, 248, 9, 24, "Text",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[71342, 2632, 255, 6, 42, "Input",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[71600, 2640, 1769, 31, 293, "Output",
      CellTags->{
      "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "RowReduce::rmeth"}]},
  "Inverse::rmeth"->{
    Cell[68514, 2530, 214, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[68731, 2540, 652, 18, 53, "Message",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[69386, 2560, 300, 8, 40, "Notes",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[69711, 2572, 136, 3, 38, "ExampleSection",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[69850, 2577, 324, 11, 40, "Text",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[70199, 2592, 249, 6, 42, "Input",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[70451, 2600, 345, 8, 53, "Message",
      CellTags->{
      "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "RowReduce::rmeth"}],
    Cell[70799, 2610, 255, 6, 37, "Output",
      CellTags->{
      "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "RowReduce::rmeth"}],
    Cell[71069, 2619, 248, 9, 24, "Text",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[71342, 2632, 255, 6, 42, "Input",
      CellTags->{
      "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "Inverse::rmeth"}],
    Cell[71600, 2640, 1769, 31, 293, "Output",
      CellTags->{
      "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
        "RowReduce::rmeth"}]},
  "SchurDecomposition::schurf"->{
    Cell[73430, 2678, 205, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[73638, 2685, 467, 12, 21, "Message",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[74108, 2699, 324, 7, 40, "Notes",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[74457, 2710, 126, 2, 38, "ExampleSection",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[74586, 2714, 198, 5, 24, "Text",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[74809, 2723, 185, 4, 26, "Input",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[74997, 2729, 283, 6, 37, "Message",
      CellTags->{
      "Developer`HessenbergDecomposition::schurf", 
        "SchurDecomposition::schurf"}],
    Cell[75283, 2737, 186, 4, 21, "Output",
      CellTags->{
      "Developer`HessenbergDecomposition::schurf", 
        "SchurDecomposition::schurf"}],
    Cell[75484, 2744, 202, 5, 24, "Text",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[75711, 2753, 188, 4, 26, "Input",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[75902, 2759, 202, 4, 21, "Output",
      CellTags->{
      "Developer`HessenbergDecomposition::schurf", 
        "SchurDecomposition::schurf"}]},
  "Developer`HessenbergDecomposition::schurf"->{
    Cell[73430, 2678, 205, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[73638, 2685, 467, 12, 21, "Message",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[74108, 2699, 324, 7, 40, "Notes",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[74457, 2710, 126, 2, 38, "ExampleSection",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[74586, 2714, 198, 5, 24, "Text",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[74809, 2723, 185, 4, 26, "Input",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[74997, 2729, 283, 6, 37, "Message",
      CellTags->{
      "Developer`HessenbergDecomposition::schurf", 
        "SchurDecomposition::schurf"}],
    Cell[75283, 2737, 186, 4, 21, "Output",
      CellTags->{
      "Developer`HessenbergDecomposition::schurf", 
        "SchurDecomposition::schurf"}],
    Cell[75484, 2744, 202, 5, 24, "Text",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[75711, 2753, 188, 4, 26, "Input",
      CellTags->{
      "SchurDecomposition::schurf", 
        "Developer`HessenbergDecomposition::schurf"}],
    Cell[75902, 2759, 202, 4, 21, "Output",
      CellTags->{
      "Developer`HessenbergDecomposition::schurf", 
        "SchurDecomposition::schurf"}]},
  "SchurDecomposition::schurn"->{
    Cell[76165, 2770, 205, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[76373, 2777, 501, 14, 21, "Message",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[76877, 2793, 287, 6, 40, "Notes",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[77189, 2803, 126, 2, 38, "ExampleSection",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[77318, 2807, 197, 5, 24, "Text",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[77540, 2816, 189, 4, 26, "Input",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[77732, 2822, 285, 6, 37, "Message",
      CellTags->{
      "Developer`HessenbergDecomposition::schurn", 
        "SchurDecomposition::schurn"}],
    Cell[78020, 2830, 191, 4, 21, "Output",
      CellTags->{
      "Developer`HessenbergDecomposition::schurn", 
        "SchurDecomposition::schurn"}],
    Cell[78226, 2837, 202, 6, 24, "Text",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[78453, 2847, 204, 4, 26, "Input",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[78660, 2853, 323, 6, 37, "Output",
      CellTags->{
      "Developer`HessenbergDecomposition::schurn", 
        "SchurDecomposition::schurn"}]},
  "Developer`HessenbergDecomposition::schurn"->{
    Cell[76165, 2770, 205, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[76373, 2777, 501, 14, 21, "Message",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[76877, 2793, 287, 6, 40, "Notes",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[77189, 2803, 126, 2, 38, "ExampleSection",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[77318, 2807, 197, 5, 24, "Text",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[77540, 2816, 189, 4, 26, "Input",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[77732, 2822, 285, 6, 37, "Message",
      CellTags->{
      "Developer`HessenbergDecomposition::schurn", 
        "SchurDecomposition::schurn"}],
    Cell[78020, 2830, 191, 4, 21, "Output",
      CellTags->{
      "Developer`HessenbergDecomposition::schurn", 
        "SchurDecomposition::schurn"}],
    Cell[78226, 2837, 202, 6, 24, "Text",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[78453, 2847, 204, 4, 26, "Input",
      CellTags->{
      "SchurDecomposition::schurn", 
        "Developer`HessenbergDecomposition::schurn"}],
    Cell[78660, 2853, 323, 6, 37, "Output",
      CellTags->{
      "Developer`HessenbergDecomposition::schurn", 
        "SchurDecomposition::schurn"}]},
  "General::unpack1"->{
    Cell[79044, 2866, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::unpack1"],
    Cell[79132, 2869, 223, 7, 21, "Message",
      CellTags->"General::unpack1"],
    Cell[79358, 2878, 382, 8, 68, "Notes",
      CellTags->"General::unpack1"],
    Cell[79765, 2890, 66, 1, 38, "ExampleSection",
      CellTags->"General::unpack1"],
    Cell[79834, 2893, 153, 4, 24, "Text",
      CellTags->"General::unpack1"],
    Cell[80012, 2901, 151, 4, 26, "Input",
      CellTags->"General::unpack1"],
    Cell[80166, 2907, 118, 3, 21, "Output",
      CellTags->"General::unpack1"],
    Cell[80321, 2915, 140, 3, 26, "Input",
      CellTags->"General::unpack1"],
    Cell[80464, 2920, 174, 4, 21, "Message",
      CellTags->"General::unpack1"],
    Cell[80641, 2926, 108, 3, 21, "Output",
      CellTags->"General::unpack1"],
    Cell[80764, 2932, 75, 1, 24, "Text",
      CellTags->"General::unpack1"],
    Cell[80864, 2937, 159, 4, 26, "Input",
      CellTags->"General::unpack1"],
    Cell[81026, 2943, 119, 3, 21, "Output",
      CellTags->"General::unpack1"]},
  "General::unpack"->{
    Cell[81206, 2953, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::unpack"],
    Cell[81292, 2956, 363, 11, 21, "Message",
      CellTags->"General::unpack"],
    Cell[81658, 2969, 381, 8, 68, "Notes",
      CellTags->"General::unpack"],
    Cell[82064, 2981, 65, 1, 38, "ExampleSection",
      CellTags->"General::unpack"],
    Cell[82132, 2984, 153, 4, 24, "Text",
      CellTags->"General::unpack"],
    Cell[82310, 2992, 150, 4, 26, "Input",
      CellTags->"General::unpack"],
    Cell[82463, 2998, 117, 3, 21, "Output",
      CellTags->"General::unpack"],
    Cell[82617, 3006, 125, 3, 26, "Input",
      CellTags->"General::unpack"],
    Cell[82745, 3011, 173, 4, 21, "Message",
      CellTags->"General::unpack"],
    Cell[82921, 3017, 139, 3, 21, "Output",
      CellTags->"General::unpack"],
    Cell[83075, 3023, 74, 1, 24, "Text",
      CellTags->"General::unpack"],
    Cell[83174, 3028, 158, 4, 26, "Input",
      CellTags->"General::unpack"],
    Cell[83335, 3034, 118, 3, 21, "Output",
      CellTags->"General::unpack"]},
  "General::punpack"->{
    Cell[83514, 3044, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::punpack"],
    Cell[83602, 3047, 431, 13, 21, "Message",
      CellTags->"General::punpack"],
    Cell[84036, 3062, 392, 8, 68, "Notes",
      CellTags->"General::punpack"]},
  "General::punpack1"->{
    Cell[84465, 3075, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::punpack1"],
    Cell[84555, 3078, 357, 11, 21, "Message",
      CellTags->"General::punpack1"],
    Cell[84915, 3091, 393, 8, 68, "Notes",
      CellTags->"General::punpack1"]},
  "Testing`Internal`MVectorNorm::mrange"->{
    Cell[85345, 3104, 125, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Testing`Internal`MVectorNorm::mrange"],
    Cell[85473, 3107, 243, 4, 37, "Message",
      CellTags->"Testing`Internal`MVectorNorm::mrange"],
    Cell[85719, 3113, 147, 4, 24, "Notes",
      CellTags->"Testing`Internal`MVectorNorm::mrange"]},
  "Testing`Internal`MVectorNorm::mvntestp"->{
    Cell[85903, 3122, 129, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Testing`Internal`MVectorNorm::mvntestp"],
    Cell[86035, 3125, 266, 4, 53, "Message",
      CellTags->"Testing`Internal`MVectorNorm::mvntestp"],
    Cell[86304, 3131, 149, 4, 24, "Notes",
      CellTags->"Testing`Internal`MVectorNorm::mvntestp"]},
  "Testing`Internal`MVectorNorm::mvntestv"->{
    Cell[86490, 3140, 129, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Testing`Internal`MVectorNorm::mvntestv"],
    Cell[86622, 3143, 271, 4, 53, "Message",
      CellTags->"Testing`Internal`MVectorNorm::mvntestv"],
    Cell[86896, 3149, 149, 4, 24, "Notes",
      CellTags->"Testing`Internal`MVectorNorm::mvntestv"]},
  "Testing`Internal`MScaledVectorNorm::mrange"->{
    Cell[87082, 3158, 137, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Testing`Internal`MScaledVectorNorm::mrange"],
    Cell[87222, 3161, 255, 4, 37, "Message",
      CellTags->"Testing`Internal`MScaledVectorNorm::mrange"],
    Cell[87480, 3167, 153, 4, 24, "Notes",
      CellTags->"Testing`Internal`MScaledVectorNorm::mrange"]},
  "Testing`Internal`MScaledVectorNorm::mvntestp"->{
    Cell[87670, 3176, 143, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Testing`Internal`MScaledVectorNorm::mvntestp"],
    Cell[87816, 3180, 278, 4, 53, "Message",
      CellTags->"Testing`Internal`MScaledVectorNorm::mvntestp"],
    Cell[88097, 3186, 155, 4, 24, "Notes",
      CellTags->"Testing`Internal`MScaledVectorNorm::mvntestp"]},
  "Testing`Internal`MScaledVectorNorm::mvntestv"->{
    Cell[88289, 3195, 143, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Testing`Internal`MScaledVectorNorm::mvntestv"],
    Cell[88435, 3199, 283, 4, 53, "Message",
      CellTags->"Testing`Internal`MScaledVectorNorm::mvntestv"],
    Cell[88721, 3205, 155, 4, 24, "Notes",
      CellTags->"Testing`Internal`MScaledVectorNorm::mvntestv"]},
  "Inverse::invc"->{
    Cell[88913, 3214, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Inverse::invc"],
    Cell[88995, 3217, 340, 7, 37, "Message",
      CellTags->"Inverse::invc"],
    Cell[89338, 3226, 193, 6, 24, "Notes",
      CellTags->"Inverse::invc"]},
  "MatrixPower::zvec"->{
    Cell[89568, 3237, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"MatrixPower::zvec", "MatrixExp::zvec"}],
    Cell[89703, 3243, 508, 14, 37, "Message",
      CellTags->{"MatrixPower::zvec", "MatrixExp::zvec"}],
    Cell[90214, 3259, 409, 8, 78, "Notes",
      CellTags->{"MatrixPower::zvec", "MatrixExp::zvec"}]},
  "MatrixExp::zvec"->{
    Cell[89568, 3237, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"MatrixPower::zvec", "MatrixExp::zvec"}],
    Cell[89703, 3243, 508, 14, 37, "Message",
      CellTags->{"MatrixPower::zvec", "MatrixExp::zvec"}],
    Cell[90214, 3259, 409, 8, 78, "Notes",
      CellTags->{"MatrixPower::zvec", "MatrixExp::zvec"}]},
  "Range::range"->{
    Cell[90660, 3272, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Range::range"],
    Cell[90740, 3275, 274, 6, 21, "Message",
      CellTags->"Range::range"],
    Cell[91017, 3283, 269, 6, 40, "Notes",
      CellTags->"Range::range"],
    Cell[91311, 3293, 62, 1, 38, "ExampleSection",
      CellTags->"Range::range"],
    Cell[91376, 3296, 127, 4, 24, "Text",
      CellTags->"Range::range"],
    Cell[91528, 3304, 96, 3, 26, "Input",
      CellTags->"Range::range"],
    Cell[91627, 3309, 226, 5, 37, "Message",
      CellTags->"Range::range"],
    Cell[91856, 3316, 109, 3, 21, "Output",
      CellTags->"Range::range"],
    Cell[91980, 3322, 125, 5, 24, "Text",
      CellTags->"Range::range"],
    Cell[92130, 3331, 93, 3, 26, "Input",
      CellTags->"Range::range"],
    Cell[92226, 3336, 95, 3, 21, "Output",
      CellTags->"Range::range"]},
  "Transpose::diagnl"->{
    Cell[92382, 3346, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Transpose::diagnl"],
    Cell[92472, 3349, 290, 6, 37, "Message",
      CellTags->"Transpose::diagnl"],
    Cell[92765, 3357, 290, 7, 40, "Notes",
      CellTags->"Transpose::diagnl"],
    Cell[93080, 3368, 67, 1, 38, "ExampleSection",
      CellTags->"Transpose::diagnl"],
    Cell[93150, 3371, 157, 4, 24, "Text",
      CellTags->"Transpose::diagnl"],
    Cell[93332, 3379, 133, 3, 26, "Input",
      CellTags->"Transpose::diagnl"],
    Cell[93468, 3384, 232, 5, 37, "Message",
      CellTags->"Transpose::diagnl"],
    Cell[93703, 3391, 134, 3, 21, "Output",
      CellTags->"Transpose::diagnl"],
    Cell[93852, 3397, 155, 4, 24, "Text",
      CellTags->"Transpose::diagnl"],
    Cell[94032, 3405, 125, 3, 26, "Input",
      CellTags->"Transpose::diagnl"],
    Cell[94160, 3410, 97, 3, 21, "Output",
      CellTags->"Transpose::diagnl"]},
  "Transpose::newdims"->{
    Cell[94318, 3420, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Transpose::newdims"],
    Cell[94410, 3423, 414, 11, 37, "Message",
      CellTags->"Transpose::newdims"],
    Cell[94827, 3436, 197, 5, 40, "Notes",
      CellTags->"Transpose::newdims"],
    Cell[95049, 3445, 68, 1, 38, "ExampleSection",
      CellTags->"Transpose::newdims"],
    Cell[95120, 3448, 166, 4, 24, "Text",
      CellTags->"Transpose::newdims"],
    Cell[95311, 3456, 133, 3, 26, "Input",
      CellTags->"Transpose::newdims"],
    Cell[95447, 3461, 229, 5, 37, "Message",
      CellTags->"Transpose::newdims"],
    Cell[95679, 3468, 134, 3, 21, "Output",
      CellTags->"Transpose::newdims"],
    Cell[95828, 3474, 152, 5, 24, "Text",
      CellTags->"Transpose::newdims"],
    Cell[96005, 3483, 133, 3, 26, "Input",
      CellTags->"Transpose::newdims"],
    Cell[96141, 3488, 116, 3, 21, "Output",
      CellTags->"Transpose::newdims"]},
  "Transpose::nmtx"->{
    Cell[96318, 3498, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Transpose::nmtx"],
    Cell[96404, 3501, 289, 6, 37, "Message",
      CellTags->"Transpose::nmtx"],
    Cell[96696, 3509, 176, 5, 24, "Notes",
      CellTags->"Transpose::nmtx"],
    Cell[96897, 3518, 65, 1, 38, "ExampleSection",
      CellTags->"Transpose::nmtx"],
    Cell[96965, 3521, 190, 5, 24, "Text",
      CellTags->"Transpose::nmtx"],
    Cell[97180, 3530, 108, 3, 26, "Input",
      CellTags->"Transpose::nmtx"],
    Cell[97291, 3535, 226, 5, 37, "Message",
      CellTags->"Transpose::nmtx"],
    Cell[97520, 3542, 109, 3, 21, "Output",
      CellTags->"Transpose::nmtx"],
    Cell[97644, 3548, 139, 5, 24, "Text",
      CellTags->"Transpose::nmtx"],
    Cell[97808, 3557, 110, 3, 26, "Input",
      CellTags->"Transpose::nmtx"],
    Cell[97921, 3562, 104, 3, 21, "Output",
      CellTags->"Transpose::nmtx"],
    Cell[98040, 3568, 215, 7, 24, "Text",
      CellTags->"Transpose::nmtx"],
    Cell[98280, 3579, 113, 3, 26, "Input",
      CellTags->"Transpose::nmtx"],
    Cell[98396, 3584, 98, 3, 21, "Output",
      CellTags->"Transpose::nmtx"]},
  "Transpose::tperm"->{
    Cell[98555, 3594, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Transpose::tperm"],
    Cell[98643, 3597, 401, 10, 37, "Message",
      CellTags->"Transpose::tperm"],
    Cell[99047, 3609, 248, 6, 40, "Notes",
      CellTags->"Transpose::tperm"],
    Cell[99320, 3619, 66, 1, 38, "ExampleSection",
      CellTags->"Transpose::tperm"],
    Cell[99389, 3622, 245, 6, 40, "Text",
      CellTags->"Transpose::tperm"],
    Cell[99659, 3632, 117, 3, 26, "Input",
      CellTags->"Transpose::tperm"],
    Cell[99779, 3637, 220, 5, 37, "Message",
      CellTags->"Transpose::tperm"],
    Cell[100002, 3644, 118, 3, 21, "Output",
      CellTags->"Transpose::tperm"],
    Cell[100135, 3650, 186, 5, 24, "Text",
      CellTags->"Transpose::tperm"],
    Cell[100346, 3659, 114, 3, 26, "Input",
      CellTags->"Transpose::tperm"],
    Cell[100463, 3664, 99, 3, 21, "Output",
      CellTags->"Transpose::tperm"]},
  "Transpose::perm"->{
    Cell[100623, 3674, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Transpose::perm"],
    Cell[100709, 3677, 419, 11, 37, "Message",
      CellTags->"Transpose::perm"],
    Cell[101131, 3690, 195, 6, 24, "Notes",
      CellTags->"Transpose::perm"]},
  "Transpose::perm1"->{
    Cell[101363, 3701, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Transpose::perm1"],
    Cell[101451, 3704, 358, 9, 37, "Message",
      CellTags->"Transpose::perm1"],
    Cell[101812, 3715, 293, 7, 40, "Notes",
      CellTags->"Transpose::perm1"],
    Cell[102130, 3726, 66, 1, 38, "ExampleSection",
      CellTags->"Transpose::perm1"],
    Cell[102199, 3729, 215, 6, 40, "Text",
      CellTags->"Transpose::perm1"],
    Cell[102439, 3739, 126, 3, 26, "Input",
      CellTags->"Transpose::perm1"],
    Cell[102568, 3744, 229, 5, 37, "Message",
      CellTags->"Transpose::perm1"],
    Cell[102800, 3751, 127, 3, 21, "Output",
      CellTags->"Transpose::perm1"],
    Cell[102942, 3757, 132, 5, 24, "Text",
      CellTags->"Transpose::perm1"],
    Cell[103099, 3766, 124, 3, 26, "Input",
      CellTags->"Transpose::perm1"],
    Cell[103226, 3771, 106, 3, 21, "Output",
      CellTags->"Transpose::perm1"]},
  "Transpose::perm2"->{
    Cell[103393, 3781, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Transpose::perm2"],
    Cell[103481, 3784, 372, 10, 21, "Message",
      CellTags->"Transpose::perm2"],
    Cell[103856, 3796, 281, 7, 40, "Notes",
      CellTags->"Transpose::perm2"],
    Cell[104162, 3807, 66, 1, 38, "ExampleSection",
      CellTags->"Transpose::perm2"],
    Cell[104231, 3810, 231, 5, 40, "Text",
      CellTags->"Transpose::perm2"],
    Cell[104487, 3819, 124, 3, 26, "Input",
      CellTags->"Transpose::perm2"],
    Cell[104614, 3824, 202, 5, 21, "Message",
      CellTags->"Transpose::perm2"],
    Cell[104819, 3831, 125, 3, 21, "Output",
      CellTags->"Transpose::perm2"],
    Cell[104959, 3837, 132, 5, 24, "Text",
      CellTags->"Transpose::perm2"],
    Cell[105116, 3846, 124, 3, 26, "Input",
      CellTags->"Transpose::perm2"],
    Cell[105243, 3851, 106, 3, 21, "Output",
      CellTags->"Transpose::perm2"]},
  "General::lconv"->{
    Cell[105410, 3861, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::lconv"],
    Cell[105494, 3864, 238, 7, 21, "Message",
      CellTags->"General::lconv"],
    Cell[105735, 3873, 553, 15, 84, "Notes",
      CellTags->"General::lconv"]},
  "General::luc"->{
    Cell[106325, 3893, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::luc"],
    Cell[106405, 3896, 502, 14, 37, "Message",
      CellTags->"General::luc"],
    Cell[106910, 3912, 314, 6, 62, "Notes",
      CellTags->"General::luc"]},
  "General::matrix"->{
    Cell[107261, 3923, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::matrix"],
    Cell[107347, 3926, 455, 12, 37, "Message",
      CellTags->"General::matrix"],
    Cell[107805, 3940, 592, 11, 100, "Notes",
      CellTags->"General::matrix"],
    Cell[108422, 3955, 65, 1, 38, "ExampleSection",
      CellTags->"General::matrix"],
    Cell[108490, 3958, 148, 5, 24, "Text",
      CellTags->"General::matrix"],
    Cell[108663, 3967, 129, 3, 26, "Input",
      CellTags->"General::matrix"],
    Cell[108795, 3972, 273, 5, 53, "Message",
      CellTags->"General::matrix"],
    Cell[109071, 3979, 134, 3, 21, "Output",
      CellTags->"General::matrix"],
    Cell[109220, 3985, 133, 5, 24, "Text",
      CellTags->"General::matrix"],
    Cell[109378, 3994, 127, 3, 26, "Input",
      CellTags->"General::matrix"],
    Cell[109508, 3999, 198, 5, 21, "Output",
      CellTags->"General::matrix"],
    Cell[109721, 4007, 81, 2, 26, "Input",
      CellTags->"General::matrix"]},
  "General::matsq"->{
    Cell[109851, 4015, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::matsq"],
    Cell[109935, 4018, 448, 12, 21, "Message",
      CellTags->"General::matsq"],
    Cell[110386, 4032, 314, 7, 62, "Notes",
      CellTags->"General::matsq"],
    Cell[110725, 4043, 64, 1, 38, "ExampleSection",
      CellTags->"General::matsq"],
    Cell[110792, 4046, 184, 5, 24, "Text",
      CellTags->"General::matsq"],
    Cell[111001, 4055, 106, 3, 26, "Input",
      CellTags->"General::matsq"],
    Cell[111110, 4060, 220, 5, 37, "Message",
      CellTags->"General::matsq"],
    Cell[111333, 4067, 107, 3, 21, "Output",
      CellTags->"General::matsq"],
    Cell[111455, 4073, 125, 5, 24, "Text",
      CellTags->"General::matsq"],
    Cell[111605, 4082, 108, 3, 26, "Input",
      CellTags->"General::matsq"],
    Cell[111716, 4087, 94, 3, 21, "Output",
      CellTags->"General::matsq"]},
  "ListConvolve::depth"->{
    Cell[111871, 4097, 146, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[112020, 4103, 606, 16, 37, "Message",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[112629, 4121, 544, 14, 78, "Notes",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[113198, 4139, 95, 1, 38, "ExampleSection",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[113296, 4142, 242, 5, 40, "Text",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[113563, 4151, 189, 4, 26, "Input",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[113755, 4157, 275, 5, 53, "Message",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[114033, 4164, 190, 4, 21, "Output",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[114238, 4171, 193, 5, 24, "Text",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[114456, 4180, 180, 4, 26, "Input",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[114639, 4186, 230, 4, 37, "Output",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}]},
  "ListCorrelate::depth"->{
    Cell[111871, 4097, 146, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[112020, 4103, 606, 16, 37, "Message",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[112629, 4121, 544, 14, 78, "Notes",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[113198, 4139, 95, 1, 38, "ExampleSection",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[113296, 4142, 242, 5, 40, "Text",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[113563, 4151, 189, 4, 26, "Input",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[113755, 4157, 275, 5, 53, "Message",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[114033, 4164, 190, 4, 21, "Output",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[114238, 4171, 193, 5, 24, "Text",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[114456, 4180, 180, 4, 26, "Input",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
    Cell[114639, 4186, 230, 4, 37, "Output",
      CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}]},
  "ListConvolve::kldims"->{
    Cell[114930, 4197, 150, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[115083, 4203, 560, 14, 37, "Message",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[115646, 4219, 319, 8, 40, "Notes",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[115990, 4231, 97, 1, 38, "ExampleSection",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[116090, 4234, 227, 5, 40, "Text",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[116342, 4243, 166, 3, 26, "Input",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[116511, 4248, 321, 6, 53, "Message",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[116835, 4256, 167, 3, 21, "Output",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[117017, 4262, 258, 5, 40, "Text",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[117300, 4271, 195, 4, 42, "Input",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[117498, 4277, 178, 3, 21, "Output",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}]},
  "ListCorrelate::kldims"->{
    Cell[114930, 4197, 150, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[115083, 4203, 560, 14, 37, "Message",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[115646, 4219, 319, 8, 40, "Notes",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[115990, 4231, 97, 1, 38, "ExampleSection",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[116090, 4234, 227, 5, 40, "Text",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[116342, 4243, 166, 3, 26, "Input",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[116511, 4248, 321, 6, 53, "Message",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[116835, 4256, 167, 3, 21, "Output",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[117017, 4262, 258, 5, 40, "Text",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[117300, 4271, 195, 4, 42, "Input",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
    Cell[117498, 4277, 178, 3, 21, "Output",
      CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}]},
  "ListConvolve::nlen"->{
    Cell[117737, 4287, 142, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[117882, 4293, 333, 9, 37, "Message",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[118218, 4304, 286, 7, 40, "Notes",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[118529, 4315, 93, 1, 38, "ExampleSection",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[118625, 4318, 214, 4, 40, "Text",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[118864, 4326, 156, 3, 26, "Input",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[119023, 4331, 247, 5, 37, "Message",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[119273, 4338, 119, 3, 21, "Output",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[119407, 4344, 162, 5, 24, "Text",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[119594, 4353, 156, 3, 26, "Input",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[119753, 4358, 209, 4, 21, "Output",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}]},
  "ListCorrelate::nlen"->{
    Cell[117737, 4287, 142, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[117882, 4293, 333, 9, 37, "Message",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[118218, 4304, 286, 7, 40, "Notes",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[118529, 4315, 93, 1, 38, "ExampleSection",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[118625, 4318, 214, 4, 40, "Text",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[118864, 4326, 156, 3, 26, "Input",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[119023, 4331, 247, 5, 37, "Message",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[119273, 4338, 119, 3, 21, "Output",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[119407, 4344, 162, 5, 24, "Text",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[119594, 4353, 156, 3, 26, "Input",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
    Cell[119753, 4358, 209, 4, 21, "Output",
      CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}]},
  "ListConvolve::ohp"->{
    Cell[120023, 4369, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[120197, 4376, 604, 15, 37, "Message",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[120804, 4393, 776, 18, 116, "Notes",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[121605, 4415, 109, 1, 38, "ExampleSection",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[121717, 4418, 176, 4, 24, "Text",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[121918, 4426, 179, 3, 26, "Input",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122100, 4431, 299, 5, 53, "Message",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122402, 4438, 180, 3, 21, "Output",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122597, 4444, 179, 5, 24, "Text",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122801, 4453, 179, 3, 26, "Input",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122983, 4458, 200, 4, 21, "Output",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}]},
  "ListCorrelate::ohp"->{
    Cell[120023, 4369, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[120197, 4376, 604, 15, 37, "Message",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[120804, 4393, 776, 18, 116, "Notes",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[121605, 4415, 109, 1, 38, "ExampleSection",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[121717, 4418, 176, 4, 24, "Text",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[121918, 4426, 179, 3, 26, "Input",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122100, 4431, 299, 5, 53, "Message",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122402, 4438, 180, 3, 21, "Output",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122597, 4444, 179, 5, 24, "Text",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122801, 4453, 179, 3, 26, "Input",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122983, 4458, 200, 4, 21, "Output",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}]},
  "Partition::ohp"->{
    Cell[120023, 4369, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[120197, 4376, 604, 15, 37, "Message",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[120804, 4393, 776, 18, 116, "Notes",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[121605, 4415, 109, 1, 38, "ExampleSection",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[121717, 4418, 176, 4, 24, "Text",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[121918, 4426, 179, 3, 26, "Input",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122100, 4431, 299, 5, 53, "Message",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122402, 4438, 180, 3, 21, "Output",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122597, 4444, 179, 5, 24, "Text",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122801, 4453, 179, 3, 26, "Input",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
    Cell[122983, 4458, 200, 4, 21, "Output",
      CellTags->{
      "ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}]},
  "Partition::ohpdm"->{
    Cell[123244, 4469, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Partition::ohpdm"],
    Cell[123332, 4472, 228, 5, 37, "Message",
      CellTags->"Partition::ohpdm"],
    Cell[123563, 4479, 388, 10, 62, "Notes",
      CellTags->"Partition::ohpdm"],
    Cell[123976, 4493, 66, 1, 38, "ExampleSection",
      CellTags->"Partition::ohpdm"],
    Cell[124045, 4496, 189, 5, 40, "Text",
      CellTags->"Partition::ohpdm"],
    Cell[124259, 4505, 129, 3, 26, "Input",
      CellTags->"Partition::ohpdm"],
    Cell[124391, 4510, 235, 5, 37, "Message",
      CellTags->"Partition::ohpdm"],
    Cell[124629, 4517, 130, 3, 21, "Output",
      CellTags->"Partition::ohpdm"],
    Cell[124774, 4523, 142, 5, 24, "Text",
      CellTags->"Partition::ohpdm"],
    Cell[124941, 4532, 126, 3, 26, "Input",
      CellTags->"Partition::ohpdm"],
    Cell[125070, 4537, 114, 3, 21, "Output",
      CellTags->"Partition::ohpdm"]},
  "General::blvecmat"->{
    Cell[125245, 4547, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blvecmat"],
    Cell[125335, 4550, 285, 8, 37, "Message",
      CellTags->"General::blvecmat"],
    Cell[125623, 4560, 137, 4, 24, "Notes",
      CellTags->"General::blvecmat"]},
  "General::scalar"->{
    Cell[125797, 4569, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::scalar"],
    Cell[125883, 4572, 257, 7, 21, "Message",
      CellTags->"General::scalar"],
    Cell[126143, 4581, 135, 4, 24, "Notes",
      CellTags->"General::scalar"]},
  "General::blnotn"->{
    Cell[126315, 4590, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blnotn"],
    Cell[126401, 4593, 280, 8, 37, "Message",
      CellTags->"General::blnotn"],
    Cell[126684, 4603, 126, 4, 24, "Notes",
      CellTags->"General::blnotn"]},
  "General::blncorr"->{
    Cell[126847, 4612, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blncorr"],
    Cell[126935, 4615, 275, 7, 37, "Message",
      CellTags->"General::blncorr"],
    Cell[127213, 4624, 127, 4, 24, "Notes",
      CellTags->"General::blncorr"]},
  "General::blwarg"->{
    Cell[127377, 4633, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blwarg"],
    Cell[127463, 4636, 302, 8, 37, "Message",
      CellTags->"General::blwarg"],
    Cell[127768, 4646, 126, 4, 24, "Notes",
      CellTags->"General::blwarg"]},
  "General::blndim1"->{
    Cell[127931, 4655, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blndim1"],
    Cell[128019, 4658, 275, 7, 37, "Message",
      CellTags->"General::blndim1"],
    Cell[128297, 4667, 127, 4, 24, "Notes",
      CellTags->"General::blndim1"]},
  "General::blndim2"->{
    Cell[128461, 4676, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blndim2"],
    Cell[128549, 4679, 265, 7, 21, "Message",
      CellTags->"General::blndim2"],
    Cell[128817, 4688, 127, 4, 24, "Notes",
      CellTags->"General::blndim2"]},
  "General::blrank"->{
    Cell[128981, 4697, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blrank"],
    Cell[129067, 4700, 288, 8, 37, "Message",
      CellTags->"General::blrank"],
    Cell[129358, 4710, 126, 4, 24, "Notes",
      CellTags->"General::blrank"]},
  "General::blrank1"->{
    Cell[129521, 4719, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blrank1"],
    Cell[129609, 4722, 299, 8, 37, "Message",
      CellTags->"General::blrank1"],
    Cell[129911, 4732, 127, 4, 24, "Notes",
      CellTags->"General::blrank1"]},
  "General::blnotsym"->{
    Cell[130075, 4741, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blnotsym"],
    Cell[130165, 4744, 330, 8, 37, "Message",
      CellTags->"General::blnotsym"],
    Cell[130498, 4754, 128, 4, 24, "Notes",
      CellTags->"General::blnotsym"]},
  "General::blscas"->{
    Cell[130663, 4763, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blscas"],
    Cell[130749, 4766, 289, 8, 37, "Message",
      CellTags->"General::blscas"],
    Cell[131041, 4776, 126, 4, 24, "Notes",
      CellTags->"General::blscas"]},
  "General::bldim"->{
    Cell[131204, 4785, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::bldim"],
    Cell[131288, 4788, 282, 8, 37, "Message",
      CellTags->"General::bldim"],
    Cell[131573, 4798, 125, 4, 24, "Notes",
      CellTags->"General::bldim"]},
  "General::bldim1"->{
    Cell[131735, 4807, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::bldim1"],
    Cell[131821, 4810, 287, 8, 37, "Message",
      CellTags->"General::bldim1"],
    Cell[132111, 4820, 126, 4, 24, "Notes",
      CellTags->"General::bldim1"]},
  "General::blvec"->{
    Cell[132274, 4829, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blvec"],
    Cell[132358, 4832, 265, 7, 21, "Message",
      CellTags->"General::blvec"],
    Cell[132626, 4841, 125, 4, 24, "Notes",
      CellTags->"General::blvec"]},
  "General::blnotsq"->{
    Cell[132788, 4850, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blnotsq"],
    Cell[132876, 4853, 317, 8, 37, "Message",
      CellTags->"General::blnotsq"],
    Cell[133196, 4863, 127, 4, 24, "Notes",
      CellTags->"General::blnotsq"]},
  "General::blnsetst"->{
    Cell[133360, 4872, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blnsetst"],
    Cell[133450, 4875, 335, 8, 37, "Message",
      CellTags->"General::blnsetst"],
    Cell[133788, 4885, 128, 4, 24, "Notes",
      CellTags->"General::blnsetst"]},
  "General::blnulst"->{
    Cell[133953, 4894, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blnulst"],
    Cell[134041, 4897, 278, 7, 37, "Message",
      CellTags->"General::blnulst"],
    Cell[134322, 4906, 127, 4, 24, "Notes",
      CellTags->"General::blnulst"]},
  "General::blreal"->{
    Cell[134486, 4915, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blreal"],
    Cell[134572, 4918, 254, 7, 21, "Message",
      CellTags->"General::blreal"],
    Cell[134829, 4927, 126, 4, 24, "Notes",
      CellTags->"General::blreal"]},
  "General::blnegn"->{
    Cell[134992, 4936, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blnegn"],
    Cell[135078, 4939, 251, 7, 21, "Message",
      CellTags->"General::blnegn"],
    Cell[135332, 4948, 126, 4, 24, "Notes",
      CellTags->"General::blnegn"]},
  "General::blnmpre"->{
    Cell[135495, 4957, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blnmpre"],
    Cell[135583, 4960, 292, 8, 37, "Message",
      CellTags->"General::blnmpre"],
    Cell[135878, 4970, 127, 4, 24, "Notes",
      CellTags->"General::blnmpre"]},
  "General::spsder"->{
    Cell[136042, 4979, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::spsder"],
    Cell[136128, 4982, 314, 8, 37, "Message",
      CellTags->"General::spsder"],
    Cell[136445, 4992, 126, 4, 24, "Notes",
      CellTags->"General::spsder"]},
  "General::sdsh"->{
    Cell[136608, 5001, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sdsh"],
    Cell[136690, 5004, 306, 8, 37, "Message",
      CellTags->"General::sdsh"],
    Cell[136999, 5014, 124, 4, 24, "Notes",
      CellTags->"General::sdsh"]},
  "Partition::pttl"->{
    Cell[137160, 5023, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Partition::pttl"],
    Cell[137246, 5026, 344, 8, 37, "Message",
      CellTags->"Partition::pttl"],
    Cell[137593, 5036, 421, 9, 78, "Notes",
      CellTags->"Partition::pttl"],
    Cell[138039, 5049, 65, 1, 38, "ExampleSection",
      CellTags->"Partition::pttl"],
    Cell[138107, 5052, 201, 5, 40, "Text",
      CellTags->"Partition::pttl"],
    Cell[138333, 5061, 145, 3, 26, "Input",
      CellTags->"Partition::pttl"],
    Cell[138481, 5066, 234, 5, 37, "Message",
      CellTags->"Partition::pttl"],
    Cell[138718, 5073, 146, 3, 21, "Output",
      CellTags->"Partition::pttl"],
    Cell[138879, 5079, 161, 5, 24, "Text",
      CellTags->"Partition::pttl"],
    Cell[139065, 5088, 150, 4, 26, "Input",
      CellTags->"Partition::pttl"],
    Cell[139218, 5094, 121, 3, 21, "Output",
      CellTags->"Partition::pttl"]},
  "Drop::drop"->{
    Cell[139400, 5104, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Drop::drop"],
    Cell[139476, 5107, 381, 12, 21, "Message",
      CellTags->"Drop::drop"],
    Cell[139860, 5121, 222, 5, 40, "Notes",
      CellTags->"Drop::drop"],
    Cell[140107, 5130, 60, 1, 38, "ExampleSection",
      CellTags->"Drop::drop"],
    Cell[140170, 5133, 219, 6, 40, "Text",
      CellTags->"Drop::drop"],
    Cell[140414, 5143, 103, 3, 26, "Input",
      CellTags->"Drop::drop"],
    Cell[140520, 5148, 195, 5, 21, "Message",
      CellTags->"Drop::drop"],
    Cell[140718, 5155, 104, 3, 21, "Output",
      CellTags->"Drop::drop"],
    Cell[140837, 5161, 117, 5, 24, "Text",
      CellTags->"Drop::drop"],
    Cell[140979, 5170, 103, 3, 26, "Input",
      CellTags->"Drop::drop"],
    Cell[141085, 5175, 90, 3, 21, "Output",
      CellTags->"Drop::drop"]},
  "First::first"->{
    Cell[141236, 5185, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"First::first"],
    Cell[141316, 5188, 223, 5, 21, "Message",
      CellTags->"First::first"],
    Cell[141542, 5195, 168, 5, 24, "Notes",
      CellTags->"First::first"],
    Cell[141735, 5204, 62, 1, 38, "ExampleSection",
      CellTags->"First::first"],
    Cell[141800, 5207, 160, 4, 24, "Text",
      CellTags->"First::first"],
    Cell[141985, 5215, 99, 3, 26, "Input",
      CellTags->"First::first"],
    Cell[142087, 5220, 183, 4, 21, "Message",
      CellTags->"First::first"],
    Cell[142273, 5226, 95, 3, 21, "Output",
      CellTags->"First::first"],
    Cell[142383, 5232, 158, 4, 24, "Text",
      CellTags->"First::first"],
    Cell[142566, 5240, 112, 3, 26, "Input",
      CellTags->"First::first"],
    Cell[142681, 5245, 88, 3, 21, "Output",
      CellTags->"First::first"]},
  "FlattenAt::flatp"->{
    Cell[142830, 5255, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FlattenAt::flatp"],
    Cell[142918, 5258, 416, 11, 37, "Message",
      CellTags->"FlattenAt::flatp"],
    Cell[143337, 5271, 251, 6, 40, "Notes",
      CellTags->"FlattenAt::flatp"],
    Cell[143613, 5281, 66, 1, 38, "ExampleSection",
      CellTags->"FlattenAt::flatp"],
    Cell[143682, 5284, 169, 4, 40, "Text",
      CellTags->"FlattenAt::flatp"],
    Cell[143876, 5292, 118, 3, 26, "Input",
      CellTags->"FlattenAt::flatp"],
    Cell[143997, 5297, 247, 5, 37, "Message",
      CellTags->"FlattenAt::flatp"],
    Cell[144247, 5304, 119, 3, 21, "Output",
      CellTags->"FlattenAt::flatp"],
    Cell[144381, 5310, 128, 5, 24, "Text",
      CellTags->"FlattenAt::flatp"],
    Cell[144534, 5319, 124, 3, 26, "Input",
      CellTags->"FlattenAt::flatp"],
    Cell[144661, 5324, 109, 3, 21, "Output",
      CellTags->"FlattenAt::flatp"]},
  "Insert::ins"->{
    Cell[144831, 5334, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Insert::ins"],
    Cell[144909, 5337, 167, 4, 21, "Message",
      CellTags->"Insert::ins"],
    Cell[145079, 5343, 310, 7, 62, "Notes",
      CellTags->"Insert::ins"],
    Cell[145414, 5354, 61, 1, 38, "ExampleSection",
      CellTags->"Insert::ins"],
    Cell[145478, 5357, 124, 4, 24, "Text",
      CellTags->"Insert::ins"],
    Cell[145627, 5365, 114, 3, 26, "Input",
      CellTags->"Insert::ins"],
    Cell[145744, 5370, 191, 5, 21, "Message",
      CellTags->"Insert::ins"],
    Cell[145938, 5377, 115, 3, 21, "Output",
      CellTags->"Insert::ins"],
    Cell[146068, 5383, 133, 5, 24, "Text",
      CellTags->"Insert::ins"],
    Cell[146226, 5392, 114, 3, 26, "Input",
      CellTags->"Insert::ins"],
    Cell[146343, 5397, 104, 3, 21, "Output",
      CellTags->"Insert::ins"],
    Cell[146484, 5405, 119, 3, 26, "Input",
      CellTags->"Insert::ins"],
    Cell[146606, 5410, 104, 3, 21, "Output",
      CellTags->"Insert::ins"]},
  "Last::nolast"->{
    Cell[146771, 5420, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Last::nolast"],
    Cell[146851, 5423, 222, 5, 21, "Message",
      CellTags->"Last::nolast"],
    Cell[147076, 5430, 156, 4, 24, "Notes",
      CellTags->"Last::nolast"],
    Cell[147257, 5438, 62, 1, 38, "ExampleSection",
      CellTags->"Last::nolast"],
    Cell[147322, 5441, 138, 4, 24, "Text",
      CellTags->"Last::nolast"],
    Cell[147485, 5449, 93, 3, 26, "Input",
      CellTags->"Last::nolast"],
    Cell[147581, 5454, 182, 4, 21, "Message",
      CellTags->"Last::nolast"],
    Cell[147766, 5460, 94, 3, 21, "Output",
      CellTags->"Last::nolast"],
    Cell[147875, 5466, 119, 5, 24, "Text",
      CellTags->"Last::nolast"],
    Cell[148019, 5475, 106, 3, 26, "Input",
      CellTags->"Last::nolast"],
    Cell[148128, 5480, 87, 3, 21, "Output",
      CellTags->"Last::nolast"]},
  "Partition::pdep"->{
    Cell[148276, 5490, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Partition::pdep"],
    Cell[148362, 5493, 365, 10, 21, "Message",
      CellTags->"Partition::pdep"],
    Cell[148730, 5505, 266, 6, 40, "Notes",
      CellTags->"Partition::pdep"],
    Cell[149021, 5515, 65, 1, 38, "ExampleSection",
      CellTags->"Partition::pdep"],
    Cell[149089, 5518, 246, 6, 40, "Text",
      CellTags->"Partition::pdep"],
    Cell[149360, 5528, 127, 3, 26, "Input",
      CellTags->"Partition::pdep"],
    Cell[149490, 5533, 200, 5, 21, "Message",
      CellTags->"Partition::pdep"],
    Cell[149693, 5540, 128, 3, 21, "Output",
      CellTags->"Partition::pdep"],
    Cell[149836, 5546, 131, 5, 24, "Text",
      CellTags->"Partition::pdep"],
    Cell[149992, 5555, 166, 4, 42, "Input",
      CellTags->"Partition::pdep"],
    Cell[150161, 5561, 194, 4, 37, "Output",
      CellTags->"Partition::pdep"]},
  "RotateLeft::rotate"->{
    Cell[150416, 5572, 142, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"RotateLeft::rotate", "RotateRight::rotate"}],
    Cell[150561, 5578, 391, 11, 21, "Message",
      CellTags->{"RotateLeft::rotate", "RotateRight::rotate"}],
    Cell[150955, 5591, 267, 7, 40, "Notes",
      CellTags->{"RotateLeft::rotate", "RotateRight::rotate"}]},
  "RotateRight::rotate"->{
    Cell[150416, 5572, 142, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"RotateLeft::rotate", "RotateRight::rotate"}],
    Cell[150561, 5578, 391, 11, 21, "Message",
      CellTags->{"RotateLeft::rotate", "RotateRight::rotate"}],
    Cell[150955, 5591, 267, 7, 40, "Notes",
      CellTags->{"RotateLeft::rotate", "RotateRight::rotate"}]},
  "RotateLeft::rspec"->{
    Cell[151259, 5603, 138, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[151400, 5609, 517, 13, 37, "Message",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[151920, 5624, 263, 7, 40, "Notes",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[152208, 5635, 91, 1, 38, "ExampleSection",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[152302, 5638, 155, 4, 24, "Text",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[152482, 5646, 161, 3, 26, "Input",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[152646, 5651, 278, 5, 53, "Message",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[152927, 5658, 162, 3, 21, "Output",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[153104, 5664, 174, 5, 24, "Text",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[153303, 5673, 151, 3, 26, "Input",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[153457, 5678, 136, 3, 21, "Output",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}]},
  "RotateRight::rspec"->{
    Cell[151259, 5603, 138, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[151400, 5609, 517, 13, 37, "Message",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[151920, 5624, 263, 7, 40, "Notes",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[152208, 5635, 91, 1, 38, "ExampleSection",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[152302, 5638, 155, 4, 24, "Text",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[152482, 5646, 161, 3, 26, "Input",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[152646, 5651, 278, 5, 53, "Message",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[152927, 5658, 162, 3, 21, "Output",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[153104, 5664, 174, 5, 24, "Text",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[153303, 5673, 151, 3, 26, "Input",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
    Cell[153457, 5678, 136, 3, 21, "Output",
      CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}]},
  "Take::take"->{
    Cell[153654, 5688, 225, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[153882, 5699, 532, 17, 21, "Message",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154417, 5718, 309, 7, 40, "Notes",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154751, 5729, 143, 3, 38, "ExampleSection",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154897, 5734, 248, 6, 40, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[155170, 5744, 190, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[155363, 5751, 301, 7, 37, "Message",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[155667, 5760, 213, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[155895, 5768, 196, 6, 24, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156116, 5778, 194, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156313, 5785, 180, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[156508, 5793, 244, 6, 40, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156777, 5803, 202, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156982, 5810, 289, 7, 21, "Message",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[157274, 5819, 199, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[157488, 5827, 182, 3, 24, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[157695, 5834, 206, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[157904, 5841, 174, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}]},
  "StringTake::take"->{
    Cell[153654, 5688, 225, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[153882, 5699, 532, 17, 21, "Message",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154417, 5718, 309, 7, 40, "Notes",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154751, 5729, 143, 3, 38, "ExampleSection",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154897, 5734, 248, 6, 40, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[155170, 5744, 190, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[155363, 5751, 301, 7, 37, "Message",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[155667, 5760, 213, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[155895, 5768, 196, 6, 24, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156116, 5778, 194, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156313, 5785, 180, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[156508, 5793, 244, 6, 40, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156777, 5803, 202, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156982, 5810, 289, 7, 21, "Message",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[157274, 5819, 199, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[157488, 5827, 182, 3, 24, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[157695, 5834, 206, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[157904, 5841, 174, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}]},
  "Part::take"->{
    Cell[153654, 5688, 225, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[153882, 5699, 532, 17, 21, "Message",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154417, 5718, 309, 7, 40, "Notes",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154751, 5729, 143, 3, 38, "ExampleSection",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154897, 5734, 248, 6, 40, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[155170, 5744, 190, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[155363, 5751, 301, 7, 37, "Message",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[155667, 5760, 213, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[155895, 5768, 196, 6, 24, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156116, 5778, 194, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156313, 5785, 180, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[156508, 5793, 244, 6, 40, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156777, 5803, 202, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156982, 5810, 289, 7, 21, "Message",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[157274, 5819, 199, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[157488, 5827, 182, 3, 24, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[157695, 5834, 206, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[157904, 5841, 174, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}]},
  "Set::take"->{
    Cell[153654, 5688, 225, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[153882, 5699, 532, 17, 21, "Message",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154417, 5718, 309, 7, 40, "Notes",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154751, 5729, 143, 3, 38, "ExampleSection",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154897, 5734, 248, 6, 40, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[155170, 5744, 190, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[155363, 5751, 301, 7, 37, "Message",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[155667, 5760, 213, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[155895, 5768, 196, 6, 24, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156116, 5778, 194, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156313, 5785, 180, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[156508, 5793, 244, 6, 40, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156777, 5803, 202, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156982, 5810, 289, 7, 21, "Message",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[157274, 5819, 199, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[157488, 5827, 182, 3, 24, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[157695, 5834, 206, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[157904, 5841, 174, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}]},
  "Internal`BagPart::take"->{
    Cell[153654, 5688, 225, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[153882, 5699, 532, 17, 21, "Message",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154417, 5718, 309, 7, 40, "Notes",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154751, 5729, 143, 3, 38, "ExampleSection",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[154897, 5734, 248, 6, 40, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[155170, 5744, 190, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[155363, 5751, 301, 7, 37, "Message",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[155667, 5760, 213, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[155895, 5768, 196, 6, 24, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156116, 5778, 194, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156313, 5785, 180, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[156508, 5793, 244, 6, 40, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156777, 5803, 202, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[156982, 5810, 289, 7, 21, "Message",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[157274, 5819, 199, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}],
    Cell[157488, 5827, 182, 3, 24, "Text",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[157695, 5834, 206, 5, 26, "Input",
      CellTags->{
      "Take::take", "StringTake::take", "Part::take", "Set::take", 
        "Internal`BagPart::take"}],
    Cell[157904, 5841, 174, 5, 21, "Output",
      CellTags->{
      "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take",
         "Take::take"}]},
  "Thread::tdlen"->{
    Cell[158139, 5853, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Thread::tdlen"],
    Cell[158221, 5856, 276, 5, 21, "Message",
      CellTags->"Thread::tdlen"],
    Cell[158500, 5863, 404, 11, 62, "Notes",
      CellTags->"Thread::tdlen"],
    Cell[158929, 5878, 63, 1, 38, "ExampleSection",
      CellTags->"Thread::tdlen"],
    Cell[158995, 5881, 169, 4, 40, "Text",
      CellTags->"Thread::tdlen"],
    Cell[159189, 5889, 117, 3, 26, "Input",
      CellTags->"Thread::tdlen"],
    Cell[159309, 5894, 238, 5, 37, "Message",
      CellTags->"Thread::tdlen"],
    Cell[159550, 5901, 110, 3, 21, "Output",
      CellTags->"Thread::tdlen"],
    Cell[159675, 5907, 127, 5, 24, "Text",
      CellTags->"Thread::tdlen"],
    Cell[159827, 5916, 120, 3, 26, "Input",
      CellTags->"Thread::tdlen"],
    Cell[159950, 5921, 123, 3, 21, "Output",
      CellTags->"Thread::tdlen"],
    Cell[160088, 5927, 276, 7, 40, "Text",
      CellTags->"Thread::tdlen"],
    Cell[160389, 5938, 102, 3, 26, "Input",
      CellTags->"Thread::tdlen"],
    Cell[160494, 5943, 162, 4, 21, "Output",
      CellTags->"Thread::tdlen"],
    Cell[160693, 5952, 109, 3, 26, "Input",
      CellTags->"Thread::tdlen"],
    Cell[160805, 5957, 230, 5, 37, "Message",
      CellTags->"Thread::tdlen"],
    Cell[161038, 5964, 110, 3, 21, "Output",
      CellTags->"Thread::tdlen"],
    Cell[161163, 5970, 129, 4, 24, "Text",
      CellTags->"Thread::tdlen"],
    Cell[161317, 5978, 112, 3, 26, "Input",
      CellTags->"Thread::tdlen"],
    Cell[161432, 5983, 99, 3, 21, "Output",
      CellTags->"Thread::tdlen"]},
  "Thread::tpos"->{
    Cell[161592, 5993, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Thread::tpos"],
    Cell[161672, 5996, 400, 12, 21, "Message",
      CellTags->"Thread::tpos"],
    Cell[162075, 6010, 241, 6, 40, "Notes",
      CellTags->"Thread::tpos"],
    Cell[162341, 6020, 62, 1, 38, "ExampleSection",
      CellTags->"Thread::tpos"],
    Cell[162406, 6023, 248, 6, 40, "Text",
      CellTags->"Thread::tpos"],
    Cell[162679, 6033, 135, 3, 26, "Input",
      CellTags->"Thread::tpos"],
    Cell[162817, 6038, 259, 6, 37, "Message",
      CellTags->"Thread::tpos"],
    Cell[163079, 6046, 136, 3, 21, "Output",
      CellTags->"Thread::tpos"],
    Cell[163230, 6052, 140, 5, 24, "Text",
      CellTags->"Thread::tpos"],
    Cell[163395, 6061, 135, 3, 26, "Input",
      CellTags->"Thread::tpos"],
    Cell[163533, 6066, 126, 3, 21, "Output",
      CellTags->"Thread::tpos"]},
  "Union::smtst"->{
    Cell[163720, 6076, 169, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[163892, 6083, 772, 18, 53, "Message",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[164667, 6103, 328, 10, 40, "Notes",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[165020, 6117, 108, 1, 38, "ExampleSection",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[165131, 6120, 295, 8, 40, "Text",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[165451, 6132, 207, 4, 26, "Input",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[165661, 6138, 419, 7, 69, "Message",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[166083, 6147, 418, 7, 69, "Message",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[166504, 6156, 418, 7, 69, "Message",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[166925, 6165, 267, 5, 37, "Message",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[167195, 6172, 146, 3, 21, "Output",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[167356, 6178, 217, 5, 24, "Text",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[167598, 6187, 206, 4, 26, "Input",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[167807, 6193, 145, 3, 21, "Output",
      CellTags->{
      "Complement::smtst", "Intersection::smtst", "Union::smtst"}]},
  "Intersection::smtst"->{
    Cell[163720, 6076, 169, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[163892, 6083, 772, 18, 53, "Message",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[164667, 6103, 328, 10, 40, "Notes",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[165020, 6117, 108, 1, 38, "ExampleSection",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[165131, 6120, 295, 8, 40, "Text",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[165451, 6132, 207, 4, 26, "Input",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[165661, 6138, 419, 7, 69, "Message",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[166083, 6147, 418, 7, 69, "Message",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[166504, 6156, 418, 7, 69, "Message",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[166925, 6165, 267, 5, 37, "Message",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[167195, 6172, 146, 3, 21, "Output",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[167356, 6178, 217, 5, 24, "Text",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[167598, 6187, 206, 4, 26, "Input",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[167807, 6193, 145, 3, 21, "Output",
      CellTags->{
      "Complement::smtst", "Intersection::smtst", "Union::smtst"}]},
  "Complement::smtst"->{
    Cell[163720, 6076, 169, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[163892, 6083, 772, 18, 53, "Message",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[164667, 6103, 328, 10, 40, "Notes",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[165020, 6117, 108, 1, 38, "ExampleSection",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[165131, 6120, 295, 8, 40, "Text",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[165451, 6132, 207, 4, 26, "Input",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[165661, 6138, 419, 7, 69, "Message",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[166083, 6147, 418, 7, 69, "Message",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[166504, 6156, 418, 7, 69, "Message",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[166925, 6165, 267, 5, 37, "Message",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[167195, 6172, 146, 3, 21, "Output",
      CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
    
    Cell[167356, 6178, 217, 5, 24, "Text",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[167598, 6187, 206, 4, 26, "Input",
      CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
    
    Cell[167807, 6193, 145, 3, 21, "Output",
      CellTags->{
      "Complement::smtst", "Intersection::smtst", "Union::smtst"}]},
  "General::partd"->{
    Cell[168013, 6203, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::partd"],
    Cell[168097, 6206, 403, 11, 21, "Message",
      CellTags->"General::partd"],
    Cell[168503, 6219, 158, 4, 24, "Notes",
      CellTags->"General::partd"],
    Cell[168686, 6227, 64, 1, 38, "ExampleSection",
      CellTags->"General::partd"],
    Cell[168753, 6230, 149, 4, 24, "Text",
      CellTags->"General::partd"],
    Cell[168927, 6238, 119, 3, 26, "Input",
      CellTags->"General::partd"],
    Cell[169049, 6243, 282, 6, 37, "Message",
      CellTags->"General::partd"],
    Cell[169334, 6251, 164, 4, 21, "Output",
      CellTags->"General::partd"],
    Cell[169513, 6258, 84, 1, 24, "Text",
      CellTags->"General::partd"],
    Cell[169622, 6263, 123, 3, 26, "Input",
      CellTags->"General::partd"],
    Cell[169748, 6268, 92, 3, 21, "Output",
      CellTags->"General::partd"]},
  "General::partw"->{
    Cell[169901, 6278, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::partw"],
    Cell[169985, 6281, 384, 12, 21, "Message",
      CellTags->"General::partw"],
    Cell[170372, 6295, 176, 4, 24, "Notes",
      CellTags->"General::partw"],
    Cell[170573, 6303, 64, 1, 38, "ExampleSection",
      CellTags->"General::partw"],
    Cell[170640, 6306, 176, 4, 40, "Text",
      CellTags->"General::partw"],
    Cell[170841, 6314, 120, 3, 26, "Input",
      CellTags->"General::partw"],
    Cell[170964, 6319, 192, 4, 21, "Message",
      CellTags->"General::partw"],
    Cell[171159, 6325, 121, 3, 21, "Output",
      CellTags->"General::partw"],
    Cell[171295, 6331, 104, 1, 24, "Text",
      CellTags->"General::partw"],
    Cell[171424, 6336, 120, 3, 26, "Input",
      CellTags->"General::partw"],
    Cell[171547, 6341, 100, 3, 21, "Output",
      CellTags->"General::partw"]},
  "General::pspec"->{
    Cell[171708, 6351, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::pspec"],
    Cell[171792, 6354, 448, 12, 37, "Message",
      CellTags->"General::pspec"],
    Cell[172243, 6368, 158, 4, 24, "Notes",
      CellTags->"General::pspec"],
    Cell[172426, 6376, 64, 1, 38, "ExampleSection",
      CellTags->"General::pspec"],
    Cell[172493, 6379, 198, 5, 40, "Text",
      CellTags->"General::pspec"],
    Cell[172716, 6388, 123, 3, 26, "Input",
      CellTags->"General::pspec"],
    Cell[172842, 6393, 218, 5, 37, "Message",
      CellTags->"General::pspec"],
    Cell[173063, 6400, 168, 4, 21, "Output",
      CellTags->"General::pspec"],
    Cell[173246, 6407, 92, 1, 24, "Text",
      CellTags->"General::pspec"],
    Cell[173363, 6412, 119, 3, 26, "Input",
      CellTags->"General::pspec"],
    Cell[173485, 6417, 90, 3, 21, "Output",
      CellTags->"General::pspec"],
    Cell[173612, 6425, 134, 3, 26, "Input",
      CellTags->"General::pspec"],
    Cell[173749, 6430, 90, 3, 21, "Output",
      CellTags->"General::pspec"],
    Cell[173876, 6438, 139, 3, 26, "Input",
      CellTags->"General::pspec"],
    Cell[174018, 6443, 96, 3, 21, "Output",
      CellTags->"General::pspec"]},
  "Array::plen"->{
    Cell[174175, 6453, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[174314, 6459, 200, 4, 21, "Message",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[174517, 6465, 650, 14, 116, "Notes",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[175192, 6483, 90, 1, 38, "ExampleSection",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[175285, 6486, 181, 4, 24, "Text",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[175491, 6494, 137, 3, 26, "Input",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[175631, 6499, 216, 5, 21, "Message",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[175850, 6506, 138, 3, 21, "Output",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[176003, 6512, 152, 5, 24, "Text",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[176180, 6521, 140, 3, 26, "Input",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[176323, 6526, 150, 3, 21, "Output",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[176488, 6532, 208, 4, 40, "Text",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[176721, 6540, 205, 4, 42, "Input",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[176929, 6546, 272, 5, 37, "Message",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[177204, 6553, 186, 4, 21, "Output",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[177405, 6560, 200, 5, 24, "Text",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[177630, 6569, 213, 4, 42, "Input",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[177846, 6575, 123, 3, 21, "Output",
      CellTags->{"Array::plen", "StringReplacePart::plen"}]},
  "StringReplacePart::plen"->{
    Cell[174175, 6453, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[174314, 6459, 200, 4, 21, "Message",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[174517, 6465, 650, 14, 116, "Notes",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[175192, 6483, 90, 1, 38, "ExampleSection",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[175285, 6486, 181, 4, 24, "Text",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[175491, 6494, 137, 3, 26, "Input",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[175631, 6499, 216, 5, 21, "Message",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[175850, 6506, 138, 3, 21, "Output",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[176003, 6512, 152, 5, 24, "Text",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[176180, 6521, 140, 3, 26, "Input",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[176323, 6526, 150, 3, 21, "Output",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[176488, 6532, 208, 4, 40, "Text",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[176721, 6540, 205, 4, 42, "Input",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[176929, 6546, 272, 5, 37, "Message",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[177204, 6553, 186, 4, 21, "Output",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[177405, 6560, 200, 5, 24, "Text",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[177630, 6569, 213, 4, 42, "Input",
      CellTags->{"Array::plen", "StringReplacePart::plen"}],
    Cell[177846, 6575, 123, 3, 21, "Output",
      CellTags->{"Array::plen", "StringReplacePart::plen"}]},
  "PadLeft::level"->{
    Cell[178030, 6585, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[178159, 6591, 384, 11, 37, "Message",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[178546, 6604, 318, 9, 40, "Notes",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[178889, 6617, 85, 1, 38, "ExampleSection",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[178977, 6620, 210, 5, 40, "Text",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[179212, 6629, 138, 3, 26, "Input",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[179353, 6634, 275, 5, 53, "Message",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[179631, 6641, 139, 3, 21, "Output",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[179785, 6647, 180, 5, 24, "Text",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[179990, 6656, 142, 3, 26, "Input",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[180135, 6661, 142, 3, 21, "Output",
      CellTags->{"PadLeft::level", "PadRight::level"}]},
  "PadRight::level"->{
    Cell[178030, 6585, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[178159, 6591, 384, 11, 37, "Message",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[178546, 6604, 318, 9, 40, "Notes",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[178889, 6617, 85, 1, 38, "ExampleSection",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[178977, 6620, 210, 5, 40, "Text",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[179212, 6629, 138, 3, 26, "Input",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[179353, 6634, 275, 5, 53, "Message",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[179631, 6641, 139, 3, 21, "Output",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[179785, 6647, 180, 5, 24, "Text",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[179990, 6656, 142, 3, 26, "Input",
      CellTags->{"PadLeft::level", "PadRight::level"}],
    Cell[180135, 6661, 142, 3, 21, "Output",
      CellTags->{"PadLeft::level", "PadRight::level"}]},
  "PadLeft::margin"->{
    Cell[180338, 6671, 130, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[180471, 6677, 410, 11, 53, "Message",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[180884, 6690, 290, 8, 40, "Notes",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[181199, 6702, 87, 1, 38, "ExampleSection",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[181289, 6705, 206, 4, 40, "Text",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[181520, 6713, 143, 3, 26, "Input",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[181666, 6718, 350, 6, 53, "Message",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[182019, 6726, 144, 3, 21, "Output",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[182178, 6732, 167, 5, 24, "Text",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[182370, 6741, 138, 3, 26, "Input",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[182511, 6746, 141, 3, 21, "Output",
      CellTags->{"PadLeft::margin", "PadRight::margin"}]},
  "PadRight::margin"->{
    Cell[180338, 6671, 130, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[180471, 6677, 410, 11, 53, "Message",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[180884, 6690, 290, 8, 40, "Notes",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[181199, 6702, 87, 1, 38, "ExampleSection",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[181289, 6705, 206, 4, 40, "Text",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[181520, 6713, 143, 3, 26, "Input",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[181666, 6718, 350, 6, 53, "Message",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[182019, 6726, 144, 3, 21, "Output",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[182178, 6732, 167, 5, 24, "Text",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[182370, 6741, 138, 3, 26, "Input",
      CellTags->{"PadLeft::margin", "PadRight::margin"}],
    Cell[182511, 6746, 141, 3, 21, "Output",
      CellTags->{"PadLeft::margin", "PadRight::margin"}]},
  "Sow::encl"->{
    Cell[182713, 6756, 71, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Sow::encl"],
    Cell[182787, 6759, 200, 5, 21, "Message",
      CellTags->"Sow::encl"],
    Cell[182990, 6766, 320, 10, 46, "Notes",
      CellTags->"Sow::encl"],
    Cell[183335, 6780, 59, 1, 38, "ExampleSection",
      CellTags->"Sow::encl"],
    Cell[183397, 6783, 181, 7, 24, "Text",
      CellTags->"Sow::encl"],
    Cell[183603, 6794, 113, 3, 26, "Input",
      CellTags->"Sow::encl"],
    Cell[183719, 6799, 172, 4, 21, "Message",
      CellTags->"Sow::encl"],
    Cell[183894, 6805, 172, 4, 21, "Message",
      CellTags->"Sow::encl"],
    Cell[184069, 6811, 172, 4, 21, "Message",
      CellTags->"Sow::encl"],
    Cell[184244, 6817, 215, 5, 37, "Message",
      CellTags->"Sow::encl"],
    Cell[184462, 6824, 92, 3, 21, "Output",
      CellTags->"Sow::encl"],
    Cell[184569, 6830, 152, 7, 24, "Text",
      CellTags->"Sow::encl"],
    Cell[184746, 6841, 108, 3, 26, "Input",
      CellTags->"Sow::encl"],
    Cell[184857, 6846, 110, 3, 21, "Output",
      CellTags->"Sow::encl"],
    Cell[184982, 6852, 211, 7, 24, "Text",
      CellTags->"Sow::encl"],
    Cell[185218, 6863, 119, 3, 26, "Input",
      CellTags->"Sow::encl"],
    Cell[185340, 6868, 172, 4, 21, "Message",
      CellTags->"Sow::encl"],
    Cell[185515, 6874, 172, 4, 21, "Message",
      CellTags->"Sow::encl"],
    Cell[185690, 6880, 172, 4, 21, "Message",
      CellTags->"Sow::encl"],
    Cell[185865, 6886, 215, 5, 37, "Message",
      CellTags->"Sow::encl"],
    Cell[186083, 6893, 93, 3, 21, "Output",
      CellTags->"Sow::encl"]},
  "Sow::enclt"->{
    Cell[186237, 6903, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Sow::enclt"],
    Cell[186313, 6906, 151, 3, 21, "Message",
      CellTags->"Sow::enclt"],
    Cell[186467, 6911, 286, 7, 46, "Notes",
      CellTags->"Sow::enclt"],
    Cell[186778, 6922, 60, 1, 38, "ExampleSection",
      CellTags->"Sow::enclt"],
    Cell[186841, 6925, 235, 7, 40, "Text",
      CellTags->"Sow::enclt"],
    Cell[187101, 6936, 133, 3, 26, "Input",
      CellTags->"Sow::enclt"],
    Cell[187237, 6941, 204, 5, 21, "Message",
      CellTags->"Sow::enclt"],
    Cell[187444, 6948, 204, 5, 21, "Message",
      CellTags->"Sow::enclt"],
    Cell[187651, 6955, 204, 5, 21, "Message",
      CellTags->"Sow::enclt"],
    Cell[187858, 6962, 217, 5, 37, "Message",
      CellTags->"Sow::enclt"],
    Cell[188078, 6969, 94, 3, 21, "Output",
      CellTags->"Sow::enclt"]},
  "General::dim"->{
    Cell[188233, 6979, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::dim"],
    Cell[188313, 6982, 326, 8, 37, "Message",
      CellTags->"General::dim"],
    Cell[188642, 6992, 123, 4, 24, "Notes",
      CellTags->"General::dim"]},
  "General::nsdims"->{
    Cell[188802, 7001, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nsdims"],
    Cell[188888, 7004, 285, 8, 37, "Message",
      CellTags->"General::nsdims"],
    Cell[189176, 7014, 126, 4, 24, "Notes",
      CellTags->"General::nsdims"]},
  "General::rect"->{
    Cell[189339, 7023, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::rect"],
    Cell[189421, 7026, 310, 10, 21, "Message",
      CellTags->"General::rect"],
    Cell[189734, 7038, 124, 4, 24, "Notes",
      CellTags->"General::rect"]},
  "General::rectn"->{
    Cell[189895, 7047, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::rectn"],
    Cell[189979, 7050, 328, 10, 21, "Message",
      CellTags->"General::rectn"],
    Cell[190310, 7062, 125, 4, 24, "Notes",
      CellTags->"General::rectn"]},
  "General::rectt"->{
    Cell[190472, 7071, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::rectt"],
    Cell[190556, 7074, 328, 10, 21, "Message",
      CellTags->"General::rectt"],
    Cell[190887, 7086, 125, 4, 24, "Notes",
      CellTags->"General::rectt"]},
  "General::gfargs"->{
    Cell[191049, 7095, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::gfargs"],
    Cell[191135, 7098, 303, 8, 37, "Message",
      CellTags->"General::gfargs"],
    Cell[191441, 7108, 126, 4, 24, "Notes",
      CellTags->"General::gfargs"]},
  "General::nonnum"->{
    Cell[191604, 7117, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nonnum"],
    Cell[191690, 7120, 267, 7, 21, "Message",
      CellTags->"General::nonnum"],
    Cell[191960, 7129, 126, 4, 24, "Notes",
      CellTags->"General::nonnum"]},
  "General::dvec"->{
    Cell[192123, 7138, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::dvec"],
    Cell[192205, 7141, 355, 9, 37, "Message",
      CellTags->"General::dvec"],
    Cell[192563, 7152, 124, 4, 24, "Notes",
      CellTags->"General::dvec"]},
  "Eigensystem::svecnm"->{
    Cell[192724, 7161, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::svecnm", "Eigenvalues::svecnm", "Eigenvectors::svecnm"}],
    Cell[192919, 7169, 464, 12, 53, "Message",
      CellTags->{
      "Eigensystem::svecnm", "Eigenvalues::svecnm", "Eigenvectors::svecnm"}],
    Cell[193386, 7183, 182, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::svecnm", "Eigenvalues::svecnm", 
        "Eigenvectors::svecnm"}]},
  "Eigenvalues::svecnm"->{
    Cell[192724, 7161, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::svecnm", "Eigenvalues::svecnm", "Eigenvectors::svecnm"}],
    Cell[192919, 7169, 464, 12, 53, "Message",
      CellTags->{
      "Eigensystem::svecnm", "Eigenvalues::svecnm", "Eigenvectors::svecnm"}],
    Cell[193386, 7183, 182, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::svecnm", "Eigenvalues::svecnm", 
        "Eigenvectors::svecnm"}]},
  "Eigenvectors::svecnm"->{
    Cell[192724, 7161, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::svecnm", "Eigenvalues::svecnm", "Eigenvectors::svecnm"}],
    Cell[192919, 7169, 464, 12, 53, "Message",
      CellTags->{
      "Eigensystem::svecnm", "Eigenvalues::svecnm", "Eigenvectors::svecnm"}],
    Cell[193386, 7183, 182, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::svecnm", "Eigenvalues::svecnm", 
        "Eigenvectors::svecnm"}]},
  "Eigensystem::eslct"->{
    Cell[193605, 7193, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}],
    Cell[193794, 7201, 539, 13, 69, "Message",
      CellTags->{
      "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}],
    Cell[194336, 7216, 179, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}]},
  "Eigenvalues::eslct"->{
    Cell[193605, 7193, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}],
    Cell[193794, 7201, 539, 13, 69, "Message",
      CellTags->{
      "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}],
    Cell[194336, 7216, 179, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}]},
  "Eigenvectors::eslct"->{
    Cell[193605, 7193, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}],
    Cell[193794, 7201, 539, 13, 69, "Message",
      CellTags->{
      "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}],
    Cell[194336, 7216, 179, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}]},
  "Eigensystem::ssing"->{
    Cell[194552, 7226, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}],
    Cell[194741, 7234, 500, 13, 69, "Message",
      CellTags->{
      "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}],
    Cell[195244, 7249, 179, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}]},
  "Eigenvalues::ssing"->{
    Cell[194552, 7226, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}],
    Cell[194741, 7234, 500, 13, 69, "Message",
      CellTags->{
      "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}],
    Cell[195244, 7249, 179, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}]},
  "Eigenvectors::ssing"->{
    Cell[194552, 7226, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}],
    Cell[194741, 7234, 500, 13, 69, "Message",
      CellTags->{
      "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}],
    Cell[195244, 7249, 179, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}]},
  "Eigensystem::bsing"->{
    Cell[195460, 7259, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}],
    Cell[195649, 7267, 409, 11, 37, "Message",
      CellTags->{
      "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}],
    Cell[196061, 7280, 179, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}]},
  "Eigenvalues::bsing"->{
    Cell[195460, 7259, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}],
    Cell[195649, 7267, 409, 11, 37, "Message",
      CellTags->{
      "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}],
    Cell[196061, 7280, 179, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}]},
  "Eigenvectors::bsing"->{
    Cell[195460, 7259, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}],
    Cell[195649, 7267, 409, 11, 37, "Message",
      CellTags->{
      "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}],
    Cell[196061, 7280, 179, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}]},
  "Eigensystem::aribs"->{
    Cell[196277, 7290, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}],
    Cell[196466, 7298, 584, 14, 85, "Message",
      CellTags->{
      "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}],
    Cell[197053, 7314, 179, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}]},
  "Eigenvalues::aribs"->{
    Cell[196277, 7290, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}],
    Cell[196466, 7298, 584, 14, 85, "Message",
      CellTags->{
      "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}],
    Cell[197053, 7314, 179, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}]},
  "Eigenvectors::aribs"->{
    Cell[196277, 7290, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}],
    Cell[196466, 7298, 584, 14, 85, "Message",
      CellTags->{
      "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}],
    Cell[197053, 7314, 179, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}]},
  "Eigensystem::mcsgma"->{
    Cell[197269, 7324, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::mcsgma", "Eigenvalues::mcsgma", "Eigenvectors::mcsgma"}],
    Cell[197464, 7332, 388, 11, 21, "Message",
      CellTags->{
      "Eigensystem::mcsgma", "Eigenvalues::mcsgma", "Eigenvectors::mcsgma"}],
    Cell[197855, 7345, 182, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::mcsgma", "Eigenvalues::mcsgma", 
        "Eigenvectors::mcsgma"}]},
  "Eigenvalues::mcsgma"->{
    Cell[197269, 7324, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::mcsgma", "Eigenvalues::mcsgma", "Eigenvectors::mcsgma"}],
    Cell[197464, 7332, 388, 11, 21, "Message",
      CellTags->{
      "Eigensystem::mcsgma", "Eigenvalues::mcsgma", "Eigenvectors::mcsgma"}],
    Cell[197855, 7345, 182, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::mcsgma", "Eigenvalues::mcsgma", 
        "Eigenvectors::mcsgma"}]},
  "Eigenvectors::mcsgma"->{
    Cell[197269, 7324, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::mcsgma", "Eigenvalues::mcsgma", "Eigenvectors::mcsgma"}],
    Cell[197464, 7332, 388, 11, 21, "Message",
      CellTags->{
      "Eigensystem::mcsgma", "Eigenvalues::mcsgma", "Eigenvectors::mcsgma"}],
    Cell[197855, 7345, 182, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::mcsgma", "Eigenvalues::mcsgma", 
        "Eigenvectors::mcsgma"}]},
  "Eigensystem::arconv"->{
    Cell[198074, 7355, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::arconv", "Eigenvalues::arconv", "Eigenvectors::arconv"}],
    Cell[198269, 7363, 390, 11, 37, "Message",
      CellTags->{
      "Eigensystem::arconv", "Eigenvalues::arconv", "Eigenvectors::arconv"}],
    Cell[198662, 7376, 182, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::arconv", "Eigenvalues::arconv", 
        "Eigenvectors::arconv"}]},
  "Eigenvalues::arconv"->{
    Cell[198074, 7355, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::arconv", "Eigenvalues::arconv", "Eigenvectors::arconv"}],
    Cell[198269, 7363, 390, 11, 37, "Message",
      CellTags->{
      "Eigensystem::arconv", "Eigenvalues::arconv", "Eigenvectors::arconv"}],
    Cell[198662, 7376, 182, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::arconv", "Eigenvalues::arconv", 
        "Eigenvectors::arconv"}]},
  "Eigenvectors::arconv"->{
    Cell[198074, 7355, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigensystem::arconv", "Eigenvalues::arconv", "Eigenvectors::arconv"}],
    Cell[198269, 7363, 390, 11, 37, "Message",
      CellTags->{
      "Eigensystem::arconv", "Eigenvalues::arconv", "Eigenvectors::arconv"}],
    Cell[198662, 7376, 182, 5, 24, "Notes",
      CellTags->{
      "Eigensystem::arconv", "Eigenvalues::arconv", 
        "Eigenvectors::arconv"}]},
  "Eigenvalues::maxit"->{
    Cell[198881, 7386, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}],
    Cell[199070, 7394, 667, 15, 101, "Message",
      CellTags->{
      "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}],
    Cell[199740, 7411, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}]},
  "Eigenvectors::maxit"->{
    Cell[198881, 7386, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}],
    Cell[199070, 7394, 667, 15, 101, "Message",
      CellTags->{
      "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}],
    Cell[199740, 7411, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}]},
  "Eigensystem::maxit"->{
    Cell[198881, 7386, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}],
    Cell[199070, 7394, 667, 15, 101, "Message",
      CellTags->{
      "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}],
    Cell[199740, 7411, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}]},
  "Eigenvalues::take"->{
    Cell[199956, 7421, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Eigenvalues::take"],
    Cell[200046, 7424, 210, 4, 37, "Message",
      CellTags->"Eigenvalues::take"],
    Cell[200259, 7430, 128, 4, 24, "Notes",
      CellTags->"Eigenvalues::take"]},
  "Eigenvectors::take"->{
    Cell[200424, 7439, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Eigenvectors::take"],
    Cell[200516, 7442, 214, 4, 37, "Message",
      CellTags->"Eigenvectors::take"],
    Cell[200733, 7448, 129, 4, 24, "Notes",
      CellTags->"Eigenvectors::take"]},
  "Eigensystem::take"->{
    Cell[200899, 7457, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Eigensystem::take"],
    Cell[200989, 7460, 248, 4, 37, "Message",
      CellTags->"Eigensystem::take"],
    Cell[201240, 7466, 128, 4, 24, "Notes",
      CellTags->"Eigensystem::take"]},
  "SingularValueDecomposition::take"->{
    Cell[201405, 7475, 178, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "SingularValueDecomposition::take", "SingularValueList::take"}],
    Cell[201586, 7481, 277, 5, 53, "Message",
      CellTags->{
      "SingularValueDecomposition::take", "SingularValueList::take"}],
    Cell[201866, 7488, 172, 4, 24, "Notes",
      CellTags->{
      "SingularValueDecomposition::take", "SingularValueList::take"}]},
  "SingularValueList::take"->{
    Cell[201405, 7475, 178, 4, 51, "ObjectNameWarningMessages",
      CellTags->{
      "SingularValueDecomposition::take", "SingularValueList::take"}],
    Cell[201586, 7481, 277, 5, 53, "Message",
      CellTags->{
      "SingularValueDecomposition::take", "SingularValueList::take"}],
    Cell[201866, 7488, 172, 4, 24, "Notes",
      CellTags->{
      "SingularValueDecomposition::take", "SingularValueList::take"}]},
  "General::blincor"->{
    Cell[202075, 7497, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blincor"],
    Cell[202163, 7500, 255, 7, 21, "Message",
      CellTags->"General::blincor"],
    Cell[202421, 7509, 127, 4, 24, "Notes",
      CellTags->"General::blincor"]},
  "General::blintli"->{
    Cell[202585, 7518, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blintli"],
    Cell[202673, 7521, 264, 7, 21, "Message",
      CellTags->"General::blintli"],
    Cell[202940, 7530, 127, 4, 24, "Notes",
      CellTags->"General::blintli"]},
  "General::blveclen"->{
    Cell[203104, 7539, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::blveclen"],
    Cell[203194, 7542, 267, 7, 21, "Message",
      CellTags->"General::blveclen"],
    Cell[203464, 7551, 128, 4, 24, "Notes",
      CellTags->"General::blveclen"]},
  "LinearAlgebra`LAPACK`GESVX::blinstlu"->{
    Cell[203629, 7560, 125, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearAlgebra`LAPACK`GESVX::blinstlu"],
    Cell[203757, 7563, 333, 6, 53, "Message",
      CellTags->"LinearAlgebra`LAPACK`GESVX::blinstlu"],
    Cell[204093, 7571, 147, 4, 24, "Notes",
      CellTags->"LinearAlgebra`LAPACK`GESVX::blinstlu"]},
  "LinearAlgebra`LAPACK`LARTG::blneqsym"->{
    Cell[204277, 7580, 125, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearAlgebra`LAPACK`LARTG::blneqsym"],
    Cell[204405, 7583, 233, 4, 37, "Message",
      CellTags->"LinearAlgebra`LAPACK`LARTG::blneqsym"],
    Cell[204641, 7589, 147, 4, 24, "Notes",
      CellTags->"LinearAlgebra`LAPACK`LARTG::blneqsym"]},
  "Norm::ptype"->{
    Cell[204825, 7598, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Norm::ptype"],
    Cell[204903, 7601, 291, 6, 37, "Message",
      CellTags->"Norm::ptype"],
    Cell[205197, 7609, 122, 4, 24, "Notes",
      CellTags->"Norm::ptype"]},
  "Norm::symb"->{
    Cell[205356, 7618, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Norm::symb"],
    Cell[205432, 7621, 181, 4, 21, "Message",
      CellTags->"Norm::symb"],
    Cell[205616, 7627, 121, 4, 24, "Notes",
      CellTags->"Norm::symb"]},
  "Quantile::nquan"->{
    Cell[205774, 7636, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Quantile::nquan"],
    Cell[205860, 7639, 178, 3, 37, "Message",
      CellTags->"Quantile::nquan"],
    Cell[206041, 7644, 126, 4, 24, "Notes",
      CellTags->"Quantile::nquan"]},
  "LinearAlgebra`BLAS`TestArgument::blapos"->{
    Cell[206204, 7653, 131, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearAlgebra`BLAS`TestArgument::blapos"],
    Cell[206338, 7656, 278, 4, 37, "Message",
      CellTags->"LinearAlgebra`BLAS`TestArgument::blapos"],
    Cell[206619, 7662, 150, 4, 24, "Notes",
      CellTags->"LinearAlgebra`BLAS`TestArgument::blapos"]},
  "LinearAlgebra`BLAS`TestArgument::bltrank"->{
    Cell[206806, 7671, 133, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearAlgebra`BLAS`TestArgument::bltrank"],
    Cell[206942, 7674, 231, 4, 37, "Message",
      CellTags->"LinearAlgebra`BLAS`TestArgument::bltrank"],
    Cell[207176, 7680, 151, 4, 24, "Notes",
      CellTags->"LinearAlgebra`BLAS`TestArgument::bltrank"]},
  "Norm::nvm"->{
    Cell[207364, 7689, 71, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Norm::nvm"],
    Cell[207438, 7692, 178, 3, 21, "Message",
      CellTags->"Norm::nvm"],
    Cell[207619, 7697, 120, 4, 24, "Notes",
      CellTags->"Norm::nvm"]},
  "NDSolve`ScaledVectorNorm::vinp"->{
    Cell[207776, 7706, 113, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`ScaledVectorNorm::vinp"],
    Cell[207892, 7709, 235, 4, 37, "Message",
      CellTags->"NDSolve`ScaledVectorNorm::vinp"],
    Cell[208130, 7715, 141, 4, 24, "Notes",
      CellTags->"NDSolve`ScaledVectorNorm::vinp"]},
  "Norm::vlen"->{
    Cell[208308, 7724, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Norm::vlen", "NDSolve`ScaledVectorNorm::vlen"}],
    Cell[208459, 7730, 310, 8, 37, "Message",
      CellTags->{"Norm::vlen", "NDSolve`ScaledVectorNorm::vlen"}],
    Cell[208772, 7740, 157, 4, 24, "Notes",
      CellTags->{"Norm::vlen", "NDSolve`ScaledVectorNorm::vlen"}]},
  "NDSolve`ScaledVectorNorm::vlen"->{
    Cell[208308, 7724, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Norm::vlen", "NDSolve`ScaledVectorNorm::vlen"}],
    Cell[208459, 7730, 310, 8, 37, "Message",
      CellTags->{"Norm::vlen", "NDSolve`ScaledVectorNorm::vlen"}],
    Cell[208772, 7740, 157, 4, 24, "Notes",
      CellTags->{"Norm::vlen", "NDSolve`ScaledVectorNorm::vlen"}]},
  "Norm::winp"->{
    Cell[208966, 7749, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Norm::winp", "NDSolve`ScaledVectorNorm::winp"}],
    Cell[209117, 7755, 311, 8, 37, "Message",
      CellTags->{"Norm::winp", "NDSolve`ScaledVectorNorm::winp"}],
    Cell[209431, 7765, 157, 4, 24, "Notes",
      CellTags->{"Norm::winp", "NDSolve`ScaledVectorNorm::winp"}]},
  "NDSolve`ScaledVectorNorm::winp"->{
    Cell[208966, 7749, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Norm::winp", "NDSolve`ScaledVectorNorm::winp"}],
    Cell[209117, 7755, 311, 8, 37, "Message",
      CellTags->{"Norm::winp", "NDSolve`ScaledVectorNorm::winp"}],
    Cell[209431, 7765, 157, 4, 24, "Notes",
      CellTags->{"Norm::winp", "NDSolve`ScaledVectorNorm::winp"}]},
  "LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv"->{
    Cell[209625, 7774, 246, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv", 
        "LinearAlgebra`LAPACK`LASWP::blnotpiv"}],
    Cell[209874, 7782, 329, 9, 21, "Message",
      CellTags->{
      "LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv", 
        "LinearAlgebra`LAPACK`LASWP::blnotpiv"}],
    Cell[210206, 7793, 210, 6, 24, "Notes",
      CellTags->{
      "LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv", 
        "LinearAlgebra`LAPACK`LASWP::blnotpiv"}]},
  "LinearAlgebra`LAPACK`LASWP::blnotpiv"->{
    Cell[209625, 7774, 246, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv", 
        "LinearAlgebra`LAPACK`LASWP::blnotpiv"}],
    Cell[209874, 7782, 329, 9, 21, "Message",
      CellTags->{
      "LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv", 
        "LinearAlgebra`LAPACK`LASWP::blnotpiv"}],
    Cell[210206, 7793, 210, 6, 24, "Notes",
      CellTags->{
      "LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv", 
        "LinearAlgebra`LAPACK`LASWP::blnotpiv"}]},
  "Eigenvalues::arall"->{
    Cell[210453, 7804, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}],
    Cell[210642, 7812, 376, 8, 37, "Message",
      CellTags->{
      "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}],
    Cell[211021, 7822, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}]},
  "Eigenvectors::arall"->{
    Cell[210453, 7804, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}],
    Cell[210642, 7812, 376, 8, 37, "Message",
      CellTags->{
      "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}],
    Cell[211021, 7822, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}]},
  "Eigensystem::arall"->{
    Cell[210453, 7804, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}],
    Cell[210642, 7812, 376, 8, 37, "Message",
      CellTags->{
      "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}],
    Cell[211021, 7822, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}]},
  "Eigenvalues::arb2"->{
    Cell[211237, 7832, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}],
    Cell[211417, 7839, 408, 9, 37, "Message",
      CellTags->{
      "Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}],
    Cell[211828, 7850, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}]},
  "Eigenvectors::arb2"->{
    Cell[211237, 7832, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}],
    Cell[211417, 7839, 408, 9, 37, "Message",
      CellTags->{
      "Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}],
    Cell[211828, 7850, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}]},
  "Eigensystem::arb2"->{
    Cell[211237, 7832, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}],
    Cell[211417, 7839, 408, 9, 37, "Message",
      CellTags->{
      "Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}],
    Cell[211828, 7850, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}]},
  "Eigenvalues::arbs"->{
    Cell[212038, 7859, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}],
    Cell[212218, 7866, 520, 12, 69, "Message",
      CellTags->{
      "Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}],
    Cell[212741, 7880, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}]},
  "Eigenvectors::arbs"->{
    Cell[212038, 7859, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}],
    Cell[212218, 7866, 520, 12, 69, "Message",
      CellTags->{
      "Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}],
    Cell[212741, 7880, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}]},
  "Eigensystem::arbs"->{
    Cell[212038, 7859, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}],
    Cell[212218, 7866, 520, 12, 69, "Message",
      CellTags->{
      "Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}],
    Cell[212741, 7880, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}]},
  "Eigenvalues::arbss"->{
    Cell[212951, 7889, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}],
    Cell[213140, 7897, 481, 11, 69, "Message",
      CellTags->{
      "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}],
    Cell[213624, 7910, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}]},
  "Eigenvectors::arbss"->{
    Cell[212951, 7889, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}],
    Cell[213140, 7897, 481, 11, 69, "Message",
      CellTags->{
      "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}],
    Cell[213624, 7910, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}]},
  "Eigensystem::arbss"->{
    Cell[212951, 7889, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}],
    Cell[213140, 7897, 481, 11, 69, "Message",
      CellTags->{
      "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}],
    Cell[213624, 7910, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}]},
  "Eigenvalues::arbsym"->{
    Cell[213840, 7920, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arbsym", "Eigenvectors::arbsym", "Eigensystem::arbsym"}],
    Cell[214035, 7928, 430, 12, 37, "Message",
      CellTags->{
      "Eigenvalues::arbsym", "Eigenvectors::arbsym", "Eigensystem::arbsym"}],
    Cell[214468, 7942, 182, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arbsym", "Eigenvectors::arbsym", 
        "Eigensystem::arbsym"}]},
  "Eigenvectors::arbsym"->{
    Cell[213840, 7920, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arbsym", "Eigenvectors::arbsym", "Eigensystem::arbsym"}],
    Cell[214035, 7928, 430, 12, 37, "Message",
      CellTags->{
      "Eigenvalues::arbsym", "Eigenvectors::arbsym", "Eigensystem::arbsym"}],
    Cell[214468, 7942, 182, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arbsym", "Eigenvectors::arbsym", 
        "Eigensystem::arbsym"}]},
  "Eigensystem::arbsym"->{
    Cell[213840, 7920, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arbsym", "Eigenvectors::arbsym", "Eigensystem::arbsym"}],
    Cell[214035, 7928, 430, 12, 37, "Message",
      CellTags->{
      "Eigenvalues::arbsym", "Eigenvectors::arbsym", "Eigensystem::arbsym"}],
    Cell[214468, 7942, 182, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arbsym", "Eigenvectors::arbsym", 
        "Eigensystem::arbsym"}]},
  "Eigenvalues::arerr"->{
    Cell[214687, 7952, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}],
    Cell[214876, 7960, 357, 9, 37, "Message",
      CellTags->{
      "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}],
    Cell[215236, 7971, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}]},
  "Eigenvectors::arerr"->{
    Cell[214687, 7952, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}],
    Cell[214876, 7960, 357, 9, 37, "Message",
      CellTags->{
      "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}],
    Cell[215236, 7971, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}]},
  "Eigensystem::arerr"->{
    Cell[214687, 7952, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}],
    Cell[214876, 7960, 357, 9, 37, "Message",
      CellTags->{
      "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}],
    Cell[215236, 7971, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}]},
  "Eigenvalues::arfac"->{
    Cell[215452, 7981, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}],
    Cell[215641, 7989, 345, 9, 37, "Message",
      CellTags->{
      "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}],
    Cell[215989, 8000, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}]},
  "Eigenvectors::arfac"->{
    Cell[215452, 7981, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}],
    Cell[215641, 7989, 345, 9, 37, "Message",
      CellTags->{
      "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}],
    Cell[215989, 8000, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}]},
  "Eigensystem::arfac"->{
    Cell[215452, 7981, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}],
    Cell[215641, 7989, 345, 9, 37, "Message",
      CellTags->{
      "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}],
    Cell[215989, 8000, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}]},
  "Eigenvalues::argpd"->{
    Cell[216205, 8010, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}],
    Cell[216394, 8018, 747, 16, 117, "Message",
      CellTags->{
      "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}],
    Cell[217144, 8036, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}]},
  "Eigenvectors::argpd"->{
    Cell[216205, 8010, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}],
    Cell[216394, 8018, 747, 16, 117, "Message",
      CellTags->{
      "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}],
    Cell[217144, 8036, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}]},
  "Eigensystem::argpd"->{
    Cell[216205, 8010, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}],
    Cell[216394, 8018, 747, 16, 117, "Message",
      CellTags->{
      "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}],
    Cell[217144, 8036, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}]},
  "Eigenvalues::arh"->{
    Cell[217360, 8046, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}],
    Cell[217534, 8053, 613, 13, 85, "Message",
      CellTags->{
      "Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}],
    Cell[218150, 8068, 170, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}]},
  "Eigenvectors::arh"->{
    Cell[217360, 8046, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}],
    Cell[217534, 8053, 613, 13, 85, "Message",
      CellTags->{
      "Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}],
    Cell[218150, 8068, 170, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}]},
  "Eigensystem::arh"->{
    Cell[217360, 8046, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}],
    Cell[217534, 8053, 613, 13, 85, "Message",
      CellTags->{
      "Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}],
    Cell[218150, 8068, 170, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}]},
  "Eigenvalues::arhm"->{
    Cell[218357, 8077, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}],
    Cell[218537, 8084, 684, 14, 101, "Message",
      CellTags->{
      "Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}],
    Cell[219224, 8100, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}]},
  "Eigenvectors::arhm"->{
    Cell[218357, 8077, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}],
    Cell[218537, 8084, 684, 14, 101, "Message",
      CellTags->{
      "Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}],
    Cell[219224, 8100, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}]},
  "Eigensystem::arhm"->{
    Cell[218357, 8077, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}],
    Cell[218537, 8084, 684, 14, 101, "Message",
      CellTags->{
      "Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}],
    Cell[219224, 8100, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}]},
  "Eigenvalues::arm"->{
    Cell[219434, 8109, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}],
    Cell[219608, 8116, 321, 7, 37, "Message",
      CellTags->{
      "Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}],
    Cell[219932, 8125, 170, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}]},
  "Eigenvectors::arm"->{
    Cell[219434, 8109, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}],
    Cell[219608, 8116, 321, 7, 37, "Message",
      CellTags->{
      "Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}],
    Cell[219932, 8125, 170, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}]},
  "Eigensystem::arm"->{
    Cell[219434, 8109, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}],
    Cell[219608, 8116, 321, 7, 37, "Message",
      CellTags->{
      "Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}],
    Cell[219932, 8125, 170, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}]},
  "Eigenvalues::armc"->{
    Cell[220139, 8134, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}],
    Cell[220319, 8141, 351, 8, 37, "Message",
      CellTags->{
      "Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}],
    Cell[220673, 8151, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}]},
  "Eigenvectors::armc"->{
    Cell[220139, 8134, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}],
    Cell[220319, 8141, 351, 8, 37, "Message",
      CellTags->{
      "Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}],
    Cell[220673, 8151, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}]},
  "Eigensystem::armc"->{
    Cell[220139, 8134, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}],
    Cell[220319, 8141, 351, 8, 37, "Message",
      CellTags->{
      "Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}],
    Cell[220673, 8151, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}]},
  "Eigenvalues::armw"->{
    Cell[220883, 8160, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}],
    Cell[221063, 8167, 449, 11, 53, "Message",
      CellTags->{
      "Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}],
    Cell[221515, 8180, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}]},
  "Eigenvectors::armw"->{
    Cell[220883, 8160, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}],
    Cell[221063, 8167, 449, 11, 53, "Message",
      CellTags->{
      "Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}],
    Cell[221515, 8180, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}]},
  "Eigensystem::armw"->{
    Cell[220883, 8160, 177, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}],
    Cell[221063, 8167, 449, 11, 53, "Message",
      CellTags->{
      "Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}],
    Cell[221515, 8180, 173, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}]},
  "Eigenvalues::ars"->{
    Cell[221725, 8189, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}],
    Cell[221899, 8196, 502, 10, 69, "Message",
      CellTags->{
      "Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}],
    Cell[222404, 8208, 170, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}]},
  "Eigenvectors::ars"->{
    Cell[221725, 8189, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}],
    Cell[221899, 8196, 502, 10, 69, "Message",
      CellTags->{
      "Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}],
    Cell[222404, 8208, 170, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}]},
  "Eigensystem::ars"->{
    Cell[221725, 8189, 171, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}],
    Cell[221899, 8196, 502, 10, 69, "Message",
      CellTags->{
      "Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}],
    Cell[222404, 8208, 170, 4, 24, "Notes",
      CellTags->{
      "Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}]},
  "Eigenvalues::arstv"->{
    Cell[222611, 8217, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}],
    Cell[222800, 8225, 326, 8, 37, "Message",
      CellTags->{
      "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}],
    Cell[223129, 8235, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}]},
  "Eigenvectors::arstv"->{
    Cell[222611, 8217, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}],
    Cell[222800, 8225, 326, 8, 37, "Message",
      CellTags->{
      "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}],
    Cell[223129, 8235, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}]},
  "Eigensystem::arstv"->{
    Cell[222611, 8217, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}],
    Cell[222800, 8225, 326, 8, 37, "Message",
      CellTags->{
      "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}],
    Cell[223129, 8235, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}]},
  "Eigenvalues::emeth"->{
    Cell[223345, 8245, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}],
    Cell[223534, 8253, 344, 9, 37, "Message",
      CellTags->{
      "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}],
    Cell[223881, 8264, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}]},
  "Eigenvectors::emeth"->{
    Cell[223345, 8245, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}],
    Cell[223534, 8253, 344, 9, 37, "Message",
      CellTags->{
      "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}],
    Cell[223881, 8264, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}]},
  "Eigensystem::emeth"->{
    Cell[223345, 8245, 186, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}],
    Cell[223534, 8253, 344, 9, 37, "Message",
      CellTags->{
      "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}],
    Cell[223881, 8264, 179, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}]},
  "Eigenvalues::maxit2"->{
    Cell[224097, 8274, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::maxit2", "Eigenvectors::maxit2", "Eigensystem::maxit2"}],
    Cell[224292, 8282, 760, 16, 117, "Message",
      CellTags->{
      "Eigenvalues::maxit2", "Eigenvectors::maxit2", "Eigensystem::maxit2"}],
    Cell[225055, 8300, 182, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::maxit2", "Eigenvectors::maxit2", 
        "Eigensystem::maxit2"}]},
  "Eigenvectors::maxit2"->{
    Cell[224097, 8274, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::maxit2", "Eigenvectors::maxit2", "Eigensystem::maxit2"}],
    Cell[224292, 8282, 760, 16, 117, "Message",
      CellTags->{
      "Eigenvalues::maxit2", "Eigenvectors::maxit2", "Eigensystem::maxit2"}],
    Cell[225055, 8300, 182, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::maxit2", "Eigenvectors::maxit2", 
        "Eigensystem::maxit2"}]},
  "Eigensystem::maxit2"->{
    Cell[224097, 8274, 192, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Eigenvalues::maxit2", "Eigenvectors::maxit2", "Eigensystem::maxit2"}],
    Cell[224292, 8282, 760, 16, 117, "Message",
      CellTags->{
      "Eigenvalues::maxit2", "Eigenvectors::maxit2", "Eigensystem::maxit2"}],
    Cell[225055, 8300, 182, 5, 24, "Notes",
      CellTags->{
      "Eigenvalues::maxit2", "Eigenvectors::maxit2", 
        "Eigensystem::maxit2"}]},
  "LinearSolve::sing1"->{
    Cell[225274, 8310, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::sing1"],
    Cell[225366, 8313, 199, 3, 37, "Message",
      CellTags->"LinearSolve::sing1"],
    Cell[225568, 8318, 129, 4, 24, "Notes",
      CellTags->"LinearSolve::sing1"]},
  "LinearSolve::sqmat1"->{
    Cell[225734, 8327, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::sqmat1"],
    Cell[225828, 8330, 206, 4, 37, "Message",
      CellTags->"LinearSolve::sqmat1"],
    Cell[226037, 8336, 130, 4, 24, "Notes",
      CellTags->"LinearSolve::sqmat1"]},
  "SparseArray::posr"->{
    Cell[226204, 8345, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SparseArray::posr"],
    Cell[226294, 8348, 286, 5, 37, "Message",
      CellTags->"SparseArray::posr"],
    Cell[226583, 8355, 128, 4, 24, "Notes",
      CellTags->"SparseArray::posr"]},
  "LinearSolve::kryme"->{
    Cell[226748, 8364, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::kryme"],
    Cell[226840, 8367, 205, 5, 21, "Message",
      CellTags->"LinearSolve::kryme"],
    Cell[227048, 8374, 129, 4, 24, "Notes",
      CellTags->"LinearSolve::kryme"]},
  "LinearSolve::kryit"->{
    Cell[227214, 8383, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::kryit"],
    Cell[227306, 8386, 266, 6, 37, "Message",
      CellTags->"LinearSolve::kryit"],
    Cell[227575, 8394, 129, 4, 24, "Notes",
      CellTags->"LinearSolve::kryit"]},
  "LinearSolve::krytol"->{
    Cell[227741, 8403, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::krytol"],
    Cell[227835, 8406, 266, 6, 37, "Message",
      CellTags->"LinearSolve::krytol"],
    Cell[228104, 8414, 130, 4, 24, "Notes",
      CellTags->"LinearSolve::krytol"]},
  "LinearSolve::krypre"->{
    Cell[228271, 8423, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::krypre"],
    Cell[228365, 8426, 228, 5, 37, "Message",
      CellTags->"LinearSolve::krypre"],
    Cell[228596, 8433, 130, 4, 24, "Notes",
      CellTags->"LinearSolve::krypre"]},
  "LinearSolve::krynor"->{
    Cell[228763, 8442, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::krynor"],
    Cell[228857, 8445, 251, 6, 37, "Message",
      CellTags->"LinearSolve::krynor"],
    Cell[229111, 8453, 130, 4, 24, "Notes",
      CellTags->"LinearSolve::krynor"]},
  "LinearSolve::krynorv"->{
    Cell[229278, 8462, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::krynorv"],
    Cell[229374, 8465, 270, 6, 53, "Message",
      CellTags->"LinearSolve::krynorv"],
    Cell[229647, 8473, 131, 4, 24, "Notes",
      CellTags->"LinearSolve::krynorv"]},
  "LinearSolve::krydia"->{
    Cell[229815, 8482, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::krydia"],
    Cell[229909, 8485, 322, 6, 53, "Message",
      CellTags->"LinearSolve::krydia"],
    Cell[230234, 8493, 130, 4, 24, "Notes",
      CellTags->"LinearSolve::krydia"]},
  "LinearSolve::krymit"->{
    Cell[230401, 8502, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::krymit"],
    Cell[230495, 8505, 370, 8, 53, "Message",
      CellTags->"LinearSolve::krymit"],
    Cell[230868, 8515, 130, 4, 24, "Notes",
      CellTags->"LinearSolve::krymit"]},
  "LinearSolve::krypr"->{
    Cell[231035, 8524, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::krypr"],
    Cell[231127, 8527, 330, 7, 53, "Message",
      CellTags->"LinearSolve::krypr"],
    Cell[231460, 8536, 129, 4, 24, "Notes",
      CellTags->"LinearSolve::krypr"]},
  "LinearSolve::kryma"->{
    Cell[231626, 8545, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::kryma"],
    Cell[231718, 8548, 325, 7, 37, "Message",
      CellTags->"LinearSolve::kryma"],
    Cell[232046, 8557, 129, 4, 24, "Notes",
      CellTags->"LinearSolve::kryma"]},
  "LinearSolve::krynom"->{
    Cell[232212, 8566, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::krynom"],
    Cell[232306, 8569, 340, 8, 53, "Message",
      CellTags->"LinearSolve::krynom"],
    Cell[232649, 8579, 130, 4, 24, "Notes",
      CellTags->"LinearSolve::krynom"]},
  "LinearSolve::krynum"->{
    Cell[232816, 8588, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::krynum"],
    Cell[232910, 8591, 244, 6, 37, "Message",
      CellTags->"LinearSolve::krynum"],
    Cell[233157, 8599, 130, 4, 24, "Notes",
      CellTags->"LinearSolve::krynum"]},
  "LinearSolve::kryinfp"->{
    Cell[233324, 8608, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinearSolve::kryinfp"],
    Cell[233420, 8611, 321, 7, 37, "Message",
      CellTags->"LinearSolve::kryinfp"],
    Cell[233744, 8620, 131, 4, 24, "Notes",
      CellTags->"LinearSolve::kryinfp"]},
  "SparseArray::drnk"->{
    Cell[233912, 8629, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SparseArray::drnk"],
    Cell[234002, 8632, 281, 6, 37, "Message",
      CellTags->"SparseArray::drnk"],
    Cell[234286, 8640, 128, 4, 24, "Notes",
      CellTags->"SparseArray::drnk"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Rest::norest", 235105, 8665},
  {"Cross::nonn1", 235740, 8682},
  {"LinearSolve::mronly", 236613, 8705},
  {"LinearSolve::mconly", 236905, 8712},
  {"LinearSolve::mcovl", 237196, 8719},
  {"LinearSolve::nolib", 237484, 8726},
  {"LinearSolve::lupat", 237772, 8733},
  {"LinearSolve::sqmat", 238060, 8740},
  {"LinearSolve::npdef", 238348, 8747},
  {"LinearSolve::herm", 238635, 8754},
  {"LinearSolve::tmm", 238919, 8761},
  {"Experimental`ExtendedLinearSolve::lsvs", 239222, 8768},
  {"Experimental`LinearSolveFunction::lsvs", 239913, 8784},
  {"Developer`SparseLinearSolve::lsvs", 240599, 8800},
  {"CholeskyDecomposition::herm", 241279, 8816},
  {"Optimization`ModifiedCholeskyDecomposition::herm", 241838, 8829},
  {"CholeskyDecomposition::posdef", 242378, 8842},
  {"Optimization`ModifiedCholeskyDecomposition::posdef", 242951, 8855},
  {"SingularValues::neqcols", 243497, 8868},
  {"SingularValueList::neqcols", 244074, 8881},
  {"SingularValueDecomposition::neqcols", 244660, 8894},
  {"SingularValueDecomposition::svdf", 245243, 8907},
  {"SingularValueList::svdf", 247115, 8952},
  {"SingularValues::svdf", 248984, 8997},
  {"SingularValueDecomposition::svdn", 250865, 9042},
  {"SingularValueList::svdn", 252736, 9087},
  {"SingularValues::svdn", 254604, 9132},
  {"Developer`LinearExpressionToMatrix::nonlin", 256494, 9177},
  {"Developer`LinearExpressionToSparseMatrix::nonlin", 257098, 9190},
  {"Developer`LinearExpressionToMatrix::lexp", 257694, 9203},
  {"Developer`LinearExpressionToSparseMatrix::lexp", 258285, 9216},
  {"LUBackSubstitution::singlu", 258856, 9229},
  {"SparseArray::dims", 259171, 9236},
  {"SparseArray::rect", 259458, 9243},
  {"SparseArray::exdims", 259747, 9250},
  {"SparseArray::pind", 260040, 9257},
  {"SparseArray::ilist", 260328, 9264},
  {"SparseArray::rule", 260618, 9271},
  {"SparseArray::rule1", 260906, 9278},
  {"SparseArray::ntb", 261195, 9285},
  {"SparseArray::pos", 261478, 9292},
  {"SparseArray::valnl", 261763, 9299},
  {"SparseArray`SymmetricQ::spmat", 262065, 9306},
  {"SparseArray`HermitianQ::spmat", 262527, 9316},
  {"General::sparv", 262974, 9326},
  {"General::spts", 263251, 9333},
  {"Developer`SparseLinearSolve::spam", 263545, 9340},
  {"Developer`SparseLinearSolve::deprec", 263902, 9347},
  {"Developer`SparseLinearSolve::fovflw", 264265, 9354},
  {"Experimental`ExtendedLinearSolve::fovflw", 264979, 9370},
  {"Experimental`LinearSolveFunction::fovflw", 265693, 9386},
  {"Developer`SparseLinearSolve::sovflw", 266402, 9402},
  {"Experimental`ExtendedLinearSolve::sovflw", 267116, 9418},
  {"Experimental`LinearSolveFunction::sovflw", 267830, 9434},
  {"General::mindet", 268519, 9450},
  {"General::blnoval", 268803, 9457},
  {"HermiteNormalForm::latm", 269506, 9474},
  {"LatticeReduce::latm", 270798, 9497},
  {"General::cfail", 272085, 9520},
  {"LUDecomposition::sq", 272369, 9527},
  {"General::tol", 272660, 9534},
  {"Dot::rect", 273546, 9557},
  {"Tr::rect", 274552, 9580},
  {"DiagonalMatrix::vec", 275569, 9603},
  {"Dot::dotsh", 276532, 9626},
  {"Dot::dotpat", 277397, 9649},
  {"General::eivn", 277665, 9656},
  {"General::eivec", 277943, 9663},
  {"General::eival", 278224, 9670},
  {"General::inf", 278502, 9677},
  {"General::pvec", 278774, 9684},
  {"General::sing", 279049, 9691},
  {"Inner::incom", 279717, 9708},
  {"Inner::inntf", 281059, 9743},
  {"Inner::nolev", 281330, 9750},
  {"LUBackSubstitution::bpvt", 282231, 9773},
  {"LinearSolve::lsfail", 284140, 9816},
  {"General::lslc", 284432, 9823},
  {"General::lsv", 285486, 9850},
  {"LinearSolve::nosol", 285763, 9857},
  {"RowReduce::rmeth", 286965, 9886},
  {"LinearSolve::rmeth", 288768, 9931},
  {"NullSpace::rmeth", 290569, 9976},
  {"Inverse::rmeth", 292368, 10021},
  {"SchurDecomposition::schurf", 294179, 10066},
  {"Developer`HessenbergDecomposition::schurf", 295946, 10111},
  {"SchurDecomposition::schurn", 297698, 10156},
  {"Developer`HessenbergDecomposition::schurn", 299465, 10201},
  {"General::unpack1", 301207, 10246},
  {"General::unpack", 302302, 10273},
  {"General::punpack", 303386, 10300},
  {"General::punpack1", 303674, 10307},
  {"Testing`Internal`MVectorNorm::mrange", 303984, 10314},
  {"Testing`Internal`MVectorNorm::mvntestp", 304353, 10321},
  {"Testing`Internal`MVectorNorm::mvntestv", 304728, 10328},
  {"Testing`Internal`MScaledVectorNorm::mrange", 305107, 10335},
  {"Testing`Internal`MScaledVectorNorm::mvntestp", 305500, 10342},
  {"Testing`Internal`MScaledVectorNorm::mvntestv", 305899, 10349},
  {"Inverse::invc", 306267, 10356},
  {"MatrixPower::zvec", 306545, 10363},
  {"MatrixExp::zvec", 306898, 10370},
  {"Range::range", 307248, 10377},
  {"Transpose::diagnl", 308138, 10400},
  {"Transpose::newdims", 309086, 10423},
  {"Transpose::nmtx", 310044, 10446},
  {"Transpose::tperm", 311205, 10475},
  {"Transpose::perm", 312144, 10498},
  {"Transpose::perm1", 312431, 10505},
  {"Transpose::perm2", 313378, 10528},
  {"General::lconv", 314324, 10551},
  {"General::luc", 314604, 10558},
  {"General::matrix", 314881, 10565},
  {"General::matsq", 315897, 10590},
  {"ListConvolve::depth", 316825, 10613},
  {"ListCorrelate::depth", 318098, 10636},
  {"ListConvolve::kldims", 319371, 10659},
  {"ListCorrelate::kldims", 320666, 10682},
  {"ListConvolve::nlen", 321958, 10705},
  {"ListCorrelate::nlen", 323206, 10728},
  {"ListConvolve::ohp", 324452, 10751},
  {"ListCorrelate::ohp", 325956, 10785},
  {"Partition::ohp", 327456, 10819},
  {"Partition::ohpdm", 328958, 10853},
  {"General::blvecmat", 329907, 10876},
  {"General::scalar", 330198, 10883},
  {"General::blnotn", 330483, 10890},
  {"General::blncorr", 330769, 10897},
  {"General::blwarg", 331057, 10904},
  {"General::blndim1", 331343, 10911},
  {"General::blndim2", 331632, 10918},
  {"General::blrank", 331920, 10925},
  {"General::blrank1", 332206, 10932},
  {"General::blnotsym", 332496, 10939},
  {"General::blscas", 332787, 10946},
  {"General::bldim", 333071, 10953},
  {"General::bldim1", 333353, 10960},
  {"General::blvec", 333637, 10967},
  {"General::blnotsq", 333920, 10974},
  {"General::blnsetst", 334210, 10981},
  {"General::blnulst", 334502, 10988},
  {"General::blreal", 334790, 10995},
  {"General::blnegn", 335075, 11002},
  {"General::blnmpre", 335361, 11009},
  {"General::spsder", 335649, 11016},
  {"General::sdsh", 335932, 11023},
  {"Partition::pttl", 336211, 11030},
  {"Drop::drop", 337141, 11053},
  {"First::first", 338018, 11076},
  {"FlattenAt::flatp", 338918, 11099},
  {"Insert::ins", 339861, 11122},
  {"Last::nolast", 340902, 11149},
  {"Partition::pdep", 341801, 11172},
  {"RotateLeft::rotate", 342740, 11195},
  {"RotateRight::rotate", 343115, 11202},
  {"RotateLeft::rspec", 343488, 11209},
  {"RotateRight::rspec", 344714, 11232},
  {"Take::take", 345932, 11255},
  {"StringTake::take", 348982, 11328},
  {"Part::take", 352026, 11401},
  {"Set::take", 355069, 11474},
  {"Internal`BagPart::take", 358125, 11547},
  {"Thread::tdlen", 361172, 11620},
  {"Thread::tpos", 362787, 11661},
  {"Union::smtst", 363687, 11684},
  {"Intersection::smtst", 365550, 11727},
  {"Complement::smtst", 367411, 11770},
  {"General::partd", 369269, 11813},
  {"General::partw", 370191, 11836},
  {"General::pspec", 371115, 11859},
  {"Array::plen", 372350, 11890},
  {"StringReplacePart::plen", 374308, 11927},
  {"PadLeft::level", 376257, 11964},
  {"PadRight::level", 377414, 11987},
  {"PadLeft::margin", 378571, 12010},
  {"PadRight::margin", 379751, 12033},
  {"Sow::encl", 380924, 12056},
  {"Sow::enclt", 382541, 12099},
  {"General::dim", 383423, 12122},
  {"General::nsdims", 383699, 12129},
  {"General::rect", 383982, 12136},
  {"General::rectn", 384261, 12143},
  {"General::rectt", 384543, 12150},
  {"General::gfargs", 384826, 12157},
  {"General::nonnum", 385111, 12164},
  {"General::dvec", 385394, 12171},
  {"Eigensystem::svecnm", 385677, 12178},
  {"Eigenvalues::svecnm", 386157, 12189},
  {"Eigenvectors::svecnm", 386638, 12200},
  {"Eigensystem::eslct", 387117, 12211},
  {"Eigenvalues::eslct", 387578, 12221},
  {"Eigenvectors::eslct", 388040, 12231},
  {"Eigensystem::ssing", 388501, 12241},
  {"Eigenvalues::ssing", 388962, 12251},
  {"Eigenvectors::ssing", 389424, 12261},
  {"Eigensystem::bsing", 389885, 12271},
  {"Eigenvalues::bsing", 390346, 12281},
  {"Eigenvectors::bsing", 390808, 12291},
  {"Eigensystem::aribs", 391269, 12301},
  {"Eigenvalues::aribs", 391730, 12311},
  {"Eigenvectors::aribs", 392192, 12321},
  {"Eigensystem::mcsgma", 392654, 12331},
  {"Eigenvalues::mcsgma", 393134, 12342},
  {"Eigenvectors::mcsgma", 393615, 12353},
  {"Eigensystem::arconv", 394095, 12364},
  {"Eigenvalues::arconv", 394575, 12375},
  {"Eigenvectors::arconv", 395056, 12386},
  {"Eigenvalues::maxit", 395535, 12397},
  {"Eigenvectors::maxit", 395998, 12407},
  {"Eigensystem::maxit", 396460, 12417},
  {"Eigenvalues::take", 396921, 12427},
  {"Eigenvectors::take", 397215, 12434},
  {"Eigensystem::take", 397511, 12441},
  {"SingularValueDecomposition::take", 397819, 12448},
  {"SingularValueList::take", 398272, 12458},
  {"General::blincor", 398718, 12468},
  {"General::blintli", 399007, 12475},
  {"General::blveclen", 399297, 12482},
  {"LinearAlgebra`LAPACK`GESVX::blinstlu", 399609, 12489},
  {"LinearAlgebra`LAPACK`LARTG::blneqsym", 399979, 12496},
  {"Norm::ptype", 400324, 12503},
  {"Norm::symb", 400592, 12510},
  {"Quantile::nquan", 400862, 12517},
  {"LinearAlgebra`BLAS`TestArgument::blapos", 401171, 12524},
  {"LinearAlgebra`BLAS`TestArgument::bltrank", 401554, 12531},
  {"Norm::nvm", 401909, 12538},
  {"NDSolve`ScaledVectorNorm::vinp", 402191, 12545},
  {"Norm::vlen", 402517, 12552},
  {"NDSolve`ScaledVectorNorm::vlen", 402911, 12559},
  {"Norm::winp", 403285, 12566},
  {"NDSolve`ScaledVectorNorm::winp", 403679, 12573},
  {"LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv", 404092, 12580},
  {"LinearAlgebra`LAPACK`LASWP::blnotpiv", 404675, 12593},
  {"Eigenvalues::arall", 405240, 12606},
  {"Eigenvectors::arall", 405701, 12616},
  {"Eigensystem::arall", 406161, 12626},
  {"Eigenvalues::arb2", 406620, 12636},
  {"Eigenvectors::arb2", 407071, 12646},
  {"Eigensystem::arb2", 407521, 12656},
  {"Eigenvalues::arbs", 407971, 12666},
  {"Eigenvectors::arbs", 408423, 12676},
  {"Eigensystem::arbs", 408874, 12686},
  {"Eigenvalues::arbss", 409326, 12696},
  {"Eigenvectors::arbss", 409788, 12706},
  {"Eigensystem::arbss", 410249, 12716},
  {"Eigenvalues::arbsym", 410711, 12726},
  {"Eigenvectors::arbsym", 411192, 12737},
  {"Eigensystem::arbsym", 411672, 12748},
  {"Eigenvalues::arerr", 412151, 12759},
  {"Eigenvectors::arerr", 412612, 12769},
  {"Eigensystem::arerr", 413072, 12779},
  {"Eigenvalues::arfac", 413532, 12789},
  {"Eigenvectors::arfac", 413993, 12799},
  {"Eigensystem::arfac", 414453, 12809},
  {"Eigenvalues::argpd", 414913, 12819},
  {"Eigenvectors::argpd", 415376, 12829},
  {"Eigensystem::argpd", 415838, 12839},
  {"Eigenvalues::arh", 416298, 12849},
  {"Eigenvectors::arh", 416740, 12859},
  {"Eigensystem::arh", 417181, 12869},
  {"Eigenvalues::arhm", 417623, 12879},
  {"Eigenvectors::arhm", 418076, 12889},
  {"Eigensystem::arhm", 418528, 12899},
  {"Eigenvalues::arm", 418979, 12909},
  {"Eigenvectors::arm", 419420, 12919},
  {"Eigensystem::arm", 419860, 12929},
  {"Eigenvalues::armc", 420301, 12939},
  {"Eigenvectors::armc", 420752, 12949},
  {"Eigensystem::armc", 421202, 12959},
  {"Eigenvalues::armw", 421652, 12969},
  {"Eigenvectors::armw", 422104, 12979},
  {"Eigensystem::armw", 422555, 12989},
  {"Eigenvalues::ars", 423005, 12999},
  {"Eigenvectors::ars", 423447, 13009},
  {"Eigensystem::ars", 423888, 13019},
  {"Eigenvalues::arstv", 424331, 13029},
  {"Eigenvectors::arstv", 424792, 13039},
  {"Eigensystem::arstv", 425252, 13049},
  {"Eigenvalues::emeth", 425712, 13059},
  {"Eigenvectors::emeth", 426173, 13069},
  {"Eigensystem::emeth", 426633, 13079},
  {"Eigenvalues::maxit2", 427094, 13089},
  {"Eigenvectors::maxit2", 427576, 13100},
  {"Eigensystem::maxit2", 428057, 13111},
  {"LinearSolve::sing1", 428537, 13122},
  {"LinearSolve::sqmat1", 428835, 13129},
  {"SparseArray::posr", 429134, 13136},
  {"LinearSolve::kryme", 429428, 13143},
  {"LinearSolve::kryit", 429725, 13150},
  {"LinearSolve::krytol", 430023, 13157},
  {"LinearSolve::krypre", 430324, 13164},
  {"LinearSolve::krynor", 430625, 13171},
  {"LinearSolve::krynorv", 430927, 13178},
  {"LinearSolve::krydia", 431231, 13185},
  {"LinearSolve::krymit", 431532, 13192},
  {"LinearSolve::krypr", 431832, 13199},
  {"LinearSolve::kryma", 432129, 13206},
  {"LinearSolve::krynom", 432427, 13213},
  {"LinearSolve::krynum", 432728, 13220},
  {"LinearSolve::kryinfp", 433030, 13227},
  {"SparseArray::drnk", 433332, 13234}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 35, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1836, 57, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Rest::norest"],
Cell[1916, 60, 346, 9, 21, "Message",
  CellTags->"Rest::norest"],
Cell[2265, 71, 186, 5, 24, "Notes",
  CellTags->"Rest::norest"],

Cell[CellGroupData[{
Cell[2476, 80, 62, 1, 38, "ExampleSection",
  CellTags->"Rest::norest"],
Cell[2541, 83, 155, 4, 24, "Text",
  CellTags->"Rest::norest"],

Cell[CellGroupData[{
Cell[2721, 91, 93, 3, 26, "Input",
  CellTags->"Rest::norest"],
Cell[2817, 96, 191, 5, 21, "Message",
  CellTags->"Rest::norest"],
Cell[3011, 103, 94, 3, 21, "Output",
  CellTags->"Rest::norest"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[3166, 113, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Cross::nonn1"],
Cell[3246, 116, 236, 5, 53, "Message",
  CellTags->"Cross::nonn1"],
Cell[3485, 123, 542, 14, 68, "Notes",
  CellTags->"Cross::nonn1"],

Cell[CellGroupData[{
Cell[4052, 141, 62, 1, 38, "ExampleSection",
  CellTags->"Cross::nonn1"],
Cell[4117, 144, 119, 4, 24, "Text",
  CellTags->"Cross::nonn1"],

Cell[CellGroupData[{
Cell[4261, 152, 101, 3, 26, "Input",
  CellTags->"Cross::nonn1"],
Cell[4365, 157, 265, 6, 53, "Message",
  CellTags->"Cross::nonn1"],
Cell[4633, 165, 102, 3, 21, "Output",
  CellTags->"Cross::nonn1"]
}, Open  ]],
Cell[4750, 171, 77, 1, 24, "Text",
  CellTags->"Cross::nonn1"],

Cell[CellGroupData[{
Cell[4852, 176, 112, 3, 26, "Input",
  CellTags->"Cross::nonn1"],
Cell[4967, 181, 105, 3, 21, "Output",
  CellTags->"Cross::nonn1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5133, 191, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::mronly"],
Cell[5227, 194, 307, 5, 53, "Message",
  CellTags->"LinearSolve::mronly"],
Cell[5537, 201, 130, 4, 24, "Notes",
  CellTags->"LinearSolve::mronly"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5704, 210, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::mconly"],
Cell[5798, 213, 320, 6, 53, "Message",
  CellTags->"LinearSolve::mconly"],
Cell[6121, 221, 130, 4, 24, "Notes",
  CellTags->"LinearSolve::mconly"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6288, 230, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::mcovl"],
Cell[6380, 233, 372, 6, 69, "Message",
  CellTags->"LinearSolve::mcovl"],
Cell[6755, 241, 129, 4, 24, "Notes",
  CellTags->"LinearSolve::mcovl"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6921, 250, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::nolib"],
Cell[7013, 253, 250, 4, 37, "Message",
  CellTags->"LinearSolve::nolib"],
Cell[7266, 259, 129, 4, 24, "Notes",
  CellTags->"LinearSolve::nolib"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7432, 268, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::lupat"],
Cell[7524, 271, 189, 3, 37, "Message",
  CellTags->"LinearSolve::lupat"],
Cell[7716, 276, 129, 4, 24, "Notes",
  CellTags->"LinearSolve::lupat"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7882, 285, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::sqmat"],
Cell[7974, 288, 429, 9, 37, "Message",
  CellTags->"LinearSolve::sqmat"],
Cell[8406, 299, 129, 4, 24, "Notes",
  CellTags->"LinearSolve::sqmat"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8572, 308, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::npdef"],
Cell[8664, 311, 316, 8, 21, "Message",
  CellTags->"LinearSolve::npdef"],
Cell[8983, 321, 129, 4, 24, "Notes",
  CellTags->"LinearSolve::npdef"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9149, 330, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::herm"],
Cell[9239, 333, 437, 11, 37, "Message",
  CellTags->"LinearSolve::herm"],
Cell[9679, 346, 128, 4, 24, "Notes",
  CellTags->"LinearSolve::herm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9844, 355, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::tmm"],
Cell[9932, 358, 225, 4, 37, "Message",
  CellTags->"LinearSolve::tmm"],
Cell[10160, 364, 127, 4, 24, "Notes",
  CellTags->"LinearSolve::tmm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10324, 373, 304, 8, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Experimental`ExtendedLinearSolve::lsvs", 
    "Experimental`LinearSolveFunction::lsvs", 
    "Developer`SparseLinearSolve::lsvs"}],
Cell[10631, 383, 499, 13, 53, "Message",
  CellTags->{
  "Experimental`ExtendedLinearSolve::lsvs", 
    "Experimental`LinearSolveFunction::lsvs", 
    "Developer`SparseLinearSolve::lsvs"}],
Cell[11133, 398, 243, 7, 24, "Notes",
  CellTags->{
  "Experimental`ExtendedLinearSolve::lsvs", 
    "Experimental`LinearSolveFunction::lsvs", 
    "Developer`SparseLinearSolve::lsvs"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[11413, 410, 228, 7, 51, "ObjectNameWarningMessages",
  CellTags->{
  "CholeskyDecomposition::herm", 
    "Optimization`ModifiedCholeskyDecomposition::herm"}],
Cell[11644, 419, 267, 5, 37, "Message",
  CellTags->{
  "CholeskyDecomposition::herm", 
    "Optimization`ModifiedCholeskyDecomposition::herm"}],
Cell[11914, 426, 200, 6, 24, "Notes",
  CellTags->{
  "CholeskyDecomposition::herm", 
    "Optimization`ModifiedCholeskyDecomposition::herm"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12151, 437, 236, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "CholeskyDecomposition::posdef", 
    "Optimization`ModifiedCholeskyDecomposition::posdef"}],
Cell[12390, 446, 342, 6, 53, "Message",
  CellTags->{
  "CholeskyDecomposition::posdef", 
    "Optimization`ModifiedCholeskyDecomposition::posdef"}],
Cell[12735, 454, 204, 6, 24, "Notes",
  CellTags->{
  "CholeskyDecomposition::posdef", 
    "Optimization`ModifiedCholeskyDecomposition::posdef"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[12976, 465, 249, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "SingularValues::neqcols", "SingularValueList::neqcols", 
    "SingularValueDecomposition::neqcols"}],
Cell[13228, 474, 385, 11, 37, "Message",
  CellTags->{
  "SingularValues::neqcols", "SingularValueList::neqcols", 
    "SingularValueDecomposition::neqcols"}],
Cell[13616, 487, 213, 6, 24, "Notes",
  CellTags->{
  "SingularValues::neqcols", "SingularValueList::neqcols", 
    "SingularValueDecomposition::neqcols"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[13866, 498, 231, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],
Cell[14100, 507, 475, 13, 21, "Message",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],
Cell[14578, 522, 405, 10, 40, "Notes",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],

Cell[CellGroupData[{
Cell[15008, 536, 143, 3, 38, "ExampleSection",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],
Cell[15154, 541, 215, 6, 24, "Text",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],

Cell[CellGroupData[{
Cell[15394, 551, 210, 5, 26, "Input",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],
Cell[15607, 558, 314, 7, 53, "Message",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],
Cell[15924, 567, 211, 5, 21, "Output",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}]
}, Open  ]],
Cell[16150, 575, 219, 6, 24, "Text",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],

Cell[CellGroupData[{
Cell[16394, 585, 213, 5, 26, "Input",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}],
Cell[16610, 592, 470, 10, 53, "Output",
  CellTags->{
  "SingularValueDecomposition::svdf", "SingularValueList::svdf", 
    "SingularValues::svdf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17141, 609, 231, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],
Cell[17375, 618, 518, 15, 21, "Message",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],
Cell[17896, 635, 361, 9, 40, "Notes",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],

Cell[CellGroupData[{
Cell[18282, 648, 143, 3, 38, "ExampleSection",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],
Cell[18428, 653, 214, 6, 24, "Text",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],

Cell[CellGroupData[{
Cell[18667, 663, 216, 5, 26, "Input",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],
Cell[18886, 670, 318, 7, 53, "Message",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],
Cell[19207, 679, 220, 5, 21, "Output",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}]
}, Open  ]],
Cell[19442, 687, 227, 7, 24, "Text",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],

Cell[CellGroupData[{
Cell[19694, 698, 238, 6, 42, "Input",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}],
Cell[19935, 706, 473, 10, 53, "Output",
  CellTags->{
  "SingularValueDecomposition::svdn", "SingularValueList::svdn", 
    "SingularValues::svdn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[20469, 723, 258, 7, 51, "ObjectNameWarningMessages",
  CellTags->{
  "Developer`LinearExpressionToMatrix::nonlin", 
    "Developer`LinearExpressionToSparseMatrix::nonlin"}],
Cell[20730, 732, 356, 9, 21, "Message",
  CellTags->{
  "Developer`LinearExpressionToMatrix::nonlin", 
    "Developer`LinearExpressionToSparseMatrix::nonlin"}],
Cell[21089, 743, 215, 6, 24, "Notes",
  CellTags->{
  "Developer`LinearExpressionToMatrix::nonlin", 
    "Developer`LinearExpressionToSparseMatrix::nonlin"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[21341, 754, 250, 7, 51, "ObjectNameWarningMessages",
  CellTags->{
  "Developer`LinearExpressionToMatrix::lexp", 
    "Developer`LinearExpressionToSparseMatrix::lexp"}],
Cell[21594, 763, 378, 10, 37, "Message",
  CellTags->{
  "Developer`LinearExpressionToMatrix::lexp", 
    "Developer`LinearExpressionToSparseMatrix::lexp"}],
Cell[21975, 775, 211, 6, 24, "Notes",
  CellTags->{
  "Developer`LinearExpressionToMatrix::lexp", 
    "Developer`LinearExpressionToSparseMatrix::lexp"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[22223, 786, 105, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LUBackSubstitution::singlu"],
Cell[22331, 789, 190, 3, 21, "Message",
  CellTags->"LUBackSubstitution::singlu"],
Cell[22524, 794, 137, 4, 24, "Notes",
  CellTags->"LUBackSubstitution::singlu"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22698, 803, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SparseArray::dims"],
Cell[22788, 806, 195, 3, 37, "Message",
  CellTags->"SparseArray::dims"],
Cell[22986, 811, 128, 4, 24, "Notes",
  CellTags->"SparseArray::dims"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23151, 820, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SparseArray::rect"],
Cell[23241, 823, 196, 3, 37, "Message",
  CellTags->"SparseArray::rect"],
Cell[23440, 828, 128, 4, 24, "Notes",
  CellTags->"SparseArray::rect"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23605, 837, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SparseArray::exdims"],
Cell[23699, 840, 193, 3, 37, "Message",
  CellTags->"SparseArray::exdims"],
Cell[23895, 845, 130, 4, 24, "Notes",
  CellTags->"SparseArray::exdims"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24062, 854, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SparseArray::pind"],
Cell[24152, 857, 169, 3, 21, "Message",
  CellTags->"SparseArray::pind"],
Cell[24324, 862, 128, 4, 24, "Notes",
  CellTags->"SparseArray::pind"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24489, 871, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SparseArray::ilist"],
Cell[24581, 874, 180, 3, 21, "Message",
  CellTags->"SparseArray::ilist"],
Cell[24764, 879, 129, 4, 24, "Notes",
  CellTags->"SparseArray::ilist"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24930, 888, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SparseArray::rule"],
Cell[25020, 891, 166, 3, 21, "Message",
  CellTags->"SparseArray::rule"],
Cell[25189, 896, 128, 4, 24, "Notes",
  CellTags->"SparseArray::rule"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25354, 905, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SparseArray::rule1"],
Cell[25446, 908, 182, 3, 21, "Message",
  CellTags->"SparseArray::rule1"],
Cell[25631, 913, 129, 4, 24, "Notes",
  CellTags->"SparseArray::rule1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25797, 922, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SparseArray::ntb"],
Cell[25885, 925, 263, 4, 37, "Message",
  CellTags->"SparseArray::ntb"],
Cell[26151, 931, 127, 4, 24, "Notes",
  CellTags->"SparseArray::ntb"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26315, 940, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SparseArray::pos"],
Cell[26403, 943, 230, 4, 37, "Message",
  CellTags->"SparseArray::pos"],
Cell[26636, 949, 127, 4, 24, "Notes",
  CellTags->"SparseArray::pos"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26800, 958, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SparseArray::valnl"],
Cell[26892, 961, 192, 3, 37, "Message",
  CellTags->"SparseArray::valnl"],
Cell[27087, 966, 129, 4, 24, "Notes",
  CellTags->"SparseArray::valnl"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27253, 975, 187, 5, 51, "ObjectNameWarningMessages",
  CellTags->{
  "SparseArray`SymmetricQ::spmat", "SparseArray`HermitianQ::spmat"}],
Cell[27443, 982, 287, 8, 21, "Message",
  CellTags->{
  "SparseArray`SymmetricQ::spmat", "SparseArray`HermitianQ::spmat"}],
Cell[27733, 992, 178, 5, 24, "Notes",
  CellTags->{
  "SparseArray`SymmetricQ::spmat", "SparseArray`HermitianQ::spmat"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[27948, 1002, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sparv"],
Cell[28032, 1005, 259, 7, 21, "Message",
  CellTags->"General::sparv"],
Cell[28294, 1014, 125, 4, 24, "Notes",
  CellTags->"General::sparv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28456, 1023, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::spts"],
Cell[28538, 1026, 299, 8, 37, "Message",
  CellTags->"General::spts"],
Cell[28840, 1036, 124, 4, 24, "Notes",
  CellTags->"General::spts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29001, 1045, 119, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Developer`SparseLinearSolve::spam"],
Cell[29123, 1048, 405, 6, 85, "Message",
  CellTags->"Developer`SparseLinearSolve::spam"],
Cell[29531, 1056, 144, 4, 24, "Notes",
  CellTags->"Developer`SparseLinearSolve::spam"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29712, 1065, 123, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Developer`SparseLinearSolve::deprec"],
Cell[29838, 1068, 274, 5, 53, "Message",
  CellTags->"Developer`SparseLinearSolve::deprec"],
Cell[30115, 1075, 146, 4, 24, "Notes",
  CellTags->"Developer`SparseLinearSolve::deprec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30298, 1084, 316, 8, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Developer`SparseLinearSolve::fovflw", 
    "Experimental`ExtendedLinearSolve::fovflw", 
    "Experimental`LinearSolveFunction::fovflw"}],
Cell[30617, 1094, 390, 10, 21, "Message",
  CellTags->{
  "Developer`SparseLinearSolve::fovflw", 
    "Experimental`ExtendedLinearSolve::fovflw", 
    "Experimental`LinearSolveFunction::fovflw"}],
Cell[31010, 1106, 249, 7, 24, "Notes",
  CellTags->{
  "Developer`SparseLinearSolve::fovflw", 
    "Experimental`ExtendedLinearSolve::fovflw", 
    "Experimental`LinearSolveFunction::fovflw"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[31296, 1118, 316, 8, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Developer`SparseLinearSolve::sovflw", 
    "Experimental`ExtendedLinearSolve::sovflw", 
    "Experimental`LinearSolveFunction::sovflw"}],
Cell[31615, 1128, 388, 10, 21, "Message",
  CellTags->{
  "Developer`SparseLinearSolve::sovflw", 
    "Experimental`ExtendedLinearSolve::sovflw", 
    "Experimental`LinearSolveFunction::sovflw"}],
Cell[32006, 1140, 249, 7, 24, "Notes",
  CellTags->{
  "Developer`SparseLinearSolve::sovflw", 
    "Experimental`ExtendedLinearSolve::sovflw", 
    "Experimental`LinearSolveFunction::sovflw"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[32292, 1152, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::mindet"],
Cell[32378, 1155, 254, 7, 21, "Message",
  CellTags->"General::mindet"],
Cell[32635, 1164, 500, 16, 62, "Notes",
  CellTags->"General::mindet"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33172, 1185, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blnoval"],
Cell[33260, 1188, 289, 8, 37, "Message",
  CellTags->"General::blnoval"],
Cell[33552, 1198, 185, 4, 24, "Notes",
  CellTags->"General::blnoval"],

Cell[CellGroupData[{
Cell[33762, 1206, 66, 1, 38, "ExampleSection",
  CellTags->"General::blnoval"],
Cell[33831, 1209, 159, 4, 24, "Text",
  CellTags->"General::blnoval"],

Cell[CellGroupData[{
Cell[34015, 1217, 127, 3, 26, "Input",
  CellTags->"General::blnoval"],
Cell[34145, 1222, 236, 5, 37, "Message",
  CellTags->"General::blnoval"],
Cell[34384, 1229, 128, 3, 21, "Output",
  CellTags->"General::blnoval"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[34573, 1239, 152, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
Cell[34728, 1245, 284, 7, 21, "Message",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
Cell[35015, 1254, 342, 8, 40, "Notes",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],

Cell[CellGroupData[{
Cell[35382, 1266, 98, 1, 38, "ExampleSection",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
Cell[35483, 1269, 173, 4, 24, "Text",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],

Cell[CellGroupData[{
Cell[35681, 1277, 160, 3, 26, "Input",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
Cell[35844, 1282, 218, 4, 21, "Message",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
Cell[36065, 1288, 156, 3, 21, "Output",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}]
}, Open  ]],
Cell[36236, 1294, 206, 5, 24, "Text",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],

Cell[CellGroupData[{
Cell[36467, 1303, 167, 3, 26, "Input",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}],
Cell[36637, 1308, 146, 3, 36, "Output",
  CellTags->{"HermiteNormalForm::latm", "LatticeReduce::latm"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36844, 1318, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::cfail"],
Cell[36928, 1321, 225, 7, 21, "Message",
  CellTags->"General::cfail"],
Cell[37156, 1330, 534, 13, 78, "Notes",
  CellTags->"General::cfail"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37727, 1348, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LUDecomposition::sq"],
Cell[37821, 1351, 175, 3, 21, "Message",
  CellTags->"LUDecomposition::sq"],
Cell[37999, 1356, 199, 6, 24, "Notes",
  CellTags->"LUDecomposition::sq"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38235, 1367, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::tol"],
Cell[38315, 1370, 507, 16, 37, "Message",
  CellTags->"General::tol"],
Cell[38825, 1388, 201, 5, 24, "Notes",
  CellTags->"General::tol"],

Cell[CellGroupData[{
Cell[39051, 1397, 62, 1, 38, "ExampleSection",
  CellTags->"General::tol"],
Cell[39116, 1400, 165, 7, 24, "Text",
  CellTags->"General::tol"],

Cell[CellGroupData[{
Cell[39306, 1411, 173, 4, 42, "Input",
  CellTags->"General::tol"],
Cell[39482, 1417, 223, 5, 37, "Message",
  CellTags->"General::tol"],
Cell[39708, 1424, 188, 4, 37, "Output",
  CellTags->"General::tol"]
}, Open  ]],
Cell[39911, 1431, 138, 5, 24, "Text",
  CellTags->"General::tol"],

Cell[CellGroupData[{
Cell[40074, 1440, 172, 4, 42, "Input",
  CellTags->"General::tol"],
Cell[40249, 1446, 260, 5, 39, "Output",
  CellTags->"General::tol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40570, 1458, 102, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Dot::rect", "Tr::rect"}],
Cell[40675, 1464, 299, 8, 21, "Message",
  CellTags->{"Dot::rect", "Tr::rect"}],
Cell[40977, 1474, 268, 7, 40, "Notes",
  CellTags->{"Dot::rect", "Tr::rect"}],

Cell[CellGroupData[{
Cell[41270, 1485, 73, 1, 38, "ExampleSection",
  CellTags->{"Dot::rect", "Tr::rect"}],
Cell[41346, 1488, 147, 4, 24, "Text",
  CellTags->{"Dot::rect", "Tr::rect"}],

Cell[CellGroupData[{
Cell[41518, 1496, 110, 3, 26, "Input",
  CellTags->{"Dot::rect", "Tr::rect"}],
Cell[41631, 1501, 175, 4, 21, "Message",
  CellTags->{"Dot::rect", "Tr::rect"}],
Cell[41809, 1507, 111, 3, 21, "Output",
  CellTags->{"Dot::rect", "Tr::rect"}]
}, Open  ]],
Cell[41935, 1513, 111, 1, 24, "Text",
  CellTags->{"Dot::rect", "Tr::rect"}],

Cell[CellGroupData[{
Cell[42071, 1518, 112, 3, 26, "Input",
  CellTags->{"Dot::rect", "Tr::rect"}],
Cell[42186, 1523, 103, 3, 21, "Output",
  CellTags->{"Dot::rect", "Tr::rect"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[42350, 1533, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DiagonalMatrix::vec"],
Cell[42444, 1536, 258, 5, 37, "Message",
  CellTags->"DiagonalMatrix::vec"],
Cell[42705, 1543, 252, 6, 40, "Notes",
  CellTags->"DiagonalMatrix::vec"],

Cell[CellGroupData[{
Cell[42982, 1553, 69, 1, 38, "ExampleSection",
  CellTags->"DiagonalMatrix::vec"],
Cell[43054, 1556, 200, 6, 40, "Text",
  CellTags->"DiagonalMatrix::vec"],

Cell[CellGroupData[{
Cell[43279, 1566, 124, 3, 26, "Input",
  CellTags->"DiagonalMatrix::vec"],
Cell[43406, 1571, 236, 5, 37, "Message",
  CellTags->"DiagonalMatrix::vec"],
Cell[43645, 1578, 125, 3, 21, "Output",
  CellTags->"DiagonalMatrix::vec"]
}, Open  ]],
Cell[43785, 1584, 136, 5, 24, "Text",
  CellTags->"DiagonalMatrix::vec"],

Cell[CellGroupData[{
Cell[43946, 1593, 114, 3, 26, "Input",
  CellTags->"DiagonalMatrix::vec"],
Cell[44063, 1598, 109, 3, 21, "Output",
  CellTags->"DiagonalMatrix::vec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[44233, 1608, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Dot::dotsh"],
Cell[44309, 1611, 326, 9, 21, "Message",
  CellTags->"Dot::dotsh"],
Cell[44638, 1622, 298, 6, 56, "Notes",
  CellTags->"Dot::dotsh"],

Cell[CellGroupData[{
Cell[44961, 1632, 60, 1, 38, "ExampleSection",
  CellTags->"Dot::dotsh"],
Cell[45024, 1635, 199, 5, 40, "Text",
  CellTags->"Dot::dotsh"],

Cell[CellGroupData[{
Cell[45248, 1644, 113, 3, 26, "Input",
  CellTags->"Dot::dotsh"],
Cell[45364, 1649, 232, 5, 37, "Message",
  CellTags->"Dot::dotsh"],
Cell[45599, 1656, 114, 3, 21, "Output",
  CellTags->"Dot::dotsh"]
}, Open  ]],
Cell[45728, 1662, 126, 4, 24, "Text",
  CellTags->"Dot::dotsh"],

Cell[CellGroupData[{
Cell[45879, 1670, 115, 3, 26, "Input",
  CellTags->"Dot::dotsh"],
Cell[45997, 1675, 126, 3, 21, "Output",
  CellTags->"Dot::dotsh"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[46184, 1685, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Dot::dotpat"],
Cell[46262, 1688, 192, 5, 37, "Message",
  CellTags->"Dot::dotpat"],
Cell[46457, 1695, 122, 4, 24, "Notes",
  CellTags->"Dot::dotpat"]
}, Open  ]],

Cell[CellGroupData[{
Cell[46616, 1704, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::eivn"],
Cell[46698, 1707, 514, 16, 37, "Message",
  CellTags->"General::eivn"],
Cell[47215, 1725, 671, 11, 122, "Notes",
  CellTags->"General::eivn"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47923, 1741, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::eivec"],
Cell[48007, 1744, 394, 12, 21, "Message",
  CellTags->"General::eivec"],
Cell[48404, 1758, 712, 13, 122, "Notes",
  CellTags->"General::eivec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49153, 1776, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::eival"],
Cell[49237, 1779, 268, 7, 21, "Message",
  CellTags->"General::eival"],
Cell[49508, 1788, 616, 11, 106, "Notes",
  CellTags->"General::eival"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50161, 1804, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::inf"],
Cell[50241, 1807, 243, 7, 21, "Message",
  CellTags->"General::inf"],
Cell[50487, 1816, 518, 16, 78, "Notes",
  CellTags->"General::inf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[51042, 1837, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::pvec"],
Cell[51124, 1840, 406, 12, 21, "Message",
  CellTags->"General::pvec"],
Cell[51533, 1854, 330, 7, 46, "Notes",
  CellTags->"General::pvec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[51900, 1866, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sing"],
Cell[51982, 1869, 316, 9, 21, "Message",
  CellTags->"General::sing"],
Cell[52301, 1880, 167, 4, 24, "Notes",
  CellTags->"General::sing"],

Cell[CellGroupData[{
Cell[52493, 1888, 63, 1, 38, "ExampleSection",
  CellTags->"General::sing"],
Cell[52559, 1891, 132, 4, 24, "Text",
  CellTags->"General::sing"],

Cell[CellGroupData[{
Cell[52716, 1899, 111, 3, 26, "Input",
  CellTags->"General::sing"],
Cell[52830, 1904, 194, 5, 21, "Message",
  CellTags->"General::sing"],
Cell[53027, 1911, 112, 3, 21, "Output",
  CellTags->"General::sing"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[53200, 1921, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Inner::incom"],
Cell[53280, 1924, 561, 16, 37, "Message",
  CellTags->"Inner::incom"],
Cell[53844, 1942, 192, 5, 24, "Notes",
  CellTags->"Inner::incom"],

Cell[CellGroupData[{
Cell[54061, 1951, 62, 1, 38, "ExampleSection",
  CellTags->"Inner::incom"],
Cell[54126, 1954, 228, 5, 40, "Text",
  CellTags->"Inner::incom"],

Cell[CellGroupData[{
Cell[54379, 1963, 118, 3, 26, "Input",
  CellTags->"Inner::incom"],
Cell[54500, 1968, 279, 6, 37, "Message",
  CellTags->"Inner::incom"],
Cell[54782, 1976, 119, 3, 21, "Output",
  CellTags->"Inner::incom"]
}, Open  ]],
Cell[54916, 1982, 120, 5, 24, "Text",
  CellTags->"Inner::incom"],

Cell[CellGroupData[{
Cell[55061, 1991, 116, 3, 26, "Input",
  CellTags->"Inner::incom"],
Cell[55180, 1996, 90, 3, 21, "Output",
  CellTags->"Inner::incom"]
}, Open  ]],
Cell[55285, 2002, 142, 5, 24, "Text",
  CellTags->"Inner::incom"],

Cell[CellGroupData[{
Cell[55452, 2011, 129, 3, 26, "Input",
  CellTags->"Inner::incom"],
Cell[55584, 2016, 90, 3, 21, "Output",
  CellTags->"Inner::incom"]
}, Open  ]],
Cell[55689, 2022, 204, 6, 40, "Text",
  CellTags->"Inner::incom"],

Cell[CellGroupData[{
Cell[55918, 2032, 128, 3, 26, "Input",
  CellTags->"Inner::incom"],
Cell[56049, 2037, 92, 3, 21, "Output",
  CellTags->"Inner::incom"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[56202, 2047, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Inner::inntf"],
Cell[56282, 2050, 204, 5, 21, "Message",
  CellTags->"Inner::inntf"],
Cell[56489, 2057, 464, 10, 84, "Notes",
  CellTags->"Inner::inntf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[56990, 2072, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Inner::nolev"],
Cell[57070, 2075, 449, 13, 21, "Message",
  CellTags->"Inner::nolev"],
Cell[57522, 2090, 239, 6, 40, "Notes",
  CellTags->"Inner::nolev"],

Cell[CellGroupData[{
Cell[57786, 2100, 62, 1, 38, "ExampleSection",
  CellTags->"Inner::nolev"],
Cell[57851, 2103, 193, 5, 40, "Text",
  CellTags->"Inner::nolev"],

Cell[CellGroupData[{
Cell[58069, 2112, 130, 3, 26, "Input",
  CellTags->"Inner::nolev"],
Cell[58202, 2117, 226, 5, 37, "Message",
  CellTags->"Inner::nolev"],
Cell[58431, 2124, 131, 3, 21, "Output",
  CellTags->"Inner::nolev"]
}, Open  ]],
Cell[58577, 2130, 124, 5, 24, "Text",
  CellTags->"Inner::nolev"],

Cell[CellGroupData[{
Cell[58726, 2139, 135, 3, 26, "Input",
  CellTags->"Inner::nolev"],
Cell[58864, 2144, 108, 3, 21, "Output",
  CellTags->"Inner::nolev"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[59033, 2154, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LUBackSubstitution::bpvt"],
Cell[59137, 2157, 259, 5, 21, "Message",
  CellTags->"LUBackSubstitution::bpvt"],
Cell[59399, 2164, 465, 10, 84, "Notes",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[CellGroupData[{
Cell[59889, 2178, 74, 1, 38, "ExampleSection",
  CellTags->"LUBackSubstitution::bpvt"],
Cell[59966, 2181, 183, 4, 40, "Text",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[CellGroupData[{
Cell[60174, 2189, 155, 3, 26, "Input",
  CellTags->"LUBackSubstitution::bpvt"],
Cell[60332, 2194, 206, 4, 21, "Message",
  CellTags->"LUBackSubstitution::bpvt"],
Cell[60541, 2200, 158, 4, 21, "Output",
  CellTags->"LUBackSubstitution::bpvt"]
}, Open  ]],
Cell[60714, 2207, 157, 5, 24, "Text",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[CellGroupData[{
Cell[60896, 2216, 154, 3, 26, "Input",
  CellTags->"LUBackSubstitution::bpvt"],
Cell[61053, 2221, 109, 3, 21, "Output",
  CellTags->"LUBackSubstitution::bpvt"]
}, Open  ]],
Cell[61177, 2227, 223, 7, 40, "Text",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[CellGroupData[{
Cell[61425, 2238, 138, 3, 26, "Input",
  CellTags->"LUBackSubstitution::bpvt"],
Cell[61566, 2243, 127, 3, 21, "Output",
  CellTags->"LUBackSubstitution::bpvt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[61730, 2251, 130, 3, 26, "Input",
  CellTags->"LUBackSubstitution::bpvt"],
Cell[61863, 2256, 109, 3, 21, "Output",
  CellTags->"LUBackSubstitution::bpvt"]
}, Open  ]],
Cell[61987, 2262, 140, 4, 24, "Text",
  CellTags->"LUBackSubstitution::bpvt"],

Cell[CellGroupData[{
Cell[62152, 2270, 134, 3, 26, "Input",
  CellTags->"LUBackSubstitution::bpvt"],
Cell[62289, 2275, 109, 3, 21, "Output",
  CellTags->"LUBackSubstitution::bpvt"]
}, Open  ]],
Cell[62413, 2281, 125, 5, 24, "Text",
  CellTags->"LUBackSubstitution::bpvt"],
Cell[62541, 2288, 109, 3, 26, "Input",
  CellTags->"LUBackSubstitution::bpvt"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[62699, 2297, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::lsfail"],
Cell[62793, 2300, 192, 3, 37, "Message",
  CellTags->"LinearSolve::lsfail"],
Cell[62988, 2305, 199, 6, 24, "Notes",
  CellTags->"LinearSolve::lsfail"]
}, Open  ]],

Cell[CellGroupData[{
Cell[63224, 2316, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::lslc"],
Cell[63306, 2319, 307, 9, 37, "Message",
  CellTags->"General::lslc"],
Cell[63616, 2330, 341, 9, 46, "Notes",
  CellTags->"General::lslc"],

Cell[CellGroupData[{
Cell[63982, 2343, 63, 1, 38, "ExampleSection",
  CellTags->"General::lslc"],
Cell[64048, 2346, 218, 5, 40, "Text",
  CellTags->"General::lslc"],

Cell[CellGroupData[{
Cell[64291, 2355, 129, 3, 26, "Input",
  CellTags->"General::lslc"],
Cell[64423, 2360, 219, 5, 37, "Message",
  CellTags->"General::lslc"],
Cell[64645, 2367, 130, 3, 21, "Output",
  CellTags->"General::lslc"]
}, Open  ]],
Cell[64790, 2373, 140, 5, 24, "Text",
  CellTags->"General::lslc"],

Cell[CellGroupData[{
Cell[64955, 2382, 123, 3, 26, "Input",
  CellTags->"General::lslc"],
Cell[65081, 2387, 108, 3, 36, "Output",
  CellTags->"General::lslc"]
}, Open  ]],

Cell[CellGroupData[{
Cell[65226, 2395, 139, 3, 26, "Input",
  CellTags->"General::lslc"],
Cell[65368, 2400, 144, 3, 36, "Output",
  CellTags->"General::lslc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[65573, 2410, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::lsv"],
Cell[65653, 2413, 465, 13, 37, "Message",
  CellTags->"General::lsv"],
Cell[66121, 2428, 312, 9, 46, "Notes",
  CellTags->"General::lsv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[66470, 2442, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::nosol"],
Cell[66562, 2445, 180, 3, 21, "Message",
  CellTags->"LinearSolve::nosol"],
Cell[66745, 2450, 187, 5, 24, "Notes",
  CellTags->"LinearSolve::nosol"],

Cell[CellGroupData[{
Cell[66957, 2459, 68, 1, 38, "ExampleSection",
  CellTags->"LinearSolve::nosol"],
Cell[67028, 2462, 139, 4, 24, "Text",
  CellTags->"LinearSolve::nosol"],

Cell[CellGroupData[{
Cell[67192, 2470, 128, 3, 26, "Input",
  CellTags->"LinearSolve::nosol"],
Cell[67323, 2475, 194, 4, 37, "Message",
  CellTags->"LinearSolve::nosol"],
Cell[67520, 2481, 129, 3, 21, "Output",
  CellTags->"LinearSolve::nosol"]
}, Open  ]],
Cell[67664, 2487, 138, 5, 24, "Text",
  CellTags->"LinearSolve::nosol"],

Cell[CellGroupData[{
Cell[67827, 2496, 139, 3, 26, "Input",
  CellTags->"LinearSolve::nosol"],
Cell[67969, 2501, 94, 3, 21, "Output",
  CellTags->"LinearSolve::nosol"]
}, Open  ]],
Cell[68078, 2507, 121, 4, 24, "Text",
  CellTags->"LinearSolve::nosol"],

Cell[CellGroupData[{
Cell[68224, 2515, 128, 3, 26, "Input",
  CellTags->"LinearSolve::nosol"],
Cell[68355, 2520, 98, 3, 21, "Output",
  CellTags->"LinearSolve::nosol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[68514, 2530, 214, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],
Cell[68731, 2540, 652, 18, 53, "Message",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],
Cell[69386, 2560, 300, 8, 40, "Notes",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],

Cell[CellGroupData[{
Cell[69711, 2572, 136, 3, 38, "ExampleSection",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],
Cell[69850, 2577, 324, 11, 40, "Text",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],

Cell[CellGroupData[{
Cell[70199, 2592, 249, 6, 42, "Input",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],
Cell[70451, 2600, 345, 8, 53, "Message",
  CellTags->{
  "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "RowReduce::rmeth"}],
Cell[70799, 2610, 255, 6, 37, "Output",
  CellTags->{
  "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "RowReduce::rmeth"}]
}, Open  ]],
Cell[71069, 2619, 248, 9, 24, "Text",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],

Cell[CellGroupData[{
Cell[71342, 2632, 255, 6, 42, "Input",
  CellTags->{
  "RowReduce::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "Inverse::rmeth"}],
Cell[71600, 2640, 1769, 31, 293, "Output",
  CellTags->{
  "Inverse::rmeth", "LinearSolve::rmeth", "NullSpace::rmeth", 
    "RowReduce::rmeth"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[73430, 2678, 205, 5, 51, "ObjectNameWarningMessages",
  CellTags->{
  "SchurDecomposition::schurf", 
    "Developer`HessenbergDecomposition::schurf"}],
Cell[73638, 2685, 467, 12, 21, "Message",
  CellTags->{
  "SchurDecomposition::schurf", 
    "Developer`HessenbergDecomposition::schurf"}],
Cell[74108, 2699, 324, 7, 40, "Notes",
  CellTags->{
  "SchurDecomposition::schurf", 
    "Developer`HessenbergDecomposition::schurf"}],

Cell[CellGroupData[{
Cell[74457, 2710, 126, 2, 38, "ExampleSection",
  CellTags->{
  "SchurDecomposition::schurf", 
    "Developer`HessenbergDecomposition::schurf"}],
Cell[74586, 2714, 198, 5, 24, "Text",
  CellTags->{
  "SchurDecomposition::schurf", 
    "Developer`HessenbergDecomposition::schurf"}],

Cell[CellGroupData[{
Cell[74809, 2723, 185, 4, 26, "Input",
  CellTags->{
  "SchurDecomposition::schurf", 
    "Developer`HessenbergDecomposition::schurf"}],
Cell[74997, 2729, 283, 6, 37, "Message",
  CellTags->{
  "Developer`HessenbergDecomposition::schurf", 
    "SchurDecomposition::schurf"}],
Cell[75283, 2737, 186, 4, 21, "Output",
  CellTags->{
  "Developer`HessenbergDecomposition::schurf", "SchurDecomposition::schurf"}]
}, Open  ]],
Cell[75484, 2744, 202, 5, 24, "Text",
  CellTags->{
  "SchurDecomposition::schurf", 
    "Developer`HessenbergDecomposition::schurf"}],

Cell[CellGroupData[{
Cell[75711, 2753, 188, 4, 26, "Input",
  CellTags->{
  "SchurDecomposition::schurf", 
    "Developer`HessenbergDecomposition::schurf"}],
Cell[75902, 2759, 202, 4, 21, "Output",
  CellTags->{
  "Developer`HessenbergDecomposition::schurf", "SchurDecomposition::schurf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[76165, 2770, 205, 5, 51, "ObjectNameWarningMessages",
  CellTags->{
  "SchurDecomposition::schurn", 
    "Developer`HessenbergDecomposition::schurn"}],
Cell[76373, 2777, 501, 14, 21, "Message",
  CellTags->{
  "SchurDecomposition::schurn", 
    "Developer`HessenbergDecomposition::schurn"}],
Cell[76877, 2793, 287, 6, 40, "Notes",
  CellTags->{
  "SchurDecomposition::schurn", 
    "Developer`HessenbergDecomposition::schurn"}],

Cell[CellGroupData[{
Cell[77189, 2803, 126, 2, 38, "ExampleSection",
  CellTags->{
  "SchurDecomposition::schurn", 
    "Developer`HessenbergDecomposition::schurn"}],
Cell[77318, 2807, 197, 5, 24, "Text",
  CellTags->{
  "SchurDecomposition::schurn", 
    "Developer`HessenbergDecomposition::schurn"}],

Cell[CellGroupData[{
Cell[77540, 2816, 189, 4, 26, "Input",
  CellTags->{
  "SchurDecomposition::schurn", 
    "Developer`HessenbergDecomposition::schurn"}],
Cell[77732, 2822, 285, 6, 37, "Message",
  CellTags->{
  "Developer`HessenbergDecomposition::schurn", 
    "SchurDecomposition::schurn"}],
Cell[78020, 2830, 191, 4, 21, "Output",
  CellTags->{
  "Developer`HessenbergDecomposition::schurn", "SchurDecomposition::schurn"}]
}, Open  ]],
Cell[78226, 2837, 202, 6, 24, "Text",
  CellTags->{
  "SchurDecomposition::schurn", 
    "Developer`HessenbergDecomposition::schurn"}],

Cell[CellGroupData[{
Cell[78453, 2847, 204, 4, 26, "Input",
  CellTags->{
  "SchurDecomposition::schurn", 
    "Developer`HessenbergDecomposition::schurn"}],
Cell[78660, 2853, 323, 6, 37, "Output",
  CellTags->{
  "Developer`HessenbergDecomposition::schurn", "SchurDecomposition::schurn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[79044, 2866, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::unpack1"],
Cell[79132, 2869, 223, 7, 21, "Message",
  CellTags->"General::unpack1"],
Cell[79358, 2878, 382, 8, 68, "Notes",
  CellTags->"General::unpack1"],

Cell[CellGroupData[{
Cell[79765, 2890, 66, 1, 38, "ExampleSection",
  CellTags->"General::unpack1"],
Cell[79834, 2893, 153, 4, 24, "Text",
  CellTags->"General::unpack1"],

Cell[CellGroupData[{
Cell[80012, 2901, 151, 4, 26, "Input",
  CellTags->"General::unpack1"],
Cell[80166, 2907, 118, 3, 21, "Output",
  CellTags->"General::unpack1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[80321, 2915, 140, 3, 26, "Input",
  CellTags->"General::unpack1"],
Cell[80464, 2920, 174, 4, 21, "Message",
  CellTags->"General::unpack1"],
Cell[80641, 2926, 108, 3, 21, "Output",
  CellTags->"General::unpack1"]
}, Open  ]],
Cell[80764, 2932, 75, 1, 24, "Text",
  CellTags->"General::unpack1"],

Cell[CellGroupData[{
Cell[80864, 2937, 159, 4, 26, "Input",
  CellTags->"General::unpack1"],
Cell[81026, 2943, 119, 3, 21, "Output",
  CellTags->"General::unpack1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[81206, 2953, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::unpack"],
Cell[81292, 2956, 363, 11, 21, "Message",
  CellTags->"General::unpack"],
Cell[81658, 2969, 381, 8, 68, "Notes",
  CellTags->"General::unpack"],

Cell[CellGroupData[{
Cell[82064, 2981, 65, 1, 38, "ExampleSection",
  CellTags->"General::unpack"],
Cell[82132, 2984, 153, 4, 24, "Text",
  CellTags->"General::unpack"],

Cell[CellGroupData[{
Cell[82310, 2992, 150, 4, 26, "Input",
  CellTags->"General::unpack"],
Cell[82463, 2998, 117, 3, 21, "Output",
  CellTags->"General::unpack"]
}, Open  ]],

Cell[CellGroupData[{
Cell[82617, 3006, 125, 3, 26, "Input",
  CellTags->"General::unpack"],
Cell[82745, 3011, 173, 4, 21, "Message",
  CellTags->"General::unpack"],
Cell[82921, 3017, 139, 3, 21, "Output",
  CellTags->"General::unpack"]
}, Open  ]],
Cell[83075, 3023, 74, 1, 24, "Text",
  CellTags->"General::unpack"],

Cell[CellGroupData[{
Cell[83174, 3028, 158, 4, 26, "Input",
  CellTags->"General::unpack"],
Cell[83335, 3034, 118, 3, 21, "Output",
  CellTags->"General::unpack"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[83514, 3044, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::punpack"],
Cell[83602, 3047, 431, 13, 21, "Message",
  CellTags->"General::punpack"],
Cell[84036, 3062, 392, 8, 68, "Notes",
  CellTags->"General::punpack"]
}, Open  ]],

Cell[CellGroupData[{
Cell[84465, 3075, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::punpack1"],
Cell[84555, 3078, 357, 11, 21, "Message",
  CellTags->"General::punpack1"],
Cell[84915, 3091, 393, 8, 68, "Notes",
  CellTags->"General::punpack1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85345, 3104, 125, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Testing`Internal`MVectorNorm::mrange"],
Cell[85473, 3107, 243, 4, 37, "Message",
  CellTags->"Testing`Internal`MVectorNorm::mrange"],
Cell[85719, 3113, 147, 4, 24, "Notes",
  CellTags->"Testing`Internal`MVectorNorm::mrange"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85903, 3122, 129, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Testing`Internal`MVectorNorm::mvntestp"],
Cell[86035, 3125, 266, 4, 53, "Message",
  CellTags->"Testing`Internal`MVectorNorm::mvntestp"],
Cell[86304, 3131, 149, 4, 24, "Notes",
  CellTags->"Testing`Internal`MVectorNorm::mvntestp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[86490, 3140, 129, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Testing`Internal`MVectorNorm::mvntestv"],
Cell[86622, 3143, 271, 4, 53, "Message",
  CellTags->"Testing`Internal`MVectorNorm::mvntestv"],
Cell[86896, 3149, 149, 4, 24, "Notes",
  CellTags->"Testing`Internal`MVectorNorm::mvntestv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87082, 3158, 137, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Testing`Internal`MScaledVectorNorm::mrange"],
Cell[87222, 3161, 255, 4, 37, "Message",
  CellTags->"Testing`Internal`MScaledVectorNorm::mrange"],
Cell[87480, 3167, 153, 4, 24, "Notes",
  CellTags->"Testing`Internal`MScaledVectorNorm::mrange"]
}, Open  ]],

Cell[CellGroupData[{
Cell[87670, 3176, 143, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Testing`Internal`MScaledVectorNorm::mvntestp"],
Cell[87816, 3180, 278, 4, 53, "Message",
  CellTags->"Testing`Internal`MScaledVectorNorm::mvntestp"],
Cell[88097, 3186, 155, 4, 24, "Notes",
  CellTags->"Testing`Internal`MScaledVectorNorm::mvntestp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88289, 3195, 143, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Testing`Internal`MScaledVectorNorm::mvntestv"],
Cell[88435, 3199, 283, 4, 53, "Message",
  CellTags->"Testing`Internal`MScaledVectorNorm::mvntestv"],
Cell[88721, 3205, 155, 4, 24, "Notes",
  CellTags->"Testing`Internal`MScaledVectorNorm::mvntestv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[88913, 3214, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Inverse::invc"],
Cell[88995, 3217, 340, 7, 37, "Message",
  CellTags->"Inverse::invc"],
Cell[89338, 3226, 193, 6, 24, "Notes",
  CellTags->"Inverse::invc"]
}, Open  ]],

Cell[CellGroupData[{
Cell[89568, 3237, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"MatrixPower::zvec", "MatrixExp::zvec"}],
Cell[89703, 3243, 508, 14, 37, "Message",
  CellTags->{"MatrixPower::zvec", "MatrixExp::zvec"}],
Cell[90214, 3259, 409, 8, 78, "Notes",
  CellTags->{"MatrixPower::zvec", "MatrixExp::zvec"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[90660, 3272, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Range::range"],
Cell[90740, 3275, 274, 6, 21, "Message",
  CellTags->"Range::range"],
Cell[91017, 3283, 269, 6, 40, "Notes",
  CellTags->"Range::range"],

Cell[CellGroupData[{
Cell[91311, 3293, 62, 1, 38, "ExampleSection",
  CellTags->"Range::range"],
Cell[91376, 3296, 127, 4, 24, "Text",
  CellTags->"Range::range"],

Cell[CellGroupData[{
Cell[91528, 3304, 96, 3, 26, "Input",
  CellTags->"Range::range"],
Cell[91627, 3309, 226, 5, 37, "Message",
  CellTags->"Range::range"],
Cell[91856, 3316, 109, 3, 21, "Output",
  CellTags->"Range::range"]
}, Open  ]],
Cell[91980, 3322, 125, 5, 24, "Text",
  CellTags->"Range::range"],

Cell[CellGroupData[{
Cell[92130, 3331, 93, 3, 26, "Input",
  CellTags->"Range::range"],
Cell[92226, 3336, 95, 3, 21, "Output",
  CellTags->"Range::range"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[92382, 3346, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Transpose::diagnl"],
Cell[92472, 3349, 290, 6, 37, "Message",
  CellTags->"Transpose::diagnl"],
Cell[92765, 3357, 290, 7, 40, "Notes",
  CellTags->"Transpose::diagnl"],

Cell[CellGroupData[{
Cell[93080, 3368, 67, 1, 38, "ExampleSection",
  CellTags->"Transpose::diagnl"],
Cell[93150, 3371, 157, 4, 24, "Text",
  CellTags->"Transpose::diagnl"],

Cell[CellGroupData[{
Cell[93332, 3379, 133, 3, 26, "Input",
  CellTags->"Transpose::diagnl"],
Cell[93468, 3384, 232, 5, 37, "Message",
  CellTags->"Transpose::diagnl"],
Cell[93703, 3391, 134, 3, 21, "Output",
  CellTags->"Transpose::diagnl"]
}, Open  ]],
Cell[93852, 3397, 155, 4, 24, "Text",
  CellTags->"Transpose::diagnl"],

Cell[CellGroupData[{
Cell[94032, 3405, 125, 3, 26, "Input",
  CellTags->"Transpose::diagnl"],
Cell[94160, 3410, 97, 3, 21, "Output",
  CellTags->"Transpose::diagnl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[94318, 3420, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Transpose::newdims"],
Cell[94410, 3423, 414, 11, 37, "Message",
  CellTags->"Transpose::newdims"],
Cell[94827, 3436, 197, 5, 40, "Notes",
  CellTags->"Transpose::newdims"],

Cell[CellGroupData[{
Cell[95049, 3445, 68, 1, 38, "ExampleSection",
  CellTags->"Transpose::newdims"],
Cell[95120, 3448, 166, 4, 24, "Text",
  CellTags->"Transpose::newdims"],

Cell[CellGroupData[{
Cell[95311, 3456, 133, 3, 26, "Input",
  CellTags->"Transpose::newdims"],
Cell[95447, 3461, 229, 5, 37, "Message",
  CellTags->"Transpose::newdims"],
Cell[95679, 3468, 134, 3, 21, "Output",
  CellTags->"Transpose::newdims"]
}, Open  ]],
Cell[95828, 3474, 152, 5, 24, "Text",
  CellTags->"Transpose::newdims"],

Cell[CellGroupData[{
Cell[96005, 3483, 133, 3, 26, "Input",
  CellTags->"Transpose::newdims"],
Cell[96141, 3488, 116, 3, 21, "Output",
  CellTags->"Transpose::newdims"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[96318, 3498, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Transpose::nmtx"],
Cell[96404, 3501, 289, 6, 37, "Message",
  CellTags->"Transpose::nmtx"],
Cell[96696, 3509, 176, 5, 24, "Notes",
  CellTags->"Transpose::nmtx"],

Cell[CellGroupData[{
Cell[96897, 3518, 65, 1, 38, "ExampleSection",
  CellTags->"Transpose::nmtx"],
Cell[96965, 3521, 190, 5, 24, "Text",
  CellTags->"Transpose::nmtx"],

Cell[CellGroupData[{
Cell[97180, 3530, 108, 3, 26, "Input",
  CellTags->"Transpose::nmtx"],
Cell[97291, 3535, 226, 5, 37, "Message",
  CellTags->"Transpose::nmtx"],
Cell[97520, 3542, 109, 3, 21, "Output",
  CellTags->"Transpose::nmtx"]
}, Open  ]],
Cell[97644, 3548, 139, 5, 24, "Text",
  CellTags->"Transpose::nmtx"],

Cell[CellGroupData[{
Cell[97808, 3557, 110, 3, 26, "Input",
  CellTags->"Transpose::nmtx"],
Cell[97921, 3562, 104, 3, 21, "Output",
  CellTags->"Transpose::nmtx"]
}, Open  ]],
Cell[98040, 3568, 215, 7, 24, "Text",
  CellTags->"Transpose::nmtx"],

Cell[CellGroupData[{
Cell[98280, 3579, 113, 3, 26, "Input",
  CellTags->"Transpose::nmtx"],
Cell[98396, 3584, 98, 3, 21, "Output",
  CellTags->"Transpose::nmtx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[98555, 3594, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Transpose::tperm"],
Cell[98643, 3597, 401, 10, 37, "Message",
  CellTags->"Transpose::tperm"],
Cell[99047, 3609, 248, 6, 40, "Notes",
  CellTags->"Transpose::tperm"],

Cell[CellGroupData[{
Cell[99320, 3619, 66, 1, 38, "ExampleSection",
  CellTags->"Transpose::tperm"],
Cell[99389, 3622, 245, 6, 40, "Text",
  CellTags->"Transpose::tperm"],

Cell[CellGroupData[{
Cell[99659, 3632, 117, 3, 26, "Input",
  CellTags->"Transpose::tperm"],
Cell[99779, 3637, 220, 5, 37, "Message",
  CellTags->"Transpose::tperm"],
Cell[100002, 3644, 118, 3, 21, "Output",
  CellTags->"Transpose::tperm"]
}, Open  ]],
Cell[100135, 3650, 186, 5, 24, "Text",
  CellTags->"Transpose::tperm"],

Cell[CellGroupData[{
Cell[100346, 3659, 114, 3, 26, "Input",
  CellTags->"Transpose::tperm"],
Cell[100463, 3664, 99, 3, 21, "Output",
  CellTags->"Transpose::tperm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[100623, 3674, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Transpose::perm"],
Cell[100709, 3677, 419, 11, 37, "Message",
  CellTags->"Transpose::perm"],
Cell[101131, 3690, 195, 6, 24, "Notes",
  CellTags->"Transpose::perm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[101363, 3701, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Transpose::perm1"],
Cell[101451, 3704, 358, 9, 37, "Message",
  CellTags->"Transpose::perm1"],
Cell[101812, 3715, 293, 7, 40, "Notes",
  CellTags->"Transpose::perm1"],

Cell[CellGroupData[{
Cell[102130, 3726, 66, 1, 38, "ExampleSection",
  CellTags->"Transpose::perm1"],
Cell[102199, 3729, 215, 6, 40, "Text",
  CellTags->"Transpose::perm1"],

Cell[CellGroupData[{
Cell[102439, 3739, 126, 3, 26, "Input",
  CellTags->"Transpose::perm1"],
Cell[102568, 3744, 229, 5, 37, "Message",
  CellTags->"Transpose::perm1"],
Cell[102800, 3751, 127, 3, 21, "Output",
  CellTags->"Transpose::perm1"]
}, Open  ]],
Cell[102942, 3757, 132, 5, 24, "Text",
  CellTags->"Transpose::perm1"],

Cell[CellGroupData[{
Cell[103099, 3766, 124, 3, 26, "Input",
  CellTags->"Transpose::perm1"],
Cell[103226, 3771, 106, 3, 21, "Output",
  CellTags->"Transpose::perm1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[103393, 3781, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Transpose::perm2"],
Cell[103481, 3784, 372, 10, 21, "Message",
  CellTags->"Transpose::perm2"],
Cell[103856, 3796, 281, 7, 40, "Notes",
  CellTags->"Transpose::perm2"],

Cell[CellGroupData[{
Cell[104162, 3807, 66, 1, 38, "ExampleSection",
  CellTags->"Transpose::perm2"],
Cell[104231, 3810, 231, 5, 40, "Text",
  CellTags->"Transpose::perm2"],

Cell[CellGroupData[{
Cell[104487, 3819, 124, 3, 26, "Input",
  CellTags->"Transpose::perm2"],
Cell[104614, 3824, 202, 5, 21, "Message",
  CellTags->"Transpose::perm2"],
Cell[104819, 3831, 125, 3, 21, "Output",
  CellTags->"Transpose::perm2"]
}, Open  ]],
Cell[104959, 3837, 132, 5, 24, "Text",
  CellTags->"Transpose::perm2"],

Cell[CellGroupData[{
Cell[105116, 3846, 124, 3, 26, "Input",
  CellTags->"Transpose::perm2"],
Cell[105243, 3851, 106, 3, 21, "Output",
  CellTags->"Transpose::perm2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[105410, 3861, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::lconv"],
Cell[105494, 3864, 238, 7, 21, "Message",
  CellTags->"General::lconv"],
Cell[105735, 3873, 553, 15, 84, "Notes",
  CellTags->"General::lconv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[106325, 3893, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::luc"],
Cell[106405, 3896, 502, 14, 37, "Message",
  CellTags->"General::luc"],
Cell[106910, 3912, 314, 6, 62, "Notes",
  CellTags->"General::luc"]
}, Open  ]],

Cell[CellGroupData[{
Cell[107261, 3923, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::matrix"],
Cell[107347, 3926, 455, 12, 37, "Message",
  CellTags->"General::matrix"],
Cell[107805, 3940, 592, 11, 100, "Notes",
  CellTags->"General::matrix"],

Cell[CellGroupData[{
Cell[108422, 3955, 65, 1, 38, "ExampleSection",
  CellTags->"General::matrix"],
Cell[108490, 3958, 148, 5, 24, "Text",
  CellTags->"General::matrix"],

Cell[CellGroupData[{
Cell[108663, 3967, 129, 3, 26, "Input",
  CellTags->"General::matrix"],
Cell[108795, 3972, 273, 5, 53, "Message",
  CellTags->"General::matrix"],
Cell[109071, 3979, 134, 3, 21, "Output",
  CellTags->"General::matrix"]
}, Open  ]],
Cell[109220, 3985, 133, 5, 24, "Text",
  CellTags->"General::matrix"],

Cell[CellGroupData[{
Cell[109378, 3994, 127, 3, 26, "Input",
  CellTags->"General::matrix"],
Cell[109508, 3999, 198, 5, 21, "Output",
  CellTags->"General::matrix"]
}, Open  ]],
Cell[109721, 4007, 81, 2, 26, "Input",
  CellTags->"General::matrix"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[109851, 4015, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::matsq"],
Cell[109935, 4018, 448, 12, 21, "Message",
  CellTags->"General::matsq"],
Cell[110386, 4032, 314, 7, 62, "Notes",
  CellTags->"General::matsq"],

Cell[CellGroupData[{
Cell[110725, 4043, 64, 1, 38, "ExampleSection",
  CellTags->"General::matsq"],
Cell[110792, 4046, 184, 5, 24, "Text",
  CellTags->"General::matsq"],

Cell[CellGroupData[{
Cell[111001, 4055, 106, 3, 26, "Input",
  CellTags->"General::matsq"],
Cell[111110, 4060, 220, 5, 37, "Message",
  CellTags->"General::matsq"],
Cell[111333, 4067, 107, 3, 21, "Output",
  CellTags->"General::matsq"]
}, Open  ]],
Cell[111455, 4073, 125, 5, 24, "Text",
  CellTags->"General::matsq"],

Cell[CellGroupData[{
Cell[111605, 4082, 108, 3, 26, "Input",
  CellTags->"General::matsq"],
Cell[111716, 4087, 94, 3, 21, "Output",
  CellTags->"General::matsq"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[111871, 4097, 146, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
Cell[112020, 4103, 606, 16, 37, "Message",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
Cell[112629, 4121, 544, 14, 78, "Notes",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],

Cell[CellGroupData[{
Cell[113198, 4139, 95, 1, 38, "ExampleSection",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
Cell[113296, 4142, 242, 5, 40, "Text",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],

Cell[CellGroupData[{
Cell[113563, 4151, 189, 4, 26, "Input",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
Cell[113755, 4157, 275, 5, 53, "Message",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
Cell[114033, 4164, 190, 4, 21, "Output",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}]
}, Open  ]],
Cell[114238, 4171, 193, 5, 24, "Text",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],

Cell[CellGroupData[{
Cell[114456, 4180, 180, 4, 26, "Input",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}],
Cell[114639, 4186, 230, 4, 37, "Output",
  CellTags->{"ListConvolve::depth", "ListCorrelate::depth"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[114930, 4197, 150, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
Cell[115083, 4203, 560, 14, 37, "Message",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
Cell[115646, 4219, 319, 8, 40, "Notes",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],

Cell[CellGroupData[{
Cell[115990, 4231, 97, 1, 38, "ExampleSection",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
Cell[116090, 4234, 227, 5, 40, "Text",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],

Cell[CellGroupData[{
Cell[116342, 4243, 166, 3, 26, "Input",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
Cell[116511, 4248, 321, 6, 53, "Message",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
Cell[116835, 4256, 167, 3, 21, "Output",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}]
}, Open  ]],
Cell[117017, 4262, 258, 5, 40, "Text",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],

Cell[CellGroupData[{
Cell[117300, 4271, 195, 4, 42, "Input",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}],
Cell[117498, 4277, 178, 3, 21, "Output",
  CellTags->{"ListConvolve::kldims", "ListCorrelate::kldims"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[117737, 4287, 142, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
Cell[117882, 4293, 333, 9, 37, "Message",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
Cell[118218, 4304, 286, 7, 40, "Notes",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],

Cell[CellGroupData[{
Cell[118529, 4315, 93, 1, 38, "ExampleSection",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
Cell[118625, 4318, 214, 4, 40, "Text",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],

Cell[CellGroupData[{
Cell[118864, 4326, 156, 3, 26, "Input",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
Cell[119023, 4331, 247, 5, 37, "Message",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
Cell[119273, 4338, 119, 3, 21, "Output",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}]
}, Open  ]],
Cell[119407, 4344, 162, 5, 24, "Text",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],

Cell[CellGroupData[{
Cell[119594, 4353, 156, 3, 26, "Input",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}],
Cell[119753, 4358, 209, 4, 21, "Output",
  CellTags->{"ListConvolve::nlen", "ListCorrelate::nlen"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[120023, 4369, 171, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
Cell[120197, 4376, 604, 15, 37, "Message",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
Cell[120804, 4393, 776, 18, 116, "Notes",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],

Cell[CellGroupData[{
Cell[121605, 4415, 109, 1, 38, "ExampleSection",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
Cell[121717, 4418, 176, 4, 24, "Text",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],

Cell[CellGroupData[{
Cell[121918, 4426, 179, 3, 26, "Input",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
Cell[122100, 4431, 299, 5, 53, "Message",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
Cell[122402, 4438, 180, 3, 21, "Output",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}]
}, Open  ]],
Cell[122597, 4444, 179, 5, 24, "Text",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],

Cell[CellGroupData[{
Cell[122801, 4453, 179, 3, 26, "Input",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}],
Cell[122983, 4458, 200, 4, 21, "Output",
  CellTags->{"ListConvolve::ohp", "ListCorrelate::ohp", "Partition::ohp"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[123244, 4469, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Partition::ohpdm"],
Cell[123332, 4472, 228, 5, 37, "Message",
  CellTags->"Partition::ohpdm"],
Cell[123563, 4479, 388, 10, 62, "Notes",
  CellTags->"Partition::ohpdm"],

Cell[CellGroupData[{
Cell[123976, 4493, 66, 1, 38, "ExampleSection",
  CellTags->"Partition::ohpdm"],
Cell[124045, 4496, 189, 5, 40, "Text",
  CellTags->"Partition::ohpdm"],

Cell[CellGroupData[{
Cell[124259, 4505, 129, 3, 26, "Input",
  CellTags->"Partition::ohpdm"],
Cell[124391, 4510, 235, 5, 37, "Message",
  CellTags->"Partition::ohpdm"],
Cell[124629, 4517, 130, 3, 21, "Output",
  CellTags->"Partition::ohpdm"]
}, Open  ]],
Cell[124774, 4523, 142, 5, 24, "Text",
  CellTags->"Partition::ohpdm"],

Cell[CellGroupData[{
Cell[124941, 4532, 126, 3, 26, "Input",
  CellTags->"Partition::ohpdm"],
Cell[125070, 4537, 114, 3, 21, "Output",
  CellTags->"Partition::ohpdm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[125245, 4547, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blvecmat"],
Cell[125335, 4550, 285, 8, 37, "Message",
  CellTags->"General::blvecmat"],
Cell[125623, 4560, 137, 4, 24, "Notes",
  CellTags->"General::blvecmat"]
}, Open  ]],

Cell[CellGroupData[{
Cell[125797, 4569, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::scalar"],
Cell[125883, 4572, 257, 7, 21, "Message",
  CellTags->"General::scalar"],
Cell[126143, 4581, 135, 4, 24, "Notes",
  CellTags->"General::scalar"]
}, Open  ]],

Cell[CellGroupData[{
Cell[126315, 4590, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blnotn"],
Cell[126401, 4593, 280, 8, 37, "Message",
  CellTags->"General::blnotn"],
Cell[126684, 4603, 126, 4, 24, "Notes",
  CellTags->"General::blnotn"]
}, Open  ]],

Cell[CellGroupData[{
Cell[126847, 4612, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blncorr"],
Cell[126935, 4615, 275, 7, 37, "Message",
  CellTags->"General::blncorr"],
Cell[127213, 4624, 127, 4, 24, "Notes",
  CellTags->"General::blncorr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[127377, 4633, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blwarg"],
Cell[127463, 4636, 302, 8, 37, "Message",
  CellTags->"General::blwarg"],
Cell[127768, 4646, 126, 4, 24, "Notes",
  CellTags->"General::blwarg"]
}, Open  ]],

Cell[CellGroupData[{
Cell[127931, 4655, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blndim1"],
Cell[128019, 4658, 275, 7, 37, "Message",
  CellTags->"General::blndim1"],
Cell[128297, 4667, 127, 4, 24, "Notes",
  CellTags->"General::blndim1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[128461, 4676, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blndim2"],
Cell[128549, 4679, 265, 7, 21, "Message",
  CellTags->"General::blndim2"],
Cell[128817, 4688, 127, 4, 24, "Notes",
  CellTags->"General::blndim2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[128981, 4697, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blrank"],
Cell[129067, 4700, 288, 8, 37, "Message",
  CellTags->"General::blrank"],
Cell[129358, 4710, 126, 4, 24, "Notes",
  CellTags->"General::blrank"]
}, Open  ]],

Cell[CellGroupData[{
Cell[129521, 4719, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blrank1"],
Cell[129609, 4722, 299, 8, 37, "Message",
  CellTags->"General::blrank1"],
Cell[129911, 4732, 127, 4, 24, "Notes",
  CellTags->"General::blrank1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[130075, 4741, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blnotsym"],
Cell[130165, 4744, 330, 8, 37, "Message",
  CellTags->"General::blnotsym"],
Cell[130498, 4754, 128, 4, 24, "Notes",
  CellTags->"General::blnotsym"]
}, Open  ]],

Cell[CellGroupData[{
Cell[130663, 4763, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blscas"],
Cell[130749, 4766, 289, 8, 37, "Message",
  CellTags->"General::blscas"],
Cell[131041, 4776, 126, 4, 24, "Notes",
  CellTags->"General::blscas"]
}, Open  ]],

Cell[CellGroupData[{
Cell[131204, 4785, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::bldim"],
Cell[131288, 4788, 282, 8, 37, "Message",
  CellTags->"General::bldim"],
Cell[131573, 4798, 125, 4, 24, "Notes",
  CellTags->"General::bldim"]
}, Open  ]],

Cell[CellGroupData[{
Cell[131735, 4807, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::bldim1"],
Cell[131821, 4810, 287, 8, 37, "Message",
  CellTags->"General::bldim1"],
Cell[132111, 4820, 126, 4, 24, "Notes",
  CellTags->"General::bldim1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[132274, 4829, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blvec"],
Cell[132358, 4832, 265, 7, 21, "Message",
  CellTags->"General::blvec"],
Cell[132626, 4841, 125, 4, 24, "Notes",
  CellTags->"General::blvec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[132788, 4850, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blnotsq"],
Cell[132876, 4853, 317, 8, 37, "Message",
  CellTags->"General::blnotsq"],
Cell[133196, 4863, 127, 4, 24, "Notes",
  CellTags->"General::blnotsq"]
}, Open  ]],

Cell[CellGroupData[{
Cell[133360, 4872, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blnsetst"],
Cell[133450, 4875, 335, 8, 37, "Message",
  CellTags->"General::blnsetst"],
Cell[133788, 4885, 128, 4, 24, "Notes",
  CellTags->"General::blnsetst"]
}, Open  ]],

Cell[CellGroupData[{
Cell[133953, 4894, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blnulst"],
Cell[134041, 4897, 278, 7, 37, "Message",
  CellTags->"General::blnulst"],
Cell[134322, 4906, 127, 4, 24, "Notes",
  CellTags->"General::blnulst"]
}, Open  ]],

Cell[CellGroupData[{
Cell[134486, 4915, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blreal"],
Cell[134572, 4918, 254, 7, 21, "Message",
  CellTags->"General::blreal"],
Cell[134829, 4927, 126, 4, 24, "Notes",
  CellTags->"General::blreal"]
}, Open  ]],

Cell[CellGroupData[{
Cell[134992, 4936, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blnegn"],
Cell[135078, 4939, 251, 7, 21, "Message",
  CellTags->"General::blnegn"],
Cell[135332, 4948, 126, 4, 24, "Notes",
  CellTags->"General::blnegn"]
}, Open  ]],

Cell[CellGroupData[{
Cell[135495, 4957, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blnmpre"],
Cell[135583, 4960, 292, 8, 37, "Message",
  CellTags->"General::blnmpre"],
Cell[135878, 4970, 127, 4, 24, "Notes",
  CellTags->"General::blnmpre"]
}, Open  ]],

Cell[CellGroupData[{
Cell[136042, 4979, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::spsder"],
Cell[136128, 4982, 314, 8, 37, "Message",
  CellTags->"General::spsder"],
Cell[136445, 4992, 126, 4, 24, "Notes",
  CellTags->"General::spsder"]
}, Open  ]],

Cell[CellGroupData[{
Cell[136608, 5001, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sdsh"],
Cell[136690, 5004, 306, 8, 37, "Message",
  CellTags->"General::sdsh"],
Cell[136999, 5014, 124, 4, 24, "Notes",
  CellTags->"General::sdsh"]
}, Open  ]],

Cell[CellGroupData[{
Cell[137160, 5023, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Partition::pttl"],
Cell[137246, 5026, 344, 8, 37, "Message",
  CellTags->"Partition::pttl"],
Cell[137593, 5036, 421, 9, 78, "Notes",
  CellTags->"Partition::pttl"],

Cell[CellGroupData[{
Cell[138039, 5049, 65, 1, 38, "ExampleSection",
  CellTags->"Partition::pttl"],
Cell[138107, 5052, 201, 5, 40, "Text",
  CellTags->"Partition::pttl"],

Cell[CellGroupData[{
Cell[138333, 5061, 145, 3, 26, "Input",
  CellTags->"Partition::pttl"],
Cell[138481, 5066, 234, 5, 37, "Message",
  CellTags->"Partition::pttl"],
Cell[138718, 5073, 146, 3, 21, "Output",
  CellTags->"Partition::pttl"]
}, Open  ]],
Cell[138879, 5079, 161, 5, 24, "Text",
  CellTags->"Partition::pttl"],

Cell[CellGroupData[{
Cell[139065, 5088, 150, 4, 26, "Input",
  CellTags->"Partition::pttl"],
Cell[139218, 5094, 121, 3, 21, "Output",
  CellTags->"Partition::pttl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[139400, 5104, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Drop::drop"],
Cell[139476, 5107, 381, 12, 21, "Message",
  CellTags->"Drop::drop"],
Cell[139860, 5121, 222, 5, 40, "Notes",
  CellTags->"Drop::drop"],

Cell[CellGroupData[{
Cell[140107, 5130, 60, 1, 38, "ExampleSection",
  CellTags->"Drop::drop"],
Cell[140170, 5133, 219, 6, 40, "Text",
  CellTags->"Drop::drop"],

Cell[CellGroupData[{
Cell[140414, 5143, 103, 3, 26, "Input",
  CellTags->"Drop::drop"],
Cell[140520, 5148, 195, 5, 21, "Message",
  CellTags->"Drop::drop"],
Cell[140718, 5155, 104, 3, 21, "Output",
  CellTags->"Drop::drop"]
}, Open  ]],
Cell[140837, 5161, 117, 5, 24, "Text",
  CellTags->"Drop::drop"],

Cell[CellGroupData[{
Cell[140979, 5170, 103, 3, 26, "Input",
  CellTags->"Drop::drop"],
Cell[141085, 5175, 90, 3, 21, "Output",
  CellTags->"Drop::drop"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[141236, 5185, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"First::first"],
Cell[141316, 5188, 223, 5, 21, "Message",
  CellTags->"First::first"],
Cell[141542, 5195, 168, 5, 24, "Notes",
  CellTags->"First::first"],

Cell[CellGroupData[{
Cell[141735, 5204, 62, 1, 38, "ExampleSection",
  CellTags->"First::first"],
Cell[141800, 5207, 160, 4, 24, "Text",
  CellTags->"First::first"],

Cell[CellGroupData[{
Cell[141985, 5215, 99, 3, 26, "Input",
  CellTags->"First::first"],
Cell[142087, 5220, 183, 4, 21, "Message",
  CellTags->"First::first"],
Cell[142273, 5226, 95, 3, 21, "Output",
  CellTags->"First::first"]
}, Open  ]],
Cell[142383, 5232, 158, 4, 24, "Text",
  CellTags->"First::first"],

Cell[CellGroupData[{
Cell[142566, 5240, 112, 3, 26, "Input",
  CellTags->"First::first"],
Cell[142681, 5245, 88, 3, 21, "Output",
  CellTags->"First::first"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[142830, 5255, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FlattenAt::flatp"],
Cell[142918, 5258, 416, 11, 37, "Message",
  CellTags->"FlattenAt::flatp"],
Cell[143337, 5271, 251, 6, 40, "Notes",
  CellTags->"FlattenAt::flatp"],

Cell[CellGroupData[{
Cell[143613, 5281, 66, 1, 38, "ExampleSection",
  CellTags->"FlattenAt::flatp"],
Cell[143682, 5284, 169, 4, 40, "Text",
  CellTags->"FlattenAt::flatp"],

Cell[CellGroupData[{
Cell[143876, 5292, 118, 3, 26, "Input",
  CellTags->"FlattenAt::flatp"],
Cell[143997, 5297, 247, 5, 37, "Message",
  CellTags->"FlattenAt::flatp"],
Cell[144247, 5304, 119, 3, 21, "Output",
  CellTags->"FlattenAt::flatp"]
}, Open  ]],
Cell[144381, 5310, 128, 5, 24, "Text",
  CellTags->"FlattenAt::flatp"],

Cell[CellGroupData[{
Cell[144534, 5319, 124, 3, 26, "Input",
  CellTags->"FlattenAt::flatp"],
Cell[144661, 5324, 109, 3, 21, "Output",
  CellTags->"FlattenAt::flatp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[144831, 5334, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Insert::ins"],
Cell[144909, 5337, 167, 4, 21, "Message",
  CellTags->"Insert::ins"],
Cell[145079, 5343, 310, 7, 62, "Notes",
  CellTags->"Insert::ins"],

Cell[CellGroupData[{
Cell[145414, 5354, 61, 1, 38, "ExampleSection",
  CellTags->"Insert::ins"],
Cell[145478, 5357, 124, 4, 24, "Text",
  CellTags->"Insert::ins"],

Cell[CellGroupData[{
Cell[145627, 5365, 114, 3, 26, "Input",
  CellTags->"Insert::ins"],
Cell[145744, 5370, 191, 5, 21, "Message",
  CellTags->"Insert::ins"],
Cell[145938, 5377, 115, 3, 21, "Output",
  CellTags->"Insert::ins"]
}, Open  ]],
Cell[146068, 5383, 133, 5, 24, "Text",
  CellTags->"Insert::ins"],

Cell[CellGroupData[{
Cell[146226, 5392, 114, 3, 26, "Input",
  CellTags->"Insert::ins"],
Cell[146343, 5397, 104, 3, 21, "Output",
  CellTags->"Insert::ins"]
}, Open  ]],

Cell[CellGroupData[{
Cell[146484, 5405, 119, 3, 26, "Input",
  CellTags->"Insert::ins"],
Cell[146606, 5410, 104, 3, 21, "Output",
  CellTags->"Insert::ins"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[146771, 5420, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Last::nolast"],
Cell[146851, 5423, 222, 5, 21, "Message",
  CellTags->"Last::nolast"],
Cell[147076, 5430, 156, 4, 24, "Notes",
  CellTags->"Last::nolast"],

Cell[CellGroupData[{
Cell[147257, 5438, 62, 1, 38, "ExampleSection",
  CellTags->"Last::nolast"],
Cell[147322, 5441, 138, 4, 24, "Text",
  CellTags->"Last::nolast"],

Cell[CellGroupData[{
Cell[147485, 5449, 93, 3, 26, "Input",
  CellTags->"Last::nolast"],
Cell[147581, 5454, 182, 4, 21, "Message",
  CellTags->"Last::nolast"],
Cell[147766, 5460, 94, 3, 21, "Output",
  CellTags->"Last::nolast"]
}, Open  ]],
Cell[147875, 5466, 119, 5, 24, "Text",
  CellTags->"Last::nolast"],

Cell[CellGroupData[{
Cell[148019, 5475, 106, 3, 26, "Input",
  CellTags->"Last::nolast"],
Cell[148128, 5480, 87, 3, 21, "Output",
  CellTags->"Last::nolast"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[148276, 5490, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Partition::pdep"],
Cell[148362, 5493, 365, 10, 21, "Message",
  CellTags->"Partition::pdep"],
Cell[148730, 5505, 266, 6, 40, "Notes",
  CellTags->"Partition::pdep"],

Cell[CellGroupData[{
Cell[149021, 5515, 65, 1, 38, "ExampleSection",
  CellTags->"Partition::pdep"],
Cell[149089, 5518, 246, 6, 40, "Text",
  CellTags->"Partition::pdep"],

Cell[CellGroupData[{
Cell[149360, 5528, 127, 3, 26, "Input",
  CellTags->"Partition::pdep"],
Cell[149490, 5533, 200, 5, 21, "Message",
  CellTags->"Partition::pdep"],
Cell[149693, 5540, 128, 3, 21, "Output",
  CellTags->"Partition::pdep"]
}, Open  ]],
Cell[149836, 5546, 131, 5, 24, "Text",
  CellTags->"Partition::pdep"],

Cell[CellGroupData[{
Cell[149992, 5555, 166, 4, 42, "Input",
  CellTags->"Partition::pdep"],
Cell[150161, 5561, 194, 4, 37, "Output",
  CellTags->"Partition::pdep"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[150416, 5572, 142, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"RotateLeft::rotate", "RotateRight::rotate"}],
Cell[150561, 5578, 391, 11, 21, "Message",
  CellTags->{"RotateLeft::rotate", "RotateRight::rotate"}],
Cell[150955, 5591, 267, 7, 40, "Notes",
  CellTags->{"RotateLeft::rotate", "RotateRight::rotate"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[151259, 5603, 138, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
Cell[151400, 5609, 517, 13, 37, "Message",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
Cell[151920, 5624, 263, 7, 40, "Notes",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],

Cell[CellGroupData[{
Cell[152208, 5635, 91, 1, 38, "ExampleSection",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
Cell[152302, 5638, 155, 4, 24, "Text",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],

Cell[CellGroupData[{
Cell[152482, 5646, 161, 3, 26, "Input",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
Cell[152646, 5651, 278, 5, 53, "Message",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
Cell[152927, 5658, 162, 3, 21, "Output",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}]
}, Open  ]],
Cell[153104, 5664, 174, 5, 24, "Text",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],

Cell[CellGroupData[{
Cell[153303, 5673, 151, 3, 26, "Input",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}],
Cell[153457, 5678, 136, 3, 21, "Output",
  CellTags->{"RotateLeft::rspec", "RotateRight::rspec"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[153654, 5688, 225, 9, 111, "ObjectNameWarningMessages",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],
Cell[153882, 5699, 532, 17, 21, "Message",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],
Cell[154417, 5718, 309, 7, 40, "Notes",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[CellGroupData[{
Cell[154751, 5729, 143, 3, 38, "ExampleSection",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],
Cell[154897, 5734, 248, 6, 40, "Text",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[CellGroupData[{
Cell[155170, 5744, 190, 5, 26, "Input",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],
Cell[155363, 5751, 301, 7, 37, "Message",
  CellTags->{
  "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take", 
    "Take::take"}],
Cell[155667, 5760, 213, 5, 21, "Output",
  CellTags->{
  "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take", 
    "Take::take"}]
}, Open  ]],
Cell[155895, 5768, 196, 6, 24, "Text",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[CellGroupData[{
Cell[156116, 5778, 194, 5, 26, "Input",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],
Cell[156313, 5785, 180, 5, 21, "Output",
  CellTags->{
  "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take", 
    "Take::take"}]
}, Open  ]],
Cell[156508, 5793, 244, 6, 40, "Text",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[CellGroupData[{
Cell[156777, 5803, 202, 5, 26, "Input",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],
Cell[156982, 5810, 289, 7, 21, "Message",
  CellTags->{
  "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take", 
    "Take::take"}],
Cell[157274, 5819, 199, 5, 21, "Output",
  CellTags->{
  "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take", 
    "Take::take"}]
}, Open  ]],
Cell[157488, 5827, 182, 3, 24, "Text",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],

Cell[CellGroupData[{
Cell[157695, 5834, 206, 5, 26, "Input",
  CellTags->{
  "Take::take", "StringTake::take", "Part::take", "Set::take", 
    "Internal`BagPart::take"}],
Cell[157904, 5841, 174, 5, 21, "Output",
  CellTags->{
  "Internal`BagPart::take", "Part::take", "Set::take", "StringTake::take", 
    "Take::take"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[158139, 5853, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Thread::tdlen"],
Cell[158221, 5856, 276, 5, 21, "Message",
  CellTags->"Thread::tdlen"],
Cell[158500, 5863, 404, 11, 62, "Notes",
  CellTags->"Thread::tdlen"],

Cell[CellGroupData[{
Cell[158929, 5878, 63, 1, 38, "ExampleSection",
  CellTags->"Thread::tdlen"],
Cell[158995, 5881, 169, 4, 40, "Text",
  CellTags->"Thread::tdlen"],

Cell[CellGroupData[{
Cell[159189, 5889, 117, 3, 26, "Input",
  CellTags->"Thread::tdlen"],
Cell[159309, 5894, 238, 5, 37, "Message",
  CellTags->"Thread::tdlen"],
Cell[159550, 5901, 110, 3, 21, "Output",
  CellTags->"Thread::tdlen"]
}, Open  ]],
Cell[159675, 5907, 127, 5, 24, "Text",
  CellTags->"Thread::tdlen"],

Cell[CellGroupData[{
Cell[159827, 5916, 120, 3, 26, "Input",
  CellTags->"Thread::tdlen"],
Cell[159950, 5921, 123, 3, 21, "Output",
  CellTags->"Thread::tdlen"]
}, Open  ]],
Cell[160088, 5927, 276, 7, 40, "Text",
  CellTags->"Thread::tdlen"],

Cell[CellGroupData[{
Cell[160389, 5938, 102, 3, 26, "Input",
  CellTags->"Thread::tdlen"],
Cell[160494, 5943, 162, 4, 21, "Output",
  CellTags->"Thread::tdlen"]
}, Open  ]],

Cell[CellGroupData[{
Cell[160693, 5952, 109, 3, 26, "Input",
  CellTags->"Thread::tdlen"],
Cell[160805, 5957, 230, 5, 37, "Message",
  CellTags->"Thread::tdlen"],
Cell[161038, 5964, 110, 3, 21, "Output",
  CellTags->"Thread::tdlen"]
}, Open  ]],
Cell[161163, 5970, 129, 4, 24, "Text",
  CellTags->"Thread::tdlen"],

Cell[CellGroupData[{
Cell[161317, 5978, 112, 3, 26, "Input",
  CellTags->"Thread::tdlen"],
Cell[161432, 5983, 99, 3, 21, "Output",
  CellTags->"Thread::tdlen"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[161592, 5993, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Thread::tpos"],
Cell[161672, 5996, 400, 12, 21, "Message",
  CellTags->"Thread::tpos"],
Cell[162075, 6010, 241, 6, 40, "Notes",
  CellTags->"Thread::tpos"],

Cell[CellGroupData[{
Cell[162341, 6020, 62, 1, 38, "ExampleSection",
  CellTags->"Thread::tpos"],
Cell[162406, 6023, 248, 6, 40, "Text",
  CellTags->"Thread::tpos"],

Cell[CellGroupData[{
Cell[162679, 6033, 135, 3, 26, "Input",
  CellTags->"Thread::tpos"],
Cell[162817, 6038, 259, 6, 37, "Message",
  CellTags->"Thread::tpos"],
Cell[163079, 6046, 136, 3, 21, "Output",
  CellTags->"Thread::tpos"]
}, Open  ]],
Cell[163230, 6052, 140, 5, 24, "Text",
  CellTags->"Thread::tpos"],

Cell[CellGroupData[{
Cell[163395, 6061, 135, 3, 26, "Input",
  CellTags->"Thread::tpos"],
Cell[163533, 6066, 126, 3, 21, "Output",
  CellTags->"Thread::tpos"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[163720, 6076, 169, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
Cell[163892, 6083, 772, 18, 53, "Message",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
Cell[164667, 6103, 328, 10, 40, "Notes",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],

Cell[CellGroupData[{
Cell[165020, 6117, 108, 1, 38, "ExampleSection",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
Cell[165131, 6120, 295, 8, 40, "Text",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],

Cell[CellGroupData[{
Cell[165451, 6132, 207, 4, 26, "Input",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
Cell[165661, 6138, 419, 7, 69, "Message",
  CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
Cell[166083, 6147, 418, 7, 69, "Message",
  CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
Cell[166504, 6156, 418, 7, 69, "Message",
  CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
Cell[166925, 6165, 267, 5, 37, "Message",
  CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}],
Cell[167195, 6172, 146, 3, 21, "Output",
  CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}]
}, Open  ]],
Cell[167356, 6178, 217, 5, 24, "Text",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],

Cell[CellGroupData[{
Cell[167598, 6187, 206, 4, 26, "Input",
  CellTags->{"Union::smtst", "Intersection::smtst", "Complement::smtst"}],
Cell[167807, 6193, 145, 3, 21, "Output",
  CellTags->{"Complement::smtst", "Intersection::smtst", "Union::smtst"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[168013, 6203, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::partd"],
Cell[168097, 6206, 403, 11, 21, "Message",
  CellTags->"General::partd"],
Cell[168503, 6219, 158, 4, 24, "Notes",
  CellTags->"General::partd"],

Cell[CellGroupData[{
Cell[168686, 6227, 64, 1, 38, "ExampleSection",
  CellTags->"General::partd"],
Cell[168753, 6230, 149, 4, 24, "Text",
  CellTags->"General::partd"],

Cell[CellGroupData[{
Cell[168927, 6238, 119, 3, 26, "Input",
  CellTags->"General::partd"],
Cell[169049, 6243, 282, 6, 37, "Message",
  CellTags->"General::partd"],
Cell[169334, 6251, 164, 4, 21, "Output",
  CellTags->"General::partd"]
}, Open  ]],
Cell[169513, 6258, 84, 1, 24, "Text",
  CellTags->"General::partd"],

Cell[CellGroupData[{
Cell[169622, 6263, 123, 3, 26, "Input",
  CellTags->"General::partd"],
Cell[169748, 6268, 92, 3, 21, "Output",
  CellTags->"General::partd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[169901, 6278, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::partw"],
Cell[169985, 6281, 384, 12, 21, "Message",
  CellTags->"General::partw"],
Cell[170372, 6295, 176, 4, 24, "Notes",
  CellTags->"General::partw"],

Cell[CellGroupData[{
Cell[170573, 6303, 64, 1, 38, "ExampleSection",
  CellTags->"General::partw"],
Cell[170640, 6306, 176, 4, 40, "Text",
  CellTags->"General::partw"],

Cell[CellGroupData[{
Cell[170841, 6314, 120, 3, 26, "Input",
  CellTags->"General::partw"],
Cell[170964, 6319, 192, 4, 21, "Message",
  CellTags->"General::partw"],
Cell[171159, 6325, 121, 3, 21, "Output",
  CellTags->"General::partw"]
}, Open  ]],
Cell[171295, 6331, 104, 1, 24, "Text",
  CellTags->"General::partw"],

Cell[CellGroupData[{
Cell[171424, 6336, 120, 3, 26, "Input",
  CellTags->"General::partw"],
Cell[171547, 6341, 100, 3, 21, "Output",
  CellTags->"General::partw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[171708, 6351, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::pspec"],
Cell[171792, 6354, 448, 12, 37, "Message",
  CellTags->"General::pspec"],
Cell[172243, 6368, 158, 4, 24, "Notes",
  CellTags->"General::pspec"],

Cell[CellGroupData[{
Cell[172426, 6376, 64, 1, 38, "ExampleSection",
  CellTags->"General::pspec"],
Cell[172493, 6379, 198, 5, 40, "Text",
  CellTags->"General::pspec"],

Cell[CellGroupData[{
Cell[172716, 6388, 123, 3, 26, "Input",
  CellTags->"General::pspec"],
Cell[172842, 6393, 218, 5, 37, "Message",
  CellTags->"General::pspec"],
Cell[173063, 6400, 168, 4, 21, "Output",
  CellTags->"General::pspec"]
}, Open  ]],
Cell[173246, 6407, 92, 1, 24, "Text",
  CellTags->"General::pspec"],

Cell[CellGroupData[{
Cell[173363, 6412, 119, 3, 26, "Input",
  CellTags->"General::pspec"],
Cell[173485, 6417, 90, 3, 21, "Output",
  CellTags->"General::pspec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[173612, 6425, 134, 3, 26, "Input",
  CellTags->"General::pspec"],
Cell[173749, 6430, 90, 3, 21, "Output",
  CellTags->"General::pspec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[173876, 6438, 139, 3, 26, "Input",
  CellTags->"General::pspec"],
Cell[174018, 6443, 96, 3, 21, "Output",
  CellTags->"General::pspec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[174175, 6453, 136, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],
Cell[174314, 6459, 200, 4, 21, "Message",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],
Cell[174517, 6465, 650, 14, 116, "Notes",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[CellGroupData[{
Cell[175192, 6483, 90, 1, 38, "ExampleSection",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],
Cell[175285, 6486, 181, 4, 24, "Text",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[CellGroupData[{
Cell[175491, 6494, 137, 3, 26, "Input",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],
Cell[175631, 6499, 216, 5, 21, "Message",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],
Cell[175850, 6506, 138, 3, 21, "Output",
  CellTags->{"Array::plen", "StringReplacePart::plen"}]
}, Open  ]],
Cell[176003, 6512, 152, 5, 24, "Text",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[CellGroupData[{
Cell[176180, 6521, 140, 3, 26, "Input",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],
Cell[176323, 6526, 150, 3, 21, "Output",
  CellTags->{"Array::plen", "StringReplacePart::plen"}]
}, Open  ]],
Cell[176488, 6532, 208, 4, 40, "Text",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[CellGroupData[{
Cell[176721, 6540, 205, 4, 42, "Input",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],
Cell[176929, 6546, 272, 5, 37, "Message",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],
Cell[177204, 6553, 186, 4, 21, "Output",
  CellTags->{"Array::plen", "StringReplacePart::plen"}]
}, Open  ]],
Cell[177405, 6560, 200, 5, 24, "Text",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],

Cell[CellGroupData[{
Cell[177630, 6569, 213, 4, 42, "Input",
  CellTags->{"Array::plen", "StringReplacePart::plen"}],
Cell[177846, 6575, 123, 3, 21, "Output",
  CellTags->{"Array::plen", "StringReplacePart::plen"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[178030, 6585, 126, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"PadLeft::level", "PadRight::level"}],
Cell[178159, 6591, 384, 11, 37, "Message",
  CellTags->{"PadLeft::level", "PadRight::level"}],
Cell[178546, 6604, 318, 9, 40, "Notes",
  CellTags->{"PadLeft::level", "PadRight::level"}],

Cell[CellGroupData[{
Cell[178889, 6617, 85, 1, 38, "ExampleSection",
  CellTags->{"PadLeft::level", "PadRight::level"}],
Cell[178977, 6620, 210, 5, 40, "Text",
  CellTags->{"PadLeft::level", "PadRight::level"}],

Cell[CellGroupData[{
Cell[179212, 6629, 138, 3, 26, "Input",
  CellTags->{"PadLeft::level", "PadRight::level"}],
Cell[179353, 6634, 275, 5, 53, "Message",
  CellTags->{"PadLeft::level", "PadRight::level"}],
Cell[179631, 6641, 139, 3, 21, "Output",
  CellTags->{"PadLeft::level", "PadRight::level"}]
}, Open  ]],
Cell[179785, 6647, 180, 5, 24, "Text",
  CellTags->{"PadLeft::level", "PadRight::level"}],

Cell[CellGroupData[{
Cell[179990, 6656, 142, 3, 26, "Input",
  CellTags->{"PadLeft::level", "PadRight::level"}],
Cell[180135, 6661, 142, 3, 21, "Output",
  CellTags->{"PadLeft::level", "PadRight::level"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[180338, 6671, 130, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],
Cell[180471, 6677, 410, 11, 53, "Message",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],
Cell[180884, 6690, 290, 8, 40, "Notes",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],

Cell[CellGroupData[{
Cell[181199, 6702, 87, 1, 38, "ExampleSection",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],
Cell[181289, 6705, 206, 4, 40, "Text",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],

Cell[CellGroupData[{
Cell[181520, 6713, 143, 3, 26, "Input",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],
Cell[181666, 6718, 350, 6, 53, "Message",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],
Cell[182019, 6726, 144, 3, 21, "Output",
  CellTags->{"PadLeft::margin", "PadRight::margin"}]
}, Open  ]],
Cell[182178, 6732, 167, 5, 24, "Text",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],

Cell[CellGroupData[{
Cell[182370, 6741, 138, 3, 26, "Input",
  CellTags->{"PadLeft::margin", "PadRight::margin"}],
Cell[182511, 6746, 141, 3, 21, "Output",
  CellTags->{"PadLeft::margin", "PadRight::margin"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[182713, 6756, 71, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Sow::encl"],
Cell[182787, 6759, 200, 5, 21, "Message",
  CellTags->"Sow::encl"],
Cell[182990, 6766, 320, 10, 46, "Notes",
  CellTags->"Sow::encl"],

Cell[CellGroupData[{
Cell[183335, 6780, 59, 1, 38, "ExampleSection",
  CellTags->"Sow::encl"],
Cell[183397, 6783, 181, 7, 24, "Text",
  CellTags->"Sow::encl"],

Cell[CellGroupData[{
Cell[183603, 6794, 113, 3, 26, "Input",
  CellTags->"Sow::encl"],
Cell[183719, 6799, 172, 4, 21, "Message",
  CellTags->"Sow::encl"],
Cell[183894, 6805, 172, 4, 21, "Message",
  CellTags->"Sow::encl"],
Cell[184069, 6811, 172, 4, 21, "Message",
  CellTags->"Sow::encl"],
Cell[184244, 6817, 215, 5, 37, "Message",
  CellTags->"Sow::encl"],
Cell[184462, 6824, 92, 3, 21, "Output",
  CellTags->"Sow::encl"]
}, Open  ]],
Cell[184569, 6830, 152, 7, 24, "Text",
  CellTags->"Sow::encl"],

Cell[CellGroupData[{
Cell[184746, 6841, 108, 3, 26, "Input",
  CellTags->"Sow::encl"],
Cell[184857, 6846, 110, 3, 21, "Output",
  CellTags->"Sow::encl"]
}, Open  ]],
Cell[184982, 6852, 211, 7, 24, "Text",
  CellTags->"Sow::encl"],

Cell[CellGroupData[{
Cell[185218, 6863, 119, 3, 26, "Input",
  CellTags->"Sow::encl"],
Cell[185340, 6868, 172, 4, 21, "Message",
  CellTags->"Sow::encl"],
Cell[185515, 6874, 172, 4, 21, "Message",
  CellTags->"Sow::encl"],
Cell[185690, 6880, 172, 4, 21, "Message",
  CellTags->"Sow::encl"],
Cell[185865, 6886, 215, 5, 37, "Message",
  CellTags->"Sow::encl"],
Cell[186083, 6893, 93, 3, 21, "Output",
  CellTags->"Sow::encl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[186237, 6903, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Sow::enclt"],
Cell[186313, 6906, 151, 3, 21, "Message",
  CellTags->"Sow::enclt"],
Cell[186467, 6911, 286, 7, 46, "Notes",
  CellTags->"Sow::enclt"],

Cell[CellGroupData[{
Cell[186778, 6922, 60, 1, 38, "ExampleSection",
  CellTags->"Sow::enclt"],
Cell[186841, 6925, 235, 7, 40, "Text",
  CellTags->"Sow::enclt"],

Cell[CellGroupData[{
Cell[187101, 6936, 133, 3, 26, "Input",
  CellTags->"Sow::enclt"],
Cell[187237, 6941, 204, 5, 21, "Message",
  CellTags->"Sow::enclt"],
Cell[187444, 6948, 204, 5, 21, "Message",
  CellTags->"Sow::enclt"],
Cell[187651, 6955, 204, 5, 21, "Message",
  CellTags->"Sow::enclt"],
Cell[187858, 6962, 217, 5, 37, "Message",
  CellTags->"Sow::enclt"],
Cell[188078, 6969, 94, 3, 21, "Output",
  CellTags->"Sow::enclt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[188233, 6979, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::dim"],
Cell[188313, 6982, 326, 8, 37, "Message",
  CellTags->"General::dim"],
Cell[188642, 6992, 123, 4, 24, "Notes",
  CellTags->"General::dim"]
}, Open  ]],

Cell[CellGroupData[{
Cell[188802, 7001, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nsdims"],
Cell[188888, 7004, 285, 8, 37, "Message",
  CellTags->"General::nsdims"],
Cell[189176, 7014, 126, 4, 24, "Notes",
  CellTags->"General::nsdims"]
}, Open  ]],

Cell[CellGroupData[{
Cell[189339, 7023, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::rect"],
Cell[189421, 7026, 310, 10, 21, "Message",
  CellTags->"General::rect"],
Cell[189734, 7038, 124, 4, 24, "Notes",
  CellTags->"General::rect"]
}, Open  ]],

Cell[CellGroupData[{
Cell[189895, 7047, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::rectn"],
Cell[189979, 7050, 328, 10, 21, "Message",
  CellTags->"General::rectn"],
Cell[190310, 7062, 125, 4, 24, "Notes",
  CellTags->"General::rectn"]
}, Open  ]],

Cell[CellGroupData[{
Cell[190472, 7071, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::rectt"],
Cell[190556, 7074, 328, 10, 21, "Message",
  CellTags->"General::rectt"],
Cell[190887, 7086, 125, 4, 24, "Notes",
  CellTags->"General::rectt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[191049, 7095, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::gfargs"],
Cell[191135, 7098, 303, 8, 37, "Message",
  CellTags->"General::gfargs"],
Cell[191441, 7108, 126, 4, 24, "Notes",
  CellTags->"General::gfargs"]
}, Open  ]],

Cell[CellGroupData[{
Cell[191604, 7117, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nonnum"],
Cell[191690, 7120, 267, 7, 21, "Message",
  CellTags->"General::nonnum"],
Cell[191960, 7129, 126, 4, 24, "Notes",
  CellTags->"General::nonnum"]
}, Open  ]],

Cell[CellGroupData[{
Cell[192123, 7138, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::dvec"],
Cell[192205, 7141, 355, 9, 37, "Message",
  CellTags->"General::dvec"],
Cell[192563, 7152, 124, 4, 24, "Notes",
  CellTags->"General::dvec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[192724, 7161, 192, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::svecnm", "Eigenvalues::svecnm", "Eigenvectors::svecnm"}],
Cell[192919, 7169, 464, 12, 53, "Message",
  CellTags->{
  "Eigensystem::svecnm", "Eigenvalues::svecnm", "Eigenvectors::svecnm"}],
Cell[193386, 7183, 182, 5, 24, "Notes",
  CellTags->{
  "Eigensystem::svecnm", "Eigenvalues::svecnm", "Eigenvectors::svecnm"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[193605, 7193, 186, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}],
Cell[193794, 7201, 539, 13, 69, "Message",
  CellTags->{
  "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}],
Cell[194336, 7216, 179, 5, 24, "Notes",
  CellTags->{
  "Eigensystem::eslct", "Eigenvalues::eslct", "Eigenvectors::eslct"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[194552, 7226, 186, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}],
Cell[194741, 7234, 500, 13, 69, "Message",
  CellTags->{
  "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}],
Cell[195244, 7249, 179, 5, 24, "Notes",
  CellTags->{
  "Eigensystem::ssing", "Eigenvalues::ssing", "Eigenvectors::ssing"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[195460, 7259, 186, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}],
Cell[195649, 7267, 409, 11, 37, "Message",
  CellTags->{
  "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}],
Cell[196061, 7280, 179, 5, 24, "Notes",
  CellTags->{
  "Eigensystem::bsing", "Eigenvalues::bsing", "Eigenvectors::bsing"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[196277, 7290, 186, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}],
Cell[196466, 7298, 584, 14, 85, "Message",
  CellTags->{
  "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}],
Cell[197053, 7314, 179, 5, 24, "Notes",
  CellTags->{
  "Eigensystem::aribs", "Eigenvalues::aribs", "Eigenvectors::aribs"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[197269, 7324, 192, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::mcsgma", "Eigenvalues::mcsgma", "Eigenvectors::mcsgma"}],
Cell[197464, 7332, 388, 11, 21, "Message",
  CellTags->{
  "Eigensystem::mcsgma", "Eigenvalues::mcsgma", "Eigenvectors::mcsgma"}],
Cell[197855, 7345, 182, 5, 24, "Notes",
  CellTags->{
  "Eigensystem::mcsgma", "Eigenvalues::mcsgma", "Eigenvectors::mcsgma"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[198074, 7355, 192, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigensystem::arconv", "Eigenvalues::arconv", "Eigenvectors::arconv"}],
Cell[198269, 7363, 390, 11, 37, "Message",
  CellTags->{
  "Eigensystem::arconv", "Eigenvalues::arconv", "Eigenvectors::arconv"}],
Cell[198662, 7376, 182, 5, 24, "Notes",
  CellTags->{
  "Eigensystem::arconv", "Eigenvalues::arconv", "Eigenvectors::arconv"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[198881, 7386, 186, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}],
Cell[199070, 7394, 667, 15, 101, "Message",
  CellTags->{
  "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}],
Cell[199740, 7411, 179, 5, 24, "Notes",
  CellTags->{
  "Eigenvalues::maxit", "Eigenvectors::maxit", "Eigensystem::maxit"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[199956, 7421, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Eigenvalues::take"],
Cell[200046, 7424, 210, 4, 37, "Message",
  CellTags->"Eigenvalues::take"],
Cell[200259, 7430, 128, 4, 24, "Notes",
  CellTags->"Eigenvalues::take"]
}, Open  ]],

Cell[CellGroupData[{
Cell[200424, 7439, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Eigenvectors::take"],
Cell[200516, 7442, 214, 4, 37, "Message",
  CellTags->"Eigenvectors::take"],
Cell[200733, 7448, 129, 4, 24, "Notes",
  CellTags->"Eigenvectors::take"]
}, Open  ]],

Cell[CellGroupData[{
Cell[200899, 7457, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Eigensystem::take"],
Cell[200989, 7460, 248, 4, 37, "Message",
  CellTags->"Eigensystem::take"],
Cell[201240, 7466, 128, 4, 24, "Notes",
  CellTags->"Eigensystem::take"]
}, Open  ]],

Cell[CellGroupData[{
Cell[201405, 7475, 178, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"SingularValueDecomposition::take", "SingularValueList::take"}],
Cell[201586, 7481, 277, 5, 53, "Message",
  CellTags->{"SingularValueDecomposition::take", "SingularValueList::take"}],
Cell[201866, 7488, 172, 4, 24, "Notes",
  CellTags->{"SingularValueDecomposition::take", "SingularValueList::take"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[202075, 7497, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blincor"],
Cell[202163, 7500, 255, 7, 21, "Message",
  CellTags->"General::blincor"],
Cell[202421, 7509, 127, 4, 24, "Notes",
  CellTags->"General::blincor"]
}, Open  ]],

Cell[CellGroupData[{
Cell[202585, 7518, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blintli"],
Cell[202673, 7521, 264, 7, 21, "Message",
  CellTags->"General::blintli"],
Cell[202940, 7530, 127, 4, 24, "Notes",
  CellTags->"General::blintli"]
}, Open  ]],

Cell[CellGroupData[{
Cell[203104, 7539, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::blveclen"],
Cell[203194, 7542, 267, 7, 21, "Message",
  CellTags->"General::blveclen"],
Cell[203464, 7551, 128, 4, 24, "Notes",
  CellTags->"General::blveclen"]
}, Open  ]],

Cell[CellGroupData[{
Cell[203629, 7560, 125, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearAlgebra`LAPACK`GESVX::blinstlu"],
Cell[203757, 7563, 333, 6, 53, "Message",
  CellTags->"LinearAlgebra`LAPACK`GESVX::blinstlu"],
Cell[204093, 7571, 147, 4, 24, "Notes",
  CellTags->"LinearAlgebra`LAPACK`GESVX::blinstlu"]
}, Open  ]],

Cell[CellGroupData[{
Cell[204277, 7580, 125, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearAlgebra`LAPACK`LARTG::blneqsym"],
Cell[204405, 7583, 233, 4, 37, "Message",
  CellTags->"LinearAlgebra`LAPACK`LARTG::blneqsym"],
Cell[204641, 7589, 147, 4, 24, "Notes",
  CellTags->"LinearAlgebra`LAPACK`LARTG::blneqsym"]
}, Open  ]],

Cell[CellGroupData[{
Cell[204825, 7598, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Norm::ptype"],
Cell[204903, 7601, 291, 6, 37, "Message",
  CellTags->"Norm::ptype"],
Cell[205197, 7609, 122, 4, 24, "Notes",
  CellTags->"Norm::ptype"]
}, Open  ]],

Cell[CellGroupData[{
Cell[205356, 7618, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Norm::symb"],
Cell[205432, 7621, 181, 4, 21, "Message",
  CellTags->"Norm::symb"],
Cell[205616, 7627, 121, 4, 24, "Notes",
  CellTags->"Norm::symb"]
}, Open  ]],

Cell[CellGroupData[{
Cell[205774, 7636, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Quantile::nquan"],
Cell[205860, 7639, 178, 3, 37, "Message",
  CellTags->"Quantile::nquan"],
Cell[206041, 7644, 126, 4, 24, "Notes",
  CellTags->"Quantile::nquan"]
}, Open  ]],

Cell[CellGroupData[{
Cell[206204, 7653, 131, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearAlgebra`BLAS`TestArgument::blapos"],
Cell[206338, 7656, 278, 4, 37, "Message",
  CellTags->"LinearAlgebra`BLAS`TestArgument::blapos"],
Cell[206619, 7662, 150, 4, 24, "Notes",
  CellTags->"LinearAlgebra`BLAS`TestArgument::blapos"]
}, Open  ]],

Cell[CellGroupData[{
Cell[206806, 7671, 133, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearAlgebra`BLAS`TestArgument::bltrank"],
Cell[206942, 7674, 231, 4, 37, "Message",
  CellTags->"LinearAlgebra`BLAS`TestArgument::bltrank"],
Cell[207176, 7680, 151, 4, 24, "Notes",
  CellTags->"LinearAlgebra`BLAS`TestArgument::bltrank"]
}, Open  ]],

Cell[CellGroupData[{
Cell[207364, 7689, 71, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Norm::nvm"],
Cell[207438, 7692, 178, 3, 21, "Message",
  CellTags->"Norm::nvm"],
Cell[207619, 7697, 120, 4, 24, "Notes",
  CellTags->"Norm::nvm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[207776, 7706, 113, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::vinp"],
Cell[207892, 7709, 235, 4, 37, "Message",
  CellTags->"NDSolve`ScaledVectorNorm::vinp"],
Cell[208130, 7715, 141, 4, 24, "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::vinp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[208308, 7724, 148, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Norm::vlen", "NDSolve`ScaledVectorNorm::vlen"}],
Cell[208459, 7730, 310, 8, 37, "Message",
  CellTags->{"Norm::vlen", "NDSolve`ScaledVectorNorm::vlen"}],
Cell[208772, 7740, 157, 4, 24, "Notes",
  CellTags->{"Norm::vlen", "NDSolve`ScaledVectorNorm::vlen"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[208966, 7749, 148, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Norm::winp", "NDSolve`ScaledVectorNorm::winp"}],
Cell[209117, 7755, 311, 8, 37, "Message",
  CellTags->{"Norm::winp", "NDSolve`ScaledVectorNorm::winp"}],
Cell[209431, 7765, 157, 4, 24, "Notes",
  CellTags->{"Norm::winp", "NDSolve`ScaledVectorNorm::winp"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[209625, 7774, 246, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv", 
    "LinearAlgebra`LAPACK`LASWP::blnotpiv"}],
Cell[209874, 7782, 329, 9, 21, "Message",
  CellTags->{
  "LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv", 
    "LinearAlgebra`LAPACK`LASWP::blnotpiv"}],
Cell[210206, 7793, 210, 6, 24, "Notes",
  CellTags->{
  "LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv", 
    "LinearAlgebra`LAPACK`LASWP::blnotpiv"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[210453, 7804, 186, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}],
Cell[210642, 7812, 376, 8, 37, "Message",
  CellTags->{
  "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}],
Cell[211021, 7822, 179, 5, 24, "Notes",
  CellTags->{
  "Eigenvalues::arall", "Eigenvectors::arall", "Eigensystem::arall"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[211237, 7832, 177, 5, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}],
Cell[211417, 7839, 408, 9, 37, "Message",
  CellTags->{
  "Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}],
Cell[211828, 7850, 173, 4, 24, "Notes",
  CellTags->{"Eigenvalues::arb2", "Eigenvectors::arb2", "Eigensystem::arb2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[212038, 7859, 177, 5, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}],
Cell[212218, 7866, 520, 12, 69, "Message",
  CellTags->{
  "Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}],
Cell[212741, 7880, 173, 4, 24, "Notes",
  CellTags->{"Eigenvalues::arbs", "Eigenvectors::arbs", "Eigensystem::arbs"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[212951, 7889, 186, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}],
Cell[213140, 7897, 481, 11, 69, "Message",
  CellTags->{
  "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}],
Cell[213624, 7910, 179, 5, 24, "Notes",
  CellTags->{
  "Eigenvalues::arbss", "Eigenvectors::arbss", "Eigensystem::arbss"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[213840, 7920, 192, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arbsym", "Eigenvectors::arbsym", "Eigensystem::arbsym"}],
Cell[214035, 7928, 430, 12, 37, "Message",
  CellTags->{
  "Eigenvalues::arbsym", "Eigenvectors::arbsym", "Eigensystem::arbsym"}],
Cell[214468, 7942, 182, 5, 24, "Notes",
  CellTags->{
  "Eigenvalues::arbsym", "Eigenvectors::arbsym", "Eigensystem::arbsym"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[214687, 7952, 186, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}],
Cell[214876, 7960, 357, 9, 37, "Message",
  CellTags->{
  "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}],
Cell[215236, 7971, 179, 5, 24, "Notes",
  CellTags->{
  "Eigenvalues::arerr", "Eigenvectors::arerr", "Eigensystem::arerr"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[215452, 7981, 186, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}],
Cell[215641, 7989, 345, 9, 37, "Message",
  CellTags->{
  "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}],
Cell[215989, 8000, 179, 5, 24, "Notes",
  CellTags->{
  "Eigenvalues::arfac", "Eigenvectors::arfac", "Eigensystem::arfac"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[216205, 8010, 186, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}],
Cell[216394, 8018, 747, 16, 117, "Message",
  CellTags->{
  "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}],
Cell[217144, 8036, 179, 5, 24, "Notes",
  CellTags->{
  "Eigenvalues::argpd", "Eigenvectors::argpd", "Eigensystem::argpd"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[217360, 8046, 171, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}],
Cell[217534, 8053, 613, 13, 85, "Message",
  CellTags->{"Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}],
Cell[218150, 8068, 170, 4, 24, "Notes",
  CellTags->{"Eigenvalues::arh", "Eigenvectors::arh", "Eigensystem::arh"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[218357, 8077, 177, 5, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}],
Cell[218537, 8084, 684, 14, 101, "Message",
  CellTags->{
  "Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}],
Cell[219224, 8100, 173, 4, 24, "Notes",
  CellTags->{"Eigenvalues::arhm", "Eigenvectors::arhm", "Eigensystem::arhm"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[219434, 8109, 171, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}],
Cell[219608, 8116, 321, 7, 37, "Message",
  CellTags->{"Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}],
Cell[219932, 8125, 170, 4, 24, "Notes",
  CellTags->{"Eigenvalues::arm", "Eigenvectors::arm", "Eigensystem::arm"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[220139, 8134, 177, 5, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}],
Cell[220319, 8141, 351, 8, 37, "Message",
  CellTags->{
  "Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}],
Cell[220673, 8151, 173, 4, 24, "Notes",
  CellTags->{"Eigenvalues::armc", "Eigenvectors::armc", "Eigensystem::armc"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[220883, 8160, 177, 5, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}],
Cell[221063, 8167, 449, 11, 53, "Message",
  CellTags->{
  "Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}],
Cell[221515, 8180, 173, 4, 24, "Notes",
  CellTags->{"Eigenvalues::armw", "Eigenvectors::armw", "Eigensystem::armw"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[221725, 8189, 171, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}],
Cell[221899, 8196, 502, 10, 69, "Message",
  CellTags->{"Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}],
Cell[222404, 8208, 170, 4, 24, "Notes",
  CellTags->{"Eigenvalues::ars", "Eigenvectors::ars", "Eigensystem::ars"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[222611, 8217, 186, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}],
Cell[222800, 8225, 326, 8, 37, "Message",
  CellTags->{
  "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}],
Cell[223129, 8235, 179, 5, 24, "Notes",
  CellTags->{
  "Eigenvalues::arstv", "Eigenvectors::arstv", "Eigensystem::arstv"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[223345, 8245, 186, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}],
Cell[223534, 8253, 344, 9, 37, "Message",
  CellTags->{
  "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}],
Cell[223881, 8264, 179, 5, 24, "Notes",
  CellTags->{
  "Eigenvalues::emeth", "Eigenvectors::emeth", "Eigensystem::emeth"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[224097, 8274, 192, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Eigenvalues::maxit2", "Eigenvectors::maxit2", "Eigensystem::maxit2"}],
Cell[224292, 8282, 760, 16, 117, "Message",
  CellTags->{
  "Eigenvalues::maxit2", "Eigenvectors::maxit2", "Eigensystem::maxit2"}],
Cell[225055, 8300, 182, 5, 24, "Notes",
  CellTags->{
  "Eigenvalues::maxit2", "Eigenvectors::maxit2", "Eigensystem::maxit2"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[225274, 8310, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::sing1"],
Cell[225366, 8313, 199, 3, 37, "Message",
  CellTags->"LinearSolve::sing1"],
Cell[225568, 8318, 129, 4, 24, "Notes",
  CellTags->"LinearSolve::sing1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[225734, 8327, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::sqmat1"],
Cell[225828, 8330, 206, 4, 37, "Message",
  CellTags->"LinearSolve::sqmat1"],
Cell[226037, 8336, 130, 4, 24, "Notes",
  CellTags->"LinearSolve::sqmat1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[226204, 8345, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SparseArray::posr"],
Cell[226294, 8348, 286, 5, 37, "Message",
  CellTags->"SparseArray::posr"],
Cell[226583, 8355, 128, 4, 24, "Notes",
  CellTags->"SparseArray::posr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[226748, 8364, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::kryme"],
Cell[226840, 8367, 205, 5, 21, "Message",
  CellTags->"LinearSolve::kryme"],
Cell[227048, 8374, 129, 4, 24, "Notes",
  CellTags->"LinearSolve::kryme"]
}, Open  ]],

Cell[CellGroupData[{
Cell[227214, 8383, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::kryit"],
Cell[227306, 8386, 266, 6, 37, "Message",
  CellTags->"LinearSolve::kryit"],
Cell[227575, 8394, 129, 4, 24, "Notes",
  CellTags->"LinearSolve::kryit"]
}, Open  ]],

Cell[CellGroupData[{
Cell[227741, 8403, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krytol"],
Cell[227835, 8406, 266, 6, 37, "Message",
  CellTags->"LinearSolve::krytol"],
Cell[228104, 8414, 130, 4, 24, "Notes",
  CellTags->"LinearSolve::krytol"]
}, Open  ]],

Cell[CellGroupData[{
Cell[228271, 8423, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krypre"],
Cell[228365, 8426, 228, 5, 37, "Message",
  CellTags->"LinearSolve::krypre"],
Cell[228596, 8433, 130, 4, 24, "Notes",
  CellTags->"LinearSolve::krypre"]
}, Open  ]],

Cell[CellGroupData[{
Cell[228763, 8442, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krynor"],
Cell[228857, 8445, 251, 6, 37, "Message",
  CellTags->"LinearSolve::krynor"],
Cell[229111, 8453, 130, 4, 24, "Notes",
  CellTags->"LinearSolve::krynor"]
}, Open  ]],

Cell[CellGroupData[{
Cell[229278, 8462, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krynorv"],
Cell[229374, 8465, 270, 6, 53, "Message",
  CellTags->"LinearSolve::krynorv"],
Cell[229647, 8473, 131, 4, 24, "Notes",
  CellTags->"LinearSolve::krynorv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[229815, 8482, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krydia"],
Cell[229909, 8485, 322, 6, 53, "Message",
  CellTags->"LinearSolve::krydia"],
Cell[230234, 8493, 130, 4, 24, "Notes",
  CellTags->"LinearSolve::krydia"]
}, Open  ]],

Cell[CellGroupData[{
Cell[230401, 8502, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krymit"],
Cell[230495, 8505, 370, 8, 53, "Message",
  CellTags->"LinearSolve::krymit"],
Cell[230868, 8515, 130, 4, 24, "Notes",
  CellTags->"LinearSolve::krymit"]
}, Open  ]],

Cell[CellGroupData[{
Cell[231035, 8524, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krypr"],
Cell[231127, 8527, 330, 7, 53, "Message",
  CellTags->"LinearSolve::krypr"],
Cell[231460, 8536, 129, 4, 24, "Notes",
  CellTags->"LinearSolve::krypr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[231626, 8545, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::kryma"],
Cell[231718, 8548, 325, 7, 37, "Message",
  CellTags->"LinearSolve::kryma"],
Cell[232046, 8557, 129, 4, 24, "Notes",
  CellTags->"LinearSolve::kryma"]
}, Open  ]],

Cell[CellGroupData[{
Cell[232212, 8566, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krynom"],
Cell[232306, 8569, 340, 8, 53, "Message",
  CellTags->"LinearSolve::krynom"],
Cell[232649, 8579, 130, 4, 24, "Notes",
  CellTags->"LinearSolve::krynom"]
}, Open  ]],

Cell[CellGroupData[{
Cell[232816, 8588, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::krynum"],
Cell[232910, 8591, 244, 6, 37, "Message",
  CellTags->"LinearSolve::krynum"],
Cell[233157, 8599, 130, 4, 24, "Notes",
  CellTags->"LinearSolve::krynum"]
}, Open  ]],

Cell[CellGroupData[{
Cell[233324, 8608, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinearSolve::kryinfp"],
Cell[233420, 8611, 321, 7, 37, "Message",
  CellTags->"LinearSolve::kryinfp"],
Cell[233744, 8620, 131, 4, 24, "Notes",
  CellTags->"LinearSolve::kryinfp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[233912, 8629, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SparseArray::drnk"],
Cell[234002, 8632, 281, 6, 37, "Message",
  CellTags->"SparseArray::drnk"],
Cell[234286, 8640, 128, 4, 24, "Notes",
  CellTags->"SparseArray::drnk"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

