(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     73713,       2866]*)
(*NotebookOutlinePosition[    120076,       3936]*)
(*  CellTagsIndexPosition[    118040,       3879]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Mathematical Functions", "Title"],

Cell[CellGroupData[{

Cell["Power::infy", "ObjectNameWarningMessages",
  CellTags->"Power::infy"],

Cell[BoxData[
    RowBox[{\(Power::"infy"\), \(\(:\)\(\ \)\), \(\(Infinite\ expression\)\(\ \
\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\(encountered\)\(.\)\)\)}]], "Message",
  CellTags->"Power::infy"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is generated if ",
  StyleBox["Mathematica", "TI"],
  " encounters division by zero."
}], "Notes",
  CellTags->"Power::infy"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Power::infy"],

Cell["Explicit division by zero will generate a warning message.", "Text",
  CellTags->"Power::infy"],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/0\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Power::infy"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0\) encountered."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Power::infy"],

Cell[BoxData[
    \(ComplexInfinity\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Power::infy"]
}, Open  ]],

Cell["\<\
Division by zero often occurs indirectly within another \
calculation.\
\>", "Text",
  CellTags->"Power::infy"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[1/Sqrt[Abs[x]], {x, \(-1\), 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Power::infy"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0.`\) encountered."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"Power::infy"],

Cell[BoxData[
    \(NIntegrate::"inum" \(\(:\)\(\ \)\) 
      "Integrand \!\(1\/\@\(Abs[x]\)\) is not numerical at \!\({x}\) = \
\!\({0.`}\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"Power::infy"],

Cell[BoxData[
    \(NIntegrate[1\/\@Abs[x], {x, \(-1\), 1}]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Power::infy"]
}, Open  ]],

Cell["\<\
The numerical integral in this example can be done by including the \
location of the singularity in the limits of integration.\
\>", "Text",
  CellTags->"Power::infy"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[1/Sqrt[Abs[x]], {x, \(-1\), 0, 1}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Power::infy"],

Cell[BoxData[
    \(4.000000000032326`\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Power::infy"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Random::randn", "ObjectNameWarningMessages",
  CellTags->"Random::randn"],

Cell[BoxData[
    \(Random::"randn" \(\(:\)\(\ \)\) 
      "Range specification `1` in `2` is not a valid number or pair of \
numbers."\)], "Message",
  CellLabel->"From In[41]:=",
  CellTags->"Random::randn"],

Cell[TextData[{
  "\[FilledSmallSquare] The second argument in ",
  StyleBox["Random", "MR"],
  " is expected to be either a number or a list of two numbers."
}], "Notes",
  CellTags->"Random::randn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Random::randn"],

Cell[TextData[{
  "If the second element in ",
  StyleBox["Random", "MR"],
  " is a list, that list should give both endpoints for the range of random \
numbers."
}], "Text",
  CellTags->"Random::randn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Random[Integer, \ {10}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Random::randn"],

Cell[BoxData[
    \(Random::"randn" \(\(:\)\(\ \)\) 
      "Range specification \!\({10}\) in \!\(Random[\(\(Integer, \(\({10}\)\)\
\)\)]\) is not a valid number or pair of numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Random::randn"],

Cell[BoxData[
    \(Random[Integer, {10}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Random::randn"]
}, Open  ]],

Cell["This generates a random integer between zero and ten.", "Text",
  CellTags->"Random::randn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Random[Integer, \ {0, \ 10}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Random::randn"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Random::randn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Random::randt", "ObjectNameWarningMessages",
  CellTags->"Random::randt"],

Cell[BoxData[
    RowBox[{"Random", "::", 
      RowBox[{"\<\"randt\"\>", ":", " ", 
        RowBox[{"Type", " ", "specification", " ", 
          StyleBox["spec",
            "TI"], \(\(\ \)\(in\)\(\ \)\), 
          StyleBox["expr",
            "TI"], \(\(\ \)\(should\ be\ Real, \ Integer, \ 
          or\ \(\(Complex\)\(.\)\)\)\)}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Random::randt"],

Cell[TextData[{
  "\[FilledSmallSquare] The valid default values for the first argument in ",
  StyleBox["Random", "MR"],
  " are ",
  StyleBox["Real", "MR"],
  ", ",
  StyleBox["Integer", "MR"],
  ", and ",
  StyleBox["Complex", "MR"],
  ".\n\[FilledSmallSquare] Statistical distributions packages (",
  StyleBox["Statistics`NormalDistribution`", "MR"],
  ", ",
  StyleBox["Statistics`ContinuousDistributions`", "MR"],
  ", ",
  StyleBox["Statistics`DiscreteDistributions`", "MR"],
  ") can be loaded to generate random numbers with non-uniform distributions. \
 After loading these packages, valid values for the first argument in ",
  StyleBox["Random", "MR"],
  " include specifications of statistical distributions."
}], "Notes",
  CellTags->"Random::randt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Random::randt"],

Cell[TextData[{
  "The default definition of ",
  StyleBox["Random", "MR"],
  " generates a message if the first element is anything other than ",
  StyleBox["Real", "MR"],
  ", ",
  StyleBox["Integer", "MR"],
  ", or ",
  StyleBox["Complex", "MR"],
  "."
}], "Text",
  CellTags->"Random::randt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Random[Positive]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Random::randt"],

Cell[BoxData[
    \(Random::"randt" \(\(:\)\(\ \)\) 
      "Type specification \!\(Positive\) in \!\(Random[Positive]\) should be \
Real, Integer, or Complex."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Random::randt"],

Cell[BoxData[
    \(Random[Positive]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Random::randt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FactorInteger::facnf", "ObjectNameWarningMessages",
  CellTags->"FactorInteger::facnf"],

Cell[BoxData[
    RowBox[{\(FactorInteger::"facnf"\), \(\(:\)\(\ \)\), \(\(Unable\)\(\ \
\)\(to\)\(\ \)\(factor\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"FactorInteger::facnf"],

Cell[TextData[{
  "\[FilledSmallSquare] There are no common examples in which this message is \
generated.\n\[FilledSmallSquare] This message can be generated by an internal \
failure of the algorithm for ",
  StyleBox["FactorInteger", "MR"],
  ".\n\[FilledSmallSquare] If you encounter an example of this message, \
please contact Wolfram Research Technical Support for additional \
information."
}], "Notes",
  CellTags->"FactorInteger::facnf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FactorInteger::gfacnf", "ObjectNameWarningMessages",
  CellTags->"FactorInteger::gfacnf"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(FactorInteger::"gfacnf"\), \(\(:\)\(\ \)\), "Unable", " ", 
        "to", " ", "factor", " ", 
        StyleBox["x",
          "TI"]}], " ", "+", " ", 
      RowBox[{
        StyleBox["y",
          "TI"], " ", \(\(I\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"FactorInteger::gfacnf"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FactorInteger::gfacnf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FactorInteger::facn", "ObjectNameWarningMessages",
  CellTags->"FactorInteger::facn"],

Cell[BoxData[
    RowBox[{\(FactorInteger::"facn"\), \(\(:\)\(\ \)\), \(\(Argument\)\(\ \
\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ an\ exact\ \(\(number\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"FactorInteger::facn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["FactorInteger", "MR"],
  " is not a number or is a number with finite precision.\n\
\[FilledSmallSquare] ",
  StyleBox["FactorInteger", "MR"],
  " can be used with integers, rational numbers, or complex numbers in which \
the real and imaginary parts are integers or rational numbers."
}], "Notes",
  CellTags->"FactorInteger::facn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FactorInteger::facn"],

Cell["\<\
The argument in this example is an exact numeric expression, but \
that expression is not represented as a number.\
\>", "Text",
  CellTags->"FactorInteger::facn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FactorInteger[Sin[8]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FactorInteger::facn"],

Cell[BoxData[
    \(FactorInteger::"facn" \(\(:\)\(\ \)\) 
      "Argument \!\(Sin[8]\) in \!\(FactorInteger[\(\(Sin[8]\)\)]\) is not an \
exact number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FactorInteger::facn"],

Cell[BoxData[
    \(FactorInteger[Sin[8]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FactorInteger::facn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$RandomState::rndst", "ObjectNameWarningMessages",
  CellTags->"$RandomState::rndst"],

Cell[BoxData[
    RowBox[{\($RandomState::"rndst"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ random\ \
\(\(state\)\(.\)\)\)\)}]], "Message",
  CellTags->"$RandomState::rndst"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set the value of ",
  StyleBox["$RandomState", "MR"],
  " to an invalid value.\n\[FilledSmallSquare] The intended purpose of ",
  StyleBox["$RandomState", "MR"],
  " is to provide for restoring a previous state of the pseudorandom number \
generator used by ",
  StyleBox["Random", "MR"],
  ".  This can be done by saving a value of ",
  StyleBox["$RandomState", "MR"],
  " and later reassigning that value to ",
  StyleBox["$RandomState", "MR"],
  "."
}], "Notes",
  CellTags->"$RandomState::rndst"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$RandomState::rndst"],

Cell[TextData[{
  "Zero is not a valid value for ",
  StyleBox["$RandomState", "MR"],
  ".  When this error occurs, the value of ",
  StyleBox["$RandomState", "MR"],
  " is left unchanged."
}], "Text",
  CellTags->"$RandomState::rndst"],

Cell[CellGroupData[{

Cell[BoxData[
    \($RandomState = 0\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$RandomState::rndst"],

Cell[BoxData[
    \($RandomState::"rndst" \(\(:\)\(\ \)\) 
      "\!\(0\) is not a valid random state."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$RandomState::rndst"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$RandomState::rndst"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Chop::tolnn
Rationalize::tolnn\
\>", "ObjectNameWarningMessages",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"tolnn\"\>"}], \(\(:\)\(\ \)\), "Tolerance", " ",
         "specification", " ", 
        StyleBox["expr",
          "TI"], " ", "must", " ", "be", " ", "a", " ", "non"}], 
      "-", \(negative\ \(\(number\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Chop", "MR"],
  " or ",
  StyleBox["Rationalize", "MR"],
  " is negative or is not a real number."
}], "Notes",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],

Cell["\<\
An error occurs in this example because the second argument is not \
a number.\
\>", "Text",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Chop[{0.01, \ 0.1, \ 1.0, \ 10.0, \ 100.0}, \ Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],

Cell[BoxData[
    \(Chop::"tolnn" \(\(:\)\(\ \)\) 
      "Tolerance specification \!\(Automatic\) must be a non-negative \
number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],

Cell[BoxData[
    \(Chop[{0.01`, 0.1`, 1.`, 10.`, 100.`}, Automatic]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Chop", "MR"],
  "."
}], "Text",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Chop[{0.01, \ 0.1, \ 1.0, \ 10.0, \ 100.0}, \ 0.5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],

Cell[BoxData[
    \({0, 0, 1.`, 10.`, 100.`}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ClebschGordan::phy", "ObjectNameWarningMessages",
  CellTags->"ClebschGordan::phy"],

Cell[BoxData[
    RowBox[{\(ClebschGordan::"phy"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ \(\(physical\)\(.\)\)\)\)}]], "Message",
  CellTags->"ClebschGordan::phy"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the arguments in ",
  StyleBox["ClebschGordan", "MR"],
  " or ",
  StyleBox["ThreeJSymbol", "MR"],
  " do not represent a physically meaningful coefficient."
}], "Notes",
  CellTags->"ClebschGordan::phy"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ClebschGordan::phy"],

Cell["\<\
An error occurs in this example because the input does not \
correspond to a possible decomposition.\
\>", "Text",
  CellTags->"ClebschGordan::phy"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClebschGordan[{2, 1}, {1, 1}, {2, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ClebschGordan::phy"],

Cell[BoxData[
    \(ClebschGordan::"phy" \(\(:\)\(\ \)\) 
      "\!\(ThreeJSymbol[\(\(\(\({2, 1}\)\), \(\({1, 1}\)\), \(\({2, \
\(\(-1\)\)}\)\)\)\)]\) is not physical."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ClebschGordan::phy"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ClebschGordan::phy"]
}, Open  ]],

Cell["\<\
This shows a physically meaningful Clebsch-Gordan \
coefficient.\
\>", "Text",
  CellTags->"ClebschGordan::phy"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClebschGordan[{2, 1}, {1, 0}, {2, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ClebschGordan::phy"],

Cell[BoxData[
    \(1\/\@6\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ClebschGordan::phy"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ClebschGordan::tri", "ObjectNameWarningMessages",
  CellTags->"ClebschGordan::tri"],

Cell[BoxData[
    RowBox[{\(ClebschGordan::"tri"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ \(\(triangular\)\(.\)\)\)\)}]], "Message",
  CellTags->"ClebschGordan::tri"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the arguments in ",
  StyleBox["ClebschGordan", "MR"],
  ", ",
  StyleBox["ThreeJSymbol", "MR"],
  ", or ",
  StyleBox["SixJSymbol", "MR"],
  " fail to satisfy the required triangle inequality."
}], "Notes",
  CellTags->"ClebschGordan::tri"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ClebschGordan::tri"],

Cell["\<\
An error occurs in this example because the indicated decomposition \
is not possible.\
\>", "Text",
  CellTags->"ClebschGordan::tri"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClebschGordan[{1, 0}, {2, 0}, {4, 0}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ClebschGordan::tri"],

Cell[BoxData[
    \(ClebschGordan::"tri" \(\(:\)\(\ \)\) 
      "\!\(ThreeJSymbol[\(\(\(\({1, 0}\)\), \(\({2, 0}\)\), \(\({4, \
0}\)\)\)\)]\) is not triangular."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ClebschGordan::tri"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ClebschGordan::tri"]
}, Open  ]],

Cell["This shows a physically valid Clebsch-Gordan coefficient.", "Text",
  CellTags->"ClebschGordan::tri"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClebschGordan[{1, 0}, {2, 0}, {3, 0}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ClebschGordan::tri"],

Cell[BoxData[
    \(\@\(3\/5\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ClebschGordan::tri"]
}, Open  ]],

Cell[TextData[{
  "A similar error can also occur for ",
  StyleBox["ThreeJSymbol", "MR"],
  " or ",
  StyleBox["SixJSymbol", "MR"],
  "."
}], "Text",
  CellTags->"ClebschGordan::tri"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SixJSymbol[{1, 1, 1}, {2, 5, 5}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"ClebschGordan::tri"],

Cell[BoxData[
    \(ClebschGordan::"tri" \(\(:\)\(\ \)\) 
      "\!\(SixJSymbol[\(\(\(\({1, 1, 1}\)\), \(\({2, 5, 5}\)\)\)\)]\) is not \
triangular."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"ClebschGordan::tri"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"ClebschGordan::tri"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EllipticLog::elld", "ObjectNameWarningMessages",
  CellTags->"EllipticLog::elld"],

Cell[BoxData[
    RowBox[{\(EllipticLog::"elld"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \
\)\(arguments\)\(\ \)\(to\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(are\ inconsistent\ with\ the\ defining\ equation\ \
y^2\  == \ x^3\  + \ a\ x^2\  + \ b\ \(\(x\)\(.\)\)\)\)}]], "Message",
  CellTags->"EllipticLog::elld"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the arguments ",
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  ", ",
  StyleBox["y", "MR",
    FontSlant->"Italic"],
  ", ",
  StyleBox["a", "MR",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["b", "MR",
    FontSlant->"Italic"],
  " in ",
  StyleBox["EllipticLog[{", "MR"],
  StyleBox["x", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["y", "MR",
    FontSlant->"Italic"],
  StyleBox["},{", "MR"],
  StyleBox["a", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["b", "MR",
    FontSlant->"Italic"],
  StyleBox["}]", "MR"],
  " do not satisfy the indicated equation."
}], "Notes",
  CellTags->"EllipticLog::elld"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
EllipticLog::ellnp
EllipticExp::ellnp\
\>", "ObjectNameWarningMessages",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"ellnp\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
        "argument", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "an", " ", "ordered", " ", 
        "pair"}], ";", 
      " ", \(a\ list\ of\ length\ 2\ is\ \(\(expected\)\(.\)\)\)}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated argument in ",
  StyleBox["EllipticLog", "MR"],
  " or ",
  StyleBox["EllipticExp", "MR"],
  " is not a list with two elements."
}], "Notes",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["EllipticExp", "MR"],
  " is expected to be a list with two elements."
}], "Text",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(EllipticExp[1.0, 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],

Cell[BoxData[
    \(EllipticExp::"ellnp" \(\(:\)\(\ \)\) 
      "The argument \!\(1.`\) is not an ordered pair; a list of length 2 is \
expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"EllipticExp::ellnp", "EllipticLog::ellnp"}],

Cell[BoxData[
    \(EllipticExp[1.`, 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"EllipticExp::ellnp", "EllipticLog::ellnp"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["EllipticExp", "MR"],
  "."
}], "Text",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(EllipticExp[1.0, {1, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],

Cell[BoxData[
    \({0.5749706105873643`, \(-1.0467292102033054`\)}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"EllipticExp::ellnp", "EllipticLog::ellnp"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EllipticReducedHalfPeriods::nind", "ObjectNameWarningMessages",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[BoxData[
    RowBox[{\(EllipticReducedHalfPeriods::"nind"\), \(\(:\)\(\ \)\), \(\(Half\
\)\(\ \)\(periods\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(are\ not\ \(\(independent\)\(.\)\)\)\)}]], "Message",\

  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the imaginary part of ",
  StyleBox["u", "MR",
    FontSlant->"Italic"],
  " and ",
  StyleBox["v", "MR",
    FontSlant->"Italic"],
  " in ",
  StyleBox["EllipticReducedHalfPeriods[{", "MR"],
  StyleBox["u", "MR",
    FontSlant->"Italic"],
  StyleBox[",", "MR"],
  StyleBox["v", "MR",
    FontSlant->"Italic"],
  StyleBox["}]", "MR"],
  " is zero.\n\[FilledSmallSquare] This message can also be generated by \
related functions, such as ",
  StyleBox["WeierstrassHalfPeriods", "MR"],
  " and ",
  StyleBox["WeierstrassInvariants", "MR"],
  ", that use ",
  StyleBox["EllipticReducedHalfPeriods", "MR"],
  " internally."
}], "Notes",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[TextData[{
  "An error occurs in this example because the arguments in ",
  StyleBox["EllipticReducedHalfPeriods", "MR"],
  " are real numbers."
}], "Text",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EllipticReducedHalfPeriods[{1.0, 1.5}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[BoxData[
    \(EllipticReducedHalfPeriods::"nind" \(\(:\)\(\ \)\) 
      "Half periods \!\({1.`, 1.5`}\) are not independent."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[BoxData[
    \(EllipticReducedHalfPeriods[{1.`, 1.5`}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"EllipticReducedHalfPeriods::nind"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["EllipticReducedHalfPeriods", "MR"],
  "."
}], "Text",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EllipticReducedHalfPeriods[{1.0, 1.5 + 2.3\ I}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[BoxData[
    \({1.`, \(-0.5`\) + 2.3`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"EllipticReducedHalfPeriods::nind"]
}, Open  ]],

Cell[TextData[{
  "This message can also be generated by related functions that are computed \
using ",
  StyleBox["EllipticReducedHalfPeriods", "MR"],
  "."
}], "Text",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[CellGroupData[{

Cell[BoxData[
    \(WeierstrassInvariants[{1.0, 1.0}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[BoxData[
    \(EllipticReducedHalfPeriods::"nind" \(\(:\)\(\ \)\) 
      "Half periods \!\({1.`, 1.`}\) are not independent."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[BoxData[
    \(WeierstrassInvariants[{1.`, 1.`}]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"EllipticReducedHalfPeriods::nind"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
EllipticTheta::etype
EllipticThetaPrime::etype\
\>", "ObjectNameWarningMessages",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"etype\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
        "first", " ", "argument", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "expected", " ", "to", " ", "be", " ", "1"}],
       ",", " ", "2", ",", " ", "3", ",", " ", \(or\ 4. \)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],

Cell["\<\
\[FilledSmallSquare] Generated when the first argument in the \
indicated function is not valid.\
\>", "Notes",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],

Cell["\<\
An error occurs in this example because the first argument does \
match any of the allowed values specified in the message.\
\>", "Text",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(EllipticTheta[1.5, 1.5, 0.1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],

Cell[BoxData[
    \(EllipticTheta::"etype" \(\(:\)\(\ \)\) 
      "The first argument \!\(1.5`\) is expected to be 1, 2, 3, or 4."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],

Cell[BoxData[
    \(EllipticTheta[1.5`, 1.5`, 0.1`]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}]
}, Open  ]],

Cell[TextData[{
  "This example shows valid arguments in ",
  StyleBox["EllipticTheta", "MR"],
  "."
}], "Text",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(EllipticTheta[1, 1.5, 0.1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],

Cell[BoxData[
    \(1.1328604718642217`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ExtendedGCD::egcd", "ObjectNameWarningMessages",
  CellTags->"ExtendedGCD::egcd"],

Cell[BoxData[
    RowBox[{\(ExtendedGCD::"egcd"\), ":", " ", 
      RowBox[{"Arguments", " ", "in", " ", 
        StyleBox["expr",
          
          "TI"], \(\(\ \)\(should\ be\ \(\(integers\)\(.\)\)\)\)}]}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"ExtendedGCD::egcd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the arguments in ",
  StyleBox["ExtendedGCD", "MR"],
  " are not integers."
}], "Notes",
  CellTags->"ExtendedGCD::egcd"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ExtendedGCD::egcd"],

Cell["\<\
An error occurs in this example because the arguments are inexact \
numbers rather than integers.\
\>", "Text",
  CellTags->"ExtendedGCD::egcd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExtendedGCD[17.0, 5.0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ExtendedGCD::egcd"],

Cell[BoxData[
    \(ExtendedGCD::"egcd" \(\(:\)\(\ \)\) 
      "Arguments in \!\(ExtendedGCD[\(\(17.`, 5.`\)\)]\) should be integers."\
\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ExtendedGCD::egcd"],

Cell[BoxData[
    \(ExtendedGCD[17.`, 5.`]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ExtendedGCD::egcd"]
}, Open  ]],

Cell[TextData[{
  "This input shows valid arguments in ",
  StyleBox["ExtendedGCD", "MR"],
  "."
}], "Text",
  CellTags->"ExtendedGCD::egcd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExtendedGCD[17, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ExtendedGCD::egcd"],

Cell[BoxData[
    \({1, {\(-2\), 7}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ExtendedGCD::egcd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ExtendedGCD::egcdz", "ObjectNameWarningMessages",
  CellTags->"ExtendedGCD::egcdz"],

Cell[BoxData[
    \(ExtendedGCD::"egcdz" \(\(:\)\(\ \)\) \(ExtendedGCD[0, 
          0]\ has\ no\ unique\ \(\(solution\)\(.\)\)\)\)], "Message",
  CellTags->"ExtendedGCD::egcdz"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"ExtendedGCD::egcdz"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FactorInteger::faccp", "ObjectNameWarningMessages",
  CellTags->"FactorInteger::faccp"],

Cell[BoxData[
    RowBox[{\(FactorInteger::"faccp"\), \(\(:\)\(\ \)\), \(\(Unable\)\(\ \
\)\(to\)\(\ \)\(factor\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\(completely\)\(.\)\)\)}]], "Message",
  CellTags->"FactorInteger::faccp"],

Cell["\<\
\[FilledSmallSquare] Generated by an internal failure in the \
algorithm used for factoring integers.
\[FilledSmallSquare] If you see this message in a situation in which it is \
not expected, please contact Technical Support.\
\>", "Notes",
  CellTags->"FactorInteger::faccp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
GCD::exact
LCM::exact\
\>", "ObjectNameWarningMessages",
  CellTags->{"GCD::exact", "LCM::exact"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"exact\"\>"}], \(\(:\)\(\ \)\), "Argument", " ", 
      StyleBox["expr",
        "TI"], " ", "at", " ", "position", " ", 
      StyleBox["n",
        "TI"], " ", "is", " ", "not", " ", "an", " ", "exact", 
      " ", \(\(number\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"GCD::exact", "LCM::exact"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated argument in ",
  StyleBox["GCD", "MR"],
  " or ",
  StyleBox["LCM", "MR"],
  " is not an exact number.\n\[FilledSmallSquare] Exact numbers include \
integers, rational numbers, and other numbers that are known exactly.  \
Numbers with decimal points are inexact numbers."
}], "Notes",
  CellTags->{"GCD::exact", "LCM::exact"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"GCD::exact", "LCM::exact"}],

Cell["\<\
An error occurs in this example because the first argument is an \
inexact number.\
\>", "Text",
  CellTags->{"GCD::exact", "LCM::exact"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(GCD[3.5, 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"GCD::exact", "LCM::exact"}],

Cell[BoxData[
    \(GCD::"exact" \(\(:\)\(\ \)\) 
      "Argument \!\(3.5`\) at position \!\(2\) is not an exact number."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"GCD::exact", "LCM::exact"}],

Cell[BoxData[
    \(GCD[2, 3.5`]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"GCD::exact", "LCM::exact"}]
}, Open  ]],

Cell[TextData[{
  "This example shows valid arguments in ",
  StyleBox["GCD", "MR"],
  "."
}], "Text",
  CellTags->{"GCD::exact", "LCM::exact"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(GCD[35/10, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"GCD::exact", "LCM::exact"}],

Cell[BoxData[
    \(1\/2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"GCD::exact", "LCM::exact"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gamma::gamc", "ObjectNameWarningMessages",
  CellTags->"Gamma::gamc"],

Cell[BoxData[
    RowBox[{\(Gamma::"gamc"\), \(\(:\)\(\ \)\), \(\(Gamma\)\([\)\), 
      StyleBox["expr",
        "TI"], \(\(,\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\(]\)\(\ \)\(is\)\(\ \)\(too\)\(\ \)\(ill\)\) - 
        conditioned\ to\ \(\(compute\)\(.\)\)\)}]], "Message",
  CellTags->"Gamma::gamc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the series used to compute numerical \
approximations for the ",
  StyleBox["Gamma", "MR"],
  " function is not valid at the indicated point."
}], "Notes",
  CellTags->"Gamma::gamc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Gamma::gamc"],

Cell[TextData[{
  "The algorithm used by ",
  StyleBox["Gamma", "MR"],
  " is not designed to compute a numerical approximation at this point."
}], "Text",
  CellTags->"Gamma::gamc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Gamma[10. ^57\ I, \ 10. ^70]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Gamma::gamc"],

Cell[BoxData[
    \(Gamma::"gamc" \(\(:\)\(\ \)\) 
      "Gamma[\!\(\(\(0.`\[InvisibleSpace]\)\) + \(\(9.999999999999999`*^56\\ \
\[ImaginaryI]\)\)\), \!\(9.999999999999999`*^69\)] is too ill-conditioned to \
compute."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Gamma::gamc"],

Cell[BoxData[
    \(Gamma[9.999999999999999`*^56\ \[ImaginaryI], 
      9.999999999999999`*^69]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Gamma::gamc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::indet", "ObjectNameWarningMessages",
  CellTags->"General::indet"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"indet\"\>"}], \(\(:\)\(\ \)\), "Indeterminate", 
      " ", "expression", " ", 
      StyleBox["expr",
        "TI"], " ", \(\(encountered\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::indet"],

Cell["\<\
\[FilledSmallSquare] Generated when an indeterminate expression is \
encountered in arithmetic.
\[FilledSmallSquare] This message is generated for operations such as \
multiplying zero and infinity.
\[FilledSmallSquare] This message often occurs as a result of indeterminate \
operations that are invoked by other functions.\
\>", "Notes",
  CellTags->"General::indet"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::indet"],

Cell["\<\
An error occurs in this example because this arithmetic corresponds \
to multiplying zero and infinity.\
\>", "Text",
  CellTags->"General::indet"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((2 + 3 - 5)\)/\((7 - 8 + 1)\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::indet"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0\) encountered."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::indet"],

Cell[BoxData[
    \(\[Infinity]::"indet" \(\(:\)\(\ \)\) 
      "Indeterminate expression \!\(0\\ ComplexInfinity\) encountered."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::indet"],

Cell[BoxData[
    \(Indeterminate\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::indet"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Prime::intpp", "ObjectNameWarningMessages",
  CellTags->"Prime::intpp"],

Cell[BoxData[
    RowBox[{\(Prime::"intpp"\), \(\(:\)\(\ \)\), \(\(Positive\)\(\ \
\)\(integer\)\(\ \)\(argument\)\(\ \)\(expected\)\(\ \)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Prime::intpp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated argument used in ",
  StyleBox["Prime", "MR"],
  " is not a positive integer."
}], "Notes",
  CellTags->"Prime::intpp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Prime::intpp"],

Cell["\<\
An error occurs in this example because the argument is not a \
positive integer.\
\>", "Text",
  CellTags->"Prime::intpp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Prime[0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Prime::intpp"],

Cell[BoxData[
    \(Prime::"intpp" \(\(:\)\(\ \)\) 
      "Positive integer argument expected in \!\(Prime[0]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Prime::intpp"],

Cell[BoxData[
    \(Prime[0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Prime::intpp"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["Prime", "MR"],
  "."
}], "Text",
  CellTags->"Prime::intpp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Prime[999]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Prime::intpp"],

Cell[BoxData[
    \(7907\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Prime::intpp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["JacobiSymbol::jcpo", "ObjectNameWarningMessages",
  CellTags->"JacobiSymbol::jcpo"],

Cell[BoxData[
    RowBox[{\(JacobiSymbol::"jcpo"\), \(\(:\)\(\ \)\), "Second", " ", 
      "argument", " ", 
      StyleBox["arg",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ an\ odd, \ 
      positive\ \(\(integer\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"JacobiSymbol::jcpo"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["JacobiSymbol", "MR"],
  " is not a positive integer or is not odd."
}], "Notes",
  CellTags->"JacobiSymbol::jcpo"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"JacobiSymbol::jcpo"],

Cell["\<\
An error occurs in this example because the second argument is an \
even integer.\
\>", "Text",
  CellTags->"JacobiSymbol::jcpo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(JacobiSymbol[5, 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"JacobiSymbol::jcpo"],

Cell[BoxData[
    \(JacobiSymbol::"jcpo" \(\(:\)\(\ \)\) 
      "Second argument \!\(2\) in \!\(JacobiSymbol[\(\(5, 2\)\)]\) should be \
an odd, positive integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"JacobiSymbol::jcpo"],

Cell[BoxData[
    \(JacobiSymbol[5, 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"JacobiSymbol::jcpo"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["JacobiSymbol", "MR"],
  "."
}], "Text",
  CellTags->"JacobiSymbol::jcpo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(JacobiSymbol[5, 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"JacobiSymbol::jcpo"],

Cell[BoxData[
    \(\(-1\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"JacobiSymbol::jcpo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LegendreP::ltype
LegendreQ::ltype\
\>", "ObjectNameWarningMessages",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"ltype\"\>"}], \(\(:\)\(\ \)\), "Legendre", " ", 
        "type", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "expected", " ", "to", " ", "be", " ", "1"}],
       ",", " ", "2", ",", " ", \(or\ 3. \)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["LegendreP", "MR"],
  " or ",
  StyleBox["LegendreQ", "MR"],
  " is used with four arguments, and the third argument is not ",
  StyleBox["1", "MR"],
  ", ",
  StyleBox["2", "MR"],
  ", or ",
  StyleBox["3", "MR"],
  "."
}], "Notes",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid value for the third argument when ",
  StyleBox["LegendreP", "MR"],
  " is used with four arguments."
}], "Text",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LegendreP[n, m, Automatic, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],

Cell[BoxData[
    \(LegendreP::"ltype" \(\(:\)\(\ \)\) 
      "Legendre type \!\(Automatic\) is expected to be 1, 2, or 3."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],

Cell[BoxData[
    \(LegendreP[n, m, Automatic, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}]
}, Open  ]],

Cell[TextData[{
  "The default value for the third argument in this example is ",
  StyleBox["1", "MR"],
  "."
}], "Text",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LegendreP[n, m, 1, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],

Cell[BoxData[
    \(LegendreP[n, m, x]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
MathieuCharacteristicA::nnord
MathieuCharacteristicB::nnord\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "MathieuCharacteristicA::nnord", "MathieuCharacteristicB::nnord"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"nnord\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
        "order", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "non"}], 
      "-", \(\(negative\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "MathieuCharacteristicA::nnord", "MathieuCharacteristicB::nnord"}],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->{
  "MathieuCharacteristicA::nnord", "MathieuCharacteristicB::nnord"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathieuCharacteristicB::zord", "ObjectNameWarningMessages",
  CellTags->"MathieuCharacteristicB::zord"],

Cell[BoxData[
    \(MathieuCharacteristicB::"zord" \(\(:\)\(\ \)\) \(There\ is\ no\ zero - 
        th\ order\ \(\(MathieuCharacteristicB\)\(.\)\)\)\)], "Message",
  CellTags->"MathieuCharacteristicB::zord"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["MathieuCharacteristicB", "MR"],
  " is zero."
}], "Notes",
  CellTags->"MathieuCharacteristicB::zord"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"MathieuCharacteristicB::zord"],

Cell["\<\
An error occurs in this example because the first argument is zero.\
\
\>", "Text",
  CellTags->"MathieuCharacteristicB::zord"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MathieuCharacteristicB[0, 0.71]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"MathieuCharacteristicB::zord"],

Cell[BoxData[
    \(MathieuCharacteristicB::"zord" \(\(:\)\(\ \)\) 
      "There is no zero-th order MathieuCharacteristicB."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"MathieuCharacteristicB::zord"],

Cell[BoxData[
    \(MathieuCharacteristicB[0, 0.71`]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"MathieuCharacteristicB::zord"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["MathieuCharacteristicB", "MR"],
  "."
}], "Text",
  CellTags->"MathieuCharacteristicB::zord"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MathieuCharacteristicB[1, 0.71]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"MathieuCharacteristicB::zord"],

Cell[BoxData[
    \(0.23237057620012677`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"MathieuCharacteristicB::zord"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MeijerG::hdiv", "ObjectNameWarningMessages",
  CellTags->"MeijerG::hdiv"],

Cell[BoxData[
    RowBox[{\(MeijerG::"hdiv"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(does\ not\ exist . \ 
          Arguments\ are\ not\ \(\(consistent\)\(.\)\)\)\)}]], "Message",
  CellTags->"MeijerG::hdiv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the arguments in ",
  StyleBox["MeijerG", "MR"],
  " are not valid."
}], "Notes",
  CellTags->"MeijerG::hdiv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"MeijerG::hdiv"],

Cell[TextData[{
  "A warning message is generated in this example because the ",
  StyleBox["MeijerG", "MR"],
  " function is not defined for these arguments."
}], "Text",
  CellTags->"MeijerG::hdiv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MeijerG[{{}, {1}}, {{}, {1, 1}}, I]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"MeijerG::hdiv"],

Cell[BoxData[
    \(MeijerG::"hdiv" \(\(:\)\(\ \)\) 
      "\!\(MeijerG[\(\(\(\({\(\({}\)\), \(\({1}\)\)}\)\), \(\({\(\({}\)\), \(\
\({1, 1}\)\)}\)\), \[ImaginaryI]\)\)]\) does not exist. Arguments are not \
consistent."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"MeijerG::hdiv"],

Cell[BoxData[
    \(MeijerG[{{}, {1}}, {{}, {1, 1}}, \[ImaginaryI]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"MeijerG::hdiv"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["MeijerG", "MR"],
  "."
}], "Text",
  CellTags->"MeijerG::hdiv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MeijerG[{{5/2}, {1}}, {{}, {1, 1}}, I]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"MeijerG::hdiv"],

Cell[BoxData[
    \(\(-\(\(2\ \((\(-1\))\)\^\(3/4\)\ \@\(1 - \
\[ImaginaryI]\)\)\/\[Pi]\^\(3/2\)\)\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"MeijerG::hdiv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MeijerG::rarg", "ObjectNameWarningMessages",
  CellTags->"MeijerG::rarg"],

Cell[BoxData[
    RowBox[{\(MeijerG::"rarg"\), \(\(:\)\(\ \)\), \(\(MeijerG\)\(\ \)\(is\)\(\
\ \)\(used\)\(\ \)\(with\)\(\ \)\(abstract\)\(\ \)\(optional\)\(\ \
\)\(\(parameter\)\(.\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ defined\ for\ every\ complex\ value\ of\ \
optional\ \(\(parameter\)\(.\)\)\)\)}]], "Message",
  CellTags->"MeijerG::rarg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the optional fourth \
argument in ",
  StyleBox["MeijerG", "MR"],
  " is not valid.\n\[FilledSmallSquare] This message can be generated if the \
fourth argument in ",
  StyleBox["MeijerG", "MR"],
  " is zero, complex, or symbolic."
}], "Notes",
  CellTags->"MeijerG::rarg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"MeijerG::rarg"],

Cell[TextData[{
  "An error occurs in this example because zero is not a valid value for the \
fourth argument in ",
  StyleBox["MeijerG", "MR"],
  " in combination with the other arguments used here."
}], "Text",
  CellTags->"MeijerG::rarg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MeijerG[{{2.5}, {1}}, {{}, {1, 1}}, I, 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"MeijerG::rarg"],

Cell[BoxData[
    \(MeijerG::"rarg" \(\(:\)\(\ \)\) 
      "MeijerG is used with abstract optional parameter. \
\!\(MeijerG[\(\(\(\({\(\({2.5`}\)\), \(\({1}\)\)}\)\), \(\({\(\({}\)\), \
\(\({1, 1}\)\)}\)\), \[ImaginaryI], 0\)\)]\) is not defined for every complex \
value of optional parameter."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"MeijerG::rarg"],

Cell[BoxData[
    \(MeijerG[{{2.5`}, {1}}, {{}, {1, 1}}, \[ImaginaryI], 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"MeijerG::rarg"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["MeijerG", "MR"],
  "."
}], "Text",
  CellTags->"MeijerG::rarg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MeijerG[{{2.5}, {1}}, {{}, {1, 1}}, I, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"MeijerG::rarg"],

Cell[BoxData[
    \(\(-0.2712481756932025`\) - 
      0.40595158285494787`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"MeijerG::rarg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Mod::divz
Quotient::divz\
\>", "ObjectNameWarningMessages",
  CellTags->{"Mod::divz", "Quotient::divz"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"divz\"\>"}], \(\(:\)\(\ \)\), "Second", " ", 
        "argument", " ", "in", " ", 
        StyleBox["expr",
          "TI"], " ", "should", " ", "be", " ", "non"}], 
      "-", \(\(zero\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Mod::divz", "Quotient::divz"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function argument \
is zero.\
\>", "Notes",
  CellTags->{"Mod::divz", "Quotient::divz"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Mod::divz", "Quotient::divz"}],

Cell[TextData[{
  "An error occurs in this example because zero is not a valid value for the \
second argument in ",
  StyleBox["Mod", "MR"],
  "."
}], "Text",
  CellTags->{"Mod::divz", "Quotient::divz"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Mod[5, 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Mod::divz", "Quotient::divz"}],

Cell[BoxData[
    \(Mod::"divz" \(\(:\)\(\ \)\) 
      "Second argument in \!\(Mod[\(\(5, 0\)\)]\) should be non-zero."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Mod::divz", "Quotient::divz"}],

Cell[BoxData[
    \(Mod[5, 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Mod::divz", "Quotient::divz"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Mod", "MR"],
  "."
}], "Text",
  CellTags->{"Mod::divz", "Quotient::divz"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Mod[5, 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Mod::divz", "Quotient::divz"}],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Mod::divz", "Quotient::divz"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PowerMod::divz", "ObjectNameWarningMessages",
  CellTags->"PowerMod::divz"],

Cell[BoxData[
    RowBox[{\(PowerMod::"divz"\), \(\(:\)\(\ \)\), \(\(Third\)\(\ \
\)\(argument\)\(\ \)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ non - \(\(zero\)\(.\)\)\)\)}]], "Message",\

  CellTags->"PowerMod::divz"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third argument in ",
  StyleBox["PowerMod", "MR"],
  " is zero."
}], "Notes",
  CellTags->"PowerMod::divz"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"PowerMod::divz"],

Cell[TextData[{
  "An error occurs in this example because the third argument in ",
  StyleBox["PowerMod", "MR"],
  " is zero."
}], "Text",
  CellTags->"PowerMod::divz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerMod[5, 5, 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"PowerMod::divz"],

Cell[BoxData[
    \(PowerMod::"divz" \(\(:\)\(\ \)\) 
      "Third argument in \!\(PowerMod[\(\(5, 5, 0\)\)]\) should be non-zero."\
\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"PowerMod::divz"],

Cell[BoxData[
    \(PowerMod[5, 5, 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"PowerMod::divz"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["PowerMod", "MR"],
  "."
}], "Text",
  CellTags->"PowerMod::divz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerMod[5, 5, 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"PowerMod::divz"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"PowerMod::divz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PowerMod::ninv", "ObjectNameWarningMessages",
  CellTags->"PowerMod::ninv"],

Cell[BoxData[
    RowBox[{\(PowerMod::"ninv"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\(is\)\(\ \)\(not\)\(\ \)\(invertible\)\(\ \
\)\(modulo\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"PowerMod::ninv"],

Cell["\<\
\[FilledSmallSquare] Generated when a requested modular inverse \
does not exist.\
\>", "Notes",
  CellTags->"PowerMod::ninv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"PowerMod::ninv"],

Cell["\<\
An error occurs in this example because 15 is evenly divisible by \
3.\
\>", "Text",
  CellTags->"PowerMod::ninv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerMod[15, \(-1\), 3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"PowerMod::ninv"],

Cell[BoxData[
    \(PowerMod::"ninv" \(\(:\)\(\ \)\) 
      "\!\(15\) is not invertible modulo \!\(3\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"PowerMod::ninv"],

Cell[BoxData[
    \(PowerMod[15, \(-1\), 3]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"PowerMod::ninv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PowerMod::pmod", "ObjectNameWarningMessages",
  CellTags->"PowerMod::pmod"],

Cell[BoxData[
    RowBox[{\(PowerMod::"pmod"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \)\(base\)\(\ \
\)\(and\)\(\ \)\(modulus\)\(\ \)\(arguments\)\(\ \)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "must", " ", "be", " ", "Gaussian", 
      " ", \(\(integers\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"PowerMod::pmod"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the arguments in ",
  StyleBox["PowerMod", "MR"],
  " do not have the indicated form.\n\[FilledSmallSquare] This message can \
occur if one of the arguments in ",
  StyleBox["PowerMod", "MR"],
  " is not an integer."
}], "Notes",
  CellTags->"PowerMod::pmod"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"PowerMod::pmod"],

Cell["\<\
An error occurs in this example because the first argument is an \
inexact number.\
\>", "Text",
  CellTags->"PowerMod::pmod"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerMod[3.0, 2, 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"PowerMod::pmod"],

Cell[BoxData[
    \(PowerMod::"pmod" \(\(:\)\(\ \)\) 
      "The base and modulus arguments in \!\(PowerMod[\(\(3.`, 2, 2\)\)]\) \
must be Gaussian integers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"PowerMod::pmod"],

Cell[BoxData[
    \(PowerMod[3.`, 2, 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"PowerMod::pmod"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["PowerMod", "MR"],
  "."
}], "Text",
  CellTags->"PowerMod::pmod"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerMod[3, 2, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"PowerMod::pmod"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"PowerMod::pmod"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Prime::largp
PrimePi::largp\
\>", "ObjectNameWarningMessages",
  CellTags->{"Prime::largp", "PrimePi::largp"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"largp\"\>"}], \(\(:\)\(\ \)\), "Argument", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "too", " ", "large", " ", "for", " ", "this", 
      " ", \(\(implementation\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Prime::largp", "PrimePi::largp"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated argument is too large \
for this version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] The largest supported argument in ",
  StyleBox["Prime", "MR"],
  " is typically about ",
  StyleBox["2^60", "MR"],
  "."
}], "Notes",
  CellTags->{"Prime::largp", "PrimePi::largp"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Prime::largp", "PrimePi::largp"}],

Cell[TextData[{
  "An error occurs in this example because the argument is larger than the \
largest supported argument in ",
  StyleBox["Prime", "MR"],
  " on this computer."
}], "Text",
  CellTags->{"Prime::largp", "PrimePi::largp"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Prime[10^20]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Prime::largp", "PrimePi::largp"}],

Cell[BoxData[
    \(Prime::"largp" \(\(:\)\(\ \)\) 
      "Argument \!\(100000000000000000000\) in \
\!\(Prime[100000000000000000000]\) is too large for this implementation."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Prime::largp", "PrimePi::largp"}],

Cell[BoxData[
    \(Prime[100000000000000000000]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Prime::largp", "PrimePi::largp"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PrimePi::nsfmm", "ObjectNameWarningMessages",
  CellTags->"PrimePi::nsfmm"],

Cell[BoxData[
    \(PrimePi::"nsfmm" \(\(:\)\(\ \)\) \(Insufficient\ memory\ to\ allocate\ \
required\ \(\(sieves\)\(.\)\)\)\)], "Message",
  CellTags->"PrimePi::nsfmm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an internal memory allocation error in \
the algorithm used by ",
  StyleBox["PrimePi", "MR"],
  "."
}], "Notes",
  CellTags->"PrimePi::nsfmm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SeedRandom::seed", "ObjectNameWarningMessages",
  CellTags->"SeedRandom::seed"],

Cell[BoxData[
    RowBox[{\(SeedRandom::"seed"\), \(\(:\)\(\ \)\), "Argument", " ", 
      StyleBox["e",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ an\ integer\ or\ a\ \
\(\(string\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SeedRandom::seed"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["SeedRandom", "MR"],
  " is not an integer or a string."
}], "Notes",
  CellTags->"SeedRandom::seed"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SeedRandom::seed"],

Cell["\<\
An error occurs in this example because the argument is an inexact \
number.\
\>", "Text",
  CellTags->"SeedRandom::seed"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SeedRandom[Random[]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SeedRandom::seed"],

Cell[BoxData[
    \(SeedRandom::"seed" \(\(:\)\(\ \)\) 
      "Argument \!\(0.7360230624547145`\) in \
\!\(SeedRandom[0.7360230624547145`]\) should be an integer or a string."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"SeedRandom::seed"],

Cell[BoxData[
    \(SeedRandom[0.7360230624547145`]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SeedRandom::seed"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["SeedRandom", "MR"],
  "."
}], "Text",
  CellTags->"SeedRandom::seed"],

Cell[BoxData[
    \(SeedRandom[0]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SeedRandom::seed"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DigitCount::base", "ObjectNameWarningMessages",
  CellTags->"DigitCount::base"],

Cell[BoxData[
    \(DigitCount::"base" \(\(:\)\(\ \)\) 
      "The base `1` at position 2 of `2` should be an integer greater than \
1."\)], "Message",
  CellLabel->"From In[41]:=",
  CellTags->"DigitCount::base"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["DigitCount", "MR"],
  " is not an integer or not greater than 1.\n\[FilledSmallSquare] The second \
argument in ",
  StyleBox["DigitCount", "MR"],
  " specifies the base to use in determining the digits of the first \
argument.."
}], "Notes",
  CellTags->"DigitCount::base"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"DigitCount::base"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["DigitCount", "MR"],
  " is less than 1."
}], "Text",
  CellTags->"DigitCount::base"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DigitCount[303100331, 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"DigitCount::base"],

Cell[BoxData[
    \(DigitCount::"base" \(\(:\)\(\ \)\) 
      "The base \!\(0\) at position 2 of \!\(DigitCount[\(\(303100331, 0\)\)]\
\) should be an integer greater than 1."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"DigitCount::base"],

Cell[BoxData[
    \(DigitCount[303100331, 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"DigitCount::base"]
}, Open  ]],

Cell["\<\
This input counts the number of times that the digit 0 occurs in \
the base 10 representation of the number in the first argument.\
\>", "Text",
  CellTags->"DigitCount::base"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DigitCount[303100331, 10, 0]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"DigitCount::base"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"DigitCount::base"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DigitCount::digp", "ObjectNameWarningMessages",
  CellTags->"DigitCount::digp"],

Cell[BoxData[
    \(DigitCount::"digp" \(\(:\)\(\ \)\) 
      "Positive integer or list of nonnegative integers less than the base \
`1` expected at position 3 in `2`."\)], "Message",
  CellLabel->"From In[41]:=",
  CellTags->"DigitCount::digp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third argument in ",
  StyleBox["DigitCount", "MR"],
  " is not an integer or is larger than the second argument.\n\
\[FilledSmallSquare] The third argument in ",
  StyleBox["DigitCount", "MR"],
  " specifies the digit to count, using the base specified in the second \
argument."
}], "Notes",
  CellTags->"DigitCount::digp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"DigitCount::digp"],

Cell[TextData[{
  "An error occurs in this example because the third argument in ",
  StyleBox["DigitCount", "MR"],
  " is greater than the second argument."
}], "Text",
  CellTags->"DigitCount::digp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DigitCount[303100331, 3, 10]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"DigitCount::digp"],

Cell[BoxData[
    \(DigitCount::"digp" \(\(:\)\(\ \)\) 
      "Positive integer or list of nonnegative integers less than the base \!\
\(3\) expected at position 3 in \!\(DigitCount[\(\(303100331, 3, \
10\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"DigitCount::digp"],

Cell[BoxData[
    \(DigitCount[303100331, 3, 10]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"DigitCount::digp"]
}, Open  ]],

Cell["\<\
This input counts the number of times the digit 3 occurs in the \
base 10 representation of the number in the first argument.\
\>", "Text",
  CellTags->"DigitCount::digp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DigitCount[303100331, 10, 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"DigitCount::digp"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"DigitCount::digp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RealDigits::digs", "ObjectNameWarningMessages",
  CellTags->"RealDigits::digs"],

Cell[BoxData[
    \(RealDigits::"digs" \(\(:\)\(\ \)\) 
      "Unable to determine the number of terms in the list of digits."\)], \
"Message",
  CellTags->"RealDigits::digs"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"RealDigits::digs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["RealDigits::period", "ObjectNameWarningMessages",
  CellTags->"RealDigits::period"],

Cell[BoxData[
    \(RealDigits::"period" \(\(:\)\(\ \)\) 
      "`1` has a period of `2` digits in base `3`. Use RealDigits[x, b, n] to \
request n digits."\)], "Message",
  CellLabel->"From In[41]:=",
  CellTags->"RealDigits::period"],

Cell["\<\
\[FilledSmallSquare] Notes about this message have not yet been \
added.\
\>", "Notes",
  CellTags->"RealDigits::period"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PowerMod::badmod", "ObjectNameWarningMessages",
  CellTags->"PowerMod::badmod"],

Cell[BoxData[
    \(PowerMod::"badmod" \(\(:\)\(\ \)\) \(The\ modulus\ `1`\ has\ too\ large\
\ prime\ \(\(factors\)\(.\)\)\)\)], "Message",
  CellTags->"PowerMod::badmod"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"PowerMod::badmod"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PowerMod::root", "ObjectNameWarningMessages",
  CellTags->"PowerMod::root"],

Cell[BoxData[
    \(PowerMod::"root" \(\(:\)\(\ \)\) \(The\ equation\ x^`1`\  = \ `2`\ \
\((mod\ `3`)\)\ has\ no\ integer\ \(\(solutions\)\(.\)\)\)\)], "Message",
  CellTags->"PowerMod::root"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"PowerMod::root"]
}, Open  ]],

Cell[CellGroupData[{

Cell["PowerModList::arg1", "ObjectNameWarningMessages",
  CellTags->"PowerModList::arg1"],

Cell[BoxData[
    \(PowerModList::"arg1" \(\(:\)\(\ \)\) \(The\ first\ argument\ `1`\ of\ \
PowerModList\ is\ not\ an\ \(\(integer\)\(.\)\)\)\)], "Message",
  CellTags->"PowerModList::arg1"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["PowerModList", "MR"],
  " does not have the indicated form."
}], "Notes",
  CellTags->"PowerModList::arg1"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"PowerModList::arg1"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["PowerModList", "MR"],
  " is a list containing an integer rather than just an integer."
}], "Text",
  CellTags->"PowerModList::arg1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerModList[{55}, 2/9, 100]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"PowerModList::arg1"],

Cell[BoxData[
    \(PowerModList::"arg1" \(\(:\)\(\ \)\) 
      "The first argument \!\({55}\) of PowerModList is not an integer."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"PowerModList::arg1"],

Cell[BoxData[
    \(PowerModList[{55}, 2\/9, 100]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"PowerModList::arg1"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["PowerModList", "MR"],
  "."
}], "Text",
  CellTags->"PowerModList::arg1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerModList[55, 2/9, 100]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"PowerModList::arg1"],

Cell[BoxData[
    \({5, 25, 45, 65, 85}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"PowerModList::arg1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PowerModList::arg2", "ObjectNameWarningMessages",
  CellTags->"PowerModList::arg2"],

Cell[BoxData[
    \(PowerModList::"arg2" \(\(:\)\(\ \)\) \(The\ second\ argument\ `1`\ of\ \
PowerModList\ is\ not\ \(\(rational\)\(.\)\)\)\)], "Message",
  CellTags->"PowerModList::arg2"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["PowerModList", "MR"],
  " does not have the indicated form."
}], "Notes",
  CellTags->"PowerModList::arg2"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"PowerModList::arg2"],

Cell["\<\
An error occurs in this example because the second argument in p is \
not a rational number.\
\>", "Text",
  CellTags->"PowerModList::arg2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerModList[55, Sqrt[3], 100]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"PowerModList::arg2"],

Cell[BoxData[
    \(PowerModList::"arg2" \(\(:\)\(\ \)\) 
      "The second argument \!\(\@3\) of PowerModList is not rational."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"PowerModList::arg2"],

Cell[BoxData[
    \(PowerModList[55, \@3, 100]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"PowerModList::arg2"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["PowerModList", "MR"],
  "."
}], "Text",
  CellTags->"PowerModList::arg2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerModList[55, 2/9, 100]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"PowerModList::arg2"],

Cell[BoxData[
    \({5, 25, 45, 65, 85}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"PowerModList::arg2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PowerModList::arg3", "ObjectNameWarningMessages",
  CellTags->"PowerModList::arg3"],

Cell[BoxData[
    RowBox[{\(PowerModList::"arg3"\), \(\(:\)\(\ \)\), "The", " ", "third", 
      " ", "argument", " ", 
      StyleBox["expr",
        "TI"], " ", "of", " ", "PowerModList", " ", "is", " ", "not", " ", 
      "a", " ", "positive", " ", \(\(integer\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"PowerModList::arg3"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third argument in ",
  StyleBox["PowerModList", "MR"],
  " does not have the indicated form."
}], "Notes",
  CellTags->"PowerModList::arg3"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"PowerModList::arg3"],

Cell[TextData[{
  "An error occurs in this example because the third argument in ",
  StyleBox["PowerModList", "MR"],
  " is a list containing a positive integer rather than a positive integer."
}], "Text",
  CellTags->"PowerModList::arg3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerModList[55, 2/9, {100}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"PowerModList::arg3"],

Cell[BoxData[
    \(PowerModList::"arg3" \(\(:\)\(\ \)\) 
      "The third argument \!\({100}\) of PowerModList is not a positive \
integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"PowerModList::arg3"],

Cell[BoxData[
    \(PowerModList[55, 2\/9, {100}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"PowerModList::arg3"],

Cell[BoxData[
    \(PowerModList::"arg3" \(\(:\)\(\ \)\) "\<The third argument {100} of \
PowerModList is not a positive integer.\>"\)], "Message",
  CellLabel->"From In[114]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"PowerModList::arg3"],

Cell[BoxData[
    \(PowerModList[55, 2\/9, {100}]\)], "Output",
  CellLabel->"Out[114]=",
  CellTags->"PowerModList::arg3"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["PowerModList", "MR"],
  "."
}], "Text",
  CellTags->"PowerModList::arg3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerModList[55, 2/9, 100]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"PowerModList::arg3"],

Cell[BoxData[
    \({5, 25, 45, 65, 85}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"PowerModList::arg3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PowerModList::nargs", "ObjectNameWarningMessages",
  CellTags->"PowerModList::nargs"],

Cell[BoxData[
    RowBox[{\(PowerModList::"nargs" \(\(:\)\(\ \)\) \(PowerModList\ requires\ \
3\ arguments\)\), ",", " ", 
      RowBox[{
        StyleBox["n",
          "TI"], " ", "were", " ", \(\(given\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"PowerModList::nargs"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["PowerModList", "MR"],
  " is called with an incorrect number of arguments."
}], "Notes",
  CellTags->"PowerModList::nargs"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"PowerModList::nargs"],

Cell["\<\
An error occurs in this example because p expects three \
arguments.\
\>", "Text",
  CellTags->"PowerModList::nargs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerModList[55, 2/9]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"PowerModList::nargs"],

Cell[BoxData[
    \(PowerModList::"nargs" \(\(:\)\(\ \)\) 
      "PowerModList requires 3 arguments, \!\(2\) were given."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"PowerModList::nargs"],

Cell[BoxData[
    \(PowerModList[55, 2\/9]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"PowerModList::nargs"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["PowerModList", "MR"],
  "."
}], "Text",
  CellTags->"PowerModList::nargs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PowerModList[55, 2/9, 100]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"PowerModList::nargs"],

Cell[BoxData[
    \({5, 25, 45, 65, 85}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"PowerModList::nargs"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 975}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{641, 517},
WindowMargins->{{Automatic, 53}, {Automatic, 77}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Power::infy"->{
    Cell[1840, 57, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Power::infy"],
    Cell[1918, 60, 215, 5, 21, "Message",
      CellTags->"Power::infy"],
    Cell[2136, 67, 178, 5, 24, "Notes",
      CellTags->"Power::infy"],
    Cell[2339, 76, 61, 1, 38, "ExampleSection",
      CellTags->"Power::infy"],
    Cell[2403, 79, 101, 1, 24, "Text",
      CellTags->"Power::infy"],
    Cell[2529, 84, 87, 3, 26, "Input",
      CellTags->"Power::infy"],
    Cell[2619, 89, 173, 4, 36, "Message",
      CellTags->"Power::infy"],
    Cell[2795, 95, 100, 3, 21, "Output",
      CellTags->"Power::infy"],
    Cell[2910, 101, 121, 4, 24, "Text",
      CellTags->"Power::infy"],
    Cell[3056, 109, 126, 3, 26, "Input",
      CellTags->"Power::infy"],
    Cell[3185, 114, 175, 4, 36, "Message",
      CellTags->"Power::infy"],
    Cell[3363, 120, 213, 5, 41, "Message",
      CellTags->"Power::infy"],
    Cell[3579, 127, 124, 3, 41, "Output",
      CellTags->"Power::infy"],
    Cell[3718, 133, 178, 4, 40, "Text",
      CellTags->"Power::infy"],
    Cell[3921, 141, 129, 3, 26, "Input",
      CellTags->"Power::infy"],
    Cell[4053, 146, 103, 3, 21, "Output",
      CellTags->"Power::infy"]},
  "Random::randn"->{
    Cell[4217, 156, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Random::randn"],
    Cell[4299, 159, 209, 5, 37, "Message",
      CellTags->"Random::randn"],
    Cell[4511, 166, 200, 5, 24, "Notes",
      CellTags->"Random::randn"],
    Cell[4736, 175, 63, 1, 38, "ExampleSection",
      CellTags->"Random::randn"],
    Cell[4802, 178, 203, 6, 24, "Text",
      CellTags->"Random::randn"],
    Cell[5030, 188, 109, 3, 26, "Input",
      CellTags->"Random::randn"],
    Cell[5142, 193, 255, 5, 37, "Message",
      CellTags->"Random::randn"],
    Cell[5400, 200, 108, 3, 21, "Output",
      CellTags->"Random::randn"],
    Cell[5523, 206, 98, 1, 24, "Text",
      CellTags->"Random::randn"],
    Cell[5646, 211, 114, 3, 26, "Input",
      CellTags->"Random::randn"],
    Cell[5763, 216, 88, 3, 21, "Output",
      CellTags->"Random::randn"]},
  "Random::randt"->{
    Cell[5912, 226, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Random::randt"],
    Cell[5994, 229, 434, 11, 37, "Message",
      CellTags->"Random::randt"],
    Cell[6431, 242, 763, 20, 94, "Notes",
      CellTags->"Random::randt"],
    Cell[7219, 266, 63, 1, 38, "ExampleSection",
      CellTags->"Random::randt"],
    Cell[7285, 269, 296, 11, 40, "Text",
      CellTags->"Random::randt"],
    Cell[7606, 284, 102, 3, 26, "Input",
      CellTags->"Random::randt"],
    Cell[7711, 289, 232, 5, 37, "Message",
      CellTags->"Random::randt"],
    Cell[7946, 296, 103, 3, 21, "Output",
      CellTags->"Random::randt"]},
  "FactorInteger::facnf"->{
    Cell[8110, 306, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FactorInteger::facnf"],
    Cell[8206, 309, 216, 5, 21, "Message",
      CellTags->"FactorInteger::facnf"],
    Cell[8425, 316, 446, 9, 84, "Notes",
      CellTags->"FactorInteger::facnf"]},
  "FactorInteger::gfacnf"->{
    Cell[8908, 330, 95, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FactorInteger::gfacnf"],
    Cell[9006, 333, 374, 11, 21, "Message",
      CellTags->"FactorInteger::gfacnf"],
    Cell[9383, 346, 132, 4, 24, "Notes",
      CellTags->"FactorInteger::gfacnf"]},
  "FactorInteger::facn"->{
    Cell[9552, 355, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FactorInteger::facn"],
    Cell[9646, 358, 303, 8, 21, "Message",
      CellTags->"FactorInteger::facn"],
    Cell[9952, 368, 419, 9, 62, "Notes",
      CellTags->"FactorInteger::facn"],
    Cell[10396, 381, 69, 1, 38, "ExampleSection",
      CellTags->"FactorInteger::facn"],
    Cell[10468, 384, 173, 4, 24, "Text",
      CellTags->"FactorInteger::facn"],
    Cell[10666, 392, 113, 3, 26, "Input",
      CellTags->"FactorInteger::facn"],
    Cell[10782, 397, 232, 5, 37, "Message",
      CellTags->"FactorInteger::facn"],
    Cell[11017, 404, 114, 3, 21, "Output",
      CellTags->"FactorInteger::facn"]},
  "$RandomState::rndst"->{
    Cell[11192, 414, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$RandomState::rndst"],
    Cell[11286, 417, 220, 5, 21, "Message",
      CellTags->"$RandomState::rndst"],
    Cell[11509, 424, 567, 14, 78, "Notes",
      CellTags->"$RandomState::rndst"],
    Cell[12101, 442, 69, 1, 38, "ExampleSection",
      CellTags->"$RandomState::rndst"],
    Cell[12173, 445, 236, 7, 40, "Text",
      CellTags->"$RandomState::rndst"],
    Cell[12434, 456, 108, 3, 26, "Input",
      CellTags->"$RandomState::rndst"],
    Cell[12545, 461, 182, 4, 21, "Message",
      CellTags->"$RandomState::rndst"],
    Cell[12730, 467, 94, 3, 21, "Output",
      CellTags->"$RandomState::rndst"]},
  "Chop::tolnn"->{
    Cell[12885, 477, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[13014, 483, 454, 12, 21, "Message",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[13471, 497, 255, 7, 24, "Notes",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[13751, 508, 85, 1, 38, "ExampleSection",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[13839, 511, 153, 4, 24, "Text",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[14017, 519, 164, 3, 26, "Input",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[14184, 524, 226, 5, 37, "Message",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[14413, 531, 157, 3, 21, "Output",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[14585, 537, 142, 5, 24, "Text",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[14752, 546, 158, 3, 26, "Input",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[14913, 551, 133, 3, 21, "Output",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}]},
  "Rationalize::tolnn"->{
    Cell[12885, 477, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[13014, 483, 454, 12, 21, "Message",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[13471, 497, 255, 7, 24, "Notes",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[13751, 508, 85, 1, 38, "ExampleSection",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[13839, 511, 153, 4, 24, "Text",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[14017, 519, 164, 3, 26, "Input",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[14184, 524, 226, 5, 37, "Message",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[14413, 531, 157, 3, 21, "Output",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[14585, 537, 142, 5, 24, "Text",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[14752, 546, 158, 3, 26, "Input",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
    Cell[14913, 551, 133, 3, 21, "Output",
      CellTags->{"Chop::tolnn", "Rationalize::tolnn"}]},
  "ClebschGordan::phy"->{
    Cell[15107, 561, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ClebschGordan::phy"],
    Cell[15199, 564, 201, 4, 21, "Message",
      CellTags->"ClebschGordan::phy"],
    Cell[15403, 570, 259, 7, 40, "Notes",
      CellTags->"ClebschGordan::phy"],
    Cell[15687, 581, 68, 1, 38, "ExampleSection",
      CellTags->"ClebschGordan::phy"],
    Cell[15758, 584, 158, 4, 24, "Text",
      CellTags->"ClebschGordan::phy"],
    Cell[15941, 592, 128, 3, 26, "Input",
      CellTags->"ClebschGordan::phy"],
    Cell[16072, 597, 246, 5, 21, "Message",
      CellTags->"ClebschGordan::phy"],
    Cell[16321, 604, 93, 3, 21, "Output",
      CellTags->"ClebschGordan::phy"],
    Cell[16429, 610, 122, 4, 24, "Text",
      CellTags->"ClebschGordan::phy"],
    Cell[16576, 618, 128, 3, 26, "Input",
      CellTags->"ClebschGordan::phy"],
    Cell[16707, 623, 98, 3, 40, "Output",
      CellTags->"ClebschGordan::phy"]},
  "ClebschGordan::tri"->{
    Cell[16866, 633, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ClebschGordan::tri"],
    Cell[16958, 636, 203, 4, 21, "Message",
      CellTags->"ClebschGordan::tri"],
    Cell[17164, 642, 296, 9, 40, "Notes",
      CellTags->"ClebschGordan::tri"],
    Cell[17485, 655, 68, 1, 38, "ExampleSection",
      CellTags->"ClebschGordan::tri"],
    Cell[17556, 658, 144, 4, 24, "Text",
      CellTags->"ClebschGordan::tri"],
    Cell[17725, 666, 128, 3, 26, "Input",
      CellTags->"ClebschGordan::tri"],
    Cell[17856, 671, 239, 5, 37, "Message",
      CellTags->"ClebschGordan::tri"],
    Cell[18098, 678, 93, 3, 21, "Output",
      CellTags->"ClebschGordan::tri"],
    Cell[18206, 684, 107, 1, 24, "Text",
      CellTags->"ClebschGordan::tri"],
    Cell[18338, 689, 128, 3, 26, "Input",
      CellTags->"ClebschGordan::tri"],
    Cell[18469, 694, 102, 3, 45, "Output",
      CellTags->"ClebschGordan::tri"],
    Cell[18586, 700, 184, 7, 24, "Text",
      CellTags->"ClebschGordan::tri"],
    Cell[18795, 711, 123, 3, 26, "Input",
      CellTags->"ClebschGordan::tri"],
    Cell[18921, 716, 227, 5, 21, "Message",
      CellTags->"ClebschGordan::tri"],
    Cell[19151, 723, 93, 3, 21, "Output",
      CellTags->"ClebschGordan::tri"]},
  "EllipticLog::elld"->{
    Cell[19305, 733, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"EllipticLog::elld"],
    Cell[19395, 736, 324, 6, 37, "Message",
      CellTags->"EllipticLog::elld"],
    Cell[19722, 744, 713, 29, 40, "Notes",
      CellTags->"EllipticLog::elld"]},
  "EllipticLog::ellnp"->{
    Cell[20472, 778, 140, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[20615, 784, 503, 14, 37, "Message",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[21121, 800, 268, 7, 24, "Notes",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[21414, 811, 92, 1, 38, "ExampleSection",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[21509, 814, 236, 5, 40, "Text",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[21770, 823, 134, 3, 26, "Input",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[21907, 828, 248, 5, 37, "Message",
      CellTags->{"EllipticExp::ellnp", "EllipticLog::ellnp"}],
    Cell[22158, 835, 135, 3, 21, "Output",
      CellTags->{"EllipticExp::ellnp", "EllipticLog::ellnp"}],
    Cell[22308, 841, 160, 5, 24, "Text",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[22493, 850, 139, 3, 26, "Input",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[22635, 855, 163, 3, 21, "Output",
      CellTags->{"EllipticExp::ellnp", "EllipticLog::ellnp"}]},
  "EllipticExp::ellnp"->{
    Cell[20472, 778, 140, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[20615, 784, 503, 14, 37, "Message",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[21121, 800, 268, 7, 24, "Notes",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[21414, 811, 92, 1, 38, "ExampleSection",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[21509, 814, 236, 5, 40, "Text",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[21770, 823, 134, 3, 26, "Input",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[21907, 828, 248, 5, 37, "Message",
      CellTags->{"EllipticExp::ellnp", "EllipticLog::ellnp"}],
    Cell[22158, 835, 135, 3, 21, "Output",
      CellTags->{"EllipticExp::ellnp", "EllipticLog::ellnp"}],
    Cell[22308, 841, 160, 5, 24, "Text",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[22493, 850, 139, 3, 26, "Input",
      CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
    Cell[22635, 855, 163, 3, 21, "Output",
      CellTags->{"EllipticExp::ellnp", "EllipticLog::ellnp"}]},
  "EllipticReducedHalfPeriods::nind"->{
    Cell[22859, 865, 117, 1, 31, "ObjectNameWarningMessages",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[22979, 868, 274, 6, 21, "Message",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[23256, 876, 735, 24, 62, "Notes",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[24016, 904, 82, 1, 38, "ExampleSection",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[24101, 907, 209, 5, 24, "Text",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[24335, 916, 143, 3, 26, "Input",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[24481, 921, 223, 4, 37, "Message",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[24707, 927, 145, 3, 21, "Output",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[24867, 933, 165, 5, 24, "Text",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[25057, 942, 152, 3, 26, "Input",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[25212, 947, 144, 3, 21, "Output",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[25371, 953, 217, 6, 40, "Text",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[25613, 963, 138, 3, 26, "Input",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[25754, 968, 222, 4, 37, "Message",
      CellTags->"EllipticReducedHalfPeriods::nind"],
    Cell[25979, 974, 139, 3, 21, "Output",
      CellTags->"EllipticReducedHalfPeriods::nind"]},
  "EllipticTheta::etype"->{
    Cell[26179, 984, 158, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[26340, 990, 500, 12, 21, "Message",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[26843, 1004, 188, 4, 24, "Notes",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[27056, 1012, 101, 1, 38, "ExampleSection",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[27160, 1015, 214, 4, 40, "Text",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[27399, 1023, 152, 3, 26, "Input",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[27554, 1028, 243, 5, 37, "Message",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[27800, 1035, 156, 3, 21, "Output",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[27971, 1041, 179, 5, 24, "Text",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[28175, 1050, 150, 3, 26, "Input",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[28328, 1055, 144, 3, 21, "Output",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}]},
  "EllipticThetaPrime::etype"->{
    Cell[26179, 984, 158, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[26340, 990, 500, 12, 21, "Message",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[26843, 1004, 188, 4, 24, "Notes",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[27056, 1012, 101, 1, 38, "ExampleSection",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[27160, 1015, 214, 4, 40, "Text",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[27399, 1023, 152, 3, 26, "Input",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[27554, 1028, 243, 5, 37, "Message",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[27800, 1035, 156, 3, 21, "Output",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[27971, 1041, 179, 5, 24, "Text",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[28175, 1050, 150, 3, 26, "Input",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
    Cell[28328, 1055, 144, 3, 21, "Output",
      CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}]},
  "ExtendedGCD::egcd"->{
    Cell[28533, 1065, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ExtendedGCD::egcd"],
    Cell[28623, 1068, 310, 9, 21, "Message",
      CellTags->"ExtendedGCD::egcd"],
    Cell[28936, 1079, 176, 5, 24, "Notes",
      CellTags->"ExtendedGCD::egcd"],
    Cell[29137, 1088, 67, 1, 38, "ExampleSection",
      CellTags->"ExtendedGCD::egcd"],
    Cell[29207, 1091, 154, 4, 24, "Text",
      CellTags->"ExtendedGCD::egcd"],
    Cell[29386, 1099, 112, 3, 26, "Input",
      CellTags->"ExtendedGCD::egcd"],
    Cell[29501, 1104, 213, 5, 21, "Message",
      CellTags->"ExtendedGCD::egcd"],
    Cell[29717, 1111, 113, 3, 21, "Output",
      CellTags->"ExtendedGCD::egcd"],
    Cell[29845, 1117, 141, 5, 24, "Text",
      CellTags->"ExtendedGCD::egcd"],
    Cell[30011, 1126, 108, 3, 26, "Input",
      CellTags->"ExtendedGCD::egcd"],
    Cell[30122, 1131, 107, 3, 21, "Output",
      CellTags->"ExtendedGCD::egcd"]},
  "ExtendedGCD::egcdz"->{
    Cell[30290, 1141, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ExtendedGCD::egcdz"],
    Cell[30382, 1144, 178, 3, 21, "Message",
      CellTags->"ExtendedGCD::egcdz"],
    Cell[30563, 1149, 129, 4, 24, "Notes",
      CellTags->"ExtendedGCD::egcdz"]},
  "FactorInteger::faccp"->{
    Cell[30729, 1158, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FactorInteger::faccp"],
    Cell[30825, 1161, 246, 5, 21, "Message",
      CellTags->"FactorInteger::faccp"],
    Cell[31074, 1168, 287, 6, 46, "Notes",
      CellTags->"FactorInteger::faccp"]},
  "GCD::exact"->{
    Cell[31398, 1179, 108, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[31509, 1185, 443, 12, 21, "Message",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[31955, 1199, 395, 9, 62, "Notes",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[32375, 1212, 76, 1, 38, "ExampleSection",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[32454, 1215, 148, 4, 24, "Text",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[32627, 1223, 110, 3, 26, "Input",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[32740, 1228, 209, 5, 21, "Message",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[32952, 1235, 112, 3, 21, "Output",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[33079, 1241, 144, 5, 24, "Text",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[33248, 1250, 112, 3, 26, "Input",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[33363, 1255, 104, 3, 36, "Output",
      CellTags->{"GCD::exact", "LCM::exact"}]},
  "LCM::exact"->{
    Cell[31398, 1179, 108, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[31509, 1185, 443, 12, 21, "Message",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[31955, 1199, 395, 9, 62, "Notes",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[32375, 1212, 76, 1, 38, "ExampleSection",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[32454, 1215, 148, 4, 24, "Text",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[32627, 1223, 110, 3, 26, "Input",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[32740, 1228, 209, 5, 21, "Message",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[32952, 1235, 112, 3, 21, "Output",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[33079, 1241, 144, 5, 24, "Text",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[33248, 1250, 112, 3, 26, "Input",
      CellTags->{"GCD::exact", "LCM::exact"}],
    Cell[33363, 1255, 104, 3, 36, "Output",
      CellTags->{"GCD::exact", "LCM::exact"}]},
  "Gamma::gamc"->{
    Cell[33528, 1265, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Gamma::gamc"],
    Cell[33606, 1268, 319, 7, 21, "Message",
      CellTags->"Gamma::gamc"],
    Cell[33928, 1277, 237, 6, 40, "Notes",
      CellTags->"Gamma::gamc"],
    Cell[34190, 1287, 61, 1, 38, "ExampleSection",
      CellTags->"Gamma::gamc"],
    Cell[34254, 1290, 182, 5, 24, "Text",
      CellTags->"Gamma::gamc"],
    Cell[34461, 1299, 112, 3, 26, "Input",
      CellTags->"Gamma::gamc"],
    Cell[34576, 1304, 289, 6, 39, "Message",
      CellTags->"Gamma::gamc"],
    Cell[34868, 1312, 160, 4, 23, "Output",
      CellTags->"Gamma::gamc"]},
  "General::indet"->{
    Cell[35089, 1323, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::indet"],
    Cell[35173, 1326, 343, 10, 21, "Message",
      CellTags->"General::indet"],
    Cell[35519, 1338, 379, 8, 68, "Notes",
      CellTags->"General::indet"],
    Cell[35923, 1350, 64, 1, 38, "ExampleSection",
      CellTags->"General::indet"],
    Cell[35990, 1353, 157, 4, 24, "Text",
      CellTags->"General::indet"],
    Cell[36172, 1361, 118, 3, 26, "Input",
      CellTags->"General::indet"],
    Cell[36293, 1366, 176, 4, 36, "Message",
      CellTags->"General::indet"],
    Cell[36472, 1372, 205, 5, 21, "Message",
      CellTags->"General::indet"],
    Cell[36680, 1379, 101, 3, 21, "Output",
      CellTags->"General::indet"]},
  "Prime::intpp"->{
    Cell[36842, 1389, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Prime::intpp"],
    Cell[36922, 1392, 239, 5, 21, "Message",
      CellTags->"Prime::intpp"],
    Cell[37164, 1399, 188, 5, 24, "Notes",
      CellTags->"Prime::intpp"],
    Cell[37377, 1408, 62, 1, 38, "ExampleSection",
      CellTags->"Prime::intpp"],
    Cell[37442, 1411, 133, 4, 24, "Text",
      CellTags->"Prime::intpp"],
    Cell[37600, 1419, 93, 3, 26, "Input",
      CellTags->"Prime::intpp"],
    Cell[37696, 1424, 185, 4, 21, "Message",
      CellTags->"Prime::intpp"],
    Cell[37884, 1430, 94, 3, 21, "Output",
      CellTags->"Prime::intpp"],
    Cell[37993, 1436, 125, 5, 24, "Text",
      CellTags->"Prime::intpp"],
    Cell[38143, 1445, 95, 3, 26, "Input",
      CellTags->"Prime::intpp"],
    Cell[38241, 1450, 90, 3, 21, "Output",
      CellTags->"Prime::intpp"]},
  "JacobiSymbol::jcpo"->{
    Cell[38392, 1460, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"JacobiSymbol::jcpo"],
    Cell[38484, 1463, 376, 10, 37, "Message",
      CellTags->"JacobiSymbol::jcpo"],
    Cell[38863, 1475, 207, 5, 24, "Notes",
      CellTags->"JacobiSymbol::jcpo"],
    Cell[39095, 1484, 68, 1, 38, "ExampleSection",
      CellTags->"JacobiSymbol::jcpo"],
    Cell[39166, 1487, 139, 4, 24, "Text",
      CellTags->"JacobiSymbol::jcpo"],
    Cell[39330, 1495, 109, 3, 26, "Input",
      CellTags->"JacobiSymbol::jcpo"],
    Cell[39442, 1500, 241, 5, 37, "Message",
      CellTags->"JacobiSymbol::jcpo"],
    Cell[39686, 1507, 110, 3, 21, "Output",
      CellTags->"JacobiSymbol::jcpo"],
    Cell[39811, 1513, 137, 5, 24, "Text",
      CellTags->"JacobiSymbol::jcpo"],
    Cell[39973, 1522, 109, 3, 26, "Input",
      CellTags->"JacobiSymbol::jcpo"],
    Cell[40085, 1527, 98, 3, 21, "Output",
      CellTags->"JacobiSymbol::jcpo"]},
  "LegendreP::ltype"->{
    Cell[40244, 1537, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[40379, 1543, 459, 12, 21, "Message",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[40841, 1557, 356, 13, 40, "Notes",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[41222, 1574, 88, 1, 38, "ExampleSection",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[41313, 1577, 279, 7, 40, "Text",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[41617, 1588, 140, 3, 26, "Input",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[41760, 1593, 223, 5, 21, "Message",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[41986, 1600, 141, 3, 21, "Output",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[42142, 1606, 176, 5, 24, "Text",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[42343, 1615, 132, 3, 26, "Input",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[42478, 1620, 130, 3, 21, "Output",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}]},
  "LegendreQ::ltype"->{
    Cell[40244, 1537, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[40379, 1543, 459, 12, 21, "Message",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[40841, 1557, 356, 13, 40, "Notes",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[41222, 1574, 88, 1, 38, "ExampleSection",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[41313, 1577, 279, 7, 40, "Text",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[41617, 1588, 140, 3, 26, "Input",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[41760, 1593, 223, 5, 21, "Message",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[41986, 1600, 141, 3, 21, "Output",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[42142, 1606, 176, 5, 24, "Text",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[42343, 1615, 132, 3, 26, "Input",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
    Cell[42478, 1620, 130, 3, 21, "Output",
      CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}]},
  "MathieuCharacteristicA::nnord"->{
    Cell[42669, 1630, 187, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "MathieuCharacteristicA::nnord", "MathieuCharacteristicB::nnord"}],
    Cell[42859, 1637, 449, 13, 21, "Message",
      CellTags->{
      "MathieuCharacteristicA::nnord", "MathieuCharacteristicB::nnord"}],
    Cell[43311, 1652, 247, 7, 24, "Notes",
      CellTags->{
      "MathieuCharacteristicA::nnord", "MathieuCharacteristicB::nnord"}]},
  "MathieuCharacteristicB::nnord"->{
    Cell[42669, 1630, 187, 5, 51, "ObjectNameWarningMessages",
      CellTags->{
      "MathieuCharacteristicA::nnord", "MathieuCharacteristicB::nnord"}],
    Cell[42859, 1637, 449, 13, 21, "Message",
      CellTags->{
      "MathieuCharacteristicA::nnord", "MathieuCharacteristicB::nnord"}],
    Cell[43311, 1652, 247, 7, 24, "Notes",
      CellTags->{
      "MathieuCharacteristicA::nnord", "MathieuCharacteristicB::nnord"}]},
  "MathieuCharacteristicB::zord"->{
    Cell[43595, 1664, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"MathieuCharacteristicB::zord"],
    Cell[43707, 1667, 207, 3, 37, "Message",
      CellTags->"MathieuCharacteristicB::zord"],
    Cell[43917, 1672, 194, 5, 24, "Notes",
      CellTags->"MathieuCharacteristicB::zord"],
    Cell[44136, 1681, 78, 1, 38, "ExampleSection",
      CellTags->"MathieuCharacteristicB::zord"],
    Cell[44217, 1684, 137, 4, 24, "Text",
      CellTags->"MathieuCharacteristicB::zord"],
    Cell[44379, 1692, 132, 3, 26, "Input",
      CellTags->"MathieuCharacteristicB::zord"],
    Cell[44514, 1697, 213, 4, 37, "Message",
      CellTags->"MathieuCharacteristicB::zord"],
    Cell[44730, 1703, 134, 3, 21, "Output",
      CellTags->"MathieuCharacteristicB::zord"],
    Cell[44879, 1709, 157, 5, 24, "Text",
      CellTags->"MathieuCharacteristicB::zord"],
    Cell[45061, 1718, 132, 3, 26, "Input",
      CellTags->"MathieuCharacteristicB::zord"],
    Cell[45196, 1723, 122, 3, 21, "Output",
      CellTags->"MathieuCharacteristicB::zord"]},
  "MeijerG::hdiv"->{
    Cell[45379, 1733, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"MeijerG::hdiv"],
    Cell[45461, 1736, 237, 5, 21, "Message",
      CellTags->"MeijerG::hdiv"],
    Cell[45701, 1743, 165, 5, 24, "Notes",
      CellTags->"MeijerG::hdiv"],
    Cell[45891, 1752, 63, 1, 38, "ExampleSection",
      CellTags->"MeijerG::hdiv"],
    Cell[45957, 1755, 200, 5, 40, "Text",
      CellTags->"MeijerG::hdiv"],
    Cell[46182, 1764, 121, 3, 26, "Input",
      CellTags->"MeijerG::hdiv"],
    Cell[46306, 1769, 293, 6, 37, "Message",
      CellTags->"MeijerG::hdiv"],
    Cell[46602, 1777, 134, 3, 21, "Output",
      CellTags->"MeijerG::hdiv"],
    Cell[46751, 1783, 127, 5, 24, "Text",
      CellTags->"MeijerG::hdiv"],
    Cell[46903, 1792, 124, 3, 26, "Input",
      CellTags->"MeijerG::hdiv"],
    Cell[47030, 1797, 167, 4, 41, "Output",
      CellTags->"MeijerG::hdiv"]},
  "MeijerG::rarg"->{
    Cell[47258, 1808, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"MeijerG::rarg"],
    Cell[47340, 1811, 376, 7, 37, "Message",
      CellTags->"MeijerG::rarg"],
    Cell[47719, 1820, 341, 9, 46, "Notes",
      CellTags->"MeijerG::rarg"],
    Cell[48085, 1833, 63, 1, 38, "ExampleSection",
      CellTags->"MeijerG::rarg"],
    Cell[48151, 1836, 242, 6, 40, "Text",
      CellTags->"MeijerG::rarg"],
    Cell[48418, 1846, 127, 3, 26, "Input",
      CellTags->"MeijerG::rarg"],
    Cell[48548, 1851, 368, 7, 53, "Message",
      CellTags->"MeijerG::rarg"],
    Cell[48919, 1860, 141, 3, 21, "Output",
      CellTags->"MeijerG::rarg"],
    Cell[49075, 1866, 127, 5, 24, "Text",
      CellTags->"MeijerG::rarg"],
    Cell[49227, 1875, 127, 3, 26, "Input",
      CellTags->"MeijerG::rarg"],
    Cell[49357, 1880, 156, 4, 21, "Output",
      CellTags->"MeijerG::rarg"]},
  "Mod::divz"->{
    Cell[49574, 1891, 114, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[49691, 1897, 426, 12, 21, "Message",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[50120, 1911, 148, 4, 24, "Notes",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[50293, 1919, 79, 1, 38, "ExampleSection",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[50375, 1922, 204, 6, 24, "Text",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[50604, 1932, 111, 3, 26, "Input",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[50718, 1937, 210, 5, 21, "Message",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[50931, 1944, 112, 3, 21, "Output",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[51058, 1950, 139, 5, 24, "Text",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[51222, 1959, 111, 3, 26, "Input",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[51336, 1964, 104, 3, 21, "Output",
      CellTags->{"Mod::divz", "Quotient::divz"}]},
  "Quotient::divz"->{
    Cell[49574, 1891, 114, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[49691, 1897, 426, 12, 21, "Message",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[50120, 1911, 148, 4, 24, "Notes",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[50293, 1919, 79, 1, 38, "ExampleSection",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[50375, 1922, 204, 6, 24, "Text",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[50604, 1932, 111, 3, 26, "Input",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[50718, 1937, 210, 5, 21, "Message",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[50931, 1944, 112, 3, 21, "Output",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[51058, 1950, 139, 5, 24, "Text",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[51222, 1959, 111, 3, 26, "Input",
      CellTags->{"Mod::divz", "Quotient::divz"}],
    Cell[51336, 1964, 104, 3, 21, "Output",
      CellTags->{"Mod::divz", "Quotient::divz"}]},
  "PowerMod::divz"->{
    Cell[51501, 1974, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PowerMod::divz"],
    Cell[51585, 1977, 253, 6, 21, "Message",
      CellTags->"PowerMod::divz"],
    Cell[51841, 1985, 166, 5, 24, "Notes",
      CellTags->"PowerMod::divz"],
    Cell[52032, 1994, 64, 1, 38, "ExampleSection",
      CellTags->"PowerMod::divz"],
    Cell[52099, 1997, 169, 5, 24, "Text",
      CellTags->"PowerMod::divz"],
    Cell[52293, 2006, 104, 3, 26, "Input",
      CellTags->"PowerMod::divz"],
    Cell[52400, 2011, 207, 5, 21, "Message",
      CellTags->"PowerMod::divz"],
    Cell[52610, 2018, 105, 3, 21, "Output",
      CellTags->"PowerMod::divz"],
    Cell[52730, 2024, 129, 5, 24, "Text",
      CellTags->"PowerMod::divz"],
    Cell[52884, 2033, 104, 3, 26, "Input",
      CellTags->"PowerMod::divz"],
    Cell[52991, 2038, 89, 3, 21, "Output",
      CellTags->"PowerMod::divz"]},
  "PowerMod::ninv"->{
    Cell[53141, 2048, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PowerMod::ninv"],
    Cell[53225, 2051, 270, 7, 21, "Message",
      CellTags->"PowerMod::ninv"],
    Cell[53498, 2060, 136, 4, 24, "Notes",
      CellTags->"PowerMod::ninv"],
    Cell[53659, 2068, 64, 1, 38, "ExampleSection",
      CellTags->"PowerMod::ninv"],
    Cell[53726, 2071, 124, 4, 24, "Text",
      CellTags->"PowerMod::ninv"],
    Cell[53875, 2079, 110, 3, 26, "Input",
      CellTags->"PowerMod::ninv"],
    Cell[53988, 2084, 178, 4, 21, "Message",
      CellTags->"PowerMod::ninv"],
    Cell[54169, 2090, 111, 3, 21, "Output",
      CellTags->"PowerMod::ninv"]},
  "PowerMod::pmod"->{
    Cell[54341, 2100, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PowerMod::pmod"],
    Cell[54425, 2103, 371, 8, 21, "Message",
      CellTags->"PowerMod::pmod"],
    Cell[54799, 2113, 314, 8, 46, "Notes",
      CellTags->"PowerMod::pmod"],
    Cell[55138, 2125, 64, 1, 38, "ExampleSection",
      CellTags->"PowerMod::pmod"],
    Cell[55205, 2128, 136, 4, 24, "Text",
      CellTags->"PowerMod::pmod"],
    Cell[55366, 2136, 106, 3, 26, "Input",
      CellTags->"PowerMod::pmod"],
    Cell[55475, 2141, 232, 5, 37, "Message",
      CellTags->"PowerMod::pmod"],
    Cell[55710, 2148, 107, 3, 21, "Output",
      CellTags->"PowerMod::pmod"],
    Cell[55832, 2154, 129, 5, 24, "Text",
      CellTags->"PowerMod::pmod"],
    Cell[55986, 2163, 104, 3, 26, "Input",
      CellTags->"PowerMod::pmod"],
    Cell[56093, 2168, 89, 3, 21, "Output",
      CellTags->"PowerMod::pmod"]},
  "Prime::largp"->{
    Cell[56243, 2178, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[56366, 2184, 454, 12, 21, "Message",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[56823, 2198, 377, 11, 46, "Notes",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[57225, 2213, 82, 1, 38, "ExampleSection",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[57310, 2216, 235, 6, 40, "Text",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[57570, 2226, 117, 3, 26, "Input",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[57690, 2231, 268, 6, 37, "Message",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[57961, 2239, 134, 3, 21, "Output",
      CellTags->{"Prime::largp", "PrimePi::largp"}]},
  "PrimePi::largp"->{
    Cell[56243, 2178, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[56366, 2184, 454, 12, 21, "Message",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[56823, 2198, 377, 11, 46, "Notes",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[57225, 2213, 82, 1, 38, "ExampleSection",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[57310, 2216, 235, 6, 40, "Text",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[57570, 2226, 117, 3, 26, "Input",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[57690, 2231, 268, 6, 37, "Message",
      CellTags->{"Prime::largp", "PrimePi::largp"}],
    Cell[57961, 2239, 134, 3, 21, "Output",
      CellTags->{"Prime::largp", "PrimePi::largp"}]},
  "PrimePi::nsfmm"->{
    Cell[58156, 2249, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PrimePi::nsfmm"],
    Cell[58240, 2252, 169, 3, 21, "Message",
      CellTags->"PrimePi::nsfmm"],
    Cell[58412, 2257, 196, 6, 24, "Notes",
      CellTags->"PrimePi::nsfmm"]},
  "SeedRandom::seed"->{
    Cell[58645, 2268, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SeedRandom::seed"],
    Cell[58733, 2271, 341, 9, 21, "Message",
      CellTags->"SeedRandom::seed"],
    Cell[59077, 2282, 186, 5, 24, "Notes",
      CellTags->"SeedRandom::seed"],
    Cell[59288, 2291, 66, 1, 38, "ExampleSection",
      CellTags->"SeedRandom::seed"],
    Cell[59357, 2294, 132, 4, 24, "Text",
      CellTags->"SeedRandom::seed"],
    Cell[59514, 2302, 109, 3, 26, "Input",
      CellTags->"SeedRandom::seed"],
    Cell[59626, 2307, 253, 6, 37, "Message",
      CellTags->"SeedRandom::seed"],
    Cell[59882, 2315, 121, 3, 21, "Output",
      CellTags->"SeedRandom::seed"],
    Cell[60018, 2321, 134, 5, 24, "Text",
      CellTags->"SeedRandom::seed"],
    Cell[60155, 2328, 102, 3, 26, "Input",
      CellTags->"SeedRandom::seed"]},
  "DigitCount::base"->{
    Cell[60306, 2337, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DigitCount::base"],
    Cell[60394, 2340, 213, 5, 37, "Message",
      CellTags->"DigitCount::base"],
    Cell[60610, 2347, 367, 9, 46, "Notes",
      CellTags->"DigitCount::base"],
    Cell[61002, 2360, 66, 1, 38, "ExampleSection",
      CellTags->"DigitCount::base"],
    Cell[61071, 2363, 181, 5, 24, "Text",
      CellTags->"DigitCount::base"],
    Cell[61277, 2372, 113, 3, 26, "Input",
      CellTags->"DigitCount::base"],
    Cell[61393, 2377, 251, 5, 37, "Message",
      CellTags->"DigitCount::base"],
    Cell[61647, 2384, 114, 3, 21, "Output",
      CellTags->"DigitCount::base"],
    Cell[61776, 2390, 186, 4, 40, "Text",
      CellTags->"DigitCount::base"],
    Cell[61987, 2398, 117, 3, 26, "Input",
      CellTags->"DigitCount::base"],
    Cell[62107, 2403, 91, 3, 21, "Output",
      CellTags->"DigitCount::base"]},
  "DigitCount::digp"->{
    Cell[62259, 2413, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DigitCount::digp"],
    Cell[62347, 2416, 245, 5, 53, "Message",
      CellTags->"DigitCount::digp"],
    Cell[62595, 2423, 384, 9, 46, "Notes",
      CellTags->"DigitCount::digp"],
    Cell[63004, 2436, 66, 1, 38, "ExampleSection",
      CellTags->"DigitCount::digp"],
    Cell[63073, 2439, 201, 5, 24, "Text",
      CellTags->"DigitCount::digp"],
    Cell[63299, 2448, 117, 3, 26, "Input",
      CellTags->"DigitCount::digp"],
    Cell[63419, 2453, 289, 6, 53, "Message",
      CellTags->"DigitCount::digp"],
    Cell[63711, 2461, 118, 3, 21, "Output",
      CellTags->"DigitCount::digp"],
    Cell[63844, 2467, 181, 4, 40, "Text",
      CellTags->"DigitCount::digp"],
    Cell[64050, 2475, 117, 3, 26, "Input",
      CellTags->"DigitCount::digp"],
    Cell[64170, 2480, 91, 3, 21, "Output",
      CellTags->"DigitCount::digp"]},
  "RealDigits::digs"->{
    Cell[64322, 2490, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RealDigits::digs"],
    Cell[64410, 2493, 175, 4, 37, "Message",
      CellTags->"RealDigits::digs"],
    Cell[64588, 2499, 196, 6, 24, "Notes",
      CellTags->"RealDigits::digs"]},
  "RealDigits::period"->{
    Cell[64821, 2510, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RealDigits::period"],
    Cell[64913, 2513, 235, 5, 37, "Message",
      CellTags->"RealDigits::period"],
    Cell[65151, 2520, 131, 4, 24, "Notes",
      CellTags->"RealDigits::period"]},
  "PowerMod::badmod"->{
    Cell[65319, 2529, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PowerMod::badmod"],
    Cell[65407, 2532, 171, 3, 21, "Message",
      CellTags->"PowerMod::badmod"],
    Cell[65581, 2537, 127, 4, 24, "Notes",
      CellTags->"PowerMod::badmod"]},
  "PowerMod::root"->{
    Cell[65745, 2546, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PowerMod::root"],
    Cell[65829, 2549, 192, 3, 21, "Message",
      CellTags->"PowerMod::root"],
    Cell[66024, 2554, 125, 4, 24, "Notes",
      CellTags->"PowerMod::root"]},
  "PowerModList::arg1"->{
    Cell[66186, 2563, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PowerModList::arg1"],
    Cell[66278, 2566, 190, 3, 21, "Message",
      CellTags->"PowerModList::arg1"],
    Cell[66471, 2571, 199, 5, 24, "Notes",
      CellTags->"PowerModList::arg1"],
    Cell[66695, 2580, 68, 1, 38, "ExampleSection",
      CellTags->"PowerModList::arg1"],
    Cell[66766, 2583, 229, 5, 40, "Text",
      CellTags->"PowerModList::arg1"],
    Cell[67020, 2592, 119, 3, 26, "Input",
      CellTags->"PowerModList::arg1"],
    Cell[67142, 2597, 210, 5, 37, "Message",
      CellTags->"PowerModList::arg1"],
    Cell[67355, 2604, 121, 3, 36, "Output",
      CellTags->"PowerModList::arg1"],
    Cell[67491, 2610, 133, 5, 24, "Text",
      CellTags->"PowerModList::arg1"],
    Cell[67649, 2619, 117, 3, 26, "Input",
      CellTags->"PowerModList::arg1"],
    Cell[67769, 2624, 111, 3, 21, "Output",
      CellTags->"PowerModList::arg1"]},
  "PowerModList::arg2"->{
    Cell[67941, 2634, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PowerModList::arg2"],
    Cell[68033, 2637, 188, 3, 21, "Message",
      CellTags->"PowerModList::arg2"],
    Cell[68224, 2642, 200, 5, 24, "Notes",
      CellTags->"PowerModList::arg2"],
    Cell[68449, 2651, 68, 1, 38, "ExampleSection",
      CellTags->"PowerModList::arg2"],
    Cell[68520, 2654, 150, 4, 24, "Text",
      CellTags->"PowerModList::arg2"],
    Cell[68695, 2662, 121, 3, 26, "Input",
      CellTags->"PowerModList::arg2"],
    Cell[68819, 2667, 208, 5, 40, "Message",
      CellTags->"PowerModList::arg2"],
    Cell[69030, 2674, 118, 3, 26, "Output",
      CellTags->"PowerModList::arg2"],
    Cell[69163, 2680, 133, 5, 24, "Text",
      CellTags->"PowerModList::arg2"],
    Cell[69321, 2689, 117, 3, 26, "Input",
      CellTags->"PowerModList::arg2"],
    Cell[69441, 2694, 111, 3, 21, "Output",
      CellTags->"PowerModList::arg2"]},
  "PowerModList::arg3"->{
    Cell[69613, 2704, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PowerModList::arg3"],
    Cell[69705, 2707, 373, 8, 37, "Message",
      CellTags->"PowerModList::arg3"],
    Cell[70081, 2717, 199, 5, 24, "Notes",
      CellTags->"PowerModList::arg3"],
    Cell[70305, 2726, 68, 1, 38, "ExampleSection",
      CellTags->"PowerModList::arg3"],
    Cell[70376, 2729, 240, 5, 40, "Text",
      CellTags->"PowerModList::arg3"],
    Cell[70641, 2738, 119, 3, 26, "Input",
      CellTags->"PowerModList::arg3"],
    Cell[70763, 2743, 219, 5, 37, "Message",
      CellTags->"PowerModList::arg3"],
    Cell[70985, 2750, 121, 3, 36, "Output",
      CellTags->"PowerModList::arg3"],
    Cell[71109, 2755, 264, 6, 37, "Message",
      CellTags->"PowerModList::arg3"],
    Cell[71376, 2763, 123, 3, 36, "Output",
      CellTags->"PowerModList::arg3"],
    Cell[71514, 2769, 133, 5, 24, "Text",
      CellTags->"PowerModList::arg3"],
    Cell[71672, 2778, 117, 3, 26, "Input",
      CellTags->"PowerModList::arg3"],
    Cell[71792, 2783, 111, 3, 21, "Output",
      CellTags->"PowerModList::arg3"]},
  "PowerModList::nargs"->{
    Cell[71964, 2793, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PowerModList::nargs"],
    Cell[72058, 2796, 317, 8, 21, "Message",
      CellTags->"PowerModList::nargs"],
    Cell[72378, 2806, 193, 5, 24, "Notes",
      CellTags->"PowerModList::nargs"],
    Cell[72596, 2815, 69, 1, 38, "ExampleSection",
      CellTags->"PowerModList::nargs"],
    Cell[72668, 2818, 127, 4, 24, "Text",
      CellTags->"PowerModList::nargs"],
    Cell[72820, 2826, 113, 3, 26, "Input",
      CellTags->"PowerModList::nargs"],
    Cell[72936, 2831, 200, 4, 21, "Message",
      CellTags->"PowerModList::nargs"],
    Cell[73139, 2837, 115, 3, 36, "Output",
      CellTags->"PowerModList::nargs"],
    Cell[73269, 2843, 134, 5, 24, "Text",
      CellTags->"PowerModList::nargs"],
    Cell[73428, 2852, 118, 3, 26, "Input",
      CellTags->"PowerModList::nargs"],
    Cell[73549, 2857, 112, 3, 21, "Output",
      CellTags->"PowerModList::nargs"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Power::infy", 74375, 2883},
  {"Random::randn", 75591, 2916},
  {"Random::randt", 76467, 2939},
  {"FactorInteger::facnf", 77130, 2956},
  {"FactorInteger::gfacnf", 77427, 2963},
  {"FactorInteger::facn", 77726, 2970},
  {"$RandomState::rndst", 78438, 2987},
  {"Chop::tolnn", 79145, 3004},
  {"Rationalize::tolnn", 80283, 3027},
  {"ClebschGordan::phy", 81421, 3050},
  {"ClebschGordan::tri", 82368, 3073},
  {"EllipticLog::elld", 83640, 3104},
  {"EllipticLog::ellnp", 83929, 3111},
  {"EllipticExp::ellnp", 85144, 3134},
  {"EllipticReducedHalfPeriods::nind", 86373, 3157},
  {"EllipticTheta::etype", 87862, 3188},
  {"EllipticThetaPrime::etype", 89193, 3211},
  {"ExtendedGCD::egcd", 90516, 3234},
  {"ExtendedGCD::egcdz", 91465, 3257},
  {"FactorInteger::faccp", 91761, 3264},
  {"GCD::exact", 92053, 3271},
  {"LCM::exact", 93095, 3294},
  {"Gamma::gamc", 94138, 3317},
  {"General::indet", 94792, 3334},
  {"Prime::intpp", 95549, 3353},
  {"JacobiSymbol::jcpo", 96439, 3376},
  {"LegendreP::ltype", 97397, 3399},
  {"LegendreQ::ltype", 98578, 3422},
  {"MathieuCharacteristicA::nnord", 99772, 3445},
  {"MathieuCharacteristicB::nnord", 100238, 3455},
  {"MathieuCharacteristicB::zord", 100703, 3465},
  {"MeijerG::hdiv", 101769, 3488},
  {"MeijerG::rarg", 102669, 3511},
  {"Mod::divz", 103565, 3534},
  {"Quotient::divz", 104644, 3557},
  {"PowerMod::divz", 105723, 3580},
  {"PowerMod::ninv", 106634, 3603},
  {"PowerMod::pmod", 107312, 3620},
  {"Prime::largp", 108221, 3643},
  {"PrimePi::largp", 109046, 3660},
  {"PrimePi::nsfmm", 109871, 3677},
  {"SeedRandom::seed", 110151, 3684},
  {"DigitCount::base", 111006, 3705},
  {"DigitCount::digp", 111941, 3728},
  {"RealDigits::digs", 112876, 3751},
  {"RealDigits::period", 113164, 3758},
  {"PowerMod::badmod", 113456, 3765},
  {"PowerMod::root", 113740, 3772},
  {"PowerModList::arg1", 114022, 3779},
  {"PowerModList::arg2", 114982, 3802},
  {"PowerModList::arg3", 115942, 3825},
  {"PowerModList::nargs", 117070, 3852}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 39, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1840, 57, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Power::infy"],
Cell[1918, 60, 215, 5, 21, "Message",
  CellTags->"Power::infy"],
Cell[2136, 67, 178, 5, 24, "Notes",
  CellTags->"Power::infy"],

Cell[CellGroupData[{
Cell[2339, 76, 61, 1, 38, "ExampleSection",
  CellTags->"Power::infy"],
Cell[2403, 79, 101, 1, 24, "Text",
  CellTags->"Power::infy"],

Cell[CellGroupData[{
Cell[2529, 84, 87, 3, 26, "Input",
  CellTags->"Power::infy"],
Cell[2619, 89, 173, 4, 36, "Message",
  CellTags->"Power::infy"],
Cell[2795, 95, 100, 3, 21, "Output",
  CellTags->"Power::infy"]
}, Open  ]],
Cell[2910, 101, 121, 4, 24, "Text",
  CellTags->"Power::infy"],

Cell[CellGroupData[{
Cell[3056, 109, 126, 3, 26, "Input",
  CellTags->"Power::infy"],
Cell[3185, 114, 175, 4, 36, "Message",
  CellTags->"Power::infy"],
Cell[3363, 120, 213, 5, 41, "Message",
  CellTags->"Power::infy"],
Cell[3579, 127, 124, 3, 41, "Output",
  CellTags->"Power::infy"]
}, Open  ]],
Cell[3718, 133, 178, 4, 40, "Text",
  CellTags->"Power::infy"],

Cell[CellGroupData[{
Cell[3921, 141, 129, 3, 26, "Input",
  CellTags->"Power::infy"],
Cell[4053, 146, 103, 3, 21, "Output",
  CellTags->"Power::infy"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4217, 156, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Random::randn"],
Cell[4299, 159, 209, 5, 37, "Message",
  CellTags->"Random::randn"],
Cell[4511, 166, 200, 5, 24, "Notes",
  CellTags->"Random::randn"],

Cell[CellGroupData[{
Cell[4736, 175, 63, 1, 38, "ExampleSection",
  CellTags->"Random::randn"],
Cell[4802, 178, 203, 6, 24, "Text",
  CellTags->"Random::randn"],

Cell[CellGroupData[{
Cell[5030, 188, 109, 3, 26, "Input",
  CellTags->"Random::randn"],
Cell[5142, 193, 255, 5, 37, "Message",
  CellTags->"Random::randn"],
Cell[5400, 200, 108, 3, 21, "Output",
  CellTags->"Random::randn"]
}, Open  ]],
Cell[5523, 206, 98, 1, 24, "Text",
  CellTags->"Random::randn"],

Cell[CellGroupData[{
Cell[5646, 211, 114, 3, 26, "Input",
  CellTags->"Random::randn"],
Cell[5763, 216, 88, 3, 21, "Output",
  CellTags->"Random::randn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5912, 226, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Random::randt"],
Cell[5994, 229, 434, 11, 37, "Message",
  CellTags->"Random::randt"],
Cell[6431, 242, 763, 20, 94, "Notes",
  CellTags->"Random::randt"],

Cell[CellGroupData[{
Cell[7219, 266, 63, 1, 38, "ExampleSection",
  CellTags->"Random::randt"],
Cell[7285, 269, 296, 11, 40, "Text",
  CellTags->"Random::randt"],

Cell[CellGroupData[{
Cell[7606, 284, 102, 3, 26, "Input",
  CellTags->"Random::randt"],
Cell[7711, 289, 232, 5, 37, "Message",
  CellTags->"Random::randt"],
Cell[7946, 296, 103, 3, 21, "Output",
  CellTags->"Random::randt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8110, 306, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FactorInteger::facnf"],
Cell[8206, 309, 216, 5, 21, "Message",
  CellTags->"FactorInteger::facnf"],
Cell[8425, 316, 446, 9, 84, "Notes",
  CellTags->"FactorInteger::facnf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8908, 330, 95, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FactorInteger::gfacnf"],
Cell[9006, 333, 374, 11, 21, "Message",
  CellTags->"FactorInteger::gfacnf"],
Cell[9383, 346, 132, 4, 24, "Notes",
  CellTags->"FactorInteger::gfacnf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9552, 355, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FactorInteger::facn"],
Cell[9646, 358, 303, 8, 21, "Message",
  CellTags->"FactorInteger::facn"],
Cell[9952, 368, 419, 9, 62, "Notes",
  CellTags->"FactorInteger::facn"],

Cell[CellGroupData[{
Cell[10396, 381, 69, 1, 38, "ExampleSection",
  CellTags->"FactorInteger::facn"],
Cell[10468, 384, 173, 4, 24, "Text",
  CellTags->"FactorInteger::facn"],

Cell[CellGroupData[{
Cell[10666, 392, 113, 3, 26, "Input",
  CellTags->"FactorInteger::facn"],
Cell[10782, 397, 232, 5, 37, "Message",
  CellTags->"FactorInteger::facn"],
Cell[11017, 404, 114, 3, 21, "Output",
  CellTags->"FactorInteger::facn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11192, 414, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$RandomState::rndst"],
Cell[11286, 417, 220, 5, 21, "Message",
  CellTags->"$RandomState::rndst"],
Cell[11509, 424, 567, 14, 78, "Notes",
  CellTags->"$RandomState::rndst"],

Cell[CellGroupData[{
Cell[12101, 442, 69, 1, 38, "ExampleSection",
  CellTags->"$RandomState::rndst"],
Cell[12173, 445, 236, 7, 40, "Text",
  CellTags->"$RandomState::rndst"],

Cell[CellGroupData[{
Cell[12434, 456, 108, 3, 26, "Input",
  CellTags->"$RandomState::rndst"],
Cell[12545, 461, 182, 4, 21, "Message",
  CellTags->"$RandomState::rndst"],
Cell[12730, 467, 94, 3, 21, "Output",
  CellTags->"$RandomState::rndst"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12885, 477, 126, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
Cell[13014, 483, 454, 12, 21, "Message",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
Cell[13471, 497, 255, 7, 24, "Notes",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],

Cell[CellGroupData[{
Cell[13751, 508, 85, 1, 38, "ExampleSection",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
Cell[13839, 511, 153, 4, 24, "Text",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],

Cell[CellGroupData[{
Cell[14017, 519, 164, 3, 26, "Input",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
Cell[14184, 524, 226, 5, 37, "Message",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
Cell[14413, 531, 157, 3, 21, "Output",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}]
}, Open  ]],
Cell[14585, 537, 142, 5, 24, "Text",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],

Cell[CellGroupData[{
Cell[14752, 546, 158, 3, 26, "Input",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}],
Cell[14913, 551, 133, 3, 21, "Output",
  CellTags->{"Chop::tolnn", "Rationalize::tolnn"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15107, 561, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ClebschGordan::phy"],
Cell[15199, 564, 201, 4, 21, "Message",
  CellTags->"ClebschGordan::phy"],
Cell[15403, 570, 259, 7, 40, "Notes",
  CellTags->"ClebschGordan::phy"],

Cell[CellGroupData[{
Cell[15687, 581, 68, 1, 38, "ExampleSection",
  CellTags->"ClebschGordan::phy"],
Cell[15758, 584, 158, 4, 24, "Text",
  CellTags->"ClebschGordan::phy"],

Cell[CellGroupData[{
Cell[15941, 592, 128, 3, 26, "Input",
  CellTags->"ClebschGordan::phy"],
Cell[16072, 597, 246, 5, 21, "Message",
  CellTags->"ClebschGordan::phy"],
Cell[16321, 604, 93, 3, 21, "Output",
  CellTags->"ClebschGordan::phy"]
}, Open  ]],
Cell[16429, 610, 122, 4, 24, "Text",
  CellTags->"ClebschGordan::phy"],

Cell[CellGroupData[{
Cell[16576, 618, 128, 3, 26, "Input",
  CellTags->"ClebschGordan::phy"],
Cell[16707, 623, 98, 3, 40, "Output",
  CellTags->"ClebschGordan::phy"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[16866, 633, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ClebschGordan::tri"],
Cell[16958, 636, 203, 4, 21, "Message",
  CellTags->"ClebschGordan::tri"],
Cell[17164, 642, 296, 9, 40, "Notes",
  CellTags->"ClebschGordan::tri"],

Cell[CellGroupData[{
Cell[17485, 655, 68, 1, 38, "ExampleSection",
  CellTags->"ClebschGordan::tri"],
Cell[17556, 658, 144, 4, 24, "Text",
  CellTags->"ClebschGordan::tri"],

Cell[CellGroupData[{
Cell[17725, 666, 128, 3, 26, "Input",
  CellTags->"ClebschGordan::tri"],
Cell[17856, 671, 239, 5, 37, "Message",
  CellTags->"ClebschGordan::tri"],
Cell[18098, 678, 93, 3, 21, "Output",
  CellTags->"ClebschGordan::tri"]
}, Open  ]],
Cell[18206, 684, 107, 1, 24, "Text",
  CellTags->"ClebschGordan::tri"],

Cell[CellGroupData[{
Cell[18338, 689, 128, 3, 26, "Input",
  CellTags->"ClebschGordan::tri"],
Cell[18469, 694, 102, 3, 45, "Output",
  CellTags->"ClebschGordan::tri"]
}, Open  ]],
Cell[18586, 700, 184, 7, 24, "Text",
  CellTags->"ClebschGordan::tri"],

Cell[CellGroupData[{
Cell[18795, 711, 123, 3, 26, "Input",
  CellTags->"ClebschGordan::tri"],
Cell[18921, 716, 227, 5, 21, "Message",
  CellTags->"ClebschGordan::tri"],
Cell[19151, 723, 93, 3, 21, "Output",
  CellTags->"ClebschGordan::tri"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[19305, 733, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"EllipticLog::elld"],
Cell[19395, 736, 324, 6, 37, "Message",
  CellTags->"EllipticLog::elld"],
Cell[19722, 744, 713, 29, 40, "Notes",
  CellTags->"EllipticLog::elld"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20472, 778, 140, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
Cell[20615, 784, 503, 14, 37, "Message",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
Cell[21121, 800, 268, 7, 24, "Notes",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],

Cell[CellGroupData[{
Cell[21414, 811, 92, 1, 38, "ExampleSection",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
Cell[21509, 814, 236, 5, 40, "Text",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],

Cell[CellGroupData[{
Cell[21770, 823, 134, 3, 26, "Input",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
Cell[21907, 828, 248, 5, 37, "Message",
  CellTags->{"EllipticExp::ellnp", "EllipticLog::ellnp"}],
Cell[22158, 835, 135, 3, 21, "Output",
  CellTags->{"EllipticExp::ellnp", "EllipticLog::ellnp"}]
}, Open  ]],
Cell[22308, 841, 160, 5, 24, "Text",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],

Cell[CellGroupData[{
Cell[22493, 850, 139, 3, 26, "Input",
  CellTags->{"EllipticLog::ellnp", "EllipticExp::ellnp"}],
Cell[22635, 855, 163, 3, 21, "Output",
  CellTags->{"EllipticExp::ellnp", "EllipticLog::ellnp"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22859, 865, 117, 1, 31, "ObjectNameWarningMessages",
  CellTags->"EllipticReducedHalfPeriods::nind"],
Cell[22979, 868, 274, 6, 21, "Message",
  CellTags->"EllipticReducedHalfPeriods::nind"],
Cell[23256, 876, 735, 24, 62, "Notes",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[CellGroupData[{
Cell[24016, 904, 82, 1, 38, "ExampleSection",
  CellTags->"EllipticReducedHalfPeriods::nind"],
Cell[24101, 907, 209, 5, 24, "Text",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[CellGroupData[{
Cell[24335, 916, 143, 3, 26, "Input",
  CellTags->"EllipticReducedHalfPeriods::nind"],
Cell[24481, 921, 223, 4, 37, "Message",
  CellTags->"EllipticReducedHalfPeriods::nind"],
Cell[24707, 927, 145, 3, 21, "Output",
  CellTags->"EllipticReducedHalfPeriods::nind"]
}, Open  ]],
Cell[24867, 933, 165, 5, 24, "Text",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[CellGroupData[{
Cell[25057, 942, 152, 3, 26, "Input",
  CellTags->"EllipticReducedHalfPeriods::nind"],
Cell[25212, 947, 144, 3, 21, "Output",
  CellTags->"EllipticReducedHalfPeriods::nind"]
}, Open  ]],
Cell[25371, 953, 217, 6, 40, "Text",
  CellTags->"EllipticReducedHalfPeriods::nind"],

Cell[CellGroupData[{
Cell[25613, 963, 138, 3, 26, "Input",
  CellTags->"EllipticReducedHalfPeriods::nind"],
Cell[25754, 968, 222, 4, 37, "Message",
  CellTags->"EllipticReducedHalfPeriods::nind"],
Cell[25979, 974, 139, 3, 21, "Output",
  CellTags->"EllipticReducedHalfPeriods::nind"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26179, 984, 158, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
Cell[26340, 990, 500, 12, 21, "Message",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
Cell[26843, 1004, 188, 4, 24, "Notes",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],

Cell[CellGroupData[{
Cell[27056, 1012, 101, 1, 38, "ExampleSection",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
Cell[27160, 1015, 214, 4, 40, "Text",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],

Cell[CellGroupData[{
Cell[27399, 1023, 152, 3, 26, "Input",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
Cell[27554, 1028, 243, 5, 37, "Message",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
Cell[27800, 1035, 156, 3, 21, "Output",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}]
}, Open  ]],
Cell[27971, 1041, 179, 5, 24, "Text",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],

Cell[CellGroupData[{
Cell[28175, 1050, 150, 3, 26, "Input",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}],
Cell[28328, 1055, 144, 3, 21, "Output",
  CellTags->{"EllipticTheta::etype", "EllipticThetaPrime::etype"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[28533, 1065, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ExtendedGCD::egcd"],
Cell[28623, 1068, 310, 9, 21, "Message",
  CellTags->"ExtendedGCD::egcd"],
Cell[28936, 1079, 176, 5, 24, "Notes",
  CellTags->"ExtendedGCD::egcd"],

Cell[CellGroupData[{
Cell[29137, 1088, 67, 1, 38, "ExampleSection",
  CellTags->"ExtendedGCD::egcd"],
Cell[29207, 1091, 154, 4, 24, "Text",
  CellTags->"ExtendedGCD::egcd"],

Cell[CellGroupData[{
Cell[29386, 1099, 112, 3, 26, "Input",
  CellTags->"ExtendedGCD::egcd"],
Cell[29501, 1104, 213, 5, 21, "Message",
  CellTags->"ExtendedGCD::egcd"],
Cell[29717, 1111, 113, 3, 21, "Output",
  CellTags->"ExtendedGCD::egcd"]
}, Open  ]],
Cell[29845, 1117, 141, 5, 24, "Text",
  CellTags->"ExtendedGCD::egcd"],

Cell[CellGroupData[{
Cell[30011, 1126, 108, 3, 26, "Input",
  CellTags->"ExtendedGCD::egcd"],
Cell[30122, 1131, 107, 3, 21, "Output",
  CellTags->"ExtendedGCD::egcd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30290, 1141, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ExtendedGCD::egcdz"],
Cell[30382, 1144, 178, 3, 21, "Message",
  CellTags->"ExtendedGCD::egcdz"],
Cell[30563, 1149, 129, 4, 24, "Notes",
  CellTags->"ExtendedGCD::egcdz"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30729, 1158, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FactorInteger::faccp"],
Cell[30825, 1161, 246, 5, 21, "Message",
  CellTags->"FactorInteger::faccp"],
Cell[31074, 1168, 287, 6, 46, "Notes",
  CellTags->"FactorInteger::faccp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31398, 1179, 108, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"GCD::exact", "LCM::exact"}],
Cell[31509, 1185, 443, 12, 21, "Message",
  CellTags->{"GCD::exact", "LCM::exact"}],
Cell[31955, 1199, 395, 9, 62, "Notes",
  CellTags->{"GCD::exact", "LCM::exact"}],

Cell[CellGroupData[{
Cell[32375, 1212, 76, 1, 38, "ExampleSection",
  CellTags->{"GCD::exact", "LCM::exact"}],
Cell[32454, 1215, 148, 4, 24, "Text",
  CellTags->{"GCD::exact", "LCM::exact"}],

Cell[CellGroupData[{
Cell[32627, 1223, 110, 3, 26, "Input",
  CellTags->{"GCD::exact", "LCM::exact"}],
Cell[32740, 1228, 209, 5, 21, "Message",
  CellTags->{"GCD::exact", "LCM::exact"}],
Cell[32952, 1235, 112, 3, 21, "Output",
  CellTags->{"GCD::exact", "LCM::exact"}]
}, Open  ]],
Cell[33079, 1241, 144, 5, 24, "Text",
  CellTags->{"GCD::exact", "LCM::exact"}],

Cell[CellGroupData[{
Cell[33248, 1250, 112, 3, 26, "Input",
  CellTags->{"GCD::exact", "LCM::exact"}],
Cell[33363, 1255, 104, 3, 36, "Output",
  CellTags->{"GCD::exact", "LCM::exact"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[33528, 1265, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Gamma::gamc"],
Cell[33606, 1268, 319, 7, 21, "Message",
  CellTags->"Gamma::gamc"],
Cell[33928, 1277, 237, 6, 40, "Notes",
  CellTags->"Gamma::gamc"],

Cell[CellGroupData[{
Cell[34190, 1287, 61, 1, 38, "ExampleSection",
  CellTags->"Gamma::gamc"],
Cell[34254, 1290, 182, 5, 24, "Text",
  CellTags->"Gamma::gamc"],

Cell[CellGroupData[{
Cell[34461, 1299, 112, 3, 26, "Input",
  CellTags->"Gamma::gamc"],
Cell[34576, 1304, 289, 6, 39, "Message",
  CellTags->"Gamma::gamc"],
Cell[34868, 1312, 160, 4, 23, "Output",
  CellTags->"Gamma::gamc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35089, 1323, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::indet"],
Cell[35173, 1326, 343, 10, 21, "Message",
  CellTags->"General::indet"],
Cell[35519, 1338, 379, 8, 68, "Notes",
  CellTags->"General::indet"],

Cell[CellGroupData[{
Cell[35923, 1350, 64, 1, 38, "ExampleSection",
  CellTags->"General::indet"],
Cell[35990, 1353, 157, 4, 24, "Text",
  CellTags->"General::indet"],

Cell[CellGroupData[{
Cell[36172, 1361, 118, 3, 26, "Input",
  CellTags->"General::indet"],
Cell[36293, 1366, 176, 4, 36, "Message",
  CellTags->"General::indet"],
Cell[36472, 1372, 205, 5, 21, "Message",
  CellTags->"General::indet"],
Cell[36680, 1379, 101, 3, 21, "Output",
  CellTags->"General::indet"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36842, 1389, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Prime::intpp"],
Cell[36922, 1392, 239, 5, 21, "Message",
  CellTags->"Prime::intpp"],
Cell[37164, 1399, 188, 5, 24, "Notes",
  CellTags->"Prime::intpp"],

Cell[CellGroupData[{
Cell[37377, 1408, 62, 1, 38, "ExampleSection",
  CellTags->"Prime::intpp"],
Cell[37442, 1411, 133, 4, 24, "Text",
  CellTags->"Prime::intpp"],

Cell[CellGroupData[{
Cell[37600, 1419, 93, 3, 26, "Input",
  CellTags->"Prime::intpp"],
Cell[37696, 1424, 185, 4, 21, "Message",
  CellTags->"Prime::intpp"],
Cell[37884, 1430, 94, 3, 21, "Output",
  CellTags->"Prime::intpp"]
}, Open  ]],
Cell[37993, 1436, 125, 5, 24, "Text",
  CellTags->"Prime::intpp"],

Cell[CellGroupData[{
Cell[38143, 1445, 95, 3, 26, "Input",
  CellTags->"Prime::intpp"],
Cell[38241, 1450, 90, 3, 21, "Output",
  CellTags->"Prime::intpp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[38392, 1460, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"JacobiSymbol::jcpo"],
Cell[38484, 1463, 376, 10, 37, "Message",
  CellTags->"JacobiSymbol::jcpo"],
Cell[38863, 1475, 207, 5, 24, "Notes",
  CellTags->"JacobiSymbol::jcpo"],

Cell[CellGroupData[{
Cell[39095, 1484, 68, 1, 38, "ExampleSection",
  CellTags->"JacobiSymbol::jcpo"],
Cell[39166, 1487, 139, 4, 24, "Text",
  CellTags->"JacobiSymbol::jcpo"],

Cell[CellGroupData[{
Cell[39330, 1495, 109, 3, 26, "Input",
  CellTags->"JacobiSymbol::jcpo"],
Cell[39442, 1500, 241, 5, 37, "Message",
  CellTags->"JacobiSymbol::jcpo"],
Cell[39686, 1507, 110, 3, 21, "Output",
  CellTags->"JacobiSymbol::jcpo"]
}, Open  ]],
Cell[39811, 1513, 137, 5, 24, "Text",
  CellTags->"JacobiSymbol::jcpo"],

Cell[CellGroupData[{
Cell[39973, 1522, 109, 3, 26, "Input",
  CellTags->"JacobiSymbol::jcpo"],
Cell[40085, 1527, 98, 3, 21, "Output",
  CellTags->"JacobiSymbol::jcpo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40244, 1537, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
Cell[40379, 1543, 459, 12, 21, "Message",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
Cell[40841, 1557, 356, 13, 40, "Notes",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],

Cell[CellGroupData[{
Cell[41222, 1574, 88, 1, 38, "ExampleSection",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
Cell[41313, 1577, 279, 7, 40, "Text",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],

Cell[CellGroupData[{
Cell[41617, 1588, 140, 3, 26, "Input",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
Cell[41760, 1593, 223, 5, 21, "Message",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
Cell[41986, 1600, 141, 3, 21, "Output",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}]
}, Open  ]],
Cell[42142, 1606, 176, 5, 24, "Text",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],

Cell[CellGroupData[{
Cell[42343, 1615, 132, 3, 26, "Input",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}],
Cell[42478, 1620, 130, 3, 21, "Output",
  CellTags->{"LegendreP::ltype", "LegendreQ::ltype"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[42669, 1630, 187, 5, 51, "ObjectNameWarningMessages",
  CellTags->{
  "MathieuCharacteristicA::nnord", "MathieuCharacteristicB::nnord"}],
Cell[42859, 1637, 449, 13, 21, "Message",
  CellTags->{
  "MathieuCharacteristicA::nnord", "MathieuCharacteristicB::nnord"}],
Cell[43311, 1652, 247, 7, 24, "Notes",
  CellTags->{
  "MathieuCharacteristicA::nnord", "MathieuCharacteristicB::nnord"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[43595, 1664, 109, 1, 31, "ObjectNameWarningMessages",
  CellTags->"MathieuCharacteristicB::zord"],
Cell[43707, 1667, 207, 3, 37, "Message",
  CellTags->"MathieuCharacteristicB::zord"],
Cell[43917, 1672, 194, 5, 24, "Notes",
  CellTags->"MathieuCharacteristicB::zord"],

Cell[CellGroupData[{
Cell[44136, 1681, 78, 1, 38, "ExampleSection",
  CellTags->"MathieuCharacteristicB::zord"],
Cell[44217, 1684, 137, 4, 24, "Text",
  CellTags->"MathieuCharacteristicB::zord"],

Cell[CellGroupData[{
Cell[44379, 1692, 132, 3, 26, "Input",
  CellTags->"MathieuCharacteristicB::zord"],
Cell[44514, 1697, 213, 4, 37, "Message",
  CellTags->"MathieuCharacteristicB::zord"],
Cell[44730, 1703, 134, 3, 21, "Output",
  CellTags->"MathieuCharacteristicB::zord"]
}, Open  ]],
Cell[44879, 1709, 157, 5, 24, "Text",
  CellTags->"MathieuCharacteristicB::zord"],

Cell[CellGroupData[{
Cell[45061, 1718, 132, 3, 26, "Input",
  CellTags->"MathieuCharacteristicB::zord"],
Cell[45196, 1723, 122, 3, 21, "Output",
  CellTags->"MathieuCharacteristicB::zord"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[45379, 1733, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"MeijerG::hdiv"],
Cell[45461, 1736, 237, 5, 21, "Message",
  CellTags->"MeijerG::hdiv"],
Cell[45701, 1743, 165, 5, 24, "Notes",
  CellTags->"MeijerG::hdiv"],

Cell[CellGroupData[{
Cell[45891, 1752, 63, 1, 38, "ExampleSection",
  CellTags->"MeijerG::hdiv"],
Cell[45957, 1755, 200, 5, 40, "Text",
  CellTags->"MeijerG::hdiv"],

Cell[CellGroupData[{
Cell[46182, 1764, 121, 3, 26, "Input",
  CellTags->"MeijerG::hdiv"],
Cell[46306, 1769, 293, 6, 37, "Message",
  CellTags->"MeijerG::hdiv"],
Cell[46602, 1777, 134, 3, 21, "Output",
  CellTags->"MeijerG::hdiv"]
}, Open  ]],
Cell[46751, 1783, 127, 5, 24, "Text",
  CellTags->"MeijerG::hdiv"],

Cell[CellGroupData[{
Cell[46903, 1792, 124, 3, 26, "Input",
  CellTags->"MeijerG::hdiv"],
Cell[47030, 1797, 167, 4, 41, "Output",
  CellTags->"MeijerG::hdiv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47258, 1808, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"MeijerG::rarg"],
Cell[47340, 1811, 376, 7, 37, "Message",
  CellTags->"MeijerG::rarg"],
Cell[47719, 1820, 341, 9, 46, "Notes",
  CellTags->"MeijerG::rarg"],

Cell[CellGroupData[{
Cell[48085, 1833, 63, 1, 38, "ExampleSection",
  CellTags->"MeijerG::rarg"],
Cell[48151, 1836, 242, 6, 40, "Text",
  CellTags->"MeijerG::rarg"],

Cell[CellGroupData[{
Cell[48418, 1846, 127, 3, 26, "Input",
  CellTags->"MeijerG::rarg"],
Cell[48548, 1851, 368, 7, 53, "Message",
  CellTags->"MeijerG::rarg"],
Cell[48919, 1860, 141, 3, 21, "Output",
  CellTags->"MeijerG::rarg"]
}, Open  ]],
Cell[49075, 1866, 127, 5, 24, "Text",
  CellTags->"MeijerG::rarg"],

Cell[CellGroupData[{
Cell[49227, 1875, 127, 3, 26, "Input",
  CellTags->"MeijerG::rarg"],
Cell[49357, 1880, 156, 4, 21, "Output",
  CellTags->"MeijerG::rarg"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[49574, 1891, 114, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Mod::divz", "Quotient::divz"}],
Cell[49691, 1897, 426, 12, 21, "Message",
  CellTags->{"Mod::divz", "Quotient::divz"}],
Cell[50120, 1911, 148, 4, 24, "Notes",
  CellTags->{"Mod::divz", "Quotient::divz"}],

Cell[CellGroupData[{
Cell[50293, 1919, 79, 1, 38, "ExampleSection",
  CellTags->{"Mod::divz", "Quotient::divz"}],
Cell[50375, 1922, 204, 6, 24, "Text",
  CellTags->{"Mod::divz", "Quotient::divz"}],

Cell[CellGroupData[{
Cell[50604, 1932, 111, 3, 26, "Input",
  CellTags->{"Mod::divz", "Quotient::divz"}],
Cell[50718, 1937, 210, 5, 21, "Message",
  CellTags->{"Mod::divz", "Quotient::divz"}],
Cell[50931, 1944, 112, 3, 21, "Output",
  CellTags->{"Mod::divz", "Quotient::divz"}]
}, Open  ]],
Cell[51058, 1950, 139, 5, 24, "Text",
  CellTags->{"Mod::divz", "Quotient::divz"}],

Cell[CellGroupData[{
Cell[51222, 1959, 111, 3, 26, "Input",
  CellTags->{"Mod::divz", "Quotient::divz"}],
Cell[51336, 1964, 104, 3, 21, "Output",
  CellTags->{"Mod::divz", "Quotient::divz"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[51501, 1974, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PowerMod::divz"],
Cell[51585, 1977, 253, 6, 21, "Message",
  CellTags->"PowerMod::divz"],
Cell[51841, 1985, 166, 5, 24, "Notes",
  CellTags->"PowerMod::divz"],

Cell[CellGroupData[{
Cell[52032, 1994, 64, 1, 38, "ExampleSection",
  CellTags->"PowerMod::divz"],
Cell[52099, 1997, 169, 5, 24, "Text",
  CellTags->"PowerMod::divz"],

Cell[CellGroupData[{
Cell[52293, 2006, 104, 3, 26, "Input",
  CellTags->"PowerMod::divz"],
Cell[52400, 2011, 207, 5, 21, "Message",
  CellTags->"PowerMod::divz"],
Cell[52610, 2018, 105, 3, 21, "Output",
  CellTags->"PowerMod::divz"]
}, Open  ]],
Cell[52730, 2024, 129, 5, 24, "Text",
  CellTags->"PowerMod::divz"],

Cell[CellGroupData[{
Cell[52884, 2033, 104, 3, 26, "Input",
  CellTags->"PowerMod::divz"],
Cell[52991, 2038, 89, 3, 21, "Output",
  CellTags->"PowerMod::divz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[53141, 2048, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PowerMod::ninv"],
Cell[53225, 2051, 270, 7, 21, "Message",
  CellTags->"PowerMod::ninv"],
Cell[53498, 2060, 136, 4, 24, "Notes",
  CellTags->"PowerMod::ninv"],

Cell[CellGroupData[{
Cell[53659, 2068, 64, 1, 38, "ExampleSection",
  CellTags->"PowerMod::ninv"],
Cell[53726, 2071, 124, 4, 24, "Text",
  CellTags->"PowerMod::ninv"],

Cell[CellGroupData[{
Cell[53875, 2079, 110, 3, 26, "Input",
  CellTags->"PowerMod::ninv"],
Cell[53988, 2084, 178, 4, 21, "Message",
  CellTags->"PowerMod::ninv"],
Cell[54169, 2090, 111, 3, 21, "Output",
  CellTags->"PowerMod::ninv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[54341, 2100, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PowerMod::pmod"],
Cell[54425, 2103, 371, 8, 21, "Message",
  CellTags->"PowerMod::pmod"],
Cell[54799, 2113, 314, 8, 46, "Notes",
  CellTags->"PowerMod::pmod"],

Cell[CellGroupData[{
Cell[55138, 2125, 64, 1, 38, "ExampleSection",
  CellTags->"PowerMod::pmod"],
Cell[55205, 2128, 136, 4, 24, "Text",
  CellTags->"PowerMod::pmod"],

Cell[CellGroupData[{
Cell[55366, 2136, 106, 3, 26, "Input",
  CellTags->"PowerMod::pmod"],
Cell[55475, 2141, 232, 5, 37, "Message",
  CellTags->"PowerMod::pmod"],
Cell[55710, 2148, 107, 3, 21, "Output",
  CellTags->"PowerMod::pmod"]
}, Open  ]],
Cell[55832, 2154, 129, 5, 24, "Text",
  CellTags->"PowerMod::pmod"],

Cell[CellGroupData[{
Cell[55986, 2163, 104, 3, 26, "Input",
  CellTags->"PowerMod::pmod"],
Cell[56093, 2168, 89, 3, 21, "Output",
  CellTags->"PowerMod::pmod"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[56243, 2178, 120, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Prime::largp", "PrimePi::largp"}],
Cell[56366, 2184, 454, 12, 21, "Message",
  CellTags->{"Prime::largp", "PrimePi::largp"}],
Cell[56823, 2198, 377, 11, 46, "Notes",
  CellTags->{"Prime::largp", "PrimePi::largp"}],

Cell[CellGroupData[{
Cell[57225, 2213, 82, 1, 38, "ExampleSection",
  CellTags->{"Prime::largp", "PrimePi::largp"}],
Cell[57310, 2216, 235, 6, 40, "Text",
  CellTags->{"Prime::largp", "PrimePi::largp"}],

Cell[CellGroupData[{
Cell[57570, 2226, 117, 3, 26, "Input",
  CellTags->{"Prime::largp", "PrimePi::largp"}],
Cell[57690, 2231, 268, 6, 37, "Message",
  CellTags->{"Prime::largp", "PrimePi::largp"}],
Cell[57961, 2239, 134, 3, 21, "Output",
  CellTags->{"Prime::largp", "PrimePi::largp"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[58156, 2249, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PrimePi::nsfmm"],
Cell[58240, 2252, 169, 3, 21, "Message",
  CellTags->"PrimePi::nsfmm"],
Cell[58412, 2257, 196, 6, 24, "Notes",
  CellTags->"PrimePi::nsfmm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[58645, 2268, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SeedRandom::seed"],
Cell[58733, 2271, 341, 9, 21, "Message",
  CellTags->"SeedRandom::seed"],
Cell[59077, 2282, 186, 5, 24, "Notes",
  CellTags->"SeedRandom::seed"],

Cell[CellGroupData[{
Cell[59288, 2291, 66, 1, 38, "ExampleSection",
  CellTags->"SeedRandom::seed"],
Cell[59357, 2294, 132, 4, 24, "Text",
  CellTags->"SeedRandom::seed"],

Cell[CellGroupData[{
Cell[59514, 2302, 109, 3, 26, "Input",
  CellTags->"SeedRandom::seed"],
Cell[59626, 2307, 253, 6, 37, "Message",
  CellTags->"SeedRandom::seed"],
Cell[59882, 2315, 121, 3, 21, "Output",
  CellTags->"SeedRandom::seed"]
}, Open  ]],
Cell[60018, 2321, 134, 5, 24, "Text",
  CellTags->"SeedRandom::seed"],
Cell[60155, 2328, 102, 3, 26, "Input",
  CellTags->"SeedRandom::seed"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[60306, 2337, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DigitCount::base"],
Cell[60394, 2340, 213, 5, 37, "Message",
  CellTags->"DigitCount::base"],
Cell[60610, 2347, 367, 9, 46, "Notes",
  CellTags->"DigitCount::base"],

Cell[CellGroupData[{
Cell[61002, 2360, 66, 1, 38, "ExampleSection",
  CellTags->"DigitCount::base"],
Cell[61071, 2363, 181, 5, 24, "Text",
  CellTags->"DigitCount::base"],

Cell[CellGroupData[{
Cell[61277, 2372, 113, 3, 26, "Input",
  CellTags->"DigitCount::base"],
Cell[61393, 2377, 251, 5, 37, "Message",
  CellTags->"DigitCount::base"],
Cell[61647, 2384, 114, 3, 21, "Output",
  CellTags->"DigitCount::base"]
}, Open  ]],
Cell[61776, 2390, 186, 4, 40, "Text",
  CellTags->"DigitCount::base"],

Cell[CellGroupData[{
Cell[61987, 2398, 117, 3, 26, "Input",
  CellTags->"DigitCount::base"],
Cell[62107, 2403, 91, 3, 21, "Output",
  CellTags->"DigitCount::base"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[62259, 2413, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DigitCount::digp"],
Cell[62347, 2416, 245, 5, 53, "Message",
  CellTags->"DigitCount::digp"],
Cell[62595, 2423, 384, 9, 46, "Notes",
  CellTags->"DigitCount::digp"],

Cell[CellGroupData[{
Cell[63004, 2436, 66, 1, 38, "ExampleSection",
  CellTags->"DigitCount::digp"],
Cell[63073, 2439, 201, 5, 24, "Text",
  CellTags->"DigitCount::digp"],

Cell[CellGroupData[{
Cell[63299, 2448, 117, 3, 26, "Input",
  CellTags->"DigitCount::digp"],
Cell[63419, 2453, 289, 6, 53, "Message",
  CellTags->"DigitCount::digp"],
Cell[63711, 2461, 118, 3, 21, "Output",
  CellTags->"DigitCount::digp"]
}, Open  ]],
Cell[63844, 2467, 181, 4, 40, "Text",
  CellTags->"DigitCount::digp"],

Cell[CellGroupData[{
Cell[64050, 2475, 117, 3, 26, "Input",
  CellTags->"DigitCount::digp"],
Cell[64170, 2480, 91, 3, 21, "Output",
  CellTags->"DigitCount::digp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[64322, 2490, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RealDigits::digs"],
Cell[64410, 2493, 175, 4, 37, "Message",
  CellTags->"RealDigits::digs"],
Cell[64588, 2499, 196, 6, 24, "Notes",
  CellTags->"RealDigits::digs"]
}, Open  ]],

Cell[CellGroupData[{
Cell[64821, 2510, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RealDigits::period"],
Cell[64913, 2513, 235, 5, 37, "Message",
  CellTags->"RealDigits::period"],
Cell[65151, 2520, 131, 4, 24, "Notes",
  CellTags->"RealDigits::period"]
}, Open  ]],

Cell[CellGroupData[{
Cell[65319, 2529, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PowerMod::badmod"],
Cell[65407, 2532, 171, 3, 21, "Message",
  CellTags->"PowerMod::badmod"],
Cell[65581, 2537, 127, 4, 24, "Notes",
  CellTags->"PowerMod::badmod"]
}, Open  ]],

Cell[CellGroupData[{
Cell[65745, 2546, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PowerMod::root"],
Cell[65829, 2549, 192, 3, 21, "Message",
  CellTags->"PowerMod::root"],
Cell[66024, 2554, 125, 4, 24, "Notes",
  CellTags->"PowerMod::root"]
}, Open  ]],

Cell[CellGroupData[{
Cell[66186, 2563, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PowerModList::arg1"],
Cell[66278, 2566, 190, 3, 21, "Message",
  CellTags->"PowerModList::arg1"],
Cell[66471, 2571, 199, 5, 24, "Notes",
  CellTags->"PowerModList::arg1"],

Cell[CellGroupData[{
Cell[66695, 2580, 68, 1, 38, "ExampleSection",
  CellTags->"PowerModList::arg1"],
Cell[66766, 2583, 229, 5, 40, "Text",
  CellTags->"PowerModList::arg1"],

Cell[CellGroupData[{
Cell[67020, 2592, 119, 3, 26, "Input",
  CellTags->"PowerModList::arg1"],
Cell[67142, 2597, 210, 5, 37, "Message",
  CellTags->"PowerModList::arg1"],
Cell[67355, 2604, 121, 3, 36, "Output",
  CellTags->"PowerModList::arg1"]
}, Open  ]],
Cell[67491, 2610, 133, 5, 24, "Text",
  CellTags->"PowerModList::arg1"],

Cell[CellGroupData[{
Cell[67649, 2619, 117, 3, 26, "Input",
  CellTags->"PowerModList::arg1"],
Cell[67769, 2624, 111, 3, 21, "Output",
  CellTags->"PowerModList::arg1"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[67941, 2634, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PowerModList::arg2"],
Cell[68033, 2637, 188, 3, 21, "Message",
  CellTags->"PowerModList::arg2"],
Cell[68224, 2642, 200, 5, 24, "Notes",
  CellTags->"PowerModList::arg2"],

Cell[CellGroupData[{
Cell[68449, 2651, 68, 1, 38, "ExampleSection",
  CellTags->"PowerModList::arg2"],
Cell[68520, 2654, 150, 4, 24, "Text",
  CellTags->"PowerModList::arg2"],

Cell[CellGroupData[{
Cell[68695, 2662, 121, 3, 26, "Input",
  CellTags->"PowerModList::arg2"],
Cell[68819, 2667, 208, 5, 40, "Message",
  CellTags->"PowerModList::arg2"],
Cell[69030, 2674, 118, 3, 26, "Output",
  CellTags->"PowerModList::arg2"]
}, Open  ]],
Cell[69163, 2680, 133, 5, 24, "Text",
  CellTags->"PowerModList::arg2"],

Cell[CellGroupData[{
Cell[69321, 2689, 117, 3, 26, "Input",
  CellTags->"PowerModList::arg2"],
Cell[69441, 2694, 111, 3, 21, "Output",
  CellTags->"PowerModList::arg2"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[69613, 2704, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PowerModList::arg3"],
Cell[69705, 2707, 373, 8, 37, "Message",
  CellTags->"PowerModList::arg3"],
Cell[70081, 2717, 199, 5, 24, "Notes",
  CellTags->"PowerModList::arg3"],

Cell[CellGroupData[{
Cell[70305, 2726, 68, 1, 38, "ExampleSection",
  CellTags->"PowerModList::arg3"],
Cell[70376, 2729, 240, 5, 40, "Text",
  CellTags->"PowerModList::arg3"],

Cell[CellGroupData[{
Cell[70641, 2738, 119, 3, 26, "Input",
  CellTags->"PowerModList::arg3"],
Cell[70763, 2743, 219, 5, 37, "Message",
  CellTags->"PowerModList::arg3"],
Cell[70985, 2750, 121, 3, 36, "Output",
  CellTags->"PowerModList::arg3"],
Cell[71109, 2755, 264, 6, 37, "Message",
  CellTags->"PowerModList::arg3"],
Cell[71376, 2763, 123, 3, 36, "Output",
  CellTags->"PowerModList::arg3"]
}, Open  ]],
Cell[71514, 2769, 133, 5, 24, "Text",
  CellTags->"PowerModList::arg3"],

Cell[CellGroupData[{
Cell[71672, 2778, 117, 3, 26, "Input",
  CellTags->"PowerModList::arg3"],
Cell[71792, 2783, 111, 3, 21, "Output",
  CellTags->"PowerModList::arg3"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[71964, 2793, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PowerModList::nargs"],
Cell[72058, 2796, 317, 8, 21, "Message",
  CellTags->"PowerModList::nargs"],
Cell[72378, 2806, 193, 5, 24, "Notes",
  CellTags->"PowerModList::nargs"],

Cell[CellGroupData[{
Cell[72596, 2815, 69, 1, 38, "ExampleSection",
  CellTags->"PowerModList::nargs"],
Cell[72668, 2818, 127, 4, 24, "Text",
  CellTags->"PowerModList::nargs"],

Cell[CellGroupData[{
Cell[72820, 2826, 113, 3, 26, "Input",
  CellTags->"PowerModList::nargs"],
Cell[72936, 2831, 200, 4, 21, "Message",
  CellTags->"PowerModList::nargs"],
Cell[73139, 2837, 115, 3, 36, "Output",
  CellTags->"PowerModList::nargs"]
}, Open  ]],
Cell[73269, 2843, 134, 5, 24, "Text",
  CellTags->"PowerModList::nargs"],

Cell[CellGroupData[{
Cell[73428, 2852, 118, 3, 26, "Input",
  CellTags->"PowerModList::nargs"],
Cell[73549, 2857, 112, 3, 21, "Output",
  CellTags->"PowerModList::nargs"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

