(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    276746,       9248]*)
(*NotebookOutlinePosition[    401257,      12139]*)
(*  CellTagsIndexPosition[    393662,      11945]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["NDSolve", "Title"],

Cell[CellGroupData[{

Cell["NDSolve::ndtol", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndtol"],

Cell[BoxData[
    \(NDSolve::"ndtol" \(\(:\)\(\ \)\) 
      "Tolerances requested by the AccuracyGoal and PrecisionGoal options \
could not be achieved at `1` == `2`."\)], "Message",
  CellLabel->"From In[22]:=",
  CellTags->"NDSolve::ndtol"],

Cell["\<\
\[FilledSmallSquare] This message is generated by a specific type \
of failure within the algorithms that are used for computing numerical \
solutions of ordinary differential equations.\
\>", "Notes",
  CellTags->"NDSolve::ndtol"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::ndtol"],

Cell["\<\
A warning message is generated in this example because the \
requested precision and accuracy are too high to be achieved using the \
default options.\
\>", "Text",
  CellTags->"NDSolve::ndtol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x'\)[t]\  \[Equal] \ x[t], \ x[0]\  \[Equal] \ 1}, 
      x, {t, 0, 1}, \ AccuracyGoal \[Rule] 30, \ 
      PrecisionGoal \[Rule] 30]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::ndtol"],

Cell[BoxData[
    \(NDSolve::"ndtol" \(\(:\)\(\ \)\) 
      "Tolerances requested by the AccuracyGoal and PrecisionGoal options \
could not be achieved at \!\(t\) == \!\(0.`\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ndtol"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 0.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::ndtol"]
}, Open  ]],

Cell[TextData[{
  "The accuracy and precision goals specified in this example can be achieved \
by including a sufficiently high value for the ",
  StyleBox["WorkingPrecision", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::ndtol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x'\)[t]\  \[Equal] \ x[t], \ x[0]\  \[Equal] \ 1}, 
      x, {t, 0, 1}, \ AccuracyGoal \[Rule] 30, \ PrecisionGoal \[Rule] 30, 
      WorkingPrecision \[Rule] 50]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::ndtol"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0, 1.`50. }}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::ndtol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ivone", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ivone"],

Cell[BoxData[
    \(NDSolve::"ivone" \(\(:\)\(\ \)\) 
      "Boundary values may only be specified for one independent variable. \
Initial values may only be specified at one value of the other independent \
variable."\)], "Message",
  CellLabel->"From In[35]:=",
  CellTags->"NDSolve::ivone"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the initial values and boundary  \
conditions for a partial differential equation specify values on all sides of \
 the solution region.\n\[FilledSmallSquare] The partial differential equation \
 solver used by ",
  StyleBox["NDSolve", "MR"],
  " is designed to solve initial value problems."
}], "Notes",
  CellTags->"NDSolve::ivone"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::ivone"],

Cell["\<\
This input generates a message because the equations specify values \
for the solution on all sides of the solution region.\
\>", "Text",
  CellTags->"NDSolve::ivone"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
              t] == \(\(Derivative[0, 2]\)[f]\)[x, t], \n\t\tf[1, t] == 0, 
          f[x, 0] == 0, f[0, t] == 0, f[x, 4] == 0}, 
        f, {x, 0, 1}, {t, 0, 4}];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::ivone"],

Cell[BoxData[
    \(NDSolve::"ivone" \(\(:\)\(\ \)\) 
      "Boundary values may only be specified for one independent variable. \
Initial values may only be specified at one value of the other independent \
variable."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ivone"]
}, Open  ]],

Cell["\<\
An error is generated in this example because there is no \
specification for the initial values of the solution.\
\>", "Text",
  CellTags->"NDSolve::ivone"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 2]\)[f]\)[x, t], \n\t\tf[0, t] == 0, 
        f[1, t] == 0}, f, {x, 0, 1}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::ivone"],

Cell[BoxData[
    \(NDSolve::"ivone" \(\(:\)\(\ \)\) 
      "Boundary values may only be specified for one independent variable. \
Initial values may only be specified at one value of the other independent \
variable."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"NDSolve::ivone"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 2)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(f[0, t] \[Equal] 0\), ",", \(f[1, t] \[Equal] 0\)}], "}"}],
         ",", "f", ",", \({x, 0, 1}\), ",", \({t, 0, 1}\)}], "]"}]], "Output",\

  CellLabel->"Out[2]=",
  CellTags->"NDSolve::ivone"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bcnorm", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bcnorm"],

Cell[BoxData[
    \(NDSolve::"bcnorm" \(\(:\)\(\ \)\) 
      "Boundary condition `1` includes non-normal derivatives."\)], "Message",\

  CellLabel->"From In[22]:=",
  CellTags->"NDSolve::bcnorm"],

Cell["\<\
\[FilledSmallSquare] Generated when a boundary condition for a \
partial differential equation involves derivatives that are not normal to the \
boundary.
\[FilledSmallSquare] This problem can usually be resolved by checking that \
derivative boundary conditions are specified using the correct \
variable.\
\>", "Notes",
  CellTags->"NDSolve::bcnorm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bcnorm"],

Cell["\<\
An error occurs in this example because the boundary condition \
indicated in the message involves a derivative in a direction that is not \
perpendicular to the boundary.\
\>", "Text",
  CellTags->"NDSolve::bcnorm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, y, t], t]\  \[Equal] \ 
          D[u[x, y, t], x, x]\  + \ D[u[x, y, t], y, y], 
        u[x, y, 0]\  \[Equal] \ 
          Exp[\(-10\)\ x^2], \ \(\(Derivative[0, 1, 0]\)[u]\)[1, y, 
            t]\  \[Equal] \ Exp[\(-10\)], \ 
        u[\(-1\), y, t]\  \[Equal] \ Exp[\(-10\)], 
        u[x, 1, t]\  \[Equal] \ Exp[\(-10\)\ x^2], 
        u[x, \(-1\), t]\  \[Equal] \ Exp[\(-10\)\ x^2]}, 
      u, {x, \(-1\), 1}, {y, \(-1\), 1}, {t, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bcnorm"],

Cell[BoxData[
    RowBox[{\(NDSolve::"bcnorm"\), \(\(:\)\(\ \)\), "\<\"Boundary condition \
\\!\\(\\(\\(-\\(\\(1\\/\[ExponentialE]\\^10\\)\\)\\)\\) + \
\\(\\(\\(\\(\\*SuperscriptBox[\\\"u\\\", TagBox[\\((0, 1, 0)\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(1, y, t\\)\\)]\\)\\)\\) includes \
non-normal derivatives.\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bcnorm"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, y, t\), "]"}], 
              "\[Equal]", 
              RowBox[{
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((0, 2, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, y, t\), "]"}], "+", 
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((2, 0, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, y, t\), "]"}]}]}], 
            ",", \(u[x, y, 0] \[Equal] \[ExponentialE]\^\(\(-10\)\ x\^2\)\), 
            ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(1, y, t\), "]"}], 
              "\[Equal]", \(1\/\[ExponentialE]\^10\)}], 
            ",", \(u[\(-1\), y, t] \[Equal] 1\/\[ExponentialE]\^10\), 
            ",", \(u[x, 1, t] \[Equal] \[ExponentialE]\^\(\(-10\)\ x\^2\)\), 
            ",", \(u[x, \(-1\), 
                t] \[Equal] \[ExponentialE]\^\(\(-10\)\ x\^2\)\)}], "}"}], 
        ",", "u", ",", \({x, \(-1\), 1}\), ",", \({y, \(-1\), 1}\), 
        ",", \({t, 2}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bcnorm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndlim", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndlim"],

Cell[BoxData[
    RowBox[{\(NDSolve::"ndlim"\), ":", " ", 
      RowBox[{"Range", " ", "specification", " ", 
        StyleBox["expr",
          
          "TI"], \(\(\ \)\(is\ not\ of\ the\ form\ {x, \ 
            xend}\ or\ \(\({x, \ xmin, \ xmax}\)\(.\)\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::ndlim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the range specifications in ",
  StyleBox["NDSolve", "MR"],
  " do not have the indicated form.\n\[FilledSmallSquare] The third argument \
and subsequent arguments in ",
  StyleBox["NDSolve", "MR"],
  " are treated as range specifications. A range specification is a list that \
gives the name of a variable and the range of that variable."
}], "Notes",
  CellTags->"NDSolve::ndlim"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndcf", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndcf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\(NDSolve::"ndcf"\), \(\(:\)\(\ \)\), "Repeated", " ", 
          "convergence", " ", "test", " ", "failure", " ", "at", " ", 
          StyleBox["x",
            "TI"]}], " ", "==", " ", 
        StyleBox["val",
          "TI"]}], ";", 
      " ", \(unable\ to\ \(\(continue\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::ndcf"],

Cell["\<\
\[FilledSmallSquare] This message is generated by a specific type \
of failure within the algorithms that are used for computing numerical \
solutions of ordinary differential equations.
\[FilledSmallSquare] If you see this message and the cause is not evident \
from the nature of the example, please send your example to Technical Support \
so that it can be investigated.\
\>", "Notes",
  CellTags->"NDSolve::ndcf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::conarg
NDSolve::conarg
RSolve::conarg\
\>", "ObjectNameWarningMessages",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"conarg\"\>"}], \(\(:\)\(\ \)\), \(The\ arguments\ should\ \
be\ ordered\ \(\(consistently\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],

Cell["\<\
\[FilledSmallSquare] Generated when the function arguments in the \
specification of an equation occur in different orders in different parts of \
the equation.
\[FilledSmallSquare] The cause of this error can in most cases be readily \
identified by inspecting the input to be sure that the solution function is \
always specified in the same way.\
\>", "Notes",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],

Cell["\<\
This example generates an error because the arguments of the \
solution function are given in the opposite order on the right-hand side of \
the differential equation.\
\>", "Text",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[f[x, t], x, x] == D[f[t, x], t], f[0, t] == 0, f[1, t] == 0, 
        f[x, 0] == x \((x - 1)\)}, f, {x, 0, 1}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],

Cell[BoxData[
    \(NDSolve::"conarg" \(\(:\)\(\ \)\) 
      "The arguments should be ordered consistently."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((1, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(t, x\), "]"}]}], 
            ",", \(f[0, t] \[Equal] 0\), ",", \(f[1, t] \[Equal] 0\), 
            ",", \(f[x, 0] \[Equal] \((\(-1\) + x)\)\ x\)}], "}"}], ",", "f", 
        ",", \({x, 0, 1}\), ",", \({t, 0, 1}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}]
}, Open  ]],

Cell["\<\
This shows a correct specification of the partial differential \
equation.\
\>", "Text",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[f[x, t], x, x] == D[f[x, t], t], f[0, t] == 0, f[1, t] == 0, 
        f[x, 0] == x \((x - 1)\)}, f, {x, 0, 1}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}, {0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NDSolve::ndnco
NDSolve`Reinitialize::ndnco\
\>", "ObjectNameWarningMessages",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ndnco\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "number", " ", "of", " ", "constraints", " ", 
      RowBox[{"(", 
        StyleBox["n1",
          "TI"], ")"}], " ", \((initial\ conditions)\), " ", "is", " ", "not",
       " ", "equal", " ", "to", " ", "the", " ", "total", " ", "differential",
       " ", "order", " ", "of", " ", "the", " ", "system", " ", 
      RowBox[{
        RowBox[{"(", 
          StyleBox["n2",
            "TI"], ")"}], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],

Cell["\<\
\[FilledSmallSquare] Generated when the solution of a differential \
equation is either underspecified (insufficient initial conditions) or \
overspecified (too many initial conditions).\
\>", "Notes",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],

Cell["\<\
An error occurs in this example because there are not enough \
initial conditions to uniquely specify a solution.\
\>", "Text",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(f'\)'\)[x] == f[x], f[0] == 1}, f, {x, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],

Cell[BoxData[
    \(NDSolve::"ndnco" \(\(:\)\(\ \)\) 
      "The number of constraints (\!\(1\)) (initial conditions) is not equal \
to the total differential order of the system (\!\(2\))."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(f[x]\)}], ",", \(f[0] \[Equal] 1\)}], "}"}], ",", 
        "f", ",", \({x, 0, 1}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}]
}, Open  ]],

Cell["\<\
This shows a valid specification of a unique solution for this \
differential equation.\
\>", "Text",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(f'\)'\)[x] == f[x], f[0] == 1, \(f'\)[0] == 1}, 
      f, {x, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ntcs", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ntcs"],

Cell[BoxData[
    \(NDSolve::"ntcs" \(\(:\)\(\ \)\) \(Cannot\ solve\ constraint\ equations\ \
for\ initial\ \(\(conditions\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::ntcs"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["NDSolve", "MR"],
  " is unable to compute the initial conditions for the solution of a  \
differential equation.\n\[FilledSmallSquare] This error can occur if the  \
specified initial conditions are inconsistent, or if the equations that give  \
the initial values for the solution cannot be solved for the initial  \
conditions by algebraic methods."
}], "Notes",
  CellTags->"NDSolve::ntcs"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::ntcs"],

Cell["\<\
An error occurs in this example because the initial conditions are \
inconsistent.\
\>", "Text",
  CellTags->"NDSolve::ntcs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[x] == g[x], \ \(g'\)[x] == f[x], f[1] == 1, 
        f[1] == 2}, {f, g}, {x, 1, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::ntcs"],

Cell[BoxData[
    \(NDSolve::"ntcs" \(\(:\)\(\ \)\) 
      "Cannot solve constraint equations for initial conditions."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ntcs"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(g[x]\)}], ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["g", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(f[x]\)}], ",", \(f[1] \[Equal] 1\), 
            ",", \(f[1] \[Equal] 2\)}], "}"}], ",", \({f, g}\), 
        ",", \({x, 1, 2}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::ntcs"]
}, Open  ]],

Cell["\<\
This shows a valid specification for a solution of this pair of \
differential equations.\
\>", "Text",
  CellTags->"NDSolve::ntcs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[x] == g[x], \ \(g'\)[x] == f[x], f[1] == 1, 
        g[1] == 2}, {f, g}, {x, 1, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::ntcs"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"f", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{1.`, 2.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"g", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{1.`, 2.`}}, "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::ntcs"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bcart", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bcart"],

Cell[BoxData[
    \(NDSolve::"bcart" \(\(:\)\(\ \)\) 
      "Warning: An insufficient number of boundary conditions have been \
specified for the direction of independent variable `1`. Artificial boundary \
effects may be present in the solution."\)], "Message",
  CellLabel->"From In[22]:=",
  CellTags->"NDSolve::bcart"],

Cell["\<\
\[FilledSmallSquare] Generated when the boundary conditions in a \
partial differential equation are not sufficient to uniquely specify the \
solution.\
\>", "Notes",
  CellTags->"NDSolve::bcart"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bcart"],

Cell["\<\
A warning message is generated in this example because no condition \
is given for one of the boundaries.\
\>", "Text",
  CellTags->"NDSolve::bcart"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[f[x, t], x, x] == D[f[x, t], t], f[0, t] == 0, \n\t
        f[x, 0] == x \((1 - x)\)}, f, {x, 0, 1}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bcart"],

Cell[BoxData[
    \(NDSolve::"bcart" \(\(:\)\(\ \)\) 
      "Warning: An insufficient number of boundary conditions have been \
specified for the direction of independent variable \!\(x\). Artificial \
boundary effects may be present in the solution."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bcart"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}, {0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bcart"]
}, Open  ]],

Cell["\<\
This shows one way to specify a unique solution in this \
example.\
\>", "Text",
  CellTags->"NDSolve::bcart"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[f[x, t], x, x] == D[f[x, t], t], f[0, t] == 0, 
        f[1, t] == 0, \n\tf[x, 0] == x \((1 - x)\)}, 
      f, {x, 0, 1}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::bcart"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}, {0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::bcart"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NDSolve::ndsv
NDSolve`Reinitialize::ndsv\
\>", "ObjectNameWarningMessages",
  CellTags->{"NDSolve::ndsv", "NDSolve`Reinitialize::ndsv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ndsv\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "find", " ", "starting", " ", "value", " ", "for", " ", "the", " ", 
      "variable", " ", 
      RowBox[{
        StyleBox["var",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NDSolve::ndsv", "NDSolve`Reinitialize::ndsv"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["NDSolve", "MR"],
  " is unable to solve the initial conditions to find a starting value in an  \
initial value problem.\n\[FilledSmallSquare] This message can be generated by \
 a variety of errors in the specification of initial conditions."
}], "Notes",
  CellTags->{"NDSolve::ndsv", "NDSolve`Reinitialize::ndsv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::nderr", "ObjectNameWarningMessages",
  CellTags->"NDSolve::nderr"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NDSolve::"nderr"\), ":", " ", 
        RowBox[{
          RowBox[{"Error", " ", "test", " ", "failure", " ", "at", " ", 
            StyleBox["var",
              "TI"]}], " ", "==", " ", 
          StyleBox["val",
            "TI"]}]}], ";", 
      " ", \(unable\ to\ \(\(continue\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::nderr"],

Cell["\<\
\[FilledSmallSquare] This message is generated by a specific type \
of failure within the algorithm that is used for solving initial value \
problems.
\[FilledSmallSquare] This error can occur if the differential equation has \
singular or oscillatory solutions.
\[FilledSmallSquare] If you see this message in an example where it is not \
expected, please contact Technical Support for more information.\
\>", "Notes",\

  CellTags->"NDSolve::nderr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndnl", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndnl"],

Cell[BoxData[
    RowBox[{\(NDSolve::"ndnl"\), ":", " ", 
      RowBox[{"Endpoint", " ", 
        StyleBox["val",
          "TI"], " ", "in", " ", 
        StyleBox["expr",
          
          "TI"], \(\(\ \)\(is\ not\ a\ real\ \(\(number\)\(.\)\)\)\)}]}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::ndnl"],

Cell["\<\
\[FilledSmallSquare] Generated when the endpoints specified for the \
range of integration are not real numbers.\
\>", "Notes",
  CellTags->"NDSolve::ndnl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::ndnl"],

Cell["\<\
An error occurs in this example because the limits on the \
independent variable do not have values.\
\>", "Text",
  CellTags->"NDSolve::ndnl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[t] == f[t], f[1] == 1}, f, {t, t1, t2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::ndnl"],

Cell[BoxData[
    \(NDSolve::"ndnl" \(\(:\)\(\ \)\) 
      "Endpoint \!\(t1\) in \!\({t, t1, t2}\) is not a real number."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ndnl"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], 
              "\[Equal]", \(f[t]\)}], ",", \(f[1] \[Equal] 1\)}], "}"}], ",", 
        "f", ",", \({t, t1, t2}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::ndnl"]
}, Open  ]],

Cell["\<\
This shows a correct specification of the limits on the variable.\
\
\>", "Text",
  CellTags->"NDSolve::ndnl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{t1 = 1, t2 = 2}, 
      NDSolve[{\(f'\)[t] == f[t], f[1] == 1}, f, {t, t1, t2}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::ndnl"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{1.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::ndnl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::stopt", "ObjectNameWarningMessages",
  CellTags->"NDSolve::stopt"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NDSolve::"stopt"\), \(\(:\)\(\ \)\), "The", " ", 
        "integration", " ", "was", " ", "not", " ", "completed", " ", 
        "because", " ", "the", " ", "StoppingTest", " ", "evaluated", " ", 
        "to", " ", "neither", " ", "True", " ", "nor", " ", "False", " ", 
        "at", " ", 
        StyleBox["var",
          "TI"]}], " ", "==", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::stopt"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["StoppingTest", "MR"],
  " option does not evaluate to ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  " at the indicated point.\n\[FilledSmallSquare] The value of the ",
  StyleBox["StoppingTest", "MR"],
  " option should be an expression that will evaluate to either ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  " when numerical values are inserted for the independent variable and the  \
solution."
}], "Notes",
  CellTags->"NDSolve::stopt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::stopt"],

Cell[TextData[{
  "An error occurs in this example because of an incorrect value for the ",
  StyleBox["StoppingTest", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::stopt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol\  = 
      NDSolve[{\(\(f'\)'\)[x] == f[x], f[1] == 1, \(f'\)[1] == 1}, 
        f, {x, 1, 10}, StoppingTest -> \((f[5] > 1000)\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::stopt"],

Cell[BoxData[
    \(NDSolve::"stopt" \(\(:\)\(\ \)\) 
      "The integration was not completed because the StoppingTest evaluated \
to neither True nor False at \!\(\"t\"\) == \!\(1.0002013102478162`\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::stopt"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{1.`, 1.0002013102478162`}}, 
              "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::stopt"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["StoppingTest", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::stopt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(f'\)'\)[x] == f[x], f[1] == 1, \(f'\)[1] == 1}, 
      f, {x, 1, 10}, StoppingTest -> \((f[x] > 1000)\)]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::stopt"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{1.`, 7.972969794499707`}}, "<>"]\),
            
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::stopt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ibcinc", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ibcinc"],

Cell[BoxData[
    \(NDSolve::"ibcinc" \(\(:\)\(\ \)\) \(Warning : \ 
        Boundary\ and\ initial\ conditions\ are\ \
\(\(inconsistent\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::ibcinc"],

Cell["\<\
\[FilledSmallSquare] Generated when the boundary conditions and \
initial conditions in a partial differential equation give different values \
for the solution at a single point.
\[FilledSmallSquare] Difficulties with inconsistent boundary and initial \
conditions can sometimes be resolved by approximating the inconsistent \
conditions with consistent conditions.
\[FilledSmallSquare] Although inconsistent boundary and initial conditions \
are common in practical models, such conditions generally represent \
unphysical processes, such as an instantaneous change in temperature, and can \
lead to singular solutions that may be difficult to handle by numerical \
methods.\
\>", "Notes",
  CellTags->"NDSolve::ibcinc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::ibcinc"],

Cell[TextData[{
  "A warning is generated in this example because the initial conditions and  \
boundary conditions give two different values for the value of ",
  StyleBox["f[0,0]", "MR"],
  ".  This example corresponds to a heat equation in which the temperature at \
 one endpoint changes instantly."
}], "Text",
  CellTags->"NDSolve::ibcinc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 1]\)[f]\)[x, t], \n\t\tf[x, 0] == 1 - x, 
        f[0, t] == 0, f[1, t] == 0}, f, {x, 0, 1}, {t, 0, 0.2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::ibcinc"],

Cell[BoxData[
    \(NDSolve::"ibcinc" \(\(:\)\(\ \)\) 
      "Warning: Boundary and initial conditions are inconsistent."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ibcinc"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}, {0.`, 0.2`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::ibcinc"]
}, Open  ]],

Cell["\<\
One way to avoid the inconsistent conditions on the solution is to \
replace the discontinuous condition with a similar condition that changes \
quickly but smoothly.\
\>", "Text",
  CellTags->"NDSolve::ibcinc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
              t] == \(\(Derivative[0, 1]\)[f]\)[x, t], \n\t\tf[x, 0] == 
            1 - x, f[0, t] == Exp[\(-1000\)\ t], f[1, t] == 0}, 
        f, {x, 0, 1}, {t, 0, 0.2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::ibcinc"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}, {0.`, 0.2`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::ibcinc"]
}, Open  ]],

Cell["This shows a plot of the solution.", "Text",
  CellTags->"NDSolve::ibcinc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      Evaluate[f[x, t] /. sol[\([1]\)]], {t, 0, 0.2}, {x, 0, 1}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"NDSolve::ibcinc"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"NDSolve::ibcinc"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["sol", "MR"],
  "."
}], "Text",
  CellTags->"NDSolve::ibcinc"],

Cell[BoxData[
    \(Clear[sol]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"NDSolve::ibcinc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::pdnbc", "ObjectNameWarningMessages",
  CellTags->"NDSolve::pdnbc"],

Cell[BoxData[
    \(NDSolve::"pdnbc" \(\(:\)\(\ \)\) 
      "Mixed periodic and Dirichlet/Neumann boundary conditions not allowed."\
\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::pdnbc"],

Cell["\<\
\[FilledSmallSquare] Generated when periodic boundary conditions \
are used together with other types of boundary conditions in specifying the \
solution of a partial differential equation.\
\>", "Notes",
  CellTags->"NDSolve::pdnbc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::pdnbc"],

Cell["\<\
A error occurs in this example because of the combination of the \
periodic boundary condition and another type of boundary condition.\
\>", \
"Text",
  CellTags->"NDSolve::pdnbc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 2]\)[f]\)[x, t], f[0, t] == f[1, t], 
        f[0, t] == 0, \(\(Derivative[0, 1]\)[f]\)[x, 0] == 0, 
        f[x, 0] == x \((1 - x)\)}, f, {x, 0, 1}, {t, 0, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::pdnbc"],

Cell[BoxData[
    \(NDSolve::"pdnbc" \(\(:\)\(\ \)\) 
      "Mixed periodic and Dirichlet/Neumann boundary conditions not allowed."\
\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::pdnbc"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 2)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(f[0, t] \[Equal] f[1, t]\), ",", \(f[0, t] \[Equal] 0\), 
            ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, 0\), "]"}], "\[Equal]", 
              "0"}], ",", \(f[x, 0] \[Equal] \((1 - x)\)\ x\)}], "}"}], ",", 
        "f", ",", \({x, 0, 1}\), ",", \({t, 0, 3}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::pdnbc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::eerr", "ObjectNameWarningMessages",
  CellTags->"NDSolve::eerr"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NDSolve::"eerr"\), \(\(:\)\(\ \)\), 
        RowBox[{"Warning", ":", " ", 
          RowBox[{
          "Scaled", " ", "local", " ", "spatial", " ", "error", " ", 
            "estimate", " ", "of", " ", 
            StyleBox["err",
              "TI"], " ", "at", " ", 
            StyleBox["var1",
              "TI"]}]}]}], " ", "=", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "in", " ", "the", " ", "direction", " ", "of", " ", 
        "independent", " ", "variable", " ", 
        StyleBox["var2",
          "TI"], " ", "is", " ", "much", " ", "greater", " ", "than", " ", 
        "prescribed", " ", "error", " ", \(tolerance . \ Grid\), " ", 
        "spacing", " ", "with", " ", 
        StyleBox["n",
          "TI"], " ", "points", " ", "may", " ", "be", " ", "too", " ", 
        "large", " ", "to", " ", "achieve", " ", "the", " ", "desired", " ", 
        "accuracy", " ", "or", " ", \(precision . \ \ A\), " ", "singularity",
         " ", "may", " ", "have", " ", "formed", " ", "or", " ", "you", " ", 
        "may", " ", "want", " ", "to", " ", "specify", " ", "a", " ", 
        "smaller", " ", "grid", " ", "spacing", " ", "using", " ", "the", " ",
         "MaxStepSize", " ", "or", " ", "MinPoints", 
        " ", \(\(options\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::eerr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by excessive numerical error while solving  \
a partial differential equation.\n\[FilledSmallSquare] This error can  \
sometimes be avoided by reducing the value of the ",
  StyleBox["StartingStepSize", "MR"],
  " option to increase the number of grid points, or by lowering the value of \
 the ",
  StyleBox["AccuracyGoal", "MR"],
  " or ",
  StyleBox["PrecisionGoal", "MR"],
  " option to increase the error tolerance."
}], "Notes",
  CellTags->"NDSolve::eerr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::eerr"],

Cell["\<\
A warning is generated in this example because the default choice \
for grid spacing is not sufficient for computing a solution to within the \
default error tolerance.\
\>", "Text",
  CellTags->"NDSolve::eerr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
              t] == \(\(Derivative[0, 2]\)[f]\)[x, t], \n\t\tf[0, t] == 0, 
          f[1, t] == 0, \(\(Derivative[0, 1]\)[f]\)[x, 0] == 0, 
          f[x, 0] == x \((1 - x)\)}, f, {x, 0, 1}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::eerr"],

Cell[BoxData[
    \(NDSolve::"eerr" \(\(:\)\(\ \)\) 
      "Warning: Scaled local spatial error estimate of \
\!\(17.561925967711694`\) at \!\(t\) = \!\(1.`\) in the direction of \
independent variable \!\(x\) is much greater than prescribed error tolerance. \
Grid spacing with \!\(15\) points may be too large to achieve the desired \
accuracy or precision.  A singularity may have formed or you may want to \
specify a smaller grid spacing using the MaxStepSize or MinPoints \
options."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::eerr"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}, {0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::eerr"]
}, Open  ]],

Cell[TextData[{
  "This error can be avoided by lowering the value of the ",
  StyleBox["PrecisionGoal", "MR"],
  " option, which raises the error tolerance."
}], "Text",
  CellTags->"NDSolve::eerr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
              t] == \(\(Derivative[0, 2]\)[f]\)[x, t], \n\t\tf[0, t] == 0, 
          f[1, t] == 0, \(\(Derivative[0, 1]\)[f]\)[x, 0] == 0, 
          f[x, 0] == x \((1 - x)\)}, f, {x, 0, 1}, {t, 0, 1}, 
        PrecisionGoal \[Rule] 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::eerr"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}, {0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::eerr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DSolve::ndord
NDSolve::ndord
NDSolve`Reinitialize::ndord\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ndord\"\>"}], ":", " ", 
      RowBox[{
        RowBox[{"Derivative", " ", "order", " ", 
          StyleBox["expr",
            "TI"], " ", "in", " ", "term", " ", 
          StyleBox["expr",
            "TI"], " ", "should", " ", "be", " ", "a", " ", "non"}], 
        "-", \(negative\ machine\), 
        "-", \(sized\ \(\(integer\)\(.\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],

Cell["\<\
\[FilledSmallSquare] Generated when the order of the derivative in \
a differential equation is not an integer.\
\>", "Notes",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],

Cell[TextData[{
  "An error occurs in this example because of an incorrect use of ",
  StyleBox["Derivative", "MR"],
  " in the input."
}], "Text",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[f]\)[f]\)[x] == f[x], f[1] == 1}, 
      f, {x, 1, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],

Cell[BoxData[
    RowBox[{\(NDSolve::"ndord"\), \(\(:\)\(\ \)\), "\<\"Derivative order \
\\!\\(f\\) in term \\!\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", TagBox[\\((f)\\), \
Derivative], Rule[MultilineFunction, None]]\\)\\)[x]\\) should be a \
non-negative machine-sized integer.\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((f)\),
                    Derivative],
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(f[x]\)}], ",", \(f[1] \[Equal] 1\)}], "}"}], ",", 
        "f", ",", \({x, 1, 2}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid specification of a derivative in the input to ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Text",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[1]\)[f]\)[x] == f[x], f[1] == 1}, 
      f, {x, 1, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{1.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndnum", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndnum"],

Cell[BoxData[
    RowBox[{\(NDSolve::"ndnum"\), ":", " ", 
      RowBox[{
        RowBox[{\(Encountered\ non\), "-", 
          RowBox[{
          "numerical", " ", "value", " ", "for", " ", "a", " ", "derivative", 
            " ", "at", " ", 
            StyleBox["var",
              "TI"]}]}], " ", "==", " ", 
        RowBox[{
          StyleBox["val",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::ndnum"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when non-numerical expressions are  \
encountered in a differential equation.\n\[FilledSmallSquare] The cause of  \
this error can usually be determined by checking the form of the first  \
argument in ",
  StyleBox["NDSolve", "MR"],
  " and verifying that numerical values have been assigned to all symbolic  \
parameters.\n\[FilledSmallSquare] Non-numerical expressions can often be  \
found by replacing the variable, the solution, and all of the derivatives in  \
the input with random or typical values and looking for non-numerical  \
expressions in the result.\n\[FilledSmallSquare] If you are unable to  \
determine the cause of this message, please send your example to Technical  \
Support."
}], "Notes",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::ndnum"],

Cell["\<\
An error occurs in this example because the input contains a \
symbolic parameter that does not have a numerical value.\
\>", "Text",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[x] == c\ f[x], f[1] == 1}, f, {x, 1, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::ndnum"],

Cell[BoxData[
    \(NDSolve::"ndnum" \(\(:\)\(\ \)\) 
      "Encountered non-numerical value for a derivative at \!\(x\) == \!\(1.`\
\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ndnum"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(c\ f[x]\)}], ",", \(f[1] \[Equal] 1\)}], "}"}], 
        ",", "f", ",", \({x, 1, 2}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::ndnum"]
}, Open  ]],

Cell["\<\
The calculation is successful after a numerical value is assigned \
for the parameter.\
\>", "Text",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{c\  = \ 1.7}, 
      sol = NDSolve[{\(f'\)[x] == c\ f[x], f[1] == 1}, 
          f, {x, 1, 2}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::ndnum"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{1.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::ndnum"]
}, Open  ]],

Cell["Evaluation of this input will give a plot of the solution.", "Text",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[f[x] /. sol[\([1]\)]], {x, 1, 2}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"NDSolve::ndnum"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"NDSolve::ndnum"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["sol", "MR"],
  "."
}], "Text",
  CellTags->"NDSolve::ndnum"],

Cell[BoxData[
    \(Clear[sol]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"NDSolve::ndnum"],

Cell["\<\
This example generates an error because the initial condition \
depends on the wrong variable.\
\>", "Text",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 1]\)[f]\)[x, t], f[0, t] == 0, 
        f[1, t] == 0, f[x, 0] == t \((1 - t)\)}, 
      f, {x, 0, 1}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"NDSolve::ndnum"],

Cell[BoxData[
    \(NDSolve::"ndnum" \(\(:\)\(\ \)\) 
      "Encountered non-numerical value for a derivative at \!\(t\) == \!\(0.`\
\)."\)], "Message",
  CellLabel->"From In[5]:=",
  CellTags->"NDSolve::ndnum"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(f[0, t] \[Equal] 0\), ",", \(f[1, t] \[Equal] 0\), 
            ",", \(f[x, 0] \[Equal] \((1 - t)\)\ t\)}], "}"}], ",", "f", 
        ",", \({x, 0, 1}\), ",", \({t, 0, 1}\)}], "]"}]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"NDSolve::ndnum"]
}, Open  ]],

Cell["\<\
This example shows a calculation with a valid initial \
condition.\
\>", "Text",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol\  = 
      NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
              t] == \(\(Derivative[0, 1]\)[f]\)[x, t], f[0, t] == 0, 
          f[1, t] == 0, f[x, 0] == x \((1 - x)\)}, 
        f, {x, 0, 1}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"NDSolve::ndnum"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}, {0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[6]=",
  CellTags->"NDSolve::ndnum"]
}, Open  ]],

Cell["Evaluation of this input will give a plot of the solution.", "Text",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[Evaluate[f[x, t]\  /. \ sol[\([1]\)]], {t, 0, 1}, {x, 0, 1}, 
      PlotRange -> All]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"NDSolve::ndnum"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]=",
  CellTags->"NDSolve::ndnum"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["sol", "MR"],
  "."
}], "Text",
  CellTags->"NDSolve::ndnum"],

Cell[BoxData[
    \(Clear[sol]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"NDSolve::ndnum"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndode", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndode"],

Cell[BoxData[
    \(NDSolve::"ndode" \(\(:\)\(\ \)\) \(Input\ is\ not\ an\ ordinary\ \
differential\ \(\(equation\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::ndode"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the input includes the range of a  \
single variable but ",
  StyleBox["NDSolve", "MR"],
  " is unable to recognize an ordinary differential equation in the first  \
argument.\n\[FilledSmallSquare] This message can be generated by a variety of \
 errors in the input to ",
  StyleBox["NDSolve", "MR"],
  ".  The error can usually be resolved by checking the form of the input."
}], "Notes",
  CellTags->"NDSolve::ndode"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bvals", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvals"],

Cell[BoxData[
    \(NDSolve::"bvals" \(\(:\)\(\ \)\) \(Each\ boundary\ value\ equation\ \
must\ be\ given\ at\ one\ point\ \(\(only\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::bvals"],

Cell["\<\
\[FilledSmallSquare] Generated when the solution function occurs \
with different arguments in the same boundary condition equation.
\[FilledSmallSquare] The boundary value solver is only designed to handle \
conditions that give the value of the solution at a single point.\
\>", \
"Notes",
  CellTags->"NDSolve::bvals"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bvals"],

Cell["\<\
An error occurs in this example because one of the boundary \
condition equations includes the solution function evaluated at two different \
points.\
\>", "Text",
  CellTags->"NDSolve::bvals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(f'\)'\)[x] + f[x] == 0, f[1] == f[2], f[2] == 1}, 
      f, {x, 1, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bvals"],

Cell[BoxData[
    \(NDSolve::"bvals" \(\(:\)\(\ \)\) 
      "Each boundary value equation must be given at one point only."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bvals"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(f[x]\), "+", 
                RowBox[{
                  SuperscriptBox["f", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", 
              "0"}], ",", \(f[1] \[Equal] f[2]\), ",", \(f[2] \[Equal] 1\)}], 
          "}"}], ",", "f", ",", \({x, 1, 2}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bvals"]
}, Open  ]],

Cell["\<\
This shows a valid specification of a boundary value problem.\
\>", \
"Text",
  CellTags->"NDSolve::bvals"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(f'\)'\)[x] + f[x] == 0, f[1] == 1, f[2] == 1}, 
      f, {x, 1, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::bvals"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{1.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::bvals"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ntdv", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ntdv"],

Cell[BoxData[
    \(NDSolve::"ntdv" \(\(:\)\(\ \)\) 
      "Cannot solve to find an explicit formula for the derivatives.  \
Consider using the option setting SolveDelayed->True."\)], "Message",
  CellLabel->"From In[77]:=",
  CellTags->"NDSolve::ntdv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["NDSolve", "MR"],
  " is unable to solve for the derivatives in a differential equation.\n\
\[FilledSmallSquare] ",
  StyleBox["NDSolve", "MR"],
  " uses ",
  StyleBox["Solve", "MR"],
  " to solve symbolically for the derivatives in a differential equation.\n\
\[FilledSmallSquare] This error will occur if the equations do not have a  \
solution, or if it is not possible to solve for the derivatives by algebraic  \
methods.\n\[FilledSmallSquare] In some cases this error can be handled by  \
solving for the derivatives separately and using those solutions in the input \
 to ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Notes",
  CellTags->"NDSolve::ntdv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::ntdv"],

Cell[TextData[{
  "In some versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " an error occurs in this example because this differential equation does \
not have a solution."
}], "Text",
  CellTags->"NDSolve::ntdv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{Sqrt[\(f'\)[x]] == \(-1\), f[1] == 1}, 
      f, {x, 1, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::ntdv"],

Cell[BoxData[
    \(NDSolve::"ntdv" \(\(:\)\(\ \)\) 
      "Cannot solve to find an explicit formula for the derivatives.  \
Consider using the option setting SolveDelayed->True."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ntdv"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SqrtBox[
                RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}]], 
              "\[Equal]", \(-1\)}], ",", \(f[1] \[Equal] 1\)}], "}"}], ",", 
        "f", ",", \({x, 1, 2}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::ntdv"]
}, Open  ]],

Cell["\<\
This calculation fails because the equation to be solved for the \
derivative cannot be solved by algebraic methods.\
\>", "Text",
  CellTags->"NDSolve::ntdv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[x] == Cos[\(f'\)[x]], f[1] == 1}, 
      f, {x, 1, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::ntdv"],

Cell[BoxData[
    \(Solve::"tdep" \(\(:\)\(\ \)\) 
      "The equations appear to involve the variables to be solved for in an \
essentially non-algebraic way."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"NDSolve::ntdv"],

Cell[BoxData[
    \(NDSolve::"ntdv" \(\(:\)\(\ \)\) 
      "Cannot solve to find an explicit formula for the derivatives.  \
Consider using the option setting SolveDelayed->True."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"NDSolve::ntdv"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], "\[Equal]", 
              RowBox[{"Cos", "[", 
                RowBox[{
                  SuperscriptBox["f", "\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}], "]"}]}], 
            ",", \(f[1] \[Equal] 1\)}], "}"}], ",", "f", ",", \({x, 1, 2}\)}],
       "]"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::ntdv"]
}, Open  ]],

Cell[TextData[{
  "This example can be handled by solving numerically for the derivative and  \
using that solution in the input to ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Text",
  CellTags->"NDSolve::ntdv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[
            x] == \((\(f'\)[x] /. 
              FindRoot[\(f'\)[x] == Cos[\(f'\)[x]], {\(f'\)[x], 1, 2}])\), 
        f[1] == 1}, f, {x, 1, 2}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"NDSolve::ntdv"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{1.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"NDSolve::ntdv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bcedge", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bcedge"],

Cell[BoxData[
    RowBox[{\(NDSolve::"bcedge"\), \(\(:\)\(\ \)\), "Boundary", " ", 
      "condition", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "specified", " ", "on", " ", "a", 
      " ", "single", " ", "edge", " ", "of", " ", "the", " ", "boundary", " ",
       "of", " ", "the", " ", "computational", 
      " ", \(\(domain\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::bcedge"],

Cell["\<\
\[FilledSmallSquare] Generated when the boundary conditions in the \
specification of the solution of a partial differential equation are given at \
points that are not on the edge of the domain of the solution.\
\>", "Notes",
  CellTags->"NDSolve::bcedge"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bcedge"],

Cell["\<\
An error occurs in this example because one of the boundary \
conditions does not fall on the edge of the solution domain.\
\>", "Text",
  CellTags->"NDSolve::bcedge"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 1]\)[f]\)[x, t], f[0, t] == 0, 
        f[2, t] == 4, f[x, 0] == x^2}, f, {x, 1, 2}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bcedge"],

Cell[BoxData[
    \(NDSolve::"bcedge" \(\(:\)\(\ \)\) 
      "Boundary condition \!\(\(\(f[\(\(2, t\)\)]\)\) \[Equal] 4\) is not \
specified on a single edge of the boundary of the computational domain."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bcedge"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(f[0, t] \[Equal] 0\), ",", \(f[2, t] \[Equal] 4\), 
            ",", \(f[x, 0] \[Equal] x\^2\)}], "}"}], ",", "f", 
        ",", \({x, 1, 2}\), ",", \({t, 0, 1}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bcedge"]
}, Open  ]],

Cell["\<\
This shows a valid specification of a solution of this partial \
differential equation.\
\>", "Text",
  CellTags->"NDSolve::bcedge"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 1]\)[f]\)[x, t], f[0, t] == 0, 
        f[2, t] == 4, f[x, 0] == x^2}, f, {x, 0, 2}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::bcedge"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 2.`}, {0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::bcedge"]
}, Open  ]],

Cell[TextData[{
  "This input will generate a warning message because of the condition on ",
  StyleBox["f[0,0]", "MR"],
  "."
}], "Text",
  CellTags->"NDSolve::bcedge"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(sol = 
        NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
                t] == \(\(Derivative[0, 2]\)[f]\)[x, t], \n\t\tf[0, 0] == 0, 
            f[1, t] == 0, f[x, 0] == x \((x - 1)\), 
            f[0, t] == 0, \n\t\t\(\(Derivative[0, 1]\)[f]\)[x, 0] == 0}, 
          f, {x, 0, 1}, {t, 0, 4}];\)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"NDSolve::bcedge"],

Cell[BoxData[
    \(NDSolve::"bcedge" \(\(:\)\(\ \)\) 
      "Boundary condition \!\(\(\(f[\(\(0, 0\)\)]\)\) \[Equal] 0\) is not \
specified on a single edge of the boundary of the computational domain."\)], \
"Message",
  CellLabel->"From In[3]:=",
  CellTags->"NDSolve::bcedge"]
}, Open  ]],

Cell[TextData[{
  "The problem can be resolved in this example by simply discarding the  \
condition on ",
  StyleBox["f[0,0]", "MR"],
  ", since this condition is redundant with other equations in the input."
}], "Text",
  CellTags->"NDSolve::bcedge"],

Cell[BoxData[
    \(\(sol = 
        NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
                t] == \(\(Derivative[0, 2]\)[f]\)[x, t], \n\t\tf[1, t] == 0, 
            f[x, 0] == x \((x - 1)\), 
            f[0, t] == 0, \n\t\t\(\(Derivative[0, 1]\)[f]\)[x, 0] == 0}, 
          f, {x, 0, 1}, {t, 0, 4}];\)\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"NDSolve::bcedge"],

Cell["\<\
Evaluation of this input will show a plot of the solution.  The \
result corresponds to oscillations of a string with fixed endpoints.\
\>", \
"Text",
  CellTags->"NDSolve::bcedge"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      Evaluate[f[x, t] /. sol[\([1]\)]], {x, 0, 1}, {t, 0, 4}]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"NDSolve::bcedge"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"NDSolve::bcedge"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndsss", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndsss"],

Cell[BoxData[
    RowBox[{\(NDSolve::"ndsss"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\ \
StartingStepSize\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ Positive\ real\ number\ or\ \
\(\(Automatic\)\(.\)\)\)\)}]], "Message",
  CellTags->"NDSolve::ndsss"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["StartingStepSize", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->"NDSolve::ndsss"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::ndsss"],

Cell[TextData[{
  "The value of the ",
  StyleBox["StartingStepSize", "MR"],
  " option cannot be a symbol."
}], "Text",
  CellTags->"NDSolve::ndsss"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[x] == f[x], f[1] == 1}, f, {x, 1, 2}, 
      StartingStepSize -> x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::ndsss"],

Cell[BoxData[
    \(NDSolve::"ndsss" \(\(:\)\(\ \)\) 
      "Value of option StartingStepSize -> \!\(x\) is not a Positive real \
number or Automatic."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ndsss"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(f[x]\)}], ",", \(f[1] \[Equal] 1\)}], "}"}], ",", 
        "f", ",", \({x, 1, 2}\), ",", \(StartingStepSize \[Rule] x\)}], 
      "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::ndsss"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["StartingStepSize", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::ndsss"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[x] == f[x], f[1] == 1}, f, {x, 1, 2}, 
      StartingStepSize -> 0.1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::ndsss"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{1.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::ndsss"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::mxst", "ObjectNameWarningMessages",
  CellTags->"NDSolve::mxst"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NDSolve::"mxst"\), \(\(:\)\(\ \)\), "Maximum", " ", "number", 
        " ", "of", " ", 
        StyleBox["n",
          "TI"], " ", "steps", " ", "reached", " ", "at", " ", "the", " ", 
        "point", " ", 
        StyleBox["var",
          "TI"]}], " ", "==", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::mxst"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of steps used in solving a  \
differential equation exceeds the value specified by the ",
  StyleBox["MaxSteps", "MR"],
  " option.\n\[FilledSmallSquare] This message can be generated if the  \
solution has many features or oscillations that must be resolved, or if the  \
solution has a sharp or singular feature that can be represented only with  \
very fine resolution.\n\[FilledSmallSquare] Difficulties associated with this \
 error can usually be resolved by increasing the value of the ",
  StyleBox["MaxSteps", "MR"],
  " option, or by lowering the values of the ",
  StyleBox["AccuracyGoal", "MR"],
  " or ",
  StyleBox["PrecisionGoal", "MR"],
  " options."
}], "Notes",
  CellTags->"NDSolve::mxst"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::mxst"],

Cell["\<\
A large number of steps is needed to construct a solution through \
all of the oscillations in this example.\
\>", "Text",
  CellTags->"NDSolve::mxst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(f'\)'\)[x] + f[x] == 0, f[0] == 0, \(f'\)[0] == 1}, 
      f, {x, 0, 50}, MaxSteps -> 100]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::mxst"],

Cell[BoxData[
    \(NDSolve::"mxst" \(\(:\)\(\ \)\) 
      "Maximum number of \!\(100\) steps reached at the point \!\(x\) == \
\!\(9.907632260522195`\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::mxst"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{0.`, 9.907632260522195`}}, "<>"]\),
            
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::mxst"]
}, Open  ]],

Cell["This error can be avoided by increasing the number of steps.", "Text",
  CellTags->"NDSolve::mxst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      NDSolve[{\(\(f'\)'\)[x] + f[x] == 0, f[0] == 0, \(f'\)[0] == 1}, 
        f, {x, 0, 50}, MaxSteps -> 500]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::mxst"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 50.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::mxst"]
}, Open  ]],

Cell["\<\
This shows a plot of the solution.  The exact solution is a sine \
function.\
\>", "Text",
  CellTags->"NDSolve::mxst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[f[x] /. sol], {x, 0, 50}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"NDSolve::mxst"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"NDSolve::mxst"]
}, Open  ]],

Cell["\<\
This error can also be avoided by lowering the error tolerances.  \
With this change, the solution will be computed in fewer steps, but the \
solution will not be as accurate.\
\>", "Text",
  CellTags->"NDSolve::mxst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      NDSolve[{\(\(f'\)'\)[x] + f[x] == 0, f[0] == 0, \(f'\)[0] == 1}, 
        f, {x, 0, 50}, MaxSteps -> 100, AccuracyGoal -> 2]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"NDSolve::mxst"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 50.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[4]=",
  CellTags->"NDSolve::mxst"]
}, Open  ]],

Cell["\<\
A plot of the solution shows the effect of using low error \
tolerances.\
\>", "Text",
  CellTags->"NDSolve::mxst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[Evaluate[f[x] /. sol], {x, 0, 50}]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"NDSolve::mxst"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"NDSolve::mxst"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["sol", "MR"],
  "."
}], "Text",
  CellTags->"NDSolve::mxst"],

Cell[BoxData[
    \(Clear[sol]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"NDSolve::mxst"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bcnan", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bcnan"],

Cell[BoxData[
    \(NDSolve::"bcnan" \(\(:\)\(\ \)\) 
      Boundary\ conditions\ not\ \(\(numerical\)\(.\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::bcnan"],

Cell["\<\
\[FilledSmallSquare] Generated when the boundary conditions in a \
boundary value problem are not properly specified.\
\>", "Notes",
  CellTags->"NDSolve::bcnan"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bcnan"],

Cell["\<\
This example will generate a message because one of the boundary \
conditions involves the variable of the differential equation.\
\>", "Text",
  CellTags->"NDSolve::bcnan"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(f'\)'\)[x] + f[x] == 0, f[1] == x, f[2] == 1}, 
      f, {x, 1, 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bcnan"],

Cell[BoxData[
    \(NDSolve::"bcnan" \(\(:\)\(\ \)\) 
      "Boundary conditions not numerical."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bcnan"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(f[x]\), "+", 
                RowBox[{
                  SuperscriptBox["f", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", 
              "0"}], ",", \(f[1] \[Equal] x\), ",", \(f[2] \[Equal] 1\)}], 
          "}"}], ",", "f", ",", \({x, 1, 2}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bcnan"]
}, Open  ]],

Cell["\<\
This shows a valid specification of a boundary value problem.\
\>", \
"Text",
  CellTags->"NDSolve::bcnan"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(f'\)'\)[x] + f[x] == 0, f[1] == 1, f[2] == 1}, 
      f, {x, 1, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::bcnan"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{1.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::bcnan"]
}, Open  ]],

Cell["\<\
An error occurs in this example because a parameter in one of the \
boundary conditions does not have a numerical value.\
\>", "Text",
  CellTags->"NDSolve::bcnan"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(f'\)'\)[x] + f[x] == 0, f[0] == 0, b\ f[1] == 1}, 
      f, {x, 0, 1}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"NDSolve::bcnan"],

Cell[BoxData[
    \(NDSolve::"bcnan" \(\(:\)\(\ \)\) 
      "Boundary conditions not numerical."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"NDSolve::bcnan"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(f[x]\), "+", 
                RowBox[{
                  SuperscriptBox["f", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "x", "]"}]}], "\[Equal]", 
              "0"}], ",", \(f[0] \[Equal] 0\), ",", \(b\ f[1] \[Equal] 1\)}], 
          "}"}], ",", "f", ",", \({x, 0, 1}\)}], "]"}]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"NDSolve::bcnan"]
}, Open  ]],

Cell["\<\
This shows a valid specification of the solution of a boundary \
value problem.\
\>", "Text",
  CellTags->"NDSolve::bcnan"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{b = 2}, 
      NDSolve[{\(\(f'\)'\)[x] + f[x] == 0, f[0] == 0, b\ f[1] == 1}, 
        f, {x, 0, 1}]]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"NDSolve::bcnan"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[4]=",
  CellTags->"NDSolve::bcnan"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bcsol", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bcsol"],

Cell[BoxData[
    \(NDSolve::"bcsol" \(\(:\)\(\ \)\) 
      "Could not solve for equations at boundary points from the boundary \
conditions."\)], "Message",
  CellLabel->"From In[37]:=",
  CellTags->"NDSolve::bcsol"],

Cell["\<\
\[FilledSmallSquare] Generated when the partial differential \
equation solver is unable to solve algebraically for the boundary conditions \
needed to compute a solution.\
\>", "Notes",
  CellTags->"NDSolve::bcsol"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::depvr", "ObjectNameWarningMessages",
  CellTags->"NDSolve::depvr"],

Cell[BoxData[
    \(NDSolve::"depvr" \(\(:\)\(\ \)\) \(The\ dependent\ variable\ cannot\ be\
\ found\ in\ the\ \(\(equation\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::depvr"],

Cell["\<\
\[FilledSmallSquare] Generated when the boundary value problem \
solver cannot find the variable in the differential equation that is to be \
solved.
\[FilledSmallSquare] If you see this message in an example where it is not \
expected, please contact Technical Support.\
\>", "Notes",
  CellTags->"NDSolve::depvr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bddo", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bddo"],

Cell[BoxData[
    \(NDSolve::"bddo" \(\(:\)\(\ \)\) 
      "Value of option DifferenceOrder->`1` should be a positive integer or \
\"Pseudospectral\"."\)], "Message",
  CellLabel->"From In[22]:=",
  CellTags->"NDSolve::bddo"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["DifferenceOrder", "MR"],
  " option in ",
  StyleBox["NDSolve", "MR"],
  " does not have the expected form.\n\[FilledSmallSquare] ",
  StyleBox["DifferenceOrder", "MR"],
  " is an option used within methods available to ",
  StyleBox["NDSolve", "MR"],
  ", rather than an option to ",
  StyleBox["NDSolve", "MR"],
  " itself."
}], "Notes",
  CellTags->"NDSolve::bddo"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bddo"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["DifferenceOrder", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::bddo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] {"\<TensorProductGrid\>", \ 
              DifferenceOrder \[Rule] None}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bddo"],

Cell[BoxData[
    \(NDSolve::"bddo" \(\(:\)\(\ \)\) 
      "Value of option DifferenceOrder->\!\(None\) should be a positive \
integer or \"Pseudospectral\"."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bddo"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(u[x, 0] \[Equal] \[ExponentialE]\^\(\(-100\)\ x\^2\)\), 
            ",", \(u[\(-1\), t] \[Equal] u[1, t]\)}], "}"}], ",", "u", 
        ",", \({x, \(-1\), 1}\), ",", \({t, 2}\), 
        ",", \(Method \[Rule] {"MethodOfLines", 
            "SpatialDiscretization" \[Rule] {"TensorProductGrid", 
                DifferenceOrder \[Rule] None}}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bddo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::mxsst", "ObjectNameWarningMessages",
  CellTags->"NDSolve::mxsst"],

Cell[BoxData[
    \(NDSolve::"mxsst" \(\(:\)\(\ \)\) 
      "Using maximum number of grid points `1` allowed by the MaxPoints or \
MinStepSize options for independent variable `2`."\)], "Message",
  CellLabel->"From In[23]:=",
  CellTags->"NDSolve::mxsst"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of grid points used by the  \
partial differential equation solver is the number specified in the value of  \
the ",
  StyleBox["MaxSteps", "MR"],
  " option rather than the number that would have been chosen by default.\n\
\[FilledSmallSquare] This warning is normally seen only if the solution to a  \
partial differential equation has sharp or oscillating features, or when  \
using relatively small values in the ",
  StyleBox["MaxSteps", "MR"],
  " option."
}], "Notes",
  CellTags->"NDSolve::mxsst"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::mxsst"],

Cell[TextData[{
  "A warning message is generated in this example because the sharp feature \
in the initial condition cannot be handled reliably with the number of grid \
points specified by the ",
  StyleBox["MaxSteps", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::mxsst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      MaxSteps \[Rule] {15, \ Infinity}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::mxsst"],

Cell[BoxData[
    \(NDSolve::"mxsst" \(\(:\)\(\ \)\) 
      "Using maximum number of grid points \!\(15\) allowed by the MaxPoints \
or MinStepSize options for independent variable \!\(x\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::mxsst"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{"...", \(-1.`\), 1.`, 
                  "..."}, {0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::mxsst"]
}, Open  ]],

Cell[TextData[{
  "The error can be avoided in this example by omitting the setting for the \
",
  StyleBox["MaxSteps", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::mxsst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, 
      u, {x, \(-1\), 1}, {t, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::mxsst"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{"...", \(-1.`\), 1.`, 
                  "..."}, {0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::mxsst"]
}, Open  ]],

Cell[TextData[{
  "A warning message is generated in this example because the sharp feature \
in the initial condition cannot be handled reliably with the number of grid \
points specified by the ",
  StyleBox["MaxSteps", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::mxsst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] {"\<TensorProductGrid\>", \ MaxPoints \[Rule] 15}}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"NDSolve::mxsst"],

Cell[BoxData[
    \(NDSolve::"mxsst" \(\(:\)\(\ \)\) 
      "Using maximum number of grid points \!\(15\) allowed by the MaxPoints \
or MinStepSize options for independent variable \!\(x\)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"NDSolve::mxsst"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{"...", \(-1.`\), 1.`, 
                  "..."}, {0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"NDSolve::mxsst"]
}, Open  ]],

Cell[TextData[{
  "The error can be avoided in this example by omitting the setting for the \
",
  StyleBox["MaxSteps", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::mxsst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] {"\<TensorProductGrid\>"}}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"NDSolve::mxsst"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{"...", \(-1.`\), 1.`, 
                  "..."}, {0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[4]=",
  CellTags->"NDSolve::mxsst"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndmss", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndmss"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NDSolve::"ndmss"\), \(\(:\)\(\ \)\), "Value", " ", "of", " ", 
        "option", " ", 
        StyleBox["opt",
          "TI"]}], " ", "->", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "positive", " ", 
        "real", " ", "number", " ", "or", 
        " ", \(\(Infinity\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::ndmss"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MaxStepSize", "MR"],
  " option does not have the indicated form."
}], "Notes",
  CellTags->"NDSolve::ndmss"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::ndmss"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["MaxStepSize", "MR"],
  " option cannot be zero."
}], "Text",
  CellTags->"NDSolve::ndmss"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[x] == f[x], f[1] == 1}, f, {x, 1, 10}, 
      MaxStepSize -> 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::ndmss"],

Cell[BoxData[
    \(NDSolve::"ndmss" \(\(:\)\(\ \)\) 
      "Value of option \!\(MaxStepSize\) -> \!\(0.`\) is not a positive real \
number or Infinity."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ndmss"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(f[x]\)}], ",", \(f[1] \[Equal] 1\)}], "}"}], ",", 
        "f", ",", \({x, 1, 10}\), ",", \(MaxStepSize \[Rule] 0\)}], 
      "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::ndmss"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bdmtd", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bdmtd"],

Cell[BoxData[
    \(NDSolve::"bdmtd" \(\(:\)\(\ \)\) 
      "The value of the option Method->`1` is not a known built-in method, a \
symbol which could be a user-defined method, or a list with a name followed \
by method options."\)], "Message",
  CellLabel->"From In[23]:=",
  CellTags->"NDSolve::bdmtd"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::bdmtd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndsz", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndsz"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NDSolve::"ndsz"\), \(\(:\)\(\ \)\), \(\(At\)\(\ \)\), 
        StyleBox["var",
          "TI"], \(\(\ \)\(\(==\)\(\ \)\)\), 
        StyleBox["val",
          "TI"], \(\(,\)\(\ \)\(step\ size\ is\ effectively\ zero\)\)}], ";", 
      " ", \(singularity\ or\ stiff\ system\ \(\(suspected\)\(.\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::ndsz"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the adaptive algorithm used by ",
  StyleBox["NDSolve", "MR"],
  " requires a step size that is too small for numerically reliable \
calculations."
}], "Notes",
  CellTags->"NDSolve::ndsz"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::ndsz"],

Cell["\<\
An error occurs in this example because the solution is singular.\
\
\>", "Text",
  CellTags->"NDSolve::ndsz"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\((2 - f[x])\) \(f'\)[x] == f[x], f[0] == 1}, 
      f, {x, 0, 5}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::ndsz"],

Cell[BoxData[
    \(NDSolve::"ndsz" \(\(:\)\(\ \)\) 
      "At \!\(x\) == \!\(0.3862940268757767`\), step size is effectively \
zero; singularity or stiff system suspected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ndsz"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{0.`, 0.3862940268757767`}}, 
              "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::ndsz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::pdord", "ObjectNameWarningMessages",
  CellTags->"NDSolve::pdord"],

Cell[BoxData[
    \(NDSolve::"pdord" \(\(:\)\(\ \)\) \(Some\ of\ the\ functions\ have\ zero\
\ differential\ order\ so\ the\ equations\ will\ be\ solved\ as\ a\ system\ \
of\ differential - algebraic\ \(\(equations\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::pdord"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the equations do not include \
derivatives of one or more of the functions specified in the second argument \
of ",
  StyleBox["NDSolve", "MR"],
  ".\n\[FilledSmallSquare] This message does not necessarily indicate an \
error."
}], "Notes",
  CellTags->"NDSolve::pdord"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::pdord"],

Cell[TextData[{
  "A message is generated in this example because there are no derivatives of \
",
  StyleBox["y[t]", "MR"],
  " in the equations."
}], "Text",
  CellTags->"NDSolve::pdord"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x'\)[t]\  \[Equal] \ 2\ y[t], \ \(x'\)[t]\  \[Equal] \ 
          1\  - \ y[t], x[0]\  \[Equal] \ 1}, {x, y}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::pdord"],

Cell[BoxData[
    \(NDSolve::"pdord" \(\(:\)\(\ \)\) 
      "Some of the functions have zero differential order so the equations \
will be solved as a system of differential-algebraic equations."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::pdord"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"x", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"y", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::pdord"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::precw", "ObjectNameWarningMessages",
  CellTags->"NDSolve::precw"],

Cell[BoxData[
    \(NDSolve::"precw" \(\(:\)\(\ \)\) \(The\ precision\ of\ the\ \
differential\ equation\ \((`1`)\)\ is\ less\ than\ WorkingPrecision\ \
\(\((`2`)\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::precw"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["WorkingPrecision", "MR"],
  " option exceeds the precision of the least precise number in the \
differential equations."
}], "Notes",
  CellTags->"NDSolve::precw"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::precw"],

Cell[TextData[{
  "An error is generated in this example because the precision of the machine \
number in the equations is less than the value of the ",
  StyleBox["WorkingPrecision", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::precw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[x] \[Equal] 1.3\ f[x], f[1] \[Equal] 1}, f, {x, 1, 2}, 
      WorkingPrecision \[Rule] 50]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::precw"],

Cell[BoxData[
    RowBox[{\(NDSolve::"precw"\), \(\(:\)\(\ \)\), "\<\"The precision of the \
differential equation (\\!\\({\\(\\(\\(\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", \
\\\"\[Prime]\\\", Rule[MultilineFunction, None]]\\)\\)[x]\\)\\) \[Equal] \
\\(\\(1.3`\\\\ \\(\\(f[x]\\)\\)\\)\\)\\)\\), \\(\\(\\(\\(f[1]\\)\\) \[Equal] \
1\\)\\)}\\)) is less than WorkingPrecision (\\!\\(50.`\\)).\"\>"}]], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::precw"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{1.`50. , 2.`50. }}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::precw"]
}, Open  ]],

Cell["\<\
A high-precision result can be computed if the low-precision number \
in the input is reqlaced by an exact number.\
\>", "Text",
  CellTags->"NDSolve::precw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[x] \[Equal] \((13/10)\)\ f[x], f[1] \[Equal] 1}, 
      f, {x, 1, 2}, WorkingPrecision \[Rule] 50, 
      PrecisionGoal \[Rule] 30]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::precw"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{1.`50. , 2.`50. }}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::precw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::acoeffs", "ObjectNameWarningMessages",
  CellTags->"NDSolve::acoeffs"],

Cell[BoxData[
    \(NDSolve::"acoeffs" \(\(:\)\(\ \)\) \(Unable\ to\ automatically\ \
determine\ the\ coefficients\ of\ the\ method\ `1` . \ 
          Try\ specifying\ the\ coefficients\ as\ an\ \
\(\(option\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::acoeffs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::acoeffs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::sprkdm", "ObjectNameWarningMessages",
  CellTags->"NDSolve::sprkdm"],

Cell[BoxData[
    \(NDSolve::"sprkdm" \(\(:\)\(\ \)\) \(The\ dimension\ `1`\ of\ the\ \
differential\ system\ in\ the\ method\ `2`\ is\ not\ \(\(even\)\(.\)\)\)\)], \
"Message",
  CellTags->"NDSolve::sprkdm"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::sprkdm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::sprkqv", "ObjectNameWarningMessages",
  CellTags->"NDSolve::sprkqv"],

Cell[BoxData[
    \(NDSolve::"sprkqv" \(\(:\)\(\ \)\) \(The\ value\ of\ PositionsVariables -> \
`1`\ of\ the\ method\ `2`\ is\ not\ a\ valid\ list\ of\ position\ \
\(\(variables\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::sprkqv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::sprkqv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::sprkpqv", "ObjectNameWarningMessages",
  CellTags->"NDSolve::sprkpqv"],

Cell[BoxData[
    \(NDSolve::"sprkpqv" \(\(:\)\(\ \)\) \(The\ position\ variables\ `1`\ and\
\ momentum\ variables\ `2`\ of\ the\ method\ `3`\ are\ not\ consistent\ with\ \
the\ variables\ `4`\ of\ the\ differential\ \(\(system\)\(.\)\)\)\)], \
"Message",
  CellTags->"NDSolve::sprkpqv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::sprkpqv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::spltdep", "ObjectNameWarningMessages",
  CellTags->"NDSolve::spltdep"],

Cell[BoxData[
    \(NDSolve::"spltdep" \(\(:\)\(\ \)\) \(The\ differential\ system\ `1`\ in\
\ the\ method\ `2`\ depends\ on\ `3`\ which\ is\ ambiguous . \ 
          The\ differential\ system\ should\ be\ in\ autonomous\ \
\(\(form\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::spltdep"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::spltdep"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::spltdim", "ObjectNameWarningMessages",
  CellTags->"NDSolve::spltdim"],

Cell[BoxData[
    \(NDSolve::"spltdim" \(\(:\)\(\ \)\) \(The\ dimensions\ `1`\ of\ the\ \
equations\ in\ the\ method\ `2`\ are\ not\ compatible\ with\ the\ dimensions\ \
`3`\ of\ the\ differential\ \(\(system\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::spltdim"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::spltdim"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::msols", "ObjectNameWarningMessages",
  CellTags->"NDSolve::msols"],

Cell[BoxData[
    \(NDSolve::"msols" \(\(:\)\(\ \)\) \(Multiple\ solutions\ found\ using\ \
DSolve\ in\ the\ method\ \(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::msols"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::msols"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndsol", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndsol"],

Cell[BoxData[
    \(NDSolve::"ndsol" \(\(:\)\(\ \)\) \(No\ solution\ found\ using\ DSolve\ \
in\ the\ method\ \(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::ndsol"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ndsol"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndsnf", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndsnf"],

Cell[BoxData[
    \(NDSolve::"ndsnf" \(\(:\)\(\ \)\) \(Unable\ to\ create\ a\ \
NumericalFunction\ for\ the\ expression\ `1`\ in\ the\ method\ \(\(`2`\)\(.\)\
\)\)\)], "Message",
  CellTags->"NDSolve::ndsnf"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ndsnf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndspe", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndspe"],

Cell[BoxData[
    \(NDSolve::"ndspe" \(\(:\)\(\ \)\) \(Unable\ to\ process\ the\ equations\ \
`1`\ in\ the\ method\ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::ndspe"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ndspe"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::nlst", "ObjectNameWarningMessages",
  CellTags->"NDSolve::nlst"],

Cell[BoxData[
    \(NDSolve::"nlst" \(\(:\)\(\ \)\) \(`1`\ in\ the\ method\ `2`\ is\ not\ a\
\ list\ of\ length\ \(\(`3`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::nlst"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::nlst"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::nfun", "ObjectNameWarningMessages",
  CellTags->"NDSolve::nfun"],

Cell[BoxData[
    \(NDSolve::"nfun" \(\(:\)\(\ \)\) \(`1`\ of\ the\ method\ `2`\ is\ not\ a\
\ \(\(function\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::nfun"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::nfun"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::sfun", "ObjectNameWarningMessages",
  CellTags->"NDSolve::sfun"],

Cell[BoxData[
    \(NDSolve::"sfun" \(\(:\)\(\ \)\) \(Invalid\ simplification\ function\ \
`1`\ in\ the\ method\ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::sfun"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::sfun"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::csymb", "ObjectNameWarningMessages",
  CellTags->"NDSolve::csymb"],

Cell[BoxData[
    \(NDSolve::"csymb" \(\(:\)\(\ \)\) \(Value\ of\ option\ \ `1` -> `2`\ of\ \
the\ method\ `3`\ is\ not\ a\ \(\(symbol\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::csymb"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::csymb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::lsb", "ObjectNameWarningMessages",
  CellTags->"NDSolve::lsb"],

Cell[BoxData[
    \(NDSolve::"lsb" \(\(:\)\(\ \)\) 
      LinearStabilityBoundary\ is\ not\ defined\ for\ \(\(`1`\)\(.\)\)\)], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::lsb"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::lsb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bdord", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bdord"],

Cell[BoxData[
    \(NDSolve::"bdord" \(\(:\)\(\ \)\) \(Boundary\ condition\ `1`\ should\ \
have\ derivatives\ of\ order\ lower\ than\ the\ differential\ order\ of\ the\ \
partial\ differential\ \(\(equation\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::bdord"],

Cell["\<\
\[FilledSmallSquare] Generated when the number of times that a \
function is differentiated with respect to a particular variable is greater \
in a boundary condition than in the differential equation.\
\>", "Notes",
  CellTags->"NDSolve::bdord"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bdord"],

Cell["\<\
An error occurs in this example because the derivative boundary \
condition is specified with respect to the wrong variable.\
\>", "Text",
  CellTags->"NDSolve::bdord"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 1]\)[f]\)[x, t], \n\tf[0, t] == Sin[t], 
        f[x, 0] == 0, \(\(Derivative[0, 1]\)[f]\)[5, t] == 0}, 
      f, {x, 0, 5}, {t, 0, 4\ Pi}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bdord"],

Cell[BoxData[
    RowBox[{\(NDSolve::"bdord"\), \(\(:\)\(\ \)\), "\<\"Boundary condition \
\\!\\(\\(\\(\\*SuperscriptBox[\\\"f\\\", TagBox[\\((0, 1)\\), Derivative], \
Rule[MultilineFunction, None]]\\)\\)[\\(\\(5, t\\)\\)]\\) should have \
derivatives of order lower than the differential order of the partial \
differential equation.\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bdord"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(f[0, t] \[Equal] Sin[t]\), ",", \(f[x, 0] \[Equal] 0\), 
            ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(5, t\), "]"}], "\[Equal]", 
              "0"}]}], "}"}], ",", "f", ",", \({x, 0, 5}\), 
        ",", \({t, 0, 4\ \[Pi]}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bdord"]
}, Open  ]],

Cell["\<\
This shows a valid specification of a solution of this partial \
differential equation.\
\>", "Text",
  CellTags->"NDSolve::bdord"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sol = 
      NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
              t] == \(\(Derivative[0, 1]\)[f]\)[x, t], \n\tf[0, t] == Sin[t], 
          f[x, 0] == 0, \(\(Derivative[1, 0]\)[f]\)[5, t] == 0}, 
        f, {x, 0, 5}, {t, 0, 4\ Pi}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::bdord"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{0.`, 5.`}, {0.`, 
                  12.566370614359172`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::bdord"]
}, Open  ]],

Cell["This shows a plot of the solution.", "Text",
  CellTags->"NDSolve::bdord"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot3D[
      Evaluate[f[x, t] /. sol[\([1]\)]], {x, 0, 5}, {t, 0, 4\ Pi}]\)], "Input",\

  CellLabel->"In[3]:=",
  CellTags->"NDSolve::bdord"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"NDSolve::bdord"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["sol", "MR"],
  "."
}], "Text",
  CellTags->"NDSolve::bdord"],

Cell[BoxData[
    \(Clear[sol]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"NDSolve::bdord"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::nostep", "ObjectNameWarningMessages",
  CellTags->"NDSolve::nostep"],

Cell[BoxData[
    \(NDSolve::"nostep" \(\(:\)\(\ \)\) \(\(\ \)\(The\ method\ specified\ by\ \
Method\  -> \ `1`\ is\ not\ a\ known\ built - 
          in\ method\ and\ has\ not\ been\ properly\ set\ up\ as\ a\ user - 
          defined\ method\ with\ a\ Step\ \(\(function\)\(.\)\)\)\)\)], \
"Message",
  CellTags->"NDSolve::nostep"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a user-defined method does not include \
a ",
  StyleBox["Step", "MR"],
  " function."
}], "Notes",
  CellTags->"NDSolve::nostep"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bdstep", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bdstep"],

Cell[BoxData[
    \(NDSolve::"bdstep" \(\(:\)\(\ \)\) \(The\ Step\ function\ for\ the\ \
Method\  -> \ `1`\ returned\ `2`\ which\ is\ not\ an\ acceptable\ \
\(\(form\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::bdstep"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the result from the ",
  StyleBox["Step", "MR"],
  " function for a user-defined method does not have an expected form."
}], "Notes",
  CellTags->"NDSolve::bdstep"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bdstep"],

Cell[TextData[{
  "An error is generated in this example if the value of the ",
  StyleBox["Method", "MR"],
  " option does not include a ",
  StyleBox["Step", "MR"],
  " function."
}], "Text",
  CellTags->"NDSolve::bdstep"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x'\)[t]\  \[Equal] \ x[t], \ x[0]\  \[Equal] \ 1}, 
      x, {t, 0, 1}, \ Method \[Rule] MyMethod]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bdstep"],

Cell[BoxData[
    \(NDSolve::"bdstep" \(\(:\)\(\ \)\) 
      "The Step function for the Method -> \!\(MyMethod\) returned \!\(0\) \
which is not an acceptable form."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bdstep"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 0.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bdstep"]
}, Open  ]],

Cell[TextData[{
  "An error occurs in this example because the definition for ",
  StyleBox["Step", "MR"],
  " that is provided for the user-defined method does not return an expected \
result."
}], "Text",
  CellTags->"NDSolve::bdstep"],

Cell[BoxData[
    \(\(MyMethod[]\)["\<Step\>"[___]]\  := \ 0\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::bdstep"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x'\)[t]\  \[Equal] \ x[t], \ x[0]\  \[Equal] \ 1}, 
      x, {t, 0, 1}, \ Method \[Rule] MyMethod]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"NDSolve::bdstep"],

Cell[BoxData[
    \(NDSolve::"bdstep" \(\(:\)\(\ \)\) 
      "The Step function for the Method -> \!\(MyMethod\) returned \!\(0\) \
which is not an acceptable form."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"NDSolve::bdstep"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 0.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"NDSolve::bdstep"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bvlin", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvlin"],

Cell[BoxData[
    \(NDSolve::"bvlin" \(\(:\)\(\ \)\) \(The\ differential\ equation \((s)\)\ \
and/or\ boundary\ conditions\ are\ not\ linear\ in\ the\ dependent\ variables \
. \ NDSolve\ requires\ linearity\ to\ compute\ the\ solution\ of\ a\ \
multipoint\ boundary\ value\ \(\(problem\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::bvlin"],

Cell["\<\
\[FilledSmallSquare] Generated when the equations that specify a \
boundary value problem are not linear.\
\>", "Notes",
  CellTags->"NDSolve::bvlin"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bvlin"],

Cell["\<\
An error occurs in this example because the boundary condition is \
not linear in the dependent variable.\
\>", "Text",
  CellTags->"NDSolve::bvlin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ x[t]\  == \ 0, \ x[0]\  \[Equal] \ 1, \ 
        x[1]^2\  \[Equal] \ 3}, x, {t, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bvlin"],

Cell[BoxData[
    \(NDSolve::"bvlin" \(\(:\)\(\ \)\) 
      "The differential equation(s) and/or boundary conditions are not linear \
in the dependent variables. NDSolve requires linearity to compute the \
solution of a multipoint boundary value problem."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bvlin"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(x[t]\), "+", 
                RowBox[{
                  SuperscriptBox["x", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
              "0"}], ",", \(x[0] \[Equal] 1\), ",", \(x[1]\^2 \[Equal] 3\)}], 
          "}"}], ",", "x", ",", \({t, 0, 1}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bvlin"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bvluc", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvluc"],

Cell[BoxData[
    \(NDSolve::"bvluc" \(\(:\)\(\ \)\) \(The\ equations\ derived\ from\ the\ \
boundary\ conditions\ are\ numerically\ ill - 
        conditioned . \ 
            The\ boundary\ conditions\ may\ not\ be\ sufficient\ to\ uniquely\
\ define\ a\ solution . \ 
            The\ computed\ solution\ may\ match\ the\ boundary\ conditions\ \
\(\(poorly\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::bvluc"],

Cell["\<\
\[FilledSmallSquare] Generated when the equations do not appear to \
unambiguously specify a unique solution.\
\>", "Notes",
  CellTags->"NDSolve::bvluc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bvluc"],

Cell["\<\
A warning message occurs in this example because there are an \
infinite number of solutions that satisfy this differential equation and the \
boundary condition.\
\>", "Text",
  CellTags->"NDSolve::bvluc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ x[t]\  == \ 0, \ x[0]\  \[Equal] \ 0, \ 
        x[2\ Pi]\  \[Equal] \ 1}, x, {t, 0, 2\ Pi}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bvluc"],

Cell[BoxData[
    \(NDSolve::"bvluc" \(\(:\)\(\ \)\) 
      "The equations derived from the boundary conditions are numerically \
ill-conditioned. The boundary conditions may not be sufficient to uniquely \
define a solution. The computed solution may match the boundary conditions \
poorly."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bvluc"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{0.`, 6.283185307179586`}}, "<>"]\),
            
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bvluc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bvls", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvls"],

Cell[BoxData[
    \(NDSolve::"bvls" \(\(:\)\(\ \)\) \(Unable\ to\ resolve\ the\ conditions\ \
derived\ from\ the\ given\ boundary\ conditions . \ 
          It\ is\ possible\ there\ is\ no\ solution\ for\ the\ given\ \
boundary\ value\ \(\(problem\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::bvls"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::bvls"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bvlind", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvlind"],

Cell[BoxData[
    \(NDSolve::"bvlind" \(\(:\)\(\ \)\) \(Boundary\ conditions\ are\ not\ \
linearly\ \(\(independent\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::bvlind"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::bvlind"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bvaux", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvaux"],

Cell[BoxData[
    \(NDSolve::"bvaux" \(\(:\)\(\ \)\) \(Unable\ to\ solve\ auxiliary\ system\
\ for\ boundary\ condition\ at\ `1`\  == \ `2`\)\)], "Message",
  CellTags->"NDSolve::bvaux"],

Cell["\<\
\[FilledSmallSquare] Generated by an error condition when setting \
up to solve a boundary value problem.
\[FilledSmallSquare] This error occurs for boundary value problems when the \
differential equation is singular at one of the endpoints.
\[FilledSmallSquare] There will typically be other warning messages related \
to the singularity.
\[FilledSmallSquare] No solution is computed when this error occurs.\
\>", \
"Notes",
  CellTags->"NDSolve::bvaux"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bvaux"],

Cell["\<\
Evaluation of this input generates many warning messages related to \
the singularity.\
\>", "Text",
  CellTags->"NDSolve::bvaux"],

Cell[CellGroupData[{

Cell[BoxData[
    \(0. /0. ; 
    NDSolve[{x\ \(\(f'\)'\)[x] + f[x] == 0, f[0] == 0, f[1] == 1}, 
      f, {x, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bvaux"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0.`\) encountered."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bvaux"],

Cell[BoxData[
    \(\[Infinity]::"indet" \(\(:\)\(\ \)\) 
      "Indeterminate expression \!\(0.`\\ ComplexInfinity\) encountered."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bvaux"],

Cell[BoxData[
    \(Power::"infy" \(\(:\)\(\ \)\) 
      "Infinite expression \!\(1\/0.`\) encountered."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bvaux"],

Cell[BoxData[
    \(\[Infinity]::"indet" \(\(:\)\(\ \)\) 
      "Indeterminate expression \!\(0.`\\ ComplexInfinity\) encountered."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bvaux"],

Cell[BoxData[
    \(NDSolve::"ndnum" \(\(:\)\(\ \)\) 
      "Encountered non-numerical value for a derivative at \!\(x\) == \!\(0.`\
\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bvaux"],

Cell[BoxData[
    \(NDSolve::"bvaux" \(\(:\)\(\ \)\) 
      "Unable to solve auxiliary system for boundary condition at \!\(x\) == \
\!\(0.`\)"\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bvaux"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(f[x]\), "+", 
                RowBox[{"x", " ", 
                  RowBox[{
                    SuperscriptBox["f", "\[Prime]\[Prime]",
                      MultilineFunction->None], "[", "x", "]"}]}]}], 
              "\[Equal]", "0"}], ",", \(f[0] \[Equal] 0\), 
            ",", \(f[1] \[Equal] 1\)}], "}"}], ",", "f", ",", \({x, 0, 1}\)}],
       "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bvaux"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bvep", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvep"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NDSolve::"bvep"\), \(\(:\)\(\ \)\), "Value", " ", "of", " ", 
        "option", " ", 
        StyleBox["opt",
          "TI"]}], "->", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "nonnegative", " ", 
        "real", " ", \(\(number\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::bvep"],

Cell["\<\
\[FilledSmallSquare] Generated when the value of the indicated \
option does not have the expected form.\
\>", "Notes",
  CellTags->"NDSolve::bvep"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bvep"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["ExtraPrecision", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::bvep"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ x[t]\  == \ 0, \ x[0]\  \[Equal] \ 0, \ 
        x[Pi/2]\  \[Equal] \ 1}, x, {t, 0, 1}, \ 
      Method \[Rule] {Chasing, \ ExtraPrecision \[Rule] None}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bvep"],

Cell[BoxData[
    \(NDSolve::"bvep" \(\(:\)\(\ \)\) 
      "Value of option \!\(\"ExtraPrecision\"\)->\!\(None\) should be a \
nonnegative real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bvep"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(x[t]\), "+", 
                RowBox[{
                  SuperscriptBox["x", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
              "0"}], ",", \(x[0] \[Equal] 0\), 
            ",", \(x[\[Pi]\/2] \[Equal] 1\)}], "}"}], ",", "x", 
        ",", \({t, 0, 1}\), 
        ",", \(Method \[Rule] {Chasing, ExtraPrecision \[Rule] None}\)}], 
      "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bvep"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bvcrat", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvcrat"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NDSolve::"bvcrat"\), \(\(:\)\(\ \)\), "Value", " ", "of", " ",
         "option", " ", 
        StyleBox["opt",
          "TI"]}], "->", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "nonzero", " ", 
        "real", " ", \(\(number\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::bvcrat"],

Cell["\<\
\[FilledSmallSquare] Generated when the value of the indicated \
option does not have the expected form.\
\>", "Notes",
  CellTags->"NDSolve::bvcrat"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bvdae", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvdae"],

Cell[BoxData[
    \(NDSolve::"bvdae" \(\(:\)\(\ \)\) \(Differential - 
        algebraic\ equations\ must\ be\ given\ as\ initial\ value\ \
\(\(problems\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::bvdae"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::bvdae"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::cprec", "ObjectNameWarningMessages",
  CellTags->"NDSolve::cprec"],

Cell[BoxData[
    \(NDSolve::"cprec" \(\(:\)\(\ \)\) \(The\ precision\ `1`\ of\ the\ \
coefficients\ of\ the\ method\ `2`\ is\ not\ consisitent\ with\ the\ working\ \
precision\ \(\(`3`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::cprec"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::cprec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::cconst", "ObjectNameWarningMessages",
  CellTags->"NDSolve::cconst"],

Cell[BoxData[
    \(NDSolve::"cconst" \(\(:\)\(\ \)\) \(The\ coefficients\ `1`\ of\ `2`\ do\
\ not\ give\ a\ consistent\ \(\(method\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::cconst"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::cconst"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::cdims", "ObjectNameWarningMessages",
  CellTags->"NDSolve::cdims"],

Cell[BoxData[
    \(NDSolve::"cdims" \(\(:\)\(\ \)\) \(The\ dimensions\ of\ the\ options\ \
`1`, \ `2`\ and\ `3`\ of\ the\ method\ `4`\ are\ not\ \(\(compatible\)\(.\)\)\
\)\)], "Message",
  CellTags->"NDSolve::cdims"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::cdims"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::cstruct", "ObjectNameWarningMessages",
  CellTags->"NDSolve::cstruct"],

Cell[BoxData[
    \(NDSolve::"cstruct" \(\(:\)\(\ \)\) \(The\ coefficients\ `1`\ of\ `2`\ \
do\ not\ have\ the\ correct\ \(\(structure\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::cstruct"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::cstruct"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::submtd", "ObjectNameWarningMessages",
  CellTags->"NDSolve::submtd"],

Cell[BoxData[
    RowBox[{\(NDSolve::"submtd"\), ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", 
        " ", \(\(submethod\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::submtd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Method", "MR"],
  " option within the value of another ",
  StyleBox["Method", "MR"],
  " option is not valid."
}], "Notes",
  CellTags->"NDSolve::submtd"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::submtd"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["DoubleStep", "MR"],
  " is not a valid submethod within the ",
  StyleBox["FixedStep", "MR"],
  " method."
}], "Text",
  CellTags->"NDSolve::submtd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ x[t]\  == \ 0, 
        x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 1}, x, {t, 0, 1}, \ 
      Method \[Rule] {FixedStep, \ Method \[Rule] DoubleStep}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::submtd"],

Cell[BoxData[
    \(NDSolve::"submtd" \(\(:\)\(\ \)\) 
      "\!\(None\) is not a valid submethod."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::submtd"],

Cell[BoxData[
    \(NDSolve::"initf" \(\(:\)\(\ \)\) 
      "The initialization of the method \!\(NDSolve`FixedStep\) failed."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::submtd"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 0.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::submtd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::uniss", "ObjectNameWarningMessages",
  CellTags->"NDSolve::uniss"],

Cell[BoxData[
    \(NDSolve::"uniss" \(\(:\)\(\ \)\) \(The\ spacing\ specified\ by\ \
MinStepSize -> \(`1`\ and\ MaxStepSize -> `2`\ for\ independent\ variable\ \
`3`\ cannot\ be\ used\ to\ construct\ a\ uniform\ grid\ on\ an\ interval\ of\ \
length\ `4` . \ \ Using\ spacing\ `5`\ \(\(instead\)\(.\)\)\)\)\)], "Message",\

  CellTags->"NDSolve::uniss"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated option values \
restrict the step size in a way that is not commensurate with the interval \
for the corresponding variable.\
\>", "Notes",
  CellTags->"NDSolve::uniss"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::uniss"],

Cell[TextData[{
  "A warning message is generated in this example because ",
  StyleBox["NDSolve", "MR"],
  " did not use a step size that satisfied the restrictions indicated by the \
options."
}], "Text",
  CellTags->"NDSolve::uniss"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] {"\<TensorProductGrid\>", \ MaxStepSize \[Rule]  .003, \ 
              MinStepSize \[Rule]  .003}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::uniss"],

Cell[BoxData[
    \(NDSolve::"uniss" \(\(:\)\(\ \)\) 
      "The spacing specified by MinStepSize->\!\(0.003`\) and MaxStepSize->\!\
\(0.003`\) for independent variable \!\(x\) cannot be used to construct a \
uniform grid on an interval of length \!\(2.`\).  Using spacing \
\!\(0.0029985007496251873`\) instead."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::uniss"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{"...", \(-1.`\), 1.`, 
                  "..."}, {0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::uniss"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::eerri", "ObjectNameWarningMessages",
  CellTags->"NDSolve::eerri"],

Cell[BoxData[
    \(NDSolve::"eerri" \(\(:\)\(\ \)\) \(Warning : \ 
        Estimated\ initial\ error\ on\ the\ specified\ spatial\ grid\ in\ the\
\ direction\ of\ independent\ variable\ `1`\ exceeds\ prescribed\ error\ \
\(\(tolerance\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::eerri"],

Cell["\<\
\[FilledSmallSquare] Generated by an excessive numerical error \
estimate in the numerical solution of a partial differential equation.\
\>", \
"Notes",
  CellTags->"NDSolve::eerri"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::eerri"],

Cell["\<\
A warning message is generated in this example because the sharp \
feature in the boundary condition cannot be reliably resolved within the \
indicated restrictions on the step size.\
\>", "Text",
  CellTags->"NDSolve::eerri"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] {"\<TensorProductGrid\>", \ MinStepSize \[Rule] 0.01, 
              MaxStepSize \[Rule] 0.01}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::eerri"],

Cell[BoxData[
    \(NDSolve::"eerri" \(\(:\)\(\ \)\) 
      "Warning: Estimated initial error on the specified spatial grid in the \
direction of independent variable \!\(x\) exceeds prescribed error \
tolerance."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::eerri"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{"...", \(-1.`\), 1.`, 
                  "..."}, {0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::eerri"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::vdobj", "ObjectNameWarningMessages",
  CellTags->"NDSolve::vdobj"],

Cell[BoxData[
    \(NDSolve::"vdobj" \(\(:\)\(\ \)\) \(Encountered\ `1`\ which\ is\ not\ a\ \
valid\ `2`\ \(\(expression\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::vdobj"],

Cell["\<\
\[FilledSmallSquare] Generated when certain invalid internal data \
structures are encountered.\
\>", "Notes",
  CellTags->"NDSolve::vdobj"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::vdobj"],

Cell[TextData[{
  "This message can be generated if an invalid ",
  StyleBox["NDSolve`StateData", "MR"],
  " expression is encountered."
}], "Text",
  CellTags->"NDSolve::vdobj"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`ProcessSolutions[NDSolve`StateData[0]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::vdobj"],

Cell[BoxData[
    RowBox[{\(NDSolve::"vdobj"\), \(\(:\)\(\ \)\), "\<\"Encountered \
\\!\\(\\*TagBox[\\(NDSolve`StateData[0]\\), False, Rule[Editable, False]]\\) \
which is not a valid \\!\\(NDSolve`StateData\\) expression.\"\>"}]], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::vdobj"],

Cell[BoxData[
    RowBox[{"NDSolve`ProcessSolutions", "[", 
      TagBox[\(NDSolve`StateData[0]\),
        False,
        Editable->False], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::vdobj"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ininv", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ininv"],

Cell[BoxData[
    \(NDSolve::"ininv" \(\(:\)\(\ \)\) \(Unable\ to\ ascertain\ the\ initial\ \
data\ for\ the\ invariants\ in\ the\ method\ \(\(`1`\)\(.\)\)\)\)], "Message",\

  CellTags->"NDSolve::ininv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ininv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::impsol", "ObjectNameWarningMessages",
  CellTags->"NDSolve::impsol"],

Cell[BoxData[
    \(NDSolve::"impsol" \(\(:\)\(\ \)\) 
      "The option `1`->`2` of the method `3` is not FixedPoint or \
Newton."\)], "Message",
  CellLabel->"From In[22]:=",
  CellTags->"NDSolve::impsol"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::impsol"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::maxit", "ObjectNameWarningMessages",
  CellTags->"NDSolve::maxit"],

Cell[BoxData[
    \(NDSolve::"maxit" \(\(:\)\(\ \)\) \(Maximum\ number\ of\ iterations\ `1`\
\ reached\ at\ `2`\  = \ \(\(`3`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::maxit"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::maxit"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::mmpts", "ObjectNameWarningMessages",
  CellTags->"NDSolve::mmpts"],

Cell[BoxData[
    \(NDSolve::"mmpts" \(\(:\)\(\ \)\) \(Number\ of\ steps\ for\ independent\ \
variable\ `1`\ required\ by\ MaxStepSize -> \(`2`\ or\ MinPoints -> \(`3`\ is\
\ greater\ than\ the\ number\ of\ steps\ allowed\ by\ MinStepSize -> \(`4`\ \
and/or\ MaxPoints -> \(\(`5`\)\(.\)\)\)\)\)\)\)], "Message",
  CellTags->"NDSolve::mmpts"],

Cell["\<\
\[FilledSmallSquare] Generated by conflicting values of the \
indicated options.\
\>", "Notes",
  CellTags->"NDSolve::mmpts"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::mmpts"],

Cell[TextData[{
  "An error occurs in this example because there is no step size that can \
satsify both the specification given by the value of the ",
  StyleBox["MaxSteps", "MR"],
  " option and the specification given by the value of the ",
  StyleBox["MaxStepSize", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::mmpts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      MaxSteps \[Rule] {15, \ Infinity}, \ 
      MaxStepSize \[Rule] { .001, \ Infinity}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::mmpts"],

Cell[BoxData[
    \(NDSolve::"mmpts" \(\(:\)\(\ \)\) 
      "Number of steps for independent variable \!\(x\) required by \
MaxStepSize->\!\(0.001`\) or MinPoints->\!\(Automatic\) is greater than the \
number of steps allowed by MinStepSize->\!\(Automatic\) and/or \
MaxPoints->\!\(15\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::mmpts"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(u[x, 0] \[Equal] \[ExponentialE]\^\(\(-100\)\ x\^2\)\), 
            ",", \(u[\(-1\), t] \[Equal] u[1, t]\)}], "}"}], ",", "u", 
        ",", \({x, \(-1\), 1}\), ",", \({t, 2}\), 
        ",", \(MaxSteps \[Rule] {15, \[Infinity]}\), 
        ",", \(MaxStepSize \[Rule] {0.001`, \[Infinity]}\)}], "]"}]], "Output",\

  CellLabel->"Out[1]=",
  CellTags->"NDSolve::mmpts"]
}, Open  ]],

Cell[TextData[{
  "One way to avoid the error in this example is by removing the setting of \
the ",
  StyleBox["MaxSteps", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::mmpts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      MaxStepSize \[Rule] { .001, \ Infinity}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::mmpts"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{"...", \(-1.`\), 1.`, 
                  "..."}, {0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::mmpts"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::dored", "ObjectNameWarningMessages",
  CellTags->"NDSolve::dored"],

Cell[BoxData[
    \(NDSolve::"dored" \(\(:\)\(\ \)\) \(The\ maximum\ number\ of\ spatial\ \
points\ \((`1`)\)\ for\ independent\ variable\ `2`\ allowed\ by\ MaxPoints -> \
\(`3`\ or\ MinStepSize -> \(`4`\ is\ to\ few\ for\ DifferenceOrder -> `5` . \ \
\ Spatial\ difference\ order\ for\ `2`\ will\ be\ reduced\ to\ \(\(`6`\)\(.\)\
\)\)\)\)\)], "Message",
  CellTags->"NDSolve::dored"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::dored"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::nerres", "ObjectNameWarningMessages",
  CellTags->"NDSolve::nerres"],

Cell[BoxData[
    \(NDSolve::"nerres" \(\(:\)\(\ \)\) \(The\ maximum\ number\ of\ spatial\ \
points\ \((`1`)\)\ for\ independent\ variable\ `2`\ allowed\ by\ MaxPoints -> \
\(`3`\ or\ MinStepSize -> `4`\ is\ too\ few\ to\ compute\ a\ spatial\ error\ \
\(\(estimate\)\(.\)\)\)\)\)], "Message",
  CellTags->"NDSolve::nerres"],

Cell["\<\
\[FilledSmallSquare] Generated by numerical failure in solving a \
partial differential equation.\
\>", "Notes",
  CellTags->"NDSolve::nerres"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::nerres"],

Cell[TextData[{
  "A warning is generated in this example because the specified value of the  \
",
  StyleBox["MaxSteps", "MR"],
  " option may not be sufficient to compute a solution within the default  \
tolerances."
}], "Text",
  CellTags->"NDSolve::nerres"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 2]\)[f]\)[x, t], f[0, t] == 0, 
        f[1, t] == 0, \(\(Derivative[0, 1]\)[f]\)[x, 0] == 0, 
        f[x, 0] == Sin[2\ Pi\ x]}, f, {x, 0, 1}, {t, 0, 1}, 
      MaxSteps -> {10, Automatic}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::nerres"],

Cell[BoxData[
    \(NDSolve::"nerres" \(\(:\)\(\ \)\) 
      "The maximum number of spatial points (\!\(10\)) for independent \
variable \!\(x\) allowed by MaxPoints->\!\(10\) or MinStepSize->\!\(Automatic\
\) is too few to compute a spatial error estimate."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::nerres"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}, {0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::nerres"]
}, Open  ]],

Cell[TextData[{
  "A solution is computed without difficulty if a larger value is used for  \
the ",
  StyleBox["MaxSteps", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::nerres"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 2]\)[f]\)[x, t], f[0, t] == 0, 
        f[1, t] == 0, \(\(Derivative[0, 1]\)[f]\)[x, 0] == 0, 
        f[x, 0] == Sin[2\ Pi\ x]}, f, {x, 0, 1}, {t, 0, 1}, 
      MaxSteps -> {100, Automatic}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::nerres"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}, {0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::nerres"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::eveerr", "ObjectNameWarningMessages",
  CellTags->"NDSolve::eveerr"],

Cell[BoxData[
    \(NDSolve::"eveerr" \(\(:\)\(\ \)\) \(The\ specified\ spatial\ grid\ in\ \
the\ direction\ of\ independent\ variable\ `1`\ has\ an\ even\ number\ of\ \
points\ \((`2`)\)\ and\ the\ pseudospectral\ grid\ cannot\ be\ subdivided\ in\
\ two, \ so\ no\ spatial\ error\ estimate\ will\ be\ done\ on\ the\ final\ \
result\ in\ this\ \(\(direction\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::eveerr"],

Cell["\<\
\[FilledSmallSquare] Generated when the chosen method requires an \
odd number of grid points to compute error estimates as intended.\
\>", \
"Notes",
  CellTags->"NDSolve::eveerr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::stpmin", "ObjectNameWarningMessages",
  CellTags->"NDSolve::stpmin"],

Cell[BoxData[
    \(NDSolve::"stpmin" \(\(:\)\(\ \)\) \(The\ starting\ number\ of\ points\ \
determined\ by\ StartingStepSize -> \(`3`\ and\ StartingPoints -> `4`\ is\ \
`1`\ which\ is\ less\ than\ the\ minimum\ number\ of\ `2`\ grid\ points . \ \ \
`2`\ will\ be\ used\ \(\(instead\)\(.\)\)\)\)\)], "Message",
  CellTags->"NDSolve::stpmin"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated options impose \
incompatible restrictions on the number of steps.\
\>", "Notes",
  CellTags->"NDSolve::stpmin"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::stpmin"],

Cell["\<\
A warning message is generated in this example because there is no \
choice for the number of steps that will satisfy all of the indicated \
options.\
\>", "Text",
  CellTags->"NDSolve::stpmin"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] {"\<TensorProductGrid\>", \ 
              MinPoints \[Rule] 50, \ \ StartingPoints \[Rule] 
                10}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::stpmin"],

Cell[BoxData[
    \(NDSolve::"stpmin" \(\(:\)\(\ \)\) 
      "The starting number of points determined by \
StartingStepSize->\!\(Automatic\) and StartingPoints->\!\(10\) is \!\(10\) \
which is less than the minimum number of \!\(50\) grid points.  \!\(50\) will \
be used instead."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::stpmin"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{"...", \(-1.`\), 1.`, 
                  "..."}, {0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::stpmin"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::stpmax", "ObjectNameWarningMessages",
  CellTags->"NDSolve::stpmax"],

Cell[BoxData[
    \(NDSolve::"stpmax" \(\(:\)\(\ \)\) \(The\ starting\ number\ of\ points\ \
determined\ by\ StartingStepSize -> \(`3`\ and\ StartingPoints -> `4`\ is\ \
`1`\ which\ is\ greater\ than\ the\ maximum\ number\ of\ `2`\ grid\ points . \
\ \ `2`\ will\ be\ used\ \(\(instead\)\(.\)\)\)\)\)], "Message",
  CellTags->"NDSolve::stpmax"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated options impose \
incompatible restrictions on the number of steps.\
\>", "Notes",
  CellTags->"NDSolve::stpmax"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::stpmax"],

Cell["\<\
A warning message is generated in this example because there is no \
choice for the number of steps that will satisfy all of the indicated \
options.\
\>", "Text",
  CellTags->"NDSolve::stpmax"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] {"\<TensorProductGrid\>", \ 
              MaxPoints \[Rule] 1000, \ \ StartingPoints \[Rule] 
                1200}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::stpmax"],

Cell[BoxData[
    \(NDSolve::"stpmax" \(\(:\)\(\ \)\) 
      "The starting number of points determined by \
StartingStepSize->\!\(Automatic\) and StartingPoints->\!\(1200\) is \
\!\(1200\) which is greater than the maximum number of \!\(1000\) grid \
points.  \!\(1000\) will be used instead."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::stpmax"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{"...", \(-1.`\), 1.`, 
                  "..."}, {0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::stpmax"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::stps", "ObjectNameWarningMessages",
  CellTags->"NDSolve::stps"],

Cell[BoxData[
    \(NDSolve::"stps" \(\(:\)\(\ \)\) \(Only\ one\ of\ StartingPoints\ and\ \
StartingStepSize\ should\ be\ specified\ at\ a\ time . \ \ StartingPoints -> \
\(`1`\ will\ be\ used\ and\ StartingStepSize -> `2`\ will\ be\ \
\(\(disregarded\)\(.\)\)\)\)\)], "Message",
  CellTags->"NDSolve::stps"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the input includes values for both the \
",
  StyleBox["StartingStepSize", "MR"],
  " and ",
  StyleBox["StartingPoints", "MR"],
  " options.\n\[FilledSmallSquare] Since these options specify the same \
quantity, it is only necessary to provide a value for one of these options."
}], "Notes",
  CellTags->"NDSolve::stps"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::stps"],

Cell[TextData[{
  "A warning message is generated by this examlpe because ",
  "the input includes values for both the ",
  StyleBox["StartingStepSize", "MR"],
  " and ",
  StyleBox["StartingPoints", "MR"],
  " options."
}], "Text",
  CellTags->"NDSolve::stps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] {"\<TensorProductGrid\>", 
              StartingStepSize \[Rule] 1, \ \ StartingPoints \[Rule] 
                1200}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::stps"],

Cell[BoxData[
    \(NDSolve::"stps" \(\(:\)\(\ \)\) 
      "Only one of StartingPoints and StartingStepSize should be specified at \
a time.  StartingPoints->\!\(1200\) will be used and \
StartingStepSize->\!\(1.`\) will be disregarded."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::stps"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{"...", \(-1.`\), 1.`, 
                  "..."}, {0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::stps"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::maxits", "ObjectNameWarningMessages",
  CellTags->"NDSolve::maxits"],

Cell[BoxData[
    \(NDSolve::"maxits" \(\(:\)\(\ \)\) \(The\ number\ of\ iterations\ `1`\ \
in\ the\ method\ `2`\ is\ not\ Automatic, \ 
      a\ positive\ machine\ integer\ or\ \(\(Infinity\)\(.\)\)\)\)], "Message",\

  CellTags->"NDSolve::maxits"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::maxits"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::moptxn", "ObjectNameWarningMessages",
  CellTags->"NDSolve::moptxn"],

Cell[BoxData[
    RowBox[{\(NDSolve::"moptxn"\), ":", " ", 
      RowBox[{"The", " ", "option", " ", 
        StyleBox["opt",
          "TI"], " ", "of", " ", "the", " ", "method", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "one", " ", "of", " ", 
        RowBox[{
          StyleBox["vals",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::moptxn"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated option is not \
among the known options of the indicated method.\
\>", "Notes",
  CellTags->"NDSolve::moptxn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::moptxn"],

Cell[TextData[{
  "A warning is generated in this example because ",
  StyleBox["Solve", "MR"],
  " is not a known option of the method specified in the ",
  StyleBox["Method", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::moptxn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ x[t]\  == \ 0, \ 
        x[0]\  \[Equal] \ 0, \ \(x'\)[0]\  \[Equal] \ 1}, x, {t, 0, 1}, \ 
      Method \[Rule] {BDF, \ Solve \[Rule] Newton}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::moptxn"],

Cell[BoxData[
    \(NDSolve::"moptxn" \(\(:\)\(\ \)\) 
      "The option \!\(\"Solve\"\) of the method \!\(NDSolve`BDF\) is not one \
of \!\({\"MaxDifferenceOrder\", \"VariableStepCoefficients\", \
\"ImplicitSolver\"}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::moptxn"],

Cell[BoxData[
    \(NDSolve::"initf" \(\(:\)\(\ \)\) 
      "The initialization of the method \!\(NDSolve`BDF\) failed."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::moptxn"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 0.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::moptxn"]
}, Open  ]],

Cell["This shows a valid option specification for this method.", "Text",
  CellTags->"NDSolve::moptxn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ x[t]\  == \ 0, \ 
        x[0]\  \[Equal] \ 0, \ \(x'\)[0]\  \[Equal] \ 1}, x, {t, 0, 1}, \ 
      Method \[Rule] {BDF, \ ImplicitSolver \[Rule] Newton}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::moptxn"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::moptxn"]
}, Open  ]],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["ContourRatio", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::moptxn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ x[t]\  == \ 0, \ x[0]\  \[Equal] \ 0, \ 
        x[1]\  \[Equal] \ 1}, x, {t, 0, 1}, \ 
      Method \[Rule] {Chasing, \ ContourRatio \[Rule] None}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"NDSolve::moptxn"],

Cell[BoxData[
    \(NDSolve::"moptxn" \(\(:\)\(\ \)\) 
      "The option \!\(\"ContourRatio\"\) of the method \!\(NDSolve`Chasing\) \
is not one of \!\({\"Method\", \"ExtraPrecision\", \"ChasingType\"}\)."\)], \
"Message",
  CellLabel->"From In[3]:=",
  CellTags->"NDSolve::moptxn"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(x[t]\), "+", 
                RowBox[{
                  SuperscriptBox["x", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
              "0"}], ",", \(x[0] \[Equal] 0\), ",", \(x[1] \[Equal] 1\)}], 
          "}"}], ",", "x", ",", \({t, 0, 1}\), 
        ",", \(Method \[Rule] {Chasing, ContourRatio \[Rule] None}\)}], 
      "]"}]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"NDSolve::moptxn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::mrsti", "ObjectNameWarningMessages",
  CellTags->"NDSolve::mrsti"],

Cell[BoxData[
    \(NDSolve::"mrsti" \(\(:\)\(\ \)\) 
      "Number of steps `1` required by `2`->`3` should be a machine sized \
integer."\)], "Message",
  CellLabel->"From In[23]:=",
  CellTags->"NDSolve::mrsti"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MaxRelativeStepSize", "MR"],
  " option leads to an excessive number of steps."
}], "Notes",
  CellTags->"NDSolve::mrsti"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::mrsti"],

Cell[TextData[{
  "An error is generated in this example because of the excessively small \
value of the ",
  StyleBox["MaxRelativeStepSize", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::mrsti"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ x[t]\  == \ 0, \ 
        x[0]\  \[Equal] \ 0, \ \(x'\)[0]\  \[Equal] \ 1}, x, {t, 0, 1}, \ 
      MaxRelativeStepSize \[Rule] 2^\(-32\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::mrsti"],

Cell[BoxData[
    \(NDSolve::"mrsti" \(\(:\)\(\ \)\) 
      "Number of steps \!\(4294967296\) required by \!\(\"MaxRelativeStepSize\
\"\)->\!\(1\/10\) should be a machine sized integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::mrsti"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(x[t]\), "+", 
                RowBox[{
                  SuperscriptBox["x", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
              "0"}], ",", \(x[0] \[Equal] 0\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "\[Equal]", 
              "1"}]}], "}"}], ",", "x", ",", \({t, 0, 1}\), 
        ",", \(MaxRelativeStepSize \[Rule] 1\/4294967296\)}], "]"}]], "Output",\

  CellLabel->"Out[1]=",
  CellTags->"NDSolve::mrsti"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::msti", "ObjectNameWarningMessages",
  CellTags->"NDSolve::msti"],

Cell[BoxData[
    \(NDSolve::"msti" \(\(:\)\(\ \)\) \(Number\ of\ steps\ `1`\ required\ by\ \
MaxStepSize -> `2`\ for\ independent\ variable\ `3`\ should\ be\ a\ machine\ \
sized\ \(\(integer\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::msti"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MaxStepSize", "MR"],
  " option leads to an excessive number of steps."
}], "Notes",
  CellTags->"NDSolve::msti"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::msti"],

Cell[TextData[{
  "An error is generated in this example because of the excessively small \
value of the ",
  StyleBox["MaxStepSize", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::msti"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] {"\<TensorProductGrid\>", MaxStepSize \[Rule] 2^\(-32\)}}]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"NDSolve::msti"],

Cell[BoxData[
    \(NDSolve::"msti" \(\(:\)\(\ \)\) 
      "Number of steps \!\(8589934592\) required by \
MaxStepSize->\!\(2.3283064365386963`*^-10\) for independent variable \!\(x\) \
should be a machine sized integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::msti"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(u[x, 0] \[Equal] \[ExponentialE]\^\(\(-100\)\ x\^2\)\), 
            ",", \(u[\(-1\), t] \[Equal] u[1, t]\)}], "}"}], ",", "u", 
        ",", \({x, \(-1\), 1}\), ",", \({t, 2}\), 
        ",", \(Method \[Rule] {"MethodOfLines", 
            "SpatialDiscretization" \[Rule] {"TensorProductGrid", 
                MaxStepSize \[Rule] 1\/4294967296}}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::msti"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ncsm", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ncsm"],

Cell[BoxData[
    \(NDSolve::"ncsm" \(\(:\)\(\ \)\) \(The\ number\ of\ coefficients\ `1`\ \
is\ not\ the\ same\ as\ the\ number\ of\ submethods\ `2`\ in\ the\ method\ \(\
\(`3`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::ncsm"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ncsm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::lsf", "ObjectNameWarningMessages",
  CellTags->"NDSolve::lsf"],

Cell[BoxData[
    \(NDSolve::"lsf" \(\(:\)\(\ \)\) \(Unable\ to\ solve\ required\ system\ \
of\ linear\ equations\ to\ `1`\  == \ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::lsf"],

Cell["\<\
\[FilledSmallSquare] This message is generated by a specific type \
of failure within the algorithm that is used for solving initial value \
problems.
\[FilledSmallSquare] If you see this message in an example where it is not \
expected, please contact Technical Support for more information.\
\>", "Notes",\

  CellTags->"NDSolve::lsf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndinnt", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndinnt"],

Cell[BoxData[
    \(NDSolve::"ndinnt" \(\(:\)\(\ \)\) \(Initial\ condition\ `1`\ is\ not\ a\
\ number\ or\ a\ rectangular\ array\ of\ \(\(numbers\)\(.\)\)\)\)], "Message",\

  CellTags->"NDSolve::ndinnt"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an initial condition in ",
  StyleBox["NDSolve", "MR"],
  " does not have the required form.\n\[FilledSmallSquare] The most common \
cause of  this message is an undefined symbolic parameter in the equations."
}], "Notes",
  CellTags->"NDSolve::ndinnt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::ndinnt"],

Cell[TextData[{
  "The initial value of a solution in ",
  StyleBox["NDSolve", "MR"],
  " cannot be ",
  StyleBox["Infinity", "MR"],
  "."
}], "Text",
  CellTags->"NDSolve::ndinnt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[x] == f[x], f[0] \[Equal] Infinity}, 
      f, {x, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::ndinnt"],

Cell[BoxData[
    \(RowReduce::"inf" \(\(:\)\(\ \)\) 
      "Input matrix contains an infinite entry."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ndinnt"],

Cell[BoxData[
    \(NDSolve::"ndinnt" \(\(:\)\(\ \)\) 
      "Initial condition \!\(\[Infinity]\) is not a number or a rectangular \
array of numbers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ndinnt"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", "\[Prime]",
                  MultilineFunction->None], "[", "x", "]"}], 
              "\[Equal]", \(f[x]\)}], ",", \(f[0] \[Equal] \[Infinity]\)}], 
          "}"}], ",", "f", ",", \({x, 0, 1}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::ndinnt"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid specification of an initial value problem in ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Text",
  CellTags->"NDSolve::ndinnt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(f'\)[x] == f[x], f[0] == 1}, f, {x, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::ndinnt"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::ndinnt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NDSolve::ndincd
NDSolve`Reinitialize::ndincd\
\>", "ObjectNameWarningMessages",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ndincd\"\>"}], \(\(:\)\(\ \)\), \(Initial\ conditions\ for\
\ derivatives\ of\ the\ function\ `1`\ do\ not\ have\ consistent\ \
\(\(dimensions\)\(.\)\)\)}]], "Message",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],

Cell["\<\
\[FilledSmallSquare] Generated when inequivalent lists are used in \
specifying initial conditions.\
\>", "Notes",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],

Cell["\<\
An error is generated in this example because one of the two \
initial conditions is specified using a list and the other is not.\
\>", \
"Text",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ x[t]\  == \ 0, \ 
        x[0]\  \[Equal] \ 0, \ \(x'\)[0]\  \[Equal] \ {1}}, 
      x, {t, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],

Cell[BoxData[
    \(NDSolve::"ndincd" \(\(:\)\(\ \)\) 
      "Initial conditions for derivatives of the function \!\(x[t]\) do not \
have consistent dimensions."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(x[t]\), "+", 
                RowBox[{
                  SuperscriptBox["x", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
              "0"}], ",", \(x[0] \[Equal] 0\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], 
              "\[Equal]", \({1}\)}]}], "}"}], ",", "x", ",", \({t, 0, 1}\)}], 
      "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndincb", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndincb"],

Cell[BoxData[
    \(NDSolve::"ndincb" \(\(:\)\(\ \)\) \(Initial\ conditions\ are\ not\ of\ \
consistent\ \(\(dimensionality\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::ndincb"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ndincb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::opdims", "ObjectNameWarningMessages",
  CellTags->"NDSolve::opdims"],

Cell[BoxData[
    \(NDSolve::"opdims" \(\(:\)\(\ \)\) \(The\ value\ of\ `1` -> `2`\ of\ the\
\ method\ `3`\ is\ not\ a\ pair\ of\ positive\ integers\ {n, \ 
              m}\ with\ n\  >= \ 
          m\ and\ n*m\ equal\ to\ \(\(`4`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::opdims"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::opdims"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::opmdims", "ObjectNameWarningMessages",
  CellTags->"NDSolve::opmdims"],

Cell[BoxData[
    \(NDSolve::"opmdims" \(\(:\)\(\ \)\) \(The\ dimensions\ `1`\ of\ the\ \
matrix\ function\ in\ the\ method\ `2`\ are\ not\ compatible\ with\ the\ \
specified\ dimensions\ \(\(`4`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::opmdims"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::opmdims"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`Reinitialize::ndincb", "ObjectNameWarningMessages",
  CellTags->"NDSolve`Reinitialize::ndincb"],

Cell[BoxData[
    \(NDSolve`Reinitialize::"ndincb" \(\(:\)\(\ \)\) \(The\ new\ initial\ \
conditions\ need\ to\ have\ the\ same\ dimensions\ as\ the\ original\ \
\(\(ones\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`Reinitialize::ndincb"],

Cell["\<\
\[FilledSmallSquare] This message can be generated by an incorrect \
use of the indicated internal function.\
\>", "Notes",
  CellTags->"NDSolve`Reinitialize::ndincb"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve`Reinitialize::ndincb"],

Cell[TextData[{
  "A message is generated in this example because of an error in the use of \
",
  StyleBox["NDSolve`Reinitialize", "MR"],
  "."
}], "Text",
  CellTags->"NDSolve`Reinitialize::ndincb"],

Cell[CellGroupData[{

Cell[BoxData[
    \(state\  = \ 
      First[NDSolve`ProcessEquations[{\(x''\)[t]\  + \ x[t]\  == \ 0, \ 
            x[0]\  \[Equal] \ {0}, \ \(x'\)[0]\  \[Equal] \ {1}}, x, 
          t]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve`Reinitialize::ndincb"],

Cell[BoxData[
    TagBox[
      RowBox[{"NDSolve`StateData", "[", 
        InterpretationBox[\("<"\[InvisibleSpace]0.`\[InvisibleSpace]">"\),
          SequenceForm[ "<", 0.0, ">"],
          Editable->False], "]"}],
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve`Reinitialize::ndincb"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`Reinitialize[
      state, \ {x[0]\  \[Equal] \ 0, \ \(x'\)[0]\  \[Equal] \ 1}]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->"NDSolve`Reinitialize::ndincb"],

Cell[BoxData[
    \(NDSolve`Reinitialize::"ndincb" \(\(:\)\(\ \)\) 
      "The new initial conditions need to have the same dimensions as the \
original ones."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"NDSolve`Reinitialize::ndincb"],

Cell[BoxData[
    RowBox[{"NDSolve`Reinitialize", "[", 
      RowBox[{
        TagBox[
          RowBox[{"NDSolve`StateData", "[", 
            
            InterpretationBox[\("<"\[InvisibleSpace]0.`\[InvisibleSpace]">"\),
              
              SequenceForm[ "<", 0.0, ">"],
              Editable->False], "]"}],
          False,
          Editable->False], ",", 
        RowBox[{"{", 
          RowBox[{\(x[0] \[Equal] 0\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "\[Equal]", 
              "1"}]}], "}"}]}], "]"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve`Reinitialize::ndincb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NDSolve::ndncov
NDSolve`Reinitialize::ndncov\
\>", "ObjectNameWarningMessages",
  CellTags->{"NDSolve::ndncov", "NDSolve`Reinitialize::ndncov"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ndncov\"\>"}], \(\(:\)\(\ \)\), \(The\ number\ of\ \
constraints\ \((initial\ conditions)\)\ for\ function\ `1`\ is\ insufficient\ \
for\ its\ differential\ order\ \(\((`2`)\)\(.\)\)\)}]], "Message",
  CellTags->{"NDSolve::ndncov", "NDSolve`Reinitialize::ndncov"}],

Cell["\<\
\[FilledSmallSquare] Generated when the equations do not include \
enough constraints to specify a unique solution.\
\>", "Notes",
  CellTags->{"NDSolve::ndncov", "NDSolve`Reinitialize::ndncov"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndfdmc", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndfdmc"],

Cell[BoxData[
    \(NDSolve::"ndfdmc" \(\(:\)\(\ \)\) \(Computed\ derivatives\ do\ not\ \
have\ dimensionality\ consistent\ with\ the\ initial\ \(\(conditions\)\(.\)\)\
\)\)], "Message",
  CellTags->"NDSolve::ndfdmc"],

Cell["\<\
\[FilledSmallSquare] Generated when the equations for the \
derivatives give values with list structures that are not equivalent to the \
lists used in specifying the initial conditions.\
\>", "Notes",
  CellTags->"NDSolve::ndfdmc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::ndfdmc"],

Cell["\<\
An error occurs in this example because the initial conditions are \
specified using lists and the equation for the derivatives gives scalar \
values for the derivatives.\
\>", "Text",
  CellTags->"NDSolve::ndfdmc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ x[t] . x[t]\  == \ 0, \ 
        x[0]\  \[Equal] \ {0}, \ \(x'\)[0]\  \[Equal] \ {1}}, 
      x, {t, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::ndfdmc"],

Cell[BoxData[
    \(NDSolve::"ndfdmc" \(\(:\)\(\ \)\) 
      "Computed derivatives do not have dimensionality consistent with the \
initial conditions."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ndfdmc"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(x[t] . x[t]\), "+", 
                RowBox[{
                  SuperscriptBox["x", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
              "0"}], ",", \(x[0] \[Equal] {0}\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], 
              "\[Equal]", \({1}\)}]}], "}"}], ",", "x", ",", \({t, 0, 1}\)}], 
      "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::ndfdmc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndrsd", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndrsd"],

Cell[BoxData[
    \(NDSolve::"ndrsd" \(\(:\)\(\ \)\) \(Step\ size\ was\ not\ decreased\ \
after\ a\ rejected\ step\ at\ `1`\  == \ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::ndrsd"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ndrsd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndsnorm", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndsnorm"],

Cell[BoxData[
    \(NDSolve::"ndsnorm" \(\(:\)\(\ \)\) \(Value\ of\ option\ NormFunction\  \
-> \ `1`\ is\ not\ Automatic\ or\ a\ function\ which\ gives\ a\ legitmate\ \(\
\(norm\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::ndsnorm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["NormFunction", "MR"],
  " option does not have the indicated form."
}], "Notes",
  CellTags->"NDSolve::ndsnorm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndsnr", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndsnr"],

Cell[BoxData[
    \(NDSolve::"ndsnr" \(\(:\)\(\ \)\) 
      "Step size was not real at `1` == `2`."\)], "Message",
  CellLabel->"From In[24]:=",
  CellTags->"NDSolve::ndsnr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ndsnr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndssc", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndssc"],

Cell[BoxData[
    \(NDSolve::"ndssc" \(\(:\)\(\ \)\) \(Step\ size\ changed\ sign\ at\ `1`\  \
== \ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::ndssc"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ndssc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndstf", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndstf"],

Cell[BoxData[
    \(NDSolve::"ndstf" \(\(:\)\(\ \)\) 
      "At `1` == `2`, system appears to be stiff. Methods Automatic, BDF or \
StiffnessSwitching may be more appropriate."\)], "Message",
  CellLabel->"From In[26]:=",
  CellTags->"NDSolve::ndstf"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ndstf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NDSolve::ivcon
NDSolve`Reinitialize::ivcon\
\>", "ObjectNameWarningMessages",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ivcon\"\>"}], \(\(:\)\(\ \)\), \(The\ given\ initial\ \
conditions\ were\ not\ consistent\ with\ the\ differential - 
        algebraic\ equations . \ \ NDSolve\ will\ attempt\ to\ correct\ the\ \
\(\(values\)\(.\)\)\)}]], "Message",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],

Cell["\<\
\[FilledSmallSquare] This message can be generated when the initial \
conditions are inconsistent with each other or when there are more initial \
conditions than necessary to specify a solution.\
\>", "Notes",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],

Cell["\<\
A warning message is generated in this example because some of the \
initial conditions are unnecessary.\
\>", "Text",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t] + \ y[t]\  \[Equal] \ 0, \ 
        y[t]\  \[Equal] \ x[t], \ 
        x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 
          0, \ \(x''\)[0]\  \[Equal] \ 0, \ 
        y[0]\  \[Equal] \ 0, \ \(y'\)[0]\  \[Equal] \ 0}, {x, y}, {t, 0, 
        1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],

Cell[BoxData[
    \(NDSolve::"ivcon" \(\(:\)\(\ \)\) 
      "The given initial conditions were not consistent with the \
differential-algebraic equations.  NDSolve will attempt to correct the \
values."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],

Cell[BoxData[
    \(NDSolve::"ivres" \(\(:\)\(\ \)\) 
      "NDSolve has computed initial values which give a zero residual for the \
differential-algebraic system, but some components are different from those \
specified.   If you need those to be satisfied, it is recommended that you \
give initial conditions for all dependent variables and derivatives of them."\
\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{
          RowBox[{"x", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
              False,
              Editable->False]}], ",", 
          RowBox[{"y", "\[Rule]", 
            TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
              False,
              Editable->False]}]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NDSolve::icord
NDSolve`Reinitialize::icord\
\>", "ObjectNameWarningMessages",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"icord\"\>"}], \(\(:\)\(\ \)\), \(The\ differential\ order\ \
of\ the\ functions\ in\ the\ initial\ or\ boundary\ conditions\ should\ be\ \
strictly\ less\ than\ in\ the\ differential\ \(\(equations\)\(.\)\)\)}]], \
"Message",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],

Cell["\<\
\[FilledSmallSquare] Generated when an initial condition includes a \
derivative of higher differential order than that of the differential \
equation.\
\>", "Notes",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],

Cell["\<\
An error occurs in this example because the order of the derivative \
in the initial condition is higher than the order of the highest derivatve in \
the differential equation.\
\>", "Text",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  \[Equal] \ x[t], \ 
        x[0]\  \[Equal] \ 0, \ \(x'''\)[0]\  \[Equal] \ 1}, 
      x, {t, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],

Cell[BoxData[
    \(NDSolve::"icord" \(\(:\)\(\ \)\) 
      "The differential order of the functions in the initial or boundary \
conditions should be strictly less than in the differential equations."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], 
              "\[Equal]", \(x[t]\)}], ",", \(x[0] \[Equal] 0\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", 
                  TagBox[\((3)\),
                    Derivative],
                  MultilineFunction->None], "[", "0", "]"}], "\[Equal]", 
              "1"}]}], "}"}], ",", "x", ",", \({t, 0, 1}\)}], "]"}]], "Output",\

  CellLabel->"Out[1]=",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NDSolve::icorddae
NDSolve`Reinitialize::icorddae\
\>", "ObjectNameWarningMessages",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"icorddae\"\>"}], \(\(:\)\(\ \)\), \(For\ a\ system\ \
treated\ as\ a\ differential\ algebraic\ equation, \ 
      the\ differential\ order\ of\ the\ functions\ in\ the\ initial\ \
conditions\ should\ be\ equal\ or\ less\ than\ in\ the\ \
\(\(equations\)\(.\)\)\)}]], "Message",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],

Cell["\<\
\[FilledSmallSquare] Generated when an initial condition includes a \
derivative of higher differential order than that of the differential \
equation.\
\>", "Notes",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],

Cell[TextData[{
  "An error occurs in this example because the differential order of ",
  StyleBox["y[t]", "MR"],
  " in the initial conditions is higher than the differential order of ",
  StyleBox["y[t]", "MR"],
  " in the differential equation."
}], "Text",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t] + \ y[t]\  \[Equal] \ 0, \ 
        y[t]\  \[Equal] \ x[t], \ 
        x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 
          0, \ \(x''\)[0]\  \[Equal] \ 0, \ 
        y[0]\  \[Equal] \ 0, \ \(y''\)[0]\  \[Equal] \ 0}, {x, y}, {t, 0, 
        1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],

Cell[BoxData[
    \(NDSolve::"icorddae" \(\(:\)\(\ \)\) 
      "For a system treated as a differential algebraic equation, the \
differential order of the functions in the initial conditions should be equal \
or less than in the equations."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(y[t]\), "+", 
                RowBox[{
                  SuperscriptBox["x", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
              "0"}], ",", \(y[t] \[Equal] x[t]\), ",", \(x[0] \[Equal] 1\), 
            ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "\[Equal]", 
              "0"}], ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "\[Equal]", 
              "0"}], ",", \(y[0] \[Equal] 0\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "\[Equal]", 
              "0"}]}], "}"}], ",", \({x, y}\), ",", \({t, 0, 1}\)}], 
      "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::mdata", "ObjectNameWarningMessages",
  CellTags->"NDSolve::mdata"],

Cell[BoxData[
    \(NDSolve::"mdata" \(\(:\)\(\ \)\) \(An\ invalid\ `1`\ method\ data\ \
object\ was\ encountered\ at\ the\ point\ `2`\  == \ \(\(`3`\)\(.\)\)\)\)], \
"Message",
  CellTags->"NDSolve::mdata"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::mdata"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::tponly", "ObjectNameWarningMessages",
  CellTags->"NDSolve::tponly"],

Cell[BoxData[
    \(NDSolve::"tponly" \(\(:\)\(\ \)\) \(Currently\ the\ only\ \
discretization\ method\ implemented\ is\ SpatialDiscretization -> \
\(\(TensorProductGrid\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::tponly"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an invalid value for the ",
  StyleBox["SpatialDiscretization", "MR"],
  " option."
}], "Notes",
  CellTags->"NDSolve::tponly"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::tponly"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Triangularization", "MR"],
  " is not a valid value for the ",
  StyleBox["SpatialDiscretization", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::tponly"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] "\<Triangularization\>"}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::tponly"],

Cell[BoxData[
    \(NDSolve::"tponly" \(\(:\)\(\ \)\) 
      "Currently the only discretization method implemented is \
SpatialDiscretization->TensorProductGrid."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::tponly"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(u[x, 0] \[Equal] \[ExponentialE]\^\(\(-100\)\ x\^2\)\), 
            ",", \(u[\(-1\), t] \[Equal] u[1, t]\)}], "}"}], ",", "u", 
        ",", \({x, \(-1\), 1}\), ",", \({t, 2}\), 
        ",", \(Method \[Rule] {"MethodOfLines", 
            "SpatialDiscretization" \[Rule] "Triangularization"}\)}], 
      "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::tponly"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::norm", "ObjectNameWarningMessages",
  CellTags->"NDSolve::norm"],

Cell[BoxData[
    \(NDSolve::"norm" \(\(:\)\(\ \)\) \(Invalid\ norm\ `1`\ in\ the\ method\ \
\(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::norm"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::norm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::rclist", "ObjectNameWarningMessages",
  CellTags->"NDSolve::rclist"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NDSolve::"rclist"\), \(\(:\)\(\ \)\), "The", " ", "value", 
        " ", "of", " ", "the", " ", "option", " ", 
        StyleBox["opt",
          "TI"]}], "->", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "should", " ", "be", " ", "Automatic", " ", "or", " ", 
        "a", " ", "list", " ", "of", " ", "the", " ", "coordinate", " ", 
        "lists", " ", "for", " ", "each", " ", "spatial", 
        " ", \(\(dimension\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::rclist"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated option does not \
have one of the expected forms.\
\>", "Notes",
  CellTags->"NDSolve::rclist"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::rclist"],

Cell[TextData[{
  "An error occurs in this example because a matrix is not a valid value for \
the ",
  StyleBox["Coordinates", "MR"],
  " option in this example."
}], "Text",
  CellTags->"NDSolve::rclist"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] {"\<TensorProductGrid\>", \ "\<Coordinates\>" \[Rule] {{1, 2}, {2, 
                    3}}}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::rclist"],

Cell[BoxData[
    \(NDSolve::"rclist" \(\(:\)\(\ \)\) 
      "The value of the option \!\(\"Coordinates\"\)->\!\({\(\({1, 2}\)\), \(\
\({2, 3}\)\)}\) should be Automatic or a list of the coordinate lists for \
each spatial dimension."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::rclist"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(u[x, 0] \[Equal] \[ExponentialE]\^\(\(-100\)\ x\^2\)\), 
            ",", \(u[\(-1\), t] \[Equal] u[1, t]\)}], "}"}], ",", "u", 
        ",", \({x, \(-1\), 1}\), ",", \({t, 2}\), 
        ",", \(Method \[Rule] {"MethodOfLines", 
            "SpatialDiscretization" \[Rule] {"TensorProductGrid", 
                "Coordinates" \[Rule] {{1, 2}, {2, 3}}}}\)}], "]"}]], "Output",\

  CellLabel->"Out[1]=",
  CellTags->"NDSolve::rclist"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::coend", "ObjectNameWarningMessages",
  CellTags->"NDSolve::coend"],

Cell[BoxData[
    \(NDSolve::"coend" \(\(:\)\(\ \)\) \(The\ endpoints\ of\ the\ grid\ \
coordinates\ `1`\ do\ not\ match\ those\ specified\ in\ \
\(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::coend"],

Cell["\<\
\[FilledSmallSquare] Generated when explicitly specified grid \
coordinates are incompatible with the endpoints for the range of the \
corresponding variable.\
\>", "Notes",
  CellTags->"NDSolve::coend"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::coend"],

Cell[TextData[{
  "An error is generated in this example because the minimum and maximum grid \
points specified in the value of the ",
  StyleBox["Coordinates", "MR"],
  " option are not the same as the endpoints of the range of the \
corresponding variable."
}], "Text",
  CellTags->"NDSolve::coend"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] {"\<TensorProductGrid\>", \ "\<Coordinates\>" \[Rule] 
                Range[10]}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::coend"],

Cell[BoxData[
    \(NDSolve::"coend" \(\(:\)\(\ \)\) 
      "The endpoints of the grid coordinates \!\({1.`, 2.`, 3.`, 4.`, 5.`, \
6.`, 7.`, 8.`, 9.`, 10.`}\) do not match those specified in \!\({x, \
\(\(-1.`\)\), 1.`}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::coend"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(u[x, 0] \[Equal] \[ExponentialE]\^\(\(-100\)\ x\^2\)\), 
            ",", \(u[\(-1\), t] \[Equal] u[1, t]\)}], "}"}], ",", "u", 
        ",", \({x, \(-1\), 1}\), ",", \({t, 2}\), 
        ",", \(Method \[Rule] {"MethodOfLines", 
            "SpatialDiscretization" \[Rule] {"TensorProductGrid", 
                "Coordinates" \[Rule] {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}}}\)}], 
      "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::coend"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::coexp", "ObjectNameWarningMessages",
  CellTags->"NDSolve::coexp"],

Cell[BoxData[
    \(NDSolve::"coexp" \(\(:\)\(\ \)\) \(Because\ the\ coordinates\ were\ \
explicitly\ given\ for\ the\ direction\ of\ independent\ variable\ `1`, \ 
      the\ values\ of\ options\ `2`\ will\ be\ disregarded\ for\ this\ \
\(\(direction\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::coexp"],

Cell["\<\
\[FilledSmallSquare] Generated when grid points are specified both \
directly in an explicit list and indirectly with values for the indicated \
options.\
\>", "Notes",
  CellTags->"NDSolve::coexp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::coexp"],

Cell[TextData[{
  "A warning message is generated in this example because the grid points are \
specified both by the value of the ",
  StyleBox["Coordinates", "MR"],
  " option and through the ",
  StyleBox["MinPoints", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::coexp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] {"\<TensorProductGrid\>", \ "\<Coordinates\>" \[Rule] 
                Join[Sin[Pi\ Range[0, 200]/400]\  - \ 1, 
                  1\  - \ Sin[Pi\ Range[199, 0, \(-1\)]/400]]\ , \ 
              MinPoints \[Rule] 4}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::coexp"],

Cell[BoxData[
    \(NDSolve::"coexp" \(\(:\)\(\ \)\) 
      "Because the coordinates were explicitly given for the direction of \
independent variable \!\(x\), the values of options \!\({\"MaxPoints\", \
\"MinPoints\", \(\(\"St\"\[Ellipsis]\"nts\"\)\), \(\(\"\"\[Ellipsis]\"\"\)\), \
\"MinStepSize\", \"StartingStepSize\"}\) will be disregarded for this \
direction."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::coexp"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{"...", \(-1.`\), 1.`, 
                  "..."}, {0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::coexp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ssrei", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ssrei"],

Cell[BoxData[
    \(NDSolve::"ssrei" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ `1` -> \
`2`\ should\ be\ a\ positive\ real\ number\ or\ \(\(Infinity\)\(.\)\)\)\)], \
"Message",
  CellTags->"NDSolve::ssrei"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ssrei"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ssre", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ssre"],

Cell[BoxData[
    \(NDSolve::"ssre" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ `1` -> \
`2`\ should\ be\ a\ positive\ real\ \(\(number\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::ssre"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ssre"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::sfty", "ObjectNameWarningMessages",
  CellTags->"NDSolve::sfty"],

Cell[BoxData[
    \(NDSolve::"sfty" \(\(:\)\(\ \)\) 
      "The option `1`->`2` of the method `3` is not a real number x such that \
0 < x <= 1."\)], "Message",
  CellLabel->"From In[22]:=",
  CellTags->"NDSolve::sfty"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::sfty"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::aord", "ObjectNameWarningMessages",
  CellTags->"NDSolve::aord"],

Cell[BoxData[
    \(NDSolve::"aord" \(\(:\)\(\ \)\) \(The\ selection\ of\ the\ order\ for\ \
the\ method\ `1`\ \(\(failed\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::aord"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::aord"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::sss", "ObjectNameWarningMessages",
  CellTags->"NDSolve::sss"],

Cell[BoxData[
    \(NDSolve::"sss" \(\(:\)\(\ \)\) \(Unable\ to\ determine\ a\ starting\ \
step\ size\ for\ the\ method\ \(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::sss"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::sss"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::mconly", "ObjectNameWarningMessages",
  CellTags->"NDSolve::mconly"],

Cell[BoxData[
    \(NDSolve::"mconly" \(\(:\)\(\ \)\) \(For\ the\ method\ `1`, \ 
      only\ machine\ real\ code\ is\ available . \ 
          Unable\ to\ continue\ with\ complex\ values\ or\ beyond\ floating\ \
point\ \(\(exceptions\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::mconly"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::mconly"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::nolib", "ObjectNameWarningMessages",
  CellTags->"NDSolve::nolib"],

Cell[BoxData[
    \(NDSolve::"nolib" \(\(:\)\(\ \)\) \(The\ library\ for\ the\ method\ `1`\ \
is\ missing\ so\ NDSolve\ is\ unable\ to\ compute\ the\ \(\(solution\)\(.\)\)\
\)\)], "Message",
  CellTags->"NDSolve::nolib"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::nolib"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::nodae", "ObjectNameWarningMessages",
  CellTags->"NDSolve::nodae"],

Cell[BoxData[
    \(NDSolve::"nodae" \(\(:\)\(\ \)\) \(The\ method\ `1`\ is\ not\ currently\
\ implemented\ to\ solve\ differential - 
          algebraic\ equations . \ \ Use\ Method -> 
        Automatic\ \(\(instead\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::nodae"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the equations are determined to \
represent a differential-algebraic system, and the value of the ",
  StyleBox["Method", "MR"],
  " option corresponds to a method that is not implemented for solving \
differential-algebraic equations."
}], "Notes",
  CellTags->"NDSolve::nodae"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::nodae"],

Cell["\<\
A warning message is generated in this example because the \
specified method is not programmed to solve these equations.\
\>", "Text",
  CellTags->"NDSolve::nodae"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  \[Equal] \ y[t], \ 
        y[t]\  + \ x[t]\  \[Equal] \ 0, 
        x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 0}, {x, y}, {t, 0, 
        1}, \ Method \[Rule] BDF]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::nodae"],

Cell[BoxData[
    \(NDSolve::"nodae" \(\(:\)\(\ \)\) 
      "The method \!\(NDSolve`BDF\) is not currently implemented to solve \
differential-algebraic equations.  Use Method->Automatic instead."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::nodae"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::nodae"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::icfail", "ObjectNameWarningMessages",
  CellTags->"NDSolve::icfail"],

Cell[BoxData[
    \(NDSolve::"icfail" \(\(:\)\(\ \)\) \(Unable\ to\ find\ initial\ \
conditions\ which\ satisfy\ the\ residual\ function\ within\ specified\ \
tolerances . \ \ Try\ giving\ initial\ conditions\ for\ both\ values\ and\ \
derivatives\ of\ the\ \(\(functions\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::icfail"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["NDSolve", "MR"],
  " is unable to find initial conditions that satisfy the equations."
}], "Notes",
  CellTags->"NDSolve::icfail"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::icfail"],

Cell["\<\
An error is generated in this example because these equations do \
not have a solution.\
\>", "Text",
  CellTags->"NDSolve::icfail"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  \[Equal] \ y[t], \ 
        y[t]^2\  + \ x[t]^2\  \[Equal] \ \(-1\), 
        x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 0}, {x, y}, {t, 0, 
        1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::icfail"],

Cell[BoxData[
    \(NDSolve::"icfail" \(\(:\)\(\ \)\) 
      "Unable to find initial conditions which satisfy the residual function \
within specified tolerances.  Try giving initial conditions for both values \
and derivatives of the functions."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::icfail"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::icfail"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::lsopt", "ObjectNameWarningMessages",
  CellTags->"NDSolve::lsopt"],

Cell[BoxData[
    \(NDSolve::"lsopt" \(\(:\)\(\ \)\) \(The\ option\ `1` -> `2`\ should\ \
either\ be\ a\ single\ value\ or\ a\ list\ of\ length\ equal\ to\ the\ number\
\ of\ spatial\ independent\ variables, \ \(\(`3`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::lsopt"],

Cell["\<\
\[FilledSmallSquare] Generated when the value of the indicated \
option does not have one of the expected forms.\
\>", "Notes",
  CellTags->"NDSolve::lsopt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::lsopt"],

Cell[TextData[{
  "An error occurs in this example because a list with one element is not a \
valid value for the ",
  StyleBox["MinPoints", "MR"],
  " option when there are two spatial variables."
}], "Text",
  CellTags->"NDSolve::lsopt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, y, t], t]\  \[Equal] \ 
          D[u[x, y, t], x, x]\  + \ D[u[x, y, t], y, y], 
        u[x, y, 0]\  \[Equal] \ Exp[\(-10\)\ x^2], \ 
        u[1, y, t]\  \[Equal] \ Exp[\(-10\)], \ 
        u[\(-1\), y, t]\  \[Equal] \ Exp[\(-10\)], 
        u[x, 1, t]\  \[Equal] \ Exp[\(-10\)\ x^2], 
        u[x, \(-1\), t]\  \[Equal] \ Exp[\(-10\)\ x^2]}, 
      u, {x, \(-1\), 1}, {y, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {"\<MethodOfLines\>", \ "\<SpatialDiscretization\>" \
\[Rule] {"\<TensorProductGrid\>", \ MinPoints \[Rule] {10}}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::lsopt"],

Cell[BoxData[
    \(NDSolve::"lsopt" \(\(:\)\(\ \)\) 
      "The option \!\(\"MinPoints\"\)->\!\({10}\) should either be a single \
value or a list of length equal to the number of spatial independent \
variables, \!\(2\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::lsopt"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, y, t\), "]"}], 
              "\[Equal]", 
              RowBox[{
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((0, 2, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, y, t\), "]"}], "+", 
                RowBox[{
                  SuperscriptBox["u", 
                    TagBox[\((2, 0, 0)\),
                      Derivative],
                    MultilineFunction->None], "[", \(x, y, t\), "]"}]}]}], 
            ",", \(u[x, y, 0] \[Equal] \[ExponentialE]\^\(\(-10\)\ x\^2\)\), 
            ",", \(u[1, y, t] \[Equal] 1\/\[ExponentialE]\^10\), 
            ",", \(u[\(-1\), y, t] \[Equal] 1\/\[ExponentialE]\^10\), 
            ",", \(u[x, 1, t] \[Equal] \[ExponentialE]\^\(\(-10\)\ x\^2\)\), 
            ",", \(u[x, \(-1\), 
                t] \[Equal] \[ExponentialE]\^\(\(-10\)\ x\^2\)\)}], "}"}], 
        ",", "u", ",", \({x, \(-1\), 1}\), ",", \({y, \(-1\), 1}\), 
        ",", \({t, 2}\), 
        ",", \(Method \[Rule] {"MethodOfLines", 
            "SpatialDiscretization" \[Rule] {"TensorProductGrid", 
                MinPoints \[Rule] {10}}}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::lsopt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::molpde", "ObjectNameWarningMessages",
  CellTags->"NDSolve::molpde"],

Cell[BoxData[
    \(NDSolve::"molpde" \(\(:\)\(\ \)\) \(The\ option\ Method -> 
        MethodOfLines\ is\ only\ legitimate\ for\ partial\ differential\ \
equations\ with\ more\ than\ one\ independent\ \(\(variable\)\(.\)\)\)\)], \
"Message",
  CellTags->"NDSolve::molpde"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["MethodOfLines", "MR"],
  " is used as the value of the ",
  StyleBox["Method", "MR"],
  " option and the first argument in ",
  StyleBox["NSolve", "MR"],
  " is not a specification of a partial differential equation."
}], "Notes",
  CellTags->"NDSolve::molpde"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::molpde"],

Cell["\<\
An error occurs in this example because the specified method is not \
designed for solving equations with only one independent variable.\
\>", \
"Text",
  CellTags->"NDSolve::molpde"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  \[Equal] \ y[t], \ 
        y[t]^2\  + \ x[t]^2\  \[Equal] \ \(-1\), 
        x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 0}, {x, y}, {t, 0, 
        1}, \ Method -> "\<MethodOfLines\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::molpde"],

Cell[BoxData[
    \(NDSolve::"molpde" \(\(:\)\(\ \)\) 
      "The option Method->MethodOfLines is only legitimate for partial \
differential equations with more than one independent variable."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::molpde"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], 
              "\[Equal]", \(y[t]\)}], 
            ",", \(x[t]\^2 + y[t]\^2 \[Equal] \(-1\)\), 
            ",", \(x[0] \[Equal] 1\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "\[Equal]", 
              "0"}]}], "}"}], ",", \({x, y}\), ",", \({t, 0, 1}\), 
        ",", \(Method \[Rule] "MethodOfLines"\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::molpde"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::chbvp", "ObjectNameWarningMessages",
  CellTags->"NDSolve::chbvp"],

Cell[BoxData[
    \(NDSolve::"chbvp" \(\(:\)\(\ \)\) \(The\ option\ Method -> 
        Chasing\ is\ only\ legitimate\ for\ boundary\ value\ problems\ with\ \
values\ specified\ at\ two\ or\ more\ distinct\ \(\(points\)\(.\)\)\)\)], \
"Message",
  CellTags->"NDSolve::chbvp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Chasing", "MR"],
  " is used as the value of the ",
  StyleBox["Method", "MR"],
  " option and the first argument in ",
  StyleBox["NSolve", "MR"],
  " is not a specification of a boundary value problem."
}], "Notes",
  CellTags->"NDSolve::chbvp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::chbvp"],

Cell["\<\
An error occurs in this example because the specified method is not \
designed for solving equations that are not boundary value problems.\
\>", \
"Text",
  CellTags->"NDSolve::chbvp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  \[Equal] \ y[t], \ 
        y[t]^2\  + \ x[t]^2\  \[Equal] \ \(-1\), 
        x[0]\  \[Equal] \ 1, \ \(x'\)[0]\  \[Equal] \ 0}, {x, y}, {t, 0, 
        1}, \ Method -> "\<Chasing\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::chbvp"],

Cell[BoxData[
    \(NDSolve::"chbvp" \(\(:\)\(\ \)\) 
      "The option Method->Chasing is only legitimate for boundary value \
problems with values specified at two or more distinct points."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::chbvp"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]\[Prime]",
                  MultilineFunction->None], "[", "t", "]"}], 
              "\[Equal]", \(y[t]\)}], 
            ",", \(x[t]\^2 + y[t]\^2 \[Equal] \(-1\)\), 
            ",", \(x[0] \[Equal] 1\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["x", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "\[Equal]", 
              "0"}]}], "}"}], ",", \({x, y}\), ",", \({t, 0, 1}\), 
        ",", \(Method \[Rule] "Chasing"\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::chbvp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::jpde", "ObjectNameWarningMessages",
  CellTags->"NDSolve::jpde"],

Cell[BoxData[
    \(NDSolve::"jpde" \(\(:\)\(\ \)\) \(For\ PDE' s, \ 
      the\ Jacobian\ will\ be\ computed\ using\ finite\ differences\ unless\ \
you\ have\ chosen\ the\ MethodOfLines\ option\ ExpandEquationsSymbolically -> \
\(\(True\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::jpde"],

Cell["\<\
\[FilledSmallSquare] Generated by an inconsistent specification of \
whether the Jacobian should be computed symbolically or numerically.\
\>", \
"Notes",
  CellTags->"NDSolve::jpde"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::jpde"],

Cell[TextData[{
  "A warning message is generated in this example because the specified value \
of the ",
  StyleBox["Jacobian", "MR"],
  " option will not be used."
}], "Text",
  CellTags->"NDSolve::jpde"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Jacobian -> "\<Symbolic\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::jpde"],

Cell[BoxData[
    \(NDSolve::"jpde" \(\(:\)\(\ \)\) 
      "For PDE's, the Jacobian will be computed using finite differences \
unless you have chosen the MethodOfLines option \
ExpandEquationsSymbolically->True."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::jpde"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"u", "\[Rule]", 
          
          TagBox[\(InterpolatingFunction[{{"...", \(-1.`\), 1.`, 
                  "..."}, {0.`, 2.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::jpde"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::tvar", "ObjectNameWarningMessages",
  CellTags->"NDSolve::tvar"],

Cell[BoxData[
    \(NDSolve::"tvar" \(\(:\)\(\ \)\) \(Value\ of\ option\ `1` -> `2`\ is\ \
not\ one\ of\ the\ independent\ variables, \ \(\(`3`\)\(.\)\)\)\)], "Message",\

  CellTags->"NDSolve::tvar"],

Cell["\<\
\[FilledSmallSquare] Generated when the value of the indicated \
option does not have an expected form.\
\>", "Notes",
  CellTags->"NDSolve::tvar"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::tvar"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["TemporalVariable", "MR"],
  " option is the dependent variable rather than one of the two independent \
variables."
}], "Text",
  CellTags->"NDSolve::tvar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2], \ 
        u[\(-1\), t]\  \[Equal] \ u[1, t]}, u, {x, \(-1\), 1}, {t, 2}, \ 
      Method \[Rule] {MethodOfLines, \ 
          TemporalVariable \[Rule] u}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::tvar"],

Cell[BoxData[
    \(NDSolve::"tvar" \(\(:\)\(\ \)\) 
      "Value of option \!\(\"TemporalVariable\"\)->\!\(u\) is not one of the \
independent variables, \!\({x, t}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::tvar"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(u[x, 0] \[Equal] \[ExponentialE]\^\(\(-100\)\ x\^2\)\), 
            ",", \(u[\(-1\), t] \[Equal] u[1, t]\)}], "}"}], ",", "u", 
        ",", \({x, \(-1\), 1}\), ",", \({t, 2}\), 
        ",", \(Method \[Rule] {MethodOfLines, TemporalVariable \[Rule] u}\)}],
       "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::tvar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::tvic", "ObjectNameWarningMessages",
  CellTags->"NDSolve::tvic"],

Cell[BoxData[
    \(NDSolve::"tvic" \(\(:\)\(\ \)\) \(`1`\ cannot\ be\ used\ as\ the\ \
temporal\ independent\ variable\ because\ the\ conditions, \ `2`, \ 
      for\ that\ dimension\ do\ not\ constitute\ sufficient\ initial\ \
conditions\ given\ at\ only\ one\ value\ of\ \(\(`1`\)\(.\)\)\)\)], "Message",\

  CellTags->"NDSolve::tvic"],

Cell["\<\
\[FilledSmallSquare] Generated when the value of the indicated \
option is a variable that cannot be used as the temporal variable.\
\>", \
"Notes",
  CellTags->"NDSolve::tvic"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::tvic"],

Cell[TextData[{
  "An error occurs in this example because the equations are such that the \
variable specified as the value of the ",
  StyleBox["TemporalVariable", "MR"],
  " option cannot be used as the temporal variable."
}], "Text",
  CellTags->"NDSolve::tvic"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{D[u[x, t], t]\  \[Equal] \ D[u[x, t], x, x], 
        u[x, 0]\  \[Equal] \ Exp[\(-100\)\ x^2]}, 
      u, {x, \(-1\), 1}, {t, 0, 2}, \ 
      Method \[Rule] {MethodOfLines, \ 
          TemporalVariable \[Rule] x}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::tvic"],

Cell[BoxData[
    \(NDSolve::"tvic" \(\(:\)\(\ \)\) 
      "\!\(x\) cannot be used as the temporal independent variable because \
the conditions, \!\({}\), for that dimension do not constitute sufficient \
initial conditions given at only one value of \!\(x\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::tvic"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["u", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(u[x, 0] \[Equal] \[ExponentialE]\^\(\(-100\)\ x\^2\)\)}], 
          "}"}], ",", "u", ",", \({x, \(-1\), 1}\), ",", \({t, 0, 2}\), 
        ",", \(Method \[Rule] {MethodOfLines, TemporalVariable \[Rule] x}\)}],
       "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::tvic"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ponly", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ponly"],

Cell[BoxData[
    \(NDSolve::"ponly" \(\(:\)\(\ \)\) \(The\ method\ given\ in\ Method -> \
`1`\ is\ only\ for\ equation\ processing\ and\ is\ not\ a\ time - 
          stepping\ \(\(method\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::ponly"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ponly"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::mdo", "ObjectNameWarningMessages",
  CellTags->"NDSolve::mdo"],

Cell[BoxData[
    \(NDSolve::"mdo" \(\(:\)\(\ \)\) 
      "The value of \"MaxDifferenceOrder\"->`1` should be an integer from `2` \
through `3` for the method `4`."\)], "Message",
  CellLabel->"From In[24]:=",
  CellTags->"NDSolve::mdo"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the ",
  StyleBox["MaxDifferenceOrder", "MR"],
  " option does not have one of the indicated forms."
}], "Notes",
  CellTags->"NDSolve::mdo"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::mdo"],

Cell[TextData[{
  "A warning message is generated in this example because 9 is not a valid \
value for the ",
  StyleBox["MaxDifferenceOrder", "MR"],
  " option in this example."
}], "Text",
  CellTags->"NDSolve::mdo"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x'\)[t]\  \[Equal] \ x[t], \ x[0]\  \[Equal] \ 1}, 
      x, {t, 0, 1}, \ 
      Method \[Rule] {"\<IDA\>", \ "\<MaxDifferenceOrder\>" \[Rule] 
            9}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::mdo"],

Cell[BoxData[
    \(NDSolve::"mdo" \(\(:\)\(\ \)\) 
      "The value of \"MaxDifferenceOrder\"->\!\(9\) should be an integer from \
\!\(1\) through \!\(5\) for the method \!\(NDSolve`IDA\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::mdo"],

Cell[BoxData[
    \(NDSolve::"initf" \(\(:\)\(\ \)\) 
      "The initialization of the method \!\(NDSolve`IDA\) failed."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::mdo"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 0.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::mdo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::mord", "ObjectNameWarningMessages",
  CellTags->"NDSolve::mord"],

Cell[BoxData[
    \(NDSolve::"mord" \(\(:\)\(\ \)\) \(Unable\ to\ ascertain\ the\ order\ of\
\ the\ method\ \(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::mord"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::mord"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::imps", "ObjectNameWarningMessages",
  CellTags->"NDSolve::imps"],

Cell[BoxData[
    \(NDSolve::"imps" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ \
ImplicitSolver -> `1`\ should\ be\ FixedPoint, \ Newton, \ 
      or\ \(\(GMRES\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::imps"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["ImplicitSolver", "MR"],
  " option is not among the indicated values."
}], "Notes",
  CellTags->"NDSolve::imps"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::imps"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["9", "MR"],
  " is not a valid value for the ",
  StyleBox["ImplicitSolver", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::imps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x'\)[t]\  \[Equal] \ x[t], \ x[0]\  \[Equal] \ 1}, 
      x, {t, 0, 1}, \ 
      Method \[Rule] {"\<IDA\>", \ "\<ImplicitSolver\>" \[Rule] 
            9}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::imps"],

Cell[BoxData[
    \(NDSolve::"imps" \(\(:\)\(\ \)\) 
      "The value of the option ImplicitSolver->\!\(9\) should be FixedPoint, \
Newton, or GMRES."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::imps"],

Cell[BoxData[
    \(NDSolve::"initf" \(\(:\)\(\ \)\) 
      "The initialization of the method \!\(NDSolve`IDA\) failed."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::imps"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 0.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::imps"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::lsm", "ObjectNameWarningMessages",
  CellTags->"NDSolve::lsm"],

Cell[BoxData[
    \(NDSolve::"lsm" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ \
LinearSolveMethod -> `1`\ should\ be\ Automatic\ or\ \(\(Band\)\(.\)\)\)\)], \
"Message",
  CellTags->"NDSolve::lsm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["LinearSolveMethod", "MR"],
  " option is not among the indicated forms.\n\[FilledSmallSquare] This \
message applies to the BDF and IDA methods."
}], "Notes",
  CellTags->"NDSolve::lsm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::lsm"],

Cell[TextData[{
  "A warning is generated in this example because ",
  StyleBox["QRDecomposition", "MR"],
  " is not a valid value of the ",
  StyleBox["LinearSolveMethod", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::lsm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x'\)[t]\  \[Equal] \ x[t], \ x[0]\  \[Equal] \ 1}, 
      x, {t, 0, 1}, \ 
      Method \[Rule] {"\<IDA\>", \ "\<ImplicitSolver\>" \[Rule] \
{"\<Newton\>", \ "\<LinearSolveMethod\>" \[Rule] 
                QRDecomposition}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::lsm"],

Cell[BoxData[
    \(NDSolve::"lsm" \(\(:\)\(\ \)\) 
      "The value of the option LinearSolveMethod->\!\(QRDecomposition\) \
should be Automatic or Band."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::lsm"],

Cell[BoxData[
    \(NDSolve::"initf" \(\(:\)\(\ \)\) 
      "The initialization of the method \!\(NDSolve`IDA\) failed."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::lsm"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 0.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::lsm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bw", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bw"],

Cell[BoxData[
    \(NDSolve::"bw" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ `1` -> `2`\
\ should\ be\ a\ positive\ integer\ or\ a\ list\ of\ two\ positive\ integers\ \
giving\ upper\ and\ lower\ band\ \(\(widths\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::bw"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["BandWidth", "MR"],
  " option is not among the indicated forms.\n\[FilledSmallSquare] This \
message applies to the BDF and IDA methods."
}], "Notes",
  CellTags->"NDSolve::bw"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bw"],

Cell[TextData[{
  "A warning is generated in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value of the ",
  StyleBox["LinearSolveMethod", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::bw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x'\)[t]\  \[Equal] \ x[t], \ x[0]\  \[Equal] \ 1}, 
      x, {t, 0, 1}, \ 
      Method \[Rule] {"\<IDA\>", \ "\<ImplicitSolver\>" \[Rule] \
{"\<Newton\>", \ "\<LinearSolveMethod\>" \[Rule] {"\<Band\>", \ \
"\<BandWidth\>" \[Rule] None}}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bw"],

Cell[BoxData[
    \(NDSolve::"bw" \(\(:\)\(\ \)\) 
      "The value of the option \!\(\"BandWidth\"\)->\!\(None\) should be a \
positive integer or a list of two positive integers giving upper and lower \
band widths."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bw"],

Cell[BoxData[
    \(NDSolve::"initf" \(\(:\)\(\ \)\) 
      "The initialization of the method \!\(NDSolve`IDA\) failed."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bw"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 0.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::otype", "ObjectNameWarningMessages",
  CellTags->"NDSolve::otype"],

Cell[BoxData[
    \(NDSolve::"otype" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ `1` -> \
`2`\ should\ be\ ModifiedGramSchmidt\ or\ \(\(ClassicalGramSchmidt\)\(.\)\)\)\
\)], "Message",
  CellTags->"NDSolve::otype"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["OrthogonalizationType", "MR"],
  " option is not among the indicated forms.\n\[FilledSmallSquare] This \
message applies to the BDF and IDA methods."
}], "Notes",
  CellTags->"NDSolve::otype"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::otype"],

Cell[TextData[{
  "A warning is generated in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value of the ",
  StyleBox["OrthogonalizationType", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::otype"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x'\)[t]\  \[Equal] \ x[t], \ x[0]\  \[Equal] \ 1}, 
      x, {t, 0, 1}, \ 
      Method \[Rule] {"\<IDA\>", \ "\<ImplicitSolver\>" \[Rule] {"\<GMRES\>", \
\ "\<OrthogonalizationType\>" \[Rule] None}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::otype"],

Cell[BoxData[
    \(NDSolve::"otype" \(\(:\)\(\ \)\) 
      "The value of the option \!\(\"OrthogonalizationType\"\)->\!\(None\) \
should be ModifiedGramSchmidt or ClassicalGramSchmidt."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::otype"],

Cell[BoxData[
    \(NDSolve::"initf" \(\(:\)\(\ \)\) 
      "The initialization of the method \!\(NDSolve`IDA\) failed."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::otype"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 0.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::otype"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::scpar", "ObjectNameWarningMessages",
  CellTags->"NDSolve::scpar"],

Cell[BoxData[
    \(NDSolve::"scpar" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ `1` -> \
`2`\ of\ the\ method\ `3`\ should\ be\ Automatic\ or\ a\ pair\ of\ real\ \
numbers\ 0\  <= \ {a, \ b}\  <= \ 1. \)\)], "Message",
  CellTags->"NDSolve::scpar"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::scpar"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::subsp", "ObjectNameWarningMessages",
  CellTags->"NDSolve::subsp"],

Cell[BoxData[
    \(NDSolve::"subsp" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ \ `1` -> \
`2`\ should\ be\ a\ positive\ integer\ or\ \(\(Automatic\)\(.\)\)\)\)], \
"Message",
  CellTags->"NDSolve::subsp"],

Cell["\<\
\[FilledSmallSquare] Generated when the value of the indicated \
option is not among the expected forms.
\[FilledSmallSquare] This message applies to the BDF and IDA methods.\
\>", \
"Notes",
  CellTags->"NDSolve::subsp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::subsp"],

Cell[TextData[{
  "A warning is generated in this example because ",
  StyleBox["E", "MR"],
  " is not a valid value of the ",
  StyleBox["MaxKrylovSubspaceDimension", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::subsp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x'\)[t]\  \[Equal] \ x[t], \ x[0]\  \[Equal] \ 1}, 
      x, {t, 0, 1}, \ 
      Method \[Rule] {"\<IDA\>", \ "\<ImplicitSolver\>" \[Rule] {"\<GMRES\>", \
\ "\<MaxKrylovSubspaceDimension\>" \[Rule] E}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::subsp"],

Cell[BoxData[
    \(NDSolve::"subsp" \(\(:\)\(\ \)\) 
      "The value of the option  \!\(\"MaxKrylovSubspaceDimension\"\)->\!\(\
\[ExponentialE]\) should be a positive integer or Automatic."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::subsp"],

Cell[BoxData[
    \(NDSolve::"initf" \(\(:\)\(\ \)\) 
      "The initialization of the method \!\(NDSolve`IDA\) failed."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::subsp"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 0.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::subsp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ssrb", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ssrb"],

Cell[BoxData[
    \(NDSolve::"ssrb" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ `1` -> \
`2`\ of\ the\ method\ `3`\ should\ be\ a\ pair\ of\ real\ numbers\ {0, \ 
              1}\  <= \ {a, \ 
            b}\  <= \ \(\({1, \ Infinity}\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::ssrb"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ssrb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ssserr", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ssserr"],

Cell[BoxData[
    \(NDSolve::"ssserr" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ `1` -> \
`2`\ of\ the\ method\ `3`\ should\ be\ a\ real\ number\ x\ such\ that\ 0\  \
<= \ x\  < \ 1. \)\)], "Message",
  CellTags->"NDSolve::ssserr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ssserr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::irkcargs", "ObjectNameWarningMessages",
  CellTags->"NDSolve::irkcargs"],

Cell[BoxData[
    \(NDSolve::"irkcargs" \(\(:\)\(\ \)\) 
      "The argument `1` in ImplicitRungeKuttaCoefficients is not `2`."\)], \
"Message",
  CellLabel->"From In[22]:=",
  CellTags->"NDSolve::irkcargs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::irkcargs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::irkcopts", "ObjectNameWarningMessages",
  CellTags->"NDSolve::irkcopts"],

Cell[BoxData[
    \(NDSolve::"irkcopts" \(\(:\)\(\ \)\) 
      "The option `1` in ImplicitRungeKuttaCoefficients is not `2`."\)], \
"Message",
  CellLabel->"From In[22]:=",
  CellTags->"NDSolve::irkcopts"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::irkcopts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::irkcploss", "ObjectNameWarningMessages",
  CellTags->"NDSolve::irkcploss"],

Cell[BoxData[
    \(NDSolve::"irkcploss" \(\(:\)\(\ \)\) \(Only\ obtained\ precision\ `1`\ \
of\ requested\ precision\ `2` . \ 
          Try\ increasing\ $MaxExtraPrecision\)\)], "Message",
  CellTags->"NDSolve::irkcploss"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::irkcploss"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`Iterate::sivpd", "ObjectNameWarningMessages",
  CellTags->"NDSolve`Iterate::sivpd"],

Cell[BoxData[
    \(NDSolve`Iterate::"sivpd" \(\(:\)\(\ \)\) \(The\ first\ argument\ `1`\ \
to\ `2`\ should\ be\ a\ symbol\ assigned\ to\ a\ value\ which\ is\ a\ valid\ \
`3`\ \(\(object\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`Iterate::sivpd"],

Cell["\<\
\[FilledSmallSquare] This message can be generated by an incorrect \
use of certain internal numerical linear algebra functions.\
\>", "Notes",
  CellTags->"NDSolve`Iterate::sivpd"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve`Iterate::sivpd"],

Cell["\<\
Messages are generated in the following examples because the \
arguments to this internal function are incorrect.\
\>", "Text",
  CellTags->"NDSolve`Iterate::sivpd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`Iterate[1, 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve`Iterate::sivpd"],

Cell[BoxData[
    \(NDSolve`Iterate::"sivpd" \(\(:\)\(\ \)\) 
      "The first argument \!\(1\) to \!\(NDSolve`Iterate\) should be a symbol \
assigned to a value which is a valid \!\(NDSolve`StateData\) object."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve`Iterate::sivpd"],

Cell[BoxData[
    \(NDSolve`Iterate[1, 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve`Iterate::sivpd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`Iterate[
      Evaluate[First[
          NDSolve`ProcessEquations[{\(x'\)[t] \[Equal] \ x[t], \ 
              x[0]\  \[Equal] \ 1}, x, t]]], 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve`Iterate::sivpd"],

Cell[BoxData[
    RowBox[{\(NDSolve`Iterate::"sivpd"\), \(\(:\)\(\ \)\), "\<\"The first \
argument \\!\\(\\*TagBox[\\(NDSolve`StateData[\\(\\(\\\"<\\\"\[InvisibleSpace]\
0.`\[InvisibleSpace]\\\">\\\"\\)\\)]\\), False, Rule[Editable, False]]\\) to \
\\!\\(NDSolve`Iterate\\) should be a symbol assigned to a value which is a \
valid \\!\\(NDSolve`StateData\\) object.\"\>"}]], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"NDSolve`Iterate::sivpd"],

Cell[BoxData[
    RowBox[{"NDSolve`Iterate", "[", 
      RowBox[{
        TagBox[
          RowBox[{"NDSolve`StateData", "[", 
            
            InterpretationBox[\("<"\[InvisibleSpace]0.`\[InvisibleSpace]">"\),
              
              SequenceForm[ "<", 0.0, ">"],
              Editable->False], "]"}],
          False,
          Editable->False], ",", "1"}], "]"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve`Iterate::sivpd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::exseq", "ObjectNameWarningMessages",
  CellTags->"NDSolve::exseq"],

Cell[BoxData[
    \(NDSolve::"exseq" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ `1`\  \
-> \ `2`\ for\ the\ method\ `3`\ should\ be\ either\ Automatic, \ 
      a\ strictly\ increasing\ list\ of\ at\ least\ `4`\ positive\ integers\ \
or\ a\ function, \ f, \ 
      which\ generates\ such\ a\ list\ with\ \(\({f[1], 
            f[2],  ... }\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::exseq"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::exseq"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::exseqev", "ObjectNameWarningMessages",
  CellTags->"NDSolve::exseqev"],

Cell[BoxData[
    \(NDSolve::"exseqev" \(\(:\)\(\ \)\) \(Warning : \ 
          extrapolation\ for\ the\ method\ `1`\ will\ not\ be\ done\ in\ even\
\ powers\ because\ the\ value\ of\ the\ option\ `2` -> `3`\ does\ not\ give\ \
only\ even\ \(\(numbers\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::exseqev"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::exseqev"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::exmaxo", "ObjectNameWarningMessages",
  CellTags->"NDSolve::exmaxo"],

Cell[BoxData[
    \(NDSolve::"exmaxo" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ `1`\  \
-> \ `2`\ for\ the\ method\ `3`\ should\ be\ Automatic, \ Infinity, \ 
      or\ an\ integer\ greater\ than\ or\ equal\ to\ \(\(`4`\)\(.\)\)\)\)], \
"Message",
  CellTags->"NDSolve::exmaxo"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::exmaxo"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::exmino", "ObjectNameWarningMessages",
  CellTags->"NDSolve::exmino"],

Cell[BoxData[
    \(NDSolve::"exmino" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ `1`\  \
-> \ `2`\ for\ the\ method\ `3`\ should\ be\ Automatic\ or\ an\ integer\ \
greater\ than\ or\ equal\ to\ \(\(`4`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::exmino"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::exmino"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::exsord", "ObjectNameWarningMessages",
  CellTags->"NDSolve::exsord"],

Cell[BoxData[
    \(NDSolve::"exsord" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ `1`\  \
-> \ `2`\ of\ the\ method\ `3`\ should\ be\ a\ positive\ integer\ strictly\ \
between\ `4`\ and\ \(\(`5`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::exsord"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::exsord"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NDSolve::exordf
NDSolve::sssf\
\>", "ObjectNameWarningMessages",
  CellTags->{"NDSolve::exordf", "NDSolve::sssf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sssf\"\>"}], \(\(:\)\(\ \)\), "\<\"The value of the option \
`1` -> `2` for the method `3` should be a list of `4` real numbers between 0 \
and 1.\"\>"}]], "Message",
  CellLabel->"From In[11]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NDSolve::exordf", "NDSolve::sssf"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"NDSolve::exordf", "NDSolve::sssf"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`FiniteDifferenceDerivative::deriv", "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"deriv" \(\(:\)\(\ \)\) \(`1`\ \
should\ be\ a\ Derivative\ operator\ with\ non - 
        negative\ integer\ order \(\((s)\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],

Cell["\<\
\[FilledSmallSquare] Generated by an incorrect use of the indicated \
internal function.\
\>", "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],

Cell["\<\
An error is generated in this example because the arguments to this \
internal function are incorrect.\
\>", "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[E, Range[10]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"deriv" \(\(:\)\(\ \)\) 
      "\!\(\[ExponentialE]\) should be a Derivative operator with \
non-negative integer order(s)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[\[ExponentialE], {1, 2, 3, 4, 5, 6, 
        7, 8, 9, 10}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`FiniteDifferenceDerivative::ldim", "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"ldim" \(\(:\)\(\ \)\) \(`1`\ \
should\ be\ a\ list\ with\ an\ element\ for\ each\ of\ the\ `2`\ \
\(\(dimensions\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],

Cell["\<\
\[FilledSmallSquare] Generated by an incorrect use of the indicated \
internal function.\
\>", "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],

Cell["\<\
An error is generated in this example because the arguments to this \
internal function are incorrect.\
\>", "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[Derivative[1, 0], 
      Range[10]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"ldim" \(\(:\)\(\ \)\) 
      "\!\({1, 2, 3, 4, 5, 6, 7, 8, 9, 10}\) should be a list with an element \
for each of the \!\(2\) dimensions."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[
      Derivative[1, 0], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`FiniteDifferenceDerivative::grid", "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"grid" \(\(:\)\(\ \)\) \(The\ grid\ \
`1`\ given\ for\ dimension\ `2`\ is\ not\ an\ increasing\ list\ of\ distinct\ \
real\ \(\(coordinates\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],

Cell["\<\
\[FilledSmallSquare] Generated by an incorrect use of the indicated \
internal function.\
\>", "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],

Cell["\<\
An error is generated in this example because the arguments to this \
internal function are incorrect.\
\>", "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[Derivative[1], {0, 0, 0}]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"grid" \(\(:\)\(\ \)\) 
      "The grid \!\({0, 0, 0}\) given for dimension \!\(1\) is not an \
increasing list of distinct real coordinates."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[
      Derivative[1], {0, 0, 0}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"]
}, Open  ]],

Cell["\<\
An error is generated in this example because the arguments to this \
internal function are incorrect. This input should generate the message and \
return the input.\
\>", "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[Derivative[1], 
      Cos[Pi\ Range[0, 10]/10], \ PeriodicInterpolation \[Rule] True, \ 
      DifferenceOrder -> "\<Pseudospectral\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"grid" \(\(:\)\(\ \)\) 
      "The grid \!\({1, \(\(1\/2\\ \@\(1\/2\\ \(\((5 + \@5)\)\)\)\)\), \
\(\(1\/4\\ \(\((1 + \@5)\)\)\)\), \(\(\[LeftSkeleton] 5 \[RightSkeleton]\)\), \
\(\(\(\(-\(\(1\/4\)\)\)\)\\ \(\((1 + \@5)\)\)\)\), \
\(\(\(\(-\(\(1\/2\)\)\)\)\\ \@\(1\/2\\ \(\((5 + \@5)\)\)\)\)\), \(\(-1\)\)}\) \
given for dimension \!\(1\) is not an increasing list of distinct real \
coordinates."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[
      Derivative[1], {1, 1\/2\ \@\(1\/2\ \((5 + \@5)\)\), 
        1\/4\ \((1 + \@5)\), 1\/2\ \@\(1\/2\ \((5 - \@5)\)\), 
        1\/4\ \((\(-1\) + \@5)\), 
        0, \(-\(1\/4\)\)\ \((\(-1\) + \@5)\), \(-\(1\/2\)\)\ \@\(1\/2\ \((5 - \
\@5)\)\), \(-\(1\/4\)\)\ \((1 + \@5)\), \(-\(1\/2\)\)\ \@\(1\/2\ \((5 + \
\@5)\)\), \(-1\)}, PeriodicInterpolation \[Rule] True, 
      DifferenceOrder \[Rule] "Pseudospectral"]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`FiniteDifferenceDerivative::aord", "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"aord" \(\(:\)\(\ \)\) \(The\ \
approximation\ order\ `1`\ given\ for\ dimension\ `2`\ should\ be\ a\ \
positive\ machine - sized\ integer\ or\ \(\(`3`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],

Cell["\<\
\[FilledSmallSquare] Generated by an incorrect use of the indicated \
internal function.\
\>", "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],

Cell["\<\
An error is generated in this example because the arguments to this \
internal function are incorrect.\
\>", "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[Derivative[1], Range[10], \ 
      DifferenceOrder \[Rule] \(-4\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"aord" \(\(:\)\(\ \)\) 
      "The approximation order \!\(-4\) given for dimension \!\(1\) should be \
a positive machine-sized integer or \!\(\"Pseudospectral\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[
      Derivative[1], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, 
      DifferenceOrder \[Rule] \(-4\)]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"]
}, Open  ]],

Cell["\<\
An error is generated in this example because the arguments to this \
internal function are incorrect.\
\>", "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(NDSolve`FiniteDifferenceDerivative[Derivative[1], Range[10], \ 
        DifferenceOrder -> "\<PseudoSpectral\>", \ 
        PeriodicInterpolation \[Rule] True]\)[Array[x, 10]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"aord" \(\(:\)\(\ \)\) 
      "The approximation order \!\(\"PseudoSpectral\"\) given for dimension \
\!\(1\) should be a positive machine-sized integer or \
\!\(\"Pseudospectral\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],

Cell[BoxData[
    \(\(NDSolve`FiniteDifferenceDerivative[
        Derivative[1], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, 
        DifferenceOrder \[Rule] "PseudoSpectral", 
        PeriodicInterpolation \[Rule] True]\)[{x[1], x[2], x[3], x[4], x[5], 
        x[6], x[7], x[8], x[9], x[10]}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`FiniteDifferenceDerivative::per", "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"per" \(\(:\)\(\ \)\) \(The\ \
specification\ of\ periodicity\ `1`\ given\ for\ dimension\ `2`\ should\ be\ \
either\ True\ or\ \(\(False\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],

Cell["\<\
\[FilledSmallSquare] Generated by an incorrect use of the indicated \
internal function.\
\>", "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],

Cell["\<\
An error is generated in this example because the arguments to this \
internal function are incorrect.\
\>", "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[Derivative[1], Range[10], \ 
      PeriodicInterpolation \[Rule] Maybe]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"per" \(\(:\)\(\ \)\) 
      "The specification of periodicity \!\(Maybe\) given for dimension \!\(1\
\) should be either True or False."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[
      Derivative[1], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, 
      PeriodicInterpolation \[Rule] Maybe]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`FiniteDifferenceDerivative::spu", "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spu"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"spu" \(\(:\)\(\ \)\) \(The\ \
coordinates\ `1`\ for\ dimension\ `2`\ are\ not\ uniformly\ spaced . \ 
          Periodic\ pseudospectral\ derivatives\ are\ computed\ on\ a\ \
uniform\ \(\(grid\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spu"],

Cell["\<\
\[FilledSmallSquare] Generated by an incorrect use of the indicated \
internal function.\
\>", "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spu"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`FiniteDifferenceDerivative::spc", "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"spc" \(\(:\)\(\ \)\) \(The\ \
coordinates\ `1`\ for\ dimension\ `2`\ do\ not\ have\ spacing\ proportional\ \
to\ the\ Chebyshev\ points\  - 
        Cos[Range[0, `3`]\ Pi/`3`] . \ 
            Nonperiodic\ pseudospectral\ derivatives\ are\ only\ computed\ \
for\ this\ \(\(spacing\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],

Cell["\<\
\[FilledSmallSquare] Generated by an incorrect use of the indicated \
internal function.\
\>", "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],

Cell["\<\
An error is generated in this example because the arguments to this \
internal function are incorrect.\
\>", "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[Derivative[1], Range[10], 
      DifferenceOrder -> "\<Pseudospectral\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"spc" \(\(:\)\(\ \)\) 
      "The coordinates \!\({1, 2, 3, 4, 5, 6, 7, 8, 9, 10}\) for dimension \!\
\(1\) do not have spacing proportional to the Chebyshev points \
-Cos[Range[0,\!\(9\)] Pi/\!\(9\)]. Nonperiodic pseudospectral derivatives are \
only computed for this spacing."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[
      Derivative[1], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10}, 
      DifferenceOrder \[Rule] "Pseudospectral"]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`FiniteDifferenceDerivative::conw", "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"conw" \(\(:\)\(\ \)\) \(There\ are\
\ insufficient\ points\ in\ dimension\ `1`\ to\ generate\ consistent\ finite\ \
different\ \(\(weights\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],

Cell["\<\
\[FilledSmallSquare] Generated by an incorrect use of the indicated \
internal function.\
\>", "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],

Cell["\<\
An error is generated in this example because the arguments to this \
internal function are incorrect.\
\>", "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[Derivative[1], Range[1], \ 
      DifferenceOrder \[Rule] 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"conw" \(\(:\)\(\ \)\) 
      "There are insufficient points in dimension \!\(1\) to generate \
consistent finite different weights."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[Derivative[1], {1}, 
      DifferenceOrder \[Rule] 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`FiniteDifferenceDerivative::ordred", "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"ordred" \(\(:\)\(\ \)\) \(There\ \
are\ insufficient\ points\ in\ dimension\ `1`\ to\ achieve\ the\ requested\ \
approximation\ order . \ 
          Order\ will\ be\ reduced\ to\ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],

Cell["\<\
\[FilledSmallSquare] Generated by difficulty within the algorithm \
used by the indicated internal function.\
\>", "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],

Cell["\<\
An error is generated in this example because the arguments to this \
internal function are incorrect.\
\>", "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative[Derivative[1], Range[10], 
      DifferenceOrder \[Rule] 12]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivative::"ordred" \(\(:\)\(\ \)\) 
      "There are insufficient points in dimension \!\(1\) to achieve the \
requested approximation order. Order will be reduced to \!\(9\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],

Cell[BoxData[
    TagBox[\(NDSolve`FiniteDifferenceDerivativeFunction[Derivative[1], 
        "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`FiniteDifferenceDerivativeFunction::ddim", \
"ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivativeFunction::"ddim" \(\(:\)\(\ \)\) \
\(Data\ `1`\ is\ not\ a\ rectangular\ tensor\ with\ dimensions\ \
\(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],

Cell["\<\
\[FilledSmallSquare] Generated by an incorrect use of the indicated \
internal function.\
\>", "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],

Cell["\<\
An error is generated in this example because the arguments to this \
internal function are incorrect.\
\>", "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(NDSolve`FiniteDifferenceDerivative[Derivative[1], 
        Range[10]]\)[{1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivativeFunction::"ddim" \(\(:\)\(\ \)\) 
      "Data \!\({1}\) is not a rectangular tensor with dimensions \
\!\({10}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],

Cell[BoxData[
    RowBox[{
      TagBox[\(NDSolve`FiniteDifferenceDerivativeFunction[Derivative[1], 
          "<>"]\),
        False,
        Editable->False], "[", \({1}\), "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`FiniteDifferenceDerivativeFunction::spnum", \
"ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::spnum"],

Cell[BoxData[
    \(NDSolve`FiniteDifferenceDerivativeFunction::"spnum" \(\(:\)\(\ \)\) \
\(Data\ `1`\ is\ exact\ or\ symbolic . \ 
          Spectral\ weight\ computation\ requires\ data\ with\ approximate\ \
\(\(numbers\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::spnum"],

Cell["\<\
\[FilledSmallSquare] Generated by an incorrect use of the indicated \
internal function.\
\>", "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::spnum"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::bcuns", "ObjectNameWarningMessages",
  CellTags->"NDSolve::bcuns"],

Cell[BoxData[
    \(NDSolve::"bcuns" \(\(:\)\(\ \)\) \(Boundary\ condition\ `1`\ cannot\ be\
\ satisfied\ in\ \(\(general\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::bcuns"],

Cell["\<\
\[FilledSmallSquare] Generated when the equations for the boundary \
conditions cannot be solved.\
\>", "Notes",
  CellTags->"NDSolve::bcuns"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::bcuns"],

Cell["\<\
An error is generated in this example because one of the boundary \
conditions does not have a solution.\
\>", "Text",
  CellTags->"NDSolve::bcuns"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 2]\)[f]\)[x, t], f[1, t] == 1 + f[1, t], 
        f[2, t] == 2, f[x, 0] == x, \(\(Derivative[0, 1]\)[f]\)[x, 0] == 0}, 
      f, {x, 1, 2}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::bcuns"],

Cell[BoxData[
    \(NDSolve::"bcuns" \(\(:\)\(\ \)\) 
      "Boundary condition \!\(\(\(f[\(\(1, t\)\)]\)\) \[Equal] \(\(1 + \(\(f[\
\(\(1, t\)\)]\)\)\)\)\) cannot be satisfied in general."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::bcuns"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((2, 0)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}], "\[Equal]", 
              
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 2)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, t\), "]"}]}], 
            ",", \(f[1, t] \[Equal] 1 + f[1, t]\), 
            ",", \(f[2, t] \[Equal] 2\), ",", \(f[x, 0] \[Equal] x\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["f", 
                  TagBox[\((0, 1)\),
                    Derivative],
                  MultilineFunction->None], "[", \(x, 0\), "]"}], "\[Equal]", 
              "0"}]}], "}"}], ",", "f", ",", \({x, 1, 2}\), 
        ",", \({t, 0, 1}\)}], "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::bcuns"]
}, Open  ]],

Cell["\<\
This shows a valid specification of a solution of this partial \
differential equation.\
\>", "Text",
  CellTags->"NDSolve::bcuns"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(\(Derivative[2, 0]\)[f]\)[x, 
            t] == \(\(Derivative[0, 2]\)[f]\)[x, t], f[1, t] == 1, 
        f[2, t] == 2, f[x, 0] == x, \(\(Derivative[0, 1]\)[f]\)[x, 0] == 0}, 
      f, {x, 1, 2}, {t, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::bcuns"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"f", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{1.`, 2.`}, {0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::bcuns"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::dvout", "ObjectNameWarningMessages",
  CellTags->"NDSolve::dvout"],

Cell[BoxData[
    \(NDSolve::"dvout" \(\(:\)\(\ \)\) \(The\ output\ function\ `1`\ is\ not\ \
one\ of\ the\ dependent\ variables, \ \ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::dvout"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::dvout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::idobj", "ObjectNameWarningMessages",
  CellTags->"NDSolve::idobj"],

Cell[BoxData[
    \(NDSolve::"idobj" \(\(:\)\(\ \)\) \(The\ data\ object\ `1`\ is\ not\ a\ \
valid\ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::idobj"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::idobj"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ivdae", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ivdae"],

Cell[BoxData[
    \(NDSolve::"ivdae" \(\(:\)\(\ \)\) \(For\ differential - 
        algebraic\ equations, \ 
      initial\ conditions\ need\ to\ be\ given\ for\ either\ all\ of\ the\ \
non - algebraic\ variables\ or\ their\ \(\(derivatives\)\(.\)\)\)\)], \
"Message",
  CellTags->"NDSolve::ivdae"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by difficulty handling algebraic equations \
in the input to ",
  StyleBox["NDSolve", "MR"],
  "."
}], "Notes",
  CellTags->"NDSolve::ivdae"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::ivdae"],

Cell[TextData[{
  "An error occurs in this example because there is only one initial \
condition for ",
  StyleBox["x[t]", "MR"],
  "."
}], "Text",
  CellTags->"NDSolve::ivdae"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ y[t]\  == \ 0, y[t]\  \[Equal] \ x[t], \ 
        x[0]\  \[Equal] \ 0, \ 
        y[0]\  \[Equal] \ 1, \ \(y'\)[0]\  \[Equal] \ 0}, {x, y}, {t, 0, 
        1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::ivdae"],

Cell[BoxData[
    \(NDSolve::"ivdae" \(\(:\)\(\ \)\) 
      "For differential-algebraic equations, initial conditions need to be \
given for either all of the non-algebraic variables or their \
derivatives."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::ivdae"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(y[t]\), "+", 
                RowBox[{
                  SuperscriptBox["x", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
              "0"}], ",", \(y[t] \[Equal] x[t]\), ",", \(x[0] \[Equal] 0\), 
            ",", \(y[0] \[Equal] 1\), ",", 
            RowBox[{
              RowBox[{
                SuperscriptBox["y", "\[Prime]",
                  MultilineFunction->None], "[", "0", "]"}], "\[Equal]", 
              "0"}]}], "}"}], ",", \({x, y}\), ",", \({t, 0, 1}\)}], 
      "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::ivdae"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ivres", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ivres"],

Cell[BoxData[
    \(NDSolve::"ivres" \(\(:\)\(\ \)\) \(NDSolve\ has\ computed\ initial\ \
values\ which\ give\ a\ zero\ residual\ for\ the\ differential - 
        algebraic\ system, \ 
      but\ some\ components\ are\ different\ from\ those\ specified . \ \ \ \
If\ you\ need\ those\ to\ be\ satisfied, \ 
      it\ is\ recommended\ that\ you\ give\ initial\ conditions\ for\ all\ \
dependent\ variables\ and\ derivatives\ of\ \(\(them\)\(.\)\)\)\)], "Message",\

  CellTags->"NDSolve::ivres"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ivres"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndtola", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndtola"],

Cell[BoxData[
    \(NDSolve::"ndtola" \(\(:\)\(\ \)\) \(A\ component\ of\ the\ solution\ at\
\ `1`\  == \ `2`\ is\ essentially\ zero\ and\ the\ tolerance\ specified\ by\ \
the\ AccuracyGoal\ option\ could\ not\ be\ \(\(achieved\)\(.\)\)\)\)], \
"Message",
  CellTags->"NDSolve::ndtola"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ndtola"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::nfnan", "ObjectNameWarningMessages",
  CellTags->"NDSolve::nfnan"],

Cell[BoxData[
    \(NDSolve::"nfnan" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ \
NormFunction -> `1`\ applied\ to\ the\ current\ scaled\ error\ vector\ was\ \
`2`\ which\ is\ not\ a\ \(\(number\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::nfnan"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["NormFunction", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->"NDSolve::nfnan"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::nfnan"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["NormFunction", "MR"],
  " option."
}], "Text",
  CellTags->"NDSolve::nfnan"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(x''\)[t]\  + \ x[t]\ x[t]\  == \ 0, \ 
        x[0]\  \[Equal] \ {0}, \ \(x'\)[0]\  \[Equal] \ {1}}, x, {t, 0, 1}, \ 
      NormFunction \[Rule] None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::nfnan"],

Cell[BoxData[
    \(NDSolve::"nfnan" \(\(:\)\(\ \)\) 
      "The value of the option NormFunction->\!\(None\) applied to the \
current scaled error vector was \!\(None[\(\({9.490626562425165`*^7, \
0.`}\)\)]\) which is not a number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::nfnan"],

Cell[BoxData[
    \(NDSolve::"nderr" \(\(:\)\(\ \)\) 
      "Error test failure at \!\(t\) == \!\(0.`\); unable to continue."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::nfnan"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"x", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 0.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::nfnan"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::nfp", "ObjectNameWarningMessages",
  CellTags->"NDSolve::nfp"],

Cell[BoxData[
    \(NDSolve::"nfp" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ \
NormFunction -> `1`\ applied\ to\ the\ current\ scaled\ error\ vector\ was\ \
`2`\ which\ is\ not\ a\ nonnegative\ real\ \(\(number\)\(.\)\)\)\)], "Message",\

  CellTags->"NDSolve::nfp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::nfp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::nodv", "ObjectNameWarningMessages",
  CellTags->"NDSolve::nodv"],

Cell[BoxData[
    \(NDSolve::"nodv" \(\(:\)\(\ \)\) \(No\ dependent\ variables\ were\ found\
\ in\ the\ equations . \ \ Make\ sure\ that\ your\ functions\ appear\ with\ \
the\ independent\ variables\ in\ the\ arguments, \ 
      as\ in\ x[
            t] . \ \ You\ may\ want\ to\ specify\ them\ explicitly\ using\ \
the\ DependentVariables\ \(\(option\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::nodv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::nodv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NDSolve::nodv"],

Cell[TextData[{
  "An error occurs in this example because the dependent variable ",
  StyleBox["z[t]", "MR"],
  " does not appear in the differential equation."
}], "Text",
  CellTags->"NDSolve::nodv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{z' \[Equal] 1, z[0] \[Equal] 0}, z, {t, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NDSolve::nodv"],

Cell[BoxData[
    \(NDSolve::"nodv" \(\(:\)\(\ \)\) 
      "No dependent variables were found in the equations.  Make sure that \
your functions appear with the independent variables in the arguments, as in \
x[t].  You may want to specify them explicitly using the DependentVariables \
option."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NDSolve::nodv"],

Cell[BoxData[
    RowBox[{"NDSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              SuperscriptBox["z", "\[Prime]",
                MultilineFunction->None], "\[Equal]", "1"}], 
            ",", \(z[0] \[Equal] 0\)}], "}"}], ",", "z", ",", \({t, 0, 1}\)}],
       "]"}]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NDSolve::nodv"]
}, Open  ]],

Cell["This shows a valid specification of a differential equation.", "Text",
  CellTags->"NDSolve::nodv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NDSolve[{\(z'\)[t] \[Equal] 1, z[0] \[Equal] 0}, 
      z, {t, 0, 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NDSolve::nodv"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"z", "\[Rule]", 
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
            False,
            Editable->False]}], "}"}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NDSolve::nodv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::noout", "ObjectNameWarningMessages",
  CellTags->"NDSolve::noout"],

Cell[BoxData[
    \(NDSolve::"noout" \(\(:\)\(\ \)\) \(No\ functions\ were\ specified\ for\ \
output\ from\ \(\(NDSolve\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::noout"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::noout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::pdeopt", "ObjectNameWarningMessages",
  CellTags->"NDSolve::pdeopt"],

Cell[BoxData[
    \(NDSolve::"pdeopt" \(\(:\)\(\ \)\) \(If\ the\ option\ `1`\ to\ NDSolve\ \
is\ a\ list, \ it\ must\ have\ length\ 2. \)\)], "Message",
  CellTags->"NDSolve::pdeopt"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::pdeopt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`ProcessSolutions::nodata", "ObjectNameWarningMessages",
  CellTags->"NDSolve`ProcessSolutions::nodata"],

Cell[BoxData[
    \(NDSolve`ProcessSolutions::"nodata" \(\(:\)\(\ \)\) \(No\ solution\ data\
\ was\ computed\ between\ `1`\  == \ `2`\ and\ `1`\  == \ \
\(\(`3`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`ProcessSolutions::nodata"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve`ProcessSolutions::nodata"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`ScaledVectorNorm::fnnan", "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::fnnan"],

Cell[BoxData[
    \(NDSolve`ScaledVectorNorm::"fnnan" \(\(:\)\(\ \)\) \(The\ norm\ function\
\ applied\ to\ the\ scaled\ vector\ gave\ `1`\ which\ is\ not\ a\ \
\(\(number\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`ScaledVectorNorm::fnnan"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::fnnan"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`ScaledVectorNorm::nfp", "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::nfp"],

Cell[BoxData[
    \(NDSolve`ScaledVectorNorm::"nfp" \(\(:\)\(\ \)\) \(The\ norm\ function\ \
applied\ to\ the\ scaled\ vector\ gave\ `1`\ which\ is\ not\ a\ nonnegative\ \
real\ \(\(number\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`ScaledVectorNorm::nfp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::nfp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`ScaledVectorNorm::nvec", "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::nvec"],

Cell[BoxData[
    \(NDSolve`ScaledVectorNorm::"nvec" \(\(:\)\(\ \)\) \(No\ vector\ \
\(\(specified\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`ScaledVectorNorm::nvec"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::nvec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`ScaledVectorNorm::pinp", "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::pinp"],

Cell[BoxData[
    \(NDSolve`ScaledVectorNorm::"pinp" \(\(:\)\(\ \)\) \(Argument\ `1`\ at\ \
position\ 1\ in\ `2`\ should\ be\ a\ real\ number\ greater\ than\ or\ equal\ \
to\ 1\ or\ a\ function\ to\ compute\ the\ norm\ of\ the\ scaled\ \(\(vector\)\
\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`ScaledVectorNorm::pinp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::pinp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`ScaledVectorNorm::sinp", "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::sinp"],

Cell[BoxData[
    \(NDSolve`ScaledVectorNorm::"sinp" \(\(:\)\(\ \)\) \(The\ scaling\ vector\
\ argument\ `1`\ is\ not\ a\ nonempty\ list\ of\ \(\(numbers\)\(.\)\)\)\)], \
"Message",
  CellTags->"NDSolve`ScaledVectorNorm::sinp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::sinp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve`ScaledVectorNorm::tinp", "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::tinp"],

Cell[BoxData[
    \(NDSolve`ScaledVectorNorm::"tinp" \(\(:\)\(\ \)\) \(Argument\ `1`\ \
should\ be\ a\ list\ of\ nonnegative\ real\ numbers, \ {rtol, \ atol}, \ 
      giving\ relative\ and\ absolute\ tolerances\ with\ at\ least\ one\ \
strictly\ \(\(positive\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve`ScaledVectorNorm::tinp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::tinp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NDSolve::urange
NDSolve`ScaledVectorNorm::urange\
\>", "ObjectNameWarningMessages",
  CellTags->{"NDSolve::urange", "NDSolve`ScaledVectorNorm::urange"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"urange\"\>"}], \(\(:\)\(\ \)\), \(The\ scaling\ vector\ \
has\ a\ zero\ component, \ 
      so\ the\ zero\ absolute\ tolerance\ leads\ to\ an\ unbounded\ \(\(value\
\)\(.\)\)\)}]], "Message",
  CellTags->{"NDSolve::urange", "NDSolve`ScaledVectorNorm::urange"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"NDSolve::urange", "NDSolve`ScaledVectorNorm::urange"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::eord", "ObjectNameWarningMessages",
  CellTags->"NDSolve::eord"],

Cell[BoxData[
    \(NDSolve::"eord" \(\(:\)\(\ \)\) \(The\ value\ of\ the\ option\ `1`\  \
-> \ `2`\ should\ give\ a\ positive\ machine\ integer\ greater\ than\ 1\ for\ \
the\ method\ \(\(`3`\)\(.\)\)\)\)], "Message",
  CellTags->"NDSolve::eord"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::eord"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::ndstab", "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndstab"],

Cell[BoxData[
    \(NDSolve::\(ndstab : \ 
        Stability\ check\ failed\ at\ `1`\  == \ \(\(`2`\)\(.\)\)\)\)], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NDSolve::ndstab"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::ndstab"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::maxsts", "ObjectNameWarningMessages",
  CellTags->"NDSolve::maxsts"],

Cell[BoxData[
    \(NDSolve::"maxsts" \(\(:\)\(\ \)\) 
      "The option `1`->`2` in the method `3` is not a positive machine \
integer or Infinity."\)], "Message",
  CellLabel->"From In[19]:=",
  CellTags->"NDSolve::maxsts"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::maxsts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NDSolve::mtdp", "ObjectNameWarningMessages",
  CellTags->"NDSolve::mtdp"],

Cell[BoxData[
    \(NDSolve::"mtdp" \(\(:\)\(\ \)\) 
      "Unable to determine if the method `1` has the property `2` in \
`3`."\)], "Message",
  CellLabel->"From In[19]:=",
  CellTags->"NDSolve::mtdp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NDSolve::mtdp"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 975}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{688, 579},
WindowMargins->{{33, Automatic}, {Automatic, 14}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "NDSolve::ndtol"->{
    Cell[1825, 57, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndtol"],
    Cell[1909, 60, 242, 5, 37, "Message",
      CellTags->"NDSolve::ndtol"],
    Cell[2154, 67, 241, 5, 40, "Notes",
      CellTags->"NDSolve::ndtol"],
    Cell[2420, 76, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::ndtol"],
    Cell[2487, 79, 204, 5, 40, "Text",
      CellTags->"NDSolve::ndtol"],
    Cell[2716, 88, 231, 5, 42, "Input",
      CellTags->"NDSolve::ndtol"],
    Cell[2950, 95, 251, 5, 37, "Message",
      CellTags->"NDSolve::ndtol"],
    Cell[3204, 102, 278, 8, 21, "Output",
      CellTags->"NDSolve::ndtol"],
    Cell[3497, 113, 238, 6, 40, "Text",
      CellTags->"NDSolve::ndtol"],
    Cell[3760, 123, 260, 5, 42, "Input",
      CellTags->"NDSolve::ndtol"],
    Cell[4023, 130, 280, 8, 37, "Output",
      CellTags->"NDSolve::ndtol"]},
  "NDSolve::ivone"->{
    Cell[4364, 145, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ivone"],
    Cell[4448, 148, 293, 6, 53, "Message",
      CellTags->"NDSolve::ivone"],
    Cell[4744, 156, 390, 8, 62, "Notes",
      CellTags->"NDSolve::ivone"],
    Cell[5159, 168, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::ivone"],
    Cell[5226, 171, 177, 4, 24, "Text",
      CellTags->"NDSolve::ivone"],
    Cell[5428, 179, 295, 6, 58, "Input",
      CellTags->"NDSolve::ivone"],
    Cell[5726, 187, 292, 6, 53, "Message",
      CellTags->"NDSolve::ivone"],
    Cell[6033, 196, 167, 4, 24, "Text",
      CellTags->"NDSolve::ivone"],
    Cell[6225, 204, 249, 5, 42, "Input",
      CellTags->"NDSolve::ivone"],
    Cell[6477, 211, 292, 6, 53, "Message",
      CellTags->"NDSolve::ivone"],
    Cell[6772, 219, 756, 21, 23, "Output",
      CellTags->"NDSolve::ivone"]},
  "NDSolve::bcnorm"->{
    Cell[7589, 247, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bcnorm"],
    Cell[7675, 250, 196, 5, 21, "Message",
      CellTags->"NDSolve::bcnorm"],
    Cell[7874, 257, 362, 8, 78, "Notes",
      CellTags->"NDSolve::bcnorm"],
    Cell[8261, 269, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bcnorm"],
    Cell[8329, 272, 226, 5, 40, "Text",
      CellTags->"NDSolve::bcnorm"],
    Cell[8580, 281, 543, 11, 74, "Input",
      CellTags->"NDSolve::bcnorm"],
    Cell[9126, 294, 413, 7, 54, "Message",
      CellTags->"NDSolve::bcnorm"],
    Cell[9542, 303, 1611, 39, 88, "Output",
      CellTags->"NDSolve::bcnorm"]},
  "NDSolve::ndlim"->{
    Cell[11214, 349, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndlim"],
    Cell[11298, 352, 362, 9, 37, "Message",
      CellTags->"NDSolve::ndlim"],
    Cell[11663, 363, 438, 9, 62, "Notes",
      CellTags->"NDSolve::ndlim"]},
  "NDSolve::ndcf"->{
    Cell[12138, 377, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndcf"],
    Cell[12220, 380, 440, 12, 21, "Message",
      CellTags->"NDSolve::ndcf"],
    Cell[12663, 394, 428, 8, 78, "Notes",
      CellTags->"NDSolve::ndcf"]},
  "DSolve::conarg"->{
    Cell[13128, 407, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[13290, 414, 344, 9, 21, "Message",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[13637, 425, 442, 8, 78, "Notes",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14104, 437, 103, 1, 38, "ExampleSection",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14210, 440, 260, 5, 40, "Text",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14495, 449, 258, 4, 42, "Input",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14756, 455, 221, 4, 21, "Message",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14980, 461, 853, 21, 39, "Output",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[15848, 485, 167, 4, 24, "Text",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[16040, 493, 258, 4, 42, "Input",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[16301, 499, 329, 8, 21, "Output",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}]},
  "NDSolve::conarg"->{
    Cell[13128, 407, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[13290, 414, 344, 9, 21, "Message",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[13637, 425, 442, 8, 78, "Notes",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14104, 437, 103, 1, 38, "ExampleSection",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14210, 440, 260, 5, 40, "Text",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14495, 449, 258, 4, 42, "Input",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14756, 455, 221, 4, 21, "Message",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14980, 461, 853, 21, 39, "Output",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[15848, 485, 167, 4, 24, "Text",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[16040, 493, 258, 4, 42, "Input",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[16301, 499, 329, 8, 21, "Output",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}]},
  "RSolve::conarg"->{
    Cell[13128, 407, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[13290, 414, 344, 9, 21, "Message",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[13637, 425, 442, 8, 78, "Notes",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14104, 437, 103, 1, 38, "ExampleSection",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14210, 440, 260, 5, 40, "Text",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14495, 449, 258, 4, 42, "Input",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14756, 455, 221, 4, 21, "Message",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[14980, 461, 853, 21, 39, "Output",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[15848, 485, 167, 4, 24, "Text",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[16040, 493, 258, 4, 42, "Input",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
    Cell[16301, 499, 329, 8, 21, "Output",
      CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}]},
  "NDSolve::ndnco"->{
    Cell[16691, 514, 150, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[16844, 520, 685, 17, 37, "Message",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[17532, 539, 274, 5, 40, "Notes",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[17831, 548, 97, 1, 38, "ExampleSection",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[17931, 551, 200, 4, 24, "Text",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[18156, 559, 178, 3, 26, "Input",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[18337, 564, 297, 5, 53, "Message",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[18637, 571, 479, 12, 21, "Output",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[19131, 586, 174, 4, 24, "Text",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[19330, 594, 201, 4, 26, "Input",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[19534, 600, 311, 8, 21, "Output",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}]},
  "NDSolve`Reinitialize::ndnco"->{
    Cell[16691, 514, 150, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[16844, 520, 685, 17, 37, "Message",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[17532, 539, 274, 5, 40, "Notes",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[17831, 548, 97, 1, 38, "ExampleSection",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[17931, 551, 200, 4, 24, "Text",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[18156, 559, 178, 3, 26, "Input",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[18337, 564, 297, 5, 53, "Message",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[18637, 571, 479, 12, 21, "Output",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[19131, 586, 174, 4, 24, "Text",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[19330, 594, 201, 4, 26, "Input",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
    Cell[19534, 600, 311, 8, 21, "Output",
      CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}]},
  "NDSolve::ntcs"->{
    Cell[19906, 615, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ntcs"],
    Cell[19988, 618, 177, 3, 21, "Message",
      CellTags->"NDSolve::ntcs"],
    Cell[20168, 623, 463, 9, 62, "Notes",
      CellTags->"NDSolve::ntcs"],
    Cell[20656, 636, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::ntcs"],
    Cell[20722, 639, 135, 4, 24, "Text",
      CellTags->"NDSolve::ntcs"],
    Cell[20882, 647, 185, 4, 42, "Input",
      CellTags->"NDSolve::ntcs"],
    Cell[21070, 653, 193, 5, 21, "Message",
      CellTags->"NDSolve::ntcs"],
    Cell[21266, 660, 681, 18, 21, "Output",
      CellTags->"NDSolve::ntcs"],
    Cell[21962, 681, 142, 4, 24, "Text",
      CellTags->"NDSolve::ntcs"],
    Cell[22129, 689, 185, 4, 42, "Input",
      CellTags->"NDSolve::ntcs"],
    Cell[22317, 695, 466, 13, 37, "Output",
      CellTags->"NDSolve::ntcs"]},
  "NDSolve::bcart"->{
    Cell[22844, 715, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bcart"],
    Cell[22928, 718, 322, 6, 69, "Message",
      CellTags->"NDSolve::bcart"],
    Cell[23253, 726, 206, 5, 40, "Notes",
      CellTags->"NDSolve::bcart"],
    Cell[23484, 735, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bcart"],
    Cell[23551, 738, 159, 4, 24, "Text",
      CellTags->"NDSolve::bcart"],
    Cell[23735, 746, 209, 4, 42, "Input",
      CellTags->"NDSolve::bcart"],
    Cell[23947, 752, 325, 6, 69, "Message",
      CellTags->"NDSolve::bcart"],
    Cell[24275, 760, 290, 8, 21, "Output",
      CellTags->"NDSolve::bcart"],
    Cell[24580, 771, 120, 4, 24, "Text",
      CellTags->"NDSolve::bcart"],
    Cell[24725, 779, 230, 5, 42, "Input",
      CellTags->"NDSolve::bcart"],
    Cell[24958, 786, 290, 8, 21, "Output",
      CellTags->"NDSolve::bcart"]},
  "NDSolve::ndsv"->{
    Cell[25309, 801, 146, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::ndsv", "NDSolve`Reinitialize::ndsv"}],
    Cell[25458, 807, 433, 12, 21, "Message",
      CellTags->{"NDSolve::ndsv", "NDSolve`Reinitialize::ndsv"}],
    Cell[25894, 821, 386, 7, 62, "Notes",
      CellTags->{"NDSolve::ndsv", "NDSolve`Reinitialize::ndsv"}]},
  "NDSolve`Reinitialize::ndsv"->{
    Cell[25309, 801, 146, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::ndsv", "NDSolve`Reinitialize::ndsv"}],
    Cell[25458, 807, 433, 12, 21, "Message",
      CellTags->{"NDSolve::ndsv", "NDSolve`Reinitialize::ndsv"}],
    Cell[25894, 821, 386, 7, 62, "Notes",
      CellTags->{"NDSolve::ndsv", "NDSolve`Reinitialize::ndsv"}]},
  "NDSolve::nderr"->{
    Cell[26317, 833, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::nderr"],
    Cell[26401, 836, 432, 12, 21, "Message",
      CellTags->"NDSolve::nderr"],
    Cell[26836, 850, 461, 10, 100, "Notes",
      CellTags->"NDSolve::nderr"]},
  "NDSolve::ndnl"->{
    Cell[27334, 865, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndnl"],
    Cell[27416, 868, 352, 11, 21, "Message",
      CellTags->"NDSolve::ndnl"],
    Cell[27771, 881, 166, 4, 24, "Notes",
      CellTags->"NDSolve::ndnl"],
    Cell[27962, 889, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::ndnl"],
    Cell[28028, 892, 153, 4, 24, "Text",
      CellTags->"NDSolve::ndnl"],
    Cell[28206, 900, 141, 3, 26, "Input",
      CellTags->"NDSolve::ndnl"],
    Cell[28350, 905, 196, 5, 21, "Message",
      CellTags->"NDSolve::ndnl"],
    Cell[28549, 912, 439, 12, 21, "Output",
      CellTags->"NDSolve::ndnl"],
    Cell[29003, 927, 120, 4, 24, "Text",
      CellTags->"NDSolve::ndnl"],
    Cell[29148, 935, 173, 4, 42, "Input",
      CellTags->"NDSolve::ndnl"],
    Cell[29324, 941, 277, 8, 21, "Output",
      CellTags->"NDSolve::ndnl"]},
  "NDSolve::stopt"->{
    Cell[29662, 956, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::stopt"],
    Cell[29746, 959, 553, 14, 37, "Message",
      CellTags->"NDSolve::stopt"],
    Cell[30302, 975, 573, 16, 78, "Notes",
      CellTags->"NDSolve::stopt"],
    Cell[30900, 995, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::stopt"],
    Cell[30967, 998, 180, 5, 24, "Text",
      CellTags->"NDSolve::stopt"],
    Cell[31172, 1007, 221, 5, 42, "Input",
      CellTags->"NDSolve::stopt"],
    Cell[31396, 1014, 279, 6, 53, "Message",
      CellTags->"NDSolve::stopt"],
    Cell[31678, 1022, 320, 10, 21, "Output",
      CellTags->"NDSolve::stopt"],
    Cell[32013, 1035, 143, 5, 24, "Text",
      CellTags->"NDSolve::stopt"],
    Cell[32181, 1044, 204, 4, 42, "Input",
      CellTags->"NDSolve::stopt"],
    Cell[32388, 1050, 317, 10, 21, "Output",
      CellTags->"NDSolve::stopt"]},
  "NDSolve::ibcinc"->{
    Cell[32766, 1067, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ibcinc"],
    Cell[32852, 1070, 193, 4, 21, "Message",
      CellTags->"NDSolve::ibcinc"],
    Cell[33048, 1076, 732, 13, 132, "Notes",
      CellTags->"NDSolve::ibcinc"],
    Cell[33805, 1093, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::ibcinc"],
    Cell[33873, 1096, 346, 7, 56, "Text",
      CellTags->"NDSolve::ibcinc"],
    Cell[34244, 1107, 270, 5, 58, "Input",
      CellTags->"NDSolve::ibcinc"],
    Cell[34517, 1114, 198, 5, 37, "Message",
      CellTags->"NDSolve::ibcinc"],
    Cell[34718, 1121, 292, 8, 21, "Output",
      CellTags->"NDSolve::ibcinc"],
    Cell[35025, 1132, 221, 5, 40, "Text",
      CellTags->"NDSolve::ibcinc"],
    Cell[35271, 1141, 314, 7, 74, "Input",
      CellTags->"NDSolve::ibcinc"],
    Cell[35588, 1150, 292, 8, 21, "Output",
      CellTags->"NDSolve::ibcinc"],
    Cell[35895, 1161, 81, 1, 24, "Text",
      CellTags->"NDSolve::ibcinc"],
    Cell[36001, 1166, 160, 4, 26, "Input",
      CellTags->"NDSolve::ibcinc"],
    Cell[36164, 1172, 192, 5, 21, "Output",
      CellTags->"NDSolve::ibcinc"],
    Cell[36371, 1180, 114, 5, 24, "Text",
      CellTags->"NDSolve::ibcinc"],
    Cell[36488, 1187, 98, 3, 26, "Input",
      CellTags->"NDSolve::ibcinc"]},
  "NDSolve::pdnbc"->{
    Cell[36635, 1196, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::pdnbc"],
    Cell[36719, 1199, 207, 5, 37, "Message",
      CellTags->"NDSolve::pdnbc"],
    Cell[36929, 1206, 244, 5, 40, "Notes",
      CellTags->"NDSolve::pdnbc"],
    Cell[37198, 1215, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::pdnbc"],
    Cell[37265, 1218, 190, 5, 40, "Text",
      CellTags->"NDSolve::pdnbc"],
    Cell[37480, 1227, 324, 6, 58, "Input",
      CellTags->"NDSolve::pdnbc"],
    Cell[37807, 1235, 207, 5, 37, "Message",
      CellTags->"NDSolve::pdnbc"],
    Cell[38017, 1242, 1072, 28, 41, "Output",
      CellTags->"NDSolve::pdnbc"]},
  "NDSolve::eerr"->{
    Cell[39150, 1277, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::eerr"],
    Cell[39232, 1280, 1421, 30, 85, "Message",
      CellTags->"NDSolve::eerr"],
    Cell[40656, 1312, 513, 12, 78, "Notes",
      CellTags->"NDSolve::eerr"],
    Cell[41194, 1328, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::eerr"],
    Cell[41260, 1331, 221, 5, 40, "Text",
      CellTags->"NDSolve::eerr"],
    Cell[41506, 1340, 342, 7, 74, "Input",
      CellTags->"NDSolve::eerr"],
    Cell[41851, 1349, 562, 10, 117, "Message",
      CellTags->"NDSolve::eerr"],
    Cell[42416, 1361, 289, 8, 21, "Output",
      CellTags->"NDSolve::eerr"],
    Cell[42720, 1372, 199, 5, 24, "Text",
      CellTags->"NDSolve::eerr"],
    Cell[42944, 1381, 376, 8, 74, "Input",
      CellTags->"NDSolve::eerr"],
    Cell[43323, 1391, 289, 8, 21, "Output",
      CellTags->"NDSolve::eerr"]},
  "DSolve::ndord"->{
    Cell[43673, 1406, 184, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[43860, 1414, 595, 16, 37, "Message",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[44458, 1432, 219, 5, 24, "Notes",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[44702, 1441, 117, 2, 38, "ExampleSection",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[44822, 1445, 230, 6, 24, "Text",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[45077, 1455, 218, 5, 26, "Input",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[45298, 1462, 406, 7, 39, "Message",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[45707, 1471, 547, 15, 23, "Output",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[46269, 1489, 216, 6, 24, "Text",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[46510, 1499, 218, 5, 26, "Input",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[46731, 1506, 331, 9, 21, "Output",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}]},
  "NDSolve::ndord"->{
    Cell[43673, 1406, 184, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[43860, 1414, 595, 16, 37, "Message",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[44458, 1432, 219, 5, 24, "Notes",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[44702, 1441, 117, 2, 38, "ExampleSection",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[44822, 1445, 230, 6, 24, "Text",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[45077, 1455, 218, 5, 26, "Input",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[45298, 1462, 406, 7, 39, "Message",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[45707, 1471, 547, 15, 23, "Output",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[46269, 1489, 216, 6, 24, "Text",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[46510, 1499, 218, 5, 26, "Input",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[46731, 1506, 331, 9, 21, "Output",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}]},
  "NDSolve`Reinitialize::ndord"->{
    Cell[43673, 1406, 184, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[43860, 1414, 595, 16, 37, "Message",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[44458, 1432, 219, 5, 24, "Notes",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[44702, 1441, 117, 2, 38, "ExampleSection",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[44822, 1445, 230, 6, 24, "Text",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[45077, 1455, 218, 5, 26, "Input",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[45298, 1462, 406, 7, 39, "Message",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[45707, 1471, 547, 15, 23, "Output",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[46269, 1489, 216, 6, 24, "Text",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[46510, 1499, 218, 5, 26, "Input",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
    Cell[46731, 1506, 331, 9, 21, "Output",
      CellTags->{
      "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}]},
  "NDSolve::ndnum"->{
    Cell[47123, 1522, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndnum"],
    Cell[47207, 1525, 481, 14, 21, "Message",
      CellTags->"NDSolve::ndnum"],
    Cell[47691, 1541, 794, 14, 122, "Notes",
      CellTags->"NDSolve::ndnum"],
    Cell[48510, 1559, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::ndnum"],
    Cell[48577, 1562, 173, 4, 40, "Text",
      CellTags->"NDSolve::ndnum"],
    Cell[48775, 1570, 143, 3, 26, "Input",
      CellTags->"NDSolve::ndnum"],
    Cell[48921, 1575, 211, 5, 37, "Message",
      CellTags->"NDSolve::ndnum"],
    Cell[49135, 1582, 441, 12, 21, "Output",
      CellTags->"NDSolve::ndnum"],
    Cell[49591, 1597, 140, 4, 24, "Text",
      CellTags->"NDSolve::ndnum"],
    Cell[49756, 1605, 188, 5, 42, "Input",
      CellTags->"NDSolve::ndnum"],
    Cell[49947, 1612, 278, 8, 21, "Output",
      CellTags->"NDSolve::ndnum"],
    Cell[50240, 1623, 104, 1, 24, "Text",
      CellTags->"NDSolve::ndnum"],
    Cell[50369, 1628, 134, 3, 26, "Input",
      CellTags->"NDSolve::ndnum"],
    Cell[50506, 1633, 184, 5, 21, "Output",
      CellTags->"NDSolve::ndnum"],
    Cell[50705, 1641, 113, 5, 24, "Text",
      CellTags->"NDSolve::ndnum"],
    Cell[50821, 1648, 97, 3, 26, "Input",
      CellTags->"NDSolve::ndnum"],
    Cell[50921, 1653, 148, 4, 24, "Text",
      CellTags->"NDSolve::ndnum"],
    Cell[51094, 1661, 276, 6, 42, "Input",
      CellTags->"NDSolve::ndnum"],
    Cell[51373, 1669, 211, 5, 37, "Message",
      CellTags->"NDSolve::ndnum"],
    Cell[51587, 1676, 809, 21, 39, "Output",
      CellTags->"NDSolve::ndnum"],
    Cell[52411, 1700, 120, 4, 24, "Text",
      CellTags->"NDSolve::ndnum"],
    Cell[52556, 1708, 297, 7, 58, "Input",
      CellTags->"NDSolve::ndnum"],
    Cell[52856, 1717, 290, 8, 21, "Output",
      CellTags->"NDSolve::ndnum"],
    Cell[53161, 1728, 104, 1, 24, "Text",
      CellTags->"NDSolve::ndnum"],
    Cell[53290, 1733, 179, 4, 42, "Input",
      CellTags->"NDSolve::ndnum"],
    Cell[53472, 1739, 191, 5, 21, "Output",
      CellTags->"NDSolve::ndnum"],
    Cell[53678, 1747, 113, 5, 24, "Text",
      CellTags->"NDSolve::ndnum"],
    Cell[53794, 1754, 97, 3, 26, "Input",
      CellTags->"NDSolve::ndnum"]},
  "NDSolve::ndode"->{
    Cell[53940, 1763, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndode"],
    Cell[54024, 1766, 169, 3, 21, "Message",
      CellTags->"NDSolve::ndode"],
    Cell[54196, 1771, 475, 10, 78, "Notes",
      CellTags->"NDSolve::ndode"]},
  "NDSolve::bvals"->{
    Cell[54708, 1786, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bvals"],
    Cell[54792, 1789, 187, 3, 21, "Message",
      CellTags->"NDSolve::bvals"],
    Cell[54982, 1794, 331, 7, 62, "Notes",
      CellTags->"NDSolve::bvals"],
    Cell[55338, 1805, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bvals"],
    Cell[55405, 1808, 203, 5, 40, "Text",
      CellTags->"NDSolve::bvals"],
    Cell[55633, 1817, 170, 4, 26, "Input",
      CellTags->"NDSolve::bvals"],
    Cell[55806, 1823, 199, 5, 37, "Message",
      CellTags->"NDSolve::bvals"],
    Cell[56008, 1830, 518, 13, 21, "Output",
      CellTags->"NDSolve::bvals"],
    Cell[56541, 1846, 117, 4, 24, "Text",
      CellTags->"NDSolve::bvals"],
    Cell[56683, 1854, 167, 4, 26, "Input",
      CellTags->"NDSolve::bvals"],
    Cell[56853, 1860, 278, 8, 21, "Output",
      CellTags->"NDSolve::bvals"]},
  "NDSolve::ntdv"->{
    Cell[57192, 1875, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ntdv"],
    Cell[57274, 1878, 253, 5, 53, "Message",
      CellTags->"NDSolve::ntdv"],
    Cell[57530, 1885, 727, 17, 122, "Notes",
      CellTags->"NDSolve::ntdv"],
    Cell[58282, 1906, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::ntdv"],
    Cell[58348, 1909, 234, 7, 40, "Text",
      CellTags->"NDSolve::ntdv"],
    Cell[58607, 1920, 154, 4, 26, "Input",
      CellTags->"NDSolve::ntdv"],
    Cell[58764, 1926, 252, 5, 53, "Message",
      CellTags->"NDSolve::ntdv"],
    Cell[59019, 1933, 465, 13, 26, "Output",
      CellTags->"NDSolve::ntdv"],
    Cell[59499, 1949, 169, 4, 24, "Text",
      CellTags->"NDSolve::ntdv"],
    Cell[59693, 1957, 156, 4, 26, "Input",
      CellTags->"NDSolve::ntdv"],
    Cell[59852, 1963, 233, 5, 37, "Message",
      CellTags->"NDSolve::ntdv"],
    Cell[60088, 1970, 252, 5, 37, "Message",
      CellTags->"NDSolve::ntdv"],
    Cell[60343, 1977, 604, 16, 21, "Output",
      CellTags->"NDSolve::ntdv"],
    Cell[60962, 1996, 210, 6, 24, "Text",
      CellTags->"NDSolve::ntdv"],
    Cell[61197, 2006, 247, 6, 42, "Input",
      CellTags->"NDSolve::ntdv"],
    Cell[61447, 2014, 277, 8, 21, "Output",
      CellTags->"NDSolve::ntdv"]},
  "NDSolve::bcedge"->{
    Cell[61785, 2029, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bcedge"],
    Cell[61871, 2032, 465, 10, 37, "Message",
      CellTags->"NDSolve::bcedge"],
    Cell[62339, 2044, 267, 5, 40, "Notes",
      CellTags->"NDSolve::bcedge"],
    Cell[62631, 2053, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bcedge"],
    Cell[62699, 2056, 177, 4, 24, "Text",
      CellTags->"NDSolve::bcedge"],
    Cell[62901, 2064, 260, 5, 42, "Input",
      CellTags->"NDSolve::bcedge"],
    Cell[63164, 2071, 280, 6, 37, "Message",
      CellTags->"NDSolve::bcedge"],
    Cell[63447, 2079, 800, 21, 39, "Output",
      CellTags->"NDSolve::bcedge"],
    Cell[64262, 2103, 142, 4, 24, "Text",
      CellTags->"NDSolve::bcedge"],
    Cell[64429, 2111, 260, 5, 42, "Input",
      CellTags->"NDSolve::bcedge"],
    Cell[64692, 2118, 291, 8, 21, "Output",
      CellTags->"NDSolve::bcedge"],
    Cell[64998, 2129, 169, 5, 24, "Text",
      CellTags->"NDSolve::bcedge"],
    Cell[65192, 2138, 388, 8, 58, "Input",
      CellTags->"NDSolve::bcedge"],
    Cell[65583, 2148, 280, 6, 37, "Message",
      CellTags->"NDSolve::bcedge"],
    Cell[65878, 2157, 252, 6, 40, "Text",
      CellTags->"NDSolve::bcedge"],
    Cell[66133, 2165, 374, 8, 58, "Input",
      CellTags->"NDSolve::bcedge"],
    Cell[66510, 2175, 191, 5, 40, "Text",
      CellTags->"NDSolve::bcedge"],
    Cell[66726, 2184, 158, 4, 26, "Input",
      CellTags->"NDSolve::bcedge"],
    Cell[66887, 2190, 192, 5, 21, "Output",
      CellTags->"NDSolve::bcedge"]},
  "NDSolve::ndsss"->{
    Cell[67140, 2202, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndsss"],
    Cell[67224, 2205, 296, 6, 37, "Message",
      CellTags->"NDSolve::ndsss"],
    Cell[67523, 2213, 200, 5, 24, "Notes",
      CellTags->"NDSolve::ndsss"],
    Cell[67748, 2222, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::ndsss"],
    Cell[67815, 2225, 150, 5, 24, "Text",
      CellTags->"NDSolve::ndsss"],
    Cell[67990, 2234, 170, 4, 26, "Input",
      CellTags->"NDSolve::ndsss"],
    Cell[68163, 2240, 225, 5, 37, "Message",
      CellTags->"NDSolve::ndsss"],
    Cell[68391, 2247, 482, 13, 21, "Output",
      CellTags->"NDSolve::ndsss"],
    Cell[68888, 2263, 147, 5, 24, "Text",
      CellTags->"NDSolve::ndsss"],
    Cell[69060, 2272, 172, 4, 26, "Input",
      CellTags->"NDSolve::ndsss"],
    Cell[69235, 2278, 278, 8, 21, "Output",
      CellTags->"NDSolve::ndsss"]},
  "NDSolve::mxst"->{
    Cell[69574, 2293, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::mxst"],
    Cell[69656, 2296, 469, 14, 21, "Message",
      CellTags->"NDSolve::mxst"],
    Cell[70128, 2312, 774, 16, 116, "Notes",
      CellTags->"NDSolve::mxst"],
    Cell[70927, 2332, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::mxst"],
    Cell[70993, 2335, 161, 4, 24, "Text",
      CellTags->"NDSolve::mxst"],
    Cell[71179, 2343, 189, 4, 42, "Input",
      CellTags->"NDSolve::mxst"],
    Cell[71371, 2349, 227, 5, 37, "Message",
      CellTags->"NDSolve::mxst"],
    Cell[71601, 2356, 316, 10, 21, "Output",
      CellTags->"NDSolve::mxst"],
    Cell[71932, 2369, 105, 1, 24, "Text",
      CellTags->"NDSolve::mxst"],
    Cell[72062, 2374, 204, 5, 42, "Input",
      CellTags->"NDSolve::mxst"],
    Cell[72269, 2381, 278, 8, 21, "Output",
      CellTags->"NDSolve::mxst"],
    Cell[72562, 2392, 129, 4, 24, "Text",
      CellTags->"NDSolve::mxst"],
    Cell[72716, 2400, 125, 3, 26, "Input",
      CellTags->"NDSolve::mxst"],
    Cell[72844, 2405, 183, 5, 21, "Output",
      CellTags->"NDSolve::mxst"],
    Cell[73042, 2413, 228, 5, 40, "Text",
      CellTags->"NDSolve::mxst"],
    Cell[73295, 2422, 223, 5, 42, "Input",
      CellTags->"NDSolve::mxst"],
    Cell[73521, 2429, 278, 8, 21, "Output",
      CellTags->"NDSolve::mxst"],
    Cell[73814, 2440, 125, 4, 24, "Text",
      CellTags->"NDSolve::mxst"],
    Cell[73964, 2448, 125, 3, 26, "Input",
      CellTags->"NDSolve::mxst"],
    Cell[74092, 2453, 183, 5, 21, "Output",
      CellTags->"NDSolve::mxst"],
    Cell[74290, 2461, 112, 5, 24, "Text",
      CellTags->"NDSolve::mxst"],
    Cell[74405, 2468, 96, 3, 26, "Input",
      CellTags->"NDSolve::mxst"]},
  "NDSolve::bcnan"->{
    Cell[74550, 2477, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bcnan"],
    Cell[74634, 2480, 206, 5, 21, "Message",
      CellTags->"NDSolve::bcnan"],
    Cell[74843, 2487, 172, 4, 24, "Notes",
      CellTags->"NDSolve::bcnan"],
    Cell[75040, 2495, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bcnan"],
    Cell[75107, 2498, 183, 4, 40, "Text",
      CellTags->"NDSolve::bcnan"],
    Cell[75315, 2506, 167, 4, 26, "Input",
      CellTags->"NDSolve::bcnan"],
    Cell[75485, 2512, 170, 4, 21, "Message",
      CellTags->"NDSolve::bcnan"],
    Cell[75658, 2518, 515, 13, 21, "Output",
      CellTags->"NDSolve::bcnan"],
    Cell[76188, 2534, 117, 4, 24, "Text",
      CellTags->"NDSolve::bcnan"],
    Cell[76330, 2542, 167, 4, 26, "Input",
      CellTags->"NDSolve::bcnan"],
    Cell[76500, 2548, 278, 8, 21, "Output",
      CellTags->"NDSolve::bcnan"],
    Cell[76793, 2559, 174, 4, 40, "Text",
      CellTags->"NDSolve::bcnan"],
    Cell[76992, 2567, 170, 4, 26, "Input",
      CellTags->"NDSolve::bcnan"],
    Cell[77165, 2573, 170, 4, 21, "Message",
      CellTags->"NDSolve::bcnan"],
    Cell[77338, 2579, 518, 13, 21, "Output",
      CellTags->"NDSolve::bcnan"],
    Cell[77871, 2595, 133, 4, 24, "Text",
      CellTags->"NDSolve::bcnan"],
    Cell[78029, 2603, 195, 5, 42, "Input",
      CellTags->"NDSolve::bcnan"],
    Cell[78227, 2610, 278, 8, 21, "Output",
      CellTags->"NDSolve::bcnan"]},
  "NDSolve::bcsol"->{
    Cell[78566, 2625, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bcsol"],
    Cell[78650, 2628, 217, 5, 37, "Message",
      CellTags->"NDSolve::bcsol"],
    Cell[78870, 2635, 226, 5, 40, "Notes",
      CellTags->"NDSolve::bcsol"]},
  "NDSolve::depvr"->{
    Cell[79133, 2645, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::depvr"],
    Cell[79217, 2648, 179, 3, 21, "Message",
      CellTags->"NDSolve::depvr"],
    Cell[79399, 2653, 325, 7, 62, "Notes",
      CellTags->"NDSolve::depvr"]},
  "NDSolve::bddo"->{
    Cell[79761, 2665, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bddo"],
    Cell[79843, 2668, 225, 5, 37, "Message",
      CellTags->"NDSolve::bddo"],
    Cell[80071, 2675, 455, 13, 62, "Notes",
      CellTags->"NDSolve::bddo"],
    Cell[80551, 2692, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bddo"],
    Cell[80617, 2695, 214, 7, 24, "Text",
      CellTags->"NDSolve::bddo"],
    Cell[80856, 2706, 424, 8, 74, "Input",
      CellTags->"NDSolve::bddo"],
    Cell[81283, 2716, 231, 5, 37, "Message",
      CellTags->"NDSolve::bddo"],
    Cell[81517, 2723, 980, 24, 71, "Output",
      CellTags->"NDSolve::bddo"]},
  "NDSolve::mxsst"->{
    Cell[82558, 2754, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::mxsst"],
    Cell[82642, 2757, 256, 5, 53, "Message",
      CellTags->"NDSolve::mxsst"],
    Cell[82901, 2764, 571, 12, 78, "Notes",
      CellTags->"NDSolve::mxsst"],
    Cell[83497, 2780, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::mxsst"],
    Cell[83564, 2783, 283, 7, 40, "Text",
      CellTags->"NDSolve::mxsst"],
    Cell[83872, 2794, 308, 6, 58, "Input",
      CellTags->"NDSolve::mxsst"],
    Cell[84183, 2802, 264, 5, 53, "Message",
      CellTags->"NDSolve::mxsst"],
    Cell[84450, 2809, 339, 10, 21, "Output",
      CellTags->"NDSolve::mxsst"],
    Cell[84804, 2822, 181, 6, 24, "Text",
      CellTags->"NDSolve::mxsst"],
    Cell[85010, 2832, 271, 6, 42, "Input",
      CellTags->"NDSolve::mxsst"],
    Cell[85284, 2840, 339, 10, 21, "Output",
      CellTags->"NDSolve::mxsst"],
    Cell[85638, 2853, 283, 7, 40, "Text",
      CellTags->"NDSolve::mxsst"],
    Cell[85946, 2864, 402, 7, 74, "Input",
      CellTags->"NDSolve::mxsst"],
    Cell[86351, 2873, 264, 5, 53, "Message",
      CellTags->"NDSolve::mxsst"],
    Cell[86618, 2880, 339, 10, 21, "Output",
      CellTags->"NDSolve::mxsst"],
    Cell[86972, 2893, 181, 6, 24, "Text",
      CellTags->"NDSolve::mxsst"],
    Cell[87178, 2903, 378, 7, 74, "Input",
      CellTags->"NDSolve::mxsst"],
    Cell[87559, 2912, 339, 10, 21, "Output",
      CellTags->"NDSolve::mxsst"]},
  "NDSolve::ndmss"->{
    Cell[87959, 2929, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndmss"],
    Cell[88043, 2932, 478, 13, 21, "Message",
      CellTags->"NDSolve::ndmss"],
    Cell[88524, 2947, 196, 5, 24, "Notes",
      CellTags->"NDSolve::ndmss"],
    Cell[88745, 2956, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::ndmss"],
    Cell[88812, 2959, 181, 5, 24, "Text",
      CellTags->"NDSolve::ndmss"],
    Cell[89018, 2968, 166, 4, 26, "Input",
      CellTags->"NDSolve::ndmss"],
    Cell[89187, 2974, 227, 5, 37, "Message",
      CellTags->"NDSolve::ndmss"],
    Cell[89417, 2981, 478, 13, 21, "Output",
      CellTags->"NDSolve::ndmss"]},
  "NDSolve::bdmtd"->{
    Cell[89956, 3001, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bdmtd"],
    Cell[90040, 3004, 305, 6, 69, "Message",
      CellTags->"NDSolve::bdmtd"],
    Cell[90348, 3012, 125, 4, 24, "Notes",
      CellTags->"NDSolve::bdmtd"]},
  "NDSolve::ndsz"->{
    Cell[90510, 3021, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndsz"],
    Cell[90592, 3024, 438, 11, 37, "Message",
      CellTags->"NDSolve::ndsz"],
    Cell[91033, 3037, 244, 6, 40, "Notes",
      CellTags->"NDSolve::ndsz"],
    Cell[91302, 3047, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::ndsz"],
    Cell[91368, 3050, 120, 4, 24, "Text",
      CellTags->"NDSolve::ndsz"],
    Cell[91513, 3058, 161, 4, 26, "Input",
      CellTags->"NDSolve::ndsz"],
    Cell[91677, 3064, 246, 5, 37, "Message",
      CellTags->"NDSolve::ndsz"],
    Cell[91926, 3071, 319, 10, 21, "Output",
      CellTags->"NDSolve::ndsz"]},
  "NDSolve::pdord"->{
    Cell[92306, 3088, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::pdord"],
    Cell[92390, 3091, 270, 4, 53, "Message",
      CellTags->"NDSolve::pdord"],
    Cell[92663, 3097, 325, 8, 62, "Notes",
      CellTags->"NDSolve::pdord"],
    Cell[93013, 3109, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::pdord"],
    Cell[93080, 3112, 189, 6, 24, "Text",
      CellTags->"NDSolve::pdord"],
    Cell[93294, 3122, 218, 4, 26, "Input",
      CellTags->"NDSolve::pdord"],
    Cell[93515, 3128, 271, 6, 53, "Message",
      CellTags->"NDSolve::pdord"],
    Cell[93789, 3136, 467, 13, 37, "Output",
      CellTags->"NDSolve::pdord"]},
  "NDSolve::precw"->{
    Cell[94317, 3156, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::precw"],
    Cell[94401, 3159, 218, 4, 37, "Message",
      CellTags->"NDSolve::precw"],
    Cell[94622, 3165, 250, 6, 40, "Notes",
      CellTags->"NDSolve::precw"],
    Cell[94897, 3175, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::precw"],
    Cell[94964, 3178, 245, 6, 40, "Text",
      CellTags->"NDSolve::precw"],
    Cell[95234, 3188, 193, 4, 26, "Input",
      CellTags->"NDSolve::precw"],
    Cell[95430, 3194, 466, 8, 37, "Message",
      CellTags->"NDSolve::precw"],
    Cell[95899, 3204, 286, 8, 53, "Output",
      CellTags->"NDSolve::precw"],
    Cell[96200, 3215, 168, 4, 24, "Text",
      CellTags->"NDSolve::precw"],
    Cell[96393, 3223, 234, 5, 42, "Input",
      CellTags->"NDSolve::precw"],
    Cell[96630, 3230, 286, 8, 53, "Output",
      CellTags->"NDSolve::precw"]},
  "NDSolve::acoeffs"->{
    Cell[96977, 3245, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::acoeffs"],
    Cell[97065, 3248, 266, 5, 37, "Message",
      CellTags->"NDSolve::acoeffs"],
    Cell[97334, 3255, 127, 4, 24, "Notes",
      CellTags->"NDSolve::acoeffs"]},
  "NDSolve::sprkdm"->{
    Cell[97498, 3264, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::sprkdm"],
    Cell[97584, 3267, 208, 4, 37, "Message",
      CellTags->"NDSolve::sprkdm"],
    Cell[97795, 3273, 126, 4, 24, "Notes",
      CellTags->"NDSolve::sprkdm"]},
  "NDSolve::sprkqv"->{
    Cell[97958, 3282, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::sprkqv"],
    Cell[98044, 3285, 234, 4, 37, "Message",
      CellTags->"NDSolve::sprkqv"],
    Cell[98281, 3291, 126, 4, 24, "Notes",
      CellTags->"NDSolve::sprkqv"]},
  "NDSolve::sprkpqv"->{
    Cell[98444, 3300, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::sprkpqv"],
    Cell[98532, 3303, 287, 5, 37, "Message",
      CellTags->"NDSolve::sprkpqv"],
    Cell[98822, 3310, 127, 4, 24, "Notes",
      CellTags->"NDSolve::sprkpqv"]},
  "NDSolve::spltdep"->{
    Cell[98986, 3319, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::spltdep"],
    Cell[99074, 3322, 290, 5, 37, "Message",
      CellTags->"NDSolve::spltdep"],
    Cell[99367, 3329, 127, 4, 24, "Notes",
      CellTags->"NDSolve::spltdep"]},
  "NDSolve::spltdim"->{
    Cell[99531, 3338, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::spltdim"],
    Cell[99619, 3341, 266, 4, 37, "Message",
      CellTags->"NDSolve::spltdim"],
    Cell[99888, 3347, 127, 4, 24, "Notes",
      CellTags->"NDSolve::spltdim"]},
  "NDSolve::msols"->{
    Cell[100052, 3356, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::msols"],
    Cell[100136, 3359, 180, 3, 21, "Message",
      CellTags->"NDSolve::msols"],
    Cell[100319, 3364, 125, 4, 24, "Notes",
      CellTags->"NDSolve::msols"]},
  "NDSolve::ndsol"->{
    Cell[100481, 3373, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndsol"],
    Cell[100565, 3376, 173, 3, 21, "Message",
      CellTags->"NDSolve::ndsol"],
    Cell[100741, 3381, 125, 4, 24, "Notes",
      CellTags->"NDSolve::ndsol"]},
  "NDSolve::ndsnf"->{
    Cell[100903, 3390, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndsnf"],
    Cell[100987, 3393, 208, 4, 37, "Message",
      CellTags->"NDSolve::ndsnf"],
    Cell[101198, 3399, 125, 4, 24, "Notes",
      CellTags->"NDSolve::ndsnf"]},
  "NDSolve::ndspe"->{
    Cell[101360, 3408, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndspe"],
    Cell[101444, 3411, 179, 3, 21, "Message",
      CellTags->"NDSolve::ndspe"],
    Cell[101626, 3416, 125, 4, 24, "Notes",
      CellTags->"NDSolve::ndspe"]},
  "NDSolve::nlst"->{
    Cell[101788, 3425, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::nlst"],
    Cell[101870, 3428, 175, 3, 21, "Message",
      CellTags->"NDSolve::nlst"],
    Cell[102048, 3433, 124, 4, 24, "Notes",
      CellTags->"NDSolve::nlst"]},
  "NDSolve::nfun"->{
    Cell[102209, 3442, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::nfun"],
    Cell[102291, 3445, 162, 3, 21, "Message",
      CellTags->"NDSolve::nfun"],
    Cell[102456, 3450, 124, 4, 24, "Notes",
      CellTags->"NDSolve::nfun"]},
  "NDSolve::sfun"->{
    Cell[102617, 3459, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::sfun"],
    Cell[102699, 3462, 175, 3, 21, "Message",
      CellTags->"NDSolve::sfun"],
    Cell[102877, 3467, 124, 4, 24, "Notes",
      CellTags->"NDSolve::sfun"]},
  "NDSolve::csymb"->{
    Cell[103038, 3476, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::csymb"],
    Cell[103122, 3479, 190, 3, 21, "Message",
      CellTags->"NDSolve::csymb"],
    Cell[103315, 3484, 125, 4, 24, "Notes",
      CellTags->"NDSolve::csymb"]},
  "NDSolve::lsb"->{
    Cell[103477, 3493, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::lsb"],
    Cell[103557, 3496, 219, 6, 21, "Message",
      CellTags->"NDSolve::lsb"],
    Cell[103779, 3504, 123, 4, 24, "Notes",
      CellTags->"NDSolve::lsb"]},
  "NDSolve::bdord"->{
    Cell[103939, 3513, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bdord"],
    Cell[104023, 3516, 262, 4, 37, "Message",
      CellTags->"NDSolve::bdord"],
    Cell[104288, 3522, 256, 5, 40, "Notes",
      CellTags->"NDSolve::bdord"],
    Cell[104569, 3531, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bdord"],
    Cell[104636, 3534, 178, 4, 40, "Text",
      CellTags->"NDSolve::bdord"],
    Cell[104839, 3542, 303, 6, 58, "Input",
      CellTags->"NDSolve::bdord"],
    Cell[105145, 3550, 413, 7, 55, "Message",
      CellTags->"NDSolve::bdord"],
    Cell[105561, 3559, 1036, 28, 41, "Output",
      CellTags->"NDSolve::bdord"],
    Cell[106612, 3590, 141, 4, 24, "Text",
      CellTags->"NDSolve::bdord"],
    Cell[106778, 3598, 322, 7, 74, "Input",
      CellTags->"NDSolve::bdord"],
    Cell[107103, 3607, 336, 10, 21, "Output",
      CellTags->"NDSolve::bdord"],
    Cell[107454, 3620, 80, 1, 24, "Text",
      CellTags->"NDSolve::bdord"],
    Cell[107559, 3625, 163, 5, 26, "Input",
      CellTags->"NDSolve::bdord"],
    Cell[107725, 3632, 191, 5, 21, "Output",
      CellTags->"NDSolve::bdord"],
    Cell[107931, 3640, 113, 5, 24, "Text",
      CellTags->"NDSolve::bdord"],
    Cell[108047, 3647, 97, 3, 26, "Input",
      CellTags->"NDSolve::bdord"]},
  "NDSolve::nostep"->{
    Cell[108193, 3656, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::nostep"],
    Cell[108279, 3659, 333, 6, 53, "Message",
      CellTags->"NDSolve::nostep"],
    Cell[108615, 3667, 185, 6, 24, "Notes",
      CellTags->"NDSolve::nostep"]},
  "NDSolve::bdstep"->{
    Cell[108837, 3678, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bdstep"],
    Cell[108923, 3681, 222, 4, 37, "Message",
      CellTags->"NDSolve::bdstep"],
    Cell[109148, 3687, 219, 5, 24, "Notes",
      CellTags->"NDSolve::bdstep"],
    Cell[109392, 3696, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bdstep"],
    Cell[109460, 3699, 224, 7, 24, "Text",
      CellTags->"NDSolve::bdstep"],
    Cell[109709, 3710, 197, 4, 26, "Input",
      CellTags->"NDSolve::bdstep"],
    Cell[109909, 3716, 240, 5, 37, "Message",
      CellTags->"NDSolve::bdstep"],
    Cell[110152, 3723, 279, 8, 21, "Output",
      CellTags->"NDSolve::bdstep"],
    Cell[110446, 3734, 237, 6, 40, "Text",
      CellTags->"NDSolve::bdstep"],
    Cell[110686, 3742, 128, 3, 26, "Input",
      CellTags->"NDSolve::bdstep"],
    Cell[110839, 3749, 197, 4, 26, "Input",
      CellTags->"NDSolve::bdstep"],
    Cell[111039, 3755, 240, 5, 37, "Message",
      CellTags->"NDSolve::bdstep"],
    Cell[111282, 3762, 279, 8, 21, "Output",
      CellTags->"NDSolve::bdstep"]},
  "NDSolve::bvlin"->{
    Cell[111622, 3777, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bvlin"],
    Cell[111706, 3780, 341, 5, 53, "Message",
      CellTags->"NDSolve::bvlin"],
    Cell[112050, 3787, 160, 4, 24, "Notes",
      CellTags->"NDSolve::bvlin"],
    Cell[112235, 3795, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bvlin"],
    Cell[112302, 3798, 159, 4, 24, "Text",
      CellTags->"NDSolve::bvlin"],
    Cell[112486, 3806, 199, 4, 26, "Input",
      CellTags->"NDSolve::bvlin"],
    Cell[112688, 3812, 329, 6, 69, "Message",
      CellTags->"NDSolve::bvlin"],
    Cell[113020, 3820, 518, 13, 23, "Output",
      CellTags->"NDSolve::bvlin"]},
  "NDSolve::bvluc"->{
    Cell[113599, 3840, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bvluc"],
    Cell[113683, 3843, 415, 8, 69, "Message",
      CellTags->"NDSolve::bvluc"],
    Cell[114101, 3853, 164, 4, 24, "Notes",
      CellTags->"NDSolve::bvluc"],
    Cell[114290, 3861, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bvluc"],
    Cell[114357, 3864, 216, 5, 40, "Text",
      CellTags->"NDSolve::bvluc"],
    Cell[114598, 3873, 205, 4, 26, "Input",
      CellTags->"NDSolve::bvluc"],
    Cell[114806, 3879, 366, 7, 85, "Message",
      CellTags->"NDSolve::bvluc"],
    Cell[115175, 3888, 317, 10, 21, "Output",
      CellTags->"NDSolve::bvluc"]},
  "NDSolve::bvls"->{
    Cell[115553, 3905, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bvls"],
    Cell[115635, 3908, 302, 5, 37, "Message",
      CellTags->"NDSolve::bvls"],
    Cell[115940, 3915, 124, 4, 24, "Notes",
      CellTags->"NDSolve::bvls"]},
  "NDSolve::bvlind"->{
    Cell[116101, 3924, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bvlind"],
    Cell[116187, 3927, 172, 3, 21, "Message",
      CellTags->"NDSolve::bvlind"],
    Cell[116362, 3932, 126, 4, 24, "Notes",
      CellTags->"NDSolve::bvlind"]},
  "NDSolve::bvaux"->{
    Cell[116525, 3941, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bvaux"],
    Cell[116609, 3944, 186, 3, 21, "Message",
      CellTags->"NDSolve::bvaux"],
    Cell[116798, 3949, 466, 10, 90, "Notes",
      CellTags->"NDSolve::bvaux"],
    Cell[117289, 3963, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bvaux"],
    Cell[117356, 3966, 140, 4, 24, "Text",
      CellTags->"NDSolve::bvaux"],
    Cell[117521, 3974, 184, 5, 26, "Input",
      CellTags->"NDSolve::bvaux"],
    Cell[117708, 3981, 178, 4, 36, "Message",
      CellTags->"NDSolve::bvaux"],
    Cell[117889, 3987, 207, 5, 21, "Message",
      CellTags->"NDSolve::bvaux"],
    Cell[118099, 3994, 178, 4, 36, "Message",
      CellTags->"NDSolve::bvaux"],
    Cell[118280, 4000, 207, 5, 21, "Message",
      CellTags->"NDSolve::bvaux"],
    Cell[118490, 4007, 211, 5, 21, "Message",
      CellTags->"NDSolve::bvaux"],
    Cell[118704, 4014, 217, 5, 37, "Message",
      CellTags->"NDSolve::bvaux"],
    Cell[118924, 4021, 567, 15, 21, "Output",
      CellTags->"NDSolve::bvaux"]},
  "NDSolve::bvep"->{
    Cell[119552, 4043, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bvep"],
    Cell[119634, 4046, 435, 12, 21, "Message",
      CellTags->"NDSolve::bvep"],
    Cell[120072, 4060, 158, 4, 24, "Notes",
      CellTags->"NDSolve::bvep"],
    Cell[120255, 4068, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bvep"],
    Cell[120321, 4071, 213, 7, 24, "Text",
      CellTags->"NDSolve::bvep"],
    Cell[120559, 4082, 265, 5, 42, "Input",
      CellTags->"NDSolve::bvep"],
    Cell[120827, 4089, 225, 5, 37, "Message",
      CellTags->"NDSolve::bvep"],
    Cell[121055, 4096, 612, 16, 58, "Output",
      CellTags->"NDSolve::bvep"]},
  "NDSolve::bvcrat"->{
    Cell[121728, 4119, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bvcrat"],
    Cell[121814, 4122, 435, 12, 21, "Message",
      CellTags->"NDSolve::bvcrat"],
    Cell[122252, 4136, 160, 4, 24, "Notes",
      CellTags->"NDSolve::bvcrat"]},
  "NDSolve::bvdae"->{
    Cell[122449, 4145, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bvdae"],
    Cell[122533, 4148, 208, 4, 37, "Message",
      CellTags->"NDSolve::bvdae"],
    Cell[122744, 4154, 125, 4, 24, "Notes",
      CellTags->"NDSolve::bvdae"]},
  "NDSolve::cprec"->{
    Cell[122906, 4163, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::cprec"],
    Cell[122990, 4166, 241, 4, 37, "Message",
      CellTags->"NDSolve::cprec"],
    Cell[123234, 4172, 125, 4, 24, "Notes",
      CellTags->"NDSolve::cprec"]},
  "NDSolve::cconst"->{
    Cell[123396, 4181, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::cconst"],
    Cell[123482, 4184, 188, 3, 21, "Message",
      CellTags->"NDSolve::cconst"],
    Cell[123673, 4189, 126, 4, 24, "Notes",
      CellTags->"NDSolve::cconst"]},
  "NDSolve::cdims"->{
    Cell[123836, 4198, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::cdims"],
    Cell[123920, 4201, 218, 4, 37, "Message",
      CellTags->"NDSolve::cdims"],
    Cell[124141, 4207, 125, 4, 24, "Notes",
      CellTags->"NDSolve::cdims"]},
  "NDSolve::cstruct"->{
    Cell[124303, 4216, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::cstruct"],
    Cell[124391, 4219, 192, 3, 21, "Message",
      CellTags->"NDSolve::cstruct"],
    Cell[124586, 4224, 127, 4, 24, "Notes",
      CellTags->"NDSolve::cstruct"]},
  "NDSolve::submtd"->{
    Cell[124750, 4233, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::submtd"],
    Cell[124836, 4236, 300, 8, 21, "Message",
      CellTags->"NDSolve::submtd"],
    Cell[125139, 4246, 242, 7, 24, "Notes",
      CellTags->"NDSolve::submtd"],
    Cell[125406, 4257, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::submtd"],
    Cell[125474, 4260, 223, 7, 24, "Text",
      CellTags->"NDSolve::submtd"],
    Cell[125722, 4271, 267, 5, 42, "Input",
      CellTags->"NDSolve::submtd"],
    Cell[125992, 4278, 174, 4, 21, "Message",
      CellTags->"NDSolve::submtd"],
    Cell[126169, 4284, 203, 5, 21, "Message",
      CellTags->"NDSolve::submtd"],
    Cell[126375, 4291, 279, 8, 21, "Output",
      CellTags->"NDSolve::submtd"]},
  "NDSolve::uniss"->{
    Cell[126715, 4306, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::uniss"],
    Cell[126799, 4309, 353, 6, 53, "Message",
      CellTags->"NDSolve::uniss"],
    Cell[127155, 4317, 229, 5, 40, "Notes",
      CellTags->"NDSolve::uniss"],
    Cell[127409, 4326, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::uniss"],
    Cell[127476, 4329, 236, 6, 40, "Text",
      CellTags->"NDSolve::uniss"],
    Cell[127737, 4339, 451, 8, 90, "Input",
      CellTags->"NDSolve::uniss"],
    Cell[128191, 4349, 387, 7, 85, "Message",
      CellTags->"NDSolve::uniss"],
    Cell[128581, 4358, 339, 10, 21, "Output",
      CellTags->"NDSolve::uniss"]},
  "NDSolve::eerri"->{
    Cell[128981, 4375, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::eerri"],
    Cell[129065, 4378, 291, 5, 53, "Message",
      CellTags->"NDSolve::eerri"],
    Cell[129359, 4385, 192, 5, 24, "Notes",
      CellTags->"NDSolve::eerri"],
    Cell[129576, 4394, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::eerri"],
    Cell[129643, 4397, 236, 5, 40, "Text",
      CellTags->"NDSolve::eerri"],
    Cell[129904, 4406, 447, 8, 74, "Input",
      CellTags->"NDSolve::eerri"],
    Cell[130354, 4416, 287, 6, 69, "Message",
      CellTags->"NDSolve::eerri"],
    Cell[130644, 4424, 339, 10, 21, "Output",
      CellTags->"NDSolve::eerri"]},
  "NDSolve::vdobj"->{
    Cell[131044, 4441, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::vdobj"],
    Cell[131128, 4444, 176, 3, 21, "Message",
      CellTags->"NDSolve::vdobj"],
    Cell[131307, 4449, 150, 4, 24, "Notes",
      CellTags->"NDSolve::vdobj"],
    Cell[131482, 4457, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::vdobj"],
    Cell[131549, 4460, 178, 5, 24, "Text",
      CellTags->"NDSolve::vdobj"],
    Cell[131752, 4469, 133, 3, 26, "Input",
      CellTags->"NDSolve::vdobj"],
    Cell[131888, 4474, 303, 6, 37, "Message",
      CellTags->"NDSolve::vdobj"],
    Cell[132194, 4482, 211, 6, 21, "Output",
      CellTags->"NDSolve::vdobj"]},
  "NDSolve::ininv"->{
    Cell[132466, 4495, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ininv"],
    Cell[132550, 4498, 204, 4, 37, "Message",
      CellTags->"NDSolve::ininv"],
    Cell[132757, 4504, 125, 4, 24, "Notes",
      CellTags->"NDSolve::ininv"]},
  "NDSolve::impsol"->{
    Cell[132919, 4513, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::impsol"],
    Cell[133005, 4516, 207, 5, 37, "Message",
      CellTags->"NDSolve::impsol"],
    Cell[133215, 4523, 126, 4, 24, "Notes",
      CellTags->"NDSolve::impsol"]},
  "NDSolve::maxit"->{
    Cell[133378, 4532, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::maxit"],
    Cell[133462, 4535, 181, 3, 21, "Message",
      CellTags->"NDSolve::maxit"],
    Cell[133646, 4540, 125, 4, 24, "Notes",
      CellTags->"NDSolve::maxit"]},
  "NDSolve::mmpts"->{
    Cell[133808, 4549, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::mmpts"],
    Cell[133892, 4552, 341, 5, 69, "Message",
      CellTags->"NDSolve::mmpts"],
    Cell[134236, 4559, 135, 4, 24, "Notes",
      CellTags->"NDSolve::mmpts"],
    Cell[134396, 4567, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::mmpts"],
    Cell[134463, 4570, 331, 8, 40, "Text",
      CellTags->"NDSolve::mmpts"],
    Cell[134819, 4582, 358, 7, 58, "Input",
      CellTags->"NDSolve::mmpts"],
    Cell[135180, 4591, 362, 7, 69, "Message",
      CellTags->"NDSolve::mmpts"],
    Cell[135545, 4600, 931, 24, 55, "Output",
      CellTags->"NDSolve::mmpts"],
    Cell[136491, 4627, 185, 6, 24, "Text",
      CellTags->"NDSolve::mmpts"],
    Cell[136701, 4637, 314, 6, 58, "Input",
      CellTags->"NDSolve::mmpts"],
    Cell[137018, 4645, 339, 10, 21, "Output",
      CellTags->"NDSolve::mmpts"]},
  "NDSolve::dored"->{
    Cell[137418, 4662, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::dored"],
    Cell[137502, 4665, 384, 6, 69, "Message",
      CellTags->"NDSolve::dored"],
    Cell[137889, 4673, 125, 4, 24, "Notes",
      CellTags->"NDSolve::dored"]},
  "NDSolve::nerres"->{
    Cell[138051, 4682, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::nerres"],
    Cell[138137, 4685, 323, 5, 53, "Message",
      CellTags->"NDSolve::nerres"],
    Cell[138463, 4692, 153, 4, 24, "Notes",
      CellTags->"NDSolve::nerres"],
    Cell[138641, 4700, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::nerres"],
    Cell[138709, 4703, 261, 7, 40, "Text",
      CellTags->"NDSolve::nerres"],
    Cell[138995, 4714, 355, 7, 74, "Input",
      CellTags->"NDSolve::nerres"],
    Cell[139353, 4723, 333, 6, 69, "Message",
      CellTags->"NDSolve::nerres"],
    Cell[139689, 4731, 291, 8, 21, "Output",
      CellTags->"NDSolve::nerres"],
    Cell[139995, 4742, 186, 6, 24, "Text",
      CellTags->"NDSolve::nerres"],
    Cell[140206, 4752, 356, 7, 74, "Input",
      CellTags->"NDSolve::nerres"],
    Cell[140565, 4761, 291, 8, 21, "Output",
      CellTags->"NDSolve::nerres"]},
  "NDSolve::eveerr"->{
    Cell[140917, 4776, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::eveerr"],
    Cell[141003, 4779, 414, 6, 69, "Message",
      CellTags->"NDSolve::eveerr"],
    Cell[141420, 4787, 191, 5, 24, "Notes",
      CellTags->"NDSolve::eveerr"]},
  "NDSolve::stpmin"->{
    Cell[141648, 4797, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::stpmin"],
    Cell[141734, 4800, 341, 5, 69, "Message",
      CellTags->"NDSolve::stpmin"],
    Cell[142078, 4807, 172, 4, 24, "Notes",
      CellTags->"NDSolve::stpmin"],
    Cell[142275, 4815, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::stpmin"],
    Cell[142343, 4818, 204, 5, 40, "Text",
      CellTags->"NDSolve::stpmin"],
    Cell[142572, 4827, 466, 9, 74, "Input",
      CellTags->"NDSolve::stpmin"],
    Cell[143041, 4838, 357, 7, 69, "Message",
      CellTags->"NDSolve::stpmin"],
    Cell[143401, 4847, 340, 10, 21, "Output",
      CellTags->"NDSolve::stpmin"]},
  "NDSolve::stpmax"->{
    Cell[143802, 4864, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::stpmax"],
    Cell[143888, 4867, 344, 5, 69, "Message",
      CellTags->"NDSolve::stpmax"],
    Cell[144235, 4874, 172, 4, 24, "Notes",
      CellTags->"NDSolve::stpmax"],
    Cell[144432, 4882, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::stpmax"],
    Cell[144500, 4885, 204, 5, 40, "Text",
      CellTags->"NDSolve::stpmax"],
    Cell[144729, 4894, 470, 9, 90, "Input",
      CellTags->"NDSolve::stpmax"],
    Cell[145202, 4905, 368, 7, 69, "Message",
      CellTags->"NDSolve::stpmax"],
    Cell[145573, 4914, 340, 10, 21, "Output",
      CellTags->"NDSolve::stpmax"]},
  "NDSolve::stps"->{
    Cell[145974, 4931, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::stps"],
    Cell[146056, 4934, 308, 5, 53, "Message",
      CellTags->"NDSolve::stps"],
    Cell[146367, 4941, 376, 9, 46, "Notes",
      CellTags->"NDSolve::stps"],
    Cell[146768, 4954, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::stps"],
    Cell[146834, 4957, 261, 8, 40, "Text",
      CellTags->"NDSolve::stps"],
    Cell[147120, 4969, 470, 9, 90, "Input",
      CellTags->"NDSolve::stps"],
    Cell[147593, 4980, 310, 6, 69, "Message",
      CellTags->"NDSolve::stps"],
    Cell[147906, 4988, 338, 10, 21, "Output",
      CellTags->"NDSolve::stps"]},
  "NDSolve::maxits"->{
    Cell[148305, 5005, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::maxits"],
    Cell[148391, 5008, 249, 5, 53, "Message",
      CellTags->"NDSolve::maxits"],
    Cell[148643, 5015, 126, 4, 24, "Notes",
      CellTags->"NDSolve::maxits"]},
  "NDSolve::moptxn"->{
    Cell[148806, 5024, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::moptxn"],
    Cell[148892, 5027, 449, 12, 21, "Message",
      CellTags->"NDSolve::moptxn"],
    Cell[149344, 5041, 170, 4, 24, "Notes",
      CellTags->"NDSolve::moptxn"],
    Cell[149539, 5049, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::moptxn"],
    Cell[149607, 5052, 239, 7, 40, "Text",
      CellTags->"NDSolve::moptxn"],
    Cell[149871, 5063, 258, 5, 42, "Input",
      CellTags->"NDSolve::moptxn"],
    Cell[150132, 5070, 296, 6, 53, "Message",
      CellTags->"NDSolve::moptxn"],
    Cell[150431, 5078, 197, 5, 21, "Message",
      CellTags->"NDSolve::moptxn"],
    Cell[150631, 5085, 279, 8, 21, "Output",
      CellTags->"NDSolve::moptxn"],
    Cell[150925, 5096, 103, 1, 24, "Text",
      CellTags->"NDSolve::moptxn"],
    Cell[151053, 5101, 267, 5, 42, "Input",
      CellTags->"NDSolve::moptxn"],
    Cell[151323, 5108, 279, 8, 21, "Output",
      CellTags->"NDSolve::moptxn"],
    Cell[151617, 5119, 213, 7, 24, "Text",
      CellTags->"NDSolve::moptxn"],
    Cell[151855, 5130, 262, 5, 42, "Input",
      CellTags->"NDSolve::moptxn"],
    Cell[152120, 5137, 282, 6, 53, "Message",
      CellTags->"NDSolve::moptxn"],
    Cell[152405, 5145, 594, 15, 37, "Output",
      CellTags->"NDSolve::moptxn"]},
  "NDSolve::mrsti"->{
    Cell[153060, 5167, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::mrsti"],
    Cell[153144, 5170, 214, 5, 37, "Message",
      CellTags->"NDSolve::mrsti"],
    Cell[153361, 5177, 209, 5, 24, "Notes",
      CellTags->"NDSolve::mrsti"],
    Cell[153595, 5186, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::mrsti"],
    Cell[153662, 5189, 203, 6, 40, "Text",
      CellTags->"NDSolve::mrsti"],
    Cell[153890, 5199, 250, 5, 42, "Input",
      CellTags->"NDSolve::mrsti"],
    Cell[154143, 5206, 260, 5, 54, "Message",
      CellTags->"NDSolve::mrsti"],
    Cell[154406, 5213, 734, 19, 61, "Output",
      CellTags->"NDSolve::mrsti"]},
  "NDSolve::msti"->{
    Cell[155201, 5239, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::msti"],
    Cell[155283, 5242, 246, 4, 37, "Message",
      CellTags->"NDSolve::msti"],
    Cell[155532, 5248, 200, 5, 24, "Notes",
      CellTags->"NDSolve::msti"],
    Cell[155757, 5257, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::msti"],
    Cell[155823, 5260, 194, 6, 24, "Text",
      CellTags->"NDSolve::msti"],
    Cell[156042, 5270, 410, 8, 74, "Input",
      CellTags->"NDSolve::msti"],
    Cell[156455, 5280, 294, 6, 53, "Message",
      CellTags->"NDSolve::msti"],
    Cell[156752, 5288, 985, 24, 88, "Output",
      CellTags->"NDSolve::msti"]},
  "NDSolve::ncsm"->{
    Cell[157798, 5319, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ncsm"],
    Cell[157880, 5322, 231, 4, 37, "Message",
      CellTags->"NDSolve::ncsm"],
    Cell[158114, 5328, 124, 4, 24, "Notes",
      CellTags->"NDSolve::ncsm"]},
  "NDSolve::lsf"->{
    Cell[158275, 5337, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::lsf"],
    Cell[158355, 5340, 191, 3, 21, "Message",
      CellTags->"NDSolve::lsf"],
    Cell[158549, 5345, 347, 8, 46, "Notes",
      CellTags->"NDSolve::lsf"]},
  "NDSolve::ndinnt"->{
    Cell[158933, 5358, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndinnt"],
    Cell[159019, 5361, 204, 4, 37, "Message",
      CellTags->"NDSolve::ndinnt"],
    Cell[159226, 5367, 308, 6, 46, "Notes",
      CellTags->"NDSolve::ndinnt"],
    Cell[159559, 5377, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::ndinnt"],
    Cell[159627, 5380, 181, 7, 24, "Text",
      CellTags->"NDSolve::ndinnt"],
    Cell[159833, 5391, 161, 4, 26, "Input",
      CellTags->"NDSolve::ndinnt"],
    Cell[159997, 5397, 177, 4, 21, "Message",
      CellTags->"NDSolve::ndinnt"],
    Cell[160177, 5403, 226, 5, 37, "Message",
      CellTags->"NDSolve::ndinnt"],
    Cell[160406, 5410, 451, 12, 21, "Output",
      CellTags->"NDSolve::ndinnt"],
    Cell[160872, 5425, 163, 5, 24, "Text",
      CellTags->"NDSolve::ndinnt"],
    Cell[161060, 5434, 141, 3, 26, "Input",
      CellTags->"NDSolve::ndinnt"],
    Cell[161204, 5439, 279, 8, 21, "Output",
      CellTags->"NDSolve::ndinnt"]},
  "NDSolve::ndincd"->{
    Cell[161544, 5454, 154, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[161701, 5460, 341, 8, 37, "Message",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[162045, 5470, 189, 4, 24, "Notes",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[162259, 5478, 99, 1, 38, "ExampleSection",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[162361, 5481, 220, 5, 24, "Text",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[162606, 5490, 246, 5, 26, "Input",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[162855, 5497, 270, 5, 37, "Message",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[163128, 5504, 717, 18, 21, "Output",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}]},
  "NDSolve`Reinitialize::ndincd"->{
    Cell[161544, 5454, 154, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[161701, 5460, 341, 8, 37, "Message",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[162045, 5470, 189, 4, 24, "Notes",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[162259, 5478, 99, 1, 38, "ExampleSection",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[162361, 5481, 220, 5, 24, "Text",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[162606, 5490, 246, 5, 26, "Input",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[162855, 5497, 270, 5, 37, "Message",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
    Cell[163128, 5504, 717, 18, 21, "Output",
      CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}]},
  "NDSolve::ndincb"->{
    Cell[163906, 5529, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndincb"],
    Cell[163992, 5532, 180, 3, 21, "Message",
      CellTags->"NDSolve::ndincb"],
    Cell[164175, 5537, 126, 4, 24, "Notes",
      CellTags->"NDSolve::ndincb"]},
  "NDSolve::opdims"->{
    Cell[164338, 5546, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::opdims"],
    Cell[164424, 5549, 289, 5, 53, "Message",
      CellTags->"NDSolve::opdims"],
    Cell[164716, 5556, 126, 4, 24, "Notes",
      CellTags->"NDSolve::opdims"]},
  "NDSolve::opmdims"->{
    Cell[164879, 5565, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::opmdims"],
    Cell[164967, 5568, 253, 4, 37, "Message",
      CellTags->"NDSolve::opmdims"],
    Cell[165223, 5574, 127, 4, 24, "Notes",
      CellTags->"NDSolve::opmdims"]},
  "NDSolve`Reinitialize::ndincb"->{
    Cell[165387, 5583, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`Reinitialize::ndincb"],
    Cell[165499, 5586, 240, 4, 37, "Message",
      CellTags->"NDSolve`Reinitialize::ndincb"],
    Cell[165742, 5592, 177, 4, 24, "Notes",
      CellTags->"NDSolve`Reinitialize::ndincb"],
    Cell[165944, 5600, 78, 1, 38, "ExampleSection",
      CellTags->"NDSolve`Reinitialize::ndincb"],
    Cell[166025, 5603, 200, 6, 24, "Text",
      CellTags->"NDSolve`Reinitialize::ndincb"],
    Cell[166250, 5613, 270, 6, 42, "Input",
      CellTags->"NDSolve`Reinitialize::ndincb"],
    Cell[166523, 5621, 332, 9, 21, "Output",
      CellTags->"NDSolve`Reinitialize::ndincb"],
    Cell[166892, 5635, 190, 5, 26, "Input",
      CellTags->"NDSolve`Reinitialize::ndincb"],
    Cell[167085, 5642, 247, 5, 37, "Message",
      CellTags->"NDSolve`Reinitialize::ndincb"],
    Cell[167335, 5649, 723, 20, 21, "Output",
      CellTags->"NDSolve`Reinitialize::ndincb"]},
  "NDSolve::ndncov"->{
    Cell[168119, 5676, 154, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::ndncov", "NDSolve`Reinitialize::ndncov"}],
    Cell[168276, 5682, 372, 8, 37, "Message",
      CellTags->{"NDSolve::ndncov", "NDSolve`Reinitialize::ndncov"}],
    Cell[168651, 5692, 205, 4, 24, "Notes",
      CellTags->{"NDSolve::ndncov", "NDSolve`Reinitialize::ndncov"}]},
  "NDSolve`Reinitialize::ndncov"->{
    Cell[168119, 5676, 154, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::ndncov", "NDSolve`Reinitialize::ndncov"}],
    Cell[168276, 5682, 372, 8, 37, "Message",
      CellTags->{"NDSolve::ndncov", "NDSolve`Reinitialize::ndncov"}],
    Cell[168651, 5692, 205, 4, 24, "Notes",
      CellTags->{"NDSolve::ndncov", "NDSolve`Reinitialize::ndncov"}]},
  "NDSolve::ndfdmc"->{
    Cell[168893, 5701, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndfdmc"],
    Cell[168979, 5704, 217, 4, 37, "Message",
      CellTags->"NDSolve::ndfdmc"],
    Cell[169199, 5710, 242, 5, 40, "Notes",
      CellTags->"NDSolve::ndfdmc"],
    Cell[169466, 5719, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::ndfdmc"],
    Cell[169534, 5722, 225, 5, 40, "Text",
      CellTags->"NDSolve::ndfdmc"],
    Cell[169784, 5731, 221, 5, 42, "Input",
      CellTags->"NDSolve::ndfdmc"],
    Cell[170008, 5738, 227, 5, 37, "Message",
      CellTags->"NDSolve::ndfdmc"],
    Cell[170238, 5745, 692, 18, 21, "Output",
      CellTags->"NDSolve::ndfdmc"]},
  "NDSolve::ndrsd"->{
    Cell[170991, 5770, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndrsd"],
    Cell[171075, 5773, 194, 3, 21, "Message",
      CellTags->"NDSolve::ndrsd"],
    Cell[171272, 5778, 125, 4, 24, "Notes",
      CellTags->"NDSolve::ndrsd"]},
  "NDSolve::ndsnorm"->{
    Cell[171434, 5787, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndsnorm"],
    Cell[171522, 5790, 236, 4, 37, "Message",
      CellTags->"NDSolve::ndsnorm"],
    Cell[171761, 5796, 199, 5, 24, "Notes",
      CellTags->"NDSolve::ndsnorm"]},
  "NDSolve::ndsnr"->{
    Cell[171997, 5806, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndsnr"],
    Cell[172081, 5809, 174, 4, 21, "Message",
      CellTags->"NDSolve::ndsnr"],
    Cell[172258, 5815, 125, 4, 24, "Notes",
      CellTags->"NDSolve::ndsnr"]},
  "NDSolve::ndssc"->{
    Cell[172420, 5824, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndssc"],
    Cell[172504, 5827, 162, 3, 21, "Message",
      CellTags->"NDSolve::ndssc"],
    Cell[172669, 5832, 125, 4, 24, "Notes",
      CellTags->"NDSolve::ndssc"]},
  "NDSolve::ndstf"->{
    Cell[172831, 5841, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndstf"],
    Cell[172915, 5844, 251, 5, 53, "Message",
      CellTags->"NDSolve::ndstf"],
    Cell[173169, 5851, 125, 4, 24, "Notes",
      CellTags->"NDSolve::ndstf"]},
  "NDSolve::ivcon"->{
    Cell[173331, 5860, 150, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[173484, 5866, 404, 9, 37, "Message",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[173891, 5877, 283, 5, 40, "Notes",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[174199, 5886, 97, 1, 38, "ExampleSection",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[174299, 5889, 191, 4, 24, "Text",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[174515, 5897, 388, 8, 42, "Input",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[174906, 5907, 309, 6, 53, "Message",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[175218, 5915, 475, 8, 85, "Message",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[175696, 5925, 500, 13, 37, "Output",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}]},
  "NDSolve`Reinitialize::ivcon"->{
    Cell[173331, 5860, 150, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[173484, 5866, 404, 9, 37, "Message",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[173891, 5877, 283, 5, 40, "Notes",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[174199, 5886, 97, 1, 38, "ExampleSection",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[174299, 5889, 191, 4, 24, "Text",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[174515, 5897, 388, 8, 42, "Input",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[174906, 5907, 309, 6, 53, "Message",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[175218, 5915, 475, 8, 85, "Message",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
    Cell[175696, 5925, 500, 13, 37, "Output",
      CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}]},
  "NDSolve::icord"->{
    Cell[176257, 5945, 150, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[176410, 5951, 396, 9, 37, "Message",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[176809, 5962, 239, 5, 24, "Notes",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[177073, 5971, 97, 1, 38, "ExampleSection",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[177173, 5974, 263, 5, 40, "Text",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[177461, 5983, 242, 5, 26, "Input",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[177706, 5990, 310, 6, 53, "Message",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[178019, 5998, 721, 19, 23, "Output",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}]},
  "NDSolve`Reinitialize::icord"->{
    Cell[176257, 5945, 150, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[176410, 5951, 396, 9, 37, "Message",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[176809, 5962, 239, 5, 24, "Notes",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[177073, 5971, 97, 1, 38, "ExampleSection",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[177173, 5974, 263, 5, 40, "Text",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[177461, 5983, 242, 5, 26, "Input",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[177706, 5990, 310, 6, 53, "Message",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
    Cell[178019, 5998, 721, 19, 23, "Output",
      CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}]},
  "NDSolve::icorddae"->{
    Cell[178801, 6024, 162, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[178966, 6030, 454, 10, 53, "Message",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[179423, 6042, 245, 5, 24, "Notes",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[179693, 6051, 103, 1, 38, "ExampleSection",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[179799, 6054, 329, 7, 40, "Text",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[180153, 6065, 395, 8, 42, "Input",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[180551, 6075, 353, 6, 69, "Message",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[180907, 6083, 1194, 29, 37, "Output",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}]},
  "NDSolve`Reinitialize::icorddae"->{
    Cell[178801, 6024, 162, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[178966, 6030, 454, 10, 53, "Message",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[179423, 6042, 245, 5, 24, "Notes",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[179693, 6051, 103, 1, 38, "ExampleSection",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[179799, 6054, 329, 7, 40, "Text",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[180153, 6065, 395, 8, 42, "Input",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[180551, 6075, 353, 6, 69, "Message",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
    Cell[180907, 6083, 1194, 29, 37, "Output",
      CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}]},
  "NDSolve::mdata"->{
    Cell[182162, 6119, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::mdata"],
    Cell[182246, 6122, 207, 4, 37, "Message",
      CellTags->"NDSolve::mdata"],
    Cell[182456, 6128, 125, 4, 24, "Notes",
      CellTags->"NDSolve::mdata"]},
  "NDSolve::tponly"->{
    Cell[182618, 6137, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::tponly"],
    Cell[182704, 6140, 226, 4, 53, "Message",
      CellTags->"NDSolve::tponly"],
    Cell[182933, 6146, 180, 5, 24, "Notes",
      CellTags->"NDSolve::tponly"],
    Cell[183138, 6155, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::tponly"],
    Cell[183206, 6158, 235, 7, 40, "Text",
      CellTags->"NDSolve::tponly"],
    Cell[183466, 6169, 377, 7, 58, "Input",
      CellTags->"NDSolve::tponly"],
    Cell[183846, 6178, 237, 5, 37, "Message",
      CellTags->"NDSolve::tponly"],
    Cell[184086, 6185, 940, 24, 71, "Output",
      CellTags->"NDSolve::tponly"]},
  "NDSolve::norm"->{
    Cell[185087, 6216, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::norm"],
    Cell[185169, 6219, 155, 3, 21, "Message",
      CellTags->"NDSolve::norm"],
    Cell[185327, 6224, 124, 4, 24, "Notes",
      CellTags->"NDSolve::norm"]},
  "NDSolve::rclist"->{
    Cell[185488, 6233, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::rclist"],
    Cell[185574, 6236, 590, 14, 37, "Message",
      CellTags->"NDSolve::rclist"],
    Cell[186167, 6252, 155, 4, 24, "Notes",
      CellTags->"NDSolve::rclist"],
    Cell[186347, 6260, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::rclist"],
    Cell[186415, 6263, 206, 6, 24, "Text",
      CellTags->"NDSolve::rclist"],
    Cell[186646, 6273, 446, 8, 74, "Input",
      CellTags->"NDSolve::rclist"],
    Cell[187095, 6283, 309, 6, 53, "Message",
      CellTags->"NDSolve::rclist"],
    Cell[187407, 6291, 994, 25, 71, "Output",
      CellTags->"NDSolve::rclist"]},
  "NDSolve::coend"->{
    Cell[188462, 6323, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::coend"],
    Cell[188546, 6326, 209, 4, 37, "Message",
      CellTags->"NDSolve::coend"],
    Cell[188758, 6332, 213, 5, 40, "Notes",
      CellTags->"NDSolve::coend"],
    Cell[188996, 6341, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::coend"],
    Cell[189063, 6344, 302, 7, 40, "Text",
      CellTags->"NDSolve::coend"],
    Cell[189390, 6355, 434, 8, 74, "Input",
      CellTags->"NDSolve::coend"],
    Cell[189827, 6365, 297, 6, 53, "Message",
      CellTags->"NDSolve::coend"],
    Cell[190127, 6373, 1013, 25, 71, "Output",
      CellTags->"NDSolve::coend"]},
  "NDSolve::coexp"->{
    Cell[191201, 6405, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::coexp"],
    Cell[191285, 6408, 307, 5, 53, "Message",
      CellTags->"NDSolve::coexp"],
    Cell[191595, 6415, 208, 5, 40, "Notes",
      CellTags->"NDSolve::coexp"],
    Cell[191828, 6424, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::coexp"],
    Cell[191895, 6427, 282, 8, 40, "Text",
      CellTags->"NDSolve::coexp"],
    Cell[192202, 6439, 568, 10, 106, "Input",
      CellTags->"NDSolve::coexp"],
    Cell[192773, 6451, 441, 8, 85, "Message",
      CellTags->"NDSolve::coexp"],
    Cell[193217, 6461, 339, 10, 21, "Output",
      CellTags->"NDSolve::coexp"]},
  "NDSolve::ssrei"->{
    Cell[193617, 6478, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ssrei"],
    Cell[193701, 6481, 211, 4, 37, "Message",
      CellTags->"NDSolve::ssrei"],
    Cell[193915, 6487, 125, 4, 24, "Notes",
      CellTags->"NDSolve::ssrei"]},
  "NDSolve::ssre"->{
    Cell[194077, 6496, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ssre"],
    Cell[194159, 6499, 193, 3, 37, "Message",
      CellTags->"NDSolve::ssre"],
    Cell[194355, 6504, 124, 4, 24, "Notes",
      CellTags->"NDSolve::ssre"]},
  "NDSolve::sfty"->{
    Cell[194516, 6513, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::sfty"],
    Cell[194598, 6516, 219, 5, 37, "Message",
      CellTags->"NDSolve::sfty"],
    Cell[194820, 6523, 124, 4, 24, "Notes",
      CellTags->"NDSolve::sfty"]},
  "NDSolve::aord"->{
    Cell[194981, 6532, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::aord"],
    Cell[195063, 6535, 176, 3, 21, "Message",
      CellTags->"NDSolve::aord"],
    Cell[195242, 6540, 124, 4, 24, "Notes",
      CellTags->"NDSolve::aord"]},
  "NDSolve::sss"->{
    Cell[195403, 6549, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::sss"],
    Cell[195483, 6552, 182, 3, 21, "Message",
      CellTags->"NDSolve::sss"],
    Cell[195668, 6557, 123, 4, 24, "Notes",
      CellTags->"NDSolve::sss"]},
  "NDSolve::mconly"->{
    Cell[195828, 6566, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::mconly"],
    Cell[195914, 6569, 291, 5, 53, "Message",
      CellTags->"NDSolve::mconly"],
    Cell[196208, 6576, 126, 4, 24, "Notes",
      CellTags->"NDSolve::mconly"]},
  "NDSolve::nolib"->{
    Cell[196371, 6585, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::nolib"],
    Cell[196455, 6588, 220, 4, 37, "Message",
      CellTags->"NDSolve::nolib"],
    Cell[196678, 6594, 125, 4, 24, "Notes",
      CellTags->"NDSolve::nolib"]},
  "NDSolve::nodae"->{
    Cell[196840, 6603, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::nodae"],
    Cell[196924, 6606, 274, 5, 53, "Message",
      CellTags->"NDSolve::nodae"],
    Cell[197201, 6613, 334, 7, 40, "Notes",
      CellTags->"NDSolve::nodae"],
    Cell[197560, 6624, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::nodae"],
    Cell[197627, 6627, 175, 4, 40, "Text",
      CellTags->"NDSolve::nodae"],
    Cell[197827, 6635, 277, 6, 42, "Input",
      CellTags->"NDSolve::nodae"],
    Cell[198107, 6643, 272, 6, 53, "Message",
      CellTags->"NDSolve::nodae"],
    Cell[198382, 6651, 90, 3, 21, "Output",
      CellTags->"NDSolve::nodae"]},
  "NDSolve::icfail"->{
    Cell[198533, 6661, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::icfail"],
    Cell[198619, 6664, 328, 5, 53, "Message",
      CellTags->"NDSolve::icfail"],
    Cell[198950, 6671, 200, 5, 24, "Notes",
      CellTags->"NDSolve::icfail"],
    Cell[199175, 6680, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::icfail"],
    Cell[199243, 6683, 142, 4, 24, "Text",
      CellTags->"NDSolve::icfail"],
    Cell[199410, 6691, 265, 6, 42, "Input",
      CellTags->"NDSolve::icfail"],
    Cell[199678, 6699, 321, 6, 69, "Message",
      CellTags->"NDSolve::icfail"],
    Cell[200002, 6707, 91, 3, 21, "Output",
      CellTags->"NDSolve::icfail"]},
  "NDSolve::lsopt"->{
    Cell[200154, 6717, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::lsopt"],
    Cell[200238, 6720, 273, 4, 53, "Message",
      CellTags->"NDSolve::lsopt"],
    Cell[200514, 6726, 167, 4, 24, "Notes",
      CellTags->"NDSolve::lsopt"],
    Cell[200706, 6734, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::lsopt"],
    Cell[200773, 6737, 239, 6, 40, "Text",
      CellTags->"NDSolve::lsopt"],
    Cell[201037, 6747, 638, 12, 106, "Input",
      CellTags->"NDSolve::lsopt"],
    Cell[201678, 6761, 297, 6, 53, "Message",
      CellTags->"NDSolve::lsopt"],
    Cell[201978, 6769, 1538, 35, 129, "Output",
      CellTags->"NDSolve::lsopt"]},
  "NDSolve::molpde"->{
    Cell[203577, 6811, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::molpde"],
    Cell[203663, 6814, 273, 5, 53, "Message",
      CellTags->"NDSolve::molpde"],
    Cell[203939, 6821, 331, 9, 40, "Notes",
      CellTags->"NDSolve::molpde"],
    Cell[204295, 6834, 65, 1, 38, "ExampleSection",
      CellTags->"NDSolve::molpde"],
    Cell[204363, 6837, 193, 5, 40, "Text",
      CellTags->"NDSolve::molpde"],
    Cell[204581, 6846, 298, 6, 58, "Input",
      CellTags->"NDSolve::molpde"],
    Cell[204882, 6854, 269, 6, 53, "Message",
      CellTags->"NDSolve::molpde"],
    Cell[205154, 6862, 758, 19, 39, "Output",
      CellTags->"NDSolve::molpde"]},
  "NDSolve::chbvp"->{
    Cell[205973, 6888, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::chbvp"],
    Cell[206057, 6891, 274, 5, 53, "Message",
      CellTags->"NDSolve::chbvp"],
    Cell[206334, 6898, 317, 9, 40, "Notes",
      CellTags->"NDSolve::chbvp"],
    Cell[206676, 6911, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::chbvp"],
    Cell[206743, 6914, 194, 5, 40, "Text",
      CellTags->"NDSolve::chbvp"],
    Cell[206962, 6923, 291, 6, 58, "Input",
      CellTags->"NDSolve::chbvp"],
    Cell[207256, 6931, 267, 6, 53, "Message",
      CellTags->"NDSolve::chbvp"],
    Cell[207526, 6939, 751, 19, 39, "Output",
      CellTags->"NDSolve::chbvp"]},
  "NDSolve::jpde"->{
    Cell[208338, 6965, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::jpde"],
    Cell[208420, 6968, 292, 5, 53, "Message",
      CellTags->"NDSolve::jpde"],
    Cell[208715, 6975, 193, 5, 40, "Notes",
      CellTags->"NDSolve::jpde"],
    Cell[208933, 6984, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::jpde"],
    Cell[208999, 6987, 206, 6, 40, "Text",
      CellTags->"NDSolve::jpde"],
    Cell[209230, 6997, 300, 6, 58, "Input",
      CellTags->"NDSolve::jpde"],
    Cell[209533, 7005, 286, 6, 69, "Message",
      CellTags->"NDSolve::jpde"],
    Cell[209822, 7013, 338, 10, 21, "Output",
      CellTags->"NDSolve::jpde"]},
  "NDSolve::tvar"->{
    Cell[210221, 7030, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::tvar"],
    Cell[210303, 7033, 200, 4, 37, "Message",
      CellTags->"NDSolve::tvar"],
    Cell[210506, 7039, 157, 4, 24, "Notes",
      CellTags->"NDSolve::tvar"],
    Cell[210688, 7047, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::tvar"],
    Cell[210754, 7050, 247, 6, 40, "Text",
      CellTags->"NDSolve::tvar"],
    Cell[211026, 7060, 345, 7, 58, "Input",
      CellTags->"NDSolve::tvar"],
    Cell[211374, 7069, 242, 5, 37, "Message",
      CellTags->"NDSolve::tvar"],
    Cell[211619, 7076, 898, 23, 55, "Output",
      CellTags->"NDSolve::tvar"]},
  "NDSolve::tvic"->{
    Cell[212578, 7106, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::tvic"],
    Cell[212660, 7109, 338, 6, 69, "Message",
      CellTags->"NDSolve::tvic"],
    Cell[213001, 7117, 187, 5, 24, "Notes",
      CellTags->"NDSolve::tvic"],
    Cell[213213, 7126, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::tvic"],
    Cell[213279, 7129, 266, 6, 40, "Text",
      CellTags->"NDSolve::tvic"],
    Cell[213570, 7139, 309, 7, 58, "Input",
      CellTags->"NDSolve::tvic"],
    Cell[213882, 7148, 334, 6, 69, "Message",
      CellTags->"NDSolve::tvic"],
    Cell[214219, 7156, 850, 22, 55, "Output",
      CellTags->"NDSolve::tvic"]},
  "NDSolve::ponly"->{
    Cell[215130, 7185, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ponly"],
    Cell[215214, 7188, 244, 4, 37, "Message",
      CellTags->"NDSolve::ponly"],
    Cell[215461, 7194, 125, 4, 24, "Notes",
      CellTags->"NDSolve::ponly"]},
  "NDSolve::mdo"->{
    Cell[215623, 7203, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::mdo"],
    Cell[215703, 7206, 237, 5, 37, "Message",
      CellTags->"NDSolve::mdo"],
    Cell[215943, 7213, 196, 5, 24, "Notes",
      CellTags->"NDSolve::mdo"],
    Cell[216164, 7222, 62, 1, 38, "ExampleSection",
      CellTags->"NDSolve::mdo"],
    Cell[216229, 7225, 218, 6, 40, "Text",
      CellTags->"NDSolve::mdo"],
    Cell[216472, 7235, 255, 6, 42, "Input",
      CellTags->"NDSolve::mdo"],
    Cell[216730, 7243, 262, 5, 37, "Message",
      CellTags->"NDSolve::mdo"],
    Cell[216995, 7250, 194, 5, 21, "Message",
      CellTags->"NDSolve::mdo"],
    Cell[217192, 7257, 276, 8, 21, "Output",
      CellTags->"NDSolve::mdo"]},
  "NDSolve::mord"->{
    Cell[217529, 7272, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::mord"],
    Cell[217611, 7275, 170, 3, 21, "Message",
      CellTags->"NDSolve::mord"],
    Cell[217784, 7280, 124, 4, 24, "Notes",
      CellTags->"NDSolve::mord"]},
  "NDSolve::imps"->{
    Cell[217945, 7289, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::imps"],
    Cell[218027, 7292, 219, 4, 37, "Message",
      CellTags->"NDSolve::imps"],
    Cell[218249, 7298, 199, 5, 24, "Notes",
      CellTags->"NDSolve::imps"],
    Cell[218473, 7307, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::imps"],
    Cell[218539, 7310, 210, 7, 24, "Text",
      CellTags->"NDSolve::imps"],
    Cell[218774, 7321, 252, 6, 42, "Input",
      CellTags->"NDSolve::imps"],
    Cell[219029, 7329, 223, 5, 37, "Message",
      CellTags->"NDSolve::imps"],
    Cell[219255, 7336, 195, 5, 21, "Message",
      CellTags->"NDSolve::imps"],
    Cell[219453, 7343, 277, 8, 21, "Output",
      CellTags->"NDSolve::imps"]},
  "NDSolve::lsm"->{
    Cell[219791, 7358, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::lsm"],
    Cell[219871, 7361, 201, 4, 37, "Message",
      CellTags->"NDSolve::lsm"],
    Cell[220075, 7367, 273, 6, 46, "Notes",
      CellTags->"NDSolve::lsm"],
    Cell[220373, 7377, 62, 1, 38, "ExampleSection",
      CellTags->"NDSolve::lsm"],
    Cell[220438, 7380, 232, 7, 40, "Text",
      CellTags->"NDSolve::lsm"],
    Cell[220695, 7391, 321, 7, 58, "Input",
      CellTags->"NDSolve::lsm"],
    Cell[221019, 7400, 227, 5, 37, "Message",
      CellTags->"NDSolve::lsm"],
    Cell[221249, 7407, 194, 5, 21, "Message",
      CellTags->"NDSolve::lsm"],
    Cell[221446, 7414, 276, 8, 21, "Output",
      CellTags->"NDSolve::lsm"]},
  "NDSolve::bw"->{
    Cell[221783, 7429, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bw"],
    Cell[221861, 7432, 269, 4, 53, "Message",
      CellTags->"NDSolve::bw"],
    Cell[222133, 7438, 264, 6, 46, "Notes",
      CellTags->"NDSolve::bw"],
    Cell[222422, 7448, 61, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bw"],
    Cell[222486, 7451, 220, 7, 24, "Text",
      CellTags->"NDSolve::bw"],
    Cell[222731, 7462, 334, 7, 58, "Input",
      CellTags->"NDSolve::bw"],
    Cell[223068, 7471, 289, 6, 53, "Message",
      CellTags->"NDSolve::bw"],
    Cell[223360, 7479, 193, 5, 21, "Message",
      CellTags->"NDSolve::bw"],
    Cell[223556, 7486, 275, 8, 21, "Output",
      CellTags->"NDSolve::bw"]},
  "NDSolve::otype"->{
    Cell[223892, 7501, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::otype"],
    Cell[223976, 7504, 217, 4, 37, "Message",
      CellTags->"NDSolve::otype"],
    Cell[224196, 7510, 279, 6, 46, "Notes",
      CellTags->"NDSolve::otype"],
    Cell[224500, 7520, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::otype"],
    Cell[224567, 7523, 227, 7, 40, "Text",
      CellTags->"NDSolve::otype"],
    Cell[224819, 7534, 298, 6, 42, "Input",
      CellTags->"NDSolve::otype"],
    Cell[225120, 7542, 260, 5, 53, "Message",
      CellTags->"NDSolve::otype"],
    Cell[225383, 7549, 196, 5, 21, "Message",
      CellTags->"NDSolve::otype"],
    Cell[225582, 7556, 278, 8, 21, "Output",
      CellTags->"NDSolve::otype"]},
  "NDSolve::scpar"->{
    Cell[225921, 7571, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::scpar"],
    Cell[226005, 7574, 252, 4, 53, "Message",
      CellTags->"NDSolve::scpar"],
    Cell[226260, 7580, 125, 4, 24, "Notes",
      CellTags->"NDSolve::scpar"]},
  "NDSolve::subsp"->{
    Cell[226422, 7589, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::subsp"],
    Cell[226506, 7592, 209, 4, 37, "Message",
      CellTags->"NDSolve::subsp"],
    Cell[226718, 7598, 231, 6, 46, "Notes",
      CellTags->"NDSolve::subsp"],
    Cell[226974, 7608, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::subsp"],
    Cell[227041, 7611, 229, 7, 40, "Text",
      CellTags->"NDSolve::subsp"],
    Cell[227295, 7622, 300, 6, 58, "Input",
      CellTags->"NDSolve::subsp"],
    Cell[227598, 7630, 265, 5, 53, "Message",
      CellTags->"NDSolve::subsp"],
    Cell[227866, 7637, 196, 5, 21, "Message",
      CellTags->"NDSolve::subsp"],
    Cell[228065, 7644, 278, 8, 21, "Output",
      CellTags->"NDSolve::subsp"]},
  "NDSolve::ssrb"->{
    Cell[228404, 7659, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ssrb"],
    Cell[228486, 7662, 293, 5, 53, "Message",
      CellTags->"NDSolve::ssrb"],
    Cell[228782, 7669, 124, 4, 24, "Notes",
      CellTags->"NDSolve::ssrb"]},
  "NDSolve::ssserr"->{
    Cell[228943, 7678, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ssserr"],
    Cell[229029, 7681, 235, 4, 37, "Message",
      CellTags->"NDSolve::ssserr"],
    Cell[229267, 7687, 126, 4, 24, "Notes",
      CellTags->"NDSolve::ssserr"]},
  "NDSolve::irkcargs"->{
    Cell[229430, 7696, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::irkcargs"],
    Cell[229520, 7699, 207, 5, 37, "Message",
      CellTags->"NDSolve::irkcargs"],
    Cell[229730, 7706, 128, 4, 24, "Notes",
      CellTags->"NDSolve::irkcargs"]},
  "NDSolve::irkcopts"->{
    Cell[229895, 7715, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::irkcopts"],
    Cell[229985, 7718, 205, 5, 37, "Message",
      CellTags->"NDSolve::irkcopts"],
    Cell[230193, 7725, 128, 4, 24, "Notes",
      CellTags->"NDSolve::irkcopts"]},
  "NDSolve::irkcploss"->{
    Cell[230358, 7734, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::irkcploss"],
    Cell[230450, 7737, 224, 4, 37, "Message",
      CellTags->"NDSolve::irkcploss"],
    Cell[230677, 7743, 129, 4, 24, "Notes",
      CellTags->"NDSolve::irkcploss"]},
  "NDSolve`Iterate::sivpd"->{
    Cell[230843, 7752, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`Iterate::sivpd"],
    Cell[230943, 7755, 250, 4, 37, "Message",
      CellTags->"NDSolve`Iterate::sivpd"],
    Cell[231196, 7761, 191, 4, 24, "Notes",
      CellTags->"NDSolve`Iterate::sivpd"],
    Cell[231412, 7769, 72, 1, 38, "ExampleSection",
      CellTags->"NDSolve`Iterate::sivpd"],
    Cell[231487, 7772, 175, 4, 24, "Text",
      CellTags->"NDSolve`Iterate::sivpd"],
    Cell[231687, 7780, 116, 3, 26, "Input",
      CellTags->"NDSolve`Iterate::sivpd"],
    Cell[231806, 7785, 295, 6, 53, "Message",
      CellTags->"NDSolve`Iterate::sivpd"],
    Cell[232104, 7793, 117, 3, 21, "Output",
      CellTags->"NDSolve`Iterate::sivpd"],
    Cell[232258, 7801, 247, 6, 42, "Input",
      CellTags->"NDSolve`Iterate::sivpd"],
    Cell[232508, 7809, 453, 7, 69, "Message",
      CellTags->"NDSolve`Iterate::sivpd"],
    Cell[232964, 7818, 453, 13, 21, "Output",
      CellTags->"NDSolve`Iterate::sivpd"]},
  "NDSolve::exseq"->{
    Cell[233478, 7838, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::exseq"],
    Cell[233562, 7841, 400, 7, 69, "Message",
      CellTags->"NDSolve::exseq"],
    Cell[233965, 7850, 125, 4, 24, "Notes",
      CellTags->"NDSolve::exseq"]},
  "NDSolve::exseqev"->{
    Cell[234127, 7859, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::exseqev"],
    Cell[234215, 7862, 309, 5, 53, "Message",
      CellTags->"NDSolve::exseqev"],
    Cell[234527, 7869, 127, 4, 24, "Notes",
      CellTags->"NDSolve::exseqev"]},
  "NDSolve::exmaxo"->{
    Cell[234691, 7878, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::exmaxo"],
    Cell[234777, 7881, 283, 5, 53, "Message",
      CellTags->"NDSolve::exmaxo"],
    Cell[235063, 7888, 126, 4, 24, "Notes",
      CellTags->"NDSolve::exmaxo"]},
  "NDSolve::exmino"->{
    Cell[235226, 7897, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::exmino"],
    Cell[235312, 7900, 262, 4, 37, "Message",
      CellTags->"NDSolve::exmino"],
    Cell[235577, 7906, 126, 4, 24, "Notes",
      CellTags->"NDSolve::exmino"]},
  "NDSolve::exsord"->{
    Cell[235740, 7915, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::exsord"],
    Cell[235826, 7918, 254, 4, 37, "Message",
      CellTags->"NDSolve::exsord"],
    Cell[236083, 7924, 126, 4, 24, "Notes",
      CellTags->"NDSolve::exsord"]},
  "NDSolve::exordf"->{
    Cell[236246, 7933, 124, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::exordf", "NDSolve::sssf"}],
    Cell[236373, 7939, 406, 11, 37, "Message",
      CellTags->{"NDSolve::exordf", "NDSolve::sssf"}],
    Cell[236782, 7952, 145, 4, 24, "Notes",
      CellTags->{"NDSolve::exordf", "NDSolve::sssf"}]},
  "NDSolve::sssf"->{
    Cell[236246, 7933, 124, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::exordf", "NDSolve::sssf"}],
    Cell[236373, 7939, 406, 11, 37, "Message",
      CellTags->{"NDSolve::exordf", "NDSolve::sssf"}],
    Cell[236782, 7952, 145, 4, 24, "Notes",
      CellTags->{"NDSolve::exordf", "NDSolve::sssf"}]},
  "NDSolve`FiniteDifferenceDerivative::deriv"->{
    Cell[236964, 7961, 135, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],
    Cell[237102, 7964, 262, 4, 37, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],
    Cell[237367, 7970, 170, 4, 24, "Notes",
      CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],
    Cell[237562, 7978, 91, 1, 38, "ExampleSection",
      CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],
    Cell[237656, 7981, 183, 4, 24, "Text",
      CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],
    Cell[237864, 7989, 162, 3, 26, "Input",
      CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],
    Cell[238029, 7994, 281, 5, 37, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],
    Cell[238313, 8001, 208, 4, 21, "Output",
      CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"]},
  "NDSolve`FiniteDifferenceDerivative::ldim"->{
    Cell[238582, 8012, 133, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],
    Cell[238718, 8015, 251, 4, 37, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],
    Cell[238972, 8021, 169, 4, 24, "Notes",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],
    Cell[239166, 8029, 90, 1, 38, "ExampleSection",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],
    Cell[239259, 8032, 182, 4, 24, "Text",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],
    Cell[239466, 8040, 183, 4, 26, "Input",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],
    Cell[239652, 8046, 296, 5, 53, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],
    Cell[239951, 8053, 206, 4, 37, "Output",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"]},
  "NDSolve`FiniteDifferenceDerivative::grid"->{
    Cell[240218, 8064, 133, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
    Cell[240354, 8067, 277, 4, 37, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
    Cell[240634, 8073, 169, 4, 24, "Notes",
      CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
    Cell[240828, 8081, 90, 1, 38, "ExampleSection",
      CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
    Cell[240921, 8084, 182, 4, 24, "Text",
      CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
    Cell[241128, 8092, 175, 4, 26, "Input",
      CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
    Cell[241306, 8098, 298, 5, 53, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
    Cell[241607, 8105, 181, 4, 21, "Output",
      CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
    Cell[241803, 8112, 245, 5, 40, "Text",
      CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
    Cell[242073, 8121, 283, 5, 58, "Input",
      CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
    Cell[242359, 8128, 552, 9, 82, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
    Cell[242914, 8139, 564, 10, 143, "Output",
      CellTags->"NDSolve`FiniteDifferenceDerivative::grid"]},
  "NDSolve`FiniteDifferenceDerivative::aord"->{
    Cell[243539, 8156, 133, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
    Cell[243675, 8159, 289, 4, 53, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
    Cell[243967, 8165, 169, 4, 24, "Notes",
      CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
    Cell[244161, 8173, 90, 1, 38, "ExampleSection",
      CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
    Cell[244254, 8176, 182, 4, 24, "Text",
      CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
    Cell[244461, 8184, 214, 4, 42, "Input",
      CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
    Cell[244678, 8190, 322, 5, 53, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
    Cell[245003, 8197, 242, 5, 37, "Output",
      CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
    Cell[245260, 8205, 182, 4, 24, "Text",
      CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
    Cell[245467, 8213, 290, 5, 58, "Input",
      CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
    Cell[245760, 8220, 340, 6, 53, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
    Cell[246103, 8228, 377, 7, 53, "Output",
      CellTags->"NDSolve`FiniteDifferenceDerivative::aord"]},
  "NDSolve`FiniteDifferenceDerivative::per"->{
    Cell[246541, 8242, 131, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`FiniteDifferenceDerivative::per"],
    Cell[246675, 8245, 274, 4, 37, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::per"],
    Cell[246952, 8251, 168, 4, 24, "Notes",
      CellTags->"NDSolve`FiniteDifferenceDerivative::per"],
    Cell[247145, 8259, 89, 1, 38, "ExampleSection",
      CellTags->"NDSolve`FiniteDifferenceDerivative::per"],
    Cell[247237, 8262, 181, 4, 24, "Text",
      CellTags->"NDSolve`FiniteDifferenceDerivative::per"],
    Cell[247443, 8270, 218, 4, 42, "Input",
      CellTags->"NDSolve`FiniteDifferenceDerivative::per"],
    Cell[247664, 8276, 292, 5, 53, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::per"],
    Cell[247959, 8283, 246, 5, 37, "Output",
      CellTags->"NDSolve`FiniteDifferenceDerivative::per"]},
  "NDSolve`FiniteDifferenceDerivative::spu"->{
    Cell[248266, 8295, 131, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`FiniteDifferenceDerivative::spu"],
    Cell[248400, 8298, 330, 5, 53, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::spu"],
    Cell[248733, 8305, 168, 4, 24, "Notes",
      CellTags->"NDSolve`FiniteDifferenceDerivative::spu"]},
  "NDSolve`FiniteDifferenceDerivative::spc"->{
    Cell[248938, 8314, 131, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],
    Cell[249072, 8317, 418, 7, 69, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],
    Cell[249493, 8326, 168, 4, 24, "Notes",
      CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],
    Cell[249686, 8334, 89, 1, 38, "ExampleSection",
      CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],
    Cell[249778, 8337, 181, 4, 24, "Text",
      CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],
    Cell[249984, 8345, 220, 4, 42, "Input",
      CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],
    Cell[250207, 8351, 434, 7, 69, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],
    Cell[250644, 8360, 251, 5, 37, "Output",
      CellTags->"NDSolve`FiniteDifferenceDerivative::spc"]},
  "NDSolve`FiniteDifferenceDerivative::conw"->{
    Cell[250956, 8372, 133, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],
    Cell[251092, 8375, 277, 4, 37, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],
    Cell[251372, 8381, 169, 4, 24, "Notes",
      CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],
    Cell[251566, 8389, 90, 1, 38, "ExampleSection",
      CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],
    Cell[251659, 8392, 182, 4, 24, "Text",
      CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],
    Cell[251866, 8400, 208, 4, 42, "Input",
      CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],
    Cell[252077, 8406, 289, 5, 53, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],
    Cell[252369, 8413, 202, 4, 21, "Output",
      CellTags->"NDSolve`FiniteDifferenceDerivative::conw"]},
  "NDSolve`FiniteDifferenceDerivative::ordred"->{
    Cell[252632, 8424, 137, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],
    Cell[252772, 8427, 327, 5, 53, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],
    Cell[253102, 8434, 191, 4, 24, "Notes",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],
    Cell[253318, 8442, 92, 1, 38, "ExampleSection",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],
    Cell[253413, 8445, 184, 4, 24, "Text",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],
    Cell[253622, 8453, 210, 4, 42, "Input",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],
    Cell[253835, 8459, 326, 6, 53, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],
    Cell[254164, 8467, 232, 6, 21, "Output",
      CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"]},
  "NDSolve`FiniteDifferenceDerivativeFunction::ddim"->{
    Cell[254457, 8480, 151, 2, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],
    Cell[254611, 8484, 252, 4, 37, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],
    Cell[254866, 8490, 177, 4, 24, "Notes",
      CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],
    Cell[255068, 8498, 98, 1, 38, "ExampleSection",
      CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],
    Cell[255169, 8501, 190, 4, 24, "Text",
      CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],
    Cell[255384, 8509, 199, 4, 26, "Input",
      CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],
    Cell[255586, 8515, 276, 5, 37, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],
    Cell[255865, 8522, 280, 7, 21, "Output",
      CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"]},
  "NDSolve`FiniteDifferenceDerivativeFunction::spnum"->{
    Cell[256206, 8536, 153, 2, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::spnum"],
    Cell[256362, 8540, 312, 5, 37, "Message",
      CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::spnum"],
    Cell[256677, 8547, 178, 4, 24, "Notes",
      CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::spnum"]},
  "NDSolve::bcuns"->{
    Cell[256892, 8556, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::bcuns"],
    Cell[256976, 8559, 177, 3, 21, "Message",
      CellTags->"NDSolve::bcuns"],
    Cell[257156, 8564, 152, 4, 24, "Notes",
      CellTags->"NDSolve::bcuns"],
    Cell[257333, 8572, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::bcuns"],
    Cell[257400, 8575, 158, 4, 24, "Text",
      CellTags->"NDSolve::bcuns"],
    Cell[257583, 8583, 314, 6, 58, "Input",
      CellTags->"NDSolve::bcuns"],
    Cell[257900, 8591, 263, 5, 37, "Message",
      CellTags->"NDSolve::bcuns"],
    Cell[258166, 8598, 1063, 28, 41, "Output",
      CellTags->"NDSolve::bcuns"],
    Cell[259244, 8629, 141, 4, 24, "Text",
      CellTags->"NDSolve::bcuns"],
    Cell[259410, 8637, 304, 6, 58, "Input",
      CellTags->"NDSolve::bcuns"],
    Cell[259717, 8645, 290, 8, 21, "Output",
      CellTags->"NDSolve::bcuns"]},
  "NDSolve::dvout"->{
    Cell[260068, 8660, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::dvout"],
    Cell[260152, 8663, 197, 3, 21, "Message",
      CellTags->"NDSolve::dvout"],
    Cell[260352, 8668, 125, 4, 24, "Notes",
      CellTags->"NDSolve::dvout"]},
  "NDSolve::idobj"->{
    Cell[260514, 8677, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::idobj"],
    Cell[260598, 8680, 163, 3, 21, "Message",
      CellTags->"NDSolve::idobj"],
    Cell[260764, 8685, 125, 4, 24, "Notes",
      CellTags->"NDSolve::idobj"]},
  "NDSolve::ivdae"->{
    Cell[260926, 8694, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ivdae"],
    Cell[261010, 8697, 298, 6, 53, "Message",
      CellTags->"NDSolve::ivdae"],
    Cell[261311, 8705, 191, 6, 24, "Notes",
      CellTags->"NDSolve::ivdae"],
    Cell[261527, 8715, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::ivdae"],
    Cell[261594, 8718, 177, 6, 24, "Text",
      CellTags->"NDSolve::ivdae"],
    Cell[261796, 8728, 272, 6, 42, "Input",
      CellTags->"NDSolve::ivdae"],
    Cell[262071, 8736, 281, 6, 53, "Message",
      CellTags->"NDSolve::ivdae"],
    Cell[262355, 8744, 753, 19, 37, "Output",
      CellTags->"NDSolve::ivdae"]},
  "NDSolve::ivres"->{
    Cell[263169, 8770, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ivres"],
    Cell[263253, 8773, 495, 9, 85, "Message",
      CellTags->"NDSolve::ivres"],
    Cell[263751, 8784, 125, 4, 24, "Notes",
      CellTags->"NDSolve::ivres"]},
  "NDSolve::ndtola"->{
    Cell[263913, 8793, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndtola"],
    Cell[263999, 8796, 286, 5, 53, "Message",
      CellTags->"NDSolve::ndtola"],
    Cell[264288, 8803, 126, 4, 24, "Notes",
      CellTags->"NDSolve::ndtola"]},
  "NDSolve::nfnan"->{
    Cell[264451, 8812, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::nfnan"],
    Cell[264535, 8815, 254, 4, 37, "Message",
      CellTags->"NDSolve::nfnan"],
    Cell[264792, 8821, 196, 5, 24, "Notes",
      CellTags->"NDSolve::nfnan"],
    Cell[265013, 8830, 64, 1, 38, "ExampleSection",
      CellTags->"NDSolve::nfnan"],
    Cell[265080, 8833, 212, 7, 24, "Text",
      CellTags->"NDSolve::nfnan"],
    Cell[265317, 8844, 248, 5, 42, "Input",
      CellTags->"NDSolve::nfnan"],
    Cell[265568, 8851, 307, 6, 55, "Message",
      CellTags->"NDSolve::nfnan"],
    Cell[265878, 8859, 201, 5, 21, "Message",
      CellTags->"NDSolve::nfnan"],
    Cell[266082, 8866, 278, 8, 21, "Output",
      CellTags->"NDSolve::nfnan"]},
  "NDSolve::nfp"->{
    Cell[266421, 8881, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::nfp"],
    Cell[266501, 8884, 271, 5, 37, "Message",
      CellTags->"NDSolve::nfp"],
    Cell[266775, 8891, 123, 4, 24, "Notes",
      CellTags->"NDSolve::nfp"]},
  "NDSolve::nodv"->{
    Cell[266935, 8900, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::nodv"],
    Cell[267017, 8903, 407, 7, 69, "Message",
      CellTags->"NDSolve::nodv"],
    Cell[267427, 8912, 124, 4, 24, "Notes",
      CellTags->"NDSolve::nodv"],
    Cell[267576, 8920, 63, 1, 38, "ExampleSection",
      CellTags->"NDSolve::nodv"],
    Cell[267642, 8923, 202, 5, 24, "Text",
      CellTags->"NDSolve::nodv"],
    Cell[267869, 8932, 141, 3, 26, "Input",
      CellTags->"NDSolve::nodv"],
    Cell[268013, 8937, 368, 7, 85, "Message",
      CellTags->"NDSolve::nodv"],
    Cell[268384, 8946, 384, 11, 21, "Output",
      CellTags->"NDSolve::nodv"],
    Cell[268783, 8960, 105, 1, 24, "Text",
      CellTags->"NDSolve::nodv"],
    Cell[268913, 8965, 155, 4, 26, "Input",
      CellTags->"NDSolve::nodv"],
    Cell[269071, 8971, 277, 8, 21, "Output",
      CellTags->"NDSolve::nodv"]},
  "NDSolve::noout"->{
    Cell[269409, 8986, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::noout"],
    Cell[269493, 8989, 175, 3, 21, "Message",
      CellTags->"NDSolve::noout"],
    Cell[269671, 8994, 125, 4, 24, "Notes",
      CellTags->"NDSolve::noout"]},
  "NDSolve::pdeopt"->{
    Cell[269833, 9003, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::pdeopt"],
    Cell[269919, 9006, 183, 3, 21, "Message",
      CellTags->"NDSolve::pdeopt"],
    Cell[270105, 9011, 126, 4, 24, "Notes",
      CellTags->"NDSolve::pdeopt"]},
  "NDSolve`ProcessSolutions::nodata"->{
    Cell[270268, 9020, 117, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`ProcessSolutions::nodata"],
    Cell[270388, 9023, 234, 4, 37, "Message",
      CellTags->"NDSolve`ProcessSolutions::nodata"],
    Cell[270625, 9029, 143, 4, 24, "Notes",
      CellTags->"NDSolve`ProcessSolutions::nodata"]},
  "NDSolve`ScaledVectorNorm::fnnan"->{
    Cell[270805, 9038, 115, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`ScaledVectorNorm::fnnan"],
    Cell[270923, 9041, 244, 4, 37, "Message",
      CellTags->"NDSolve`ScaledVectorNorm::fnnan"],
    Cell[271170, 9047, 142, 4, 24, "Notes",
      CellTags->"NDSolve`ScaledVectorNorm::fnnan"]},
  "NDSolve`ScaledVectorNorm::nfp"->{
    Cell[271349, 9056, 111, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`ScaledVectorNorm::nfp"],
    Cell[271463, 9059, 259, 4, 37, "Message",
      CellTags->"NDSolve`ScaledVectorNorm::nfp"],
    Cell[271725, 9065, 140, 4, 24, "Notes",
      CellTags->"NDSolve`ScaledVectorNorm::nfp"]},
  "NDSolve`ScaledVectorNorm::nvec"->{
    Cell[271902, 9074, 113, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`ScaledVectorNorm::nvec"],
    Cell[272018, 9077, 170, 3, 21, "Message",
      CellTags->"NDSolve`ScaledVectorNorm::nvec"],
    Cell[272191, 9082, 141, 4, 24, "Notes",
      CellTags->"NDSolve`ScaledVectorNorm::nvec"]},
  "NDSolve`ScaledVectorNorm::pinp"->{
    Cell[272369, 9091, 113, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`ScaledVectorNorm::pinp"],
    Cell[272485, 9094, 320, 5, 53, "Message",
      CellTags->"NDSolve`ScaledVectorNorm::pinp"],
    Cell[272808, 9101, 141, 4, 24, "Notes",
      CellTags->"NDSolve`ScaledVectorNorm::pinp"]},
  "NDSolve`ScaledVectorNorm::sinp"->{
    Cell[272986, 9110, 113, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`ScaledVectorNorm::sinp"],
    Cell[273102, 9113, 227, 4, 37, "Message",
      CellTags->"NDSolve`ScaledVectorNorm::sinp"],
    Cell[273332, 9119, 141, 4, 24, "Notes",
      CellTags->"NDSolve`ScaledVectorNorm::sinp"]},
  "NDSolve`ScaledVectorNorm::tinp"->{
    Cell[273510, 9128, 113, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve`ScaledVectorNorm::tinp"],
    Cell[273626, 9131, 331, 5, 53, "Message",
      CellTags->"NDSolve`ScaledVectorNorm::tinp"],
    Cell[273960, 9138, 141, 4, 24, "Notes",
      CellTags->"NDSolve`ScaledVectorNorm::tinp"]},
  "NDSolve::urange"->{
    Cell[274138, 9147, 162, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::urange", "NDSolve`ScaledVectorNorm::urange"}],
    Cell[274303, 9153, 368, 9, 37, "Message",
      CellTags->{"NDSolve::urange", "NDSolve`ScaledVectorNorm::urange"}],
    Cell[274674, 9164, 164, 4, 24, "Notes",
      CellTags->{"NDSolve::urange", "NDSolve`ScaledVectorNorm::urange"}]},
  "NDSolve`ScaledVectorNorm::urange"->{
    Cell[274138, 9147, 162, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NDSolve::urange", "NDSolve`ScaledVectorNorm::urange"}],
    Cell[274303, 9153, 368, 9, 37, "Message",
      CellTags->{"NDSolve::urange", "NDSolve`ScaledVectorNorm::urange"}],
    Cell[274674, 9164, 164, 4, 24, "Notes",
      CellTags->{"NDSolve::urange", "NDSolve`ScaledVectorNorm::urange"}]},
  "NDSolve::eord"->{
    Cell[274875, 9173, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::eord"],
    Cell[274957, 9176, 246, 4, 37, "Message",
      CellTags->"NDSolve::eord"],
    Cell[275206, 9182, 124, 4, 24, "Notes",
      CellTags->"NDSolve::eord"]},
  "NDSolve::ndstab"->{
    Cell[275367, 9191, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::ndstab"],
    Cell[275453, 9194, 210, 6, 21, "Message",
      CellTags->"NDSolve::ndstab"],
    Cell[275666, 9202, 126, 4, 24, "Notes",
      CellTags->"NDSolve::ndstab"]},
  "NDSolve::maxsts"->{
    Cell[275829, 9211, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::maxsts"],
    Cell[275915, 9214, 225, 5, 37, "Message",
      CellTags->"NDSolve::maxsts"],
    Cell[276143, 9221, 126, 4, 24, "Notes",
      CellTags->"NDSolve::maxsts"]},
  "NDSolve::mtdp"->{
    Cell[276306, 9230, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NDSolve::mtdp"],
    Cell[276388, 9233, 203, 5, 37, "Message",
      CellTags->"NDSolve::mtdp"],
    Cell[276594, 9240, 124, 4, 24, "Notes",
      CellTags->"NDSolve::mtdp"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"NDSolve::ndtol", 277411, 9265},
  {"NDSolve::ivone", 278294, 9288},
  {"NDSolve::bcnorm", 279187, 9311},
  {"NDSolve::ndlim", 279860, 9328},
  {"NDSolve::ndcf", 280134, 9335},
  {"DSolve::conarg", 280407, 9342},
  {"NDSolve::conarg", 281741, 9365},
  {"RSolve::conarg", 283074, 9388},
  {"NDSolve::ndnco", 284407, 9411},
  {"NDSolve`Reinitialize::ndnco", 285687, 9434},
  {"NDSolve::ntcs", 286953, 9457},
  {"NDSolve::bcart", 287845, 9480},
  {"NDSolve::ndsv", 288745, 9503},
  {"NDSolve`Reinitialize::ndsv", 289127, 9510},
  {"NDSolve::nderr", 289497, 9517},
  {"NDSolve::ndnl", 289774, 9524},
  {"NDSolve::stopt", 290666, 9547},
  {"NDSolve::ibcinc", 291578, 9570},
  {"NDSolve::pdnbc", 292895, 9603},
  {"NDSolve::eerr", 293574, 9620},
  {"DSolve::ndord", 294479, 9643},
  {"NDSolve::ndord", 296022, 9677},
  {"NDSolve`Reinitialize::ndord", 297578, 9711},
  {"NDSolve::ndnum", 299121, 9745},
  {"NDSolve::ndode", 301362, 9802},
  {"NDSolve::bvals", 301641, 9809},
  {"NDSolve::ntdv", 302553, 9832},
  {"NDSolve::bcedge", 303848, 9865},
  {"NDSolve::ndsss", 305405, 9904},
  {"NDSolve::mxst", 306317, 9927},
  {"NDSolve::bcnan", 308067, 9972},
  {"NDSolve::bcsol", 309529, 10009},
  {"NDSolve::depvr", 309807, 10016},
  {"NDSolve::bddo", 310084, 10023},
  {"NDSolve::mxsst", 310756, 10040},
  {"NDSolve::ndmss", 312221, 10077},
  {"NDSolve::bdmtd", 312901, 10094},
  {"NDSolve::ndsz", 313178, 10101},
  {"NDSolve::pdord", 313850, 10118},
  {"NDSolve::precw", 314529, 10135},
  {"NDSolve::acoeffs", 315443, 10158},
  {"NDSolve::sprkdm", 315728, 10165},
  {"NDSolve::sprkqv", 316010, 10172},
  {"NDSolve::sprkpqv", 316293, 10179},
  {"NDSolve::spltdep", 316579, 10186},
  {"NDSolve::spltdim", 316865, 10193},
  {"NDSolve::msols", 317149, 10200},
  {"NDSolve::ndsol", 317430, 10207},
  {"NDSolve::ndsnf", 317711, 10214},
  {"NDSolve::ndspe", 317992, 10221},
  {"NDSolve::nlst", 318272, 10228},
  {"NDSolve::nfun", 318549, 10235},
  {"NDSolve::sfun", 318826, 10242},
  {"NDSolve::csymb", 319104, 10249},
  {"NDSolve::lsb", 319383, 10256},
  {"NDSolve::bdord", 319658, 10263},
  {"NDSolve::nostep", 320977, 10296},
  {"NDSolve::bdstep", 321262, 10303},
  {"NDSolve::bvlin", 322358, 10330},
  {"NDSolve::bvluc", 323045, 10347},
  {"NDSolve::bvls", 323731, 10364},
  {"NDSolve::bvlind", 324010, 10371},
  {"NDSolve::bvaux", 324294, 10378},
  {"NDSolve::bvep", 325386, 10405},
  {"NDSolve::bvcrat", 326067, 10422},
  {"NDSolve::bvdae", 326352, 10429},
  {"NDSolve::cprec", 326633, 10436},
  {"NDSolve::cconst", 326915, 10443},
  {"NDSolve::cdims", 327199, 10450},
  {"NDSolve::cstruct", 327482, 10457},
  {"NDSolve::submtd", 327770, 10464},
  {"NDSolve::uniss", 328546, 10483},
  {"NDSolve::eerri", 329233, 10500},
  {"NDSolve::vdobj", 329920, 10517},
  {"NDSolve::ininv", 330606, 10534},
  {"NDSolve::impsol", 330888, 10541},
  {"NDSolve::maxit", 331172, 10548},
  {"NDSolve::mmpts", 331453, 10555},
  {"NDSolve::dored", 332378, 10578},
  {"NDSolve::nerres", 332660, 10585},
  {"NDSolve::eveerr", 333595, 10608},
  {"NDSolve::stpmin", 333880, 10615},
  {"NDSolve::stpmax", 334576, 10632},
  {"NDSolve::stps", 335270, 10649},
  {"NDSolve::maxits", 335950, 10666},
  {"NDSolve::moptxn", 336235, 10673},
  {"NDSolve::mrsti", 337575, 10706},
  {"NDSolve::msti", 338261, 10723},
  {"NDSolve::ncsm", 338939, 10740},
  {"NDSolve::lsf", 339215, 10747},
  {"NDSolve::ndinnt", 339491, 10754},
  {"NDSolve::ndincd", 340509, 10779},
  {"NDSolve`Reinitialize::ndincd", 341491, 10796},
  {"NDSolve::ndincb", 342460, 10813},
  {"NDSolve::opdims", 342745, 10820},
  {"NDSolve::opmdims", 343031, 10827},
  {"NDSolve`Reinitialize::ndincb", 343332, 10834},
  {"NDSolve::ndncov", 344320, 10855},
  {"NDSolve`Reinitialize::ndncov", 344721, 10862},
  {"NDSolve::ndfdmc", 345109, 10869},
  {"NDSolve::ndrsd", 345804, 10886},
  {"NDSolve::ndsnorm", 346087, 10893},
  {"NDSolve::ndsnr", 346374, 10900},
  {"NDSolve::ndssc", 346655, 10907},
  {"NDSolve::ndstf", 346936, 10914},
  {"NDSolve::ivcon", 347217, 10921},
  {"NDSolve`Reinitialize::ivcon", 348296, 10940},
  {"NDSolve::icord", 349362, 10959},
  {"NDSolve`Reinitialize::icord", 350327, 10976},
  {"NDSolve::icorddae", 351282, 10993},
  {"NDSolve`Reinitialize::icorddae", 352301, 11010},
  {"NDSolve::mdata", 353304, 11027},
  {"NDSolve::tponly", 353586, 11034},
  {"NDSolve::norm", 354280, 11051},
  {"NDSolve::rclist", 354559, 11058},
  {"NDSolve::coend", 355255, 11075},
  {"NDSolve::coexp", 355943, 11092},
  {"NDSolve::ssrei", 356632, 11109},
  {"NDSolve::ssre", 356912, 11116},
  {"NDSolve::sfty", 357189, 11123},
  {"NDSolve::aord", 357466, 11130},
  {"NDSolve::sss", 357742, 11137},
  {"NDSolve::mconly", 358018, 11144},
  {"NDSolve::nolib", 358302, 11151},
  {"NDSolve::nodae", 358583, 11158},
  {"NDSolve::icfail", 359269, 11175},
  {"NDSolve::lsopt", 359962, 11192},
  {"NDSolve::molpde", 360654, 11209},
  {"NDSolve::chbvp", 361349, 11226},
  {"NDSolve::jpde", 362035, 11243},
  {"NDSolve::tvar", 362713, 11260},
  {"NDSolve::tvic", 363391, 11277},
  {"NDSolve::ponly", 364070, 11294},
  {"NDSolve::mdo", 364349, 11301},
  {"NDSolve::mord", 365097, 11320},
  {"NDSolve::imps", 365374, 11327},
  {"NDSolve::lsm", 366130, 11346},
  {"NDSolve::bw", 366876, 11365},
  {"NDSolve::otype", 367616, 11384},
  {"NDSolve::scpar", 368383, 11403},
  {"NDSolve::subsp", 368664, 11410},
  {"NDSolve::ssrb", 369430, 11429},
  {"NDSolve::ssserr", 369709, 11436},
  {"NDSolve::irkcargs", 369996, 11443},
  {"NDSolve::irkcopts", 370289, 11450},
  {"NDSolve::irkcploss", 370583, 11457},
  {"NDSolve`Iterate::sivpd", 370884, 11464},
  {"NDSolve::exseq", 371899, 11487},
  {"NDSolve::exseqev", 372182, 11494},
  {"NDSolve::exmaxo", 372470, 11501},
  {"NDSolve::exmino", 372755, 11508},
  {"NDSolve::exsord", 373040, 11515},
  {"NDSolve::exordf", 373325, 11522},
  {"NDSolve::sssf", 373667, 11529},
  {"NDSolve`FiniteDifferenceDerivative::deriv", 374037, 11536},
  {"NDSolve`FiniteDifferenceDerivative::ldim", 374966, 11553},
  {"NDSolve`FiniteDifferenceDerivative::grid", 375887, 11570},
  {"NDSolve`FiniteDifferenceDerivative::aord", 377232, 11595},
  {"NDSolve`FiniteDifferenceDerivative::per", 378574, 11620},
  {"NDSolve`FiniteDifferenceDerivative::spu", 379486, 11637},
  {"NDSolve`FiniteDifferenceDerivative::spc", 379868, 11644},
  {"NDSolve`FiniteDifferenceDerivative::conw", 380781, 11661},
  {"NDSolve`FiniteDifferenceDerivative::ordred", 381704, 11678},
  {"NDSolve`FiniteDifferenceDerivativeFunction::ddim", 382649, 11695},
  {"NDSolve`FiniteDifferenceDerivativeFunction::spnum", 383643, 11712},
  {"NDSolve::bcuns", 384030, 11719},
  {"NDSolve::dvout", 384955, 11742},
  {"NDSolve::idobj", 385236, 11749},
  {"NDSolve::ivdae", 385517, 11756},
  {"NDSolve::ivres", 386204, 11773},
  {"NDSolve::ndtola", 386486, 11780},
  {"NDSolve::nfnan", 386770, 11787},
  {"NDSolve::nfp", 387535, 11806},
  {"NDSolve::nodv", 387809, 11813},
  {"NDSolve::noout", 388722, 11836},
  {"NDSolve::pdeopt", 389004, 11843},
  {"NDSolve`ProcessSolutions::nodata", 389306, 11850},
  {"NDSolve`ScaledVectorNorm::fnnan", 389659, 11857},
  {"NDSolve`ScaledVectorNorm::nfp", 390007, 11864},
  {"NDSolve`ScaledVectorNorm::nvec", 390350, 11871},
  {"NDSolve`ScaledVectorNorm::pinp", 390696, 11878},
  {"NDSolve`ScaledVectorNorm::sinp", 391042, 11885},
  {"NDSolve`ScaledVectorNorm::tinp", 391388, 11892},
  {"NDSolve::urange", 391719, 11899},
  {"NDSolve`ScaledVectorNorm::urange", 392136, 11906},
  {"NDSolve::eord", 392534, 11913},
  {"NDSolve::ndstab", 392813, 11920},
  {"NDSolve::maxsts", 393098, 11927},
  {"NDSolve::mtdp", 393381, 11934}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 24, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1825, 57, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndtol"],
Cell[1909, 60, 242, 5, 37, "Message",
  CellTags->"NDSolve::ndtol"],
Cell[2154, 67, 241, 5, 40, "Notes",
  CellTags->"NDSolve::ndtol"],

Cell[CellGroupData[{
Cell[2420, 76, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::ndtol"],
Cell[2487, 79, 204, 5, 40, "Text",
  CellTags->"NDSolve::ndtol"],

Cell[CellGroupData[{
Cell[2716, 88, 231, 5, 42, "Input",
  CellTags->"NDSolve::ndtol"],
Cell[2950, 95, 251, 5, 37, "Message",
  CellTags->"NDSolve::ndtol"],
Cell[3204, 102, 278, 8, 21, "Output",
  CellTags->"NDSolve::ndtol"]
}, Open  ]],
Cell[3497, 113, 238, 6, 40, "Text",
  CellTags->"NDSolve::ndtol"],

Cell[CellGroupData[{
Cell[3760, 123, 260, 5, 42, "Input",
  CellTags->"NDSolve::ndtol"],
Cell[4023, 130, 280, 8, 37, "Output",
  CellTags->"NDSolve::ndtol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4364, 145, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ivone"],
Cell[4448, 148, 293, 6, 53, "Message",
  CellTags->"NDSolve::ivone"],
Cell[4744, 156, 390, 8, 62, "Notes",
  CellTags->"NDSolve::ivone"],

Cell[CellGroupData[{
Cell[5159, 168, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::ivone"],
Cell[5226, 171, 177, 4, 24, "Text",
  CellTags->"NDSolve::ivone"],

Cell[CellGroupData[{
Cell[5428, 179, 295, 6, 58, "Input",
  CellTags->"NDSolve::ivone"],
Cell[5726, 187, 292, 6, 53, "Message",
  CellTags->"NDSolve::ivone"]
}, Open  ]],
Cell[6033, 196, 167, 4, 24, "Text",
  CellTags->"NDSolve::ivone"],

Cell[CellGroupData[{
Cell[6225, 204, 249, 5, 42, "Input",
  CellTags->"NDSolve::ivone"],
Cell[6477, 211, 292, 6, 53, "Message",
  CellTags->"NDSolve::ivone"],
Cell[6772, 219, 756, 21, 23, "Output",
  CellTags->"NDSolve::ivone"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7589, 247, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bcnorm"],
Cell[7675, 250, 196, 5, 21, "Message",
  CellTags->"NDSolve::bcnorm"],
Cell[7874, 257, 362, 8, 78, "Notes",
  CellTags->"NDSolve::bcnorm"],

Cell[CellGroupData[{
Cell[8261, 269, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bcnorm"],
Cell[8329, 272, 226, 5, 40, "Text",
  CellTags->"NDSolve::bcnorm"],

Cell[CellGroupData[{
Cell[8580, 281, 543, 11, 74, "Input",
  CellTags->"NDSolve::bcnorm"],
Cell[9126, 294, 413, 7, 54, "Message",
  CellTags->"NDSolve::bcnorm"],
Cell[9542, 303, 1611, 39, 88, "Output",
  CellTags->"NDSolve::bcnorm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11214, 349, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndlim"],
Cell[11298, 352, 362, 9, 37, "Message",
  CellTags->"NDSolve::ndlim"],
Cell[11663, 363, 438, 9, 62, "Notes",
  CellTags->"NDSolve::ndlim"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12138, 377, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndcf"],
Cell[12220, 380, 440, 12, 21, "Message",
  CellTags->"NDSolve::ndcf"],
Cell[12663, 394, 428, 8, 78, "Notes",
  CellTags->"NDSolve::ndcf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13128, 407, 159, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
Cell[13290, 414, 344, 9, 21, "Message",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
Cell[13637, 425, 442, 8, 78, "Notes",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],

Cell[CellGroupData[{
Cell[14104, 437, 103, 1, 38, "ExampleSection",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
Cell[14210, 440, 260, 5, 40, "Text",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],

Cell[CellGroupData[{
Cell[14495, 449, 258, 4, 42, "Input",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
Cell[14756, 455, 221, 4, 21, "Message",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
Cell[14980, 461, 853, 21, 39, "Output",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}]
}, Open  ]],
Cell[15848, 485, 167, 4, 24, "Text",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],

Cell[CellGroupData[{
Cell[16040, 493, 258, 4, 42, "Input",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}],
Cell[16301, 499, 329, 8, 21, "Output",
  CellTags->{"DSolve::conarg", "NDSolve::conarg", "RSolve::conarg"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[16691, 514, 150, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
Cell[16844, 520, 685, 17, 37, "Message",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
Cell[17532, 539, 274, 5, 40, "Notes",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],

Cell[CellGroupData[{
Cell[17831, 548, 97, 1, 38, "ExampleSection",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
Cell[17931, 551, 200, 4, 24, "Text",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],

Cell[CellGroupData[{
Cell[18156, 559, 178, 3, 26, "Input",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
Cell[18337, 564, 297, 5, 53, "Message",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
Cell[18637, 571, 479, 12, 21, "Output",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}]
}, Open  ]],
Cell[19131, 586, 174, 4, 24, "Text",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],

Cell[CellGroupData[{
Cell[19330, 594, 201, 4, 26, "Input",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}],
Cell[19534, 600, 311, 8, 21, "Output",
  CellTags->{"NDSolve::ndnco", "NDSolve`Reinitialize::ndnco"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[19906, 615, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ntcs"],
Cell[19988, 618, 177, 3, 21, "Message",
  CellTags->"NDSolve::ntcs"],
Cell[20168, 623, 463, 9, 62, "Notes",
  CellTags->"NDSolve::ntcs"],

Cell[CellGroupData[{
Cell[20656, 636, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::ntcs"],
Cell[20722, 639, 135, 4, 24, "Text",
  CellTags->"NDSolve::ntcs"],

Cell[CellGroupData[{
Cell[20882, 647, 185, 4, 42, "Input",
  CellTags->"NDSolve::ntcs"],
Cell[21070, 653, 193, 5, 21, "Message",
  CellTags->"NDSolve::ntcs"],
Cell[21266, 660, 681, 18, 21, "Output",
  CellTags->"NDSolve::ntcs"]
}, Open  ]],
Cell[21962, 681, 142, 4, 24, "Text",
  CellTags->"NDSolve::ntcs"],

Cell[CellGroupData[{
Cell[22129, 689, 185, 4, 42, "Input",
  CellTags->"NDSolve::ntcs"],
Cell[22317, 695, 466, 13, 37, "Output",
  CellTags->"NDSolve::ntcs"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22844, 715, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bcart"],
Cell[22928, 718, 322, 6, 69, "Message",
  CellTags->"NDSolve::bcart"],
Cell[23253, 726, 206, 5, 40, "Notes",
  CellTags->"NDSolve::bcart"],

Cell[CellGroupData[{
Cell[23484, 735, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bcart"],
Cell[23551, 738, 159, 4, 24, "Text",
  CellTags->"NDSolve::bcart"],

Cell[CellGroupData[{
Cell[23735, 746, 209, 4, 42, "Input",
  CellTags->"NDSolve::bcart"],
Cell[23947, 752, 325, 6, 69, "Message",
  CellTags->"NDSolve::bcart"],
Cell[24275, 760, 290, 8, 21, "Output",
  CellTags->"NDSolve::bcart"]
}, Open  ]],
Cell[24580, 771, 120, 4, 24, "Text",
  CellTags->"NDSolve::bcart"],

Cell[CellGroupData[{
Cell[24725, 779, 230, 5, 42, "Input",
  CellTags->"NDSolve::bcart"],
Cell[24958, 786, 290, 8, 21, "Output",
  CellTags->"NDSolve::bcart"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[25309, 801, 146, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NDSolve::ndsv", "NDSolve`Reinitialize::ndsv"}],
Cell[25458, 807, 433, 12, 21, "Message",
  CellTags->{"NDSolve::ndsv", "NDSolve`Reinitialize::ndsv"}],
Cell[25894, 821, 386, 7, 62, "Notes",
  CellTags->{"NDSolve::ndsv", "NDSolve`Reinitialize::ndsv"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[26317, 833, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::nderr"],
Cell[26401, 836, 432, 12, 21, "Message",
  CellTags->"NDSolve::nderr"],
Cell[26836, 850, 461, 10, 100, "Notes",
  CellTags->"NDSolve::nderr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27334, 865, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndnl"],
Cell[27416, 868, 352, 11, 21, "Message",
  CellTags->"NDSolve::ndnl"],
Cell[27771, 881, 166, 4, 24, "Notes",
  CellTags->"NDSolve::ndnl"],

Cell[CellGroupData[{
Cell[27962, 889, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::ndnl"],
Cell[28028, 892, 153, 4, 24, "Text",
  CellTags->"NDSolve::ndnl"],

Cell[CellGroupData[{
Cell[28206, 900, 141, 3, 26, "Input",
  CellTags->"NDSolve::ndnl"],
Cell[28350, 905, 196, 5, 21, "Message",
  CellTags->"NDSolve::ndnl"],
Cell[28549, 912, 439, 12, 21, "Output",
  CellTags->"NDSolve::ndnl"]
}, Open  ]],
Cell[29003, 927, 120, 4, 24, "Text",
  CellTags->"NDSolve::ndnl"],

Cell[CellGroupData[{
Cell[29148, 935, 173, 4, 42, "Input",
  CellTags->"NDSolve::ndnl"],
Cell[29324, 941, 277, 8, 21, "Output",
  CellTags->"NDSolve::ndnl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[29662, 956, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::stopt"],
Cell[29746, 959, 553, 14, 37, "Message",
  CellTags->"NDSolve::stopt"],
Cell[30302, 975, 573, 16, 78, "Notes",
  CellTags->"NDSolve::stopt"],

Cell[CellGroupData[{
Cell[30900, 995, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::stopt"],
Cell[30967, 998, 180, 5, 24, "Text",
  CellTags->"NDSolve::stopt"],

Cell[CellGroupData[{
Cell[31172, 1007, 221, 5, 42, "Input",
  CellTags->"NDSolve::stopt"],
Cell[31396, 1014, 279, 6, 53, "Message",
  CellTags->"NDSolve::stopt"],
Cell[31678, 1022, 320, 10, 21, "Output",
  CellTags->"NDSolve::stopt"]
}, Open  ]],
Cell[32013, 1035, 143, 5, 24, "Text",
  CellTags->"NDSolve::stopt"],

Cell[CellGroupData[{
Cell[32181, 1044, 204, 4, 42, "Input",
  CellTags->"NDSolve::stopt"],
Cell[32388, 1050, 317, 10, 21, "Output",
  CellTags->"NDSolve::stopt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32766, 1067, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ibcinc"],
Cell[32852, 1070, 193, 4, 21, "Message",
  CellTags->"NDSolve::ibcinc"],
Cell[33048, 1076, 732, 13, 132, "Notes",
  CellTags->"NDSolve::ibcinc"],

Cell[CellGroupData[{
Cell[33805, 1093, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::ibcinc"],
Cell[33873, 1096, 346, 7, 56, "Text",
  CellTags->"NDSolve::ibcinc"],

Cell[CellGroupData[{
Cell[34244, 1107, 270, 5, 58, "Input",
  CellTags->"NDSolve::ibcinc"],
Cell[34517, 1114, 198, 5, 37, "Message",
  CellTags->"NDSolve::ibcinc"],
Cell[34718, 1121, 292, 8, 21, "Output",
  CellTags->"NDSolve::ibcinc"]
}, Open  ]],
Cell[35025, 1132, 221, 5, 40, "Text",
  CellTags->"NDSolve::ibcinc"],

Cell[CellGroupData[{
Cell[35271, 1141, 314, 7, 74, "Input",
  CellTags->"NDSolve::ibcinc"],
Cell[35588, 1150, 292, 8, 21, "Output",
  CellTags->"NDSolve::ibcinc"]
}, Open  ]],
Cell[35895, 1161, 81, 1, 24, "Text",
  CellTags->"NDSolve::ibcinc"],

Cell[CellGroupData[{
Cell[36001, 1166, 160, 4, 26, "Input",
  CellTags->"NDSolve::ibcinc"],
Cell[36164, 1172, 192, 5, 21, "Output",
  CellTags->"NDSolve::ibcinc"]
}, Open  ]],
Cell[36371, 1180, 114, 5, 24, "Text",
  CellTags->"NDSolve::ibcinc"],
Cell[36488, 1187, 98, 3, 26, "Input",
  CellTags->"NDSolve::ibcinc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36635, 1196, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::pdnbc"],
Cell[36719, 1199, 207, 5, 37, "Message",
  CellTags->"NDSolve::pdnbc"],
Cell[36929, 1206, 244, 5, 40, "Notes",
  CellTags->"NDSolve::pdnbc"],

Cell[CellGroupData[{
Cell[37198, 1215, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::pdnbc"],
Cell[37265, 1218, 190, 5, 40, "Text",
  CellTags->"NDSolve::pdnbc"],

Cell[CellGroupData[{
Cell[37480, 1227, 324, 6, 58, "Input",
  CellTags->"NDSolve::pdnbc"],
Cell[37807, 1235, 207, 5, 37, "Message",
  CellTags->"NDSolve::pdnbc"],
Cell[38017, 1242, 1072, 28, 41, "Output",
  CellTags->"NDSolve::pdnbc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[39150, 1277, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::eerr"],
Cell[39232, 1280, 1421, 30, 85, "Message",
  CellTags->"NDSolve::eerr"],
Cell[40656, 1312, 513, 12, 78, "Notes",
  CellTags->"NDSolve::eerr"],

Cell[CellGroupData[{
Cell[41194, 1328, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::eerr"],
Cell[41260, 1331, 221, 5, 40, "Text",
  CellTags->"NDSolve::eerr"],

Cell[CellGroupData[{
Cell[41506, 1340, 342, 7, 74, "Input",
  CellTags->"NDSolve::eerr"],
Cell[41851, 1349, 562, 10, 117, "Message",
  CellTags->"NDSolve::eerr"],
Cell[42416, 1361, 289, 8, 21, "Output",
  CellTags->"NDSolve::eerr"]
}, Open  ]],
Cell[42720, 1372, 199, 5, 24, "Text",
  CellTags->"NDSolve::eerr"],

Cell[CellGroupData[{
Cell[42944, 1381, 376, 8, 74, "Input",
  CellTags->"NDSolve::eerr"],
Cell[43323, 1391, 289, 8, 21, "Output",
  CellTags->"NDSolve::eerr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[43673, 1406, 184, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
Cell[43860, 1414, 595, 16, 37, "Message",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
Cell[44458, 1432, 219, 5, 24, "Notes",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],

Cell[CellGroupData[{
Cell[44702, 1441, 117, 2, 38, "ExampleSection",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
Cell[44822, 1445, 230, 6, 24, "Text",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],

Cell[CellGroupData[{
Cell[45077, 1455, 218, 5, 26, "Input",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
Cell[45298, 1462, 406, 7, 39, "Message",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
Cell[45707, 1471, 547, 15, 23, "Output",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}]
}, Open  ]],
Cell[46269, 1489, 216, 6, 24, "Text",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],

Cell[CellGroupData[{
Cell[46510, 1499, 218, 5, 26, "Input",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}],
Cell[46731, 1506, 331, 9, 21, "Output",
  CellTags->{
  "DSolve::ndord", "NDSolve::ndord", "NDSolve`Reinitialize::ndord"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47123, 1522, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndnum"],
Cell[47207, 1525, 481, 14, 21, "Message",
  CellTags->"NDSolve::ndnum"],
Cell[47691, 1541, 794, 14, 122, "Notes",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{
Cell[48510, 1559, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::ndnum"],
Cell[48577, 1562, 173, 4, 40, "Text",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{
Cell[48775, 1570, 143, 3, 26, "Input",
  CellTags->"NDSolve::ndnum"],
Cell[48921, 1575, 211, 5, 37, "Message",
  CellTags->"NDSolve::ndnum"],
Cell[49135, 1582, 441, 12, 21, "Output",
  CellTags->"NDSolve::ndnum"]
}, Open  ]],
Cell[49591, 1597, 140, 4, 24, "Text",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{
Cell[49756, 1605, 188, 5, 42, "Input",
  CellTags->"NDSolve::ndnum"],
Cell[49947, 1612, 278, 8, 21, "Output",
  CellTags->"NDSolve::ndnum"]
}, Open  ]],
Cell[50240, 1623, 104, 1, 24, "Text",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{
Cell[50369, 1628, 134, 3, 26, "Input",
  CellTags->"NDSolve::ndnum"],
Cell[50506, 1633, 184, 5, 21, "Output",
  CellTags->"NDSolve::ndnum"]
}, Open  ]],
Cell[50705, 1641, 113, 5, 24, "Text",
  CellTags->"NDSolve::ndnum"],
Cell[50821, 1648, 97, 3, 26, "Input",
  CellTags->"NDSolve::ndnum"],
Cell[50921, 1653, 148, 4, 24, "Text",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{
Cell[51094, 1661, 276, 6, 42, "Input",
  CellTags->"NDSolve::ndnum"],
Cell[51373, 1669, 211, 5, 37, "Message",
  CellTags->"NDSolve::ndnum"],
Cell[51587, 1676, 809, 21, 39, "Output",
  CellTags->"NDSolve::ndnum"]
}, Open  ]],
Cell[52411, 1700, 120, 4, 24, "Text",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{
Cell[52556, 1708, 297, 7, 58, "Input",
  CellTags->"NDSolve::ndnum"],
Cell[52856, 1717, 290, 8, 21, "Output",
  CellTags->"NDSolve::ndnum"]
}, Open  ]],
Cell[53161, 1728, 104, 1, 24, "Text",
  CellTags->"NDSolve::ndnum"],

Cell[CellGroupData[{
Cell[53290, 1733, 179, 4, 42, "Input",
  CellTags->"NDSolve::ndnum"],
Cell[53472, 1739, 191, 5, 21, "Output",
  CellTags->"NDSolve::ndnum"]
}, Open  ]],
Cell[53678, 1747, 113, 5, 24, "Text",
  CellTags->"NDSolve::ndnum"],
Cell[53794, 1754, 97, 3, 26, "Input",
  CellTags->"NDSolve::ndnum"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[53940, 1763, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndode"],
Cell[54024, 1766, 169, 3, 21, "Message",
  CellTags->"NDSolve::ndode"],
Cell[54196, 1771, 475, 10, 78, "Notes",
  CellTags->"NDSolve::ndode"]
}, Open  ]],

Cell[CellGroupData[{
Cell[54708, 1786, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvals"],
Cell[54792, 1789, 187, 3, 21, "Message",
  CellTags->"NDSolve::bvals"],
Cell[54982, 1794, 331, 7, 62, "Notes",
  CellTags->"NDSolve::bvals"],

Cell[CellGroupData[{
Cell[55338, 1805, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bvals"],
Cell[55405, 1808, 203, 5, 40, "Text",
  CellTags->"NDSolve::bvals"],

Cell[CellGroupData[{
Cell[55633, 1817, 170, 4, 26, "Input",
  CellTags->"NDSolve::bvals"],
Cell[55806, 1823, 199, 5, 37, "Message",
  CellTags->"NDSolve::bvals"],
Cell[56008, 1830, 518, 13, 21, "Output",
  CellTags->"NDSolve::bvals"]
}, Open  ]],
Cell[56541, 1846, 117, 4, 24, "Text",
  CellTags->"NDSolve::bvals"],

Cell[CellGroupData[{
Cell[56683, 1854, 167, 4, 26, "Input",
  CellTags->"NDSolve::bvals"],
Cell[56853, 1860, 278, 8, 21, "Output",
  CellTags->"NDSolve::bvals"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[57192, 1875, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ntdv"],
Cell[57274, 1878, 253, 5, 53, "Message",
  CellTags->"NDSolve::ntdv"],
Cell[57530, 1885, 727, 17, 122, "Notes",
  CellTags->"NDSolve::ntdv"],

Cell[CellGroupData[{
Cell[58282, 1906, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::ntdv"],
Cell[58348, 1909, 234, 7, 40, "Text",
  CellTags->"NDSolve::ntdv"],

Cell[CellGroupData[{
Cell[58607, 1920, 154, 4, 26, "Input",
  CellTags->"NDSolve::ntdv"],
Cell[58764, 1926, 252, 5, 53, "Message",
  CellTags->"NDSolve::ntdv"],
Cell[59019, 1933, 465, 13, 26, "Output",
  CellTags->"NDSolve::ntdv"]
}, Open  ]],
Cell[59499, 1949, 169, 4, 24, "Text",
  CellTags->"NDSolve::ntdv"],

Cell[CellGroupData[{
Cell[59693, 1957, 156, 4, 26, "Input",
  CellTags->"NDSolve::ntdv"],
Cell[59852, 1963, 233, 5, 37, "Message",
  CellTags->"NDSolve::ntdv"],
Cell[60088, 1970, 252, 5, 37, "Message",
  CellTags->"NDSolve::ntdv"],
Cell[60343, 1977, 604, 16, 21, "Output",
  CellTags->"NDSolve::ntdv"]
}, Open  ]],
Cell[60962, 1996, 210, 6, 24, "Text",
  CellTags->"NDSolve::ntdv"],

Cell[CellGroupData[{
Cell[61197, 2006, 247, 6, 42, "Input",
  CellTags->"NDSolve::ntdv"],
Cell[61447, 2014, 277, 8, 21, "Output",
  CellTags->"NDSolve::ntdv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[61785, 2029, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bcedge"],
Cell[61871, 2032, 465, 10, 37, "Message",
  CellTags->"NDSolve::bcedge"],
Cell[62339, 2044, 267, 5, 40, "Notes",
  CellTags->"NDSolve::bcedge"],

Cell[CellGroupData[{
Cell[62631, 2053, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bcedge"],
Cell[62699, 2056, 177, 4, 24, "Text",
  CellTags->"NDSolve::bcedge"],

Cell[CellGroupData[{
Cell[62901, 2064, 260, 5, 42, "Input",
  CellTags->"NDSolve::bcedge"],
Cell[63164, 2071, 280, 6, 37, "Message",
  CellTags->"NDSolve::bcedge"],
Cell[63447, 2079, 800, 21, 39, "Output",
  CellTags->"NDSolve::bcedge"]
}, Open  ]],
Cell[64262, 2103, 142, 4, 24, "Text",
  CellTags->"NDSolve::bcedge"],

Cell[CellGroupData[{
Cell[64429, 2111, 260, 5, 42, "Input",
  CellTags->"NDSolve::bcedge"],
Cell[64692, 2118, 291, 8, 21, "Output",
  CellTags->"NDSolve::bcedge"]
}, Open  ]],
Cell[64998, 2129, 169, 5, 24, "Text",
  CellTags->"NDSolve::bcedge"],

Cell[CellGroupData[{
Cell[65192, 2138, 388, 8, 58, "Input",
  CellTags->"NDSolve::bcedge"],
Cell[65583, 2148, 280, 6, 37, "Message",
  CellTags->"NDSolve::bcedge"]
}, Open  ]],
Cell[65878, 2157, 252, 6, 40, "Text",
  CellTags->"NDSolve::bcedge"],
Cell[66133, 2165, 374, 8, 58, "Input",
  CellTags->"NDSolve::bcedge"],
Cell[66510, 2175, 191, 5, 40, "Text",
  CellTags->"NDSolve::bcedge"],

Cell[CellGroupData[{
Cell[66726, 2184, 158, 4, 26, "Input",
  CellTags->"NDSolve::bcedge"],
Cell[66887, 2190, 192, 5, 21, "Output",
  CellTags->"NDSolve::bcedge"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[67140, 2202, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndsss"],
Cell[67224, 2205, 296, 6, 37, "Message",
  CellTags->"NDSolve::ndsss"],
Cell[67523, 2213, 200, 5, 24, "Notes",
  CellTags->"NDSolve::ndsss"],

Cell[CellGroupData[{
Cell[67748, 2222, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::ndsss"],
Cell[67815, 2225, 150, 5, 24, "Text",
  CellTags->"NDSolve::ndsss"],

Cell[CellGroupData[{
Cell[67990, 2234, 170, 4, 26, "Input",
  CellTags->"NDSolve::ndsss"],
Cell[68163, 2240, 225, 5, 37, "Message",
  CellTags->"NDSolve::ndsss"],
Cell[68391, 2247, 482, 13, 21, "Output",
  CellTags->"NDSolve::ndsss"]
}, Open  ]],
Cell[68888, 2263, 147, 5, 24, "Text",
  CellTags->"NDSolve::ndsss"],

Cell[CellGroupData[{
Cell[69060, 2272, 172, 4, 26, "Input",
  CellTags->"NDSolve::ndsss"],
Cell[69235, 2278, 278, 8, 21, "Output",
  CellTags->"NDSolve::ndsss"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[69574, 2293, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::mxst"],
Cell[69656, 2296, 469, 14, 21, "Message",
  CellTags->"NDSolve::mxst"],
Cell[70128, 2312, 774, 16, 116, "Notes",
  CellTags->"NDSolve::mxst"],

Cell[CellGroupData[{
Cell[70927, 2332, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::mxst"],
Cell[70993, 2335, 161, 4, 24, "Text",
  CellTags->"NDSolve::mxst"],

Cell[CellGroupData[{
Cell[71179, 2343, 189, 4, 42, "Input",
  CellTags->"NDSolve::mxst"],
Cell[71371, 2349, 227, 5, 37, "Message",
  CellTags->"NDSolve::mxst"],
Cell[71601, 2356, 316, 10, 21, "Output",
  CellTags->"NDSolve::mxst"]
}, Open  ]],
Cell[71932, 2369, 105, 1, 24, "Text",
  CellTags->"NDSolve::mxst"],

Cell[CellGroupData[{
Cell[72062, 2374, 204, 5, 42, "Input",
  CellTags->"NDSolve::mxst"],
Cell[72269, 2381, 278, 8, 21, "Output",
  CellTags->"NDSolve::mxst"]
}, Open  ]],
Cell[72562, 2392, 129, 4, 24, "Text",
  CellTags->"NDSolve::mxst"],

Cell[CellGroupData[{
Cell[72716, 2400, 125, 3, 26, "Input",
  CellTags->"NDSolve::mxst"],
Cell[72844, 2405, 183, 5, 21, "Output",
  CellTags->"NDSolve::mxst"]
}, Open  ]],
Cell[73042, 2413, 228, 5, 40, "Text",
  CellTags->"NDSolve::mxst"],

Cell[CellGroupData[{
Cell[73295, 2422, 223, 5, 42, "Input",
  CellTags->"NDSolve::mxst"],
Cell[73521, 2429, 278, 8, 21, "Output",
  CellTags->"NDSolve::mxst"]
}, Open  ]],
Cell[73814, 2440, 125, 4, 24, "Text",
  CellTags->"NDSolve::mxst"],

Cell[CellGroupData[{
Cell[73964, 2448, 125, 3, 26, "Input",
  CellTags->"NDSolve::mxst"],
Cell[74092, 2453, 183, 5, 21, "Output",
  CellTags->"NDSolve::mxst"]
}, Open  ]],
Cell[74290, 2461, 112, 5, 24, "Text",
  CellTags->"NDSolve::mxst"],
Cell[74405, 2468, 96, 3, 26, "Input",
  CellTags->"NDSolve::mxst"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[74550, 2477, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bcnan"],
Cell[74634, 2480, 206, 5, 21, "Message",
  CellTags->"NDSolve::bcnan"],
Cell[74843, 2487, 172, 4, 24, "Notes",
  CellTags->"NDSolve::bcnan"],

Cell[CellGroupData[{
Cell[75040, 2495, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bcnan"],
Cell[75107, 2498, 183, 4, 40, "Text",
  CellTags->"NDSolve::bcnan"],

Cell[CellGroupData[{
Cell[75315, 2506, 167, 4, 26, "Input",
  CellTags->"NDSolve::bcnan"],
Cell[75485, 2512, 170, 4, 21, "Message",
  CellTags->"NDSolve::bcnan"],
Cell[75658, 2518, 515, 13, 21, "Output",
  CellTags->"NDSolve::bcnan"]
}, Open  ]],
Cell[76188, 2534, 117, 4, 24, "Text",
  CellTags->"NDSolve::bcnan"],

Cell[CellGroupData[{
Cell[76330, 2542, 167, 4, 26, "Input",
  CellTags->"NDSolve::bcnan"],
Cell[76500, 2548, 278, 8, 21, "Output",
  CellTags->"NDSolve::bcnan"]
}, Open  ]],
Cell[76793, 2559, 174, 4, 40, "Text",
  CellTags->"NDSolve::bcnan"],

Cell[CellGroupData[{
Cell[76992, 2567, 170, 4, 26, "Input",
  CellTags->"NDSolve::bcnan"],
Cell[77165, 2573, 170, 4, 21, "Message",
  CellTags->"NDSolve::bcnan"],
Cell[77338, 2579, 518, 13, 21, "Output",
  CellTags->"NDSolve::bcnan"]
}, Open  ]],
Cell[77871, 2595, 133, 4, 24, "Text",
  CellTags->"NDSolve::bcnan"],

Cell[CellGroupData[{
Cell[78029, 2603, 195, 5, 42, "Input",
  CellTags->"NDSolve::bcnan"],
Cell[78227, 2610, 278, 8, 21, "Output",
  CellTags->"NDSolve::bcnan"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[78566, 2625, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bcsol"],
Cell[78650, 2628, 217, 5, 37, "Message",
  CellTags->"NDSolve::bcsol"],
Cell[78870, 2635, 226, 5, 40, "Notes",
  CellTags->"NDSolve::bcsol"]
}, Open  ]],

Cell[CellGroupData[{
Cell[79133, 2645, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::depvr"],
Cell[79217, 2648, 179, 3, 21, "Message",
  CellTags->"NDSolve::depvr"],
Cell[79399, 2653, 325, 7, 62, "Notes",
  CellTags->"NDSolve::depvr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[79761, 2665, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bddo"],
Cell[79843, 2668, 225, 5, 37, "Message",
  CellTags->"NDSolve::bddo"],
Cell[80071, 2675, 455, 13, 62, "Notes",
  CellTags->"NDSolve::bddo"],

Cell[CellGroupData[{
Cell[80551, 2692, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bddo"],
Cell[80617, 2695, 214, 7, 24, "Text",
  CellTags->"NDSolve::bddo"],

Cell[CellGroupData[{
Cell[80856, 2706, 424, 8, 74, "Input",
  CellTags->"NDSolve::bddo"],
Cell[81283, 2716, 231, 5, 37, "Message",
  CellTags->"NDSolve::bddo"],
Cell[81517, 2723, 980, 24, 71, "Output",
  CellTags->"NDSolve::bddo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[82558, 2754, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::mxsst"],
Cell[82642, 2757, 256, 5, 53, "Message",
  CellTags->"NDSolve::mxsst"],
Cell[82901, 2764, 571, 12, 78, "Notes",
  CellTags->"NDSolve::mxsst"],

Cell[CellGroupData[{
Cell[83497, 2780, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::mxsst"],
Cell[83564, 2783, 283, 7, 40, "Text",
  CellTags->"NDSolve::mxsst"],

Cell[CellGroupData[{
Cell[83872, 2794, 308, 6, 58, "Input",
  CellTags->"NDSolve::mxsst"],
Cell[84183, 2802, 264, 5, 53, "Message",
  CellTags->"NDSolve::mxsst"],
Cell[84450, 2809, 339, 10, 21, "Output",
  CellTags->"NDSolve::mxsst"]
}, Open  ]],
Cell[84804, 2822, 181, 6, 24, "Text",
  CellTags->"NDSolve::mxsst"],

Cell[CellGroupData[{
Cell[85010, 2832, 271, 6, 42, "Input",
  CellTags->"NDSolve::mxsst"],
Cell[85284, 2840, 339, 10, 21, "Output",
  CellTags->"NDSolve::mxsst"]
}, Open  ]],
Cell[85638, 2853, 283, 7, 40, "Text",
  CellTags->"NDSolve::mxsst"],

Cell[CellGroupData[{
Cell[85946, 2864, 402, 7, 74, "Input",
  CellTags->"NDSolve::mxsst"],
Cell[86351, 2873, 264, 5, 53, "Message",
  CellTags->"NDSolve::mxsst"],
Cell[86618, 2880, 339, 10, 21, "Output",
  CellTags->"NDSolve::mxsst"]
}, Open  ]],
Cell[86972, 2893, 181, 6, 24, "Text",
  CellTags->"NDSolve::mxsst"],

Cell[CellGroupData[{
Cell[87178, 2903, 378, 7, 74, "Input",
  CellTags->"NDSolve::mxsst"],
Cell[87559, 2912, 339, 10, 21, "Output",
  CellTags->"NDSolve::mxsst"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[87959, 2929, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndmss"],
Cell[88043, 2932, 478, 13, 21, "Message",
  CellTags->"NDSolve::ndmss"],
Cell[88524, 2947, 196, 5, 24, "Notes",
  CellTags->"NDSolve::ndmss"],

Cell[CellGroupData[{
Cell[88745, 2956, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::ndmss"],
Cell[88812, 2959, 181, 5, 24, "Text",
  CellTags->"NDSolve::ndmss"],

Cell[CellGroupData[{
Cell[89018, 2968, 166, 4, 26, "Input",
  CellTags->"NDSolve::ndmss"],
Cell[89187, 2974, 227, 5, 37, "Message",
  CellTags->"NDSolve::ndmss"],
Cell[89417, 2981, 478, 13, 21, "Output",
  CellTags->"NDSolve::ndmss"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[89956, 3001, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bdmtd"],
Cell[90040, 3004, 305, 6, 69, "Message",
  CellTags->"NDSolve::bdmtd"],
Cell[90348, 3012, 125, 4, 24, "Notes",
  CellTags->"NDSolve::bdmtd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[90510, 3021, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndsz"],
Cell[90592, 3024, 438, 11, 37, "Message",
  CellTags->"NDSolve::ndsz"],
Cell[91033, 3037, 244, 6, 40, "Notes",
  CellTags->"NDSolve::ndsz"],

Cell[CellGroupData[{
Cell[91302, 3047, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::ndsz"],
Cell[91368, 3050, 120, 4, 24, "Text",
  CellTags->"NDSolve::ndsz"],

Cell[CellGroupData[{
Cell[91513, 3058, 161, 4, 26, "Input",
  CellTags->"NDSolve::ndsz"],
Cell[91677, 3064, 246, 5, 37, "Message",
  CellTags->"NDSolve::ndsz"],
Cell[91926, 3071, 319, 10, 21, "Output",
  CellTags->"NDSolve::ndsz"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[92306, 3088, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::pdord"],
Cell[92390, 3091, 270, 4, 53, "Message",
  CellTags->"NDSolve::pdord"],
Cell[92663, 3097, 325, 8, 62, "Notes",
  CellTags->"NDSolve::pdord"],

Cell[CellGroupData[{
Cell[93013, 3109, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::pdord"],
Cell[93080, 3112, 189, 6, 24, "Text",
  CellTags->"NDSolve::pdord"],

Cell[CellGroupData[{
Cell[93294, 3122, 218, 4, 26, "Input",
  CellTags->"NDSolve::pdord"],
Cell[93515, 3128, 271, 6, 53, "Message",
  CellTags->"NDSolve::pdord"],
Cell[93789, 3136, 467, 13, 37, "Output",
  CellTags->"NDSolve::pdord"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[94317, 3156, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::precw"],
Cell[94401, 3159, 218, 4, 37, "Message",
  CellTags->"NDSolve::precw"],
Cell[94622, 3165, 250, 6, 40, "Notes",
  CellTags->"NDSolve::precw"],

Cell[CellGroupData[{
Cell[94897, 3175, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::precw"],
Cell[94964, 3178, 245, 6, 40, "Text",
  CellTags->"NDSolve::precw"],

Cell[CellGroupData[{
Cell[95234, 3188, 193, 4, 26, "Input",
  CellTags->"NDSolve::precw"],
Cell[95430, 3194, 466, 8, 37, "Message",
  CellTags->"NDSolve::precw"],
Cell[95899, 3204, 286, 8, 53, "Output",
  CellTags->"NDSolve::precw"]
}, Open  ]],
Cell[96200, 3215, 168, 4, 24, "Text",
  CellTags->"NDSolve::precw"],

Cell[CellGroupData[{
Cell[96393, 3223, 234, 5, 42, "Input",
  CellTags->"NDSolve::precw"],
Cell[96630, 3230, 286, 8, 53, "Output",
  CellTags->"NDSolve::precw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[96977, 3245, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::acoeffs"],
Cell[97065, 3248, 266, 5, 37, "Message",
  CellTags->"NDSolve::acoeffs"],
Cell[97334, 3255, 127, 4, 24, "Notes",
  CellTags->"NDSolve::acoeffs"]
}, Open  ]],

Cell[CellGroupData[{
Cell[97498, 3264, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::sprkdm"],
Cell[97584, 3267, 208, 4, 37, "Message",
  CellTags->"NDSolve::sprkdm"],
Cell[97795, 3273, 126, 4, 24, "Notes",
  CellTags->"NDSolve::sprkdm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[97958, 3282, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::sprkqv"],
Cell[98044, 3285, 234, 4, 37, "Message",
  CellTags->"NDSolve::sprkqv"],
Cell[98281, 3291, 126, 4, 24, "Notes",
  CellTags->"NDSolve::sprkqv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[98444, 3300, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::sprkpqv"],
Cell[98532, 3303, 287, 5, 37, "Message",
  CellTags->"NDSolve::sprkpqv"],
Cell[98822, 3310, 127, 4, 24, "Notes",
  CellTags->"NDSolve::sprkpqv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[98986, 3319, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::spltdep"],
Cell[99074, 3322, 290, 5, 37, "Message",
  CellTags->"NDSolve::spltdep"],
Cell[99367, 3329, 127, 4, 24, "Notes",
  CellTags->"NDSolve::spltdep"]
}, Open  ]],

Cell[CellGroupData[{
Cell[99531, 3338, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::spltdim"],
Cell[99619, 3341, 266, 4, 37, "Message",
  CellTags->"NDSolve::spltdim"],
Cell[99888, 3347, 127, 4, 24, "Notes",
  CellTags->"NDSolve::spltdim"]
}, Open  ]],

Cell[CellGroupData[{
Cell[100052, 3356, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::msols"],
Cell[100136, 3359, 180, 3, 21, "Message",
  CellTags->"NDSolve::msols"],
Cell[100319, 3364, 125, 4, 24, "Notes",
  CellTags->"NDSolve::msols"]
}, Open  ]],

Cell[CellGroupData[{
Cell[100481, 3373, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndsol"],
Cell[100565, 3376, 173, 3, 21, "Message",
  CellTags->"NDSolve::ndsol"],
Cell[100741, 3381, 125, 4, 24, "Notes",
  CellTags->"NDSolve::ndsol"]
}, Open  ]],

Cell[CellGroupData[{
Cell[100903, 3390, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndsnf"],
Cell[100987, 3393, 208, 4, 37, "Message",
  CellTags->"NDSolve::ndsnf"],
Cell[101198, 3399, 125, 4, 24, "Notes",
  CellTags->"NDSolve::ndsnf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[101360, 3408, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndspe"],
Cell[101444, 3411, 179, 3, 21, "Message",
  CellTags->"NDSolve::ndspe"],
Cell[101626, 3416, 125, 4, 24, "Notes",
  CellTags->"NDSolve::ndspe"]
}, Open  ]],

Cell[CellGroupData[{
Cell[101788, 3425, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::nlst"],
Cell[101870, 3428, 175, 3, 21, "Message",
  CellTags->"NDSolve::nlst"],
Cell[102048, 3433, 124, 4, 24, "Notes",
  CellTags->"NDSolve::nlst"]
}, Open  ]],

Cell[CellGroupData[{
Cell[102209, 3442, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::nfun"],
Cell[102291, 3445, 162, 3, 21, "Message",
  CellTags->"NDSolve::nfun"],
Cell[102456, 3450, 124, 4, 24, "Notes",
  CellTags->"NDSolve::nfun"]
}, Open  ]],

Cell[CellGroupData[{
Cell[102617, 3459, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::sfun"],
Cell[102699, 3462, 175, 3, 21, "Message",
  CellTags->"NDSolve::sfun"],
Cell[102877, 3467, 124, 4, 24, "Notes",
  CellTags->"NDSolve::sfun"]
}, Open  ]],

Cell[CellGroupData[{
Cell[103038, 3476, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::csymb"],
Cell[103122, 3479, 190, 3, 21, "Message",
  CellTags->"NDSolve::csymb"],
Cell[103315, 3484, 125, 4, 24, "Notes",
  CellTags->"NDSolve::csymb"]
}, Open  ]],

Cell[CellGroupData[{
Cell[103477, 3493, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::lsb"],
Cell[103557, 3496, 219, 6, 21, "Message",
  CellTags->"NDSolve::lsb"],
Cell[103779, 3504, 123, 4, 24, "Notes",
  CellTags->"NDSolve::lsb"]
}, Open  ]],

Cell[CellGroupData[{
Cell[103939, 3513, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bdord"],
Cell[104023, 3516, 262, 4, 37, "Message",
  CellTags->"NDSolve::bdord"],
Cell[104288, 3522, 256, 5, 40, "Notes",
  CellTags->"NDSolve::bdord"],

Cell[CellGroupData[{
Cell[104569, 3531, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bdord"],
Cell[104636, 3534, 178, 4, 40, "Text",
  CellTags->"NDSolve::bdord"],

Cell[CellGroupData[{
Cell[104839, 3542, 303, 6, 58, "Input",
  CellTags->"NDSolve::bdord"],
Cell[105145, 3550, 413, 7, 55, "Message",
  CellTags->"NDSolve::bdord"],
Cell[105561, 3559, 1036, 28, 41, "Output",
  CellTags->"NDSolve::bdord"]
}, Open  ]],
Cell[106612, 3590, 141, 4, 24, "Text",
  CellTags->"NDSolve::bdord"],

Cell[CellGroupData[{
Cell[106778, 3598, 322, 7, 74, "Input",
  CellTags->"NDSolve::bdord"],
Cell[107103, 3607, 336, 10, 21, "Output",
  CellTags->"NDSolve::bdord"]
}, Open  ]],
Cell[107454, 3620, 80, 1, 24, "Text",
  CellTags->"NDSolve::bdord"],

Cell[CellGroupData[{
Cell[107559, 3625, 163, 5, 26, "Input",
  CellTags->"NDSolve::bdord"],
Cell[107725, 3632, 191, 5, 21, "Output",
  CellTags->"NDSolve::bdord"]
}, Open  ]],
Cell[107931, 3640, 113, 5, 24, "Text",
  CellTags->"NDSolve::bdord"],
Cell[108047, 3647, 97, 3, 26, "Input",
  CellTags->"NDSolve::bdord"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[108193, 3656, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::nostep"],
Cell[108279, 3659, 333, 6, 53, "Message",
  CellTags->"NDSolve::nostep"],
Cell[108615, 3667, 185, 6, 24, "Notes",
  CellTags->"NDSolve::nostep"]
}, Open  ]],

Cell[CellGroupData[{
Cell[108837, 3678, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bdstep"],
Cell[108923, 3681, 222, 4, 37, "Message",
  CellTags->"NDSolve::bdstep"],
Cell[109148, 3687, 219, 5, 24, "Notes",
  CellTags->"NDSolve::bdstep"],

Cell[CellGroupData[{
Cell[109392, 3696, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bdstep"],
Cell[109460, 3699, 224, 7, 24, "Text",
  CellTags->"NDSolve::bdstep"],

Cell[CellGroupData[{
Cell[109709, 3710, 197, 4, 26, "Input",
  CellTags->"NDSolve::bdstep"],
Cell[109909, 3716, 240, 5, 37, "Message",
  CellTags->"NDSolve::bdstep"],
Cell[110152, 3723, 279, 8, 21, "Output",
  CellTags->"NDSolve::bdstep"]
}, Open  ]],
Cell[110446, 3734, 237, 6, 40, "Text",
  CellTags->"NDSolve::bdstep"],
Cell[110686, 3742, 128, 3, 26, "Input",
  CellTags->"NDSolve::bdstep"],

Cell[CellGroupData[{
Cell[110839, 3749, 197, 4, 26, "Input",
  CellTags->"NDSolve::bdstep"],
Cell[111039, 3755, 240, 5, 37, "Message",
  CellTags->"NDSolve::bdstep"],
Cell[111282, 3762, 279, 8, 21, "Output",
  CellTags->"NDSolve::bdstep"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[111622, 3777, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvlin"],
Cell[111706, 3780, 341, 5, 53, "Message",
  CellTags->"NDSolve::bvlin"],
Cell[112050, 3787, 160, 4, 24, "Notes",
  CellTags->"NDSolve::bvlin"],

Cell[CellGroupData[{
Cell[112235, 3795, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bvlin"],
Cell[112302, 3798, 159, 4, 24, "Text",
  CellTags->"NDSolve::bvlin"],

Cell[CellGroupData[{
Cell[112486, 3806, 199, 4, 26, "Input",
  CellTags->"NDSolve::bvlin"],
Cell[112688, 3812, 329, 6, 69, "Message",
  CellTags->"NDSolve::bvlin"],
Cell[113020, 3820, 518, 13, 23, "Output",
  CellTags->"NDSolve::bvlin"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[113599, 3840, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvluc"],
Cell[113683, 3843, 415, 8, 69, "Message",
  CellTags->"NDSolve::bvluc"],
Cell[114101, 3853, 164, 4, 24, "Notes",
  CellTags->"NDSolve::bvluc"],

Cell[CellGroupData[{
Cell[114290, 3861, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bvluc"],
Cell[114357, 3864, 216, 5, 40, "Text",
  CellTags->"NDSolve::bvluc"],

Cell[CellGroupData[{
Cell[114598, 3873, 205, 4, 26, "Input",
  CellTags->"NDSolve::bvluc"],
Cell[114806, 3879, 366, 7, 85, "Message",
  CellTags->"NDSolve::bvluc"],
Cell[115175, 3888, 317, 10, 21, "Output",
  CellTags->"NDSolve::bvluc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[115553, 3905, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvls"],
Cell[115635, 3908, 302, 5, 37, "Message",
  CellTags->"NDSolve::bvls"],
Cell[115940, 3915, 124, 4, 24, "Notes",
  CellTags->"NDSolve::bvls"]
}, Open  ]],

Cell[CellGroupData[{
Cell[116101, 3924, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvlind"],
Cell[116187, 3927, 172, 3, 21, "Message",
  CellTags->"NDSolve::bvlind"],
Cell[116362, 3932, 126, 4, 24, "Notes",
  CellTags->"NDSolve::bvlind"]
}, Open  ]],

Cell[CellGroupData[{
Cell[116525, 3941, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvaux"],
Cell[116609, 3944, 186, 3, 21, "Message",
  CellTags->"NDSolve::bvaux"],
Cell[116798, 3949, 466, 10, 90, "Notes",
  CellTags->"NDSolve::bvaux"],

Cell[CellGroupData[{
Cell[117289, 3963, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bvaux"],
Cell[117356, 3966, 140, 4, 24, "Text",
  CellTags->"NDSolve::bvaux"],

Cell[CellGroupData[{
Cell[117521, 3974, 184, 5, 26, "Input",
  CellTags->"NDSolve::bvaux"],
Cell[117708, 3981, 178, 4, 36, "Message",
  CellTags->"NDSolve::bvaux"],
Cell[117889, 3987, 207, 5, 21, "Message",
  CellTags->"NDSolve::bvaux"],
Cell[118099, 3994, 178, 4, 36, "Message",
  CellTags->"NDSolve::bvaux"],
Cell[118280, 4000, 207, 5, 21, "Message",
  CellTags->"NDSolve::bvaux"],
Cell[118490, 4007, 211, 5, 21, "Message",
  CellTags->"NDSolve::bvaux"],
Cell[118704, 4014, 217, 5, 37, "Message",
  CellTags->"NDSolve::bvaux"],
Cell[118924, 4021, 567, 15, 21, "Output",
  CellTags->"NDSolve::bvaux"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[119552, 4043, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvep"],
Cell[119634, 4046, 435, 12, 21, "Message",
  CellTags->"NDSolve::bvep"],
Cell[120072, 4060, 158, 4, 24, "Notes",
  CellTags->"NDSolve::bvep"],

Cell[CellGroupData[{
Cell[120255, 4068, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bvep"],
Cell[120321, 4071, 213, 7, 24, "Text",
  CellTags->"NDSolve::bvep"],

Cell[CellGroupData[{
Cell[120559, 4082, 265, 5, 42, "Input",
  CellTags->"NDSolve::bvep"],
Cell[120827, 4089, 225, 5, 37, "Message",
  CellTags->"NDSolve::bvep"],
Cell[121055, 4096, 612, 16, 58, "Output",
  CellTags->"NDSolve::bvep"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[121728, 4119, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvcrat"],
Cell[121814, 4122, 435, 12, 21, "Message",
  CellTags->"NDSolve::bvcrat"],
Cell[122252, 4136, 160, 4, 24, "Notes",
  CellTags->"NDSolve::bvcrat"]
}, Open  ]],

Cell[CellGroupData[{
Cell[122449, 4145, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bvdae"],
Cell[122533, 4148, 208, 4, 37, "Message",
  CellTags->"NDSolve::bvdae"],
Cell[122744, 4154, 125, 4, 24, "Notes",
  CellTags->"NDSolve::bvdae"]
}, Open  ]],

Cell[CellGroupData[{
Cell[122906, 4163, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::cprec"],
Cell[122990, 4166, 241, 4, 37, "Message",
  CellTags->"NDSolve::cprec"],
Cell[123234, 4172, 125, 4, 24, "Notes",
  CellTags->"NDSolve::cprec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[123396, 4181, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::cconst"],
Cell[123482, 4184, 188, 3, 21, "Message",
  CellTags->"NDSolve::cconst"],
Cell[123673, 4189, 126, 4, 24, "Notes",
  CellTags->"NDSolve::cconst"]
}, Open  ]],

Cell[CellGroupData[{
Cell[123836, 4198, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::cdims"],
Cell[123920, 4201, 218, 4, 37, "Message",
  CellTags->"NDSolve::cdims"],
Cell[124141, 4207, 125, 4, 24, "Notes",
  CellTags->"NDSolve::cdims"]
}, Open  ]],

Cell[CellGroupData[{
Cell[124303, 4216, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::cstruct"],
Cell[124391, 4219, 192, 3, 21, "Message",
  CellTags->"NDSolve::cstruct"],
Cell[124586, 4224, 127, 4, 24, "Notes",
  CellTags->"NDSolve::cstruct"]
}, Open  ]],

Cell[CellGroupData[{
Cell[124750, 4233, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::submtd"],
Cell[124836, 4236, 300, 8, 21, "Message",
  CellTags->"NDSolve::submtd"],
Cell[125139, 4246, 242, 7, 24, "Notes",
  CellTags->"NDSolve::submtd"],

Cell[CellGroupData[{
Cell[125406, 4257, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::submtd"],
Cell[125474, 4260, 223, 7, 24, "Text",
  CellTags->"NDSolve::submtd"],

Cell[CellGroupData[{
Cell[125722, 4271, 267, 5, 42, "Input",
  CellTags->"NDSolve::submtd"],
Cell[125992, 4278, 174, 4, 21, "Message",
  CellTags->"NDSolve::submtd"],
Cell[126169, 4284, 203, 5, 21, "Message",
  CellTags->"NDSolve::submtd"],
Cell[126375, 4291, 279, 8, 21, "Output",
  CellTags->"NDSolve::submtd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[126715, 4306, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::uniss"],
Cell[126799, 4309, 353, 6, 53, "Message",
  CellTags->"NDSolve::uniss"],
Cell[127155, 4317, 229, 5, 40, "Notes",
  CellTags->"NDSolve::uniss"],

Cell[CellGroupData[{
Cell[127409, 4326, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::uniss"],
Cell[127476, 4329, 236, 6, 40, "Text",
  CellTags->"NDSolve::uniss"],

Cell[CellGroupData[{
Cell[127737, 4339, 451, 8, 90, "Input",
  CellTags->"NDSolve::uniss"],
Cell[128191, 4349, 387, 7, 85, "Message",
  CellTags->"NDSolve::uniss"],
Cell[128581, 4358, 339, 10, 21, "Output",
  CellTags->"NDSolve::uniss"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[128981, 4375, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::eerri"],
Cell[129065, 4378, 291, 5, 53, "Message",
  CellTags->"NDSolve::eerri"],
Cell[129359, 4385, 192, 5, 24, "Notes",
  CellTags->"NDSolve::eerri"],

Cell[CellGroupData[{
Cell[129576, 4394, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::eerri"],
Cell[129643, 4397, 236, 5, 40, "Text",
  CellTags->"NDSolve::eerri"],

Cell[CellGroupData[{
Cell[129904, 4406, 447, 8, 74, "Input",
  CellTags->"NDSolve::eerri"],
Cell[130354, 4416, 287, 6, 69, "Message",
  CellTags->"NDSolve::eerri"],
Cell[130644, 4424, 339, 10, 21, "Output",
  CellTags->"NDSolve::eerri"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[131044, 4441, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::vdobj"],
Cell[131128, 4444, 176, 3, 21, "Message",
  CellTags->"NDSolve::vdobj"],
Cell[131307, 4449, 150, 4, 24, "Notes",
  CellTags->"NDSolve::vdobj"],

Cell[CellGroupData[{
Cell[131482, 4457, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::vdobj"],
Cell[131549, 4460, 178, 5, 24, "Text",
  CellTags->"NDSolve::vdobj"],

Cell[CellGroupData[{
Cell[131752, 4469, 133, 3, 26, "Input",
  CellTags->"NDSolve::vdobj"],
Cell[131888, 4474, 303, 6, 37, "Message",
  CellTags->"NDSolve::vdobj"],
Cell[132194, 4482, 211, 6, 21, "Output",
  CellTags->"NDSolve::vdobj"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[132466, 4495, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ininv"],
Cell[132550, 4498, 204, 4, 37, "Message",
  CellTags->"NDSolve::ininv"],
Cell[132757, 4504, 125, 4, 24, "Notes",
  CellTags->"NDSolve::ininv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[132919, 4513, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::impsol"],
Cell[133005, 4516, 207, 5, 37, "Message",
  CellTags->"NDSolve::impsol"],
Cell[133215, 4523, 126, 4, 24, "Notes",
  CellTags->"NDSolve::impsol"]
}, Open  ]],

Cell[CellGroupData[{
Cell[133378, 4532, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::maxit"],
Cell[133462, 4535, 181, 3, 21, "Message",
  CellTags->"NDSolve::maxit"],
Cell[133646, 4540, 125, 4, 24, "Notes",
  CellTags->"NDSolve::maxit"]
}, Open  ]],

Cell[CellGroupData[{
Cell[133808, 4549, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::mmpts"],
Cell[133892, 4552, 341, 5, 69, "Message",
  CellTags->"NDSolve::mmpts"],
Cell[134236, 4559, 135, 4, 24, "Notes",
  CellTags->"NDSolve::mmpts"],

Cell[CellGroupData[{
Cell[134396, 4567, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::mmpts"],
Cell[134463, 4570, 331, 8, 40, "Text",
  CellTags->"NDSolve::mmpts"],

Cell[CellGroupData[{
Cell[134819, 4582, 358, 7, 58, "Input",
  CellTags->"NDSolve::mmpts"],
Cell[135180, 4591, 362, 7, 69, "Message",
  CellTags->"NDSolve::mmpts"],
Cell[135545, 4600, 931, 24, 55, "Output",
  CellTags->"NDSolve::mmpts"]
}, Open  ]],
Cell[136491, 4627, 185, 6, 24, "Text",
  CellTags->"NDSolve::mmpts"],

Cell[CellGroupData[{
Cell[136701, 4637, 314, 6, 58, "Input",
  CellTags->"NDSolve::mmpts"],
Cell[137018, 4645, 339, 10, 21, "Output",
  CellTags->"NDSolve::mmpts"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[137418, 4662, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::dored"],
Cell[137502, 4665, 384, 6, 69, "Message",
  CellTags->"NDSolve::dored"],
Cell[137889, 4673, 125, 4, 24, "Notes",
  CellTags->"NDSolve::dored"]
}, Open  ]],

Cell[CellGroupData[{
Cell[138051, 4682, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::nerres"],
Cell[138137, 4685, 323, 5, 53, "Message",
  CellTags->"NDSolve::nerres"],
Cell[138463, 4692, 153, 4, 24, "Notes",
  CellTags->"NDSolve::nerres"],

Cell[CellGroupData[{
Cell[138641, 4700, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::nerres"],
Cell[138709, 4703, 261, 7, 40, "Text",
  CellTags->"NDSolve::nerres"],

Cell[CellGroupData[{
Cell[138995, 4714, 355, 7, 74, "Input",
  CellTags->"NDSolve::nerres"],
Cell[139353, 4723, 333, 6, 69, "Message",
  CellTags->"NDSolve::nerres"],
Cell[139689, 4731, 291, 8, 21, "Output",
  CellTags->"NDSolve::nerres"]
}, Open  ]],
Cell[139995, 4742, 186, 6, 24, "Text",
  CellTags->"NDSolve::nerres"],

Cell[CellGroupData[{
Cell[140206, 4752, 356, 7, 74, "Input",
  CellTags->"NDSolve::nerres"],
Cell[140565, 4761, 291, 8, 21, "Output",
  CellTags->"NDSolve::nerres"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[140917, 4776, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::eveerr"],
Cell[141003, 4779, 414, 6, 69, "Message",
  CellTags->"NDSolve::eveerr"],
Cell[141420, 4787, 191, 5, 24, "Notes",
  CellTags->"NDSolve::eveerr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[141648, 4797, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::stpmin"],
Cell[141734, 4800, 341, 5, 69, "Message",
  CellTags->"NDSolve::stpmin"],
Cell[142078, 4807, 172, 4, 24, "Notes",
  CellTags->"NDSolve::stpmin"],

Cell[CellGroupData[{
Cell[142275, 4815, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::stpmin"],
Cell[142343, 4818, 204, 5, 40, "Text",
  CellTags->"NDSolve::stpmin"],

Cell[CellGroupData[{
Cell[142572, 4827, 466, 9, 74, "Input",
  CellTags->"NDSolve::stpmin"],
Cell[143041, 4838, 357, 7, 69, "Message",
  CellTags->"NDSolve::stpmin"],
Cell[143401, 4847, 340, 10, 21, "Output",
  CellTags->"NDSolve::stpmin"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[143802, 4864, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::stpmax"],
Cell[143888, 4867, 344, 5, 69, "Message",
  CellTags->"NDSolve::stpmax"],
Cell[144235, 4874, 172, 4, 24, "Notes",
  CellTags->"NDSolve::stpmax"],

Cell[CellGroupData[{
Cell[144432, 4882, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::stpmax"],
Cell[144500, 4885, 204, 5, 40, "Text",
  CellTags->"NDSolve::stpmax"],

Cell[CellGroupData[{
Cell[144729, 4894, 470, 9, 90, "Input",
  CellTags->"NDSolve::stpmax"],
Cell[145202, 4905, 368, 7, 69, "Message",
  CellTags->"NDSolve::stpmax"],
Cell[145573, 4914, 340, 10, 21, "Output",
  CellTags->"NDSolve::stpmax"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[145974, 4931, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::stps"],
Cell[146056, 4934, 308, 5, 53, "Message",
  CellTags->"NDSolve::stps"],
Cell[146367, 4941, 376, 9, 46, "Notes",
  CellTags->"NDSolve::stps"],

Cell[CellGroupData[{
Cell[146768, 4954, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::stps"],
Cell[146834, 4957, 261, 8, 40, "Text",
  CellTags->"NDSolve::stps"],

Cell[CellGroupData[{
Cell[147120, 4969, 470, 9, 90, "Input",
  CellTags->"NDSolve::stps"],
Cell[147593, 4980, 310, 6, 69, "Message",
  CellTags->"NDSolve::stps"],
Cell[147906, 4988, 338, 10, 21, "Output",
  CellTags->"NDSolve::stps"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[148305, 5005, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::maxits"],
Cell[148391, 5008, 249, 5, 53, "Message",
  CellTags->"NDSolve::maxits"],
Cell[148643, 5015, 126, 4, 24, "Notes",
  CellTags->"NDSolve::maxits"]
}, Open  ]],

Cell[CellGroupData[{
Cell[148806, 5024, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::moptxn"],
Cell[148892, 5027, 449, 12, 21, "Message",
  CellTags->"NDSolve::moptxn"],
Cell[149344, 5041, 170, 4, 24, "Notes",
  CellTags->"NDSolve::moptxn"],

Cell[CellGroupData[{
Cell[149539, 5049, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::moptxn"],
Cell[149607, 5052, 239, 7, 40, "Text",
  CellTags->"NDSolve::moptxn"],

Cell[CellGroupData[{
Cell[149871, 5063, 258, 5, 42, "Input",
  CellTags->"NDSolve::moptxn"],
Cell[150132, 5070, 296, 6, 53, "Message",
  CellTags->"NDSolve::moptxn"],
Cell[150431, 5078, 197, 5, 21, "Message",
  CellTags->"NDSolve::moptxn"],
Cell[150631, 5085, 279, 8, 21, "Output",
  CellTags->"NDSolve::moptxn"]
}, Open  ]],
Cell[150925, 5096, 103, 1, 24, "Text",
  CellTags->"NDSolve::moptxn"],

Cell[CellGroupData[{
Cell[151053, 5101, 267, 5, 42, "Input",
  CellTags->"NDSolve::moptxn"],
Cell[151323, 5108, 279, 8, 21, "Output",
  CellTags->"NDSolve::moptxn"]
}, Open  ]],
Cell[151617, 5119, 213, 7, 24, "Text",
  CellTags->"NDSolve::moptxn"],

Cell[CellGroupData[{
Cell[151855, 5130, 262, 5, 42, "Input",
  CellTags->"NDSolve::moptxn"],
Cell[152120, 5137, 282, 6, 53, "Message",
  CellTags->"NDSolve::moptxn"],
Cell[152405, 5145, 594, 15, 37, "Output",
  CellTags->"NDSolve::moptxn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[153060, 5167, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::mrsti"],
Cell[153144, 5170, 214, 5, 37, "Message",
  CellTags->"NDSolve::mrsti"],
Cell[153361, 5177, 209, 5, 24, "Notes",
  CellTags->"NDSolve::mrsti"],

Cell[CellGroupData[{
Cell[153595, 5186, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::mrsti"],
Cell[153662, 5189, 203, 6, 40, "Text",
  CellTags->"NDSolve::mrsti"],

Cell[CellGroupData[{
Cell[153890, 5199, 250, 5, 42, "Input",
  CellTags->"NDSolve::mrsti"],
Cell[154143, 5206, 260, 5, 54, "Message",
  CellTags->"NDSolve::mrsti"],
Cell[154406, 5213, 734, 19, 61, "Output",
  CellTags->"NDSolve::mrsti"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[155201, 5239, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::msti"],
Cell[155283, 5242, 246, 4, 37, "Message",
  CellTags->"NDSolve::msti"],
Cell[155532, 5248, 200, 5, 24, "Notes",
  CellTags->"NDSolve::msti"],

Cell[CellGroupData[{
Cell[155757, 5257, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::msti"],
Cell[155823, 5260, 194, 6, 24, "Text",
  CellTags->"NDSolve::msti"],

Cell[CellGroupData[{
Cell[156042, 5270, 410, 8, 74, "Input",
  CellTags->"NDSolve::msti"],
Cell[156455, 5280, 294, 6, 53, "Message",
  CellTags->"NDSolve::msti"],
Cell[156752, 5288, 985, 24, 88, "Output",
  CellTags->"NDSolve::msti"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[157798, 5319, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ncsm"],
Cell[157880, 5322, 231, 4, 37, "Message",
  CellTags->"NDSolve::ncsm"],
Cell[158114, 5328, 124, 4, 24, "Notes",
  CellTags->"NDSolve::ncsm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[158275, 5337, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::lsf"],
Cell[158355, 5340, 191, 3, 21, "Message",
  CellTags->"NDSolve::lsf"],
Cell[158549, 5345, 347, 8, 46, "Notes",
  CellTags->"NDSolve::lsf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[158933, 5358, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndinnt"],
Cell[159019, 5361, 204, 4, 37, "Message",
  CellTags->"NDSolve::ndinnt"],
Cell[159226, 5367, 308, 6, 46, "Notes",
  CellTags->"NDSolve::ndinnt"],

Cell[CellGroupData[{
Cell[159559, 5377, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::ndinnt"],
Cell[159627, 5380, 181, 7, 24, "Text",
  CellTags->"NDSolve::ndinnt"],

Cell[CellGroupData[{
Cell[159833, 5391, 161, 4, 26, "Input",
  CellTags->"NDSolve::ndinnt"],
Cell[159997, 5397, 177, 4, 21, "Message",
  CellTags->"NDSolve::ndinnt"],
Cell[160177, 5403, 226, 5, 37, "Message",
  CellTags->"NDSolve::ndinnt"],
Cell[160406, 5410, 451, 12, 21, "Output",
  CellTags->"NDSolve::ndinnt"]
}, Open  ]],
Cell[160872, 5425, 163, 5, 24, "Text",
  CellTags->"NDSolve::ndinnt"],

Cell[CellGroupData[{
Cell[161060, 5434, 141, 3, 26, "Input",
  CellTags->"NDSolve::ndinnt"],
Cell[161204, 5439, 279, 8, 21, "Output",
  CellTags->"NDSolve::ndinnt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[161544, 5454, 154, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
Cell[161701, 5460, 341, 8, 37, "Message",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
Cell[162045, 5470, 189, 4, 24, "Notes",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],

Cell[CellGroupData[{
Cell[162259, 5478, 99, 1, 38, "ExampleSection",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
Cell[162361, 5481, 220, 5, 24, "Text",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],

Cell[CellGroupData[{
Cell[162606, 5490, 246, 5, 26, "Input",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
Cell[162855, 5497, 270, 5, 37, "Message",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}],
Cell[163128, 5504, 717, 18, 21, "Output",
  CellTags->{"NDSolve::ndincd", "NDSolve`Reinitialize::ndincd"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[163906, 5529, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndincb"],
Cell[163992, 5532, 180, 3, 21, "Message",
  CellTags->"NDSolve::ndincb"],
Cell[164175, 5537, 126, 4, 24, "Notes",
  CellTags->"NDSolve::ndincb"]
}, Open  ]],

Cell[CellGroupData[{
Cell[164338, 5546, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::opdims"],
Cell[164424, 5549, 289, 5, 53, "Message",
  CellTags->"NDSolve::opdims"],
Cell[164716, 5556, 126, 4, 24, "Notes",
  CellTags->"NDSolve::opdims"]
}, Open  ]],

Cell[CellGroupData[{
Cell[164879, 5565, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::opmdims"],
Cell[164967, 5568, 253, 4, 37, "Message",
  CellTags->"NDSolve::opmdims"],
Cell[165223, 5574, 127, 4, 24, "Notes",
  CellTags->"NDSolve::opmdims"]
}, Open  ]],

Cell[CellGroupData[{
Cell[165387, 5583, 109, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`Reinitialize::ndincb"],
Cell[165499, 5586, 240, 4, 37, "Message",
  CellTags->"NDSolve`Reinitialize::ndincb"],
Cell[165742, 5592, 177, 4, 24, "Notes",
  CellTags->"NDSolve`Reinitialize::ndincb"],

Cell[CellGroupData[{
Cell[165944, 5600, 78, 1, 38, "ExampleSection",
  CellTags->"NDSolve`Reinitialize::ndincb"],
Cell[166025, 5603, 200, 6, 24, "Text",
  CellTags->"NDSolve`Reinitialize::ndincb"],

Cell[CellGroupData[{
Cell[166250, 5613, 270, 6, 42, "Input",
  CellTags->"NDSolve`Reinitialize::ndincb"],
Cell[166523, 5621, 332, 9, 21, "Output",
  CellTags->"NDSolve`Reinitialize::ndincb"]
}, Open  ]],

Cell[CellGroupData[{
Cell[166892, 5635, 190, 5, 26, "Input",
  CellTags->"NDSolve`Reinitialize::ndincb"],
Cell[167085, 5642, 247, 5, 37, "Message",
  CellTags->"NDSolve`Reinitialize::ndincb"],
Cell[167335, 5649, 723, 20, 21, "Output",
  CellTags->"NDSolve`Reinitialize::ndincb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[168119, 5676, 154, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NDSolve::ndncov", "NDSolve`Reinitialize::ndncov"}],
Cell[168276, 5682, 372, 8, 37, "Message",
  CellTags->{"NDSolve::ndncov", "NDSolve`Reinitialize::ndncov"}],
Cell[168651, 5692, 205, 4, 24, "Notes",
  CellTags->{"NDSolve::ndncov", "NDSolve`Reinitialize::ndncov"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[168893, 5701, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndfdmc"],
Cell[168979, 5704, 217, 4, 37, "Message",
  CellTags->"NDSolve::ndfdmc"],
Cell[169199, 5710, 242, 5, 40, "Notes",
  CellTags->"NDSolve::ndfdmc"],

Cell[CellGroupData[{
Cell[169466, 5719, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::ndfdmc"],
Cell[169534, 5722, 225, 5, 40, "Text",
  CellTags->"NDSolve::ndfdmc"],

Cell[CellGroupData[{
Cell[169784, 5731, 221, 5, 42, "Input",
  CellTags->"NDSolve::ndfdmc"],
Cell[170008, 5738, 227, 5, 37, "Message",
  CellTags->"NDSolve::ndfdmc"],
Cell[170238, 5745, 692, 18, 21, "Output",
  CellTags->"NDSolve::ndfdmc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[170991, 5770, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndrsd"],
Cell[171075, 5773, 194, 3, 21, "Message",
  CellTags->"NDSolve::ndrsd"],
Cell[171272, 5778, 125, 4, 24, "Notes",
  CellTags->"NDSolve::ndrsd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[171434, 5787, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndsnorm"],
Cell[171522, 5790, 236, 4, 37, "Message",
  CellTags->"NDSolve::ndsnorm"],
Cell[171761, 5796, 199, 5, 24, "Notes",
  CellTags->"NDSolve::ndsnorm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[171997, 5806, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndsnr"],
Cell[172081, 5809, 174, 4, 21, "Message",
  CellTags->"NDSolve::ndsnr"],
Cell[172258, 5815, 125, 4, 24, "Notes",
  CellTags->"NDSolve::ndsnr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[172420, 5824, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndssc"],
Cell[172504, 5827, 162, 3, 21, "Message",
  CellTags->"NDSolve::ndssc"],
Cell[172669, 5832, 125, 4, 24, "Notes",
  CellTags->"NDSolve::ndssc"]
}, Open  ]],

Cell[CellGroupData[{
Cell[172831, 5841, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndstf"],
Cell[172915, 5844, 251, 5, 53, "Message",
  CellTags->"NDSolve::ndstf"],
Cell[173169, 5851, 125, 4, 24, "Notes",
  CellTags->"NDSolve::ndstf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[173331, 5860, 150, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
Cell[173484, 5866, 404, 9, 37, "Message",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
Cell[173891, 5877, 283, 5, 40, "Notes",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],

Cell[CellGroupData[{
Cell[174199, 5886, 97, 1, 38, "ExampleSection",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
Cell[174299, 5889, 191, 4, 24, "Text",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],

Cell[CellGroupData[{
Cell[174515, 5897, 388, 8, 42, "Input",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
Cell[174906, 5907, 309, 6, 53, "Message",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
Cell[175218, 5915, 475, 8, 85, "Message",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}],
Cell[175696, 5925, 500, 13, 37, "Output",
  CellTags->{"NDSolve::ivcon", "NDSolve`Reinitialize::ivcon"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[176257, 5945, 150, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
Cell[176410, 5951, 396, 9, 37, "Message",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
Cell[176809, 5962, 239, 5, 24, "Notes",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],

Cell[CellGroupData[{
Cell[177073, 5971, 97, 1, 38, "ExampleSection",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
Cell[177173, 5974, 263, 5, 40, "Text",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],

Cell[CellGroupData[{
Cell[177461, 5983, 242, 5, 26, "Input",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
Cell[177706, 5990, 310, 6, 53, "Message",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}],
Cell[178019, 5998, 721, 19, 23, "Output",
  CellTags->{"NDSolve::icord", "NDSolve`Reinitialize::icord"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[178801, 6024, 162, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
Cell[178966, 6030, 454, 10, 53, "Message",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
Cell[179423, 6042, 245, 5, 24, "Notes",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],

Cell[CellGroupData[{
Cell[179693, 6051, 103, 1, 38, "ExampleSection",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
Cell[179799, 6054, 329, 7, 40, "Text",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],

Cell[CellGroupData[{
Cell[180153, 6065, 395, 8, 42, "Input",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
Cell[180551, 6075, 353, 6, 69, "Message",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}],
Cell[180907, 6083, 1194, 29, 37, "Output",
  CellTags->{"NDSolve::icorddae", "NDSolve`Reinitialize::icorddae"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[182162, 6119, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::mdata"],
Cell[182246, 6122, 207, 4, 37, "Message",
  CellTags->"NDSolve::mdata"],
Cell[182456, 6128, 125, 4, 24, "Notes",
  CellTags->"NDSolve::mdata"]
}, Open  ]],

Cell[CellGroupData[{
Cell[182618, 6137, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::tponly"],
Cell[182704, 6140, 226, 4, 53, "Message",
  CellTags->"NDSolve::tponly"],
Cell[182933, 6146, 180, 5, 24, "Notes",
  CellTags->"NDSolve::tponly"],

Cell[CellGroupData[{
Cell[183138, 6155, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::tponly"],
Cell[183206, 6158, 235, 7, 40, "Text",
  CellTags->"NDSolve::tponly"],

Cell[CellGroupData[{
Cell[183466, 6169, 377, 7, 58, "Input",
  CellTags->"NDSolve::tponly"],
Cell[183846, 6178, 237, 5, 37, "Message",
  CellTags->"NDSolve::tponly"],
Cell[184086, 6185, 940, 24, 71, "Output",
  CellTags->"NDSolve::tponly"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[185087, 6216, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::norm"],
Cell[185169, 6219, 155, 3, 21, "Message",
  CellTags->"NDSolve::norm"],
Cell[185327, 6224, 124, 4, 24, "Notes",
  CellTags->"NDSolve::norm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[185488, 6233, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::rclist"],
Cell[185574, 6236, 590, 14, 37, "Message",
  CellTags->"NDSolve::rclist"],
Cell[186167, 6252, 155, 4, 24, "Notes",
  CellTags->"NDSolve::rclist"],

Cell[CellGroupData[{
Cell[186347, 6260, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::rclist"],
Cell[186415, 6263, 206, 6, 24, "Text",
  CellTags->"NDSolve::rclist"],

Cell[CellGroupData[{
Cell[186646, 6273, 446, 8, 74, "Input",
  CellTags->"NDSolve::rclist"],
Cell[187095, 6283, 309, 6, 53, "Message",
  CellTags->"NDSolve::rclist"],
Cell[187407, 6291, 994, 25, 71, "Output",
  CellTags->"NDSolve::rclist"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[188462, 6323, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::coend"],
Cell[188546, 6326, 209, 4, 37, "Message",
  CellTags->"NDSolve::coend"],
Cell[188758, 6332, 213, 5, 40, "Notes",
  CellTags->"NDSolve::coend"],

Cell[CellGroupData[{
Cell[188996, 6341, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::coend"],
Cell[189063, 6344, 302, 7, 40, "Text",
  CellTags->"NDSolve::coend"],

Cell[CellGroupData[{
Cell[189390, 6355, 434, 8, 74, "Input",
  CellTags->"NDSolve::coend"],
Cell[189827, 6365, 297, 6, 53, "Message",
  CellTags->"NDSolve::coend"],
Cell[190127, 6373, 1013, 25, 71, "Output",
  CellTags->"NDSolve::coend"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[191201, 6405, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::coexp"],
Cell[191285, 6408, 307, 5, 53, "Message",
  CellTags->"NDSolve::coexp"],
Cell[191595, 6415, 208, 5, 40, "Notes",
  CellTags->"NDSolve::coexp"],

Cell[CellGroupData[{
Cell[191828, 6424, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::coexp"],
Cell[191895, 6427, 282, 8, 40, "Text",
  CellTags->"NDSolve::coexp"],

Cell[CellGroupData[{
Cell[192202, 6439, 568, 10, 106, "Input",
  CellTags->"NDSolve::coexp"],
Cell[192773, 6451, 441, 8, 85, "Message",
  CellTags->"NDSolve::coexp"],
Cell[193217, 6461, 339, 10, 21, "Output",
  CellTags->"NDSolve::coexp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[193617, 6478, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ssrei"],
Cell[193701, 6481, 211, 4, 37, "Message",
  CellTags->"NDSolve::ssrei"],
Cell[193915, 6487, 125, 4, 24, "Notes",
  CellTags->"NDSolve::ssrei"]
}, Open  ]],

Cell[CellGroupData[{
Cell[194077, 6496, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ssre"],
Cell[194159, 6499, 193, 3, 37, "Message",
  CellTags->"NDSolve::ssre"],
Cell[194355, 6504, 124, 4, 24, "Notes",
  CellTags->"NDSolve::ssre"]
}, Open  ]],

Cell[CellGroupData[{
Cell[194516, 6513, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::sfty"],
Cell[194598, 6516, 219, 5, 37, "Message",
  CellTags->"NDSolve::sfty"],
Cell[194820, 6523, 124, 4, 24, "Notes",
  CellTags->"NDSolve::sfty"]
}, Open  ]],

Cell[CellGroupData[{
Cell[194981, 6532, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::aord"],
Cell[195063, 6535, 176, 3, 21, "Message",
  CellTags->"NDSolve::aord"],
Cell[195242, 6540, 124, 4, 24, "Notes",
  CellTags->"NDSolve::aord"]
}, Open  ]],

Cell[CellGroupData[{
Cell[195403, 6549, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::sss"],
Cell[195483, 6552, 182, 3, 21, "Message",
  CellTags->"NDSolve::sss"],
Cell[195668, 6557, 123, 4, 24, "Notes",
  CellTags->"NDSolve::sss"]
}, Open  ]],

Cell[CellGroupData[{
Cell[195828, 6566, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::mconly"],
Cell[195914, 6569, 291, 5, 53, "Message",
  CellTags->"NDSolve::mconly"],
Cell[196208, 6576, 126, 4, 24, "Notes",
  CellTags->"NDSolve::mconly"]
}, Open  ]],

Cell[CellGroupData[{
Cell[196371, 6585, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::nolib"],
Cell[196455, 6588, 220, 4, 37, "Message",
  CellTags->"NDSolve::nolib"],
Cell[196678, 6594, 125, 4, 24, "Notes",
  CellTags->"NDSolve::nolib"]
}, Open  ]],

Cell[CellGroupData[{
Cell[196840, 6603, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::nodae"],
Cell[196924, 6606, 274, 5, 53, "Message",
  CellTags->"NDSolve::nodae"],
Cell[197201, 6613, 334, 7, 40, "Notes",
  CellTags->"NDSolve::nodae"],

Cell[CellGroupData[{
Cell[197560, 6624, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::nodae"],
Cell[197627, 6627, 175, 4, 40, "Text",
  CellTags->"NDSolve::nodae"],

Cell[CellGroupData[{
Cell[197827, 6635, 277, 6, 42, "Input",
  CellTags->"NDSolve::nodae"],
Cell[198107, 6643, 272, 6, 53, "Message",
  CellTags->"NDSolve::nodae"],
Cell[198382, 6651, 90, 3, 21, "Output",
  CellTags->"NDSolve::nodae"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[198533, 6661, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::icfail"],
Cell[198619, 6664, 328, 5, 53, "Message",
  CellTags->"NDSolve::icfail"],
Cell[198950, 6671, 200, 5, 24, "Notes",
  CellTags->"NDSolve::icfail"],

Cell[CellGroupData[{
Cell[199175, 6680, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::icfail"],
Cell[199243, 6683, 142, 4, 24, "Text",
  CellTags->"NDSolve::icfail"],

Cell[CellGroupData[{
Cell[199410, 6691, 265, 6, 42, "Input",
  CellTags->"NDSolve::icfail"],
Cell[199678, 6699, 321, 6, 69, "Message",
  CellTags->"NDSolve::icfail"],
Cell[200002, 6707, 91, 3, 21, "Output",
  CellTags->"NDSolve::icfail"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[200154, 6717, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::lsopt"],
Cell[200238, 6720, 273, 4, 53, "Message",
  CellTags->"NDSolve::lsopt"],
Cell[200514, 6726, 167, 4, 24, "Notes",
  CellTags->"NDSolve::lsopt"],

Cell[CellGroupData[{
Cell[200706, 6734, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::lsopt"],
Cell[200773, 6737, 239, 6, 40, "Text",
  CellTags->"NDSolve::lsopt"],

Cell[CellGroupData[{
Cell[201037, 6747, 638, 12, 106, "Input",
  CellTags->"NDSolve::lsopt"],
Cell[201678, 6761, 297, 6, 53, "Message",
  CellTags->"NDSolve::lsopt"],
Cell[201978, 6769, 1538, 35, 129, "Output",
  CellTags->"NDSolve::lsopt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[203577, 6811, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::molpde"],
Cell[203663, 6814, 273, 5, 53, "Message",
  CellTags->"NDSolve::molpde"],
Cell[203939, 6821, 331, 9, 40, "Notes",
  CellTags->"NDSolve::molpde"],

Cell[CellGroupData[{
Cell[204295, 6834, 65, 1, 38, "ExampleSection",
  CellTags->"NDSolve::molpde"],
Cell[204363, 6837, 193, 5, 40, "Text",
  CellTags->"NDSolve::molpde"],

Cell[CellGroupData[{
Cell[204581, 6846, 298, 6, 58, "Input",
  CellTags->"NDSolve::molpde"],
Cell[204882, 6854, 269, 6, 53, "Message",
  CellTags->"NDSolve::molpde"],
Cell[205154, 6862, 758, 19, 39, "Output",
  CellTags->"NDSolve::molpde"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[205973, 6888, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::chbvp"],
Cell[206057, 6891, 274, 5, 53, "Message",
  CellTags->"NDSolve::chbvp"],
Cell[206334, 6898, 317, 9, 40, "Notes",
  CellTags->"NDSolve::chbvp"],

Cell[CellGroupData[{
Cell[206676, 6911, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::chbvp"],
Cell[206743, 6914, 194, 5, 40, "Text",
  CellTags->"NDSolve::chbvp"],

Cell[CellGroupData[{
Cell[206962, 6923, 291, 6, 58, "Input",
  CellTags->"NDSolve::chbvp"],
Cell[207256, 6931, 267, 6, 53, "Message",
  CellTags->"NDSolve::chbvp"],
Cell[207526, 6939, 751, 19, 39, "Output",
  CellTags->"NDSolve::chbvp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[208338, 6965, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::jpde"],
Cell[208420, 6968, 292, 5, 53, "Message",
  CellTags->"NDSolve::jpde"],
Cell[208715, 6975, 193, 5, 40, "Notes",
  CellTags->"NDSolve::jpde"],

Cell[CellGroupData[{
Cell[208933, 6984, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::jpde"],
Cell[208999, 6987, 206, 6, 40, "Text",
  CellTags->"NDSolve::jpde"],

Cell[CellGroupData[{
Cell[209230, 6997, 300, 6, 58, "Input",
  CellTags->"NDSolve::jpde"],
Cell[209533, 7005, 286, 6, 69, "Message",
  CellTags->"NDSolve::jpde"],
Cell[209822, 7013, 338, 10, 21, "Output",
  CellTags->"NDSolve::jpde"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[210221, 7030, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::tvar"],
Cell[210303, 7033, 200, 4, 37, "Message",
  CellTags->"NDSolve::tvar"],
Cell[210506, 7039, 157, 4, 24, "Notes",
  CellTags->"NDSolve::tvar"],

Cell[CellGroupData[{
Cell[210688, 7047, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::tvar"],
Cell[210754, 7050, 247, 6, 40, "Text",
  CellTags->"NDSolve::tvar"],

Cell[CellGroupData[{
Cell[211026, 7060, 345, 7, 58, "Input",
  CellTags->"NDSolve::tvar"],
Cell[211374, 7069, 242, 5, 37, "Message",
  CellTags->"NDSolve::tvar"],
Cell[211619, 7076, 898, 23, 55, "Output",
  CellTags->"NDSolve::tvar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[212578, 7106, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::tvic"],
Cell[212660, 7109, 338, 6, 69, "Message",
  CellTags->"NDSolve::tvic"],
Cell[213001, 7117, 187, 5, 24, "Notes",
  CellTags->"NDSolve::tvic"],

Cell[CellGroupData[{
Cell[213213, 7126, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::tvic"],
Cell[213279, 7129, 266, 6, 40, "Text",
  CellTags->"NDSolve::tvic"],

Cell[CellGroupData[{
Cell[213570, 7139, 309, 7, 58, "Input",
  CellTags->"NDSolve::tvic"],
Cell[213882, 7148, 334, 6, 69, "Message",
  CellTags->"NDSolve::tvic"],
Cell[214219, 7156, 850, 22, 55, "Output",
  CellTags->"NDSolve::tvic"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[215130, 7185, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ponly"],
Cell[215214, 7188, 244, 4, 37, "Message",
  CellTags->"NDSolve::ponly"],
Cell[215461, 7194, 125, 4, 24, "Notes",
  CellTags->"NDSolve::ponly"]
}, Open  ]],

Cell[CellGroupData[{
Cell[215623, 7203, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::mdo"],
Cell[215703, 7206, 237, 5, 37, "Message",
  CellTags->"NDSolve::mdo"],
Cell[215943, 7213, 196, 5, 24, "Notes",
  CellTags->"NDSolve::mdo"],

Cell[CellGroupData[{
Cell[216164, 7222, 62, 1, 38, "ExampleSection",
  CellTags->"NDSolve::mdo"],
Cell[216229, 7225, 218, 6, 40, "Text",
  CellTags->"NDSolve::mdo"],

Cell[CellGroupData[{
Cell[216472, 7235, 255, 6, 42, "Input",
  CellTags->"NDSolve::mdo"],
Cell[216730, 7243, 262, 5, 37, "Message",
  CellTags->"NDSolve::mdo"],
Cell[216995, 7250, 194, 5, 21, "Message",
  CellTags->"NDSolve::mdo"],
Cell[217192, 7257, 276, 8, 21, "Output",
  CellTags->"NDSolve::mdo"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[217529, 7272, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::mord"],
Cell[217611, 7275, 170, 3, 21, "Message",
  CellTags->"NDSolve::mord"],
Cell[217784, 7280, 124, 4, 24, "Notes",
  CellTags->"NDSolve::mord"]
}, Open  ]],

Cell[CellGroupData[{
Cell[217945, 7289, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::imps"],
Cell[218027, 7292, 219, 4, 37, "Message",
  CellTags->"NDSolve::imps"],
Cell[218249, 7298, 199, 5, 24, "Notes",
  CellTags->"NDSolve::imps"],

Cell[CellGroupData[{
Cell[218473, 7307, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::imps"],
Cell[218539, 7310, 210, 7, 24, "Text",
  CellTags->"NDSolve::imps"],

Cell[CellGroupData[{
Cell[218774, 7321, 252, 6, 42, "Input",
  CellTags->"NDSolve::imps"],
Cell[219029, 7329, 223, 5, 37, "Message",
  CellTags->"NDSolve::imps"],
Cell[219255, 7336, 195, 5, 21, "Message",
  CellTags->"NDSolve::imps"],
Cell[219453, 7343, 277, 8, 21, "Output",
  CellTags->"NDSolve::imps"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[219791, 7358, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::lsm"],
Cell[219871, 7361, 201, 4, 37, "Message",
  CellTags->"NDSolve::lsm"],
Cell[220075, 7367, 273, 6, 46, "Notes",
  CellTags->"NDSolve::lsm"],

Cell[CellGroupData[{
Cell[220373, 7377, 62, 1, 38, "ExampleSection",
  CellTags->"NDSolve::lsm"],
Cell[220438, 7380, 232, 7, 40, "Text",
  CellTags->"NDSolve::lsm"],

Cell[CellGroupData[{
Cell[220695, 7391, 321, 7, 58, "Input",
  CellTags->"NDSolve::lsm"],
Cell[221019, 7400, 227, 5, 37, "Message",
  CellTags->"NDSolve::lsm"],
Cell[221249, 7407, 194, 5, 21, "Message",
  CellTags->"NDSolve::lsm"],
Cell[221446, 7414, 276, 8, 21, "Output",
  CellTags->"NDSolve::lsm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[221783, 7429, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bw"],
Cell[221861, 7432, 269, 4, 53, "Message",
  CellTags->"NDSolve::bw"],
Cell[222133, 7438, 264, 6, 46, "Notes",
  CellTags->"NDSolve::bw"],

Cell[CellGroupData[{
Cell[222422, 7448, 61, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bw"],
Cell[222486, 7451, 220, 7, 24, "Text",
  CellTags->"NDSolve::bw"],

Cell[CellGroupData[{
Cell[222731, 7462, 334, 7, 58, "Input",
  CellTags->"NDSolve::bw"],
Cell[223068, 7471, 289, 6, 53, "Message",
  CellTags->"NDSolve::bw"],
Cell[223360, 7479, 193, 5, 21, "Message",
  CellTags->"NDSolve::bw"],
Cell[223556, 7486, 275, 8, 21, "Output",
  CellTags->"NDSolve::bw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[223892, 7501, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::otype"],
Cell[223976, 7504, 217, 4, 37, "Message",
  CellTags->"NDSolve::otype"],
Cell[224196, 7510, 279, 6, 46, "Notes",
  CellTags->"NDSolve::otype"],

Cell[CellGroupData[{
Cell[224500, 7520, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::otype"],
Cell[224567, 7523, 227, 7, 40, "Text",
  CellTags->"NDSolve::otype"],

Cell[CellGroupData[{
Cell[224819, 7534, 298, 6, 42, "Input",
  CellTags->"NDSolve::otype"],
Cell[225120, 7542, 260, 5, 53, "Message",
  CellTags->"NDSolve::otype"],
Cell[225383, 7549, 196, 5, 21, "Message",
  CellTags->"NDSolve::otype"],
Cell[225582, 7556, 278, 8, 21, "Output",
  CellTags->"NDSolve::otype"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[225921, 7571, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::scpar"],
Cell[226005, 7574, 252, 4, 53, "Message",
  CellTags->"NDSolve::scpar"],
Cell[226260, 7580, 125, 4, 24, "Notes",
  CellTags->"NDSolve::scpar"]
}, Open  ]],

Cell[CellGroupData[{
Cell[226422, 7589, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::subsp"],
Cell[226506, 7592, 209, 4, 37, "Message",
  CellTags->"NDSolve::subsp"],
Cell[226718, 7598, 231, 6, 46, "Notes",
  CellTags->"NDSolve::subsp"],

Cell[CellGroupData[{
Cell[226974, 7608, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::subsp"],
Cell[227041, 7611, 229, 7, 40, "Text",
  CellTags->"NDSolve::subsp"],

Cell[CellGroupData[{
Cell[227295, 7622, 300, 6, 58, "Input",
  CellTags->"NDSolve::subsp"],
Cell[227598, 7630, 265, 5, 53, "Message",
  CellTags->"NDSolve::subsp"],
Cell[227866, 7637, 196, 5, 21, "Message",
  CellTags->"NDSolve::subsp"],
Cell[228065, 7644, 278, 8, 21, "Output",
  CellTags->"NDSolve::subsp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[228404, 7659, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ssrb"],
Cell[228486, 7662, 293, 5, 53, "Message",
  CellTags->"NDSolve::ssrb"],
Cell[228782, 7669, 124, 4, 24, "Notes",
  CellTags->"NDSolve::ssrb"]
}, Open  ]],

Cell[CellGroupData[{
Cell[228943, 7678, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ssserr"],
Cell[229029, 7681, 235, 4, 37, "Message",
  CellTags->"NDSolve::ssserr"],
Cell[229267, 7687, 126, 4, 24, "Notes",
  CellTags->"NDSolve::ssserr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[229430, 7696, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::irkcargs"],
Cell[229520, 7699, 207, 5, 37, "Message",
  CellTags->"NDSolve::irkcargs"],
Cell[229730, 7706, 128, 4, 24, "Notes",
  CellTags->"NDSolve::irkcargs"]
}, Open  ]],

Cell[CellGroupData[{
Cell[229895, 7715, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::irkcopts"],
Cell[229985, 7718, 205, 5, 37, "Message",
  CellTags->"NDSolve::irkcopts"],
Cell[230193, 7725, 128, 4, 24, "Notes",
  CellTags->"NDSolve::irkcopts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[230358, 7734, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::irkcploss"],
Cell[230450, 7737, 224, 4, 37, "Message",
  CellTags->"NDSolve::irkcploss"],
Cell[230677, 7743, 129, 4, 24, "Notes",
  CellTags->"NDSolve::irkcploss"]
}, Open  ]],

Cell[CellGroupData[{
Cell[230843, 7752, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`Iterate::sivpd"],
Cell[230943, 7755, 250, 4, 37, "Message",
  CellTags->"NDSolve`Iterate::sivpd"],
Cell[231196, 7761, 191, 4, 24, "Notes",
  CellTags->"NDSolve`Iterate::sivpd"],

Cell[CellGroupData[{
Cell[231412, 7769, 72, 1, 38, "ExampleSection",
  CellTags->"NDSolve`Iterate::sivpd"],
Cell[231487, 7772, 175, 4, 24, "Text",
  CellTags->"NDSolve`Iterate::sivpd"],

Cell[CellGroupData[{
Cell[231687, 7780, 116, 3, 26, "Input",
  CellTags->"NDSolve`Iterate::sivpd"],
Cell[231806, 7785, 295, 6, 53, "Message",
  CellTags->"NDSolve`Iterate::sivpd"],
Cell[232104, 7793, 117, 3, 21, "Output",
  CellTags->"NDSolve`Iterate::sivpd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[232258, 7801, 247, 6, 42, "Input",
  CellTags->"NDSolve`Iterate::sivpd"],
Cell[232508, 7809, 453, 7, 69, "Message",
  CellTags->"NDSolve`Iterate::sivpd"],
Cell[232964, 7818, 453, 13, 21, "Output",
  CellTags->"NDSolve`Iterate::sivpd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[233478, 7838, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::exseq"],
Cell[233562, 7841, 400, 7, 69, "Message",
  CellTags->"NDSolve::exseq"],
Cell[233965, 7850, 125, 4, 24, "Notes",
  CellTags->"NDSolve::exseq"]
}, Open  ]],

Cell[CellGroupData[{
Cell[234127, 7859, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::exseqev"],
Cell[234215, 7862, 309, 5, 53, "Message",
  CellTags->"NDSolve::exseqev"],
Cell[234527, 7869, 127, 4, 24, "Notes",
  CellTags->"NDSolve::exseqev"]
}, Open  ]],

Cell[CellGroupData[{
Cell[234691, 7878, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::exmaxo"],
Cell[234777, 7881, 283, 5, 53, "Message",
  CellTags->"NDSolve::exmaxo"],
Cell[235063, 7888, 126, 4, 24, "Notes",
  CellTags->"NDSolve::exmaxo"]
}, Open  ]],

Cell[CellGroupData[{
Cell[235226, 7897, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::exmino"],
Cell[235312, 7900, 262, 4, 37, "Message",
  CellTags->"NDSolve::exmino"],
Cell[235577, 7906, 126, 4, 24, "Notes",
  CellTags->"NDSolve::exmino"]
}, Open  ]],

Cell[CellGroupData[{
Cell[235740, 7915, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::exsord"],
Cell[235826, 7918, 254, 4, 37, "Message",
  CellTags->"NDSolve::exsord"],
Cell[236083, 7924, 126, 4, 24, "Notes",
  CellTags->"NDSolve::exsord"]
}, Open  ]],

Cell[CellGroupData[{
Cell[236246, 7933, 124, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NDSolve::exordf", "NDSolve::sssf"}],
Cell[236373, 7939, 406, 11, 37, "Message",
  CellTags->{"NDSolve::exordf", "NDSolve::sssf"}],
Cell[236782, 7952, 145, 4, 24, "Notes",
  CellTags->{"NDSolve::exordf", "NDSolve::sssf"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[236964, 7961, 135, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],
Cell[237102, 7964, 262, 4, 37, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],
Cell[237367, 7970, 170, 4, 24, "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],

Cell[CellGroupData[{
Cell[237562, 7978, 91, 1, 38, "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],
Cell[237656, 7981, 183, 4, 24, "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],

Cell[CellGroupData[{
Cell[237864, 7989, 162, 3, 26, "Input",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],
Cell[238029, 7994, 281, 5, 37, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"],
Cell[238313, 8001, 208, 4, 21, "Output",
  CellTags->"NDSolve`FiniteDifferenceDerivative::deriv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[238582, 8012, 133, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],
Cell[238718, 8015, 251, 4, 37, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],
Cell[238972, 8021, 169, 4, 24, "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],

Cell[CellGroupData[{
Cell[239166, 8029, 90, 1, 38, "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],
Cell[239259, 8032, 182, 4, 24, "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],

Cell[CellGroupData[{
Cell[239466, 8040, 183, 4, 26, "Input",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],
Cell[239652, 8046, 296, 5, 53, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"],
Cell[239951, 8053, 206, 4, 37, "Output",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ldim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[240218, 8064, 133, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
Cell[240354, 8067, 277, 4, 37, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
Cell[240634, 8073, 169, 4, 24, "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],

Cell[CellGroupData[{
Cell[240828, 8081, 90, 1, 38, "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
Cell[240921, 8084, 182, 4, 24, "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],

Cell[CellGroupData[{
Cell[241128, 8092, 175, 4, 26, "Input",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
Cell[241306, 8098, 298, 5, 53, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
Cell[241607, 8105, 181, 4, 21, "Output",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"]
}, Open  ]],
Cell[241803, 8112, 245, 5, 40, "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],

Cell[CellGroupData[{
Cell[242073, 8121, 283, 5, 58, "Input",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
Cell[242359, 8128, 552, 9, 82, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"],
Cell[242914, 8139, 564, 10, 143, "Output",
  CellTags->"NDSolve`FiniteDifferenceDerivative::grid"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[243539, 8156, 133, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
Cell[243675, 8159, 289, 4, 53, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
Cell[243967, 8165, 169, 4, 24, "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],

Cell[CellGroupData[{
Cell[244161, 8173, 90, 1, 38, "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
Cell[244254, 8176, 182, 4, 24, "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],

Cell[CellGroupData[{
Cell[244461, 8184, 214, 4, 42, "Input",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
Cell[244678, 8190, 322, 5, 53, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
Cell[245003, 8197, 242, 5, 37, "Output",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"]
}, Open  ]],
Cell[245260, 8205, 182, 4, 24, "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],

Cell[CellGroupData[{
Cell[245467, 8213, 290, 5, 58, "Input",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
Cell[245760, 8220, 340, 6, 53, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"],
Cell[246103, 8228, 377, 7, 53, "Output",
  CellTags->"NDSolve`FiniteDifferenceDerivative::aord"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[246541, 8242, 131, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],
Cell[246675, 8245, 274, 4, 37, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],
Cell[246952, 8251, 168, 4, 24, "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],

Cell[CellGroupData[{
Cell[247145, 8259, 89, 1, 38, "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],
Cell[247237, 8262, 181, 4, 24, "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],

Cell[CellGroupData[{
Cell[247443, 8270, 218, 4, 42, "Input",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],
Cell[247664, 8276, 292, 5, 53, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"],
Cell[247959, 8283, 246, 5, 37, "Output",
  CellTags->"NDSolve`FiniteDifferenceDerivative::per"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[248266, 8295, 131, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spu"],
Cell[248400, 8298, 330, 5, 53, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spu"],
Cell[248733, 8305, 168, 4, 24, "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spu"]
}, Open  ]],

Cell[CellGroupData[{
Cell[248938, 8314, 131, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],
Cell[249072, 8317, 418, 7, 69, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],
Cell[249493, 8326, 168, 4, 24, "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],

Cell[CellGroupData[{
Cell[249686, 8334, 89, 1, 38, "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],
Cell[249778, 8337, 181, 4, 24, "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],

Cell[CellGroupData[{
Cell[249984, 8345, 220, 4, 42, "Input",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],
Cell[250207, 8351, 434, 7, 69, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"],
Cell[250644, 8360, 251, 5, 37, "Output",
  CellTags->"NDSolve`FiniteDifferenceDerivative::spc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[250956, 8372, 133, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],
Cell[251092, 8375, 277, 4, 37, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],
Cell[251372, 8381, 169, 4, 24, "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],

Cell[CellGroupData[{
Cell[251566, 8389, 90, 1, 38, "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],
Cell[251659, 8392, 182, 4, 24, "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],

Cell[CellGroupData[{
Cell[251866, 8400, 208, 4, 42, "Input",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],
Cell[252077, 8406, 289, 5, 53, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"],
Cell[252369, 8413, 202, 4, 21, "Output",
  CellTags->"NDSolve`FiniteDifferenceDerivative::conw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[252632, 8424, 137, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],
Cell[252772, 8427, 327, 5, 53, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],
Cell[253102, 8434, 191, 4, 24, "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],

Cell[CellGroupData[{
Cell[253318, 8442, 92, 1, 38, "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],
Cell[253413, 8445, 184, 4, 24, "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],

Cell[CellGroupData[{
Cell[253622, 8453, 210, 4, 42, "Input",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],
Cell[253835, 8459, 326, 6, 53, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"],
Cell[254164, 8467, 232, 6, 21, "Output",
  CellTags->"NDSolve`FiniteDifferenceDerivative::ordred"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[254457, 8480, 151, 2, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],
Cell[254611, 8484, 252, 4, 37, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],
Cell[254866, 8490, 177, 4, 24, "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],

Cell[CellGroupData[{
Cell[255068, 8498, 98, 1, 38, "ExampleSection",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],
Cell[255169, 8501, 190, 4, 24, "Text",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],

Cell[CellGroupData[{
Cell[255384, 8509, 199, 4, 26, "Input",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],
Cell[255586, 8515, 276, 5, 37, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"],
Cell[255865, 8522, 280, 7, 21, "Output",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::ddim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[256206, 8536, 153, 2, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::spnum"],
Cell[256362, 8540, 312, 5, 37, "Message",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::spnum"],
Cell[256677, 8547, 178, 4, 24, "Notes",
  CellTags->"NDSolve`FiniteDifferenceDerivativeFunction::spnum"]
}, Open  ]],

Cell[CellGroupData[{
Cell[256892, 8556, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::bcuns"],
Cell[256976, 8559, 177, 3, 21, "Message",
  CellTags->"NDSolve::bcuns"],
Cell[257156, 8564, 152, 4, 24, "Notes",
  CellTags->"NDSolve::bcuns"],

Cell[CellGroupData[{
Cell[257333, 8572, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::bcuns"],
Cell[257400, 8575, 158, 4, 24, "Text",
  CellTags->"NDSolve::bcuns"],

Cell[CellGroupData[{
Cell[257583, 8583, 314, 6, 58, "Input",
  CellTags->"NDSolve::bcuns"],
Cell[257900, 8591, 263, 5, 37, "Message",
  CellTags->"NDSolve::bcuns"],
Cell[258166, 8598, 1063, 28, 41, "Output",
  CellTags->"NDSolve::bcuns"]
}, Open  ]],
Cell[259244, 8629, 141, 4, 24, "Text",
  CellTags->"NDSolve::bcuns"],

Cell[CellGroupData[{
Cell[259410, 8637, 304, 6, 58, "Input",
  CellTags->"NDSolve::bcuns"],
Cell[259717, 8645, 290, 8, 21, "Output",
  CellTags->"NDSolve::bcuns"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[260068, 8660, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::dvout"],
Cell[260152, 8663, 197, 3, 21, "Message",
  CellTags->"NDSolve::dvout"],
Cell[260352, 8668, 125, 4, 24, "Notes",
  CellTags->"NDSolve::dvout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[260514, 8677, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::idobj"],
Cell[260598, 8680, 163, 3, 21, "Message",
  CellTags->"NDSolve::idobj"],
Cell[260764, 8685, 125, 4, 24, "Notes",
  CellTags->"NDSolve::idobj"]
}, Open  ]],

Cell[CellGroupData[{
Cell[260926, 8694, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ivdae"],
Cell[261010, 8697, 298, 6, 53, "Message",
  CellTags->"NDSolve::ivdae"],
Cell[261311, 8705, 191, 6, 24, "Notes",
  CellTags->"NDSolve::ivdae"],

Cell[CellGroupData[{
Cell[261527, 8715, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::ivdae"],
Cell[261594, 8718, 177, 6, 24, "Text",
  CellTags->"NDSolve::ivdae"],

Cell[CellGroupData[{
Cell[261796, 8728, 272, 6, 42, "Input",
  CellTags->"NDSolve::ivdae"],
Cell[262071, 8736, 281, 6, 53, "Message",
  CellTags->"NDSolve::ivdae"],
Cell[262355, 8744, 753, 19, 37, "Output",
  CellTags->"NDSolve::ivdae"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[263169, 8770, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ivres"],
Cell[263253, 8773, 495, 9, 85, "Message",
  CellTags->"NDSolve::ivres"],
Cell[263751, 8784, 125, 4, 24, "Notes",
  CellTags->"NDSolve::ivres"]
}, Open  ]],

Cell[CellGroupData[{
Cell[263913, 8793, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndtola"],
Cell[263999, 8796, 286, 5, 53, "Message",
  CellTags->"NDSolve::ndtola"],
Cell[264288, 8803, 126, 4, 24, "Notes",
  CellTags->"NDSolve::ndtola"]
}, Open  ]],

Cell[CellGroupData[{
Cell[264451, 8812, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::nfnan"],
Cell[264535, 8815, 254, 4, 37, "Message",
  CellTags->"NDSolve::nfnan"],
Cell[264792, 8821, 196, 5, 24, "Notes",
  CellTags->"NDSolve::nfnan"],

Cell[CellGroupData[{
Cell[265013, 8830, 64, 1, 38, "ExampleSection",
  CellTags->"NDSolve::nfnan"],
Cell[265080, 8833, 212, 7, 24, "Text",
  CellTags->"NDSolve::nfnan"],

Cell[CellGroupData[{
Cell[265317, 8844, 248, 5, 42, "Input",
  CellTags->"NDSolve::nfnan"],
Cell[265568, 8851, 307, 6, 55, "Message",
  CellTags->"NDSolve::nfnan"],
Cell[265878, 8859, 201, 5, 21, "Message",
  CellTags->"NDSolve::nfnan"],
Cell[266082, 8866, 278, 8, 21, "Output",
  CellTags->"NDSolve::nfnan"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[266421, 8881, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::nfp"],
Cell[266501, 8884, 271, 5, 37, "Message",
  CellTags->"NDSolve::nfp"],
Cell[266775, 8891, 123, 4, 24, "Notes",
  CellTags->"NDSolve::nfp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[266935, 8900, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::nodv"],
Cell[267017, 8903, 407, 7, 69, "Message",
  CellTags->"NDSolve::nodv"],
Cell[267427, 8912, 124, 4, 24, "Notes",
  CellTags->"NDSolve::nodv"],

Cell[CellGroupData[{
Cell[267576, 8920, 63, 1, 38, "ExampleSection",
  CellTags->"NDSolve::nodv"],
Cell[267642, 8923, 202, 5, 24, "Text",
  CellTags->"NDSolve::nodv"],

Cell[CellGroupData[{
Cell[267869, 8932, 141, 3, 26, "Input",
  CellTags->"NDSolve::nodv"],
Cell[268013, 8937, 368, 7, 85, "Message",
  CellTags->"NDSolve::nodv"],
Cell[268384, 8946, 384, 11, 21, "Output",
  CellTags->"NDSolve::nodv"]
}, Open  ]],
Cell[268783, 8960, 105, 1, 24, "Text",
  CellTags->"NDSolve::nodv"],

Cell[CellGroupData[{
Cell[268913, 8965, 155, 4, 26, "Input",
  CellTags->"NDSolve::nodv"],
Cell[269071, 8971, 277, 8, 21, "Output",
  CellTags->"NDSolve::nodv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[269409, 8986, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::noout"],
Cell[269493, 8989, 175, 3, 21, "Message",
  CellTags->"NDSolve::noout"],
Cell[269671, 8994, 125, 4, 24, "Notes",
  CellTags->"NDSolve::noout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[269833, 9003, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::pdeopt"],
Cell[269919, 9006, 183, 3, 21, "Message",
  CellTags->"NDSolve::pdeopt"],
Cell[270105, 9011, 126, 4, 24, "Notes",
  CellTags->"NDSolve::pdeopt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[270268, 9020, 117, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`ProcessSolutions::nodata"],
Cell[270388, 9023, 234, 4, 37, "Message",
  CellTags->"NDSolve`ProcessSolutions::nodata"],
Cell[270625, 9029, 143, 4, 24, "Notes",
  CellTags->"NDSolve`ProcessSolutions::nodata"]
}, Open  ]],

Cell[CellGroupData[{
Cell[270805, 9038, 115, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::fnnan"],
Cell[270923, 9041, 244, 4, 37, "Message",
  CellTags->"NDSolve`ScaledVectorNorm::fnnan"],
Cell[271170, 9047, 142, 4, 24, "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::fnnan"]
}, Open  ]],

Cell[CellGroupData[{
Cell[271349, 9056, 111, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::nfp"],
Cell[271463, 9059, 259, 4, 37, "Message",
  CellTags->"NDSolve`ScaledVectorNorm::nfp"],
Cell[271725, 9065, 140, 4, 24, "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::nfp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[271902, 9074, 113, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::nvec"],
Cell[272018, 9077, 170, 3, 21, "Message",
  CellTags->"NDSolve`ScaledVectorNorm::nvec"],
Cell[272191, 9082, 141, 4, 24, "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::nvec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[272369, 9091, 113, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::pinp"],
Cell[272485, 9094, 320, 5, 53, "Message",
  CellTags->"NDSolve`ScaledVectorNorm::pinp"],
Cell[272808, 9101, 141, 4, 24, "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::pinp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[272986, 9110, 113, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::sinp"],
Cell[273102, 9113, 227, 4, 37, "Message",
  CellTags->"NDSolve`ScaledVectorNorm::sinp"],
Cell[273332, 9119, 141, 4, 24, "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::sinp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[273510, 9128, 113, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve`ScaledVectorNorm::tinp"],
Cell[273626, 9131, 331, 5, 53, "Message",
  CellTags->"NDSolve`ScaledVectorNorm::tinp"],
Cell[273960, 9138, 141, 4, 24, "Notes",
  CellTags->"NDSolve`ScaledVectorNorm::tinp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[274138, 9147, 162, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NDSolve::urange", "NDSolve`ScaledVectorNorm::urange"}],
Cell[274303, 9153, 368, 9, 37, "Message",
  CellTags->{"NDSolve::urange", "NDSolve`ScaledVectorNorm::urange"}],
Cell[274674, 9164, 164, 4, 24, "Notes",
  CellTags->{"NDSolve::urange", "NDSolve`ScaledVectorNorm::urange"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[274875, 9173, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::eord"],
Cell[274957, 9176, 246, 4, 37, "Message",
  CellTags->"NDSolve::eord"],
Cell[275206, 9182, 124, 4, 24, "Notes",
  CellTags->"NDSolve::eord"]
}, Open  ]],

Cell[CellGroupData[{
Cell[275367, 9191, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::ndstab"],
Cell[275453, 9194, 210, 6, 21, "Message",
  CellTags->"NDSolve::ndstab"],
Cell[275666, 9202, 126, 4, 24, "Notes",
  CellTags->"NDSolve::ndstab"]
}, Open  ]],

Cell[CellGroupData[{
Cell[275829, 9211, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::maxsts"],
Cell[275915, 9214, 225, 5, 37, "Message",
  CellTags->"NDSolve::maxsts"],
Cell[276143, 9221, 126, 4, 24, "Notes",
  CellTags->"NDSolve::maxsts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[276306, 9230, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NDSolve::mtdp"],
Cell[276388, 9233, 203, 5, 37, "Message",
  CellTags->"NDSolve::mtdp"],
Cell[276594, 9240, 124, 4, 24, "Notes",
  CellTags->"NDSolve::mtdp"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

