(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     43508,       1508]*)
(*NotebookOutlinePosition[     82818,       2334]*)
(*  CellTagsIndexPosition[     80780,       2277]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["NMinimize", "Title"],

Cell[CellGroupData[{

Cell["\<\
NMinimize::bcons
NMaximize::bcons\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"bcons\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
        "following", " ", "constraints", " ", "are", " ", "not", " ", 
        RowBox[{"valid", ":", " ", 
          RowBox[{
            RowBox[{
              StyleBox["expr",
                "TI"], ".", " ", "Constraints"}], " ", "should", " ", "be", 
            " ", "equalities"}]}]}], ",", " ", "inequalities", ",", 
      " ", \(or\ domain\ specifications\ involving\ the\ \(\(variables\)\(.\)\
\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated elements within the \
first argument of ",
  StyleBox["NMinimize", "MR"],
  " or ",
  StyleBox["NMaximize", "MR"],
  " do not have the indicated form.\n\[FilledSmallSquare] If first argument \
in ",
  StyleBox["NMinimize", "MR"],
  " or ",
  StyleBox["NMaximize", "MR"],
  " is a list, the first element in that list is expected to be a numerical \
expression, and the remaining elements are expected to be constraints."
}], "Notes",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[TextData[{
  "This message can be generated if the constraints are not given in a valid \
form. In this example, you could use ",
  StyleBox["Element[x,Reals]", "MR"],
  " to indicate that ",
  StyleBox["x", "MR"],
  " is real."
}], "Text",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x^2, Real[x]}, {x}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[BoxData[
    \(NMinimize::"bcons" \(\(:\)\(\ \)\) 
      "The following constraints are not valid: \!\({\(Real[x]\)}\). \
Constraints should be equalities, inequalities, or domain specifications \
involving the variables."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NMaximize::bcons", "NMinimize::bcons"}],

Cell[BoxData[
    \(NMinimize[{x\^2, Real[x]}, {x}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NMaximize::bcons", "NMinimize::bcons"}]
}, Open  ]],

Cell[TextData[{
  "This message can also be generated if the function to minimize is not the \
first element in the first argument of ",
  StyleBox["NMinimize", "MR"],
  "."
}], "Text",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x \[GreaterEqual] 1, x^2}, {x}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[BoxData[
    \(NMinimize::"bcons" \(\(:\)\(\ \)\) 
      "The following constraints are not valid: \!\({x\^2}\). Constraints \
should be equalities, inequalities, or domain specifications involving the \
variables."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"NMaximize::bcons", "NMinimize::bcons"}],

Cell[BoxData[
    \(NMinimize[{x \[GreaterEqual] 1, x\^2}, {x}]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"NMaximize::bcons", "NMinimize::bcons"}]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["NMinimize", "MR"],
  " with a constraint."
}], "Text",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x^2, x \[GreaterEqual] 3}, {x}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[BoxData[
    \({9.`, {x \[Rule] 3.`}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"NMaximize::bcons", "NMinimize::bcons"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::lvar
NMaximize::lvar\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"lvar\"\>"}], \(\(:\)\(\ \)\), "Variables", " ", 
        
        StyleBox["expr",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "list", " ", "of", 
        " ", "variables"}], ",", 
      " ", \(with\ each\ element\ being\ a\ variable\), ",", 
      " ", \(or\ a\ list\ containing\ a\ variable\ and\ lower\ and\ upper\ \
bounds\ for\ the\ starting\ region\ for\ that\ \(\(variable\)\(.\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["NMinimize", "MR"],
  " or ",
  StyleBox["NMaximize", "MR"],
  " is not a list of valid variables or a list of valid variables with upper \
and lower bounds for each variable.\n\[FilledSmallSquare] Symbols and \
expressions that do not have some other meaning are usually valid variables. \
Numbers, strings, lists, inequalities, sums, powers, and products are not \
valid variables.\n\[FilledSmallSquare] Upper and lower bounds for a variable \
are specified using a list, such as ",
  StyleBox["{x,1,2}", "MR"],
  "."
}], "Notes",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],

Cell[TextData[{
  "An error message will be generated if constraints are entered in the \
second argument of ",
  StyleBox["NMinimize", "MR"],
  ". The second argument in ",
  StyleBox["NMinimize", "MR"],
  " is treated as the specification of the variables. An inequality is not a \
valid variable."
}], "Text",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[x^2, {x \[GreaterEqual] 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],

Cell[BoxData[
    \(NMinimize::"lvar" \(\(:\)\(\ \)\) 
      "Variables \!\({x \[GreaterEqual] 3}\) should be a list of variables, \
with each element being a variable, or a list containing a variable and lower \
and upper bounds for the starting region for that variable."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NMaximize::lvar", "NMinimize::lvar"}],

Cell[BoxData[
    \(NMinimize[x\^2, {x \[GreaterEqual] 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NMaximize::lvar", "NMinimize::lvar"}]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["NMinimize", "MR"],
  "."
}], "Text",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x^2, x \[GreaterEqual] 3}, {x}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],

Cell[BoxData[
    \({9.`, {x \[Rule] 3.`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"NMaximize::lvar", "NMinimize::lvar"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NMinimize::cnft", "ObjectNameWarningMessages",
  CellTags->"NMinimize::cnft"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NMinimize::"cnft"\), \(\(:\)\(\ \)\), "The", " ", "point", 
        " ", 
        StyleBox["e1",
          "TI"], " ", "better", " ", "satisfies", " ", "the", " ", 
        "constraints"}], ",", " ", 
      RowBox[{"but", " ", "evaluates", " ", "to", " ", 
        StyleBox["e2",
          "TI"], " ", "which", " ", "is", " ", "larger", " ", "than", " ", 
        "the", " ", "final", " ", \(\(result\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NMinimize::cnft"],

Cell["\<\
\[FilledSmallSquare] This message can be generated if the \
constraints are inconsistent or can only be satisfied approximately.\
\>", \
"Notes",
  CellTags->"NMinimize::cnft"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NMaximize::cnft", "ObjectNameWarningMessages",
  CellTags->"NMaximize::cnft"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NMaximize::"cnft"\), \(\(:\)\(\ \)\), "The", " ", "point", 
        " ", 
        StyleBox["e1",
          "TI"], " ", "better", " ", "satisfies", " ", "the", " ", 
        "constraints"}], ",", " ", 
      RowBox[{"but", " ", "evaluates", " ", "to", " ", 
        StyleBox["e2",
          "TI"], " ", "which", " ", "is", " ", "smaller", " ", "than", " ", 
        "the", " ", "final", " ", \(\(result\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NMaximize::cnft"],

Cell["\<\
\[FilledSmallSquare] This message can be generated if the \
constraints are inconsistent or can only be satisfied approximately.\
\>", \
"Notes",
  CellTags->"NMaximize::cnft"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::parchange
NMaximize::parchange\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], "::", "\<\"parchange\"\>"}], \(\(:\)\(\ \)\), 
          "Inappropriate", " ", 
          RowBox[{"parameter", ":", " ", 
            StyleBox["opt",
              "TI"]}]}], " ", "->", " ", 
        StyleBox["val1",
          "TI"]}], ",", " ", 
      RowBox[{"changed", " ", "to", " ", 
        RowBox[{
          StyleBox["val2",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],

Cell["\<\
\[FilledSmallSquare] Generated when the value of the indicated \
option is not valid.\
\>", "Notes",
  CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],

Cell[TextData[{
  "A message is generated in this example because ",
  StyleBox["1", "MR"],
  " is not a valid value for the \"",
  StyleBox["PostProcess\"", "MR"],
  " option."
}], "Text",
  CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[Sin[x], x, 
      Method \[Rule] {"\<NelderMead\>", "\<PostProcess\>" \[Rule] 
            1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],

Cell[BoxData[
    \(NMinimize::"parchange" \(\(:\)\(\ \)\) 
      "Inappropriate parameter: \!\(\"PostProcess\"\) -> \!\(1\), changed to \
\!\(Automatic\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NMaximize::parchange", "NMinimize::parchange"}],

Cell[BoxData[
    \({\(-1.`\), {x \[Rule] \(-1.5707963267948966`\)}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NMaximize::parchange", "NMinimize::parchange"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::maxit
NMaximize::maxit\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"maxit\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
MaxIterations\  -> \ `1`\ should\ be\ a\ non - 
          negative\ integer\ or\ \(\(Automatic\)\(.\)\)\)}]], "Message",
  CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MaxIterations", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],

Cell[TextData[{
  "A message is generated in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["MaxIterations", "MR"],
  " option."
}], "Text",
  CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[Cos[x], {x}, MaxIterations \[Rule] None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],

Cell[BoxData[
    \(NMinimize::"maxit" \(\(:\)\(\ \)\) 
      "Value of option MaxIterations -> \!\(None\) should be a non-negative \
integer or Automatic."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NMaximize::maxit", "NMinimize::maxit"}],

Cell[BoxData[
    \(NMinimize[Cos[x], {x}, MaxIterations \[Rule] None]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NMaximize::maxit", "NMinimize::maxit"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::nosat
NMaximize::nosat\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], 
          "::", "\<\"nosat\"\>"}], \(\(:\)\(\ \)\), \(Obtained\ solution\ \
does\ not\ satisfy\ the\ following\ constraints\ within\ Tolerance\)}], " ", "->",
       " ", 
      RowBox[{
        StyleBox["tol",
          "TI"], ":", " ", 
        RowBox[{
          StyleBox["constraint",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated constraints are \
not satisfied by the result.
\[FilledSmallSquare] This message will normally occur only if the constraints \
are inconsistent.\
\>", "Notes",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],

Cell["\<\
A warning is generated in this example because the result does not \
satisfy the indicated equality constraint.\
\>", "Text",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x\^2, 
        x\^2 \[Equal] 5 && \(-2\) \[LessEqual] x \[LessEqual] 
            2}, {x}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],

Cell[BoxData[
    \(NMinimize::"nosat" \(\(:\)\(\ \)\) 
      "Obtained solution does not satisfy the following constraints within \
Tolerance -> \!\(0.001`\): \!\({\(\(5 - x\^2\)\) \[Equal] 0}\)."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],

Cell[BoxData[
    \({4.`, {x \[Rule] \(-2.`\)}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}]
}, Open  ]],

Cell["\<\
A warning is generated in this example because the result does not \
satisfy the indicated inequality constraint.\
\>", "Text",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x\^2, \ 
        x\^2 \[GreaterEqual] 3\  && \ \(-2\) \[LessEqual] x\^2 \[LessEqual] 
            2}, \ {x}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],

Cell[BoxData[
    \(NMinimize::"incst" \(\(:\)\(\ \)\) 
      "\!\(NMinimize\) was unable to generate any initial points satisfying \
the inequality constraints \!\({\(\(\(\(-2\)\) - x\^2\)\), \(\(3 - x\^2\)\), \
\(\(\(\(-2\)\) + x\^2\)\)}\). The initial region specified may not contain \
any feasible points. Changing the initial region or specifying explicit \
initial points may provide a better solution."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],

Cell[BoxData[
    \(NMinimize::"incst" \(\(:\)\(\ \)\) 
      "\!\(NMinimize\) was unable to generate any initial points satisfying \
the inequality constraints \!\({\(\(\(\(-2\)\) - x\^2\)\), \(\(3 - x\^2\)\), \
\(\(\(\(-2\)\) + x\^2\)\)}\). The initial region specified may not contain \
any feasible points. Changing the initial region or specifying explicit \
initial points may provide a better solution."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],

Cell[BoxData[
    \(NMinimize::"nosat" \(\(:\)\(\ \)\) 
      "Obtained solution does not satisfy the following constraints within \
Tolerance -> \!\(0.001`\): \!\({\(\(\(\(3 - x\^2\)\) \[LessEqual] 0\)\), \(\(\
\(\(\(\(-2\)\) + x\^2\)\) \[LessEqual] 0\)\)}\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],

Cell[BoxData[
    \({2.44599226186209`, {x \[Rule] \(-1.5639668352820306`\)}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}]
}, Open  ]],

Cell["\<\
A warning message is generated in this example because the \
constraints are inconsistent.\
\>", "Text",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x\^2, \ 
        x\^2 \[Equal] 5\  && \ \(-2\) \[LessEqual] x \[LessEqual] 
            2}, \ {x}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],

Cell[BoxData[
    \(NMinimize::"nosat" \(\(:\)\(\ \)\) 
      "Obtained solution does not satisfy the following constraints within \
Tolerance -> \!\(0.001`\): \!\({\(\(5 - x\^2\)\) \[Equal] 0}\)."\)], "Message",\

  CellLabel->"From In[3]:=",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],

Cell[BoxData[
    \({4.`, {x \[Rule] \(-2.`\)}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::workprec
NMaximize::workprec\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::workprec", "NMaximize::workprec"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"workprec\"\>"}], \(\(:\)\(\ \)\), \(Precision\ of\ the\ \
input\ is\ less\ than\ WorkingPrecision . \ 
          Precision\ of\ the\ input\ will\ be\ used\ in\ \(\(computation\)\(.\
\)\)\)}]], "Message",
  CellTags->{"NMinimize::workprec", "NMaximize::workprec"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"NMinimize::workprec", "NMaximize::workprec"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::belt
NMaximize::belt\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"belt\"\>"}], \(\(:\)\(\ \)\), "Invalid", " ", 
      "integer", " ", 
      RowBox[{"elements", ":", " ", 
        RowBox[{
          RowBox[{
            StyleBox["expr",
              "TI"], ".", " ", "Currently"}], " ", "only", " ", "variables", 
          " ", "may", " ", "have", " ", "a", " ", "specified", 
          " ", \(\(domain\)\(.\)\)}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a constraint of the form ",
  StyleBox["Element[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[", Integers]", "MR"],
  " is encountered, and the expression ",
  StyleBox["expr", "TI"],
  " is not one of the variables."
}], "Notes",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],

Cell[TextData[{
  "An error occurs in this example because the product ",
  StyleBox["2x", "MR"],
  " is not one of the variables."
}], "Text",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{Cos[x], \ Element[2  x, \ Integers]}, \ {x}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],

Cell[BoxData[
    \(NMinimize::"belt" \(\(:\)\(\ \)\) 
      "Invalid integer elements: \!\({2\\ x}\). Currently only variables may \
have a specified domain."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NMaximize::belt", "NMinimize::belt"}],

Cell[BoxData[
    \({\[Infinity], {x \[Rule] Indeterminate}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NMaximize::belt", "NMinimize::belt"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["NMinimize", "MR"],
  " to minimize a function with the constraint that the variable be an \
integer."
}], "Text",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{Cos[x], \ Element[x, \ Integers]}, \ {x}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],

Cell[BoxData[
    \({\(-0.9899924966004454`\), {x \[Rule] 3}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"NMaximize::belt", "NMinimize::belt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::elmt
NMaximize::elmt\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"elmt\"\>"}], \(\(:\)\(\ \)\), \(Invalid\ variable\ domain \
. \ All\ variables\ must\ be\ either\ Integers\ or\ Reals\ \((Reals\ by\ \
\(\(default\)\(.\)\))\)\)}]], "Message",
  CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an ",
  StyleBox["Element", "MR"],
  " constraint is encountered in which the requested domain is other than ",
  StyleBox["Integers", "MR"],
  " or ",
  StyleBox["Reals", "MR"],
  "."
}], "Notes",
  CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Complexes", "MR"],
  " is not a valid domain for use in ",
  StyleBox["NMinimize", "MR"],
  "."
}], "Text",
  CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{Abs[z], Element[z, Complexes]}, {z}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],

Cell[BoxData[
    \(NMinimize::"elmt" \(\(:\)\(\ \)\) 
      "Invalid variable domain. All variables must be either Integers or \
Reals (Reals by default.)"\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NMaximize::elmt", "NMinimize::elmt"}],

Cell[BoxData[
    \(NMinimize[{Abs[z], z \[Element] Complexes}, {z}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NMaximize::elmt", "NMinimize::elmt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::incst
NMaximize::incst\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"incst\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["f",
          "TI"], " ", "was", " ", "unable", " ", "to", " ", "generate", " ", 
        "any", " ", "initial", " ", "points", " ", "satisfying", " ", "the", 
        " ", "inequality", " ", "constraints", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], ".", " ", "The"}], " ", "initial", " ", "region", " ", 
        "specified", " ", "may", " ", "not", " ", "contain", " ", "any", " ", 
        "feasible", " ", \(points . \ Changing\), " ", "the", " ", "initial", 
        " ", "region", " ", "or", " ", "specifying", " ", "explicit", " ", 
        "initial", " ", "points", " ", "may", " ", "provide", " ", "a", " ", 
        "better", " ", \(\(solution\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated function did not \
find any points that satisfy the constraints.
\[FilledSmallSquare] This error can occur if the constraints are \
inconsistent, or if the procedure used to find starting values for the \
variables does not find starting values that satisfy the constraints.\
\>", \
"Notes",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],

Cell["\<\
A warning is generated in this example because NMinimize uses a \
starting value that does not satisfy the constraint.\
\>", "Text",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x\^2, \ x\^2 \[GreaterEqual] 1}, \ {x}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],

Cell[BoxData[
    \(NMinimize::"incst" \(\(:\)\(\ \)\) 
      "\!\(NMinimize\) was unable to generate any initial points satisfying \
the inequality constraints \!\({1 - x\^2}\). The initial region specified may \
not contain any feasible points. Changing the initial region or specifying \
explicit initial points may provide a better solution."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NMaximize::incst", "NMinimize::incst"}],

Cell[BoxData[
    \({1.`, {x \[Rule] \(-1.`\)}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NMaximize::incst", "NMinimize::incst"}]
}, Open  ]],

Cell["\<\
This error can typically be avoided by providing starting values \
for the variable.\
\>", "Text",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x\^2, \ x\^2 \[GreaterEqual] 1}, \ {x, 1, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],

Cell[BoxData[
    \({1.`, {x \[Rule] 1.`}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"NMaximize::incst", "NMinimize::incst"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::bdmtd
NMaximize::bdmtd\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], 
            "::", "\<\"bdmtd\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
Method\)}], " ", "->", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "Automatic"}]}], ",", " ", 
      "DifferentialEvolution", ",", " ", "NelderMead", ",", " ", 
      "RandomSearch", ",", 
      " ", \(or\ \(\(SimulatedAnnealing\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when value provided for the ",
  StyleBox["Method", "MR"],
  " option is not among the indicated values."
}], "Notes",
  CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],

Cell[TextData[{
  "A warning message is generated in this example because ",
  StyleBox["All", "MR"],
  " is not a valid value for the ",
  StyleBox["Method", "MR"],
  " option."
}], "Text",
  CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[Cos[x], {x}, Method \[Rule] All]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],

Cell[BoxData[
    \(NMinimize::"bdmtd" \(\(:\)\(\ \)\) 
      "Value of option Method -> \!\(\"All\"\) is not Automatic, \
DifferentialEvolution, NelderMead, RandomSearch, or SimulatedAnnealing."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NMaximize::bdmtd", "NMinimize::bdmtd"}],

Cell[BoxData[
    \(NMinimize[Cos[x], {x}, Method \[Rule] All]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NMaximize::bdmtd", "NMinimize::bdmtd"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::nsol
NMaximize::nsol\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nsol\"\>"}], \(\(:\)\(\ \)\), "There", " ", "are",
       " ", "no", " ", "points", " ", "that", " ", "satisfy", " ", "the", " ",
       "constraints", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["NMinimize", "MR"],
  " or ",
  StyleBox["NMaximize", "MR"],
  " determines that the constraints are inconsistent."
}], "Notes",
  CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],

Cell["\<\
An error occurs in this example because the constraints are \
inconsistent.\
\>", "Text",
  CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NMinimize[{x\^2, \ 
        0 \[GreaterEqual] x\  && \ x \[GreaterEqual] 1}, \ {x}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],

Cell[BoxData[
    \(NMinimize::"nsol" \(\(:\)\(\ \)\) 
      "There are no points that satisfy the constraints \!\({\(\(x \
\[LessEqual] 0\)\), \(\(\(\(1 - x\)\) \[LessEqual] 0\)\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NMaximize::nsol", "NMinimize::nsol"}],

Cell[BoxData[
    \({\[Infinity], {x \[Rule] Indeterminate}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NMaximize::nsol", "NMinimize::nsol"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`Maximize::deprec", "ObjectNameWarningMessages",
  CellTags->"Experimental`Maximize::deprec"],

Cell[BoxData[
    \(Experimental`Maximize::"deprec" \(\(:\)\(\ \)\) \(Experimental`Maximize\
\ will\ not\ be\ supported\ in\ future\ versions\ of\ Mathematica . \ 
          Use\ System`Maximize\ \(\(instead\)\(.\)\)\)\)], "Message",
  CellTags->"Experimental`Maximize::deprec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Experimental`Maximize", "MR"],
  " is used in a version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " where the name of this function has been changed to ",
  StyleBox["System`Maximize", "MR"],
  "."
}], "Notes",
  CellTags->"Experimental`Maximize::deprec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Maximize::wksol", "ObjectNameWarningMessages",
  CellTags->"Maximize::wksol"],

Cell[BoxData[
    \(Maximize::"wksol" \(\(:\)\(\ \)\) 
      "Warning: There is no maximum in the region described by the \
contraints; returning a result on the boundary."\)], "Message",
  CellLabel->"From In[21]:=",
  CellTags->"Maximize::wksol"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when one or more inequality constraints in \
",
  StyleBox["Maximize", "MR"],
  " is satisfied as an equality."
}], "Notes",
  CellTags->"Maximize::wksol"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Maximize::wksol"],

Cell["\<\
A warning message is generated in this example because the maximum \
occurs when the constraint is satisfied as an equality.\
\>", "Text",
  CellTags->"Maximize::wksol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Maximize[x, x < 1, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Maximize::wksol"],

Cell[BoxData[
    \(Maximize::"wksol" \(\(:\)\(\ \)\) 
      "Warning: There is no maximum in the region described by the \
contraints; returning a result on the boundary."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Maximize::wksol"],

Cell[BoxData[
    \({1, {x \[Rule] 1}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Maximize::wksol"]
}, Open  ]],

Cell[TextData[{
  "This warning can be avoided by replacing ",
  Cell[BoxData[
      \(x < 1\)]],
  " with ",
  Cell[BoxData[
      \(x \[LessEqual] 1\)]],
  "."
}], "Text",
  CellTags->"Maximize::wksol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Maximize[x, x \[LessEqual] 1, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Maximize::wksol"],

Cell[BoxData[
    \({1, {x \[Rule] 1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Maximize::wksol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Maximize::natt", "ObjectNameWarningMessages",
  CellTags->"Maximize::natt"],

Cell[BoxData[
    \(Maximize::"natt" \(\(:\)\(\ \)\) \(The\ maximum\ is\ not\ attained\ at\ \
any\ point\ satisfying\ the\ given\ \(\(constraints\)\(.\)\(\ \)\)\)\)], \
"Message",
  CellTags->"Maximize::natt"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Maximize::natt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Maximize::nopmet
Minimize::nopmet
Experimental`Infimum::nopmet
Experimental`Supremum::nopmet\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
    "Experimental`Supremum::nopmet"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nopmet\"\>"}], \(\(:\)\(\ \)\), \(This\ optimization\ \
problem\ cannot\ be\ solved\ with\ methods\ available\ to\ \
\(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
    "Experimental`Supremum::nopmet"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
    "Experimental`Supremum::nopmet"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Maximize::noobj
Minimize::noobj
Experimental`Infimum::noobj
Experimental`Supremum::noobj\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
    "Experimental`Supremum::noobj"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"noobj\"\>"}], \(\(:\)\(\ \)\), \(No\ objective\ function\ \
\(\(specified\)\(.\)\)\)}]], "Message",
  CellTags->{
  "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
    "Experimental`Supremum::noobj"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
    "Experimental`Supremum::noobj"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Experimental`Minimize::deprec", "ObjectNameWarningMessages",
  CellTags->"Experimental`Minimize::deprec"],

Cell[BoxData[
    \(Experimental`Minimize::"deprec" \(\(:\)\(\ \)\) \(Experimental`Minimize\
\ will\ not\ be\ supported\ in\ future\ versions\ of\ Mathematica . \ 
          Use\ System`Minimize\ \(\(instead\)\(.\)\)\)\)], "Message",
  CellTags->"Experimental`Minimize::deprec"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`Minimize::deprec"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Minimize::wksol", "ObjectNameWarningMessages",
  CellTags->"Minimize::wksol"],

Cell[BoxData[
    \(Minimize::"wksol" \(\(:\)\(\ \)\) \(Warning : \ 
        There\ is\ no\ minimum\ in\ the\ region\ described\ by\ the\ \
contraints; \ 
      returning\ a\ result\ on\ the\ \(\(boundary\)\(.\)\)\)\)], "Message",
  CellTags->"Minimize::wksol"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when one or more inequality constraints in \
",
  StyleBox["Minimize", "MR"],
  " is satisfied as an equality."
}], "Notes",
  CellTags->"Minimize::wksol"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Minimize::wksol"],

Cell["\<\
A warning message is generated in this example because the minimum \
occurs when the constraint is satisfied as an equality.\
\>", "Text",
  CellTags->"Minimize::wksol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Minimize[x, x > 1, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Minimize::wksol"],

Cell[BoxData[
    \(Minimize::"wksol" \(\(:\)\(\ \)\) 
      "Warning: There is no minimum in the region described by the \
contraints; returning a result on the boundary."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Minimize::wksol"],

Cell[BoxData[
    \({1, {x \[Rule] 1}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Minimize::wksol"]
}, Open  ]],

Cell[TextData[{
  "This warning can be avoided by replacing ",
  Cell[BoxData[
      \(x > 1\)]],
  " with ",
  Cell[BoxData[
      \(x \[GreaterEqual] 1\)]],
  "."
}], "Text",
  CellTags->"Minimize::wksol"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Minimize[x, x \[GreaterEqual] 1, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Minimize::wksol"],

Cell[BoxData[
    \({1, {x \[Rule] 1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Minimize::wksol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Minimize::natt", "ObjectNameWarningMessages",
  CellTags->"Minimize::natt"],

Cell[BoxData[
    \(Minimize::"natt" \(\(:\)\(\ \)\) \(The\ minimum\ is\ not\ attained\ at\ \
any\ point\ satisfying\ the\ given\ \(\(constraints\)\(.\)\)\)\)], "Message",
  CellTags->"Minimize::natt"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Minimize::natt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::cvmit
NMaximize::cvmit\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::cvmit", "NMaximize::cvmit"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"cvmit\"\>"}], \(\(:\)\(\ \)\), \(Failed\ to\ converge\ to\ \
the\ requested\ accuracy\ or\ precision\ within\ `1`\ \(\(iterations\)\(.\)\)\
\)}]], "Message",
  CellTags->{"NMinimize::cvmit", "NMaximize::cvmit"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"NMinimize::cvmit", "NMaximize::cvmit"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::cvdiv
NMaximize::cvdiv\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::cvdiv", "NMaximize::cvdiv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"cvdiv\"\>"}], \(\(:\)\(\ \)\), \(Failed\ to\ converge\ to\ \
a\ solution . \ \ The\ function\ may\ be\ \(\(unbounded\)\(.\)\)\)}]], \
"Message",
  CellTags->{"NMinimize::cvdiv", "NMaximize::cvdiv"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"NMinimize::cvdiv", "NMaximize::cvdiv"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::ropn
NMaximize::ropn\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::ropn", "NMaximize::ropn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ropn\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ `1`\  \
-> \ `2`\ should\ be\ a\ non - 
          negative\ real\ \(\(number\)\(.\)\)\)}]], "Message",
  CellTags->{"NMinimize::ropn", "NMaximize::ropn"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"NMinimize::ropn", "NMaximize::ropn"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::roprl
NMaximize::roprl\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::roprl", "NMaximize::roprl"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"roprl\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ `1`\  \
-> \ `2`\ should\ be\ a\ real\ number\ x\ greater\ than\ `3`\  <= \ \
\(\(x\)\(.\)\)\)}]], "Message",
  CellTags->{"NMinimize::roprl", "NMaximize::roprl"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"NMinimize::roprl", "NMaximize::roprl"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::roprlu
NMaximize::roprlu\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::roprlu", "NMaximize::roprlu"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"roprlu\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ `1`\  \
-> \ `2`\ should\ be\ a\ real\ number\ between\ `3`\ and\ \
\(\(`4`\)\(.\)\)\)}]], "Message",
  CellTags->{"NMinimize::roprlu", "NMaximize::roprlu"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"NMinimize::roprlu", "NMaximize::roprlu"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::rseed
NMaximize::rseed\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::rseed", "NMaximize::rseed"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"rseed\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
RandomSeed\  -> \ `1`\ is\ not\ an\ integer\ or\ \(\(Automatic\)\(.\)\)\)}]], \
"Message",
  CellTags->{"NMinimize::rseed", "NMaximize::rseed"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"NMinimize::rseed", "NMaximize::rseed"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NMinimize::ubnd
NMaximize::ubnd\
\>", "ObjectNameWarningMessages",
  CellTags->{"NMinimize::ubnd", "NMaximize::ubnd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ubnd\"\>"}], \(\(:\)\(\ \)\), \(The\ problem\ is\ \
\(\(unbounded\)\(.\)\)\)}]], "Message",
  CellTags->{"NMinimize::ubnd", "NMaximize::ubnd"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"NMinimize::ubnd", "NMaximize::ubnd"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 975}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{641, 517},
WindowMargins->{{Automatic, 10}, {Automatic, 46}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "NMinimize::bcons"->{
    Cell[1827, 57, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[1962, 63, 692, 17, 53, "Message",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[2657, 82, 556, 14, 78, "Notes",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[3238, 100, 88, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[3329, 103, 299, 8, 40, "Text",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[3653, 115, 141, 3, 26, "Input",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[3797, 120, 325, 6, 69, "Message",
      CellTags->{"NMaximize::bcons", "NMinimize::bcons"}],
    Cell[4125, 128, 143, 3, 23, "Output",
      CellTags->{"NMaximize::bcons", "NMinimize::bcons"}],
    Cell[4283, 134, 239, 6, 40, "Text",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[4547, 144, 153, 3, 26, "Input",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[4703, 149, 318, 6, 71, "Message",
      CellTags->{"NMaximize::bcons", "NMinimize::bcons"}],
    Cell[5024, 157, 155, 3, 23, "Output",
      CellTags->{"NMaximize::bcons", "NMinimize::bcons"}],
    Cell[5194, 163, 170, 5, 24, "Text",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[5389, 172, 153, 3, 26, "Input",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[5545, 177, 134, 3, 21, "Output",
      CellTags->{"NMaximize::bcons", "NMinimize::bcons"}]},
  "NMaximize::bcons"->{
    Cell[1827, 57, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[1962, 63, 692, 17, 53, "Message",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[2657, 82, 556, 14, 78, "Notes",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[3238, 100, 88, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[3329, 103, 299, 8, 40, "Text",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[3653, 115, 141, 3, 26, "Input",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[3797, 120, 325, 6, 69, "Message",
      CellTags->{"NMaximize::bcons", "NMinimize::bcons"}],
    Cell[4125, 128, 143, 3, 23, "Output",
      CellTags->{"NMaximize::bcons", "NMinimize::bcons"}],
    Cell[4283, 134, 239, 6, 40, "Text",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[4547, 144, 153, 3, 26, "Input",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[4703, 149, 318, 6, 71, "Message",
      CellTags->{"NMaximize::bcons", "NMinimize::bcons"}],
    Cell[5024, 157, 155, 3, 23, "Output",
      CellTags->{"NMaximize::bcons", "NMinimize::bcons"}],
    Cell[5194, 163, 170, 5, 24, "Text",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[5389, 172, 153, 3, 26, "Input",
      CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
    Cell[5545, 177, 134, 3, 21, "Output",
      CellTags->{"NMaximize::bcons", "NMinimize::bcons"}]},
  "NMinimize::lvar"->{
    Cell[5740, 187, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[5871, 193, 645, 16, 53, "Message",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[6519, 211, 676, 14, 100, "Notes",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[7220, 229, 86, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[7309, 232, 364, 9, 40, "Text",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[7698, 245, 146, 3, 26, "Input",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[7847, 250, 369, 6, 69, "Message",
      CellTags->{"NMaximize::lvar", "NMinimize::lvar"}],
    Cell[8219, 258, 148, 3, 23, "Output",
      CellTags->{"NMaximize::lvar", "NMinimize::lvar"}],
    Cell[8382, 264, 150, 5, 24, "Text",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[8557, 273, 151, 3, 26, "Input",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[8711, 278, 132, 3, 21, "Output",
      CellTags->{"NMaximize::lvar", "NMinimize::lvar"}]},
  "NMaximize::lvar"->{
    Cell[5740, 187, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[5871, 193, 645, 16, 53, "Message",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[6519, 211, 676, 14, 100, "Notes",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[7220, 229, 86, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[7309, 232, 364, 9, 40, "Text",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[7698, 245, 146, 3, 26, "Input",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[7847, 250, 369, 6, 69, "Message",
      CellTags->{"NMaximize::lvar", "NMinimize::lvar"}],
    Cell[8219, 258, 148, 3, 23, "Output",
      CellTags->{"NMaximize::lvar", "NMinimize::lvar"}],
    Cell[8382, 264, 150, 5, 24, "Text",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[8557, 273, 151, 3, 26, "Input",
      CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
    Cell[8711, 278, 132, 3, 21, "Output",
      CellTags->{"NMaximize::lvar", "NMinimize::lvar"}]},
  "NMinimize::cnft"->{
    Cell[8904, 288, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NMinimize::cnft"],
    Cell[8990, 291, 552, 13, 37, "Message",
      CellTags->"NMinimize::cnft"],
    Cell[9545, 306, 186, 5, 24, "Notes",
      CellTags->"NMinimize::cnft"]},
  "NMaximize::cnft"->{
    Cell[9768, 316, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NMaximize::cnft"],
    Cell[9854, 319, 553, 13, 37, "Message",
      CellTags->"NMaximize::cnft"],
    Cell[10410, 334, 186, 5, 24, "Notes",
      CellTags->"NMaximize::cnft"]},
  "NMinimize::parchange"->{
    Cell[10633, 344, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
    Cell[10784, 350, 620, 19, 21, "Message",
      CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
    Cell[11407, 371, 172, 4, 24, "Notes",
      CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
    Cell[11604, 379, 96, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
    Cell[11703, 382, 251, 7, 24, "Text",
      CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
    Cell[11979, 393, 223, 5, 26, "Input",
      CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
    Cell[12205, 400, 262, 5, 37, "Message",
      CellTags->{"NMaximize::parchange", "NMinimize::parchange"}],
    Cell[12470, 407, 168, 3, 21, "Output",
      CellTags->{"NMaximize::parchange", "NMinimize::parchange"}]},
  "NMaximize::parchange"->{
    Cell[10633, 344, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
    Cell[10784, 350, 620, 19, 21, "Message",
      CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
    Cell[11407, 371, 172, 4, 24, "Notes",
      CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
    Cell[11604, 379, 96, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
    Cell[11703, 382, 251, 7, 24, "Text",
      CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
    Cell[11979, 393, 223, 5, 26, "Input",
      CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
    Cell[12205, 400, 262, 5, 37, "Message",
      CellTags->{"NMaximize::parchange", "NMinimize::parchange"}],
    Cell[12470, 407, 168, 3, 21, "Output",
      CellTags->{"NMaximize::parchange", "NMinimize::parchange"}]},
  "NMinimize::maxit"->{
    Cell[12699, 417, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
    Cell[12834, 423, 336, 8, 37, "Message",
      CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
    Cell[13173, 433, 221, 5, 24, "Notes",
      CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
    Cell[13419, 442, 88, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
    Cell[13510, 445, 244, 7, 24, "Text",
      CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
    Cell[13779, 456, 161, 3, 26, "Input",
      CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
    Cell[13943, 461, 254, 5, 37, "Message",
      CellTags->{"NMaximize::maxit", "NMinimize::maxit"}],
    Cell[14200, 468, 162, 3, 21, "Output",
      CellTags->{"NMaximize::maxit", "NMinimize::maxit"}]},
  "NMaximize::maxit"->{
    Cell[12699, 417, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
    Cell[12834, 423, 336, 8, 37, "Message",
      CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
    Cell[13173, 433, 221, 5, 24, "Notes",
      CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
    Cell[13419, 442, 88, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
    Cell[13510, 445, 244, 7, 24, "Text",
      CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
    Cell[13779, 456, 161, 3, 26, "Input",
      CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
    Cell[13943, 461, 254, 5, 37, "Message",
      CellTags->{"NMaximize::maxit", "NMinimize::maxit"}],
    Cell[14200, 468, 162, 3, 21, "Output",
      CellTags->{"NMaximize::maxit", "NMinimize::maxit"}]},
  "NMinimize::nosat"->{
    Cell[14423, 478, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[14558, 484, 546, 17, 37, "Message",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[15107, 503, 273, 6, 46, "Notes",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[15405, 513, 88, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[15496, 516, 189, 4, 24, "Text",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[15710, 524, 212, 5, 30, "Input",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[15925, 531, 297, 6, 39, "Message",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[16225, 539, 139, 3, 21, "Output",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[16379, 545, 191, 4, 24, "Text",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[16595, 553, 230, 5, 30, "Input",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[16828, 560, 508, 8, 103, "Message",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[17339, 570, 508, 8, 103, "Message",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[17850, 580, 359, 6, 55, "Message",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[18212, 588, 169, 3, 21, "Output",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[18396, 594, 168, 4, 24, "Text",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[18589, 602, 220, 5, 30, "Input",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[18812, 609, 297, 6, 39, "Message",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[19112, 617, 139, 3, 21, "Output",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}]},
  "NMaximize::nosat"->{
    Cell[14423, 478, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[14558, 484, 546, 17, 37, "Message",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[15107, 503, 273, 6, 46, "Notes",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[15405, 513, 88, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[15496, 516, 189, 4, 24, "Text",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[15710, 524, 212, 5, 30, "Input",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[15925, 531, 297, 6, 39, "Message",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[16225, 539, 139, 3, 21, "Output",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[16379, 545, 191, 4, 24, "Text",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[16595, 553, 230, 5, 30, "Input",
      CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
    Cell[16828, 560, 508, 8, 103, "Message",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[17339, 570, 508, 8, 103, "Message",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[17850, 580, 359, 6, 55, "Message",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[18212, 588, 169, 3, 21, "Output",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[18396, 594, 168, 4, 24, "Text",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[18589, 602, 220, 5, 30, "Input",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[18812, 609, 297, 6, 39, "Message",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
    Cell[19112, 617, 139, 3, 21, "Output",
      CellTags->{"NMaximize::nosat", "NMinimize::nosat"}]},
  "NMinimize::workprec"->{
    Cell[19312, 627, 144, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::workprec", "NMaximize::workprec"}],
    Cell[19459, 633, 371, 9, 37, "Message",
      CellTags->{"NMinimize::workprec", "NMaximize::workprec"}],
    Cell[19833, 644, 155, 4, 24, "Notes",
      CellTags->{"NMinimize::workprec", "NMaximize::workprec"}]},
  "NMaximize::workprec"->{
    Cell[19312, 627, 144, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::workprec", "NMaximize::workprec"}],
    Cell[19459, 633, 371, 9, 37, "Message",
      CellTags->{"NMinimize::workprec", "NMaximize::workprec"}],
    Cell[19833, 644, 155, 4, 24, "Notes",
      CellTags->{"NMinimize::workprec", "NMaximize::workprec"}]},
  "NMinimize::belt"->{
    Cell[20025, 653, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[20156, 659, 570, 15, 37, "Message",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[20729, 676, 338, 9, 40, "Notes",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[21092, 689, 86, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[21181, 692, 195, 5, 24, "Text",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[21401, 701, 164, 3, 26, "Input",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[21568, 706, 255, 5, 37, "Message",
      CellTags->{"NMaximize::belt", "NMinimize::belt"}],
    Cell[21826, 713, 150, 3, 21, "Output",
      CellTags->{"NMaximize::belt", "NMinimize::belt"}],
    Cell[21991, 719, 225, 6, 24, "Text",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[22241, 729, 161, 3, 26, "Input",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[22405, 734, 151, 3, 21, "Output",
      CellTags->{"NMaximize::belt", "NMinimize::belt"}]},
  "NMaximize::belt"->{
    Cell[20025, 653, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[20156, 659, 570, 15, 37, "Message",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[20729, 676, 338, 9, 40, "Notes",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[21092, 689, 86, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[21181, 692, 195, 5, 24, "Text",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[21401, 701, 164, 3, 26, "Input",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[21568, 706, 255, 5, 37, "Message",
      CellTags->{"NMaximize::belt", "NMinimize::belt"}],
    Cell[21826, 713, 150, 3, 21, "Output",
      CellTags->{"NMaximize::belt", "NMinimize::belt"}],
    Cell[21991, 719, 225, 6, 24, "Text",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[22241, 729, 161, 3, 26, "Input",
      CellTags->{"NMinimize::belt", "NMaximize::belt"}],
    Cell[22405, 734, 151, 3, 21, "Output",
      CellTags->{"NMaximize::belt", "NMinimize::belt"}]},
  "NMinimize::elmt"->{
    Cell[22617, 744, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
    Cell[22748, 750, 335, 8, 37, "Message",
      CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
    Cell[23086, 760, 304, 9, 40, "Notes",
      CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
    Cell[23415, 773, 86, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
    Cell[23504, 776, 233, 7, 24, "Text",
      CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
    Cell[23762, 787, 156, 3, 26, "Input",
      CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
    Cell[23921, 792, 252, 5, 37, "Message",
      CellTags->{"NMaximize::elmt", "NMinimize::elmt"}],
    Cell[24176, 799, 158, 3, 21, "Output",
      CellTags->{"NMaximize::elmt", "NMinimize::elmt"}]},
  "NMaximize::elmt"->{
    Cell[22617, 744, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
    Cell[22748, 750, 335, 8, 37, "Message",
      CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
    Cell[23086, 760, 304, 9, 40, "Notes",
      CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
    Cell[23415, 773, 86, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
    Cell[23504, 776, 233, 7, 24, "Text",
      CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
    Cell[23762, 787, 156, 3, 26, "Input",
      CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
    Cell[23921, 792, 252, 5, 37, "Message",
      CellTags->{"NMaximize::elmt", "NMinimize::elmt"}],
    Cell[24176, 799, 158, 3, 21, "Output",
      CellTags->{"NMaximize::elmt", "NMinimize::elmt"}]},
  "NMinimize::incst"->{
    Cell[24395, 809, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[24530, 815, 968, 20, 69, "Message",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[25501, 837, 405, 8, 62, "Notes",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[25931, 849, 88, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[26022, 852, 196, 4, 40, "Text",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[26243, 860, 161, 3, 30, "Input",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[26407, 865, 444, 7, 87, "Message",
      CellTags->{"NMaximize::incst", "NMinimize::incst"}],
    Cell[26854, 874, 139, 3, 21, "Output",
      CellTags->{"NMaximize::incst", "NMinimize::incst"}],
    Cell[27008, 880, 162, 4, 24, "Text",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[27195, 888, 167, 3, 30, "Input",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[27365, 893, 134, 3, 21, "Output",
      CellTags->{"NMaximize::incst", "NMinimize::incst"}]},
  "NMaximize::incst"->{
    Cell[24395, 809, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[24530, 815, 968, 20, 69, "Message",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[25501, 837, 405, 8, 62, "Notes",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[25931, 849, 88, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[26022, 852, 196, 4, 40, "Text",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[26243, 860, 161, 3, 30, "Input",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[26407, 865, 444, 7, 87, "Message",
      CellTags->{"NMaximize::incst", "NMinimize::incst"}],
    Cell[26854, 874, 139, 3, 21, "Output",
      CellTags->{"NMaximize::incst", "NMinimize::incst"}],
    Cell[27008, 880, 162, 4, 24, "Text",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[27195, 888, 167, 3, 30, "Input",
      CellTags->{"NMinimize::incst", "NMaximize::incst"}],
    Cell[27365, 893, 134, 3, 21, "Output",
      CellTags->{"NMaximize::incst", "NMinimize::incst"}]},
  "NMinimize::bdmtd"->{
    Cell[27560, 903, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
    Cell[27695, 909, 623, 17, 37, "Message",
      CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
    Cell[28321, 928, 222, 5, 24, "Notes",
      CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
    Cell[28568, 937, 88, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
    Cell[28659, 940, 244, 7, 24, "Text",
      CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
    Cell[28928, 951, 153, 3, 26, "Input",
      CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
    Cell[29084, 956, 295, 6, 53, "Message",
      CellTags->{"NMaximize::bdmtd", "NMinimize::bdmtd"}],
    Cell[29382, 964, 154, 3, 21, "Output",
      CellTags->{"NMaximize::bdmtd", "NMinimize::bdmtd"}]},
  "NMaximize::bdmtd"->{
    Cell[27560, 903, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
    Cell[27695, 909, 623, 17, 37, "Message",
      CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
    Cell[28321, 928, 222, 5, 24, "Notes",
      CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
    Cell[28568, 937, 88, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
    Cell[28659, 940, 244, 7, 24, "Text",
      CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
    Cell[28928, 951, 153, 3, 26, "Input",
      CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
    Cell[29084, 956, 295, 6, 53, "Message",
      CellTags->{"NMaximize::bdmtd", "NMinimize::bdmtd"}],
    Cell[29382, 964, 154, 3, 21, "Output",
      CellTags->{"NMaximize::bdmtd", "NMinimize::bdmtd"}]},
  "NMinimize::nsol"->{
    Cell[29597, 974, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
    Cell[29728, 980, 438, 12, 21, "Message",
      CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
    Cell[30169, 994, 249, 7, 24, "Notes",
      CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
    Cell[30443, 1005, 86, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
    Cell[30532, 1008, 151, 4, 24, "Text",
      CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
    Cell[30708, 1016, 192, 4, 30, "Input",
      CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
    Cell[30903, 1022, 281, 5, 37, "Message",
      CellTags->{"NMaximize::nsol", "NMinimize::nsol"}],
    Cell[31187, 1029, 150, 3, 21, "Output",
      CellTags->{"NMaximize::nsol", "NMinimize::nsol"}]},
  "NMaximize::nsol"->{
    Cell[29597, 974, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
    Cell[29728, 980, 438, 12, 21, "Message",
      CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
    Cell[30169, 994, 249, 7, 24, "Notes",
      CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
    Cell[30443, 1005, 86, 1, 38, "ExampleSection",
      CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
    Cell[30532, 1008, 151, 4, 24, "Text",
      CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
    Cell[30708, 1016, 192, 4, 30, "Input",
      CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
    Cell[30903, 1022, 281, 5, 37, "Message",
      CellTags->{"NMaximize::nsol", "NMinimize::nsol"}],
    Cell[31187, 1029, 150, 3, 21, "Output",
      CellTags->{"NMaximize::nsol", "NMinimize::nsol"}]},
  "Experimental`Maximize::deprec"->{
    Cell[31398, 1039, 111, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`Maximize::deprec"],
    Cell[31512, 1042, 278, 4, 37, "Message",
      CellTags->"Experimental`Maximize::deprec"],
    Cell[31793, 1048, 343, 10, 40, "Notes",
      CellTags->"Experimental`Maximize::deprec"]},
  "Maximize::wksol"->{
    Cell[32173, 1063, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Maximize::wksol"],
    Cell[32259, 1066, 248, 5, 53, "Message",
      CellTags->"Maximize::wksol"],
    Cell[32510, 1073, 205, 6, 24, "Notes",
      CellTags->"Maximize::wksol"],
    Cell[32740, 1083, 65, 1, 38, "ExampleSection",
      CellTags->"Maximize::wksol"],
    Cell[32808, 1086, 179, 4, 40, "Text",
      CellTags->"Maximize::wksol"],
    Cell[33012, 1094, 109, 3, 26, "Input",
      CellTags->"Maximize::wksol"],
    Cell[33124, 1099, 247, 5, 53, "Message",
      CellTags->"Maximize::wksol"],
    Cell[33374, 1106, 107, 3, 21, "Output",
      CellTags->"Maximize::wksol"],
    Cell[33496, 1112, 204, 9, 24, "Text",
      CellTags->"Maximize::wksol"],
    Cell[33725, 1125, 120, 3, 26, "Input",
      CellTags->"Maximize::wksol"],
    Cell[33848, 1130, 107, 3, 21, "Output",
      CellTags->"Maximize::wksol"]},
  "Maximize::natt"->{
    Cell[34016, 1140, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Maximize::natt"],
    Cell[34100, 1143, 209, 4, 37, "Message",
      CellTags->"Maximize::natt"],
    Cell[34312, 1149, 125, 4, 24, "Notes",
      CellTags->"Maximize::natt"]},
  "Maximize::nopmet"->{
    Cell[34474, 1158, 264, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
        "Experimental`Supremum::nopmet"}],
    Cell[34741, 1168, 385, 10, 37, "Message",
      CellTags->{
      "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
        "Experimental`Supremum::nopmet"}],
    Cell[35129, 1180, 222, 6, 24, "Notes",
      CellTags->{
      "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
        "Experimental`Supremum::nopmet"}]},
  "Minimize::nopmet"->{
    Cell[34474, 1158, 264, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
        "Experimental`Supremum::nopmet"}],
    Cell[34741, 1168, 385, 10, 37, "Message",
      CellTags->{
      "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
        "Experimental`Supremum::nopmet"}],
    Cell[35129, 1180, 222, 6, 24, "Notes",
      CellTags->{
      "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
        "Experimental`Supremum::nopmet"}]},
  "Experimental`Infimum::nopmet"->{
    Cell[34474, 1158, 264, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
        "Experimental`Supremum::nopmet"}],
    Cell[34741, 1168, 385, 10, 37, "Message",
      CellTags->{
      "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
        "Experimental`Supremum::nopmet"}],
    Cell[35129, 1180, 222, 6, 24, "Notes",
      CellTags->{
      "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
        "Experimental`Supremum::nopmet"}]},
  "Experimental`Supremum::nopmet"->{
    Cell[34474, 1158, 264, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
        "Experimental`Supremum::nopmet"}],
    Cell[34741, 1168, 385, 10, 37, "Message",
      CellTags->{
      "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
        "Experimental`Supremum::nopmet"}],
    Cell[35129, 1180, 222, 6, 24, "Notes",
      CellTags->{
      "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
        "Experimental`Supremum::nopmet"}]},
  "Maximize::noobj"->{
    Cell[35388, 1191, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
        "Experimental`Supremum::noobj"}],
    Cell[35647, 1201, 330, 9, 21, "Message",
      CellTags->{
      "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
        "Experimental`Supremum::noobj"}],
    Cell[35980, 1212, 218, 6, 24, "Notes",
      CellTags->{
      "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
        "Experimental`Supremum::noobj"}]},
  "Minimize::noobj"->{
    Cell[35388, 1191, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
        "Experimental`Supremum::noobj"}],
    Cell[35647, 1201, 330, 9, 21, "Message",
      CellTags->{
      "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
        "Experimental`Supremum::noobj"}],
    Cell[35980, 1212, 218, 6, 24, "Notes",
      CellTags->{
      "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
        "Experimental`Supremum::noobj"}]},
  "Experimental`Infimum::noobj"->{
    Cell[35388, 1191, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
        "Experimental`Supremum::noobj"}],
    Cell[35647, 1201, 330, 9, 21, "Message",
      CellTags->{
      "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
        "Experimental`Supremum::noobj"}],
    Cell[35980, 1212, 218, 6, 24, "Notes",
      CellTags->{
      "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
        "Experimental`Supremum::noobj"}]},
  "Experimental`Supremum::noobj"->{
    Cell[35388, 1191, 256, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
        "Experimental`Supremum::noobj"}],
    Cell[35647, 1201, 330, 9, 21, "Message",
      CellTags->{
      "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
        "Experimental`Supremum::noobj"}],
    Cell[35980, 1212, 218, 6, 24, "Notes",
      CellTags->{
      "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
        "Experimental`Supremum::noobj"}]},
  "Experimental`Minimize::deprec"->{
    Cell[36235, 1223, 111, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`Minimize::deprec"],
    Cell[36349, 1226, 278, 4, 37, "Message",
      CellTags->"Experimental`Minimize::deprec"],
    Cell[36630, 1232, 140, 4, 24, "Notes",
      CellTags->"Experimental`Minimize::deprec"]},
  "Minimize::wksol"->{
    Cell[36807, 1241, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Minimize::wksol"],
    Cell[36893, 1244, 261, 5, 53, "Message",
      CellTags->"Minimize::wksol"],
    Cell[37157, 1251, 205, 6, 24, "Notes",
      CellTags->"Minimize::wksol"],
    Cell[37387, 1261, 65, 1, 38, "ExampleSection",
      CellTags->"Minimize::wksol"],
    Cell[37455, 1264, 179, 4, 40, "Text",
      CellTags->"Minimize::wksol"],
    Cell[37659, 1272, 109, 3, 26, "Input",
      CellTags->"Minimize::wksol"],
    Cell[37771, 1277, 247, 5, 53, "Message",
      CellTags->"Minimize::wksol"],
    Cell[38021, 1284, 107, 3, 21, "Output",
      CellTags->"Minimize::wksol"],
    Cell[38143, 1290, 207, 9, 24, "Text",
      CellTags->"Minimize::wksol"],
    Cell[38375, 1303, 123, 3, 26, "Input",
      CellTags->"Minimize::wksol"],
    Cell[38501, 1308, 107, 3, 21, "Output",
      CellTags->"Minimize::wksol"]},
  "Minimize::natt"->{
    Cell[38669, 1318, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Minimize::natt"],
    Cell[38753, 1321, 201, 3, 37, "Message",
      CellTags->"Minimize::natt"],
    Cell[38957, 1326, 125, 4, 24, "Notes",
      CellTags->"Minimize::natt"]},
  "NMinimize::cvmit"->{
    Cell[39119, 1335, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::cvmit", "NMaximize::cvmit"}],
    Cell[39254, 1341, 319, 8, 37, "Message",
      CellTags->{"NMinimize::cvmit", "NMaximize::cvmit"}],
    Cell[39576, 1351, 149, 4, 24, "Notes",
      CellTags->{"NMinimize::cvmit", "NMaximize::cvmit"}]},
  "NMaximize::cvmit"->{
    Cell[39119, 1335, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::cvmit", "NMaximize::cvmit"}],
    Cell[39254, 1341, 319, 8, 37, "Message",
      CellTags->{"NMinimize::cvmit", "NMaximize::cvmit"}],
    Cell[39576, 1351, 149, 4, 24, "Notes",
      CellTags->{"NMinimize::cvmit", "NMaximize::cvmit"}]},
  "NMinimize::cvdiv"->{
    Cell[39762, 1360, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::cvdiv", "NMaximize::cvdiv"}],
    Cell[39897, 1366, 306, 8, 21, "Message",
      CellTags->{"NMinimize::cvdiv", "NMaximize::cvdiv"}],
    Cell[40206, 1376, 149, 4, 24, "Notes",
      CellTags->{"NMinimize::cvdiv", "NMaximize::cvdiv"}]},
  "NMaximize::cvdiv"->{
    Cell[39762, 1360, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::cvdiv", "NMaximize::cvdiv"}],
    Cell[39897, 1366, 306, 8, 21, "Message",
      CellTags->{"NMinimize::cvdiv", "NMaximize::cvdiv"}],
    Cell[40206, 1376, 149, 4, 24, "Notes",
      CellTags->{"NMinimize::cvdiv", "NMaximize::cvdiv"}]},
  "NMinimize::ropn"->{
    Cell[40392, 1385, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::ropn", "NMaximize::ropn"}],
    Cell[40523, 1391, 313, 8, 21, "Message",
      CellTags->{"NMinimize::ropn", "NMaximize::ropn"}],
    Cell[40839, 1401, 147, 4, 24, "Notes",
      CellTags->{"NMinimize::ropn", "NMaximize::ropn"}]},
  "NMaximize::ropn"->{
    Cell[40392, 1385, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::ropn", "NMaximize::ropn"}],
    Cell[40523, 1391, 313, 8, 21, "Message",
      CellTags->{"NMinimize::ropn", "NMaximize::ropn"}],
    Cell[40839, 1401, 147, 4, 24, "Notes",
      CellTags->{"NMinimize::ropn", "NMaximize::ropn"}]},
  "NMinimize::roprl"->{
    Cell[41023, 1410, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::roprl", "NMaximize::roprl"}],
    Cell[41158, 1416, 323, 8, 37, "Message",
      CellTags->{"NMinimize::roprl", "NMaximize::roprl"}],
    Cell[41484, 1426, 149, 4, 24, "Notes",
      CellTags->{"NMinimize::roprl", "NMaximize::roprl"}]},
  "NMaximize::roprl"->{
    Cell[41023, 1410, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::roprl", "NMaximize::roprl"}],
    Cell[41158, 1416, 323, 8, 37, "Message",
      CellTags->{"NMinimize::roprl", "NMaximize::roprl"}],
    Cell[41484, 1426, 149, 4, 24, "Notes",
      CellTags->{"NMinimize::roprl", "NMaximize::roprl"}]},
  "NMinimize::roprlu"->{
    Cell[41670, 1435, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::roprlu", "NMaximize::roprlu"}],
    Cell[41809, 1441, 318, 8, 37, "Message",
      CellTags->{"NMinimize::roprlu", "NMaximize::roprlu"}],
    Cell[42130, 1451, 151, 4, 24, "Notes",
      CellTags->{"NMinimize::roprlu", "NMaximize::roprlu"}]},
  "NMaximize::roprlu"->{
    Cell[41670, 1435, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::roprlu", "NMaximize::roprlu"}],
    Cell[41809, 1441, 318, 8, 37, "Message",
      CellTags->{"NMinimize::roprlu", "NMaximize::roprlu"}],
    Cell[42130, 1451, 151, 4, 24, "Notes",
      CellTags->{"NMinimize::roprlu", "NMaximize::roprlu"}]},
  "NMinimize::rseed"->{
    Cell[42318, 1460, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::rseed", "NMaximize::rseed"}],
    Cell[42453, 1466, 306, 8, 21, "Message",
      CellTags->{"NMinimize::rseed", "NMaximize::rseed"}],
    Cell[42762, 1476, 149, 4, 24, "Notes",
      CellTags->{"NMinimize::rseed", "NMaximize::rseed"}]},
  "NMaximize::rseed"->{
    Cell[42318, 1460, 132, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::rseed", "NMaximize::rseed"}],
    Cell[42453, 1466, 306, 8, 21, "Message",
      CellTags->{"NMinimize::rseed", "NMaximize::rseed"}],
    Cell[42762, 1476, 149, 4, 24, "Notes",
      CellTags->{"NMinimize::rseed", "NMaximize::rseed"}]},
  "NMinimize::ubnd"->{
    Cell[42948, 1485, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::ubnd", "NMaximize::ubnd"}],
    Cell[43079, 1491, 251, 7, 21, "Message",
      CellTags->{"NMinimize::ubnd", "NMaximize::ubnd"}],
    Cell[43333, 1500, 147, 4, 24, "Notes",
      CellTags->{"NMinimize::ubnd", "NMaximize::ubnd"}]},
  "NMaximize::ubnd"->{
    Cell[42948, 1485, 128, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NMinimize::ubnd", "NMaximize::ubnd"}],
    Cell[43079, 1491, 251, 7, 21, "Message",
      CellTags->{"NMinimize::ubnd", "NMaximize::ubnd"}],
    Cell[43333, 1500, 147, 4, 24, "Notes",
      CellTags->{"NMinimize::ubnd", "NMaximize::ubnd"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"NMinimize::bcons", 44175, 1525},
  {"NMaximize::bcons", 45733, 1556},
  {"NMinimize::lvar", 47290, 1587},
  {"NMaximize::lvar", 48427, 1610},
  {"NMinimize::cnft", 49564, 1633},
  {"NMaximize::cnft", 49841, 1640},
  {"NMinimize::parchange", 50124, 1647},
  {"NMaximize::parchange", 51058, 1664},
  {"NMinimize::maxit", 51988, 1681},
  {"NMaximize::maxit", 52853, 1698},
  {"NMinimize::nosat", 53718, 1715},
  {"NMaximize::nosat", 55604, 1752},
  {"NMinimize::workprec", 57493, 1789},
  {"NMaximize::workprec", 57864, 1796},
  {"NMinimize::belt", 58231, 1803},
  {"NMaximize::belt", 59377, 1826},
  {"NMinimize::elmt", 60523, 1849},
  {"NMaximize::elmt", 61371, 1866},
  {"NMinimize::incst", 62220, 1883},
  {"NMaximize::incst", 63389, 1906},
  {"NMinimize::bdmtd", 64558, 1929},
  {"NMaximize::bdmtd", 65424, 1946},
  {"NMinimize::nsol", 66289, 1963},
  {"NMaximize::nsol", 67143, 1980},
  {"Experimental`Maximize::deprec", 68011, 1997},
  {"Maximize::wksol", 68337, 2004},
  {"Maximize::natt", 69260, 2027},
  {"Maximize::nopmet", 69540, 2034},
  {"Minimize::nopmet", 70137, 2047},
  {"Experimental`Infimum::nopmet", 70746, 2060},
  {"Experimental`Supremum::nopmet", 71356, 2073},
  {"Maximize::noobj", 71952, 2086},
  {"Minimize::noobj", 72535, 2099},
  {"Experimental`Infimum::noobj", 73130, 2112},
  {"Experimental`Supremum::noobj", 73726, 2125},
  {"Experimental`Minimize::deprec", 74323, 2138},
  {"Minimize::wksol", 74648, 2145},
  {"Minimize::natt", 75571, 2168},
  {"NMinimize::cvmit", 75851, 2175},
  {"NMaximize::cvmit", 76204, 2182},
  {"NMinimize::cvdiv", 76557, 2189},
  {"NMaximize::cvdiv", 76910, 2196},
  {"NMinimize::ropn", 77262, 2203},
  {"NMaximize::ropn", 77608, 2210},
  {"NMinimize::roprl", 77955, 2217},
  {"NMaximize::roprl", 78308, 2224},
  {"NMinimize::roprlu", 78662, 2231},
  {"NMaximize::roprlu", 79022, 2238},
  {"NMinimize::rseed", 79381, 2245},
  {"NMaximize::rseed", 79734, 2252},
  {"NMinimize::ubnd", 80086, 2259},
  {"NMaximize::ubnd", 80432, 2266}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 26, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1827, 57, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
Cell[1962, 63, 692, 17, 53, "Message",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
Cell[2657, 82, 556, 14, 78, "Notes",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[CellGroupData[{
Cell[3238, 100, 88, 1, 38, "ExampleSection",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
Cell[3329, 103, 299, 8, 40, "Text",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[CellGroupData[{
Cell[3653, 115, 141, 3, 26, "Input",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
Cell[3797, 120, 325, 6, 69, "Message",
  CellTags->{"NMaximize::bcons", "NMinimize::bcons"}],
Cell[4125, 128, 143, 3, 23, "Output",
  CellTags->{"NMaximize::bcons", "NMinimize::bcons"}]
}, Open  ]],
Cell[4283, 134, 239, 6, 40, "Text",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[CellGroupData[{
Cell[4547, 144, 153, 3, 26, "Input",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
Cell[4703, 149, 318, 6, 71, "Message",
  CellTags->{"NMaximize::bcons", "NMinimize::bcons"}],
Cell[5024, 157, 155, 3, 23, "Output",
  CellTags->{"NMaximize::bcons", "NMinimize::bcons"}]
}, Open  ]],
Cell[5194, 163, 170, 5, 24, "Text",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],

Cell[CellGroupData[{
Cell[5389, 172, 153, 3, 26, "Input",
  CellTags->{"NMinimize::bcons", "NMaximize::bcons"}],
Cell[5545, 177, 134, 3, 21, "Output",
  CellTags->{"NMaximize::bcons", "NMinimize::bcons"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5740, 187, 128, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
Cell[5871, 193, 645, 16, 53, "Message",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
Cell[6519, 211, 676, 14, 100, "Notes",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],

Cell[CellGroupData[{
Cell[7220, 229, 86, 1, 38, "ExampleSection",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
Cell[7309, 232, 364, 9, 40, "Text",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],

Cell[CellGroupData[{
Cell[7698, 245, 146, 3, 26, "Input",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
Cell[7847, 250, 369, 6, 69, "Message",
  CellTags->{"NMaximize::lvar", "NMinimize::lvar"}],
Cell[8219, 258, 148, 3, 23, "Output",
  CellTags->{"NMaximize::lvar", "NMinimize::lvar"}]
}, Open  ]],
Cell[8382, 264, 150, 5, 24, "Text",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],

Cell[CellGroupData[{
Cell[8557, 273, 151, 3, 26, "Input",
  CellTags->{"NMinimize::lvar", "NMaximize::lvar"}],
Cell[8711, 278, 132, 3, 21, "Output",
  CellTags->{"NMaximize::lvar", "NMinimize::lvar"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8904, 288, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NMinimize::cnft"],
Cell[8990, 291, 552, 13, 37, "Message",
  CellTags->"NMinimize::cnft"],
Cell[9545, 306, 186, 5, 24, "Notes",
  CellTags->"NMinimize::cnft"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9768, 316, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NMaximize::cnft"],
Cell[9854, 319, 553, 13, 37, "Message",
  CellTags->"NMaximize::cnft"],
Cell[10410, 334, 186, 5, 24, "Notes",
  CellTags->"NMaximize::cnft"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10633, 344, 148, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
Cell[10784, 350, 620, 19, 21, "Message",
  CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
Cell[11407, 371, 172, 4, 24, "Notes",
  CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],

Cell[CellGroupData[{
Cell[11604, 379, 96, 1, 38, "ExampleSection",
  CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
Cell[11703, 382, 251, 7, 24, "Text",
  CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],

Cell[CellGroupData[{
Cell[11979, 393, 223, 5, 26, "Input",
  CellTags->{"NMinimize::parchange", "NMaximize::parchange"}],
Cell[12205, 400, 262, 5, 37, "Message",
  CellTags->{"NMaximize::parchange", "NMinimize::parchange"}],
Cell[12470, 407, 168, 3, 21, "Output",
  CellTags->{"NMaximize::parchange", "NMinimize::parchange"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12699, 417, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
Cell[12834, 423, 336, 8, 37, "Message",
  CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
Cell[13173, 433, 221, 5, 24, "Notes",
  CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],

Cell[CellGroupData[{
Cell[13419, 442, 88, 1, 38, "ExampleSection",
  CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
Cell[13510, 445, 244, 7, 24, "Text",
  CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],

Cell[CellGroupData[{
Cell[13779, 456, 161, 3, 26, "Input",
  CellTags->{"NMinimize::maxit", "NMaximize::maxit"}],
Cell[13943, 461, 254, 5, 37, "Message",
  CellTags->{"NMaximize::maxit", "NMinimize::maxit"}],
Cell[14200, 468, 162, 3, 21, "Output",
  CellTags->{"NMaximize::maxit", "NMinimize::maxit"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14423, 478, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
Cell[14558, 484, 546, 17, 37, "Message",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
Cell[15107, 503, 273, 6, 46, "Notes",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],

Cell[CellGroupData[{
Cell[15405, 513, 88, 1, 38, "ExampleSection",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
Cell[15496, 516, 189, 4, 24, "Text",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],

Cell[CellGroupData[{
Cell[15710, 524, 212, 5, 30, "Input",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
Cell[15925, 531, 297, 6, 39, "Message",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
Cell[16225, 539, 139, 3, 21, "Output",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}]
}, Open  ]],
Cell[16379, 545, 191, 4, 24, "Text",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],

Cell[CellGroupData[{
Cell[16595, 553, 230, 5, 30, "Input",
  CellTags->{"NMinimize::nosat", "NMaximize::nosat"}],
Cell[16828, 560, 508, 8, 103, "Message",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
Cell[17339, 570, 508, 8, 103, "Message",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
Cell[17850, 580, 359, 6, 55, "Message",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
Cell[18212, 588, 169, 3, 21, "Output",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}]
}, Open  ]],
Cell[18396, 594, 168, 4, 24, "Text",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],

Cell[CellGroupData[{
Cell[18589, 602, 220, 5, 30, "Input",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
Cell[18812, 609, 297, 6, 39, "Message",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}],
Cell[19112, 617, 139, 3, 21, "Output",
  CellTags->{"NMaximize::nosat", "NMinimize::nosat"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[19312, 627, 144, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::workprec", "NMaximize::workprec"}],
Cell[19459, 633, 371, 9, 37, "Message",
  CellTags->{"NMinimize::workprec", "NMaximize::workprec"}],
Cell[19833, 644, 155, 4, 24, "Notes",
  CellTags->{"NMinimize::workprec", "NMaximize::workprec"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[20025, 653, 128, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],
Cell[20156, 659, 570, 15, 37, "Message",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],
Cell[20729, 676, 338, 9, 40, "Notes",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],

Cell[CellGroupData[{
Cell[21092, 689, 86, 1, 38, "ExampleSection",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],
Cell[21181, 692, 195, 5, 24, "Text",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],

Cell[CellGroupData[{
Cell[21401, 701, 164, 3, 26, "Input",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],
Cell[21568, 706, 255, 5, 37, "Message",
  CellTags->{"NMaximize::belt", "NMinimize::belt"}],
Cell[21826, 713, 150, 3, 21, "Output",
  CellTags->{"NMaximize::belt", "NMinimize::belt"}]
}, Open  ]],
Cell[21991, 719, 225, 6, 24, "Text",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],

Cell[CellGroupData[{
Cell[22241, 729, 161, 3, 26, "Input",
  CellTags->{"NMinimize::belt", "NMaximize::belt"}],
Cell[22405, 734, 151, 3, 21, "Output",
  CellTags->{"NMaximize::belt", "NMinimize::belt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22617, 744, 128, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
Cell[22748, 750, 335, 8, 37, "Message",
  CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
Cell[23086, 760, 304, 9, 40, "Notes",
  CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],

Cell[CellGroupData[{
Cell[23415, 773, 86, 1, 38, "ExampleSection",
  CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
Cell[23504, 776, 233, 7, 24, "Text",
  CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],

Cell[CellGroupData[{
Cell[23762, 787, 156, 3, 26, "Input",
  CellTags->{"NMinimize::elmt", "NMaximize::elmt"}],
Cell[23921, 792, 252, 5, 37, "Message",
  CellTags->{"NMaximize::elmt", "NMinimize::elmt"}],
Cell[24176, 799, 158, 3, 21, "Output",
  CellTags->{"NMaximize::elmt", "NMinimize::elmt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[24395, 809, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],
Cell[24530, 815, 968, 20, 69, "Message",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],
Cell[25501, 837, 405, 8, 62, "Notes",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],

Cell[CellGroupData[{
Cell[25931, 849, 88, 1, 38, "ExampleSection",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],
Cell[26022, 852, 196, 4, 40, "Text",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],

Cell[CellGroupData[{
Cell[26243, 860, 161, 3, 30, "Input",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],
Cell[26407, 865, 444, 7, 87, "Message",
  CellTags->{"NMaximize::incst", "NMinimize::incst"}],
Cell[26854, 874, 139, 3, 21, "Output",
  CellTags->{"NMaximize::incst", "NMinimize::incst"}]
}, Open  ]],
Cell[27008, 880, 162, 4, 24, "Text",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],

Cell[CellGroupData[{
Cell[27195, 888, 167, 3, 30, "Input",
  CellTags->{"NMinimize::incst", "NMaximize::incst"}],
Cell[27365, 893, 134, 3, 21, "Output",
  CellTags->{"NMaximize::incst", "NMinimize::incst"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27560, 903, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
Cell[27695, 909, 623, 17, 37, "Message",
  CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
Cell[28321, 928, 222, 5, 24, "Notes",
  CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],

Cell[CellGroupData[{
Cell[28568, 937, 88, 1, 38, "ExampleSection",
  CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
Cell[28659, 940, 244, 7, 24, "Text",
  CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],

Cell[CellGroupData[{
Cell[28928, 951, 153, 3, 26, "Input",
  CellTags->{"NMinimize::bdmtd", "NMaximize::bdmtd"}],
Cell[29084, 956, 295, 6, 53, "Message",
  CellTags->{"NMaximize::bdmtd", "NMinimize::bdmtd"}],
Cell[29382, 964, 154, 3, 21, "Output",
  CellTags->{"NMaximize::bdmtd", "NMinimize::bdmtd"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[29597, 974, 128, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
Cell[29728, 980, 438, 12, 21, "Message",
  CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
Cell[30169, 994, 249, 7, 24, "Notes",
  CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],

Cell[CellGroupData[{
Cell[30443, 1005, 86, 1, 38, "ExampleSection",
  CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
Cell[30532, 1008, 151, 4, 24, "Text",
  CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],

Cell[CellGroupData[{
Cell[30708, 1016, 192, 4, 30, "Input",
  CellTags->{"NMinimize::nsol", "NMaximize::nsol"}],
Cell[30903, 1022, 281, 5, 37, "Message",
  CellTags->{"NMaximize::nsol", "NMinimize::nsol"}],
Cell[31187, 1029, 150, 3, 21, "Output",
  CellTags->{"NMaximize::nsol", "NMinimize::nsol"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[31398, 1039, 111, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`Maximize::deprec"],
Cell[31512, 1042, 278, 4, 37, "Message",
  CellTags->"Experimental`Maximize::deprec"],
Cell[31793, 1048, 343, 10, 40, "Notes",
  CellTags->"Experimental`Maximize::deprec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32173, 1063, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Maximize::wksol"],
Cell[32259, 1066, 248, 5, 53, "Message",
  CellTags->"Maximize::wksol"],
Cell[32510, 1073, 205, 6, 24, "Notes",
  CellTags->"Maximize::wksol"],

Cell[CellGroupData[{
Cell[32740, 1083, 65, 1, 38, "ExampleSection",
  CellTags->"Maximize::wksol"],
Cell[32808, 1086, 179, 4, 40, "Text",
  CellTags->"Maximize::wksol"],

Cell[CellGroupData[{
Cell[33012, 1094, 109, 3, 26, "Input",
  CellTags->"Maximize::wksol"],
Cell[33124, 1099, 247, 5, 53, "Message",
  CellTags->"Maximize::wksol"],
Cell[33374, 1106, 107, 3, 21, "Output",
  CellTags->"Maximize::wksol"]
}, Open  ]],
Cell[33496, 1112, 204, 9, 24, "Text",
  CellTags->"Maximize::wksol"],

Cell[CellGroupData[{
Cell[33725, 1125, 120, 3, 26, "Input",
  CellTags->"Maximize::wksol"],
Cell[33848, 1130, 107, 3, 21, "Output",
  CellTags->"Maximize::wksol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[34016, 1140, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Maximize::natt"],
Cell[34100, 1143, 209, 4, 37, "Message",
  CellTags->"Maximize::natt"],
Cell[34312, 1149, 125, 4, 24, "Notes",
  CellTags->"Maximize::natt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34474, 1158, 264, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
    "Experimental`Supremum::nopmet"}],
Cell[34741, 1168, 385, 10, 37, "Message",
  CellTags->{
  "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
    "Experimental`Supremum::nopmet"}],
Cell[35129, 1180, 222, 6, 24, "Notes",
  CellTags->{
  "Maximize::nopmet", "Minimize::nopmet", "Experimental`Infimum::nopmet", 
    "Experimental`Supremum::nopmet"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[35388, 1191, 256, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
    "Experimental`Supremum::noobj"}],
Cell[35647, 1201, 330, 9, 21, "Message",
  CellTags->{
  "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
    "Experimental`Supremum::noobj"}],
Cell[35980, 1212, 218, 6, 24, "Notes",
  CellTags->{
  "Maximize::noobj", "Minimize::noobj", "Experimental`Infimum::noobj", 
    "Experimental`Supremum::noobj"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[36235, 1223, 111, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`Minimize::deprec"],
Cell[36349, 1226, 278, 4, 37, "Message",
  CellTags->"Experimental`Minimize::deprec"],
Cell[36630, 1232, 140, 4, 24, "Notes",
  CellTags->"Experimental`Minimize::deprec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36807, 1241, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Minimize::wksol"],
Cell[36893, 1244, 261, 5, 53, "Message",
  CellTags->"Minimize::wksol"],
Cell[37157, 1251, 205, 6, 24, "Notes",
  CellTags->"Minimize::wksol"],

Cell[CellGroupData[{
Cell[37387, 1261, 65, 1, 38, "ExampleSection",
  CellTags->"Minimize::wksol"],
Cell[37455, 1264, 179, 4, 40, "Text",
  CellTags->"Minimize::wksol"],

Cell[CellGroupData[{
Cell[37659, 1272, 109, 3, 26, "Input",
  CellTags->"Minimize::wksol"],
Cell[37771, 1277, 247, 5, 53, "Message",
  CellTags->"Minimize::wksol"],
Cell[38021, 1284, 107, 3, 21, "Output",
  CellTags->"Minimize::wksol"]
}, Open  ]],
Cell[38143, 1290, 207, 9, 24, "Text",
  CellTags->"Minimize::wksol"],

Cell[CellGroupData[{
Cell[38375, 1303, 123, 3, 26, "Input",
  CellTags->"Minimize::wksol"],
Cell[38501, 1308, 107, 3, 21, "Output",
  CellTags->"Minimize::wksol"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[38669, 1318, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Minimize::natt"],
Cell[38753, 1321, 201, 3, 37, "Message",
  CellTags->"Minimize::natt"],
Cell[38957, 1326, 125, 4, 24, "Notes",
  CellTags->"Minimize::natt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39119, 1335, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::cvmit", "NMaximize::cvmit"}],
Cell[39254, 1341, 319, 8, 37, "Message",
  CellTags->{"NMinimize::cvmit", "NMaximize::cvmit"}],
Cell[39576, 1351, 149, 4, 24, "Notes",
  CellTags->{"NMinimize::cvmit", "NMaximize::cvmit"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[39762, 1360, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::cvdiv", "NMaximize::cvdiv"}],
Cell[39897, 1366, 306, 8, 21, "Message",
  CellTags->{"NMinimize::cvdiv", "NMaximize::cvdiv"}],
Cell[40206, 1376, 149, 4, 24, "Notes",
  CellTags->{"NMinimize::cvdiv", "NMaximize::cvdiv"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[40392, 1385, 128, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::ropn", "NMaximize::ropn"}],
Cell[40523, 1391, 313, 8, 21, "Message",
  CellTags->{"NMinimize::ropn", "NMaximize::ropn"}],
Cell[40839, 1401, 147, 4, 24, "Notes",
  CellTags->{"NMinimize::ropn", "NMaximize::ropn"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[41023, 1410, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::roprl", "NMaximize::roprl"}],
Cell[41158, 1416, 323, 8, 37, "Message",
  CellTags->{"NMinimize::roprl", "NMaximize::roprl"}],
Cell[41484, 1426, 149, 4, 24, "Notes",
  CellTags->{"NMinimize::roprl", "NMaximize::roprl"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[41670, 1435, 136, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::roprlu", "NMaximize::roprlu"}],
Cell[41809, 1441, 318, 8, 37, "Message",
  CellTags->{"NMinimize::roprlu", "NMaximize::roprlu"}],
Cell[42130, 1451, 151, 4, 24, "Notes",
  CellTags->{"NMinimize::roprlu", "NMaximize::roprlu"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[42318, 1460, 132, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::rseed", "NMaximize::rseed"}],
Cell[42453, 1466, 306, 8, 21, "Message",
  CellTags->{"NMinimize::rseed", "NMaximize::rseed"}],
Cell[42762, 1476, 149, 4, 24, "Notes",
  CellTags->{"NMinimize::rseed", "NMaximize::rseed"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[42948, 1485, 128, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NMinimize::ubnd", "NMaximize::ubnd"}],
Cell[43079, 1491, 251, 7, 21, "Message",
  CellTags->{"NMinimize::ubnd", "NMaximize::ubnd"}],
Cell[43333, 1500, 147, 4, 24, "Notes",
  CellTags->{"NMinimize::ubnd", "NMaximize::ubnd"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

