(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    307013,      10939]*)
(*NotebookOutlinePosition[    512167,      15439]*)
(*  CellTagsIndexPosition[    502454,      15211]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Numerical Computation", "Title"],

Cell[CellGroupData[{

Cell["\<\
Roots::eqn
NRoots::eqn\
\>", "ObjectNameWarningMessages",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"eqn\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "an", 
        " ", \(\(equation\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Roots::eqn", "NRoots::eqn"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected \
to be an equation.\n\[FilledSmallSquare] An equation is an expression of the \
form ",
  StyleBox["lhs", "TI"],
  StyleBox["==", "MR"],
  StyleBox["rhs", "TI"],
  ", or ",
  StyleBox["Equal[", "MR"],
  StyleBox["lhs", "TI"],
  StyleBox[",", "MR"],
  StyleBox["rsh", "TI"],
  StyleBox["]", "MR"],
  "."
}], "Notes",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],

Cell["A polynomial is not by itself an equation.", "Text",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Roots[x^2 - 5  x + 6, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],

Cell[BoxData[
    \(Roots::"eqn" \(\(:\)\(\ \)\) 
      "\!\(6 - \(\(5\\ x\)\) + x\^2\) is not an equation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NRoots::eqn", "Roots::eqn"}],

Cell[BoxData[
    \(Roots[6 - 5\ x + x\^2, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NRoots::eqn", "Roots::eqn"}]
}, Closed]],

Cell["\<\
An equation can be entered by setting this polynomial equal to \
zero.\
\>", "Text",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Roots[x^2 - 5  x + 6 == 0, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],

Cell[BoxData[
    \(x \[Equal] 2 || x \[Equal] 3\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"NRoots::eqn", "Roots::eqn"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Roots::neq
NRoots::neq\
\>", "ObjectNameWarningMessages",
  CellTags->{"Roots::neq", "NRoots::neq"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"neq\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "expected", " ", "to", " ", "be", " ", "a", 
        " ", "polynomial", " ", "in", " ", "the", " ", "variable", " ", 
        RowBox[{
          StyleBox["var",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Roots::neq", "NRoots::neq"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected \
to be a univariate polynomial.\n\[FilledSmallSquare] Equations other than \
univariate polynomial equations can be solved symbolically using ",
  StyleBox["Solve", "MR"],
  ", or numerically using ",
  StyleBox["FindRoot", "MR"],
  "."
}], "Notes",
  CellTags->{"Roots::neq", "NRoots::neq"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Roots::neq", "NRoots::neq"}],

Cell[TextData[{
  "The ",
  StyleBox["Roots", "MR"],
  " function is only designed for finding roots of polynomials."
}], "Text",
  CellTags->{"Roots::neq", "NRoots::neq"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Roots[Sqrt[x + 1] == 3, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Roots::neq", "NRoots::neq"}],

Cell[BoxData[
    \(Roots::"neq" \(\(:\)\(\ \)\) 
      "\!\(\(\(-3\)\) + \@\(1 + x\)\) is expected to be a polynomial in the \
variable \!\(x\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NRoots::neq", "Roots::neq"}],

Cell[BoxData[
    \(Roots[\@\(1 + x\) \[Equal] 3, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NRoots::neq", "Roots::neq"}]
}, Closed]],

Cell[TextData[{
  "This equation can be solved using ",
  StyleBox["Solve", "MR"],
  "."
}], "Text",
  CellTags->{"Roots::neq", "NRoots::neq"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Sqrt[x + 1] == 3, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Roots::neq", "NRoots::neq"}],

Cell[BoxData[
    \({{x \[Rule] 8}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"NRoots::neq", "Roots::neq"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General::meprec", "ObjectNameWarningMessages",
  CellTags->"General::meprec"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"meprec\"\>"}], ":", 
        " ", \(Internal\ precision\ limit\ $MaxExtraPrecision\)}], " ", "=", 
      " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "reached", " ", "while", " ", "evaluating", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::meprec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated precision is \
insufficient for numerical resolution of an inequality.\n\[FilledSmallSquare] \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " automatically uses numerical computations to resolve inequalities \
involving numeric quantities. The precision used in these computations is \
limited by the value of ",
  StyleBox["$MaxExtraPrecision", "MR"],
  ".\n\[FilledSmallSquare] This message can be generated when comparing \
expressions that are numerically equivalent. In such cases, no amount of \
extra precision can resolve the inequality.\n\[FilledSmallSquare] This \
message can be generated within other functions that use inequalities, and so \
can appear even when there are no inequalities in the input.\n\
\[FilledSmallSquare] This message is primarily advisory and often does not \
indicate an error condition."
}], "Notes",
  CellTags->"General::meprec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::meprec"],

Cell[TextData[{
  "Since ",
  StyleBox["Sin[2]", "MR"],
  " is numerically equivalent to ",
  StyleBox["2 Sin[1] Cos[1]", "MR"],
  ", this inequality cannot be resolved using numerical methods.  Increasing \
the value of ",
  StyleBox["$MaxExtraPrecision", "MR"],
  " will not help to resolve the inequality in this example."
}], "Text",
  CellTags->"General::meprec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sin[2]\  < \ 2\ Sin[1]\ Cos[1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::meprec"],

Cell[BoxData[
    \(General::"meprec" \(\(:\)\(\ \)\) 
      "Internal precision limit $MaxExtraPrecision = \!\(50.`\) reached while \
evaluating \!\(\(\(\(\(-2\)\)\\ \(\(Cos[1]\)\)\\ \(\(Sin[1]\)\)\)\) + \
\(\(Sin[2]\)\)\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::meprec"],

Cell[BoxData[
    \(Sin[2] < 2\ Cos[1]\ Sin[1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::meprec"]
}, Closed]],

Cell[TextData[{
  "Although the default precision used to resolve inequalities is \
insufficient in this example, this inequality can be resolved by increasing \
the value of ",
  StyleBox["$MaxExtraPrecision", "MR"],
  "."
}], "Text",
  CellTags->"General::meprec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sin[2]\  < \ 2\ Sin[1]\ Cos[1] + Exp[\(-1000\)]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::meprec"],

Cell[BoxData[
    \(General::"meprec" \(\(:\)\(\ \)\) 
      "Internal precision limit $MaxExtraPrecision = \!\(50.`\) reached while \
evaluating \!\(\(\(-\(\(1\/\[ExponentialE]\^1000\)\)\)\) - \(\(2\\ \(\(Cos[1]\
\)\)\\ \(\(Sin[1]\)\)\)\) + \(\(Sin[2]\)\)\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::meprec"],

Cell[BoxData[
    \(Sin[2] < 1\/\[ExponentialE]\^1000 + 2\ Cos[1]\ Sin[1]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::meprec"]
}, Closed]],

Cell[TextData[{
  "You can use ",
  StyleBox["Block", "MR"],
  " to temporarily change the value of ",
  StyleBox["$MaxExtraPrecision", "MR"],
  "."
}], "Text",
  CellTags->"General::meprec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MaxExtraPrecision\  = \ 1000}, \n\t
      Sin[2] < 2\ Sin[1]\ Cos[1] + Exp[\(-1000\)]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::meprec"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::meprec"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["$MaxExtraPrecision::meprecset", "ObjectNameWarningMessages",
  CellTags->"$MaxExtraPrecision::meprecset"],

Cell[BoxData[
    RowBox[{\($MaxExtraPrecision::"meprecset"\), \(\(:\)\(\ \)\), \
\(\(Cannot\)\(\ \)\(set\)\(\ \)\($MaxExtraPrecision\)\(\ \)\(to\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(;\)\(\ \)\(value\ must\ be\ a\ positive\ number\ or\ \
\(\(Infinity\)\(.\)\)\)\)}]], "Message",
  CellTags->"$MaxExtraPrecision::meprecset"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set ",
  StyleBox["$MaxExtraPrecision", "MR"],
  " to a value that does not have the indicated form."
}], "Notes",
  CellTags->"$MaxExtraPrecision::meprecset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$MaxExtraPrecision::meprecset"],

Cell[TextData[{
  "The value of ",
  StyleBox["$MaxExtraPrecision", "MR"],
  " can only be set to an expression that is explicitly a non-negative number \
or ",
  StyleBox["Infinity", "MR"],
  ".  When this error occurs, the value of ",
  StyleBox["$MaxExtraPrecision", "MR"],
  " is left unchanged."
}], "Text",
  CellTags->"$MaxExtraPrecision::meprecset"],

Cell[CellGroupData[{

Cell[BoxData[
    \($MaxExtraPrecision := If[$Remote, \ 2, \ 3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$MaxExtraPrecision::meprecset"],

Cell[BoxData[
    \($MaxExtraPrecision::"meprecset" \(\(:\)\(\ \)\) 
      "Cannot set $MaxExtraPrecision to \!\(If[\(\($Remote, 2, 3\)\)]\); \
value must be a positive number or Infinity."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$MaxExtraPrecision::meprecset"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["$MaxPrecision::precset", "ObjectNameWarningMessages",
  CellTags->"$MaxPrecision::precset"],

Cell[BoxData[
    RowBox[{\($MaxPrecision::"\<precset\>"\), ":", " ", 
      RowBox[{\(\(Cannot\)\(\ \)\(set\)\(\ \)\), 
        StyleBox["symbol",
          "TI"], \(\(\ \)\(to\)\(\ \)\), 
        StyleBox["expr",
          
          "TI"], \(\(;\)\(\ \)\(value\ must\ be\ a\ positive\ number\ or\ \
\(\(Infinity\)\(.\)\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"$MaxPrecision::precset"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set ",
  StyleBox["$MaxPrecision", "MR"],
  " to an invalid value."
}], "Notes",
  CellTags->"$MaxPrecision::precset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$MaxPrecision::precset"],

Cell[TextData[{
  "The symbol ",
  StyleBox["ComplexInfinity", "MR"],
  " is not a positive number or infinity and so cannot be the value of ",
  StyleBox["$MaxPrecision", "MR"],
  "."
}], "Text",
  CellTags->"$MaxPrecision::precset"],

Cell[CellGroupData[{

Cell[BoxData[
    \($MaxPrecision\  = \ ComplexInfinity\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$MaxPrecision::precset"],

Cell[BoxData[
    \($MaxPrecision::"precset" \(\(:\)\(\ \)\) 
      "Cannot set \!\($MaxPrecision\) to \!\(ComplexInfinity\); value must be \
a positive number or Infinity."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$MaxPrecision::precset"],

Cell[BoxData[
    \(ComplexInfinity\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$MaxPrecision::precset"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["$MinPrecision::precset", "ObjectNameWarningMessages",
  CellTags->"$MinPrecision::precset"],

Cell[BoxData[
    RowBox[{\($MinPrecision::"\<precset\>"\), ":", " ", 
      RowBox[{\(\(Cannot\)\(\ \)\(set\)\(\ \)\), 
        StyleBox["symbol",
          "TI"], \(\(\ \)\(to\)\(\ \)\), 
        StyleBox["expr",
          
          "TI"], \(\(\(;\)\(\ \)\(value\ must\ be\ a\ real\ number\ or\)\)\  \
+ \(\(/\)\(-\ \(\(Infinity\)\(.\)\)\)\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"$MinPrecision::precset"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set ",
  StyleBox["$MinPrecision", "MR"],
  " to an invalid value."
}], "Notes",
  CellTags->"$MinPrecision::precset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$MinPrecision::precset"],

Cell[TextData[{
  "The symbol ",
  StyleBox["ComplexInfinity", "MR"],
  " is not a real number or a real infinity and so cannot be the value of ",
  StyleBox["$MinPrecision", "MR"],
  "."
}], "Text",
  CellTags->"$MinPrecision::precset"],

Cell[CellGroupData[{

Cell[BoxData[
    \($MinPrecision\  = \ ComplexInfinity\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$MinPrecision::precset"],

Cell[BoxData[
    \($MinPrecision::"precset" \(\(:\)\(\ \)\) 
      "Cannot set \!\($MinPrecision\) to \!\(ComplexInfinity\); value must be \
a real number or +/- Infinity."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$MinPrecision::precset"],

Cell[BoxData[
    \(ComplexInfinity\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$MinPrecision::precset"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
$MinPrecision::preccon
$MaxPrecision::preccon\
\>", "ObjectNameWarningMessages",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"preccon\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
        "set", " ", 
        StyleBox["sym",
          "TI"], " ", "such", " ", "that", " ", "$MaxPrecision"}], " ", "<", 
      " ", \(\($MinPrecision\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set ",
  StyleBox["$MinPrecision", "MR"],
  " to a value greater than ",
  StyleBox["$MaxPrecision", "MR"],
  ", or ",
  StyleBox["$MaxPrecision", "MR"],
  " to a value less than ",
  StyleBox["$MinPrecision", "MR"],
  ".\n\[FilledSmallSquare] You can set ",
  StyleBox["$MinPrecision", "MR"],
  " and ",
  StyleBox["$MaxPrecision", "MR"],
  " to the same value."
}], "Notes",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],

Cell[TextData[{
  StyleBox["$MaxPrecision", "MR"],
  " cannot be less than ",
  StyleBox["$MinPrecision", "MR"],
  "."
}], "Text",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MinPrecision = 30, $MaxPrecision = 20}, 
      2.`50 + 2.`50]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],

Cell[BoxData[
    \($MaxPrecision::"preccon" \(\(:\)\(\ \)\) 
      "Cannot set \!\($MaxPrecision\) such that $MaxPrecision < \
$MinPrecision."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],

Cell[BoxData[
    \(4.`50. \)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}]
}, Closed]],

Cell[TextData[{
  "This shows valid settings for ",
  StyleBox["$MaxPrecision", "MR"],
  " and ",
  StyleBox["$MinPrecision", "MR"],
  "."
}], "Text",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MinPrecision = 20, $MaxPrecision = 20}, 
      2.`50 + 2.`50]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],

Cell[BoxData[
    \(4.`20. \)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
$MinPrecision::preclck
$MaxPrecision::preclck\
\>", "ObjectNameWarningMessages",
  CellTags->{"$MinPrecision::preclck", "$MaxPrecision::preclck"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"preclck\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["sym",
          "TI"], " ", "is", " ", "currently", " ", "under", " ", "the", " ", 
        "control", " ", "of", " ", "internal", " ", \(routines . \ You\), " ",
         "cannot", " ", "change", " ", "it", " ", "at", " ", "this", 
        " ", \(\(time\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"$MinPrecision::preclck", "$MaxPrecision::preclck"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to change the value of ",
  StyleBox["$MinPrecision", "MR"],
  " or ",
  StyleBox["$MaxPrecision", "MR"],
  " while the value has been temporarily locked by an internal function.\n\
\[FilledSmallSquare] The values of ",
  StyleBox["$MinPrecision", "MR"],
  " and ",
  StyleBox["$MaxPrecision", "MR"],
  " are locked briefly by certain numerical algorithms.  It is normally not \
desirable to allow the precision to vary during these calculations.\n\
\[FilledSmallSquare] There are no common examples in which this message is \
generated.  If you find an example in which this message is generated and \
have questions about the cause, please contact Technical Support."
}], "Notes",
  CellTags->{"$MinPrecision::preclck", "$MaxPrecision::preclck"}]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::lzero", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::lzero"],

Cell[BoxData[
    \(NIntegrate::"lzero" \(\(:\)\(\ \)\) 
      "Method->Oscillatory does not support negative, complex, or variable \
indices for BesselY and BesselJ."\)], "Message",
  CellTags->"NIntegrate::lzero"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Method->Oscillatory", "MR"],
  " is used in ",
  StyleBox["NIntegrate", "MR"],
  " and the integrand includes a Bessel function in which the index is \
negative, complex, or variable.\n\[FilledSmallSquare] ",
  StyleBox["BesselJ", "MR"],
  " and ",
  StyleBox["BesselY", "MR"],
  " with negative indices are often related through simple identities to ",
  StyleBox["BesselJ", "MR"],
  " and ",
  StyleBox["BesselY", "MR"],
  " with positive indices.\n\[FilledSmallSquare] ",
  StyleBox["NIntegrate", "MR"],
  " with ",
  StyleBox["Method->Oscillatory", "MR"],
  " is programmed to handle integrands in which one factor is ",
  StyleBox["Sin", "MR"],
  ", ",
  StyleBox["Cos", "MR"],
  ", ",
  StyleBox["BesselJ", "MR"],
  ", or ",
  StyleBox["BesselY", "MR"],
  " with a simple polynomial argument."
}], "Notes",
  CellTags->"NIntegrate::lzero"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::lzero"],

Cell[TextData[{
  "An error occurs in this example because the variable of integration occurs \
in the index of ",
  StyleBox["BesselJ", "MR"],
  "."
}], "Text",
  CellTags->"NIntegrate::lzero"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[BesselJ[x, x] Exp[\(-x\)], {x, 0, Infinity}, 
      Method \[Rule] Oscillatory]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::lzero"],

Cell[BoxData[
    \(NIntegrate::"lzero" \(\(:\)\(\ \)\) 
      "Method->Oscillatory does not support negative, complex, or variable \
indices for BesselY and BesselJ."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::lzero"],

Cell[BoxData[
    \(NIntegrate[BesselJ[x, x]\ \[ExponentialE]\^\(-x\), {x, 0, \[Infinity]}, 
      Method \[Rule] Oscillatory]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::lzero"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NSum::nsnum", "ObjectNameWarningMessages",
  CellTags->"NSum::nsnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NSum::"nsnum"\), \(\(:\)\(\ \)\), "Summand", 
        " ", \((or\ its\ derivative)\), " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "numerical", " ", "at", " ", 
        "point", " ", 
        StyleBox["var",
          "TI"]}], " ", "=", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], "."}]}]], "Message",
  CellTags->"NSum::nsnum"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["NSum", "MR"],
  " does not evaluate to a number at the indicated value of the summation \
variable."
}], "Notes",
  CellTags->"NSum::nsnum"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NSum::nsnum"],

Cell[TextData[{
  "The summand ",
  StyleBox["Null", "MR"],
  " does not evaluate to a number."
}], "Text",
  CellTags->"NSum::nsnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSum[Null, {k, 25}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NSum::nsnum"],

Cell[BoxData[
    \(NSum::"nsnum" \(\(:\)\(\ \)\) 
      "Summand (or its derivative) \!\(Null\) is not numerical at point \!\(k\
\) = \!\(16\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NSum::nsnum"],

Cell[BoxData[
    \(NSum[Null, {k, 25}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NSum::nsnum"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::ncvi", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::ncvi"],

Cell[BoxData[
    RowBox[{\(NIntegrate::"ncvi"\), \(\(:\)\(\ \)\), "NIntegrate", " ", 
      "failed", " ", "to", " ", "converge", " ", "to", " ", "prescribed", " ",
       "accuracy", " ", "after", " ", 
      StyleBox["n",
        "TI"], " ", "iterated", " ", "refinements", " ", "in", " ", 
      StyleBox["var",
        "TI"], " ", "in", " ", "the", " ", "interval", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NIntegrate::ncvi"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated number of refinements of \
the range of integration is not sufficient to achieve the requested accuracy.\
\n\[FilledSmallSquare] This message can be generated when ",
  StyleBox["NIntegrate", "MR"],
  " is used with ",
  StyleBox["Method\[Rule]DoubleExponential", "MR"],
  " or ",
  StyleBox["Method\[Rule]Trapezoidal", "MR"],
  ".\n\[FilledSmallSquare] Difficulties with convergence of a numerical \
integral can sometimes be addressed by using a different value of the ",
  StyleBox["Method", "MR"],
  " option, decreasing the value of the ",
  StyleBox["PrecisionGoal", "MR"],
  " or ",
  StyleBox["AccuracyGoal", "MR"],
  " option, increasing the value of the ",
  StyleBox["MaxRecursion", "MR"],
  " option, or transforming the integral to a form that can be handled more \
easily."
}], "Notes",
  CellTags->"NIntegrate::ncvi"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::ncvi"],

Cell["\<\
This integrand has an awkward singularity that cannot easily be \
integrated numerically.\
\>", "Text",
  CellTags->"NIntegrate::ncvi"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[Exp[1/x]], {x, 0, 1}, 
      Method -> DoubleExponential]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::ncvi"],

Cell[BoxData[
    \(NIntegrate::"slwcon" \(\(:\)\(\ \)\) 
      "Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration being 0, oscillatory \
integrand, or insufficient WorkingPrecision. If your integrand is oscillatory \
try using the option Method->Oscillatory in NIntegrate."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::ncvi"],

Cell[BoxData[
    \(NIntegrate::"ncvi" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(7\) \
iterated refinements in \!\(x\) in the interval \!\({\({x, 0.`, \
1.`}\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::ncvi"],

Cell[BoxData[
    \(\(-0.12105319292080942`\)\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::ncvi"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NSum::nslim", "ObjectNameWarningMessages",
  CellTags->"NSum::nslim"],

Cell[BoxData[
    RowBox[{\(NSum::"nslim"\), \(\(:\)\(\ \)\), \(\(Limit\)\(\ \)\(of\)\(\ \)\
\(summation\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ \(\(number\)\(.\)\)\)\)}]], "Message",
  CellTags->"NSum::nslim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the limits on the summation variable \
in ",
  StyleBox["NSum", "MR"],
  " are not numeric quantities."
}], "Notes",
  CellTags->"NSum::nslim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NSum::nslim"],

Cell[TextData[{
  "This input generates an error because the second element in ",
  StyleBox["NSum", "MR"],
  " does not give a numerical limit for the variable of summation."
}], "Text",
  CellTags->"NSum::nslim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSum[k, {k, k}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NSum::nslim"],

Cell[BoxData[
    \(NSum::"nslim" \(\(:\)\(\ \)\) 
      "Limit of summation \!\(k\) is not a number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NSum::nslim"],

Cell[BoxData[
    \(NSum[k, {k, k}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NSum::nslim"]
}, Closed]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["NSum", "MR"],
  "."
}], "Text",
  CellTags->"NSum::nslim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSum[k, {k, 10}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NSum::nslim"],

Cell[BoxData[
    \(55\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NSum::nslim"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::noeval", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::noeval"],

Cell[BoxData[
    \(NIntegrate::"noeval" \(\(:\)\(\ \)\) \(For\ oscillating\ integrals, \ 
      individual\ points\ where\ evaluation\ takes\ place\ is\ not\ \
supported; \ 
      the\ range\ has\ to\ be\ in\ the\ form\ \(\({x, \ xmin, \ 
            xmax}\)\(.\)\)\)\)], "Message",
  CellTags->"NIntegrate::noeval"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["NIntegrate", "MR"],
  " is used with ",
  StyleBox["Method->Oscillatory", "MR"],
  " and the range specification is not a list with three elements.\n\
\[FilledSmallSquare] The range specification is the second argument in ",
  StyleBox["NIntegrate", "MR"],
  ".\n\[FilledSmallSquare] When ",
  StyleBox["NIntegrate", "MR"],
  " is used with methods other than ",
  StyleBox["Method->Oscillatory", "MR"],
  ", the range specification can have three or more elements to indicate \
integration between several endpoints."
}], "Notes",
  CellTags->"NIntegrate::noeval"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::noeval"],

Cell[TextData[{
  "This input generates a message because the second argument to ",
  StyleBox["NIntegrate", "MR"],
  " has four elements."
}], "Text",
  CellTags->"NIntegrate::noeval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x]/x^2, {x, 1, 2, Infinity}, 
      Method -> Oscillatory]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::noeval"],

Cell[BoxData[
    \(NIntegrate::"noeval" \(\(:\)\(\ \)\) 
      "For oscillating integrals, individual points where evaluation takes \
place is not supported; the range has to be in the form {x, xmin, xmax}."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::noeval"],

Cell[BoxData[
    \(NIntegrate[Sin[x]\/x\^2, {x, 1, 2, \[Infinity]}, 
      Method \[Rule] Oscillatory]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::noeval"]
}, Closed]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["NIntegrate", "MR"],
  " with ",
  StyleBox["Method->Oscillatory", "MR"],
  "."
}], "Text",
  CellTags->"NIntegrate::noeval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x]/x^2, {x, 1, Infinity}, 
      Method -> Oscillatory]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::noeval"],

Cell[BoxData[
    \(0.5040670619069316`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::noeval"]
}, Closed]],

Cell[TextData[{
  "This message is also generated if ",
  StyleBox["NIntegrate", "MR"],
  " is used with ",
  StyleBox["Method->Oscillatory", "MR"],
  " and the range specification has less than three elements."
}], "Text",
  CellTags->"NIntegrate::noeval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x]/x^2, {x, Infinity}, Method -> Oscillatory]\)], "Input",\

  CellLabel->"In[3]:=",
  CellTags->"NIntegrate::noeval"],

Cell[BoxData[
    \(NIntegrate::"noeval" \(\(:\)\(\ \)\) 
      "For oscillating integrals, individual points where evaluation takes \
place is not supported; the range has to be in the form {x, xmin, xmax}."\)], \
"Message",
  CellLabel->"From In[3]:=",
  CellTags->"NIntegrate::noeval"],

Cell[BoxData[
    \(NIntegrate[Sin[x]\/x\^2, {x, \[Infinity]}, 
      Method \[Rule] Oscillatory]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"NIntegrate::noeval"]
}, Closed]],

Cell["\<\
A range specification with more than three elements can be used for \
other methods of integration.  This is useful, for example, in computing \
contour integrals.\
\>", "Text",
  CellTags->"NIntegrate::noeval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[1/x, {x, 1, I, \(-1\), \(-I\), 1}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"NIntegrate::noeval"],

Cell[BoxData[
    \(1.1102230246251565`*^-16 + 6.28318530717957`\ \[ImaginaryI]\)], "Output",\

  CellLabel->"Out[4]=",
  CellTags->"NIntegrate::noeval"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::nlim", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::nlim"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NIntegrate::"nlim"\), ":", " ", 
        StyleBox["var",
          "TI"]}], " ", "=", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", " ", "limit", 
        " ", "of", " ", \(\(integration\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NIntegrate::nlim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when non-numerical limits of integration \
are encountered in ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Notes",
  CellTags->"NIntegrate::nlim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::nlim"],

Cell[TextData[{
  "If the symbol ",
  StyleBox["b", "MR"],
  " in this example does not evaluate to a number, a warning message is \
generated and the integral is returned unevaluated."
}], "Text",
  CellTags->"NIntegrate::nlim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[x\ Exp[x], {x, 0, b}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::nlim"],

Cell[BoxData[
    \(NIntegrate::"nlim" \(\(:\)\(\ \)\) 
      "\!\(x\) = \!\(b\) is not a valid limit of integration."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::nlim"],

Cell[BoxData[
    \(NIntegrate[x\ \[ExponentialE]\^x, {x, 0, b}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::nlim"]
}, Closed]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Text",
  CellTags->"NIntegrate::nlim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[x\ Exp[x], {x, 0, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::nlim"],

Cell[BoxData[
    \(41.17107384637535`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::nlim"]
}, Closed]],

Cell["\<\
In a multi-dimensional integral, the warning message will include a \
point on the boundary of the region of integration.\
\>", "Text",
  CellTags->"NIntegrate::nlim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[x\ y, {x, 0, 1}, {y, 0, b}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"NIntegrate::nlim"],

Cell[BoxData[
    \(NIntegrate::"nlim" \(\(:\)\(\ \)\) 
      "\!\({x, y}\) = \!\({0.5`, b}\) is not a valid limit of \
integration."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"NIntegrate::nlim"],

Cell[BoxData[
    \(NIntegrate[x\ y, {x, 0, 1}, {y, 0, b}]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"NIntegrate::nlim"]
}, Closed]],

Cell["\<\
If a symbolic limit of integration is needed in a definition, you \
can use a pattern to prevent the rule from being applied until a numerical \
value is inserted for the limit.\
\>", "Text",
  CellTags->"NIntegrate::nlim"],

Cell[BoxData[
    \(f[b_?NumberQ] := NIntegrate[x\ Exp[x], {x, 0, b}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"NIntegrate::nlim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[3]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"NIntegrate::nlim"],

Cell[BoxData[
    \(41.17107384637535`\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"NIntegrate::nlim"]
}, Closed]],

Cell[TextData[{
  "Unset the rule for ",
  StyleBox["f", "MR"],
  "."
}], "Text",
  CellTags->"NIntegrate::nlim"],

Cell[BoxData[
    \(Unset[f[b_?NumberQ]]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"NIntegrate::nlim"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::vars", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::vars"],

Cell[BoxData[
    RowBox[{\(NIntegrate::"vars"\), \(\(:\)\(\ \)\), \(\(Integration\)\(\ \
\)\(range\)\(\ \)\(specification\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ of\ the\ form\ \(\({x, \ xmin, \  ... , \ 
            xmax}\)\(.\)\)\)\)}]], "Message",
  CellTags->"NIntegrate::vars"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a range specification in ",
  StyleBox["NIntegrate", "MR"],
  " is not a list with three or more elements.\n\[FilledSmallSquare] The \
range and the integration variable for a one-dimensional integral is \
specified in the second argument of ",
  StyleBox["NIntegrate", "MR"],
  ".  Range specifications for multi-dimensional integrals are specified \
using additional arguments."
}], "Notes",
  CellTags->"NIntegrate::vars"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::vars"],

Cell[TextData[{
  "The range specification in ",
  StyleBox["NIntegrate", "MR"],
  " must be a list with three or more elements."
}], "Text",
  CellTags->"NIntegrate::vars"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[x\ Exp[x], x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::vars"],

Cell[BoxData[
    \(NIntegrate::"vars" \(\(:\)\(\ \)\) 
      "Integration range specification \!\(x\) is not of the form {x, xmin, \
..., xmax}."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::vars"],

Cell[BoxData[
    \(NIntegrate[x\ \[ExponentialE]\^x, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::vars"]
}, Closed]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Text",
  CellTags->"NIntegrate::vars"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[x\ Exp[x], {x, 0, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::vars"],

Cell[BoxData[
    \(41.17107384637535`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::vars"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["RealDigits::ndig", "ObjectNameWarningMessages",
  CellTags->"RealDigits::ndig"],

Cell[BoxData[
    \(RealDigits::"ndig" \(\(:\)\(\ \)\) \(The\ number\ of\ digits\ to\ \
return\ cannot\ be\ \(\(determined\)\(.\)\)\)\)], "Message",
  CellTags->"RealDigits::ndig"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["RealDigits", "MR"],
  " is used with one or two arguments and the arguments are either \
non-numeric or are exact.\n\[FilledSmallSquare] You can use ",
  StyleBox["IntegerDigits", "MR"],
  " to get the digits of an integer."
}], "Notes",
  CellTags->"RealDigits::ndig"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"RealDigits::ndig"],

Cell[TextData[{
  "This example generates an error because the arguments in ",
  StyleBox["RealDigits", "MR"],
  " are exact numbers."
}], "Text",
  CellTags->"RealDigits::ndig"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RealDigits[Pi, \ 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"RealDigits::ndig"],

Cell[BoxData[
    \(RealDigits::"ndig" \(\(:\)\(\ \)\) 
      "The number of digits to return cannot be determined."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"RealDigits::ndig"],

Cell[BoxData[
    \(RealDigits[\[Pi], 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"RealDigits::ndig"]
}, Closed]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["RealDigits", "MR"],
  "."
}], "Text",
  CellTags->"RealDigits::ndig"],

Cell[CellGroupData[{

Cell[BoxData[
    \(RealDigits[N[Pi], \ 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"RealDigits::ndig"],

Cell[BoxData[
    \({{1, 1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 1, 1, 0, 1, 
        0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 1, 1, 0, 1, 0, 
        0, 0, 1, 1, 0, 0, 0}, 2}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"RealDigits::ndig"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
RealDigits::rbase
MantissaExponent::rbase\
\>", "ObjectNameWarningMessages",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"rbase\"\>"}], \(\(:\)\(\ \)\), "\<\"Base `1` is not a real \
number greater than 1.\"\>"}]], "Message",
  CellLabel->"From In[234]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["RealDigits", "MR"],
  " or ",
  StyleBox["MantissaExponent", "MR"],
  " is not a real number or is not greater than 1."
}], "Notes",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell["The base used for computing digits must be greater than 1.", "Text",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(RealDigits[25.7, 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell[BoxData[
    \(RealDigits::"rbase" \(\(:\)\(\ \)\) 
      "Base \!\(1\) is not a real number greater than 1."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}],

Cell[BoxData[
    \(RealDigits[25.7`, 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}]
}, Closed]],

Cell[TextData[{
  "This shows a correct use of the second argument in ",
  StyleBox["RealDigits", "MR"],
  "."
}], "Text",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(RealDigits[25.7, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell[BoxData[
    \({{1, 1, 0, 0, 1, 1, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 
        1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 1, 1, 0, 
        0, 1, 1, 0, 0, 1, 1}, 5}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}]
}, Closed]],

Cell[TextData[{
  "The second argument in ",
  StyleBox["MantissaExponent", "MR"],
  " should also be a real number greater than 1."
}], "Text",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(MantissaExponent[18.7, \ Automatic]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell[BoxData[
    \(MantissaExponent::"rbase" \(\(:\)\(\ \)\) 
      "Base \!\(Automatic\) is not a real number greater than 1."\)], \
"Message",
  CellLabel->"From In[3]:=",
  CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}],

Cell[BoxData[
    \(MantissaExponent[18.7`, Automatic]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
NProduct::istep
NSum::istep\
\>", "ObjectNameWarningMessages",
  CellTags->{"NProduct::istep", "NSum::istep"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"istep\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "get", " ", "from", " ", 
      StyleBox["min",
        "TI"], " ", "to", " ", 
      StyleBox["max",
        "TI"], " ", "in", " ", "steps", " ", "of", " ", 
      RowBox[{
        StyleBox["s",
          "TI"], "."}]}]], "Message",
  CellTags->{"NProduct::istep", "NSum::istep"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the step size specified in ",
  StyleBox["NSum", "MR"],
  " or ",
  StyleBox["NProduct", "MR"],
  " is incompatible with the limits.\n\[FilledSmallSquare] The step size is \
the fourth element in a range specification of the form ",
  StyleBox["{", "MR"],
  StyleBox["k", "TI"],
  StyleBox[",", "MR"],
  StyleBox["min", "TI"],
  StyleBox[",", "MR"],
  StyleBox["max", "TI"],
  StyleBox[",", "MR"],
  StyleBox["step", "TI"],
  StyleBox["}", "MR"],
  "."
}], "Notes",
  CellTags->{"NProduct::istep", "NSum::istep"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NProduct::istep", "NSum::istep"}],

Cell[TextData[{
  "An error occurs in this example because it is not possible to go from ",
  StyleBox["1", "MR"],
  " to ",
  StyleBox["10", "MR"],
  " in steps of ",
  StyleBox["\[ImaginaryI]", "MR"],
  "."
}], "Text",
  CellTags->{"NProduct::istep", "NSum::istep"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSum[1/k^2, {k, 1, 10, \[ImaginaryI]}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NProduct::istep", "NSum::istep"}],

Cell[BoxData[
    \(NSum::"istep" \(\(:\)\(\ \)\) 
      "Cannot get from \!\(1\) to \!\(10\) in steps of \
\!\(\[ImaginaryI]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NProduct::istep", "NSum::istep"}],

Cell[BoxData[
    \(NSum[1\/k\^2, {k, 1, 10, \[ImaginaryI]}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NProduct::istep", "NSum::istep"}]
}, Closed]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["NSum", "MR"],
  " with a step size of ",
  StyleBox["\[ImaginaryI]", "MR"],
  "."
}], "Text",
  CellTags->{"NProduct::istep", "NSum::istep"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSum[
      1/k^2, {k, \[ImaginaryI], 10  \[ImaginaryI], \[ImaginaryI]}]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->{"NProduct::istep", "NSum::istep"}],

Cell[BoxData[
    \(\(-1.5497677311665408`\) + 0.`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"NProduct::istep", "NSum::istep"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Accuracy::mnprec
Precision::mnprec\
\>", "ObjectNameWarningMessages",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"mnprec\"\>"}], \(\(:\)\(\ \)\), "\<\"Value `1` would be \
inconsistent with $MinPrecision; bounding by $MinPrecision instead.\"\>"}]], \
"Message",
  CellLabel->"From In[237]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by ",
  StyleBox["Accuracy[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " or ",
  StyleBox["Precision[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " when the precision of ",
  StyleBox["expr", "TI"],
  " is less than the value of ",
  StyleBox["$MinPrecision", "MR"],
  ".\n\[FilledSmallSquare] Since precision and accuracy are related, setting \
the accuracy of a number also sets the precision.\n\[FilledSmallSquare] The \
default value of ",
  StyleBox["$MinPrecision", "MR"],
  " is zero.  This error occurs only if the value of ",
  StyleBox["$MinPrecision", "MR"],
  " is increased or in unusual examples that generate results with negative \
precision."
}], "Notes",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],

Cell[TextData[{
  "This error can occur as a result of direct manipulation of the value of ",
  StyleBox["$MinPrecision", "MR"],
  "."
}], "Text",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MinPrecision, x}, \n\t
      x = N[Pi, 20]; \n\t$MinPrecision = 30; \n\tPrecision[x]\n]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],

Cell[BoxData[
    \(Precision::"mnprec" \(\(:\)\(\ \)\) 
      "Value \!\(20.`\) would be inconsistent with $MinPrecision; bounding by \
$MinPrecision instead."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],

Cell[BoxData[
    \(30.`\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}]
}, Closed]],

Cell["A similar error can occur when processing certain inputs.", "Text",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression["\<5.7``-10\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],

Cell[BoxData[
    \(Accuracy::"mnprec" \(\(:\)\(\ \)\) 
      "Value \!\(-10.`\) would be inconsistent with $MinPrecision; bounding \
by $MinPrecision instead."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],

Cell[BoxData[
    \(0`-9.244125144327509\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Accuracy::mxprec
Precision::mxprec\
\>", "ObjectNameWarningMessages",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"mxprec\"\>"}], \(\(:\)\(\ \)\), "\<\"Value `1` would be \
inconsistent with $MaxPrecision; bounding by $MaxPrecision instead.\"\>"}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Precision", "MR"],
  " or ",
  StyleBox["Accuracy", "MR"],
  " is used for a number with precision greater than the current value of ",
  StyleBox["$MaxPrecision", "MR"],
  "."
}], "Notes",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],

Cell[TextData[{
  "A warning message is generated in this example because the specified value \
of ",
  StyleBox["$MaxPrecision", "MR"],
  " is less than the typical precision of a machine number."
}], "Text",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MaxPrecision = 10}, Precision[1.7`20]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],

Cell[BoxData[
    \(Precision::"mxprec" \(\(:\)\(\ \)\) 
      "Value \!\(20.`\) would be inconsistent with $MaxPrecision; bounding by \
$MaxPrecision instead."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],

Cell[BoxData[
    \(10.`\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}]
}, Closed]],

Cell["A similar message can occur when reading numbers.", "Text",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MaxPrecision = 20}, ToExpression["\<1.7``30\>"]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],

Cell[BoxData[
    \(Accuracy::"mnprec" \(\(:\)\(\ \)\) 
      "Value \!\(30.`\) would be inconsistent with $MinPrecision; bounding by \
$MinPrecision instead."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],

Cell[BoxData[
    \(1.7`20. \)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Fourier::fftl
InverseFourier::fftl\
\>", "ObjectNameWarningMessages",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"fftl\"\>"}], \(\(:\)\(\ \)\), "\<\"Argument `1` is not a \
non-empty list or rectangular array of numeric quantities.\"\>"}]], "Message",\

  CellLabel->"From In[74]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["Fourier", "MR"],
  " or ",
  StyleBox["InverseFourier", "MR"],
  " does not have the expected form."
}], "Notes",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],

Cell["\<\
An error occurs in this example because the argument includes \
expressions that are not numbers.\
\>", "Text",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fourier[{Cos, Sin}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],

Cell[BoxData[
    \(Fourier::"fftl" \(\(:\)\(\ \)\) 
      "Argument \!\({Cos, Sin}\) is not a non-empty list or rectangular array \
of numeric quantities."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],

Cell[BoxData[
    \(Fourier[{Cos, Sin}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}]
}, Closed]],

Cell[TextData[{
  "This shows valid input in ",
  StyleBox["Fourier", "MR"],
  "."
}], "Text",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fourier[{Cos[1], Sin[2]}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],

Cell[BoxData[
    \({\(\(1.0250218009940077`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(-0.2609189522538282`\) + 
        0.`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FromDigits::nlst", "ObjectNameWarningMessages",
  CellTags->"FromDigits::nlst"],

Cell[BoxData[
    RowBox[{\(FromDigits::"nlst"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \
\)\(expression\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ list\ of\ \(\(digits\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"FromDigits::nlst"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["FromDigits", "MR"],
  " is not a list."
}], "Notes",
  CellTags->"FromDigits::nlst"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FromDigits::nlst"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["FromDigits", "MR"],
  " is expected to be a list."
}], "Text",
  CellTags->"FromDigits::nlst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FromDigits[25]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FromDigits::nlst"],

Cell[BoxData[
    \(FromDigits::"nlst" \(\(:\)\(\ \)\) 
      "The expression \!\(25\) is not a list of digits."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FromDigits::nlst"],

Cell[BoxData[
    \(FromDigits[25]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FromDigits::nlst"]
}, Closed]],

Cell[TextData[{
  "This shows valid input for ",
  StyleBox["FromDigits", "MR"],
  "."
}], "Text",
  CellTags->"FromDigits::nlst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FromDigits[{2, 5}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FromDigits::nlst"],

Cell[BoxData[
    \(25\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FromDigits::nlst"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FunctionInterpolation::argdim", "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::argdim"],

Cell[BoxData[
    \(FunctionInterpolation::"argdim" \(\(:\)\(\ \)\) \(The\ dimension\ of\ \
the\ argument\ to\ an\ InterpolatingFunction\ function\ object\ in\ the\ \
input\ does\ not\ match\ the\ dimension\ of\ the\ \(\(InterpolatingFunction\)\
\(.\)\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"FunctionInterpolation::argdim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an ",
  StyleBox["InterpolatingFunction", "MR"],
  " expression is used with an incorrect number of arguments and occurs as an \
argument in ",
  StyleBox["FunctionInterpolation", "MR"],
  "."
}], "Notes",
  CellTags->"FunctionInterpolation::argdim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FunctionInterpolation::argdim"],

Cell[TextData[{
  "An error occurs in this example because a one-dimensional ",
  StyleBox["InterpolatingFunction", "MR"],
  " expression is used with two arguments."
}], "Text",
  CellTags->"FunctionInterpolation::argdim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FunctionInterpolation[
      Evaluate[3\ \(Interpolation[{1, 2, 3, 2, 1}]\)[x, y]\n\t], {x, 1, 
        5}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FunctionInterpolation::argdim"],

Cell[BoxData[
    \(FunctionInterpolation::"argdim" \(\(:\)\(\ \)\) 
      "The dimension of the argument to an InterpolatingFunction function \
object in the input does not match the dimension of the \
InterpolatingFunction."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FunctionInterpolation::argdim"],

Cell[BoxData[
    \(FunctionInterpolation::"nreal" \(\(:\)\(\ \)\) 
      "Near \!\({x}\) = \!\({1}\), the function did not evaluate to a real \
number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FunctionInterpolation::argdim"],

Cell[BoxData[
    \(FunctionInterpolation::"nreal" \(\(:\)\(\ \)\) 
      "Near \!\({x}\) = \!\({7\/5}\), the function did not evaluate to a real \
number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FunctionInterpolation::argdim"],

Cell[BoxData[
    \(FunctionInterpolation::"nreal" \(\(:\)\(\ \)\) 
      "Near \!\({x}\) = \!\({9\/5}\), the function did not evaluate to a real \
number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FunctionInterpolation::argdim"],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(FunctionInterpolation :: \"nreal\"\) will be \
suppressed during this calculation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FunctionInterpolation::argdim"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 5}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FunctionInterpolation::argdim"]
}, Closed]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Interpolation", "MR"],
  " and ",
  StyleBox["FunctionInterpolation", "MR"],
  "."
}], "Text",
  CellTags->"FunctionInterpolation::argdim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FunctionInterpolation[
      Evaluate[3\ \(Interpolation[{1, 2, 3, 2, 1}]\)[x]\n\t], {x, 1, 
        5}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FunctionInterpolation::argdim"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 5}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FunctionInterpolation::argdim"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FunctionInterpolation::precg", "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::precg"],

Cell[BoxData[
    RowBox[{\(FunctionInterpolation::"precg"\), \(\(:\)\(\ \)\), \(\(\(Value\ \
of\ option\ PrecisionGoal\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", \(is\ not\ Automatic, \ Infinity, \ 
      or\ a\ positive\ machine - 
        size\ real\ or\ \(\(integer\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"FunctionInterpolation::precg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["PrecisionGoal", "MR"],
  " option in ",
  StyleBox["FunctionInterpolation", "MR"],
  " does not have the indicated form."
}], "Notes",
  CellTags->"FunctionInterpolation::precg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FunctionInterpolation::precg"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["PrecisionGoal", "MR"],
  " option in ",
  StyleBox["FunctionInterpolation", "MR"],
  "."
}], "Text",
  CellTags->"FunctionInterpolation::precg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FunctionInterpolation[Cos[x], {x, 1, 2}, InterpolationPoints -> 5, 
      PrecisionGoal -> None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FunctionInterpolation::precg"],

Cell[BoxData[
    \(FunctionInterpolation::"precg" \(\(:\)\(\ \)\) 
      "Value of option PrecisionGoal -> \!\(None\) is not Automatic, \
Infinity, or a positive machine-size real or integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FunctionInterpolation::precg"],

Cell[BoxData[
    \(FunctionInterpolation[Cos[x], {x, 1, 2}, InterpolationPoints \[Rule] 5, 
      PrecisionGoal \[Rule] None]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FunctionInterpolation::precg"]
}, Closed]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["PrecisionGoal", "MR"],
  " option in ",
  StyleBox["FunctionInterpolation", "MR"],
  "."
}], "Text",
  CellTags->"FunctionInterpolation::precg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FunctionInterpolation[Cos[x], {x, 1, 2}, InterpolationPoints -> 5, 
      PrecisionGoal -> 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FunctionInterpolation::precg"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 2}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FunctionInterpolation::precg"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FunctionInterpolation::range", "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::range"],

Cell[BoxData[
    RowBox[{\(FunctionInterpolation::"range"\), \(\(:\)\(\ \)\), \(\(Argument\
\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ in\ the\ form\ of\ a\ range\ specification, \
\ \(\({x, \ xmin, \ xmax}\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"FunctionInterpolation::range"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated argument in ",
  StyleBox["FunctionInterpolation", "MR"],
  " does not have the expected form."
}], "Notes",
  CellTags->"FunctionInterpolation::range"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FunctionInterpolation::range"],

Cell["\<\
An error occurs in this example because the second argument does \
not include the range of the variable.\
\>", "Text",
  CellTags->"FunctionInterpolation::range"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FunctionInterpolation[Cos[x], {x}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FunctionInterpolation::range"],

Cell[BoxData[
    \(FunctionInterpolation::"range" \(\(:\)\(\ \)\) 
      "Argument \!\({x}\) is not in the form of a range specification, {x, \
xmin, xmax}."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FunctionInterpolation::range"],

Cell[BoxData[
    \(FunctionInterpolation[Cos[x], {x}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FunctionInterpolation::range"]
}, Closed]],

Cell[TextData[{
  "This example shows a valid variable specification in ",
  StyleBox["FunctionInterpolation", "MR"],
  "."
}], "Text",
  CellTags->"FunctionInterpolation::range"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FunctionInterpolation[Cos[x], {x, 1, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FunctionInterpolation::range"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1.`, 2.`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FunctionInterpolation::range"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FunctionInterpolation::accg", "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::accg"],

Cell[BoxData[
    RowBox[{\(FunctionInterpolation::"accg"\), \(\(:\)\(\ \)\), \(\(\(Value\ \
of\ option\ AccuracyGoal\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ Automatic, \ Infinity, \ 
      or\ a\ machine - size\ \(\(integer\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"FunctionInterpolation::accg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["AccuracyGoal", "MR"],
  " option in ",
  StyleBox["FunctionInterpolation", "MR"],
  " does not have the indicated form."
}], "Notes",
  CellTags->"FunctionInterpolation::accg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FunctionInterpolation::accg"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["AccuracyGoal", "MR"],
  " option in ",
  StyleBox["FunctionInterpolation", "MR"],
  "."
}], "Text",
  CellTags->"FunctionInterpolation::accg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FunctionInterpolation[Cos[x], {x, 1, 2}, InterpolationPoints -> 5, 
      AccuracyGoal -> None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FunctionInterpolation::accg"],

Cell[BoxData[
    \(FunctionInterpolation::"accg" \(\(:\)\(\ \)\) 
      "Value of option AccuracyGoal -> \!\(None\) is not Automatic, Infinity, \
or a machine-size integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FunctionInterpolation::accg"],

Cell[BoxData[
    \(FunctionInterpolation[Cos[x], {x, 1, 2}, InterpolationPoints \[Rule] 5, 
      AccuracyGoal \[Rule] None]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FunctionInterpolation::accg"]
}, Closed]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["AccuracyGoal", "MR"],
  " option in ",
  StyleBox["FunctionInterpolation", "MR"],
  "."
}], "Text",
  CellTags->"FunctionInterpolation::accg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FunctionInterpolation[Cos[x], {x, 1, 2}, InterpolationPoints -> 5, 
      AccuracyGoal -> 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FunctionInterpolation::accg"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 2}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FunctionInterpolation::accg"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FunctionInterpolation::nreal", "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::nreal"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\(FunctionInterpolation::"nreal"\), ":", " ", 
          RowBox[{"Near", " ", 
            StyleBox["var",
              "TI"]}]}], " ", "=", " ", 
        StyleBox["expr",
          "TI"]}], ",", 
      " ", \(the\ function\ did\ not\ evaluate\ to\ a\ real\ \
\(\(number\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"FunctionInterpolation::nreal"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["FunctionInterpolation", "MR"],
  " does not evaluate to a real number at the indicated point."
}], "Notes",
  CellTags->"FunctionInterpolation::nreal"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FunctionInterpolation::nreal"],

Cell["\<\
An error occurs in this example because the first argument is \
complex in the range of the variable.\
\>", "Text",
  CellTags->"FunctionInterpolation::nreal"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FunctionInterpolation[Exp[I\ x], {x, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FunctionInterpolation::nreal"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FunctionInterpolation::nreal"]
}, Closed]],

Cell[TextData[{
  StyleBox["FunctionInterpolation", "MR"],
  " can be used to construct ",
  StyleBox["InterpolatingFunction", "MR"],
  " expressions separately for the real and imaginary parts of a complex \
function."
}], "Text",
  CellTags->"FunctionInterpolation::nreal"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(FunctionInterpolation[Re[Exp[I\ x]], {x, 0, 1}]\)[z] + 
      I\ \(FunctionInterpolation[Im[Exp[I\ x]], {x, 0, 1}]\)[z]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FunctionInterpolation::nreal"],

Cell[BoxData[
    RowBox[{
      RowBox[{"\[ImaginaryI]", " ", 
        RowBox[{
          TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
            False,
            Editable->False], "[", "z", "]"}]}], "+", 
      RowBox[{
        TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
          False,
          Editable->False], "[", "z", "]"}]}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FunctionInterpolation::nreal"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FunctionInterpolation::npts", "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::npts"],

Cell[BoxData[
    RowBox[{\(FunctionInterpolation::"npts"\), \(\(:\)\(\ \)\), \(\(\(Value\ \
of\ option\ InterpolationPoints\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ machine - size\ integer\  >= \ 
        2. \)\)}]], "Message",
  CellTags->"FunctionInterpolation::npts"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["InterpolationPoints", "MR"],
  " option in ",
  StyleBox["FunctionInterpolation", "MR"],
  " does not have the expected form."
}], "Notes",
  CellTags->"FunctionInterpolation::npts"]
}, Closed]],

Cell[CellGroupData[{

Cell["FunctionInterpolation::ncvb", "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::ncvb"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(FunctionInterpolation::"ncvb"\), ":", " ", 
        RowBox[{
        "FunctionInterpolation", " ", "failed", " ", "to", " ", "meet", " ", 
          "the", " ", "prescribed", " ", "accuracy", " ", "and", " ", 
          "precision", " ", "goals", " ", "after", " ", 
          StyleBox["n",
            "TI"], " ", "recursive", " ", "bisections", " ", "near", " ", 
          StyleBox["var",
            "TI"]}]}], " ", "=", " ", 
      RowBox[{
        RowBox[{
          StyleBox["val",
            "TI"], ".", " ", "Continuing"}], " ", "to", " ", "refine", 
        " ", \(\(elsewhere\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"FunctionInterpolation::ncvb"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["FunctionInterpolation", "MR"],
  " is unable to compute a suitable interpolation using the indicated number \
of recursive refinements of the interval.\n\[FilledSmallSquare] This message \
is most often seen for functions that have a sharp feature or that have \
features that are difficult to approximate.\n\[FilledSmallSquare] This error \
can usually be corrected by increasing the value of the ",
  StyleBox["MaxRecursion", "MR"],
  " option, decreasing the ",
  StyleBox["AccuracyGoal", "MR"],
  " or ",
  StyleBox["PrecisionGoal", "MR"],
  " options, or through qualitative changes in the input, such as breaking \
the interpolation up into smooth segments."
}], "Notes",
  CellTags->"FunctionInterpolation::ncvb"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FunctionInterpolation::ncvb"],

Cell["\<\
An error occurs in this example because of difficulties \
approximating the sharp feature in the function given in the first \
argument.\
\>", "Text",
  CellTags->"FunctionInterpolation::ncvb"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FunctionInterpolation[Sqrt[x], {x, 0, 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FunctionInterpolation::ncvb"],

Cell[BoxData[
    \(FunctionInterpolation::"ncvb" \(\(:\)\(\ \)\) 
      "FunctionInterpolation failed to meet the prescribed accuracy and \
precision goals after \!\(6\) recursive bisections near \!\(x\) = \!\(0.`\). \
Continuing to refine elsewhere."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FunctionInterpolation::ncvb"],

Cell[BoxData[
    \(FunctionInterpolation::"ncvb" \(\(:\)\(\ \)\) 
      "FunctionInterpolation failed to meet the prescribed accuracy and \
precision goals after \!\(6\) recursive bisections near \!\(x\) = \
\!\(0.0078125`\). Continuing to refine elsewhere."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"FunctionInterpolation::ncvb"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{0.`, 1.`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FunctionInterpolation::ncvb"]
}, Closed]],

Cell[TextData[{
  "The interpolation can be constructed without error by reducing the value \
of the ",
  StyleBox["AccuracyGoal", "MR"],
  " option."
}], "Text",
  CellTags->"FunctionInterpolation::ncvb"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FunctionInterpolation[Sqrt[x], {x, 0, 1}, AccuracyGoal -> 2]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->"FunctionInterpolation::ncvb"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{0, 1}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FunctionInterpolation::ncvb"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Interpolation::inlen", "ObjectNameWarningMessages",
  CellTags->"Interpolation::inlen"],

Cell[BoxData[
    \(Interpolation::"inlen" \(\(:\)\(\ \)\) 
      "Inconsistent element `1` encountered; all data elements must have the \
same length."\)], "Message",
  CellLabel->"From In[264]:=",
  CellTags->"Interpolation::inlen"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Interpolation::inlen"]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::mccnv", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::mccnv"],

Cell[BoxData[
    \(NIntegrate::"mccnv" \(\(:\)\(\ \)\) 
      "The integral failed to converge after `1` iterations."\)], "Message",
  CellLabel->"From In[264]:=",
  CellTags->"NIntegrate::mccnv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated number of iterations is \
not sufficient to reach the specified accuracy or precision goals.\n\
\[FilledSmallSquare] This message is generated for ",
  StyleBox["Method->MonteCarlo", "MR"],
  " and ",
  StyleBox["Method->QuasiMonteCarlo", "MR"],
  "."
}], "Notes",
  CellTags->"NIntegrate::mccnv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::mccnv"],

Cell[TextData[{
  "A warning message is generated in this example because a very large number \
of iterations will be needed to compute this oscillatory integral using ",
  StyleBox["Method->MonteCarlo", "MR"],
  "."
}], "Text",
  CellTags->"NIntegrate::mccnv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x], {x, 0, 100}, Method -> MonteCarlo]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::mccnv"],

Cell[BoxData[
    \(NIntegrate::"mccnv" \(\(:\)\(\ \)\) 
      "The integral failed to converge after \!\(50000\) iterations."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::mccnv"],

Cell[BoxData[
    \(0.34716685709062944`\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::mccnv"]
}, Closed]],

Cell["The integral in this example can be evaluated symbolically.", "Text",
  CellTags->"NIntegrate::mccnv"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[Sin[x], {x, 0, 100}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::mccnv"],

Cell[BoxData[
    \(2\ Sin[50]\^2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::mccnv"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General::precbd", "ObjectNameWarningMessages",
  CellTags->"General::precbd"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"precbd\"\>"}], \(\(:\)\(\ \)\), "\<\"Requested precision \
`1` is not a machine sized real number between $MinPrecision and \
$MaxPrecision.\"\>"}]], "Message",
  CellLabel->"From In[264]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::precbd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected \
to be a real number in the indicated range.\n\[FilledSmallSquare] You can \
change the values of ",
  StyleBox["$MinPrecision", "MR"],
  " and ",
  StyleBox["$MaxPrecision", "MR"],
  " for calculations that require precision outside of this range."
}], "Notes",
  CellTags->"General::precbd"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::precbd"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid value for the ",
  StyleBox["WorkingPrecision", "MR"],
  " option in ",
  StyleBox["Solve", "MR"],
  "."
}], "Text",
  CellTags->"General::precbd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[x^2 == 3, x, WorkingPrecision -> Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::precbd"],

Cell[BoxData[
    \(Solve::"precbd" \(\(:\)\(\ \)\) 
      "Requested precision \!\(Automatic\) is not a machine sized real number \
between $MinPrecision and $MaxPrecision."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::precbd"],

Cell[BoxData[
    \(Solve[x\^2 \[Equal] 3, x, 
      WorkingPrecision \[Rule] Automatic]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::precbd"]
}, Closed]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["WorkingPrecision", "MR"],
  " option in ",
  StyleBox["Solve", "MR"],
  "."
}], "Text",
  CellTags->"General::precbd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[x^2 == 3, x, WorkingPrecision -> 25]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::precbd"],

Cell[BoxData[
    \({{x \[Rule] \(-1.73205080756887729352744634150587236694`25. \)}, {x \
\[Rule] 1.73205080756887729352744634150587236694`25. }}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::precbd"]
}, Closed]],

Cell[TextData[{
  "This message can also be generated by ",
  StyleBox["SetAccuracy", "MR"],
  " and ",
  StyleBox["SetPrecision", "MR"],
  "."
}], "Text",
  CellTags->"General::precbd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetAccuracy[300, Sqrt[101]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::precbd"],

Cell[BoxData[
    \(300.`12.526996875840554\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::precbd"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General::preclg", "ObjectNameWarningMessages",
  CellTags->"General::preclg"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"preclg\"\>"}], \(\(:\)\(\ \)\), "Requested", 
        " ", "precision", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "larger", " ", "than", 
        " ", \($MaxPrecision . \ Using\), " ", "current", " ", 
        "$MaxPrecision", " ", "of", " ", 
        StyleBox["val",
          "TI"], " ", \(instead . \ $MaxPrecision\)}], " ", "=", 
      " ", \(Infinity\ specifies\ that\ any\ precision\ should\ be\ \
\(\(allowed\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::preclg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a requested value of precision exceeds \
the value of ",
  StyleBox["$MaxPrecision", "MR"],
  ".\n\[FilledSmallSquare] You can set ",
  StyleBox["$MaxPrecision", "MR"],
  " to a larger value if you need greater precision.\n\[FilledSmallSquare] In \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the accuracy of a number is the number of known digits to the right of \
the decimal point, the precision is the total number of significant digits, \
the scale is the number of digits to the left of the decimal point, and the \
precision is the sum of the scale and the accuracy.\n\[FilledSmallSquare] \
This is a warning message to indicate that the value of ",
  StyleBox["$MaxPrecision", "MR"],
  " has been exceeded.  This warning message does not necessarily indicate an \
error."
}], "Notes",
  CellTags->"General::preclg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::preclg"],

Cell[TextData[{
  "An error occurs in this example because the precision specified in ",
  StyleBox["SetPrecision", "MR"],
  " exceeds the value of ",
  StyleBox["$MaxPrecision", "MR"],
  " when this expression is evaluated."
}], "Text",
  CellTags->"General::preclg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MaxPrecision = 20}, SetPrecision[Pi, 50]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::preclg"],

Cell[BoxData[
    \(SetPrecision::"preclg" \(\(:\)\(\ \)\) 
      "Requested precision \!\(50\) is larger than $MaxPrecision. Using \
current $MaxPrecision of \!\(20.`\) instead. $MaxPrecision = Infinity \
specifies that any precision should be allowed."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::preclg"],

Cell[BoxData[
    \(3.14159265358979323846264338358737222874`20. \)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::preclg"]
}, Closed]],

Cell["This shows valid precision specifications.", "Text",
  CellTags->"General::preclg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MaxPrecision = 100}, SetPrecision[Pi, 50]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::preclg"],

Cell[BoxData[
    \(3.1415926535897932384626433832795028841971693993751058209749445925295`\
50. \)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::preclg"]
}, Closed]],

Cell[TextData[{
  "This message can also be generated by ",
  StyleBox["SetAccuracy", "MR"],
  "."
}], "Text",
  CellTags->"General::preclg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MaxPrecision = 25}, SetAccuracy[5, \ 30]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::preclg"],

Cell[BoxData[
    \(SetAccuracy::"preclg" \(\(:\)\(\ \)\) 
      "Requested precision \!\(30\) is larger than $MaxPrecision. Using \
current $MaxPrecision of \!\(25.`\) instead. $MaxPrecision = Infinity \
specifies that any precision should be allowed."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::preclg"],

Cell[BoxData[
    \(5.`25. \)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::preclg"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General::precsm", "ObjectNameWarningMessages",
  CellTags->"General::precsm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"precsm\"\>"}], \(\(:\)\(\ \)\), "Requested", " ", 
      "precision", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "smaller", " ", "than", 
      " ", \($MinPrecision . \ Using\), " ", "$MinPrecision", 
      " ", \(\(instead\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::precsm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a requested value of precision is less \
than the value of ",
  StyleBox["$MinPrecision", "MR"],
  ".\n\[FilledSmallSquare] You can lower the value of ",
  StyleBox["$MinPrecision", "MR"],
  " if necessary.\n\[FilledSmallSquare] In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the accuracy of a number is the number of known digits to the right of \
the decimal point, the precision is the total number of significant digits, \
the scale is the number of digits to the left of the decimal point, and the \
precision is the sum of the scale and the accuracy.\n\[FilledSmallSquare] \
This is a warning message to indicate that the value of ",
  StyleBox["$MinPrecision", "MR"],
  " has been exceeded.  This warning message does not necessarily indicate an \
error."
}], "Notes",
  CellTags->"General::precsm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::precsm"],

Cell[TextData[{
  "An error occurs in this example because the precision specified in ",
  StyleBox["SetPrecision", "MR"],
  " is less than the value of ",
  StyleBox["$MinPrecision", "MR"],
  " when this expression is evaluated."
}], "Text",
  CellTags->"General::precsm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MinPrecision = 50}, SetPrecision[Pi, 25]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::precsm"],

Cell[BoxData[
    \(SetPrecision::"precsm" \(\(:\)\(\ \)\) 
      "Requested precision \!\(25\) is smaller than $MinPrecision. Using \
$MinPrecision instead."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::precsm"],

Cell[BoxData[
    \(3.1415926535897932384626433832795028841971693993751058209749445925295`\
50. \)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::precsm"]
}, Closed]],

Cell["This shows valid precision specifications.", "Text",
  CellTags->"General::precsm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MinPrecision = 25}, SetPrecision[Pi, 25]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::precsm"],

Cell[BoxData[
    \(3.1415926535897932384626433832795028842`25. \)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::precsm"]
}, Closed]],

Cell[TextData[{
  "This message can also be generated by ",
  StyleBox["SetAccuracy", "MR"],
  "."
}], "Text",
  CellTags->"General::precsm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MinPrecision = 20}, SetAccuracy[Pi, 10]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::precsm"],

Cell[BoxData[
    \(SetAccuracy::"precsm" \(\(:\)\(\ \)\) 
      "Requested precision \!\(10\) is smaller than $MinPrecision. Using \
$MinPrecision instead."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::precsm"],

Cell[BoxData[
    \(3.14159265358979323846264338358737222874`20.497149872694138\)], "Output",\

  CellLabel->"Out[3]=",
  CellTags->"General::precsm"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["$MaxPrecision::prec", "ObjectNameWarningMessages",
  CellTags->"$MaxPrecision::prec"],

Cell[BoxData[
    \($MaxPrecision::"prec" \(\(:\)\(\ \)\) 
      "In increasing internal precision while attempting to evaluate `1`, the \
limit $MaxPrecision = `2` was reached. Increasing the value of $MaxPrecision \
may help resolve the uncertainty."\)], "Message",
  CellTags->"$MaxPrecision::prec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when internal calculations use precision \
greater than the value of ",
  StyleBox["$MaxPrecision", "MR"],
  "."
}], "Notes",
  CellTags->"$MaxPrecision::prec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$MaxPrecision::prec"],

Cell[TextData[{
  "An error occurs in this example because the precision needed in the \
numerical evaluation exceeds the value of ",
  StyleBox["$MaxPrecision", "MR"],
  "."
}], "Text",
  CellTags->"$MaxPrecision::prec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MaxPrecision = 30}, N[Exp[50], 30]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$MaxPrecision::prec"],

Cell[BoxData[
    \($MaxPrecision::"prec" \(\(:\)\(\ \)\) 
      "In increasing internal precision while attempting to evaluate \!\(\
\[ExponentialE]\^50\), the limit $MaxPrecision = \!\(30.`\) was reached. \
Increasing the value of $MaxPrecision may help resolve the uncertainty."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"$MaxPrecision::prec"],

Cell[BoxData[
    \(5.1847055285870724640874533229334853848218`27.999999999999996*^21\)], \
"Output",
  CellLabel->"Out[1]=",
  CellTags->"$MaxPrecision::prec"]
}, Closed]],

Cell[TextData[{
  "This message can be avoided by raising the value of ",
  StyleBox["$MaxPrecision", "MR"],
  "."
}], "Text",
  CellTags->"$MaxPrecision::prec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{$MaxPrecision = 40}, N[Exp[50], 30]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"$MaxPrecision::prec"],

Cell[BoxData[
    \(5.1847055285870724640874533229334853848275`30.*^21\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"$MaxPrecision::prec"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
IntegerDigits::ibase
IntegerExponent::ibase\
\>", "ObjectNameWarningMessages",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ibase\"\>"}], \(\(:\)\(\ \)\), \(\(Base\)\(\ \)\),
       
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ an\ integer\ greater\ than\ 1. \)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["IntegerDigits", "MR"],
  " or ",
  StyleBox["IntegerExponent", "MR"],
  " is not an integer or is less than 2."
}], "Notes",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell["\<\
An error occurs in this example because the second argument is not \
an integer.\
\>", "Text",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegerDigits[57, 1.5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[BoxData[
    \(IntegerDigits::"ibase" \(\(:\)\(\ \)\) 
      "Base \!\(1.5`\) is not an integer greater than 1."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[BoxData[
    \(IntegerDigits[57, 1.5`]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}]
}, Closed]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["IntegerDigits", "MR"],
  "."
}], "Text",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegerDigits[57, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[BoxData[
    \({1, 1, 1, 0, 0, 1}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}]
}, Closed]],

Cell[TextData[{
  "You can use ",
  StyleBox["RealDigits", "MR"],
  " to get digits in a base that is not an integer."
}], "Text",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(RealDigits[57.0, 1.5]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[BoxData[
    \({{1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 
        0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 
        0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 0, 0, 
        1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 
      10}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}]
}, Closed]],

Cell[TextData[{
  "An error occurs in this example because zero is not a valid value for the \
second argument in ",
  StyleBox["IntegerExponent", "MR"],
  "."
}], "Text",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegerExponent[\(30!\), 0]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[BoxData[
    \(IntegerExponent::"ibase" \(\(:\)\(\ \)\) 
      "Base \!\(0\) is not an integer greater than 1."\)], "Message",
  CellLabel->"From In[4]:=",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[BoxData[
    \(IntegerExponent[265252859812191058636308480000000, 0]\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}]
}, Closed]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["IntegerExponent", "MR"],
  "."
}], "Text",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegerExponent[\(30!\), 5]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[BoxData[
    \(7\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["InterpolatingFunction::dmval", "ObjectNameWarningMessages",
  CellTags->"InterpolatingFunction::dmval"],

Cell[BoxData[
    RowBox[{\(InterpolatingFunction::"dmval"\), \(\(:\)\(\ \)\), \
\(\(Input\)\(\ \)\(value\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(lies\ outside\ the\ range\ of\ data\ in\ the\ \
interpolating\ function . \ 
          Extrapolation\ will\ be\ \(\(used\)\(.\)\)\)\)}]], "Message",
  CellTags->"InterpolatingFunction::dmval"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument passed to an ",
  StyleBox["InterpolatingFunction", "MR"],
  " expression falls outside of the range of the interpolation.\n\
\[FilledSmallSquare] Extrapolation outside of the range of the interpolation \
can give results that give misleading results."
}], "Notes",
  CellTags->"InterpolatingFunction::dmval"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"InterpolatingFunction::dmval"],

Cell[TextData[{
  "A warning is generated in this example because the point at which the ",
  StyleBox["InterpolatingFunction", "MR"],
  " expression is evaluated is beyond the range of the interpolation."
}], "Text",
  CellTags->"InterpolatingFunction::dmval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(interp = 
      Interpolation[{{2, 3.7}, {3, 6.5}, {5, 1.8}, {8, 2.1}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"InterpolatingFunction::dmval"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{2.`, 8.`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"InterpolatingFunction::dmval"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(interp[20]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"InterpolatingFunction::dmval"],

Cell[BoxData[
    \(InterpolatingFunction::"dmval" \(\(:\)\(\ \)\) 
      "Input value \!\({20}\) lies outside the range of data in the \
interpolating function. Extrapolation will be used."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"InterpolatingFunction::dmval"],

Cell[BoxData[
    \(1216.9`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"InterpolatingFunction::dmval"]
}, Closed]],

Cell[TextData[{
  "There is no difficulty if the ",
  StyleBox["InterpolatingFunction", "MR"],
  " expression is evaluated within the range of the interpolation."
}], "Text",
  CellTags->"InterpolatingFunction::dmval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(interp[4]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"InterpolatingFunction::dmval"],

Cell[BoxData[
    \(5.131111111111111`\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"InterpolatingFunction::dmval"]
}, Closed]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["interp", "MR"],
  "."
}], "Text",
  CellTags->"InterpolatingFunction::dmval"],

Cell[BoxData[
    \(Clear[interp]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"InterpolatingFunction::dmval"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["InterpolatingFunction::dmvali", "ObjectNameWarningMessages",
  CellTags->"InterpolatingFunction::dmvali"],

Cell[BoxData[
    RowBox[{\(InterpolatingFunction::"dmvali"\), \(\(:\)\(\ \)\), \(\(The\)\(\
\ \)\(integration\)\(\ \)\(endpoint\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "in", " ", "dimension", " ", 
      StyleBox["n",
        "TI"], " ", "lies", " ", "outside", " ", "the", " ", "range", " ", 
      "of", " ", "data", " ", "in", " ", "the", " ", "interpolating", 
      " ", \(function . \ Extrapolation\), " ", "will", " ", "be", 
      " ", \(\(used\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"InterpolatingFunction::dmvali"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an ",
  StyleBox["InterpolatingFunction", "MR"],
  " expression is integrated and the range of integration extends outside of \
the range of the interpolation.\n\[FilledSmallSquare] Although this message \
does not necessarily represent an error, extrapolation beyond the range of \
interpolation can give unexpected or misleading results."
}], "Notes",
  CellTags->"InterpolatingFunction::dmvali"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"InterpolatingFunction::dmvali"],

Cell["\<\
A warning message is generated in this example because computation \
of the integral requires extrapolation beyond the range of interpolation of \
the integrand.\
\>", "Text",
  CellTags->"InterpolatingFunction::dmvali"],

Cell[CellGroupData[{

Cell[BoxData[
    \(interp = FunctionInterpolation[Sin[x], {x, 0, Pi}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"InterpolatingFunction::dmvali"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{0.`, 3.141592653589793`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"InterpolatingFunction::dmvali"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[interp[x], {x, 0, 2  Pi}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"InterpolatingFunction::dmvali"],

Cell[BoxData[
    \(InterpolatingFunction::"dmvali" \(\(:\)\(\ \)\) 
      "The integration endpoint \!\(2\\ \[Pi]\) in dimension \!\(1\) lies \
outside the range of data in the interpolating function. Extrapolation will \
be used."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"InterpolatingFunction::dmvali"],

Cell[BoxData[
    \(1.1007293412714978`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"InterpolatingFunction::dmvali"]
}, Closed]],

Cell["\<\
A more accurate result can be computed by extending the range of \
interpolation.\
\>", "Text",
  CellTags->"InterpolatingFunction::dmvali"],

Cell[CellGroupData[{

Cell[BoxData[
    \(interp = FunctionInterpolation[Sin[x], {x, 0, 2\ Pi}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"InterpolatingFunction::dmvali"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{0.`, 6.283185307179586`}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"InterpolatingFunction::dmvali"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[interp[x], {x, 0, 2  Pi}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"InterpolatingFunction::dmvali"],

Cell[BoxData[
    \(1.0364972768961422`*^-16\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"InterpolatingFunction::dmvali"]
}, Closed]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["interp", "MR"],
  "."
}], "Text",
  CellTags->"InterpolatingFunction::dmvali"],

Cell[BoxData[
    \(Clear[interp]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"InterpolatingFunction::dmvali"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["InterpolatingFunction::dprec", "ObjectNameWarningMessages",
  CellTags->"InterpolatingFunction::dprec"],

Cell[BoxData[
    RowBox[{\(InterpolatingFunction::"dprec"\), \(\(:\)\(\ \)\), "The", " ", 
      "precision", " ", "of", " ", "input", " ", "value", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(and/
          or\ the\ interpolation\ grid\ is\ insufficient\ to\ compute\ the\ \
\(\(value\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"InterpolatingFunction::dprec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the grid spacing is zero to within the \
precision of the inputs.\n\[FilledSmallSquare] This message is generated \
while computing a value for an ",
  StyleBox["InterpolatingFunction", "MR"],
  " expression.\n\[FilledSmallSquare] This error can occur if the grid \
spacing is smaller than the uncertainty in the arguments that are passed to \
the ",
  StyleBox["InterpolatingFunction", "MR"],
  " expression."
}], "Notes",
  CellTags->"InterpolatingFunction::dprec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"InterpolatingFunction::dprec"],

Cell[TextData[{
  "An error occurs in this example because the uncertainty in the \
machine-number argument that is passed to the ",
  StyleBox["InterpolatingFunction", "MR"],
  " expression is larger than the width of the interval in which that number \
falls."
}], "Text",
  CellTags->"InterpolatingFunction::dprec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(interp = 
      Interpolation[
        N[{{1, 1}, {1 + 10^\(-25\), 2}, {2, 3}, {3, 4}}, 30]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"InterpolatingFunction::dprec"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1.`30. , 3.`30. }}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->"InterpolatingFunction::dprec"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(interp[1.0]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"InterpolatingFunction::dprec"],

Cell[BoxData[
    \(InterpolatingFunction::"dprec" \(\(:\)\(\ \)\) 
      "The precision of input value \!\({1.`}\) and/or the interpolation grid \
is insufficient to compute the value."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"InterpolatingFunction::dprec"],

Cell[BoxData[
    RowBox[{
      TagBox[\(InterpolatingFunction[{{1.`30. , 3.`30. }}, "<>"]\),
        False,
        Editable->False], "[", "1.`", "]"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"InterpolatingFunction::dprec"]
}, Closed]],

Cell["\<\
The interpolation can be computed without difficulty if the \
argument is a high-precision number or if the argument is exact.\
\>", "Text",\

  CellTags->"InterpolatingFunction::dprec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(interp[1 + 10^\(-25\)/2]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"InterpolatingFunction::dprec"],

Cell[BoxData[
    \(1.5000000000000000621`4.875061263391703\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"InterpolatingFunction::dprec"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(interp[1.000000000000000000000000050000]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"InterpolatingFunction::dprec"],

Cell[BoxData[
    \(1.5000000000000000621`4.6989700043360205\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"InterpolatingFunction::dprec"]
}, Closed]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["interp", "MR"],
  "."
}], "Text",
  CellTags->"InterpolatingFunction::dprec"],

Cell[BoxData[
    \(Clear[interp]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"InterpolatingFunction::dprec"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Interpolation::inauto
ListInterpolation::inauto\
\>", "ObjectNameWarningMessages",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"inauto\"\>"}], \(\(:\)\(\ \)\), "\<\"The function value at \
each grid point must be specified. It cannot be omitted or given as \
\\\"Automatic\\\".\"\>"}]], "Message",
  CellLabel->"From In[264]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Automatic", "MR"],
  " is found in a position other than a derivative specification in the first \
argument of ",
  StyleBox["Interpolation", "MR"],
  " or ",
  StyleBox["ListInterpolation", "MR"],
  "."
}], "Notes",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid value for interpolation."
}], "Text",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{Automatic}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],

Cell[BoxData[
    \(Interpolation::"inauto" \(\(:\)\(\ \)\) 
      "The function value at each grid point must be specified. It cannot be \
omitted or given as \"Automatic\"."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],

Cell[BoxData[
    \(Interpolation[{Automatic}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}]
}, Closed]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["Interpolation", "MR"],
  "."
}], "Text",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{{1, 1}, {2, 2}, {3, 1}, {4, 2}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 4}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Interpolation::incon
ListInterpolation::incon
InterpolatingFunction::incon\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"incon\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      StyleBox["expr",
        "TI"], " ", "derivative", " ", "was", " ", "not", " ", "specified", 
      " ", "consistently", " ", "across", " ", "other", 
      " ", \(\(dimensions\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],

Cell["\<\
\[FilledSmallSquare] Generated when partial derivatives are not \
specified uniformly in the input to the indicated function.
\[FilledSmallSquare] In multi-dimensional interpolation derivatives must be \
specified in the same way at all interpolation points.\
\>", "Notes",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],

Cell["\<\
An error occurs in this example because derivatives are specified \
only for some of the points.\
\>", "Text",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{{1, 1, {2, {0, 0}}}, {1, 2, {3, {0, 0}}}, {1, 
          3, {4, {0, 0}}}, {1, 4, {5, {0, 0}}}, \n\t\t{2, 1, 3}, {2, 2, 
          4}, {2, 3, 5}, {2, 4, 6}, \n\t\t{3, 1, 4}, {3, 2, 5}, {3, 3, 
          6}, {3, 4, 7}, \n\t\t{4, 1, 5}, {4, 2, 6}, {4, 3, 7}, {4, 4, 
          8}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],

Cell[BoxData[
    \(Interpolation::"incon" \(\(:\)\(\ \)\) 
      "The \!\({0, 1}\) derivative was not specified consistently across \
other dimensions."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "InterpolatingFunction::incon", "Interpolation::incon", 
    "ListInterpolation::incon"}],

Cell[BoxData[
    \(Interpolation[{{1, 1, {2, {0, 0}}}, {1, 2, {3, {0, 0}}}, {1, 
          3, {4, {0, 0}}}, {1, 4, {5, {0, 0}}}, {2, 1, 3}, {2, 2, 4}, {2, 3, 
          5}, {2, 4, 6}, {3, 1, 4}, {3, 2, 5}, {3, 3, 6}, {3, 4, 7}, {4, 1, 
          5}, {4, 2, 6}, {4, 3, 7}, {4, 4, 8}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "InterpolatingFunction::incon", "Interpolation::incon", 
    "ListInterpolation::incon"}]
}, Closed]],

Cell[TextData[{
  "This shows valid input to ",
  StyleBox["Interpolation", "MR"],
  " with specifications for the first partial derivatives."
}], "Text",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sampledata\  = \ 
      Flatten[Table[{x, y, {x + y, {0, 0}}}, {x, 4}, {y, 4}], 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],

Cell[BoxData[
    \({{1, 1, {2, {0, 0}}}, {1, 2, {3, {0, 0}}}, {1, 3, {4, {0, 0}}}, {1, 
        4, {5, {0, 0}}}, {2, 1, {3, {0, 0}}}, {2, 2, {4, {0, 0}}}, {2, 
        3, {5, {0, 0}}}, {2, 4, {6, {0, 0}}}, {3, 1, {4, {0, 0}}}, {3, 
        2, {5, {0, 0}}}, {3, 3, {6, {0, 0}}}, {3, 4, {7, {0, 0}}}, {4, 
        1, {5, {0, 0}}}, {4, 2, {6, {0, 0}}}, {4, 3, {7, {0, 0}}}, {4, 
        4, {8, {0, 0}}}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "InterpolatingFunction::incon", "Interpolation::incon", 
    "ListInterpolation::incon"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[sampledata]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 4}, {1, 4}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->{
  "InterpolatingFunction::incon", "Interpolation::incon", 
    "ListInterpolation::incon"}]
}, Closed]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["sampledata", "MR"],
  "."
}], "Text",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],

Cell[BoxData[
    \(Clear[sampledata]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Interpolation::indat
ListInterpolation::indat\
\>", "ObjectNameWarningMessages",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"indat\"\>"}], \(\(:\)\(\ \)\), "Data", " ", 
      "point", " ", 
      StyleBox["expr",
        "TI"], " ", "contains", " ", "abscissa", " ", 
      StyleBox["x",
        "TI"], " ", "which", " ", "is", " ", "not", " ", "a", " ", "real", 
      " ", \(\(number\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell["\<\
\[FilledSmallSquare] Generated when the first element or one of the \
first elements in the indicated data point is not a real number.\
\>", "Notes",\

  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell["\<\
An error occurs in this example because the first element in each \
pair is not a number.\
\>", "Text",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{{x1, 1}, {x2, 2}, {x3, 3}, {x4, 4}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell[BoxData[
    \(Interpolation::"indat" \(\(:\)\(\ \)\) 
      "Data point \!\({x1, 1}\) contains abscissa \!\(x1\) which is not a \
real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell[BoxData[
    \(Interpolation[{{x1, 1}, {x2, 2}, {x3, 3}, {x4, 4}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}]
}, Closed]],

Cell[TextData[{
  "This shows valid input in ",
  StyleBox["Interpolation", "MR"],
  "."
}], "Text",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{{1, y1}, {2, y2}, {3, y3}, {4, y4}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 4}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}]
}, Closed]],

Cell[TextData[{
  StyleBox["InterpolatingPolynomial", "MR"],
  " can be used for symbolic interpolation."
}], "Text",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(InterpolatingPolynomial[{{x1, 1}, {x2, 2}, {x3, 3}, {x4, 4}}, 
      x]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell[BoxData[
    \(1 + \((x - 
            x1)\)\ \((1\/\(\(-x1\) + x2\) + \((x - 
                  x2)\)\ \((\(\(-\(1\/\(\(-x1\) + x2\)\)\) + 1\/\(\(-x2\) + \
x3\)\)\/\(\(-x1\) + x3\) + \(\((x - x3)\)\ \((\(-\(\(\(-\(1\/\(\(-x1\) + x2\)\
\)\) + 1\/\(\(-x2\) + x3\)\)\/\(\(-x1\) + x3\)\)\) + \(\(-\(1\/\(\(-x2\) + x3\
\)\)\) + 1\/\(\(-x3\) + x4\)\)\/\(\(-x2\) + x4\))\)\)\/\(\(-x1\) + x4\))\))\)\
\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Interpolation::indatg
ListInterpolation::indatg\
\>", "ObjectNameWarningMessages",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"indatg\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "abscissa", " ", 
      StyleBox["expr",
        "TI"], " ", "in", " ", "dimension", " ", 
      StyleBox["d",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "real", 
      " ", \(\(number\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],

Cell["\<\
\[FilledSmallSquare] Generated when the data are given as an array \
and the grid coordinates are not all real numbers.\
\>", "Notes",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],

Cell["\<\
An error occurs in this example because the grid coordinates are \
symbols rather than real numbers.\
\>", "Text",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListInterpolation[{3, 1, 7, 9, 9, 
        5}, {{x1, x2, x3, x4, x5, x6}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],

Cell[BoxData[
    \(ListInterpolation::"indatg" \(\(:\)\(\ \)\) 
      "The abscissa \!\(x2\) in dimension \!\(1\) is not a real number."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],

Cell[BoxData[
    \(ListInterpolation[{3, 1, 7, 9, 9, 
        5}, {{x1, x2, x3, x4, x5, x6}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}]
}, Closed]],

Cell[TextData[{
  "This shows a valid specification of grid coordinates in ",
  StyleBox["ListInterpolation", "MR"],
  "."
}], "Text",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListInterpolation[{3, 1, 7, 9, 9, 5}, {{1, 2, 3, 7, 8, 9}}]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 9}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Interpolation::inddp
ListInterpolation::inddp\
\>", "ObjectNameWarningMessages",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"inddp\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "point", " ", 
      StyleBox["expr",
        "TI"], " ", "in", " ", "dimension", " ", 
      StyleBox["d",
        "TI"], " ", "is", " ", \(\(duplicated\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],

Cell["\<\
\[FilledSmallSquare] Generated when the data are given as a grid \
and the grid coordinates are not all distinct.\
\>", "Notes",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],

Cell[TextData[{
  "An error occurs in this example because the grid points specified in the \
second argument of ",
  StyleBox["ListInterpolation", "MR"],
  " are not all distinct."
}], "Text",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListInterpolation[{3, 4, 1, 5, 6, 4}, {{1, 2, 3, 3, 4, 5}}]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],

Cell[BoxData[
    \(ListInterpolation::"inddp" \(\(:\)\(\ \)\) 
      "The point \!\(3\) in dimension \!\(1\) is duplicated."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],

Cell[BoxData[
    \(ListInterpolation[{3, 4, 1, 5, 6, 4}, {{1, 2, 3, 3, 4, 5}}]\)], "Output",\

  CellLabel->"Out[1]=",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}]
}, Closed]],

Cell[TextData[{
  "This shows a valid specification of grid points in ",
  StyleBox["ListInterpolation", "MR"],
  "."
}], "Text",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListInterpolation[{3, 4, 1, 5, 6, 4}, {{1, 2, 3, 4, 5, 6}}]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 6}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Interpolation::indep
ListInterpolation::indep
InterpolatingFunction::indep\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"indep\"\>"}], \(\(:\)\(\ \)\), "An", " ", 
        "order"}], "-", 
      RowBox[{
        StyleBox["ord",
          "TI"], " ", "derivative", " ", "was", " ", "specified", " ", "in", 
        " ", 
        StyleBox["expr",
          "TI"], " ", "without", " ", "all", " ", "corresponding", " ", 
        "lower"}], "-", \(order\ \(\(derivatives\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a specific value is given for the \
indicated derivative and a lower derivative at the same point is specified \
using ",
  StyleBox["Automatic", "MR"],
  "."
}], "Notes",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is used for a derivative other than the highest specified derivative."
}], "Text",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{{1, {1, 0, 0}}, {2, {3, 0, Automatic}}, {3, {5, 
            Automatic, 0}}, {5, {1, 0, 0}}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],

Cell[BoxData[
    \(Interpolation::"indep" \(\(:\)\(\ \)\) 
      "An order-\!\(2\) derivative was specified in \!\({5, Automatic, 0}\) \
without all corresponding lower-order derivatives."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "InterpolatingFunction::indep", "Interpolation::indep", 
    "ListInterpolation::indep"}],

Cell[BoxData[
    \(Interpolation[{{1, {1, 0, 0}}, {2, {3, 0, Automatic}}, {3, {5, 
            Automatic, 0}}, {5, {1, 0, 0}}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "InterpolatingFunction::indep", "Interpolation::indep", 
    "ListInterpolation::indep"}]
}, Closed]],

Cell[TextData[{
  "This shows a valid specification of derivatives in ",
  StyleBox["Interpolation", "MR"],
  "."
}], "Text",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{{1, {1, 0, 0}}, {2, {3, 0, Automatic}}, {3, {5, 0, 
            Automatic}}, {5, {1, 0, 0}}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 5}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "InterpolatingFunction::indep", "Interpolation::indep", 
    "ListInterpolation::indep"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Interpolation::inder
ListInterpolation::inder\
\>", "ObjectNameWarningMessages",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"inder\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
        "order"}], "-", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "derivative", " ", "of", " ", 
        StyleBox["n",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "tensor", " ", "of", 
        " ", "rank", " ", "`1`", " ", "with", " ", "dimensions", " ", 
        RowBox[{
          StyleBox["dim",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell["\<\
\[FilledSmallSquare] Generated when a derivative specification does \
not have the expected form.\
\>", "Notes",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell["\<\
An error occurs in this example because unnecessary lists are used \
to indicate the derivatives.\
\>", "Text",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sampledata = Table[{k, {k, {0, 0}}}, {k, 4}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell[BoxData[
    \({{1, {1, {0, 0}}}, {2, {2, {0, 0}}}, {3, {3, {0, 0}}}, {4, {4, {0, 
            0}}}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[sampledata]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell[BoxData[
    \(Interpolation::"inder" \(\(:\)\(\ \)\) 
      "The order-\!\(1\) derivative of \!\({0, 0}\) is not a tensor of rank \
\!\(1\) with dimensions \!\(1\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell[BoxData[
    \(Interpolation[{{1, {1, {0, 0}}}, {2, {2, {0, 0}}}, {3, {3, {0, 
              0}}}, {4, {4, {0, 0}}}}]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}]
}, Closed]],

Cell[TextData[{
  "This shows a valid specification of the first two derivatives for ",
  StyleBox["Interpolation", "MR"],
  " in one dimension."
}], "Text",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sampledata = Table[{k, {k, 0, 0}}, {k, 4}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell[BoxData[
    \({{1, {1, 0, 0}}, {2, {2, 0, 0}}, {3, {3, 0, 0}}, {4, {4, 0, 
          0}}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[sampledata]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 4}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}]
}, Closed]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["sampledata", "MR"],
  "."
}], "Text",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell[BoxData[
    \(Clear[sampledata]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Interpolation::indim", "ObjectNameWarningMessages",
  CellTags->"Interpolation::indim"],

Cell[BoxData[
    RowBox[{\(Interpolation::"indim"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \
\)\(coordinates\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "in", " ", "dimension", " ", 
      StyleBox["dim",
        "TI"], " ", "are", " ", "not", " ", "consistent", " ", "with", " ", 
      "other", " ", "coordinates", " ", "in", " ", "this", 
      " ", \(\(dimension\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Interpolation::indim"],

Cell["\<\
\[FilledSmallSquare] Generated when the data points to be \
interpolated do not fall on a regular grid.
\[FilledSmallSquare] The grid for multi-dimensional data does not need to be \
square, and the grid lines do not need to be evenly spaced, but the data \
points must fall on a regular grid.
\[FilledSmallSquare] Triangulation is a standard recommended method for \
interpolating irregular data.
\[FilledSmallSquare] If the data show significant regularities, it is often \
possible to resample onto a regular grid or to interpolate between adjacent \
points to fill in missing data.\
\>", "Notes",
  CellTags->"Interpolation::indim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Interpolation::indim"],

Cell["\<\
An error occurs in this example because one of the points in the \
data does not fall on the same grid as the remaining points.\
\>", "Text",
  CellTags->"Interpolation::indim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{\n\t\t{1, 1, 3}, {1, 2, 4}, {1, 6, 5}, {1, 11, 6}, {1, 
          13, 7}, \n\t\t{2, 1, 3}, {2, 2, 4}, {2, 6, 5}, {2, 11, 6}, {2, 17, 
          7}, \n\t\t{7, 1, 4}, {7, 2, 5}, {7, 6, 6}, {7, 11, 7}, {7, 17, 
          8}, \n\t\t{9, 1, 5}, {9, 2, 6}, {9, 6, 7}, {9, 11, 8}, {9, 17, 
          10}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Interpolation::indim"],

Cell[BoxData[
    \(Interpolation::"indim" \(\(:\)\(\ \)\) 
      "The coordinates \!\({1, 2, 6, 11, 13}\) in dimension \!\(2\) are not \
consistent with other coordinates in this dimension."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Interpolation::indim"],

Cell[BoxData[
    \(Interpolation[{{1, 1, 3}, {1, 2, 4}, {1, 6, 5}, {1, 11, 6}, {1, 13, 
          7}, {2, 1, 3}, {2, 2, 4}, {2, 6, 5}, {2, 11, 6}, {2, 17, 7}, {7, 1, 
          4}, {7, 2, 5}, {7, 6, 6}, {7, 11, 7}, {7, 17, 8}, {9, 1, 5}, {9, 2, 
          6}, {9, 6, 7}, {9, 11, 8}, {9, 17, 10}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Interpolation::indim"]
}, Closed]],

Cell["This shows valid data on a regular grid.", "Text",
  CellTags->"Interpolation::indim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{\n\t\t{1, 1, 3}, {1, 2, 4}, {1, 6, 5}, {1, 11, 6}, {1, 
          17, 7}, \n\t\t{2, 1, 3}, {2, 2, 4}, {2, 6, 5}, {2, 11, 6}, {2, 17, 
          7}, \n\t\t{7, 1, 4}, {7, 2, 5}, {7, 6, 6}, {7, 11, 7}, {7, 17, 
          8}, \n\t\t{9, 1, 5}, {9, 2, 6}, {9, 6, 7}, {9, 11, 8}, {9, 17, 
          10}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Interpolation::indim"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 9}, {1, 17}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Interpolation::indim"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Interpolation::indimt
ListInterpolation::indimt\
\>", "ObjectNameWarningMessages",
  CellTags->{"Interpolation::indimt", "ListInterpolation::indimt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"indimt\"\>"}], \(\(:\)\(\ \)\), "\<\"The coordinate `1` in \
dimension `2` is not consistent with other values for this coordinate in this \
row of the data.\"\>"}]], "Message",
  CellLabel->"From In[74]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Interpolation::indimt", "ListInterpolation::indimt"}],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->{"Interpolation::indimt", "ListInterpolation::indimt"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Interpolation::inhr
ListInterpolation::inhr
InterpolatingFunction::inhr\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"inhr\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{\(Requested\ order\ is\ too\ high\), ";", " ", 
        RowBox[{
        "order", " ", "has", " ", "been", " ", "reduced", " ", "to", " ", 
          RowBox[{
            StyleBox["n",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when there are not enough points in the \
data to construct an interpolation of the requested order.\n\
\[FilledSmallSquare] Interpolation of order ",
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  " requires ",
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  StyleBox["+1", "MR"],
  " data points.\n\[FilledSmallSquare] The order of interpolation is \
specified using the ",
  StyleBox["InterpolationOrder", "MR"],
  " option.\n\[FilledSmallSquare] The default value of the ",
  StyleBox["InterpolationOrder", "MR"],
  " option is 3.  This interpolation order requires at least 4 points in each \
dimension."
}], "Notes",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[TextData[{
  "A warning message is generated in this example because the number of data \
points is not sufficient for the default interpolation of order ",
  StyleBox["3", "MR"],
  "."
}], "Text",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{{1, 1}, {2, 3}, {5, 1}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[BoxData[
    \(Interpolation::"inhr" \(\(:\)\(\ \)\) 
      "Requested order is too high; order has been reduced to \!\({2}\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "InterpolatingFunction::inhr", "Interpolation::inhr", 
    "ListInterpolation::inhr"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 5}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "InterpolatingFunction::inhr", "Interpolation::inhr", 
    "ListInterpolation::inhr"}]
}, Closed]],

Cell[TextData[{
  "Linear interpolation can be done by setting the value of the ",
  StyleBox["InterpolationOrder", "MR"],
  " option to ",
  StyleBox["1", "MR"],
  "."
}], "Text",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{{1, 1}, {2, 3}, {5, 1}}, 
      InterpolationOrder -> 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 5}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "InterpolatingFunction::inhr", "Interpolation::inhr", 
    "ListInterpolation::inhr"}]
}, Closed]],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["ListInterpolation", "MR"],
  " is interpreted as an array and is expected to have a sufficient number of \
data points in all dimensions."
}], "Text",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListInterpolation[{{1, 1}, {2, 2}, {3, 3}, {5, 4}}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[BoxData[
    \(ListInterpolation::"inhr" \(\(:\)\(\ \)\) 
      "Requested order is too high; order has been reduced to \!\({3, \
1}\)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{
  "InterpolatingFunction::inhr", "Interpolation::inhr", 
    "ListInterpolation::inhr"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 4}, {1, 2}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->{
  "InterpolatingFunction::inhr", "Interpolation::inhr", 
    "ListInterpolation::inhr"}]
}, Closed]],

Cell[TextData[{
  "If the data are not an array, but rather a list of points in one \
dimension, the interpolation can be done using ",
  StyleBox["Interpolation", "MR"],
  "."
}], "Text",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{{1, 1}, {2, 2}, {3, 3}, {5, 4}}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 5}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]=",
  CellTags->{
  "InterpolatingFunction::inhr", "Interpolation::inhr", 
    "ListInterpolation::inhr"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Interpolation::innd
ListInterpolation::innd\
\>", "ObjectNameWarningMessages",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"innd\"\>"}], \(\(:\)\(\ \)\), "First", " ", 
      "argument", " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "does", " ", "not", " ", "contain", " ", "a", " ", "list",
       " ", "of", " ", "data", " ", "and", 
      " ", \(\(coordinates\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated argument is not a \
list, includes empty lists, or is otherwise invalid.\
\>", "Notes",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],

Cell["\<\
An error occurs in this example because the empty list does not \
include any data.\
\>", "Text",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListInterpolation[{}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],

Cell[BoxData[
    \(ListInterpolation::"innd" \(\(:\)\(\ \)\) 
      "First argument in \!\({}\) does not contain a list of data and \
coordinates."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],

Cell[BoxData[
    \(ListInterpolation[{}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Interpolation::inord
ListInterpolation::inord
FunctionInterpolation::inord\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], "::", "\<\"inord\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
          "of", " ", "option", " ", 
          StyleBox["opt",
            "TI"]}], " ", "->", " ", 
        RowBox[{
          RowBox[{
            StyleBox["val",
              "TI"], " ", "should", " ", "be", " ", "a", " ", "non"}], 
          "-", \(negative\ machine\), 
          "-", \(sized\ integer\ or\ a\ list\ of\ integers\ with\ length\ \
equal\ to\ the\ number\ of\ dimensions\)}]}], ",", " ", 
      RowBox[{
        StyleBox["dim",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["InterpolationOrder", "MR"],
  " option does not have the indicated form."
}], "Notes",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["InterpolationOrder", "MR"],
  " option."
}], "Text",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{2, 5, 1, 1, 7, 3}, 
      InterpolationOrder -> None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],

Cell[BoxData[
    \(Interpolation::"inord" \(\(:\)\(\ \)\) 
      "Value of option \!\(InterpolationOrder\) -> \!\(None\) should be a \
non-negative machine-sized integer or a list of integers with length equal to \
the number of dimensions, \!\(1\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "FunctionInterpolation::inord", "Interpolation::inord", 
    "ListInterpolation::inord"}],

Cell[BoxData[
    \(Interpolation[{2, 5, 1, 1, 7, 3}, 
      InterpolationOrder \[Rule] None]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "FunctionInterpolation::inord", "Interpolation::inord", 
    "ListInterpolation::inord"}]
}, Closed]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["InterpolationOrder", "MR"],
  " option."
}], "Text",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{2, 5, 1, 1, 7, 3}, InterpolationOrder -> 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 6}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "FunctionInterpolation::inord", "Interpolation::inord", 
    "ListInterpolation::inord"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Interpolation::inpts", "ObjectNameWarningMessages",
  CellTags->"Interpolation::inpts"],

Cell[BoxData[
    RowBox[{\(Interpolation::"inpts"\), \(\(:\)\(\ \)\), "The", " ", "total", 
      " ", "number", " ", 
      StyleBox["n1",
        "TI"], " ", "of", " ", "data", " ", "points", " ", "is", " ", "not", 
      " ", "a", " ", "multiple", " ", "of", " ", "the", " ", "number", " ", 
      StyleBox["n2",
        "TI"], " ", "of", " ", "points", " ", "in", " ", "dimension", " ", 
      RowBox[{
        StyleBox["dim",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Interpolation::inpts"],

Cell["\<\
\[FilledSmallSquare] Generated when the data points cannot be \
organized on a regular grid.\
\>", "Notes",
  CellTags->"Interpolation::inpts"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Interpolation::inpts"],

Cell["\<\
An error occurs in this example because the number of data points \
is not compatible with the number of distinct grid points.\
\>", "Text",
  CellTags->"Interpolation::inpts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{\n\t\t{1, 1, 2}, {1, 2, 3}, {1, 3, 4}, {1, 4, 
          5}, \n\t\t{2, 1, 3}, {2, 2, 4}, {2, 3, 5}, {2, 4, 6}, \n\t\t{3, 1, 
          4}, {3, 2, 5}, {3, 3, 6}, {3, 4, 7}, \n\t\t{4, 1, 5}, {4, 2, 
          6}, {4, 3, 7}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Interpolation::inpts"],

Cell[BoxData[
    \(Interpolation::"inpts" \(\(:\)\(\ \)\) 
      "The total number \!\(15\) of data points is not a multiple of the \
number \!\(4\) of points in dimension \!\(2\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Interpolation::inpts"],

Cell[BoxData[
    \(Interpolation[{{1, 1, 2}, {1, 2, 3}, {1, 3, 4}, {1, 4, 5}, {2, 1, 
          3}, {2, 2, 4}, {2, 3, 5}, {2, 4, 6}, {3, 1, 4}, {3, 2, 5}, {3, 3, 
          6}, {3, 4, 7}, {4, 1, 5}, {4, 2, 6}, {4, 3, 7}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Interpolation::inpts"]
}, Closed]],

Cell[TextData[{
  "This shows a valid data argument in ",
  StyleBox["Interpolation", "MR"],
  "."
}], "Text",
  CellTags->"Interpolation::inpts"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[{\n\t\t{1, 1, 2}, {1, 2, 3}, {1, 3, 4}, {1, 4, 
          5}, \n\t\t{2, 1, 3}, {2, 2, 4}, {2, 3, 5}, {2, 4, 6}, \n\t\t{3, 1, 
          4}, {3, 2, 5}, {3, 3, 6}, {3, 4, 7}, \n\t\t{4, 1, 5}, {4, 2, 
          6}, {4, 3, 7}, {4, 4, 8}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Interpolation::inpts"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 4}, {1, 4}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Interpolation::inpts"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Interpolation::mixedp
ListInterpolation::mixedp\
\>", "ObjectNameWarningMessages",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"mixedp\"\>"}], \(\(:\)\(\ \)\), "Equality", " ", 
      "of", " ", "mixed", " ", "partials", " ", "in", " ", "the", " ", 
      StyleBox["d1",
        "TI"], " ", "derivative", " ", "of", " ", "data", " ", 
      StyleBox["expr",
        "TI"], " ", "was", " ", "not", " ", 
      RowBox[{"satisfied", ":", " ", 
        RowBox[{"using", " ", 
          RowBox[{
            StyleBox["d2",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell["\<\
\[FilledSmallSquare] Generated when the derivatives specified in \
multi-dimensional interpolation are not symmetric.\
\>", "Notes",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell["\<\
An error occurs in this example because the matrices that specify \
the second derivatives are not symmetric matrices.\
\>", "Text",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sampledata = 
      Flatten[Table[{i, j, {i + j, {0, 0}, {{0, i}, {0, 0}}}}, {i, 3}, {j, 
            3}], 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[BoxData[
    \({{1, 1, {2, {0, 0}, {{0, 1}, {0, 0}}}}, {1, 
        2, {3, {0, 0}, {{0, 1}, {0, 0}}}}, {1, 
        3, {4, {0, 0}, {{0, 1}, {0, 0}}}}, {2, 
        1, {3, {0, 0}, {{0, 2}, {0, 0}}}}, {2, 
        2, {4, {0, 0}, {{0, 2}, {0, 0}}}}, {2, 
        3, {5, {0, 0}, {{0, 2}, {0, 0}}}}, {3, 
        1, {4, {0, 0}, {{0, 3}, {0, 0}}}}, {3, 
        2, {5, {0, 0}, {{0, 3}, {0, 0}}}}, {3, 
        3, {6, {0, 0}, {{0, 3}, {0, 0}}}}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[sampledata]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[BoxData[
    \(Interpolation::"mixedp" \(\(:\)\(\ \)\) 
      "Equality of mixed partials in the \!\({1, 1}\) derivative of data \
\!\({2, \(\({0, 0}\)\), \(\({\(\({0, 1}\)\), \(\({0, 0}\)\)}\)\)}\) was not \
satisfied: using \!\(1\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[BoxData[
    \(Interpolation::"mixedp" \(\(:\)\(\ \)\) 
      "Equality of mixed partials in the \!\({1, 1}\) derivative of data \
\!\({3, \(\({0, 0}\)\), \(\({\(\({0, 1}\)\), \(\({0, 0}\)\)}\)\)}\) was not \
satisfied: using \!\(1\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[BoxData[
    \(Interpolation::"mixedp" \(\(:\)\(\ \)\) 
      "Equality of mixed partials in the \!\({1, 1}\) derivative of data \
\!\({4, \(\({0, 0}\)\), \(\({\(\({0, 1}\)\), \(\({0, 0}\)\)}\)\)}\) was not \
satisfied: using \!\(1\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(Interpolation :: \"mixedp\"\) will be suppressed \
during this calculation."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 3}, {1, 3}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}]
}, Closed]],

Cell["\<\
This shows valid data with consistent specifications of all partial \
derivatives.\
\>", "Text",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sampledata = 
      Flatten[Table[{i, j, {i + j, {0, 0}, {{i, 0}, {0, 0}}}}, {i, 3}, {j, 
            3}], 1]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[BoxData[
    \({{1, 1, {2, {0, 0}, {{1, 0}, {0, 0}}}}, {1, 
        2, {3, {0, 0}, {{1, 0}, {0, 0}}}}, {1, 
        3, {4, {0, 0}, {{1, 0}, {0, 0}}}}, {2, 
        1, {3, {0, 0}, {{2, 0}, {0, 0}}}}, {2, 
        2, {4, {0, 0}, {{2, 0}, {0, 0}}}}, {2, 
        3, {5, {0, 0}, {{2, 0}, {0, 0}}}}, {3, 
        1, {4, {0, 0}, {{3, 0}, {0, 0}}}}, {3, 
        2, {5, {0, 0}, {{3, 0}, {0, 0}}}}, {3, 
        3, {6, {0, 0}, {{3, 0}, {0, 0}}}}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Interpolation[sampledata]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 3}, {1, 3}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}]
}, Closed]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["sampledata", "MR"],
  "."
}], "Text",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[BoxData[
    \(Clear[sampledata]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Interval::nvld", "ObjectNameWarningMessages",
  CellTags->"Interval::nvld"],

Cell[BoxData[
    RowBox[{\(Interval::"nvld"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \)\(form\)\(\ \
\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(does\ not\ represent\ a\ valid\ \
\(\(interval\)\(.\)\)\)\)}]], "Message",
  CellTags->"Interval::nvld"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an argument in ",
  StyleBox["Interval", "MR"],
  " is a list with length other than 2.\n\[FilledSmallSquare] This message is \
not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Interval::nvld"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
RealDigits::realx
MantissaExponent::realx\
\>", "ObjectNameWarningMessages",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"realx\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "value", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "real", 
      " ", \(\(number\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],

Cell["\<\
\[FilledSmallSquare] Generated when the first argument in the \
indicated function is not a real number.\
\>", "Notes",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],

Cell["\<\
An error occurs in this example because the first argument is not a \
real number.\
\>", "Text",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(RealDigits[235.7  I]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],

Cell[BoxData[
    \(RealDigits::"realx" \(\(:\)\(\ \)\) 
      "The value \!\(235.7`\\ \[ImaginaryI]\) is not a real number."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"MantissaExponent::realx", "RealDigits::realx"}],

Cell[BoxData[
    \(RealDigits[235.7`\ \[ImaginaryI]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"MantissaExponent::realx", "RealDigits::realx"}]
}, Closed]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["RealDigits", "MR"],
  "."
}], "Text",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(RealDigits[4795.0*^21]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],

Cell[BoxData[
    \({{4, 7, 9, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 25}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"MantissaExponent::realx", "RealDigits::realx"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NumericalMath`$NumberBits::realx", "ObjectNameWarningMessages",
  CellTags->"NumericalMath`$NumberBits::realx"],

Cell[BoxData[
    RowBox[{\(NumericalMath`$NumberBits::"\<realx\>"\), ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "an", " ", "inexact", " ", 
        "real", " ", \(\(number\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NumericalMath`$NumberBits::realx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["NumericalMath`$NumberBits", "MR"],
  " is not a real number or is exact."
}], "Notes",
  CellTags->"NumericalMath`$NumberBits::realx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NumericalMath`$NumberBits::realx"],

Cell["\<\
An error occurs in this example because the first argument is a \
complex number.\
\>", "Text",
  CellTags->"NumericalMath`$NumberBits::realx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumericalMath`$NumberBits[1.7 + 2.5  I]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NumericalMath`$NumberBits::realx"],

Cell[BoxData[
    \(NumericalMath`$NumberBits::"realx" \(\(:\)\(\ \)\) 
      "\!\(\(\(1.7`\[InvisibleSpace]\)\) + \(\(2.5`\\ \[ImaginaryI]\)\)\) is \
not an inexact real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NumericalMath`$NumberBits::realx"],

Cell[BoxData[
    \(NumericalMath`$NumberBits[\(\(1.7`\)\(\[InvisibleSpace]\)\) + 
        2.5`\ \[ImaginaryI]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NumericalMath`$NumberBits::realx"]
}, Closed]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["NumericalMath`$NumberBits", "MR"],
  "."
}], "Text",
  CellTags->"NumericalMath`$NumberBits::realx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumericalMath`$NumberBits[1.7 + 2.5, 10, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NumericalMath`$NumberBits::realx"],

Cell[BoxData[
    \(NumericalMath`$NumberBits::"argx" \(\(:\)\(\ \)\) 
      "\!\(NumericalMath`$NumberBits\) called with \!\(3\) arguments; 1 \
argument is expected."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"NumericalMath`$NumberBits::realx"],

Cell[BoxData[
    \(NumericalMath`$NumberBits[4.2`, 10, 5]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NumericalMath`$NumberBits::realx"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General::accg", "ObjectNameWarningMessages",
  CellTags->"General::accg"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], 
            "::", "\<\"accg\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
AccuracyGoal\)}], " ", "->", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "Automatic"}]}], ",", " ", 
      "Infinity", ",", 
      " ", \(or\ a\ machine - 
        sized\ real\ or\ \(\(integer\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::accg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["AccuracyGoal", "MR"],
  " option does not have the indicated form."
}], "Notes",
  CellTags->"General::accg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::accg"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["All", "MR"],
  " is not a valid value for the ",
  StyleBox["AccuracyGoal", "MR"],
  " option in ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Text",
  CellTags->"General::accg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Exp[x], {x, 0, 1}, AccuracyGoal -> All, PrecisionGoal -> 10, 
      WorkingPrecision -> 20]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::accg"],

Cell[BoxData[
    \(NIntegrate::"accg" \(\(:\)\(\ \)\) 
      "Value of option AccuracyGoal -> \!\(All\) is not Automatic, Infinity, \
or a machine-sized real or integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::accg"],

Cell[BoxData[
    \(NIntegrate[\[ExponentialE]\^x, {x, 0, 1}, AccuracyGoal \[Rule] All, 
      PrecisionGoal \[Rule] 10, WorkingPrecision \[Rule] 20]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::accg"]
}, Closed]],

Cell[TextData[{
  "This shows valid option specifications in ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Text",
  CellTags->"General::accg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Exp[x], {x, 0, 1}, AccuracyGoal -> Infinity, 
      PrecisionGoal -> 10, WorkingPrecision -> 20]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::accg"],

Cell[BoxData[
    \(1.7182818284590452353602874714`15.741644636095389\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::accg"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::bdmtd", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::bdmtd"],

Cell[BoxData[
    RowBox[{\(NIntegrate::"bdmtd"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\
\ Method\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ Automatic, \ GaussKronrod, \ 
      DoubleExponential, \ Trapezoidal, \ Oscillatory, \ 
      MonteCarlo\ or\ \(\(QuasiMonteCarlo\)\(.\)\)\)\)}]], "Message",
  CellTags->"NIntegrate::bdmtd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the ",
  StyleBox["Method", "MR"],
  " option in ",
  StyleBox["NIntegrate", "MR"],
  " does not have one of the indicated values."
}], "Notes",
  CellTags->"NIntegrate::bdmtd"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::bdmtd"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Integrate", "MR"],
  " is not a valid value for the ",
  StyleBox["Method", "MR"],
  " option in ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Text",
  CellTags->"NIntegrate::bdmtd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x], {x, 0, Pi}, Method -> Integrate]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::bdmtd"],

Cell[BoxData[
    \(NIntegrate::"bdmtd" \(\(:\)\(\ \)\) 
      "Value of option Method -> \!\(Integrate\) is not Automatic, \
GaussKronrod, DoubleExponential, Trapezoidal, Oscillatory, MonteCarlo or \
QuasiMonteCarlo."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::bdmtd"],

Cell[BoxData[
    \(NIntegrate[Sin[x], {x, 0, \[Pi]}, Method \[Rule] Integrate]\)], "Output",\

  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::bdmtd"]
}, Closed]],

Cell[TextData[{
  "This shows valid option values in ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Text",
  CellTags->"NIntegrate::bdmtd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x], {x, 0, Pi}, Method -> DoubleExponential]\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::bdmtd"],

Cell[BoxData[
    \(2.`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::bdmtd"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::comp", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::comp"],

Cell[BoxData[
    \(NIntegrate::"comp" \(\(:\)\(\ \)\) 
      "For Method->Oscillatory, the integrand can only contain one term of \
the general form: f[x] w[x], where w is one of the following functions: Sin, \
Cos, BesselJ, or BesselY. Try using Expand on your function and apply \
NIntegrate[.., Method->Oscillatory] to each part."\)], "Message",
  CellTags->"NIntegrate::comp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Method", "MR"],
  " option is ",
  StyleBox["Oscillatory", "MR"],
  " and the integrand does not have a form that the underlying algorithm is \
designed to integrate."
}], "Notes",
  CellTags->"NIntegrate::comp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::comp"],

Cell["\<\
An error occurs in this example because the integrand does not \
include an oscillatory factor.\
\>", "Text",
  CellTags->"NIntegrate::comp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[1/\((1 + x^2)\), {x, 1, Infinity}, 
      Method -> Oscillatory]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::comp"],

Cell[BoxData[
    \(NIntegrate::"comp" \(\(:\)\(\ \)\) 
      "For Method->Oscillatory, the integrand can only contain one term of \
the general form: f[x] w[x], where w is one of the following functions: Sin, \
Cos, BesselJ, or BesselY. Try using Expand on your function and apply \
NIntegrate[.., Method->Oscillatory] to each part."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::comp"],

Cell[BoxData[
    \(NIntegrate[1\/\(1 + x\^2\), {x, 1, \[Infinity]}, 
      Method \[Rule] Oscillatory]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::comp"]
}, Closed]],

Cell[TextData[{
  "This shows a valid integrand for ",
  StyleBox["Method->Oscillatory", "MR"],
  "."
}], "Text",
  CellTags->"NIntegrate::comp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x]/\((1 + x^2)\), {x, 1, Infinity}, 
      Method -> Oscillatory]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::comp"],

Cell[BoxData[
    \(0.3249675780380536`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::comp"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::ierr", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::ierr"],

Cell[BoxData[
    \(NIntegrate::"ierr" \(\(:\)\(\ \)\) \(The\ argument\ in\ the\ \
oscillatory\ function\ must\ be\ of\ the\ form\ a\  + \ b\ x^n, \ 
      where\ a\ and\ b\ are\ \(\(constants\)\(.\)\)\)\)], "Message",
  CellTags->"NIntegrate::ierr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Method", "MR"],
  " option is ",
  StyleBox["Oscillatory", "MR"],
  " and the argument in the oscillatory factor is not a simple function of \
the integration variable."
}], "Notes",
  CellTags->"NIntegrate::ierr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::ierr"],

Cell["\<\
An error occurs in this example because the integrand does not have \
the required form.\
\>", "Text",
  CellTags->"NIntegrate::ierr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x + x^2]/\((1 + x^2)\), {x, 0, Infinity}, 
      Method -> Oscillatory]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::ierr"],

Cell[BoxData[
    \(NIntegrate::"ierr" \(\(:\)\(\ \)\) 
      "The argument in the oscillatory function must be of the form a + b \
x^n, where a and b are constants."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::ierr"],

Cell[BoxData[
    \(NIntegrate[Sin[x + x\^2]\/\(1 + x\^2\), {x, 0, \[Infinity]}, 
      Method \[Rule] Oscillatory]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::ierr"]
}, Closed]],

Cell[TextData[{
  "This shows a valid integrand for ",
  StyleBox["Method->Oscillatory", "MR"],
  "."
}], "Text",
  CellTags->"NIntegrate::ierr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x]/\((1 + x^2)\), {x, 1, Infinity}, 
      Method -> Oscillatory]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::ierr"],

Cell[BoxData[
    \(0.3249675780380536`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::ierr"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::inovf", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::inovf"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NIntegrate::"inovf"\), ":", " ", 
        RowBox[{
        "Overflow", " ", "resulted", " ", "when", " ", "attempting", " ", 
          "to", " ", "evaluate", " ", "the", " ", "integrand", " ", "at", " ",
           
          StyleBox["vars",
            "TI"]}]}], " ", "=", " ", 
      RowBox[{
        StyleBox["vals",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NIntegrate::inovf"],

Cell["\<\
\[FilledSmallSquare] Generated when evaluation of the integrand \
gives numerical overflow.\
\>", "Notes",
  CellTags->"NIntegrate::inovf"]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::inum", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::inum"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NIntegrate::"inum"\), ":", " ", 
        RowBox[{"Integrand", " ", 
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "numerical", " ", "at", " ", 
          StyleBox["vars",
            "TI"]}]}], " ", "=", " ", 
      RowBox[{
        StyleBox["vals",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NIntegrate::inum"],

Cell["\<\
\[FilledSmallSquare] Generated when the integrand does not evaluate \
to a number at the indicated point.\
\>", "Notes",
  CellTags->"NIntegrate::inum"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::inum"],

Cell["\<\
An error occurs in this example because the integrand contains a \
parameter that does not have a numerical value.\
\>", "Text",
  CellTags->"NIntegrate::inum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Cos[c\ x], {x, 0, 6}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::inum"],

Cell[BoxData[
    \(NIntegrate::"inum" \(\(:\)\(\ \)\) 
      "Integrand \!\(Cos[\(\(c\\ x\)\)]\) is not numerical at \!\({x}\) = \
\!\({3.`}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::inum"],

Cell[BoxData[
    \(NIntegrate[Cos[c\ x], {x, 0, 6}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::inum"]
}, Closed]],

Cell["\<\
The integral is computed without difficulty if the parameter has a \
numerical value.\
\>", "Text",
  CellTags->"NIntegrate::inum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{c = 1}, NIntegrate[Cos[c\ x], {x, 0, 6}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::inum"],

Cell[BoxData[
    \(\(-0.2794154981989258`\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::inum"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::minmax", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::minmax"],

Cell[BoxData[
    RowBox[{\(NIntegrate::"minmax"\), \(\(:\)\(\ \)\), "MinRecursion", " ", 
      RowBox[{"(", 
        StyleBox["m1",
          "TI"], ")"}], " ", "is", " ", "greater", " ", "than", " ", 
      "MaxRecursion", " ", 
      RowBox[{
        RowBox[{"(", 
          StyleBox["m2",
            "TI"], ")"}], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NIntegrate::minmax"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MinRecursion", "MR"],
  " option is greater than the value of the ",
  StyleBox["MaxRecursion", "MR"],
  " option."
}], "Notes",
  CellTags->"NIntegrate::minmax"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::minmax"],

Cell[TextData[{
  "An error occurs in this example because the value of ",
  StyleBox["MaxRecursion", "MR"],
  " and the value of ",
  StyleBox["MinRecursion", "MR"],
  " are not consistent."
}], "Text",
  CellTags->"NIntegrate::minmax"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Cos[x], {x, 0, 10}, MaxRecursion -> 3, 
      MinRecursion -> 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::minmax"],

Cell[BoxData[
    \(NIntegrate::"minmax" \(\(:\)\(\ \)\) 
      "MinRecursion (\!\(5\)) is greater than MaxRecursion (\!\(3\))."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::minmax"],

Cell[BoxData[
    \(NIntegrate[Cos[x], {x, 0, 10}, MaxRecursion \[Rule] 3, 
      MinRecursion \[Rule] 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::minmax"]
}, Closed]],

Cell[TextData[{
  "This shows valid values for the ",
  StyleBox["MinRecursion", "MR"],
  " and ",
  StyleBox["MaxRecursion", "MR"],
  " options."
}], "Text",
  CellTags->"NIntegrate::minmax"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Cos[x], {x, 0, 10}, MaxRecursion -> 3, 
      MinRecursion -> 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::minmax"],

Cell[BoxData[
    \(\(-0.5440211108893696`\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::minmax"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::nconv", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::nconv"],

Cell[BoxData[
    \(NIntegrate::"nconv" \(\(:\)\(\ \)\) \(This\ oscillatory\ integral\ \
might\ not\ be\ \(\(convergent\)\(.\)\)\)\)], "Message",
  CellTags->"NIntegrate::nconv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Method", "MR"],
  " option is ",
  StyleBox["Oscillatory", "MR"],
  " and mathematical tests indicate that the integrand diverges at infinity."
}], "Notes",
  CellTags->"NIntegrate::nconv"]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::ncvb", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::ncvb"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NIntegrate::"ncvb"\), ":", " ", 
        RowBox[{
        "NIntegrate", " ", "failed", " ", "to", " ", "converge", " ", "to", 
          " ", "prescribed", " ", "accuracy", " ", "after", " ", 
          StyleBox["n",
            "TI"], " ", "recursive", " ", "bisections", " ", "in", " ", 
          StyleBox["var",
            "TI"], " ", "near", " ", 
          StyleBox["var",
            "TI"]}]}], " ", "=", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NIntegrate::ncvb"],

Cell["\<\
\[FilledSmallSquare] Generated when the requested error tolerances \
are not reached at the indicated point.
\[FilledSmallSquare] This is a warning message only.  This message does not \
necessarily indicate an error or that the result will be incorrect.
\[FilledSmallSquare] This message usually indicates a singularity or a \
divergence in the integral.
\[FilledSmallSquare] This message can generally be avoided by changing the \
limits of integration or by transforming the integral to compensate for the \
singularity or divergence that led to the message.\
\>", "Notes",
  CellTags->"NIntegrate::ncvb"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::ncvb"],

Cell["\<\
A warning is generated in this example because of the singularity \
in the range of integration.\
\>", "Text",
  CellTags->"NIntegrate::ncvb"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[1/Sqrt[Abs[x]], {x, \(-1\), 2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::ncvb"],

Cell[BoxData[
    \(NIntegrate::"slwcon" \(\(:\)\(\ \)\) 
      "Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration being 0, oscillatory \
integrand, or insufficient WorkingPrecision. If your integrand is oscillatory \
try using the option Method->Oscillatory in NIntegrate."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::ncvb"],

Cell[BoxData[
    \(NIntegrate::"ncvb" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(7\) \
recursive bisections in \!\(x\) near \!\(x\) = \!\(-0.00390625`\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::ncvb"],

Cell[BoxData[
    \(4.793431881815844`\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::ncvb"]
}, Closed]],

Cell["\<\
This integral can be computed without difficulty if the position of \
the singularity is included in the limits of integration.\
\>", "Text",
  CellTags->"NIntegrate::ncvb"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[1/Sqrt[Abs[x]], {x, \(-1\), 0, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::ncvb"],

Cell[BoxData[
    \(4.828427124785212`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::ncvb"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::ncvs", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::ncvs"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NIntegrate::"ncvs"\), ":", " ", 
        RowBox[{\(NIntegrate\ failed\ to\ converge\ near\ the\ apparently\ \
non\), "-", 
          RowBox[{"integrable", " ", "singularity", " ", "at", " ", 
            StyleBox["var",
              "TI"]}]}]}], " ", "=", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NIntegrate::ncvs"],

Cell["\<\
\[FilledSmallSquare] Generated when the integrand appears to \
contain a non-integrable singularity.\
\>", "Notes",
  CellTags->"NIntegrate::ncvs"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::ncvs"],

Cell["\<\
An error occurs in this example because the integral does not \
converge.\
\>", "Text",
  CellTags->"NIntegrate::ncvs"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[1/x^2, {x, 0, 2}, Method -> DoubleExponential]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::ncvs"],

Cell[BoxData[
    \(NIntegrate::"ncvs" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge near the apparently non-integrable \
singularity at \!\(x\) = \!\(0.`\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::ncvs"],

Cell[BoxData[
    \(NIntegrate[1\/x\^2, {x, 0, 2}, 
      Method \[Rule] DoubleExponential]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::ncvs"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::ninf", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::ninf"],

Cell[BoxData[
    RowBox[{\(NIntegrate::"ninf"\), \(\(:\)\(\ \)\), \(\(Invalid\)\(\ \)\(use\
\)\(\ \)\(of\)\(\ \)\(Infinity\)\(\ \)\(in\)\(\ \)\(integration\)\(\ \
\)\(limits\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"NIntegrate::ninf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a non-directional infinity is used as \
a limit of integration, or when directed infinities are not in opposite \
directions.\n\[FilledSmallSquare] The direction of infinity is specified as \
the argument in ",
  StyleBox["DirectedInfinity", "MR"],
  ".\n\[FilledSmallSquare] Non-directional infinity (",
  StyleBox["DirectedInfinity[]", "MR"],
  " or ",
  StyleBox["ComplexInfinity", "MR"],
  ") is not a valid limit of integration in ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Notes",
  CellTags->"NIntegrate::ninf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::ninf"],

Cell["\<\
An error occurs in this example because the infinite limits of \
integration are not in opposite directions.\
\>", "Text",
  CellTags->"NIntegrate::ninf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[1/\((x^2 - 1)\), {x, Infinity, I\ Infinity}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::ninf"],

Cell[BoxData[
    \(NIntegrate::"ninf" \(\(:\)\(\ \)\) 
      "Invalid use of Infinity in integration limits \!\({x, \[Infinity], \
\(\(\[ImaginaryI]\\ \[Infinity]\)\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::ninf"],

Cell[BoxData[
    \(NIntegrate[
      1\/\(x\^2 - 1\), {x, \[Infinity], \[ImaginaryI]\ \[Infinity]}]\)], \
"Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::ninf"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::nintp", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::nintp"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NIntegrate::"nintp"\), ":", " ", 
        RowBox[{\(Encountered\ the\ non\), "-", 
          RowBox[{"number", " ", 
            StyleBox["expr",
              "TI"], " ", "at", " ", 
            StyleBox["var",
              "TI"]}]}]}], " ", "=", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NIntegrate::nintp"],

Cell["\<\
\[FilledSmallSquare] Generated when a non-numerical expression is \
encountered at the indicated point.
\[FilledSmallSquare] This message is expected only in unusual examples where \
the non-numerical expressions arise while analyzing a singularity in the \
integrand.\
\>", "Notes",
  CellTags->"NIntegrate::nintp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::nintp"],

Cell["Examples for this message have not yet been added.", "Text",
  CellTags->"NIntegrate::nintp"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::oscfm", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::oscfm"],

Cell[BoxData[
    \(NIntegrate::"oscfm" \(\(:\)\(\ \)\) 
      "With Method->Oscillatory, the integrand should be a product of an \
oscillatory function w[x] and another function f[x] , as NIntegrate[ w[x] \
f[x],{x,a,Infinity}, Method->Oscillatory]. The function w should be Sin, Cos, \
BesselJ, or BesselY, and f[x] should be of the form a + b x^n for constant a \
and b."\)], "Message",
  CellTags->"NIntegrate::oscfm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Method", "MR"],
  " option is ",
  StyleBox["Oscillatory", "MR"],
  " and the integrand does not have a form that the underlying algorithm is \
designed to integrate."
}], "Notes",
  CellTags->"NIntegrate::oscfm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::oscfm"],

Cell["\<\
An error occurs in this example because the integrand is not the \
product of an oscillatory factor and another function.\
\>", "Text",
  CellTags->"NIntegrate::oscfm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Cos[x], {x, 0, Infinity}, Method -> Oscillatory]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::oscfm"],

Cell[BoxData[
    \(NIntegrate::"oscfm" \(\(:\)\(\ \)\) 
      "With Method->Oscillatory, the integrand should be a product of an \
oscillatory function w[x] and another function f[x] , as NIntegrate[ w[x] \
f[x],{x,a,Infinity}, Method->Oscillatory]. The function w should be Sin, Cos, \
BesselJ, or BesselY, and f[x] should be of the form a + b x^n for constant a \
and b."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::oscfm"],

Cell[BoxData[
    \(NIntegrate[Cos[x], {x, 0, \[Infinity]}, 
      Method \[Rule] Oscillatory]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::oscfm"]
}, Closed]],

Cell[TextData[{
  "This shows a valid integrand for ",
  StyleBox["Method->Oscillatory", "MR"],
  "."
}], "Text",
  CellTags->"NIntegrate::oscfm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Cos[x]/\((1 + x^2)\), {x, 0, Infinity}, 
      Method -> Oscillatory]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::oscfm"],

Cell[BoxData[
    \(0.5778636748954468`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::oscfm"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::oscint", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::oscint"],

Cell[BoxData[
    \(NIntegrate::"oscint" \(\(:\)\(\ \)\) \(This\ integral\ does\ not\ \
contain\ any\ of\ the\ oscillating\ functions\ Cos, \ Sin, \ BesselJ, \ 
      or\ BesselY . \ 
          Please\ use\ some\ other\ method\ of\ NIntegrate\ \
\(\(instead\)\(.\)\)\)\)], "Message",
  CellTags->"NIntegrate::oscint"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Method", "MR"],
  " option is ",
  StyleBox["Oscillatory", "MR"],
  " but none of the indicated oscillatory factors are found in the integrand.\
\n\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"NIntegrate::oscint"]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::osran", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::osran"],

Cell[BoxData[
    \(NIntegrate::"osran" : \ Method -> 
      Oscillatory\ works\ only\ for\ one - 
        dimensional\ \(\(integrals\)\(.\)\)\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NIntegrate::osran"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Method", "MR"],
  " option is ",
  StyleBox["Oscillatory", "MR"],
  " and the integral includes more than one variable of integration."
}], "Notes",
  CellTags->"NIntegrate::osran"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::osran"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Method->Oscillatory", "MR"],
  " is not supported for multi-dimensional integrals."
}], "Text",
  CellTags->"NIntegrate::osran"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x]/\((1 + x^2 + y^2)\), {x, 0, Infinity}, {y, 0, 1}, 
      Method -> Oscillatory]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::osran"],

Cell[BoxData[
    \(NIntegrate::"osran" \(\(:\)\(\ \)\) 
      "Method->Oscillatory works only for one-dimensional integrals."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::osran"],

Cell[BoxData[
    \(NIntegrate[Sin[x]\/\(1 + x\^2 + y\^2\), {x, 0, \[Infinity]}, {y, 0, 1}, 
      Method \[Rule] Oscillatory]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::osran"]
}, Closed]],

Cell["\<\
The integral in this example can be computed by evaluating one of \
the integrals symbolically.\
\>", "Text",
  CellTags->"NIntegrate::osran"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[
      Evaluate[Integrate[Sin[x]/\((1 + x^2 + y^2)\), {y, 0, 1}]], {x, 0, 
        Infinity}, Method -> Oscillatory]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::osran"],

Cell[BoxData[
    \(0.5600383462723022`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::osran"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::osrn", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::osrn"],

Cell[BoxData[
    \(NIntegrate::"osrn" \(\(:\)\(\ \)\) \(For\ oscillating\ integrals, \ 
      the\ range\ has\ to\ contain\ one\ Infinity\ \((or\  - 
              Infinity)\)\ and\ be\ of\ non - 
        zero\ \(\(length\)\(.\)\)\)\)], "Message",
  CellTags->"NIntegrate::osrn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Method", "MR"],
  " option is ",
  StyleBox["Oscillatory", "MR"],
  " and the limits of integration do not include a directional infinity."
}], "Notes",
  CellTags->"NIntegrate::osrn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::osrn"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Method->Oscillatory", "MR"],
  " is only designed to be used when at least one of the limits of \
integration is infinite."
}], "Text",
  CellTags->"NIntegrate::osrn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x]/\((1 + x^2)\), {x, 0, 100}, 
      Method -> Oscillatory]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::osrn"],

Cell[BoxData[
    \(NIntegrate::"osrn" \(\(:\)\(\ \)\) 
      "For oscillating integrals, the range has to contain one Infinity (or \
-Infinity) and be of non-zero length."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::osrn"],

Cell[BoxData[
    \(NIntegrate[Sin[x]\/\(1 + x\^2\), {x, 0, 100}, 
      Method \[Rule] Oscillatory]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::osrn"]
}, Closed]],

Cell["\<\
A value for this integral can be computed using the default method.\
\
\>", "Text",
  CellTags->"NIntegrate::osrn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x]/\((1 + x^2)\), {x, 0, 100}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::osrn"],

Cell[BoxData[
    \(0.6466759624504617`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::osrn"]
}, Closed]],

Cell["\<\
It is sometimes useful to compute values for finite integrals as a \
difference of infinite integrals.\
\>", "Text",
  CellTags->"NIntegrate::osrn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x]/\((1 + x^2)\), {x, 0, Infinity}, 
        Method -> Oscillatory] - 
      NIntegrate[Sin[x]/\((1 + x^2)\), {x, 100, Infinity}, 
        Method -> Oscillatory]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"NIntegrate::osrn"],

Cell[BoxData[
    \(0.6466759624508601`\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"NIntegrate::osrn"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::ploss", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::ploss"],

Cell[BoxData[
    \(NIntegrate::"ploss" \(\(:\)\(\ \)\) 
      "Numerical integration stopping due to loss of precision. Achieved \
neither the requested PrecisionGoal nor AccuracyGoal; suspect one of the \
following: highly oscillatory integrand or the true value of the integral is \
0. If your integrand is oscillatory try using the option Method->Oscillatory \
in NIntegrate."\)], "Message",
  CellTags->"NIntegrate::ploss"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when numerical error causes ",
  StyleBox["NIntegrate", "MR"],
  " to stop before reaching the tolerances specified by the values of the ",
  StyleBox["PrecisionGoal", "MR"],
  " and ",
  StyleBox["AccuracyGoal", "MR"],
  " options."
}], "Notes",
  CellTags->"NIntegrate::ploss"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::ploss"],

Cell["\<\
A warning message is generated in this example because the true \
value of the integral is zero.  It is not possible to compute the required \
number of non-zero significant digits.\
\>", "Text",
  CellTags->"NIntegrate::ploss"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x], {x, 0, 2  Pi}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::ploss"],

Cell[BoxData[
    \(NIntegrate::"ploss" \(\(:\)\(\ \)\) 
      "Numerical integration stopping due to loss of precision. Achieved \
neither the requested PrecisionGoal nor AccuracyGoal; suspect one of the \
following: highly oscillatory integrand or the true value of the integral is \
0. If your integrand is oscillatory try using the option Method->Oscillatory \
in NIntegrate."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::ploss"],

Cell[BoxData[
    \(\(-5.551115123125783`*^-17\)\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::ploss"]
}, Closed]],

Cell[TextData[{
  "The warning message in this example can be avoided by specifying a finite \
value for the ",
  StyleBox["AccuracyGoal", "MR"],
  " option so that the integral will be computed to within the specified \
number of digits after the decimal point."
}], "Text",
  CellTags->"NIntegrate::ploss"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x], {x, 0, 2  Pi}, AccuracyGoal -> 4]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::ploss"],

Cell[BoxData[
    \(1.6228898854208085`*^-16\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::ploss"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General::precg", "ObjectNameWarningMessages",
  CellTags->"General::precg"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], 
            "::", "\<\"precg\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
PrecisionGoal\)}], " ", "->", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "Automatic"}]}], ",", " ", 
      "Infinity", ",", 
      " ", \(or\ a\ positive\ machine - 
        size\ integer\ or\ \(\(real\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::precg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["PrecisionGoal", "MR"],
  " option does not have the indicated form."
}], "Notes",
  CellTags->"General::precg"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::precg"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["PrecisionGoal", "MR"],
  " option in ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Text",
  CellTags->"General::precg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x], {x, 0, 10}, PrecisionGoal \[Rule] None, 
      AccuracyGoal \[Rule] 30, WorkingPrecision \[Rule] 36]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::precg"],

Cell[BoxData[
    \(NIntegrate::"precg" \(\(:\)\(\ \)\) 
      "Value of option PrecisionGoal -> \!\(None\) is not Automatic, \
Infinity, or a positive machine-size integer or real."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::precg"],

Cell[BoxData[
    \(NIntegrate[Sin[x], {x, 0, 10}, PrecisionGoal \[Rule] None, 
      AccuracyGoal \[Rule] 30, WorkingPrecision \[Rule] 36]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::precg"]
}, Closed]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["PrecisionGoal", "MR"],
  " option in ",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Text",
  CellTags->"General::precg"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x], {x, 0, 10}, PrecisionGoal \[Rule] Infinity, 
      AccuracyGoal \[Rule] 30, WorkingPrecision \[Rule] 36]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::precg"],

Cell[BoxData[
    \(1.839071529076452452258863947824064834519930165133`35.198630821232896\)]\
, "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::precg"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::rnderr", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::rnderr"],

Cell[BoxData[
    RowBox[{\(NIntegrate::"rnderr"\), \(\(:\)\(\ \)\), "Numerical", " ", 
      "approximation", " ", "has", " ", "caused", " ", 
      StyleBox["var",
        "TI"], " ", "to", " ", "take", " ", "the", " ", "value", " ", 
      StyleBox["val",
        "TI"], " ", "where", " ", "the", " ", "integrand", " ", "is", 
      " ", \(\(singular\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NIntegrate::rnderr"],

Cell["\<\
\[FilledSmallSquare] Generated when evaluations near a singularity \
cause the integrand to be divergent or indeterminate to within the precision \
of those evaluations.
\[FilledSmallSquare] This problem can usually be resolved by changing various \
option settings or by transforming the integral to make the singularity \
easier to handle.\
\>", "Notes",
  CellTags->"NIntegrate::rnderr"]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::slwcon", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::slwcon"],

Cell[BoxData[
    \(NIntegrate::"slwcon" \(\(:\)\(\ \)\) 
      "Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration being 0, oscillatory \
integrand, or insufficient WorkingPrecision. If your integrand is oscillatory \
try using the option Method->Oscillatory in NIntegrate."\)], "Message",
  CellTags->"NIntegrate::slwcon"],

Cell["\<\
\[FilledSmallSquare] Generated when the integration algorithm does \
not appear to be converging to a finite answer.\
\>", "Notes",
  CellTags->"NIntegrate::slwcon"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NIntegrate::slwcon"],

Cell["\<\
A warning message is generated in this example because the integral \
did not converge to the required tolerances.\
\>", "Text",
  CellTags->"NIntegrate::slwcon"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x]/\((1 + x^2)\), \ {x, \ 0, \ Infinity}, 
      MaxRecursion \[Rule] 12]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NIntegrate::slwcon"],

Cell[BoxData[
    \(NIntegrate::"slwcon" \(\(:\)\(\ \)\) 
      "Numerical integration converging too slowly; suspect one of the \
following: singularity, value of the integration being 0, oscillatory \
integrand, or insufficient WorkingPrecision. If your integrand is oscillatory \
try using the option Method->Oscillatory in NIntegrate."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::slwcon"],

Cell[BoxData[
    \(NIntegrate::"ncvb" \(\(:\)\(\ \)\) 
      "NIntegrate failed to converge to prescribed accuracy after \!\(13\) \
recursive bisections in \!\(x\) near \!\(x\) = \
\!\(5986.0630522224565`\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NIntegrate::slwcon"],

Cell[BoxData[
    \(0.6467422641863056`\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NIntegrate::slwcon"]
}, Closed]],

Cell[TextData[{
  "This integral can be computed using ",
  StyleBox["Method->Oscillatory", "MR"],
  "."
}], "Text",
  CellTags->"NIntegrate::slwcon"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x]/\((1 + x^2)\), \ {x, \ 0, \ Infinity}, 
      Method -> Oscillatory]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NIntegrate::slwcon"],

Cell[BoxData[
    \(0.6467611227791292`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NIntegrate::slwcon"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
NProduct::emcon
NSum::emcon\
\>", "ObjectNameWarningMessages",
  CellTags->{"NProduct::emcon", "NSum::emcon"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"emcon\"\>"}], \(\(:\)\(\ \)\), \(Euler - 
        Maclaurin\ sum\ failed\ to\ converge\ to\ requested\ error\ \
\(\(tolerance\)\(.\)\)\)}]], "Message",
  CellTags->{"NProduct::emcon", "NSum::emcon"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the Euler-Maclaurin algorithm does not \
converge.\n\[FilledSmallSquare] The Euler-Maclaurin algorithm is selected \
using ",
  StyleBox["Method->Integrate", "MR"],
  "."
}], "Notes",
  CellTags->{"NProduct::emcon", "NSum::emcon"}]
}, Closed]],

Cell[CellGroupData[{

Cell["NProduct::itfn", "ObjectNameWarningMessages",
  CellTags->"NProduct::itfn"],

Cell[BoxData[
    RowBox[{\(NProduct::"itfn"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(does\ not\ have\ the\ correct\ form\ for\ an\ \
\(\(iterator\)\(.\)\)\)\)}]], "Message",
  CellTags->"NProduct::itfn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["NProduct", "MR"],
  " does not have the expected form.\n\[FilledSmallSquare] The second \
argument in ",
  StyleBox["NProduct", "MR"],
  " is the iterator specification.\n\[FilledSmallSquare] An iterator \
specification can be given in the form ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  StyleBox["imin", "TI"],
  StyleBox[",", "MR"],
  StyleBox["imax", "TI"],
  StyleBox["}", "MR"],
  ", ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  StyleBox["imax", "TI"],
  StyleBox["}", "MR"],
  ", or ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  StyleBox["imin", "TI"],
  StyleBox[",", "MR"],
  StyleBox["imax", "TI"],
  StyleBox[",", "MR"],
  StyleBox["step", "TI"],
  StyleBox["}", "MR"],
  "."
}], "Notes",
  CellTags->"NProduct::itfn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NProduct::itfn"],

Cell["\<\
An error occurs in this example because a number is not a valid \
iteration specification.\
\>", "Text",
  CellTags->"NProduct::itfn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NProduct[k, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NProduct::itfn"],

Cell[BoxData[
    \(NProduct::"itfn" \(\(:\)\(\ \)\) 
      "\!\(5\) does not have the correct form for an iterator."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"NProduct::itfn"],

Cell[BoxData[
    \(NProduct[k, 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NProduct::itfn"]
}, Closed]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["NProduct", "MR"],
  "."
}], "Text",
  CellTags->"NProduct::itfn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NProduct[k, {k, 5}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NProduct::itfn"],

Cell[BoxData[
    \(120.`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NProduct::itfn"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NProduct::nplim", "ObjectNameWarningMessages",
  CellTags->"NProduct::nplim"],

Cell[BoxData[
    RowBox[{\(NProduct::"nplim"\), \(\(:\)\(\ \)\), \(\(Limit\)\(\ \)\(of\)\(\
\ \)\(product\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ \(\(number\)\(.\)\)\)\)}]], "Message",
  CellTags->"NProduct::nplim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the limits on the iteration variable \
in ",
  StyleBox["NProduct", "MR"],
  " are not numerical."
}], "Notes",
  CellTags->"NProduct::nplim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NProduct::nplim"],

Cell["\<\
An error occurs in this example because the limits on the iteration \
variable are symbols rather than numbers.\
\>", "Text",
  CellTags->"NProduct::nplim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NProduct[k, {k, k1, k2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NProduct::nplim"],

Cell[BoxData[
    \(NProduct::"nplim" \(\(:\)\(\ \)\) 
      "Limit of product \!\(k1\) is not a number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NProduct::nplim"],

Cell[BoxData[
    \(NProduct[k, {k, k1, k2}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NProduct::nplim"]
}, Closed]],

Cell[TextData[{
  "This shows a valid iteration specification in ",
  StyleBox["NProduct", "MR"],
  "."
}], "Text",
  CellTags->"NProduct::nplim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{k1 = 5, k2 = 7}, NProduct[k, {k, k1, k2}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NProduct::nplim"],

Cell[BoxData[
    \(210.`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NProduct::nplim"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NProduct::npnum", "ObjectNameWarningMessages",
  CellTags->"NProduct::npnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(NProduct::"npnum"\), ":", " ", 
        RowBox[{"Multiplicand", " ", 
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "numerical", " ", "at", " ", 
          "point", " ", 
          StyleBox["var",
            "TI"]}]}], " ", "=", " ", 
      RowBox[{
        StyleBox["val",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"NProduct::npnum"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["NProduct", "MR"],
  " does not evaluate to a number at the indicated point."
}], "Notes",
  CellTags->"NProduct::npnum"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NProduct::npnum"],

Cell[TextData[{
  "An error occurs in this example because the symbolic parameter in the \
first argument of ",
  StyleBox["NProduct", "MR"],
  " does not have a numerical value."
}], "Text",
  CellTags->"NProduct::npnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NProduct[k^\(-s\), {k, 1, Infinity}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NProduct::npnum"],

Cell[BoxData[
    \(NProduct::"npnum" \(\(:\)\(\ \)\) 
      "Multiplicand \!\(k\^\(-s\)\) is not numerical at point \!\(k\) = \
\!\(46662\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NProduct::npnum"],

Cell[BoxData[
    \(NProduct[k\^\(-s\), {k, 1, \[Infinity]}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NProduct::npnum"]
}, Closed]],

Cell[TextData[{
  "This shows a valid iteration specification in ",
  StyleBox["NProduct", "MR"],
  "."
}], "Text",
  CellTags->"NProduct::npnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{s = 2.3}, NProduct[k^\(-s\), {k, 1, Infinity}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NProduct::npnum"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NProduct::npnum"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NProduct::npst", "ObjectNameWarningMessages",
  CellTags->"NProduct::npst"],

Cell[BoxData[
    RowBox[{\(NProduct::"npst"\), \(\(:\)\(\ \)\), \(\(Product\)\(\ \
\)\(step\)\(\ \)\(size\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ zero\ or\ not\ a\ \(\(number\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"NProduct::npst"],

Cell["\<\
\[FilledSmallSquare] Generated when the iteration specification has \
four elements and the fourth element is zero or is not a number.\
\>", "Notes",\

  CellTags->"NProduct::npst"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NProduct::npst"],

Cell["\<\
An error occurs in this example because the symbolic parameter in \
the iteration specification does not have a numerical value.\
\>", "Text",
  CellTags->"NProduct::npst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NProduct[1/k^2, {k, 1, 4, step}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NProduct::npst"],

Cell[BoxData[
    \(NProduct::"npst" \(\(:\)\(\ \)\) 
      "Product step size \!\(step\) is zero or not a number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NProduct::npst"],

Cell[BoxData[
    \(NProduct[1\/k\^2, {k, 1, 4, step}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NProduct::npst"]
}, Closed]],

Cell[TextData[{
  "This shows a valid iteration specification in ",
  StyleBox["NProduct", "MR"],
  "."
}], "Text",
  CellTags->"NProduct::npst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{step = 0.5}, NProduct[1/k^2, {k, 1, 4, step}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NProduct::npst"],

Cell[BoxData[
    \(0.000010078105316200553`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NProduct::npst"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NProduct::npz", "ObjectNameWarningMessages",
  CellTags->"NProduct::npz"],

Cell[BoxData[
    \(NProduct::"npz" \(\(:\)\(\ \)\) \(Some\ factors\ are\ one . \ 
          The\ algorithms\ are\ not\ very\ \(\(applicable\)\(.\)\)\)\)], \
"Message",
  CellTags->"NProduct::npz"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when tests used to select an algorithm \
indicate that the algorithms used by ",
  StyleBox["NProduct", "MR"],
  " may not be appropriate for the specified product.\n\[FilledSmallSquare] \
This is a warning message only, and does not necessarily indicate an error.\n\
\[FilledSmallSquare] This message is seen only for infinite products with ",
  StyleBox["Method->Automatic", "MR"],
  " and ",
  StyleBox["VerifyConvergence->True", "MR"],
  "."
}], "Notes",
  CellTags->"NProduct::npz"]
}, Closed]],

Cell[CellGroupData[{

Cell["NRoots::nomod", "ObjectNameWarningMessages",
  CellTags->"NRoots::nomod"],

Cell[BoxData[
    \(NRoots::"nomod" \(\(:\)\(\ \)\) \(NRoots\ does\ not\ take\ a\ modulus\ \
\(\(option\)\(.\)\)\)\)], "Message",
  CellTags->"NRoots::nomod"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"NRoots::nomod"]
}, Closed]],

Cell[CellGroupData[{

Cell["NSum::itfn", "ObjectNameWarningMessages",
  CellTags->"NSum::itfn"],

Cell[BoxData[
    RowBox[{\(NSum::"itfn"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(does\ not\ have\ the\ correct\ form\ for\ an\ \
\(\(iterator\)\(.\)\)\)\)}]], "Message",
  CellTags->"NSum::itfn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["NSum", "MR"],
  " does not have the expected form.\n\[FilledSmallSquare] The second \
argument in ",
  StyleBox["NSum", "MR"],
  " is the iterator specification.\n\[FilledSmallSquare] An iterator \
specification can be given in the form ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  StyleBox["imin", "TI"],
  StyleBox[",", "MR"],
  StyleBox["imax", "TI"],
  StyleBox["}", "MR"],
  ", ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  StyleBox["imax", "TI"],
  StyleBox["}", "MR"],
  ", or ",
  StyleBox["{", "MR"],
  StyleBox["i", "TI"],
  StyleBox[",", "MR"],
  StyleBox["imin", "TI"],
  StyleBox[",", "MR"],
  StyleBox["imax", "TI"],
  StyleBox[",", "MR"],
  StyleBox["step", "TI"],
  StyleBox["}", "MR"],
  "."
}], "Notes",
  CellTags->"NSum::itfn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NSum::itfn"],

Cell["\<\
An error occurs in this example because a number is not a valid \
iteration specification.\
\>", "Text",
  CellTags->"NSum::itfn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSum[k, 25]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NSum::itfn"],

Cell[BoxData[
    \(NSum::"itfn" \(\(:\)\(\ \)\) 
      "\!\(25\) does not have the correct form for an iterator."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"NSum::itfn"],

Cell[BoxData[
    \(NSum[k, 25]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NSum::itfn"]
}, Closed]],

Cell[TextData[{
  "This shows a valid iteration specification in ",
  StyleBox["NSum", "MR"],
  "."
}], "Text",
  CellTags->"NSum::itfn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSum[k, {k, 25}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NSum::itfn"],

Cell[BoxData[
    \(325.`\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NSum::itfn"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NSum::nsst", "ObjectNameWarningMessages",
  CellTags->"NSum::nsst"],

Cell[BoxData[
    RowBox[{\(NSum::"nsst"\), \(\(:\)\(\ \)\), \(\(Summation\)\(\ \
\)\(step\)\(\ \)\(size\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ zero\ or\ not\ a\ \(\(number\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"NSum::nsst"],

Cell["\<\
\[FilledSmallSquare] Generated when the iteration specification has \
four elements and the fourth element is not a number.\
\>", "Notes",
  CellTags->"NSum::nsst"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NSum::nsst"],

Cell["\<\
An error occurs in this example because the symbolic parameter in \
the iteration specification does not have a numerical value.\
\>", "Text",
  CellTags->"NSum::nsst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSum[k, {k, 20, 30, step}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NSum::nsst"],

Cell[BoxData[
    \(NSum::"nsst" \(\(:\)\(\ \)\) 
      "Summation step size \!\(step\) is zero or not a number."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"NSum::nsst"],

Cell[BoxData[
    \(NSum[k, {k, 20, 30, step}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NSum::nsst"]
}, Closed]],

Cell[TextData[{
  "This shows a valid iteration specification in ",
  StyleBox["NSum", "MR"],
  "."
}], "Text",
  CellTags->"NSum::nsst"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{step = 2}, NSum[k, {k, 20, 30, step}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NSum::nsst"],

Cell[BoxData[
    \(150\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NSum::nsst"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NSum::nsumz", "ObjectNameWarningMessages",
  CellTags->"NSum::nsumz"],

Cell[BoxData[
    \(NSum::"nsumz" \(\(:\)\(\ \)\) \(Some\ terms\ are\ zero . \ 
          The\ algorithms\ are\ not\ very\ \(\(applicable\)\(.\)\)\)\)], \
"Message",
  CellTags->"NSum::nsumz"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when tests used to select an algorithm \
indicate that the algorithms used by ",
  StyleBox["NSum", "MR"],
  " may not be appropriate for the specified sum.\n\[FilledSmallSquare] This \
is a warning message only, and does not necessarily indicate an error.\n\
\[FilledSmallSquare] This message is seen only for infinite sums with ",
  StyleBox["Method->Automatic", "MR"],
  " and ",
  StyleBox["VerifyConvergence->True", "MR"],
  "."
}], "Notes",
  CellTags->"NSum::nsumz"]
}, Closed]],

Cell[CellGroupData[{

Cell["SequenceLimit::seqlim", "ObjectNameWarningMessages",
  CellTags->"SequenceLimit::seqlim"],

Cell[BoxData[
    \(SequenceLimit::"seqlim" \(\(:\)\(\ \)\) \(The\ general\ form\ of\ the\ \
sequence\ could\ not\ be\ determined, \ 
      and\ the\ result\ may\ be\ \(\(incorrect\)\(.\)\)\)\)], "Message",
  CellTags->"SequenceLimit::seqlim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the list of numbers in the first \
argument of ",
  StyleBox["SequenceLimit", "MR"],
  " does not correspond to a sequence that the algorithm used by ",
  StyleBox["SequenceLimit", "MR"],
  " is designed to handle.\n\[FilledSmallSquare] Since ",
  StyleBox["SequenceLimit", "MR"],
  " is used internally by other functions, this message can be generated even \
if ",
  StyleBox["SequenceLimit", "MR"],
  " is not called directly."
}], "Notes",
  CellTags->"SequenceLimit::seqlim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SequenceLimit::seqlim"],

Cell["\<\
A warning message is generated in this example because this \
sequence does not appear to converge to a well-defined limit.\
\>", "Text",
  CellTags->"SequenceLimit::seqlim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SequenceLimit[{0, 1, 2, 5, 0, 1, 2, 5}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SequenceLimit::seqlim"],

Cell[BoxData[
    \(SequenceLimit::"seqlim" \(\(:\)\(\ \)\) 
      "The general form of the sequence could not be determined, and the \
result may be incorrect."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SequenceLimit::seqlim"],

Cell[BoxData[
    \(1\/2\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SequenceLimit::seqlim"]
}, Closed]],

Cell[TextData[{
  "This warning message can also be by generated by ",
  StyleBox["NIntegrate", "MR"],
  " when the value of the ",
  StyleBox["Method", "MR"],
  " option is ",
  StyleBox["Oscillatory", "MR"],
  "."
}], "Text",
  CellTags->"SequenceLimit::seqlim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Sin[x]/\((2 + Sin[x])\), {x, 0, Infinity}, 
      Method -> Oscillatory]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SequenceLimit::seqlim"],

Cell[BoxData[
    \(SequenceLimit::"seqlim" \(\(:\)\(\ \)\) 
      "The general form of the sequence could not be determined, and the \
result may be incorrect."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"SequenceLimit::seqlim"],

Cell[BoxData[
    \(\(-11.157214710469558`\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SequenceLimit::seqlim"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SequenceLimit::seqw", "ObjectNameWarningMessages",
  CellTags->"SequenceLimit::seqw"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(SequenceLimit::"seqw"\), \(\(:\)\(\ \)\), \(\(Sequence\)\(\ \
\)\(of\)\(\ \)\(length\)\(\ \)\), 
        StyleBox["expr",
          "TI"], " ", \(is\ too\ short\ for\ use\ with\ WynnDegree\)}], " ", "->",
       " ", 
      RowBox[{
        StyleBox["n",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SequenceLimit::seqw"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the length of the first argument in ",
  StyleBox["SequenceLimit", "MR"],
  " is less than ",
  StyleBox["2", "MR"],
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  StyleBox["+2", "MR"],
  ", where ",
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  " is the value of the ",
  StyleBox["WynnDegree", "MR"],
  " option."
}], "Notes",
  CellTags->"SequenceLimit::seqw"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SequenceLimit::seqw"],

Cell[TextData[{
  "An error occurs in this example because the partial sequence specified in \
the first argument is too short to use the specified value for the ",
  StyleBox["WynnDegree", "MR"],
  " option."
}], "Text",
  CellTags->"SequenceLimit::seqw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SequenceLimit[{3, 3, 3, 3, 3}, WynnDegree -> 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SequenceLimit::seqw"],

Cell[BoxData[
    \(SequenceLimit::"seqw" \(\(:\)\(\ \)\) 
      "Sequence of length \!\(5\) is too short for use with WynnDegree -> \
\!\(2\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SequenceLimit::seqw"],

Cell[BoxData[
    \(SequenceLimit[{3, 3, 3, 3, 3}, WynnDegree \[Rule] 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SequenceLimit::seqw"]
}, Closed]],

Cell[TextData[{
  "This shows a valid partial sequence for this value of the ",
  StyleBox["WynnDegree", "MR"],
  " option."
}], "Text",
  CellTags->"SequenceLimit::seqw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SequenceLimit[{3, 3, 3, 3, 3, 3}, WynnDegree -> 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SequenceLimit::seqw"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SequenceLimit::seqw"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SequenceLimit::wynn", "ObjectNameWarningMessages",
  CellTags->"SequenceLimit::wynn"],

Cell[BoxData[
    RowBox[{\(SequenceLimit::"wynn"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ \
option\ WynnDegree\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ a\ positive\ machine - 
        size\ integer\ or\ \(\(Infinity\)\(.\)\)\)\)}]], "Message",
  CellTags->"SequenceLimit::wynn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["WynnDegree", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->"SequenceLimit::wynn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SequenceLimit::wynn"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid value for the ",
  StyleBox["WynnDegree", "MR"],
  " option."
}], "Text",
  CellTags->"SequenceLimit::wynn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SequenceLimit[{3, 3, 3, 3, 3, 3}, WynnDegree -> Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SequenceLimit::wynn"],

Cell[BoxData[
    \(SequenceLimit::"wynn" \(\(:\)\(\ \)\) 
      "Value of option WynnDegree -> \!\(Automatic\) should be a positive \
machine-size integer or Infinity."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SequenceLimit::wynn"],

Cell[BoxData[
    \(SequenceLimit[{3, 3, 3, 3, 3, 3}, 
      WynnDegree \[Rule] Automatic]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SequenceLimit::wynn"]
}, Closed]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["WynnDegree", "MR"],
  " option."
}], "Text",
  CellTags->"SequenceLimit::wynn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SequenceLimit[{3, 3, 3, 3, 3, 3}, WynnDegree -> 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SequenceLimit::wynn"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"SequenceLimit::wynn"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SetAccuracy::accbd", "ObjectNameWarningMessages",
  CellTags->"SetAccuracy::accbd"],

Cell[BoxData[
    RowBox[{\(SetAccuracy::"accbd"\), \(\(:\)\(\ \)\), \(\(Requested\)\(\ \
\)\(accuracy\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ real\ number\ within\ the\ allowable\ \(\
\(range\)\(.\)\)\)\)}]], "Message",
  CellTags->"SetAccuracy::accbd"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"SetAccuracy::accbd"]
}, Closed]],

Cell[CellGroupData[{

Cell["SetAccuracy::acclg", "ObjectNameWarningMessages",
  CellTags->"SetAccuracy::acclg"],

Cell[BoxData[
    RowBox[{\(SetAccuracy::"acclg"\), \(\(:\)\(\ \)\), "Requested", " ", 
      "accuracy", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(would\ result\ in\ a\ precision\ greater\ than\ \
$MaxPrecision; \ 
      bounding\ by\ $MaxPrecision\ \(\(instead\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SetAccuracy::acclg"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["SetAccuracy", "MR"],
  " would lead to a result with precision greater than the value of ",
  StyleBox["$MaxPrecision", "MR"],
  "."
}], "Notes",
  CellTags->"SetAccuracy::acclg"]
}, Closed]],

Cell[CellGroupData[{

Cell["SetAccuracy::accsm", "ObjectNameWarningMessages",
  CellTags->"SetAccuracy::accsm"],

Cell[BoxData[
    RowBox[{\(SetAccuracy::"accsm"\), \(\(:\)\(\ \)\), "Requested", " ", 
      "accuracy", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(would\ result\ in\ a\ precision\ smaller\ than\ \
$MinPrecision; \ 
      bounding\ by\ $MinPrecision\ \(\(instead\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SetAccuracy::accsm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["SetAccuracy", "MR"],
  " would lead to a result with precision smaller than the value of ",
  StyleBox["$MinPrecision", "MR"],
  "."
}], "Notes",
  CellTags->"SetAccuracy::accsm"]
}, Closed]],

Cell[CellGroupData[{

Cell["Sum::div", "ObjectNameWarningMessages",
  CellTags->"Sum::div"],

Cell[BoxData[
    \(Sum::"div" \(\(:\)\(\ \)\) \(Sum\ does\ not\ \
\(\(converge\)\(.\)\)\)\)], "Message",
  CellTags->"Sum::div"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a sum specified in ",
  StyleBox["Sum", "MR"],
  " is divergent."
}], "Notes",
  CellTags->"Sum::div"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::precw", "ObjectNameWarningMessages",
  CellTags->"General::precw"],

Cell[BoxData[
    RowBox[{
      StyleBox["function",
        "TI"], "::", 
      RowBox[{"\<\"precw\"\>", ":", " ", 
        RowBox[{\(\(The\)\(\ \)\(precision\)\(\ \)\(of\)\(\ \)\(the\)\(\ \
\)\(argument\)\(\ \)\(function\)\(\ \)\), 
          RowBox[{"(", 
            StyleBox["expr",
              "TI"], ")"}], \(\(\ \)\(is\ less\ than\ WorkingPrecision\ (\)\),
           
          StyleBox["p",
            "TI"], \(\()\)\(.\)\)}]}]}]], "Message",
  CellTags->"General::precw"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by numerical functions when the value of \
the ",
  StyleBox["WorkingPrecision", "MR"],
  " option is greater than the precision of the argument function.\n\
\[FilledSmallSquare] This message can be avoided by using exact or \
high-precision numbers in the input.\n\[FilledSmallSquare] This message is \
often encountered when the argument function includes an inexact zero (",
  StyleBox["0.0", "MR"],
  ").  The precision of ",
  StyleBox["0.0", "MR"],
  " is zero (",
  StyleBox["0.0", "MR"],
  " has no non-zero significant digits), which is less than the default value \
of the ",
  StyleBox["WorkingPrecision", "MR"],
  " option.\n\[FilledSmallSquare] This message is a warning only and can \
often be ignored if you are not concerned about the precision used in your \
calculations."
}], "Notes",
  CellTags->"General::precw"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::precw"],

Cell[TextData[{
  "This evaluation generates a warning message because the precision of the \
machine number ",
  StyleBox["3.4", "MR"],
  " is less than the specified value of the ",
  StyleBox["WorkingPrecision", "MR"],
  " option.  It is not possible to do a proper high-precision calculation \
starting with low-precision inputs."
}], "Text",
  CellTags->"General::precw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[3.4\ x, {x, 0, 1}, WorkingPrecision -> 25]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::precw"],

Cell[BoxData[
    \(NIntegrate::"precw" \(\(:\)\(\ \)\) 
      "The precision of the argument function (\!\(3.4`\\ x\)) is less than \
WorkingPrecision (\!\(25.`\))."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::precw"],

Cell[BoxData[
    \(1.69999999999999995559107901499300623697`24.69896907155002\)], "Output",\

  CellLabel->"Out[1]=",
  CellTags->"General::precw"]
}, Closed]],

Cell["\<\
The message can be avoided by using exact numbers in the \
input.\
\>", "Text",
  CellTags->"General::precw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[34/10\ x, {x, 0, 1}, WorkingPrecision -> 25]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::precw"],

Cell[BoxData[
    \(1.69999999999999999999999999999926785392`24.69896907155002\)], "Output",\

  CellLabel->"Out[2]=",
  CellTags->"General::precw"]
}, Closed]],

Cell[TextData[{
  "If the ",
  StyleBox["WorkingPrecision", "MR"],
  " option is not changed, the most common cause origin of this message is an \
inexact zero (",
  StyleBox["0.0", "MR"],
  ") in the input."
}], "Text",
  CellTags->"General::precw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[2.1  x^2 + 0.0  x + 1.5, {x, 0, 1}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::precw"],

Cell[BoxData[
    \(2.2`\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::precw"]
}, Closed]],

Cell[TextData[{
  "This message is generated because ",
  StyleBox["Precision[0.0]", "MR"],
  " is zero (",
  StyleBox["0.0", "MR"],
  " has no non-zero significant digits), which is less than the default value \
of the ",
  StyleBox["WorkingPrecision", "MR"],
  " option."
}], "Text",
  CellTags->"General::precw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Precision[0.0]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::precw"],

Cell[BoxData[
    \(MachinePrecision\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::precw"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[NIntegrate, WorkingPrecision]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"General::precw"],

Cell[BoxData[
    \({WorkingPrecision \[Rule] MachinePrecision}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"General::precw"]
}, Closed]],

Cell[TextData[{
  "This message can be avoided either by using an exact zero in place of ",
  StyleBox["0.0", "MR"],
  ", or by using a function such as ",
  StyleBox["Chop", "MR"],
  " to replace ",
  StyleBox["0.0", "MR"],
  " by an exact zero.  Another alternative is to ignore the message, since in \
most applications the inexact zero does not affect the result."
}], "Text",
  CellTags->"General::precw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[
      Evaluate[Chop[2.1  x^2 + 0.0  x + 1.5]], {x, 0, 1}]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"General::precw"],

Cell[BoxData[
    \(2.2`\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"General::precw"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General::unfl", "ObjectNameWarningMessages",
  CellTags->"General::unfl"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"unfl\"\>"}], \(\(:\)\(\ \)\), \(Underflow\ occurred\ in\ \
\(\(computation\)\(.\)\)\)}]], "Message",
  CellTags->"General::unfl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the scale of a numerical result is \
smaller than the scale of numbers that can be represented in the version of \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that is in use.\n\[FilledSmallSquare] This message is generated by \
arithmetic underflow within numerical functions.\n\[FilledSmallSquare] The \
smallest number that can be represented in a particular version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can be found by evaluating ",
  StyleBox["$MinNumber", "MR"],
  "."
}], "Notes",
  CellTags->"General::unfl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::unfl"],

Cell[TextData[{
  "This operation will generate a warning message because the result is \
smaller than the value of ",
  StyleBox["$MinNumber", "MR"],
  " on this computer."
}], "Text",
  CellTags->"General::unfl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Exp[\(-10. ^10\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::unfl"],

Cell[BoxData[
    \(General::"unfl" \(\(:\)\(\ \)\) 
      "Underflow occurred in computation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::unfl"],

Cell[BoxData[
    \(Underflow[]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::unfl"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \($MinNumber\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::unfl"],

Cell[BoxData[
    \(5.2077239409589238546156053328`15.954589770191005*^-646456888\)], \
"Output",
  CellLabel->"Out[2]=",
  CellTags->"General::unfl"]
}, Closed]],

Cell[TextData[{
  "Underflow often occurs as a result of arithmetic within functions such as \
",
  StyleBox["NIntegrate", "MR"],
  "."
}], "Text",
  CellTags->"General::unfl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Exp[\(-x^10\)], {x, 0, Infinity}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::unfl"],

Cell[BoxData[
    \(0.9513507698666762`\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::unfl"]
}, Closed]],

Cell[TextData[{
  "In this example the problem can be resolved by using a different method to \
compute the integral or by using ",
  StyleBox["Integrate", "MR"],
  " to evaluate the integral exactly."
}], "Text",
  CellTags->"General::unfl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NIntegrate[Exp[\(-x^10\)], {x, 0, Infinity}, 
      Method -> Trapezoidal]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::unfl"],

Cell[BoxData[
    \(General::"unfl" \(\(:\)\(\ \)\) 
      "Underflow occurred in computation."\)], "Message",
  CellLabel->"From In[4]:=",
  CellTags->"General::unfl"],

Cell[BoxData[
    \(0.9513507698668733`\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::unfl"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Integrate[Exp[\(-x^10\)], {x, 0, Infinity}]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"General::unfl"],

Cell[BoxData[
    \(Gamma[11\/10]\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"General::unfl"]
}, Closed]],

Cell["\<\
The preferred way to resolve this problem will be different in \
different examples.\
\>", "Text",
  CellTags->"General::unfl"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General::ovfl", "ObjectNameWarningMessages",
  CellTags->"General::ovfl"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"ovfl\"\>"}], \(\(:\)\(\ \)\), \(Overflow\ occurred\ in\ \(\
\(computation\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::ovfl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the scale of a result exceeds the \
scale of numbers that can be represented in the version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that is in use.\n\[FilledSmallSquare] This message is generated by \
arithmetic overflow within numerical functions.\n\[FilledSmallSquare] The \
largest number that can be represented in a particular version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can be found by evaluating ",
  StyleBox["$MaxNumber", "MR"],
  "."
}], "Notes",
  CellTags->"General::ovfl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::ovfl"],

Cell[TextData[{
  "This operation will generate a warning message because the result is \
larger than the value of ",
  StyleBox["$MaxNumber", "MR"],
  " on this computer."
}], "Text",
  CellTags->"General::ovfl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Exp[10. ^10]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::ovfl"],

Cell[BoxData[
    \(General::"ovfl" \(\(:\)\(\ \)\) 
      "Overflow occurred in computation."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::ovfl"],

Cell[BoxData[
    \(Overflow[]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::ovfl"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \($MaxNumber\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::ovfl"],

Cell[BoxData[
    \(1.9202246726923565854204690606`15.954589770191005*^646456887\)], \
"Output",
  CellLabel->"Out[2]=",
  CellTags->"General::ovfl"]
}, Closed]],

Cell[TextData[{
  "Overflow often occurs as a result of arithmetic within functions such as \
",
  StyleBox["FindRoot", "MR"],
  "."
}], "Text",
  CellTags->"General::ovfl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[Exp[10^x] == 2, {x, 10}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::ovfl"],

Cell[BoxData[
    \(General::"ovfl" \(\(:\)\(\ \)\) 
      "Overflow occurred in computation."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::ovfl"],

Cell[BoxData[
    \(FindRoot::"nnum" \(\(:\)\(\ \)\) 
      "The function value \!\({\(Overflow[]\)}\) is not a number at \!\({x}\) \
= \!\({10.`}\)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::ovfl"],

Cell[BoxData[
    \(FindRoot[\[ExponentialE]\^\(10\^x\) \[Equal] 2, {x, 10}]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::ovfl"]
}, Closed]],

Cell["\<\
In this example the problem can be resolved by choosing a better \
starting value.\
\>", "Text",
  CellTags->"General::ovfl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[Exp[10^x] == 2, {x, 0}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::ovfl"],

Cell[BoxData[
    \({x \[Rule] \(-0.1591745389548615`\)}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::ovfl"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ContinuedFraction::noterms", "ObjectNameWarningMessages",
  CellTags->"ContinuedFraction::noterms"],

Cell[BoxData[
    \(ContinuedFraction::"noterms" \(\(:\)\(\ \)\) "\<`1` does not have a \
terminating or periodic continued fraction expansion; specify an explicit \
number of terms to generate.\>"\)], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"ContinuedFraction::noterms"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["ContinuedFraction", "MR"],
  " is used with one argument and that argument is an exact number.\n\
\[FilledSmallSquare] The number of terms to generate is specified in the \
second argument of ",
  StyleBox["ContinuedFraction", "MR"],
  "."
}], "Notes",
  CellTags->"ContinuedFraction::noterms"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ContinuedFraction::noterms"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["ContinuedFraction", "MR"],
  " will not automatically determine the number of terms if the argument is \
exact."
}], "Text",
  CellTags->"ContinuedFraction::noterms"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContinuedFraction[Pi]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ContinuedFraction::noterms"],

Cell[BoxData[
    \(ContinuedFraction::"noterms" \(\(:\)\(\ \)\) 
      "\!\(\[Pi]\) does not have a terminating or periodic continued fraction \
expansion; specify an explicit number of terms to generate."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContinuedFraction::noterms"],

Cell[BoxData[
    \(ContinuedFraction[\[Pi]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ContinuedFraction::noterms"]
}, Closed]],

Cell["\<\
The continued fraction expansion is computed if the number of terms \
is specified explicitly.\
\>", "Text",
  CellTags->"ContinuedFraction::noterms"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContinuedFraction[Pi, 10]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ContinuedFraction::noterms"],

Cell[BoxData[
    \({3, 7, 15, 1, 292, 1, 1, 1, 2, 1}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ContinuedFraction::noterms"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ContinuedFraction::incomp", "ObjectNameWarningMessages",
  CellTags->"ContinuedFraction::incomp"],

Cell[BoxData[
    \(ContinuedFraction::"incomp" \(\(:\)\(\ \)\) 
      "Warning: ContinuedFraction terminated before `1` terms."\)], "Message",\

  CellLabel->"From In[3]:=",
  CellTags->"ContinuedFraction::incomp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["ContinuedFraction", "MR"],
  " is an integer or a rational number and the continued fraction terminates \
before reaching the number of terms specified in the second argument."
}], "Notes",
  CellTags->"ContinuedFraction::incomp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ContinuedFraction::incomp"],

Cell["\<\
A warning message is generated in this example because the \
continued fraction expansion of an integer has only one term.\
\>", "Text",
  CellTags->"ContinuedFraction::incomp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContinuedFraction[5, 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ContinuedFraction::incomp"],

Cell[BoxData[
    \(ContinuedFraction::"incomp" \(\(:\)\(\ \)\) 
      "Warning: ContinuedFraction terminated before \!\(2\) terms."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContinuedFraction::incomp"],

Cell[BoxData[
    \({5}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ContinuedFraction::incomp"]
}, Closed]],

Cell["This shows the continued fraction expansion for an integer.", "Text",
  CellTags->"ContinuedFraction::incomp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContinuedFraction[5, 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ContinuedFraction::incomp"],

Cell[BoxData[
    \({5}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ContinuedFraction::incomp"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ContinuedFraction::terms", "ObjectNameWarningMessages",
  CellTags->"ContinuedFraction::terms"],

Cell[BoxData[
    \(ContinuedFraction::"terms" \(\(:\)\(\ \)\) 
      "Warning: ContinuedFraction only obtained `1` of `2` requested terms \
using precision `3`.`4`"\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"ContinuedFraction::terms"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["ContinuedFraction", "MR"],
  " is unable to compute the requested number of terms in a continued \
fraction expansion."
}], "Notes",
  CellTags->"ContinuedFraction::terms"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ContinuedFraction::terms"],

Cell[TextData[{
  "A warning message is generated in this example because precision needed to \
compute the requested number of terms in the continued fraction expansion \
exceeds the precision of the machine number ",
  StyleBox["3.5", "MR"],
  "."
}], "Text",
  CellTags->"ContinuedFraction::terms"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContinuedFraction[Sqrt[3.5], 50]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ContinuedFraction::terms"],

Cell[BoxData[
    \(ContinuedFraction::"terms" \(\(:\)\(\ \)\) 
      "Warning: ContinuedFraction only obtained \!\(22\) of \!\(50\) \
requested terms using precision \!\(16\).\!\(\"\"\)"\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContinuedFraction::terms"],

Cell[BoxData[
    \({1, 1, 6, 1, 2, 1, 6, 1, 2, 1, 6, 1, 2, 1, 6, 1, 2, 1, 6, 1, 2, 
      1}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ContinuedFraction::terms"]
}, Closed]],

Cell["\<\
The specified number of terms is computed if the first argument is \
sufficiently precise.\
\>", "Text",
  CellTags->"ContinuedFraction::terms"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContinuedFraction[Sqrt[3.5`100], 50]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ContinuedFraction::terms"],

Cell[BoxData[
    \({1, 1, 6, 1, 2, 1, 6, 1, 2, 1, 6, 1, 2, 1, 6, 1, 2, 1, 6, 1, 2, 1, 6, 
      1, 2, 1, 6, 1, 2, 1, 6, 1, 2, 1, 6, 1, 2, 1, 6, 1, 2, 1, 6, 1, 2, 1, 6, 
      1, 2, 1}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ContinuedFraction::terms"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ContinuedFraction::start", "ObjectNameWarningMessages",
  CellTags->"ContinuedFraction::start"],

Cell[BoxData[
    \(ContinuedFraction::"start" \(\(:\)\(\ \)\) 
      "Warning: ContinuedFraction was unable to obtain at least one term \
using precision `1`.`2`"\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"ContinuedFraction::start"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["ContinuedFraction", "MR"],
  " is unable to compute enough terms to start the algorithm, or when an \
error occurs while computing a numerical approximation for the first \
argument."
}], "Notes",
  CellTags->"ContinuedFraction::start"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ContinuedFraction::start"],

Cell["\<\
A warning message is generated in this example because the \
continued fraction expansion has only one term before the precision of the \
first argument is reached.\
\>", "Text",
  CellTags->"ContinuedFraction::start"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContinuedFraction[4.0, 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ContinuedFraction::start"],

Cell[BoxData[
    \(ContinuedFraction::"start" \(\(:\)\(\ \)\) 
      "Warning: ContinuedFraction was unable to obtain at least one term \
using precision \!\(16\).\!\(\"\"\)"\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContinuedFraction::start"],

Cell[BoxData[
    \(ContinuedFraction[4.`, 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ContinuedFraction::start"]
}, Closed]],

Cell["\<\
A warning message is generated in this example because numerical \
computation of the first argument generates an error.\
\>", "Text",
  CellTags->"ContinuedFraction::start"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContinuedFraction[1 - Cos[1]^2 - Sin[1]^2, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ContinuedFraction::start"],

Cell[BoxData[
    \(IntegerPart::"meprec" \(\(:\)\(\ \)\) 
      "Internal precision limit $MaxExtraPrecision = \!\(50.`\) reached while \
evaluating \!\(IntegerPart[\(\(1 - \(Cos[1]\)\^2 - \(Sin[1]\)\^2\)\)]\)."\)], \
"Message",
  CellLabel->"From In[2]:=",
  CellTags->"ContinuedFraction::start"],

Cell[BoxData[
    \(General::"meprec" \(\(:\)\(\ \)\) 
      "Internal precision limit $MaxExtraPrecision = \!\(50.`\) reached while \
evaluating \!\(IntegerPart[\(\(1 - \(Cos[1]\)\^2 - \(Sin[1]\)\^2\)\)]\)."\)], \
"Message",
  CellLabel->"From In[2]:=",
  CellTags->"ContinuedFraction::start"],

Cell[BoxData[
    \(ContinuedFraction::"start" \(\(:\)\(\ \)\) 
      "Warning: ContinuedFraction was unable to obtain at least one term \
using precision \!\(50\).\!\(\" Try increasing $MaxExtraPrecision.\"\)"\)], \
"Message",
  CellLabel->"From In[2]:=",
  CellTags->"ContinuedFraction::start"],

Cell[BoxData[
    \(ContinuedFraction[1 - Cos[1]\^2 - Sin[1]\^2, 2]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ContinuedFraction::start"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Fourier::fpopt
InverseFourier::fpopt\
\>", "ObjectNameWarningMessages",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"fpopt\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
        "value", " ", "of", " ", "the", " ", "option", " ", 
        "FourierParameters"}], "->", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "should", " ", "be", " ", "a", " ", "length", " ", "2", 
        " ", "list"}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["FourierParameters", "MR"],
  " option in ",
  StyleBox["Fourier", "MR"],
  " or ",
  StyleBox["InverseFourier", "MR"],
  " is not a list or does not have two elements."
}], "Notes",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a valid value for the ",
  StyleBox["FourierParameters", "MR"],
  " option in ",
  StyleBox["Fourier.", "MR"]
}], "Text",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fourier[{2.3, 1.7, 5.9, 1.4, 2.1}, 
      FourierParameters \[Rule] Automatic]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],

Cell[BoxData[
    \(Fourier::"fpopt" \(\(:\)\(\ \)\) 
      "The value of the option FourierParameters->\!\(Automatic\) should be a \
length 2 list"\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],

Cell[BoxData[
    \(Fourier[{2.3`, 1.7`, 5.9`, 1.4`, 2.1`}, 
      FourierParameters \[Rule] Automatic]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}]
}, Closed]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["FourierParameters", "MR"],
  " option in ",
  StyleBox["Fourier", "MR"],
  "."
}], "Text",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fourier[{2.3, 1.7, 5.9, 1.4, 2.1}, 
      FourierParameters \[Rule] {\(-1\), 1}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],

Cell[BoxData[
    \({\(\(2.6800000000000006`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(-0.48631189606246344`\) + 
        0.4529222057596136`\ \[ImaginaryI], \(\(0.2963118960624632`\)\(\
\[InvisibleSpace]\)\) - 
        0.9029736848490361`\ \[ImaginaryI], \(\(0.2963118960624632`\)\(\
\[InvisibleSpace]\)\) + 
        0.9029736848490361`\ \[ImaginaryI], \(-0.48631189606246344`\) - 
        0.4529222057596136`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Fourier::fpopt2
InverseFourier::fpopt2\
\>", "ObjectNameWarningMessages",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"fpopt2\"\>"}], \(\(:\)\(\ \)\), \(Warning : \ 
          the\ discrete\ Fourier\ transform\ may\ not\ be\ consistent\ with\ \
its\ inverse\ unless\ the\ second\ element\ of\ the\ option\ \
FourierParameters\)}], "->", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "an", " ", "integer", " ", "having", " ", 
        "no", " ", "factors", " ", "in", " ", "common", " ", "with", " ", 
        "the", " ", "length", " ", "of", " ", "the", 
        " ", \(\(input\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second element in the value of the \
",
  StyleBox["FourierParameters", "MR"],
  " option in ",
  StyleBox["Fourier", "MR"],
  " or ",
  StyleBox["InverseFourier", "MR"],
  " is not a non-zero integer or has factors in common with the number of \
elements in the input.\n\[FilledSmallSquare] For most common definitions of \
the discrete Fourier transform the second element in the value of the ",
  StyleBox["FourierParameters", "MR"],
  " option should be 1 or -1.\n\[FilledSmallSquare] If this message is \
generated, the result is usually not mathematically valid as a discrete \
Fourier transform."
}], "Notes",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],

Cell[TextData[{
  "A warning message is generated in this example because the second element \
in the value of the ",
  StyleBox["FourierParameters", "MR"],
  " option does not lead to a valid Fourier transform."
}], "Text",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fourier[{2.3, 1.7, 5.9, 1.4, 2.1}, 
      FourierParameters \[Rule] {\(-1\), 0}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],

Cell[BoxData[
    \(Fourier::"fpopt2" \(\(:\)\(\ \)\) 
      "Warning: the discrete Fourier transform may not be consistent with its \
inverse unless the second element of the option \
FourierParameters->\!\({\(\(-1\)\), 0}\) is an integer having no factors in \
common with the length of the input."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],

Cell[BoxData[
    \({\(\(2.680000000000001`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(\(2.680000000000001`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(\(2.680000000000001`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(\(2.680000000000001`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(\(2.680000000000001`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}]
}, Closed]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["FourierParameters", "MR"],
  " option in ",
  StyleBox["Fourier", "MR"],
  "."
}], "Text",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fourier[{2.3, 1.7, 5.9, 1.4, 2.1}, 
      FourierParameters \[Rule] {0, \(-1\)}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],

Cell[BoxData[
    \({\(\(5.992662179699437`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(-1.0874264578624804`\) - 
        1.0127648405976426`\ \[ImaginaryI], \(\(0.66257354213752`\)\(\
\[InvisibleSpace]\)\) + 
        2.0191105412159165`\ \[ImaginaryI], \(\(0.66257354213752`\)\(\
\[InvisibleSpace]\)\) - 
        2.0191105412159165`\ \[ImaginaryI], \(-1.0874264578624804`\) + 
        1.0127648405976426`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Fourier::fpoptn
InverseFourier::fpoptn\
\>", "ObjectNameWarningMessages",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"fpoptn\"\>"}], \(\(:\)\(\ \)\), "Both", " ", 
        "values", " ", "of", " ", "the", " ", "option", " ", 
        "FourierParameters"}], "->", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "need", " ", "to", " ", "be", 
        " ", \(\(numeric\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the elements in the value of the ",
  StyleBox["FourierParameters", "MR"],
  " option in ",
  StyleBox["Fourier", "MR"],
  " or ",
  StyleBox["InverseFourier", "MR"],
  " are not numeric quantities."
}], "Notes",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],

Cell[TextData[{
  "An error occurs in this example because the elements in the value of the \
",
  StyleBox["FourierParameters", "MR"],
  " option do not have numerical values."
}], "Text",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Fourier[{2.3, 1.7, 5.9, 1.4, 2.1}, 
      FourierParameters \[Rule] {a, b}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],

Cell[BoxData[
    \(Fourier::"fpoptn" \(\(:\)\(\ \)\) 
      "Both values of the option FourierParameters->\!\({a, b}\) need to be \
numeric."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],

Cell[BoxData[
    \(Fourier[{2.3`, 1.7`, 5.9`, 1.4`, 2.1`}, 
      FourierParameters \[Rule] {a, b}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}]
}, Closed]],

Cell[TextData[{
  "This shows a valid use of the ",
  StyleBox["FourierParameters", "MR"],
  " option in ",
  StyleBox["Fourier", "MR"],
  "."
}], "Text",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{a = 0, b = \(-1\)}, 
      Fourier[{2.3, 1.7, 5.9, 1.4, 2.1}, 
        FourierParameters \[Rule] {a, b}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],

Cell[BoxData[
    \({\(\(5.992662179699437`\)\(\[InvisibleSpace]\)\) + 
        0.`\ \[ImaginaryI], \(-1.0874264578624804`\) - 
        1.0127648405976426`\ \[ImaginaryI], \(\(0.66257354213752`\)\(\
\[InvisibleSpace]\)\) + 
        2.0191105412159165`\ \[ImaginaryI], \(\(0.66257354213752`\)\(\
\[InvisibleSpace]\)\) - 
        2.0191105412159165`\ \[ImaginaryI], \(-1.0874264578624804`\) + 
        1.0127648405976426`\ \[ImaginaryI]}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General::lrgexp", "ObjectNameWarningMessages",
  CellTags->"General::lrgexp"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"lrgexp\"\>"}], \(\(:\)\(\ \)\), "Exponent", " ", 
      "is", " ", "out", " ", "of", " ", "bounds", " ", "for", " ", "function",
       " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::lrgexp"],

Cell["\<\
\[FilledSmallSquare] Generated when an exponent is encountered that \
exceeds the exponent size limit for the indicated function.
\[FilledSmallSquare] This message is generated for polynomial and related \
operations when an exponent is so large that the calculation would require a \
prohibitively large amount of time or memory.\
\>", "Notes",
  CellTags->"General::lrgexp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::lrgexp"],

Cell[TextData[{
  "An error occurs in this example because the exponent exceeds the limit \
imposed by ",
  StyleBox["NRoots", "MR"],
  "."
}], "Text",
  CellTags->"General::lrgexp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NRoots[x^\(10^10\) \[Equal] 1, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::lrgexp"],

Cell[BoxData[
    \(NRoots::"lrgexp" \(\(:\)\(\ \)\) 
      "Exponent is out of bounds for function \!\(NRoots\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::lrgexp"],

Cell[BoxData[
    \(NRoots[x\^10000000000 \[Equal] 1, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::lrgexp"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Developer`InequalityInstance::lowpr
Experimental`ExistsRealQ::lowpr
Experimental`ForAllRealQ::lowpr
Experimental`ImpliesRealQ::lowpr\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Developer`InequalityInstance::lowpr", "Experimental`ExistsRealQ::lowpr", 
    "Experimental`ForAllRealQ::lowpr", "Experimental`ImpliesRealQ::lowpr"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"lowpr\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "precision", " ", "of", " ", "coefficients", " ", "of", " ", "system", 
      " ", 
      StyleBox["expr",
        "TI"], " ", "was", " ", "too", " ", "low", " ", "to", " ", "decide", 
      " ", "whether", " ", "there", " ", "are", " ", "any", 
      " ", \(\(solutions\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Developer`InequalityInstance::lowpr", "Experimental`ExistsRealQ::lowpr", 
    "Experimental`ForAllRealQ::lowpr", "Experimental`ImpliesRealQ::lowpr"}],

Cell["\<\
\[FilledSmallSquare] Generated by difficulty related to finite \
precision in handling of inequalities.\
\>", "Notes",
  CellTags->{
  "Developer`InequalityInstance::lowpr", "Experimental`ExistsRealQ::lowpr", 
    "Experimental`ForAllRealQ::lowpr", "Experimental`ImpliesRealQ::lowpr"}]
}, Closed]],

Cell[CellGroupData[{

Cell["General::real", "ObjectNameWarningMessages",
  CellTags->"General::real"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"real\"\>"}], \(\(:\)\(\ \)\), "In", " ", 
      "attempting", " ", "decide", " ", "whether", " ", "a", " ", "solution", 
      " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "real", " ", "$MaxExtraPrecision", " ", 
      StyleBox["max",
        "TI"], " ", "was", " ", \(encountered . \ The\), " ", "solution", " ",
       "was", " ", "assumed", " ", \(real . \ Increasing\), " ", "the", " ", 
      "value", " ", "of", " ", "$MaxExtraPrecision", " ", "may", " ", "help", 
      " ", "resolve", " ", "the", " ", \(\(uncertainty\)\(.\)\)}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::real"],

Cell["\<\
\[FilledSmallSquare] Generated by difficulty in handling of \
inequalities.\
\>", "Notes",
  CellTags->"General::real"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::sign", "ObjectNameWarningMessages",
  CellTags->"General::sign"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"sign\"\>"}], \(\(:\)\(\ \)\), "\<\"Unable to determine \
sign of `1`. The expression was assumed to be zero. Increasing the value of \
$MaxExtraPrecision may help resolve the uncertainty.\"\>"}]], "Message",
  CellLabel->"From In[3]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::sign"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by difficulty resolving inequalities by \
numerical methods.\n\[FilledSmallSquare] This message can be generated by \
functions such as ",
  StyleBox["Reduce", "MR"],
  " or ",
  StyleBox["Resolve", "MR"],
  " that use assumptions."
}], "Notes",
  CellTags->"General::sign"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::sign"],

Cell[TextData[{
  "An error occurs in this example because the two conditions on the variable \
are numerically indistinguishable. In this example, increasing the value of \
",
  StyleBox["$MaxExtraPrecision", "MR"],
  " will not help resolve the uncertainty because the two expressions are \
equivalent."
}], "Text",
  CellTags->"General::sign"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Reduce[
      ForAll[x, x > Sqrt[2 - Sqrt[2 + Sqrt[2]]]/2, 
        x > Sin[Pi/16]]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::sign"],

Cell[BoxData[
    \(Reduce::"sign" \(\(:\)\(\ \)\) 
      "Unable to determine sign of \!\(\@\(2 - \@\(2 + \@2\)\) - \(\(2\\ \
\(\(Sin[\(\(\[Pi]\/16\)\)]\)\)\)\)\). The expression was assumed to be zero. \
Increasing the value of $MaxExtraPrecision may help resolve the uncertainty."\
\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::sign"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::sign"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NSolve::sfail", "ObjectNameWarningMessages",
  CellTags->"NSolve::sfail"],

Cell[BoxData[
    \(NSolve::"sfail" \(\(:\)\(\ \)\) 
      "Subsystem could not be solved for `1` at value `2`. The likely cause \
is failure to detect zero due to low precision. The likely effect is the loss \
of one or more solutions. Increasing WorkingPrecision might prevent some \
solutions from being lost."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"NSolve::sfail"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NSolve::sfail"]
}, Closed]],

Cell[CellGroupData[{

Cell["NSolve::zerosol", "ObjectNameWarningMessages",
  CellTags->"NSolve::zerosol"],

Cell[BoxData[
    \(NSolve::"zerosol" \(\(:\)\(\ \)\) 
      "Scale of possible solution value `1` for variable `2` is too small. \
Must set this value to zero in order to avoid generation of spurious \
solutions. This may cause the loss of some solutions."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"NSolve::zerosol"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NSolve::zerosol"]
}, Closed]],

Cell[CellGroupData[{

Cell["NumericQ::set", "ObjectNameWarningMessages",
  CellTags->"NumericQ::set"],

Cell[BoxData[
    \(NumericQ::"set" \(\(:\)\(\ \)\) 
      "Cannot set `1` to `2`; the lhs argument must be a symbol and the rhs \
must be True or False."\)], "Message",
  CellLabel->"From In[12]:=",
  CellTags->"NumericQ::set"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["NumericQ", "MR"],
  " on the left side of an assignment is not a symbol, or the expression on \
the right side is not ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  "."
}], "Notes",
  CellTags->"NumericQ::set"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NumericQ::set"],

Cell[TextData[{
  "An error occurs in this example because the right side of this assignment \
is not ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  "."
}], "Text",
  CellTags->"NumericQ::set"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumericQ[test] = Sqrt[2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NumericQ::set"],

Cell[BoxData[
    \(NumericQ::"set" \(\(:\)\(\ \)\) 
      "Cannot set \!\(NumericQ[test]\) to \!\(\@2\); the lhs argument must be \
a symbol and the rhs must be True or False."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NumericQ::set"]
}, Closed]],

Cell["\<\
These inputs set a numerical value for the test symbol and specify \
that the test symbol is a numeric quantity.\
\>", "Text",
  CellTags->"NumericQ::set"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[test] = Sqrt[2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NumericQ::set"],

Cell[BoxData[
    \(\@2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NumericQ::set"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumericQ[test] = True\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"NumericQ::set"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"NumericQ::set"]
}, Closed]],

Cell["\<\
The test symbol now has a numerical value and will be treated as a \
numeric quantity.\
\>", "Text",
  CellTags->"NumericQ::set"],

Cell[CellGroupData[{

Cell[BoxData[
    \(N[test]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"NumericQ::set"],

Cell[BoxData[
    \(1.4142135623730951`\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"NumericQ::set"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumericQ[Cos[test]]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"NumericQ::set"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"NumericQ::set"]
}, Closed]],

Cell["Remove the changes to the test symbol.", "Text",
  CellTags->"NumericQ::set"],

Cell[BoxData[
    \(ClearAll[test]; NumericQ[test] =. \)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"NumericQ::set"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NumericQ::unset", "ObjectNameWarningMessages",
  CellTags->"NumericQ::unset"],

Cell[BoxData[
    \(NumericQ::"unset" \(\(:\)\(\ \)\) 
      "Cannot clear `1`; the argument must be a symbol."\)], "Message",
  CellLabel->"From In[12]:=",
  CellTags->"NumericQ::unset"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Unset", "MR"],
  " is used with a ",
  StyleBox["NumericQ", "MR"],
  " expression, and the argument in ",
  StyleBox["NumericQ", "MR"],
  " is not a symbol.\n\[FilledSmallSquare] The notation ",
  StyleBox["expr", "TI"],
  StyleBox["=.", "MR"],
  " can be used for ",
  StyleBox["Unset[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  "."
}], "Notes",
  CellTags->"NumericQ::unset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NumericQ::unset"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["NumericQ", "MR"],
  " is not a symbol."
}], "Text",
  CellTags->"NumericQ::unset"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NumericQ[test[0]] =. \)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NumericQ::unset"],

Cell[BoxData[
    \(NumericQ::"unset" \(\(:\)\(\ \)\) 
      "Cannot clear \!\(NumericQ[\(\(test[0]\)\)]\); the argument must be a \
symbol."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NumericQ::unset"]
}, Closed]],

Cell[TextData[{
  "This unsets the ",
  StyleBox["NumericQ", "MR"],
  " property for the test symbol."
}], "Text",
  CellTags->"NumericQ::unset"],

Cell[BoxData[
    \(NumericQ[test] =. \)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NumericQ::unset"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["NRoots::nnumeq", "ObjectNameWarningMessages",
  CellTags->"NRoots::nnumeq"],

Cell[BoxData[
    \(NRoots::"nnumeq" \(\(:\)\(\ \)\) 
      "`1` is expected to be a polynomial equation in the variable `2` with \
numeric coefficients."\)], "Message",
  CellLabel->"From In[12]:=",
  CellTags->"NRoots::nnumeq"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["NRoots", "MR"],
  " does not have a head of ",
  StyleBox["Equal", "MR"],
  " or does not have two elements."
}], "Notes",
  CellTags->"NRoots::nnumeq"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"NRoots::nnumeq"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["NRoots", "MR"],
  " is not an equation."
}], "Text",
  CellTags->"NRoots::nnumeq"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NRoots[x^2 - 3  x + 7, x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"NRoots::nnumeq"],

Cell[BoxData[
    \(NRoots::"nnumeq" \(\(:\)\(\ \)\) 
      "\!\(\(\(7.`\[InvisibleSpace]\)\) - \(\(3.`\\ x\)\) + x\^2\) is \
expected to be a polynomial equation in the variable \!\(x\) with numeric \
coefficients."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"NRoots::nnumeq"],

Cell[BoxData[
    \(NRoots[7 - 3\ x + x\^2, x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"NRoots::nnumeq"]
}, Closed]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["NRoots", "MR"],
  "."
}], "Text",
  CellTags->"NRoots::nnumeq"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NRoots[x^2 - 3  x + 7 \[Equal] 0, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"NRoots::nnumeq"],

Cell[BoxData[
    \(x \[Equal] \(\(1.5`\)\(\[InvisibleSpace]\)\) - 
          2.1794494717703365`\ \[ImaginaryI] || 
      x \[Equal] \(\(1.5`\)\(\[InvisibleSpace]\)\) + 
          2.1794494717703365`\ \[ImaginaryI]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"NRoots::nnumeq"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Experimental`$EqualTolerance::tolset
Experimental`$SameQTolerance::tolset\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"tolset\"\>"}], \(\(:\)\(\ \)\), "\<\"Cannot set `1` to \
`2`; value must be a real number or +/- Infinity.\"\>"}]], "Message",
  CellLabel->"From In[12]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set ",
  StyleBox["Experimental`$SameQTolerance", "MR"],
  " or ",
  StyleBox["Experimental`$EqualTolerance", "MR"],
  " to a value other than the values specified in the message."
}], "Notes",
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Null", "MR"],
  " is not a valid value for ",
  StyleBox["Experimental`$SameQTolerance", "MR"],
  "."
}], "Text",
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Experimental`$SameQTolerance = Null\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}],

Cell[BoxData[
    \(Experimental`$SameQTolerance::"tolset" \(\(:\)\(\ \)\) 
      "Cannot set \!\(Experimental`$SameQTolerance\) to \!\(Null\); value \
must be a real number or +/- Infinity."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Developer`InequalityInstance::wkno
Experimental`ExistsRealQ::wkno
Experimental`ForAllRealQ::wkno
Experimental`ImpliesRealQ::wkno\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
    "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"wkno\"\>"}], \(\(:\)\(\ \)\), "\<\"No solution of the \
system of inequalities with inexact coefficients has been found, however the \
algorithm was not able to prove that the system has no solutions for any \
values of inexact coefficients within the error bounds.\"\>"}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
    "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
    "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}]
}, Closed]],

Cell[CellGroupData[{

Cell["FromContinuedFraction::root", "ObjectNameWarningMessages",
  CellTags->"FromContinuedFraction::root"],

Cell[BoxData[
    \(FromContinuedFraction::"root" \(\(:\)\(\ \)\) \(Unable\ to\ determine\ \
the\ appropriate\ root\ for\ the\ periodic\ continued\ \
\(\(fraction\)\(.\)\)\)\)], "Message",
  CellTags->"FromContinuedFraction::root"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"FromContinuedFraction::root"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Interpolation::per
ListInterpolation::per\
\>", "ObjectNameWarningMessages",
  CellTags->{"Interpolation::per", "ListInterpolation::per"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"per\"\>"}], \(\(:\)\(\ \)\), \(In\ dimension\ `1`\ the\ \
data\ at\ the\ endpoints\ of\ the\ fundamental\ period\ are\ not\ \(\(equal\)\
\(.\)\)\)}]], "Message",
  CellTags->{"Interpolation::per", "ListInterpolation::per"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Interpolation::per", "ListInterpolation::per"}]
}, Closed]],

Cell[CellGroupData[{

Cell["N::arg", "ObjectNameWarningMessages",
  CellTags->"N::arg"],

Cell[BoxData[
    \(N::"arg" \(\(:\)\(\ \)\) \(Argument\ `1`\ is\ not\ of\ the\ form\ \
\(\({precision, \ accuracy}\)\(.\)\)\)\)], "Message",
  CellTags->"N::arg"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"N::arg"]
}, Closed]],

Cell[CellGroupData[{

Cell["NIntegrate::singd", "ObjectNameWarningMessages",
  CellTags->"NIntegrate::singd"],

Cell[BoxData[
    \(NIntegrate::"singd" \(\(:\)\(\ \)\) 
      "NIntegrate's singularity handling has failed at point `1`=`2` for the \
specified precision goal. Try using larger values for the options \
WorkingPrecision, or SingularityDepth and MaxRecursion."\)], "Message",
  CellLabel->"From In[46]:=",
  CellTags->"NIntegrate::singd"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NIntegrate::singd"]
}, Closed]],

Cell[CellGroupData[{

Cell["System`Private`NRoot::bdst", "ObjectNameWarningMessages",
  CellTags->"System`Private`NRoot::bdst"],

Cell[BoxData[
    \(System`Private`NRoot::"bdst" \(\(:\)\(\ \)\) \(Starting\ value\ `1`\ is\
\ not\ sufficiently\ close\ to\ the\ true\ \(\(root\)\(.\)\)\)\)], "Message",
  CellTags->"System`Private`NRoot::bdst"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"System`Private`NRoot::bdst"]
}, Closed]],

Cell[CellGroupData[{

Cell["System`Private`NRoot::nnum", "ObjectNameWarningMessages",
  CellTags->"System`Private`NRoot::nnum"],

Cell[BoxData[
    \(System`Private`NRoot::"nnum" \(\(:\)\(\ \)\) \(Starting\ value\ `1`\ is\
\ not\ a\ \(\(number\)\(.\)\)\)\)], "Message",
  CellTags->"System`Private`NRoot::nnum"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"System`Private`NRoot::nnum"]
}, Closed]],

Cell[CellGroupData[{

Cell["System`Private`NRRoot::bpa", "ObjectNameWarningMessages",
  CellTags->"System`Private`NRRoot::bpa"],

Cell[BoxData[
    \(System`Private`NRRoot::"bpa" \(\(:\)\(\ \)\) \(Precision\ `2`\ is\ too\ \
low\ to\ find\ real\ roots\ of\ \(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"System`Private`NRRoot::bpa"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"System`Private`NRRoot::bpa"]
}, Closed]],

Cell[CellGroupData[{

Cell["System`Private`NRRoot::bfac", "ObjectNameWarningMessages",
  CellTags->"System`Private`NRRoot::bfac"],

Cell[BoxData[
    \(System`Private`NRRoot::"bfac" \(\(:\)\(\ \)\) \(Warning : \ 
          Using\ factorization\ `1`\  = \ `2`\ *\ `3`\ which\ may\ not\ be\ \
correct . \ The\ difference\ is\ \(\(`4`\)\(.\)\)\)\)], "Message",
  CellTags->"System`Private`NRRoot::bfac"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"System`Private`NRRoot::bfac"]
}, Closed]],

Cell[CellGroupData[{

Cell["NSolve::closesols", "ObjectNameWarningMessages",
  CellTags->"NSolve::closesols"],

Cell[BoxData[
    \(NSolve::"closesols" \(\(:\)\(\ \)\) \(Some\ solutions\ in\ variables\ \
`1`\ are\ close\ together . \ 
          This\ may\ cause\ solution\ components\ in\ other\ variables\ to\ \
suffer\ from\ loss\ of\ precision . \ 
          Use\ of\ increased\ WorkingPrecision\ may\ resolve\ \(\(this\)\(.\)\
\)\)\)], "Message",
  CellTags->"NSolve::closesols"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NSolve::closesols"]
}, Closed]],

Cell[CellGroupData[{

Cell["NSolve::illcnd", "ObjectNameWarningMessages",
  CellTags->"NSolve::illcnd"],

Cell[BoxData[
    \(NSolve::"illcnd" \(\(:\)\(\ \)\) \(Possible\ ill\ conditioning\ \
detected\ in\ system . \ 
          Likely\ cause\ is\ exact\ or\ approximate\ multiplicity . \ 
          This\ may\ cause\ solutions\ to\ suffer\ from\ loss\ of\ precision \
. \ Use\ of\ sufficiently\ large\ WorkingPrecision\ may\ resolve\ \
\(\(this\)\(.\)\)\)\)], "Message",
  CellTags->"NSolve::illcnd"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NSolve::illcnd"]
}, Closed]],

Cell[CellGroupData[{

Cell["NSolve::nsolprec", "ObjectNameWarningMessages",
  CellTags->"NSolve::nsolprec"],

Cell[BoxData[
    \(NSolve::"nsolprec" \(\(:\)\(\ \)\) \(Cannot\ obtain\ small\ residual . \
\ Use\ of\ sufficiently\ large\ WorkingPrecision\ may\ resolve\ \(\(this\)\(.\
\)\)\)\)], "Message",
  CellTags->"NSolve::nsolprec"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NSolve::nsolprec"]
}, Closed]],

Cell[CellGroupData[{

Cell["NSolve::infsolns", "ObjectNameWarningMessages",
  CellTags->"NSolve::infsolns"],

Cell[BoxData[
    \(NSolve::"infsolns" \(\(:\)\(\ \)\) \(Infinite\ solution\ set\ has\ \
dimension\ at\ least\ `1` . \ 
            Returning\ intersection\ of\ solutions\ with\ `2`\  == \ 
        1. \)\)], "Message",
  CellTags->"NSolve::infsolns"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"NSolve::infsolns"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::largd", \
"ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::largd"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"largd" \(\(:\)\(\ \)\) 
      "Argument specification `1` in `2` is not of the form {name, \
dimensions}."\)], "Message",
  CellLabel->"From In[116]:=",
  CellTags->"Experimental`CreateNumericalFunction::largd"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::largd"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::dlist", \
"ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::dlist"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"dlist" \(\(:\)\(\ \)\) 
      "Dimension list expected instead of `1` in `2`."\)], "Message",
  CellLabel->"From In[116]:=",
  CellTags->"Experimental`CreateNumericalFunction::dlist"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::dlist"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::largs", \
"ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::largs"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"largs" \(\(:\)\(\ \)\) 
      "Argument specification `1` in `2` is not of the form {name, sample \
value}."\)], "Message",
  CellLabel->"From In[116]:=",
  CellTags->"Experimental`CreateNumericalFunction::largs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::largs"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::nosamp", \
"ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::nosamp"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"nosamp" \(\(:\)\(\ \)\) 
      "Sample argument expected in specification `1`."\)], "Message",
  CellLabel->"From In[116]:=",
  CellTags->"Experimental`CreateNumericalFunction::nosamp"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::nosamp"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::scdims", \
"ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::scdims"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"scdims" \(\(:\)\(\ \)\) 
      "Smaple arguments given in specification `1` do not have consistent \
dimensions."\)], "Message",
  CellLabel->"From In[116]:=",
  CellTags->"Experimental`CreateNumericalFunction::scdims"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::scdims"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::srect", \
"ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::srect"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"srect" \(\(:\)\(\ \)\) 
      "Sample argument `1` in specification `2` is not a number or array of \
numbers."\)], "Message",
  CellLabel->"From In[116]:=",
  CellTags->"Experimental`CreateNumericalFunction::srect"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::srect"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::pval", "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::pval"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"pval" \(\(:\)\(\ \)\) 
      "Sample parameter value `1` in `2` is not a number."\)], "Message",
  CellLabel->"From In[116]:=",
  CellTags->"Experimental`CreateNumericalFunction::pval"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::pval"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::pdim", "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::pdim"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"pdim" \(\(:\)\(\ \)\) 
      "Dimensions `1` in `2` for the parameter are inconsistent with the \
requirement that the parameter be a scalar."\)], "Message",
  CellLabel->"From In[116]:=",
  CellTags->"Experimental`CreateNumericalFunction::pdim"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::pdim"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::dimsl", \
"ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::dimsl"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"dimsl" \(\(:\)\(\ \)\) 
      "`1` in list `2` is not a specification for the dimensions of an \
argument."\)], "Message",
  CellLabel->"From In[116]:=",
  CellTags->"Experimental`CreateNumericalFunction::dimsl"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::dimsl"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::ardims", \
"ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::ardims"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"ardims" \(\(:\)\(\ \)\) 
      "The result dimensions for `1` cannot be computed automatically unless \
the option SampleArgument->True and argument values are given in the second \
argument."\)], "Message",
  CellLabel->"From In[116]:=",
  CellTags->"Experimental`CreateNumericalFunction::ardims"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::ardims"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::jg", "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::jg"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"jg" \(\(:\)\(\ \)\) 
      "You cannot specify values for both the Gradient and Jacobian options."\
\)], "Message",
  CellLabel->"From In[117]:=",
  CellTags->"Experimental`CreateNumericalFunction::jg"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::jg"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::arglist", \
"ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::arglist"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"arglist" \(\(:\)\(\ \)\) 
      "The sample arguments `1` should be given as a list with elements \
corresponding to the variables `2`."\)], "Message",
  CellLabel->"From In[117]:=",
  CellTags->"Experimental`CreateNumericalFunction::arglist"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::arglist"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::msym", "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::msym"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"msym" \(\(:\)\(\ \)\) 
      "The value of the option `1` should be a symbol."\)], "Message",
  CellLabel->"From In[117]:=",
  CellTags->"Experimental`CreateNumericalFunction::msym"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::msym"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::rdim", "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::rdim"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"rdim" \(\(:\)\(\ \)\) 
      "The fourth argument `1` should be a list of positive machine integers \
containing the result dimensions."\)], "Message",
  CellLabel->"From In[117]:=",
  CellTags->"Experimental`CreateNumericalFunction::rdim"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::rdim"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Gradient::smeth
Jacobian::smeth
Hessian::smeth\
\>", "ObjectNameWarningMessages",
  CellTags->{"Gradient::smeth", "Jacobian::smeth", "Hessian::smeth"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"smeth\"\>"}], \(\(:\)\(\ \)\), "\<\"The method `1` in `2` \
for computing the derivative is not a function which will be evaluated to \
give the derivative or one of the strings \\\"FiniteDifference\\\" or \
\\\"Symbolic\\\".\"\>"}]], "Message",
  CellLabel->"From In[12]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Gradient::smeth", "Hessian::smeth", "Jacobian::smeth"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Gradient::smeth", "Jacobian::smeth", "Hessian::smeth"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Gradient::spopt
Jacobian::spopt
Hessian::spopt\
\>", "ObjectNameWarningMessages",
  CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"spopt\"\>"}], \(\(:\)\(\ \)\), \(The\ option\ Sparse -> \
`1`\ should\ be\ Automatic, \ True, \ False, \ 
      or\ a\ SparseArray\ pattern\ object\ with\ corresponding\ nonzero\ \
\(\(elements\)\(.\)\)\)}]], "Message",
  CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Product::div", "ObjectNameWarningMessages",
  CellTags->"Product::div"],

Cell[BoxData[
    \(Product::"div" \(\(:\)\(\ \)\) \(Product\ does\ not\ \
\(\(converge\)\(.\)\)\)\)], "Message",
  CellTags->"Product::div"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Product::div"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`NumberScale::num", "ObjectNameWarningMessages",
  CellTags->"Experimental`NumberScale::num"],

Cell[BoxData[
    \(Experimental`NumberScale::"num" \(\(:\)\(\ \)\) \(Argument\ `1`\ should\
\ be\ a\ \(\(number\)\(.\)\)\)\)], "Message",
  CellTags->"Experimental`NumberScale::num"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`NumberScale::num"]
}, Closed]],

Cell[CellGroupData[{

Cell["Sum::gener", "ObjectNameWarningMessages",
  CellTags->"Sum::gener"],

Cell[BoxData[
    \(Sum::"gener" \(\(:\)\(\ \)\) \(Unable\ to\ check\ \
\(\(convergence\)\(.\)\)\)\)], "Message",
  CellTags->"Sum::gener"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Sum::gener"]
}, Closed]],

Cell[CellGroupData[{

Cell["Total::tlauto", "ObjectNameWarningMessages",
  CellTags->"Total::tlauto"],

Cell[BoxData[
    \(Total::"tlauto" \(\(:\)\(\ \)\) 
      "The nested option for the Method option value Automatic can be \
\"ExtraPrecision\"->n, where n is an integer >= 0, or \
\"ExtraPrecision\"->Automatic, not `1`."\)], "Message",
  CellLabel->"From In[12]:=",
  CellTags->"Total::tlauto"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Total::tlauto"]
}, Closed]],

Cell[CellGroupData[{

Cell["Total::tlep", "ObjectNameWarningMessages",
  CellTags->"Total::tlep"],

Cell[BoxData[
    \(Total::"tlep" \(\(:\)\(\ \)\) 
      "The value of the option \"ExtraPrecision\"->`1` should be a positive \
integer or Automatic."\)], "Message",
  CellLabel->"From In[12]:=",
  CellTags->"Total::tlep"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Total::tlep"]
}, Closed]],

Cell[CellGroupData[{

Cell["Total::tlmth", "ObjectNameWarningMessages",
  CellTags->"Total::tlmth"],

Cell[BoxData[
    \(Total::"tlmth" \(\(:\)\(\ \)\) 
      "The value of the option Method->`1` should be Automatic or \
\"CompensatedSummation\"."\)], "Message",
  CellLabel->"From In[12]:=",
  CellTags->"Total::tlmth"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Total::tlmth"]
}, Closed]],

Cell[CellGroupData[{

Cell["Total::tllen", "ObjectNameWarningMessages",
  CellTags->"Total::tllen"],

Cell[BoxData[
    \(Total::"tllen" \(\(:\)\(\ \)\) \(Lists\ of\ unequal\ length\ in\ `1`\ \
cannot\ be\ \(\(added\)\(.\)\)\)\)], "Message",
  CellTags->"Total::tllen"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Total::tllen"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::idid", "ObjectNameWarningMessages",
  CellTags->"General::idid"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"idid\"\>"}], \(\(:\)\(\ \)\), \(`1`\ is\ not\ an\ \
integration\ direction\ specified\ by\ Forward\ or\ \
\(\(Backward\)\(.\)\)\)}]], "Message",
  CellTags->"General::idid"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::idid"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::wprec", "ObjectNameWarningMessages",
  CellTags->"General::wprec"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"wprec\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
WorkingPrecision\  -> \ `1`\ is\ not\ a\ positive\ machine - 
          sized\ real\ or\ \(\(integer\)\(.\)\)\)}]], "Message",
  CellTags->"General::wprec"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::wprec"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::agpginf", "ObjectNameWarningMessages",
  CellTags->"General::agpginf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"agpginf\"\>"}], \(\(:\)\(\ \)\), \(Both\ Accuracy\ and\ \
Precision\ goals\ are\ sufficiently\ large\ to\ allow\ effectively\ zero\ \
tolerance . \ \ The\ numerical\ algorithm\ cannot\ solve\ the\ problem\ \
\(\(exactly\)\(.\)\)\)}]], "Message",
  CellTags->"General::agpginf"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::agpginf"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::tma", "ObjectNameWarningMessages",
  CellTags->"General::tma"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"tma\"\>"}], \(\(:\)\(\ \)\), \(Too\ much\ accuracy\ \
requested\ at\ start\ of\ \(problem : \ 
          try\ increasing\ the\ value\ of\ the\ WorkingPrecision\ option\ or\ \
decreasing\ the\ values\ of\ the\ AccuracyGoal\ and/
              or\ PrecisionGoal\ \(\(options\)\(.\)\)\)\)}]], "Message",
  CellTags->"General::tma"],

Cell["\<\
\[FilledSmallSquare] Generated in ImplicitRungeKutta.m.\
\>", \
"Notes",
  CellTags->"General::tma"]
}, Closed]],

Cell[CellGroupData[{

Cell["InterpolatingFunction::cmpile", "ObjectNameWarningMessages",
  CellTags->"InterpolatingFunction::cmpile"],

Cell[BoxData[
    \(InterpolatingFunction::"cmpile" \(\(:\)\(\ \)\) \(The\ \
InterpolatingFunction\ could\ not\ be\ compiled\ because\ it\ has\ symbolic\ \
data\ or\ abscissae\ which\ cannot\ be\ resolved\ with\ machine\ \
\(\(numbers\)\(.\)\)\)\)], "Message",
  CellTags->"InterpolatingFunction::cmpile"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"InterpolatingFunction::cmpile"]
}, Closed]],

Cell[CellGroupData[{

Cell["ListInterpolation::ingrdm", "ObjectNameWarningMessages",
  CellTags->"ListInterpolation::ingrdm"],

Cell[BoxData[
    \(ListInterpolation::"ingrdm" \(\(:\)\(\ \)\) \(The\ dimension\ of\ the\ \
data\ to\ be\ interpolated\ in\ the\ first\ argument\ is\ inconsistent\ with\ \
the\ dimension\ of\ the\ grid\ in\ the\ second\ \(\(argument\)\(.\)\)\)\)], \
"Message",
  CellTags->"ListInterpolation::ingrdm"],

Cell["\<\
\[FilledSmallSquare] Generated when the number of elements in the \
data does not match the number of elements in the grid specification.\
\>", \
"Notes",
  CellTags->"ListInterpolation::ingrdm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ListInterpolation::ingrdm"],

Cell["\<\
An error occurs in this example because the grid range in the \
second argument is expected to be specified using a sublist for each \
dimension.\
\>", "Text",
  CellTags->"ListInterpolation::ingrdm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListInterpolation[{1, 9, 16, 25, 49}, {1, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ListInterpolation::ingrdm"],

Cell[BoxData[
    \(ListInterpolation::"ingrdm" \(\(:\)\(\ \)\) 
      "The dimension of the data to be interpolated in the first argument is \
inconsistent with the dimension of the grid in the second argument."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"ListInterpolation::ingrdm"],

Cell[BoxData[
    \(ListInterpolation[{1, 9, 16, 25, 49}, {1, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ListInterpolation::ingrdm"]
}, Closed]],

Cell[TextData[{
  "This shows a valid grid specification in ",
  StyleBox["ListInterpolation", "MR"],
  "."
}], "Text",
  CellTags->"ListInterpolation::ingrdm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ListInterpolation[{1, 9, 16, 25, 49}, {{1, 3}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ListInterpolation::ingrdm"],

Cell[BoxData[
    TagBox[\(InterpolatingFunction[{{1, 3}}, "<>"]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ListInterpolation::ingrdm"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nlnum", "ObjectNameWarningMessages",
  CellTags->"General::nlnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nlnum\"\>"}], \(\(:\)\(\ \)\), \(The\ function\ value\ `3`\
\ is\ not\ a\ list\ of\ numbers\ with\ dimensions\ `4`\ at\ `2`\  = \ \(\(`1`\
\)\(.\)\)\)}]], "Message",
  CellTags->"General::nlnum"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nlnum"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nlnum1", "ObjectNameWarningMessages",
  CellTags->"General::nlnum1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nlnum1\"\>"}], \(\(:\)\(\ \)\), \(The\ function\ value\ \
`2`\ is\ not\ a\ list\ of\ numbers\ with\ dimensions\ `3`\ when\ the\ \
arguments\ are\ \(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->"General::nlnum1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nlnum1"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::njnum", "ObjectNameWarningMessages",
  CellTags->"General::njnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"njnum\"\>"}], \(\(:\)\(\ \)\), "\<\"The Jacobian is not a \
matrix of numbers at `2` = `1`.\"\>"}]], "Message",
  CellLabel->"From In[27]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::njnum"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["Jacobian", "MR"],
  " option does not have the required form, or when when the corresponding \
derivatives are not numerical at the indicated point,\n\[FilledSmallSquare] \
This error can occur if a point is encountered at which the derivatives of \
the equations are singular or non-numerical, or if the value of the ",
  StyleBox["Jacobian", "MR"],
  " option includes symbolic parameters that do not have numerical values."
}], "Notes",
  CellTags->"General::njnum"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::njnum"],

Cell["\<\
An error occurs in this example because the first argument includes \
a symbolic parameter that does not have a numerical value.\
\>", "Text",
  CellTags->"General::njnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[2\ Sin[x] == 1, {x, 2}, Jacobian -> f]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::njnum"],

Cell[BoxData[
    \(FindRoot::"njnum" \(\(:\)\(\ \)\) 
      "The Jacobian \!\(f\) is not a matrix or tensor of numbers having \
dimensions \!\({1, 1}\) at \!\({x}\) = \!\({2.`}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::njnum"],

Cell[BoxData[
    \({x \[Rule] 2.`}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::njnum"]
}, Closed]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["Jacobian", "MR"],
  " option in ",
  StyleBox["FindRoot", "MR"],
  "."
}], "Text",
  CellTags->"General::njnum"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{f = {{2\ Cos[x]}}}, 
      FindRoot[2\ Sin[x] == 1, {x, 2}, Jacobian -> f]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::njnum"],

Cell[BoxData[
    \({x \[Rule] 2.6179938779914944`}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::njnum"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["General::njnum1", "ObjectNameWarningMessages",
  CellTags->"General::njnum1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"njnum1\"\>"}], \(\(:\)\(\ \)\), "\<\"The Jacobian is not a \
matrix of numbers when the arguments are `1`.\"\>"}]], "Message",
  CellLabel->"From In[27]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::njnum1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::njnum1"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nhnum", "ObjectNameWarningMessages",
  CellTags->"General::nhnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nhnum\"\>"}], \(\(:\)\(\ \)\), "\<\"The Hessian is not a \
matrix of numbers at `2` = `1`.\"\>"}]], "Message",
  CellLabel->"From In[27]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nhnum"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nhnum"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nhnum1", "ObjectNameWarningMessages",
  CellTags->"General::nhnum1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nhnum1\"\>"}], \(\(:\)\(\ \)\), "\<\"The Hessian is not a \
matrix of numbers when the arguments are `1`.\"\>"}]], "Message",
  CellLabel->"From In[27]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nhnum1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nhnum1"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nrnum", "ObjectNameWarningMessages",
  CellTags->"General::nrnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nrnum\"\>"}], \(\(:\)\(\ \)\), \(The\ function\ value\ `3`\
\ is\ not\ a\ real\ number\ at\ `2`\  = \ \(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->"General::nrnum"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nrnum"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nrnum1", "ObjectNameWarningMessages",
  CellTags->"General::nrnum1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nrnum1\"\>"}], \(\(:\)\(\ \)\), \(The\ function\ value\ \
`2`\ is\ not\ a\ real\ number\ when\ the\ arguments\ are\ \
\(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->"General::nrnum1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nrnum1"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nrlnum", "ObjectNameWarningMessages",
  CellTags->"General::nrlnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nrlnum\"\>"}], \(\(:\)\(\ \)\), \(The\ function\ value\ \
`3`\ is\ not\ a\ list\ of\ real\ numbers\ with\ dimensions\ `4`\ at\ `2`\  = \
\ \(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->"General::nrlnum"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nrlnum"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nrlnum1", "ObjectNameWarningMessages",
  CellTags->"General::nrlnum1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nrlnum1\"\>"}], \(\(:\)\(\ \)\), \(The\ function\ value\ \
`2`\ is\ not\ a\ list\ of\ real\ numbers\ with\ dimensions\ `3`\ when\ the\ \
arguments\ are\ \(\(`1`\)\(.\)\)\)}]], "Message",
  CellTags->"General::nrlnum1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nrlnum1"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nrgnum", "ObjectNameWarningMessages",
  CellTags->"General::nrgnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nrgnum\"\>"}], \(\(:\)\(\ \)\), "\<\"The gradient is not a \
vector of real numbers at `2` = `1`.\"\>"}]], "Message",
  CellLabel->"From In[27]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nrgnum"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nrgnum"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nrgnum1", "ObjectNameWarningMessages",
  CellTags->"General::nrgnum1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nrgnum1\"\>"}], \(\(:\)\(\ \)\), "\<\"The gradient is not \
a vector of real numbers of length when the arguments are `1`.\"\>"}]], \
"Message",
  CellLabel->"From In[27]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nrgnum1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nrgnum1"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nrjnum", "ObjectNameWarningMessages",
  CellTags->"General::nrjnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nrjnum\"\>"}], \(\(:\)\(\ \)\), "\<\"The Jacobian is not a \
matrix of real numbers at `2` = `1`.\"\>"}]], "Message",
  CellLabel->"From In[27]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nrjnum"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nrjnum"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nrjnum1", "ObjectNameWarningMessages",
  CellTags->"General::nrjnum1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nrjnum1\"\>"}], \(\(:\)\(\ \)\), "\<\"The Jacobian is not \
a matrix of real numbers when the arguments are `1`.\"\>"}]], "Message",
  CellLabel->"From In[27]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nrjnum1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nrjnum1"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nrhnum", "ObjectNameWarningMessages",
  CellTags->"General::nrhnum"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nrhnum\"\>"}], \(\(:\)\(\ \)\), "\<\"The Hessian is not a \
matrix of real numbers at `2` = `1`.\"\>"}]], "Message",
  CellLabel->"From In[27]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nrhnum"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nrhnum"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::nrhnum1", "ObjectNameWarningMessages",
  CellTags->"General::nrhnum1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"nrhnum1\"\>"}], \(\(:\)\(\ \)\), "\<\"The Hessian is not a \
matrix of real numbers when the arguments are `1`.\"\>"}]], "Message",
  CellLabel->"From In[27]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nrhnum1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::nrhnum1"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::preal", "ObjectNameWarningMessages",
  CellTags->"General::preal"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"preal\"\>"}], \(\(:\)\(\ \)\), "The", " ", 
      "parameter", " ", 
      StyleBox["expr",
        "TI"], " ", "should", " ", "be", " ", "real", 
      " ", \(\(valued\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::preal"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::preal"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::symd", "ObjectNameWarningMessages",
  CellTags->"General::symd"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"symd\"\>"}], \(\(:\)\(\ \)\), \(Unable\ to\ automatically\ \
compute\ the\ symbolic\ derivative\ of\ `1`\ with\ respect\ to\ the\ \
arguments\ `2` . \ 
          Numerical\ approximations\ to\ derivatives\ will\ be\ used\ \
\(\(instead\)\(.\)\)\)}]], "Message",
  CellTags->"General::symd"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::symd"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::symd1", "ObjectNameWarningMessages",
  CellTags->"General::symd1"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"symd1\"\>"}], \(\(:\)\(\ \)\), \(Unable\ to\ automatically\
\ compute\ the\ symbolic\ derivative\ of\ `1` . \ 
          Numerical\ approximations\ to\ derivatives\ will\ be\ used\ \
\(\(instead\)\(.\)\)\)}]], "Message",
  CellTags->"General::symd1"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::symd1"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::symdv", "ObjectNameWarningMessages",
  CellTags->"General::symdv"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"symdv\"\>"}], \(\(:\)\(\ \)\), \(Unable\ to\ automatically\
\ compute\ the\ symbolic\ derivative\ for\ a\ function\ of\ vector\ arguments \
. \ Numerical\ approximations\ to\ derivatives\ will\ be\ used\ \(\(instead\)\
\(.\)\)\)}]], "Message",
  CellTags->"General::symdv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::symdv"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::symfd", "ObjectNameWarningMessages",
  CellTags->"General::symfd"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"symfd\"\>"}], \(\(:\)\(\ \)\), \(Unable\ to\ compute\ the\ \
symbolic\ second\ derivative\ when\ the\ first\ derivative\ is\ computed\ \
using\ numerical\ approximations . \ \ Numerical\ approximations\ will\ be\ \
used\ \(\(instead\)\(.\)\)\)}]], "Message",
  CellTags->"General::symfd"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::symfd"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::vardep", "ObjectNameWarningMessages",
  CellTags->"General::vardep"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"vardep\"\>"}], \(\(:\)\(\ \)\), \(The\ variable\ `1`\ has\ \
dependencies\ on\ the\ other\ variables, \ `2` . \ \ Try\ using\ variables\ \
which\ do\ not\ depend\ on\ each\ \(\(other\)\(.\)\)\)}]], "Message",
  CellTags->"General::vardep"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::vardep"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::vloc", "ObjectNameWarningMessages",
  CellTags->"General::vloc"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"vloc\"\>"}], \(\(:\)\(\ \)\), \(The\ variable\ `1`\ cannot\
\ be\ localized\ so\ that\ it\ can\ be\ assigned\ to\ numerical\ \(\(values\)\
\(.\)\)\)}]], "Message",
  CellTags->"General::vloc"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::vloc"]
}, Closed]],

Cell[CellGroupData[{

Cell["General::vexdep", "ObjectNameWarningMessages",
  CellTags->"General::vexdep"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"vexdep\"\>"}], \(\(:\)\(\ \)\), \(The\ variable\ `1`\ has\ \
dependencies\ in\ the\ current\ session\ which\ causes\ it\ to\ evaluate\ to\ \
`2`\ which\ cannot\ be\ used\ as\ a\ \(\(variable\)\(.\)\)\)}]], "Message",
  CellTags->"General::vexdep"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"General::vexdep"]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental`CreateNumericalFunction::neargs", \
"ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::neargs"],

Cell[BoxData[
    \(Experimental`CreateNumericalFunction::"neargs" \(\(:\)\(\ \)\) 
      "The first argument should be a nonempty list of argument \
specifications."\)], "Message",
  CellLabel->"From In[118]:=",
  CellTags->"Experimental`CreateNumericalFunction::neargs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Experimental`CreateNumericalFunction::neargs"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{4, 1152}, {0, 848}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{641, 517},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Roots::eqn"->{
    Cell[1839, 57, 110, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[1952, 63, 360, 11, 19, "Message",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[2315, 76, 451, 15, 46, "Notes",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[2791, 95, 77, 1, 38, "ExampleSection",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[2871, 98, 101, 1, 24, "Text",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[2997, 103, 124, 3, 26, "Input",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[3124, 108, 195, 4, 21, "Message",
      CellTags->{"NRoots::eqn", "Roots::eqn"}],
    Cell[3322, 114, 126, 3, 27, "Output",
      CellTags->{"NRoots::eqn", "Roots::eqn"}],
    Cell[3463, 120, 137, 4, 24, "Text",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[3625, 128, 129, 3, 26, "Input",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[3757, 133, 129, 3, 25, "Output",
      CellTags->{"NRoots::eqn", "Roots::eqn"}]},
  "NRoots::eqn"->{
    Cell[1839, 57, 110, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[1952, 63, 360, 11, 19, "Message",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[2315, 76, 451, 15, 46, "Notes",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[2791, 95, 77, 1, 38, "ExampleSection",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[2871, 98, 101, 1, 24, "Text",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[2997, 103, 124, 3, 26, "Input",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[3124, 108, 195, 4, 21, "Message",
      CellTags->{"NRoots::eqn", "Roots::eqn"}],
    Cell[3322, 114, 126, 3, 27, "Output",
      CellTags->{"NRoots::eqn", "Roots::eqn"}],
    Cell[3463, 120, 137, 4, 24, "Text",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[3625, 128, 129, 3, 26, "Input",
      CellTags->{"Roots::eqn", "NRoots::eqn"}],
    Cell[3757, 133, 129, 3, 25, "Output",
      CellTags->{"NRoots::eqn", "Roots::eqn"}]},
  "Roots::neq"->{
    Cell[3947, 143, 110, 4, 45, "ObjectNameWarningMessages",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[4060, 149, 492, 14, 19, "Message",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[4555, 165, 385, 9, 62, "Notes",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[4965, 178, 77, 1, 38, "ExampleSection",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[5045, 181, 172, 5, 24, "Text",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[5242, 190, 126, 3, 26, "Input",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[5371, 195, 233, 5, 24, "Message",
      CellTags->{"NRoots::neq", "Roots::neq"}],
    Cell[5607, 202, 133, 3, 26, "Output",
      CellTags->{"NRoots::neq", "Roots::neq"}],
    Cell[5755, 208, 143, 5, 24, "Text",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[5923, 217, 126, 3, 26, "Input",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[6052, 222, 116, 3, 21, "Output",
      CellTags->{"NRoots::neq", "Roots::neq"}]},
  "NRoots::neq"->{
    Cell[3947, 143, 110, 4, 45, "ObjectNameWarningMessages",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[4060, 149, 492, 14, 19, "Message",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[4555, 165, 385, 9, 62, "Notes",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[4965, 178, 77, 1, 38, "ExampleSection",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[5045, 181, 172, 5, 24, "Text",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[5242, 190, 126, 3, 26, "Input",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[5371, 195, 233, 5, 24, "Message",
      CellTags->{"NRoots::neq", "Roots::neq"}],
    Cell[5607, 202, 133, 3, 26, "Output",
      CellTags->{"NRoots::neq", "Roots::neq"}],
    Cell[5755, 208, 143, 5, 24, "Text",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[5923, 217, 126, 3, 26, "Input",
      CellTags->{"Roots::neq", "NRoots::neq"}],
    Cell[6052, 222, 116, 3, 21, "Output",
      CellTags->{"NRoots::neq", "Roots::neq"}]},
  "General::meprec"->{
    Cell[6229, 232, 83, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::meprec"],
    Cell[6315, 235, 511, 16, 37, "Message",
      CellTags->"General::meprec"],
    Cell[6829, 253, 950, 18, 160, "Notes",
      CellTags->"General::meprec"],
    Cell[7804, 275, 65, 1, 38, "ExampleSection",
      CellTags->"General::meprec"],
    Cell[7872, 278, 368, 10, 56, "Text",
      CellTags->"General::meprec"],
    Cell[8265, 292, 118, 3, 26, "Input",
      CellTags->"General::meprec"],
    Cell[8386, 297, 300, 6, 53, "Message",
      CellTags->"General::meprec"],
    Cell[8689, 305, 115, 3, 21, "Output",
      CellTags->"General::meprec"],
    Cell[8819, 311, 266, 7, 40, "Text",
      CellTags->"General::meprec"],
    Cell[9110, 322, 135, 3, 26, "Input",
      CellTags->"General::meprec"],
    Cell[9248, 327, 335, 6, 70, "Message",
      CellTags->"General::meprec"],
    Cell[9586, 335, 142, 3, 36, "Output",
      CellTags->"General::meprec"],
    Cell[9743, 341, 191, 7, 24, "Text",
      CellTags->"General::meprec"],
    Cell[9959, 352, 182, 4, 42, "Input",
      CellTags->"General::meprec"],
    Cell[10144, 358, 93, 3, 21, "Output",
      CellTags->"General::meprec"]},
  "$MaxExtraPrecision::meprecset"->{
    Cell[10298, 368, 111, 1, 25, "ObjectNameWarningMessages",
      CellTags->"$MaxExtraPrecision::meprecset"],
    Cell[10412, 371, 340, 6, 37, "Message",
      CellTags->"$MaxExtraPrecision::meprecset"],
    Cell[10755, 379, 226, 5, 24, "Notes",
      CellTags->"$MaxExtraPrecision::meprecset"],
    Cell[11006, 388, 79, 1, 38, "ExampleSection",
      CellTags->"$MaxExtraPrecision::meprecset"],
    Cell[11088, 391, 357, 10, 40, "Text",
      CellTags->"$MaxExtraPrecision::meprecset"],
    Cell[11470, 405, 145, 3, 26, "Input",
      CellTags->"$MaxExtraPrecision::meprecset"],
    Cell[11618, 410, 278, 5, 53, "Message",
      CellTags->"$MaxExtraPrecision::meprecset"]},
  "$MaxPrecision::precset"->{
    Cell[11957, 422, 97, 1, 25, "ObjectNameWarningMessages",
      CellTags->"$MaxPrecision::precset"],
    Cell[12057, 425, 434, 11, 37, "Message",
      CellTags->"$MaxPrecision::precset"],
    Cell[12494, 438, 185, 5, 24, "Notes",
      CellTags->"$MaxPrecision::precset"],
    Cell[12704, 447, 72, 1, 38, "ExampleSection",
      CellTags->"$MaxPrecision::precset"],
    Cell[12779, 450, 234, 7, 40, "Text",
      CellTags->"$MaxPrecision::precset"],
    Cell[13038, 461, 130, 3, 26, "Input",
      CellTags->"$MaxPrecision::precset"],
    Cell[13171, 466, 255, 5, 53, "Message",
      CellTags->"$MaxPrecision::precset"],
    Cell[13429, 473, 111, 3, 21, "Output",
      CellTags->"$MaxPrecision::precset"]},
  "$MinPrecision::precset"->{
    Cell[13601, 483, 97, 1, 25, "ObjectNameWarningMessages",
      CellTags->"$MinPrecision::precset"],
    Cell[13701, 486, 453, 11, 37, "Message",
      CellTags->"$MinPrecision::precset"],
    Cell[14157, 499, 185, 5, 24, "Notes",
      CellTags->"$MinPrecision::precset"],
    Cell[14367, 508, 72, 1, 38, "ExampleSection",
      CellTags->"$MinPrecision::precset"],
    Cell[14442, 511, 237, 7, 40, "Text",
      CellTags->"$MinPrecision::precset"],
    Cell[14704, 522, 130, 3, 26, "Input",
      CellTags->"$MinPrecision::precset"],
    Cell[14837, 527, 255, 5, 53, "Message",
      CellTags->"$MinPrecision::precset"],
    Cell[15095, 534, 111, 3, 21, "Output",
      CellTags->"$MinPrecision::precset"]},
  "$MinPrecision::preccon"->{
    Cell[15267, 544, 156, 4, 45, "ObjectNameWarningMessages",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[15426, 550, 462, 12, 21, "Message",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[15891, 564, 509, 15, 62, "Notes",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[16425, 583, 100, 1, 38, "ExampleSection",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[16528, 586, 196, 6, 24, "Text",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[16749, 596, 192, 4, 26, "Input",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[16944, 602, 253, 5, 37, "Message",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[17200, 609, 131, 3, 21, "Output",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[17346, 615, 216, 7, 24, "Text",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[17587, 626, 192, 4, 26, "Input",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[17782, 632, 131, 3, 21, "Output",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}]},
  "$MaxPrecision::preccon"->{
    Cell[15267, 544, 156, 4, 45, "ObjectNameWarningMessages",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[15426, 550, 462, 12, 21, "Message",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[15891, 564, 509, 15, 62, "Notes",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[16425, 583, 100, 1, 38, "ExampleSection",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[16528, 586, 196, 6, 24, "Text",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[16749, 596, 192, 4, 26, "Input",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[16944, 602, 253, 5, 37, "Message",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[17200, 609, 131, 3, 21, "Output",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[17346, 615, 216, 7, 24, "Text",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[17587, 626, 192, 4, 26, "Input",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
    Cell[17782, 632, 131, 3, 21, "Output",
      CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}]},
  "$MinPrecision::preclck"->{
    Cell[17974, 642, 156, 4, 45, "ObjectNameWarningMessages",
      CellTags->{"$MinPrecision::preclck", "$MaxPrecision::preclck"}],
    Cell[18133, 648, 557, 13, 37, "Message",
      CellTags->{"$MinPrecision::preclck", "$MaxPrecision::preclck"}],
    Cell[18693, 663, 812, 16, 116, "Notes",
      CellTags->{"$MinPrecision::preclck", "$MaxPrecision::preclck"}]},
  "$MaxPrecision::preclck"->{
    Cell[17974, 642, 156, 4, 45, "ObjectNameWarningMessages",
      CellTags->{"$MinPrecision::preclck", "$MaxPrecision::preclck"}],
    Cell[18133, 648, 557, 13, 37, "Message",
      CellTags->{"$MinPrecision::preclck", "$MaxPrecision::preclck"}],
    Cell[18693, 663, 812, 16, 116, "Notes",
      CellTags->{"$MinPrecision::preclck", "$MaxPrecision::preclck"}]},
  "NIntegrate::lzero"->{
    Cell[19542, 684, 87, 1, 25, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::lzero"],
    Cell[19632, 687, 215, 4, 53, "Message",
      CellTags->"NIntegrate::lzero"],
    Cell[19850, 693, 915, 28, 116, "Notes",
      CellTags->"NIntegrate::lzero"],
    Cell[20790, 725, 67, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::lzero"],
    Cell[20860, 728, 194, 6, 24, "Text",
      CellTags->"NIntegrate::lzero"],
    Cell[21079, 738, 180, 4, 42, "Input",
      CellTags->"NIntegrate::lzero"],
    Cell[21262, 744, 244, 5, 53, "Message",
      CellTags->"NIntegrate::lzero"],
    Cell[21509, 751, 197, 4, 21, "Output",
      CellTags->"NIntegrate::lzero"]},
  "NSum::nsnum"->{
    Cell[21767, 762, 75, 1, 25, "ObjectNameWarningMessages",
      CellTags->"NSum::nsnum"],
    Cell[21845, 765, 420, 12, 21, "Message",
      CellTags->"NSum::nsnum"],
    Cell[22268, 779, 232, 6, 40, "Notes",
      CellTags->"NSum::nsnum"],
    Cell[22525, 789, 61, 1, 38, "ExampleSection",
      CellTags->"NSum::nsnum"],
    Cell[22589, 792, 134, 5, 24, "Text",
      CellTags->"NSum::nsnum"],
    Cell[22748, 801, 103, 3, 26, "Input",
      CellTags->"NSum::nsnum"],
    Cell[22854, 806, 216, 5, 37, "Message",
      CellTags->"NSum::nsnum"],
    Cell[23073, 813, 104, 3, 21, "Output",
      CellTags->"NSum::nsnum"]},
  "NIntegrate::ncvi"->{
    Cell[23238, 823, 85, 1, 25, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::ncvi"],
    Cell[23326, 826, 538, 13, 37, "Message",
      CellTags->"NIntegrate::ncvi"],
    Cell[23867, 841, 901, 21, 132, "Notes",
      CellTags->"NIntegrate::ncvi"],
    Cell[24793, 866, 66, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::ncvi"],
    Cell[24862, 869, 145, 4, 24, "Text",
      CellTags->"NIntegrate::ncvi"],
    Cell[25032, 877, 161, 4, 26, "Input",
      CellTags->"NIntegrate::ncvi"],
    Cell[25196, 883, 415, 7, 85, "Message",
      CellTags->"NIntegrate::ncvi"],
    Cell[25614, 892, 285, 6, 53, "Message",
      CellTags->"NIntegrate::ncvi"],
    Cell[25902, 900, 115, 3, 21, "Output",
      CellTags->"NIntegrate::ncvi"]},
  "NSum::nslim"->{
    Cell[26078, 910, 75, 1, 25, "ObjectNameWarningMessages",
      CellTags->"NSum::nslim"],
    Cell[26156, 913, 242, 5, 21, "Message",
      CellTags->"NSum::nslim"],
    Cell[26401, 920, 198, 6, 24, "Notes",
      CellTags->"NSum::nslim"],
    Cell[26624, 930, 61, 1, 38, "ExampleSection",
      CellTags->"NSum::nslim"],
    Cell[26688, 933, 214, 5, 40, "Text",
      CellTags->"NSum::nslim"],
    Cell[26927, 942, 99, 3, 26, "Input",
      CellTags->"NSum::nslim"],
    Cell[27029, 947, 173, 4, 21, "Message",
      CellTags->"NSum::nslim"],
    Cell[27205, 953, 100, 3, 21, "Output",
      CellTags->"NSum::nslim"],
    Cell[27320, 959, 120, 5, 24, "Text",
      CellTags->"NSum::nslim"],
    Cell[27465, 968, 100, 3, 26, "Input",
      CellTags->"NSum::nslim"],
    Cell[27568, 973, 87, 3, 21, "Output",
      CellTags->"NSum::nslim"]},
  "NIntegrate::noeval"->{
    Cell[27716, 983, 89, 1, 25, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::noeval"],
    Cell[27808, 986, 317, 6, 53, "Message",
      CellTags->"NIntegrate::noeval"],
    Cell[28128, 994, 635, 15, 100, "Notes",
      CellTags->"NIntegrate::noeval"],
    Cell[28788, 1013, 68, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::noeval"],
    Cell[28859, 1016, 185, 5, 24, "Text",
      CellTags->"NIntegrate::noeval"],
    Cell[29069, 1025, 164, 4, 26, "Input",
      CellTags->"NIntegrate::noeval"],
    Cell[29236, 1031, 288, 6, 69, "Message",
      CellTags->"NIntegrate::noeval"],
    Cell[29527, 1039, 175, 4, 36, "Output",
      CellTags->"NIntegrate::noeval"],
    Cell[29717, 1046, 186, 7, 24, "Text",
      CellTags->"NIntegrate::noeval"],
    Cell[29928, 1057, 161, 4, 26, "Input",
      CellTags->"NIntegrate::noeval"],
    Cell[30092, 1063, 111, 3, 21, "Output",
      CellTags->"NIntegrate::noeval"],
    Cell[30218, 1069, 257, 7, 40, "Text",
      CellTags->"NIntegrate::noeval"],
    Cell[30500, 1080, 153, 4, 26, "Input",
      CellTags->"NIntegrate::noeval"],
    Cell[30656, 1086, 288, 6, 69, "Message",
      CellTags->"NIntegrate::noeval"],
    Cell[30947, 1094, 169, 4, 36, "Output",
      CellTags->"NIntegrate::noeval"],
    Cell[31131, 1101, 221, 5, 40, "Text",
      CellTags->"NIntegrate::noeval"],
    Cell[31377, 1110, 136, 3, 26, "Input",
      CellTags->"NIntegrate::noeval"],
    Cell[31516, 1115, 153, 4, 23, "Output",
      CellTags->"NIntegrate::noeval"]},
  "NIntegrate::nlim"->{
    Cell[31730, 1126, 85, 1, 25, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::nlim"],
    Cell[31818, 1129, 402, 11, 21, "Message",
      CellTags->"NIntegrate::nlim"],
    Cell[32223, 1142, 197, 6, 24, "Notes",
      CellTags->"NIntegrate::nlim"],
    Cell[32445, 1152, 66, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::nlim"],
    Cell[32514, 1155, 229, 6, 40, "Text",
      CellTags->"NIntegrate::nlim"],
    Cell[32768, 1165, 121, 3, 26, "Input",
      CellTags->"NIntegrate::nlim"],
    Cell[32892, 1170, 194, 4, 21, "Message",
      CellTags->"NIntegrate::nlim"],
    Cell[33089, 1176, 134, 3, 21, "Output",
      CellTags->"NIntegrate::nlim"],
    Cell[33238, 1182, 131, 5, 24, "Text",
      CellTags->"NIntegrate::nlim"],
    Cell[33394, 1191, 121, 3, 26, "Input",
      CellTags->"NIntegrate::nlim"],
    Cell[33518, 1196, 108, 3, 21, "Output",
      CellTags->"NIntegrate::nlim"],
    Cell[33641, 1202, 177, 4, 40, "Text",
      CellTags->"NIntegrate::nlim"],
    Cell[33843, 1210, 127, 3, 26, "Input",
      CellTags->"NIntegrate::nlim"],
    Cell[33973, 1215, 209, 5, 21, "Message",
      CellTags->"NIntegrate::nlim"],
    Cell[34185, 1222, 128, 3, 21, "Output",
      CellTags->"NIntegrate::nlim"],
    Cell[34328, 1228, 233, 5, 40, "Text",
      CellTags->"NIntegrate::nlim"],
    Cell[34564, 1235, 138, 3, 26, "Input",
      CellTags->"NIntegrate::nlim"],
    Cell[34727, 1242, 93, 3, 26, "Input",
      CellTags->"NIntegrate::nlim"],
    Cell[34823, 1247, 108, 3, 21, "Output",
      CellTags->"NIntegrate::nlim"],
    Cell[34946, 1253, 113, 5, 24, "Text",
      CellTags->"NIntegrate::nlim"],
    Cell[35062, 1260, 109, 3, 26, "Input",
      CellTags->"NIntegrate::nlim"]},
  "NIntegrate::vars"->{
    Cell[35220, 1269, 85, 1, 25, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::vars"],
    Cell[35308, 1272, 312, 6, 37, "Message",
      CellTags->"NIntegrate::vars"],
    Cell[35623, 1280, 480, 10, 62, "Notes",
      CellTags->"NIntegrate::vars"],
    Cell[36128, 1294, 66, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::vars"],
    Cell[36197, 1297, 173, 5, 24, "Text",
      CellTags->"NIntegrate::vars"],
    Cell[36395, 1306, 113, 3, 26, "Input",
      CellTags->"NIntegrate::vars"],
    Cell[36511, 1311, 222, 5, 37, "Message",
      CellTags->"NIntegrate::vars"],
    Cell[36736, 1318, 126, 3, 21, "Output",
      CellTags->"NIntegrate::vars"],
    Cell[36877, 1324, 131, 5, 24, "Text",
      CellTags->"NIntegrate::vars"],
    Cell[37033, 1333, 121, 3, 26, "Input",
      CellTags->"NIntegrate::vars"],
    Cell[37157, 1338, 108, 3, 21, "Output",
      CellTags->"NIntegrate::vars"]},
  "RealDigits::ndig"->{
    Cell[37326, 1348, 85, 1, 25, "ObjectNameWarningMessages",
      CellTags->"RealDigits::ndig"],
    Cell[37414, 1351, 180, 3, 21, "Message",
      CellTags->"RealDigits::ndig"],
    Cell[37597, 1356, 339, 8, 62, "Notes",
      CellTags->"RealDigits::ndig"],
    Cell[37961, 1368, 66, 1, 38, "ExampleSection",
      CellTags->"RealDigits::ndig"],
    Cell[38030, 1371, 178, 5, 24, "Text",
      CellTags->"RealDigits::ndig"],
    Cell[38233, 1380, 108, 3, 26, "Input",
      CellTags->"RealDigits::ndig"],
    Cell[38344, 1385, 192, 4, 21, "Message",
      CellTags->"RealDigits::ndig"],
    Cell[38539, 1391, 110, 3, 21, "Output",
      CellTags->"RealDigits::ndig"],
    Cell[38664, 1397, 131, 5, 24, "Text",
      CellTags->"RealDigits::ndig"],
    Cell[38820, 1406, 111, 3, 26, "Input",
      CellTags->"RealDigits::ndig"],
    Cell[38934, 1411, 272, 5, 37, "Output",
      CellTags->"RealDigits::ndig"]},
  "RealDigits::rbase"->{
    Cell[39267, 1423, 148, 4, 45, "ObjectNameWarningMessages",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[39418, 1429, 356, 10, 21, "Message",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[39777, 1441, 287, 7, 40, "Notes",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[40089, 1452, 96, 1, 38, "ExampleSection",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[40188, 1455, 136, 1, 24, "Text",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[40349, 1460, 138, 3, 26, "Input",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[40490, 1465, 220, 4, 21, "Message",
      CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}],
    Cell[40713, 1471, 140, 3, 21, "Output",
      CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}],
    Cell[40868, 1477, 184, 5, 24, "Text",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[41077, 1486, 138, 3, 26, "Input",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[41218, 1491, 302, 5, 37, "Output",
      CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}],
    Cell[41535, 1499, 206, 5, 24, "Text",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[41766, 1508, 154, 3, 26, "Input",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[41923, 1513, 236, 5, 37, "Message",
      CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}],
    Cell[42162, 1520, 154, 3, 21, "Output",
      CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}]},
  "MantissaExponent::rbase"->{
    Cell[39267, 1423, 148, 4, 45, "ObjectNameWarningMessages",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[39418, 1429, 356, 10, 21, "Message",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[39777, 1441, 287, 7, 40, "Notes",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[40089, 1452, 96, 1, 38, "ExampleSection",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[40188, 1455, 136, 1, 24, "Text",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[40349, 1460, 138, 3, 26, "Input",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[40490, 1465, 220, 4, 21, "Message",
      CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}],
    Cell[40713, 1471, 140, 3, 21, "Output",
      CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}],
    Cell[40868, 1477, 184, 5, 24, "Text",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[41077, 1486, 138, 3, 26, "Input",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[41218, 1491, 302, 5, 37, "Output",
      CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}],
    Cell[41535, 1499, 206, 5, 24, "Text",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[41766, 1508, 154, 3, 26, "Input",
      CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
    Cell[41923, 1513, 236, 5, 37, "Message",
      CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}],
    Cell[42162, 1520, 154, 3, 21, "Output",
      CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}]},
  "NProduct::istep"->{
    Cell[42377, 1530, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[42500, 1536, 433, 13, 21, "Message",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[42936, 1551, 568, 18, 46, "Notes",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[43529, 1573, 82, 1, 38, "ExampleSection",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[43614, 1576, 268, 9, 24, "Text",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[43907, 1589, 143, 3, 26, "Input",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[44053, 1594, 221, 5, 21, "Message",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[44277, 1601, 146, 3, 36, "Output",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[44438, 1607, 203, 7, 24, "Text",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[44666, 1618, 179, 5, 26, "Input",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[44848, 1625, 151, 3, 21, "Output",
      CellTags->{"NProduct::istep", "NSum::istep"}]},
  "NSum::istep"->{
    Cell[42377, 1530, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[42500, 1536, 433, 13, 21, "Message",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[42936, 1551, 568, 18, 46, "Notes",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[43529, 1573, 82, 1, 38, "ExampleSection",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[43614, 1576, 268, 9, 24, "Text",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[43907, 1589, 143, 3, 26, "Input",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[44053, 1594, 221, 5, 21, "Message",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[44277, 1601, 146, 3, 36, "Output",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[44438, 1607, 203, 7, 24, "Text",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[44666, 1618, 179, 5, 26, "Input",
      CellTags->{"NProduct::istep", "NSum::istep"}],
    Cell[44848, 1625, 151, 3, 21, "Output",
      CellTags->{"NProduct::istep", "NSum::istep"}]},
  "Accuracy::mnprec"->{
    Cell[45060, 1635, 134, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[45197, 1641, 393, 11, 37, "Message",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[45593, 1654, 810, 22, 100, "Notes",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[46428, 1680, 89, 1, 38, "ExampleSection",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[46520, 1683, 201, 5, 24, "Text",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[46746, 1692, 207, 4, 90, "Input",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[46956, 1698, 259, 5, 37, "Message",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[47218, 1705, 117, 3, 21, "Output",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[47350, 1711, 128, 1, 24, "Text",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[47503, 1716, 140, 3, 26, "Input",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[47646, 1721, 259, 5, 37, "Message",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[47908, 1728, 133, 3, 23, "Output",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}]},
  "Precision::mnprec"->{
    Cell[45060, 1635, 134, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[45197, 1641, 393, 11, 37, "Message",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[45593, 1654, 810, 22, 100, "Notes",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[46428, 1680, 89, 1, 38, "ExampleSection",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[46520, 1683, 201, 5, 24, "Text",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[46746, 1692, 207, 4, 90, "Input",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[46956, 1698, 259, 5, 37, "Message",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[47218, 1705, 117, 3, 21, "Output",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[47350, 1711, 128, 1, 24, "Text",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[47503, 1716, 140, 3, 26, "Input",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[47646, 1721, 259, 5, 37, "Message",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
    Cell[47908, 1728, 133, 3, 23, "Output",
      CellTags->{"Accuracy::mnprec", "Precision::mnprec"}]},
  "Accuracy::mxprec"->{
    Cell[48102, 1738, 134, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[48239, 1744, 362, 10, 37, "Message",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[48604, 1756, 314, 9, 40, "Notes",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[48943, 1769, 89, 1, 38, "ExampleSection",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[49035, 1772, 264, 6, 40, "Text",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[49324, 1782, 158, 3, 26, "Input",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[49485, 1787, 259, 5, 37, "Message",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[49747, 1794, 117, 3, 21, "Output",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[49879, 1800, 120, 1, 24, "Text",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[50024, 1805, 168, 3, 26, "Input",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[50195, 1810, 258, 5, 37, "Message",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[50456, 1817, 121, 3, 21, "Output",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}]},
  "Precision::mxprec"->{
    Cell[48102, 1738, 134, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[48239, 1744, 362, 10, 37, "Message",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[48604, 1756, 314, 9, 40, "Notes",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[48943, 1769, 89, 1, 38, "ExampleSection",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[49035, 1772, 264, 6, 40, "Text",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[49324, 1782, 158, 3, 26, "Input",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[49485, 1787, 259, 5, 37, "Message",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[49747, 1794, 117, 3, 21, "Output",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[49879, 1800, 120, 1, 24, "Text",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[50024, 1805, 168, 3, 26, "Input",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[50195, 1810, 258, 5, 37, "Message",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
    Cell[50456, 1817, 121, 3, 21, "Output",
      CellTags->{"Accuracy::mxprec", "Precision::mxprec"}]},
  "Fourier::fftl"->{
    Cell[50638, 1827, 134, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[50775, 1833, 384, 11, 37, "Message",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[51162, 1846, 254, 7, 24, "Notes",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[51441, 1857, 89, 1, 38, "ExampleSection",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[51533, 1860, 176, 4, 24, "Text",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[51734, 1868, 131, 3, 26, "Input",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[51868, 1873, 255, 5, 37, "Message",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[52126, 1880, 132, 3, 21, "Output",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[52273, 1886, 149, 5, 24, "Text",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[52447, 1895, 137, 3, 26, "Input",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[52587, 1900, 249, 5, 21, "Output",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}]},
  "InverseFourier::fftl"->{
    Cell[50638, 1827, 134, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[50775, 1833, 384, 11, 37, "Message",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[51162, 1846, 254, 7, 24, "Notes",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[51441, 1857, 89, 1, 38, "ExampleSection",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[51533, 1860, 176, 4, 24, "Text",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[51734, 1868, 131, 3, 26, "Input",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[51868, 1873, 255, 5, 37, "Message",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[52126, 1880, 132, 3, 21, "Output",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[52273, 1886, 149, 5, 24, "Text",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[52447, 1895, 137, 3, 26, "Input",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
    Cell[52587, 1900, 249, 5, 21, "Output",
      CellTags->{"Fourier::fftl", "InverseFourier::fftl"}]},
  "FromDigits::nlst"->{
    Cell[52897, 1912, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FromDigits::nlst"],
    Cell[52985, 1915, 251, 6, 21, "Message",
      CellTags->"FromDigits::nlst"],
    Cell[53239, 1923, 170, 5, 24, "Notes",
      CellTags->"FromDigits::nlst"],
    Cell[53434, 1932, 66, 1, 38, "ExampleSection",
      CellTags->"FromDigits::nlst"],
    Cell[53503, 1935, 184, 5, 24, "Text",
      CellTags->"FromDigits::nlst"],
    Cell[53712, 1944, 103, 3, 26, "Input",
      CellTags->"FromDigits::nlst"],
    Cell[53818, 1949, 188, 4, 21, "Message",
      CellTags->"FromDigits::nlst"],
    Cell[54009, 1955, 104, 3, 21, "Output",
      CellTags->"FromDigits::nlst"],
    Cell[54128, 1961, 130, 5, 24, "Text",
      CellTags->"FromDigits::nlst"],
    Cell[54283, 1970, 107, 3, 26, "Input",
      CellTags->"FromDigits::nlst"],
    Cell[54393, 1975, 92, 3, 21, "Output",
      CellTags->"FromDigits::nlst"]},
  "FunctionInterpolation::argdim"->{
    Cell[54546, 1985, 111, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[54660, 1988, 367, 7, 53, "Message",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[55030, 1997, 305, 8, 40, "Notes",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[55360, 2009, 79, 1, 38, "ExampleSection",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[55442, 2012, 223, 5, 40, "Text",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[55690, 2021, 209, 5, 58, "Input",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[55902, 2028, 315, 6, 69, "Message",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[56220, 2036, 242, 5, 37, "Message",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[56465, 2043, 245, 5, 54, "Message",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[56713, 2050, 245, 5, 54, "Message",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[56961, 2057, 254, 5, 37, "Message",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[57218, 2064, 184, 5, 21, "Output",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[57417, 2072, 199, 7, 24, "Text",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[57641, 2083, 206, 5, 42, "Input",
      CellTags->"FunctionInterpolation::argdim"],
    Cell[57850, 2090, 184, 5, 21, "Output",
      CellTags->"FunctionInterpolation::argdim"]},
  "FunctionInterpolation::precg"->{
    Cell[58095, 2102, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FunctionInterpolation::precg"],
    Cell[58207, 2105, 417, 9, 37, "Message",
      CellTags->"FunctionInterpolation::precg"],
    Cell[58627, 2116, 265, 7, 40, "Notes",
      CellTags->"FunctionInterpolation::precg"],
    Cell[58917, 2127, 78, 1, 38, "ExampleSection",
      CellTags->"FunctionInterpolation::precg"],
    Cell[58998, 2130, 280, 9, 40, "Text",
      CellTags->"FunctionInterpolation::precg"],
    Cell[59303, 2143, 197, 4, 42, "Input",
      CellTags->"FunctionInterpolation::precg"],
    Cell[59503, 2149, 281, 5, 53, "Message",
      CellTags->"FunctionInterpolation::precg"],
    Cell[59787, 2156, 208, 4, 37, "Output",
      CellTags->"FunctionInterpolation::precg"],
    Cell[60010, 2163, 211, 7, 24, "Text",
      CellTags->"FunctionInterpolation::precg"],
    Cell[60246, 2174, 194, 4, 42, "Input",
      CellTags->"FunctionInterpolation::precg"],
    Cell[60443, 2180, 183, 5, 21, "Output",
      CellTags->"FunctionInterpolation::precg"]},
  "FunctionInterpolation::range"->{
    Cell[60687, 2192, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FunctionInterpolation::range"],
    Cell[60799, 2195, 358, 8, 37, "Message",
      CellTags->"FunctionInterpolation::range"],
    Cell[61160, 2205, 221, 5, 24, "Notes",
      CellTags->"FunctionInterpolation::range"],
    Cell[61406, 2214, 78, 1, 38, "ExampleSection",
      CellTags->"FunctionInterpolation::range"],
    Cell[61487, 2217, 173, 4, 24, "Text",
      CellTags->"FunctionInterpolation::range"],
    Cell[61685, 2225, 135, 3, 26, "Input",
      CellTags->"FunctionInterpolation::range"],
    Cell[61823, 2230, 246, 5, 37, "Message",
      CellTags->"FunctionInterpolation::range"],
    Cell[62072, 2237, 136, 3, 21, "Output",
      CellTags->"FunctionInterpolation::range"],
    Cell[62223, 2243, 179, 5, 24, "Text",
      CellTags->"FunctionInterpolation::range"],
    Cell[62427, 2252, 141, 3, 26, "Input",
      CellTags->"FunctionInterpolation::range"],
    Cell[62571, 2257, 187, 5, 21, "Output",
      CellTags->"FunctionInterpolation::range"]},
  "FunctionInterpolation::accg"->{
    Cell[62819, 2269, 107, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FunctionInterpolation::accg"],
    Cell[62929, 2272, 390, 8, 37, "Message",
      CellTags->"FunctionInterpolation::accg"],
    Cell[63322, 2282, 263, 7, 40, "Notes",
      CellTags->"FunctionInterpolation::accg"],
    Cell[63610, 2293, 77, 1, 38, "ExampleSection",
      CellTags->"FunctionInterpolation::accg"],
    Cell[63690, 2296, 278, 9, 40, "Text",
      CellTags->"FunctionInterpolation::accg"],
    Cell[63993, 2309, 195, 4, 42, "Input",
      CellTags->"FunctionInterpolation::accg"],
    Cell[64191, 2315, 261, 5, 53, "Message",
      CellTags->"FunctionInterpolation::accg"],
    Cell[64455, 2322, 206, 4, 37, "Output",
      CellTags->"FunctionInterpolation::accg"],
    Cell[64676, 2329, 209, 7, 24, "Text",
      CellTags->"FunctionInterpolation::accg"],
    Cell[64910, 2340, 192, 4, 42, "Input",
      CellTags->"FunctionInterpolation::accg"],
    Cell[65105, 2346, 182, 5, 21, "Output",
      CellTags->"FunctionInterpolation::accg"]},
  "FunctionInterpolation::nreal"->{
    Cell[65348, 2358, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FunctionInterpolation::nreal"],
    Cell[65460, 2361, 451, 13, 37, "Message",
      CellTags->"FunctionInterpolation::nreal"],
    Cell[65914, 2376, 237, 5, 40, "Notes",
      CellTags->"FunctionInterpolation::nreal"],
    Cell[66176, 2385, 78, 1, 38, "ExampleSection",
      CellTags->"FunctionInterpolation::nreal"],
    Cell[66257, 2388, 169, 4, 24, "Text",
      CellTags->"FunctionInterpolation::nreal"],
    Cell[66451, 2396, 144, 3, 26, "Input",
      CellTags->"FunctionInterpolation::nreal"],
    Cell[66598, 2401, 187, 5, 21, "Output",
      CellTags->"FunctionInterpolation::nreal"],
    Cell[66800, 2409, 275, 7, 40, "Text",
      CellTags->"FunctionInterpolation::nreal"],
    Cell[67100, 2420, 222, 4, 42, "Input",
      CellTags->"FunctionInterpolation::nreal"],
    Cell[67325, 2426, 438, 12, 37, "Output",
      CellTags->"FunctionInterpolation::nreal"]},
  "FunctionInterpolation::npts"->{
    Cell[67824, 2445, 107, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FunctionInterpolation::npts"],
    Cell[67934, 2448, 316, 6, 37, "Message",
      CellTags->"FunctionInterpolation::npts"],
    Cell[68253, 2456, 269, 7, 40, "Notes",
      CellTags->"FunctionInterpolation::npts"]},
  "FunctionInterpolation::ncvb"->{
    Cell[68559, 2468, 107, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FunctionInterpolation::ncvb"],
    Cell[68669, 2471, 751, 18, 69, "Message",
      CellTags->"FunctionInterpolation::ncvb"],
    Cell[69423, 2491, 790, 16, 132, "Notes",
      CellTags->"FunctionInterpolation::ncvb"],
    Cell[70238, 2511, 77, 1, 38, "ExampleSection",
      CellTags->"FunctionInterpolation::ncvb"],
    Cell[70318, 2514, 203, 5, 40, "Text",
      CellTags->"FunctionInterpolation::ncvb"],
    Cell[70546, 2523, 141, 3, 26, "Input",
      CellTags->"FunctionInterpolation::ncvb"],
    Cell[70690, 2528, 339, 6, 69, "Message",
      CellTags->"FunctionInterpolation::ncvb"],
    Cell[71032, 2536, 346, 6, 69, "Message",
      CellTags->"FunctionInterpolation::ncvb"],
    Cell[71381, 2544, 186, 5, 21, "Output",
      CellTags->"FunctionInterpolation::ncvb"],
    Cell[71582, 2552, 205, 6, 24, "Text",
      CellTags->"FunctionInterpolation::ncvb"],
    Cell[71812, 2562, 162, 4, 26, "Input",
      CellTags->"FunctionInterpolation::ncvb"],
    Cell[71977, 2568, 182, 5, 21, "Output",
      CellTags->"FunctionInterpolation::ncvb"]},
  "Interpolation::inlen"->{
    Cell[72220, 2580, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Interpolation::inlen"],
    Cell[72316, 2583, 234, 5, 37, "Message",
      CellTags->"Interpolation::inlen"],
    Cell[72553, 2590, 131, 4, 24, "Notes",
      CellTags->"Interpolation::inlen"]},
  "NIntegrate::mccnv"->{
    Cell[72721, 2599, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::mccnv"],
    Cell[72811, 2602, 197, 4, 21, "Message",
      CellTags->"NIntegrate::mccnv"],
    Cell[73011, 2608, 366, 9, 62, "Notes",
      CellTags->"NIntegrate::mccnv"],
    Cell[73402, 2621, 67, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::mccnv"],
    Cell[73472, 2624, 261, 6, 40, "Text",
      CellTags->"NIntegrate::mccnv"],
    Cell[73758, 2634, 143, 3, 26, "Input",
      CellTags->"NIntegrate::mccnv"],
    Cell[73904, 2639, 205, 5, 37, "Message",
      CellTags->"NIntegrate::mccnv"],
    Cell[74112, 2646, 111, 3, 21, "Output",
      CellTags->"NIntegrate::mccnv"],
    Cell[74238, 2652, 108, 1, 24, "Text",
      CellTags->"NIntegrate::mccnv"],
    Cell[74371, 2657, 120, 3, 26, "Input",
      CellTags->"NIntegrate::mccnv"],
    Cell[74494, 2662, 104, 3, 23, "Output",
      CellTags->"NIntegrate::mccnv"]},
  "General::precbd"->{
    Cell[74659, 2672, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::precbd"],
    Cell[74745, 2675, 382, 11, 37, "Message",
      CellTags->"General::precbd"],
    Cell[75130, 2688, 386, 9, 62, "Notes",
      CellTags->"General::precbd"],
    Cell[75541, 2701, 65, 1, 38, "ExampleSection",
      CellTags->"General::precbd"],
    Cell[75609, 2704, 259, 9, 40, "Text",
      CellTags->"General::precbd"],
    Cell[75893, 2717, 137, 3, 26, "Input",
      CellTags->"General::precbd"],
    Cell[76033, 2722, 249, 5, 53, "Message",
      CellTags->"General::precbd"],
    Cell[76285, 2729, 157, 4, 23, "Output",
      CellTags->"General::precbd"],
    Cell[76457, 2736, 185, 7, 24, "Text",
      CellTags->"General::precbd"],
    Cell[76667, 2747, 130, 3, 26, "Input",
      CellTags->"General::precbd"],
    Cell[76800, 2752, 214, 4, 21, "Output",
      CellTags->"General::precbd"],
    Cell[77029, 2759, 186, 7, 24, "Text",
      CellTags->"General::precbd"],
    Cell[77240, 2770, 115, 3, 26, "Input",
      CellTags->"General::precbd"],
    Cell[77358, 2775, 112, 3, 21, "Output",
      CellTags->"General::precbd"]},
  "General::preclg"->{
    Cell[77531, 2785, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::preclg"],
    Cell[77617, 2788, 666, 17, 53, "Message",
      CellTags->"General::preclg"],
    Cell[78286, 2807, 894, 19, 138, "Notes",
      CellTags->"General::preclg"],
    Cell[79205, 2830, 65, 1, 38, "ExampleSection",
      CellTags->"General::preclg"],
    Cell[79273, 2833, 268, 7, 40, "Text",
      CellTags->"General::preclg"],
    Cell[79566, 2844, 137, 3, 26, "Input",
      CellTags->"General::preclg"],
    Cell[79706, 2849, 329, 6, 69, "Message",
      CellTags->"General::preclg"],
    Cell[80038, 2857, 134, 3, 21, "Output",
      CellTags->"General::preclg"],
    Cell[80187, 2863, 89, 1, 24, "Text",
      CellTags->"General::preclg"],
    Cell[80301, 2868, 138, 3, 26, "Input",
      CellTags->"General::preclg"],
    Cell[80442, 2873, 165, 4, 21, "Output",
      CellTags->"General::preclg"],
    Cell[80622, 2880, 141, 5, 24, "Text",
      CellTags->"General::preclg"],
    Cell[80788, 2889, 137, 3, 26, "Input",
      CellTags->"General::preclg"],
    Cell[80928, 2894, 328, 6, 69, "Message",
      CellTags->"General::preclg"],
    Cell[81259, 2902, 96, 3, 21, "Output",
      CellTags->"General::preclg"]},
  "General::precsm"->{
    Cell[81416, 2912, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::precsm"],
    Cell[81502, 2915, 446, 12, 37, "Message",
      CellTags->"General::precsm"],
    Cell[81951, 2929, 877, 18, 138, "Notes",
      CellTags->"General::precsm"],
    Cell[82853, 2951, 65, 1, 38, "ExampleSection",
      CellTags->"General::precsm"],
    Cell[82921, 2954, 273, 7, 40, "Text",
      CellTags->"General::precsm"],
    Cell[83219, 2965, 137, 3, 26, "Input",
      CellTags->"General::precsm"],
    Cell[83359, 2970, 233, 5, 37, "Message",
      CellTags->"General::precsm"],
    Cell[83595, 2977, 165, 4, 21, "Output",
      CellTags->"General::precsm"],
    Cell[83775, 2984, 89, 1, 24, "Text",
      CellTags->"General::precsm"],
    Cell[83889, 2989, 137, 3, 26, "Input",
      CellTags->"General::precsm"],
    Cell[84029, 2994, 133, 3, 21, "Output",
      CellTags->"General::precsm"],
    Cell[84177, 3000, 141, 5, 24, "Text",
      CellTags->"General::precsm"],
    Cell[84343, 3009, 136, 3, 26, "Input",
      CellTags->"General::precsm"],
    Cell[84482, 3014, 232, 5, 37, "Message",
      CellTags->"General::precsm"],
    Cell[84717, 3021, 150, 4, 21, "Output",
      CellTags->"General::precsm"]},
  "$MaxPrecision::prec"->{
    Cell[84928, 3032, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$MaxPrecision::prec"],
    Cell[85022, 3035, 302, 5, 69, "Message",
      CellTags->"$MaxPrecision::prec"],
    Cell[85327, 3042, 210, 6, 24, "Notes",
      CellTags->"$MaxPrecision::prec"],
    Cell[85562, 3052, 69, 1, 38, "ExampleSection",
      CellTags->"$MaxPrecision::prec"],
    Cell[85634, 3055, 221, 6, 40, "Text",
      CellTags->"$MaxPrecision::prec"],
    Cell[85880, 3065, 135, 3, 26, "Input",
      CellTags->"$MaxPrecision::prec"],
    Cell[86018, 3070, 362, 7, 71, "Message",
      CellTags->"$MaxPrecision::prec"],
    Cell[86383, 3079, 160, 4, 23, "Output",
      CellTags->"$MaxPrecision::prec"],
    Cell[86558, 3086, 161, 5, 24, "Text",
      CellTags->"$MaxPrecision::prec"],
    Cell[86744, 3095, 135, 3, 26, "Input",
      CellTags->"$MaxPrecision::prec"],
    Cell[86882, 3100, 143, 3, 23, "Output",
      CellTags->"$MaxPrecision::prec"]},
  "IntegerDigits::ibase"->{
    Cell[87086, 3110, 152, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[87241, 3116, 383, 11, 21, "Message",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[87627, 3129, 281, 7, 40, "Notes",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[87933, 3140, 98, 1, 38, "ExampleSection",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[88034, 3143, 168, 4, 24, "Text",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[88227, 3151, 143, 3, 26, "Input",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[88373, 3156, 225, 4, 21, "Message",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[88601, 3162, 145, 3, 21, "Output",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[88761, 3168, 168, 5, 24, "Text",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[88954, 3177, 141, 3, 26, "Input",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[89098, 3182, 140, 3, 21, "Output",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[89253, 3188, 194, 5, 24, "Text",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[89472, 3197, 142, 3, 26, "Input",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[89617, 3202, 432, 7, 69, "Output",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[90064, 3212, 235, 6, 24, "Text",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[90324, 3222, 148, 3, 26, "Input",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[90475, 3227, 224, 4, 21, "Message",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[90702, 3233, 175, 3, 21, "Output",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[90892, 3239, 170, 5, 24, "Text",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[91087, 3248, 148, 3, 26, "Input",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[91238, 3253, 123, 3, 21, "Output",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}]},
  "IntegerExponent::ibase"->{
    Cell[87086, 3110, 152, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[87241, 3116, 383, 11, 21, "Message",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[87627, 3129, 281, 7, 40, "Notes",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[87933, 3140, 98, 1, 38, "ExampleSection",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[88034, 3143, 168, 4, 24, "Text",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[88227, 3151, 143, 3, 26, "Input",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[88373, 3156, 225, 4, 21, "Message",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[88601, 3162, 145, 3, 21, "Output",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[88761, 3168, 168, 5, 24, "Text",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[88954, 3177, 141, 3, 26, "Input",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[89098, 3182, 140, 3, 21, "Output",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[89253, 3188, 194, 5, 24, "Text",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[89472, 3197, 142, 3, 26, "Input",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[89617, 3202, 432, 7, 69, "Output",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[90064, 3212, 235, 6, 24, "Text",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[90324, 3222, 148, 3, 26, "Input",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[90475, 3227, 224, 4, 21, "Message",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[90702, 3233, 175, 3, 21, "Output",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[90892, 3239, 170, 5, 24, "Text",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[91087, 3248, 148, 3, 26, "Input",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
    Cell[91238, 3253, 123, 3, 21, "Output",
      CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}]},
  "InterpolatingFunction::dmval"->{
    Cell[91422, 3263, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[91534, 3266, 358, 7, 37, "Message",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[91895, 3275, 377, 7, 62, "Notes",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[92297, 3286, 78, 1, 38, "ExampleSection",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[92378, 3289, 261, 5, 40, "Text",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[92664, 3298, 172, 4, 26, "Input",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[92839, 3304, 187, 5, 21, "Output",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[93063, 3314, 111, 3, 26, "Input",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[93177, 3319, 278, 5, 53, "Message",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[93458, 3326, 109, 3, 21, "Output",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[93582, 3332, 218, 5, 40, "Text",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[93825, 3341, 110, 3, 26, "Input",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[93938, 3346, 120, 3, 21, "Output",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[94073, 3352, 130, 5, 24, "Text",
      CellTags->"InterpolatingFunction::dmval"],
    Cell[94206, 3359, 114, 3, 26, "Input",
      CellTags->"InterpolatingFunction::dmval"]},
  "InterpolatingFunction::dmvali"->{
    Cell[94369, 3368, 111, 1, 31, "ObjectNameWarningMessages",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[94483, 3371, 589, 12, 53, "Message",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[95075, 3385, 453, 8, 78, "Notes",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[95553, 3397, 79, 1, 38, "ExampleSection",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[95635, 3400, 230, 5, 40, "Text",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[95890, 3409, 152, 3, 26, "Input",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[96045, 3414, 203, 5, 21, "Output",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[96285, 3424, 137, 3, 26, "Input",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[96425, 3429, 321, 6, 53, "Message",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[96749, 3437, 122, 3, 21, "Output",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[96886, 3443, 150, 4, 24, "Text",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[97061, 3451, 155, 3, 26, "Input",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[97219, 3456, 203, 5, 21, "Output",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[97459, 3466, 137, 3, 26, "Input",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[97599, 3471, 127, 3, 23, "Output",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[97741, 3477, 131, 5, 24, "Text",
      CellTags->"InterpolatingFunction::dmvali"],
    Cell[97875, 3484, 115, 3, 26, "Input",
      CellTags->"InterpolatingFunction::dmvali"]},
  "InterpolatingFunction::dprec"->{
    Cell[98039, 3493, 109, 1, 31, "ObjectNameWarningMessages",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[98151, 3496, 420, 9, 37, "Message",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[98574, 3507, 522, 11, 84, "Notes",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[99121, 3522, 78, 1, 38, "ExampleSection",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[99202, 3525, 318, 7, 40, "Text",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[99545, 3536, 193, 5, 42, "Input",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[99741, 3543, 195, 5, 37, "Output",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[99973, 3553, 112, 3, 26, "Input",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[100088, 3558, 274, 5, 53, "Message",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[100365, 3565, 233, 6, 53, "Output",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[100613, 3574, 196, 5, 40, "Text",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[100834, 3583, 125, 3, 26, "Input",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[100962, 3588, 141, 3, 21, "Output",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[101140, 3596, 141, 3, 26, "Input",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[101284, 3601, 142, 3, 21, "Output",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[101441, 3607, 130, 5, 24, "Text",
      CellTags->"InterpolatingFunction::dprec"],
    Cell[101574, 3614, 114, 3, 26, "Input",
      CellTags->"InterpolatingFunction::dprec"]},
  "Interpolation::inauto"->{
    Cell[101737, 3623, 160, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[101900, 3629, 428, 11, 37, "Message",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[102331, 3642, 354, 10, 40, "Notes",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[102710, 3656, 102, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[102815, 3659, 217, 5, 24, "Text",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[103057, 3668, 151, 3, 26, "Input",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[103211, 3673, 287, 5, 53, "Message",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[103501, 3680, 152, 3, 21, "Output",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[103668, 3686, 173, 5, 24, "Text",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[103866, 3695, 172, 3, 26, "Input",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[104041, 3700, 207, 5, 21, "Output",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}]},
  "ListInterpolation::inauto"->{
    Cell[101737, 3623, 160, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[101900, 3629, 428, 11, 37, "Message",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[102331, 3642, 354, 10, 40, "Notes",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[102710, 3656, 102, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[102815, 3659, 217, 5, 24, "Text",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[103057, 3668, 151, 3, 26, "Input",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[103211, 3673, 287, 5, 53, "Message",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[103501, 3680, 152, 3, 21, "Output",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[103668, 3686, 173, 5, 24, "Text",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[103866, 3695, 172, 3, 26, "Input",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
    Cell[104041, 3700, 207, 5, 21, "Output",
      CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}]},
  "Interpolation::incon"->{
    Cell[104309, 3712, 225, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[104537, 3721, 507, 13, 37, "Message",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[105047, 3736, 389, 8, 46, "Notes",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[105461, 3748, 140, 3, 38, "ExampleSection",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[105604, 3753, 226, 6, 24, "Text",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[105855, 3763, 456, 9, 90, "Input",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[106314, 3774, 303, 7, 37, "Message",
      CellTags->{
      "InterpolatingFunction::incon", "Interpolation::incon", 
        "ListInterpolation::incon"}],
    Cell[106620, 3783, 428, 8, 53, "Output",
      CellTags->{
      "InterpolatingFunction::incon", "Interpolation::incon", 
        "ListInterpolation::incon"}],
    Cell[107063, 3794, 260, 7, 24, "Text",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[107348, 3805, 245, 6, 26, "Input",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[107596, 3813, 545, 10, 101, "Output",
      CellTags->{
      "InterpolatingFunction::incon", "Interpolation::incon", 
        "ListInterpolation::incon"}],
    Cell[108178, 3828, 188, 5, 26, "Input",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[108369, 3835, 253, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::incon", "Interpolation::incon", 
        "ListInterpolation::incon"}],
    Cell[108637, 3845, 196, 7, 24, "Text",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[108836, 3854, 180, 5, 26, "Input",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}]},
  "ListInterpolation::incon"->{
    Cell[104309, 3712, 225, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[104537, 3721, 507, 13, 37, "Message",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[105047, 3736, 389, 8, 46, "Notes",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[105461, 3748, 140, 3, 38, "ExampleSection",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[105604, 3753, 226, 6, 24, "Text",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[105855, 3763, 456, 9, 90, "Input",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[106314, 3774, 303, 7, 37, "Message",
      CellTags->{
      "InterpolatingFunction::incon", "Interpolation::incon", 
        "ListInterpolation::incon"}],
    Cell[106620, 3783, 428, 8, 53, "Output",
      CellTags->{
      "InterpolatingFunction::incon", "Interpolation::incon", 
        "ListInterpolation::incon"}],
    Cell[107063, 3794, 260, 7, 24, "Text",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[107348, 3805, 245, 6, 26, "Input",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[107596, 3813, 545, 10, 101, "Output",
      CellTags->{
      "InterpolatingFunction::incon", "Interpolation::incon", 
        "ListInterpolation::incon"}],
    Cell[108178, 3828, 188, 5, 26, "Input",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[108369, 3835, 253, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::incon", "Interpolation::incon", 
        "ListInterpolation::incon"}],
    Cell[108637, 3845, 196, 7, 24, "Text",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[108836, 3854, 180, 5, 26, "Input",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}]},
  "InterpolatingFunction::incon"->{
    Cell[104309, 3712, 225, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[104537, 3721, 507, 13, 37, "Message",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[105047, 3736, 389, 8, 46, "Notes",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[105461, 3748, 140, 3, 38, "ExampleSection",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[105604, 3753, 226, 6, 24, "Text",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[105855, 3763, 456, 9, 90, "Input",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[106314, 3774, 303, 7, 37, "Message",
      CellTags->{
      "InterpolatingFunction::incon", "Interpolation::incon", 
        "ListInterpolation::incon"}],
    Cell[106620, 3783, 428, 8, 53, "Output",
      CellTags->{
      "InterpolatingFunction::incon", "Interpolation::incon", 
        "ListInterpolation::incon"}],
    Cell[107063, 3794, 260, 7, 24, "Text",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[107348, 3805, 245, 6, 26, "Input",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[107596, 3813, 545, 10, 101, "Output",
      CellTags->{
      "InterpolatingFunction::incon", "Interpolation::incon", 
        "ListInterpolation::incon"}],
    Cell[108178, 3828, 188, 5, 26, "Input",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[108369, 3835, 253, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::incon", "Interpolation::incon", 
        "ListInterpolation::incon"}],
    Cell[108637, 3845, 196, 7, 24, "Text",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}],
    Cell[108836, 3854, 180, 5, 26, "Input",
      CellTags->{
      "Interpolation::incon", "ListInterpolation::incon", 
        "InterpolatingFunction::incon"}]},
  "Interpolation::indat"->{
    Cell[109065, 3865, 156, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[109224, 3871, 502, 13, 21, "Message",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[109729, 3886, 227, 5, 24, "Notes",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[109981, 3895, 100, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[110084, 3898, 179, 4, 24, "Text",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[110288, 3906, 174, 3, 26, "Input",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[110465, 3911, 259, 5, 37, "Message",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[110727, 3918, 175, 3, 21, "Output",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[110917, 3924, 166, 5, 24, "Text",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[111108, 3933, 174, 3, 26, "Input",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[111285, 3938, 205, 5, 21, "Output",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[111505, 3946, 183, 4, 24, "Text",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[111713, 3954, 194, 4, 26, "Input",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[111910, 3960, 503, 9, 175, "Output",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}]},
  "ListInterpolation::indat"->{
    Cell[109065, 3865, 156, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[109224, 3871, 502, 13, 21, "Message",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[109729, 3886, 227, 5, 24, "Notes",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[109981, 3895, 100, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[110084, 3898, 179, 4, 24, "Text",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[110288, 3906, 174, 3, 26, "Input",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[110465, 3911, 259, 5, 37, "Message",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[110727, 3918, 175, 3, 21, "Output",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[110917, 3924, 166, 5, 24, "Text",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[111108, 3933, 174, 3, 26, "Input",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[111285, 3938, 205, 5, 21, "Output",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[111505, 3946, 183, 4, 24, "Text",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[111713, 3954, 194, 4, 26, "Input",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
    Cell[111910, 3960, 503, 9, 175, "Output",
      CellTags->{"Interpolation::indat", "ListInterpolation::indat"}]},
  "Interpolation::indatg"->{
    Cell[112474, 3976, 160, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[112637, 3982, 488, 13, 21, "Message",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[113128, 3997, 212, 4, 24, "Notes",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[113365, 4005, 102, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[113470, 4008, 192, 4, 24, "Text",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[113687, 4016, 199, 4, 26, "Input",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[113889, 4022, 251, 5, 37, "Message",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[114143, 4029, 200, 4, 21, "Output",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[114358, 4036, 202, 5, 24, "Text",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[114585, 4045, 186, 4, 26, "Input",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[114774, 4051, 207, 5, 21, "Output",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}]},
  "ListInterpolation::indatg"->{
    Cell[112474, 3976, 160, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[112637, 3982, 488, 13, 21, "Message",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[113128, 3997, 212, 4, 24, "Notes",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[113365, 4005, 102, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[113470, 4008, 192, 4, 24, "Text",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[113687, 4016, 199, 4, 26, "Input",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[113889, 4022, 251, 5, 37, "Message",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[114143, 4029, 200, 4, 21, "Output",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[114358, 4036, 202, 5, 24, "Text",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[114585, 4045, 186, 4, 26, "Input",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
    Cell[114774, 4051, 207, 5, 21, "Output",
      CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}]},
  "Interpolation::inddp"->{
    Cell[115042, 4063, 156, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[115201, 4069, 444, 12, 21, "Message",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[115648, 4083, 204, 4, 24, "Notes",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[115877, 4091, 100, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[115980, 4094, 259, 6, 40, "Text",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[116264, 4104, 184, 4, 26, "Input",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[116451, 4110, 235, 4, 21, "Message",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[116689, 4116, 185, 4, 21, "Output",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[116889, 4123, 195, 5, 24, "Text",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[117109, 4132, 184, 4, 26, "Input",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[117296, 4138, 205, 5, 21, "Output",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}]},
  "ListInterpolation::inddp"->{
    Cell[115042, 4063, 156, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[115201, 4069, 444, 12, 21, "Message",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[115648, 4083, 204, 4, 24, "Notes",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[115877, 4091, 100, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[115980, 4094, 259, 6, 40, "Text",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[116264, 4104, 184, 4, 26, "Input",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[116451, 4110, 235, 4, 21, "Message",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[116689, 4116, 185, 4, 21, "Output",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[116889, 4123, 195, 5, 24, "Text",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[117109, 4132, 184, 4, 26, "Input",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
    Cell[117296, 4138, 205, 5, 21, "Output",
      CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}]},
  "Interpolation::indep"->{
    Cell[117562, 4150, 225, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[117790, 4159, 649, 18, 37, "Message",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[118442, 4179, 332, 9, 40, "Notes",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[118799, 4192, 140, 3, 38, "ExampleSection",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[118942, 4197, 285, 7, 40, "Text",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[119252, 4208, 271, 6, 42, "Input",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[119526, 4216, 339, 7, 53, "Message",
      CellTags->{
      "InterpolatingFunction::indep", "Interpolation::indep", 
        "ListInterpolation::indep"}],
    Cell[119868, 4225, 272, 6, 37, "Output",
      CellTags->{
      "InterpolatingFunction::indep", "Interpolation::indep", 
        "ListInterpolation::indep"}],
    Cell[120155, 4234, 231, 7, 24, "Text",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[120411, 4245, 271, 6, 42, "Input",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[120685, 4253, 245, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::indep", "Interpolation::indep", 
        "ListInterpolation::indep"}]},
  "ListInterpolation::indep"->{
    Cell[117562, 4150, 225, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[117790, 4159, 649, 18, 37, "Message",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[118442, 4179, 332, 9, 40, "Notes",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[118799, 4192, 140, 3, 38, "ExampleSection",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[118942, 4197, 285, 7, 40, "Text",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[119252, 4208, 271, 6, 42, "Input",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[119526, 4216, 339, 7, 53, "Message",
      CellTags->{
      "InterpolatingFunction::indep", "Interpolation::indep", 
        "ListInterpolation::indep"}],
    Cell[119868, 4225, 272, 6, 37, "Output",
      CellTags->{
      "InterpolatingFunction::indep", "Interpolation::indep", 
        "ListInterpolation::indep"}],
    Cell[120155, 4234, 231, 7, 24, "Text",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[120411, 4245, 271, 6, 42, "Input",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[120685, 4253, 245, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::indep", "Interpolation::indep", 
        "ListInterpolation::indep"}]},
  "InterpolatingFunction::indep"->{
    Cell[117562, 4150, 225, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[117790, 4159, 649, 18, 37, "Message",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[118442, 4179, 332, 9, 40, "Notes",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[118799, 4192, 140, 3, 38, "ExampleSection",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[118942, 4197, 285, 7, 40, "Text",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[119252, 4208, 271, 6, 42, "Input",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[119526, 4216, 339, 7, 53, "Message",
      CellTags->{
      "InterpolatingFunction::indep", "Interpolation::indep", 
        "ListInterpolation::indep"}],
    Cell[119868, 4225, 272, 6, 37, "Output",
      CellTags->{
      "InterpolatingFunction::indep", "Interpolation::indep", 
        "ListInterpolation::indep"}],
    Cell[120155, 4234, 231, 7, 24, "Text",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[120411, 4245, 271, 6, 42, "Input",
      CellTags->{
      "Interpolation::indep", "ListInterpolation::indep", 
        "InterpolatingFunction::indep"}],
    Cell[120685, 4253, 245, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::indep", "Interpolation::indep", 
        "ListInterpolation::indep"}]},
  "Interpolation::inder"->{
    Cell[120991, 4267, 156, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[121150, 4273, 654, 18, 37, "Message",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[121807, 4293, 188, 4, 24, "Notes",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[122020, 4301, 100, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[122123, 4304, 187, 4, 24, "Text",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[122335, 4312, 167, 3, 26, "Input",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[122505, 4317, 209, 4, 21, "Output",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[122751, 4326, 148, 3, 26, "Input",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[122902, 4331, 281, 5, 37, "Message",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[123186, 4338, 226, 4, 37, "Output",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[123427, 4345, 223, 5, 24, "Text",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[123675, 4354, 165, 3, 26, "Input",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[123843, 4359, 199, 4, 21, "Output",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[124079, 4368, 148, 3, 26, "Input",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[124230, 4373, 205, 5, 21, "Output",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[124450, 4381, 156, 5, 24, "Text",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[124609, 4388, 140, 3, 26, "Input",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}]},
  "ListInterpolation::inder"->{
    Cell[120991, 4267, 156, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[121150, 4273, 654, 18, 37, "Message",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[121807, 4293, 188, 4, 24, "Notes",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[122020, 4301, 100, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[122123, 4304, 187, 4, 24, "Text",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[122335, 4312, 167, 3, 26, "Input",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[122505, 4317, 209, 4, 21, "Output",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[122751, 4326, 148, 3, 26, "Input",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[122902, 4331, 281, 5, 37, "Message",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[123186, 4338, 226, 4, 37, "Output",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[123427, 4345, 223, 5, 24, "Text",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[123675, 4354, 165, 3, 26, "Input",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[123843, 4359, 199, 4, 21, "Output",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[124079, 4368, 148, 3, 26, "Input",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[124230, 4373, 205, 5, 21, "Output",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[124450, 4381, 156, 5, 24, "Text",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
    Cell[124609, 4388, 140, 3, 26, "Input",
      CellTags->{"Interpolation::inder", "ListInterpolation::inder"}]},
  "Interpolation::indim"->{
    Cell[124798, 4397, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Interpolation::indim"],
    Cell[124894, 4400, 482, 11, 37, "Message",
      CellTags->"Interpolation::indim"],
    Cell[125379, 4413, 646, 12, 122, "Notes",
      CellTags->"Interpolation::indim"],
    Cell[126050, 4429, 70, 1, 38, "ExampleSection",
      CellTags->"Interpolation::indim"],
    Cell[126123, 4432, 187, 4, 40, "Text",
      CellTags->"Interpolation::indim"],
    Cell[126335, 4440, 405, 7, 90, "Input",
      CellTags->"Interpolation::indim"],
    Cell[126743, 4449, 271, 5, 53, "Message",
      CellTags->"Interpolation::indim"],
    Cell[127017, 4456, 371, 6, 69, "Output",
      CellTags->"Interpolation::indim"],
    Cell[127403, 4465, 92, 1, 24, "Text",
      CellTags->"Interpolation::indim"],
    Cell[127520, 4470, 405, 7, 90, "Input",
      CellTags->"Interpolation::indim"],
    Cell[127928, 4479, 184, 5, 21, "Output",
      CellTags->"Interpolation::indim"]},
  "Interpolation::indimt"->{
    Cell[128173, 4491, 160, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::indimt", "ListInterpolation::indimt"}],
    Cell[128336, 4497, 435, 11, 53, "Message",
      CellTags->{"Interpolation::indimt", "ListInterpolation::indimt"}],
    Cell[128774, 4510, 232, 6, 24, "Notes",
      CellTags->{"Interpolation::indimt", "ListInterpolation::indimt"}]},
  "ListInterpolation::indimt"->{
    Cell[128173, 4491, 160, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::indimt", "ListInterpolation::indimt"}],
    Cell[128336, 4497, 435, 11, 53, "Message",
      CellTags->{"Interpolation::indimt", "ListInterpolation::indimt"}],
    Cell[128774, 4510, 232, 6, 24, "Notes",
      CellTags->{"Interpolation::indimt", "ListInterpolation::indimt"}]},
  "Interpolation::inhr"->{
    Cell[129043, 4521, 219, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[129265, 4530, 529, 15, 21, "Message",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[129797, 4547, 780, 20, 106, "Notes",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[130602, 4571, 137, 3, 38, "ExampleSection",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[130742, 4576, 305, 8, 40, "Text",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[131072, 4588, 199, 5, 26, "Input",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[131274, 4595, 281, 7, 37, "Message",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[131558, 4604, 242, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[131815, 4614, 283, 9, 24, "Text",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[132123, 4627, 231, 6, 26, "Input",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[132357, 4635, 242, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[132614, 4645, 349, 8, 40, "Text",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[132988, 4657, 211, 5, 26, "Input",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[133202, 4664, 288, 7, 37, "Message",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[133493, 4673, 250, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[133758, 4683, 291, 8, 40, "Text",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[134074, 4695, 207, 5, 26, "Input",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[134284, 4702, 242, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}]},
  "ListInterpolation::inhr"->{
    Cell[129043, 4521, 219, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[129265, 4530, 529, 15, 21, "Message",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[129797, 4547, 780, 20, 106, "Notes",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[130602, 4571, 137, 3, 38, "ExampleSection",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[130742, 4576, 305, 8, 40, "Text",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[131072, 4588, 199, 5, 26, "Input",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[131274, 4595, 281, 7, 37, "Message",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[131558, 4604, 242, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[131815, 4614, 283, 9, 24, "Text",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[132123, 4627, 231, 6, 26, "Input",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[132357, 4635, 242, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[132614, 4645, 349, 8, 40, "Text",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[132988, 4657, 211, 5, 26, "Input",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[133202, 4664, 288, 7, 37, "Message",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[133493, 4673, 250, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[133758, 4683, 291, 8, 40, "Text",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[134074, 4695, 207, 5, 26, "Input",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[134284, 4702, 242, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}]},
  "InterpolatingFunction::inhr"->{
    Cell[129043, 4521, 219, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[129265, 4530, 529, 15, 21, "Message",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[129797, 4547, 780, 20, 106, "Notes",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[130602, 4571, 137, 3, 38, "ExampleSection",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[130742, 4576, 305, 8, 40, "Text",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[131072, 4588, 199, 5, 26, "Input",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[131274, 4595, 281, 7, 37, "Message",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[131558, 4604, 242, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[131815, 4614, 283, 9, 24, "Text",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[132123, 4627, 231, 6, 26, "Input",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[132357, 4635, 242, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[132614, 4645, 349, 8, 40, "Text",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[132988, 4657, 211, 5, 26, "Input",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[133202, 4664, 288, 7, 37, "Message",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[133493, 4673, 250, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}],
    Cell[133758, 4683, 291, 8, 40, "Text",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[134074, 4695, 207, 5, 26, "Input",
      CellTags->{
      "Interpolation::inhr", "ListInterpolation::inhr", 
        "InterpolatingFunction::inhr"}],
    Cell[134284, 4702, 242, 7, 21, "Output",
      CellTags->{
      "InterpolatingFunction::inhr", "Interpolation::inhr", 
        "ListInterpolation::inhr"}]},
  "Interpolation::innd"->{
    Cell[134587, 4716, 152, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[134742, 4722, 491, 12, 37, "Message",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[135236, 4736, 211, 4, 24, "Notes",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[135472, 4744, 98, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[135573, 4747, 171, 4, 24, "Text",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[135769, 4755, 142, 3, 26, "Input",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[135914, 4760, 256, 5, 37, "Message",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[136173, 4767, 143, 3, 21, "Output",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}]},
  "ListInterpolation::innd"->{
    Cell[134587, 4716, 152, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[134742, 4722, 491, 12, 37, "Message",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[135236, 4736, 211, 4, 24, "Notes",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[135472, 4744, 98, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[135573, 4747, 171, 4, 24, "Text",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[135769, 4755, 142, 3, 26, "Input",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[135914, 4760, 256, 5, 37, "Message",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
    Cell[136173, 4767, 143, 3, 21, "Output",
      CellTags->{"Interpolation::innd", "ListInterpolation::innd"}]},
  "Interpolation::inord"->{
    Cell[136377, 4777, 225, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[136605, 4786, 832, 24, 53, "Message",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[137440, 4812, 279, 7, 24, "Notes",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[137744, 4823, 140, 3, 38, "ExampleSection",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[137887, 4828, 294, 9, 24, "Text",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[138206, 4841, 231, 6, 26, "Input",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[138440, 4849, 401, 8, 69, "Message",
      CellTags->{
      "FunctionInterpolation::inord", "Interpolation::inord", 
        "ListInterpolation::inord"}],
    Cell[138844, 4859, 237, 6, 21, "Output",
      CellTags->{
      "FunctionInterpolation::inord", "Interpolation::inord", 
        "ListInterpolation::inord"}],
    Cell[139096, 4868, 225, 7, 24, "Text",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[139346, 4879, 221, 5, 26, "Input",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[139570, 4886, 245, 7, 21, "Output",
      CellTags->{
      "FunctionInterpolation::inord", "Interpolation::inord", 
        "ListInterpolation::inord"}]},
  "ListInterpolation::inord"->{
    Cell[136377, 4777, 225, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[136605, 4786, 832, 24, 53, "Message",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[137440, 4812, 279, 7, 24, "Notes",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[137744, 4823, 140, 3, 38, "ExampleSection",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[137887, 4828, 294, 9, 24, "Text",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[138206, 4841, 231, 6, 26, "Input",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[138440, 4849, 401, 8, 69, "Message",
      CellTags->{
      "FunctionInterpolation::inord", "Interpolation::inord", 
        "ListInterpolation::inord"}],
    Cell[138844, 4859, 237, 6, 21, "Output",
      CellTags->{
      "FunctionInterpolation::inord", "Interpolation::inord", 
        "ListInterpolation::inord"}],
    Cell[139096, 4868, 225, 7, 24, "Text",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[139346, 4879, 221, 5, 26, "Input",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[139570, 4886, 245, 7, 21, "Output",
      CellTags->{
      "FunctionInterpolation::inord", "Interpolation::inord", 
        "ListInterpolation::inord"}]},
  "FunctionInterpolation::inord"->{
    Cell[136377, 4777, 225, 7, 71, "ObjectNameWarningMessages",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[136605, 4786, 832, 24, 53, "Message",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[137440, 4812, 279, 7, 24, "Notes",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[137744, 4823, 140, 3, 38, "ExampleSection",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[137887, 4828, 294, 9, 24, "Text",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[138206, 4841, 231, 6, 26, "Input",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[138440, 4849, 401, 8, 69, "Message",
      CellTags->{
      "FunctionInterpolation::inord", "Interpolation::inord", 
        "ListInterpolation::inord"}],
    Cell[138844, 4859, 237, 6, 21, "Output",
      CellTags->{
      "FunctionInterpolation::inord", "Interpolation::inord", 
        "ListInterpolation::inord"}],
    Cell[139096, 4868, 225, 7, 24, "Text",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[139346, 4879, 221, 5, 26, "Input",
      CellTags->{
      "Interpolation::inord", "ListInterpolation::inord", 
        "FunctionInterpolation::inord"}],
    Cell[139570, 4886, 245, 7, 21, "Output",
      CellTags->{
      "FunctionInterpolation::inord", "Interpolation::inord", 
        "ListInterpolation::inord"}]},
  "Interpolation::inpts"->{
    Cell[139876, 4900, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Interpolation::inpts"],
    Cell[139972, 4903, 557, 13, 37, "Message",
      CellTags->"Interpolation::inpts"],
    Cell[140532, 4918, 153, 4, 24, "Notes",
      CellTags->"Interpolation::inpts"],
    Cell[140710, 4926, 70, 1, 38, "ExampleSection",
      CellTags->"Interpolation::inpts"],
    Cell[140783, 4929, 186, 4, 40, "Text",
      CellTags->"Interpolation::inpts"],
    Cell[140994, 4937, 330, 6, 90, "Input",
      CellTags->"Interpolation::inpts"],
    Cell[141327, 4945, 262, 5, 53, "Message",
      CellTags->"Interpolation::inpts"],
    Cell[141592, 4952, 296, 5, 53, "Output",
      CellTags->"Interpolation::inpts"],
    Cell[141903, 4960, 146, 5, 24, "Text",
      CellTags->"Interpolation::inpts"],
    Cell[142074, 4969, 341, 6, 90, "Input",
      CellTags->"Interpolation::inpts"],
    Cell[142418, 4977, 183, 5, 21, "Output",
      CellTags->"Interpolation::inpts"]},
  "Interpolation::mixedp"->{
    Cell[142662, 4989, 160, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[142825, 4995, 654, 17, 37, "Message",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[143482, 5014, 210, 4, 24, "Notes",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[143717, 5022, 102, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[143822, 5025, 210, 4, 40, "Text",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[144057, 5033, 234, 5, 42, "Input",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[144294, 5040, 549, 11, 85, "Output",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[144880, 5056, 150, 3, 26, "Input",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[145033, 5061, 352, 6, 53, "Message",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[145388, 5069, 352, 6, 53, "Message",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[145743, 5077, 352, 6, 53, "Message",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[146098, 5085, 270, 5, 37, "Message",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[146371, 5092, 215, 5, 21, "Output",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[146601, 5100, 174, 4, 24, "Text",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[146800, 5108, 234, 5, 42, "Input",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[147037, 5115, 549, 11, 85, "Output",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[147623, 5131, 150, 3, 26, "Input",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[147776, 5136, 215, 5, 21, "Output",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[148006, 5144, 158, 5, 24, "Text",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[148167, 5151, 142, 3, 26, "Input",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}]},
  "ListInterpolation::mixedp"->{
    Cell[142662, 4989, 160, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[142825, 4995, 654, 17, 37, "Message",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[143482, 5014, 210, 4, 24, "Notes",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[143717, 5022, 102, 1, 38, "ExampleSection",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[143822, 5025, 210, 4, 40, "Text",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[144057, 5033, 234, 5, 42, "Input",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[144294, 5040, 549, 11, 85, "Output",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[144880, 5056, 150, 3, 26, "Input",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[145033, 5061, 352, 6, 53, "Message",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[145388, 5069, 352, 6, 53, "Message",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[145743, 5077, 352, 6, 53, "Message",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[146098, 5085, 270, 5, 37, "Message",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[146371, 5092, 215, 5, 21, "Output",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[146601, 5100, 174, 4, 24, "Text",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[146800, 5108, 234, 5, 42, "Input",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[147037, 5115, 549, 11, 85, "Output",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[147623, 5131, 150, 3, 26, "Input",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[147776, 5136, 215, 5, 21, "Output",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[148006, 5144, 158, 5, 24, "Text",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
    Cell[148167, 5151, 142, 3, 26, "Input",
      CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}]},
  "Interval::nvld"->{
    Cell[148358, 5160, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Interval::nvld"],
    Cell[148442, 5163, 253, 6, 21, "Message",
      CellTags->"Interval::nvld"],
    Cell[148698, 5171, 321, 9, 46, "Notes",
      CellTags->"Interval::nvld"]},
  "RealDigits::realx"->{
    Cell[149056, 5185, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[149207, 5191, 408, 11, 21, "Message",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[149618, 5204, 191, 4, 24, "Notes",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[149834, 5212, 96, 1, 38, "ExampleSection",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[149933, 5215, 168, 4, 24, "Text",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[150126, 5223, 139, 3, 26, "Input",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[150268, 5228, 233, 5, 21, "Message",
      CellTags->{"MantissaExponent::realx", "RealDigits::realx"}],
    Cell[150504, 5235, 153, 3, 21, "Output",
      CellTags->{"MantissaExponent::realx", "RealDigits::realx"}],
    Cell[150672, 5241, 164, 5, 24, "Text",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[150861, 5250, 141, 3, 26, "Input",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[151005, 5255, 174, 3, 21, "Output",
      CellTags->{"MantissaExponent::realx", "RealDigits::realx"}]},
  "MantissaExponent::realx"->{
    Cell[149056, 5185, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[149207, 5191, 408, 11, 21, "Message",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[149618, 5204, 191, 4, 24, "Notes",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[149834, 5212, 96, 1, 38, "ExampleSection",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[149933, 5215, 168, 4, 24, "Text",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[150126, 5223, 139, 3, 26, "Input",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[150268, 5228, 233, 5, 21, "Message",
      CellTags->{"MantissaExponent::realx", "RealDigits::realx"}],
    Cell[150504, 5235, 153, 3, 21, "Output",
      CellTags->{"MantissaExponent::realx", "RealDigits::realx"}],
    Cell[150672, 5241, 164, 5, 24, "Text",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[150861, 5250, 141, 3, 26, "Input",
      CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
    Cell[151005, 5255, 174, 3, 21, "Output",
      CellTags->{"MantissaExponent::realx", "RealDigits::realx"}]},
  "NumericalMath`$NumberBits::realx"->{
    Cell[151240, 5265, 117, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NumericalMath`$NumberBits::realx"],
    Cell[151360, 5268, 351, 8, 21, "Message",
      CellTags->"NumericalMath`$NumberBits::realx"],
    Cell[151714, 5278, 226, 5, 24, "Notes",
      CellTags->"NumericalMath`$NumberBits::realx"],
    Cell[151965, 5287, 82, 1, 38, "ExampleSection",
      CellTags->"NumericalMath`$NumberBits::realx"],
    Cell[152050, 5290, 153, 4, 24, "Text",
      CellTags->"NumericalMath`$NumberBits::realx"],
    Cell[152228, 5298, 144, 3, 26, "Input",
      CellTags->"NumericalMath`$NumberBits::realx"],
    Cell[152375, 5303, 271, 5, 37, "Message",
      CellTags->"NumericalMath`$NumberBits::realx"],
    Cell[152649, 5310, 197, 4, 21, "Output",
      CellTags->"NumericalMath`$NumberBits::realx"],
    Cell[152861, 5317, 164, 5, 24, "Text",
      CellTags->"NumericalMath`$NumberBits::realx"],
    Cell[153050, 5326, 148, 3, 26, "Input",
      CellTags->"NumericalMath`$NumberBits::realx"],
    Cell[153201, 5331, 259, 5, 53, "Message",
      CellTags->"NumericalMath`$NumberBits::realx"],
    Cell[153463, 5338, 144, 3, 21, "Output",
      CellTags->"NumericalMath`$NumberBits::realx"]},
  "General::accg"->{
    Cell[153668, 5348, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::accg"],
    Cell[153750, 5351, 561, 17, 37, "Message",
      CellTags->"General::accg"],
    Cell[154314, 5370, 196, 5, 24, "Notes",
      CellTags->"General::accg"],
    Cell[154535, 5379, 63, 1, 38, "ExampleSection",
      CellTags->"General::accg"],
    Cell[154601, 5382, 252, 9, 40, "Text",
      CellTags->"General::accg"],
    Cell[154878, 5395, 188, 4, 42, "Input",
      CellTags->"General::accg"],
    Cell[155069, 5401, 244, 5, 37, "Message",
      CellTags->"General::accg"],
    Cell[155316, 5408, 216, 4, 37, "Output",
      CellTags->"General::accg"],
    Cell[155547, 5415, 142, 5, 24, "Text",
      CellTags->"General::accg"],
    Cell[155714, 5424, 193, 4, 42, "Input",
      CellTags->"General::accg"],
    Cell[155910, 5430, 136, 3, 21, "Output",
      CellTags->"General::accg"]},
  "NIntegrate::bdmtd"->{
    Cell[156107, 5440, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::bdmtd"],
    Cell[156197, 5443, 375, 7, 53, "Message",
      CellTags->"NIntegrate::bdmtd"],
    Cell[156575, 5452, 232, 7, 24, "Notes",
      CellTags->"NIntegrate::bdmtd"],
    Cell[156832, 5463, 67, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::bdmtd"],
    Cell[156902, 5466, 256, 9, 40, "Text",
      CellTags->"NIntegrate::bdmtd"],
    Cell[157183, 5479, 141, 3, 26, "Input",
      CellTags->"NIntegrate::bdmtd"],
    Cell[157327, 5484, 295, 6, 69, "Message",
      CellTags->"NIntegrate::bdmtd"],
    Cell[157625, 5492, 152, 4, 21, "Output",
      CellTags->"NIntegrate::bdmtd"],
    Cell[157792, 5499, 138, 5, 24, "Text",
      CellTags->"NIntegrate::bdmtd"],
    Cell[157955, 5508, 151, 4, 26, "Input",
      CellTags->"NIntegrate::bdmtd"],
    Cell[158109, 5514, 94, 3, 21, "Output",
      CellTags->"NIntegrate::bdmtd"]},
  "NIntegrate::comp"->{
    Cell[158264, 5524, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::comp"],
    Cell[158352, 5527, 381, 6, 85, "Message",
      CellTags->"NIntegrate::comp"],
    Cell[158736, 5535, 299, 8, 40, "Notes",
      CellTags->"NIntegrate::comp"],
    Cell[159060, 5547, 66, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::comp"],
    Cell[159129, 5550, 151, 4, 24, "Text",
      CellTags->"NIntegrate::comp"],
    Cell[159305, 5558, 164, 4, 26, "Input",
      CellTags->"NIntegrate::comp"],
    Cell[159472, 5564, 410, 7, 85, "Message",
      CellTags->"NIntegrate::comp"],
    Cell[159885, 5573, 173, 4, 36, "Output",
      CellTags->"NIntegrate::comp"],
    Cell[160073, 5580, 145, 5, 24, "Text",
      CellTags->"NIntegrate::comp"],
    Cell[160243, 5589, 169, 4, 42, "Input",
      CellTags->"NIntegrate::comp"],
    Cell[160415, 5595, 109, 3, 21, "Output",
      CellTags->"NIntegrate::comp"]},
  "NIntegrate::ierr"->{
    Cell[160585, 5605, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::ierr"],
    Cell[160673, 5608, 250, 4, 53, "Message",
      CellTags->"NIntegrate::ierr"],
    Cell[160926, 5614, 301, 8, 40, "Notes",
      CellTags->"NIntegrate::ierr"],
    Cell[161252, 5626, 66, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::ierr"],
    Cell[161321, 5629, 144, 4, 24, "Text",
      CellTags->"NIntegrate::ierr"],
    Cell[161490, 5637, 175, 4, 42, "Input",
      CellTags->"NIntegrate::ierr"],
    Cell[161668, 5643, 242, 5, 53, "Message",
      CellTags->"NIntegrate::ierr"],
    Cell[161913, 5650, 185, 4, 39, "Output",
      CellTags->"NIntegrate::ierr"],
    Cell[162113, 5657, 145, 5, 24, "Text",
      CellTags->"NIntegrate::ierr"],
    Cell[162283, 5666, 169, 4, 42, "Input",
      CellTags->"NIntegrate::ierr"],
    Cell[162455, 5672, 109, 3, 21, "Output",
      CellTags->"NIntegrate::ierr"]},
  "NIntegrate::inovf"->{
    Cell[162625, 5682, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::inovf"],
    Cell[162715, 5685, 488, 14, 37, "Message",
      CellTags->"NIntegrate::inovf"],
    Cell[163206, 5701, 149, 4, 24, "Notes",
      CellTags->"NIntegrate::inovf"]},
  "NIntegrate::inum"->{
    Cell[163392, 5710, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::inum"],
    Cell[163480, 5713, 442, 13, 21, "Message",
      CellTags->"NIntegrate::inum"],
    Cell[163925, 5728, 162, 4, 24, "Notes",
      CellTags->"NIntegrate::inum"],
    Cell[164112, 5736, 66, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::inum"],
    Cell[164181, 5739, 170, 4, 24, "Text",
      CellTags->"NIntegrate::inum"],
    Cell[164376, 5747, 121, 3, 26, "Input",
      CellTags->"NIntegrate::inum"],
    Cell[164500, 5752, 221, 5, 19, "Message",
      CellTags->"NIntegrate::inum"],
    Cell[164724, 5759, 122, 3, 25, "Output",
      CellTags->"NIntegrate::inum"],
    Cell[164861, 5765, 141, 4, 24, "Text",
      CellTags->"NIntegrate::inum"],
    Cell[165027, 5773, 136, 3, 26, "Input",
      CellTags->"NIntegrate::inum"],
    Cell[165166, 5778, 114, 3, 25, "Output",
      CellTags->"NIntegrate::inum"]},
  "NIntegrate::minmax"->{
    Cell[165341, 5788, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::minmax"],
    Cell[165433, 5791, 426, 12, 19, "Message",
      CellTags->"NIntegrate::minmax"],
    Cell[165862, 5805, 249, 7, 24, "Notes",
      CellTags->"NIntegrate::minmax"],
    Cell[166136, 5816, 68, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::minmax"],
    Cell[166207, 5819, 237, 7, 40, "Text",
      CellTags->"NIntegrate::minmax"],
    Cell[166469, 5830, 166, 4, 26, "Input",
      CellTags->"NIntegrate::minmax"],
    Cell[166638, 5836, 208, 5, 19, "Message",
      CellTags->"NIntegrate::minmax"],
    Cell[166849, 5843, 177, 4, 25, "Output",
      CellTags->"NIntegrate::minmax"],
    Cell[167041, 5850, 192, 7, 24, "Text",
      CellTags->"NIntegrate::minmax"],
    Cell[167258, 5861, 166, 4, 26, "Input",
      CellTags->"NIntegrate::minmax"],
    Cell[167427, 5867, 116, 3, 25, "Output",
      CellTags->"NIntegrate::minmax"]},
  "NIntegrate::nconv"->{
    Cell[167604, 5877, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::nconv"],
    Cell[167694, 5880, 178, 3, 19, "Message",
      CellTags->"NIntegrate::nconv"],
    Cell[167875, 5885, 276, 7, 40, "Notes",
      CellTags->"NIntegrate::nconv"]},
  "NIntegrate::ncvb"->{
    Cell[168188, 5897, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::ncvb"],
    Cell[168276, 5900, 622, 17, 33, "Message",
      CellTags->"NIntegrate::ncvb"],
    Cell[168901, 5919, 618, 11, 122, "Notes",
      CellTags->"NIntegrate::ncvb"],
    Cell[169544, 5934, 66, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::ncvb"],
    Cell[169613, 5937, 152, 4, 24, "Text",
      CellTags->"NIntegrate::ncvb"],
    Cell[169790, 5945, 131, 3, 26, "Input",
      CellTags->"NIntegrate::ncvb"],
    Cell[169924, 5950, 415, 7, 75, "Message",
      CellTags->"NIntegrate::ncvb"],
    Cell[170342, 5959, 277, 6, 33, "Message",
      CellTags->"NIntegrate::ncvb"],
    Cell[170622, 5967, 108, 3, 25, "Output",
      CellTags->"NIntegrate::ncvb"],
    Cell[170745, 5973, 183, 4, 40, "Text",
      CellTags->"NIntegrate::ncvb"],
    Cell[170953, 5981, 134, 3, 26, "Input",
      CellTags->"NIntegrate::ncvb"],
    Cell[171090, 5986, 108, 3, 25, "Output",
      CellTags->"NIntegrate::ncvb"]},
  "NIntegrate::ncvs"->{
    Cell[171259, 5996, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::ncvs"],
    Cell[171347, 5999, 466, 13, 33, "Message",
      CellTags->"NIntegrate::ncvs"],
    Cell[171816, 6014, 157, 4, 24, "Notes",
      CellTags->"NIntegrate::ncvs"],
    Cell[171998, 6022, 66, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::ncvs"],
    Cell[172067, 6025, 129, 4, 24, "Text",
      CellTags->"NIntegrate::ncvs"],
    Cell[172221, 6033, 146, 3, 26, "Input",
      CellTags->"NIntegrate::ncvs"],
    Cell[172370, 6038, 242, 5, 33, "Message",
      CellTags->"NIntegrate::ncvs"],
    Cell[172615, 6045, 161, 4, 40, "Output",
      CellTags->"NIntegrate::ncvs"]},
  "NIntegrate::ninf"->{
    Cell[172837, 6056, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::ninf"],
    Cell[172925, 6059, 275, 6, 19, "Message",
      CellTags->"NIntegrate::ninf"],
    Cell[173203, 6067, 576, 14, 100, "Notes",
      CellTags->"NIntegrate::ninf"],
    Cell[173804, 6085, 66, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::ninf"],
    Cell[173873, 6088, 164, 4, 24, "Text",
      CellTags->"NIntegrate::ninf"],
    Cell[174062, 6096, 144, 3, 26, "Input",
      CellTags->"NIntegrate::ninf"],
    Cell[174209, 6101, 248, 5, 19, "Message",
      CellTags->"NIntegrate::ninf"],
    Cell[174460, 6108, 172, 5, 40, "Output",
      CellTags->"NIntegrate::ninf"]},
  "NIntegrate::nintp"->{
    Cell[174693, 6120, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::nintp"],
    Cell[174783, 6123, 459, 14, 19, "Message",
      CellTags->"NIntegrate::nintp"],
    Cell[175245, 6139, 326, 7, 62, "Notes",
      CellTags->"NIntegrate::nintp"],
    Cell[175596, 6150, 67, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::nintp"],
    Cell[175666, 6153, 99, 1, 24, "Text",
      CellTags->"NIntegrate::nintp"]},
  "NIntegrate::oscfm"->{
    Cell[175814, 6160, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::oscfm"],
    Cell[175904, 6163, 422, 7, 75, "Message",
      CellTags->"NIntegrate::oscfm"],
    Cell[176329, 6172, 300, 8, 40, "Notes",
      CellTags->"NIntegrate::oscfm"],
    Cell[176654, 6184, 67, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::oscfm"],
    Cell[176724, 6187, 178, 4, 40, "Text",
      CellTags->"NIntegrate::oscfm"],
    Cell[176927, 6195, 151, 4, 26, "Input",
      CellTags->"NIntegrate::oscfm"],
    Cell[177081, 6201, 451, 8, 75, "Message",
      CellTags->"NIntegrate::oscfm"],
    Cell[177535, 6211, 165, 4, 25, "Output",
      CellTags->"NIntegrate::oscfm"],
    Cell[177715, 6218, 146, 5, 24, "Text",
      CellTags->"NIntegrate::oscfm"],
    Cell[177886, 6227, 170, 4, 42, "Input",
      CellTags->"NIntegrate::oscfm"],
    Cell[178059, 6233, 110, 3, 25, "Output",
      CellTags->"NIntegrate::oscfm"]},
  "NIntegrate::oscint"->{
    Cell[178230, 6243, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::oscint"],
    Cell[178322, 6246, 317, 6, 33, "Message",
      CellTags->"NIntegrate::oscint"],
    Cell[178642, 6254, 413, 11, 62, "Notes",
      CellTags->"NIntegrate::oscint"]},
  "NIntegrate::osran"->{
    Cell[179092, 6270, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::osran"],
    Cell[179182, 6273, 242, 6, 19, "Message",
      CellTags->"NIntegrate::osran"],
    Cell[179427, 6281, 268, 7, 40, "Notes",
      CellTags->"NIntegrate::osran"],
    Cell[179720, 6292, 67, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::osran"],
    Cell[179790, 6295, 202, 5, 40, "Text",
      CellTags->"NIntegrate::osran"],
    Cell[180017, 6304, 187, 4, 42, "Input",
      CellTags->"NIntegrate::osran"],
    Cell[180207, 6310, 205, 5, 19, "Message",
      CellTags->"NIntegrate::osran"],
    Cell[180415, 6317, 197, 4, 42, "Output",
      CellTags->"NIntegrate::osran"],
    Cell[180627, 6324, 152, 4, 24, "Text",
      CellTags->"NIntegrate::osran"],
    Cell[180804, 6332, 217, 5, 42, "Input",
      CellTags->"NIntegrate::osran"],
    Cell[181024, 6339, 110, 3, 25, "Output",
      CellTags->"NIntegrate::osran"]},
  "NIntegrate::osrn"->{
    Cell[181195, 6349, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::osrn"],
    Cell[181283, 6352, 280, 5, 33, "Message",
      CellTags->"NIntegrate::osrn"],
    Cell[181566, 6359, 271, 7, 40, "Notes",
      CellTags->"NIntegrate::osrn"],
    Cell[181862, 6370, 66, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::osrn"],
    Cell[181931, 6373, 241, 6, 40, "Text",
      CellTags->"NIntegrate::osrn"],
    Cell[182197, 6383, 164, 4, 26, "Input",
      CellTags->"NIntegrate::osrn"],
    Cell[182364, 6389, 248, 5, 33, "Message",
      CellTags->"NIntegrate::osrn"],
    Cell[182615, 6396, 170, 4, 40, "Output",
      CellTags->"NIntegrate::osrn"],
    Cell[182800, 6403, 125, 4, 24, "Text",
      CellTags->"NIntegrate::osrn"],
    Cell[182950, 6411, 134, 3, 26, "Input",
      CellTags->"NIntegrate::osrn"],
    Cell[183087, 6416, 109, 3, 25, "Output",
      CellTags->"NIntegrate::osrn"],
    Cell[183211, 6422, 158, 4, 24, "Text",
      CellTags->"NIntegrate::osrn"],
    Cell[183394, 6430, 265, 6, 58, "Input",
      CellTags->"NIntegrate::osrn"],
    Cell[183662, 6438, 109, 3, 25, "Output",
      CellTags->"NIntegrate::osrn"]},
  "NIntegrate::ploss"->{
    Cell[183832, 6448, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::ploss"],
    Cell[183922, 6451, 428, 7, 75, "Message",
      CellTags->"NIntegrate::ploss"],
    Cell[184353, 6460, 329, 9, 40, "Notes",
      CellTags->"NIntegrate::ploss"],
    Cell[184707, 6473, 67, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::ploss"],
    Cell[184777, 6476, 238, 5, 40, "Text",
      CellTags->"NIntegrate::ploss"],
    Cell[185040, 6485, 123, 3, 26, "Input",
      CellTags->"NIntegrate::ploss"],
    Cell[185166, 6490, 457, 8, 101, "Message",
      CellTags->"NIntegrate::ploss"],
    Cell[185626, 6500, 119, 3, 23, "Output",
      CellTags->"NIntegrate::ploss"],
    Cell[185760, 6506, 308, 7, 40, "Text",
      CellTags->"NIntegrate::ploss"],
    Cell[186093, 6517, 142, 3, 26, "Input",
      CellTags->"NIntegrate::ploss"],
    Cell[186238, 6522, 115, 3, 23, "Output",
      CellTags->"NIntegrate::ploss"]},
  "General::precg"->{
    Cell[186414, 6532, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::precg"],
    Cell[186498, 6535, 573, 17, 37, "Message",
      CellTags->"General::precg"],
    Cell[187074, 6554, 198, 5, 24, "Notes",
      CellTags->"General::precg"],
    Cell[187297, 6563, 64, 1, 38, "ExampleSection",
      CellTags->"General::precg"],
    Cell[187364, 6566, 255, 9, 40, "Text",
      CellTags->"General::precg"],
    Cell[187644, 6579, 206, 4, 42, "Input",
      CellTags->"General::precg"],
    Cell[187853, 6585, 256, 5, 53, "Message",
      CellTags->"General::precg"],
    Cell[188112, 6592, 207, 4, 37, "Output",
      CellTags->"General::precg"],
    Cell[188334, 6599, 186, 7, 24, "Text",
      CellTags->"General::precg"],
    Cell[188545, 6610, 210, 4, 42, "Input",
      CellTags->"General::precg"],
    Cell[188758, 6616, 159, 4, 21, "Output",
      CellTags->"General::precg"]},
  "NIntegrate::rnderr"->{
    Cell[188978, 6627, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::rnderr"],
    Cell[189070, 6630, 463, 10, 37, "Message",
      CellTags->"NIntegrate::rnderr"],
    Cell[189536, 6642, 400, 8, 78, "Notes",
      CellTags->"NIntegrate::rnderr"]},
  "NIntegrate::slwcon"->{
    Cell[189973, 6655, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::slwcon"],
    Cell[190065, 6658, 388, 6, 85, "Message",
      CellTags->"NIntegrate::slwcon"],
    Cell[190456, 6666, 175, 4, 24, "Notes",
      CellTags->"NIntegrate::slwcon"],
    Cell[190656, 6674, 68, 1, 38, "ExampleSection",
      CellTags->"NIntegrate::slwcon"],
    Cell[190727, 6677, 172, 4, 24, "Text",
      CellTags->"NIntegrate::slwcon"],
    Cell[190924, 6685, 179, 4, 26, "Input",
      CellTags->"NIntegrate::slwcon"],
    Cell[191106, 6691, 417, 7, 85, "Message",
      CellTags->"NIntegrate::slwcon"],
    Cell[191526, 6700, 287, 6, 53, "Message",
      CellTags->"NIntegrate::slwcon"],
    Cell[191816, 6708, 111, 3, 21, "Output",
      CellTags->"NIntegrate::slwcon"],
    Cell[191942, 6714, 150, 5, 24, "Text",
      CellTags->"NIntegrate::slwcon"],
    Cell[192117, 6723, 177, 4, 42, "Input",
      CellTags->"NIntegrate::slwcon"],
    Cell[192297, 6729, 111, 3, 21, "Output",
      CellTags->"NIntegrate::slwcon"]},
  "NProduct::emcon"->{
    Cell[192469, 6739, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NProduct::emcon", "NSum::emcon"}],
    Cell[192592, 6745, 298, 7, 37, "Message",
      CellTags->{"NProduct::emcon", "NSum::emcon"}],
    Cell[192893, 6754, 286, 7, 46, "Notes",
      CellTags->{"NProduct::emcon", "NSum::emcon"}]},
  "NSum::emcon"->{
    Cell[192469, 6739, 120, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NProduct::emcon", "NSum::emcon"}],
    Cell[192592, 6745, 298, 7, 37, "Message",
      CellTags->{"NProduct::emcon", "NSum::emcon"}],
    Cell[192893, 6754, 286, 7, 46, "Notes",
      CellTags->{"NProduct::emcon", "NSum::emcon"}]},
  "NProduct::itfn"->{
    Cell[193216, 6766, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NProduct::itfn"],
    Cell[193300, 6769, 232, 5, 21, "Message",
      CellTags->"NProduct::itfn"],
    Cell[193535, 6776, 909, 33, 68, "Notes",
      CellTags->"NProduct::itfn"],
    Cell[194469, 6813, 64, 1, 38, "ExampleSection",
      CellTags->"NProduct::itfn"],
    Cell[194536, 6816, 144, 4, 24, "Text",
      CellTags->"NProduct::itfn"],
    Cell[194705, 6824, 101, 3, 26, "Input",
      CellTags->"NProduct::itfn"],
    Cell[194809, 6829, 193, 5, 21, "Message",
      CellTags->"NProduct::itfn"],
    Cell[195005, 6836, 102, 3, 21, "Output",
      CellTags->"NProduct::itfn"],
    Cell[195122, 6842, 129, 5, 24, "Text",
      CellTags->"NProduct::itfn"],
    Cell[195276, 6851, 106, 3, 26, "Input",
      CellTags->"NProduct::itfn"],
    Cell[195385, 6856, 93, 3, 21, "Output",
      CellTags->"NProduct::itfn"]},
  "NProduct::nplim"->{
    Cell[195539, 6866, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NProduct::nplim"],
    Cell[195625, 6869, 248, 5, 21, "Message",
      CellTags->"NProduct::nplim"],
    Cell[195876, 6876, 197, 6, 24, "Notes",
      CellTags->"NProduct::nplim"],
    Cell[196098, 6886, 65, 1, 38, "ExampleSection",
      CellTags->"NProduct::nplim"],
    Cell[196166, 6889, 166, 4, 24, "Text",
      CellTags->"NProduct::nplim"],
    Cell[196357, 6897, 112, 3, 26, "Input",
      CellTags->"NProduct::nplim"],
    Cell[196472, 6902, 180, 4, 21, "Message",
      CellTags->"NProduct::nplim"],
    Cell[196655, 6908, 113, 3, 21, "Output",
      CellTags->"NProduct::nplim"],
    Cell[196783, 6914, 146, 5, 24, "Text",
      CellTags->"NProduct::nplim"],
    Cell[196954, 6923, 136, 3, 26, "Input",
      CellTags->"NProduct::nplim"],
    Cell[197093, 6928, 94, 3, 21, "Output",
      CellTags->"NProduct::nplim"]},
  "NProduct::npnum"->{
    Cell[197248, 6938, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NProduct::npnum"],
    Cell[197334, 6941, 466, 14, 21, "Message",
      CellTags->"NProduct::npnum"],
    Cell[197803, 6957, 212, 5, 24, "Notes",
      CellTags->"NProduct::npnum"],
    Cell[198040, 6966, 65, 1, 38, "ExampleSection",
      CellTags->"NProduct::npnum"],
    Cell[198108, 6969, 222, 6, 40, "Text",
      CellTags->"NProduct::npnum"],
    Cell[198355, 6979, 124, 3, 26, "Input",
      CellTags->"NProduct::npnum"],
    Cell[198482, 6984, 217, 5, 21, "Message",
      CellTags->"NProduct::npnum"],
    Cell[198702, 6991, 129, 3, 21, "Output",
      CellTags->"NProduct::npnum"],
    Cell[198846, 6997, 146, 5, 24, "Text",
      CellTags->"NProduct::npnum"],
    Cell[199017, 7006, 141, 3, 26, "Input",
      CellTags->"NProduct::npnum"],
    Cell[199161, 7011, 90, 3, 21, "Output",
      CellTags->"NProduct::npnum"]},
  "NProduct::npst"->{
    Cell[199312, 7021, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NProduct::npst"],
    Cell[199396, 7024, 259, 6, 21, "Message",
      CellTags->"NProduct::npst"],
    Cell[199658, 7032, 191, 5, 24, "Notes",
      CellTags->"NProduct::npst"],
    Cell[199874, 7041, 64, 1, 38, "ExampleSection",
      CellTags->"NProduct::npst"],
    Cell[199941, 7044, 182, 4, 40, "Text",
      CellTags->"NProduct::npst"],
    Cell[200148, 7052, 119, 3, 26, "Input",
      CellTags->"NProduct::npst"],
    Cell[200270, 7057, 189, 4, 21, "Message",
      CellTags->"NProduct::npst"],
    Cell[200462, 7063, 122, 3, 36, "Output",
      CellTags->"NProduct::npst"],
    Cell[200599, 7069, 145, 5, 24, "Text",
      CellTags->"NProduct::npst"],
    Cell[200769, 7078, 139, 3, 26, "Input",
      CellTags->"NProduct::npst"],
    Cell[200911, 7083, 112, 3, 21, "Output",
      CellTags->"NProduct::npst"]},
  "NProduct::npz"->{
    Cell[201084, 7093, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NProduct::npz"],
    Cell[201166, 7096, 197, 4, 21, "Message",
      CellTags->"NProduct::npz"],
    Cell[201366, 7102, 537, 12, 100, "Notes",
      CellTags->"NProduct::npz"]},
  "NRoots::nomod"->{
    Cell[201940, 7119, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NRoots::nomod"],
    Cell[202022, 7122, 158, 3, 21, "Message",
      CellTags->"NRoots::nomod"],
    Cell[202183, 7127, 193, 6, 24, "Notes",
      CellTags->"NRoots::nomod"]},
  "NSum::itfn"->{
    Cell[202413, 7138, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NSum::itfn"],
    Cell[202489, 7141, 224, 5, 21, "Message",
      CellTags->"NSum::itfn"],
    Cell[202716, 7148, 897, 33, 68, "Notes",
      CellTags->"NSum::itfn"],
    Cell[203638, 7185, 60, 1, 38, "ExampleSection",
      CellTags->"NSum::itfn"],
    Cell[203701, 7188, 140, 4, 24, "Text",
      CellTags->"NSum::itfn"],
    Cell[203866, 7196, 94, 3, 26, "Input",
      CellTags->"NSum::itfn"],
    Cell[203963, 7201, 186, 5, 21, "Message",
      CellTags->"NSum::itfn"],
    Cell[204152, 7208, 95, 3, 21, "Output",
      CellTags->"NSum::itfn"],
    Cell[204262, 7214, 137, 5, 24, "Text",
      CellTags->"NSum::itfn"],
    Cell[204424, 7223, 99, 3, 26, "Input",
      CellTags->"NSum::itfn"],
    Cell[204526, 7228, 89, 3, 21, "Output",
      CellTags->"NSum::itfn"]},
  "NSum::nsst"->{
    Cell[204676, 7238, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NSum::nsst"],
    Cell[204752, 7241, 253, 6, 21, "Message",
      CellTags->"NSum::nsst"],
    Cell[205008, 7249, 174, 4, 24, "Notes",
      CellTags->"NSum::nsst"],
    Cell[205207, 7257, 60, 1, 38, "ExampleSection",
      CellTags->"NSum::nsst"],
    Cell[205270, 7260, 178, 4, 40, "Text",
      CellTags->"NSum::nsst"],
    Cell[205473, 7268, 109, 3, 26, "Input",
      CellTags->"NSum::nsst"],
    Cell[205585, 7273, 185, 5, 21, "Message",
      CellTags->"NSum::nsst"],
    Cell[205773, 7280, 110, 3, 21, "Output",
      CellTags->"NSum::nsst"],
    Cell[205898, 7286, 137, 5, 24, "Text",
      CellTags->"NSum::nsst"],
    Cell[206060, 7295, 127, 3, 26, "Input",
      CellTags->"NSum::nsst"],
    Cell[206190, 7300, 87, 3, 21, "Output",
      CellTags->"NSum::nsst"]},
  "NSum::nsumz"->{
    Cell[206338, 7310, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NSum::nsumz"],
    Cell[206416, 7313, 192, 4, 21, "Message",
      CellTags->"NSum::nsumz"],
    Cell[206611, 7319, 523, 12, 84, "Notes",
      CellTags->"NSum::nsumz"]},
  "SequenceLimit::seqlim"->{
    Cell[207171, 7336, 95, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SequenceLimit::seqlim"],
    Cell[207269, 7339, 243, 4, 53, "Message",
      CellTags->"SequenceLimit::seqlim"],
    Cell[207515, 7345, 535, 13, 78, "Notes",
      CellTags->"SequenceLimit::seqlim"],
    Cell[208075, 7362, 71, 1, 38, "ExampleSection",
      CellTags->"SequenceLimit::seqlim"],
    Cell[208149, 7365, 184, 4, 40, "Text",
      CellTags->"SequenceLimit::seqlim"],
    Cell[208358, 7373, 133, 3, 26, "Input",
      CellTags->"SequenceLimit::seqlim"],
    Cell[208494, 7378, 242, 5, 37, "Message",
      CellTags->"SequenceLimit::seqlim"],
    Cell[208739, 7385, 99, 3, 36, "Output",
      CellTags->"SequenceLimit::seqlim"],
    Cell[208853, 7391, 264, 9, 40, "Text",
      CellTags->"SequenceLimit::seqlim"],
    Cell[209142, 7404, 177, 4, 42, "Input",
      CellTags->"SequenceLimit::seqlim"],
    Cell[209322, 7410, 242, 5, 37, "Message",
      CellTags->"SequenceLimit::seqlim"],
    Cell[209567, 7417, 119, 3, 21, "Output",
      CellTags->"SequenceLimit::seqlim"]},
  "SequenceLimit::seqw"->{
    Cell[209747, 7427, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SequenceLimit::seqw"],
    Cell[209841, 7430, 422, 12, 37, "Message",
      CellTags->"SequenceLimit::seqw"],
    Cell[210266, 7444, 425, 15, 40, "Notes",
      CellTags->"SequenceLimit::seqw"],
    Cell[210716, 7463, 69, 1, 38, "ExampleSection",
      CellTags->"SequenceLimit::seqw"],
    Cell[210788, 7466, 256, 6, 40, "Text",
      CellTags->"SequenceLimit::seqw"],
    Cell[211069, 7476, 139, 3, 26, "Input",
      CellTags->"SequenceLimit::seqw"],
    Cell[211211, 7481, 223, 5, 37, "Message",
      CellTags->"SequenceLimit::seqw"],
    Cell[211437, 7488, 145, 3, 21, "Output",
      CellTags->"SequenceLimit::seqw"],
    Cell[211597, 7494, 171, 5, 24, "Text",
      CellTags->"SequenceLimit::seqw"],
    Cell[211793, 7503, 142, 3, 26, "Input",
      CellTags->"SequenceLimit::seqw"],
    Cell[211938, 7508, 94, 3, 21, "Output",
      CellTags->"SequenceLimit::seqw"]},
  "SequenceLimit::wynn"->{
    Cell[212093, 7518, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SequenceLimit::wynn"],
    Cell[212187, 7521, 320, 6, 37, "Message",
      CellTags->"SequenceLimit::wynn"],
    Cell[212510, 7529, 199, 5, 24, "Notes",
      CellTags->"SequenceLimit::wynn"],
    Cell[212734, 7538, 69, 1, 38, "ExampleSection",
      CellTags->"SequenceLimit::wynn"],
    Cell[212806, 7541, 220, 7, 24, "Text",
      CellTags->"SequenceLimit::wynn"],
    Cell[213051, 7552, 150, 3, 26, "Input",
      CellTags->"SequenceLimit::wynn"],
    Cell[213204, 7557, 248, 5, 53, "Message",
      CellTags->"SequenceLimit::wynn"],
    Cell[213455, 7564, 163, 4, 21, "Output",
      CellTags->"SequenceLimit::wynn"],
    Cell[213633, 7571, 146, 5, 24, "Text",
      CellTags->"SequenceLimit::wynn"],
    Cell[213804, 7580, 142, 3, 26, "Input",
      CellTags->"SequenceLimit::wynn"],
    Cell[213949, 7585, 94, 3, 21, "Output",
      CellTags->"SequenceLimit::wynn"]},
  "SetAccuracy::accbd"->{
    Cell[214104, 7595, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SetAccuracy::accbd"],
    Cell[214196, 7598, 286, 6, 37, "Message",
      CellTags->"SetAccuracy::accbd"],
    Cell[214485, 7606, 198, 6, 24, "Notes",
      CellTags->"SetAccuracy::accbd"]},
  "SetAccuracy::acclg"->{
    Cell[214720, 7617, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SetAccuracy::acclg"],
    Cell[214812, 7620, 388, 9, 53, "Message",
      CellTags->"SetAccuracy::acclg"],
    Cell[215203, 7631, 272, 7, 40, "Notes",
      CellTags->"SetAccuracy::acclg"]},
  "SetAccuracy::accsm"->{
    Cell[215512, 7643, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SetAccuracy::accsm"],
    Cell[215604, 7646, 388, 9, 53, "Message",
      CellTags->"SetAccuracy::accsm"],
    Cell[215995, 7657, 272, 7, 40, "Notes",
      CellTags->"SetAccuracy::accsm"]},
  "Sum::div"->{
    Cell[216304, 7669, 69, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Sum::div"],
    Cell[216376, 7672, 129, 3, 21, "Message",
      CellTags->"Sum::div"],
    Cell[216508, 7677, 157, 5, 24, "Notes",
      CellTags->"Sum::div"]},
  "General::precw"->{
    Cell[216702, 7687, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::precw"],
    Cell[216786, 7690, 486, 13, 37, "Message",
      CellTags->"General::precw"],
    Cell[217275, 7705, 883, 20, 154, "Notes",
      CellTags->"General::precw"],
    Cell[218183, 7729, 64, 1, 38, "ExampleSection",
      CellTags->"General::precw"],
    Cell[218250, 7732, 376, 9, 56, "Text",
      CellTags->"General::precw"],
    Cell[218651, 7745, 140, 3, 26, "Input",
      CellTags->"General::precw"],
    Cell[218794, 7750, 240, 5, 37, "Message",
      CellTags->"General::precw"],
    Cell[219037, 7757, 148, 4, 21, "Output",
      CellTags->"General::precw"],
    Cell[219200, 7764, 119, 4, 24, "Text",
      CellTags->"General::precw"],
    Cell[219344, 7772, 142, 3, 26, "Input",
      CellTags->"General::precw"],
    Cell[219489, 7777, 148, 4, 21, "Output",
      CellTags->"General::precw"],
    Cell[219652, 7784, 250, 8, 40, "Text",
      CellTags->"General::precw"],
    Cell[219927, 7796, 133, 3, 26, "Input",
      CellTags->"General::precw"],
    Cell[220063, 7801, 92, 3, 21, "Output",
      CellTags->"General::precw"],
    Cell[220170, 7807, 315, 10, 40, "Text",
      CellTags->"General::precw"],
    Cell[220510, 7821, 101, 3, 26, "Input",
      CellTags->"General::precw"],
    Cell[220614, 7826, 104, 3, 21, "Output",
      CellTags->"General::precw"],
    Cell[220755, 7834, 124, 3, 26, "Input",
      CellTags->"General::precw"],
    Cell[220882, 7839, 131, 3, 21, "Output",
      CellTags->"General::precw"],
    Cell[221028, 7845, 410, 10, 56, "Text",
      CellTags->"General::precw"],
    Cell[221463, 7859, 156, 4, 26, "Input",
      CellTags->"General::precw"],
    Cell[221622, 7865, 92, 3, 21, "Output",
      CellTags->"General::precw"]},
  "General::unfl"->{
    Cell[221775, 7875, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::unfl"],
    Cell[221857, 7878, 237, 7, 21, "Message",
      CellTags->"General::unfl"],
    Cell[222097, 7887, 610, 15, 100, "Notes",
      CellTags->"General::unfl"],
    Cell[222732, 7906, 63, 1, 38, "ExampleSection",
      CellTags->"General::unfl"],
    Cell[222798, 7909, 214, 6, 40, "Text",
      CellTags->"General::unfl"],
    Cell[223037, 7919, 103, 3, 26, "Input",
      CellTags->"General::unfl"],
    Cell[223143, 7924, 168, 4, 21, "Message",
      CellTags->"General::unfl"],
    Cell[223314, 7930, 98, 3, 21, "Output",
      CellTags->"General::unfl"],
    Cell[223449, 7938, 96, 3, 26, "Input",
      CellTags->"General::unfl"],
    Cell[223548, 7943, 150, 4, 23, "Output",
      CellTags->"General::unfl"],
    Cell[223713, 7950, 176, 6, 24, "Text",
      CellTags->"General::unfl"],
    Cell[223914, 7960, 130, 3, 26, "Input",
      CellTags->"General::unfl"],
    Cell[224047, 7965, 106, 3, 21, "Output",
      CellTags->"General::unfl"],
    Cell[224168, 7971, 242, 6, 40, "Text",
      CellTags->"General::unfl"],
    Cell[224435, 7981, 160, 4, 26, "Input",
      CellTags->"General::unfl"],
    Cell[224598, 7987, 168, 4, 21, "Message",
      CellTags->"General::unfl"],
    Cell[224769, 7993, 106, 3, 21, "Output",
      CellTags->"General::unfl"],
    Cell[224912, 8001, 129, 3, 26, "Input",
      CellTags->"General::unfl"],
    Cell[225044, 8006, 100, 3, 36, "Output",
      CellTags->"General::unfl"],
    Cell[225159, 8012, 137, 4, 24, "Text",
      CellTags->"General::unfl"]},
  "General::ovfl"->{
    Cell[225345, 8022, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::ovfl"],
    Cell[225427, 8025, 288, 9, 21, "Message",
      CellTags->"General::ovfl"],
    Cell[225718, 8036, 588, 14, 100, "Notes",
      CellTags->"General::ovfl"],
    Cell[226331, 8054, 63, 1, 38, "ExampleSection",
      CellTags->"General::ovfl"],
    Cell[226397, 8057, 213, 6, 40, "Text",
      CellTags->"General::ovfl"],
    Cell[226635, 8067, 98, 3, 26, "Input",
      CellTags->"General::ovfl"],
    Cell[226736, 8072, 167, 4, 21, "Message",
      CellTags->"General::ovfl"],
    Cell[226906, 8078, 97, 3, 21, "Output",
      CellTags->"General::ovfl"],
    Cell[227040, 8086, 96, 3, 26, "Input",
      CellTags->"General::ovfl"],
    Cell[227139, 8091, 149, 4, 23, "Output",
      CellTags->"General::ovfl"],
    Cell[227303, 8098, 173, 6, 24, "Text",
      CellTags->"General::ovfl"],
    Cell[227501, 8108, 119, 3, 26, "Input",
      CellTags->"General::ovfl"],
    Cell[227623, 8113, 167, 4, 21, "Message",
      CellTags->"General::ovfl"],
    Cell[227793, 8119, 223, 5, 37, "Message",
      CellTags->"General::ovfl"],
    Cell[228019, 8126, 143, 3, 26, "Output",
      CellTags->"General::ovfl"],
    Cell[228177, 8132, 135, 4, 24, "Text",
      CellTags->"General::ovfl"],
    Cell[228337, 8140, 118, 3, 26, "Input",
      CellTags->"General::ovfl"],
    Cell[228458, 8145, 123, 3, 21, "Output",
      CellTags->"General::ovfl"]},
  "ContinuedFraction::noterms"->{
    Cell[228642, 8155, 105, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ContinuedFraction::noterms"],
    Cell[228750, 8158, 306, 6, 53, "Message",
      CellTags->"ContinuedFraction::noterms"],
    Cell[229059, 8166, 364, 9, 46, "Notes",
      CellTags->"ContinuedFraction::noterms"],
    Cell[229448, 8179, 76, 1, 38, "ExampleSection",
      CellTags->"ContinuedFraction::noterms"],
    Cell[229527, 8182, 240, 6, 40, "Text",
      CellTags->"ContinuedFraction::noterms"],
    Cell[229792, 8192, 120, 3, 26, "Input",
      CellTags->"ContinuedFraction::noterms"],
    Cell[229915, 8197, 292, 5, 53, "Message",
      CellTags->"ContinuedFraction::noterms"],
    Cell[230210, 8204, 124, 3, 21, "Output",
      CellTags->"ContinuedFraction::noterms"],
    Cell[230349, 8210, 160, 4, 24, "Text",
      CellTags->"ContinuedFraction::noterms"],
    Cell[230534, 8218, 124, 3, 26, "Input",
      CellTags->"ContinuedFraction::noterms"],
    Cell[230661, 8223, 133, 3, 21, "Output",
      CellTags->"ContinuedFraction::noterms"]},
  "ContinuedFraction::incomp"->{
    Cell[230855, 8233, 103, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ContinuedFraction::incomp"],
    Cell[230961, 8236, 215, 5, 37, "Message",
      CellTags->"ContinuedFraction::incomp"],
    Cell[231179, 8243, 322, 6, 40, "Notes",
      CellTags->"ContinuedFraction::incomp"],
    Cell[231526, 8253, 75, 1, 38, "ExampleSection",
      CellTags->"ContinuedFraction::incomp"],
    Cell[231604, 8256, 187, 4, 40, "Text",
      CellTags->"ContinuedFraction::incomp"],
    Cell[231816, 8264, 121, 3, 26, "Input",
      CellTags->"ContinuedFraction::incomp"],
    Cell[231940, 8269, 219, 5, 37, "Message",
      CellTags->"ContinuedFraction::incomp"],
    Cell[232162, 8276, 102, 3, 21, "Output",
      CellTags->"ContinuedFraction::incomp"],
    Cell[232279, 8282, 116, 1, 24, "Text",
      CellTags->"ContinuedFraction::incomp"],
    Cell[232420, 8287, 121, 3, 26, "Input",
      CellTags->"ContinuedFraction::incomp"],
    Cell[232544, 8292, 102, 3, 21, "Output",
      CellTags->"ContinuedFraction::incomp"]},
  "ContinuedFraction::terms"->{
    Cell[232707, 8302, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ContinuedFraction::terms"],
    Cell[232811, 8305, 249, 5, 53, "Message",
      CellTags->"ContinuedFraction::terms"],
    Cell[233063, 8312, 242, 6, 40, "Notes",
      CellTags->"ContinuedFraction::terms"],
    Cell[233330, 8322, 74, 1, 38, "ExampleSection",
      CellTags->"ContinuedFraction::terms"],
    Cell[233407, 8325, 301, 7, 40, "Text",
      CellTags->"ContinuedFraction::terms"],
    Cell[233733, 8336, 129, 3, 26, "Input",
      CellTags->"ContinuedFraction::terms"],
    Cell[233865, 8341, 271, 5, 53, "Message",
      CellTags->"ContinuedFraction::terms"],
    Cell[234139, 8348, 171, 4, 21, "Output",
      CellTags->"ContinuedFraction::terms"],
    Cell[234325, 8355, 154, 4, 24, "Text",
      CellTags->"ContinuedFraction::terms"],
    Cell[234504, 8363, 133, 3, 26, "Input",
      CellTags->"ContinuedFraction::terms"],
    Cell[234640, 8368, 262, 5, 37, "Output",
      CellTags->"ContinuedFraction::terms"]},
  "ContinuedFraction::start"->{
    Cell[234963, 8380, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ContinuedFraction::start"],
    Cell[235067, 8383, 247, 5, 53, "Message",
      CellTags->"ContinuedFraction::start"],
    Cell[235317, 8390, 306, 7, 40, "Notes",
      CellTags->"ContinuedFraction::start"],
    Cell[235648, 8401, 74, 1, 38, "ExampleSection",
      CellTags->"ContinuedFraction::start"],
    Cell[235725, 8404, 228, 5, 40, "Text",
      CellTags->"ContinuedFraction::start"],
    Cell[235978, 8413, 122, 3, 26, "Input",
      CellTags->"ContinuedFraction::start"],
    Cell[236103, 8418, 259, 5, 53, "Message",
      CellTags->"ContinuedFraction::start"],
    Cell[236365, 8425, 123, 3, 21, "Output",
      CellTags->"ContinuedFraction::start"],
    Cell[236503, 8431, 184, 4, 40, "Text",
      CellTags->"ContinuedFraction::start"],
    Cell[236712, 8439, 142, 3, 26, "Input",
      CellTags->"ContinuedFraction::start"],
    Cell[236857, 8444, 298, 6, 55, "Message",
      CellTags->"ContinuedFraction::start"],
    Cell[237158, 8452, 294, 6, 55, "Message",
      CellTags->"ContinuedFraction::start"],
    Cell[237455, 8460, 296, 6, 53, "Message",
      CellTags->"ContinuedFraction::start"],
    Cell[237754, 8468, 145, 3, 23, "Output",
      CellTags->"ContinuedFraction::start"]},
  "Fourier::fpopt"->{
    Cell[237960, 8478, 138, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[238101, 8484, 527, 14, 37, "Message",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[238631, 8500, 325, 9, 40, "Notes",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[238981, 8513, 91, 1, 38, "ExampleSection",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[239075, 8516, 282, 8, 40, "Text",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[239382, 8528, 192, 4, 26, "Input",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[239577, 8534, 249, 5, 37, "Message",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[239829, 8541, 198, 4, 21, "Output",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[240042, 8548, 214, 7, 24, "Text",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[240281, 8559, 194, 4, 26, "Input",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[240478, 8565, 537, 10, 37, "Output",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}]},
  "InverseFourier::fpopt"->{
    Cell[237960, 8478, 138, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[238101, 8484, 527, 14, 37, "Message",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[238631, 8500, 325, 9, 40, "Notes",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[238981, 8513, 91, 1, 38, "ExampleSection",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[239075, 8516, 282, 8, 40, "Text",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[239382, 8528, 192, 4, 26, "Input",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[239577, 8534, 249, 5, 37, "Message",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[239829, 8541, 198, 4, 21, "Output",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[240042, 8548, 214, 7, 24, "Text",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[240281, 8559, 194, 4, 26, "Input",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
    Cell[240478, 8565, 537, 10, 37, "Output",
      CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}]},
  "Fourier::fpopt2"->{
    Cell[241076, 8582, 142, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[241221, 8588, 743, 17, 69, "Message",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[241967, 8607, 734, 16, 100, "Notes",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[242726, 8627, 93, 1, 38, "ExampleSection",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[242822, 8630, 283, 6, 40, "Text",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[243130, 8640, 196, 4, 26, "Input",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[243329, 8646, 403, 7, 85, "Message",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[243735, 8655, 512, 8, 21, "Output",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[244262, 8666, 216, 7, 24, "Text",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[244503, 8677, 196, 4, 26, "Input",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[244702, 8683, 532, 10, 37, "Output",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}]},
  "InverseFourier::fpopt2"->{
    Cell[241076, 8582, 142, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[241221, 8588, 743, 17, 69, "Message",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[241967, 8607, 734, 16, 100, "Notes",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[242726, 8627, 93, 1, 38, "ExampleSection",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[242822, 8630, 283, 6, 40, "Text",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[243130, 8640, 196, 4, 26, "Input",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[243329, 8646, 403, 7, 85, "Message",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[243735, 8655, 512, 8, 21, "Output",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[244262, 8666, 216, 7, 24, "Text",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[244503, 8677, 196, 4, 26, "Input",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
    Cell[244702, 8683, 532, 10, 37, "Output",
      CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}]},
  "Fourier::fpoptn"->{
    Cell[245295, 8700, 142, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[245440, 8706, 520, 14, 37, "Message",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[245963, 8722, 326, 9, 40, "Notes",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[246314, 8735, 93, 1, 38, "ExampleSection",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[246410, 8738, 248, 6, 40, "Text",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[246683, 8748, 191, 4, 26, "Input",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[246877, 8754, 245, 5, 37, "Message",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[247125, 8761, 197, 4, 21, "Output",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[247337, 8768, 213, 7, 24, "Text",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[247575, 8779, 227, 5, 42, "Input",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[247805, 8786, 532, 10, 37, "Output",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}]},
  "InverseFourier::fpoptn"->{
    Cell[245295, 8700, 142, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[245440, 8706, 520, 14, 37, "Message",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[245963, 8722, 326, 9, 40, "Notes",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[246314, 8735, 93, 1, 38, "ExampleSection",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[246410, 8738, 248, 6, 40, "Text",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[246683, 8748, 191, 4, 26, "Input",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[246877, 8754, 245, 5, 37, "Message",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[247125, 8761, 197, 4, 21, "Output",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[247337, 8768, 213, 7, 24, "Text",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[247575, 8779, 227, 5, 42, "Input",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
    Cell[247805, 8786, 532, 10, 37, "Output",
      CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}]},
  "General::lrgexp"->{
    Cell[248398, 8803, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::lrgexp"],
    Cell[248484, 8806, 401, 12, 21, "Message",
      CellTags->"General::lrgexp"],
    Cell[248888, 8820, 386, 7, 62, "Notes",
      CellTags->"General::lrgexp"],
    Cell[249299, 8831, 65, 1, 38, "ExampleSection",
      CellTags->"General::lrgexp"],
    Cell[249367, 8834, 182, 6, 24, "Text",
      CellTags->"General::lrgexp"],
    Cell[249574, 8844, 121, 3, 26, "Input",
      CellTags->"General::lrgexp"],
    Cell[249698, 8849, 189, 4, 21, "Message",
      CellTags->"General::lrgexp"],
    Cell[249890, 8855, 125, 3, 23, "Output",
      CellTags->"General::lrgexp"]},
  "Developer`InequalityInstance::lowpr"->{
    Cell[250076, 8865, 344, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::lowpr", 
        "Experimental`ExistsRealQ::lowpr", "Experimental`ForAllRealQ::lowpr", 
        "Experimental`ImpliesRealQ::lowpr"}],
    Cell[250423, 8875, 662, 15, 37, "Message",
      CellTags->{
      "Developer`InequalityInstance::lowpr", 
        "Experimental`ExistsRealQ::lowpr", "Experimental`ForAllRealQ::lowpr", 
        "Experimental`ImpliesRealQ::lowpr"}],
    Cell[251088, 8892, 295, 6, 24, "Notes",
      CellTags->{
      "Developer`InequalityInstance::lowpr", 
        "Experimental`ExistsRealQ::lowpr", "Experimental`ForAllRealQ::lowpr", 
        "Experimental`ImpliesRealQ::lowpr"}]},
  "Experimental`ExistsRealQ::lowpr"->{
    Cell[250076, 8865, 344, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::lowpr", 
        "Experimental`ExistsRealQ::lowpr", "Experimental`ForAllRealQ::lowpr", 
        "Experimental`ImpliesRealQ::lowpr"}],
    Cell[250423, 8875, 662, 15, 37, "Message",
      CellTags->{
      "Developer`InequalityInstance::lowpr", 
        "Experimental`ExistsRealQ::lowpr", "Experimental`ForAllRealQ::lowpr", 
        "Experimental`ImpliesRealQ::lowpr"}],
    Cell[251088, 8892, 295, 6, 24, "Notes",
      CellTags->{
      "Developer`InequalityInstance::lowpr", 
        "Experimental`ExistsRealQ::lowpr", "Experimental`ForAllRealQ::lowpr", 
        "Experimental`ImpliesRealQ::lowpr"}]},
  "Experimental`ForAllRealQ::lowpr"->{
    Cell[250076, 8865, 344, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::lowpr", 
        "Experimental`ExistsRealQ::lowpr", "Experimental`ForAllRealQ::lowpr", 
        "Experimental`ImpliesRealQ::lowpr"}],
    Cell[250423, 8875, 662, 15, 37, "Message",
      CellTags->{
      "Developer`InequalityInstance::lowpr", 
        "Experimental`ExistsRealQ::lowpr", "Experimental`ForAllRealQ::lowpr", 
        "Experimental`ImpliesRealQ::lowpr"}],
    Cell[251088, 8892, 295, 6, 24, "Notes",
      CellTags->{
      "Developer`InequalityInstance::lowpr", 
        "Experimental`ExistsRealQ::lowpr", "Experimental`ForAllRealQ::lowpr", 
        "Experimental`ImpliesRealQ::lowpr"}]},
  "Experimental`ImpliesRealQ::lowpr"->{
    Cell[250076, 8865, 344, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::lowpr", 
        "Experimental`ExistsRealQ::lowpr", "Experimental`ForAllRealQ::lowpr", 
        "Experimental`ImpliesRealQ::lowpr"}],
    Cell[250423, 8875, 662, 15, 37, "Message",
      CellTags->{
      "Developer`InequalityInstance::lowpr", 
        "Experimental`ExistsRealQ::lowpr", "Experimental`ForAllRealQ::lowpr", 
        "Experimental`ImpliesRealQ::lowpr"}],
    Cell[251088, 8892, 295, 6, 24, "Notes",
      CellTags->{
      "Developer`InequalityInstance::lowpr", 
        "Experimental`ExistsRealQ::lowpr", "Experimental`ForAllRealQ::lowpr", 
        "Experimental`ImpliesRealQ::lowpr"}]},
  "General::real"->{
    Cell[251420, 8903, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::real"],
    Cell[251502, 8906, 746, 17, 69, "Message",
      CellTags->"General::real"],
    Cell[252251, 8925, 129, 4, 24, "Notes",
      CellTags->"General::real"]},
  "General::sign"->{
    Cell[252417, 8934, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sign"],
    Cell[252499, 8937, 425, 11, 53, "Message",
      CellTags->"General::sign"],
    Cell[252927, 8950, 324, 9, 46, "Notes",
      CellTags->"General::sign"],
    Cell[253276, 8963, 63, 1, 38, "ExampleSection",
      CellTags->"General::sign"],
    Cell[253342, 8966, 346, 8, 56, "Text",
      CellTags->"General::sign"],
    Cell[253713, 8978, 170, 5, 26, "Input",
      CellTags->"General::sign"],
    Cell[253886, 8985, 358, 7, 102, "Message",
      CellTags->"General::sign"],
    Cell[254247, 8994, 91, 3, 21, "Output",
      CellTags->"General::sign"]},
  "NSolve::sfail"->{
    Cell[254399, 9004, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NSolve::sfail"],
    Cell[254481, 9007, 386, 7, 85, "Message",
      CellTags->"NSolve::sfail"],
    Cell[254870, 9016, 124, 4, 24, "Notes",
      CellTags->"NSolve::sfail"]},
  "NSolve::zerosol"->{
    Cell[255031, 9025, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NSolve::zerosol"],
    Cell[255117, 9028, 332, 6, 69, "Message",
      CellTags->"NSolve::zerosol"],
    Cell[255452, 9036, 126, 4, 24, "Notes",
      CellTags->"NSolve::zerosol"]},
  "NumericQ::set"->{
    Cell[255615, 9045, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NumericQ::set"],
    Cell[255697, 9048, 228, 5, 37, "Message",
      CellTags->"NumericQ::set"],
    Cell[255928, 9055, 317, 10, 40, "Notes",
      CellTags->"NumericQ::set"],
    Cell[256270, 9069, 63, 1, 38, "ExampleSection",
      CellTags->"NumericQ::set"],
    Cell[256336, 9072, 214, 8, 24, "Text",
      CellTags->"NumericQ::set"],
    Cell[256575, 9084, 110, 3, 26, "Input",
      CellTags->"NumericQ::set"],
    Cell[256688, 9089, 250, 5, 41, "Message",
      CellTags->"NumericQ::set"],
    Cell[256953, 9097, 165, 4, 24, "Text",
      CellTags->"NumericQ::set"],
    Cell[257143, 9105, 103, 3, 26, "Input",
      CellTags->"NumericQ::set"],
    Cell[257249, 9110, 90, 3, 24, "Output",
      CellTags->"NumericQ::set"],
    Cell[257376, 9118, 107, 3, 26, "Input",
      CellTags->"NumericQ::set"],
    Cell[257486, 9123, 91, 3, 21, "Output",
      CellTags->"NumericQ::set"],
    Cell[257592, 9129, 139, 4, 24, "Text",
      CellTags->"NumericQ::set"],
    Cell[257756, 9137, 93, 3, 26, "Input",
      CellTags->"NumericQ::set"],
    Cell[257852, 9142, 106, 3, 21, "Output",
      CellTags->"NumericQ::set"],
    Cell[257995, 9150, 105, 3, 26, "Input",
      CellTags->"NumericQ::set"],
    Cell[258103, 9155, 91, 3, 21, "Output",
      CellTags->"NumericQ::set"],
    Cell[258209, 9161, 83, 1, 24, "Text",
      CellTags->"NumericQ::set"],
    Cell[258295, 9164, 120, 3, 26, "Input",
      CellTags->"NumericQ::set"]},
  "NumericQ::unset"->{
    Cell[258464, 9173, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NumericQ::unset"],
    Cell[258550, 9176, 187, 4, 21, "Message",
      CellTags->"NumericQ::unset"],
    Cell[258740, 9182, 464, 16, 46, "Notes",
      CellTags->"NumericQ::unset"],
    Cell[259229, 9202, 65, 1, 38, "ExampleSection",
      CellTags->"NumericQ::unset"],
    Cell[259297, 9205, 172, 5, 24, "Text",
      CellTags->"NumericQ::unset"],
    Cell[259494, 9214, 109, 3, 26, "Input",
      CellTags->"NumericQ::unset"],
    Cell[259606, 9219, 216, 5, 37, "Message",
      CellTags->"NumericQ::unset"],
    Cell[259837, 9227, 145, 5, 24, "Text",
      CellTags->"NumericQ::unset"],
    Cell[259985, 9234, 106, 3, 26, "Input",
      CellTags->"NumericQ::unset"]},
  "NRoots::nnumeq"->{
    Cell[260140, 9243, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NRoots::nnumeq"],
    Cell[260224, 9246, 229, 5, 37, "Message",
      CellTags->"NRoots::nnumeq"],
    Cell[260456, 9253, 244, 7, 24, "Notes",
      CellTags->"NRoots::nnumeq"],
    Cell[260725, 9264, 64, 1, 38, "ExampleSection",
      CellTags->"NRoots::nnumeq"],
    Cell[260792, 9267, 178, 5, 24, "Text",
      CellTags->"NRoots::nnumeq"],
    Cell[260995, 9276, 112, 3, 26, "Input",
      CellTags->"NRoots::nnumeq"],
    Cell[261110, 9281, 290, 6, 39, "Message",
      CellTags->"NRoots::nnumeq"],
    Cell[261403, 9289, 114, 3, 23, "Output",
      CellTags->"NRoots::nnumeq"],
    Cell[261532, 9295, 127, 5, 24, "Text",
      CellTags->"NRoots::nnumeq"],
    Cell[261684, 9304, 123, 3, 26, "Input",
      CellTags->"NRoots::nnumeq"],
    Cell[261810, 9309, 283, 6, 21, "Output",
      CellTags->"NRoots::nnumeq"]},
  "Experimental`$EqualTolerance::tolset"->{
    Cell[262154, 9322, 220, 6, 51, "ObjectNameWarningMessages",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}],
    Cell[262377, 9330, 418, 12, 37, "Message",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}],
    Cell[262798, 9344, 362, 9, 40, "Notes",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}],
    Cell[263185, 9357, 136, 3, 38, "ExampleSection",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}],
    Cell[263324, 9362, 289, 9, 24, "Text",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}],
    Cell[263638, 9375, 194, 5, 26, "Input",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}],
    Cell[263835, 9382, 337, 7, 53, "Message",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}]},
  "Experimental`$SameQTolerance::tolset"->{
    Cell[262154, 9322, 220, 6, 51, "ObjectNameWarningMessages",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}],
    Cell[262377, 9330, 418, 12, 37, "Message",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}],
    Cell[262798, 9344, 362, 9, 40, "Notes",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}],
    Cell[263185, 9357, 136, 3, 38, "ExampleSection",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}],
    Cell[263324, 9362, 289, 9, 24, "Text",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}],
    Cell[263638, 9375, 194, 5, 26, "Input",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}],
    Cell[263835, 9382, 337, 7, 53, "Message",
      CellTags->{
      "Experimental`$EqualTolerance::tolset", 
        "Experimental`$SameQTolerance::tolset"}]},
  "Developer`InequalityInstance::wkno"->{
    Cell[264233, 9396, 336, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
        "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}],
    
    Cell[264572, 9406, 608, 13, 85, "Message",
      CellTags->{
      "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
        "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}],
    
    Cell[265183, 9421, 258, 6, 24, "Notes",
      CellTags->{
      "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
        "Experimental`ForAllRealQ::wkno", 
        "Experimental`ImpliesRealQ::wkno"}]},
  "Experimental`ExistsRealQ::wkno"->{
    Cell[264233, 9396, 336, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
        "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}],
    
    Cell[264572, 9406, 608, 13, 85, "Message",
      CellTags->{
      "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
        "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}],
    
    Cell[265183, 9421, 258, 6, 24, "Notes",
      CellTags->{
      "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
        "Experimental`ForAllRealQ::wkno", 
        "Experimental`ImpliesRealQ::wkno"}]},
  "Experimental`ForAllRealQ::wkno"->{
    Cell[264233, 9396, 336, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
        "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}],
    
    Cell[264572, 9406, 608, 13, 85, "Message",
      CellTags->{
      "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
        "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}],
    
    Cell[265183, 9421, 258, 6, 24, "Notes",
      CellTags->{
      "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
        "Experimental`ForAllRealQ::wkno", 
        "Experimental`ImpliesRealQ::wkno"}]},
  "Experimental`ImpliesRealQ::wkno"->{
    Cell[264233, 9396, 336, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
        "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}],
    
    Cell[264572, 9406, 608, 13, 85, "Message",
      CellTags->{
      "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
        "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}],
    
    Cell[265183, 9421, 258, 6, 24, "Notes",
      CellTags->{
      "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
        "Experimental`ForAllRealQ::wkno", 
        "Experimental`ImpliesRealQ::wkno"}]},
  "FromContinuedFraction::root"->{
    Cell[265478, 9432, 107, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FromContinuedFraction::root"],
    Cell[265588, 9435, 231, 4, 37, "Message",
      CellTags->"FromContinuedFraction::root"],
    Cell[265822, 9441, 138, 4, 24, "Notes",
      CellTags->"FromContinuedFraction::root"]},
  "Interpolation::per"->{
    Cell[265997, 9450, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::per", "ListInterpolation::per"}],
    Cell[266148, 9456, 331, 8, 37, "Message",
      CellTags->{"Interpolation::per", "ListInterpolation::per"}],
    Cell[266482, 9466, 157, 4, 24, "Notes",
      CellTags->{"Interpolation::per", "ListInterpolation::per"}]},
  "ListInterpolation::per"->{
    Cell[265997, 9450, 148, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interpolation::per", "ListInterpolation::per"}],
    Cell[266148, 9456, 331, 8, 37, "Message",
      CellTags->{"Interpolation::per", "ListInterpolation::per"}],
    Cell[266482, 9466, 157, 4, 24, "Notes",
      CellTags->{"Interpolation::per", "ListInterpolation::per"}]},
  "N::arg"->{
    Cell[266676, 9475, 65, 1, 31, "ObjectNameWarningMessages",
      CellTags->"N::arg"],
    Cell[266744, 9478, 163, 3, 21, "Message",
      CellTags->"N::arg"],
    Cell[266910, 9483, 117, 4, 24, "Notes",
      CellTags->"N::arg"]},
  "NIntegrate::singd"->{
    Cell[267064, 9492, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NIntegrate::singd"],
    Cell[267154, 9495, 338, 6, 69, "Message",
      CellTags->"NIntegrate::singd"],
    Cell[267495, 9503, 128, 4, 24, "Notes",
      CellTags->"NIntegrate::singd"]},
  "System`Private`NRoot::bdst"->{
    Cell[267660, 9512, 105, 1, 31, "ObjectNameWarningMessages",
      CellTags->"System`Private`NRoot::bdst"],
    Cell[267768, 9515, 212, 3, 37, "Message",
      CellTags->"System`Private`NRoot::bdst"],
    Cell[267983, 9520, 137, 4, 24, "Notes",
      CellTags->"System`Private`NRoot::bdst"]},
  "System`Private`NRoot::nnum"->{
    Cell[268157, 9529, 105, 1, 31, "ObjectNameWarningMessages",
      CellTags->"System`Private`NRoot::nnum"],
    Cell[268265, 9532, 181, 3, 21, "Message",
      CellTags->"System`Private`NRoot::nnum"],
    Cell[268449, 9537, 137, 4, 24, "Notes",
      CellTags->"System`Private`NRoot::nnum"]},
  "System`Private`NRRoot::bpa"->{
    Cell[268623, 9546, 105, 1, 31, "ObjectNameWarningMessages",
      CellTags->"System`Private`NRRoot::bpa"],
    Cell[268731, 9549, 201, 3, 21, "Message",
      CellTags->"System`Private`NRRoot::bpa"],
    Cell[268935, 9554, 137, 4, 24, "Notes",
      CellTags->"System`Private`NRRoot::bpa"]},
  "System`Private`NRRoot::bfac"->{
    Cell[269109, 9563, 107, 1, 31, "ObjectNameWarningMessages",
      CellTags->"System`Private`NRRoot::bfac"],
    Cell[269219, 9566, 268, 4, 37, "Message",
      CellTags->"System`Private`NRRoot::bfac"],
    Cell[269490, 9572, 138, 4, 24, "Notes",
      CellTags->"System`Private`NRRoot::bfac"]},
  "NSolve::closesols"->{
    Cell[269665, 9581, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NSolve::closesols"],
    Cell[269755, 9584, 371, 7, 53, "Message",
      CellTags->"NSolve::closesols"],
    Cell[270129, 9593, 128, 4, 24, "Notes",
      CellTags->"NSolve::closesols"]},
  "NSolve::illcnd"->{
    Cell[270294, 9602, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NSolve::illcnd"],
    Cell[270378, 9605, 394, 7, 53, "Message",
      CellTags->"NSolve::illcnd"],
    Cell[270775, 9614, 125, 4, 24, "Notes",
      CellTags->"NSolve::illcnd"]},
  "NSolve::nsolprec"->{
    Cell[270937, 9623, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NSolve::nsolprec"],
    Cell[271025, 9626, 225, 4, 37, "Message",
      CellTags->"NSolve::nsolprec"],
    Cell[271253, 9632, 127, 4, 24, "Notes",
      CellTags->"NSolve::nsolprec"]},
  "NSolve::infsolns"->{
    Cell[271417, 9641, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"NSolve::infsolns"],
    Cell[271505, 9644, 250, 5, 37, "Message",
      CellTags->"NSolve::infsolns"],
    Cell[271758, 9651, 127, 4, 24, "Notes",
      CellTags->"NSolve::infsolns"]},
  "Experimental`CreateNumericalFunction::largd"->{
    Cell[271922, 9660, 141, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::largd"],
    Cell[272066, 9664, 270, 5, 37, "Message",
      CellTags->"Experimental`CreateNumericalFunction::largd"],
    Cell[272339, 9671, 154, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::largd"]},
  "Experimental`CreateNumericalFunction::dlist"->{
    Cell[272530, 9680, 141, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::dlist"],
    Cell[272674, 9684, 242, 4, 37, "Message",
      CellTags->"Experimental`CreateNumericalFunction::dlist"],
    Cell[272919, 9690, 154, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::dlist"]},
  "Experimental`CreateNumericalFunction::largs"->{
    Cell[273110, 9699, 141, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::largs"],
    Cell[273254, 9703, 272, 5, 37, "Message",
      CellTags->"Experimental`CreateNumericalFunction::largs"],
    Cell[273529, 9710, 154, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::largs"]},
  "Experimental`CreateNumericalFunction::nosamp"->{
    Cell[273720, 9719, 143, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::nosamp"],
    Cell[273866, 9723, 244, 4, 37, "Message",
      CellTags->"Experimental`CreateNumericalFunction::nosamp"],
    Cell[274113, 9729, 155, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::nosamp"]},
  "Experimental`CreateNumericalFunction::scdims"->{
    Cell[274305, 9738, 143, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::scdims"],
    Cell[274451, 9742, 278, 5, 53, "Message",
      CellTags->"Experimental`CreateNumericalFunction::scdims"],
    Cell[274732, 9749, 155, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::scdims"]},
  "Experimental`CreateNumericalFunction::srect"->{
    Cell[274924, 9758, 141, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::srect"],
    Cell[275068, 9762, 275, 5, 53, "Message",
      CellTags->"Experimental`CreateNumericalFunction::srect"],
    Cell[275346, 9769, 154, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::srect"]},
  "Experimental`CreateNumericalFunction::pval"->{
    Cell[275537, 9778, 137, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::pval"],
    Cell[275677, 9781, 244, 4, 37, "Message",
      CellTags->"Experimental`CreateNumericalFunction::pval"],
    Cell[275924, 9787, 153, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::pval"]},
  "Experimental`CreateNumericalFunction::pdim"->{
    Cell[276114, 9796, 137, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::pdim"],
    Cell[276254, 9799, 305, 5, 53, "Message",
      CellTags->"Experimental`CreateNumericalFunction::pdim"],
    Cell[276562, 9806, 153, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::pdim"]},
  "Experimental`CreateNumericalFunction::dimsl"->{
    Cell[276752, 9815, 141, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::dimsl"],
    Cell[276896, 9819, 271, 5, 37, "Message",
      CellTags->"Experimental`CreateNumericalFunction::dimsl"],
    Cell[277170, 9826, 154, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::dimsl"]},
  "Experimental`CreateNumericalFunction::ardims"->{
    Cell[277361, 9835, 143, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::ardims"],
    Cell[277507, 9839, 357, 6, 69, "Message",
      CellTags->"Experimental`CreateNumericalFunction::ardims"],
    Cell[277867, 9847, 155, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::ardims"]},
  "Experimental`CreateNumericalFunction::jg"->{
    Cell[278059, 9856, 133, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::jg"],
    Cell[278195, 9859, 261, 5, 37, "Message",
      CellTags->"Experimental`CreateNumericalFunction::jg"],
    Cell[278459, 9866, 151, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::jg"]},
  "Experimental`CreateNumericalFunction::arglist"->{
    Cell[278647, 9875, 145, 2, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::arglist"],
    Cell[278795, 9879, 302, 5, 53, "Message",
      CellTags->"Experimental`CreateNumericalFunction::arglist"],
    Cell[279100, 9886, 156, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::arglist"]},
  "Experimental`CreateNumericalFunction::msym"->{
    Cell[279293, 9895, 137, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::msym"],
    Cell[279433, 9898, 241, 4, 37, "Message",
      CellTags->"Experimental`CreateNumericalFunction::msym"],
    Cell[279677, 9904, 153, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::msym"]},
  "Experimental`CreateNumericalFunction::rdim"->{
    Cell[279867, 9913, 137, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::rdim"],
    Cell[280007, 9916, 299, 5, 53, "Message",
      CellTags->"Experimental`CreateNumericalFunction::rdim"],
    Cell[280309, 9923, 153, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::rdim"]},
  "Gradient::smeth"->{
    Cell[280499, 9932, 161, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Gradient::smeth", "Jacobian::smeth", "Hessian::smeth"}],
    Cell[280663, 9939, 505, 12, 69, "Message",
      CellTags->{"Gradient::smeth", "Hessian::smeth", "Jacobian::smeth"}],
    Cell[281171, 9953, 165, 4, 24, "Notes",
      CellTags->{"Gradient::smeth", "Jacobian::smeth", "Hessian::smeth"}]},
  "Jacobian::smeth"->{
    Cell[280499, 9932, 161, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Gradient::smeth", "Jacobian::smeth", "Hessian::smeth"}],
    Cell[280663, 9939, 505, 12, 69, "Message",
      CellTags->{"Gradient::smeth", "Hessian::smeth", "Jacobian::smeth"}],
    Cell[281171, 9953, 165, 4, 24, "Notes",
      CellTags->{"Gradient::smeth", "Jacobian::smeth", "Hessian::smeth"}]},
  "Hessian::smeth"->{
    Cell[280499, 9932, 161, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Gradient::smeth", "Jacobian::smeth", "Hessian::smeth"}],
    Cell[280663, 9939, 505, 12, 69, "Message",
      CellTags->{"Gradient::smeth", "Hessian::smeth", "Jacobian::smeth"}],
    Cell[281171, 9953, 165, 4, 24, "Notes",
      CellTags->{"Gradient::smeth", "Jacobian::smeth", "Hessian::smeth"}]},
  "Gradient::spopt"->{
    Cell[281373, 9962, 161, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}],
    Cell[281537, 9969, 397, 9, 37, "Message",
      CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}],
    Cell[281937, 9980, 165, 4, 24, "Notes",
      CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}]},
  "Jacobian::spopt"->{
    Cell[281373, 9962, 161, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}],
    Cell[281537, 9969, 397, 9, 37, "Message",
      CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}],
    Cell[281937, 9980, 165, 4, 24, "Notes",
      CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}]},
  "Hessian::spopt"->{
    Cell[281373, 9962, 161, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}],
    Cell[281537, 9969, 397, 9, 37, "Message",
      CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}],
    Cell[281937, 9980, 165, 4, 24, "Notes",
      CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}]},
  "Product::div"->{
    Cell[282139, 9989, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Product::div"],
    Cell[282219, 9992, 141, 3, 21, "Message",
      CellTags->"Product::div"],
    Cell[282363, 9997, 123, 4, 24, "Notes",
      CellTags->"Product::div"]},
  "Experimental`NumberScale::num"->{
    Cell[282523, 10006, 111, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Experimental`NumberScale::num"],
    Cell[282637, 10009, 183, 3, 21, "Message",
      CellTags->"Experimental`NumberScale::num"],
    Cell[282823, 10014, 140, 4, 24, "Notes",
      CellTags->"Experimental`NumberScale::num"]},
  "Sum::gener"->{
    Cell[283000, 10023, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Sum::gener"],
    Cell[283076, 10026, 139, 3, 21, "Message",
      CellTags->"Sum::gener"],
    Cell[283218, 10031, 121, 4, 24, "Notes",
      CellTags->"Sum::gener"]},
  "Total::tlauto"->{
    Cell[283376, 10040, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Total::tlauto"],
    Cell[283458, 10043, 295, 6, 69, "Message",
      CellTags->"Total::tlauto"],
    Cell[283756, 10051, 124, 4, 24, "Notes",
      CellTags->"Total::tlauto"]},
  "Total::tlep"->{
    Cell[283917, 10060, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Total::tlep"],
    Cell[283995, 10063, 223, 5, 37, "Message",
      CellTags->"Total::tlep"],
    Cell[284221, 10070, 122, 4, 24, "Notes",
      CellTags->"Total::tlep"]},
  "Total::tlmth"->{
    Cell[284380, 10079, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Total::tlmth"],
    Cell[284460, 10082, 219, 5, 37, "Message",
      CellTags->"Total::tlmth"],
    Cell[284682, 10089, 123, 4, 24, "Notes",
      CellTags->"Total::tlmth"]},
  "Total::tllen"->{
    Cell[284842, 10098, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Total::tllen"],
    Cell[284922, 10101, 167, 3, 21, "Message",
      CellTags->"Total::tllen"],
    Cell[285092, 10106, 123, 4, 24, "Notes",
      CellTags->"Total::tllen"]},
  "General::idid"->{
    Cell[285252, 10115, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::idid"],
    Cell[285334, 10118, 281, 8, 37, "Message",
      CellTags->"General::idid"],
    Cell[285618, 10128, 124, 4, 24, "Notes",
      CellTags->"General::idid"]},
  "General::wprec"->{
    Cell[285779, 10137, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::wprec"],
    Cell[285863, 10140, 318, 8, 37, "Message",
      CellTags->"General::wprec"],
    Cell[286184, 10150, 125, 4, 24, "Notes",
      CellTags->"General::wprec"]},
  "General::agpginf"->{
    Cell[286346, 10159, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::agpginf"],
    Cell[286434, 10162, 385, 9, 53, "Message",
      CellTags->"General::agpginf"],
    Cell[286822, 10173, 127, 4, 24, "Notes",
      CellTags->"General::agpginf"]},
  "General::tma"->{
    Cell[286986, 10182, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::tma"],
    Cell[287066, 10185, 436, 10, 53, "Message",
      CellTags->"General::tma"],
    Cell[287505, 10197, 110, 4, 24, "Notes",
      CellTags->"General::tma"]},
  "InterpolatingFunction::cmpile"->{
    Cell[287652, 10206, 111, 1, 31, "ObjectNameWarningMessages",
      CellTags->"InterpolatingFunction::cmpile"],
    Cell[287766, 10209, 305, 5, 53, "Message",
      CellTags->"InterpolatingFunction::cmpile"],
    Cell[288074, 10216, 209, 6, 24, "Notes",
      CellTags->"InterpolatingFunction::cmpile"]},
  "ListInterpolation::ingrdm"->{
    Cell[288320, 10227, 103, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ListInterpolation::ingrdm"],
    Cell[288426, 10230, 302, 5, 53, "Message",
      CellTags->"ListInterpolation::ingrdm"],
    Cell[288731, 10237, 205, 5, 40, "Notes",
      CellTags->"ListInterpolation::ingrdm"],
    Cell[288961, 10246, 75, 1, 38, "ExampleSection",
      CellTags->"ListInterpolation::ingrdm"],
    Cell[289039, 10249, 210, 5, 40, "Text",
      CellTags->"ListInterpolation::ingrdm"],
    Cell[289274, 10258, 143, 3, 26, "Input",
      CellTags->"ListInterpolation::ingrdm"],
    Cell[289420, 10263, 299, 6, 53, "Message",
      CellTags->"ListInterpolation::ingrdm"],
    Cell[289722, 10271, 144, 3, 21, "Output",
      CellTags->"ListInterpolation::ingrdm"],
    Cell[289881, 10277, 160, 5, 24, "Text",
      CellTags->"ListInterpolation::ingrdm"],
    Cell[290066, 10286, 145, 3, 26, "Input",
      CellTags->"ListInterpolation::ingrdm"],
    Cell[290214, 10291, 180, 5, 21, "Output",
      CellTags->"ListInterpolation::ingrdm"]},
  "General::nlnum"->{
    Cell[290455, 10303, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nlnum"],
    Cell[290539, 10306, 303, 8, 37, "Message",
      CellTags->"General::nlnum"],
    Cell[290845, 10316, 125, 4, 24, "Notes",
      CellTags->"General::nlnum"]},
  "General::nlnum1"->{
    Cell[291007, 10325, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nlnum1"],
    Cell[291093, 10328, 318, 8, 37, "Message",
      CellTags->"General::nlnum1"],
    Cell[291414, 10338, 126, 4, 24, "Notes",
      CellTags->"General::nlnum1"]},
  "General::njnum"->{
    Cell[291577, 10347, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::njnum"],
    Cell[291661, 10350, 331, 10, 21, "Message",
      CellTags->"General::njnum"],
    Cell[291995, 10362, 556, 10, 78, "Notes",
      CellTags->"General::njnum"],
    Cell[292576, 10376, 64, 1, 38, "ExampleSection",
      CellTags->"General::njnum"],
    Cell[292643, 10379, 182, 4, 40, "Text",
      CellTags->"General::njnum"],
    Cell[292850, 10387, 134, 3, 26, "Input",
      CellTags->"General::njnum"],
    Cell[292987, 10392, 255, 5, 37, "Message",
      CellTags->"General::njnum"],
    Cell[293245, 10399, 103, 3, 21, "Output",
      CellTags->"General::njnum"],
    Cell[293363, 10405, 179, 7, 24, "Text",
      CellTags->"General::njnum"],
    Cell[293567, 10416, 168, 4, 26, "Input",
      CellTags->"General::njnum"],
    Cell[293738, 10422, 119, 3, 21, "Output",
      CellTags->"General::njnum"]},
  "General::njnum1"->{
    Cell[293918, 10432, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::njnum1"],
    Cell[294004, 10435, 347, 10, 37, "Message",
      CellTags->"General::njnum1"],
    Cell[294354, 10447, 126, 4, 24, "Notes",
      CellTags->"General::njnum1"]},
  "General::nhnum"->{
    Cell[294517, 10456, 81, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::nhnum"],
    Cell[294601, 10459, 330, 10, 21, "Message",
      CellTags->"General::nhnum"],
    Cell[294934, 10471, 125, 4, 24, "Notes",
      CellTags->"General::nhnum"]},
  "General::nhnum1"->{
    Cell[295096, 10480, 83, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::nhnum1"],
    Cell[295182, 10483, 346, 10, 37, "Message",
      CellTags->"General::nhnum1"],
    Cell[295531, 10495, 126, 4, 24, "Notes",
      CellTags->"General::nhnum1"]},
  "General::nrnum"->{
    Cell[295694, 10504, 81, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::nrnum"],
    Cell[295778, 10507, 273, 7, 21, "Message",
      CellTags->"General::nrnum"],
    Cell[296054, 10516, 125, 4, 24, "Notes",
      CellTags->"General::nrnum"]},
  "General::nrnum1"->{
    Cell[296216, 10525, 83, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::nrnum1"],
    Cell[296302, 10528, 290, 8, 37, "Message",
      CellTags->"General::nrnum1"],
    Cell[296595, 10538, 126, 4, 24, "Notes",
      CellTags->"General::nrnum1"]},
  "General::nrlnum"->{
    Cell[296758, 10547, 83, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::nrlnum"],
    Cell[296844, 10550, 311, 8, 37, "Message",
      CellTags->"General::nrlnum"],
    Cell[297158, 10560, 126, 4, 24, "Notes",
      CellTags->"General::nrlnum"]},
  "General::nrlnum1"->{
    Cell[297321, 10569, 85, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::nrlnum1"],
    Cell[297409, 10572, 326, 8, 37, "Message",
      CellTags->"General::nrlnum1"],
    Cell[297738, 10582, 127, 4, 24, "Notes",
      CellTags->"General::nrlnum1"]},
  "General::nrgnum"->{
    Cell[297902, 10591, 83, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::nrgnum"],
    Cell[297988, 10594, 338, 10, 21, "Message",
      CellTags->"General::nrgnum"],
    Cell[298329, 10606, 126, 4, 24, "Notes",
      CellTags->"General::nrgnum"]},
  "General::nrgnum1"->{
    Cell[298492, 10615, 85, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::nrgnum1"],
    Cell[298580, 10618, 366, 11, 37, "Message",
      CellTags->"General::nrgnum1"],
    Cell[298949, 10631, 127, 4, 24, "Notes",
      CellTags->"General::nrgnum1"]},
  "General::nrjnum"->{
    Cell[299113, 10640, 83, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::nrjnum"],
    Cell[299199, 10643, 338, 10, 21, "Message",
      CellTags->"General::nrjnum"],
    Cell[299540, 10655, 126, 4, 24, "Notes",
      CellTags->"General::nrjnum"]},
  "General::nrjnum1"->{
    Cell[299703, 10664, 85, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::nrjnum1"],
    Cell[299791, 10667, 354, 10, 37, "Message",
      CellTags->"General::nrjnum1"],
    Cell[300148, 10679, 127, 4, 24, "Notes",
      CellTags->"General::nrjnum1"]},
  "General::nrhnum"->{
    Cell[300312, 10688, 83, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::nrhnum"],
    Cell[300398, 10691, 337, 10, 21, "Message",
      CellTags->"General::nrhnum"],
    Cell[300738, 10703, 126, 4, 24, "Notes",
      CellTags->"General::nrhnum"]},
  "General::nrhnum1"->{
    Cell[300901, 10712, 85, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::nrhnum1"],
    Cell[300989, 10715, 353, 10, 37, "Message",
      CellTags->"General::nrhnum1"],
    Cell[301345, 10727, 127, 4, 24, "Notes",
      CellTags->"General::nrhnum1"]},
  "General::preal"->{
    Cell[301509, 10736, 81, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::preal"],
    Cell[301593, 10739, 373, 11, 21, "Message",
      CellTags->"General::preal"],
    Cell[301969, 10752, 125, 4, 24, "Notes",
      CellTags->"General::preal"]},
  "General::symd"->{
    Cell[302131, 10761, 79, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::symd"],
    Cell[302213, 10764, 398, 10, 53, "Message",
      CellTags->"General::symd"],
    Cell[302614, 10776, 124, 4, 24, "Notes",
      CellTags->"General::symd"]},
  "General::symd1"->{
    Cell[302775, 10785, 81, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::symd1"],
    Cell[302859, 10788, 358, 9, 37, "Message",
      CellTags->"General::symd1"],
    Cell[303220, 10799, 125, 4, 24, "Notes",
      CellTags->"General::symd1"]},
  "General::symdv"->{
    Cell[303382, 10808, 81, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::symdv"],
    Cell[303466, 10811, 381, 9, 53, "Message",
      CellTags->"General::symdv"],
    Cell[303850, 10822, 125, 4, 24, "Notes",
      CellTags->"General::symdv"]},
  "General::symfd"->{
    Cell[304012, 10831, 81, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::symfd"],
    Cell[304096, 10834, 396, 9, 53, "Message",
      CellTags->"General::symfd"],
    Cell[304495, 10845, 125, 4, 24, "Notes",
      CellTags->"General::symfd"]},
  "General::vardep"->{
    Cell[304657, 10854, 83, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::vardep"],
    Cell[304743, 10857, 347, 8, 37, "Message",
      CellTags->"General::vardep"],
    Cell[305093, 10867, 126, 4, 24, "Notes",
      CellTags->"General::vardep"]},
  "General::vloc"->{
    Cell[305256, 10876, 79, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::vloc"],
    Cell[305338, 10879, 300, 8, 37, "Message",
      CellTags->"General::vloc"],
    Cell[305641, 10889, 124, 4, 24, "Notes",
      CellTags->"General::vloc"]},
  "General::vexdep"->{
    Cell[305802, 10898, 83, 1, 25, "ObjectNameWarningMessages",
      CellTags->"General::vexdep"],
    Cell[305888, 10901, 355, 8, 37, "Message",
      CellTags->"General::vexdep"],
    Cell[306246, 10911, 126, 4, 24, "Notes",
      CellTags->"General::vexdep"]},
  "Experimental`CreateNumericalFunction::neargs"->{
    Cell[306409, 10920, 143, 2, 25, "ObjectNameWarningMessages",
      CellTags->"Experimental`CreateNumericalFunction::neargs"],
    Cell[306555, 10924, 272, 5, 37, "Message",
      CellTags->"Experimental`CreateNumericalFunction::neargs"],
    Cell[306830, 10931, 155, 4, 24, "Notes",
      CellTags->"Experimental`CreateNumericalFunction::neargs"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Roots::eqn", 307673, 10956},
  {"NRoots::eqn", 308701, 10979},
  {"Roots::neq", 309728, 11002},
  {"NRoots::neq", 310760, 11025},
  {"General::meprec", 311796, 11048},
  {"$MaxExtraPrecision::meprecset", 313026, 11079},
  {"$MaxPrecision::precset", 313733, 11094},
  {"$MinPrecision::precset", 314476, 11111},
  {"$MinPrecision::preccon", 315219, 11128},
  {"$MaxPrecision::preccon", 316528, 11151},
  {"$MinPrecision::preclck", 317837, 11174},
  {"$MaxPrecision::preclck", 318232, 11181},
  {"NIntegrate::lzero", 318622, 11188},
  {"NSum::nsnum", 319315, 11205},
  {"NIntegrate::ncvi", 319964, 11222},
  {"NSum::nslim", 320731, 11241},
  {"NIntegrate::noeval", 321601, 11264},
  {"NIntegrate::nlim", 323134, 11301},
  {"NIntegrate::vars", 324871, 11344},
  {"RealDigits::ndig", 325808, 11367},
  {"RealDigits::rbase", 326745, 11390},
  {"MantissaExponent::rbase", 328462, 11421},
  {"NProduct::istep", 330171, 11452},
  {"NSum::istep", 331281, 11475},
  {"Accuracy::mnprec", 332396, 11498},
  {"Precision::mnprec", 333695, 11523},
  {"Accuracy::mxprec", 334993, 11548},
  {"Precision::mxprec", 336290, 11573},
  {"Fourier::fftl", 337583, 11598},
  {"InverseFourier::fftl", 338778, 11621},
  {"FromDigits::nlst", 339969, 11644},
  {"FunctionInterpolation::argdim", 340917, 11667},
  {"FunctionInterpolation::precg", 342389, 11698},
  {"FunctionInterpolation::range", 343470, 11721},
  {"FunctionInterpolation::accg", 344550, 11744},
  {"FunctionInterpolation::nreal", 345620, 11767},
  {"FunctionInterpolation::npts", 346608, 11788},
  {"FunctionInterpolation::ncvb", 346939, 11795},
  {"Interpolation::inlen", 348097, 11820},
  {"NIntegrate::mccnv", 348396, 11827},
  {"General::precbd", 349342, 11850},
  {"General::preclg", 350504, 11879},
  {"General::precsm", 351747, 11910},
  {"$MaxPrecision::prec", 352995, 11941},
  {"IntegerDigits::ibase", 353968, 11964},
  {"IntegerExponent::ibase", 356386, 12007},
  {"InterpolatingFunction::dmval", 358810, 12050},
  {"InterpolatingFunction::dmvali", 360260, 12081},
  {"InterpolatingFunction::dprec", 361912, 12116},
  {"Interpolation::inauto", 363549, 12151},
  {"ListInterpolation::inauto", 364905, 12174},
  {"Interpolation::incon", 366256, 12197},
  {"ListInterpolation::incon", 368770, 12258},
  {"InterpolatingFunction::incon", 371288, 12319},
  {"Interpolation::indat", 373798, 12380},
  {"ListInterpolation::indat", 375476, 12409},
  {"Interpolation::indatg", 377151, 12438},
  {"ListInterpolation::indatg", 378506, 12461},
  {"Interpolation::inddp", 379856, 12484},
  {"ListInterpolation::inddp", 381188, 12507},
  {"Interpolation::indep", 382516, 12530},
  {"ListInterpolation::indep", 384376, 12575},
  {"InterpolatingFunction::indep", 386240, 12620},
  {"Interpolation::inder", 388096, 12665},
  {"ListInterpolation::inder", 390119, 12700},
  {"Interpolation::indim", 392138, 12735},
  {"Interpolation::indimt", 393136, 12758},
  {"ListInterpolation::indimt", 393544, 12765},
  {"Interpolation::inhr", 393946, 12772},
  {"ListInterpolation::inhr", 396896, 12845},
  {"InterpolatingFunction::inhr", 399850, 12918},
  {"Interpolation::innd", 402796, 12991},
  {"ListInterpolation::innd", 403765, 13008},
  {"Interpolation::inord", 404731, 13025},
  {"ListInterpolation::inord", 406591, 13070},
  {"FunctionInterpolation::inord", 408455, 13115},
  {"Interpolation::inpts", 410311, 13160},
  {"Interpolation::mixedp", 411308, 13183},
  {"ListInterpolation::mixedp", 413725, 13224},
  {"Interval::nvld", 416131, 13265},
  {"RealDigits::realx", 416415, 13272},
  {"MantissaExponent::realx", 417701, 13295},
  {"NumericalMath`$NumberBits::realx", 418996, 13318},
  {"General::accg", 420216, 13343},
  {"NIntegrate::bdmtd", 421132, 13366},
  {"NIntegrate::comp", 422089, 13389},
  {"NIntegrate::ierr", 423036, 13412},
  {"NIntegrate::inovf", 423984, 13435},
  {"NIntegrate::inum", 424277, 13442},
  {"NIntegrate::minmax", 425227, 13465},
  {"NIntegrate::nconv", 426198, 13488},
  {"NIntegrate::ncvb", 426490, 13495},
  {"NIntegrate::ncvs", 427523, 13520},
  {"NIntegrate::ninf", 428228, 13537},
  {"NIntegrate::nintp", 428935, 13554},
  {"NIntegrate::oscfm", 429399, 13565},
  {"NIntegrate::oscint", 430359, 13588},
  {"NIntegrate::osran", 430656, 13595},
  {"NIntegrate::osrn", 431614, 13618},
  {"NIntegrate::ploss", 432805, 13647},
  {"General::precg", 433762, 13670},
  {"NIntegrate::rnderr", 434690, 13693},
  {"NIntegrate::slwcon", 434988, 13700},
  {"NProduct::emcon", 436041, 13725},
  {"NSum::emcon", 436374, 13732},
  {"NProduct::itfn", 436710, 13739},
  {"NProduct::nplim", 437634, 13762},
  {"NProduct::npnum", 438568, 13785},
  {"NProduct::npst", 439502, 13808},
  {"NProduct::npz", 440424, 13831},
  {"NRoots::nomod", 440703, 13838},
  {"NSum::itfn", 440977, 13845},
  {"NSum::nsst", 441849, 13868},
  {"NSum::nsumz", 442724, 13891},
  {"SequenceLimit::seqlim", 443004, 13898},
  {"SequenceLimit::seqw", 444097, 13923},
  {"SequenceLimit::wynn", 445081, 13946},
  {"SetAccuracy::accbd", 446062, 13969},
  {"SetAccuracy::acclg", 446359, 13976},
  {"SetAccuracy::accsm", 446656, 13983},
  {"Sum::div", 446943, 13990},
  {"General::precw", 447206, 13997},
  {"General::unfl", 449001, 14042},
  {"General::ovfl", 450617, 14083},
  {"ContinuedFraction::noterms", 452091, 14120},
  {"ContinuedFraction::incomp", 453158, 14143},
  {"ContinuedFraction::terms", 454213, 14166},
  {"ContinuedFraction::start", 455257, 14189},
  {"Fourier::fpopt", 456564, 14218},
  {"InverseFourier::fpopt", 457794, 14241},
  {"Fourier::fpopt2", 459018, 14264},
  {"InverseFourier::fpopt2", 460273, 14287},
  {"Fourier::fpoptn", 461521, 14310},
  {"InverseFourier::fpoptn", 462774, 14333},
  {"General::lrgexp", 464020, 14356},
  {"Developer`InequalityInstance::lowpr", 464736, 14373},
  {"Experimental`ExistsRealQ::lowpr", 465498, 14389},
  {"Experimental`ForAllRealQ::lowpr", 466260, 14405},
  {"Experimental`ImpliesRealQ::lowpr", 467023, 14421},
  {"General::real", 467767, 14437},
  {"General::sign", 468045, 14444},
  {"NSolve::sfail", 468723, 14461},
  {"NSolve::zerosol", 469002, 14468},
  {"NumericQ::set", 469285, 14475},
  {"NumericQ::unset", 470818, 14514},
  {"NRoots::nnumeq", 471591, 14533},
  {"Experimental`$EqualTolerance::tolset", 472536, 14556},
  {"Experimental`$SameQTolerance::tolset", 473727, 14585},
  {"Developer`InequalityInstance::wkno", 474916, 14614},
  {"Experimental`ExistsRealQ::wkno", 475657, 14630},
  {"Experimental`ForAllRealQ::wkno", 476398, 14646},
  {"Experimental`ImpliesRealQ::wkno", 477140, 14662},
  {"FromContinuedFraction::root", 477878, 14678},
  {"Interpolation::per", 478203, 14685},
  {"ListInterpolation::per", 478589, 14692},
  {"N::arg", 478959, 14699},
  {"NIntegrate::singd", 479219, 14706},
  {"System`Private`NRoot::bdst", 479521, 14713},
  {"System`Private`NRoot::nnum", 479851, 14720},
  {"System`Private`NRRoot::bpa", 480181, 14727},
  {"System`Private`NRRoot::bfac", 480512, 14734},
  {"NSolve::closesols", 480836, 14741},
  {"NSolve::illcnd", 481126, 14748},
  {"NSolve::nsolprec", 481409, 14755},
  {"NSolve::infsolns", 481698, 14762},
  {"Experimental`CreateNumericalFunction::largd", 482014, 14769},
  {"Experimental`CreateNumericalFunction::dlist", 482412, 14776},
  {"Experimental`CreateNumericalFunction::largs", 482810, 14783},
  {"Experimental`CreateNumericalFunction::nosamp", 483209, 14790},
  {"Experimental`CreateNumericalFunction::scdims", 483611, 14797},
  {"Experimental`CreateNumericalFunction::srect", 484012, 14804},
  {"Experimental`CreateNumericalFunction::pval", 484409, 14811},
  {"Experimental`CreateNumericalFunction::pdim", 484803, 14818},
  {"Experimental`CreateNumericalFunction::dimsl", 485198, 14825},
  {"Experimental`CreateNumericalFunction::ardims", 485597, 14832},
  {"Experimental`CreateNumericalFunction::jg", 485995, 14839},
  {"Experimental`CreateNumericalFunction::arglist", 486386, 14846},
  {"Experimental`CreateNumericalFunction::msym", 486789, 14853},
  {"Experimental`CreateNumericalFunction::rdim", 487183, 14860},
  {"Gradient::smeth", 487550, 14867},
  {"Jacobian::smeth", 487954, 14874},
  {"Hessian::smeth", 488357, 14881},
  {"Gradient::spopt", 488761, 14888},
  {"Jacobian::spopt", 489164, 14895},
  {"Hessian::spopt", 489566, 14902},
  {"Product::div", 489966, 14909},
  {"Experimental`NumberScale::num", 490256, 14916},
  {"Sum::gener", 490582, 14923},
  {"Total::tlauto", 490853, 14930},
  {"Total::tlep", 491131, 14937},
  {"Total::tlmth", 491404, 14944},
  {"Total::tllen", 491680, 14951},
  {"General::idid", 491957, 14958},
  {"General::wprec", 492238, 14965},
  {"General::agpginf", 492524, 14972},
  {"General::tma", 492812, 14979},
  {"InterpolatingFunction::cmpile", 493106, 14986},
  {"ListInterpolation::ingrdm", 493447, 14993},
  {"General::nlnum", 494503, 15016},
  {"General::nlnum1", 494788, 15023},
  {"General::njnum", 495075, 15030},
  {"General::njnum1", 496012, 15053},
  {"General::nhnum", 496300, 15060},
  {"General::nhnum1", 496586, 15067},
  {"General::nrnum", 496874, 15074},
  {"General::nrnum1", 497159, 15081},
  {"General::nrlnum", 497447, 15088},
  {"General::nrlnum1", 497736, 15095},
  {"General::nrgnum", 498027, 15102},
  {"General::nrgnum1", 498317, 15109},
  {"General::nrjnum", 498609, 15116},
  {"General::nrjnum1", 498899, 15123},
  {"General::nrhnum", 499191, 15130},
  {"General::nrhnum1", 499481, 15137},
  {"General::preal", 499772, 15144},
  {"General::symd", 500056, 15151},
  {"General::symd1", 500338, 15158},
  {"General::symdv", 500622, 15165},
  {"General::symfd", 500906, 15172},
  {"General::vardep", 501191, 15179},
  {"General::vloc", 501477, 15186},
  {"General::vexdep", 501759, 15193},
  {"Experimental`CreateNumericalFunction::neargs", 502076, 15200}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 38, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1839, 57, 110, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],
Cell[1952, 63, 360, 11, 19, "Message",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],
Cell[2315, 76, 451, 15, 46, "Notes",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],

Cell[CellGroupData[{
Cell[2791, 95, 77, 1, 38, "ExampleSection",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],
Cell[2871, 98, 101, 1, 24, "Text",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],

Cell[CellGroupData[{
Cell[2997, 103, 124, 3, 26, "Input",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],
Cell[3124, 108, 195, 4, 21, "Message",
  CellTags->{"NRoots::eqn", "Roots::eqn"}],
Cell[3322, 114, 126, 3, 27, "Output",
  CellTags->{"NRoots::eqn", "Roots::eqn"}]
}, Closed]],
Cell[3463, 120, 137, 4, 24, "Text",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],

Cell[CellGroupData[{
Cell[3625, 128, 129, 3, 26, "Input",
  CellTags->{"Roots::eqn", "NRoots::eqn"}],
Cell[3757, 133, 129, 3, 25, "Output",
  CellTags->{"NRoots::eqn", "Roots::eqn"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3947, 143, 110, 4, 45, "ObjectNameWarningMessages",
  CellTags->{"Roots::neq", "NRoots::neq"}],
Cell[4060, 149, 492, 14, 19, "Message",
  CellTags->{"Roots::neq", "NRoots::neq"}],
Cell[4555, 165, 385, 9, 62, "Notes",
  CellTags->{"Roots::neq", "NRoots::neq"}],

Cell[CellGroupData[{
Cell[4965, 178, 77, 1, 38, "ExampleSection",
  CellTags->{"Roots::neq", "NRoots::neq"}],
Cell[5045, 181, 172, 5, 24, "Text",
  CellTags->{"Roots::neq", "NRoots::neq"}],

Cell[CellGroupData[{
Cell[5242, 190, 126, 3, 26, "Input",
  CellTags->{"Roots::neq", "NRoots::neq"}],
Cell[5371, 195, 233, 5, 24, "Message",
  CellTags->{"NRoots::neq", "Roots::neq"}],
Cell[5607, 202, 133, 3, 26, "Output",
  CellTags->{"NRoots::neq", "Roots::neq"}]
}, Closed]],
Cell[5755, 208, 143, 5, 24, "Text",
  CellTags->{"Roots::neq", "NRoots::neq"}],

Cell[CellGroupData[{
Cell[5923, 217, 126, 3, 26, "Input",
  CellTags->{"Roots::neq", "NRoots::neq"}],
Cell[6052, 222, 116, 3, 21, "Output",
  CellTags->{"NRoots::neq", "Roots::neq"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6229, 232, 83, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::meprec"],
Cell[6315, 235, 511, 16, 37, "Message",
  CellTags->"General::meprec"],
Cell[6829, 253, 950, 18, 160, "Notes",
  CellTags->"General::meprec"],

Cell[CellGroupData[{
Cell[7804, 275, 65, 1, 38, "ExampleSection",
  CellTags->"General::meprec"],
Cell[7872, 278, 368, 10, 56, "Text",
  CellTags->"General::meprec"],

Cell[CellGroupData[{
Cell[8265, 292, 118, 3, 26, "Input",
  CellTags->"General::meprec"],
Cell[8386, 297, 300, 6, 53, "Message",
  CellTags->"General::meprec"],
Cell[8689, 305, 115, 3, 21, "Output",
  CellTags->"General::meprec"]
}, Closed]],
Cell[8819, 311, 266, 7, 40, "Text",
  CellTags->"General::meprec"],

Cell[CellGroupData[{
Cell[9110, 322, 135, 3, 26, "Input",
  CellTags->"General::meprec"],
Cell[9248, 327, 335, 6, 70, "Message",
  CellTags->"General::meprec"],
Cell[9586, 335, 142, 3, 36, "Output",
  CellTags->"General::meprec"]
}, Closed]],
Cell[9743, 341, 191, 7, 24, "Text",
  CellTags->"General::meprec"],

Cell[CellGroupData[{
Cell[9959, 352, 182, 4, 42, "Input",
  CellTags->"General::meprec"],
Cell[10144, 358, 93, 3, 21, "Output",
  CellTags->"General::meprec"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[10298, 368, 111, 1, 25, "ObjectNameWarningMessages",
  CellTags->"$MaxExtraPrecision::meprecset"],
Cell[10412, 371, 340, 6, 37, "Message",
  CellTags->"$MaxExtraPrecision::meprecset"],
Cell[10755, 379, 226, 5, 24, "Notes",
  CellTags->"$MaxExtraPrecision::meprecset"],

Cell[CellGroupData[{
Cell[11006, 388, 79, 1, 38, "ExampleSection",
  CellTags->"$MaxExtraPrecision::meprecset"],
Cell[11088, 391, 357, 10, 40, "Text",
  CellTags->"$MaxExtraPrecision::meprecset"],

Cell[CellGroupData[{
Cell[11470, 405, 145, 3, 26, "Input",
  CellTags->"$MaxExtraPrecision::meprecset"],
Cell[11618, 410, 278, 5, 53, "Message",
  CellTags->"$MaxExtraPrecision::meprecset"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11957, 422, 97, 1, 25, "ObjectNameWarningMessages",
  CellTags->"$MaxPrecision::precset"],
Cell[12057, 425, 434, 11, 37, "Message",
  CellTags->"$MaxPrecision::precset"],
Cell[12494, 438, 185, 5, 24, "Notes",
  CellTags->"$MaxPrecision::precset"],

Cell[CellGroupData[{
Cell[12704, 447, 72, 1, 38, "ExampleSection",
  CellTags->"$MaxPrecision::precset"],
Cell[12779, 450, 234, 7, 40, "Text",
  CellTags->"$MaxPrecision::precset"],

Cell[CellGroupData[{
Cell[13038, 461, 130, 3, 26, "Input",
  CellTags->"$MaxPrecision::precset"],
Cell[13171, 466, 255, 5, 53, "Message",
  CellTags->"$MaxPrecision::precset"],
Cell[13429, 473, 111, 3, 21, "Output",
  CellTags->"$MaxPrecision::precset"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[13601, 483, 97, 1, 25, "ObjectNameWarningMessages",
  CellTags->"$MinPrecision::precset"],
Cell[13701, 486, 453, 11, 37, "Message",
  CellTags->"$MinPrecision::precset"],
Cell[14157, 499, 185, 5, 24, "Notes",
  CellTags->"$MinPrecision::precset"],

Cell[CellGroupData[{
Cell[14367, 508, 72, 1, 38, "ExampleSection",
  CellTags->"$MinPrecision::precset"],
Cell[14442, 511, 237, 7, 40, "Text",
  CellTags->"$MinPrecision::precset"],

Cell[CellGroupData[{
Cell[14704, 522, 130, 3, 26, "Input",
  CellTags->"$MinPrecision::precset"],
Cell[14837, 527, 255, 5, 53, "Message",
  CellTags->"$MinPrecision::precset"],
Cell[15095, 534, 111, 3, 21, "Output",
  CellTags->"$MinPrecision::precset"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15267, 544, 156, 4, 45, "ObjectNameWarningMessages",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
Cell[15426, 550, 462, 12, 21, "Message",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
Cell[15891, 564, 509, 15, 62, "Notes",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],

Cell[CellGroupData[{
Cell[16425, 583, 100, 1, 38, "ExampleSection",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
Cell[16528, 586, 196, 6, 24, "Text",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],

Cell[CellGroupData[{
Cell[16749, 596, 192, 4, 26, "Input",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
Cell[16944, 602, 253, 5, 37, "Message",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
Cell[17200, 609, 131, 3, 21, "Output",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}]
}, Closed]],
Cell[17346, 615, 216, 7, 24, "Text",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],

Cell[CellGroupData[{
Cell[17587, 626, 192, 4, 26, "Input",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}],
Cell[17782, 632, 131, 3, 21, "Output",
  CellTags->{"$MinPrecision::preccon", "$MaxPrecision::preccon"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[17974, 642, 156, 4, 45, "ObjectNameWarningMessages",
  CellTags->{"$MinPrecision::preclck", "$MaxPrecision::preclck"}],
Cell[18133, 648, 557, 13, 37, "Message",
  CellTags->{"$MinPrecision::preclck", "$MaxPrecision::preclck"}],
Cell[18693, 663, 812, 16, 116, "Notes",
  CellTags->{"$MinPrecision::preclck", "$MaxPrecision::preclck"}]
}, Closed]],

Cell[CellGroupData[{
Cell[19542, 684, 87, 1, 25, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::lzero"],
Cell[19632, 687, 215, 4, 53, "Message",
  CellTags->"NIntegrate::lzero"],
Cell[19850, 693, 915, 28, 116, "Notes",
  CellTags->"NIntegrate::lzero"],

Cell[CellGroupData[{
Cell[20790, 725, 67, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::lzero"],
Cell[20860, 728, 194, 6, 24, "Text",
  CellTags->"NIntegrate::lzero"],

Cell[CellGroupData[{
Cell[21079, 738, 180, 4, 42, "Input",
  CellTags->"NIntegrate::lzero"],
Cell[21262, 744, 244, 5, 53, "Message",
  CellTags->"NIntegrate::lzero"],
Cell[21509, 751, 197, 4, 21, "Output",
  CellTags->"NIntegrate::lzero"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[21767, 762, 75, 1, 25, "ObjectNameWarningMessages",
  CellTags->"NSum::nsnum"],
Cell[21845, 765, 420, 12, 21, "Message",
  CellTags->"NSum::nsnum"],
Cell[22268, 779, 232, 6, 40, "Notes",
  CellTags->"NSum::nsnum"],

Cell[CellGroupData[{
Cell[22525, 789, 61, 1, 38, "ExampleSection",
  CellTags->"NSum::nsnum"],
Cell[22589, 792, 134, 5, 24, "Text",
  CellTags->"NSum::nsnum"],

Cell[CellGroupData[{
Cell[22748, 801, 103, 3, 26, "Input",
  CellTags->"NSum::nsnum"],
Cell[22854, 806, 216, 5, 37, "Message",
  CellTags->"NSum::nsnum"],
Cell[23073, 813, 104, 3, 21, "Output",
  CellTags->"NSum::nsnum"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[23238, 823, 85, 1, 25, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::ncvi"],
Cell[23326, 826, 538, 13, 37, "Message",
  CellTags->"NIntegrate::ncvi"],
Cell[23867, 841, 901, 21, 132, "Notes",
  CellTags->"NIntegrate::ncvi"],

Cell[CellGroupData[{
Cell[24793, 866, 66, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::ncvi"],
Cell[24862, 869, 145, 4, 24, "Text",
  CellTags->"NIntegrate::ncvi"],

Cell[CellGroupData[{
Cell[25032, 877, 161, 4, 26, "Input",
  CellTags->"NIntegrate::ncvi"],
Cell[25196, 883, 415, 7, 85, "Message",
  CellTags->"NIntegrate::ncvi"],
Cell[25614, 892, 285, 6, 53, "Message",
  CellTags->"NIntegrate::ncvi"],
Cell[25902, 900, 115, 3, 21, "Output",
  CellTags->"NIntegrate::ncvi"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[26078, 910, 75, 1, 25, "ObjectNameWarningMessages",
  CellTags->"NSum::nslim"],
Cell[26156, 913, 242, 5, 21, "Message",
  CellTags->"NSum::nslim"],
Cell[26401, 920, 198, 6, 24, "Notes",
  CellTags->"NSum::nslim"],

Cell[CellGroupData[{
Cell[26624, 930, 61, 1, 38, "ExampleSection",
  CellTags->"NSum::nslim"],
Cell[26688, 933, 214, 5, 40, "Text",
  CellTags->"NSum::nslim"],

Cell[CellGroupData[{
Cell[26927, 942, 99, 3, 26, "Input",
  CellTags->"NSum::nslim"],
Cell[27029, 947, 173, 4, 21, "Message",
  CellTags->"NSum::nslim"],
Cell[27205, 953, 100, 3, 21, "Output",
  CellTags->"NSum::nslim"]
}, Closed]],
Cell[27320, 959, 120, 5, 24, "Text",
  CellTags->"NSum::nslim"],

Cell[CellGroupData[{
Cell[27465, 968, 100, 3, 26, "Input",
  CellTags->"NSum::nslim"],
Cell[27568, 973, 87, 3, 21, "Output",
  CellTags->"NSum::nslim"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[27716, 983, 89, 1, 25, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::noeval"],
Cell[27808, 986, 317, 6, 53, "Message",
  CellTags->"NIntegrate::noeval"],
Cell[28128, 994, 635, 15, 100, "Notes",
  CellTags->"NIntegrate::noeval"],

Cell[CellGroupData[{
Cell[28788, 1013, 68, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::noeval"],
Cell[28859, 1016, 185, 5, 24, "Text",
  CellTags->"NIntegrate::noeval"],

Cell[CellGroupData[{
Cell[29069, 1025, 164, 4, 26, "Input",
  CellTags->"NIntegrate::noeval"],
Cell[29236, 1031, 288, 6, 69, "Message",
  CellTags->"NIntegrate::noeval"],
Cell[29527, 1039, 175, 4, 36, "Output",
  CellTags->"NIntegrate::noeval"]
}, Closed]],
Cell[29717, 1046, 186, 7, 24, "Text",
  CellTags->"NIntegrate::noeval"],

Cell[CellGroupData[{
Cell[29928, 1057, 161, 4, 26, "Input",
  CellTags->"NIntegrate::noeval"],
Cell[30092, 1063, 111, 3, 21, "Output",
  CellTags->"NIntegrate::noeval"]
}, Closed]],
Cell[30218, 1069, 257, 7, 40, "Text",
  CellTags->"NIntegrate::noeval"],

Cell[CellGroupData[{
Cell[30500, 1080, 153, 4, 26, "Input",
  CellTags->"NIntegrate::noeval"],
Cell[30656, 1086, 288, 6, 69, "Message",
  CellTags->"NIntegrate::noeval"],
Cell[30947, 1094, 169, 4, 36, "Output",
  CellTags->"NIntegrate::noeval"]
}, Closed]],
Cell[31131, 1101, 221, 5, 40, "Text",
  CellTags->"NIntegrate::noeval"],

Cell[CellGroupData[{
Cell[31377, 1110, 136, 3, 26, "Input",
  CellTags->"NIntegrate::noeval"],
Cell[31516, 1115, 153, 4, 23, "Output",
  CellTags->"NIntegrate::noeval"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[31730, 1126, 85, 1, 25, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::nlim"],
Cell[31818, 1129, 402, 11, 21, "Message",
  CellTags->"NIntegrate::nlim"],
Cell[32223, 1142, 197, 6, 24, "Notes",
  CellTags->"NIntegrate::nlim"],

Cell[CellGroupData[{
Cell[32445, 1152, 66, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::nlim"],
Cell[32514, 1155, 229, 6, 40, "Text",
  CellTags->"NIntegrate::nlim"],

Cell[CellGroupData[{
Cell[32768, 1165, 121, 3, 26, "Input",
  CellTags->"NIntegrate::nlim"],
Cell[32892, 1170, 194, 4, 21, "Message",
  CellTags->"NIntegrate::nlim"],
Cell[33089, 1176, 134, 3, 21, "Output",
  CellTags->"NIntegrate::nlim"]
}, Closed]],
Cell[33238, 1182, 131, 5, 24, "Text",
  CellTags->"NIntegrate::nlim"],

Cell[CellGroupData[{
Cell[33394, 1191, 121, 3, 26, "Input",
  CellTags->"NIntegrate::nlim"],
Cell[33518, 1196, 108, 3, 21, "Output",
  CellTags->"NIntegrate::nlim"]
}, Closed]],
Cell[33641, 1202, 177, 4, 40, "Text",
  CellTags->"NIntegrate::nlim"],

Cell[CellGroupData[{
Cell[33843, 1210, 127, 3, 26, "Input",
  CellTags->"NIntegrate::nlim"],
Cell[33973, 1215, 209, 5, 21, "Message",
  CellTags->"NIntegrate::nlim"],
Cell[34185, 1222, 128, 3, 21, "Output",
  CellTags->"NIntegrate::nlim"]
}, Closed]],
Cell[34328, 1228, 233, 5, 40, "Text",
  CellTags->"NIntegrate::nlim"],
Cell[34564, 1235, 138, 3, 26, "Input",
  CellTags->"NIntegrate::nlim"],

Cell[CellGroupData[{
Cell[34727, 1242, 93, 3, 26, "Input",
  CellTags->"NIntegrate::nlim"],
Cell[34823, 1247, 108, 3, 21, "Output",
  CellTags->"NIntegrate::nlim"]
}, Closed]],
Cell[34946, 1253, 113, 5, 24, "Text",
  CellTags->"NIntegrate::nlim"],
Cell[35062, 1260, 109, 3, 26, "Input",
  CellTags->"NIntegrate::nlim"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[35220, 1269, 85, 1, 25, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::vars"],
Cell[35308, 1272, 312, 6, 37, "Message",
  CellTags->"NIntegrate::vars"],
Cell[35623, 1280, 480, 10, 62, "Notes",
  CellTags->"NIntegrate::vars"],

Cell[CellGroupData[{
Cell[36128, 1294, 66, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::vars"],
Cell[36197, 1297, 173, 5, 24, "Text",
  CellTags->"NIntegrate::vars"],

Cell[CellGroupData[{
Cell[36395, 1306, 113, 3, 26, "Input",
  CellTags->"NIntegrate::vars"],
Cell[36511, 1311, 222, 5, 37, "Message",
  CellTags->"NIntegrate::vars"],
Cell[36736, 1318, 126, 3, 21, "Output",
  CellTags->"NIntegrate::vars"]
}, Closed]],
Cell[36877, 1324, 131, 5, 24, "Text",
  CellTags->"NIntegrate::vars"],

Cell[CellGroupData[{
Cell[37033, 1333, 121, 3, 26, "Input",
  CellTags->"NIntegrate::vars"],
Cell[37157, 1338, 108, 3, 21, "Output",
  CellTags->"NIntegrate::vars"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[37326, 1348, 85, 1, 25, "ObjectNameWarningMessages",
  CellTags->"RealDigits::ndig"],
Cell[37414, 1351, 180, 3, 21, "Message",
  CellTags->"RealDigits::ndig"],
Cell[37597, 1356, 339, 8, 62, "Notes",
  CellTags->"RealDigits::ndig"],

Cell[CellGroupData[{
Cell[37961, 1368, 66, 1, 38, "ExampleSection",
  CellTags->"RealDigits::ndig"],
Cell[38030, 1371, 178, 5, 24, "Text",
  CellTags->"RealDigits::ndig"],

Cell[CellGroupData[{
Cell[38233, 1380, 108, 3, 26, "Input",
  CellTags->"RealDigits::ndig"],
Cell[38344, 1385, 192, 4, 21, "Message",
  CellTags->"RealDigits::ndig"],
Cell[38539, 1391, 110, 3, 21, "Output",
  CellTags->"RealDigits::ndig"]
}, Closed]],
Cell[38664, 1397, 131, 5, 24, "Text",
  CellTags->"RealDigits::ndig"],

Cell[CellGroupData[{
Cell[38820, 1406, 111, 3, 26, "Input",
  CellTags->"RealDigits::ndig"],
Cell[38934, 1411, 272, 5, 37, "Output",
  CellTags->"RealDigits::ndig"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[39267, 1423, 148, 4, 45, "ObjectNameWarningMessages",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
Cell[39418, 1429, 356, 10, 21, "Message",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
Cell[39777, 1441, 287, 7, 40, "Notes",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell[CellGroupData[{
Cell[40089, 1452, 96, 1, 38, "ExampleSection",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
Cell[40188, 1455, 136, 1, 24, "Text",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell[CellGroupData[{
Cell[40349, 1460, 138, 3, 26, "Input",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
Cell[40490, 1465, 220, 4, 21, "Message",
  CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}],
Cell[40713, 1471, 140, 3, 21, "Output",
  CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}]
}, Closed]],
Cell[40868, 1477, 184, 5, 24, "Text",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell[CellGroupData[{
Cell[41077, 1486, 138, 3, 26, "Input",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
Cell[41218, 1491, 302, 5, 37, "Output",
  CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}]
}, Closed]],
Cell[41535, 1499, 206, 5, 24, "Text",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],

Cell[CellGroupData[{
Cell[41766, 1508, 154, 3, 26, "Input",
  CellTags->{"RealDigits::rbase", "MantissaExponent::rbase"}],
Cell[41923, 1513, 236, 5, 37, "Message",
  CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}],
Cell[42162, 1520, 154, 3, 21, "Output",
  CellTags->{"MantissaExponent::rbase", "RealDigits::rbase"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[42377, 1530, 120, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NProduct::istep", "NSum::istep"}],
Cell[42500, 1536, 433, 13, 21, "Message",
  CellTags->{"NProduct::istep", "NSum::istep"}],
Cell[42936, 1551, 568, 18, 46, "Notes",
  CellTags->{"NProduct::istep", "NSum::istep"}],

Cell[CellGroupData[{
Cell[43529, 1573, 82, 1, 38, "ExampleSection",
  CellTags->{"NProduct::istep", "NSum::istep"}],
Cell[43614, 1576, 268, 9, 24, "Text",
  CellTags->{"NProduct::istep", "NSum::istep"}],

Cell[CellGroupData[{
Cell[43907, 1589, 143, 3, 26, "Input",
  CellTags->{"NProduct::istep", "NSum::istep"}],
Cell[44053, 1594, 221, 5, 21, "Message",
  CellTags->{"NProduct::istep", "NSum::istep"}],
Cell[44277, 1601, 146, 3, 36, "Output",
  CellTags->{"NProduct::istep", "NSum::istep"}]
}, Closed]],
Cell[44438, 1607, 203, 7, 24, "Text",
  CellTags->{"NProduct::istep", "NSum::istep"}],

Cell[CellGroupData[{
Cell[44666, 1618, 179, 5, 26, "Input",
  CellTags->{"NProduct::istep", "NSum::istep"}],
Cell[44848, 1625, 151, 3, 21, "Output",
  CellTags->{"NProduct::istep", "NSum::istep"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[45060, 1635, 134, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
Cell[45197, 1641, 393, 11, 37, "Message",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
Cell[45593, 1654, 810, 22, 100, "Notes",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],

Cell[CellGroupData[{
Cell[46428, 1680, 89, 1, 38, "ExampleSection",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
Cell[46520, 1683, 201, 5, 24, "Text",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],

Cell[CellGroupData[{
Cell[46746, 1692, 207, 4, 90, "Input",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
Cell[46956, 1698, 259, 5, 37, "Message",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
Cell[47218, 1705, 117, 3, 21, "Output",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}]
}, Closed]],
Cell[47350, 1711, 128, 1, 24, "Text",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],

Cell[CellGroupData[{
Cell[47503, 1716, 140, 3, 26, "Input",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
Cell[47646, 1721, 259, 5, 37, "Message",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}],
Cell[47908, 1728, 133, 3, 23, "Output",
  CellTags->{"Accuracy::mnprec", "Precision::mnprec"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[48102, 1738, 134, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
Cell[48239, 1744, 362, 10, 37, "Message",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
Cell[48604, 1756, 314, 9, 40, "Notes",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],

Cell[CellGroupData[{
Cell[48943, 1769, 89, 1, 38, "ExampleSection",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
Cell[49035, 1772, 264, 6, 40, "Text",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],

Cell[CellGroupData[{
Cell[49324, 1782, 158, 3, 26, "Input",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
Cell[49485, 1787, 259, 5, 37, "Message",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
Cell[49747, 1794, 117, 3, 21, "Output",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}]
}, Closed]],
Cell[49879, 1800, 120, 1, 24, "Text",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],

Cell[CellGroupData[{
Cell[50024, 1805, 168, 3, 26, "Input",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
Cell[50195, 1810, 258, 5, 37, "Message",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}],
Cell[50456, 1817, 121, 3, 21, "Output",
  CellTags->{"Accuracy::mxprec", "Precision::mxprec"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[50638, 1827, 134, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
Cell[50775, 1833, 384, 11, 37, "Message",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
Cell[51162, 1846, 254, 7, 24, "Notes",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],

Cell[CellGroupData[{
Cell[51441, 1857, 89, 1, 38, "ExampleSection",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
Cell[51533, 1860, 176, 4, 24, "Text",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],

Cell[CellGroupData[{
Cell[51734, 1868, 131, 3, 26, "Input",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
Cell[51868, 1873, 255, 5, 37, "Message",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
Cell[52126, 1880, 132, 3, 21, "Output",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}]
}, Closed]],
Cell[52273, 1886, 149, 5, 24, "Text",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],

Cell[CellGroupData[{
Cell[52447, 1895, 137, 3, 26, "Input",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}],
Cell[52587, 1900, 249, 5, 21, "Output",
  CellTags->{"Fourier::fftl", "InverseFourier::fftl"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[52897, 1912, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FromDigits::nlst"],
Cell[52985, 1915, 251, 6, 21, "Message",
  CellTags->"FromDigits::nlst"],
Cell[53239, 1923, 170, 5, 24, "Notes",
  CellTags->"FromDigits::nlst"],

Cell[CellGroupData[{
Cell[53434, 1932, 66, 1, 38, "ExampleSection",
  CellTags->"FromDigits::nlst"],
Cell[53503, 1935, 184, 5, 24, "Text",
  CellTags->"FromDigits::nlst"],

Cell[CellGroupData[{
Cell[53712, 1944, 103, 3, 26, "Input",
  CellTags->"FromDigits::nlst"],
Cell[53818, 1949, 188, 4, 21, "Message",
  CellTags->"FromDigits::nlst"],
Cell[54009, 1955, 104, 3, 21, "Output",
  CellTags->"FromDigits::nlst"]
}, Closed]],
Cell[54128, 1961, 130, 5, 24, "Text",
  CellTags->"FromDigits::nlst"],

Cell[CellGroupData[{
Cell[54283, 1970, 107, 3, 26, "Input",
  CellTags->"FromDigits::nlst"],
Cell[54393, 1975, 92, 3, 21, "Output",
  CellTags->"FromDigits::nlst"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[54546, 1985, 111, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::argdim"],
Cell[54660, 1988, 367, 7, 53, "Message",
  CellTags->"FunctionInterpolation::argdim"],
Cell[55030, 1997, 305, 8, 40, "Notes",
  CellTags->"FunctionInterpolation::argdim"],

Cell[CellGroupData[{
Cell[55360, 2009, 79, 1, 38, "ExampleSection",
  CellTags->"FunctionInterpolation::argdim"],
Cell[55442, 2012, 223, 5, 40, "Text",
  CellTags->"FunctionInterpolation::argdim"],

Cell[CellGroupData[{
Cell[55690, 2021, 209, 5, 58, "Input",
  CellTags->"FunctionInterpolation::argdim"],
Cell[55902, 2028, 315, 6, 69, "Message",
  CellTags->"FunctionInterpolation::argdim"],
Cell[56220, 2036, 242, 5, 37, "Message",
  CellTags->"FunctionInterpolation::argdim"],
Cell[56465, 2043, 245, 5, 54, "Message",
  CellTags->"FunctionInterpolation::argdim"],
Cell[56713, 2050, 245, 5, 54, "Message",
  CellTags->"FunctionInterpolation::argdim"],
Cell[56961, 2057, 254, 5, 37, "Message",
  CellTags->"FunctionInterpolation::argdim"],
Cell[57218, 2064, 184, 5, 21, "Output",
  CellTags->"FunctionInterpolation::argdim"]
}, Closed]],
Cell[57417, 2072, 199, 7, 24, "Text",
  CellTags->"FunctionInterpolation::argdim"],

Cell[CellGroupData[{
Cell[57641, 2083, 206, 5, 42, "Input",
  CellTags->"FunctionInterpolation::argdim"],
Cell[57850, 2090, 184, 5, 21, "Output",
  CellTags->"FunctionInterpolation::argdim"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[58095, 2102, 109, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::precg"],
Cell[58207, 2105, 417, 9, 37, "Message",
  CellTags->"FunctionInterpolation::precg"],
Cell[58627, 2116, 265, 7, 40, "Notes",
  CellTags->"FunctionInterpolation::precg"],

Cell[CellGroupData[{
Cell[58917, 2127, 78, 1, 38, "ExampleSection",
  CellTags->"FunctionInterpolation::precg"],
Cell[58998, 2130, 280, 9, 40, "Text",
  CellTags->"FunctionInterpolation::precg"],

Cell[CellGroupData[{
Cell[59303, 2143, 197, 4, 42, "Input",
  CellTags->"FunctionInterpolation::precg"],
Cell[59503, 2149, 281, 5, 53, "Message",
  CellTags->"FunctionInterpolation::precg"],
Cell[59787, 2156, 208, 4, 37, "Output",
  CellTags->"FunctionInterpolation::precg"]
}, Closed]],
Cell[60010, 2163, 211, 7, 24, "Text",
  CellTags->"FunctionInterpolation::precg"],

Cell[CellGroupData[{
Cell[60246, 2174, 194, 4, 42, "Input",
  CellTags->"FunctionInterpolation::precg"],
Cell[60443, 2180, 183, 5, 21, "Output",
  CellTags->"FunctionInterpolation::precg"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[60687, 2192, 109, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::range"],
Cell[60799, 2195, 358, 8, 37, "Message",
  CellTags->"FunctionInterpolation::range"],
Cell[61160, 2205, 221, 5, 24, "Notes",
  CellTags->"FunctionInterpolation::range"],

Cell[CellGroupData[{
Cell[61406, 2214, 78, 1, 38, "ExampleSection",
  CellTags->"FunctionInterpolation::range"],
Cell[61487, 2217, 173, 4, 24, "Text",
  CellTags->"FunctionInterpolation::range"],

Cell[CellGroupData[{
Cell[61685, 2225, 135, 3, 26, "Input",
  CellTags->"FunctionInterpolation::range"],
Cell[61823, 2230, 246, 5, 37, "Message",
  CellTags->"FunctionInterpolation::range"],
Cell[62072, 2237, 136, 3, 21, "Output",
  CellTags->"FunctionInterpolation::range"]
}, Closed]],
Cell[62223, 2243, 179, 5, 24, "Text",
  CellTags->"FunctionInterpolation::range"],

Cell[CellGroupData[{
Cell[62427, 2252, 141, 3, 26, "Input",
  CellTags->"FunctionInterpolation::range"],
Cell[62571, 2257, 187, 5, 21, "Output",
  CellTags->"FunctionInterpolation::range"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[62819, 2269, 107, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::accg"],
Cell[62929, 2272, 390, 8, 37, "Message",
  CellTags->"FunctionInterpolation::accg"],
Cell[63322, 2282, 263, 7, 40, "Notes",
  CellTags->"FunctionInterpolation::accg"],

Cell[CellGroupData[{
Cell[63610, 2293, 77, 1, 38, "ExampleSection",
  CellTags->"FunctionInterpolation::accg"],
Cell[63690, 2296, 278, 9, 40, "Text",
  CellTags->"FunctionInterpolation::accg"],

Cell[CellGroupData[{
Cell[63993, 2309, 195, 4, 42, "Input",
  CellTags->"FunctionInterpolation::accg"],
Cell[64191, 2315, 261, 5, 53, "Message",
  CellTags->"FunctionInterpolation::accg"],
Cell[64455, 2322, 206, 4, 37, "Output",
  CellTags->"FunctionInterpolation::accg"]
}, Closed]],
Cell[64676, 2329, 209, 7, 24, "Text",
  CellTags->"FunctionInterpolation::accg"],

Cell[CellGroupData[{
Cell[64910, 2340, 192, 4, 42, "Input",
  CellTags->"FunctionInterpolation::accg"],
Cell[65105, 2346, 182, 5, 21, "Output",
  CellTags->"FunctionInterpolation::accg"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[65348, 2358, 109, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::nreal"],
Cell[65460, 2361, 451, 13, 37, "Message",
  CellTags->"FunctionInterpolation::nreal"],
Cell[65914, 2376, 237, 5, 40, "Notes",
  CellTags->"FunctionInterpolation::nreal"],

Cell[CellGroupData[{
Cell[66176, 2385, 78, 1, 38, "ExampleSection",
  CellTags->"FunctionInterpolation::nreal"],
Cell[66257, 2388, 169, 4, 24, "Text",
  CellTags->"FunctionInterpolation::nreal"],

Cell[CellGroupData[{
Cell[66451, 2396, 144, 3, 26, "Input",
  CellTags->"FunctionInterpolation::nreal"],
Cell[66598, 2401, 187, 5, 21, "Output",
  CellTags->"FunctionInterpolation::nreal"]
}, Closed]],
Cell[66800, 2409, 275, 7, 40, "Text",
  CellTags->"FunctionInterpolation::nreal"],

Cell[CellGroupData[{
Cell[67100, 2420, 222, 4, 42, "Input",
  CellTags->"FunctionInterpolation::nreal"],
Cell[67325, 2426, 438, 12, 37, "Output",
  CellTags->"FunctionInterpolation::nreal"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[67824, 2445, 107, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::npts"],
Cell[67934, 2448, 316, 6, 37, "Message",
  CellTags->"FunctionInterpolation::npts"],
Cell[68253, 2456, 269, 7, 40, "Notes",
  CellTags->"FunctionInterpolation::npts"]
}, Closed]],

Cell[CellGroupData[{
Cell[68559, 2468, 107, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FunctionInterpolation::ncvb"],
Cell[68669, 2471, 751, 18, 69, "Message",
  CellTags->"FunctionInterpolation::ncvb"],
Cell[69423, 2491, 790, 16, 132, "Notes",
  CellTags->"FunctionInterpolation::ncvb"],

Cell[CellGroupData[{
Cell[70238, 2511, 77, 1, 38, "ExampleSection",
  CellTags->"FunctionInterpolation::ncvb"],
Cell[70318, 2514, 203, 5, 40, "Text",
  CellTags->"FunctionInterpolation::ncvb"],

Cell[CellGroupData[{
Cell[70546, 2523, 141, 3, 26, "Input",
  CellTags->"FunctionInterpolation::ncvb"],
Cell[70690, 2528, 339, 6, 69, "Message",
  CellTags->"FunctionInterpolation::ncvb"],
Cell[71032, 2536, 346, 6, 69, "Message",
  CellTags->"FunctionInterpolation::ncvb"],
Cell[71381, 2544, 186, 5, 21, "Output",
  CellTags->"FunctionInterpolation::ncvb"]
}, Closed]],
Cell[71582, 2552, 205, 6, 24, "Text",
  CellTags->"FunctionInterpolation::ncvb"],

Cell[CellGroupData[{
Cell[71812, 2562, 162, 4, 26, "Input",
  CellTags->"FunctionInterpolation::ncvb"],
Cell[71977, 2568, 182, 5, 21, "Output",
  CellTags->"FunctionInterpolation::ncvb"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[72220, 2580, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Interpolation::inlen"],
Cell[72316, 2583, 234, 5, 37, "Message",
  CellTags->"Interpolation::inlen"],
Cell[72553, 2590, 131, 4, 24, "Notes",
  CellTags->"Interpolation::inlen"]
}, Closed]],

Cell[CellGroupData[{
Cell[72721, 2599, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::mccnv"],
Cell[72811, 2602, 197, 4, 21, "Message",
  CellTags->"NIntegrate::mccnv"],
Cell[73011, 2608, 366, 9, 62, "Notes",
  CellTags->"NIntegrate::mccnv"],

Cell[CellGroupData[{
Cell[73402, 2621, 67, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::mccnv"],
Cell[73472, 2624, 261, 6, 40, "Text",
  CellTags->"NIntegrate::mccnv"],

Cell[CellGroupData[{
Cell[73758, 2634, 143, 3, 26, "Input",
  CellTags->"NIntegrate::mccnv"],
Cell[73904, 2639, 205, 5, 37, "Message",
  CellTags->"NIntegrate::mccnv"],
Cell[74112, 2646, 111, 3, 21, "Output",
  CellTags->"NIntegrate::mccnv"]
}, Closed]],
Cell[74238, 2652, 108, 1, 24, "Text",
  CellTags->"NIntegrate::mccnv"],

Cell[CellGroupData[{
Cell[74371, 2657, 120, 3, 26, "Input",
  CellTags->"NIntegrate::mccnv"],
Cell[74494, 2662, 104, 3, 23, "Output",
  CellTags->"NIntegrate::mccnv"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[74659, 2672, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::precbd"],
Cell[74745, 2675, 382, 11, 37, "Message",
  CellTags->"General::precbd"],
Cell[75130, 2688, 386, 9, 62, "Notes",
  CellTags->"General::precbd"],

Cell[CellGroupData[{
Cell[75541, 2701, 65, 1, 38, "ExampleSection",
  CellTags->"General::precbd"],
Cell[75609, 2704, 259, 9, 40, "Text",
  CellTags->"General::precbd"],

Cell[CellGroupData[{
Cell[75893, 2717, 137, 3, 26, "Input",
  CellTags->"General::precbd"],
Cell[76033, 2722, 249, 5, 53, "Message",
  CellTags->"General::precbd"],
Cell[76285, 2729, 157, 4, 23, "Output",
  CellTags->"General::precbd"]
}, Closed]],
Cell[76457, 2736, 185, 7, 24, "Text",
  CellTags->"General::precbd"],

Cell[CellGroupData[{
Cell[76667, 2747, 130, 3, 26, "Input",
  CellTags->"General::precbd"],
Cell[76800, 2752, 214, 4, 21, "Output",
  CellTags->"General::precbd"]
}, Closed]],
Cell[77029, 2759, 186, 7, 24, "Text",
  CellTags->"General::precbd"],

Cell[CellGroupData[{
Cell[77240, 2770, 115, 3, 26, "Input",
  CellTags->"General::precbd"],
Cell[77358, 2775, 112, 3, 21, "Output",
  CellTags->"General::precbd"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[77531, 2785, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::preclg"],
Cell[77617, 2788, 666, 17, 53, "Message",
  CellTags->"General::preclg"],
Cell[78286, 2807, 894, 19, 138, "Notes",
  CellTags->"General::preclg"],

Cell[CellGroupData[{
Cell[79205, 2830, 65, 1, 38, "ExampleSection",
  CellTags->"General::preclg"],
Cell[79273, 2833, 268, 7, 40, "Text",
  CellTags->"General::preclg"],

Cell[CellGroupData[{
Cell[79566, 2844, 137, 3, 26, "Input",
  CellTags->"General::preclg"],
Cell[79706, 2849, 329, 6, 69, "Message",
  CellTags->"General::preclg"],
Cell[80038, 2857, 134, 3, 21, "Output",
  CellTags->"General::preclg"]
}, Closed]],
Cell[80187, 2863, 89, 1, 24, "Text",
  CellTags->"General::preclg"],

Cell[CellGroupData[{
Cell[80301, 2868, 138, 3, 26, "Input",
  CellTags->"General::preclg"],
Cell[80442, 2873, 165, 4, 21, "Output",
  CellTags->"General::preclg"]
}, Closed]],
Cell[80622, 2880, 141, 5, 24, "Text",
  CellTags->"General::preclg"],

Cell[CellGroupData[{
Cell[80788, 2889, 137, 3, 26, "Input",
  CellTags->"General::preclg"],
Cell[80928, 2894, 328, 6, 69, "Message",
  CellTags->"General::preclg"],
Cell[81259, 2902, 96, 3, 21, "Output",
  CellTags->"General::preclg"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[81416, 2912, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::precsm"],
Cell[81502, 2915, 446, 12, 37, "Message",
  CellTags->"General::precsm"],
Cell[81951, 2929, 877, 18, 138, "Notes",
  CellTags->"General::precsm"],

Cell[CellGroupData[{
Cell[82853, 2951, 65, 1, 38, "ExampleSection",
  CellTags->"General::precsm"],
Cell[82921, 2954, 273, 7, 40, "Text",
  CellTags->"General::precsm"],

Cell[CellGroupData[{
Cell[83219, 2965, 137, 3, 26, "Input",
  CellTags->"General::precsm"],
Cell[83359, 2970, 233, 5, 37, "Message",
  CellTags->"General::precsm"],
Cell[83595, 2977, 165, 4, 21, "Output",
  CellTags->"General::precsm"]
}, Closed]],
Cell[83775, 2984, 89, 1, 24, "Text",
  CellTags->"General::precsm"],

Cell[CellGroupData[{
Cell[83889, 2989, 137, 3, 26, "Input",
  CellTags->"General::precsm"],
Cell[84029, 2994, 133, 3, 21, "Output",
  CellTags->"General::precsm"]
}, Closed]],
Cell[84177, 3000, 141, 5, 24, "Text",
  CellTags->"General::precsm"],

Cell[CellGroupData[{
Cell[84343, 3009, 136, 3, 26, "Input",
  CellTags->"General::precsm"],
Cell[84482, 3014, 232, 5, 37, "Message",
  CellTags->"General::precsm"],
Cell[84717, 3021, 150, 4, 21, "Output",
  CellTags->"General::precsm"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[84928, 3032, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$MaxPrecision::prec"],
Cell[85022, 3035, 302, 5, 69, "Message",
  CellTags->"$MaxPrecision::prec"],
Cell[85327, 3042, 210, 6, 24, "Notes",
  CellTags->"$MaxPrecision::prec"],

Cell[CellGroupData[{
Cell[85562, 3052, 69, 1, 38, "ExampleSection",
  CellTags->"$MaxPrecision::prec"],
Cell[85634, 3055, 221, 6, 40, "Text",
  CellTags->"$MaxPrecision::prec"],

Cell[CellGroupData[{
Cell[85880, 3065, 135, 3, 26, "Input",
  CellTags->"$MaxPrecision::prec"],
Cell[86018, 3070, 362, 7, 71, "Message",
  CellTags->"$MaxPrecision::prec"],
Cell[86383, 3079, 160, 4, 23, "Output",
  CellTags->"$MaxPrecision::prec"]
}, Closed]],
Cell[86558, 3086, 161, 5, 24, "Text",
  CellTags->"$MaxPrecision::prec"],

Cell[CellGroupData[{
Cell[86744, 3095, 135, 3, 26, "Input",
  CellTags->"$MaxPrecision::prec"],
Cell[86882, 3100, 143, 3, 23, "Output",
  CellTags->"$MaxPrecision::prec"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[87086, 3110, 152, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
Cell[87241, 3116, 383, 11, 21, "Message",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
Cell[87627, 3129, 281, 7, 40, "Notes",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[CellGroupData[{
Cell[87933, 3140, 98, 1, 38, "ExampleSection",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
Cell[88034, 3143, 168, 4, 24, "Text",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[CellGroupData[{
Cell[88227, 3151, 143, 3, 26, "Input",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
Cell[88373, 3156, 225, 4, 21, "Message",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
Cell[88601, 3162, 145, 3, 21, "Output",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}]
}, Closed]],
Cell[88761, 3168, 168, 5, 24, "Text",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[CellGroupData[{
Cell[88954, 3177, 141, 3, 26, "Input",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
Cell[89098, 3182, 140, 3, 21, "Output",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}]
}, Closed]],
Cell[89253, 3188, 194, 5, 24, "Text",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[CellGroupData[{
Cell[89472, 3197, 142, 3, 26, "Input",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
Cell[89617, 3202, 432, 7, 69, "Output",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}]
}, Closed]],
Cell[90064, 3212, 235, 6, 24, "Text",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[CellGroupData[{
Cell[90324, 3222, 148, 3, 26, "Input",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
Cell[90475, 3227, 224, 4, 21, "Message",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
Cell[90702, 3233, 175, 3, 21, "Output",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}]
}, Closed]],
Cell[90892, 3239, 170, 5, 24, "Text",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],

Cell[CellGroupData[{
Cell[91087, 3248, 148, 3, 26, "Input",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}],
Cell[91238, 3253, 123, 3, 21, "Output",
  CellTags->{"IntegerDigits::ibase", "IntegerExponent::ibase"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[91422, 3263, 109, 1, 31, "ObjectNameWarningMessages",
  CellTags->"InterpolatingFunction::dmval"],
Cell[91534, 3266, 358, 7, 37, "Message",
  CellTags->"InterpolatingFunction::dmval"],
Cell[91895, 3275, 377, 7, 62, "Notes",
  CellTags->"InterpolatingFunction::dmval"],

Cell[CellGroupData[{
Cell[92297, 3286, 78, 1, 38, "ExampleSection",
  CellTags->"InterpolatingFunction::dmval"],
Cell[92378, 3289, 261, 5, 40, "Text",
  CellTags->"InterpolatingFunction::dmval"],

Cell[CellGroupData[{
Cell[92664, 3298, 172, 4, 26, "Input",
  CellTags->"InterpolatingFunction::dmval"],
Cell[92839, 3304, 187, 5, 21, "Output",
  CellTags->"InterpolatingFunction::dmval"]
}, Closed]],

Cell[CellGroupData[{
Cell[93063, 3314, 111, 3, 26, "Input",
  CellTags->"InterpolatingFunction::dmval"],
Cell[93177, 3319, 278, 5, 53, "Message",
  CellTags->"InterpolatingFunction::dmval"],
Cell[93458, 3326, 109, 3, 21, "Output",
  CellTags->"InterpolatingFunction::dmval"]
}, Closed]],
Cell[93582, 3332, 218, 5, 40, "Text",
  CellTags->"InterpolatingFunction::dmval"],

Cell[CellGroupData[{
Cell[93825, 3341, 110, 3, 26, "Input",
  CellTags->"InterpolatingFunction::dmval"],
Cell[93938, 3346, 120, 3, 21, "Output",
  CellTags->"InterpolatingFunction::dmval"]
}, Closed]],
Cell[94073, 3352, 130, 5, 24, "Text",
  CellTags->"InterpolatingFunction::dmval"],
Cell[94206, 3359, 114, 3, 26, "Input",
  CellTags->"InterpolatingFunction::dmval"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[94369, 3368, 111, 1, 31, "ObjectNameWarningMessages",
  CellTags->"InterpolatingFunction::dmvali"],
Cell[94483, 3371, 589, 12, 53, "Message",
  CellTags->"InterpolatingFunction::dmvali"],
Cell[95075, 3385, 453, 8, 78, "Notes",
  CellTags->"InterpolatingFunction::dmvali"],

Cell[CellGroupData[{
Cell[95553, 3397, 79, 1, 38, "ExampleSection",
  CellTags->"InterpolatingFunction::dmvali"],
Cell[95635, 3400, 230, 5, 40, "Text",
  CellTags->"InterpolatingFunction::dmvali"],

Cell[CellGroupData[{
Cell[95890, 3409, 152, 3, 26, "Input",
  CellTags->"InterpolatingFunction::dmvali"],
Cell[96045, 3414, 203, 5, 21, "Output",
  CellTags->"InterpolatingFunction::dmvali"]
}, Closed]],

Cell[CellGroupData[{
Cell[96285, 3424, 137, 3, 26, "Input",
  CellTags->"InterpolatingFunction::dmvali"],
Cell[96425, 3429, 321, 6, 53, "Message",
  CellTags->"InterpolatingFunction::dmvali"],
Cell[96749, 3437, 122, 3, 21, "Output",
  CellTags->"InterpolatingFunction::dmvali"]
}, Closed]],
Cell[96886, 3443, 150, 4, 24, "Text",
  CellTags->"InterpolatingFunction::dmvali"],

Cell[CellGroupData[{
Cell[97061, 3451, 155, 3, 26, "Input",
  CellTags->"InterpolatingFunction::dmvali"],
Cell[97219, 3456, 203, 5, 21, "Output",
  CellTags->"InterpolatingFunction::dmvali"]
}, Closed]],

Cell[CellGroupData[{
Cell[97459, 3466, 137, 3, 26, "Input",
  CellTags->"InterpolatingFunction::dmvali"],
Cell[97599, 3471, 127, 3, 23, "Output",
  CellTags->"InterpolatingFunction::dmvali"]
}, Closed]],
Cell[97741, 3477, 131, 5, 24, "Text",
  CellTags->"InterpolatingFunction::dmvali"],
Cell[97875, 3484, 115, 3, 26, "Input",
  CellTags->"InterpolatingFunction::dmvali"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[98039, 3493, 109, 1, 31, "ObjectNameWarningMessages",
  CellTags->"InterpolatingFunction::dprec"],
Cell[98151, 3496, 420, 9, 37, "Message",
  CellTags->"InterpolatingFunction::dprec"],
Cell[98574, 3507, 522, 11, 84, "Notes",
  CellTags->"InterpolatingFunction::dprec"],

Cell[CellGroupData[{
Cell[99121, 3522, 78, 1, 38, "ExampleSection",
  CellTags->"InterpolatingFunction::dprec"],
Cell[99202, 3525, 318, 7, 40, "Text",
  CellTags->"InterpolatingFunction::dprec"],

Cell[CellGroupData[{
Cell[99545, 3536, 193, 5, 42, "Input",
  CellTags->"InterpolatingFunction::dprec"],
Cell[99741, 3543, 195, 5, 37, "Output",
  CellTags->"InterpolatingFunction::dprec"]
}, Closed]],

Cell[CellGroupData[{
Cell[99973, 3553, 112, 3, 26, "Input",
  CellTags->"InterpolatingFunction::dprec"],
Cell[100088, 3558, 274, 5, 53, "Message",
  CellTags->"InterpolatingFunction::dprec"],
Cell[100365, 3565, 233, 6, 53, "Output",
  CellTags->"InterpolatingFunction::dprec"]
}, Closed]],
Cell[100613, 3574, 196, 5, 40, "Text",
  CellTags->"InterpolatingFunction::dprec"],

Cell[CellGroupData[{
Cell[100834, 3583, 125, 3, 26, "Input",
  CellTags->"InterpolatingFunction::dprec"],
Cell[100962, 3588, 141, 3, 21, "Output",
  CellTags->"InterpolatingFunction::dprec"]
}, Closed]],

Cell[CellGroupData[{
Cell[101140, 3596, 141, 3, 26, "Input",
  CellTags->"InterpolatingFunction::dprec"],
Cell[101284, 3601, 142, 3, 21, "Output",
  CellTags->"InterpolatingFunction::dprec"]
}, Closed]],
Cell[101441, 3607, 130, 5, 24, "Text",
  CellTags->"InterpolatingFunction::dprec"],
Cell[101574, 3614, 114, 3, 26, "Input",
  CellTags->"InterpolatingFunction::dprec"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[101737, 3623, 160, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
Cell[101900, 3629, 428, 11, 37, "Message",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
Cell[102331, 3642, 354, 10, 40, "Notes",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],

Cell[CellGroupData[{
Cell[102710, 3656, 102, 1, 38, "ExampleSection",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
Cell[102815, 3659, 217, 5, 24, "Text",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],

Cell[CellGroupData[{
Cell[103057, 3668, 151, 3, 26, "Input",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
Cell[103211, 3673, 287, 5, 53, "Message",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
Cell[103501, 3680, 152, 3, 21, "Output",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}]
}, Closed]],
Cell[103668, 3686, 173, 5, 24, "Text",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],

Cell[CellGroupData[{
Cell[103866, 3695, 172, 3, 26, "Input",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}],
Cell[104041, 3700, 207, 5, 21, "Output",
  CellTags->{"Interpolation::inauto", "ListInterpolation::inauto"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[104309, 3712, 225, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],
Cell[104537, 3721, 507, 13, 37, "Message",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],
Cell[105047, 3736, 389, 8, 46, "Notes",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],

Cell[CellGroupData[{
Cell[105461, 3748, 140, 3, 38, "ExampleSection",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],
Cell[105604, 3753, 226, 6, 24, "Text",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],

Cell[CellGroupData[{
Cell[105855, 3763, 456, 9, 90, "Input",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],
Cell[106314, 3774, 303, 7, 37, "Message",
  CellTags->{
  "InterpolatingFunction::incon", "Interpolation::incon", 
    "ListInterpolation::incon"}],
Cell[106620, 3783, 428, 8, 53, "Output",
  CellTags->{
  "InterpolatingFunction::incon", "Interpolation::incon", 
    "ListInterpolation::incon"}]
}, Closed]],
Cell[107063, 3794, 260, 7, 24, "Text",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],

Cell[CellGroupData[{
Cell[107348, 3805, 245, 6, 26, "Input",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],
Cell[107596, 3813, 545, 10, 101, "Output",
  CellTags->{
  "InterpolatingFunction::incon", "Interpolation::incon", 
    "ListInterpolation::incon"}]
}, Closed]],

Cell[CellGroupData[{
Cell[108178, 3828, 188, 5, 26, "Input",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],
Cell[108369, 3835, 253, 7, 21, "Output",
  CellTags->{
  "InterpolatingFunction::incon", "Interpolation::incon", 
    "ListInterpolation::incon"}]
}, Closed]],
Cell[108637, 3845, 196, 7, 24, "Text",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}],
Cell[108836, 3854, 180, 5, 26, "Input",
  CellTags->{
  "Interpolation::incon", "ListInterpolation::incon", 
    "InterpolatingFunction::incon"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[109065, 3865, 156, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
Cell[109224, 3871, 502, 13, 21, "Message",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
Cell[109729, 3886, 227, 5, 24, "Notes",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell[CellGroupData[{
Cell[109981, 3895, 100, 1, 38, "ExampleSection",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
Cell[110084, 3898, 179, 4, 24, "Text",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell[CellGroupData[{
Cell[110288, 3906, 174, 3, 26, "Input",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
Cell[110465, 3911, 259, 5, 37, "Message",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
Cell[110727, 3918, 175, 3, 21, "Output",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}]
}, Closed]],
Cell[110917, 3924, 166, 5, 24, "Text",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell[CellGroupData[{
Cell[111108, 3933, 174, 3, 26, "Input",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
Cell[111285, 3938, 205, 5, 21, "Output",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}]
}, Closed]],
Cell[111505, 3946, 183, 4, 24, "Text",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],

Cell[CellGroupData[{
Cell[111713, 3954, 194, 4, 26, "Input",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}],
Cell[111910, 3960, 503, 9, 175, "Output",
  CellTags->{"Interpolation::indat", "ListInterpolation::indat"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[112474, 3976, 160, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
Cell[112637, 3982, 488, 13, 21, "Message",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
Cell[113128, 3997, 212, 4, 24, "Notes",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],

Cell[CellGroupData[{
Cell[113365, 4005, 102, 1, 38, "ExampleSection",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
Cell[113470, 4008, 192, 4, 24, "Text",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],

Cell[CellGroupData[{
Cell[113687, 4016, 199, 4, 26, "Input",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
Cell[113889, 4022, 251, 5, 37, "Message",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
Cell[114143, 4029, 200, 4, 21, "Output",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}]
}, Closed]],
Cell[114358, 4036, 202, 5, 24, "Text",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],

Cell[CellGroupData[{
Cell[114585, 4045, 186, 4, 26, "Input",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}],
Cell[114774, 4051, 207, 5, 21, "Output",
  CellTags->{"Interpolation::indatg", "ListInterpolation::indatg"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[115042, 4063, 156, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
Cell[115201, 4069, 444, 12, 21, "Message",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
Cell[115648, 4083, 204, 4, 24, "Notes",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],

Cell[CellGroupData[{
Cell[115877, 4091, 100, 1, 38, "ExampleSection",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
Cell[115980, 4094, 259, 6, 40, "Text",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],

Cell[CellGroupData[{
Cell[116264, 4104, 184, 4, 26, "Input",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
Cell[116451, 4110, 235, 4, 21, "Message",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
Cell[116689, 4116, 185, 4, 21, "Output",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}]
}, Closed]],
Cell[116889, 4123, 195, 5, 24, "Text",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],

Cell[CellGroupData[{
Cell[117109, 4132, 184, 4, 26, "Input",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}],
Cell[117296, 4138, 205, 5, 21, "Output",
  CellTags->{"Interpolation::inddp", "ListInterpolation::inddp"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[117562, 4150, 225, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],
Cell[117790, 4159, 649, 18, 37, "Message",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],
Cell[118442, 4179, 332, 9, 40, "Notes",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],

Cell[CellGroupData[{
Cell[118799, 4192, 140, 3, 38, "ExampleSection",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],
Cell[118942, 4197, 285, 7, 40, "Text",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],

Cell[CellGroupData[{
Cell[119252, 4208, 271, 6, 42, "Input",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],
Cell[119526, 4216, 339, 7, 53, "Message",
  CellTags->{
  "InterpolatingFunction::indep", "Interpolation::indep", 
    "ListInterpolation::indep"}],
Cell[119868, 4225, 272, 6, 37, "Output",
  CellTags->{
  "InterpolatingFunction::indep", "Interpolation::indep", 
    "ListInterpolation::indep"}]
}, Closed]],
Cell[120155, 4234, 231, 7, 24, "Text",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],

Cell[CellGroupData[{
Cell[120411, 4245, 271, 6, 42, "Input",
  CellTags->{
  "Interpolation::indep", "ListInterpolation::indep", 
    "InterpolatingFunction::indep"}],
Cell[120685, 4253, 245, 7, 21, "Output",
  CellTags->{
  "InterpolatingFunction::indep", "Interpolation::indep", 
    "ListInterpolation::indep"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[120991, 4267, 156, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
Cell[121150, 4273, 654, 18, 37, "Message",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
Cell[121807, 4293, 188, 4, 24, "Notes",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell[CellGroupData[{
Cell[122020, 4301, 100, 1, 38, "ExampleSection",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
Cell[122123, 4304, 187, 4, 24, "Text",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell[CellGroupData[{
Cell[122335, 4312, 167, 3, 26, "Input",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
Cell[122505, 4317, 209, 4, 21, "Output",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}]
}, Closed]],

Cell[CellGroupData[{
Cell[122751, 4326, 148, 3, 26, "Input",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
Cell[122902, 4331, 281, 5, 37, "Message",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
Cell[123186, 4338, 226, 4, 37, "Output",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}]
}, Closed]],
Cell[123427, 4345, 223, 5, 24, "Text",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],

Cell[CellGroupData[{
Cell[123675, 4354, 165, 3, 26, "Input",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
Cell[123843, 4359, 199, 4, 21, "Output",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}]
}, Closed]],

Cell[CellGroupData[{
Cell[124079, 4368, 148, 3, 26, "Input",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
Cell[124230, 4373, 205, 5, 21, "Output",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}]
}, Closed]],
Cell[124450, 4381, 156, 5, 24, "Text",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}],
Cell[124609, 4388, 140, 3, 26, "Input",
  CellTags->{"Interpolation::inder", "ListInterpolation::inder"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[124798, 4397, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Interpolation::indim"],
Cell[124894, 4400, 482, 11, 37, "Message",
  CellTags->"Interpolation::indim"],
Cell[125379, 4413, 646, 12, 122, "Notes",
  CellTags->"Interpolation::indim"],

Cell[CellGroupData[{
Cell[126050, 4429, 70, 1, 38, "ExampleSection",
  CellTags->"Interpolation::indim"],
Cell[126123, 4432, 187, 4, 40, "Text",
  CellTags->"Interpolation::indim"],

Cell[CellGroupData[{
Cell[126335, 4440, 405, 7, 90, "Input",
  CellTags->"Interpolation::indim"],
Cell[126743, 4449, 271, 5, 53, "Message",
  CellTags->"Interpolation::indim"],
Cell[127017, 4456, 371, 6, 69, "Output",
  CellTags->"Interpolation::indim"]
}, Closed]],
Cell[127403, 4465, 92, 1, 24, "Text",
  CellTags->"Interpolation::indim"],

Cell[CellGroupData[{
Cell[127520, 4470, 405, 7, 90, "Input",
  CellTags->"Interpolation::indim"],
Cell[127928, 4479, 184, 5, 21, "Output",
  CellTags->"Interpolation::indim"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[128173, 4491, 160, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Interpolation::indimt", "ListInterpolation::indimt"}],
Cell[128336, 4497, 435, 11, 53, "Message",
  CellTags->{"Interpolation::indimt", "ListInterpolation::indimt"}],
Cell[128774, 4510, 232, 6, 24, "Notes",
  CellTags->{"Interpolation::indimt", "ListInterpolation::indimt"}]
}, Closed]],

Cell[CellGroupData[{
Cell[129043, 4521, 219, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],
Cell[129265, 4530, 529, 15, 21, "Message",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],
Cell[129797, 4547, 780, 20, 106, "Notes",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[CellGroupData[{
Cell[130602, 4571, 137, 3, 38, "ExampleSection",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],
Cell[130742, 4576, 305, 8, 40, "Text",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[CellGroupData[{
Cell[131072, 4588, 199, 5, 26, "Input",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],
Cell[131274, 4595, 281, 7, 37, "Message",
  CellTags->{
  "InterpolatingFunction::inhr", "Interpolation::inhr", 
    "ListInterpolation::inhr"}],
Cell[131558, 4604, 242, 7, 21, "Output",
  CellTags->{
  "InterpolatingFunction::inhr", "Interpolation::inhr", 
    "ListInterpolation::inhr"}]
}, Closed]],
Cell[131815, 4614, 283, 9, 24, "Text",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[CellGroupData[{
Cell[132123, 4627, 231, 6, 26, "Input",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],
Cell[132357, 4635, 242, 7, 21, "Output",
  CellTags->{
  "InterpolatingFunction::inhr", "Interpolation::inhr", 
    "ListInterpolation::inhr"}]
}, Closed]],
Cell[132614, 4645, 349, 8, 40, "Text",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[CellGroupData[{
Cell[132988, 4657, 211, 5, 26, "Input",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],
Cell[133202, 4664, 288, 7, 37, "Message",
  CellTags->{
  "InterpolatingFunction::inhr", "Interpolation::inhr", 
    "ListInterpolation::inhr"}],
Cell[133493, 4673, 250, 7, 21, "Output",
  CellTags->{
  "InterpolatingFunction::inhr", "Interpolation::inhr", 
    "ListInterpolation::inhr"}]
}, Closed]],
Cell[133758, 4683, 291, 8, 40, "Text",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],

Cell[CellGroupData[{
Cell[134074, 4695, 207, 5, 26, "Input",
  CellTags->{
  "Interpolation::inhr", "ListInterpolation::inhr", 
    "InterpolatingFunction::inhr"}],
Cell[134284, 4702, 242, 7, 21, "Output",
  CellTags->{
  "InterpolatingFunction::inhr", "Interpolation::inhr", 
    "ListInterpolation::inhr"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[134587, 4716, 152, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
Cell[134742, 4722, 491, 12, 37, "Message",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
Cell[135236, 4736, 211, 4, 24, "Notes",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],

Cell[CellGroupData[{
Cell[135472, 4744, 98, 1, 38, "ExampleSection",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
Cell[135573, 4747, 171, 4, 24, "Text",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],

Cell[CellGroupData[{
Cell[135769, 4755, 142, 3, 26, "Input",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
Cell[135914, 4760, 256, 5, 37, "Message",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}],
Cell[136173, 4767, 143, 3, 21, "Output",
  CellTags->{"Interpolation::innd", "ListInterpolation::innd"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[136377, 4777, 225, 7, 71, "ObjectNameWarningMessages",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],
Cell[136605, 4786, 832, 24, 53, "Message",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],
Cell[137440, 4812, 279, 7, 24, "Notes",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],

Cell[CellGroupData[{
Cell[137744, 4823, 140, 3, 38, "ExampleSection",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],
Cell[137887, 4828, 294, 9, 24, "Text",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],

Cell[CellGroupData[{
Cell[138206, 4841, 231, 6, 26, "Input",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],
Cell[138440, 4849, 401, 8, 69, "Message",
  CellTags->{
  "FunctionInterpolation::inord", "Interpolation::inord", 
    "ListInterpolation::inord"}],
Cell[138844, 4859, 237, 6, 21, "Output",
  CellTags->{
  "FunctionInterpolation::inord", "Interpolation::inord", 
    "ListInterpolation::inord"}]
}, Closed]],
Cell[139096, 4868, 225, 7, 24, "Text",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],

Cell[CellGroupData[{
Cell[139346, 4879, 221, 5, 26, "Input",
  CellTags->{
  "Interpolation::inord", "ListInterpolation::inord", 
    "FunctionInterpolation::inord"}],
Cell[139570, 4886, 245, 7, 21, "Output",
  CellTags->{
  "FunctionInterpolation::inord", "Interpolation::inord", 
    "ListInterpolation::inord"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[139876, 4900, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Interpolation::inpts"],
Cell[139972, 4903, 557, 13, 37, "Message",
  CellTags->"Interpolation::inpts"],
Cell[140532, 4918, 153, 4, 24, "Notes",
  CellTags->"Interpolation::inpts"],

Cell[CellGroupData[{
Cell[140710, 4926, 70, 1, 38, "ExampleSection",
  CellTags->"Interpolation::inpts"],
Cell[140783, 4929, 186, 4, 40, "Text",
  CellTags->"Interpolation::inpts"],

Cell[CellGroupData[{
Cell[140994, 4937, 330, 6, 90, "Input",
  CellTags->"Interpolation::inpts"],
Cell[141327, 4945, 262, 5, 53, "Message",
  CellTags->"Interpolation::inpts"],
Cell[141592, 4952, 296, 5, 53, "Output",
  CellTags->"Interpolation::inpts"]
}, Closed]],
Cell[141903, 4960, 146, 5, 24, "Text",
  CellTags->"Interpolation::inpts"],

Cell[CellGroupData[{
Cell[142074, 4969, 341, 6, 90, "Input",
  CellTags->"Interpolation::inpts"],
Cell[142418, 4977, 183, 5, 21, "Output",
  CellTags->"Interpolation::inpts"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[142662, 4989, 160, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
Cell[142825, 4995, 654, 17, 37, "Message",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
Cell[143482, 5014, 210, 4, 24, "Notes",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[CellGroupData[{
Cell[143717, 5022, 102, 1, 38, "ExampleSection",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
Cell[143822, 5025, 210, 4, 40, "Text",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[CellGroupData[{
Cell[144057, 5033, 234, 5, 42, "Input",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
Cell[144294, 5040, 549, 11, 85, "Output",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}]
}, Closed]],

Cell[CellGroupData[{
Cell[144880, 5056, 150, 3, 26, "Input",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
Cell[145033, 5061, 352, 6, 53, "Message",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
Cell[145388, 5069, 352, 6, 53, "Message",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
Cell[145743, 5077, 352, 6, 53, "Message",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
Cell[146098, 5085, 270, 5, 37, "Message",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
Cell[146371, 5092, 215, 5, 21, "Output",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}]
}, Closed]],
Cell[146601, 5100, 174, 4, 24, "Text",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],

Cell[CellGroupData[{
Cell[146800, 5108, 234, 5, 42, "Input",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
Cell[147037, 5115, 549, 11, 85, "Output",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}]
}, Closed]],

Cell[CellGroupData[{
Cell[147623, 5131, 150, 3, 26, "Input",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
Cell[147776, 5136, 215, 5, 21, "Output",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}]
}, Closed]],
Cell[148006, 5144, 158, 5, 24, "Text",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}],
Cell[148167, 5151, 142, 3, 26, "Input",
  CellTags->{"Interpolation::mixedp", "ListInterpolation::mixedp"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[148358, 5160, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Interval::nvld"],
Cell[148442, 5163, 253, 6, 21, "Message",
  CellTags->"Interval::nvld"],
Cell[148698, 5171, 321, 9, 46, "Notes",
  CellTags->"Interval::nvld"]
}, Closed]],

Cell[CellGroupData[{
Cell[149056, 5185, 148, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
Cell[149207, 5191, 408, 11, 21, "Message",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
Cell[149618, 5204, 191, 4, 24, "Notes",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],

Cell[CellGroupData[{
Cell[149834, 5212, 96, 1, 38, "ExampleSection",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
Cell[149933, 5215, 168, 4, 24, "Text",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],

Cell[CellGroupData[{
Cell[150126, 5223, 139, 3, 26, "Input",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
Cell[150268, 5228, 233, 5, 21, "Message",
  CellTags->{"MantissaExponent::realx", "RealDigits::realx"}],
Cell[150504, 5235, 153, 3, 21, "Output",
  CellTags->{"MantissaExponent::realx", "RealDigits::realx"}]
}, Closed]],
Cell[150672, 5241, 164, 5, 24, "Text",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],

Cell[CellGroupData[{
Cell[150861, 5250, 141, 3, 26, "Input",
  CellTags->{"RealDigits::realx", "MantissaExponent::realx"}],
Cell[151005, 5255, 174, 3, 21, "Output",
  CellTags->{"MantissaExponent::realx", "RealDigits::realx"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[151240, 5265, 117, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NumericalMath`$NumberBits::realx"],
Cell[151360, 5268, 351, 8, 21, "Message",
  CellTags->"NumericalMath`$NumberBits::realx"],
Cell[151714, 5278, 226, 5, 24, "Notes",
  CellTags->"NumericalMath`$NumberBits::realx"],

Cell[CellGroupData[{
Cell[151965, 5287, 82, 1, 38, "ExampleSection",
  CellTags->"NumericalMath`$NumberBits::realx"],
Cell[152050, 5290, 153, 4, 24, "Text",
  CellTags->"NumericalMath`$NumberBits::realx"],

Cell[CellGroupData[{
Cell[152228, 5298, 144, 3, 26, "Input",
  CellTags->"NumericalMath`$NumberBits::realx"],
Cell[152375, 5303, 271, 5, 37, "Message",
  CellTags->"NumericalMath`$NumberBits::realx"],
Cell[152649, 5310, 197, 4, 21, "Output",
  CellTags->"NumericalMath`$NumberBits::realx"]
}, Closed]],
Cell[152861, 5317, 164, 5, 24, "Text",
  CellTags->"NumericalMath`$NumberBits::realx"],

Cell[CellGroupData[{
Cell[153050, 5326, 148, 3, 26, "Input",
  CellTags->"NumericalMath`$NumberBits::realx"],
Cell[153201, 5331, 259, 5, 53, "Message",
  CellTags->"NumericalMath`$NumberBits::realx"],
Cell[153463, 5338, 144, 3, 21, "Output",
  CellTags->"NumericalMath`$NumberBits::realx"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[153668, 5348, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::accg"],
Cell[153750, 5351, 561, 17, 37, "Message",
  CellTags->"General::accg"],
Cell[154314, 5370, 196, 5, 24, "Notes",
  CellTags->"General::accg"],

Cell[CellGroupData[{
Cell[154535, 5379, 63, 1, 38, "ExampleSection",
  CellTags->"General::accg"],
Cell[154601, 5382, 252, 9, 40, "Text",
  CellTags->"General::accg"],

Cell[CellGroupData[{
Cell[154878, 5395, 188, 4, 42, "Input",
  CellTags->"General::accg"],
Cell[155069, 5401, 244, 5, 37, "Message",
  CellTags->"General::accg"],
Cell[155316, 5408, 216, 4, 37, "Output",
  CellTags->"General::accg"]
}, Closed]],
Cell[155547, 5415, 142, 5, 24, "Text",
  CellTags->"General::accg"],

Cell[CellGroupData[{
Cell[155714, 5424, 193, 4, 42, "Input",
  CellTags->"General::accg"],
Cell[155910, 5430, 136, 3, 21, "Output",
  CellTags->"General::accg"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[156107, 5440, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::bdmtd"],
Cell[156197, 5443, 375, 7, 53, "Message",
  CellTags->"NIntegrate::bdmtd"],
Cell[156575, 5452, 232, 7, 24, "Notes",
  CellTags->"NIntegrate::bdmtd"],

Cell[CellGroupData[{
Cell[156832, 5463, 67, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::bdmtd"],
Cell[156902, 5466, 256, 9, 40, "Text",
  CellTags->"NIntegrate::bdmtd"],

Cell[CellGroupData[{
Cell[157183, 5479, 141, 3, 26, "Input",
  CellTags->"NIntegrate::bdmtd"],
Cell[157327, 5484, 295, 6, 69, "Message",
  CellTags->"NIntegrate::bdmtd"],
Cell[157625, 5492, 152, 4, 21, "Output",
  CellTags->"NIntegrate::bdmtd"]
}, Closed]],
Cell[157792, 5499, 138, 5, 24, "Text",
  CellTags->"NIntegrate::bdmtd"],

Cell[CellGroupData[{
Cell[157955, 5508, 151, 4, 26, "Input",
  CellTags->"NIntegrate::bdmtd"],
Cell[158109, 5514, 94, 3, 21, "Output",
  CellTags->"NIntegrate::bdmtd"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[158264, 5524, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::comp"],
Cell[158352, 5527, 381, 6, 85, "Message",
  CellTags->"NIntegrate::comp"],
Cell[158736, 5535, 299, 8, 40, "Notes",
  CellTags->"NIntegrate::comp"],

Cell[CellGroupData[{
Cell[159060, 5547, 66, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::comp"],
Cell[159129, 5550, 151, 4, 24, "Text",
  CellTags->"NIntegrate::comp"],

Cell[CellGroupData[{
Cell[159305, 5558, 164, 4, 26, "Input",
  CellTags->"NIntegrate::comp"],
Cell[159472, 5564, 410, 7, 85, "Message",
  CellTags->"NIntegrate::comp"],
Cell[159885, 5573, 173, 4, 36, "Output",
  CellTags->"NIntegrate::comp"]
}, Closed]],
Cell[160073, 5580, 145, 5, 24, "Text",
  CellTags->"NIntegrate::comp"],

Cell[CellGroupData[{
Cell[160243, 5589, 169, 4, 42, "Input",
  CellTags->"NIntegrate::comp"],
Cell[160415, 5595, 109, 3, 21, "Output",
  CellTags->"NIntegrate::comp"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[160585, 5605, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::ierr"],
Cell[160673, 5608, 250, 4, 53, "Message",
  CellTags->"NIntegrate::ierr"],
Cell[160926, 5614, 301, 8, 40, "Notes",
  CellTags->"NIntegrate::ierr"],

Cell[CellGroupData[{
Cell[161252, 5626, 66, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::ierr"],
Cell[161321, 5629, 144, 4, 24, "Text",
  CellTags->"NIntegrate::ierr"],

Cell[CellGroupData[{
Cell[161490, 5637, 175, 4, 42, "Input",
  CellTags->"NIntegrate::ierr"],
Cell[161668, 5643, 242, 5, 53, "Message",
  CellTags->"NIntegrate::ierr"],
Cell[161913, 5650, 185, 4, 39, "Output",
  CellTags->"NIntegrate::ierr"]
}, Closed]],
Cell[162113, 5657, 145, 5, 24, "Text",
  CellTags->"NIntegrate::ierr"],

Cell[CellGroupData[{
Cell[162283, 5666, 169, 4, 42, "Input",
  CellTags->"NIntegrate::ierr"],
Cell[162455, 5672, 109, 3, 21, "Output",
  CellTags->"NIntegrate::ierr"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[162625, 5682, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::inovf"],
Cell[162715, 5685, 488, 14, 37, "Message",
  CellTags->"NIntegrate::inovf"],
Cell[163206, 5701, 149, 4, 24, "Notes",
  CellTags->"NIntegrate::inovf"]
}, Closed]],

Cell[CellGroupData[{
Cell[163392, 5710, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::inum"],
Cell[163480, 5713, 442, 13, 21, "Message",
  CellTags->"NIntegrate::inum"],
Cell[163925, 5728, 162, 4, 24, "Notes",
  CellTags->"NIntegrate::inum"],

Cell[CellGroupData[{
Cell[164112, 5736, 66, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::inum"],
Cell[164181, 5739, 170, 4, 24, "Text",
  CellTags->"NIntegrate::inum"],

Cell[CellGroupData[{
Cell[164376, 5747, 121, 3, 26, "Input",
  CellTags->"NIntegrate::inum"],
Cell[164500, 5752, 221, 5, 19, "Message",
  CellTags->"NIntegrate::inum"],
Cell[164724, 5759, 122, 3, 25, "Output",
  CellTags->"NIntegrate::inum"]
}, Closed]],
Cell[164861, 5765, 141, 4, 24, "Text",
  CellTags->"NIntegrate::inum"],

Cell[CellGroupData[{
Cell[165027, 5773, 136, 3, 26, "Input",
  CellTags->"NIntegrate::inum"],
Cell[165166, 5778, 114, 3, 25, "Output",
  CellTags->"NIntegrate::inum"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[165341, 5788, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::minmax"],
Cell[165433, 5791, 426, 12, 19, "Message",
  CellTags->"NIntegrate::minmax"],
Cell[165862, 5805, 249, 7, 24, "Notes",
  CellTags->"NIntegrate::minmax"],

Cell[CellGroupData[{
Cell[166136, 5816, 68, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::minmax"],
Cell[166207, 5819, 237, 7, 40, "Text",
  CellTags->"NIntegrate::minmax"],

Cell[CellGroupData[{
Cell[166469, 5830, 166, 4, 26, "Input",
  CellTags->"NIntegrate::minmax"],
Cell[166638, 5836, 208, 5, 19, "Message",
  CellTags->"NIntegrate::minmax"],
Cell[166849, 5843, 177, 4, 25, "Output",
  CellTags->"NIntegrate::minmax"]
}, Closed]],
Cell[167041, 5850, 192, 7, 24, "Text",
  CellTags->"NIntegrate::minmax"],

Cell[CellGroupData[{
Cell[167258, 5861, 166, 4, 26, "Input",
  CellTags->"NIntegrate::minmax"],
Cell[167427, 5867, 116, 3, 25, "Output",
  CellTags->"NIntegrate::minmax"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[167604, 5877, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::nconv"],
Cell[167694, 5880, 178, 3, 19, "Message",
  CellTags->"NIntegrate::nconv"],
Cell[167875, 5885, 276, 7, 40, "Notes",
  CellTags->"NIntegrate::nconv"]
}, Closed]],

Cell[CellGroupData[{
Cell[168188, 5897, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::ncvb"],
Cell[168276, 5900, 622, 17, 33, "Message",
  CellTags->"NIntegrate::ncvb"],
Cell[168901, 5919, 618, 11, 122, "Notes",
  CellTags->"NIntegrate::ncvb"],

Cell[CellGroupData[{
Cell[169544, 5934, 66, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::ncvb"],
Cell[169613, 5937, 152, 4, 24, "Text",
  CellTags->"NIntegrate::ncvb"],

Cell[CellGroupData[{
Cell[169790, 5945, 131, 3, 26, "Input",
  CellTags->"NIntegrate::ncvb"],
Cell[169924, 5950, 415, 7, 75, "Message",
  CellTags->"NIntegrate::ncvb"],
Cell[170342, 5959, 277, 6, 33, "Message",
  CellTags->"NIntegrate::ncvb"],
Cell[170622, 5967, 108, 3, 25, "Output",
  CellTags->"NIntegrate::ncvb"]
}, Closed]],
Cell[170745, 5973, 183, 4, 40, "Text",
  CellTags->"NIntegrate::ncvb"],

Cell[CellGroupData[{
Cell[170953, 5981, 134, 3, 26, "Input",
  CellTags->"NIntegrate::ncvb"],
Cell[171090, 5986, 108, 3, 25, "Output",
  CellTags->"NIntegrate::ncvb"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[171259, 5996, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::ncvs"],
Cell[171347, 5999, 466, 13, 33, "Message",
  CellTags->"NIntegrate::ncvs"],
Cell[171816, 6014, 157, 4, 24, "Notes",
  CellTags->"NIntegrate::ncvs"],

Cell[CellGroupData[{
Cell[171998, 6022, 66, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::ncvs"],
Cell[172067, 6025, 129, 4, 24, "Text",
  CellTags->"NIntegrate::ncvs"],

Cell[CellGroupData[{
Cell[172221, 6033, 146, 3, 26, "Input",
  CellTags->"NIntegrate::ncvs"],
Cell[172370, 6038, 242, 5, 33, "Message",
  CellTags->"NIntegrate::ncvs"],
Cell[172615, 6045, 161, 4, 40, "Output",
  CellTags->"NIntegrate::ncvs"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[172837, 6056, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::ninf"],
Cell[172925, 6059, 275, 6, 19, "Message",
  CellTags->"NIntegrate::ninf"],
Cell[173203, 6067, 576, 14, 100, "Notes",
  CellTags->"NIntegrate::ninf"],

Cell[CellGroupData[{
Cell[173804, 6085, 66, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::ninf"],
Cell[173873, 6088, 164, 4, 24, "Text",
  CellTags->"NIntegrate::ninf"],

Cell[CellGroupData[{
Cell[174062, 6096, 144, 3, 26, "Input",
  CellTags->"NIntegrate::ninf"],
Cell[174209, 6101, 248, 5, 19, "Message",
  CellTags->"NIntegrate::ninf"],
Cell[174460, 6108, 172, 5, 40, "Output",
  CellTags->"NIntegrate::ninf"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[174693, 6120, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::nintp"],
Cell[174783, 6123, 459, 14, 19, "Message",
  CellTags->"NIntegrate::nintp"],
Cell[175245, 6139, 326, 7, 62, "Notes",
  CellTags->"NIntegrate::nintp"],

Cell[CellGroupData[{
Cell[175596, 6150, 67, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::nintp"],
Cell[175666, 6153, 99, 1, 24, "Text",
  CellTags->"NIntegrate::nintp"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[175814, 6160, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::oscfm"],
Cell[175904, 6163, 422, 7, 75, "Message",
  CellTags->"NIntegrate::oscfm"],
Cell[176329, 6172, 300, 8, 40, "Notes",
  CellTags->"NIntegrate::oscfm"],

Cell[CellGroupData[{
Cell[176654, 6184, 67, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::oscfm"],
Cell[176724, 6187, 178, 4, 40, "Text",
  CellTags->"NIntegrate::oscfm"],

Cell[CellGroupData[{
Cell[176927, 6195, 151, 4, 26, "Input",
  CellTags->"NIntegrate::oscfm"],
Cell[177081, 6201, 451, 8, 75, "Message",
  CellTags->"NIntegrate::oscfm"],
Cell[177535, 6211, 165, 4, 25, "Output",
  CellTags->"NIntegrate::oscfm"]
}, Closed]],
Cell[177715, 6218, 146, 5, 24, "Text",
  CellTags->"NIntegrate::oscfm"],

Cell[CellGroupData[{
Cell[177886, 6227, 170, 4, 42, "Input",
  CellTags->"NIntegrate::oscfm"],
Cell[178059, 6233, 110, 3, 25, "Output",
  CellTags->"NIntegrate::oscfm"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[178230, 6243, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::oscint"],
Cell[178322, 6246, 317, 6, 33, "Message",
  CellTags->"NIntegrate::oscint"],
Cell[178642, 6254, 413, 11, 62, "Notes",
  CellTags->"NIntegrate::oscint"]
}, Closed]],

Cell[CellGroupData[{
Cell[179092, 6270, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::osran"],
Cell[179182, 6273, 242, 6, 19, "Message",
  CellTags->"NIntegrate::osran"],
Cell[179427, 6281, 268, 7, 40, "Notes",
  CellTags->"NIntegrate::osran"],

Cell[CellGroupData[{
Cell[179720, 6292, 67, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::osran"],
Cell[179790, 6295, 202, 5, 40, "Text",
  CellTags->"NIntegrate::osran"],

Cell[CellGroupData[{
Cell[180017, 6304, 187, 4, 42, "Input",
  CellTags->"NIntegrate::osran"],
Cell[180207, 6310, 205, 5, 19, "Message",
  CellTags->"NIntegrate::osran"],
Cell[180415, 6317, 197, 4, 42, "Output",
  CellTags->"NIntegrate::osran"]
}, Closed]],
Cell[180627, 6324, 152, 4, 24, "Text",
  CellTags->"NIntegrate::osran"],

Cell[CellGroupData[{
Cell[180804, 6332, 217, 5, 42, "Input",
  CellTags->"NIntegrate::osran"],
Cell[181024, 6339, 110, 3, 25, "Output",
  CellTags->"NIntegrate::osran"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[181195, 6349, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::osrn"],
Cell[181283, 6352, 280, 5, 33, "Message",
  CellTags->"NIntegrate::osrn"],
Cell[181566, 6359, 271, 7, 40, "Notes",
  CellTags->"NIntegrate::osrn"],

Cell[CellGroupData[{
Cell[181862, 6370, 66, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::osrn"],
Cell[181931, 6373, 241, 6, 40, "Text",
  CellTags->"NIntegrate::osrn"],

Cell[CellGroupData[{
Cell[182197, 6383, 164, 4, 26, "Input",
  CellTags->"NIntegrate::osrn"],
Cell[182364, 6389, 248, 5, 33, "Message",
  CellTags->"NIntegrate::osrn"],
Cell[182615, 6396, 170, 4, 40, "Output",
  CellTags->"NIntegrate::osrn"]
}, Closed]],
Cell[182800, 6403, 125, 4, 24, "Text",
  CellTags->"NIntegrate::osrn"],

Cell[CellGroupData[{
Cell[182950, 6411, 134, 3, 26, "Input",
  CellTags->"NIntegrate::osrn"],
Cell[183087, 6416, 109, 3, 25, "Output",
  CellTags->"NIntegrate::osrn"]
}, Closed]],
Cell[183211, 6422, 158, 4, 24, "Text",
  CellTags->"NIntegrate::osrn"],

Cell[CellGroupData[{
Cell[183394, 6430, 265, 6, 58, "Input",
  CellTags->"NIntegrate::osrn"],
Cell[183662, 6438, 109, 3, 25, "Output",
  CellTags->"NIntegrate::osrn"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[183832, 6448, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::ploss"],
Cell[183922, 6451, 428, 7, 75, "Message",
  CellTags->"NIntegrate::ploss"],
Cell[184353, 6460, 329, 9, 40, "Notes",
  CellTags->"NIntegrate::ploss"],

Cell[CellGroupData[{
Cell[184707, 6473, 67, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::ploss"],
Cell[184777, 6476, 238, 5, 40, "Text",
  CellTags->"NIntegrate::ploss"],

Cell[CellGroupData[{
Cell[185040, 6485, 123, 3, 26, "Input",
  CellTags->"NIntegrate::ploss"],
Cell[185166, 6490, 457, 8, 101, "Message",
  CellTags->"NIntegrate::ploss"],
Cell[185626, 6500, 119, 3, 23, "Output",
  CellTags->"NIntegrate::ploss"]
}, Closed]],
Cell[185760, 6506, 308, 7, 40, "Text",
  CellTags->"NIntegrate::ploss"],

Cell[CellGroupData[{
Cell[186093, 6517, 142, 3, 26, "Input",
  CellTags->"NIntegrate::ploss"],
Cell[186238, 6522, 115, 3, 23, "Output",
  CellTags->"NIntegrate::ploss"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[186414, 6532, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::precg"],
Cell[186498, 6535, 573, 17, 37, "Message",
  CellTags->"General::precg"],
Cell[187074, 6554, 198, 5, 24, "Notes",
  CellTags->"General::precg"],

Cell[CellGroupData[{
Cell[187297, 6563, 64, 1, 38, "ExampleSection",
  CellTags->"General::precg"],
Cell[187364, 6566, 255, 9, 40, "Text",
  CellTags->"General::precg"],

Cell[CellGroupData[{
Cell[187644, 6579, 206, 4, 42, "Input",
  CellTags->"General::precg"],
Cell[187853, 6585, 256, 5, 53, "Message",
  CellTags->"General::precg"],
Cell[188112, 6592, 207, 4, 37, "Output",
  CellTags->"General::precg"]
}, Closed]],
Cell[188334, 6599, 186, 7, 24, "Text",
  CellTags->"General::precg"],

Cell[CellGroupData[{
Cell[188545, 6610, 210, 4, 42, "Input",
  CellTags->"General::precg"],
Cell[188758, 6616, 159, 4, 21, "Output",
  CellTags->"General::precg"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[188978, 6627, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::rnderr"],
Cell[189070, 6630, 463, 10, 37, "Message",
  CellTags->"NIntegrate::rnderr"],
Cell[189536, 6642, 400, 8, 78, "Notes",
  CellTags->"NIntegrate::rnderr"]
}, Closed]],

Cell[CellGroupData[{
Cell[189973, 6655, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::slwcon"],
Cell[190065, 6658, 388, 6, 85, "Message",
  CellTags->"NIntegrate::slwcon"],
Cell[190456, 6666, 175, 4, 24, "Notes",
  CellTags->"NIntegrate::slwcon"],

Cell[CellGroupData[{
Cell[190656, 6674, 68, 1, 38, "ExampleSection",
  CellTags->"NIntegrate::slwcon"],
Cell[190727, 6677, 172, 4, 24, "Text",
  CellTags->"NIntegrate::slwcon"],

Cell[CellGroupData[{
Cell[190924, 6685, 179, 4, 26, "Input",
  CellTags->"NIntegrate::slwcon"],
Cell[191106, 6691, 417, 7, 85, "Message",
  CellTags->"NIntegrate::slwcon"],
Cell[191526, 6700, 287, 6, 53, "Message",
  CellTags->"NIntegrate::slwcon"],
Cell[191816, 6708, 111, 3, 21, "Output",
  CellTags->"NIntegrate::slwcon"]
}, Closed]],
Cell[191942, 6714, 150, 5, 24, "Text",
  CellTags->"NIntegrate::slwcon"],

Cell[CellGroupData[{
Cell[192117, 6723, 177, 4, 42, "Input",
  CellTags->"NIntegrate::slwcon"],
Cell[192297, 6729, 111, 3, 21, "Output",
  CellTags->"NIntegrate::slwcon"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[192469, 6739, 120, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NProduct::emcon", "NSum::emcon"}],
Cell[192592, 6745, 298, 7, 37, "Message",
  CellTags->{"NProduct::emcon", "NSum::emcon"}],
Cell[192893, 6754, 286, 7, 46, "Notes",
  CellTags->{"NProduct::emcon", "NSum::emcon"}]
}, Closed]],

Cell[CellGroupData[{
Cell[193216, 6766, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NProduct::itfn"],
Cell[193300, 6769, 232, 5, 21, "Message",
  CellTags->"NProduct::itfn"],
Cell[193535, 6776, 909, 33, 68, "Notes",
  CellTags->"NProduct::itfn"],

Cell[CellGroupData[{
Cell[194469, 6813, 64, 1, 38, "ExampleSection",
  CellTags->"NProduct::itfn"],
Cell[194536, 6816, 144, 4, 24, "Text",
  CellTags->"NProduct::itfn"],

Cell[CellGroupData[{
Cell[194705, 6824, 101, 3, 26, "Input",
  CellTags->"NProduct::itfn"],
Cell[194809, 6829, 193, 5, 21, "Message",
  CellTags->"NProduct::itfn"],
Cell[195005, 6836, 102, 3, 21, "Output",
  CellTags->"NProduct::itfn"]
}, Closed]],
Cell[195122, 6842, 129, 5, 24, "Text",
  CellTags->"NProduct::itfn"],

Cell[CellGroupData[{
Cell[195276, 6851, 106, 3, 26, "Input",
  CellTags->"NProduct::itfn"],
Cell[195385, 6856, 93, 3, 21, "Output",
  CellTags->"NProduct::itfn"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[195539, 6866, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NProduct::nplim"],
Cell[195625, 6869, 248, 5, 21, "Message",
  CellTags->"NProduct::nplim"],
Cell[195876, 6876, 197, 6, 24, "Notes",
  CellTags->"NProduct::nplim"],

Cell[CellGroupData[{
Cell[196098, 6886, 65, 1, 38, "ExampleSection",
  CellTags->"NProduct::nplim"],
Cell[196166, 6889, 166, 4, 24, "Text",
  CellTags->"NProduct::nplim"],

Cell[CellGroupData[{
Cell[196357, 6897, 112, 3, 26, "Input",
  CellTags->"NProduct::nplim"],
Cell[196472, 6902, 180, 4, 21, "Message",
  CellTags->"NProduct::nplim"],
Cell[196655, 6908, 113, 3, 21, "Output",
  CellTags->"NProduct::nplim"]
}, Closed]],
Cell[196783, 6914, 146, 5, 24, "Text",
  CellTags->"NProduct::nplim"],

Cell[CellGroupData[{
Cell[196954, 6923, 136, 3, 26, "Input",
  CellTags->"NProduct::nplim"],
Cell[197093, 6928, 94, 3, 21, "Output",
  CellTags->"NProduct::nplim"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[197248, 6938, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NProduct::npnum"],
Cell[197334, 6941, 466, 14, 21, "Message",
  CellTags->"NProduct::npnum"],
Cell[197803, 6957, 212, 5, 24, "Notes",
  CellTags->"NProduct::npnum"],

Cell[CellGroupData[{
Cell[198040, 6966, 65, 1, 38, "ExampleSection",
  CellTags->"NProduct::npnum"],
Cell[198108, 6969, 222, 6, 40, "Text",
  CellTags->"NProduct::npnum"],

Cell[CellGroupData[{
Cell[198355, 6979, 124, 3, 26, "Input",
  CellTags->"NProduct::npnum"],
Cell[198482, 6984, 217, 5, 21, "Message",
  CellTags->"NProduct::npnum"],
Cell[198702, 6991, 129, 3, 21, "Output",
  CellTags->"NProduct::npnum"]
}, Closed]],
Cell[198846, 6997, 146, 5, 24, "Text",
  CellTags->"NProduct::npnum"],

Cell[CellGroupData[{
Cell[199017, 7006, 141, 3, 26, "Input",
  CellTags->"NProduct::npnum"],
Cell[199161, 7011, 90, 3, 21, "Output",
  CellTags->"NProduct::npnum"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[199312, 7021, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NProduct::npst"],
Cell[199396, 7024, 259, 6, 21, "Message",
  CellTags->"NProduct::npst"],
Cell[199658, 7032, 191, 5, 24, "Notes",
  CellTags->"NProduct::npst"],

Cell[CellGroupData[{
Cell[199874, 7041, 64, 1, 38, "ExampleSection",
  CellTags->"NProduct::npst"],
Cell[199941, 7044, 182, 4, 40, "Text",
  CellTags->"NProduct::npst"],

Cell[CellGroupData[{
Cell[200148, 7052, 119, 3, 26, "Input",
  CellTags->"NProduct::npst"],
Cell[200270, 7057, 189, 4, 21, "Message",
  CellTags->"NProduct::npst"],
Cell[200462, 7063, 122, 3, 36, "Output",
  CellTags->"NProduct::npst"]
}, Closed]],
Cell[200599, 7069, 145, 5, 24, "Text",
  CellTags->"NProduct::npst"],

Cell[CellGroupData[{
Cell[200769, 7078, 139, 3, 26, "Input",
  CellTags->"NProduct::npst"],
Cell[200911, 7083, 112, 3, 21, "Output",
  CellTags->"NProduct::npst"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[201084, 7093, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NProduct::npz"],
Cell[201166, 7096, 197, 4, 21, "Message",
  CellTags->"NProduct::npz"],
Cell[201366, 7102, 537, 12, 100, "Notes",
  CellTags->"NProduct::npz"]
}, Closed]],

Cell[CellGroupData[{
Cell[201940, 7119, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NRoots::nomod"],
Cell[202022, 7122, 158, 3, 21, "Message",
  CellTags->"NRoots::nomod"],
Cell[202183, 7127, 193, 6, 24, "Notes",
  CellTags->"NRoots::nomod"]
}, Closed]],

Cell[CellGroupData[{
Cell[202413, 7138, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NSum::itfn"],
Cell[202489, 7141, 224, 5, 21, "Message",
  CellTags->"NSum::itfn"],
Cell[202716, 7148, 897, 33, 68, "Notes",
  CellTags->"NSum::itfn"],

Cell[CellGroupData[{
Cell[203638, 7185, 60, 1, 38, "ExampleSection",
  CellTags->"NSum::itfn"],
Cell[203701, 7188, 140, 4, 24, "Text",
  CellTags->"NSum::itfn"],

Cell[CellGroupData[{
Cell[203866, 7196, 94, 3, 26, "Input",
  CellTags->"NSum::itfn"],
Cell[203963, 7201, 186, 5, 21, "Message",
  CellTags->"NSum::itfn"],
Cell[204152, 7208, 95, 3, 21, "Output",
  CellTags->"NSum::itfn"]
}, Closed]],
Cell[204262, 7214, 137, 5, 24, "Text",
  CellTags->"NSum::itfn"],

Cell[CellGroupData[{
Cell[204424, 7223, 99, 3, 26, "Input",
  CellTags->"NSum::itfn"],
Cell[204526, 7228, 89, 3, 21, "Output",
  CellTags->"NSum::itfn"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[204676, 7238, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NSum::nsst"],
Cell[204752, 7241, 253, 6, 21, "Message",
  CellTags->"NSum::nsst"],
Cell[205008, 7249, 174, 4, 24, "Notes",
  CellTags->"NSum::nsst"],

Cell[CellGroupData[{
Cell[205207, 7257, 60, 1, 38, "ExampleSection",
  CellTags->"NSum::nsst"],
Cell[205270, 7260, 178, 4, 40, "Text",
  CellTags->"NSum::nsst"],

Cell[CellGroupData[{
Cell[205473, 7268, 109, 3, 26, "Input",
  CellTags->"NSum::nsst"],
Cell[205585, 7273, 185, 5, 21, "Message",
  CellTags->"NSum::nsst"],
Cell[205773, 7280, 110, 3, 21, "Output",
  CellTags->"NSum::nsst"]
}, Closed]],
Cell[205898, 7286, 137, 5, 24, "Text",
  CellTags->"NSum::nsst"],

Cell[CellGroupData[{
Cell[206060, 7295, 127, 3, 26, "Input",
  CellTags->"NSum::nsst"],
Cell[206190, 7300, 87, 3, 21, "Output",
  CellTags->"NSum::nsst"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[206338, 7310, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NSum::nsumz"],
Cell[206416, 7313, 192, 4, 21, "Message",
  CellTags->"NSum::nsumz"],
Cell[206611, 7319, 523, 12, 84, "Notes",
  CellTags->"NSum::nsumz"]
}, Closed]],

Cell[CellGroupData[{
Cell[207171, 7336, 95, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SequenceLimit::seqlim"],
Cell[207269, 7339, 243, 4, 53, "Message",
  CellTags->"SequenceLimit::seqlim"],
Cell[207515, 7345, 535, 13, 78, "Notes",
  CellTags->"SequenceLimit::seqlim"],

Cell[CellGroupData[{
Cell[208075, 7362, 71, 1, 38, "ExampleSection",
  CellTags->"SequenceLimit::seqlim"],
Cell[208149, 7365, 184, 4, 40, "Text",
  CellTags->"SequenceLimit::seqlim"],

Cell[CellGroupData[{
Cell[208358, 7373, 133, 3, 26, "Input",
  CellTags->"SequenceLimit::seqlim"],
Cell[208494, 7378, 242, 5, 37, "Message",
  CellTags->"SequenceLimit::seqlim"],
Cell[208739, 7385, 99, 3, 36, "Output",
  CellTags->"SequenceLimit::seqlim"]
}, Closed]],
Cell[208853, 7391, 264, 9, 40, "Text",
  CellTags->"SequenceLimit::seqlim"],

Cell[CellGroupData[{
Cell[209142, 7404, 177, 4, 42, "Input",
  CellTags->"SequenceLimit::seqlim"],
Cell[209322, 7410, 242, 5, 37, "Message",
  CellTags->"SequenceLimit::seqlim"],
Cell[209567, 7417, 119, 3, 21, "Output",
  CellTags->"SequenceLimit::seqlim"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[209747, 7427, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SequenceLimit::seqw"],
Cell[209841, 7430, 422, 12, 37, "Message",
  CellTags->"SequenceLimit::seqw"],
Cell[210266, 7444, 425, 15, 40, "Notes",
  CellTags->"SequenceLimit::seqw"],

Cell[CellGroupData[{
Cell[210716, 7463, 69, 1, 38, "ExampleSection",
  CellTags->"SequenceLimit::seqw"],
Cell[210788, 7466, 256, 6, 40, "Text",
  CellTags->"SequenceLimit::seqw"],

Cell[CellGroupData[{
Cell[211069, 7476, 139, 3, 26, "Input",
  CellTags->"SequenceLimit::seqw"],
Cell[211211, 7481, 223, 5, 37, "Message",
  CellTags->"SequenceLimit::seqw"],
Cell[211437, 7488, 145, 3, 21, "Output",
  CellTags->"SequenceLimit::seqw"]
}, Closed]],
Cell[211597, 7494, 171, 5, 24, "Text",
  CellTags->"SequenceLimit::seqw"],

Cell[CellGroupData[{
Cell[211793, 7503, 142, 3, 26, "Input",
  CellTags->"SequenceLimit::seqw"],
Cell[211938, 7508, 94, 3, 21, "Output",
  CellTags->"SequenceLimit::seqw"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[212093, 7518, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SequenceLimit::wynn"],
Cell[212187, 7521, 320, 6, 37, "Message",
  CellTags->"SequenceLimit::wynn"],
Cell[212510, 7529, 199, 5, 24, "Notes",
  CellTags->"SequenceLimit::wynn"],

Cell[CellGroupData[{
Cell[212734, 7538, 69, 1, 38, "ExampleSection",
  CellTags->"SequenceLimit::wynn"],
Cell[212806, 7541, 220, 7, 24, "Text",
  CellTags->"SequenceLimit::wynn"],

Cell[CellGroupData[{
Cell[213051, 7552, 150, 3, 26, "Input",
  CellTags->"SequenceLimit::wynn"],
Cell[213204, 7557, 248, 5, 53, "Message",
  CellTags->"SequenceLimit::wynn"],
Cell[213455, 7564, 163, 4, 21, "Output",
  CellTags->"SequenceLimit::wynn"]
}, Closed]],
Cell[213633, 7571, 146, 5, 24, "Text",
  CellTags->"SequenceLimit::wynn"],

Cell[CellGroupData[{
Cell[213804, 7580, 142, 3, 26, "Input",
  CellTags->"SequenceLimit::wynn"],
Cell[213949, 7585, 94, 3, 21, "Output",
  CellTags->"SequenceLimit::wynn"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[214104, 7595, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SetAccuracy::accbd"],
Cell[214196, 7598, 286, 6, 37, "Message",
  CellTags->"SetAccuracy::accbd"],
Cell[214485, 7606, 198, 6, 24, "Notes",
  CellTags->"SetAccuracy::accbd"]
}, Closed]],

Cell[CellGroupData[{
Cell[214720, 7617, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SetAccuracy::acclg"],
Cell[214812, 7620, 388, 9, 53, "Message",
  CellTags->"SetAccuracy::acclg"],
Cell[215203, 7631, 272, 7, 40, "Notes",
  CellTags->"SetAccuracy::acclg"]
}, Closed]],

Cell[CellGroupData[{
Cell[215512, 7643, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SetAccuracy::accsm"],
Cell[215604, 7646, 388, 9, 53, "Message",
  CellTags->"SetAccuracy::accsm"],
Cell[215995, 7657, 272, 7, 40, "Notes",
  CellTags->"SetAccuracy::accsm"]
}, Closed]],

Cell[CellGroupData[{
Cell[216304, 7669, 69, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Sum::div"],
Cell[216376, 7672, 129, 3, 21, "Message",
  CellTags->"Sum::div"],
Cell[216508, 7677, 157, 5, 24, "Notes",
  CellTags->"Sum::div"]
}, Closed]],

Cell[CellGroupData[{
Cell[216702, 7687, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::precw"],
Cell[216786, 7690, 486, 13, 37, "Message",
  CellTags->"General::precw"],
Cell[217275, 7705, 883, 20, 154, "Notes",
  CellTags->"General::precw"],

Cell[CellGroupData[{
Cell[218183, 7729, 64, 1, 38, "ExampleSection",
  CellTags->"General::precw"],
Cell[218250, 7732, 376, 9, 56, "Text",
  CellTags->"General::precw"],

Cell[CellGroupData[{
Cell[218651, 7745, 140, 3, 26, "Input",
  CellTags->"General::precw"],
Cell[218794, 7750, 240, 5, 37, "Message",
  CellTags->"General::precw"],
Cell[219037, 7757, 148, 4, 21, "Output",
  CellTags->"General::precw"]
}, Closed]],
Cell[219200, 7764, 119, 4, 24, "Text",
  CellTags->"General::precw"],

Cell[CellGroupData[{
Cell[219344, 7772, 142, 3, 26, "Input",
  CellTags->"General::precw"],
Cell[219489, 7777, 148, 4, 21, "Output",
  CellTags->"General::precw"]
}, Closed]],
Cell[219652, 7784, 250, 8, 40, "Text",
  CellTags->"General::precw"],

Cell[CellGroupData[{
Cell[219927, 7796, 133, 3, 26, "Input",
  CellTags->"General::precw"],
Cell[220063, 7801, 92, 3, 21, "Output",
  CellTags->"General::precw"]
}, Closed]],
Cell[220170, 7807, 315, 10, 40, "Text",
  CellTags->"General::precw"],

Cell[CellGroupData[{
Cell[220510, 7821, 101, 3, 26, "Input",
  CellTags->"General::precw"],
Cell[220614, 7826, 104, 3, 21, "Output",
  CellTags->"General::precw"]
}, Closed]],

Cell[CellGroupData[{
Cell[220755, 7834, 124, 3, 26, "Input",
  CellTags->"General::precw"],
Cell[220882, 7839, 131, 3, 21, "Output",
  CellTags->"General::precw"]
}, Closed]],
Cell[221028, 7845, 410, 10, 56, "Text",
  CellTags->"General::precw"],

Cell[CellGroupData[{
Cell[221463, 7859, 156, 4, 26, "Input",
  CellTags->"General::precw"],
Cell[221622, 7865, 92, 3, 21, "Output",
  CellTags->"General::precw"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[221775, 7875, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::unfl"],
Cell[221857, 7878, 237, 7, 21, "Message",
  CellTags->"General::unfl"],
Cell[222097, 7887, 610, 15, 100, "Notes",
  CellTags->"General::unfl"],

Cell[CellGroupData[{
Cell[222732, 7906, 63, 1, 38, "ExampleSection",
  CellTags->"General::unfl"],
Cell[222798, 7909, 214, 6, 40, "Text",
  CellTags->"General::unfl"],

Cell[CellGroupData[{
Cell[223037, 7919, 103, 3, 26, "Input",
  CellTags->"General::unfl"],
Cell[223143, 7924, 168, 4, 21, "Message",
  CellTags->"General::unfl"],
Cell[223314, 7930, 98, 3, 21, "Output",
  CellTags->"General::unfl"]
}, Closed]],

Cell[CellGroupData[{
Cell[223449, 7938, 96, 3, 26, "Input",
  CellTags->"General::unfl"],
Cell[223548, 7943, 150, 4, 23, "Output",
  CellTags->"General::unfl"]
}, Closed]],
Cell[223713, 7950, 176, 6, 24, "Text",
  CellTags->"General::unfl"],

Cell[CellGroupData[{
Cell[223914, 7960, 130, 3, 26, "Input",
  CellTags->"General::unfl"],
Cell[224047, 7965, 106, 3, 21, "Output",
  CellTags->"General::unfl"]
}, Closed]],
Cell[224168, 7971, 242, 6, 40, "Text",
  CellTags->"General::unfl"],

Cell[CellGroupData[{
Cell[224435, 7981, 160, 4, 26, "Input",
  CellTags->"General::unfl"],
Cell[224598, 7987, 168, 4, 21, "Message",
  CellTags->"General::unfl"],
Cell[224769, 7993, 106, 3, 21, "Output",
  CellTags->"General::unfl"]
}, Closed]],

Cell[CellGroupData[{
Cell[224912, 8001, 129, 3, 26, "Input",
  CellTags->"General::unfl"],
Cell[225044, 8006, 100, 3, 36, "Output",
  CellTags->"General::unfl"]
}, Closed]],
Cell[225159, 8012, 137, 4, 24, "Text",
  CellTags->"General::unfl"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[225345, 8022, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::ovfl"],
Cell[225427, 8025, 288, 9, 21, "Message",
  CellTags->"General::ovfl"],
Cell[225718, 8036, 588, 14, 100, "Notes",
  CellTags->"General::ovfl"],

Cell[CellGroupData[{
Cell[226331, 8054, 63, 1, 38, "ExampleSection",
  CellTags->"General::ovfl"],
Cell[226397, 8057, 213, 6, 40, "Text",
  CellTags->"General::ovfl"],

Cell[CellGroupData[{
Cell[226635, 8067, 98, 3, 26, "Input",
  CellTags->"General::ovfl"],
Cell[226736, 8072, 167, 4, 21, "Message",
  CellTags->"General::ovfl"],
Cell[226906, 8078, 97, 3, 21, "Output",
  CellTags->"General::ovfl"]
}, Closed]],

Cell[CellGroupData[{
Cell[227040, 8086, 96, 3, 26, "Input",
  CellTags->"General::ovfl"],
Cell[227139, 8091, 149, 4, 23, "Output",
  CellTags->"General::ovfl"]
}, Closed]],
Cell[227303, 8098, 173, 6, 24, "Text",
  CellTags->"General::ovfl"],

Cell[CellGroupData[{
Cell[227501, 8108, 119, 3, 26, "Input",
  CellTags->"General::ovfl"],
Cell[227623, 8113, 167, 4, 21, "Message",
  CellTags->"General::ovfl"],
Cell[227793, 8119, 223, 5, 37, "Message",
  CellTags->"General::ovfl"],
Cell[228019, 8126, 143, 3, 26, "Output",
  CellTags->"General::ovfl"]
}, Closed]],
Cell[228177, 8132, 135, 4, 24, "Text",
  CellTags->"General::ovfl"],

Cell[CellGroupData[{
Cell[228337, 8140, 118, 3, 26, "Input",
  CellTags->"General::ovfl"],
Cell[228458, 8145, 123, 3, 21, "Output",
  CellTags->"General::ovfl"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[228642, 8155, 105, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ContinuedFraction::noterms"],
Cell[228750, 8158, 306, 6, 53, "Message",
  CellTags->"ContinuedFraction::noterms"],
Cell[229059, 8166, 364, 9, 46, "Notes",
  CellTags->"ContinuedFraction::noterms"],

Cell[CellGroupData[{
Cell[229448, 8179, 76, 1, 38, "ExampleSection",
  CellTags->"ContinuedFraction::noterms"],
Cell[229527, 8182, 240, 6, 40, "Text",
  CellTags->"ContinuedFraction::noterms"],

Cell[CellGroupData[{
Cell[229792, 8192, 120, 3, 26, "Input",
  CellTags->"ContinuedFraction::noterms"],
Cell[229915, 8197, 292, 5, 53, "Message",
  CellTags->"ContinuedFraction::noterms"],
Cell[230210, 8204, 124, 3, 21, "Output",
  CellTags->"ContinuedFraction::noterms"]
}, Closed]],
Cell[230349, 8210, 160, 4, 24, "Text",
  CellTags->"ContinuedFraction::noterms"],

Cell[CellGroupData[{
Cell[230534, 8218, 124, 3, 26, "Input",
  CellTags->"ContinuedFraction::noterms"],
Cell[230661, 8223, 133, 3, 21, "Output",
  CellTags->"ContinuedFraction::noterms"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[230855, 8233, 103, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ContinuedFraction::incomp"],
Cell[230961, 8236, 215, 5, 37, "Message",
  CellTags->"ContinuedFraction::incomp"],
Cell[231179, 8243, 322, 6, 40, "Notes",
  CellTags->"ContinuedFraction::incomp"],

Cell[CellGroupData[{
Cell[231526, 8253, 75, 1, 38, "ExampleSection",
  CellTags->"ContinuedFraction::incomp"],
Cell[231604, 8256, 187, 4, 40, "Text",
  CellTags->"ContinuedFraction::incomp"],

Cell[CellGroupData[{
Cell[231816, 8264, 121, 3, 26, "Input",
  CellTags->"ContinuedFraction::incomp"],
Cell[231940, 8269, 219, 5, 37, "Message",
  CellTags->"ContinuedFraction::incomp"],
Cell[232162, 8276, 102, 3, 21, "Output",
  CellTags->"ContinuedFraction::incomp"]
}, Closed]],
Cell[232279, 8282, 116, 1, 24, "Text",
  CellTags->"ContinuedFraction::incomp"],

Cell[CellGroupData[{
Cell[232420, 8287, 121, 3, 26, "Input",
  CellTags->"ContinuedFraction::incomp"],
Cell[232544, 8292, 102, 3, 21, "Output",
  CellTags->"ContinuedFraction::incomp"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[232707, 8302, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ContinuedFraction::terms"],
Cell[232811, 8305, 249, 5, 53, "Message",
  CellTags->"ContinuedFraction::terms"],
Cell[233063, 8312, 242, 6, 40, "Notes",
  CellTags->"ContinuedFraction::terms"],

Cell[CellGroupData[{
Cell[233330, 8322, 74, 1, 38, "ExampleSection",
  CellTags->"ContinuedFraction::terms"],
Cell[233407, 8325, 301, 7, 40, "Text",
  CellTags->"ContinuedFraction::terms"],

Cell[CellGroupData[{
Cell[233733, 8336, 129, 3, 26, "Input",
  CellTags->"ContinuedFraction::terms"],
Cell[233865, 8341, 271, 5, 53, "Message",
  CellTags->"ContinuedFraction::terms"],
Cell[234139, 8348, 171, 4, 21, "Output",
  CellTags->"ContinuedFraction::terms"]
}, Closed]],
Cell[234325, 8355, 154, 4, 24, "Text",
  CellTags->"ContinuedFraction::terms"],

Cell[CellGroupData[{
Cell[234504, 8363, 133, 3, 26, "Input",
  CellTags->"ContinuedFraction::terms"],
Cell[234640, 8368, 262, 5, 37, "Output",
  CellTags->"ContinuedFraction::terms"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[234963, 8380, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ContinuedFraction::start"],
Cell[235067, 8383, 247, 5, 53, "Message",
  CellTags->"ContinuedFraction::start"],
Cell[235317, 8390, 306, 7, 40, "Notes",
  CellTags->"ContinuedFraction::start"],

Cell[CellGroupData[{
Cell[235648, 8401, 74, 1, 38, "ExampleSection",
  CellTags->"ContinuedFraction::start"],
Cell[235725, 8404, 228, 5, 40, "Text",
  CellTags->"ContinuedFraction::start"],

Cell[CellGroupData[{
Cell[235978, 8413, 122, 3, 26, "Input",
  CellTags->"ContinuedFraction::start"],
Cell[236103, 8418, 259, 5, 53, "Message",
  CellTags->"ContinuedFraction::start"],
Cell[236365, 8425, 123, 3, 21, "Output",
  CellTags->"ContinuedFraction::start"]
}, Closed]],
Cell[236503, 8431, 184, 4, 40, "Text",
  CellTags->"ContinuedFraction::start"],

Cell[CellGroupData[{
Cell[236712, 8439, 142, 3, 26, "Input",
  CellTags->"ContinuedFraction::start"],
Cell[236857, 8444, 298, 6, 55, "Message",
  CellTags->"ContinuedFraction::start"],
Cell[237158, 8452, 294, 6, 55, "Message",
  CellTags->"ContinuedFraction::start"],
Cell[237455, 8460, 296, 6, 53, "Message",
  CellTags->"ContinuedFraction::start"],
Cell[237754, 8468, 145, 3, 23, "Output",
  CellTags->"ContinuedFraction::start"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[237960, 8478, 138, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
Cell[238101, 8484, 527, 14, 37, "Message",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
Cell[238631, 8500, 325, 9, 40, "Notes",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],

Cell[CellGroupData[{
Cell[238981, 8513, 91, 1, 38, "ExampleSection",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
Cell[239075, 8516, 282, 8, 40, "Text",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],

Cell[CellGroupData[{
Cell[239382, 8528, 192, 4, 26, "Input",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
Cell[239577, 8534, 249, 5, 37, "Message",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
Cell[239829, 8541, 198, 4, 21, "Output",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}]
}, Closed]],
Cell[240042, 8548, 214, 7, 24, "Text",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],

Cell[CellGroupData[{
Cell[240281, 8559, 194, 4, 26, "Input",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}],
Cell[240478, 8565, 537, 10, 37, "Output",
  CellTags->{"Fourier::fpopt", "InverseFourier::fpopt"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[241076, 8582, 142, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
Cell[241221, 8588, 743, 17, 69, "Message",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
Cell[241967, 8607, 734, 16, 100, "Notes",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],

Cell[CellGroupData[{
Cell[242726, 8627, 93, 1, 38, "ExampleSection",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
Cell[242822, 8630, 283, 6, 40, "Text",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],

Cell[CellGroupData[{
Cell[243130, 8640, 196, 4, 26, "Input",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
Cell[243329, 8646, 403, 7, 85, "Message",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
Cell[243735, 8655, 512, 8, 21, "Output",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}]
}, Closed]],
Cell[244262, 8666, 216, 7, 24, "Text",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],

Cell[CellGroupData[{
Cell[244503, 8677, 196, 4, 26, "Input",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}],
Cell[244702, 8683, 532, 10, 37, "Output",
  CellTags->{"Fourier::fpopt2", "InverseFourier::fpopt2"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[245295, 8700, 142, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
Cell[245440, 8706, 520, 14, 37, "Message",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
Cell[245963, 8722, 326, 9, 40, "Notes",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],

Cell[CellGroupData[{
Cell[246314, 8735, 93, 1, 38, "ExampleSection",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
Cell[246410, 8738, 248, 6, 40, "Text",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],

Cell[CellGroupData[{
Cell[246683, 8748, 191, 4, 26, "Input",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
Cell[246877, 8754, 245, 5, 37, "Message",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
Cell[247125, 8761, 197, 4, 21, "Output",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}]
}, Closed]],
Cell[247337, 8768, 213, 7, 24, "Text",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],

Cell[CellGroupData[{
Cell[247575, 8779, 227, 5, 42, "Input",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}],
Cell[247805, 8786, 532, 10, 37, "Output",
  CellTags->{"Fourier::fpoptn", "InverseFourier::fpoptn"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[248398, 8803, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::lrgexp"],
Cell[248484, 8806, 401, 12, 21, "Message",
  CellTags->"General::lrgexp"],
Cell[248888, 8820, 386, 7, 62, "Notes",
  CellTags->"General::lrgexp"],

Cell[CellGroupData[{
Cell[249299, 8831, 65, 1, 38, "ExampleSection",
  CellTags->"General::lrgexp"],
Cell[249367, 8834, 182, 6, 24, "Text",
  CellTags->"General::lrgexp"],

Cell[CellGroupData[{
Cell[249574, 8844, 121, 3, 26, "Input",
  CellTags->"General::lrgexp"],
Cell[249698, 8849, 189, 4, 21, "Message",
  CellTags->"General::lrgexp"],
Cell[249890, 8855, 125, 3, 23, "Output",
  CellTags->"General::lrgexp"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[250076, 8865, 344, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "Developer`InequalityInstance::lowpr", "Experimental`ExistsRealQ::lowpr", 
    "Experimental`ForAllRealQ::lowpr", "Experimental`ImpliesRealQ::lowpr"}],
Cell[250423, 8875, 662, 15, 37, "Message",
  CellTags->{
  "Developer`InequalityInstance::lowpr", "Experimental`ExistsRealQ::lowpr", 
    "Experimental`ForAllRealQ::lowpr", "Experimental`ImpliesRealQ::lowpr"}],
Cell[251088, 8892, 295, 6, 24, "Notes",
  CellTags->{
  "Developer`InequalityInstance::lowpr", "Experimental`ExistsRealQ::lowpr", 
    "Experimental`ForAllRealQ::lowpr", "Experimental`ImpliesRealQ::lowpr"}]
}, Closed]],

Cell[CellGroupData[{
Cell[251420, 8903, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::real"],
Cell[251502, 8906, 746, 17, 69, "Message",
  CellTags->"General::real"],
Cell[252251, 8925, 129, 4, 24, "Notes",
  CellTags->"General::real"]
}, Closed]],

Cell[CellGroupData[{
Cell[252417, 8934, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sign"],
Cell[252499, 8937, 425, 11, 53, "Message",
  CellTags->"General::sign"],
Cell[252927, 8950, 324, 9, 46, "Notes",
  CellTags->"General::sign"],

Cell[CellGroupData[{
Cell[253276, 8963, 63, 1, 38, "ExampleSection",
  CellTags->"General::sign"],
Cell[253342, 8966, 346, 8, 56, "Text",
  CellTags->"General::sign"],

Cell[CellGroupData[{
Cell[253713, 8978, 170, 5, 26, "Input",
  CellTags->"General::sign"],
Cell[253886, 8985, 358, 7, 102, "Message",
  CellTags->"General::sign"],
Cell[254247, 8994, 91, 3, 21, "Output",
  CellTags->"General::sign"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[254399, 9004, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NSolve::sfail"],
Cell[254481, 9007, 386, 7, 85, "Message",
  CellTags->"NSolve::sfail"],
Cell[254870, 9016, 124, 4, 24, "Notes",
  CellTags->"NSolve::sfail"]
}, Closed]],

Cell[CellGroupData[{
Cell[255031, 9025, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NSolve::zerosol"],
Cell[255117, 9028, 332, 6, 69, "Message",
  CellTags->"NSolve::zerosol"],
Cell[255452, 9036, 126, 4, 24, "Notes",
  CellTags->"NSolve::zerosol"]
}, Closed]],

Cell[CellGroupData[{
Cell[255615, 9045, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NumericQ::set"],
Cell[255697, 9048, 228, 5, 37, "Message",
  CellTags->"NumericQ::set"],
Cell[255928, 9055, 317, 10, 40, "Notes",
  CellTags->"NumericQ::set"],

Cell[CellGroupData[{
Cell[256270, 9069, 63, 1, 38, "ExampleSection",
  CellTags->"NumericQ::set"],
Cell[256336, 9072, 214, 8, 24, "Text",
  CellTags->"NumericQ::set"],

Cell[CellGroupData[{
Cell[256575, 9084, 110, 3, 26, "Input",
  CellTags->"NumericQ::set"],
Cell[256688, 9089, 250, 5, 41, "Message",
  CellTags->"NumericQ::set"]
}, Closed]],
Cell[256953, 9097, 165, 4, 24, "Text",
  CellTags->"NumericQ::set"],

Cell[CellGroupData[{
Cell[257143, 9105, 103, 3, 26, "Input",
  CellTags->"NumericQ::set"],
Cell[257249, 9110, 90, 3, 24, "Output",
  CellTags->"NumericQ::set"]
}, Closed]],

Cell[CellGroupData[{
Cell[257376, 9118, 107, 3, 26, "Input",
  CellTags->"NumericQ::set"],
Cell[257486, 9123, 91, 3, 21, "Output",
  CellTags->"NumericQ::set"]
}, Closed]],
Cell[257592, 9129, 139, 4, 24, "Text",
  CellTags->"NumericQ::set"],

Cell[CellGroupData[{
Cell[257756, 9137, 93, 3, 26, "Input",
  CellTags->"NumericQ::set"],
Cell[257852, 9142, 106, 3, 21, "Output",
  CellTags->"NumericQ::set"]
}, Closed]],

Cell[CellGroupData[{
Cell[257995, 9150, 105, 3, 26, "Input",
  CellTags->"NumericQ::set"],
Cell[258103, 9155, 91, 3, 21, "Output",
  CellTags->"NumericQ::set"]
}, Closed]],
Cell[258209, 9161, 83, 1, 24, "Text",
  CellTags->"NumericQ::set"],
Cell[258295, 9164, 120, 3, 26, "Input",
  CellTags->"NumericQ::set"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[258464, 9173, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NumericQ::unset"],
Cell[258550, 9176, 187, 4, 21, "Message",
  CellTags->"NumericQ::unset"],
Cell[258740, 9182, 464, 16, 46, "Notes",
  CellTags->"NumericQ::unset"],

Cell[CellGroupData[{
Cell[259229, 9202, 65, 1, 38, "ExampleSection",
  CellTags->"NumericQ::unset"],
Cell[259297, 9205, 172, 5, 24, "Text",
  CellTags->"NumericQ::unset"],

Cell[CellGroupData[{
Cell[259494, 9214, 109, 3, 26, "Input",
  CellTags->"NumericQ::unset"],
Cell[259606, 9219, 216, 5, 37, "Message",
  CellTags->"NumericQ::unset"]
}, Closed]],
Cell[259837, 9227, 145, 5, 24, "Text",
  CellTags->"NumericQ::unset"],
Cell[259985, 9234, 106, 3, 26, "Input",
  CellTags->"NumericQ::unset"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[260140, 9243, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NRoots::nnumeq"],
Cell[260224, 9246, 229, 5, 37, "Message",
  CellTags->"NRoots::nnumeq"],
Cell[260456, 9253, 244, 7, 24, "Notes",
  CellTags->"NRoots::nnumeq"],

Cell[CellGroupData[{
Cell[260725, 9264, 64, 1, 38, "ExampleSection",
  CellTags->"NRoots::nnumeq"],
Cell[260792, 9267, 178, 5, 24, "Text",
  CellTags->"NRoots::nnumeq"],

Cell[CellGroupData[{
Cell[260995, 9276, 112, 3, 26, "Input",
  CellTags->"NRoots::nnumeq"],
Cell[261110, 9281, 290, 6, 39, "Message",
  CellTags->"NRoots::nnumeq"],
Cell[261403, 9289, 114, 3, 23, "Output",
  CellTags->"NRoots::nnumeq"]
}, Closed]],
Cell[261532, 9295, 127, 5, 24, "Text",
  CellTags->"NRoots::nnumeq"],

Cell[CellGroupData[{
Cell[261684, 9304, 123, 3, 26, "Input",
  CellTags->"NRoots::nnumeq"],
Cell[261810, 9309, 283, 6, 21, "Output",
  CellTags->"NRoots::nnumeq"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[262154, 9322, 220, 6, 51, "ObjectNameWarningMessages",
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}],
Cell[262377, 9330, 418, 12, 37, "Message",
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}],
Cell[262798, 9344, 362, 9, 40, "Notes",
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}],

Cell[CellGroupData[{
Cell[263185, 9357, 136, 3, 38, "ExampleSection",
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}],
Cell[263324, 9362, 289, 9, 24, "Text",
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}],

Cell[CellGroupData[{
Cell[263638, 9375, 194, 5, 26, "Input",
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}],
Cell[263835, 9382, 337, 7, 53, "Message",
  CellTags->{
  "Experimental`$EqualTolerance::tolset", 
    "Experimental`$SameQTolerance::tolset"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[264233, 9396, 336, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
    "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}],
Cell[264572, 9406, 608, 13, 85, "Message",
  CellTags->{
  "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
    "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}],
Cell[265183, 9421, 258, 6, 24, "Notes",
  CellTags->{
  "Developer`InequalityInstance::wkno", "Experimental`ExistsRealQ::wkno", 
    "Experimental`ForAllRealQ::wkno", "Experimental`ImpliesRealQ::wkno"}]
}, Closed]],

Cell[CellGroupData[{
Cell[265478, 9432, 107, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FromContinuedFraction::root"],
Cell[265588, 9435, 231, 4, 37, "Message",
  CellTags->"FromContinuedFraction::root"],
Cell[265822, 9441, 138, 4, 24, "Notes",
  CellTags->"FromContinuedFraction::root"]
}, Closed]],

Cell[CellGroupData[{
Cell[265997, 9450, 148, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Interpolation::per", "ListInterpolation::per"}],
Cell[266148, 9456, 331, 8, 37, "Message",
  CellTags->{"Interpolation::per", "ListInterpolation::per"}],
Cell[266482, 9466, 157, 4, 24, "Notes",
  CellTags->{"Interpolation::per", "ListInterpolation::per"}]
}, Closed]],

Cell[CellGroupData[{
Cell[266676, 9475, 65, 1, 31, "ObjectNameWarningMessages",
  CellTags->"N::arg"],
Cell[266744, 9478, 163, 3, 21, "Message",
  CellTags->"N::arg"],
Cell[266910, 9483, 117, 4, 24, "Notes",
  CellTags->"N::arg"]
}, Closed]],

Cell[CellGroupData[{
Cell[267064, 9492, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NIntegrate::singd"],
Cell[267154, 9495, 338, 6, 69, "Message",
  CellTags->"NIntegrate::singd"],
Cell[267495, 9503, 128, 4, 24, "Notes",
  CellTags->"NIntegrate::singd"]
}, Closed]],

Cell[CellGroupData[{
Cell[267660, 9512, 105, 1, 31, "ObjectNameWarningMessages",
  CellTags->"System`Private`NRoot::bdst"],
Cell[267768, 9515, 212, 3, 37, "Message",
  CellTags->"System`Private`NRoot::bdst"],
Cell[267983, 9520, 137, 4, 24, "Notes",
  CellTags->"System`Private`NRoot::bdst"]
}, Closed]],

Cell[CellGroupData[{
Cell[268157, 9529, 105, 1, 31, "ObjectNameWarningMessages",
  CellTags->"System`Private`NRoot::nnum"],
Cell[268265, 9532, 181, 3, 21, "Message",
  CellTags->"System`Private`NRoot::nnum"],
Cell[268449, 9537, 137, 4, 24, "Notes",
  CellTags->"System`Private`NRoot::nnum"]
}, Closed]],

Cell[CellGroupData[{
Cell[268623, 9546, 105, 1, 31, "ObjectNameWarningMessages",
  CellTags->"System`Private`NRRoot::bpa"],
Cell[268731, 9549, 201, 3, 21, "Message",
  CellTags->"System`Private`NRRoot::bpa"],
Cell[268935, 9554, 137, 4, 24, "Notes",
  CellTags->"System`Private`NRRoot::bpa"]
}, Closed]],

Cell[CellGroupData[{
Cell[269109, 9563, 107, 1, 31, "ObjectNameWarningMessages",
  CellTags->"System`Private`NRRoot::bfac"],
Cell[269219, 9566, 268, 4, 37, "Message",
  CellTags->"System`Private`NRRoot::bfac"],
Cell[269490, 9572, 138, 4, 24, "Notes",
  CellTags->"System`Private`NRRoot::bfac"]
}, Closed]],

Cell[CellGroupData[{
Cell[269665, 9581, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NSolve::closesols"],
Cell[269755, 9584, 371, 7, 53, "Message",
  CellTags->"NSolve::closesols"],
Cell[270129, 9593, 128, 4, 24, "Notes",
  CellTags->"NSolve::closesols"]
}, Closed]],

Cell[CellGroupData[{
Cell[270294, 9602, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NSolve::illcnd"],
Cell[270378, 9605, 394, 7, 53, "Message",
  CellTags->"NSolve::illcnd"],
Cell[270775, 9614, 125, 4, 24, "Notes",
  CellTags->"NSolve::illcnd"]
}, Closed]],

Cell[CellGroupData[{
Cell[270937, 9623, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NSolve::nsolprec"],
Cell[271025, 9626, 225, 4, 37, "Message",
  CellTags->"NSolve::nsolprec"],
Cell[271253, 9632, 127, 4, 24, "Notes",
  CellTags->"NSolve::nsolprec"]
}, Closed]],

Cell[CellGroupData[{
Cell[271417, 9641, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"NSolve::infsolns"],
Cell[271505, 9644, 250, 5, 37, "Message",
  CellTags->"NSolve::infsolns"],
Cell[271758, 9651, 127, 4, 24, "Notes",
  CellTags->"NSolve::infsolns"]
}, Closed]],

Cell[CellGroupData[{
Cell[271922, 9660, 141, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::largd"],
Cell[272066, 9664, 270, 5, 37, "Message",
  CellTags->"Experimental`CreateNumericalFunction::largd"],
Cell[272339, 9671, 154, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::largd"]
}, Closed]],

Cell[CellGroupData[{
Cell[272530, 9680, 141, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::dlist"],
Cell[272674, 9684, 242, 4, 37, "Message",
  CellTags->"Experimental`CreateNumericalFunction::dlist"],
Cell[272919, 9690, 154, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::dlist"]
}, Closed]],

Cell[CellGroupData[{
Cell[273110, 9699, 141, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::largs"],
Cell[273254, 9703, 272, 5, 37, "Message",
  CellTags->"Experimental`CreateNumericalFunction::largs"],
Cell[273529, 9710, 154, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::largs"]
}, Closed]],

Cell[CellGroupData[{
Cell[273720, 9719, 143, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::nosamp"],
Cell[273866, 9723, 244, 4, 37, "Message",
  CellTags->"Experimental`CreateNumericalFunction::nosamp"],
Cell[274113, 9729, 155, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::nosamp"]
}, Closed]],

Cell[CellGroupData[{
Cell[274305, 9738, 143, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::scdims"],
Cell[274451, 9742, 278, 5, 53, "Message",
  CellTags->"Experimental`CreateNumericalFunction::scdims"],
Cell[274732, 9749, 155, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::scdims"]
}, Closed]],

Cell[CellGroupData[{
Cell[274924, 9758, 141, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::srect"],
Cell[275068, 9762, 275, 5, 53, "Message",
  CellTags->"Experimental`CreateNumericalFunction::srect"],
Cell[275346, 9769, 154, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::srect"]
}, Closed]],

Cell[CellGroupData[{
Cell[275537, 9778, 137, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::pval"],
Cell[275677, 9781, 244, 4, 37, "Message",
  CellTags->"Experimental`CreateNumericalFunction::pval"],
Cell[275924, 9787, 153, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::pval"]
}, Closed]],

Cell[CellGroupData[{
Cell[276114, 9796, 137, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::pdim"],
Cell[276254, 9799, 305, 5, 53, "Message",
  CellTags->"Experimental`CreateNumericalFunction::pdim"],
Cell[276562, 9806, 153, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::pdim"]
}, Closed]],

Cell[CellGroupData[{
Cell[276752, 9815, 141, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::dimsl"],
Cell[276896, 9819, 271, 5, 37, "Message",
  CellTags->"Experimental`CreateNumericalFunction::dimsl"],
Cell[277170, 9826, 154, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::dimsl"]
}, Closed]],

Cell[CellGroupData[{
Cell[277361, 9835, 143, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::ardims"],
Cell[277507, 9839, 357, 6, 69, "Message",
  CellTags->"Experimental`CreateNumericalFunction::ardims"],
Cell[277867, 9847, 155, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::ardims"]
}, Closed]],

Cell[CellGroupData[{
Cell[278059, 9856, 133, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::jg"],
Cell[278195, 9859, 261, 5, 37, "Message",
  CellTags->"Experimental`CreateNumericalFunction::jg"],
Cell[278459, 9866, 151, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::jg"]
}, Closed]],

Cell[CellGroupData[{
Cell[278647, 9875, 145, 2, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::arglist"],
Cell[278795, 9879, 302, 5, 53, "Message",
  CellTags->"Experimental`CreateNumericalFunction::arglist"],
Cell[279100, 9886, 156, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::arglist"]
}, Closed]],

Cell[CellGroupData[{
Cell[279293, 9895, 137, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::msym"],
Cell[279433, 9898, 241, 4, 37, "Message",
  CellTags->"Experimental`CreateNumericalFunction::msym"],
Cell[279677, 9904, 153, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::msym"]
}, Closed]],

Cell[CellGroupData[{
Cell[279867, 9913, 137, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::rdim"],
Cell[280007, 9916, 299, 5, 53, "Message",
  CellTags->"Experimental`CreateNumericalFunction::rdim"],
Cell[280309, 9923, 153, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::rdim"]
}, Closed]],

Cell[CellGroupData[{
Cell[280499, 9932, 161, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Gradient::smeth", "Jacobian::smeth", "Hessian::smeth"}],
Cell[280663, 9939, 505, 12, 69, "Message",
  CellTags->{"Gradient::smeth", "Hessian::smeth", "Jacobian::smeth"}],
Cell[281171, 9953, 165, 4, 24, "Notes",
  CellTags->{"Gradient::smeth", "Jacobian::smeth", "Hessian::smeth"}]
}, Closed]],

Cell[CellGroupData[{
Cell[281373, 9962, 161, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}],
Cell[281537, 9969, 397, 9, 37, "Message",
  CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}],
Cell[281937, 9980, 165, 4, 24, "Notes",
  CellTags->{"Gradient::spopt", "Jacobian::spopt", "Hessian::spopt"}]
}, Closed]],

Cell[CellGroupData[{
Cell[282139, 9989, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Product::div"],
Cell[282219, 9992, 141, 3, 21, "Message",
  CellTags->"Product::div"],
Cell[282363, 9997, 123, 4, 24, "Notes",
  CellTags->"Product::div"]
}, Closed]],

Cell[CellGroupData[{
Cell[282523, 10006, 111, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Experimental`NumberScale::num"],
Cell[282637, 10009, 183, 3, 21, "Message",
  CellTags->"Experimental`NumberScale::num"],
Cell[282823, 10014, 140, 4, 24, "Notes",
  CellTags->"Experimental`NumberScale::num"]
}, Closed]],

Cell[CellGroupData[{
Cell[283000, 10023, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Sum::gener"],
Cell[283076, 10026, 139, 3, 21, "Message",
  CellTags->"Sum::gener"],
Cell[283218, 10031, 121, 4, 24, "Notes",
  CellTags->"Sum::gener"]
}, Closed]],

Cell[CellGroupData[{
Cell[283376, 10040, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Total::tlauto"],
Cell[283458, 10043, 295, 6, 69, "Message",
  CellTags->"Total::tlauto"],
Cell[283756, 10051, 124, 4, 24, "Notes",
  CellTags->"Total::tlauto"]
}, Closed]],

Cell[CellGroupData[{
Cell[283917, 10060, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Total::tlep"],
Cell[283995, 10063, 223, 5, 37, "Message",
  CellTags->"Total::tlep"],
Cell[284221, 10070, 122, 4, 24, "Notes",
  CellTags->"Total::tlep"]
}, Closed]],

Cell[CellGroupData[{
Cell[284380, 10079, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Total::tlmth"],
Cell[284460, 10082, 219, 5, 37, "Message",
  CellTags->"Total::tlmth"],
Cell[284682, 10089, 123, 4, 24, "Notes",
  CellTags->"Total::tlmth"]
}, Closed]],

Cell[CellGroupData[{
Cell[284842, 10098, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Total::tllen"],
Cell[284922, 10101, 167, 3, 21, "Message",
  CellTags->"Total::tllen"],
Cell[285092, 10106, 123, 4, 24, "Notes",
  CellTags->"Total::tllen"]
}, Closed]],

Cell[CellGroupData[{
Cell[285252, 10115, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::idid"],
Cell[285334, 10118, 281, 8, 37, "Message",
  CellTags->"General::idid"],
Cell[285618, 10128, 124, 4, 24, "Notes",
  CellTags->"General::idid"]
}, Closed]],

Cell[CellGroupData[{
Cell[285779, 10137, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::wprec"],
Cell[285863, 10140, 318, 8, 37, "Message",
  CellTags->"General::wprec"],
Cell[286184, 10150, 125, 4, 24, "Notes",
  CellTags->"General::wprec"]
}, Closed]],

Cell[CellGroupData[{
Cell[286346, 10159, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::agpginf"],
Cell[286434, 10162, 385, 9, 53, "Message",
  CellTags->"General::agpginf"],
Cell[286822, 10173, 127, 4, 24, "Notes",
  CellTags->"General::agpginf"]
}, Closed]],

Cell[CellGroupData[{
Cell[286986, 10182, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::tma"],
Cell[287066, 10185, 436, 10, 53, "Message",
  CellTags->"General::tma"],
Cell[287505, 10197, 110, 4, 24, "Notes",
  CellTags->"General::tma"]
}, Closed]],

Cell[CellGroupData[{
Cell[287652, 10206, 111, 1, 31, "ObjectNameWarningMessages",
  CellTags->"InterpolatingFunction::cmpile"],
Cell[287766, 10209, 305, 5, 53, "Message",
  CellTags->"InterpolatingFunction::cmpile"],
Cell[288074, 10216, 209, 6, 24, "Notes",
  CellTags->"InterpolatingFunction::cmpile"]
}, Closed]],

Cell[CellGroupData[{
Cell[288320, 10227, 103, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ListInterpolation::ingrdm"],
Cell[288426, 10230, 302, 5, 53, "Message",
  CellTags->"ListInterpolation::ingrdm"],
Cell[288731, 10237, 205, 5, 40, "Notes",
  CellTags->"ListInterpolation::ingrdm"],

Cell[CellGroupData[{
Cell[288961, 10246, 75, 1, 38, "ExampleSection",
  CellTags->"ListInterpolation::ingrdm"],
Cell[289039, 10249, 210, 5, 40, "Text",
  CellTags->"ListInterpolation::ingrdm"],

Cell[CellGroupData[{
Cell[289274, 10258, 143, 3, 26, "Input",
  CellTags->"ListInterpolation::ingrdm"],
Cell[289420, 10263, 299, 6, 53, "Message",
  CellTags->"ListInterpolation::ingrdm"],
Cell[289722, 10271, 144, 3, 21, "Output",
  CellTags->"ListInterpolation::ingrdm"]
}, Closed]],
Cell[289881, 10277, 160, 5, 24, "Text",
  CellTags->"ListInterpolation::ingrdm"],

Cell[CellGroupData[{
Cell[290066, 10286, 145, 3, 26, "Input",
  CellTags->"ListInterpolation::ingrdm"],
Cell[290214, 10291, 180, 5, 21, "Output",
  CellTags->"ListInterpolation::ingrdm"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[290455, 10303, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nlnum"],
Cell[290539, 10306, 303, 8, 37, "Message",
  CellTags->"General::nlnum"],
Cell[290845, 10316, 125, 4, 24, "Notes",
  CellTags->"General::nlnum"]
}, Closed]],

Cell[CellGroupData[{
Cell[291007, 10325, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nlnum1"],
Cell[291093, 10328, 318, 8, 37, "Message",
  CellTags->"General::nlnum1"],
Cell[291414, 10338, 126, 4, 24, "Notes",
  CellTags->"General::nlnum1"]
}, Closed]],

Cell[CellGroupData[{
Cell[291577, 10347, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::njnum"],
Cell[291661, 10350, 331, 10, 21, "Message",
  CellTags->"General::njnum"],
Cell[291995, 10362, 556, 10, 78, "Notes",
  CellTags->"General::njnum"],

Cell[CellGroupData[{
Cell[292576, 10376, 64, 1, 38, "ExampleSection",
  CellTags->"General::njnum"],
Cell[292643, 10379, 182, 4, 40, "Text",
  CellTags->"General::njnum"],

Cell[CellGroupData[{
Cell[292850, 10387, 134, 3, 26, "Input",
  CellTags->"General::njnum"],
Cell[292987, 10392, 255, 5, 37, "Message",
  CellTags->"General::njnum"],
Cell[293245, 10399, 103, 3, 21, "Output",
  CellTags->"General::njnum"]
}, Closed]],
Cell[293363, 10405, 179, 7, 24, "Text",
  CellTags->"General::njnum"],

Cell[CellGroupData[{
Cell[293567, 10416, 168, 4, 26, "Input",
  CellTags->"General::njnum"],
Cell[293738, 10422, 119, 3, 21, "Output",
  CellTags->"General::njnum"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[293918, 10432, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::njnum1"],
Cell[294004, 10435, 347, 10, 37, "Message",
  CellTags->"General::njnum1"],
Cell[294354, 10447, 126, 4, 24, "Notes",
  CellTags->"General::njnum1"]
}, Closed]],

Cell[CellGroupData[{
Cell[294517, 10456, 81, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::nhnum"],
Cell[294601, 10459, 330, 10, 21, "Message",
  CellTags->"General::nhnum"],
Cell[294934, 10471, 125, 4, 24, "Notes",
  CellTags->"General::nhnum"]
}, Closed]],

Cell[CellGroupData[{
Cell[295096, 10480, 83, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::nhnum1"],
Cell[295182, 10483, 346, 10, 37, "Message",
  CellTags->"General::nhnum1"],
Cell[295531, 10495, 126, 4, 24, "Notes",
  CellTags->"General::nhnum1"]
}, Closed]],

Cell[CellGroupData[{
Cell[295694, 10504, 81, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::nrnum"],
Cell[295778, 10507, 273, 7, 21, "Message",
  CellTags->"General::nrnum"],
Cell[296054, 10516, 125, 4, 24, "Notes",
  CellTags->"General::nrnum"]
}, Closed]],

Cell[CellGroupData[{
Cell[296216, 10525, 83, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::nrnum1"],
Cell[296302, 10528, 290, 8, 37, "Message",
  CellTags->"General::nrnum1"],
Cell[296595, 10538, 126, 4, 24, "Notes",
  CellTags->"General::nrnum1"]
}, Closed]],

Cell[CellGroupData[{
Cell[296758, 10547, 83, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::nrlnum"],
Cell[296844, 10550, 311, 8, 37, "Message",
  CellTags->"General::nrlnum"],
Cell[297158, 10560, 126, 4, 24, "Notes",
  CellTags->"General::nrlnum"]
}, Closed]],

Cell[CellGroupData[{
Cell[297321, 10569, 85, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::nrlnum1"],
Cell[297409, 10572, 326, 8, 37, "Message",
  CellTags->"General::nrlnum1"],
Cell[297738, 10582, 127, 4, 24, "Notes",
  CellTags->"General::nrlnum1"]
}, Closed]],

Cell[CellGroupData[{
Cell[297902, 10591, 83, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::nrgnum"],
Cell[297988, 10594, 338, 10, 21, "Message",
  CellTags->"General::nrgnum"],
Cell[298329, 10606, 126, 4, 24, "Notes",
  CellTags->"General::nrgnum"]
}, Closed]],

Cell[CellGroupData[{
Cell[298492, 10615, 85, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::nrgnum1"],
Cell[298580, 10618, 366, 11, 37, "Message",
  CellTags->"General::nrgnum1"],
Cell[298949, 10631, 127, 4, 24, "Notes",
  CellTags->"General::nrgnum1"]
}, Closed]],

Cell[CellGroupData[{
Cell[299113, 10640, 83, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::nrjnum"],
Cell[299199, 10643, 338, 10, 21, "Message",
  CellTags->"General::nrjnum"],
Cell[299540, 10655, 126, 4, 24, "Notes",
  CellTags->"General::nrjnum"]
}, Closed]],

Cell[CellGroupData[{
Cell[299703, 10664, 85, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::nrjnum1"],
Cell[299791, 10667, 354, 10, 37, "Message",
  CellTags->"General::nrjnum1"],
Cell[300148, 10679, 127, 4, 24, "Notes",
  CellTags->"General::nrjnum1"]
}, Closed]],

Cell[CellGroupData[{
Cell[300312, 10688, 83, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::nrhnum"],
Cell[300398, 10691, 337, 10, 21, "Message",
  CellTags->"General::nrhnum"],
Cell[300738, 10703, 126, 4, 24, "Notes",
  CellTags->"General::nrhnum"]
}, Closed]],

Cell[CellGroupData[{
Cell[300901, 10712, 85, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::nrhnum1"],
Cell[300989, 10715, 353, 10, 37, "Message",
  CellTags->"General::nrhnum1"],
Cell[301345, 10727, 127, 4, 24, "Notes",
  CellTags->"General::nrhnum1"]
}, Closed]],

Cell[CellGroupData[{
Cell[301509, 10736, 81, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::preal"],
Cell[301593, 10739, 373, 11, 21, "Message",
  CellTags->"General::preal"],
Cell[301969, 10752, 125, 4, 24, "Notes",
  CellTags->"General::preal"]
}, Closed]],

Cell[CellGroupData[{
Cell[302131, 10761, 79, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::symd"],
Cell[302213, 10764, 398, 10, 53, "Message",
  CellTags->"General::symd"],
Cell[302614, 10776, 124, 4, 24, "Notes",
  CellTags->"General::symd"]
}, Closed]],

Cell[CellGroupData[{
Cell[302775, 10785, 81, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::symd1"],
Cell[302859, 10788, 358, 9, 37, "Message",
  CellTags->"General::symd1"],
Cell[303220, 10799, 125, 4, 24, "Notes",
  CellTags->"General::symd1"]
}, Closed]],

Cell[CellGroupData[{
Cell[303382, 10808, 81, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::symdv"],
Cell[303466, 10811, 381, 9, 53, "Message",
  CellTags->"General::symdv"],
Cell[303850, 10822, 125, 4, 24, "Notes",
  CellTags->"General::symdv"]
}, Closed]],

Cell[CellGroupData[{
Cell[304012, 10831, 81, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::symfd"],
Cell[304096, 10834, 396, 9, 53, "Message",
  CellTags->"General::symfd"],
Cell[304495, 10845, 125, 4, 24, "Notes",
  CellTags->"General::symfd"]
}, Closed]],

Cell[CellGroupData[{
Cell[304657, 10854, 83, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::vardep"],
Cell[304743, 10857, 347, 8, 37, "Message",
  CellTags->"General::vardep"],
Cell[305093, 10867, 126, 4, 24, "Notes",
  CellTags->"General::vardep"]
}, Closed]],

Cell[CellGroupData[{
Cell[305256, 10876, 79, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::vloc"],
Cell[305338, 10879, 300, 8, 37, "Message",
  CellTags->"General::vloc"],
Cell[305641, 10889, 124, 4, 24, "Notes",
  CellTags->"General::vloc"]
}, Closed]],

Cell[CellGroupData[{
Cell[305802, 10898, 83, 1, 25, "ObjectNameWarningMessages",
  CellTags->"General::vexdep"],
Cell[305888, 10901, 355, 8, 37, "Message",
  CellTags->"General::vexdep"],
Cell[306246, 10911, 126, 4, 24, "Notes",
  CellTags->"General::vexdep"]
}, Closed]],

Cell[CellGroupData[{
Cell[306409, 10920, 143, 2, 25, "ObjectNameWarningMessages",
  CellTags->"Experimental`CreateNumericalFunction::neargs"],
Cell[306555, 10924, 272, 5, 37, "Message",
  CellTags->"Experimental`CreateNumericalFunction::neargs"],
Cell[306830, 10931, 155, 4, 24, "Notes",
  CellTags->"Experimental`CreateNumericalFunction::neargs"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

