(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    344789,      12852]*)
(*NotebookOutlinePosition[    737269,      21331]*)
(*  CellTagsIndexPosition[    727210,      21065]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Programming", "Title"],

Cell[CellGroupData[{

Cell["\<\
Attributes::locked
ClearAll::locked
Protect::locked
SetOptions::locked\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"locked\"\>"}], \(\(:\)\(\ \)\), "Symbol", " ", 
      StyleBox["sym",
        "TI"], " ", "is", " ", \(\(locked\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to change the options or \
attributes of a locked symbol.\n\[FilledSmallSquare] A locked symbol is a \
symbol with the ",
  StyleBox["Locked", "MR"],
  " attribute."
}], "Notes",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],

Cell[TextData[{
  "The symbol ",
  StyleBox["List", "MR"],
  " is locked and cannot be modified."
}], "Text",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Unprotect[List]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],

Cell[BoxData[
    \(Protect::"locked" \(\(:\)\(\ \)\) 
      "Symbol \!\(List\) is locked."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["With::lvw", "ObjectNameWarningMessages",
  CellTags->"With::lvw"],

Cell[BoxData[
    RowBox[{\(With::"lvw"\), \(\(:\)\(\ \)\), "Local", " ", "variable", " ", 
      "specification", " ", 
      StyleBox["spec",
        "TI"], " ", "contains", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(which\ is\ not\ an\ assignment\ to\ a\ \
\(\(symbol\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"With::lvw"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first element in ",
  StyleBox["With", "MR"],
  " is not a list of assignments to symbols.\n\[FilledSmallSquare] You can \
use ",
  StyleBox["Block", "MR"],
  " or ",
  StyleBox["Module", "MR"],
  " to introduce local variables without assigning values to those variables.\
\n\[FilledSmallSquare] Current versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " do not support local variables that are not symbols. "
}], "Notes",
  CellTags->"With::lvw"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"With::lvw"],

Cell[TextData[{
  "This input generates a message because the first element in ",
  StyleBox["With", "MR"],
  " is not a list of assignments to symbols.  The expression ",
  StyleBox["x[0]", "MR"],
  " is a normal expression rather than a symbol."
}], "Text",
  CellTags->"With::lvw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{x[0]}, x[0] = 2; 1 + x[0]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"With::lvw"],

Cell[BoxData[
    \(With::"lvw" \(\(:\)\(\ \)\) 
      "Local variable specification \!\({\(x[0]\)}\) contains \!\(x[0]\) \
which is not an assignment to a symbol."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"With::lvw"],

Cell[BoxData[
    \(With[{x[0]}, x[0] = 2; 1 + x[0]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"With::lvw"]
}, Open  ]],

Cell[TextData[{
  "Correct use of ",
  StyleBox["With", "MR"],
  " requires a list of assignments to symbols."
}], "Text",
  CellTags->"With::lvw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{x0 = 2}, 1 + x0]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"With::lvw"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"With::lvw"]
}, Open  ]],

Cell[TextData[{
  "This message will also be generated if the first element in ",
  StyleBox["With", "MR"],
  " is a list of strings.  You can use ",
  StyleBox["Get", "MR"],
  " or ",
  StyleBox["Needs", "MR"],
  " to load a package.  The ",
  StyleBox["With", "MR"],
  " function is used to set up local values for symbols."
}], "Text",
  CellTags->"With::lvw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{"\<package\>"}, 2 + 2]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"With::lvw"],

Cell[BoxData[
    \(With::"lvw" \(\(:\)\(\ \)\) 
      "Local variable specification \!\({\"package\"}\) contains \
\!\(\"package\"\) which is not an assignment to a symbol."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"With::lvw"],

Cell[BoxData[
    \(With[{"package"}, 2 + 2]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"With::lvw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Replace::reps
ReplaceAll::reps
ReplaceRepeated::reps
ReplaceList::reps\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"reps\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "neither", " ", "a", " ", "list", " ", 
          "of", " ", "replacement", " ", "rules", " ", "nor", " ", "a", " ", 
          "valid", " ", "dispatch", " ", "table"}]}], ",", 
      " ", \(and\ so\ cannot\ be\ used\ for\ \(\(replacing\)\(.\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression does not have \
the expected form of a rule, a list of rules, or a dispatch table.\n\
\[FilledSmallSquare] ",
  StyleBox["ReplaceAll[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["rules", "TI"],
  StyleBox["]", "MR"],
  " is usually entered as ",
  StyleBox["expr", "TI"],
  StyleBox["/.", "MR"],
  StyleBox["rules", "TI"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["ReplaceRepeated[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",", "MR"],
  StyleBox["rules", "TI"],
  StyleBox["]", "MR"],
  " is usually entered as ",
  StyleBox["expr", "TI"],
  StyleBox["//.", "MR"],
  StyleBox["rules", "TI"],
  ".\n\[FilledSmallSquare] A rule is an expression of the form ",
  StyleBox["lhs", "TI"],
  StyleBox["->", "MR"],
  StyleBox["rhs", "TI"],
  " or ",
  StyleBox["lhs", "TI"],
  StyleBox[":>", "MR"],
  StyleBox["rhs", "TI"],
  " (",
  StyleBox["Rule[", "MR"],
  StyleBox["lhs", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["rhs", "TI"],
  StyleBox["]", "MR"],
  " or ",
  StyleBox["RuleDelayed[", "MR"],
  StyleBox["lhs", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["rhs", "TI"],
  StyleBox["]", "MR"],
  ").\n\[FilledSmallSquare] Dispatch tables are constructed using the ",
  StyleBox["Dispatch", "MR"],
  " function."
}], "Notes",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[TextData[{
  "This input generates an error because the expression on the right-hand \
side of ",
  StyleBox["/.", "MR"],
  " (",
  StyleBox["ReplaceRepeated", "MR"],
  ") is not a rule (or a list of rules or a dispatch table)."
}], "Text",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x /. y\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[BoxData[
    \(ReplaceAll::"reps" \(\(:\)\(\ \)\) 
      "\!\({y}\) is neither a list of replacement rules nor a valid dispatch \
table, and so cannot be used for replacing."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
    "Replace::reps"}],

Cell[BoxData[
    \(x /. \[InvisibleSpace]y\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
    "Replace::reps"}]
}, Open  ]],

Cell[TextData[{
  "This type of error frequently occurs following the failure of some other \
calculation.  For example, the invalid ",
  StyleBox["FindRoot", "MR"],
  " input here gives a result that is not a list of rules."
}], "Text",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x /. FindRoot[Sin[x], x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[BoxData[
    \(FindRoot::"fdss" \(\(:\)\(\ \)\) 
      "Search specification \!\(x\) should be a list with a 2-5 \
elements."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{
  "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
    "Replace::reps"}],

Cell[BoxData[
    \(ReplaceAll::"reps" \(\(:\)\(\ \)\) 
      "\!\({\(FindRoot[\(\(\(\(Sin[x]\)\), x\)\)]\)}\) is neither a list of \
replacement rules nor a valid dispatch table, and so cannot be used for \
replacing."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{
  "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
    "Replace::reps"}],

Cell[BoxData[
    \(x /. \[InvisibleSpace]FindRoot[Sin[x], x]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
    "Replace::reps"}]
}, Open  ]],

Cell[TextData[{
  "With correct input to ",
  StyleBox["FindRoot", "MR"],
  ", the result will have the correct form for use in ",
  StyleBox["ReplaceAll", "MR"],
  "."
}], "Text",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x /. FindRoot[Sin[x], {x, 3}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[BoxData[
    \(3.141592653589793`\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{
  "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
    "Replace::reps"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
$ContextPath::cxlist
$Packages::cxlist\
\>", "ObjectNameWarningMessages",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"cxlist\"\>"}], \(\(:\)\(\ \)\), "\<\"Cannot set `1` to \
`2`; value must be a list of strings ending in `3`.\"\>"}]], "Message",
  CellLabel->"From In[52]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to assign to the indicated \
symbol a value that is not a list of context strings.\n\[FilledSmallSquare] A \
valid context string is a string of characters ending with a backquote \
character.\n\[FilledSmallSquare] The values of ",
  StyleBox["$ContextPath", "MR"],
  " and ",
  StyleBox["$Packages", "MR"],
  " are changed automatically by ",
  StyleBox["BeginPackage", "MR"],
  " and related functions and are not often modified directly."
}], "Notes",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],

Cell[TextData[{
  "The value assigned to ",
  StyleBox["$ContextPath", "MR"],
  " must be a list.  When this error occurs, the value of ",
  StyleBox["$ContextPath", "MR"],
  " is left unchanged."
}], "Text",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],

Cell[CellGroupData[{

Cell[BoxData[
    \($ContextPath = "\<Global`\>"\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],

Cell[BoxData[
    \($ContextPath::"cxlist" \(\(:\)\(\ \)\) 
      "Cannot set \!\($ContextPath\) to \!\(\"Global`\"\); value must be a \
list of strings ending in \!\(\"`\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],

Cell[BoxData[
    \("Global`"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$IterationLimit::itlim", "ObjectNameWarningMessages",
  CellTags->"$IterationLimit::itlim"],

Cell[BoxData[
    RowBox[{\($IterationLimit::"itlim"\), \(\(:\)\(\ \)\), \(\(Iteration\)\(\ \
\)\(limit\)\(\ \)\(of\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\(exceeded\)\(.\)\)\)}]], "Message",
  CellTags->"$IterationLimit::itlim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of iterative evaluations of \
an expression exceeds the indicated limit.\n\[FilledSmallSquare] The limit on \
the number of iterative evaluations of an expression is determined by the \
value of ",
  StyleBox["$IterationLimit", "MR"],
  ".\n\[FilledSmallSquare] If your calculation requires a large number of \
iterative evaluations, you can set the value of ",
  StyleBox["$IterationLimit", "MR"],
  " to a large positive integer or to ",
  StyleBox["Infinity", "MR"],
  ".\n\[FilledSmallSquare] This message is sometimes caused by syntax errors, \
such as misplaced \[OpenCurlyDoubleQuote]",
  StyleBox["=", "MR"],
  "\[CloseCurlyDoubleQuote] signs."
}], "Notes",
  CellTags->"$IterationLimit::itlim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$IterationLimit::itlim"],

Cell[TextData[{
  "With this rule for ",
  StyleBox["f[p_]", "MR"],
  ", evaluation of ",
  StyleBox["f[p-1]", "MR"],
  " will lead to infinite iteration."
}], "Text",
  CellTags->"$IterationLimit::itlim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[p_] = \ f[p - 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$IterationLimit::itlim"],

Cell[BoxData[
    \($IterationLimit::"itlim" \(\(:\)\(\ \)\) 
      "Iteration limit of \!\(4096\) exceeded."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$IterationLimit::itlim"],

Cell[BoxData[
    \(Hold[f[\(-1\) + \((\(-4095\) + p)\)]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$IterationLimit::itlim"]
}, Open  ]],

Cell[TextData[{
  "Clear the rule for ",
  StyleBox["f[p_]", "MR"],
  "."
}], "Text",
  CellTags->"$IterationLimit::itlim"],

Cell[BoxData[
    \(Clear[f]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"$IterationLimit::itlim"],

Cell["\<\
A termination rule can be added so that the iteration will \
stop.\
\>", "Text",
  CellTags->"$IterationLimit::itlim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[p_Integer] = f[p - 1]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"$IterationLimit::itlim"],

Cell[BoxData[
    \(f[\(-1\) + p]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"$IterationLimit::itlim"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[0] = 1\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"$IterationLimit::itlim"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"$IterationLimit::itlim"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[10]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"$IterationLimit::itlim"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"$IterationLimit::itlim"]
}, Open  ]],

Cell[TextData[{
  "Clear the rules for ",
  StyleBox["f", "MR"],
  "."
}], "Text",
  CellTags->"$IterationLimit::itlim"],

Cell[BoxData[
    \(Clear[f]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"$IterationLimit::itlim"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$IterationLimit::aitlim", "ObjectNameWarningMessages",
  CellTags->"$IterationLimit::aitlim"],

Cell[BoxData[
    RowBox[{\($IterationLimit::"aitlim"\), \(\(:\)\(\ \)\), "Iteration", " ", 
      "limit", " ", "of", " ", 
      StyleBox["expr",
        "TI"], " ", "exceeded", " ", "during", " ", "evaluation", " ", "with",
       " ", \(\(assumptions\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"$IterationLimit::aitlim"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated iteration limit \
is exceeded and one of the transformations is invoked because of an \
assumption.\
\>", "Notes",
  CellTags->"$IterationLimit::aitlim"]
}, Open  ]],

Cell[CellGroupData[{

Cell["$MaxComputationSteps::complim", "ObjectNameWarningMessages",
  CellTags->"$MaxComputationSteps::complim"],

Cell[BoxData[
    RowBox[{\($MaxComputationSteps::"complim"\), \(\(:\)\(\ \)\), "The", " ", 
      "number", " ", "of", " ", "computation", " ", "steps", " ", "has", " ", 
      "been", " ", "exceeded", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"$MaxComputationSteps::complim"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"$MaxComputationSteps::complim"]
}, Open  ]],

Cell[CellGroupData[{

Cell["$Cache::set", "ObjectNameWarningMessages",
  CellTags->"$Cache::set"],

Cell[BoxData[
    \($Cache::"set" \(\(:\)\(\ \)\) 
      "Cannot set `1` to `2`; value must be True or False."\)], "Message",
  CellLabel->"From In[52]:=",
  CellTags->"$Cache::set"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"$Cache::set"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
$IterationLimit::limset
$RecursionLimit::limset\
\>", "ObjectNameWarningMessages",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"limset\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
        "set", " ", 
        StyleBox["sym",
          "TI"], " ", "to", " ", 
        StyleBox["expr",
          "TI"]}], ";", " ", 
      RowBox[{
      "value", " ", "must", " ", "be", " ", "Infinity", " ", "or", " ", "an", 
        " ", "integer", " ", "at", " ", "least", " ", 
        RowBox[{
          StyleBox["n",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to assign to ",
  StyleBox["$IterationLimit", "MR"],
  " or ",
  StyleBox["$RecursionLimit", "MR"],
  " a value that does not have the indicated form.\n\[FilledSmallSquare] In \
most versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the values of ",
  StyleBox["$IterationLimit", "MR"],
  " and ",
  StyleBox["$RecursionLimit", "MR"],
  " must be larger than 20."
}], "Notes",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],

Cell[TextData[{
  "The value of ",
  StyleBox["$RecursionLimit", "MR"],
  " must be larger than 20.  When this error occurs, the value of ",
  StyleBox["$RecursionLimit", "MR"],
  " is left unchanged."
}], "Text",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],

Cell[CellGroupData[{

Cell[BoxData[
    \($RecursionLimit = 10\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],

Cell[BoxData[
    \($RecursionLimit::"limset" \(\(:\)\(\ \)\) 
      "Cannot set \!\($RecursionLimit\) to \!\(10\); value must be Infinity \
or an integer at least \!\(20\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],

Cell[BoxData[
    \(10\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Replace::erep", "ObjectNameWarningMessages",
  CellTags->"Replace::erep"],

Cell[BoxData[
    RowBox[{\(Replace::"erep"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(must\ be\ evaluated\ before\ \
\(\(use\)\(.\)\)\)\)}]], "Message",
  CellTags->"Replace::erep"],

Cell[TextData[{
  "\[FilledSmallSquare] This message should not be generated in normal use of \
",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  "  If you see this message, please contact Wolfram Research Technical \
Support."
}], "Notes",
  CellTags->"Replace::erep"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
With::dup
Module::dup
Block::dup
Dialog::dup\
\>", "ObjectNameWarningMessages",
  CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"dup\"\>"}], \(\(:\)\(\ \)\), "Duplicate", " ", 
      "local", " ", "variable", " ", 
      StyleBox["var",
        "TI"], " ", "found", " ", "in", " ", "local", " ", "variable", " ", 
      "specification", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],

Cell["\<\
\[FilledSmallSquare] Generated when the same symbol is used two or \
more times in the indicated list of local variables.\
\>", "Notes",
  CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],

Cell["\<\
It is considered an error to include a symbol more than once in a \
list of local variables.\
\>", "Text",
  CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{x, \ y, \ x}, \ x\  = \ 7; \ y\  = \ 5; \ x\  + \ y]\)], "Input",\

  CellLabel->"In[1]:=",
  CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],

Cell[BoxData[
    \(Module::"dup" \(\(:\)\(\ \)\) 
      "Duplicate local variable \!\(x\) found in local variable specification \
\!\({x, y, x}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Block::dup", "Dialog::dup", "Module::dup", "With::dup"}],

Cell[BoxData[
    \(Module[{x, y, x}, x = 7; y = 5; x + y]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Block::dup", "Dialog::dup", "Module::dup", "With::dup"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$ModuleNumber::modnc", "ObjectNameWarningMessages",
  CellTags->"$ModuleNumber::modnc"],

Cell[BoxData[
    \($ModuleNumber::"modnc" \(\(:\)\(\ \)\) \(Newly\ created\ symbol\ names\ \
may\ conflict\ with\ existing\ \(\(ones\)\(.\)\)\)\)], "Message",
  CellTags->"$ModuleNumber::modnc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of ",
  StyleBox["$ModuleNumber", "MR"],
  " is set to a lower value, or to some other value that may lead to \
conflicts between existing symbols and symbols that are generated \
automatically.\n\[FilledSmallSquare] Symbols are generated automatically by \
",
  StyleBox["Module", "MR"],
  " and by ",
  StyleBox["Unique", "MR"],
  ".  The names of these symbols are based on the value of ",
  StyleBox["$ModuleNumber", "MR"],
  "."
}], "Notes",
  CellTags->"$ModuleNumber::modnc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$ModuleNumber::modnc"],

Cell[TextData[{
  "Evaluation of this input causes ",
  StyleBox["Module", "MR"],
  " to generate a new symbol.  The number in the name of this symbol is taken \
from the value of ",
  StyleBox["$ModuleNumber", "MR"],
  "."
}], "Text",
  CellTags->"$ModuleNumber::modnc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{var}, 1 + var]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$ModuleNumber::modnc"],

Cell[BoxData[
    \(1 + var$38841\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$ModuleNumber::modnc"]
}, Open  ]],

Cell[TextData[{
  "Reducing the value of ",
  StyleBox["$ModuleNumber", "MR"],
  " will produce a warning message, since subsequent symbols generated using \
",
  StyleBox["$ModuleNumber", "MR"],
  ", such as symbols generated by ",
  StyleBox["Module", "MR"],
  ", may have the same name as existing symbols."
}], "Text",
  CellTags->"$ModuleNumber::modnc"],

Cell[CellGroupData[{

Cell[BoxData[
    \($ModuleNumber = $ModuleNumber - 1\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"$ModuleNumber::modnc"],

Cell[BoxData[
    \($ModuleNumber::"modnc" \(\(:\)\(\ \)\) 
      "Newly created symbol names may conflict with existing ones."\)], \
"Message",
  CellLabel->"From In[2]:=",
  CellTags->"$ModuleNumber::modnc"],

Cell[BoxData[
    \(38841\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"$ModuleNumber::modnc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$ModuleNumber::set", "ObjectNameWarningMessages",
  CellTags->"$ModuleNumber::set"],

Cell[BoxData[
    RowBox[{\($ModuleNumber::"set"\), \(\(:\)\(\ \)\), "Cannot", " ", "set", 
      " ", 
      StyleBox["sym",
        "TI"], " ", "to", " ", 
      StyleBox["expr",
        "TI"], \(\(;\)\(\ \)\(value\ must\ be\ a\ positive\ \
\(\(integer\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"$ModuleNumber::set"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set the value of ",
  StyleBox["$ModuleNumber", "MR"],
  " to a value that is not a positive integer."
}], "Notes",
  CellTags->"$ModuleNumber::set"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$ModuleNumber::set"],

Cell[TextData[{
  "The value of ",
  StyleBox["$ModuleNumber", "MR"],
  " must be positive.  When this error occurs, the value of ",
  StyleBox["$ModuleNumber", "MR"],
  " is left unchanged."
}], "Text",
  CellTags->"$ModuleNumber::set"],

Cell[CellGroupData[{

Cell[BoxData[
    \($ModuleNumber = 0\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$ModuleNumber::set"],

Cell[BoxData[
    \($ModuleNumber::"set" \(\(:\)\(\ \)\) 
      "Cannot set \!\($ModuleNumber\) to \!\(0\); value must be a positive \
integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$ModuleNumber::set"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$ModuleNumber::set"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CharacterRange::argtype", "ObjectNameWarningMessages",
  CellTags->"CharacterRange::argtype"],

Cell[BoxData[
    RowBox[{\(CharacterRange::"argtype"\), \(\(:\)\(\ \)\), "Arguments", " ", 
      
      StyleBox["e1",
        "TI"], " ", "and", " ", 
      StyleBox["e2",
        "TI"], " ", "of", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(are\ not\ both\ strings\ of\ length\ 1. \)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"CharacterRange::argtype"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the arguments in ",
  StyleBox["CharacterRange", "MR"],
  " are not strings or are strings with more than one character."
}], "Notes",
  CellTags->"CharacterRange::argtype"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"CharacterRange::argtype"],

Cell[TextData[{
  "The arguments in ",
  StyleBox["CharacterRange", "MR"],
  " must be strings."
}], "Text",
  CellTags->"CharacterRange::argtype"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CharacterRange[1, \ 9]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"CharacterRange::argtype"],

Cell[BoxData[
    \(CharacterRange::"argtype" \(\(:\)\(\ \)\) 
      "Arguments \!\(1\) and \!\(9\) of \!\(CharacterRange\) are not both \
strings of length 1."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"CharacterRange::argtype"],

Cell[BoxData[
    \(CharacterRange[1, 9]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"CharacterRange::argtype"]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["CharacterRange", "MR"],
  "."
}], "Text",
  CellTags->"CharacterRange::argtype"],

Cell[CellGroupData[{

Cell[BoxData[
    \(CharacterRange["\<1\>", \ "\<9\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"CharacterRange::argtype"],

Cell[BoxData[
    \({"1", "2", "3", "4", "5", "6", "7", "8", "9"}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"CharacterRange::argtype"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Set::inset", "ObjectNameWarningMessages",
  CellTags->"Set::inset"],

Cell[BoxData[
    \(Set::"inset" \(\(:\)\(\ \)\) \(Assignments\ cannot\ be\ performed\ \
during\ \(\(inspection\)\(.\)\)\)\)], "Message",
  CellTags->"Set::inset"],

Cell[TextData[{
  "\[FilledSmallSquare] This message should not occur in normal use of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  If you see this message, please contact Wolfram Research Technical \
Support for more information.\n\[FilledSmallSquare] Assignments are normally \
allowed during inspection.\n\[FilledSmallSquare] The term \
\[OpenCurlyDoubleQuote]inspection\[CloseCurlyDoubleQuote] in this situation \
refers to a dialog subsession reached from the interrupt menu."
}], "Notes",
  CellTags->"Set::inset"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
With::dups
Module::dups\
\>", "ObjectNameWarningMessages",
  CellTags->{"With::dups", "Module::dups"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"dups\"\>"}], \(\(:\)\(\ \)\), "Conflicting", " ", 
      "local", " ", "variables", " ", 
      StyleBox["s1",
        "TI"], " ", "and", " ", 
      StyleBox["s2",
        "TI"], " ", "found", " ", "in", " ", "local", " ", "variable", " ", 
      "specification", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"With::dups", "Module::dups"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a name that is chosen for a local \
variable in ",
  StyleBox["With", "MR"],
  " or ",
  StyleBox["Module", "MR"],
  " may conflict with a name that is introduced as part of the process of \
variable localization.\n\[FilledSmallSquare] This message can occur if the \
names of local variables end in the ",
  StyleBox["$", "MR"],
  " character.  It is recommended that names of this form be avoided."
}], "Notes",
  CellTags->{"With::dups", "Module::dups"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"With::dups", "Module::dups"}],

Cell[TextData[{
  "Since variable localization may involve generating new symbols by \
appending a ",
  StyleBox["$", "MR"],
  " character to the names of existing symbols, the names in this input may \
lead to conflicts."
}], "Text",
  CellTags->{"With::dups", "Module::dups"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{x = 2, x$ = 1}, x$ + x]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"With::dups", "Module::dups"}],

Cell[BoxData[
    \(With::"dups" \(\(:\)\(\ \)\) 
      "Conflicting local variables \!\(x\) and \!\(x$\) found in local \
variable specification \!\({\(\(x = 2\)\), \(\(x$ = 1\)\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Module::dups", "With::dups"}],

Cell[BoxData[
    \(With[{x = 2, x$ = 1}, x$ + x]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Module::dups", "With::dups"}]
}, Open  ]],

Cell[TextData[{
  "This input shows valid choices for the names of local variables in ",
  StyleBox["With", "MR"],
  "."
}], "Text",
  CellTags->{"With::dups", "Module::dups"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{x = 2, y = 1}, x + y]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"With::dups", "Module::dups"}],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Module::dups", "With::dups"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["With::lvws", "ObjectNameWarningMessages",
  CellTags->"With::lvws"],

Cell[BoxData[
    RowBox[{\(With::"lvws"\), \(\(:\)\(\ \)\), \(\(Variable\)\(\ \)\), 
      StyleBox["var",
        "TI"], \(\(\ \)\(\(in\)\(\ \)\(local\)\(\ \)\(variable\)\(\ \
\)\(specification\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(requires\ a\ \(\(value\)\(.\)\)\)\)}]], "Message",
  CellTags->"With::lvws"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["With", "MR"],
  " is not a list of assignments to symbols."
}], "Notes",
  CellTags->"With::lvws"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"With::lvws"],

Cell[TextData[{
  "Values must be assigned to the local variables listed in the first \
argument of ",
  StyleBox["With", "MR"],
  "."
}], "Text",
  CellTags->"With::lvws"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{x, y}, x = 1; y = 2; x + y]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"With::lvws"],

Cell[BoxData[
    \(With::"lvws" \(\(:\)\(\ \)\) 
      "Variable \!\(x\) in local variable specification \!\({x, y}\) requires \
a value."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"With::lvws"],

Cell[BoxData[
    \(With[{x, y}, x = 1; y = 2; x + y]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"With::lvws"]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of ",
  StyleBox["With", "MR"],
  "."
}], "Text",
  CellTags->"With::lvws"],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{x = 1, y = 2}, x + y]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"With::lvws"],

Cell[BoxData[
    \(3\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"With::lvws"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
AbsoluteOptions::optnf
SetOptions::optnf
Options::optnf\
\>", "ObjectNameWarningMessages",
  CellTags->{"AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"optnf\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "known", " ", "option",
         " ", "for", " ", 
        RowBox[{
          StyleBox["sym",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set or inspect an option \
that is not one of the known options of the indicated symbol.\n\
\[FilledSmallSquare] Options can be added to a symbol ",
  StyleBox["sym", "TI"],
  " by making an assignment to ",
  StyleBox["Options[", "MR"],
  StyleBox["sym", "TI"],
  StyleBox["]", "MR"],
  "."
}], "Notes",
  CellTags->{"AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[TextData[{
  "This input generates an error because ",
  StyleBox["Modulus", "MR"],
  " is not an option of ",
  StyleBox["Integrate", "MR"],
  "."
}], "Text",
  CellTags->{"AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[Integrate, Modulus]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[BoxData[
    \(Options::"optnf" \(\(:\)\(\ \)\) 
      "\!\(Modulus\) is not a known option for \!\(Integrate\)."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->{"AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of the ",
  StyleBox["Options", "MR"],
  " function."
}], "Text",
  CellTags->{"AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[Integrate, GenerateConditions]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[BoxData[
    \({GenerateConditions \[Rule] Automatic}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}]
}, Open  ]],

Cell["\<\
A similar error will result from an attempt to set an unknown \
option.\
\>", "Text",
  CellTags->{"AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[Integrate, Modulus -> 0]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[BoxData[
    \(SetOptions::"optnf" \(\(:\)\(\ \)\) 
      "\!\(Modulus\) is not a known option for \!\(Integrate\)."\)], "Message",\

  CellLabel->"From In[3]:=",
  CellTags->{"AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],

Cell[BoxData[
    \(SetOptions[Integrate, Modulus \[Rule] 0]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Break::nofunc
Continue::nofunc
Return::nofunc\
\>", "ObjectNameWarningMessages",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nofunc\"\>"}], \(\(:\)\(\ \)\), "Function", " ", 
      StyleBox["f",
        "TI"], " ", "not", " ", "found", " ", "enclosing", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the optional second argument in ",
  StyleBox["Break", "MR"],
  ", ",
  StyleBox["Continue", "MR"],
  ", or ",
  StyleBox["Return", "MR"],
  " does not match an enclosing function call.\n\[FilledSmallSquare] The \
second argument in ",
  StyleBox["Break", "MR"],
  ", ",
  StyleBox["Continue", "MR"],
  ", or ",
  StyleBox["Return", "MR"],
  " is a label that specifies the enclosing function or loop that will be \
affected.  If this label is omitted, the affected function or loop is \
determined using built-in heuristics."
}], "Notes",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[TextData[{
  "This message is generated if ",
  StyleBox["Return", "MR"],
  " is used with two arguments and there are no enclosing functions."
}], "Text",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Return[1, 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    \(Return::"nofunc" \(\(:\)\(\ \)\) 
      "Function \!\(2\) not found enclosing \!\(Return[\(\(1, 2\)\)]\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    \(Hold[Return[1, 2]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}]
}, Open  ]],

Cell[TextData[{
  "This shows a typical use of ",
  StyleBox["Return", "MR"],
  " with two arguments.  The second argument is used here to specify that the \
return should be from the enclosing ",
  StyleBox["Module", "MR"],
  "."
}], "Text",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    \(f[n_] := 
      Module[{k}, \n\t\tk = 
          1; \n\t\tDo[\n\t\t\tPrint["\<k = \>", \ k]; \n\t\t\tIf[\(++k\) > n, 
            Return[k, 
              Module]], \n\t\t\t{1000}\n\t\t]; \n\t\t1000\n\t\t]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[3]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]1\),
      SequenceForm[ "k = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[3]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]2\),
      SequenceForm[ "k = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[3]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]3\),
      SequenceForm[ "k = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[3]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}]
}, Open  ]],

Cell[TextData[{
  "Without the second argument in ",
  StyleBox["Return", "MR"],
  ", the default is to return from the enclosing ",
  StyleBox["Do", "MR"],
  " loop, so the return value of the function will be different."
}], "Text",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    \(f[n_] := 
      Module[{k}, \n\t\tk = 
          1; \n\t\tDo[\n\t\t\tPrint["\<k = \>", \ k]; \n\t\t\tIf[\(++k\) > n, 
            Return[k]], \n\t\t\t{1000}\n\t\t]; \n\t\t1000\n\t\t]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[3]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]1\),
      SequenceForm[ "k = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[5]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]2\),
      SequenceForm[ "k = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[5]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]3\),
      SequenceForm[ "k = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[5]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    \(1000\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}]
}, Open  ]],

Cell[TextData[{
  "This shows an incorrect use of the second argument in ",
  StyleBox["Return", "MR"],
  ".  The function ",
  StyleBox["f", "MR"],
  " does not enclose the ",
  StyleBox["Return", "MR"],
  " expression and so cannot be used as a return destination."
}], "Text",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    \(f[n_] := 
      Module[{k}, \n\t\tk = 
          1; \n\t\tDo[\n\t\t\tPrint["\<k = \>", \ k]; \n\t\t\tIf[\(++k\) > n, 
            Return[k, 
              f]], \n\t\t\t{1000}\n\t\t]; \n\t\t1000\n\t\t]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(f[3]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]1\),
      SequenceForm[ "k = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[7]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]2\),
      SequenceForm[ "k = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[7]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]3\),
      SequenceForm[ "k = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[7]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    \(Return::"nofunc" \(\(:\)\(\ \)\) 
      "Function \!\(f\) not found enclosing \!\(Return[\(\(4, f\)\)]\)."\)], \
"Message",
  CellLabel->"From In[7]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    \(Hold[Return[4, f]]\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}]
}, Open  ]],

Cell[TextData[{
  "Clear the definition of ",
  StyleBox["f", "MR"],
  "."
}], "Text",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[BoxData[
    \(Clear[f]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$RecursionLimit::reclim", "ObjectNameWarningMessages",
  CellTags->"$RecursionLimit::reclim"],

Cell[BoxData[
    RowBox[{\($RecursionLimit::"reclim"\), \(\(:\)\(\ \)\), \(\(Recursion\)\(\
\ \)\(depth\)\(\ \)\(of\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\(exceeded\)\(.\)\)\)}]], "Message",
  CellTags->"$RecursionLimit::reclim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an evaluation exceeds the indicated \
number of recursive evaluations.\n\[FilledSmallSquare] The limit on the \
number of levels of recursion that will be used in evaluating an expression \
is given by the value of ",
  StyleBox["$RecursionLimit", "MR"],
  ".\n\[FilledSmallSquare] The value of ",
  StyleBox["$RecursionLimit", "MR"],
  " can be set to a large value or to ",
  StyleBox["Infinity", "MR"],
  " for calculations that require many levels of recursion."
}], "Notes",
  CellTags->"$RecursionLimit::reclim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$RecursionLimit::reclim"],

Cell[TextData[{
  "If ",
  StyleBox["var", "MR"],
  " does not have a value, evaluation of this assignment will generate \
infinite recursion."
}], "Text",
  CellTags->"$RecursionLimit::reclim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(var = var + 1\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$RecursionLimit::reclim"],

Cell[BoxData[
    \($RecursionLimit::"reclim" \(\(:\)\(\ \)\) 
      "Recursion depth of \!\(256\) exceeded."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$RecursionLimit::reclim"],

Cell[BoxData[
    \(255 + Hold[1 + var]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$RecursionLimit::reclim"]
}, Open  ]],

Cell[TextData[{
  "If ",
  StyleBox["var", "MR"],
  " has a value, the same assignment does not lead to infinite recursion."
}], "Text",
  CellTags->"$RecursionLimit::reclim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(var = 17\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"$RecursionLimit::reclim"],

Cell[BoxData[
    \(17\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"$RecursionLimit::reclim"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(var = var + 1\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"$RecursionLimit::reclim"],

Cell[BoxData[
    \(18\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"$RecursionLimit::reclim"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["var", "MR"],
  "."
}], "Text",
  CellTags->"$RecursionLimit::reclim"],

Cell[BoxData[
    \(Clear[var]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"$RecursionLimit::reclim"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Condition::condp", "ObjectNameWarningMessages",
  CellTags->"Condition::condp"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Condition::"condp"\), \(\(:\)\(\ \)\), "Pattern", " ", 
        StyleBox["pat",
          "TI"], " ", "appears", " ", "on", " ", "the", " ", "right"}], "-", 
      RowBox[{\(hand\ side\ of\ condition\), " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Condition::condp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a pattern expression appears on the \
right-hand side of a ",
  StyleBox["Condition", "MR"],
  " pattern.\n\[FilledSmallSquare] This message is a warning about a use of \
pattern expressions that is often an error.  In most useful patterns, pattern \
expressions will only appear on the left-hand side of a condition.\n\
\[FilledSmallSquare] Pattern expressions associated with this warning are \
typically entered using the underscore character, such as ",
  StyleBox["p_", "MR"],
  ", and ",
  StyleBox["Condition[", "MR"],
  StyleBox["patt", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["cond", "TI"],
  StyleBox["]", "MR"],
  " is typically entered as ",
  StyleBox["patt", "TI"],
  StyleBox["/;", "MR"],
  StyleBox["cond", "TI"],
  ".  This message can be generated if underscore patterns occur within ",
  StyleBox["cond", "TI"],
  "."
}], "Notes",
  CellTags->"Condition::condp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Condition::condp"],

Cell["\<\
A warning message is generated in this example because the pattern \
expression appears in an unusual position in the condition.\
\>", "Text",
  CellTags->"Condition::condp"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 2, 3, 4, 5} /. \((p_ /; EvenQ[p_])\) :> 0\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Condition::condp"],

Cell[BoxData[
    \(Condition::"condp" \(\(:\)\(\ \)\) 
      "Pattern \!\(p_\) appears on the right-hand side of condition \
\!\(p_/;\(\(EvenQ[p_]\)\)\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Condition::condp"],

Cell[BoxData[
    \({1, 2, 3, 4, 5}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Condition::condp"]
}, Open  ]],

Cell["This shows a more typical use of patterns in a condition.", "Text",
  CellTags->"Condition::condp"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 2, 3, 4, 5} /. \((p_ /; EvenQ[p])\) :> 0\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Condition::condp"],

Cell[BoxData[
    \({1, 0, 3, 0, 5}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Condition::condp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Optional::opdef", "ObjectNameWarningMessages",
  CellTags->"Optional::opdef"],

Cell[BoxData[
    RowBox[{\(Optional::"opdef"\), \(\(:\)\(\ \)\), \(\(The\)\(\ \
\)\(default\)\(\ \)\(value\)\(\ \)\(for\)\(\ \)\(the\)\(\ \)\(optional\)\(\ \
\)\(argument\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(contains\ a\ \(\(pattern\)\(.\)\)\)\)}]], "Message",
  CellTags->"Optional::opdef"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Optional", "MR"],
  " contains pattern expressions.\n\[FilledSmallSquare] The second argument \
in ",
  StyleBox["Optional", "MR"],
  " is the default value to use for the pattern.\n\[FilledSmallSquare] This \
message is a warning about a potentially ambiguous pattern.  The message can \
be ignored if the use of a pattern expression as a default value is \
intentional.\n\[FilledSmallSquare] Pattern expressions are expressions such \
as ",
  StyleBox["Blank[]", "MR"],
  " (",
  StyleBox["_", "MR"],
  ") and ",
  StyleBox["Alternatives[x, y]", "MR"],
  " (",
  StyleBox["x | y", "MR"],
  ") that are intended for matching expressions other than themselves.\n\
\[FilledSmallSquare] The pattern ",
  StyleBox["Optional[", "MR"],
  StyleBox["p", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["v", "TI"],
  StyleBox["]", "MR"],
  " is commonly entered using the notation ",
  StyleBox["p", "TI"],
  StyleBox[":", "MR"],
  StyleBox["v", "TI"],
  "."
}], "Notes",
  CellTags->"Optional::opdef"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Optional::opdef"],

Cell[TextData[{
  "A warning message is generated in this example because the default value \
in the ",
  StyleBox["Optional", "MR"],
  " pattern includes the pattern expression ",
  StyleBox["Blank[]", "MR"],
  " (",
  StyleBox["_", "MR"],
  ").  The pattern is used as specified despite the warning message."
}], "Text",
  CellTags->"Optional::opdef"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, {2}, 3} /. {p_, q_:  _} -> {p, q}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Optional::opdef"],

Cell[BoxData[
    \(Optional::"opdef" \(\(:\)\(\ \)\) 
      "The default value for the optional argument \!\(q_ : _\) contains a \
pattern."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Optional::opdef"],

Cell[BoxData[
    \(Optional::"opdef" \(\(:\)\(\ \)\) 
      "The default value for the optional argument \!\(q_ : _\) contains a \
pattern."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Optional::opdef"],

Cell[BoxData[
    \({1, {2, _}, 3}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Optional::opdef"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Attributes::attnf", "ObjectNameWarningMessages",
  CellTags->"Attributes::attnf"],

Cell[BoxData[
    RowBox[{\(Attributes::"attnf"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ known\ \(\(attribute\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"Attributes::attnf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set the attributes of a \
symbol to an invalid value.\n\[FilledSmallSquare] The possible attributes for \
symbols are ",
  StyleBox["Protected", "MR"],
  ", ",
  StyleBox["ReadProtected", "MR"],
  ", ",
  StyleBox["Locked", "MR"],
  ", ",
  StyleBox["Temporary", "MR"],
  ", ",
  StyleBox["HoldFirst", "MR"],
  ", ",
  StyleBox["HoldRest", "MR"],
  ", ",
  StyleBox["HoldAll", "MR"],
  ", ",
  StyleBox["Flat", "MR"],
  ", ",
  StyleBox["Orderless", "MR"],
  ", ",
  StyleBox["OneIdentity", "MR"],
  ", ",
  StyleBox["Listable", "MR"],
  ", ",
  StyleBox["Constant", "MR"],
  ", ",
  StyleBox["Stub", "MR"],
  ", ",
  StyleBox["NHoldFirst", "MR"],
  ", ",
  StyleBox["NHoldRest", "MR"],
  ", ",
  StyleBox["NHoldAll", "MR"],
  ", ",
  StyleBox["NumericFunction", "MR"],
  ", ",
  StyleBox["SequenceHold", "MR"],
  ", and ",
  StyleBox["HoldAllComplete", "MR"],
  ".\n\[FilledSmallSquare] The attributes available in each version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " are fixed and cannot be changed."
}], "Notes",
  CellTags->"Attributes::attnf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Attributes::attnf"],

Cell[TextData[{
  StyleBox["Commutative", "MR"],
  " is not a known attribute.  You can use the ",
  StyleBox["Orderless", "MR"],
  " attribute to indicate that an operation is commutative.  When this error \
occurs, the attributes of the symbol are left unchanged."
}], "Text",
  CellTags->"Attributes::attnf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetAttributes[f, Commutative]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Attributes::attnf"],

Cell[BoxData[
    \(Attributes::"attnf" \(\(:\)\(\ \)\) 
      "\!\(Commutative\) is not a known attribute."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Attributes::attnf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Attributes::attsl", "ObjectNameWarningMessages",
  CellTags->"Attributes::attsl"],

Cell[BoxData[
    RowBox[{\(Attributes::"attsl"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ symbol, \ string, \ 
      or\ list\ of\ symbols\ and\ \(\(strings\)\(.\)\)\)\)}]], "Message",
  CellTags->"Attributes::attsl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated argument in the ",
  StyleBox["Attributes", "MR"],
  " function does not have the expected form."
}], "Notes",
  CellTags->"Attributes::attsl"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Block::lockt
Dialog::lockt\
\>", "ObjectNameWarningMessages",
  CellTags->{"Block::lockt", "Dialog::lockt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"lockt\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "localize", " ", "locked", " ", "symbol", " ", 
      StyleBox["sym",
        "TI"], " ", "in", " ", "assignment", " ", 
      StyleBox["expr",
        "TI"], " ", "from", " ", "local", " ", "variable", " ", 
      "specification", " ", 
      RowBox[{
        StyleBox["spec",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Block::lockt", "Dialog::lockt"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a locked symbol is used in an \
assignment in a local variable list.\n\[FilledSmallSquare] Locked symbols \
cannot be used as local variables in ",
  StyleBox["Block", "MR"],
  " or in the ",
  StyleBox["DialogSymbols", "MR"],
  " option of ",
  StyleBox["Dialog", "MR"],
  ".\n\[FilledSmallSquare] A symbol ",
  StyleBox["sym", "TI"],
  " is locked if ",
  StyleBox["Attributes[", "MR"],
  StyleBox["sym", "TI"],
  StyleBox["]", "MR"],
  " includes ",
  StyleBox["Locked", "MR"],
  "."
}], "Notes",
  CellTags->{"Block::lockt", "Dialog::lockt"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Block::lockt", "Dialog::lockt"}],

Cell[TextData[{
  "An error occurs in this example because the symbol ",
  StyleBox["List", "MR"],
  " has the ",
  StyleBox["Locked", "MR"],
  " attribute.  ",
  StyleBox["List", "MR"],
  " cannot be used as a local variable in ",
  StyleBox["Block", "MR"],
  "."
}], "Text",
  CellTags->{"Block::lockt", "Dialog::lockt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{List = Plus}, \ {1, 2, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Block::lockt", "Dialog::lockt"}],

Cell[BoxData[
    \(Block::"lockt" \(\(:\)\(\ \)\) 
      "Cannot localize locked symbol \!\(List\) in assignment \!\(List = Plus\
\) from local variable specification \!\({List = Plus}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Block::lockt", "Dialog::lockt"}],

Cell[BoxData[
    \(Block[{List = Plus}, {1, 2, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Block::lockt", "Dialog::lockt"}]
}, Open  ]],

Cell[TextData[{
  "Any symbol that is not locked can normally be used as a local variable in \
",
  StyleBox["Block", "MR"],
  "."
}], "Text",
  CellTags->{"Block::lockt", "Dialog::lockt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{Plus = List}, 1 + 2 + 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Block::lockt", "Dialog::lockt"}],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Block::lockt", "Dialog::lockt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Block::lockv
Dialog::lockv\
\>", "ObjectNameWarningMessages",
  CellTags->{"Block::lockv", "Dialog::lockv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"lockv\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "localize", " ", "locked", " ", "symbol", " ", 
      StyleBox["sym",
        "TI"], " ", "in", " ", "local", " ", "variable", " ", "specification",
       " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Block::lockv", "Dialog::lockv"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a locked symbol is used as a local \
variable.\n\[FilledSmallSquare] Locked symbols cannot be used as local \
variables in ",
  StyleBox["Block", "MR"],
  ", or in the ",
  StyleBox["DialogSymbols", "MR"],
  " option of ",
  StyleBox["Dialog", "MR"],
  ".\n\[FilledSmallSquare] A symbol ",
  StyleBox["sym", "TI"],
  " is locked if ",
  StyleBox["Attributes[", "MR"],
  StyleBox["sym", "TI"],
  StyleBox["]", "MR"],
  " includes ",
  StyleBox["Locked", "MR"],
  "."
}], "Notes",
  CellTags->{"Block::lockv", "Dialog::lockv"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Block::lockv", "Dialog::lockv"}],

Cell[TextData[{
  "An error occurs in this example because the symbol ",
  StyleBox["List", "MR"],
  " has the ",
  StyleBox["Locked", "MR"],
  " attribute.  ",
  StyleBox["List", "MR"],
  " cannot be used as a local variable in ",
  StyleBox["Block", "MR"],
  "."
}], "Text",
  CellTags->{"Block::lockv", "Dialog::lockv"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{List}, List = {1, 2, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Block::lockv", "Dialog::lockv"}],

Cell[BoxData[
    \(Block::"lockv" \(\(:\)\(\ \)\) 
      "Cannot localize locked symbol \!\(List\) in local variable \
specification \!\({List}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Block::lockv", "Dialog::lockv"}],

Cell[BoxData[
    \(Block[{List}, List = {1, 2, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Block::lockv", "Dialog::lockv"}]
}, Open  ]],

Cell[TextData[{
  "Any symbol that is not locked can normally be used as a local variable in \
",
  StyleBox["Block", "MR"],
  "."
}], "Text",
  CellTags->{"Block::lockv", "Dialog::lockv"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{Plus}, Plus = {1, 2, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Block::lockv", "Dialog::lockv"}],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Block::lockv", "Dialog::lockv"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Block::lvlist
Dialog::lvlist
Module::lvlist
With::lvlist\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"lvlist\"\>"}], \(\(:\)\(\ \)\), "Local", " ", 
      "variable", " ", "specification", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", 
      " ", \(\(List\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated local variable \
specification is not a list.\n\[FilledSmallSquare] The local variable \
specifications associated with this message are the first argument in ",
  StyleBox["Block", "MR"],
  ", ",
  StyleBox["Module", "MR"],
  ", or ",
  StyleBox["With", "MR"],
  " and the value of the ",
  StyleBox["DialogSymbols", "MR"],
  " option in ",
  StyleBox["Dialog", "MR"],
  ".\n\[FilledSmallSquare] The first argument in ",
  StyleBox["Block", "MR"],
  ", the first argument in ",
  StyleBox["Module", "MR"],
  ", and the value of the ",
  StyleBox["DialogSymbols", "MR"],
  " option in ",
  StyleBox["Dialog", "MR"],
  " must be a list of symbols or assignments to symbols.\n\
\[FilledSmallSquare] The first argument in ",
  StyleBox["With", "MR"],
  " must be a list of assignments to symbols.\n\[FilledSmallSquare] If only a \
single local variable is used, the variable or assignment must be enclosed in \
a list."
}], "Notes",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],

Cell["\<\
An error occurs in this example because the first argument is not a \
list.\
\>", "Text",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[x, x = 5; 2\ x + 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],

Cell[BoxData[
    \(Block::"lvlist" \(\(:\)\(\ \)\) 
      "Local variable specification \!\(x\) is not a List."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],

Cell[BoxData[
    \(Block[x, x = 5; 2\ x + 1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid local variable specification in ",
  StyleBox["Block", "MR"],
  "."
}], "Text",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{x}, x = 5; 2\ x + 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],

Cell[BoxData[
    \(11\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Block::lvset
Dialog::lvset
With::lvset
Module::lvset\
\>", "ObjectNameWarningMessages",
  CellTags->{"Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"lvset\"\>"}], \(\(:\)\(\ \)\), "Local", " ", 
        "variable", " ", "specification", " ", 
        StyleBox["spec",
          "TI"], " ", "contains", " ", 
        StyleBox["expr",
          "TI"], " ", "which", " ", "is", " ", "an", " ", "assignment", " ", 
        "to", " ", 
        StyleBox["var",
          "TI"]}], ";", 
      " ", \(only\ assignments\ to\ symbols\ are\ \(\(allowed\)\(.\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an assignment to an expression that is \
not a symbol occurs in a local variable specification in ",
  StyleBox["Block", "MR"],
  ", ",
  StyleBox["Dialog", "MR"],
  ", ",
  StyleBox["With", "MR"],
  ", or ",
  StyleBox["Module", "MR"],
  ".\n\[FilledSmallSquare] The local variable specifications associated with \
this message are the first argument in ",
  StyleBox["Block", "MR"],
  ", ",
  StyleBox["Module", "MR"],
  ", or ",
  StyleBox["With", "MR"],
  " and the value of the ",
  StyleBox["DialogSymbols", "MR"],
  " option in ",
  StyleBox["Dialog", "MR"],
  ".\n\[FilledSmallSquare] The first argument in ",
  StyleBox["Block", "MR"],
  ", the first argument in ",
  StyleBox["Module", "MR"],
  ", and the value of the ",
  StyleBox["DialogSymbols", "MR"],
  " option in ",
  StyleBox["Dialog", "MR"],
  " must be a list of symbols or assignments to symbols.\n\
\[FilledSmallSquare] The first argument in ",
  StyleBox["With", "MR"],
  " must be a list of assignments to symbols."
}], "Notes",
  CellTags->{"Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],

Cell[TextData[{
  "An error occurs in this example because the expression on the left-hand \
side of the assignment in the first argument of ",
  StyleBox["With", "MR"],
  " is a normal expression rather than a symbol."
}], "Text",
  CellTags->{"Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{f[x_] := Sin[x]}, f[1] + f[2]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],

Cell[BoxData[
    \(With::"lvset" \(\(:\)\(\ \)\) 
      "Local variable specification \!\({\(\(f[x_]\)\) := \(\(Sin[x]\)\)}\) \
contains \!\(\(\(f[x_]\)\) := \(\(Sin[x]\)\)\) which is an assignment to \
\!\(f[x_]\); only assignments to symbols are allowed."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}],

Cell[BoxData[
    \(With[{f[x_] := Sin[x]}, f[1] + f[2]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid local variable specification in ",
  StyleBox["With", "MR"],
  "."
}], "Text",
  CellTags->{"Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{f = Sin}, f[1] + f[2]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],

Cell[BoxData[
    \(Sin[1] + Sin[2]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Block::lvsym
Dialog::lvsym
Module::lvsym\
\>", "ObjectNameWarningMessages",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"lvsym\"\>"}], \(\(:\)\(\ \)\), "Local", " ", 
      "variable", " ", "specification", " ", 
      StyleBox["spec",
        "TI"], " ", "contains", " ", 
      StyleBox["expr",
        "TI"], " ", "which", " ", "is", " ", "not", " ", "a", " ", "symbol", 
      " ", "or", " ", "an", " ", "assignment", " ", "to", " ", "a", 
      " ", \(\(symbol\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression from a local \
variable specification is not a symbol or an assignment to a symbol.\n\
\[FilledSmallSquare] The local variable specifications associated with this \
message are the first argument in ",
  StyleBox["Block", "MR"],
  ", the first argument in ",
  StyleBox["Module", "MR"],
  ", and the value of the ",
  StyleBox["DialogSymbols", "MR"],
  " option in ",
  StyleBox["Dialog", "MR"],
  ".\n\[FilledSmallSquare] The first argument in ",
  StyleBox["Block", "MR"],
  ", the first argument in ",
  StyleBox["Module", "MR"],
  ", and the value of the ",
  StyleBox["DialogSymbols", "MR"],
  " option in ",
  StyleBox["Dialog", "MR"],
  " must be a list of symbols or assignments to symbols."
}], "Notes",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["Block", "MR"],
  " includes an expression that is not a symbol."
}], "Text",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{x, f[p_]}, x = 3; f[p_] = p\ x; {f[1], f[2], f[3]}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],

Cell[BoxData[
    \(Block::"lvsym" \(\(:\)\(\ \)\) 
      "Local variable specification \!\({x, \(\(f[p_]\)\)}\) contains \
\!\(f[p_]\) which is not a symbol or an assignment to a symbol."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],

Cell[BoxData[
    \(Block[{x, f[p_]}, x = 3; f[p_] = p\ x; {f[1], f[2], f[3]}]\)], "Output",\

  CellLabel->"Out[1]=",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of local variables in ",
  StyleBox["Block", "MR"],
  "."
}], "Text",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{x, f}, x = 3; f[p_] = p\ x; {f[1], f[2], f[3]}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],

Cell[BoxData[
    \({3, 6, 9}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Break::nofwd", "ObjectNameWarningMessages",
  CellTags->"Break::nofwd"],

Cell[BoxData[
    RowBox[{\(Break::"nofwd"\), \(\(:\)\(\ \)\), \(No\ enclosing\ For, \ 
      While, \ \(\(or\)\(\ \)\(Do\)\(\ \)\(found\)\(\ \)\(for\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Break::nofwd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Break", "MR"],
  " is evaluated and there is no enclosing loop from which to exit."
}], "Notes",
  CellTags->"Break::nofwd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Clear::spsym
ClearAll::spsym\
\>", "ObjectNameWarningMessages",
  CellTags->{"Clear::spsym", "ClearAll::spsym"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"spsym\"\>"}], \(\(:\)\(\ \)\), "Special", " ", 
      "symbol", " ", 
      StyleBox["expr",
        "TI"], " ", "cannot", " ", "be", 
      " ", \(\(cleared\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Clear::spsym", "ClearAll::spsym"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to clear the values of a \
symbol that is used in a special way by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel.\n\[FilledSmallSquare] Special symbols are global variables, such \
as ",
  StyleBox["$RandomState", "MR"],
  " or ",
  StyleBox["$ParentLink", "MR"],
  ", that are set by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel and cannot be cleared."
}], "Notes",
  CellTags->{"Clear::spsym", "ClearAll::spsym"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Clear::spsym", "ClearAll::spsym"}],

Cell[TextData[{
  "The global variable ",
  StyleBox["$RandomState", "MR"],
  " is a special symbol and cannot be cleared."
}], "Text",
  CellTags->{"Clear::spsym", "ClearAll::spsym"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[$RandomState]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Clear::spsym", "ClearAll::spsym"}],

Cell[BoxData[
    \(Clear::"spsym" \(\(:\)\(\ \)\) 
      "Special symbol \!\($RandomState\) cannot be cleared."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ClearAll::spsym", "Clear::spsym"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Remove::spsym", "ObjectNameWarningMessages",
  CellTags->"Remove::spsym"],

Cell[BoxData[
    RowBox[{\(Remove::"spsym"\), \(\(:\)\(\ \)\), \(\(Special\)\(\ \)\(symbol\
\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(cannot\ be\ \(\(removed\)\(.\)\)\)\)}]], "Message",
  CellTags->"Remove::spsym"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to remove a symbol that is \
used in a special way by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel.\n\[FilledSmallSquare] Special symbols are global variables, such \
as ",
  StyleBox["$RandomState", "MR"],
  " or ",
  StyleBox["$ParentLink", "MR"],
  ", that are set by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel and cannot be cleared."
}], "Notes",
  CellTags->"Remove::spsym"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Remove::spsym"],

Cell[TextData[{
  "The global variable ",
  StyleBox["$RandomState", "MR"],
  " is a special symbol and cannot be removed."
}], "Text",
  CellTags->"Remove::spsym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Remove[$RandomState]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Remove::spsym"],

Cell[BoxData[
    \(Remove::"spsym" \(\(:\)\(\ \)\) 
      "Special symbol \!\($RandomState\) cannot be removed."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Remove::spsym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Clear::ssym
ClearAll::ssym
Information::ssym\
\>", "ObjectNameWarningMessages",
  CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ssym\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "symbol", " ", "or", 
        " ", "a", " ", \(\(string\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected \
to be a symbol or a string.\n\[FilledSmallSquare] The arguments in ",
  StyleBox["Clear", "MR"],
  ", ",
  StyleBox["ClearAll", "MR"],
  ", and ",
  StyleBox["Information", "MR"],
  " are expected to be symbols or strings containing the names of symbols.\n\
\[FilledSmallSquare] Subscripted expressions are normal expressions rather \
than symbols.\n\[FilledSmallSquare] You can use ",
  StyleBox["Unset", "MR"],
  " to clear specific rules associated with a symbol."
}], "Notes",
  CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],

Cell["\<\
An error occurs in this example because the argument is a normal \
expression rather than a symbol.\
\>", "Text",
  CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[f[p_]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],

Cell[BoxData[
    \(Clear::"ssym" \(\(:\)\(\ \)\) 
      "\!\(f[p_]\) is not a symbol or a string."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"ClearAll::ssym", "Clear::ssym", "Information::ssym"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ClearAll::clloc", "ObjectNameWarningMessages",
  CellTags->"ClearAll::clloc"],

Cell[BoxData[
    RowBox[{\(ClearAll::"clloc"\), \(\(:\)\(\ \)\), \(\(Cannot\)\(\ \)\(clear\
\)\(\ \)\(local\)\(\ \)\(variable\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"ClearAll::clloc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["ClearAll", "MR"],
  " is used with a local variable in ",
  StyleBox["Block", "MR"],
  " or with a similar local variable in another function."
}], "Notes",
  CellTags->"ClearAll::clloc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ClearAll::clloc"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["ClearAll", "MR"],
  " cannot be used with a local variable in ",
  StyleBox["Block", "MR"],
  "."
}], "Text",
  CellTags->"ClearAll::clloc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{x}, ClearAll[x]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ClearAll::clloc"],

Cell[BoxData[
    \(ClearAll::"clloc" \(\(:\)\(\ \)\) 
      "Cannot clear local variable \!\(x\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ClearAll::clloc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Context::cxdup", "ObjectNameWarningMessages",
  CellTags->"Context::cxdup"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Context::"cxdup"\), \(\(:\)\(\ \)\), \(\(Cannot\)\(\ \
\)\(set\)\(\ \)\), 
        StyleBox["expr",
          "TI"], " ", "to", " ", 
        StyleBox["c",
          "TI"]}], ",", " ", 
      RowBox[{
      "since", " ", "a", " ", "symbol", " ", "already", " ", "exists", " ", 
        "with", " ", "name", " ", 
        StyleBox["var",
          "TI"], " ", "and", " ", "context", " ", 
        RowBox[{
          StyleBox["c",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Context::cxdup"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to change the context of a \
symbol to a context that already contains a symbol with the same name.\n\
\[FilledSmallSquare] The context of a symbol ",
  StyleBox["sym", "TI"],
  " can be changed by making an assignment to ",
  StyleBox["Context[", "MR"],
  StyleBox["sym", "TI"],
  StyleBox["]", "MR"],
  "."
}], "Notes",
  CellTags->"Context::cxdup"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Context::cxdup"],

Cell["\<\
This context assignment generates an error message because there is \
already a symbol with the new name and context.  When this error occurs, the \
context is not changed.\
\>", "Text",
  CellTags->"Context::cxdup"],

Cell[CellGroupData[{

Cell[BoxData[
    \(context1`var\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Context::cxdup"],

Cell[BoxData[
    \(context1`var\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Context::cxdup"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Context[context2`var] = "\<context1`\>"\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Context::cxdup"],

Cell[BoxData[
    \(Context::"cxdup" \(\(:\)\(\ \)\) 
      "Cannot set \!\(Context[context2`var]\) to \!\(\"context1`\"\), since a \
symbol already exists with name \!\(\"var\"\) and context \
\!\(\"context1`\"\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"Context::cxdup"],

Cell[BoxData[
    \("context1`"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Context::cxdup"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Context::cxname", "ObjectNameWarningMessages",
  CellTags->"Context::cxname"],

Cell[BoxData[
    RowBox[{\(Context::"cxname"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "parsable", " ", 
      "context", " ", "name", " ", "ending", " ", "in", " ", 
      RowBox[{
        StyleBox["char",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Context::cxname"],

Cell["\<\
\[FilledSmallSquare] Generated when a string that does not have the \
form of a context string is used to specify a context.
\[FilledSmallSquare] A valid context string ends in a backquote character and \
does not include characters such as minus signs, plus signs, asterisks, and \
other characters that have special meanings in input.\
\>", "Notes",
  CellTags->"Context::cxname"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Context::cxname"],

Cell["\<\
An error occurs in this example because the string used to specify \
a context ends in a forward quote character rather than a backquote \
character.\
\>", "Text",
  CellTags->"Context::cxname"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContextToFileName["\<package'\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Context::cxname"],

Cell[BoxData[
    \(Context::"cxname" \(\(:\)\(\ \)\) 
      "\!\(\"package'\"\) is not a parsable context name ending in \
\!\(\"`\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Context::cxname"],

Cell[BoxData[
    \(ContextToFileName["package'"]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Context::cxname"]
}, Open  ]],

Cell["This example shows a valid context string.", "Text",
  CellTags->"Context::cxname"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContextToFileName["\<package`\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Context::cxname"],

Cell[BoxData[
    \("package.m"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Context::cxname"]
}, Open  ]],

Cell["\<\
Context strings cannot include characters such as the asterisk \
character.\
\>", "Text",
  CellTags->"Context::cxname"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ContextToFileName["\<*`\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Context::cxname"],

Cell[BoxData[
    \(Context::"cxname" \(\(:\)\(\ \)\) 
      "\!\(\"*`\"\) is not a parsable context name ending in \
\!\(\"`\"\)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"Context::cxname"],

Cell[BoxData[
    \(ContextToFileName["*`"]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Context::cxname"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Context::cxset
$Context::cxset\
\>", "ObjectNameWarningMessages",
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"cxset\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
        "set", " ", 
        StyleBox["expr",
          "TI"], " ", "to", " ", 
        StyleBox["val",
          "TI"]}], ";", " ", 
      RowBox[{
      "value", " ", "is", " ", "not", " ", "a", " ", "parsable", " ", 
        "context", " ", "name", " ", "ending", " ", "in", " ", 
        RowBox[{
          StyleBox["char",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell["\<\
\[FilledSmallSquare] Generated by a context assignment in which the \
new context specification does not have the correct form to be a context.
\[FilledSmallSquare] A valid context specification is a string that ends in a \
backquote character and does not include any special characters.\
\>", "Notes",\

  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell["\<\
An error occurs in this example because the string on the \
right-hand side of the assignment is not a valid context specification ending \
in a backquote character.\
\>", "Text",
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell[CellGroupData[{

Cell[BoxData[
    \($Context = "\<package\>"\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell[BoxData[
    \($Context::"cxset" \(\(:\)\(\ \)\) 
      "Cannot set \!\($Context\) to \!\(\"package\"\); value is not a \
parsable context name ending in \!\(\"`\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell[BoxData[
    \("package"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Context::cxset", "$Context::cxset"}]
}, Open  ]],

Cell[TextData[{
  "This example shows a valid context string.  Evaluation of this input will \
change the default context in the current ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session."
}], "Text",
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell[CellGroupData[{

Cell[BoxData[
    \($Context = "\<package`\>"\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell[BoxData[
    \("package`"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Context::cxset", "$Context::cxset"}]
}, Open  ]],

Cell["Restore the default context to the normal value.", "Text",
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell[CellGroupData[{

Cell[BoxData[
    \($Context = "\<Global`\>"\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell[BoxData[
    \("Global`"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"Context::cxset", "$Context::cxset"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ContextToFileName::cxfil", "ObjectNameWarningMessages",
  CellTags->"ContextToFileName::cxfil"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(ContextToFileName::"cxfil"\), \(\(:\)\(\ \)\), 
        RowBox[{"ContextToFileName", "[", 
          StyleBox["arg",
            "TI"], "]"}], " ", "evaluated", " ", "to", " ", 
        StyleBox["expr",
          "TI"]}], ";", " ", \(a\ string\ is\ expected\), ";", " ", 
      RowBox[{"using", " ", 
        RowBox[{
          StyleBox["name",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"ContextToFileName::cxfil"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when there is a rule for ",
  StyleBox["ContextToFileName", "MR"],
  " that gives a result that is not a string.\n\[FilledSmallSquare] Functions \
such as ",
  StyleBox["Needs", "MR"],
  " and ",
  StyleBox["BeginPackage", "MR"],
  " assume that the result from ",
  StyleBox["ContextToFileName", "MR"],
  " will always be a string.  These functions can lead to this message if the \
result from ",
  StyleBox["ContextToFileName", "MR"],
  " is not a string.\n\[FilledSmallSquare] Rules for ",
  StyleBox["ContextToFileName", "MR"],
  " are sometimes added in special situations, such as when the default rules \
for translating a context into a file name do not match the file naming \
conventions of the host computer."
}], "Notes",
  CellTags->"ContextToFileName::cxfil"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ContextToFileName::cxfil"],

Cell[TextData[{
  "Error messages are generated in this example because of an unexpected rule \
for ",
  StyleBox["ContextToFileName", "MR"],
  "."
}], "Text",
  CellTags->"ContextToFileName::cxfil"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{ContextToFileName}, \n\tContextToFileName[_] := Null; \n\t
      Needs["\<package`\>"]\n]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ContextToFileName::cxfil"],

Cell[BoxData[
    \(ContextToFileName::"cxfil" \(\(:\)\(\ \)\) 
      "ContextToFileName[\!\(\"package`\"\)] evaluated to \!\(Null\); a \
string is expected; using \!\(\"package.m\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContextToFileName::cxfil"],

Cell[BoxData[
    \(Get::"noopen" \(\(:\)\(\ \)\) 
      "Cannot open \!\(\"package`\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContextToFileName::cxfil"],

Cell[BoxData[
    \(Needs::"nocont" \(\(:\)\(\ \)\) 
      "Context \!\(\"package`\"\) was not created when Needs was \
evaluated."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ContextToFileName::cxfil"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ContextToFileName::cxfil"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Continue::nofwd", "ObjectNameWarningMessages",
  CellTags->"Continue::nofwd"],

Cell[BoxData[
    RowBox[{\(Continue::"nofwd"\), \(\(:\)\(\ \)\), \(No\ enclosing\ For, \ 
      While, \ \(\(or\)\(\ \)\(Do\)\(\ \)\(found\)\(\ \)\(for\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Continue::nofwd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Continue", "MR"],
  " is evaluated and there is no enclosing loop to continue."
}], "Notes",
  CellTags->"Continue::nofwd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Debug::dbug", "ObjectNameWarningMessages",
  CellTags->"Debug::dbug"],

Cell[BoxData[
    \(Debug::"dbug" \(\(:\)\(\ \)\) \(To\ inspect\ an\ expression, \ 
      just\ evaluate\ it\ \(\(normally\)\(.\)\)\)\)], "Message",
  CellTags->"Debug::dbug"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by miscommunication between the kernel and \
the front end while using ",
  StyleBox["Debug", "MR"],
  ".\n\[FilledSmallSquare] This message is not used in current versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["Debug", "MR"],
  " is an obsolete function, superseded by ",
  StyleBox["Trace", "MR"],
  "."
}], "Notes",
  CellTags->"Debug::dbug"]
}, Open  ]],

Cell[CellGroupData[{

Cell["DeclarePackage::aldec", "ObjectNameWarningMessages",
  CellTags->"DeclarePackage::aldec"],

Cell[BoxData[
    RowBox[{\(DeclarePackage::"aldec"\), \(\(:\)\(\ \)\), "Symbol", " ", 
      StyleBox["sym",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(has\ already\ been\ \(\(declared\)\(.\)\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"DeclarePackage::aldec"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a symbol specified in ",
  StyleBox["DeclarePackage", "MR"],
  " already exists.\n\[FilledSmallSquare] ",
  StyleBox["DeclarePackage", "MR"],
  " is used for causing a package to be loaded automatically when symbols \
defined in that package are first entered. It will not work as intended if \
those symbols have already been entered."
}], "Notes",
  CellTags->"DeclarePackage::aldec"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"DeclarePackage::aldec"],

Cell[TextData[{
  "This pair of inputs generates an error because the symbol specified in ",
  StyleBox["DeclarePackage", "MR"],
  " is introduced by evaluation of the first input."
}], "Text",
  CellTags->"DeclarePackage::aldec"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NewPackage`ComputeResult\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"DeclarePackage::aldec"],

Cell[BoxData[
    \(NewPackage`ComputeResult\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"DeclarePackage::aldec"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(DeclarePackage["\<NewPackage`\>", "\<ComputeResult\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"DeclarePackage::aldec"],

Cell[BoxData[
    \(DeclarePackage::"aldec" \(\(:\)\(\ \)\) 
      "Symbol \!\(\"ComputeResult\"\) in \!\(DeclarePackage[\(\(\"NewPackage`\
\", \"ComputeResult\"\)\)]\) has already been declared."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"DeclarePackage::aldec"],

Cell[BoxData[
    \("NewPackage`"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"DeclarePackage::aldec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DefineExternal::des", "ObjectNameWarningMessages",
  CellTags->"DefineExternal::des"],

Cell[BoxData[
    RowBox[{\(DefineExternal::"des"\), \(\(:\)\(\ \)\), \(\(A\)\(\ \
\)\(definition\)\(\ \)\(for\)\(\ \)\(external\)\(\ \)\(function\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(of\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(was\ not\ created\ because\ of\ a\ syntax\ error . \ 
          The\ external\ function\ may\ still\ be\ called\ with\ \
\(\(ExternalCall\)\([\)\)\)\), 
      StyleBox["expr",
        "TI"], \(\(,\)\(\ \)\(\(CallPacket\)\([\)\)\), 
      StyleBox["expr",
        "TI"], \(\(\(\(\(,\)\(\ \)\({args}\)\)\(]\)\)\(]\)\)\(.\)\)}]], \
"Message",
  CellTags->"DefineExternal::des"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when either of the first two arguments in \
",
  StyleBox["DefineExternal", "MR"],
  " is not syntactically valid.\n\[FilledSmallSquare] The first argument in \
",
  StyleBox["DefineExternal", "MR"],
  " is a string giving the pattern for the external call, and the second \
argument is a string giving the arguments.\n\[FilledSmallSquare] ",
  StyleBox["DefineExternal", "MR"],
  " is invoked by ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs that are generated using ",
  StyleBox["mprep", "MR"],
  " and installed using ",
  StyleBox["Install", "MR"],
  ".  It is not usually called directly.\n\[FilledSmallSquare] The most \
common cause of this error is a syntax error in a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " template file."
}], "Notes",
  CellTags->"DefineExternal::des"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"DefineExternal::des"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["DefineExternal", "MR"],
  " is not a syntactically valid input.  The syntax message is generated when \
",
  StyleBox["DefineExternal", "MR"],
  " tries to translate this argument into an expression."
}], "Text",
  CellTags->"DefineExternal::des"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DefineExternal["\<AddTwo[p_,q_]\>", "\<p,q\>", 1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"DefineExternal::des"],

Cell["\<\
ToExpression::sntx: Syntax error in or before \"p,q\".
                                                 ^\
\>", "Message",
  CellLabel->"From In[1]:=",
  CellTags->"DefineExternal::des"],

Cell[BoxData[
    RowBox[{\(DefineExternal::"des"\), \(\(:\)\(\ \)\), "\<\"A definition for \
external function \\!\\(1\\) of \
\\!\\(\\*FrameBox[\\\"\\\\\\\"$CurrentLink\\\\\\\"\\\", Rule[BoxFrame, \
False], Rule[BoxMargins, False]]\\) was not created because of a syntax \
error. The external function may still be called with \
ExternalCall[\\!\\(\\*FrameBox[\\\"\\\\\\\"$CurrentLink\\\\\\\"\\\", \
Rule[BoxFrame, False], Rule[BoxMargins, False]]\\), CallPacket[\\!\\(1\\), \
{args}]].\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"DefineExternal::des"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dialog::dpa", "ObjectNameWarningMessages",
  CellTags->"Dialog::dpa"],

Cell[BoxData[
    RowBox[{\(Dialog::"dpa"\), \(\(:\)\(\ \)\), \(\(Abort\)\(\ \)\(while\)\(\ \
\)\(evaluating\)\(\ \)\(DialogProlog\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(caught\ in\ \(\(dialog\)\(.\)\)\)\)}]], "Message",
  CellTags->"Dialog::dpa"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an abort occurs during evaluation of \
the ",
  StyleBox["DialogProlog", "MR"],
  " option.\n\[FilledSmallSquare] Since the abort that led to this message \
will also suppress the message, this message is not normally seen."
}], "Notes",
  CellTags->"Dialog::dpa"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dialog::exd", "ObjectNameWarningMessages",
  CellTags->"Dialog::exd"],

Cell[BoxData[
    \(Dialog::"exd" \(\(:\)\(\ \)\) \(To\ exit\ a\ dialog, \ 
      use\ Return[]\ or\ Return[expr] . \ 
          To\ exit\ the\ entire\ Mathematica\ session, \ 
      type\ \(\(Exit[]\)\(.\)\)\)\)], "Message",
  CellTags->"Dialog::exd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Exit", "MR"],
  " or ",
  StyleBox["Quit", "MR"],
  " is used during an interactive dialog initiated by ",
  StyleBox["Dialog", "MR"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["Exit", "MR"],
  " and ",
  StyleBox["Quit", "MR"],
  " are used for exiting a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session."
}], "Notes",
  CellTags->"Dialog::exd"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Dialog::exd"],

Cell[TextData[{
  "A warning message is generated if ",
  StyleBox["Exit", "MR"],
  " is evaluated after evaluating ",
  StyleBox["Dialog[]", "MR"],
  "."
}], "Text",
  CellTags->"Dialog::exd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dialog[]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Dialog::exd"],

Cell[BoxData[
    \(Exit\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Dialog::exd"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Exit\)], "Input",
  CellLabel->"(Dialog) In[2]:=",
  CellTags->"Dialog::exd"],

Cell[BoxData[
    \(Dialog::"exd" \(\(:\)\(\ \)\) 
      "To exit a dialog, use Return[] or Return[expr]. To exit the entire \
Mathematica session, type Exit[]."\)], "Message",
  CellLabel->"From (Dialog) In[2]:=",
  CellTags->"Dialog::exd"],

Cell[BoxData[
    \(Exit\)], "Output",
  CellLabel->"(Dialog) Out[2]=",
  CellTags->"Dialog::exd"]
}, Open  ]],

Cell[TextData[{
  "Evaluate ",
  StyleBox["ExitDialog[]", "MR"],
  " to exit the dialog."
}], "Text",
  CellTags->"Dialog::exd"],

Cell[BoxData[
    \(ExitDialog[]\)], "Input",
  CellLabel->"(Dialog) In[3]:=",
  CellTags->"Dialog::exd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DownValues::itloc
UpValues::itloc
OwnValues::itloc
FormatValues::itloc
DefaultValues::itloc
NValues::itloc
Messages::itloc
SubValues::itloc\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
    "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
    "Messages::itloc", "SubValues::itloc"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"itloc\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "currently", " ", "contains", " ", "iterator", " ", 
          "localizations"}]}], ",", " ", 
      RowBox[{"and", " ", "cannot", " ", "be", " ", "set", " ", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{"to", " ", 
              StyleBox["val",
                "TI"]}], ")"}], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
    "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
    "Messages::itloc", "SubValues::itloc"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when an expression that has been localized \
as an iterator is encountered in a value assignment.\n\[FilledSmallSquare] \
Iterators are used in ",
  StyleBox["Do", "MR"],
  ", ",
  StyleBox["Sum", "MR"],
  ", ",
  StyleBox["Product", "MR"],
  ", ",
  StyleBox["Table", "MR"],
  ", and other functions that perform iteration.\n\[FilledSmallSquare] This \
error occurs only if the iterator is not a symbol."
}], "Notes",
  CellTags->{
  "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
    "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
    "Messages::itloc", "SubValues::itloc"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
    "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
    "Messages::itloc", "SubValues::itloc"}],

Cell["\<\
An error occurs in this example because the body of the loop \
includes an assignment to the values of a symbol that occurs in the iterator.\
\
\>", "Text",
  CellTags->{
  "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
    "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
    "Messages::itloc", "SubValues::itloc"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[DownValues[f]\  = \ {f[x_]\  -> \ x^2}, \ {f[0], \ 1}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
    "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
    "Messages::itloc", "SubValues::itloc"}],

Cell[BoxData[
    \(DownValues::"itloc" \(\(:\)\(\ \)\) 
      "\!\(DownValues[f]\) currently contains iterator localizations, and \
cannot be set (to \!\({\(\(f[x_]\)\) \[Rule] x\^2}\))."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "DefaultValues::itloc", "DownValues::itloc", "FormatValues::itloc", 
    "Messages::itloc", "NValues::itloc", "OwnValues::itloc", 
    "SubValues::itloc", "UpValues::itloc"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DownValues::vlist
UpValues::vlist
OwnValues::vlist
FormatValues::vlist
DefaultValues::vlist
NValues::vlist
Messages::vlist
SubValues::vlist\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"vlist\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
        "set", " ", 
        StyleBox["expr",
          "TI"], " ", "to", " ", 
        StyleBox["val",
          "TI"]}], ";", 
      " ", \(value\ must\ be\ a\ list\ of\ \(\(rules\)\(.\)\)\)}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell["\<\
\[FilledSmallSquare] Generated when the right-hand side of the \
indicated assignment is not a list of rules.
\[FilledSmallSquare] This message is generated only by direct assignments to \
the values of a symbol.
\[FilledSmallSquare] Definitions are usually added using ordinary \
assignments, rather than using direct assignments to the values of a symbol.
\[FilledSmallSquare] Values stored in the internal structure of a symbol are \
represented using lists of rules.\
\>", "Notes",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell["\<\
An error occurs in this example because the right-hand side of the \
assignment is not a list of rules.\
\>", "Text",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Messages[fsym] = "\<text of message\>"\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[BoxData[
    \(Messages::"vlist" \(\(:\)\(\ \)\) 
      "Cannot set \!\(Messages[fsym]\) to \!\(\"text of message\"\); value \
must be a list of rules."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
    "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
    "SubValues::vlist", "UpValues::vlist"}],

Cell[BoxData[
    \("text of message"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
    "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
    "SubValues::vlist", "UpValues::vlist"}]
}, Open  ]],

Cell["This shows a valid assignment for the messages of a symbol.", "Text",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Messages[
        fsym] = {HoldPattern[fsym::tag] :> "\<text of message\>"}\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[BoxData[
    \({HoldPattern[fsym::"tag"] \[RuleDelayed] "text of message"}\)], "Output",\

  CellLabel->"Out[2]=",
  CellTags->{
  "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
    "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
    "SubValues::vlist", "UpValues::vlist"}]
}, Open  ]],

Cell["\<\
The same message can be introduced using a simple assignment.\
\>", \
"Text",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(fsym::tag = "\<text of message\>"\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[BoxData[
    \("text of message"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{
  "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
    "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
    "SubValues::vlist", "UpValues::vlist"}]
}, Open  ]],

Cell["\<\
This shows the message that was introduced by the assignment.\
\>", \
"Text",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Messages[fsym]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[BoxData[
    \({HoldPattern[fsym::"tag"] \[RuleDelayed] "text of message"}\)], "Output",\

  CellLabel->"Out[4]=",
  CellTags->{
  "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
    "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
    "SubValues::vlist", "UpValues::vlist"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
DownValues::vrule
UpValues::vrule
OwnValues::vrule
FormatValues::vrule
DefaultValues::vrule
NValues::vrule
Messages::vrule
SubValues::vrule\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], "::", "\<\"vrule\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
          "set", " ", 
          StyleBox["expr",
            "TI"], " ", "to", " ", 
          StyleBox["val",
            "TI"]}], ";", " ", 
        RowBox[{"value", " ", "contains", " ", 
          StyleBox["ei",
            "TI"]}]}], ",", 
      " ", \(which\ is\ not\ a\ \(\(rule\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell["\<\
\[FilledSmallSquare] Generated when the right-hand side of an \
assignment to the values of a symbol includes an element that is not a rule.
\[FilledSmallSquare] This message is generated only by direct assignments to \
the values of a symbol.
\[FilledSmallSquare] Definitions are usually added using ordinary \
assignments, rather than using direct assignments to the values of a symbol.
\[FilledSmallSquare] Values stored in the internal structure of a symbol are \
represented using lists of rules.\
\>", "Notes",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell["\<\
An error occurs in this example because the element on the \
right-hand side of the assignment is not a rule.\
\>", "Text",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Messages[fsym] = {"\<text of message\>"}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[BoxData[
    \(Messages::"vrule" \(\(:\)\(\ \)\) 
      "Cannot set \!\(Messages[fsym]\) to \!\({\"text of message\"}\); value \
contains \!\(\"text of message\"\), which is not a rule."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
    "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
    "SubValues::vrule", "UpValues::vrule"}],

Cell[BoxData[
    \({"text of message"}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
    "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
    "SubValues::vrule", "UpValues::vrule"}]
}, Open  ]],

Cell["This shows a valid assignment for the messages of a symbol.", "Text",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Messages[
        fsym] = {HoldPattern[fsym::tag] :> "\<text of message\>"}\)], "Input",\

  CellLabel->"In[2]:=",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[BoxData[
    \({HoldPattern[fsym::"tag"] \[RuleDelayed] "text of message"}\)], "Output",\

  CellLabel->"Out[2]=",
  CellTags->{
  "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
    "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
    "SubValues::vrule", "UpValues::vrule"}]
}, Open  ]],

Cell["\<\
The same message can be introduced using an ordinary \
assignment.\
\>", "Text",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(fsym::tag = "\<text of message\>"\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[BoxData[
    \("text of message"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{
  "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
    "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
    "SubValues::vrule", "UpValues::vrule"}]
}, Open  ]],

Cell["\<\
This shows the message that was introduced by the assignment.\
\>", \
"Text",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Messages[fsym]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[BoxData[
    \({HoldPattern[fsym::"tag"] \[RuleDelayed] "text of message"}\)], "Output",\

  CellLabel->"Out[4]=",
  CellTags->{
  "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
    "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
    "SubValues::vrule", "UpValues::vrule"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EditDefinition::edsym", "ObjectNameWarningMessages",
  CellTags->"EditDefinition::edsym"],

Cell[BoxData[
    RowBox[{\(EditDefinition::"edsym"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ \(\(symbol\)\(.\)\)\)\)}]], "Message",
  CellTags->"EditDefinition::edsym"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["EditDefinition", "MR"],
  " is not a symbol.\n\[FilledSmallSquare] ",
  StyleBox["EditDefinition", "MR"],
  " is intended for use when the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel is used directly, rather than through a notebook front end, and \
the system environment provides an editor that can be launched from the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel."
}], "Notes",
  CellTags->"EditDefinition::edsym"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"EditDefinition::edsym"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["EditDefinition", "MR"],
  " is a number rather than a symbol.  "
}], "Text",
  CellTags->"EditDefinition::edsym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(EditDefinition[7]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"EditDefinition::edsym"],

Cell[BoxData[
    \(EditDefinition::"edsym" \(\(:\)\(\ \)\) 
      "\!\(7\) is not a symbol."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"EditDefinition::edsym"],

Cell[BoxData[
    \(EditDefinition[7]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"EditDefinition::edsym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
End::noctx
EndAdd::noctx
EndPackage::noctx\
\>", "ObjectNameWarningMessages",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"noctx\"\>"}], \(\(:\)\(\ \)\), \(No\ previous\ context\ \(\
\(defined\)\(.\)\)\)}]], "Message",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["End", "MR"],
  ", ",
  StyleBox["EndAdd", "MR"],
  ", or ",
  StyleBox["EndPackage", "MR"],
  " is used without a corresponding ",
  StyleBox["Begin", "MR"],
  " or ",
  StyleBox["BeginPackage", "MR"],
  ".\n\[FilledSmallSquare] This error can normally be resolved by checking \
the uses of ",
  StyleBox["Begin", "MR"],
  ", ",
  StyleBox["BeginPackage", "MR"],
  ", ",
  StyleBox["End", "MR"],
  ", ",
  StyleBox["EndAdd", "MR"],
  ", and ",
  StyleBox["EndPackage", "MR"],
  " in the input."
}], "Notes",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],

Cell[TextData[{
  "An error occurs in this example unless there has been a corresponding ",
  StyleBox["Begin", "MR"],
  " or ",
  StyleBox["BeginPackage", "MR"],
  " earlier in this ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session."
}], "Text",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(End[]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],

Cell[BoxData[
    \(End::"noctx" \(\(:\)\(\ \)\) 
      "No previous context defined."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}],

Cell[BoxData[
    \("Global`"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Begin", "MR"],
  " and ",
  StyleBox["End", "MR"],
  " to control the current context."
}], "Text",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Begin["\<NewContext`\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],

Cell[BoxData[
    \("NewContext`"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(End[]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],

Cell[BoxData[
    \("NewContext`"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ExitDialog::cant", "ObjectNameWarningMessages",
  CellTags->"ExitDialog::cant"],

Cell[BoxData[
    \(ExitDialog::"cant" \(\(:\)\(\ \)\) \(No\ dialog\ to\ exit\ \
\(\(from\)\(.\)\)\)\)], "Message",
  CellTags->"ExitDialog::cant"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["ExitDialog[]", "MR"],
  " is used outside of a dialog subsession.\n\[FilledSmallSquare] The ",
  StyleBox["Dialog", "MR"],
  " function is used to enter a dialog."
}], "Notes",
  CellTags->"ExitDialog::cant"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ExitDialog::cant"],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["ExitDialog", "MR"],
  " to exit a dialog."
}], "Text",
  CellTags->"ExitDialog::cant"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Dialog[]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ExitDialog::cant"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ExitDialog::cant"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(2 + 2\)], "Input",
  CellLabel->"(Dialog) In[2]:=",
  CellTags->"ExitDialog::cant"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"(Dialog) Out[2]=",
  CellTags->"ExitDialog::cant"]
}, Open  ]],

Cell[BoxData[
    \(ExitDialog[]\)], "Input",
  CellLabel->"(Dialog) In[3]:=",
  CellTags->"ExitDialog::cant"],

Cell[TextData[{
  "An error occurs if ",
  StyleBox["ExitDialog[]", "MR"],
  " is evaluated after the dialog has already ended."
}], "Text",
  CellTags->"ExitDialog::cant"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExitDialog[]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ExitDialog::cant"],

Cell[BoxData[
    \(ExitDialog::"cant" \(\(:\)\(\ \)\) 
      "No dialog to exit from."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"ExitDialog::cant"],

Cell[BoxData[
    \(ExitDialog[]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ExitDialog::cant"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Return::obs", "ObjectNameWarningMessages",
  CellTags->"Return::obs"],

Cell[BoxData[
    \(Return::"obs" \(\(:\)\(\ \)\) \(Return' 
        s\ functionality\ of\ exiting\ a\ dialog\ is\ obsolete . \ 
          To\ exit\ a\ dialog, \ 
      use\ ExitDialog[]\ or\ ExitDialog[expr] . \ If\ an\ ExitDialog[
          expr]\ is\ encountered\ in\ the\ course\ of\ evaluation, \ 
      the\ dialog\ will\ immediately\ be\ exited, \ 
      returning\ \(\(expr\)\(.\)\)\)\)], "Message",
  CellTags->"Return::obs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Return::obs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["FrontEndObject::notavail", "ObjectNameWarningMessages",
  CellTags->"FrontEndObject::notavail"],

Cell[BoxData[
    \(FrontEndObject::"notavail" \(\(:\)\(\ \)\) 
      "A front end is not available; certain operations require a front end."\
\)], "Message",
  CellLabel->"From In[344]:=",
  CellTags->"FrontEndObject::notavail"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when operations that require a notebook \
front end are evaluated in a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel that is not connected to a notebook front end.\n\
\[FilledSmallSquare] This message can be generated by functions that \
manipulate notebooks, such as ",
  StyleBox["NotebookPut", "MR"],
  " and ",
  StyleBox["SelectionEvaluate", "MR"],
  ", and functions that use the notebook front end, such as ",
  StyleBox["ConvertToPostScript", "MR"],
  ".\n\[FilledSmallSquare] This message is normally seen only when using the \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel without a notebook front end.  If you see this message in a \
situation where it is not expected, please contact Technical Support."
}], "Notes",
  CellTags->"FrontEndObject::notavail"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function::attf", "ObjectNameWarningMessages",
  CellTags->"Function::attf"],

Cell[BoxData[
    RowBox[{\(Function::"attf"\), \(\(:\)\(\ \)\), "Attributes", " ", 
      StyleBox["e",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(cannot\ be\ used\ as\ function\ \
\(\(attributes\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Function::attf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the attributes specified in ",
  StyleBox["Function", "MR"],
  " are not valid.\n\[FilledSmallSquare] Attributes for a ",
  StyleBox["Function", "MR"],
  " expression are specified in the optional third argument of ",
  StyleBox["Function", "MR"],
  ".\n\[FilledSmallSquare] Valid attributes in ",
  StyleBox["Function", "MR"],
  " are ",
  StyleBox["Flat", "MR"],
  ", ",
  StyleBox["Listable", "MR"],
  ", ",
  StyleBox["Orderless", "MR"],
  ", ",
  StyleBox["HoldAll", "MR"],
  ", ",
  StyleBox["NHoldAll", "MR"],
  ", ",
  StyleBox["SequenceHold", "MR"],
  ", and ",
  StyleBox["HoldAllComplete", "MR"],
  "."
}], "Notes",
  CellTags->"Function::attf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Function::attf"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Locked", "MR"],
  " is not a valid attribute for a ",
  StyleBox["Function", "MR"],
  " expression."
}], "Text",
  CellTags->"Function::attf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[x, List[x], Locked]\)[{1, 2, 3}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Function::attf"],

Cell[BoxData[
    \(Function::"attf" \(\(:\)\(\ \)\) 
      "Attributes \!\({Locked}\) in \!\(Function[\(\(x, \(\({x}\)\), Locked\)\
\)]\) cannot be used as function attributes."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Function::attf"],

Cell[BoxData[
    \(Function::"attf" \(\(:\)\(\ \)\) 
      "Attributes \!\({Locked}\) in \!\(Function[\(\(x, \(\({x}\)\), Locked\)\
\)]\) cannot be used as function attributes."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Function::attf"],

Cell[BoxData[
    \(\(Function[x, {x}, Locked]\)[{1, 2, 3}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Function::attf"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of an attribute in ",
  StyleBox["Function", "MR"],
  "."
}], "Text",
  CellTags->"Function::attf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[x, List[x], Listable]\)[{1, 2, 3}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Function::attf"],

Cell[BoxData[
    \({{1}, {2}, {3}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Function::attf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Function::fdup
Compile::fdup\
\>", "ObjectNameWarningMessages",
  CellTags->{"Function::fdup", "Compile::fdup"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"fdup\"\>"}], \(\(:\)\(\ \)\), \(\(Duplicate\)\(\ \
\)\(parameter\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\(found\)\(\ \)\(in\)\(\ \)\)\), 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Function::fdup", "Compile::fdup"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the same parameter name appears more \
than once in the first argument of ",
  StyleBox["Function", "MR"],
  " or ",
  StyleBox["Compile", "MR"],
  "."
}], "Notes",
  CellTags->{"Function::fdup", "Compile::fdup"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Function::fdup", "Compile::fdup"}],

Cell["\<\
An error occurs in this example because the same symbol is used for \
both parameters.\
\>", "Text",
  CellTags->{"Function::fdup", "Compile::fdup"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[{x, x}, x + y]\)[3, 6]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Function::fdup", "Compile::fdup"}],

Cell[BoxData[
    \(Function::"fdup" \(\(:\)\(\ \)\) 
      "Duplicate parameter \!\(x\) found in \!\({x, x}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Compile::fdup", "Function::fdup"}],

Cell[BoxData[
    \(Function::"fdup" \(\(:\)\(\ \)\) 
      "Duplicate parameter \!\(x\) found in \!\({x, x}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Compile::fdup", "Function::fdup"}],

Cell[BoxData[
    \(\(Function[{x, x}, x + y]\)[3, 6]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"Compile::fdup", "Function::fdup"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid parameter names in ",
  StyleBox["Function", "MR"],
  "."
}], "Text",
  CellTags->{"Function::fdup", "Compile::fdup"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[{x, y}, x + y]\)[3, 6]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Function::fdup", "Compile::fdup"}],

Cell[BoxData[
    \(9\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Compile::fdup", "Function::fdup"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function::fdups", "ObjectNameWarningMessages",
  CellTags->"Function::fdups"],

Cell[BoxData[
    RowBox[{\(Function::"fdups"\), \(\(:\)\(\ \)\), "Conflicting", " ", 
      "parameters", " ", 
      StyleBox["s1",
        "TI"], " ", "and", " ", 
      StyleBox["s2",
        "TI"], " ", "found", " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Function::fdups"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the names of parameters in ",
  StyleBox["Function", "MR"],
  " may lead to conflicts with names that are generated automatically by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] Names that end in a ",
  StyleBox["$", "MR"],
  " character can lead to this message and should be avoided.\n\
\[FilledSmallSquare] ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " generates symbol names that end in a ",
  StyleBox["$", "MR"],
  " character when localizing variables.  Name conflicts may arise if names \
of this form are already in use."
}], "Notes",
  CellTags->"Function::fdups"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Function::fdups"],

Cell["\<\
An error occurs in this example because of incompatible parameter \
names.\
\>", "Text",
  CellTags->"Function::fdups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[{x, x$}, x + x$]\)[3, 5]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Function::fdups"],

Cell[BoxData[
    \(Function::"fdups" \(\(:\)\(\ \)\) 
      "Conflicting parameters \!\(x\) and \!\(x$\) found in \!\({x, \
x$}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Function::fdups"],

Cell[BoxData[
    \(Function::"fdups" \(\(:\)\(\ \)\) 
      "Conflicting parameters \!\(x\) and \!\(x$\) found in \!\({x, \
x$}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Function::fdups"],

Cell[BoxData[
    \(\(Function[{x, x$}, x + x$]\)[3, 5]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Function::fdups"]
}, Open  ]],

Cell[TextData[{
  "This example shows valid parameter names in ",
  StyleBox["Function", "MR"],
  "."
}], "Text",
  CellTags->"Function::fdups"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[{x, y}, x + y]\)[3, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Function::fdups"],

Cell[BoxData[
    \(8\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Function::fdups"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function::flpar", "ObjectNameWarningMessages",
  CellTags->"Function::flpar"],

Cell[BoxData[
    RowBox[{\(Function::"flpar"\), \(\(:\)\(\ \)\), "Parameter", " ", 
      "specification", " ", 
      StyleBox["e",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ a\ symbol\ or\ a\ list\ of\ \
\(\(symbols\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Function::flpar"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["Function", "MR"],
  " is not a symbol or a list of symbols.\n\[FilledSmallSquare] Since ",
  StyleBox["Function", "MR"],
  " has the ",
  StyleBox["HoldAll", "MR"],
  " attribute, the value of an argument that evaluates to a symbol or to a \
list of symbols will not be used unless ",
  StyleBox["Evaluate", "MR"],
  " or some similar construction is used to cause that evaluation."
}], "Notes",
  CellTags->"Function::flpar"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Function::flpar"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["Function", "MR"],
  " is not a symbol or a list of symbols."
}], "Text",
  CellTags->"Function::flpar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[f[x], f[x] + 1]\)[3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Function::flpar"],

Cell[BoxData[
    \(Function::"flpar" \(\(:\)\(\ \)\) 
      "Parameter specification \!\(f[x]\) in \!\(Function[\(\(\(\(f[x]\)\), \
\(\(\(\(f[x]\)\) + 1\)\)\)\)]\) should be a symbol or a list of symbols."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Function::flpar"],

Cell[BoxData[
    \(Function::"flpar" \(\(:\)\(\ \)\) 
      "Parameter specification \!\(f[x]\) in \!\(Function[\(\(\(\(f[x]\)\), \
\(\(\(\(f[x]\)\) + 1\)\)\)\)]\) should be a symbol or a list of symbols."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Function::flpar"],

Cell[BoxData[
    \(\(Function[f[x], f[x] + 1]\)[3]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Function::flpar"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid parameter specification in ",
  StyleBox["Function", "MR"],
  "."
}], "Text",
  CellTags->"Function::flpar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[fx, fx + 1]\)[3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Function::flpar"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Function::flpar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Remove::rmnsm", "ObjectNameWarningMessages",
  CellTags->"Remove::rmnsm"],

Cell[BoxData[
    \(Remove::"rmnsm" \(\(:\)\(\ \)\) 
      "There are no symbols matching \"`1`\"."\)], "Message",
  CellLabel->"From In[52]:=",
  CellTags->"Remove::rmnsm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["Remove", "MR"],
  " is a string and there are no symbols with names that match that string."
}], "Notes",
  CellTags->"Remove::rmnsm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Remove::rmnsm"],

Cell[TextData[{
  "An error occurs if there are no symbols with names that match the string \
pattern given in the argument of ",
  StyleBox["Remove", "MR"],
  "."
}], "Text",
  CellTags->"Remove::rmnsm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Remove["\<NOSYMBOL*\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Remove::rmnsm"],

Cell[BoxData[
    \(Remove::"rmnsm" \(\(:\)\(\ \)\) 
      "There are no symbols matching \"\!\(\"NOSYMBOL*\"\)\"."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Remove::rmnsm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function::fpct", "ObjectNameWarningMessages",
  CellTags->"Function::fpct"],

Cell[BoxData[
    RowBox[{\(Function::"fpct"\), \(\(:\)\(\ \)\), \(\(Too\)\(\ \)\(many\)\(\ \
\)\(parameters\)\(\ \)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\(to\)\(\ \)\(be\)\(\ \)\(filled\)\(\ \)\(from\)\(\ \
\)\)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Function::fpct"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of parameters in a ",
  StyleBox["Function", "MR"],
  " expression is greater than the number of arguments passed to the \
function."
}], "Notes",
  CellTags->"Function::fpct"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Function::fpct"],

Cell[TextData[{
  "An error occurs in this example because the number of arguments passed to \
the ",
  StyleBox["Function", "MR"],
  " expression is not the same as the number of parameters in the ",
  StyleBox["Function", "MR"],
  " expression."
}], "Text",
  CellTags->"Function::fpct"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[{x, y, z}, x + y + z]\)[3, 4]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Function::fpct"],

Cell[BoxData[
    \(Function::"fpct" \(\(:\)\(\ \)\) 
      "Too many parameters in \!\({x, y, z}\) to be filled from \
\!\(\(\(Function[\(\(\(\({x, y, z}\)\), \(\(x + y + z\)\)\)\)]\)\)[\(\(3, 4\)\
\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Function::fpct"],

Cell[BoxData[
    \(\(Function[{x, y, z}, x + y + z]\)[3, 4]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Function::fpct"]
}, Open  ]],

Cell[TextData[{
  "This shows a correct use of this ",
  StyleBox["Function", "MR"],
  " expression."
}], "Text",
  CellTags->"Function::fpct"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Function[{x, y, z}, x + y + z]\)[3, 4, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Function::fpct"],

Cell[BoxData[
    \(12\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Function::fpct"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function::slot", "ObjectNameWarningMessages",
  CellTags->"Function::slot"],

Cell[BoxData[
    RowBox[{\(Function::"slot"\), ":", " ", 
      RowBox[{
        StyleBox["e",
          "TI"], " ", 
        RowBox[{"(", 
          RowBox[{"in", " ", 
            StyleBox["expr",
              
              "TI"], \(\(\()\)\(\ \)\(should\)\(\ \)\(contain\)\(\ \)\(a\)\(\ \
\)\(non\)\) - negative\ \(\(integer\)\(.\)\)\)}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Function::slot"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["Slot", "MR"],
  " is not an integer or is negative.\n\[FilledSmallSquare] ",
  StyleBox["Slot[n]", "MR"],
  " can be entered using the notation ",
  StyleBox["#n", "MR"],
  ".\n\[FilledSmallSquare] If ",
  StyleBox["Slot", "MR"],
  " is used in a position where it is not evaluated, such as in ",
  StyleBox["Function", "MR"],
  ", arguments that might evaluate to integers will not be evaluated unless \
",
  StyleBox["Evaluate", "MR"],
  " or some other construction is used to cause the evaluation."
}], "Notes",
  CellTags->"Function::slot"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Function::slot"],

Cell["\<\
An error occurs in this example because a symbol is used when a \
non-negative integer is expected.\
\>", "Text",
  CellTags->"Function::slot"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Slot[n] &\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Function::slot"],

Cell[BoxData[
    \(Function::"slot" \(\(:\)\(\ \)\) 
      "\!\(Slot[n]\) (in \!\(\(\(Slot[n]\)\) &\)) should contain a \
non-negative integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Function::slot"],

Cell[BoxData[
    \(Slot[n] &\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Function::slot"]
}, Open  ]],

Cell[TextData[{
  "The same error will be generated unless the argument in ",
  StyleBox["Slot", "MR"],
  " is a non-negative integer or evaluates to give a non-negative integer."
}], "Text",
  CellTags->"Function::slot"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{n = 1}, Slot[n] &]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Function::slot"],

Cell[BoxData[
    \(Function::"slot" \(\(:\)\(\ \)\) 
      "\!\(Slot[n]\) (in \!\(\(\(Slot[n]\)\) &\)) should contain a \
non-negative integer."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"Function::slot"],

Cell[BoxData[
    \(Function::"slot" \(\(:\)\(\ \)\) 
      "\!\(Slot[n]\) (in \!\(\(\(Slot[n]\)\) &\)) should contain a \
non-negative integer."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"Function::slot"],

Cell[BoxData[
    \(Slot[n] &\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Function::slot"]
}, Open  ]],

Cell[TextData[{
  "These examples show valid uses of ",
  StyleBox["Slot", "MR"],
  " in a ",
  StyleBox["Function", "MR"],
  " expression."
}], "Text",
  CellTags->"Function::slot"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Slot[1] &\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Function::slot"],

Cell[BoxData[
    \(#1 &\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Function::slot"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{n = 1}, Evaluate[Slot[n]] &]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Function::slot"],

Cell[BoxData[
    \(#1 &\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Function::slot"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{n = 1}, Slot[n] &]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"Function::slot"],

Cell[BoxData[
    \(#1 &\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"Function::slot"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function::slotn", "ObjectNameWarningMessages",
  CellTags->"Function::slotn"],

Cell[BoxData[
    RowBox[{\(Function::"slotn"\), \(\(:\)\(\ \)\), "Slot", " ", "number", 
      " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "cannot", " ", "be", " ", "filled", " ", "from", " ", 
      RowBox[{
        StyleBox["args",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Function::slotn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of arguments passed to a ",
  StyleBox["Function", "MR"],
  " expression is less than the number of ",
  StyleBox["Slot", "MR"],
  " parameters.\n\[FilledSmallSquare] The notation ",
  StyleBox["#", "MR"],
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  " is equivalent to ",
  StyleBox["Slot[", "MR"],
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " if ",
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  " is a non-negative integer."
}], "Notes",
  CellTags->"Function::slotn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Function::slotn"],

Cell[TextData[{
  "An error occurs in this example because the ",
  StyleBox["Function", "MR"],
  " expression in the first argument of ",
  StyleBox["Apply", "MR"],
  " requires two arguments but is evaluated here with only one argument."
}], "Text",
  CellTags->"Function::slotn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[\((#1 + #2)\) &, {7}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Function::slotn"],

Cell[BoxData[
    \(Function::"slotn" \(\(:\)\(\ \)\) 
      "Slot number \!\(2\) in \!\(\(\(#1 + #2\)\) &\) cannot be filled from \
\!\(\(\((\(\(\(#1 + #2\)\) &\))\)\)[7]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Function::slotn"],

Cell[BoxData[
    \(7 + #2\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Function::slotn"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of a ",
  StyleBox["Function", "MR"],
  " expression with two ",
  StyleBox["Slot", "MR"],
  " arguments."
}], "Text",
  CellTags->"Function::slotn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[\((#1 + #2)\) &, {7, 4}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Function::slotn"],

Cell[BoxData[
    \(11\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Function::slotn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function::slotp", "ObjectNameWarningMessages",
  CellTags->"Function::slotp"],

Cell[BoxData[
    RowBox[{\(Function::"slotp"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\((\)\(in\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], \(\()\)\(\ \)\(should\)\(\ \)\(contain\)\(\ \)\(a\)\(\ \
\)\(positive\)\(\ \)\(\(integer\)\(.\)\)\)}]], "Message",
  CellTags->"Function::slotp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in a ",
  StyleBox["SlotSequence", "MR"],
  " expression in ",
  StyleBox["Function", "MR"],
  " is not a positive integer.\n\[FilledSmallSquare] The notation ",
  StyleBox["##", "MR"],
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  " is equivalent to ",
  StyleBox["SlotSequence[", "MR"],
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " if ",
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  " is a positive integer.\n\[FilledSmallSquare] If ",
  StyleBox["SlotSequence", "MR"],
  " is used in a position where it is not evaluated, such as in ",
  StyleBox["Function", "MR"],
  ", arguments that might evaluate to integers will not be evaluated unless \
",
  StyleBox["Evaluate", "MR"],
  " or some other construction is used to cause the evaluation."
}], "Notes",
  CellTags->"Function::slotp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Function::slotp"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["SlotSequence", "MR"],
  " is not an integer."
}], "Text",
  CellTags->"Function::slotp"],

Cell[CellGroupData[{

Cell[BoxData[
    \({Slot[1], {SlotSequence[n]}} &\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Function::slotp"],

Cell[BoxData[
    \(Function::"slotp" \(\(:\)\(\ \)\) 
      "\!\(SlotSequence[n]\) (in \!\(\(\({#1, \
\(\({\(SlotSequence[n]\)}\)\)}\)\) &\)) should contain a positive \
integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Function::slotp"],

Cell[BoxData[
    \({#1, {SlotSequence[n]}} &\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Function::slotp"]
}, Open  ]],

Cell[TextData[{
  "The same error will be generated unless the argument in ",
  StyleBox["SlotSequence", "MR"],
  " is a non-negative integer or evaluates to give a non-negative integer."
}], "Text",
  CellTags->"Function::slotp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{n = 2}, {#, {SlotSequence[n]}} &]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Function::slotp"],

Cell[BoxData[
    \(Function::"slotp" \(\(:\)\(\ \)\) 
      "\!\(SlotSequence[n]\) (in \!\(\(\({#1, \
\(\({\(SlotSequence[n]\)}\)\)}\)\) &\)) should contain a positive \
integer."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"Function::slotp"],

Cell[BoxData[
    \(Function::"slotp" \(\(:\)\(\ \)\) 
      "\!\(SlotSequence[n]\) (in \!\(\(\({#1, \
\(\({\(SlotSequence[n]\)}\)\)}\)\) &\)) should contain a positive \
integer."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"Function::slotp"],

Cell[BoxData[
    \({#1, {SlotSequence[n]}} &\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Function::slotp"]
}, Open  ]],

Cell[TextData[{
  "These examples show valid uses of ",
  StyleBox["SlotSequence", "MR"],
  " in a ",
  StyleBox["Function", "MR"],
  " expression."
}], "Text",
  CellTags->"Function::slotp"],

Cell[CellGroupData[{

Cell[BoxData[
    \({#1, {SlotSequence[2]}} &\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Function::slotp"],

Cell[BoxData[
    \({#1, {##2}} &\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Function::slotp"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{n = 2}, Evaluate[{#1, {SlotSequence[n]}}] &]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Function::slotp"],

Cell[BoxData[
    \({#1, {##2}} &\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Function::slotp"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(With[{n = 2}, {#1, {SlotSequence[n]}} &]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"Function::slotp"],

Cell[BoxData[
    \({#1, {##2}} &\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"Function::slotp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Function::slots", "ObjectNameWarningMessages",
  CellTags->"Function::slots"],

Cell[BoxData[
    RowBox[{\(Function::"slots"\), \(\(:\)\(\ \)\), \(\(SlotSequence\)\([\)\),
       
      StyleBox["expr",
        "TI"], \(\(\(]\)\(\ \)\(in\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(\(cannot\)\(\ \)\(be\)\(\ \)\(filled\)\(\ \)\(from\)\
\(\ \)\)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Function::slots"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a ",
  StyleBox["Function", "MR"],
  " expression is used with an insufficient number of arguments to substitute \
for a ",
  StyleBox["SlotSequence", "MR"],
  " parameter.\n\[FilledSmallSquare] The notation ",
  StyleBox["##", "MR"],
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  " is equivalent to ",
  StyleBox["SlotSequence[", "MR"],
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " if ",
  StyleBox["n", "MR",
    FontSlant->"Italic"],
  " is a positive integer."
}], "Notes",
  CellTags->"Function::slots"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Function::slots"],

Cell[TextData[{
  "An error occurs in this example because the ",
  StyleBox["Function", "MR"],
  " expression in the first argument of ",
  StyleBox["Apply", "MR"],
  " is used here with only one argument, which does not provide for any \
arguments to fill the ",
  StyleBox["SlotSequence", "MR"],
  " expression."
}], "Text",
  CellTags->"Function::slots"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[{#1, {##3}} &, {7}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Function::slots"],

Cell[BoxData[
    \(Function::"slots" \(\(:\)\(\ \)\) 
      "SlotSequence[\!\(3\)] in \!\(\(\({#1, \(\({##3}\)\)}\)\) &\) cannot be \
filled from \!\(\(\((\(\(\({#1, \(\({##3}\)\)}\)\) &\))\)\)[7]\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Function::slots"],

Cell[BoxData[
    \({7, {##3}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Function::slots"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments for this ",
  StyleBox["Function", "MR"],
  " expression."
}], "Text",
  CellTags->"Function::slots"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Apply[{#1, {##3}} &, {7, 8, 9, 5}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Function::slots"],

Cell[BoxData[
    \({7, {9, 5}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Function::slots"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Goto::nolabel", "ObjectNameWarningMessages",
  CellTags->"Goto::nolabel"],

Cell[BoxData[
    RowBox[{\(Goto::"nolabel"\), \(\(:\)\(\ \)\), \(\(Label\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(not\ \(\(found\)\(.\)\)\)\)}]], "Message",
  CellTags->"Goto::nolabel"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a ",
  StyleBox["Goto", "MR"],
  " expression is encountered without a corresponding ",
  StyleBox["Label", "MR"],
  "."
}], "Notes",
  CellTags->"Goto::nolabel"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Goto::nolabel"],

Cell[TextData[{
  "An error occurs in this example because the label specified in ",
  StyleBox["Goto", "MR"],
  " does not match the label specified in the ",
  StyleBox["Label", "MR"],
  "."
}], "Text",
  CellTags->"Goto::nolabel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{k}, \n\tk = 1; \n\tLabel["\<top\>"]; \n\t
      Print["\<k = \>", \(k++\)]; \n\t
      If[k < 4, Goto["\<Top\>"]]; \n\t"\<done\>"\n\t\t]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Goto::nolabel"],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]1\),
      SequenceForm[ "k = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[1]:=",
  CellTags->"Goto::nolabel"],

Cell[BoxData[
    \(Goto::"nolabel" \(\(:\)\(\ \)\) 
      "Label \!\(\"Top\"\) not found."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Goto::nolabel"],

Cell[BoxData[
    \(Hold[Goto["Top"]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Goto::nolabel"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Goto", "MR"],
  " and ",
  StyleBox["Label", "MR"],
  "."
}], "Text",
  CellTags->"Goto::nolabel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{k}, \n\tk = 1; \n\tLabel["\<top\>"]; \n\t
      Print["\<k = \>", \(k++\)]; \n\t
      If[k < 4, Goto["\<top\>"]]; \n\t"\<done\>"\n\t\t]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Goto::nolabel"],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]1\),
      SequenceForm[ "k = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[2]:=",
  CellTags->"Goto::nolabel"],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]2\),
      SequenceForm[ "k = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[2]:=",
  CellTags->"Goto::nolabel"],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]3\),
      SequenceForm[ "k = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[2]:=",
  CellTags->"Goto::nolabel"],

Cell[BoxData[
    \("done"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Goto::nolabel"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Interrupt::dgbgn
TraceDialog::dgbgn\
\>", "ObjectNameWarningMessages",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"dgbgn\"\>"}], \(\(:\)\(\ \)\), \(Entering\ Dialog; \ 
      use\ Return[]\ to\ \(\(exit\)\(.\)\)\)}]], "Message",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[TextData[{
  "\[FilledSmallSquare] This is an informational message generated when \
entering a dialog from the interrupt menu or during ",
  StyleBox["TraceDialog", "MR"],
  ".\n\[FilledSmallSquare] This is not an error or warning message.\n\
\[FilledSmallSquare] When a dialog is entered from the interrupt menu, this \
message is seen only if the kernel is used directly rather than through the \
notebook front end."
}], "Notes",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[TextData[{
  "This shows a typical use of this message.  To run this example, evaluate \
",
  StyleBox["ExitDialog[]", "MR"],
  " after evaluating the ",
  StyleBox["TraceDialog", "MR"],
  " expression to start the subsession."
}], "Text",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraceDialog[Do[Print[k], {k, 5}], 3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[BoxData[
    \(1\)], "Print",
  CellLabel->"From In[1]:=",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[BoxData[
    \(2\)], "Print",
  CellLabel->"From In[1]:=",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[BoxData[
    \(TraceDialog::"dgbgn" \(\(:\)\(\ \)\) 
      "Entering Dialog; use Return[] to exit."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[BoxData[
    TagBox["3",
      HoldForm]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[BoxData[
    \(TraceDialog::"dgend" \(\(:\)\(\ \)\) "Exiting Dialog."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[BoxData[
    \(3\)], "Print",
  CellLabel->"From In[3]:=",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[BoxData[
    \(4\)], "Print",
  CellLabel->"From In[3]:=",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[BoxData[
    \(5\)], "Print",
  CellLabel->"From In[3]:=",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}]
}, Open  ]],

Cell[BoxData[
    \(ExitDialog[]\)], "Input",
  CellLabel->"(Dialog) In[3]:=",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Interrupt::dgend
TraceDialog::dgend\
\>", "ObjectNameWarningMessages",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"dgend\"\>"}], \(\(:\)\(\ \)\), "\<\"Exiting \
Dialog.\"\>"}]], "Message",
  CellLabel->"From In[57]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[TextData[{
  "\[FilledSmallSquare] This is an informational message generated when \
exiting a dialog that was entered from the interrupt menu or during ",
  StyleBox["TraceDialog", "MR"],
  ".\n\[FilledSmallSquare] This is not an error or warning message.\n\
\[FilledSmallSquare] When a dialog is entered from the interrupt menu, this \
message is seen only if the kernel is used directly rather than through the \
notebook front end."
}], "Notes",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[TextData[{
  "This shows a typical use of this message.  To run this example, evaluate \
",
  StyleBox["ExitDialog[]", "MR"],
  " after evaluating the ",
  StyleBox["TraceDialog", "MR"],
  " expression to start the subsession."
}], "Text",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraceDialog[Do[Print[k], {k, 5}], 3]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[BoxData[
    \(1\)], "Print",
  CellLabel->"From In[1]:=",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[BoxData[
    \(2\)], "Print",
  CellLabel->"From In[1]:=",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[BoxData[
    \(TraceDialog::"dgbgn" \(\(:\)\(\ \)\) 
      "Entering Dialog; use Return[] to exit."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[BoxData[
    TagBox["3",
      HoldForm]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[BoxData[
    \(TraceDialog::"dgend" \(\(:\)\(\ \)\) "Exiting Dialog."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[BoxData[
    \(3\)], "Print",
  CellLabel->"From In[3]:=",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[BoxData[
    \(4\)], "Print",
  CellLabel->"From In[3]:=",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[BoxData[
    \(5\)], "Print",
  CellLabel->"From In[3]:=",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}]
}, Open  ]],

Cell[BoxData[
    \(ExitDialog[]\)], "Input",
  CellLabel->"(Dialog) In[3]:=",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkConnect::linkc", "ObjectNameWarningMessages",
  CellTags->"LinkConnect::linkc"],

Cell[BoxData[
    RowBox[{\(LinkConnect::"linkc"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ dead; \ 
      attempt\ to\ connect\ \(\(failed\)\(.\)\)\)\)}]], "Message",
  CellTags->"LinkConnect::linkc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to access a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connection that is not active."
}], "Notes",
  CellTags->"LinkConnect::linkc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkObject::linkd", "ObjectNameWarningMessages",
  CellTags->"LinkObject::linkd"],

Cell[BoxData[
    RowBox[{\(LinkObject::"linkd"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ closed; \ 
      the\ connection\ is\ \(\(dead\)\(.\)\)\)\)}]], "Message",
  CellTags->"LinkObject::linkd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to access a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connection that is not active."
}], "Notes",
  CellTags->"LinkObject::linkd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkOpen::linke", "ObjectNameWarningMessages",
  CellTags->"LinkOpen::linke"],

Cell[BoxData[
    RowBox[{\(LinkOpen::"linke"\), \(\(:\)\(\ \)\), "MathLink", " ", 
      RowBox[{"error", ":", " ", 
        StyleBox["expr",
          "TI"]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinkOpen::linke"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " error indicated in the text of the message.\n\[FilledSmallSquare] This \
message can be generated if the values of the ",
  StyleBox["LinkProtocol", "MR"],
  " option and ",
  StyleBox["LinkMode", "MR"],
  " option are incompatible in the version of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " that you are using.\n\[FilledSmallSquare] Supported values of the ",
  StyleBox["LinkProtocol", "MR"],
  " option and the conditions under which this message is generated are \
different on different types of computers."
}], "Notes",
  CellTags->"LinkOpen::linke"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"LinkOpen::linke"],

Cell[TextData[{
  "This message can be seen when setting both the ",
  StyleBox["LinkMode", "MR"],
  " and ",
  StyleBox["LinkProtocol", "MR"],
  " options to non-default values.  The behavior shown in this example will \
be different on different computers."
}], "Text",
  CellTags->"LinkOpen::linke"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinkOpen["\<prog\>", LinkMode -> Launch, 
      LinkProtocol -> "\<Local\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"LinkOpen::linke"],

Cell[BoxData[
    \(LinkOpen::"linke" \(\(:\)\(\ \)\) 
      "MathLink error: \!\(\"mode unavailable\"\)"\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"LinkOpen::linke"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"LinkOpen::linke"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkRead::linkep", "ObjectNameWarningMessages",
  CellTags->"LinkRead::linkep"],

Cell[BoxData[
    \(LinkRead::"linkep" \(\(:\)\(\ \)\) \(An\ unexpected\ end\ of\ packet\ \
was\ \(\(received\)\(.\)\)\)\)], "Message",
  CellTags->"LinkRead::linkep"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by the indicated ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " error."
}], "Notes",
  CellTags->"LinkRead::linkep"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkObject::linkn", "ObjectNameWarningMessages",
  CellTags->"LinkObject::linkn"],

Cell[BoxData[
    RowBox[{\(LinkObject::"linkn"\), \(\(:\)\(\ \)\), "Argument", " ", 
      StyleBox["n",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(has\ an\ invalid\ LinkObject\ number; \ 
      the\ link\ may\ be\ \(\(dead\)\(.\)\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinkObject::linkn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the link number included in the \
indicated ",
  StyleBox["LinkObject", "MR"],
  " expression does not match the link number that has been established \
internally for that link."
}], "Notes",
  CellTags->"LinkObject::linkn"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
LinkObject::linkv
LinkWrite::linkv
LinkWriteHeld::linkv\
\>", "ObjectNameWarningMessages",
  CellTags->{"LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"linkv\"\>"}], \(\(:\)\(\ \)\), "Argument", " ", 
      StyleBox["expr",
        "TI"], " ", "in", " ", 
      StyleBox["link",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", 
      " ", \(\(LinkObject\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated ",
  StyleBox["LinkObject", "MR"],
  " expression does not have a valid form.\n\[FilledSmallSquare] This error \
can occur if a ",
  StyleBox["LinkObject", "MR"],
  " expression is entered directly, rather than using the ",
  StyleBox["LinkObject", "MR"],
  " expression returned by ",
  StyleBox["LinkOpen", "MR"],
  " and related functions."
}], "Notes",
  CellTags->{"LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["LinkObject", "MR"],
  " is used with an unexpected number of arguments."
}], "Text",
  CellTags->{"LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinkClose[LinkObject["\<99\>"]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],

Cell[BoxData[
    \(LinkObject::"argr" \(\(:\)\(\ \)\) 
      "\!\(LinkObject\) called with 1 argument; \!\(3\) arguments are \
expected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}],

Cell[BoxData[
    \(LinkObject::"linkv" \(\(:\)\(\ \)\) 
      "Argument \!\(LinkObject[\"99\"]\) in \!\(LinkClose[\(\(LinkObject[\"99\
\"]\)\)]\) is not a valid LinkObject."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}],

Cell[BoxData[
    \(LinkClose[LinkObject["99"]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkObject::linkw", "ObjectNameWarningMessages",
  CellTags->"LinkObject::linkw"],

Cell[BoxData[
    RowBox[{\(LinkObject::"linkw"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ closed; \ 
      attempt\ to\ write\ \(\(failed\)\(.\)\)\)\)}]], "Message",
  CellTags->"LinkObject::linkw"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to write to a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connection that is not active."
}], "Notes",
  CellTags->"LinkObject::linkw"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkObject::linkx", "ObjectNameWarningMessages",
  CellTags->"LinkObject::linkx"],

Cell[BoxData[
    RowBox[{\(LinkObject::"linkx"\), \(\(:\)\(\ \)\), "Argument", " ", 
      StyleBox["link",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ an\ open\ \(\(LinkObject\)\(.\)\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinkObject::linkx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to access a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connection that is not active."
}], "Notes",
  CellTags->"LinkObject::linkx"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkOpen::linkh", "ObjectNameWarningMessages",
  CellTags->"LinkOpen::linkh"],

Cell[BoxData[
    RowBox[{\(LinkOpen::"linkh"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\ \
LinkHost\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ a\ \(\(string\)\(.\)\)\)\)}]], "Message",\

  CellTags->"LinkOpen::linkh"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["LinkHost", "MR"],
  " option does not have the indicated form."
}], "Notes",
  CellTags->"LinkOpen::linkh"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkOpen::linki", "ObjectNameWarningMessages",
  CellTags->"LinkOpen::linki"],

Cell[BoxData[
    \(LinkOpen::"linki" \(\(:\)\(\ \)\) \(MathLink\ could\ not\ be\ \
\(\(initialized\)\(.\)\)\)\)], "Message",
  CellTags->"LinkOpen::linki"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by low-level failure while opening a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connection."
}], "Notes",
  CellTags->"LinkOpen::linki"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkOpen::linkm", "ObjectNameWarningMessages",
  CellTags->"LinkOpen::linkm"],

Cell[BoxData[
    RowBox[{\(LinkOpen::"linkm"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\ \
LinkMode\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ Launch, \ ParentConnect, \ Listen, \ 
      or\ \(\(Connect\)\(.\)\)\)\)}]], "Message",
  CellTags->"LinkOpen::linkm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["LinkMode", "MR"],
  " option does not have the indicated form."
}], "Notes",
  CellTags->"LinkOpen::linkm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkOpen::linknm", "ObjectNameWarningMessages",
  CellTags->"LinkOpen::linknm"],

Cell[BoxData[
    \(LinkOpen::"linknm" \(\(:\)\(\ \)\) \(Either\ a\ link\ name\ or\ a\ \
value\ for\ the\ LinkMode\ option\ must\ be\ \(\(given\)\(.\)\)\)\)], \
"Message",
  CellTags->"LinkOpen::linknm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["LinkOpen", "MR"],
  " is used without specifying a link name or a value for the ",
  StyleBox["LinkMode", "MR"],
  " option."
}], "Notes",
  CellTags->"LinkOpen::linknm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"LinkOpen::linknm"],

Cell["\<\
An error occurs in this example because the name of the link to \
open cannot be determined.\
\>", "Text",
  CellTags->"LinkOpen::linknm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinkOpen[]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"LinkOpen::linknm"],

Cell[BoxData[
    \(LinkOpen::"linknm" \(\(:\)\(\ \)\) 
      "Either a link name or a value for the LinkMode option must be \
given."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"LinkOpen::linknm"],

Cell[BoxData[
    \(LinkOpen[]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"LinkOpen::linknm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkOpen::linkpl", "ObjectNameWarningMessages",
  CellTags->"LinkOpen::linkpl"],

Cell[BoxData[
    RowBox[{\(LinkOpen::"linkpl"\), \(\(:\)\(\ \)\), \(\(\(Value\ of\ option\ \
LinkProtocol\)\(\ \)\(->\)\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "should", " ", "be", " ", 
      StyleBox["vals",
        "TI"], " ", "or", " ", \(\(Automatic\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinkOpen::linkpl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["LinkProtocol", "MR"],
  " option does not match any of the indicated values.\n\[FilledSmallSquare] \
Supported values for the ",
  StyleBox["LinkProtocol", "MR"],
  " option will be different on different computers and in different versions \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"LinkOpen::linkpl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"LinkOpen::linkpl"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["None", "MR"],
  " is not a valid value for the ",
  StyleBox["LinkProtocol", "MR"],
  " option.  Evaluation of this input will show the values that are valid in \
this version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"LinkOpen::linkpl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinkOpen[LinkProtocol -> None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"LinkOpen::linkpl"],

Cell[BoxData[
    RowBox[{\(LinkOpen::"linkpl"\), \(\(:\)\(\ \)\), "\<\"Value of option \
LinkProtocol -> \\!\\(\\*FrameBox[\\\"\\\\\\\"None\\\\\\\"\\\", \
Rule[BoxFrame, False], Rule[BoxMargins, False]]\\) should be \\!\\(\\\"\\\\\\\
\"Pipes\\\\\\\", \\\\\\\"TCPIP\\\\\\\", \\\\\\\"TCP\\\\\\\"\\\"\\) or \
Automatic.\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"LinkOpen::linkpl"],

Cell[BoxData[
    \(LinkOpen[LinkProtocol \[Rule] None]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"LinkOpen::linkpl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkOpen::links", "ObjectNameWarningMessages",
  CellTags->"LinkOpen::links"],

Cell[BoxData[
    \(LinkOpen::"links" \(\(:\)\(\ \)\) \(Too\ many\ open\ \(\(links\)\(.\)\)\
\)\)], "Message",
  CellTags->"LinkOpen::links"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connections exceeds the limit supported in the version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that is in use."
}], "Notes",
  CellTags->"LinkOpen::links"]
}, Open  ]],

Cell[CellGroupData[{

Cell["LinkWriteHeld::linkhl", "ObjectNameWarningMessages",
  CellTags->"LinkWriteHeld::linkhl"],

Cell[BoxData[
    RowBox[{\(LinkWriteHeld::"linkhl"\), \(\(:\)\(\ \)\), "Argument", " ", 
      StyleBox["e",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ held\ \(\(expression\)\(.\)\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"LinkWriteHeld::linkhl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["LinkWriteHeld", "MR"],
  " does not have the form ",
  StyleBox["Hold[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  "."
}], "Notes",
  CellTags->"LinkWriteHeld::linkhl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"LinkWriteHeld::linkhl"],

Cell[TextData[{
  "An error occurs in this example because the second argument does not have \
a head of ",
  StyleBox["Hold", "MR"],
  "."
}], "Text",
  CellTags->"LinkWriteHeld::linkhl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(LinkWriteHeld[0, 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"LinkWriteHeld::linkhl"],

Cell[BoxData[
    \(LinkWriteHeld::"linkhl" \(\(:\)\(\ \)\) 
      "Argument \!\(0\) in \!\(LinkWriteHeld[\(\(0, 0\)\)]\) is not a held \
expression."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"LinkWriteHeld::linkhl"],

Cell[BoxData[
    \(LinkWriteHeld[0, 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"LinkWriteHeld::linkhl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MapThread::mptc", "ObjectNameWarningMessages",
  CellTags->"MapThread::mptc"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(MapThread::"mptc"\), \(\(:\)\(\ \)\), "Incompatible", " ", 
        "dimensions", " ", "of", " ", "objects", " ", "at", " ", "positions", 
        " ", 
        RowBox[{"{", 
          RowBox[{"2", ",", " ", 
            StyleBox["d1",
              "TI"]}], "}"}], " ", "and", " ", 
        RowBox[{"{", 
          RowBox[{"2", ",", " ", 
            StyleBox["d2",
              "TI"]}], "}"}], " ", "of", " ", 
        StyleBox["expr",
          "TI"]}], ";", " ", 
      RowBox[{"dimensions", " ", "are", " ", 
        StyleBox["dim1",
          "TI"], " ", "and", " ", 
        RowBox[{
          StyleBox["dim2",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"MapThread::mptc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when expressions to be threaded in ",
  StyleBox["MapThread", "MR"],
  " have unequal lengths or different dimensions."
}], "Notes",
  CellTags->"MapThread::mptc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"MapThread::mptc"],

Cell["\<\
An error occurs in this example because the expressions to be \
threaded do not have the same length.\
\>", "Text",
  CellTags->"MapThread::mptc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MapThread[maptest, \ {{10, 20}, {1, 2, 3}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"MapThread::mptc"],

Cell[BoxData[
    \(MapThread::"mptc" \(\(:\)\(\ \)\) 
      "Incompatible dimensions of objects at positions {2, \!\(1\)} and {2, \
\!\(2\)} of \!\(MapThread[\(\(maptest, \(\({\(\({10, 20}\)\), \(\({1, 2, 3}\)\
\)}\)\)\)\)]\); dimensions are \!\({2}\) and \!\({3}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"MapThread::mptc"],

Cell[BoxData[
    \(MapThread[maptest, {{10, 20}, {1, 2, 3}}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"MapThread::mptc"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["MapThread", "MR"],
  "."
}], "Text",
  CellTags->"MapThread::mptc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MapThread[maptest, \ {{10, 20, 30}, {1, 2, 3}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"MapThread::mptc"],

Cell[BoxData[
    \({maptest[10, 1], maptest[20, 2], maptest[30, 3]}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"MapThread::mptc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MapThread::mptd", "ObjectNameWarningMessages",
  CellTags->"MapThread::mptd"],

Cell[BoxData[
    RowBox[{\(MapThread::"mptd"\), \(\(:\)\(\ \)\), "Object", " ", 
      StyleBox["e",
        "TI"], " ", "at", " ", "position", " ", 
      RowBox[{"{", 
        RowBox[{"2", ",", " ", 
          StyleBox["n",
            "TI"]}], "}"}], " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "has", " ", "only", " ", 
      StyleBox["n1",
        "TI"], " ", "of", " ", "required", " ", 
      StyleBox["n2",
        "TI"], " ", \(\(dimensions\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"MapThread::mptd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression in ",
  StyleBox["MapThread", "MR"],
  " cannot be threaded with other expressions because it does not have \
elements at the indicated level."
}], "Notes",
  CellTags->"MapThread::mptd"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"MapThread::mptd"],

Cell[TextData[{
  "An error occurs in this example because the second expression to be \
threaded does not have elements at the level specified by the third argument \
in ",
  StyleBox["MapThread", "MR"],
  "."
}], "Text",
  CellTags->"MapThread::mptd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MapThread[maptest, \ {{{10, 20}, {30, 40}}, \ {1, \ 2, \ 3, 4}}, \ 
      2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"MapThread::mptd"],

Cell[BoxData[
    \(MapThread::"mptd" \(\(:\)\(\ \)\) 
      "Object \!\({1, 2, 3, 4}\) at position {2, \!\(2\)} in \!\(MapThread[\(\
\(maptest, \(\({\(\({\(\({10, 20}\)\), \(\({30, 40}\)\)}\)\), \(\({1, 2, 3, \
4}\)\)}\)\), 2\)\)]\) has only \!\(1\) of required \!\(2\) dimensions."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"MapThread::mptd"],

Cell[BoxData[
    \(MapThread[maptest, {{{10, 20}, {30, 40}}, {1, 2, 3, 4}}, 2]\)], "Output",\

  CellLabel->"Out[1]=",
  CellTags->"MapThread::mptd"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["MapThread", "MR"],
  "."
}], "Text",
  CellTags->"MapThread::mptd"],

Cell[CellGroupData[{

Cell[BoxData[
    \(MapThread[maptest, \ {{{10, 20}, {30, 40}}, \ {{1, \ 2}, {3, 4}}}, \ 
      2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"MapThread::mptd"],

Cell[BoxData[
    \({{maptest[10, 1], maptest[20, 2]}, {maptest[30, 3], 
        maptest[40, 4]}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"MapThread::mptd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options::opmix", "ObjectNameWarningMessages",
  CellTags->"Options::opmix"],

Cell[BoxData[
    RowBox[{\(Options::"opmix"\), \(\(:\)\(\ \)\), \(Cannot\ mix\ streams\ \
and\ non - \(\(streams\)\(\ \)\(in\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Options::opmix"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["Options", "MR"],
  " includes ",
  StyleBox["InputStream", "MR"],
  " or ",
  StyleBox["OutputStream", "MR"],
  " expressions together with expressions that are not ",
  StyleBox["InputStream", "MR"],
  " or ",
  StyleBox["OutputStream", "MR"],
  " expressions.\n\[FilledSmallSquare] ",
  StyleBox["Options", "MR"],
  " and ",
  StyleBox["SetOptions", "MR"],
  " can be used to set or inspect options of symbols or options of stream \
expressions, but cannot be used for both in the same input."
}], "Notes",
  CellTags->"Options::opmix"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Options::opmix"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["Options", "MR"],
  " includes a symbol and a stream expression."
}], "Text",
  CellTags->"Options::opmix"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[{Factor, \(Streams[]\)[\([1]\)]}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Options::opmix"],

Cell[BoxData[
    \(Options::"opmix" \(\(:\)\(\ \)\) 
      "Cannot mix streams and non-streams in \!\({Factor, \(\(OutputStream[\(\
\(\"stdout\", 1\)\)]\)\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Options::opmix"],

Cell[BoxData[
    \(Options[{Factor, OutputStream["stdout", 1]}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Options::opmix"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options::opsym", "ObjectNameWarningMessages",
  CellTags->"Options::opsym"],

Cell[BoxData[
    RowBox[{\(Options::"opsym"\), \(\(:\)\(\ \)\), \(\(Second\)\(\ \
\)\(argument\)\(\ \)\(in\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(should\ be\ a\ symbol\ or\ a\ list\ of\ \
\(\(symbols\)\(.\)\)\)\)}]], "Message",
  CellTags->"Options::opsym"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Options", "MR"],
  " does not have the expected form."
}], "Notes",
  CellTags->"Options::opsym"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Options::opsym"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["Options", "MR"],
  " cannot be a rule."
}], "Text",
  CellTags->"Options::opsym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[Factor, \ Modulus -> 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Options::opsym"],

Cell[BoxData[
    \(Options::"opsym" \(\(:\)\(\ \)\) 
      "Second argument in \!\(Options[\(\(Factor, \(\(Modulus \[Rule] 0\)\)\)\
\)]\) should be a symbol or a list of symbols."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Options::opsym"],

Cell[BoxData[
    \(Options[Factor, Modulus \[Rule] 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Options::opsym"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid used of the second argument in ",
  StyleBox["Options", "MR"],
  "."
}], "Text",
  CellTags->"Options::opsym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[Factor, \ Modulus]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Options::opsym"],

Cell[BoxData[
    \({Modulus \[Rule] 0}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Options::opsym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pattern::nodef", "ObjectNameWarningMessages",
  CellTags->"Pattern::nodef"],

Cell[BoxData[
    RowBox[{\(Pattern::"nodef"\), \(\(:\)\(\ \)\), \(\(No\)\(\ \
\)\(default\)\(\ \)\(setting\)\(\ \)\(found\)\(\ \)\(for\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "in", " ", "position", " ", 
      StyleBox["n1",
        "TI"], " ", "when", " ", "length", " ", "is", " ", 
      RowBox[{
        StyleBox["n2",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Pattern::nodef"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a pattern based on ",
  StyleBox["Optional", "MR"],
  " is used without specifying a default value for the pattern.\n\
\[FilledSmallSquare] The notation ",
  StyleBox["patt", "TI"],
  StyleBox[".", "MR"],
  " is used for ",
  StyleBox["Optional[", "MR"],
  StyleBox["patt", "TI"],
  StyleBox["]", "MR"],
  ".\n\[FilledSmallSquare] Assignments to ",
  StyleBox["Default", "MR"],
  " are used for specifying default values for ",
  StyleBox["Optional", "MR"],
  " patterns."
}], "Notes",
  CellTags->"Pattern::nodef"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Pattern::nodef"],

Cell[TextData[{
  "An error occurs in this example because a ",
  StyleBox["Default", "MR"],
  " value has not been assigned for an ",
  StyleBox["Optional", "MR"],
  " pattern in the test function."
}], "Text",
  CellTags->"Pattern::nodef"],

Cell[CellGroupData[{

Cell[BoxData[
    \(test[] /. test[p_. ] -> {p, p + 1}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Pattern::nodef"],

Cell[BoxData[
    \(Pattern::"nodef" \(\(:\)\(\ \)\) 
      "No default setting found for \!\(test\) in position \!\(1\) when \
length is \!\(1\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Pattern::nodef"],

Cell[BoxData[
    \(Pattern::"nodef" \(\(:\)\(\ \)\) 
      "No default setting found for \!\(test\) in position \!\(1\) when \
length is \!\(1\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Pattern::nodef"],

Cell[BoxData[
    \(test[]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Pattern::nodef"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid assignment to ",
  StyleBox["Default", "MR"],
  " for use with an ",
  StyleBox["Optional", "MR"],
  " pattern that occurs as an argument in the test function."
}], "Text",
  CellTags->"Pattern::nodef"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Default[test, 1] = 0\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Pattern::nodef"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Pattern::nodef"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(test[] /. test[p_. ] -> {p, p + 1}\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Pattern::nodef"],

Cell[BoxData[
    \({0, 1}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Pattern::nodef"]
}, Open  ]],

Cell[TextData[{
  "Clear the ",
  StyleBox["Default", "MR"],
  " rule for the test function."
}], "Text",
  CellTags->"Pattern::nodef"],

Cell[BoxData[
    \(Default[test, 1] =. \)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Pattern::nodef"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pattern::patm", "ObjectNameWarningMessages",
  CellTags->"Pattern::patm"],

Cell[BoxData[
    RowBox[{\(Pattern::"patm"\), \(\(:\)\(\ \)\), "Too", " ", "many", " ", 
      RowBox[{"(", 
        StyleBox["n",
          "TI"], ")"}], " ", "optional", " ", "arguments", " ", "required", 
      " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Pattern::patm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the pattern includes an excessive \
number of arguments based on ",
  StyleBox["Optional", "MR"],
  ".\n\[FilledSmallSquare] The notations ",
  StyleBox["patt", "TI"],
  StyleBox[".", "MR"],
  " and ",
  StyleBox["pat", "TI"],
  StyleBox["::", "MR"],
  StyleBox["def", "TI"],
  " are used to enter ",
  StyleBox["Optional", "MR"],
  " patterns.\n\[FilledSmallSquare] This message is generated if more than 13 \
",
  StyleBox["Optional", "MR"],
  " patterns occur in the same rule."
}], "Notes",
  CellTags->"Pattern::patm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Pattern::patm"],

Cell[TextData[{
  "An error occurs in this example because the number of ",
  StyleBox["Optional", "MR"],
  " patterns exceeds the limit set in this version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"Pattern::patm"],

Cell[CellGroupData[{

Cell[BoxData[
    \({} /. {p1_:  1, p2_:  2, p3_:  3, p4_:  4, p5_:  5, p6_:  6, p7_:  7, 
          p8_:  8, p9_:  9, p10_:  10, p11_:  11, p12_:  12, p13_:  13, 
          p14_:  14} -> 0\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Pattern::patm"],

Cell[BoxData[
    \(Pattern::"patm" \(\(:\)\(\ \)\) 
      "Too many (\!\(14\)) optional arguments required in \
\!\({\(\(Optional[\(\(\(\(Pattern[\(\(1, _\)\)]\)\), 1\)\)]\)\), \(\(\
\[LeftSkeleton] 12 \[RightSkeleton]\)\), \(\(Optional[\(\(\(\(Pattern[\(\(14, \
_\)\)]\)\), 14\)\)]\)\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Pattern::patm"],

Cell[BoxData[
    \(Pattern::"patm" \(\(:\)\(\ \)\) 
      "Too many (\!\(14\)) optional arguments required in \
\!\({\(\(Optional[\(\(\(\(Pattern[\(\(1, _\)\)]\)\), 1\)\)]\)\), \(\(\
\[LeftSkeleton] 12 \[RightSkeleton]\)\), \(\(Optional[\(\(\(\(Pattern[\(\(14, \
_\)\)]\)\), 14\)\)]\)\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Pattern::patm"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Pattern::patm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pattern::patsym", "ObjectNameWarningMessages",
  CellTags->"Pattern::patsym"],

Cell[BoxData[
    RowBox[{\(Pattern::"patsym"\), \(\(:\)\(\ \)\), \(\(First\)\(\ \
\)\(element\)\(\ \)\(in\)\(\ \)\(pattern\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ \(\(symbol\)\(.\)\)\)\)}]], "Message",
  CellTags->"Pattern::patsym"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Pattern::patsym"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pattern::patv", "ObjectNameWarningMessages",
  CellTags->"Pattern::patv"],

Cell[BoxData[
    RowBox[{\(Pattern::"patv"\), \(\(:\)\(\ \)\), \(\(Name\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(used\ for\ both\ fixed\ and\ variable\ length\ \
\(\(patterns\)\(.\)\)\)\)}]], "Message",
  CellTags->"Pattern::patv"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the same name is used for both \
fixed-length patterns and variable-length patterns in the same rule.\n\
\[FilledSmallSquare] A variable-length pattern is a pattern such as ",
  StyleBox["__", "MR"],
  " or ",
  StyleBox["___", "MR"],
  " that can match expressions with variable length."
}], "Notes",
  CellTags->"Pattern::patv"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Pattern::patv"],

Cell["\<\
An error occurs in this example because the same symbol is used as \
the name of a pattern of fixed length and a pattern of variable length.\
\>", \
"Text",
  CellTags->"Pattern::patv"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 4, 3, 2, 1} /. {p_, p__} -> {{p}, {p}}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Pattern::patv"],

Cell[BoxData[
    \(Pattern::"patv" \(\(:\)\(\ \)\) 
      "Name \!\(p\) used for both fixed and variable length patterns."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Pattern::patv"],

Cell[BoxData[
    \({1, 4, 3, 2, 1}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Pattern::patv"]
}, Open  ]],

Cell["\<\
This rule can be applied without error if different names are used \
for the elements in the pattern.\
\>", "Text",
  CellTags->"Pattern::patv"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 4, 3, 2, 1} /. {p_, q__} -> {{p}, {q}}\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Pattern::patv"],

Cell[BoxData[
    \({{1}, {4, 3, 2, 1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Pattern::patv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PatternTest::ptest", "ObjectNameWarningMessages",
  CellTags->"PatternTest::ptest"],

Cell[BoxData[
    RowBox[{\(PatternTest::"ptest"\), \(\(:\)\(\ \)\), \(\(No\)\(\ \
\)\(patterns\)\(\ \)\(found\)\(\ \)\(in\)\(\ \)\(test\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"PatternTest::ptest"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first element in a ",
  StyleBox["PatternTest", "MR"],
  " pattern does not include any special pattern expressions.\n\
\[FilledSmallSquare] The notation ",
  StyleBox["p", "TI"],
  StyleBox["?", "MR"],
  StyleBox["test", "TI"],
  " is used for entering ",
  StyleBox["PatternTest[", "MR"],
  StyleBox["p", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["test", "TI"],
  StyleBox["]", "MR"],
  ".\n\[FilledSmallSquare] Pattern expressions are expressions such as ",
  StyleBox["_", "MR"],
  " or ",
  StyleBox["__", "MR"],
  " that match expressions other than themselves."
}], "Notes",
  CellTags->"PatternTest::ptest"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Protect::pssl", "ObjectNameWarningMessages",
  CellTags->"Protect::pssl"],

Cell[BoxData[
    RowBox[{\(Protect::"pssl"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ string, \ symbol, \ 
      or\ list\ of\ strings\ and\ \(\(symbols\)\(.\)\)\)\)}]], "Message",
  CellTags->"Protect::pssl"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["Protect", "MR"],
  " does not have the expected form."
}], "Notes",
  CellTags->"Protect::pssl"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Protect::pssl"],

Cell["\<\
An error occurs in this example because the argument is a number.\
\
\>", "Text",
  CellTags->"Protect::pssl"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Protect[0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Protect::pssl"],

Cell[BoxData[
    \(Protect::"pssl" \(\(:\)\(\ \)\) 
      "\!\(0\) is not a string, symbol, or list of strings and symbols."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Protect::pssl"],

Cell[BoxData[
    \(Protect[0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Protect::pssl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Remove::relex", "ObjectNameWarningMessages",
  CellTags->"Remove::relex"],

Cell[BoxData[
    RowBox[{\(Remove::"relex"\), \(\(:\)\(\ \)\), \(\(Cannot\)\(\ \
\)\(remove\)\(\ \)\(lexical\)\(\ \)\(symbol\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(except\ automatically\ \(\((\)\(when\)\(\ \)\)\)\), 
      StyleBox["expr",
        "TI"], \(\(\(\ \)\(is\ removed\)\()\)\)\(.\)\)}]], "Message",
  CellTags->"Remove::relex"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Remove", "MR"],
  " is used with a symbol that can only be removed automatically."
}], "Notes",
  CellTags->"Remove::relex"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Remove::relex"],

Cell["\<\
An error occurs in this example because of the attempt to remove a \
symbol that was generated automatically for the purpose of variable \
localization.\
\>", "Text",
  CellTags->"Remove::relex"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{x}, Remove[Evaluate[Part[p_ :> p\ x, 1, 1]]]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Remove::relex"],

Cell[BoxData[
    \(Remove::"relex" \(\(:\)\(\ \)\) 
      "Cannot remove lexical symbol \!\(p$\) except automatically (when \!\(p\
\) is removed)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Remove::relex"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Remove::remal", "ObjectNameWarningMessages",
  CellTags->"Remove::remal"],

Cell[BoxData[
    RowBox[{\(Remove::"remal"\), \(\(:\)\(\ \)\), \(\(Symbol\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(already\ \(\(removed\)\(.\)\)\)\)}]], "Message",
  CellTags->"Remove::remal"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Remove", "MR"],
  " is applied more than once to the same symbol."
}], "Notes",
  CellTags->"Remove::remal"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Remove::remal"],

Cell[TextData[{
  "An error occurs in this example when ",
  StyleBox["Remove", "MR"],
  " is used a second time on the same symbol."
}], "Text",
  CellTags->"Remove::remal"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Remove[symtest]; Remove[symtest]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Remove::remal"],

Cell[BoxData[
    RowBox[{\(Remove::"remal"\), \(\(:\)\(\ \)\), "\<\"Symbol \
\\!\\(\\*TagBox[\\(Removed[\\\"symtest\\\"]\\), False, Rule[Editable, False]]\
\\) already removed.\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Remove::remal"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Remove::rmlck", "ObjectNameWarningMessages",
  CellTags->"Remove::rmlck"],

Cell[BoxData[
    RowBox[{\(Remove::"rmlck"\), \(\(:\)\(\ \)\), \(\(Symbol\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ Locked\ and\ cannot\ be\ \
\(\(removed\)\(.\)\)\)\)}]], "Message",
  CellTags->"Remove::rmlck"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Remove", "MR"],
  " is applied to a symbol that has the ",
  StyleBox["Locked", "MR"],
  " attribute."
}], "Notes",
  CellTags->"Remove::rmlck"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Remove::rmlck"],

Cell[TextData[{
  "An error occurs in this example because the symbol ",
  StyleBox["List", "MR"],
  " has the ",
  StyleBox["Locked", "MR"],
  " attribute."
}], "Text",
  CellTags->"Remove::rmlck"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Remove[List]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Remove::rmlck"],

Cell[BoxData[
    \(Remove::"rmlck" \(\(:\)\(\ \)\) 
      "Symbol \!\(List\) is Locked and cannot be removed."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Remove::rmlck"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Attributes[List]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Remove::rmlck"],

Cell[BoxData[
    \({Locked, Protected}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Remove::rmlck"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Remove::rmptc", "ObjectNameWarningMessages",
  CellTags->"Remove::rmptc"],

Cell[BoxData[
    RowBox[{\(Remove::"rmptc"\), \(\(:\)\(\ \)\), \(\(Symbol\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ Protected\ and\ cannot\ be\ \(\(removed\)\(.\)\)\
\)\)}]], "Message",
  CellTags->"Remove::rmptc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Remove", "MR"],
  " is applied to a symbol with the ",
  StyleBox["Protected", "MR"],
  " attribute."
}], "Notes",
  CellTags->"Remove::rmptc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Remove::rmptc"],

Cell[TextData[{
  "An error occurs in this example because the ",
  StyleBox["Protected", "MR"],
  " attribute is set for the test symbol."
}], "Text",
  CellTags->"Remove::rmptc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Protect[symtest]; Remove[symtest]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Remove::rmptc"],

Cell[BoxData[
    \(Remove::"rmptc" \(\(:\)\(\ \)\) 
      "Symbol \!\(symtest\) is Protected and cannot be removed."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"Remove::rmptc"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Attributes[symtest]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Remove::rmptc"],

Cell[BoxData[
    \({Protected}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Remove::rmptc"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Unprotect", "MR"],
  " can be used to clear the ",
  StyleBox["Protected", "MR"],
  " attribute so that this symbol can be removed."
}], "Text",
  CellTags->"Remove::rmptc"],

Cell[BoxData[
    \(Unprotect[symtest]; Remove[symtest]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Remove::rmptc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Remove::ssym", "ObjectNameWarningMessages",
  CellTags->"Remove::ssym"],

Cell[BoxData[
    RowBox[{\(Remove::"ssym"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ \(\(symbol\)\(.\)\)\)\)}]], "Message",
  CellTags->"Remove::ssym"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["Remove", "MR"],
  " is not a symbol.\n\[FilledSmallSquare] The argument in ",
  StyleBox["Remove", "MR"],
  " can also be a string that gives the name of a symbol."
}], "Notes",
  CellTags->"Remove::ssym"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Remove::ssym"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["Remove", "MR"],
  " is a number."
}], "Text",
  CellTags->"Remove::ssym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Remove[0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Remove::ssym"],

Cell[BoxData[
    \(Remove::"ssym" \(\(:\)\(\ \)\) "\!\(0\) is not a symbol."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"Remove::ssym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::rep", "ObjectNameWarningMessages",
  CellTags->"General::rep"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"rep\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "a", " ", "valid", " ", 
        "replacement", " ", \(\(rule\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::rep"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated expression is expected \
to be a rule.\n\[FilledSmallSquare] A rule is an expression with a head of ",
  StyleBox["Rule", "MR"],
  " or ",
  StyleBox["RuleDelayed", "MR"],
  "."
}], "Notes",
  CellTags->"General::rep"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::rep"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Automatic", "MR"],
  " is not a rule."
}], "Text",
  CellTags->"General::rep"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[testsym] = testopt -> 0\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::rep"],

Cell[BoxData[
    \(testopt \[Rule] 0\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::rep"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[testsym, Automatic]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::rep"],

Cell[BoxData[
    \(SetOptions::"rep" \(\(:\)\(\ \)\) 
      "\!\(Automatic\) is not a valid replacement rule."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::rep"],

Cell[BoxData[
    \(SetOptions[testsym, Automatic]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::rep"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["SetOptions", "MR"],
  "."
}], "Text",
  CellTags->"General::rep"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[testsym, testopt -> Automatic]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::rep"],

Cell[BoxData[
    \({testopt \[Rule] Automatic}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::rep"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Replace::rmix
ReplaceAll::rmix
ReplaceRepeated::rmix
ReplaceList::rmix\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"rmix\"\>"}], \(\(:\)\(\ \)\), "Elements", " ", 
        "of", " ", 
        StyleBox["expr",
          "TI"], " ", "are", " ", "a", " ", "mixture", " ", "of", " ", 
        "lists", " ", "and", " ", "non"}], 
      "-", \(\(lists\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],

Cell["\<\
\[FilledSmallSquare] Generated when the second argument in the \
indicated function is a list in which some of the elements are lists and some \
of the elements are not lists.\
\>", "Notes",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],

Cell["\<\
An error occurs in this example because the of the irregular lists \
of rules.\
\>", "Text",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({2, 5, 1} /. {{5 -> 0}, 5 -> 3}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],

Cell[BoxData[
    \(ReplaceAll::"rmix" \(\(:\)\(\ \)\) 
      "Elements of \!\({\(\({5 \[Rule] 0}\)\), \(\(5 \[Rule] 3\)\)}\) are a \
mixture of lists and non-lists."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
    "Replace::rmix"}],

Cell[BoxData[
    \({2, 5, 1} /. \[InvisibleSpace]{{5 \[Rule] 0}, 5 \[Rule] 3}\)], "Output",\

  CellLabel->"Out[1]=",
  CellTags->{
  "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
    "Replace::rmix"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["ReplaceAll", "MR"],
  "."
}], "Text",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({2, 5, 1} /. {{5 -> 0}, {5 -> 3}}\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],

Cell[BoxData[
    \({{2, 0, 1}, {2, 3, 1}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
    "Replace::rmix"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
ReplacePart::psl
ReplaceHeldPart::psl
MapAt::psl
Delete::psl
FlattenAt::psl
Insert::psl
StringInsert::psl
StringReplacePart::psl
Extract::psl\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"psl\"\>"}], \(\(:\)\(\ \)\), "Position", " ", 
      "specification", " ", 
      StyleBox["pos",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "an", " ", "integer", " ", "or", 
      " ", "a", " ", "list", " ", "of", 
      " ", \(\(integers\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression is not \
a valid position specification.\
\>", "Notes",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["First", "MR"],
  " is not a valid position specification."
}], "Text",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(MapAt[10  # &, {3, 5, 7, 2}, First]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],

Cell[BoxData[
    \(MapAt::"psl" \(\(:\)\(\ \)\) 
      "Position specification \!\(First\) in \!\(MapAt[\(\(\(\(\(\(10\\ \
#1\)\) &\)\), \(\({3, 5, 7, 2}\)\), First\)\)]\) is not an integer or a list \
of integers."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
    "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
    "StringInsert::psl", "StringReplacePart::psl"}],

Cell[BoxData[
    \(MapAt[10\ #1 &, {3, 5, 7, 2}, First]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
    "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
    "StringInsert::psl", "StringReplacePart::psl"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid position specification in ",
  StyleBox["MapAt", "MR"],
  "."
}], "Text",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(MapAt[10  # &, {3, 5, 7, 2}, 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],

Cell[BoxData[
    \({30, 5, 7, 2}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
    "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
    "StringInsert::psl", "StringReplacePart::psl"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReplaceRepeated::rrlim", "ObjectNameWarningMessages",
  CellTags->"ReplaceRepeated::rrlim"],

Cell[BoxData[
    RowBox[{\(ReplaceRepeated::"rrlim"\), \(\(:\)\(\ \)\), \(\(Exiting\)\(\ \
\)\(after\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "scanned", " ", 
      StyleBox["n",
        "TI"], " ", \(\(times\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"ReplaceRepeated::rrlim"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of times that a rule is \
applied in a single evaluation exceeds the value of the ",
  StyleBox["MaxIterations", "MR"],
  " option."
}], "Notes",
  CellTags->"ReplaceRepeated::rrlim"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ReplaceRepeated::rrlim"],

Cell["\<\
An error occurs in this example because this rule can be applied an \
infinite number of times.\
\>", "Text",
  CellTags->"ReplaceRepeated::rrlim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(0 //. p_ :> p + 1\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ReplaceRepeated::rrlim"],

Cell[BoxData[
    \(ReplaceRepeated::"rrlim" \(\(:\)\(\ \)\) 
      "Exiting after \!\(0\) scanned \!\(65536\) times."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ReplaceRepeated::rrlim"],

Cell[BoxData[
    \(65536\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ReplaceRepeated::rrlim"]
}, Open  ]],

Cell[TextData[{
  "The maximum number of times that a rule will be applied is given by the \
value of the ",
  StyleBox["MaxIterations", "MR"],
  " option."
}], "Text",
  CellTags->"ReplaceRepeated::rrlim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[ReplaceRepeated]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ReplaceRepeated::rrlim"],

Cell[BoxData[
    \({MaxIterations \[Rule] 65536}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ReplaceRepeated::rrlim"]
}, Open  ]],

Cell["This shows a rule that is applied a finite number of times.", "Text",
  CellTags->"ReplaceRepeated::rrlim"],

Cell[CellGroupData[{

Cell[BoxData[
    \(0 //. p_ :> p + 1 /; p < 1000\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"ReplaceRepeated::rrlim"],

Cell[BoxData[
    \(1000\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"ReplaceRepeated::rrlim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Return::nofsdd", "ObjectNameWarningMessages",
  CellTags->"Return::nofsdd"],

Cell[BoxData[
    RowBox[{\(Return::"nofsdd"\), \(\(:\)\(\ \)\), \(No\ enclosing\ function, \
\ Scan, \ 
      Do, \ \(\(or\)\(\ \)\(Dialog\)\(\ \)\(found\)\(\ \)\(for\)\(\ \)\)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"Return::nofsdd"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Return", "MR"],
  " is encountered and there is no enclosing function from which to return.\n \
\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Return::nofsdd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Rule::rhs
RuleDelayed::rhs\
\>", "ObjectNameWarningMessages",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"rhs\"\>"}], \(\(:\)\(\ \)\), "Pattern", " ", 
        StyleBox["p",
          "TI"], " ", "appears", " ", "on", " ", "the", " ", "right"}], "-", 
      RowBox[{"hand", " ", "side", " ", "of", " ", "rule", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a pattern is encountered on the \
right-hand side of a rule.\n\[FilledSmallSquare] This is a warning message \
about an unusual use of patterns. It does not necessarily indicate an error.\n\
\[FilledSmallSquare] A pattern is an expression that matches something other \
than itself. ",
  StyleBox["x_", "MR"],
  " and ",
  StyleBox["p__", "MR"],
  " are examples of common patterns.\n\[FilledSmallSquare] Patterns are \
typically used only on the left-hand sides of rules and assignments."
}], "Notes",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],

Cell[TextData[{
  "A warning message is generated in this example because the pattern ",
  StyleBox["p_", "MR"],
  " is used in an unusual way on the right-hand side of the rule."
}], "Text",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 2, 3, 4, 5} /. p_Integer :> p_ + 1\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],

Cell[BoxData[
    \(RuleDelayed::"rhs" \(\(:\)\(\ \)\) 
      "Pattern \!\(p_\) appears on the right-hand side of rule \!\(p_Integer \
\[RuleDelayed] \(\(p_ + 1\)\)\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"RuleDelayed::rhs", "Rule::rhs"}],

Cell[BoxData[
    \({1 + Pattern[1, _], 1 + Pattern[2, _], 1 + Pattern[3, _], 
      1 + Pattern[4, _], 1 + Pattern[5, _]}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"RuleDelayed::rhs", "Rule::rhs"}]
}, Open  ]],

Cell["This shows a more typical use of a pattern in a rule.", "Text",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 2, 3, 4, 5} /. p_Integer :> p + 1\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],

Cell[BoxData[
    \({2, 3, 4, 5, 6}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"RuleDelayed::rhs", "Rule::rhs"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Set::lhsr
SetDelayed::lhsr
Unset::lhsr
TagSet::lhsr
TagSetDelayed::lhsr
TagUnset::lhsr
UpSet::lhsr
UpSetDelayed::lhsr\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
    "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
    "UpSetDelayed::lhsr"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"lhsr\"\>"}], \(\(:\)\(\ \)\), "Replacing", " ", 
        "rule", " ", 
        StyleBox["r1",
          "TI"], " ", "with", " ", "rule", " ", 
        StyleBox["r2",
          "TI"], " ", "since", " ", "their", " ", "left"}], 
      "-", \(hand\ sides\ and\ conditions\ are\ \(\(equivalent\)\(.\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
    "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
    "UpSetDelayed::lhsr"}],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->{
  "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
    "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
    "UpSetDelayed::lhsr"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Set::setraw
SetDelayed::setraw
UpSet::setraw
UpSetDelayed::setraw
TagSet::setraw
TagSetDelayed::setraw\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"setraw\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "assign", " ", "to", " ", "raw", " ", "object", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the left-hand side of an assignment is \
a number or a string.\n\[FilledSmallSquare] This error may occur if an \
assignment (",
  StyleBox["lhs", "MR",
    FontSlant->"Italic"],
  StyleBox["=", "MR"],
  StyleBox["rhs", "MR",
    FontSlant->"Italic"],
  ") is used in place of an equation (",
  StyleBox["lhs", "MR",
    FontSlant->"Italic"],
  StyleBox["==", "MR"],
  StyleBox["rhs", "MR",
    FontSlant->"Italic"],
  ")."
}], "Notes",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell["\<\
An error occurs in this example because it is not possible to \
assign a value to a number.\
\>", "Text",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(0 = 9 - 3  x\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell[BoxData[
    \(Set::"setraw" \(\(:\)\(\ \)\) 
      "Cannot assign to raw object \!\(0\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
    "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],

Cell[BoxData[
    \(9 - 3\ x\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
    "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}]
}, Open  ]],

Cell[TextData[{
  "This shows the same error in the arguments of ",
  StyleBox["Solve", "MR"],
  "."
}], "Text",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[0 = 9 - 3  x, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell[BoxData[
    \(Set::"setraw" \(\(:\)\(\ \)\) 
      "Cannot assign to raw object \!\(0\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{
  "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
    "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],

Cell[BoxData[
    \(Solve::"eqf" \(\(:\)\(\ \)\) 
      "\!\(9 - \(\(3\\ x\)\)\) is not a well-formed equation."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->{
  "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
    "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],

Cell[BoxData[
    \(Solve[9 - 3\ x, x]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
    "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}]
}, Open  ]],

Cell["This example shows a valid equation.", "Text",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[0 == 9 - 3  x, x]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell[BoxData[
    \({{x \[Rule] 3}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{
  "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
    "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Set::shape
SetDelayed::shape\
\>", "ObjectNameWarningMessages",
  CellTags->{"Set::shape", "SetDelayed::shape"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"shape\"\>"}], \(\(:\)\(\ \)\), "Lists", " ", 
      StyleBox["e1",
        "TI"], " ", "and", " ", 
      StyleBox["e2",
        "TI"], " ", "are", " ", "not", " ", "the", " ", "same", 
      " ", \(\(shape\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Set::shape", "SetDelayed::shape"}],

Cell["\<\
\[FilledSmallSquare] Generated when corresponding lists or sublists \
on opposite sides of an equation do not have the same length.\
\>", "Notes",
  CellTags->{"Set::shape", "SetDelayed::shape"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Set::shape", "SetDelayed::shape"}],

Cell["\<\
An error occurs in this example because the list on the right side \
of this assignment does not have the same length as the list on the left side \
of the assignment.\
\>", "Text",
  CellTags->{"Set::shape", "SetDelayed::shape"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({var1, var2, var3} = {1, 2, 3, 4}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Set::shape", "SetDelayed::shape"}],

Cell[BoxData[
    \(Set::"shape" \(\(:\)\(\ \)\) 
      "Lists \!\({var1, var2, var3}\) and \!\({1, 2, 3, 4}\) are not the same \
shape."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"SetDelayed::shape", "Set::shape"}],

Cell[BoxData[
    \({1, 2, 3, 4}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"SetDelayed::shape", "Set::shape"}]
}, Open  ]],

Cell["This shows a valid assignment.", "Text",
  CellTags->{"Set::shape", "SetDelayed::shape"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({var1, var2, var3} = {1, 2, 3}\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Set::shape", "SetDelayed::shape"}],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"SetDelayed::shape", "Set::shape"}]
}, Open  ]],

Cell["Clear the assigned values.", "Text",
  CellTags->{"Set::shape", "SetDelayed::shape"}],

Cell[BoxData[
    \(Clear[var1, var2, var3]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Set::shape", "SetDelayed::shape"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Set::setrpt
SetDelayed::setrpt
UpSet::setrpt
UpSetDelayed::setrpt
TagSet::setrpt
TagSetDelayed::setrpt\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
    "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"setrpt\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "assign", " ", "to", " ", "raw", " ", "object", " ", 
      StyleBox["expr",
        "TI"], " ", "in", " ", "pattern", " ", 
      RowBox[{
        StyleBox["p",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
    "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],

Cell["\<\
\[FilledSmallSquare] Generated when the left-hand side of an \
assignment is a pattern in which the assignment tag is a number or a \
string.\
\>", "Notes",
  CellTags->{
  "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
    "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
    "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],

Cell["\<\
An error occurs in this example because it is not possible to \
assign a value to a number.\
\>", "Text",
  CellTags->{
  "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
    "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Verbatim[3] = 0\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
    "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],

Cell[BoxData[
    \(Set::"setrpt" \(\(:\)\(\ \)\) 
      "Cannot assign to raw object \!\(3\) in pattern \!\(Verbatim[3]\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
    "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
    "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetOptions::optf", "ObjectNameWarningMessages",
  CellTags->"SetOptions::optf"],

Cell[BoxData[
    RowBox[{\(SetOptions::"optf"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "has", " ", "incorrectly", " ", "formed", " ", "options", 
      " ", 
      RowBox[{
        StyleBox["opts",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"SetOptions::optf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["SetOptions", "MR"],
  " is used with symbol and ",
  StyleBox["Options", "MR"],
  " for that symbol is not a list.\n\[FilledSmallSquare] This message is \
expected if ",
  StyleBox["Options", "MR"],
  " has been redefined so that it does not always return a list."
}], "Notes",
  CellTags->"SetOptions::optf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SetOptions::optf"],

Cell[TextData[{
  "An error occurs in this example because of the temporary redefinition of \
",
  StyleBox["Options", "MR"],
  "."
}], "Text",
  CellTags->"SetOptions::optf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{Options, var}, SetOptions[var, 0]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SetOptions::optf"],

Cell[BoxData[
    \(SetOptions::"optf" \(\(:\)\(\ \)\) 
      "\!\(var\) has incorrectly formed options \!\(Options[var]\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"SetOptions::optf"],

Cell[BoxData[
    \(SetOptions::"rep" \(\(:\)\(\ \)\) 
      "\!\(0\) is not a valid replacement rule."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SetOptions::optf"],

Cell[BoxData[
    \(SetOptions[var, 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SetOptions::optf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetOptions::sstm", "ObjectNameWarningMessages",
  CellTags->"SetOptions::sstm"],

Cell[BoxData[
    RowBox[{\(SetOptions::"sstm"\), \(\(:\)\(\ \)\), \(\(Argument\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ symbol\ or\ a\ \
\(\(stream\)\(.\)\)\)\)}]], "Message",
  CellTags->"SetOptions::sstm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["SetOptions", "MR"],
  " is not a symbol or a stream.\n\[FilledSmallSquare] Options can only be \
set for symbols or for stream expressions.\n\[FilledSmallSquare] A stream \
expression is an expression with a head of ",
  StyleBox["InputStream", "MR"],
  " or ",
  StyleBox["OutputStream", "MR"],
  " that represents a channel for input or output."
}], "Notes",
  CellTags->"SetOptions::sstm"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SetOptions::sstm"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["SetOptions", "MR"],
  " is a rule."
}], "Text",
  CellTags->"SetOptions::sstm"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[opt -> 0, var]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SetOptions::sstm"],

Cell[BoxData[
    \(SetOptions::"sstm" \(\(:\)\(\ \)\) 
      "Argument \!\(opt \[Rule] 0\) is not a symbol or a stream."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"SetOptions::sstm"],

Cell[BoxData[
    \(SetOptions[opt \[Rule] 0, var]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SetOptions::sstm"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["SetOptions", "MR"],
  " to change the options of a symbol."
}], "Text",
  CellTags->"SetOptions::sstm"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Options[var] = opt -> 1;\)\), "\n", 
    \(SetOptions[var, opt -> 0]\)}], "Input",
  CellLabel->"In[2]:=",
  CellTags->"SetOptions::sstm"],

Cell[BoxData[
    \({opt \[Rule] 0}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"SetOptions::sstm"]
}, Open  ]],

Cell[TextData[{
  "Clear the options of ",
  StyleBox["var", "MR"],
  "."
}], "Text",
  CellTags->"SetOptions::sstm"],

Cell[BoxData[
    \(ClearAll[var]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"SetOptions::sstm"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stack::stackx", "ObjectNameWarningMessages",
  CellTags->"Stack::stackx"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Stack::"stackx"\), \(\(:\)\(\ \)\), "Expression", " ", 
        "number", " ", 
        StyleBox["n1",
          "TI"], " ", "does", " ", "not", " ", "exist", " ", "in", " ", 
        StyleBox["expr",
          "TI"]}], ";", " ", 
      RowBox[{"there", " ", "are", " ", 
        StyleBox["n2",
          "TI"], " ", "expressions", " ", "of", " ", "the", " ", "requested", 
        " ", \(\(form\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Stack::stackx"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["Stack", "MR"],
  " is an integer greater than the number of stack elements that match the \
form specified in the first argument."
}], "Notes",
  CellTags->"Stack::stackx"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Stack::stackx"],

Cell[TextData[{
  "An error occurs in this example because the evaluation stack is only four \
levels deep when the ",
  StyleBox["Stack", "MR"],
  " expression is evaluated."
}], "Text",
  CellTags->"Stack::stackx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cos[2 + \((Print[Stack[_, 5]]; Pi)\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Stack::stackx"],

Cell[BoxData[
    \(Stack::"stackx" \(\(:\)\(\ \)\) 
      "Expression number \!\(5\) does not exist in \!\(Stack[\(\(_, 5\)\)]\); \
there are \!\(4\) expressions of the requested form."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Stack::stackx"],

Cell[BoxData[
    \(Stack[_, 5]\)], "Print",
  CellLabel->"From In[1]:=",
  CellTags->"Stack::stackx"],

Cell[BoxData[
    \(\(-Cos[2]\)\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Stack::stackx"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Stack", "MR"],
  "."
}], "Text",
  CellTags->"Stack::stackx"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cos[2 + \((Print[Stack[_, 4]]; Pi)\)]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Stack::stackx"],

Cell[BoxData[
    TagBox[\(Print[Stack[_, 4]]\),
      HoldForm]], "Print",
  CellLabel->"From In[2]:=",
  CellTags->"Stack::stackx"],

Cell[BoxData[
    \(\(-Cos[2]\)\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Stack::stackx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringDrop::drop", "ObjectNameWarningMessages",
  CellTags->"StringDrop::drop"],

Cell[BoxData[
    \(StringDrop::"drop" \(\(:\)\(\ \)\) 
      "Cannot drop positions `1` through `2` in \"`3`\"."\)], "Message",
  CellLabel->"From In[53]:=",
  CellTags->"StringDrop::drop"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["StringDrop", "MR"],
  " specifies positions that are not available in the indicated expression."
}], "Notes",
  CellTags->"StringDrop::drop"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"StringDrop::drop"],

Cell["\<\
An error occurs in this example because the specified positions \
fall beyond the end of this string.\
\>", "Text",
  CellTags->"StringDrop::drop"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringDrop["\<112233445566778899\>", {25, 30}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"StringDrop::drop"],

Cell[BoxData[
    \(StringDrop::"drop" \(\(:\)\(\ \)\) 
      "Cannot drop positions \!\(25\) through \!\(30\) in \
\"\!\(\"112233445566778899\"\)\"."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"StringDrop::drop"],

Cell[BoxData[
    \(StringDrop["112233445566778899", {25, 30}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"StringDrop::drop"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["StringDrop", "MR"],
  "."
}], "Text",
  CellTags->"StringDrop::drop"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringDrop["\<112233445566778899\>", {5, 10}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"StringDrop::drop"],

Cell[BoxData[
    \("112266778899"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"StringDrop::drop"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
StringInsert::ins
StringReplacePart::ins\
\>", "ObjectNameWarningMessages",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"ins\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "insert", " ", "at", " ", "position", " ", 
      StyleBox["pos",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],

Cell["\<\
\[FilledSmallSquare] Generated when the specified position does not \
exist in the argument string.\
\>", "Notes",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],

Cell["\<\
An error occurs in this example because the position specified in \
the third argument falls beyond the end of the string.\
\>", "Text",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringInsert["\<11223344\>", "\<99\>", 10]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],

Cell[BoxData[
    \(StringInsert::"ins" \(\(:\)\(\ \)\) 
      "Cannot insert at position \!\(10\) in \!\(\"11223344\"\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],

Cell[BoxData[
    \(StringInsert["11223344", "99", 10]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["StringInsert", "MR"],
  "."
}], "Text",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringInsert["\<112233445\>", "\<99\>", 10]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],

Cell[BoxData[
    \("11223344599"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
StringPosition::meta
StringReplace::meta\
\>", "ObjectNameWarningMessages",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], 
            "::", "\<\"meta\"\>"}], \(\(:\)\(\ \)\), \(Value\ of\ option\ \
MetaCharacters\)}], " ", "->", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "None"}]}], ",", " ", 
      "Automatic", ",", " ", \(a\ string\ of\ length\ 3\), ",", 
      " ", \(or\ a\ list\ of\ three\ \(\(strings\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["MetaCharacters", "MR"],
  " option does not have the indicated form."
}], "Notes",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],

Cell[TextData[{
  "An error occurs in this example because a string containing a single \
character is not a valid value for the ",
  StyleBox["MetaCharacters", "MR"],
  " option."
}], "Text",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringPosition["\<1234568\>", "\<3xx\>", 
      MetaCharacters -> "\<x\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],

Cell[BoxData[
    \(StringPosition::"meta" \(\(:\)\(\ \)\) 
      "Value of option MetaCharacters -> \!\(\"x\"\) is not None, Automatic, \
a string of length 3, or a list of three strings."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],

Cell[BoxData[
    \(StringPosition["1234568", "3xx", 
      MetaCharacters \[Rule] "x"]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["MetaCharacters", "MR"],
  " option."
}], "Text",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringPosition["\<1234568\>", "\<3xx\>", 
      MetaCharacters -> {"\<\\\>", "\<x\>", "\<*\>"}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],

Cell[BoxData[
    \({{3, 5}}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringReplace::srep", "ObjectNameWarningMessages",
  CellTags->"StringReplace::srep"],

Cell[BoxData[
    RowBox[{\(StringReplace::"srep"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ valid\ string\ replacement\ \
\(\(rule\)\(.\)\)\)\)}]], "Message",
  CellTags->"StringReplace::srep"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["StringReplace", "MR"],
  " is not a valid string replacement rule or a list of valid string \
replacement rules.\n\[FilledSmallSquare] A valid string replacement rule is a \
rule in which both sides of the rule are strings."
}], "Notes",
  CellTags->"StringReplace::srep"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"StringReplace::srep"],

Cell[TextData[{
  "An error occurs in this example because both sides of the rule in the \
second argument of ",
  StyleBox["StringReplace", "MR"],
  " are numbers rather than strings."
}], "Text",
  CellTags->"StringReplace::srep"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReplace["\<12345\>", 1 -> 9]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"StringReplace::srep"],

Cell[BoxData[
    \(Rule::"string" \(\(:\)\(\ \)\) 
      "String expected at position \!\(1\) in \!\(1 \[Rule] 9\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"StringReplace::srep"],

Cell[BoxData[
    \(StringReplace::"srep" \(\(:\)\(\ \)\) 
      "\!\(1 \[Rule] 9\) is not a valid string replacement rule."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"StringReplace::srep"],

Cell[BoxData[
    \(StringReplace["12345", 1 \[Rule] 9]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"StringReplace::srep"]
}, Open  ]],

Cell["This shows a valid string replacement rule.", "Text",
  CellTags->"StringReplace::srep"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReplace["\<12345\>", "\<1\>" -> "\<9\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"StringReplace::srep"],

Cell[BoxData[
    \("92345"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"StringReplace::srep"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringReplacePart::ovlp", "ObjectNameWarningMessages",
  CellTags->"StringReplacePart::ovlp"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(StringReplacePart::"ovlp"\), \(\(:\)\(\ \)\), "Position", " ",
         
        StyleBox["pos",
          "TI"], " ", "overlaps", " ", "previous", " ", "positions"}], ";", 
      " ", 
      RowBox[{\(new\ string\), " ", 
        StyleBox["expr",
          
          "TI"], \(\(\ \)\(will\ not\ be\ \(\(inserted\)\(.\)\)\)\)}]}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"StringReplacePart::ovlp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when overlapping position specifications \
are encountered in the third argument of ",
  StyleBox["StringReplacePart", "MR"],
  "."
}], "Notes",
  CellTags->"StringReplacePart::ovlp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"StringReplacePart::ovlp"],

Cell["\<\
An error occurs in this example because the position specifications \
refer to overlapping ranges in the string.\
\>", "Text",
  CellTags->"StringReplacePart::ovlp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReplacePart["\<123456789\>", "\<x\>", {{4, 5}, {5, 
          6}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"StringReplacePart::ovlp"],

Cell[BoxData[
    \(StringReplacePart::"ovlp" \(\(:\)\(\ \)\) 
      "Position \!\({5, 6}\) overlaps previous positions; new string \
\!\(\"x\"\) will not be inserted."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"StringReplacePart::ovlp"],

Cell[BoxData[
    \("123x6789"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"StringReplacePart::ovlp"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["StringReplacePart", "MR"],
  "."
}], "Text",
  CellTags->"StringReplacePart::ovlp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReplacePart["\<123456789\>", "\<x\>", {{4, 5}, {7, 
          8}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"StringReplacePart::ovlp"],

Cell[BoxData[
    \("123x6x9"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"StringReplacePart::ovlp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringReplacePart::repart", "ObjectNameWarningMessages",
  CellTags->"StringReplacePart::repart"],

Cell[BoxData[
    \(StringReplacePart::"repart" \(\(:\)\(\ \)\) 
      "Cannot replace positions `1` through `2` in \"`3`\"."\)], "Message",
  CellLabel->"From In[53]:=",
  CellTags->"StringReplacePart::repart"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the positions specified in the third \
argument of ",
  StyleBox["StringReplacePart", "MR"],
  " fall outside of the string given in the first argument."
}], "Notes",
  CellTags->"StringReplacePart::repart"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"StringReplacePart::repart"],

Cell["\<\
An error occurs in this example because the specified string \
positions are not available in the string given in the first argument.\
\>", \
"Text",
  CellTags->"StringReplacePart::repart"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReplacePart["\<123456\>", "\<xyz\>", {5, 7}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"StringReplacePart::repart"],

Cell[BoxData[
    \(StringReplacePart::"repart" \(\(:\)\(\ \)\) 
      "Cannot replace positions \!\(5\) through \!\(7\) in \"\!\(\"123456\"\)\
\"."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"StringReplacePart::repart"],

Cell[BoxData[
    \(StringReplacePart["123456", "xyz", {5, 7}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"StringReplacePart::repart"]
}, Open  ]],

Cell["\<\
This shows a valid position specification for the given \
string.\
\>", "Text",
  CellTags->"StringReplacePart::repart"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReplacePart["\<123456\>", "\<xyz\>", {4, 6}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"StringReplacePart::repart"],

Cell[BoxData[
    \("123xyz"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"StringReplacePart::repart"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["StringReplacePart::spos", "ObjectNameWarningMessages",
  CellTags->"StringReplacePart::spos"],

Cell[BoxData[
    RowBox[{\(StringReplacePart::"spos"\), \(\(:\)\(\ \)\), "Position", " ", 
      "specification", " ", \({m, \ n}\), " ", "is", " ", "expected", " ", 
      "at", " ", "position", " ", 
      StyleBox["p",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"StringReplacePart::spos"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the third argument in ",
  StyleBox["StringReplacePart", "MR"],
  " is not an integer, a pair of integers, or a list of pairs of integers."
}], "Notes",
  CellTags->"StringReplacePart::spos"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"StringReplacePart::spos"],

Cell["\<\
An error occurs in this example because the third argument is not a \
pair of integers.\
\>", "Text",
  CellTags->"StringReplacePart::spos"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReplacePart["\<123456\>", "\<xyz\>", {2}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"StringReplacePart::spos"],

Cell[BoxData[
    \(StringReplacePart::"spos" \(\(:\)\(\ \)\) 
      "Position specification {m, n} is expected at position \!\(1\) in \!\({\
\({2}\)}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"StringReplacePart::spos"],

Cell[BoxData[
    \(StringReplacePart["123456", "xyz", {2}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"StringReplacePart::spos"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid position specification in ",
  StyleBox["StringReplacePart", "MR"],
  "."
}], "Text",
  CellTags->"StringReplacePart::spos"],

Cell[CellGroupData[{

Cell[BoxData[
    \(StringReplacePart["\<123456\>", "\<xyz\>", {2, 2}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"StringReplacePart::spos"],

Cell[BoxData[
    \("1xyz3456"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"StringReplacePart::spos"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbol::symname", "ObjectNameWarningMessages",
  CellTags->"Symbol::symname"],

Cell[BoxData[
    \(Symbol::"symname" \(\(:\)\(\ \)\) 
      "The string \"`1`\" cannot be used for a symbol name. A symbol name \
must start with a letter followed by letters and numbers."\)], "Message",
  CellLabel->"From In[61]:=",
  CellTags->"Symbol::symname"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["Symbol", "MR"],
  " is not a syntactically valid symbol name."
}], "Notes",
  CellTags->"Symbol::symname"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Symbol::symname"],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["Symbol", "MR"],
  " is not valid syntax for the name of a symbol."
}], "Text",
  CellTags->"Symbol::symname"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Symbol["\<test[0]\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Symbol::symname"],

Cell[BoxData[
    \(Symbol::"symname" \(\(:\)\(\ \)\) 
      "The string \"\!\(\"test[0]\"\)\" cannot be used for a symbol name. A \
symbol name must start with a letter followed by letters and numbers."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"Symbol::symname"],

Cell[BoxData[
    \(Symbol["test[0]"]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Symbol::symname"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["Symbol", "MR"],
  "."
}], "Text",
  CellTags->"Symbol::symname"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Symbol["\<test0\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Symbol::symname"],

Cell[BoxData[
    \(test0\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Symbol::symname"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
TagSet::tagnf
TagSetDelayed::tagnf
TagUnset::tagnf\
\>", "ObjectNameWarningMessages",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"tagnf\"\>"}], \(\(:\)\(\ \)\), "Tag", " ", 
      StyleBox["sym",
        "TI"], " ", "not", " ", "found", " ", "in", " ", 
      RowBox[{
        StyleBox["lhs",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],

Cell["\<\
\[FilledSmallSquare] Generated when the tag symbol is not found in \
the expression on the left side of a tagged assignment.\
\>", "Notes",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],

Cell["\<\
An error occurs in this example because the specified tag is not \
present in this assignment.\
\>", "Text",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sym /: {1, 2, 3} := {1, 0, 0}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],

Cell[BoxData[
    \(TagSetDelayed::"tagnf" \(\(:\)\(\ \)\) 
      "Tag \!\(sym\) not found in \!\({1, 2, 3}\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}]
}, Open  ]],

Cell["\<\
This shows a valid tagged assignment and an application of the \
resulting evaluation rule.\
\>", "Text",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],

Cell[BoxData[
    \(sym /: {1, 2, 3, sym} := {1, 0, 0}\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 2, 3, sym}\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],

Cell[BoxData[
    \({1, 0, 0}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}]
}, Open  ]],

Cell[TextData[{
  "Clear the rule for ",
  StyleBox["sym", "MR"],
  "."
}], "Text",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],

Cell[BoxData[
    \(Clear[sym]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
TagSet::tagpos
TagSetDelayed::tagpos
TagUnset::tagpos\
\>", "ObjectNameWarningMessages",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"tagpos\"\>"}], \(\(:\)\(\ \)\), "Tag", " ", 
      StyleBox["sym",
        "TI"], " ", "in", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "too", " ", "deep", " ", "for", " ", "an", " ",
       "assigned", " ", "rule", " ", "to", " ", "be", 
      " ", \(\(found\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],

Cell["\<\
\[FilledSmallSquare] Generated when the tag symbol is not found in \
the outer two levels on the left side of a tagged assignment.\
\>", "Notes",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],

Cell["\<\
An error occurs in this example because the tag symbol is found \
only at a level beyond the outer two levels on the left side of this \
assignment.\
\>", "Text",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(p /: c1[c2[p]] := 1\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],

Cell[BoxData[
    \(TagSetDelayed::"tagpos" \(\(:\)\(\ \)\) 
      "Tag \!\(p\) in \!\(c1[\(\(c2[p]\)\)]\) is too deep for an assigned \
rule to be found."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}]
}, Open  ]],

Cell["\<\
This shows a valid tag for this assignment and an application of \
the resulting evaluation rule.\
\>", "Text",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],

Cell[BoxData[
    \(c2 /: c1[c2[p]] := 1\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(c1[c2[p]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}]
}, Open  ]],

Cell[TextData[{
  "Clear the rule for ",
  StyleBox["c2", "MR"],
  "."
}], "Text",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],

Cell[BoxData[
    \(Clear[c2]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Throw::nocatch", "ObjectNameWarningMessages",
  CellTags->"Throw::nocatch"],

Cell[BoxData[
    RowBox[{\(Throw::"nocatch"\), \(\(:\)\(\ \)\), \(\(Uncaught\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(returned\ to\ top\ \(\(level\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"Throw::nocatch"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Throw", "MR"],
  " is used without an enclosing ",
  StyleBox["Catch", "MR"],
  "."
}], "Notes",
  CellTags->"Throw::nocatch"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Throw::nocatch"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Throw", "MR"],
  " is used without an enclosing ",
  StyleBox["Catch", "MR"],
  "."
}], "Text",
  CellTags->"Throw::nocatch"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[If[k < 4, Print["\<k = \>", k], Throw[k]], {k, 99}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Throw::nocatch"],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]1\),
      SequenceForm[ "k = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[1]:=",
  CellTags->"Throw::nocatch"],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]2\),
      SequenceForm[ "k = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[1]:=",
  CellTags->"Throw::nocatch"],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]3\),
      SequenceForm[ "k = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[1]:=",
  CellTags->"Throw::nocatch"],

Cell[BoxData[
    \(Throw::"nocatch" \(\(:\)\(\ \)\) 
      "Uncaught \!\(Throw[4]\) returned to top level."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Throw::nocatch"],

Cell[BoxData[
    \(Hold[Throw[4]]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Throw::nocatch"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Throw", "MR"],
  " and ",
  StyleBox["Catch", "MR"],
  "."
}], "Text",
  CellTags->"Throw::nocatch"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Catch[
      Do[If[k < 4, Print["\<k = \>", k], Throw[k]], {k, 99}]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Throw::nocatch"],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]1\),
      SequenceForm[ "k = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[2]:=",
  CellTags->"Throw::nocatch"],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]2\),
      SequenceForm[ "k = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[2]:=",
  CellTags->"Throw::nocatch"],

Cell[BoxData[
    InterpretationBox[\("k = "\[InvisibleSpace]3\),
      SequenceForm[ "k = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[2]:=",
  CellTags->"Throw::nocatch"],

Cell[BoxData[
    \(4\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Throw::nocatch"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Trace::tracb
TraceScan::tracb
TracePrint::tracb
TraceDialog::tracb\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], "::", "\<\"tracb\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
          "of", " ", "option", " ", 
          StyleBox["opt",
            "TI"]}], " ", "->", " ", 
        RowBox[{
          StyleBox["val",
            "TI"], " ", "should", " ", "be", " ", "False"}]}], ",", " ", 
      "True", ",", " ", "All", ",", 
      " ", \(or\ a\ list\ of\ two\ of\ these\ \(\(symbols\)\(.\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["TraceAbove", "MR"],
  " option does not have the expected form."
}], "Notes",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],

Cell[TextData[{
  "An error occurs in this example because None is not a valid value for the \
",
  StyleBox["TraceAbove", "MR"],
  " option."
}], "Text",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Trace[{2 + 3, {5 + 7}}, 12, TraceAbove -> None]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],

Cell[BoxData[
    \(Trace::"tracb" \(\(:\)\(\ \)\) 
      "Value of option \!\(TraceAbove\) -> \!\(None\) should be False, True, \
All, or a list of two of these symbols."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
    "Trace::tracb"}],

Cell[BoxData[
    \(Trace[{2 + 3, {5 + 7}}, 12, TraceAbove \[Rule] None]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
    "Trace::tracb"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["TraceAbove", "MR"],
  " option in ",
  StyleBox["Trace", "MR"],
  "."
}], "Text",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Trace[{2 + 3, {5 + 7}}, 12, TraceAbove -> All]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                TagBox[\(5 + 7\),
                  HoldForm], ",", 
                TagBox["12",
                  HoldForm]}], "}"}], ",", 
            TagBox[\({12}\),
              HoldForm]}], "}"}], ",", 
        TagBox[\({5, {12}}\),
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
    "Trace::tracb"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Trace::tracd
TraceScan::tracd
TracePrint::tracd
TraceDialog::tracd\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], "::", "\<\"tracd\"\>"}], \(\(:\)\(\ \)\), "Value", " ", 
          "of", " ", "option", " ", 
          StyleBox["opt",
            "TI"]}], " ", "->", " ", 
        RowBox[{
          StyleBox["val",
            "TI"], " ", "should", " ", "be", " ", "False"}]}], ",", " ", 
      "True", ",", " ", \(or\ \(\(All\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the value of the ",
  StyleBox["TraceBackward", "MR"],
  " or ",
  StyleBox["TraceForward", "MR"],
  " option is not ",
  StyleBox["True", "MR"],
  ", ",
  StyleBox["False", "MR"],
  ", or ",
  StyleBox["All", "MR"],
  "."
}], "Notes",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],

Cell[TextData[{
  "An error occurs in this example because a number is not a valid value for \
the ",
  StyleBox["TraceBackward", "MR"],
  " option."
}], "Text",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Trace[3 + Cos[Pi] + Sin[Pi], 2, TraceBackward -> 2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],

Cell[BoxData[
    \(Trace::"tracd" \(\(:\)\(\ \)\) 
      "Value of option \!\(TraceBackward\) -> \!\(2\) should be False, True, \
or All."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
    "Trace::tracd"}],

Cell[BoxData[
    \(Trace[3 + Cos[\[Pi]] + Sin[\[Pi]], 2, 
      TraceBackward \[Rule] 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{
  "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
    "Trace::tracd"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid value for the ",
  StyleBox["TraceBackward", "MR"],
  " option in ",
  StyleBox["Trace", "MR"],
  "."
}], "Text",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Trace[3 + Cos[Pi] + Sin[Pi], 2, TraceBackward -> True]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        TagBox[\(3 - 1 + 0\),
          HoldForm], ",", 
        TagBox["2",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->{
  "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
    "Trace::tracd"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TraceLevel::notrc", "ObjectNameWarningMessages",
  CellTags->"TraceLevel::notrc"],

Cell[BoxData[
    \(TraceLevel::"notrc" \(\(:\)\(\ \)\) \(No\ Trace\ function\ is\ \
currently\ \(\(active\)\(.\)\)\)\)], "Message",
  CellTags->"TraceLevel::notrc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["TraceLevel", "MR"],
  " is used but tracing has not been turned on."
}], "Notes",
  CellTags->"TraceLevel::notrc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"TraceLevel::notrc"],

Cell[TextData[{
  "An error occurs in this example because the value of the ",
  StyleBox["TraceOn", "MR"],
  " option is such that tracing is never turned on during this evaluation."
}], "Text",
  CellTags->"TraceLevel::notrc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Trace[2 + \((Print["\<trace level = \>", \ TraceLevel[]]; 2)\), 
      TraceOn -> All]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"TraceLevel::notrc"],

Cell[BoxData[
    \(TraceLevel::"notrc" \(\(:\)\(\ \)\) 
      "No Trace function is currently active."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"TraceLevel::notrc"],

Cell[BoxData[
    InterpretationBox[\("trace level = "\[InvisibleSpace]0\),
      SequenceForm[ "trace level = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[1]:=",
  CellTags->"TraceLevel::notrc"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"TraceLevel::notrc"]
}, Open  ]],

Cell[TextData[{
  "This shows a value for the ",
  StyleBox["TraceOn", "MR"],
  " option that causes tracing to be turned on during this evaluation."
}], "Text",
  CellTags->"TraceLevel::notrc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Trace[2 + \((Print["\<trace level = \>", \ TraceLevel[]]; 2)\), 
      TraceOn -> _]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"TraceLevel::notrc"],

Cell[BoxData[
    InterpretationBox[\("trace level = "\[InvisibleSpace]2\),
      SequenceForm[ "trace level = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[2]:=",
  CellTags->"TraceLevel::notrc"],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            TagBox[\(Print["trace level = ", TraceLevel[]]; 2\),
              HoldForm], ",", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    TagBox[\(TraceLevel[]\),
                      HoldForm], ",", 
                    TagBox["2",
                      HoldForm]}], "}"}], ",", 
                TagBox[\(Print["trace level = ", 2]\),
                  HoldForm], ",", 
                RowBox[{"{", 
                  RowBox[{
                    TagBox[
                      RowBox[{"MakeBoxes", "[", 
                        RowBox[{
                          
                          InterpretationBox[\("trace level = "\
\[InvisibleSpace]2\),
                            SequenceForm[ "trace level = ", 2],
                            Editable->False], ",", "StandardForm"}], "]"}],
                      HoldForm], ",", 
                    TagBox[
                      RowBox[{"InterpretationBox", "[", 
                        
                        RowBox[{\(RowBox[{"\"trace level = \"", 
                              "\[InvisibleSpace]", "2"}]\), ",", 
                          
                          InterpretationBox[\("trace level = "\
\[InvisibleSpace]2\),
                            SequenceForm[ "trace level = ", 2],
                            Editable->False], 
                          ",", \(Editable \[Rule] False\)}], "]"}],
                      HoldForm]}], "}"}], ",", 
                TagBox["Null",
                  HoldForm]}], "}"}], ",", 
            TagBox["2",
              HoldForm]}], "}"}], ",", 
        TagBox[\(2 + 2\),
          HoldForm], ",", 
        TagBox["4",
          HoldForm]}], "}"}]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"TraceLevel::notrc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Unset::cxun", "ObjectNameWarningMessages",
  CellTags->"Unset::cxun"],

Cell[BoxData[
    \(Unset::"cxun" \(\(:\)\(\ \)\) \(Cannot\ unset\ \
\(\(contexts\)\(.\)\)\)\)], "Message",
  CellTags->"Unset::cxun"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Unset", "MR"],
  " is used for context assignment."
}], "Notes",
  CellTags->"Unset::cxun"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Unset::cxun"],

Cell["\<\
An error occurs in this example because the context of a symbol \
cannot be unset.\
\>", "Text",
  CellTags->"Unset::cxun"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Context[x] =. \)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Unset::cxun"],

Cell[BoxData[
    \(Unset::"cxun" \(\(:\)\(\ \)\) "Cannot unset contexts."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Unset::cxun"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Unset::cxun"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Alias::almark", "ObjectNameWarningMessages",
  CellTags->"Alias::almark"],

Cell[BoxData[
    RowBox[{\(Alias::"almark"\), \(\(:\)\(\ \)\), \(\(Source\)\(\ \
\)\(string\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(contains\ context\ \(\(mark\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"Alias::almark"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the symbol in the first argument of ",
  StyleBox["Alias", "MR"],
  " contains a backquote character (a context mark).\n\[FilledSmallSquare] ",
  StyleBox["Alias", "MR"],
  " is not documented in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and is not fully supported."
}], "Notes",
  CellTags->"Alias::almark"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Alias::almark"],

Cell[TextData[{
  "An error occurs in this example because the first argument in ",
  StyleBox["Alias", "MR"],
  " contains a backquote character."
}], "Text",
  CellTags->"Alias::almark"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Alias["\<x`y\>", \ z]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Alias::almark"],

Cell[BoxData[
    \(Alias::"almark" \(\(:\)\(\ \)\) 
      "Source string \!\(\"x`y\"\) contains context mark."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Alias::almark"],

Cell[BoxData[
    \(Alias["x`y", z]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Alias::almark"]
}, Open  ]],

Cell[TextData[{
  "This shows an intended use of ",
  StyleBox["Alias", "MR"],
  "."
}], "Text",
  CellTags->"Alias::almark"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Alias["\<y\>", \ z]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Alias::almark"],

Cell[BoxData[
    \(z\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Alias::almark"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(y\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Alias::almark"],

Cell[BoxData[
    \(z\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Alias::almark"]
}, Open  ]],

Cell["Remove the alias.", "Text",
  CellTags->"Alias::almark"],

Cell[CellGroupData[{

Cell[BoxData[
    \(UnAlias["\<y\>"]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Alias::almark"],

Cell[BoxData[
    \("y"\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Alias::almark"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["UnAlias::alspr", "ObjectNameWarningMessages",
  CellTags->"UnAlias::alspr"],

Cell[BoxData[
    RowBox[{\(UnAlias::"alspr"\), \(\(:\)\(\ \)\), \(\(No\)\(\ \)\(previous\)\
\(\ \)\(alias\)\(\ \)\(found\)\(\ \)\(for\)\(\ \)\), 
      StyleBox["expr",
        "TI"], "."}]], "Message",
  CellTags->"UnAlias::alspr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when no alias has been assigned for the \
indicated expression.\n\[FilledSmallSquare] ",
  StyleBox["Alias", "MR"],
  " and ",
  StyleBox["Unalias", "MR"],
  " are not fully supported in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"UnAlias::alspr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"UnAlias::alspr"],

Cell["\<\
An error occurs in this example unless an alias has been defined \
for this symbol.\
\>", "Text",
  CellTags->"UnAlias::alspr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(UnAlias[symtest1]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"UnAlias::alspr"],

Cell[BoxData[
    \(UnAlias::"alspr" \(\(:\)\(\ \)\) 
      "No previous alias found for \!\(symtest1\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"UnAlias::alspr"],

Cell[BoxData[
    \(UnAlias[symtest1]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"UnAlias::alspr"]
}, Open  ]],

Cell["This introduces an alias for the test symbol.", "Text",
  CellTags->"UnAlias::alspr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Alias["\<symtest1\>", symtest2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"UnAlias::alspr"],

Cell[BoxData[
    \(symtest2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"UnAlias::alspr"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(symtest1\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"UnAlias::alspr"],

Cell[BoxData[
    \(symtest2\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"UnAlias::alspr"]
}, Open  ]],

Cell["Remove the alias for the test symbol.", "Text",
  CellTags->"UnAlias::alspr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(UnAlias["\<symtest1\>"]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"UnAlias::alspr"],

Cell[BoxData[
    \("symtest1"\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"UnAlias::alspr"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(symtest1\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"UnAlias::alspr"],

Cell[BoxData[
    \(symtest1\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"UnAlias::alspr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Uninstall::unlink", "ObjectNameWarningMessages",
  CellTags->"Uninstall::unlink"],

Cell[BoxData[
    RowBox[{\(Uninstall::"unlink"\), \(\(:\)\(\ \)\), \(\(External\)\(\ \
\)\(package\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(has\ not\ been\ \(\(installed\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"Uninstall::unlink"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Uninstall", "MR"],
  " is used with a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connection that has not yet been installed."
}], "Notes",
  CellTags->"Uninstall::unlink"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Uninstall::unlink"],

Cell[TextData[{
  "An error occurs in this example unless a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connection with this name has already been installed."
}], "Text",
  CellTags->"Uninstall::unlink"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Uninstall["\<link\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Uninstall::unlink"],

Cell[BoxData[
    \(Uninstall::"unlink" \(\(:\)\(\ \)\) 
      "External package \!\(\"link\"\) has not been installed."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"Uninstall::unlink"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Unique::usym", "ObjectNameWarningMessages",
  CellTags->"Unique::usym"],

Cell[BoxData[
    RowBox[{\(Unique::"usym"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ symbol\ or\ a\ valid\ symbol\ \(\(name\)\
\(.\)\)\)\)}]], "Message",
  CellTags->"Unique::usym"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["Unique", "MR"],
  " is not a symbol, a string giving the name of a symbol, a list of symbols \
and  symbol names."
}], "Notes",
  CellTags->"Unique::usym"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Unique::usym"],

Cell["\<\
An error occurs in this example because the name of a symbol cannot \
end in a backquote character.\
\>", "Text",
  CellTags->"Unique::usym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Unique["\<c`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Unique::usym"],

Cell[BoxData[
    RowBox[{\(Unique::"usym"\), \(\(:\)\(\ \)\), \
"\<\"\\!\\(\\*FrameBox[\\\"\\\\\\\"\\\\\\\\\\\\\\\"c`\\\\\\\\\\\\\\\"\\\\\\\"\
\\\", Rule[BoxFrame, False], Rule[BoxMargins, False]]\\) is not a symbol or a \
valid symbol name.\"\>"}]], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Unique::usym"],

Cell[BoxData[
    \(Unique["c`"]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Unique::usym"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["Unique", "MR"],
  "."
}], "Text",
  CellTags->"Unique::usym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Unique["\<c`test\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Unique::usym"],

Cell[BoxData[
    \(c`test1\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Unique::usym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Unset::norep
TagUnset::norep\
\>", "ObjectNameWarningMessages",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"norep\"\>"}], \(\(:\)\(\ \)\), "Assignment", " ", 
      "on", " ", 
      StyleBox["expr",
        "TI"], " ", "for", " ", 
      StyleBox["pattern",
        "TI"], " ", "not", " ", \(\(found\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when there are no definitions associated \
with the indicated pattern.\n\[FilledSmallSquare] The notation ",
  StyleBox["pattern", "TI"],
  StyleBox["=.", "MR"],
  " can be used for ",
  StyleBox["Unset[", "MR"],
  StyleBox["pattern", "TI"],
  StyleBox["]", "MR"],
  "."
}], "Notes",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[TextData[{
  "An error occurs in this example unless there is an evaluation rule for the \
argument in ",
  StyleBox["Unset", "MR"],
  "."
}], "Text",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Unset[testsym[p_]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[BoxData[
    \(Unset::"norep" \(\(:\)\(\ \)\) 
      "Assignment on \!\(testsym\) for \!\(testsym[p_]\) not found."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"TagUnset::norep", "Unset::norep"}],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"TagUnset::norep", "Unset::norep"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Unset", "MR"],
  "."
}], "Text",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[BoxData[
    \(testsym[p_] := Cos[p]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(testsym[1]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[BoxData[
    \(Cos[1]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"TagUnset::norep", "Unset::norep"}]
}, Open  ]],

Cell[BoxData[
    \(testsym[p_] =. \)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(testsym[1]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[BoxData[
    \(testsym[1]\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->{"TagUnset::norep", "Unset::norep"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Unset::usraw
TagUnset::usraw\
\>", "ObjectNameWarningMessages",
  CellTags->{"Unset::usraw", "TagUnset::usraw"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"usraw\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "unset", " ", "raw", " ", "object", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Unset::usraw", "TagUnset::usraw"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when ",
  StyleBox["Unset", "MR"],
  " or ",
  StyleBox["TagUnset", "MR"],
  " is used with a string or a number.\n\[FilledSmallSquare] The notation ",
  StyleBox["pattern", "MR",
    FontSlant->"Italic"],
  StyleBox["=.", "MR"],
  " can be used for ",
  StyleBox["Unset[", "MR"],
  StyleBox["pattern", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  "."
}], "Notes",
  CellTags->{"Unset::usraw", "TagUnset::usraw"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Unset::usraw", "TagUnset::usraw"}],

Cell[TextData[{
  "An error occurs in this example because the argument in ",
  StyleBox["Unset", "MR"],
  " is a number."
}], "Text",
  CellTags->{"Unset::usraw", "TagUnset::usraw"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(5 =. \)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Unset::usraw", "TagUnset::usraw"}],

Cell[BoxData[
    \(Unset::"usraw" \(\(:\)\(\ \)\) 
      "Cannot unset raw object \!\(5\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"TagUnset::usraw", "Unset::usraw"}],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"TagUnset::usraw", "Unset::usraw"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Unset::usrpt
TagUnset::usrpt\
\>", "ObjectNameWarningMessages",
  CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"usrpt\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "unset", " ", "raw", " ", "object", " ", 
      StyleBox["expr",
        "TI"], " ", "in", " ", "pattern", " ", 
      RowBox[{
        StyleBox["patt",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the assignment tag in ",
  StyleBox["Unset", "MR"],
  " or ",
  StyleBox["TagUnset", "MR"],
  " is a number or a string."
}], "Notes",
  CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],

Cell["\<\
An error occurs in this example because the assignment tag in the \
argument pattern is a number.\
\>", "Text",
  CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Verbatim[3] =. \)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],

Cell[BoxData[
    \(Unset::"usrpt" \(\(:\)\(\ \)\) 
      "Cannot unset raw object \!\(3\) in pattern \!\(Verbatim[3]\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"TagUnset::usrpt", "Unset::usrpt"}],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"TagUnset::usrpt", "Unset::usrpt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::altno", "ObjectNameWarningMessages",
  CellTags->"General::altno"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"altno\"\>"}], \(\(:\)\(\ \)\), "Use", " ", 
      "multiple", " ", "sets", " ", "instead", " ", "of", " ", "Alternatives",
       " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::altno"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the tag for an assignment appears \
within an ",
  StyleBox["Alternatives", "MR"],
  " pattern.\n\[FilledSmallSquare] Assignments for tags within ",
  StyleBox["Alternatives", "MR"],
  " are not supported.  The same effect can be achieved using separate \
assignments.\n\[FilledSmallSquare] The notation ",
  StyleBox["p1", "MR",
    FontSlant->"Italic"],
  StyleBox["|", "MR"],
  StyleBox["p2", "MR",
    FontSlant->"Italic"],
  StyleBox["|", "MR"],
  StyleBox["p3", "MR",
    FontSlant->"Italic"],
  " is equivalent to ",
  StyleBox["Alternatives[", "MR"],
  StyleBox["p1", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["p2", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["p3", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  "."
}], "Notes",
  CellTags->"General::altno"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::altno"],

Cell[TextData[{
  "An error occurs in this example because the assignment tags occur within \
an ",
  StyleBox["Alternatives", "MR"],
  " pattern on the left-hand side of the assignment.  When this message is \
generated, the assignment is not made."
}], "Text",
  CellTags->"General::altno"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((f1 | f2)\)[0] = 0\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::altno"],

Cell[BoxData[
    \(Set::"altno" \(\(:\)\(\ \)\) 
      "Use multiple sets instead of Alternatives in \!\(\(\((f1 | \
f2)\)\)[0]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::altno"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::altno"]
}, Open  ]],

Cell["\<\
Rules for these symbols can be introduced using separate \
assignments.\
\>", "Text",
  CellTags->"General::altno"],

Cell[CellGroupData[{

Cell[BoxData[
    \(f1[0] = 0; f2[0] = 0\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::altno"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::altno"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \({f1[0], f2[0]}\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::altno"],

Cell[BoxData[
    \({0, 0}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::altno"]
}, Open  ]],

Cell["Clear the rules.", "Text",
  CellTags->"General::altno"],

Cell[BoxData[
    \(f1[0] =. ; f2[0] =. \)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::altno"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::bebal", "ObjectNameWarningMessages",
  CellTags->"General::bebal"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"bebal\"\>"}], \(\(:\)\(\ \)\), "Unterminated", 
      " ", "uses", " ", "of", " ", "BeginPackage", " ", "or", " ", "Begin", 
      " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::bebal"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a file loaded using ",
  StyleBox["Get", "MR"],
  " includes ",
  StyleBox["BeginPackage", "MR"],
  " without a corresponding ",
  StyleBox["EndPackage", "MR"],
  " or ",
  StyleBox["Begin", "MR"],
  " without a corresponding ",
  StyleBox["End", "MR"],
  ".\n\[FilledSmallSquare] This message can also be generated by functions \
such as ",
  StyleBox["Needs", "MR"],
  " and ",
  StyleBox["BeginPackage", "MR"],
  " that use ",
  StyleBox["Get", "MR"],
  " to load files.\n\[FilledSmallSquare] This message is a warning about an \
unexpected use of ",
  StyleBox["BeginPackage", "MR"],
  " or ",
  StyleBox["Begin", "MR"],
  ". This message does not necessarily indicate an error."
}], "Notes",
  CellTags->"General::bebal"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::bebal"],

Cell[TextData[{
  "An error occurs in this example because the example package includes ",
  StyleBox["Begin", "MR"],
  " without a corresponding ",
  StyleBox["End", "MR"],
  "."
}], "Text",
  CellTags->"General::bebal"],

Cell[BoxData[
    \(Write["\<TESTFILE\>", 
      OutputForm["\<Begin[\"`private`\"]\>"]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::bebal"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Close["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::bebal"],

Cell[BoxData[
    \("TESTFILE"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::bebal"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Get["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::bebal"],

Cell[BoxData[
    \(Get::"bebal" \(\(:\)\(\ \)\) 
      "Unterminated uses of BeginPackage or Begin in \!\(<< \
\"TESTFILE\"\)."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::bebal"],

Cell[BoxData[
    \("Global`private`"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::bebal"]
}, Open  ]],

Cell[TextData[{
  "Evaluate ",
  StyleBox["End[]", "MR"],
  " to restore the original context."
}], "Text",
  CellTags->"General::bebal"],

Cell[CellGroupData[{

Cell[BoxData[
    \(End[]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::bebal"],

Cell[BoxData[
    \("Global`private`"\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::bebal"]
}, Open  ]],

Cell["Remove the example package.", "Text",
  CellTags->"General::bebal"],

Cell[BoxData[
    \(DeleteFile["\<TESTFILE\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"General::bebal"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::cxls", "ObjectNameWarningMessages",
  CellTags->"General::cxls"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"cxls\"\>"}], \(\(:\)\(\ \)\), 
      RowBox[{\(Context\ or\ non\), "-", 
        RowBox[{
        "empty", " ", "list", " ", "of", " ", "contexts", " ", "expected", 
          " ", "at", " ", "position", " ", 
          StyleBox["n",
            "TI"], " ", "in", " ", 
          RowBox[{
            StyleBox["expr",
              "TI"], "."}]}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::cxls"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is generated by ",
  StyleBox["BeginPackage", "MR"],
  " if the second argument is not a context specification or a list of \
context specifications.\n\[FilledSmallSquare] A valid context specification \
is a string that ends in a backquote character and that does not contain any \
operator characters (spaces, underscores, arithmetic operators, etc.)."
}], "Notes",
  CellTags->"General::cxls"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::cxls"],

Cell["\<\
This input will generate a message because the string in the second \
argument does not end in a backquote character, so the string is not a valid \
context specification.\
\>", "Text",
  CellTags->"General::cxls"],

Cell[CellGroupData[{

Cell[BoxData[
    \(BeginPackage["\<NewPackage`\>", \ "\<NeededPackage\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::cxls"],

Cell[BoxData[
    \(BeginPackage::"cxls" \(\(:\)\(\ \)\) 
      "Context or non-empty list of contexts expected at position \!\(2\) in \
\!\(BeginPackage[\(\(\"NewPackage`\", \"NeededPackage\"\)\)]\)."\)], "Message",\

  CellLabel->"From In[1]:=",
  CellTags->"General::cxls"],

Cell[BoxData[
    \(BeginPackage["NewPackage`", "NeededPackage"]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::cxls"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::cxt", "ObjectNameWarningMessages",
  CellTags->"General::cxt"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"cxt\"\>"}], \(\(:\)\(\ \)\), "Context", " ", 
      RowBox[{"(", 
        RowBox[{"string", " ", "ending", " ", "in", " ", 
          StyleBox["char",
            "TI"]}], ")"}], " ", "expected", " ", "at", " ", "position", " ", 
      
      StyleBox["n",
        "TI"], " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::cxt"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression is not \
a valid context specification.
\[FilledSmallSquare] A valid context specification is a string that ends in a \
backquote character, starts with a character that is not a number, and does \
not contain any operator characters.\
\>", "Notes",
  CellTags->"General::cxt"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::cxt"],

Cell["\<\
An error occurs in this example because the argument string ends in \
a forward quote character rather than a backquote character.\
\>", "Text",
  CellTags->"General::cxt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Begin["\<package'\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::cxt"],

Cell[BoxData[
    \(Context::"quote" \(\(:\)\(\ \)\) 
      "Warning, \!\(\"package'\"\) is not a valid context. A valid context \
uses back quotes instead of forward quotes as in \!\(\"package`\"\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::cxt"],

Cell[BoxData[
    \(Begin::"cxt" \(\(:\)\(\ \)\) 
      "Context (string ending in \!\(\"`\"\)) expected at position \!\(1\) in \
\!\(Begin[\"package'\"]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::cxt"],

Cell[BoxData[
    \(Begin["package'"]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::cxt"]
}, Open  ]],

Cell["This shows a valid context specification.", "Text",
  CellTags->"General::cxt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Begin["\<package`\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::cxt"],

Cell[BoxData[
    \("package`"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::cxt"]
}, Open  ]],

Cell["Restore the original context.", "Text",
  CellTags->"General::cxt"],

Cell[CellGroupData[{

Cell[BoxData[
    \(End[]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::cxt"],

Cell[BoxData[
    \("package`"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::cxt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::mbox", "ObjectNameWarningMessages",
  CellTags->"General::mbox"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"mbox\"\>"}], \(\(:\)\(\ \)\), \(MatchBox\ cannot\ occur\ \
in\ transformation\ rule\ \(\(source\)\(.\)\)\)}]], "Message",
  CellTags->"General::mbox"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated if the special symbol ",
  StyleBox["MatchBox", "MR"],
  " is used in a rule.\n\[FilledSmallSquare] ",
  StyleBox["MatchBox", "MR"],
  " is in a private context, so it is unlikely that this symbol would come up \
by accident."
}], "Notes",
  CellTags->"General::mbox"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::newsym", "ObjectNameWarningMessages",
  CellTags->"General::newsym"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"newsym\"\>"}], \(\(:\)\(\ \)\), "Symbol", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", \(\(new\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::newsym"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a new symbol is created.\n\
\[FilledSmallSquare] This message is off by default and so is normally seen \
only if it is turned on using ",
  StyleBox["On[General::newsym]", "MR"],
  "."
}], "Notes",
  CellTags->"General::newsym"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::newsym"],

Cell["This shows a typical use of this message.", "Text",
  CellTags->"General::newsym"],

Cell[BoxData[
    \(On[General::newsym]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::newsym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NewVariable\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::newsym"],

Cell[BoxData[
    \(General::"newsym" \(\(:\)\(\ \)\) 
      "Symbol \!\(NewVariable\) is new."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::newsym"],

Cell[BoxData[
    \(NewVariable\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::newsym"]
}, Open  ]],

Cell[BoxData[
    \(Off[General::newsym]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::newsym"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nosym", "ObjectNameWarningMessages",
  CellTags->"General::nosym"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nosym\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "does", " ", "not", " ", "contain", " ", "a", " ", 
        "symbol", " ", "to", " ", "which", " ", "to", " ", "attach", " ", "a",
         " ", \(\(rule\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nosym"],

Cell["\<\
\[FilledSmallSquare] Generated by an assignment that does not \
contain a valid assignment tag.
\[FilledSmallSquare] The assignment tag is the symbol on the left-hand side \
of the assignment with which the rule created by the assignment will be \
associated.\
\>", "Notes",
  CellTags->"General::nosym"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::nosym"],

Cell["\<\
An error occurs in this example because attributes cannot be \
attached to a pattern expression.\
\>", "Text",
  CellTags->"General::nosym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Attributes[p_] = Protected\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::nosym"],

Cell[BoxData[
    \(Attributes::"nosym" \(\(:\)\(\ \)\) 
      "\!\(Attributes[p_]\) does not contain a symbol to which to attach a \
rule."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::nosym"],

Cell[BoxData[
    \(Protected\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::nosym"]
}, Open  ]],

Cell["This shows a valid assignment to the attributes of a symbol.", "Text",
  CellTags->"General::nosym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Attributes[sym] = Protected\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::nosym"],

Cell[BoxData[
    \(Protected\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::nosym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::noval", "ObjectNameWarningMessages",
  CellTags->"General::noval"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"noval\"\>"}], \(\(:\)\(\ \)\), "Symbol", " ", 
      StyleBox["sym",
        "TI"], " ", "in", " ", "part", " ", "assignment", " ", "does", " ", 
      "not", " ", "have", " ", "an", " ", "immediate", 
      " ", \(\(value\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::noval"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempted assignment to part of the \
value of a symbol when the symbol does not have an immediate value.\n\
\[FilledSmallSquare] It is necessary to initialize the value of a symbol \
before making assignments to parts of the value of that symbol.\n\
\[FilledSmallSquare] Immediate values can be assigned using ",
  StyleBox["Set", "MR"],
  " (",
  StyleBox["lhs", "TI"],
  StyleBox["=", "MR"],
  StyleBox["rhs", "TI"],
  "). Delayed values can be assigned using ",
  StyleBox["SetDelayed", "MR"],
  " (",
  StyleBox["lhs", "TI"],
  StyleBox[":=", "MR"],
  StyleBox["rhs", "TI"],
  ")."
}], "Notes",
  CellTags->"General::noval"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::noval"],

Cell[TextData[{
  "If the symbol ",
  StyleBox["vector", "MR"],
  " does not have a value, this assignment to ",
  StyleBox["vector[[1]]", "MR"],
  " will generate an error, and the assignment will not be made."
}], "Text",
  CellTags->"General::noval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vector[\([1]\)] = 1\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::noval"],

Cell[BoxData[
    \(Set::"noval" \(\(:\)\(\ \)\) 
      "Symbol \!\(vector\) in part assignment does not have an immediate \
value."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::noval"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::noval"]
}, Open  ]],

Cell[TextData[{
  "A similar error will occur if the value of ",
  StyleBox["vector", "MR"],
  " is a delayed value."
}], "Text",
  CellTags->"General::noval"],

Cell[BoxData[
    \(vector := {Null, Null, Null}\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::noval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vector[\([1]\)] = 1\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::noval"],

Cell[BoxData[
    \(Set::"noval" \(\(:\)\(\ \)\) 
      "Symbol \!\(vector\) in part assignment does not have an immediate \
value."\)], "Message",
  CellLabel->"From In[3]:=",
  CellTags->"General::noval"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::noval"]
}, Open  ]],

Cell[TextData[{
  "The assignment works as intended if ",
  StyleBox["vector", "MR"],
  " has an immediate value."
}], "Text",
  CellTags->"General::noval"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vector = {Null, Null, Null}\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::noval"],

Cell[BoxData[
    \({Null, Null, Null}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::noval"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(vector[\([1]\)] = 1\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"General::noval"],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"General::noval"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(vector\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"General::noval"],

Cell[BoxData[
    \({1, Null, Null}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"General::noval"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["vector", "MR"],
  "."
}], "Text",
  CellTags->"General::noval"],

Cell[BoxData[
    \(Clear[vector]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"General::noval"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::opset", "ObjectNameWarningMessages",
  CellTags->"General::opset"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"opset\"\>"}], \(\(:\)\(\ \)\), "Option", " ", 
      StyleBox["opt",
        "TI"], " ", "is", " ", "not", " ", "set", " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::opset"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated option has not \
been assigned a value.
\[FilledSmallSquare] Many standard functions require that all options have \
values.\
\>", "Notes",
  CellTags->"General::opset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::opset"],

Cell["\<\
An error occurs in this example when the options are temporarily \
removed from a built-in function.\
\>", "Text",
  CellTags->"General::opset"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Module[{opts}, \n\topts = Options[Inverse]; \n\tUnprotect[Inverse]; \n\t
      Unset[Options[Inverse]]; \n\tInverse[{{1}}]; \n\t
      Options[Inverse] = opts; \n\tProtect[Inverse]\n]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::opset"],

Cell[BoxData[
    \(Inverse::"opset" \(\(:\)\(\ \)\) 
      "Option \!\(Modulus\) is not set in \!\(Options[Inverse]\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::opset"],

Cell[BoxData[
    \({"Inverse"}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::opset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::optb", "ObjectNameWarningMessages",
  CellTags->"General::optb"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"optb\"\>"}], \(\(:\)\(\ \)\), "Optional", " ", 
      "object", " ", 
      StyleBox["expr",
        "TI"], " ", "in", " ", 
      StyleBox["pattern",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "single", 
      " ", \(\(blank\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::optb"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in an ",
  StyleBox["Optional", "MR"],
  " pattern is not an expression based on ",
  StyleBox["Blank", "MR"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["Optional[", "MR"],
  StyleBox["p", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["v", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " can also be entered using the notation ",
  StyleBox["p", "MR",
    FontSlant->"Italic"],
  StyleBox[":", "MR"],
  StyleBox["v", "MR",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::optb"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::optb"],

Cell[TextData[{
  "An error occurs in this example because the ",
  StyleBox["Optional", "MR"],
  " pattern uses ",
  StyleBox["__", "MR"],
  " (",
  StyleBox["BlankSequence", "MR"],
  ") rather than ",
  StyleBox["_", "MR"],
  " (",
  StyleBox["Blank", "MR"],
  ")."
}], "Text",
  CellTags->"General::optb"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1}, {2}, {}} /. {Optional[__, 0]} :> p\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::optb"],

Cell[BoxData[
    \(General::"optb" \(\(:\)\(\ \)\) 
      "Optional object \!\(__\) in \!\(__ : 0\) is not a single blank."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::optb"],

Cell[BoxData[
    \({{1}, {2}, {}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::optb"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid ",
  StyleBox["Optional", "MR"],
  " pattern."
}], "Text",
  CellTags->"General::optb"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1}, {2}, {}} /. {Optional[p_, 0]} :> p\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::optb"],

Cell[BoxData[
    \({1, 2, 0}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::optb"]
}, Open  ]],

Cell["This  pattern can also be entered using shorter notation.", "Text",
  CellTags->"General::optb"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{1}, {2}, {}} /. {p_:  0} :> p\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::optb"],

Cell[BoxData[
    \({1, 2, 0}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::optb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::patop", "ObjectNameWarningMessages",
  CellTags->"General::patop"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"patop\"\>"}], \(\(:\)\(\ \)\), "Pattern", " ", 
      StyleBox["expr",
        "TI"], " ", "contains", " ", "inappropriate", " ", "optional", 
      " ", \(\(object\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::patop"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a pattern based on ",
  StyleBox["Optional", "MR"],
  " appears in an invalid location within another pattern expression.\n\
\[FilledSmallSquare] A pattern based on ",
  StyleBox["Optional", "MR"],
  " cannot be used as the first argument in ",
  StyleBox["PatternTest", "MR"],
  ", ",
  StyleBox["Condition", "MR"],
  ", ",
  StyleBox["Repeated", "MR"],
  ", ",
  StyleBox["RepeatedNull", "MR"],
  ", or ",
  StyleBox["Optional", "MR"],
  ", or as the second argument in ",
  StyleBox["Pattern", "MR"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["Optional[", "MR"],
  StyleBox["p", "MR",
    FontSlant->"Italic"],
  StyleBox[", ", "MR"],
  StyleBox["v", "MR",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " can also be entered using the notation ",
  StyleBox["p", "MR",
    FontSlant->"Italic"],
  StyleBox[":", "MR"],
  StyleBox["v", "MR",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::patop"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::patop"],

Cell[TextData[{
  "An error occurs in this example because an ",
  StyleBox["Optional", "MR"],
  " pattern is used as the second argument in a ",
  StyleBox["Pattern", "MR"],
  " expression."
}], "Text",
  CellTags->"General::patop"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{3}, {4}, {}} /. {p : \((_ : 0)\)} :> p\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::patop"],

Cell[BoxData[
    \(General::"patop" \(\(:\)\(\ \)\) 
      "Pattern \!\(p : \(\((_ : 0)\)\)\) contains inappropriate optional \
object."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::patop"],

Cell[BoxData[
    \({{3}, {4}, {}}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::patop"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of an ",
  StyleBox["Optional", "MR"],
  " pattern."
}], "Text",
  CellTags->"General::patop"],

Cell[CellGroupData[{

Cell[BoxData[
    \({{3}, {4}, {}} /. {\((p_:  0)\)} :> p\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::patop"],

Cell[BoxData[
    \({3, 4, 0}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::patop"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::rvalue", "ObjectNameWarningMessages",
  CellTags->"General::rvalue"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"rvalue\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "not", " ", "a", " ", "variable", " ", 
          "with", " ", "a", " ", "value"}]}], ",", 
      " ", \(so\ its\ value\ cannot\ be\ \(\(changed\)\(.\)\)\)}]], "Message",\

  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::rvalue"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["Increment", "MR"],
  " and related functions has not been assigned a value.\n\
\[FilledSmallSquare] Functions such as ",
  StyleBox["Increment", "MR"],
  " assume that the operand evaluates to something other than itself."
}], "Notes",
  CellTags->"General::rvalue"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::rvalue"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Increment", "MR"],
  " is used with a variable that does not have a value."
}], "Text",
  CellTags->"General::rvalue"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{var}, \(var++\); Print["\<result = \>", \ var]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::rvalue"],

Cell[BoxData[
    \(Increment::"rvalue" \(\(:\)\(\ \)\) 
      "\!\(var\) is not a variable with a value, so its value cannot be \
changed."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::rvalue"],

Cell[BoxData[
    InterpretationBox[\("result = "\[InvisibleSpace]var\),
      SequenceForm[ "result = ", var],
      Editable->False]], "Print",
  CellLabel->"From In[1]:=",
  CellTags->"General::rvalue"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of ",
  StyleBox["Increment", "MR"],
  "."
}], "Text",
  CellTags->"General::rvalue"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{var = 5}, \(var++\); Print["\<result = \>", var]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::rvalue"],

Cell[BoxData[
    InterpretationBox[\("result = "\[InvisibleSpace]6\),
      SequenceForm[ "result = ", 6],
      Editable->False]], "Print",
  CellLabel->"From In[2]:=",
  CellTags->"General::rvalue"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::setp", "ObjectNameWarningMessages",
  CellTags->"General::setp"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"setp\"\>"}], \(\(:\)\(\ \)\), "Part", " ", 
      "assignment", " ", "to", " ", 
      StyleBox["expr",
        "TI"], " ", "could", " ", "not", " ", "be", 
      " ", \(\(made\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::setp"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an invalid use of ",
  StyleBox["Part", "MR"],
  " on the left-hand side of an assignment."
}], "Notes",
  CellTags->"General::setp"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::setp"],

Cell["\<\
An error occurs in this example because this is not an assignment \
to part of the value of a symbol.\
\>", "Text",
  CellTags->"General::setp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[] = 0\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::setp"],

Cell[BoxData[
    \(Set::"setp" \(\(:\)\(\ \)\) 
      "Part assignment to \!\(Part[]\) could not be made."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::setp"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::setp"]
}, Open  ]],

Cell["This shows a valid part assignment.", "Text",
  CellTags->"General::setp"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{x = {0, 0, 0}}, Part[x, 2] = 11; x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::setp"],

Cell[BoxData[
    \({0, 11, 0}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::setp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::setps", "ObjectNameWarningMessages",
  CellTags->"General::setps"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"setps\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "in", " ", "assignment", " ", "of", " ", "part", " ", 
        "is", " ", "not", " ", "a", " ", \(\(symbol\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::setps"],

Cell["\<\
\[FilledSmallSquare] Generated when a part assignment is used for \
the value of an expression other than a symbol.
\[FilledSmallSquare] Part assignments are implemented only for parts of the \
value of a symbol.\
\>", "Notes",
  CellTags->"General::setps"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::setps"],

Cell["\<\
An error occurs in this example because the part assignment is for \
the value of a normal expression rather than for the value of a symbol.\
\>", \
"Text",
  CellTags->"General::setps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{x}, x[1] = {0, 0, 0}; \(x[1]\)[\([2]\)] = 11; x[1]]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::setps"],

Cell[BoxData[
    \(Set::"setps" \(\(:\)\(\ \)\) 
      "\!\(x[1]\) in assignment of part is not a symbol."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::setps"],

Cell[BoxData[
    \({0, 0, 0}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::setps"]
}, Open  ]],

Cell["This shows a valid part assignment.", "Text",
  CellTags->"General::setps"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Block[{x1}, x1 = {0, 0, 0}; x1[\([2]\)] = 11; x1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::setps"],

Cell[BoxData[
    \({0, 11, 0}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::setps"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::shdw", "ObjectNameWarningMessages",
  CellTags->"General::shdw"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"shdw\"\>"}], \(\(:\)\(\ \)\), "Symbol", " ", 
        StyleBox["sym",
          "TI"], " ", "appears", " ", "in", " ", "multiple", " ", "contexts", 
        " ", 
        StyleBox["expr",
          "TI"]}], ";", " ", 
      RowBox[{"definitions", " ", "in", " ", "context", " ", 
        StyleBox["c",
          "TI"], " ", "may", " ", "shadow", " ", "or", " ", "be", " ", 
        "shadowed", " ", "by", " ", "other", 
        " ", \(\(definitions\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::shdw"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when symbols with the same name occur in \
more than one context and both contexts are in the context search path.\n\
\[FilledSmallSquare] This message occurs most often when loading packages \
that introduce symbols with the same names as symbols that have already been \
entered or that have been introduced by other packages.\n\[FilledSmallSquare] \
If symbols with the same name exist in more than one context, the name will \
refer to the symbol that occurs first in the context search path.  Any symbol \
can be accessed by entering the full context name of the symbol.\n\
\[FilledSmallSquare] Unwanted symbols can be removed using ",
  StyleBox["Remove", "MR"],
  ".\n\[FilledSmallSquare] The contexts in the context search path are \
determined by ",
  StyleBox["$Context", "MR"],
  " and ",
  StyleBox["$ContextPath", "MR"],
  "."
}], "Notes",
  CellTags->"General::shdw"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::shdw"],

Cell[TextData[{
  "An error occurs in this example because the symbol ",
  StyleBox["NewFunction", "MR"],
  " is created in more than one context."
}], "Text",
  CellTags->"General::shdw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NewFunction[2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::shdw"],

Cell[BoxData[
    \(NewFunction[2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::shdw"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Write["\<TEST.m\>", 
      OutputForm["\<BeginPackage[\"TEST`\"]\>"]]\), "\n", 
    \(Write["\<TEST.m\>", 
      OutputForm["\<NewFunction[p_]:=p Cos[p]\>"]]\), "\n", 
    \(Write["\<TEST.m\>", OutputForm["\<EndPackage[]\>"]]\), "\n", 
    \(Close["\<TEST.m\>"]\)}], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::shdw"],

Cell[BoxData[
    \("TEST.m"\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"General::shdw"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Get["\<TEST`\>"]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"General::shdw"],

Cell[BoxData[
    \(NewFunction::"shdw" \(\(:\)\(\ \)\) 
      "Symbol \!\(\"NewFunction\"\) appears in multiple contexts \!\({\"TEST`\
\", \"Global`\"}\); definitions in context \!\(\"TEST`\"\) may shadow or be \
shadowed by other definitions."\)], "Message",
  CellLabel->"From In[6]:=",
  CellTags->"General::shdw"],

Cell[BoxData[
    \(p::"shdw" \(\(:\)\(\ \)\) 
      "Symbol \!\(\"p\"\) appears in multiple contexts \!\({\"TEST`\", \
\"Global`\"}\); definitions in context \!\(\"TEST`\"\) may shadow or be \
shadowed by other definitions."\)], "Message",
  CellLabel->"From In[6]:=",
  CellTags->"General::shdw"]
}, Open  ]],

Cell["\<\
The symbol from the package context can be accessed by including \
the context with the name of the symbol.\
\>", "Text",
  CellTags->"General::shdw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TEST`NewFunction[2]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"General::shdw"],

Cell[BoxData[
    \(2\ Cos[2]\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"General::shdw"]
}, Open  ]],

Cell["\<\
Without the context name, the symbol from the package and the \
definition from the package will not be used.\
\>", "Text",
  CellTags->"General::shdw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NewFunction[2]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"General::shdw"],

Cell[BoxData[
    \(NewFunction[2]\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"General::shdw"]
}, Open  ]],

Cell[TextData[{
  "The symbol from ",
  StyleBox["Global`", "MR"],
  " context can be removed using ",
  StyleBox["Remove", "MR"],
  "."
}], "Text",
  CellTags->"General::shdw"],

Cell[BoxData[
    \(Remove[NewFunction]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"General::shdw"],

Cell["\<\
Now the symbol from the package can be accessed without including \
the context name.\
\>", "Text",
  CellTags->"General::shdw"],

Cell[CellGroupData[{

Cell[BoxData[
    \(NewFunction[2]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"General::shdw"],

Cell[BoxData[
    \(2\ Cos[2]\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"General::shdw"]
}, Open  ]],

Cell["Remove the test file.", "Text",
  CellTags->"General::shdw"],

Cell[BoxData[
    \(DeleteFile["\<TEST.m\>"]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"General::shdw"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::tag", "ObjectNameWarningMessages",
  CellTags->"General::tag"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"tag\"\>"}], \(\(:\)\(\ \)\), "Rule", " ", "for", 
      " ", 
      StyleBox["vals",
        "TI"], " ", "of", " ", 
      StyleBox["expr",
        "TI"], " ", "can", " ", "only", " ", "be", " ", "attached", " ", "to",
       " ", 
      RowBox[{
        StyleBox["sym",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::tag"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a tagged assignment is used \
incorrectly with functions that select assignment tags in a special way.\n\
\[FilledSmallSquare] This message can occur in assignments involving ",
  StyleBox["Attributes", "MR"],
  ", ",
  StyleBox["Context", "MR"],
  ", ",
  StyleBox["Default", "MR"],
  ", ",
  StyleBox["Format", "MR"],
  ", ",
  StyleBox["MessageName", "MR"],
  ", and ",
  StyleBox["N", "MR"],
  ".\n\[FilledSmallSquare] A tagged assignment is an assignment based on ",
  StyleBox["TagSet", "MR"],
  " or ",
  StyleBox["TagSetDelayed", "MR"],
  " where the tag is specified explicitly in the assignment."
}], "Notes",
  CellTags->"General::tag"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::tag"],

Cell[TextData[{
  "An error occurs in this example because the tag for assignments to ",
  StyleBox["Attributes[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " is taken from ",
  StyleBox["expr", "TI"],
  "."
}], "Text",
  CellTags->"General::tag"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Attributes /: Attributes[testfunction] = Listable\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::tag"],

Cell[BoxData[
    \(Attributes::"tag" \(\(:\)\(\ \)\) 
      "Rule for \!\(Attributes\) of \!\(Attributes[testfunction]\) can only \
be attached to \!\(testfunction\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::tag"],

Cell[BoxData[
    \(Listable\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::tag"]
}, Open  ]],

Cell["\<\
This shows a valid assignment for the attributes of a symbol.\
\>", \
"Text",
  CellTags->"General::tag"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Attributes[testfunction] = Listable\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::tag"],

Cell[BoxData[
    \(Listable\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::tag"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::trace", "ObjectNameWarningMessages",
  CellTags->"General::trace"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"trace\"\>"}], ":", " ", 
      RowBox[{
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "--"}], ">", " ", 
        RowBox[{
          StyleBox["result",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::trace"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is used for displaying information when \
evaluation is traced using ",
  StyleBox["On", "MR"],
  " and ",
  StyleBox["Off", "MR"],
  ".\n\[FilledSmallSquare] This is not an error or warning message."
}], "Notes",
  CellTags->"General::trace"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::trace"],

Cell["This shows a typical use of this message.", "Text",
  CellTags->"General::trace"],

Cell[BoxData[
    \(On[Dot]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::trace"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((1 + {{2, 3}, {1, \(-1\)}} . {0, 1})\) . {10, 20}\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::trace"],

Cell[BoxData[
    \(Dot::"trace" \(\(:\)\(\ \)\) 
      "\!\(\(\({\(\({2, 3}\)\), \(\({1, \(\(-1\)\)}\)\)}\)\) . \(\({0, 1}\)\)\
\) --> \!\({3, \(\(-1\)\)}\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::trace"],

Cell[BoxData[
    \(Dot::"trace" \(\(:\)\(\ \)\) 
      "\!\(\(\((1 + \(\(\(\({\(\({2, 3}\)\), \(\({1, \(\(-1\)\)}\)\)}\)\) . \
\(\({0, 1}\)\)\)\))\)\) . \(\({10, 20}\)\)\) --> \!\(\(\({4, 0}\)\) . \
\(\({10, 20}\)\)\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::trace"],

Cell[BoxData[
    \(Dot::"trace" \(\(:\)\(\ \)\) 
      "\!\(\(\({4, 0}\)\) . \(\({10, 20}\)\)\) --> \!\(40\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::trace"],

Cell[BoxData[
    \(40\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::trace"]
}, Open  ]],

Cell[TextData[{
  "Turn off tracing for ",
  StyleBox["Dot", "MR"],
  "."
}], "Text",
  CellTags->"General::trace"],

Cell[BoxData[
    \(Off[Dot]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::trace"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::write", "ObjectNameWarningMessages",
  CellTags->"General::write"],

Cell[BoxData[
    RowBox[{
      StyleBox["function",
        "TI"], "::", 
      RowBox[{"\<\"write\"\>", ":", " ", 
        RowBox[{\(\(Tag\)\(\ \)\), 
          StyleBox["sym",
            "TI"], \(\(\ \)\(in\)\(\ \)\), 
          StyleBox["expr",
            "TI"], " ", "is", " ", \(\(Protected\)\(.\)\)}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::write"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to assign a value to a \
protected symbol.\n\[FilledSmallSquare] A symbol ",
  StyleBox["s", "TI"],
  " is protected if ",
  StyleBox["Attributes[", "MR"],
  StyleBox["s", "TI"],
  StyleBox["]", "MR"],
  " includes ",
  StyleBox["Protected", "MR"],
  ".\n\[FilledSmallSquare] An assignment tag is the symbol to which an \
assignment attaches an evaluation rule."
}], "Notes",
  CellTags->"General::write"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::write"],

Cell[TextData[{
  "This assignment will fail because the expression ",
  StyleBox["3 x", "MR"],
  " on the left-hand side of the assignment is a product (an expression with \
a head of ",
  StyleBox["Times", "MR"],
  ").  The symbol ",
  StyleBox["Times", "MR"],
  " is protected."
}], "Text",
  CellTags->"General::write"],

Cell[CellGroupData[{

Cell[BoxData[
    \(3\ x = \ 21\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::write"],

Cell[BoxData[
    \(Set::"write" \(\(:\)\(\ \)\) 
      "Tag \!\(Times\) in \!\(3\\ x\) is Protected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::write"],

Cell[BoxData[
    \(21\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::write"]
}, Open  ]],

Cell["\<\
The same message is generated if this assignment occurs within \
another expression.\
\>", "Text",
  CellTags->"General::write"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[3\ x = 21, x]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::write"],

Cell[BoxData[
    \(Set::"write" \(\(:\)\(\ \)\) 
      "Tag \!\(Times\) in \!\(3\\ x\) is Protected."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::write"],

Cell[BoxData[
    \(Solve::"eqf" \(\(:\)\(\ \)\) 
      "\!\(21\) is not a well-formed equation."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::write"],

Cell[BoxData[
    \(Solve[21, x]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::write"]
}, Open  ]],

Cell[TextData[{
  "Equations are entered using ",
  StyleBox["lhs", "TI"],
  StyleBox["==", "MR"],
  StyleBox["rhs", "TI"],
  " rather than ",
  StyleBox["lhs", "TI"],
  StyleBox["=", "MR"],
  StyleBox["rhs", "TI"],
  "."
}], "Text",
  CellTags->"General::write"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[3\ x == 21, x]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::write"],

Cell[BoxData[
    \({{x \[Rule] 7}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"General::write"]
}, Open  ]],

Cell[TextData[{
  "A ",
  StyleBox["function", "TI"],
  StyleBox["::write", "MR"],
  " message can be generated indirectly by any function that makes \
assignments.  In this example, the use of ",
  StyleBox["k+1", "MR"],
  " as an iterator generates an error when ",
  StyleBox["Do", "MR"],
  " tries to assign a value to that iterator."
}], "Text",
  CellTags->"General::write"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Do[Print[k], \ {k + 1, 5}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"General::write"],

Cell[BoxData[
    \(Do::"write" \(\(:\)\(\ \)\) 
      "Tag \!\(Plus\) in \!\(k + 1\) is Protected."\)], "Message",
  CellLabel->"From In[4]:=",
  CellTags->"General::write"],

Cell[BoxData[
    \(Do[Print[k], {k + 1, 5}]\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"General::write"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::wrsym", "ObjectNameWarningMessages",
  CellTags->"General::wrsym"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"wrsym\"\>"}], \(\(:\)\(\ \)\), "Symbol", " ", 
      StyleBox["sym",
        "TI"], " ", "is", " ", \(\(Protected\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::wrsym"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to assign a value to a \
protected symbol.\n\[FilledSmallSquare] A symbol is protected if the symbol \
has the ",
  StyleBox["Protected", "MR"],
  " attribute."
}], "Notes",
  CellTags->"General::wrsym"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::wrsym"],

Cell[TextData[{
  "You cannot assign a value to the symbol ",
  StyleBox["List", "MR"],
  "."
}], "Text",
  CellTags->"General::wrsym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(List = Identity\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::wrsym"],

Cell[BoxData[
    \(Set::"wrsym" \(\(:\)\(\ \)\) 
      "Symbol \!\(List\) is Protected."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::wrsym"],

Cell[BoxData[
    \(Identity\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::wrsym"]
}, Open  ]],

Cell[TextData[{
  "One of the attributes of ",
  StyleBox["List", "MR"],
  " is the ",
  StyleBox["Protected", "MR"],
  " attribute."
}], "Text",
  CellTags->"General::wrsym"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Attributes[List]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::wrsym"],

Cell[BoxData[
    \({Locked, Protected}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::wrsym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::shdwcor", "ObjectNameWarningMessages",
  CellTags->"General::shdwcor"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"shdwcor\"\>"}], \(\(:\)\(\ \)\), "Symbol", " ", 
      StyleBox["sym",
        "TI"], " ", "defined", " ", "in", " ", 
      StyleBox["c1",
        "TI"], " ", "already", " ", "exists", " ", "in", " ", 
      RowBox[{
        StyleBox["c2",
          "TI"], ".", " ", "Select"}], " ", "the", " ", "version", " ", "you",
       " ", "want", " ", "to", " ", 
      RowBox[{"use", ":", " ", 
        RowBox[{
          StyleBox["sel",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::shdwcor"],

Cell["\<\
\[FilledSmallSquare] Generated as part of an internal feature for \
interactive correction of shadowing errors.
\[FilledSmallSquare] Interactive correction of shadowing error is not yet \
fully implemented.\
\>", "Notes",
  CellTags->"General::shdwcor"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NestWhile::nres
NestWhileList::nres\
\>", "ObjectNameWarningMessages",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nres\"\>"}], \(\(:\)\(\ \)\), "Insufficient", " ",
       "results", " ", "generated", " ", "to", " ", "return", " ", "the", " ",
       
      StyleBox["n",
        "TI"], " ", "term", " ", "in", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the sixth argument in ",
  StyleBox["NestWhile", "MR"],
  " or ",
  StyleBox["NestWhileList", "MR"],
  " specifies elements that were not computed."
}], "Notes",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],

Cell["\<\
An error occurs in this example because the number of elements that \
are computed is less than the position specified by the sixth argument.\
\>", \
"Text",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestWhileList[\((# + 1)\) &, 5, \((# < 10)\) &, 1, 
      5, \(-10\)]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],

Cell[BoxData[
    \(NestWhileList::"nres" \(\(:\)\(\ \)\) 
      "Insufficient results generated to return the \!\(-10\) term in \
\!\(NestWhileList[\(\(\(\(\(\(#1 + 1\)\) &\)\), 5, \(\(\(\(#1 < 10\)\) &\)\), \
1, 5, \(\(-10\)\)\)\)]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NestWhileList::nres", "NestWhile::nres"}],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NestWhileList::nres", "NestWhile::nres"}]
}, Open  ]],

Cell[TextData[{
  "This shows a valid use of the sixth argument in ",
  StyleBox["NestWhileList", "MR"],
  "."
}], "Text",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestWhileList[\((# + 1)\) &, 5, \((# < 10)\) &, 1, 
      5, \(-4\)]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],

Cell[BoxData[
    \({5, 6}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"NestWhileList::nres", "NestWhile::nres"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
NestWhile::nwargs
NestWhileList::nwargs\
\>", "ObjectNameWarningMessages",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"nwargs\"\>"}], \(\(:\)\(\ \)\), "Argument", " ",
         
        StyleBox["n",
          "TI"], " ", "in", " ", 
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "of", " ", "the", " ", "form", 
        " ", "n"}], ",", " ", \({m, \ n}\), ",", " ", \({n, \ Infinity}\), 
      ",", " ", \(or\ All\), ",", 
      " ", \(where\ m\ and\ n\ are\ non - negative\ machine - 
        size\ \(\(integers\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the fourth argument in ",
  StyleBox["NestWhile", "MR"],
  " or ",
  StyleBox["NestWhileList", "MR"],
  " does not match any of the forms described in the message."
}], "Notes",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],

Cell[TextData[{
  "An error occurs in this example because the fourth argument in ",
  StyleBox["NestWhileList", "MR"],
  " does not match any of the expected forms."
}], "Text",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestWhileList[\((# + 1)\) &, 3, 5, \((# < 10)\) &]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],

Cell[BoxData[
    \(NestWhileList::"nwargs" \(\(:\)\(\ \)\) 
      "Argument \!\(4\) in \!\(NestWhileList[\(\(\(\(\(\(#1 + 1\)\) &\)\), 3, \
5, \(\(\(\(#1 < 10\)\) &\)\)\)\)]\) is not of the form n, {m, n}, {n, \
Infinity}, or All, where m and n are non-negative machine-size integers."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->{"NestWhileList::nwargs", "NestWhile::nwargs"}],

Cell[BoxData[
    \(NestWhileList[#1 + 1 &, 3, 5, #1 < 10 &]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"NestWhileList::nwargs", "NestWhile::nwargs"}]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["NestWhileList", "MR"],
  "."
}], "Text",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(NestWhileList[\((# + 1)\) &, 3, \((# < 10)\) &, 5]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],

Cell[BoxData[
    \({3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"NestWhileList::nwargs", "NestWhile::nwargs"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Pattern::patvar", "ObjectNameWarningMessages",
  CellTags->"Pattern::patvar"],

Cell[BoxData[
    \(Pattern::"patvar" \(\(:\)\(\ \)\) 
      "First element in pattern `1` is not a valid pattern name."\)], \
"Message",
  CellLabel->"From In[61]:=",
  CellTags->"Pattern::patvar"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in a ",
  StyleBox["Pattern", "MR"],
  " expression cannot be used as the name of a pattern.\n\[FilledSmallSquare] \
Most expressions other than numbers can be used as names of patterns."
}], "Notes",
  CellTags->"Pattern::patvar"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Pattern::patvar"],

Cell["\<\
An error occurs in this example because a number cannot be used as \
the name of a pattern.\
\>", "Text",
  CellTags->"Pattern::patvar"],

Cell[CellGroupData[{

Cell[BoxData[
    \({1, 2, 3} /. {_, Pattern[99, _], _} \[Rule] {99}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Pattern::patvar"],

Cell[BoxData[
    \(Pattern::"patvar" \(\(:\)\(\ \)\) 
      "First element in pattern \!\(Pattern[\(\(99, _\)\)]\) is not a valid \
pattern name."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Pattern::patvar"],

Cell[BoxData[
    \({1, 2, 3}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Pattern::patvar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Set::patset", "ObjectNameWarningMessages",
  CellTags->"Set::patset"],

Cell[BoxData[
    \(Set::"patset" \(\(:\)\(\ \)\) 
      "Warning: `1` in assignment `2` represents a named pattern; use \
symbol::tag to represent a message name."\)], "Message",
  CellLabel->"From In[61]:=",
  CellTags->"Set::patset"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to assign a value to a named \
pattern.\n\[FilledSmallSquare] Named patterns are typically entered using the \
notation ",
  StyleBox["name", "TI"],
  StyleBox["_", "MR"],
  " or ",
  StyleBox["name", "TI"],
  StyleBox[":", "MR"],
  StyleBox["patt", "TI"],
  ".\n\[FilledSmallSquare] Operator characters, such as \
\[OpenCurlyDoubleQuote]",
  StyleBox["_", "MR"],
  "\[CloseCurlyDoubleQuote] and \[OpenCurlyDoubleQuote]",
  StyleBox[":", "MR"],
  "\[CloseCurlyDoubleQuote], cannot be used in the names of variables.\n\
\[FilledSmallSquare] See the ",
  StyleBox["Utilities`Notation`", "MR"],
  " package for information on using subscripts or other typeset structures \
in the names of variables."
}], "Notes",
  CellTags->"Set::patset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Set::patset"],

Cell[TextData[{
  "A warning message is generated by this input because this use of a pattern \
on the left side of an assignment is very unusual. This assignment introduces \
a rule that will apply to any expression with a head of ",
  StyleBox["n", "MR"],
  "."
}], "Text",
  CellTags->"Set::patset"],

Cell[CellGroupData[{

Cell[BoxData[
    \(p_n = 5\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Set::patset"],

Cell[BoxData[
    \(Set::"patset" \(\(:\)\(\ \)\) 
      "Warning: \!\(p_n\) in assignment \!\(p_n = 5\) represents a named \
pattern; use symbol::tag to represent a message name."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Set::patset"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Set::patset"]
}, Open  ]],

Cell["This shows one of the effects of the assignment above.", "Text",
  CellTags->"Set::patset"],

Cell[CellGroupData[{

Cell[BoxData[
    \(n[1, 2, 3]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Set::patset"],

Cell[BoxData[
    \(5\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Set::patset"]
}, Open  ]],

Cell[TextData[{
  "Clear the definition attached to ",
  StyleBox["n", "MR"],
  "."
}], "Text",
  CellTags->"Set::patset"],

Cell[BoxData[
    \(Clear[n]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Set::patset"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Switch::argct", "ObjectNameWarningMessages",
  CellTags->"Switch::argct"],

Cell[BoxData[
    \(Switch::"argct" \(\(:\)\(\ \)\) 
      "Switch called with `2` arguments. Switch must be called with an odd \
number of arguments."\)], "Message",
  CellLabel->"From In[69]:=",
  CellTags->"Switch::argct"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the number of arguments in ",
  StyleBox["Switch", "MR"],
  " is an even number."
}], "Notes",
  CellTags->"Switch::argct"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"Switch::argct"],

Cell[TextData[{
  "An error occurs in this example because ",
  StyleBox["Switch", "MR"],
  " is used with an even number of arguments."
}], "Text",
  CellTags->"Switch::argct"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Switch[Pi, _Integer, 1, _  2]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Switch::argct"],

Cell[BoxData[
    \(Switch::"argct" \(\(:\)\(\ \)\) 
      "Switch called with \!\(4\) arguments. Switch must be called with an \
odd number of arguments."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"Switch::argct"],

Cell[BoxData[
    \(Switch[\[Pi], _Integer, 1, _\ 2]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"Switch::argct"]
}, Open  ]],

Cell[TextData[{
  "This shows valid arguments in ",
  StyleBox["Switch", "MR"],
  "."
}], "Text",
  CellTags->"Switch::argct"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Switch[Pi, _Integer, 1, _, 2]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Switch::argct"],

Cell[BoxData[
    \(2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Switch::argct"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Syntax::stresc", "ObjectNameWarningMessages",
  CellTags->"Syntax::stresc"],

Cell[BoxData[
    \(Syntax::"stresc" \(\(:\)\(\ \)\) 
      "Unknown string escape \\`1`."\)], "Message",
  CellLabel->"From In[69]:=",
  CellTags->"Syntax::stresc"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Syntax::stresc"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 975}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{687, 644},
WindowMargins->{{Automatic, 20}, {Automatic, 33}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Attributes::locked"->{
    Cell[1829, 57, 220, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2052, 67, 391, 11, 21, "Message",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2446, 80, 347, 9, 46, "Notes",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2818, 93, 139, 3, 38, "ExampleSection",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2960, 98, 214, 7, 24, "Text",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[3199, 109, 177, 5, 26, "Input",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[3379, 116, 240, 6, 21, "Message",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[3622, 124, 165, 5, 21, "Output",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}]},
  "ClearAll::locked"->{
    Cell[1829, 57, 220, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2052, 67, 391, 11, 21, "Message",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2446, 80, 347, 9, 46, "Notes",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2818, 93, 139, 3, 38, "ExampleSection",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2960, 98, 214, 7, 24, "Text",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[3199, 109, 177, 5, 26, "Input",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[3379, 116, 240, 6, 21, "Message",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[3622, 124, 165, 5, 21, "Output",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}]},
  "Protect::locked"->{
    Cell[1829, 57, 220, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2052, 67, 391, 11, 21, "Message",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2446, 80, 347, 9, 46, "Notes",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2818, 93, 139, 3, 38, "ExampleSection",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2960, 98, 214, 7, 24, "Text",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[3199, 109, 177, 5, 26, "Input",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[3379, 116, 240, 6, 21, "Message",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[3622, 124, 165, 5, 21, "Output",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}]},
  "SetOptions::locked"->{
    Cell[1829, 57, 220, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2052, 67, 391, 11, 21, "Message",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2446, 80, 347, 9, 46, "Notes",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2818, 93, 139, 3, 38, "ExampleSection",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[2960, 98, 214, 7, 24, "Text",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[3199, 109, 177, 5, 26, "Input",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[3379, 116, 240, 6, 21, "Message",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}],
    Cell[3622, 124, 165, 5, 21, "Output",
      CellTags->{
      "Attributes::locked", "ClearAll::locked", "Protect::locked", 
        "SetOptions::locked"}]},
  "With::lvw"->{
    Cell[3848, 136, 71, 1, 31, "ObjectNameWarningMessages",
      CellTags->"With::lvw"],
    Cell[3922, 139, 386, 10, 37, "Message",
      CellTags->"With::lvw"],
    Cell[4311, 151, 527, 14, 68, "Notes",
      CellTags->"With::lvw"],
    Cell[4863, 169, 59, 1, 38, "ExampleSection",
      CellTags->"With::lvw"],
    Cell[4925, 172, 284, 7, 40, "Text",
      CellTags->"With::lvw"],
    Cell[5234, 183, 114, 3, 26, "Input",
      CellTags->"With::lvw"],
    Cell[5351, 188, 233, 5, 37, "Message",
      CellTags->"With::lvw"],
    Cell[5587, 195, 115, 3, 21, "Output",
      CellTags->"With::lvw"],
    Cell[5717, 201, 147, 5, 24, "Text",
      CellTags->"With::lvw"],
    Cell[5889, 210, 104, 3, 26, "Input",
      CellTags->"With::lvw"],
    Cell[5996, 215, 84, 3, 21, "Output",
      CellTags->"With::lvw"],
    Cell[6095, 221, 363, 11, 40, "Text",
      CellTags->"With::lvw"],
    Cell[6483, 236, 110, 3, 26, "Input",
      CellTags->"With::lvw"],
    Cell[6596, 241, 243, 5, 37, "Message",
      CellTags->"With::lvw"],
    Cell[6842, 248, 107, 3, 21, "Output",
      CellTags->"With::lvw"]},
  "Replace::reps"->{
    Cell[7010, 258, 220, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[7233, 268, 644, 17, 37, "Message",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[7880, 287, 1435, 49, 112, "Notes",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[9340, 340, 139, 3, 38, "ExampleSection",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[9482, 345, 350, 10, 40, "Text",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[9857, 359, 168, 5, 26, "Input",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[10028, 366, 328, 7, 37, "Message",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[10359, 375, 186, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[10560, 383, 342, 8, 40, "Text",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[10927, 395, 186, 5, 26, "Input",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[11116, 402, 279, 7, 21, "Message",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[11398, 411, 368, 8, 53, "Message",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[11769, 421, 204, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[11988, 429, 285, 9, 24, "Text",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[12298, 442, 191, 5, 26, "Input",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[12492, 449, 181, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}]},
  "ReplaceAll::reps"->{
    Cell[7010, 258, 220, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[7233, 268, 644, 17, 37, "Message",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[7880, 287, 1435, 49, 112, "Notes",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[9340, 340, 139, 3, 38, "ExampleSection",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[9482, 345, 350, 10, 40, "Text",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[9857, 359, 168, 5, 26, "Input",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[10028, 366, 328, 7, 37, "Message",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[10359, 375, 186, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[10560, 383, 342, 8, 40, "Text",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[10927, 395, 186, 5, 26, "Input",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[11116, 402, 279, 7, 21, "Message",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[11398, 411, 368, 8, 53, "Message",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[11769, 421, 204, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[11988, 429, 285, 9, 24, "Text",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[12298, 442, 191, 5, 26, "Input",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[12492, 449, 181, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}]},
  "ReplaceRepeated::reps"->{
    Cell[7010, 258, 220, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[7233, 268, 644, 17, 37, "Message",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[7880, 287, 1435, 49, 112, "Notes",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[9340, 340, 139, 3, 38, "ExampleSection",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[9482, 345, 350, 10, 40, "Text",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[9857, 359, 168, 5, 26, "Input",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[10028, 366, 328, 7, 37, "Message",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[10359, 375, 186, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[10560, 383, 342, 8, 40, "Text",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[10927, 395, 186, 5, 26, "Input",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[11116, 402, 279, 7, 21, "Message",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[11398, 411, 368, 8, 53, "Message",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[11769, 421, 204, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[11988, 429, 285, 9, 24, "Text",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[12298, 442, 191, 5, 26, "Input",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[12492, 449, 181, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}]},
  "ReplaceList::reps"->{
    Cell[7010, 258, 220, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[7233, 268, 644, 17, 37, "Message",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[7880, 287, 1435, 49, 112, "Notes",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[9340, 340, 139, 3, 38, "ExampleSection",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[9482, 345, 350, 10, 40, "Text",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[9857, 359, 168, 5, 26, "Input",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[10028, 366, 328, 7, 37, "Message",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[10359, 375, 186, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[10560, 383, 342, 8, 40, "Text",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[10927, 395, 186, 5, 26, "Input",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[11116, 402, 279, 7, 21, "Message",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[11398, 411, 368, 8, 53, "Message",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[11769, 421, 204, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}],
    Cell[11988, 429, 285, 9, 24, "Text",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[12298, 442, 191, 5, 26, "Input",
      CellTags->{
      "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
        "ReplaceList::reps"}],
    Cell[12492, 449, 181, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
        "Replace::reps"}]},
  "$ContextPath::cxlist"->{
    Cell[12734, 461, 142, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[12879, 467, 377, 10, 37, "Message",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[13259, 479, 577, 12, 84, "Notes",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[13861, 495, 93, 1, 38, "ExampleSection",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[13957, 498, 267, 7, 40, "Text",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[14249, 509, 144, 3, 26, "Input",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[14396, 514, 279, 5, 37, "Message",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[14678, 521, 126, 3, 21, "Output",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}]},
  "$Packages::cxlist"->{
    Cell[12734, 461, 142, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[12879, 467, 377, 10, 37, "Message",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[13259, 479, 577, 12, 84, "Notes",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[13861, 495, 93, 1, 38, "ExampleSection",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[13957, 498, 267, 7, 40, "Text",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[14249, 509, 144, 3, 26, "Input",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[14396, 514, 279, 5, 37, "Message",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
    Cell[14678, 521, 126, 3, 21, "Output",
      CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}]},
  "$IterationLimit::itlim"->{
    Cell[14865, 531, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$IterationLimit::itlim"],
    Cell[14965, 534, 250, 5, 21, "Message",
      CellTags->"$IterationLimit::itlim"],
    Cell[15218, 541, 769, 16, 106, "Notes",
      CellTags->"$IterationLimit::itlim"],
    Cell[16012, 561, 72, 1, 38, "ExampleSection",
      CellTags->"$IterationLimit::itlim"],
    Cell[16087, 564, 205, 7, 24, "Text",
      CellTags->"$IterationLimit::itlim"],
    Cell[16317, 575, 113, 3, 26, "Input",
      CellTags->"$IterationLimit::itlim"],
    Cell[16433, 580, 191, 4, 21, "Message",
      CellTags->"$IterationLimit::itlim"],
    Cell[16627, 586, 133, 3, 21, "Output",
      CellTags->"$IterationLimit::itlim"],
    Cell[16775, 592, 123, 5, 24, "Text",
      CellTags->"$IterationLimit::itlim"],
    Cell[16901, 599, 103, 3, 26, "Input",
      CellTags->"$IterationLimit::itlim"],
    Cell[17007, 604, 128, 4, 24, "Text",
      CellTags->"$IterationLimit::itlim"],
    Cell[17160, 612, 118, 3, 26, "Input",
      CellTags->"$IterationLimit::itlim"],
    Cell[17281, 617, 109, 3, 21, "Output",
      CellTags->"$IterationLimit::itlim"],
    Cell[17427, 625, 103, 3, 26, "Input",
      CellTags->"$IterationLimit::itlim"],
    Cell[17533, 630, 97, 3, 21, "Output",
      CellTags->"$IterationLimit::itlim"],
    Cell[17667, 638, 100, 3, 26, "Input",
      CellTags->"$IterationLimit::itlim"],
    Cell[17770, 643, 97, 3, 21, "Output",
      CellTags->"$IterationLimit::itlim"],
    Cell[17882, 649, 120, 5, 24, "Text",
      CellTags->"$IterationLimit::itlim"],
    Cell[18005, 656, 103, 3, 26, "Input",
      CellTags->"$IterationLimit::itlim"]},
  "$IterationLimit::aitlim"->{
    Cell[18157, 665, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$IterationLimit::aitlim"],
    Cell[18259, 668, 369, 8, 37, "Message",
      CellTags->"$IterationLimit::aitlim"],
    Cell[18631, 678, 213, 5, 40, "Notes",
      CellTags->"$IterationLimit::aitlim"]},
  "$MaxComputationSteps::complim"->{
    Cell[18881, 688, 111, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$MaxComputationSteps::complim"],
    Cell[18995, 691, 383, 9, 21, "Message",
      CellTags->"$MaxComputationSteps::complim"],
    Cell[19381, 702, 140, 4, 24, "Notes",
      CellTags->"$MaxComputationSteps::complim"]},
  "$Cache::set"->{
    Cell[19558, 711, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$Cache::set"],
    Cell[19636, 714, 182, 4, 21, "Message",
      CellTags->"$Cache::set"],
    Cell[19821, 720, 191, 6, 24, "Notes",
      CellTags->"$Cache::set"]},
  "$IterationLimit::limset"->{
    Cell[20049, 731, 160, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[20212, 737, 653, 19, 21, "Message",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[20868, 758, 530, 15, 62, "Notes",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[21423, 777, 102, 1, 38, "ExampleSection",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[21528, 780, 281, 7, 40, "Text",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[21834, 791, 145, 3, 26, "Input",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[21982, 796, 286, 5, 37, "Message",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[22271, 803, 128, 3, 21, "Output",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}]},
  "$RecursionLimit::limset"->{
    Cell[20049, 731, 160, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[20212, 737, 653, 19, 21, "Message",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[20868, 758, 530, 15, 62, "Notes",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[21423, 777, 102, 1, 38, "ExampleSection",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[21528, 780, 281, 7, 40, "Text",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[21834, 791, 145, 3, 26, "Input",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[21982, 796, 286, 5, 37, "Message",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
    Cell[22271, 803, 128, 3, 21, "Output",
      CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}]},
  "Replace::erep"->{
    Cell[22460, 813, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Replace::erep"],
    Cell[22542, 816, 208, 5, 21, "Message",
      CellTags->"Replace::erep"],
    Cell[22753, 823, 277, 8, 40, "Notes",
      CellTags->"Replace::erep"]},
  "With::dup"->{
    Cell[23067, 836, 160, 6, 91, "ObjectNameWarningMessages",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[23230, 844, 513, 14, 21, "Message",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[23746, 860, 217, 4, 24, "Notes",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[23988, 868, 105, 1, 38, "ExampleSection",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[24096, 871, 187, 4, 24, "Text",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[24308, 879, 190, 4, 26, "Input",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[24501, 885, 263, 5, 37, "Message",
      CellTags->{"Block::dup", "Dialog::dup", "Module::dup", "With::dup"}],
    Cell[24767, 892, 167, 3, 21, "Output",
      CellTags->{"Block::dup", "Dialog::dup", "Module::dup", "With::dup"}]},
  "Module::dup"->{
    Cell[23067, 836, 160, 6, 91, "ObjectNameWarningMessages",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[23230, 844, 513, 14, 21, "Message",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[23746, 860, 217, 4, 24, "Notes",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[23988, 868, 105, 1, 38, "ExampleSection",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[24096, 871, 187, 4, 24, "Text",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[24308, 879, 190, 4, 26, "Input",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[24501, 885, 263, 5, 37, "Message",
      CellTags->{"Block::dup", "Dialog::dup", "Module::dup", "With::dup"}],
    Cell[24767, 892, 167, 3, 21, "Output",
      CellTags->{"Block::dup", "Dialog::dup", "Module::dup", "With::dup"}]},
  "Block::dup"->{
    Cell[23067, 836, 160, 6, 91, "ObjectNameWarningMessages",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[23230, 844, 513, 14, 21, "Message",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[23746, 860, 217, 4, 24, "Notes",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[23988, 868, 105, 1, 38, "ExampleSection",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[24096, 871, 187, 4, 24, "Text",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[24308, 879, 190, 4, 26, "Input",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[24501, 885, 263, 5, 37, "Message",
      CellTags->{"Block::dup", "Dialog::dup", "Module::dup", "With::dup"}],
    Cell[24767, 892, 167, 3, 21, "Output",
      CellTags->{"Block::dup", "Dialog::dup", "Module::dup", "With::dup"}]},
  "Dialog::dup"->{
    Cell[23067, 836, 160, 6, 91, "ObjectNameWarningMessages",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[23230, 844, 513, 14, 21, "Message",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[23746, 860, 217, 4, 24, "Notes",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[23988, 868, 105, 1, 38, "ExampleSection",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[24096, 871, 187, 4, 24, "Text",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[24308, 879, 190, 4, 26, "Input",
      CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
    Cell[24501, 885, 263, 5, 37, "Message",
      CellTags->{"Block::dup", "Dialog::dup", "Module::dup", "With::dup"}],
    Cell[24767, 892, 167, 3, 21, "Output",
      CellTags->{"Block::dup", "Dialog::dup", "Module::dup", "With::dup"}]},
  "$ModuleNumber::modnc"->{
    Cell[24995, 902, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$ModuleNumber::modnc"],
    Cell[25091, 905, 195, 3, 21, "Message",
      CellTags->"$ModuleNumber::modnc"],
    Cell[25289, 910, 547, 14, 78, "Notes",
      CellTags->"$ModuleNumber::modnc"],
    Cell[25861, 928, 70, 1, 38, "ExampleSection",
      CellTags->"$ModuleNumber::modnc"],
    Cell[25934, 931, 271, 8, 40, "Text",
      CellTags->"$ModuleNumber::modnc"],
    Cell[26230, 943, 115, 3, 26, "Input",
      CellTags->"$ModuleNumber::modnc"],
    Cell[26348, 948, 107, 3, 21, "Output",
      CellTags->"$ModuleNumber::modnc"],
    Cell[26470, 954, 358, 10, 40, "Text",
      CellTags->"$ModuleNumber::modnc"],
    Cell[26853, 968, 126, 3, 26, "Input",
      CellTags->"$ModuleNumber::modnc"],
    Cell[26982, 973, 209, 5, 37, "Message",
      CellTags->"$ModuleNumber::modnc"],
    Cell[27194, 980, 99, 3, 21, "Output",
      CellTags->"$ModuleNumber::modnc"]},
  "$ModuleNumber::set"->{
    Cell[27354, 990, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$ModuleNumber::set"],
    Cell[27446, 993, 368, 10, 21, "Message",
      CellTags->"$ModuleNumber::set"],
    Cell[27817, 1005, 216, 5, 24, "Notes",
      CellTags->"$ModuleNumber::set"],
    Cell[28058, 1014, 68, 1, 38, "ExampleSection",
      CellTags->"$ModuleNumber::set"],
    Cell[28129, 1017, 237, 7, 40, "Text",
      CellTags->"$ModuleNumber::set"],
    Cell[28391, 1028, 108, 3, 26, "Input",
      CellTags->"$ModuleNumber::set"],
    Cell[28502, 1033, 222, 5, 37, "Message",
      CellTags->"$ModuleNumber::set"],
    Cell[28727, 1040, 93, 3, 21, "Output",
      CellTags->"$ModuleNumber::set"]},
  "CharacterRange::argtype"->{
    Cell[28881, 1050, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"CharacterRange::argtype"],
    Cell[28983, 1053, 407, 12, 21, "Message",
      CellTags->"CharacterRange::argtype"],
    Cell[29393, 1067, 228, 5, 24, "Notes",
      CellTags->"CharacterRange::argtype"],
    Cell[29646, 1076, 73, 1, 38, "ExampleSection",
      CellTags->"CharacterRange::argtype"],
    Cell[29722, 1079, 147, 5, 24, "Text",
      CellTags->"CharacterRange::argtype"],
    Cell[29894, 1088, 118, 3, 26, "Input",
      CellTags->"CharacterRange::argtype"],
    Cell[30015, 1093, 243, 5, 37, "Message",
      CellTags->"CharacterRange::argtype"],
    Cell[30261, 1100, 117, 3, 21, "Output",
      CellTags->"CharacterRange::argtype"],
    Cell[30393, 1106, 142, 5, 24, "Text",
      CellTags->"CharacterRange::argtype"],
    Cell[30560, 1115, 130, 3, 26, "Input",
      CellTags->"CharacterRange::argtype"],
    Cell[30693, 1120, 142, 3, 21, "Output",
      CellTags->"CharacterRange::argtype"]},
  "Set::inset"->{
    Cell[30896, 1130, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Set::inset"],
    Cell[30972, 1133, 163, 3, 21, "Message",
      CellTags->"Set::inset"],
    Cell[31138, 1138, 536, 10, 84, "Notes",
      CellTags->"Set::inset"]},
  "With::dups"->{
    Cell[31711, 1153, 112, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[31826, 1159, 543, 16, 37, "Message",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[32372, 1177, 512, 12, 78, "Notes",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[32909, 1193, 78, 1, 38, "ExampleSection",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[32990, 1196, 278, 7, 40, "Text",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[33293, 1207, 130, 3, 26, "Input",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[33426, 1212, 273, 5, 37, "Message",
      CellTags->{"Module::dups", "With::dups"}],
    Cell[33702, 1219, 131, 3, 21, "Output",
      CellTags->{"Module::dups", "With::dups"}],
    Cell[33848, 1225, 176, 5, 24, "Text",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[34049, 1234, 128, 3, 26, "Input",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[34180, 1239, 103, 3, 21, "Output",
      CellTags->{"Module::dups", "With::dups"}]},
  "Module::dups"->{
    Cell[31711, 1153, 112, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[31826, 1159, 543, 16, 37, "Message",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[32372, 1177, 512, 12, 78, "Notes",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[32909, 1193, 78, 1, 38, "ExampleSection",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[32990, 1196, 278, 7, 40, "Text",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[33293, 1207, 130, 3, 26, "Input",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[33426, 1212, 273, 5, 37, "Message",
      CellTags->{"Module::dups", "With::dups"}],
    Cell[33702, 1219, 131, 3, 21, "Output",
      CellTags->{"Module::dups", "With::dups"}],
    Cell[33848, 1225, 176, 5, 24, "Text",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[34049, 1234, 128, 3, 26, "Input",
      CellTags->{"With::dups", "Module::dups"}],
    Cell[34180, 1239, 103, 3, 21, "Output",
      CellTags->{"Module::dups", "With::dups"}]},
  "With::lvws"->{
    Cell[34344, 1249, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"With::lvws"],
    Cell[34420, 1252, 334, 7, 21, "Message",
      CellTags->"With::lvws"],
    Cell[34757, 1261, 190, 5, 24, "Notes",
      CellTags->"With::lvws"],
    Cell[34972, 1270, 60, 1, 38, "ExampleSection",
      CellTags->"With::lvws"],
    Cell[35035, 1273, 172, 6, 24, "Text",
      CellTags->"With::lvws"],
    Cell[35232, 1283, 116, 3, 26, "Input",
      CellTags->"With::lvws"],
    Cell[35351, 1288, 209, 5, 21, "Message",
      CellTags->"With::lvws"],
    Cell[35563, 1295, 117, 3, 21, "Output",
      CellTags->"With::lvws"],
    Cell[35695, 1301, 119, 5, 24, "Text",
      CellTags->"With::lvws"],
    Cell[35839, 1310, 110, 3, 26, "Input",
      CellTags->"With::lvws"],
    Cell[35952, 1315, 85, 3, 21, "Output",
      CellTags->"With::lvws"]},
  "AbsoluteOptions::optnf"->{
    Cell[36098, 1325, 179, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[36280, 1332, 485, 14, 21, "Message",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[36768, 1348, 450, 11, 46, "Notes",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[37243, 1363, 113, 1, 38, "ExampleSection",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[37359, 1366, 243, 7, 24, "Text",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[37627, 1377, 163, 3, 26, "Input",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[37793, 1382, 243, 5, 21, "Message",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
    Cell[38039, 1389, 139, 3, 21, "Output",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
    Cell[38193, 1395, 188, 5, 24, "Text",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[38406, 1404, 174, 3, 26, "Input",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[38583, 1409, 175, 3, 21, "Output",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
    Cell[38773, 1415, 174, 4, 24, "Text",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[38972, 1423, 171, 3, 26, "Input",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[39146, 1428, 246, 5, 21, "Message",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
    Cell[39395, 1435, 177, 3, 21, "Output",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}]},
  "SetOptions::optnf"->{
    Cell[36098, 1325, 179, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[36280, 1332, 485, 14, 21, "Message",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[36768, 1348, 450, 11, 46, "Notes",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[37243, 1363, 113, 1, 38, "ExampleSection",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[37359, 1366, 243, 7, 24, "Text",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[37627, 1377, 163, 3, 26, "Input",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[37793, 1382, 243, 5, 21, "Message",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
    Cell[38039, 1389, 139, 3, 21, "Output",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
    Cell[38193, 1395, 188, 5, 24, "Text",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[38406, 1404, 174, 3, 26, "Input",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[38583, 1409, 175, 3, 21, "Output",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
    Cell[38773, 1415, 174, 4, 24, "Text",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[38972, 1423, 171, 3, 26, "Input",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[39146, 1428, 246, 5, 21, "Message",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
    Cell[39395, 1435, 177, 3, 21, "Output",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}]},
  "Options::optnf"->{
    Cell[36098, 1325, 179, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[36280, 1332, 485, 14, 21, "Message",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[36768, 1348, 450, 11, 46, "Notes",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[37243, 1363, 113, 1, 38, "ExampleSection",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[37359, 1366, 243, 7, 24, "Text",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[37627, 1377, 163, 3, 26, "Input",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[37793, 1382, 243, 5, 21, "Message",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
    Cell[38039, 1389, 139, 3, 21, "Output",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
    Cell[38193, 1395, 188, 5, 24, "Text",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[38406, 1404, 174, 3, 26, "Input",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[38583, 1409, 175, 3, 21, "Output",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
    Cell[38773, 1415, 174, 4, 24, "Text",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[38972, 1423, 171, 3, 26, "Input",
      CellTags->{
      "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
    Cell[39146, 1428, 246, 5, 21, "Message",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
    Cell[39395, 1435, 177, 3, 21, "Output",
      CellTags->{
      "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}]},
  "Break::nofunc"->{
    Cell[39633, 1445, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[39795, 1452, 432, 12, 21, "Message",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[40230, 1466, 663, 18, 78, "Notes",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[40918, 1488, 103, 1, 38, "ExampleSection",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41024, 1491, 229, 5, 24, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41278, 1500, 138, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41419, 1505, 241, 5, 21, "Message",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41663, 1512, 145, 3, 21, "Output",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41823, 1518, 311, 8, 40, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[42137, 1528, 331, 7, 154, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[42493, 1539, 130, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[42626, 1544, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[42858, 1551, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[43090, 1558, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[43322, 1565, 128, 3, 21, "Output",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[43465, 1571, 303, 7, 40, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[43771, 1580, 308, 6, 154, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44104, 1590, 130, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44237, 1595, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44469, 1602, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44701, 1609, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44933, 1616, 131, 3, 21, "Output",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[45079, 1622, 348, 9, 40, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[45430, 1633, 326, 7, 154, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[45781, 1644, 130, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[45914, 1649, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[46146, 1656, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[46378, 1663, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[46610, 1670, 241, 5, 21, "Message",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[46854, 1677, 145, 3, 21, "Output",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[47014, 1683, 155, 5, 24, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[47172, 1690, 134, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}]},
  "Continue::nofunc"->{
    Cell[39633, 1445, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[39795, 1452, 432, 12, 21, "Message",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[40230, 1466, 663, 18, 78, "Notes",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[40918, 1488, 103, 1, 38, "ExampleSection",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41024, 1491, 229, 5, 24, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41278, 1500, 138, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41419, 1505, 241, 5, 21, "Message",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41663, 1512, 145, 3, 21, "Output",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41823, 1518, 311, 8, 40, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[42137, 1528, 331, 7, 154, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[42493, 1539, 130, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[42626, 1544, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[42858, 1551, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[43090, 1558, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[43322, 1565, 128, 3, 21, "Output",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[43465, 1571, 303, 7, 40, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[43771, 1580, 308, 6, 154, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44104, 1590, 130, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44237, 1595, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44469, 1602, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44701, 1609, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44933, 1616, 131, 3, 21, "Output",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[45079, 1622, 348, 9, 40, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[45430, 1633, 326, 7, 154, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[45781, 1644, 130, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[45914, 1649, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[46146, 1656, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[46378, 1663, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[46610, 1670, 241, 5, 21, "Message",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[46854, 1677, 145, 3, 21, "Output",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[47014, 1683, 155, 5, 24, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[47172, 1690, 134, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}]},
  "Return::nofunc"->{
    Cell[39633, 1445, 159, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[39795, 1452, 432, 12, 21, "Message",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[40230, 1466, 663, 18, 78, "Notes",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[40918, 1488, 103, 1, 38, "ExampleSection",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41024, 1491, 229, 5, 24, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41278, 1500, 138, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41419, 1505, 241, 5, 21, "Message",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41663, 1512, 145, 3, 21, "Output",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[41823, 1518, 311, 8, 40, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[42137, 1528, 331, 7, 154, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[42493, 1539, 130, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[42626, 1544, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[42858, 1551, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[43090, 1558, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[43322, 1565, 128, 3, 21, "Output",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[43465, 1571, 303, 7, 40, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[43771, 1580, 308, 6, 154, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44104, 1590, 130, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44237, 1595, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44469, 1602, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44701, 1609, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[44933, 1616, 131, 3, 21, "Output",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[45079, 1622, 348, 9, 40, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[45430, 1633, 326, 7, 154, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[45781, 1644, 130, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[45914, 1649, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[46146, 1656, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[46378, 1663, 229, 5, 21, "Print",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[46610, 1670, 241, 5, 21, "Message",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[46854, 1677, 145, 3, 21, "Output",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[47014, 1683, 155, 5, 24, "Text",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
    Cell[47172, 1690, 134, 3, 26, "Input",
      CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}]},
  "$RecursionLimit::reclim"->{
    Cell[47355, 1699, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$RecursionLimit::reclim"],
    Cell[47457, 1702, 252, 5, 21, "Message",
      CellTags->"$RecursionLimit::reclim"],
    Cell[47712, 1709, 573, 12, 100, "Notes",
      CellTags->"$RecursionLimit::reclim"],
    Cell[48310, 1725, 73, 1, 38, "ExampleSection",
      CellTags->"$RecursionLimit::reclim"],
    Cell[48386, 1728, 194, 6, 24, "Text",
      CellTags->"$RecursionLimit::reclim"],
    Cell[48605, 1738, 109, 3, 26, "Input",
      CellTags->"$RecursionLimit::reclim"],
    Cell[48717, 1743, 192, 4, 21, "Message",
      CellTags->"$RecursionLimit::reclim"],
    Cell[48912, 1749, 116, 3, 21, "Output",
      CellTags->"$RecursionLimit::reclim"],
    Cell[49043, 1755, 175, 5, 24, "Text",
      CellTags->"$RecursionLimit::reclim"],
    Cell[49243, 1764, 104, 3, 26, "Input",
      CellTags->"$RecursionLimit::reclim"],
    Cell[49350, 1769, 99, 3, 21, "Output",
      CellTags->"$RecursionLimit::reclim"],
    Cell[49486, 1777, 109, 3, 26, "Input",
      CellTags->"$RecursionLimit::reclim"],
    Cell[49598, 1782, 99, 3, 21, "Output",
      CellTags->"$RecursionLimit::reclim"],
    Cell[49712, 1788, 122, 5, 24, "Text",
      CellTags->"$RecursionLimit::reclim"],
    Cell[49837, 1795, 106, 3, 26, "Input",
      CellTags->"$RecursionLimit::reclim"]},
  "Condition::condp"->{
    Cell[49992, 1804, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Condition::condp"],
    Cell[50080, 1807, 421, 11, 21, "Message",
      CellTags->"Condition::condp"],
    Cell[50504, 1820, 938, 24, 116, "Notes",
      CellTags->"Condition::condp"],
    Cell[51467, 1848, 66, 1, 38, "ExampleSection",
      CellTags->"Condition::condp"],
    Cell[51536, 1851, 184, 4, 40, "Text",
      CellTags->"Condition::condp"],
    Cell[51745, 1859, 134, 3, 26, "Input",
      CellTags->"Condition::condp"],
    Cell[51882, 1864, 231, 5, 37, "Message",
      CellTags->"Condition::condp"],
    Cell[52116, 1871, 105, 3, 21, "Output",
      CellTags->"Condition::condp"],
    Cell[52236, 1877, 105, 1, 24, "Text",
      CellTags->"Condition::condp"],
    Cell[52366, 1882, 133, 3, 26, "Input",
      CellTags->"Condition::condp"],
    Cell[52502, 1887, 105, 3, 21, "Output",
      CellTags->"Condition::condp"]},
  "Optional::opdef"->{
    Cell[52668, 1897, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Optional::opdef"],
    Cell[52754, 1900, 315, 6, 21, "Message",
      CellTags->"Optional::opdef"],
    Cell[53072, 1908, 1081, 31, 144, "Notes",
      CellTags->"Optional::opdef"],
    Cell[54178, 1943, 65, 1, 38, "ExampleSection",
      CellTags->"Optional::opdef"],
    Cell[54246, 1946, 353, 10, 40, "Text",
      CellTags->"Optional::opdef"],
    Cell[54624, 1960, 125, 3, 26, "Input",
      CellTags->"Optional::opdef"],
    Cell[54752, 1965, 216, 5, 37, "Message",
      CellTags->"Optional::opdef"],
    Cell[54971, 1972, 216, 5, 37, "Message",
      CellTags->"Optional::opdef"],
    Cell[55190, 1979, 103, 3, 21, "Output",
      CellTags->"Optional::opdef"]},
  "Attributes::attnf"->{
    Cell[55354, 1989, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Attributes::attnf"],
    Cell[55444, 1992, 212, 5, 21, "Message",
      CellTags->"Attributes::attnf"],
    Cell[55659, 1999, 1137, 46, 100, "Notes",
      CellTags->"Attributes::attnf"],
    Cell[56821, 2049, 67, 1, 38, "ExampleSection",
      CellTags->"Attributes::attnf"],
    Cell[56891, 2052, 311, 7, 40, "Text",
      CellTags->"Attributes::attnf"],
    Cell[57227, 2063, 119, 3, 26, "Input",
      CellTags->"Attributes::attnf"],
    Cell[57349, 2068, 185, 4, 21, "Message",
      CellTags->"Attributes::attnf"]},
  "Attributes::attsl"->{
    Cell[57595, 2079, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Attributes::attsl"],
    Cell[57685, 2082, 256, 5, 21, "Message",
      CellTags->"Attributes::attsl"],
    Cell[57944, 2089, 212, 5, 24, "Notes",
      CellTags->"Attributes::attsl"]},
  "Block::lockt"->{
    Cell[58193, 2099, 118, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[58314, 2105, 566, 16, 37, "Message",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[58883, 2123, 601, 19, 68, "Notes",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[59509, 2146, 81, 1, 38, "ExampleSection",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[59593, 2149, 323, 11, 40, "Text",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[59941, 2164, 137, 3, 26, "Input",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[60081, 2169, 280, 5, 37, "Message",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[60364, 2176, 136, 3, 21, "Output",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[60515, 2182, 189, 6, 24, "Text",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[60729, 2192, 135, 3, 26, "Input",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[60867, 2197, 114, 3, 21, "Output",
      CellTags->{"Block::lockt", "Dialog::lockt"}]},
  "Dialog::lockt"->{
    Cell[58193, 2099, 118, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[58314, 2105, 566, 16, 37, "Message",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[58883, 2123, 601, 19, 68, "Notes",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[59509, 2146, 81, 1, 38, "ExampleSection",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[59593, 2149, 323, 11, 40, "Text",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[59941, 2164, 137, 3, 26, "Input",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[60081, 2169, 280, 5, 37, "Message",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[60364, 2176, 136, 3, 21, "Output",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[60515, 2182, 189, 6, 24, "Text",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[60729, 2192, 135, 3, 26, "Input",
      CellTags->{"Block::lockt", "Dialog::lockt"}],
    Cell[60867, 2197, 114, 3, 21, "Output",
      CellTags->{"Block::lockt", "Dialog::lockt"}]},
  "Block::lockv"->{
    Cell[61042, 2207, 118, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[61163, 2213, 490, 14, 21, "Message",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[61656, 2229, 580, 19, 68, "Notes",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[62261, 2252, 81, 1, 38, "ExampleSection",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[62345, 2255, 323, 11, 40, "Text",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[62693, 2270, 135, 3, 26, "Input",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[62831, 2275, 239, 5, 37, "Message",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[63073, 2282, 136, 3, 21, "Output",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[63224, 2288, 189, 6, 24, "Text",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[63438, 2298, 135, 3, 26, "Input",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[63576, 2303, 114, 3, 21, "Output",
      CellTags->{"Block::lockv", "Dialog::lockv"}]},
  "Dialog::lockv"->{
    Cell[61042, 2207, 118, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[61163, 2213, 490, 14, 21, "Message",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[61656, 2229, 580, 19, 68, "Notes",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[62261, 2252, 81, 1, 38, "ExampleSection",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[62345, 2255, 323, 11, 40, "Text",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[62693, 2270, 135, 3, 26, "Input",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[62831, 2275, 239, 5, 37, "Message",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[63073, 2282, 136, 3, 21, "Output",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[63224, 2288, 189, 6, 24, "Text",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[63438, 2298, 135, 3, 26, "Input",
      CellTags->{"Block::lockv", "Dialog::lockv"}],
    Cell[63576, 2303, 114, 3, 21, "Output",
      CellTags->{"Block::lockv", "Dialog::lockv"}]},
  "Block::lvlist"->{
    Cell[63751, 2313, 187, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[63941, 2322, 445, 12, 21, "Message",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[64389, 2336, 1084, 29, 144, "Notes",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[65498, 2369, 120, 2, 38, "ExampleSection",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[65621, 2373, 185, 5, 24, "Text",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[65831, 2382, 168, 4, 26, "Input",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66002, 2388, 242, 5, 21, "Message",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66247, 2395, 169, 4, 21, "Output",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66431, 2402, 203, 6, 24, "Text",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66659, 2412, 170, 4, 26, "Input",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66832, 2418, 146, 4, 21, "Output",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}]},
  "Dialog::lvlist"->{
    Cell[63751, 2313, 187, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[63941, 2322, 445, 12, 21, "Message",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[64389, 2336, 1084, 29, 144, "Notes",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[65498, 2369, 120, 2, 38, "ExampleSection",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[65621, 2373, 185, 5, 24, "Text",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[65831, 2382, 168, 4, 26, "Input",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66002, 2388, 242, 5, 21, "Message",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66247, 2395, 169, 4, 21, "Output",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66431, 2402, 203, 6, 24, "Text",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66659, 2412, 170, 4, 26, "Input",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66832, 2418, 146, 4, 21, "Output",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}]},
  "Module::lvlist"->{
    Cell[63751, 2313, 187, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[63941, 2322, 445, 12, 21, "Message",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[64389, 2336, 1084, 29, 144, "Notes",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[65498, 2369, 120, 2, 38, "ExampleSection",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[65621, 2373, 185, 5, 24, "Text",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[65831, 2382, 168, 4, 26, "Input",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66002, 2388, 242, 5, 21, "Message",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66247, 2395, 169, 4, 21, "Output",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66431, 2402, 203, 6, 24, "Text",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66659, 2412, 170, 4, 26, "Input",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66832, 2418, 146, 4, 21, "Output",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}]},
  "With::lvlist"->{
    Cell[63751, 2313, 187, 7, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[63941, 2322, 445, 12, 21, "Message",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[64389, 2336, 1084, 29, 144, "Notes",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[65498, 2369, 120, 2, 38, "ExampleSection",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[65621, 2373, 185, 5, 24, "Text",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[65831, 2382, 168, 4, 26, "Input",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66002, 2388, 242, 5, 21, "Message",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66247, 2395, 169, 4, 21, "Output",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66431, 2402, 203, 6, 24, "Text",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66659, 2412, 170, 4, 26, "Input",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
    Cell[66832, 2418, 146, 4, 21, "Output",
      CellTags->{
      "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}]},
  "Block::lvset"->{
    Cell[67039, 2429, 176, 6, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[67218, 2437, 671, 18, 37, "Message",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[67892, 2457, 1137, 34, 138, "Notes",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69054, 2495, 113, 1, 38, "ExampleSection",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69170, 2498, 310, 6, 40, "Text",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69505, 2508, 172, 3, 26, "Input",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69680, 2513, 381, 6, 53, "Message",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}],
    Cell[70064, 2521, 173, 3, 21, "Output",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}],
    Cell[70252, 2527, 195, 5, 24, "Text",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[70472, 2536, 164, 3, 26, "Input",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[70639, 2541, 152, 3, 21, "Output",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}]},
  "Dialog::lvset"->{
    Cell[67039, 2429, 176, 6, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[67218, 2437, 671, 18, 37, "Message",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[67892, 2457, 1137, 34, 138, "Notes",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69054, 2495, 113, 1, 38, "ExampleSection",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69170, 2498, 310, 6, 40, "Text",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69505, 2508, 172, 3, 26, "Input",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69680, 2513, 381, 6, 53, "Message",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}],
    Cell[70064, 2521, 173, 3, 21, "Output",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}],
    Cell[70252, 2527, 195, 5, 24, "Text",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[70472, 2536, 164, 3, 26, "Input",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[70639, 2541, 152, 3, 21, "Output",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}]},
  "With::lvset"->{
    Cell[67039, 2429, 176, 6, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[67218, 2437, 671, 18, 37, "Message",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[67892, 2457, 1137, 34, 138, "Notes",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69054, 2495, 113, 1, 38, "ExampleSection",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69170, 2498, 310, 6, 40, "Text",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69505, 2508, 172, 3, 26, "Input",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69680, 2513, 381, 6, 53, "Message",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}],
    Cell[70064, 2521, 173, 3, 21, "Output",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}],
    Cell[70252, 2527, 195, 5, 24, "Text",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[70472, 2536, 164, 3, 26, "Input",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[70639, 2541, 152, 3, 21, "Output",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}]},
  "Module::lvset"->{
    Cell[67039, 2429, 176, 6, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[67218, 2437, 671, 18, 37, "Message",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[67892, 2457, 1137, 34, 138, "Notes",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69054, 2495, 113, 1, 38, "ExampleSection",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69170, 2498, 310, 6, 40, "Text",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69505, 2508, 172, 3, 26, "Input",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[69680, 2513, 381, 6, 53, "Message",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}],
    Cell[70064, 2521, 173, 3, 21, "Output",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}],
    Cell[70252, 2527, 195, 5, 24, "Text",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[70472, 2536, 164, 3, 26, "Input",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
    Cell[70639, 2541, 152, 3, 21, "Output",
      CellTags->{
      "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}]},
  "Block::lvsym"->{
    Cell[70852, 2551, 149, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[71004, 2558, 583, 14, 37, "Message",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[71590, 2574, 856, 22, 100, "Notes",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[72471, 2600, 98, 1, 38, "ExampleSection",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[72572, 2603, 236, 5, 24, "Text",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[72833, 2612, 179, 3, 26, "Input",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73015, 2617, 298, 6, 37, "Message",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73316, 2625, 182, 4, 21, "Output",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73513, 2632, 175, 5, 24, "Text",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73713, 2641, 175, 3, 26, "Input",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73891, 2646, 131, 3, 21, "Output",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}]},
  "Dialog::lvsym"->{
    Cell[70852, 2551, 149, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[71004, 2558, 583, 14, 37, "Message",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[71590, 2574, 856, 22, 100, "Notes",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[72471, 2600, 98, 1, 38, "ExampleSection",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[72572, 2603, 236, 5, 24, "Text",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[72833, 2612, 179, 3, 26, "Input",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73015, 2617, 298, 6, 37, "Message",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73316, 2625, 182, 4, 21, "Output",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73513, 2632, 175, 5, 24, "Text",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73713, 2641, 175, 3, 26, "Input",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73891, 2646, 131, 3, 21, "Output",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}]},
  "Module::lvsym"->{
    Cell[70852, 2551, 149, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[71004, 2558, 583, 14, 37, "Message",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[71590, 2574, 856, 22, 100, "Notes",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[72471, 2600, 98, 1, 38, "ExampleSection",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[72572, 2603, 236, 5, 24, "Text",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[72833, 2612, 179, 3, 26, "Input",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73015, 2617, 298, 6, 37, "Message",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73316, 2625, 182, 4, 21, "Output",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73513, 2632, 175, 5, 24, "Text",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73713, 2641, 175, 3, 26, "Input",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
    Cell[73891, 2646, 131, 3, 21, "Output",
      CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}]},
  "Break::nofwd"->{
    Cell[74083, 2656, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Break::nofwd"],
    Cell[74163, 2659, 248, 5, 21, "Message",
      CellTags->"Break::nofwd"],
    Cell[74414, 2666, 194, 5, 24, "Notes",
      CellTags->"Break::nofwd"]},
  "Clear::spsym"->{
    Cell[74645, 2676, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Clear::spsym", "ClearAll::spsym"}],
    Cell[74770, 2682, 381, 11, 21, "Message",
      CellTags->{"Clear::spsym", "ClearAll::spsym"}],
    Cell[75154, 2695, 528, 15, 62, "Notes",
      CellTags->{"Clear::spsym", "ClearAll::spsym"}],
    Cell[75707, 2714, 83, 1, 38, "ExampleSection",
      CellTags->{"Clear::spsym", "ClearAll::spsym"}],
    Cell[75793, 2717, 184, 5, 24, "Text",
      CellTags->{"Clear::spsym", "ClearAll::spsym"}],
    Cell[76002, 2726, 125, 3, 26, "Input",
      CellTags->{"Clear::spsym", "ClearAll::spsym"}],
    Cell[76130, 2731, 205, 4, 21, "Message",
      CellTags->{"ClearAll::spsym", "Clear::spsym"}]},
  "ClearAll::spsym"->{
    Cell[74645, 2676, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Clear::spsym", "ClearAll::spsym"}],
    Cell[74770, 2682, 381, 11, 21, "Message",
      CellTags->{"Clear::spsym", "ClearAll::spsym"}],
    Cell[75154, 2695, 528, 15, 62, "Notes",
      CellTags->{"Clear::spsym", "ClearAll::spsym"}],
    Cell[75707, 2714, 83, 1, 38, "ExampleSection",
      CellTags->{"Clear::spsym", "ClearAll::spsym"}],
    Cell[75793, 2717, 184, 5, 24, "Text",
      CellTags->{"Clear::spsym", "ClearAll::spsym"}],
    Cell[76002, 2726, 125, 3, 26, "Input",
      CellTags->{"Clear::spsym", "ClearAll::spsym"}],
    Cell[76130, 2731, 205, 4, 21, "Message",
      CellTags->{"ClearAll::spsym", "Clear::spsym"}]},
  "Remove::spsym"->{
    Cell[76396, 2742, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Remove::spsym"],
    Cell[76478, 2745, 234, 5, 21, "Message",
      CellTags->"Remove::spsym"],
    Cell[76715, 2752, 495, 15, 62, "Notes",
      CellTags->"Remove::spsym"],
    Cell[77235, 2771, 63, 1, 38, "ExampleSection",
      CellTags->"Remove::spsym"],
    Cell[77301, 2774, 164, 5, 24, "Text",
      CellTags->"Remove::spsym"],
    Cell[77490, 2783, 106, 3, 26, "Input",
      CellTags->"Remove::spsym"],
    Cell[77599, 2788, 186, 4, 21, "Message",
      CellTags->"Remove::spsym"]},
  "Clear::ssym"->{
    Cell[77846, 2799, 157, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[78006, 2806, 419, 11, 21, "Message",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[78428, 2819, 642, 14, 106, "Notes",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[79095, 2837, 102, 1, 38, "ExampleSection",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[79200, 2840, 191, 4, 24, "Text",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[79416, 2848, 137, 3, 26, "Input",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[79556, 2853, 211, 4, 21, "Message",
      CellTags->{"ClearAll::ssym", "Clear::ssym", "Information::ssym"}]},
  "ClearAll::ssym"->{
    Cell[77846, 2799, 157, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[78006, 2806, 419, 11, 21, "Message",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[78428, 2819, 642, 14, 106, "Notes",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[79095, 2837, 102, 1, 38, "ExampleSection",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[79200, 2840, 191, 4, 24, "Text",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[79416, 2848, 137, 3, 26, "Input",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[79556, 2853, 211, 4, 21, "Message",
      CellTags->{"ClearAll::ssym", "Clear::ssym", "Information::ssym"}]},
  "Information::ssym"->{
    Cell[77846, 2799, 157, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[78006, 2806, 419, 11, 21, "Message",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[78428, 2819, 642, 14, 106, "Notes",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[79095, 2837, 102, 1, 38, "ExampleSection",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[79200, 2840, 191, 4, 24, "Text",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[79416, 2848, 137, 3, 26, "Input",
      CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
    Cell[79556, 2853, 211, 4, 21, "Message",
      CellTags->{"ClearAll::ssym", "Clear::ssym", "Information::ssym"}]},
  "ClearAll::clloc"->{
    Cell[79828, 2864, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ClearAll::clloc"],
    Cell[79914, 2867, 226, 5, 21, "Message",
      CellTags->"ClearAll::clloc"],
    Cell[80143, 2874, 257, 7, 24, "Notes",
      CellTags->"ClearAll::clloc"],
    Cell[80425, 2885, 65, 1, 38, "ExampleSection",
      CellTags->"ClearAll::clloc"],
    Cell[80493, 2888, 214, 7, 24, "Text",
      CellTags->"ClearAll::clloc"],
    Cell[80732, 2899, 111, 3, 26, "Input",
      CellTags->"ClearAll::clloc"],
    Cell[80846, 2904, 174, 4, 21, "Message",
      CellTags->"ClearAll::clloc"]},
  "Context::cxdup"->{
    Cell[81081, 2915, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Context::cxdup"],
    Cell[81165, 2918, 595, 18, 37, "Message",
      CellTags->"Context::cxdup"],
    Cell[81763, 2938, 415, 11, 46, "Notes",
      CellTags->"Context::cxdup"],
    Cell[82203, 2953, 64, 1, 38, "ExampleSection",
      CellTags->"Context::cxdup"],
    Cell[82270, 2956, 226, 5, 40, "Text",
      CellTags->"Context::cxdup"],
    Cell[82521, 2965, 99, 3, 26, "Input",
      CellTags->"Context::cxdup"],
    Cell[82623, 2970, 100, 3, 21, "Output",
      CellTags->"Context::cxdup"],
    Cell[82760, 2978, 126, 3, 26, "Input",
      CellTags->"Context::cxdup"],
    Cell[82889, 2983, 289, 6, 37, "Message",
      CellTags->"Context::cxdup"],
    Cell[83181, 2991, 99, 3, 21, "Output",
      CellTags->"Context::cxdup"]},
  "Context::cxname"->{
    Cell[83341, 3001, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Context::cxname"],
    Cell[83427, 3004, 383, 10, 21, "Message",
      CellTags->"Context::cxname"],
    Cell[83813, 3016, 392, 7, 62, "Notes",
      CellTags->"Context::cxname"],
    Cell[84230, 3027, 65, 1, 38, "ExampleSection",
      CellTags->"Context::cxname"],
    Cell[84298, 3030, 204, 5, 40, "Text",
      CellTags->"Context::cxname"],
    Cell[84527, 3039, 121, 3, 26, "Input",
      CellTags->"Context::cxname"],
    Cell[84651, 3044, 212, 5, 21, "Message",
      CellTags->"Context::cxname"],
    Cell[84866, 3051, 118, 3, 21, "Output",
      CellTags->"Context::cxname"],
    Cell[84999, 3057, 89, 1, 24, "Text",
      CellTags->"Context::cxname"],
    Cell[85113, 3062, 121, 3, 26, "Input",
      CellTags->"Context::cxname"],
    Cell[85237, 3067, 100, 3, 21, "Output",
      CellTags->"Context::cxname"],
    Cell[85352, 3073, 130, 4, 24, "Text",
      CellTags->"Context::cxname"],
    Cell[85507, 3081, 115, 3, 26, "Input",
      CellTags->"Context::cxname"],
    Cell[85625, 3086, 206, 5, 21, "Message",
      CellTags->"Context::cxname"],
    Cell[85834, 3093, 112, 3, 21, "Output",
      CellTags->"Context::cxname"]},
  "Context::cxset"->{
    Cell[86007, 3103, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[86136, 3109, 639, 19, 21, "Message",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[86778, 3130, 366, 7, 46, "Notes",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[87169, 3141, 85, 1, 38, "ExampleSection",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[87257, 3144, 240, 5, 40, "Text",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[87522, 3153, 132, 3, 26, "Input",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[87657, 3158, 267, 5, 37, "Message",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[87927, 3165, 118, 3, 21, "Output",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[88060, 3171, 268, 7, 40, "Text",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[88353, 3182, 133, 3, 26, "Input",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[88489, 3187, 119, 3, 21, "Output",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[88623, 3193, 115, 1, 24, "Text",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[88763, 3198, 132, 3, 26, "Input",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[88898, 3203, 118, 3, 21, "Output",
      CellTags->{"Context::cxset", "$Context::cxset"}]},
  "$Context::cxset"->{
    Cell[86007, 3103, 126, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[86136, 3109, 639, 19, 21, "Message",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[86778, 3130, 366, 7, 46, "Notes",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[87169, 3141, 85, 1, 38, "ExampleSection",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[87257, 3144, 240, 5, 40, "Text",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[87522, 3153, 132, 3, 26, "Input",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[87657, 3158, 267, 5, 37, "Message",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[87927, 3165, 118, 3, 21, "Output",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[88060, 3171, 268, 7, 40, "Text",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[88353, 3182, 133, 3, 26, "Input",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[88489, 3187, 119, 3, 21, "Output",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[88623, 3193, 115, 1, 24, "Text",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[88763, 3198, 132, 3, 26, "Input",
      CellTags->{"Context::cxset", "$Context::cxset"}],
    Cell[88898, 3203, 118, 3, 21, "Output",
      CellTags->{"Context::cxset", "$Context::cxset"}]},
  "ContextToFileName::cxfil"->{
    Cell[89077, 3213, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ContextToFileName::cxfil"],
    Cell[89181, 3216, 521, 14, 37, "Message",
      CellTags->"ContextToFileName::cxfil"],
    Cell[89705, 3232, 824, 19, 100, "Notes",
      CellTags->"ContextToFileName::cxfil"],
    Cell[90554, 3255, 74, 1, 38, "ExampleSection",
      CellTags->"ContextToFileName::cxfil"],
    Cell[90631, 3258, 199, 6, 24, "Text",
      CellTags->"ContextToFileName::cxfil"],
    Cell[90855, 3268, 193, 4, 74, "Input",
      CellTags->"ContextToFileName::cxfil"],
    Cell[91051, 3274, 269, 5, 37, "Message",
      CellTags->"ContextToFileName::cxfil"],
    Cell[91323, 3281, 174, 4, 21, "Message",
      CellTags->"ContextToFileName::cxfil"],
    Cell[91500, 3287, 215, 5, 21, "Message",
      CellTags->"ContextToFileName::cxfil"],
    Cell[91718, 3294, 105, 3, 21, "Output",
      CellTags->"ContextToFileName::cxfil"]},
  "Continue::nofwd"->{
    Cell[91884, 3304, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Continue::nofwd"],
    Cell[91970, 3307, 254, 5, 21, "Message",
      CellTags->"Continue::nofwd"],
    Cell[92227, 3314, 193, 5, 24, "Notes",
      CellTags->"Continue::nofwd"]},
  "Debug::dbug"->{
    Cell[92457, 3324, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Debug::dbug"],
    Cell[92535, 3327, 175, 3, 21, "Message",
      CellTags->"Debug::dbug"],
    Cell[92713, 3332, 456, 13, 68, "Notes",
      CellTags->"Debug::dbug"]},
  "DeclarePackage::aldec"->{
    Cell[93206, 3350, 95, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DeclarePackage::aldec"],
    Cell[93304, 3353, 341, 9, 21, "Message",
      CellTags->"DeclarePackage::aldec"],
    Cell[93648, 3364, 441, 9, 62, "Notes",
      CellTags->"DeclarePackage::aldec"],
    Cell[94114, 3377, 71, 1, 38, "ExampleSection",
      CellTags->"DeclarePackage::aldec"],
    Cell[94188, 3380, 230, 5, 40, "Text",
      CellTags->"DeclarePackage::aldec"],
    Cell[94443, 3389, 118, 3, 26, "Input",
      CellTags->"DeclarePackage::aldec"],
    Cell[94564, 3394, 119, 3, 21, "Output",
      CellTags->"DeclarePackage::aldec"],
    Cell[94720, 3402, 148, 3, 26, "Input",
      CellTags->"DeclarePackage::aldec"],
    Cell[94871, 3407, 277, 5, 37, "Message",
      CellTags->"DeclarePackage::aldec"],
    Cell[95151, 3414, 108, 3, 21, "Output",
      CellTags->"DeclarePackage::aldec"]},
  "DefineExternal::des"->{
    Cell[95320, 3424, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"DefineExternal::des"],
    Cell[95414, 3427, 644, 14, 53, "Message",
      CellTags->"DefineExternal::des"],
    Cell[96061, 3443, 866, 23, 122, "Notes",
      CellTags->"DefineExternal::des"],
    Cell[96952, 3470, 69, 1, 38, "ExampleSection",
      CellTags->"DefineExternal::des"],
    Cell[97024, 3473, 344, 8, 40, "Text",
      CellTags->"DefineExternal::des"],
    Cell[97393, 3485, 141, 3, 26, "Input",
      CellTags->"DefineExternal::des"],
    Cell[97537, 3490, 196, 5, 36, "Message",
      CellTags->"DefineExternal::des"],
    Cell[97736, 3497, 572, 10, 69, "Message",
      CellTags->"DefineExternal::des"]},
  "Dialog::dpa"->{
    Cell[98369, 3514, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Dialog::dpa"],
    Cell[98447, 3517, 268, 5, 21, "Message",
      CellTags->"Dialog::dpa"],
    Cell[98718, 3524, 319, 7, 46, "Notes",
      CellTags->"Dialog::dpa"]},
  "Dialog::exd"->{
    Cell[99074, 3536, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Dialog::exd"],
    Cell[99152, 3539, 252, 5, 37, "Message",
      CellTags->"Dialog::exd"],
    Cell[99407, 3546, 433, 16, 46, "Notes",
      CellTags->"Dialog::exd"],
    Cell[99865, 3566, 61, 1, 38, "ExampleSection",
      CellTags->"Dialog::exd"],
    Cell[99929, 3569, 193, 7, 24, "Text",
      CellTags->"Dialog::exd"],
    Cell[100147, 3580, 92, 3, 26, "Input",
      CellTags->"Dialog::exd"],
    Cell[100242, 3585, 89, 3, 21, "Output",
      CellTags->"Dialog::exd"],
    Cell[100368, 3593, 97, 3, 26, "Input",
      CellTags->"Dialog::exd"],
    Cell[100468, 3598, 241, 5, 37, "Message",
      CellTags->"Dialog::exd"],
    Cell[100712, 3605, 98, 3, 21, "Output",
      CellTags->"Dialog::exd"],
    Cell[100825, 3611, 128, 5, 24, "Text",
      CellTags->"Dialog::exd"],
    Cell[100956, 3618, 105, 3, 26, "Input",
      CellTags->"Dialog::exd"]},
  "DownValues::itloc"->{
    Cell[101110, 3627, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[101488, 3642, 773, 21, 37, "Message",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102264, 3665, 659, 17, 68, "Notes",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102948, 3686, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103176, 3692, 357, 8, 40, "Text",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103558, 3704, 305, 6, 26, "Input",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103866, 3712, 423, 8, 39, "Message",
      CellTags->{
      "DefaultValues::itloc", "DownValues::itloc", "FormatValues::itloc", 
        "Messages::itloc", "NValues::itloc", "OwnValues::itloc", 
        "SubValues::itloc", "UpValues::itloc"}]},
  "UpValues::itloc"->{
    Cell[101110, 3627, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[101488, 3642, 773, 21, 37, "Message",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102264, 3665, 659, 17, 68, "Notes",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102948, 3686, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103176, 3692, 357, 8, 40, "Text",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103558, 3704, 305, 6, 26, "Input",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103866, 3712, 423, 8, 39, "Message",
      CellTags->{
      "DefaultValues::itloc", "DownValues::itloc", "FormatValues::itloc", 
        "Messages::itloc", "NValues::itloc", "OwnValues::itloc", 
        "SubValues::itloc", "UpValues::itloc"}]},
  "OwnValues::itloc"->{
    Cell[101110, 3627, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[101488, 3642, 773, 21, 37, "Message",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102264, 3665, 659, 17, 68, "Notes",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102948, 3686, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103176, 3692, 357, 8, 40, "Text",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103558, 3704, 305, 6, 26, "Input",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103866, 3712, 423, 8, 39, "Message",
      CellTags->{
      "DefaultValues::itloc", "DownValues::itloc", "FormatValues::itloc", 
        "Messages::itloc", "NValues::itloc", "OwnValues::itloc", 
        "SubValues::itloc", "UpValues::itloc"}]},
  "FormatValues::itloc"->{
    Cell[101110, 3627, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[101488, 3642, 773, 21, 37, "Message",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102264, 3665, 659, 17, 68, "Notes",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102948, 3686, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103176, 3692, 357, 8, 40, "Text",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103558, 3704, 305, 6, 26, "Input",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103866, 3712, 423, 8, 39, "Message",
      CellTags->{
      "DefaultValues::itloc", "DownValues::itloc", "FormatValues::itloc", 
        "Messages::itloc", "NValues::itloc", "OwnValues::itloc", 
        "SubValues::itloc", "UpValues::itloc"}]},
  "DefaultValues::itloc"->{
    Cell[101110, 3627, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[101488, 3642, 773, 21, 37, "Message",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102264, 3665, 659, 17, 68, "Notes",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102948, 3686, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103176, 3692, 357, 8, 40, "Text",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103558, 3704, 305, 6, 26, "Input",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103866, 3712, 423, 8, 39, "Message",
      CellTags->{
      "DefaultValues::itloc", "DownValues::itloc", "FormatValues::itloc", 
        "Messages::itloc", "NValues::itloc", "OwnValues::itloc", 
        "SubValues::itloc", "UpValues::itloc"}]},
  "NValues::itloc"->{
    Cell[101110, 3627, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[101488, 3642, 773, 21, 37, "Message",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102264, 3665, 659, 17, 68, "Notes",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102948, 3686, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103176, 3692, 357, 8, 40, "Text",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103558, 3704, 305, 6, 26, "Input",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103866, 3712, 423, 8, 39, "Message",
      CellTags->{
      "DefaultValues::itloc", "DownValues::itloc", "FormatValues::itloc", 
        "Messages::itloc", "NValues::itloc", "OwnValues::itloc", 
        "SubValues::itloc", "UpValues::itloc"}]},
  "Messages::itloc"->{
    Cell[101110, 3627, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[101488, 3642, 773, 21, 37, "Message",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102264, 3665, 659, 17, 68, "Notes",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102948, 3686, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103176, 3692, 357, 8, 40, "Text",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103558, 3704, 305, 6, 26, "Input",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103866, 3712, 423, 8, 39, "Message",
      CellTags->{
      "DefaultValues::itloc", "DownValues::itloc", "FormatValues::itloc", 
        "Messages::itloc", "NValues::itloc", "OwnValues::itloc", 
        "SubValues::itloc", "UpValues::itloc"}]},
  "SubValues::itloc"->{
    Cell[101110, 3627, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[101488, 3642, 773, 21, 37, "Message",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102264, 3665, 659, 17, 68, "Notes",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[102948, 3686, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103176, 3692, 357, 8, 40, "Text",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103558, 3704, 305, 6, 26, "Input",
      CellTags->{
      "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
        "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
        "Messages::itloc", "SubValues::itloc"}],
    Cell[103866, 3712, 423, 8, 39, "Message",
      CellTags->{
      "DefaultValues::itloc", "DownValues::itloc", "FormatValues::itloc", 
        "Messages::itloc", "NValues::itloc", "OwnValues::itloc", 
        "SubValues::itloc", "UpValues::itloc"}]},
  "DownValues::vlist"->{
    Cell[104350, 3727, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[104728, 3742, 619, 18, 21, "Message",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[105350, 3762, 686, 13, 90, "Notes",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106061, 3779, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106289, 3785, 318, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106632, 3796, 286, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106921, 3804, 392, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107316, 3814, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107597, 3823, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[107888, 3831, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108216, 3841, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[108541, 3851, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108844, 3862, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109128, 3870, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[109409, 3879, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109712, 3890, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109977, 3898, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}]},
  "UpValues::vlist"->{
    Cell[104350, 3727, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[104728, 3742, 619, 18, 21, "Message",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[105350, 3762, 686, 13, 90, "Notes",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106061, 3779, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106289, 3785, 318, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106632, 3796, 286, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106921, 3804, 392, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107316, 3814, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107597, 3823, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[107888, 3831, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108216, 3841, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[108541, 3851, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108844, 3862, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109128, 3870, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[109409, 3879, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109712, 3890, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109977, 3898, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}]},
  "OwnValues::vlist"->{
    Cell[104350, 3727, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[104728, 3742, 619, 18, 21, "Message",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[105350, 3762, 686, 13, 90, "Notes",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106061, 3779, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106289, 3785, 318, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106632, 3796, 286, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106921, 3804, 392, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107316, 3814, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107597, 3823, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[107888, 3831, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108216, 3841, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[108541, 3851, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108844, 3862, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109128, 3870, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[109409, 3879, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109712, 3890, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109977, 3898, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}]},
  "FormatValues::vlist"->{
    Cell[104350, 3727, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[104728, 3742, 619, 18, 21, "Message",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[105350, 3762, 686, 13, 90, "Notes",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106061, 3779, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106289, 3785, 318, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106632, 3796, 286, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106921, 3804, 392, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107316, 3814, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107597, 3823, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[107888, 3831, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108216, 3841, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[108541, 3851, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108844, 3862, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109128, 3870, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[109409, 3879, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109712, 3890, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109977, 3898, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}]},
  "DefaultValues::vlist"->{
    Cell[104350, 3727, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[104728, 3742, 619, 18, 21, "Message",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[105350, 3762, 686, 13, 90, "Notes",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106061, 3779, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106289, 3785, 318, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106632, 3796, 286, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106921, 3804, 392, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107316, 3814, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107597, 3823, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[107888, 3831, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108216, 3841, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[108541, 3851, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108844, 3862, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109128, 3870, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[109409, 3879, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109712, 3890, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109977, 3898, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}]},
  "NValues::vlist"->{
    Cell[104350, 3727, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[104728, 3742, 619, 18, 21, "Message",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[105350, 3762, 686, 13, 90, "Notes",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106061, 3779, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106289, 3785, 318, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106632, 3796, 286, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106921, 3804, 392, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107316, 3814, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107597, 3823, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[107888, 3831, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108216, 3841, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[108541, 3851, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108844, 3862, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109128, 3870, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[109409, 3879, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109712, 3890, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109977, 3898, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}]},
  "Messages::vlist"->{
    Cell[104350, 3727, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[104728, 3742, 619, 18, 21, "Message",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[105350, 3762, 686, 13, 90, "Notes",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106061, 3779, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106289, 3785, 318, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106632, 3796, 286, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106921, 3804, 392, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107316, 3814, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107597, 3823, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[107888, 3831, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108216, 3841, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[108541, 3851, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108844, 3862, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109128, 3870, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[109409, 3879, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109712, 3890, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109977, 3898, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}]},
  "SubValues::vlist"->{
    Cell[104350, 3727, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[104728, 3742, 619, 18, 21, "Message",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[105350, 3762, 686, 13, 90, "Notes",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106061, 3779, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106289, 3785, 318, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106632, 3796, 286, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[106921, 3804, 392, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107316, 3814, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[107597, 3823, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[107888, 3831, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108216, 3841, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[108541, 3851, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[108844, 3862, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109128, 3870, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}],
    Cell[109409, 3879, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109712, 3890, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
        "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
        "Messages::vlist", "SubValues::vlist"}],
    Cell[109977, 3898, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
        "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
        "SubValues::vlist", "UpValues::vlist"}]},
  "DownValues::vrule"->{
    Cell[110348, 3912, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[110726, 3927, 745, 21, 21, "Message",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[111474, 3950, 717, 13, 90, "Notes",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112216, 3967, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112444, 3973, 324, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112793, 3984, 288, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[113084, 3992, 426, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113513, 4002, 268, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113796, 4011, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114087, 4019, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114415, 4029, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[114740, 4039, 281, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115046, 4050, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115330, 4058, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[115611, 4067, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115914, 4078, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[116179, 4086, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}]},
  "UpValues::vrule"->{
    Cell[110348, 3912, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[110726, 3927, 745, 21, 21, "Message",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[111474, 3950, 717, 13, 90, "Notes",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112216, 3967, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112444, 3973, 324, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112793, 3984, 288, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[113084, 3992, 426, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113513, 4002, 268, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113796, 4011, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114087, 4019, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114415, 4029, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[114740, 4039, 281, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115046, 4050, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115330, 4058, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[115611, 4067, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115914, 4078, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[116179, 4086, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}]},
  "OwnValues::vrule"->{
    Cell[110348, 3912, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[110726, 3927, 745, 21, 21, "Message",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[111474, 3950, 717, 13, 90, "Notes",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112216, 3967, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112444, 3973, 324, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112793, 3984, 288, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[113084, 3992, 426, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113513, 4002, 268, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113796, 4011, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114087, 4019, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114415, 4029, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[114740, 4039, 281, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115046, 4050, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115330, 4058, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[115611, 4067, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115914, 4078, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[116179, 4086, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}]},
  "FormatValues::vrule"->{
    Cell[110348, 3912, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[110726, 3927, 745, 21, 21, "Message",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[111474, 3950, 717, 13, 90, "Notes",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112216, 3967, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112444, 3973, 324, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112793, 3984, 288, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[113084, 3992, 426, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113513, 4002, 268, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113796, 4011, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114087, 4019, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114415, 4029, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[114740, 4039, 281, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115046, 4050, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115330, 4058, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[115611, 4067, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115914, 4078, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[116179, 4086, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}]},
  "DefaultValues::vrule"->{
    Cell[110348, 3912, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[110726, 3927, 745, 21, 21, "Message",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[111474, 3950, 717, 13, 90, "Notes",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112216, 3967, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112444, 3973, 324, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112793, 3984, 288, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[113084, 3992, 426, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113513, 4002, 268, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113796, 4011, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114087, 4019, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114415, 4029, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[114740, 4039, 281, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115046, 4050, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115330, 4058, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[115611, 4067, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115914, 4078, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[116179, 4086, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}]},
  "NValues::vrule"->{
    Cell[110348, 3912, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[110726, 3927, 745, 21, 21, "Message",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[111474, 3950, 717, 13, 90, "Notes",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112216, 3967, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112444, 3973, 324, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112793, 3984, 288, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[113084, 3992, 426, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113513, 4002, 268, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113796, 4011, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114087, 4019, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114415, 4029, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[114740, 4039, 281, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115046, 4050, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115330, 4058, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[115611, 4067, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115914, 4078, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[116179, 4086, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}]},
  "Messages::vrule"->{
    Cell[110348, 3912, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[110726, 3927, 745, 21, 21, "Message",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[111474, 3950, 717, 13, 90, "Notes",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112216, 3967, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112444, 3973, 324, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112793, 3984, 288, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[113084, 3992, 426, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113513, 4002, 268, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113796, 4011, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114087, 4019, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114415, 4029, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[114740, 4039, 281, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115046, 4050, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115330, 4058, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[115611, 4067, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115914, 4078, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[116179, 4086, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}]},
  "SubValues::vrule"->{
    Cell[110348, 3912, 375, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[110726, 3927, 745, 21, 21, "Message",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[111474, 3950, 717, 13, 90, "Notes",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112216, 3967, 225, 4, 38, "ExampleSection",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112444, 3973, 324, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[112793, 3984, 288, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[113084, 3992, 426, 8, 37, "Message",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113513, 4002, 268, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[113796, 4011, 266, 4, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114087, 4019, 325, 8, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[114415, 4029, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[114740, 4039, 281, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115046, 4050, 281, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115330, 4058, 266, 6, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}],
    Cell[115611, 4067, 278, 7, 24, "Text",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[115914, 4078, 262, 6, 26, "Input",
      CellTags->{
      "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
        "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
        "Messages::vrule", "SubValues::vrule"}],
    Cell[116179, 4086, 310, 7, 21, "Output",
      CellTags->{
      "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
        "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
        "SubValues::vrule", "UpValues::vrule"}]},
  "EditDefinition::edsym"->{
    Cell[116550, 4100, 95, 1, 31, "ObjectNameWarningMessages",
      CellTags->"EditDefinition::edsym"],
    Cell[116648, 4103, 208, 4, 21, "Message",
      CellTags->"EditDefinition::edsym"],
    Cell[116859, 4109, 546, 14, 62, "Notes",
      CellTags->"EditDefinition::edsym"],
    Cell[117430, 4127, 71, 1, 38, "ExampleSection",
      CellTags->"EditDefinition::edsym"],
    Cell[117504, 4130, 203, 5, 24, "Text",
      CellTags->"EditDefinition::edsym"],
    Cell[117732, 4139, 111, 3, 26, "Input",
      CellTags->"EditDefinition::edsym"],
    Cell[117846, 4144, 174, 4, 21, "Message",
      CellTags->"EditDefinition::edsym"],
    Cell[118023, 4150, 112, 3, 21, "Output",
      CellTags->"EditDefinition::edsym"]},
  "End::noctx"->{
    Cell[118196, 4160, 153, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[118352, 4167, 269, 7, 21, "Message",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[118624, 4176, 643, 24, 62, "Notes",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[119292, 4204, 100, 1, 38, "ExampleSection",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[119395, 4207, 329, 10, 40, "Text",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[119749, 4221, 128, 3, 26, "Input",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[119880, 4226, 196, 4, 21, "Message",
      CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}],
    Cell[120079, 4232, 133, 3, 21, "Output",
      CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}],
    Cell[120227, 4238, 225, 7, 24, "Text",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[120477, 4249, 147, 3, 26, "Input",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[120627, 4254, 137, 3, 21, "Output",
      CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}],
    Cell[120801, 4262, 128, 3, 26, "Input",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[120932, 4267, 137, 3, 21, "Output",
      CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}]},
  "EndAdd::noctx"->{
    Cell[118196, 4160, 153, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[118352, 4167, 269, 7, 21, "Message",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[118624, 4176, 643, 24, 62, "Notes",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[119292, 4204, 100, 1, 38, "ExampleSection",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[119395, 4207, 329, 10, 40, "Text",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[119749, 4221, 128, 3, 26, "Input",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[119880, 4226, 196, 4, 21, "Message",
      CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}],
    Cell[120079, 4232, 133, 3, 21, "Output",
      CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}],
    Cell[120227, 4238, 225, 7, 24, "Text",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[120477, 4249, 147, 3, 26, "Input",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[120627, 4254, 137, 3, 21, "Output",
      CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}],
    Cell[120801, 4262, 128, 3, 26, "Input",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[120932, 4267, 137, 3, 21, "Output",
      CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}]},
  "EndPackage::noctx"->{
    Cell[118196, 4160, 153, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[118352, 4167, 269, 7, 21, "Message",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[118624, 4176, 643, 24, 62, "Notes",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[119292, 4204, 100, 1, 38, "ExampleSection",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[119395, 4207, 329, 10, 40, "Text",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[119749, 4221, 128, 3, 26, "Input",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[119880, 4226, 196, 4, 21, "Message",
      CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}],
    Cell[120079, 4232, 133, 3, 21, "Output",
      CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}],
    Cell[120227, 4238, 225, 7, 24, "Text",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[120477, 4249, 147, 3, 26, "Input",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[120627, 4254, 137, 3, 21, "Output",
      CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}],
    Cell[120801, 4262, 128, 3, 26, "Input",
      CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
    Cell[120932, 4267, 137, 3, 21, "Output",
      CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}]},
  "ExitDialog::cant"->{
    Cell[121130, 4277, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ExitDialog::cant"],
    Cell[121218, 4280, 147, 3, 21, "Message",
      CellTags->"ExitDialog::cant"],
    Cell[121368, 4285, 278, 7, 46, "Notes",
      CellTags->"ExitDialog::cant"],
    Cell[121671, 4296, 66, 1, 38, "ExampleSection",
      CellTags->"ExitDialog::cant"],
    Cell[121740, 4299, 146, 5, 24, "Text",
      CellTags->"ExitDialog::cant"],
    Cell[121911, 4308, 97, 3, 26, "Input",
      CellTags->"ExitDialog::cant"],
    Cell[122011, 4313, 91, 3, 21, "Output",
      CellTags->"ExitDialog::cant"],
    Cell[122139, 4321, 103, 3, 26, "Input",
      CellTags->"ExitDialog::cant"],
    Cell[122245, 4326, 100, 3, 21, "Output",
      CellTags->"ExitDialog::cant"],
    Cell[122360, 4332, 110, 3, 26, "Input",
      CellTags->"ExitDialog::cant"],
    Cell[122473, 4337, 172, 5, 24, "Text",
      CellTags->"ExitDialog::cant"],
    Cell[122670, 4346, 101, 3, 26, "Input",
      CellTags->"ExitDialog::cant"],
    Cell[122774, 4351, 163, 4, 21, "Message",
      CellTags->"ExitDialog::cant"],
    Cell[122940, 4357, 102, 3, 21, "Output",
      CellTags->"ExitDialog::cant"]},
  "Return::obs"->{
    Cell[123103, 4367, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Return::obs"],
    Cell[123181, 4370, 434, 8, 69, "Message",
      CellTags->"Return::obs"],
    Cell[123618, 4380, 122, 4, 24, "Notes",
      CellTags->"Return::obs"]},
  "FrontEndObject::notavail"->{
    Cell[123777, 4389, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FrontEndObject::notavail"],
    Cell[123881, 4392, 229, 5, 37, "Message",
      CellTags->"FrontEndObject::notavail"],
    Cell[124113, 4399, 858, 20, 116, "Notes",
      CellTags->"FrontEndObject::notavail"]},
  "Function::attf"->{
    Cell[125008, 4424, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Function::attf"],
    Cell[125092, 4427, 343, 9, 21, "Message",
      CellTags->"Function::attf"],
    Cell[125438, 4438, 711, 25, 84, "Notes",
      CellTags->"Function::attf"],
    Cell[126174, 4467, 64, 1, 38, "ExampleSection",
      CellTags->"Function::attf"],
    Cell[126241, 4470, 216, 7, 24, "Text",
      CellTags->"Function::attf"],
    Cell[126482, 4481, 130, 3, 26, "Input",
      CellTags->"Function::attf"],
    Cell[126615, 4486, 252, 5, 37, "Message",
      CellTags->"Function::attf"],
    Cell[126870, 4493, 252, 5, 37, "Message",
      CellTags->"Function::attf"],
    Cell[127125, 4500, 127, 3, 21, "Output",
      CellTags->"Function::attf"],
    Cell[127267, 4506, 141, 5, 24, "Text",
      CellTags->"Function::attf"],
    Cell[127433, 4515, 132, 3, 26, "Input",
      CellTags->"Function::attf"],
    Cell[127568, 4520, 103, 3, 21, "Output",
      CellTags->"Function::attf"]},
  "Function::fdup"->{
    Cell[127732, 4530, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[127857, 4536, 445, 14, 21, "Message",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[128305, 4552, 268, 8, 24, "Notes",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[128598, 4564, 83, 1, 38, "ExampleSection",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[128684, 4567, 159, 4, 24, "Text",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[128868, 4575, 139, 3, 26, "Input",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[129010, 4580, 205, 4, 21, "Message",
      CellTags->{"Compile::fdup", "Function::fdup"}],
    Cell[129218, 4586, 205, 4, 21, "Message",
      CellTags->{"Compile::fdup", "Function::fdup"}],
    Cell[129426, 4592, 140, 3, 21, "Output",
      CellTags->{"Compile::fdup", "Function::fdup"}],
    Cell[129581, 4598, 154, 5, 24, "Text",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[129760, 4607, 139, 3, 26, "Input",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[129902, 4612, 108, 3, 21, "Output",
      CellTags->{"Compile::fdup", "Function::fdup"}]},
  "Compile::fdup"->{
    Cell[127732, 4530, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[127857, 4536, 445, 14, 21, "Message",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[128305, 4552, 268, 8, 24, "Notes",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[128598, 4564, 83, 1, 38, "ExampleSection",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[128684, 4567, 159, 4, 24, "Text",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[128868, 4575, 139, 3, 26, "Input",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[129010, 4580, 205, 4, 21, "Message",
      CellTags->{"Compile::fdup", "Function::fdup"}],
    Cell[129218, 4586, 205, 4, 21, "Message",
      CellTags->{"Compile::fdup", "Function::fdup"}],
    Cell[129426, 4592, 140, 3, 21, "Output",
      CellTags->{"Compile::fdup", "Function::fdup"}],
    Cell[129581, 4598, 154, 5, 24, "Text",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[129760, 4607, 139, 3, 26, "Input",
      CellTags->{"Function::fdup", "Compile::fdup"}],
    Cell[129902, 4612, 108, 3, 21, "Output",
      CellTags->{"Compile::fdup", "Function::fdup"}]},
  "Function::fdups"->{
    Cell[130071, 4622, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Function::fdups"],
    Cell[130157, 4625, 394, 12, 21, "Message",
      CellTags->"Function::fdups"],
    Cell[130554, 4639, 679, 17, 100, "Notes",
      CellTags->"Function::fdups"],
    Cell[131258, 4660, 65, 1, 38, "ExampleSection",
      CellTags->"Function::fdups"],
    Cell[131326, 4663, 129, 4, 24, "Text",
      CellTags->"Function::fdups"],
    Cell[131480, 4671, 123, 3, 26, "Input",
      CellTags->"Function::fdups"],
    Cell[131606, 4676, 207, 5, 21, "Message",
      CellTags->"Function::fdups"],
    Cell[131816, 4683, 207, 5, 21, "Message",
      CellTags->"Function::fdups"],
    Cell[132026, 4690, 124, 3, 21, "Output",
      CellTags->"Function::fdups"],
    Cell[132165, 4696, 144, 5, 24, "Text",
      CellTags->"Function::fdups"],
    Cell[132334, 4705, 121, 3, 26, "Input",
      CellTags->"Function::fdups"],
    Cell[132458, 4710, 90, 3, 21, "Output",
      CellTags->"Function::fdups"]},
  "Function::flpar"->{
    Cell[132609, 4720, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Function::flpar"],
    Cell[132695, 4723, 378, 10, 37, "Message",
      CellTags->"Function::flpar"],
    Cell[133076, 4735, 518, 12, 62, "Notes",
      CellTags->"Function::flpar"],
    Cell[133619, 4751, 65, 1, 38, "ExampleSection",
      CellTags->"Function::flpar"],
    Cell[133687, 4754, 199, 5, 24, "Text",
      CellTags->"Function::flpar"],
    Cell[133911, 4763, 119, 3, 26, "Input",
      CellTags->"Function::flpar"],
    Cell[134033, 4768, 283, 6, 37, "Message",
      CellTags->"Function::flpar"],
    Cell[134319, 4776, 283, 6, 37, "Message",
      CellTags->"Function::flpar"],
    Cell[134605, 4784, 120, 3, 21, "Output",
      CellTags->"Function::flpar"],
    Cell[134740, 4790, 146, 5, 24, "Text",
      CellTags->"Function::flpar"],
    Cell[134911, 4799, 115, 3, 26, "Input",
      CellTags->"Function::flpar"],
    Cell[135029, 4804, 90, 3, 21, "Output",
      CellTags->"Function::flpar"]},
  "Remove::rmnsm"->{
    Cell[135180, 4814, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Remove::rmnsm"],
    Cell[135262, 4817, 173, 4, 21, "Message",
      CellTags->"Remove::rmnsm"],
    Cell[135438, 4823, 220, 5, 24, "Notes",
      CellTags->"Remove::rmnsm"],
    Cell[135683, 4832, 63, 1, 38, "ExampleSection",
      CellTags->"Remove::rmnsm"],
    Cell[135749, 4835, 204, 6, 24, "Text",
      CellTags->"Remove::rmnsm"],
    Cell[135978, 4845, 109, 3, 26, "Input",
      CellTags->"Remove::rmnsm"],
    Cell[136090, 4850, 188, 4, 21, "Message",
      CellTags->"Remove::rmnsm"]},
  "Function::fpct"->{
    Cell[136339, 4861, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Function::fpct"],
    Cell[136423, 4864, 330, 8, 21, "Message",
      CellTags->"Function::fpct"],
    Cell[136756, 4874, 242, 6, 40, "Notes",
      CellTags->"Function::fpct"],
    Cell[137023, 4884, 64, 1, 38, "ExampleSection",
      CellTags->"Function::fpct"],
    Cell[137090, 4887, 289, 8, 40, "Text",
      CellTags->"Function::fpct"],
    Cell[137404, 4899, 127, 3, 26, "Input",
      CellTags->"Function::fpct"],
    Cell[137534, 4904, 280, 6, 37, "Message",
      CellTags->"Function::fpct"],
    Cell[137817, 4912, 128, 3, 21, "Output",
      CellTags->"Function::fpct"],
    Cell[137960, 4918, 143, 5, 24, "Text",
      CellTags->"Function::fpct"],
    Cell[138128, 4927, 130, 3, 26, "Input",
      CellTags->"Function::fpct"],
    Cell[138261, 4932, 90, 3, 21, "Output",
      CellTags->"Function::fpct"]},
  "Function::slot"->{
    Cell[138412, 4942, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Function::slot"],
    Cell[138496, 4945, 444, 13, 21, "Message",
      CellTags->"Function::slot"],
    Cell[138943, 4960, 631, 16, 84, "Notes",
      CellTags->"Function::slot"],
    Cell[139599, 4980, 64, 1, 38, "ExampleSection",
      CellTags->"Function::slot"],
    Cell[139666, 4983, 153, 4, 24, "Text",
      CellTags->"Function::slot"],
    Cell[139844, 4991, 96, 3, 26, "Input",
      CellTags->"Function::slot"],
    Cell[139943, 4996, 219, 5, 21, "Message",
      CellTags->"Function::slot"],
    Cell[140165, 5003, 97, 3, 21, "Output",
      CellTags->"Function::slot"],
    Cell[140277, 5009, 221, 5, 40, "Text",
      CellTags->"Function::slot"],
    Cell[140523, 5018, 112, 3, 26, "Input",
      CellTags->"Function::slot"],
    Cell[140638, 5023, 219, 5, 21, "Message",
      CellTags->"Function::slot"],
    Cell[140860, 5030, 219, 5, 21, "Message",
      CellTags->"Function::slot"],
    Cell[141082, 5037, 97, 3, 21, "Output",
      CellTags->"Function::slot"],
    Cell[141194, 5043, 182, 7, 24, "Text",
      CellTags->"Function::slot"],
    Cell[141401, 5054, 96, 3, 26, "Input",
      CellTags->"Function::slot"],
    Cell[141500, 5059, 92, 3, 21, "Output",
      CellTags->"Function::slot"],
    Cell[141629, 5067, 122, 3, 26, "Input",
      CellTags->"Function::slot"],
    Cell[141754, 5072, 92, 3, 21, "Output",
      CellTags->"Function::slot"],
    Cell[141883, 5080, 111, 3, 26, "Input",
      CellTags->"Function::slot"],
    Cell[141997, 5085, 92, 3, 21, "Output",
      CellTags->"Function::slot"]},
  "Function::slotn"->{
    Cell[142150, 5095, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Function::slotn"],
    Cell[142236, 5098, 412, 12, 21, "Message",
      CellTags->"Function::slotn"],
    Cell[142651, 5112, 575, 19, 46, "Notes",
      CellTags->"Function::slotn"],
    Cell[143251, 5135, 65, 1, 38, "ExampleSection",
      CellTags->"Function::slotn"],
    Cell[143319, 5138, 282, 7, 40, "Text",
      CellTags->"Function::slotn"],
    Cell[143626, 5149, 115, 3, 26, "Input",
      CellTags->"Function::slotn"],
    Cell[143744, 5154, 250, 5, 21, "Message",
      CellTags->"Function::slotn"],
    Cell[143997, 5161, 95, 3, 21, "Output",
      CellTags->"Function::slotn"],
    Cell[144107, 5167, 191, 7, 24, "Text",
      CellTags->"Function::slotn"],
    Cell[144323, 5178, 118, 3, 26, "Input",
      CellTags->"Function::slotn"],
    Cell[144444, 5183, 91, 3, 21, "Output",
      CellTags->"Function::slotn"]},
  "Function::slotp"->{
    Cell[144596, 5193, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Function::slotp"],
    Cell[144682, 5196, 322, 7, 21, "Message",
      CellTags->"Function::slotp"],
    Cell[145007, 5205, 895, 26, 84, "Notes",
      CellTags->"Function::slotp"],
    Cell[145927, 5235, 65, 1, 38, "ExampleSection",
      CellTags->"Function::slotp"],
    Cell[145995, 5238, 178, 5, 24, "Text",
      CellTags->"Function::slotp"],
    Cell[146198, 5247, 118, 3, 26, "Input",
      CellTags->"Function::slotp"],
    Cell[146319, 5252, 255, 6, 37, "Message",
      CellTags->"Function::slotp"],
    Cell[146577, 5260, 114, 3, 21, "Output",
      CellTags->"Function::slotp"],
    Cell[146706, 5266, 230, 5, 40, "Text",
      CellTags->"Function::slotp"],
    Cell[146961, 5275, 128, 3, 26, "Input",
      CellTags->"Function::slotp"],
    Cell[147092, 5280, 255, 6, 37, "Message",
      CellTags->"Function::slotp"],
    Cell[147350, 5288, 255, 6, 37, "Message",
      CellTags->"Function::slotp"],
    Cell[147608, 5296, 114, 3, 21, "Output",
      CellTags->"Function::slotp"],
    Cell[147737, 5302, 191, 7, 24, "Text",
      CellTags->"Function::slotp"],
    Cell[147953, 5313, 113, 3, 26, "Input",
      CellTags->"Function::slotp"],
    Cell[148069, 5318, 102, 3, 21, "Output",
      CellTags->"Function::slotp"],
    Cell[148208, 5326, 139, 3, 26, "Input",
      CellTags->"Function::slotp"],
    Cell[148350, 5331, 102, 3, 21, "Output",
      CellTags->"Function::slotp"],
    Cell[148489, 5339, 128, 3, 26, "Input",
      CellTags->"Function::slotp"],
    Cell[148620, 5344, 102, 3, 21, "Output",
      CellTags->"Function::slotp"]},
  "Function::slots"->{
    Cell[148783, 5354, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Function::slots"],
    Cell[148869, 5357, 375, 10, 21, "Message",
      CellTags->"Function::slots"],
    Cell[149247, 5369, 597, 20, 62, "Notes",
      CellTags->"Function::slots"],
    Cell[149869, 5393, 65, 1, 38, "ExampleSection",
      CellTags->"Function::slots"],
    Cell[149937, 5396, 358, 10, 40, "Text",
      CellTags->"Function::slots"],
    Cell[150320, 5410, 113, 3, 26, "Input",
      CellTags->"Function::slots"],
    Cell[150436, 5415, 278, 6, 37, "Message",
      CellTags->"Function::slots"],
    Cell[150717, 5423, 99, 3, 21, "Output",
      CellTags->"Function::slots"],
    Cell[150831, 5429, 147, 5, 24, "Text",
      CellTags->"Function::slots"],
    Cell[151003, 5438, 122, 3, 26, "Input",
      CellTags->"Function::slots"],
    Cell[151128, 5443, 100, 3, 21, "Output",
      CellTags->"Function::slots"]},
  "Goto::nolabel"->{
    Cell[151289, 5453, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Goto::nolabel"],
    Cell[151371, 5456, 205, 4, 21, "Message",
      CellTags->"Goto::nolabel"],
    Cell[151579, 5462, 217, 7, 24, "Notes",
      CellTags->"Goto::nolabel"],
    Cell[151821, 5473, 63, 1, 38, "ExampleSection",
      CellTags->"Goto::nolabel"],
    Cell[151887, 5476, 233, 7, 24, "Text",
      CellTags->"Goto::nolabel"],
    Cell[152145, 5487, 229, 5, 122, "Input",
      CellTags->"Goto::nolabel"],
    Cell[152377, 5494, 189, 5, 21, "Print",
      CellTags->"Goto::nolabel"],
    Cell[152569, 5501, 164, 4, 21, "Message",
      CellTags->"Goto::nolabel"],
    Cell[152736, 5507, 104, 3, 21, "Output",
      CellTags->"Goto::nolabel"],
    Cell[152855, 5513, 158, 7, 24, "Text",
      CellTags->"Goto::nolabel"],
    Cell[153038, 5524, 229, 5, 122, "Input",
      CellTags->"Goto::nolabel"],
    Cell[153270, 5531, 189, 5, 21, "Print",
      CellTags->"Goto::nolabel"],
    Cell[153462, 5538, 189, 5, 21, "Print",
      CellTags->"Goto::nolabel"],
    Cell[153654, 5545, 189, 5, 21, "Print",
      CellTags->"Goto::nolabel"],
    Cell[153846, 5552, 93, 3, 21, "Output",
      CellTags->"Goto::nolabel"]},
  "Interrupt::dgbgn"->{
    Cell[154000, 5562, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[154139, 5568, 277, 7, 21, "Message",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[154419, 5577, 494, 9, 84, "Notes",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[154938, 5590, 90, 1, 38, "ExampleSection",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[155031, 5593, 300, 8, 40, "Text",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[155356, 5605, 149, 3, 26, "Input",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[155508, 5610, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[155630, 5615, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[155752, 5620, 204, 4, 21, "Message",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[155959, 5626, 137, 4, 21, "Output",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[156099, 5632, 174, 3, 21, "Message",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[156276, 5637, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[156398, 5642, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[156520, 5647, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[156654, 5653, 134, 3, 26, "Input",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}]},
  "TraceDialog::dgbgn"->{
    Cell[154000, 5562, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[154139, 5568, 277, 7, 21, "Message",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[154419, 5577, 494, 9, 84, "Notes",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[154938, 5590, 90, 1, 38, "ExampleSection",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[155031, 5593, 300, 8, 40, "Text",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[155356, 5605, 149, 3, 26, "Input",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[155508, 5610, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[155630, 5615, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[155752, 5620, 204, 4, 21, "Message",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[155959, 5626, 137, 4, 21, "Output",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[156099, 5632, 174, 3, 21, "Message",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[156276, 5637, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[156398, 5642, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[156520, 5647, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
    Cell[156654, 5653, 134, 3, 26, "Input",
      CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}]},
  "Interrupt::dgend"->{
    Cell[156837, 5662, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[156976, 5668, 319, 10, 21, "Message",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[157298, 5680, 510, 9, 100, "Notes",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[157833, 5693, 90, 1, 38, "ExampleSection",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[157926, 5696, 300, 8, 40, "Text",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[158251, 5708, 149, 3, 26, "Input",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[158403, 5713, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[158525, 5718, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[158647, 5723, 204, 4, 21, "Message",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[158854, 5729, 137, 4, 21, "Output",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[158994, 5735, 174, 3, 21, "Message",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[159171, 5740, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[159293, 5745, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[159415, 5750, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[159549, 5756, 134, 3, 26, "Input",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}]},
  "TraceDialog::dgend"->{
    Cell[156837, 5662, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[156976, 5668, 319, 10, 21, "Message",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[157298, 5680, 510, 9, 100, "Notes",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[157833, 5693, 90, 1, 38, "ExampleSection",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[157926, 5696, 300, 8, 40, "Text",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[158251, 5708, 149, 3, 26, "Input",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[158403, 5713, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[158525, 5718, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[158647, 5723, 204, 4, 21, "Message",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[158854, 5729, 137, 4, 21, "Output",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[158994, 5735, 174, 3, 21, "Message",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[159171, 5740, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[159293, 5745, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[159415, 5750, 119, 3, 21, "Print",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
    Cell[159549, 5756, 134, 3, 26, "Input",
      CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}]},
  "LinkConnect::linkc"->{
    Cell[159732, 5765, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkConnect::linkc"],
    Cell[159824, 5768, 231, 5, 21, "Message",
      CellTags->"LinkConnect::linkc"],
    Cell[160058, 5775, 210, 6, 24, "Notes",
      CellTags->"LinkConnect::linkc"]},
  "LinkObject::linkd"->{
    Cell[160305, 5786, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkObject::linkd"],
    Cell[160395, 5789, 228, 5, 21, "Message",
      CellTags->"LinkObject::linkd"],
    Cell[160626, 5796, 209, 6, 24, "Notes",
      CellTags->"LinkObject::linkd"]},
  "LinkOpen::linke"->{
    Cell[160872, 5807, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkOpen::linke"],
    Cell[160958, 5810, 258, 7, 21, "Message",
      CellTags->"LinkOpen::linke"],
    Cell[161219, 5819, 683, 17, 100, "Notes",
      CellTags->"LinkOpen::linke"],
    Cell[161927, 5840, 65, 1, 38, "ExampleSection",
      CellTags->"LinkOpen::linke"],
    Cell[161995, 5843, 302, 8, 40, "Text",
      CellTags->"LinkOpen::linke"],
    Cell[162322, 5855, 164, 4, 26, "Input",
      CellTags->"LinkOpen::linke"],
    Cell[162489, 5861, 180, 4, 21, "Message",
      CellTags->"LinkOpen::linke"],
    Cell[162672, 5867, 96, 3, 21, "Output",
      CellTags->"LinkOpen::linke"]},
  "LinkRead::linkep"->{
    Cell[162829, 5877, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkRead::linkep"],
    Cell[162917, 5880, 167, 3, 21, "Message",
      CellTags->"LinkRead::linkep"],
    Cell[163087, 5885, 175, 6, 24, "Notes",
      CellTags->"LinkRead::linkep"]},
  "LinkObject::linkn"->{
    Cell[163299, 5896, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkObject::linkn"],
    Cell[163389, 5899, 374, 9, 37, "Message",
      CellTags->"LinkObject::linkn"],
    Cell[163766, 5910, 280, 7, 40, "Notes",
      CellTags->"LinkObject::linkn"]},
  "LinkObject::linkv"->{
    Cell[164083, 5922, 179, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[164265, 5929, 469, 12, 21, "Message",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[164737, 5943, 504, 12, 62, "Notes",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[165266, 5959, 113, 1, 38, "ExampleSection",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[165382, 5962, 237, 5, 24, "Text",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[165644, 5971, 167, 3, 26, "Input",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[165814, 5976, 261, 5, 21, "Message",
      CellTags->{
      "LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}],
    Cell[166078, 5983, 297, 5, 37, "Message",
      CellTags->{
      "LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}],
    Cell[166378, 5990, 164, 3, 21, "Output",
      CellTags->{
      "LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}]},
  "LinkWrite::linkv"->{
    Cell[164083, 5922, 179, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[164265, 5929, 469, 12, 21, "Message",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[164737, 5943, 504, 12, 62, "Notes",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[165266, 5959, 113, 1, 38, "ExampleSection",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[165382, 5962, 237, 5, 24, "Text",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[165644, 5971, 167, 3, 26, "Input",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[165814, 5976, 261, 5, 21, "Message",
      CellTags->{
      "LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}],
    Cell[166078, 5983, 297, 5, 37, "Message",
      CellTags->{
      "LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}],
    Cell[166378, 5990, 164, 3, 21, "Output",
      CellTags->{
      "LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}]},
  "LinkWriteHeld::linkv"->{
    Cell[164083, 5922, 179, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[164265, 5929, 469, 12, 21, "Message",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[164737, 5943, 504, 12, 62, "Notes",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[165266, 5959, 113, 1, 38, "ExampleSection",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[165382, 5962, 237, 5, 24, "Text",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[165644, 5971, 167, 3, 26, "Input",
      CellTags->{
      "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
    Cell[165814, 5976, 261, 5, 21, "Message",
      CellTags->{
      "LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}],
    Cell[166078, 5983, 297, 5, 37, "Message",
      CellTags->{
      "LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}],
    Cell[166378, 5990, 164, 3, 21, "Output",
      CellTags->{
      "LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}]},
  "LinkObject::linkw"->{
    Cell[166603, 6000, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkObject::linkw"],
    Cell[166693, 6003, 229, 5, 21, "Message",
      CellTags->"LinkObject::linkw"],
    Cell[166925, 6010, 211, 6, 24, "Notes",
      CellTags->"LinkObject::linkw"]},
  "LinkObject::linkx"->{
    Cell[167173, 6021, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkObject::linkx"],
    Cell[167263, 6024, 337, 9, 21, "Message",
      CellTags->"LinkObject::linkx"],
    Cell[167603, 6035, 209, 6, 24, "Notes",
      CellTags->"LinkObject::linkx"]},
  "LinkOpen::linkh"->{
    Cell[167849, 6046, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkOpen::linkh"],
    Cell[167935, 6049, 262, 6, 21, "Message",
      CellTags->"LinkOpen::linkh"],
    Cell[168200, 6057, 194, 5, 24, "Notes",
      CellTags->"LinkOpen::linkh"]},
  "LinkOpen::linki"->{
    Cell[168431, 6067, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkOpen::linki"],
    Cell[168517, 6070, 156, 3, 21, "Message",
      CellTags->"LinkOpen::linki"],
    Cell[168676, 6075, 199, 6, 24, "Notes",
      CellTags->"LinkOpen::linki"]},
  "LinkOpen::linkm"->{
    Cell[168912, 6086, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkOpen::linkm"],
    Cell[168998, 6089, 306, 6, 37, "Message",
      CellTags->"LinkOpen::linkm"],
    Cell[169307, 6097, 194, 5, 24, "Notes",
      CellTags->"LinkOpen::linkm"]},
  "LinkOpen::linknm"->{
    Cell[169538, 6107, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkOpen::linknm"],
    Cell[169626, 6110, 203, 4, 21, "Message",
      CellTags->"LinkOpen::linknm"],
    Cell[169832, 6116, 240, 7, 24, "Notes",
      CellTags->"LinkOpen::linknm"],
    Cell[170097, 6127, 66, 1, 38, "ExampleSection",
      CellTags->"LinkOpen::linknm"],
    Cell[170166, 6130, 148, 4, 24, "Text",
      CellTags->"LinkOpen::linknm"],
    Cell[170339, 6138, 99, 3, 26, "Input",
      CellTags->"LinkOpen::linknm"],
    Cell[170441, 6143, 210, 5, 37, "Message",
      CellTags->"LinkOpen::linknm"],
    Cell[170654, 6150, 100, 3, 21, "Output",
      CellTags->"LinkOpen::linknm"]},
  "LinkOpen::linkpl"->{
    Cell[170815, 6160, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkOpen::linkpl"],
    Cell[170903, 6163, 378, 9, 21, "Message",
      CellTags->"LinkOpen::linkpl"],
    Cell[171284, 6174, 438, 12, 62, "Notes",
      CellTags->"LinkOpen::linkpl"],
    Cell[171747, 6190, 66, 1, 38, "ExampleSection",
      CellTags->"LinkOpen::linkpl"],
    Cell[171816, 6193, 357, 11, 40, "Text",
      CellTags->"LinkOpen::linkpl"],
    Cell[172198, 6208, 119, 3, 26, "Input",
      CellTags->"LinkOpen::linkpl"],
    Cell[172320, 6213, 398, 7, 37, "Message",
      CellTags->"LinkOpen::linkpl"],
    Cell[172721, 6222, 125, 3, 21, "Output",
      CellTags->"LinkOpen::linkpl"]},
  "LinkOpen::links"->{
    Cell[172907, 6232, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkOpen::links"],
    Cell[172993, 6235, 141, 3, 21, "Message",
      CellTags->"LinkOpen::links"],
    Cell[173137, 6240, 302, 9, 40, "Notes",
      CellTags->"LinkOpen::links"]},
  "LinkWriteHeld::linkhl"->{
    Cell[173476, 6254, 95, 1, 31, "ObjectNameWarningMessages",
      CellTags->"LinkWriteHeld::linkhl"],
    Cell[173574, 6257, 341, 9, 21, "Message",
      CellTags->"LinkWriteHeld::linkhl"],
    Cell[173918, 6268, 277, 9, 24, "Notes",
      CellTags->"LinkWriteHeld::linkhl"],
    Cell[174220, 6281, 71, 1, 38, "ExampleSection",
      CellTags->"LinkWriteHeld::linkhl"],
    Cell[174294, 6284, 188, 6, 24, "Text",
      CellTags->"LinkWriteHeld::linkhl"],
    Cell[174507, 6294, 113, 3, 26, "Input",
      CellTags->"LinkWriteHeld::linkhl"],
    Cell[174623, 6299, 231, 5, 37, "Message",
      CellTags->"LinkWriteHeld::linkhl"],
    Cell[174857, 6306, 114, 3, 21, "Output",
      CellTags->"LinkWriteHeld::linkhl"]},
  "MapThread::mptc"->{
    Cell[175032, 6316, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"MapThread::mptc"],
    Cell[175118, 6319, 786, 23, 37, "Message",
      CellTags->"MapThread::mptc"],
    Cell[175907, 6344, 213, 5, 24, "Notes",
      CellTags->"MapThread::mptc"],
    Cell[176145, 6353, 65, 1, 38, "ExampleSection",
      CellTags->"MapThread::mptc"],
    Cell[176213, 6356, 156, 4, 24, "Text",
      CellTags->"MapThread::mptc"],
    Cell[176394, 6364, 131, 3, 26, "Input",
      CellTags->"MapThread::mptc"],
    Cell[176528, 6369, 343, 6, 53, "Message",
      CellTags->"MapThread::mptc"],
    Cell[176874, 6377, 130, 3, 21, "Output",
      CellTags->"MapThread::mptc"],
    Cell[177019, 6383, 131, 5, 24, "Text",
      CellTags->"MapThread::mptc"],
    Cell[177175, 6392, 135, 3, 26, "Input",
      CellTags->"MapThread::mptc"],
    Cell[177313, 6397, 137, 3, 21, "Output",
      CellTags->"MapThread::mptc"]},
  "MapThread::mptd"->{
    Cell[177511, 6407, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"MapThread::mptd"],
    Cell[177597, 6410, 573, 16, 37, "Message",
      CellTags->"MapThread::mptd"],
    Cell[178173, 6428, 267, 6, 40, "Notes",
      CellTags->"MapThread::mptd"],
    Cell[178465, 6438, 65, 1, 38, "ExampleSection",
      CellTags->"MapThread::mptd"],
    Cell[178533, 6441, 253, 7, 40, "Text",
      CellTags->"MapThread::mptd"],
    Cell[178811, 6452, 164, 4, 26, "Input",
      CellTags->"MapThread::mptd"],
    Cell[178978, 6458, 360, 7, 53, "Message",
      CellTags->"MapThread::mptd"],
    Cell[179341, 6467, 150, 4, 21, "Output",
      CellTags->"MapThread::mptd"],
    Cell[179506, 6474, 131, 5, 24, "Text",
      CellTags->"MapThread::mptd"],
    Cell[179662, 6483, 166, 4, 26, "Input",
      CellTags->"MapThread::mptd"],
    Cell[179831, 6489, 166, 4, 21, "Output",
      CellTags->"MapThread::mptd"]},
  "Options::opmix"->{
    Cell[180058, 6500, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Options::opmix"],
    Cell[180142, 6503, 226, 5, 21, "Message",
      CellTags->"Options::opmix"],
    Cell[180371, 6510, 630, 18, 78, "Notes",
      CellTags->"Options::opmix"],
    Cell[181026, 6532, 64, 1, 38, "ExampleSection",
      CellTags->"Options::opmix"],
    Cell[181093, 6535, 196, 5, 24, "Text",
      CellTags->"Options::opmix"],
    Cell[181314, 6544, 128, 3, 26, "Input",
      CellTags->"Options::opmix"],
    Cell[181445, 6549, 236, 5, 37, "Message",
      CellTags->"Options::opmix"],
    Cell[181684, 6556, 132, 3, 21, "Output",
      CellTags->"Options::opmix"]},
  "Options::opsym"->{
    Cell[181877, 6566, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Options::opsym"],
    Cell[181961, 6569, 279, 6, 21, "Message",
      CellTags->"Options::opsym"],
    Cell[182243, 6577, 190, 5, 24, "Notes",
      CellTags->"Options::opsym"],
    Cell[182458, 6586, 64, 1, 38, "ExampleSection",
      CellTags->"Options::opsym"],
    Cell[182525, 6589, 178, 5, 24, "Text",
      CellTags->"Options::opsym"],
    Cell[182728, 6598, 118, 3, 26, "Input",
      CellTags->"Options::opsym"],
    Cell[182849, 6603, 254, 5, 37, "Message",
      CellTags->"Options::opsym"],
    Cell[183106, 6610, 122, 3, 21, "Output",
      CellTags->"Options::opsym"],
    Cell[183243, 6616, 148, 5, 24, "Text",
      CellTags->"Options::opsym"],
    Cell[183416, 6625, 113, 3, 26, "Input",
      CellTags->"Options::opsym"],
    Cell[183532, 6630, 107, 3, 21, "Output",
      CellTags->"Options::opsym"]},
  "Pattern::nodef"->{
    Cell[183700, 6640, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Pattern::nodef"],
    Cell[183784, 6643, 458, 12, 21, "Message",
      CellTags->"Pattern::nodef"],
    Cell[184245, 6657, 570, 17, 68, "Notes",
      CellTags->"Pattern::nodef"],
    Cell[184840, 6678, 64, 1, 38, "ExampleSection",
      CellTags->"Pattern::nodef"],
    Cell[184907, 6681, 241, 7, 40, "Text",
      CellTags->"Pattern::nodef"],
    Cell[185173, 6692, 121, 3, 26, "Input",
      CellTags->"Pattern::nodef"],
    Cell[185297, 6697, 221, 5, 37, "Message",
      CellTags->"Pattern::nodef"],
    Cell[185521, 6704, 221, 5, 37, "Message",
      CellTags->"Pattern::nodef"],
    Cell[185745, 6711, 94, 3, 21, "Output",
      CellTags->"Pattern::nodef"],
    Cell[185854, 6717, 240, 7, 40, "Text",
      CellTags->"Pattern::nodef"],
    Cell[186119, 6728, 107, 3, 26, "Input",
      CellTags->"Pattern::nodef"],
    Cell[186229, 6733, 89, 3, 21, "Output",
      CellTags->"Pattern::nodef"],
    Cell[186355, 6741, 121, 3, 26, "Input",
      CellTags->"Pattern::nodef"],
    Cell[186479, 6746, 94, 3, 21, "Output",
      CellTags->"Pattern::nodef"],
    Cell[186588, 6752, 135, 5, 24, "Text",
      CellTags->"Pattern::nodef"],
    Cell[186726, 6759, 107, 3, 26, "Input",
      CellTags->"Pattern::nodef"]},
  "Pattern::patm"->{
    Cell[186882, 6768, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Pattern::patm"],
    Cell[186964, 6771, 390, 11, 21, "Message",
      CellTags->"Pattern::patm"],
    Cell[187357, 6784, 578, 18, 68, "Notes",
      CellTags->"Pattern::patm"],
    Cell[187960, 6806, 63, 1, 38, "ExampleSection",
      CellTags->"Pattern::patm"],
    Cell[188026, 6809, 261, 8, 40, "Text",
      CellTags->"Pattern::patm"],
    Cell[188312, 6821, 255, 5, 42, "Input",
      CellTags->"Pattern::patm"],
    Cell[188570, 6828, 365, 7, 37, "Message",
      CellTags->"Pattern::patm"],
    Cell[188938, 6837, 365, 7, 37, "Message",
      CellTags->"Pattern::patm"],
    Cell[189306, 6846, 89, 3, 21, "Output",
      CellTags->"Pattern::patm"]},
  "Pattern::patsym"->{
    Cell[189456, 6856, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Pattern::patsym"],
    Cell[189542, 6859, 265, 5, 21, "Message",
      CellTags->"Pattern::patsym"],
    Cell[189810, 6866, 195, 6, 24, "Notes",
      CellTags->"Pattern::patsym"]},
  "Pattern::patv"->{
    Cell[190042, 6877, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Pattern::patv"],
    Cell[190124, 6880, 251, 5, 21, "Message",
      CellTags->"Pattern::patv"],
    Cell[190378, 6887, 385, 9, 46, "Notes",
      CellTags->"Pattern::patv"],
    Cell[190788, 6900, 63, 1, 38, "ExampleSection",
      CellTags->"Pattern::patv"],
    Cell[190854, 6903, 195, 5, 40, "Text",
      CellTags->"Pattern::patv"],
    Cell[191074, 6912, 128, 3, 26, "Input",
      CellTags->"Pattern::patv"],
    Cell[191205, 6917, 198, 5, 21, "Message",
      CellTags->"Pattern::patv"],
    Cell[191406, 6924, 102, 3, 21, "Output",
      CellTags->"Pattern::patv"],
    Cell[191523, 6930, 154, 4, 24, "Text",
      CellTags->"Pattern::patv"],
    Cell[191702, 6938, 128, 3, 26, "Input",
      CellTags->"Pattern::patv"],
    Cell[191833, 6943, 106, 3, 21, "Output",
      CellTags->"Pattern::patv"]},
  "PatternTest::ptest"->{
    Cell[192000, 6953, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"PatternTest::ptest"],
    Cell[192092, 6956, 239, 5, 21, "Message",
      CellTags->"PatternTest::ptest"],
    Cell[192334, 6963, 674, 20, 68, "Notes",
      CellTags->"PatternTest::ptest"]},
  "Protect::pssl"->{
    Cell[193045, 6988, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Protect::pssl"],
    Cell[193127, 6991, 248, 5, 21, "Message",
      CellTags->"Protect::pssl"],
    Cell[193378, 6998, 182, 5, 24, "Notes",
      CellTags->"Protect::pssl"],
    Cell[193585, 7007, 63, 1, 38, "ExampleSection",
      CellTags->"Protect::pssl"],
    Cell[193651, 7010, 120, 4, 24, "Text",
      CellTags->"Protect::pssl"],
    Cell[193796, 7018, 96, 3, 26, "Input",
      CellTags->"Protect::pssl"],
    Cell[193895, 7023, 200, 5, 21, "Message",
      CellTags->"Protect::pssl"],
    Cell[194098, 7030, 97, 3, 21, "Output",
      CellTags->"Protect::pssl"]},
  "Remove::relex"->{
    Cell[194256, 7040, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Remove::relex"],
    Cell[194338, 7043, 360, 7, 37, "Message",
      CellTags->"Remove::relex"],
    Cell[194701, 7052, 194, 5, 24, "Notes",
      CellTags->"Remove::relex"],
    Cell[194920, 7061, 63, 1, 38, "ExampleSection",
      CellTags->"Remove::relex"],
    Cell[194986, 7064, 205, 5, 40, "Text",
      CellTags->"Remove::relex"],
    Cell[195216, 7073, 139, 3, 26, "Input",
      CellTags->"Remove::relex"],
    Cell[195358, 7078, 221, 5, 37, "Message",
      CellTags->"Remove::relex"]},
  "Remove::remal"->{
    Cell[195640, 7090, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Remove::remal"],
    Cell[195722, 7093, 212, 4, 21, "Message",
      CellTags->"Remove::remal"],
    Cell[195937, 7099, 178, 5, 24, "Notes",
      CellTags->"Remove::remal"],
    Cell[196140, 7108, 63, 1, 38, "ExampleSection",
      CellTags->"Remove::remal"],
    Cell[196206, 7111, 174, 5, 24, "Text",
      CellTags->"Remove::remal"],
    Cell[196405, 7120, 118, 3, 26, "Input",
      CellTags->"Remove::remal"],
    Cell[196526, 7125, 255, 5, 21, "Message",
      CellTags->"Remove::remal"]},
  "Remove::rmlck"->{
    Cell[196842, 7137, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Remove::rmlck"],
    Cell[196924, 7140, 234, 5, 21, "Message",
      CellTags->"Remove::rmlck"],
    Cell[197161, 7147, 214, 7, 24, "Notes",
      CellTags->"Remove::rmlck"],
    Cell[197400, 7158, 63, 1, 38, "ExampleSection",
      CellTags->"Remove::rmlck"],
    Cell[197466, 7161, 198, 7, 24, "Text",
      CellTags->"Remove::rmlck"],
    Cell[197689, 7172, 98, 3, 26, "Input",
      CellTags->"Remove::rmlck"],
    Cell[197790, 7177, 184, 4, 21, "Message",
      CellTags->"Remove::rmlck"],
    Cell[198011, 7186, 102, 3, 26, "Input",
      CellTags->"Remove::rmlck"],
    Cell[198116, 7191, 106, 3, 21, "Output",
      CellTags->"Remove::rmlck"]},
  "Remove::rmptc"->{
    Cell[198283, 7201, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Remove::rmptc"],
    Cell[198365, 7204, 237, 5, 21, "Message",
      CellTags->"Remove::rmptc"],
    Cell[198605, 7211, 213, 7, 24, "Notes",
      CellTags->"Remove::rmptc"],
    Cell[198843, 7222, 63, 1, 38, "ExampleSection",
      CellTags->"Remove::rmptc"],
    Cell[198909, 7225, 180, 5, 24, "Text",
      CellTags->"Remove::rmptc"],
    Cell[199114, 7234, 119, 3, 26, "Input",
      CellTags->"Remove::rmptc"],
    Cell[199236, 7239, 192, 5, 21, "Message",
      CellTags->"Remove::rmptc"],
    Cell[199465, 7249, 105, 3, 26, "Input",
      CellTags->"Remove::rmptc"],
    Cell[199573, 7254, 98, 3, 21, "Output",
      CellTags->"Remove::rmptc"],
    Cell[199686, 7260, 201, 6, 24, "Text",
      CellTags->"Remove::rmptc"],
    Cell[199890, 7268, 121, 3, 26, "Input",
      CellTags->"Remove::rmptc"]},
  "Remove::ssym"->{
    Cell[200060, 7277, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Remove::ssym"],
    Cell[200140, 7280, 190, 4, 21, "Message",
      CellTags->"Remove::ssym"],
    Cell[200333, 7286, 291, 7, 46, "Notes",
      CellTags->"Remove::ssym"],
    Cell[200649, 7297, 62, 1, 38, "ExampleSection",
      CellTags->"Remove::ssym"],
    Cell[200714, 7300, 163, 5, 24, "Text",
      CellTags->"Remove::ssym"],
    Cell[200902, 7309, 94, 3, 26, "Input",
      CellTags->"Remove::ssym"],
    Cell[200999, 7314, 151, 4, 21, "Message",
      CellTags->"Remove::ssym"]},
  "General::rep"->{
    Cell[201211, 7325, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::rep"],
    Cell[201291, 7328, 374, 11, 21, "Message",
      CellTags->"General::rep"],
    Cell[201668, 7341, 287, 8, 46, "Notes",
      CellTags->"General::rep"],
    Cell[201980, 7353, 62, 1, 38, "ExampleSection",
      CellTags->"General::rep"],
    Cell[202045, 7356, 152, 5, 24, "Text",
      CellTags->"General::rep"],
    Cell[202222, 7365, 116, 3, 26, "Input",
      CellTags->"General::rep"],
    Cell[202341, 7370, 103, 3, 21, "Output",
      CellTags->"General::rep"],
    Cell[202481, 7378, 115, 3, 26, "Input",
      CellTags->"General::rep"],
    Cell[202599, 7383, 183, 4, 21, "Message",
      CellTags->"General::rep"],
    Cell[202785, 7389, 116, 3, 21, "Output",
      CellTags->"General::rep"],
    Cell[202916, 7395, 129, 5, 24, "Text",
      CellTags->"General::rep"],
    Cell[203070, 7404, 126, 3, 26, "Input",
      CellTags->"General::rep"],
    Cell[203199, 7409, 113, 3, 21, "Output",
      CellTags->"General::rep"]},
  "Replace::rmix"->{
    Cell[203373, 7419, 220, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[203596, 7429, 530, 15, 21, "Message",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204129, 7446, 305, 7, 40, "Notes",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204459, 7457, 139, 3, 38, "ExampleSection",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204601, 7462, 207, 6, 24, "Text",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204833, 7472, 193, 5, 26, "Input",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[205029, 7479, 315, 7, 37, "Message",
      CellTags->{
      "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
        "Replace::rmix"}],
    Cell[205347, 7488, 223, 6, 21, "Output",
      CellTags->{
      "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
        "Replace::rmix"}],
    Cell[205585, 7497, 206, 7, 24, "Text",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[205816, 7508, 195, 5, 26, "Input",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[206014, 7515, 185, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
        "Replace::rmix"}]},
  "ReplaceAll::rmix"->{
    Cell[203373, 7419, 220, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[203596, 7429, 530, 15, 21, "Message",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204129, 7446, 305, 7, 40, "Notes",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204459, 7457, 139, 3, 38, "ExampleSection",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204601, 7462, 207, 6, 24, "Text",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204833, 7472, 193, 5, 26, "Input",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[205029, 7479, 315, 7, 37, "Message",
      CellTags->{
      "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
        "Replace::rmix"}],
    Cell[205347, 7488, 223, 6, 21, "Output",
      CellTags->{
      "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
        "Replace::rmix"}],
    Cell[205585, 7497, 206, 7, 24, "Text",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[205816, 7508, 195, 5, 26, "Input",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[206014, 7515, 185, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
        "Replace::rmix"}]},
  "ReplaceRepeated::rmix"->{
    Cell[203373, 7419, 220, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[203596, 7429, 530, 15, 21, "Message",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204129, 7446, 305, 7, 40, "Notes",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204459, 7457, 139, 3, 38, "ExampleSection",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204601, 7462, 207, 6, 24, "Text",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204833, 7472, 193, 5, 26, "Input",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[205029, 7479, 315, 7, 37, "Message",
      CellTags->{
      "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
        "Replace::rmix"}],
    Cell[205347, 7488, 223, 6, 21, "Output",
      CellTags->{
      "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
        "Replace::rmix"}],
    Cell[205585, 7497, 206, 7, 24, "Text",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[205816, 7508, 195, 5, 26, "Input",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[206014, 7515, 185, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
        "Replace::rmix"}]},
  "ReplaceList::rmix"->{
    Cell[203373, 7419, 220, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[203596, 7429, 530, 15, 21, "Message",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204129, 7446, 305, 7, 40, "Notes",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204459, 7457, 139, 3, 38, "ExampleSection",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204601, 7462, 207, 6, 24, "Text",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[204833, 7472, 193, 5, 26, "Input",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[205029, 7479, 315, 7, 37, "Message",
      CellTags->{
      "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
        "Replace::rmix"}],
    Cell[205347, 7488, 223, 6, 21, "Output",
      CellTags->{
      "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
        "Replace::rmix"}],
    Cell[205585, 7497, 206, 7, 24, "Text",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[205816, 7508, 195, 5, 26, "Input",
      CellTags->{
      "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
        "ReplaceList::rmix"}],
    Cell[206014, 7515, 185, 5, 21, "Output",
      CellTags->{
      "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
        "Replace::rmix"}]},
  "ReplacePart::psl"->{
    Cell[206260, 7527, 382, 14, 191, "ObjectNameWarningMessages",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[206645, 7543, 665, 17, 21, "Message",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207313, 7562, 322, 7, 24, "Notes",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207660, 7573, 230, 4, 38, "ExampleSection",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207893, 7579, 340, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208258, 7591, 288, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208549, 7599, 456, 9, 37, "Message",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209008, 7610, 290, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209313, 7619, 307, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209645, 7631, 284, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209932, 7639, 267, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}]},
  "ReplaceHeldPart::psl"->{
    Cell[206260, 7527, 382, 14, 191, "ObjectNameWarningMessages",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[206645, 7543, 665, 17, 21, "Message",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207313, 7562, 322, 7, 24, "Notes",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207660, 7573, 230, 4, 38, "ExampleSection",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207893, 7579, 340, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208258, 7591, 288, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208549, 7599, 456, 9, 37, "Message",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209008, 7610, 290, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209313, 7619, 307, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209645, 7631, 284, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209932, 7639, 267, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}]},
  "MapAt::psl"->{
    Cell[206260, 7527, 382, 14, 191, "ObjectNameWarningMessages",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[206645, 7543, 665, 17, 21, "Message",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207313, 7562, 322, 7, 24, "Notes",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207660, 7573, 230, 4, 38, "ExampleSection",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207893, 7579, 340, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208258, 7591, 288, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208549, 7599, 456, 9, 37, "Message",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209008, 7610, 290, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209313, 7619, 307, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209645, 7631, 284, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209932, 7639, 267, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}]},
  "Delete::psl"->{
    Cell[206260, 7527, 382, 14, 191, "ObjectNameWarningMessages",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[206645, 7543, 665, 17, 21, "Message",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207313, 7562, 322, 7, 24, "Notes",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207660, 7573, 230, 4, 38, "ExampleSection",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207893, 7579, 340, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208258, 7591, 288, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208549, 7599, 456, 9, 37, "Message",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209008, 7610, 290, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209313, 7619, 307, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209645, 7631, 284, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209932, 7639, 267, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}]},
  "FlattenAt::psl"->{
    Cell[206260, 7527, 382, 14, 191, "ObjectNameWarningMessages",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[206645, 7543, 665, 17, 21, "Message",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207313, 7562, 322, 7, 24, "Notes",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207660, 7573, 230, 4, 38, "ExampleSection",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207893, 7579, 340, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208258, 7591, 288, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208549, 7599, 456, 9, 37, "Message",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209008, 7610, 290, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209313, 7619, 307, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209645, 7631, 284, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209932, 7639, 267, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}]},
  "Insert::psl"->{
    Cell[206260, 7527, 382, 14, 191, "ObjectNameWarningMessages",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[206645, 7543, 665, 17, 21, "Message",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207313, 7562, 322, 7, 24, "Notes",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207660, 7573, 230, 4, 38, "ExampleSection",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207893, 7579, 340, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208258, 7591, 288, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208549, 7599, 456, 9, 37, "Message",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209008, 7610, 290, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209313, 7619, 307, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209645, 7631, 284, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209932, 7639, 267, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}]},
  "StringInsert::psl"->{
    Cell[206260, 7527, 382, 14, 191, "ObjectNameWarningMessages",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[206645, 7543, 665, 17, 21, "Message",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207313, 7562, 322, 7, 24, "Notes",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207660, 7573, 230, 4, 38, "ExampleSection",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207893, 7579, 340, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208258, 7591, 288, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208549, 7599, 456, 9, 37, "Message",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209008, 7610, 290, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209313, 7619, 307, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209645, 7631, 284, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209932, 7639, 267, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}]},
  "StringReplacePart::psl"->{
    Cell[206260, 7527, 382, 14, 191, "ObjectNameWarningMessages",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[206645, 7543, 665, 17, 21, "Message",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207313, 7562, 322, 7, 24, "Notes",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207660, 7573, 230, 4, 38, "ExampleSection",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207893, 7579, 340, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208258, 7591, 288, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208549, 7599, 456, 9, 37, "Message",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209008, 7610, 290, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209313, 7619, 307, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209645, 7631, 284, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209932, 7639, 267, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}]},
  "Extract::psl"->{
    Cell[206260, 7527, 382, 14, 191, "ObjectNameWarningMessages",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[206645, 7543, 665, 17, 21, "Message",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207313, 7562, 322, 7, 24, "Notes",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207660, 7573, 230, 4, 38, "ExampleSection",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[207893, 7579, 340, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208258, 7591, 288, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[208549, 7599, 456, 9, 37, "Message",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209008, 7610, 290, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}],
    Cell[209313, 7619, 307, 8, 24, "Text",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209645, 7631, 284, 6, 26, "Input",
      CellTags->{
      "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl",
         "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
        "StringReplacePart::psl", "Extract::psl"}],
    Cell[209932, 7639, 267, 6, 21, "Output",
      CellTags->{
      "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
        "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
        "StringInsert::psl", "StringReplacePart::psl"}]},
  "ReplaceRepeated::rrlim"->{
    Cell[210260, 7652, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ReplaceRepeated::rrlim"],
    Cell[210360, 7655, 337, 9, 21, "Message",
      CellTags->"ReplaceRepeated::rrlim"],
    Cell[210700, 7666, 249, 6, 40, "Notes",
      CellTags->"ReplaceRepeated::rrlim"],
    Cell[210974, 7676, 72, 1, 38, "ExampleSection",
      CellTags->"ReplaceRepeated::rrlim"],
    Cell[211049, 7679, 157, 4, 24, "Text",
      CellTags->"ReplaceRepeated::rrlim"],
    Cell[211231, 7687, 112, 3, 26, "Input",
      CellTags->"ReplaceRepeated::rrlim"],
    Cell[211346, 7692, 200, 4, 21, "Message",
      CellTags->"ReplaceRepeated::rrlim"],
    Cell[211549, 7698, 101, 3, 21, "Output",
      CellTags->"ReplaceRepeated::rrlim"],
    Cell[211665, 7704, 206, 6, 24, "Text",
      CellTags->"ReplaceRepeated::rrlim"],
    Cell[211896, 7714, 119, 3, 26, "Input",
      CellTags->"ReplaceRepeated::rrlim"],
    Cell[212018, 7719, 125, 3, 21, "Output",
      CellTags->"ReplaceRepeated::rrlim"],
    Cell[212158, 7725, 113, 1, 24, "Text",
      CellTags->"ReplaceRepeated::rrlim"],
    Cell[212296, 7730, 124, 3, 26, "Input",
      CellTags->"ReplaceRepeated::rrlim"],
    Cell[212423, 7735, 100, 3, 21, "Output",
      CellTags->"ReplaceRepeated::rrlim"]},
  "Return::nofsdd"->{
    Cell[212584, 7745, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Return::nofsdd"],
    Cell[212668, 7748, 268, 6, 21, "Message",
      CellTags->"Return::nofsdd"],
    Cell[212939, 7756, 341, 9, 46, "Notes",
      CellTags->"Return::nofsdd"]},
  "Rule::rhs"->{
    Cell[213317, 7770, 118, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[213438, 7776, 515, 14, 21, "Message",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[213956, 7792, 604, 12, 90, "Notes",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[214585, 7808, 81, 1, 38, "ExampleSection",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[214669, 7811, 238, 5, 40, "Text",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[214932, 7820, 142, 3, 26, "Input",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[215077, 7825, 259, 5, 37, "Message",
      CellTags->{"RuleDelayed::rhs", "Rule::rhs"}],
    Cell[215339, 7832, 207, 4, 37, "Output",
      CellTags->{"RuleDelayed::rhs", "Rule::rhs"}],
    Cell[215561, 7839, 116, 1, 24, "Text",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[215702, 7844, 141, 3, 26, "Input",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[215846, 7849, 120, 3, 21, "Output",
      CellTags->{"RuleDelayed::rhs", "Rule::rhs"}]},
  "RuleDelayed::rhs"->{
    Cell[213317, 7770, 118, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[213438, 7776, 515, 14, 21, "Message",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[213956, 7792, 604, 12, 90, "Notes",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[214585, 7808, 81, 1, 38, "ExampleSection",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[214669, 7811, 238, 5, 40, "Text",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[214932, 7820, 142, 3, 26, "Input",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[215077, 7825, 259, 5, 37, "Message",
      CellTags->{"RuleDelayed::rhs", "Rule::rhs"}],
    Cell[215339, 7832, 207, 4, 37, "Output",
      CellTags->{"RuleDelayed::rhs", "Rule::rhs"}],
    Cell[215561, 7839, 116, 1, 24, "Text",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[215702, 7844, 141, 3, 26, "Input",
      CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
    Cell[215846, 7849, 120, 3, 21, "Output",
      CellTags->{"RuleDelayed::rhs", "Rule::rhs"}]},
  "Set::lhsr"->{
    Cell[216027, 7859, 331, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[216361, 7874, 658, 18, 37, "Message",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[217022, 7894, 333, 9, 24, "Notes",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}]},
  "SetDelayed::lhsr"->{
    Cell[216027, 7859, 331, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[216361, 7874, 658, 18, 37, "Message",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[217022, 7894, 333, 9, 24, "Notes",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}]},
  "Unset::lhsr"->{
    Cell[216027, 7859, 331, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[216361, 7874, 658, 18, 37, "Message",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[217022, 7894, 333, 9, 24, "Notes",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}]},
  "TagSet::lhsr"->{
    Cell[216027, 7859, 331, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[216361, 7874, 658, 18, 37, "Message",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[217022, 7894, 333, 9, 24, "Notes",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}]},
  "TagSetDelayed::lhsr"->{
    Cell[216027, 7859, 331, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[216361, 7874, 658, 18, 37, "Message",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[217022, 7894, 333, 9, 24, "Notes",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}]},
  "TagUnset::lhsr"->{
    Cell[216027, 7859, 331, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[216361, 7874, 658, 18, 37, "Message",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[217022, 7894, 333, 9, 24, "Notes",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}]},
  "UpSet::lhsr"->{
    Cell[216027, 7859, 331, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[216361, 7874, 658, 18, 37, "Message",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[217022, 7894, 333, 9, 24, "Notes",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}]},
  "UpSetDelayed::lhsr"->{
    Cell[216027, 7859, 331, 13, 171, "ObjectNameWarningMessages",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[216361, 7874, 658, 18, 37, "Message",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}],
    Cell[217022, 7894, 333, 9, 24, "Notes",
      CellTags->{
      "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
        "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
        "UpSetDelayed::lhsr"}]},
  "Set::setraw"->{
    Cell[217392, 7908, 290, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[217685, 7920, 479, 13, 21, "Message",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[218167, 7935, 634, 19, 46, "Notes",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[218826, 7958, 177, 3, 38, "ExampleSection",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219006, 7963, 258, 6, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219289, 7973, 212, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219504, 7980, 282, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[219789, 7988, 209, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[220013, 7996, 255, 7, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[220293, 8007, 222, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[220518, 8014, 282, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[220803, 8022, 299, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[221105, 8030, 219, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[221339, 8038, 195, 3, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[221559, 8045, 223, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[221785, 8052, 216, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}]},
  "SetDelayed::setraw"->{
    Cell[217392, 7908, 290, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[217685, 7920, 479, 13, 21, "Message",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[218167, 7935, 634, 19, 46, "Notes",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[218826, 7958, 177, 3, 38, "ExampleSection",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219006, 7963, 258, 6, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219289, 7973, 212, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219504, 7980, 282, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[219789, 7988, 209, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[220013, 7996, 255, 7, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[220293, 8007, 222, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[220518, 8014, 282, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[220803, 8022, 299, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[221105, 8030, 219, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[221339, 8038, 195, 3, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[221559, 8045, 223, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[221785, 8052, 216, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}]},
  "UpSet::setraw"->{
    Cell[217392, 7908, 290, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[217685, 7920, 479, 13, 21, "Message",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[218167, 7935, 634, 19, 46, "Notes",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[218826, 7958, 177, 3, 38, "ExampleSection",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219006, 7963, 258, 6, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219289, 7973, 212, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219504, 7980, 282, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[219789, 7988, 209, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[220013, 7996, 255, 7, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[220293, 8007, 222, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[220518, 8014, 282, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[220803, 8022, 299, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[221105, 8030, 219, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[221339, 8038, 195, 3, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[221559, 8045, 223, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[221785, 8052, 216, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}]},
  "UpSetDelayed::setraw"->{
    Cell[217392, 7908, 290, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[217685, 7920, 479, 13, 21, "Message",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[218167, 7935, 634, 19, 46, "Notes",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[218826, 7958, 177, 3, 38, "ExampleSection",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219006, 7963, 258, 6, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219289, 7973, 212, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219504, 7980, 282, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[219789, 7988, 209, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[220013, 7996, 255, 7, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[220293, 8007, 222, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[220518, 8014, 282, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[220803, 8022, 299, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[221105, 8030, 219, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[221339, 8038, 195, 3, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[221559, 8045, 223, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[221785, 8052, 216, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}]},
  "TagSet::setraw"->{
    Cell[217392, 7908, 290, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[217685, 7920, 479, 13, 21, "Message",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[218167, 7935, 634, 19, 46, "Notes",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[218826, 7958, 177, 3, 38, "ExampleSection",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219006, 7963, 258, 6, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219289, 7973, 212, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219504, 7980, 282, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[219789, 7988, 209, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[220013, 7996, 255, 7, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[220293, 8007, 222, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[220518, 8014, 282, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[220803, 8022, 299, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[221105, 8030, 219, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[221339, 8038, 195, 3, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[221559, 8045, 223, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[221785, 8052, 216, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}]},
  "TagSetDelayed::setraw"->{
    Cell[217392, 7908, 290, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[217685, 7920, 479, 13, 21, "Message",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[218167, 7935, 634, 19, 46, "Notes",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[218826, 7958, 177, 3, 38, "ExampleSection",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219006, 7963, 258, 6, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219289, 7973, 212, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[219504, 7980, 282, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[219789, 7988, 209, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[220013, 7996, 255, 7, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[220293, 8007, 222, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[220518, 8014, 282, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[220803, 8022, 299, 6, 21, "Message",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[221105, 8030, 219, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
    Cell[221339, 8038, 195, 3, 24, "Text",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[221559, 8045, 223, 5, 26, "Input",
      CellTags->{
      "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
        "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
    Cell[221785, 8052, 216, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
        "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}]},
  "Set::shape"->{
    Cell[222062, 8064, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[222187, 8070, 430, 12, 21, "Message",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[222620, 8084, 205, 4, 24, "Notes",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[222850, 8092, 83, 1, 38, "ExampleSection",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[222936, 8095, 240, 5, 40, "Text",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[223201, 8104, 139, 3, 26, "Input",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[223343, 8109, 230, 5, 21, "Message",
      CellTags->{"SetDelayed::shape", "Set::shape"}],
    Cell[223576, 8116, 119, 3, 21, "Output",
      CellTags->{"SetDelayed::shape", "Set::shape"}],
    Cell[223710, 8122, 95, 1, 24, "Text",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[223830, 8127, 136, 3, 26, "Input",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[223969, 8132, 116, 3, 21, "Output",
      CellTags->{"SetDelayed::shape", "Set::shape"}],
    Cell[224100, 8138, 91, 1, 24, "Text",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[224194, 8141, 129, 3, 26, "Input",
      CellTags->{"Set::shape", "SetDelayed::shape"}]},
  "SetDelayed::shape"->{
    Cell[222062, 8064, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[222187, 8070, 430, 12, 21, "Message",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[222620, 8084, 205, 4, 24, "Notes",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[222850, 8092, 83, 1, 38, "ExampleSection",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[222936, 8095, 240, 5, 40, "Text",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[223201, 8104, 139, 3, 26, "Input",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[223343, 8109, 230, 5, 21, "Message",
      CellTags->{"SetDelayed::shape", "Set::shape"}],
    Cell[223576, 8116, 119, 3, 21, "Output",
      CellTags->{"SetDelayed::shape", "Set::shape"}],
    Cell[223710, 8122, 95, 1, 24, "Text",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[223830, 8127, 136, 3, 26, "Input",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[223969, 8132, 116, 3, 21, "Output",
      CellTags->{"SetDelayed::shape", "Set::shape"}],
    Cell[224100, 8138, 91, 1, 24, "Text",
      CellTags->{"Set::shape", "SetDelayed::shape"}],
    Cell[224194, 8141, 129, 3, 26, "Input",
      CellTags->{"Set::shape", "SetDelayed::shape"}]},
  "Set::setrpt"->{
    Cell[224372, 8150, 290, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[224665, 8162, 547, 15, 21, "Message",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225215, 8179, 309, 7, 24, "Notes",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225549, 8190, 177, 3, 38, "ExampleSection",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225729, 8195, 258, 6, 24, "Text",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[226012, 8205, 215, 5, 26, "Input",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[226230, 8212, 313, 7, 21, "Message",
      CellTags->{
      "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
        "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}],
    Cell[226546, 8221, 202, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
        "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}]},
  "SetDelayed::setrpt"->{
    Cell[224372, 8150, 290, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[224665, 8162, 547, 15, 21, "Message",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225215, 8179, 309, 7, 24, "Notes",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225549, 8190, 177, 3, 38, "ExampleSection",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225729, 8195, 258, 6, 24, "Text",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[226012, 8205, 215, 5, 26, "Input",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[226230, 8212, 313, 7, 21, "Message",
      CellTags->{
      "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
        "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}],
    Cell[226546, 8221, 202, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
        "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}]},
  "UpSet::setrpt"->{
    Cell[224372, 8150, 290, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[224665, 8162, 547, 15, 21, "Message",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225215, 8179, 309, 7, 24, "Notes",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225549, 8190, 177, 3, 38, "ExampleSection",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225729, 8195, 258, 6, 24, "Text",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[226012, 8205, 215, 5, 26, "Input",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[226230, 8212, 313, 7, 21, "Message",
      CellTags->{
      "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
        "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}],
    Cell[226546, 8221, 202, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
        "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}]},
  "UpSetDelayed::setrpt"->{
    Cell[224372, 8150, 290, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[224665, 8162, 547, 15, 21, "Message",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225215, 8179, 309, 7, 24, "Notes",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225549, 8190, 177, 3, 38, "ExampleSection",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225729, 8195, 258, 6, 24, "Text",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[226012, 8205, 215, 5, 26, "Input",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[226230, 8212, 313, 7, 21, "Message",
      CellTags->{
      "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
        "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}],
    Cell[226546, 8221, 202, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
        "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}]},
  "TagSet::setrpt"->{
    Cell[224372, 8150, 290, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[224665, 8162, 547, 15, 21, "Message",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225215, 8179, 309, 7, 24, "Notes",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225549, 8190, 177, 3, 38, "ExampleSection",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225729, 8195, 258, 6, 24, "Text",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[226012, 8205, 215, 5, 26, "Input",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[226230, 8212, 313, 7, 21, "Message",
      CellTags->{
      "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
        "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}],
    Cell[226546, 8221, 202, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
        "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}]},
  "TagSetDelayed::setrpt"->{
    Cell[224372, 8150, 290, 10, 131, "ObjectNameWarningMessages",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[224665, 8162, 547, 15, 21, "Message",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225215, 8179, 309, 7, 24, "Notes",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225549, 8190, 177, 3, 38, "ExampleSection",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[225729, 8195, 258, 6, 24, "Text",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[226012, 8205, 215, 5, 26, "Input",
      CellTags->{
      "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
        "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
    Cell[226230, 8212, 313, 7, 21, "Message",
      CellTags->{
      "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
        "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}],
    Cell[226546, 8221, 202, 5, 21, "Output",
      CellTags->{
      "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
        "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}]},
  "SetOptions::optf"->{
    Cell[226809, 8233, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SetOptions::optf"],
    Cell[226897, 8236, 343, 10, 21, "Message",
      CellTags->"SetOptions::optf"],
    Cell[227243, 8248, 379, 10, 46, "Notes",
      CellTags->"SetOptions::optf"],
    Cell[227647, 8262, 66, 1, 38, "ExampleSection",
      CellTags->"SetOptions::optf"],
    Cell[227716, 8265, 175, 6, 24, "Text",
      CellTags->"SetOptions::optf"],
    Cell[227916, 8275, 130, 3, 26, "Input",
      CellTags->"SetOptions::optf"],
    Cell[228049, 8280, 202, 5, 21, "Message",
      CellTags->"SetOptions::optf"],
    Cell[228254, 8287, 179, 4, 21, "Message",
      CellTags->"SetOptions::optf"],
    Cell[228436, 8293, 108, 3, 21, "Output",
      CellTags->"SetOptions::optf"]},
  "SetOptions::sstm"->{
    Cell[228605, 8303, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SetOptions::sstm"],
    Cell[228693, 8306, 239, 5, 21, "Message",
      CellTags->"SetOptions::sstm"],
    Cell[228935, 8313, 484, 11, 84, "Notes",
      CellTags->"SetOptions::sstm"],
    Cell[229444, 8328, 66, 1, 38, "ExampleSection",
      CellTags->"SetOptions::sstm"],
    Cell[229513, 8331, 175, 5, 24, "Text",
      CellTags->"SetOptions::sstm"],
    Cell[229713, 8340, 114, 3, 26, "Input",
      CellTags->"SetOptions::sstm"],
    Cell[229830, 8345, 199, 5, 21, "Message",
      CellTags->"SetOptions::sstm"],
    Cell[230032, 8352, 120, 3, 21, "Output",
      CellTags->"SetOptions::sstm"],
    Cell[230167, 8358, 163, 5, 24, "Text",
      CellTags->"SetOptions::sstm"],
    Cell[230355, 8367, 161, 4, 42, "Input",
      CellTags->"SetOptions::sstm"],
    Cell[230519, 8373, 105, 3, 21, "Output",
      CellTags->"SetOptions::sstm"],
    Cell[230639, 8379, 117, 5, 24, "Text",
      CellTags->"SetOptions::sstm"],
    Cell[230759, 8386, 102, 3, 26, "Input",
      CellTags->"SetOptions::sstm"]},
  "Stack::stackx"->{
    Cell[230910, 8395, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Stack::stackx"],
    Cell[230992, 8398, 545, 14, 37, "Message",
      CellTags->"Stack::stackx"],
    Cell[231540, 8414, 265, 6, 40, "Notes",
      CellTags->"Stack::stackx"],
    Cell[231830, 8424, 63, 1, 38, "ExampleSection",
      CellTags->"Stack::stackx"],
    Cell[231896, 8427, 216, 6, 40, "Text",
      CellTags->"Stack::stackx"],
    Cell[232137, 8437, 123, 3, 26, "Input",
      CellTags->"Stack::stackx"],
    Cell[232263, 8442, 259, 5, 37, "Message",
      CellTags->"Stack::stackx"],
    Cell[232525, 8449, 102, 3, 21, "Print",
      CellTags->"Stack::stackx"],
    Cell[232630, 8454, 98, 3, 21, "Output",
      CellTags->"Stack::stackx"],
    Cell[232743, 8460, 121, 5, 24, "Text",
      CellTags->"Stack::stackx"],
    Cell[232889, 8469, 123, 3, 26, "Input",
      CellTags->"Stack::stackx"],
    Cell[233015, 8474, 133, 4, 21, "Print",
      CellTags->"Stack::stackx"],
    Cell[233151, 8480, 98, 3, 21, "Output",
      CellTags->"Stack::stackx"]},
  "StringDrop::drop"->{
    Cell[233310, 8490, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"StringDrop::drop"],
    Cell[233398, 8493, 190, 4, 21, "Message",
      CellTags->"StringDrop::drop"],
    Cell[233591, 8499, 234, 5, 24, "Notes",
      CellTags->"StringDrop::drop"],
    Cell[233850, 8508, 66, 1, 38, "ExampleSection",
      CellTags->"StringDrop::drop"],
    Cell[233919, 8511, 157, 4, 24, "Text",
      CellTags->"StringDrop::drop"],
    Cell[234101, 8519, 135, 3, 26, "Input",
      CellTags->"StringDrop::drop"],
    Cell[234239, 8524, 226, 5, 21, "Message",
      CellTags->"StringDrop::drop"],
    Cell[234468, 8531, 132, 3, 21, "Output",
      CellTags->"StringDrop::drop"],
    Cell[234615, 8537, 133, 5, 24, "Text",
      CellTags->"StringDrop::drop"],
    Cell[234773, 8546, 134, 3, 26, "Input",
      CellTags->"StringDrop::drop"],
    Cell[234910, 8551, 104, 3, 21, "Output",
      CellTags->"StringDrop::drop"]},
  "StringInsert::ins"->{
    Cell[235075, 8561, 146, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[235224, 8567, 438, 13, 21, "Message",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[235665, 8582, 185, 4, 24, "Notes",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[235875, 8590, 95, 1, 38, "ExampleSection",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[235973, 8593, 207, 4, 24, "Text",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[236205, 8601, 160, 3, 26, "Input",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[236368, 8606, 229, 5, 21, "Message",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[236600, 8613, 153, 3, 21, "Output",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[236768, 8619, 164, 5, 24, "Text",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[236957, 8628, 161, 3, 26, "Input",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[237121, 8633, 132, 3, 21, "Output",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}]},
  "StringReplacePart::ins"->{
    Cell[235075, 8561, 146, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[235224, 8567, 438, 13, 21, "Message",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[235665, 8582, 185, 4, 24, "Notes",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[235875, 8590, 95, 1, 38, "ExampleSection",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[235973, 8593, 207, 4, 24, "Text",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[236205, 8601, 160, 3, 26, "Input",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[236368, 8606, 229, 5, 21, "Message",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[236600, 8613, 153, 3, 21, "Output",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[236768, 8619, 164, 5, 24, "Text",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[236957, 8628, 161, 3, 26, "Input",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
    Cell[237121, 8633, 132, 3, 21, "Output",
      CellTags->{"StringInsert::ins", "StringReplacePart::ins"}]},
  "StringPosition::meta"->{
    Cell[237314, 8643, 146, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[237463, 8649, 612, 16, 37, "Message",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[238078, 8667, 230, 5, 24, "Notes",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[238333, 8676, 95, 1, 38, "ExampleSection",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[238431, 8679, 253, 6, 40, "Text",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[238709, 8689, 192, 4, 26, "Input",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[238904, 8695, 294, 5, 53, "Message",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[239201, 8702, 186, 4, 21, "Output",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[239402, 8709, 176, 5, 24, "Text",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[239603, 8718, 213, 4, 26, "Input",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[239819, 8724, 127, 3, 21, "Output",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}]},
  "StringReplace::meta"->{
    Cell[237314, 8643, 146, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[237463, 8649, 612, 16, 37, "Message",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[238078, 8667, 230, 5, 24, "Notes",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[238333, 8676, 95, 1, 38, "ExampleSection",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[238431, 8679, 253, 6, 40, "Text",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[238709, 8689, 192, 4, 26, "Input",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[238904, 8695, 294, 5, 53, "Message",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[239201, 8702, 186, 4, 21, "Output",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[239402, 8709, 176, 5, 24, "Text",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[239603, 8718, 213, 4, 26, "Input",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}],
    Cell[239819, 8724, 127, 3, 21, "Output",
      CellTags->{"StringPosition::meta", "StringReplace::meta"}]},
  "StringReplace::srep"->{
    Cell[240007, 8734, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"StringReplace::srep"],
    Cell[240101, 8737, 232, 5, 21, "Message",
      CellTags->"StringReplace::srep"],
    Cell[240336, 8744, 365, 7, 62, "Notes",
      CellTags->"StringReplace::srep"],
    Cell[240726, 8755, 69, 1, 38, "ExampleSection",
      CellTags->"StringReplace::srep"],
    Cell[240798, 8758, 232, 6, 40, "Text",
      CellTags->"StringReplace::srep"],
    Cell[241055, 8768, 126, 3, 26, "Input",
      CellTags->"StringReplace::srep"],
    Cell[241184, 8773, 198, 5, 21, "Message",
      CellTags->"StringReplace::srep"],
    Cell[241385, 8780, 205, 5, 21, "Message",
      CellTags->"StringReplace::srep"],
    Cell[241593, 8787, 128, 3, 21, "Output",
      CellTags->"StringReplace::srep"],
    Cell[241736, 8793, 94, 1, 24, "Text",
      CellTags->"StringReplace::srep"],
    Cell[241855, 8798, 138, 3, 26, "Input",
      CellTags->"StringReplace::srep"],
    Cell[241996, 8803, 100, 3, 21, "Output",
      CellTags->"StringReplace::srep"]},
  "StringReplacePart::ovlp"->{
    Cell[242157, 8813, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"StringReplacePart::ovlp"],
    Cell[242259, 8816, 479, 14, 37, "Message",
      CellTags->"StringReplacePart::ovlp"],
    Cell[242741, 8832, 233, 6, 24, "Notes",
      CellTags->"StringReplacePart::ovlp"],
    Cell[242999, 8842, 73, 1, 38, "ExampleSection",
      CellTags->"StringReplacePart::ovlp"],
    Cell[243075, 8845, 175, 4, 24, "Text",
      CellTags->"StringReplacePart::ovlp"],
    Cell[243275, 8853, 168, 4, 26, "Input",
      CellTags->"StringReplacePart::ovlp"],
    Cell[243446, 8859, 251, 5, 37, "Message",
      CellTags->"StringReplacePart::ovlp"],
    Cell[243700, 8866, 107, 3, 21, "Output",
      CellTags->"StringReplacePart::ovlp"],
    Cell[243822, 8872, 147, 5, 24, "Text",
      CellTags->"StringReplacePart::ovlp"],
    Cell[243994, 8881, 168, 4, 26, "Input",
      CellTags->"StringReplacePart::ovlp"],
    Cell[244165, 8887, 106, 3, 21, "Output",
      CellTags->"StringReplacePart::ovlp"]},
  "StringReplacePart::repart"->{
    Cell[244332, 8897, 103, 1, 31, "ObjectNameWarningMessages",
      CellTags->"StringReplacePart::repart"],
    Cell[244438, 8900, 211, 4, 21, "Message",
      CellTags->"StringReplacePart::repart"],
    Cell[244652, 8906, 262, 6, 40, "Notes",
      CellTags->"StringReplacePart::repart"],
    Cell[244939, 8916, 75, 1, 38, "ExampleSection",
      CellTags->"StringReplacePart::repart"],
    Cell[245017, 8919, 200, 5, 40, "Text",
      CellTags->"StringReplacePart::repart"],
    Cell[245242, 8928, 148, 3, 26, "Input",
      CellTags->"StringReplacePart::repart"],
    Cell[245393, 8933, 233, 5, 21, "Message",
      CellTags->"StringReplacePart::repart"],
    Cell[245629, 8940, 141, 3, 21, "Output",
      CellTags->"StringReplacePart::repart"],
    Cell[245785, 8946, 130, 4, 24, "Text",
      CellTags->"StringReplacePart::repart"],
    Cell[245940, 8954, 148, 3, 26, "Input",
      CellTags->"StringReplacePart::repart"],
    Cell[246091, 8959, 107, 3, 21, "Output",
      CellTags->"StringReplacePart::repart"]},
  "StringReplacePart::spos"->{
    Cell[246259, 8969, 99, 1, 31, "ObjectNameWarningMessages",
      CellTags->"StringReplacePart::spos"],
    Cell[246361, 8972, 423, 11, 37, "Message",
      CellTags->"StringReplacePart::spos"],
    Cell[246787, 8985, 246, 5, 40, "Notes",
      CellTags->"StringReplacePart::spos"],
    Cell[247058, 8994, 73, 1, 38, "ExampleSection",
      CellTags->"StringReplacePart::spos"],
    Cell[247134, 8997, 150, 4, 24, "Text",
      CellTags->"StringReplacePart::spos"],
    Cell[247309, 9005, 143, 3, 26, "Input",
      CellTags->"StringReplacePart::spos"],
    Cell[247455, 9010, 237, 5, 37, "Message",
      CellTags->"StringReplacePart::spos"],
    Cell[247695, 9017, 136, 3, 21, "Output",
      CellTags->"StringReplacePart::spos"],
    Cell[247846, 9023, 162, 5, 24, "Text",
      CellTags->"StringReplacePart::spos"],
    Cell[248033, 9032, 146, 3, 26, "Input",
      CellTags->"StringReplacePart::spos"],
    Cell[248182, 9037, 107, 3, 21, "Output",
      CellTags->"StringReplacePart::spos"]},
  "Symbol::symname"->{
    Cell[248350, 9047, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Symbol::symname"],
    Cell[248436, 9050, 265, 5, 53, "Message",
      CellTags->"Symbol::symname"],
    Cell[248704, 9057, 192, 5, 24, "Notes",
      CellTags->"Symbol::symname"],
    Cell[248921, 9066, 65, 1, 38, "ExampleSection",
      CellTags->"Symbol::symname"],
    Cell[248989, 9069, 199, 5, 24, "Text",
      CellTags->"Symbol::symname"],
    Cell[249213, 9078, 109, 3, 26, "Input",
      CellTags->"Symbol::symname"],
    Cell[249325, 9083, 280, 6, 53, "Message",
      CellTags->"Symbol::symname"],
    Cell[249608, 9091, 106, 3, 21, "Output",
      CellTags->"Symbol::symname"],
    Cell[249729, 9097, 129, 5, 24, "Text",
      CellTags->"Symbol::symname"],
    Cell[249883, 9106, 107, 3, 26, "Input",
      CellTags->"Symbol::symname"],
    Cell[249993, 9111, 94, 3, 21, "Output",
      CellTags->"Symbol::symname"]},
  "TagSet::tagnf"->{
    Cell[250148, 9121, 169, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[250320, 9128, 425, 12, 21, "Message",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[250748, 9142, 223, 4, 24, "Notes",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[250996, 9150, 108, 1, 38, "ExampleSection",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[251107, 9153, 192, 4, 24, "Text",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[251324, 9161, 160, 3, 26, "Input",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[251487, 9166, 229, 4, 21, "Message",
      CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}],
    
    Cell[251719, 9172, 139, 3, 21, "Output",
      CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}],
    
    Cell[251873, 9178, 189, 4, 24, "Text",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[252065, 9184, 165, 3, 26, "Input",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[252255, 9191, 145, 3, 26, "Input",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[252403, 9196, 141, 3, 21, "Output",
      CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}],
    
    Cell[252559, 9202, 157, 5, 24, "Text",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[252719, 9209, 141, 3, 26, "Input",
      CellTags->{
      "TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}]},
  "TagSetDelayed::tagnf"->{
    Cell[250148, 9121, 169, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[250320, 9128, 425, 12, 21, "Message",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[250748, 9142, 223, 4, 24, "Notes",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[250996, 9150, 108, 1, 38, "ExampleSection",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[251107, 9153, 192, 4, 24, "Text",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[251324, 9161, 160, 3, 26, "Input",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[251487, 9166, 229, 4, 21, "Message",
      CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}],
    
    Cell[251719, 9172, 139, 3, 21, "Output",
      CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}],
    
    Cell[251873, 9178, 189, 4, 24, "Text",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[252065, 9184, 165, 3, 26, "Input",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[252255, 9191, 145, 3, 26, "Input",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[252403, 9196, 141, 3, 21, "Output",
      CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}],
    
    Cell[252559, 9202, 157, 5, 24, "Text",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[252719, 9209, 141, 3, 26, "Input",
      CellTags->{
      "TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}]},
  "TagUnset::tagnf"->{
    Cell[250148, 9121, 169, 5, 71, "ObjectNameWarningMessages",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[250320, 9128, 425, 12, 21, "Message",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[250748, 9142, 223, 4, 24, "Notes",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[250996, 9150, 108, 1, 38, "ExampleSection",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[251107, 9153, 192, 4, 24, "Text",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[251324, 9161, 160, 3, 26, "Input",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[251487, 9166, 229, 4, 21, "Message",
      CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}],
    
    Cell[251719, 9172, 139, 3, 21, "Output",
      CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}],
    
    Cell[251873, 9178, 189, 4, 24, "Text",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[252065, 9184, 165, 3, 26, "Input",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[252255, 9191, 145, 3, 26, "Input",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[252403, 9196, 141, 3, 21, "Output",
      CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}],
    
    Cell[252559, 9202, 157, 5, 24, "Text",
      CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
    
    Cell[252719, 9209, 141, 3, 26, "Input",
      CellTags->{
      "TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}]},
  "TagSet::tagpos"->{
    Cell[252909, 9218, 175, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[253087, 9225, 528, 13, 21, "Message",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[253618, 9240, 232, 4, 24, "Notes",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[253875, 9248, 111, 1, 38, "ExampleSection",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[253989, 9251, 249, 5, 40, "Text",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[254263, 9260, 153, 3, 26, "Input",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[254419, 9265, 276, 5, 37, "Message",
      CellTags->{
      "TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}],
    Cell[254698, 9272, 142, 3, 21, "Output",
      CellTags->{
      "TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}],
    Cell[254855, 9278, 198, 4, 24, "Text",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[255056, 9284, 154, 3, 26, "Input",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[255235, 9291, 143, 3, 26, "Input",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[255381, 9296, 136, 3, 21, "Output",
      CellTags->{
      "TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}],
    Cell[255532, 9302, 159, 5, 24, "Text",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[255694, 9309, 143, 3, 26, "Input",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}]},
  "TagSetDelayed::tagpos"->{
    Cell[252909, 9218, 175, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[253087, 9225, 528, 13, 21, "Message",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[253618, 9240, 232, 4, 24, "Notes",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[253875, 9248, 111, 1, 38, "ExampleSection",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[253989, 9251, 249, 5, 40, "Text",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[254263, 9260, 153, 3, 26, "Input",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[254419, 9265, 276, 5, 37, "Message",
      CellTags->{
      "TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}],
    Cell[254698, 9272, 142, 3, 21, "Output",
      CellTags->{
      "TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}],
    Cell[254855, 9278, 198, 4, 24, "Text",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[255056, 9284, 154, 3, 26, "Input",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[255235, 9291, 143, 3, 26, "Input",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[255381, 9296, 136, 3, 21, "Output",
      CellTags->{
      "TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}],
    Cell[255532, 9302, 159, 5, 24, "Text",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[255694, 9309, 143, 3, 26, "Input",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}]},
  "TagUnset::tagpos"->{
    Cell[252909, 9218, 175, 5, 71, "ObjectNameWarningMessages",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[253087, 9225, 528, 13, 21, "Message",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[253618, 9240, 232, 4, 24, "Notes",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[253875, 9248, 111, 1, 38, "ExampleSection",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[253989, 9251, 249, 5, 40, "Text",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[254263, 9260, 153, 3, 26, "Input",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[254419, 9265, 276, 5, 37, "Message",
      CellTags->{
      "TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}],
    Cell[254698, 9272, 142, 3, 21, "Output",
      CellTags->{
      "TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}],
    Cell[254855, 9278, 198, 4, 24, "Text",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[255056, 9284, 154, 3, 26, "Input",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[255235, 9291, 143, 3, 26, "Input",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[255381, 9296, 136, 3, 21, "Output",
      CellTags->{
      "TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}],
    Cell[255532, 9302, 159, 5, 24, "Text",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
    Cell[255694, 9309, 143, 3, 26, "Input",
      CellTags->{
      "TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}]},
  "Throw::nocatch"->{
    Cell[255886, 9318, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Throw::nocatch"],
    Cell[255970, 9321, 226, 5, 21, "Message",
      CellTags->"Throw::nocatch"],
    Cell[256199, 9328, 196, 7, 24, "Notes",
      CellTags->"Throw::nocatch"],
    Cell[256420, 9339, 64, 1, 38, "ExampleSection",
      CellTags->"Throw::nocatch"],
    Cell[256487, 9342, 199, 7, 24, "Text",
      CellTags->"Throw::nocatch"],
    Cell[256711, 9353, 141, 3, 26, "Input",
      CellTags->"Throw::nocatch"],
    Cell[256855, 9358, 190, 5, 21, "Print",
      CellTags->"Throw::nocatch"],
    Cell[257048, 9365, 190, 5, 21, "Print",
      CellTags->"Throw::nocatch"],
    Cell[257241, 9372, 190, 5, 21, "Print",
      CellTags->"Throw::nocatch"],
    Cell[257434, 9379, 182, 4, 21, "Message",
      CellTags->"Throw::nocatch"],
    Cell[257619, 9385, 102, 3, 21, "Output",
      CellTags->"Throw::nocatch"],
    Cell[257736, 9391, 160, 7, 24, "Text",
      CellTags->"Throw::nocatch"],
    Cell[257921, 9402, 155, 4, 26, "Input",
      CellTags->"Throw::nocatch"],
    Cell[258079, 9408, 190, 5, 21, "Print",
      CellTags->"Throw::nocatch"],
    Cell[258272, 9415, 190, 5, 21, "Print",
      CellTags->"Throw::nocatch"],
    Cell[258465, 9422, 190, 5, 21, "Print",
      CellTags->"Throw::nocatch"],
    Cell[258658, 9429, 89, 3, 21, "Output",
      CellTags->"Throw::nocatch"]},
  "Trace::tracb"->{
    Cell[258808, 9439, 212, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[259023, 9449, 682, 20, 37, "Message",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[259708, 9471, 265, 7, 24, "Notes",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[259998, 9482, 135, 3, 38, "ExampleSection",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[260136, 9487, 255, 8, 24, "Text",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[260416, 9499, 205, 5, 26, "Input",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[260624, 9506, 316, 7, 37, "Message",
      CellTags->{
      "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
        "Trace::tracb"}],
    Cell[260943, 9515, 211, 5, 21, "Output",
      CellTags->{
      "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
        "Trace::tracb"}],
    Cell[261169, 9523, 249, 9, 24, "Text",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[261443, 9536, 204, 5, 26, "Input",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[261650, 9543, 543, 18, 21, "Output",
      CellTags->{
      "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
        "Trace::tracb"}]},
  "TraceScan::tracb"->{
    Cell[258808, 9439, 212, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[259023, 9449, 682, 20, 37, "Message",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[259708, 9471, 265, 7, 24, "Notes",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[259998, 9482, 135, 3, 38, "ExampleSection",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[260136, 9487, 255, 8, 24, "Text",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[260416, 9499, 205, 5, 26, "Input",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[260624, 9506, 316, 7, 37, "Message",
      CellTags->{
      "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
        "Trace::tracb"}],
    Cell[260943, 9515, 211, 5, 21, "Output",
      CellTags->{
      "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
        "Trace::tracb"}],
    Cell[261169, 9523, 249, 9, 24, "Text",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[261443, 9536, 204, 5, 26, "Input",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[261650, 9543, 543, 18, 21, "Output",
      CellTags->{
      "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
        "Trace::tracb"}]},
  "TracePrint::tracb"->{
    Cell[258808, 9439, 212, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[259023, 9449, 682, 20, 37, "Message",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[259708, 9471, 265, 7, 24, "Notes",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[259998, 9482, 135, 3, 38, "ExampleSection",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[260136, 9487, 255, 8, 24, "Text",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[260416, 9499, 205, 5, 26, "Input",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[260624, 9506, 316, 7, 37, "Message",
      CellTags->{
      "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
        "Trace::tracb"}],
    Cell[260943, 9515, 211, 5, 21, "Output",
      CellTags->{
      "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
        "Trace::tracb"}],
    Cell[261169, 9523, 249, 9, 24, "Text",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[261443, 9536, 204, 5, 26, "Input",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[261650, 9543, 543, 18, 21, "Output",
      CellTags->{
      "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
        "Trace::tracb"}]},
  "TraceDialog::tracb"->{
    Cell[258808, 9439, 212, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[259023, 9449, 682, 20, 37, "Message",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[259708, 9471, 265, 7, 24, "Notes",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[259998, 9482, 135, 3, 38, "ExampleSection",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[260136, 9487, 255, 8, 24, "Text",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[260416, 9499, 205, 5, 26, "Input",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[260624, 9506, 316, 7, 37, "Message",
      CellTags->{
      "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
        "Trace::tracb"}],
    Cell[260943, 9515, 211, 5, 21, "Output",
      CellTags->{
      "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
        "Trace::tracb"}],
    Cell[261169, 9523, 249, 9, 24, "Text",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[261443, 9536, 204, 5, 26, "Input",
      CellTags->{
      "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
        "TraceDialog::tracb"}],
    Cell[261650, 9543, 543, 18, 21, "Output",
      CellTags->{
      "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
        "Trace::tracb"}]},
  "Trace::tracd"->{
    Cell[262254, 9568, 212, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[262469, 9578, 623, 18, 21, "Message",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263095, 9598, 391, 15, 24, "Notes",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263511, 9617, 135, 3, 38, "ExampleSection",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263649, 9622, 262, 8, 24, "Text",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263936, 9634, 209, 5, 26, "Input",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[264148, 9641, 284, 7, 21, "Message",
      CellTags->{
      "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
        "Trace::tracd"}],
    Cell[264435, 9650, 228, 6, 21, "Output",
      CellTags->{
      "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
        "Trace::tracd"}],
    Cell[264678, 9659, 252, 9, 24, "Text",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[264955, 9672, 212, 5, 26, "Input",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[265170, 9679, 289, 10, 21, "Output",
      CellTags->{
      "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
        "Trace::tracd"}]},
  "TraceScan::tracd"->{
    Cell[262254, 9568, 212, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[262469, 9578, 623, 18, 21, "Message",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263095, 9598, 391, 15, 24, "Notes",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263511, 9617, 135, 3, 38, "ExampleSection",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263649, 9622, 262, 8, 24, "Text",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263936, 9634, 209, 5, 26, "Input",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[264148, 9641, 284, 7, 21, "Message",
      CellTags->{
      "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
        "Trace::tracd"}],
    Cell[264435, 9650, 228, 6, 21, "Output",
      CellTags->{
      "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
        "Trace::tracd"}],
    Cell[264678, 9659, 252, 9, 24, "Text",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[264955, 9672, 212, 5, 26, "Input",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[265170, 9679, 289, 10, 21, "Output",
      CellTags->{
      "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
        "Trace::tracd"}]},
  "TracePrint::tracd"->{
    Cell[262254, 9568, 212, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[262469, 9578, 623, 18, 21, "Message",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263095, 9598, 391, 15, 24, "Notes",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263511, 9617, 135, 3, 38, "ExampleSection",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263649, 9622, 262, 8, 24, "Text",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263936, 9634, 209, 5, 26, "Input",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[264148, 9641, 284, 7, 21, "Message",
      CellTags->{
      "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
        "Trace::tracd"}],
    Cell[264435, 9650, 228, 6, 21, "Output",
      CellTags->{
      "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
        "Trace::tracd"}],
    Cell[264678, 9659, 252, 9, 24, "Text",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[264955, 9672, 212, 5, 26, "Input",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[265170, 9679, 289, 10, 21, "Output",
      CellTags->{
      "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
        "Trace::tracd"}]},
  "TraceDialog::tracd"->{
    Cell[262254, 9568, 212, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[262469, 9578, 623, 18, 21, "Message",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263095, 9598, 391, 15, 24, "Notes",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263511, 9617, 135, 3, 38, "ExampleSection",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263649, 9622, 262, 8, 24, "Text",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[263936, 9634, 209, 5, 26, "Input",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[264148, 9641, 284, 7, 21, "Message",
      CellTags->{
      "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
        "Trace::tracd"}],
    Cell[264435, 9650, 228, 6, 21, "Output",
      CellTags->{
      "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
        "Trace::tracd"}],
    Cell[264678, 9659, 252, 9, 24, "Text",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[264955, 9672, 212, 5, 26, "Input",
      CellTags->{
      "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
        "TraceDialog::tracd"}],
    Cell[265170, 9679, 289, 10, 21, "Output",
      CellTags->{
      "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
        "Trace::tracd"}]},
  "TraceLevel::notrc"->{
    Cell[265520, 9696, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"TraceLevel::notrc"],
    Cell[265610, 9699, 165, 3, 21, "Message",
      CellTags->"TraceLevel::notrc"],
    Cell[265778, 9704, 184, 5, 24, "Notes",
      CellTags->"TraceLevel::notrc"],
    Cell[265987, 9713, 67, 1, 38, "ExampleSection",
      CellTags->"TraceLevel::notrc"],
    Cell[266057, 9716, 228, 5, 40, "Text",
      CellTags->"TraceLevel::notrc"],
    Cell[266310, 9725, 176, 4, 26, "Input",
      CellTags->"TraceLevel::notrc"],
    Cell[266489, 9731, 180, 4, 21, "Message",
      CellTags->"TraceLevel::notrc"],
    Cell[266672, 9737, 213, 5, 21, "Print",
      CellTags->"TraceLevel::notrc"],
    Cell[266888, 9744, 93, 3, 21, "Output",
      CellTags->"TraceLevel::notrc"],
    Cell[266996, 9750, 194, 5, 24, "Text",
      CellTags->"TraceLevel::notrc"],
    Cell[267215, 9759, 174, 4, 26, "Input",
      CellTags->"TraceLevel::notrc"],
    Cell[267392, 9765, 213, 5, 21, "Print",
      CellTags->"TraceLevel::notrc"],
    Cell[267608, 9772, 1893, 49, 69, "Output",
      CellTags->"TraceLevel::notrc"]},
  "Unset::cxun"->{
    Cell[269562, 9828, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Unset::cxun"],
    Cell[269640, 9831, 134, 3, 21, "Message",
      CellTags->"Unset::cxun"],
    Cell[269777, 9836, 161, 5, 24, "Notes",
      CellTags->"Unset::cxun"],
    Cell[269963, 9845, 61, 1, 38, "ExampleSection",
      CellTags->"Unset::cxun"],
    Cell[270027, 9848, 133, 4, 24, "Text",
      CellTags->"Unset::cxun"],
    Cell[270185, 9856, 98, 3, 26, "Input",
      CellTags->"Unset::cxun"],
    Cell[270286, 9861, 145, 3, 21, "Message",
      CellTags->"Unset::cxun"],
    Cell[270434, 9866, 92, 3, 21, "Output",
      CellTags->"Unset::cxun"]},
  "Alias::almark"->{
    Cell[270587, 9876, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Alias::almark"],
    Cell[270669, 9879, 239, 6, 21, "Message",
      CellTags->"Alias::almark"],
    Cell[270911, 9887, 403, 10, 46, "Notes",
      CellTags->"Alias::almark"],
    Cell[271339, 9901, 63, 1, 38, "ExampleSection",
      CellTags->"Alias::almark"],
    Cell[271405, 9904, 188, 5, 24, "Text",
      CellTags->"Alias::almark"],
    Cell[271618, 9913, 107, 3, 26, "Input",
      CellTags->"Alias::almark"],
    Cell[271728, 9918, 184, 4, 21, "Message",
      CellTags->"Alias::almark"],
    Cell[271915, 9924, 102, 3, 21, "Output",
      CellTags->"Alias::almark"],
    Cell[272032, 9930, 125, 5, 24, "Text",
      CellTags->"Alias::almark"],
    Cell[272182, 9939, 105, 3, 26, "Input",
      CellTags->"Alias::almark"],
    Cell[272290, 9944, 88, 3, 21, "Output",
      CellTags->"Alias::almark"],
    Cell[272415, 9952, 87, 3, 26, "Input",
      CellTags->"Alias::almark"],
    Cell[272505, 9957, 88, 3, 21, "Output",
      CellTags->"Alias::almark"],
    Cell[272608, 9963, 62, 1, 24, "Text",
      CellTags->"Alias::almark"],
    Cell[272695, 9968, 102, 3, 26, "Input",
      CellTags->"Alias::almark"],
    Cell[272800, 9973, 90, 3, 21, "Output",
      CellTags->"Alias::almark"]},
  "UnAlias::alspr"->{
    Cell[272951, 9983, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"UnAlias::alspr"],
    Cell[273035, 9986, 233, 5, 21, "Message",
      CellTags->"UnAlias::alspr"],
    Cell[273271, 9993, 363, 11, 46, "Notes",
      CellTags->"UnAlias::alspr"],
    Cell[273659, 10008, 64, 1, 38, "ExampleSection",
      CellTags->"UnAlias::alspr"],
    Cell[273726, 10011, 137, 4, 24, "Text",
      CellTags->"UnAlias::alspr"],
    Cell[273888, 10019, 104, 3, 26, "Input",
      CellTags->"UnAlias::alspr"],
    Cell[273995, 10024, 179, 4, 21, "Message",
      CellTags->"UnAlias::alspr"],
    Cell[274177, 10030, 105, 3, 21, "Output",
      CellTags->"UnAlias::alspr"],
    Cell[274297, 10036, 91, 1, 24, "Text",
      CellTags->"UnAlias::alspr"],
    Cell[274413, 10041, 118, 3, 26, "Input",
      CellTags->"UnAlias::alspr"],
    Cell[274534, 10046, 96, 3, 21, "Output",
      CellTags->"UnAlias::alspr"],
    Cell[274667, 10054, 95, 3, 26, "Input",
      CellTags->"UnAlias::alspr"],
    Cell[274765, 10059, 96, 3, 21, "Output",
      CellTags->"UnAlias::alspr"],
    Cell[274876, 10065, 83, 1, 24, "Text",
      CellTags->"UnAlias::alspr"],
    Cell[274984, 10070, 110, 3, 26, "Input",
      CellTags->"UnAlias::alspr"],
    Cell[275097, 10075, 98, 3, 21, "Output",
      CellTags->"UnAlias::alspr"],
    Cell[275232, 10083, 95, 3, 26, "Input",
      CellTags->"UnAlias::alspr"],
    Cell[275330, 10088, 96, 3, 21, "Output",
      CellTags->"UnAlias::alspr"]},
  "Uninstall::unlink"->{
    Cell[275487, 10098, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Uninstall::unlink"],
    Cell[275577, 10101, 252, 6, 21, "Message",
      CellTags->"Uninstall::unlink"],
    Cell[275832, 10109, 254, 8, 24, "Notes",
      CellTags->"Uninstall::unlink"],
    Cell[276111, 10121, 67, 1, 38, "ExampleSection",
      CellTags->"Uninstall::unlink"],
    Cell[276181, 10124, 215, 6, 24, "Text",
      CellTags->"Uninstall::unlink"],
    Cell[276421, 10134, 111, 3, 26, "Input",
      CellTags->"Uninstall::unlink"],
    Cell[276535, 10139, 199, 5, 21, "Message",
      CellTags->"Uninstall::unlink"]},
  "Unique::usym"->{
    Cell[276795, 10151, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Unique::usym"],
    Cell[276875, 10154, 220, 5, 21, "Message",
      CellTags->"Unique::usym"],
    Cell[277098, 10161, 247, 6, 40, "Notes",
      CellTags->"Unique::usym"],
    Cell[277370, 10171, 62, 1, 38, "ExampleSection",
      CellTags->"Unique::usym"],
    Cell[277435, 10174, 151, 4, 24, "Text",
      CellTags->"Unique::usym"],
    Cell[277611, 10182, 101, 3, 26, "Input",
      CellTags->"Unique::usym"],
    Cell[277715, 10187, 319, 6, 21, "Message",
      CellTags->"Unique::usym"],
    Cell[278037, 10195, 98, 3, 21, "Output",
      CellTags->"Unique::usym"],
    Cell[278150, 10201, 126, 5, 24, "Text",
      CellTags->"Unique::usym"],
    Cell[278301, 10210, 105, 3, 26, "Input",
      CellTags->"Unique::usym"],
    Cell[278409, 10215, 93, 3, 21, "Output",
      CellTags->"Unique::usym"]},
  "Unset::norep"->{
    Cell[278563, 10225, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[278688, 10231, 416, 12, 21, "Message",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[279107, 10245, 382, 11, 46, "Notes",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[279514, 10260, 83, 1, 38, "ExampleSection",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[279600, 10263, 204, 6, 24, "Text",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[279829, 10273, 124, 3, 26, "Input",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[279956, 10278, 215, 5, 21, "Message",
      CellTags->{"TagUnset::norep", "Unset::norep"}],
    Cell[280174, 10285, 114, 3, 21, "Output",
      CellTags->{"TagUnset::norep", "Unset::norep"}],
    Cell[280303, 10291, 141, 5, 24, "Text",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[280447, 10298, 127, 3, 26, "Input",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[280599, 10305, 116, 3, 26, "Input",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[280718, 10310, 113, 3, 21, "Output",
      CellTags->{"TagUnset::norep", "Unset::norep"}],
    Cell[280846, 10316, 121, 3, 26, "Input",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[280992, 10323, 116, 3, 26, "Input",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[281111, 10328, 117, 3, 21, "Output",
      CellTags->{"TagUnset::norep", "Unset::norep"}]},
  "TagUnset::norep"->{
    Cell[278563, 10225, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[278688, 10231, 416, 12, 21, "Message",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[279107, 10245, 382, 11, 46, "Notes",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[279514, 10260, 83, 1, 38, "ExampleSection",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[279600, 10263, 204, 6, 24, "Text",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[279829, 10273, 124, 3, 26, "Input",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[279956, 10278, 215, 5, 21, "Message",
      CellTags->{"TagUnset::norep", "Unset::norep"}],
    Cell[280174, 10285, 114, 3, 21, "Output",
      CellTags->{"TagUnset::norep", "Unset::norep"}],
    Cell[280303, 10291, 141, 5, 24, "Text",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[280447, 10298, 127, 3, 26, "Input",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[280599, 10305, 116, 3, 26, "Input",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[280718, 10310, 113, 3, 21, "Output",
      CellTags->{"TagUnset::norep", "Unset::norep"}],
    Cell[280846, 10316, 121, 3, 26, "Input",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[280992, 10323, 116, 3, 26, "Input",
      CellTags->{"Unset::norep", "TagUnset::norep"}],
    Cell[281111, 10328, 117, 3, 21, "Output",
      CellTags->{"TagUnset::norep", "Unset::norep"}]},
  "Unset::usraw"->{
    Cell[281289, 10338, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Unset::usraw", "TagUnset::usraw"}],
    Cell[281414, 10344, 372, 11, 21, "Message",
      CellTags->{"Unset::usraw", "TagUnset::usraw"}],
    Cell[281789, 10357, 475, 16, 46, "Notes",
      CellTags->{"Unset::usraw", "TagUnset::usraw"}],
    Cell[282289, 10377, 83, 1, 38, "ExampleSection",
      CellTags->{"Unset::usraw", "TagUnset::usraw"}],
    Cell[282375, 10380, 183, 5, 24, "Text",
      CellTags->{"Unset::usraw", "TagUnset::usraw"}],
    Cell[282583, 10389, 111, 3, 26, "Input",
      CellTags->{"Unset::usraw", "TagUnset::usraw"}],
    Cell[282697, 10394, 185, 4, 21, "Message",
      CellTags->{"TagUnset::usraw", "Unset::usraw"}],
    Cell[282885, 10400, 114, 3, 21, "Output",
      CellTags->{"TagUnset::usraw", "Unset::usraw"}]},
  "TagUnset::usraw"->{
    Cell[281289, 10338, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Unset::usraw", "TagUnset::usraw"}],
    Cell[281414, 10344, 372, 11, 21, "Message",
      CellTags->{"Unset::usraw", "TagUnset::usraw"}],
    Cell[281789, 10357, 475, 16, 46, "Notes",
      CellTags->{"Unset::usraw", "TagUnset::usraw"}],
    Cell[282289, 10377, 83, 1, 38, "ExampleSection",
      CellTags->{"Unset::usraw", "TagUnset::usraw"}],
    Cell[282375, 10380, 183, 5, 24, "Text",
      CellTags->{"Unset::usraw", "TagUnset::usraw"}],
    Cell[282583, 10389, 111, 3, 26, "Input",
      CellTags->{"Unset::usraw", "TagUnset::usraw"}],
    Cell[282697, 10394, 185, 4, 21, "Message",
      CellTags->{"TagUnset::usraw", "Unset::usraw"}],
    Cell[282885, 10400, 114, 3, 21, "Output",
      CellTags->{"TagUnset::usraw", "Unset::usraw"}]},
  "Unset::usrpt"->{
    Cell[283060, 10410, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
    Cell[283185, 10416, 443, 13, 21, "Message",
      CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
    Cell[283631, 10431, 238, 7, 24, "Notes",
      CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
    Cell[283894, 10442, 83, 1, 38, "ExampleSection",
      CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
    Cell[283980, 10445, 170, 4, 24, "Text",
      CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
    Cell[284175, 10453, 121, 3, 26, "Input",
      CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
    Cell[284299, 10458, 216, 5, 21, "Message",
      CellTags->{"TagUnset::usrpt", "Unset::usrpt"}],
    Cell[284518, 10465, 114, 3, 21, "Output",
      CellTags->{"TagUnset::usrpt", "Unset::usrpt"}]},
  "TagUnset::usrpt"->{
    Cell[283060, 10410, 122, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
    Cell[283185, 10416, 443, 13, 21, "Message",
      CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
    Cell[283631, 10431, 238, 7, 24, "Notes",
      CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
    Cell[283894, 10442, 83, 1, 38, "ExampleSection",
      CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
    Cell[283980, 10445, 170, 4, 24, "Text",
      CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
    Cell[284175, 10453, 121, 3, 26, "Input",
      CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
    Cell[284299, 10458, 216, 5, 21, "Message",
      CellTags->{"TagUnset::usrpt", "Unset::usrpt"}],
    Cell[284518, 10465, 114, 3, 21, "Output",
      CellTags->{"TagUnset::usrpt", "Unset::usrpt"}]},
  "General::altno"->{
    Cell[284693, 10475, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::altno"],
    Cell[284777, 10478, 405, 12, 21, "Message",
      CellTags->"General::altno"],
    Cell[285185, 10492, 880, 29, 84, "Notes",
      CellTags->"General::altno"],
    Cell[286090, 10525, 64, 1, 38, "ExampleSection",
      CellTags->"General::altno"],
    Cell[286157, 10528, 292, 7, 40, "Text",
      CellTags->"General::altno"],
    Cell[286474, 10539, 107, 3, 26, "Input",
      CellTags->"General::altno"],
    Cell[286584, 10544, 206, 5, 21, "Message",
      CellTags->"General::altno"],
    Cell[286793, 10551, 89, 3, 21, "Output",
      CellTags->"General::altno"],
    Cell[286897, 10557, 125, 4, 24, "Text",
      CellTags->"General::altno"],
    Cell[287047, 10565, 107, 3, 26, "Input",
      CellTags->"General::altno"],
    Cell[287157, 10570, 89, 3, 21, "Output",
      CellTags->"General::altno"],
    Cell[287283, 10578, 101, 3, 26, "Input",
      CellTags->"General::altno"],
    Cell[287387, 10583, 94, 3, 21, "Output",
      CellTags->"General::altno"],
    Cell[287496, 10589, 62, 1, 24, "Text",
      CellTags->"General::altno"],
    Cell[287561, 10592, 107, 3, 26, "Input",
      CellTags->"General::altno"]},
  "General::bebal"->{
    Cell[287717, 10601, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::bebal"],
    Cell[287801, 10604, 406, 12, 21, "Message",
      CellTags->"General::bebal"],
    Cell[288210, 10618, 781, 25, 100, "Notes",
      CellTags->"General::bebal"],
    Cell[289016, 10647, 64, 1, 38, "ExampleSection",
      CellTags->"General::bebal"],
    Cell[289083, 10650, 221, 7, 24, "Text",
      CellTags->"General::bebal"],
    Cell[289307, 10659, 155, 4, 26, "Input",
      CellTags->"General::bebal"],
    Cell[289487, 10667, 108, 3, 26, "Input",
      CellTags->"General::bebal"],
    Cell[289598, 10672, 98, 3, 21, "Output",
      CellTags->"General::bebal"],
    Cell[289733, 10680, 106, 3, 26, "Input",
      CellTags->"General::bebal"],
    Cell[289842, 10685, 202, 5, 21, "Message",
      CellTags->"General::bebal"],
    Cell[290047, 10692, 105, 3, 21, "Output",
      CellTags->"General::bebal"],
    Cell[290167, 10698, 137, 5, 24, "Text",
      CellTags->"General::bebal"],
    Cell[290329, 10707, 92, 3, 26, "Input",
      CellTags->"General::bebal"],
    Cell[290424, 10712, 105, 3, 21, "Output",
      CellTags->"General::bebal"],
    Cell[290544, 10718, 73, 1, 24, "Text",
      CellTags->"General::bebal"],
    Cell[290620, 10721, 113, 3, 26, "Input",
      CellTags->"General::bebal"]},
  "General::cxls"->{
    Cell[290782, 10730, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::cxls"],
    Cell[290864, 10733, 543, 16, 21, "Message",
      CellTags->"General::cxls"],
    Cell[291410, 10751, 449, 8, 78, "Notes",
      CellTags->"General::cxls"],
    Cell[291884, 10763, 63, 1, 38, "ExampleSection",
      CellTags->"General::cxls"],
    Cell[291950, 10766, 224, 5, 40, "Text",
      CellTags->"General::cxls"],
    Cell[292199, 10775, 140, 3, 26, "Input",
      CellTags->"General::cxls"],
    Cell[292342, 10780, 276, 6, 37, "Message",
      CellTags->"General::cxls"],
    Cell[292621, 10788, 131, 3, 21, "Output",
      CellTags->"General::cxls"]},
  "General::cxt"->{
    Cell[292813, 10798, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::cxt"],
    Cell[292893, 10801, 545, 17, 21, "Message",
      CellTags->"General::cxt"],
    Cell[293441, 10820, 348, 7, 62, "Notes",
      CellTags->"General::cxt"],
    Cell[293814, 10831, 62, 1, 38, "ExampleSection",
      CellTags->"General::cxt"],
    Cell[293879, 10834, 182, 4, 40, "Text",
      CellTags->"General::cxt"],
    Cell[294086, 10842, 106, 3, 26, "Input",
      CellTags->"General::cxt"],
    Cell[294195, 10847, 274, 6, 37, "Message",
      CellTags->"General::cxt"],
    Cell[294472, 10855, 229, 5, 37, "Message",
      CellTags->"General::cxt"],
    Cell[294704, 10862, 103, 3, 21, "Output",
      CellTags->"General::cxt"],
    Cell[294822, 10868, 85, 1, 24, "Text",
      CellTags->"General::cxt"],
    Cell[294932, 10873, 106, 3, 26, "Input",
      CellTags->"General::cxt"],
    Cell[295041, 10878, 96, 3, 21, "Output",
      CellTags->"General::cxt"],
    Cell[295152, 10884, 73, 1, 24, "Text",
      CellTags->"General::cxt"],
    Cell[295250, 10889, 90, 3, 26, "Input",
      CellTags->"General::cxt"],
    Cell[295343, 10894, 96, 3, 21, "Output",
      CellTags->"General::cxt"]},
  "General::mbox"->{
    Cell[295500, 10904, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::mbox"],
    Cell[295582, 10907, 258, 7, 21, "Message",
      CellTags->"General::mbox"],
    Cell[295843, 10916, 318, 8, 46, "Notes",
      CellTags->"General::mbox"]},
  "General::newsym"->{
    Cell[296198, 10929, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::newsym"],
    Cell[296284, 10932, 315, 9, 21, "Message",
      CellTags->"General::newsym"],
    Cell[296602, 10943, 284, 7, 46, "Notes",
      CellTags->"General::newsym"],
    Cell[296911, 10954, 65, 1, 38, "ExampleSection",
      CellTags->"General::newsym"],
    Cell[296979, 10957, 88, 1, 24, "Text",
      CellTags->"General::newsym"],
    Cell[297070, 10960, 107, 3, 26, "Input",
      CellTags->"General::newsym"],
    Cell[297202, 10967, 99, 3, 26, "Input",
      CellTags->"General::newsym"],
    Cell[297304, 10972, 170, 4, 21, "Message",
      CellTags->"General::newsym"],
    Cell[297477, 10978, 100, 3, 21, "Output",
      CellTags->"General::newsym"],
    Cell[297592, 10984, 108, 3, 26, "Input",
      CellTags->"General::newsym"]},
  "General::nosym"->{
    Cell[297749, 10993, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nosym"],
    Cell[297833, 10996, 447, 12, 21, "Message",
      CellTags->"General::nosym"],
    Cell[298283, 11010, 314, 7, 62, "Notes",
      CellTags->"General::nosym"],
    Cell[298622, 11021, 64, 1, 38, "ExampleSection",
      CellTags->"General::nosym"],
    Cell[298689, 11024, 150, 4, 24, "Text",
      CellTags->"General::nosym"],
    Cell[298864, 11032, 113, 3, 26, "Input",
      CellTags->"General::nosym"],
    Cell[298980, 11037, 214, 5, 37, "Message",
      CellTags->"General::nosym"],
    Cell[299197, 11044, 97, 3, 21, "Output",
      CellTags->"General::nosym"],
    Cell[299309, 11050, 106, 1, 24, "Text",
      CellTags->"General::nosym"],
    Cell[299440, 11055, 114, 3, 26, "Input",
      CellTags->"General::nosym"],
    Cell[299557, 11060, 97, 3, 21, "Output",
      CellTags->"General::nosym"]},
  "General::noval"->{
    Cell[299715, 11070, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::noval"],
    Cell[299799, 11073, 427, 11, 21, "Message",
      CellTags->"General::noval"],
    Cell[300229, 11086, 685, 19, 68, "Notes",
      CellTags->"General::noval"],
    Cell[300939, 11109, 64, 1, 38, "ExampleSection",
      CellTags->"General::noval"],
    Cell[301006, 11112, 253, 7, 40, "Text",
      CellTags->"General::noval"],
    Cell[301284, 11123, 106, 3, 26, "Input",
      CellTags->"General::noval"],
    Cell[301393, 11128, 206, 5, 21, "Message",
      CellTags->"General::noval"],
    Cell[301602, 11135, 89, 3, 21, "Output",
      CellTags->"General::noval"],
    Cell[301706, 11141, 159, 5, 24, "Text",
      CellTags->"General::noval"],
    Cell[301868, 11148, 115, 3, 26, "Input",
      CellTags->"General::noval"],
    Cell[302008, 11155, 106, 3, 26, "Input",
      CellTags->"General::noval"],
    Cell[302117, 11160, 206, 5, 21, "Message",
      CellTags->"General::noval"],
    Cell[302326, 11167, 89, 3, 21, "Output",
      CellTags->"General::noval"],
    Cell[302430, 11173, 156, 5, 24, "Text",
      CellTags->"General::noval"],
    Cell[302611, 11182, 114, 3, 26, "Input",
      CellTags->"General::noval"],
    Cell[302728, 11187, 106, 3, 21, "Output",
      CellTags->"General::noval"],
    Cell[302871, 11195, 106, 3, 26, "Input",
      CellTags->"General::noval"],
    Cell[302980, 11200, 89, 3, 21, "Output",
      CellTags->"General::noval"],
    Cell[303106, 11208, 93, 3, 26, "Input",
      CellTags->"General::noval"],
    Cell[303202, 11213, 103, 3, 21, "Output",
      CellTags->"General::noval"],
    Cell[303320, 11219, 116, 5, 24, "Text",
      CellTags->"General::noval"],
    Cell[303439, 11226, 100, 3, 26, "Input",
      CellTags->"General::noval"]},
  "General::opset"->{
    Cell[303588, 11235, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::opset"],
    Cell[303672, 11238, 394, 12, 21, "Message",
      CellTags->"General::opset"],
    Cell[304069, 11252, 229, 6, 46, "Notes",
      CellTags->"General::opset"],
    Cell[304323, 11262, 64, 1, 38, "ExampleSection",
      CellTags->"General::opset"],
    Cell[304390, 11265, 154, 4, 24, "Text",
      CellTags->"General::opset"],
    Cell[304569, 11273, 270, 5, 138, "Input",
      CellTags->"General::opset"],
    Cell[304842, 11280, 196, 5, 21, "Message",
      CellTags->"General::opset"],
    Cell[305041, 11287, 99, 3, 21, "Output",
      CellTags->"General::opset"]},
  "General::optb"->{
    Cell[305201, 11297, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::optb"],
    Cell[305283, 11300, 439, 13, 21, "Message",
      CellTags->"General::optb"],
    Cell[305725, 11315, 601, 21, 46, "Notes",
      CellTags->"General::optb"],
    Cell[306351, 11340, 63, 1, 38, "ExampleSection",
      CellTags->"General::optb"],
    Cell[306417, 11343, 308, 13, 24, "Text",
      CellTags->"General::optb"],
    Cell[306750, 11360, 126, 3, 26, "Input",
      CellTags->"General::optb"],
    Cell[306879, 11365, 199, 5, 21, "Message",
      CellTags->"General::optb"],
    Cell[307081, 11372, 101, 3, 21, "Output",
      CellTags->"General::optb"],
    Cell[307197, 11378, 125, 5, 24, "Text",
      CellTags->"General::optb"],
    Cell[307347, 11387, 126, 3, 26, "Input",
      CellTags->"General::optb"],
    Cell[307476, 11392, 96, 3, 21, "Output",
      CellTags->"General::optb"],
    Cell[307587, 11398, 102, 1, 24, "Text",
      CellTags->"General::optb"],
    Cell[307714, 11403, 117, 3, 26, "Input",
      CellTags->"General::optb"],
    Cell[307834, 11408, 96, 3, 21, "Output",
      CellTags->"General::optb"]},
  "General::patop"->{
    Cell[307991, 11418, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::patop"],
    Cell[308075, 11421, 369, 10, 21, "Message",
      CellTags->"General::patop"],
    Cell[308447, 11433, 976, 34, 84, "Notes",
      CellTags->"General::patop"],
    Cell[309448, 11471, 64, 1, 38, "ExampleSection",
      CellTags->"General::patop"],
    Cell[309515, 11474, 233, 7, 24, "Text",
      CellTags->"General::patop"],
    Cell[309773, 11485, 127, 3, 26, "Input",
      CellTags->"General::patop"],
    Cell[309903, 11490, 211, 5, 21, "Message",
      CellTags->"General::patop"],
    Cell[310117, 11497, 102, 3, 21, "Output",
      CellTags->"General::patop"],
    Cell[310234, 11503, 136, 5, 24, "Text",
      CellTags->"General::patop"],
    Cell[310395, 11512, 124, 3, 26, "Input",
      CellTags->"General::patop"],
    Cell[310522, 11517, 97, 3, 21, "Output",
      CellTags->"General::patop"]},
  "General::rvalue"->{
    Cell[310680, 11527, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::rvalue"],
    Cell[310766, 11530, 480, 14, 21, "Message",
      CellTags->"General::rvalue"],
    Cell[311249, 11546, 352, 8, 46, "Notes",
      CellTags->"General::rvalue"],
    Cell[311626, 11558, 65, 1, 38, "ExampleSection",
      CellTags->"General::rvalue"],
    Cell[311694, 11561, 192, 5, 24, "Text",
      CellTags->"General::rvalue"],
    Cell[311911, 11570, 142, 3, 26, "Input",
      CellTags->"General::rvalue"],
    Cell[312056, 11575, 215, 5, 37, "Message",
      CellTags->"General::rvalue"],
    Cell[312274, 11582, 205, 5, 21, "Print",
      CellTags->"General::rvalue"],
    Cell[312494, 11590, 127, 5, 24, "Text",
      CellTags->"General::rvalue"],
    Cell[312646, 11599, 144, 3, 26, "Input",
      CellTags->"General::rvalue"],
    Cell[312793, 11604, 201, 5, 21, "Print",
      CellTags->"General::rvalue"]},
  "General::setp"->{
    Cell[313055, 11616, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::setp"],
    Cell[313137, 11619, 380, 11, 21, "Message",
      CellTags->"General::setp"],
    Cell[313520, 11632, 186, 5, 24, "Notes",
      CellTags->"General::setp"],
    Cell[313731, 11641, 63, 1, 38, "ExampleSection",
      CellTags->"General::setp"],
    Cell[313797, 11644, 154, 4, 24, "Text",
      CellTags->"General::setp"],
    Cell[313976, 11652, 96, 3, 26, "Input",
      CellTags->"General::setp"],
    Cell[314075, 11657, 180, 4, 21, "Message",
      CellTags->"General::setp"],
    Cell[314258, 11663, 88, 3, 21, "Output",
      CellTags->"General::setp"],
    Cell[314361, 11669, 80, 1, 24, "Text",
      CellTags->"General::setp"],
    Cell[314466, 11674, 128, 3, 26, "Input",
      CellTags->"General::setp"],
    Cell[314597, 11679, 97, 3, 21, "Output",
      CellTags->"General::setp"]},
  "General::setps"->{
    Cell[314755, 11689, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::setps"],
    Cell[314839, 11692, 400, 11, 21, "Message",
      CellTags->"General::setps"],
    Cell[315242, 11705, 267, 6, 46, "Notes",
      CellTags->"General::setps"],
    Cell[315534, 11715, 64, 1, 38, "ExampleSection",
      CellTags->"General::setps"],
    Cell[315601, 11718, 196, 5, 40, "Text",
      CellTags->"General::setps"],
    Cell[315822, 11727, 145, 3, 26, "Input",
      CellTags->"General::setps"],
    Cell[315970, 11732, 181, 4, 21, "Message",
      CellTags->"General::setps"],
    Cell[316154, 11738, 97, 3, 21, "Output",
      CellTags->"General::setps"],
    Cell[316266, 11744, 81, 1, 24, "Text",
      CellTags->"General::setps"],
    Cell[316372, 11749, 136, 3, 26, "Input",
      CellTags->"General::setps"],
    Cell[316511, 11754, 98, 3, 21, "Output",
      CellTags->"General::setps"]},
  "General::shdw"->{
    Cell[316670, 11764, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::shdw"],
    Cell[316752, 11767, 675, 18, 37, "Message",
      CellTags->"General::shdw"],
    Cell[317430, 11787, 931, 18, 160, "Notes",
      CellTags->"General::shdw"],
    Cell[318386, 11809, 63, 1, 38, "ExampleSection",
      CellTags->"General::shdw"],
    Cell[318452, 11812, 188, 5, 24, "Text",
      CellTags->"General::shdw"],
    Cell[318665, 11821, 100, 3, 26, "Input",
      CellTags->"General::shdw"],
    Cell[318768, 11826, 101, 3, 21, "Output",
      CellTags->"General::shdw"],
    Cell[318906, 11834, 349, 8, 74, "Input",
      CellTags->"General::shdw"],
    Cell[319258, 11844, 95, 3, 21, "Output",
      CellTags->"General::shdw"],
    Cell[319390, 11852, 102, 3, 26, "Input",
      CellTags->"General::shdw"],
    Cell[319495, 11857, 318, 6, 53, "Message",
      CellTags->"General::shdw"],
    Cell[319816, 11865, 298, 6, 37, "Message",
      CellTags->"General::shdw"],
    Cell[320129, 11874, 160, 4, 24, "Text",
      CellTags->"General::shdw"],
    Cell[320314, 11882, 105, 3, 26, "Input",
      CellTags->"General::shdw"],
    Cell[320422, 11887, 96, 3, 21, "Output",
      CellTags->"General::shdw"],
    Cell[320533, 11893, 162, 4, 24, "Text",
      CellTags->"General::shdw"],
    Cell[320720, 11901, 100, 3, 26, "Input",
      CellTags->"General::shdw"],
    Cell[320823, 11906, 101, 3, 21, "Output",
      CellTags->"General::shdw"],
    Cell[320939, 11912, 177, 7, 24, "Text",
      CellTags->"General::shdw"],
    Cell[321119, 11921, 105, 3, 26, "Input",
      CellTags->"General::shdw"],
    Cell[321227, 11926, 138, 4, 24, "Text",
      CellTags->"General::shdw"],
    Cell[321390, 11934, 101, 3, 26, "Input",
      CellTags->"General::shdw"],
    Cell[321494, 11939, 97, 3, 21, "Output",
      CellTags->"General::shdw"],
    Cell[321606, 11945, 66, 1, 24, "Text",
      CellTags->"General::shdw"],
    Cell[321675, 11948, 111, 3, 26, "Input",
      CellTags->"General::shdw"]},
  "General::tag"->{
    Cell[321835, 11957, 77, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::tag"],
    Cell[321915, 11960, 487, 16, 21, "Message",
      CellTags->"General::tag"],
    Cell[322405, 11978, 702, 21, 84, "Notes",
      CellTags->"General::tag"],
    Cell[323132, 12003, 62, 1, 38, "ExampleSection",
      CellTags->"General::tag"],
    Cell[323197, 12006, 263, 9, 24, "Text",
      CellTags->"General::tag"],
    Cell[323485, 12019, 134, 3, 26, "Input",
      CellTags->"General::tag"],
    Cell[323622, 12024, 240, 5, 37, "Message",
      CellTags->"General::tag"],
    Cell[323865, 12031, 94, 3, 21, "Output",
      CellTags->"General::tag"],
    Cell[323974, 12037, 115, 4, 24, "Text",
      CellTags->"General::tag"],
    Cell[324114, 12045, 120, 3, 26, "Input",
      CellTags->"General::tag"],
    Cell[324237, 12050, 94, 3, 21, "Output",
      CellTags->"General::tag"]},
  "General::trace"->{
    Cell[324392, 12060, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::trace"],
    Cell[324476, 12063, 395, 14, 21, "Message",
      CellTags->"General::trace"],
    Cell[324874, 12079, 296, 8, 46, "Notes",
      CellTags->"General::trace"],
    Cell[325195, 12091, 64, 1, 38, "ExampleSection",
      CellTags->"General::trace"],
    Cell[325262, 12094, 87, 1, 24, "Text",
      CellTags->"General::trace"],
    Cell[325352, 12097, 94, 3, 26, "Input",
      CellTags->"General::trace"],
    Cell[325471, 12104, 138, 3, 26, "Input",
      CellTags->"General::trace"],
    Cell[325612, 12109, 233, 5, 21, "Message",
      CellTags->"General::trace"],
    Cell[325848, 12116, 294, 6, 21, "Message",
      CellTags->"General::trace"],
    Cell[326145, 12124, 185, 4, 21, "Message",
      CellTags->"General::trace"],
    Cell[326333, 12130, 90, 3, 21, "Output",
      CellTags->"General::trace"],
    Cell[326438, 12136, 115, 5, 24, "Text",
      CellTags->"General::trace"],
    Cell[326556, 12143, 95, 3, 26, "Input",
      CellTags->"General::trace"]},
  "General::write"->{
    Cell[326700, 12152, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::write"],
    Cell[326784, 12155, 409, 12, 21, "Message",
      CellTags->"General::write"],
    Cell[327196, 12169, 469, 13, 68, "Notes",
      CellTags->"General::write"],
    Cell[327690, 12186, 64, 1, 38, "ExampleSection",
      CellTags->"General::write"],
    Cell[327757, 12189, 323, 10, 40, "Text",
      CellTags->"General::write"],
    Cell[328105, 12203, 98, 3, 26, "Input",
      CellTags->"General::write"],
    Cell[328206, 12208, 176, 4, 21, "Message",
      CellTags->"General::write"],
    Cell[328385, 12214, 90, 3, 21, "Output",
      CellTags->"General::write"],
    Cell[328490, 12220, 138, 4, 24, "Text",
      CellTags->"General::write"],
    Cell[328653, 12228, 106, 3, 26, "Input",
      CellTags->"General::write"],
    Cell[328762, 12233, 176, 4, 21, "Message",
      CellTags->"General::write"],
    Cell[328941, 12239, 171, 4, 21, "Message",
      CellTags->"General::write"],
    Cell[329115, 12245, 100, 3, 21, "Output",
      CellTags->"General::write"],
    Cell[329230, 12251, 263, 11, 24, "Text",
      CellTags->"General::write"],
    Cell[329518, 12266, 107, 3, 26, "Input",
      CellTags->"General::write"],
    Cell[329628, 12271, 103, 3, 21, "Output",
      CellTags->"General::write"],
    Cell[329746, 12277, 380, 11, 40, "Text",
      CellTags->"General::write"],
    Cell[330151, 12292, 113, 3, 26, "Input",
      CellTags->"General::write"],
    Cell[330267, 12297, 174, 4, 21, "Message",
      CellTags->"General::write"],
    Cell[330444, 12303, 112, 3, 21, "Output",
      CellTags->"General::write"]},
  "General::wrsym"->{
    Cell[330617, 12313, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::wrsym"],
    Cell[330701, 12316, 318, 9, 21, "Message",
      CellTags->"General::wrsym"],
    Cell[331022, 12327, 267, 7, 46, "Notes",
      CellTags->"General::wrsym"],
    Cell[331314, 12338, 64, 1, 38, "ExampleSection",
      CellTags->"General::wrsym"],
    Cell[331381, 12341, 135, 5, 24, "Text",
      CellTags->"General::wrsym"],
    Cell[331541, 12350, 102, 3, 26, "Input",
      CellTags->"General::wrsym"],
    Cell[331646, 12355, 163, 4, 21, "Message",
      CellTags->"General::wrsym"],
    Cell[331812, 12361, 96, 3, 21, "Output",
      CellTags->"General::wrsym"],
    Cell[331923, 12367, 175, 7, 24, "Text",
      CellTags->"General::wrsym"],
    Cell[332123, 12378, 103, 3, 26, "Input",
      CellTags->"General::wrsym"],
    Cell[332229, 12383, 107, 3, 21, "Output",
      CellTags->"General::wrsym"]},
  "General::shdwcor"->{
    Cell[332397, 12393, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::shdwcor"],
    Cell[332485, 12396, 656, 19, 37, "Message",
      CellTags->"General::shdwcor"],
    Cell[333144, 12417, 263, 6, 46, "Notes",
      CellTags->"General::shdwcor"]},
  "NestWhile::nres"->{
    Cell[333444, 12428, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[333583, 12434, 487, 14, 21, "Message",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[334073, 12450, 272, 7, 24, "Notes",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[334370, 12461, 90, 1, 38, "ExampleSection",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[334463, 12464, 223, 5, 40, "Text",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[334711, 12473, 182, 4, 26, "Input",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[334896, 12479, 337, 6, 37, "Message",
      CellTags->{"NestWhileList::nres", "NestWhile::nres"}],
    Cell[335236, 12487, 116, 3, 21, "Output",
      CellTags->{"NestWhileList::nres", "NestWhile::nres"}],
    Cell[335367, 12493, 178, 5, 24, "Text",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[335570, 12502, 181, 4, 26, "Input",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[335754, 12508, 120, 3, 21, "Output",
      CellTags->{"NestWhileList::nres", "NestWhile::nres"}]},
  "NestWhileList::nres"->{
    Cell[333444, 12428, 136, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[333583, 12434, 487, 14, 21, "Message",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[334073, 12450, 272, 7, 24, "Notes",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[334370, 12461, 90, 1, 38, "ExampleSection",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[334463, 12464, 223, 5, 40, "Text",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[334711, 12473, 182, 4, 26, "Input",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[334896, 12479, 337, 6, 37, "Message",
      CellTags->{"NestWhileList::nres", "NestWhile::nres"}],
    Cell[335236, 12487, 116, 3, 21, "Output",
      CellTags->{"NestWhileList::nres", "NestWhile::nres"}],
    Cell[335367, 12493, 178, 5, 24, "Text",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[335570, 12502, 181, 4, 26, "Input",
      CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
    Cell[335754, 12508, 120, 3, 21, "Output",
      CellTags->{"NestWhileList::nres", "NestWhile::nres"}]},
  "NestWhile::nwargs"->{
    Cell[335935, 12518, 144, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[336082, 12524, 675, 17, 37, "Message",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[336760, 12543, 292, 7, 40, "Notes",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[337077, 12554, 94, 1, 38, "ExampleSection",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[337174, 12557, 238, 5, 40, "Text",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[337437, 12566, 167, 3, 26, "Input",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[337607, 12571, 392, 7, 69, "Message",
      CellTags->{"NestWhileList::nwargs", "NestWhile::nwargs"}],
    Cell[338002, 12580, 158, 3, 21, "Output",
      CellTags->{"NestWhileList::nwargs", "NestWhile::nwargs"}],
    Cell[338175, 12586, 164, 5, 24, "Text",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[338364, 12595, 167, 3, 26, "Input",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[338534, 12600, 159, 3, 21, "Output",
      CellTags->{"NestWhileList::nwargs", "NestWhile::nwargs"}]},
  "NestWhileList::nwargs"->{
    Cell[335935, 12518, 144, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[336082, 12524, 675, 17, 37, "Message",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[336760, 12543, 292, 7, 40, "Notes",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[337077, 12554, 94, 1, 38, "ExampleSection",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[337174, 12557, 238, 5, 40, "Text",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[337437, 12566, 167, 3, 26, "Input",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[337607, 12571, 392, 7, 69, "Message",
      CellTags->{"NestWhileList::nwargs", "NestWhile::nwargs"}],
    Cell[338002, 12580, 158, 3, 21, "Output",
      CellTags->{"NestWhileList::nwargs", "NestWhile::nwargs"}],
    Cell[338175, 12586, 164, 5, 24, "Text",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[338364, 12595, 167, 3, 26, "Input",
      CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
    Cell[338534, 12600, 159, 3, 21, "Output",
      CellTags->{"NestWhileList::nwargs", "NestWhile::nwargs"}]},
  "Pattern::patvar"->{
    Cell[338754, 12610, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Pattern::patvar"],
    Cell[338840, 12613, 198, 5, 21, "Message",
      CellTags->"Pattern::patvar"],
    Cell[339041, 12620, 305, 6, 46, "Notes",
      CellTags->"Pattern::patvar"],
    Cell[339371, 12630, 65, 1, 38, "ExampleSection",
      CellTags->"Pattern::patvar"],
    Cell[339439, 12633, 146, 4, 24, "Text",
      CellTags->"Pattern::patvar"],
    Cell[339610, 12641, 136, 3, 26, "Input",
      CellTags->"Pattern::patvar"],
    Cell[339749, 12646, 222, 5, 37, "Message",
      CellTags->"Pattern::patvar"],
    Cell[339974, 12653, 98, 3, 21, "Output",
      CellTags->"Pattern::patvar"]},
  "Set::patset"->{
    Cell[340133, 12663, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Set::patset"],
    Cell[340211, 12666, 236, 5, 37, "Message",
      CellTags->"Set::patset"],
    Cell[340450, 12673, 801, 21, 106, "Notes",
      CellTags->"Set::patset"],
    Cell[341276, 12698, 61, 1, 38, "ExampleSection",
      CellTags->"Set::patset"],
    Cell[341340, 12701, 302, 7, 40, "Text",
      CellTags->"Set::patset"],
    Cell[341667, 12712, 91, 3, 26, "Input",
      CellTags->"Set::patset"],
    Cell[341761, 12717, 251, 5, 37, "Message",
      CellTags->"Set::patset"],
    Cell[342015, 12724, 86, 3, 21, "Output",
      CellTags->"Set::patset"],
    Cell[342116, 12730, 97, 1, 24, "Text",
      CellTags->"Set::patset"],
    Cell[342238, 12735, 94, 3, 26, "Input",
      CellTags->"Set::patset"],
    Cell[342335, 12740, 86, 3, 21, "Output",
      CellTags->"Set::patset"],
    Cell[342436, 12746, 122, 5, 24, "Text",
      CellTags->"Set::patset"],
    Cell[342561, 12753, 92, 3, 26, "Input",
      CellTags->"Set::patset"]},
  "Switch::argct"->{
    Cell[342702, 12762, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Switch::argct"],
    Cell[342784, 12765, 225, 5, 37, "Message",
      CellTags->"Switch::argct"],
    Cell[343012, 12772, 178, 5, 24, "Notes",
      CellTags->"Switch::argct"],
    Cell[343215, 12781, 63, 1, 38, "ExampleSection",
      CellTags->"Switch::argct"],
    Cell[343281, 12784, 177, 5, 24, "Text",
      CellTags->"Switch::argct"],
    Cell[343483, 12793, 115, 3, 26, "Input",
      CellTags->"Switch::argct"],
    Cell[343601, 12798, 228, 5, 37, "Message",
      CellTags->"Switch::argct"],
    Cell[343832, 12805, 119, 3, 21, "Output",
      CellTags->"Switch::argct"],
    Cell[343966, 12811, 126, 5, 24, "Text",
      CellTags->"Switch::argct"],
    Cell[344117, 12820, 115, 3, 26, "Input",
      CellTags->"Switch::argct"],
    Cell[344235, 12825, 88, 3, 21, "Output",
      CellTags->"Switch::argct"]},
  "Syntax::stresc"->{
    Cell[344384, 12835, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Syntax::stresc"],
    Cell[344468, 12838, 165, 4, 21, "Message",
      CellTags->"Syntax::stresc"],
    Cell[344636, 12844, 125, 4, 24, "Notes",
      CellTags->"Syntax::stresc"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Attributes::locked", 345458, 12869},
  {"ClearAll::locked", 346784, 12902},
  {"Protect::locked", 348109, 12935},
  {"SetOptions::locked", 349437, 12968},
  {"With::lvw", 350756, 13001},
  {"Replace::reps", 351878, 13032},
  {"ReplaceAll::reps", 354499, 13097},
  {"ReplaceRepeated::reps", 357125, 13162},
  {"ReplaceList::reps", 359747, 13227},
  {"$ContextPath::cxlist", 362372, 13292},
  {"$Packages::cxlist", 363280, 13309},
  {"$IterationLimit::itlim", 364193, 13326},
  {"$IterationLimit::aitlim", 365871, 13365},
  {"$MaxComputationSteps::complim", 366188, 13372},
  {"$Cache::set", 366506, 13379},
  {"$IterationLimit::limset", 366781, 13386},
  {"$RecursionLimit::limset", 367768, 13403},
  {"Replace::erep", 368745, 13420},
  {"With::dup", 369012, 13427},
  {"Module::dup", 370010, 13444},
  {"Block::dup", 371007, 13461},
  {"Dialog::dup", 372005, 13478},
  {"$ModuleNumber::modnc", 373012, 13495},
  {"$ModuleNumber::set", 373984, 13518},
  {"CharacterRange::argtype", 374701, 13535},
  {"Set::inset", 375709, 13558},
  {"With::dups", 375972, 13565},
  {"Module::dups", 377039, 13588},
  {"With::lvws", 378104, 13611},
  {"AbsoluteOptions::optnf", 378979, 13634},
  {"SetOptions::optnf", 381052, 13680},
  {"Options::optnf", 383122, 13726},
  {"Break::nofunc", 385191, 13772},
  {"Continue::nofunc", 388999, 13837},
  {"Return::nofunc", 392805, 13902},
  {"$RecursionLimit::reclim", 396620, 13967},
  {"Condition::condp", 397981, 13998},
  {"Optional::opdef", 398919, 14021},
  {"Attributes::attnf", 399693, 14040},
  {"Attributes::attsl", 400319, 14055},
  {"Block::lockt", 400604, 14062},
  {"Dialog::lockt", 401706, 14085},
  {"Block::lockv", 402807, 14108},
  {"Dialog::lockv", 403909, 14131},
  {"Block::lvlist", 405011, 14154},
  {"Dialog::lvlist", 406589, 14188},
  {"Module::lvlist", 408167, 14222},
  {"With::lvlist", 409743, 14256},
  {"Block::lvset", 411319, 14290},
  {"Dialog::lvset", 412852, 14324},
  {"With::lvset", 414383, 14358},
  {"Module::lvset", 415916, 14392},
  {"Block::lvsym", 417448, 14426},
  {"Dialog::lvsym", 418737, 14449},
  {"Module::lvsym", 420026, 14472},
  {"Break::nofwd", 421314, 14495},
  {"Clear::spsym", 421584, 14502},
  {"ClearAll::spsym", 422320, 14517},
  {"Remove::spsym", 423054, 14532},
  {"Clear::ssym", 423644, 14547},
  {"ClearAll::ssym", 424514, 14562},
  {"Information::ssym", 425387, 14577},
  {"ClearAll::clloc", 426258, 14592},
  {"Context::cxdup", 426864, 14607},
  {"Context::cxname", 427700, 14628},
  {"Context::cxset", 428941, 14659},
  {"$Context::cxset", 430384, 14688},
  {"ContextToFileName::cxfil", 431836, 14717},
  {"Continue::nofwd", 432779, 14738},
  {"Debug::dbug", 433057, 14745},
  {"DeclarePackage::aldec", 433334, 14752},
  {"DefineExternal::des", 434244, 14773},
  {"Dialog::dpa", 434964, 14790},
  {"Dialog::exd", 435230, 14797},
  {"DownValues::itloc", 436191, 14822},
  {"UpValues::itloc", 438015, 14858},
  {"OwnValues::itloc", 439840, 14894},
  {"FormatValues::itloc", 441668, 14930},
  {"DefaultValues::itloc", 443497, 14966},
  {"NValues::itloc", 445320, 15002},
  {"Messages::itloc", 447144, 15038},
  {"SubValues::itloc", 448969, 15074},
  {"DownValues::vlist", 450795, 15110},
  {"UpValues::vlist", 455140, 15196},
  {"OwnValues::vlist", 459486, 15282},
  {"FormatValues::vlist", 463835, 15368},
  {"DefaultValues::vlist", 468185, 15454},
  {"NValues::vlist", 472529, 15540},
  {"Messages::vlist", 476874, 15626},
  {"SubValues::vlist", 481220, 15712},
  {"DownValues::vrule", 485567, 15798},
  {"UpValues::vrule", 489912, 15884},
  {"OwnValues::vrule", 494258, 15970},
  {"FormatValues::vrule", 498607, 16056},
  {"DefaultValues::vrule", 502957, 16142},
  {"NValues::vrule", 507301, 16228},
  {"Messages::vrule", 511646, 16314},
  {"SubValues::vrule", 515992, 16400},
  {"EditDefinition::edsym", 520343, 16486},
  {"End::noctx", 521082, 16503},
  {"EndAdd::noctx", 522635, 16530},
  {"EndPackage::noctx", 524192, 16557},
  {"ExitDialog::cant", 525748, 16584},
  {"Return::obs", 526932, 16613},
  {"FrontEndObject::notavail", 527214, 16620},
  {"Function::attf", 527528, 16627},
  {"Function::fdup", 528533, 16652},
  {"Compile::fdup", 529766, 16677},
  {"Function::fdups", 531001, 16702},
  {"Function::flpar", 532020, 16727},
  {"Remove::rmnsm", 533036, 16752},
  {"Function::fpct", 533635, 16767},
  {"Function::slot", 534557, 16790},
  {"Function::slotn", 536193, 16831},
  {"Function::slotp", 537128, 16854},
  {"Function::slots", 538790, 16895},
  {"Goto::nolabel", 539725, 16918},
  {"Interrupt::dgbgn", 540952, 16949},
  {"TraceDialog::dgbgn", 542588, 16980},
  {"Interrupt::dgend", 544222, 17011},
  {"TraceDialog::dgend", 545860, 17042},
  {"LinkConnect::linkc", 547498, 17073},
  {"LinkObject::linkd", 547794, 17080},
  {"LinkOpen::linke", 548085, 17087},
  {"LinkRead::linkep", 548782, 17104},
  {"LinkObject::linkn", 549072, 17111},
  {"LinkObject::linkv", 549365, 17118},
  {"LinkWrite::linkv", 550642, 17146},
  {"LinkWriteHeld::linkv", 551923, 17174},
  {"LinkObject::linkw", 553201, 17202},
  {"LinkObject::linkx", 553494, 17209},
  {"LinkOpen::linkh", 553785, 17216},
  {"LinkOpen::linki", 554070, 17223},
  {"LinkOpen::linkm", 554355, 17230},
  {"LinkOpen::linknm", 554641, 17237},
  {"LinkOpen::linkpl", 555344, 17254},
  {"LinkOpen::links", 556049, 17271},
  {"LinkWriteHeld::linkhl", 556340, 17278},
  {"MapThread::mptc", 557083, 17295},
  {"MapThread::mptd", 558019, 17318},
  {"Options::opmix", 558954, 17341},
  {"Options::opsym", 559641, 17358},
  {"Pattern::nodef", 560564, 17381},
  {"Pattern::patm", 561882, 17414},
  {"Pattern::patsym", 562642, 17433},
  {"Pattern::patv", 562925, 17440},
  {"PatternTest::ptest", 563841, 17463},
  {"Protect::pssl", 564134, 17470},
  {"Remove::relex", 564809, 17487},
  {"Remove::remal", 565407, 17502},
  {"Remove::rmlck", 566005, 17517},
  {"Remove::rmptc", 566759, 17536},
  {"Remove::ssym", 567667, 17559},
  {"General::rep", 568256, 17574},
  {"Replace::rmix", 569312, 17601},
  {"ReplaceAll::rmix", 571153, 17646},
  {"ReplaceRepeated::rmix", 572999, 17691},
  {"ReplaceList::rmix", 574841, 17736},
  {"ReplacePart::psl", 576682, 17781},
  {"ReplaceHeldPart::psl", 579574, 17837},
  {"MapAt::psl", 582456, 17893},
  {"Delete::psl", 585339, 17949},
  {"FlattenAt::psl", 588225, 18005},
  {"Insert::psl", 591108, 18061},
  {"StringInsert::psl", 593997, 18117},
  {"StringReplacePart::psl", 596891, 18173},
  {"Extract::psl", 599775, 18229},
  {"ReplaceRepeated::rrlim", 602669, 18285},
  {"Return::nofsdd", 603941, 18314},
  {"Rule::rhs", 604217, 18321},
  {"RuleDelayed::rhs", 605332, 18344},
  {"Set::lhsr", 606440, 18367},
  {"SetDelayed::lhsr", 607180, 18383},
  {"Unset::lhsr", 607915, 18399},
  {"TagSet::lhsr", 608651, 18415},
  {"TagSetDelayed::lhsr", 609394, 18431},
  {"TagUnset::lhsr", 610132, 18447},
  {"UpSet::lhsr", 610867, 18463},
  {"UpSetDelayed::lhsr", 611609, 18479},
  {"Set::setraw", 612344, 18495},
  {"SetDelayed::setraw", 615612, 18560},
  {"UpSet::setraw", 618875, 18625},
  {"UpSetDelayed::setraw", 622145, 18690},
  {"TagSet::setraw", 625409, 18755},
  {"TagSetDelayed::setraw", 628680, 18820},
  {"Set::shape", 631940, 18885},
  {"SetDelayed::shape", 633270, 18912},
  {"Set::setrpt", 634594, 18939},
  {"SetDelayed::setrpt", 636257, 18972},
  {"UpSet::setrpt", 637915, 19005},
  {"UpSetDelayed::setrpt", 639580, 19038},
  {"TagSet::setrpt", 641239, 19071},
  {"TagSetDelayed::setrpt", 642905, 19104},
  {"SetOptions::optf", 644566, 19137},
  {"SetOptions::sstm", 645355, 19156},
  {"Stack::stackx", 646461, 19183},
  {"StringDrop::drop", 647530, 19210},
  {"StringInsert::ins", 648478, 19233},
  {"StringReplacePart::ins", 649752, 19256},
  {"StringPosition::meta", 651024, 19279},
  {"StringReplace::meta", 652295, 19302},
  {"StringReplace::srep", 653566, 19325},
  {"StringReplacePart::ovlp", 654638, 19350},
  {"StringReplacePart::repart", 655672, 19373},
  {"StringReplacePart::spos", 656726, 19396},
  {"Symbol::symname", 657750, 19419},
  {"TagSet::tagnf", 658682, 19442},
  {"TagSetDelayed::tagnf", 660538, 19485},
  {"TagUnset::tagnf", 662389, 19528},
  {"TagSet::tagpos", 664239, 19571},
  {"TagSetDelayed::tagpos", 666164, 19614},
  {"TagUnset::tagpos", 668084, 19657},
  {"Throw::nocatch", 670002, 19700},
  {"Trace::tracb", 671396, 19735},
  {"TraceScan::tracb", 673194, 19780},
  {"TracePrint::tracb", 674993, 19825},
  {"TraceDialog::tracb", 676793, 19870},
  {"Trace::tracd", 678587, 19915},
  {"TraceScan::tracd", 680386, 19960},
  {"TracePrint::tracd", 682186, 20005},
  {"TraceDialog::tracd", 683987, 20050},
  {"TraceLevel::notrc", 685787, 20095},
  {"Unset::cxun", 686905, 20122},
  {"Alias::almark", 687564, 20139},
  {"UnAlias::alspr", 688863, 20172},
  {"Uninstall::unlink", 690352, 20209},
  {"Unique::usym", 690984, 20224},
  {"Unset::norep", 691892, 20247},
  {"TagUnset::norep", 693436, 20278},
  {"Unset::usraw", 694977, 20309},
  {"TagUnset::usraw", 695827, 20326},
  {"Unset::usrpt", 696674, 20343},
  {"TagUnset::usrpt", 697523, 20360},
  {"General::altno", 698371, 20377},
  {"General::bebal", 699623, 20408},
  {"General::cxls", 700956, 20441},
  {"General::cxt", 701641, 20458},
  {"General::mbox", 702862, 20489},
  {"General::newsym", 703144, 20496},
  {"General::nosym", 704006, 20517},
  {"General::noval", 704939, 20540},
  {"General::opset", 706754, 20585},
  {"General::optb", 707448, 20602},
  {"General::patop", 708609, 20631},
  {"General::rvalue", 709545, 20654},
  {"General::setp", 710488, 20677},
  {"General::setps", 711408, 20700},
  {"General::shdw", 712339, 20723},
  {"General::tag", 714366, 20774},
  {"General::trace", 715278, 20797},
  {"General::write", 716372, 20824},
  {"General::wrsym", 718035, 20865},
  {"General::shdwcor", 718970, 20888},
  {"NestWhile::nres", 719262, 20895},
  {"NestWhileList::nres", 720489, 20918},
  {"NestWhile::nwargs", 721714, 20941},
  {"NestWhileList::nwargs", 722987, 20964},
  {"Pattern::patvar", 724254, 20987},
  {"Set::patset", 724952, 21004},
  {"Switch::argct", 726001, 21031},
  {"Syntax::stresc", 726923, 21054}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 28, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1829, 57, 220, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],
Cell[2052, 67, 391, 11, 21, "Message",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],
Cell[2446, 80, 347, 9, 46, "Notes",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],

Cell[CellGroupData[{
Cell[2818, 93, 139, 3, 38, "ExampleSection",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],
Cell[2960, 98, 214, 7, 24, "Text",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],

Cell[CellGroupData[{
Cell[3199, 109, 177, 5, 26, "Input",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],
Cell[3379, 116, 240, 6, 21, "Message",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}],
Cell[3622, 124, 165, 5, 21, "Output",
  CellTags->{
  "Attributes::locked", "ClearAll::locked", "Protect::locked", 
    "SetOptions::locked"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[3848, 136, 71, 1, 31, "ObjectNameWarningMessages",
  CellTags->"With::lvw"],
Cell[3922, 139, 386, 10, 37, "Message",
  CellTags->"With::lvw"],
Cell[4311, 151, 527, 14, 68, "Notes",
  CellTags->"With::lvw"],

Cell[CellGroupData[{
Cell[4863, 169, 59, 1, 38, "ExampleSection",
  CellTags->"With::lvw"],
Cell[4925, 172, 284, 7, 40, "Text",
  CellTags->"With::lvw"],

Cell[CellGroupData[{
Cell[5234, 183, 114, 3, 26, "Input",
  CellTags->"With::lvw"],
Cell[5351, 188, 233, 5, 37, "Message",
  CellTags->"With::lvw"],
Cell[5587, 195, 115, 3, 21, "Output",
  CellTags->"With::lvw"]
}, Open  ]],
Cell[5717, 201, 147, 5, 24, "Text",
  CellTags->"With::lvw"],

Cell[CellGroupData[{
Cell[5889, 210, 104, 3, 26, "Input",
  CellTags->"With::lvw"],
Cell[5996, 215, 84, 3, 21, "Output",
  CellTags->"With::lvw"]
}, Open  ]],
Cell[6095, 221, 363, 11, 40, "Text",
  CellTags->"With::lvw"],

Cell[CellGroupData[{
Cell[6483, 236, 110, 3, 26, "Input",
  CellTags->"With::lvw"],
Cell[6596, 241, 243, 5, 37, "Message",
  CellTags->"With::lvw"],
Cell[6842, 248, 107, 3, 21, "Output",
  CellTags->"With::lvw"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7010, 258, 220, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],
Cell[7233, 268, 644, 17, 37, "Message",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],
Cell[7880, 287, 1435, 49, 112, "Notes",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[CellGroupData[{
Cell[9340, 340, 139, 3, 38, "ExampleSection",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],
Cell[9482, 345, 350, 10, 40, "Text",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[CellGroupData[{
Cell[9857, 359, 168, 5, 26, "Input",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],
Cell[10028, 366, 328, 7, 37, "Message",
  CellTags->{
  "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
    "Replace::reps"}],
Cell[10359, 375, 186, 5, 21, "Output",
  CellTags->{
  "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
    "Replace::reps"}]
}, Open  ]],
Cell[10560, 383, 342, 8, 40, "Text",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[CellGroupData[{
Cell[10927, 395, 186, 5, 26, "Input",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],
Cell[11116, 402, 279, 7, 21, "Message",
  CellTags->{
  "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
    "Replace::reps"}],
Cell[11398, 411, 368, 8, 53, "Message",
  CellTags->{
  "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
    "Replace::reps"}],
Cell[11769, 421, 204, 5, 21, "Output",
  CellTags->{
  "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
    "Replace::reps"}]
}, Open  ]],
Cell[11988, 429, 285, 9, 24, "Text",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],

Cell[CellGroupData[{
Cell[12298, 442, 191, 5, 26, "Input",
  CellTags->{
  "Replace::reps", "ReplaceAll::reps", "ReplaceRepeated::reps", 
    "ReplaceList::reps"}],
Cell[12492, 449, 181, 5, 21, "Output",
  CellTags->{
  "ReplaceAll::reps", "ReplaceList::reps", "ReplaceRepeated::reps", 
    "Replace::reps"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12734, 461, 142, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
Cell[12879, 467, 377, 10, 37, "Message",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
Cell[13259, 479, 577, 12, 84, "Notes",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],

Cell[CellGroupData[{
Cell[13861, 495, 93, 1, 38, "ExampleSection",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
Cell[13957, 498, 267, 7, 40, "Text",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],

Cell[CellGroupData[{
Cell[14249, 509, 144, 3, 26, "Input",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
Cell[14396, 514, 279, 5, 37, "Message",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}],
Cell[14678, 521, 126, 3, 21, "Output",
  CellTags->{"$ContextPath::cxlist", "$Packages::cxlist"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14865, 531, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$IterationLimit::itlim"],
Cell[14965, 534, 250, 5, 21, "Message",
  CellTags->"$IterationLimit::itlim"],
Cell[15218, 541, 769, 16, 106, "Notes",
  CellTags->"$IterationLimit::itlim"],

Cell[CellGroupData[{
Cell[16012, 561, 72, 1, 38, "ExampleSection",
  CellTags->"$IterationLimit::itlim"],
Cell[16087, 564, 205, 7, 24, "Text",
  CellTags->"$IterationLimit::itlim"],

Cell[CellGroupData[{
Cell[16317, 575, 113, 3, 26, "Input",
  CellTags->"$IterationLimit::itlim"],
Cell[16433, 580, 191, 4, 21, "Message",
  CellTags->"$IterationLimit::itlim"],
Cell[16627, 586, 133, 3, 21, "Output",
  CellTags->"$IterationLimit::itlim"]
}, Open  ]],
Cell[16775, 592, 123, 5, 24, "Text",
  CellTags->"$IterationLimit::itlim"],
Cell[16901, 599, 103, 3, 26, "Input",
  CellTags->"$IterationLimit::itlim"],
Cell[17007, 604, 128, 4, 24, "Text",
  CellTags->"$IterationLimit::itlim"],

Cell[CellGroupData[{
Cell[17160, 612, 118, 3, 26, "Input",
  CellTags->"$IterationLimit::itlim"],
Cell[17281, 617, 109, 3, 21, "Output",
  CellTags->"$IterationLimit::itlim"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17427, 625, 103, 3, 26, "Input",
  CellTags->"$IterationLimit::itlim"],
Cell[17533, 630, 97, 3, 21, "Output",
  CellTags->"$IterationLimit::itlim"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17667, 638, 100, 3, 26, "Input",
  CellTags->"$IterationLimit::itlim"],
Cell[17770, 643, 97, 3, 21, "Output",
  CellTags->"$IterationLimit::itlim"]
}, Open  ]],
Cell[17882, 649, 120, 5, 24, "Text",
  CellTags->"$IterationLimit::itlim"],
Cell[18005, 656, 103, 3, 26, "Input",
  CellTags->"$IterationLimit::itlim"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18157, 665, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$IterationLimit::aitlim"],
Cell[18259, 668, 369, 8, 37, "Message",
  CellTags->"$IterationLimit::aitlim"],
Cell[18631, 678, 213, 5, 40, "Notes",
  CellTags->"$IterationLimit::aitlim"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18881, 688, 111, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$MaxComputationSteps::complim"],
Cell[18995, 691, 383, 9, 21, "Message",
  CellTags->"$MaxComputationSteps::complim"],
Cell[19381, 702, 140, 4, 24, "Notes",
  CellTags->"$MaxComputationSteps::complim"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19558, 711, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$Cache::set"],
Cell[19636, 714, 182, 4, 21, "Message",
  CellTags->"$Cache::set"],
Cell[19821, 720, 191, 6, 24, "Notes",
  CellTags->"$Cache::set"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20049, 731, 160, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
Cell[20212, 737, 653, 19, 21, "Message",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
Cell[20868, 758, 530, 15, 62, "Notes",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],

Cell[CellGroupData[{
Cell[21423, 777, 102, 1, 38, "ExampleSection",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
Cell[21528, 780, 281, 7, 40, "Text",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],

Cell[CellGroupData[{
Cell[21834, 791, 145, 3, 26, "Input",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
Cell[21982, 796, 286, 5, 37, "Message",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}],
Cell[22271, 803, 128, 3, 21, "Output",
  CellTags->{"$IterationLimit::limset", "$RecursionLimit::limset"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22460, 813, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Replace::erep"],
Cell[22542, 816, 208, 5, 21, "Message",
  CellTags->"Replace::erep"],
Cell[22753, 823, 277, 8, 40, "Notes",
  CellTags->"Replace::erep"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23067, 836, 160, 6, 91, "ObjectNameWarningMessages",
  CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
Cell[23230, 844, 513, 14, 21, "Message",
  CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
Cell[23746, 860, 217, 4, 24, "Notes",
  CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],

Cell[CellGroupData[{
Cell[23988, 868, 105, 1, 38, "ExampleSection",
  CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
Cell[24096, 871, 187, 4, 24, "Text",
  CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],

Cell[CellGroupData[{
Cell[24308, 879, 190, 4, 26, "Input",
  CellTags->{"With::dup", "Module::dup", "Block::dup", "Dialog::dup"}],
Cell[24501, 885, 263, 5, 37, "Message",
  CellTags->{"Block::dup", "Dialog::dup", "Module::dup", "With::dup"}],
Cell[24767, 892, 167, 3, 21, "Output",
  CellTags->{"Block::dup", "Dialog::dup", "Module::dup", "With::dup"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[24995, 902, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$ModuleNumber::modnc"],
Cell[25091, 905, 195, 3, 21, "Message",
  CellTags->"$ModuleNumber::modnc"],
Cell[25289, 910, 547, 14, 78, "Notes",
  CellTags->"$ModuleNumber::modnc"],

Cell[CellGroupData[{
Cell[25861, 928, 70, 1, 38, "ExampleSection",
  CellTags->"$ModuleNumber::modnc"],
Cell[25934, 931, 271, 8, 40, "Text",
  CellTags->"$ModuleNumber::modnc"],

Cell[CellGroupData[{
Cell[26230, 943, 115, 3, 26, "Input",
  CellTags->"$ModuleNumber::modnc"],
Cell[26348, 948, 107, 3, 21, "Output",
  CellTags->"$ModuleNumber::modnc"]
}, Open  ]],
Cell[26470, 954, 358, 10, 40, "Text",
  CellTags->"$ModuleNumber::modnc"],

Cell[CellGroupData[{
Cell[26853, 968, 126, 3, 26, "Input",
  CellTags->"$ModuleNumber::modnc"],
Cell[26982, 973, 209, 5, 37, "Message",
  CellTags->"$ModuleNumber::modnc"],
Cell[27194, 980, 99, 3, 21, "Output",
  CellTags->"$ModuleNumber::modnc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27354, 990, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$ModuleNumber::set"],
Cell[27446, 993, 368, 10, 21, "Message",
  CellTags->"$ModuleNumber::set"],
Cell[27817, 1005, 216, 5, 24, "Notes",
  CellTags->"$ModuleNumber::set"],

Cell[CellGroupData[{
Cell[28058, 1014, 68, 1, 38, "ExampleSection",
  CellTags->"$ModuleNumber::set"],
Cell[28129, 1017, 237, 7, 40, "Text",
  CellTags->"$ModuleNumber::set"],

Cell[CellGroupData[{
Cell[28391, 1028, 108, 3, 26, "Input",
  CellTags->"$ModuleNumber::set"],
Cell[28502, 1033, 222, 5, 37, "Message",
  CellTags->"$ModuleNumber::set"],
Cell[28727, 1040, 93, 3, 21, "Output",
  CellTags->"$ModuleNumber::set"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[28881, 1050, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"CharacterRange::argtype"],
Cell[28983, 1053, 407, 12, 21, "Message",
  CellTags->"CharacterRange::argtype"],
Cell[29393, 1067, 228, 5, 24, "Notes",
  CellTags->"CharacterRange::argtype"],

Cell[CellGroupData[{
Cell[29646, 1076, 73, 1, 38, "ExampleSection",
  CellTags->"CharacterRange::argtype"],
Cell[29722, 1079, 147, 5, 24, "Text",
  CellTags->"CharacterRange::argtype"],

Cell[CellGroupData[{
Cell[29894, 1088, 118, 3, 26, "Input",
  CellTags->"CharacterRange::argtype"],
Cell[30015, 1093, 243, 5, 37, "Message",
  CellTags->"CharacterRange::argtype"],
Cell[30261, 1100, 117, 3, 21, "Output",
  CellTags->"CharacterRange::argtype"]
}, Open  ]],
Cell[30393, 1106, 142, 5, 24, "Text",
  CellTags->"CharacterRange::argtype"],

Cell[CellGroupData[{
Cell[30560, 1115, 130, 3, 26, "Input",
  CellTags->"CharacterRange::argtype"],
Cell[30693, 1120, 142, 3, 21, "Output",
  CellTags->"CharacterRange::argtype"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30896, 1130, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Set::inset"],
Cell[30972, 1133, 163, 3, 21, "Message",
  CellTags->"Set::inset"],
Cell[31138, 1138, 536, 10, 84, "Notes",
  CellTags->"Set::inset"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31711, 1153, 112, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"With::dups", "Module::dups"}],
Cell[31826, 1159, 543, 16, 37, "Message",
  CellTags->{"With::dups", "Module::dups"}],
Cell[32372, 1177, 512, 12, 78, "Notes",
  CellTags->{"With::dups", "Module::dups"}],

Cell[CellGroupData[{
Cell[32909, 1193, 78, 1, 38, "ExampleSection",
  CellTags->{"With::dups", "Module::dups"}],
Cell[32990, 1196, 278, 7, 40, "Text",
  CellTags->{"With::dups", "Module::dups"}],

Cell[CellGroupData[{
Cell[33293, 1207, 130, 3, 26, "Input",
  CellTags->{"With::dups", "Module::dups"}],
Cell[33426, 1212, 273, 5, 37, "Message",
  CellTags->{"Module::dups", "With::dups"}],
Cell[33702, 1219, 131, 3, 21, "Output",
  CellTags->{"Module::dups", "With::dups"}]
}, Open  ]],
Cell[33848, 1225, 176, 5, 24, "Text",
  CellTags->{"With::dups", "Module::dups"}],

Cell[CellGroupData[{
Cell[34049, 1234, 128, 3, 26, "Input",
  CellTags->{"With::dups", "Module::dups"}],
Cell[34180, 1239, 103, 3, 21, "Output",
  CellTags->{"Module::dups", "With::dups"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[34344, 1249, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"With::lvws"],
Cell[34420, 1252, 334, 7, 21, "Message",
  CellTags->"With::lvws"],
Cell[34757, 1261, 190, 5, 24, "Notes",
  CellTags->"With::lvws"],

Cell[CellGroupData[{
Cell[34972, 1270, 60, 1, 38, "ExampleSection",
  CellTags->"With::lvws"],
Cell[35035, 1273, 172, 6, 24, "Text",
  CellTags->"With::lvws"],

Cell[CellGroupData[{
Cell[35232, 1283, 116, 3, 26, "Input",
  CellTags->"With::lvws"],
Cell[35351, 1288, 209, 5, 21, "Message",
  CellTags->"With::lvws"],
Cell[35563, 1295, 117, 3, 21, "Output",
  CellTags->"With::lvws"]
}, Open  ]],
Cell[35695, 1301, 119, 5, 24, "Text",
  CellTags->"With::lvws"],

Cell[CellGroupData[{
Cell[35839, 1310, 110, 3, 26, "Input",
  CellTags->"With::lvws"],
Cell[35952, 1315, 85, 3, 21, "Output",
  CellTags->"With::lvws"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[36098, 1325, 179, 5, 71, "ObjectNameWarningMessages",
  CellTags->{
  "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
Cell[36280, 1332, 485, 14, 21, "Message",
  CellTags->{
  "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
Cell[36768, 1348, 450, 11, 46, "Notes",
  CellTags->{
  "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[CellGroupData[{
Cell[37243, 1363, 113, 1, 38, "ExampleSection",
  CellTags->{
  "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
Cell[37359, 1366, 243, 7, 24, "Text",
  CellTags->{
  "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[CellGroupData[{
Cell[37627, 1377, 163, 3, 26, "Input",
  CellTags->{
  "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
Cell[37793, 1382, 243, 5, 21, "Message",
  CellTags->{
  "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
Cell[38039, 1389, 139, 3, 21, "Output",
  CellTags->{
  "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}]
}, Open  ]],
Cell[38193, 1395, 188, 5, 24, "Text",
  CellTags->{
  "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[CellGroupData[{
Cell[38406, 1404, 174, 3, 26, "Input",
  CellTags->{
  "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
Cell[38583, 1409, 175, 3, 21, "Output",
  CellTags->{
  "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}]
}, Open  ]],
Cell[38773, 1415, 174, 4, 24, "Text",
  CellTags->{
  "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],

Cell[CellGroupData[{
Cell[38972, 1423, 171, 3, 26, "Input",
  CellTags->{
  "AbsoluteOptions::optnf", "SetOptions::optnf", "Options::optnf"}],
Cell[39146, 1428, 246, 5, 21, "Message",
  CellTags->{
  "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}],
Cell[39395, 1435, 177, 3, 21, "Output",
  CellTags->{
  "AbsoluteOptions::optnf", "Options::optnf", "SetOptions::optnf"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[39633, 1445, 159, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[39795, 1452, 432, 12, 21, "Message",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[40230, 1466, 663, 18, 78, "Notes",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[CellGroupData[{
Cell[40918, 1488, 103, 1, 38, "ExampleSection",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[41024, 1491, 229, 5, 24, "Text",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[CellGroupData[{
Cell[41278, 1500, 138, 3, 26, "Input",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[41419, 1505, 241, 5, 21, "Message",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[41663, 1512, 145, 3, 21, "Output",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}]
}, Open  ]],
Cell[41823, 1518, 311, 8, 40, "Text",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[42137, 1528, 331, 7, 154, "Input",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[CellGroupData[{
Cell[42493, 1539, 130, 3, 26, "Input",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[42626, 1544, 229, 5, 21, "Print",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[42858, 1551, 229, 5, 21, "Print",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[43090, 1558, 229, 5, 21, "Print",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[43322, 1565, 128, 3, 21, "Output",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}]
}, Open  ]],
Cell[43465, 1571, 303, 7, 40, "Text",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[43771, 1580, 308, 6, 154, "Input",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[CellGroupData[{
Cell[44104, 1590, 130, 3, 26, "Input",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[44237, 1595, 229, 5, 21, "Print",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[44469, 1602, 229, 5, 21, "Print",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[44701, 1609, 229, 5, 21, "Print",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[44933, 1616, 131, 3, 21, "Output",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}]
}, Open  ]],
Cell[45079, 1622, 348, 9, 40, "Text",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[45430, 1633, 326, 7, 154, "Input",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],

Cell[CellGroupData[{
Cell[45781, 1644, 130, 3, 26, "Input",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[45914, 1649, 229, 5, 21, "Print",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[46146, 1656, 229, 5, 21, "Print",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[46378, 1663, 229, 5, 21, "Print",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[46610, 1670, 241, 5, 21, "Message",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[46854, 1677, 145, 3, 21, "Output",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}]
}, Open  ]],
Cell[47014, 1683, 155, 5, 24, "Text",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}],
Cell[47172, 1690, 134, 3, 26, "Input",
  CellTags->{"Break::nofunc", "Continue::nofunc", "Return::nofunc"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47355, 1699, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$RecursionLimit::reclim"],
Cell[47457, 1702, 252, 5, 21, "Message",
  CellTags->"$RecursionLimit::reclim"],
Cell[47712, 1709, 573, 12, 100, "Notes",
  CellTags->"$RecursionLimit::reclim"],

Cell[CellGroupData[{
Cell[48310, 1725, 73, 1, 38, "ExampleSection",
  CellTags->"$RecursionLimit::reclim"],
Cell[48386, 1728, 194, 6, 24, "Text",
  CellTags->"$RecursionLimit::reclim"],

Cell[CellGroupData[{
Cell[48605, 1738, 109, 3, 26, "Input",
  CellTags->"$RecursionLimit::reclim"],
Cell[48717, 1743, 192, 4, 21, "Message",
  CellTags->"$RecursionLimit::reclim"],
Cell[48912, 1749, 116, 3, 21, "Output",
  CellTags->"$RecursionLimit::reclim"]
}, Open  ]],
Cell[49043, 1755, 175, 5, 24, "Text",
  CellTags->"$RecursionLimit::reclim"],

Cell[CellGroupData[{
Cell[49243, 1764, 104, 3, 26, "Input",
  CellTags->"$RecursionLimit::reclim"],
Cell[49350, 1769, 99, 3, 21, "Output",
  CellTags->"$RecursionLimit::reclim"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49486, 1777, 109, 3, 26, "Input",
  CellTags->"$RecursionLimit::reclim"],
Cell[49598, 1782, 99, 3, 21, "Output",
  CellTags->"$RecursionLimit::reclim"]
}, Open  ]],
Cell[49712, 1788, 122, 5, 24, "Text",
  CellTags->"$RecursionLimit::reclim"],
Cell[49837, 1795, 106, 3, 26, "Input",
  CellTags->"$RecursionLimit::reclim"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[49992, 1804, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Condition::condp"],
Cell[50080, 1807, 421, 11, 21, "Message",
  CellTags->"Condition::condp"],
Cell[50504, 1820, 938, 24, 116, "Notes",
  CellTags->"Condition::condp"],

Cell[CellGroupData[{
Cell[51467, 1848, 66, 1, 38, "ExampleSection",
  CellTags->"Condition::condp"],
Cell[51536, 1851, 184, 4, 40, "Text",
  CellTags->"Condition::condp"],

Cell[CellGroupData[{
Cell[51745, 1859, 134, 3, 26, "Input",
  CellTags->"Condition::condp"],
Cell[51882, 1864, 231, 5, 37, "Message",
  CellTags->"Condition::condp"],
Cell[52116, 1871, 105, 3, 21, "Output",
  CellTags->"Condition::condp"]
}, Open  ]],
Cell[52236, 1877, 105, 1, 24, "Text",
  CellTags->"Condition::condp"],

Cell[CellGroupData[{
Cell[52366, 1882, 133, 3, 26, "Input",
  CellTags->"Condition::condp"],
Cell[52502, 1887, 105, 3, 21, "Output",
  CellTags->"Condition::condp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52668, 1897, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Optional::opdef"],
Cell[52754, 1900, 315, 6, 21, "Message",
  CellTags->"Optional::opdef"],
Cell[53072, 1908, 1081, 31, 144, "Notes",
  CellTags->"Optional::opdef"],

Cell[CellGroupData[{
Cell[54178, 1943, 65, 1, 38, "ExampleSection",
  CellTags->"Optional::opdef"],
Cell[54246, 1946, 353, 10, 40, "Text",
  CellTags->"Optional::opdef"],

Cell[CellGroupData[{
Cell[54624, 1960, 125, 3, 26, "Input",
  CellTags->"Optional::opdef"],
Cell[54752, 1965, 216, 5, 37, "Message",
  CellTags->"Optional::opdef"],
Cell[54971, 1972, 216, 5, 37, "Message",
  CellTags->"Optional::opdef"],
Cell[55190, 1979, 103, 3, 21, "Output",
  CellTags->"Optional::opdef"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[55354, 1989, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Attributes::attnf"],
Cell[55444, 1992, 212, 5, 21, "Message",
  CellTags->"Attributes::attnf"],
Cell[55659, 1999, 1137, 46, 100, "Notes",
  CellTags->"Attributes::attnf"],

Cell[CellGroupData[{
Cell[56821, 2049, 67, 1, 38, "ExampleSection",
  CellTags->"Attributes::attnf"],
Cell[56891, 2052, 311, 7, 40, "Text",
  CellTags->"Attributes::attnf"],

Cell[CellGroupData[{
Cell[57227, 2063, 119, 3, 26, "Input",
  CellTags->"Attributes::attnf"],
Cell[57349, 2068, 185, 4, 21, "Message",
  CellTags->"Attributes::attnf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[57595, 2079, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Attributes::attsl"],
Cell[57685, 2082, 256, 5, 21, "Message",
  CellTags->"Attributes::attsl"],
Cell[57944, 2089, 212, 5, 24, "Notes",
  CellTags->"Attributes::attsl"]
}, Open  ]],

Cell[CellGroupData[{
Cell[58193, 2099, 118, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Block::lockt", "Dialog::lockt"}],
Cell[58314, 2105, 566, 16, 37, "Message",
  CellTags->{"Block::lockt", "Dialog::lockt"}],
Cell[58883, 2123, 601, 19, 68, "Notes",
  CellTags->{"Block::lockt", "Dialog::lockt"}],

Cell[CellGroupData[{
Cell[59509, 2146, 81, 1, 38, "ExampleSection",
  CellTags->{"Block::lockt", "Dialog::lockt"}],
Cell[59593, 2149, 323, 11, 40, "Text",
  CellTags->{"Block::lockt", "Dialog::lockt"}],

Cell[CellGroupData[{
Cell[59941, 2164, 137, 3, 26, "Input",
  CellTags->{"Block::lockt", "Dialog::lockt"}],
Cell[60081, 2169, 280, 5, 37, "Message",
  CellTags->{"Block::lockt", "Dialog::lockt"}],
Cell[60364, 2176, 136, 3, 21, "Output",
  CellTags->{"Block::lockt", "Dialog::lockt"}]
}, Open  ]],
Cell[60515, 2182, 189, 6, 24, "Text",
  CellTags->{"Block::lockt", "Dialog::lockt"}],

Cell[CellGroupData[{
Cell[60729, 2192, 135, 3, 26, "Input",
  CellTags->{"Block::lockt", "Dialog::lockt"}],
Cell[60867, 2197, 114, 3, 21, "Output",
  CellTags->{"Block::lockt", "Dialog::lockt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[61042, 2207, 118, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Block::lockv", "Dialog::lockv"}],
Cell[61163, 2213, 490, 14, 21, "Message",
  CellTags->{"Block::lockv", "Dialog::lockv"}],
Cell[61656, 2229, 580, 19, 68, "Notes",
  CellTags->{"Block::lockv", "Dialog::lockv"}],

Cell[CellGroupData[{
Cell[62261, 2252, 81, 1, 38, "ExampleSection",
  CellTags->{"Block::lockv", "Dialog::lockv"}],
Cell[62345, 2255, 323, 11, 40, "Text",
  CellTags->{"Block::lockv", "Dialog::lockv"}],

Cell[CellGroupData[{
Cell[62693, 2270, 135, 3, 26, "Input",
  CellTags->{"Block::lockv", "Dialog::lockv"}],
Cell[62831, 2275, 239, 5, 37, "Message",
  CellTags->{"Block::lockv", "Dialog::lockv"}],
Cell[63073, 2282, 136, 3, 21, "Output",
  CellTags->{"Block::lockv", "Dialog::lockv"}]
}, Open  ]],
Cell[63224, 2288, 189, 6, 24, "Text",
  CellTags->{"Block::lockv", "Dialog::lockv"}],

Cell[CellGroupData[{
Cell[63438, 2298, 135, 3, 26, "Input",
  CellTags->{"Block::lockv", "Dialog::lockv"}],
Cell[63576, 2303, 114, 3, 21, "Output",
  CellTags->{"Block::lockv", "Dialog::lockv"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[63751, 2313, 187, 7, 91, "ObjectNameWarningMessages",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
Cell[63941, 2322, 445, 12, 21, "Message",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
Cell[64389, 2336, 1084, 29, 144, "Notes",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],

Cell[CellGroupData[{
Cell[65498, 2369, 120, 2, 38, "ExampleSection",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
Cell[65621, 2373, 185, 5, 24, "Text",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],

Cell[CellGroupData[{
Cell[65831, 2382, 168, 4, 26, "Input",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
Cell[66002, 2388, 242, 5, 21, "Message",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
Cell[66247, 2395, 169, 4, 21, "Output",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}]
}, Open  ]],
Cell[66431, 2402, 203, 6, 24, "Text",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],

Cell[CellGroupData[{
Cell[66659, 2412, 170, 4, 26, "Input",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}],
Cell[66832, 2418, 146, 4, 21, "Output",
  CellTags->{
  "Block::lvlist", "Dialog::lvlist", "Module::lvlist", "With::lvlist"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[67039, 2429, 176, 6, 91, "ObjectNameWarningMessages",
  CellTags->{
  "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
Cell[67218, 2437, 671, 18, 37, "Message",
  CellTags->{
  "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
Cell[67892, 2457, 1137, 34, 138, "Notes",
  CellTags->{
  "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],

Cell[CellGroupData[{
Cell[69054, 2495, 113, 1, 38, "ExampleSection",
  CellTags->{
  "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
Cell[69170, 2498, 310, 6, 40, "Text",
  CellTags->{
  "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],

Cell[CellGroupData[{
Cell[69505, 2508, 172, 3, 26, "Input",
  CellTags->{
  "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
Cell[69680, 2513, 381, 6, 53, "Message",
  CellTags->{
  "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}],
Cell[70064, 2521, 173, 3, 21, "Output",
  CellTags->{
  "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}]
}, Open  ]],
Cell[70252, 2527, 195, 5, 24, "Text",
  CellTags->{
  "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],

Cell[CellGroupData[{
Cell[70472, 2536, 164, 3, 26, "Input",
  CellTags->{
  "Block::lvset", "Dialog::lvset", "With::lvset", "Module::lvset"}],
Cell[70639, 2541, 152, 3, 21, "Output",
  CellTags->{
  "Block::lvset", "Dialog::lvset", "Module::lvset", "With::lvset"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[70852, 2551, 149, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
Cell[71004, 2558, 583, 14, 37, "Message",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
Cell[71590, 2574, 856, 22, 100, "Notes",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],

Cell[CellGroupData[{
Cell[72471, 2600, 98, 1, 38, "ExampleSection",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
Cell[72572, 2603, 236, 5, 24, "Text",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],

Cell[CellGroupData[{
Cell[72833, 2612, 179, 3, 26, "Input",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
Cell[73015, 2617, 298, 6, 37, "Message",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
Cell[73316, 2625, 182, 4, 21, "Output",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}]
}, Open  ]],
Cell[73513, 2632, 175, 5, 24, "Text",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],

Cell[CellGroupData[{
Cell[73713, 2641, 175, 3, 26, "Input",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}],
Cell[73891, 2646, 131, 3, 21, "Output",
  CellTags->{"Block::lvsym", "Dialog::lvsym", "Module::lvsym"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[74083, 2656, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Break::nofwd"],
Cell[74163, 2659, 248, 5, 21, "Message",
  CellTags->"Break::nofwd"],
Cell[74414, 2666, 194, 5, 24, "Notes",
  CellTags->"Break::nofwd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[74645, 2676, 122, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Clear::spsym", "ClearAll::spsym"}],
Cell[74770, 2682, 381, 11, 21, "Message",
  CellTags->{"Clear::spsym", "ClearAll::spsym"}],
Cell[75154, 2695, 528, 15, 62, "Notes",
  CellTags->{"Clear::spsym", "ClearAll::spsym"}],

Cell[CellGroupData[{
Cell[75707, 2714, 83, 1, 38, "ExampleSection",
  CellTags->{"Clear::spsym", "ClearAll::spsym"}],
Cell[75793, 2717, 184, 5, 24, "Text",
  CellTags->{"Clear::spsym", "ClearAll::spsym"}],

Cell[CellGroupData[{
Cell[76002, 2726, 125, 3, 26, "Input",
  CellTags->{"Clear::spsym", "ClearAll::spsym"}],
Cell[76130, 2731, 205, 4, 21, "Message",
  CellTags->{"ClearAll::spsym", "Clear::spsym"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[76396, 2742, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Remove::spsym"],
Cell[76478, 2745, 234, 5, 21, "Message",
  CellTags->"Remove::spsym"],
Cell[76715, 2752, 495, 15, 62, "Notes",
  CellTags->"Remove::spsym"],

Cell[CellGroupData[{
Cell[77235, 2771, 63, 1, 38, "ExampleSection",
  CellTags->"Remove::spsym"],
Cell[77301, 2774, 164, 5, 24, "Text",
  CellTags->"Remove::spsym"],

Cell[CellGroupData[{
Cell[77490, 2783, 106, 3, 26, "Input",
  CellTags->"Remove::spsym"],
Cell[77599, 2788, 186, 4, 21, "Message",
  CellTags->"Remove::spsym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[77846, 2799, 157, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
Cell[78006, 2806, 419, 11, 21, "Message",
  CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
Cell[78428, 2819, 642, 14, 106, "Notes",
  CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],

Cell[CellGroupData[{
Cell[79095, 2837, 102, 1, 38, "ExampleSection",
  CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
Cell[79200, 2840, 191, 4, 24, "Text",
  CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],

Cell[CellGroupData[{
Cell[79416, 2848, 137, 3, 26, "Input",
  CellTags->{"Clear::ssym", "ClearAll::ssym", "Information::ssym"}],
Cell[79556, 2853, 211, 4, 21, "Message",
  CellTags->{"ClearAll::ssym", "Clear::ssym", "Information::ssym"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[79828, 2864, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ClearAll::clloc"],
Cell[79914, 2867, 226, 5, 21, "Message",
  CellTags->"ClearAll::clloc"],
Cell[80143, 2874, 257, 7, 24, "Notes",
  CellTags->"ClearAll::clloc"],

Cell[CellGroupData[{
Cell[80425, 2885, 65, 1, 38, "ExampleSection",
  CellTags->"ClearAll::clloc"],
Cell[80493, 2888, 214, 7, 24, "Text",
  CellTags->"ClearAll::clloc"],

Cell[CellGroupData[{
Cell[80732, 2899, 111, 3, 26, "Input",
  CellTags->"ClearAll::clloc"],
Cell[80846, 2904, 174, 4, 21, "Message",
  CellTags->"ClearAll::clloc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[81081, 2915, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Context::cxdup"],
Cell[81165, 2918, 595, 18, 37, "Message",
  CellTags->"Context::cxdup"],
Cell[81763, 2938, 415, 11, 46, "Notes",
  CellTags->"Context::cxdup"],

Cell[CellGroupData[{
Cell[82203, 2953, 64, 1, 38, "ExampleSection",
  CellTags->"Context::cxdup"],
Cell[82270, 2956, 226, 5, 40, "Text",
  CellTags->"Context::cxdup"],

Cell[CellGroupData[{
Cell[82521, 2965, 99, 3, 26, "Input",
  CellTags->"Context::cxdup"],
Cell[82623, 2970, 100, 3, 21, "Output",
  CellTags->"Context::cxdup"]
}, Open  ]],

Cell[CellGroupData[{
Cell[82760, 2978, 126, 3, 26, "Input",
  CellTags->"Context::cxdup"],
Cell[82889, 2983, 289, 6, 37, "Message",
  CellTags->"Context::cxdup"],
Cell[83181, 2991, 99, 3, 21, "Output",
  CellTags->"Context::cxdup"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[83341, 3001, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Context::cxname"],
Cell[83427, 3004, 383, 10, 21, "Message",
  CellTags->"Context::cxname"],
Cell[83813, 3016, 392, 7, 62, "Notes",
  CellTags->"Context::cxname"],

Cell[CellGroupData[{
Cell[84230, 3027, 65, 1, 38, "ExampleSection",
  CellTags->"Context::cxname"],
Cell[84298, 3030, 204, 5, 40, "Text",
  CellTags->"Context::cxname"],

Cell[CellGroupData[{
Cell[84527, 3039, 121, 3, 26, "Input",
  CellTags->"Context::cxname"],
Cell[84651, 3044, 212, 5, 21, "Message",
  CellTags->"Context::cxname"],
Cell[84866, 3051, 118, 3, 21, "Output",
  CellTags->"Context::cxname"]
}, Open  ]],
Cell[84999, 3057, 89, 1, 24, "Text",
  CellTags->"Context::cxname"],

Cell[CellGroupData[{
Cell[85113, 3062, 121, 3, 26, "Input",
  CellTags->"Context::cxname"],
Cell[85237, 3067, 100, 3, 21, "Output",
  CellTags->"Context::cxname"]
}, Open  ]],
Cell[85352, 3073, 130, 4, 24, "Text",
  CellTags->"Context::cxname"],

Cell[CellGroupData[{
Cell[85507, 3081, 115, 3, 26, "Input",
  CellTags->"Context::cxname"],
Cell[85625, 3086, 206, 5, 21, "Message",
  CellTags->"Context::cxname"],
Cell[85834, 3093, 112, 3, 21, "Output",
  CellTags->"Context::cxname"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[86007, 3103, 126, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Context::cxset", "$Context::cxset"}],
Cell[86136, 3109, 639, 19, 21, "Message",
  CellTags->{"Context::cxset", "$Context::cxset"}],
Cell[86778, 3130, 366, 7, 46, "Notes",
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell[CellGroupData[{
Cell[87169, 3141, 85, 1, 38, "ExampleSection",
  CellTags->{"Context::cxset", "$Context::cxset"}],
Cell[87257, 3144, 240, 5, 40, "Text",
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell[CellGroupData[{
Cell[87522, 3153, 132, 3, 26, "Input",
  CellTags->{"Context::cxset", "$Context::cxset"}],
Cell[87657, 3158, 267, 5, 37, "Message",
  CellTags->{"Context::cxset", "$Context::cxset"}],
Cell[87927, 3165, 118, 3, 21, "Output",
  CellTags->{"Context::cxset", "$Context::cxset"}]
}, Open  ]],
Cell[88060, 3171, 268, 7, 40, "Text",
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell[CellGroupData[{
Cell[88353, 3182, 133, 3, 26, "Input",
  CellTags->{"Context::cxset", "$Context::cxset"}],
Cell[88489, 3187, 119, 3, 21, "Output",
  CellTags->{"Context::cxset", "$Context::cxset"}]
}, Open  ]],
Cell[88623, 3193, 115, 1, 24, "Text",
  CellTags->{"Context::cxset", "$Context::cxset"}],

Cell[CellGroupData[{
Cell[88763, 3198, 132, 3, 26, "Input",
  CellTags->{"Context::cxset", "$Context::cxset"}],
Cell[88898, 3203, 118, 3, 21, "Output",
  CellTags->{"Context::cxset", "$Context::cxset"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[89077, 3213, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ContextToFileName::cxfil"],
Cell[89181, 3216, 521, 14, 37, "Message",
  CellTags->"ContextToFileName::cxfil"],
Cell[89705, 3232, 824, 19, 100, "Notes",
  CellTags->"ContextToFileName::cxfil"],

Cell[CellGroupData[{
Cell[90554, 3255, 74, 1, 38, "ExampleSection",
  CellTags->"ContextToFileName::cxfil"],
Cell[90631, 3258, 199, 6, 24, "Text",
  CellTags->"ContextToFileName::cxfil"],

Cell[CellGroupData[{
Cell[90855, 3268, 193, 4, 74, "Input",
  CellTags->"ContextToFileName::cxfil"],
Cell[91051, 3274, 269, 5, 37, "Message",
  CellTags->"ContextToFileName::cxfil"],
Cell[91323, 3281, 174, 4, 21, "Message",
  CellTags->"ContextToFileName::cxfil"],
Cell[91500, 3287, 215, 5, 21, "Message",
  CellTags->"ContextToFileName::cxfil"],
Cell[91718, 3294, 105, 3, 21, "Output",
  CellTags->"ContextToFileName::cxfil"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[91884, 3304, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Continue::nofwd"],
Cell[91970, 3307, 254, 5, 21, "Message",
  CellTags->"Continue::nofwd"],
Cell[92227, 3314, 193, 5, 24, "Notes",
  CellTags->"Continue::nofwd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[92457, 3324, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Debug::dbug"],
Cell[92535, 3327, 175, 3, 21, "Message",
  CellTags->"Debug::dbug"],
Cell[92713, 3332, 456, 13, 68, "Notes",
  CellTags->"Debug::dbug"]
}, Open  ]],

Cell[CellGroupData[{
Cell[93206, 3350, 95, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DeclarePackage::aldec"],
Cell[93304, 3353, 341, 9, 21, "Message",
  CellTags->"DeclarePackage::aldec"],
Cell[93648, 3364, 441, 9, 62, "Notes",
  CellTags->"DeclarePackage::aldec"],

Cell[CellGroupData[{
Cell[94114, 3377, 71, 1, 38, "ExampleSection",
  CellTags->"DeclarePackage::aldec"],
Cell[94188, 3380, 230, 5, 40, "Text",
  CellTags->"DeclarePackage::aldec"],

Cell[CellGroupData[{
Cell[94443, 3389, 118, 3, 26, "Input",
  CellTags->"DeclarePackage::aldec"],
Cell[94564, 3394, 119, 3, 21, "Output",
  CellTags->"DeclarePackage::aldec"]
}, Open  ]],

Cell[CellGroupData[{
Cell[94720, 3402, 148, 3, 26, "Input",
  CellTags->"DeclarePackage::aldec"],
Cell[94871, 3407, 277, 5, 37, "Message",
  CellTags->"DeclarePackage::aldec"],
Cell[95151, 3414, 108, 3, 21, "Output",
  CellTags->"DeclarePackage::aldec"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[95320, 3424, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"DefineExternal::des"],
Cell[95414, 3427, 644, 14, 53, "Message",
  CellTags->"DefineExternal::des"],
Cell[96061, 3443, 866, 23, 122, "Notes",
  CellTags->"DefineExternal::des"],

Cell[CellGroupData[{
Cell[96952, 3470, 69, 1, 38, "ExampleSection",
  CellTags->"DefineExternal::des"],
Cell[97024, 3473, 344, 8, 40, "Text",
  CellTags->"DefineExternal::des"],

Cell[CellGroupData[{
Cell[97393, 3485, 141, 3, 26, "Input",
  CellTags->"DefineExternal::des"],
Cell[97537, 3490, 196, 5, 36, "Message",
  CellTags->"DefineExternal::des"],
Cell[97736, 3497, 572, 10, 69, "Message",
  CellTags->"DefineExternal::des"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[98369, 3514, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Dialog::dpa"],
Cell[98447, 3517, 268, 5, 21, "Message",
  CellTags->"Dialog::dpa"],
Cell[98718, 3524, 319, 7, 46, "Notes",
  CellTags->"Dialog::dpa"]
}, Open  ]],

Cell[CellGroupData[{
Cell[99074, 3536, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Dialog::exd"],
Cell[99152, 3539, 252, 5, 37, "Message",
  CellTags->"Dialog::exd"],
Cell[99407, 3546, 433, 16, 46, "Notes",
  CellTags->"Dialog::exd"],

Cell[CellGroupData[{
Cell[99865, 3566, 61, 1, 38, "ExampleSection",
  CellTags->"Dialog::exd"],
Cell[99929, 3569, 193, 7, 24, "Text",
  CellTags->"Dialog::exd"],

Cell[CellGroupData[{
Cell[100147, 3580, 92, 3, 26, "Input",
  CellTags->"Dialog::exd"],
Cell[100242, 3585, 89, 3, 21, "Output",
  CellTags->"Dialog::exd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[100368, 3593, 97, 3, 26, "Input",
  CellTags->"Dialog::exd"],
Cell[100468, 3598, 241, 5, 37, "Message",
  CellTags->"Dialog::exd"],
Cell[100712, 3605, 98, 3, 21, "Output",
  CellTags->"Dialog::exd"]
}, Open  ]],
Cell[100825, 3611, 128, 5, 24, "Text",
  CellTags->"Dialog::exd"],
Cell[100956, 3618, 105, 3, 26, "Input",
  CellTags->"Dialog::exd"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[101110, 3627, 375, 13, 171, "ObjectNameWarningMessages",
  CellTags->{
  "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
    "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
    "Messages::itloc", "SubValues::itloc"}],
Cell[101488, 3642, 773, 21, 37, "Message",
  CellTags->{
  "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
    "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
    "Messages::itloc", "SubValues::itloc"}],
Cell[102264, 3665, 659, 17, 68, "Notes",
  CellTags->{
  "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
    "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
    "Messages::itloc", "SubValues::itloc"}],

Cell[CellGroupData[{
Cell[102948, 3686, 225, 4, 38, "ExampleSection",
  CellTags->{
  "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
    "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
    "Messages::itloc", "SubValues::itloc"}],
Cell[103176, 3692, 357, 8, 40, "Text",
  CellTags->{
  "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
    "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
    "Messages::itloc", "SubValues::itloc"}],

Cell[CellGroupData[{
Cell[103558, 3704, 305, 6, 26, "Input",
  CellTags->{
  "DownValues::itloc", "UpValues::itloc", "OwnValues::itloc", 
    "FormatValues::itloc", "DefaultValues::itloc", "NValues::itloc", 
    "Messages::itloc", "SubValues::itloc"}],
Cell[103866, 3712, 423, 8, 39, "Message",
  CellTags->{
  "DefaultValues::itloc", "DownValues::itloc", "FormatValues::itloc", 
    "Messages::itloc", "NValues::itloc", "OwnValues::itloc", 
    "SubValues::itloc", "UpValues::itloc"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[104350, 3727, 375, 13, 171, "ObjectNameWarningMessages",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],
Cell[104728, 3742, 619, 18, 21, "Message",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],
Cell[105350, 3762, 686, 13, 90, "Notes",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[CellGroupData[{
Cell[106061, 3779, 225, 4, 38, "ExampleSection",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],
Cell[106289, 3785, 318, 7, 24, "Text",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[CellGroupData[{
Cell[106632, 3796, 286, 6, 26, "Input",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],
Cell[106921, 3804, 392, 8, 37, "Message",
  CellTags->{
  "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
    "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
    "SubValues::vlist", "UpValues::vlist"}],
Cell[107316, 3814, 266, 6, 21, "Output",
  CellTags->{
  "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
    "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
    "SubValues::vlist", "UpValues::vlist"}]
}, Open  ]],
Cell[107597, 3823, 266, 4, 24, "Text",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[CellGroupData[{
Cell[107888, 3831, 325, 8, 26, "Input",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],
Cell[108216, 3841, 310, 7, 21, "Output",
  CellTags->{
  "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
    "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
    "SubValues::vlist", "UpValues::vlist"}]
}, Open  ]],
Cell[108541, 3851, 278, 7, 24, "Text",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[CellGroupData[{
Cell[108844, 3862, 281, 6, 26, "Input",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],
Cell[109128, 3870, 266, 6, 21, "Output",
  CellTags->{
  "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
    "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
    "SubValues::vlist", "UpValues::vlist"}]
}, Open  ]],
Cell[109409, 3879, 278, 7, 24, "Text",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],

Cell[CellGroupData[{
Cell[109712, 3890, 262, 6, 26, "Input",
  CellTags->{
  "DownValues::vlist", "UpValues::vlist", "OwnValues::vlist", 
    "FormatValues::vlist", "DefaultValues::vlist", "NValues::vlist", 
    "Messages::vlist", "SubValues::vlist"}],
Cell[109977, 3898, 310, 7, 21, "Output",
  CellTags->{
  "DefaultValues::vlist", "DownValues::vlist", "FormatValues::vlist", 
    "Messages::vlist", "NValues::vlist", "OwnValues::vlist", 
    "SubValues::vlist", "UpValues::vlist"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[110348, 3912, 375, 13, 171, "ObjectNameWarningMessages",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],
Cell[110726, 3927, 745, 21, 21, "Message",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],
Cell[111474, 3950, 717, 13, 90, "Notes",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[CellGroupData[{
Cell[112216, 3967, 225, 4, 38, "ExampleSection",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],
Cell[112444, 3973, 324, 7, 24, "Text",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[CellGroupData[{
Cell[112793, 3984, 288, 6, 26, "Input",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],
Cell[113084, 3992, 426, 8, 37, "Message",
  CellTags->{
  "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
    "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
    "SubValues::vrule", "UpValues::vrule"}],
Cell[113513, 4002, 268, 6, 21, "Output",
  CellTags->{
  "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
    "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
    "SubValues::vrule", "UpValues::vrule"}]
}, Open  ]],
Cell[113796, 4011, 266, 4, 24, "Text",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[CellGroupData[{
Cell[114087, 4019, 325, 8, 26, "Input",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],
Cell[114415, 4029, 310, 7, 21, "Output",
  CellTags->{
  "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
    "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
    "SubValues::vrule", "UpValues::vrule"}]
}, Open  ]],
Cell[114740, 4039, 281, 7, 24, "Text",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[CellGroupData[{
Cell[115046, 4050, 281, 6, 26, "Input",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],
Cell[115330, 4058, 266, 6, 21, "Output",
  CellTags->{
  "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
    "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
    "SubValues::vrule", "UpValues::vrule"}]
}, Open  ]],
Cell[115611, 4067, 278, 7, 24, "Text",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],

Cell[CellGroupData[{
Cell[115914, 4078, 262, 6, 26, "Input",
  CellTags->{
  "DownValues::vrule", "UpValues::vrule", "OwnValues::vrule", 
    "FormatValues::vrule", "DefaultValues::vrule", "NValues::vrule", 
    "Messages::vrule", "SubValues::vrule"}],
Cell[116179, 4086, 310, 7, 21, "Output",
  CellTags->{
  "DefaultValues::vrule", "DownValues::vrule", "FormatValues::vrule", 
    "Messages::vrule", "NValues::vrule", "OwnValues::vrule", 
    "SubValues::vrule", "UpValues::vrule"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[116550, 4100, 95, 1, 31, "ObjectNameWarningMessages",
  CellTags->"EditDefinition::edsym"],
Cell[116648, 4103, 208, 4, 21, "Message",
  CellTags->"EditDefinition::edsym"],
Cell[116859, 4109, 546, 14, 62, "Notes",
  CellTags->"EditDefinition::edsym"],

Cell[CellGroupData[{
Cell[117430, 4127, 71, 1, 38, "ExampleSection",
  CellTags->"EditDefinition::edsym"],
Cell[117504, 4130, 203, 5, 24, "Text",
  CellTags->"EditDefinition::edsym"],

Cell[CellGroupData[{
Cell[117732, 4139, 111, 3, 26, "Input",
  CellTags->"EditDefinition::edsym"],
Cell[117846, 4144, 174, 4, 21, "Message",
  CellTags->"EditDefinition::edsym"],
Cell[118023, 4150, 112, 3, 21, "Output",
  CellTags->"EditDefinition::edsym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[118196, 4160, 153, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
Cell[118352, 4167, 269, 7, 21, "Message",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
Cell[118624, 4176, 643, 24, 62, "Notes",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],

Cell[CellGroupData[{
Cell[119292, 4204, 100, 1, 38, "ExampleSection",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
Cell[119395, 4207, 329, 10, 40, "Text",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],

Cell[CellGroupData[{
Cell[119749, 4221, 128, 3, 26, "Input",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
Cell[119880, 4226, 196, 4, 21, "Message",
  CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}],
Cell[120079, 4232, 133, 3, 21, "Output",
  CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}]
}, Open  ]],
Cell[120227, 4238, 225, 7, 24, "Text",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],

Cell[CellGroupData[{
Cell[120477, 4249, 147, 3, 26, "Input",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
Cell[120627, 4254, 137, 3, 21, "Output",
  CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[120801, 4262, 128, 3, 26, "Input",
  CellTags->{"End::noctx", "EndAdd::noctx", "EndPackage::noctx"}],
Cell[120932, 4267, 137, 3, 21, "Output",
  CellTags->{"EndAdd::noctx", "End::noctx", "EndPackage::noctx"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[121130, 4277, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ExitDialog::cant"],
Cell[121218, 4280, 147, 3, 21, "Message",
  CellTags->"ExitDialog::cant"],
Cell[121368, 4285, 278, 7, 46, "Notes",
  CellTags->"ExitDialog::cant"],

Cell[CellGroupData[{
Cell[121671, 4296, 66, 1, 38, "ExampleSection",
  CellTags->"ExitDialog::cant"],
Cell[121740, 4299, 146, 5, 24, "Text",
  CellTags->"ExitDialog::cant"],

Cell[CellGroupData[{
Cell[121911, 4308, 97, 3, 26, "Input",
  CellTags->"ExitDialog::cant"],
Cell[122011, 4313, 91, 3, 21, "Output",
  CellTags->"ExitDialog::cant"]
}, Open  ]],

Cell[CellGroupData[{
Cell[122139, 4321, 103, 3, 26, "Input",
  CellTags->"ExitDialog::cant"],
Cell[122245, 4326, 100, 3, 21, "Output",
  CellTags->"ExitDialog::cant"]
}, Open  ]],
Cell[122360, 4332, 110, 3, 26, "Input",
  CellTags->"ExitDialog::cant"],
Cell[122473, 4337, 172, 5, 24, "Text",
  CellTags->"ExitDialog::cant"],

Cell[CellGroupData[{
Cell[122670, 4346, 101, 3, 26, "Input",
  CellTags->"ExitDialog::cant"],
Cell[122774, 4351, 163, 4, 21, "Message",
  CellTags->"ExitDialog::cant"],
Cell[122940, 4357, 102, 3, 21, "Output",
  CellTags->"ExitDialog::cant"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[123103, 4367, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Return::obs"],
Cell[123181, 4370, 434, 8, 69, "Message",
  CellTags->"Return::obs"],
Cell[123618, 4380, 122, 4, 24, "Notes",
  CellTags->"Return::obs"]
}, Open  ]],

Cell[CellGroupData[{
Cell[123777, 4389, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FrontEndObject::notavail"],
Cell[123881, 4392, 229, 5, 37, "Message",
  CellTags->"FrontEndObject::notavail"],
Cell[124113, 4399, 858, 20, 116, "Notes",
  CellTags->"FrontEndObject::notavail"]
}, Open  ]],

Cell[CellGroupData[{
Cell[125008, 4424, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Function::attf"],
Cell[125092, 4427, 343, 9, 21, "Message",
  CellTags->"Function::attf"],
Cell[125438, 4438, 711, 25, 84, "Notes",
  CellTags->"Function::attf"],

Cell[CellGroupData[{
Cell[126174, 4467, 64, 1, 38, "ExampleSection",
  CellTags->"Function::attf"],
Cell[126241, 4470, 216, 7, 24, "Text",
  CellTags->"Function::attf"],

Cell[CellGroupData[{
Cell[126482, 4481, 130, 3, 26, "Input",
  CellTags->"Function::attf"],
Cell[126615, 4486, 252, 5, 37, "Message",
  CellTags->"Function::attf"],
Cell[126870, 4493, 252, 5, 37, "Message",
  CellTags->"Function::attf"],
Cell[127125, 4500, 127, 3, 21, "Output",
  CellTags->"Function::attf"]
}, Open  ]],
Cell[127267, 4506, 141, 5, 24, "Text",
  CellTags->"Function::attf"],

Cell[CellGroupData[{
Cell[127433, 4515, 132, 3, 26, "Input",
  CellTags->"Function::attf"],
Cell[127568, 4520, 103, 3, 21, "Output",
  CellTags->"Function::attf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[127732, 4530, 122, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Function::fdup", "Compile::fdup"}],
Cell[127857, 4536, 445, 14, 21, "Message",
  CellTags->{"Function::fdup", "Compile::fdup"}],
Cell[128305, 4552, 268, 8, 24, "Notes",
  CellTags->{"Function::fdup", "Compile::fdup"}],

Cell[CellGroupData[{
Cell[128598, 4564, 83, 1, 38, "ExampleSection",
  CellTags->{"Function::fdup", "Compile::fdup"}],
Cell[128684, 4567, 159, 4, 24, "Text",
  CellTags->{"Function::fdup", "Compile::fdup"}],

Cell[CellGroupData[{
Cell[128868, 4575, 139, 3, 26, "Input",
  CellTags->{"Function::fdup", "Compile::fdup"}],
Cell[129010, 4580, 205, 4, 21, "Message",
  CellTags->{"Compile::fdup", "Function::fdup"}],
Cell[129218, 4586, 205, 4, 21, "Message",
  CellTags->{"Compile::fdup", "Function::fdup"}],
Cell[129426, 4592, 140, 3, 21, "Output",
  CellTags->{"Compile::fdup", "Function::fdup"}]
}, Open  ]],
Cell[129581, 4598, 154, 5, 24, "Text",
  CellTags->{"Function::fdup", "Compile::fdup"}],

Cell[CellGroupData[{
Cell[129760, 4607, 139, 3, 26, "Input",
  CellTags->{"Function::fdup", "Compile::fdup"}],
Cell[129902, 4612, 108, 3, 21, "Output",
  CellTags->{"Compile::fdup", "Function::fdup"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[130071, 4622, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Function::fdups"],
Cell[130157, 4625, 394, 12, 21, "Message",
  CellTags->"Function::fdups"],
Cell[130554, 4639, 679, 17, 100, "Notes",
  CellTags->"Function::fdups"],

Cell[CellGroupData[{
Cell[131258, 4660, 65, 1, 38, "ExampleSection",
  CellTags->"Function::fdups"],
Cell[131326, 4663, 129, 4, 24, "Text",
  CellTags->"Function::fdups"],

Cell[CellGroupData[{
Cell[131480, 4671, 123, 3, 26, "Input",
  CellTags->"Function::fdups"],
Cell[131606, 4676, 207, 5, 21, "Message",
  CellTags->"Function::fdups"],
Cell[131816, 4683, 207, 5, 21, "Message",
  CellTags->"Function::fdups"],
Cell[132026, 4690, 124, 3, 21, "Output",
  CellTags->"Function::fdups"]
}, Open  ]],
Cell[132165, 4696, 144, 5, 24, "Text",
  CellTags->"Function::fdups"],

Cell[CellGroupData[{
Cell[132334, 4705, 121, 3, 26, "Input",
  CellTags->"Function::fdups"],
Cell[132458, 4710, 90, 3, 21, "Output",
  CellTags->"Function::fdups"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[132609, 4720, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Function::flpar"],
Cell[132695, 4723, 378, 10, 37, "Message",
  CellTags->"Function::flpar"],
Cell[133076, 4735, 518, 12, 62, "Notes",
  CellTags->"Function::flpar"],

Cell[CellGroupData[{
Cell[133619, 4751, 65, 1, 38, "ExampleSection",
  CellTags->"Function::flpar"],
Cell[133687, 4754, 199, 5, 24, "Text",
  CellTags->"Function::flpar"],

Cell[CellGroupData[{
Cell[133911, 4763, 119, 3, 26, "Input",
  CellTags->"Function::flpar"],
Cell[134033, 4768, 283, 6, 37, "Message",
  CellTags->"Function::flpar"],
Cell[134319, 4776, 283, 6, 37, "Message",
  CellTags->"Function::flpar"],
Cell[134605, 4784, 120, 3, 21, "Output",
  CellTags->"Function::flpar"]
}, Open  ]],
Cell[134740, 4790, 146, 5, 24, "Text",
  CellTags->"Function::flpar"],

Cell[CellGroupData[{
Cell[134911, 4799, 115, 3, 26, "Input",
  CellTags->"Function::flpar"],
Cell[135029, 4804, 90, 3, 21, "Output",
  CellTags->"Function::flpar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[135180, 4814, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Remove::rmnsm"],
Cell[135262, 4817, 173, 4, 21, "Message",
  CellTags->"Remove::rmnsm"],
Cell[135438, 4823, 220, 5, 24, "Notes",
  CellTags->"Remove::rmnsm"],

Cell[CellGroupData[{
Cell[135683, 4832, 63, 1, 38, "ExampleSection",
  CellTags->"Remove::rmnsm"],
Cell[135749, 4835, 204, 6, 24, "Text",
  CellTags->"Remove::rmnsm"],

Cell[CellGroupData[{
Cell[135978, 4845, 109, 3, 26, "Input",
  CellTags->"Remove::rmnsm"],
Cell[136090, 4850, 188, 4, 21, "Message",
  CellTags->"Remove::rmnsm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[136339, 4861, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Function::fpct"],
Cell[136423, 4864, 330, 8, 21, "Message",
  CellTags->"Function::fpct"],
Cell[136756, 4874, 242, 6, 40, "Notes",
  CellTags->"Function::fpct"],

Cell[CellGroupData[{
Cell[137023, 4884, 64, 1, 38, "ExampleSection",
  CellTags->"Function::fpct"],
Cell[137090, 4887, 289, 8, 40, "Text",
  CellTags->"Function::fpct"],

Cell[CellGroupData[{
Cell[137404, 4899, 127, 3, 26, "Input",
  CellTags->"Function::fpct"],
Cell[137534, 4904, 280, 6, 37, "Message",
  CellTags->"Function::fpct"],
Cell[137817, 4912, 128, 3, 21, "Output",
  CellTags->"Function::fpct"]
}, Open  ]],
Cell[137960, 4918, 143, 5, 24, "Text",
  CellTags->"Function::fpct"],

Cell[CellGroupData[{
Cell[138128, 4927, 130, 3, 26, "Input",
  CellTags->"Function::fpct"],
Cell[138261, 4932, 90, 3, 21, "Output",
  CellTags->"Function::fpct"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[138412, 4942, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Function::slot"],
Cell[138496, 4945, 444, 13, 21, "Message",
  CellTags->"Function::slot"],
Cell[138943, 4960, 631, 16, 84, "Notes",
  CellTags->"Function::slot"],

Cell[CellGroupData[{
Cell[139599, 4980, 64, 1, 38, "ExampleSection",
  CellTags->"Function::slot"],
Cell[139666, 4983, 153, 4, 24, "Text",
  CellTags->"Function::slot"],

Cell[CellGroupData[{
Cell[139844, 4991, 96, 3, 26, "Input",
  CellTags->"Function::slot"],
Cell[139943, 4996, 219, 5, 21, "Message",
  CellTags->"Function::slot"],
Cell[140165, 5003, 97, 3, 21, "Output",
  CellTags->"Function::slot"]
}, Open  ]],
Cell[140277, 5009, 221, 5, 40, "Text",
  CellTags->"Function::slot"],

Cell[CellGroupData[{
Cell[140523, 5018, 112, 3, 26, "Input",
  CellTags->"Function::slot"],
Cell[140638, 5023, 219, 5, 21, "Message",
  CellTags->"Function::slot"],
Cell[140860, 5030, 219, 5, 21, "Message",
  CellTags->"Function::slot"],
Cell[141082, 5037, 97, 3, 21, "Output",
  CellTags->"Function::slot"]
}, Open  ]],
Cell[141194, 5043, 182, 7, 24, "Text",
  CellTags->"Function::slot"],

Cell[CellGroupData[{
Cell[141401, 5054, 96, 3, 26, "Input",
  CellTags->"Function::slot"],
Cell[141500, 5059, 92, 3, 21, "Output",
  CellTags->"Function::slot"]
}, Open  ]],

Cell[CellGroupData[{
Cell[141629, 5067, 122, 3, 26, "Input",
  CellTags->"Function::slot"],
Cell[141754, 5072, 92, 3, 21, "Output",
  CellTags->"Function::slot"]
}, Open  ]],

Cell[CellGroupData[{
Cell[141883, 5080, 111, 3, 26, "Input",
  CellTags->"Function::slot"],
Cell[141997, 5085, 92, 3, 21, "Output",
  CellTags->"Function::slot"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[142150, 5095, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Function::slotn"],
Cell[142236, 5098, 412, 12, 21, "Message",
  CellTags->"Function::slotn"],
Cell[142651, 5112, 575, 19, 46, "Notes",
  CellTags->"Function::slotn"],

Cell[CellGroupData[{
Cell[143251, 5135, 65, 1, 38, "ExampleSection",
  CellTags->"Function::slotn"],
Cell[143319, 5138, 282, 7, 40, "Text",
  CellTags->"Function::slotn"],

Cell[CellGroupData[{
Cell[143626, 5149, 115, 3, 26, "Input",
  CellTags->"Function::slotn"],
Cell[143744, 5154, 250, 5, 21, "Message",
  CellTags->"Function::slotn"],
Cell[143997, 5161, 95, 3, 21, "Output",
  CellTags->"Function::slotn"]
}, Open  ]],
Cell[144107, 5167, 191, 7, 24, "Text",
  CellTags->"Function::slotn"],

Cell[CellGroupData[{
Cell[144323, 5178, 118, 3, 26, "Input",
  CellTags->"Function::slotn"],
Cell[144444, 5183, 91, 3, 21, "Output",
  CellTags->"Function::slotn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[144596, 5193, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Function::slotp"],
Cell[144682, 5196, 322, 7, 21, "Message",
  CellTags->"Function::slotp"],
Cell[145007, 5205, 895, 26, 84, "Notes",
  CellTags->"Function::slotp"],

Cell[CellGroupData[{
Cell[145927, 5235, 65, 1, 38, "ExampleSection",
  CellTags->"Function::slotp"],
Cell[145995, 5238, 178, 5, 24, "Text",
  CellTags->"Function::slotp"],

Cell[CellGroupData[{
Cell[146198, 5247, 118, 3, 26, "Input",
  CellTags->"Function::slotp"],
Cell[146319, 5252, 255, 6, 37, "Message",
  CellTags->"Function::slotp"],
Cell[146577, 5260, 114, 3, 21, "Output",
  CellTags->"Function::slotp"]
}, Open  ]],
Cell[146706, 5266, 230, 5, 40, "Text",
  CellTags->"Function::slotp"],

Cell[CellGroupData[{
Cell[146961, 5275, 128, 3, 26, "Input",
  CellTags->"Function::slotp"],
Cell[147092, 5280, 255, 6, 37, "Message",
  CellTags->"Function::slotp"],
Cell[147350, 5288, 255, 6, 37, "Message",
  CellTags->"Function::slotp"],
Cell[147608, 5296, 114, 3, 21, "Output",
  CellTags->"Function::slotp"]
}, Open  ]],
Cell[147737, 5302, 191, 7, 24, "Text",
  CellTags->"Function::slotp"],

Cell[CellGroupData[{
Cell[147953, 5313, 113, 3, 26, "Input",
  CellTags->"Function::slotp"],
Cell[148069, 5318, 102, 3, 21, "Output",
  CellTags->"Function::slotp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[148208, 5326, 139, 3, 26, "Input",
  CellTags->"Function::slotp"],
Cell[148350, 5331, 102, 3, 21, "Output",
  CellTags->"Function::slotp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[148489, 5339, 128, 3, 26, "Input",
  CellTags->"Function::slotp"],
Cell[148620, 5344, 102, 3, 21, "Output",
  CellTags->"Function::slotp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[148783, 5354, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Function::slots"],
Cell[148869, 5357, 375, 10, 21, "Message",
  CellTags->"Function::slots"],
Cell[149247, 5369, 597, 20, 62, "Notes",
  CellTags->"Function::slots"],

Cell[CellGroupData[{
Cell[149869, 5393, 65, 1, 38, "ExampleSection",
  CellTags->"Function::slots"],
Cell[149937, 5396, 358, 10, 40, "Text",
  CellTags->"Function::slots"],

Cell[CellGroupData[{
Cell[150320, 5410, 113, 3, 26, "Input",
  CellTags->"Function::slots"],
Cell[150436, 5415, 278, 6, 37, "Message",
  CellTags->"Function::slots"],
Cell[150717, 5423, 99, 3, 21, "Output",
  CellTags->"Function::slots"]
}, Open  ]],
Cell[150831, 5429, 147, 5, 24, "Text",
  CellTags->"Function::slots"],

Cell[CellGroupData[{
Cell[151003, 5438, 122, 3, 26, "Input",
  CellTags->"Function::slots"],
Cell[151128, 5443, 100, 3, 21, "Output",
  CellTags->"Function::slots"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[151289, 5453, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Goto::nolabel"],
Cell[151371, 5456, 205, 4, 21, "Message",
  CellTags->"Goto::nolabel"],
Cell[151579, 5462, 217, 7, 24, "Notes",
  CellTags->"Goto::nolabel"],

Cell[CellGroupData[{
Cell[151821, 5473, 63, 1, 38, "ExampleSection",
  CellTags->"Goto::nolabel"],
Cell[151887, 5476, 233, 7, 24, "Text",
  CellTags->"Goto::nolabel"],

Cell[CellGroupData[{
Cell[152145, 5487, 229, 5, 122, "Input",
  CellTags->"Goto::nolabel"],
Cell[152377, 5494, 189, 5, 21, "Print",
  CellTags->"Goto::nolabel"],
Cell[152569, 5501, 164, 4, 21, "Message",
  CellTags->"Goto::nolabel"],
Cell[152736, 5507, 104, 3, 21, "Output",
  CellTags->"Goto::nolabel"]
}, Open  ]],
Cell[152855, 5513, 158, 7, 24, "Text",
  CellTags->"Goto::nolabel"],

Cell[CellGroupData[{
Cell[153038, 5524, 229, 5, 122, "Input",
  CellTags->"Goto::nolabel"],
Cell[153270, 5531, 189, 5, 21, "Print",
  CellTags->"Goto::nolabel"],
Cell[153462, 5538, 189, 5, 21, "Print",
  CellTags->"Goto::nolabel"],
Cell[153654, 5545, 189, 5, 21, "Print",
  CellTags->"Goto::nolabel"],
Cell[153846, 5552, 93, 3, 21, "Output",
  CellTags->"Goto::nolabel"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[154000, 5562, 136, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
Cell[154139, 5568, 277, 7, 21, "Message",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
Cell[154419, 5577, 494, 9, 84, "Notes",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[CellGroupData[{
Cell[154938, 5590, 90, 1, 38, "ExampleSection",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
Cell[155031, 5593, 300, 8, 40, "Text",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],

Cell[CellGroupData[{
Cell[155356, 5605, 149, 3, 26, "Input",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
Cell[155508, 5610, 119, 3, 21, "Print",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
Cell[155630, 5615, 119, 3, 21, "Print",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
Cell[155752, 5620, 204, 4, 21, "Message",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
Cell[155959, 5626, 137, 4, 21, "Output",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
Cell[156099, 5632, 174, 3, 21, "Message",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
Cell[156276, 5637, 119, 3, 21, "Print",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
Cell[156398, 5642, 119, 3, 21, "Print",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}],
Cell[156520, 5647, 119, 3, 21, "Print",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}]
}, Open  ]],
Cell[156654, 5653, 134, 3, 26, "Input",
  CellTags->{"Interrupt::dgbgn", "TraceDialog::dgbgn"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[156837, 5662, 136, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
Cell[156976, 5668, 319, 10, 21, "Message",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
Cell[157298, 5680, 510, 9, 100, "Notes",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[CellGroupData[{
Cell[157833, 5693, 90, 1, 38, "ExampleSection",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
Cell[157926, 5696, 300, 8, 40, "Text",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],

Cell[CellGroupData[{
Cell[158251, 5708, 149, 3, 26, "Input",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
Cell[158403, 5713, 119, 3, 21, "Print",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
Cell[158525, 5718, 119, 3, 21, "Print",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
Cell[158647, 5723, 204, 4, 21, "Message",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
Cell[158854, 5729, 137, 4, 21, "Output",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
Cell[158994, 5735, 174, 3, 21, "Message",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
Cell[159171, 5740, 119, 3, 21, "Print",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
Cell[159293, 5745, 119, 3, 21, "Print",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}],
Cell[159415, 5750, 119, 3, 21, "Print",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}]
}, Open  ]],
Cell[159549, 5756, 134, 3, 26, "Input",
  CellTags->{"Interrupt::dgend", "TraceDialog::dgend"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[159732, 5765, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkConnect::linkc"],
Cell[159824, 5768, 231, 5, 21, "Message",
  CellTags->"LinkConnect::linkc"],
Cell[160058, 5775, 210, 6, 24, "Notes",
  CellTags->"LinkConnect::linkc"]
}, Open  ]],

Cell[CellGroupData[{
Cell[160305, 5786, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkObject::linkd"],
Cell[160395, 5789, 228, 5, 21, "Message",
  CellTags->"LinkObject::linkd"],
Cell[160626, 5796, 209, 6, 24, "Notes",
  CellTags->"LinkObject::linkd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[160872, 5807, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkOpen::linke"],
Cell[160958, 5810, 258, 7, 21, "Message",
  CellTags->"LinkOpen::linke"],
Cell[161219, 5819, 683, 17, 100, "Notes",
  CellTags->"LinkOpen::linke"],

Cell[CellGroupData[{
Cell[161927, 5840, 65, 1, 38, "ExampleSection",
  CellTags->"LinkOpen::linke"],
Cell[161995, 5843, 302, 8, 40, "Text",
  CellTags->"LinkOpen::linke"],

Cell[CellGroupData[{
Cell[162322, 5855, 164, 4, 26, "Input",
  CellTags->"LinkOpen::linke"],
Cell[162489, 5861, 180, 4, 21, "Message",
  CellTags->"LinkOpen::linke"],
Cell[162672, 5867, 96, 3, 21, "Output",
  CellTags->"LinkOpen::linke"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[162829, 5877, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkRead::linkep"],
Cell[162917, 5880, 167, 3, 21, "Message",
  CellTags->"LinkRead::linkep"],
Cell[163087, 5885, 175, 6, 24, "Notes",
  CellTags->"LinkRead::linkep"]
}, Open  ]],

Cell[CellGroupData[{
Cell[163299, 5896, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkObject::linkn"],
Cell[163389, 5899, 374, 9, 37, "Message",
  CellTags->"LinkObject::linkn"],
Cell[163766, 5910, 280, 7, 40, "Notes",
  CellTags->"LinkObject::linkn"]
}, Open  ]],

Cell[CellGroupData[{
Cell[164083, 5922, 179, 5, 71, "ObjectNameWarningMessages",
  CellTags->{
  "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
Cell[164265, 5929, 469, 12, 21, "Message",
  CellTags->{
  "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
Cell[164737, 5943, 504, 12, 62, "Notes",
  CellTags->{
  "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],

Cell[CellGroupData[{
Cell[165266, 5959, 113, 1, 38, "ExampleSection",
  CellTags->{
  "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
Cell[165382, 5962, 237, 5, 24, "Text",
  CellTags->{
  "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],

Cell[CellGroupData[{
Cell[165644, 5971, 167, 3, 26, "Input",
  CellTags->{
  "LinkObject::linkv", "LinkWrite::linkv", "LinkWriteHeld::linkv"}],
Cell[165814, 5976, 261, 5, 21, "Message",
  CellTags->{
  "LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}],
Cell[166078, 5983, 297, 5, 37, "Message",
  CellTags->{
  "LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}],
Cell[166378, 5990, 164, 3, 21, "Output",
  CellTags->{
  "LinkObject::linkv", "LinkWriteHeld::linkv", "LinkWrite::linkv"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[166603, 6000, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkObject::linkw"],
Cell[166693, 6003, 229, 5, 21, "Message",
  CellTags->"LinkObject::linkw"],
Cell[166925, 6010, 211, 6, 24, "Notes",
  CellTags->"LinkObject::linkw"]
}, Open  ]],

Cell[CellGroupData[{
Cell[167173, 6021, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkObject::linkx"],
Cell[167263, 6024, 337, 9, 21, "Message",
  CellTags->"LinkObject::linkx"],
Cell[167603, 6035, 209, 6, 24, "Notes",
  CellTags->"LinkObject::linkx"]
}, Open  ]],

Cell[CellGroupData[{
Cell[167849, 6046, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkOpen::linkh"],
Cell[167935, 6049, 262, 6, 21, "Message",
  CellTags->"LinkOpen::linkh"],
Cell[168200, 6057, 194, 5, 24, "Notes",
  CellTags->"LinkOpen::linkh"]
}, Open  ]],

Cell[CellGroupData[{
Cell[168431, 6067, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkOpen::linki"],
Cell[168517, 6070, 156, 3, 21, "Message",
  CellTags->"LinkOpen::linki"],
Cell[168676, 6075, 199, 6, 24, "Notes",
  CellTags->"LinkOpen::linki"]
}, Open  ]],

Cell[CellGroupData[{
Cell[168912, 6086, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkOpen::linkm"],
Cell[168998, 6089, 306, 6, 37, "Message",
  CellTags->"LinkOpen::linkm"],
Cell[169307, 6097, 194, 5, 24, "Notes",
  CellTags->"LinkOpen::linkm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[169538, 6107, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkOpen::linknm"],
Cell[169626, 6110, 203, 4, 21, "Message",
  CellTags->"LinkOpen::linknm"],
Cell[169832, 6116, 240, 7, 24, "Notes",
  CellTags->"LinkOpen::linknm"],

Cell[CellGroupData[{
Cell[170097, 6127, 66, 1, 38, "ExampleSection",
  CellTags->"LinkOpen::linknm"],
Cell[170166, 6130, 148, 4, 24, "Text",
  CellTags->"LinkOpen::linknm"],

Cell[CellGroupData[{
Cell[170339, 6138, 99, 3, 26, "Input",
  CellTags->"LinkOpen::linknm"],
Cell[170441, 6143, 210, 5, 37, "Message",
  CellTags->"LinkOpen::linknm"],
Cell[170654, 6150, 100, 3, 21, "Output",
  CellTags->"LinkOpen::linknm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[170815, 6160, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkOpen::linkpl"],
Cell[170903, 6163, 378, 9, 21, "Message",
  CellTags->"LinkOpen::linkpl"],
Cell[171284, 6174, 438, 12, 62, "Notes",
  CellTags->"LinkOpen::linkpl"],

Cell[CellGroupData[{
Cell[171747, 6190, 66, 1, 38, "ExampleSection",
  CellTags->"LinkOpen::linkpl"],
Cell[171816, 6193, 357, 11, 40, "Text",
  CellTags->"LinkOpen::linkpl"],

Cell[CellGroupData[{
Cell[172198, 6208, 119, 3, 26, "Input",
  CellTags->"LinkOpen::linkpl"],
Cell[172320, 6213, 398, 7, 37, "Message",
  CellTags->"LinkOpen::linkpl"],
Cell[172721, 6222, 125, 3, 21, "Output",
  CellTags->"LinkOpen::linkpl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[172907, 6232, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkOpen::links"],
Cell[172993, 6235, 141, 3, 21, "Message",
  CellTags->"LinkOpen::links"],
Cell[173137, 6240, 302, 9, 40, "Notes",
  CellTags->"LinkOpen::links"]
}, Open  ]],

Cell[CellGroupData[{
Cell[173476, 6254, 95, 1, 31, "ObjectNameWarningMessages",
  CellTags->"LinkWriteHeld::linkhl"],
Cell[173574, 6257, 341, 9, 21, "Message",
  CellTags->"LinkWriteHeld::linkhl"],
Cell[173918, 6268, 277, 9, 24, "Notes",
  CellTags->"LinkWriteHeld::linkhl"],

Cell[CellGroupData[{
Cell[174220, 6281, 71, 1, 38, "ExampleSection",
  CellTags->"LinkWriteHeld::linkhl"],
Cell[174294, 6284, 188, 6, 24, "Text",
  CellTags->"LinkWriteHeld::linkhl"],

Cell[CellGroupData[{
Cell[174507, 6294, 113, 3, 26, "Input",
  CellTags->"LinkWriteHeld::linkhl"],
Cell[174623, 6299, 231, 5, 37, "Message",
  CellTags->"LinkWriteHeld::linkhl"],
Cell[174857, 6306, 114, 3, 21, "Output",
  CellTags->"LinkWriteHeld::linkhl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[175032, 6316, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"MapThread::mptc"],
Cell[175118, 6319, 786, 23, 37, "Message",
  CellTags->"MapThread::mptc"],
Cell[175907, 6344, 213, 5, 24, "Notes",
  CellTags->"MapThread::mptc"],

Cell[CellGroupData[{
Cell[176145, 6353, 65, 1, 38, "ExampleSection",
  CellTags->"MapThread::mptc"],
Cell[176213, 6356, 156, 4, 24, "Text",
  CellTags->"MapThread::mptc"],

Cell[CellGroupData[{
Cell[176394, 6364, 131, 3, 26, "Input",
  CellTags->"MapThread::mptc"],
Cell[176528, 6369, 343, 6, 53, "Message",
  CellTags->"MapThread::mptc"],
Cell[176874, 6377, 130, 3, 21, "Output",
  CellTags->"MapThread::mptc"]
}, Open  ]],
Cell[177019, 6383, 131, 5, 24, "Text",
  CellTags->"MapThread::mptc"],

Cell[CellGroupData[{
Cell[177175, 6392, 135, 3, 26, "Input",
  CellTags->"MapThread::mptc"],
Cell[177313, 6397, 137, 3, 21, "Output",
  CellTags->"MapThread::mptc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[177511, 6407, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"MapThread::mptd"],
Cell[177597, 6410, 573, 16, 37, "Message",
  CellTags->"MapThread::mptd"],
Cell[178173, 6428, 267, 6, 40, "Notes",
  CellTags->"MapThread::mptd"],

Cell[CellGroupData[{
Cell[178465, 6438, 65, 1, 38, "ExampleSection",
  CellTags->"MapThread::mptd"],
Cell[178533, 6441, 253, 7, 40, "Text",
  CellTags->"MapThread::mptd"],

Cell[CellGroupData[{
Cell[178811, 6452, 164, 4, 26, "Input",
  CellTags->"MapThread::mptd"],
Cell[178978, 6458, 360, 7, 53, "Message",
  CellTags->"MapThread::mptd"],
Cell[179341, 6467, 150, 4, 21, "Output",
  CellTags->"MapThread::mptd"]
}, Open  ]],
Cell[179506, 6474, 131, 5, 24, "Text",
  CellTags->"MapThread::mptd"],

Cell[CellGroupData[{
Cell[179662, 6483, 166, 4, 26, "Input",
  CellTags->"MapThread::mptd"],
Cell[179831, 6489, 166, 4, 21, "Output",
  CellTags->"MapThread::mptd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[180058, 6500, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Options::opmix"],
Cell[180142, 6503, 226, 5, 21, "Message",
  CellTags->"Options::opmix"],
Cell[180371, 6510, 630, 18, 78, "Notes",
  CellTags->"Options::opmix"],

Cell[CellGroupData[{
Cell[181026, 6532, 64, 1, 38, "ExampleSection",
  CellTags->"Options::opmix"],
Cell[181093, 6535, 196, 5, 24, "Text",
  CellTags->"Options::opmix"],

Cell[CellGroupData[{
Cell[181314, 6544, 128, 3, 26, "Input",
  CellTags->"Options::opmix"],
Cell[181445, 6549, 236, 5, 37, "Message",
  CellTags->"Options::opmix"],
Cell[181684, 6556, 132, 3, 21, "Output",
  CellTags->"Options::opmix"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[181877, 6566, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Options::opsym"],
Cell[181961, 6569, 279, 6, 21, "Message",
  CellTags->"Options::opsym"],
Cell[182243, 6577, 190, 5, 24, "Notes",
  CellTags->"Options::opsym"],

Cell[CellGroupData[{
Cell[182458, 6586, 64, 1, 38, "ExampleSection",
  CellTags->"Options::opsym"],
Cell[182525, 6589, 178, 5, 24, "Text",
  CellTags->"Options::opsym"],

Cell[CellGroupData[{
Cell[182728, 6598, 118, 3, 26, "Input",
  CellTags->"Options::opsym"],
Cell[182849, 6603, 254, 5, 37, "Message",
  CellTags->"Options::opsym"],
Cell[183106, 6610, 122, 3, 21, "Output",
  CellTags->"Options::opsym"]
}, Open  ]],
Cell[183243, 6616, 148, 5, 24, "Text",
  CellTags->"Options::opsym"],

Cell[CellGroupData[{
Cell[183416, 6625, 113, 3, 26, "Input",
  CellTags->"Options::opsym"],
Cell[183532, 6630, 107, 3, 21, "Output",
  CellTags->"Options::opsym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[183700, 6640, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Pattern::nodef"],
Cell[183784, 6643, 458, 12, 21, "Message",
  CellTags->"Pattern::nodef"],
Cell[184245, 6657, 570, 17, 68, "Notes",
  CellTags->"Pattern::nodef"],

Cell[CellGroupData[{
Cell[184840, 6678, 64, 1, 38, "ExampleSection",
  CellTags->"Pattern::nodef"],
Cell[184907, 6681, 241, 7, 40, "Text",
  CellTags->"Pattern::nodef"],

Cell[CellGroupData[{
Cell[185173, 6692, 121, 3, 26, "Input",
  CellTags->"Pattern::nodef"],
Cell[185297, 6697, 221, 5, 37, "Message",
  CellTags->"Pattern::nodef"],
Cell[185521, 6704, 221, 5, 37, "Message",
  CellTags->"Pattern::nodef"],
Cell[185745, 6711, 94, 3, 21, "Output",
  CellTags->"Pattern::nodef"]
}, Open  ]],
Cell[185854, 6717, 240, 7, 40, "Text",
  CellTags->"Pattern::nodef"],

Cell[CellGroupData[{
Cell[186119, 6728, 107, 3, 26, "Input",
  CellTags->"Pattern::nodef"],
Cell[186229, 6733, 89, 3, 21, "Output",
  CellTags->"Pattern::nodef"]
}, Open  ]],

Cell[CellGroupData[{
Cell[186355, 6741, 121, 3, 26, "Input",
  CellTags->"Pattern::nodef"],
Cell[186479, 6746, 94, 3, 21, "Output",
  CellTags->"Pattern::nodef"]
}, Open  ]],
Cell[186588, 6752, 135, 5, 24, "Text",
  CellTags->"Pattern::nodef"],
Cell[186726, 6759, 107, 3, 26, "Input",
  CellTags->"Pattern::nodef"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[186882, 6768, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Pattern::patm"],
Cell[186964, 6771, 390, 11, 21, "Message",
  CellTags->"Pattern::patm"],
Cell[187357, 6784, 578, 18, 68, "Notes",
  CellTags->"Pattern::patm"],

Cell[CellGroupData[{
Cell[187960, 6806, 63, 1, 38, "ExampleSection",
  CellTags->"Pattern::patm"],
Cell[188026, 6809, 261, 8, 40, "Text",
  CellTags->"Pattern::patm"],

Cell[CellGroupData[{
Cell[188312, 6821, 255, 5, 42, "Input",
  CellTags->"Pattern::patm"],
Cell[188570, 6828, 365, 7, 37, "Message",
  CellTags->"Pattern::patm"],
Cell[188938, 6837, 365, 7, 37, "Message",
  CellTags->"Pattern::patm"],
Cell[189306, 6846, 89, 3, 21, "Output",
  CellTags->"Pattern::patm"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[189456, 6856, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Pattern::patsym"],
Cell[189542, 6859, 265, 5, 21, "Message",
  CellTags->"Pattern::patsym"],
Cell[189810, 6866, 195, 6, 24, "Notes",
  CellTags->"Pattern::patsym"]
}, Open  ]],

Cell[CellGroupData[{
Cell[190042, 6877, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Pattern::patv"],
Cell[190124, 6880, 251, 5, 21, "Message",
  CellTags->"Pattern::patv"],
Cell[190378, 6887, 385, 9, 46, "Notes",
  CellTags->"Pattern::patv"],

Cell[CellGroupData[{
Cell[190788, 6900, 63, 1, 38, "ExampleSection",
  CellTags->"Pattern::patv"],
Cell[190854, 6903, 195, 5, 40, "Text",
  CellTags->"Pattern::patv"],

Cell[CellGroupData[{
Cell[191074, 6912, 128, 3, 26, "Input",
  CellTags->"Pattern::patv"],
Cell[191205, 6917, 198, 5, 21, "Message",
  CellTags->"Pattern::patv"],
Cell[191406, 6924, 102, 3, 21, "Output",
  CellTags->"Pattern::patv"]
}, Open  ]],
Cell[191523, 6930, 154, 4, 24, "Text",
  CellTags->"Pattern::patv"],

Cell[CellGroupData[{
Cell[191702, 6938, 128, 3, 26, "Input",
  CellTags->"Pattern::patv"],
Cell[191833, 6943, 106, 3, 21, "Output",
  CellTags->"Pattern::patv"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[192000, 6953, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"PatternTest::ptest"],
Cell[192092, 6956, 239, 5, 21, "Message",
  CellTags->"PatternTest::ptest"],
Cell[192334, 6963, 674, 20, 68, "Notes",
  CellTags->"PatternTest::ptest"]
}, Open  ]],

Cell[CellGroupData[{
Cell[193045, 6988, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Protect::pssl"],
Cell[193127, 6991, 248, 5, 21, "Message",
  CellTags->"Protect::pssl"],
Cell[193378, 6998, 182, 5, 24, "Notes",
  CellTags->"Protect::pssl"],

Cell[CellGroupData[{
Cell[193585, 7007, 63, 1, 38, "ExampleSection",
  CellTags->"Protect::pssl"],
Cell[193651, 7010, 120, 4, 24, "Text",
  CellTags->"Protect::pssl"],

Cell[CellGroupData[{
Cell[193796, 7018, 96, 3, 26, "Input",
  CellTags->"Protect::pssl"],
Cell[193895, 7023, 200, 5, 21, "Message",
  CellTags->"Protect::pssl"],
Cell[194098, 7030, 97, 3, 21, "Output",
  CellTags->"Protect::pssl"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[194256, 7040, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Remove::relex"],
Cell[194338, 7043, 360, 7, 37, "Message",
  CellTags->"Remove::relex"],
Cell[194701, 7052, 194, 5, 24, "Notes",
  CellTags->"Remove::relex"],

Cell[CellGroupData[{
Cell[194920, 7061, 63, 1, 38, "ExampleSection",
  CellTags->"Remove::relex"],
Cell[194986, 7064, 205, 5, 40, "Text",
  CellTags->"Remove::relex"],

Cell[CellGroupData[{
Cell[195216, 7073, 139, 3, 26, "Input",
  CellTags->"Remove::relex"],
Cell[195358, 7078, 221, 5, 37, "Message",
  CellTags->"Remove::relex"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[195640, 7090, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Remove::remal"],
Cell[195722, 7093, 212, 4, 21, "Message",
  CellTags->"Remove::remal"],
Cell[195937, 7099, 178, 5, 24, "Notes",
  CellTags->"Remove::remal"],

Cell[CellGroupData[{
Cell[196140, 7108, 63, 1, 38, "ExampleSection",
  CellTags->"Remove::remal"],
Cell[196206, 7111, 174, 5, 24, "Text",
  CellTags->"Remove::remal"],

Cell[CellGroupData[{
Cell[196405, 7120, 118, 3, 26, "Input",
  CellTags->"Remove::remal"],
Cell[196526, 7125, 255, 5, 21, "Message",
  CellTags->"Remove::remal"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[196842, 7137, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Remove::rmlck"],
Cell[196924, 7140, 234, 5, 21, "Message",
  CellTags->"Remove::rmlck"],
Cell[197161, 7147, 214, 7, 24, "Notes",
  CellTags->"Remove::rmlck"],

Cell[CellGroupData[{
Cell[197400, 7158, 63, 1, 38, "ExampleSection",
  CellTags->"Remove::rmlck"],
Cell[197466, 7161, 198, 7, 24, "Text",
  CellTags->"Remove::rmlck"],

Cell[CellGroupData[{
Cell[197689, 7172, 98, 3, 26, "Input",
  CellTags->"Remove::rmlck"],
Cell[197790, 7177, 184, 4, 21, "Message",
  CellTags->"Remove::rmlck"]
}, Open  ]],

Cell[CellGroupData[{
Cell[198011, 7186, 102, 3, 26, "Input",
  CellTags->"Remove::rmlck"],
Cell[198116, 7191, 106, 3, 21, "Output",
  CellTags->"Remove::rmlck"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[198283, 7201, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Remove::rmptc"],
Cell[198365, 7204, 237, 5, 21, "Message",
  CellTags->"Remove::rmptc"],
Cell[198605, 7211, 213, 7, 24, "Notes",
  CellTags->"Remove::rmptc"],

Cell[CellGroupData[{
Cell[198843, 7222, 63, 1, 38, "ExampleSection",
  CellTags->"Remove::rmptc"],
Cell[198909, 7225, 180, 5, 24, "Text",
  CellTags->"Remove::rmptc"],

Cell[CellGroupData[{
Cell[199114, 7234, 119, 3, 26, "Input",
  CellTags->"Remove::rmptc"],
Cell[199236, 7239, 192, 5, 21, "Message",
  CellTags->"Remove::rmptc"]
}, Open  ]],

Cell[CellGroupData[{
Cell[199465, 7249, 105, 3, 26, "Input",
  CellTags->"Remove::rmptc"],
Cell[199573, 7254, 98, 3, 21, "Output",
  CellTags->"Remove::rmptc"]
}, Open  ]],
Cell[199686, 7260, 201, 6, 24, "Text",
  CellTags->"Remove::rmptc"],
Cell[199890, 7268, 121, 3, 26, "Input",
  CellTags->"Remove::rmptc"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[200060, 7277, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Remove::ssym"],
Cell[200140, 7280, 190, 4, 21, "Message",
  CellTags->"Remove::ssym"],
Cell[200333, 7286, 291, 7, 46, "Notes",
  CellTags->"Remove::ssym"],

Cell[CellGroupData[{
Cell[200649, 7297, 62, 1, 38, "ExampleSection",
  CellTags->"Remove::ssym"],
Cell[200714, 7300, 163, 5, 24, "Text",
  CellTags->"Remove::ssym"],

Cell[CellGroupData[{
Cell[200902, 7309, 94, 3, 26, "Input",
  CellTags->"Remove::ssym"],
Cell[200999, 7314, 151, 4, 21, "Message",
  CellTags->"Remove::ssym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[201211, 7325, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::rep"],
Cell[201291, 7328, 374, 11, 21, "Message",
  CellTags->"General::rep"],
Cell[201668, 7341, 287, 8, 46, "Notes",
  CellTags->"General::rep"],

Cell[CellGroupData[{
Cell[201980, 7353, 62, 1, 38, "ExampleSection",
  CellTags->"General::rep"],
Cell[202045, 7356, 152, 5, 24, "Text",
  CellTags->"General::rep"],

Cell[CellGroupData[{
Cell[202222, 7365, 116, 3, 26, "Input",
  CellTags->"General::rep"],
Cell[202341, 7370, 103, 3, 21, "Output",
  CellTags->"General::rep"]
}, Open  ]],

Cell[CellGroupData[{
Cell[202481, 7378, 115, 3, 26, "Input",
  CellTags->"General::rep"],
Cell[202599, 7383, 183, 4, 21, "Message",
  CellTags->"General::rep"],
Cell[202785, 7389, 116, 3, 21, "Output",
  CellTags->"General::rep"]
}, Open  ]],
Cell[202916, 7395, 129, 5, 24, "Text",
  CellTags->"General::rep"],

Cell[CellGroupData[{
Cell[203070, 7404, 126, 3, 26, "Input",
  CellTags->"General::rep"],
Cell[203199, 7409, 113, 3, 21, "Output",
  CellTags->"General::rep"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[203373, 7419, 220, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],
Cell[203596, 7429, 530, 15, 21, "Message",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],
Cell[204129, 7446, 305, 7, 40, "Notes",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],

Cell[CellGroupData[{
Cell[204459, 7457, 139, 3, 38, "ExampleSection",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],
Cell[204601, 7462, 207, 6, 24, "Text",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],

Cell[CellGroupData[{
Cell[204833, 7472, 193, 5, 26, "Input",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],
Cell[205029, 7479, 315, 7, 37, "Message",
  CellTags->{
  "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
    "Replace::rmix"}],
Cell[205347, 7488, 223, 6, 21, "Output",
  CellTags->{
  "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
    "Replace::rmix"}]
}, Open  ]],
Cell[205585, 7497, 206, 7, 24, "Text",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],

Cell[CellGroupData[{
Cell[205816, 7508, 195, 5, 26, "Input",
  CellTags->{
  "Replace::rmix", "ReplaceAll::rmix", "ReplaceRepeated::rmix", 
    "ReplaceList::rmix"}],
Cell[206014, 7515, 185, 5, 21, "Output",
  CellTags->{
  "ReplaceAll::rmix", "ReplaceList::rmix", "ReplaceRepeated::rmix", 
    "Replace::rmix"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[206260, 7527, 382, 14, 191, "ObjectNameWarningMessages",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],
Cell[206645, 7543, 665, 17, 21, "Message",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],
Cell[207313, 7562, 322, 7, 24, "Notes",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],

Cell[CellGroupData[{
Cell[207660, 7573, 230, 4, 38, "ExampleSection",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],
Cell[207893, 7579, 340, 8, 24, "Text",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],

Cell[CellGroupData[{
Cell[208258, 7591, 288, 6, 26, "Input",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],
Cell[208549, 7599, 456, 9, 37, "Message",
  CellTags->{
  "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
    "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
    "StringInsert::psl", "StringReplacePart::psl"}],
Cell[209008, 7610, 290, 6, 21, "Output",
  CellTags->{
  "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
    "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
    "StringInsert::psl", "StringReplacePart::psl"}]
}, Open  ]],
Cell[209313, 7619, 307, 8, 24, "Text",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],

Cell[CellGroupData[{
Cell[209645, 7631, 284, 6, 26, "Input",
  CellTags->{
  "ReplacePart::psl", "ReplaceHeldPart::psl", "MapAt::psl", "Delete::psl", 
    "FlattenAt::psl", "Insert::psl", "StringInsert::psl", 
    "StringReplacePart::psl", "Extract::psl"}],
Cell[209932, 7639, 267, 6, 21, "Output",
  CellTags->{
  "Delete::psl", "Extract::psl", "FlattenAt::psl", "Insert::psl", 
    "MapAt::psl", "ReplaceHeldPart::psl", "ReplacePart::psl", 
    "StringInsert::psl", "StringReplacePart::psl"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[210260, 7652, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ReplaceRepeated::rrlim"],
Cell[210360, 7655, 337, 9, 21, "Message",
  CellTags->"ReplaceRepeated::rrlim"],
Cell[210700, 7666, 249, 6, 40, "Notes",
  CellTags->"ReplaceRepeated::rrlim"],

Cell[CellGroupData[{
Cell[210974, 7676, 72, 1, 38, "ExampleSection",
  CellTags->"ReplaceRepeated::rrlim"],
Cell[211049, 7679, 157, 4, 24, "Text",
  CellTags->"ReplaceRepeated::rrlim"],

Cell[CellGroupData[{
Cell[211231, 7687, 112, 3, 26, "Input",
  CellTags->"ReplaceRepeated::rrlim"],
Cell[211346, 7692, 200, 4, 21, "Message",
  CellTags->"ReplaceRepeated::rrlim"],
Cell[211549, 7698, 101, 3, 21, "Output",
  CellTags->"ReplaceRepeated::rrlim"]
}, Open  ]],
Cell[211665, 7704, 206, 6, 24, "Text",
  CellTags->"ReplaceRepeated::rrlim"],

Cell[CellGroupData[{
Cell[211896, 7714, 119, 3, 26, "Input",
  CellTags->"ReplaceRepeated::rrlim"],
Cell[212018, 7719, 125, 3, 21, "Output",
  CellTags->"ReplaceRepeated::rrlim"]
}, Open  ]],
Cell[212158, 7725, 113, 1, 24, "Text",
  CellTags->"ReplaceRepeated::rrlim"],

Cell[CellGroupData[{
Cell[212296, 7730, 124, 3, 26, "Input",
  CellTags->"ReplaceRepeated::rrlim"],
Cell[212423, 7735, 100, 3, 21, "Output",
  CellTags->"ReplaceRepeated::rrlim"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[212584, 7745, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Return::nofsdd"],
Cell[212668, 7748, 268, 6, 21, "Message",
  CellTags->"Return::nofsdd"],
Cell[212939, 7756, 341, 9, 46, "Notes",
  CellTags->"Return::nofsdd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[213317, 7770, 118, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
Cell[213438, 7776, 515, 14, 21, "Message",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
Cell[213956, 7792, 604, 12, 90, "Notes",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],

Cell[CellGroupData[{
Cell[214585, 7808, 81, 1, 38, "ExampleSection",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
Cell[214669, 7811, 238, 5, 40, "Text",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],

Cell[CellGroupData[{
Cell[214932, 7820, 142, 3, 26, "Input",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
Cell[215077, 7825, 259, 5, 37, "Message",
  CellTags->{"RuleDelayed::rhs", "Rule::rhs"}],
Cell[215339, 7832, 207, 4, 37, "Output",
  CellTags->{"RuleDelayed::rhs", "Rule::rhs"}]
}, Open  ]],
Cell[215561, 7839, 116, 1, 24, "Text",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],

Cell[CellGroupData[{
Cell[215702, 7844, 141, 3, 26, "Input",
  CellTags->{"Rule::rhs", "RuleDelayed::rhs"}],
Cell[215846, 7849, 120, 3, 21, "Output",
  CellTags->{"RuleDelayed::rhs", "Rule::rhs"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[216027, 7859, 331, 13, 171, "ObjectNameWarningMessages",
  CellTags->{
  "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
    "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
    "UpSetDelayed::lhsr"}],
Cell[216361, 7874, 658, 18, 37, "Message",
  CellTags->{
  "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
    "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
    "UpSetDelayed::lhsr"}],
Cell[217022, 7894, 333, 9, 24, "Notes",
  CellTags->{
  "Set::lhsr", "SetDelayed::lhsr", "Unset::lhsr", "TagSet::lhsr", 
    "TagSetDelayed::lhsr", "TagUnset::lhsr", "UpSet::lhsr", 
    "UpSetDelayed::lhsr"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[217392, 7908, 290, 10, 131, "ObjectNameWarningMessages",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
Cell[217685, 7920, 479, 13, 21, "Message",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
Cell[218167, 7935, 634, 19, 46, "Notes",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell[CellGroupData[{
Cell[218826, 7958, 177, 3, 38, "ExampleSection",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
Cell[219006, 7963, 258, 6, 24, "Text",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell[CellGroupData[{
Cell[219289, 7973, 212, 5, 26, "Input",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
Cell[219504, 7980, 282, 6, 21, "Message",
  CellTags->{
  "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
    "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
Cell[219789, 7988, 209, 5, 21, "Output",
  CellTags->{
  "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
    "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}]
}, Open  ]],
Cell[220013, 7996, 255, 7, 24, "Text",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell[CellGroupData[{
Cell[220293, 8007, 222, 5, 26, "Input",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
Cell[220518, 8014, 282, 6, 21, "Message",
  CellTags->{
  "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
    "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
Cell[220803, 8022, 299, 6, 21, "Message",
  CellTags->{
  "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
    "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}],
Cell[221105, 8030, 219, 5, 21, "Output",
  CellTags->{
  "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
    "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}]
}, Open  ]],
Cell[221339, 8038, 195, 3, 24, "Text",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],

Cell[CellGroupData[{
Cell[221559, 8045, 223, 5, 26, "Input",
  CellTags->{
  "Set::setraw", "SetDelayed::setraw", "UpSet::setraw", 
    "UpSetDelayed::setraw", "TagSet::setraw", "TagSetDelayed::setraw"}],
Cell[221785, 8052, 216, 5, 21, "Output",
  CellTags->{
  "SetDelayed::setraw", "Set::setraw", "TagSetDelayed::setraw", 
    "TagSet::setraw", "UpSetDelayed::setraw", "UpSet::setraw"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[222062, 8064, 122, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Set::shape", "SetDelayed::shape"}],
Cell[222187, 8070, 430, 12, 21, "Message",
  CellTags->{"Set::shape", "SetDelayed::shape"}],
Cell[222620, 8084, 205, 4, 24, "Notes",
  CellTags->{"Set::shape", "SetDelayed::shape"}],

Cell[CellGroupData[{
Cell[222850, 8092, 83, 1, 38, "ExampleSection",
  CellTags->{"Set::shape", "SetDelayed::shape"}],
Cell[222936, 8095, 240, 5, 40, "Text",
  CellTags->{"Set::shape", "SetDelayed::shape"}],

Cell[CellGroupData[{
Cell[223201, 8104, 139, 3, 26, "Input",
  CellTags->{"Set::shape", "SetDelayed::shape"}],
Cell[223343, 8109, 230, 5, 21, "Message",
  CellTags->{"SetDelayed::shape", "Set::shape"}],
Cell[223576, 8116, 119, 3, 21, "Output",
  CellTags->{"SetDelayed::shape", "Set::shape"}]
}, Open  ]],
Cell[223710, 8122, 95, 1, 24, "Text",
  CellTags->{"Set::shape", "SetDelayed::shape"}],

Cell[CellGroupData[{
Cell[223830, 8127, 136, 3, 26, "Input",
  CellTags->{"Set::shape", "SetDelayed::shape"}],
Cell[223969, 8132, 116, 3, 21, "Output",
  CellTags->{"SetDelayed::shape", "Set::shape"}]
}, Open  ]],
Cell[224100, 8138, 91, 1, 24, "Text",
  CellTags->{"Set::shape", "SetDelayed::shape"}],
Cell[224194, 8141, 129, 3, 26, "Input",
  CellTags->{"Set::shape", "SetDelayed::shape"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[224372, 8150, 290, 10, 131, "ObjectNameWarningMessages",
  CellTags->{
  "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
    "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
Cell[224665, 8162, 547, 15, 21, "Message",
  CellTags->{
  "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
    "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
Cell[225215, 8179, 309, 7, 24, "Notes",
  CellTags->{
  "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
    "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],

Cell[CellGroupData[{
Cell[225549, 8190, 177, 3, 38, "ExampleSection",
  CellTags->{
  "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
    "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
Cell[225729, 8195, 258, 6, 24, "Text",
  CellTags->{
  "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
    "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],

Cell[CellGroupData[{
Cell[226012, 8205, 215, 5, 26, "Input",
  CellTags->{
  "Set::setrpt", "SetDelayed::setrpt", "UpSet::setrpt", 
    "UpSetDelayed::setrpt", "TagSet::setrpt", "TagSetDelayed::setrpt"}],
Cell[226230, 8212, 313, 7, 21, "Message",
  CellTags->{
  "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
    "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}],
Cell[226546, 8221, 202, 5, 21, "Output",
  CellTags->{
  "SetDelayed::setrpt", "Set::setrpt", "TagSetDelayed::setrpt", 
    "TagSet::setrpt", "UpSetDelayed::setrpt", "UpSet::setrpt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[226809, 8233, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SetOptions::optf"],
Cell[226897, 8236, 343, 10, 21, "Message",
  CellTags->"SetOptions::optf"],
Cell[227243, 8248, 379, 10, 46, "Notes",
  CellTags->"SetOptions::optf"],

Cell[CellGroupData[{
Cell[227647, 8262, 66, 1, 38, "ExampleSection",
  CellTags->"SetOptions::optf"],
Cell[227716, 8265, 175, 6, 24, "Text",
  CellTags->"SetOptions::optf"],

Cell[CellGroupData[{
Cell[227916, 8275, 130, 3, 26, "Input",
  CellTags->"SetOptions::optf"],
Cell[228049, 8280, 202, 5, 21, "Message",
  CellTags->"SetOptions::optf"],
Cell[228254, 8287, 179, 4, 21, "Message",
  CellTags->"SetOptions::optf"],
Cell[228436, 8293, 108, 3, 21, "Output",
  CellTags->"SetOptions::optf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[228605, 8303, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SetOptions::sstm"],
Cell[228693, 8306, 239, 5, 21, "Message",
  CellTags->"SetOptions::sstm"],
Cell[228935, 8313, 484, 11, 84, "Notes",
  CellTags->"SetOptions::sstm"],

Cell[CellGroupData[{
Cell[229444, 8328, 66, 1, 38, "ExampleSection",
  CellTags->"SetOptions::sstm"],
Cell[229513, 8331, 175, 5, 24, "Text",
  CellTags->"SetOptions::sstm"],

Cell[CellGroupData[{
Cell[229713, 8340, 114, 3, 26, "Input",
  CellTags->"SetOptions::sstm"],
Cell[229830, 8345, 199, 5, 21, "Message",
  CellTags->"SetOptions::sstm"],
Cell[230032, 8352, 120, 3, 21, "Output",
  CellTags->"SetOptions::sstm"]
}, Open  ]],
Cell[230167, 8358, 163, 5, 24, "Text",
  CellTags->"SetOptions::sstm"],

Cell[CellGroupData[{
Cell[230355, 8367, 161, 4, 42, "Input",
  CellTags->"SetOptions::sstm"],
Cell[230519, 8373, 105, 3, 21, "Output",
  CellTags->"SetOptions::sstm"]
}, Open  ]],
Cell[230639, 8379, 117, 5, 24, "Text",
  CellTags->"SetOptions::sstm"],
Cell[230759, 8386, 102, 3, 26, "Input",
  CellTags->"SetOptions::sstm"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[230910, 8395, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Stack::stackx"],
Cell[230992, 8398, 545, 14, 37, "Message",
  CellTags->"Stack::stackx"],
Cell[231540, 8414, 265, 6, 40, "Notes",
  CellTags->"Stack::stackx"],

Cell[CellGroupData[{
Cell[231830, 8424, 63, 1, 38, "ExampleSection",
  CellTags->"Stack::stackx"],
Cell[231896, 8427, 216, 6, 40, "Text",
  CellTags->"Stack::stackx"],

Cell[CellGroupData[{
Cell[232137, 8437, 123, 3, 26, "Input",
  CellTags->"Stack::stackx"],
Cell[232263, 8442, 259, 5, 37, "Message",
  CellTags->"Stack::stackx"],
Cell[232525, 8449, 102, 3, 21, "Print",
  CellTags->"Stack::stackx"],
Cell[232630, 8454, 98, 3, 21, "Output",
  CellTags->"Stack::stackx"]
}, Open  ]],
Cell[232743, 8460, 121, 5, 24, "Text",
  CellTags->"Stack::stackx"],

Cell[CellGroupData[{
Cell[232889, 8469, 123, 3, 26, "Input",
  CellTags->"Stack::stackx"],
Cell[233015, 8474, 133, 4, 21, "Print",
  CellTags->"Stack::stackx"],
Cell[233151, 8480, 98, 3, 21, "Output",
  CellTags->"Stack::stackx"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[233310, 8490, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"StringDrop::drop"],
Cell[233398, 8493, 190, 4, 21, "Message",
  CellTags->"StringDrop::drop"],
Cell[233591, 8499, 234, 5, 24, "Notes",
  CellTags->"StringDrop::drop"],

Cell[CellGroupData[{
Cell[233850, 8508, 66, 1, 38, "ExampleSection",
  CellTags->"StringDrop::drop"],
Cell[233919, 8511, 157, 4, 24, "Text",
  CellTags->"StringDrop::drop"],

Cell[CellGroupData[{
Cell[234101, 8519, 135, 3, 26, "Input",
  CellTags->"StringDrop::drop"],
Cell[234239, 8524, 226, 5, 21, "Message",
  CellTags->"StringDrop::drop"],
Cell[234468, 8531, 132, 3, 21, "Output",
  CellTags->"StringDrop::drop"]
}, Open  ]],
Cell[234615, 8537, 133, 5, 24, "Text",
  CellTags->"StringDrop::drop"],

Cell[CellGroupData[{
Cell[234773, 8546, 134, 3, 26, "Input",
  CellTags->"StringDrop::drop"],
Cell[234910, 8551, 104, 3, 21, "Output",
  CellTags->"StringDrop::drop"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[235075, 8561, 146, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
Cell[235224, 8567, 438, 13, 21, "Message",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
Cell[235665, 8582, 185, 4, 24, "Notes",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],

Cell[CellGroupData[{
Cell[235875, 8590, 95, 1, 38, "ExampleSection",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
Cell[235973, 8593, 207, 4, 24, "Text",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],

Cell[CellGroupData[{
Cell[236205, 8601, 160, 3, 26, "Input",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
Cell[236368, 8606, 229, 5, 21, "Message",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
Cell[236600, 8613, 153, 3, 21, "Output",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}]
}, Open  ]],
Cell[236768, 8619, 164, 5, 24, "Text",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],

Cell[CellGroupData[{
Cell[236957, 8628, 161, 3, 26, "Input",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}],
Cell[237121, 8633, 132, 3, 21, "Output",
  CellTags->{"StringInsert::ins", "StringReplacePart::ins"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[237314, 8643, 146, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],
Cell[237463, 8649, 612, 16, 37, "Message",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],
Cell[238078, 8667, 230, 5, 24, "Notes",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],

Cell[CellGroupData[{
Cell[238333, 8676, 95, 1, 38, "ExampleSection",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],
Cell[238431, 8679, 253, 6, 40, "Text",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],

Cell[CellGroupData[{
Cell[238709, 8689, 192, 4, 26, "Input",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],
Cell[238904, 8695, 294, 5, 53, "Message",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],
Cell[239201, 8702, 186, 4, 21, "Output",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}]
}, Open  ]],
Cell[239402, 8709, 176, 5, 24, "Text",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],

Cell[CellGroupData[{
Cell[239603, 8718, 213, 4, 26, "Input",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}],
Cell[239819, 8724, 127, 3, 21, "Output",
  CellTags->{"StringPosition::meta", "StringReplace::meta"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[240007, 8734, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"StringReplace::srep"],
Cell[240101, 8737, 232, 5, 21, "Message",
  CellTags->"StringReplace::srep"],
Cell[240336, 8744, 365, 7, 62, "Notes",
  CellTags->"StringReplace::srep"],

Cell[CellGroupData[{
Cell[240726, 8755, 69, 1, 38, "ExampleSection",
  CellTags->"StringReplace::srep"],
Cell[240798, 8758, 232, 6, 40, "Text",
  CellTags->"StringReplace::srep"],

Cell[CellGroupData[{
Cell[241055, 8768, 126, 3, 26, "Input",
  CellTags->"StringReplace::srep"],
Cell[241184, 8773, 198, 5, 21, "Message",
  CellTags->"StringReplace::srep"],
Cell[241385, 8780, 205, 5, 21, "Message",
  CellTags->"StringReplace::srep"],
Cell[241593, 8787, 128, 3, 21, "Output",
  CellTags->"StringReplace::srep"]
}, Open  ]],
Cell[241736, 8793, 94, 1, 24, "Text",
  CellTags->"StringReplace::srep"],

Cell[CellGroupData[{
Cell[241855, 8798, 138, 3, 26, "Input",
  CellTags->"StringReplace::srep"],
Cell[241996, 8803, 100, 3, 21, "Output",
  CellTags->"StringReplace::srep"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[242157, 8813, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"StringReplacePart::ovlp"],
Cell[242259, 8816, 479, 14, 37, "Message",
  CellTags->"StringReplacePart::ovlp"],
Cell[242741, 8832, 233, 6, 24, "Notes",
  CellTags->"StringReplacePart::ovlp"],

Cell[CellGroupData[{
Cell[242999, 8842, 73, 1, 38, "ExampleSection",
  CellTags->"StringReplacePart::ovlp"],
Cell[243075, 8845, 175, 4, 24, "Text",
  CellTags->"StringReplacePart::ovlp"],

Cell[CellGroupData[{
Cell[243275, 8853, 168, 4, 26, "Input",
  CellTags->"StringReplacePart::ovlp"],
Cell[243446, 8859, 251, 5, 37, "Message",
  CellTags->"StringReplacePart::ovlp"],
Cell[243700, 8866, 107, 3, 21, "Output",
  CellTags->"StringReplacePart::ovlp"]
}, Open  ]],
Cell[243822, 8872, 147, 5, 24, "Text",
  CellTags->"StringReplacePart::ovlp"],

Cell[CellGroupData[{
Cell[243994, 8881, 168, 4, 26, "Input",
  CellTags->"StringReplacePart::ovlp"],
Cell[244165, 8887, 106, 3, 21, "Output",
  CellTags->"StringReplacePart::ovlp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[244332, 8897, 103, 1, 31, "ObjectNameWarningMessages",
  CellTags->"StringReplacePart::repart"],
Cell[244438, 8900, 211, 4, 21, "Message",
  CellTags->"StringReplacePart::repart"],
Cell[244652, 8906, 262, 6, 40, "Notes",
  CellTags->"StringReplacePart::repart"],

Cell[CellGroupData[{
Cell[244939, 8916, 75, 1, 38, "ExampleSection",
  CellTags->"StringReplacePart::repart"],
Cell[245017, 8919, 200, 5, 40, "Text",
  CellTags->"StringReplacePart::repart"],

Cell[CellGroupData[{
Cell[245242, 8928, 148, 3, 26, "Input",
  CellTags->"StringReplacePart::repart"],
Cell[245393, 8933, 233, 5, 21, "Message",
  CellTags->"StringReplacePart::repart"],
Cell[245629, 8940, 141, 3, 21, "Output",
  CellTags->"StringReplacePart::repart"]
}, Open  ]],
Cell[245785, 8946, 130, 4, 24, "Text",
  CellTags->"StringReplacePart::repart"],

Cell[CellGroupData[{
Cell[245940, 8954, 148, 3, 26, "Input",
  CellTags->"StringReplacePart::repart"],
Cell[246091, 8959, 107, 3, 21, "Output",
  CellTags->"StringReplacePart::repart"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[246259, 8969, 99, 1, 31, "ObjectNameWarningMessages",
  CellTags->"StringReplacePart::spos"],
Cell[246361, 8972, 423, 11, 37, "Message",
  CellTags->"StringReplacePart::spos"],
Cell[246787, 8985, 246, 5, 40, "Notes",
  CellTags->"StringReplacePart::spos"],

Cell[CellGroupData[{
Cell[247058, 8994, 73, 1, 38, "ExampleSection",
  CellTags->"StringReplacePart::spos"],
Cell[247134, 8997, 150, 4, 24, "Text",
  CellTags->"StringReplacePart::spos"],

Cell[CellGroupData[{
Cell[247309, 9005, 143, 3, 26, "Input",
  CellTags->"StringReplacePart::spos"],
Cell[247455, 9010, 237, 5, 37, "Message",
  CellTags->"StringReplacePart::spos"],
Cell[247695, 9017, 136, 3, 21, "Output",
  CellTags->"StringReplacePart::spos"]
}, Open  ]],
Cell[247846, 9023, 162, 5, 24, "Text",
  CellTags->"StringReplacePart::spos"],

Cell[CellGroupData[{
Cell[248033, 9032, 146, 3, 26, "Input",
  CellTags->"StringReplacePart::spos"],
Cell[248182, 9037, 107, 3, 21, "Output",
  CellTags->"StringReplacePart::spos"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[248350, 9047, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Symbol::symname"],
Cell[248436, 9050, 265, 5, 53, "Message",
  CellTags->"Symbol::symname"],
Cell[248704, 9057, 192, 5, 24, "Notes",
  CellTags->"Symbol::symname"],

Cell[CellGroupData[{
Cell[248921, 9066, 65, 1, 38, "ExampleSection",
  CellTags->"Symbol::symname"],
Cell[248989, 9069, 199, 5, 24, "Text",
  CellTags->"Symbol::symname"],

Cell[CellGroupData[{
Cell[249213, 9078, 109, 3, 26, "Input",
  CellTags->"Symbol::symname"],
Cell[249325, 9083, 280, 6, 53, "Message",
  CellTags->"Symbol::symname"],
Cell[249608, 9091, 106, 3, 21, "Output",
  CellTags->"Symbol::symname"]
}, Open  ]],
Cell[249729, 9097, 129, 5, 24, "Text",
  CellTags->"Symbol::symname"],

Cell[CellGroupData[{
Cell[249883, 9106, 107, 3, 26, "Input",
  CellTags->"Symbol::symname"],
Cell[249993, 9111, 94, 3, 21, "Output",
  CellTags->"Symbol::symname"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[250148, 9121, 169, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
Cell[250320, 9128, 425, 12, 21, "Message",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
Cell[250748, 9142, 223, 4, 24, "Notes",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],

Cell[CellGroupData[{
Cell[250996, 9150, 108, 1, 38, "ExampleSection",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
Cell[251107, 9153, 192, 4, 24, "Text",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],

Cell[CellGroupData[{
Cell[251324, 9161, 160, 3, 26, "Input",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
Cell[251487, 9166, 229, 4, 21, "Message",
  CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}],
Cell[251719, 9172, 139, 3, 21, "Output",
  CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}]
}, Open  ]],
Cell[251873, 9178, 189, 4, 24, "Text",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
Cell[252065, 9184, 165, 3, 26, "Input",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],

Cell[CellGroupData[{
Cell[252255, 9191, 145, 3, 26, "Input",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
Cell[252403, 9196, 141, 3, 21, "Output",
  CellTags->{"TagSetDelayed::tagnf", "TagSet::tagnf", "TagUnset::tagnf"}]
}, Open  ]],
Cell[252559, 9202, 157, 5, 24, "Text",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}],
Cell[252719, 9209, 141, 3, 26, "Input",
  CellTags->{"TagSet::tagnf", "TagSetDelayed::tagnf", "TagUnset::tagnf"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[252909, 9218, 175, 5, 71, "ObjectNameWarningMessages",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
Cell[253087, 9225, 528, 13, 21, "Message",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
Cell[253618, 9240, 232, 4, 24, "Notes",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],

Cell[CellGroupData[{
Cell[253875, 9248, 111, 1, 38, "ExampleSection",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
Cell[253989, 9251, 249, 5, 40, "Text",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],

Cell[CellGroupData[{
Cell[254263, 9260, 153, 3, 26, "Input",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
Cell[254419, 9265, 276, 5, 37, "Message",
  CellTags->{"TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}],
Cell[254698, 9272, 142, 3, 21, "Output",
  CellTags->{"TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}]
}, Open  ]],
Cell[254855, 9278, 198, 4, 24, "Text",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
Cell[255056, 9284, 154, 3, 26, "Input",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],

Cell[CellGroupData[{
Cell[255235, 9291, 143, 3, 26, "Input",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
Cell[255381, 9296, 136, 3, 21, "Output",
  CellTags->{"TagSetDelayed::tagpos", "TagSet::tagpos", "TagUnset::tagpos"}]
}, Open  ]],
Cell[255532, 9302, 159, 5, 24, "Text",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}],
Cell[255694, 9309, 143, 3, 26, "Input",
  CellTags->{"TagSet::tagpos", "TagSetDelayed::tagpos", "TagUnset::tagpos"}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[255886, 9318, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Throw::nocatch"],
Cell[255970, 9321, 226, 5, 21, "Message",
  CellTags->"Throw::nocatch"],
Cell[256199, 9328, 196, 7, 24, "Notes",
  CellTags->"Throw::nocatch"],

Cell[CellGroupData[{
Cell[256420, 9339, 64, 1, 38, "ExampleSection",
  CellTags->"Throw::nocatch"],
Cell[256487, 9342, 199, 7, 24, "Text",
  CellTags->"Throw::nocatch"],

Cell[CellGroupData[{
Cell[256711, 9353, 141, 3, 26, "Input",
  CellTags->"Throw::nocatch"],
Cell[256855, 9358, 190, 5, 21, "Print",
  CellTags->"Throw::nocatch"],
Cell[257048, 9365, 190, 5, 21, "Print",
  CellTags->"Throw::nocatch"],
Cell[257241, 9372, 190, 5, 21, "Print",
  CellTags->"Throw::nocatch"],
Cell[257434, 9379, 182, 4, 21, "Message",
  CellTags->"Throw::nocatch"],
Cell[257619, 9385, 102, 3, 21, "Output",
  CellTags->"Throw::nocatch"]
}, Open  ]],
Cell[257736, 9391, 160, 7, 24, "Text",
  CellTags->"Throw::nocatch"],

Cell[CellGroupData[{
Cell[257921, 9402, 155, 4, 26, "Input",
  CellTags->"Throw::nocatch"],
Cell[258079, 9408, 190, 5, 21, "Print",
  CellTags->"Throw::nocatch"],
Cell[258272, 9415, 190, 5, 21, "Print",
  CellTags->"Throw::nocatch"],
Cell[258465, 9422, 190, 5, 21, "Print",
  CellTags->"Throw::nocatch"],
Cell[258658, 9429, 89, 3, 21, "Output",
  CellTags->"Throw::nocatch"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[258808, 9439, 212, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],
Cell[259023, 9449, 682, 20, 37, "Message",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],
Cell[259708, 9471, 265, 7, 24, "Notes",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],

Cell[CellGroupData[{
Cell[259998, 9482, 135, 3, 38, "ExampleSection",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],
Cell[260136, 9487, 255, 8, 24, "Text",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],

Cell[CellGroupData[{
Cell[260416, 9499, 205, 5, 26, "Input",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],
Cell[260624, 9506, 316, 7, 37, "Message",
  CellTags->{
  "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
    "Trace::tracb"}],
Cell[260943, 9515, 211, 5, 21, "Output",
  CellTags->{
  "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
    "Trace::tracb"}]
}, Open  ]],
Cell[261169, 9523, 249, 9, 24, "Text",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],

Cell[CellGroupData[{
Cell[261443, 9536, 204, 5, 26, "Input",
  CellTags->{
  "Trace::tracb", "TraceScan::tracb", "TracePrint::tracb", 
    "TraceDialog::tracb"}],
Cell[261650, 9543, 543, 18, 21, "Output",
  CellTags->{
  "TraceDialog::tracb", "TracePrint::tracb", "TraceScan::tracb", 
    "Trace::tracb"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[262254, 9568, 212, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],
Cell[262469, 9578, 623, 18, 21, "Message",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],
Cell[263095, 9598, 391, 15, 24, "Notes",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],

Cell[CellGroupData[{
Cell[263511, 9617, 135, 3, 38, "ExampleSection",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],
Cell[263649, 9622, 262, 8, 24, "Text",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],

Cell[CellGroupData[{
Cell[263936, 9634, 209, 5, 26, "Input",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],
Cell[264148, 9641, 284, 7, 21, "Message",
  CellTags->{
  "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
    "Trace::tracd"}],
Cell[264435, 9650, 228, 6, 21, "Output",
  CellTags->{
  "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
    "Trace::tracd"}]
}, Open  ]],
Cell[264678, 9659, 252, 9, 24, "Text",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],

Cell[CellGroupData[{
Cell[264955, 9672, 212, 5, 26, "Input",
  CellTags->{
  "Trace::tracd", "TraceScan::tracd", "TracePrint::tracd", 
    "TraceDialog::tracd"}],
Cell[265170, 9679, 289, 10, 21, "Output",
  CellTags->{
  "TraceDialog::tracd", "TracePrint::tracd", "TraceScan::tracd", 
    "Trace::tracd"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[265520, 9696, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"TraceLevel::notrc"],
Cell[265610, 9699, 165, 3, 21, "Message",
  CellTags->"TraceLevel::notrc"],
Cell[265778, 9704, 184, 5, 24, "Notes",
  CellTags->"TraceLevel::notrc"],

Cell[CellGroupData[{
Cell[265987, 9713, 67, 1, 38, "ExampleSection",
  CellTags->"TraceLevel::notrc"],
Cell[266057, 9716, 228, 5, 40, "Text",
  CellTags->"TraceLevel::notrc"],

Cell[CellGroupData[{
Cell[266310, 9725, 176, 4, 26, "Input",
  CellTags->"TraceLevel::notrc"],
Cell[266489, 9731, 180, 4, 21, "Message",
  CellTags->"TraceLevel::notrc"],
Cell[266672, 9737, 213, 5, 21, "Print",
  CellTags->"TraceLevel::notrc"],
Cell[266888, 9744, 93, 3, 21, "Output",
  CellTags->"TraceLevel::notrc"]
}, Open  ]],
Cell[266996, 9750, 194, 5, 24, "Text",
  CellTags->"TraceLevel::notrc"],

Cell[CellGroupData[{
Cell[267215, 9759, 174, 4, 26, "Input",
  CellTags->"TraceLevel::notrc"],
Cell[267392, 9765, 213, 5, 21, "Print",
  CellTags->"TraceLevel::notrc"],
Cell[267608, 9772, 1893, 49, 69, "Output",
  CellTags->"TraceLevel::notrc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[269562, 9828, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Unset::cxun"],
Cell[269640, 9831, 134, 3, 21, "Message",
  CellTags->"Unset::cxun"],
Cell[269777, 9836, 161, 5, 24, "Notes",
  CellTags->"Unset::cxun"],

Cell[CellGroupData[{
Cell[269963, 9845, 61, 1, 38, "ExampleSection",
  CellTags->"Unset::cxun"],
Cell[270027, 9848, 133, 4, 24, "Text",
  CellTags->"Unset::cxun"],

Cell[CellGroupData[{
Cell[270185, 9856, 98, 3, 26, "Input",
  CellTags->"Unset::cxun"],
Cell[270286, 9861, 145, 3, 21, "Message",
  CellTags->"Unset::cxun"],
Cell[270434, 9866, 92, 3, 21, "Output",
  CellTags->"Unset::cxun"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[270587, 9876, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Alias::almark"],
Cell[270669, 9879, 239, 6, 21, "Message",
  CellTags->"Alias::almark"],
Cell[270911, 9887, 403, 10, 46, "Notes",
  CellTags->"Alias::almark"],

Cell[CellGroupData[{
Cell[271339, 9901, 63, 1, 38, "ExampleSection",
  CellTags->"Alias::almark"],
Cell[271405, 9904, 188, 5, 24, "Text",
  CellTags->"Alias::almark"],

Cell[CellGroupData[{
Cell[271618, 9913, 107, 3, 26, "Input",
  CellTags->"Alias::almark"],
Cell[271728, 9918, 184, 4, 21, "Message",
  CellTags->"Alias::almark"],
Cell[271915, 9924, 102, 3, 21, "Output",
  CellTags->"Alias::almark"]
}, Open  ]],
Cell[272032, 9930, 125, 5, 24, "Text",
  CellTags->"Alias::almark"],

Cell[CellGroupData[{
Cell[272182, 9939, 105, 3, 26, "Input",
  CellTags->"Alias::almark"],
Cell[272290, 9944, 88, 3, 21, "Output",
  CellTags->"Alias::almark"]
}, Open  ]],

Cell[CellGroupData[{
Cell[272415, 9952, 87, 3, 26, "Input",
  CellTags->"Alias::almark"],
Cell[272505, 9957, 88, 3, 21, "Output",
  CellTags->"Alias::almark"]
}, Open  ]],
Cell[272608, 9963, 62, 1, 24, "Text",
  CellTags->"Alias::almark"],

Cell[CellGroupData[{
Cell[272695, 9968, 102, 3, 26, "Input",
  CellTags->"Alias::almark"],
Cell[272800, 9973, 90, 3, 21, "Output",
  CellTags->"Alias::almark"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[272951, 9983, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"UnAlias::alspr"],
Cell[273035, 9986, 233, 5, 21, "Message",
  CellTags->"UnAlias::alspr"],
Cell[273271, 9993, 363, 11, 46, "Notes",
  CellTags->"UnAlias::alspr"],

Cell[CellGroupData[{
Cell[273659, 10008, 64, 1, 38, "ExampleSection",
  CellTags->"UnAlias::alspr"],
Cell[273726, 10011, 137, 4, 24, "Text",
  CellTags->"UnAlias::alspr"],

Cell[CellGroupData[{
Cell[273888, 10019, 104, 3, 26, "Input",
  CellTags->"UnAlias::alspr"],
Cell[273995, 10024, 179, 4, 21, "Message",
  CellTags->"UnAlias::alspr"],
Cell[274177, 10030, 105, 3, 21, "Output",
  CellTags->"UnAlias::alspr"]
}, Open  ]],
Cell[274297, 10036, 91, 1, 24, "Text",
  CellTags->"UnAlias::alspr"],

Cell[CellGroupData[{
Cell[274413, 10041, 118, 3, 26, "Input",
  CellTags->"UnAlias::alspr"],
Cell[274534, 10046, 96, 3, 21, "Output",
  CellTags->"UnAlias::alspr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[274667, 10054, 95, 3, 26, "Input",
  CellTags->"UnAlias::alspr"],
Cell[274765, 10059, 96, 3, 21, "Output",
  CellTags->"UnAlias::alspr"]
}, Open  ]],
Cell[274876, 10065, 83, 1, 24, "Text",
  CellTags->"UnAlias::alspr"],

Cell[CellGroupData[{
Cell[274984, 10070, 110, 3, 26, "Input",
  CellTags->"UnAlias::alspr"],
Cell[275097, 10075, 98, 3, 21, "Output",
  CellTags->"UnAlias::alspr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[275232, 10083, 95, 3, 26, "Input",
  CellTags->"UnAlias::alspr"],
Cell[275330, 10088, 96, 3, 21, "Output",
  CellTags->"UnAlias::alspr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[275487, 10098, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Uninstall::unlink"],
Cell[275577, 10101, 252, 6, 21, "Message",
  CellTags->"Uninstall::unlink"],
Cell[275832, 10109, 254, 8, 24, "Notes",
  CellTags->"Uninstall::unlink"],

Cell[CellGroupData[{
Cell[276111, 10121, 67, 1, 38, "ExampleSection",
  CellTags->"Uninstall::unlink"],
Cell[276181, 10124, 215, 6, 24, "Text",
  CellTags->"Uninstall::unlink"],

Cell[CellGroupData[{
Cell[276421, 10134, 111, 3, 26, "Input",
  CellTags->"Uninstall::unlink"],
Cell[276535, 10139, 199, 5, 21, "Message",
  CellTags->"Uninstall::unlink"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[276795, 10151, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Unique::usym"],
Cell[276875, 10154, 220, 5, 21, "Message",
  CellTags->"Unique::usym"],
Cell[277098, 10161, 247, 6, 40, "Notes",
  CellTags->"Unique::usym"],

Cell[CellGroupData[{
Cell[277370, 10171, 62, 1, 38, "ExampleSection",
  CellTags->"Unique::usym"],
Cell[277435, 10174, 151, 4, 24, "Text",
  CellTags->"Unique::usym"],

Cell[CellGroupData[{
Cell[277611, 10182, 101, 3, 26, "Input",
  CellTags->"Unique::usym"],
Cell[277715, 10187, 319, 6, 21, "Message",
  CellTags->"Unique::usym"],
Cell[278037, 10195, 98, 3, 21, "Output",
  CellTags->"Unique::usym"]
}, Open  ]],
Cell[278150, 10201, 126, 5, 24, "Text",
  CellTags->"Unique::usym"],

Cell[CellGroupData[{
Cell[278301, 10210, 105, 3, 26, "Input",
  CellTags->"Unique::usym"],
Cell[278409, 10215, 93, 3, 21, "Output",
  CellTags->"Unique::usym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[278563, 10225, 122, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Unset::norep", "TagUnset::norep"}],
Cell[278688, 10231, 416, 12, 21, "Message",
  CellTags->{"Unset::norep", "TagUnset::norep"}],
Cell[279107, 10245, 382, 11, 46, "Notes",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[CellGroupData[{
Cell[279514, 10260, 83, 1, 38, "ExampleSection",
  CellTags->{"Unset::norep", "TagUnset::norep"}],
Cell[279600, 10263, 204, 6, 24, "Text",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[CellGroupData[{
Cell[279829, 10273, 124, 3, 26, "Input",
  CellTags->{"Unset::norep", "TagUnset::norep"}],
Cell[279956, 10278, 215, 5, 21, "Message",
  CellTags->{"TagUnset::norep", "Unset::norep"}],
Cell[280174, 10285, 114, 3, 21, "Output",
  CellTags->{"TagUnset::norep", "Unset::norep"}]
}, Open  ]],
Cell[280303, 10291, 141, 5, 24, "Text",
  CellTags->{"Unset::norep", "TagUnset::norep"}],
Cell[280447, 10298, 127, 3, 26, "Input",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[CellGroupData[{
Cell[280599, 10305, 116, 3, 26, "Input",
  CellTags->{"Unset::norep", "TagUnset::norep"}],
Cell[280718, 10310, 113, 3, 21, "Output",
  CellTags->{"TagUnset::norep", "Unset::norep"}]
}, Open  ]],
Cell[280846, 10316, 121, 3, 26, "Input",
  CellTags->{"Unset::norep", "TagUnset::norep"}],

Cell[CellGroupData[{
Cell[280992, 10323, 116, 3, 26, "Input",
  CellTags->{"Unset::norep", "TagUnset::norep"}],
Cell[281111, 10328, 117, 3, 21, "Output",
  CellTags->{"TagUnset::norep", "Unset::norep"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[281289, 10338, 122, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Unset::usraw", "TagUnset::usraw"}],
Cell[281414, 10344, 372, 11, 21, "Message",
  CellTags->{"Unset::usraw", "TagUnset::usraw"}],
Cell[281789, 10357, 475, 16, 46, "Notes",
  CellTags->{"Unset::usraw", "TagUnset::usraw"}],

Cell[CellGroupData[{
Cell[282289, 10377, 83, 1, 38, "ExampleSection",
  CellTags->{"Unset::usraw", "TagUnset::usraw"}],
Cell[282375, 10380, 183, 5, 24, "Text",
  CellTags->{"Unset::usraw", "TagUnset::usraw"}],

Cell[CellGroupData[{
Cell[282583, 10389, 111, 3, 26, "Input",
  CellTags->{"Unset::usraw", "TagUnset::usraw"}],
Cell[282697, 10394, 185, 4, 21, "Message",
  CellTags->{"TagUnset::usraw", "Unset::usraw"}],
Cell[282885, 10400, 114, 3, 21, "Output",
  CellTags->{"TagUnset::usraw", "Unset::usraw"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[283060, 10410, 122, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
Cell[283185, 10416, 443, 13, 21, "Message",
  CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
Cell[283631, 10431, 238, 7, 24, "Notes",
  CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],

Cell[CellGroupData[{
Cell[283894, 10442, 83, 1, 38, "ExampleSection",
  CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
Cell[283980, 10445, 170, 4, 24, "Text",
  CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],

Cell[CellGroupData[{
Cell[284175, 10453, 121, 3, 26, "Input",
  CellTags->{"Unset::usrpt", "TagUnset::usrpt"}],
Cell[284299, 10458, 216, 5, 21, "Message",
  CellTags->{"TagUnset::usrpt", "Unset::usrpt"}],
Cell[284518, 10465, 114, 3, 21, "Output",
  CellTags->{"TagUnset::usrpt", "Unset::usrpt"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[284693, 10475, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::altno"],
Cell[284777, 10478, 405, 12, 21, "Message",
  CellTags->"General::altno"],
Cell[285185, 10492, 880, 29, 84, "Notes",
  CellTags->"General::altno"],

Cell[CellGroupData[{
Cell[286090, 10525, 64, 1, 38, "ExampleSection",
  CellTags->"General::altno"],
Cell[286157, 10528, 292, 7, 40, "Text",
  CellTags->"General::altno"],

Cell[CellGroupData[{
Cell[286474, 10539, 107, 3, 26, "Input",
  CellTags->"General::altno"],
Cell[286584, 10544, 206, 5, 21, "Message",
  CellTags->"General::altno"],
Cell[286793, 10551, 89, 3, 21, "Output",
  CellTags->"General::altno"]
}, Open  ]],
Cell[286897, 10557, 125, 4, 24, "Text",
  CellTags->"General::altno"],

Cell[CellGroupData[{
Cell[287047, 10565, 107, 3, 26, "Input",
  CellTags->"General::altno"],
Cell[287157, 10570, 89, 3, 21, "Output",
  CellTags->"General::altno"]
}, Open  ]],

Cell[CellGroupData[{
Cell[287283, 10578, 101, 3, 26, "Input",
  CellTags->"General::altno"],
Cell[287387, 10583, 94, 3, 21, "Output",
  CellTags->"General::altno"]
}, Open  ]],
Cell[287496, 10589, 62, 1, 24, "Text",
  CellTags->"General::altno"],
Cell[287561, 10592, 107, 3, 26, "Input",
  CellTags->"General::altno"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[287717, 10601, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::bebal"],
Cell[287801, 10604, 406, 12, 21, "Message",
  CellTags->"General::bebal"],
Cell[288210, 10618, 781, 25, 100, "Notes",
  CellTags->"General::bebal"],

Cell[CellGroupData[{
Cell[289016, 10647, 64, 1, 38, "ExampleSection",
  CellTags->"General::bebal"],
Cell[289083, 10650, 221, 7, 24, "Text",
  CellTags->"General::bebal"],
Cell[289307, 10659, 155, 4, 26, "Input",
  CellTags->"General::bebal"],

Cell[CellGroupData[{
Cell[289487, 10667, 108, 3, 26, "Input",
  CellTags->"General::bebal"],
Cell[289598, 10672, 98, 3, 21, "Output",
  CellTags->"General::bebal"]
}, Open  ]],

Cell[CellGroupData[{
Cell[289733, 10680, 106, 3, 26, "Input",
  CellTags->"General::bebal"],
Cell[289842, 10685, 202, 5, 21, "Message",
  CellTags->"General::bebal"],
Cell[290047, 10692, 105, 3, 21, "Output",
  CellTags->"General::bebal"]
}, Open  ]],
Cell[290167, 10698, 137, 5, 24, "Text",
  CellTags->"General::bebal"],

Cell[CellGroupData[{
Cell[290329, 10707, 92, 3, 26, "Input",
  CellTags->"General::bebal"],
Cell[290424, 10712, 105, 3, 21, "Output",
  CellTags->"General::bebal"]
}, Open  ]],
Cell[290544, 10718, 73, 1, 24, "Text",
  CellTags->"General::bebal"],
Cell[290620, 10721, 113, 3, 26, "Input",
  CellTags->"General::bebal"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[290782, 10730, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::cxls"],
Cell[290864, 10733, 543, 16, 21, "Message",
  CellTags->"General::cxls"],
Cell[291410, 10751, 449, 8, 78, "Notes",
  CellTags->"General::cxls"],

Cell[CellGroupData[{
Cell[291884, 10763, 63, 1, 38, "ExampleSection",
  CellTags->"General::cxls"],
Cell[291950, 10766, 224, 5, 40, "Text",
  CellTags->"General::cxls"],

Cell[CellGroupData[{
Cell[292199, 10775, 140, 3, 26, "Input",
  CellTags->"General::cxls"],
Cell[292342, 10780, 276, 6, 37, "Message",
  CellTags->"General::cxls"],
Cell[292621, 10788, 131, 3, 21, "Output",
  CellTags->"General::cxls"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[292813, 10798, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::cxt"],
Cell[292893, 10801, 545, 17, 21, "Message",
  CellTags->"General::cxt"],
Cell[293441, 10820, 348, 7, 62, "Notes",
  CellTags->"General::cxt"],

Cell[CellGroupData[{
Cell[293814, 10831, 62, 1, 38, "ExampleSection",
  CellTags->"General::cxt"],
Cell[293879, 10834, 182, 4, 40, "Text",
  CellTags->"General::cxt"],

Cell[CellGroupData[{
Cell[294086, 10842, 106, 3, 26, "Input",
  CellTags->"General::cxt"],
Cell[294195, 10847, 274, 6, 37, "Message",
  CellTags->"General::cxt"],
Cell[294472, 10855, 229, 5, 37, "Message",
  CellTags->"General::cxt"],
Cell[294704, 10862, 103, 3, 21, "Output",
  CellTags->"General::cxt"]
}, Open  ]],
Cell[294822, 10868, 85, 1, 24, "Text",
  CellTags->"General::cxt"],

Cell[CellGroupData[{
Cell[294932, 10873, 106, 3, 26, "Input",
  CellTags->"General::cxt"],
Cell[295041, 10878, 96, 3, 21, "Output",
  CellTags->"General::cxt"]
}, Open  ]],
Cell[295152, 10884, 73, 1, 24, "Text",
  CellTags->"General::cxt"],

Cell[CellGroupData[{
Cell[295250, 10889, 90, 3, 26, "Input",
  CellTags->"General::cxt"],
Cell[295343, 10894, 96, 3, 21, "Output",
  CellTags->"General::cxt"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[295500, 10904, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::mbox"],
Cell[295582, 10907, 258, 7, 21, "Message",
  CellTags->"General::mbox"],
Cell[295843, 10916, 318, 8, 46, "Notes",
  CellTags->"General::mbox"]
}, Open  ]],

Cell[CellGroupData[{
Cell[296198, 10929, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::newsym"],
Cell[296284, 10932, 315, 9, 21, "Message",
  CellTags->"General::newsym"],
Cell[296602, 10943, 284, 7, 46, "Notes",
  CellTags->"General::newsym"],

Cell[CellGroupData[{
Cell[296911, 10954, 65, 1, 38, "ExampleSection",
  CellTags->"General::newsym"],
Cell[296979, 10957, 88, 1, 24, "Text",
  CellTags->"General::newsym"],
Cell[297070, 10960, 107, 3, 26, "Input",
  CellTags->"General::newsym"],

Cell[CellGroupData[{
Cell[297202, 10967, 99, 3, 26, "Input",
  CellTags->"General::newsym"],
Cell[297304, 10972, 170, 4, 21, "Message",
  CellTags->"General::newsym"],
Cell[297477, 10978, 100, 3, 21, "Output",
  CellTags->"General::newsym"]
}, Open  ]],
Cell[297592, 10984, 108, 3, 26, "Input",
  CellTags->"General::newsym"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[297749, 10993, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nosym"],
Cell[297833, 10996, 447, 12, 21, "Message",
  CellTags->"General::nosym"],
Cell[298283, 11010, 314, 7, 62, "Notes",
  CellTags->"General::nosym"],

Cell[CellGroupData[{
Cell[298622, 11021, 64, 1, 38, "ExampleSection",
  CellTags->"General::nosym"],
Cell[298689, 11024, 150, 4, 24, "Text",
  CellTags->"General::nosym"],

Cell[CellGroupData[{
Cell[298864, 11032, 113, 3, 26, "Input",
  CellTags->"General::nosym"],
Cell[298980, 11037, 214, 5, 37, "Message",
  CellTags->"General::nosym"],
Cell[299197, 11044, 97, 3, 21, "Output",
  CellTags->"General::nosym"]
}, Open  ]],
Cell[299309, 11050, 106, 1, 24, "Text",
  CellTags->"General::nosym"],

Cell[CellGroupData[{
Cell[299440, 11055, 114, 3, 26, "Input",
  CellTags->"General::nosym"],
Cell[299557, 11060, 97, 3, 21, "Output",
  CellTags->"General::nosym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[299715, 11070, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::noval"],
Cell[299799, 11073, 427, 11, 21, "Message",
  CellTags->"General::noval"],
Cell[300229, 11086, 685, 19, 68, "Notes",
  CellTags->"General::noval"],

Cell[CellGroupData[{
Cell[300939, 11109, 64, 1, 38, "ExampleSection",
  CellTags->"General::noval"],
Cell[301006, 11112, 253, 7, 40, "Text",
  CellTags->"General::noval"],

Cell[CellGroupData[{
Cell[301284, 11123, 106, 3, 26, "Input",
  CellTags->"General::noval"],
Cell[301393, 11128, 206, 5, 21, "Message",
  CellTags->"General::noval"],
Cell[301602, 11135, 89, 3, 21, "Output",
  CellTags->"General::noval"]
}, Open  ]],
Cell[301706, 11141, 159, 5, 24, "Text",
  CellTags->"General::noval"],
Cell[301868, 11148, 115, 3, 26, "Input",
  CellTags->"General::noval"],

Cell[CellGroupData[{
Cell[302008, 11155, 106, 3, 26, "Input",
  CellTags->"General::noval"],
Cell[302117, 11160, 206, 5, 21, "Message",
  CellTags->"General::noval"],
Cell[302326, 11167, 89, 3, 21, "Output",
  CellTags->"General::noval"]
}, Open  ]],
Cell[302430, 11173, 156, 5, 24, "Text",
  CellTags->"General::noval"],

Cell[CellGroupData[{
Cell[302611, 11182, 114, 3, 26, "Input",
  CellTags->"General::noval"],
Cell[302728, 11187, 106, 3, 21, "Output",
  CellTags->"General::noval"]
}, Open  ]],

Cell[CellGroupData[{
Cell[302871, 11195, 106, 3, 26, "Input",
  CellTags->"General::noval"],
Cell[302980, 11200, 89, 3, 21, "Output",
  CellTags->"General::noval"]
}, Open  ]],

Cell[CellGroupData[{
Cell[303106, 11208, 93, 3, 26, "Input",
  CellTags->"General::noval"],
Cell[303202, 11213, 103, 3, 21, "Output",
  CellTags->"General::noval"]
}, Open  ]],
Cell[303320, 11219, 116, 5, 24, "Text",
  CellTags->"General::noval"],
Cell[303439, 11226, 100, 3, 26, "Input",
  CellTags->"General::noval"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[303588, 11235, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::opset"],
Cell[303672, 11238, 394, 12, 21, "Message",
  CellTags->"General::opset"],
Cell[304069, 11252, 229, 6, 46, "Notes",
  CellTags->"General::opset"],

Cell[CellGroupData[{
Cell[304323, 11262, 64, 1, 38, "ExampleSection",
  CellTags->"General::opset"],
Cell[304390, 11265, 154, 4, 24, "Text",
  CellTags->"General::opset"],

Cell[CellGroupData[{
Cell[304569, 11273, 270, 5, 138, "Input",
  CellTags->"General::opset"],
Cell[304842, 11280, 196, 5, 21, "Message",
  CellTags->"General::opset"],
Cell[305041, 11287, 99, 3, 21, "Output",
  CellTags->"General::opset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[305201, 11297, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::optb"],
Cell[305283, 11300, 439, 13, 21, "Message",
  CellTags->"General::optb"],
Cell[305725, 11315, 601, 21, 46, "Notes",
  CellTags->"General::optb"],

Cell[CellGroupData[{
Cell[306351, 11340, 63, 1, 38, "ExampleSection",
  CellTags->"General::optb"],
Cell[306417, 11343, 308, 13, 24, "Text",
  CellTags->"General::optb"],

Cell[CellGroupData[{
Cell[306750, 11360, 126, 3, 26, "Input",
  CellTags->"General::optb"],
Cell[306879, 11365, 199, 5, 21, "Message",
  CellTags->"General::optb"],
Cell[307081, 11372, 101, 3, 21, "Output",
  CellTags->"General::optb"]
}, Open  ]],
Cell[307197, 11378, 125, 5, 24, "Text",
  CellTags->"General::optb"],

Cell[CellGroupData[{
Cell[307347, 11387, 126, 3, 26, "Input",
  CellTags->"General::optb"],
Cell[307476, 11392, 96, 3, 21, "Output",
  CellTags->"General::optb"]
}, Open  ]],
Cell[307587, 11398, 102, 1, 24, "Text",
  CellTags->"General::optb"],

Cell[CellGroupData[{
Cell[307714, 11403, 117, 3, 26, "Input",
  CellTags->"General::optb"],
Cell[307834, 11408, 96, 3, 21, "Output",
  CellTags->"General::optb"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[307991, 11418, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::patop"],
Cell[308075, 11421, 369, 10, 21, "Message",
  CellTags->"General::patop"],
Cell[308447, 11433, 976, 34, 84, "Notes",
  CellTags->"General::patop"],

Cell[CellGroupData[{
Cell[309448, 11471, 64, 1, 38, "ExampleSection",
  CellTags->"General::patop"],
Cell[309515, 11474, 233, 7, 24, "Text",
  CellTags->"General::patop"],

Cell[CellGroupData[{
Cell[309773, 11485, 127, 3, 26, "Input",
  CellTags->"General::patop"],
Cell[309903, 11490, 211, 5, 21, "Message",
  CellTags->"General::patop"],
Cell[310117, 11497, 102, 3, 21, "Output",
  CellTags->"General::patop"]
}, Open  ]],
Cell[310234, 11503, 136, 5, 24, "Text",
  CellTags->"General::patop"],

Cell[CellGroupData[{
Cell[310395, 11512, 124, 3, 26, "Input",
  CellTags->"General::patop"],
Cell[310522, 11517, 97, 3, 21, "Output",
  CellTags->"General::patop"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[310680, 11527, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::rvalue"],
Cell[310766, 11530, 480, 14, 21, "Message",
  CellTags->"General::rvalue"],
Cell[311249, 11546, 352, 8, 46, "Notes",
  CellTags->"General::rvalue"],

Cell[CellGroupData[{
Cell[311626, 11558, 65, 1, 38, "ExampleSection",
  CellTags->"General::rvalue"],
Cell[311694, 11561, 192, 5, 24, "Text",
  CellTags->"General::rvalue"],

Cell[CellGroupData[{
Cell[311911, 11570, 142, 3, 26, "Input",
  CellTags->"General::rvalue"],
Cell[312056, 11575, 215, 5, 37, "Message",
  CellTags->"General::rvalue"],
Cell[312274, 11582, 205, 5, 21, "Print",
  CellTags->"General::rvalue"]
}, Open  ]],
Cell[312494, 11590, 127, 5, 24, "Text",
  CellTags->"General::rvalue"],

Cell[CellGroupData[{
Cell[312646, 11599, 144, 3, 26, "Input",
  CellTags->"General::rvalue"],
Cell[312793, 11604, 201, 5, 21, "Print",
  CellTags->"General::rvalue"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[313055, 11616, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::setp"],
Cell[313137, 11619, 380, 11, 21, "Message",
  CellTags->"General::setp"],
Cell[313520, 11632, 186, 5, 24, "Notes",
  CellTags->"General::setp"],

Cell[CellGroupData[{
Cell[313731, 11641, 63, 1, 38, "ExampleSection",
  CellTags->"General::setp"],
Cell[313797, 11644, 154, 4, 24, "Text",
  CellTags->"General::setp"],

Cell[CellGroupData[{
Cell[313976, 11652, 96, 3, 26, "Input",
  CellTags->"General::setp"],
Cell[314075, 11657, 180, 4, 21, "Message",
  CellTags->"General::setp"],
Cell[314258, 11663, 88, 3, 21, "Output",
  CellTags->"General::setp"]
}, Open  ]],
Cell[314361, 11669, 80, 1, 24, "Text",
  CellTags->"General::setp"],

Cell[CellGroupData[{
Cell[314466, 11674, 128, 3, 26, "Input",
  CellTags->"General::setp"],
Cell[314597, 11679, 97, 3, 21, "Output",
  CellTags->"General::setp"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[314755, 11689, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::setps"],
Cell[314839, 11692, 400, 11, 21, "Message",
  CellTags->"General::setps"],
Cell[315242, 11705, 267, 6, 46, "Notes",
  CellTags->"General::setps"],

Cell[CellGroupData[{
Cell[315534, 11715, 64, 1, 38, "ExampleSection",
  CellTags->"General::setps"],
Cell[315601, 11718, 196, 5, 40, "Text",
  CellTags->"General::setps"],

Cell[CellGroupData[{
Cell[315822, 11727, 145, 3, 26, "Input",
  CellTags->"General::setps"],
Cell[315970, 11732, 181, 4, 21, "Message",
  CellTags->"General::setps"],
Cell[316154, 11738, 97, 3, 21, "Output",
  CellTags->"General::setps"]
}, Open  ]],
Cell[316266, 11744, 81, 1, 24, "Text",
  CellTags->"General::setps"],

Cell[CellGroupData[{
Cell[316372, 11749, 136, 3, 26, "Input",
  CellTags->"General::setps"],
Cell[316511, 11754, 98, 3, 21, "Output",
  CellTags->"General::setps"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[316670, 11764, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::shdw"],
Cell[316752, 11767, 675, 18, 37, "Message",
  CellTags->"General::shdw"],
Cell[317430, 11787, 931, 18, 160, "Notes",
  CellTags->"General::shdw"],

Cell[CellGroupData[{
Cell[318386, 11809, 63, 1, 38, "ExampleSection",
  CellTags->"General::shdw"],
Cell[318452, 11812, 188, 5, 24, "Text",
  CellTags->"General::shdw"],

Cell[CellGroupData[{
Cell[318665, 11821, 100, 3, 26, "Input",
  CellTags->"General::shdw"],
Cell[318768, 11826, 101, 3, 21, "Output",
  CellTags->"General::shdw"]
}, Open  ]],

Cell[CellGroupData[{
Cell[318906, 11834, 349, 8, 74, "Input",
  CellTags->"General::shdw"],
Cell[319258, 11844, 95, 3, 21, "Output",
  CellTags->"General::shdw"]
}, Open  ]],

Cell[CellGroupData[{
Cell[319390, 11852, 102, 3, 26, "Input",
  CellTags->"General::shdw"],
Cell[319495, 11857, 318, 6, 53, "Message",
  CellTags->"General::shdw"],
Cell[319816, 11865, 298, 6, 37, "Message",
  CellTags->"General::shdw"]
}, Open  ]],
Cell[320129, 11874, 160, 4, 24, "Text",
  CellTags->"General::shdw"],

Cell[CellGroupData[{
Cell[320314, 11882, 105, 3, 26, "Input",
  CellTags->"General::shdw"],
Cell[320422, 11887, 96, 3, 21, "Output",
  CellTags->"General::shdw"]
}, Open  ]],
Cell[320533, 11893, 162, 4, 24, "Text",
  CellTags->"General::shdw"],

Cell[CellGroupData[{
Cell[320720, 11901, 100, 3, 26, "Input",
  CellTags->"General::shdw"],
Cell[320823, 11906, 101, 3, 21, "Output",
  CellTags->"General::shdw"]
}, Open  ]],
Cell[320939, 11912, 177, 7, 24, "Text",
  CellTags->"General::shdw"],
Cell[321119, 11921, 105, 3, 26, "Input",
  CellTags->"General::shdw"],
Cell[321227, 11926, 138, 4, 24, "Text",
  CellTags->"General::shdw"],

Cell[CellGroupData[{
Cell[321390, 11934, 101, 3, 26, "Input",
  CellTags->"General::shdw"],
Cell[321494, 11939, 97, 3, 21, "Output",
  CellTags->"General::shdw"]
}, Open  ]],
Cell[321606, 11945, 66, 1, 24, "Text",
  CellTags->"General::shdw"],
Cell[321675, 11948, 111, 3, 26, "Input",
  CellTags->"General::shdw"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[321835, 11957, 77, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::tag"],
Cell[321915, 11960, 487, 16, 21, "Message",
  CellTags->"General::tag"],
Cell[322405, 11978, 702, 21, 84, "Notes",
  CellTags->"General::tag"],

Cell[CellGroupData[{
Cell[323132, 12003, 62, 1, 38, "ExampleSection",
  CellTags->"General::tag"],
Cell[323197, 12006, 263, 9, 24, "Text",
  CellTags->"General::tag"],

Cell[CellGroupData[{
Cell[323485, 12019, 134, 3, 26, "Input",
  CellTags->"General::tag"],
Cell[323622, 12024, 240, 5, 37, "Message",
  CellTags->"General::tag"],
Cell[323865, 12031, 94, 3, 21, "Output",
  CellTags->"General::tag"]
}, Open  ]],
Cell[323974, 12037, 115, 4, 24, "Text",
  CellTags->"General::tag"],

Cell[CellGroupData[{
Cell[324114, 12045, 120, 3, 26, "Input",
  CellTags->"General::tag"],
Cell[324237, 12050, 94, 3, 21, "Output",
  CellTags->"General::tag"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[324392, 12060, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::trace"],
Cell[324476, 12063, 395, 14, 21, "Message",
  CellTags->"General::trace"],
Cell[324874, 12079, 296, 8, 46, "Notes",
  CellTags->"General::trace"],

Cell[CellGroupData[{
Cell[325195, 12091, 64, 1, 38, "ExampleSection",
  CellTags->"General::trace"],
Cell[325262, 12094, 87, 1, 24, "Text",
  CellTags->"General::trace"],
Cell[325352, 12097, 94, 3, 26, "Input",
  CellTags->"General::trace"],

Cell[CellGroupData[{
Cell[325471, 12104, 138, 3, 26, "Input",
  CellTags->"General::trace"],
Cell[325612, 12109, 233, 5, 21, "Message",
  CellTags->"General::trace"],
Cell[325848, 12116, 294, 6, 21, "Message",
  CellTags->"General::trace"],
Cell[326145, 12124, 185, 4, 21, "Message",
  CellTags->"General::trace"],
Cell[326333, 12130, 90, 3, 21, "Output",
  CellTags->"General::trace"]
}, Open  ]],
Cell[326438, 12136, 115, 5, 24, "Text",
  CellTags->"General::trace"],
Cell[326556, 12143, 95, 3, 26, "Input",
  CellTags->"General::trace"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[326700, 12152, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::write"],
Cell[326784, 12155, 409, 12, 21, "Message",
  CellTags->"General::write"],
Cell[327196, 12169, 469, 13, 68, "Notes",
  CellTags->"General::write"],

Cell[CellGroupData[{
Cell[327690, 12186, 64, 1, 38, "ExampleSection",
  CellTags->"General::write"],
Cell[327757, 12189, 323, 10, 40, "Text",
  CellTags->"General::write"],

Cell[CellGroupData[{
Cell[328105, 12203, 98, 3, 26, "Input",
  CellTags->"General::write"],
Cell[328206, 12208, 176, 4, 21, "Message",
  CellTags->"General::write"],
Cell[328385, 12214, 90, 3, 21, "Output",
  CellTags->"General::write"]
}, Open  ]],
Cell[328490, 12220, 138, 4, 24, "Text",
  CellTags->"General::write"],

Cell[CellGroupData[{
Cell[328653, 12228, 106, 3, 26, "Input",
  CellTags->"General::write"],
Cell[328762, 12233, 176, 4, 21, "Message",
  CellTags->"General::write"],
Cell[328941, 12239, 171, 4, 21, "Message",
  CellTags->"General::write"],
Cell[329115, 12245, 100, 3, 21, "Output",
  CellTags->"General::write"]
}, Open  ]],
Cell[329230, 12251, 263, 11, 24, "Text",
  CellTags->"General::write"],

Cell[CellGroupData[{
Cell[329518, 12266, 107, 3, 26, "Input",
  CellTags->"General::write"],
Cell[329628, 12271, 103, 3, 21, "Output",
  CellTags->"General::write"]
}, Open  ]],
Cell[329746, 12277, 380, 11, 40, "Text",
  CellTags->"General::write"],

Cell[CellGroupData[{
Cell[330151, 12292, 113, 3, 26, "Input",
  CellTags->"General::write"],
Cell[330267, 12297, 174, 4, 21, "Message",
  CellTags->"General::write"],
Cell[330444, 12303, 112, 3, 21, "Output",
  CellTags->"General::write"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[330617, 12313, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::wrsym"],
Cell[330701, 12316, 318, 9, 21, "Message",
  CellTags->"General::wrsym"],
Cell[331022, 12327, 267, 7, 46, "Notes",
  CellTags->"General::wrsym"],

Cell[CellGroupData[{
Cell[331314, 12338, 64, 1, 38, "ExampleSection",
  CellTags->"General::wrsym"],
Cell[331381, 12341, 135, 5, 24, "Text",
  CellTags->"General::wrsym"],

Cell[CellGroupData[{
Cell[331541, 12350, 102, 3, 26, "Input",
  CellTags->"General::wrsym"],
Cell[331646, 12355, 163, 4, 21, "Message",
  CellTags->"General::wrsym"],
Cell[331812, 12361, 96, 3, 21, "Output",
  CellTags->"General::wrsym"]
}, Open  ]],
Cell[331923, 12367, 175, 7, 24, "Text",
  CellTags->"General::wrsym"],

Cell[CellGroupData[{
Cell[332123, 12378, 103, 3, 26, "Input",
  CellTags->"General::wrsym"],
Cell[332229, 12383, 107, 3, 21, "Output",
  CellTags->"General::wrsym"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[332397, 12393, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::shdwcor"],
Cell[332485, 12396, 656, 19, 37, "Message",
  CellTags->"General::shdwcor"],
Cell[333144, 12417, 263, 6, 46, "Notes",
  CellTags->"General::shdwcor"]
}, Open  ]],

Cell[CellGroupData[{
Cell[333444, 12428, 136, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
Cell[333583, 12434, 487, 14, 21, "Message",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
Cell[334073, 12450, 272, 7, 24, "Notes",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],

Cell[CellGroupData[{
Cell[334370, 12461, 90, 1, 38, "ExampleSection",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
Cell[334463, 12464, 223, 5, 40, "Text",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],

Cell[CellGroupData[{
Cell[334711, 12473, 182, 4, 26, "Input",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
Cell[334896, 12479, 337, 6, 37, "Message",
  CellTags->{"NestWhileList::nres", "NestWhile::nres"}],
Cell[335236, 12487, 116, 3, 21, "Output",
  CellTags->{"NestWhileList::nres", "NestWhile::nres"}]
}, Open  ]],
Cell[335367, 12493, 178, 5, 24, "Text",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],

Cell[CellGroupData[{
Cell[335570, 12502, 181, 4, 26, "Input",
  CellTags->{"NestWhile::nres", "NestWhileList::nres"}],
Cell[335754, 12508, 120, 3, 21, "Output",
  CellTags->{"NestWhileList::nres", "NestWhile::nres"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[335935, 12518, 144, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
Cell[336082, 12524, 675, 17, 37, "Message",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
Cell[336760, 12543, 292, 7, 40, "Notes",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],

Cell[CellGroupData[{
Cell[337077, 12554, 94, 1, 38, "ExampleSection",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
Cell[337174, 12557, 238, 5, 40, "Text",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],

Cell[CellGroupData[{
Cell[337437, 12566, 167, 3, 26, "Input",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
Cell[337607, 12571, 392, 7, 69, "Message",
  CellTags->{"NestWhileList::nwargs", "NestWhile::nwargs"}],
Cell[338002, 12580, 158, 3, 21, "Output",
  CellTags->{"NestWhileList::nwargs", "NestWhile::nwargs"}]
}, Open  ]],
Cell[338175, 12586, 164, 5, 24, "Text",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],

Cell[CellGroupData[{
Cell[338364, 12595, 167, 3, 26, "Input",
  CellTags->{"NestWhile::nwargs", "NestWhileList::nwargs"}],
Cell[338534, 12600, 159, 3, 21, "Output",
  CellTags->{"NestWhileList::nwargs", "NestWhile::nwargs"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[338754, 12610, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Pattern::patvar"],
Cell[338840, 12613, 198, 5, 21, "Message",
  CellTags->"Pattern::patvar"],
Cell[339041, 12620, 305, 6, 46, "Notes",
  CellTags->"Pattern::patvar"],

Cell[CellGroupData[{
Cell[339371, 12630, 65, 1, 38, "ExampleSection",
  CellTags->"Pattern::patvar"],
Cell[339439, 12633, 146, 4, 24, "Text",
  CellTags->"Pattern::patvar"],

Cell[CellGroupData[{
Cell[339610, 12641, 136, 3, 26, "Input",
  CellTags->"Pattern::patvar"],
Cell[339749, 12646, 222, 5, 37, "Message",
  CellTags->"Pattern::patvar"],
Cell[339974, 12653, 98, 3, 21, "Output",
  CellTags->"Pattern::patvar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[340133, 12663, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Set::patset"],
Cell[340211, 12666, 236, 5, 37, "Message",
  CellTags->"Set::patset"],
Cell[340450, 12673, 801, 21, 106, "Notes",
  CellTags->"Set::patset"],

Cell[CellGroupData[{
Cell[341276, 12698, 61, 1, 38, "ExampleSection",
  CellTags->"Set::patset"],
Cell[341340, 12701, 302, 7, 40, "Text",
  CellTags->"Set::patset"],

Cell[CellGroupData[{
Cell[341667, 12712, 91, 3, 26, "Input",
  CellTags->"Set::patset"],
Cell[341761, 12717, 251, 5, 37, "Message",
  CellTags->"Set::patset"],
Cell[342015, 12724, 86, 3, 21, "Output",
  CellTags->"Set::patset"]
}, Open  ]],
Cell[342116, 12730, 97, 1, 24, "Text",
  CellTags->"Set::patset"],

Cell[CellGroupData[{
Cell[342238, 12735, 94, 3, 26, "Input",
  CellTags->"Set::patset"],
Cell[342335, 12740, 86, 3, 21, "Output",
  CellTags->"Set::patset"]
}, Open  ]],
Cell[342436, 12746, 122, 5, 24, "Text",
  CellTags->"Set::patset"],
Cell[342561, 12753, 92, 3, 26, "Input",
  CellTags->"Set::patset"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[342702, 12762, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Switch::argct"],
Cell[342784, 12765, 225, 5, 37, "Message",
  CellTags->"Switch::argct"],
Cell[343012, 12772, 178, 5, 24, "Notes",
  CellTags->"Switch::argct"],

Cell[CellGroupData[{
Cell[343215, 12781, 63, 1, 38, "ExampleSection",
  CellTags->"Switch::argct"],
Cell[343281, 12784, 177, 5, 24, "Text",
  CellTags->"Switch::argct"],

Cell[CellGroupData[{
Cell[343483, 12793, 115, 3, 26, "Input",
  CellTags->"Switch::argct"],
Cell[343601, 12798, 228, 5, 37, "Message",
  CellTags->"Switch::argct"],
Cell[343832, 12805, 119, 3, 21, "Output",
  CellTags->"Switch::argct"]
}, Open  ]],
Cell[343966, 12811, 126, 5, 24, "Text",
  CellTags->"Switch::argct"],

Cell[CellGroupData[{
Cell[344117, 12820, 115, 3, 26, "Input",
  CellTags->"Switch::argct"],
Cell[344235, 12825, 88, 3, 21, "Output",
  CellTags->"Switch::argct"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[344384, 12835, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Syntax::stresc"],
Cell[344468, 12838, 165, 4, 21, "Message",
  CellTags->"Syntax::stresc"],
Cell[344636, 12844, 125, 4, 24, "Notes",
  CellTags->"Syntax::stresc"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

