(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     53614,       1932]*)
(*NotebookOutlinePosition[     88287,       2788]*)
(*  CellTagsIndexPosition[     86092,       2726]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["System Interface", "Title"],

Cell[CellGroupData[{

Cell["$BatchInput::bitf", "ObjectNameWarningMessages",
  CellTags->"$BatchInput::bitf"],

Cell[BoxData[
    \($BatchInput::"bitf" \(\(:\)\(\ \)\) 
      "Cannot set `1` to `2`; value must be True or False."\)], "Message",
  CellLabel->"From In[11]:=",
  CellTags->"$BatchInput::bitf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set the value of ",
  StyleBox["$BatchInput", "MR"],
  " to something other than ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  "."
}], "Notes",
  CellTags->"$BatchInput::bitf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$BatchInput::bitf"],

Cell[TextData[{
  "The value of ",
  StyleBox["$BatchInput", "MR"],
  " can only be sent to an expression that is explicitly ",
  StyleBox["True", "MR"],
  " or ",
  StyleBox["False", "MR"],
  ".  The value of ",
  StyleBox["$BatchInput", "MR"],
  " is otherwise left unchanged."
}], "Text",
  CellTags->"$BatchInput::bitf"],

Cell[CellGroupData[{

Cell[BoxData[
    \($BatchInput := If[$Remote, False, True]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$BatchInput::bitf"],

Cell[BoxData[
    \($BatchInput::"bitf" \(\(:\)\(\ \)\) 
      "Cannot set \!\($BatchInput\) to \!\(If[\(\($Remote, False, \
True\)\)]\); value must be True or False."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$BatchInput::bitf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$HistoryLength::limset", "ObjectNameWarningMessages",
  CellTags->"$HistoryLength::limset"],

Cell[BoxData[
    RowBox[{\($HistoryLength::"limset"\), \(\(:\)\(\ \)\), \(\(Cannot\)\(\ \)\
\(set\)\(\ \)\($HistoryLength\)\(\ \)\(to\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(;\)\(\ \)\(value\ must\ be\ Infinity\ or\ a\ non - 
        negative\ machine - size\ \(\(integer\)\(.\)\)\)\)}]], "Message",
  CellTags->"$HistoryLength::limset"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to assign to ",
  StyleBox["$HistoryLength", "MR"],
  " a value that does not have the indicated form."
}], "Notes",
  CellTags->"$HistoryLength::limset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$HistoryLength::limset"],

Cell[TextData[{
  "The integer in this example is too large to be represented as a machine \
integer.  The value of ",
  StyleBox["$HistoryLength", "MR"],
  " can be set to ",
  StyleBox["Infinity", "MR"],
  "."
}], "Text",
  CellTags->"$HistoryLength::limset"],

Cell[CellGroupData[{

Cell[BoxData[
    \($HistoryLength = 10^50\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$HistoryLength::limset"],

Cell[BoxData[
    \($HistoryLength::"limset" \(\(:\)\(\ \)\) 
      "Cannot set $HistoryLength to \
\!\(100000000000000000000000000000000000000000000000000\); value must be \
Infinity or a non-negative machine-size integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$HistoryLength::limset"],

Cell[BoxData[
    \(100000000000000000000000000000000000000000000000000\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$HistoryLength::limset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ResetDirectory::dtop", "ObjectNameWarningMessages",
  CellTags->"ResetDirectory::dtop"],

Cell[BoxData[
    \(ResetDirectory::"dtop" \(\(:\)\(\ \)\) \(Directory\ stack\ is\ \
\(\(empty\)\(.\)\)\)\)], "Message",
  CellTags->"ResetDirectory::dtop"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by ",
  StyleBox["ResetDirectory", "MR"],
  " if there has not been a corresponding ",
  StyleBox["SetDirectory", "MR"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["SetDirectory", "MR"],
  " sets the working directory and saves the previous working directory on a \
stack.  ",
  StyleBox["ResetDirectory", "MR"],
  " restores the most recently saved directory."
}], "Notes",
  CellTags->"ResetDirectory::dtop"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ResetDirectory::dtop"],

Cell[TextData[{
  "Evaluation of ",
  StyleBox["ResetDirectory[]", "MR"],
  " without a corresponding ",
  StyleBox["SetDirectory", "MR"],
  " generates a warning message and leaves the current directory unchanged."
}], "Text",
  CellTags->"ResetDirectory::dtop"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ResetDirectory[]\ ;\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ResetDirectory::dtop"],

Cell[BoxData[
    \(ResetDirectory::"dtop" \(\(:\)\(\ \)\) 
      "Directory stack is empty."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ResetDirectory::dtop"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetFileDate::fdate", "ObjectNameWarningMessages",
  CellTags->"SetFileDate::fdate"],

Cell[BoxData[
    \(SetFileDate::"fdate" \(\(:\)\(\ \)\) 
      "Date specification should be either the number of seconds since Jan 1, \
1900, or a {y, m, d, h, m, s} list."\)], "Message",
  CellTags->"SetFileDate::fdate"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["SetFileDate", "MR"],
  " is neither an integer nor a list."
}], "Notes",
  CellTags->"SetFileDate::fdate"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"SetFileDate::fdate"],

Cell[TextData[{
  "The second argument in ",
  StyleBox["SetFileDate", "MR"],
  " is expected to evaluate either to an integer or to a list of six \
integers."
}], "Text",
  CellTags->"SetFileDate::fdate"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetFileDate["\<file\>", \ Date]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"SetFileDate::fdate"],

Cell[BoxData[
    \(SetFileDate::"fdate" \(\(:\)\(\ \)\) 
      "Date specification should be either the number of seconds since Jan 1, \
1900, or a {y, m, d, h, m, s} list."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"SetFileDate::fdate"],

Cell[BoxData[
    \(SetFileDate["file", Date]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"SetFileDate::fdate"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$ParentLink::lnset", "ObjectNameWarningMessages",
  CellTags->"$ParentLink::lnset"],

Cell[BoxData[
    RowBox[{\($ParentLink::"lnset"\), \(\(:\)\(\ \)\), \(\(Cannot\)\(\ \
\)\(set\)\(\ \)\($ParentLink\)\(\ \)\(to\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(;\)\(\ \)\(value\ is\ not\ a\ \
\(\(LinkObject\)\(.\)\)\)\)}]], "Message",
  CellTags->"$ParentLink::lnset"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to set the value of ",
  StyleBox["$ParentLink", "MR"],
  " to an expression that does not have a head of ",
  StyleBox["LinkObject", "MR"],
  " and is not ",
  StyleBox["Null", "MR"],
  "."
}], "Notes",
  CellTags->"$ParentLink::lnset"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$ParentLink::lnset"],

Cell[TextData[{
  "The value of ",
  StyleBox["$ParentLink", "MR"],
  " is expected to be a valid ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " ",
  StyleBox["LinkObject", "MR"],
  " expression.  When this error occurs, the value of ",
  StyleBox["$ParentLink", "MR"],
  " is left unchanged."
}], "Text",
  CellTags->"$ParentLink::lnset"],

Cell[CellGroupData[{

Cell[BoxData[
    \($ParentLink = {}\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"$ParentLink::lnset"],

Cell[BoxData[
    \($ParentLink::"lnset" \(\(:\)\(\ \)\) 
      "Cannot set $ParentLink to \!\({}\); value is not a LinkObject."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"$ParentLink::lnset"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$ParentLink::lnset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$ParentLink::notfe", "ObjectNameWarningMessages",
  CellTags->"$ParentLink::notfe"],

Cell[BoxData[
    RowBox[{\($ParentLink::"notfe"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(has\ refused\ the\ responsibility\ of\ \
\(\($ParentLink\)\(.\)\)\)\)}]], "Message",
  CellTags->"$ParentLink::notfe"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by direct or indirect attempts to cause an \
",
  StyleBox["mprep", "MR"],
  " ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " program to handle input and output, such as by sending a ",
  StyleBox["CallPacket", "MR"],
  " expression to that program.\n\[FilledSmallSquare] This message is sent \
from ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " programs produced using ",
  StyleBox["mprep", "MR"],
  ".\n\[FilledSmallSquare] The origin of this message can be understood by \
looking at the output of ",
  StyleBox["mprep", "MR"],
  "."
}], "Notes",
  CellTags->"$ParentLink::notfe"]
}, Open  ]],

Cell[CellGroupData[{

Cell["$PreRead::prstr", "ObjectNameWarningMessages",
  CellTags->"$PreRead::prstr"],

Cell[BoxData[
    \($PreRead::"prstr" \(\(:\)\(\ \)\) 
      "$PreRead[\"`1`\"] results in `2`, which is not a string."\)], "Message",\

  CellLabel->"From In[11]:=",
  CellTags->"$PreRead::prstr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the result of applying the value of ",
  StyleBox["$PreRead", "MR"],
  " to interactive ",
  StyleBox["InputForm", "MR"],
  " input is not a string.\n\[FilledSmallSquare] The result of applying ",
  StyleBox["$PreRead", "MR"],
  " to input is normally expected to have the same type as the original \
input.  For example, the result of applying ",
  StyleBox["$PreRead", "MR"],
  " to typeset boxes, such as from a ",
  StyleBox["StandardForm", "MR"],
  " cell, is expected to consist of typeset boxes.\n\[FilledSmallSquare] The \
result of applying ",
  StyleBox["$PreRead", "MR"],
  " to ",
  StyleBox["InputForm", "MR"],
  " input is expected to be a string."
}], "Notes",
  CellTags->"$PreRead::prstr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$PreRead::prstr"],

Cell[TextData[{
  "Evaluation of this ",
  StyleBox["InputForm", "MR"],
  " input cell will generate a warning message."
}], "Text",
  CellTags->"$PreRead::prstr"],

Cell[CellGroupData[{

Cell["$PreRead = 0", "Input",
  CellLabel->"In[1]:=",
  CellTags->"$PreRead::prstr"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$PreRead::prstr"],

Cell[BoxData[
    \($PreRead::"prstr" \(\(:\)\(\ \)\) 
      "$PreRead[\"\!\(\"\"\)\"] results in \!\(0[\"\"]\), which is not a \
string."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"$PreRead::prstr"]
}, Open  ]],

Cell[TextData[{
  "You can recover from this error by clearing the value of ",
  StyleBox["$PreRead", "MR"],
  ".  A similar message is generated when this input is processed."
}], "Text",
  CellTags->"$PreRead::prstr"],

Cell[CellGroupData[{

Cell["Clear[$PreRead]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"$PreRead::prstr"],

Cell[BoxData[
    \($PreRead::"prstr" \(\(:\)\(\ \)\) 
      "$PreRead[\"\!\(\"Clear[$PreRead]\"\)\"] results in \
\!\(0[\"Clear[$PreRead]\"]\), which is not a string."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"$PreRead::prstr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$SyntaxHandler::sntxh", "ObjectNameWarningMessages",
  CellTags->"$SyntaxHandler::sntxh"],

Cell[BoxData[
    RowBox[{\($SyntaxHandler::"sntxh"\), \(\(:\)\(\ \)\), \
\(\($SyntaxHandler\)\(\ \)\(returned\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(,\)\(\ \)\(which\ is\ not\ a\ string\ or\ \(\($Failed\)\(.\
\)\)\)\)}]], "Message",
  CellTags->"$SyntaxHandler::sntxh"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the result of applying the value of ",
  StyleBox["$SyntaxHandler", "MR"],
  " to an ",
  StyleBox["InputForm", "MR"],
  " input string is not a string or ",
  StyleBox["$Failed", "MR"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["$SyntaxHandler", "MR"],
  " is intended for use with the text-based interface to the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel, where it can be used to modify an input string so that the input \
can be re-edited.  ",
  StyleBox["$SyntaxHandler", "MR"],
  " is not generally useful with the notebook front end."
}], "Notes",
  CellTags->"$SyntaxHandler::sntxh"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"$SyntaxHandler::sntxh"],

Cell[TextData[{
  "This value of ",
  StyleBox["$SyntaxHandler", "MR"],
  " will return ",
  StyleBox["Null", "MR"],
  " when it is applied."
}], "Text",
  CellTags->"$SyntaxHandler::sntxh"],

Cell[CellGroupData[{

Cell["$SyntaxHandler = Null &", "Input",
  CellLabel->"In[1]:=",
  CellTags->"$SyntaxHandler::sntxh"],

Cell[BoxData[
    \(Null &\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"$SyntaxHandler::sntxh"]
}, Open  ]],

Cell[TextData[{
  "Entering this ",
  StyleBox["InputForm", "MR"],
  " input will generate both a syntax message and a message indicating the \
invalid return value from ",
  StyleBox["$SyntaxHandler", "MR"],
  ".  The input will not be evaluated."
}], "Text",
  CellTags->"$SyntaxHandler::sntxh"],

Cell[CellGroupData[{

Cell["g[)", "Input",
  CellLabel->"In[2]:=",
  CellTags->"$SyntaxHandler::sntxh"],

Cell["Syntax::bktmch: \"g[\" must be followed by \"]\", not \")\".", "Message",
  CellLabel->"From In[2]:=",
  CellTags->"$SyntaxHandler::sntxh"],

Cell[BoxData[
    \($SyntaxHandler::"sntxh" \(\(:\)\(\ \)\) 
      "$SyntaxHandler returned \!\(Null\), which is not a string or $Failed."\
\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"$SyntaxHandler::sntxh"]
}, Open  ]],

Cell[TextData[{
  "Clear the value of ",
  StyleBox["$SyntaxHandler", "MR"],
  "."
}], "Text",
  CellTags->"$SyntaxHandler::sntxh"],

Cell["Clear[$SyntaxHandler]", "Input",
  CellLabel->"In[2]:=",
  CellTags->"$SyntaxHandler::sntxh"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
CopyDirectory::dirne
DeleteDirectory::dirne
RenameDirectory::dirne\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "CopyDirectory::dirne", "DeleteDirectory::dirne", "RenameDirectory::dirne"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"dirne\"\>"}], \(\(:\)\(\ \)\), "Directory", " ", 
      StyleBox["expr",
        "TI"], " ", "not", " ", \(\(empty\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "CopyDirectory::dirne", "DeleteDirectory::dirne", "RenameDirectory::dirne"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to delete a directory or \
folder that is not empty.\n\[FilledSmallSquare] If the ",
  StyleBox["DeleteContents", "MR"],
  " option is set to ",
  StyleBox["True", "MR"],
  ", then the contents of a directory that is not empty will be deleted \
automatically."
}], "Notes",
  CellTags->{
  "CopyDirectory::dirne", "DeleteDirectory::dirne", "RenameDirectory::dirne"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
CopyDirectory::filex
CopyFile::filex
RenameDirectory::filex
RenameFile::filex\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
    "RenameFile::filex"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"filex\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "overwrite", " ", "existing", " ", "file", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
    "RenameFile::filex"}],

Cell["\<\
\[FilledSmallSquare] Generated when a file operation will cause an \
existing file or directory to be overwritten.
\[FilledSmallSquare] To overwrite an existing file, first delete that file.\
\
\>", "Notes",
  CellTags->{
  "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
    "RenameFile::filex"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
CopyDirectory::nodir
DeleteDirectory::nodir
RenameDirectory::nodir\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "CopyDirectory::nodir", "DeleteDirectory::nodir", "RenameDirectory::nodir"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nodir\"\>"}], \(\(:\)\(\ \)\), "Directory", " ", 
      StyleBox["expr",
        "TI"], " ", "not", " ", \(\(found\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "CopyDirectory::nodir", "DeleteDirectory::nodir", "RenameDirectory::nodir"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a requested directory or folder is not \
found in the part of the file system that is checked by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel."
}], "Notes",
  CellTags->{
  "CopyDirectory::nodir", "DeleteDirectory::nodir", "RenameDirectory::nodir"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
CopyFile::fdir
DeleteFile::fdir
Export::fdir
Get::fdir
RenameFile::fdir\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
    "RenameFile::fdir"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["function",
            "TI"], "::", "\<\"fdir\"\>"}], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], " ", "is", " ", "a", " ", "directory"}]}], ";", 
      " ", \(a\ file\ is\ \(\(expected\)\(.\)\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
    "RenameFile::fdir"}],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated name corresponds \
to a directory rather than a file.\
\>", "Notes",
  CellTags->{
  "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
    "RenameFile::fdir"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Directory::dirx", "ObjectNameWarningMessages",
  CellTags->"Directory::dirx"],

Cell[BoxData[
    RowBox[{\(Directory::"dirx"\), \(\(:\)\(\ \)\), 
      StyleBox["expr",
        "TI"]}]], "Message",
  CellTags->"Directory::dirx"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"Directory::dirx"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
FileNames::cdir
ParentDirectory::cdir
ResetDirectory::cdir
SetDirectory::cdir\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"cdir\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "set", " ", "current", " ", "directory", " ", "to", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a specified directory cannot be used \
as the current directory.\n\[FilledSmallSquare] If this error occurs, check \
that the name of the directory has been spelled correctly and that the name \
uses format and punctuation appropriate for your computer.\n\
\[FilledSmallSquare] Some operations by functions such as ",
  StyleBox["FileNames", "MR"],
  " involve temporarily changing the current directory."
}], "Notes",
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}],

Cell["\<\
An error occurs in this example if there is no directory with the \
specified name on this computer.\
\>", "Text",
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(SetDirectory["\<NODIR\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}],

Cell[BoxData[
    \(SetDirectory::"cdir" \(\(:\)\(\ \)\) 
      "Cannot set current directory to \!\(\"NODIR\"\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["FromDate::fdls", "ObjectNameWarningMessages",
  CellTags->"FromDate::fdls"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(FromDate::"fdls"\), \(\(:\)\(\ \)\), 
        StyleBox["expr",
          "TI"], " ", "is", " ", "neither", " ", "a", " ", "list", " ", "of", 
        " ", "6", " ", "machine"}], 
      "-", \(size\ integers\ nor\ a\ list\ of\ 5\ machine\), 
      "-", \(size\ integers\ followed\ by\ a\ real\ \(\(number\)\(.\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"FromDate::fdls"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the argument in ",
  StyleBox["FromDate", "MR"],
  " does not have the indicated form."
}], "Notes",
  CellTags->"FromDate::fdls"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"FromDate::fdls"],

Cell["\<\
An error occurs in this example because the argument is not a list \
with six elements.\
\>", "Text",
  CellTags->"FromDate::fdls"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FromDate[{1984, 6, 9, 2, 21}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"FromDate::fdls"],

Cell[BoxData[
    \(FromDate::"fdls" \(\(:\)\(\ \)\) 
      "\!\({1984, 6, 9, 2, 21}\) is neither a list of 6 machine-size integers \
nor a list of 5 machine-size integers followed by a real number."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"FromDate::fdls"],

Cell[BoxData[
    \(FromDate[{1984, 6, 9, 2, 21}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"FromDate::fdls"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["FromDate", "MR"],
  "."
}], "Text",
  CellTags->"FromDate::fdls"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FromDate[{1984, 6, 9, 2, 21, 0}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"FromDate::fdls"],

Cell[BoxData[
    \(2664584460\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"FromDate::fdls"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::globn", "ObjectNameWarningMessages",
  CellTags->"General::globn"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"globn\"\>"}], \(\(:\)\(\ \)\), "No", " ", 
      "matches", " ", "for", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::globn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when no files or directories are found that \
match a string specified using \[OpenCurlyDoubleQuote]glob\
\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]wild card\
\[CloseCurlyDoubleQuote] characters.\n\[FilledSmallSquare] This message is \
used only in Unix versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::globn"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::globf", "ObjectNameWarningMessages",
  CellTags->"General::globf"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"globf\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "open", " ", "object", " ", "obtained", " ", "by", " ", "expansion", 
      " ", "of", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::globf"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a file specified using \
\[OpenCurlyDoubleQuote]glob\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]wild card\[CloseCurlyDoubleQuote] characters could not \
be opened.\n\[FilledSmallSquare] This message is used only in Unix versions \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::globf"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::globf"],

Cell[TextData[{
  "An error occurs in this example if there is not a file that matches the \
name specified in the first argument of ",
  StyleBox["Find", "MR"],
  "."
}], "Text",
  CellTags->"General::globf"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Find["\<*NOFILE\>", "\<text\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::globf"],

Cell[BoxData[
    \(General::"globf" \(\(:\)\(\ \)\) 
      "Cannot open object obtained by expansion of \!\(\"*NOFILE\"\)."\)], \
"Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::globf"],

Cell[BoxData[
    \(Find::"openx" \(\(:\)\(\ \)\) 
      "\!\(\"*NOFILE\"\) is not open."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::globf"],

Cell[BoxData[
    \(Find["*NOFILE", "text"]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::globf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::globm", "ObjectNameWarningMessages",
  CellTags->"General::globm"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"globm\"\>"}], \(\(:\)\(\ \)\), "Too", " ", "many",
       " ", "matches", " ", "for", " ", 
      RowBox[{
        StyleBox["spec",
          "TI"], ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::globm"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when no files or directories are found that \
match a string specified using \[OpenCurlyDoubleQuote]glob\
\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]wild card\
\[CloseCurlyDoubleQuote] characters.\n\[FilledSmallSquare] This message is \
used only in Unix versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::globm"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
RenameDirectory::redev
RenameFile::redev\
\>", "ObjectNameWarningMessages",
  CellTags->{"RenameDirectory::redev", "RenameFile::redev"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          RowBox[{
            StyleBox["function",
              "TI"], 
            "::", "\<\"redev\"\>"}], \(\(:\)\(\ \)\), \(Cannot\ rename\ to\ a\
\ different\ physical\ device\)}], ";", " ", 
        RowBox[{
          StyleBox["f1",
            "TI"], " ", "will", " ", "be", " ", "copied", " ", "to", " ", 
          StyleBox["f2",
            "TI"]}]}], ",", 
      " ", \(and\ the\ original\ will\ be\ \(\(deleted\)\(.\)\)\)}]], \
"Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"RenameDirectory::redev", "RenameFile::redev"}],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the new file or directory name in ",
  StyleBox["RenameDirectory", "MR"],
  " or ",
  StyleBox["RenameFile", "MR"],
  " is not on the same physical device as the original file or directory in \
your computer system.\n\[FilledSmallSquare] This message is advisory and does \
not necessarily represent an error."
}], "Notes",
  CellTags->{"RenameDirectory::redev", "RenameFile::redev"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["RenameFile::renfd", "ObjectNameWarningMessages",
  CellTags->"RenameFile::renfd"],

Cell[BoxData[
    \(RenameFile::"renfd" \(\(:\)\(\ \)\) \(Cannot\ rename\ a\ file\ into\ a\ \
\(\(directory\)\(.\)\)\)\)], "Message",
  CellTags->"RenameFile::renfd"],

Cell["\<\
\[FilledSmallSquare] Generated by a request to change a file into a \
directory.
\[FilledSmallSquare] This message is a response to a corresponding message \
generated by the operating system of your computer.\
\>", "Notes",
  CellTags->"RenameFile::renfd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Run::shell", "ObjectNameWarningMessages",
  CellTags->"Run::shell"],

Cell[BoxData[
    \(Run::"shell" \(\(:\)\(\ \)\) \(Cannot\ execute\ \
\(\(shell\)\(.\)\)\)\)], "Message",
  CellTags->"Run::shell"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a ",
  StyleBox["Run", "MR"],
  " instruction cannot be executed.\n\[FilledSmallSquare] This message is a \
response to the return code of the corresponding ",
  StyleBox["system", "MR"],
  " function on your computer."
}], "Notes",
  CellTags->"Run::shell"]
}, Open  ]],

Cell[CellGroupData[{

Cell["TimeConstrained::timc", "ObjectNameWarningMessages",
  CellTags->"TimeConstrained::timc"],

Cell[BoxData[
    RowBox[{\(TimeConstrained::"timc"\), \(\(:\)\(\ \)\), \(\(Number\)\(\ \
\)\(of\)\(\ \)\(seconds\)\(\ \)\), 
      StyleBox["expr",
        "TI"], \(\(\ \)\(is\ not\ a\ positive\ \(\(integer\)\(.\)\)\)\)}]], \
"Message",
  CellTags->"TimeConstrained::timc"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the second argument in ",
  StyleBox["TimeConstrained", "MR"],
  " is not a positive integer."
}], "Notes",
  CellTags->"TimeConstrained::timc"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"TimeConstrained::timc"],

Cell[TextData[{
  "An error occurs in this example because the second argument in ",
  StyleBox["TimeConstrained", "MR"],
  " is not positive."
}], "Text",
  CellTags->"TimeConstrained::timc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TimeConstrained[Do[2 + 2, {10^9}], 0]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"TimeConstrained::timc"],

Cell[BoxData[
    \(TimeConstrained::"timc" \(\(:\)\(\ \)\) 
      "Number of seconds \!\(0\) is not a positive integer."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"TimeConstrained::timc"],

Cell[BoxData[
    \(TimeConstrained[Do[2 + 2, {10\^9}], 0]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"TimeConstrained::timc"]
}, Open  ]],

Cell[TextData[{
  "This example shows valid arguments in ",
  StyleBox["TimeConstrained", "MR"],
  "."
}], "Text",
  CellTags->"TimeConstrained::timc"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TimeConstrained[Do[2 + 2, {10^9}], 1]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"TimeConstrained::timc"],

Cell[BoxData[
    \($Aborted\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"TimeConstrained::timc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToDate::tdn", "ObjectNameWarningMessages",
  CellTags->"ToDate::tdn"],

Cell[BoxData[
    RowBox[{\(ToDate::"tdn"\), \(\(:\)\(\ \)\), \(\(First\)\(\ \)\(argument\)\
\(\ \)\), 
      StyleBox["expr",
        "TI"], " ", "should", " ", "be", " ", "an", " ", "integer", " ", "or",
       " ", "a", " ", "real", " ", \(\(number\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"ToDate::tdn"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the first argument in ",
  StyleBox["ToDate", "MR"],
  " is not an integer."
}], "Notes",
  CellTags->"ToDate::tdn"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"ToDate::tdn"],

Cell["\<\
An error occurs in this example because the argument is a list \
rather than an integer.\
\>", "Text",
  CellTags->"ToDate::tdn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToDate[{1987, 3, 26, 23, 5, 40}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"ToDate::tdn"],

Cell[BoxData[
    \(ToDate::"tdn" \(\(:\)\(\ \)\) 
      "First argument \!\({1987, 3, 26, 23, 5, 40}\) should be an integer or \
a real number."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"ToDate::tdn"],

Cell[BoxData[
    \(ToDate[{1987, 3, 26, 23, 5, 40}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"ToDate::tdn"]
}, Open  ]],

Cell[TextData[{
  "This shows a valid argument in ",
  StyleBox["ToDate", "MR"],
  "."
}], "Text",
  CellTags->"ToDate::tdn"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToDate[2752787140]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"ToDate::tdn"],

Cell[BoxData[
    \({1987, 3, 26, 23, 5, 40.`}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"ToDate::tdn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::dirdep", "ObjectNameWarningMessages",
  CellTags->"General::dirdep"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"dirdep\"\>"}], \(\(:\)\(\ \)\), "Cannot", " ", 
      "get", " ", "deeper", " ", "in", " ", "directory", " ", 
      RowBox[{"tree", ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::dirdep"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated operation would \
cause the depth of nested directories to exceed the depth allowed by the \
operating system of your computer.
\[FilledSmallSquare] This message is a response to a corresponding message \
generated internally by the operating system of your computer.
\[FilledSmallSquare] This message can occur if there are circular directory \
links on your computer.\
\>", "Notes",
  CellTags->"General::dirdep"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::enable", "ObjectNameWarningMessages",
  CellTags->"General::enable"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"enable\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "is", " ", "not", " ", "enabled", " ", "in", " ", 
        "your", " ", "version", " ", "of", 
        " ", \(\(Mathematica\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::enable"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when the indicated operation is not \
available in your copy of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".\n\[FilledSmallSquare] This message is used only in non-standard versions \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that have been prepared for use in special environments."
}], "Notes",
  CellTags->"General::enable"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::fstr", "ObjectNameWarningMessages",
  CellTags->"General::fstr"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"fstr\"\>"}], \(\(:\)\(\ \)\), "File", " ", 
      "specification", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "not", " ", "a", " ", "string", " ", "of", " ",
       "one", " ", "or", " ", "more", 
      " ", \(\(characters\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::fstr"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated expression does \
not have the expected form.
\[FilledSmallSquare] File and directory specifications are given as strings \
with at least one character.\
\>", "Notes",
  CellTags->"General::fstr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::fstr"],

Cell["\<\
An error occurs in this example unless the argument evaluates to a \
string with at least one character.\
\>", "Text",
  CellTags->"General::fstr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FileType[ff]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::fstr"],

Cell[BoxData[
    \(FileType::"fstr" \(\(:\)\(\ \)\) 
      "File specification \!\(ff\) is not a string of one or more \
characters."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::fstr"],

Cell[BoxData[
    \(FileType[ff]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::fstr"]
}, Open  ]],

Cell[TextData[{
  "This shows valid input in ",
  StyleBox["FileType", "MR"],
  "."
}], "Text",
  CellTags->"General::fstr"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FileType[\(FileNames[]\)[\([1]\)]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::fstr"],

Cell[BoxData[
    \(File\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::fstr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::hmdir", "ObjectNameWarningMessages",
  CellTags->"General::hmdir"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"hmdir\"\>"}], \(\(:\)\(\ \)\), "\<\"\\\"~\\\" should be \
followed by \\\"/\\\": only the current user's home directory is supported.\"\
\>"}]], "Message",
  CellLabel->"From In[11]:=",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::hmdir"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  If you see this message in an example where it is not expected, please \
contact Wolfram Research Technical Support."
}], "Notes",
  CellTags->"General::hmdir"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::initstate", "ObjectNameWarningMessages",
  CellTags->"General::initstate"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"initstate\"\>"}], ":", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], " ", "cannot", " ", "be", " ", "used", " ", "during", 
        " ", \(\(initialization\)\(.\)\)}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::initstate"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to perform an operation that \
is not allowed during initialization of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel.\n\[FilledSmallSquare] This message can be generated by \
operations, such as saving files or displaying graphics, that are not allowed \
during early stages of initialization."
}], "Notes",
  CellTags->"General::initstate"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::longp", "ObjectNameWarningMessages",
  CellTags->"General::longp"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"longp\"\>"}], \(\(:\)\(\ \)\), "Pathname", " ", 
      "in", " ", 
      StyleBox["expr",
        "TI"], " ", "is", " ", "too", " ", \(\(long\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::longp"],

Cell["\<\
\[FilledSmallSquare] Generated when the indicated string is too \
long to be used as a pathname on your computer.
\[FilledSmallSquare] This message is a response to a corresponding message \
generated internally by the operating system of your computer.
\[FilledSmallSquare] The limit on the length of a path name is determined by \
the operating system.\
\>", "Notes",
  CellTags->"General::longp"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nfdir", "ObjectNameWarningMessages",
  CellTags->"General::nfdir"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nfdir\"\>"}], \(\(:\)\(\ \)\), "Directory", " ", 
      "not", " ", "found", " ", "during", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nfdir"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a directory needed by the indicated \
operation is not found.\n\[FilledSmallSquare] This message is typically the \
manifestation within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " of a corresponding message generated by the operating system of your \
computer.\n\[FilledSmallSquare] The examples in which this message is \
generated may be different on different computers."
}], "Notes",
  CellTags->"General::nfdir"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::nfdir"],

Cell["\<\
Attempting to copy a file to a directory that does not exist will \
generate this message on some computer systems.\
\>", "Text",
  CellTags->"General::nfdir"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Write["\<nfdir.tst\>", "\<data\>"]; Close["\<nfdir.tst\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::nfdir"],

Cell[BoxData[
    \("nfdir.tst"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::nfdir"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CopyFile["\<nfdir.tst\>", 
      ToFileName["\<nfdir.tst\>", "\<nfdir.tst\>"]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"General::nfdir"],

Cell[BoxData[
    \(CopyFile::"nfdir" \(\(:\)\(\ \)\) 
      "Directory not found during \!\(CopyFile[\(\(\"nfdir.tst\", \
\"nfdir.tst/nfdir.tst\"\)\)]\)."\)], "Message",
  CellLabel->"From In[2]:=",
  CellTags->"General::nfdir"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"General::nfdir"]
}, Open  ]],

Cell["Delete the file.", "Text",
  CellTags->"General::nfdir"],

Cell[BoxData[
    \(DeleteFile["\<nfdir.tst\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"General::nfdir"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::nffil", "ObjectNameWarningMessages",
  CellTags->"General::nffil"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"nffil\"\>"}], \(\(:\)\(\ \)\), "File", " ", "not",
       " ", "found", " ", "during", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::nffil"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a file needed during evaluation of the \
indicated expression was not found.\n\[FilledSmallSquare] This message is a \
response to a corresponding message generated internally by the operating \
system of your computer.\n\[FilledSmallSquare] The directories that are \
searched in attempting to find an external file are listed in the value of \
the global variable ",
  StyleBox["$Path", "MR"],
  "."
}], "Notes",
  CellTags->"General::nffil"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::nffil"],

Cell[TextData[{
  "An error occurs in this example if a file with the specified name is not \
found in any of the directories listed in the value of ",
  StyleBox["$Path", "MR"],
  "."
}], "Text",
  CellTags->"General::nffil"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FileDate["\<NOFILE\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::nffil"],

Cell[BoxData[
    \(FileDate::"nffil" \(\(:\)\(\ \)\) 
      "File not found during \!\(FileDate[\"NOFILE\"]\)."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::nffil"],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::nffil"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::privv", "ObjectNameWarningMessages",
  CellTags->"General::privv"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"privv\"\>"}], \(\(:\)\(\ \)\), "Privilege", " ", 
      "violation", " ", "during", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::privv"],

Cell["\<\
\[FilledSmallSquare] Generated when a privilege violation occurs \
during manipulation of external files or directories.
\[FilledSmallSquare] This message is a response to a corresponding message \
generated internally by the operating system of your computer.  The meaning \
of this message will be different on different types of computers.\
\>", \
"Notes",
  CellTags->"General::privv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::unuser", "ObjectNameWarningMessages",
  CellTags->"General::unuser"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"unuser\"\>"}], \(\(:\)\(\ \)\), "Unknown", " ", 
      RowBox[{"user", ":", " ", 
        RowBox[{
          StyleBox["expr",
            "TI"], "."}]}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::unuser"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when a directory specification describes \
the home directory of a user that is not recognized on this computer system.\n\
\[FilledSmallSquare] The notion of home directory and the syntax used to \
specify a home directory are different under different computer operating \
systems.\n\[FilledSmallSquare] In Unix systems, the syntax \
\[OpenCurlyDoubleQuote]",
  StyleBox["~", "MR"],
  StyleBox["user", "TI"],
  "\[CloseCurlyDoubleQuote] is used to indicate the home directory of ",
  StyleBox["user", "TI"],
  "."
}], "Notes",
  CellTags->"General::unuser"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::addsyms", "ObjectNameWarningMessages",
  CellTags->"General::addsyms"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], "::", "\<\"addsyms\"\>"}], \(\(:\)\(\ \)\), "Autoloading", 
      " ", "file", " ", 
      StyleBox["expr",
        "TI"], " ", "added", " ", "symbols", " ", 
      StyleBox["syms",
        "TI"], " ", \(\((not\ an\ error)\)\(.\)\)}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"General::addsyms"],

Cell[TextData[{
  "\[FilledSmallSquare] This message is not used in the current version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::addsyms"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::autoload", "ObjectNameWarningMessages",
  CellTags->"General::autoload"],

Cell[BoxData[
    \(General::"autoload" \(\(:\)\(\ \)\) 
      "Symbol `1` has autoloading rules attached to load `2` which are \
disabled by the setting of $AutoLoad to False. The package can be loaded with \
Get and the evaluation repeated."\)], "Message",
  CellLabel->"From In[11]:=",
  CellTags->"General::autoload"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when autoloading has been disabled by \
setting ",
  StyleBox["System`Private`$Autoload", "MR"],
  " to ",
  StyleBox["False", "MR"],
  " and a symbol with autoloaded functionality is encountered.\n\
\[FilledSmallSquare] Autoloading is used by default to load some of the rules \
for built-in functions.\n\[FilledSmallSquare] This message should not occur \
unless autoloading has been disabled."
}], "Notes",
  CellTags->"General::autoload"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::badsys1", "ObjectNameWarningMessages",
  CellTags->"General::badsys1"],

Cell[BoxData[
    \(General::"badsys1" \(\(:\)\(\ \)\) 
      "File `1` returned symbols `2` that did not match the declared symbol \
list `3`."\)], "Message",
  CellLabel->"From In[12]:=",
  CellTags->"General::badsys1"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when autoloading of the indicated file \
returns an expression that does not match the expected list of symbols.\n\
\[FilledSmallSquare] This error should occur only if the files that set up \
the default autoloading system have been modified or damaged.  For example, \
this error can occur if those files are not all from the same version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::badsys1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::badsys4", "ObjectNameWarningMessages",
  CellTags->"General::badsys4"],

Cell[BoxData[
    \(General::"badsys4" \(\(:\)\(\ \)\) 
      "Loading file `1` returned `2`, it should return a list of the exported \
symbols."\)], "Message",
  CellLabel->"From In[12]:=",
  CellTags->"General::badsys4"],

Cell["\<\
\[FilledSmallSquare] Generated when autoloading of the indicated \
file returns an expression that is not a list of symbols.
\[FilledSmallSquare] This error should occur only if the files that set up \
the default autoloading system have been modified or damaged, or if those \
files were not properly installed.\
\>", "Notes",
  CellTags->"General::badsys4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::badsys2", "ObjectNameWarningMessages",
  CellTags->"General::badsys2"],

Cell[BoxData[
    \(General::"badsys2" \(\(:\)\(\ \)\) 
      "Loading file `1` has removed these system definitions `2`."\)], \
"Message",
  CellLabel->"From In[12]:=",
  CellTags->"General::badsys2"],

Cell["\<\
\[FilledSmallSquare] Generated when autoloading of a file removes \
the indicated definitions.
\[FilledSmallSquare] This error should occur only if the files that set up \
the default autoloading system have been modified or damaged, or if \
non-standard definitions have been introduced for built-in functions.\
\>", \
"Notes",
  CellTags->"General::badsys2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::badsys3", "ObjectNameWarningMessages",
  CellTags->"General::badsys3"],

Cell[BoxData[
    \(General::"badsys3" \(\(:\)\(\ \)\) 
      "Loading file `1` has added system definitions `2` that were not \
specified in the symbol list for that file."\)], "Message",
  CellLabel->"From In[13]:=",
  CellTags->"General::badsys3"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated when autoloading of the indicated file adds \
unexpected definitions.\n\[FilledSmallSquare] This error should occur only if \
the files that set up the default autoloading system have been modified or \
damaged.  For example, this error can occur if those files are not all from \
the same version of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Notes",
  CellTags->"General::badsys3"]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::dstr", "ObjectNameWarningMessages",
  CellTags->"General::dstr"],

Cell[BoxData[
    \(General::"dstr" \(\(:\)\(\ \)\) 
      "Directory specification `1` is not a string."\)], "Message",
  CellLabel->"From In[13]:=",
  CellTags->"General::dstr"],

Cell[TextData[{
  "\[FilledSmallSquare] Generated by an attempt to assign an expression that \
is not a string as the value of ",
  StyleBox["$InstallationDirectory", "MR"],
  ".\n\[FilledSmallSquare] When this message is generated the value of ",
  StyleBox["$InstallationDirectory", "MR"],
  " is not changed."
}], "Notes",
  CellTags->"General::dstr"],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->"General::dstr"],

Cell[TextData[{
  "An error occurs in this example because the value of ",
  StyleBox["$InstallationDirectory", "MR"],
  " cannot be a number."
}], "Text",
  CellTags->"General::dstr"],

Cell[CellGroupData[{

Cell[BoxData[
    \($InstallationDirectory = 0\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"General::dstr"],

Cell[BoxData[
    \(General::"dstr" \(\(:\)\(\ \)\) 
      "Directory specification \!\(0\) is not a string."\)], "Message",
  CellLabel->"From In[1]:=",
  CellTags->"General::dstr"],

Cell[BoxData[
    \(0\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->"General::dstr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["General::sysfile", "ObjectNameWarningMessages",
  CellTags->"General::sysfile"],

Cell[BoxData[
    \(General::"sysfile" \(\(:\)\(\ \)\) 
      "Binary file loading of package `1` by symbol `2` failed."\)], "Message",\

  CellLabel->"From In[13]:=",
  CellTags->"General::sysfile"],

Cell["\<\
\[FilledSmallSquare] Generated when autoloading of the indicated \
file fails.
\[FilledSmallSquare] This error should occur only if the files that set up \
the default autoloading system have been modified or damaged, or if those \
files were not properly installed.\
\>", "Notes",
  CellTags->"General::sysfile"]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetFileDate::toobig", "ObjectNameWarningMessages",
  CellTags->"SetFileDate::toobig"],

Cell[BoxData[
    \(SetFileDate::"toobig" \(\(:\)\(\ \)\) \(Requested\ date\ is\ too\ far\ \
in\ the\ \(\(future\)\(.\)\)\)\)], "Message",
  CellTags->"SetFileDate::toobig"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"SetFileDate::toobig"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 975}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{698, 613},
WindowMargins->{{Automatic, 0}, {Automatic, 29}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "$BatchInput::bitf"->{
    Cell[1834, 57, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$BatchInput::bitf"],
    Cell[1924, 60, 194, 4, 21, "Message",
      CellTags->"$BatchInput::bitf"],
    Cell[2121, 66, 265, 9, 24, "Notes",
      CellTags->"$BatchInput::bitf"],
    Cell[2411, 79, 67, 1, 38, "ExampleSection",
      CellTags->"$BatchInput::bitf"],
    Cell[2481, 82, 324, 11, 40, "Text",
      CellTags->"$BatchInput::bitf"],
    Cell[2830, 97, 129, 3, 26, "Input",
      CellTags->"$BatchInput::bitf"],
    Cell[2962, 102, 244, 5, 37, "Message",
      CellTags->"$BatchInput::bitf"]},
  "$HistoryLength::limset"->{
    Cell[3267, 114, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$HistoryLength::limset"],
    Cell[3367, 117, 352, 6, 37, "Message",
      CellTags->"$HistoryLength::limset"],
    Cell[3722, 125, 218, 5, 24, "Notes",
      CellTags->"$HistoryLength::limset"],
    Cell[3965, 134, 72, 1, 38, "ExampleSection",
      CellTags->"$HistoryLength::limset"],
    Cell[4040, 137, 261, 8, 40, "Text",
      CellTags->"$HistoryLength::limset"],
    Cell[4326, 149, 117, 3, 26, "Input",
      CellTags->"$HistoryLength::limset"],
    Cell[4446, 154, 306, 6, 53, "Message",
      CellTags->"$HistoryLength::limset"],
    Cell[4755, 162, 147, 3, 21, "Output",
      CellTags->"$HistoryLength::limset"]},
  "ResetDirectory::dtop"->{
    Cell[4963, 172, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ResetDirectory::dtop"],
    Cell[5059, 175, 156, 3, 21, "Message",
      CellTags->"ResetDirectory::dtop"],
    Cell[5218, 180, 458, 12, 62, "Notes",
      CellTags->"ResetDirectory::dtop"],
    Cell[5701, 196, 70, 1, 38, "ExampleSection",
      CellTags->"ResetDirectory::dtop"],
    Cell[5774, 199, 263, 7, 40, "Text",
      CellTags->"ResetDirectory::dtop"],
    Cell[6062, 210, 116, 3, 26, "Input",
      CellTags->"ResetDirectory::dtop"],
    Cell[6181, 215, 173, 4, 21, "Message",
      CellTags->"ResetDirectory::dtop"]},
  "SetFileDate::fdate"->{
    Cell[6415, 226, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SetFileDate::fdate"],
    Cell[6507, 229, 223, 4, 37, "Message",
      CellTags->"SetFileDate::fdate"],
    Cell[6733, 235, 199, 5, 24, "Notes",
      CellTags->"SetFileDate::fdate"],
    Cell[6957, 244, 68, 1, 38, "ExampleSection",
      CellTags->"SetFileDate::fdate"],
    Cell[7028, 247, 205, 6, 24, "Text",
      CellTags->"SetFileDate::fdate"],
    Cell[7258, 257, 122, 3, 26, "Input",
      CellTags->"SetFileDate::fdate"],
    Cell[7383, 262, 252, 5, 37, "Message",
      CellTags->"SetFileDate::fdate"],
    Cell[7638, 269, 117, 3, 21, "Output",
      CellTags->"SetFileDate::fdate"]},
  "$ParentLink::lnset"->{
    Cell[7816, 279, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$ParentLink::lnset"],
    Cell[7908, 282, 290, 6, 21, "Message",
      CellTags->"$ParentLink::lnset"],
    Cell[8201, 290, 301, 9, 40, "Notes",
      CellTags->"$ParentLink::lnset"],
    Cell[8527, 303, 68, 1, 38, "ExampleSection",
      CellTags->"$ParentLink::lnset"],
    Cell[8598, 306, 348, 12, 40, "Text",
      CellTags->"$ParentLink::lnset"],
    Cell[8971, 322, 107, 3, 26, "Input",
      CellTags->"$ParentLink::lnset"],
    Cell[9081, 327, 208, 5, 21, "Message",
      CellTags->"$ParentLink::lnset"],
    Cell[9292, 334, 94, 3, 21, "Output",
      CellTags->"$ParentLink::lnset"]},
  "$ParentLink::notfe"->{
    Cell[9447, 344, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$ParentLink::notfe"],
    Cell[9539, 347, 236, 5, 21, "Message",
      CellTags->"$ParentLink::notfe"],
    Cell[9778, 354, 653, 20, 84, "Notes",
      CellTags->"$ParentLink::notfe"]},
  "$PreRead::prstr"->{
    Cell[10468, 379, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$PreRead::prstr"],
    Cell[10554, 382, 197, 5, 21, "Message",
      CellTags->"$PreRead::prstr"],
    Cell[10754, 389, 761, 19, 84, "Notes",
      CellTags->"$PreRead::prstr"],
    Cell[11540, 412, 65, 1, 38, "ExampleSection",
      CellTags->"$PreRead::prstr"],
    Cell[11608, 415, 163, 5, 24, "Text",
      CellTags->"$PreRead::prstr"],
    Cell[11796, 424, 84, 2, 28, "Input",
      CellTags->"$PreRead::prstr"],
    Cell[11883, 428, 90, 3, 21, "Output",
      CellTags->"$PreRead::prstr"],
    Cell[11976, 433, 213, 5, 21, "Message",
      CellTags->"$PreRead::prstr"],
    Cell[12204, 441, 219, 5, 40, "Text",
      CellTags->"$PreRead::prstr"],
    Cell[12448, 450, 87, 2, 28, "Input",
      CellTags->"$PreRead::prstr"],
    Cell[12538, 454, 243, 5, 37, "Message",
      CellTags->"$PreRead::prstr"]},
  "$SyntaxHandler::sntxh"->{
    Cell[12842, 466, 95, 1, 31, "ObjectNameWarningMessages",
      CellTags->"$SyntaxHandler::sntxh"],
    Cell[12940, 469, 285, 6, 21, "Message",
      CellTags->"$SyntaxHandler::sntxh"],
    Cell[13228, 477, 668, 17, 94, "Notes",
      CellTags->"$SyntaxHandler::sntxh"],
    Cell[13921, 498, 71, 1, 38, "ExampleSection",
      CellTags->"$SyntaxHandler::sntxh"],
    Cell[13995, 501, 190, 7, 24, "Text",
      CellTags->"$SyntaxHandler::sntxh"],
    Cell[14210, 512, 101, 2, 28, "Input",
      CellTags->"$SyntaxHandler::sntxh"],
    Cell[14314, 516, 101, 3, 21, "Output",
      CellTags->"$SyntaxHandler::sntxh"],
    Cell[14430, 522, 297, 8, 40, "Text",
      CellTags->"$SyntaxHandler::sntxh"],
    Cell[14752, 534, 81, 2, 28, "Input",
      CellTags->"$SyntaxHandler::sntxh"],
    Cell[14836, 538, 145, 2, 21, "Message",
      CellTags->"$SyntaxHandler::sntxh"],
    Cell[14984, 542, 221, 5, 37, "Message",
      CellTags->"$SyntaxHandler::sntxh"],
    Cell[15220, 550, 131, 5, 24, "Text",
      CellTags->"$SyntaxHandler::sntxh"],
    Cell[15354, 557, 99, 2, 28, "Input",
      CellTags->"$SyntaxHandler::sntxh"]},
  "CopyDirectory::dirne"->{
    Cell[15502, 565, 204, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "CopyDirectory::dirne", "DeleteDirectory::dirne", 
        "RenameDirectory::dirne"}],
    Cell[15709, 573, 382, 10, 19, "Message",
      CellTags->{
      "CopyDirectory::dirne", "DeleteDirectory::dirne", 
        "RenameDirectory::dirne"}],
    Cell[16094, 585, 430, 10, 62, "Notes",
      CellTags->{
      "CopyDirectory::dirne", "DeleteDirectory::dirne", 
        "RenameDirectory::dirne"}]},
  "DeleteDirectory::dirne"->{
    Cell[15502, 565, 204, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "CopyDirectory::dirne", "DeleteDirectory::dirne", 
        "RenameDirectory::dirne"}],
    Cell[15709, 573, 382, 10, 19, "Message",
      CellTags->{
      "CopyDirectory::dirne", "DeleteDirectory::dirne", 
        "RenameDirectory::dirne"}],
    Cell[16094, 585, 430, 10, 62, "Notes",
      CellTags->{
      "CopyDirectory::dirne", "DeleteDirectory::dirne", 
        "RenameDirectory::dirne"}]},
  "RenameDirectory::dirne"->{
    Cell[15502, 565, 204, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "CopyDirectory::dirne", "DeleteDirectory::dirne", 
        "RenameDirectory::dirne"}],
    Cell[15709, 573, 382, 10, 19, "Message",
      CellTags->{
      "CopyDirectory::dirne", "DeleteDirectory::dirne", 
        "RenameDirectory::dirne"}],
    Cell[16094, 585, 430, 10, 62, "Notes",
      CellTags->{
      "CopyDirectory::dirne", "DeleteDirectory::dirne", 
        "RenameDirectory::dirne"}]},
  "CopyDirectory::filex"->{
    Cell[16561, 600, 234, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
        "RenameFile::filex"}],
    Cell[16798, 610, 442, 13, 19, "Message",
      CellTags->{
      "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
        "RenameFile::filex"}],
    Cell[17243, 625, 329, 8, 46, "Notes",
      CellTags->{
      "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
        "RenameFile::filex"}]},
  "CopyFile::filex"->{
    Cell[16561, 600, 234, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
        "RenameFile::filex"}],
    Cell[16798, 610, 442, 13, 19, "Message",
      CellTags->{
      "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
        "RenameFile::filex"}],
    Cell[17243, 625, 329, 8, 46, "Notes",
      CellTags->{
      "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
        "RenameFile::filex"}]},
  "RenameDirectory::filex"->{
    Cell[16561, 600, 234, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
        "RenameFile::filex"}],
    Cell[16798, 610, 442, 13, 19, "Message",
      CellTags->{
      "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
        "RenameFile::filex"}],
    Cell[17243, 625, 329, 8, 46, "Notes",
      CellTags->{
      "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
        "RenameFile::filex"}]},
  "RenameFile::filex"->{
    Cell[16561, 600, 234, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
        "RenameFile::filex"}],
    Cell[16798, 610, 442, 13, 19, "Message",
      CellTags->{
      "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
        "RenameFile::filex"}],
    Cell[17243, 625, 329, 8, 46, "Notes",
      CellTags->{
      "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
        "RenameFile::filex"}]},
  "CopyDirectory::nodir"->{
    Cell[17609, 638, 204, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "CopyDirectory::nodir", "DeleteDirectory::nodir", 
        "RenameDirectory::nodir"}],
    Cell[17816, 646, 382, 10, 19, "Message",
      CellTags->{
      "CopyDirectory::nodir", "DeleteDirectory::nodir", 
        "RenameDirectory::nodir"}],
    Cell[18201, 658, 329, 8, 40, "Notes",
      CellTags->{
      "CopyDirectory::nodir", "DeleteDirectory::nodir", 
        "RenameDirectory::nodir"}]},
  "DeleteDirectory::nodir"->{
    Cell[17609, 638, 204, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "CopyDirectory::nodir", "DeleteDirectory::nodir", 
        "RenameDirectory::nodir"}],
    Cell[17816, 646, 382, 10, 19, "Message",
      CellTags->{
      "CopyDirectory::nodir", "DeleteDirectory::nodir", 
        "RenameDirectory::nodir"}],
    Cell[18201, 658, 329, 8, 40, "Notes",
      CellTags->{
      "CopyDirectory::nodir", "DeleteDirectory::nodir", 
        "RenameDirectory::nodir"}]},
  "RenameDirectory::nodir"->{
    Cell[17609, 638, 204, 6, 71, "ObjectNameWarningMessages",
      CellTags->{
      "CopyDirectory::nodir", "DeleteDirectory::nodir", 
        "RenameDirectory::nodir"}],
    Cell[17816, 646, 382, 10, 19, "Message",
      CellTags->{
      "CopyDirectory::nodir", "DeleteDirectory::nodir", 
        "RenameDirectory::nodir"}],
    Cell[18201, 658, 329, 8, 40, "Notes",
      CellTags->{
      "CopyDirectory::nodir", "DeleteDirectory::nodir", 
        "RenameDirectory::nodir"}]},
  "CopyFile::fdir"->{
    Cell[18567, 671, 225, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}],
    Cell[18795, 682, 481, 14, 19, "Message",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}],
    Cell[19279, 698, 237, 6, 24, "Notes",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}]},
  "DeleteFile::fdir"->{
    Cell[18567, 671, 225, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}],
    Cell[18795, 682, 481, 14, 19, "Message",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}],
    Cell[19279, 698, 237, 6, 24, "Notes",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}]},
  "Export::fdir"->{
    Cell[18567, 671, 225, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}],
    Cell[18795, 682, 481, 14, 19, "Message",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}],
    Cell[19279, 698, 237, 6, 24, "Notes",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}]},
  "Get::fdir"->{
    Cell[18567, 671, 225, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}],
    Cell[18795, 682, 481, 14, 19, "Message",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}],
    Cell[19279, 698, 237, 6, 24, "Notes",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}]},
  "RenameFile::fdir"->{
    Cell[18567, 671, 225, 9, 111, "ObjectNameWarningMessages",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}],
    Cell[18795, 682, 481, 14, 19, "Message",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}],
    Cell[19279, 698, 237, 6, 24, "Notes",
      CellTags->{
      "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
        "RenameFile::fdir"}]},
  "Directory::dirx"->{
    Cell[19553, 709, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Directory::dirx"],
    Cell[19639, 712, 149, 4, 21, "Message",
      CellTags->"Directory::dirx"],
    Cell[19791, 718, 195, 6, 24, "Notes",
      CellTags->"Directory::dirx"]},
  "FileNames::cdir"->{
    Cell[20023, 729, 234, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[20260, 739, 450, 13, 21, "Message",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[20713, 754, 585, 11, 84, "Notes",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21323, 769, 146, 3, 38, "ExampleSection",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21472, 774, 236, 6, 24, "Text",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21733, 784, 199, 5, 26, "Input",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21935, 791, 270, 6, 21, "Message",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}]},
  "ParentDirectory::cdir"->{
    Cell[20023, 729, 234, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[20260, 739, 450, 13, 21, "Message",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[20713, 754, 585, 11, 84, "Notes",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21323, 769, 146, 3, 38, "ExampleSection",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21472, 774, 236, 6, 24, "Text",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21733, 784, 199, 5, 26, "Input",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21935, 791, 270, 6, 21, "Message",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}]},
  "ResetDirectory::cdir"->{
    Cell[20023, 729, 234, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[20260, 739, 450, 13, 21, "Message",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[20713, 754, 585, 11, 84, "Notes",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21323, 769, 146, 3, 38, "ExampleSection",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21472, 774, 236, 6, 24, "Text",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21733, 784, 199, 5, 26, "Input",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21935, 791, 270, 6, 21, "Message",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}]},
  "SetDirectory::cdir"->{
    Cell[20023, 729, 234, 8, 91, "ObjectNameWarningMessages",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[20260, 739, 450, 13, 21, "Message",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[20713, 754, 585, 11, 84, "Notes",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21323, 769, 146, 3, 38, "ExampleSection",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21472, 774, 236, 6, 24, "Text",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21733, 784, 199, 5, 26, "Input",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}],
    Cell[21935, 791, 270, 6, 21, "Message",
      CellTags->{
      "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
        "SetDirectory::cdir"}]},
  "FromDate::fdls"->{
    Cell[22266, 804, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"FromDate::fdls"],
    Cell[22350, 807, 456, 11, 37, "Message",
      CellTags->"FromDate::fdls"],
    Cell[22809, 820, 185, 5, 24, "Notes",
      CellTags->"FromDate::fdls"],
    Cell[23019, 829, 64, 1, 38, "ExampleSection",
      CellTags->"FromDate::fdls"],
    Cell[23086, 832, 141, 4, 24, "Text",
      CellTags->"FromDate::fdls"],
    Cell[23252, 840, 116, 3, 26, "Input",
      CellTags->"FromDate::fdls"],
    Cell[23371, 845, 275, 6, 53, "Message",
      CellTags->"FromDate::fdls"],
    Cell[23649, 853, 117, 3, 21, "Output",
      CellTags->"FromDate::fdls"],
    Cell[23781, 859, 130, 5, 24, "Text",
      CellTags->"FromDate::fdls"],
    Cell[23936, 868, 119, 3, 26, "Input",
      CellTags->"FromDate::fdls"],
    Cell[24058, 873, 98, 3, 21, "Output",
      CellTags->"FromDate::fdls"]},
  "General::globn"->{
    Cell[24217, 883, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::globn"],
    Cell[24301, 886, 336, 11, 21, "Message",
      CellTags->"General::globn"],
    Cell[24640, 899, 428, 10, 46, "Notes",
      CellTags->"General::globn"]},
  "General::globf"->{
    Cell[25105, 914, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::globf"],
    Cell[25189, 917, 404, 12, 21, "Message",
      CellTags->"General::globf"],
    Cell[25596, 931, 401, 10, 46, "Notes",
      CellTags->"General::globf"],
    Cell[26022, 945, 64, 1, 38, "ExampleSection",
      CellTags->"General::globf"],
    Cell[26089, 948, 209, 6, 24, "Text",
      CellTags->"General::globf"],
    Cell[26323, 958, 118, 3, 26, "Input",
      CellTags->"General::globf"],
    Cell[26444, 963, 200, 5, 21, "Message",
      CellTags->"General::globf"],
    Cell[26647, 970, 163, 4, 21, "Message",
      CellTags->"General::globf"],
    Cell[26813, 976, 111, 3, 21, "Output",
      CellTags->"General::globf"]},
  "General::globm"->{
    Cell[26985, 986, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::globm"],
    Cell[27069, 989, 426, 14, 21, "Message",
      CellTags->"General::globm"],
    Cell[27498, 1005, 428, 10, 46, "Notes",
      CellTags->"General::globm"]},
  "RenameDirectory::redev"->{
    Cell[27963, 1020, 146, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"RenameDirectory::redev", "RenameFile::redev"}],
    Cell[28112, 1026, 624, 18, 37, "Message",
      CellTags->{"RenameDirectory::redev", "RenameFile::redev"}],
    Cell[28739, 1046, 439, 9, 62, "Notes",
      CellTags->{"RenameDirectory::redev", "RenameFile::redev"}]},
  "RenameFile::redev"->{
    Cell[27963, 1020, 146, 4, 51, "ObjectNameWarningMessages",
      CellTags->{"RenameDirectory::redev", "RenameFile::redev"}],
    Cell[28112, 1026, 624, 18, 37, "Message",
      CellTags->{"RenameDirectory::redev", "RenameFile::redev"}],
    Cell[28739, 1046, 439, 9, 62, "Notes",
      CellTags->{"RenameDirectory::redev", "RenameFile::redev"}]},
  "RenameFile::renfd"->{
    Cell[29215, 1060, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"RenameFile::renfd"],
    Cell[29305, 1063, 166, 3, 21, "Message",
      CellTags->"RenameFile::renfd"],
    Cell[29474, 1068, 267, 6, 46, "Notes",
      CellTags->"RenameFile::renfd"]},
  "Run::shell"->{
    Cell[29778, 1079, 73, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Run::shell"],
    Cell[29854, 1082, 131, 3, 21, "Message",
      CellTags->"Run::shell"],
    Cell[29988, 1087, 313, 8, 46, "Notes",
      CellTags->"Run::shell"]},
  "TimeConstrained::timc"->{
    Cell[30338, 1100, 95, 1, 31, "ObjectNameWarningMessages",
      CellTags->"TimeConstrained::timc"],
    Cell[30436, 1103, 274, 6, 21, "Message",
      CellTags->"TimeConstrained::timc"],
    Cell[30713, 1111, 199, 5, 24, "Notes",
      CellTags->"TimeConstrained::timc"],
    Cell[30937, 1120, 71, 1, 38, "ExampleSection",
      CellTags->"TimeConstrained::timc"],
    Cell[31011, 1123, 192, 5, 24, "Text",
      CellTags->"TimeConstrained::timc"],
    Cell[31228, 1132, 131, 3, 26, "Input",
      CellTags->"TimeConstrained::timc"],
    Cell[31362, 1137, 202, 4, 21, "Message",
      CellTags->"TimeConstrained::timc"],
    Cell[31567, 1143, 133, 3, 23, "Output",
      CellTags->"TimeConstrained::timc"],
    Cell[31715, 1149, 151, 5, 24, "Text",
      CellTags->"TimeConstrained::timc"],
    Cell[31891, 1158, 131, 3, 26, "Input",
      CellTags->"TimeConstrained::timc"],
    Cell[32025, 1163, 103, 3, 21, "Output",
      CellTags->"TimeConstrained::timc"]},
  "ToDate::tdn"->{
    Cell[32189, 1173, 75, 1, 31, "ObjectNameWarningMessages",
      CellTags->"ToDate::tdn"],
    Cell[32267, 1176, 354, 8, 19, "Message",
      CellTags->"ToDate::tdn"],
    Cell[32624, 1186, 171, 5, 24, "Notes",
      CellTags->"ToDate::tdn"],
    Cell[32820, 1195, 61, 1, 38, "ExampleSection",
      CellTags->"ToDate::tdn"],
    Cell[32884, 1198, 139, 4, 24, "Text",
      CellTags->"ToDate::tdn"],
    Cell[33048, 1206, 116, 3, 26, "Input",
      CellTags->"ToDate::tdn"],
    Cell[33167, 1211, 216, 5, 19, "Message",
      CellTags->"ToDate::tdn"],
    Cell[33386, 1218, 117, 3, 25, "Output",
      CellTags->"ToDate::tdn"],
    Cell[33518, 1224, 125, 5, 24, "Text",
      CellTags->"ToDate::tdn"],
    Cell[33668, 1233, 102, 3, 26, "Input",
      CellTags->"ToDate::tdn"],
    Cell[33773, 1238, 111, 3, 21, "Output",
      CellTags->"ToDate::tdn"]},
  "General::dirdep"->{
    Cell[33945, 1248, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::dirdep"],
    Cell[34031, 1251, 411, 12, 21, "Message",
      CellTags->"General::dirdep"],
    Cell[34445, 1265, 475, 9, 84, "Notes",
      CellTags->"General::dirdep"]},
  "General::enable"->{
    Cell[34957, 1279, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::enable"],
    Cell[35043, 1282, 419, 12, 21, "Message",
      CellTags->"General::enable"],
    Cell[35465, 1296, 412, 11, 46, "Notes",
      CellTags->"General::enable"]},
  "General::fstr"->{
    Cell[35914, 1312, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::fstr"],
    Cell[35996, 1315, 443, 12, 21, "Message",
      CellTags->"General::fstr"],
    Cell[36442, 1329, 256, 6, 46, "Notes",
      CellTags->"General::fstr"],
    Cell[36723, 1339, 63, 1, 38, "ExampleSection",
      CellTags->"General::fstr"],
    Cell[36789, 1342, 157, 4, 24, "Text",
      CellTags->"General::fstr"],
    Cell[36971, 1350, 98, 3, 26, "Input",
      CellTags->"General::fstr"],
    Cell[37072, 1355, 207, 5, 21, "Message",
      CellTags->"General::fstr"],
    Cell[37282, 1362, 99, 3, 21, "Output",
      CellTags->"General::fstr"],
    Cell[37396, 1368, 124, 5, 24, "Text",
      CellTags->"General::fstr"],
    Cell[37545, 1377, 120, 3, 26, "Input",
      CellTags->"General::fstr"],
    Cell[37668, 1382, 91, 3, 21, "Output",
      CellTags->"General::fstr"]},
  "General::hmdir"->{
    Cell[37820, 1392, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::hmdir"],
    Cell[37904, 1395, 375, 11, 37, "Message",
      CellTags->"General::hmdir"],
    Cell[38282, 1408, 312, 7, 40, "Notes",
      CellTags->"General::hmdir"]},
  "General::initstate"->{
    Cell[38631, 1420, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::initstate"],
    Cell[38723, 1423, 383, 11, 21, "Message",
      CellTags->"General::initstate"],
    Cell[39109, 1436, 429, 9, 62, "Notes",
      CellTags->"General::initstate"]},
  "General::longp"->{
    Cell[39575, 1450, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::longp"],
    Cell[39659, 1453, 346, 10, 21, "Message",
      CellTags->"General::longp"],
    Cell[40008, 1465, 409, 8, 68, "Notes",
      CellTags->"General::longp"]},
  "General::nfdir"->{
    Cell[40454, 1478, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nfdir"],
    Cell[40538, 1481, 356, 11, 21, "Message",
      CellTags->"General::nfdir"],
    Cell[40897, 1494, 488, 10, 84, "Notes",
      CellTags->"General::nfdir"],
    Cell[41410, 1508, 64, 1, 38, "ExampleSection",
      CellTags->"General::nfdir"],
    Cell[41477, 1511, 169, 4, 24, "Text",
      CellTags->"General::nfdir"],
    Cell[41671, 1519, 145, 3, 26, "Input",
      CellTags->"General::nfdir"],
    Cell[41819, 1524, 99, 3, 21, "Output",
      CellTags->"General::nfdir"],
    Cell[41955, 1532, 165, 4, 26, "Input",
      CellTags->"General::nfdir"],
    Cell[42123, 1538, 229, 5, 37, "Message",
      CellTags->"General::nfdir"],
    Cell[42355, 1545, 95, 3, 21, "Output",
      CellTags->"General::nfdir"],
    Cell[42465, 1551, 62, 1, 24, "Text",
      CellTags->"General::nfdir"],
    Cell[42530, 1554, 114, 3, 26, "Input",
      CellTags->"General::nfdir"]},
  "General::nffil"->{
    Cell[42693, 1563, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::nffil"],
    Cell[42777, 1566, 351, 11, 21, "Message",
      CellTags->"General::nffil"],
    Cell[43131, 1579, 499, 10, 68, "Notes",
      CellTags->"General::nffil"],
    Cell[43655, 1593, 64, 1, 38, "ExampleSection",
      CellTags->"General::nffil"],
    Cell[43722, 1596, 226, 6, 40, "Text",
      CellTags->"General::nffil"],
    Cell[43973, 1606, 109, 3, 26, "Input",
      CellTags->"General::nffil"],
    Cell[44085, 1611, 186, 4, 21, "Message",
      CellTags->"General::nffil"],
    Cell[44274, 1617, 95, 3, 21, "Output",
      CellTags->"General::nffil"]},
  "General::privv"->{
    Cell[44430, 1627, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::privv"],
    Cell[44514, 1630, 348, 11, 21, "Message",
      CellTags->"General::privv"],
    Cell[44865, 1643, 399, 8, 62, "Notes",
      CellTags->"General::privv"]},
  "General::unuser"->{
    Cell[45301, 1656, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::unuser"],
    Cell[45387, 1659, 349, 11, 21, "Message",
      CellTags->"General::unuser"],
    Cell[45739, 1672, 608, 13, 100, "Notes",
      CellTags->"General::unuser"]},
  "General::addsyms"->{
    Cell[46384, 1690, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::addsyms"],
    Cell[46472, 1693, 418, 12, 21, "Message",
      CellTags->"General::addsyms"],
    Cell[46893, 1707, 196, 6, 24, "Notes",
      CellTags->"General::addsyms"]},
  "General::autoload"->{
    Cell[47126, 1718, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::autoload"],
    Cell[47216, 1721, 321, 6, 69, "Message",
      CellTags->"General::autoload"],
    Cell[47540, 1729, 492, 11, 84, "Notes",
      CellTags->"General::autoload"]},
  "General::badsys1"->{
    Cell[48069, 1745, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::badsys1"],
    Cell[48157, 1748, 221, 5, 37, "Message",
      CellTags->"General::badsys1"],
    Cell[48381, 1755, 499, 10, 62, "Notes",
      CellTags->"General::badsys1"]},
  "General::badsys4"->{
    Cell[48917, 1770, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::badsys4"],
    Cell[49005, 1773, 222, 5, 37, "Message",
      CellTags->"General::badsys4"],
    Cell[49230, 1780, 369, 7, 62, "Notes",
      CellTags->"General::badsys4"]},
  "General::badsys2"->{
    Cell[49636, 1792, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::badsys2"],
    Cell[49724, 1795, 201, 5, 21, "Message",
      CellTags->"General::badsys2"],
    Cell[49928, 1802, 370, 8, 62, "Notes",
      CellTags->"General::badsys2"]},
  "General::badsys3"->{
    Cell[50335, 1815, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::badsys3"],
    Cell[50423, 1818, 250, 5, 37, "Message",
      CellTags->"General::badsys3"],
    Cell[50676, 1825, 456, 10, 62, "Notes",
      CellTags->"General::badsys3"]},
  "General::dstr"->{
    Cell[51169, 1840, 79, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::dstr"],
    Cell[51251, 1843, 179, 4, 19, "Message",
      CellTags->"General::dstr"],
    Cell[51433, 1849, 354, 8, 46, "Notes",
      CellTags->"General::dstr"],
    Cell[51812, 1861, 63, 1, 38, "ExampleSection",
      CellTags->"General::dstr"],
    Cell[51878, 1864, 184, 5, 24, "Text",
      CellTags->"General::dstr"],
    Cell[52087, 1873, 112, 3, 26, "Input",
      CellTags->"General::dstr"],
    Cell[52202, 1878, 182, 4, 19, "Message",
      CellTags->"General::dstr"],
    Cell[52387, 1884, 88, 3, 25, "Output",
      CellTags->"General::dstr"]},
  "General::sysfile"->{
    Cell[52536, 1894, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"General::sysfile"],
    Cell[52624, 1897, 199, 5, 19, "Message",
      CellTags->"General::sysfile"],
    Cell[52826, 1904, 323, 7, 62, "Notes",
      CellTags->"General::sysfile"]},
  "SetFileDate::toobig"->{
    Cell[53186, 1916, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"SetFileDate::toobig"],
    Cell[53280, 1919, 173, 3, 19, "Message",
      CellTags->"SetFileDate::toobig"],
    Cell[53456, 1924, 130, 4, 24, "Notes",
      CellTags->"SetFileDate::toobig"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"$BatchInput::bitf", 54281, 1949},
  {"$HistoryLength::limset", 54890, 1964},
  {"ResetDirectory::dtop", 55622, 1981},
  {"SetFileDate::fdate", 56254, 1996},
  {"$ParentLink::lnset", 56952, 2013},
  {"$ParentLink::notfe", 57650, 2030},
  {"$PreRead::prstr", 57936, 2037},
  {"$SyntaxHandler::sntxh", 58854, 2060},
  {"CopyDirectory::dirne", 60005, 2087},
  {"DeleteDirectory::dirne", 60519, 2100},
  {"RenameDirectory::dirne", 61033, 2113},
  {"CopyDirectory::filex", 61545, 2126},
  {"CopyFile::filex", 62093, 2139},
  {"RenameDirectory::filex", 62648, 2152},
  {"RenameFile::filex", 63198, 2165},
  {"CopyDirectory::nodir", 63751, 2178},
  {"DeleteDirectory::nodir", 64264, 2191},
  {"RenameDirectory::nodir", 64777, 2204},
  {"CopyFile::fdir", 65282, 2217},
  {"DeleteFile::fdir", 65823, 2230},
  {"Export::fdir", 66360, 2243},
  {"Get::fdir", 66894, 2256},
  {"RenameFile::fdir", 67435, 2269},
  {"Directory::dirx", 67975, 2282},
  {"FileNames::cdir", 68254, 2289},
  {"ParentDirectory::cdir", 69487, 2318},
  {"ResetDirectory::cdir", 70719, 2347},
  {"SetDirectory::cdir", 71949, 2376},
  {"FromDate::fdls", 73175, 2405},
  {"General::globn", 74076, 2428},
  {"General::globf", 74353, 2435},
  {"General::globm", 75104, 2454},
  {"RenameDirectory::redev", 75390, 2461},
  {"RenameFile::redev", 75766, 2468},
  {"RenameFile::renfd", 76142, 2475},
  {"Run::shell", 76425, 2482},
  {"TimeConstrained::timc", 76698, 2489},
  {"ToDate::tdn", 77684, 2512},
  {"General::dirdep", 78564, 2535},
  {"General::enable", 78847, 2542},
  {"General::fstr", 79129, 2549},
  {"General::hmdir", 80028, 2572},
  {"General::initstate", 80311, 2579},
  {"General::longp", 80602, 2586},
  {"General::nfdir", 80881, 2593},
  {"General::nffil", 81870, 2618},
  {"General::privv", 82549, 2635},
  {"General::unuser", 82829, 2642},
  {"General::addsyms", 83115, 2649},
  {"General::autoload", 83403, 2656},
  {"General::badsys1", 83693, 2663},
  {"General::badsys4", 83980, 2670},
  {"General::badsys2", 84266, 2677},
  {"General::badsys3", 84552, 2684},
  {"General::dstr", 84836, 2691},
  {"General::sysfile", 85507, 2708},
  {"SetFileDate::toobig", 85796, 2715}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 33, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1834, 57, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$BatchInput::bitf"],
Cell[1924, 60, 194, 4, 21, "Message",
  CellTags->"$BatchInput::bitf"],
Cell[2121, 66, 265, 9, 24, "Notes",
  CellTags->"$BatchInput::bitf"],

Cell[CellGroupData[{
Cell[2411, 79, 67, 1, 38, "ExampleSection",
  CellTags->"$BatchInput::bitf"],
Cell[2481, 82, 324, 11, 40, "Text",
  CellTags->"$BatchInput::bitf"],

Cell[CellGroupData[{
Cell[2830, 97, 129, 3, 26, "Input",
  CellTags->"$BatchInput::bitf"],
Cell[2962, 102, 244, 5, 37, "Message",
  CellTags->"$BatchInput::bitf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[3267, 114, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$HistoryLength::limset"],
Cell[3367, 117, 352, 6, 37, "Message",
  CellTags->"$HistoryLength::limset"],
Cell[3722, 125, 218, 5, 24, "Notes",
  CellTags->"$HistoryLength::limset"],

Cell[CellGroupData[{
Cell[3965, 134, 72, 1, 38, "ExampleSection",
  CellTags->"$HistoryLength::limset"],
Cell[4040, 137, 261, 8, 40, "Text",
  CellTags->"$HistoryLength::limset"],

Cell[CellGroupData[{
Cell[4326, 149, 117, 3, 26, "Input",
  CellTags->"$HistoryLength::limset"],
Cell[4446, 154, 306, 6, 53, "Message",
  CellTags->"$HistoryLength::limset"],
Cell[4755, 162, 147, 3, 21, "Output",
  CellTags->"$HistoryLength::limset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[4963, 172, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ResetDirectory::dtop"],
Cell[5059, 175, 156, 3, 21, "Message",
  CellTags->"ResetDirectory::dtop"],
Cell[5218, 180, 458, 12, 62, "Notes",
  CellTags->"ResetDirectory::dtop"],

Cell[CellGroupData[{
Cell[5701, 196, 70, 1, 38, "ExampleSection",
  CellTags->"ResetDirectory::dtop"],
Cell[5774, 199, 263, 7, 40, "Text",
  CellTags->"ResetDirectory::dtop"],

Cell[CellGroupData[{
Cell[6062, 210, 116, 3, 26, "Input",
  CellTags->"ResetDirectory::dtop"],
Cell[6181, 215, 173, 4, 21, "Message",
  CellTags->"ResetDirectory::dtop"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6415, 226, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SetFileDate::fdate"],
Cell[6507, 229, 223, 4, 37, "Message",
  CellTags->"SetFileDate::fdate"],
Cell[6733, 235, 199, 5, 24, "Notes",
  CellTags->"SetFileDate::fdate"],

Cell[CellGroupData[{
Cell[6957, 244, 68, 1, 38, "ExampleSection",
  CellTags->"SetFileDate::fdate"],
Cell[7028, 247, 205, 6, 24, "Text",
  CellTags->"SetFileDate::fdate"],

Cell[CellGroupData[{
Cell[7258, 257, 122, 3, 26, "Input",
  CellTags->"SetFileDate::fdate"],
Cell[7383, 262, 252, 5, 37, "Message",
  CellTags->"SetFileDate::fdate"],
Cell[7638, 269, 117, 3, 21, "Output",
  CellTags->"SetFileDate::fdate"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7816, 279, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$ParentLink::lnset"],
Cell[7908, 282, 290, 6, 21, "Message",
  CellTags->"$ParentLink::lnset"],
Cell[8201, 290, 301, 9, 40, "Notes",
  CellTags->"$ParentLink::lnset"],

Cell[CellGroupData[{
Cell[8527, 303, 68, 1, 38, "ExampleSection",
  CellTags->"$ParentLink::lnset"],
Cell[8598, 306, 348, 12, 40, "Text",
  CellTags->"$ParentLink::lnset"],

Cell[CellGroupData[{
Cell[8971, 322, 107, 3, 26, "Input",
  CellTags->"$ParentLink::lnset"],
Cell[9081, 327, 208, 5, 21, "Message",
  CellTags->"$ParentLink::lnset"],
Cell[9292, 334, 94, 3, 21, "Output",
  CellTags->"$ParentLink::lnset"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9447, 344, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$ParentLink::notfe"],
Cell[9539, 347, 236, 5, 21, "Message",
  CellTags->"$ParentLink::notfe"],
Cell[9778, 354, 653, 20, 84, "Notes",
  CellTags->"$ParentLink::notfe"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10468, 379, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$PreRead::prstr"],
Cell[10554, 382, 197, 5, 21, "Message",
  CellTags->"$PreRead::prstr"],
Cell[10754, 389, 761, 19, 84, "Notes",
  CellTags->"$PreRead::prstr"],

Cell[CellGroupData[{
Cell[11540, 412, 65, 1, 38, "ExampleSection",
  CellTags->"$PreRead::prstr"],
Cell[11608, 415, 163, 5, 24, "Text",
  CellTags->"$PreRead::prstr"],

Cell[CellGroupData[{
Cell[11796, 424, 84, 2, 28, "Input",
  CellTags->"$PreRead::prstr"],
Cell[11883, 428, 90, 3, 21, "Output",
  CellTags->"$PreRead::prstr"],
Cell[11976, 433, 213, 5, 21, "Message",
  CellTags->"$PreRead::prstr"]
}, Open  ]],
Cell[12204, 441, 219, 5, 40, "Text",
  CellTags->"$PreRead::prstr"],

Cell[CellGroupData[{
Cell[12448, 450, 87, 2, 28, "Input",
  CellTags->"$PreRead::prstr"],
Cell[12538, 454, 243, 5, 37, "Message",
  CellTags->"$PreRead::prstr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12842, 466, 95, 1, 31, "ObjectNameWarningMessages",
  CellTags->"$SyntaxHandler::sntxh"],
Cell[12940, 469, 285, 6, 21, "Message",
  CellTags->"$SyntaxHandler::sntxh"],
Cell[13228, 477, 668, 17, 94, "Notes",
  CellTags->"$SyntaxHandler::sntxh"],

Cell[CellGroupData[{
Cell[13921, 498, 71, 1, 38, "ExampleSection",
  CellTags->"$SyntaxHandler::sntxh"],
Cell[13995, 501, 190, 7, 24, "Text",
  CellTags->"$SyntaxHandler::sntxh"],

Cell[CellGroupData[{
Cell[14210, 512, 101, 2, 28, "Input",
  CellTags->"$SyntaxHandler::sntxh"],
Cell[14314, 516, 101, 3, 21, "Output",
  CellTags->"$SyntaxHandler::sntxh"]
}, Open  ]],
Cell[14430, 522, 297, 8, 40, "Text",
  CellTags->"$SyntaxHandler::sntxh"],

Cell[CellGroupData[{
Cell[14752, 534, 81, 2, 28, "Input",
  CellTags->"$SyntaxHandler::sntxh"],
Cell[14836, 538, 145, 2, 21, "Message",
  CellTags->"$SyntaxHandler::sntxh"],
Cell[14984, 542, 221, 5, 37, "Message",
  CellTags->"$SyntaxHandler::sntxh"]
}, Open  ]],
Cell[15220, 550, 131, 5, 24, "Text",
  CellTags->"$SyntaxHandler::sntxh"],
Cell[15354, 557, 99, 2, 28, "Input",
  CellTags->"$SyntaxHandler::sntxh"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15502, 565, 204, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "CopyDirectory::dirne", "DeleteDirectory::dirne", 
    "RenameDirectory::dirne"}],
Cell[15709, 573, 382, 10, 19, "Message",
  CellTags->{
  "CopyDirectory::dirne", "DeleteDirectory::dirne", 
    "RenameDirectory::dirne"}],
Cell[16094, 585, 430, 10, 62, "Notes",
  CellTags->{
  "CopyDirectory::dirne", "DeleteDirectory::dirne", 
    "RenameDirectory::dirne"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[16561, 600, 234, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
    "RenameFile::filex"}],
Cell[16798, 610, 442, 13, 19, "Message",
  CellTags->{
  "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
    "RenameFile::filex"}],
Cell[17243, 625, 329, 8, 46, "Notes",
  CellTags->{
  "CopyDirectory::filex", "CopyFile::filex", "RenameDirectory::filex", 
    "RenameFile::filex"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[17609, 638, 204, 6, 71, "ObjectNameWarningMessages",
  CellTags->{
  "CopyDirectory::nodir", "DeleteDirectory::nodir", 
    "RenameDirectory::nodir"}],
Cell[17816, 646, 382, 10, 19, "Message",
  CellTags->{
  "CopyDirectory::nodir", "DeleteDirectory::nodir", 
    "RenameDirectory::nodir"}],
Cell[18201, 658, 329, 8, 40, "Notes",
  CellTags->{
  "CopyDirectory::nodir", "DeleteDirectory::nodir", 
    "RenameDirectory::nodir"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[18567, 671, 225, 9, 111, "ObjectNameWarningMessages",
  CellTags->{
  "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
    "RenameFile::fdir"}],
Cell[18795, 682, 481, 14, 19, "Message",
  CellTags->{
  "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
    "RenameFile::fdir"}],
Cell[19279, 698, 237, 6, 24, "Notes",
  CellTags->{
  "CopyFile::fdir", "DeleteFile::fdir", "Export::fdir", "Get::fdir", 
    "RenameFile::fdir"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[19553, 709, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Directory::dirx"],
Cell[19639, 712, 149, 4, 21, "Message",
  CellTags->"Directory::dirx"],
Cell[19791, 718, 195, 6, 24, "Notes",
  CellTags->"Directory::dirx"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20023, 729, 234, 8, 91, "ObjectNameWarningMessages",
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}],
Cell[20260, 739, 450, 13, 21, "Message",
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}],
Cell[20713, 754, 585, 11, 84, "Notes",
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}],

Cell[CellGroupData[{
Cell[21323, 769, 146, 3, 38, "ExampleSection",
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}],
Cell[21472, 774, 236, 6, 24, "Text",
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}],

Cell[CellGroupData[{
Cell[21733, 784, 199, 5, 26, "Input",
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}],
Cell[21935, 791, 270, 6, 21, "Message",
  CellTags->{
  "FileNames::cdir", "ParentDirectory::cdir", "ResetDirectory::cdir", 
    "SetDirectory::cdir"}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22266, 804, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"FromDate::fdls"],
Cell[22350, 807, 456, 11, 37, "Message",
  CellTags->"FromDate::fdls"],
Cell[22809, 820, 185, 5, 24, "Notes",
  CellTags->"FromDate::fdls"],

Cell[CellGroupData[{
Cell[23019, 829, 64, 1, 38, "ExampleSection",
  CellTags->"FromDate::fdls"],
Cell[23086, 832, 141, 4, 24, "Text",
  CellTags->"FromDate::fdls"],

Cell[CellGroupData[{
Cell[23252, 840, 116, 3, 26, "Input",
  CellTags->"FromDate::fdls"],
Cell[23371, 845, 275, 6, 53, "Message",
  CellTags->"FromDate::fdls"],
Cell[23649, 853, 117, 3, 21, "Output",
  CellTags->"FromDate::fdls"]
}, Open  ]],
Cell[23781, 859, 130, 5, 24, "Text",
  CellTags->"FromDate::fdls"],

Cell[CellGroupData[{
Cell[23936, 868, 119, 3, 26, "Input",
  CellTags->"FromDate::fdls"],
Cell[24058, 873, 98, 3, 21, "Output",
  CellTags->"FromDate::fdls"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[24217, 883, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::globn"],
Cell[24301, 886, 336, 11, 21, "Message",
  CellTags->"General::globn"],
Cell[24640, 899, 428, 10, 46, "Notes",
  CellTags->"General::globn"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25105, 914, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::globf"],
Cell[25189, 917, 404, 12, 21, "Message",
  CellTags->"General::globf"],
Cell[25596, 931, 401, 10, 46, "Notes",
  CellTags->"General::globf"],

Cell[CellGroupData[{
Cell[26022, 945, 64, 1, 38, "ExampleSection",
  CellTags->"General::globf"],
Cell[26089, 948, 209, 6, 24, "Text",
  CellTags->"General::globf"],

Cell[CellGroupData[{
Cell[26323, 958, 118, 3, 26, "Input",
  CellTags->"General::globf"],
Cell[26444, 963, 200, 5, 21, "Message",
  CellTags->"General::globf"],
Cell[26647, 970, 163, 4, 21, "Message",
  CellTags->"General::globf"],
Cell[26813, 976, 111, 3, 21, "Output",
  CellTags->"General::globf"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26985, 986, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::globm"],
Cell[27069, 989, 426, 14, 21, "Message",
  CellTags->"General::globm"],
Cell[27498, 1005, 428, 10, 46, "Notes",
  CellTags->"General::globm"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27963, 1020, 146, 4, 51, "ObjectNameWarningMessages",
  CellTags->{"RenameDirectory::redev", "RenameFile::redev"}],
Cell[28112, 1026, 624, 18, 37, "Message",
  CellTags->{"RenameDirectory::redev", "RenameFile::redev"}],
Cell[28739, 1046, 439, 9, 62, "Notes",
  CellTags->{"RenameDirectory::redev", "RenameFile::redev"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[29215, 1060, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"RenameFile::renfd"],
Cell[29305, 1063, 166, 3, 21, "Message",
  CellTags->"RenameFile::renfd"],
Cell[29474, 1068, 267, 6, 46, "Notes",
  CellTags->"RenameFile::renfd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29778, 1079, 73, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Run::shell"],
Cell[29854, 1082, 131, 3, 21, "Message",
  CellTags->"Run::shell"],
Cell[29988, 1087, 313, 8, 46, "Notes",
  CellTags->"Run::shell"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30338, 1100, 95, 1, 31, "ObjectNameWarningMessages",
  CellTags->"TimeConstrained::timc"],
Cell[30436, 1103, 274, 6, 21, "Message",
  CellTags->"TimeConstrained::timc"],
Cell[30713, 1111, 199, 5, 24, "Notes",
  CellTags->"TimeConstrained::timc"],

Cell[CellGroupData[{
Cell[30937, 1120, 71, 1, 38, "ExampleSection",
  CellTags->"TimeConstrained::timc"],
Cell[31011, 1123, 192, 5, 24, "Text",
  CellTags->"TimeConstrained::timc"],

Cell[CellGroupData[{
Cell[31228, 1132, 131, 3, 26, "Input",
  CellTags->"TimeConstrained::timc"],
Cell[31362, 1137, 202, 4, 21, "Message",
  CellTags->"TimeConstrained::timc"],
Cell[31567, 1143, 133, 3, 23, "Output",
  CellTags->"TimeConstrained::timc"]
}, Open  ]],
Cell[31715, 1149, 151, 5, 24, "Text",
  CellTags->"TimeConstrained::timc"],

Cell[CellGroupData[{
Cell[31891, 1158, 131, 3, 26, "Input",
  CellTags->"TimeConstrained::timc"],
Cell[32025, 1163, 103, 3, 21, "Output",
  CellTags->"TimeConstrained::timc"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32189, 1173, 75, 1, 31, "ObjectNameWarningMessages",
  CellTags->"ToDate::tdn"],
Cell[32267, 1176, 354, 8, 19, "Message",
  CellTags->"ToDate::tdn"],
Cell[32624, 1186, 171, 5, 24, "Notes",
  CellTags->"ToDate::tdn"],

Cell[CellGroupData[{
Cell[32820, 1195, 61, 1, 38, "ExampleSection",
  CellTags->"ToDate::tdn"],
Cell[32884, 1198, 139, 4, 24, "Text",
  CellTags->"ToDate::tdn"],

Cell[CellGroupData[{
Cell[33048, 1206, 116, 3, 26, "Input",
  CellTags->"ToDate::tdn"],
Cell[33167, 1211, 216, 5, 19, "Message",
  CellTags->"ToDate::tdn"],
Cell[33386, 1218, 117, 3, 25, "Output",
  CellTags->"ToDate::tdn"]
}, Open  ]],
Cell[33518, 1224, 125, 5, 24, "Text",
  CellTags->"ToDate::tdn"],

Cell[CellGroupData[{
Cell[33668, 1233, 102, 3, 26, "Input",
  CellTags->"ToDate::tdn"],
Cell[33773, 1238, 111, 3, 21, "Output",
  CellTags->"ToDate::tdn"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[33945, 1248, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::dirdep"],
Cell[34031, 1251, 411, 12, 21, "Message",
  CellTags->"General::dirdep"],
Cell[34445, 1265, 475, 9, 84, "Notes",
  CellTags->"General::dirdep"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34957, 1279, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::enable"],
Cell[35043, 1282, 419, 12, 21, "Message",
  CellTags->"General::enable"],
Cell[35465, 1296, 412, 11, 46, "Notes",
  CellTags->"General::enable"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35914, 1312, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::fstr"],
Cell[35996, 1315, 443, 12, 21, "Message",
  CellTags->"General::fstr"],
Cell[36442, 1329, 256, 6, 46, "Notes",
  CellTags->"General::fstr"],

Cell[CellGroupData[{
Cell[36723, 1339, 63, 1, 38, "ExampleSection",
  CellTags->"General::fstr"],
Cell[36789, 1342, 157, 4, 24, "Text",
  CellTags->"General::fstr"],

Cell[CellGroupData[{
Cell[36971, 1350, 98, 3, 26, "Input",
  CellTags->"General::fstr"],
Cell[37072, 1355, 207, 5, 21, "Message",
  CellTags->"General::fstr"],
Cell[37282, 1362, 99, 3, 21, "Output",
  CellTags->"General::fstr"]
}, Open  ]],
Cell[37396, 1368, 124, 5, 24, "Text",
  CellTags->"General::fstr"],

Cell[CellGroupData[{
Cell[37545, 1377, 120, 3, 26, "Input",
  CellTags->"General::fstr"],
Cell[37668, 1382, 91, 3, 21, "Output",
  CellTags->"General::fstr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[37820, 1392, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::hmdir"],
Cell[37904, 1395, 375, 11, 37, "Message",
  CellTags->"General::hmdir"],
Cell[38282, 1408, 312, 7, 40, "Notes",
  CellTags->"General::hmdir"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38631, 1420, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::initstate"],
Cell[38723, 1423, 383, 11, 21, "Message",
  CellTags->"General::initstate"],
Cell[39109, 1436, 429, 9, 62, "Notes",
  CellTags->"General::initstate"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39575, 1450, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::longp"],
Cell[39659, 1453, 346, 10, 21, "Message",
  CellTags->"General::longp"],
Cell[40008, 1465, 409, 8, 68, "Notes",
  CellTags->"General::longp"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40454, 1478, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nfdir"],
Cell[40538, 1481, 356, 11, 21, "Message",
  CellTags->"General::nfdir"],
Cell[40897, 1494, 488, 10, 84, "Notes",
  CellTags->"General::nfdir"],

Cell[CellGroupData[{
Cell[41410, 1508, 64, 1, 38, "ExampleSection",
  CellTags->"General::nfdir"],
Cell[41477, 1511, 169, 4, 24, "Text",
  CellTags->"General::nfdir"],

Cell[CellGroupData[{
Cell[41671, 1519, 145, 3, 26, "Input",
  CellTags->"General::nfdir"],
Cell[41819, 1524, 99, 3, 21, "Output",
  CellTags->"General::nfdir"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41955, 1532, 165, 4, 26, "Input",
  CellTags->"General::nfdir"],
Cell[42123, 1538, 229, 5, 37, "Message",
  CellTags->"General::nfdir"],
Cell[42355, 1545, 95, 3, 21, "Output",
  CellTags->"General::nfdir"]
}, Open  ]],
Cell[42465, 1551, 62, 1, 24, "Text",
  CellTags->"General::nfdir"],
Cell[42530, 1554, 114, 3, 26, "Input",
  CellTags->"General::nfdir"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[42693, 1563, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::nffil"],
Cell[42777, 1566, 351, 11, 21, "Message",
  CellTags->"General::nffil"],
Cell[43131, 1579, 499, 10, 68, "Notes",
  CellTags->"General::nffil"],

Cell[CellGroupData[{
Cell[43655, 1593, 64, 1, 38, "ExampleSection",
  CellTags->"General::nffil"],
Cell[43722, 1596, 226, 6, 40, "Text",
  CellTags->"General::nffil"],

Cell[CellGroupData[{
Cell[43973, 1606, 109, 3, 26, "Input",
  CellTags->"General::nffil"],
Cell[44085, 1611, 186, 4, 21, "Message",
  CellTags->"General::nffil"],
Cell[44274, 1617, 95, 3, 21, "Output",
  CellTags->"General::nffil"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[44430, 1627, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::privv"],
Cell[44514, 1630, 348, 11, 21, "Message",
  CellTags->"General::privv"],
Cell[44865, 1643, 399, 8, 62, "Notes",
  CellTags->"General::privv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[45301, 1656, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::unuser"],
Cell[45387, 1659, 349, 11, 21, "Message",
  CellTags->"General::unuser"],
Cell[45739, 1672, 608, 13, 100, "Notes",
  CellTags->"General::unuser"]
}, Open  ]],

Cell[CellGroupData[{
Cell[46384, 1690, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::addsyms"],
Cell[46472, 1693, 418, 12, 21, "Message",
  CellTags->"General::addsyms"],
Cell[46893, 1707, 196, 6, 24, "Notes",
  CellTags->"General::addsyms"]
}, Open  ]],

Cell[CellGroupData[{
Cell[47126, 1718, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::autoload"],
Cell[47216, 1721, 321, 6, 69, "Message",
  CellTags->"General::autoload"],
Cell[47540, 1729, 492, 11, 84, "Notes",
  CellTags->"General::autoload"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48069, 1745, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::badsys1"],
Cell[48157, 1748, 221, 5, 37, "Message",
  CellTags->"General::badsys1"],
Cell[48381, 1755, 499, 10, 62, "Notes",
  CellTags->"General::badsys1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[48917, 1770, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::badsys4"],
Cell[49005, 1773, 222, 5, 37, "Message",
  CellTags->"General::badsys4"],
Cell[49230, 1780, 369, 7, 62, "Notes",
  CellTags->"General::badsys4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[49636, 1792, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::badsys2"],
Cell[49724, 1795, 201, 5, 21, "Message",
  CellTags->"General::badsys2"],
Cell[49928, 1802, 370, 8, 62, "Notes",
  CellTags->"General::badsys2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[50335, 1815, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::badsys3"],
Cell[50423, 1818, 250, 5, 37, "Message",
  CellTags->"General::badsys3"],
Cell[50676, 1825, 456, 10, 62, "Notes",
  CellTags->"General::badsys3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[51169, 1840, 79, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::dstr"],
Cell[51251, 1843, 179, 4, 19, "Message",
  CellTags->"General::dstr"],
Cell[51433, 1849, 354, 8, 46, "Notes",
  CellTags->"General::dstr"],

Cell[CellGroupData[{
Cell[51812, 1861, 63, 1, 38, "ExampleSection",
  CellTags->"General::dstr"],
Cell[51878, 1864, 184, 5, 24, "Text",
  CellTags->"General::dstr"],

Cell[CellGroupData[{
Cell[52087, 1873, 112, 3, 26, "Input",
  CellTags->"General::dstr"],
Cell[52202, 1878, 182, 4, 19, "Message",
  CellTags->"General::dstr"],
Cell[52387, 1884, 88, 3, 25, "Output",
  CellTags->"General::dstr"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52536, 1894, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"General::sysfile"],
Cell[52624, 1897, 199, 5, 19, "Message",
  CellTags->"General::sysfile"],
Cell[52826, 1904, 323, 7, 62, "Notes",
  CellTags->"General::sysfile"]
}, Open  ]],

Cell[CellGroupData[{
Cell[53186, 1916, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"SetFileDate::toobig"],
Cell[53280, 1919, 173, 3, 19, "Message",
  CellTags->"SetFileDate::toobig"],
Cell[53456, 1924, 130, 4, 24, "Notes",
  CellTags->"SetFileDate::toobig"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

