(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     44326,       1452]*)
(*NotebookOutlinePosition[     75784,       2090]*)
(*  CellTagsIndexPosition[     71703,       2010]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["XML", "Title"],

Cell[CellGroupData[{

Cell["Export::xmloptv", "ObjectNameWarningMessages",
  CellTags->"Export::xmloptv"],

Cell[BoxData[
    \(Export::"xmloptv" \(\(:\)\(\ \)\) \(The\ value\ of\ option\ `1`\ in\ \
`2`\ is\ not\ valid\ in\ the\ exporting\ of\ the\ SymbolicXML\ \(\(`3`\)\(.\)\
\)\)\)], "Message",
  CellTags->"Export::xmloptv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::xmloptv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export::xmloptx", "ObjectNameWarningMessages",
  CellTags->"Export::xmloptx"],

Cell[BoxData[
    RowBox[{\(Export::"xmloptx"\), \(\(:\)\(\ \)\), "Unknown", " ", "option", 
      " ", 
      StyleBox["opt",
        "TI"], " ", "encountered", " ", "in", " ", "the", " ", "exporting", 
      " ", "of", " ", "the", " ", "SymbolicXML", " ", 
      RowBox[{
        StyleBox["expr",
          "TI"], "."}]}]], "Message",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"Export::xmloptx"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"Export::xmloptx"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLElement::attlhs", "ObjectNameWarningMessages",
  CellTags->"XMLElement::attlhs"],

Cell[BoxData[
    \(XMLElement::"attlhs" \(\(:\)\(\ \)\) \(`1`\ in\ `2`\ is\ not\ a\ valid\ \
name\ for\ an\ attribute\ in\ an\ XMLElement . \ \ It\ must\ be\ either\ a\ \
String\ \((for\ the\ localname)\)\ or\ a\ List\ of\ two\ Strings\ \(\((for\ \
the\ {namespace, \ localname}\ pair)\)\(.\)\)\)\)], "Message",
  CellTags->"XMLElement::attlhs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLElement::attlhs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLElement::attrhs", "ObjectNameWarningMessages",
  CellTags->"XMLElement::attrhs"],

Cell[BoxData[
    \(XMLElement::"attrhs" \(\(:\)\(\ \)\) \(`1`\ in\ `2`\ is\ not\ a\ valid\ \
value\ for\ an\ attribute\ in\ an\ XMLElement . \ \ The\ value\ of\ the\ \
attribute\ must\ be\ a\ \(\(String\)\(.\)\)\)\)], "Message",
  CellTags->"XMLElement::attrhs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLElement::attrhs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLElement::attrslst", "ObjectNameWarningMessages",
  CellTags->"XMLElement::attrslst"],

Cell[BoxData[
    \(XMLElement::"attrslst" \(\(:\)\(\ \)\) \(`1`\ in\ `2`\ is\ not\ a\ List\
\ of\ attributes . \ \ The\ second\ item\ in\ an\ XMLElement\ must\ be\ a\ \
List\ of\ attributes, \ 
      even\ if\ it\ is\ an\ empty\ \(\(list\)\(.\)\)\)\)], "Message",
  CellTags->"XMLElement::attrslst"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLElement::attrslst"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLElement::attrule", "ObjectNameWarningMessages",
  CellTags->"XMLElement::attrule"],

Cell[BoxData[
    \(XMLElement::"attrule" \(\(:\)\(\ \)\) 
      "`1` in `2` is not a valid attribute.  Attributes must be specified in \
the form \"name\"->\"value\" or {\"namespace\",\"localname\"}->\"value\""\)], \
"Message",
  CellLabel->"From In[98]:=",
  CellTags->"XMLElement::attrule"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLElement::attrule"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLElement::cnts", "ObjectNameWarningMessages",
  CellTags->"XMLElement::cnts"],

Cell[BoxData[
    \(XMLElement::"cnts" \(\(:\)\(\ \)\) \(`1`\ is\ not\ valid\ in\ the\ \
contents\ of\ an\ XMLElement . \ 
          The\ contents\ of\ an\ XMLElement\ must\ consist\ of\ Strings\ and\ \
\(\(XMLElements\)\(.\)\)\)\)], "Message",
  CellTags->"XMLElement::cnts"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLElement::cnts"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLElement::cntsList", "ObjectNameWarningMessages",
  CellTags->"XMLElement::cntsList"],

Cell[BoxData[
    \(XMLElement::"cntsList" \(\(:\)\(\ \)\) \(`1`\ in\ `2`\ is\ not\ a\ List\
\ of\ contents . \ \ The\ third\ item\ in\ an\ XMLElement\ must\ be\ a\ List\ \
of\ contents, \ even\ if\ it\ is\ an\ empty\ \(\(List\)\(.\)\)\)\)], "Message",\

  CellTags->"XMLElement::cntsList"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLElement::cntsList"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLElement::name", "ObjectNameWarningMessages",
  CellTags->"XMLElement::name"],

Cell[BoxData[
    \(XMLElement::"name" \(\(:\)\(\ \)\) \(`1`\ in\ `2`\ is\ not\ a\ valid\ \
name\ for\ an\ XMLElement . \ \ It\ must\ be\ either\ a\ String\ \((for\ the\ \
localname)\)\ or\ a\ List\ of\ two\ Strings\ \(\((for\ the\ {namespace, \ 
                localname}\ pair)\)\(.\)\)\)\)], "Message",
  CellTags->"XMLElement::name"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLElement::name"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLElement::unqatt", "ObjectNameWarningMessages",
  CellTags->"XMLElement::unqatt"],

Cell[BoxData[
    \(XMLElement::"unqatt" \(\(:\)\(\ \)\) \(The\ attribute\ name\ \((`1`)\)\ \
in\ `2`\ is\ not\ \(unique\ --\)\ there\ is\ already\ an\ attribute\ with\ \
this\ name\ in\ the\ same\ XMLElement . \ \ Two\ attributes\ with\ the\ same\ \
name\ cannot\ exist\ inside\ the\ same\ \(\(element\)\(.\)\)\)\)], "Message",
  CellTags->"XMLElement::unqatt"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLElement::unqatt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLObject::decunsv", "ObjectNameWarningMessages",
  CellTags->"XMLObject::decunsv"],

Cell[BoxData[
    \(XMLObject::"decunsv" \(\(:\)\(\ \)\) 
      "`1` in `2` is not a valid setting for the Version option in an \
XMLObject[\"Declaration\"].  The only setting that is supported is \
\"1.0\"."\)], "Message",
  CellLabel->"From In[98]:=",
  CellTags->"XMLObject::decunsv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLObject::decunsv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLObject::decvfst", "ObjectNameWarningMessages",
  CellTags->"XMLObject::decvfst"],

Cell[BoxData[
    \(XMLObject::"decvfst" \(\(:\)\(\ \)\) 
      "`1` in `2` is not a Version option.  The first option to \
XMLObject[\"Declaration\"] must be of the form \"Version\"->_String"\)], \
"Message",
  CellLabel->"From In[98]:=",
  CellTags->"XMLObject::decvfst"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLObject::decvfst"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLObject::decvreq", "ObjectNameWarningMessages",
  CellTags->"XMLObject::decvreq"],

Cell[BoxData[
    \(XMLObject::"decvreq" \(\(:\)\(\ \)\) 
      "`1` has no \"Version\" option -- the \"Version\" option is required to \
be the first item in an XMLObject[\"Declaration\"]."\)], "Message",
  CellLabel->"From In[98]:=",
  CellTags->"XMLObject::decvreq"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLObject::decvreq"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLObject::declfst", "ObjectNameWarningMessages",
  CellTags->"XMLObject::declfst"],

Cell[BoxData[
    \(XMLObject::"declfst" \(\(:\)\(\ \)\) 
      "The XMLObject[\"Declaration\"] is not in position 1 of `1`.  If \
present, an XMLObject[\"Declaration\"] must be the first item in the prolog \
of an XMLObject[\"Document\"]."\)], "Message",
  CellLabel->"From In[99]:=",
  CellTags->"XMLObject::declfst"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLObject::declfst"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLObject::docbarg", "ObjectNameWarningMessages",
  CellTags->"XMLObject::docbarg"],

Cell[BoxData[
    \(XMLObject::"docbarg" \(\(:\)\(\ \)\) \(The\ argument\ at\ position\ `1`\
\ in\ `2`\ is\ expected\ to\ be\ a\ `3`\)\)], "Message",
  CellTags->"XMLObject::docbarg"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLObject::docbarg"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLObject::docep", "ObjectNameWarningMessages",
  CellTags->"XMLObject::docep"],

Cell[BoxData[
    \(XMLObject::"docep" \(\(:\)\(\ \)\) 
      "`1` in `2` is not allowed in the List at position 3 of an \
XMLObject[\"Document\"].  Only XMLObject[\"Comment\"] and \
XMLObject[\"ProcessingInstruction\"] are allowed."\)], "Message",
  CellLabel->"From In[99]:=",
  CellTags->"XMLObject::docep"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLObject::docep"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLObject::docprlgi", "ObjectNameWarningMessages",
  CellTags->"XMLObject::docprlgi"],

Cell[BoxData[
    \(XMLObject::"docprlgi" \(\(:\)\(\ \)\) 
      "`1` in `2` is not allowed in the prolog of an XMLObject[\"Document\"]. \
 Only XMLObject[\"Declaration\"], XMLObject[\"Doctype\"], XMLObject[\"Comment\
\"] and XMLObject[\"ProccesingInstruction\"] are allowed in the prolog."\)], \
"Message",
  CellLabel->"From In[99]:=",
  CellTags->"XMLObject::docprlgi"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLObject::docprlgi"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLObject::dtrtstr", "ObjectNameWarningMessages",
  CellTags->"XMLObject::dtrtstr"],

Cell[BoxData[
    \(XMLObject::"dtrtstr" \(\(:\)\(\ \)\) 
      "`1` in `2` is not a String.  The first item in an \
XMLObject[\"Doctype\"] must be a String that is the name of the root  \
element."\)], "Message",
  CellLabel->"From In[99]:=",
  CellTags->"XMLObject::dtrtstr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLObject::dtrtstr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLObject::slone", "ObjectNameWarningMessages",
  CellTags->"XMLObject::slone"],

Cell[BoxData[
    \(XMLObject::"slone" \(\(:\)\(\ \)\) 
      "`1` in `2` is not a vaid setting for the \"Standalone\" option to \
XMLObject[\"Declaration\"].  The option can only be set to \"yes\" or \"no\", \
and is case-sensitive."\)], "Message",
  CellLabel->"From In[101]:=",
  CellTags->"XMLObject::slone"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLObject::slone"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLObject::unq", "ObjectNameWarningMessages",
  CellTags->"XMLObject::unq"],

Cell[BoxData[
    \(XMLObject::"unq" \(\(:\)\(\ \)\) \(There\ is\ more\ than\ one\ \
occurrence\ of\ `1`\ in\ `2` . \ \ `1`\ is\ required\ to\ be\ \(\(unique\)\(.\
\)\)\)\)], "Message",
  CellTags->"XMLObject::unq"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLObject::unq"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMLObject::unsenc", "ObjectNameWarningMessages",
  CellTags->"XMLObject::unsenc"],

Cell[BoxData[
    \(XMLObject::"unsenc" \(\(:\)\(\ \)\) \(`1`\ in\ `2`\ is\ not\ a\ \
supported\ setting\ for\ the\ encoding . \ \ The\ only\ supported\ encodings\ \
are\ UTF - 8\ and\ US - \(\(ASCII\)\(.\)\)\)\)], "Message",
  CellTags->"XMLObject::unsenc"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XMLObject::unsenc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`SymbolicXMLErrors::unknobj", "ObjectNameWarningMessages",
  CellTags->"XML`SymbolicXMLErrors::unknobj"],

Cell[BoxData[
    \(XML`SymbolicXMLErrors::"unknobj" \(\(:\)\(\ \)\) \(`1`\ is\ not\ a\ \
recognized\ SymbolicXML\ object . \ \ The\ only\ valid\ SymbolicXML\ objects\ \
are\ XMLElement\ and\ \(\(XMLObject\)\(.\)\)\)\)], "Message",
  CellTags->"XML`SymbolicXMLErrors::unknobj"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`SymbolicXMLErrors::unknobj"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`BoxesToSymbolicMathML::badba", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::badba"],

Cell[BoxData[
    \(XML`MathML`BoxesToSymbolicMathML::"badba" \(\(:\)\(\ \)\) \(An\ error\ \
occurred\ when\ translating\ a\ box\ expression\ or\ an\ annotation\ to\ \
SymbolicMathML . \ 
          The\ box\ expression\ or\ annotation\ has\ been\ \(\(ignored\)\(.\)\
\)\)\)], "Message",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::badba"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::badba"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`BoxesToSymbolicMathML::incasmml", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::incasmml"],

Cell[BoxData[
    \(XML`MathML`BoxesToSymbolicMathML::"incasmml" \(\(:\)\(\ \)\) \(Internal\
\ MathML\ processing\ error . \ 
          Attributes\ where\ wrapped\ around\ a\ leaf\ tag\ which\ should\ \
never\ happen . \ 
          The\ leaf\ is\ `1`\ and\ the\ converted\ attributes\ are\ `2` . \ 
          Please\ report\ \(\(this\)\(.\)\)\)\)], "Message",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::incasmml"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::incasmml"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`BoxesToSymbolicMathML::uncnvbxs", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::uncnvbxs"],

Cell[BoxData[
    \(XML`MathML`BoxesToSymbolicMathML::"uncnvbxs" \(\(:\)\(\ \)\) \(The\ \
boxes\ `1`\ are\ not\ convertible\ to\ \(\(SymbolicXML\)\(.\)\)\)\)], \
"Message",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::uncnvbxs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::uncnvbxs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`BoxesToSymbolicMathML::unrecf", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::unrecf"],

Cell[BoxData[
    \(XML`MathML`BoxesToSymbolicMathML::"unrecf" \(\(:\)\(\ \)\) \(The\ \
format\ `1`\ is\ not\ a\ recognized\ annotation\ for\ \
\(\(MathML\)\(.\)\)\)\)], "Message",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::unrecf"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::unrecf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`BoxesToSymbolicMathML::attrule", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attrule"],

Cell[BoxData[
    \(XML`MathML`BoxesToSymbolicMathML::"attrule" \(\(:\)\(\ \)\) 
      "`1` is not a valid xml attribute to attach to the root <math> tag.  \
Attributes must be specified in the form \"name\"->\"value\" or \
{\"namespace\",\"localname\"}->\"value\""\)], "Message",
  CellLabel->"From In[101]:=",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attrule"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attrule"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`BoxesToSymbolicMathML::attlhs", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attlhs"],

Cell[BoxData[
    \(XML`MathML`BoxesToSymbolicMathML::"attlhs" \(\(:\)\(\ \)\) \(`1`\ in\ \
`2`\ is\ not\ a\ valid\ name\ for\ an\ attribute\ to\ attach\ to\ the\ root\  \
< math > \ 
        tag . \ \ An\ attribute\ name\ must\ be\ either\ a\ String\ \((for\ \
the\ localname)\)\ or\ a\ List\ of\ two\ Strings\ \(\((for\ the\ {namespace, \
\ localname}\ pair)\)\(.\)\)\)\)], "Message",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attlhs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attlhs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`BoxesToSymbolicMathML::attrhs", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attrhs"],

Cell[BoxData[
    \(XML`MathML`BoxesToSymbolicMathML::"attrhs" \(\(:\)\(\ \)\) \(`1`\ in\ \
`2`\ is\ not\ a\ valid\ value\ for\ an\ attribute\ to\ attach\ to\ the\ root\ \
 < math > \ 
        tag . \ The\ value\ of\ the\ attribute\ must\ be\ a\ \
\(\(String\)\(.\)\)\)\)], "Message",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attrhs"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attrhs"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`SymbolicMathMLToBoxes::bmml", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::bmml"],

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToBoxes::"bmml" \(\(:\)\(\ \)\) \(The\ `1`, \ \
`2`, \ occurred\ without\ a\ surrounding\ xml\ tag . \ 
          An\ attempt\ has\ been\ made\ to\ correct\ this\ \
\(\(defect\)\(.\)\)\)\)], "Message",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::bmml"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::bmml"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`SymbolicMathMLToBoxes::incrt", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::incrt"],

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToBoxes::"incrt" \(\(:\)\(\ \)\) 
      "The SymbolicMathML structure being interpreted has the root tag \
\"`1`\" instead of the correct tag \"math\"."\)], "Message",
  CellLabel->"From In[101]:=",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::incrt"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::incrt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`SymbolicMathMLToBoxes::invsmml", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::invsmml"],

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToBoxes::"invsmml" \(\(:\)\(\ \)\) 
      "The structure \"`1`\" attempting to be converted to boxes is not a \
valid SymbolicMathML structure."\)], "Message",
  CellLabel->"From In[101]:=",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::invsmml"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::invsmml"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`SymbolicMathMLToBoxes::malsmml", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::malsmml"],

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToBoxes::"malsmml" \(\(:\)\(\ \)\) 
      "The structure \"`1`\" attempting to be converted to boxes has a \
malformed XML structure."\)], "Message",
  CellLabel->"From In[102]:=",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::malsmml"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::malsmml"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`SymbolicMathMLToBoxes::nmmlr", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::nmmlr"],

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToBoxes::"nmmlr" \(\(:\)\(\ \)\) 
      "The structure \"`1`\" attempting to be converted to boxes has the root \
XML tag \"`2`\", which is not a recognized MathML tag."\)], "Message",
  CellLabel->"From In[102]:=",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::nmmlr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::nmmlr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`SymbolicMathMLToBoxes::unknstrc", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::unknstrc"],

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToBoxes::"unknstrc" \(\(:\)\(\ \)\) \(`1`\ is\ \
not\ a\ valid\ MathML\ \(\(structure\)\(.\)\)\)\)], "Message",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::unknstrc"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::unknstrc"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`SymbolicMathMLToBoxes::unkntag", "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::unkntag"],

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToBoxes::"unkntag" \(\(:\)\(\ \)\) \(`1`\ is\ \
not\ a\ valid\ MathML\ tag . \ 
          The\ tag\ `1`\ is\ being\ treated\ as\ a\ \(\(symbol\)\(.\)\)\)\)], \
"Message",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::unkntag"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::unkntag"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`SymbolicMathMLToExpression::invsmml", \
"ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::invsmml"],

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToExpression::"invsmml" \(\(:\)\(\ \)\) 
      "The structure \"`1`\" attempting to be converted to an expression is \
not a valid SymbolicMathML structure."\)], "Message",
  CellLabel->"From In[102]:=",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::invsmml"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::invsmml"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`SymbolicMathMLToExpression::malsmml", \
"ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::malsmml"],

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToExpression::"malsmml" \(\(:\)\(\ \)\) 
      "The structure \"`1`\" attempting to be converted to an expression has \
a malformed XML structure."\)], "Message",
  CellLabel->"From In[102]:=",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::malsmml"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::malsmml"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`MathML`SymbolicMathMLToExpression::nmmlr", \
"ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::nmmlr"],

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToExpression::"nmmlr" \(\(:\)\(\ \)\) 
      "The structure \"`1`\" attempting to be converted to an expression has \
the root XML tag \"`2`\", which is not a recognized MathML tag."\)], "Message",\

  CellLabel->"From In[103]:=",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::nmmlr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::nmmlr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`NotebookML`NotebookToSymbolicNotebookML::badobj", \
"ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::badobj"],

Cell[BoxData[
    \(XML`NotebookML`NotebookToSymbolicNotebookML::"badobj" \(\(:\)\(\ \)\) \
\(Malformed\ notebook\ fragment\ `1`\ encountered . \ \ The\ fragment\ is\ \
being\ converted\ to\ \(\(SymbolicExpressionML\)\(.\)\)\)\)], "Message",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::badobj"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::badobj"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`NotebookML`NotebookToSymbolicNotebookML::filonb", \
"ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::filonb"],

Cell[BoxData[
    \(XML`NotebookML`NotebookToSymbolicNotebookML::"filonb" \(\(:\)\(\ \)\) \
\(Filename, \ Notebook\ Expression, \ 
      or\ NotebookObject\ expected\ at\ position\ 1\ in\ \
\(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::filonb"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::filonb"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv", \
"ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv"],

Cell[BoxData[
    \(XML`NotebookML`NotebookToSymbolicNotebookML::"nogrcnv" \(\(:\)\(\ \)\) \
\(A\ front\ end\ is\ not\ available . \ 
          A\ front\ end\ is\ necessary\ to\ translate\ the\ `1`\ into\ the\ \
`2`\ graphics\ \(\(format\)\(.\)\)\)\)], "Message",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd", \
"ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd"],

Cell[BoxData[
    \(XML`NotebookML`NotebookToSymbolicNotebookML::"unrecbd" \(\(:\)\(\ \)\) \
\(There\ is\ no\ built\ in\ conversion\ for\ BoxData\ objects\ to\ \
\(\(`1`\)\(.\)\)\)\)], "Message",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd", \
"ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd"],

Cell[BoxData[
    \(XML`NotebookML`NotebookToSymbolicNotebookML::"unrecgd" \(\(:\)\(\ \)\) \
\(There\ is\ no\ built\ in\ conversion\ for\ GraphicsData\ encoded\ as\ `1`\ \
to\ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns", \
"ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns"],

Cell[BoxData[
    \(XML`NotebookML`SymbolicExpressionMLToExpression::"nbmlns" \(\(:\)\(\ \)\
\) \(`1`\ is\ not\ in\ the\ NotebookML\ Namespace, \ 
      it\ is\ in\ the\ null\ namespace . \ 
          Mathematica\ is\ assuming\ that\ it\ was\ intended\ to\ be\ in\ the\
\ NotebookML\ \(\(Namespace\)\(.\)\)\)\)], "Message",
  CellTags->"XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes", \
"ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes"],

Cell[BoxData[
    \(XML`NotebookML`SymbolicNotebookMLToNotebook::"noboxes" \(\(:\)\(\ \)\) \
\(A\ NotebookML\ BoxData\ element\ did\ not\ contain\ interpretable\ \
information . \ \ It\ cannot\ be\ displayed\ \(\(correctly\)\(.\)\)\)\)], \
"Message",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx", \
"ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx"],

Cell[BoxData[
    \(XML`NotebookML`SymbolicNotebookMLToNotebook::"nogrphx" \(\(:\)\(\ \)\) \
\(A\ NotebookML\ GraphicsData\ element\ did\ not\ contain\ interpretable\ \
information . \ \ It\ cannot\ be\ displayed\ \(\(correctly\)\(.\)\)\)\)], \
"Message",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns", \
"ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns"],

Cell[BoxData[
    \(XML`NotebookML`SymbolicNotebookMLToNotebook::"nbmlns" \(\(:\)\(\ \)\) \
\(`1`\ is\ not\ in\ the\ NotebookML\ Namespace, \ 
      it\ is\ in\ the\ null\ namespace . \ 
          Mathematica\ is\ assuming\ that\ it\ was\ intended\ to\ be\ in\ the\
\ NotebookML\ \(\(Namespace\)\(.\)\)\)\)], "Message",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml", \
"ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml"],

Cell[BoxData[
    \(XML`NotebookML`SymbolicNotebookMLToNotebook::"unknxml" \(\(:\)\(\ \)\) \
\(`1`\ is\ not\ a\ valid\ NotebookML\ \(\(expression\)\(.\)\)\)\)], "Message",\

  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`InitializeXMLParser::memfail", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`InitializeXMLParser::memfail"],

Cell[BoxData[
    \(XML`Parser`InitializeXMLParser::"memfail" \(\(:\)\(\ \)\) \(XMLInit\ \
failed\ due\ to\ a\ problem\ allocating\ \(\(memory\)\(.\)\)\)\)], "Message",
  CellTags->"XML`Parser`InitializeXMLParser::memfail"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`InitializeXMLParser::memfail"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`InitializeXMLParser::nfprserr", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`InitializeXMLParser::nfprserr"],

Cell[BoxData[
    \(XML`Parser`InitializeXMLParser::"nfprserr" \(\(:\)\(\ \)\) `1`\)], \
"Message",
  CellTags->"XML`Parser`InitializeXMLParser::nfprserr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`InitializeXMLParser::nfprserr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`InitializeXMLParser::prserr", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`InitializeXMLParser::prserr"],

Cell[BoxData[
    \(XML`Parser`InitializeXMLParser::"prserr" \(\(:\)\(\ \)\) `1`\)], \
"Message",
  CellTags->"XML`Parser`InitializeXMLParser::prserr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`InitializeXMLParser::prserr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`ReleaseXMLParser::ilgprsr", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`ReleaseXMLParser::ilgprsr"],

Cell[BoxData[
    \(XML`Parser`ReleaseXMLParser::"ilgprsr" \(\(:\)\(\ \)\) 
      XMLParser[`1`]\)], "Message",
  CellTags->"XML`Parser`ReleaseXMLParser::ilgprsr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`ReleaseXMLParser::ilgprsr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`XMLGet::badop", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::badop"],

Cell[BoxData[
    \(XML`Parser`XMLGet::"badop" \(\(:\)\(\ \)\) \(Option\ `1`\ cannot\ take\ \
a\ value\ of\ `2` . \ \ It\ can\ only\ take\ \(\(`3`\)\(.\)\)\)\)], "Message",\

  CellTags->"XML`Parser`XMLGet::badop"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`XMLGet::badop"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`XMLGet::ilgprsr", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::ilgprsr"],

Cell[BoxData[
    \(XML`Parser`XMLGet::"ilgprsr" \(\(:\)\(\ \)\) 
      XMLParser[`1`]\)], "Message",
  CellTags->"XML`Parser`XMLGet::ilgprsr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`XMLGet::ilgprsr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`XMLGet::memfail", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::memfail"],

Cell[BoxData[
    \(XML`Parser`XMLGet::"memfail" \(\(:\)\(\ \)\) \(XMLGet\ failed\ due\ to\ \
a\ problem\ allocating\ \(\(memory\)\(.\)\)\)\)], "Message",
  CellTags->"XML`Parser`XMLGet::memfail"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`XMLGet::memfail"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`XMLGet::nfprserr", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::nfprserr"],

Cell[BoxData[
    \(XML`Parser`XMLGet::"nfprserr" \(\(:\)\(\ \)\) `1`\)], "Message",
  CellTags->"XML`Parser`XMLGet::nfprserr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`XMLGet::nfprserr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`XMLGet::prserr", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::prserr"],

Cell[BoxData[
    \(XML`Parser`XMLGet::"prserr" \(\(:\)\(\ \)\) `1`\)], "Message",
  CellTags->"XML`Parser`XMLGet::prserr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`XMLGet::prserr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`XMLGet::put", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::put"],

Cell[BoxData[
    \(XML`Parser`XMLGet::"put" \(\(:\)\(\ \)\) \(MathLink\ error\ when\ \
generating\ output . \ \ MathLink\ \(error : \ \(\(`1`\)\(.\)\)\)\)\)], \
"Message",
  CellTags->"XML`Parser`XMLGet::put"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`XMLGet::put"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`XMLGet::unknop", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::unknop"],

Cell[BoxData[
    \(XML`Parser`XMLGet::"unknop" \(\(:\)\(\ \)\) \(`1`\ is\ not\ a\ \
recognized\ \(\(option\)\(.\)\)\)\)], "Message",
  CellTags->"XML`Parser`XMLGet::unknop"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`XMLGet::unknop"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`XMLGet::xmlprsop", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::xmlprsop"],

Cell[BoxData[
    \(XML`Parser`XMLGet::"xmlprsop" \(\(:\)\(\ \)\) \(XMLParser\ object\ or\ \
option\ expected\ at\ position\ `1`\ in\ \(\(`2`\)\(.\)\)\)\)], "Message",
  CellTags->"XML`Parser`XMLGet::xmlprsop"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`XMLGet::xmlprsop"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`XMLGetString::ilgprsr", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGetString::ilgprsr"],

Cell[BoxData[
    \(XML`Parser`XMLGetString::"ilgprsr" \(\(:\)\(\ \)\) 
      XMLParser[`1`]\)], "Message",
  CellTags->"XML`Parser`XMLGetString::ilgprsr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`XMLGetString::ilgprsr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`XMLGetString::memfail", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGetString::memfail"],

Cell[BoxData[
    \(XML`Parser`XMLGetString::"memfail" \(\(:\)\(\ \)\) \(XMLGetString\ \
failed\ due\ to\ a\ problem\ allocating\ \(\(memory\)\(.\)\)\)\)], "Message",
  CellTags->"XML`Parser`XMLGetString::memfail"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`XMLGetString::memfail"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`XMLGetString::nfprserr", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGetString::nfprserr"],

Cell[BoxData[
    \(XML`Parser`XMLGetString::"nfprserr" \(\(:\)\(\ \)\) `1`\)], "Message",
  CellTags->"XML`Parser`XMLGetString::nfprserr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`XMLGetString::nfprserr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`XMLGetString::prserr", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGetString::prserr"],

Cell[BoxData[
    \(XML`Parser`XMLGetString::"prserr" \(\(:\)\(\ \)\) `1`\)], "Message",
  CellTags->"XML`Parser`XMLGetString::prserr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`XMLGetString::prserr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`XMLGetString::xmlprsop", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGetString::xmlprsop"],

Cell[BoxData[
    \(XML`Parser`XMLGetString::"xmlprsop" \(\(:\)\(\ \)\) \(XMLParser\ object\
\ or\ option\ expected\ at\ position\ `1`\ in\ \(\(`2`\)\(.\)\)\)\)], \
"Message",
  CellTags->"XML`Parser`XMLGetString::xmlprsop"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`XMLGetString::xmlprsop"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`SVG`GraphicsToSymbolicSVG::bdmgr", "ObjectNameWarningMessages",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bdmgr"],

Cell[BoxData[
    \(XML`SVG`GraphicsToSymbolicSVG::"bdmgr" \(\(:\)\(\ \)\) \(There\ appears\
\ to\ be\ an\ error\ in\ the\ Graphics\ being\ converted . \ 
          Some\ parts\ of\ the\ graphic\ expression\ may\ be\ incorrectly\ \(\
\(translated\)\(.\)\)\)\)], "Message",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bdmgr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bdmgr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`SVG`GraphicsToSymbolicSVG::bsvgf", "ObjectNameWarningMessages",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgf"],

Cell[BoxData[
    \(XML`SVG`GraphicsToSymbolicSVG::"bsvgf" \(\(:\)\(\ \)\) \(Unexpected\ \
\(form : \ `1`\)\)\)], "Message",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgf"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgf"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`SVG`GraphicsToSymbolicSVG::bsvgns", "ObjectNameWarningMessages",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgns"],

Cell[BoxData[
    \(XML`SVG`GraphicsToSymbolicSVG::"bsvgns" \(\(:\)\(\ \)\) \(Unexpected\ \
\(ToSVGNumberString : \ `1`\)\)\)], "Message",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgns"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgns"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`SVG`GraphicsToSymbolicSVG::gtype", "ObjectNameWarningMessages",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::gtype"],

Cell[BoxData[
    \(XML`SVG`GraphicsToSymbolicSVG::"gtype" \(\(:\)\(\ \)\) \(`1`\ is\ not\ \
a\ type\ of\ \(\(graphics\)\(.\)\)\)\)], "Message",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::gtype"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::gtype"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`SVG`GraphicsToSymbolicSVG::ncvrt", "ObjectNameWarningMessages",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::ncvrt"],

Cell[BoxData[
    \(XML`SVG`GraphicsToSymbolicSVG::"ncvrt" \(\(:\)\(\ \)\) \(Conversion\ \
from\ Graphics\ to\ SVG\ is\ missing\ a\ conversion\ for\ `1`\)\)], "Message",\

  CellTags->"XML`SVG`GraphicsToSymbolicSVG::ncvrt"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::ncvrt"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`SVG`SymbolicSVGToGraphics::unsup", "ObjectNameWarningMessages",
  CellTags->"XML`SVG`SymbolicSVGToGraphics::unsup"],

Cell[BoxData[
    \(XML`SVG`SymbolicSVGToGraphics::"unsup" \(\(:\)\(\ \)\) \(SVG\ import\ \
is\ not\ currently\ \(\(supported\)\(.\)\)\)\)], "Message",
  CellTags->"XML`SVG`SymbolicSVGToGraphics::unsup"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`SVG`SymbolicSVGToGraphics::unsup"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML`Parser`ReleaseXMLParser::bparsr", "ObjectNameWarningMessages",
  CellTags->"XML`Parser`ReleaseXMLParser::bparsr"],

Cell[BoxData[
    \(XML`Parser`ReleaseXMLParser::"bparsr" \(\(:\)\(\ \)\) \(XMLParser\ \
object\ expected\ at\ position\ 1\ in\ `1`\)\)], "Message",
  CellTags->"XML`Parser`ReleaseXMLParser::bparsr"],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->"XML`Parser`ReleaseXMLParser::bparsr"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
XML`MathML`BoxesToSymbolicMathML::notboxes
XML`MathML`BoxesToMathML::notboxes\
\>", "ObjectNameWarningMessages",
  CellTags->{
  "XML`MathML`BoxesToSymbolicMathML::notboxes", 
    "XML`MathML`BoxesToMathML::notboxes"}],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["function",
          "TI"], 
        "::", "\<\"notboxes\"\>"}], \(\(:\)\(\ \)\), \(`1`\ is\ not\ a\ valid\
\ box\ structure . \ 
          The\ first\ argument\ in\ `2`\ must\ be\ a\ valid\ box\ \
\(\(structure\)\(.\)\)\)}]], "Message",
  CellTags->{
  "XML`MathML`BoxesToSymbolicMathML::notboxes", 
    "XML`MathML`BoxesToMathML::notboxes"}],

Cell["\<\
\[FilledSmallSquare] Notes for this message have not yet been \
added.\
\>", "Notes",
  CellTags->{
  "XML`MathML`BoxesToSymbolicMathML::notboxes", 
    "XML`MathML`BoxesToMathML::notboxes"}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 973}, {0, 746}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{641, 517},
WindowMargins->{{Automatic, 87}, {78, Automatic}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Export::xmloptv"->{
    Cell[1821, 57, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::xmloptv"],
    Cell[1907, 60, 220, 4, 37, "Message",
      CellTags->"Export::xmloptv"],
    Cell[2130, 66, 126, 4, 24, "Notes",
      CellTags->"Export::xmloptv"]},
  "Export::xmloptx"->{
    Cell[2293, 75, 83, 1, 31, "ObjectNameWarningMessages",
      CellTags->"Export::xmloptx"],
    Cell[2379, 78, 419, 11, 37, "Message",
      CellTags->"Export::xmloptx"],
    Cell[2801, 91, 126, 4, 24, "Notes",
      CellTags->"Export::xmloptx"]},
  "XMLElement::attlhs"->{
    Cell[2964, 100, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLElement::attlhs"],
    Cell[3056, 103, 346, 5, 53, "Message",
      CellTags->"XMLElement::attlhs"],
    Cell[3405, 110, 129, 4, 24, "Notes",
      CellTags->"XMLElement::attlhs"]},
  "XMLElement::attrhs"->{
    Cell[3571, 119, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLElement::attrhs"],
    Cell[3663, 122, 263, 4, 37, "Message",
      CellTags->"XMLElement::attrhs"],
    Cell[3929, 128, 129, 4, 24, "Notes",
      CellTags->"XMLElement::attrhs"]},
  "XMLElement::attrslst"->{
    Cell[4095, 137, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLElement::attrslst"],
    Cell[4191, 140, 300, 5, 37, "Message",
      CellTags->"XMLElement::attrslst"],
    Cell[4494, 147, 131, 4, 24, "Notes",
      CellTags->"XMLElement::attrslst"]},
  "XMLElement::attrule"->{
    Cell[4662, 156, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLElement::attrule"],
    Cell[4756, 159, 293, 6, 53, "Message",
      CellTags->"XMLElement::attrule"],
    Cell[5052, 167, 130, 4, 24, "Notes",
      CellTags->"XMLElement::attrule"]},
  "XMLElement::cnts"->{
    Cell[5219, 176, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLElement::cnts"],
    Cell[5307, 179, 276, 5, 37, "Message",
      CellTags->"XMLElement::cnts"],
    Cell[5586, 186, 127, 4, 24, "Notes",
      CellTags->"XMLElement::cnts"]},
  "XMLElement::cntsList"->{
    Cell[5750, 195, 93, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLElement::cntsList"],
    Cell[5846, 198, 290, 5, 37, "Message",
      CellTags->"XMLElement::cntsList"],
    Cell[6139, 205, 131, 4, 24, "Notes",
      CellTags->"XMLElement::cntsList"]},
  "XMLElement::name"->{
    Cell[6307, 214, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLElement::name"],
    Cell[6395, 217, 338, 5, 53, "Message",
      CellTags->"XMLElement::name"],
    Cell[6736, 224, 127, 4, 24, "Notes",
      CellTags->"XMLElement::name"]},
  "XMLElement::unqatt"->{
    Cell[6900, 233, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLElement::unqatt"],
    Cell[6992, 236, 362, 5, 53, "Message",
      CellTags->"XMLElement::unqatt"],
    Cell[7357, 243, 129, 4, 24, "Notes",
      CellTags->"XMLElement::unqatt"]},
  "XMLObject::decunsv"->{
    Cell[7523, 252, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLObject::decunsv"],
    Cell[7615, 255, 287, 6, 53, "Message",
      CellTags->"XMLObject::decunsv"],
    Cell[7905, 263, 129, 4, 24, "Notes",
      CellTags->"XMLObject::decunsv"]},
  "XMLObject::decvfst"->{
    Cell[8071, 272, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLObject::decvfst"],
    Cell[8163, 275, 273, 6, 53, "Message",
      CellTags->"XMLObject::decvfst"],
    Cell[8439, 283, 129, 4, 24, "Notes",
      CellTags->"XMLObject::decvfst"]},
  "XMLObject::decvreq"->{
    Cell[8605, 292, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLObject::decvreq"],
    Cell[8697, 295, 269, 5, 53, "Message",
      CellTags->"XMLObject::decvreq"],
    Cell[8969, 302, 129, 4, 24, "Notes",
      CellTags->"XMLObject::decvreq"]},
  "XMLObject::declfst"->{
    Cell[9135, 311, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLObject::declfst"],
    Cell[9227, 314, 319, 6, 69, "Message",
      CellTags->"XMLObject::declfst"],
    Cell[9549, 322, 129, 4, 24, "Notes",
      CellTags->"XMLObject::declfst"]},
  "XMLObject::docbarg"->{
    Cell[9715, 331, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLObject::docbarg"],
    Cell[9807, 334, 183, 3, 21, "Message",
      CellTags->"XMLObject::docbarg"],
    Cell[9993, 339, 129, 4, 24, "Notes",
      CellTags->"XMLObject::docbarg"]},
  "XMLObject::docep"->{
    Cell[10159, 348, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLObject::docep"],
    Cell[10247, 351, 310, 6, 69, "Message",
      CellTags->"XMLObject::docep"],
    Cell[10560, 359, 127, 4, 24, "Notes",
      CellTags->"XMLObject::docep"]},
  "XMLObject::docprlgi"->{
    Cell[10724, 368, 91, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLObject::docprlgi"],
    Cell[10818, 371, 372, 7, 85, "Message",
      CellTags->"XMLObject::docprlgi"],
    Cell[11193, 380, 130, 4, 24, "Notes",
      CellTags->"XMLObject::docprlgi"]},
  "XMLObject::dtrtstr"->{
    Cell[11360, 389, 89, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLObject::dtrtstr"],
    Cell[11452, 392, 277, 6, 53, "Message",
      CellTags->"XMLObject::dtrtstr"],
    Cell[11732, 400, 129, 4, 24, "Notes",
      CellTags->"XMLObject::dtrtstr"]},
  "XMLObject::slone"->{
    Cell[11898, 409, 85, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLObject::slone"],
    Cell[11986, 412, 312, 6, 69, "Message",
      CellTags->"XMLObject::slone"],
    Cell[12301, 420, 127, 4, 24, "Notes",
      CellTags->"XMLObject::slone"]},
  "XMLObject::unq"->{
    Cell[12465, 429, 81, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLObject::unq"],
    Cell[12549, 432, 215, 4, 37, "Message",
      CellTags->"XMLObject::unq"],
    Cell[12767, 438, 125, 4, 24, "Notes",
      CellTags->"XMLObject::unq"]},
  "XMLObject::unsenc"->{
    Cell[12929, 447, 87, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XMLObject::unsenc"],
    Cell[13019, 450, 258, 4, 53, "Message",
      CellTags->"XMLObject::unsenc"],
    Cell[13280, 456, 128, 4, 24, "Notes",
      CellTags->"XMLObject::unsenc"]},
  "XML`SymbolicXMLErrors::unknobj"->{
    Cell[13445, 465, 113, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`SymbolicXMLErrors::unknobj"],
    Cell[13561, 468, 277, 4, 37, "Message",
      CellTags->"XML`SymbolicXMLErrors::unknobj"],
    Cell[13841, 474, 141, 4, 24, "Notes",
      CellTags->"XML`SymbolicXMLErrors::unknobj"]},
  "XML`MathML`BoxesToSymbolicMathML::badba"->{
    Cell[14019, 483, 131, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::badba"],
    Cell[14153, 486, 341, 6, 53, "Message",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::badba"],
    Cell[14497, 494, 150, 4, 24, "Notes",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::badba"]},
  "XML`MathML`BoxesToSymbolicMathML::incasmml"->{
    Cell[14684, 503, 137, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::incasmml"],
    Cell[14824, 506, 417, 7, 69, "Message",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::incasmml"],
    Cell[15244, 515, 153, 4, 24, "Notes",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::incasmml"]},
  "XML`MathML`BoxesToSymbolicMathML::uncnvbxs"->{
    Cell[15434, 524, 137, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::uncnvbxs"],
    Cell[15574, 527, 230, 4, 37, "Message",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::uncnvbxs"],
    Cell[15807, 533, 153, 4, 24, "Notes",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::uncnvbxs"]},
  "XML`MathML`BoxesToSymbolicMathML::unrecf"->{
    Cell[15997, 542, 133, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::unrecf"],
    Cell[16133, 545, 236, 4, 37, "Message",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::unrecf"],
    Cell[16372, 551, 151, 4, 24, "Notes",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::unrecf"]},
  "XML`MathML`BoxesToSymbolicMathML::attrule"->{
    Cell[16560, 560, 135, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::attrule"],
    Cell[16698, 563, 368, 6, 69, "Message",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::attrule"],
    Cell[17069, 571, 152, 4, 24, "Notes",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::attrule"]},
  "XML`MathML`BoxesToSymbolicMathML::attlhs"->{
    Cell[17258, 580, 133, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::attlhs"],
    Cell[17394, 583, 442, 7, 69, "Message",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::attlhs"],
    Cell[17839, 592, 151, 4, 24, "Notes",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::attlhs"]},
  "XML`MathML`BoxesToSymbolicMathML::attrhs"->{
    Cell[18027, 601, 133, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::attrhs"],
    Cell[18163, 604, 340, 6, 53, "Message",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::attrhs"],
    Cell[18506, 612, 151, 4, 24, "Notes",
      CellTags->"XML`MathML`BoxesToSymbolicMathML::attrhs"]},
  "XML`MathML`SymbolicMathMLToBoxes::bmml"->{
    Cell[18694, 621, 129, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::bmml"],
    Cell[18826, 624, 300, 5, 37, "Message",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::bmml"],
    Cell[19129, 631, 149, 4, 24, "Notes",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::bmml"]},
  "XML`MathML`SymbolicMathMLToBoxes::incrt"->{
    Cell[19315, 640, 131, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::incrt"],
    Cell[19449, 643, 298, 5, 53, "Message",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::incrt"],
    Cell[19750, 650, 150, 4, 24, "Notes",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::incrt"]},
  "XML`MathML`SymbolicMathMLToBoxes::invsmml"->{
    Cell[19937, 659, 135, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::invsmml"],
    Cell[20075, 662, 292, 5, 53, "Message",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::invsmml"],
    Cell[20370, 669, 152, 4, 24, "Notes",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::invsmml"]},
  "XML`MathML`SymbolicMathMLToBoxes::malsmml"->{
    Cell[20559, 678, 135, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::malsmml"],
    Cell[20697, 681, 282, 5, 53, "Message",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::malsmml"],
    Cell[20982, 688, 152, 4, 24, "Notes",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::malsmml"]},
  "XML`MathML`SymbolicMathMLToBoxes::nmmlr"->{
    Cell[21171, 697, 131, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::nmmlr"],
    Cell[21305, 700, 315, 5, 53, "Message",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::nmmlr"],
    Cell[21623, 707, 150, 4, 24, "Notes",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::nmmlr"]},
  "XML`MathML`SymbolicMathMLToBoxes::unknstrc"->{
    Cell[21810, 716, 137, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::unknstrc"],
    Cell[21950, 719, 214, 3, 37, "Message",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::unknstrc"],
    Cell[22167, 724, 153, 4, 24, "Notes",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::unknstrc"]},
  "XML`MathML`SymbolicMathMLToBoxes::unkntag"->{
    Cell[22357, 733, 135, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::unkntag"],
    Cell[22495, 736, 272, 5, 37, "Message",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::unkntag"],
    Cell[22770, 743, 152, 4, 24, "Notes",
      CellTags->"XML`MathML`SymbolicMathMLToBoxes::unkntag"]},
  "XML`MathML`SymbolicMathMLToExpression::invsmml"->{
    Cell[22959, 752, 147, 2, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`SymbolicMathMLToExpression::invsmml"],
    Cell[23109, 756, 310, 5, 53, "Message",
      CellTags->"XML`MathML`SymbolicMathMLToExpression::invsmml"],
    Cell[23422, 763, 157, 4, 24, "Notes",
      CellTags->"XML`MathML`SymbolicMathMLToExpression::invsmml"]},
  "XML`MathML`SymbolicMathMLToExpression::malsmml"->{
    Cell[23616, 772, 147, 2, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`SymbolicMathMLToExpression::malsmml"],
    Cell[23766, 776, 300, 5, 53, "Message",
      CellTags->"XML`MathML`SymbolicMathMLToExpression::malsmml"],
    Cell[24069, 783, 157, 4, 24, "Notes",
      CellTags->"XML`MathML`SymbolicMathMLToExpression::malsmml"]},
  "XML`MathML`SymbolicMathMLToExpression::nmmlr"->{
    Cell[24263, 792, 143, 2, 31, "ObjectNameWarningMessages",
      CellTags->"XML`MathML`SymbolicMathMLToExpression::nmmlr"],
    Cell[24409, 796, 335, 6, 53, "Message",
      CellTags->"XML`MathML`SymbolicMathMLToExpression::nmmlr"],
    Cell[24747, 804, 155, 4, 24, "Notes",
      CellTags->"XML`MathML`SymbolicMathMLToExpression::nmmlr"]},
  "XML`NotebookML`NotebookToSymbolicNotebookML::badobj"->{
    Cell[24939, 813, 157, 2, 31, "ObjectNameWarningMessages",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::badobj"],
    Cell[25099, 817, 308, 4, 53, "Message",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::badobj"],
    Cell[25410, 823, 162, 4, 24, "Notes",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::badobj"]},
  "XML`NotebookML`NotebookToSymbolicNotebookML::filonb"->{
    Cell[25609, 832, 157, 2, 31, "ObjectNameWarningMessages",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::filonb"],
    Cell[25769, 836, 290, 5, 37, "Message",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::filonb"],
    Cell[26062, 843, 162, 4, 24, "Notes",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::filonb"]},
  "XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv"->{
    Cell[26261, 852, 159, 2, 51, "ObjectNameWarningMessages",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv"],
    Cell[26423, 856, 331, 5, 53, "Message",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv"],
    Cell[26757, 863, 163, 4, 24, "Notes",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv"]},
  "XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd"->{
    Cell[26957, 872, 159, 2, 51, "ObjectNameWarningMessages",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd"],
    Cell[27119, 876, 263, 4, 37, "Message",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd"],
    Cell[27385, 882, 163, 4, 24, "Notes",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd"]},
  "XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd"->{
    Cell[27585, 891, 159, 2, 51, "ObjectNameWarningMessages",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd"],
    Cell[27747, 895, 277, 4, 37, "Message",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd"],
    Cell[28027, 901, 163, 4, 24, "Notes",
      CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd"]},
  "XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns"->{
    Cell[28227, 910, 165, 2, 51, "ObjectNameWarningMessages",
      CellTags->"XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns"],
    Cell[28395, 914, 394, 6, 53, "Message",
      CellTags->"XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns"],
    Cell[28792, 922, 166, 4, 24, "Notes",
      CellTags->"XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns"]},
  "XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes"->{
    Cell[28995, 931, 159, 2, 51, "ObjectNameWarningMessages",
      CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes"],
    Cell[29157, 935, 318, 5, 53, "Message",
      CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes"],
    Cell[29478, 942, 163, 4, 24, "Notes",
      CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes"]},
  "XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx"->{
    Cell[29678, 951, 159, 2, 51, "ObjectNameWarningMessages",
      CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx"],
    Cell[29840, 955, 323, 5, 53, "Message",
      CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx"],
    Cell[30166, 962, 163, 4, 24, "Notes",
      CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx"]},
  "XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns"->{
    Cell[30366, 971, 157, 2, 31, "ObjectNameWarningMessages",
      CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns"],
    Cell[30526, 975, 386, 6, 53, "Message",
      CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns"],
    Cell[30915, 983, 162, 4, 24, "Notes",
      CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns"]},
  "XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml"->{
    Cell[31114, 992, 159, 2, 51, "ObjectNameWarningMessages",
      CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml"],
    Cell[31276, 996, 241, 4, 37, "Message",
      CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml"],
    Cell[31520, 1002, 163, 4, 24, "Notes",
      CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml"]},
  "XML`Parser`InitializeXMLParser::memfail"->{
    Cell[31720, 1011, 131, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`InitializeXMLParser::memfail"],
    Cell[31854, 1014, 223, 3, 37, "Message",
      CellTags->"XML`Parser`InitializeXMLParser::memfail"],
    Cell[32080, 1019, 150, 4, 24, "Notes",
      CellTags->"XML`Parser`InitializeXMLParser::memfail"]},
  "XML`Parser`InitializeXMLParser::nfprserr"->{
    Cell[32267, 1028, 133, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`InitializeXMLParser::nfprserr"],
    Cell[32403, 1031, 155, 3, 21, "Message",
      CellTags->"XML`Parser`InitializeXMLParser::nfprserr"],
    Cell[32561, 1036, 151, 4, 24, "Notes",
      CellTags->"XML`Parser`InitializeXMLParser::nfprserr"]},
  "XML`Parser`InitializeXMLParser::prserr"->{
    Cell[32749, 1045, 129, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`InitializeXMLParser::prserr"],
    Cell[32881, 1048, 151, 3, 21, "Message",
      CellTags->"XML`Parser`InitializeXMLParser::prserr"],
    Cell[33035, 1053, 149, 4, 24, "Notes",
      CellTags->"XML`Parser`InitializeXMLParser::prserr"]},
  "XML`Parser`ReleaseXMLParser::ilgprsr"->{
    Cell[33221, 1062, 125, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`ReleaseXMLParser::ilgprsr"],
    Cell[33349, 1065, 163, 3, 21, "Message",
      CellTags->"XML`Parser`ReleaseXMLParser::ilgprsr"],
    Cell[33515, 1070, 147, 4, 24, "Notes",
      CellTags->"XML`Parser`ReleaseXMLParser::ilgprsr"]},
  "XML`Parser`XMLGet::badop"->{
    Cell[33699, 1079, 101, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`XMLGet::badop"],
    Cell[33803, 1082, 214, 4, 37, "Message",
      CellTags->"XML`Parser`XMLGet::badop"],
    Cell[34020, 1088, 135, 4, 24, "Notes",
      CellTags->"XML`Parser`XMLGet::badop"]},
  "XML`Parser`XMLGet::ilgprsr"->{
    Cell[34192, 1097, 105, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`XMLGet::ilgprsr"],
    Cell[34300, 1100, 143, 3, 21, "Message",
      CellTags->"XML`Parser`XMLGet::ilgprsr"],
    Cell[34446, 1105, 137, 4, 24, "Notes",
      CellTags->"XML`Parser`XMLGet::ilgprsr"]},
  "XML`Parser`XMLGet::memfail"->{
    Cell[34620, 1114, 105, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`XMLGet::memfail"],
    Cell[34728, 1117, 196, 3, 21, "Message",
      CellTags->"XML`Parser`XMLGet::memfail"],
    Cell[34927, 1122, 137, 4, 24, "Notes",
      CellTags->"XML`Parser`XMLGet::memfail"]},
  "XML`Parser`XMLGet::nfprserr"->{
    Cell[35101, 1131, 107, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`XMLGet::nfprserr"],
    Cell[35211, 1134, 127, 2, 21, "Message",
      CellTags->"XML`Parser`XMLGet::nfprserr"],
    Cell[35341, 1138, 138, 4, 24, "Notes",
      CellTags->"XML`Parser`XMLGet::nfprserr"]},
  "XML`Parser`XMLGet::prserr"->{
    Cell[35516, 1147, 103, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`XMLGet::prserr"],
    Cell[35622, 1150, 123, 2, 21, "Message",
      CellTags->"XML`Parser`XMLGet::prserr"],
    Cell[35748, 1154, 136, 4, 24, "Notes",
      CellTags->"XML`Parser`XMLGet::prserr"]},
  "XML`Parser`XMLGet::put"->{
    Cell[35921, 1163, 97, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`XMLGet::put"],
    Cell[36021, 1166, 210, 4, 37, "Message",
      CellTags->"XML`Parser`XMLGet::put"],
    Cell[36234, 1172, 133, 4, 24, "Notes",
      CellTags->"XML`Parser`XMLGet::put"]},
  "XML`Parser`XMLGet::unknop"->{
    Cell[36404, 1181, 103, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`XMLGet::unknop"],
    Cell[36510, 1184, 174, 3, 21, "Message",
      CellTags->"XML`Parser`XMLGet::unknop"],
    Cell[36687, 1189, 136, 4, 24, "Notes",
      CellTags->"XML`Parser`XMLGet::unknop"]},
  "XML`Parser`XMLGet::xmlprsop"->{
    Cell[36860, 1198, 107, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`XMLGet::xmlprsop"],
    Cell[36970, 1201, 210, 3, 37, "Message",
      CellTags->"XML`Parser`XMLGet::xmlprsop"],
    Cell[37183, 1206, 138, 4, 24, "Notes",
      CellTags->"XML`Parser`XMLGet::xmlprsop"]},
  "XML`Parser`XMLGetString::ilgprsr"->{
    Cell[37358, 1215, 117, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`XMLGetString::ilgprsr"],
    Cell[37478, 1218, 155, 3, 21, "Message",
      CellTags->"XML`Parser`XMLGetString::ilgprsr"],
    Cell[37636, 1223, 143, 4, 24, "Notes",
      CellTags->"XML`Parser`XMLGetString::ilgprsr"]},
  "XML`Parser`XMLGetString::memfail"->{
    Cell[37816, 1232, 117, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`XMLGetString::memfail"],
    Cell[37936, 1235, 214, 3, 37, "Message",
      CellTags->"XML`Parser`XMLGetString::memfail"],
    Cell[38153, 1240, 143, 4, 24, "Notes",
      CellTags->"XML`Parser`XMLGetString::memfail"]},
  "XML`Parser`XMLGetString::nfprserr"->{
    Cell[38333, 1249, 119, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`XMLGetString::nfprserr"],
    Cell[38455, 1252, 139, 2, 21, "Message",
      CellTags->"XML`Parser`XMLGetString::nfprserr"],
    Cell[38597, 1256, 144, 4, 24, "Notes",
      CellTags->"XML`Parser`XMLGetString::nfprserr"]},
  "XML`Parser`XMLGetString::prserr"->{
    Cell[38778, 1265, 115, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`XMLGetString::prserr"],
    Cell[38896, 1268, 135, 2, 21, "Message",
      CellTags->"XML`Parser`XMLGetString::prserr"],
    Cell[39034, 1272, 142, 4, 24, "Notes",
      CellTags->"XML`Parser`XMLGetString::prserr"]},
  "XML`Parser`XMLGetString::xmlprsop"->{
    Cell[39213, 1281, 119, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`XMLGetString::xmlprsop"],
    Cell[39335, 1284, 224, 4, 37, "Message",
      CellTags->"XML`Parser`XMLGetString::xmlprsop"],
    Cell[39562, 1290, 144, 4, 24, "Notes",
      CellTags->"XML`Parser`XMLGetString::xmlprsop"]},
  "XML`SVG`GraphicsToSymbolicSVG::bdmgr"->{
    Cell[39743, 1299, 125, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::bdmgr"],
    Cell[39871, 1302, 324, 5, 53, "Message",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::bdmgr"],
    Cell[40198, 1309, 147, 4, 24, "Notes",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::bdmgr"]},
  "XML`SVG`GraphicsToSymbolicSVG::bsvgf"->{
    Cell[40382, 1318, 125, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgf"],
    Cell[40510, 1321, 176, 3, 21, "Message",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgf"],
    Cell[40689, 1326, 147, 4, 24, "Notes",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgf"]},
  "XML`SVG`GraphicsToSymbolicSVG::bsvgns"->{
    Cell[40873, 1335, 127, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgns"],
    Cell[41003, 1338, 191, 3, 21, "Message",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgns"],
    Cell[41197, 1343, 148, 4, 24, "Notes",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgns"]},
  "XML`SVG`GraphicsToSymbolicSVG::gtype"->{
    Cell[41382, 1352, 125, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::gtype"],
    Cell[41510, 1355, 196, 3, 21, "Message",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::gtype"],
    Cell[41709, 1360, 147, 4, 24, "Notes",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::gtype"]},
  "XML`SVG`GraphicsToSymbolicSVG::ncvrt"->{
    Cell[41893, 1369, 125, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::ncvrt"],
    Cell[42021, 1372, 223, 4, 37, "Message",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::ncvrt"],
    Cell[42247, 1378, 147, 4, 24, "Notes",
      CellTags->"XML`SVG`GraphicsToSymbolicSVG::ncvrt"]},
  "XML`SVG`SymbolicSVGToGraphics::unsup"->{
    Cell[42431, 1387, 125, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`SVG`SymbolicSVGToGraphics::unsup"],
    Cell[42559, 1390, 203, 3, 21, "Message",
      CellTags->"XML`SVG`SymbolicSVGToGraphics::unsup"],
    Cell[42765, 1395, 147, 4, 24, "Notes",
      CellTags->"XML`SVG`SymbolicSVGToGraphics::unsup"]},
  "XML`Parser`ReleaseXMLParser::bparsr"->{
    Cell[42949, 1404, 123, 1, 31, "ObjectNameWarningMessages",
      CellTags->"XML`Parser`ReleaseXMLParser::bparsr"],
    Cell[43075, 1407, 199, 3, 37, "Message",
      CellTags->"XML`Parser`ReleaseXMLParser::bparsr"],
    Cell[43277, 1412, 146, 4, 24, "Notes",
      CellTags->"XML`Parser`ReleaseXMLParser::bparsr"]},
  "XML`MathML`BoxesToSymbolicMathML::notboxes"->{
    Cell[43460, 1421, 228, 6, 51, "ObjectNameWarningMessages",
      CellTags->{
      "XML`MathML`BoxesToSymbolicMathML::notboxes", 
        "XML`MathML`BoxesToMathML::notboxes"}],
    Cell[43691, 1429, 403, 11, 37, "Message",
      CellTags->{
      "XML`MathML`BoxesToSymbolicMathML::notboxes", 
        "XML`MathML`BoxesToMathML::notboxes"}],
    Cell[44097, 1442, 201, 6, 24, "Notes",
      CellTags->{
      "XML`MathML`BoxesToSymbolicMathML::notboxes", 
        "XML`MathML`BoxesToMathML::notboxes"}]},
  "XML`MathML`BoxesToMathML::notboxes"->{
    Cell[43460, 1421, 228, 6, 51, "ObjectNameWarningMessages",
      CellTags->{
      "XML`MathML`BoxesToSymbolicMathML::notboxes", 
        "XML`MathML`BoxesToMathML::notboxes"}],
    Cell[43691, 1429, 403, 11, 37, "Message",
      CellTags->{
      "XML`MathML`BoxesToSymbolicMathML::notboxes", 
        "XML`MathML`BoxesToMathML::notboxes"}],
    Cell[44097, 1442, 201, 6, 24, "Notes",
      CellTags->{
      "XML`MathML`BoxesToSymbolicMathML::notboxes", 
        "XML`MathML`BoxesToMathML::notboxes"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Export::xmloptv", 44992, 1469},
  {"Export::xmloptx", 45265, 1476},
  {"XMLElement::attlhs", 45542, 1483},
  {"XMLElement::attrhs", 45830, 1490},
  {"XMLElement::attrslst", 46120, 1497},
  {"XMLElement::attrule", 46415, 1504},
  {"XMLElement::cnts", 46704, 1511},
  {"XMLElement::cntsList", 46988, 1518},
  {"XMLElement::name", 47280, 1525},
  {"XMLElement::unqatt", 47562, 1532},
  {"XMLObject::decunsv", 47850, 1539},
  {"XMLObject::decvfst", 48138, 1546},
  {"XMLObject::decvreq", 48426, 1553},
  {"XMLObject::declfst", 48714, 1560},
  {"XMLObject::docbarg", 49002, 1567},
  {"XMLObject::docep", 49288, 1574},
  {"XMLObject::docprlgi", 49574, 1581},
  {"XMLObject::dtrtstr", 49868, 1588},
  {"XMLObject::slone", 50157, 1595},
  {"XMLObject::unq", 50438, 1602},
  {"XMLObject::unsenc", 50716, 1609},
  {"XML`SymbolicXMLErrors::unknobj", 51016, 1616},
  {"XML`MathML`BoxesToSymbolicMathML::badba", 51365, 1623},
  {"XML`MathML`BoxesToSymbolicMathML::incasmml", 51744, 1630},
  {"XML`MathML`BoxesToSymbolicMathML::uncnvbxs", 52132, 1637},
  {"XML`MathML`BoxesToSymbolicMathML::unrecf", 52518, 1644},
  {"XML`MathML`BoxesToSymbolicMathML::attrule", 52899, 1651},
  {"XML`MathML`BoxesToSymbolicMathML::attlhs", 53282, 1658},
  {"XML`MathML`BoxesToSymbolicMathML::attrhs", 53662, 1665},
  {"XML`MathML`SymbolicMathMLToBoxes::bmml", 54040, 1672},
  {"XML`MathML`SymbolicMathMLToBoxes::incrt", 54413, 1679},
  {"XML`MathML`SymbolicMathMLToBoxes::invsmml", 54791, 1686},
  {"XML`MathML`SymbolicMathMLToBoxes::malsmml", 55175, 1693},
  {"XML`MathML`SymbolicMathMLToBoxes::nmmlr", 55557, 1700},
  {"XML`MathML`SymbolicMathMLToBoxes::unknstrc", 55936, 1707},
  {"XML`MathML`SymbolicMathMLToBoxes::unkntag", 56323, 1714},
  {"XML`MathML`SymbolicMathMLToExpression::invsmml", 56712, 1721},
  {"XML`MathML`SymbolicMathMLToExpression::malsmml", 57116, 1728},
  {"XML`MathML`SymbolicMathMLToExpression::nmmlr", 57518, 1735},
  {"XML`NotebookML`NotebookToSymbolicNotebookML::badobj", 57921, 1742},
  {"XML`NotebookML`NotebookToSymbolicNotebookML::filonb", 58345, 1749},
  {"XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv", 58770, 1756},
  {"XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd", 59198, 1763},
  {"XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd", 59626, 1770},
  {"XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns", 60057, 1777},
  {"XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes", 60494, 1784},
  {"XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx", 60922, 1791},
  {"XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns", 61349, 1798},
  {"XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml", 61774, 1805},
  {"XML`Parser`InitializeXMLParser::memfail", 62190, 1812},
  {"XML`Parser`InitializeXMLParser::nfprserr", 62570, 1819},
  {"XML`Parser`InitializeXMLParser::prserr", 62951, 1826},
  {"XML`Parser`ReleaseXMLParser::ilgprsr", 63324, 1833},
  {"XML`Parser`XMLGet::badop", 63679, 1840},
  {"XML`Parser`XMLGet::ilgprsr", 64000, 1847},
  {"XML`Parser`XMLGet::memfail", 64327, 1854},
  {"XML`Parser`XMLGet::nfprserr", 64655, 1861},
  {"XML`Parser`XMLGet::prserr", 64984, 1868},
  {"XML`Parser`XMLGet::put", 65304, 1875},
  {"XML`Parser`XMLGet::unknop", 65617, 1882},
  {"XML`Parser`XMLGet::xmlprsop", 65942, 1889},
  {"XML`Parser`XMLGetString::ilgprsr", 66278, 1896},
  {"XML`Parser`XMLGetString::memfail", 66629, 1903},
  {"XML`Parser`XMLGetString::nfprserr", 66981, 1910},
  {"XML`Parser`XMLGetString::prserr", 67334, 1917},
  {"XML`Parser`XMLGetString::xmlprsop", 67683, 1924},
  {"XML`SVG`GraphicsToSymbolicSVG::bdmgr", 68041, 1931},
  {"XML`SVG`GraphicsToSymbolicSVG::bsvgf", 68408, 1938},
  {"XML`SVG`GraphicsToSymbolicSVG::bsvgns", 68776, 1945},
  {"XML`SVG`GraphicsToSymbolicSVG::gtype", 69146, 1952},
  {"XML`SVG`GraphicsToSymbolicSVG::ncvrt", 69513, 1959},
  {"XML`SVG`SymbolicSVGToGraphics::unsup", 69880, 1966},
  {"XML`Parser`ReleaseXMLParser::bparsr", 70246, 1973},
  {"XML`MathML`BoxesToSymbolicMathML::notboxes", 70616, 1980},
  {"XML`MathML`BoxesToMathML::notboxes", 71168, 1993}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 20, 0, 98, "Title"],

Cell[CellGroupData[{
Cell[1821, 57, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::xmloptv"],
Cell[1907, 60, 220, 4, 37, "Message",
  CellTags->"Export::xmloptv"],
Cell[2130, 66, 126, 4, 24, "Notes",
  CellTags->"Export::xmloptv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2293, 75, 83, 1, 31, "ObjectNameWarningMessages",
  CellTags->"Export::xmloptx"],
Cell[2379, 78, 419, 11, 37, "Message",
  CellTags->"Export::xmloptx"],
Cell[2801, 91, 126, 4, 24, "Notes",
  CellTags->"Export::xmloptx"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2964, 100, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLElement::attlhs"],
Cell[3056, 103, 346, 5, 53, "Message",
  CellTags->"XMLElement::attlhs"],
Cell[3405, 110, 129, 4, 24, "Notes",
  CellTags->"XMLElement::attlhs"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3571, 119, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLElement::attrhs"],
Cell[3663, 122, 263, 4, 37, "Message",
  CellTags->"XMLElement::attrhs"],
Cell[3929, 128, 129, 4, 24, "Notes",
  CellTags->"XMLElement::attrhs"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4095, 137, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLElement::attrslst"],
Cell[4191, 140, 300, 5, 37, "Message",
  CellTags->"XMLElement::attrslst"],
Cell[4494, 147, 131, 4, 24, "Notes",
  CellTags->"XMLElement::attrslst"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4662, 156, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLElement::attrule"],
Cell[4756, 159, 293, 6, 53, "Message",
  CellTags->"XMLElement::attrule"],
Cell[5052, 167, 130, 4, 24, "Notes",
  CellTags->"XMLElement::attrule"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5219, 176, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLElement::cnts"],
Cell[5307, 179, 276, 5, 37, "Message",
  CellTags->"XMLElement::cnts"],
Cell[5586, 186, 127, 4, 24, "Notes",
  CellTags->"XMLElement::cnts"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5750, 195, 93, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLElement::cntsList"],
Cell[5846, 198, 290, 5, 37, "Message",
  CellTags->"XMLElement::cntsList"],
Cell[6139, 205, 131, 4, 24, "Notes",
  CellTags->"XMLElement::cntsList"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6307, 214, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLElement::name"],
Cell[6395, 217, 338, 5, 53, "Message",
  CellTags->"XMLElement::name"],
Cell[6736, 224, 127, 4, 24, "Notes",
  CellTags->"XMLElement::name"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6900, 233, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLElement::unqatt"],
Cell[6992, 236, 362, 5, 53, "Message",
  CellTags->"XMLElement::unqatt"],
Cell[7357, 243, 129, 4, 24, "Notes",
  CellTags->"XMLElement::unqatt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7523, 252, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLObject::decunsv"],
Cell[7615, 255, 287, 6, 53, "Message",
  CellTags->"XMLObject::decunsv"],
Cell[7905, 263, 129, 4, 24, "Notes",
  CellTags->"XMLObject::decunsv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8071, 272, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLObject::decvfst"],
Cell[8163, 275, 273, 6, 53, "Message",
  CellTags->"XMLObject::decvfst"],
Cell[8439, 283, 129, 4, 24, "Notes",
  CellTags->"XMLObject::decvfst"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8605, 292, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLObject::decvreq"],
Cell[8697, 295, 269, 5, 53, "Message",
  CellTags->"XMLObject::decvreq"],
Cell[8969, 302, 129, 4, 24, "Notes",
  CellTags->"XMLObject::decvreq"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9135, 311, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLObject::declfst"],
Cell[9227, 314, 319, 6, 69, "Message",
  CellTags->"XMLObject::declfst"],
Cell[9549, 322, 129, 4, 24, "Notes",
  CellTags->"XMLObject::declfst"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9715, 331, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLObject::docbarg"],
Cell[9807, 334, 183, 3, 21, "Message",
  CellTags->"XMLObject::docbarg"],
Cell[9993, 339, 129, 4, 24, "Notes",
  CellTags->"XMLObject::docbarg"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10159, 348, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLObject::docep"],
Cell[10247, 351, 310, 6, 69, "Message",
  CellTags->"XMLObject::docep"],
Cell[10560, 359, 127, 4, 24, "Notes",
  CellTags->"XMLObject::docep"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10724, 368, 91, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLObject::docprlgi"],
Cell[10818, 371, 372, 7, 85, "Message",
  CellTags->"XMLObject::docprlgi"],
Cell[11193, 380, 130, 4, 24, "Notes",
  CellTags->"XMLObject::docprlgi"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11360, 389, 89, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLObject::dtrtstr"],
Cell[11452, 392, 277, 6, 53, "Message",
  CellTags->"XMLObject::dtrtstr"],
Cell[11732, 400, 129, 4, 24, "Notes",
  CellTags->"XMLObject::dtrtstr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11898, 409, 85, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLObject::slone"],
Cell[11986, 412, 312, 6, 69, "Message",
  CellTags->"XMLObject::slone"],
Cell[12301, 420, 127, 4, 24, "Notes",
  CellTags->"XMLObject::slone"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12465, 429, 81, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLObject::unq"],
Cell[12549, 432, 215, 4, 37, "Message",
  CellTags->"XMLObject::unq"],
Cell[12767, 438, 125, 4, 24, "Notes",
  CellTags->"XMLObject::unq"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12929, 447, 87, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XMLObject::unsenc"],
Cell[13019, 450, 258, 4, 53, "Message",
  CellTags->"XMLObject::unsenc"],
Cell[13280, 456, 128, 4, 24, "Notes",
  CellTags->"XMLObject::unsenc"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13445, 465, 113, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`SymbolicXMLErrors::unknobj"],
Cell[13561, 468, 277, 4, 37, "Message",
  CellTags->"XML`SymbolicXMLErrors::unknobj"],
Cell[13841, 474, 141, 4, 24, "Notes",
  CellTags->"XML`SymbolicXMLErrors::unknobj"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14019, 483, 131, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::badba"],
Cell[14153, 486, 341, 6, 53, "Message",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::badba"],
Cell[14497, 494, 150, 4, 24, "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::badba"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14684, 503, 137, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::incasmml"],
Cell[14824, 506, 417, 7, 69, "Message",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::incasmml"],
Cell[15244, 515, 153, 4, 24, "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::incasmml"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15434, 524, 137, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::uncnvbxs"],
Cell[15574, 527, 230, 4, 37, "Message",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::uncnvbxs"],
Cell[15807, 533, 153, 4, 24, "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::uncnvbxs"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15997, 542, 133, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::unrecf"],
Cell[16133, 545, 236, 4, 37, "Message",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::unrecf"],
Cell[16372, 551, 151, 4, 24, "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::unrecf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16560, 560, 135, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attrule"],
Cell[16698, 563, 368, 6, 69, "Message",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attrule"],
Cell[17069, 571, 152, 4, 24, "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attrule"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17258, 580, 133, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attlhs"],
Cell[17394, 583, 442, 7, 69, "Message",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attlhs"],
Cell[17839, 592, 151, 4, 24, "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attlhs"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18027, 601, 133, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attrhs"],
Cell[18163, 604, 340, 6, 53, "Message",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attrhs"],
Cell[18506, 612, 151, 4, 24, "Notes",
  CellTags->"XML`MathML`BoxesToSymbolicMathML::attrhs"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18694, 621, 129, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::bmml"],
Cell[18826, 624, 300, 5, 37, "Message",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::bmml"],
Cell[19129, 631, 149, 4, 24, "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::bmml"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19315, 640, 131, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::incrt"],
Cell[19449, 643, 298, 5, 53, "Message",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::incrt"],
Cell[19750, 650, 150, 4, 24, "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::incrt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19937, 659, 135, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::invsmml"],
Cell[20075, 662, 292, 5, 53, "Message",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::invsmml"],
Cell[20370, 669, 152, 4, 24, "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::invsmml"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20559, 678, 135, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::malsmml"],
Cell[20697, 681, 282, 5, 53, "Message",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::malsmml"],
Cell[20982, 688, 152, 4, 24, "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::malsmml"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21171, 697, 131, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::nmmlr"],
Cell[21305, 700, 315, 5, 53, "Message",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::nmmlr"],
Cell[21623, 707, 150, 4, 24, "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::nmmlr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21810, 716, 137, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::unknstrc"],
Cell[21950, 719, 214, 3, 37, "Message",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::unknstrc"],
Cell[22167, 724, 153, 4, 24, "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::unknstrc"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22357, 733, 135, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::unkntag"],
Cell[22495, 736, 272, 5, 37, "Message",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::unkntag"],
Cell[22770, 743, 152, 4, 24, "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToBoxes::unkntag"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22959, 752, 147, 2, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::invsmml"],
Cell[23109, 756, 310, 5, 53, "Message",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::invsmml"],
Cell[23422, 763, 157, 4, 24, "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::invsmml"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23616, 772, 147, 2, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::malsmml"],
Cell[23766, 776, 300, 5, 53, "Message",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::malsmml"],
Cell[24069, 783, 157, 4, 24, "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::malsmml"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24263, 792, 143, 2, 31, "ObjectNameWarningMessages",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::nmmlr"],
Cell[24409, 796, 335, 6, 53, "Message",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::nmmlr"],
Cell[24747, 804, 155, 4, 24, "Notes",
  CellTags->"XML`MathML`SymbolicMathMLToExpression::nmmlr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24939, 813, 157, 2, 31, "ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::badobj"],
Cell[25099, 817, 308, 4, 53, "Message",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::badobj"],
Cell[25410, 823, 162, 4, 24, "Notes",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::badobj"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25609, 832, 157, 2, 31, "ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::filonb"],
Cell[25769, 836, 290, 5, 37, "Message",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::filonb"],
Cell[26062, 843, 162, 4, 24, "Notes",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::filonb"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26261, 852, 159, 2, 51, "ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv"],
Cell[26423, 856, 331, 5, 53, "Message",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv"],
Cell[26757, 863, 163, 4, 24, "Notes",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26957, 872, 159, 2, 51, "ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd"],
Cell[27119, 876, 263, 4, 37, "Message",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd"],
Cell[27385, 882, 163, 4, 24, "Notes",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27585, 891, 159, 2, 51, "ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd"],
Cell[27747, 895, 277, 4, 37, "Message",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd"],
Cell[28027, 901, 163, 4, 24, "Notes",
  CellTags->"XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28227, 910, 165, 2, 51, "ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns"],
Cell[28395, 914, 394, 6, 53, "Message",
  CellTags->"XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns"],
Cell[28792, 922, 166, 4, 24, "Notes",
  CellTags->"XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28995, 931, 159, 2, 51, "ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes"],
Cell[29157, 935, 318, 5, 53, "Message",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes"],
Cell[29478, 942, 163, 4, 24, "Notes",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29678, 951, 159, 2, 51, "ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx"],
Cell[29840, 955, 323, 5, 53, "Message",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx"],
Cell[30166, 962, 163, 4, 24, "Notes",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30366, 971, 157, 2, 31, "ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns"],
Cell[30526, 975, 386, 6, 53, "Message",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns"],
Cell[30915, 983, 162, 4, 24, "Notes",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31114, 992, 159, 2, 51, "ObjectNameWarningMessages",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml"],
Cell[31276, 996, 241, 4, 37, "Message",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml"],
Cell[31520, 1002, 163, 4, 24, "Notes",
  CellTags->"XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31720, 1011, 131, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`InitializeXMLParser::memfail"],
Cell[31854, 1014, 223, 3, 37, "Message",
  CellTags->"XML`Parser`InitializeXMLParser::memfail"],
Cell[32080, 1019, 150, 4, 24, "Notes",
  CellTags->"XML`Parser`InitializeXMLParser::memfail"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32267, 1028, 133, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`InitializeXMLParser::nfprserr"],
Cell[32403, 1031, 155, 3, 21, "Message",
  CellTags->"XML`Parser`InitializeXMLParser::nfprserr"],
Cell[32561, 1036, 151, 4, 24, "Notes",
  CellTags->"XML`Parser`InitializeXMLParser::nfprserr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32749, 1045, 129, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`InitializeXMLParser::prserr"],
Cell[32881, 1048, 151, 3, 21, "Message",
  CellTags->"XML`Parser`InitializeXMLParser::prserr"],
Cell[33035, 1053, 149, 4, 24, "Notes",
  CellTags->"XML`Parser`InitializeXMLParser::prserr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33221, 1062, 125, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`ReleaseXMLParser::ilgprsr"],
Cell[33349, 1065, 163, 3, 21, "Message",
  CellTags->"XML`Parser`ReleaseXMLParser::ilgprsr"],
Cell[33515, 1070, 147, 4, 24, "Notes",
  CellTags->"XML`Parser`ReleaseXMLParser::ilgprsr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33699, 1079, 101, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::badop"],
Cell[33803, 1082, 214, 4, 37, "Message",
  CellTags->"XML`Parser`XMLGet::badop"],
Cell[34020, 1088, 135, 4, 24, "Notes",
  CellTags->"XML`Parser`XMLGet::badop"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34192, 1097, 105, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::ilgprsr"],
Cell[34300, 1100, 143, 3, 21, "Message",
  CellTags->"XML`Parser`XMLGet::ilgprsr"],
Cell[34446, 1105, 137, 4, 24, "Notes",
  CellTags->"XML`Parser`XMLGet::ilgprsr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[34620, 1114, 105, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::memfail"],
Cell[34728, 1117, 196, 3, 21, "Message",
  CellTags->"XML`Parser`XMLGet::memfail"],
Cell[34927, 1122, 137, 4, 24, "Notes",
  CellTags->"XML`Parser`XMLGet::memfail"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35101, 1131, 107, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::nfprserr"],
Cell[35211, 1134, 127, 2, 21, "Message",
  CellTags->"XML`Parser`XMLGet::nfprserr"],
Cell[35341, 1138, 138, 4, 24, "Notes",
  CellTags->"XML`Parser`XMLGet::nfprserr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35516, 1147, 103, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::prserr"],
Cell[35622, 1150, 123, 2, 21, "Message",
  CellTags->"XML`Parser`XMLGet::prserr"],
Cell[35748, 1154, 136, 4, 24, "Notes",
  CellTags->"XML`Parser`XMLGet::prserr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[35921, 1163, 97, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::put"],
Cell[36021, 1166, 210, 4, 37, "Message",
  CellTags->"XML`Parser`XMLGet::put"],
Cell[36234, 1172, 133, 4, 24, "Notes",
  CellTags->"XML`Parser`XMLGet::put"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36404, 1181, 103, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::unknop"],
Cell[36510, 1184, 174, 3, 21, "Message",
  CellTags->"XML`Parser`XMLGet::unknop"],
Cell[36687, 1189, 136, 4, 24, "Notes",
  CellTags->"XML`Parser`XMLGet::unknop"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36860, 1198, 107, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGet::xmlprsop"],
Cell[36970, 1201, 210, 3, 37, "Message",
  CellTags->"XML`Parser`XMLGet::xmlprsop"],
Cell[37183, 1206, 138, 4, 24, "Notes",
  CellTags->"XML`Parser`XMLGet::xmlprsop"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37358, 1215, 117, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGetString::ilgprsr"],
Cell[37478, 1218, 155, 3, 21, "Message",
  CellTags->"XML`Parser`XMLGetString::ilgprsr"],
Cell[37636, 1223, 143, 4, 24, "Notes",
  CellTags->"XML`Parser`XMLGetString::ilgprsr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37816, 1232, 117, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGetString::memfail"],
Cell[37936, 1235, 214, 3, 37, "Message",
  CellTags->"XML`Parser`XMLGetString::memfail"],
Cell[38153, 1240, 143, 4, 24, "Notes",
  CellTags->"XML`Parser`XMLGetString::memfail"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38333, 1249, 119, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGetString::nfprserr"],
Cell[38455, 1252, 139, 2, 21, "Message",
  CellTags->"XML`Parser`XMLGetString::nfprserr"],
Cell[38597, 1256, 144, 4, 24, "Notes",
  CellTags->"XML`Parser`XMLGetString::nfprserr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38778, 1265, 115, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGetString::prserr"],
Cell[38896, 1268, 135, 2, 21, "Message",
  CellTags->"XML`Parser`XMLGetString::prserr"],
Cell[39034, 1272, 142, 4, 24, "Notes",
  CellTags->"XML`Parser`XMLGetString::prserr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39213, 1281, 119, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`XMLGetString::xmlprsop"],
Cell[39335, 1284, 224, 4, 37, "Message",
  CellTags->"XML`Parser`XMLGetString::xmlprsop"],
Cell[39562, 1290, 144, 4, 24, "Notes",
  CellTags->"XML`Parser`XMLGetString::xmlprsop"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39743, 1299, 125, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bdmgr"],
Cell[39871, 1302, 324, 5, 53, "Message",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bdmgr"],
Cell[40198, 1309, 147, 4, 24, "Notes",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bdmgr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40382, 1318, 125, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgf"],
Cell[40510, 1321, 176, 3, 21, "Message",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgf"],
Cell[40689, 1326, 147, 4, 24, "Notes",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgf"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40873, 1335, 127, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgns"],
Cell[41003, 1338, 191, 3, 21, "Message",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgns"],
Cell[41197, 1343, 148, 4, 24, "Notes",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::bsvgns"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41382, 1352, 125, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::gtype"],
Cell[41510, 1355, 196, 3, 21, "Message",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::gtype"],
Cell[41709, 1360, 147, 4, 24, "Notes",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::gtype"]
}, Open  ]],

Cell[CellGroupData[{
Cell[41893, 1369, 125, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::ncvrt"],
Cell[42021, 1372, 223, 4, 37, "Message",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::ncvrt"],
Cell[42247, 1378, 147, 4, 24, "Notes",
  CellTags->"XML`SVG`GraphicsToSymbolicSVG::ncvrt"]
}, Open  ]],

Cell[CellGroupData[{
Cell[42431, 1387, 125, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`SVG`SymbolicSVGToGraphics::unsup"],
Cell[42559, 1390, 203, 3, 21, "Message",
  CellTags->"XML`SVG`SymbolicSVGToGraphics::unsup"],
Cell[42765, 1395, 147, 4, 24, "Notes",
  CellTags->"XML`SVG`SymbolicSVGToGraphics::unsup"]
}, Open  ]],

Cell[CellGroupData[{
Cell[42949, 1404, 123, 1, 31, "ObjectNameWarningMessages",
  CellTags->"XML`Parser`ReleaseXMLParser::bparsr"],
Cell[43075, 1407, 199, 3, 37, "Message",
  CellTags->"XML`Parser`ReleaseXMLParser::bparsr"],
Cell[43277, 1412, 146, 4, 24, "Notes",
  CellTags->"XML`Parser`ReleaseXMLParser::bparsr"]
}, Open  ]],

Cell[CellGroupData[{
Cell[43460, 1421, 228, 6, 51, "ObjectNameWarningMessages",
  CellTags->{
  "XML`MathML`BoxesToSymbolicMathML::notboxes", 
    "XML`MathML`BoxesToMathML::notboxes"}],
Cell[43691, 1429, 403, 11, 37, "Message",
  CellTags->{
  "XML`MathML`BoxesToSymbolicMathML::notboxes", 
    "XML`MathML`BoxesToMathML::notboxes"}],
Cell[44097, 1442, 201, 6, 24, "Notes",
  CellTags->{
  "XML`MathML`BoxesToSymbolicMathML::notboxes", 
    "XML`MathML`BoxesToMathML::notboxes"}]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

