(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     39101,       1313]*)
(*NotebookOutlinePosition[    170848,       4249]*)
(*  CellTagsIndexPosition[    162130,       4008]*)
(*WindowFrame->Normal*)



Notebook[{
Cell["XMLCapabilities", "IndexSection",
  CellTags->"MasterIndexHeading"],

Cell[TextData[{
  "XML and ",
  StyleBox["Mathematica", "TI"],
  ", introduction, ",
  ButtonBox["XML and ",
    ButtonData:>{"XML and Mathematica"},
    ButtonStyle->"AddOnsLinkText"],
  StyleBox[ButtonBox["Mathematica",
    ButtonData:>{"XML and Mathematica"},
    ButtonStyle->"AddOnsLinkText"], "TI"]
}], "Index",
  CellTags->{"XML and Mathematica", "XML"}],

Cell[TextData[{
  "native XML formats",
  ", ",
  ButtonBox["Native XML Formats",
    ButtonData:>{"Native XML Formats"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "Native XML Formats", "XML and Mathematica", "XML", "MathML", "NotebookML", 
    "ExpressionML"}],

Cell[TextData[{
  " ",
  ButtonBox["MathML",
    ButtonData:>{"Native XML Formats"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Native XML Formats", "XML and Mathematica", "XML", "MathML"}],

Cell[TextData[{
  " ",
  ButtonBox["NotebookML",
    ButtonData:>{"Native XML Formats"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{
  "Native XML Formats", "XML and Mathematica", "XML", "NotebookML"}],

Cell[TextData[{
  " ",
  ButtonBox["ExpressionML",
    ButtonData:>{"Native XML Formats"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{
  "Native XML Formats", "XML and Mathematica", "XML", "ExpressionML"}],

Cell[TextData[{
  "Importing XML, introduction, ",
  ButtonBox["Importing XML",
    ButtonData:>{"Importing XML"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Importing XML", "Import", "XML and Mathematica", "XML"}],

Cell[TextData[{
  "Importing XML, syntax, ",
  ButtonBox["Importing XML",
    ButtonData:>{"Importing XML"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"Importing XML", "Import", "XML Import"}],

Cell[TextData[{
  "function, ",
  ButtonBox["Import",
    ButtonData:>{"Importing XML"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->{"Importing XML", "XML Import", "Import"}],

Cell[TextData[{
  "overriding ",
  StyleBox["Import", "MR"],
  " defaults, ",
  ButtonBox["overriding Import defaults",
    ButtonData:>{"Importing XML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "Importing XML", "Defaults", "Overriding Defaults", "XML Import", 
    "XML Import Defaults", "Import"}],

Cell[TextData[{
  "and file extensions, ",
  ButtonBox["Import file extensions",
    ButtonData:>{"Importing XML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "Importing XML", "Import File Extensions", "File Extensions", "Extensions", 
    "Import"}],

Cell[TextData[{
  "importing a string",
  ", ",
  ButtonBox["ImportString",
    ButtonData:>{"ImportString"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->{"Import", "ImportString", "Importing XML"}],

Cell[TextData[{
  "default behavior",
  ", ",
  ButtonBox["ImportString default behavior",
    ButtonData:>{"ImportString"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "Import", "ImportString", "Defaults", "XML ImportString Defaults", 
    "Importing XML"}],

Cell[TextData[{
  "overriding ",
  StyleBox["ImportString", "MR"],
  " defaults, ",
  ButtonBox["overriding ImportString defaults",
    ButtonData:>{"ImportString"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "Importing XML", "Defaults", "Overriding Defaults", "Overriding Defaults", 
    "XML Import", "XML ImportString Defaults", "Import"}],

Cell[TextData[{
  StyleBox["XMLGet", "MR"],
  ", ",
  ButtonBox["XMLGet",
    ButtonData:>{"XMLGet"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->{"Importing XML", "XMLGet"}],

Cell[TextData[{
  StyleBox["XMLGet", "MR"],
  " conversion options, ",
  ButtonBox["XMLGet Conversion Options",
    ButtonData:>{"XMLGet"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "Import", "Importing XML", "XMLGet", "XMLGet Conversion Options", 
    "ImportConversionOptions", "ConversionOptions"}],

Cell[TextData[{
  StyleBox["XMLGetString", "MR"],
  ", ",
  ButtonBox["XMLGetString",
    ButtonData:>{"XMLGetString"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->{"Import", "ImportString", "XMLGetString", "Importing XML"}],

Cell[TextData[{
  StyleBox["XMLGetString", "MR"],
  " conversion options, ",
  ButtonBox["XMLGetString Conversion Options",
    ButtonData:>{"XMLGetString"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "Import", "Importing XML", "XMLGetString", 
    "XMLGetString Conversion Options", "ImportConversionOptions", 
    "ConversionOptions"}],

Cell[TextData[{
  "Importing XML from URL, ",
  ButtonBox["XMLGet",
    ButtonData:>{"XMLGet"},
    ButtonStyle->"AddOnsLink"],
  " , ",
  ButtonBox["XMLGetString",
    ButtonData:>{"XMLGetString"},
    ButtonStyle->"AddOnsLink"],
  " "
}], "Index",
  CellTags->{
  "Importing XML", "Import", "XMLGet", "XMLGetString", "URL", 
    "Import from URL", "Importing over HTTP", "XML Import", 
    "Import from Website"}],

Cell[TextData[{
  "conversion options",
  ", ",
  ButtonBox["XML Import Conversion Options",
    ButtonData:>{"XML Import Conversion Options"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "Import", "Importing XML", "XML Conversion Options", 
    "Import Conversion Options", "Conversion Options", "Options"}],

Cell[TextData[{
  "and entities",
  ", ",
  ButtonBox["Entities and Validation",
    ButtonData:>{"Entities and Validation"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "Import", "ImportString", "Importing XML", "Entities and Validation", 
    "Unicode", "Entities", "Validation"}],

Cell[TextData[{
  "Entities conversion options",
  ", ",
  ButtonBox["Entities Conversion Options",
    ButtonData:>{"Entities and Validation"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "Entities", "Validation", "Entities and Validation", "Import", 
    "Import Conversion Options", "Options", "Conversion Options", 
    "XMLGet Conversion Options", "ImportConversionOptions", 
    "ConversionOptions"}],

Cell[TextData[{
  "Validation conversion options",
  ", ",
  ButtonBox["Validation Conversion Options",
    ButtonData:>{"Entities and Validation"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "Validation", "Entities and Validation", "Import", 
    "Import Conversion Options", "Options", "Conversion Options", 
    "XMLGet Conversion Options", "ImportConversionOptions", 
    "ConversionOptions"}],

Cell[TextData[{
  "preinitializing the parser, ",
  ButtonBox["InitializeXMLParser",
    ButtonData:>{"InitializeXMLParser"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "XMLGet", "URL", "Import from URL", "Importing over HTTP", "XML Import", 
    "Import from Website", "InitializeXMLParser", "Importing XML", 
    "Entities and Validation"}],

Cell[TextData[{
  "SymbolicXML, introduction, ",
  ButtonBox["SymbolicXML",
    ButtonData:>{"SymbolicXML"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"SymbolicXML", "XML and Mathematica", "XML"}],

Cell[TextData[{
  "syntax",
  ", ",
  ButtonBox["Overview of Syntax",
    ButtonData:>{"SymbolicXML Syntax"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "SymbolicXML Syntax", "XML and Mathematica", "XML"}],

Cell[TextData[{
  "SymbolicXML and ",
  StyleBox["J/Link", "TI"],
  ",",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox[ButtonBox["J/Link",
    ButtonData:>{"SymbolicXML"},
    ButtonStyle->"AddOnsLinkText"], "TI"]
}], "IndexSubentry",
  CellTags->{"SymbolicXML", "J/Link", "SymbolicXML and J/Link"}],

Cell[TextData[{
  "Symbolic XML and tree structure",
  ", ",
  ButtonBox["Tree Structure",
    ButtonData:>{"SymbolicXML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"SymbolicXML", "Tree Structure", "XML and Mathematica", "XML"}],

Cell[TextData[{
  "SymbolicXML and XSLT",
  ", ",
  ButtonBox["XSLT",
    ButtonData:>{"SymbolicXML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"SymbolicXML", "XSLT", "SymbolicXML and XSLT", "XSLT"}],

Cell[TextData[{
  "SymbolicXML and Java",
  ", ",
  ButtonBox["Java",
    ButtonData:>{"SymbolicXML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"SymbolicXML", "SymbolicXML and Java", "Java"}],

Cell[TextData[{
  "SymbolicXML and SAX",
  ", ",
  ButtonBox["SAX",
    ButtonData:>{"SymbolicXML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"SymbolicXML", "SymbolicXML and SAX", "SAX"}],

Cell[TextData[{
  "SymbolicXML and DOM API",
  ", ",
  ButtonBox["DOM API",
    ButtonData:>{"SymbolicXML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"SymbolicXML", "SymbolicXML and DOM API", "DOM API"}],

Cell[TextData[{
  "SymbolicXML and pattern matching",
  ", ",
  ButtonBox["Pattern Matching",
    ButtonData:>{"SymbolicXML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"SymbolicXML", "Pattern Matching"}],

Cell[TextData[{
  "SymbolicXML and workflow",
  ", ",
  ButtonBox["SymbolicXML Workflow",
    ButtonData:>{"SymbolicXML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"SymbolicXML", "SymbolicXML Workflow", "Workflow"}],

Cell[TextData[{
  StyleBox["XMLElement", "MR"],
  ", definition, ",
  ButtonBox["XMLElement",
    ButtonData:>{"XMLElement"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->{
  "SymbolicXML", "SymbolicXML Syntax", "Element", "XMLElement", 
    "XML and Mathematica", "XML"}],

Cell[TextData[{
  StyleBox["XMLElement", "MR"],
  " syntax, ",
  ButtonBox["XMLElement syntax",
    ButtonData:>{"XMLElement"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XML and Mathematica", "XML", "Element", "XMLElement", 
    "SymbolicXML Syntax", "XMLElement Syntax"}],

Cell[TextData[{
  StyleBox["XMLElement", "MR"],
  " argument, ",
  ButtonBox["XMLElement argument",
    ButtonData:>{"XMLElement"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "Element", "XMLElement Argument", "Argument", 
    "SymbolicXML Syntax", "XMLElement Syntax"}],

Cell[TextData[{
  StyleBox["XMLElement", "MR"],
  " child elements, ",
  ButtonBox["Child elements",
    ButtonData:>{"XMLElement"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLElement", "XML Child Elements", "Child Elements", 
    "Element", "SymbolicXML Syntax", "XMLElement Syntax"}],

Cell[TextData[{
  StyleBox["XMLElement", "MR"],
  ", and nesting commands, ",
  ButtonBox["Nesting Commands",
    ButtonData:>{"XMLElement"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLElement", "Element", "SymbolicXML Syntax", 
    "XMLElement Commands", "Nesting Commands"}],

Cell[TextData[{
  StyleBox["XMLElement", "MR"],
  " names, ",
  ButtonBox["XMLElement names",
    ButtonData:>{"XMLElement"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLElement", "XMLElement Names", "Names", 
    "SymbolicXML Syntax", "XMLElement Syntax"}],

Cell[TextData[{
  StyleBox["XMLElement", "MR"],
  " namespaces, ",
  ButtonBox["XMLElement Namespaces",
    ButtonData:>{"Handling Namespaces"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLElement Namespaces", "XMLElement", "SymbolicXML Syntax", 
    "XMLElement Syntax"}],

Cell[TextData[{
  StyleBox["XMLElement", "MR"],
  " default namespaces, ",
  ButtonBox["XMLElement default namespaces",
    ButtonData:>{"Handling Namespaces"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "Default Namespaces", "XMLElement", "Namespace Prefixes", 
    "SymbolicXML Syntax", "XMLElement Syntax"}],

Cell[TextData[{
  StyleBox["XMLElement", "MR"],
  " explicit namespaces, ",
  ButtonBox["XMLElement explicit namespaces",
    ButtonData:>{"Handling Namespaces"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "Explicit Namespaces", "XMLElement", "Namespace Prefixes", 
    "SymbolicXML Syntax", "XMLElement Syntax"}],

Cell[TextData[{
  StyleBox["XMLObject", "MR"],
  ", definition, ",
  ButtonBox["XMLObject",
    ButtonData:>{"XMLObject"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->{"SymbolicXML", "XML and Mathematica", "XML", "XMLObject"}],

Cell[TextData[{
  StyleBox["XMLObject", "MR"],
  ", conversion options, ",
  ButtonBox["XMLObject",
    ButtonData:>{"XMLObject"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->{
  "SymbolicXML", "XMLGet Conversion Options", "Conversion Options", 
    "Import Conversion Options", "XMLObject"}],

Cell[TextData[{
  StyleBox["XMLObject", "MR"],
  " syntax, ",
  ButtonBox["XMLObject syntax",
    ButtonData:>{"SymbolicXML Syntax"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XML and Mathematica", "XML", "XMLObject", 
    "SymbolicXML Syntax", "XMLObject Syntax"}],

Cell[TextData[{
  "XML declaration, ",
  ButtonBox["XML declaration",
    ButtonData:>{"XMLObject"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLObject", "Declaration", "XML Declaration", 
    "Declaration Options"}],

Cell[TextData[ButtonBox["Standalone",
  ButtonData:>{"XMLObject"},
  ButtonStyle->"AddOnsLink"]], "IndexSubentry",
  CellTags->{
  "Standalone", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
    "Declaration Options", "XMLObject Syntax"}],

Cell[TextData[ButtonBox["Encoding",
  ButtonData:>{"XMLObject"},
  ButtonStyle->"AddOnsLink"]], "IndexSubentry",
  CellTags->{
  "Encoding", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
    "Declaration Options", "XMLObject Syntax"}],

Cell[TextData[{
  "XML comment, ",
  ButtonBox["XML comment",
    ButtonData:>{"XMLObject"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"SymbolicXML", "XMLObject", "Comment", "XML Comment"}],

Cell[TextData[{
  "XML document, ",
  ButtonBox["XML document",
    ButtonData:>{"XMLObject"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"SymbolicXML", "XMLObject", "Document", "XML Document"}],

Cell[TextData[{
  "XML DOCTYPE, ",
  ButtonBox["XML Doctype",
    ButtonData:>{"XMLObject"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"SymbolicXML", "XMLObject", "DOCTYPE", "XML DOCTYPE"}],

Cell[TextData[ButtonBox["XML`Parser",
  ButtonData:>"XMLGet",
  ButtonStyle->"AddOnsLink"]], "IndexSubentry",
  CellTags->{
  "XML`Parser", "XML and Mathematica", "XML", "XMLGet", "XMLGetString", 
    "Context"}],

Cell[TextData[ButtonBox["System",
  ButtonData:>{"XMLObject"},
  ButtonStyle->"AddOnsLink"]], "IndexSubentry",
  CellTags->{
  "System", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
    "DOCTYPE Options", "XMLObject Syntax"}],

Cell[TextData[ButtonBox["Public",
  ButtonData:>{"XMLObject"},
  ButtonStyle->"AddOnsLink"]], "IndexSubentry",
  CellTags->{
  "Public", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
    "DOCTYPE Options", "XMLObject Syntax"}],

Cell[TextData[ButtonBox["Internal",
  ButtonData:>{"XMLObject"},
  ButtonStyle->"AddOnsLink"]], "IndexSubentry",
  CellTags->{
  "Internal", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
    "DOCTYPE Options", "XMLObject Syntax"}],

Cell[TextData[{
  "XML processing instruction, ",
  ButtonBox["XML processing instruction",
    ButtonData:>{"XMLObject"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLObject", "Procession Instruction", 
    "XML Processing Instruction"}],

Cell[TextData[{
  "XML CDATASection, ",
  ButtonBox["XML CDATASection",
    ButtonData:>{"XMLObject"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLObject", "CDATA", "Character Data", "XML CDATASection", 
    "PreserveCDATASections"}],

Cell[TextData[{
  "XHTML",
  ", example with MathML, ",
  ButtonBox["XMLObject",
    ButtonData:>{"Handling Namespaces"},
    ButtonStyle->"AddOnsLink"]
}], "Index",
  CellTags->{"XHTML", "MathML"}],

Cell[TextData[{
  "namespaces, ",
  ButtonBox["Handling Namespaces",
    ButtonData:>{"Handling Namespaces"},
    ButtonStyle->"AddOnsLinkText"],
  " , ",
  ButtonBox["DTDs and Namespaces",
    ButtonData:>{"DTDs and Namespaces"},
    ButtonStyle->"AddOnsLinkText"],
  " "
}], "Index",
  CellTags->{
  "Namespaces", "DTDs and Namespaces", "Handling Namespaces", 
    "SymbolicXML and Namespaces"}],

Cell[TextData[{
  "XML constructs",
  ", ",
  ButtonBox["Representing Other Objects",
    ButtonData:>{"Representing Other Objects"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXML", "Representing Other Objects", "XML Constructs", 
    "XML and Mathematica", "XML"}],

Cell[TextData[{
  "Transforming XML",
  ", ",
  ButtonBox["Transforming XML",
    ButtonData:>{"Transforming XML:Introduction"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{
  "Transforming XML", "XML and Mathematica", "SymbolicXML", 
    "Processing XML Data"}],

Cell[TextData[{
  "XML Tree",
  ", ",
  ButtonBox["Visualizing the XML Tree",
    ButtonData:>{"Visualizing the XML Tree"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "Visualizing the XML Tree", "Transforming XML", "XML and Mathematica", 
    "XML", "Tree Structure", "Notebook", "SymbolicXML"}],

Cell[TextData[{
  "Manipulating XML Data",
  ", ",
  ButtonBox["Manipulating XML Data",
    ButtonData:>{"Manipulating XML Data"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "Manipulating Data", "Manipulating XML Data", "Transforming XML", 
    "XML and Mathematica", "XML Data", "Pattern Matching"}],

Cell[TextData[{
  "Visualizing XML Data",
  ", ",
  ButtonBox["Visualizing XML Data",
    ButtonData:>{"Visualizing XML Data"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "XML Data", "Visualizing XML Data", "Transforming XML", 
    "XML and Mathematica", "MoDL"}],

Cell[TextData[{
  "Comparing XSLT and Mathematica",
  ", ",
  ButtonBox["XSLT and Mathematica",
    ButtonData:>{"XSLT and Mathematica"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "XSLT", "XSLT and Mathematica", "Transforming XML", "XML and Mathematica", 
    "Converting", "XML", "Ancestor Elements", "Elements", "Sibling Elements", 
    "Child Elements", "Predicates"}],

Cell[TextData[{
  "Converting a notebook to HTML, ",
  ButtonBox["Notebook to HTML",
    ButtonData:>{"Notebook to HTML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "HTML", "Notebook", "XML", "Notebook to HTML", "Transforming XML"}],

Cell[TextData[{
  "Verifying SymbolicXML Syntax, ",
  ButtonBox["Verifying SymbolicXML Syntax",
    ButtonData:>{"Verifying SymbolicXML Syntax"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "SymbolicXMLErrors", "Errors", "XML Errors", "SymbolicXML", 
    "SymbolicXML Syntax", "Verifying SymbolicXML Syntax", "Transforming XML", 
    "Part", "Extract"}],

Cell[TextData[{
  "Exporting XML",
  ", introduction, ",
  ButtonBox["Exporting XML",
    ButtonData:>{"Exporting XML"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{
  "Exporting XML", "Export", "SymbolicXML", "XML and Mathematica", "XML", 
    "Export File Formats"}],

Cell[TextData[{
  "function",
  ", ",
  ButtonBox["Export",
    ButtonData:>{"Export"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->{"Export", "Exporting XML", "XML and Mathematica"}],

Cell[TextData[{
  "exporting a string",
  ", ",
  ButtonBox["ExportString",
    ButtonData:>{"ExportString"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->{
  "Export", "ExportString", "Exporting XML", "XML and Mathematica", 
    "SymbolicXML", "XML"}],

Cell[TextData[{
  "conversion options",
  ", ",
  ButtonBox["XML Export Conversion Options",
    ButtonData:>{"XML Export Conversion Options"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"Export", "Exporting XML", "XML Export Conversion Options"}],

Cell[TextData[ButtonBox["CheckXML",
  ButtonData:>{"XML Export Conversion Options"},
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{
  "CheckXML", "Export", "Exporting XML", "XML Export Conversion Options"}],

Cell[TextData[ButtonBox["ElementFormatting",
  ButtonData:>{"ElementFormatting"},
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"ElementFormatting", "Element Formatting", "Element", "Export"}],

Cell[TextData[ButtonBox["Entities",
  ButtonData:>{"Entities"},
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{
  "Entities", "Export", "Exporting XML", "XML Export Conversion Options"}],

Cell[TextData[ButtonBox["Annotations",
  ButtonData:>{"XML Annotations"},
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{
  "Annotations", "Export", "Exporting XML", "XML Export Conversion Options"}],

Cell[TextData[{
  "NotebookML, introduction, ",
  ButtonBox["NotebookML",
    ButtonData:>{"NotebookML:Introduction"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{
  "NotebookML:Introduction", "XML and Mathematica", "NotebookML", "XML"}],

Cell[TextData[{
  "syntax",
  ", ",
  ButtonBox["NotebookML Syntax",
    ButtonData:>{"NotebookML Syntax"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Syntax", "XML and Mathematica", "XML", 
    "NotebookML Elements", "NotebookML Attributes"}],

Cell[TextData[{
  "basic NotebookML elements",
  ", ",
  ButtonBox["Basic NotebookML Elements",
    ButtonData:>{"BasicBNMLElements"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Syntax", "NotebookML Elements", "Notebook", 
    "Elements", "Cell"}],

Cell[TextData[{
  "additional NotebookML elements",
  ", ",
  ButtonBox["Additional NotebookML Elements",
    ButtonData:>{"Additional NotebookML Elements"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Syntax", "NotebookML Elements", "String", 
    "Element", "List", "Number", "Symbol", "Options", "Option Elements"}],

Cell[TextData[{
  "front end options",
  ", ",
  ButtonBox["NotebookML Front End Options",
    ButtonData:>{"NotebookML Front End Options"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Syntax", "List Types", "String", "Color Values", 
    "Suboptions", "Number", "Symbol", "Options", 
    "NotebookML Front End Options"}],

Cell[TextData[ButtonBox["BoxData",
  ButtonData:>{"Cell Content Expressions"},
  ButtonStyle->"AddOnsLinkText"]], "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
    "CellGroupData", "OutputFormData", "TextData", "StyleData", 
    "TaggingRules", "XMLData", "XML Data", "Options", 
    "NotebookML Front End Options"}],

Cell[TextData[ButtonBox["Box Options",
  ButtonData:>{"Boxes"},
  ButtonStyle->"AddOnsLinkText"]], "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", "CellOptions", 
    "NotebookOptions", "RowBox", "GridBox", "OptionValueBox", 
    "InterpretationBox", "TagBox", "FormBox", "StyleBox", "CounterBox", 
    "ValueBox"}],

Cell[TextData[{
  "importing NotebookML",
  ", ",
  ButtonBox["Importing NotebookML",
    ButtonData:>{"importing NotebookML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"NotebookML", "Import", "XML and Mathematica"}],

Cell[TextData[{
  "annotations",
  ", ",
  ButtonBox["NotebookML Annotations",
    ButtonData:>{"NotebookML Annotations"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"NotebookML Annotations", "NotebookML"}],

Cell[TextData[{
  "and ",
  StyleBox["BoxFormats", "MR"],
  ", ",
  ButtonBox["BoxFormats",
    ButtonData:>{"BoxFormats"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->{"BoxFormats", "NotebookML"}],

Cell[TextData[{
  "graphics formats",
  ", ",
  ButtonBox["GraphicsFormats",
    ButtonData:>{"GraphicsFormats"},
    ButtonStyle->"AddOnsLink"]
}], "IndexSubentry",
  CellTags->{"GraphicsFormats", "NotebookML"}],

Cell[TextData[{
  "stylesheets",
  ", ",
  ButtonBox["NotebookML Stylesheets",
    ButtonData:>{"NotebookML Stylesheets"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"NotebookML Stylesheets", "NotebookML", "Stylesheets"}],

Cell[TextData[{
  "DTDs and namespaces",
  ", ",
  ButtonBox["DTDs and Namespaces",
    ButtonData:>{"DTDs and Namespaces"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"DTDs and Namespaces", "NotebookML"}],

Cell[TextData[{
  "processing NotebookML",
  ", ",
  ButtonBox["Processing NotebookML",
    ButtonData:>{"Processing NotebookML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "NotebookML", "Processing NotebookML", "SymbolicXML", 
    "NotebookML Conversion"}],

Cell[TextData[{
  "preprocessing NotebookML",
  ", ",
  ButtonBox["Preprocessing NotebookML",
    ButtonData:>{"Preprocessing NotebookML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "NotebookML", "Processing NotebookML", "Preprocessing NotebookML"}],

Cell[TextData[{
  "postprocessing NotebookML",
  ", ",
  ButtonBox["Postprocessing NotebookML",
    ButtonData:>{"Postprocessing NotebookML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "NotebookML", "Processing NotebookML", "Postprocessing NotebookML", 
    "SymbolicXML"}],

Cell[TextData[{
  "NotebookML Conversion Rules",
  ", ",
  ButtonBox["NotebookML Conversion Rules",
    ButtonData:>{"NotebookML Conversion Rules"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "NotebookML", "Processing NotebookML", "NotebookML Conversion Rules"}],

Cell[TextData[{
  "exporting NotebookML",
  ", ",
  ButtonBox["Exporting NotebookML",
    ButtonData:>{"Exporting NotebookML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"NotebookML", "Exporting NotebookML", "Export"}],

Cell[TextData[{
  "exporting NotebookML using ",
  StyleBox["ExportString", "MR"],
  ", ",
  ButtonBox["NotebookML and ExportString",
    ButtonData:>{"Exporting NotebookML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"NotebookML", "Exporting NotebookML", "ExportString", "Export"}],

Cell[TextData[{
  "NotebookML Export Conversion Options",
  ", ",
  ButtonBox["NotebookML Export Conversion Options",
    ButtonData:>{"NotebookML Export Conversion Options"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Export Conversion Options", 
    "Export Conversion Options"}],

Cell[TextData[{
  "NotebookML Annotations",
  ", ",
  ButtonBox["NotebookML Annotations",
    ButtonData:>{"NotebookML Annotations"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Annotations", "Annotations", 
    "NotebookML Export Conversion Options", "Export Conversion Options"}],

Cell[TextData[{
  StyleBox["BoxFormats", "MR"],
  ", ",
  ButtonBox["BoxFormats",
    ButtonData:>{"BoxFormats"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "NotebookML", "BoxFormats", "NotebookML Export Conversion Options", 
    "Export Conversion Options"}],

Cell[TextData[{
  StyleBox["GraphicsFormats", "MR"],
  ", ",
  ButtonBox["GraphicsFormats",
    ButtonData:>{"GraphicsFormats"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "NotebookML", "GraphicsFormats", "NotebookML Export Conversion Options", 
    "Export Conversion Options"}],

Cell[TextData[{
  "NotebookML Stylesheets",
  ", ",
  ButtonBox["NotebookML Stylesheets",
    ButtonData:>{"NotebookML Stylesheets"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"NotebookML", "Stylesheets", "NotebookML Stylesheets"}],

Cell[TextData[{
  "displaying NotebookML using CSS",
  ", ",
  ButtonBox["Displaying NotebookML",
    ButtonData:>{"Displaying NotebookML using CSS"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"NotebookML", "Displaying NotebookML using CSS", "CSS"}],

Cell[TextData[{
  "MathML, introduction, ",
  ButtonBox["MathML",
    ButtonData:>{"MathML"},
    ButtonStyle->"AddOnsLinkText"]
}], "Index",
  CellTags->{"MathML", "XML and Mathematica"}],

Cell[TextData[{
  "syntax",
  ", ",
  ButtonBox["MathML Syntax",
    ButtonData:>{"MathML Syntax"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"MathML", "MathML Syntax", "XML and Mathematica"}],

Cell[TextData[{
  "Presentation MathML",
  ", ",
  ButtonBox["Presentation MathML",
    ButtonData:>{"Presentation MathML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"MathML", "MathML Syntax", "Presentation MathML"}],

Cell[TextData[{
  "Content MathML",
  ", ",
  ButtonBox["Content MathML",
    ButtonData:>{"Content MathML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"MathML", "MathML Syntax", "Content MathML"}],

Cell[TextData[{
  "Importing MathML",
  ", ",
  ButtonBox["Importing MathML",
    ButtonData:>{"Importing MathML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"MathML", "Import", "Importing MathML"}],

Cell[TextData[{
  "MathML import conversion options",
  ", ",
  ButtonBox["MathML Import Conversion Options",
    ButtonData:>{"MathML Import Conversion Options"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"Importing MathML", "MathML Import Conversion Options"}],

Cell[TextData[{
  "generating MathML",
  ", ",
  ButtonBox["Generating MathML",
    ButtonData:>{"Generating MathML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "MathML", "Generating MathML", "BoxesToMathML", "ExpressionToMathML", 
    "BoxesToSymbolicMathML", "ExpressionToSymbolicMathML", "Export"}],

Cell[TextData[{
  "exporting MathML",
  ", ",
  ButtonBox["Exporting MathML",
    ButtonData:>{"Exporting MathML"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"MathML", "Exporting MathML", "Export"}],

Cell[TextData[{
  "MathML export conversion options",
  ", ",
  ButtonBox["MathML Export Conversion Options",
    ButtonData:>{"MathML Export Conversion Options"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "MathML", "Exporting MathML", "Export", "MathML Export Conversion Options"}],

Cell[TextData[{
  "MathML Formats",
  ", ",
  ButtonBox["MathML Formats",
    ButtonData:>{"MathMLFormats"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "MathML", "Exporting MathML", "Export", "MathML Export Conversion Options", 
    "MathML Formats"}],

Cell[TextData[{
  "MathML Annotations",
  ", ",
  ButtonBox["MathML Annotations",
    ButtonData:>{"MathMLAnnotations"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "MathML", "Exporting MathML", "Export", "MathML Export Conversion Options", 
    "MathML Annotations", "Annotations"}],

Cell[TextData[{
  "MathML Namespace Prefixes",
  ", ",
  ButtonBox["MathML Namespace Prefixes",
    ButtonData:>{"MathML Namespace Prefixes"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{
  "MathML", "Exporting MathML", "Export", "MathML Export Conversion Options", 
    "MathML Namespace Prefixes", "Namespaces"}],

Cell[TextData[{
  "symbols for MathML elements",
  ", ",
  ButtonBox["MathML Symbols",
    ButtonData:>{"Symbols for MathML Elements"},
    ButtonStyle->"AddOnsLinkText"]
}], "IndexSubentry",
  CellTags->{"MathML", "Symbols for MathML Elements", "MathML Elements"}],

Cell[TextData[ButtonBox["NormalizeWhitespace",
  ButtonData:>"NormalizeWhitespace",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{
  "XML Import Conversion Options", "NormalizeWhitespace", 
    "Import Conversion Options", "Whitespace"}],

Cell[TextData[ButtonBox["AllowRemoteDTDAccess",
  ButtonData:>"AllowRemoteDTDAccess",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{
  "XML Import Conversion Options", "Import Conversion Options", 
    "AllowRemoteDTDAccess", "Remote DTD Access", "DTD"}],

Cell[TextData[ButtonBox["AllowUnrecognizedEntities",
  ButtonData:>"AllowUnrecognizedEntities",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{
  "XML Import Conversion Options", "AllowUnrecognizedEntities", "Entities", 
    "Unrecognized Entities", "Import Conversion Options"}],

Cell[TextData[ButtonBox["ReadDTD",
  ButtonData:>"ReadDTD",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{
  "XML Import Conversion Options", "ReadDTD", "DTD", "External DTD", 
    "Validation", "External Subset"}],

Cell[TextData[ButtonBox["ValidateAgainstDTD",
  ButtonData:>"ValidateAgainstDTD",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{
  "XML Import Conversion Options", "Import Conversion Options", 
    "ValidateAgainstDTD", "DTD", "Validation", "DOCTYPE", "Declaration"}],

Cell[TextData[ButtonBox["IncludeDefaultedAttributes",
  ButtonData:>"IncludeDefaultedAttributes",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{
  "IncludeDefaultedAttributes", "XML Import Conversion Options", 
    "Import Conversion Options"}],

Cell[TextData[ButtonBox["IncludeEmbeddedObjects",
  ButtonData:>"IncludeEmbeddedObjects",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{
  "XML Import Conversion Options", "IncludeEmbeddedObjects", "Comments", 
    "Processing Instructions", "Embedded Objects", "Objects", 
    "Import Conversion Options", "Pattern Matching"}],

Cell[TextData[ButtonBox["IncludeNamespaces",
  ButtonData:>"IncludeNamespaces",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{
  "XML Import Conversion Options", "IncludeNamespaces", "Namespaces", 
    "Scoping", "Import Conversion Options", "Non-compliant XML documents"}],

Cell[TextData[ButtonBox["PreserveCDATASections",
  ButtonData:>"PreserveCDATASections",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{
  "XML Import Conversion Options", "PreserveCDATASections", 
    "Import Conversion Options"}],

Cell[TextData[ButtonBox["SymbolicXMLQ",
  ButtonData:>"SymbolicXMLQ",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"SymbolicXMLQ", "XML Functions"}],

Cell[TextData[ButtonBox["ToSymbolicXML",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"ToSymbolicXML", "XML Functions"}],

Cell[TextData[ButtonBox["FromSymbolicXML",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"FromSymbolicXML", "XML Functions"}],

Cell[TextData[ButtonBox["ToVerboseXML",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"ToVerboseXML", "XML Functions"}],

Cell[TextData[ButtonBox["ToCompactXML",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"ToCompactXML", "XML Functions"}],

Cell[TextData[ButtonBox["SymbolicXMLErrors",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{
  "SymbolicXMLErrors", "Transforming XML", "XML Errors", "SymbolicXML", 
    "XML Functions"}],

Cell[TextData[ButtonBox["ReleaseXMLParser",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"ReleaseXMLParser", "XML Functions"}],

Cell[TextData[ButtonBox["NotebookToSymbolicNotebookML",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"NotebookToSymbolicNotebookML", "XML Functions"}],

Cell[TextData[ButtonBox["ExpressionToSymbolicExpressionML",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"XML Functions", "ExpressionToSymbolicExpressionML"}],

Cell[TextData[ButtonBox["SymbolicNotebookMLToNotebook",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"SymbolicNotebookMLToNotebook", "XML Functions"}],

Cell[TextData[ButtonBox["SymbolicExpressionMLToExpression",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"SymbolicExpressionMLToExpression", "XML Functions"}],

Cell[TextData[ButtonBox["BoxesToMathML",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"BoxesToMathML", "XML Functions"}],

Cell[TextData[ButtonBox["MathMLToBoxes",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"MathMLToBoxes", "XML Functions"}],

Cell[TextData[ButtonBox["ExpressionToMathML",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"ExpressionToMathML", "XML Functions"}],

Cell[TextData[ButtonBox["MathMLToExpression",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"MathMLToExpression", "XML Functions"}],

Cell[TextData[ButtonBox["SymbolicMathMLToBoxes",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"SymbolicMathMLToBoxes", "XML Functions"}],

Cell[TextData[ButtonBox["BoxesToSymbolicMathML",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"BoxesToSymbolicMathML", "XML Functions"}],

Cell[TextData[ButtonBox["ExpressionToSymbolicMathML",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"ExpressionToSymbolicMathML", "XML Functions"}],

Cell[TextData[ButtonBox["SymbolicMathMLToExpression",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"SymbolicMathMLToExpression", "XML Functions"}],

Cell[TextData[ButtonBox["MathMLForm",
  ButtonStyle->"AddOnsLink"]], "Index",
  CellTags->{"MathMLForm", "XML Functions"}]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{4, 1280}, {0, 938}},
ScreenStyleEnvironment->"Brackets",
WindowSize->{755, 533},
WindowMargins->{{-1, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "MasterIndexHeading"->{
    Cell[1754, 51, 73, 1, 41, "IndexSection",
      CellTags->"MasterIndexHeading"]},
  "XML and Mathematica"->{
    Cell[1830, 54, 361, 11, 16, "Index",
      CellTags->{"XML and Mathematica", "XML"}],
    Cell[2194, 67, 291, 9, 16, "IndexSubentry",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "MathML", 
        "NotebookML", "ExpressionML"}],
    Cell[2488, 78, 208, 6, 16, "Index",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "MathML"}],
    Cell[2699, 86, 219, 7, 16, "Index",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "NotebookML"}],
    Cell[2921, 95, 223, 7, 16, "Index",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "ExpressionML"}],
    Cell[3147, 104, 233, 6, 16, "Index",
      CellTags->{"Importing XML", "Import", "XML and Mathematica", "XML"}],
    Cell[8752, 298, 215, 6, 16, "Index",
      CellTags->{"SymbolicXML", "XML and Mathematica", "XML"}],
    Cell[8970, 306, 249, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "SymbolicXML Syntax", "XML and Mathematica", "XML"}],
    Cell[9531, 328, 256, 7, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Tree Structure", "XML and Mathematica", "XML"}],
    Cell[11174, 391, 283, 9, 16, "Index",
      CellTags->{
      "SymbolicXML", "SymbolicXML Syntax", "Element", "XMLElement", 
        "XML and Mathematica", "XML"}],
    Cell[11460, 402, 318, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XML and Mathematica", "XML", "Element", "XMLElement", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[14106, 490, 238, 7, 16, "Index",
      CellTags->{"SymbolicXML", "XML and Mathematica", "XML", "XMLObject"}],
    Cell[14654, 510, 311, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XML and Mathematica", "XML", "XMLObject", 
        "SymbolicXML Syntax", "XMLObject Syntax"}],
    Cell[16391, 569, 212, 5, 15, "IndexSubentry",
      CellTags->{
      "XML`Parser", "XML and Mathematica", "XML", "XMLGet", "XMLGetString", 
        "Context"}],
    Cell[18483, 641, 304, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Representing Other Objects", "XML Constructs", 
        "XML and Mathematica", "XML"}],
    Cell[18790, 652, 279, 9, 16, "Index",
      CellTags->{
      "Transforming XML", "XML and Mathematica", "SymbolicXML", 
        "Processing XML Data"}],
    Cell[19072, 663, 324, 9, 16, "IndexSubentry",
      CellTags->{
      "Visualizing the XML Tree", "Transforming XML", "XML and Mathematica", 
        "XML", "Tree Structure", "Notebook", "SymbolicXML"}],
    Cell[19399, 674, 329, 9, 16, "IndexSubentry",
      CellTags->{
      "Manipulating Data", "Manipulating XML Data", "Transforming XML", 
        "XML and Mathematica", "XML Data", "Pattern Matching"}],
    Cell[19731, 685, 292, 9, 16, "IndexSubentry",
      CellTags->{
      "XML Data", "Visualizing XML Data", "Transforming XML", 
        "XML and Mathematica", "MoDL"}],
    Cell[20026, 696, 401, 10, 16, "IndexSubentry",
      CellTags->{
      "XSLT", "XSLT and Mathematica", "Transforming XML", 
        "XML and Mathematica", "Converting", "XML", "Ancestor Elements", 
        "Elements", "Sibling Elements", "Child Elements", "Predicates"}],
    Cell[21079, 728, 285, 9, 16, "Index",
      CellTags->{
      "Exporting XML", "Export", "SymbolicXML", "XML and Mathematica", "XML", 
        "Export File Formats"}],
    Cell[21367, 739, 203, 7, 16, "IndexSubentry",
      CellTags->{"Export", "Exporting XML", "XML and Mathematica"}],
    Cell[21573, 748, 271, 9, 16, "IndexSubentry",
      CellTags->{
      "Export", "ExportString", "Exporting XML", "XML and Mathematica", 
        "SymbolicXML", "XML"}],
    Cell[22944, 791, 254, 7, 16, "Index",
      CellTags->{
      "NotebookML:Introduction", "XML and Mathematica", "NotebookML", "XML"}],
    
    Cell[23201, 800, 298, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "XML and Mathematica", "XML", 
        "NotebookML Elements", "NotebookML Attributes"}],
    Cell[25291, 863, 244, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML", "Import", "XML and Mathematica"}],
    Cell[30243, 1041, 188, 6, 16, "Index",
      CellTags->{"MathML", "XML and Mathematica"}],
    Cell[30434, 1049, 219, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "MathML Syntax", "XML and Mathematica"}]},
  "XML"->{
    Cell[1830, 54, 361, 11, 16, "Index",
      CellTags->{"XML and Mathematica", "XML"}],
    Cell[2194, 67, 291, 9, 16, "IndexSubentry",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "MathML", 
        "NotebookML", "ExpressionML"}],
    Cell[2488, 78, 208, 6, 16, "Index",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "MathML"}],
    Cell[2699, 86, 219, 7, 16, "Index",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "NotebookML"}],
    Cell[2921, 95, 223, 7, 16, "Index",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "ExpressionML"}],
    Cell[3147, 104, 233, 6, 16, "Index",
      CellTags->{"Importing XML", "Import", "XML and Mathematica", "XML"}],
    Cell[8752, 298, 215, 6, 16, "Index",
      CellTags->{"SymbolicXML", "XML and Mathematica", "XML"}],
    Cell[8970, 306, 249, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "SymbolicXML Syntax", "XML and Mathematica", "XML"}],
    Cell[9531, 328, 256, 7, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Tree Structure", "XML and Mathematica", "XML"}],
    Cell[11174, 391, 283, 9, 16, "Index",
      CellTags->{
      "SymbolicXML", "SymbolicXML Syntax", "Element", "XMLElement", 
        "XML and Mathematica", "XML"}],
    Cell[11460, 402, 318, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XML and Mathematica", "XML", "Element", "XMLElement", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[14106, 490, 238, 7, 16, "Index",
      CellTags->{"SymbolicXML", "XML and Mathematica", "XML", "XMLObject"}],
    Cell[14654, 510, 311, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XML and Mathematica", "XML", "XMLObject", 
        "SymbolicXML Syntax", "XMLObject Syntax"}],
    Cell[16391, 569, 212, 5, 15, "IndexSubentry",
      CellTags->{
      "XML`Parser", "XML and Mathematica", "XML", "XMLGet", "XMLGetString", 
        "Context"}],
    Cell[18483, 641, 304, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Representing Other Objects", "XML Constructs", 
        "XML and Mathematica", "XML"}],
    Cell[19072, 663, 324, 9, 16, "IndexSubentry",
      CellTags->{
      "Visualizing the XML Tree", "Transforming XML", "XML and Mathematica", 
        "XML", "Tree Structure", "Notebook", "SymbolicXML"}],
    Cell[20026, 696, 401, 10, 16, "IndexSubentry",
      CellTags->{
      "XSLT", "XSLT and Mathematica", "Transforming XML", 
        "XML and Mathematica", "Converting", "XML", "Ancestor Elements", 
        "Elements", "Sibling Elements", "Child Elements", "Predicates"}],
    Cell[20430, 708, 262, 7, 16, "IndexSubentry",
      CellTags->{
      "HTML", "Notebook", "XML", "Notebook to HTML", "Transforming XML"}],
    Cell[21079, 728, 285, 9, 16, "Index",
      CellTags->{
      "Exporting XML", "Export", "SymbolicXML", "XML and Mathematica", "XML", 
        "Export File Formats"}],
    Cell[21573, 748, 271, 9, 16, "IndexSubentry",
      CellTags->{
      "Export", "ExportString", "Exporting XML", "XML and Mathematica", 
        "SymbolicXML", "XML"}],
    Cell[22944, 791, 254, 7, 16, "Index",
      CellTags->{
      "NotebookML:Introduction", "XML and Mathematica", "NotebookML", "XML"}],
    
    Cell[23201, 800, 298, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "XML and Mathematica", "XML", 
        "NotebookML Elements", "NotebookML Attributes"}]},
  "Native XML Formats"->{
    Cell[2194, 67, 291, 9, 16, "IndexSubentry",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "MathML", 
        "NotebookML", "ExpressionML"}],
    Cell[2488, 78, 208, 6, 16, "Index",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "MathML"}],
    Cell[2699, 86, 219, 7, 16, "Index",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "NotebookML"}],
    Cell[2921, 95, 223, 7, 16, "Index",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "ExpressionML"}]},
  "MathML"->{
    Cell[2194, 67, 291, 9, 16, "IndexSubentry",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "MathML", 
        "NotebookML", "ExpressionML"}],
    Cell[2488, 78, 208, 6, 16, "Index",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "MathML"}],
    Cell[17882, 617, 198, 7, 16, "Index",
      CellTags->{"XHTML", "MathML"}],
    Cell[30243, 1041, 188, 6, 16, "Index",
      CellTags->{"MathML", "XML and Mathematica"}],
    Cell[30434, 1049, 219, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "MathML Syntax", "XML and Mathematica"}],
    Cell[30656, 1058, 244, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "MathML Syntax", "Presentation MathML"}],
    Cell[30903, 1067, 224, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "MathML Syntax", "Content MathML"}],
    Cell[31130, 1076, 225, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "Import", "Importing MathML"}],
    Cell[31650, 1094, 331, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Generating MathML", "BoxesToMathML", "ExpressionToMathML", 
        "BoxesToSymbolicMathML", "ExpressionToSymbolicMathML", "Export"}],
    Cell[31984, 1105, 225, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "Exporting MathML", "Export"}],
    Cell[32212, 1114, 312, 8, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options"}],
    Cell[32527, 1124, 280, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Formats"}],
    Cell[32810, 1135, 311, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Annotations", 
        "Annotations"}],
    Cell[33124, 1146, 339, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Namespace Prefixes", 
        "Namespaces"}],
    Cell[33466, 1157, 265, 7, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Symbols for MathML Elements", "MathML Elements"}]},
  "NotebookML"->{
    Cell[2194, 67, 291, 9, 16, "IndexSubentry",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "MathML", 
        "NotebookML", "ExpressionML"}],
    Cell[2699, 86, 219, 7, 16, "Index",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "NotebookML"}],
    Cell[22944, 791, 254, 7, 16, "Index",
      CellTags->{
      "NotebookML:Introduction", "XML and Mathematica", "NotebookML", "XML"}],
    
    Cell[23201, 800, 298, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "XML and Mathematica", "XML", 
        "NotebookML Elements", "NotebookML Attributes"}],
    Cell[23502, 811, 302, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "Notebook", 
        "Elements", "Cell"}],
    Cell[23807, 822, 372, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "String", 
        "Element", "List", "Number", "Symbol", "Options", "Option Elements"}],
    
    Cell[24182, 833, 375, 10, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "List Types", "String", 
        "Color Values", "Suboptions", "Number", "Symbol", "Options", 
        "NotebookML Front End Options"}],
    Cell[24560, 845, 366, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
        "CellGroupData", "OutputFormData", "TextData", "StyleData", 
        "TaggingRules", "XMLData", "XML Data", "Options", 
        "NotebookML Front End Options"}],
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}],
    Cell[25291, 863, 244, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML", "Import", "XML and Mathematica"}],
    Cell[25538, 872, 232, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML Annotations", "NotebookML"}],
    Cell[25773, 881, 217, 8, 16, "IndexSubentry",
      CellTags->{"BoxFormats", "NotebookML"}],
    Cell[25993, 891, 212, 7, 16, "IndexSubentry",
      CellTags->{"GraphicsFormats", "NotebookML"}],
    Cell[26208, 900, 247, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML Stylesheets", "NotebookML", "Stylesheets"}],
    Cell[26458, 909, 231, 7, 16, "IndexSubentry",
      CellTags->{"DTDs and Namespaces", "NotebookML"}],
    Cell[26692, 918, 287, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", "SymbolicXML", 
        "NotebookML Conversion"}],
    Cell[26982, 929, 279, 8, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", "Preprocessing NotebookML"}],
    Cell[27264, 939, 303, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", "Postprocessing NotebookML", 
        "SymbolicXML"}],
    Cell[27570, 950, 291, 8, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", "NotebookML Conversion Rules"}],
    Cell[27864, 960, 245, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML", "Exporting NotebookML", "Export"}],
    Cell[28112, 969, 309, 8, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Exporting NotebookML", "ExportString", "Export"}],
    Cell[28424, 979, 336, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Export Conversion Options", 
        "Export Conversion Options"}],
    Cell[28763, 990, 335, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Annotations", "Annotations", 
        "NotebookML Export Conversion Options", "Export Conversion Options"}],
    
    Cell[29101, 1001, 288, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "BoxFormats", "NotebookML Export Conversion Options", 
        "Export Conversion Options"}],
    Cell[29392, 1012, 308, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "GraphicsFormats", "NotebookML Export Conversion Options",
         "Export Conversion Options"}],
    Cell[29703, 1023, 258, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML", "Stylesheets", "NotebookML Stylesheets"}],
    Cell[29964, 1032, 276, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML", "Displaying NotebookML using CSS", "CSS"}]},
  "ExpressionML"->{
    Cell[2194, 67, 291, 9, 16, "IndexSubentry",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "MathML", 
        "NotebookML", "ExpressionML"}],
    Cell[2921, 95, 223, 7, 16, "Index",
      CellTags->{
      "Native XML Formats", "XML and Mathematica", "XML", "ExpressionML"}]},
  "Importing XML"->{
    Cell[3147, 104, 233, 6, 16, "Index",
      CellTags->{"Importing XML", "Import", "XML and Mathematica", "XML"}],
    Cell[3383, 112, 211, 6, 16, "Index",
      CellTags->{"Importing XML", "Import", "XML Import"}],
    Cell[3597, 120, 195, 6, 16, "IndexSubentry",
      CellTags->{"Importing XML", "XML Import", "Import"}],
    Cell[3795, 128, 331, 10, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Defaults", "Overriding Defaults", "XML Import", 
        "XML Import Defaults", "Import"}],
    Cell[4129, 140, 279, 8, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Import File Extensions", "File Extensions", 
        "Extensions", "Import"}],
    Cell[4411, 150, 218, 7, 16, "IndexSubentry",
      CellTags->{"Import", "ImportString", "Importing XML"}],
    Cell[4632, 159, 286, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "ImportString", "Defaults", "XML ImportString Defaults", 
        "Importing XML"}],
    Cell[4921, 170, 371, 10, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Defaults", "Overriding Defaults", 
        "Overriding Defaults", "XML Import", "XML ImportString Defaults", 
        "Import"}],
    Cell[5295, 182, 194, 7, 16, "IndexSubentry",
      CellTags->{"Importing XML", "XMLGet"}],
    Cell[5492, 191, 331, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XMLGet", "XMLGet Conversion Options", 
        "ImportConversionOptions", "ConversionOptions"}],
    Cell[5826, 202, 244, 7, 16, "IndexSubentry",
      CellTags->{"Import", "ImportString", "XMLGetString", "Importing XML"}],
    Cell[6073, 211, 366, 10, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XMLGetString", 
        "XMLGetString Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[6442, 223, 415, 14, 16, "Index",
      CellTags->{
      "Importing XML", "Import", "XMLGet", "XMLGetString", "URL", 
        "Import from URL", "Importing over HTTP", "XML Import", 
        "Import from Website"}],
    Cell[6860, 239, 336, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XML Conversion Options", 
        "Import Conversion Options", "Conversion Options", "Options"}],
    Cell[7199, 250, 310, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "ImportString", "Importing XML", "Entities and Validation", 
        "Unicode", "Entities", "Validation"}],
    Cell[8378, 287, 371, 9, 16, "IndexSubentry",
      CellTags->{
      "XMLGet", "URL", "Import from URL", "Importing over HTTP", "XML Import",
         "Import from Website", "InitializeXMLParser", "Importing XML", 
        "Entities and Validation"}]},
  "Import"->{
    Cell[3147, 104, 233, 6, 16, "Index",
      CellTags->{"Importing XML", "Import", "XML and Mathematica", "XML"}],
    Cell[3383, 112, 211, 6, 16, "Index",
      CellTags->{"Importing XML", "Import", "XML Import"}],
    Cell[3597, 120, 195, 6, 16, "IndexSubentry",
      CellTags->{"Importing XML", "XML Import", "Import"}],
    Cell[3795, 128, 331, 10, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Defaults", "Overriding Defaults", "XML Import", 
        "XML Import Defaults", "Import"}],
    Cell[4129, 140, 279, 8, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Import File Extensions", "File Extensions", 
        "Extensions", "Import"}],
    Cell[4411, 150, 218, 7, 16, "IndexSubentry",
      CellTags->{"Import", "ImportString", "Importing XML"}],
    Cell[4632, 159, 286, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "ImportString", "Defaults", "XML ImportString Defaults", 
        "Importing XML"}],
    Cell[4921, 170, 371, 10, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Defaults", "Overriding Defaults", 
        "Overriding Defaults", "XML Import", "XML ImportString Defaults", 
        "Import"}],
    Cell[5492, 191, 331, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XMLGet", "XMLGet Conversion Options", 
        "ImportConversionOptions", "ConversionOptions"}],
    Cell[5826, 202, 244, 7, 16, "IndexSubentry",
      CellTags->{"Import", "ImportString", "XMLGetString", "Importing XML"}],
    Cell[6073, 211, 366, 10, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XMLGetString", 
        "XMLGetString Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[6442, 223, 415, 14, 16, "Index",
      CellTags->{
      "Importing XML", "Import", "XMLGet", "XMLGetString", "URL", 
        "Import from URL", "Importing over HTTP", "XML Import", 
        "Import from Website"}],
    Cell[6860, 239, 336, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XML Conversion Options", 
        "Import Conversion Options", "Conversion Options", "Options"}],
    Cell[7199, 250, 310, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "ImportString", "Importing XML", "Entities and Validation", 
        "Unicode", "Entities", "Validation"}],
    Cell[7512, 261, 434, 11, 16, "IndexSubentry",
      CellTags->{
      "Entities", "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[7949, 274, 426, 11, 16, "IndexSubentry",
      CellTags->{
      "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[25291, 863, 244, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML", "Import", "XML and Mathematica"}],
    Cell[31130, 1076, 225, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "Import", "Importing MathML"}]},
  "XML Import"->{
    Cell[3383, 112, 211, 6, 16, "Index",
      CellTags->{"Importing XML", "Import", "XML Import"}],
    Cell[3597, 120, 195, 6, 16, "IndexSubentry",
      CellTags->{"Importing XML", "XML Import", "Import"}],
    Cell[3795, 128, 331, 10, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Defaults", "Overriding Defaults", "XML Import", 
        "XML Import Defaults", "Import"}],
    Cell[4921, 170, 371, 10, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Defaults", "Overriding Defaults", 
        "Overriding Defaults", "XML Import", "XML ImportString Defaults", 
        "Import"}],
    Cell[6442, 223, 415, 14, 16, "Index",
      CellTags->{
      "Importing XML", "Import", "XMLGet", "XMLGetString", "URL", 
        "Import from URL", "Importing over HTTP", "XML Import", 
        "Import from Website"}],
    Cell[8378, 287, 371, 9, 16, "IndexSubentry",
      CellTags->{
      "XMLGet", "URL", "Import from URL", "Importing over HTTP", "XML Import",
         "Import from Website", "InitializeXMLParser", "Importing XML", 
        "Entities and Validation"}]},
  "Defaults"->{
    Cell[3795, 128, 331, 10, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Defaults", "Overriding Defaults", "XML Import", 
        "XML Import Defaults", "Import"}],
    Cell[4632, 159, 286, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "ImportString", "Defaults", "XML ImportString Defaults", 
        "Importing XML"}],
    Cell[4921, 170, 371, 10, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Defaults", "Overriding Defaults", 
        "Overriding Defaults", "XML Import", "XML ImportString Defaults", 
        "Import"}]},
  "Overriding Defaults"->{
    Cell[3795, 128, 331, 10, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Defaults", "Overriding Defaults", "XML Import", 
        "XML Import Defaults", "Import"}],
    Cell[4921, 170, 371, 10, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Defaults", "Overriding Defaults", 
        "Overriding Defaults", "XML Import", "XML ImportString Defaults", 
        "Import"}],
    Cell[4921, 170, 371, 10, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Defaults", "Overriding Defaults", 
        "Overriding Defaults", "XML Import", "XML ImportString Defaults", 
        "Import"}]},
  "XML Import Defaults"->{
    Cell[3795, 128, 331, 10, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Defaults", "Overriding Defaults", "XML Import", 
        "XML Import Defaults", "Import"}]},
  "Import File Extensions"->{
    Cell[4129, 140, 279, 8, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Import File Extensions", "File Extensions", 
        "Extensions", "Import"}]},
  "File Extensions"->{
    Cell[4129, 140, 279, 8, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Import File Extensions", "File Extensions", 
        "Extensions", "Import"}]},
  "Extensions"->{
    Cell[4129, 140, 279, 8, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Import File Extensions", "File Extensions", 
        "Extensions", "Import"}]},
  "ImportString"->{
    Cell[4411, 150, 218, 7, 16, "IndexSubentry",
      CellTags->{"Import", "ImportString", "Importing XML"}],
    Cell[4632, 159, 286, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "ImportString", "Defaults", "XML ImportString Defaults", 
        "Importing XML"}],
    Cell[5826, 202, 244, 7, 16, "IndexSubentry",
      CellTags->{"Import", "ImportString", "XMLGetString", "Importing XML"}],
    Cell[7199, 250, 310, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "ImportString", "Importing XML", "Entities and Validation", 
        "Unicode", "Entities", "Validation"}]},
  "XML ImportString Defaults"->{
    Cell[4632, 159, 286, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "ImportString", "Defaults", "XML ImportString Defaults", 
        "Importing XML"}],
    Cell[4921, 170, 371, 10, 16, "IndexSubentry",
      CellTags->{
      "Importing XML", "Defaults", "Overriding Defaults", 
        "Overriding Defaults", "XML Import", "XML ImportString Defaults", 
        "Import"}]},
  "XMLGet"->{
    Cell[5295, 182, 194, 7, 16, "IndexSubentry",
      CellTags->{"Importing XML", "XMLGet"}],
    Cell[5492, 191, 331, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XMLGet", "XMLGet Conversion Options", 
        "ImportConversionOptions", "ConversionOptions"}],
    Cell[6442, 223, 415, 14, 16, "Index",
      CellTags->{
      "Importing XML", "Import", "XMLGet", "XMLGetString", "URL", 
        "Import from URL", "Importing over HTTP", "XML Import", 
        "Import from Website"}],
    Cell[8378, 287, 371, 9, 16, "IndexSubentry",
      CellTags->{
      "XMLGet", "URL", "Import from URL", "Importing over HTTP", "XML Import",
         "Import from Website", "InitializeXMLParser", "Importing XML", 
        "Entities and Validation"}],
    Cell[16391, 569, 212, 5, 15, "IndexSubentry",
      CellTags->{
      "XML`Parser", "XML and Mathematica", "XML", "XMLGet", "XMLGetString", 
        "Context"}]},
  "XMLGet Conversion Options"->{
    Cell[5492, 191, 331, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XMLGet", "XMLGet Conversion Options", 
        "ImportConversionOptions", "ConversionOptions"}],
    Cell[7512, 261, 434, 11, 16, "IndexSubentry",
      CellTags->{
      "Entities", "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[7949, 274, 426, 11, 16, "IndexSubentry",
      CellTags->{
      "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[14347, 499, 304, 9, 16, "Index",
      CellTags->{
      "SymbolicXML", "XMLGet Conversion Options", "Conversion Options", 
        "Import Conversion Options", "XMLObject"}]},
  "ImportConversionOptions"->{
    Cell[5492, 191, 331, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XMLGet", "XMLGet Conversion Options", 
        "ImportConversionOptions", "ConversionOptions"}],
    Cell[6073, 211, 366, 10, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XMLGetString", 
        "XMLGetString Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[7512, 261, 434, 11, 16, "IndexSubentry",
      CellTags->{
      "Entities", "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[7949, 274, 426, 11, 16, "IndexSubentry",
      CellTags->{
      "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}]},
  "ConversionOptions"->{
    Cell[5492, 191, 331, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XMLGet", "XMLGet Conversion Options", 
        "ImportConversionOptions", "ConversionOptions"}],
    Cell[6073, 211, 366, 10, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XMLGetString", 
        "XMLGetString Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[7512, 261, 434, 11, 16, "IndexSubentry",
      CellTags->{
      "Entities", "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[7949, 274, 426, 11, 16, "IndexSubentry",
      CellTags->{
      "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}]},
  "XMLGetString"->{
    Cell[5826, 202, 244, 7, 16, "IndexSubentry",
      CellTags->{"Import", "ImportString", "XMLGetString", "Importing XML"}],
    Cell[6073, 211, 366, 10, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XMLGetString", 
        "XMLGetString Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[6442, 223, 415, 14, 16, "Index",
      CellTags->{
      "Importing XML", "Import", "XMLGet", "XMLGetString", "URL", 
        "Import from URL", "Importing over HTTP", "XML Import", 
        "Import from Website"}],
    Cell[16391, 569, 212, 5, 15, "IndexSubentry",
      CellTags->{
      "XML`Parser", "XML and Mathematica", "XML", "XMLGet", "XMLGetString", 
        "Context"}]},
  "XMLGetString Conversion Options"->{
    Cell[6073, 211, 366, 10, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XMLGetString", 
        "XMLGetString Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}]},
  "URL"->{
    Cell[6442, 223, 415, 14, 16, "Index",
      CellTags->{
      "Importing XML", "Import", "XMLGet", "XMLGetString", "URL", 
        "Import from URL", "Importing over HTTP", "XML Import", 
        "Import from Website"}],
    Cell[8378, 287, 371, 9, 16, "IndexSubentry",
      CellTags->{
      "XMLGet", "URL", "Import from URL", "Importing over HTTP", "XML Import",
         "Import from Website", "InitializeXMLParser", "Importing XML", 
        "Entities and Validation"}]},
  "Import from URL"->{
    Cell[6442, 223, 415, 14, 16, "Index",
      CellTags->{
      "Importing XML", "Import", "XMLGet", "XMLGetString", "URL", 
        "Import from URL", "Importing over HTTP", "XML Import", 
        "Import from Website"}],
    Cell[8378, 287, 371, 9, 16, "IndexSubentry",
      CellTags->{
      "XMLGet", "URL", "Import from URL", "Importing over HTTP", "XML Import",
         "Import from Website", "InitializeXMLParser", "Importing XML", 
        "Entities and Validation"}]},
  "Importing over HTTP"->{
    Cell[6442, 223, 415, 14, 16, "Index",
      CellTags->{
      "Importing XML", "Import", "XMLGet", "XMLGetString", "URL", 
        "Import from URL", "Importing over HTTP", "XML Import", 
        "Import from Website"}],
    Cell[8378, 287, 371, 9, 16, "IndexSubentry",
      CellTags->{
      "XMLGet", "URL", "Import from URL", "Importing over HTTP", "XML Import",
         "Import from Website", "InitializeXMLParser", "Importing XML", 
        "Entities and Validation"}]},
  "Import from Website"->{
    Cell[6442, 223, 415, 14, 16, "Index",
      CellTags->{
      "Importing XML", "Import", "XMLGet", "XMLGetString", "URL", 
        "Import from URL", "Importing over HTTP", "XML Import", 
        "Import from Website"}],
    Cell[8378, 287, 371, 9, 16, "IndexSubentry",
      CellTags->{
      "XMLGet", "URL", "Import from URL", "Importing over HTTP", "XML Import",
         "Import from Website", "InitializeXMLParser", "Importing XML", 
        "Entities and Validation"}]},
  "XML Conversion Options"->{
    Cell[6860, 239, 336, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XML Conversion Options", 
        "Import Conversion Options", "Conversion Options", "Options"}]},
  "Import Conversion Options"->{
    Cell[6860, 239, 336, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XML Conversion Options", 
        "Import Conversion Options", "Conversion Options", "Options"}],
    Cell[7512, 261, 434, 11, 16, "IndexSubentry",
      CellTags->{
      "Entities", "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[7949, 274, 426, 11, 16, "IndexSubentry",
      CellTags->{
      "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[14347, 499, 304, 9, 16, "Index",
      CellTags->{
      "SymbolicXML", "XMLGet Conversion Options", "Conversion Options", 
        "Import Conversion Options", "XMLObject"}],
    Cell[33734, 1166, 244, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "NormalizeWhitespace", 
        "Import Conversion Options", "Whitespace"}],
    Cell[33981, 1173, 261, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "Import Conversion Options", 
        "AllowRemoteDTDAccess", "Remote DTD Access", "DTD"}],
    Cell[34245, 1180, 285, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "AllowUnrecognizedEntities", 
        "Entities", "Unrecognized Entities", "Import Conversion Options"}],
    Cell[34757, 1194, 274, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "Import Conversion Options", 
        "ValidateAgainstDTD", "DTD", "Validation", "DOCTYPE", "Declaration"}],
    
    Cell[35034, 1201, 251, 5, 15, "Index",
      CellTags->{
      "IncludeDefaultedAttributes", "XML Import Conversion Options", 
        "Import Conversion Options"}],
    Cell[35288, 1208, 334, 6, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeEmbeddedObjects", "Comments", 
        "Processing Instructions", "Embedded Objects", "Objects", 
        "Import Conversion Options", "Pattern Matching"}],
    Cell[35625, 1216, 280, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeNamespaces", "Namespaces", 
        "Scoping", "Import Conversion Options", 
        "Non-compliant XML documents"}],
    Cell[35908, 1223, 236, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "PreserveCDATASections", 
        "Import Conversion Options"}]},
  "Conversion Options"->{
    Cell[6860, 239, 336, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XML Conversion Options", 
        "Import Conversion Options", "Conversion Options", "Options"}],
    Cell[7512, 261, 434, 11, 16, "IndexSubentry",
      CellTags->{
      "Entities", "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[7949, 274, 426, 11, 16, "IndexSubentry",
      CellTags->{
      "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[14347, 499, 304, 9, 16, "Index",
      CellTags->{
      "SymbolicXML", "XMLGet Conversion Options", "Conversion Options", 
        "Import Conversion Options", "XMLObject"}]},
  "Options"->{
    Cell[6860, 239, 336, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "Importing XML", "XML Conversion Options", 
        "Import Conversion Options", "Conversion Options", "Options"}],
    Cell[7512, 261, 434, 11, 16, "IndexSubentry",
      CellTags->{
      "Entities", "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[7949, 274, 426, 11, 16, "IndexSubentry",
      CellTags->{
      "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[23807, 822, 372, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "String", 
        "Element", "List", "Number", "Symbol", "Options", "Option Elements"}],
    
    Cell[24182, 833, 375, 10, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "List Types", "String", 
        "Color Values", "Suboptions", "Number", "Symbol", "Options", 
        "NotebookML Front End Options"}],
    Cell[24560, 845, 366, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
        "CellGroupData", "OutputFormData", "TextData", "StyleData", 
        "TaggingRules", "XMLData", "XML Data", "Options", 
        "NotebookML Front End Options"}]},
  "Entities and Validation"->{
    Cell[7199, 250, 310, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "ImportString", "Importing XML", "Entities and Validation", 
        "Unicode", "Entities", "Validation"}],
    Cell[7512, 261, 434, 11, 16, "IndexSubentry",
      CellTags->{
      "Entities", "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[7949, 274, 426, 11, 16, "IndexSubentry",
      CellTags->{
      "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[8378, 287, 371, 9, 16, "IndexSubentry",
      CellTags->{
      "XMLGet", "URL", "Import from URL", "Importing over HTTP", "XML Import",
         "Import from Website", "InitializeXMLParser", "Importing XML", 
        "Entities and Validation"}]},
  "Unicode"->{
    Cell[7199, 250, 310, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "ImportString", "Importing XML", "Entities and Validation", 
        "Unicode", "Entities", "Validation"}]},
  "Entities"->{
    Cell[7199, 250, 310, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "ImportString", "Importing XML", "Entities and Validation", 
        "Unicode", "Entities", "Validation"}],
    Cell[7512, 261, 434, 11, 16, "IndexSubentry",
      CellTags->{
      "Entities", "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[22541, 779, 192, 4, 15, "Index",
      CellTags->{
      "Entities", "Export", "Exporting XML", 
        "XML Export Conversion Options"}],
    Cell[34245, 1180, 285, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "AllowUnrecognizedEntities", 
        "Entities", "Unrecognized Entities", "Import Conversion Options"}]},
  "Validation"->{
    Cell[7199, 250, 310, 9, 16, "IndexSubentry",
      CellTags->{
      "Import", "ImportString", "Importing XML", "Entities and Validation", 
        "Unicode", "Entities", "Validation"}],
    Cell[7512, 261, 434, 11, 16, "IndexSubentry",
      CellTags->{
      "Entities", "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[7949, 274, 426, 11, 16, "IndexSubentry",
      CellTags->{
      "Validation", "Entities and Validation", "Import", 
        "Import Conversion Options", "Options", "Conversion Options", 
        "XMLGet Conversion Options", "ImportConversionOptions", 
        "ConversionOptions"}],
    Cell[34533, 1187, 221, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "ReadDTD", "DTD", "External DTD", 
        "Validation", "External Subset"}],
    Cell[34757, 1194, 274, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "Import Conversion Options", 
        "ValidateAgainstDTD", "DTD", "Validation", "DOCTYPE", 
        "Declaration"}]},
  "InitializeXMLParser"->{
    Cell[8378, 287, 371, 9, 16, "IndexSubentry",
      CellTags->{
      "XMLGet", "URL", "Import from URL", "Importing over HTTP", "XML Import",
         "Import from Website", "InitializeXMLParser", "Importing XML", 
        "Entities and Validation"}]},
  "SymbolicXML"->{
    Cell[8752, 298, 215, 6, 16, "Index",
      CellTags->{"SymbolicXML", "XML and Mathematica", "XML"}],
    Cell[8970, 306, 249, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "SymbolicXML Syntax", "XML and Mathematica", "XML"}],
    Cell[9222, 316, 306, 10, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "J/Link", "SymbolicXML and J/Link"}],
    Cell[9531, 328, 256, 7, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Tree Structure", "XML and Mathematica", "XML"}],
    Cell[9790, 337, 227, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XSLT", "SymbolicXML and XSLT", "XSLT"}],
    Cell[10020, 346, 219, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "SymbolicXML and Java", "Java"}],
    Cell[10242, 355, 215, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "SymbolicXML and SAX", "SAX"}],
    Cell[10460, 364, 231, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "SymbolicXML and DOM API", "DOM API"}],
    Cell[10694, 373, 231, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "Pattern Matching"}],
    Cell[10928, 382, 243, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "SymbolicXML Workflow", "Workflow"}],
    Cell[11174, 391, 283, 9, 16, "Index",
      CellTags->{
      "SymbolicXML", "SymbolicXML Syntax", "Element", "XMLElement", 
        "XML and Mathematica", "XML"}],
    Cell[11460, 402, 318, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XML and Mathematica", "XML", "Element", "XMLElement", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[11781, 413, 313, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Element", "XMLElement Argument", "Argument", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[12097, 424, 333, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "XML Child Elements", "Child Elements", 
        "Element", "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[12433, 435, 324, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "Element", "SymbolicXML Syntax", 
        "XMLElement Commands", "Nesting Commands"}],
    Cell[12760, 446, 304, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "XMLElement Names", "Names", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[13067, 457, 319, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement Namespaces", "XMLElement", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[13389, 468, 354, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Default Namespaces", "XMLElement", "Namespace Prefixes",
         "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[13746, 479, 357, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Explicit Namespaces", "XMLElement", 
        "Namespace Prefixes", "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[14106, 490, 238, 7, 16, "Index",
      CellTags->{"SymbolicXML", "XML and Mathematica", "XML", "XMLObject"}],
    Cell[14347, 499, 304, 9, 16, "Index",
      CellTags->{
      "SymbolicXML", "XMLGet Conversion Options", "Conversion Options", 
        "Import Conversion Options", "XMLObject"}],
    Cell[14654, 510, 311, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XML and Mathematica", "XML", "XMLObject", 
        "SymbolicXML Syntax", "XMLObject Syntax"}],
    Cell[14968, 521, 263, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "Declaration", "XML Declaration", 
        "Declaration Options"}],
    Cell[15730, 545, 216, 6, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XMLObject", "Comment", "XML Comment"}],
    Cell[15949, 553, 220, 6, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XMLObject", "Document", "XML Document"}],
    Cell[16172, 561, 216, 6, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XMLObject", "DOCTYPE", "XML DOCTYPE"}],
    Cell[17312, 597, 284, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "Procession Instruction", 
        "XML Processing Instruction"}],
    Cell[17599, 607, 280, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "CDATA", "Character Data", 
        "XML CDATASection", "PreserveCDATASections"}],
    Cell[18483, 641, 304, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Representing Other Objects", "XML Constructs", 
        "XML and Mathematica", "XML"}],
    Cell[18790, 652, 279, 9, 16, "Index",
      CellTags->{
      "Transforming XML", "XML and Mathematica", "SymbolicXML", 
        "Processing XML Data"}],
    Cell[19072, 663, 324, 9, 16, "IndexSubentry",
      CellTags->{
      "Visualizing the XML Tree", "Transforming XML", "XML and Mathematica", 
        "XML", "Tree Structure", "Notebook", "SymbolicXML"}],
    Cell[20695, 717, 381, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXMLErrors", "Errors", "XML Errors", "SymbolicXML", 
        "SymbolicXML Syntax", "Verifying SymbolicXML Syntax", 
        "Transforming XML", "Part", "Extract"}],
    Cell[21079, 728, 285, 9, 16, "Index",
      CellTags->{
      "Exporting XML", "Export", "SymbolicXML", "XML and Mathematica", "XML", 
        "Export File Formats"}],
    Cell[21573, 748, 271, 9, 16, "IndexSubentry",
      CellTags->{
      "Export", "ExportString", "Exporting XML", "XML and Mathematica", 
        "SymbolicXML", "XML"}],
    Cell[26692, 918, 287, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", "SymbolicXML", 
        "NotebookML Conversion"}],
    Cell[27264, 939, 303, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", "Postprocessing NotebookML", 
        "SymbolicXML"}],
    Cell[36830, 1251, 193, 4, 15, "Index",
      CellTags->{
      "SymbolicXMLErrors", "Transforming XML", "XML Errors", "SymbolicXML", 
        "XML Functions"}]},
  "SymbolicXML Syntax"->{
    Cell[8970, 306, 249, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "SymbolicXML Syntax", "XML and Mathematica", "XML"}],
    Cell[11174, 391, 283, 9, 16, "Index",
      CellTags->{
      "SymbolicXML", "SymbolicXML Syntax", "Element", "XMLElement", 
        "XML and Mathematica", "XML"}],
    Cell[11460, 402, 318, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XML and Mathematica", "XML", "Element", "XMLElement", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[11781, 413, 313, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Element", "XMLElement Argument", "Argument", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[12097, 424, 333, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "XML Child Elements", "Child Elements", 
        "Element", "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[12433, 435, 324, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "Element", "SymbolicXML Syntax", 
        "XMLElement Commands", "Nesting Commands"}],
    Cell[12760, 446, 304, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "XMLElement Names", "Names", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[13067, 457, 319, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement Namespaces", "XMLElement", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[13389, 468, 354, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Default Namespaces", "XMLElement", "Namespace Prefixes",
         "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[13746, 479, 357, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Explicit Namespaces", "XMLElement", 
        "Namespace Prefixes", "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[14654, 510, 311, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XML and Mathematica", "XML", "XMLObject", 
        "SymbolicXML Syntax", "XMLObject Syntax"}],
    Cell[15234, 531, 247, 5, 15, "IndexSubentry",
      CellTags->{
      "Standalone", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
        "Declaration Options", "XMLObject Syntax"}],
    Cell[15484, 538, 243, 5, 15, "IndexSubentry",
      CellTags->{
      "Encoding", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
        "Declaration Options", "XMLObject Syntax"}],
    Cell[16606, 576, 231, 5, 15, "IndexSubentry",
      CellTags->{
      "System", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}],
    Cell[16840, 583, 231, 5, 15, "IndexSubentry",
      CellTags->{
      "Public", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}],
    Cell[17074, 590, 235, 5, 15, "IndexSubentry",
      CellTags->{
      "Internal", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}],
    Cell[20695, 717, 381, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXMLErrors", "Errors", "XML Errors", "SymbolicXML", 
        "SymbolicXML Syntax", "Verifying SymbolicXML Syntax", 
        "Transforming XML", "Part", "Extract"}]},
  "J/Link"->{
    Cell[9222, 316, 306, 10, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "J/Link", "SymbolicXML and J/Link"}]},
  "SymbolicXML and J/Link"->{
    Cell[9222, 316, 306, 10, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "J/Link", "SymbolicXML and J/Link"}]},
  "Tree Structure"->{
    Cell[9531, 328, 256, 7, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Tree Structure", "XML and Mathematica", "XML"}],
    Cell[19072, 663, 324, 9, 16, "IndexSubentry",
      CellTags->{
      "Visualizing the XML Tree", "Transforming XML", "XML and Mathematica", 
        "XML", "Tree Structure", "Notebook", "SymbolicXML"}]},
  "XSLT"->{
    Cell[9790, 337, 227, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XSLT", "SymbolicXML and XSLT", "XSLT"}],
    Cell[9790, 337, 227, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XSLT", "SymbolicXML and XSLT", "XSLT"}],
    Cell[20026, 696, 401, 10, 16, "IndexSubentry",
      CellTags->{
      "XSLT", "XSLT and Mathematica", "Transforming XML", 
        "XML and Mathematica", "Converting", "XML", "Ancestor Elements", 
        "Elements", "Sibling Elements", "Child Elements", "Predicates"}]},
  "SymbolicXML and XSLT"->{
    Cell[9790, 337, 227, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XSLT", "SymbolicXML and XSLT", "XSLT"}]},
  "SymbolicXML and Java"->{
    Cell[10020, 346, 219, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "SymbolicXML and Java", "Java"}]},
  "Java"->{
    Cell[10020, 346, 219, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "SymbolicXML and Java", "Java"}]},
  "SymbolicXML and SAX"->{
    Cell[10242, 355, 215, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "SymbolicXML and SAX", "SAX"}]},
  "SAX"->{
    Cell[10242, 355, 215, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "SymbolicXML and SAX", "SAX"}]},
  "SymbolicXML and DOM API"->{
    Cell[10460, 364, 231, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "SymbolicXML and DOM API", "DOM API"}]},
  "DOM API"->{
    Cell[10460, 364, 231, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "SymbolicXML and DOM API", "DOM API"}]},
  "Pattern Matching"->{
    Cell[10694, 373, 231, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "Pattern Matching"}],
    Cell[19399, 674, 329, 9, 16, "IndexSubentry",
      CellTags->{
      "Manipulating Data", "Manipulating XML Data", "Transforming XML", 
        "XML and Mathematica", "XML Data", "Pattern Matching"}],
    Cell[35288, 1208, 334, 6, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeEmbeddedObjects", "Comments", 
        "Processing Instructions", "Embedded Objects", "Objects", 
        "Import Conversion Options", "Pattern Matching"}]},
  "SymbolicXML Workflow"->{
    Cell[10928, 382, 243, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "SymbolicXML Workflow", "Workflow"}]},
  "Workflow"->{
    Cell[10928, 382, 243, 7, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "SymbolicXML Workflow", "Workflow"}]},
  "Element"->{
    Cell[11174, 391, 283, 9, 16, "Index",
      CellTags->{
      "SymbolicXML", "SymbolicXML Syntax", "Element", "XMLElement", 
        "XML and Mathematica", "XML"}],
    Cell[11460, 402, 318, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XML and Mathematica", "XML", "Element", "XMLElement", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[11781, 413, 313, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Element", "XMLElement Argument", "Argument", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[12097, 424, 333, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "XML Child Elements", "Child Elements", 
        "Element", "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[12433, 435, 324, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "Element", "SymbolicXML Syntax", 
        "XMLElement Commands", "Nesting Commands"}],
    Cell[22339, 774, 199, 3, 15, "Index",
      CellTags->{
      "ElementFormatting", "Element Formatting", "Element", "Export"}],
    Cell[23807, 822, 372, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "String", 
        "Element", "List", "Number", "Symbol", "Options", 
        "Option Elements"}]},
  "XMLElement"->{
    Cell[11174, 391, 283, 9, 16, "Index",
      CellTags->{
      "SymbolicXML", "SymbolicXML Syntax", "Element", "XMLElement", 
        "XML and Mathematica", "XML"}],
    Cell[11460, 402, 318, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XML and Mathematica", "XML", "Element", "XMLElement", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[12097, 424, 333, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "XML Child Elements", "Child Elements", 
        "Element", "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[12433, 435, 324, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "Element", "SymbolicXML Syntax", 
        "XMLElement Commands", "Nesting Commands"}],
    Cell[12760, 446, 304, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "XMLElement Names", "Names", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[13067, 457, 319, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement Namespaces", "XMLElement", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[13389, 468, 354, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Default Namespaces", "XMLElement", "Namespace Prefixes",
         "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[13746, 479, 357, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Explicit Namespaces", "XMLElement", 
        "Namespace Prefixes", "SymbolicXML Syntax", "XMLElement Syntax"}]},
  "XMLElement Syntax"->{
    Cell[11460, 402, 318, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XML and Mathematica", "XML", "Element", "XMLElement", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[11781, 413, 313, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Element", "XMLElement Argument", "Argument", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[12097, 424, 333, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "XML Child Elements", "Child Elements", 
        "Element", "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[12760, 446, 304, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "XMLElement Names", "Names", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[13067, 457, 319, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement Namespaces", "XMLElement", 
        "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[13389, 468, 354, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Default Namespaces", "XMLElement", "Namespace Prefixes",
         "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[13746, 479, 357, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Explicit Namespaces", "XMLElement", 
        "Namespace Prefixes", "SymbolicXML Syntax", "XMLElement Syntax"}]},
  "XMLElement Argument"->{
    Cell[11781, 413, 313, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Element", "XMLElement Argument", "Argument", 
        "SymbolicXML Syntax", "XMLElement Syntax"}]},
  "Argument"->{
    Cell[11781, 413, 313, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Element", "XMLElement Argument", "Argument", 
        "SymbolicXML Syntax", "XMLElement Syntax"}]},
  "XML Child Elements"->{
    Cell[12097, 424, 333, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "XML Child Elements", "Child Elements", 
        "Element", "SymbolicXML Syntax", "XMLElement Syntax"}]},
  "Child Elements"->{
    Cell[12097, 424, 333, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "XML Child Elements", "Child Elements", 
        "Element", "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[20026, 696, 401, 10, 16, "IndexSubentry",
      CellTags->{
      "XSLT", "XSLT and Mathematica", "Transforming XML", 
        "XML and Mathematica", "Converting", "XML", "Ancestor Elements", 
        "Elements", "Sibling Elements", "Child Elements", "Predicates"}]},
  "XMLElement Commands"->{
    Cell[12433, 435, 324, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "Element", "SymbolicXML Syntax", 
        "XMLElement Commands", "Nesting Commands"}]},
  "Nesting Commands"->{
    Cell[12433, 435, 324, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "Element", "SymbolicXML Syntax", 
        "XMLElement Commands", "Nesting Commands"}]},
  "XMLElement Names"->{
    Cell[12760, 446, 304, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "XMLElement Names", "Names", 
        "SymbolicXML Syntax", "XMLElement Syntax"}]},
  "Names"->{
    Cell[12760, 446, 304, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement", "XMLElement Names", "Names", 
        "SymbolicXML Syntax", "XMLElement Syntax"}]},
  "XMLElement Namespaces"->{
    Cell[13067, 457, 319, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLElement Namespaces", "XMLElement", 
        "SymbolicXML Syntax", "XMLElement Syntax"}]},
  "Default Namespaces"->{
    Cell[13389, 468, 354, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Default Namespaces", "XMLElement", "Namespace Prefixes",
         "SymbolicXML Syntax", "XMLElement Syntax"}]},
  "Namespace Prefixes"->{
    Cell[13389, 468, 354, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Default Namespaces", "XMLElement", "Namespace Prefixes",
         "SymbolicXML Syntax", "XMLElement Syntax"}],
    Cell[13746, 479, 357, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Explicit Namespaces", "XMLElement", 
        "Namespace Prefixes", "SymbolicXML Syntax", "XMLElement Syntax"}]},
  "Explicit Namespaces"->{
    Cell[13746, 479, 357, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Explicit Namespaces", "XMLElement", 
        "Namespace Prefixes", "SymbolicXML Syntax", "XMLElement Syntax"}]},
  "XMLObject"->{
    Cell[14106, 490, 238, 7, 16, "Index",
      CellTags->{"SymbolicXML", "XML and Mathematica", "XML", "XMLObject"}],
    Cell[14347, 499, 304, 9, 16, "Index",
      CellTags->{
      "SymbolicXML", "XMLGet Conversion Options", "Conversion Options", 
        "Import Conversion Options", "XMLObject"}],
    Cell[14654, 510, 311, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XML and Mathematica", "XML", "XMLObject", 
        "SymbolicXML Syntax", "XMLObject Syntax"}],
    Cell[14968, 521, 263, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "Declaration", "XML Declaration", 
        "Declaration Options"}],
    Cell[15234, 531, 247, 5, 15, "IndexSubentry",
      CellTags->{
      "Standalone", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
        "Declaration Options", "XMLObject Syntax"}],
    Cell[15484, 538, 243, 5, 15, "IndexSubentry",
      CellTags->{
      "Encoding", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
        "Declaration Options", "XMLObject Syntax"}],
    Cell[15730, 545, 216, 6, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XMLObject", "Comment", "XML Comment"}],
    Cell[15949, 553, 220, 6, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XMLObject", "Document", "XML Document"}],
    Cell[16172, 561, 216, 6, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XMLObject", "DOCTYPE", "XML DOCTYPE"}],
    Cell[16606, 576, 231, 5, 15, "IndexSubentry",
      CellTags->{
      "System", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}],
    Cell[16840, 583, 231, 5, 15, "IndexSubentry",
      CellTags->{
      "Public", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}],
    Cell[17074, 590, 235, 5, 15, "IndexSubentry",
      CellTags->{
      "Internal", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}],
    Cell[17312, 597, 284, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "Procession Instruction", 
        "XML Processing Instruction"}],
    Cell[17599, 607, 280, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "CDATA", "Character Data", 
        "XML CDATASection", "PreserveCDATASections"}]},
  "XMLObject Syntax"->{
    Cell[14654, 510, 311, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XML and Mathematica", "XML", "XMLObject", 
        "SymbolicXML Syntax", "XMLObject Syntax"}],
    Cell[15234, 531, 247, 5, 15, "IndexSubentry",
      CellTags->{
      "Standalone", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
        "Declaration Options", "XMLObject Syntax"}],
    Cell[15484, 538, 243, 5, 15, "IndexSubentry",
      CellTags->{
      "Encoding", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
        "Declaration Options", "XMLObject Syntax"}],
    Cell[16606, 576, 231, 5, 15, "IndexSubentry",
      CellTags->{
      "System", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}],
    Cell[16840, 583, 231, 5, 15, "IndexSubentry",
      CellTags->{
      "Public", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}],
    Cell[17074, 590, 235, 5, 15, "IndexSubentry",
      CellTags->{
      "Internal", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}]},
  "Declaration"->{
    Cell[14968, 521, 263, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "Declaration", "XML Declaration", 
        "Declaration Options"}],
    Cell[34757, 1194, 274, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "Import Conversion Options", 
        "ValidateAgainstDTD", "DTD", "Validation", "DOCTYPE", 
        "Declaration"}]},
  "XML Declaration"->{
    Cell[14968, 521, 263, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "Declaration", "XML Declaration", 
        "Declaration Options"}],
    Cell[15234, 531, 247, 5, 15, "IndexSubentry",
      CellTags->{
      "Standalone", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
        "Declaration Options", "XMLObject Syntax"}],
    Cell[15484, 538, 243, 5, 15, "IndexSubentry",
      CellTags->{
      "Encoding", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
        "Declaration Options", "XMLObject Syntax"}]},
  "Declaration Options"->{
    Cell[14968, 521, 263, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "Declaration", "XML Declaration", 
        "Declaration Options"}],
    Cell[15234, 531, 247, 5, 15, "IndexSubentry",
      CellTags->{
      "Standalone", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
        "Declaration Options", "XMLObject Syntax"}],
    Cell[15484, 538, 243, 5, 15, "IndexSubentry",
      CellTags->{
      "Encoding", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
        "Declaration Options", "XMLObject Syntax"}]},
  "Standalone"->{
    Cell[15234, 531, 247, 5, 15, "IndexSubentry",
      CellTags->{
      "Standalone", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
        "Declaration Options", "XMLObject Syntax"}]},
  "Encoding"->{
    Cell[15484, 538, 243, 5, 15, "IndexSubentry",
      CellTags->{
      "Encoding", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
        "Declaration Options", "XMLObject Syntax"}]},
  "Comment"->{
    Cell[15730, 545, 216, 6, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XMLObject", "Comment", "XML Comment"}]},
  "XML Comment"->{
    Cell[15730, 545, 216, 6, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XMLObject", "Comment", "XML Comment"}]},
  "Document"->{
    Cell[15949, 553, 220, 6, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XMLObject", "Document", "XML Document"}]},
  "XML Document"->{
    Cell[15949, 553, 220, 6, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XMLObject", "Document", "XML Document"}]},
  "DOCTYPE"->{
    Cell[16172, 561, 216, 6, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XMLObject", "DOCTYPE", "XML DOCTYPE"}],
    Cell[34757, 1194, 274, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "Import Conversion Options", 
        "ValidateAgainstDTD", "DTD", "Validation", "DOCTYPE", 
        "Declaration"}]},
  "XML DOCTYPE"->{
    Cell[16172, 561, 216, 6, 16, "IndexSubentry",
      CellTags->{"SymbolicXML", "XMLObject", "DOCTYPE", "XML DOCTYPE"}],
    Cell[16606, 576, 231, 5, 15, "IndexSubentry",
      CellTags->{
      "System", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}],
    Cell[16840, 583, 231, 5, 15, "IndexSubentry",
      CellTags->{
      "Public", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}],
    Cell[17074, 590, 235, 5, 15, "IndexSubentry",
      CellTags->{
      "Internal", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}]},
  "XML`Parser"->{
    Cell[16391, 569, 212, 5, 15, "IndexSubentry",
      CellTags->{
      "XML`Parser", "XML and Mathematica", "XML", "XMLGet", "XMLGetString", 
        "Context"}]},
  "Context"->{
    Cell[16391, 569, 212, 5, 15, "IndexSubentry",
      CellTags->{
      "XML`Parser", "XML and Mathematica", "XML", "XMLGet", "XMLGetString", 
        "Context"}]},
  "System"->{
    Cell[16606, 576, 231, 5, 15, "IndexSubentry",
      CellTags->{
      "System", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}]},
  "DOCTYPE Options"->{
    Cell[16606, 576, 231, 5, 15, "IndexSubentry",
      CellTags->{
      "System", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}],
    Cell[16840, 583, 231, 5, 15, "IndexSubentry",
      CellTags->{
      "Public", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}],
    Cell[17074, 590, 235, 5, 15, "IndexSubentry",
      CellTags->{
      "Internal", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}]},
  "Public"->{
    Cell[16840, 583, 231, 5, 15, "IndexSubentry",
      CellTags->{
      "Public", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}]},
  "Internal"->{
    Cell[17074, 590, 235, 5, 15, "IndexSubentry",
      CellTags->{
      "Internal", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
        "DOCTYPE Options", "XMLObject Syntax"}]},
  "Procession Instruction"->{
    Cell[17312, 597, 284, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "Procession Instruction", 
        "XML Processing Instruction"}]},
  "XML Processing Instruction"->{
    Cell[17312, 597, 284, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "Procession Instruction", 
        "XML Processing Instruction"}]},
  "CDATA"->{
    Cell[17599, 607, 280, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "CDATA", "Character Data", 
        "XML CDATASection", "PreserveCDATASections"}]},
  "Character Data"->{
    Cell[17599, 607, 280, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "CDATA", "Character Data", 
        "XML CDATASection", "PreserveCDATASections"}]},
  "XML CDATASection"->{
    Cell[17599, 607, 280, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "CDATA", "Character Data", 
        "XML CDATASection", "PreserveCDATASections"}]},
  "PreserveCDATASections"->{
    Cell[17599, 607, 280, 8, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "XMLObject", "CDATA", "Character Data", 
        "XML CDATASection", "PreserveCDATASections"}],
    Cell[35908, 1223, 236, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "PreserveCDATASections", 
        "Import Conversion Options"}]},
  "XHTML"->{
    Cell[17882, 617, 198, 7, 16, "Index",
      CellTags->{"XHTML", "MathML"}]},
  "Namespaces"->{
    Cell[18083, 626, 397, 13, 16, "Index",
      CellTags->{
      "Namespaces", "DTDs and Namespaces", "Handling Namespaces", 
        "SymbolicXML and Namespaces"}],
    Cell[33124, 1146, 339, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Namespace Prefixes", 
        "Namespaces"}],
    Cell[35625, 1216, 280, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeNamespaces", "Namespaces", 
        "Scoping", "Import Conversion Options", 
        "Non-compliant XML documents"}]},
  "DTDs and Namespaces"->{
    Cell[18083, 626, 397, 13, 16, "Index",
      CellTags->{
      "Namespaces", "DTDs and Namespaces", "Handling Namespaces", 
        "SymbolicXML and Namespaces"}],
    Cell[26458, 909, 231, 7, 16, "IndexSubentry",
      CellTags->{"DTDs and Namespaces", "NotebookML"}]},
  "Handling Namespaces"->{
    Cell[18083, 626, 397, 13, 16, "Index",
      CellTags->{
      "Namespaces", "DTDs and Namespaces", "Handling Namespaces", 
        "SymbolicXML and Namespaces"}]},
  "SymbolicXML and Namespaces"->{
    Cell[18083, 626, 397, 13, 16, "Index",
      CellTags->{
      "Namespaces", "DTDs and Namespaces", "Handling Namespaces", 
        "SymbolicXML and Namespaces"}]},
  "Representing Other Objects"->{
    Cell[18483, 641, 304, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Representing Other Objects", "XML Constructs", 
        "XML and Mathematica", "XML"}]},
  "XML Constructs"->{
    Cell[18483, 641, 304, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXML", "Representing Other Objects", "XML Constructs", 
        "XML and Mathematica", "XML"}]},
  "Transforming XML"->{
    Cell[18790, 652, 279, 9, 16, "Index",
      CellTags->{
      "Transforming XML", "XML and Mathematica", "SymbolicXML", 
        "Processing XML Data"}],
    Cell[19072, 663, 324, 9, 16, "IndexSubentry",
      CellTags->{
      "Visualizing the XML Tree", "Transforming XML", "XML and Mathematica", 
        "XML", "Tree Structure", "Notebook", "SymbolicXML"}],
    Cell[19399, 674, 329, 9, 16, "IndexSubentry",
      CellTags->{
      "Manipulating Data", "Manipulating XML Data", "Transforming XML", 
        "XML and Mathematica", "XML Data", "Pattern Matching"}],
    Cell[19731, 685, 292, 9, 16, "IndexSubentry",
      CellTags->{
      "XML Data", "Visualizing XML Data", "Transforming XML", 
        "XML and Mathematica", "MoDL"}],
    Cell[20026, 696, 401, 10, 16, "IndexSubentry",
      CellTags->{
      "XSLT", "XSLT and Mathematica", "Transforming XML", 
        "XML and Mathematica", "Converting", "XML", "Ancestor Elements", 
        "Elements", "Sibling Elements", "Child Elements", "Predicates"}],
    Cell[20430, 708, 262, 7, 16, "IndexSubentry",
      CellTags->{
      "HTML", "Notebook", "XML", "Notebook to HTML", "Transforming XML"}],
    Cell[20695, 717, 381, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXMLErrors", "Errors", "XML Errors", "SymbolicXML", 
        "SymbolicXML Syntax", "Verifying SymbolicXML Syntax", 
        "Transforming XML", "Part", "Extract"}],
    Cell[36830, 1251, 193, 4, 15, "Index",
      CellTags->{
      "SymbolicXMLErrors", "Transforming XML", "XML Errors", "SymbolicXML", 
        "XML Functions"}]},
  "Processing XML Data"->{
    Cell[18790, 652, 279, 9, 16, "Index",
      CellTags->{
      "Transforming XML", "XML and Mathematica", "SymbolicXML", 
        "Processing XML Data"}]},
  "Visualizing the XML Tree"->{
    Cell[19072, 663, 324, 9, 16, "IndexSubentry",
      CellTags->{
      "Visualizing the XML Tree", "Transforming XML", "XML and Mathematica", 
        "XML", "Tree Structure", "Notebook", "SymbolicXML"}]},
  "Notebook"->{
    Cell[19072, 663, 324, 9, 16, "IndexSubentry",
      CellTags->{
      "Visualizing the XML Tree", "Transforming XML", "XML and Mathematica", 
        "XML", "Tree Structure", "Notebook", "SymbolicXML"}],
    Cell[20430, 708, 262, 7, 16, "IndexSubentry",
      CellTags->{
      "HTML", "Notebook", "XML", "Notebook to HTML", "Transforming XML"}],
    Cell[23502, 811, 302, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "Notebook", 
        "Elements", "Cell"}]},
  "Manipulating Data"->{
    Cell[19399, 674, 329, 9, 16, "IndexSubentry",
      CellTags->{
      "Manipulating Data", "Manipulating XML Data", "Transforming XML", 
        "XML and Mathematica", "XML Data", "Pattern Matching"}]},
  "Manipulating XML Data"->{
    Cell[19399, 674, 329, 9, 16, "IndexSubentry",
      CellTags->{
      "Manipulating Data", "Manipulating XML Data", "Transforming XML", 
        "XML and Mathematica", "XML Data", "Pattern Matching"}]},
  "XML Data"->{
    Cell[19399, 674, 329, 9, 16, "IndexSubentry",
      CellTags->{
      "Manipulating Data", "Manipulating XML Data", "Transforming XML", 
        "XML and Mathematica", "XML Data", "Pattern Matching"}],
    Cell[19731, 685, 292, 9, 16, "IndexSubentry",
      CellTags->{
      "XML Data", "Visualizing XML Data", "Transforming XML", 
        "XML and Mathematica", "MoDL"}],
    Cell[24560, 845, 366, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
        "CellGroupData", "OutputFormData", "TextData", "StyleData", 
        "TaggingRules", "XMLData", "XML Data", "Options", 
        "NotebookML Front End Options"}]},
  "Visualizing XML Data"->{
    Cell[19731, 685, 292, 9, 16, "IndexSubentry",
      CellTags->{
      "XML Data", "Visualizing XML Data", "Transforming XML", 
        "XML and Mathematica", "MoDL"}]},
  "MoDL"->{
    Cell[19731, 685, 292, 9, 16, "IndexSubentry",
      CellTags->{
      "XML Data", "Visualizing XML Data", "Transforming XML", 
        "XML and Mathematica", "MoDL"}]},
  "XSLT and Mathematica"->{
    Cell[20026, 696, 401, 10, 16, "IndexSubentry",
      CellTags->{
      "XSLT", "XSLT and Mathematica", "Transforming XML", 
        "XML and Mathematica", "Converting", "XML", "Ancestor Elements", 
        "Elements", "Sibling Elements", "Child Elements", "Predicates"}]},
  "Converting"->{
    Cell[20026, 696, 401, 10, 16, "IndexSubentry",
      CellTags->{
      "XSLT", "XSLT and Mathematica", "Transforming XML", 
        "XML and Mathematica", "Converting", "XML", "Ancestor Elements", 
        "Elements", "Sibling Elements", "Child Elements", "Predicates"}]},
  "Ancestor Elements"->{
    Cell[20026, 696, 401, 10, 16, "IndexSubentry",
      CellTags->{
      "XSLT", "XSLT and Mathematica", "Transforming XML", 
        "XML and Mathematica", "Converting", "XML", "Ancestor Elements", 
        "Elements", "Sibling Elements", "Child Elements", "Predicates"}]},
  "Elements"->{
    Cell[20026, 696, 401, 10, 16, "IndexSubentry",
      CellTags->{
      "XSLT", "XSLT and Mathematica", "Transforming XML", 
        "XML and Mathematica", "Converting", "XML", "Ancestor Elements", 
        "Elements", "Sibling Elements", "Child Elements", "Predicates"}],
    Cell[23502, 811, 302, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "Notebook", 
        "Elements", "Cell"}]},
  "Sibling Elements"->{
    Cell[20026, 696, 401, 10, 16, "IndexSubentry",
      CellTags->{
      "XSLT", "XSLT and Mathematica", "Transforming XML", 
        "XML and Mathematica", "Converting", "XML", "Ancestor Elements", 
        "Elements", "Sibling Elements", "Child Elements", "Predicates"}]},
  "Predicates"->{
    Cell[20026, 696, 401, 10, 16, "IndexSubentry",
      CellTags->{
      "XSLT", "XSLT and Mathematica", "Transforming XML", 
        "XML and Mathematica", "Converting", "XML", "Ancestor Elements", 
        "Elements", "Sibling Elements", "Child Elements", "Predicates"}]},
  "HTML"->{
    Cell[20430, 708, 262, 7, 16, "IndexSubentry",
      CellTags->{
      "HTML", "Notebook", "XML", "Notebook to HTML", "Transforming XML"}]},
  "Notebook to HTML"->{
    Cell[20430, 708, 262, 7, 16, "IndexSubentry",
      CellTags->{
      "HTML", "Notebook", "XML", "Notebook to HTML", "Transforming XML"}]},
  "SymbolicXMLErrors"->{
    Cell[20695, 717, 381, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXMLErrors", "Errors", "XML Errors", "SymbolicXML", 
        "SymbolicXML Syntax", "Verifying SymbolicXML Syntax", 
        "Transforming XML", "Part", "Extract"}],
    Cell[36830, 1251, 193, 4, 15, "Index",
      CellTags->{
      "SymbolicXMLErrors", "Transforming XML", "XML Errors", "SymbolicXML", 
        "XML Functions"}]},
  "Errors"->{
    Cell[20695, 717, 381, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXMLErrors", "Errors", "XML Errors", "SymbolicXML", 
        "SymbolicXML Syntax", "Verifying SymbolicXML Syntax", 
        "Transforming XML", "Part", "Extract"}]},
  "XML Errors"->{
    Cell[20695, 717, 381, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXMLErrors", "Errors", "XML Errors", "SymbolicXML", 
        "SymbolicXML Syntax", "Verifying SymbolicXML Syntax", 
        "Transforming XML", "Part", "Extract"}],
    Cell[36830, 1251, 193, 4, 15, "Index",
      CellTags->{
      "SymbolicXMLErrors", "Transforming XML", "XML Errors", "SymbolicXML", 
        "XML Functions"}]},
  "Verifying SymbolicXML Syntax"->{
    Cell[20695, 717, 381, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXMLErrors", "Errors", "XML Errors", "SymbolicXML", 
        "SymbolicXML Syntax", "Verifying SymbolicXML Syntax", 
        "Transforming XML", "Part", "Extract"}]},
  "Part"->{
    Cell[20695, 717, 381, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXMLErrors", "Errors", "XML Errors", "SymbolicXML", 
        "SymbolicXML Syntax", "Verifying SymbolicXML Syntax", 
        "Transforming XML", "Part", "Extract"}]},
  "Extract"->{
    Cell[20695, 717, 381, 9, 16, "IndexSubentry",
      CellTags->{
      "SymbolicXMLErrors", "Errors", "XML Errors", "SymbolicXML", 
        "SymbolicXML Syntax", "Verifying SymbolicXML Syntax", 
        "Transforming XML", "Part", "Extract"}]},
  "Exporting XML"->{
    Cell[21079, 728, 285, 9, 16, "Index",
      CellTags->{
      "Exporting XML", "Export", "SymbolicXML", "XML and Mathematica", "XML", 
        "Export File Formats"}],
    Cell[21367, 739, 203, 7, 16, "IndexSubentry",
      CellTags->{"Export", "Exporting XML", "XML and Mathematica"}],
    Cell[21573, 748, 271, 9, 16, "IndexSubentry",
      CellTags->{
      "Export", "ExportString", "Exporting XML", "XML and Mathematica", 
        "SymbolicXML", "XML"}],
    Cell[21847, 759, 273, 7, 16, "IndexSubentry",
      CellTags->{"Export", "Exporting XML", "XML Export Conversion Options"}],
    
    Cell[22123, 768, 213, 4, 15, "Index",
      CellTags->{
      "CheckXML", "Export", "Exporting XML", 
        "XML Export Conversion Options"}],
    Cell[22541, 779, 192, 4, 15, "Index",
      CellTags->{
      "Entities", "Export", "Exporting XML", 
        "XML Export Conversion Options"}],
    Cell[22736, 785, 205, 4, 15, "Index",
      CellTags->{
      "Annotations", "Export", "Exporting XML", 
        "XML Export Conversion Options"}]},
  "Export"->{
    Cell[21079, 728, 285, 9, 16, "Index",
      CellTags->{
      "Exporting XML", "Export", "SymbolicXML", "XML and Mathematica", "XML", 
        "Export File Formats"}],
    Cell[21367, 739, 203, 7, 16, "IndexSubentry",
      CellTags->{"Export", "Exporting XML", "XML and Mathematica"}],
    Cell[21573, 748, 271, 9, 16, "IndexSubentry",
      CellTags->{
      "Export", "ExportString", "Exporting XML", "XML and Mathematica", 
        "SymbolicXML", "XML"}],
    Cell[21847, 759, 273, 7, 16, "IndexSubentry",
      CellTags->{"Export", "Exporting XML", "XML Export Conversion Options"}],
    
    Cell[22123, 768, 213, 4, 15, "Index",
      CellTags->{
      "CheckXML", "Export", "Exporting XML", 
        "XML Export Conversion Options"}],
    Cell[22339, 774, 199, 3, 15, "Index",
      CellTags->{
      "ElementFormatting", "Element Formatting", "Element", "Export"}],
    Cell[22541, 779, 192, 4, 15, "Index",
      CellTags->{
      "Entities", "Export", "Exporting XML", 
        "XML Export Conversion Options"}],
    Cell[22736, 785, 205, 4, 15, "Index",
      CellTags->{
      "Annotations", "Export", "Exporting XML", 
        "XML Export Conversion Options"}],
    Cell[27864, 960, 245, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML", "Exporting NotebookML", "Export"}],
    Cell[28112, 969, 309, 8, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Exporting NotebookML", "ExportString", "Export"}],
    Cell[31650, 1094, 331, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Generating MathML", "BoxesToMathML", "ExpressionToMathML", 
        "BoxesToSymbolicMathML", "ExpressionToSymbolicMathML", "Export"}],
    Cell[31984, 1105, 225, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "Exporting MathML", "Export"}],
    Cell[32212, 1114, 312, 8, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options"}],
    Cell[32527, 1124, 280, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Formats"}],
    Cell[32810, 1135, 311, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Annotations", 
        "Annotations"}],
    Cell[33124, 1146, 339, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Namespace Prefixes", 
        "Namespaces"}]},
  "Export File Formats"->{
    Cell[21079, 728, 285, 9, 16, "Index",
      CellTags->{
      "Exporting XML", "Export", "SymbolicXML", "XML and Mathematica", "XML", 
        "Export File Formats"}]},
  "ExportString"->{
    Cell[21573, 748, 271, 9, 16, "IndexSubentry",
      CellTags->{
      "Export", "ExportString", "Exporting XML", "XML and Mathematica", 
        "SymbolicXML", "XML"}],
    Cell[28112, 969, 309, 8, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Exporting NotebookML", "ExportString", "Export"}]},
  "XML Export Conversion Options"->{
    Cell[21847, 759, 273, 7, 16, "IndexSubentry",
      CellTags->{"Export", "Exporting XML", "XML Export Conversion Options"}],
    
    Cell[22123, 768, 213, 4, 15, "Index",
      CellTags->{
      "CheckXML", "Export", "Exporting XML", 
        "XML Export Conversion Options"}],
    Cell[22541, 779, 192, 4, 15, "Index",
      CellTags->{
      "Entities", "Export", "Exporting XML", 
        "XML Export Conversion Options"}],
    Cell[22736, 785, 205, 4, 15, "Index",
      CellTags->{
      "Annotations", "Export", "Exporting XML", 
        "XML Export Conversion Options"}]},
  "CheckXML"->{
    Cell[22123, 768, 213, 4, 15, "Index",
      CellTags->{
      "CheckXML", "Export", "Exporting XML", 
        "XML Export Conversion Options"}]},
  "ElementFormatting"->{
    Cell[22339, 774, 199, 3, 15, "Index",
      CellTags->{
      "ElementFormatting", "Element Formatting", "Element", "Export"}]},
  "Element Formatting"->{
    Cell[22339, 774, 199, 3, 15, "Index",
      CellTags->{
      "ElementFormatting", "Element Formatting", "Element", "Export"}]},
  "Annotations"->{
    Cell[22736, 785, 205, 4, 15, "Index",
      CellTags->{
      "Annotations", "Export", "Exporting XML", 
        "XML Export Conversion Options"}],
    Cell[28763, 990, 335, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Annotations", "Annotations", 
        "NotebookML Export Conversion Options", "Export Conversion Options"}],
    
    Cell[32810, 1135, 311, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Annotations", 
        "Annotations"}]},
  "NotebookML:Introduction"->{
    Cell[22944, 791, 254, 7, 16, "Index",
      CellTags->{
      "NotebookML:Introduction", "XML and Mathematica", "NotebookML", 
        "XML"}]},
  "NotebookML Syntax"->{
    Cell[23201, 800, 298, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "XML and Mathematica", "XML", 
        "NotebookML Elements", "NotebookML Attributes"}],
    Cell[23502, 811, 302, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "Notebook", 
        "Elements", "Cell"}],
    Cell[23807, 822, 372, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "String", 
        "Element", "List", "Number", "Symbol", "Options", "Option Elements"}],
    
    Cell[24182, 833, 375, 10, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "List Types", "String", 
        "Color Values", "Suboptions", "Number", "Symbol", "Options", 
        "NotebookML Front End Options"}],
    Cell[24560, 845, 366, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
        "CellGroupData", "OutputFormData", "TextData", "StyleData", 
        "TaggingRules", "XMLData", "XML Data", "Options", 
        "NotebookML Front End Options"}],
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "NotebookML Elements"->{
    Cell[23201, 800, 298, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "XML and Mathematica", "XML", 
        "NotebookML Elements", "NotebookML Attributes"}],
    Cell[23502, 811, 302, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "Notebook", 
        "Elements", "Cell"}],
    Cell[23807, 822, 372, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "String", 
        "Element", "List", "Number", "Symbol", "Options", 
        "Option Elements"}]},
  "NotebookML Attributes"->{
    Cell[23201, 800, 298, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "XML and Mathematica", "XML", 
        "NotebookML Elements", "NotebookML Attributes"}]},
  "Cell"->{
    Cell[23502, 811, 302, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "Notebook", 
        "Elements", "Cell"}]},
  "String"->{
    Cell[23807, 822, 372, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "String", 
        "Element", "List", "Number", "Symbol", "Options", "Option Elements"}],
    
    Cell[24182, 833, 375, 10, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "List Types", "String", 
        "Color Values", "Suboptions", "Number", "Symbol", "Options", 
        "NotebookML Front End Options"}]},
  "List"->{
    Cell[23807, 822, 372, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "String", 
        "Element", "List", "Number", "Symbol", "Options", 
        "Option Elements"}]},
  "Number"->{
    Cell[23807, 822, 372, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "String", 
        "Element", "List", "Number", "Symbol", "Options", "Option Elements"}],
    
    Cell[24182, 833, 375, 10, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "List Types", "String", 
        "Color Values", "Suboptions", "Number", "Symbol", "Options", 
        "NotebookML Front End Options"}]},
  "Symbol"->{
    Cell[23807, 822, 372, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "String", 
        "Element", "List", "Number", "Symbol", "Options", "Option Elements"}],
    
    Cell[24182, 833, 375, 10, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "List Types", "String", 
        "Color Values", "Suboptions", "Number", "Symbol", "Options", 
        "NotebookML Front End Options"}]},
  "Option Elements"->{
    Cell[23807, 822, 372, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "NotebookML Elements", "String", 
        "Element", "List", "Number", "Symbol", "Options", 
        "Option Elements"}]},
  "List Types"->{
    Cell[24182, 833, 375, 10, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "List Types", "String", 
        "Color Values", "Suboptions", "Number", "Symbol", "Options", 
        "NotebookML Front End Options"}]},
  "Color Values"->{
    Cell[24182, 833, 375, 10, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "List Types", "String", 
        "Color Values", "Suboptions", "Number", "Symbol", "Options", 
        "NotebookML Front End Options"}]},
  "Suboptions"->{
    Cell[24182, 833, 375, 10, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "List Types", "String", 
        "Color Values", "Suboptions", "Number", "Symbol", "Options", 
        "NotebookML Front End Options"}]},
  "NotebookML Front End Options"->{
    Cell[24182, 833, 375, 10, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "List Types", "String", 
        "Color Values", "Suboptions", "Number", "Symbol", "Options", 
        "NotebookML Front End Options"}],
    Cell[24560, 845, 366, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
        "CellGroupData", "OutputFormData", "TextData", "StyleData", 
        "TaggingRules", "XMLData", "XML Data", "Options", 
        "NotebookML Front End Options"}]},
  "BoxData"->{
    Cell[24560, 845, 366, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
        "CellGroupData", "OutputFormData", "TextData", "StyleData", 
        "TaggingRules", "XMLData", "XML Data", "Options", 
        "NotebookML Front End Options"}]},
  "GraphicsData"->{
    Cell[24560, 845, 366, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
        "CellGroupData", "OutputFormData", "TextData", "StyleData", 
        "TaggingRules", "XMLData", "XML Data", "Options", 
        "NotebookML Front End Options"}]},
  "CellGroupData"->{
    Cell[24560, 845, 366, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
        "CellGroupData", "OutputFormData", "TextData", "StyleData", 
        "TaggingRules", "XMLData", "XML Data", "Options", 
        "NotebookML Front End Options"}]},
  "OutputFormData"->{
    Cell[24560, 845, 366, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
        "CellGroupData", "OutputFormData", "TextData", "StyleData", 
        "TaggingRules", "XMLData", "XML Data", "Options", 
        "NotebookML Front End Options"}]},
  "TextData"->{
    Cell[24560, 845, 366, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
        "CellGroupData", "OutputFormData", "TextData", "StyleData", 
        "TaggingRules", "XMLData", "XML Data", "Options", 
        "NotebookML Front End Options"}]},
  "StyleData"->{
    Cell[24560, 845, 366, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
        "CellGroupData", "OutputFormData", "TextData", "StyleData", 
        "TaggingRules", "XMLData", "XML Data", "Options", 
        "NotebookML Front End Options"}]},
  "TaggingRules"->{
    Cell[24560, 845, 366, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
        "CellGroupData", "OutputFormData", "TextData", "StyleData", 
        "TaggingRules", "XMLData", "XML Data", "Options", 
        "NotebookML Front End Options"}]},
  "XMLData"->{
    Cell[24560, 845, 366, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
        "CellGroupData", "OutputFormData", "TextData", "StyleData", 
        "TaggingRules", "XMLData", "XML Data", "Options", 
        "NotebookML Front End Options"}]},
  "Box Options"->{
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "Boxes"->{
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "CellOptions"->{
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "NotebookOptions"->{
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "RowBox"->{
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "GridBox"->{
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "OptionValueBox"->{
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "InterpretationBox"->{
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "TagBox"->{
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "FormBox"->{
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "StyleBox"->{
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "CounterBox"->{
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "ValueBox"->{
    Cell[24929, 854, 359, 7, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", 
        "CellOptions", "NotebookOptions", "RowBox", "GridBox", 
        "OptionValueBox", "InterpretationBox", "TagBox", "FormBox", 
        "StyleBox", "CounterBox", "ValueBox"}]},
  "NotebookML Annotations"->{
    Cell[25538, 872, 232, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML Annotations", "NotebookML"}],
    Cell[28763, 990, 335, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Annotations", "Annotations", 
        "NotebookML Export Conversion Options", 
        "Export Conversion Options"}]},
  "BoxFormats"->{
    Cell[25773, 881, 217, 8, 16, "IndexSubentry",
      CellTags->{"BoxFormats", "NotebookML"}],
    Cell[29101, 1001, 288, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "BoxFormats", "NotebookML Export Conversion Options", 
        "Export Conversion Options"}]},
  "GraphicsFormats"->{
    Cell[25993, 891, 212, 7, 16, "IndexSubentry",
      CellTags->{"GraphicsFormats", "NotebookML"}],
    Cell[29392, 1012, 308, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "GraphicsFormats", "NotebookML Export Conversion Options",
         "Export Conversion Options"}]},
  "NotebookML Stylesheets"->{
    Cell[26208, 900, 247, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML Stylesheets", "NotebookML", "Stylesheets"}],
    Cell[29703, 1023, 258, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML", "Stylesheets", "NotebookML Stylesheets"}]},
  "Stylesheets"->{
    Cell[26208, 900, 247, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML Stylesheets", "NotebookML", "Stylesheets"}],
    Cell[29703, 1023, 258, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML", "Stylesheets", "NotebookML Stylesheets"}]},
  "Processing NotebookML"->{
    Cell[26692, 918, 287, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", "SymbolicXML", 
        "NotebookML Conversion"}],
    Cell[26982, 929, 279, 8, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", "Preprocessing NotebookML"}],
    Cell[27264, 939, 303, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", "Postprocessing NotebookML", 
        "SymbolicXML"}],
    Cell[27570, 950, 291, 8, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", 
        "NotebookML Conversion Rules"}]},
  "NotebookML Conversion"->{
    Cell[26692, 918, 287, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", "SymbolicXML", 
        "NotebookML Conversion"}]},
  "Preprocessing NotebookML"->{
    Cell[26982, 929, 279, 8, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", "Preprocessing NotebookML"}]},
  "Postprocessing NotebookML"->{
    Cell[27264, 939, 303, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", "Postprocessing NotebookML", 
        "SymbolicXML"}]},
  "NotebookML Conversion Rules"->{
    Cell[27570, 950, 291, 8, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Processing NotebookML", 
        "NotebookML Conversion Rules"}]},
  "Exporting NotebookML"->{
    Cell[27864, 960, 245, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML", "Exporting NotebookML", "Export"}],
    Cell[28112, 969, 309, 8, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "Exporting NotebookML", "ExportString", "Export"}]},
  "NotebookML Export Conversion Options"->{
    Cell[28424, 979, 336, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Export Conversion Options", 
        "Export Conversion Options"}],
    Cell[28763, 990, 335, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Annotations", "Annotations", 
        "NotebookML Export Conversion Options", "Export Conversion Options"}],
    
    Cell[29101, 1001, 288, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "BoxFormats", "NotebookML Export Conversion Options", 
        "Export Conversion Options"}],
    Cell[29392, 1012, 308, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "GraphicsFormats", "NotebookML Export Conversion Options",
         "Export Conversion Options"}]},
  "Export Conversion Options"->{
    Cell[28424, 979, 336, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Export Conversion Options", 
        "Export Conversion Options"}],
    Cell[28763, 990, 335, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "NotebookML Annotations", "Annotations", 
        "NotebookML Export Conversion Options", "Export Conversion Options"}],
    
    Cell[29101, 1001, 288, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "BoxFormats", "NotebookML Export Conversion Options", 
        "Export Conversion Options"}],
    Cell[29392, 1012, 308, 9, 16, "IndexSubentry",
      CellTags->{
      "NotebookML", "GraphicsFormats", "NotebookML Export Conversion Options",
         "Export Conversion Options"}]},
  "Displaying NotebookML using CSS"->{
    Cell[29964, 1032, 276, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML", "Displaying NotebookML using CSS", "CSS"}]},
  "CSS"->{
    Cell[29964, 1032, 276, 7, 16, "IndexSubentry",
      CellTags->{"NotebookML", "Displaying NotebookML using CSS", "CSS"}]},
  "MathML Syntax"->{
    Cell[30434, 1049, 219, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "MathML Syntax", "XML and Mathematica"}],
    Cell[30656, 1058, 244, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "MathML Syntax", "Presentation MathML"}],
    Cell[30903, 1067, 224, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "MathML Syntax", "Content MathML"}]},
  "Presentation MathML"->{
    Cell[30656, 1058, 244, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "MathML Syntax", "Presentation MathML"}]},
  "Content MathML"->{
    Cell[30903, 1067, 224, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "MathML Syntax", "Content MathML"}]},
  "Importing MathML"->{
    Cell[31130, 1076, 225, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "Import", "Importing MathML"}],
    Cell[31358, 1085, 289, 7, 16, "IndexSubentry",
      CellTags->{"Importing MathML", "MathML Import Conversion Options"}]},
  "MathML Import Conversion Options"->{
    Cell[31358, 1085, 289, 7, 16, "IndexSubentry",
      CellTags->{"Importing MathML", "MathML Import Conversion Options"}]},
  "Generating MathML"->{
    Cell[31650, 1094, 331, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Generating MathML", "BoxesToMathML", "ExpressionToMathML", 
        "BoxesToSymbolicMathML", "ExpressionToSymbolicMathML", "Export"}]},
  "BoxesToMathML"->{
    Cell[31650, 1094, 331, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Generating MathML", "BoxesToMathML", "ExpressionToMathML", 
        "BoxesToSymbolicMathML", "ExpressionToSymbolicMathML", "Export"}],
    Cell[37823, 1277, 128, 2, 15, "Index",
      CellTags->{"BoxesToMathML", "XML Functions"}]},
  "ExpressionToMathML"->{
    Cell[31650, 1094, 331, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Generating MathML", "BoxesToMathML", "ExpressionToMathML", 
        "BoxesToSymbolicMathML", "ExpressionToSymbolicMathML", "Export"}],
    Cell[38085, 1285, 138, 2, 15, "Index",
      CellTags->{"ExpressionToMathML", "XML Functions"}]},
  "BoxesToSymbolicMathML"->{
    Cell[31650, 1094, 331, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Generating MathML", "BoxesToMathML", "ExpressionToMathML", 
        "BoxesToSymbolicMathML", "ExpressionToSymbolicMathML", "Export"}],
    Cell[38514, 1297, 144, 2, 15, "Index",
      CellTags->{"BoxesToSymbolicMathML", "XML Functions"}]},
  "ExpressionToSymbolicMathML"->{
    Cell[31650, 1094, 331, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Generating MathML", "BoxesToMathML", "ExpressionToMathML", 
        "BoxesToSymbolicMathML", "ExpressionToSymbolicMathML", "Export"}],
    Cell[38661, 1301, 154, 2, 15, "Index",
      CellTags->{"ExpressionToSymbolicMathML", "XML Functions"}]},
  "Exporting MathML"->{
    Cell[31984, 1105, 225, 7, 16, "IndexSubentry",
      CellTags->{"MathML", "Exporting MathML", "Export"}],
    Cell[32212, 1114, 312, 8, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options"}],
    Cell[32527, 1124, 280, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Formats"}],
    Cell[32810, 1135, 311, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Annotations", 
        "Annotations"}],
    Cell[33124, 1146, 339, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Namespace Prefixes", 
        "Namespaces"}]},
  "MathML Export Conversion Options"->{
    Cell[32212, 1114, 312, 8, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options"}],
    Cell[32527, 1124, 280, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Formats"}],
    Cell[32810, 1135, 311, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Annotations", 
        "Annotations"}],
    Cell[33124, 1146, 339, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Namespace Prefixes", 
        "Namespaces"}]},
  "MathML Formats"->{
    Cell[32527, 1124, 280, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Formats"}]},
  "MathML Annotations"->{
    Cell[32810, 1135, 311, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Annotations", 
        "Annotations"}]},
  "MathML Namespace Prefixes"->{
    Cell[33124, 1146, 339, 9, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Exporting MathML", "Export", 
        "MathML Export Conversion Options", "MathML Namespace Prefixes", 
        "Namespaces"}]},
  "Symbols for MathML Elements"->{
    Cell[33466, 1157, 265, 7, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Symbols for MathML Elements", "MathML Elements"}]},
  "MathML Elements"->{
    Cell[33466, 1157, 265, 7, 16, "IndexSubentry",
      CellTags->{
      "MathML", "Symbols for MathML Elements", "MathML Elements"}]},
  "XML Import Conversion Options"->{
    Cell[33734, 1166, 244, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "NormalizeWhitespace", 
        "Import Conversion Options", "Whitespace"}],
    Cell[33981, 1173, 261, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "Import Conversion Options", 
        "AllowRemoteDTDAccess", "Remote DTD Access", "DTD"}],
    Cell[34245, 1180, 285, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "AllowUnrecognizedEntities", 
        "Entities", "Unrecognized Entities", "Import Conversion Options"}],
    Cell[34533, 1187, 221, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "ReadDTD", "DTD", "External DTD", 
        "Validation", "External Subset"}],
    Cell[34757, 1194, 274, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "Import Conversion Options", 
        "ValidateAgainstDTD", "DTD", "Validation", "DOCTYPE", "Declaration"}],
    
    Cell[35034, 1201, 251, 5, 15, "Index",
      CellTags->{
      "IncludeDefaultedAttributes", "XML Import Conversion Options", 
        "Import Conversion Options"}],
    Cell[35288, 1208, 334, 6, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeEmbeddedObjects", "Comments", 
        "Processing Instructions", "Embedded Objects", "Objects", 
        "Import Conversion Options", "Pattern Matching"}],
    Cell[35625, 1216, 280, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeNamespaces", "Namespaces", 
        "Scoping", "Import Conversion Options", 
        "Non-compliant XML documents"}],
    Cell[35908, 1223, 236, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "PreserveCDATASections", 
        "Import Conversion Options"}]},
  "NormalizeWhitespace"->{
    Cell[33734, 1166, 244, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "NormalizeWhitespace", 
        "Import Conversion Options", "Whitespace"}]},
  "Whitespace"->{
    Cell[33734, 1166, 244, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "NormalizeWhitespace", 
        "Import Conversion Options", "Whitespace"}]},
  "AllowRemoteDTDAccess"->{
    Cell[33981, 1173, 261, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "Import Conversion Options", 
        "AllowRemoteDTDAccess", "Remote DTD Access", "DTD"}]},
  "Remote DTD Access"->{
    Cell[33981, 1173, 261, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "Import Conversion Options", 
        "AllowRemoteDTDAccess", "Remote DTD Access", "DTD"}]},
  "DTD"->{
    Cell[33981, 1173, 261, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "Import Conversion Options", 
        "AllowRemoteDTDAccess", "Remote DTD Access", "DTD"}],
    Cell[34533, 1187, 221, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "ReadDTD", "DTD", "External DTD", 
        "Validation", "External Subset"}],
    Cell[34757, 1194, 274, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "Import Conversion Options", 
        "ValidateAgainstDTD", "DTD", "Validation", "DOCTYPE", 
        "Declaration"}]},
  "AllowUnrecognizedEntities"->{
    Cell[34245, 1180, 285, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "AllowUnrecognizedEntities", 
        "Entities", "Unrecognized Entities", "Import Conversion Options"}]},
  "Unrecognized Entities"->{
    Cell[34245, 1180, 285, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "AllowUnrecognizedEntities", 
        "Entities", "Unrecognized Entities", "Import Conversion Options"}]},
  "ReadDTD"->{
    Cell[34533, 1187, 221, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "ReadDTD", "DTD", "External DTD", 
        "Validation", "External Subset"}]},
  "External DTD"->{
    Cell[34533, 1187, 221, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "ReadDTD", "DTD", "External DTD", 
        "Validation", "External Subset"}]},
  "External Subset"->{
    Cell[34533, 1187, 221, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "ReadDTD", "DTD", "External DTD", 
        "Validation", "External Subset"}]},
  "ValidateAgainstDTD"->{
    Cell[34757, 1194, 274, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "Import Conversion Options", 
        "ValidateAgainstDTD", "DTD", "Validation", "DOCTYPE", 
        "Declaration"}]},
  "IncludeDefaultedAttributes"->{
    Cell[35034, 1201, 251, 5, 15, "Index",
      CellTags->{
      "IncludeDefaultedAttributes", "XML Import Conversion Options", 
        "Import Conversion Options"}]},
  "IncludeEmbeddedObjects"->{
    Cell[35288, 1208, 334, 6, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeEmbeddedObjects", "Comments", 
        "Processing Instructions", "Embedded Objects", "Objects", 
        "Import Conversion Options", "Pattern Matching"}]},
  "Comments"->{
    Cell[35288, 1208, 334, 6, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeEmbeddedObjects", "Comments", 
        "Processing Instructions", "Embedded Objects", "Objects", 
        "Import Conversion Options", "Pattern Matching"}]},
  "Processing Instructions"->{
    Cell[35288, 1208, 334, 6, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeEmbeddedObjects", "Comments", 
        "Processing Instructions", "Embedded Objects", "Objects", 
        "Import Conversion Options", "Pattern Matching"}]},
  "Embedded Objects"->{
    Cell[35288, 1208, 334, 6, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeEmbeddedObjects", "Comments", 
        "Processing Instructions", "Embedded Objects", "Objects", 
        "Import Conversion Options", "Pattern Matching"}]},
  "Objects"->{
    Cell[35288, 1208, 334, 6, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeEmbeddedObjects", "Comments", 
        "Processing Instructions", "Embedded Objects", "Objects", 
        "Import Conversion Options", "Pattern Matching"}]},
  "IncludeNamespaces"->{
    Cell[35625, 1216, 280, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeNamespaces", "Namespaces", 
        "Scoping", "Import Conversion Options", 
        "Non-compliant XML documents"}]},
  "Scoping"->{
    Cell[35625, 1216, 280, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeNamespaces", "Namespaces", 
        "Scoping", "Import Conversion Options", 
        "Non-compliant XML documents"}]},
  "Non-compliant XML documents"->{
    Cell[35625, 1216, 280, 5, 15, "Index",
      CellTags->{
      "XML Import Conversion Options", "IncludeNamespaces", "Namespaces", 
        "Scoping", "Import Conversion Options", 
        "Non-compliant XML documents"}]},
  "SymbolicXMLQ"->{
    Cell[36147, 1230, 156, 3, 15, "Index",
      CellTags->{"SymbolicXMLQ", "XML Functions"}]},
  "XML Functions"->{
    Cell[36147, 1230, 156, 3, 15, "Index",
      CellTags->{"SymbolicXMLQ", "XML Functions"}],
    Cell[36306, 1235, 128, 2, 15, "Index",
      CellTags->{"ToSymbolicXML", "XML Functions"}],
    Cell[36437, 1239, 132, 2, 15, "Index",
      CellTags->{"FromSymbolicXML", "XML Functions"}],
    Cell[36572, 1243, 126, 2, 15, "Index",
      CellTags->{"ToVerboseXML", "XML Functions"}],
    Cell[36701, 1247, 126, 2, 15, "Index",
      CellTags->{"ToCompactXML", "XML Functions"}],
    Cell[36830, 1251, 193, 4, 15, "Index",
      CellTags->{
      "SymbolicXMLErrors", "Transforming XML", "XML Errors", "SymbolicXML", 
        "XML Functions"}],
    Cell[37026, 1257, 134, 2, 15, "Index",
      CellTags->{"ReleaseXMLParser", "XML Functions"}],
    Cell[37163, 1261, 158, 2, 15, "Index",
      CellTags->{"NotebookToSymbolicNotebookML", "XML Functions"}],
    Cell[37324, 1265, 166, 2, 15, "Index",
      CellTags->{"XML Functions", "ExpressionToSymbolicExpressionML"}],
    Cell[37493, 1269, 158, 2, 15, "Index",
      CellTags->{"SymbolicNotebookMLToNotebook", "XML Functions"}],
    Cell[37654, 1273, 166, 2, 15, "Index",
      CellTags->{"SymbolicExpressionMLToExpression", "XML Functions"}],
    Cell[37823, 1277, 128, 2, 15, "Index",
      CellTags->{"BoxesToMathML", "XML Functions"}],
    Cell[37954, 1281, 128, 2, 15, "Index",
      CellTags->{"MathMLToBoxes", "XML Functions"}],
    Cell[38085, 1285, 138, 2, 15, "Index",
      CellTags->{"ExpressionToMathML", "XML Functions"}],
    Cell[38226, 1289, 138, 2, 15, "Index",
      CellTags->{"MathMLToExpression", "XML Functions"}],
    Cell[38367, 1293, 144, 2, 15, "Index",
      CellTags->{"SymbolicMathMLToBoxes", "XML Functions"}],
    Cell[38514, 1297, 144, 2, 15, "Index",
      CellTags->{"BoxesToSymbolicMathML", "XML Functions"}],
    Cell[38661, 1301, 154, 2, 15, "Index",
      CellTags->{"ExpressionToSymbolicMathML", "XML Functions"}],
    Cell[38818, 1305, 154, 2, 15, "Index",
      CellTags->{"SymbolicMathMLToExpression", "XML Functions"}],
    Cell[38975, 1309, 122, 2, 15, "Index",
      CellTags->{"MathMLForm", "XML Functions"}]},
  "ToSymbolicXML"->{
    Cell[36306, 1235, 128, 2, 15, "Index",
      CellTags->{"ToSymbolicXML", "XML Functions"}]},
  "FromSymbolicXML"->{
    Cell[36437, 1239, 132, 2, 15, "Index",
      CellTags->{"FromSymbolicXML", "XML Functions"}]},
  "ToVerboseXML"->{
    Cell[36572, 1243, 126, 2, 15, "Index",
      CellTags->{"ToVerboseXML", "XML Functions"}]},
  "ToCompactXML"->{
    Cell[36701, 1247, 126, 2, 15, "Index",
      CellTags->{"ToCompactXML", "XML Functions"}]},
  "ReleaseXMLParser"->{
    Cell[37026, 1257, 134, 2, 15, "Index",
      CellTags->{"ReleaseXMLParser", "XML Functions"}]},
  "NotebookToSymbolicNotebookML"->{
    Cell[37163, 1261, 158, 2, 15, "Index",
      CellTags->{"NotebookToSymbolicNotebookML", "XML Functions"}]},
  "ExpressionToSymbolicExpressionML"->{
    Cell[37324, 1265, 166, 2, 15, "Index",
      CellTags->{"XML Functions", "ExpressionToSymbolicExpressionML"}]},
  "SymbolicNotebookMLToNotebook"->{
    Cell[37493, 1269, 158, 2, 15, "Index",
      CellTags->{"SymbolicNotebookMLToNotebook", "XML Functions"}]},
  "SymbolicExpressionMLToExpression"->{
    Cell[37654, 1273, 166, 2, 15, "Index",
      CellTags->{"SymbolicExpressionMLToExpression", "XML Functions"}]},
  "MathMLToBoxes"->{
    Cell[37954, 1281, 128, 2, 15, "Index",
      CellTags->{"MathMLToBoxes", "XML Functions"}]},
  "MathMLToExpression"->{
    Cell[38226, 1289, 138, 2, 15, "Index",
      CellTags->{"MathMLToExpression", "XML Functions"}]},
  "SymbolicMathMLToBoxes"->{
    Cell[38367, 1293, 144, 2, 15, "Index",
      CellTags->{"SymbolicMathMLToBoxes", "XML Functions"}]},
  "SymbolicMathMLToExpression"->{
    Cell[38818, 1305, 154, 2, 15, "Index",
      CellTags->{"SymbolicMathMLToExpression", "XML Functions"}]},
  "MathMLForm"->{
    Cell[38975, 1309, 122, 2, 15, "Index",
      CellTags->{"MathMLForm", "XML Functions"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"MasterIndexHeading", 39770, 1330},
  {"XML and Mathematica", 39883, 1333},
  {"XML", 44228, 1426},
  {"Native XML Formats", 47745, 1502},
  {"MathML", 48329, 1516},
  {"NotebookML", 50523, 1563},
  {"ExpressionML", 55000, 1657},
  {"Importing XML", 55331, 1665},
  {"Import", 58039, 1722},
  {"XML Import", 61224, 1788},
  {"Defaults", 62338, 1812},
  {"Overriding Defaults", 62940, 1826},
  {"XML Import Defaults", 63596, 1841},
  {"Import File Extensions", 63811, 1846},
  {"File Extensions", 64005, 1851},
  {"Extensions", 64194, 1856},
  {"ImportString", 64385, 1861},
  {"XML ImportString Defaults", 65016, 1874},
  {"XMLGet", 65421, 1884},
  {"XMLGet Conversion Options", 66395, 1905},
  {"ImportConversionOptions", 67408, 1926},
  {"ConversionOptions", 68450, 1948},
  {"XMLGetString", 69487, 1970},
  {"XMLGetString Conversion Options", 70265, 1987},
  {"URL", 70497, 1993},
  {"Import from URL", 71002, 2004},
  {"Importing over HTTP", 71511, 2015},
  {"Import from Website", 72020, 2026},
  {"XML Conversion Options", 72532, 2037},
  {"Import Conversion Options", 72765, 2042},
  {"Conversion Options", 75389, 2098},
  {"Options", 76387, 2119},
  {"Entities and Validation", 77997, 2152},
  {"Unicode", 79058, 2174},
  {"Entities", 79266, 2179},
  {"Validation", 80136, 2198},
  {"InitializeXMLParser", 81349, 2224},
  {"SymbolicXML", 81625, 2230},
  {"SymbolicXML Syntax", 87598, 2354},
  {"J/Link", 90856, 2423},
  {"SymbolicXML and J/Link", 91007, 2426},
  {"Tree Structure", 91150, 2429},
  {"XSLT", 91509, 2437},
  {"SymbolicXML and XSLT", 92060, 2447},
  {"SymbolicXML and Java", 92212, 2450},
  {"Java", 92341, 2453},
  {"SymbolicXML and SAX", 92485, 2456},
  {"SAX", 92611, 2459},
  {"SymbolicXML and DOM API", 92757, 2462},
  {"DOM API", 92895, 2465},
  {"Pattern Matching", 93042, 2468},
  {"SymbolicXML Workflow", 93646, 2480},
  {"Workflow", 93783, 2483},
  {"Element", 93919, 2486},
  {"XMLElement", 95255, 2515},
  {"XMLElement Syntax", 96817, 2548},
  {"XMLElement Argument", 98211, 2577},
  {"Argument", 98417, 2582},
  {"XML Child Elements", 98633, 2587},
  {"Child Elements", 98864, 2592},
  {"XMLElement Commands", 99376, 2602},
  {"Nesting Commands", 99591, 2607},
  {"XMLElement Names", 99806, 2612},
  {"Names", 100006, 2617},
  {"XMLElement Namespaces", 100222, 2622},
  {"Default Namespaces", 100431, 2627},
  {"Namespace Prefixes", 100659, 2632},
  {"Explicit Namespaces", 101090, 2641},
  {"XMLObject", 101310, 2646},
  {"XMLObject Syntax", 103663, 2695},
  {"Declaration", 104812, 2720},
  {"XML Declaration", 105224, 2730},
  {"Declaration Options", 105812, 2743},
  {"Standalone", 106391, 2756},
  {"Encoding", 106604, 2761},
  {"Comment", 106814, 2766},
  {"XML Comment", 106957, 2769},
  {"Document", 107097, 2772},
  {"XML Document", 107243, 2775},
  {"DOCTYPE", 107384, 2778},
  {"XML DOCTYPE", 107745, 2786},
  {"XML`Parser", 108441, 2801},
  {"Context", 108623, 2806},
  {"System", 108804, 2811},
  {"DOCTYPE Options", 109012, 2816},
  {"Public", 109581, 2829},
  {"Internal", 109782, 2834},
  {"Procession Instruction", 109999, 2839},
  {"XML Processing Instruction", 110203, 2844},
  {"CDATA", 110386, 2849},
  {"Character Data", 110594, 2854},
  {"XML CDATASection", 110804, 2859},
  {"PreserveCDATASections", 111019, 2864},
  {"XHTML", 111383, 2873},
  {"Namespaces", 111482, 2876},
  {"DTDs and Namespaces", 112118, 2891},
  {"Handling Namespaces", 112420, 2898},
  {"SymbolicXML and Namespaces", 112623, 2903},
  {"Representing Other Objects", 112826, 2908},
  {"XML Constructs", 113027, 2913},
  {"Transforming XML", 113230, 2918},
  {"Processing XML Data", 114833, 2952},
  {"Visualizing the XML Tree", 115024, 2957},
  {"Notebook", 115249, 2962},
  {"Manipulating Data", 115801, 2974},
  {"Manipulating XML Data", 116037, 2979},
  {"XML Data", 116260, 2984},
  {"Visualizing XML Data", 116974, 2999},
  {"MoDL", 117159, 3004},
  {"XSLT and Mathematica", 117360, 3009},
  {"Converting", 117655, 3015},
  {"Ancestor Elements", 117957, 3021},
  {"Elements", 118250, 3027},
  {"Sibling Elements", 118726, 3037},
  {"Predicates", 119021, 3043},
  {"HTML", 119310, 3049},
  {"Notebook to HTML", 119478, 3053},
  {"SymbolicXMLErrors", 119647, 3057},
  {"Errors", 120074, 3067},
  {"XML Errors", 120340, 3073},
  {"Verifying SymbolicXML Syntax", 120789, 3083},
  {"Part", 121049, 3089},
  {"Extract", 121312, 3095},
  {"Exporting XML", 121581, 3101},
  {"Export", 122644, 3127},
  {"Export File Formats", 125204, 3185},
  {"ExportString", 125397, 3190},
  {"XML Export Conversion Options", 125748, 3198},
  {"CheckXML", 126349, 3214},
  {"ElementFormatting", 126524, 3219},
  {"Element Formatting", 126683, 3223},
  {"Annotations", 126835, 3227},
  {"NotebookML:Introduction", 127441, 3242},
  {"NotebookML Syntax", 127615, 3247},
  {"NotebookML Elements", 129112, 3278},
  {"NotebookML Attributes", 129746, 3292},
  {"Cell", 129957, 3297},
  {"String", 130147, 3302},
  {"List", 130634, 3313},
  {"Number", 130880, 3319},
  {"Symbol", 131369, 3330},
  {"Option Elements", 131867, 3341},
  {"List Types", 132117, 3347},
  {"Color Values", 132385, 3353},
  {"Suboptions", 132651, 3359},
  {"NotebookML Front End Options", 132935, 3365},
  {"BoxData", 133505, 3377},
  {"GraphicsData", 133833, 3384},
  {"CellGroupData", 134162, 3391},
  {"OutputFormData", 134492, 3398},
  {"TextData", 134816, 3405},
  {"StyleData", 135141, 3412},
  {"TaggingRules", 135469, 3419},
  {"XMLData", 135792, 3426},
  {"Box Options", 136119, 3433},
  {"Boxes", 136448, 3440},
  {"CellOptions", 136783, 3447},
  {"NotebookOptions", 137122, 3454},
  {"RowBox", 137452, 3461},
  {"GridBox", 137783, 3468},
  {"OptionValueBox", 138121, 3475},
  {"InterpretationBox", 138462, 3482},
  {"TagBox", 138792, 3489},
  {"FormBox", 139123, 3496},
  {"StyleBox", 139455, 3503},
  {"CounterBox", 139789, 3510},
  {"ValueBox", 140121, 3517},
  {"NotebookML Annotations", 140467, 3524},
  {"BoxFormats", 140813, 3532},
  {"GraphicsFormats", 141117, 3539},
  {"NotebookML Stylesheets", 141438, 3546},
  {"Stylesheets", 141707, 3551},
  {"Processing NotebookML", 141986, 3556},
  {"NotebookML Conversion", 142646, 3572},
  {"Preprocessing NotebookML", 142843, 3577},
  {"Postprocessing NotebookML", 143020, 3581},
  {"NotebookML Conversion Rules", 143224, 3586},
  {"Exporting NotebookML", 143408, 3591},
  {"NotebookML Export Conversion Options", 143710, 3597},
  {"Export Conversion Options", 144497, 3615},
  {"Displaying NotebookML using CSS", 145290, 3633},
  {"CSS", 145428, 3636},
  {"MathML Syntax", 145576, 3639},
  {"Presentation MathML", 145959, 3646},
  {"Content MathML", 146102, 3649},
  {"Importing MathML", 146242, 3652},
  {"MathML Import Conversion Options", 146519, 3657},
  {"Generating MathML", 146671, 3660},
  {"BoxesToMathML", 146914, 3665},
  {"ExpressionToMathML", 147258, 3672},
  {"BoxesToSymbolicMathML", 147610, 3679},
  {"ExpressionToSymbolicMathML", 147970, 3686},
  {"Exporting MathML", 148325, 3693},
  {"MathML Export Conversion Options", 149240, 3714},
  {"MathML Formats", 150027, 3733},
  {"MathML Annotations", 150234, 3738},
  {"MathML Namespace Prefixes", 150476, 3744},
  {"Symbols for MathML Elements", 150726, 3750},
  {"MathML Elements", 150887, 3754},
  {"XML Import Conversion Options", 151062, 3758},
  {"NormalizeWhitespace", 152883, 3798},
  {"Whitespace", 153079, 3803},
  {"AllowRemoteDTDAccess", 153285, 3808},
  {"Remote DTD Access", 153503, 3813},
  {"DTD", 153707, 3818},
  {"AllowUnrecognizedEntities", 154329, 3832},
  {"Unrecognized Entities", 154565, 3837},
  {"ReadDTD", 154787, 3842},
  {"External DTD", 154986, 3847},
  {"External Subset", 155188, 3852},
  {"ValidateAgainstDTD", 155393, 3857},
  {"IncludeDefaultedAttributes", 155646, 3863},
  {"IncludeEmbeddedObjects", 155847, 3868},
  {"Comments", 156129, 3874},
  {"Processing Instructions", 156426, 3880},
  {"Embedded Objects", 156716, 3886},
  {"Objects", 156997, 3892},
  {"IncludeNamespaces", 157288, 3898},
  {"Scoping", 157530, 3904},
  {"Non-compliant XML documents", 157792, 3910},
  {"SymbolicXMLQ", 158039, 3916},
  {"XML Functions", 158156, 3919},
  {"ToSymbolicXML", 160286, 3962},
  {"FromSymbolicXML", 160406, 3965},
  {"ToVerboseXML", 160525, 3968},
  {"ToCompactXML", 160641, 3971},
  {"ReleaseXMLParser", 160761, 3974},
  {"NotebookToSymbolicNotebookML", 160897, 3977},
  {"ExpressionToSymbolicExpressionML", 161049, 3980},
  {"SymbolicNotebookMLToNotebook", 161201, 3983},
  {"SymbolicExpressionMLToExpression", 161353, 3986},
  {"MathMLToBoxes", 161490, 3989},
  {"MathMLToExpression", 161613, 3992},
  {"SymbolicMathMLToBoxes", 161744, 3995},
  {"SymbolicMathMLToExpression", 161883, 3998},
  {"MathMLForm", 162011, 4001}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 73, 1, 41, "IndexSection",
  CellTags->"MasterIndexHeading"],
Cell[1830, 54, 361, 11, 16, "Index",
  CellTags->{"XML and Mathematica", "XML"}],
Cell[2194, 67, 291, 9, 16, "IndexSubentry",
  CellTags->{
  "Native XML Formats", "XML and Mathematica", "XML", "MathML", "NotebookML", 
    "ExpressionML"}],
Cell[2488, 78, 208, 6, 16, "Index",
  CellTags->{"Native XML Formats", "XML and Mathematica", "XML", "MathML"}],
Cell[2699, 86, 219, 7, 16, "Index",
  CellTags->{
  "Native XML Formats", "XML and Mathematica", "XML", "NotebookML"}],
Cell[2921, 95, 223, 7, 16, "Index",
  CellTags->{
  "Native XML Formats", "XML and Mathematica", "XML", "ExpressionML"}],
Cell[3147, 104, 233, 6, 16, "Index",
  CellTags->{"Importing XML", "Import", "XML and Mathematica", "XML"}],
Cell[3383, 112, 211, 6, 16, "Index",
  CellTags->{"Importing XML", "Import", "XML Import"}],
Cell[3597, 120, 195, 6, 16, "IndexSubentry",
  CellTags->{"Importing XML", "XML Import", "Import"}],
Cell[3795, 128, 331, 10, 16, "IndexSubentry",
  CellTags->{
  "Importing XML", "Defaults", "Overriding Defaults", "XML Import", 
    "XML Import Defaults", "Import"}],
Cell[4129, 140, 279, 8, 16, "IndexSubentry",
  CellTags->{
  "Importing XML", "Import File Extensions", "File Extensions", "Extensions", 
    "Import"}],
Cell[4411, 150, 218, 7, 16, "IndexSubentry",
  CellTags->{"Import", "ImportString", "Importing XML"}],
Cell[4632, 159, 286, 9, 16, "IndexSubentry",
  CellTags->{
  "Import", "ImportString", "Defaults", "XML ImportString Defaults", 
    "Importing XML"}],
Cell[4921, 170, 371, 10, 16, "IndexSubentry",
  CellTags->{
  "Importing XML", "Defaults", "Overriding Defaults", "Overriding Defaults", 
    "XML Import", "XML ImportString Defaults", "Import"}],
Cell[5295, 182, 194, 7, 16, "IndexSubentry",
  CellTags->{"Importing XML", "XMLGet"}],
Cell[5492, 191, 331, 9, 16, "IndexSubentry",
  CellTags->{
  "Import", "Importing XML", "XMLGet", "XMLGet Conversion Options", 
    "ImportConversionOptions", "ConversionOptions"}],
Cell[5826, 202, 244, 7, 16, "IndexSubentry",
  CellTags->{"Import", "ImportString", "XMLGetString", "Importing XML"}],
Cell[6073, 211, 366, 10, 16, "IndexSubentry",
  CellTags->{
  "Import", "Importing XML", "XMLGetString", 
    "XMLGetString Conversion Options", "ImportConversionOptions", 
    "ConversionOptions"}],
Cell[6442, 223, 415, 14, 16, "Index",
  CellTags->{
  "Importing XML", "Import", "XMLGet", "XMLGetString", "URL", 
    "Import from URL", "Importing over HTTP", "XML Import", 
    "Import from Website"}],
Cell[6860, 239, 336, 9, 16, "IndexSubentry",
  CellTags->{
  "Import", "Importing XML", "XML Conversion Options", 
    "Import Conversion Options", "Conversion Options", "Options"}],
Cell[7199, 250, 310, 9, 16, "IndexSubentry",
  CellTags->{
  "Import", "ImportString", "Importing XML", "Entities and Validation", 
    "Unicode", "Entities", "Validation"}],
Cell[7512, 261, 434, 11, 16, "IndexSubentry",
  CellTags->{
  "Entities", "Validation", "Entities and Validation", "Import", 
    "Import Conversion Options", "Options", "Conversion Options", 
    "XMLGet Conversion Options", "ImportConversionOptions", 
    "ConversionOptions"}],
Cell[7949, 274, 426, 11, 16, "IndexSubentry",
  CellTags->{
  "Validation", "Entities and Validation", "Import", 
    "Import Conversion Options", "Options", "Conversion Options", 
    "XMLGet Conversion Options", "ImportConversionOptions", 
    "ConversionOptions"}],
Cell[8378, 287, 371, 9, 16, "IndexSubentry",
  CellTags->{
  "XMLGet", "URL", "Import from URL", "Importing over HTTP", "XML Import", 
    "Import from Website", "InitializeXMLParser", "Importing XML", 
    "Entities and Validation"}],
Cell[8752, 298, 215, 6, 16, "Index",
  CellTags->{"SymbolicXML", "XML and Mathematica", "XML"}],
Cell[8970, 306, 249, 8, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "SymbolicXML Syntax", "XML and Mathematica", "XML"}],
Cell[9222, 316, 306, 10, 16, "IndexSubentry",
  CellTags->{"SymbolicXML", "J/Link", "SymbolicXML and J/Link"}],
Cell[9531, 328, 256, 7, 16, "IndexSubentry",
  CellTags->{"SymbolicXML", "Tree Structure", "XML and Mathematica", "XML"}],
Cell[9790, 337, 227, 7, 16, "IndexSubentry",
  CellTags->{"SymbolicXML", "XSLT", "SymbolicXML and XSLT", "XSLT"}],
Cell[10020, 346, 219, 7, 16, "IndexSubentry",
  CellTags->{"SymbolicXML", "SymbolicXML and Java", "Java"}],
Cell[10242, 355, 215, 7, 16, "IndexSubentry",
  CellTags->{"SymbolicXML", "SymbolicXML and SAX", "SAX"}],
Cell[10460, 364, 231, 7, 16, "IndexSubentry",
  CellTags->{"SymbolicXML", "SymbolicXML and DOM API", "DOM API"}],
Cell[10694, 373, 231, 7, 16, "IndexSubentry",
  CellTags->{"SymbolicXML", "Pattern Matching"}],
Cell[10928, 382, 243, 7, 16, "IndexSubentry",
  CellTags->{"SymbolicXML", "SymbolicXML Workflow", "Workflow"}],
Cell[11174, 391, 283, 9, 16, "Index",
  CellTags->{
  "SymbolicXML", "SymbolicXML Syntax", "Element", "XMLElement", 
    "XML and Mathematica", "XML"}],
Cell[11460, 402, 318, 9, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XML and Mathematica", "XML", "Element", "XMLElement", 
    "SymbolicXML Syntax", "XMLElement Syntax"}],
Cell[11781, 413, 313, 9, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "Element", "XMLElement Argument", "Argument", 
    "SymbolicXML Syntax", "XMLElement Syntax"}],
Cell[12097, 424, 333, 9, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLElement", "XML Child Elements", "Child Elements", 
    "Element", "SymbolicXML Syntax", "XMLElement Syntax"}],
Cell[12433, 435, 324, 9, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLElement", "Element", "SymbolicXML Syntax", 
    "XMLElement Commands", "Nesting Commands"}],
Cell[12760, 446, 304, 9, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLElement", "XMLElement Names", "Names", 
    "SymbolicXML Syntax", "XMLElement Syntax"}],
Cell[13067, 457, 319, 9, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLElement Namespaces", "XMLElement", "SymbolicXML Syntax", 
    "XMLElement Syntax"}],
Cell[13389, 468, 354, 9, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "Default Namespaces", "XMLElement", "Namespace Prefixes", 
    "SymbolicXML Syntax", "XMLElement Syntax"}],
Cell[13746, 479, 357, 9, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "Explicit Namespaces", "XMLElement", "Namespace Prefixes", 
    "SymbolicXML Syntax", "XMLElement Syntax"}],
Cell[14106, 490, 238, 7, 16, "Index",
  CellTags->{"SymbolicXML", "XML and Mathematica", "XML", "XMLObject"}],
Cell[14347, 499, 304, 9, 16, "Index",
  CellTags->{
  "SymbolicXML", "XMLGet Conversion Options", "Conversion Options", 
    "Import Conversion Options", "XMLObject"}],
Cell[14654, 510, 311, 9, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XML and Mathematica", "XML", "XMLObject", 
    "SymbolicXML Syntax", "XMLObject Syntax"}],
Cell[14968, 521, 263, 8, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLObject", "Declaration", "XML Declaration", 
    "Declaration Options"}],
Cell[15234, 531, 247, 5, 15, "IndexSubentry",
  CellTags->{
  "Standalone", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
    "Declaration Options", "XMLObject Syntax"}],
Cell[15484, 538, 243, 5, 15, "IndexSubentry",
  CellTags->{
  "Encoding", "XMLObject", "SymbolicXML Syntax", "XML Declaration", 
    "Declaration Options", "XMLObject Syntax"}],
Cell[15730, 545, 216, 6, 16, "IndexSubentry",
  CellTags->{"SymbolicXML", "XMLObject", "Comment", "XML Comment"}],
Cell[15949, 553, 220, 6, 16, "IndexSubentry",
  CellTags->{"SymbolicXML", "XMLObject", "Document", "XML Document"}],
Cell[16172, 561, 216, 6, 16, "IndexSubentry",
  CellTags->{"SymbolicXML", "XMLObject", "DOCTYPE", "XML DOCTYPE"}],
Cell[16391, 569, 212, 5, 15, "IndexSubentry",
  CellTags->{
  "XML`Parser", "XML and Mathematica", "XML", "XMLGet", "XMLGetString", 
    "Context"}],
Cell[16606, 576, 231, 5, 15, "IndexSubentry",
  CellTags->{
  "System", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
    "DOCTYPE Options", "XMLObject Syntax"}],
Cell[16840, 583, 231, 5, 15, "IndexSubentry",
  CellTags->{
  "Public", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
    "DOCTYPE Options", "XMLObject Syntax"}],
Cell[17074, 590, 235, 5, 15, "IndexSubentry",
  CellTags->{
  "Internal", "XMLObject", "SymbolicXML Syntax", "XML DOCTYPE", 
    "DOCTYPE Options", "XMLObject Syntax"}],
Cell[17312, 597, 284, 8, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLObject", "Procession Instruction", 
    "XML Processing Instruction"}],
Cell[17599, 607, 280, 8, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "XMLObject", "CDATA", "Character Data", "XML CDATASection", 
    "PreserveCDATASections"}],
Cell[17882, 617, 198, 7, 16, "Index",
  CellTags->{"XHTML", "MathML"}],
Cell[18083, 626, 397, 13, 16, "Index",
  CellTags->{
  "Namespaces", "DTDs and Namespaces", "Handling Namespaces", 
    "SymbolicXML and Namespaces"}],
Cell[18483, 641, 304, 9, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXML", "Representing Other Objects", "XML Constructs", 
    "XML and Mathematica", "XML"}],
Cell[18790, 652, 279, 9, 16, "Index",
  CellTags->{
  "Transforming XML", "XML and Mathematica", "SymbolicXML", 
    "Processing XML Data"}],
Cell[19072, 663, 324, 9, 16, "IndexSubentry",
  CellTags->{
  "Visualizing the XML Tree", "Transforming XML", "XML and Mathematica", 
    "XML", "Tree Structure", "Notebook", "SymbolicXML"}],
Cell[19399, 674, 329, 9, 16, "IndexSubentry",
  CellTags->{
  "Manipulating Data", "Manipulating XML Data", "Transforming XML", 
    "XML and Mathematica", "XML Data", "Pattern Matching"}],
Cell[19731, 685, 292, 9, 16, "IndexSubentry",
  CellTags->{
  "XML Data", "Visualizing XML Data", "Transforming XML", 
    "XML and Mathematica", "MoDL"}],
Cell[20026, 696, 401, 10, 16, "IndexSubentry",
  CellTags->{
  "XSLT", "XSLT and Mathematica", "Transforming XML", "XML and Mathematica", 
    "Converting", "XML", "Ancestor Elements", "Elements", "Sibling Elements", 
    "Child Elements", "Predicates"}],
Cell[20430, 708, 262, 7, 16, "IndexSubentry",
  CellTags->{
  "HTML", "Notebook", "XML", "Notebook to HTML", "Transforming XML"}],
Cell[20695, 717, 381, 9, 16, "IndexSubentry",
  CellTags->{
  "SymbolicXMLErrors", "Errors", "XML Errors", "SymbolicXML", 
    "SymbolicXML Syntax", "Verifying SymbolicXML Syntax", "Transforming XML", 
    "Part", "Extract"}],
Cell[21079, 728, 285, 9, 16, "Index",
  CellTags->{
  "Exporting XML", "Export", "SymbolicXML", "XML and Mathematica", "XML", 
    "Export File Formats"}],
Cell[21367, 739, 203, 7, 16, "IndexSubentry",
  CellTags->{"Export", "Exporting XML", "XML and Mathematica"}],
Cell[21573, 748, 271, 9, 16, "IndexSubentry",
  CellTags->{
  "Export", "ExportString", "Exporting XML", "XML and Mathematica", 
    "SymbolicXML", "XML"}],
Cell[21847, 759, 273, 7, 16, "IndexSubentry",
  CellTags->{"Export", "Exporting XML", "XML Export Conversion Options"}],
Cell[22123, 768, 213, 4, 15, "Index",
  CellTags->{
  "CheckXML", "Export", "Exporting XML", "XML Export Conversion Options"}],
Cell[22339, 774, 199, 3, 15, "Index",
  CellTags->{
  "ElementFormatting", "Element Formatting", "Element", "Export"}],
Cell[22541, 779, 192, 4, 15, "Index",
  CellTags->{
  "Entities", "Export", "Exporting XML", "XML Export Conversion Options"}],
Cell[22736, 785, 205, 4, 15, "Index",
  CellTags->{
  "Annotations", "Export", "Exporting XML", 
    "XML Export Conversion Options"}],
Cell[22944, 791, 254, 7, 16, "Index",
  CellTags->{
  "NotebookML:Introduction", "XML and Mathematica", "NotebookML", "XML"}],
Cell[23201, 800, 298, 9, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Syntax", "XML and Mathematica", "XML", 
    "NotebookML Elements", "NotebookML Attributes"}],
Cell[23502, 811, 302, 9, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Syntax", "NotebookML Elements", "Notebook", 
    "Elements", "Cell"}],
Cell[23807, 822, 372, 9, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Syntax", "NotebookML Elements", "String", 
    "Element", "List", "Number", "Symbol", "Options", "Option Elements"}],
Cell[24182, 833, 375, 10, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Syntax", "List Types", "String", "Color Values", 
    "Suboptions", "Number", "Symbol", "Options", 
    "NotebookML Front End Options"}],
Cell[24560, 845, 366, 7, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Syntax", "BoxData", "GraphicsData", 
    "CellGroupData", "OutputFormData", "TextData", "StyleData", 
    "TaggingRules", "XMLData", "XML Data", "Options", 
    "NotebookML Front End Options"}],
Cell[24929, 854, 359, 7, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Syntax", "Box Options", "Boxes", "CellOptions", 
    "NotebookOptions", "RowBox", "GridBox", "OptionValueBox", 
    "InterpretationBox", "TagBox", "FormBox", "StyleBox", "CounterBox", 
    "ValueBox"}],
Cell[25291, 863, 244, 7, 16, "IndexSubentry",
  CellTags->{"NotebookML", "Import", "XML and Mathematica"}],
Cell[25538, 872, 232, 7, 16, "IndexSubentry",
  CellTags->{"NotebookML Annotations", "NotebookML"}],
Cell[25773, 881, 217, 8, 16, "IndexSubentry",
  CellTags->{"BoxFormats", "NotebookML"}],
Cell[25993, 891, 212, 7, 16, "IndexSubentry",
  CellTags->{"GraphicsFormats", "NotebookML"}],
Cell[26208, 900, 247, 7, 16, "IndexSubentry",
  CellTags->{"NotebookML Stylesheets", "NotebookML", "Stylesheets"}],
Cell[26458, 909, 231, 7, 16, "IndexSubentry",
  CellTags->{"DTDs and Namespaces", "NotebookML"}],
Cell[26692, 918, 287, 9, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "Processing NotebookML", "SymbolicXML", 
    "NotebookML Conversion"}],
Cell[26982, 929, 279, 8, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "Processing NotebookML", "Preprocessing NotebookML"}],
Cell[27264, 939, 303, 9, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "Processing NotebookML", "Postprocessing NotebookML", 
    "SymbolicXML"}],
Cell[27570, 950, 291, 8, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "Processing NotebookML", "NotebookML Conversion Rules"}],
Cell[27864, 960, 245, 7, 16, "IndexSubentry",
  CellTags->{"NotebookML", "Exporting NotebookML", "Export"}],
Cell[28112, 969, 309, 8, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "Exporting NotebookML", "ExportString", "Export"}],
Cell[28424, 979, 336, 9, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Export Conversion Options", 
    "Export Conversion Options"}],
Cell[28763, 990, 335, 9, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "NotebookML Annotations", "Annotations", 
    "NotebookML Export Conversion Options", "Export Conversion Options"}],
Cell[29101, 1001, 288, 9, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "BoxFormats", "NotebookML Export Conversion Options", 
    "Export Conversion Options"}],
Cell[29392, 1012, 308, 9, 16, "IndexSubentry",
  CellTags->{
  "NotebookML", "GraphicsFormats", "NotebookML Export Conversion Options", 
    "Export Conversion Options"}],
Cell[29703, 1023, 258, 7, 16, "IndexSubentry",
  CellTags->{"NotebookML", "Stylesheets", "NotebookML Stylesheets"}],
Cell[29964, 1032, 276, 7, 16, "IndexSubentry",
  CellTags->{"NotebookML", "Displaying NotebookML using CSS", "CSS"}],
Cell[30243, 1041, 188, 6, 16, "Index",
  CellTags->{"MathML", "XML and Mathematica"}],
Cell[30434, 1049, 219, 7, 16, "IndexSubentry",
  CellTags->{"MathML", "MathML Syntax", "XML and Mathematica"}],
Cell[30656, 1058, 244, 7, 16, "IndexSubentry",
  CellTags->{"MathML", "MathML Syntax", "Presentation MathML"}],
Cell[30903, 1067, 224, 7, 16, "IndexSubentry",
  CellTags->{"MathML", "MathML Syntax", "Content MathML"}],
Cell[31130, 1076, 225, 7, 16, "IndexSubentry",
  CellTags->{"MathML", "Import", "Importing MathML"}],
Cell[31358, 1085, 289, 7, 16, "IndexSubentry",
  CellTags->{"Importing MathML", "MathML Import Conversion Options"}],
Cell[31650, 1094, 331, 9, 16, "IndexSubentry",
  CellTags->{
  "MathML", "Generating MathML", "BoxesToMathML", "ExpressionToMathML", 
    "BoxesToSymbolicMathML", "ExpressionToSymbolicMathML", "Export"}],
Cell[31984, 1105, 225, 7, 16, "IndexSubentry",
  CellTags->{"MathML", "Exporting MathML", "Export"}],
Cell[32212, 1114, 312, 8, 16, "IndexSubentry",
  CellTags->{
  "MathML", "Exporting MathML", "Export", 
    "MathML Export Conversion Options"}],
Cell[32527, 1124, 280, 9, 16, "IndexSubentry",
  CellTags->{
  "MathML", "Exporting MathML", "Export", "MathML Export Conversion Options", 
    "MathML Formats"}],
Cell[32810, 1135, 311, 9, 16, "IndexSubentry",
  CellTags->{
  "MathML", "Exporting MathML", "Export", "MathML Export Conversion Options", 
    "MathML Annotations", "Annotations"}],
Cell[33124, 1146, 339, 9, 16, "IndexSubentry",
  CellTags->{
  "MathML", "Exporting MathML", "Export", "MathML Export Conversion Options", 
    "MathML Namespace Prefixes", "Namespaces"}],
Cell[33466, 1157, 265, 7, 16, "IndexSubentry",
  CellTags->{"MathML", "Symbols for MathML Elements", "MathML Elements"}],
Cell[33734, 1166, 244, 5, 15, "Index",
  CellTags->{
  "XML Import Conversion Options", "NormalizeWhitespace", 
    "Import Conversion Options", "Whitespace"}],
Cell[33981, 1173, 261, 5, 15, "Index",
  CellTags->{
  "XML Import Conversion Options", "Import Conversion Options", 
    "AllowRemoteDTDAccess", "Remote DTD Access", "DTD"}],
Cell[34245, 1180, 285, 5, 15, "Index",
  CellTags->{
  "XML Import Conversion Options", "AllowUnrecognizedEntities", "Entities", 
    "Unrecognized Entities", "Import Conversion Options"}],
Cell[34533, 1187, 221, 5, 15, "Index",
  CellTags->{
  "XML Import Conversion Options", "ReadDTD", "DTD", "External DTD", 
    "Validation", "External Subset"}],
Cell[34757, 1194, 274, 5, 15, "Index",
  CellTags->{
  "XML Import Conversion Options", "Import Conversion Options", 
    "ValidateAgainstDTD", "DTD", "Validation", "DOCTYPE", "Declaration"}],
Cell[35034, 1201, 251, 5, 15, "Index",
  CellTags->{
  "IncludeDefaultedAttributes", "XML Import Conversion Options", 
    "Import Conversion Options"}],
Cell[35288, 1208, 334, 6, 15, "Index",
  CellTags->{
  "XML Import Conversion Options", "IncludeEmbeddedObjects", "Comments", 
    "Processing Instructions", "Embedded Objects", "Objects", 
    "Import Conversion Options", "Pattern Matching"}],
Cell[35625, 1216, 280, 5, 15, "Index",
  CellTags->{
  "XML Import Conversion Options", "IncludeNamespaces", "Namespaces", 
    "Scoping", "Import Conversion Options", "Non-compliant XML documents"}],
Cell[35908, 1223, 236, 5, 15, "Index",
  CellTags->{
  "XML Import Conversion Options", "PreserveCDATASections", 
    "Import Conversion Options"}],
Cell[36147, 1230, 156, 3, 15, "Index",
  CellTags->{"SymbolicXMLQ", "XML Functions"}],
Cell[36306, 1235, 128, 2, 15, "Index",
  CellTags->{"ToSymbolicXML", "XML Functions"}],
Cell[36437, 1239, 132, 2, 15, "Index",
  CellTags->{"FromSymbolicXML", "XML Functions"}],
Cell[36572, 1243, 126, 2, 15, "Index",
  CellTags->{"ToVerboseXML", "XML Functions"}],
Cell[36701, 1247, 126, 2, 15, "Index",
  CellTags->{"ToCompactXML", "XML Functions"}],
Cell[36830, 1251, 193, 4, 15, "Index",
  CellTags->{
  "SymbolicXMLErrors", "Transforming XML", "XML Errors", "SymbolicXML", 
    "XML Functions"}],
Cell[37026, 1257, 134, 2, 15, "Index",
  CellTags->{"ReleaseXMLParser", "XML Functions"}],
Cell[37163, 1261, 158, 2, 15, "Index",
  CellTags->{"NotebookToSymbolicNotebookML", "XML Functions"}],
Cell[37324, 1265, 166, 2, 15, "Index",
  CellTags->{"XML Functions", "ExpressionToSymbolicExpressionML"}],
Cell[37493, 1269, 158, 2, 15, "Index",
  CellTags->{"SymbolicNotebookMLToNotebook", "XML Functions"}],
Cell[37654, 1273, 166, 2, 15, "Index",
  CellTags->{"SymbolicExpressionMLToExpression", "XML Functions"}],
Cell[37823, 1277, 128, 2, 15, "Index",
  CellTags->{"BoxesToMathML", "XML Functions"}],
Cell[37954, 1281, 128, 2, 15, "Index",
  CellTags->{"MathMLToBoxes", "XML Functions"}],
Cell[38085, 1285, 138, 2, 15, "Index",
  CellTags->{"ExpressionToMathML", "XML Functions"}],
Cell[38226, 1289, 138, 2, 15, "Index",
  CellTags->{"MathMLToExpression", "XML Functions"}],
Cell[38367, 1293, 144, 2, 15, "Index",
  CellTags->{"SymbolicMathMLToBoxes", "XML Functions"}],
Cell[38514, 1297, 144, 2, 15, "Index",
  CellTags->{"BoxesToSymbolicMathML", "XML Functions"}],
Cell[38661, 1301, 154, 2, 15, "Index",
  CellTags->{"ExpressionToSymbolicMathML", "XML Functions"}],
Cell[38818, 1305, 154, 2, 15, "Index",
  CellTags->{"SymbolicMathMLToExpression", "XML Functions"}],
Cell[38975, 1309, 122, 2, 15, "Index",
  CellTags->{"MathMLForm", "XML Functions"}]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

