(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    776352,      23224]*)
(*NotebookOutlinePosition[   1319612,      34217]*)
(*  CellTagsIndexPosition[   1311797,      33968]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["XML Capabilities", "Chapter"],

Cell[CellGroupData[{

Cell[TextData[{
  "1. XML and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section",
  PageBreakAbove->True],

Cell[CellGroupData[{

Cell[TextData[{
  "XML and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Subsection",
  CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.2 and later includes comprehensive support for ",
  ButtonBox["XML",
    ButtonData:>{
      URL[ "http://www.w3.org/TR/REC-xml"], None},
    ButtonStyle->"Hyperlink"],
  ", the metamarkup language developed by the ",
  ButtonBox["World Wide Web Consortium (W3C)",
    ButtonData:>{
      URL[ "http://www.w3c.org"], None},
    ButtonStyle->"Hyperlink"],
  " for describing structured documents and data. Using the new XML features \
introduced in Version 4.2, you can do any of the following:"
}], "Text",
  CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],

Cell[TextData[{
  "Import any arbitrary XML document into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in the form of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression."
}], "BulletedList",
  CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],

Cell[TextData[{
  "Analyze the contents of the XML document or transform its structure using \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s sophisticated programming and symbolic manipulation \
abilities."
}], "BulletedList",
  CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],

Cell["\<\
Export the resulting expression back as an XML document to share it \
with other users and applications.\
\>", "BulletedList",
  CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],

Cell[TextData[{
  "Save ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebooks in an XML format using the new NotebookML Document Type \
Definition (DTD) defined for this purpose."
}], "BulletedList",
  CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],

Cell["\<\
Import, export, and evaluate equations in MathML\[LongDash]the new \
standard for representing math on the web. \
\>", "BulletedList",
  CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],

Cell[TextData[{
  "These new features make ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " a powerful development environment for creating and processing XML \
documents. They ensure complete interoperability between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and other XML applications, and between notebooks and other XML document \
formats. "
}], "Text",
  CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Native XML Formats", "Subsection",
  CellTags->{"NativeXMLFormats", "b:0.1"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has built-in support for four XML formats: MathML, SVG, NotebookML, and \
ExpressionML. If you import a document in any of these formats, it is \
automatically converted into a specific type of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression. A NotebookML file is imported as a notebook expression. An \
ExpressionML file is imported as a cell expression. A MathML file is returned \
as a box expression. More details about each of these formats are given \
below."
}], "Text",
  CellTags->{"NativeXMLFormats", "b:0.1"}],

Cell[CellGroupData[{

Cell["MathML", "Subsubsection",
  CellTags->{"NativeXMLFormats", "i:2", "b:0.1"}],

Cell[TextData[{
  "MathML is an XML format developed by the W3C for describing the structure \
and meaning of mathematical formulas. It provides a standard way of \
displaying mathematical notation in web pages. Version 4.1 of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " included limited support for import and export of MathML. In Version 4.2 \
and later, the support has been greatly expanded with many new functions for \
generating and manipulating MathML and for converting between MathML and the \
expressions used internally by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to represent mathematics. "
}], "Text",
  CellTags->{"NativeXMLFormats", "i:2", "b:0.1"}],

Cell[TextData[{
  "The new MathML features make ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " an excellent environment for authoring and editing MathML content. You \
can, for example, use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s powerful typesetting system to create properly \
formatted equations and then copy and paste them in MathML format into an \
HTML document for display on the web. You can also import MathML equations \
from other applications and evaluate them using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"NativeXMLFormats", "i:2", "b:0.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["SVG", "Subsubsection",
  CellTags->{"NativeXMLFormats", "i:3", "b:0.1"}],

Cell[TextData[{
  "SVG (Scalable Vector Graphics) is an XML format developed by the W3C for \
describing two-dimensional graphics. SVG images can be rescaled without loss \
of resolution and are usually much smaller in size than comparable JPEG or \
GIF images. SVG files can also be manipulated with a scripting language to \
produce dynamic and interactive graphics. Using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.2 and later, you can directly export any graphics present in a \
notebook, in SVG format.  "
}], "Text",
  CellTags->{"NativeXMLFormats", "i:3", "b:0.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["NotebookML", "Subsubsection",
  CellTags->{"NativeXMLFormats", "i:4", "b:0.1"}],

Cell[TextData[{
  "NotebookML is an XML format developed by Wolfram Research for representing \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebooks. The tags and attributes used in NotebookML are specified by a \
DTD and correspond closely to the structures used in notebook expressions. \
Using NotebookML, you can save your notebooks as well-formed XML documents \
and then import them back into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in a completely lossless way. "
}], "Text",
  CellTags->{"NativeXMLFormats", "i:4", "b:0.1"}],

Cell[TextData[{
  "NotebookML provides a bridge between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and other XML applications, allowing you to use notebooks with standard \
web technologies such as Cascading Style Sheets (CSS) and Extensible \
Stylesheet Language Transformations (XSLT). For example, you can convert a \
notebook into an XML format such as XHTML by performing XSLT transformations \
on the NotebookML source. You can then display the resulting XHTML document \
on the web using CSS style sheets to control its appearance. Support for \
MathML and SVG is built into NotebookML, in that you can choose to save all \
equations in a notebook as MathML and all graphics as SVG when saving the \
notebook as NotebookML."
}], "Text",
  CellTags->{"NativeXMLFormats", "i:4", "b:0.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ExpressionML", "Subsubsection",
  CellTags->{"NativeXMLFormats", "i:5", "b:0.1"}],

Cell[TextData[{
  "ExpressionML is a specialized subset of NotebookML. ExpressionML fragments \
can represent any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression in an XML format. NotebookML uses ExpressionML fragments to \
represent ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions that are embedded within a notebook structure."
}], "Text",
  CellTags->{"NativeXMLFormats", "i:5", "b:0.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SymbolicXML", "Subsection",
  CellTags->{"SymXMLIntro", "b:0.2"}],

Cell[CellGroupData[{

Cell["What is SymbolicXML?", "Subsubsection",
  CellTags->{"i:6", "b:0.2"}],

Cell[TextData[{
  "SymbolicXML is the format used by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for representing XML documents. The conversion from XML to SymbolicXML \
translates the XML document into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression, while preserving its structure. Since both XML documents and \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions have a tree structure, there is a natural mapping from one to \
the other. You can then manipulate the SymbolicXML expression using the \
standard techniques of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming. "
}], "Text",
  CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],

Cell[TextData[{
  "You can import XML data into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using the standard ",
  StyleBox["Import", "Input",
    FontWeight->"Plain"],
  " or ",
  StyleBox["ImportString", "Input",
    FontWeight->"Plain"],
  " functions. You can also control various details of the import process, \
such as how to treat whitespace, whether to recognize entities, or whether to \
validate against a DTD, by specifying conversion options. For more \
information, see ",
  ButtonBox["XML Import Conversion Options",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],

Cell[TextData[{
  " The following command imports an XML data file into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". "
}], "Text",
  CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],

Cell["Import[\"data.xml\",\"XML\"]", "Program",
  FontWeight->"Bold",
  CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],

Cell[TextData[{
  "The result is a SymbolicXML expression, ",
  StyleBox["expr1",
    FontSlant->"Italic"],
  ", which you can then manipulate using standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands. The end result of your transformations is another SymbolicXML \
expression, ",
  StyleBox["expr2.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],

Cell[TextData[{
  StyleBox["expr1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  " \[Rule] ",
  StyleBox["expr2",
    FontFamily->"Times",
    FontSlant->"Italic"]
}], "IndentedText",
  FontWeight->"Bold",
  CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],

Cell[TextData[{
  "Finally, you can export the result as an XML file using the standard ",
  StyleBox["Export", "Input",
    FontWeight->"Plain"],
  " function. "
}], "Text",
  CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],

Cell[TextData[{
  "Export[\"newdata.xml\",",
  StyleBox["expr2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  ",\"XML\"]"
}], "Program",
  FontWeight->"Bold",
  CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],

Cell[TextData[{
  "You can use conversion options to control various details of the export \
process, such as the format of the exported XML,",
  " ",
  "with the ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " feature of the ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " function. For more information, see ",
  ButtonBox["XML Export Conversion Options",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],

Cell[TextData[{
  "The combination of SymbolicXML and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming provides a useful alternative to other techniques for \
manipulating XML documents, such as XSLT transformations or the SAX or DOM \
APIs used with a low-level programming language such as Java. ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "allows you to achieve the same level of flexibility and control in \
processing XML documents. The advantage is that you can leverage ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]",
  "s advanced support for symbolic manipulation and numerical computation to \
do some very complex and sophisticated transformations that would be \
difficult or impossible to do using other methods."
}], "Text",
  CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],

Cell[TextData[{
  "For example, you can use pattern-matching techniques to extract specific \
parts of an XML document, perform numerical computations on the data, and \
then convert the results into 3D graphics for easy visualization. You can \
also define transformations to convert one type of XML application to \
another. For example, you can import a ",
  StyleBox["DocBook",
    FontFamily->"Courier"],
  " document as SymbolicXML and then convert it into XHTML format by defining \
suitable transformation rules to replace one set of element names with \
another set. For some specific examples of useful applications of \
SymbolicXML, see ",
  ButtonBox["Transforming XML",
    ButtonStyle->"AddOnsLinkText"],
  ". "
}], "Text",
  CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],

Cell[TextData[{
  "Support for SymbolicXML is well-integrated with NotebookML, ExpressionML \
and MathML. For example, when importing an XML document as SymbolicXML, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " recognizes if the document is in NotebookML, ExpressionML,  or MathML \
format and automatically converts it into a notebook expression in the case \
of NotebookML,  an expression in the case of ExpressionML, or a typeset box \
expression in the case of MathML. You can also override the default behavior \
and choose to import any of these XML flavors as SymbolicXML if you wish. \
There are also a large number of kernel functions for quickly and easily \
converting between strings, boxes, or expressions on the one hand, and \
NotebookML, MathML or SymbolicXML on the other."
}], "Text",
  CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],

Cell[TextData[{
  "Note that if you prefer to manipulate XML documents using Java directly, \
you can still do so using a ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " add-on package. This package integrates ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " fully with Java, enabling you to call Java commands from ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "or to call ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel functions from Java programs. You can thus have access to both the \
computational abilities of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as well as the low-level programming features and classes of Java, \
combining the two as needed."
}], "Text",
  CellTags->{"SymXMLIntro", "i:6", "b:0.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Representing Elements", "Subsubsection",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell[TextData[{
  "Each element in an XML document corresponds to an ",
  StyleBox["XMLElement", "Input",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " command in SymbolicXML. An XML expression of the form"
}], "Text",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell[TextData[{
  StyleBox["<",
    FontFamily->"Courier"],
  StyleBox["element",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontFamily->"Courier"],
  StyleBox["attribute",
    FontSlant->"Italic"],
  StyleBox["='",
    FontFamily->"Courier"],
  StyleBox["value'",
    FontSlant->"Italic"],
  StyleBox[">",
    FontFamily->"Courier"],
  StyleBox[" data ",
    FontSlant->"Italic"],
  StyleBox["</",
    FontFamily->"Courier"],
  StyleBox["element",
    FontSlant->"Italic"],
  StyleBox[">",
    FontFamily->"Courier"]
}], "IndentedText",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell["has the following representation in SymbolicXML.", "Text",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell[TextData[{
  StyleBox["XMLElement[",
    FontFamily->"Courier"],
  StyleBox["element",
    FontSlant->"Italic"],
  StyleBox[",{",
    FontFamily->"Courier"],
  StyleBox["attribute",
    FontSlant->"Italic"],
  "\[Rule]",
  StyleBox["value",
    FontSlant->"Italic"],
  StyleBox["},{",
    FontFamily->"Courier"],
  StyleBox["data",
    FontSlant->"Italic"],
  StyleBox["}]",
    FontFamily->"Courier"]
}], "IndentedText",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell[TextData[{
  "Each ",
  StyleBox["XMLElement[]", "Input",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " command has three arguments:"
}], "Text",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell["The first argument specifies the name of the element.", "BulletedList",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell[TextData[{
  "The second argument specifies the attributes of the element. This argument \
is a list of zero or more rules, with each rule specifying a single attribute \
in the form: ",
  StyleBox["attribute ",
    FontSlant->"Italic"],
  "\[Rule] ",
  StyleBox["value",
    FontSlant->"Italic"],
  ". "
}], "BulletedList",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell[TextData[{
  "The third argument specifies the actual data contained in the element. \
This can be raw character data in the form of a string and/or child elements \
of the element being represented. Each child element is represented by its \
own ",
  StyleBox["XMLElement[]", "Input",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " command. You can nest multiple ",
  StyleBox["XMLElement[]", "Input",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  " commands to the level necessary to replicate the nested structure of the \
original XML expression. "
}], "BulletedList",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell[TextData[{
  "The names of all elements and attributes as well as any character data in \
the XML document are represented as strings in SymbolicXML. This is to \
prevent a large number of new symbols from being introduced into the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " session, which could lead to possible naming conflicts. "
}], "Text",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell["Here is a simple XML fragment.", "Text",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell["<book type='novel'>Moby Dick</book>", "Program",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell["Here is the representation of this fragment in SymbolicXML.", "Text",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell["\<\
XMLElement[\"book\",{\"type\"\[Rule]\"novel\"},{\"Moby \
Dick\"}]\
\>", "Program",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell["\<\
Here is a more complicated XML expression, showing several levels \
of nesting.\
\>", "Text",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell["\<\
\t<book type='novel'>
   \t <title>Moby Dick</title>
      <author born='1819' died='1891'>
        <name>
         <first>Herman</first>
         <last>Melville</last>
       </name>
     </author>
    </book>\
\>", "Program",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell["Here is the corresponding SymbolicXML expression.", "Text",
  CellTags->{"XMLElement", "i:7", "b:0.2"}],

Cell["\<\
   XMLElement[\"book\",{\"type\"\[Rule]\"novel\"},{
    XMLElement[\"title\",{},{\"Moby Dick\"}],
    XMLElement[\"author\",{\"born\"\[Rule]\"1819\",\"died\"\[Rule]\"1891\"},{
    XMLElement[\"name\",{},{
      XMLElement[\"first\",{},{\"Herman\"}],
      XMLElement[\"last\",{},{\"Melville\"}]}]}]}]\
\>", "Program",
  CellTags->{"XMLElement", "i:7", "b:0.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Handling Namespaces", "Subsubsection",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell["\<\
If a namespace is specified in an XML element, the syntax of the \
corresponding SymbolicXML expression is slightly more complex. The exact \
syntax depends on whether the namespace is specified implicitly, as a default \
namespace, or explicitly, using a namespace prefix.\
\>", "Text",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell["Using a default namespace", "Subsubsubsection",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell[TextData[{
  "For any element that lies within a default namespace, the ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  " expression is the same as it would be if no namespace was specified. \
However, the element in which the default namespace is declared has its ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  " expression modified, as shown in the following example. "
}], "Text",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell[TextData[{
  "Here is a simple XHTML document with a default namespace declared on the \
",
  StyleBox["html",
    FontFamily->"Courier"],
  " element. "
}], "Text",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell["\<\
<html xmlns='http://www.w3.org/1999/xhtml'>
     <head> </head>
     <body>
     <p>Here is some text.</p>
</body>
</html>\
\>", "Program",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell["Here is the corresponding SymbolicXML expression. ", "Text",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell["\<\
XMLElement[\"html\",{{\"http://www.w3.org/2000/xmlns/\",\"xmlns\"} \
\[Rule] \"http://www.w3.org/1999/xhtml\"},{
XMLElement[\"head\",{},{}],
XMLElement[\"body\",{},{
XMLElement[\"p\",{},{\"Here is some text.\"}]}]}]\
\>", "Program",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell[TextData[{
  "Note that the ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  " expression representing the ",
  StyleBox["html",
    FontFamily->"Courier"],
  " element has a complex structure. Its second argument is:"
}], "Text",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell[TextData[StyleBox["{\"http://www.w3.org/2000/xmlns/\",\"xmlns\"}\[Rule]\"\
http://www.w3.org/1999/xhtml\"}",
  FontFamily->"Courier"]], "Text",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell["This statement accomplishes two things:", "Text",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell[TextData[{
  "It identifies the ",
  StyleBox["xmlns",
    FontFamily->"Courier"],
  " attribute with the namespace defined by the Universal Resource Identifier \
(URI)  ",
  StyleBox["http://www.w3.org/2000/xmlns",
    FontFamily->"Courier"],
  ", as required by the XML specification. "
}], "BulletedList",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell[TextData[{
  "It sets the value of the ",
  StyleBox["xmlns",
    FontFamily->"Courier"],
  " attribute to the URI ",
  StyleBox["http://www.w3.org/1999/xhtml",
    FontFamily->"Courier"],
  ", thus defining the default namespace."
}], "BulletedList",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell[TextData[{
  "In other words, when declaring a default namespace on an element, the \
syntax of the corresponding ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  " structure is:"
}], "Text",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell[TextData[{
  "XMLElement[",
  StyleBox["element", "TI"],
  ",{{",
  StyleBox["xmlns-uri", "TI"],
  ", \"xmlns\"}\[Rule] ",
  StyleBox["namespace-uri", "TI"],
  "},{",
  StyleBox["data", "TI"],
  "}]"
}], "Program",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell[TextData[{
  "Here ",
  StyleBox["xmlns-uri",
    FontSlant->"Italic"],
  " is the URI associated with the namespace of the ",
  StyleBox["xmlns",
    FontFamily->"Courier"],
  " attribute and ",
  StyleBox["namespace-uri",
    FontSlant->"Italic"],
  " is the URI of the default namespace being declared."
}], "Text",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell["Using an explicit namespace prefix", "Subsubsubsection",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell["\<\
If the namespace is specified explicitly on an element using a \
namespace prefix, the syntax of the SymbolicXML expression is modified, as \
shown in the following example. \
\>", "Text",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell[TextData[{
  "Here is an XHTML document with some MathML markup embedded in it. The ",
  StyleBox["xmlns:m",
    FontFamily->"Courier"],
  " attribute in the ",
  StyleBox["math",
    FontFamily->"Courier"],
  " element binds the MathML namespace to the namespace prefix ",
  StyleBox["m", "MR"],
  ". All the MathML element names are then written with this namespace prefix \
attached. "
}], "Text",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell["\<\
<html xmlns='http://www.w3.org/1999/xhtml'>
     <head> <title>Test</title> </head>
       <body>
         <p>Here is some math.</p>
         <p>
           <m:math xmlns:m='http://www.w3.org/1998/Math/MathML'>
             <m:mi>x</m:mi>
             <m:mo>+</m:mo>
             <m:mn>1</m:mn>
          </m:math>
         </p>
     </body>
</html>\
\>", "Program",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell["Here is the corresponding SymbolicXML expression. ", "Text",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell["\<\
XMLElement[\"html\",{{\"http://www.w3.org/2000/xmlns/\",\"xmlns\"} \
\[Rule] \"http://www.w3.org/1999/xhtml\"},{XMLElement[head,{},{}],
     XMLElement[\"body\",{},{
         XMLElement[\"p\",{},{\"Here is some math.\"}],
         XMLElement[\"p\",{},{            \t\
XMLElement[{\"http://www.w3.org/1998/Math/MathML\",\"math\"},{{\"http://www.\
w3.org/2000/xmlns/\",\"m\"}\[Rule]\"http://www.w3.org/1998/Math/MathML\"},{
XMLElement[{\"http://www.w3.org/1998/Math/MathML\",\"mi\"},{},{\"x\"}],
                 XMLElement[{\"http://www.w3.org/1998/Math/MathML\",\"mo\"},{}\
,{\"+\"}],
                 XMLElement[{\"http://www.w3.org/1998/Math/MathML\",\"mn\"},{}\
,{\"1\"}
                   ]}]}]}]}]\
\>", "Program",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell["There are two features to note here.", "Text",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell[TextData[{
  "The first attribute of the ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  " structure for the top-level ",
  StyleBox["math",
    FontFamily->"Courier"],
  " element is ",
  StyleBox["{\"http://www.w3.org/2000/xmlns/\",\"m\"}\[Rule]\"http://www.w3.\
org/1998/Math/MathML\"",
    FontFamily->"Courier"],
  ". This associates the MathML namespace with the prefix ",
  StyleBox["m", "MR"],
  "."
}], "BulletedList",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],

Cell[TextData[{
  "The ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  " structure for each MathML element is of the form: ",
  StyleBox["XMLElement[{",
    FontFamily->"Courier"],
  StyleBox["uri, element",
    FontSlant->"Italic"],
  "}",
  StyleBox[",{},{",
    FontFamily->"Courier"],
  StyleBox["data",
    FontSlant->"Italic"],
  StyleBox["}]",
    FontFamily->"Courier"],
  ", where ",
  StyleBox["uri",
    FontSlant->"Italic"],
  " identifies the MathML namespace. This is the SymbolicXML equivalent of \
writing an element name with the namespace prefix attached."
}], "BulletedList",
  CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Representing Other Objects", "Subsubsection",
  CellTags->{"XMLObject", "i:15", "b:0.2"}],

Cell[TextData[{
  "The ",
  StyleBox["XMLObject",
    FontFamily->"Courier"],
  " expression is used as a container for parts of an XML document other than \
elements, such as comments, processing instructions, or declarations. It is \
also used as a container for the entire document itself. This structure has \
the syntax ",
  StyleBox["XMLObject[", "Input",
    FontWeight->"Plain"],
  StyleBox["object",
    FontSlant->"Italic"],
  StyleBox["][", "Input",
    FontWeight->"Plain"],
  StyleBox["data",
    FontSlant->"Italic"],
  StyleBox["]", "Input",
    FontWeight->"Plain"],
  ", where ",
  StyleBox["object",
    FontSlant->"Italic"],
  " describes the type of object being represented and ",
  StyleBox["data",
    FontSlant->"Italic"],
  " specifies the details of the object. There are six types of objects that \
can be specified as the first argument, each corresponding to a specific type \
of XML construct. "
}], "Text",
  CellTags->{"XMLObject", "i:9", "i:15", "b:0.2"}],

Cell[TextData[StyleBox["Declaration", "Input",
  FontWeight->"Plain"]], "BulletedList",
  CellTags->{"XMLObject", "i:15", "b:0.2"}],

Cell[TextData[StyleBox["Comment", "Input",
  FontWeight->"Plain"]], "BulletedList",
  CellTags->{"XMLObject", "i:15", "b:0.2"}],

Cell[TextData[StyleBox["Document", "Input",
  FontWeight->"Plain"]], "BulletedList",
  CellTags->{"XMLObject", "i:15", "b:0.2"}],

Cell[TextData[StyleBox["Doctype", "Input",
  FontWeight->"Plain"]], "BulletedList",
  CellTags->{"XMLObject", "i:15", "b:0.2"}],

Cell[TextData[StyleBox["ProcessingInstruction", "Input",
  FontWeight->"Plain"]], "BulletedList",
  CellTags->{"XMLObject", "i:15", "b:0.2"}],

Cell[TextData[StyleBox["CDATASection", "Input",
  FontWeight->"Plain"]], "BulletedList",
  CellTags->{"XMLObject", "i:15", "b:0.2"}],

Cell["Declaration", "Subsubsubsection",
  CellTags->{"XMLObject", "i:19", "b:0.2"}],

Cell[TextData[{
  "The ",
  StyleBox["XMLObject[\"Declaration\"]",
    FontFamily->"Courier"],
  " expression is used to represent the XML declaration that typically \
appears at the start of an XML document. This has the following syntax."
}], "Text",
  CellTags->{"XMLObject", "i:10", "i:19", "b:0.2"}],

Cell[TextData[{
  "XMLObject[\"Declaration\"][\"Version\"\[Rule]\"1.0\", ",
  StyleBox["option", "TI"],
  " \[Rule] ",
  StyleBox["value", "TI"],
  "]"
}], "Program",
  CellTags->{"XMLObject", "i:16", "i:19", "b:0.2"}],

Cell["There are two options allowed:", "Text",
  CellTags->{"XMLObject", "i:19", "b:0.2"}],

Cell[TextData[{
  StyleBox["\"Standalone\"",
    FontFamily->"Courier"],
  StyleBox[": t",
    FontFamily->"Times New Roman"],
  "his takes the value ",
  StyleBox["\"yes\"",
    FontFamily->"Courier"],
  " if the document references an external DTD and ",
  StyleBox["\"no\"",
    FontFamily->"Courier"],
  " otherwise."
}], "BulletedList",
  CellTags->{"XMLObject", "i:17", "i:19", "b:0.2"}],

Cell[TextData[{
  StyleBox["\"Encoding\"",
    FontFamily->"Courier"],
  ": this specifies the character encoding used in the document. Not all \
encodings will be honored on export. If an encoding that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " cannot export is specified, an error message is produced and the encoding \
is changed in the document."
}], "BulletedList",
  CellTags->{"XMLObject", "i:19", "b:0.2"}],

Cell["Here is a typical XML declaration.", "Text",
  CellTags->{"XMLObject", "i:19", "b:0.2"}],

Cell["<?xml version=\"1.0\" encoding=\"ascii\" standalone=\"yes\"?>", \
"Program",
  CellTags->{"XMLObject", "i:19", "b:0.2"}],

Cell["Here is the corresponding SymbolicXML expression.", "Text",
  CellTags->{"XMLObject", "i:19", "b:0.2"}],

Cell["\<\
XMLObject[\"Declaration\"][\"Version\"\[Rule]\"1.0\", \"Encoding\"\
\[Rule]\"ascii\" \"Standalone\"\[Rule]\"Yes\"]\
\>", "Program",
  CellTags->{"XMLObject", "i:19", "b:0.2"}],

Cell["Comment", "Subsubsubsection",
  CellTags->{"XMLObject", "i:11", "b:0.2"}],

Cell[TextData[{
  "The ",
  StyleBox["XMLObject[\"Comment\"]",
    FontFamily->"Courier"],
  " ",
  "expression",
  " is used to represent XML comments. It has the following syntax. "
}], "Text",
  CellTags->{"XMLObject", "i:11", "b:0.2"}],

Cell[TextData[{
  "XMLObject[\"c",
  StyleBox["omment", "TI"],
  "\"][\"",
  StyleBox["string\"]", "TI"]
}], "Program",
  CellTags->{"XMLObject", "i:11", "b:0.2"}],

Cell["Here is an example of an XML comment.", "Text",
  CellTags->{"XMLObject", "i:11", "b:0.2"}],

Cell["<!-- Created on 3/6/02. -->", "Program",
  CellTags->{"XMLObject", "i:11", "b:0.2"}],

Cell["Here is the corresponding SymbolicXML expression.", "Text",
  CellTags->{"XMLObject", "i:11", "b:0.2"}],

Cell["XMLObject[\"Comment\"][\"Created on 3/6/02.\"]", "Program",
  CellTags->{"XMLObject", "i:11", "b:0.2"}],

Cell["Document", "Subsubsubsection",
  CellTags->{"XMLObject", "i:20", "b:0.2"}],

Cell[TextData[{
  "The most important ",
  StyleBox["XMLObject",
    FontFamily->"Courier"],
  " is ",
  StyleBox["XMLObject[\"Document\"]",
    FontFamily->"Courier"],
  ". It is used as a container for the entire document and has the following \
syntax."
}], "Text",
  CellTags->{"XMLObject", "i:12", "i:20", "b:0.2"}],

Cell[TextData[{
  "XMLObject[\"Document\"][{",
  StyleBox["prolog", "TI"],
  "}, ",
  StyleBox["document tree", "TI"],
  ", {",
  StyleBox["epilog", "TI"],
  "}]"
}], "Program",
  CellTags->{"XMLObject", "i:20", "b:0.2"}],

Cell[TextData[{
  "The prolog may contain an ",
  StyleBox["XMLObject[\"Declaration\"]",
    FontFamily->"Courier"],
  ", followed by optional processing instructions and",
  " ",
  "DTD declarations. The epilog contains either processing instructions or \
comments."
}], "Text",
  CellTags->{"XMLObject", "i:20", "b:0.2"}],

Cell["\<\
Here is an example of a simple document consisting of an XML \
declaration, a comment, and a single element. \
\>", "Text",
  CellTags->{"XMLObject", "i:20", "b:0.2"}],

Cell["\<\
<?xml version='1.0'?>
<!--this is a sample file-->
<root/>\
\>", "Program",
  CellTags->{"XMLObject", "i:20", "b:0.2"}],

Cell["Here is the corresponding SymbolicXML expression.", "Text",
  CellTags->{"XMLObject", "i:20", "b:0.2"}],

Cell["\<\
XMLObject[\"Document\"][{XMLObject[\"Declaration\"][\"Version\"\
\[Rule]\"1.0\"],XMLObject[\"Comment\"][\"this is a sample \
file\"]},XMLElement[\"root\",{},{}],{}]\
\>", "Program",
  CellTags->{"XMLObject", "i:20", "b:0.2"}],

Cell[TextData[{
  "The only option for ",
  StyleBox["XMLObject[\"Document\"]",
    FontFamily->"Courier"],
  " is ",
  StyleBox["\"Valid\"",
    FontFamily->"Courier"],
  ". This option is set automatically by the parser. If the document was \
validated on import and validation succeeded, then the option ",
  StyleBox["\"Valid\"\[Rule]True",
    FontFamily->"Courier"],
  " will be included in the ",
  StyleBox["XMLObject",
    FontFamily->"Courier"],
  " expression. If validation was attempted but failed, then ",
  StyleBox["\"Valid\"\[Rule]False",
    FontFamily->"Courier"],
  " will be included in the XMLObject. If validation was not attempted, then \
the option is omitted from the ",
  StyleBox["XMLObject",
    FontFamily->"Courier"],
  " expression.."
}], "Text",
  CellTags->{"XMLObject", "i:20", "b:0.2"}],

Cell["Doctype", "Subsubsubsection",
  CellTags->{"XMLObject", "i:14", "b:0.2"}],

Cell[TextData[{
  "The ",
  StyleBox["XMLObject[\"Doctype\"]",
    FontFamily->"Courier"],
  " expression is used to represent XML document type declarations. It has \
the following syntax."
}], "Text",
  CellTags->{"XMLObject", "i:14", "b:0.2"}],

Cell[TextData[{
  "XMLObject[\"Doctype\"][",
  StyleBox["name", "TI"],
  ", ",
  StyleBox["option", "TI"],
  " \[Rule] ",
  StyleBox["value", "TI"],
  "]"
}], "Program",
  CellTags->{"XMLObject", "i:14", "b:0.2"}],

Cell["There are three options allowed:", "Text",
  CellTags->{"XMLObject", "i:14", "b:0.2"}],

Cell[TextData[{
  StyleBox["\"System\"",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  StyleBox[": specifies a DTD in the local file system, either as a relative \
pathname or a URI.",
    FontWeight->"Plain"]
}], "BulletedList",
  FontWeight->"Bold",
  CellTags->{"XMLObject", "i:14", "b:0.2"}],

Cell[TextData[{
  StyleBox["\"Public\"",
    FontFamily->"Courier"],
  ": specifies a standardized name that is used to publicly identify the \
DTD."
}], "BulletedList",
  CellTags->{"XMLObject", "i:14", "b:0.2"}],

Cell[TextData[{
  StyleBox["\"Internal\"",
    FontFamily->"Courier"],
  ":  specifies an internal DTD subset. Its value is a string that contains \
the data in the internal DTD subset."
}], "BulletedList",
  CellTags->{"XMLObject", "i:14", "b:0.2"}],

Cell["\<\
Here is a Doctype declaration that has both a formalized public \
identifier name as well as a specific location for the DTD along, with an \
internal DTD subset.\
\>", "Text",
  CellTags->{"XMLObject", "i:14", "b:0.2"}],

Cell[TextData[{
  "<!DOCTYPE catalog PUBLIC \"-//FOO//DTD catalog 1.1//EN\" \
\"www.foo.com/example/catalog.dtd\"\n   [",
  StyleBox["internal DTD stuff", "TR",
    FontSlant->"Italic"],
  "]>"
}], "Program",
  CellTags->{"XMLObject", "i:14", "b:0.2"}],

Cell["Here is the corresponding SymbolicXML expression.", "Text",
  CellTags->{"XMLObject", "i:14", "b:0.2"}],

Cell[TextData[{
  "XMLObject[\"Doctype\"][\"catalog\", \"Public\"\[Rule]\"-//FOO//DTD catalog \
1.1//EN\", \"System\"\[Rule]\"www.foo.com/example/catalog.dtd\", \
\"InternalSubset\"\[Rule]\"",
  StyleBox["internal DTD stuff", "TR",
    FontSlant->"Italic"],
  "\"]"
}], "Program",
  CellTags->{"XMLObject", "i:14", "b:0.2"}],

Cell[TextData[{
  "For more details on XML ",
  "Doctype declarations, see the ",
  ButtonBox["W3C XML specification",
    ButtonData:>{
      URL[ "http://www.w3.org/TR/REC-xml#NT-doctypedecl"], None},
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text",
  CellTags->{"XMLObject", "i:14", "b:0.2"}],

Cell["ProcessingInstruction", "Subsubsubsection",
  CellTags->{"XMLObject", "i:21", "b:0.2"}],

Cell[TextData[{
  "The ",
  StyleBox["XMLObject[\"ProcessingInstruction\"]",
    FontFamily->"Courier"],
  " expression is used to represent XML processing instructions. This has the \
following syntax."
}], "Text",
  CellTags->{"XMLObject", "i:21", "b:0.2"}],

Cell[TextData[{
  "XMLObject[\"ProcessingInstruction\"][",
  StyleBox["target string", "TI"],
  ", ",
  StyleBox["optional data string", "TI"],
  "]]"
}], "Program",
  CellTags->{"XMLObject", "i:21", "b:0.2"}],

Cell["\<\
It is common to use attribute-like syntax in processing \
instructions. These pseudo-attributes are not parsed but are returned as raw \
strings. Here is a processing instruction that specifies a style sheet.\
\>", \
"Text",
  CellTags->{"XMLObject", "i:21", "b:0.2"}],

Cell["<?xml-stylesheet href=\"mystyle.css\" type=\"text/css\"?>", "Program",
  CellTags->{"XMLObject", "i:21", "b:0.2"}],

Cell["\<\
Here is the corresponding SymbolicXML expression. Notice that the \
double quotes around the attribute values are escaped, to distinguish them \
from the double quotes around the argument as a whole. \
\>", "Text",
  CellTags->{"XMLObject", "i:21", "b:0.2"}],

Cell["\<\
XMLObject[\"ProcessingInstruction\"][\"xml-stylesheet\",
\"href=\\\"mystyle.css\\\" type=\\\"text/css\\\"\"]\
\>", "Program",
  CellTags->{"XMLObject", "i:21", "b:0.2"}],

Cell["CDATASection", "Subsubsubsection",
  CellTags->{"XMLObject", "i:22", "b:0.2"}],

Cell[TextData[{
  "The ",
  StyleBox["XMLObject[\"CDATASection\"]",
    FontFamily->"Courier"],
  " expression is used to represent CDATA sections. CDATA is a W3C \
abbreviation for Character Data. CDATA sections are used in an XML document \
as a wrapper for raw character data to avoid having to escape special \
characters such as ",
  StyleBox["\"",
    FontFamily->"Courier"],
  " and ",
  StyleBox["<",
    FontFamily->"Courier"],
  ". These characters would normally have to be indicated as ",
  StyleBox["&quote;",
    FontFamily->"Courier"],
  " and ",
  StyleBox["&lt;",
    FontFamily->"Courier"],
  ", respectively. CDATA sections are used in XML to enclose character data \
that would require a lot of escaping, such as programs or math expressions. "
}], "Text",
  CellTags->{"XMLObject", "i:22", "b:0.2"}],

Cell["\<\
Here is a simple fragment from an XML document containing a CDATA \
section. \
\>", "Text",
  CellTags->{"XMLObject", "i:22", "b:0.2"}],

Cell["<![CDATA[ 5 < 7 << 2*10^123]]>", "Program",
  CellTags->{"XMLObject", "i:22", "b:0.2"}],

Cell["Here is the corresponding SymbolicXML expression.", "Text",
  CellTags->{"XMLObject", "i:22", "b:0.2"}],

Cell["XMLObject[\"CDATASection\"][\" 5 < 7 << 2*10^123\"]", "Program",
  CellTags->{"XMLObject", "i:22", "b:0.2"}],

Cell[TextData[{
  "By default, CDATASection object wrappers are not preserved on import, and \
only the contents of the CDATA section are retained. To preserve the \
CDATASection wrappers, you must explicitly set the option ",
  StyleBox["\"PreserveCDATASections\"",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  ". "
}], "Text",
  CellTags->{"XMLObject", "i:22", "b:0.2"}],

Cell[TextData[{
  "For more information on the conversion options for importing XML, see ",
  ButtonBox["Import Conversion Options",
    ButtonData:>"ImportConversionOptions",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->{"XMLObject", "i:22", "b:0.2"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["2. Importing XML", "Section",
  PageBreakAbove->True],

Cell[CellGroupData[{

Cell["Functions for Importing XML", "Subsection",
  CellTags->"b:1.0"],

Cell[CellGroupData[{

Cell["Import", "Subsubsection",
  FontFamily->"Courier",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[TextData[{
  "You can import XML data into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using the standard ",
  ButtonBox["Import",
    ButtonStyle->"RefGuideLink"],
  " function, which has the following syntax. "
}], "Text",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[TextData[{
  StyleBox["\tImport[",
    FontFamily->"Courier"],
  StyleBox["file",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[TextData[{
  StyleBox["\tImport[",
    FontFamily->"Courier"],
  StyleBox["file",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["format",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[TextData[{
  "The first argument of the function specifies the file to be imported. You \
can also specify an optional second argument to control the form of the \
output. For importing XML data, the relevant file formats are: ",
  StyleBox["\"XML\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"NotebookML\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"ExpressionML\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"MathML\"",
    FontFamily->"Courier"],
  ",  and ",
  StyleBox["\"SymbolicXML\"",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[TextData[{
  "With ",
  StyleBox["\"XML\"",
    FontFamily->"Courier"],
  " as the import format, any XML formats that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not recognize are returned as SymbolicXML. The three formats that ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "does support on import, namely NotebookML, ExpressionML, and MathML, are \
treated slightly differently. A NotebookML file is imported as a notebook \
expression. An ExpressionML file is imported as the corresponding cell \
expression. A MathML file is returned as the corresponding box expression. "
}], "Text",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[TextData[{
  "With ",
  StyleBox["\"SymbolicXML\"",
    FontFamily->"Courier"],
  " as the import format, even NotebookML, ExpressionML, and MathML files are \
imported as SymbolicXML. This gives you a way to override any interpretation \
beyond just importing as SymbolicXML."
}], "Text",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell["Here is a file containing a simple MathML equation.", "Text",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! eqn.mml\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell["\<\
<math xmlns=\"http://www.w3.org/1998/Math/MathML\">
 <semantics>
  <msup>
   <mi>x</mi>
   <mn>2</mn>
  </msup>
  <annotation-xml encoding=\"MathML-Content\">
   <apply>
    <power/>
    <ci>x</ci>
    <cn type=\"integer\">2</cn>
   </apply>
  </annotation-xml>
 </semantics>
</math>\
\>", "Output",
  CellLabel->"Out[1]=",
  CellTags->{"UsingImport", "i:23", "b:1.0"}]
}, Closed]],

Cell[TextData[{
  "If you import the file and specify ",
  StyleBox["\"XML\"",
    FontFamily->"Courier"],
  " as the second argument, the equation is converted into a box expression."
}], "Text",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Import["\<eqn.mml\>", "\<XML\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[BoxData[
    \(FormBox[
      TagBox[TagBox[SuperscriptBox["x", "2"], "MathMLPresentationTag", 
          AutoDelete \[Rule] True], 
        "AnnotationsTagWrapper"[
          TagBox[SuperscriptBox["x", "2"], "MathMLContentTag", 
            AutoDelete \[Rule] True]], AutoDelete \[Rule] True], 
      TraditionalForm]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"UsingImport", "i:23", "b:1.0"}]
}, Closed]],

Cell[TextData[{
  "If you specify ",
  StyleBox["\"SymbolicXML\"",
    FontFamily->"Courier"],
  " as the second argument, the equation is imported as a SymbolicXML box \
expression."
}], "Text",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Import["\<eqn.mml\>", "\<SymbolicXML\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "math", {{"http://www.w3.org/2000/xmlns/", "xmlns"} \[Rule] 
            "http://www.w3.org/1998/Math/MathML"}, {XMLElement[
            "semantics", {}, {XMLElement[
                "msup", {}, {XMLElement["mi", {}, {"x"}], 
                  XMLElement["mn", {}, {"2"}]}], 
              XMLElement[
                "annotation-xml", {"encoding" \[Rule] 
                    "MathML-Content"}, {XMLElement[
                    "apply", {}, {XMLElement["power", {}, {}], 
                      XMLElement["ci", {}, {"x"}], 
                      XMLElement[
                        "cn", {"type" \[Rule] 
                            "integer"}, {"2"}]}]}]}]}], {}]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"UsingImport", "i:23", "b:1.0"}]
}, Closed]],

Cell[TextData[{
  "If ",
  StyleBox["Import",
    FontFamily->"Courier"],
  " is used with only one argument, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " processes the data in the file based on its file extension. Any file with \
a ",
  StyleBox[".xml",
    FontFamily->"Courier"],
  " extension is imported as XML. This means that if it is in one of the XML \
formats explicitly supported by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", namely NotebookML, ExpressionML, or MathML the file will be interpreted \
in the appropriate way. All other XML formats are imported as SymbolicXML. "
}], "Text",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " also recognizes the ",
  StyleBox[".mml",
    FontFamily->"Courier"],
  " extension for MathML files and the ",
  StyleBox[".nbml", "MR"],
  " extension for NotebookML files. In the following example, we import a \
file with the ",
  StyleBox[".mml", "MR"],
  " extension. "
}], "Text",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Import["\<eqn.mml\>"]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[BoxData[
    \(FormBox[
      TagBox[TagBox[SuperscriptBox["x", "2"], "MathMLPresentationTag", 
          AutoDelete \[Rule] True], 
        "AnnotationsTagWrapper"[
          TagBox[SuperscriptBox["x", "2"], "MathMLContentTag", 
            AutoDelete \[Rule] True]], AutoDelete \[Rule] True], 
      TraditionalForm]\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"UsingImport", "i:23", "b:1.0"}]
}, Closed]],

Cell[TextData[{
  "You can display the above box expression as conventional mathematical \
notation by using ",
  StyleBox["DisplayForm",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(DisplayForm[%]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"UsingImport", "i:23", "b:1.0"}],

Cell[BoxData[
    TagBox[
      FormBox[
        TagBox[
          TagBox[\(x\^2\),
            "MathMLPresentationTag",
            AutoDelete->True],
          "AnnotationsTagWrapper"[ 
            TagBox[ 
              SuperscriptBox[ "x", "2"], "MathMLContentTag", AutoDelete -> 
              True]],
          AutoDelete->True],
        "TraditionalForm"],
      DisplayForm]], "Output",
  CellLabel->"Out[5]//DisplayForm=",
  CellTags->{"UsingImport", "i:23", "b:1.0"}]
}, Closed]],

Cell[TextData[{
  "You can control the various details of the import process, such as how to \
treat whitespace, whether to recognize entities, or whether to validate \
against a DTD, by specifying conversion options to the ",
  StyleBox["Import",
    FontFamily->"Courier"],
  " function. For more information, see ",
  ButtonBox["XML Import Conversion Options",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->{"UsingImport", "i:23", "b:1.0"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ImportString", "Subsubsection",
  FontFamily->"Courier",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}],

Cell[TextData[{
  "You can use the standard ",
  ButtonBox["ImportString",
    ButtonStyle->"RefGuideLink"],
  " function to import XML data from a string. This function has the \
following syntax."
}], "Text",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}],

Cell[TextData[{
  StyleBox["\tImportString[",
    FontFamily->"Courier"],
  StyleBox["string",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["format",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}],

Cell[TextData[{
  "For importing XML data, the relevant file formats are: ",
  StyleBox["\"XML\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"NotebookML\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"ExpressionML\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"MathML\"",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\"SymbolicXML\"",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}],

Cell[TextData[{
  "With ",
  StyleBox["\"XML\"",
    FontFamily->"Courier"],
  " as the import format, any XML formats that ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " does not recognize are returned as SymbolicXML. Here is an example of a \
simple XML expression converted to SymbolicXML using ",
  StyleBox["ImportString",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<person gender='male'><name>Joe \
Smith</name></person>\>", "\<XML\>"]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "person", {"gender" \[Rule] "male"}, {XMLElement[
            "name", {}, {"Joe Smith"}]}], {}]\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}]
}, Closed]],

Cell[TextData[{
  "The three formats that ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "does support, namely NotebookML, ExpressionML, and MathML, are treated \
slightly differently. A NotebookML file is imported as a notebook expression. \
An ExpressionML file is imported as the corresponding cell expression. A \
MathML file is returned as the corresponding box expression. Here is an \
example of importing a simple MathML expression. Notice that the MathML \
markup is automatically converted to a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " box expression. "
}], "Text",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<math><mi>x</mi><mo>+</mo><mn>1</mn></math>\>", \
"\<XML\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}],

Cell[BoxData[
    \(FormBox[
      TagBox[RowBox[{"x", "+", "1"}], "MathMLPresentationTag", 
        AutoDelete \[Rule] True], TraditionalForm]\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}]
}, Closed]],

Cell[TextData[{
  "You can stop the automatic interpretation of imported files based on file \
extension by specifying ",
  StyleBox["\"SymbolicXML\"",
    FontFamily->"Courier"],
  " as the second argument. In this example, the imported file is returned as \
SymbolicXML rather than the usual box expression."
}], "Text",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<math><mi>x</mi><mo>+</mo><mn>1</mn></math>\>", \
"\<SymbolicXML\>"]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "math", {}, {XMLElement["mi", {}, {"x"}], 
          XMLElement["mo", {}, {"+"}], 
          XMLElement["mn", {}, {"1"}]}], {}]\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}]
}, Closed]],

Cell[TextData[{
  "You can control the various details of the import process, such as how to \
treat whitespace, whether to recognize entities, or whether to validate \
against a DTD, by specifying conversion options to the ",
  StyleBox["ImportString",
    FontFamily->"Courier"],
  " function. For more information,",
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  "see ",
  ButtonBox["XML Import Conversion Options",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->{"UsingImportString", "i:24", "b:1.0"}]
}, Closed]],

Cell[CellGroupData[{

Cell["XMLGet", "Subsubsection",
  FontFamily->"Courier",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],

Cell[TextData[{
  "The ",
  StyleBox["XMLGet",
    FontFamily->"Courier"],
  " function can be used to import an XML document as SymbolicXML. It is very \
similar to the ",
  StyleBox["Import",
    FontFamily->"Courier"],
  " function, in that ",
  StyleBox["XMLGet[",
    FontFamily->"Courier"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " is equivalent to ",
  StyleBox["Import[",
    FontFamily->"Courier"],
  StyleBox["file, ",
    FontSlant->"Italic"],
  StyleBox["\"SymbolicXML\"]",
    FontFamily->"Courier"],
  ". ",
  "The advantage of using ",
  StyleBox["XMLGet",
    FontFamily->"Courier"],
  " is that, unlike ",
  StyleBox["Import",
    FontFamily->"Courier"],
  ", it can retrieve files over the web. Hence, it is useful if you want to \
import an XML file posted at a URL. "
}], "Text",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],

Cell["\<\
For example, the following command retrieves stock quotes from a \
website and returns the data as SymbolicXML.\
\>", "Text",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(XML`Parser`XMLGet["\<http://www.xmltoday.com/examples/stockquote/\
getxmlquote.vep?s=amd\>"]\)\(\ \)\)\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "stock_quotes", {}, {XMLElement[
            "stock_quote", {}, {XMLElement["symbol", {}, {"AMD"}], 
              XMLElement[
                "when", {}, {XMLElement["date", {}, {"3/13/2002"}], 
                  XMLElement["time", {}, {"12:13pm"}]}], 
              XMLElement[
                "price", {"type" \[Rule] "ask", 
                  "value" \[Rule] "14.58"}, {}], 
              XMLElement[
                "price", {"type" \[Rule] "open", 
                  "value" \[Rule] "14.85"}, {}], 
              XMLElement[
                "price", {"type" \[Rule] "dayhigh", 
                  "value" \[Rule] "15.36"}, {}], 
              XMLElement[
                "price", {"type" \[Rule] "daylow", 
                  "value" \[Rule] "14.57"}, {}], 
              XMLElement["change", {}, {"-1.17"}], 
              XMLElement["volume", {}, {"4413000"}]}]}], {}]\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}]
}, Closed]],

Cell[TextData[{
  "Note that ",
  StyleBox["XMLGet", "MR"],
  " exists only in the ",
  StyleBox["XML`Parser`",
    FontFamily->"Courier"],
  " context. Hence, you must use the full name of the function, ",
  StyleBox["XML`Parser`XMLGet",
    FontFamily->"Courier"],
  ", when doing an evaluation. To use the function without the context name \
prefix, you must first add the ",
  StyleBox["XML`Parser`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Text",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],

Cell[TextData[{
  StyleBox["XMLGet",
    FontFamily->"Courier"],
  " also accepts an optional second argument, which specifies a \
pre-initialized parser object. "
}], "Text",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],

Cell[TextData[{
  StyleBox["\tXMLGet[",
    FontFamily->"Courier"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["XMLParserObject", "TI"],
  StyleBox["]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],

Cell[TextData[{
  "Initializing the parser involves loading a DTD into memory either from a \
URL or a local file. This only needs to be done once in each kernel session. \
Subsequent references to the DTD are then processed much faster because the \
DTD has already been read and parsed. For more information on initializing \
the parser, see ",
  ButtonBox["InitializeXMLParser",
    ButtonData:>"InitializeXMLParser",
    ButtonStyle->"AddOnsLink"],
  "."
}], "Text",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],

Cell[TextData[{
  "You can also specify ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " for ",
  StyleBox["XMLGet",
    FontFamily->"Courier"],
  " to control the behavior of the function. The conversion options for ",
  StyleBox["XMLGet",
    FontFamily->"Courier"],
  " are the same as the ones for ",
  StyleBox["Import",
    FontFamily->"Courier"],
  ". However, the syntax for specifying conversion options is slightly \
different. The conversion option can be specified directly in the ",
  StyleBox["XMLGet",
    FontFamily->"Courier"],
  " function, such that"
}], "Text",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],

Cell[TextData[{
  StyleBox["\tXMLGet[",
    FontFamily->"Courier"],
  StyleBox["file",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["option1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["value1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["option1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["value2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["...",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],

Cell["is equivalent to", "Text",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],

Cell[TextData[{
  StyleBox["\tImport[",
    FontFamily->"Courier"],
  StyleBox["file",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"SymbolicXML\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["option1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["value1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["option2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["value2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["...",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["}]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],

Cell[TextData[{
  "For more information on conversion options for importing XML, ",
  "see ",
  StyleBox["XML Import Conversion Options",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True}],
  "."
}], "Text",
  CellTags->{"UsingXMLGet", "i:25", "b:1.0"}]
}, Closed]],

Cell[CellGroupData[{

Cell["XMLGetString", "Subsubsection",
  FontFamily->"Courier",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[TextData[{
  "The ",
  StyleBox["XMLGetString",
    FontFamily->"Courier"],
  " function can be used to import an XML string as SymbolicXML. It is very \
similar to the ",
  StyleBox["ImportString",
    FontFamily->"Courier"],
  " function, in that ",
  StyleBox["XMLGetString[",
    FontFamily->"Courier"],
  StyleBox["string",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " is equivalent to ",
  StyleBox["ImportString[",
    FontFamily->"Courier"],
  StyleBox["string, ",
    FontSlant->"Italic"],
  StyleBox["\"SymbolicXML\"]",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString["\<<math><mi>x</mi><mo>+</mo><mn>1</mn></math>\>\
"]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "math", {}, {XMLElement["mi", {}, {"x"}], 
          XMLElement["mo", {}, {"+"}], 
          XMLElement["mn", {}, {"1"}]}], {}]\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}]
}, Closed]],

Cell[TextData[{
  "Note that ",
  StyleBox["XMLGetString",
    FontFamily->"Courier"],
  " exists only in the ",
  StyleBox["XML`Parser`",
    FontFamily->"Courier"],
  " context. Hence, you must use the full name of the function, ",
  StyleBox["XML`Parser`XMLGet",
    FontFamily->"Courier"],
  ", when doing an evaluation. To use the function without the context name \
prefix, you must first add the ",
  StyleBox["XML`Parser`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Text",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[TextData[{
  "The advantage of using ",
  StyleBox["XMLGetString",
    FontFamily->"Courier"],
  " is that it accepts a pre-initialized parser object as its second \
argument."
}], "Text",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[TextData[{
  StyleBox["\tXMLGetString[",
    FontFamily->"Courier"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["XMLParserObject", "TI"],
  StyleBox["]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[TextData[{
  "Initializing the parser involves loading a DTD into memory either from a \
URL or a local file. This only needs to be done once in each kernel session. \
Subsequent references to the DTD are then processed much faster because the \
DTD has already been read and parsed. For more information on initializing \
the parser, see ",
  ButtonBox["InitializeXMLParser",
    ButtonData:>"InitializeXMLParser",
    ButtonStyle->"AddOnsLink"],
  ". "
}], "Text",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[TextData[{
  "For example, the following command loads the XML package and then \
pre-initializes the parser according to the XHTML DTD located at the \
specified URI\:f3b5. In this example, the pre-initialized parser is given the \
name ",
  StyleBox["XHTMLParser",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XHTMLParser = 
      XML`Parser`InitializeXMLParser["\<html\>", \
"\<http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\>"]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[BoxData[
    \(XML`Parser`XMLParser["html", 
      "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"]\)], "Output",\

  CellLabel->"Out[11]=",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}]
}, Closed]],

Cell[TextData[{
  "Now that the parser is initialized, we import an XML string. The string is \
validated with respect to the DTD stored in ",
  StyleBox["XHTMLParser",
    FontFamily->"Courier"],
  " by setting \"",
  StyleBox["ValidateAgainstDTD",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  ". The option ",
  StyleBox["Valid",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  " in the output, which indicates that the XML input string was valid XML \
with respect to the XHTML DTD."
}], "Text",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString["\<<html><head><title>test</title></head><body><\
p>Here is some text.</p></body></html>\>", 
      XHTMLParser, "\<ValidateAgainstDTD\>" \[Rule] True]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Doctype"]\)["html", 
          "System" \[Rule] 
            "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"]}, 
      XMLElement[
        "html", {}, {XMLElement[
            "head", {}, {XMLElement["title", {}, {"test"}]}], 
          XMLElement[
            "body", {}, {XMLElement["p", {}, {"Here is some text."}]}]}], {}, 
      "Valid" \[Rule] True]\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}]
}, Closed]],

Cell[TextData[{
  "You can also specify ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " for ",
  StyleBox["XMLGetString",
    FontFamily->"Courier"],
  " to control the various details of the import process. The conversion \
options for ",
  StyleBox["XMLGetString",
    FontFamily->"Courier"],
  " are the same as those for ",
  StyleBox["ImportString",
    FontFamily->"Courier"],
  ". However, the syntax for specifying conversion options is slightly \
different. The conversion option can be specified directly in the ",
  StyleBox["XMLGet",
    FontFamily->"Courier"],
  " function such that"
}], "Text",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[TextData[{
  StyleBox["\tXMLGetString[",
    FontFamily->"Courier"],
  StyleBox["string",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["option1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["value1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["option1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["value2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["..",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox[".",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell["is equivalent to", "Text",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[TextData[{
  StyleBox["\tImportString[",
    FontFamily->"Courier"],
  StyleBox["string",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",\"SymbolicXML\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["option1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["value1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["option1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["value2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  StyleBox["...",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["}]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],

Cell[TextData[{
  "For more information on the conversion options available f",
  StyleBox["or importing XML, see",
    FontFamily->"Times New Roman"],
  " ",
  ButtonBox["Import Conversion Options",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Entities and Validation", "Subsection",
  CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],

Cell[TextData[{
  "An XML document can contain any characters included in the Unicode \
character set. When importing an XML document into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", all numeric Unicode character entity references are automatically \
resolved into the corresponding ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " character."
}], "Text",
  CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<hand>
<card suit='&#9824;' value='2'/>
<card suit='&#9825;' value='10'/>
<card suit='&#9826;' value='6'/>
<card suit='&#9827;' value='4'/>
<card suit='&#9827;' value='5'/>
</hand>\>", "\<XML\>"]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "hand", {}, {XMLElement[
            "card", {"suit" \[Rule] "\[SpadeSuit]", 
              "value" \[Rule] "2"}, {}], 
          XMLElement[
            "card", {"suit" \[Rule] "\[HeartSuit]", 
              "value" \[Rule] "10"}, {}], 
          XMLElement[
            "card", {"suit" \[Rule] "\[DiamondSuit]", 
              "value" \[Rule] "6"}, {}], 
          XMLElement[
            "card", {"suit" \[Rule] "\[ClubSuit]", "value" \[Rule] "4"}, {}], 
          XMLElement[
            "card", {"suit" \[Rule] "\[ClubSuit]", 
              "value" \[Rule] "5"}, {}]}], {}]\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->{"EntititiesValidation", "i:27", "b:1.1"}]
}, Closed]],

Cell["\<\
Other entities that are not built into XML are resolved according \
to the rules present in the document type declaration. \
\>", "Text",
  CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<!DOCTYPE root [<!ELEMENT root (#PCDATA)><!ENTITY WRI \
\"Wolfram Research, Inc.\">]>
<root>&WRI;</root>\>", "\<XML\>"]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Doctype"]\)["root", 
          "InternalSubset" \[Rule] 
            "<!ELEMENT root (#PCDATA)*><!ENTITY WRI 'Wolfram Research, \
Inc.'>"]}, XMLElement["root", {}, {"Wolfram Research, Inc."}], {}, 
      "Valid" \[Rule] True]\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->{"EntititiesValidation", "i:27", "b:1.1"}]
}, Closed]],

Cell[TextData[{
  "In addition to simply converting an XML document to a SymbolicXML \
expression, ",
  StyleBox["Import",
    FontFamily->"Courier"],
  " can validate the XML data to ensure that it conforms to a content model \
defined by a DTD. So long as the document is well formed, a SymbolicXML \
expression will be returned.",
  " ",
  "If the document is not valid, warning messages will be issued and the \
document wrapper will indicate the invalid nature of the document with the \
option ",
  StyleBox["Valid \[Rule] False",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],

Cell[TextData[{
  "You can control the various aspects of how entities are treated and \
whether the document is validated or not by using the conversion options for \
the ",
  StyleBox["Import",
    FontFamily->"Courier"],
  " function. For more information, see ",
  ButtonBox["Import Conversion Options",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->{"EntititiesValidation", "i:27", "b:1.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Conversion Options", "Subsection",
  CellTags->{"ConvOpt", "b:1.2"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
  CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],

Cell[TextData[{
  "The standard ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " feature of ",
  StyleBox["Import",
    FontFamily->"Courier"],
  StyleBox[" gives ",
    FontFamily->"Times New Roman"],
  "you more control over the import process. The syntax for specifying a \
conversion option is as follows. "
}], "Text",
  CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],

Cell[TextData[{
  StyleBox["Import[",
    FontFamily->"Courier"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["option",
    FontSlant->"Italic"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  " ",
  StyleBox["value",
    FontSlant->"Italic"],
  StyleBox["}]",
    FontFamily->"Courier"]
}], "IndentedText",
  CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],

Cell[TextData[{
  "Multiple conversion options can be specified by making the right-hand side \
of ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " a list of lists. There are nine conversion options",
  " ",
  "available for importing XML data. "
}], "Text",
  CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],

Cell[TextData[StyleBox["\"NormalizeWhitespace\"",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],

Cell[TextData[StyleBox["\"AllowRemoteDTDAccess\"",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],

Cell[TextData[StyleBox["\"AllowUnrecognizedEntities\"",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],

Cell[TextData[StyleBox["\"ReadDTD\"",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],

Cell[TextData[StyleBox["\"ValidateAgainstDTD\"",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],

Cell[TextData[StyleBox["\"IncludeDefaultedAttributes\"",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],

Cell[TextData[StyleBox["\"IncludeEmbeddedObjects\"",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],

Cell[TextData[StyleBox["\"IncludeNamespaces\"",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],

Cell[TextData[StyleBox["\"PreserveCDATASections\"",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"NormalizeWhitespace\"", "Subsubsection",
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],

Cell["\<\
This conversion option controls how whitespace in the document \
being imported is processed. Whitespace is defined as a space, tab, or \
newline character. \
\>", "Text",
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],

Cell[TextData[{
  "If \"",
  StyleBox["NormalizeWhitespace",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", all the whitespace inside an element is normalized. This means that all \
leading and trailing whitespace is stripped and any interior whitespace is \
reduced to a single whitespace character. \"",
  StyleBox["NormalizeWhitespace",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  " is the default setting for this option."
}], "Text",
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],

Cell[TextData[{
  "If \"",
  StyleBox["NormalizeWhitespace",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", then all whitespace is preserved as it was in the original XML \
document."
}], "Text",
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],

Cell[TextData[{
  "If \"",
  StyleBox["NormalizeWhitespace",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ", then ignorable whitespace is removed and non-ignorable whitespace is \
preserved. ",
  "Whitespace is ignorable when it occurs in places where character data is \
not permitted according to the content model specified by the DTD. The \
primary use of ignorable whitespace is to add indentation for formatting \
purposes."
}], "Text",
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<NormalizeWhitespace\>\"",
              FontFamily->"Courier"], 
            StyleBox["True",
              FontFamily->"Courier"], 
            
            StyleBox[\(all\ the\ whitespace\ inside\ an\ element\ is\ \
normalized\),
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              FontFamily->"Courier"], 
            
            StyleBox[\(all\ the\ whitespace\ in\ the\ original\ XML\ document\
\ is\ preserved\),
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["Automatic",
              FontFamily->"Courier"], 
            
            StyleBox[\(ignorable\ whitespace\ is\ removed\ and\ non - 
                ignorable\ whitespace\ is\ preserved\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],

Cell["The option \"NormalizeWhitespace\" and its possible values.", "Caption",
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],

Cell[TextData[{
  "Here is an example of whitespace handling with the default setting \"",
  StyleBox["NormalizeWhitespace",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<foo>     a   b   </foo>\>", \ "\<XML\>"]\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement["foo", {}, {"a b"}], {}]\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  "Setting \"",
  StyleBox["NormalizeWhitespace",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  " preserves the whitespace as it appears in the original string."
}], "Text",
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<foo>     a   b   </foo>\>", \ "\<XML\>", \ 
      ConversionOptions \[Rule] {"\<NormalizeWhitespace\>"\  \[Rule] \ 
            False}]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement["foo", {}, {"     a   b   "}], {}]\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  StyleBox["Note:",
    FontWeight->"Bold"],
  " If the option \"",
  StyleBox["NormalizeWhitespace",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  " is specified, pattern matching on the resulting SymbolicXML expression \
may become problematic because of the intervening whitespace."
}], "Text",
  CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"AllowRemoteDTDAccess\"", "Subsubsection",
  CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],

Cell[TextData[{
  "This conversion option controls whether the parser may access the network \
in order to retrieve DTDs. If \"",
  StyleBox["AllowRemoteDTDAccess\"",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", the parser will automatically access the network to retrieve DTDs. If \
\"",
  StyleBox["AllowRemoteDTDAccess\"",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", then remote DTDs will not be retrieved, but local DTDs may still be \
used."
}], "Text",
  CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<AllowRemoteDTDAccess\>\"",
              FontFamily->"Courier"], 
            StyleBox["True",
              FontFamily->"Courier"], 
            
            StyleBox[\(the\ parser\ will\ automatically\ access\ the\ network\
\ to\ retrieve\ DTDs\),
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              FontFamily->"Courier"], 
            
            StyleBox[\(remote\ DTDs\ will\ not\ be\ retrieved, \ 
              but\ local\ DTDs\ can\ still\ be\ used\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],

Cell["The option \"AllowRemoteDTDAccess\" and its possible values.", "Caption",
  CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],

Cell[TextData[{
  "If \"",
  StyleBox["AllowRemoteDTDAccess\"",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  " and the document refers to a remote DTD, the parse will fail and an error \
message will be generated, unless the conversion option ",
  StyleBox["\"ReadDTD\"",
    FontFamily->"Courier"],
  " is also set to ",
  StyleBox["False",
    FontFamily->"Courier"],
  ". "
}], "Text",
  CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"AllowUnrecognizedEntities\"", "Subsubsection",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],

Cell["\<\
This option determines what the parser will do if undefined entity \
references are encountered in the XML document. \
\>", "Text",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<AllowUnrecognizedEntities\>\"",
              FontFamily->"Courier"], 
            StyleBox["True",
              FontFamily->"Courier"], 
            
            StyleBox[\(any\ undefined\ entities\ are\ wrapped\ in\ special\ \
entity\ delimiter\ characters, \ and\ no\ error\ messages\ are\ reported\),
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              FontFamily->"Courier"], 
            
            StyleBox[\(an\ error\ message\ is\ reported\ and\ the\ parse\ \
fails\),
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["Automatic",
              FontFamily->"Courier"], 
            
            StyleBox[\(an\ error\ message\ is\ reported\ for\ any\ \
unrecognized\ entity, 
              and\ the\ entity\ is\ wrapped\ in\ special\ entity\ delimiter\ \
characters\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],

Cell["\<\
The option \"AllowUnrecognizedEntities\" and its possible values.\
\
\>", "Caption",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],

Cell[TextData[{
  "The following examples contain an undefined entity \
called\[OpenCurlyQuote]dogs\[CloseCurlyQuote].  If \"",
  StyleBox["AllowUnrecognizedEntities",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", then an error message is reported and the parse fails. "
}], "Text",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<!DOCTYPE root [<!ELEMENT root (#PCDATA)><!ENTITY cats \
'Himalayans'>]>
<root>
   &dogs;
</root>\>", "\<XML\>", \ 
      ConversionOptions \[Rule] {"\<AllowUnrecognizedEntities\>"\  \[Rule] \ 
            False}]\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],

Cell[BoxData[
    \(XML`Parser`XMLGet::"parseError" \(\(:\)\(\ \)\) 
      "Entity 'dogs' was not found at Line: 1 Character: 88 in \
/tmp/m0000083951"\)], "Message",
  CellLabel->"From In[17]:=",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],

Cell[BoxData[
    \(Import::"probableDTDError" \(\(:\)\(\ \)\) 
      "There was an error parsing the XML document.  This may be due to \
undeclared entities in the XML document, or an error loading the DTD.  Check \
that entities are correctly declared or use the \"AllowUnrecognizedEntities\" \
conversion option."\)], "Message",
  CellLabel->"From In[17]:=",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[17]=",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  "If \"",
  StyleBox["AllowUnrecognizedEntities",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ", ",
  "an error",
  " message is ",
  "reported for any unrecognized",
  " entity, and the entity is wrapped in special ",
  "entity delimiter characters. However, this does not interrupt the \
importing and parsing of the XML data. ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  " is the default setting for this option."
}], "Text",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<!DOCTYPE root [<!ELEMENT root (#PCDATA)><!ENTITY cats \
'Himalayans'>]>
<root>
   &dogs;
</root>\>", "\<XML\>", \ 
      ConversionOptions \[Rule] {"\<AllowUnrecognizedEntities\>"\  \[Rule] \ 
            Automatic}]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],

Cell[BoxData[
    \(XML`Parser`XMLGet::"nonFatalParseError" \(\(:\)\(\ \)\) 
      "Entity 'dogs' was not found at Line: 1 Character: 88 in \
/tmp/m0000093951"\)], "Message",
  CellLabel->"From In[18]:=",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Doctype"]\)["root", 
          "InternalSubset" \[Rule] 
            "<!ELEMENT root (#PCDATA)*><!ENTITY cats 'Himalayans'>"]}, 
      XMLElement["root", {}, {"\[EntityStart]dogs\[EntityEnd]"}], {}, 
      "Valid" \[Rule] False]\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  "If \"",
  StyleBox["AllowUnrecognizedEntities",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", then any undefined entities are wrapped in special ",
  "entity delimiter",
  " characters, ",
  "and no error messages are reported",
  "."
}], "Text",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<!DOCTYPE root [<!ELEMENT root (#PCDATA)><!ENTITY cats \
'Himalayans'>]>
<root>
   &dogs;
</root>\>", "\<XML\>", \ 
      ConversionOptions \[Rule] {"\<AllowUnrecognizedEntities\>"\  \[Rule] \ 
            True}]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Doctype"]\)["root", 
          "InternalSubset" \[Rule] 
            "<!ELEMENT root (#PCDATA)*><!ENTITY cats 'Himalayans'>"]}, 
      XMLElement["root", {}, {"\[EntityStart]dogs\[EntityEnd]"}], {}, 
      "Valid" \[Rule] True]\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ReadDTD\"", "Subsubsection",
  CellTags->{"ReadDTD", "i:32", "b:1.2"}],

Cell["\<\
This conversion option determines whether an external DTD subset is \
read or not. The most important uses of a DTD are to define a content model \
for validation and to define character entities. \
\>", "Text",
  CellTags->{"ReadDTD", "i:32", "b:1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<ReadDTD\>\"",
              FontFamily->"Courier"], 
            StyleBox["True",
              FontFamily->"Courier"], 
            StyleBox[\(external\ DTDs\ are\ read\),
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              FontFamily->"Courier"], 
            StyleBox[\(external\ DTDs\ are\ ignored\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"ReadDTD", "i:32", "b:1.2"}],

Cell["The option \"ReadDTD\" and its possible values.", "Caption",
  CellTags->{"ReadDTD", "i:32", "b:1.2"}],

Cell[TextData[{
  "Since reading the DTD can directly affect the contents of the document, \
\"",
  StyleBox["ReadDTD",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  " is the default setting for this option. Setting \"",
  StyleBox["ReadDTD",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  " can improve the efficiency, but you should only make this change if you \
are certain that no information is required from the DTD."
}], "Text",
  CellTags->{"ReadDTD", "i:32", "b:1.2"}],

Cell[TextData[{
  "Setting \"",
  StyleBox["ReadDTD",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  " is the only way prevent the parser from attempting to read the DTD. \
Setting ",
  StyleBox["\"AllowRemoteDTDAccess\" -> False",
    FontFamily->"Courier"],
  " will prevent network access and setting ",
  StyleBox["\"ValidateAgainstDTD\"-> False",
    FontFamily->"Courier"],
  " will prevent validation from happening, but neither of these options will \
prevent an error caused by the parser failing to read the DTD."
}], "Text",
  CellTags->{"ReadDTD", "i:32", "b:1.2"}],

Cell[TextData[{
  "\"",
  StyleBox["ReadDTD",
    FontFamily->"Courier"],
  "\" is ignored if you are using a pre-initialized parser. For more \
information on pre-initialized parsers, see ",
  ButtonBox["InitializeXMLParser",
    ButtonData:>"InitializeXMLParser",
    ButtonStyle->"AddOnsLink"],
  "."
}], "Text",
  CellTags->{"ReadDTD", "i:32", "b:1.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ValidateAgainstDTD\"", "Subsubsection",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell["\<\
This conversion option determines whether the XML document is \
validated or not. \
\>", "Text",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<ValidateAgainstDTD\>\"",
              FontFamily->"Courier"], 
            StyleBox["True",
              FontFamily->"Courier"], 
            
            StyleBox[\(a\ validation\ attempt\ will\ be\ made\ on\ import\ \
even\ if\ there\ is\ no\ DOCTYPE\ declaration\ in\ the\ XML\ document\),
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              FontFamily->"Courier"], 
            StyleBox[\(no\ validation\ attempt\ will\ be\ made\ on\ import\),
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["Automatic",
              FontFamily->"Courier"], 
            
            StyleBox[\(a\ validation\ attempt\ will\ be\ made\ on\ import\ \
only\ if\ there\ is\ a\ DOCTYPE\ declaration\ in\ the\ XML\ document . \ 
                  This\ is\ the\ default\ setting\ for\ this\ \(\(option\)\(.\
\)\)\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell["The option \"ValidateAgainstDTD\" and its possible values.", "Caption",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[TextData[{
  "If the document is valid, the parser will set the ",
  StyleBox["XMLObject",
    FontFamily->"Courier"],
  "[\"",
  StyleBox["Document",
    FontFamily->"Courier"],
  "\"] option \"",
  StyleBox["Valid",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  ". If the document is invalid, the parser will generate validity error \
messages and will set \"",
  StyleBox["Valid",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times New Roman"]
}], "Text",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[TextData[{
  "The following is an example where we parse a document that is not valid by \
setting \"",
  StyleBox["ValidateAgainstDTD",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  ". ",
  "The parser generates error messages since the document is not valid."
}], "Text",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString["\<<!DOCTYPE root [
<!ELEMENT root EMPTY>
]>
<root>
  <child/>
</root>\>", "\<ValidateAgainstDTD\>" \[Rule] True] // InputForm\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[BoxData[
    \(XML`Parser`XMLGetString::"nonFatalParseError" \(\(:\)\(\ \)\) 
      "No character data is allowed by content model at Line: 1 Character: \
52"\)], "Message",
  CellLabel->"From In[20]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[BoxData[
    \(XML`Parser`XMLGetString::"nonFatalParseError" \(\(:\)\(\ \)\) 
      "Unknown element 'child' at Line: 1 Character: 60"\)], "Message",
  CellLabel->"From In[20]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[BoxData[
    \(XML`Parser`XMLGetString::"nonFatalParseError" \(\(:\)\(\ \)\) 
      "No character data is allowed by content model at Line: 1 Character: \
61"\)], "Message",
  CellLabel->"From In[20]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(XML`Parser`XMLGetString :: \
\"nonFatalParseError\"\) will be suppressed during this calculation."\)], \
"Message",
  CellLabel->"From In[20]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell["\<\
XMLObject[\"Document\"][
 {XMLObject[\"Doctype\"][\"root\", 
   \"InternalSubset\" -> 
    \" <!ELEMENT root EMPTY> \"]}, 
 XMLElement[\"root\", {}, 
  {XMLElement[\"child\", {}, {}]}], {}, 
 \"Valid\" -> False]\
\>", "Output",
  CellLabel->"Out[20]//InputForm=",
  CellTags->{"Validate", "i:33", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  "On the other hand, if the document is valid, then no messages are \
generated and \"",
  StyleBox["Valid",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  StyleBox[" is included in the output.",
    FontFamily->"Times New Roman"]
}], "Text",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString["\<<!DOCTYPE root [
<!ELEMENT root EMPTY>
]>
<root></root>\>", "\<ValidateAgainstDTD\>" \[Rule] True] // 
      InputForm\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell["\<\
XMLObject[\"Document\"][
 {XMLObject[\"Doctype\"][\"root\", 
   \"InternalSubset\" -> 
    \" <!ELEMENT root EMPTY> \"]}, 
 XMLElement[\"root\", {}, {}], {}, \"Valid\" -> True]\
\>", "Output",
  CellLabel->"Out[21]//InputForm=",
  CellTags->{"Validate", "i:33", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  "Parsing both of the examples above with \"",
  StyleBox["ValidateAgainstDTD",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  " generates no error messages, nor does it add a \"",
  StyleBox["Valid",
    FontFamily->"Courier"],
  "\" option to ",
  StyleBox["XMLObject[\"Document\"]", "Input",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "."
}], "Text",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString["\<<!DOCTYPE root [
<!ELEMENT root EMPTY>
]>
<root>
  <child/>
</root>\>", "\<ValidateAgainstDTD\>" \[Rule] False] // InputForm\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell["\<\
XMLObject[\"Document\"][
 {XMLObject[\"Doctype\"][\"root\", 
   \"InternalSubset\" -> 
    \" <!ELEMENT root EMPTY> \"]}, 
 XMLElement[\"root\", {}, 
  {XMLElement[\"child\", {}, {}]}], {}]\
\>", "Output",
  CellLabel->"Out[22]//InputForm=",
  CellTags->{"Validate", "i:33", "b:1.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString["\<<!DOCTYPE root [
<!ELEMENT root EMPTY>
]>
<root></root>\>", "\<ValidateAgainstDTD\>" \[Rule] False] // 
      InputForm\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell["\<\
XMLObject[\"Document\"][
 {XMLObject[\"Doctype\"][\"root\", 
   \"InternalSubset\" -> 
    \" <!ELEMENT root EMPTY> \"]}, 
 XMLElement[\"root\", {}, {}], {}]\
\>", "Output",
  CellLabel->"Out[23]//InputForm=",
  CellTags->{"Validate", "i:33", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  "With \"",
  StyleBox["ValidateAgainstDTD",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", validation is attempted even if there is no DOCTYPE declaration."
}], "Text",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString["\<<root/>\>", "\<ValidateAgainstDTD\>" \[Rule] 
        True]\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[BoxData[
    \(XML`Parser`XMLGetString::"nonFatalParseError" \(\(:\)\(\ \)\) 
      "Unknown element 'root' at Line: 1 Character: 8"\)], "Message",
  CellLabel->"From In[24]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[BoxData[
    \(XML`Parser`XMLGetString::"nonFatalParseError" \(\(:\)\(\ \)\) 
      "Root element different from DOCTYPE at Line: 1 Character: 8"\)], \
"Message",
  CellLabel->"From In[24]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, XMLElement["root", {}, {}], {}, 
      "Valid" \[Rule] False]\)], "Output",
  CellLabel->"Out[24]=",
  CellTags->{"Validate", "i:33", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  "To have validation only when there is a DOCTYPE Declaration, use the \
default setting \"",
  StyleBox["ValidateAgainstDTD",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ". In the following example, no DTD is specified so the parser does not \
attempt to validate the XML string."
}], "Text",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<root/>\>", "\<XML\>"]\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement["root", {}, {}], {}]\)], "Output",
  CellLabel->"Out[25]=",
  CellTags->{"Validate", "i:33", "b:1.2"}]
}, Closed]],

Cell["\<\
Here the parser tries to validate the input string because a DTD is \
specified explicitly. \
\>", "Text",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<!DOCTYPE root [<!ELEMENT root EMPTY>]>
<root>
  <child/>
</root>\>", "\<XML\>"] // InputForm\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[BoxData[
    \(XML`Parser`XMLGet::"nonFatalParseError" \(\(:\)\(\ \)\) 
      "No character data is allowed by content model at Line: 1 Character: 50 \
in /tmp/m0000123951"\)], "Message",
  CellLabel->"From In[26]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[BoxData[
    \(XML`Parser`XMLGet::"nonFatalParseError" \(\(:\)\(\ \)\) 
      "Unknown element 'child' at Line: 1 Character: 58 in \
/tmp/m0000123951"\)], "Message",
  CellLabel->"From In[26]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[BoxData[
    \(XML`Parser`XMLGet::"nonFatalParseError" \(\(:\)\(\ \)\) 
      "No character data is allowed by content model at Line: 1 Character: 59 \
in /tmp/m0000123951"\)], "Message",
  CellLabel->"From In[26]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell[BoxData[
    \(General::"stop" \(\(:\)\(\ \)\) 
      "Further output of \!\(XML`Parser`XMLGet :: \"nonFatalParseError\"\) \
will be suppressed during this calculation."\)], "Message",
  CellLabel->"From In[26]:=",
  CellTags->{"Validate", "i:33", "b:1.2"}],

Cell["\<\
XMLObject[\"Document\"][
 {XMLObject[\"Doctype\"][\"root\", 
   \"InternalSubset\" -> 
    \"<!ELEMENT root EMPTY>\"]}, 
 XMLElement[\"root\", {}, 
  {XMLElement[\"child\", {}, {}]}], {}, 
 \"Valid\" -> False]\
\>", "Output",
  CellLabel->"Out[26]//InputForm=",
  CellTags->{"Validate", "i:33", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  "Note that even when using a pre-initialized parser, \"",
  StyleBox["ValidateAgainstDTD",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  " will not validate unless there is a DOCTYPE declaration in the document."
}], "Text",
  CellTags->{"Validate", "i:33", "b:1.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeDefaultedAttributes\"", "Subsubsection",
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],

Cell[TextData[{
  "This conversion option determines whether attributes that are specified by \
the DTD as default attributes are included in the SymbolicXML expression. \
\"",
  StyleBox["IncludeDefaultedAttributes",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  " is the default setting for this option since the default values for the \
attributes will be known to application developers, and therefore it is \
unnecessary to include the values in the SymbolicXML expression. Setting \"",
  StyleBox["IncludeDefaultedAttributes",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  " will include them in the SymbolicXML expression."
}], "Text",
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<IncludeDefaultedAttributes\>\"",
              FontFamily->"Courier"], 
            StyleBox["True",
              FontFamily->"Courier"], 
            
            StyleBox[\(default\ attributes\ in\ the\ DTD\ are\ included\ in\ \
the\ SymbolicXML\ expression\),
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              FontFamily->"Courier"], 
            StyleBox[\(default\ attributes\ are\ not\ included\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],

Cell["\<\
The option \"IncludeDefaultedAttributes\" and its possible \
values.\
\>", "Caption",
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],

Cell["\<\
Here is a simple example to illustrate how this option works. For \
brevity, let us assign a variable to represent the XML fragment. \
\>", "Text",\

  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],

Cell[BoxData[
    \(\(xmlString = "\<<!DOCTYPE test [<!ELEMENT test EMPTY>
<!ATTLIST test
\tMovie\t\tCDATA\t#FIXED\t\"The Lord of The Rings.\"
>]>
<test/>\>";\)\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],

Cell["This converts the XML fragment into SymbolicXML.", "Text",
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString[xmlString, "\<SymbolicXML\>"]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Doctype"]\)["test", 
          "InternalSubset" \[Rule] 
            "<!ELEMENT test EMPTY> <!ATTLIST test \tMovie CDATA #FIXED 'The \
Lord of The Rings.' >"]}, XMLElement["test", {}, {}], {}, 
      "Valid" \[Rule] True]\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  "If you want the default attributes to be included in the imported \
SymbolicXML, set \"",
  StyleBox["IncludeDefaultedAttributes",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString[xmlString, "\<SymbolicXML\>", 
      ConversionOptions \[Rule] {"\<IncludeDefaultedAttributes\>" \[Rule] 
            True}]\)], "Input",
  CellLabel->"In[29]:=",
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Doctype"]\)["test", 
          "InternalSubset" \[Rule] 
            "<!ELEMENT test EMPTY> <!ATTLIST test \tMovie CDATA #FIXED 'The \
Lord of The Rings.' >"]}, 
      XMLElement["test", {"Movie" \[Rule] "The Lord of The Rings."}, {}], {}, 
      "Valid" \[Rule] True]\)], "Output",
  CellLabel->"Out[29]=",
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  "Though default attributes are defined in a DTD, including them in the \
expression is not the same as validation; thus, default attributes can be \
included even with \"",
  StyleBox["ValidateAgainstDTD",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString[xmlString, "\<SymbolicXML\>", 
      ConversionOptions \[Rule] {"\<IncludeDefaultedAttributes\>" \[Rule] 
            True, "\<ValidateAgainstDTD\>" \[Rule] False}]\)], "Input",
  CellLabel->"In[30]:=",
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Doctype"]\)["test", 
          "InternalSubset" \[Rule] 
            "<!ELEMENT test EMPTY> <!ATTLIST test \tMovie CDATA #FIXED 'The \
Lord of The Rings.' >"]}, 
      XMLElement[
        "test", {"Movie" \[Rule] 
            "The Lord of The Rings."}, {}], {}]\)], "Output",
  CellLabel->"Out[30]=",
  CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeEmbeddedObjects\"", "Subsubsection",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell["\<\
This conversion option determines the treatment of comments and \
processing instructions that occur inside the document tree. \
\>", "Text",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<IncludeEmbeddedObjects\>\"",
              FontFamily->"Courier"], 
            StyleBox["All",
              FontFamily->"Courier"], 
            
            StyleBox[\(all\ the\ embedded\ objects\ will\ be\ included\ in\ \
the\ document\ tree\),
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["None",
              FontFamily->"Courier"], 
            StyleBox[\(no\ embedded\ objects\ are\ included\),
              SingleLetterItalics->False]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["Comments",
              FontFamily->"Courier"], 
            RowBox[{"only", " ", 
              StyleBox["embedded",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["comments",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["are",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["included",
                SingleLetterItalics->False]}]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["ProcessingInstructions",
              FontFamily->"Courier"], 
            
            StyleBox[\(only\ embedded\ processing\ instructions\ are\ \
included\),
              SingleLetterItalics->False]}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell["The option \"IncludeEmbeddedObjects\" and its possible values.", \
"Caption",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell[TextData[{
  "As before, we set a variable to represent a simple XML fragment to \
facilitate further examples. \"",
  StyleBox["IncludeEmbeddedObjects",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["All",
    FontFamily->"Courier"],
  " will include all embedded objects in the body of the XML document."
}], "Text",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell[BoxData[
    \(\(xmlexample\  = \ "\<<!--Comment-->
<?Instruction?>
<root>
<blank/>
</root>\>";\)\)], "Input",
  CellLabel->"In[31]:=",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell[TextData[{
  "With ",
  StyleBox["\"IncludeEmbeddedObjects\"\[Rule] All",
    FontFamily->"Courier"],
  ", all the embedded objects will be included in the document tree."
}], "Text",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString[
      xmlexample, \ "\<IncludeEmbeddedObjects\>" \[Rule] \ All]\)], "Input",
  CellLabel->"In[32]:=",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Comment"]\)[
          "Comment"], \(XMLObject["ProcessingInstruction"]\)["Instruction"]}, 
      XMLElement["root", {}, {XMLElement["blank", {}, {}]}], {}]\)], "Output",\

  CellLabel->"Out[32]=",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  "Since comments and processing instructions are not intended to affect \
applications that use the XML document, they are usually excluded from the \
document tree. Including them runs the risk of hampering pattern matching. \
Hence, the default setting is \"",
  StyleBox["IncludeEmbeddedObjects",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["None",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString[
      xmlexample, \ "\<IncludeEmbeddedObjects\>"\  \[Rule] \ None]\)], "Input",\

  CellLabel->"In[33]:=",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Comment"]\)[
          "Comment"], \(XMLObject["ProcessingInstruction"]\)["Instruction"]}, 
      XMLElement["root", {}, {XMLElement["blank", {}, {}]}], {}]\)], "Output",\

  CellLabel->"Out[33]=",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  "Setting \"",
  StyleBox["IncludeEmbeddedObjects",
    FontFamily->"Courier"],
  "\" \[Rule] \"",
  StyleBox["ProcessingInstructions",
    FontFamily->"Courier"],
  "\" or \"",
  StyleBox["IncludeEmbeddedObjects",
    FontFamily->"Courier"],
  "\" \[Rule] \"",
  StyleBox["Comments",
    FontFamily->"Courier"],
  "\" will include only the embedded processing instructions or comments \
respectively. You can also set \"",
  StyleBox["IncludeEmbeddedObjects",
    FontFamily->"Courier"],
  "\" \[Rule] {\"",
  StyleBox["Comments",
    FontFamily->"Courier"],
  "\", \"",
  StyleBox["ProcessingInstructions",
    FontFamily->"Courier"],
  "\"} so that a list of the embedded comments and processing instructions \
will be included."
}], "Text",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString[
      xmlexample, "\<IncludeEmbeddedObjects\>" \[Rule] \
"\<ProcessingInstructions\>"]\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Comment"]\)[
          "Comment"], \(XMLObject["ProcessingInstruction"]\)["Instruction"]}, 
      XMLElement["root", {}, {XMLElement["blank", {}, {}]}], {}]\)], "Output",\

  CellLabel->"Out[34]=",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString[
      xmlexample, "\<IncludeEmbeddedObjects\>" \[Rule] "\<Comments\>"]\)], \
"Input",
  CellLabel->"In[35]:=",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Comment"]\)[
          "Comment"], \(XMLObject["ProcessingInstruction"]\)["Instruction"]}, 
      XMLElement["root", {}, {XMLElement["blank", {}, {}]}], {}]\)], "Output",\

  CellLabel->"Out[35]=",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString[
      xmlexample, "\<IncludeEmbeddedObjects\>" \[Rule] {"\<Comments\>", \
"\<ProcessingInstructions\>"}]\)], "Input",
  CellLabel->"In[36]:=",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Comment"]\)[
          "Comment"], \(XMLObject["ProcessingInstruction"]\)["Instruction"]}, 
      XMLElement["root", {}, {XMLElement["blank", {}, {}]}], {}]\)], "Output",\

  CellLabel->"Out[36]=",
  CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeNamespaces\"", "Subsubsection",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell["\<\
This conversion option determines how namespaces are handled.\
\>", \
"Text",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<IncludeNamespaces\>\"",
              FontFamily->"Courier"], 
            StyleBox["True",
              FontFamily->"Courier"], 
            RowBox[{"specifies", " ", "the", " ", "explicit", 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["namespace",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["for",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["each",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["element",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["and",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["attribute",
                SingleLetterItalics->False]}]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              
              FontFamily->
                "Courier"], \(no\ namespace\ information\ is\ reported\)},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["Automatic",
              
              FontFamily->
                "Courier"], \(the\ namespace\ is\ determined\ by\ scoping\)},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["Unparsed",
              
              FontFamily->
                "Courier"], \(used\ for\ handling\ documents\ that\ use\ \
namespaces\ in\ a\ non - standard\ way\)}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell["The option \"IncludeNamespaces\" and its possible values.", "Caption",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell["\<\
We will set a variable to represent a simple XML fragment with \
namespaces to facilitate our examples.\
\>", "Text",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell["\<\
<root xmlns=\"http://mynamespace.com\"
     xmlns:same=\"http://mynamespace.com\"
     xmlns:foo=\"http://anothernamespace.com\">
     <child attr1=\"a\"  same:attr2=\"b\"  foo:attr3=\"c\"/>
     <foo:child/>
     <same:child/>
</root>\
\>", "Program",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[BoxData[
    \(\(xmlString = "\<<root xmlns='http://mynamespace.com'
     xmlns:same='http://mynamespace.com\'
    xmlns:foo='http://anothernamespace.com'>
    <child attr1='a'  same:attr2='b'  foo:attr3='c'/>
    <foo:child/>
    <same:child/>
</root>\>";\)\)], "Input",
  CellLabel->"In[37]:=",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[TextData[StyleBox["True", "MB"]], "Subsubsubsection",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[TextData[{
  "\"",
  StyleBox["IncludeNamespaces",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  " reports the namespace information for each element and attribute via a \
list of the form {",
  StyleBox["namespace",
    FontSlant->"Italic"],
  ", ",
  StyleBox["localname",
    FontSlant->"Italic"],
  "}. This form is more verbose, but it is more faithful to the data model of \
the XML document. Additionally, this form may be easier to use for pattern \
matching."
}], "Text",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString[
      xmlString, "\<IncludeNamespaces\>" \[Rule] True]\)], "Input",
  CellLabel->"In[38]:=",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"http://mynamespace.com", 
          "root"}, {{"http://www.w3.org/2000/xmlns/", "xmlns"} \[Rule] 
            "http://mynamespace.com", {"http://www.w3.org/2000/xmlns/", 
              "same"} \[Rule] 
            "http://mynamespace.com\\", {"http://www.w3.org/2000/xmlns/", 
              "foo"} \[Rule] 
            "http://anothernamespace.com"}, \
{XMLElement[{"http://mynamespace.com", 
              "child"}, {{\*"\<\"\"\>", "attr1"} \[Rule] 
                "a", {"http://mynamespace.com\\", "attr2"} \[Rule] 
                "b", {"http://anothernamespace.com", "attr3"} \[Rule] 
                "c"}, {}], 
          XMLElement[{"http://anothernamespace.com", "child"}, {}, {}], 
          XMLElement[{"http://mynamespace.com\\", 
              "child"}, {}, {}]}], {}]\)], "Output",
  CellLabel->"Out[38]=",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}]
}, Closed]],

Cell[TextData[StyleBox["False", "MB"]], "Subsubsubsection",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[TextData[{
  "\"",
  StyleBox["IncludeNamespaces",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  " only reports the local name of each element or attribute. While this \
setting should not be used in any serious XML application, it is useful for \
applications that have only a single namespace because it makes the \
SymbolicXML expression easier to read. Note that the names of all the child \
elements appear to be identical when parsed this way. Consequently, this \
option value cannot be trusted whenever multiple namespaces are used."
}], "Text",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString[
      xmlString, "\<IncludeNamespaces\>" \[Rule] False]\)], "Input",
  CellLabel->"In[39]:=",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "root", {"xmlns" \[Rule] "http://mynamespace.com", 
          "same" \[Rule] "http://mynamespace.com\\", 
          "foo" \[Rule] "http://anothernamespace.com"}, {XMLElement[
            "child", {"attr1" \[Rule] "a", "attr2" \[Rule] "b", 
              "attr3" \[Rule] "c"}, {}], XMLElement["child", {}, {}], 
          XMLElement["child", {}, {}]}], {}]\)], "Output",
  CellLabel->"Out[39]=",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}]
}, Closed]],

Cell[TextData[StyleBox["Automatic", "MB"]], "Subsubsubsection",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[TextData[{
  "With the default value \"",
  StyleBox["IncludeNamespaces",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ", the namespace is determined by means of scoping. If the namespace of an \
element is the same as the default namespace, then the name is represented as \
a single string for the local name. If the namespace of an element is \
different, then the name is represented by a list with the structure {",
  StyleBox["namespace",
    FontSlant->"Italic"],
  ", ",
  StyleBox["localname",
    FontSlant->"Italic"],
  "}. "
}], "Text",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[TextData[{
  "Here we see that the only element whose name is represented by a \
two-string list is the one in namespace ",
  StyleBox["http://anothernamespace.com", "XML",
    FontFamily->"Courier"],
  ". The other elements are implicitly contained in the ",
  StyleBox["http://mynamespace.com", "XML",
    FontFamily->"Courier"],
  " namespace. Attributes are not compacted since, according to the W3C \
specification, the attributes and the elements have different namespace \
scoping"
}], "Text",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString[xmlString]\)], "Input",
  CellLabel->"In[40]:=",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "root", {{"http://www.w3.org/2000/xmlns/", "xmlns"} \[Rule] 
            "http://mynamespace.com", {"http://www.w3.org/2000/xmlns/", 
              "same"} \[Rule] 
            "http://mynamespace.com\\", {"http://www.w3.org/2000/xmlns/", 
              "foo"} \[Rule] "http://anothernamespace.com"}, {XMLElement[
            "child", {"attr1" \[Rule] 
                "a", {"http://mynamespace.com\\", "attr2"} \[Rule] 
                "b", {"http://anothernamespace.com", "attr3"} \[Rule] 
                "c"}, {}], 
          XMLElement[{"http://anothernamespace.com", "child"}, {}, {}], 
          XMLElement[{"http://mynamespace.com\\", 
              "child"}, {}, {}]}], {}]\)], "Output",
  CellLabel->"Out[40]=",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}]
}, Closed]],

Cell[TextData[StyleBox["Unparsed", "MB"]], "Subsubsubsection",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[TextData[{
  "Because the XML namespace recommendation, which extends XML, was made \
after the initial XML recommendation, there are some documents that use names \
in a non-namespace-compliant fashion. \"",
  StyleBox["IncludeNamespaces",
    FontFamily->"Courier"],
  "\" \[Rule] \"",
  StyleBox["Unparsed",
    FontFamily->"Courier"],
  "\" is provided to allow parsing of these documents. With this value, the \
name is always represented as a single string: the exact string that appears \
in the XML file. Unless absolutely necessary, this option value should not be \
used."
}], "Text",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString[
      xmlString, "\<IncludeNamespaces\>" \[Rule] "\<Unparsed\>"]\)], "Input",
  CellLabel->"In[41]:=",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "root", {"xmlns" \[Rule] "http://mynamespace.com", 
          "xmlns:same" \[Rule] "http://mynamespace.com\\", 
          "xmlns:foo" \[Rule] "http://anothernamespace.com"}, {XMLElement[
            "child", {"attr1" \[Rule] "a", "same:attr2" \[Rule] "b", 
              "foo:attr3" \[Rule] "c"}, {}], XMLElement["foo:child", {}, {}], 
          XMLElement["same:child", {}, {}]}], {}]\)], "Output",
  CellLabel->"Out[41]=",
  CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PreserveCDATASections\"", "Subsubsection",
  CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],

Cell[TextData[{
  "This option controls whether the distinction between CDATA sections and \
regular character data is maintained on import. The value can be either ",
  StyleBox["True",
    FontFamily->"Courier"],
  " or ",
  StyleBox["False",
    FontFamily->"Courier"],
  ". CDATA sections are meant as a convenience for document authors; for most \
applications they should not be treated differently from ordinary data. This \
means that preserving CDATA sections can make pattern matching difficult. For \
this reason, \"",
  StyleBox["PreserveCDATASections",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  " is the default setting."
}], "Text",
  CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<PreserveCDATASections\>\"",
              FontFamily->"Courier"], 
            StyleBox["True",
              FontFamily->"Courier"], 
            RowBox[{"information", " ", "about", " ", 
              StyleBox["CDATA",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["sections",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["is",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["preserved",
                SingleLetterItalics->False]}]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              FontFamily->"Courier"], 
            RowBox[{"information", " ", "about", " ", 
              StyleBox["CDATA",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], 
              StyleBox["sections",
                SingleLetterItalics->False], 
              StyleBox[" ",
                SingleLetterItalics->False], "is", " ", "removed"}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],

Cell["The option \"PreserveCDATASections\" and its possible values.", \
"Caption",
  CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],

Cell[TextData[{
  "Here is an example of the default behavior of ",
  StyleBox["PreserveCDATASections",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<foo><![CDATA[ 5 < 7 << 2*10^123]]></foo>\>", \
"\<XML\>"]\)], "Input",
  CellLabel->"In[42]:=",
  CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement["foo", {}, {"5 < 7 << 2*10^123"}], {}]\)], "Output",
  CellLabel->"Out[42]=",
  CellTags->{"PreserveCDATA", "i:37", "b:1.2"}]
}, Closed]],

Cell[TextData[{
  "To preserve CDATA sections, specify \"",
  StyleBox["PreserveCDATASections",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<foo><![CDATA[ 5 < 7 << 2*10^123]]></foo>\>", \
"\<XML\>", 
      ConversionOptions \[Rule] {"\<PreserveCDATASections\>" \[Rule] 
            True}]\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "foo", {}, {\(XMLObject["CDATASection"]\)[
            "5 < 7 << 2*10^123"]}], {}]\)], "Output",
  CellLabel->"Out[43]=",
  CellTags->{"PreserveCDATA", "i:37", "b:1.2"}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["3. Transforming XML", "Section",
  PageBreakAbove->True],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is uniquely suited for processing symbolic expressions because of its \
powerful pattern-matching abilities and its large collection of built-in \
structural manipulation functions. This section provides a few examples to \
illustrate the use of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for processing XML data."
}], "Text",
  CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],

Cell[TextData[{
  "When you import an arbitrary XML document into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", it is automatically converted into a SymbolicXML expression. SymbolicXML \
is the format used for representing XML documents in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " syntax. The conversion to SymbolicXML translates the XML document into a \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression, while preserving its structure. The advantage of converting \
XML data into SymbolicXML is that you can directly manipulate SymbolicXML \
using any of ",
  "Mathematica\[CloseCurlyQuote]",
  "s built-in functions. "
}], "Text",
  CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],

Cell["\<\
The following command converts an XML string into a SymbolicXML \
expression.\
\>", "Text",
  CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(data = 
      ImportString["\<<colors><blue/><blue/><red/><blue/><red/></colors>\>", \
"\<XML\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "colors", {}, {XMLElement["blue", {}, {}], 
          XMLElement["blue", {}, {}], XMLElement["red", {}, {}], 
          XMLElement["blue", {}, {}], 
          XMLElement["red", {}, {}]}], {}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}]
}, Closed]],

Cell["\<\
Here we use a simple transformation rule to remove the unwanted \
\[OpenCurlyDoubleQuote]red\[CloseCurlyDoubleQuote] element from the \
list.\
\>", "Text",
  CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(newdata = 
      data /. XMLElement["\<red\>", __] \[Rule] Sequence[]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "colors", {}, {XMLElement["blue", {}, {}], 
          XMLElement["blue", {}, {}], 
          XMLElement["blue", {}, {}]}], {}]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}]
}, Closed]],

Cell[TextData[{
  "You can use ",
  StyleBox["ExportString",
    FontFamily->"Courier"],
  " to convert SymbolicXML into native XML syntax, which was designed to be \
easy to read."
}], "Text",
  CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[newdata, "\<XML\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],

Cell[BoxData[
    \("<colors>\n <blue/>\n <blue/>\n <blue/>\n</colors>"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Visualizing the XML Tree", "Subsection",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell[TextData[{
  "Many XML tools display an XML document as a collapsible tree, where the \
nodes correspond to the elements of the document. This example shows how to \
produce a similar visualization using cell grouping in a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook."
}], "Text",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell[TextData[{
  "We will do this by recursively traversing the SymbolicXML expression and \
for each ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  " object, creating a ",
  StyleBox["CellGroupData", "MR"],
  " expression that contains cells for each of that ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  " object's attributes and children. Each nested ",
  StyleBox["CellGroupData", "MR"],
  " expression will be indented from the previous one. We start with the \
function to process an ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  " object."
}], "Text",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell[BoxData[
    \(XMLNote[XMLElement[tag_, attributes_, data_], \ m_Integer] := 
      Cell[CellGroupData[{\[IndentingNewLine]Cell[
              TextData[\[IndentingNewLine]StyleBox[tag, 
                  FontFamily \[Rule] "\<Swiss\>", \
\[IndentingNewLine]FontWeight \[Rule] "\<Bold\>", 
                  FontSize \[Rule] 
                    15]]], \[IndentingNewLine]Sequence @@ \(\((XMLNote[#1, 
                      m] &)\) /@ 
                attributes\), \[IndentingNewLine]Sequence @@ \(\((XMLNote[#1, 
                      m + 30] &)\) /@ data\)\[IndentingNewLine]}, 
          Open], \[IndentingNewLine]CellMargins \[Rule] {{m, 
              Inherited}, {Inherited, Inherited}}]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell[TextData[{
  "Notice that we use the integer ",
  StyleBox["m", "MR"],
  " for indentation. When we map ",
  StyleBox["XMLNote",
    FontFamily->"Courier"],
  " onto the XMLElement object's children, we pass a larger value for ",
  StyleBox["m", "MR"],
  ", increasing the indentation for the child elements."
}], "Text",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell[TextData[{
  "A ",
  StyleBox["CellGroupData", "MR"],
  " expression contains a list of cells. In the above definition, we have \
only created a cell for the XMLElement ",
  StyleBox["x",
    FontFamily->"Courier"],
  ". However, we have then mapped ",
  StyleBox["XMLNote",
    FontFamily->"Courier"],
  " onto the attribute list. Since this returns a list, we need to use ",
  StyleBox["Apply",
    FontFamily->"Courier"],
  "[ ",
  StyleBox["Sequence",
    FontFamily->"Courier"],
  "] to the result in order to merge that list into the ",
  StyleBox["CellGroupData",
    FontFamily->"Courier"],
  " expression's list of cells. We then do the same thing to the children of \
the ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell[TextData[{
  "However, we have not yet defined ",
  StyleBox["XMLNote",
    FontFamily->"Courier"],
  " to work on attributes. The attributes of an ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  " object are stored in SymbolicXML as rules. In most cases, the rule \
contains two strings: the key and the value. However, when namespaces are \
involved, the first element of the rule may be a list containing two strings: \
the namespace and the key. We will need to make two definitions to handle the \
attributes."
}], "Text",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell[BoxData[
    \(XMLNote[{an_String, a_String} \[Rule] v_String, 
        m_Integer] := \[IndentingNewLine]Cell[
        TextData[\[IndentingNewLine]StyleBox[an, 
            FontColor \[Rule] Hue[0.6]], "\< \>", \[IndentingNewLine]StyleBox[
            a, FontWeight \[Rule] "\<Bold\>"], "\< = \>", \
\[IndentingNewLine]StyleBox[v, 
            Background \[Rule] 
              GrayLevel[0.8]]], \[IndentingNewLine]CellMargins \[Rule] {{m + 
                5, Inherited}, {Inherited, Inherited}}]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell[BoxData[
    \(XMLNote[a_String \[Rule] v_String, 
        m_Integer] := \[IndentingNewLine]Cell[
        TextData[\[IndentingNewLine]StyleBox[a, 
            FontWeight \[Rule] "\<Bold\>"], "\< = \>", \
\[IndentingNewLine]StyleBox[v, 
            Background \[Rule] 
              GrayLevel[0.8]]], \[IndentingNewLine]CellMargins \[Rule] {{m + 
                5, Inherited}, {Inherited, Inherited}}]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell[TextData[{
  "We will need one more definition in order to process simple SymbolicXML \
expressions. The text nodes in an XML document are stored simply as ",
  StyleBox["String",
    FontFamily->"Courier"],
  " objects in SymbolicXML.",
  " ",
  "Thus, we need a definition which handles ",
  StyleBox["String",
    FontFamily->"Courier"],
  " objects."
}], "Text",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell[BoxData[
    \(XMLNote[s_String, m_Integer] := \[IndentingNewLine]Cell[s, 
        Background \[Rule] 
          GrayLevel[
            0.9], \[IndentingNewLine]CellMargins \[Rule] {{m + 25, 
              Inherited}, {Inherited, Inherited}}]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell["\<\
With these definitions in place, we can construct a simple notebook \
to visualize a basic XML document. \
\>", "Text",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(d = 
      ImportString[
        ExportString[1\/\@2, "\<MathML\>"], "\<SymbolicXML\>"]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "math", {{"http://www.w3.org/2000/xmlns/", "xmlns"} \[Rule] 
            "http://www.w3.org/1998/Math/MathML"}, {XMLElement[
            "semantics", {}, {XMLElement[
                "mfrac", {}, {XMLElement["mn", {}, {"1"}], 
                  XMLElement["msqrt", {}, {XMLElement["mn", {}, {"2"}]}]}], 
              XMLElement[
                "annotation-xml", {"encoding" \[Rule] 
                    "MathML-Content"}, {XMLElement[
                    "apply", {}, {XMLElement["times", {}, {}], 
                      XMLElement["cn", {"type" \[Rule] "integer"}, {"1"}], 
                      XMLElement[
                        "apply", {}, {XMLElement["power", {}, {}], 
                          XMLElement[
                            "apply", {}, {XMLElement["power", {}, {}], 
                              XMLElement[
                                "cn", {"type" \[Rule] "integer"}, {"2"}], 
                              XMLElement[
                                "cn", {"type" \[Rule] "rational"}, {"1", 
                                  XMLElement["sep", {}, {}], "2"}]}], 
                          XMLElement[
                            "cn", {"type" \[Rule] 
                                "integer"}, {"-1"}]}]}]}]}]}], {}]\)], \
"Output",
  CellLabel->"Out[12]=",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NotebookPut@\[IndentingNewLine]Notebook[{XMLNote[d[\([2]\)], 0]}, 
        CellGrouping \[Rule] "\<Manual\>"]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],

Cell[BoxData[
    InterpretationBox[\(NotebookObject[\[LeftSkeleton]"Untitled-1"\
\[RightSkeleton]]\),
      NotebookObject[ 
        FrontEndObject[ 
          LinkObject[ "ParentLink", 1, 1]], 11]]], "Output",
  CellLabel->"Out[13]=",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}]
}, Closed]],

Cell[TextData[{
  "Since the default value of the option ",
  StyleBox["\"IncludeEmbeddedObjects\"",
    FontFamily->"Courier"],
  " is ",
  StyleBox["None",
    FontFamily->"Courier"],
  ", we did not alter comments, processing instructions, or anything else \
that would be stored in an ",
  StyleBox["XMLObject",
    FontFamily->"Courier"],
  ". Adding definitions for these is not difficult and would be a good \
exercise in processing SymbolicXML."
}], "Text",
  CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Manipulating XML Data", "Subsection",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell["\<\
XML applications are used for more than just document layout. XML \
is also an excellent format for storing structured data. Many commercial \
database vendors are now adding XML support to their products, allowing you \
to work with databases using XML as an intermediate format.\
\>", "Text",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[TextData[{
  "Mathematica\[CloseCurlyQuote]",
  "s symbolic pattern-matching capabilities make it an ideal tool for \
extracting and manipulating information from XML documents. To illustrate \
this, let us manipulate an XML file containing data on major league baseball \
players. We first import this file into ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "as a SymbolicXML expression."
}], "Text",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(\(AL = Import["\<ALHitters.xml\>"];\)\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[TextData[{
  "Each player's information is stored in a PlayerRecord element.",
  " ",
  "We can easily extract this with ",
  StyleBox["Cases",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(\(players = 
        Cases[AL, XMLElement["\<PlayerRecord\>", _, _], 
          Infinity];\)\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[players]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(294\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}]
}, Closed]],

Cell[TextData[{
  "As we can see, the XML document contains records for 294 players. Since we \
do not want to sift through all the American League hitters, we will just \
take a look at the Yankees. Inside each ",
  StyleBox["PlayerRecord", "MR"],
  " element, there is a ",
  StyleBox["TEAM", "MR"],
  " element which specifies a player's team. By passing a slightly more \
sophisticated pattern to ",
  StyleBox["Cases",
    FontFamily->"Courier"],
  ", we can extract a list of all players on the Yankees team."
}], "Text",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(\(yankees = 
        Cases[AL, \[IndentingNewLine]XMLElement["\<PlayerRecord\>", _, \
\[IndentingNewLine]{___, XMLElement["\<TEAM\>", _, {"\<NYY\>"}], ___}], 
          Infinity];\)\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Length[yankees]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(21\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}]
}, Closed]],

Cell[TextData[{
  "The variable ",
  StyleBox["yankees",
    FontFamily->"Courier"],
  " now contains a list of SymbolicXML expressions for all the Yankees \
players. Just to see what the syntax of each ",
  StyleBox["PlayerRecord", "MR"],
  " element is, let's take a look at the first element of ",
  StyleBox["yankees",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[yankees]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(XMLElement[
      "PlayerRecord", {}, {XMLElement["PLAYER", {}, {"Bernie Williams"}], 
        XMLElement["TEAM", {}, {"NYY"}], XMLElement["POS", {}, {"OF"}], 
        XMLElement["STATUS", {}, {"A"}], XMLElement["GP", {}, {"141"}], 
        XMLElement["GS", {}, {"140"}], XMLElement["AB", {}, {"537"}], 
        XMLElement["AVG", {}, {"0.307"}], XMLElement["R", {}, {"108"}], 
        XMLElement["H", {}, {"165"}], XMLElement["Doubles", {}, {"37"}], 
        XMLElement["Triples", {}, {"6"}], XMLElement["HR", {}, {"30"}], 
        XMLElement["RBI", {}, {"121"}], XMLElement["SH", {}, {"0"}], 
        XMLElement["SF", {}, {"3"}], XMLElement["BB", {}, {"71"}], 
        XMLElement["SO", {}, {"84"}], XMLElement["HBP", {}, {"5"}], 
        XMLElement["SB", {}, {"13"}], XMLElement["CS", {}, {"5"}], 
        XMLElement["GIDP", {}, {"0"}], XMLElement["OBP", {}, {"0.391"}], 
        XMLElement["Slg", {}, {"0.566"}], XMLElement["TB", {}, {"304"}], 
        XMLElement["ParkAdj", {}, {"0.97882"}], 
        XMLElement["Outs", {}, {"372"}], XMLElement["TBxOBP", {}, {"118.9"}], 
        XMLElement["RP", {}, {"116.3"}], XMLElement["BJRC", {}, {"124.5"}], 
        XMLElement["PJRP", {}, {"111.2"}], 
        XMLElement["RPper27Outs", {}, {"8.44"}], 
        XMLElement["BJRCper27Outs", {}, {"9.04"}], 
        XMLElement["PJRPper27Outs", {}, {"8.07"}], 
        XMLElement["Salary", {}, {"12357143"}], 
        XMLElement["DollarsPerRun", {}, {"106210"}], 
        XMLElement["DollarsPerRunCreated", {}, {"99230"}], 
        XMLElement["DollarsPerRunProduced", {}, {"111145"}], 
        XMLElement["PictureIndex", {}, {"8190"}]}]\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}]
}, Closed]],

Cell[TextData[{
  "We can see that the player's name is stored in the ",
  StyleBox["PLAYER", "MR"],
  " element of each ",
  StyleBox["PlayerRecord", "MR"],
  " element. Suppose we just want to look at the names of the Yankees hitters \
we have already extracted. We can extract the name from one ",
  StyleBox["PlayerRecord", "MR"],
  " element easily enough."
}], "Text",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[
      Cases[First[
          yankees], \[IndentingNewLine]XMLElement["\<PLAYER\>", _, {name_}] \
\[Rule] name, 2]]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \("Bernie Williams"\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}]
}, Closed]],

Cell[TextData[{
  "We can then use ",
  StyleBox["Map",
    FontFamily->"Courier"],
  " to extract all the names from ",
  StyleBox["yankees",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[\[IndentingNewLine]First[
          Cases[#, \[IndentingNewLine]XMLElement["\<PLAYER\>", _, {name_}] \
\[Rule] name, 2]] &, \[IndentingNewLine]yankees]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \({"Bernie Williams", "Derek Jeter", "David Justice", "Jorge Posada", 
      "Paul Oneill", "Tino Martinez", "Chuck Knoblauch", "Jose Canseco", 
      "Scott Brosius", "Luis Polonia", "Shane Spencer", "Glenallen Hill", 
      "Clay Bellinger", "Jose Vizcaino", "Luis Sojo", "Chris Turner", 
      "Ryan Thompson", "Alfonso Soriano", "Lance Johnson", "Felix Jose", 
      "Roberto Kelly"}\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}]
}, Closed]],

Cell[TextData[{
  "Alternately, we could have used ",
  StyleBox["Cases",
    FontFamily->"Courier"],
  " on ",
  StyleBox["yankees",
    FontFamily->"Courier"],
  " with an appropriate pattern."
}], "Text",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cases[
      yankees, \[IndentingNewLine]XMLElement["\<PlayerRecord\>", _, \
\[IndentingNewLine]{___, XMLElement["\<PLAYER\>", _, {name_}], ___}] \[Rule] 
        name]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \({"Bernie Williams", "Derek Jeter", "David Justice", "Jorge Posada", 
      "Paul Oneill", "Tino Martinez", "Chuck Knoblauch", "Jose Canseco", 
      "Scott Brosius", "Luis Polonia", "Shane Spencer", "Glenallen Hill", 
      "Clay Bellinger", "Jose Vizcaino", "Luis Sojo", "Chris Turner", 
      "Ryan Thompson", "Alfonso Soriano", "Lance Johnson", "Felix Jose", 
      "Roberto Kelly"}\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}]
}, Closed]],

Cell[TextData[{
  "SymbolicXML is a general-purpose format for expressing arbitrary XML data. \
In some cases, you may find it more useful to convert SymbolicXML into a \
different type of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression. This type of conversion is easy to do using pattern-matching. \
In the following example, we import an XML file containing data about \
baseball pitchers and translate the resulting SymbolicXML expression into a \
list of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " rules."
}], "Text",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(\(NL = Import["\<NLPitchers.xml\>"];\)\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(\(myTransform[XMLElement[_, _, children_]] := \[IndentingNewLine]Apply[
          Sequence, Map[myTransform, children]];\)\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(\(myTransform[s_String] := s;\)\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(\(myTransform[\(XMLObject["\<Document\>"]\)[_, 
            root_, _]] := \[IndentingNewLine]{myTransform[
            root]};\)\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(\(myTransform[
          PlayerAttribute[
            XMLElement[
              name_, _, {value_}]]] := \[IndentingNewLine]name \[Rule] 
          value;\)\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(\(myTransform[
          XMLElement["\<PlayerRecord\>", _, 
            children_]] := \[IndentingNewLine]Pitcher @@ 
          Map[myTransform[PlayerAttribute[#]] &, children];\)\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[myTransform[NL]]\)], "Input",
  CellLabel->"In[29]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(Pitcher["PLAYER" \[Rule] "Randy Johnson", "TEAM" \[Rule] "ARI", 
      "POS" \[Rule] "SP", "GP" \[Rule] "35", "GS" \[Rule] "35", 
      "STATUS" \[Rule] "A", "W" \[Rule] "19", "L" \[Rule] "7", 
      "S" \[Rule] "0", "IP" \[Rule] "248.2", "ERA" \[Rule] "2.64", 
      "ParkAdj" \[Rule] "0.97441", "PAERA" \[Rule] "2.57", 
      "_90ERA" \[Rule] "5.94", "_50ERA" \[Rule] "4.54", 
      "RPper9inn" \[Rule] "3.4", "RP" \[Rule] "93.0", 
      "RunRatio" \[Rule] "0.64", "PAERAWinsOver162" \[Rule] "123.461", 
      "Games" \[Rule] "27.6", "PAERAwins" \[Rule] "21.0", 
      "PAERAloses" \[Rule] "6.6", "AVG" \[Rule] "0.213", 
      "OBA" \[Rule] "0.276", "ShutOut" \[Rule] "3", "H" \[Rule] "202", 
      "R" \[Rule] "89", "ER" \[Rule] "73", "HR" \[Rule] "23", 
      "K" \[Rule] "347", "WP" \[Rule] "5", "BLK" \[Rule] "2", 
      "HBP" \[Rule] "6", "E" \[Rule] "3", "Salary" \[Rule] "13350000", 
      "DollarsPerRun" \[Rule] "143563", 
      "PictureIndex" \[Rule] "7762"]\)], "Output",
  CellLabel->"Out[29]=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}]
}, Closed]],

Cell[TextData[{
  "Here, we have transformed the SymbolicXML expression for a ",
  StyleBox["PlayerRecord", "MR"],
  " node into a simpler expression. All the information about the player is \
stored in a list of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["Rule",
    FontFamily->"Courier"],
  "s with ",
  StyleBox["Pitcher",
    FontFamily->"Courier"],
  " as the head."
}], "Text",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[TextData[{
  "In addition to transforming the data into a different expression syntax as \
above, we can also modify the data and leave the overall expression in \
SymbolicXML. This way we can alter our data, but still export it to an XML \
file for use with other applications. As an example, we will work with the \
salaries of our American League hitters. First, we delete any ",
  StyleBox["PlayerRecord",
    FontFamily->"Courier New"],
  " entries where the salary is not available."
}], "Text",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(\(AL = 
        AL /. XMLElement["\<PlayerRecord\>", _, {___, \
\[IndentingNewLine]XMLElement["\<Salary\>", {}, {"\<#N/A\>"}], ___}] \[Rule] 
            Sequence[];\)\)], "Input",
  CellLabel->"In[30]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[TextData[{
  "Next, we create a function to extract name-salary pairs from our ",
  StyleBox["PlayerRecord", "MR"],
  " data. We will then sort these pairs by salary and look at the top ten."
}], "Text",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(Salaries[x_] := 
      Cases[x, \[IndentingNewLine]XMLElement["\<PlayerRecord\>", _, {___, \
\[IndentingNewLine]XMLElement["\<PLAYER\>", _, {name_}], ___, \
\[IndentingNewLine]XMLElement["\<Salary\>", {}, {s_}], ___}] \[RuleDelayed] \
\[IndentingNewLine]{name, ToExpression[s]}, Infinity]\)], "Input",
  CellLabel->"In[31]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rich = 
      Take[Sort[Salaries[AL], \((#1[\([2]\)] > #2[\([2]\)])\) &], 10] // 
        TableForm\)], "Input",
  CellLabel->"In[32]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"Albert Belle\"\>", "12868670"},
          {"\<\"Bernie Williams\"\>", "12357143"},
          {"\<\"Mo Vaughn\"\>", "11166667"},
          {"\<\"Raul Mondesi\"\>", "10000000"},
          {"\<\"Derek Jeter\"\>", "10000000"},
          {"\<\"Rafael Palmeiro\"\>", "8620921"},
          {"\<\"Ivan Rodriguez\"\>", "8600000"},
          {"\<\"Jim Thome\"\>", "8175000"},
          {"\<\"Juan Gonzalez\"\>", "7500000"},
          {"\<\"Kenny Lofton\"\>", "7500000"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[32]//TableForm=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}]
}, Closed]],

Cell["\<\
As a simple example of how to change the data in our SymbolicXML \
expression, we will create a function which doubles players' salaries.\
\>", \
"Text",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(DoubleSalary[s_] := ToString[2*ToExpression[s]]\)], "Input",
  CellLabel->"In[33]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    \(\(AL = 
        AL /. XMLElement["\<Salary\>", {}, {sal_}] \[RuleDelayed] \
\[IndentingNewLine]XMLElement["\<Salary\>", {}, {DoubleSalary[
                  sal]}];\)\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(richer = 
      Take[Sort[Salaries[AL], \((#1[\([2]\)] > #2[\([2]\)])\) &], 10] // 
        TableForm\)], "Input",
  CellLabel->"In[35]:=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],

Cell[BoxData[
    TagBox[GridBox[{
          {"\<\"Albert Belle\"\>", "25737340"},
          {"\<\"Bernie Williams\"\>", "24714286"},
          {"\<\"Mo Vaughn\"\>", "22333334"},
          {"\<\"Raul Mondesi\"\>", "20000000"},
          {"\<\"Derek Jeter\"\>", "20000000"},
          {"\<\"Rafael Palmeiro\"\>", "17241842"},
          {"\<\"Ivan Rodriguez\"\>", "17200000"},
          {"\<\"Jim Thome\"\>", "16350000"},
          {"\<\"Juan Gonzalez\"\>", "15000000"},
          {"\<\"Kenny Lofton\"\>", "15000000"}
          },
        RowSpacings->1,
        ColumnSpacings->3,
        RowAlignments->Baseline,
        ColumnAlignments->{Left}],
      Function[ BoxForm`e$, 
        TableForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[35]//TableForm=",
  CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Visualizing XML Data", "Subsection",
  CellTags->{"ManipulatingExample3", "b:2.3"}],

Cell[CellGroupData[{

Cell["Creating a 3D Graphic from an XML File", "Subsubsection",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],

Cell[TextData[{
  "The following example illustrates how to use ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming and SymbolicXML to visualize data in XML format. The molecule \
description markup language (MoDL) is an XML application that describes \
molecules. For details, see ",
  ButtonBox["http://www.oasis-open.org/cover/modl.html",
    ButtonData:>{
      URL[ "http://www.oasis-open.org/cover/modl.html"], None},
    ButtonStyle->"Hyperlink"],
  ". In this example, we convert a MoDL description of the methane molecule \
into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 3D graphic. "
}], "Text",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],

Cell["\<\
The following is the MoDL file that contains the description of the \
methane molecule.\
\>", "Text",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! methane.xml\)\)], "Input",
  CellLabel->"In[2]:=",
  Evaluatable->False,
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],

Cell["\<\
<?xml version=\"1.0\"?>
<modl>
<head animation=\"on\" clockperiod=\"5s\" stepsize=\"1s\" loop=\"true\">
   <meta name=\"title\" content=\"Methane Dance\" />
   <DEFINE name=\"C\">
      <atom radius=\"0.3\" color=\"1 1 0\" />
   </DEFINE>
   <DEFINE name=\"H\">
      <atom radius=\"0.25\" color=\"1 0 0\" />
   </DEFINE>
   <DEFINE name=\"CH4\">
     <molecule>
\t<atom type=\"C\" id=\"c1\" position=\"0 0 0.4\" />
\t<atom type=\"H\" id=\"h1\" position=\"0.5 0.1 -0.4\" />
\t<atom type=\"H\" id=\"h2\" position=\"-1 0.1 0.3\" />
\t<atom type=\"H\" id=\"h3\" position=\"0.3 0.7 1\" />
\t<atom type=\"H\" id=\"h4\" position=\"0.2 -0.9 0.8\" />
\t<bond atom1=\"c1\" atom2=\"h1\" />
\t<bond atom1=\"c1\" atom2=\"h2\" />
\t<bond atom1=\"c1\" atom2=\"h3\" />
\t<bond atom1=\"c1\" atom2=\"h4\" />
     </molecule>
   </DEFINE>
</head>
<body>
  <molecule type=\"CH4\" id=\"m\" />
 
  <TRANSLATE object=\"m\" t=\"0.2\" position=\"-3 1 -2\" />
  <TRANSLATE object=\"m\" t=\"0.4\" position=\"-1 0 -3\" />
  <TRANSLATE object=\"m\" t=\"0.6\" position=\"1 -1 -1\" />
  <TRANSLATE object=\"m\" t=\"0.8\" position=\"1 0 1\" />
  <TRANSLATE object=\"m\" t=\"1\" position=\"0 0 0\" />

  <ROTATE object=\"m\" t=\"0.2\" axis=\"1 0 0\" />
  <ROTATE object=\"m\" t=\"0.4\" axis=\"0 0 1\" angle=\"-1.571\"/>
  <ROTATE object=\"m\" t=\"0.6\" axis=\"0 -1 0\" />
  <ROTATE object=\"m\" t=\"0.8\" axis=\"-1 0 0\" angle=\"-0.78\" />
  <ROTATE object=\"m\" t=\"1\" axis=\"0 0 1\" />
</body>
</modl>\
\>", "Output",
  CellLabel->"Out[2]=",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}]
}, Closed]],

Cell[TextData[{
  "Here we import the file into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " in the form of a SymbolicXML expression."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],

Cell[BoxData[
    \(\(methane = Import["\<methane.xml\>"];\)\)], "Input",
  CellLabel->"In[37]:=",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],

Cell[TextData[{
  "In order to convert the resulting SymbolicXML expression into a ",
  StyleBox["Graphics3D",
    FontFamily->"Courier"],
  " expression, we will need the standard package ",
  StyleBox["Graphics`Shapes`",
    FontFamily->"Courier"],
  ".  "
}], "Text",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],

Cell[BoxData[
    \(<< Graphics`Shapes`\)], "Input",
  CellLabel->"In[38]:=",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],

Cell[TextData[{
  "The following code defines a function called ",
  StyleBox["MoDLToGraphics3D",
    FontFamily->"Courier"],
  " that turns the SymbolicXML expression into a ",
  StyleBox["Graphics3D",
    FontFamily->"Courier"],
  " expression.",
  " ",
  "This function relies on a number of auxiliary functions that are defined \
in the later part of this section, which deals with the details of \
implementation."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],

Cell[BoxData[
    \(MoDLToGraphics3D[
        modl_] := \[IndentingNewLine]Block[{\[IndentingNewLine]defs = 
            Cases[modl, XMLElement["\<DEFINE\>", ___], 
              Infinity], \[IndentingNewLine]body = 
            First[Cases[modl, XMLElement["\<body\>", ___], 
                Infinity]], \[IndentingNewLine]moldef, themols, 
          theatoms}, \[IndentingNewLine]ProcessDefinition /@ 
          defs; \[IndentingNewLine]themols = \[IndentingNewLine]Flatten@
            Cases[body, \[IndentingNewLine]XMLElement["\<molecule\>", {___, "\
\<type\>" \[Rule] t_, ___}, __] \[RuleDelayed] 
                moldef[t], \[IndentingNewLine]Infinity]; \
\[IndentingNewLine]theatoms = 
          Cases[body, \[IndentingNewLine]XMLElement["\<atom\>", {___, "\<type\
\>" \[Rule] t_, ___, "\<position\>" \[Rule] 
                    p_, ___}, \[IndentingNewLine]__] \[RuleDelayed] 
              Append[moldef[t], MolStringListToList[p]], 
            Infinity]; \[IndentingNewLine]Graphics3D[
          MolToGraphics /@ Join[themols, theatoms], 
          Boxed \[Rule] False]\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[39]:=",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],

Cell["\<\
Applying this function to the original SymbolicXML expression \
generates a 3D graphic representing the methane molecule. \
\>", "Text",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[MoDLToGraphics3D[methane]]\)], "Input",
  CellLabel->"In[40]:=",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.06145 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0462967 1.14699 5.68122e-17 1.14699 [
[ 0 0 0 0 ]
[ 1 1.06145 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.06145 L
0 1.06145 L
closepath
clip
newpath
.37336 .66509 m .33207 .68456 L .33692 .6624 L .729 0 0 r
F
.37336 .66509 m .37499 .68768 L .33207 .68456 L F
.37022 .6428 m .37336 .66509 L .33692 .6624 L .725 0 0 r
F
.40468 .65531 m .37499 .68768 L .37336 .66509 L .607 0 0 r
F
.39296 .6356 m .37336 .66509 L .37022 .6428 L .629 0 0 r
F
.39296 .6356 m .40468 .65531 L .37336 .66509 L F
.37022 .6428 m .33692 .6624 L .34371 .64082 L .725 0 0 r
F
.36585 .62282 m .37022 .6428 L .34371 .64082 L .714 0 0 r
F
.37782 .61898 m .37022 .6428 L .36585 .62282 L .646 0 0 r
F
.37782 .61898 m .39296 .6356 L .37022 .6428 L F
.37499 .68768 m .32962 .70531 L .33207 .68456 L .727 0 0 r
F
.37499 .68768 m .37496 .70856 L .32962 .70531 L F
.41192 .67632 m .37496 .70856 L .37499 .68768 L .578 0 0 r
F
.40468 .65531 m .41192 .67632 L .37499 .68768 L .607 0 0 r
F
.33692 .6624 m .29858 .66801 L .30857 .64817 L .833 0 0 r
F
.33692 .6624 m .33207 .68456 L .29858 .66801 L F
.34371 .64082 m .33692 .6624 L .30857 .64817 L .806 0 0 r
F
.34371 .64082 m .30857 .64817 L .32319 .63036 L F
.35186 .62176 m .34371 .64082 L .32319 .63036 L .769 0 0 r
F
.36585 .62282 m .34371 .64082 L .35186 .62176 L .714 0 0 r
F
.33207 .68456 m .2942 .68804 L .29858 .66801 L .853 0 0 r
F
.33207 .68456 m .32962 .70531 L .2942 .68804 L F
.37999 .60361 m .36585 .62282 L .35186 .62176 L .66 0 0 r
F
.37999 .60361 m .37782 .61898 L .36585 .62282 L F
.40343 .6218 m .40468 .65531 L .39296 .6356 L .476 0 0 r
F
.38324 .61166 m .39296 .6356 L .37782 .61898 L .554 0 0 r
F
.38324 .61166 m .40343 .6218 L .39296 .6356 L F
.41928 .63648 m .41192 .67632 L .40468 .65531 L .376 0 0 r
F
.40343 .6218 m .41928 .63648 L .40468 .65531 L .476 0 0 r
F
.37496 .70856 m .32982 .72273 L .32962 .70531 L .717 0 0 r
F
.37496 .70856 m .37325 .72581 L .32982 .72273 L F
.41398 .69672 m .37325 .72581 L .37496 .70856 L .53 0 0 r
F
.41192 .67632 m .41398 .69672 L .37496 .70856 L .578 0 0 r
F
.37999 .60361 m .35186 .62176 L .34108 .61619 L .66 0 0 r
F
.35186 .62176 m .32319 .63036 L .34108 .61619 L .769 0 0 r
F
.37999 .60361 m .38324 .61166 L .37782 .61898 L .66 0 0 r
F
.32962 .70531 m .29592 .70638 L .2942 .68804 L .864 0 0 r
F
.32962 .70531 m .32982 .72273 L .29592 .70638 L F
.42926 .65436 m .41398 .69672 L .41192 .67632 L .229 0 0 r
F
.41928 .63648 m .42926 .65436 L .41192 .67632 L .376 0 0 r
F
.32319 .63036 m .29906 .62744 L .31645 .61521 L .878 0 0 r
F
.32319 .63036 m .30857 .64817 L .29906 .62744 L F
.34108 .61619 m .32319 .63036 L .31645 .61521 L .803 0 0 r
F
.37999 .60361 m .34108 .61619 L .33764 .60819 L .66 0 0 r
F
.34108 .61619 m .31645 .61521 L .33764 .60819 L .803 0 0 r
F
.30857 .64817 m .28718 .64379 L .29906 .62744 L .946 0 0 r
F
.30857 .64817 m .29858 .66801 L .28718 .64379 L F
.37999 .60361 m .40343 .6218 L .38324 .61166 L .42 0 0 r
F
.37325 .72581 m .33272 .73513 L .32982 .72273 L .682 0 0 r
F
.37325 .72581 m .36997 .73776 L .33272 .73513 L F
.41059 .71459 m .36997 .73776 L .37325 .72581 L .426 0 0 r
F
.41398 .69672 m .41059 .71459 L .37325 .72581 L .53 0 0 r
F
.43234 .67378 m .41059 .71459 L .41398 .69672 L 0 0 0 r
F
.42926 .65436 m .43234 .67378 L .41398 .69672 L .229 0 0 r
F
.29858 .66801 m .28207 .66274 L .28718 .64379 L .995 0 0 r
F
.29858 .66801 m .2942 .68804 L .28207 .66274 L F
.39738 .60649 m .41928 .63648 L .40343 .6218 L .108 0 0 r
F
.37999 .60361 m .39738 .60649 L .40343 .6218 L .42 0 0 r
F
.37999 .60361 m .33764 .60819 L .34292 .60078 L .66 0 0 r
F
.33764 .60819 m .3264 .60106 L .34292 .60078 L .766 0 0 r
F
.33764 .60819 m .31645 .61521 L .3264 .60106 L F
.32982 .72273 m .3037 .72124 L .29592 .70638 L .84 0 0 r
F
.32982 .72273 m .33272 .73513 L .3037 .72124 L F
.37999 .60361 m .355 .59684 L .36919 .59793 L .66 0 0 r
F
.37999 .60361 m .34292 .60078 L .355 .59684 L F
.36919 .59793 m .39738 .60649 L .37999 .60361 L .255 0 0 r
F
.4111 .61544 m .42926 .65436 L .41928 .63648 L 0 0 0 r
F
.39738 .60649 m .4111 .61544 L .41928 .63648 L .108 0 0 r
F
.31645 .61521 m .31266 .60795 L .3264 .60106 L .796 0 0 r
F
.31645 .61521 m .29906 .62744 L .31266 .60795 L F
.34292 .60078 m .34952 .5935 L .355 .59684 L .542 0 0 r
F
.34292 .60078 m .3264 .60106 L .34952 .5935 L F
.2942 .68804 m .28435 .68246 L .28207 .66274 L .954 0 0 r
F
.2942 .68804 m .29592 .70638 L .28435 .68246 L F
.41059 .71459 m .40197 .72821 L .36997 .73776 L .426 0 0 r
F
.42811 .6929 m .40197 .72821 L .41059 .71459 L 0 0 0 r
F
.43234 .67378 m .42811 .6929 L .41059 .71459 L F
.76272 .37327 m .72199 .39208 L .72617 .37003 L .73 0 0 r
F
.76272 .37327 m .76502 .39584 L .72199 .39208 L F
.76006 .3501 m .76272 .37327 L .72617 .37003 L .725 0 0 r
F
.79707 .3615 m .76502 .39584 L .76272 .37327 L .612 0 0 r
F
.785 .34146 m .76272 .37327 L .76006 .3501 L .634 0 0 r
F
.785 .34146 m .79707 .3615 L .76272 .37327 L F
.36919 .59793 m .37678 .59559 L .39738 .60649 L .255 0 0 r
F
.355 .59684 m .37678 .59559 L .36919 .59793 L .261 0 0 r
F
.355 .59684 m .34952 .5935 L .37678 .59559 L F
.36997 .73776 m .33808 .7412 L .33272 .73513 L .526 0 0 r
F
.36997 .73776 m .36541 .74312 L .33808 .7412 L F
.40197 .72821 m .36541 .74312 L .36997 .73776 L .12 0 0 r
F
.76006 .3501 m .72617 .37003 L .73348 .34772 L .725 0 0 r
F
.7573 .32843 m .76006 .3501 L .73348 .34772 L .714 0 0 r
F
.77044 .32382 m .76006 .3501 L .7573 .32843 L .652 0 0 r
F
.77044 .32382 m .785 .34146 L .76006 .3501 L F
.76502 .39584 m .72132 .41189 L .72199 .39208 L .729 0 0 r
F
.76502 .39584 m .76678 .41582 L .72132 .41189 L F
.80554 .38214 m .76678 .41582 L .76502 .39584 L .58 0 0 r
F
.79707 .3615 m .80554 .38214 L .76502 .39584 L .612 0 0 r
F
.72617 .37003 m .69189 .37211 L .7007 .35291 L .85 0 0 r
F
.72617 .37003 m .72199 .39208 L .69189 .37211 L F
.73348 .34772 m .72617 .37003 L .7007 .35291 L .813 0 0 r
F
.4111 .61544 m .41973 .62973 L .42926 .65436 L 0 0 0 r
F
.41973 .62973 m .43234 .67378 L .42926 .65436 L .895 0 0 r
F
.29906 .62744 m .30314 .62093 L .31266 .60795 L .6 0 0 r
F
.29906 .62744 m .28718 .64379 L .30314 .62093 L F
.73348 .34772 m .7007 .35291 L .71505 .33516 L .813 0 0 r
F
.74327 .32716 m .73348 .34772 L .71505 .33516 L .769 0 0 r
F
.7573 .32843 m .73348 .34772 L .74327 .32716 L .714 0 0 r
F
.37678 .59559 m .4111 .61544 L .39738 .60649 L .486 0 0 r
F
.33272 .73513 m .31689 .73108 L .3037 .72124 L .601 0 0 r
F
.33272 .73513 m .33808 .7412 L .31689 .73108 L F
.72199 .39208 m .6895 .391 L .69189 .37211 L .882 0 0 r
F
.72199 .39208 m .72132 .41189 L .6895 .391 L F
.29592 .70638 m .29391 .70098 L .28435 .68246 L 0 0 0 r
F
.29592 .70638 m .3037 .72124 L .29391 .70098 L F
.77633 .30537 m .7573 .32843 L .74327 .32716 L .671 0 0 r
F
.77633 .30537 m .77044 .32382 L .7573 .32843 L F
.79902 .32487 m .79707 .3615 L .785 .34146 L .521 0 0 r
F
.77773 .31503 m .785 .34146 L .77044 .32382 L .582 0 0 r
F
.77773 .31503 m .79902 .32487 L .785 .34146 L F
.3264 .60106 m .34471 .59748 L .34952 .5935 L 0 0 0 r
F
.3264 .60106 m .31266 .60795 L .34471 .59748 L F
.81657 .33882 m .80554 .38214 L .79707 .3615 L .446 0 0 r
F
.79902 .32487 m .81657 .33882 L .79707 .3615 L .521 0 0 r
F
.76678 .41582 m .72428 .42761 L .72132 .41189 L .714 0 0 r
F
.76678 .41582 m .76781 .43135 L .72428 .42761 L F
.8096 .40149 m .76781 .43135 L .76678 .41582 L .525 0 0 r
F
.80554 .38214 m .8096 .40149 L .76678 .41582 L .58 0 0 r
F
.77633 .30537 m .74327 .32716 L .73361 .32048 L .671 0 0 r
F
.74327 .32716 m .71505 .33516 L .73361 .32048 L .769 0 0 r
F
.4223 .64802 m .42811 .6929 L .43234 .67378 L 1 0 0 r
F
.41973 .62973 m .4223 .64802 L .43234 .67378 L .895 0 0 r
F
.40197 .72821 m .38883 .73615 L .36541 .74312 L .12 0 0 r
F
.42811 .6929 m .41685 .70981 L .40197 .72821 L 0 0 0 r
F
.41685 .70981 m .38883 .73615 L .40197 .72821 L .739 0 0 r
F
.77633 .30537 m .77773 .31503 L .77044 .32382 L .671 0 0 r
F
.28718 .64379 m .29889 .63881 L .30314 .62093 L 0 0 0 r
F
.28718 .64379 m .28207 .66274 L .29889 .63881 L F
.72132 .41189 m .69385 .40778 L .6895 .391 L .892 0 0 r
F
.72132 .41189 m .72428 .42761 L .69385 .40778 L F
.82869 .35564 m .8096 .40149 L .80554 .38214 L .337 0 0 r
F
.81657 .33882 m .82869 .35564 L .80554 .38214 L .446 0 0 r
F
.71505 .33516 m .69603 .32794 L .71181 .31694 L .89 0 0 r
F
.71505 .33516 m .7007 .35291 L .69603 .32794 L F
.73361 .32048 m .71505 .33516 L .71181 .31694 L .803 0 0 r
F
.37678 .59559 m .38259 .60038 L .4111 .61544 L .486 0 0 r
F
.34952 .5935 m .38259 .60038 L .37678 .59559 L .455 0 0 r
F
.38259 .60038 m .41973 .62973 L .4111 .61544 L .833 0 0 r
F
.77633 .30537 m .73361 .32048 L .732 .31086 L .671 0 0 r
F
.73361 .32048 m .71181 .31694 L .732 .31086 L .803 0 0 r
F
.34952 .5935 m .34471 .59748 L .38259 .60038 L .455 0 0 r
F
.7007 .35291 m .68623 .34288 L .69603 .32794 L .972 0 0 r
F
.7007 .35291 m .69189 .37211 L .68623 .34288 L F
.36541 .74312 m .34547 .74017 L .33808 .7412 L .125 0 0 r
F
.36541 .74312 m .35998 .74119 L .34547 .74017 L F
.38883 .73615 m .35998 .74119 L .36541 .74312 L .453 0 0 r
F
.3037 .72124 m .30988 .7164 L .29391 .70098 L 0 0 0 r
F
.3037 .72124 m .31689 .73108 L .30988 .7164 L F
.33808 .7412 m .33429 .73481 L .31689 .73108 L .142 0 0 r
F
.33808 .7412 m .34547 .74017 L .33429 .73481 L F
.77633 .30537 m .79902 .32487 L .77773 .31503 L .506 0 0 r
F
.76781 .43135 m .73066 .43771 L .72428 .42761 L .649 0 0 r
F
.76781 .43135 m .76802 .4409 L .73066 .43771 L F
.80883 .41774 m .76802 .4409 L .76781 .43135 L .396 0 0 r
F
.8096 .40149 m .80883 .41774 L .76781 .43135 L .525 0 0 r
F
.41845 .66856 m .41685 .70981 L .42811 .6929 L .959 0 0 r
F
.4223 .64802 m .41845 .66856 L .42811 .6929 L 1 0 0 r
F
.83415 .37375 m .80883 .41774 L .8096 .40149 L .141 0 0 r
F
.82869 .35564 m .83415 .37375 L .8096 .40149 L .337 0 0 r
F
.69189 .37211 m .68348 .36037 L .68623 .34288 L .971 0 0 r
F
.69189 .37211 m .6895 .391 L .68348 .36037 L F
.31266 .60795 m .34109 .6086 L .34471 .59748 L .376 0 0 r
F
.31266 .60795 m .30314 .62093 L .34109 .6086 L F
.28207 .66274 m .30046 .65986 L .29889 .63881 L .156 0 0 r
F
.28207 .66274 m .28435 .68246 L .30046 .65986 L F
.79655 .30645 m .81657 .33882 L .79902 .32487 L .339 0 0 r
F
.77633 .30537 m .79655 .30645 L .79902 .32487 L .506 0 0 r
F
.77633 .30537 m .732 .31086 L .73917 .30196 L .671 0 0 r
F
.732 .31086 m .72538 .29993 L .73917 .30196 L .77 0 0 r
F
.732 .31086 m .71181 .31694 L .72538 .29993 L F
.72428 .42761 m .70465 .42081 L .69385 .40778 L .762 0 0 r
F
.72428 .42761 m .73066 .43771 L .70465 .42081 L F
.38883 .73615 m .37237 .73749 L .35998 .74119 L .453 0 0 r
F
.39958 .72278 m .37237 .73749 L .38883 .73615 L .753 0 0 r
F
.41685 .70981 m .39958 .72278 L .38883 .73615 L .739 0 0 r
F
.38602 .61202 m .4223 .64802 L .41973 .62973 L .873 0 0 r
F
.38259 .60038 m .38602 .61202 L .41973 .62973 L .833 0 0 r
F
.77633 .30537 m .75244 .29723 L .76667 .29854 L .671 0 0 r
F
.77633 .30537 m .73917 .30196 L .75244 .29723 L F
.76667 .29854 m .79655 .30645 L .77633 .30537 L .439 0 0 r
F
.81337 .31348 m .82869 .35564 L .81657 .33882 L .056 0 0 r
F
.79655 .30645 m .81337 .31348 L .81657 .33882 L .339 0 0 r
F
.71181 .31694 m .71467 .30446 L .72538 .29993 L .781 0 0 r
F
.71181 .31694 m .69603 .32794 L .71467 .30446 L F
.34471 .59748 m .38602 .61202 L .38259 .60038 L .671 0 0 r
F
.31689 .73108 m .33068 .7271 L .30988 .7164 L .369 0 0 r
F
.31689 .73108 m .33429 .73481 L .33068 .7271 L F
.73917 .30196 m .7508 .29083 L .75244 .29723 L .614 0 0 r
F
.73917 .30196 m .72538 .29993 L .7508 .29083 L F
.40846 .68925 m .39958 .72278 L .41685 .70981 L .889 0 0 r
F
.41845 .66856 m .40846 .68925 L .41685 .70981 L .959 0 0 r
F
.6895 .391 m .68815 .37874 L .68348 .36037 L 0 0 0 r
F
.6895 .391 m .69385 .40778 L .68815 .37874 L F
.28435 .68246 m .30776 .68193 L .30046 .65986 L .334 0 0 r
F
.28435 .68246 m .29391 .70098 L .30776 .68193 L F
.34471 .59748 m .34109 .6086 L .38602 .61202 L .671 0 0 r
F
.80883 .41774 m .80318 .42929 L .76802 .4409 L .396 0 0 r
F
.83231 .39142 m .80318 .42929 L .80883 .41774 L 0 0 0 r
F
.83415 .37375 m .83231 .39142 L .80883 .41774 L .141 0 0 r
F
.76667 .29854 m .77814 .29335 L .79655 .30645 L .439 0 0 r
F
.75244 .29723 m .77814 .29335 L .76667 .29854 L .455 0 0 r
F
.36336 .71721 m .35998 .74119 L .37237 .73749 L .65 0 0 r
F
.36336 .71721 m .34547 .74017 L .35998 .74119 L F
.75244 .29723 m .7508 .29083 L .77814 .29335 L .455 0 0 r
F
.36336 .71721 m .33429 .73481 L .34547 .74017 L .65 0 0 r
F
.30314 .62093 m .33905 .62589 L .34109 .6086 L .509 0 0 r
F
.30314 .62093 m .29889 .63881 L .33905 .62589 L F
.76802 .4409 m .73995 .44106 L .73066 .43771 L .318 0 0 r
F
.76802 .4409 m .76735 .4434 L .73995 .44106 L F
.80318 .42929 m .76735 .4434 L .76802 .4409 L 0 0 0 r
F
.82509 .32589 m .83415 .37375 L .82869 .35564 L F
.81337 .31348 m .82509 .32589 L .82869 .35564 L .056 0 0 r
F
.38663 .62948 m .41845 .66856 L .4223 .64802 L .862 0 0 r
F
0 g
.01 w
[ ] 0 setdash
.41537 .65137 m
.41926 .65023 L
s
.35746 .66828 m
.40655 .65394 L
s
.41926 .65023 m
.42135 .64962 L
s
.38602 .61202 m .38663 .62948 L .4223 .64802 L .873 0 0 r
F
0 g
.42135 .64962 m
.4312 .64674 L
s
.69603 .32794 m .70819 .31526 L .71467 .30446 L 0 0 0 r
F
.69603 .32794 m .68623 .34288 L .70819 .31526 L F
.36336 .71721 m .37237 .73749 L .37797 .73044 L .65 0 0 r
F
.39958 .72278 m .37797 .73044 L .37237 .73749 L .753 0 0 r
F
.77814 .29335 m .81337 .31348 L .79655 .30645 L 0 0 0 r
F
.73066 .43771 m .72098 .42872 L .70465 .42081 L F
.73066 .43771 m .73995 .44106 L .72098 .42872 L F
.39331 .70795 m .37797 .73044 L .39958 .72278 L .807 0 0 r
F
.40846 .68925 m .39331 .70795 L .39958 .72278 L .889 0 0 r
F
.29391 .70098 m .32009 .70269 L .30776 .68193 L .449 0 0 r
F
.29391 .70098 m .30988 .7164 L .32009 .70269 L F
.36336 .71721 m .33068 .7271 L .33429 .73481 L .65 0 0 r
F
.69385 .40778 m .69992 .39616 L .68815 .37874 L 0 0 0 r
F
.69385 .40778 m .70465 .42081 L .69992 .39616 L F
.72538 .29993 m .74996 .29183 L .7508 .29083 L F
.72538 .29993 m .71467 .30446 L .74996 .29183 L F
.34109 .6086 m .38663 .62948 L .38602 .61202 L .716 0 0 r
F
.36336 .71721 m .37797 .73044 L .37457 .72269 L .65 0 0 r
F
.39331 .70795 m .37457 .72269 L .37797 .73044 L .807 0 0 r
F
.30988 .7164 m .33613 .71995 L .32009 .70269 L .537 0 0 r
F
.30988 .7164 m .33068 .7271 L .33613 .71995 L F
.82509 .32589 m .83042 .34256 L .83415 .37375 L 0 0 0 r
F
.83042 .34256 m .83231 .39142 L .83415 .37375 L .914 0 0 r
F
.80318 .42929 m .79311 .43491 L .76735 .4434 L 0 0 0 r
F
.83231 .39142 m .82321 .4069 L .80318 .42929 L F
.82321 .4069 m .79311 .43491 L .80318 .42929 L .713 0 0 r
F
.38432 .65106 m .40846 .68925 L .41845 .66856 L .841 0 0 r
F
.38663 .62948 m .38432 .65106 L .41845 .66856 L .862 0 0 r
F
.29889 .63881 m .33884 .64768 L .33905 .62589 L .567 0 0 r
F
.29889 .63881 m .30046 .65986 L .33884 .64768 L F
.68623 .34288 m .70668 .3314 L .70819 .31526 L .047 0 0 r
F
.68623 .34288 m .68348 .36037 L .70668 .3314 L F
.34109 .6086 m .33905 .62589 L .38663 .62948 L .716 0 0 r
F
.36336 .71721 m .33613 .71995 L .33068 .7271 L .65 0 0 r
F
.77814 .29335 m .78794 .29534 L .81337 .31348 L 0 0 0 r
F
.7508 .29083 m .78794 .29534 L .77814 .29335 L .179 0 0 r
F
.78794 .29534 m .82509 .32589 L .81337 .31348 L .687 0 0 r
F
.7508 .29083 m .74996 .29183 L .78794 .29534 L .179 0 0 r
F
0 g
.67092 .50407 m
.7144 .43651 L
s
.37927 .67452 m .39331 .70795 L .40846 .68925 L .812 0 0 r
F
.38432 .65106 m .37927 .67452 L .40846 .68925 L .841 0 0 r
F
.76735 .4434 m .75131 .43716 L .73995 .44106 L .379 0 0 r
F
.76735 .4434 m .76585 .4384 L .75131 .43716 L F
.79311 .43491 m .76585 .4384 L .76735 .4434 L .56 0 0 r
F
.37203 .69738 m .37457 .72269 L .39331 .70795 L .772 0 0 r
F
.37203 .69738 m .36336 .71721 L .37457 .72269 L F
.70465 .42081 m .71769 .41082 L .69992 .39616 L .284 0 0 r
F
.70465 .42081 m .72098 .42872 L .71769 .41082 L F
.73995 .44106 m .74131 .43062 L .72098 .42872 L .385 0 0 r
F
.73995 .44106 m .75131 .43716 L .74131 .43062 L F
.37927 .67452 m .37203 .69738 L .39331 .70795 L .812 0 0 r
F
.30046 .65986 m .34052 .67168 L .33884 .64768 L .6 0 0 r
F
.30046 .65986 m .30776 .68193 L .34052 .67168 L F
.33905 .62589 m .38432 .65106 L .38663 .62948 L .728 0 0 r
F
.82871 .36187 m .82321 .4069 L .83231 .39142 L .98 0 0 r
F
.83042 .34256 m .82871 .36187 L .83231 .39142 L .914 0 0 r
F
.36336 .71721 m .34863 .71616 L .33613 .71995 L .65 0 0 r
F
.32009 .70269 m .33613 .71995 L .34863 .71616 L .64 0 0 r
F
.71467 .30446 m .75 .30037 L .74996 .29183 L .337 0 0 r
F
.71467 .30446 m .70819 .31526 L .75 .30037 L F
.68348 .36037 m .7104 .35131 L .70668 .3314 L .291 0 0 r
F
.68348 .36037 m .68815 .37874 L .7104 .35131 L F
.3439 .69535 m .36336 .71721 L .37203 .69738 L .714 0 0 r
F
.3439 .69535 m .34863 .71616 L .36336 .71721 L F
.33905 .62589 m .33884 .64768 L .38432 .65106 L .728 0 0 r
F
.30776 .68193 m .3439 .69535 L .34052 .67168 L .623 0 0 r
F
.30776 .68193 m .32009 .70269 L .3439 .69535 L F
.79311 .43491 m .7795 .43389 L .76585 .4384 L .56 0 0 r
F
.80764 .41861 m .7795 .43389 L .79311 .43491 L .759 0 0 r
F
.82321 .4069 m .80764 .41861 L .79311 .43491 L .713 0 0 r
F
.32009 .70269 m .34863 .71616 L .3439 .69535 L .64 0 0 r
F
.79505 .3045 m .83042 .34256 L .82509 .32589 L .897 0 0 r
F
.78794 .29534 m .79505 .3045 L .82509 .32589 L .687 0 0 r
F
.62358 .5924 m .57207 .6169 L .57767 .58882 L .73 .567 0 r
F
0 g
.4312 .64674 m
.49617 .62776 L
s
.62358 .5924 m .62617 .62104 L .57207 .6169 L .73 .567 0 r
F
.62002 .56388 m .62358 .5924 L .57767 .58882 L .726 .615 0 r
F
.66544 .57938 m .62617 .62104 L .62358 .5924 L .606 .474 0 r
F
.65041 .55426 m .62358 .5924 L .62002 .56388 L .628 .544 0 r
F
.65041 .55426 m .66544 .57938 L .62358 .5924 L F
.33884 .64768 m .37927 .67452 L .38432 .65106 L .73 0 0 r
F
.74996 .29183 m .79505 .3045 L .78794 .29534 L .625 0 0 r
F
.72098 .42872 m .73968 .4212 L .71769 .41082 L .479 0 0 r
F
0 g
.7144 .43651 m
.72028 .42737 L
s
.72784 .41561 m
.75907 .36708 L
s
.72098 .42872 m .74131 .43062 L .73968 .4212 L .479 0 0 r
F
0 g
.72028 .42737 m
.72219 .42439 L
s
.72219 .42439 m
.72268 .42364 L
s
.34052 .67168 m .37203 .69738 L .37927 .67452 L .726 0 0 r
F
.34052 .67168 m .3439 .69535 L .37203 .69738 L F
.82002 .38188 m .80764 .41861 L .82321 .4069 L .901 0 0 r
F
.82871 .36187 m .82002 .38188 L .82321 .4069 L .98 0 0 r
F
.62002 .56388 m .57767 .58882 L .58662 .56123 L .726 .615 0 r
F
.6158 .53796 m .62002 .56388 L .58662 .56123 L .714 .663 0 r
F
.63181 .53281 m .62002 .56388 L .6158 .53796 L .645 .614 0 r
F
.63181 .53281 m .65041 .55426 L .62002 .56388 L F
.62617 .62104 m .57036 .64298 L .57207 .6169 L .728 .509 0 r
F
0 g
.49617 .62776 m
.5023 .62597 L
s
.62617 .62104 m .62757 .64729 L .57036 .64298 L .728 .509 0 r
F
.67558 .60594 m .62757 .64729 L .62617 .62104 L .576 .392 0 r
F
.66544 .57938 m .67558 .60594 L .62617 .62104 L .606 .474 0 r
F
.57767 .58882 m .53242 .59485 L .54414 .56984 L .848 .686 0 r
F
.57767 .58882 m .57207 .6169 L .53242 .59485 L F
.58662 .56123 m .57767 .58882 L .54414 .56984 L .816 .715 0 r
F
.68815 .37874 m .71905 .37296 L .7104 .35131 L .42 0 0 r
F
.68815 .37874 m .69992 .39616 L .71905 .37296 L F
.33884 .64768 m .34052 .67168 L .37927 .67452 L .73 0 0 r
F
.74996 .29183 m .75 .30037 L .79505 .3045 L .625 0 0 r
F
.80695 .82945 m .76464 .85081 L .76892 .82688 L .73 0 0 r
F
.80695 .82945 m .80944 .85379 L .76464 .85081 L F
.80425 .80597 m .80695 .82945 L .76892 .82688 L .726 0 0 r
F
.84308 .82009 m .80944 .85379 L .80695 .82945 L .611 0 0 r
F
.83048 .79906 m .80695 .82945 L .80425 .80597 L .628 0 0 r
F
.83048 .79906 m .84308 .82009 L .80695 .82945 L F
.77571 .40912 m .76585 .4384 L .7795 .43389 L .664 0 0 r
F
.77571 .40912 m .75131 .43716 L .76585 .4384 L F
.58662 .56123 m .54414 .56984 L .56238 .54724 L .816 .715 0 r
F
.59815 .53654 m .58662 .56123 L .56238 .54724 L .772 .735 0 r
F
.6158 .53796 m .58662 .56123 L .59815 .53654 L .714 .663 0 r
F
.77571 .40912 m .74131 .43062 L .75131 .43716 L .664 0 0 r
F
.70819 .31526 m .75096 .31575 L .75 .30037 L .504 0 0 r
F
.70819 .31526 m .70668 .3314 L .75096 .31575 L F
.80425 .80597 m .76892 .82688 L .77658 .80407 L .726 0 0 r
F
.80157 .78543 m .80425 .80597 L .77658 .80407 L .714 0 0 r
F
.81538 .78174 m .80425 .80597 L .80157 .78543 L .642 0 0 r
F
.81538 .78174 m .83048 .79906 L .80425 .80597 L F
.57207 .6169 m .52836 .62001 L .53242 .59485 L .873 .64 0 r
F
.57207 .6169 m .57036 .64298 L .52836 .62001 L F
.80944 .85379 m .76415 .87372 L .76464 .85081 L .728 0 0 r
F
.80944 .85379 m .81148 .87682 L .76415 .87372 L F
.85204 .84294 m .81148 .87682 L .80944 .85379 L .588 0 0 r
F
.84308 .82009 m .85204 .84294 L .80944 .85379 L .611 0 0 r
F
.76892 .82688 m .73369 .83499 L .74273 .81325 L .856 0 0 r
F
.76892 .82688 m .76464 .85081 L .73369 .83499 L F
.77658 .80407 m .76892 .82688 L .74273 .81325 L .824 0 0 r
F
.79867 .32009 m .82871 .36187 L .83042 .34256 L .894 0 0 r
F
.79505 .3045 m .79867 .32009 L .83042 .34256 L .897 0 0 r
F
.77571 .40912 m .7795 .43389 L .7871 .42529 L .664 0 0 r
F
.80764 .41861 m .7871 .42529 L .7795 .43389 L .759 0 0 r
F
.77658 .80407 m .74273 .81325 L .75764 .79403 L .824 0 0 r
F
.78697 .78441 m .77658 .80407 L .75764 .79403 L .777 0 0 r
F
.80157 .78543 m .77658 .80407 L .78697 .78441 L .714 0 0 r
F
.80517 .40051 m .7871 .42529 L .80764 .41861 L .808 0 0 r
F
.82002 .38188 m .80517 .40051 L .80764 .41861 L .901 0 0 r
F
.76464 .85081 m .73143 .85727 L .73369 .83499 L .878 0 0 r
F
.76464 .85081 m .76415 .87372 L .73143 .85727 L F
.69992 .39616 m .73174 .3941 L .71905 .37296 L .504 0 0 r
F
.69992 .39616 m .71769 .41082 L .73174 .3941 L F
.63757 .51214 m .6158 .53796 L .59815 .53654 L .659 .747 0 r
F
0 g
.6669 .51031 m
.67092 .50407 L
s
.63757 .51214 m .63181 .53281 L .6158 .53796 L .659 .747 0 r
F
.66653 .53575 m .66544 .57938 L .65041 .55426 L .492 .486 0 r
F
0 g
.66605 .51162 m
.6669 .51031 L
s
.64016 .52298 m .65041 .55426 L .63181 .53281 L .561 .591 0 r
F
.64016 .52298 m .66653 .53575 L .65041 .55426 L F
.77571 .40912 m .73968 .4212 L .74131 .43062 L .664 0 0 r
F
.68795 .55416 m .67558 .60594 L .66544 .57938 L .409 .365 0 r
F
.66653 .53575 m .68795 .55416 L .66544 .57938 L .492 .486 0 r
F
.62757 .64729 m .57273 .66471 L .57036 .64298 L .715 .428 0 r
F
.62757 .64729 m .62762 .6688 L .57273 .66471 L F
.67986 .63157 m .62762 .6688 L .62757 .64729 L .528 .278 0 r
F
.67558 .60594 m .67986 .63157 L .62757 .64729 L .576 .392 0 r
F
.63757 .51214 m .59815 .53654 L .58545 .52907 L .659 .747 0 r
F
.59815 .53654 m .56238 .54724 L .58545 .52907 L .772 .735 0 r
F
.82198 .76696 m .80157 .78543 L .78697 .78441 L .645 0 0 r
F
.82198 .76696 m .81538 .78174 L .80157 .78543 L F
.84551 .7858 m .84308 .82009 L .83048 .79906 L .495 0 0 r
F
.8232 .7747 m .83048 .79906 L .81538 .78174 L .554 0 0 r
F
.8232 .7747 m .84551 .7858 L .83048 .79906 L F
.864 .80204 m .85204 .84294 L .84308 .82009 L .431 0 0 r
F
.84551 .7858 m .864 .80204 L .84308 .82009 L .495 0 0 r
F
.81148 .87682 m .76755 .89352 L .76415 .87372 L .717 0 0 r
F
.81148 .87682 m .81289 .89644 L .76755 .89352 L F
.85653 .86554 m .81289 .89644 L .81148 .87682 L .554 0 0 r
F
.85204 .84294 m .85653 .86554 L .81148 .87682 L .588 0 0 r
F
.75 .30037 m .79867 .32009 L .79505 .3045 L .711 0 0 r
F
.82198 .76696 m .78697 .78441 L .77704 .77906 L .645 0 0 r
F
.78697 .78441 m .75764 .79403 L .77704 .77906 L .777 0 0 r
F
.63757 .51214 m .64016 .52298 L .63181 .53281 L .659 .747 0 r
F
.77571 .40912 m .7871 .42529 L .7857 .41581 L .664 0 0 r
F
.80517 .40051 m .7857 .41581 L .7871 .42529 L .808 0 0 r
F
.57036 .64298 m .53249 .64297 L .52836 .62001 L .881 .555 0 r
F
.57036 .64298 m .57273 .66471 L .53249 .64297 L F
.71769 .41082 m .74716 .41247 L .73174 .3941 L .571 0 0 r
F
.71769 .41082 m .73968 .4212 L .74716 .41247 L F
.79835 .34061 m .82002 .38188 L .82871 .36187 L .861 0 0 r
F
.79867 .32009 m .79835 .34061 L .82871 .36187 L .894 0 0 r
F
.70238 .57657 m .67986 .63157 L .67558 .60594 L .294 .2 0 r
F
.68795 .55416 m .70238 .57657 L .67558 .60594 L .409 .365 0 r
F
.70668 .3314 m .75275 .3365 L .75096 .31575 L .569 0 0 r
F
.70668 .3314 m .7104 .35131 L .75275 .3365 L F
.56238 .54724 m .53575 .542 L .55653 .52688 L .893 .871 0 r
F
.56238 .54724 m .54414 .56984 L .53575 .542 L F
.58545 .52907 m .56238 .54724 L .55653 .52688 L .807 .834 0 r
F
.82198 .76696 m .8232 .7747 L .81538 .78174 L .645 0 0 r
F
.75 .30037 m .75096 .31575 L .79867 .32009 L .711 0 0 r
F
.76415 .87372 m .73626 .87798 L .73143 .85727 L .882 0 0 r
F
.76415 .87372 m .76755 .89352 L .73626 .87798 L F
.87689 .82194 m .85653 .86554 L .85204 .84294 L .35 0 0 r
F
.864 .80204 m .87689 .82194 L .85204 .84294 L .431 0 0 r
F
.63757 .51214 m .58545 .52907 L .58253 .51831 L .659 .747 0 r
F
.58545 .52907 m .55653 .52688 L .58253 .51831 L .807 .834 0 r
F
.77571 .40912 m .74716 .41247 L .73968 .4212 L .664 0 0 r
F
.75764 .79403 m .73842 .79336 L .75467 .77947 L .911 0 0 r
F
.75764 .79403 m .74273 .81325 L .73842 .79336 L F
.77704 .77906 m .75764 .79403 L .75467 .77947 L .814 0 0 r
F
.54414 .56984 m .52226 .56236 L .53575 .542 L .969 .883 0 r
F
.54414 .56984 m .53242 .59485 L .52226 .56236 L F
0 g
.5365 .61599 m
.61333 .59354 L
s
.82198 .76696 m .77704 .77906 L .77558 .77136 L .645 0 0 r
F
.77704 .77906 m .75467 .77947 L .77558 .77136 L .814 0 0 r
F
.74273 .81325 m .72845 .81182 L .73842 .79336 L .981 0 0 r
F
.74273 .81325 m .73369 .83499 L .72845 .81182 L F
.79406 .36395 m .80517 .40051 L .82002 .38188 L .82 0 0 r
F
.79835 .34061 m .79406 .36395 L .82002 .38188 L .861 0 0 r
F
.78623 .38762 m .7857 .41581 L .80517 .40051 L .773 0 0 r
F
.78623 .38762 m .77571 .40912 L .7857 .41581 L F
.63757 .51214 m .66653 .53575 L .64016 .52298 L .452 .6 0 r
F
.79406 .36395 m .78623 .38762 L .80517 .40051 L .82 0 0 r
F
.82198 .76696 m .84551 .7858 L .8232 .7747 L .425 0 0 r
F
.7104 .35131 m .75519 .36049 L .75275 .3365 L .605 0 0 r
F
.7104 .35131 m .71905 .37296 L .75519 .36049 L F
.62762 .6688 m .57909 .67997 L .57273 .66471 L .67 .28 0 r
F
.62762 .6688 m .6263 .68345 L .57909 .67997 L F
.67778 .65391 m .6263 .68345 L .62762 .6688 L .426 .077 0 r
F
.67986 .63157 m .67778 .65391 L .62762 .6688 L .528 .278 0 r
F
.75096 .31575 m .79835 .34061 L .79867 .32009 L .729 0 0 r
F
.81289 .89644 m .77461 .90829 L .76755 .89352 L .683 0 0 r
F
.81289 .89644 m .81353 .91078 L .77461 .90829 L F
.85605 .88579 m .81353 .91078 L .81289 .89644 L .488 0 0 r
F
.85653 .86554 m .85605 .88579 L .81289 .89644 L .554 0 0 r
F
.77571 .40912 m .76095 .40784 L .74716 .41247 L .664 0 0 r
F
.73174 .3941 m .74716 .41247 L .76095 .40784 L .647 0 0 r
F
.70832 .60093 m .67778 .65391 L .67986 .63157 L .103 0 0 r
F
.70238 .57657 m .70832 .60093 L .67986 .63157 L .294 .2 0 r
F
.88288 .84367 m .85605 .88579 L .85653 .86554 L .23 0 0 r
F
.87689 .82194 m .88288 .84367 L .85653 .86554 L .35 0 0 r
F
.53242 .59485 m .51751 .58609 L .52226 .56236 L .994 .819 0 r
F
.53242 .59485 m .52836 .62001 L .51751 .58609 L F
0 g
.5023 .62597 m
.52788 .6185 L
s
.73369 .83499 m .72584 .83312 L .72845 .81182 L .952 0 0 r
F
.73369 .83499 m .73143 .85727 L .72584 .83312 L F
.66187 .51511 m .68795 .55416 L .66653 .53575 L .228 .424 0 r
F
.63757 .51214 m .66187 .51511 L .66653 .53575 L .452 .6 0 r
F
.84338 .77108 m .864 .80204 L .84551 .7858 L .212 0 0 r
F
.82198 .76696 m .84338 .77108 L .84551 .7858 L .425 0 0 r
F
.82198 .76696 m .77558 .77136 L .78327 .76423 L .645 0 0 r
F
.77558 .77136 m .76922 .76586 L .78327 .76423 L .71 0 0 r
F
.77558 .77136 m .75467 .77947 L .76922 .76586 L F
.63757 .51214 m .58253 .51831 L .59067 .50831 L .659 .747 0 r
F
.58253 .51831 m .5719 .50777 L .59067 .50831 L .76 .928 0 r
F
.58253 .51831 m .55653 .52688 L .5719 .50777 L F
.75802 .38514 m .77571 .40912 L .78623 .38762 L .714 0 0 r
F
.75802 .38514 m .76095 .40784 L .77571 .40912 L F
.76755 .89352 m .74786 .89512 L .73626 .87798 L .828 0 0 r
F
.76755 .89352 m .77461 .90829 L .74786 .89512 L F
.75096 .31575 m .75275 .3365 L .79835 .34061 L .729 0 0 r
F
.57273 .66471 m .54463 .66149 L .53249 .64297 L .823 .361 0 r
F
.57273 .66471 m .57909 .67997 L .54463 .66149 L F
.71905 .37296 m .75802 .38514 L .75519 .36049 L .629 0 0 r
F
.71905 .37296 m .73174 .3941 L .75802 .38514 L F
.73174 .3941 m .76095 .40784 L .75802 .38514 L .647 0 0 r
F
.82198 .76696 m .79723 .76043 L .81206 .76148 L .645 0 0 r
F
.82198 .76696 m .78327 .76423 L .79723 .76043 L F
.81206 .76148 m .84338 .77108 L .82198 .76696 L .23 0 0 r
F
.86129 .78184 m .87689 .82194 L .864 .80204 L 0 0 0 r
F
.84338 .77108 m .86129 .78184 L .864 .80204 L .212 0 0 r
F
.63757 .51214 m .60688 .50299 L .62486 .50446 L .659 .747 0 r
F
.63757 .51214 m .59067 .50831 L .60688 .50299 L F
.62486 .50446 m .66187 .51511 L .63757 .51214 L .332 .656 0 r
F
.75275 .3365 m .79406 .36395 L .79835 .34061 L .731 0 0 r
F
.75467 .77947 m .75842 .77464 L .76922 .76586 L .531 0 0 r
F
.75467 .77947 m .73842 .79336 L .75842 .77464 L F
.68183 .5258 m .70238 .57657 L .68795 .55416 L 0 .103 0 r
F
.66187 .51511 m .68183 .5258 L .68795 .55416 L .228 .424 0 r
F
0 g
.66331 .51589 m
.66605 .51162 L
s
.75519 .36049 m .78623 .38762 L .79406 .36395 L .726 0 0 r
F
.75519 .36049 m .75802 .38514 L .78623 .38762 L F
.55653 .52688 m .55681 .51566 L .5719 .50777 L .753 .993 0 r
F
.55653 .52688 m .53575 .542 L .55681 .51566 L F
.78327 .76423 m .79599 .75858 L .79723 .76043 L .353 0 0 r
F
.78327 .76423 m .76922 .76586 L .79599 .75858 L F
.73143 .85727 m .73099 .8552 L .72584 .83312 L 0 0 0 r
F
.73143 .85727 m .73626 .87798 L .73099 .8552 L F
.75275 .3365 m .75519 .36049 L .79406 .36395 L .731 0 0 r
F
.59067 .50831 m .603 .49752 L .60688 .50299 L .543 .9 0 r
F
.59067 .50831 m .5719 .50777 L .603 .49752 L F
.52836 .62001 m .52218 .61092 L .51751 .58609 L .817 .539 0 r
F
.52836 .62001 m .53249 .64297 L .52218 .61092 L F
.85605 .88579 m .85055 .90173 L .81353 .91078 L .488 0 0 r
F
.88127 .86515 m .85055 .90173 L .85605 .88579 L .014 0 0 r
F
.88288 .84367 m .88127 .86515 L .85605 .88579 L .23 0 0 r
F
.81206 .76148 m .82448 .76059 L .84338 .77108 L F
.79723 .76043 m .82448 .76059 L .81206 .76148 L .126 0 0 r
F
.79723 .76043 m .79599 .75858 L .82448 .76059 L F
.67778 .65391 m .66938 .67078 L .6263 .68345 L .426 .077 0 r
F
.70502 .62494 m .66938 .67078 L .67778 .65391 L 0 0 0 r
F
.70832 .60093 m .70502 .62494 L .67778 .65391 L .103 0 0 r
F
.62486 .50446 m .6376 .50036 L .66187 .51511 L .332 .656 0 r
F
.60688 .50299 m .6376 .50036 L .62486 .50446 L .326 .76 0 r
F
.81353 .91078 m .78475 .91649 L .77461 .90829 L .557 0 0 r
F
.81353 .91078 m .81331 .91831 L .78475 .91649 L F
.85055 .90173 m .81331 .91831 L .81353 .91078 L .314 0 0 r
F
.8739 .79834 m .88288 .84367 L .87689 .82194 L 0 0 0 r
F
.86129 .78184 m .8739 .79834 L .87689 .82194 L F
.60688 .50299 m .603 .49752 L .6376 .50036 L .326 .76 0 r
F
.73842 .79336 m .75201 .7899 L .75842 .77464 L 0 0 0 r
F
.73842 .79336 m .72845 .81182 L .75201 .7899 L F
.82448 .76059 m .86129 .78184 L .84338 .77108 L .404 0 0 r
F
.6263 .68345 m .58896 .68711 L .57909 .67997 L .474 0 0 r
F
.6263 .68345 m .62367 .68966 L .58896 .68711 L F
.66938 .67078 m .62367 .68966 L .6263 .68345 L .132 0 0 r
F
.77461 .90829 m .76524 .90691 L .74786 .89512 L .539 0 0 r
F
.77461 .90829 m .78475 .91649 L .76524 .90691 L F
.69539 .54337 m .70832 .60093 L .70238 .57657 L 0 0 0 r
F
.68183 .5258 m .69539 .54337 L .70238 .57657 L 0 .103 0 r
F
.53575 .542 m .54702 .53144 L .55681 .51566 L 0 0 0 r
F
.53575 .542 m .52226 .56236 L .54702 .53144 L F
.6376 .50036 m .68183 .5258 L .66187 .51511 L 0 .276 0 r
F
.57909 .67997 m .56378 .67362 L .54463 .66149 L .454 0 0 r
F
.57909 .67997 m .58896 .68711 L .56378 .67362 L F
.73626 .87798 m .74351 .87588 L .73099 .8552 L 0 0 0 r
F
.73626 .87798 m .74786 .89512 L .74351 .87588 L F
.76922 .76586 m .79558 .76457 L .79599 .75858 L .224 0 0 r
F
.76922 .76586 m .75842 .77464 L .79558 .76457 L F
.53249 .64297 m .536 .63436 L .52218 .61092 L 0 0 0 r
F
.53249 .64297 m .54463 .66149 L .536 .63436 L F
.8739 .79834 m .87981 .81905 L .88288 .84367 L F
.87981 .81905 m .88127 .86515 L .88288 .84367 L .876 0 0 r
F
.85055 .90173 m .84044 .91172 L .81331 .91831 L .314 0 0 r
F
.87207 .88427 m .84044 .91172 L .85055 .90173 L 0 0 0 r
F
.88127 .86515 m .87207 .88427 L .85055 .90173 L .014 0 0 r
F
.72845 .81182 m .75076 .81023 L .75201 .7899 L .159 0 0 r
F
.72845 .81182 m .72584 .83312 L .75076 .81023 L F
.5719 .50777 m .60005 .50143 L .603 .49752 L 0 0 0 r
F
.5719 .50777 m .55681 .51566 L .60005 .50143 L F
.82448 .76059 m .83518 .76737 L .86129 .78184 L .404 0 0 r
F
.79599 .75858 m .83518 .76737 L .82448 .76059 L .499 0 0 r
F
.83518 .76737 m .8739 .79834 L .86129 .78184 L .806 0 0 r
F
.69539 .54337 m .70103 .56623 L .70832 .60093 L 0 0 0 r
F
.70103 .56623 m .70502 .62494 L .70832 .60093 L .959 .79 0 r
F
.66938 .67078 m .65528 .68039 L .62367 .68966 L .132 0 0 r
F
.70502 .62494 m .6926 .64621 L .66938 .67078 L 0 0 0 r
F
.6926 .64621 m .65528 .68039 L .66938 .67078 L .646 .943 0 r
F
.79599 .75858 m .79558 .76457 L .83518 .76737 L .499 0 0 r
F
0 g
.75716 .77764 m
.80465 .83841 L
s
.72798 .74028 m
.75598 .77613 L
s
.75598 .77613 m
.75635 .77659 L
s
.67154 .66804 m
.67203 .66868 L
s
.61333 .59354 m
.67038 .66656 L
s
.67203 .66868 m
.72798 .74028 L
s
.52226 .56236 m .54369 .55374 L .54702 .53144 L 0 0 0 r
F
.52226 .56236 m .51751 .58609 L .54369 .55374 L F
.81331 .91831 m .79706 .91713 L .78475 .91649 L F
.81331 .91831 m .81223 .91809 L .79706 .91713 L F
.84044 .91172 m .81223 .91809 L .81331 .91831 L .205 0 0 r
F
.74786 .89512 m .76224 .893 L .74351 .87588 L .122 0 0 r
F
.74786 .89512 m .76524 .90691 L .76224 .893 L F
.6376 .50036 m .64825 .50538 L .68183 .5258 L 0 .276 0 r
F
.603 .49752 m .64825 .50538 L .6376 .50036 L .361 0 0 r
F
.78475 .91649 m .78678 .91206 L .76524 .90691 L .109 0 0 r
F
.78475 .91649 m .79706 .91713 L .78678 .91206 L F
.64825 .50538 m .69539 .54337 L .68183 .5258 L .786 .287 0 r
F
0 g
.61333 .59354 m
.66005 .52094 L
s
.87831 .84196 m .87207 .88427 L .88127 .86515 L .973 0 0 r
F
.87981 .81905 m .87831 .84196 L .88127 .86515 L .876 0 0 r
F
.603 .49752 m .60005 .50143 L .64825 .50538 L .361 0 0 r
F
.75842 .77464 m .79607 .77806 L .79558 .76457 L .456 0 0 r
F
.75842 .77464 m .75201 .7899 L .79607 .77806 L F
.72584 .83312 m .75489 .83366 L .75076 .81023 L .307 0 0 r
F
.72584 .83312 m .73099 .8552 L .75489 .83366 L F
.62367 .68966 m .60148 .68513 L .58896 .68711 L .178 .693 0 r
F
.62367 .68966 m .61995 .68649 L .60148 .68513 L F
.65528 .68039 m .61995 .68649 L .62367 .68966 L .433 .868 0 r
F
.54463 .66149 m .55771 .65397 L .536 .63436 L .122 .372 0 r
F
.54463 .66149 m .56378 .67362 L .55771 .65397 L F
.84044 .91172 m .8266 .9146 L .81223 .91809 L .205 0 0 r
F
.87207 .88427 m .85606 .89905 L .84044 .91172 L 0 0 0 r
F
.85606 .89905 m .8266 .9146 L .84044 .91172 L .654 0 0 r
F
.58896 .68711 m .58819 .67797 L .56378 .67362 L .221 .622 0 r
F
.58896 .68711 m .60148 .68513 L .58819 .67797 L F
.84306 .78135 m .87981 .81905 L .8739 .79834 L .89 0 0 r
F
.83518 .76737 m .84306 .78135 L .8739 .79834 L .806 0 0 r
F
.69798 .59218 m .6926 .64621 L .70502 .62494 L .979 .905 0 r
F
.70103 .56623 m .69798 .59218 L .70502 .62494 L .959 .79 0 r
F
.55681 .51566 m .59835 .51467 L .60005 .50143 L .365 0 0 r
F
.55681 .51566 m .54702 .53144 L .59835 .51467 L F
.51751 .58609 m .54733 .5804 L .54369 .55374 L .225 .138 0 r
F
.51751 .58609 m .52218 .61092 L .54733 .5804 L F
.79558 .76457 m .84306 .78135 L .83518 .76737 L .672 0 0 r
F
.76524 .90691 m .78532 .90476 L .76224 .893 L .375 0 0 r
F
.76524 .90691 m .78678 .91206 L .78532 .90476 L F
.86941 .86472 m .85606 .89905 L .87207 .88427 L .918 0 0 r
F
.87831 .84196 m .86941 .86472 L .87207 .88427 L .973 0 0 r
F
.73099 .8552 m .76406 .85775 L .75489 .83366 L .402 0 0 r
F
.73099 .8552 m .74351 .87588 L .76406 .85775 L F
.65528 .68039 m .63673 .68156 L .61995 .68649 L .433 .868 0 r
F
.67211 .66253 m .63673 .68156 L .65528 .68039 L .735 .954 0 r
F
.6926 .64621 m .67211 .66253 L .65528 .68039 L .646 .943 0 r
F
.79558 .76457 m .79607 .77806 L .84306 .78135 L .672 0 0 r
F
.8233 .89539 m .81223 .91809 L .8266 .9146 L .629 0 0 r
F
.8233 .89539 m .79706 .91713 L .81223 .91809 L F
.65567 .51933 m .70103 .56623 L .69539 .54337 L .891 .541 0 r
F
.64825 .50538 m .65567 .51933 L .69539 .54337 L .786 .287 0 r
F
.8233 .89539 m .78678 .91206 L .79706 .91713 L .629 0 0 r
F
.75201 .7899 m .79743 .79786 L .79607 .77806 L .538 0 0 r
F
.75201 .7899 m .75076 .81023 L .79743 .79786 L F
.84721 .8013 m .87831 .84196 L .87981 .81905 L .89 0 0 r
F
.84306 .78135 m .84721 .8013 L .87981 .81905 L F
.8233 .89539 m .8266 .9146 L .83478 .90793 L .629 0 0 r
F
.85606 .89905 m .83478 .90793 L .8266 .9146 L .654 0 0 r
F
.60005 .50143 m .65567 .51933 L .64825 .50538 L .65 .228 0 r
F
.56378 .67362 m .58515 .66765 L .55771 .65397 L .401 .591 0 r
F
.56378 .67362 m .58819 .67797 L .58515 .66765 L F
.85397 .88498 m .83478 .90793 L .85606 .89905 L .816 0 0 r
F
.86941 .86472 m .85397 .88498 L .85606 .89905 L .918 0 0 r
F
.68637 .61857 m .67211 .66253 L .6926 .64621 L .906 .901 0 r
F
.69798 .59218 m .68637 .61857 L .6926 .64621 L .979 .905 0 r
F
.74351 .87588 m .77735 .87999 L .76406 .85775 L .473 0 0 r
F
.74351 .87588 m .76224 .893 L .77735 .87999 L F
.8233 .89539 m .78532 .90476 L .78678 .91206 L .629 0 0 r
F
.52218 .61092 m .55769 .60867 L .54733 .5804 L .367 .334 0 r
F
.52218 .61092 m .536 .63436 L .55769 .60867 L F
.60005 .50143 m .59835 .51467 L .65567 .51933 L .65 .228 0 r
F
.62953 .65436 m .61995 .68649 L .63673 .68156 L .647 .762 0 r
F
.62953 .65436 m .60148 .68513 L .61995 .68649 L F
.79607 .77806 m .84721 .8013 L .84306 .78135 L .715 0 0 r
F
.62953 .65436 m .58819 .67797 L .60148 .68513 L .647 .762 0 r
F
.54702 .53144 m .59813 .53617 L .59835 .51467 L .503 .24 0 r
F
.54702 .53144 m .54369 .55374 L .59813 .53617 L F
.8233 .89539 m .83478 .90793 L .83357 .90058 L .629 0 0 r
F
.85397 .88498 m .83357 .90058 L .83478 .90793 L .816 0 0 r
F
.76224 .893 m .79336 .89799 L .77735 .87999 L .536 0 0 r
F
.76224 .893 m .78532 .90476 L .79336 .89799 L F
.84712 .82525 m .86941 .86472 L .87831 .84196 L .867 0 0 r
F
.84721 .8013 m .84712 .82525 L .87831 .84196 L .89 0 0 r
F
.75076 .81023 m .79954 .82202 L .79743 .79786 L .578 0 0 r
F
.75076 .81023 m .75489 .83366 L .79954 .82202 L F
.65896 .54105 m .69798 .59218 L .70103 .56623 L .887 .643 0 r
F
.65567 .51933 m .65896 .54105 L .70103 .56623 L .891 .541 0 r
F
.79607 .77806 m .79743 .79786 L .84721 .8013 L .715 0 0 r
F
.62953 .65436 m .63673 .68156 L .64551 .67213 L .647 .762 0 r
F
.67211 .66253 m .64551 .67213 L .63673 .68156 L .735 .954 0 r
F
.8233 .89539 m .79336 .89799 L .78532 .90476 L .629 0 0 r
F
.66733 .64261 m .64551 .67213 L .67211 .66253 L .812 .86 0 r
F
.68637 .61857 m .66733 .64261 L .67211 .66253 L .906 .901 0 r
F
.536 .63436 m .57372 .63552 L .55769 .60867 L .464 .473 0 r
F
.536 .63436 m .55771 .65397 L .57372 .63552 L F
.62953 .65436 m .58515 .66765 L .58819 .67797 L .647 .762 0 r
F
.84274 .85071 m .85397 .88498 L .86941 .86472 L .833 0 0 r
F
.84712 .82525 m .84274 .85071 L .86941 .86472 L .867 0 0 r
F
.8345 .87495 m .83357 .90058 L .85397 .88498 L .782 0 0 r
F
.8345 .87495 m .8233 .89539 L .83357 .90058 L F
.84274 .85071 m .8345 .87495 L .85397 .88498 L .833 0 0 r
F
.75489 .83366 m .80218 .848 L .79954 .82202 L .604 0 0 r
F
.75489 .83366 m .76406 .85775 L .80218 .848 L F
.59835 .51467 m .65896 .54105 L .65567 .51933 L .713 .409 0 r
F
.79743 .79786 m .84712 .82525 L .84721 .8013 L .729 0 0 r
F
.8233 .89539 m .8079 .89439 L .79336 .89799 L .629 0 0 r
F
.77735 .87999 m .79336 .89799 L .8079 .89439 L .636 0 0 r
F
.62953 .65436 m .64551 .67213 L .64282 .66173 L .647 .762 0 r
F
.66733 .64261 m .64282 .66173 L .64551 .67213 L .812 .86 0 r
F
.55771 .65397 m .5937 .65806 L .57372 .63552 L .541 .589 0 r
F
.55771 .65397 m .58515 .66765 L .5937 .65806 L F
.65767 .56845 m .68637 .61857 L .69798 .59218 L .861 .695 0 r
F
.65896 .54105 m .65767 .56845 L .69798 .59218 L .887 .643 0 r
F
.54369 .55374 m .59946 .56384 L .59813 .53617 L .562 .373 0 r
F
.54369 .55374 m .54733 .5804 L .59946 .56384 L F
.80507 .87302 m .8233 .89539 L .8345 .87495 L .714 0 0 r
F
.80507 .87302 m .8079 .89439 L .8233 .89539 L F
.59835 .51467 m .59813 .53617 L .65896 .54105 L .713 .409 0 r
F
.79743 .79786 m .79954 .82202 L .84712 .82525 L .729 0 0 r
F
.76406 .85775 m .80507 .87302 L .80218 .848 L .622 0 0 r
F
.76406 .85775 m .77735 .87999 L .80507 .87302 L F
.77735 .87999 m .8079 .89439 L .80507 .87302 L .636 0 0 r
F
.62953 .65436 m .5937 .65806 L .58515 .66765 L .647 .762 0 r
F
.79954 .82202 m .84274 .85071 L .84712 .82525 L .732 0 0 r
F
.65185 .59864 m .66733 .64261 L .68637 .61857 L .825 .727 0 r
F
.65767 .56845 m .65185 .59864 L .68637 .61857 L .861 .695 0 r
F
.80218 .848 m .8345 .87495 L .84274 .85071 L .728 0 0 r
F
.80218 .848 m .80507 .87302 L .8345 .87495 L F
.64212 .62836 m .64282 .66173 L .66733 .64261 L .777 .75 0 r
F
.64212 .62836 m .62953 .65436 L .64282 .66173 L F
.79954 .82202 m .80218 .848 L .84274 .85071 L .732 0 0 r
F
.65185 .59864 m .64212 .62836 L .66733 .64261 L .825 .727 0 r
F
.54733 .5804 m .60222 .59478 L .59946 .56384 L .597 .464 0 r
F
0 g
.59164 .5743 m
.59225 .57484 L
s
.60114 .58273 m
.61333 .59354 L
s
.58425 .56775 m
.59164 .5743 L
s
.54733 .5804 m .55769 .60867 L .60222 .59478 L .597 .464 0 r
F
.59813 .53617 m .65767 .56845 L .65896 .54105 L .729 .502 0 r
F
.62953 .65436 m .61069 .65295 L .5937 .65806 L .647 .762 0 r
F
.57372 .63552 m .5937 .65806 L .61069 .65295 L .638 .617 0 r
F
.6061 .62561 m .62953 .65436 L .64212 .62836 L .714 .67 0 r
F
.6061 .62561 m .61069 .65295 L .62953 .65436 L F
.59813 .53617 m .59946 .56384 L .65767 .56845 L .729 .502 0 r
F
.55769 .60867 m .6061 .62561 L .60222 .59478 L .62 .541 0 r
F
.55769 .60867 m .57372 .63552 L .6061 .62561 L F
.57372 .63552 m .61069 .65295 L .6061 .62561 L .638 .617 0 r
F
.59946 .56384 m .65185 .59864 L .65767 .56845 L .732 .566 0 r
F
.60222 .59478 m .64212 .62836 L .65185 .59864 L .728 .618 0 r
F
.60222 .59478 m .6061 .62561 L .64212 .62836 L F
.59946 .56384 m .60222 .59478 L .65185 .59864 L .732 .566 0 r
F
.54549 .52355 m .49572 .54676 L .50126 .51998 L .734 0 0 r
F
.54549 .52355 m .54783 .5509 L .49572 .54676 L F
.54194 .49605 m .54549 .52355 L .50126 .51998 L .729 0 0 r
F
.5851 .51054 m .54783 .5509 L .54549 .52355 L .587 0 0 r
F
0 g
.55567 .5424 m
.58425 .56775 L
s
.57069 .48646 m .54549 .52355 L .54194 .49605 L .614 0 0 r
F
.57069 .48646 m .5851 .51054 L .54549 .52355 L F
.54194 .49605 m .50126 .51998 L .50977 .49341 L .729 0 0 r
F
.53748 .47082 m .54194 .49605 L .50977 .49341 L .714 0 0 r
F
.55263 .46569 m .54194 .49605 L .53748 .47082 L .635 0 0 r
F
.55263 .46569 m .57069 .48646 L .54194 .49605 L F
.54783 .5509 m .49364 .5714 L .49572 .54676 L .73 0 0 r
F
.54783 .5509 m .54874 .57572 L .49364 .5714 L F
.59456 .5358 m .54874 .57572 L .54783 .5509 L .549 0 0 r
F
.5851 .51054 m .59456 .5358 L .54783 .5509 L .587 0 0 r
F
.50126 .51998 m .45671 .52472 L .46828 .50102 L .862 0 0 r
F
.50126 .51998 m .49572 .54676 L .45671 .52472 L F
.50977 .49341 m .50126 .51998 L .46828 .50102 L .827 0 0 r
F
.50977 .49341 m .46828 .50102 L .48591 .47946 L F
.52049 .46941 m .50977 .49341 L .48591 .47946 L .778 0 0 r
F
.53748 .47082 m .50977 .49341 L .52049 .46941 L .714 0 0 r
F
.49572 .54676 m .45234 .54841 L .45671 .52472 L .887 0 0 r
F
.49572 .54676 m .49364 .5714 L .45234 .54841 L F
.55726 .44511 m .53748 .47082 L .52049 .46941 L .65 0 0 r
F
.55726 .44511 m .55263 .46569 L .53748 .47082 L F
.58534 .46801 m .5851 .51054 L .57069 .48646 L .453 0 0 r
F
.56022 .4559 m .57069 .48646 L .55263 .46569 L .537 0 0 r
F
.56022 .4559 m .58534 .46801 L .57069 .48646 L F
.60555 .48538 m .59456 .5358 L .5851 .51054 L .35 0 0 r
F
.58534 .46801 m .60555 .48538 L .5851 .51054 L .453 0 0 r
F
.54874 .57572 m .49527 .59164 L .49364 .5714 L .711 0 0 r
F
.54874 .57572 m .54812 .59573 L .49527 .59164 L F
.59818 .55997 m .54812 .59573 L .54874 .57572 L .485 0 0 r
F
.59456 .5358 m .59818 .55997 L .54874 .57572 L .549 0 0 r
F
0 g
.53263 .52196 m
.55421 .5411 L
s
.55726 .44511 m .52049 .46941 L .50798 .46197 L .65 0 0 r
F
.52049 .46941 m .48591 .47946 L .50798 .46197 L .778 0 0 r
F
.55726 .44511 m .56022 .4559 L .55263 .46569 L .65 0 0 r
F
.49364 .5714 m .4557 .56986 L .45234 .54841 L .889 0 0 r
F
.49364 .5714 m .49527 .59164 L .4557 .56986 L F
.6189 .50647 m .59818 .55997 L .59456 .5358 L .204 0 0 r
F
.60555 .48538 m .6189 .50647 L .59456 .5358 L .35 0 0 r
F
.48591 .47946 m .45906 .47326 L .47945 .45917 L .899 0 0 r
F
.48591 .47946 m .46828 .50102 L .45906 .47326 L F
.50798 .46197 m .48591 .47946 L .47945 .45917 L .81 0 0 r
F
.55726 .44511 m .50798 .46197 L .50473 .45125 L .65 0 0 r
F
.50798 .46197 m .47945 .45917 L .50473 .45125 L .81 0 0 r
F
.46828 .50102 m .44558 .49229 L .45906 .47326 L .972 0 0 r
F
.46828 .50102 m .45671 .52472 L .44558 .49229 L F
.55726 .44511 m .58534 .46801 L .56022 .4559 L .415 0 0 r
F
.54812 .59573 m .50056 .60551 L .49527 .59164 L .647 0 0 r
F
.54812 .59573 m .54599 .609 L .50056 .60551 L F
.59552 .58081 m .54599 .609 L .54812 .59573 L .35 0 0 r
F
.59818 .55997 m .59552 .58081 L .54812 .59573 L .485 0 0 r
F
.62402 .52934 m .59552 .58081 L .59818 .55997 L 0 0 0 r
F
.6189 .50647 m .62402 .52934 L .59818 .55997 L .204 0 0 r
F
.45671 .52472 m .44046 .51451 L .44558 .49229 L .994 0 0 r
F
.45671 .52472 m .45234 .54841 L .44046 .51451 L F
.57996 .44746 m .60555 .48538 L .58534 .46801 L .161 0 0 r
F
.55726 .44511 m .57996 .44746 L .58534 .46801 L .415 0 0 r
F
.55726 .44511 m .50473 .45125 L .51212 .4413 L .65 0 0 r
F
.50473 .45125 m .49338 .44016 L .51212 .4413 L .756 0 0 r
F
.50473 .45125 m .47945 .45917 L .49338 .44016 L F
.49527 .59164 m .46666 .58697 L .4557 .56986 L .807 0 0 r
F
.49527 .59164 m .50056 .60551 L .46666 .58697 L F
.55726 .44511 m .52744 .436 L .54474 .43747 L .65 0 0 r
F
.55726 .44511 m .51212 .4413 L .52744 .436 L F
.54474 .43747 m .57996 .44746 L .55726 .44511 L .301 0 0 r
F
.5984 .45713 m .6189 .50647 L .60555 .48538 L 0 0 0 r
F
.57996 .44746 m .5984 .45713 L .60555 .48538 L .161 0 0 r
F
.47945 .45917 m .47814 .44703 L .49338 .44016 L .768 0 0 r
F
.47945 .45917 m .45906 .47326 L .47814 .44703 L F
.51212 .4413 m .52276 .42996 L .52744 .436 L .546 0 0 r
F
.51212 .4413 m .49338 .44016 L .52276 .42996 L F
.45234 .54841 m .44439 .5378 L .44046 .51451 L .841 0 0 r
F
.45234 .54841 m .4557 .56986 L .44439 .5378 L F
.59552 .58081 m .58668 .59628 L .54599 .609 L .35 0 0 r
F
.62023 .55182 m .58668 .59628 L .59552 .58081 L 0 0 0 r
F
.62402 .52934 m .62023 .55182 L .59552 .58081 L F
.54474 .43747 m .55605 .43279 L .57996 .44746 L .301 0 0 r
F
.52744 .436 m .55605 .43279 L .54474 .43747 L .325 0 0 r
F
.52744 .436 m .52276 .42996 L .55605 .43279 L F
.54599 .609 m .50911 .61149 L .50056 .60551 L .403 0 0 r
F
.54599 .609 m .5425 .61405 L .50911 .61149 L F
.58668 .59628 m .5425 .61405 L .54599 .609 L .012 0 0 r
F
.5984 .45713 m .61067 .47336 L .6189 .50647 L 0 0 0 r
F
.61067 .47336 m .62402 .52934 L .6189 .50647 L .713 0 0 r
F
.45906 .47326 m .46799 .46148 L .47814 .44703 L 0 0 0 r
F
.45906 .47326 m .44558 .49229 L .46799 .46148 L F
.55605 .43279 m .5984 .45713 L .57996 .44746 L F
.50056 .60551 m .48434 .59795 L .46666 .58697 L .421 0 0 r
F
.50056 .60551 m .50911 .61149 L .48434 .59795 L F
.4557 .56986 m .45716 .55981 L .44439 .5378 L 0 0 0 r
F
.4557 .56986 m .46666 .58697 L .45716 .55981 L F
.49338 .44016 m .51895 .43287 L .52276 .42996 L F
.49338 .44016 m .47814 .44703 L .51895 .43287 L F
.61539 .4947 m .62023 .55182 L .62402 .52934 L .966 0 0 r
F
.61067 .47336 m .61539 .4947 L .62402 .52934 L .713 0 0 r
F
.58668 .59628 m .57234 .60474 L .5425 .61405 L .012 0 0 r
F
.62023 .55182 m .60772 .57167 L .58668 .59628 L 0 0 0 r
F
.60772 .57167 m .57234 .60474 L .58668 .59628 L .692 0 0 r
F
.44558 .49229 m .46414 .48224 L .46799 .46148 L 0 0 0 r
F
.44558 .49229 m .44046 .51451 L .46414 .48224 L F
.55605 .43279 m .56531 .43681 L .5984 .45713 L F
.52276 .42996 m .56531 .43681 L .55605 .43279 L .288 0 0 r
F
.56531 .43681 m .61067 .47336 L .5984 .45713 L .766 0 0 r
F
.52276 .42996 m .51895 .43287 L .56531 .43681 L .288 0 0 r
F
.5425 .61405 m .52019 .60873 L .50911 .61149 L .205 0 0 r
F
.5425 .61405 m .53795 .61009 L .52019 .60873 L F
.57234 .60474 m .53795 .61009 L .5425 .61405 L .46 0 0 r
F
.46666 .58697 m .47761 .57826 L .45716 .55981 L .056 0 0 r
F
.46666 .58697 m .48434 .59795 L .47761 .57826 L F
.50911 .61149 m .50711 .60154 L .48434 .59795 L .202 0 0 r
F
.50911 .61149 m .52019 .60873 L .50711 .60154 L F
.61189 .51907 m .60772 .57167 L .62023 .55182 L .98 0 0 r
F
.61539 .4947 m .61189 .51907 L .62023 .55182 L .966 0 0 r
F
.47814 .44703 m .51642 .44478 L .51895 .43287 L .278 0 0 r
F
.47814 .44703 m .46799 .46148 L .51642 .44478 L F
.44046 .51451 m .46712 .50732 L .46414 .48224 L .123 0 0 r
F
.44046 .51451 m .44439 .5378 L .46712 .50732 L F
.57234 .60474 m .55377 .60514 L .53795 .61009 L .46 0 0 r
F
.58757 .58684 m .55377 .60514 L .57234 .60474 L .734 0 0 r
F
.60772 .57167 m .58757 .58684 L .57234 .60474 L .692 0 0 r
F
.57151 .44942 m .61539 .4947 L .61067 .47336 L .896 0 0 r
F
.56531 .43681 m .57151 .44942 L .61067 .47336 L .766 0 0 r
F
.51895 .43287 m .57151 .44942 L .56531 .43681 L .622 0 0 r
F
.48434 .59795 m .50371 .59119 L .47761 .57826 L .363 0 0 r
F
.48434 .59795 m .50711 .60154 L .50371 .59119 L F
.6004 .54401 m .58757 .58684 L .60772 .57167 L .909 0 0 r
F
.61189 .51907 m .6004 .54401 L .60772 .57167 L .98 0 0 r
F
.44439 .5378 m .47675 .53411 L .46712 .50732 L .301 0 0 r
F
.44439 .5378 m .45716 .55981 L .47675 .53411 L F
.51895 .43287 m .51642 .44478 L .57151 .44942 L .622 0 0 r
F
.54554 .57788 m .53795 .61009 L .55377 .60514 L .636 0 0 r
F
.54554 .57788 m .52019 .60873 L .53795 .61009 L F
.54554 .57788 m .50711 .60154 L .52019 .60873 L F
.46799 .46148 m .51547 .46473 L .51642 .44478 L .454 0 0 r
F
.46799 .46148 m .46414 .48224 L .51547 .46473 L F
.57392 .4696 m .61189 .51907 L .61539 .4947 L .9 0 0 r
F
.57151 .44942 m .57392 .4696 L .61539 .4947 L .896 0 0 r
F
.54554 .57788 m .55377 .60514 L .56171 .59569 L .636 0 0 r
F
.58757 .58684 m .56171 .59569 L .55377 .60514 L .734 0 0 r
F
.58201 .56688 m .56171 .59569 L .58757 .58684 L .814 0 0 r
F
.6004 .54401 m .58201 .56688 L .58757 .58684 L .909 0 0 r
F
.45716 .55981 m .49207 .55978 L .47675 .53411 L .421 0 0 r
F
.45716 .55981 m .47761 .57826 L .49207 .55978 L F
.54554 .57788 m .50371 .59119 L .50711 .60154 L .636 0 0 r
F
.51642 .44478 m .57392 .4696 L .57151 .44942 L .707 0 0 r
F
.54554 .57788 m .56171 .59569 L .55863 .58526 L .636 0 0 r
F
.58201 .56688 m .55863 .58526 L .56171 .59569 L .814 0 0 r
F
.47761 .57826 m .51143 .58158 L .49207 .55978 L .515 0 0 r
F
.47761 .57826 m .50371 .59119 L .51143 .58158 L F
.57217 .49539 m .6004 .54401 L .61189 .51907 L .874 0 0 r
F
.57392 .4696 m .57217 .49539 L .61189 .51907 L .9 0 0 r
F
.46414 .48224 m .51626 .49079 L .51547 .46473 L .532 0 0 r
F
.46414 .48224 m .46712 .50732 L .51626 .49079 L F
.51642 .44478 m .51547 .46473 L .57392 .4696 L .707 0 0 r
F
.54554 .57788 m .51143 .58158 L .50371 .59119 L .636 0 0 r
F
.56639 .52409 m .58201 .56688 L .6004 .54401 L .836 0 0 r
F
.57217 .49539 m .56639 .52409 L .6004 .54401 L .874 0 0 r
F
.55718 .55262 m .55863 .58526 L .58201 .56688 L .782 0 0 r
F
.55718 .55262 m .54554 .57788 L .55863 .58526 L F
.56639 .52409 m .55718 .55262 L .58201 .56688 L .836 0 0 r
F
.46712 .50732 m .51872 .52024 L .51626 .49079 L .576 0 0 r
F
.46712 .50732 m .47675 .53411 L .51872 .52024 L F
.51547 .46473 m .57217 .49539 L .57392 .4696 L .731 0 0 r
F
.54554 .57788 m .52745 .57646 L .51143 .58158 L .636 0 0 r
F
.49207 .55978 m .51143 .58158 L .52745 .57646 L .627 0 0 r
F
.52259 .54987 m .54554 .57788 L .55718 .55262 L .714 0 0 r
F
.52259 .54987 m .52745 .57646 L .54554 .57788 L F
.51547 .46473 m .51626 .49079 L .57217 .49539 L .731 0 0 r
F
.47675 .53411 m .52259 .54987 L .51872 .52024 L .606 0 0 r
F
.47675 .53411 m .49207 .55978 L .52259 .54987 L F
.49207 .55978 m .52745 .57646 L .52259 .54987 L .627 0 0 r
F
.51626 .49079 m .56639 .52409 L .57217 .49539 L .736 0 0 r
F
.51872 .52024 m .55718 .55262 L .56639 .52409 L .73 0 0 r
F
.51872 .52024 m .52259 .54987 L .55718 .55262 L F
.51626 .49079 m .51872 .52024 L .56639 .52409 L .736 0 0 r
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[27]:=",
  ImageSize->{237.125, 251.688},
  ImageMargins->{{27, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003]0000na000`40O003h00OkGoo003]Ool00>eo
o`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eo
o`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eo
o`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eo
o`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eo
o`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eo
o`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo002`Ool00bP0C01<0004C003500cOol0
0:eoo`@X00U<009D035oo`00ZWoo1BP00T001UP014`00U@0<7oo002XOol4:005@00:F002L002E00^
Ool00:Qoo`03:010040000I000]H009`009D02eoo`00Ygoo2D0000=805`0G0001E`015P01700;Goo
002VOol00`00@0100004@004B00;G005L00/Ool00:Eoo`0300040400009000M800]L00I`02]oo`00
Y7oo00<000@0@0002TP02e`01W00:goo002TOol2100;B00;G007L00ZOol00:=oo`03000400@000Y8
0003C01L05`000UL00M`02Yoo`00Xgoo0P@00R@01TP014`02e`00V`01W00:Goo002ROol210039004
B006C00;G003K005L00YOol00:9oo`03100T02@0008T0003B01<04`000Q<00YL00E/00=`02Uoo`00
XWoo00<402@090000R@02d`02U`01V`00W00:Goo002QOol00`@0900T000390000c@0C01<0008C009
G008K0000g@0Oomoo`0WOol00:5oo`DT008d00U<0003D01L05`000ML00Q/0003M01oogoo02Moo`00
XGoo12@00c@01T`015002E`00VP01V`000=d07ooOol09goo002QOol00`00900T0005=002C007D009
G003J004K0000g`0M01oo`0XOol00:9oo`03900d03@000@d00U@00QL00IX009/009l02Uoo`00XWoo
1c@000=00500D0001U0025`01fP000=/07`0O000:Goo002ROol00`00=00d0003=003@007D008G007
J003O00YOol00:9oo`8000<d00A000M@00MH009P00IX00=l02Uoo`00XWoo0`0000<d0400@0001400
1U001eP016000fP000A`07`0O01l02Uoo`00XWoo0`0000<T0400@000140000=80500D00015001EP0
1V0000AX0700L01`009l02Uoo`00Xgoo0P000R@01D000TP01E001EP01F0000=T0700L0000W0000=l
07ooOol0:7oo002SOol200039003@004B004D005F004H002I004L0000g`0Oomoo`0XOol00:Aoo`80
00<T0003@01804P000A8009@00ID00=P00=T00=`0003F01oogoo02Uoo`00YGoo00H002@0900T03`0
0005B009E0000f00I01T0002I002L0000eP0Oomoo`0ZOol00:Ioo`<T0003?0000000008l0003B01D
05@000QD00ET0003L01H07oo02aoo`00Z7oo00<T000000000c`02e@00f@00V0000=H07ooOol0;7oo
002YOol20004?00:E005H00_Ool007Yoo`03000T02@000<T02Qoo`@0008`0003?01D05@000QD00AP
031oo`00Mgoo00<0020080001d`012@08Woo0`000Woo00<00300<0000S001E@01D@000=P07ooOol0
;goo001eOol5800;C002H00POol20005Ool6<006A00cOol0079oo`LP00e<009P01ioo`<000Yoo`8`
009403Ioo`00L7oo220000<h05P0F0001UP01D`016006goo0`00AGoo001`Ool58004>00=F002L004
H00IOol20016Ool006moo`<P00Lh00eH00A`00=P01Moo`<004Ioo`00Kgoo2SP03UP017000V005goo
0P00Agoo001^Ool;>00>F006L0000f00Oomoo`0COol30017Ool006eoo`03000h03P000Ph0003A01L
05`000IL00IH00Q`01=oo`<004Qoo`00KGoo00<003P0>0001CP014@03U`02G004Woo0P00BGoo001/
Ool00`00>00h0003>007A00>G009L00AOol30019Ool006]oo`80008h00Y400iL00U`011oo`<004Yo
o`00Jgoo0P0034@03U`02W003goo0P00Bgoo001ZOol3000<A00>G00:L00>Ool3001;Ool006Uoo`<0
0003301404@000U40003B01L05`000aL00Y`00ioo`8004aoo`00JGoo0P000``01d@014P03U`00V`0
270000=H02`0Ool02Woo0`00C7oo001YOol00`00300<00023004A007B00>G004K006L0000eP0D>1@
h005;004Ool3001=Ool006Qoo`8000@<0003A01804P000U800eL00I/00A`0003N01@h53P00E@h09U
8004Ool00000001>Ool006Qoo`03000<00`000<<00a800aL00Q/009`009h00Q@h09U808004moo`00
J7oo1P`000<T04P0B0002DP035`02V`00WP00eVP1E3P16DPCgoo001XOol53002900;B00<G00:K002
N0000eP0FJ1IX005FJ02LR03IB1>Ool006Qoo`@<00<T00U8009<00]L00]/00=h00MIX0Ab809U84eo
o`00J7oo0``01B@01DP01D`02e`00VP026`00W`00WP01eVP1G8P0VDPC7oo001XOol230069002B008
C00;G004J006K002O002N008FJ06LR000fDPOomoo`19Ool006Qoo`03300T02@000DT00]<00UL00MX
00=/00=l009h00QIX0Qb84Yoo`00J7oo22@000<d04`0C00024`02E`02FP000A/07`0O01l009h00IN
009IX0Ub84Uoo`00JGoo1R@00c@02D`02E`02FP01G`02Eh00W:01g8PBGoo001YOol00`00900T0002
9004=009C008G00:J005O009GP04LX05LR19Ool006Yoo`<T00Hd00I<009@00QH009T00MX009d00Al
00UN00EbP0Ab8003001oogoo04Ioo`00JWoo00<002@0=0001c@00T`01E0025P00f@01FP00g@017`0
2Eh01g:00g8PB7oo001ZOol00`0010040007=007D007F006I003J003M003O00:GP09LX000g8POomo
o`16Ool006]oo`03000400@000Dd009000M@00IH00MT0003J01d07@000=d0003O01N@5i000=N@0IN
00YbP4Qoo`00Jgoo00@000@0100400<d00A000I@00EH00MT0003J01d07@000Ad0003O01N@5i000UN
@09^`0QbP4Qoo`00K7oo00D000@0100403@000I000E@00EH00IT009X00Ed0003F01N@5i000YN@0=^
`0MbP003001oogoo04Eoo`00KGoo0`@00R`01T002U000f@01FP00W@00eP035i01Fk01G:000=k87oo
Ool0AGoo001^Ool31003;004@00;D0000f@0J01X0004J00017@0F01H05P035i01fk017:000=k87oo
Ool0AGoo001`Ool00`@0;00/0003;0000d00D01@000:D006J0001E`0F01H05P0000035i02Fk000=b
P7/PNb00Agoo001aOol5;00>D002J004G002F002CL0<GT0:K/02Nb17Ool0055oo`03000h03P000Dh
0003?01oogoo01Ioo`D/00e@00EL009H009=`003CR1NH5iP00ENH0AN@0]^`0=k84Ioo`00CWoo00<0
0300<0001U@00cP00S`067oo0QP000</0500D0002e0015`000=H04g0CR000dhP2eiP0V[P2Fk00g/P
AWoo001;Ool6<009E002J002?00HOol3600:D005G006CR0;GV04J^06K/02Oh02Nb16Ool004Uoo`L`
00]D00AX01Uoo`8H00M@00@h00U>80]NH0IZh0A^`09oP09k84Ioo`00BGoo1C000T002eP00V`016P0
6Woo0Re00aP00SP000<]@4hPCR002ThP2EiP26[P0fk00Wn00W/PAWoo0018Ool00c00@0100005@00;
F003K003J00IOol20007;D000cWPCR1>8009CR09GV0:J^04Oh17Ool004Moo`U000]H00E/009X01Eo
o`D000H]@0<ih0Y>80UNH0YZh0AoP4Moo`00Agoo2D002eP01f`047oo2@0000=oo`00;D000be013WP
2ThP25iP2f[P17n0Agoo0016Ool00`00@0100005@002B00;G008K00<Ool90004Ool01000;D0]@2e0
1SWP1dhP0U9P25ZP0V;P26[P00=cP7n0Oh000Wn0Agoo0015Ool00`00@0100003@005B00;G008K009
Ool70009Ool200000be0>N0ih006>N02CR06DV08FZ03H^06J^03Lh02Oh18Ool004Eoo`0300100400
00Q800]L00Q/0003L01oogoo00=oo`L000eoo`03000=H0eP00Lih003AT1BH59P00EBH0MJX0IRh0=Z
h0AcP003Oh1oogoo04Moo`00A7oo0P002TP02e`026`000=`07ooOol01`0047oo0P000PeP1CWP0dI0
1e9P1UZP1f;P00=Zh7>0Lh000g>000=oP7ooOol0Agoo0013Ool3000:B00:G007K009000COol20003
3F03>N05AT06DV05FZ07H^000fMPLh1cP003Lh000e?0Oomoo`18Ool004=oo`800003401804P000I8
009<00YL00E/0003001/000000D001Moo`03000=H0eP008=H003>N16@4I000E6@0EBH0EJX0IRh09W
H0AcP09C`4Yoo`00@goo00<0010040001DP01D`02U`00VP01F`00P0000=l0700Ool06Goo00@000eP
3F0=H08b@0M6@09BH0QC00=Rh0EWH09cP09C`4]oo`00@Woo00@00100400@009800Q<00YL00AX00E/
0003O01`07oo01Yoo`@=H0@b@0A6@0]C0003H^1WH6MP00AWH003Lh1C`5?004aoo`00@Woo11002T`0
2U`01VP00V`00g`000=`07ooOol06Woo0PeP1S9000=6@5<0D`002U<01VMP00=O`000Dl00CGoo0012
Ool440000bP0C01<0007C009G009J003O0000g00Oomoo`0LOol6<T0>D`03If02Gl02001>Ool004=o
o`8@008X00U<00UL00UX00Al01moo`Db@0iC0005If1O`5o0Gl1C`002001>Ool004=oo`04400X02P0
:009C009G002I007J00017P0O01l07`08Goo0QiP00<b@5<0D`0035<00eo00Woo0`00CGoo0013Ool0
0a00:00X0002:008C009G004I004J003N002O00SOol37V0;D`000eo0=f1oo`04Ool3001<Ool004=o
o`DX00U<00ML00IT00=X00=h009l02Eoo`<NH0IC008gH0Uoo`<004]oo`00A7oo12P000<h04`0C000
1T`01e`026@000=X07P0N0000WP0:goo0aK000<gH7ooOol02Woo0P00Bgoo0014Ool3:003>007C007
G008I005N00kOol3001:Ool004Aoo`03000X03P000<h00I<0003D01H05P0009H009L00QT009`00Ah
03aoo`<004Uoo`00AGoo00<003P0>0000cP00T`015001UP00V001F@00g000gP0?Woo0`00B7oo0015
Ool20004>0000d@0D01@0004D005F005H0000f@0L01`0003L0000gP0Oomoo`0nOol30017Ool004Eo
o`<000<h009400E@00AH00EP0003I01`070000A`049oo`8004Moo`00AWoo0`0000<h04@0A0000T@0
150015P016000f@0170000=L07ooOol0@7oo0`00AWoo0017Ool20002;004A009D0000f00I01T0002
I003L0000e`0Oomoo`12Ool30015Ool004Uoo`04000/02`0;002A009D006I0000g00G01oo`15Ool3
0014Ool004Yoo`@/0003A01@050000Q@00=T009P0003G01oogoo04Ioo`8004Aoo`00C7oo00<@02`0
D0002U001600BWoo0`00@goo001>Ool24008D004H01<Ool30012Ool004moo`8@00E@00<h051oo`<0
045oo`00ZWoo0P00@Goo002ZOol30010Ool00:]oo`<003moo`00[7oo0`00?Woo002]Ool3000:Ool0
0a`0?00l0007?00YOol00:ioo`<000Ioo`<L0003>01D05@000AD00@l0003<01oogoo02Eoo`00[goo
0`000goo0Q`013P02U@00V@000<`07ooOol08goo002`Ool300000goo>00h0005>00;E003I00TOol0
0;5oo`8000Ph00aD00AT029oo`00/Goo0P001SP00T@035P00W000V@08Woo002`Ool20002>007A00<
F004L0000f@0Oomoo`0OOol00:moo`8000]400aH00A`0003I01oogoo01ioo`00[Woo0`002d@035P0
1W007goo002^Ool200000a@0A0140007A002B007G005F006L00OOol00:eoo`80008D00E400I800aL
00I`01moo`00[Goo00@001@0500D009400U800aL00M`01ioo`00[Goo11@02dP035`01g007Woo002/
Ool450000b@0B0180009B00<G007L00NOol00:aoo`<D008T00]800aL00M`01ioo`00[7oo0Q@012@0
24P00T`035`01g007Woo002[Ool250059005B005C00<G002K005L00NOol00:]oo`03500T02@000@T
009800Q<00aL00A/00A`01eoo`00Zgoo1R@000<`04`0C0002D`02U`01V`00g007Goo002[Ool59003
<00:C00:G008K0000g00Oomoo`0KOol00:aoo`<T00@`00Y<00YL00Q/0003L01oogoo01]oo`00[7oo
0R@01C002T`02E`02F`000=`07ooOol06goo002/Ool00b@0<00`0005<009C009G002J006K002O00M
Ool00:aoo`P`00U<00UL00EX00=/009l01eoo`00[7oo00<00300<00013000S`02D`025`01fP000=/
07`0O0007Goo002]Ool00`00<00`0002<003?009C007G008J003O00MOol00:eoo`04000`0300<005
?008C007G008J003O00MOol00:eoo`800003<00l03`000@l00I<009@00MH009T00EX0003M01l07`0
01ioo`00[Goo0P0000<<03`0?0001C`00T`01E001eP00f@00fP00W@000=l07ooOol07Goo002^Ool0
0`00300<0005?002A006D006F005I0001FP0M01d07@0O0007goo002_Ool00`00300<0003?004A005
D005F005I0000fP0M01d0002M00POol00;1oo`<<0003?01404@000A400A@00EH00=T00AX009d025o
o`00/Woo00@<02`0;00/00E400U@0003I01X06P000=X0003M01oogoo021oo`00/goo00<<02`0;000
0b`000=40500D00025001FP097oo002dOol5;00<D0000fP0D01@000UOol00;Ioo`8<0003;01@0500
00a@02Ioo`00^Goo0``02E00:7oo002nOol01000D01@01P0:goo003]Ool00>eoo`00kGoo003]Ool0
0>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool0
0>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool00>eoo`00kGoo003]Ool0
0>eoo`00kGoo003]Ool00>eoo`00kGoo0000\
\>"],
  ImageRangeCache->{{{0, 236.125}, {250.688, 0}} -> {0.0403593, -0.000101771, \
0.00369235, 0.00369235}},
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[40]=",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}]
}, Closed]],

Cell[TextData[{
  "The details of implementation of the ",
  StyleBox["MoDLToGraphics3D",
    FontFamily->"Courier"],
  " function, which performs the actual transformation from SymbolicXML to a \
3D graphic, are provided below. "
}], "Text",
  CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Implementation Details", "Subsubsection",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[TextData[{
  "Notice that the original MoDL file contains a head and a body. In the \
head, a number of definitions are made, which are used throughout the body. \
We have extracted these definitions into the variable ",
  StyleBox["defs",
    FontFamily->"Courier"],
  ". We then map the function ",
  StyleBox["ProcessDefinition",
    FontFamily->"Courier"],
  " across the list of definitions. The function ",
  StyleBox["ProcessDefinition",
    FontFamily->"Courier"],
  " constructs a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression out of a definition and stores it in the variable ",
  StyleBox["moldef",
    FontFamily->"Courier"],
  ", which is dynamically scoped inside of ",
  StyleBox["MoDLToGraphics3D",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[TextData[{
  "A ",
  StyleBox["DEFINE", "MR"],
  " element in the head typically defines either an atom or a molecule. \
First, consider an atom definition."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[
      Cases[methane, \[IndentingNewLine]XMLElement["\<DEFINE\>", _, \
{XMLElement["\<atom\>", __]}], \[IndentingNewLine]Infinity]]\)], "Input",
  CellLabel->"In[41]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(XMLElement[
      "DEFINE", {"name" \[Rule] "C"}, {XMLElement[
          "atom", {"radius" \[Rule] "0.3", 
            "color" \[Rule] "1 1 0"}, {}]}]\)], "Output",
  CellLabel->"Out[41]=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}]
}, Closed]],

Cell[TextData[{
  "The ",
  StyleBox["DEFINE", "MR"],
  " element essentially associates a unique key (in this case C) to an atom \
element. The atom element specifies its color and radius. We will turn this \
into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression of the form ",
  StyleBox["Atom[radius, color]",
    FontFamily->"Courier"],
  ". We will then store it in ",
  StyleBox["moldef[name]",
    FontFamily->"Courier"],
  ", where ",
  StyleBox["name",
    FontFamily->"Courier"],
  " is the key specified in the name attribute of the ",
  StyleBox["DEFINE", "MR"],
  " element."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(\(ProcessDefinition[
          XMLElement["\<DEFINE\>", {"\<name\>" \[Rule] 
                name_String}, \[IndentingNewLine]{XMLElement["\<atom\>", \
{a__}, {}]}]] := \[IndentingNewLine]\((moldef[name] = 
            Atom[GetRad[a], GetColor[a]])\);\)\)], "Input",
  CellLabel->"In[42]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[TextData[{
  "In this case, ",
  StyleBox["a",
    FontFamily->"Courier"],
  " is the entire sequence of attributes of the atom element. ",
  StyleBox["GetRad",
    FontFamily->"Courier"],
  " and ",
  StyleBox["GetColor",
    FontFamily->"Courier"],
  " are functions we will define later which extract the radius and color \
from this sequence. For now, assume that ",
  StyleBox["GetRad",
    FontFamily->"Courier"],
  " returns a number and that ",
  StyleBox["GetColor",
    FontFamily->"Courier"],
  " returns an ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  " expression. We now need to process definitions of molecule elements. Like \
the atom definitions, molecules are given a unique key in the name attribute \
of the ",
  StyleBox["DEFINE", "MR"],
  " element. The molecule element then contains atom elements and bond \
elements.  "
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[
      Cases[methane, \[IndentingNewLine]XMLElement["\<DEFINE\>", _, \
{XMLElement["\<molecule\>", __]}], \[IndentingNewLine]Infinity]]\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(XMLElement[
      "DEFINE", {"name" \[Rule] "CH4"}, {XMLElement[
          "molecule", {}, {XMLElement[
              "atom", {"type" \[Rule] "C", "id" \[Rule] "c1", 
                "position" \[Rule] "0 0 0.4"}, {}], 
            XMLElement[
              "atom", {"type" \[Rule] "H", "id" \[Rule] "h1", 
                "position" \[Rule] "0.5 0.1 -0.4"}, {}], 
            XMLElement[
              "atom", {"type" \[Rule] "H", "id" \[Rule] "h2", 
                "position" \[Rule] "-1 0.1 0.3"}, {}], 
            XMLElement[
              "atom", {"type" \[Rule] "H", "id" \[Rule] "h3", 
                "position" \[Rule] "0.3 0.7 1"}, {}], 
            XMLElement[
              "atom", {"type" \[Rule] "H", "id" \[Rule] "h4", 
                "position" \[Rule] "0.2 -0.9 0.8"}, {}], 
            XMLElement[
              "bond", {"atom1" \[Rule] "c1", "atom2" \[Rule] "h1"}, {}], 
            XMLElement[
              "bond", {"atom1" \[Rule] "c1", "atom2" \[Rule] "h2"}, {}], 
            XMLElement[
              "bond", {"atom1" \[Rule] "c1", "atom2" \[Rule] "h3"}, {}], 
            XMLElement[
              "bond", {"atom1" \[Rule] "c1", 
                "atom2" \[Rule] "h4"}, {}]}]}]\)], "Output",
  CellLabel->"Out[43]=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}]
}, Closed]],

Cell[TextData[{
  "The atom elements contain three attributes: ",
  StyleBox["type",
    FontFamily->"Courier"],
  ", ",
  StyleBox["id",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["position",
    FontFamily->"Courier"],
  ". The ",
  StyleBox["type",
    FontFamily->"Courier"],
  " attribute references the key from previous atom definitions. The ",
  StyleBox["id",
    FontFamily->"Courier"],
  " attribute is a unique key for this instance of the type of atom defined. \
In other words, what was defined previously in the atom definitions were \
types of atoms, like carbon or hydrogen. The atom elements inside a molecule \
element represent a distinct atom of some previously defined type."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[TextData[{
  "The ",
  StyleBox["molecule", "MR"],
  " element also contains ",
  StyleBox["bond", "MR"],
  " elements. These have two attributes: ",
  StyleBox["atom1",
    FontFamily->"Courier"],
  " and ",
  StyleBox["atom2.",
    FontFamily->"Courier"],
  " These reference the ",
  StyleBox["id",
    FontFamily->"Courier"],
  " of the ",
  StyleBox["atom", "MR"],
  " elements in that molecule expression."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[TextData[{
  "When we call ",
  StyleBox["ProcessDefinition",
    FontFamily->"Courier"],
  " on a molecule definition, we will want to store a list of the atoms and \
bonds in ",
  StyleBox["moldef",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(\(ProcessDefinition[
          XMLElement["\<DEFINE\>", {"\<name\>" \[Rule] 
                name_String}, \[IndentingNewLine]{XMLElement["\<molecule\>", \
{}, subdef_]}]] := \[IndentingNewLine]\((moldef[name] = 
            ProcessSubdef /@ subdef)\);\)\)], "Input",
  CellLabel->"In[44]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(\(ProcessSubdef[\[IndentingNewLine]XMLElement["\<atom\>", {"\<type\>" \
\[Rule] t_, "\<id\>" \[Rule] id_, 
              pos___}, {}]] := \[IndentingNewLine]\((moldef[id] = 
            Append[moldef[t], GetPos[pos]])\);\)\)], "Input",
  CellLabel->"In[45]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(\(ProcessSubdef[\[IndentingNewLine]XMLElement["\<bond\>", {"\<atom1\>" \
\[Rule] a1_, "\<atom2\>" \[Rule] 
                a2_}, {}]] := \[IndentingNewLine]Bond[\(moldef[
              a1]\)[\([3]\)], \(moldef[a2]\)[\([3]\)]];\)\)], "Input",
  CellLabel->"In[46]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[TextData[{
  "In the definition of ",
  StyleBox["ProcessDefinition",
    FontFamily->"Courier"],
  ", ",
  StyleBox["subdef",
    FontFamily->"Courier"],
  " is the list of atoms and bonds. We map ",
  StyleBox["ProcessSubdef",
    FontFamily->"Courier"],
  " onto this list. That is, what we assign to ",
  StyleBox["moldef[name]",
    FontFamily->"Courier"],
  " is a list of the result of ",
  StyleBox["ProcessSubdef",
    FontFamily->"Courier"],
  " on each ",
  StyleBox["atom", "MR"],
  " and ",
  StyleBox["bond", "MR"],
  " element in the molecule. When ",
  StyleBox["ProcessSubdef",
    FontFamily->"Courier"],
  " is called on an atom, it extracts that atom's type from ",
  StyleBox["moldef",
    FontFamily->"Courier"],
  ", appends the position to that expression, and stores the results under ",
  StyleBox["moldef[id]",
    FontFamily->"Courier"],
  ". When ",
  StyleBox["ProcessSubdef",
    FontFamily->"Courier"],
  " is called on a bond, it simply returns a ",
  StyleBox["Bond",
    FontFamily->"Courier"],
  " expression containing the positions of the two atoms it references."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[TextData[{
  "We need an auxiliary function before we define ",
  StyleBox["GetRad",
    FontFamily->"Courier"],
  ", ",
  StyleBox["GetColor",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["GetPos",
    FontFamily->"Courier"],
  ". Since positions are written as space-separated lists of numbers in MoDL, \
we first write a function which turns this string into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " list."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(\(MolStringListToList[
          molpos_String] := \[IndentingNewLine]Module[{stream = 
              StringToStream[molpos], thelist}, \[IndentingNewLine]thelist = 
            Read[stream, {Number, Number, Number}]; \[IndentingNewLine]Close[
            stream]; \[IndentingNewLine]thelist];\)\)], "Input",
  CellLabel->"In[47]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[TextData[{
  "The functions ",
  StyleBox["GetPos",
    FontFamily->"Courier"],
  ", ",
  StyleBox["GetRad",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["GetColor",
    FontFamily->"Courier"],
  " should take in a sequence of attributes of any length and create a list \
from the position attribute. In SymbolicXML, attributes are stored as ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " rules. Both ",
  StyleBox["GetPos",
    FontFamily->"Courier"],
  " and ",
  StyleBox["GetColor",
    FontFamily->"Courier"],
  " will need to use ",
  StyleBox["MolStringListToList",
    FontFamily->"Courier"],
  ".",
  " ",
  StyleBox["GetRad",
    FontFamily->"Courier"],
  " needs only to convert a string to a number."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(\(GetPos[___, "\<position\>" \[Rule] p_, ___] := 
        MolStringListToList[p];\)\)], "Input",
  CellLabel->"In[48]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(\(GetRad[___, "\<radius\>" \[Rule] r_, ___] := 
        ToExpression[r];\)\)], "Input",
  CellLabel->"In[49]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(\(GetColor[___, "\<color\>" \[Rule] 
            c_, ___] := \[IndentingNewLine]RGBColor @@ 
          MolStringListToList[c];\)\)], "Input",
  CellLabel->"In[50]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(\(GetColor[___] := GrayLevel[1];\)\)], "Input",
  CellLabel->"In[51]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[TextData[{
  "Here is the definition of ",
  StyleBox["MoDLToGraphics3D",
    FontFamily->"Courier"],
  " again for reference."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(MoDLToGraphics3D[
        modl_] := \[IndentingNewLine]Block[{\[IndentingNewLine]defs = 
            Cases[modl, XMLElement["\<DEFINE\>", ___], 
              Infinity], \[IndentingNewLine]body = 
            First[Cases[modl, XMLElement["\<body\>", ___], 
                Infinity]], \[IndentingNewLine]moldef, themols, 
          theatoms}, \[IndentingNewLine]ProcessDefinition /@ 
          defs; \[IndentingNewLine]themols = \[IndentingNewLine]Flatten@
            Cases[body, \[IndentingNewLine]XMLElement["\<molecule\>", {___, "\
\<type\>" \[Rule] t_, ___}, __] \[RuleDelayed] 
                moldef[t], \[IndentingNewLine]Infinity]; \
\[IndentingNewLine]theatoms = 
          Cases[body, \[IndentingNewLine]XMLElement["\<atom\>", {___, "\<type\
\>" \[Rule] t_, ___, "\<position\>" \[Rule] 
                    p_, ___}, \[IndentingNewLine]__] \[RuleDelayed] 
              Append[moldef[t], MolStringListToList[p]], 
            Infinity]; \[IndentingNewLine]Graphics3D[
          MolToGraphics /@ Join[themols, theatoms], 
          Boxed \[Rule] False]\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[52]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[TextData[{
  StyleBox["Block",
    FontFamily->"Courier"],
  " scopes the variables ",
  StyleBox["defs",
    FontFamily->"Courier"],
  ", ",
  StyleBox["body",
    FontFamily->"Courier"],
  ", ",
  StyleBox["moldef",
    FontFamily->"Courier"],
  ", ",
  StyleBox["themols",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["theatoms",
    FontFamily->"Courier"],
  ". We already discussed ",
  StyleBox["moldef",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["defs",
    FontFamily->"Courier"],
  " simply contains a list of the ",
  StyleBox["DEFINE", "MR"],
  " elements. The function ",
  StyleBox["body",
    FontFamily->"Courier"],
  " just contains the body element of the SymbolicXML expression. That leaves \
",
  StyleBox["themols",
    FontFamily->"Courier"],
  " and ",
  StyleBox["theatoms",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[TextData[{
  "After ",
  StyleBox["ProcessDefinition",
    FontFamily->"Courier"],
  " is mapped to ",
  StyleBox["defs",
    FontFamily->"Courier"],
  ", ",
  StyleBox["themols",
    FontFamily->"Courier"],
  " is defined. Molecules in the body have a ",
  StyleBox["type",
    FontFamily->"Courier"],
  " attribute, which references the key of the molecule type defined in the \
head. The ",
  StyleBox["Cases",
    FontFamily->"Courier"],
  " statement then matches the molecules in the body and returns that \
molecule's type definition in ",
  StyleBox["moldef",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(\(body = 
        First[Cases[methane, XMLElement["\<body\>", __], 
            Infinity]];\)\)], "Input",
  CellLabel->"In[53]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Flatten@
      Cases[body, \[IndentingNewLine]XMLElement["\<molecule\>", {___, "\<type\
\>" \[Rule] t_, ___}, _] \[RuleDelayed] 
          moldef[t], \[IndentingNewLine]Infinity]\)], "Input",
  CellLabel->"In[54]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \({Atom[0.3`, RGBColor[1, 1, 0], {0, 0, 0.4`}], 
      Atom[0.25`, RGBColor[1, 0, 0], {0.5`, 0.1`, \(-0.4`\)}], 
      Atom[0.25`, RGBColor[1, 0, 0], {\(-1\), 0.1`, 0.3`}], 
      Atom[0.25`, RGBColor[1, 0, 0], {0.3`, 0.7`, 1}], 
      Atom[0.25`, RGBColor[1, 0, 0], {0.2`, \(-0.9`\), 0.8`}], 
      Bond[{0, 0, 0.4`}, {0.5`, 0.1`, \(-0.4`\)}], 
      Bond[{0, 0, 0.4`}, {\(-1\), 0.1`, 0.3`}], 
      Bond[{0, 0, 0.4`}, {0.3`, 0.7`, 1}], 
      Bond[{0, 0, 0.4`}, {0.2`, \(-0.9`\), 0.8`}]}\)], "Output",
  CellLabel->"Out[54]=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}]
}, Closed]],

Cell[TextData[{
  "In our example, we only have one molecule in the body. If more molecules \
existed, the lists of ",
  StyleBox["Atom",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Bond",
    FontFamily->"Courier"],
  " expressions would be merged together by ",
  StyleBox["Flatten",
    FontFamily->"Courier"],
  ". As we will see, the ",
  StyleBox["Graphics3D",
    FontFamily->"Courier"],
  " expression is simply made by drawing each ",
  StyleBox["Atom",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Bond",
    FontFamily->"Courier"],
  ". Also, the body may contain other atoms as well. The definition of ",
  StyleBox["theatoms",
    FontFamily->"Courier"],
  " simply matches these elements, reads their type from ",
  StyleBox["moldef",
    FontFamily->"Courier"],
  ", and appends their positions. Thus, ",
  StyleBox["theatoms",
    FontFamily->"Courier"],
  " would contain a list of more atoms to be drawn."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[TextData[{
  "The last line of ",
  StyleBox["MoDLToGraphics3D",
    FontFamily->"Courier"],
  " joins the ",
  StyleBox["Atom",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Bond",
    FontFamily->"Courier"],
  " expressions in ",
  StyleBox["themols",
    FontFamily->"Courier"],
  " with the ",
  StyleBox["Atom",
    FontFamily->"Courier"],
  " expressions in ",
  StyleBox["theatoms",
    FontFamily->"Courier"],
  ". It then maps ",
  StyleBox["MolToGraphics",
    FontFamily->"Courier"],
  " onto this list. ",
  StyleBox["MolToGraphics",
    FontFamily->"Courier"],
  " is simply a function that returns a sphere for ",
  StyleBox["Atom",
    FontFamily->"Courier"],
  " expressions and a line for ",
  StyleBox["Bond",
    FontFamily->"Courier"],
  " expressions. Of course, we also need to define ",
  StyleBox["MolToGraphics",
    FontFamily->"Courier"],
  ". The definition is straightforward, provided you are familiar with ",
  StyleBox["Graphics`Shapes`",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Graphics",
    FontFamily->"Courier"],
  " expressions in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(\(MolToGraphics[Bond[pts__]] := {Thickness[0.01], 
          Line[{pts}]};\)\)], "Input",
  CellLabel->"In[55]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    \(\(MolToGraphics[
          Atom[r_, col_, pos_]] := \[IndentingNewLine]{SurfaceColor[col], 
          EdgeForm[], \[IndentingNewLine]TranslateShape[Sphere[r, 10, 10], 
            pos]};\)\)], "Input",
  CellLabel->"In[56]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell["\<\
The result is a 3D graphic of methane or any other molecule you \
have defined in MoDL.\
\>", "Text",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[MoDLToGraphics3D[methane]]\)], "Input",
  CellLabel->"In[57]:=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.06145 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0462967 1.14699 5.68122e-17 1.14699 [
[ 0 0 0 0 ]
[ 1 1.06145 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.06145 L
0 1.06145 L
closepath
clip
newpath
.37336 .66509 m .33207 .68456 L .33692 .6624 L .729 0 0 r
F
.37336 .66509 m .37499 .68768 L .33207 .68456 L F
.37022 .6428 m .37336 .66509 L .33692 .6624 L .725 0 0 r
F
.40468 .65531 m .37499 .68768 L .37336 .66509 L .607 0 0 r
F
.39296 .6356 m .37336 .66509 L .37022 .6428 L .629 0 0 r
F
.39296 .6356 m .40468 .65531 L .37336 .66509 L F
.37022 .6428 m .33692 .6624 L .34371 .64082 L .725 0 0 r
F
.36585 .62282 m .37022 .6428 L .34371 .64082 L .714 0 0 r
F
.37782 .61898 m .37022 .6428 L .36585 .62282 L .646 0 0 r
F
.37782 .61898 m .39296 .6356 L .37022 .6428 L F
.37499 .68768 m .32962 .70531 L .33207 .68456 L .727 0 0 r
F
.37499 .68768 m .37496 .70856 L .32962 .70531 L F
.41192 .67632 m .37496 .70856 L .37499 .68768 L .578 0 0 r
F
.40468 .65531 m .41192 .67632 L .37499 .68768 L .607 0 0 r
F
.33692 .6624 m .29858 .66801 L .30857 .64817 L .833 0 0 r
F
.33692 .6624 m .33207 .68456 L .29858 .66801 L F
.34371 .64082 m .33692 .6624 L .30857 .64817 L .806 0 0 r
F
.34371 .64082 m .30857 .64817 L .32319 .63036 L F
.35186 .62176 m .34371 .64082 L .32319 .63036 L .769 0 0 r
F
.36585 .62282 m .34371 .64082 L .35186 .62176 L .714 0 0 r
F
.33207 .68456 m .2942 .68804 L .29858 .66801 L .853 0 0 r
F
.33207 .68456 m .32962 .70531 L .2942 .68804 L F
.37999 .60361 m .36585 .62282 L .35186 .62176 L .66 0 0 r
F
.37999 .60361 m .37782 .61898 L .36585 .62282 L F
.40343 .6218 m .40468 .65531 L .39296 .6356 L .476 0 0 r
F
.38324 .61166 m .39296 .6356 L .37782 .61898 L .554 0 0 r
F
.38324 .61166 m .40343 .6218 L .39296 .6356 L F
.41928 .63648 m .41192 .67632 L .40468 .65531 L .376 0 0 r
F
.40343 .6218 m .41928 .63648 L .40468 .65531 L .476 0 0 r
F
.37496 .70856 m .32982 .72273 L .32962 .70531 L .717 0 0 r
F
.37496 .70856 m .37325 .72581 L .32982 .72273 L F
.41398 .69672 m .37325 .72581 L .37496 .70856 L .53 0 0 r
F
.41192 .67632 m .41398 .69672 L .37496 .70856 L .578 0 0 r
F
.37999 .60361 m .35186 .62176 L .34108 .61619 L .66 0 0 r
F
.35186 .62176 m .32319 .63036 L .34108 .61619 L .769 0 0 r
F
.37999 .60361 m .38324 .61166 L .37782 .61898 L .66 0 0 r
F
.32962 .70531 m .29592 .70638 L .2942 .68804 L .864 0 0 r
F
.32962 .70531 m .32982 .72273 L .29592 .70638 L F
.42926 .65436 m .41398 .69672 L .41192 .67632 L .229 0 0 r
F
.41928 .63648 m .42926 .65436 L .41192 .67632 L .376 0 0 r
F
.32319 .63036 m .29906 .62744 L .31645 .61521 L .878 0 0 r
F
.32319 .63036 m .30857 .64817 L .29906 .62744 L F
.34108 .61619 m .32319 .63036 L .31645 .61521 L .803 0 0 r
F
.37999 .60361 m .34108 .61619 L .33764 .60819 L .66 0 0 r
F
.34108 .61619 m .31645 .61521 L .33764 .60819 L .803 0 0 r
F
.30857 .64817 m .28718 .64379 L .29906 .62744 L .946 0 0 r
F
.30857 .64817 m .29858 .66801 L .28718 .64379 L F
.37999 .60361 m .40343 .6218 L .38324 .61166 L .42 0 0 r
F
.37325 .72581 m .33272 .73513 L .32982 .72273 L .682 0 0 r
F
.37325 .72581 m .36997 .73776 L .33272 .73513 L F
.41059 .71459 m .36997 .73776 L .37325 .72581 L .426 0 0 r
F
.41398 .69672 m .41059 .71459 L .37325 .72581 L .53 0 0 r
F
.43234 .67378 m .41059 .71459 L .41398 .69672 L 0 0 0 r
F
.42926 .65436 m .43234 .67378 L .41398 .69672 L .229 0 0 r
F
.29858 .66801 m .28207 .66274 L .28718 .64379 L .995 0 0 r
F
.29858 .66801 m .2942 .68804 L .28207 .66274 L F
.39738 .60649 m .41928 .63648 L .40343 .6218 L .108 0 0 r
F
.37999 .60361 m .39738 .60649 L .40343 .6218 L .42 0 0 r
F
.37999 .60361 m .33764 .60819 L .34292 .60078 L .66 0 0 r
F
.33764 .60819 m .3264 .60106 L .34292 .60078 L .766 0 0 r
F
.33764 .60819 m .31645 .61521 L .3264 .60106 L F
.32982 .72273 m .3037 .72124 L .29592 .70638 L .84 0 0 r
F
.32982 .72273 m .33272 .73513 L .3037 .72124 L F
.37999 .60361 m .355 .59684 L .36919 .59793 L .66 0 0 r
F
.37999 .60361 m .34292 .60078 L .355 .59684 L F
.36919 .59793 m .39738 .60649 L .37999 .60361 L .255 0 0 r
F
.4111 .61544 m .42926 .65436 L .41928 .63648 L 0 0 0 r
F
.39738 .60649 m .4111 .61544 L .41928 .63648 L .108 0 0 r
F
.31645 .61521 m .31266 .60795 L .3264 .60106 L .796 0 0 r
F
.31645 .61521 m .29906 .62744 L .31266 .60795 L F
.34292 .60078 m .34952 .5935 L .355 .59684 L .542 0 0 r
F
.34292 .60078 m .3264 .60106 L .34952 .5935 L F
.2942 .68804 m .28435 .68246 L .28207 .66274 L .954 0 0 r
F
.2942 .68804 m .29592 .70638 L .28435 .68246 L F
.41059 .71459 m .40197 .72821 L .36997 .73776 L .426 0 0 r
F
.42811 .6929 m .40197 .72821 L .41059 .71459 L 0 0 0 r
F
.43234 .67378 m .42811 .6929 L .41059 .71459 L F
.76272 .37327 m .72199 .39208 L .72617 .37003 L .73 0 0 r
F
.76272 .37327 m .76502 .39584 L .72199 .39208 L F
.76006 .3501 m .76272 .37327 L .72617 .37003 L .725 0 0 r
F
.79707 .3615 m .76502 .39584 L .76272 .37327 L .612 0 0 r
F
.785 .34146 m .76272 .37327 L .76006 .3501 L .634 0 0 r
F
.785 .34146 m .79707 .3615 L .76272 .37327 L F
.36919 .59793 m .37678 .59559 L .39738 .60649 L .255 0 0 r
F
.355 .59684 m .37678 .59559 L .36919 .59793 L .261 0 0 r
F
.355 .59684 m .34952 .5935 L .37678 .59559 L F
.36997 .73776 m .33808 .7412 L .33272 .73513 L .526 0 0 r
F
.36997 .73776 m .36541 .74312 L .33808 .7412 L F
.40197 .72821 m .36541 .74312 L .36997 .73776 L .12 0 0 r
F
.76006 .3501 m .72617 .37003 L .73348 .34772 L .725 0 0 r
F
.7573 .32843 m .76006 .3501 L .73348 .34772 L .714 0 0 r
F
.77044 .32382 m .76006 .3501 L .7573 .32843 L .652 0 0 r
F
.77044 .32382 m .785 .34146 L .76006 .3501 L F
.76502 .39584 m .72132 .41189 L .72199 .39208 L .729 0 0 r
F
.76502 .39584 m .76678 .41582 L .72132 .41189 L F
.80554 .38214 m .76678 .41582 L .76502 .39584 L .58 0 0 r
F
.79707 .3615 m .80554 .38214 L .76502 .39584 L .612 0 0 r
F
.72617 .37003 m .69189 .37211 L .7007 .35291 L .85 0 0 r
F
.72617 .37003 m .72199 .39208 L .69189 .37211 L F
.73348 .34772 m .72617 .37003 L .7007 .35291 L .813 0 0 r
F
.4111 .61544 m .41973 .62973 L .42926 .65436 L 0 0 0 r
F
.41973 .62973 m .43234 .67378 L .42926 .65436 L .895 0 0 r
F
.29906 .62744 m .30314 .62093 L .31266 .60795 L .6 0 0 r
F
.29906 .62744 m .28718 .64379 L .30314 .62093 L F
.73348 .34772 m .7007 .35291 L .71505 .33516 L .813 0 0 r
F
.74327 .32716 m .73348 .34772 L .71505 .33516 L .769 0 0 r
F
.7573 .32843 m .73348 .34772 L .74327 .32716 L .714 0 0 r
F
.37678 .59559 m .4111 .61544 L .39738 .60649 L .486 0 0 r
F
.33272 .73513 m .31689 .73108 L .3037 .72124 L .601 0 0 r
F
.33272 .73513 m .33808 .7412 L .31689 .73108 L F
.72199 .39208 m .6895 .391 L .69189 .37211 L .882 0 0 r
F
.72199 .39208 m .72132 .41189 L .6895 .391 L F
.29592 .70638 m .29391 .70098 L .28435 .68246 L 0 0 0 r
F
.29592 .70638 m .3037 .72124 L .29391 .70098 L F
.77633 .30537 m .7573 .32843 L .74327 .32716 L .671 0 0 r
F
.77633 .30537 m .77044 .32382 L .7573 .32843 L F
.79902 .32487 m .79707 .3615 L .785 .34146 L .521 0 0 r
F
.77773 .31503 m .785 .34146 L .77044 .32382 L .582 0 0 r
F
.77773 .31503 m .79902 .32487 L .785 .34146 L F
.3264 .60106 m .34471 .59748 L .34952 .5935 L 0 0 0 r
F
.3264 .60106 m .31266 .60795 L .34471 .59748 L F
.81657 .33882 m .80554 .38214 L .79707 .3615 L .446 0 0 r
F
.79902 .32487 m .81657 .33882 L .79707 .3615 L .521 0 0 r
F
.76678 .41582 m .72428 .42761 L .72132 .41189 L .714 0 0 r
F
.76678 .41582 m .76781 .43135 L .72428 .42761 L F
.8096 .40149 m .76781 .43135 L .76678 .41582 L .525 0 0 r
F
.80554 .38214 m .8096 .40149 L .76678 .41582 L .58 0 0 r
F
.77633 .30537 m .74327 .32716 L .73361 .32048 L .671 0 0 r
F
.74327 .32716 m .71505 .33516 L .73361 .32048 L .769 0 0 r
F
.4223 .64802 m .42811 .6929 L .43234 .67378 L 1 0 0 r
F
.41973 .62973 m .4223 .64802 L .43234 .67378 L .895 0 0 r
F
.40197 .72821 m .38883 .73615 L .36541 .74312 L .12 0 0 r
F
.42811 .6929 m .41685 .70981 L .40197 .72821 L 0 0 0 r
F
.41685 .70981 m .38883 .73615 L .40197 .72821 L .739 0 0 r
F
.77633 .30537 m .77773 .31503 L .77044 .32382 L .671 0 0 r
F
.28718 .64379 m .29889 .63881 L .30314 .62093 L 0 0 0 r
F
.28718 .64379 m .28207 .66274 L .29889 .63881 L F
.72132 .41189 m .69385 .40778 L .6895 .391 L .892 0 0 r
F
.72132 .41189 m .72428 .42761 L .69385 .40778 L F
.82869 .35564 m .8096 .40149 L .80554 .38214 L .337 0 0 r
F
.81657 .33882 m .82869 .35564 L .80554 .38214 L .446 0 0 r
F
.71505 .33516 m .69603 .32794 L .71181 .31694 L .89 0 0 r
F
.71505 .33516 m .7007 .35291 L .69603 .32794 L F
.73361 .32048 m .71505 .33516 L .71181 .31694 L .803 0 0 r
F
.37678 .59559 m .38259 .60038 L .4111 .61544 L .486 0 0 r
F
.34952 .5935 m .38259 .60038 L .37678 .59559 L .455 0 0 r
F
.38259 .60038 m .41973 .62973 L .4111 .61544 L .833 0 0 r
F
.77633 .30537 m .73361 .32048 L .732 .31086 L .671 0 0 r
F
.73361 .32048 m .71181 .31694 L .732 .31086 L .803 0 0 r
F
.34952 .5935 m .34471 .59748 L .38259 .60038 L .455 0 0 r
F
.7007 .35291 m .68623 .34288 L .69603 .32794 L .972 0 0 r
F
.7007 .35291 m .69189 .37211 L .68623 .34288 L F
.36541 .74312 m .34547 .74017 L .33808 .7412 L .125 0 0 r
F
.36541 .74312 m .35998 .74119 L .34547 .74017 L F
.38883 .73615 m .35998 .74119 L .36541 .74312 L .453 0 0 r
F
.3037 .72124 m .30988 .7164 L .29391 .70098 L 0 0 0 r
F
.3037 .72124 m .31689 .73108 L .30988 .7164 L F
.33808 .7412 m .33429 .73481 L .31689 .73108 L .142 0 0 r
F
.33808 .7412 m .34547 .74017 L .33429 .73481 L F
.77633 .30537 m .79902 .32487 L .77773 .31503 L .506 0 0 r
F
.76781 .43135 m .73066 .43771 L .72428 .42761 L .649 0 0 r
F
.76781 .43135 m .76802 .4409 L .73066 .43771 L F
.80883 .41774 m .76802 .4409 L .76781 .43135 L .396 0 0 r
F
.8096 .40149 m .80883 .41774 L .76781 .43135 L .525 0 0 r
F
.41845 .66856 m .41685 .70981 L .42811 .6929 L .959 0 0 r
F
.4223 .64802 m .41845 .66856 L .42811 .6929 L 1 0 0 r
F
.83415 .37375 m .80883 .41774 L .8096 .40149 L .141 0 0 r
F
.82869 .35564 m .83415 .37375 L .8096 .40149 L .337 0 0 r
F
.69189 .37211 m .68348 .36037 L .68623 .34288 L .971 0 0 r
F
.69189 .37211 m .6895 .391 L .68348 .36037 L F
.31266 .60795 m .34109 .6086 L .34471 .59748 L .376 0 0 r
F
.31266 .60795 m .30314 .62093 L .34109 .6086 L F
.28207 .66274 m .30046 .65986 L .29889 .63881 L .156 0 0 r
F
.28207 .66274 m .28435 .68246 L .30046 .65986 L F
.79655 .30645 m .81657 .33882 L .79902 .32487 L .339 0 0 r
F
.77633 .30537 m .79655 .30645 L .79902 .32487 L .506 0 0 r
F
.77633 .30537 m .732 .31086 L .73917 .30196 L .671 0 0 r
F
.732 .31086 m .72538 .29993 L .73917 .30196 L .77 0 0 r
F
.732 .31086 m .71181 .31694 L .72538 .29993 L F
.72428 .42761 m .70465 .42081 L .69385 .40778 L .762 0 0 r
F
.72428 .42761 m .73066 .43771 L .70465 .42081 L F
.38883 .73615 m .37237 .73749 L .35998 .74119 L .453 0 0 r
F
.39958 .72278 m .37237 .73749 L .38883 .73615 L .753 0 0 r
F
.41685 .70981 m .39958 .72278 L .38883 .73615 L .739 0 0 r
F
.38602 .61202 m .4223 .64802 L .41973 .62973 L .873 0 0 r
F
.38259 .60038 m .38602 .61202 L .41973 .62973 L .833 0 0 r
F
.77633 .30537 m .75244 .29723 L .76667 .29854 L .671 0 0 r
F
.77633 .30537 m .73917 .30196 L .75244 .29723 L F
.76667 .29854 m .79655 .30645 L .77633 .30537 L .439 0 0 r
F
.81337 .31348 m .82869 .35564 L .81657 .33882 L .056 0 0 r
F
.79655 .30645 m .81337 .31348 L .81657 .33882 L .339 0 0 r
F
.71181 .31694 m .71467 .30446 L .72538 .29993 L .781 0 0 r
F
.71181 .31694 m .69603 .32794 L .71467 .30446 L F
.34471 .59748 m .38602 .61202 L .38259 .60038 L .671 0 0 r
F
.31689 .73108 m .33068 .7271 L .30988 .7164 L .369 0 0 r
F
.31689 .73108 m .33429 .73481 L .33068 .7271 L F
.73917 .30196 m .7508 .29083 L .75244 .29723 L .614 0 0 r
F
.73917 .30196 m .72538 .29993 L .7508 .29083 L F
.40846 .68925 m .39958 .72278 L .41685 .70981 L .889 0 0 r
F
.41845 .66856 m .40846 .68925 L .41685 .70981 L .959 0 0 r
F
.6895 .391 m .68815 .37874 L .68348 .36037 L 0 0 0 r
F
.6895 .391 m .69385 .40778 L .68815 .37874 L F
.28435 .68246 m .30776 .68193 L .30046 .65986 L .334 0 0 r
F
.28435 .68246 m .29391 .70098 L .30776 .68193 L F
.34471 .59748 m .34109 .6086 L .38602 .61202 L .671 0 0 r
F
.80883 .41774 m .80318 .42929 L .76802 .4409 L .396 0 0 r
F
.83231 .39142 m .80318 .42929 L .80883 .41774 L 0 0 0 r
F
.83415 .37375 m .83231 .39142 L .80883 .41774 L .141 0 0 r
F
.76667 .29854 m .77814 .29335 L .79655 .30645 L .439 0 0 r
F
.75244 .29723 m .77814 .29335 L .76667 .29854 L .455 0 0 r
F
.36336 .71721 m .35998 .74119 L .37237 .73749 L .65 0 0 r
F
.36336 .71721 m .34547 .74017 L .35998 .74119 L F
.75244 .29723 m .7508 .29083 L .77814 .29335 L .455 0 0 r
F
.36336 .71721 m .33429 .73481 L .34547 .74017 L .65 0 0 r
F
.30314 .62093 m .33905 .62589 L .34109 .6086 L .509 0 0 r
F
.30314 .62093 m .29889 .63881 L .33905 .62589 L F
.76802 .4409 m .73995 .44106 L .73066 .43771 L .318 0 0 r
F
.76802 .4409 m .76735 .4434 L .73995 .44106 L F
.80318 .42929 m .76735 .4434 L .76802 .4409 L 0 0 0 r
F
.82509 .32589 m .83415 .37375 L .82869 .35564 L F
.81337 .31348 m .82509 .32589 L .82869 .35564 L .056 0 0 r
F
.38663 .62948 m .41845 .66856 L .4223 .64802 L .862 0 0 r
F
0 g
.01 w
[ ] 0 setdash
.41537 .65137 m
.41926 .65023 L
s
.35746 .66828 m
.40655 .65394 L
s
.41926 .65023 m
.42135 .64962 L
s
.38602 .61202 m .38663 .62948 L .4223 .64802 L .873 0 0 r
F
0 g
.42135 .64962 m
.4312 .64674 L
s
.69603 .32794 m .70819 .31526 L .71467 .30446 L 0 0 0 r
F
.69603 .32794 m .68623 .34288 L .70819 .31526 L F
.36336 .71721 m .37237 .73749 L .37797 .73044 L .65 0 0 r
F
.39958 .72278 m .37797 .73044 L .37237 .73749 L .753 0 0 r
F
.77814 .29335 m .81337 .31348 L .79655 .30645 L 0 0 0 r
F
.73066 .43771 m .72098 .42872 L .70465 .42081 L F
.73066 .43771 m .73995 .44106 L .72098 .42872 L F
.39331 .70795 m .37797 .73044 L .39958 .72278 L .807 0 0 r
F
.40846 .68925 m .39331 .70795 L .39958 .72278 L .889 0 0 r
F
.29391 .70098 m .32009 .70269 L .30776 .68193 L .449 0 0 r
F
.29391 .70098 m .30988 .7164 L .32009 .70269 L F
.36336 .71721 m .33068 .7271 L .33429 .73481 L .65 0 0 r
F
.69385 .40778 m .69992 .39616 L .68815 .37874 L 0 0 0 r
F
.69385 .40778 m .70465 .42081 L .69992 .39616 L F
.72538 .29993 m .74996 .29183 L .7508 .29083 L F
.72538 .29993 m .71467 .30446 L .74996 .29183 L F
.34109 .6086 m .38663 .62948 L .38602 .61202 L .716 0 0 r
F
.36336 .71721 m .37797 .73044 L .37457 .72269 L .65 0 0 r
F
.39331 .70795 m .37457 .72269 L .37797 .73044 L .807 0 0 r
F
.30988 .7164 m .33613 .71995 L .32009 .70269 L .537 0 0 r
F
.30988 .7164 m .33068 .7271 L .33613 .71995 L F
.82509 .32589 m .83042 .34256 L .83415 .37375 L 0 0 0 r
F
.83042 .34256 m .83231 .39142 L .83415 .37375 L .914 0 0 r
F
.80318 .42929 m .79311 .43491 L .76735 .4434 L 0 0 0 r
F
.83231 .39142 m .82321 .4069 L .80318 .42929 L F
.82321 .4069 m .79311 .43491 L .80318 .42929 L .713 0 0 r
F
.38432 .65106 m .40846 .68925 L .41845 .66856 L .841 0 0 r
F
.38663 .62948 m .38432 .65106 L .41845 .66856 L .862 0 0 r
F
.29889 .63881 m .33884 .64768 L .33905 .62589 L .567 0 0 r
F
.29889 .63881 m .30046 .65986 L .33884 .64768 L F
.68623 .34288 m .70668 .3314 L .70819 .31526 L .047 0 0 r
F
.68623 .34288 m .68348 .36037 L .70668 .3314 L F
.34109 .6086 m .33905 .62589 L .38663 .62948 L .716 0 0 r
F
.36336 .71721 m .33613 .71995 L .33068 .7271 L .65 0 0 r
F
.77814 .29335 m .78794 .29534 L .81337 .31348 L 0 0 0 r
F
.7508 .29083 m .78794 .29534 L .77814 .29335 L .179 0 0 r
F
.78794 .29534 m .82509 .32589 L .81337 .31348 L .687 0 0 r
F
.7508 .29083 m .74996 .29183 L .78794 .29534 L .179 0 0 r
F
0 g
.67092 .50407 m
.7144 .43651 L
s
.37927 .67452 m .39331 .70795 L .40846 .68925 L .812 0 0 r
F
.38432 .65106 m .37927 .67452 L .40846 .68925 L .841 0 0 r
F
.76735 .4434 m .75131 .43716 L .73995 .44106 L .379 0 0 r
F
.76735 .4434 m .76585 .4384 L .75131 .43716 L F
.79311 .43491 m .76585 .4384 L .76735 .4434 L .56 0 0 r
F
.37203 .69738 m .37457 .72269 L .39331 .70795 L .772 0 0 r
F
.37203 .69738 m .36336 .71721 L .37457 .72269 L F
.70465 .42081 m .71769 .41082 L .69992 .39616 L .284 0 0 r
F
.70465 .42081 m .72098 .42872 L .71769 .41082 L F
.73995 .44106 m .74131 .43062 L .72098 .42872 L .385 0 0 r
F
.73995 .44106 m .75131 .43716 L .74131 .43062 L F
.37927 .67452 m .37203 .69738 L .39331 .70795 L .812 0 0 r
F
.30046 .65986 m .34052 .67168 L .33884 .64768 L .6 0 0 r
F
.30046 .65986 m .30776 .68193 L .34052 .67168 L F
.33905 .62589 m .38432 .65106 L .38663 .62948 L .728 0 0 r
F
.82871 .36187 m .82321 .4069 L .83231 .39142 L .98 0 0 r
F
.83042 .34256 m .82871 .36187 L .83231 .39142 L .914 0 0 r
F
.36336 .71721 m .34863 .71616 L .33613 .71995 L .65 0 0 r
F
.32009 .70269 m .33613 .71995 L .34863 .71616 L .64 0 0 r
F
.71467 .30446 m .75 .30037 L .74996 .29183 L .337 0 0 r
F
.71467 .30446 m .70819 .31526 L .75 .30037 L F
.68348 .36037 m .7104 .35131 L .70668 .3314 L .291 0 0 r
F
.68348 .36037 m .68815 .37874 L .7104 .35131 L F
.3439 .69535 m .36336 .71721 L .37203 .69738 L .714 0 0 r
F
.3439 .69535 m .34863 .71616 L .36336 .71721 L F
.33905 .62589 m .33884 .64768 L .38432 .65106 L .728 0 0 r
F
.30776 .68193 m .3439 .69535 L .34052 .67168 L .623 0 0 r
F
.30776 .68193 m .32009 .70269 L .3439 .69535 L F
.79311 .43491 m .7795 .43389 L .76585 .4384 L .56 0 0 r
F
.80764 .41861 m .7795 .43389 L .79311 .43491 L .759 0 0 r
F
.82321 .4069 m .80764 .41861 L .79311 .43491 L .713 0 0 r
F
.32009 .70269 m .34863 .71616 L .3439 .69535 L .64 0 0 r
F
.79505 .3045 m .83042 .34256 L .82509 .32589 L .897 0 0 r
F
.78794 .29534 m .79505 .3045 L .82509 .32589 L .687 0 0 r
F
.62358 .5924 m .57207 .6169 L .57767 .58882 L .73 .567 0 r
F
0 g
.4312 .64674 m
.49617 .62776 L
s
.62358 .5924 m .62617 .62104 L .57207 .6169 L .73 .567 0 r
F
.62002 .56388 m .62358 .5924 L .57767 .58882 L .726 .615 0 r
F
.66544 .57938 m .62617 .62104 L .62358 .5924 L .606 .474 0 r
F
.65041 .55426 m .62358 .5924 L .62002 .56388 L .628 .544 0 r
F
.65041 .55426 m .66544 .57938 L .62358 .5924 L F
.33884 .64768 m .37927 .67452 L .38432 .65106 L .73 0 0 r
F
.74996 .29183 m .79505 .3045 L .78794 .29534 L .625 0 0 r
F
.72098 .42872 m .73968 .4212 L .71769 .41082 L .479 0 0 r
F
0 g
.7144 .43651 m
.72028 .42737 L
s
.72784 .41561 m
.75907 .36708 L
s
.72098 .42872 m .74131 .43062 L .73968 .4212 L .479 0 0 r
F
0 g
.72028 .42737 m
.72219 .42439 L
s
.72219 .42439 m
.72268 .42364 L
s
.34052 .67168 m .37203 .69738 L .37927 .67452 L .726 0 0 r
F
.34052 .67168 m .3439 .69535 L .37203 .69738 L F
.82002 .38188 m .80764 .41861 L .82321 .4069 L .901 0 0 r
F
.82871 .36187 m .82002 .38188 L .82321 .4069 L .98 0 0 r
F
.62002 .56388 m .57767 .58882 L .58662 .56123 L .726 .615 0 r
F
.6158 .53796 m .62002 .56388 L .58662 .56123 L .714 .663 0 r
F
.63181 .53281 m .62002 .56388 L .6158 .53796 L .645 .614 0 r
F
.63181 .53281 m .65041 .55426 L .62002 .56388 L F
.62617 .62104 m .57036 .64298 L .57207 .6169 L .728 .509 0 r
F
0 g
.49617 .62776 m
.5023 .62597 L
s
.62617 .62104 m .62757 .64729 L .57036 .64298 L .728 .509 0 r
F
.67558 .60594 m .62757 .64729 L .62617 .62104 L .576 .392 0 r
F
.66544 .57938 m .67558 .60594 L .62617 .62104 L .606 .474 0 r
F
.57767 .58882 m .53242 .59485 L .54414 .56984 L .848 .686 0 r
F
.57767 .58882 m .57207 .6169 L .53242 .59485 L F
.58662 .56123 m .57767 .58882 L .54414 .56984 L .816 .715 0 r
F
.68815 .37874 m .71905 .37296 L .7104 .35131 L .42 0 0 r
F
.68815 .37874 m .69992 .39616 L .71905 .37296 L F
.33884 .64768 m .34052 .67168 L .37927 .67452 L .73 0 0 r
F
.74996 .29183 m .75 .30037 L .79505 .3045 L .625 0 0 r
F
.80695 .82945 m .76464 .85081 L .76892 .82688 L .73 0 0 r
F
.80695 .82945 m .80944 .85379 L .76464 .85081 L F
.80425 .80597 m .80695 .82945 L .76892 .82688 L .726 0 0 r
F
.84308 .82009 m .80944 .85379 L .80695 .82945 L .611 0 0 r
F
.83048 .79906 m .80695 .82945 L .80425 .80597 L .628 0 0 r
F
.83048 .79906 m .84308 .82009 L .80695 .82945 L F
.77571 .40912 m .76585 .4384 L .7795 .43389 L .664 0 0 r
F
.77571 .40912 m .75131 .43716 L .76585 .4384 L F
.58662 .56123 m .54414 .56984 L .56238 .54724 L .816 .715 0 r
F
.59815 .53654 m .58662 .56123 L .56238 .54724 L .772 .735 0 r
F
.6158 .53796 m .58662 .56123 L .59815 .53654 L .714 .663 0 r
F
.77571 .40912 m .74131 .43062 L .75131 .43716 L .664 0 0 r
F
.70819 .31526 m .75096 .31575 L .75 .30037 L .504 0 0 r
F
.70819 .31526 m .70668 .3314 L .75096 .31575 L F
.80425 .80597 m .76892 .82688 L .77658 .80407 L .726 0 0 r
F
.80157 .78543 m .80425 .80597 L .77658 .80407 L .714 0 0 r
F
.81538 .78174 m .80425 .80597 L .80157 .78543 L .642 0 0 r
F
.81538 .78174 m .83048 .79906 L .80425 .80597 L F
.57207 .6169 m .52836 .62001 L .53242 .59485 L .873 .64 0 r
F
.57207 .6169 m .57036 .64298 L .52836 .62001 L F
.80944 .85379 m .76415 .87372 L .76464 .85081 L .728 0 0 r
F
.80944 .85379 m .81148 .87682 L .76415 .87372 L F
.85204 .84294 m .81148 .87682 L .80944 .85379 L .588 0 0 r
F
.84308 .82009 m .85204 .84294 L .80944 .85379 L .611 0 0 r
F
.76892 .82688 m .73369 .83499 L .74273 .81325 L .856 0 0 r
F
.76892 .82688 m .76464 .85081 L .73369 .83499 L F
.77658 .80407 m .76892 .82688 L .74273 .81325 L .824 0 0 r
F
.79867 .32009 m .82871 .36187 L .83042 .34256 L .894 0 0 r
F
.79505 .3045 m .79867 .32009 L .83042 .34256 L .897 0 0 r
F
.77571 .40912 m .7795 .43389 L .7871 .42529 L .664 0 0 r
F
.80764 .41861 m .7871 .42529 L .7795 .43389 L .759 0 0 r
F
.77658 .80407 m .74273 .81325 L .75764 .79403 L .824 0 0 r
F
.78697 .78441 m .77658 .80407 L .75764 .79403 L .777 0 0 r
F
.80157 .78543 m .77658 .80407 L .78697 .78441 L .714 0 0 r
F
.80517 .40051 m .7871 .42529 L .80764 .41861 L .808 0 0 r
F
.82002 .38188 m .80517 .40051 L .80764 .41861 L .901 0 0 r
F
.76464 .85081 m .73143 .85727 L .73369 .83499 L .878 0 0 r
F
.76464 .85081 m .76415 .87372 L .73143 .85727 L F
.69992 .39616 m .73174 .3941 L .71905 .37296 L .504 0 0 r
F
.69992 .39616 m .71769 .41082 L .73174 .3941 L F
.63757 .51214 m .6158 .53796 L .59815 .53654 L .659 .747 0 r
F
0 g
.6669 .51031 m
.67092 .50407 L
s
.63757 .51214 m .63181 .53281 L .6158 .53796 L .659 .747 0 r
F
.66653 .53575 m .66544 .57938 L .65041 .55426 L .492 .486 0 r
F
0 g
.66605 .51162 m
.6669 .51031 L
s
.64016 .52298 m .65041 .55426 L .63181 .53281 L .561 .591 0 r
F
.64016 .52298 m .66653 .53575 L .65041 .55426 L F
.77571 .40912 m .73968 .4212 L .74131 .43062 L .664 0 0 r
F
.68795 .55416 m .67558 .60594 L .66544 .57938 L .409 .365 0 r
F
.66653 .53575 m .68795 .55416 L .66544 .57938 L .492 .486 0 r
F
.62757 .64729 m .57273 .66471 L .57036 .64298 L .715 .428 0 r
F
.62757 .64729 m .62762 .6688 L .57273 .66471 L F
.67986 .63157 m .62762 .6688 L .62757 .64729 L .528 .278 0 r
F
.67558 .60594 m .67986 .63157 L .62757 .64729 L .576 .392 0 r
F
.63757 .51214 m .59815 .53654 L .58545 .52907 L .659 .747 0 r
F
.59815 .53654 m .56238 .54724 L .58545 .52907 L .772 .735 0 r
F
.82198 .76696 m .80157 .78543 L .78697 .78441 L .645 0 0 r
F
.82198 .76696 m .81538 .78174 L .80157 .78543 L F
.84551 .7858 m .84308 .82009 L .83048 .79906 L .495 0 0 r
F
.8232 .7747 m .83048 .79906 L .81538 .78174 L .554 0 0 r
F
.8232 .7747 m .84551 .7858 L .83048 .79906 L F
.864 .80204 m .85204 .84294 L .84308 .82009 L .431 0 0 r
F
.84551 .7858 m .864 .80204 L .84308 .82009 L .495 0 0 r
F
.81148 .87682 m .76755 .89352 L .76415 .87372 L .717 0 0 r
F
.81148 .87682 m .81289 .89644 L .76755 .89352 L F
.85653 .86554 m .81289 .89644 L .81148 .87682 L .554 0 0 r
F
.85204 .84294 m .85653 .86554 L .81148 .87682 L .588 0 0 r
F
.75 .30037 m .79867 .32009 L .79505 .3045 L .711 0 0 r
F
.82198 .76696 m .78697 .78441 L .77704 .77906 L .645 0 0 r
F
.78697 .78441 m .75764 .79403 L .77704 .77906 L .777 0 0 r
F
.63757 .51214 m .64016 .52298 L .63181 .53281 L .659 .747 0 r
F
.77571 .40912 m .7871 .42529 L .7857 .41581 L .664 0 0 r
F
.80517 .40051 m .7857 .41581 L .7871 .42529 L .808 0 0 r
F
.57036 .64298 m .53249 .64297 L .52836 .62001 L .881 .555 0 r
F
.57036 .64298 m .57273 .66471 L .53249 .64297 L F
.71769 .41082 m .74716 .41247 L .73174 .3941 L .571 0 0 r
F
.71769 .41082 m .73968 .4212 L .74716 .41247 L F
.79835 .34061 m .82002 .38188 L .82871 .36187 L .861 0 0 r
F
.79867 .32009 m .79835 .34061 L .82871 .36187 L .894 0 0 r
F
.70238 .57657 m .67986 .63157 L .67558 .60594 L .294 .2 0 r
F
.68795 .55416 m .70238 .57657 L .67558 .60594 L .409 .365 0 r
F
.70668 .3314 m .75275 .3365 L .75096 .31575 L .569 0 0 r
F
.70668 .3314 m .7104 .35131 L .75275 .3365 L F
.56238 .54724 m .53575 .542 L .55653 .52688 L .893 .871 0 r
F
.56238 .54724 m .54414 .56984 L .53575 .542 L F
.58545 .52907 m .56238 .54724 L .55653 .52688 L .807 .834 0 r
F
.82198 .76696 m .8232 .7747 L .81538 .78174 L .645 0 0 r
F
.75 .30037 m .75096 .31575 L .79867 .32009 L .711 0 0 r
F
.76415 .87372 m .73626 .87798 L .73143 .85727 L .882 0 0 r
F
.76415 .87372 m .76755 .89352 L .73626 .87798 L F
.87689 .82194 m .85653 .86554 L .85204 .84294 L .35 0 0 r
F
.864 .80204 m .87689 .82194 L .85204 .84294 L .431 0 0 r
F
.63757 .51214 m .58545 .52907 L .58253 .51831 L .659 .747 0 r
F
.58545 .52907 m .55653 .52688 L .58253 .51831 L .807 .834 0 r
F
.77571 .40912 m .74716 .41247 L .73968 .4212 L .664 0 0 r
F
.75764 .79403 m .73842 .79336 L .75467 .77947 L .911 0 0 r
F
.75764 .79403 m .74273 .81325 L .73842 .79336 L F
.77704 .77906 m .75764 .79403 L .75467 .77947 L .814 0 0 r
F
.54414 .56984 m .52226 .56236 L .53575 .542 L .969 .883 0 r
F
.54414 .56984 m .53242 .59485 L .52226 .56236 L F
0 g
.5365 .61599 m
.61333 .59354 L
s
.82198 .76696 m .77704 .77906 L .77558 .77136 L .645 0 0 r
F
.77704 .77906 m .75467 .77947 L .77558 .77136 L .814 0 0 r
F
.74273 .81325 m .72845 .81182 L .73842 .79336 L .981 0 0 r
F
.74273 .81325 m .73369 .83499 L .72845 .81182 L F
.79406 .36395 m .80517 .40051 L .82002 .38188 L .82 0 0 r
F
.79835 .34061 m .79406 .36395 L .82002 .38188 L .861 0 0 r
F
.78623 .38762 m .7857 .41581 L .80517 .40051 L .773 0 0 r
F
.78623 .38762 m .77571 .40912 L .7857 .41581 L F
.63757 .51214 m .66653 .53575 L .64016 .52298 L .452 .6 0 r
F
.79406 .36395 m .78623 .38762 L .80517 .40051 L .82 0 0 r
F
.82198 .76696 m .84551 .7858 L .8232 .7747 L .425 0 0 r
F
.7104 .35131 m .75519 .36049 L .75275 .3365 L .605 0 0 r
F
.7104 .35131 m .71905 .37296 L .75519 .36049 L F
.62762 .6688 m .57909 .67997 L .57273 .66471 L .67 .28 0 r
F
.62762 .6688 m .6263 .68345 L .57909 .67997 L F
.67778 .65391 m .6263 .68345 L .62762 .6688 L .426 .077 0 r
F
.67986 .63157 m .67778 .65391 L .62762 .6688 L .528 .278 0 r
F
.75096 .31575 m .79835 .34061 L .79867 .32009 L .729 0 0 r
F
.81289 .89644 m .77461 .90829 L .76755 .89352 L .683 0 0 r
F
.81289 .89644 m .81353 .91078 L .77461 .90829 L F
.85605 .88579 m .81353 .91078 L .81289 .89644 L .488 0 0 r
F
.85653 .86554 m .85605 .88579 L .81289 .89644 L .554 0 0 r
F
.77571 .40912 m .76095 .40784 L .74716 .41247 L .664 0 0 r
F
.73174 .3941 m .74716 .41247 L .76095 .40784 L .647 0 0 r
F
.70832 .60093 m .67778 .65391 L .67986 .63157 L .103 0 0 r
F
.70238 .57657 m .70832 .60093 L .67986 .63157 L .294 .2 0 r
F
.88288 .84367 m .85605 .88579 L .85653 .86554 L .23 0 0 r
F
.87689 .82194 m .88288 .84367 L .85653 .86554 L .35 0 0 r
F
.53242 .59485 m .51751 .58609 L .52226 .56236 L .994 .819 0 r
F
.53242 .59485 m .52836 .62001 L .51751 .58609 L F
0 g
.5023 .62597 m
.52788 .6185 L
s
.73369 .83499 m .72584 .83312 L .72845 .81182 L .952 0 0 r
F
.73369 .83499 m .73143 .85727 L .72584 .83312 L F
.66187 .51511 m .68795 .55416 L .66653 .53575 L .228 .424 0 r
F
.63757 .51214 m .66187 .51511 L .66653 .53575 L .452 .6 0 r
F
.84338 .77108 m .864 .80204 L .84551 .7858 L .212 0 0 r
F
.82198 .76696 m .84338 .77108 L .84551 .7858 L .425 0 0 r
F
.82198 .76696 m .77558 .77136 L .78327 .76423 L .645 0 0 r
F
.77558 .77136 m .76922 .76586 L .78327 .76423 L .71 0 0 r
F
.77558 .77136 m .75467 .77947 L .76922 .76586 L F
.63757 .51214 m .58253 .51831 L .59067 .50831 L .659 .747 0 r
F
.58253 .51831 m .5719 .50777 L .59067 .50831 L .76 .928 0 r
F
.58253 .51831 m .55653 .52688 L .5719 .50777 L F
.75802 .38514 m .77571 .40912 L .78623 .38762 L .714 0 0 r
F
.75802 .38514 m .76095 .40784 L .77571 .40912 L F
.76755 .89352 m .74786 .89512 L .73626 .87798 L .828 0 0 r
F
.76755 .89352 m .77461 .90829 L .74786 .89512 L F
.75096 .31575 m .75275 .3365 L .79835 .34061 L .729 0 0 r
F
.57273 .66471 m .54463 .66149 L .53249 .64297 L .823 .361 0 r
F
.57273 .66471 m .57909 .67997 L .54463 .66149 L F
.71905 .37296 m .75802 .38514 L .75519 .36049 L .629 0 0 r
F
.71905 .37296 m .73174 .3941 L .75802 .38514 L F
.73174 .3941 m .76095 .40784 L .75802 .38514 L .647 0 0 r
F
.82198 .76696 m .79723 .76043 L .81206 .76148 L .645 0 0 r
F
.82198 .76696 m .78327 .76423 L .79723 .76043 L F
.81206 .76148 m .84338 .77108 L .82198 .76696 L .23 0 0 r
F
.86129 .78184 m .87689 .82194 L .864 .80204 L 0 0 0 r
F
.84338 .77108 m .86129 .78184 L .864 .80204 L .212 0 0 r
F
.63757 .51214 m .60688 .50299 L .62486 .50446 L .659 .747 0 r
F
.63757 .51214 m .59067 .50831 L .60688 .50299 L F
.62486 .50446 m .66187 .51511 L .63757 .51214 L .332 .656 0 r
F
.75275 .3365 m .79406 .36395 L .79835 .34061 L .731 0 0 r
F
.75467 .77947 m .75842 .77464 L .76922 .76586 L .531 0 0 r
F
.75467 .77947 m .73842 .79336 L .75842 .77464 L F
.68183 .5258 m .70238 .57657 L .68795 .55416 L 0 .103 0 r
F
.66187 .51511 m .68183 .5258 L .68795 .55416 L .228 .424 0 r
F
0 g
.66331 .51589 m
.66605 .51162 L
s
.75519 .36049 m .78623 .38762 L .79406 .36395 L .726 0 0 r
F
.75519 .36049 m .75802 .38514 L .78623 .38762 L F
.55653 .52688 m .55681 .51566 L .5719 .50777 L .753 .993 0 r
F
.55653 .52688 m .53575 .542 L .55681 .51566 L F
.78327 .76423 m .79599 .75858 L .79723 .76043 L .353 0 0 r
F
.78327 .76423 m .76922 .76586 L .79599 .75858 L F
.73143 .85727 m .73099 .8552 L .72584 .83312 L 0 0 0 r
F
.73143 .85727 m .73626 .87798 L .73099 .8552 L F
.75275 .3365 m .75519 .36049 L .79406 .36395 L .731 0 0 r
F
.59067 .50831 m .603 .49752 L .60688 .50299 L .543 .9 0 r
F
.59067 .50831 m .5719 .50777 L .603 .49752 L F
.52836 .62001 m .52218 .61092 L .51751 .58609 L .817 .539 0 r
F
.52836 .62001 m .53249 .64297 L .52218 .61092 L F
.85605 .88579 m .85055 .90173 L .81353 .91078 L .488 0 0 r
F
.88127 .86515 m .85055 .90173 L .85605 .88579 L .014 0 0 r
F
.88288 .84367 m .88127 .86515 L .85605 .88579 L .23 0 0 r
F
.81206 .76148 m .82448 .76059 L .84338 .77108 L F
.79723 .76043 m .82448 .76059 L .81206 .76148 L .126 0 0 r
F
.79723 .76043 m .79599 .75858 L .82448 .76059 L F
.67778 .65391 m .66938 .67078 L .6263 .68345 L .426 .077 0 r
F
.70502 .62494 m .66938 .67078 L .67778 .65391 L 0 0 0 r
F
.70832 .60093 m .70502 .62494 L .67778 .65391 L .103 0 0 r
F
.62486 .50446 m .6376 .50036 L .66187 .51511 L .332 .656 0 r
F
.60688 .50299 m .6376 .50036 L .62486 .50446 L .326 .76 0 r
F
.81353 .91078 m .78475 .91649 L .77461 .90829 L .557 0 0 r
F
.81353 .91078 m .81331 .91831 L .78475 .91649 L F
.85055 .90173 m .81331 .91831 L .81353 .91078 L .314 0 0 r
F
.8739 .79834 m .88288 .84367 L .87689 .82194 L 0 0 0 r
F
.86129 .78184 m .8739 .79834 L .87689 .82194 L F
.60688 .50299 m .603 .49752 L .6376 .50036 L .326 .76 0 r
F
.73842 .79336 m .75201 .7899 L .75842 .77464 L 0 0 0 r
F
.73842 .79336 m .72845 .81182 L .75201 .7899 L F
.82448 .76059 m .86129 .78184 L .84338 .77108 L .404 0 0 r
F
.6263 .68345 m .58896 .68711 L .57909 .67997 L .474 0 0 r
F
.6263 .68345 m .62367 .68966 L .58896 .68711 L F
.66938 .67078 m .62367 .68966 L .6263 .68345 L .132 0 0 r
F
.77461 .90829 m .76524 .90691 L .74786 .89512 L .539 0 0 r
F
.77461 .90829 m .78475 .91649 L .76524 .90691 L F
.69539 .54337 m .70832 .60093 L .70238 .57657 L 0 0 0 r
F
.68183 .5258 m .69539 .54337 L .70238 .57657 L 0 .103 0 r
F
.53575 .542 m .54702 .53144 L .55681 .51566 L 0 0 0 r
F
.53575 .542 m .52226 .56236 L .54702 .53144 L F
.6376 .50036 m .68183 .5258 L .66187 .51511 L 0 .276 0 r
F
.57909 .67997 m .56378 .67362 L .54463 .66149 L .454 0 0 r
F
.57909 .67997 m .58896 .68711 L .56378 .67362 L F
.73626 .87798 m .74351 .87588 L .73099 .8552 L 0 0 0 r
F
.73626 .87798 m .74786 .89512 L .74351 .87588 L F
.76922 .76586 m .79558 .76457 L .79599 .75858 L .224 0 0 r
F
.76922 .76586 m .75842 .77464 L .79558 .76457 L F
.53249 .64297 m .536 .63436 L .52218 .61092 L 0 0 0 r
F
.53249 .64297 m .54463 .66149 L .536 .63436 L F
.8739 .79834 m .87981 .81905 L .88288 .84367 L F
.87981 .81905 m .88127 .86515 L .88288 .84367 L .876 0 0 r
F
.85055 .90173 m .84044 .91172 L .81331 .91831 L .314 0 0 r
F
.87207 .88427 m .84044 .91172 L .85055 .90173 L 0 0 0 r
F
.88127 .86515 m .87207 .88427 L .85055 .90173 L .014 0 0 r
F
.72845 .81182 m .75076 .81023 L .75201 .7899 L .159 0 0 r
F
.72845 .81182 m .72584 .83312 L .75076 .81023 L F
.5719 .50777 m .60005 .50143 L .603 .49752 L 0 0 0 r
F
.5719 .50777 m .55681 .51566 L .60005 .50143 L F
.82448 .76059 m .83518 .76737 L .86129 .78184 L .404 0 0 r
F
.79599 .75858 m .83518 .76737 L .82448 .76059 L .499 0 0 r
F
.83518 .76737 m .8739 .79834 L .86129 .78184 L .806 0 0 r
F
.69539 .54337 m .70103 .56623 L .70832 .60093 L 0 0 0 r
F
.70103 .56623 m .70502 .62494 L .70832 .60093 L .959 .79 0 r
F
.66938 .67078 m .65528 .68039 L .62367 .68966 L .132 0 0 r
F
.70502 .62494 m .6926 .64621 L .66938 .67078 L 0 0 0 r
F
.6926 .64621 m .65528 .68039 L .66938 .67078 L .646 .943 0 r
F
.79599 .75858 m .79558 .76457 L .83518 .76737 L .499 0 0 r
F
0 g
.75716 .77764 m
.80465 .83841 L
s
.72798 .74028 m
.75598 .77613 L
s
.75598 .77613 m
.75635 .77659 L
s
.67154 .66804 m
.67203 .66868 L
s
.61333 .59354 m
.67038 .66656 L
s
.67203 .66868 m
.72798 .74028 L
s
.52226 .56236 m .54369 .55374 L .54702 .53144 L 0 0 0 r
F
.52226 .56236 m .51751 .58609 L .54369 .55374 L F
.81331 .91831 m .79706 .91713 L .78475 .91649 L F
.81331 .91831 m .81223 .91809 L .79706 .91713 L F
.84044 .91172 m .81223 .91809 L .81331 .91831 L .205 0 0 r
F
.74786 .89512 m .76224 .893 L .74351 .87588 L .122 0 0 r
F
.74786 .89512 m .76524 .90691 L .76224 .893 L F
.6376 .50036 m .64825 .50538 L .68183 .5258 L 0 .276 0 r
F
.603 .49752 m .64825 .50538 L .6376 .50036 L .361 0 0 r
F
.78475 .91649 m .78678 .91206 L .76524 .90691 L .109 0 0 r
F
.78475 .91649 m .79706 .91713 L .78678 .91206 L F
.64825 .50538 m .69539 .54337 L .68183 .5258 L .786 .287 0 r
F
0 g
.61333 .59354 m
.66005 .52094 L
s
.87831 .84196 m .87207 .88427 L .88127 .86515 L .973 0 0 r
F
.87981 .81905 m .87831 .84196 L .88127 .86515 L .876 0 0 r
F
.603 .49752 m .60005 .50143 L .64825 .50538 L .361 0 0 r
F
.75842 .77464 m .79607 .77806 L .79558 .76457 L .456 0 0 r
F
.75842 .77464 m .75201 .7899 L .79607 .77806 L F
.72584 .83312 m .75489 .83366 L .75076 .81023 L .307 0 0 r
F
.72584 .83312 m .73099 .8552 L .75489 .83366 L F
.62367 .68966 m .60148 .68513 L .58896 .68711 L .178 .693 0 r
F
.62367 .68966 m .61995 .68649 L .60148 .68513 L F
.65528 .68039 m .61995 .68649 L .62367 .68966 L .433 .868 0 r
F
.54463 .66149 m .55771 .65397 L .536 .63436 L .122 .372 0 r
F
.54463 .66149 m .56378 .67362 L .55771 .65397 L F
.84044 .91172 m .8266 .9146 L .81223 .91809 L .205 0 0 r
F
.87207 .88427 m .85606 .89905 L .84044 .91172 L 0 0 0 r
F
.85606 .89905 m .8266 .9146 L .84044 .91172 L .654 0 0 r
F
.58896 .68711 m .58819 .67797 L .56378 .67362 L .221 .622 0 r
F
.58896 .68711 m .60148 .68513 L .58819 .67797 L F
.84306 .78135 m .87981 .81905 L .8739 .79834 L .89 0 0 r
F
.83518 .76737 m .84306 .78135 L .8739 .79834 L .806 0 0 r
F
.69798 .59218 m .6926 .64621 L .70502 .62494 L .979 .905 0 r
F
.70103 .56623 m .69798 .59218 L .70502 .62494 L .959 .79 0 r
F
.55681 .51566 m .59835 .51467 L .60005 .50143 L .365 0 0 r
F
.55681 .51566 m .54702 .53144 L .59835 .51467 L F
.51751 .58609 m .54733 .5804 L .54369 .55374 L .225 .138 0 r
F
.51751 .58609 m .52218 .61092 L .54733 .5804 L F
.79558 .76457 m .84306 .78135 L .83518 .76737 L .672 0 0 r
F
.76524 .90691 m .78532 .90476 L .76224 .893 L .375 0 0 r
F
.76524 .90691 m .78678 .91206 L .78532 .90476 L F
.86941 .86472 m .85606 .89905 L .87207 .88427 L .918 0 0 r
F
.87831 .84196 m .86941 .86472 L .87207 .88427 L .973 0 0 r
F
.73099 .8552 m .76406 .85775 L .75489 .83366 L .402 0 0 r
F
.73099 .8552 m .74351 .87588 L .76406 .85775 L F
.65528 .68039 m .63673 .68156 L .61995 .68649 L .433 .868 0 r
F
.67211 .66253 m .63673 .68156 L .65528 .68039 L .735 .954 0 r
F
.6926 .64621 m .67211 .66253 L .65528 .68039 L .646 .943 0 r
F
.79558 .76457 m .79607 .77806 L .84306 .78135 L .672 0 0 r
F
.8233 .89539 m .81223 .91809 L .8266 .9146 L .629 0 0 r
F
.8233 .89539 m .79706 .91713 L .81223 .91809 L F
.65567 .51933 m .70103 .56623 L .69539 .54337 L .891 .541 0 r
F
.64825 .50538 m .65567 .51933 L .69539 .54337 L .786 .287 0 r
F
.8233 .89539 m .78678 .91206 L .79706 .91713 L .629 0 0 r
F
.75201 .7899 m .79743 .79786 L .79607 .77806 L .538 0 0 r
F
.75201 .7899 m .75076 .81023 L .79743 .79786 L F
.84721 .8013 m .87831 .84196 L .87981 .81905 L .89 0 0 r
F
.84306 .78135 m .84721 .8013 L .87981 .81905 L F
.8233 .89539 m .8266 .9146 L .83478 .90793 L .629 0 0 r
F
.85606 .89905 m .83478 .90793 L .8266 .9146 L .654 0 0 r
F
.60005 .50143 m .65567 .51933 L .64825 .50538 L .65 .228 0 r
F
.56378 .67362 m .58515 .66765 L .55771 .65397 L .401 .591 0 r
F
.56378 .67362 m .58819 .67797 L .58515 .66765 L F
.85397 .88498 m .83478 .90793 L .85606 .89905 L .816 0 0 r
F
.86941 .86472 m .85397 .88498 L .85606 .89905 L .918 0 0 r
F
.68637 .61857 m .67211 .66253 L .6926 .64621 L .906 .901 0 r
F
.69798 .59218 m .68637 .61857 L .6926 .64621 L .979 .905 0 r
F
.74351 .87588 m .77735 .87999 L .76406 .85775 L .473 0 0 r
F
.74351 .87588 m .76224 .893 L .77735 .87999 L F
.8233 .89539 m .78532 .90476 L .78678 .91206 L .629 0 0 r
F
.52218 .61092 m .55769 .60867 L .54733 .5804 L .367 .334 0 r
F
.52218 .61092 m .536 .63436 L .55769 .60867 L F
.60005 .50143 m .59835 .51467 L .65567 .51933 L .65 .228 0 r
F
.62953 .65436 m .61995 .68649 L .63673 .68156 L .647 .762 0 r
F
.62953 .65436 m .60148 .68513 L .61995 .68649 L F
.79607 .77806 m .84721 .8013 L .84306 .78135 L .715 0 0 r
F
.62953 .65436 m .58819 .67797 L .60148 .68513 L .647 .762 0 r
F
.54702 .53144 m .59813 .53617 L .59835 .51467 L .503 .24 0 r
F
.54702 .53144 m .54369 .55374 L .59813 .53617 L F
.8233 .89539 m .83478 .90793 L .83357 .90058 L .629 0 0 r
F
.85397 .88498 m .83357 .90058 L .83478 .90793 L .816 0 0 r
F
.76224 .893 m .79336 .89799 L .77735 .87999 L .536 0 0 r
F
.76224 .893 m .78532 .90476 L .79336 .89799 L F
.84712 .82525 m .86941 .86472 L .87831 .84196 L .867 0 0 r
F
.84721 .8013 m .84712 .82525 L .87831 .84196 L .89 0 0 r
F
.75076 .81023 m .79954 .82202 L .79743 .79786 L .578 0 0 r
F
.75076 .81023 m .75489 .83366 L .79954 .82202 L F
.65896 .54105 m .69798 .59218 L .70103 .56623 L .887 .643 0 r
F
.65567 .51933 m .65896 .54105 L .70103 .56623 L .891 .541 0 r
F
.79607 .77806 m .79743 .79786 L .84721 .8013 L .715 0 0 r
F
.62953 .65436 m .63673 .68156 L .64551 .67213 L .647 .762 0 r
F
.67211 .66253 m .64551 .67213 L .63673 .68156 L .735 .954 0 r
F
.8233 .89539 m .79336 .89799 L .78532 .90476 L .629 0 0 r
F
.66733 .64261 m .64551 .67213 L .67211 .66253 L .812 .86 0 r
F
.68637 .61857 m .66733 .64261 L .67211 .66253 L .906 .901 0 r
F
.536 .63436 m .57372 .63552 L .55769 .60867 L .464 .473 0 r
F
.536 .63436 m .55771 .65397 L .57372 .63552 L F
.62953 .65436 m .58515 .66765 L .58819 .67797 L .647 .762 0 r
F
.84274 .85071 m .85397 .88498 L .86941 .86472 L .833 0 0 r
F
.84712 .82525 m .84274 .85071 L .86941 .86472 L .867 0 0 r
F
.8345 .87495 m .83357 .90058 L .85397 .88498 L .782 0 0 r
F
.8345 .87495 m .8233 .89539 L .83357 .90058 L F
.84274 .85071 m .8345 .87495 L .85397 .88498 L .833 0 0 r
F
.75489 .83366 m .80218 .848 L .79954 .82202 L .604 0 0 r
F
.75489 .83366 m .76406 .85775 L .80218 .848 L F
.59835 .51467 m .65896 .54105 L .65567 .51933 L .713 .409 0 r
F
.79743 .79786 m .84712 .82525 L .84721 .8013 L .729 0 0 r
F
.8233 .89539 m .8079 .89439 L .79336 .89799 L .629 0 0 r
F
.77735 .87999 m .79336 .89799 L .8079 .89439 L .636 0 0 r
F
.62953 .65436 m .64551 .67213 L .64282 .66173 L .647 .762 0 r
F
.66733 .64261 m .64282 .66173 L .64551 .67213 L .812 .86 0 r
F
.55771 .65397 m .5937 .65806 L .57372 .63552 L .541 .589 0 r
F
.55771 .65397 m .58515 .66765 L .5937 .65806 L F
.65767 .56845 m .68637 .61857 L .69798 .59218 L .861 .695 0 r
F
.65896 .54105 m .65767 .56845 L .69798 .59218 L .887 .643 0 r
F
.54369 .55374 m .59946 .56384 L .59813 .53617 L .562 .373 0 r
F
.54369 .55374 m .54733 .5804 L .59946 .56384 L F
.80507 .87302 m .8233 .89539 L .8345 .87495 L .714 0 0 r
F
.80507 .87302 m .8079 .89439 L .8233 .89539 L F
.59835 .51467 m .59813 .53617 L .65896 .54105 L .713 .409 0 r
F
.79743 .79786 m .79954 .82202 L .84712 .82525 L .729 0 0 r
F
.76406 .85775 m .80507 .87302 L .80218 .848 L .622 0 0 r
F
.76406 .85775 m .77735 .87999 L .80507 .87302 L F
.77735 .87999 m .8079 .89439 L .80507 .87302 L .636 0 0 r
F
.62953 .65436 m .5937 .65806 L .58515 .66765 L .647 .762 0 r
F
.79954 .82202 m .84274 .85071 L .84712 .82525 L .732 0 0 r
F
.65185 .59864 m .66733 .64261 L .68637 .61857 L .825 .727 0 r
F
.65767 .56845 m .65185 .59864 L .68637 .61857 L .861 .695 0 r
F
.80218 .848 m .8345 .87495 L .84274 .85071 L .728 0 0 r
F
.80218 .848 m .80507 .87302 L .8345 .87495 L F
.64212 .62836 m .64282 .66173 L .66733 .64261 L .777 .75 0 r
F
.64212 .62836 m .62953 .65436 L .64282 .66173 L F
.79954 .82202 m .80218 .848 L .84274 .85071 L .732 0 0 r
F
.65185 .59864 m .64212 .62836 L .66733 .64261 L .825 .727 0 r
F
.54733 .5804 m .60222 .59478 L .59946 .56384 L .597 .464 0 r
F
0 g
.59164 .5743 m
.59225 .57484 L
s
.60114 .58273 m
.61333 .59354 L
s
.58425 .56775 m
.59164 .5743 L
s
.54733 .5804 m .55769 .60867 L .60222 .59478 L .597 .464 0 r
F
.59813 .53617 m .65767 .56845 L .65896 .54105 L .729 .502 0 r
F
.62953 .65436 m .61069 .65295 L .5937 .65806 L .647 .762 0 r
F
.57372 .63552 m .5937 .65806 L .61069 .65295 L .638 .617 0 r
F
.6061 .62561 m .62953 .65436 L .64212 .62836 L .714 .67 0 r
F
.6061 .62561 m .61069 .65295 L .62953 .65436 L F
.59813 .53617 m .59946 .56384 L .65767 .56845 L .729 .502 0 r
F
.55769 .60867 m .6061 .62561 L .60222 .59478 L .62 .541 0 r
F
.55769 .60867 m .57372 .63552 L .6061 .62561 L F
.57372 .63552 m .61069 .65295 L .6061 .62561 L .638 .617 0 r
F
.59946 .56384 m .65185 .59864 L .65767 .56845 L .732 .566 0 r
F
.60222 .59478 m .64212 .62836 L .65185 .59864 L .728 .618 0 r
F
.60222 .59478 m .6061 .62561 L .64212 .62836 L F
.59946 .56384 m .60222 .59478 L .65185 .59864 L .732 .566 0 r
F
.54549 .52355 m .49572 .54676 L .50126 .51998 L .734 0 0 r
F
.54549 .52355 m .54783 .5509 L .49572 .54676 L F
.54194 .49605 m .54549 .52355 L .50126 .51998 L .729 0 0 r
F
.5851 .51054 m .54783 .5509 L .54549 .52355 L .587 0 0 r
F
0 g
.55567 .5424 m
.58425 .56775 L
s
.57069 .48646 m .54549 .52355 L .54194 .49605 L .614 0 0 r
F
.57069 .48646 m .5851 .51054 L .54549 .52355 L F
.54194 .49605 m .50126 .51998 L .50977 .49341 L .729 0 0 r
F
.53748 .47082 m .54194 .49605 L .50977 .49341 L .714 0 0 r
F
.55263 .46569 m .54194 .49605 L .53748 .47082 L .635 0 0 r
F
.55263 .46569 m .57069 .48646 L .54194 .49605 L F
.54783 .5509 m .49364 .5714 L .49572 .54676 L .73 0 0 r
F
.54783 .5509 m .54874 .57572 L .49364 .5714 L F
.59456 .5358 m .54874 .57572 L .54783 .5509 L .549 0 0 r
F
.5851 .51054 m .59456 .5358 L .54783 .5509 L .587 0 0 r
F
.50126 .51998 m .45671 .52472 L .46828 .50102 L .862 0 0 r
F
.50126 .51998 m .49572 .54676 L .45671 .52472 L F
.50977 .49341 m .50126 .51998 L .46828 .50102 L .827 0 0 r
F
.50977 .49341 m .46828 .50102 L .48591 .47946 L F
.52049 .46941 m .50977 .49341 L .48591 .47946 L .778 0 0 r
F
.53748 .47082 m .50977 .49341 L .52049 .46941 L .714 0 0 r
F
.49572 .54676 m .45234 .54841 L .45671 .52472 L .887 0 0 r
F
.49572 .54676 m .49364 .5714 L .45234 .54841 L F
.55726 .44511 m .53748 .47082 L .52049 .46941 L .65 0 0 r
F
.55726 .44511 m .55263 .46569 L .53748 .47082 L F
.58534 .46801 m .5851 .51054 L .57069 .48646 L .453 0 0 r
F
.56022 .4559 m .57069 .48646 L .55263 .46569 L .537 0 0 r
F
.56022 .4559 m .58534 .46801 L .57069 .48646 L F
.60555 .48538 m .59456 .5358 L .5851 .51054 L .35 0 0 r
F
.58534 .46801 m .60555 .48538 L .5851 .51054 L .453 0 0 r
F
.54874 .57572 m .49527 .59164 L .49364 .5714 L .711 0 0 r
F
.54874 .57572 m .54812 .59573 L .49527 .59164 L F
.59818 .55997 m .54812 .59573 L .54874 .57572 L .485 0 0 r
F
.59456 .5358 m .59818 .55997 L .54874 .57572 L .549 0 0 r
F
0 g
.53263 .52196 m
.55421 .5411 L
s
.55726 .44511 m .52049 .46941 L .50798 .46197 L .65 0 0 r
F
.52049 .46941 m .48591 .47946 L .50798 .46197 L .778 0 0 r
F
.55726 .44511 m .56022 .4559 L .55263 .46569 L .65 0 0 r
F
.49364 .5714 m .4557 .56986 L .45234 .54841 L .889 0 0 r
F
.49364 .5714 m .49527 .59164 L .4557 .56986 L F
.6189 .50647 m .59818 .55997 L .59456 .5358 L .204 0 0 r
F
.60555 .48538 m .6189 .50647 L .59456 .5358 L .35 0 0 r
F
.48591 .47946 m .45906 .47326 L .47945 .45917 L .899 0 0 r
F
.48591 .47946 m .46828 .50102 L .45906 .47326 L F
.50798 .46197 m .48591 .47946 L .47945 .45917 L .81 0 0 r
F
.55726 .44511 m .50798 .46197 L .50473 .45125 L .65 0 0 r
F
.50798 .46197 m .47945 .45917 L .50473 .45125 L .81 0 0 r
F
.46828 .50102 m .44558 .49229 L .45906 .47326 L .972 0 0 r
F
.46828 .50102 m .45671 .52472 L .44558 .49229 L F
.55726 .44511 m .58534 .46801 L .56022 .4559 L .415 0 0 r
F
.54812 .59573 m .50056 .60551 L .49527 .59164 L .647 0 0 r
F
.54812 .59573 m .54599 .609 L .50056 .60551 L F
.59552 .58081 m .54599 .609 L .54812 .59573 L .35 0 0 r
F
.59818 .55997 m .59552 .58081 L .54812 .59573 L .485 0 0 r
F
.62402 .52934 m .59552 .58081 L .59818 .55997 L 0 0 0 r
F
.6189 .50647 m .62402 .52934 L .59818 .55997 L .204 0 0 r
F
.45671 .52472 m .44046 .51451 L .44558 .49229 L .994 0 0 r
F
.45671 .52472 m .45234 .54841 L .44046 .51451 L F
.57996 .44746 m .60555 .48538 L .58534 .46801 L .161 0 0 r
F
.55726 .44511 m .57996 .44746 L .58534 .46801 L .415 0 0 r
F
.55726 .44511 m .50473 .45125 L .51212 .4413 L .65 0 0 r
F
.50473 .45125 m .49338 .44016 L .51212 .4413 L .756 0 0 r
F
.50473 .45125 m .47945 .45917 L .49338 .44016 L F
.49527 .59164 m .46666 .58697 L .4557 .56986 L .807 0 0 r
F
.49527 .59164 m .50056 .60551 L .46666 .58697 L F
.55726 .44511 m .52744 .436 L .54474 .43747 L .65 0 0 r
F
.55726 .44511 m .51212 .4413 L .52744 .436 L F
.54474 .43747 m .57996 .44746 L .55726 .44511 L .301 0 0 r
F
.5984 .45713 m .6189 .50647 L .60555 .48538 L 0 0 0 r
F
.57996 .44746 m .5984 .45713 L .60555 .48538 L .161 0 0 r
F
.47945 .45917 m .47814 .44703 L .49338 .44016 L .768 0 0 r
F
.47945 .45917 m .45906 .47326 L .47814 .44703 L F
.51212 .4413 m .52276 .42996 L .52744 .436 L .546 0 0 r
F
.51212 .4413 m .49338 .44016 L .52276 .42996 L F
.45234 .54841 m .44439 .5378 L .44046 .51451 L .841 0 0 r
F
.45234 .54841 m .4557 .56986 L .44439 .5378 L F
.59552 .58081 m .58668 .59628 L .54599 .609 L .35 0 0 r
F
.62023 .55182 m .58668 .59628 L .59552 .58081 L 0 0 0 r
F
.62402 .52934 m .62023 .55182 L .59552 .58081 L F
.54474 .43747 m .55605 .43279 L .57996 .44746 L .301 0 0 r
F
.52744 .436 m .55605 .43279 L .54474 .43747 L .325 0 0 r
F
.52744 .436 m .52276 .42996 L .55605 .43279 L F
.54599 .609 m .50911 .61149 L .50056 .60551 L .403 0 0 r
F
.54599 .609 m .5425 .61405 L .50911 .61149 L F
.58668 .59628 m .5425 .61405 L .54599 .609 L .012 0 0 r
F
.5984 .45713 m .61067 .47336 L .6189 .50647 L 0 0 0 r
F
.61067 .47336 m .62402 .52934 L .6189 .50647 L .713 0 0 r
F
.45906 .47326 m .46799 .46148 L .47814 .44703 L 0 0 0 r
F
.45906 .47326 m .44558 .49229 L .46799 .46148 L F
.55605 .43279 m .5984 .45713 L .57996 .44746 L F
.50056 .60551 m .48434 .59795 L .46666 .58697 L .421 0 0 r
F
.50056 .60551 m .50911 .61149 L .48434 .59795 L F
.4557 .56986 m .45716 .55981 L .44439 .5378 L 0 0 0 r
F
.4557 .56986 m .46666 .58697 L .45716 .55981 L F
.49338 .44016 m .51895 .43287 L .52276 .42996 L F
.49338 .44016 m .47814 .44703 L .51895 .43287 L F
.61539 .4947 m .62023 .55182 L .62402 .52934 L .966 0 0 r
F
.61067 .47336 m .61539 .4947 L .62402 .52934 L .713 0 0 r
F
.58668 .59628 m .57234 .60474 L .5425 .61405 L .012 0 0 r
F
.62023 .55182 m .60772 .57167 L .58668 .59628 L 0 0 0 r
F
.60772 .57167 m .57234 .60474 L .58668 .59628 L .692 0 0 r
F
.44558 .49229 m .46414 .48224 L .46799 .46148 L 0 0 0 r
F
.44558 .49229 m .44046 .51451 L .46414 .48224 L F
.55605 .43279 m .56531 .43681 L .5984 .45713 L F
.52276 .42996 m .56531 .43681 L .55605 .43279 L .288 0 0 r
F
.56531 .43681 m .61067 .47336 L .5984 .45713 L .766 0 0 r
F
.52276 .42996 m .51895 .43287 L .56531 .43681 L .288 0 0 r
F
.5425 .61405 m .52019 .60873 L .50911 .61149 L .205 0 0 r
F
.5425 .61405 m .53795 .61009 L .52019 .60873 L F
.57234 .60474 m .53795 .61009 L .5425 .61405 L .46 0 0 r
F
.46666 .58697 m .47761 .57826 L .45716 .55981 L .056 0 0 r
F
.46666 .58697 m .48434 .59795 L .47761 .57826 L F
.50911 .61149 m .50711 .60154 L .48434 .59795 L .202 0 0 r
F
.50911 .61149 m .52019 .60873 L .50711 .60154 L F
.61189 .51907 m .60772 .57167 L .62023 .55182 L .98 0 0 r
F
.61539 .4947 m .61189 .51907 L .62023 .55182 L .966 0 0 r
F
.47814 .44703 m .51642 .44478 L .51895 .43287 L .278 0 0 r
F
.47814 .44703 m .46799 .46148 L .51642 .44478 L F
.44046 .51451 m .46712 .50732 L .46414 .48224 L .123 0 0 r
F
.44046 .51451 m .44439 .5378 L .46712 .50732 L F
.57234 .60474 m .55377 .60514 L .53795 .61009 L .46 0 0 r
F
.58757 .58684 m .55377 .60514 L .57234 .60474 L .734 0 0 r
F
.60772 .57167 m .58757 .58684 L .57234 .60474 L .692 0 0 r
F
.57151 .44942 m .61539 .4947 L .61067 .47336 L .896 0 0 r
F
.56531 .43681 m .57151 .44942 L .61067 .47336 L .766 0 0 r
F
.51895 .43287 m .57151 .44942 L .56531 .43681 L .622 0 0 r
F
.48434 .59795 m .50371 .59119 L .47761 .57826 L .363 0 0 r
F
.48434 .59795 m .50711 .60154 L .50371 .59119 L F
.6004 .54401 m .58757 .58684 L .60772 .57167 L .909 0 0 r
F
.61189 .51907 m .6004 .54401 L .60772 .57167 L .98 0 0 r
F
.44439 .5378 m .47675 .53411 L .46712 .50732 L .301 0 0 r
F
.44439 .5378 m .45716 .55981 L .47675 .53411 L F
.51895 .43287 m .51642 .44478 L .57151 .44942 L .622 0 0 r
F
.54554 .57788 m .53795 .61009 L .55377 .60514 L .636 0 0 r
F
.54554 .57788 m .52019 .60873 L .53795 .61009 L F
.54554 .57788 m .50711 .60154 L .52019 .60873 L F
.46799 .46148 m .51547 .46473 L .51642 .44478 L .454 0 0 r
F
.46799 .46148 m .46414 .48224 L .51547 .46473 L F
.57392 .4696 m .61189 .51907 L .61539 .4947 L .9 0 0 r
F
.57151 .44942 m .57392 .4696 L .61539 .4947 L .896 0 0 r
F
.54554 .57788 m .55377 .60514 L .56171 .59569 L .636 0 0 r
F
.58757 .58684 m .56171 .59569 L .55377 .60514 L .734 0 0 r
F
.58201 .56688 m .56171 .59569 L .58757 .58684 L .814 0 0 r
F
.6004 .54401 m .58201 .56688 L .58757 .58684 L .909 0 0 r
F
.45716 .55981 m .49207 .55978 L .47675 .53411 L .421 0 0 r
F
.45716 .55981 m .47761 .57826 L .49207 .55978 L F
.54554 .57788 m .50371 .59119 L .50711 .60154 L .636 0 0 r
F
.51642 .44478 m .57392 .4696 L .57151 .44942 L .707 0 0 r
F
.54554 .57788 m .56171 .59569 L .55863 .58526 L .636 0 0 r
F
.58201 .56688 m .55863 .58526 L .56171 .59569 L .814 0 0 r
F
.47761 .57826 m .51143 .58158 L .49207 .55978 L .515 0 0 r
F
.47761 .57826 m .50371 .59119 L .51143 .58158 L F
.57217 .49539 m .6004 .54401 L .61189 .51907 L .874 0 0 r
F
.57392 .4696 m .57217 .49539 L .61189 .51907 L .9 0 0 r
F
.46414 .48224 m .51626 .49079 L .51547 .46473 L .532 0 0 r
F
.46414 .48224 m .46712 .50732 L .51626 .49079 L F
.51642 .44478 m .51547 .46473 L .57392 .4696 L .707 0 0 r
F
.54554 .57788 m .51143 .58158 L .50371 .59119 L .636 0 0 r
F
.56639 .52409 m .58201 .56688 L .6004 .54401 L .836 0 0 r
F
.57217 .49539 m .56639 .52409 L .6004 .54401 L .874 0 0 r
F
.55718 .55262 m .55863 .58526 L .58201 .56688 L .782 0 0 r
F
.55718 .55262 m .54554 .57788 L .55863 .58526 L F
.56639 .52409 m .55718 .55262 L .58201 .56688 L .836 0 0 r
F
.46712 .50732 m .51872 .52024 L .51626 .49079 L .576 0 0 r
F
.46712 .50732 m .47675 .53411 L .51872 .52024 L F
.51547 .46473 m .57217 .49539 L .57392 .4696 L .731 0 0 r
F
.54554 .57788 m .52745 .57646 L .51143 .58158 L .636 0 0 r
F
.49207 .55978 m .51143 .58158 L .52745 .57646 L .627 0 0 r
F
.52259 .54987 m .54554 .57788 L .55718 .55262 L .714 0 0 r
F
.52259 .54987 m .52745 .57646 L .54554 .57788 L F
.51547 .46473 m .51626 .49079 L .57217 .49539 L .731 0 0 r
F
.47675 .53411 m .52259 .54987 L .51872 .52024 L .606 0 0 r
F
.47675 .53411 m .49207 .55978 L .52259 .54987 L F
.49207 .55978 m .52745 .57646 L .52259 .54987 L .627 0 0 r
F
.51626 .49079 m .56639 .52409 L .57217 .49539 L .736 0 0 r
F
.51872 .52024 m .55718 .55262 L .56639 .52409 L .73 0 0 r
F
.51872 .52024 m .52259 .54987 L .55718 .55262 L F
.51626 .49079 m .51872 .52024 L .56639 .52409 L .736 0 0 r
F
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[27]:=",
  ImageSize->{271.313, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004?00017a000`40O003h00Oogoo47oo003oOol@
Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00
ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@
Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00
ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@
Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00
ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@
Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00
ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@
Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00
ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@
Ool00?mooa1oo`00ogoo47oo0038Ool2:00:C00kOol00<Ioo`@X00]<0003E01oogoo03Moo`00a7oo
1RP034`000=D07ooOol0=Woo0031Ool7:002@00<F003E00fOol00<5oo`@X00E000eH0003L01D05@0
03Eoo`00`7oo0RP024003EP00W000U@0=7oo002oOol;@00=F004L0000e@0Oomoo`0aOol00;ioo`03
0010040000M000=800aL00E`0003E01oogoo031oo`00_Goo00<000@0@0001D001TP035`01g00<Goo
002lOol00`0010040003@009B00<G008L00`Ool00;aoo`<400a800aL00U`02moo`00^goo10@000<T
04P0B0002DP035`02G00;goo002jOol41002900;B00<G009L00_Ool00;Uoo`@400<T00U800=<00]L
00U`02moo`00^Goo0`@012@01TP01T`02e`00V`01g0000=d07ooOol0;7oo002iOol210059003B009
C00;G004K005L0000g@0Oomoo`0/Ool00;Uoo`03100T02@000@T00a<00]L00I/00=`0003M01oogoo
02aoo`00^Goo1b@000<d04`0C0002D`02e`026`000=`07@0Ool0;Goo002hOol79002=00;C00;G009
K0000g@0Oomoo`0/Ool00;Uoo`DT00@d00M<00=@00YL00Y/0003M01oogoo02aoo`00^Goo12@01C@0
14`01U002U`00VP01f`000=l07@0Ool0;Goo002iOol00`00900T0006=00:D00:G003J006K0000g`0
M01oo`0]Ool00;Uoo`03000T03@000Hd0003@01@050000M@00UL00IX00=/009l0003M01oogoo02ao
o`00^Woo1c@00T002E002E`01fP00V`00W`000=d07ooOol0;7oo002jOol00`00=00d0003=004@008
D009G008J003O0000g@0Oomoo`0/Ool00;Yoo`8000@d00A000Q@00QL00UX0004L01l07`0M00^Ool0
0;Yoo`8000<d00I000Q@00MH009P00IX009`009l02moo`00^goo0P0000<d0400@0001D0025001UP0
160016P00g000W`0;goo002kOol20008@0000dP0D01@0005D006F005H002J004L002O00_Ool00;]o
o`<000039010040000=000=800I@00EH00MP00E`0003O01oogoo02ioo`00^goo0`000R@0140014P0
1E001EP01V000V@0170000=l07ooOol0;Woo002kOol300039002@006B004D004F006H003I004L00a
Ool00;aoo`8000@T00M800YD00=P00AT00=`0003F01oogoo02moo`00_Goo00<002@090000R@000<l
000000000dP035@01V@00W0000=H07ooOol0<7oo002nOol490000c`000000002?00=E006I002F00c
Ool00<1oo`8T00<000<l00aD00=T009P009H03Aoo`00`Goo0`0013`035@016000UP0=Goo0031Ool3
0004<00;E004H002F00fOol008]oo`03000T02@000PT02]oo`800003Ool0030000@`00QD00AP03Uo
o`00R7oo00@00200800P00a<02Qoo`<0009oo`8000@`00AD00A403aoo`00QGoo1b003D`000=P07oo
Ool097oo0P001Woo1c00@7oo0021Ool:800?C002H00SOol2001>Ool0085oo`LP00<h00mH00AP021o
o`<004ioo`00P7oo1B001SP045P000=`0600H0000V007Woo0P00Cgoo001oOol38009>00@F003L003
H00LOol2001@Ool007ioo`dh011H00A`00=P01Yoo`<0051oo`00OWoo3CP045P01W000V006Goo0P00
DGoo001mOol00`00>00h0009>002A008G008F007L002H00GOol2001BOol007aoo`8000Ph00E4011L
00U`0003H01oogoo01=oo`<0059oo`00O7oo0P001CP024@045`02W005Goo0P00Dgoo001kOol30002
>00;A00@G00;L00COol2001DOol007Yoo`<000i4011L00]`019oo`<005Aoo`00NWoo0`0000<<04@0
A0002d@045`02g004Woo0P00EGoo001iOol30002300=A00@G00;L00AOol2001FOol007Qoo`<000<<
00]400=800iL00a`0003F01oogoo00eoo`<005Ioo`00N7oo0`000``024@01TP03U`00V`02W0000=h
07ooOol03Goo0P00Egoo001hOol200043006A008B00>G004K008L0000gP0;00/0003;009Ool2001H
Ool007Qoo`03000<00`000<<00=400]800iL00E/00M`0003N01@h53P00I@h0Eoo`<005Qoo`00N7oo
00<000`030000``03TP03U`01f`01G0000=h05P0D>001e3P00AU87ooOomoo`8005Uoo`00N7oo1P`0
00<T04P0B0002dP03U`026`0170000=h05P0D>001e3P0VDP00Aoo`00000005Uoo`00Mgoo1P`00R@0
3DP03U`02V`00W000WP02E3P0fDP00<007ooOol0F7oo001hOol43003900=B00>G00;K003N009FJ04
IB1JOol007Qoo`<<00DT00U800A<00aL00a/0003O01h07P000YIX003LR1U86DP009U85Qoo`00N7oo
0``01B@01TP01d`035`00VP02V`000=l07P0N0002UVP0g8P0fDPEgoo001hOol230069003B00:C00<
G003J008K002O002N00:FJ04LR03IB1FOol007Qoo`03300T02@000DT00e<00]L00IX00I/009l009h
00YIX0Ib809U85Eoo`00N7oo22@000<d04`0C0002T`02e`01fP016`017`000=h05VPFJ0025VP278P
00=U87ooOol0DWoo001iOol69003=00;C00;G009J002K004O0000gP0GP1N0008GP09LR1DOol007Uo
o`DT00Dd00Y<00YL00]X00El0003N01N05h000QN009bP0Qb85=oo`00NGoo00<002@090000R@01C@0
2T`02U`02fP000=d07`0O0000W`000=h05h0GP0025h017:01W8PDgoo001jOol39007=007C003D008
F00;J002M004O00;GP05LX05LR1COol007Yoo`03000T03@000Pd00=<00I@00QH009T00QX00=d00Al
00]N00MbP0Ab859oo`00NWoo00<003@0=00023@02E0025P016@01FP01G@00W`035h027:00g8PDWoo
001kOol00`00100d0007=0000d00D01@0006D007F007I002J006M002O00<GP0:LX000g8POomoo`1@
Ool007]oo`03000400@000Hd00=000M@00MH00QT00Md0003O01N@5i000YN@0abP59oo`00Ngoo0P00
0P@013@01D001U001UP026@00VP01W@03Ei00Vk02W:000=k87ooOol0Cgoo001lOol01000100400@0
0S@01d001E001UP01f@00fP01G@000=H05i0GT002ei016k027:000=k87ooOol0Cgoo001mOol01000
100400@02D002E001f@016P00g@00UP03Ui01Fk01g:000=k87ooOol0Cgoo001nOol41002;006@00;
D004I005J002M002F00?GT07K/05LX000g/POomoo`1?Ool007ioo`@400@/00=000i@00MX00=H0003
CL1N@5i000eN@0Q^`0AbP09k851oo`00P7oo0P@01R`03e001FP00U`00UP00Tg03ei02Vk00W:00W/P
D7oo0021Ool00`@0;00/0005;00>D003J003G002F003CL0?GT0;K/03Nb1@Ool005]oo`8000Ph01eo
o`L/00i@00EL009H0003CL1>84hP009>80eNH0a^`003Oh1k87/P051oo`00F7oo0P000c002U@07Goo
1AP03E001E`000=H04hPCR001DhP3EiP0V[P2Vk000=oP7/PNb00D7oo001FOol00`00<00`0004<00;
E0000fP0Oomoo`0KOol5600:D005G009CR0=GV03J^08K/02Oh02Nb1@Ool005Aoo`P`00aD00=X01eo
o`@H00E@00Lh00]>80aNH0IZh0I^`09oP09k851oo`00Dgoo1S000d0035P01FP077oo2AP00cP000<]
@3WPCR002dhP35iP1f[P16k017n000=k87ooOol0CWoo001BOol3<007@00<F002K005J00OOol7;D03
>N0;CR0<GV09J^02K/04Oh000g/POomoo`1>Ool0055oo`]000aH00A/00AX01]oo`<000H]@0Dih0Y>
80]NH0]Zh0EoP003Nb1oogoo04ioo`00DGoo2d0035P01V`00VP05Woo2@0012e01SWP2ThP2eiP2f[P
00=cP7n0Oh000Wn0DGoo001@Ool00`00@0100008@00=F008K0000fP0Oomoo`0@Ool80003Ool01000
;D0]@2e023WP2DhP2UiP2f[P0W>017n0DGoo001@Ool00`00@0100005@003B00=G009K00>Ool90007
Ool00`00;D0ih009>N04CR05DV09FZ02H^08J^03Lh03Oh1BOol004moo`8000=000M800eL00Y/00Yo
o`L000aoo`03000ih3WP00Tih0UBH0UJX0ARh0EZh0EcP09oP59oo`00Cgoo00<004P0B0002DP03E`0
2V`01Woo1`0047oo0P0000<=H3WP>N001SWP0TI0259P25ZP1f;P0V[P1W>000=oP7ooOol0DGoo001>
Ool200000a00B0180008B00=G00:K0000g00Ool00007000COol200023F06>N04AT08DV07FZ08H^07
Lh000gn0Oomoo`1AOol004eoo`80008@00Y800eL00U/00L001Qoo`80008=H0@ih0I6@0MBH0IJX0QR
h09WH0IcP5Aoo`00CGoo0P000Q002TP03E`01F`000<006`0K0001@0077oo00@000eP3F0=H08ih0Q6
@0IBH0IJX0MRh0=WH0EcP5Eoo`00CGoo00@00100400@00M800A<00]L00M/00@00003O01`07oo01eo
o`04000=H0eP3F0:AT05DV05FZ06H^05If04Lh1FOol004eoo`04000@01004004B007C00;G003J006
K0001000K01l07007goo10eP00<b@4I0AT001TI035<00f;P1VMP0g>0Egoo001=Ool4400;C00;G005
J006K0000g`0L01oo`0NOol43F03<T06AT0=D`08If02Lh1HOol004aoo`D@0003:01<04`000Q<00]L
00QX00=/009l025oo`8=H0Db@0=6@0mC00MWH003Dl1oogoo05Moo`00C7oo11000RP02T`02e`02VP0
0g`08Woo0PeP1S9045<016MP0Uo000=C`0000000F7oo001<Ool34003:00:C00;G00:J0000gP0O01l
000SOol00`eP<T0b@004<T0@D`05Gl0015?000000000F7oo001<Ool24005:009C00:G00:J002N002
O00TOol6<T0@D`04Gl0015?0Oomoogoo0P00Egoo001<Ool00a00:00X0004:009C00:G002I008J002
N002O00WOol37V0?D`04Gl05Ool3001FOol004aoo`LX00U<00YL00AT00EX00Ah0003O01oogoo02Mo
o`<NH0aC008gH0Uoo`<005Eoo`00CGoo1RP000<h04`0C0001T`02E`01f@00fP017P000=l07ooOol0
:Goo0aiP1E<013MP3Goo0P00EGoo001=Ool00`00:00X0002:002>008C009G009I005N0000g`0Oomo
o`13Ool2001DOol004ioo`<X00@h00M<00UL00UT0003L01h07P0009h04Ioo`<005=oo`00CWoo00<0
02P0>00013P01d`025`02F@00W0017P0Agoo0`00DWoo001?Ool7>003C004D007F002H006I004L002
N019Ool2001BOol004moo`03000h03P000@h00M@00MH00AP00=T00E`0003N01oogoo04Uoo`80055o
o`00Cgoo0P0013P00T@01e001EP01f001W00C7oo0`00D7oo001@Ool20002>004A006D005F006H002
I004L0000e`0Oomoo`1;Ool3001?Ool0055oo`8000I400E@00AH00IP00=T00=`0003G01oogoo04eo
o`8004moo`00DWoo0P0000</04@0A0000d@02U000f001F@000=`05`0Ool0D7oo0P00CWoo001BOol2
0003;003A00;D007I0000e`0Oomoo`1@Ool3001=Ool005Aoo`03000/02`0008/00e@00=T00=P05Ao
o`<004aoo`00EGoo1B`035001F00EWoo0P00C7oo001GOol3400;D005H01HOol2001;Ool005Uoo`<@
00Q@00EP05Uoo`<004Yoo`00Fgoo0Q00150000<h07ooOol0Ggoo0`00BGoo0034Ool30018Ool00<Eo
o`<004Moo`00aWoo0`00AWoo0037Ool20016Ool00<Qoo`8004Eoo`00b7oo0`0027oo11`02C`0;goo
0039Ool30003Ool57003>00:E0000c00Oomoo`0[Ool00<Yoo`<00004OolL01`07006>00;E0000f@0
Oomoo`0ZOol00<]oo`8000Xh00]D00=T02Yoo`00bgoo0P002SP035@016@0:7oo003:Ool00d00000h
0006>004A00<F005I00WOol00<Uoo`03@000000000<h00Q400eH009`00=T02Ioo`00b7oo00=00000
000034@03EP017000V@09Goo0037Ool300000a@0A014000:A00>F005L0000f@0Oomoo`0ROol00<Mo
o`80008D00a400iH00M`02=oo`00aWoo0P000a@02D@014P03E`027008Woo0036Ool00`00500D0002
5006A007B00=G008L00ROol00<Eoo`03000D01@000<D00=400Y800eL00Q`029oo`00a7oo1Q@03TP0
3E`027008Woo0034Ool55002900=B00=G008L00ROol00<Aoo`@D00<T00e800eL00Q`029oo`00a7oo
0a@012@03DP03E`02G008Goo0034Ool250069008B004C00<G00:L00QOol00<Aoo`03500T02@000DT
00A800Q<00aL00=/00M`025oo`00a7oo22@034`035`01F`01G008Goo0035Ool69002<00;C00<G007
K003L00QOol00<Eoo`DT00<`00]<00aL00U/0003L01oogoo01moo`00aGoo12@013002d`035`02F`0
00=l07ooOol07goo0035Ool39006<00:C00<G009K0000g`0Oomoo`0OOol00<Eoo`8T00L`00]<00YL
00U/009l025oo`00aGoo2C002d`02U`00fP01V`00W`08Goo0036Ool7<002?00:C00:G006J003K002
O00QOol00<Ioo`03000`030000<`00@l00U<00UL00UX00=l025oo`00aWoo00<00300<0000S001C`0
2D`02E`02FP00g`08Goo0037Ool00`00<00`0007?008C009G008J0000g@0O01l000ROol00<Moo`03
000l03`000Pl00M<00QL00QX009d009l029oo`00agoo0P0000<<03`0?0001S`025001eP00V@01FP0
0g@000=l07ooOol08Goo0038Ool00`00300<0006?002A007D006F005I002J004M0000g`0Oomoo`0Q
Ool00<Uoo`<<00@l00A400I@00IH00IT00Ed02Aoo`00bGoo00@000`0300<008l00I400E@00EH00IT
009X00=d02Eoo`00bWoo10`024@015001EP01F@00fP00W@09Woo003:Ool43002;006A008D005I004
J0000g@0Oomoo`0UOol00<aoo`8<00@/00=400a@00IX02Qoo`00cGoo00<<02`0;00012`03E000fP0
0U00:Goo003>Ool6;00AD00ZOol00=5oo`<<00m@02aoo`00e7oo0``02500<7oo003oOol@Ool00?mo
oa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo
003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mo
oa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo
003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mo
oa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo003oOol@Ool00?mooa1oo`00ogoo47oo
0000\
\>"],
  ImageRangeCache->{{{0, 270.313}, {286.938, 0}} -> {0.0403593, \
-2.76835*^-05, 0.00322536, 0.00322536}},
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[57]=",
  CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Comparing XSLT and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " "
}], "Subsection",
  CellTags->{"ManipulatingExample4", "i:43", "b:2.4"}],

Cell[TextData[{
  "In many situations, there is a need to transform a document from one XML \
format into another. One popular technique used for this purpose is XSLT \
transformations. However, ",
  "Mathematica\[CloseCurlyQuote]",
  "s pattern-matching and transformation abilities allow you to do similar \
transformations simply by importing the original document and then \
manipulating the resulting SymbolicXML expression. This section gives \
examples of some basic XSLT transformations and shows how to do the \
equivalent transformations in ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->{"ManipulatingExample4", "i:43", "b:2.4"}],

Cell[CellGroupData[{

Cell["A Simple Template", "Subsubsection",
  CellTags->{"ManipulatingExample4", "b:2.4"}],

Cell[TextData[{
  "Let's consider a very simple example. Say our XML dialect uses the ",
  StyleBox["code",
    FontFamily->"Courier"],
  " tag to enclose program code. Typically, this is displayed in a monospace \
font. If we were to convert such a document to XHTML, we would probably want \
to use the ",
  StyleBox["pre",
    FontFamily->"Courier"],
  " tag for code. The following XSLT template would do this."
}], "Text",
  CellTags->{"ManipulatingExample4", "b:2.4"}],

Cell["\<\
<xsl:template match=\"code\">
\t<pre class=\"code\">
\t\t<xsl:value-of select=\".\"/>
\t</pre>
</xsl:template>\
\>", "Program",
  CellTags->{"ManipulatingExample4", "b:2.4"}],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", you can create a function to do the same."
}], "Text",
  CellTags->{"ManipulatingExample4", "b:2.4"}],

Cell[BoxData[
    \(\(xslt[
          XMLElement["\<pre\>", _, {value_String}]] \
:= \[IndentingNewLine]XMLElement["\<pre\>", {"\<class\>" -> "\<code\>"}, \
{value}];\)\)], "Input",
  CellLabel->"In[58]:=",
  CellTags->{"ManipulatingExample4", "b:2.4"}],

Cell[BoxData[
    \(\(xslt[
          XMLElement["\<code\>", _, 
            data_]] := \[IndentingNewLine]XMLElement["\<pre\>", {"\<class\>" -> \
"\<code\>"}, data];\)\)], "Input",
  CellLabel->"In[59]:=",
  CellTags->{"ManipulatingExample4", "b:2.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Inserting Attribute Values", "Subsubsection",
  CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],

Cell[TextData[{
  "Now consider an XML application which uses the ",
  StyleBox["termdef",
    FontFamily->"Courier"],
  " element to indicate the definition of a new term. Again, we will convert \
this to XHTML. We would like to anchor the definition with an element named \
",
  StyleBox["a",
    FontFamily->"Courier"],
  " so that we can link directly to that location in the document. Assuming \
we have templates to handle whatever string formatting is inside the ",
  StyleBox["termdef",
    FontFamily->"Courier"],
  " element, we can use the following XSLT."
}], "Text",
  CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],

Cell["\<\
<xsl:template match=\"termdef\">
\t<span class=\"termdef\">
\t\t<a name=\"{@id}\">[Definition:]&nbsp;&nbsp;</a>
\t\t<xsl:apply-templates/>
\t</span>
</xsl:template>\
\>", "Program",
  CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],

Cell[TextData[{
  "Notice that the ",
  StyleBox["name",
    FontFamily->"Courier"],
  " attribute in the resultant XHTML gets the value of the ",
  StyleBox["id",
    FontFamily->"Courier"],
  " attribute of the original ",
  StyleBox["termdef",
    FontFamily->"Courier"],
  " element. In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", you can do the following."
}], "Text",
  CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],

Cell[BoxData[
    \(\(xslt[
          XMLElement["\<termdef\>", {___, "\<id\>" \[Rule] id_, ___}, 
            contents_]] := \[IndentingNewLine]XMLElement["\<span\>", \
{"\<class\>" -> "\<termdef\>"}, \[IndentingNewLine]{XMLElement["\<a\>", \
{"\<name\>" \[Rule] 
                  id}, {"\<[Definitions:]  \>"}], \[IndentingNewLine]Sequence \
@@ \(xslt /@ contents\)}];\)\)], "Input",
  CellLabel->"In[60]:=",
  CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Using Predicates", "Subsubsection",
  CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],

Cell[TextData[{
  "Consider a more complicated example, which will use XPath predicates. \
Assume we would like to match a",
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["note",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  "element, but only if it either has a ",
  StyleBox["role",
    FontFamily->"Courier"],
  " attribute set to ",
  StyleBox["example",
    FontFamily->"Courier"],
  " or if it contains an ",
  StyleBox["eg",
    FontFamily->"Courier"],
  " element as a child. Let us look at an XSLT template, and then explain \
what it does."
}], "Text",
  CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],

Cell["\<\
<xsl:template match=\"note[@role='example' or child::eg]\">
\t<div class=\"exampleOuter\">
\t\t<div class=\"exampleHeader\">Example</div>
\t\t<xsl:if test=\"*[1][self::p]\">
\t\t\t<div class=\"exampleWrapper\">
\t\t\t\t<xsl:apply-templates select=\"*[1]\"/>
\t\t\t</div>
\t\t</xsl:if>
\t\t<div class=\"exampleInner\">
\t\t\t<xsl:apply-templates select=\"eg\"/>
\t\t</div>
\t\t<xsl:if test=\"*[position()>1 and self::p]\">
\t\t\t<div class=\"exampleWrapper\">
\t\t\t\t<xsl:apply-templates
\t\t\t\t\tselect=\"*[position>1 and self::p]\"/>
\t\t\t</div>
\t\t</xsl:if>
\t</div>
</xsl:template>\
\>", "Program",
  CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],

Cell[TextData[{
  "The first ",
  StyleBox["xsl:if",
    FontFamily->"Courier"],
  " element checks to see if the first child element is a ",
  StyleBox["p",
    FontFamily->"Courier"],
  " element. If it is, then ",
  StyleBox["xsl:apply-templates",
    FontFamily->"Courier"],
  " is called on that child. This is similar to calling ",
  StyleBox["Map",
    FontFamily->"Courier"],
  " across the results of ",
  StyleBox["Cases",
    FontFamily->"Courier"],
  ". In the second ",
  StyleBox["xsl:if",
    FontFamily->"Courier"],
  " element, we check if there are ",
  StyleBox["p",
    FontFamily->"Courier"],
  " child elements beyond the first child. If so, ",
  StyleBox["xsl:apply-templates",
    FontFamily->"Courier"],
  " is called on those. Here is the corresponding ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code."
}], "Text",
  CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],

Cell[BoxData[
    \(\(xslt[\[IndentingNewLine]XMLElement["\<note\>", 
              atts : {___, "\<role\>" -> "\<example\>", ___}, 
              contents]\  | \[IndentingNewLine]XMLElement["\<note\>", atts_, 
              contents : {___, 
                  XMLElement["\<eg\>", ___], ___}]] \
:= \[IndentingNewLine]XMLElement["\<div\>", {"\<class\>" -> \
"\<exampleOuter\>"}, {\[IndentingNewLine]XMLElement["\<div\>", {"\<class\>" -> \
"\<exampleHeader\>"}, {"\<Example\>"}], \[IndentingNewLine]If[
              MatchQ[contents, {XMLElement["\<p\>", ___], ___}], \
\[IndentingNewLine]XMLElement["\<div\>", {"\<class\>" -> \
"\<exampleWrapper\>"}, 
                xslt[contents[\([1]\)]]], \[IndentingNewLine]Sequence[]], \
\[IndentingNewLine]XMLElement["\<div\>", {"\<class\>" -> "\<exampleInner\>"}, 
              Map[xslt, 
                Cases[contents, 
                  XMLElement["\<eg\>", ___]]]], \[IndentingNewLine]Sequence @@ 
              Map[xslt, 
                Cases[Drop[contents, 1], 
                  XMLElement["\<p\>", ___]]]}];\)\)], "Input",
  CellLabel->"In[61]:=",
  CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \({a, If[False, bob, Sequence @@ {}], b}\)], "Input",
  CellLabel->"In[62]:=",
  CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],

Cell[BoxData[
    \({a, b}\)], "Output",
  CellLabel->"Out[62]=",
  CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Traversing Upwards", "Subsubsection",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[TextData[{
  "So far, all the examples we have given in XSLT have had a very simple \
implementation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using SymbolicXML. In each of these cases, however, we were selecting \
expressions that were nested inside of the given expression. What if we \
wanted to select an ancestor or sibling? Let us see how this can be done."
}], "Text",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[TextData[{
  "To clarify the problem and find a solution, we have to realize that an XML \
document is just a stream of characters that follows a grammar. Tools for \
manipulating XML documents treat XML according to some model. In the case of \
XSLT (and its path-selection language, XPath), this model is that of a tree. \
Since ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is a list-based language, it treats XML as nested expression lists."
}], "Text",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell["\<\
While these two models are similar, they have important \
differences. Most notably, in nested lists you do not inherently have any \
concept of the containing list. Technically, any transformation that can be \
done with axis types like ancestor can also be done without them. However, it \
is often convenient to traverse up the XML document.\
\>", "Text",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[TextData[{
  "Let us look at an example and then discuss how to implement the same \
behavior in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". While it will involve a slightly different technique than we have used \
above, it will nonetheless be rather simple. Consider the following XML \
document."
}], "Text",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(myxml = XML`Parser`XMLGetString["\<<document>
	<body>
		<p>This is a paragraph.</p>
		<p>This paragraph contains a bibliography referece:
			<bibref ref=\"mybibref\"/>
		</p>
	</body>
	<bibliography>
		<bibl id=\"mybibref\">My Bibliography Reference</bibl>
	</bibliography>
</document>\>"]\)], "Input",
  CellLabel->"In[63]:=",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "document", {}, {XMLElement[
            "body", {}, {XMLElement["p", {}, {"This is a paragraph."}], 
              XMLElement[
                "p", {}, {"This paragraph contains a bibliography referece:", 
                  XMLElement["bibref", {"ref" \[Rule] "mybibref"}, {}]}]}], 
          XMLElement[
            "bibliography", {}, {XMLElement[
                "bibl", {"id" \[Rule] 
                    "mybibref"}, {"My Bibliography Reference"}]}]}], {}]\)], \
"Output",
  CellLabel->"Out[63]=",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}]
}, Closed]],

Cell[TextData[{
  "We will assume we simply want to have a template which matches ",
  StyleBox["bibref",
    FontFamily->"Courier"],
  " elements and replaces them with the text inside of the corresponding ",
  StyleBox["bibl",
    FontFamily->"Courier"],
  " element. In XSLT, we would write the following template."
}], "Text",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell["\<\
<xsl:template match=\"bibref\">
\t<xsl:param name=\"ref\">
\t\t<xsl:value-of select=\"@ref\"/>
\t</xsl:param>
\t<xsl:value-of select=\"/bibliography/bibl[@id = $ref][1]\"/>
</xsl:template>\
\>", "Program",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[TextData[{
  "The problem with using the same approach in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is that once we have matched a ",
  StyleBox["bibref",
    FontFamily->"Courier"],
  " element, we no longer have any information about the elements containing \
it. As a remedy, we will instead pass an expression containing the entire \
SymbolicXML expression. Notice that the ",
  StyleBox["bibref",
    FontFamily->"Courier"],
  " element in question can be obtained from"
}], "Text",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[myxml, 2, 3, 1, 3, 2, 3, 2]\)], "Input",
  CellLabel->"In[64]:=",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[BoxData[
    \(XMLElement["bibref", {"ref" \[Rule] "mybibref"}, {}]\)], "Output",
  CellLabel->"Out[64]=",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}]
}, Closed]],

Cell[TextData[{
  "Rather than pass the ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  " expression, we can pass this expression wrapped in ",
  StyleBox["Hold",
    FontFamily->"Courier"],
  ". That way, we can easily obtain the ",
  StyleBox["bibref",
    FontFamily->"Courier"],
  " element by calling ",
  StyleBox["ReleaseHold",
    FontFamily->"Courier"],
  ", and we can access ancestors by dropping indices from the ",
  StyleBox["Part",
    FontFamily->"Courier"],
  " expression. However, we will need to write a pattern-matching function so \
that we can match these in definitions of functions."
}], "Text",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[BoxData[
    \(\(XMLMatchQ[expr_, 
          patt_] := \[IndentingNewLine]And[\[IndentingNewLine]MatchQ[expr, 
            Hold[Part[___]]], \[IndentingNewLine]MatchQ[ReleaseHold[expr], 
            patt]];\)\)], "Input",
  CellLabel->"In[65]:=",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XMLMatchQ[Hold[Part[myxml, 2, 3, 1, 3, 2, 3, 2]], 
      XMLElement["\<bibref\>", _, _]]\)], "Input",
  CellLabel->"In[66]:=",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[66]=",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}]
}, Closed]],

Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " transformation then becomes relatively simple."
}], "Text",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[BoxData[
    \(Clear[xslt]\)], "Input",
  CellLabel->"In[67]:=",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[BoxData[
    \(xslt[
        xml_?\((XMLMatchQ[#, 
                XMLElement["\<bibref\>", {___}, _]] &)\)] \
:= \[IndentingNewLine]Module[{ref}, \[IndentingNewLine]ref = "\<ref\>" /. \
\(ReleaseHold[xml]\)[\([2]\)]; \[IndentingNewLine]First[
          Cases[\(Part[xml, 1, 
                1]\)[\([2]\)], \
\[IndentingNewLine]XMLElement["\<bibliography\>", _, {___, \
\[IndentingNewLine]XMLElement["\<bibl\>", {"\<id\>" \[Rule] 
                        ref}, {s_}], ___}] \[Rule] s, 2]]]\)], "Input",
  CellLabel->"In[68]:=",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(xslt[Hold[Part[myxml, 2, 3, 1, 3, 2, 3, 2]]]\)], "Input",
  CellLabel->"In[69]:=",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],

Cell[BoxData[
    \("My Bibliography Reference"\)], "Output",
  CellLabel->"Out[69]=",
  CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Converting a Notebook to HTML", "Subsection",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[TextData[{
  "Suppose you need to export a notebook in a specific XML format (apart from \
standard formats listed under the ",
  StyleBox["File \[RightTriangle] Save As Special", "SR"],
  " menu). One option would be to export to NotebookML and then use some \
external tool (e.g., XSLT rules) to transform to the desired form of XML. But \
often it is just as easy to perform the manipulation within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", converting the notebook expression directly into SymbolicXML and saving \
the latter. Anyone with a basic command of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " patterns and programming should be able to do this. Users coming from an \
XSLT background may even feel a sense of ",
  StyleBox["deja vu",
    FontSlant->"Italic"],
  "; since ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions are essentially trees, the techniques are much the same."
}], "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[TextData[{
  "As an example, let us recreate an abridged version of the ",
  StyleBox["File \[RightTriangle] Save As Special \[RightTriangle] HTML", 
    "SR"],
  " functionality. First, create an example notebook."
}], "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[
    \(\(nb = 
        NotebookOpen[
          ToFileName[Directory[], "\<Shakespeare.nb\>"]];\)\)], "Input",
  CellLabel->"In[70]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(data = NotebookGet[nb]\)], "Input",
  CellLabel->"In[71]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[
    \(Notebook[{Cell[
          CellGroupData[{Cell["Quotations", "Title"], 
              Cell[CellGroupData[{Cell["Shakespeare", "Section"], 
                    Cell[TextData[{"Now is the winter of our discontent made \
glorious summer by this ", 
                          StyleBox["Son of York", 
                            FontSlant \[Rule] "Italic"], 
                          ".  And all the clouds that lowered on our house, \
in the Ocean's deep bosum buried."}], "Text"], 
                    Cell[TextData[{"Forgive me, though bleeding piece of \
earth, that I am meek and gentle with these butchers.  Thou art the ruinest \
of the noblest man that ever lived in the tide of time.  Woe to the hands ", 
                          StyleBox["that shed this costy blood", 
                            FontWeight \[Rule] "Bold"], "!"}], "Text"]}, 
                  Open]]}, Open]]}, FrontEndVersion \[Rule] "4.1 for X", 
      ScreenRectangle \[Rule] {{0.`, 1280.`}, {0.`, 1024.`}}, 
      WindowSize \[Rule] {520.`, 600.`}, 
      WindowMargins \[Rule] {{22.`, Automatic}, {Automatic, 63.`}}, 
      CellLabelAutoDelete \[Rule] True]\)], "Output",
  CellLabel->"Out[71]=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}]
}, Open  ]],

Cell[TextData[{
  "Our method will be to define a recursive function, ",
  StyleBox["transform", "Input",
    FontWeight->"Plain"],
  ", to process the original notebook expression from top to bottom, similar \
to the templates of XSLT. First, we establish a default definition to discard \
anything not explicitly matched by other patterns. (Given our \
\[OpenCurlyDoubleQuote]top-down\[CloseCurlyDoubleQuote] approach, perhaps \
this should be the last definition, but we place it here to reduce extraneous \
output in the intermediate results.)"
}], "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[
    \(\(Clear[transform];\)\)], "Input",
  CellLabel->"In[73]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell["transform[___]:=Sequence[];", "Input",
  CellLabel->"In[74]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[TextData[{
  "The above definition uses ",
  StyleBox["Sequence[]", "Input",
    FontWeight->"Plain"],
  " for the following reason: since ",
  StyleBox["transform", "Input",
    FontWeight->"Plain"],
  " will be applied recursively, the best \"null'' result is one that can \
dropped in the midst of a list of arguments without disrupting the syntax."
}], "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell["We start with the notebook expression itself.", "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[
    \(\(transform[Notebook[contents_List, ___]] := 
        XMLElement["\<html\>", {}, {XMLElement["\<body\>", {}, 
              transform /@ content]}];\)\)], "Input",
  CellLabel->"In[75]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[TextData[StyleBox["Note:",
  FontWeight->"Bold"]], "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[TextData[{
  "The argument pattern must be robust enough to accept all variants. (Even \
though the notebook options are discarded in this conversion, a ",
  StyleBox["BlankNullSequence", "Input",
    FontWeight->"Plain"],
  " (",
  StyleBox["___", "Input"],
  ") is included to allow for them)."
}], "BulletedList",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[TextData[{
  "The only thing done with the ",
  StyleBox["contents", "Input",
    FontWeight->"Plain"],
  " argument is to pass it back to ",
  StyleBox["transform", "Input",
    FontWeight->"Plain"],
  " ."
}], "BulletedList",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[TextData[{
  "The third argument is ",
  StyleBox["always",
    FontSlant->"Italic"],
  " a ",
  StyleBox["List", "Input",
    FontWeight->"Plain"],
  ". Forgetting this is a common pitfall."
}], "BulletedList",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[TextData[{
  "Those familiar with HTML will notice that we have dropped the ",
  StyleBox["head", "Output"],
  " element."
}], "BulletedList",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell["\<\
The same general theme is followed for the remaining definitions.\
\
\>", "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell["\<\
Next, we discard cell-grouping information, since the HTML has no \
use for it.\
\>", "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[
    \(\(transform[Cell[CellGroupData[contents_List, ___]]] := 
        Sequence @@ \((transform /@ contents)\);\)\)], "Input",
  CellLabel->"In[76]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sectional heads are translated to their HTML counterparts."
}], "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[{
    \(\(transform[Cell[title_String, "\<Title\>"]] := 
        XMLElement["\<h1\>", {}, {title}];\)\), "\n", 
    \(\(transform[Cell[title_String, "\<Section\>"]] := 
        XMLElement["\<h2\>", {}, {title}];\)\)}], "Input",
  CellLabel->"In[77]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[TextData[{
  "Now for the ",
  StyleBox["Text", "Input",
    FontWeight->"Plain"],
  " cells. This introduces a complication, as the contents of a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["Text", "Input",
    FontWeight->"Plain"],
  "-style cell can be a simple string or a ",
  StyleBox["TextData", "Input",
    FontWeight->"Plain"],
  "-wrapped list if the text has substructure of its own, i.e., font changes \
and so forth. Thus, we need a definition for both cases."
}], "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell["\<\
transform[Cell[contents_String,\"Text\"]]:= \
XMLElement[\"p\",{},{contents}];
transform[Cell[TextData[contents_List],\"Text\"]]:= \
XMLElement[\"p\",{},transform/@contents];\
\>", "Input",
  CellLabel->"In[79]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell["\<\
Simple strings should just be passed on as is. Once again, this \
perhaps should be placed later in the sequence of definitions, in keeping \
with a top-down style, but it helps make the intermediate results more \
meaningful.\
\>", "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[
    \(\(transform[contents_String] := contents;\)\)], "Input",
  CellLabel->"In[81]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell["Finally, we deal with (simple) font changes.", "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[{
    \(\(transform[StyleBox[contents_String, FontSlant -> "\<Italic\>"]] := 
        XMLElement["\<i\>", {}, {contents}];\)\), "\n", 
    \(\(transform[StyleBox[contents_String, FontWeight -> "\<Bold\>"]] := 
        XMLElement["\<b\>", {}, {contents}];\)\)}], "Input",
  CellLabel->"In[82]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell["Here is the final product.", "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(result = transform[data]\)], "Input",
  CellLabel->"In[84]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[
    \(XMLElement[
      "html", {}, {XMLElement[
          "body", {}, {XMLElement["h1", {}, {"Quotations"}], 
            XMLElement["h2", {}, {"Shakespeare"}], 
            XMLElement[
              "p", {}, {"Now is the winter of our discontent made glorious \
summer by this ", XMLElement["i", {}, {"Son of York"}], 
                ".  And all the clouds that lowered on our house, in the \
Ocean's deep bosum buried."}], 
            XMLElement[
              "p", {}, {"Forgive me, though bleeding piece of earth, that I \
am meek and gentle with these butchers.  Thou art the ruinest of the noblest \
man that ever lived in the tide of time.  Woe to the hands ", 
                XMLElement["b", {}, {"that shed this costy blood"}], 
                "!"}]}]}]\)], "Output",
  CellLabel->"Out[84]=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}]
}, Closed]],

Cell[TextData[{
  "You can get output in a more human-readable form by using ",
  StyleBox["ExportString", "Input",
    FontWeight->"Plain"],
  "."
}], "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[result, "\<XML\>"]\)], "Input",
  CellLabel->"In[86]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[
    \("<html>\n <body>\n  <h1>Quotations</h1>\n  <h2>Shakespeare</h2>\n  \
<p>Now is the winter of our discontent made glorious summer by this <i>Son of \
York</i>.  And all the clouds that lowered on our house, in the Ocean&apos;s \
deep bosum buried.</p>\n  <p>Forgive me, though bleeding piece of earth, that \
I am meek and gentle with these butchers.  Thou art the ruinest of the \
noblest man that ever lived in the tide of time.  Woe to the hands <b>that \
shed this costy blood</b>!</p>\n </body>\n</html>"\)], "Output",
  CellLabel->"Out[379]=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}]
}, Closed]],

Cell["We can verify that this is well-formed XML.", "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SymbolicXMLErrors[result]\)], "Input",
  CellLabel->"In[88]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[88]=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}]
}, Closed]],

Cell["\<\
And, of course, the SymbolicXML can be exported to a file, suitable \
for viewing with a web browser.\
\>", "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<Quotes.html\>", result, "\<XML\>"]\)], "Input",
  CellLabel->"In[89]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[
    \("Quotes.html"\)], "Output",
  CellLabel->"Out[89]=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}]
}, Closed]],

Cell[TextData[{
  "An alternative to a recursive function is to apply a list of replacement \
rules using ",
  StyleBox["ReplaceRepeated", "Input",
    FontWeight->"Plain"],
  "."
}], "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(nb2html = {\[IndentingNewLine]Notebook[
              contents_List, ___] \
-> \[IndentingNewLine]XMLElement["\<html\>", {}, {XMLElement["\<body\>", {}, 
                  contents]}], \[IndentingNewLine]Cell[
              CellGroupData[{contents___}, ___]] -> 
            contents, \[IndentingNewLine]Cell[title_, "\<Title\>"] -> 
            XMLElement["\<h1\>", {}, {title}], \[IndentingNewLine]Cell[
              title_, "\<Section\>"] -> 
            XMLElement["\<h2\>", {}, {title}], \[IndentingNewLine]Cell[
              contents_, "\<Text\>"] -> 
            XMLElement["\<p\>", {}, {contents}], \
\[IndentingNewLine]TextData[{contents___}] -> 
            contents, \[IndentingNewLine]StyleBox[contents_, 
              FontSlant -> "\<Italic\>"] -> 
            XMLElement["\<i\>", {}, {contents}], \[IndentingNewLine]StyleBox[
              contents_, FontWeight -> "\<Bold\>"] -> 
            XMLElement["\<b\>", {}, {contents}]\[IndentingNewLine]};\)\), "\n\
", 
    \(result2 = data //. nb2html\)}], "Input",
  CellLabel->"In[90]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[
    \(XMLElement[
      "html", {}, {XMLElement[
          "body", {}, {XMLElement["h1", {}, {"Quotations"}], 
            XMLElement["h2", {}, {"Shakespeare"}], 
            XMLElement[
              "p", {}, {"Now is the winter of our discontent made glorious \
summer by this ", XMLElement["i", {}, {"Son of York"}], 
                ".  And all the clouds that lowered on our house, in the \
Ocean's deep bosum buried."}], 
            XMLElement[
              "p", {}, {"Forgive me, though bleeding piece of earth, that I \
am meek and gentle with these butchers.  Thou art the ruinest of the noblest \
man that ever lived in the tide of time.  Woe to the hands ", 
                XMLElement["b", {}, {"that shed this costy blood"}], 
                "!"}]}]}]\)], "Output",
  CellLabel->"Out[90]=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}]
}, Closed]],

Cell["The two methods produce identical results.", "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[CellGroupData[{

Cell["result===result2", "Input",
  CellLabel->"In[91]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[91]=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}]
}, Closed]],

Cell["Here is how the two methods differ.", "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[TextData[{
  "Since the recursion occurs implicitly via ",
  StyleBox["ReplaceRepeated", "Input",
    FontWeight->"Plain"],
  ", the latter implementation is cleaner in spots. In particular, contrast \
the handling of ",
  StyleBox["Text", "Input",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  "cells: the ",
  StyleBox["TextData", "Input",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  " rule can be separated from the ",
  StyleBox["Cell", "Input",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  " rule. The same could be accomplished for the recursive function, but at \
the cost of additional patterns for the various forms that ",
  StyleBox["contents", "Input",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  " might take (for example, ",
  StyleBox["_List", "Input",
    FontWeight->"Plain"],
  " versus ",
  StyleBox["_String", "Input",
    FontWeight->"Plain"],
  " and so on). ",
  StyleBox["ReplaceRepeated", "Input",
    FontWeight->"Plain"],
  ", by acting on all subexpressions, obviates this need."
}], "BulletedList",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[TextData[{
  "There is no default rule for the second method. Any unhandled parts of the \
original ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression will pass through unchanged, probably rendering invalid XML."
}], "BulletedList",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[TextData[{
  "Finally, we use ",
  StyleBox["Clear",
    FontFamily->"Courier"],
  " to remove the definitions of all the symbols. "
}], "Text",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],

Cell[BoxData[
    \(\(Clear[nb, data, transform, result, nb2html, result2];\)\)], "Input",
  CellLabel->"In[92]:=",
  CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Verifying SymbolicXML Syntax", "Subsection",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[TextData[{
  "You can use the function ",
  StyleBox["XML`SymbolicXMLErrors",
    FontFamily->"Courier"],
  " to find errors with a SymbolicXML expression. This function returns a \
part specification which you can use with functions like ",
  StyleBox["Part",
    FontFamily->"Courier"],
  " or ",
  StyleBox["Extract",
    FontFamily->"Courier"],
  " to access the problematic part of your SymbolicXML expression. Let us \
return to the American League hitters from our earlier example."
}], "Text",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[BoxData[
    \(\(AL = Import["\<ALHitters.xml\>", "\<SymbolicXML\>"];\)\)], "Input",
  CellLabel->"In[95]:=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[TextData[{
  "We saw above that there were ",
  StyleBox["PlayerRecord",
    FontFamily->"Courier"],
  " nodes for which the ",
  StyleBox["Salary",
    FontFamily->"Courier"],
  " node contained the string \"#N/A\". Suppose we decide that any player \
whose salary is not available to use must be making $1,000,000. However, when \
we do our transformation, we make an easily overlooked mistake."
}], "Text",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[BoxData[
    \(\(AL = 
        AL /. \[IndentingNewLine]XMLElement["\<Salary\>", {}, {"\<#N/A\>"}] \
\[Rule] XMLElement["\<Salary\>", {}, "\<1000000\>"];\)\)], "Input",
  CellLabel->"In[96]:=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[TextData[{
  "We have now created incorrect SymbolicXML. We have put the string \
\"1000000\" as the third element of the ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  " expression, rather than a list containing that string. Suppose we did not \
know this, though, and that later on we find that ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " produces errors when we try to write our modified XML to a file. We can \
use ",
  StyleBox["SymbolicXMLErrors",
    FontFamily->"Courier"],
  " to find the problematic expressions."
}], "Text",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ALerrors = XML`SymbolicXMLErrors[AL]\)], "Input",
  CellLabel->"In[97]:=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[BoxData[
    \({{2, 3, 39, 3, 35}, {2, 3, 69, 3, 35}, {2, 3, 80, 3, 35}, {2, 3, 87, 3, 
        35}, {2, 3, 113, 3, 35}, {2, 3, 118, 3, 35}, {2, 3, 121, 3, 35}, {2, 
        3, 133, 3, 35}, {2, 3, 135, 3, 35}, {2, 3, 142, 3, 35}, {2, 3, 152, 
        3, 35}, {2, 3, 156, 3, 35}, {2, 3, 165, 3, 35}, {2, 3, 172, 3, 
        35}, {2, 3, 173, 3, 35}, {2, 3, 174, 3, 35}, {2, 3, 176, 3, 35}, {2, 
        3, 179, 3, 35}, {2, 3, 181, 3, 35}, {2, 3, 183, 3, 35}, {2, 3, 188, 
        3, 35}, {2, 3, 189, 3, 35}, {2, 3, 191, 3, 35}, {2, 3, 197, 3, 
        35}, {2, 3, 199, 3, 35}, {2, 3, 203, 3, 35}, {2, 3, 204, 3, 35}, {2, 
        3, 207, 3, 35}, {2, 3, 208, 3, 35}, {2, 3, 209, 3, 35}, {2, 3, 210, 
        3, 35}, {2, 3, 212, 3, 35}, {2, 3, 213, 3, 35}, {2, 3, 214, 3, 
        35}, {2, 3, 215, 3, 35}, {2, 3, 216, 3, 35}, {2, 3, 219, 3, 35}, {2, 
        3, 221, 3, 35}, {2, 3, 222, 3, 35}, {2, 3, 224, 3, 35}, {2, 3, 225, 
        3, 35}, {2, 3, 226, 3, 35}, {2, 3, 228, 3, 35}, {2, 3, 231, 3, 
        35}, {2, 3, 235, 3, 35}, {2, 3, 236, 3, 35}, {2, 3, 237, 3, 35}, {2, 
        3, 238, 3, 35}, {2, 3, 240, 3, 35}, {2, 3, 242, 3, 35}, {2, 3, 243, 
        3, 35}, {2, 3, 244, 3, 35}, {2, 3, 245, 3, 35}, {2, 3, 246, 3, 
        35}, {2, 3, 247, 3, 35}, {2, 3, 248, 3, 35}, {2, 3, 249, 3, 35}, {2, 
        3, 250, 3, 35}, {2, 3, 251, 3, 35}, {2, 3, 252, 3, 35}, {2, 3, 253, 
        3, 35}, {2, 3, 254, 3, 35}, {2, 3, 256, 3, 35}, {2, 3, 258, 3, 
        35}, {2, 3, 259, 3, 35}, {2, 3, 261, 3, 35}, {2, 3, 262, 3, 35}, {2, 
        3, 264, 3, 35}, {2, 3, 266, 3, 35}, {2, 3, 267, 3, 35}, {2, 3, 268, 
        3, 35}, {2, 3, 269, 3, 35}, {2, 3, 271, 3, 35}, {2, 3, 272, 3, 
        35}, {2, 3, 273, 3, 35}, {2, 3, 275, 3, 35}, {2, 3, 279, 3, 35}, {2, 
        3, 281, 3, 35}, {2, 3, 283, 3, 35}, {2, 3, 284, 3, 35}, {2, 3, 286, 
        3, 35}, {2, 3, 287, 3, 35}, {2, 3, 288, 3, 35}, {2, 3, 289, 3, 
        35}, {2, 3, 291, 3, 35}, {2, 3, 292, 3, 35}, {2, 3, 293, 3, 35}, {2, 
        3, 294, 3, 35}}\)], "Output",
  CellLabel->"Out[97]=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}]
}, Closed]],

Cell[TextData[{
  "Notice that we first received ",
  StyleBox["XMLElement::name",
    FontFamily->"Courier"],
  " messages. These are our first indication that something is wrong, and we \
would have received these messages with just about any other function that \
processes SymbolicXML. The output of ",
  StyleBox["SymbolicXMLErrors",
    FontFamily->"Courier"],
  ", however, tells us exactly where something went wrong. ",
  StyleBox["ALerrors",
    FontFamily->"Courier"],
  " now contains a list of part specifications where the errors occurred. \
Here we examine the first error."
}], "Text",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(First[ALerrors]\)], "Input",
  CellLabel->"In[98]:=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[BoxData[
    \({2, 3, 39, 3, 35}\)], "Output",
  CellLabel->"Out[410]=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[AL, Sequence @@ First[ALerrors]]\)], "Input",
  CellLabel->"In[99]:=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[BoxData[
    \(XMLElement["Salary", {}, "1000000"]\)], "Output",
  CellLabel->"Out[99]=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Cases[FoldList[Part, AL, First[ALerrors]], 
      XMLElement[s_, __] \[Rule] s]\)], "Input",
  CellLabel->"In[100]:=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[BoxData[
    \({"AmericanLeagueIndividualHitters", "PlayerRecord", 
      "Salary"}\)], "Output",
  CellLabel->"Out[100]=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}]
}, Closed]],

Cell["This problem is easy enough to fix.", "Text",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Part[AL, 
        Sequence @@ First[ALerrors]] = \[IndentingNewLine]Part[AL, 
          Sequence @@ 
            First[ALerrors]] /. \[IndentingNewLine]XMLElement["\<Salary\>", 
            p_, s_String] \[Rule] XMLElement["\<Salary\>", p, {s}]\)], "Input",\

  CellLabel->"In[101]:=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[BoxData[
    \(XMLElement["Salary", {}, {"1000000"}]\)], "Output",
  CellLabel->"Out[101]=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}]
}, Closed]],

Cell["\<\
We can see that the rest of the errors are of the same \
nature.\
\>", "Text",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Extract[AL, Rest[ALerrors]]\)], "Input",
  CellLabel->"In[102]:=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[BoxData[
    \({XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"], 
      XMLElement["Salary", {}, "1000000"]}\)], "Output",
  CellLabel->"Out[102]=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}]
}, Closed]],

Cell[TextData[{
  StyleBox["By using ",
    FontFamily->"Times New Roman"],
  StyleBox["Map",
    FontFamily->"Courier"],
  ", we can fix the rest of the errors in the same way."
}], "Text",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Map[\((Part[AL, Sequence @@ #] = 
            Part[AL, 
                Sequence @@ #] /. \[IndentingNewLine]XMLElement["\<Salary\>", 
                  p_, s_String] \[Rule] 
                XMLElement["\<Salary\>", 
                  p, {s}])\) &, \[IndentingNewLine]ALerrors]\)], "Input",
  CellLabel->"In[103]:=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[BoxData[
    \({XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}], 
      XMLElement["Salary", {}, {"1000000"}]}\)], "Output",
  CellLabel->"Out[103]=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}]
}, Closed]],

Cell[TextData[{
  "We can then verify that we have fixed our mistake using ",
  StyleBox["SymbolicXMLErrors",
    FontFamily->"Courier"],
  " again."
}], "Text",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`SymbolicXMLErrors[AL]\)], "Input",
  CellLabel->"In[104]:=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[104]=",
  CellTags->{"VerifyingSym", "i:48", "b:2.6"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["4. Exporting XML", "Section",
  PageBreakAbove->True],

Cell[CellGroupData[{

Cell["Functions for Exporting XML", "Subsection",
  CellTags->"b:3.0"],

Cell[CellGroupData[{

Cell["Export", "Subsubsection",
  FontFamily->"Courier",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[TextData[{
  "You can export XML data from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using the standard ",
  ButtonBox["Export",
    ButtonStyle->"RefGuideLink"],
  " function."
}], "Text",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[TextData[{
  StyleBox["\tExport[",
    FontFamily->"Courier"],
  StyleBox["file",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["expr",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[TextData[{
  StyleBox["\tExport[",
    FontFamily->"Courier"],
  StyleBox["file",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["expr",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["format",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[TextData[{
  "The first argument of the function specifies the file to which the data \
should be exported. The second argument specifies the data to be exported. \
For exporting XML data, this can be a SymbolicXML expression or any other ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression. You can also specify an optional third argument to control \
the form of the output. For exporting XML data, the relevant file formats are \
",
  StyleBox["\"XML\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"NotebookML\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"ExpressionML\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"MathML\"",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\"SVG\"",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[TextData[{
  "With ",
  StyleBox["\"XML\"", "MR"],
  " as the export format, all expressions are imported as NotebookML or \
ExpressionML."
}], "Text",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<test.xml\>", x^2, "\<XML\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[BoxData[
    \("test.xml"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! test.xml\)\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell["\<\
<?xml version='1.0'?>
<!DOCTYPE Expression SYSTEM 'http://www.wolfram.com/XML/notebookml1.dtd'>
<Expression xmlns:mathematica='http://www.wolfram.com/XML/'
    xmlns='http://www.wolfram.com/XML/'>
 <Function>
  <Symbol>Power</Symbol>
  <Symbol>x</Symbol>
  <Number>2</Number>
 </Function>
</Expression>\
\>", "Print",
  CellLabel->"From In[2]:=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}]
}, Closed]],

Cell[TextData[{
  "With ",
  StyleBox["\"MathML\"",
    FontFamily->"Courier"],
  " specified as the export format, the same expression is written out as \
MathML."
}], "Text",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<test.mml\>", x^2, "\<MathML\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[BoxData[
    \("test.mml"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! test.mml\)\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell["\<\
<math xmlns='http://www.w3.org/1998/Math/MathML'>
 <semantics>
  <msup>
   <mi>x</mi>
   <mn>2</mn>
  </msup>
  <annotation-xml encoding='MathML-Content'>
   <apply>
    <power/>
    <ci>x</ci>
    <cn type='integer'>2</cn>
   </apply>
  </annotation-xml>
 </semantics>
</math>\
\>", "Print",
  CellLabel->"From In[4]:=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}]
}, Closed]],

Cell[TextData[{
  "If ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " is used with only two arguments, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " determines the export format based on the filename extension. The ",
  StyleBox["\".xml\"",
    FontFamily->"Courier"],
  " extension is associated with XML. Hence, ",
  StyleBox["Export[",
    FontFamily->"Courier"],
  StyleBox["filename",
    FontSlant->"Italic"],
  StyleBox[".xml,",
    FontFamily->"Courier"],
  " ",
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " is equivalent to ",
  StyleBox["Export[",
    FontFamily->"Courier"],
  StyleBox["filename",
    FontSlant->"Italic"],
  StyleBox[".xml,",
    FontFamily->"Courier"],
  " ",
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"XML\"]",
    FontFamily->"Courier"],
  ", as seen in the example below."
}], "Text",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<test.xml\>", x^2]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[BoxData[
    \("test.xml"\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! test.xml\)\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell["\<\
<?xml version='1.0'?>
<!DOCTYPE Expression SYSTEM 'http://www.wolfram.com/XML/notebookml1.dtd'>
<Expression xmlns:mathematica='http://www.wolfram.com/XML/'
    xmlns='http://www.wolfram.com/XML/'>
 <Function>
  <Symbol>Power</Symbol>
  <Symbol>x</Symbol>
  <Number>2</Number>
 </Function>
</Expression>\
\>", "Print",
  CellLabel->"From In[6]:=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}]
}, Closed]],

Cell[TextData[{
  "The ",
  StyleBox[".mml",
    FontFamily->"Courier"],
  " extension is associated with MathML. Hence, ",
  StyleBox["Export[",
    FontFamily->"Courier"],
  StyleBox["filename",
    FontSlant->"Italic"],
  StyleBox[".mml,",
    FontFamily->"Courier"],
  " ",
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " is equivalent to ",
  StyleBox["Export[",
    FontFamily->"Courier"],
  StyleBox["filename",
    FontSlant->"Italic"],
  StyleBox[".mml,",
    FontFamily->"Courier"],
  " ",
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"MathML\"]",
    FontFamily->"Courier"],
  ", as seen in the example below."
}], "Text",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<test.mml\>", x^2]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[BoxData[
    \("test.mml"\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! test.mml\)\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell["\<\
<math xmlns='http://www.w3.org/1998/Math/MathML'>
 <semantics>
  <msup>
   <mi>x</mi>
   <mn>2</mn>
  </msup>
  <annotation-xml encoding='MathML-Content'>
   <apply>
    <power/>
    <ci>x</ci>
    <cn type='integer'>2</cn>
   </apply>
  </annotation-xml>
 </semantics>
</math>\
\>", "Print",
  CellLabel->"From In[8]:=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}]
}, Closed]],

Cell[TextData[{
  "You can control the various details of the export process using the ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " feature of the ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " function. For more information,",
  StyleBox[" see",
    FontFamily->"Times New Roman"],
  " ",
  ButtonBox["XML Export Conversion Options",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell["\<\
The following commands delete the test files \"test.xml\" and \
\"test.mml\" created by evaluating the commands in this section.\
\>", "Text",\

  CellTags->{"UsingExport", "i:49", "b:3.0"}],

Cell[BoxData[{
    \(\(DeleteFile[{ToFileName[{Directory[]}, "\<test.xml\>"]}];\)\), "\
\[IndentingNewLine]", 
    \(DeleteFile[{ToFileName[{Directory[]}, "\<test.mml\>"]}]\)}], "Input",
  CellLabel->"In[9]:=",
  CellTags->{"UsingExport", "i:49", "b:3.0"}]
}, Closed]],

Cell[CellGroupData[{

Cell["ExportString", "Subsubsection",
  FontFamily->"Courier",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}],

Cell[TextData[{
  "You can convert ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions into XML strings using the ",
  ButtonBox["ExportString",
    ButtonStyle->"RefGuideLink"],
  " function. This function has the following syntax."
}], "Text",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}],

Cell[TextData[{
  StyleBox["\tExportString[",
    FontFamily->"Courier"],
  StyleBox["expr",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["format",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}],

Cell[TextData[{
  "For exporting as XML, the relevant formats are ",
  StyleBox["\"XML\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"NotebookML\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"ExpressionML\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"MathML\"",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\"SVG\"",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}],

Cell["This command produces a SymbolicXML expression.", "Text",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString["\<<root><child/></root>\>", "\<SymbolicXML\>"]\)], "Input",\

  CellLabel->"In[11]:=",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement["root", {}, {XMLElement["child", {}, {}]}], {}]\)], "Output",\

  CellLabel->"Out[11]=",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}]
}, Closed]],

Cell[TextData[{
  "If the SymbolicXML expression is supplied as the first argument of ",
  StyleBox["ExportString",
    FontFamily->"Courier"],
  ", the resulting output is ordinary XML."
}], "Text",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[%, "\<XML\>"]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}],

Cell[BoxData[
    \("<root>\n <child/>\n</root>"\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}]
}, Closed]],

Cell["\<\
If the first argument is some other type of expression, the output \
is in the form of ExpressionML.\
\>", "Text",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString["\<some text\>", "\<XML\>"]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}],

Cell[BoxData[
    \("<?xml version='1.0'?>\n<!DOCTYPE Expression SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\n<Expression \
xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <String>some text</String>\n\
</Expression>"\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}]
}, Closed]],

Cell[TextData[{
  "You can control various details of the export process using the ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " feature of the ",
  StyleBox["ExportString",
    FontFamily->"Courier"],
  " function. For more information,",
  StyleBox[" see",
    FontFamily->"Times New Roman"],
  " ",
  ButtonBox["XML Export Conversion Options",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->{"UsingExportString", "i:50", "b:3.0"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Conversion Options", "Subsection",
  CellTags->"b:3.1"],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
  CellTags->{"ExportConvOptIntro", "i:51", "b:3.1"}],

Cell[TextData[{
  "The standard ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " feature of the ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " or ",
  StyleBox["ExportString",
    FontFamily->"Courier"],
  " functions can be used for greater control over the export process. The \
syntax for specifying a conversion option is as follows. "
}], "Text",
  CellTags->{"ExportConvOptIntro", "i:51", "b:3.1"}],

Cell[TextData[{
  StyleBox["Export[",
    FontFamily->"Courier"],
  StyleBox["file",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["expr",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["format",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["ConversionOptions \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["option1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["option2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ...}]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"ExportConvOptIntro", "i:51", "b:3.1"}],

Cell[TextData[{
  StyleBox["ExportString[",
    FontFamily->"Courier"],
  StyleBox["expr",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["format",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["ConversionOptions \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["option1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["option2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ...}]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"ExportConvOptIntro", "i:51", "b:3.1"}],

Cell["\<\
There are seven conversion options which are applicable to \
exporting XML data.\
\>", "Text",
  CellTags->{"ExportConvOptIntro", "i:51", "b:3.1"}],

Cell[TextData[{
  "\"",
  StyleBox["Annotations",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"ExportConvOptIntro", "i:51", "b:3.1"}],

Cell[TextData[{
  "\"",
  StyleBox["AttributeQuoting",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"ExportConvOptIntro", "i:51", "b:3.1"}],

Cell[TextData[{
  "\"",
  StyleBox["CheckXML",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"ExportConvOptIntro", "i:51", "b:3.1"}],

Cell[TextData[{
  "\"",
  StyleBox["ElementFormatting",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"ExportConvOptIntro", "i:51", "b:3.1"}],

Cell[TextData[{
  "\"",
  StyleBox["Entities",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"ExportConvOptIntro", "i:51", "b:3.1"}],

Cell[TextData[{
  "\"",
  StyleBox["NamespacePrefixes",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"ExportConvOptIntro", "i:51", "b:3.1"}],

Cell[TextData[{
  "\"",
  StyleBox["PrefixCreation",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"ExportConvOptIntro", "i:51", "b:3.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Annotations\"", "Subsubsection",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[TextData[{
  "This conversion option controls which annotations are added to the output \
XML. The value of this option is a list whose elements can be any combination \
of the following: \"",
  StyleBox["DocumentHeader\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"XMLDeclaration\"",
    FontFamily->"Courier"],
  ", or ",
  StyleBox["\"DOCTYPEDeclaration\"",
    FontFamily->"Courier"],
  ". The order of the elements in the list is irrelevant. "
}], "Text",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[TextData[StyleBox["\"XMLDeclaration\"", "MB"]], "Subsubsubsection",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[TextData[{
  "When ",
  StyleBox["\"XMLDeclaration\"",
    FontFamily->"Courier"],
  " is one of the annotations, then an XML declaration is included in the \
header. That is, the statement ",
  StyleBox["<?xml version=\"1.0\"?>",
    FontFamily->"Courier"],
  " appears in the header."
}], "Text",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      x, "\<XML\>", \[IndentingNewLine]ConversionOptions \[Rule] \
{"\<Annotations\>"\  \[Rule] {"\<DocumentHeader\>", \
"\<XMLDeclaration\>"}}]\)], "Input",
  CellLabel->"In[35]:=",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[BoxData[
    \("<?xml version='1.0'?>\n<Expression \
xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <Symbol>x</Symbol>\n</Expression>"\)], \
"Output",
  CellLabel->"Out[35]=",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}]
}, Closed]],

Cell[TextData[StyleBox["\"DOCTYPEDeclaration\"", "MB"]], "Subsubsubsection",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[TextData[{
  "When ",
  StyleBox["\"DOCTYPEDeclaration\"",
    FontFamily->"Courier"],
  " is one of the annotations, then an XML document type declaration of the \
form ",
  StyleBox["\"<!DOCTYPE ... >\"",
    FontFamily->"Courier"],
  " appears in the header. This is a statement that specifies the DTD for the \
XML application in which the output is written.  "
}], "Text",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      x, "\<XML\>", \[IndentingNewLine]ConversionOptions \[Rule] \
{"\<Annotations\>"\  \[Rule] {"\<DocumentHeader\>", \
"\<DOCTYPEDeclaration\>"}}]\)], "Input",
  CellLabel->"In[36]:=",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[BoxData[
    \("<!DOCTYPE Expression SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\n<Expression \
xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <Symbol>x</Symbol>\n</Expression>"\)], \
"Output",
  CellLabel->"Out[36]=",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}]
}, Closed]],

Cell[TextData[StyleBox["\"DocumentHeader\"", "MB"]], "Subsubsubsection",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[TextData[{
  "With the setting, ",
  StyleBox["\"Annotations\"",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["{\"DocumentHeader\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"XMLDeclaration\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"DOCTYPEDeclaration\"}",
    FontFamily->"Courier"],
  ", a header containing an XML declaration and a document type declaration \
for the DTD are automatically added to the output. "
}], "Text",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      x, "\<XML\>", \[IndentingNewLine]ConversionOptions \[Rule] \
{"\<Annotations\>"\  \[Rule] {"\<DocumentHeader\>", "\<XMLDeclaration\>", \
"\<DOCTYPEDeclaration\>"}}]\)], "Input",
  CellLabel->"In[37]:=",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[BoxData[
    \("<?xml version='1.0'?>\n<!DOCTYPE Expression SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\n<Expression \
xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <Symbol>x</Symbol>\n</Expression>"\)], \
"Output",
  CellLabel->"Out[37]=",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}]
}, Closed]],

Cell[TextData[{
  "When ",
  StyleBox["\"Annotations\"",
    FontFamily->"Courier"],
  " does not contain ",
  StyleBox["\"DocumentHeader\"",
    FontFamily->"Courier"],
  ", then the output has no header. This is true even if the ",
  StyleBox["\"Annotations\"",
    FontFamily->"Courier"],
  " contains other elements such as ",
  StyleBox["\"XMLDeclaration\"",
    FontFamily->"Courier"],
  " or ",
  StyleBox["\"DOCTYPEDeclaration\"",
    FontFamily->"Courier"],
  ". Thus ",
  StyleBox["\"DocumentHeader\"",
    FontFamily->"Courier"],
  " is an overall switch that controls whether the structure has a header or \
not."
}], "Text",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      x, "\<XML\>", \[IndentingNewLine]ConversionOptions \[Rule] \
{"\<Annotations\>"\  \[Rule] {"\<XMLDeclaration\>", \
"\<DOCTYPEDeclaration\>"}}]\)], "Input",
  CellLabel->"In[38]:=",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[BoxData[
    \("<Expression xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <Symbol>x</Symbol>\n</Expression>"\)], \
"Output",
  CellLabel->"Out[38]=",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}]
}, Closed]],

Cell[TextData[{
  "The ",
  StyleBox["\"Annotations\" \[Rule] \"DocumentHeader\"",
    FontFamily->"Courier"],
  " is useful for controlling the form of SymbolicXML generated. For \
instance, you can explicitly add an ",
  StyleBox["XMLElement[Document]",
    FontFamily->"Courier"],
  " to the SymbolicXML output, as shown below ."
}], "Text",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`ExpressionToSymbolicMathML[
      x + 2, "\<Annotations\>"\  \[Rule] {"\<DocumentHeader\>"}, \ "\<Formats\
\>" -> "\<PresentationMathML\>"]\)], "Input",
  CellLabel->"In[39]:=",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "math", {"xmlns" \[Rule] 
            "http://www.w3.org/1998/Math/MathML"}, {XMLElement[
            "mrow", {}, {XMLElement["mi", {}, {"x"}], 
              XMLElement["mo", {}, {"+"}], 
              XMLElement["mn", {}, {"2"}]}]}], {}]\)], "Output",
  CellLabel->"Out[39]=",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}]
}, Closed]],

Cell[TextData[{
  "Here, ",
  StyleBox["\"Annotations\" \[Rule] {\"DocumentHeader\"}",
    FontFamily->"Courier"],
  " is not specified so the ",
  StyleBox["XMLElement[Document]",
    FontFamily->"Courier"],
  " is omitted from the output."
}], "Text",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`ExpressionToSymbolicMathML[
      x + 2, \ "\<Formats\>" -> "\<PresentationMathML\>"]\)], "Input",
  CellLabel->"In[40]:=",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}],

Cell[BoxData[
    \(XMLElement[
      "math", {"xmlns" \[Rule] 
          "http://www.w3.org/1998/Math/MathML"}, {XMLElement[
          "mrow", {}, {XMLElement["mi", {}, {"x"}], 
            XMLElement["mo", {}, {"+"}], 
            XMLElement["mn", {}, {"2"}]}]}]\)], "Output",
  CellLabel->"Out[40]=",
  CellTags->{"SymbXMLAnnotations", "i:52", "b:3.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"AttributeQuoting\"", "Subsubsection",
  CellTags->{"AttributeQuoting", "i:53", "b:3.1"}],

Cell["\<\
This conversion option determines whether attribute values are \
enclosed by single quotes or double quotes. \
\>", "Text",
  CellTags->{"AttributeQuoting", "i:53", "b:3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<AttributeQuoting\>\"",
              FontFamily->"Courier"], 
            StyleBox["'",
              
              FontFamily->
                "Courier"], \(attribute\ values\ are\ enclosed\ by\ single\ \
quotes\)},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["\\\"",
              
              FontFamily->
                "Courier"], \(attribute\ values\ are\ enclosed\ by\ double\ \
quotes\)}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"AttributeQuoting", "i:53", "b:3.1"}],

Cell["The option \"AttributeQuoting\" and its possible values.", "Caption",
  CellTags->{"AttributeQuoting", "i:53", "b:3.1"}],

Cell[TextData[{
  "With the default setting, ",
  StyleBox["\"AttributeQuoting\" \[Rule] \"'\"",
    FontFamily->"Courier"],
  ", attribute values are enclosed in single quotes. This ensures that there \
is no conflict with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " strings, which are typically enclosed in double quotes. "
}], "Text",
  CellTags->{"AttributeQuoting", "i:53", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      XMLElement["\<foo\>", {"\<color\>" \[Rule] "\<blue\>"}, {"\<some \
data\>"}], "\<XML\>", 
      ConversionOptions \[Rule] {"\<AttributeQuoting\>" \[Rule] "\<'\>"}]\)], \
"Input",
  CellLabel->"In[1]:=",
  CellTags->{"AttributeQuoting", "i:53", "b:3.1"}],

Cell[BoxData[
    \("<foo color='blue'>some data</foo>"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"AttributeQuoting", "i:53", "b:3.1"}]
}, Closed]],

Cell[TextData[{
  "For certain applications, you might prefer attribute values to be enclosed \
in double quotes. This can be done by setting ",
  StyleBox["\"AttributeQuoting\" \[Rule] \"\\\"\"",
    FontFamily->"Courier"],
  ". Note that the double-quote character must be preceded by a forward slash \
to escape it. "
}], "Text",
  CellTags->{"AttributeQuoting", "i:53", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      XMLElement["\<foo\>", {"\<color\>" \[Rule] "\<blue\>"}, {"\<some \
data\>"}], "\<XML\>", 
      ConversionOptions \[Rule] {"\<AttributeQuoting\>" \[Rule] \
"\<\"\>"}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"AttributeQuoting", "i:53", "b:3.1"}],

Cell[BoxData[
    \("<foo color=\"blue\">some data</foo>"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"AttributeQuoting", "i:53", "b:3.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"CheckXML\"", "Subsubsection",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[TextData[{
  "This conversion option determines whether the SymbolicXML expression being \
exported is first checked for errors. By default this option is set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  ". "
}], "Text",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<CheckXML\>\"",
              FontFamily->"Courier"], 
            StyleBox["True",
              
              FontFamily->
                "Courier"], \(the\ file\ being\ exported\ is\ checked\ for\ \
errors\)},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              
              FontFamily->
                "Courier"], \(the\ file\ being\ exported\ is\ not\ checked\ \
for\ errors\)}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell["The option \"CheckXML\" and its possible values.", "Caption",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[TextData[{
  "You can set this option to ",
  StyleBox["False",
    FontFamily->"Courier"],
  " if you are confident that the SymbolicXML is correct, because checking \
the XML for errors can cause processing delays. The following example shows \
the delay produced by checking a small file for errors."
}], "Text",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[BoxData[
    \(\(largeSymbolicXML = 
        Import["\<test.xml\>", "\<SymbolicXML\>"];\)\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[\(Export["\<myFile\>", 
          largeSymbolicXML, "\<XML\>"];\)]\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[BoxData[
    \({16.083333333333332`\ Second, Null}\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[\(Export["\<myFile\>", largeSymbolicXML, "\<XML\>", 
          ConversionOptions \[Rule] {"\<CheckXML\>" \[Rule] 
                False}];\)]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[BoxData[
    \({13.766666666666666`\ Second, Null}\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}]
}, Closed]],

Cell["\<\
The error checking provided by this option can be quite useful, \
since a small error may completely ruin the exported form of a large \
SymbolicXML expression. With the option on, small errors can often be fixed. \
Here the SymbolicXML has an error, but it is fixed to give a reasonable \
result.\
\>", "Text",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<myFile\>", XMLElement["\<foo\>"], "\<XML\>"]\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[BoxData[
    \(XMLElement::"argrx" \(\(:\)\(\ \)\) 
      "\!\(XMLElement\) called with \!\(1\) arguments; \!\(3\) arguments are \
expected."\)], "Message",
  CellLabel->"From In[17]:=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[BoxData[
    \(Export::"autoFix" \(\(:\)\(\ \)\) 
      "There is an error in the SymbolicXML expression begin exported. An \
automated attempt has been made to fix the error, however the fix may yield \
XML different to that desired.  The function XML`SymbolicXMLErrors will \
detail the errors in the SymbolicXML expression."\)], "Message",
  CellLabel->"From In[17]:=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[BoxData[
    \("myFile"\)], "Output",
  CellLabel->"Out[17]=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! myFile\)\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell["<foo/>", "Print",
  CellLabel->"From In[18]:=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}]
}, Closed]],

Cell[TextData[{
  "On the other hand, with ",
  StyleBox["\"CheckXML\"",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", nothing is output to the file."
}], "Text",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<myFile\>", XMLElement["\<foo\>"], "\<XML\>", 
      ConversionOptions \[Rule] {"\<CheckXML\>" \[Rule] False}]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[BoxData[
    \(Export::"unrecov" \(\(:\)\(\ \)\) 
      "An unrecoverable error occurred while exporting the SymbolicXML."\)], \
"Message",
  CellLabel->"From In[19]:=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}],

Cell[BoxData[
    \($Failed\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->{"CheckXML", "i:54", "b:3.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"ElementFormatting\"", "Subsubsection",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[TextData[{
  "This conversion option controls how elements are indented in the XML \
file.",
  StyleBox[" Possible values of the option are ",
    FontFamily->"Times New Roman",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["All",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[", ",
    FontFamily->"Times New Roman",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["None",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[", ",
    FontFamily->"Times New Roman",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Automatic",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[", or a user-defined function. The default value is ",
    FontFamily->"Times New Roman",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Automatic",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[". ",
    FontFamily->"Times New Roman",
    FontVariations->{"CompatibilityType"->0}]
}], "Text",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<ElementFormatting\>\"",
              FontFamily->"Courier"], 
            StyleBox["All",
              FontFamily->"Courier"], 
            RowBox[{
              StyleBox["all",
                FontFamily->"Times New Roman",
                FontVariations->{"CompatibilityType"->0}], 
              StyleBox[" ",
                FontFamily->"Times New Roman",
                FontVariations->{"CompatibilityType"->0}], 
              StyleBox["child",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["nodes",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["of",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["an",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["element",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["are",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["indented",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["and",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["long",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["lines",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["are",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["wrapped",
                FontFamily->"Times New Roman"]}]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["None",
              FontFamily->"Courier"], \(no\ extra\ indentation\ is\ added\)},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["Automatic",
              FontFamily->"Courier"], 
            RowBox[{
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["ele",
                      FontFamily->"Times New Roman",
                      FontVariations->{"CompatibilityType"->0}], 
                    StyleBox["m",
                      FontVariations->{"CompatibilityType"->0}], "ents"}]], 
                " ", "with", " ", "mixed", " ", "content", " ", "are", " ", 
                "not", " ", "indented"}], 
              ",", \(while\ elements\ with\ element\[Hyphen]only\ content\ \
are\ \(\(indented\)\(.\)\)\)}]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["fn",
              FontSlant->"Italic"], \(a\ user\[Hyphen]defined\ function\)}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell["The option \"ElementFormatting\" and its possible values.", "Caption",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[TextData[{
  "The following example shows the result of using ",
  StyleBox["\"ElementFormatting\"", "Input",
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ", "Input",
    FontFamily->"Times New Roman",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "\[Rule]",
  StyleBox[" ", "Input",
    FontFamily->"Times New Roman",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["All", "Input",
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[".",
    FontFamily->"Times New Roman"]
}], "Text",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      XMLElement["\<root\>", {}, {"\<a\>", 
          XMLElement["\<child\>", {}, {}], "\<b\>"}], "\<XML\>", 
      ConversionOptions \[Rule] {"\<ElementFormatting\>" \[Rule] 
            All}]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[BoxData[
    \("<root>\n a\n <child/>\n b\n</root>"\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      XMLElement["\<p\>", {}, {"\<This is a long paragraph. It is made of \
several sentences. It keeps going and going. It doesn't look very nice on one \
long line, but if its indented, its much easier to read.\>"}], "\<XML\>", 
      ConversionOptions \[Rule] {"\<ElementFormatting\>" \[Rule] 
            All}]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[BoxData[
    \("<p>\n This is a long paragraph. It is made of several\n sentences. It \
keeps going and going. It doesn&apos;t\n look very nice on one long line, but \
if its\n indented, its much easier to read.\n</p>"\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}]
}, Closed]],

Cell[TextData[{
  "With ",
  StyleBox["\"ElementFormatting\"", "Input",
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ", "Input",
    FontFamily->"Times New Roman",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  "\[Rule]",
  StyleBox[" ", "Input",
    FontFamily->"Times New Roman",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["None",
    FontFamily->"Courier"],
  ", no extra indentation is added."
}], "Text",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      XMLElement["\<root\>", {}, {"\<a\>", 
          XMLElement["\<child\>", {}, {}], "\<b\>"}], "\<XML\>", 
      ConversionOptions \[Rule] {"\<ElementFormatting\>" \[Rule] 
            None}]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[BoxData[
    \("<root>a<child/>b</root>"\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}]
}, Closed]],

Cell[TextData[{
  "W",
  StyleBox["ith",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ",
    FontFamily->"Times New Roman",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\"ElementFormatting\"", "Input",
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ", "Input",
    FontFamily->"Times New Roman",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\[Rule]",
    FontFamily->"Times New Roman",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ", "Input",
    FontFamily->"Times New Roman",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Automatic", "Input",
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[", ele",
    FontFamily->"Times New Roman",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["m",
    FontVariations->{"CompatibilityType"->0}],
  "ents with mixed content (strings as content) are not indented, while \
elements with element-only content are indented."
}], "Text",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      XMLElement["\<element-only\>", {}, {XMLElement["\<empty\>", {}, {}], 
          XMLElement["\<string-only\>", {}, {"\<a string\>"}], 
          XMLElement["\<mixed\>", {}, {"\<a\>", 
              XMLElement["\<empty\>", {}, {}], "\<b\>"}], 
          XMLElement["\<element-only\>", {}, {XMLElement["\<empty\>", {}, \
{}]}]}], "\<XML\>"]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[BoxData[
    \("<element-only>\n <empty/>\n <string-only>a string</string-only>\n \
<mixed>a<empty/>b</mixed>\n <element-only>\n  <empty/>\n </element-only>\n\
</element-only>"\)], "Output",
  CellLabel->"Out[23]=",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}]
}, Closed]],

Cell[TextData[{
  "We saw that with ",
  StyleBox["\"ElementFormatting\"", "Input",
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ", "Input",
    FontFamily->"Times New Roman",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\[Rule]",
    FontFamily->"Times New Roman",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ", "Input",
    FontFamily->"Times New Roman",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["All",
    FontFamily->"Courier"],
  ", long strings are linewrapped. This can be used to produce output similar \
to HTML. On the other hand, ",
  StyleBox["ElementFormatting",
    FontFamily->"Courier"],
  " ",
  StyleBox["\[Rule]",
    FontFamily->"Times New Roman",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" ", "Input",
    FontFamily->"Times New Roman",
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Automatic",
    FontFamily->"Courier"],
  " produces one long line of text."
}], "Text",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      XMLElement["\<p\>", {}, {"\<This is a long paragraph. It is made of \
several sentences. It keeps going and going. It doesn't look very nice on one \
long line, but if its indented, its much easier to read.\>"}], "\<XML\>"]\)], \
"Input",
  CellLabel->"In[24]:=",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[BoxData[
    \("<p>This is a long paragraph. It is made of several sentences. It keeps \
going and going. It doesn&apos;t look very nice on one long line, but if its \
indented, its much easier to read.</p>"\)], "Output",
  CellLabel->"Out[24]=",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}]
}, Closed]],

Cell[TextData[{
  "Advanced users can also specify a function to determine the formatting. \
The function is passed a two-element list, ",
  StyleBox["{namespace, localName}", "Input"],
  ". The function should return ",
  StyleBox["True",
    FontFamily->"Courier"],
  " when indenting is wanted, ",
  StyleBox["False",
    FontFamily->"Courier"],
  " when no indenting is wanted, and ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  " for cases where the element-only content should be indented and mixed \
content should not be indented."
}], "Text",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[BoxData[{
    \(\(myIndentFunction[{"\<\>", "\<indent\>"}] := 
        True;\)\), "\[IndentingNewLine]", 
    \(\(myIndentFunction[{"\<\>", "\<noIndent\>"}] := 
        False;\)\), "\[IndentingNewLine]", 
    \(\(myIndentFunction[{"\<\>", "\<autoIndent\>"}] := 
        Automatic;\)\)}], "Input",
  CellLabel->"In[25]:=",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      XMLElement["\<indent\>", {}, {XMLElement["\<noIndent\>", {}, \
{XMLElement["\<indent\>", {}, {}]}], 
          XMLElement["\<autoIndent\>", {}, {XMLElement["\<autoIndent\>", {}, \
{"\<foo\>"}]}]}], "\<XML\>", 
      ConversionOptions \[Rule] {"\<ElementFormatting\>" \[Rule] 
            myIndentFunction}]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}],

Cell[BoxData[
    \("<indent>\n <noIndent><indent/></noIndent>\n <autoIndent>\n  \
<autoIndent>foo</autoIndent>\n </autoIndent>\n</indent>"\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->{"ElementFormatting", "i:55", "b:3.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Entities\"", "Subsubsection",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell[TextData[{
  "When exporting XML documents, it is sometimes desirable to display \
represent special characters using named character entities. The ",
  StyleBox["\"Entities\"",
    FontFamily->"Courier"],
  " conversion option supports output of these named character entities. "
}], "Text",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<Entities\>\"",
              FontFamily->"Courier"], "\"\<\!\(\*
StyleBox[\"HTML\",\nFontFamily->\"Courier\"]\)\!\(\*
StyleBox[\"\\\"\<\>\",\nFontFamily->\"Courier\"]\)\>", \(resolves\ entity\ \
names\ defined\ in\ HTML\)},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["\"\<MathML\>\"",
              
              FontFamily->
                "Courier"], \(resolves\ entity\ names\ defined\ in\ \
MathML\)},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["list",
              
              FontSlant->
                "Italic"], \(a\ list\ of\ character\ replacement\ rules\)}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell["The option \"Entities\" and its possible values.", "Caption",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell["\<\
You can also specify a list of entities as the value of this option \
as a list. For example, if you want to export both HTML and MathML entities, \
you could use the setting: \
\>", "Text",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell["\"Entities\"\[Rule]{\"HTML\", \"MathML\"} ", "Program",
  FontWeight->"Bold",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell[TextData[{
  "If neither the ",
  StyleBox["\"HTML\"",
    FontFamily->"Courier"],
  " or ",
  StyleBox["\"MathML\"",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  "settings are used, all characters are still output correctly in XML. \
However, they may be numeric entities or encoded in UTF-8."
}], "Text",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell[TextData[{
  "Here we use the ",
  StyleBox["\"HTML\"",
    FontFamily->"Courier"],
  " setting to turn an \[Alpha] in the input into the named character entity \
",
  StyleBox["&alpha;",
    FontFamily->"Courier"],
  ". "
}], "Text",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(xmlString = 
      ExportString[XMLElement["\<foo\>", {}, {"\<\[Alpha]\>"}], "\<XML\>", 
        ConversionOptions \[Rule] {"\<Entities\>" -> "\<HTML\>"}]\)], "Input",\

  CellLabel->"In[29]:=",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell[BoxData[
    \("<foo>&alpha;</foo>"\)], "Output",
  CellLabel->"Out[29]=",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}]
}, Closed]],

Cell["\<\
You can also enter your own list of character replacement rules to \
be used. If this used, then you are also responsible for including some basic \
escaping required by XML. For example:\
\>", "Text",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell["\<\
\"Entities\"\[Rule]{
    \"&\"->\"&amp;\",
    \"<\"->\"&lt;\",
    \">\"->\"&gt;\",
    \"\\\"\"->\"&quot;\",
    \"'\"->\"&apos;\",
    \"h\"->\"&lowerCaseH;\"
    }\
\>", "Program",
  FontWeight->"Bold",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell[TextData[{
  "If you specify any value for ",
  StyleBox["Entities",
    FontFamily->"Courier"],
  ", it is your responsibility to ensure that appropriate entity declarations \
are present. For example, by using the ",
  StyleBox["\"HTML\"",
    FontFamily->"Courier"],
  " setting, you can easily generate XML with HTML entities. In this example, \
the Icelandic character \"thorn\" is exported as the corresponding character \
entity reference."
}], "Text",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(xmlString = 
      ExportString[XMLElement["\<foo\>", {}, {"\<\[Thorn]\>"}], "\<XML\>", 
        ConversionOptions \[Rule] {"\<Entities\>" -> "\<HTML\>"}]\)], "Input",\

  CellLabel->"In[31]:=",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell[BoxData[
    \("<foo>&thorn;</foo>"\)], "Output",
  CellLabel->"Out[31]=",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}]
}, Closed]],

Cell["\<\
But in this document, the entity is not declared and the literal \
output is retained.\
\>", "Text",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImportString[xmlString, \ "\<XML\>"]\)], "Input",
  CellLabel->"In[32]:=",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell[BoxData[
    \(XML`Parser`XMLGet::"nonFatalParseError" \(\(:\)\(\ \)\) 
      "Entity 'thorn' was not found at Line: 1 Character: 13 in \
/tmp/m0000124091"\)], "Message",
  CellLabel->"From In[32]:=",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "foo", {}, {"\[EntityStart]thorn\[EntityEnd]"}], {}]\)], "Output",
  CellLabel->"Out[32]=",
  CellTags->{"EntityNameSet", "i:56", "b:3.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"NamespacePrefixes\"", "Subsubsection",
  CellTags->{"NamespacePrefixes", "i:57", "b:3.1"}],

Cell["\<\
This option lets you generate XML markup with a specific namespace \
declaration and namespace prefixes. The option is specified in the form\
\>", \
"Text",
  CellTags->{"NamespacePrefixes", "i:57", "b:3.1"}],

Cell[TextData[{
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["NamespacePrefixes",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["\[Rule]{",
    FontFamily->"Courier"],
  StyleBox["url",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["prefix",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"]
}], "Text",
  CellTags->{"NamespacePrefixes", "i:57", "b:3.1"}],

Cell[TextData[{
  "where ",
  StyleBox["url",
    FontSlant->"Italic"],
  " and ",
  StyleBox["prefix",
    FontSlant->"Italic"],
  " are strings specifying the URL of the namespace and the namespace prefix. \
In the following example, the ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["NamespacePrefix",
    FontFamily->"Courier"],
  StyleBox["\" ",
    FontFamily->"Times New Roman"],
  "option is used to generate presentation markup with each MathML element \
having a namespace prefix ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["mml",
    FontFamily->"Courier"],
  StyleBox["\",",
    FontFamily->"Times New Roman"],
  " associated with the MathML namespace."
}], "Text",
  CellTags->{"NamespacePrefixes", "i:57", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<test.mml\>", x\^2, "\<MathML\>", 
      ConversionOptions \[Rule] {"\<Formats\>" \[Rule] {"\<PresentationMathML\
\>"}, "\<NamespacePrefixes\>" \[Rule] \
{"\<http://www.w3.org/1998/Math/MathML\>" \[Rule] "\<m\>"}}]\)], "Input",
  CellLabel->"In[33]:=",
  CellTags->{"NamespacePrefixes", "i:57", "b:3.1"}],

Cell[BoxData[
    \("test.mml"\)], "Output",
  CellLabel->"Out[33]=",
  CellTags->{"NamespacePrefixes", "i:57", "b:3.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! test.mml\)\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->{"NamespacePrefixes", "i:57", "b:3.1"}],

Cell["\<\
<m:math xmlns:m='http://www.w3.org/1998/Math/MathML'
    xmlns='http://www.w3.org/1998/Math/MathML'>
 <m:msup>
  <m:mi>x</m:mi>
  <m:mn>2</m:mn>
 </m:msup>
</m:math>\
\>", "Print",
  CellLabel->"From In[34]:=",
  CellTags->{"NamespacePrefixes", "i:57", "b:3.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"PrefixCreation\"", "Subsubsection",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell["\<\
This conversion option controls whether a namespace declaration \
should be automatically generated when exporting tags that have a namespace \
associated with them, but no namespace declaration is present in the \
SymbolicXML.  \
\>", "Text",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<PrefixCreation\>\"",
              FontFamily->"Courier"], 
            StyleBox["True",
              
              FontFamily->
                "Courier"], \(a\ namespace\ declaration\ is\ always\ \
generated\ for\ any\ elements\ that\ have\ a\ namespace\ prefix\ but\ no\ \
corresponding\ namespace\ declaration\)},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              
              FontFamily->
                "Courier"], \(a\ namespace\ declaration\ is\ never\ \
automatically\ generated\ for\ any\ element\)},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["Automatic",
              
              FontFamily->
                "Courier"], \(a\ namespace\ declaration\ is\ automatically\ \
generated\ for\ any\ elements\ that\ have\ a\ namespace\ prefix\ in\ the\ \
form\ of\ a\ URL\)}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell["The option \"PrefixCreation\" and its possible values.", "Caption",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell["\<\
Let us look at an example of how this option works. Here is a \
sample of SymbolicXML. \
\>", "Text",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(sxml\  = \ 
      XMLElement[{"\<http://www.mydoc.net/2001/XML\>", "\<tag\>"}, {}, \
{"\<data\>"}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell[BoxData[
    \(XMLElement[{"http://www.mydoc.net/2001/XML", 
        "tag"}, {}, {"data"}]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}]
}, Closed]],

Cell[TextData[{
  "With the setting, ",
  StyleBox["\"PrefixCreation\" \[Rule] \"True\"",
    FontFamily->"Courier"],
  ", a namespace prefix is automatically generated for any namespace that \
does not have a namespace binding. If a namespace prefix is generated, it has \
the form ",
  StyleBox["ns",
    FontFamily->"Courier"],
  StyleBox["i",
    FontSlant->"Italic"],
  " , where ",
  StyleBox["i",
    FontSlant->"Italic"],
  " is an index that starts at 0 and is incremented by one whenever another \
namespace is needed. Here is an example. "
}], "Text",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[\ sxml, "\<XML\>", 
      ConversionOptions \[Rule] {"\<PrefixCreation\>" \[Rule] 
            True}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell[BoxData[
    \("<ns0:tag xmlns:ns0='http://www.mydoc.net/2001/XML'>data</ns0:tag>"\)], \
"Output",
  CellLabel->"Out[2]=",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}]
}, Closed]],

Cell[TextData[{
  "With the setting, ",
  StyleBox["\"PrefixCreation\" \[Rule] Automatic",
    FontFamily->"Courier"],
  ", a namespace declaration is automatically included only if the specified \
namespace for the element has the form of a URL. "
}], "Text",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[\ 
      XMLElement[{"\<http://www.mydoc.net/2001/XML\>", "\<tag\>"}, {}, \
{"\<c\>"}], "\<XML\>", 
      ConversionOptions \[Rule] {"\<PrefixCreation\>" \[Rule] 
            Automatic}]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell[BoxData[
    \("<ns0:tag xmlns:ns0='http://www.mydoc.net/2001/XML'>c</ns0:tag>"\)], \
"Output",
  CellLabel->"Out[3]=",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}]
}, Closed]],

Cell["\<\
If the specified namespace does not have the form of a URL, then no \
namespace declaration is included. \
\>", "Text",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[\ 
      XMLElement[{"\<mydoc\>", "\<tag\>"}, {}, {"\<c\>"}], "\<XML\>", 
      ConversionOptions \[Rule] {"\<PrefixCreation\>" \[Rule] 
            Automatic}]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell[BoxData[
    \("<mydoc:tag>c</mydoc:tag>"\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}]
}, Closed]],

Cell[TextData[{
  "With the setting, ",
  StyleBox["\"PrefixCreation\" \[Rule] \"False\"",
    FontFamily->"Courier"],
  ", a namespace prefix and declaration are not generated automatically. \
Instead, the namespace is literally used as a namespace prefix. "
}], "Text",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[\ sxml, "\<XML\>", 
      ConversionOptions \[Rule] {"\<PrefixCreation\>" \[Rule] 
            False}]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}],

Cell[BoxData[
    \("<http://www.mydoc.net/2001/XML:tag>c</http://www.mydoc.net/2001/XML:\
tag>"\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}]
}, Closed]],

Cell[TextData[{
  "The XML produced in this case is not meaningful because the original \
SymbolicXML did not have a binding for the namespace: ",
  StyleBox["http://www.mydoc.net/2001/XML",
    FontFamily->"Courier"],
  ". In other words, there was no namespace declaration of the form ",
  StyleBox["xmlns:",
    FontFamily->"Courier"],
  StyleBox["prefix",
    FontSlant->"Italic"],
  StyleBox[" = \"http://www.mydoc.net/2001/XML\"",
    FontFamily->"Courier"],
  ". This behavior is desirable in cases where you are exporting the XML as a \
fragment to be enclosed within an outer piece of XML, for which the namespace \
has a binding. "
}], "Text",
  CellTags->{"PrefixCreation", "i:58", "b:3.1"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["5. Working with NotebookML", "Section",
  PageBreakAbove->True],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->{"WhatsEML", "WhatsNBML", "NBMLIntro", "i:60", "b:4.0"}],

Cell[TextData[{
  "NotebookML is an XML format for describing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebooks. It involves a mapping of a notebook expression to a similar \
XML tree structure. The names of elements and attributes in NotebookML are \
chosen to match the names of the corresponding parts of the original notebook \
expression. Let us look at an example. "
}], "Text",
  CellTags->{"WhatsNBML", "NBMLIntro", "WhatsEML", "i:60", "b:4.0"}],

Cell["Here is a simple notebook expression.", "Text",
  CellTags->{"WhatsNBML", "NBMLIntro", "WhatsEML", "i:60", "b:4.0"}],

Cell["Notebook[{Cell[\"Here is some text!\",\"Text\"]}]", "Program",
  FontWeight->"Bold",
  CellTags->{"WhatsNBML", "NBMLIntro", "WhatsEML", "i:60", "b:4.0"}],

Cell["Here is the same expression in NotebookML.", "Text",
  CellTags->{"WhatsNBML", "NBMLIntro", "WhatsEML", "i:60", "b:4.0"}],

Cell["\<\
<Notebook>
 <List>
  <Cell>
   <String>This is a cell.</String>
   <Style>
    <String>Section</String>
   </Style>
  </Cell>
 </List>
</Notebook>\
\>", "Program",
  CellTags->{"WhatsNBML", "NBMLIntro", "WhatsEML", "i:60", "b:4.0"}],

Cell[TextData[{
  "Note the direct correspondence between the parts of the notebook \
expression and their XML counterparts. The conversion is done on the ",
  StyleBox["FullForm",
    FontFamily->"Courier"],
  " of the notebook expression. For example, while a list can be denoted by \
",
  StyleBox["{}",
    FontFamily->"Courier"],
  " in a notebook, the underlying representation of the list is still ",
  StyleBox["List[...]",
    FontFamily->"Courier"],
  ". Hence, in NotebookML a list would be represented by a ",
  StyleBox["List",
    FontFamily->"Courier"],
  " element of the form: ",
  StyleBox["<List>...</List>",
    FontFamily->"Courier"],
  ". "
}], "Text",
  CellTags->{"WhatsNBML", "NBMLIntro", "WhatsEML", "i:60", "b:4.0"}],

Cell[TextData[{
  "NotebookML is useful for exporting complete notebooks in XML format. \
However, you can also export individual cells, mathematical formulas, or \
other types of content in a notebook as XML, using what is called \
ExpressionML. This is a subset of NotebookML that enables you to save \
arbitrary ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions in XML format. Let us look at an example. ",
  "Here is the ",
  StyleBox["FullForm",
    FontFamily->"Courier"],
  " for a mathematical formula."
}], "Text",
  CellTags->{"WhatsEML", "WhatsNBML", "NBMLIntro", "i:60", "b:4.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Sin[x + 1] // FullForm\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"WhatsEML", "WhatsNBML", "NBMLIntro", "i:60", "b:4.0"}],

Cell[BoxData[
    TagBox[
      StyleBox[\(Sin[Plus[1, x]]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True,
        NumberMarks->True],
      FullForm]], "Output",
  CellLabel->"Out[1]//FullForm=",
  CellTags->{"WhatsEML", "WhatsNBML", "NBMLIntro", "i:60", "b:4.0"}]
}, Closed]],

Cell[TextData[{
  "Here is the ExpressionML representation of the same formula. You can \
generate the NotebookML or ExpressionML for any type of notebook expression \
using ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " or ",
  StyleBox["ExportString",
    FontFamily->"Courier"],
  ". "
}], "Text",
  CellTags->{"WhatsEML", "WhatsNBML", "NBMLIntro", "i:60", "b:4.0"}],

Cell["\<\
<Expression>
 <Function>
  <Symbol>Sin</Symbol>
  <Function>
   <Symbol>Plus</Symbol>
   <Number>1</Number>
   <Symbol>x</Symbol>
  </Function>
 </Function>
</Expression>\
\>", "Program",
  CellEditDuplicate->False,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"WhatsEML", "WhatsNBML", "NBMLIntro", "i:60", "b:4.0"}],

Cell[TextData[{
  "NotebookML and ExpressionML are both 100 percent well-formed, \
standards-compliant XML. Hence, they make it easy to integrate ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebooks or parts of notebooks into any XML framework or workflow. "
}], "Text",
  CellTags->{"WhatsNBML", "NBMLIntro", "WhatsEML", "i:60", "b:4.0"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Syntax of NotebookML", "Subsection",
  CellTags->{"i:61", "b:4.1"}],

Cell[CellGroupData[{

Cell["Strings, Numbers, and Symbols", "Subsubsection",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}],

Cell[TextData[{
  "The ",
  StyleBox["String",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Number", "MR"],
  ", and ",
  StyleBox["Symbol",
    FontFamily->"Courier"],
  " elements are the only NotebookML elements that can directly contain \
character data. All other NotebookML elements are either empty elements or \
can only contain other elements. ",
  "For example, here is a simple cell in Text style."
}], "Text",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}],

Cell[BoxData[
    \(Cell["This is a text cell", "Text"]\)], "Program",
  FontWeight->"Bold",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}],

Cell["Here is the corresponding NotebookML.", "Text",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      Cell["\<This is a text cell\>", "\<Text\>"], "\<XML\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}],

Cell[BoxData[
    \("<?xml version='1.0'?>\n<!DOCTYPE Cell SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\n<Cell class='Text'\n    \
CreatedBy='Mathematica 5.0'\n    xmlns:xhtml='http://www.w3.org/1999/xhtml'\n \
   xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <String>This is a text cell</String>\n \
<Style>\n  <String>Text</String>\n </Style>\n</Cell>"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"i:63", "b:4.1"}]
}, Closed]],

Cell[TextData[{
  "Note that each string in the cell expression is represented by a ",
  StyleBox["String",
    FontFamily->"Courier"],
  " element in NotebookML. One benefit of using a ",
  StyleBox["String",
    FontFamily->"Courier"],
  " element to describe string data is that it provides a clearer indication \
to XML-processing applications that the whitespace inside the string data is \
significant. "
}], "Text",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}],

Cell[TextData[{
  "In addition to strings, the contents of a cell can contain numbers or \
symbols. These structures are represented in NotebookML using the elements ",
  StyleBox["Number", "MR"],
  " and ",
  StyleBox["Symbol", "MR"],
  ". For example, the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression"
}], "Text",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}],

Cell[BoxData[
    \(CellFrame[{1, 0}, {0, 1}]\)], "Program",
  FontWeight->"Bold",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}],

Cell["has the following NotebookML representation.", "Text",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}],

Cell["\<\
<CellFrame>
   <List>
     <Number>1</Number>
     <Number>0</Number>
   </List>
   <List>
     <Number>0</Number>
     <Number>1</Number>
   </List>
</CellFrame>\
\>", "Program",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}],

Cell[TextData[{
  StyleBox["Symbol",
    FontFamily->"Courier"],
  " elements lack any special structure. The left-hand side is rendered as an \
element that wraps the right-hand side which is taken as a ",
  StyleBox["Symbol",
    FontFamily->"Courier"],
  " element. As an example, consider the following ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code fragment."
}], "Text",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}],

Cell["Sin[x]", "Program",
  FontWeight->"Bold",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}],

Cell[TextData[{
  "Here is the corresponding NotebookML. The ",
  StyleBox["Function",
    FontFamily->"Courier"],
  " element is used to enclose the names of all built-in functions."
}], "Text",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}],

Cell["\<\
<Function>
  <Symbol>Sin</Symbol>
  <Symbol>x</Symbol>
</Function>\
\>", "Program",
  CellTags->{"BasicNBMLElements", "i:63", "b:4.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Options", "Subsubsection",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", various properties of notebooks, cells, and the contents of a cell are \
described by options. Any notebook with specified options has the following \
underlying structure."
}], "Text",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[TextData[{
  "\t",
  StyleBox["Notebook[{",
    FontFamily->"Courier"],
  StyleBox["cell1", "TR",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  ",",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["cell2", "TR",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  ",",
  StyleBox[" ",
    FontSlant->"Italic"],
  StyleBox["cell3", "TR",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  ", ",
  StyleBox["...",
    FontSlant->"Italic"],
  StyleBox["},",
    FontFamily->"Courier"],
  " ",
  StyleBox["options", "TR",
    FontFamily->"Times New Roman",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"]
}], "FramedBox",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[TextData[{
  "An option has the general form, ",
  StyleBox["name \[Rule]",
    FontSlant->"Italic"],
  " ",
  StyleBox["value",
    FontSlant->"Italic"],
  ", where the left-hand side specifies the option name and the right-hand \
side specifies the value of that option. In NotebookML, an option is \
represented in the following way."
}], "Text",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[TextData[{
  StyleBox["<Option>\n  <Symbol>",
    FontFamily->"Courier"],
  StyleBox["name",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["</Symbol>",
    FontFamily->"Courier"],
  " \n  ",
  StyleBox["NotebookML representation of value",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox["\n",
    FontSlant->"Italic"],
  StyleBox["</Option>",
    FontFamily->"Courier"]
}], "Program",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["\<\
For example, this Notebook expression will include a ruler in the \
toolbar at the top of the displayed window.\
\>", "Text",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[BoxData[
    \(Notebook[{Cell["Some text", "Text"]}, 
      WindowToolbars \[Rule] {"RulerBar"}]\)], "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["Here is the corresponding NotebookML. ", "Text",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      Notebook[{Cell["\<Some text\>", "\<Text\>"]}, 
        WindowToolbars \[Rule] {"\<RulerBar\>"}], "\<XML\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[BoxData[
    \("<?xml version='1.0'?>\n<!DOCTYPE Notebook SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\n<Notebook \
CreatedBy='Mathematica 5.0'\n    xmlns:xhtml='http://www.w3.org/1999/xhtml'\n \
   xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <List>\n  <Cell class='Text'>\n   \
<String>Some text</String>\n   <Style>\n    <String>Text</String>\n   \
</Style>\n  </Cell>\n </List>\n <Options>\n  <Option>\n   \
<Symbol>WindowToolbars</Symbol>\n   <Function>\n    <Symbol>List</Symbol>\n   \
 <String>RulerBar</String>\n   </Function>\n  </Option>\n </Options>\n\
</Notebook>"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}]
}, Closed]],

Cell[TextData[{
  "Multiple options are grouped together in an ",
  StyleBox["Options",
    FontFamily->"Courier"],
  " element. Although this is not necessary, it is useful (for ease of \
programming and efficiency reasons) for many XML applications like XSLT. For \
example, the cell expression"
}], "Text",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["\<\
Cell[\"some \
text\",FontSize\[Rule]8,FontWeight\[Rule]\"Bold\"]\
\>", "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["has the following representation in NotebookML.", "Text",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      Cell["\<some text\>", FontSize \[Rule] 8, 
        FontWeight \[Rule] "\<Bold\>"], "\<XML\>"]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[BoxData[
    \("<?xml version='1.0'?>\n<!DOCTYPE Cell SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\n<Cell CreatedBy='Mathematica \
5.0'\n    xmlns:xhtml='http://www.w3.org/1999/xhtml'\n    \
xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <String>some text</String>\n <Options>\
\n  <Option>\n   <Symbol>FontSize</Symbol>\n   <Number>8</Number>\n  \
</Option>\n  <Option>\n   <Symbol>FontWeight</Symbol>\n   \
<String>Bold</String>\n  </Option>\n </Options>\n</Cell>"\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}]
}, Closed]],

Cell["Options fall into the following four categories. ", "Text",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["String/Symbol/Number Options", "Subsubsubsection",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[TextData[{
  "These options lack any special structure. The left-hand side is rendered \
as an element that wraps the right-hand side, which is taken as a ",
  StyleBox["Symbol",
    FontFamily->"Courier"],
  " element. This can be seen in the following example."
}], "Text",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["Active\[Rule]True", "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["\<\
<Option>
  <Symbol>Active</Symbol>
  <Symbol>True</Symbol>
</Option>\
\>", "Program",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["Color Values", "Subsubsubsection",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[TextData[{
  "Several ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " options, such as ",
  StyleBox["RGBColor",
    FontFamily->"Courier"],
  " or ",
  StyleBox["Hue",
    FontFamily->"Courier"],
  ", can take color values. For these options, the head of the right-hand \
side is treated as a proper element rather than just as a ",
  StyleBox["Symbol",
    FontFamily->"Courier"],
  " element. The specified color value is then represented as a sequence of \
individual ",
  StyleBox["Number",
    FontFamily->"Courier"],
  " elements. Here is an example."
}], "Text",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["Background\[Rule]RGBColor[1,0,0]", "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["\<\
<Option>
   <Symbol>Background</Symbol>
   <Function>
    <Symbol>RGBColor</Symbol>
    <Number>0</Number>
    <Number>0</Number>
    <Number>1</Number>
   </Function>
</Option>\
\>", "Program",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["Suboptions", "Subsubsubsection",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[TextData[{
  "Many options take a list of suboptions. For these types of options, the \
option corresponds to the parent element in the NotebookML representation, \
and each of the suboptions is a child element. Note that in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", all of the suboptions have left-hand sides that are strings, not \
symbols. This information is implicit in the XML representation because \
NotebookML automatically recognizes whether the option should be a string or \
a symbol on import. The following examples illustrate how this mechanism \
works."
}], "Text",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["\<\
PrintingOptions\[Rule]{\"FirstPageFooter\"\[Rule]False,\"\
PageFooterMargins\"\[Rule]{10,10}}\
\>", "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["\<\
  <Option>
   <Symbol>PrintingOptions</Symbol>
   <Options>
    <Option>
     <String>FirstPageFooter</String>
     <Symbol>False</Symbol>
    </Option>
    <Option>
     <String>PageFooterMargins</String>
     <Function>
      <Symbol>List</Symbol>
      <Number>10</Number>
      <Number>10</Number>
     </Function>
    </Option>
   </Options>
  </Option>\
\>", "Program",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["List Types", "Subsubsubsection",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[TextData[{
  "Some options in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " can take a list of any number of values. Since each of the values must be \
separated from one another, each is enclosed in a separate child element. In \
this example, each of the ",
  StyleBox["True",
    FontFamily->"Courier"],
  " or ",
  StyleBox["False",
    FontFamily->"Courier"],
  " values is enclosed in a separate ",
  StyleBox["Symbol",
    FontFamily->"Courier"],
  " element."
}], "Text",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["ColumnLines\[Rule]{True,False,True}", "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["\<\
<ColumnLines>
   <Symbol>True</Symbol>
   <Symbol>False</Symbol>
   <Symbol>True</Symbol>
</ColumnLines>\
\>", "Program",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell[TextData[{
  "When there are sublists in the option value, each of the sublists is \
enclosed in its own ",
  StyleBox["List",
    FontFamily->"Courier"],
  " element, as in the following examples. The first example shows only \
numbers as suboptions, while the second shows both symbols and numbers. Here \
are two examples."
}], "Text",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["CellFrame\[Rule]{{4,0},{0,2}}", "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["\<\
  <Option>
   <Symbol>CellFrame</Symbol>
   <Function>
    <Symbol>List</Symbol>
    <Function>
     <Symbol>List</Symbol>
     <Number>4</Number>
     <Number>0</Number>
    </Function>
    <Function>
     <Symbol>List</Symbol>
     <Number>0</Number>
     <Number>2</Number>
    </Function>
   </Function>
  </Option>\
\>", "Program",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["\<\
CellFrame\[Rule]{{Inherited,5},{0,Inherited}}\
\>", "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}],

Cell["\<\
  <Option>
   <Symbol>CellFrame</Symbol>
   <Function>
    <Symbol>List</Symbol>
    <Function>
     <Symbol>List</Symbol>
     <Symbol>Inherited</Symbol>
     <Number>5</Number>
    </Function>
    <Function>
     <Symbol>List</Symbol>
     <Number>0</Number>
     <Symbol>Inherited</Symbol>
    </Function>
   </Function>
  </Option>\
\>", "Program",
  CellTags->{"NBMLOptions", "i:62", "b:4.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Data", "Subsubsection",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
There are several notebook elements for representing the different \
types of data that can occur in a notebook. These are described below. \
\>", \
"Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["TextData", "Subsubsubsection",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "Text that is potentially in different styles or that contains embedded \
cells, is represented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " as ",
  StyleBox["TextData",
    FontFamily->"Courier"],
  ". In NotebookML, it is represented by the ",
  StyleBox["TextData",
    FontFamily->"Courier"],
  " tag. Here is an example. "
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["TextData[{\"Some text\",Cell[...],\"some more text\"}]", "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
<TextData>
   <String>Some text</String>
   <Cell>...</Cell>
   <String>Some more text</String>
</TextData>\
\>", "Program",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  StyleBox["TextData",
    FontFamily->"Courier"],
  " does not take any options\[LongDash]all of its children are its contents. \
Hence, there is no need for a ",
  StyleBox["TextDataContents",
    FontFamily->"Courier"],
  " wrapper element."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["StyleData", "Subsubsubsection",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "Options for styles in a cell are contained in a ",
  StyleBox["StyleData",
    FontFamily->"Courier"],
  " element in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". As expected, this is represented by a ",
  StyleBox["StyleData",
    FontFamily->"Courier"],
  " element in NotebookML. Here are two basic templates, depending on whether \
a particular style environment is specified or not."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["StyleData[style_String]", "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
<StyleData>
   <String>style</String>
</StyleData>\
\>", "Program",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["StyleData[style_String, environment_String]", "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
<StyleData>
   <String>style</String>
   <String>environment</String>
</StyleData>\
\>", "Program",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["BoxData", "Subsubsubsection",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "In addition to being expressed as NotebookML, the contents of a ",
  StyleBox["BoxData",
    FontFamily->"Courier"],
  " expression can also be saved as MathML or a GIF file. If it is saved as \
MathML, then the ",
  StyleBox["BoxData",
    FontFamily->"Courier"],
  " element contains MathML wrapped in a ",
  StyleBox["math",
    FontFamily->"Courier"],
  " tag. If it is saved as a GIF image, then the content is an ",
  StyleBox["img",
    FontFamily->"Courier"],
  " element like XHTML, with the appropriate references."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "For example, here is a ",
  StyleBox["BoxData",
    FontFamily->"Courier"],
  " fragment exported as MathML."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
<BoxData>
   <math>
     <mrow>
      ...
     </mrow>
   </math>
</BoxData>\
\>", "Program",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "Here is ",
  StyleBox["BoxData",
    FontFamily->"Courier"],
  " fragment exported as a GIF image."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
<BoxData>
   <img src=\"/Images/img1.gif\"/>
</BoxData>\
\>", "Program",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["GraphicsData", "Subsubsubsection",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "In addition to being a NotebookML expression, ",
  StyleBox["a",
    FontFamily->"Times New Roman"],
  " ",
  StyleBox["GraphicsData",
    FontFamily->"Courier"],
  " expression can also be saved as a GIF file. When saved as NotebookML, the \
",
  StyleBox["GraphicsData", "Program"],
  " element wraps the data in an element whose name is the encoding type. \
When saved as a GIF, the ",
  StyleBox["GraphicsData", "Program"],
  " element has only a ",
  StyleBox["img",
    FontFamily->"Courier"],
  " element like XHTML that references the GIF."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "Here, for example, is a ",
  StyleBox["GraphicsData", "Program"],
  " fragment exported as NotebookML."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
<GraphicsData>
   <PostScript> ... postscript data here ...</PostScript>
</GraphicsData>\
\>", "Program",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "Here, on the other hand, is a ",
  StyleBox["GraphicsData", "Program"],
  " fragment exported as a GIF image."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
<GraphicsData>
   <img src=\"/Images/img1.gif\"/>
<GraphicsData>\
\>", "Program",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["CellGroupData", "Subsubsubsection",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "Closed or open cell groups are represented by the ",
  StyleBox["CellGroupData",
    FontFamily->"Courier"],
  " tag."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["CellGroupData[contents_List, Open|Closed]", "Program",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
<CellGroupData>
   <CellGroupDataContents>
     ...
   </CellGroupDataContents>
   <Symbol>[Open|Closed]</Symbol>
</CellGroupData>\
\>", "Program",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["OutputFormData", "Subsubsubsection",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", ",
  StyleBox["OutputFormData",
    FontFamily->"Courier"],
  " contains text as generated by ",
  StyleBox["InputForm",
    FontFamily->"Courier"],
  " and ",
  StyleBox["OutputForm",
    FontFamily->"Courier"],
  ". It is represented in NotebookML by the tag ",
  StyleBox["OutputFormData",
    FontFamily->"Courier"],
  " with the following basic template, where ",
  StyleBox["input",
    FontSlant->"Italic"],
  " is a string representing the input form and ",
  StyleBox["output",
    FontSlant->"Italic"],
  " is a string representing the output form."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  StyleBox["OutputFormData[",
    FontFamily->"Courier"],
  StyleBox["input",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier"],
  StyleBox["output",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"]
}], "Text",
  Evaluatable->False,
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
<OutputFormData>
   <String>...</String>
   <String>...</String>
</OutputFormData>\
\>", "Program",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "As in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", the string that represents the output form and the string that \
represents the input form are determined positionally; the first child is the \
input form, the second is the output form."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["XMLData", "Subsubsubsection",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
One potential benefit of XML formats is the ability to use multiple \
programs for authoring single documents. By using XML as an interchange \
format, the document should be editable by many programs. However, just \
because the files are in XML format, does not necessarily mean all programs \
will know what to do with the XML; there still must be a way to hold onto the \
unrecognized XML portions in other applications.\
\>", "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "Raw SymbolicXML can be entered under an ",
  StyleBox["XMLData",
    FontFamily->"Times New Roman"],
  " suboption for the TaggingRules option. This allows you to add arbitrary \
SymbolicXML into your notebooks or, if you are generating NotebookML from \
some other means, additional XML code. After importing the NotebookML \
document, your XML is stored in the notebook under this option. Any part of \
",
  StyleBox["TaggingRules",
    FontFamily->"Courier"],
  " that is not under the ",
  StyleBox["\"", "MR"],
  StyleBox["XMLData", "MR"],
  StyleBox["\"", "MR"],
  " suboption is saved as ExpressionML, as it can represent arbitrary ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "For example, suppose you are authoring a document that uses MathML and \
VoiceML. Naturally, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " would be an excellent environment for editing the MathML portion of such \
a document. However, chances are there is a better editing environment for \
VoiceML. It is therefore useful to retain the VoiceML data in a notebook. \
Even if that information is never used by the front end itself, it needs to \
be present so that it is still available after exporting to XML."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell[TextData[{
  "Here, we have a simple example that shows ",
  StyleBox["TaggingRules",
    FontFamily->"Courier"],
  " being used on a cell. The XML data is rendered in an ",
  StyleBox["XMLData",
    FontFamily->"Courier"],
  " element."
}], "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
Cell[\"Some \
text\",TaggingRules\[Rule]{\"val\",\"XMLData\"\[Rule]{XMLElement[\"voice\",{},\
{}]},1}]\
\>", "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
This is how the above cell would be represented in \
ExpressionML.\
\>", "Text",
  CellTags->{"NBMLData", "i:64", "b:4.1"}],

Cell["\<\
<Cell>
 <String>Some text</String>
 <Options>
  <Option>
   <Symbol>TaggingRules</Symbol>
   <Function>
    <Symbol>List</Symbol>
    <String>val</String>
    <XMLData>
     <voice/>
    </XMLData>
    <Number>1</Number>
   </Function>
  </Option>
 </Options>
</Cell>\
\>", "Program",
  CellTags->{"NBMLData", "i:64", "b:4.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Boxes", "Subsubsection",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " uses boxes to represent typesetting information. This section give an \
overview of the various types of boxes, and their representation in \
NotebookML."
}], "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["Generic Boxes", "Subsubsubsection",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  "Most of the boxes are very straightforward, and are handled exactly \
analogously to their representation in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". The first argument is the first child element, the second argument is \
the second element, and so on. There is an optional element at the end. Here \
is a template specifically for ",
  StyleBox["SuperscriptBox",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  "SuperscriptBox[",
  StyleBox["base",
    FontFamily->"Times",
    FontSlant->"Italic"],
  ", ",
  StyleBox["superscript",
    FontFamily->"Times",
    FontSlant->"Italic"],
  ", ",
  StyleBox["options",
    FontFamily->"Times",
    FontSlant->"Italic"],
  "]"
}], "Text",
  Evaluatable->False,
  FontFamily->"Courier",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  "This would be represented in NotebookML as shown below, where ",
  StyleBox["xmlbase",
    FontSlant->"Italic"],
  " and ",
  StyleBox["xmlsuperscript",
    FontSlant->"Italic"],
  " are the NotebookML representations of the base and superscript, \
respectively. "
}], "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  "<SupercriptBox>\n  ",
  StyleBox["xmlbase\n    xmlsuperscript",
    FontFamily->"Times",
    FontSlant->"Italic"],
  "\n  <SuperscriptBoxOptions>...</SuperscriptBoxOptions>\n</SuperscriptBox>"
}], "Program",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["Here, the previous template is put to use.", "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["SuperscriptBox[\"3\",\"4\"]", "Program",
  FontWeight->"Bold",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["\<\
<SuperscriptBox>
   <String>3</String>
   <String>4</String>
</SuperscriptBox>\
\>", "Program",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  "All box options are inserted into a container that takes the name of the \
box with \[OpenCurlyDoubleQuote]Options\[CloseCurlyDoubleQuote] appended, for \
example, ",
  StyleBox["SuperscriptBoxOptions",
    FontFamily->"Courier"],
  ". This is exactly analogous to the option used to specify box options at a \
cell level in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  "Cell[",
  StyleBox["contents",
    FontFamily->"Times",
    FontSlant->"Italic"],
  ", ",
  StyleBox["style",
    FontFamily->"Times",
    FontSlant->"Italic"],
  ", ",
  StyleBox["options",
    FontFamily->"Times",
    FontSlant->"Italic"],
  "]"
}], "Text",
  Evaluatable->False,
  FontFamily->"Courier",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  "All of the box option containers are allowed to appear either as a \
subelement to the boxes, or as a subelement to ",
  StyleBox["CellOptions",
    FontFamily->"Courier"],
  " or ",
  StyleBox["NotebookOptions",
    FontFamily->"Courier"],
  ". "
}], "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  "Here is a list of all the simple boxes that behave like ",
  StyleBox["SuperscriptBox",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  StyleBox["SubscriptBox[",
    FontFamily->"Courier"],
  StyleBox["base",
    FontSlant->"Italic"],
  ", ",
  StyleBox["sub",
    FontSlant->"Italic"],
  ", ",
  StyleBox["opts",
    FontSlant->"Italic"],
  "]"
}], "BulletedList",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  StyleBox["SubsuperscriptBox",
    FontFamily->"Courier"],
  "[",
  StyleBox["base",
    FontSlant->"Italic"],
  ", ",
  StyleBox["sub",
    FontSlant->"Italic"],
  ", ",
  StyleBox["super",
    FontSlant->"Italic"],
  ", ",
  StyleBox["opts",
    FontSlant->"Italic"],
  "]"
}], "BulletedList",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  StyleBox["OverscriptBox",
    FontFamily->"Courier"],
  "[",
  StyleBox["base",
    FontSlant->"Italic"],
  ", ",
  StyleBox["over",
    FontSlant->"Italic"],
  ", ",
  StyleBox["opts",
    FontSlant->"Italic"],
  "]"
}], "BulletedList",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  StyleBox["UnderscriptBox",
    FontFamily->"Courier"],
  "[",
  StyleBox["base",
    FontSlant->"Italic"],
  ", ",
  StyleBox["under",
    FontSlant->"Italic"],
  ", ",
  StyleBox["opts",
    FontSlant->"Italic"],
  "]"
}], "BulletedList",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  StyleBox["UnderoverscriptBox",
    FontFamily->"Courier"],
  "[",
  StyleBox["base",
    FontSlant->"Italic"],
  ", ",
  StyleBox["under",
    FontSlant->"Italic"],
  ", ",
  StyleBox["over",
    FontSlant->"Italic"],
  ", ",
  StyleBox["opts",
    FontSlant->"Italic"],
  "]"
}], "BulletedList",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  StyleBox["FractionBox",
    FontFamily->"Courier"],
  "[",
  StyleBox["num",
    FontSlant->"Italic"],
  ", ",
  StyleBox["denom",
    FontSlant->"Italic"],
  ", ",
  StyleBox["opts",
    FontSlant->"Italic"],
  "]"
}], "BulletedList",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  StyleBox["SqrtBox",
    FontFamily->"Courier"],
  "[",
  StyleBox["base",
    FontSlant->"Italic"],
  ", ",
  StyleBox["opts",
    FontSlant->"Italic"],
  "]"
}], "BulletedList",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  StyleBox["RadicalBox",
    FontFamily->"Courier"],
  "[",
  StyleBox["base",
    FontSlant->"Italic"],
  ", ",
  StyleBox["script",
    FontSlant->"Italic"],
  ", ",
  StyleBox["opts",
    FontSlant->"Italic"],
  "]"
}], "BulletedList",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  StyleBox["FrameBox",
    FontFamily->"Courier"],
  "[",
  StyleBox["base",
    FontSlant->"Italic"],
  ", ",
  StyleBox["opts",
    FontSlant->"Italic"],
  "]"
}], "BulletedList",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["RowBox", "Subsubsubsection",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  StyleBox["RowBox",
    FontFamily->"Courier"],
  " in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " represents a row of boxes or strings in input and output. In NotebookML, \
it is represented by the ",
  StyleBox["RowBox", "MR"],
  " tag. Here is an example template.."
}], "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["Here is a more concrete example.", "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["RowBox[{\"Some text\",SqrtBox[\"7\"]}]", "Program",
  FontWeight->"Bold",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["This has the following representation in NotebookML.", "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["\<\
<RowBox>
   <List>
     <String>Some text</String>
     <SqrtBox>
       <String>7</String>
     </SqrtBox>
   </List>
</RowBox>\
\>", "Program",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["GridBox", "Subsubsubsection",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  StyleBox["GridBox",
    FontFamily->"Courier"],
  " in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " represents a two-dimensional grid of boxes or strings in input and \
output. In NotebookML, it is represented by the ",
  StyleBox["GridBox", "MR"],
  " tag. Here is an example."
}], "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["\<\
GridBox[{{\"1\",\"2\"},{{SqrtBox[\"3\"]},{\"4\"}}},ColumnLines\
\[Rule]True]\
\>", "Program",
  FontWeight->"Bold",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["This has the following representation in NotebookML.", "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["\<\
<GridBox>
    <List>
       <List>
          <String>1</String>
          <String>2</String>
       </List>
       <List>
          <SqrtBox>
             <String>3</String>
          </SqrtBox>
          <String>4</String>
       </List>
    </List>
    <GridBoxOptions>
       <ColumnLines>True</ColumnLines>
    </GridBoxOptions>
</GridBox>\
\>", "Program",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["StyleBox", "Subsubsubsection",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  StyleBox["StyleBox",
    FontFamily->"Courier"],
  " in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " represents output that is shown with the specified option settings. \
StyleBoxes can be children of ",
  StyleBox["TextData",
    FontFamily->"Courier"],
  ", not just ",
  StyleBox["BoxData",
    FontFamily->"Courier"],
  ". In NotebookML, it is represented by the ",
  StyleBox["StyleBox", "MR"],
  " tag. Here is an example."
}], "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["StyleBox[\"Some text\",\"Input\"]", "Program",
  FontWeight->"Bold",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["\<\
<StyleBox>
   <String>Some text</String>
   <Style>
     <String>Input</String>
   </Style>
</StyleBox>\
\>", "Program",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["CounterBox/ValueBox/OptionValueBox", "Subsubsubsection",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  "The boxes in this section have the same form, and all have the property \
that the front end computes their value based on the input. Because those \
computations are not all that simple, it could be hard, and potentially \
impossible, to figure out what should be used with other XML applications, \
such as XSLT. In ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  "5.0",
  ", there is a new option (",
  StyleBox["DisplayedValue",
    FontFamily->"Courier"],
  ") that contains what is literally displayed."
}], "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  "Here are three templates, based on ",
  StyleBox["CounterBox",
    FontFamily->"Courier"],
  ". ",
  StyleBox["ValueBox",
    FontFamily->"Courier"],
  " and ",
  StyleBox["OptionValueBox",
    FontFamily->"Courier"],
  " operate in exactly the same way."
}], "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[BoxData[
    \(CounterBox[data_String, opts___]\)], "Program",
  FontWeight->"Bold",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["\<\
<CounterBox>
  <String>data</String>
  <CounterBoxOptions>...</CounterBoxOptions>
</CounterBox>\
\>", "Program",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[BoxData[
    \(CounterBox[data_String, \ cellTag_String, \ opts___]\)], "Program",
  FontWeight->"Bold",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["\<\
<CounterBox>
       <String>data</String>
       <String>thetag</String>
       <CounterBoxOptions>...</CounterBoxOptions>
   </CounterBox>\
\>", "Program",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[BoxData[
    \(CounterBox[data_String, {file_String, cellTag_String}, 
      opts___]\)], "Program",
  FontWeight->"Bold",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["\<\
<CounterBox>
       <String>data</String>
       <String>thefile<String>
       <String>thetag</String>
       <CounterBoxOptions>...</CounterBoxOptions>
   </CounterBox>\
\>", "Program",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  "The position of the cell tag depends on how many string children ",
  StyleBox["CounterBox",
    FontFamily->"Courier"],
  " has. If there are three string children, it will be the third; if there \
are two string children, it will be the second. This means it is always the \
last string child."
}], "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["InterpretationBox/TagBox/FormBox", "Subsubsubsection",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  "The special thing about these boxes is that their second argument can take \
arbitrary ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions rather than just box expressions. Because of this, in the \
NotebookML representation the second argument must be represented in \
ExpressionML. Here is a basic template."
}], "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[BoxData[
    \(\(InterpretationBox[content_, \ interpretation_, \ 
        opts___];\)\)], "Program",
  FontWeight->"Bold",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[TextData[{
  "<InterpretationBox>\n  ",
  StyleBox["XML representation of content\n    XML representation of \
interpretation",
    FontFamily->"Times",
    FontSlant->"Italic"],
  "\n   <InterpretationBoxOptions>...</InterpretationBoxOptions>\n\
</InterpretationBox>"
}], "Program",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["Here is a concrete example.", "Text",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell[BoxData[
    \(InterpretationBox["Some text", Sin[x]]\)], "Program",
  FontWeight->"Bold",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}],

Cell["\<\
<InterpretationBox>
   <String>Some text</String>
   <Function>
     <Symbol>Sin</Symbol>
     <Symbol>x</Symbol>
   </Function>
</InterpretationBox>\
\>", "Program",
  CellTags->{"NMBMLBoxes", "i:65", "b:4.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Importing NotebookML", "Subsection",
  CellTags->{"NBMLImport", "i:66", "b:4.2"}],

Cell[TextData[{
  "NotebookML files can be imported through the kernel using ",
  StyleBox["Import",
    FontFamily->"Courier"],
  ". The first argument of ",
  StyleBox["Import",
    FontFamily->"Courier"],
  " is the filename of the file you are importing. If the file carries the ",
  StyleBox[".xml",
    FontFamily->"Courier"],
  " or ",
  StyleBox[".nbml",
    FontFamily->"Courier"],
  " extension and is in NotebookML format, then ",
  StyleBox["Import",
    FontFamily->"Courier"],
  " will automatically convert the file into a notebook expression. Here is \
an example."
}], "Text",
  CellTags->{"NBMLImport", "i:66", "b:4.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Import["\<test.xml\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"NBMLImport", "i:66", "b:4.2"}],

Cell[BoxData[
    \(Notebook[Cell["Hello. This is a test notebook.", "Text"], 
      FrontEndVersion \[RuleDelayed] "5.0 for Microsoft Windows", 
      ScreenRectangle \[RuleDelayed] {{0.`, 1024.`}, {0.`, 695.`}}, 
      WindowSize \[RuleDelayed] {496.`, 599.`}, 
      WindowMargins \[RuleDelayed] {{18.`, Automatic}, {Automatic, 
            23.`}}]\)], "Output",
  CellEditDuplicate->False,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"NBMLImport", "i:66", "b:4.2"}]
}, Open  ]],

Cell[TextData[{
  "You can also specify the import format explicitly, by using \"",
  StyleBox["SymbolicXML",
    FontFamily->"Courier"],
  "\" or \"",
  StyleBox["NotebookML",
    FontFamily->"Courier"],
  "\" as the second argument to ",
  StyleBox["Import",
    FontFamily->"Courier"],
  ". This is useful when the file you are importing does not have a ",
  StyleBox[".xml",
    FontFamily->"Courier"],
  " or ",
  StyleBox[".nbml",
    FontFamily->"Courier"],
  " extension to indicate the nature of its contents. "
}], "Text",
  CellTags->{"NBMLImport", "i:66", "b:4.2"}],

Cell[TextData[{
  "The import process is much faster, especially for large files, if you \
specify \"",
  StyleBox["NotebookML",
    FontFamily->"Courier"],
  "\" as the import format. However, you should only use this form if you are \
sure that the file is a NotebookML document."
}], "Text",
  CellTags->{"NBMLImport", "i:66", "b:4.2"}],

Cell["Import[\"test.xml\", \"NotebookML\"];", "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLImport", "i:66", "b:4.2"}],

Cell[TextData[{
  "You can also import the file as",
  StyleBox[" ",
    FontColor->RGBColor[1, 0, 0]],
  "SymbolicXML using the following command."
}], "Text",
  CellTags->{"NBMLImport", "i:66", "b:4.2"}],

Cell["Import[\"test.xml\", \"SymbolicXML\"];", "Program",
  FontWeight->"Bold",
  CellTags->{"NBMLImport", "i:66", "b:4.2"}],

Cell[TextData[{
  "You can control the various details of the import process, such as how to \
treat whitespace or whether to recognize entities, by specifying conversion \
options to the ",
  StyleBox["Import",
    FontFamily->"Courier"],
  " function. For more information, see ",
  ButtonBox["XML Import Conversion Options",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->{"NBMLImport", "i:66", "b:4.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Processing NotebookML", "Subsection",
  CellTags->"b:4.3"],

Cell[CellGroupData[{

Cell["Converting to SymbolicXML", "Subsubsection",
  CellTags->{"NBMLSymbolicXML", "i:67", "b:4.3"}],

Cell[TextData[{
  "Suppose you have written a technical paper in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " and now want to submit the paper to a journal that only accepts \
submissions in a specific XML format, say DocBook. You therefore need to \
transform your notebook into DocBook format. One way to do this is to use \
XSLT to transform the NotebookML output from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " into DocBook."
}], "Text",
  CellTags->{"NBMLSymbolicXML", "i:67", "b:4.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006F0000Fb000`400?l00000o`00003ooooooonG
ooooo`00oooooonGooooo`00oooooonGooooo`00oooooonGooooo`001Ooooom5o`000?ooooooCOoo
ool000Gooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`3ooooood_ooooo0005oooo
o`03o`000?oooooooooo047ooooo00?o0000ooooooooool0oooooom;ooooo`001Oooool00ol0003o
ooooooooo`11ooooo`03o`000?oooooooooo0?ooooooBoooool000Gooooo00?o0000ooooooooool0
@Oooool00ol0003oooooooooo`0hooooo`03ooclo?okno_ono_k06Wono_k00?ooOgmooooooooool0
=_ooool00oolo?cono_koo_kn`1Yoo_kn`7ooOgm0005ooooo`03o`000?oooooooooo047ooooo00?o
0000ooooooooool0=oooool00oomoOgol_;bonk^kP1Yonk^kP03oo3`l?okno_ooooo03Kooooo00?o
oOgmoo;bl_o^k^h0JOo^k^h1oo3`l07ono_k0005ooooo`03o`000?oooooooooo047ooooo00?o0000
ooooooooool0=_ooool00ooinOWohN7QomGEe@1Yom;BdP03omOGeoo^k^kono_k03Kooooo00?onOWi
on7QhOoEeMD0JOoBd]81omOGe`7ok^k^0Ookno/000Gooooo00?o0000ooooooooool0@Oooool00ol0
003oooooooooo`0eooooo`04ooGemOoCdm?o^k^kok>c/fSo/K6a00Co^;Rhom;Bd_o^k^kono_k=Ooo
ool01?oemOGodm?Cok^k^onc/k=Xok6a/@03okRh^?oBd];ok^k^007ono_k0005ooooo`03o`000?oo
oooooooo047ooooo00?o0000ooooooooool0=?ooool01Oo^k^ko];BdoiVIVOn=SHgoQhN706OoQXJ6
00GoShn?ok6a/OoBd];ok^k^oo_kn`0dooooo`05onk^k_nd];CoVIVIohf=SOn7QhL0Ion6QXH01?n?
Shoo/K6aom;Bd_o^k^h1oo_kn`001Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo
03?oooooKOl000001On7QhOo/K6aom;Bd_o^k^kono_k03?oooooKOl000001?n7QhOo/K6aom;Bd_o^
k^h1oo_kn`001Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo03?ooooo00?o0000
ooooooooool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knc?ooooo00?o0000ooooooooool0
JOooool01Ol0003oQhN7ok6a/OoBd];ok^k^007ono_k0005ooooo`03o`000?oooooooooo047ooooo
00?o0000ooooooooool0<oooool00ol0003oooooooooo`1Yooooo`06o`000?n7QhOo/K6aom;Bd_o^
k^kono_k<oooool00ol0003oooooooooo`1Yooooo`05o`000?n7QhOo/K6aom;Bd_o^k^h00Ookno/0
00Gooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo
06Wooooo00Ko0000ohN7Qona/K7od];Bonk^k_okno/cooooo`03o`000?oooooooooo06Wooooo00Go
0000ohN7Qona/K7od];Bonk^kP01oo_kn`001Oooool00ol0003oooooooooo`11ooooo`03o`000?oo
oooooooo03?ooooo00?o0000ooooooooool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knc?o
oooo00?o0000ooooooooool0JOooool01Ol0003oQhN7ok6a/OoBd];ok^k^007ono_k0005ooooo`03
o`000?oooooooooo047ooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`1Yooooo`06
o`000?n7QhOo/K6aom;Bd_o^k^kono_k<oooool00ol0003oooooooooo`1Yooooo`05o`000?n7QhOo
/K6aom;Bd_o^k^h00Ookno/000Gooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`0c
ooooo`03o`000?oooooooooo06Wooooo00Ko0000ohN7Qona/K7od];Bonk^k_okno/cooooo`03o`00
0?oooooooooo06Wooooo00Go0000ohN7Qona/K7od];Bonk^kP01oo_kn`001Oooool00ol0003ooooo
ooooo`11ooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool0JOooool01_l0003oQhN7
ok6a/OoBd];ok^k^oo_knc?ooooo00?o0000ooooooooool0JOooool01Ol0003oQhN7ok6a/OoBd];o
k^k^007ono_k0005ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0<oooool00ol0
003oooooooooo`1Yooooo`06o`000?n7QhOo/K6aom;Bd_o^k^kono_k<oooool00ol0003ooooooooo
o`1Yooooo`05o`000?n7QhOo/K6aom;Bd_o^k^h00Ookno/000Gooooo00?o0000ooooooooool0@Ooo
ool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo06Wooooo00Ko0000ohN7Qona/K7od];B
onk^k_okno/cooooo`03o`000?oooooooooo06Wooooo00Go0000ohN7Qona/K7od];Bonk^kP01oo_k
n`001Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo03?ooooo00?o0000oooooooo
ool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knc?ooooo00?o0000ooooooooool0JOooool0
1Ol0003oQhN7ok6a/OoBd];ok^k^007ono_k0005ooooo`03o`000?oooooooooo047ooooo00?o0000
ooooooooool0<oooool00ol0003oooooooooo`1Yooooo`06o`000?n7QhOo/K6aom;Bd_o^k^kono_k
<oooool00ol0003oooooooooo`1Yooooo`05o`000?n7QhOo/K6aom;Bd_o^k^h00Ookno/000Gooooo
00?o0000ooooooooool0@Oooool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo06Wooooo
00Ko0000ohN7Qona/K7od];Bonk^k_okno/cooooo`03o`000?oooooooooo06Wooooo00Go0000ohN7
Qona/K7od];Bonk^kP01oo_kn`001Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo
03?ooooo00?o0000ooooooooool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knc?ooooo00?o
0000ooooooooool0JOooool01Ol0003oQhN7ok6a/OoBd];ok^k^007ono_k0005ooooo`03o`000?oo
oooooooo047ooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`1Yooooo`06o`000?n7
QhOo/K6aom;Bd_o^k^kono_k<oooool00ol0003oooooooooo`1Yooooo`05o`000?n7QhOo/K6aom;B
d_o^k^h00Ookno/000Gooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`0cooooo`03
o`000?oooooooooo06Wooooo00Ko0000ohN7Qona/K7od];Bonk^k_okno/cooooo`03o`000?oooooo
oooo06Wooooo00Go0000ohN7Qona/K7od];Bonk^kP01oo_kn`001Oooool00ol0003oooooooooo`11
ooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool0JOooool01_l0003oQhN7ok6a/OoB
d];ok^k^oo_knc?ooooo00?o0000ooooooooool0JOooool01Ol0003oQhN7ok6a/OoBd];ok^k^007o
no_k0005ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0<oooool00ol0003ooooo
ooooo`1Yooooo`06o`000?n7QhOo/K6aom;Bd_o^k^kono_k<oooool00ol0003oooooooooo`1Yoooo
o`05o`000?n7QhOo/K6aom;Bd_o^k^h00Ookno/000Gooooo00?o0000ooooooooool0@Oooool00ol0
003oooooooooo`0cooooo`03o`000?oooooooooo06Wooooo00Ko0000ohN7Qona/K7od];Bonk^k_ok
no/cooooo`03o`000?oooooooooo06Wooooo00Go0000ohN7Qona/K7od];Bonk^kP01oo_kn`001Ooo
ool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool0JOoo
ool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knc?ooooo00?o0000ooooooooool0JOooool01Ol0003o
QhN7ok6a/OoBd];ok^k^007ono_k0005ooooo`03o`000?oooooooooo047ooooo00?o0000oooooooo
ool0<oooool00ol0003oooooooooo`1Yooooo`06o`000?n7QhOo/K6aom;Bd_o^k^kono_k<oooool0
0ol0003oooooooooo`1Yooooo`05o`000?n7QhOo/K6aom;Bd_o^k^h00Ookno/000Gooooo00?o0000
ooooooooool0@Oooool00ol0003oooooooooo`0cooooo`03o`000?oooooooooo06Wooooo00Ko0000
ohN7Qona/K7od];Bonk^k_okno/cooooo`03o`000?oooooooooo06Wooooo00Go0000ohN7Qona/K7o
d];Bonk^kP01oo_kn`001Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo03?ooooo
00?o0000ooooooooool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knc?ooooo00?o0000oooo
ooooool0JOooool01Ol0003oQhN7ok6a/OoBd];ok^k^007ono_k0005ooooo`03o`000?oooooooooo
047ooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`1Yooooo`06o`000?n7QhOo/K6a
om;Bd_o^k^kono_k<oooool00ol0003oooooooooo`1Yooooo`05o`000?n7QhOo/K6aom;Bd_o^k^h0
0Ookno/000Gooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`0cooooo`03o`000?oo
oooooooo06Wooooo00Ko0000ohN7Qona/K7od];Bonk^k_okno/cooooo`03o`000?oooooooooo06Wo
oooo00Go0000ohN7Qona/K7od];Bonk^kP01oo_kn`001Oooool00ol0003oooooooooo`11ooooo`03
o`000?oooooooooo03?ooooo00?o0000ooooooooool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^
oo_knc?ooooo00?o0000ooooooooool0JOooool01Ol0003oQhN7ok6a/OoBd];ok^k^007ono_k0005
ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`1Y
ooooo`06o`000?n7QhOo/K6aom;Bd_o^k^kono_k<oooool00ol0003oooooooooo`1Yooooo`05o`00
0?n7QhOo/K6aom;Bd_o^k^h00Ookno/000Gooooo00?o0000ooooooooool0@Oooool00ol0003ooooo
ooooo`0cooooo`03o`000?oooooooooo06Wooooo00Ko0000ohN7Qona/K7od];Bonk^k_okno/coooo
o`03o`000?oooooooooo06Wooooo00Go0000ohN7Qona/K7od];Bonk^kP01oo_kn`001Oooool00ol0
003oooooooooo`0@ooooo`03onGUiOoFe]Kono_k00?ooooo00Oon_[jooCdm?ooooooooooon_[joo@
d=3onOWi00Cooooo00?omOGeon7QhOooool00oooool00ooclo?odM7Aoo?cl`04ooooo`03onGUiOoF
e]Kono_k013ooooo00?o0000ooooooooool0:Oooool00on1PH7oc/k>ooooo`07ooooo`03o`000?oo
oooooooo01_ooooo00?oiNGUomKFe_okno/00oooool01oojn_[om?Cdoooooooooooojn_[om3@d?oi
nOT01?ooool00ooemOGohN7Qooooo`03ooooo`03oo?clooAdM7olo?c00Cooooo00?oiNGUomKFe_ok
no/0;Oooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knbWooooo00?oPH61olk>c_ooool01oooool0
0ol0003oooooooooo`0Uooooo`03onGUiOoFe]Kono_k00Cooooo00?oh^;Rooclo?ooool02_ooool0
0oolo?coe]KFonCTi004ooooo`03oo?clooAdM7olo?c02Kooooo00Go0000ohN7Qona/K7od];Bonk^
kP01oo_kn`001Oooool00ol0003oooooooooo`06ooooo`03oclo?onSXj?ooooo00;ooooo023oM7Ad
o`000?o[jn_ooooooemOGol:2P[o:BTYoaXJ6_o=cLgoooooomkNg_lG5aOoIfMWoooooomhN7So2PX:
oc0`<?lO7aoo`<30oooooomKFe_oCDe=ob<S8olG5aOo?clooo;bl_ooooooZj^[o`X:2_l`<33o1@D5
ohn?S`;ooooo00coGemOo`X:2_lY:BWo6QXJolg=cOooooooJVYZoi6ATOooooooinOWo`l?3onc/k<8
ooooo`03o`000?oooooooooo02Wooooo00Go3`l?o`P82?lQ8B7oS8b<onWYj@05ooooo`03o`000?oo
oooooooo017ooooo00?o?clooj>SXoooool00_ooool08?mdM7Co0000on_[joooooooGemOo`X:2_lY
:BWo6QXJolg=cOoooooog]kNoaLG5omWIfOoooooogQhN?l:2P[o<30`oalO7oo0`<3ooooooe]KFom=
CDgo8b<SoaLG5olo?cool_;boooooon[Zj_o2PX:oc0`<?l51@GoShn?0_ooool05omOGeoo2PX:obTY
:OlJ6Q[ocLg=oooooomZJV[oTI6AoooooooWinOo3`l?ok>c/on=SHgoEEEEooooooo[jn_o10@4oi6A
TOoooooo/K6aoc8b<_ooooooU9BD00Go000000?oi>CTooooooooool04_ooool01_l0003oQhN7ok6a
/OoBd];ok^k^oo_knbWooooo00Go3`l?o`P82?lQ8B7oS8b<onWYj@05ooooo`03o`000?oooooooooo
01_ooooo00OoC4a<o`000?l0003o0P82oc0`<?moOgooo_kn00;ooooo00goGemOo`X:2_lY:BWo6QXJ
olg=cOoooooohn?Sob`/;?lP823o8R8Roi2@T?ooooooSHf=00?o000001?o3Ph>od92@_oFe]Kooooo
on7QhOlX:2So820Poa8B4_m8B4Som?Cdoooooon[Zj_o2PX:oc0`<?l51@GoShn?ooooooo0`<3o?3`l
00;ooooo00?oBd];oeiNG_ooool07Oooool01Ol0003oQhN7ok6a/OoBd];ok^k^007ono_k0005oooo
o`03o`000?oooooooooo00Kooooo03;o?clooj>SXoooooooooooolk>c_l>3Pko0000on_[jooDe=Co
9BDUon[Zj_ono_koRHV9oe=CDoooooooZJVYod51@Ooooooo_[jnoa<C4oo[jn_ooooookNg]olV9RKo
o_knoe]KFolm?Cgoo?clooGemOm=CDgoXJ6QoooooolZ:R[o^[Zjooooooo@d=3o5ADEooKfm_oDe=Co
9BDUon[Zj_ono_koRHV9oe=CDoooooooJVYZoi6ATOooooooF5QHoeUIF@Wooooo00?o0000oooooooo
ool0:Oooool02?l?3`oo0000o`000?l92@Wo1`L7od51@On^[Zkon_[j0_ooool00ol0003ooooooooo
o`0Aooooo`0ooclo?onSXj?oooooooooooo>c/ko3Ph>o`000?o[jn_oe=CDobDU9OoZj^[oo_knohV9
ROmCDe?oooooojVYZOm1@D7ooooookjn__lC4a?ojn_[oooooong]kOo9RHVookno_mKFe_o?Cdmoocl
o?oemOGoCDe=oj6QXOoooooo:RXZokZj^_ooooood=3@oaDE5Oofm_Koe=CDobDU9OoZj^[oo_knohV9
ROmCDe?oooooofYZJ_nATI7ooooooeQHF?mIFEWoooooohf=SOmEEEGooooooiRHV?lW9bOo>SXjoooo
oona/K7o<S8boooooonDU9Co?clo00ConOWi5Oooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knbWo
oooo00So3`l?o`000?l0003o2@T9o`L71om1@D7o[Zj^oo[jnP;ooooo00?o0000ooooooooool06ooo
ool05om<C4coQhN7ooooooomoOgoclo?obTY:OmlO7coooooomCDe?lU9BGoj^[Zookno_n9RHWoDe=C
oooooommOGgoIVIVoo_knoo^k^ko6a/Kon_[jon=SHgoCTi>00;ooooo01Ooh>3PofYZJ_lY:BWooooo
ogmoOomYJFWono_kono_kom3@d?oZJVYoooooolZ:R[o^[Zjooooooo@d=3o5ADEooKfm_o0`<3o?3`l
oooooon][Jgo5QHFong]k@0Nooooo`05o`000?n7QhOo/K6aom;Bd_o^k^h00Ookno/000Gooooo00?o
0000ooooooooool01_ooool02_lo?cooXj>Sooooooolo?co<c<cohZ:R_l0003ojn_[oh61POm_Kfl2
ooooo`08onc/k?l>3Pkon_[jojJVY_m8B4SoooooogmoOom3@d<4olc<c003ooShn?mKFe_oT92@00;o
oooo00CoXj>SoeIFE_oGemOo6QXJ0oooool01?m2@T;o/k>coh61POm_Kfl2ooooo`08onc/k?l>3Pko
n_[jofYZJ_mIFEWo]kNgoa@D5?oZj^X9ooooo`03o`000?n0P83oP82002WoP82000?o2PX:o`000?l0
00000ol000001Ol=3@go30`<ofMWIoo>c/ko000001?ooooo00[o?clooj>SXoooooooo?cloc<c<on:
RX[o0000on_[jon1PH7oKfm_0_ooool02?o/k>co3Ph>oo[jn_nVYZKoB4Q8oooooomoOgoo@d=31?o<
c<`00oohn?SoFe]Koi2@T002ooooo`04oj>SXomFEUKoemOGoaXJ6P?ooooo00Co@T92ok>c/on1PH7o
Kfm_0_ooool05Oo/k>co3Ph>oo[jn_mZJV[oFEUIokNg]olD51Coj^[Zoooooon=SHgoEEEEoooooom1
@D7o/K6aoaTI6OoShn?o/K6aoc8b<_ooooooU9BDod10@00Iooooo`06o`000?m3@d?oF5QHofUYJOmg
MgOoOGem:On0P8000ol:2P[o0000o`000003o`000005o`d=3Ol<30coIfMWolk>c_l000007Oooool0
0om<C4coQhN7ooooo`02ooooo`05om?Cdol51@GomoOgoh61POm_Kfl00_ooool01Oo/k>co3Ph>oo[j
n_lZ:R[o_kno00;ooooo00Cof=SHong]kOn=SHgoCTi>0oooool01Oobl_;o0000onKVi_l/;2coa<C4
00;ooooo00CoV9RHoeeMGOoGemOo6QXJ0oooool01om2@T;o/k>col30`?lL71cofMWIoa/K6onYZJT0
7oooool01Ol0003oQhN7ok6a/OoBd];ok^k^007ono_k0005ooooo`03o`000?oooooooooo00Kooooo
00[o?clooj>SXoooooooSXj>oc@d=?ofm_Ko0000on_[jomZJV[oLg=c0_ooool02?omoOgo2@T9om_K
fonVYZKoB4Q8oooooomnOWko820P0omLG5`01?l20P;oiNGUoe]KFonCTi<2ooooo`04okRh^?lf=SKo
_knooahN7P?ooooo00CoG5aLohJ6Q_mZJV[oLg=c0_ooool01oomoOgo2@T9om_KfomZJV[o4a<Co`D5
1OnSXj<02_ooool00ol0003oOgmoogmoO`0YogmoO`03o`X:2_l0003o000000?o000000Go3@d=o`/;
2omTI6Coc<c<o`00000Cooooo`0:oclo?onSXj?oooooohj>S_ld=3Com_Kfo`000?o[jn_oJVYZog=c
L`;ooooo00SooOgmo`T92OoKfm_oYZJVodQ8B?ooooooOWinob0P80?oG5aL00Co0P82onGUiOmKFe_o
Ti>C0_ooool01?nh^;So=SHfokno_olN7Qh3ooooo`04oeaLG?n6QXKoJVYZog=cL`;ooooo00OooOgm
o`T92OoKfm_oJVYZoa<C4ol51@GoXj>S00;ooooo00coSHf=oeEEEOoWinOo4a<Coo[jn_m]KFgoSHf=
ok6a/Olb<S;ooooooiBDU?m0@40Iooooo`06o`000?m3@d?oF5QHofQXJ?mfMWKoOGem:OmoOgl00ol:
2P[o0000o`000003o`000005o`d=3Ol;2`_oI6ATolc<c?l000007Oooool00om<C4coQhN7ooooo`03
ooooo`04ob<S8oo8b<SoJVYZog=cL`;ooooo00GooOgmo`T92OoKfm_o5ADEol?3``04ooooo`0:ohf=
SOm>CTkoooooooooooobl_;oSHf=obd];Ooooooo5ADEolS8b0;ooooo00Co/[:boc0`<?no_koo7QhN
0oooool01_mLG5coQXJ6ol30`?l@413o2@T9ode=CB3ooooo00Go0000ohN7Qona/K7od];Bonk^kP01
oo_kn`001Oooool00ol0003oooooooooo`06ooooo`0Koclo?onSXj?oh>3Po`h>3_o=cLgon?Sho`00
0?o[jn_oX:2Poc0`<?okno_oooooolg=cOl;2`_on_[jojJVY_m8B4SooooookRh^?lI6AWono_koooo
ooo6a/Ko5ADEoo_knomKFe_oATI600;ooooo01GoLg=cogmoOoo/k>co2@T9omKFe_ooooooo?clobHV
9_n`/;3oX:2Poc0`<?okno_oooooolg=cOl;2`_on_[jofYZJ_n>SXkoFEUIoeQHF?okno/02Oooool0
0ol0003oooooooooo`0Yooooo`08o`l?3ol0003o0000o`T92Ol71`Oo?cloojb/[?oinOT2ooooo`03
o`000?oooooooooo017ooooo01_o?clooj>SXooPh>3o3Ph>olg=cOohn?So0000on_[jonPX:3o<30`
oo_knooooooocLg=o`/;2oojn_[oYZJVodQ8B?oooooo^;RhoaTI6Ookno_oooooolK6a_lE5AGono_k
oe]KFom6ATH00_ooool08_mcLg?oOgmoonc/k?l92@Woe]KFooooooolo?co9RHVok2`/?nPX:3o<30`
oo_knooooooocLg=o`/;2oojn_[oJVYZohj>S_mIFEWoF5QHoo_knoooooooSHf=oeEEEOnCTi?oHV9R
ooooooo3`l?o=cLgok6a/Olb<S;ooooooiBDU?m0@40Iooooo`06o`000?n7QhOo/K6aom;Bd_o^k^ko
no_k:Oooool02?l?3`oo0000o`000?l92@Wo1`L7oclo?on/[:conOWi0_ooool00ol0003ooooooooo
o`0Kooooo`03oda<C?n7QhOooooo00?ooooo00_o9BDUoj2PX?nPX:3o<30`oo_knooooooocLg=o`/;
2oojn_[oBDU9ohF5Q@02ooooo`0<odm?CooEeMGoSHf=o`@41?l>3Pko3@d=o`000?lH61Sof=SHoooo
oom:BT[oPH610_ooool03_mhN7SoFe]Konc/k?l92@Woe]KFooooooolo?co9RHVok2`/?o0`<3o?3`l
ojNWYolT92Cog]kN7oooool01Ol0003oQhN7ok6a/OoBd];ok^k^007ono_k0005ooooo`03o`000?oo
oooooooo00Kooooo03?o?clooj>SXom:BT[oL71`ooooooohn?So0000on_[jookno_o?ShnobDU9Omd
M7Co8B4QoiRHV?oRh^;oADE5oahN7_nDU9CooooooeeMGOlV9RKoFUYJo`T92OnPX:3ooooooe]KFolT
92Co>SXjod];Bol<30coeMGEoooooon>SXko30`<ofa/K?m0@43oB4Q8oogmoOokno_o?ShnobDU9Omd
M7Co8B4QoiRHV?ooooooJVYZoi6ATOolo?coG5aLoeADE?ojn_X02?ooool00ol0003oooooooooo`0Y
ooooo`05o`l?3ol92@Wo7alOohZ:R_oXj>P01Oooool00ol0003oooooooooo`0Aooooo`0ooclo?onS
Xj?oBTY:og1`L?oooooon?Sho`000?o[jn_ono_kochn?_lU9BGoM7Adob4Q8OnHV9Soh^;RodE5AOlN
7QkoU9BDoooooomMGEgo9RHVoeYJF_l92@WoX:2PoooooomKFe_o92@TocXj>_m;Bd_o30`<omGEeOoo
ooooSXj>o``<3?m/K6co@410odQ8B?omoOgono_kochn?_lU9BGoM7Adob4Q8OnHV9SoooooofYZJ_nA
TI7oo?cloeaLG?mDE5Con_[johf=SOmGEeOo?3`lokVi^Oooooooo_knoa/K6onCTi?o<S8boooooonD
U9Co@41001Wooooo00Ko0000ohN7Qona/K7od];Bonk^k_okno/Yooooo`05o`l?3ol92@Wo7alOohZ:
R_oXj>P01Oooool00ol0003oooooooooo`0Kooooo`03oda<C?n7QhOooooo00;ooooo01;oi^KVo`00
0?nk^k_ono_kochn?_lU9BGoM7Adob4Q8OnHV9Soooooolo?colI6AWoIfMWodM7Aolh>3Soooooohf=
SOm>CTh2ooooo`0GonSXj?lY:BWoTY:BoooooooAdM7o51@Dode=COmVIVKo6QXJom[Jf_ooooooSXj>
o``<3?m/K6co@410odQ8B?omoOgo`<30oc`l??ooooooZZZZob8R8_oKfm/07_ooool01Ol0003oQhN7
ok6a/OoBd];ok^k^007ono_k0005ooooo`03o`000?oooooooooo00Kooooo01;o?clood];BolL71co
lo?cooooooohn?So0000on_[jooooooono_kok>c/onHV9Sodm?Cooooooobl_;oN7Qhoc@d=?o=cLd2
ooooo`03olC4a?nTY:Cog]kN00;ooooo00GoFe]KoifMWOnn_[koWinOon3Ph003ooooo`04olk>c_nH
V9So][JfooknoP;ooooo00Cono_kok>c/onHV9Sodm?C0_ooool01_mZJV[oTI6AooooooomoOgo^k^k
onOWi`Sooooo00?o0000ooooooooool0:Oooool00omoOgooc<c<ooooo`07ooooo`03o`000?oooooo
oooo017ooooo01;o?clood];BolL71colo?cooooooohn?So0000on_[jooooooono_kok>c/onHV9So
dm?Cooooooobl_;oN7Qhoc@d=?o=cLd2ooooo`03olC4a?nTY:Cog]kN00;ooooo00GoFe]KoifMWOnn
_[koWinOon3Ph003ooooo`04olk>c_nHV9So][JfooknoP;ooooo00Cono_kok>c/onHV9Sodm?C0_oo
ool02_mZJV[oTI6AooooooomoOgo^k^konOWion=SHgo?ShnoaDE5Oolo?`2ooooo`06og1`L?m0@43o
<S8boooooonDU9Co@4106Oooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knbWooooo00?oOgmoolc<
c?ooool01oooool00ol0003oooooooooo`0Kooooo`03oda<C?n7QhOooooo00;ooooo00SoVi^Koa@D
5?oclo?ooooooo_knonc/k?oV9RHom?Cd`?ooooo00OoiNGUoinOWonk^k_on_[joooooon=SHgoCTi>
00?ooooo00SoLG5aodi>C_ooooooooooonSXj?nRXZ;oXj>Song]k@?ooooo00Ooc/k>oiRHV?nf][Ko
o_knooooooo0`<3o?3`l00;ooooo0_o@d=0Nooooo`05o`000?n7QhOo/K6aom;Bd_o^k^h00Ookno/0
00Gooooo00?o0000ooooooooool01_ooool00olo?coo0000ojn_[`02ooooo`03ooShn?l0003ojn_[
00Oooooo00?oYZJVodQ8B?ooool01oooool00omKFe_oWIfMooooo`0Aooooo`03ofYZJ_nATI7ooooo
00_ooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`0Aooooo`03oclo?ol0003o[jn_
00;ooooo00?on?Sho`000?o[jn/01oooool00onVYZKoB4Q8ooooo`07ooooo`03oe]KFonMWIgooooo
017ooooo00?oJVYZoi6ATOooool00oooool00on=SHgo0`<3ofIVIP03ooooo`06olK6a_l20P;o<S8b
oooooonDU9Co@4106Oooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knc?ooooo00?o0000oooooooo
ool06oooool01om<C4coDE5Aoi^KVonFUYKoJFUYo`d=3OnZZZX03_ooool01on=SHgo<C4aoj:RX_nQ
XJ7oQXJ6o`T92OnDU9@03_ooool00oo0`<3o?3`looooo`0Qooooo`05o`000?n7QhOo/K6aom;Bd_o^
k^h00Ookno/000Gooooo00?o0000ooooooooool01_ooool00on:RX[oPH61ooooo`02ooooo`03oo_k
nomTI6Colo?c00Oooooo00?ooOgmoo[jn_ooool01oooool00onGUiOo`L71ooooo`0Aooooo`03ojFU
YOnm_Kgooooo00_ooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`0Aooooo`03ohZ:
R_n1PH7ooooo00;ooooo00?ono_kofATI?oclo<01oooool00oomoOgon_[jooooo`07ooooo`03oiNG
Uoo1`L7ooooo017ooooo00?oYJFUokfm_Oooool00oooool00onj^[[oI6ATolg=c@03ooooo`06ookn
o_m[Jf_oPh>3oooooonn_[koRh^;6Oooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knc?ooooo00?o
0000ooooooooool06oooool01_nCTi?oI6ATofATI?mUIFGoR8R8om?Cd`oooooo00Ko^[ZjofATI?mT
I6CoI6ATog5aLOn/[:`?ooooo`03omWIfOn9RHWooooo027ooooo00Go0000ohN7Qona/K7od];Bonk^
kP01oo_kn`001Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo03?ooooo00?o0000
ooooooooool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knc?ooooo00?o0000ooooooooool0
JOooool01Ol0003oQhN7ok6a/OoBd];ok^k^007ono_k0005ooooo`03o`000?oooooooooo047ooooo
00?o0000ooooooooool0<oooool00ol0003oooooooooo`1Yooooo`06o`000?n7QhOo/K6aom;Bd_o^
k^kono_k4?ooool00oolo?coemOGooclo00Pooooo`03o`000?oooooooooo06Wooooo00Go0000ohN7
Qona/K7od];Bonk^kP01oo_kn`001Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo
03?ooooo00?o0000ooooooooool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_kn`Kooooo00?o
cLg=oa0@4?oKfm/00_ooool03?nn_[ko3`l?on7QhOoemOGoIFEUocLg=om9BDWo<S8boeaLG?ogmoOo
e]KFo`410@?o3`l?00Go9RHVooooooooooooe]KFoa@D500Dooooo`03o`000?oooooooooo06Wooooo
00Go0000ohN7Qona/K7od];Bonk^kP01oo_kn`001Oooool00ol0003oooooooooo`11ooooo`03o`00
0?oooooooooo03?ooooo00?o0000ooooooooool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_k
n`Oooooo013oQHF5oc/k>oomoOgomOGeob8R8_nPX:3ooooooh20P?mBDU;oo?clooooooomoOgoCTi>
oiBDU?oFe]Ko5aLG1_ooool00ooFe]Ko51@Dooooo`0Cooooo`03o`000?oooooooooo06Wooooo00Go
0000ohN7Qona/K7od];Bonk^kP01oo_kn`001Oooool00ol0003oooooooooo`11ooooo`03o`000?oo
oooooooo03?ooooo00?o0000ooooooooool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_kn`Oo
oooo00GooOgmoc/k>on<S8coL71`oe1@D002ooooo`03oj:RX_o<c<cooooo00;ooooo00CoDU9BoiBD
U?oFe]Ko5aLG1_ooool00ooFe]Ko51@Dooooo`0Cooooo`03o`000?oooooooooo06Wooooo00Go0000
ohN7Qona/K7od];Bonk^kP01oo_kn`001Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooo
oooo03?ooooo00?o0000ooooooooool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_kn`Sooooo
00Cog]kNoaDE5OlH61SojNWY0oooool02?ono_ko`l?3ogmoOol^;Rko71`LooGemOoFe]Ko5aLG1_oo
ool00ooFe]Ko51@Dooooo`0Cooooo`03o`000?oooooooooo06Wooooo00Go0000ohN7Qona/K7od];B
onk^kP01oo_kn`001Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo03?ooooo00?o
0000ooooooooool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_kn`Sooooo00Coj>SXoaDE5OlO
7aool?3`0_ooool02Oolo?co<30`obXZ:_m_Kfoo[Zj^ooWinOooooooe]KFoaLG5`06ooooo`03omKF
e_lD51Cooooo01?ooooo00?o0000ooooooooool0JOooool01Ol0003oQhN7ok6a/OoBd];ok^k^007o
no_k0005ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0<oooool00ol0003ooooo
ooooo`1Yooooo`06o`000?n7QhOo/K6aom;Bd_o^k^kono_k2?ooool01?m<C4coJVYZof][JomNGUh2
ooooo`03ojj^[_lk>c_ooooo00;ooooo00Co[jn_omoOgooFe]Ko5aLG1_ooool00ooFe]Ko51@Doooo
o`0Cooooo`03o`000?oooooooooo06Wooooo00Go0000ohN7Qona/K7od];Bonk^kP01oo_kn`001Ooo
ool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool0JOoo
ool01_l0003oQhN7ok6a/OoBd];ok^k^oo_kn`Oooooo013oW9bLob4Q8Ooclo?om?Cdob4Q8On^[Zko
ooooon;Rh_lZ:R[ojNWYoogmoOnk^k_o3Ph>om[Jf_oFe]Ko5aLG1?ooool01?oemOGolo?col_;bolC
4a<2oo?cl`03ooShn?oooooooooo00oooooo00?o0000ooooooooool0JOooool01Ol0003oQhN7ok6a
/OoBd];ok^k^007ono_k0005ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0<ooo
ool00ol0003oooooooooo`1Yooooo`06o`000?n7QhOo/K6aom;Bd_o^k^kono_k1_ooool00ooYjNWo
:BTYokjn_P02ooooo`0<okfm_Ola<C7olO7aoooooonFUYKo<c<coaLG5olk>c_oXZ:RoooooooKfm_o
<C4a1?ooool00om4A4Co71`Loa`L7003oa`L7003og]kNooooooooooo00oooooo00?o0000oooooooo
ool0JOooool01Ol0003oQhN7ok6a/OoBd];ok^k^007ono_k0005ooooo`03o`000?oooooooooo047o
oooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`1Yooooo`06o`000?n7QhOo/K6aom;B
d_o^k^kono_k4Oooool00ooinOWoooooooooo`0Oooooo`03o`000?oooooooooo06Wooooo00Go0000
ohN7Qona/K7od];Bonk^kP01oo_kn`001Oooool00ol0003oooooooooo`11ooooo`03o`000?oooooo
oooo03?ooooo00?o0000ooooooooool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knc?ooooo
00?o0000ooooooooool0JOooool01Ol0003oQhN7ok6a/OoBd];ok^k^007ono_k0005ooooo`03o`00
0?oooooooooo047ooooo00?o0000ooooooooool0<oooool00ol0003oooooooooo`1Yooooo`06o`00
0?n7QhOo/K6aom;Bd_o^k^kono_k<oooool00ol0003oooooooooo`1Yooooo`05o`000?n7QhOo/K6a
om;Bd_o^k^h00Ookno/000Gooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`0coooo
o`03o`000?oooooooooo06Wooooo00Ko0000ohN7Qona/K7od];Bonk^k_okno/cooooo`03o`000?oo
oooooooo06Wooooo00Go0000ohN7Qona/K7od];Bonk^kP01oo_kn`001Oooool00ol0003ooooooooo
o`11ooooo`03o`000?oooooooooo03?ooooo00?o0000ooooooooool0JOooool01_l0003oQhN7ok6a
/OoBd];ok^k^oo_knc?ooooo00?o0000ooooooooool0JOooool01Ol0003oQhN7ok6a/OoBd];ok^k^
007ono_k0005ooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0<oooool00ol0003o
ooooooooo`1Yooooo`06o`000?n7QhOo/K6aom;Bd_o^k^kono_k<oooool00ol0003oooooooooo`1Y
ooooo`05o`000?n7QhOo/K6aom;Bd_o^k^h00Ookno/000Gooooo00?o0000ooooooooool0@Oooool0
0ol0003oooooooooo`0cooooo`03o`000?oooooooooo06Wooooo00Ko0000ohN7Qona/K7od];Bonk^
k_okno/cooooo`03o`000?oooooooooo06Wooooo00Go0000ohN7Qona/K7od];Bonk^kP01oo_kn`00
1Oooool00ol0003oooooooooo`0cooooo`03on7QhOo=cLgocLg=00_ocLg=00?o0000ooooooooool0
<oooool00ol0003oooooooooo`1Yooooo`06o`000?n7QhOo/K6aom;Bd_o^k^kono_k<oooool00ol0
003oooooooooo`1Yooooo`05o`000?n7QhOo/K6aom;Bd_o^k^h00Ookno/000Gooooo00?o0000oooo
ooooool0<oooool00omVIVKo7QhNoc8b<P0:oc8b<P03oa4A4OlL71cooooo03Cooooo00?o0000oooo
ooooool0JOooool01_l0003oQhN7ok6a/OoBd];ok^k^oo_knc?ooooo00?o0000ooooooooool0JOoo
ool01Ol0003oQhN7ok6a/OoBd];ok^k^007ono_k0005ooooo`03o`000?oooooooooo03?ooooo00?o
IVIVoiVIVOooool02Oooool00oo=cLgo5ADEolk>cP0eooooo`03o`000?oooooooooo06Wooooo00Ko
0000ohN7Qona/K7od];Bonk^k_okno/cooooo`03o`000?oooooooooo06Wooooo00Go0000ohN7Qona
/K7od];Bonk^kP01oo_kn`001Oooool00ol0003oooooooooo`0cooooo`03ofIVI_nIVIWooooo00So
oooo00?oiNGUoadM7On_[jl0=_ooool00ol0003oooooooooo`1Yooooo`06o`000?n7QhOo/k>comGE
eOobl_;oo?cl<oooool00ol0003oooooooooo`1Yooooo`05o`000?n7QhOo/k>comGEeOobl_800Ool
o?`000Gooooo00?o0000ooooooooool0<oooool00omVIVKoVIVIooooo`07ooooo`03ooGemOlc<c?o
QhN703Oooooo00?o0000ooooooooool0JOooool01Ol0003oSHf=ok^k^ooQhN7ooOgm03Cooooo00?o
0000ooooooooool0JOooool01Ol0003oSHf=ok^k^ooQhN7ooOgm007ooooo0005ooooo`03o`000?oo
oooooooo03?ooooo00?oIVIVoiVIVOooool01_ooool00oono_koE5ADoemOG`0hooooo`03o`000?oo
oooooooo06Wooooo00Co0000oi6ATOo4a<CoiNGU=Oooool00ol0003oooooooooo`1Yooooo`04o`00
0?nATI7oa<C4onGUi@;ooooo0005ooooo`03o`000?oooooooooo03?ooooo00?oIVIVoiVIVOooool0
1_ooool00omlO7co?3`looWin@0hooooo`03o`000?oooooooooo06Wooooo00?o0000okBd]?oemOD0
=_ooool00ol0003oooooooooo`1Yooooo`03o`000?nd];ComOGe00?ooooo0005ooooo`03o`000?oo
oooooooo03?ooooo00?oIVIVoiVIVOooool01Oooool00onTY:Co8R8Ron_[j`0iooooo`03o`000?oo
oooooooo06Wooooo00?o0000onc/k?ooool0=_ooool00ol0003oooooooooo`1Yooooo`03o`000?o/
k>cooooo00?ooooo0005ooooo`03o`000?oooooooooo03?ooooo00?oIVIVoiVIVOooool01?ooool0
0oo6a/Ko5QHFomCDe00jooooofgo0000>?oooom]o`0000Gooooo0005ooooo`03o`000?oooooooooo
03?ooooo00?oIVIVoiVIVOooool00oooool00ooPh>3o6QXJokNg]`3ooooooe?ooooo0005ooooo`03
o`000?oooooooooo03?ooooo00?oIVIVoiVIVOooool00_ooool00oobl_;o;Bd]oi6AT@3ooooooeCo
oooo0005ooooo`03o`000?oooooooooo03?ooooo00OoIVIVoiVIVOoooooooooooogmoOm<C4coJ6QX
0?ooooooEOooool000Gooooo00?o0000ooooooooool0<oooool01omVIVKoVIVIooooooooooooLW9b
od=3@ookno/0oooooomEooooo`001Oooool00ol0003oooooooooo`0cooooo`06ofIVI_nIVIWooooo
oi^KVolW9bOok^k^oooooomFooooo`001Oooool00ol0003oooooooooo`0cooooo`05ofIVI_nIVIWo
_knooaLG5ooJf]X0oooooomGooooo`001Oooool00ol0003oooooooooo`0cooooo`04ofIVI_mdM7Co
5aLGokjn__ooooooF?ooool000Gooooo00?o0000ooooooooool0<oooool00omVIVKo0@41oiZJVP3o
oooooeWooooo0005ooooo`03oclo?ol0003o000003Co000000?oLG5aooooooooool0oooooomHoooo
o`00oooooonGooooo`00oooooonGooooo`00oooooonGooooo`00oooooonGooooo`00oooooonGoooo
o`00\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{406, 91},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->{"NBMLSymbolicXML", "i:67", "b:4.3"}],

Cell[TextData[{
  "However, you can easily perform the same transformation completely within \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " by using SymbolicXML as an intermediary. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\[CloseCurlyQuote]s pattern matching and symbolic processing can make the \
task quite easy. A schematic of the process might look like the following."
}], "Text",
  CellTags->{"NBMLSymbolicXML", "i:67", "b:4.3"}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004`0000d2000`400?l00000o`00003ooooooola
ooooo`00oooooolaooooo`00oooooolaooooo`00oooooolaooooo`006ooooom4o`000003o`410Ooo
oooooooo0<kooooo000Kooooo`03o`000?oooooooooo043ooooo00?oo_kno`000?ooool0coooool0
01_ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`3>ooooo`006oooool00ol0003o
ooooooooo`11ooooo`03o`000?oooooooooo0<kooooo000Kooooo`03o`000?oooooooooo047ooooo
00?o0000ooooooooool0J?ooool00oolo?cono_koo_kn`1Poo_kn`7ooOgm0Oooool1ooooo`006ooo
ool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo06Oooooo00?ooOgmoo;bl_o^k^h0H?o^
k^h00oo`l?3ono_kooooo`01ooooo`006oooool00ol0003oooooooooo`11ooooo`03o`000?oooooo
oooo06Kooooo00?oi^KVon7QhOoEeMD0H?oBd]800ooGemOok^k^oo_kn`02ooooo`006oooool00ol0
003oooooooooo`11ooooo`03o`000?oooooooooo06Gooooo00ComOGeolC4a?nk^k_o/k>cGona/K40
1?nh^;Sod];Bonk^k_okno/2ooooo`006oooool00ol0003oooooooooo`11ooooo`03o`000?oooooo
oooo06Cooooo00GokNg]okBd]?nATI7oSHf=ohN7Q`1NohJ6QP05ohn?Sona/K7od];Bonk^k_okno/0
0_ooool001_ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1SooooofCo000000Go
QXJ6ok6a/OoBd];ok^k^oo_kn`02ooooo`006oooool00ol0003oooooooooo`11ooooo`03o`000?oo
oooooooo06?ooooo00?o0000ooooooooool0Goooool01oono_ko0000ohJ6Q_na/K7od];Bonk^k_ok
no/00_ooool001_ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1Sooooo`03o`00
0?oooooooooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`006oooool00ol0003o
ooooooooo`11ooooo`03o`000?oooooooooo06?ooooo00?o0000ooooooooool0H?ooool01_l0003o
QXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`000?oooooooooo047ooooo00?o0000oooo
ooooool0Hoooool00ol0003oooooooooo`1Pooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k0_oo
ool001_ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1Sooooo`03o`000?oooooo
oooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`006oooool00ol0003ooooooooo
o`11ooooo`03o`000?oooooooooo06?ooooo00?o0000ooooooooool0H?ooool01_l0003oQXJ6ok6a
/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0
Hoooool00ol0003oooooooooo`1Pooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k0_ooool001_o
oooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1Sooooo`03o`000?oooooooooo063o
oooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`006oooool00ol0003oooooooooo`11oooo
o`03o`000?oooooooooo06?ooooo00?o0000ooooooooool0H?ooool01_l0003oQXJ6ok6a/OoBd];o
k^k^oo_kn`;ooooo000Kooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0Hoooool0
0ol0003oooooooooo`1Pooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o
0000ooooooooool0@Oooool00ol0003oooooooooo`1Sooooo`03o`000?oooooooooo063ooooo00Ko
0000ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`006oooool00ol0003oooooooooo`11ooooo`03o`00
0?oooooooooo06?ooooo00?o0000ooooooooool0H?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_k
n`;ooooo000Kooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0Hoooool00ol0003o
ooooooooo`1Pooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o0000oooo
ooooool0@Oooool00ol0003oooooooooo`1Sooooo`03o`000?oooooooooo063ooooo00Ko0000ohJ6
Q_na/K7od];Bonk^k_okno/2ooooo`006oooool00ol0003oooooooooo`11ooooo`03o`000?oooooo
oooo06?ooooo00?o0000ooooooooool0H?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo
000Kooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0Hoooool00ol0003ooooooooo
o`1Pooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o0000ooooooooool0
@Oooool00ol0003oooooooooo`1Sooooo`03o`000?oooooooooo063ooooo00Ko0000ohJ6Q_na/K7o
d];Bonk^k_okno/2ooooo`006oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo06?o
oooo00?o0000ooooooooool0H?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Koooo
o`03o`000?oooooooooo047ooooo00?o0000ooooooooool0Hoooool00ol0003oooooooooo`1Poooo
o`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o0000ooooooooool0@Oooool0
0ol0003oooooooooo`1Sooooo`03o`000?oooooooooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^
k_okno/2ooooo`006oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo06?ooooo00?o
0000ooooooooool0H?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`00
0?oooooooooo047ooooo00?o0000ooooooooool0Hoooool00ol0003oooooooooo`1Pooooo`06o`00
0?n6QXKo/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o0000ooooooooool0@Oooool00ol0003o
ooooooooo`1Sooooo`03o`000?oooooooooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2
ooooo`006oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo06?ooooo00?o0000oooo
ooooool0H?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`000?oooooo
oooo047ooooo00?o0000ooooooooool0Hoooool00ol0003oooooooooo`1Pooooo`06o`000?n6QXKo
/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o0000ooooooooool0@Oooool00ol0003ooooooooo
o`1Sooooo`03o`000?oooooooooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`00
6oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo06?ooooo00?o0000ooooooooool0
H?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`000?oooooooooo013o
oooo00?oiNGUomKFe_okno/00oooool01oojn_[om?Cdoooooooooooojn_[om3@d?oinOT01?ooool0
0ooemOGohN7Qooooo`03ooooo`03oo?clooAdM7olo?c00Cooooo00?oiNGUomKFe_okno/04?ooool0
0ol0003oooooooooo`1Sooooo`03o`000?oooooooooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^
k_okno/2ooooo`006oooool00ol0003oooooooooo`06ooooo`03oclo?onSXj?ooooo00;ooooo023o
M7Ado`000?o[jn_ooooooemOGol:2P[o:BTYoaXJ6_o=cLgoooooomkNg_lG5aOoIfMWoooooomhN7So
2PX:oc0`<?lO7aoo`<30oooooomKFe_oCDe=ob<S8olG5aOo?clooo;bl_ooooooZj^[o`X:2_l`<33o
1@D5ohn?S`;ooooo00coGemOo`X:2_lY:BWo6QXJolg=cOooooooJVYZoi6ATOooooooinOWo`l?3onc
/k<8ooooo`03o`000?oooooooooo06?ooooo00?o0000ooooooooool0H?ooool01_l0003oQXJ6ok6a
/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`000?oooooooooo00Kooooo03;o?clooj>SXooooooo
ooooolk>c_l>3Pko0000on_[jooDe=Co9BDUon[Zj_ono_koRHV9oe=CDoooooooZJVYod51@Ooooooo
_[jnoa<C4oo[jn_ooooookNg]olV9RKoo_knoe]KFolm?Cgoo?clooGemOm=CDgoXJ6QoooooolZ:R[o
^[Zjooooooo@d=3o5ADEooKfm_oDe=Co9BDUon[Zj_ono_koRHV9oe=CDoooooooJVYZoi6ATOoooooo
F5QHoeUIF@Wooooo00?o0000ooooooooool0Hoooool00ol0003oooooooooo`1Pooooo`06o`000?n6
QXKo/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o0000ooooooooool01_ooool02_lo?cooXj>S
ooooooolo?co<c<cohZ:R_l0003ojn_[oh61POm_Kfl2ooooo`08onc/k?l>3Pkon_[jojJVY_m8B4So
ooooogmoOom3@d<4olc<c003ooShn?mKFe_oT92@00;ooooo00CoXj>SoeIFE_oGemOo6QXJ0oooool0
1?m2@T;o/k>coh61POm_Kfl2ooooo`08onc/k?l>3Pkon_[jofYZJ_mIFEWo]kNgoa@D5?oZj^X9oooo
o`03o`000?oooooooooo06?ooooo00?o0000ooooooooool0H?ooool01_l0003oQXJ6ok6a/OoBd];o
k^k^oo_kn`;ooooo000Kooooo`03o`000?oooooooooo00Kooooo00[o?clooj>SXoooooooSXj>oc@d
=?ofm_Ko0000on_[jomZJV[oLg=c0_ooool02?omoOgo2@T9om_KfonVYZKoB4Q8oooooomnOWko820P
0omLG5`01?l20P;oiNGUoe]KFonCTi<2ooooo`04okRh^?lf=SKo_knooahN7P?ooooo00CoG5aLohJ6
Q_mZJV[oLg=c0_ooool01oomoOgo2@T9om_KfomZJV[o4a<Co`D51OnSXj<02_ooool00ol0003ooooo
ooooo`1Sooooo`03o`000?oooooooooo027ooooo00?oiNGUomKFe_okno/01?ooool00ooRh^;oo?cl
ooooo`0:ooooo`03ooclo?oFe]Koi>CT00Cooooo00?olo?com7AdOoclo<08Oooool01_l0003oQXJ6
ok6a/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`000?oooooooooo00Kooooo01_o?clooj>SXooP
h>3o3Ph>olg=cOohn?So0000on_[jonPX:3o<30`oo_knooooooocLg=o`/;2oojn_[oYZJVodQ8B?oo
oooo^;RhoaTI6Ookno_oooooolK6a_lE5AGono_koe]KFom6ATH00_ooool05OmcLg?oOgmoonc/k?l9
2@Woe]KFooooooolo?co9RHVok2`/?nPX:3o<30`oo_knooooooocLg=o`/;2oojn_[oJVYZohj>S_mI
FEWoF5QHoo_kn`09ooooo`03o`000?oooooooooo06?ooooo00?o0000ooooooooool05oooool01om<
C4co0000o`000?l20P;o<30`ogmoOoono_h00_ooool03OmOGeoo2PX:obTY:OlJ6Q[ocLg=oooooooS
hn?o;2`/ob0P8?lR8R;oT92@oooooon=SHd00ol000004ol>3Pko@T92omKFe_oooooohN7QobPX:?lP
823o4Q8BodQ8B?odm?Cooooooj^[Zol:2P[o<30`o`D51On?Shoooooool30`?ll?3`00_ooool00om;
Bd_oGUiNooooo`0Hooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o0000
ooooooooool01_ooool0<olo?cooXj>SodY:B_m`L73oooooooShn?l0003ojn_[oo_knoln?Sko9BDU
ogAdM?lQ8B7oV9RHon;Rh_m5ADGo7QhNoiBDU?ooooooGEeMobHV9_mJFU[o2@T9oj2PX?ooooooFe]K
ob@T9?lj>S[oBd];o``<3?oEeMGoooooohj>S_l<30coK6a/od10@?m8B4SooOgmoo_knoln?Sko9BDU
ogAdM?lQ8B7oV9RHoooooomZJV[oTI6Aooclo?mLG5coE5ADoo[jnP08ooooo`03o`000?oooooooooo
06?ooooo00?o0000ooooooooool05oooool05om<C4coQhN7ooooooomoOgoclo?obTY:OmlO7cooooo
omCDe?lU9BGoj^[Zookno_n9RHWoDe=CoooooommOGgoIVIVoo_knoo^k^ko6a/Kon_[jon=SHgoCTi>
00;ooooo01Ooh>3PofYZJ_lY:BWoooooogmoOomYJFWono_kono_kom3@d?oZJVYoooooolZ:R[o^[Zj
ooooooo@d=3o5ADEooKfm_o0`<3o?3`loooooon][Jgo5QHFong]k@0Iooooo`06o`000?n6QXKo/K6a
om;Bd_o^k^kono_k0_ooool001_ooooo00?o0000ooooooooool01_ooool04_lo?cooBd];oa`L7?oc
lo?oooooooShn?l0003ojn_[oooooookno_o/k>coiRHV?oCdm?ooooooo;bl_mhN7So=3@dolg=c@;o
oooo00?oa<C4ojBTY?oNg]h00_ooool01OmKFe_oWIfMokjn__nOWiooh>3P00?ooooo00Coc/k>oiRH
V?nf][Koo_kn0_ooool01?okno_o/k>coiRHV?oCdm<2ooooo`06ofYZJ_nATI7ooooooogmoOnk^k_o
inOW2?ooool00ol0003oooooooooo`1Sooooo`03o`000?oooooooooo01Oooooo00?oC4a<ohN7Qooo
ool00_ooool01OoCdm?o1@D5ooOgmon1PH7oKfm_00;ooooo00Gok>c/o`h>3_ojn_[o:RXZokno_`02
ooooo`04omSHf?o]kNgoSHf=odi>CP?ooooo00Gol_;bo`000?oVi^Ko;2`/olC4a002ooooo`04oiRH
V?mMGEgoemOGoaXJ6P?ooooo00Oo@T92ok>c/oo0`<3o71`LomWIfOlK6a_oZJVY01[ooooo00Ko0000
ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`006oooool00ol0003oooooooooo`06ooooo`03oclo?ol0
003o[jn_00;ooooo00?on?Sho`000?o[jn/01oooool00onVYZKoB4Q8ooooo`07ooooo`03oe]KFonM
WIgooooo017ooooo00?oJVYZoi6ATOooool02oooool00ol0003oooooooooo`1Sooooo`03o`000?oo
oooooooo01Oooooo00?oC4a<ohN7Qoooool00oooool01?lS8b?ob<S8ofYZJ_mcLg<2ooooo`05oogm
oOl92@Wofm_KoaDE5Oo3`l<01?ooool02_n=SHgoCTi>ooooooooooool_;bohf=SOl];BgooooooaDE
5Oo8b<P2ooooo`04ok:b/_l`<33o_knooahN7P?ooooo00KoG5aLohJ6Q_o0`<3o410@o`T92Om=CDdK
ooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o0000ooooooooool01_oo
ool00on:RX[oPH61ooooo`02ooooo`03oo_knomTI6Colo?c00Oooooo00?ooOgmoo[jn_ooool01ooo
ool00onGUiOo`L71ooooo`0Aooooo`03ojFUYOnm_Kgooooo00_ooooo00?o0000ooooooooool0Hooo
ool00ol0003oooooooooo`0Gooooo`03oda<C?n7QhOooooo00?ooooo00_o9BDUoj2PX?nPX:3o<30`
oo_knooooooocLg=o`/;2oojn_[oBDU9ohF5Q@02ooooo`0<odm?CooEeMGoSHf=o`@41?l>3Pko3@d=
o`000?lH61Sof=SHoooooom:BT[oPH610_ooool03_mhN7SoFe]Konc/k?l92@Woe]KFooooooolo?co
9RHVok2`/?o0`<3o?3`lojNWYolT92Cog]kN6_ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;o
oooo000Kooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0Hoooool00ol0003ooooo
ooooo`0Gooooo`03oda<C?n7QhOooooo00;ooooo01;oi^KVo`000?nk^k_ono_kochn?_lU9BGoM7Ad
ob4Q8OnHV9Soooooolo?colI6AWoIfMWodM7Aolh>3Soooooohf=SOm>CTh2ooooo`0GonSXj?lY:BWo
TY:BoooooooAdM7o51@Dode=COmVIVKo6QXJom[Jf_ooooooSXj>o``<3?m/K6co@410odQ8B?omoOgo
`<30oc`l??ooooooZZZZob8R8_oKfm/06Oooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo
000Kooooo`03o`000?oooooooooo047ooooo00?o0000ooooooooool0Hoooool00ol0003ooooooooo
o`0Gooooo`03oda<C?n7QhOooooo00;ooooo00SoVi^Koa@D5?oclo?ooooooo_knonc/k?oV9RHom?C
d`?ooooo00OoiNGUoinOWonk^k_on_[joooooon=SHgoCTi>00?ooooo00SoLG5aodi>C_oooooooooo
onSXj?nRXZ;oXj>Song]k@?ooooo00Ooc/k>oiRHV?nf][Koo_knooooooo0`<3o?3`l00;ooooo0_o@
d=0Iooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o0000ooooooooool0
@Oooool00ol0003oooooooooo`1Sooooo`03o`000?oooooooooo01Oooooo00OoC4a<oe5ADOnKVi_o
UYJFofUYJOl=3@goZZZZ00kooooo00OoSHf=oc4a<OnRXZ;oXJ6QohJ6Q_l92@WoU9BD00kooooo00?o
`<30oc`l??ooool07?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`00
0?oooooooooo047ooooo00?o0000ooooooooool0Hoooool00ol0003oooooooooo`0Gooooo`06oi>C
TomTI6CoI6ATofEUIOn8R8Sodm?C3oooool01_nj^[[oI6ATofATI?mTI6CoLG5aojb/[0oooooo00?o
fMWIohV9ROooool07?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`00
0?oooooooooo047ooooo00?o0000ooooooooool0Hoooool00ol0003oooooooooo`1Pooooo`06o`00
0?n6QXKo/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o0000ooooooooool0@Oooool00ol0003o
ooooooooo`1Sooooo`03o`000?oooooooooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2
ooooo`006oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo06?ooooo00?o0000oooo
ooooool0H?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`000?oooooo
oooo047ooooo00?o0000ooooooooool0Hoooool00ol0003oooooooooo`1Pooooo`06o`000?n6QXKo
/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o0000ooooooooool0@Oooool00ol0003ooooooooo
o`1Sooooo`03o`000?oooooooooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`00
6oooool00ol0003oooooooooo`11ooooo`03o`000?oooooooooo06?ooooo00?o0000ooooooooool0
H?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`000?oooooooooo047o
oooo00?o0000ooooooooool0Hoooool00ol0003oooooooooo`1Pooooo`06o`000?n6QXKo/K6aom;B
d_o^k^kono_k0_ooool001_ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1Soooo
o`03o`000?oooooooooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`006oooool0
0ol0003oooooooooo`11ooooo`03o`000?oooooooooo06?ooooo00?o0000ooooooooool0H?ooool0
1_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`000?oooooooooo047ooooo00?o
0000ooooooooool0Hoooool00ol0003oooooooooo`1Pooooo`06o`000?n6QXKo/K6aom;Bd_o^k^ko
no_k0_ooool001_ooooo00?o0000ooooooooool0@Oooool00ol0003oooooooooo`1Sooooo`03o`00
0?oooooooooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`006oooool00ol0003o
ooooooooo`11ooooo`03o`000?oooooooooo06?ooooo00?o0000ooooooooool0H?ooool01_l0003o
QXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`000?oooooooooo047ooooo00?o0000oooo
ooooool0Hoooool00ol0003oooooooooo`1Pooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k0_oo
ool001_ooooo00?o0000ooooooooool0<oooool00ooQhN7ocLg=olg=c@0:olg=c@03olc<c?l0003o
oooo06Cooooo00?o0000ooooooooool0H?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo
000Jooooo`03ookno_l0003ooooo03Cooooo00?oIFEUoahN7_lb<S802_lb<S800olA4A7o7AdMoooo
o`1Tooooo`03o`000?oooooooooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`00
6oooool00ol0003oooooooooo`0cooooo`03ofEUIOnJVY[ooooo00Wooooo00?oc<c<oaDE5Oo?cll0
IOooool00ol0003oooooooooo`1Pooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k0_ooool001_o
oooo00?o0000ooooooooool0<oooool00omUIFGoVYZJooooo`08ooooo`03onGUiOlL71co[jn_06Ko
oooo00?o0000ooooooooool0H?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Koooo
o`03o`000?oooooooooo03?ooooo00?oIFEUoiZJV_ooool01oooool00ooemOGo<c<cohR8R01Woooo
o`03o`000?oooooooooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`006oooool0
0ol0003oooooooooo`0cooooo`03ofEUIOnJVY[ooooo00Kooooo00?oo_knoe=CDomOGel0J?ooool0
0ol0003oooooooooo`1Pooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o
0000ooooooooool0<oooool00omUIFGoVYZJooooo`06ooooo`03og]kNolm?CgonOWi06Sooooo00?o
0000ooooooooool0H?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`00
0?oooooooooo03?ooooo00?oIFEUoiZJV_ooool01Oooool00onSXj?o8R8Ron_[j`1Yooooo`03o`00
0?oooooooooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`006oooool00ol0003o
ooooooooo`0cooooo`03ofEUIOnJVY[ooooo00Cooooo00?oaLG5oaHF5_oEeMD0J_ooool00ol0003o
ooooooooo`1Pooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k0_ooool001_ooooo00?o0000oooo
ooooool0<oooool00omUIFGoVYZJooooo`03ooooo`03on3Ph?lI6AWo]kNg06_ooooo00?o0000oooo
ooooool0H?ooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`;ooooo000Kooooo`03o`000?oooooo
oooo03?ooooo00?oIFEUoiZJV_ooool00_ooool00oobl_;o;2`/oi6AT@1/ooooo`03o`000?oooooo
oooo063ooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`006oooool00ol0003ooooooooo
o`0cooooo`07ofEUIOnJVY[oooooooooooomoOgoBd];ofUYJ@1]ooooo`03o`000?oooooooooo063o
oooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/2ooooo`006oooool00ol0003oooooooooo`0coooo
o`07ofEUIOnJVY[ooooooooooombLW;oA4A4oo_kn`1]ooooo`03o`000?oooooooooo063ooooo00Ko
0000ohN7Qonc/k?oeMGEoo;bl_olo?`2ooooo`006oooool00ol0003oooooooooo`0cooooo`06ofEU
IOnJVY[ooooooiZJV_lW9bOokno_K_ooool00ol0003oooooooooo`1Pooooo`05o`000?n=SHgo^k^k
on7QhOomoOd00oooool001_ooooo00?o0000ooooooooool0<oooool01OmUIFGoVYZJokjn__lG5aOo
fm_K06oooooo00?o0000ooooooooool0H?ooool01?l0003oTI6AolC4a?oVi^H4ooooo`006oooool0
0ol0003oooooooooo`0cooooo`04ofEUIOmeMGGo5aLGokno_g3ooooo00?o0000ooooooooool0H?oo
ool00ol0003o];BdooGem@05ooooo`006oooool00ol0003oooooooooo`0cooooo`03ofEUIOl10@7o
Vi^K077ooooo00?o0000ooooooooool0H?ooool00ol0003okNg]ooooo`05ooooo`006oooool00olo
?coo0000o`00000do`000003og9bL_oooooooooo073oooooI?l00007ooooo`00??ooool00omDE5Co
Zj^[ooooo`2gooooo`03oi^KVooooooooooo03Oooooo000looooo`03oe1@D?n_[joooooo0;Kooooo
00?ok>c/o`L71ooUiND0>?ooool003cooooo00?oC4a<ok>c/oooool0]_ooool00on>SXko0000ohV9
R@0hooooo`00??ooool00om8B4So]kNgooooo`2fooooo`03ob0P8?l0003o820P03Sooooo000loooo
o`03odA4A?nk^k_ooooo0;Gooooo00GobLW9o`/;2ol0003o2PX:om;BdP0gooooo`00??ooool00om0
@43o_knoooooo`2eooooo`05oeeMGOl20P;o0000o`@41?m`L700=oooool003cooooo00?o?3`lol?3
`oooool0]?ooool00oodm?Co2@T9o`000002o`000003oa4A4OomoOgooooo03Gooooo000looooo`03
ocPh>?o7alOooooo0;Cooooo00?oWinOo``<3?l000000_l000000ol=3@go_Kfmooooo`0eooooo`00
??ooool00old=3Cobl_;ooooo`2dooooo`03obd];Ol0003o000000;o000000?o0@41oeIFE_ooool0
=Oooool003cooooo00?o<30`olo?coooool0/oooool02OoRh^;o6a/Koa<C4ol@413o1PH6o``<3?l:
2P[o61PHooShn00eooooo`00??ooool00ol/;2codm?Cooooo`2fooooo`03on[Zj_lE5AGooooo03So
oooo000looooo`03obPX:?oGemOooooo0;Kooooo00?oinOWoaPH6?ooool0>?ooool003cooooo00?o
8b<SomcLg?ooool0]_ooool00ooTi>Co6a/Kooooo`0hooooo`00??ooool00olO7aooh>3Pooooo`2f
ooooo`03on7QhOlN7Qkooooo03Sooooo000looooo`03oa/K6ooTi>Cooooo0;Kooooo00?og]kNob4Q
8Oooool0>?ooool003cooooo00?o5aLGonSXj?ooool0]_ooool00ooKfm_o92@Tooooo`0hooooo`00
??ooool00olC4a?ok>c/ooooo`2fooooo`03omOGeolW9bOooooo03Sooooo000looooo`03o`l?3oo`
l?3ooooo0;Kooooo00?oe=CDob/[:oooool0>?ooool003cooooo00?o2`/;ooCdm?ooool0]_ooool0
0ooAdM7o;Rh^ooooo`0hooooo`00??ooool00ol71`Oon?Shooooo`2fooooo`03olk>c_la<C7ooooo
03Sooooo000looooo`03o`<30oolo?cooooo0;Kooooo00?obl_;oc@d=?ooool0>?ooool003_ooooo
00?oo_kno`410Oooool0]oooool00oo8b<So=cLgooooo`0hooooo`00>oooool00ookno_o10@4oooo
o`2gooooo`03olG5aOlj>S[ooooo03Sooooo000kooooo`03ooOgmol820Sooooo0;Oooooo00?o`/;2
ocdm?Oooool0>?ooool003_ooooo00?olo?co``<3?ooool0]oooool00onn_[ko@410ooooo`0hoooo
o`00>oooool00oo_knoo410@ooooo`2gooooo`03ok^k^om4A4Cooooo03Sooooo000kooooo`03on_[
jolD51Cooooo0;Oooooo00?o^;RhodM7Aoooool0>?ooool003_ooooo00?oinOWoaPH6?ooool0]ooo
ool00one]KGoBTY:ooooo`0hooooo`00>oooool00ooRh^;o7AdMooooo`2gooooo`03ok:b/_m=CDgo
oooo03Sooooo000kooooo`03omkNg_lQ8B7ooooo0;Oooooo00?o[jn_oe1@D?ooool0>?ooool003_o
oooo00?of][JobDU9Oooool0]oooool00on/[:coDe=Cooooo`0hooooo`00>oooool00ooFe]Ko:BTY
ooooo`2gooooo`03ojVYZOmFEUKooooo03Sooooo000kooooo`03om;Bd_l];Bgooooo0;Oooooo00?o
YJFUoeUIFOooool0>?ooool003_ooooo00?oc/k>oc4a<Oooool0]oooool00onRXZ;oGEeMooooo`0h
ooooo`00>oooool00oo:b/[o=CDeooooo`2gooooo`03oinOWomPH63ooooo03Sooooo000kooooo`03
olK6a_li>CWooooo0;Oooooo00?oW9bLof=SHoooool0>?ooool003_ooooo00?o`/;2ocdm?Oooool0
]oooool00onIVIWoIVIVooooo`0hooooo`00>oooool00onn_[ko@D51ooooo`2gooooo`03oiJFU_mY
JFWooooo03Sooooo000kooooo`03okZj^_m5ADGooooo0;Oooooo00?oTi>Cofa/K?ooool0>?ooool0
03_ooooo00?o][JfodU9BOooool0]oooool00on@T93oKfm_ooooo`0hooooo`00>oooool00onb/[;o
CDe=ooooo`2gooooo`03ohb<S?mbLW;ooooo03Sooooo000kooooo`03ojj^[_mADE7ooooo0;Oooooo
00?oRHV9ogIfM_ooool0>?ooool003_ooooo00?oZZZZoeEEEOooool0]oooool00on6QXKoNGUioooo
o`0hooooo`00>?ooool02?nMWIgo2@T9o`X:2_l:2P[o2@T9oa@D5?lG5aOoI6AT]Oooool00on3Ph?o
O7alooooo`0hooooo`00>?ooool00oo/k>co1PH6o`000003o`000003o`X:2_nXZ:Sooooo0;Cooooo
00?oP820ogmoOoooool0>?ooool003Wooooo00?o@410o`000?l000000_l000000ol<30conOWioooo
o`2dooooo`03ogemOOn2PX;ooooo03Sooooo000iooooo`06ojRXZ?l=3@go0000o`000?l410CoJVYZ
]_ooool00omjNW[oQHF5ooooo`0hooooo`00>Oooool01_ofm_Ko2@T9o`000?l0003o2@T9omKFe[Ko
oooo00?oMgMgohR8R?ooool0>?ooool000[ooooo00?oo?cloo_knookno/0;Ookno/01?mCDe?o0000
o`000?l/;2`hoo_kn`03oogmoOoooooooooo04_ooooo00?oo?cloo_knookno/0;_okno/00omaLG7o
R8R8oo_kn`0hoo_kn`002Oooool00oomoOgol_;bonk^kP0^onk^kP04ojf][Ol<30co2`/;oiBDU3Oo
k^k^00?ol?3`oo_knoooool0Boooool00oomoOgol_;bonk^kP0_onk^kP03ofQXJ?n5QHGok^k^03Oo
k^k^0Oo`l?0000Sooooo00?oi^KVon7QhOoEeMD0;ooBd]801?o?cloo30`<o`L71oo9bLTfom;BdP03
omOGeoo^k^kono_k04_ooooo00?oi^KVon7QhOoEeMD0<?oBd]800omIFEWoN7Qhom;BdP0fom;BdP7o
emOG0Oo^k^h000Oooooo00ComOGeolC4a?nk^k_o/k>c<?na/K400om9BDWo@d=3ok6a/@0eok6a/@04
okRh^?oBd];ok^k^oo_knd[ooooo00ComOGeolC4a?nk^k_o/k>c<?na/K400om9BDWoIfMWok6a/@0e
ok6a/@7o^;Rh0OoBd]81onk^kP001_ooool01Oo]kNgo];Bdoi6ATOn=SHgoQhN7033oQXJ600?oJf][
ofa/K?n6QXH0=?n6QXH01On?Shoo/K6aom;Bd_o^k^kono_k04Wooooo00GokNg]okBd]?nATI7oSHf=
ohN7Q`0`ohJ6QP03ocHf=_m?CdooQXJ603CoQXJ600?oShn?ok6a/OoBd]800Oo^k^h000GoooooKOl0
00001On6QXKo/K6aom;Bd_o^k^kono_k04SoooooKOl000000on6QXKo/K6aom;BdP01onk^kP001Ooo
ool00ol0003oooooooooo`1Xooooo`07ookno_l0003oQXJ6ok6a/OoBd];ok^k^oo_kn`18ooooo`03
o`000?oooooooooo06Sooooo00Goo_kno`000?n6QXKo/K6aom;BdP01onk^kP001Oooool00ol0003o
ooooooooo`1Yooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_kB?ooool00ol0003oooooooooo`1Y
ooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooooooo06Wooooo00Ko0000
ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo06Wooooo00Co0000ohJ6Q_na/K7o
d];B0Oo^k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_k
ndSooooo00?o0000ooooooooool0JOooool01?l0003oQXJ6ok6a/OoBd]81onk^kP001Oooool00ol0
003oooooooooo`1Yooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_kB?ooool00ol0003ooooooooo
o`1Yooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooooooo06Wooooo00Ko
0000ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo06Wooooo00Co0000ohJ6Q_na
/K7od];B0Oo^k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a/OoBd];ok^k^
oo_kndSooooo00?o0000ooooooooool0JOooool01?l0003oQXJ6ok6a/OoBd]81onk^kP001Oooool0
0ol0003oooooooooo`1Yooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_kB?ooool00ol0003ooooo
ooooo`1Yooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooooooo06Wooooo
00Ko0000ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo06Wooooo00Co0000ohJ6
Q_na/K7od];B0Oo^k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a/OoBd];o
k^k^oo_kndSooooo00?o0000ooooooooool0JOooool01?l0003oQXJ6ok6a/OoBd]81onk^kP001Ooo
ool00ol0003oooooooooo`1Yooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_kB?ooool00ol0003o
ooooooooo`1Yooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooooooo06Wo
oooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo06Wooooo00Co0000
ohJ6Q_na/K7od];B0Oo^k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a/OoB
d];ok^k^oo_kndSooooo00?o0000ooooooooool0JOooool01?l0003oQXJ6ok6a/OoBd]81onk^kP00
1Oooool00ol0003oooooooooo`1Yooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_kB?ooool00ol0
003oooooooooo`1Yooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooooooo
06Wooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo06Wooooo00Co
0000ohJ6Q_na/K7od];B0Oo^k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a
/OoBd];ok^k^oo_kndSooooo00?o0000ooooooooool0JOooool01?l0003oQXJ6ok6a/OoBd]81onk^
kP001Oooool00ol0003oooooooooo`1Yooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_kB?ooool0
0ol0003oooooooooo`0Gooooo`03og]kNoo5aLGooooo04oooooo00Co0000ohJ6Q_na/K7od];B0Oo^
k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kndSooooo
00?o0000ooooooooool05oooool00onKVi_o:2PXolC4a01?ooooo`04o`000?n6QXKo/K6aom;BdP7o
k^k^0005ooooo`03o`000?oooooooooo06Wooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno]8oooo
o`03o`000?oooooooooo013ooooo00CooOgmomgMgOo@d=3oo?cl1?ooool00onRXZ;oDE5Aooooo`0>
ooooo`03onKVi_o`l?3ooooo00?ooooo00?oiNGUomKFe_okno/02Oooool00oo]kNgolO7aooooo`0[
ooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooooooo06Wooooo00Ko0000
ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo00oooooo00Ooe]KFobl_;olK6a_o
>CTiob@T9?mDE5Col?3`00;ooooo00?oQhN7o`@41?oUiND00_ooool01OlK6a_oe]KFooooooo9bLWo
92@T00;ooooo00SoM7Adog=cLooooooo1PH6oeIFE_l];Bgo1PH6ohF5Q@;ooooo01CoGemOo`X:2_lY
:BWo6QXJolg=cOooooooN7QhogUiNOoooooo6a/Kom;Bd_ooooooI6ATo``<3?lX:2SoCdm?oo_knonH
V9So5QHFon_[j`;ooooo00Gok^k^oaPH6?n9RHWoh^;Ro`000002ooooo`07odE5AOll?3cooooooooo
ool71`OogMgMon[ZjP05o`000003ohn?Sooooooooooo00oooooo00Co0000ohJ6Q_na/K7od];B0Oo^
k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kndSooooo
00?o0000ooooooooool03oooool01old=3CoMGEeoooooooooooonOWioe5ADOm^KVh00_ooool00ol[
:b_o>SXjohR8R002ooooo`05oa/K6ooFe]KoooooolW9bOlT92@00_ooool05?mdM7CoLg=cooooool6
1PKoT92@oooooooKfm_o5QHFoo7alOoDe=Co9BDUon[Zj_ono_koRHV9oe=CDoooooooN7QhogUiNOoo
oooo6a/K0_oBd]802?lS8b?ojNWYookno_mEEEGoX:2Poooooom;Bd_oEUIF0_ooool04?mOGeoo?3`l
oogmoOoRh^;o0000oooooooZj^[o4a<CoaXJ6_oTi>Coooooo`L71ooMgMgoj^[Zo`000?oUiND3ooWi
n@03oogmoOoooooooooo00oooooo00Co0000ohJ6Q_na/K7od];B0Oo^k^h000Gooooo00?o0000oooo
ooooool0JOooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kndSooooo00?o0000ooooooooool03_oo
ool00oojn_[o>SXjonOWi`03ooooo`07ogmoOom7AdOoooooom3@d?lL71coaLG5ob/[:`02ooooo`05
oa/K6ooFe]KoooooolW9bOlT92@00_ooool01OmdM7CoLg=cooooool61PKoi^KV00;ooooo00CoCTi>
oj^[Zon1PH7oKfm_0_ooool02_o/k>co3Ph>oo[jn_mhN7SoNGUioooooolK6a_od];BogmoOomZJVX2
ooooo`0Gon_[jooJf][oooooonSXj?lE5AGoZJVYokNg]ol<30cogMgMoooooooRh^;o0000oooooonF
UYKoGUiNofa/K?n?Shooooooo`L71ooMgMgoj^[Zo`000?o[jn/05Oooool01?l0003oQXJ6ok6a/OoB
d]81onk^kP001Oooool00ol0003oooooooooo`1Yooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k
B?ooool00ol0003oooooooooo`0Aooooo`0Aoo_knoo<c<coNWYjo`l?3on=SHgoooooogAdM?m_Kfoo
o_knoa`L7?o>c/kooooooa/K6oo5aLGoooooolW9bOlO7al00_ooool01OmdM7CoLg=cooooool61PKo
j>SX00;ooooo00CoHV9Roh^;RomZJV[oLg=c0_ooool02_omoOgo2@T9om_KfomhN7SoNGUioooooolK
6a_od];Bof][Jom^KVh6ooooo`04ok2`/?lD51Co7AdMoiVIV@;ooooo00goh^;Ro`000?oooooo?clo
okFe]Oo2`/;o>3Phooooool71`OogMgMon[Zj_l0003ojn_[01Gooooo00Co0000ohJ6Q_na/K7od];B
0Oo^k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kndSo
oooo00?o0000ooooooooool03oooool0<?o/k>coIFEUoa4A4Ol=3@goB4Q8ojRXZ?ono_kooOgmoaXJ
6_o3`l?oooooog1`L?mbLW;ooooooa/K6omoOgoooooookRh^?l0003ogMgMoooooomQHF7oPh>3oooo
ool61PKoVi^Koooooookno_o8R8RomCDe?nPX:3o<30`oo_knooooooocLg=o`/;2oojn_[oN7QhogUi
NOoooooo6a/Kom;Bd_nNWYko<S8boogmoOooooooUYJFohj>SP;ooooo00Coo_knobLW9olB4Q;onOWi
0_ooool03OoRh^;o0000onKVi_lD51Cono_kookno_lJ6Q[oh>3Po`L71ooMgMgoj^[Zo`000?o[jn/0
5Oooool01?l0003oQXJ6ok6a/OoBd]81onk^kP001Oooool00ol0003oooooooooo`1Yooooo`06o`00
0?n6QXKo/K6aom;Bd_o^k^kono_kB?ooool00ol0003oooooooooo`0?ooooo`04oeiNG_l^;RkoalO7
ooclo0?ooooo02Wo_;bloaTI6OomoOgoooooolC4a?lI6AWoo?cloa/K6olg=cOoEEEEoadM7Om2@T;o
:b/[oeiNG_l?3`ooa/K6ooooool61PKo;2`/oeYJF_lU9BGo=SHfoooooookno_o?ShnobDU9OmdM7Co
8B4QoiRHV?ooooooN7QhogUiNOoooooo6a/Kom;Bd_okno_o>SXjodE5AOmTI6Co4A4AomkNgP02oooo
o`04oiBDU?lI6AWo=SHfogUiN@;ooooo00Coh^;Ro`820_nATI7oHf=S0_ooool01om_KfooRh^;o`P8
2?oMgMgoj^[Zo`000?o[jn/05Oooool01?l0003oQXJ6ok6a/OoBd]81onk^kP001Oooool00ol0003o
ooooooooo`0Gooooo`03og]kNoo5aLGooooo04oooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno]8
ooooo`03o`000?oooooooooo00oooooo00?oA4A4oi2@T?ooool00_ooool01?mCDe?oVIVIomgMgOo>
c/h2ooooo`0;ookno_ni^KWomOGeol71`OoalO7o_Kfmok^k^ookno_ogmoOojBTY?oAdM400_ooool0
1Ol61PKoi^KVojRXZ?n[Zj_omoOg00;ooooo00Cono_kok>c/onHV9Sodm?C0_ooool02_mhN7SoNGUi
ooooooo7alOom?Cdooooooojn_[o[jn_ojBTY?o[jn/2ooooo`0;omWIfOl:2P[o/K6aomSHf?l;2`_o
a/K6oooooooRh^;o1PH6ocXj>_nj^[X00_ooool01oo5aLGo=3@do`/;2ooMgMgoj^[Zo`000?o[jn/0
5Oooool01?l0003oQXJ6ok6a/OoBd]81onk^kP001Oooool00ol0003oooooooooo`0Gooooo`03oi^K
VolX:2Soa<C404oooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo
00oooooo00OoVi^Kob8R8_nIVIWo/k>coeUIFOl?3`oofMWI017ooooo00?o1PH6oo?cloooool02_oo
ool01OmhN7SoNGUioooooomiNGWoiNGU00Kooooo00?oo?clocLg=omLG5`00_ooool01on:RX[o92@T
ooCdm?oRh^;o0@41oaHF5_omoOd00_ooool01oono_ko71`Lo`820_oMgMgoj^[Zo`000?o[jn/05Ooo
ool01?l0003oQXJ6ok6a/OoBd]81onk^kP001Oooool00ol0003oooooooooo`0@ooooo`04oogmoOoM
gMgod=3@ooclo0Cooooo00?oXZ:Roe5ADOooool03_ooool00ooVi^Kol?3`ooooo`03ooooo`03onGU
iOoFe]Kono_k00Wooooo00?okNg]oo7alOooool0:oooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_k
nckooooo00?oPH61olk>c_ooool01oooool00ol0003oooooooooo`0@ooooo`05ol71`Om^KVko@d=3
ohF5QOoGemL04_ooool00omQHF7omoOgooooo`0:ooooo`05ojf][On^[ZkoooooogEeMOoTi>@01_oo
ool00oo9bLWoIVIVonk^kP02ooooo`06ooclo?mcLg?o^KVionk^k_mTI6CoVIVI1?ooool01_nOWioo
I6ATon_[joobl_;oI6AToo?claGooooo00Co0000ohJ6Q_na/K7od];B0Oo^k^h000Gooooo00?o0000
ooooooooool03oooool01ooFe]Ko;bl_oa/K6oli>CWo92@ToeADE?o`l?000_ooool00on7QhOo10@4
onGUi@02ooooo`05oa/K6ooFe]KoooooolW9bOlT92@00_ooool02?mdM7CoLg=cooooool61PKoEUIF
obd];Ol61PKoQHF50_ooool05?mOGeoo2PX:obTY:OlJ6Q[ocLg=oooooomhN7SoNGUioooooolK6a_o
d];BoooooomTI6Co30`<obPX:?m?Cdoono_koiRHV?lF5QKojn_[0_ooool01Oo^k^ko61PHohV9ROoR
h^;o000000;ooooo00OoADE5oc`l??ooooooooooo`L71ooMgMgoj^[Z00Go000000?oShn?oooooooo
ool03oooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_knckooooo00Go3`l?o`P82?lQ8B7oS8b<onWY
j@05ooooo`03o`000?oooooooooo06Wooooo00Co0000ohJ6Q_na/K7od];B0Oo^k^h000Gooooo00?o
0000ooooooooool03oooool01old=3CoMGEeoooooooooooonOWioe5ADOm^KVh00_ooool00ol[:b_o
>SXjohR8R002ooooo`05oa/K6ooFe]KoooooolW9bOlT92@00_ooool05?mdM7CoLg=cooooool61PKo
T92@oooooooKfm_o5QHFoo7alOoDe=Co9BDUon[Zj_ono_koRHV9oe=CDoooooooN7QhogUiNOoooooo
6a/K0_oBd]802?lS8b?ojNWYookno_mEEEGoX:2Poooooom;Bd_oEUIF0_ooool04?mOGeoo?3`loogm
oOoRh^;o0000oooooooZj^[o4a<CoaXJ6_oTi>Coooooo`L71ooMgMgoj^[Zo`000?oUiND3ooWin@03
oogmoOoooooooooo00oooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno/nooooo`08o`h>3_l0003o
0000o`T92Ol71`Oo@D51ojj^[_ojn_X2ooooo`03o`000?oooooooooo06Wooooo00Co0000ohJ6Q_na
/K7od];B0Oo^k^h000Gooooo00?o0000ooooooooool03_ooool00oojn_[o>SXjonOWi`03ooooo`07
ogmoOom7AdOoooooom3@d?lL71coaLG5ob/[:`02ooooo`05oa/K6ooFe]KoooooolW9bOlT92@00_oo
ool01OmdM7CoLg=cooooool61PKoi^KV00;ooooo00CoCTi>oj^[Zon1PH7oKfm_0_ooool02_o/k>co
3Ph>oo[jn_mhN7SoNGUioooooolK6a_od];BogmoOomZJVX2ooooo`0Gon_[jooJf][oooooonSXj?lE
5AGoZJVYokNg]ol<30cogMgMoooooooRh^;o0000oooooonFUYKoGUiNofa/K?n?Shooooooo`L71ooM
gMgoj^[Zo`000?o[jn/05Oooool01_l0003o@d=3oeQHF?mYJFWoMgMgogemOCkoP82000?o2PX:o`00
0?l000000ol000001Ol=3@go30`<ofMWIoo>c/ko000006_ooooo00Co0000ohJ6Q_na/K7od];B0Oo^
k^h000Gooooo00?o0000ooooooooool04Oooool04Ookno_oc<c<ogYjN_l?3`ooSHf=oooooomdM7Co
Kfm_ookno_lL71coc/k>oooooolK6a_oaLG5ooooooo9bLWo7alO00;ooooo00GoM7Adog=cLooooooo
1PH6onSXj002ooooo`04of9RH_n;Rh_oJVYZog=cL`;ooooo00[ooOgmo`T92OoKfm_oN7QhogUiNOoo
oooo6a/Kom;Bd_m[Jf_oKVi^1_ooool01?n`/;3o51@DoadM7OnIVIT2ooooo`0=on;Rh_l0003ooooo
oclo?one]KGo`/;2ocPh>?oooooo1`L7omgMgOoZj^[o0000on_[j`0Eooooo`06o`000?m2@T;oF5QH
ofQXJ?mfMWKoOGem?_moOgl00ol92@Wo0000o`000003o`000005o`d=3Ol<30coIFEUolg=cOl00000
Joooool01?l0003oQXJ6ok6a/OoBd]81onk^kP001Oooool00ol0003oooooooooo`0?ooooo`0`onc/
k?mUIFGo4A4Ao`d=3Om8B4SoZ:RXookno_omoOgo6QXJol?3`oooooooL71`og9bL_oooooo6a/Kogmo
Oooooooo^;Rho`000?oMgMgoooooof5QHOn3Ph?oooooo`H61_nKVi_ooooooo_knolR8R;oe=CDoj2P
X?l`<33ono_kooooooo=cLgo2`/;oo[jn_mhN7SoNGUioooooolK6a_od];BoijNW_lb<S;ooOgmoooo
oonFUYKoSXj>0_ooool01?ono_ko9bLWoa8B4_oinOT2ooooo`0=on;Rh_l0003oi^KVoa@D5?okno_o
o_knoaXJ6_oPh>3o1`L7omgMgOoZj^[o0000on_[j`0Eooooo`06o`000?n6QXKo/K6aom;Bd_o^k^ko
no_k?_ooool02?l>3Pko0000o`000?l92@Wo1`L7od10@?n][JgonOWi0_ooool00ol0003ooooooooo
o`1Yooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooooooo00oooooo00Co
GUiNobh^;_o7alOoo?cl0oooool0:Onl_;co6ATIoogmoOooooooa<C4oaTI6Oolo?co6a/KocLg=omE
EEGo7AdMod92@_l[:b_oGUiNo`l?3oo6a/Koooooo`H61_l/;2coFUYJobDU9Olf=SKooooooo_knoln
?Sko9BDUogAdM?lQ8B7oV9RHoooooomhN7SoNGUioooooolK6a_od];Boo_knolj>S[oADE5ofATI?lA
4A7og]kN00;ooooo00CoU9BDoaTI6Olf=SKoNGUi0_ooool01?oRh^;o0P82oi6ATOmSHf<2ooooo`07
ofm_Kon;Rh_o20P8omgMgOoZj^[o0000on_[j`0Eooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_k
?_ooool01Ol?3`oo2@T9oalO7on;Rh_oj>SX00Gooooo00?o0000ooooooooool0:?ooool00ooclo?o
dM7Aoo?cl`04ooooo`03omoOgooXj>Sooooo00cooooo00?omoOgom7AdOo[jn/01?ooool00ooOgmoo
j>SXooooo`0Qooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooooooo00oo
oooo00?oA4A4oi2@T?ooool00_ooool01?mCDe?oVIVIomgMgOo>c/h2ooooo`0;ookno_ni^KWomOGe
ol71`OoalO7o_Kfmok^k^ookno_ogmoOojBTY?oAdM400_ooool01Ol61PKoi^KVojRXZ?n[Zj_omoOg
00;ooooo00Cono_kok>c/onHV9Sodm?C0_ooool02_mhN7SoNGUiooooooo7alOom?Cdooooooojn_[o
[jn_ojBTY?o[jn/2ooooo`0;omWIfOl:2P[o/K6aomSHf?l;2`_oa/K6oooooooRh^;o1PH6ocXj>_nj
^[X00_ooool01oo5aLGo=3@do`/;2ooMgMgoj^[Zo`000?o[jn/05Oooool01_l0003oQXJ6ok6a/OoB
d];ok^k^oo_knckooooo00?oOgmoolg=cOooool01oooool00ol0003oooooooooo`0Mooooo`05oa/K
6ooFe]KoooooolW9bOlT92@00_ooool02?mdM7CoLg=coooooon[Zj_o2PX:oc0`<?l51@GoShn?0_oo
ool05?mIFEWo20P8obDU9OmUIFGo71`Loooooom`L73oO7aloooooomNGUkoUYJFoooooomkNg_oMWIf
oooooonk^k_o4a<Coc0`<?l?3`ooPX:20_ooool01OmIFEWo20P8obDU9OmUIFGo71`L023ooooo00Co
0000ohJ6Q_na/K7od];B0Oo^k^h000Gooooo00?o0000ooooooooool03oooool01onKVi_o8R8RoiVI
VOnc/k?oFEUIo`l?3ooIfMT04Oooool00ol61PKolo?cooooo`0:ooooo`05ogQhN?miNGWoooooogUi
NOoUiND01_ooool00oolo?co=cLgoeaLG002ooooo`07ohZ:R_lT92Com?Cdon;Rh_l10@7o5QHFoogm
o@02ooooo`07ookno_lL71co0P82omgMgOoZj^[o0000on_[j`0Eooooo`06o`000?n6QXKo/K6aom;B
d_o^k^kono_kB?ooool00ol0003oooooooooo`0Mooooo`05oa/K6ooFe]KoooooolW9bOlT92@00_oo
ool09OmdM7CoLg=coooooolZ:R[o^[Zjooooooo@d=3o5ADEooKfm_oBd];o8R8RonKVi_omoOgoJ6QX
oa`L7?ooooooL71`ogalO?ooooooGUiNoiJFU_ooooooNg]kogIfM_oinOWo6QXJojRXZ?ooooook>c/
obHV9_o9bLWod];Bob8R8_oVi^KooOgmofQXJ?lL71`08?ooool01?l0003oQXJ6ok6a/OoBd]81onk^
kP001Oooool00ol0003oooooooooo`0@ooooo`05ol71`Om^KVko@d=3ohF5QOoGemL04_ooool00omQ
HF7omoOgooooo`0:ooooo`05ojf][On^[ZkoooooogEeMOoTi>@01_ooool00oo9bLWoIVIVonk^kP02
ooooo`06ooclo?mcLg?o^KVionk^k_mTI6CoVIVI1?ooool01_nOWiooI6ATon_[joobl_;oI6AToo?c
laGooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo01gooooo00Go
6a/KomKFe_oooooobLW9ob@T9002ooooo`04ogAdM?mcLg?oemOGoaXJ6P?ooooo00Co@T92ok>c/omn
OWkoJVYZ0_ooool03_o0`<3o71`Loooooom`L73oO7aloooooomNGUkoUYJFoooooomkNg_oMWIfomGE
eOl51@Goa/K60oo<c<`00ooWinOoOWinofYZJP02ooooo`03ol30`?lL71cooooo01oooooo00Co0000
ohJ6Q_na/K7od];B0Oo^k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a/OoB
d];ok^k^oo_kndSooooo00?o0000ooooooooool07Oooool01OlK6a_oaLG5ooooooo9bLWo7alO00;o
oooo00CoM7Adog=cLono_koo7QhN0oooool01?mLG5coQXJ6ogUiNOm_Kfl2ooooo`0>olo?colL71co
ooooog1`L?mlO7cooooooeiNG_nFUYKoooooog]kNomfMWKodm?Co`820_mKFe/2oeaLG004ob0P8?n?
ShooNGUiofm_K`;ooooo00?oclo?oa`L7?ooool07oooool01?l0003oQXJ6ok6a/OoBd]81onk^kP00
1Oooool00ol0003oooooooooo`1Yooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_kB?ooool00ol0
003oooooooooo`0Mooooo`0/oa/K6omoOgoooooookRh^?l0003ogMgMoooooomQHF7oPh>3onc/k?l9
2@Woe]KFooooooolo?co9RHVok2`/?o4a<Co:2PXooclo?ooooooQhN7oa`L7?ooooooL71`ogalO?oo
ooooGUiNoiJFU_ooooooNg]kogIfM_ohn?So5ADEokno_ooooooomOGeobHV9_nk^k_oa<C4obPX:?ol
o?coooooohN7QolL71`Pooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooo
oooo06Wooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo01gooooo
02co6a/KocLg=omEEEGo7AdMod92@_l[:b_oGUiNo`l?3oo6a/Koooooohj>S_l<30coK6a/od10@?m8
B4SooOgmooclo?lk>c_o8R8Roe1@D?lX:2So71`Loooooom`L73oO7alokBd]?lW9bOo?ShnokVi^Omk
Ng_oMWIfoooooon[Zj_o5ADEoemOGolH61SoDE5AoogmoOolo?co>c/kob8R8_m@D53o:2PXoa`L723o
oooo00Co0000ohJ6Q_na/K7od];B0Oo^k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003o
QXJ6ok6a/OoBd];ok^k^oo_kndSooooo00?o0000ooooooooool07Oooool02?o1`L7olO7aokfm_Onk
^k_ono_komoOgonTY:CodM7A0oooool01?o>c/koV9RHokJf]_ono_h2ooooo`0>ooShn?nj^[[o^k^k
omSHf?lL71coooooomcLg?oOgmooh>3PodM7AomYJFWoh^;RomoOgooNg]h2ooooo`04omkNg_nTY:Co
aLG5oogmo@;ooooo00Gon?ShokZj^_nk^k_of=SHoa`L700Pooooo`04o`000?n6QXKo/K6aom;BdP7o
k^k^0005ooooo`03o`000?oooooooooo06Wooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno]8oooo
o`03o`000?oooooooooo037ooooo00_oh>3Poa`L7?ooooooZj^[ok:b/_ooooooL71`odi>C_oRh^;o
/K6aojn_[`0;ooooo`03on3Ph?lL71cooooo01oooooo00Co0000ohJ6Q_na/K7od];B0Oo^k^h000Go
oooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a/OoBd];ok^k^oo_kndSooooo00?o0000
ooooooooool0<Oooool02oo[jn_oKfm_oooooonXZ:So/;2`oooooooShn?oMgMgojVYZOn_[joo[:b/
00_ooooo00?ojn_[ofm_Koooool07oooool01?l0003oQXJ6ok6a/OoBd]81onk^kP001Oooool00ol0
003oooooooooo`1Yooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_kB?ooool00ol0003ooooooooo
o`1Yooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooooooo06Wooooo00Ko
0000ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo06Wooooo00Co0000ohJ6Q_na
/K7od];B0Oo^k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a/OoBd];ok^k^
oo_kndSooooo00?o0000ooooooooool0JOooool01?l0003oQXJ6ok6a/OoBd]81onk^kP001Oooool0
0ol0003oooooooooo`1Yooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_kB?ooool00ol0003ooooo
ooooo`1Yooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooooooo06Wooooo
00Ko0000ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo06Wooooo00Co0000ohJ6
Q_na/K7od];B0Oo^k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a/OoBd];o
k^k^oo_kndSooooo00?o0000ooooooooool0JOooool01?l0003oQXJ6ok6a/OoBd]81onk^kP001Ooo
ool00ol0003oooooooooo`1Yooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_kB?ooool00ol0003o
ooooooooo`1Yooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooooooo06Wo
oooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo06Wooooo00Co0000
ohJ6Q_na/K7od];B0Oo^k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a/OoB
d];ok^k^oo_kndSooooo00?o0000ooooooooool0JOooool01?l0003oQXJ6ok6a/OoBd]81onk^kP00
1Oooool00ol0003oooooooooo`1Yooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_kB?ooool00ol0
003oooooooooo`1Yooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooooooo
06Wooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo06Wooooo00Co
0000ohJ6Q_na/K7od];B0Oo^k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQXJ6ok6a
/OoBd];ok^k^oo_kndSooooo00?o0000ooooooooool0JOooool01?l0003oQXJ6ok6a/OoBd]81onk^
kP001Oooool00ol0003oooooooooo`1Yooooo`06o`000?n6QXKo/K6aom;Bd_o^k^kono_kB?ooool0
0ol0003oooooooooo`1Yooooo`04o`000?n6QXKo/K6aom;BdP7ok^k^0005ooooo`03o`000?oooooo
oooo06Wooooo00Ko0000ohJ6Q_na/K7od];Bonk^k_okno]8ooooo`03o`000?oooooooooo06Wooooo
00Co0000ohJ6Q_na/K7od];B0Oo^k^h000Gooooo00?o0000ooooooooool0JOooool01_l0003oQhN7
ok>c/ooEeMGol_;booclo4Sooooo00?o0000ooooooooool0JOooool01?l0003oQhN7ok>c/ooEeMD1
oo;blP001Oooool00ol0003oooooooooo`1Yooooo`05o`000?n=SHgo^k^kon7QhOomoOd0BOooool0
0ol0003oooooooooo`1Yooooo`04o`000?n=SHgo^k^kon7Qh@7ooOgm0005ooooo`03o`000?oooooo
oooo06Wooooo00Co0000oi6ATOo4a<Coi^KVB_ooool00ol0003oooooooooo`1Yooooo`04o`000?nA
TI7oa<C4onKViP7ooooo0005ooooo`03o`000?oooooooooo06Wooooo00?o0000okBd]?oemOD0Booo
ool00ol0003oooooooooo`1Yooooo`03o`000?nd];ComOGe00;ooooo0005ooooo`03o`000?oooooo
oooo06Wooooo00?o0000ong]kOooool0Boooool00ol0003oooooooooo`1Yooooo`03o`000?o]kNgo
oooo00;ooooo0005ooooofgo0000COoooom]o`0000Cooooo003ooooooc7ooooo003ooooooc7ooooo
003ooooooc7ooooo003ooooooc7ooooo003ooooooc7ooooo0000\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{304, 208},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->{"NBMLSymbolicXML", "i:67", "b:4.3"}],

Cell["\<\
Here is a simple example of the type of manipulations you can \
perform. This command replaces tab characters ('\\t') with four non-breaking \
spaces. This is something one might want to do before presenting work on the \
web.\
\>", "Text",
  CellTags->{"NBMLSymbolicXML", "i:67", "b:4.3"}],

Cell[BoxData[
    \(\(fixCharRule = {XMLElement["\<String\>", a_, {s_String}] \[Rule] 
            XMLElement["\<String\>", 
              a, {StringReplace[
                  s, "\<\t\>" -> "\<\[NonBreakingSpace]\[NonBreakingSpace]
\[NonBreakingSpace]\[NonBreakingSpace]\>"]}]};\)\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"NBMLSymbolicXML", "i:67", "b:4.3"}],

Cell[TextData[{
  "This applies the rule to a notebook called ",
  StyleBox["nb",
    FontFamily->"Courier"],
  " and exports the result as an XML file. "
}], "Text",
  CellTags->{"NBMLSymbolicXML", "i:67", "b:4.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(nb = Notebooks[\([2]\)]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->{"i:56", "NBMLSymbolicXML", "i:67", "b:4.3"}],

Cell[BoxData[
    InterpretationBox[\(NotebookObject[\[LeftSkeleton]"test.nb"\
\[RightSkeleton]]\),
      NotebookObject[ 
        FrontEndObject[ 
          LinkObject[ "ParentLink", 1, 1]], 13]]], "Output",
  CellLabel->"Out[8]=",
  CellTags->{"NBMLSymbolicXML", "i:67", "b:4.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<changedchars.xml\>", 
      ToSymbolicXML[InputNotebook[]] /. fixCharRule]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->{"NBMLSymbolicXML", "i:67", "b:4.3"}],

Cell[BoxData[
    \("changedchars.xml"\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->{"NBMLSymbolicXML", "i:67", "b:4.3"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Preprocess", "Subsubsection",
  CellTags->{"NBMLPreprocess", "i:68", "b:4.3"}],

Cell["\<\
Preprocessing allows any function to be applied to the notebook \
before the XML conversion functions are applied to it. For example, one might \
want to ensure that all closed cell groups are open before proceeding with \
the conversion. This can be done with the following command.\
\>", "Text",
  CellTags->{"NBMLPreprocess", "i:68", "b:4.3"}],

Cell[BoxData[
    \(\(openCellGroups[eachCell_] := 
        eachCell /. {CellGroupData[cells_, Closed] \[Rule] 
              CellGroupData[cells, Open]};\)\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->{"NBMLPreprocess", "i:68", "b:4.3"}],

Cell[TextData[{
  "One could then preprocess the notebook by using ",
  StyleBox["openCellGroups", "MR"],
  " in the following way."
}], "Text",
  CellTags->{"NBMLPreprocess", "i:68", "b:4.3"}],

Cell[BoxData[
    \(ExportString[
      openCellGroups[NotebookGet[InputNotebook[]]], \ "\<XML\>"]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->{"NBMLPreprocess", "i:68", "b:4.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Postprocess", "Subsubsection",
  CellTags->{"NBMLPostprocess", "i:69", "b:4.3"}],

Cell["\<\
Postprocessing provides a handle on the SymbolicXML object \
representing the NotebookML before it is exported. This gives you total \
freedom to manipulate the SymbolicXML in any fashion you choose. However, it \
is your responsibility to output legitimate SymbolicXML; otherwise, the \
exporting process may have to autocorrect or even fail if the exported \
expression is not in the correct syntax. \
\>", "Text",
  CellTags->{"NBMLPostprocess", "i:69", "b:4.3"}],

Cell["Here we use a postprocessing rule to replace characters.", "Text",
  CellTags->{"NBMLPostprocess", "i:69", "b:4.3"}],

Cell[BoxData[
    \(\(changeChars[\(XMLObject["\<Document\>"]\)[pre_, root_, 
            postopts___]] := \(XMLObject["\<Document\>"]\)[pre, 
          changeChars[root], postopts];\)\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->{"NBMLPostprocess", "i:69", "b:4.3"}],

Cell[BoxData[
    \(\(changeChars[XMLElement[name_, atts_, contents_]] := 
        XMLElement[name, atts, 
          Flatten[changeChars /@ contents]];\)\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"NBMLPostprocess", "i:69", "b:4.3"}],

Cell[BoxData[
    \(changeChars[s_String] := Characters[s] /. charRules\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->{"NBMLPostprocess", "i:69", "b:4.3"}],

Cell[BoxData[
    \(\(charRules = 
        Dispatch[{"\<\[Alpha]\>" \[Rule] "\<Mathematica is cool\>"}];\)\)], \
"Input",
  CellLabel->"In[15]:=",
  CellTags->{"NBMLPostprocess", "i:69", "b:4.3"}],

Cell[TextData[{
  "One could then postprocess the Symbolic NotebookML by using ",
  StyleBox["changeChars", "MR"],
  " in the following way."
}], "Text",
  CellTags->{"NBMLPostprocess", "i:69", "b:4.3"}],

Cell[BoxData[
    \(ExportString[
      changeChars[
        XML`ToSymbolicXML[NotebookGet[nb]]], \ "\<XML\>"]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->{"NBMLPostprocess", "i:69", "b:4.3"}],

Cell["\<\
Of course, one can use both pre- and postprocessing together.\
\>", \
"Text",
  CellTags->{"NBMLPostprocess", "i:69", "b:4.3"}],

Cell[BoxData[
    \(ExportString[
      changeChars[
        XML`ToSymbolicXML[
          openCellGroups[NotebookGet[nb]]]], \ "\<XML\>"]\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->{"NBMLPostprocess", "i:69", "b:4.3"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Exporting NotebookML", "Subsection",
  CellTags->"b:4.4"],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}],

Cell[TextData[{
  "You can export notebooks as NotebookML using the ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " function. Just as when exporting a notebook as HTML, when you export a \
notebook as NotebookML, graphics and boxes are automatically saved as GIF \
images. "
}], "Text",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}],

Cell[TextData[{
  "The first argument for ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " is the filename for the exported data. The second argument for ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " specifies the data to be exported. If you specify the file extension of \
the exported document as \"",
  StyleBox[".xml",
    FontFamily->"Courier"],
  "\", then ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " will automatically generate NotebookML. For example, the following will \
export the current notebook as a file named \"",
  StyleBox["anothertest.xml",
    FontFamily->"Courier"],
  "\" in NotebookML."
}], "Text",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<anothertest.xml\>", InputNotebook[]]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}],

Cell[BoxData[
    \("anothertest.xml"\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}]
}, Closed]],

Cell[TextData[{
  "If you export a ",
  StyleBox["Cell",
    FontFamily->"Courier"],
  " with the file extension ",
  StyleBox[".xml",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " will automatically generate ExpressionML. The following example will \
export the cell as ExpressionML."
}], "Text",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<celltest.xml\>", 
      Cell["\<Some text\>", \ "\<Text\>"]]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}],

Cell[BoxData[
    \("celltest.xml"\)], "Output",
  CellLabel->"Out[19]=",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}]
}, Closed]],

Cell[TextData[{
  "If the filename for the exported data does not carry the ",
  StyleBox[".xml",
    FontFamily->"Courier"],
  " extension, then you must specify \"",
  StyleBox["XML",
    FontFamily->"Courier"],
  "\" or \"",
  StyleBox["NotebookML",
    FontFamily->"Courier"],
  "\" as the second argument for ",
  StyleBox["Export",
    FontFamily->"Courier"],
  ". The data for export is then specified as the third argument. Here is an \
example."
}], "Text",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<moretests\>", \ \ InputNotebook[], \ "\<XML\>"]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}],

Cell[BoxData[
    \("moretests"\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}]
}, Closed]],

Cell[TextData[{
  "You can also export data using ",
  StyleBox["ExportString",
    FontFamily->"Courier"],
  ". This will return NotebookML for a notebook expression or ExpressionML \
for a cell expression, without assigning the output a particular filename. \
The first argument for ",
  StyleBox["ExportString",
    FontFamily->"Courier"],
  " is the data and the second argument is the desired export format. In \
this",
  " ",
  "example, the Notebook expression is exported as NotebookML."
}], "Text",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[
      Notebook[{Cell["\<Some text\>", \ "\<Text\>"]}], \ \
"\<NotebookML\>"]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}],

Cell[BoxData[
    \("<?xml version='1.0'?>\n<!DOCTYPE Notebook SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\n<Notebook \
CreatedBy='Mathematica 5.0'\n    xmlns:xhtml='http://www.w3.org/1999/xhtml'\n \
   xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <List>\n  <Cell class='Text'>\n   \
<String>Some text</String>\n   <Style>\n    <String>Text</String>\n   \
</Style>\n  </Cell>\n </List>\n</Notebook>"\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->{"ExportingNBML", "i:70", "b:4.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Conversion Options for Export", "Subsubsection",
  CellTags->{"ExportNBMLConvOpts", "i:71", "b:4.4"}],

Cell[TextData[{
  "You can use ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " in order to control the behavior of ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " and ",
  StyleBox["ExportString",
    FontFamily->"Courier"],
  ". There are four options for export in NotebookML. "
}], "Text",
  CellTags->{"ExportNBMLConvOpts", "i:71", "b:4.4"}],

Cell[TextData[{
  "\"",
  StyleBox["Annotations",
    FontFamily->"Courier"],
  "\" includes or excludes XML declarations, DOCTYPE declarations, and style \
advisories in any desired combination."
}], "BulletedList",
  CellTags->{"ExportNBMLConvOpts", "i:71", "b:4.4"}],

Cell[TextData[{
  "\"",
  StyleBox["BoxFormats",
    FontFamily->"Courier"],
  "\" specifies the export formats for various typeset box objects in the \
document. "
}], "BulletedList",
  CellTags->{"ExportNBMLConvOpts", "i:71", "b:4.4"}],

Cell[TextData[{
  "\"",
  StyleBox["GraphicsFormats",
    FontFamily->"Courier"],
  "\" specifies the export formats for graphics objects in the document.. "
}], "BulletedList",
  CellTags->{"ExportNBMLConvOpts", "i:71", "b:4.4"}],

Cell[TextData[{
  "\"",
  StyleBox["Stylesheets",
    FontFamily->"Courier"],
  "\" will associate a stylesheet (CSS or XSLT) for presentation on the web."
}], "BulletedList",
  CellTags->{"ExportNBMLConvOpts", "i:71", "b:4.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["\"Annotations\"",
  FontFamily->"Courier",
  FontWeight->"Bold"]], "Subsubsection",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[TextData[{
  "The ",
  StyleBox["Annotations",
    FontFamily->"Courier"],
  " option takes a list whose elements can be any combination of the \
following values: ",
  StyleBox["\"DocumentHeader\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"DOCTYPEDeclaration\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"XMLDeclaration\"",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\"StyleAdvisories\"",
    FontFamily->"Courier"],
  ". "
}], "Text",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell["\"DocumentHeader\"", "Subsubsubsection",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[TextData[{
  StyleBox["\"DocumentHeader\"",
    FontFamily->"Courier"],
  " determines if any header information should be added at the start of the \
NotebookML file.  The ",
  StyleBox["\"DOCTYPEDeclaration\"",
    FontFamily->"Courier"],
  " and ",
  StyleBox["\"XMLDeclaration\"",
    FontFamily->"Courier"],
  " settings only take effect if ",
  StyleBox["\"DocumentHeader\"",
    FontFamily->"Courier"],
  " is specified as one of the annotations. "
}], "Text",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell["\"DOCTYPEDeclaration\"", "Subsubsubsection",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[TextData[{
  "If ",
  StyleBox["\"DOCTYPEDeclaration\"",
    FontFamily->"Courier"],
  " is included in the list of annotations, then a DOCTYPE declaration is \
included in the header of the exported document. The default setting for ",
  StyleBox["\"Annotations\"",
    FontFamily->"Courier"],
  " includes ",
  StyleBox["\"DOCTYPEDeclaration\"",
    FontFamily->"Courier"],
  ", as shown in the following example."
}], "Text",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[Cell["\<Some text\>", "\<Text\>"], "\<XML\>"]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[BoxData[
    \("<?xml version='1.0'?>\n<!DOCTYPE Cell SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\n<Cell class='Text'\n    \
CreatedBy='Mathematica 5.0'\n    xmlns:xhtml='http://www.w3.org/1999/xhtml'\n \
   xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <String>Some text</String>\n <Style>\n \
 <String>Text</String>\n </Style>\n</Cell>"\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->{"Annotations", "i:72", "b:4.4"}]
}, Closed]],

Cell[TextData[{
  "If you exclude ",
  StyleBox["\"DOCTYPEDeclaration\"",
    FontFamily->"Courier"],
  " from the list of ",
  StyleBox["Annotations",
    FontFamily->"Courier"],
  " values, the DOCTYPE declaration is omitted from the header of the \
exported document. ",
  "Excluding the DOCTYPE declaration can sometimes shorten processing time \
reading the resulting XML document into an application since the parser is \
not required to reference a DTD."
}], "Text",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell["\"XMLDeclaration\"", "Subsubsubsection",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[TextData[{
  "If ",
  StyleBox["\"XMLDeclaration\"",
    FontFamily->"Courier"],
  " is included in the list of annotation values, an XML declaration is also \
included in the header of the exported document. The default setting for ",
  StyleBox["\"Annotations\"",
    FontFamily->"Courier"],
  " includes ",
  StyleBox["\"XMLDeclaration\"",
    FontFamily->"Courier"],
  ", as shown in the following example."
}], "Text",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[Cell["\<Some text\>", "\<Text\>"], "\<XML\>"]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[BoxData[
    \("<?xml version='1.0'?>\n<!DOCTYPE Cell SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\n<Cell class='Text'\n    \
CreatedBy='Mathematica 5.0'\n    xmlns:xhtml='http://www.w3.org/1999/xhtml'\n \
   xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <String>Some text</String>\n <Style>\n \
 <String>Text</String>\n </Style>\n</Cell>"\)], "Output",
  CellLabel->"Out[23]=",
  CellTags->{"Annotations", "i:72", "b:4.4"}]
}, Closed]],

Cell[TextData[{
  "If ",
  StyleBox["\"XMLDeclaration\"",
    FontFamily->"Courier"],
  " is excluded from ",
  StyleBox["Annotations",
    FontFamily->"Courier"],
  ", it is also omitted from the header of the exported document. ",
  "Excluding the XML declaration is useful if a user wishes to create a \
NotebookML fragment for insertion in another XML document."
}], "Text",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[Cell["\<some text\>", "\<Text\>"], "\<XML\>", 
      ConversionOptions \[Rule] {"\<Annotations\>" \[Rule] \
{"\<DOCTYPEDeclaration\>", "\<StyleAdvisories\>"}}]\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[BoxData[
    \("<Cell class='Text'\n    CreatedBy='Mathematica 5.0'\n    \
xmlns:xhtml='http://www.w3.org/1999/xhtml'\n    \
xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <String>some text</String>\n <Style>\n \
 <String>Text</String>\n </Style>\n</Cell>"\)], "Output",
  CellLabel->"Out[24]=",
  CellTags->{"Annotations", "i:72", "b:4.4"}]
}, Closed]],

Cell["\"StyleAdvisories\"", "Subsubsubsection",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[TextData[{
  "If ",
  StyleBox["\"StyleAdvisories\"",
    FontFamily->"Courier"],
  " is included in the list of annotations, class attributes are returned for \
",
  StyleBox["Cells",
    FontFamily->"Courier"],
  " and ",
  StyleBox["StyleBoxes",
    FontFamily->"Courier"],
  " that have styles associated with them. The default setting for ",
  StyleBox["\"Annotations\"",
    FontFamily->"Courier"],
  " includes ",
  StyleBox["\"StyleAdvisories\"",
    FontFamily->"Courier"],
  ", as shown in the following example."
}], "Text",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[Cell["\<Some text\>", "\<Text\>"], "\<XML\>"]\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[BoxData[
    \("<?xml version='1.0'?>\n<!DOCTYPE Cell SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\n<Cell class='Text'\n    \
CreatedBy='Mathematica 5.0'\n    xmlns:xhtml='http://www.w3.org/1999/xhtml'\n \
   xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <String>Some text</String>\n <Style>\n \
 <String>Text</String>\n </Style>\n</Cell>"\)], "Output",
  CellLabel->"Out[25]=",
  CellTags->{"Annotations", "i:72", "b:4.4"}]
}, Closed]],

Cell[TextData[{
  "If you exclude ",
  StyleBox["\"StyleAdvisories\"",
    FontFamily->"Courier"],
  " from ",
  StyleBox["Annotations",
    FontFamily->"Courier"],
  ", the class attributes associated with ",
  StyleBox["Cell",
    FontFamily->"Courier"],
  " are omitted."
}], "Text",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[Cell["\<Some text\>", "\<Text\>"], "\<XML\>", 
      ConversionOptions \[Rule] {"\<Annotations\>" \[Rule] \
{"\<DOCTYPEDeclaration\>", "\<XMLDeclaration\>"}}]\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->{"Annotations", "i:72", "b:4.4"}],

Cell[BoxData[
    \("<Cell CreatedBy='Mathematica 5.0'\n    \
xmlns:xhtml='http://www.w3.org/1999/xhtml'\n    \
xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <String>Some text</String>\n <Style>\n \
 <String>Text</String>\n </Style>\n</Cell>"\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->{"Annotations", "i:72", "b:4.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["\"BoxFormats\"",
  FontWeight->"Bold"]], "Subsubsection",
  FontFamily->"Courier",
  CellTags->{"BoxFormats", "i:73", "b:4.4"}],

Cell[TextData[{
  StyleBox["BoxFormats",
    FontFamily->"Courier"],
  " exports box data as NotebookML, GIF, or MathML. This option can be set to \
one or more of the following values: ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["GIF",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  ", or ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["MathML",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  ". The default setting is \"",
  StyleBox["BoxFormats",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  " \[Rule] ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ". "
}], "Text",
  CellTags->{"BoxFormats", "i:73", "b:4.4"}],

Cell["\"Automatic\"", "Subsubsubsection",
  CellTags->{"BoxFormats", "i:73", "b:4.4"}],

Cell[TextData[{
  "With \"",
  StyleBox["BoxFormats",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  " \[Rule] ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ", the boxes will be losslessly exported as NotebookML. This is the only \
box format setting that is guaranteed to be lossless."
}], "Text",
  CellTags->{"BoxFormats", "i:73", "b:4.4"}],

Cell["\"GIF\"", "Subsubsubsection",
  CellTags->{"BoxFormats", "i:73", "b:4.4"}],

Cell[TextData[{
  "With \"",
  StyleBox["BoxFormats",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  " \[Rule] \"",
  StyleBox["GIF\"",
    FontFamily->"Courier"],
  ", the box data will be represented as a GIF file. The exported NotebookML \
document will reference the exported GIF file by using an XHTML tag such as",
  " <",
  StyleBox["img src=\"",
    FontFamily->"Courier"],
  StyleBox["file.gif",
    FontSlant->"Italic"],
  StyleBox["\">",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"BoxFormats", "i:73", "b:4.4"}],

Cell["\"MathML\"", "Subsubsubsection",
  CellTags->{"BoxFormats", "i:73", "b:4.4"}],

Cell[TextData[{
  "With \"",
  StyleBox["BoxFormats",
    FontFamily->"Courier"],
  "\" \[Rule] \"",
  StyleBox["MathML\"",
    FontFamily->"Courier"],
  ", the box data will be exported as MathML, which will be embedded inside \
the NotebookML."
}], "Text",
  CellTags->{"BoxFormats", "i:73", "b:4.4"}],

Cell[TextData[{
  "If ",
  StyleBox["BoxFormats",
    FontFamily->"Courier"],
  " has more than one value, then the ",
  StyleBox["BoxData",
    FontFamily->"Courier"],
  " parent element will have multiple child elements associated with it, one \
element per format. "
}], "Text",
  CellTags->{"BoxFormats", "i:73", "b:4.4"}],

Cell[TextData[{
  "For example, suppose you have a ",
  StyleBox["BoxData", "MR"],
  " expression of the following form. "
}], "Text",
  CellTags->{"BoxFormats", "i:73", "b:4.4"}],

Cell["BoxData[{...}, BoxFormats -> {Automatic,GIF,MathML}]", "Program",
  CellTags->{"BoxFormats", "i:73", "b:4.4"}],

Cell["Here is the corresponding NotebookML expression.", "Text",
  CellTags->{"BoxFormats", "i:73", "b:4.4"}],

Cell["\<\
<BoxData>
   <List>
     ...
   </List>
   <xhtml:img src=\"Images/myFile_1.gif\"/>
   <math>
     ...
   </math>
</BoxData>\
\>", "Program",
  CellTags->{"BoxFormats", "i:73", "b:4.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["\"GraphicsFormats\"",
    FontWeight->"Bold"],
  " "
}], "Subsubsection",
  FontFamily->"Courier",
  CellTags->{"GraphicsFormats", "i:74", "b:4.4"}],

Cell[TextData[{
  "The \"",
  StyleBox["GraphicsFormats",
    FontFamily->"Courier"],
  "\" option changes the format of notebook graphics into another format for \
export. This is often useful since some external applications do not support \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook graphics. This option can be set to one or more of the following \
values: ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  ", \"",
  StyleBox["Bitmap\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"GIF\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Metafile\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"PICT\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"PostScript\"",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\"QuickTime\"",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"GraphicsFormats", "i:74", "b:4.4"}],

Cell[TextData[{
  StyleBox["Automatic",
    FontFamily->"Courier"],
  " is the default setting for this option. It is necessary to set \"",
  StyleBox["GraphicsFormats",
    FontFamily->"Courier"],
  "\" \[Rule] ",
  StyleBox["Automatic",
    FontFamily->"Courier"],
  " to ensure lossless import and export of a notebook. "
}], "Text",
  CellTags->{"GraphicsFormats", "i:74", "b:4.4"}],

Cell[TextData[{
  "For the ",
  StyleBox["\"Bitmap\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Metafile\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"PICT\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"PostScript\"",
    FontFamily->"Courier"],
  " and ",
  StyleBox["\"QuickTime\"",
    FontFamily->"Courier"],
  " values, the original notebook graphic will be converted to the specified \
graphic type and then exported."
}], "Text",
  CellTags->{"GraphicsFormats", "i:74", "b:4.4"}],

Cell[TextData[{
  "For the ",
  StyleBox["\"GIF\"",
    FontFamily->"Courier"],
  " setting, an external GIF file is created from the original notebook \
graphic. An ",
  StyleBox["<xhtml:img src>",
    FontFamily->"Courier"],
  " element is inserted in the exported file. Here is an example."
}], "Text",
  CellTags->{"GraphicsFormats", "i:74", "b:4.4"}],

Cell[BoxData[
    \("GraphicsFormats" \[Rule] {Automatic, "GIF"}\)], "Program",
  CellTags->{"GraphicsFormats", "i:74", "b:4.4"}],

Cell["\<\
<GraphicsData>
    <PostScript>(some postscript data...)</PostScript>
    <xhtml:img src=\"Images/myFile_1.gif\"/>
</GraphicsData>\
\>", "Program",
  CellTags->{"GraphicsFormats", "i:74", "b:4.4"}],

Cell[TextData[{
  "If \"",
  StyleBox["GraphicsFormats",
    FontFamily->"Courier"],
  "\" has more than one value, then multiple child elements are created for \
each specified format inside the ",
  StyleBox["GraphicsFormats",
    FontFamily->"Courier"],
  " parent element."
}], "Text",
  CellTags->{"GraphicsFormats", "i:74", "b:4.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["\"Stylesheets\"",
  FontWeight->"Bold"]], "Subsubsection",
  FontFamily->"Courier",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[TextData[{
  "You can associate your NotebookML documents with a stylesheet (CSS or \
XSLT) by using the ",
  StyleBox["Stylesheets",
    FontFamily->"Courier"],
  " option. This option takes a list of rules that represent the \
pseudoattributes in the XML-stylesheet processing instruction. For more \
information about the various pseudo-attributes, see: ",
  ButtonBox["http://www.w3.org/TR/xml-stylesheet",
    ButtonData:>{
      URL[ "http://www.w3.org/TR/xml-stylesheet"], None},
    ButtonStyle->"Hyperlink"],
  "."
}], "Text",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[TextData[{
  "The following is a list of rules for ",
  StyleBox["\"Stylesheets\"",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[TextData[StyleBox["href", "MR"]], "BulletedList",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[TextData[StyleBox["type", "MR"]], "BulletedList",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[TextData[StyleBox["title", "MR"]], "BulletedList",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[TextData[StyleBox["media", "MR"]], "BulletedList",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[TextData[StyleBox["charset", "MR"]], "BulletedList",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[TextData[StyleBox["alternate", "MR"]], "BulletedList",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell["\<\
Each of these rules must have a string as its value. For example, \
the following option\
\>", "Text",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<StyleSheets\>" \[Rule] {"\<href\>" -> "\<mystyle.css\>", "\<type\>" -> \
"\<text/css\>"}\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[BoxData[
    \("StyleSheets" \[Rule] {"href" \[Rule] "mystyle.css", 
        "type" \[Rule] "text/css"}\)], "Output",
  CellLabel->"Out[27]=",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}]
}, Closed]],

Cell["would result in the following XML statement.", "Text",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[TextData[StyleBox["<?xml-stylesheet href=\"mystyle.css\" type=\"text/css\
\"?>",
  FontFamily->"Courier"]], "IndentedText",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell["Here is an example that uses this conversion option.", "Text",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[Cell["\<Some text\>"], "\<XML\>", 
      ConversionOptions \[Rule] {"\<StyleSheets\>" \[Rule] {"\<href\>" -> \
"\<mystyle.css\>", "\<type\>" -> "\<text/css\>"}}]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[BoxData[
    \("<?xml version='1.0'?>\n<!DOCTYPE Cell SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\n<?xml-stylesheet \
href=\"mystyle.css\" type=\"text/css\" ?>\n<Cell CreatedBy='Mathematica 5.0'\n\
    xmlns:xhtml='http://www.w3.org/1999/xhtml'\n    \
xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <String>Some text</String>\n\
</Cell>"\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}]
}, Closed]],

Cell[TextData[{
  StyleBox["\"Stylesheets\"",
    FontFamily->"Courier"],
  " can also take a list of rules, each of which may take a list of values as \
a sublist. Each sublist corresponds to one ",
  StyleBox["xml-stylesheet", "MR"],
  " processing instruction."
}], "Text",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<StyleSheets\>" \[Rule] {\[IndentingNewLine]{"\<href\>" -> \
"\<basicStyle.css\>", "\<type\>" -> "\<text/css\>", "\<alternate\>" -> "\<yes
\>", "\<title\>" -> "\<basic\>"}, \[IndentingNewLine]{"\<href\>" -> \
"\<bigStyle.css\>", "\<type\>" -> "\<text/css\>", "\<alternate\>" -> \
"\<yes\>", "\<title\>" -> "\<big\>"}}\)], "Input",
  CellLabel->"In[29]:=",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[BoxData[
    \("StyleSheets" \[Rule] {{"href" \[Rule] "basicStyle.css", 
          "type" \[Rule] "text/css", "alternate" \[Rule] "yes ", 
          "title" \[Rule] "basic"}, {"href" \[Rule] "bigStyle.css", 
          "type" \[Rule] "text/css", "alternate" \[Rule] "yes", 
          "title" \[Rule] "big"}}\)], "Output",
  CellLabel->"Out[29]=",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}]
}, Closed]],

Cell["Here is an example.", "Text",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[Cell["\<Some text\>"], "\<XML\>", 
      ConversionOptions \[Rule] {"\<StyleSheets\>" \[Rule] {\
\[IndentingNewLine]{"\<href\>" -> "\<basicStyle.css\>", "\<type\>" -> \
"\<text/css\>", "\<alternate\>" -> "\<yes\>", "\<title\>" -> "\<basic\>"}, \
\[IndentingNewLine]{"\<href\>" -> "\<bigStyle.css\>", "\<type\>" -> \
"\<text/css\>", "\<alternate\>" -> "\<yes\>", "\<title\>" -> \
"\<big\>"}}}]\)], "Input",
  CellLabel->"In[30]:=",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}],

Cell[BoxData[
    \("<?xml version='1.0'?>\n<!DOCTYPE Cell SYSTEM \
'http://www.wolfram.com/XML/notebookml1.dtd'>\n<?xml-stylesheet \
href=\"basicStyle.css\" type=\"text/css\" alternate=\"yes\" title=\"basic\" \
?>\n<?xml-stylesheet href=\"bigStyle.css\" type=\"text/css\" \
alternate=\"yes\" title=\"big\" ?>\n<Cell CreatedBy='Mathematica 5.0'\n    \
xmlns:xhtml='http://www.w3.org/1999/xhtml'\n    \
xmlns:mathematica='http://www.wolfram.com/XML/'\n    \
xmlns='http://www.wolfram.com/XML/'>\n <String>Some text</String>\n\
</Cell>"\)], "Output",
  CellLabel->"Out[30]=",
  CellTags->{"Stylesheets", "i:75", "b:4.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["DTDs and Namespaces", "Subsubsection",
  CellTags->{"DTDsNamespaces", "i:76", "b:4.4"}],

Cell["\<\
Namespaces in XML are designated by URIs, which in practice are web \
addresses under the control of the organization supporting the dialect of \
XML. The following two examples are the namespace designations for XSLT and \
MathML, both recommendations of the W3C.\
\>", "Text",
  CellTags->{"DTDsNamespaces", "i:76", "b:4.4"}],

Cell[TextData[ButtonBox["www.w3.org/1999/XSL/Transform",
  ButtonData:>{
    URL[ "http://www.w3.org/1999/XSL/Transform"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"DTDsNamespaces", "i:76", "b:4.4"}],

Cell[TextData[ButtonBox["www.w3.org/1998/Math/MathML",
  ButtonData:>{
    URL[ "http://www.w3.org/1998/Math/MathML"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"DTDsNamespaces", "i:76", "b:4.4"}],

Cell["\<\
The namespace for NotebookML and ExpressionML, is specified by the \
following URI.\
\>", "Text",
  CellTags->{"DTDsNamespaces", "i:76", "b:4.4"}],

Cell[TextData[ButtonBox["www.wolfram.com/XML",
  ButtonData:>{
    URL[ "http://www.wolfram.com/XML/DTD/2001/NBMLwMathML.dtd"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"DTDsNamespaces", "i:76", "b:4.4"}],

Cell["\<\
The DTD for NotebookML and ExpressionML is located at the following \
URI. \
\>", "Text",
  CellTags->{"DTDsNamespaces", "i:76", "b:4.4"}],

Cell[TextData[ButtonBox["www.wolfram.com/XML/DTD/notebookml1.dtd",
  ButtonData:>{
    URL[ "http://www.wolfram.com/XML/DTD/2001/NBMLwMathML.dtd"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellTags->{"DTDsNamespaces", "i:76", "b:4.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Displaying NotebookML Using CSS", "Subsection",
  CellTags->{"NBMLCSS", "i:77", "b:4.5"}],

Cell[TextData[{
  "NotebookML can be displayed in many current generation browsers, by using \
CSS style sheets. For example, ",
  StyleBox["Internet Explorer",
    FontSlant->"Italic"],
  " 5 or later and ",
  StyleBox["Netscape",
    FontSlant->"Italic"],
  " 6 or later have built-in support for CSS. CSS can even mimic the behavior \
of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  StyleBox["\[CloseCurlyQuote]s environments (like Working, Printout,",
    FontVariations->{"CompatibilityType"->0}],
  " ",
  StyleBox["Presentation, and so forth). To save a notebook as NotebookML \
with a Cascading Style",
    FontVariations->{"CompatibilityType"->0}],
  " ",
  StyleBox["Sheet, use the ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Export",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" function, with a conversion option of ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\"StyleSheets\"",
    FontFamily->"Courier",
    FontVariations->{"CompatibilityType"->0}],
  " ",
  StyleBox["pointing to the relevant stylesheet. Here is an example.",
    FontVariations->{"CompatibilityType"->0}]
}], "Text",
  CellTags->{"NBMLCSS", "i:77", "b:4.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<NotebookML.xml\>", \ InputNotebook[], 
      ConversionOptions \[Rule] {"\<StyleSheets\>" \[Rule] {"\<type\>" -> \
"\<text/css\>", "\<href\>" -> "\<css/presentation.css\>"}}]\)], "Input",
  CellLabel->"In[31]:=",
  CellTags->{"NBMLCSS", "i:77", "b:4.5"}],

Cell[BoxData[
    \("NotebookML.xml"\)], "Output",
  CellLabel->"Out[31]=",
  CellTags->{"NBMLCSS", "i:77", "b:4.5"}]
}, Closed]],

Cell[TextData[{
  "If you save a notebook as NotebookML and CSS (instead of simply converting \
it to HTML), the ",
  StyleBox["resulting", "emphasis"],
  " file can be rendered in a web browser. The advantage of this approach is \
that you only need to create a single document, which can be viewed either in \
web browsers or in ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  " A non-",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " user can view the document in any web browser. But a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " user will be able to open and edit the document as a notebook, evaluate \
the input, manipulate the graphics, and so on."
}], "Text",
  CellTags->{"NBMLCSS", "i:77", "b:4.5"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["6. Working with MathML", "Section",
  PageBreakAbove->True],

Cell[CellGroupData[{

Cell["Introduction", "Subsection",
  CellTags->{"WhatsMathML", "i:78", "b:5.0"}],

Cell[TextData[{
  "MathML is an XML-based markup language for representing mathematics. It \
was developed by the W3C to provide an effective way to display math in web \
pages and to facilitate the transfer and re-use of mathematical content \
between applications. The great advantage of MathML is that it can encode \
information about both the",
  " ",
  "meaning and the appearance of mathematical notation. This makes it an \
ideal data format for storing and exchanging mathematical information. For \
example, a MathML equation can be copied out of a web page and directly \
pasted into an application like ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for evaluation. "
}], "Text",
  CellTags->{"WhatsMathML", "i:78", "b:5.0"}],

Cell["\<\
MathML is expected to have a big impact on how science and \
mathematics are communicated. As a common and widely accepted standard for \
representing mathematics, it provides the foundation for many interesting and \
useful applications. For example, you can use MathML to create dynamic \
mathematical websites featuring interactive equations, set up a database of \
technical documents whose contents can be easily searched, indexed, and \
archived, or develop speech synthesis software for audio rendering of \
mathematics.\
\>", "Text",
  CellTags->{"WhatsMathML", "i:78", "b:5.0"}],

Cell["\<\
MathML has grown rapidly in popularity since it was first released \
in 1998, gaining broad support in both industry and academia. It is currently \
possible to view MathML equations in the leading web browsers, either \
directly or using freely available plug-ins. As more tools for authoring, \
viewing, and processing MathML become available, its importance is only \
expected to grow. \
\>", "Text",
  CellTags->{"WhatsMathML", "i:78", "b:5.0"}],

Cell[TextData[{
  "Wolfram Research was a key participant in the development of MathML and is \
committed to supporting this important web technology.",
  StyleBox[" Mathematica",
    FontSlant->"Italic"],
  " ",
  "5.0",
  " includes full support for MathML 2.0, the latest version of the language. \
You can import MathML equations into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook and evaluate them, or export equations from a notebook as MathML \
and paste them into an HTML document for viewing in a web browser. There are \
also several kernel commands for converting between MathML and the boxes and \
expressions used internally by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to represent mathematics. "
}], "Text",
  CellTags->{"WhatsMathML", "i:78", "b:5.0"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Syntax of MathML", "Subsection",
  CellTags->{"i:117", "b:5.1"}],

Cell[CellGroupData[{

Cell["Overview", "Subsubsection",
  CellTags->{"MathMLOverview", "i:79", "i:117", "b:5.1"}],

Cell["\<\
Since it is an XML application, the syntax rules of MathML are \
defined by the XML specification. Each MathML expression consists of a series \
of elements, written in the angle bracket syntax similar to HTML. Each \
element can take several attributes. The allowed elements and attributes are \
determined by the MathML DTD. \
\>", "Text",
  CellTags->{"MathMLOverview", "i:79", "i:117", "b:5.1"}],

Cell[TextData[{
  "All MathML elements fall into one of three categories: interface elements, \
presentation elements, and content elements. Interface elements, such as the \
top-level ",
  StyleBox["math",
    FontFamily->"Courier"],
  " element determine how a MathML expression is embedded in other XML \
documents. "
}], "Text",
  CellTags->{"MathMLOverview", "i:79", "i:117", "b:5.1"}],

Cell[TextData[{
  "Presentation elements encode information about the appearance of a \
mathematical expression, that is its visual two-dimensional structure. For \
example, the ",
  StyleBox["mrow",
    FontFamily->"Courier"],
  ", ",
  StyleBox["mfrac",
    FontFamily->"Courier"],
  ", ",
  StyleBox["msqrt",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["msub",
    FontFamily->"Courier"],
  " elements represent a row, a fraction, a square root, and a subscripted \
expression, respectively."
}], "Text",
  CellTags->{"MathMLOverview", "i:79", "i:117", "b:5.1"}],

Cell[TextData[{
  "Content elements encode information about the logical meaning of a \
mathematical expression. For example, ",
  StyleBox["plus",
    FontFamily->"Courier"],
  " and ",
  StyleBox["sin",
    FontFamily->"Courier"],
  " represent addition and the trigonometric sine function, and ",
  StyleBox["apply",
    FontFamily->"Courier"],
  " represents the operation of applying a function. "
}], "Text",
  CellTags->{"MathMLOverview", "i:79", "i:117", "b:5.1"}],

Cell["\<\
A given equation can be represented in several different ways in \
MathML:\
\>", "Text",
  CellTags->{"MathMLOverview", "i:79", "i:117", "b:5.1"}],

Cell["\<\
Presentation elements only. This type of markup is called \
presentation MathML. It is useful in situations where only the display of \
mathematics is important, for example, to include equations in a web page \
that are intended only for viewing. \
\>", "BulletedList",
  CellTags->{"MathMLOverview", "i:79", "i:117", "b:5.1"}],

Cell[TextData[{
  "Content elements only. This type of markup is called content MathML. It is \
useful in situations where it is important to encode mathematical meaning. \
For example, you can use it to post an equation on a web page that readers \
can copy and paste into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for evaluation.  "
}], "BulletedList",
  CellTags->{"MathMLOverview", "i:79", "i:117", "b:5.1"}],

Cell["\<\
A combination of content and presentation elements. This type of \
markup is called combined markup and is used when you want to encode both the \
appearance and meaning of equations. For example, you can use combined markup \
to specify a non-standard notation for a common mathematical construct, or to \
associate a specific mathematical meaning with a certain type of notation \
that usually has a different meaning. \
\>", "BulletedList",
  CellTags->{"MathMLOverview", "i:79", "i:117", "b:5.1"}],

Cell[TextData[{
  "Using ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", you can generate presentation markup, content markup, or combined markup \
for any equation."
}], "Text",
  CellTags->{"MathMLOverview", "i:79", "i:117", "b:5.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Presentation MathML", "Subsubsection",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[TextData[{
  "Presentation MathML consists of about 30 elements and 50 attributes, which \
encode the visual two-dimensional structure of a mathematical expression. For \
example, the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " typeset expression ",
  StyleBox["x + 1", "Input"],
  " would have the following MathML representation."
}], "Text",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x + 1\)], "DisplayMath",
  Evaluatable->False,
  FontWeight->"Bold",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[BoxData[
    \("<math>\n <mrow>\n  <mi>x</mi>\n  <mo>+</mo>\n  <mn>1</mn>\n </mrow>\n\
</math>"\)], "Output",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}]
}, Closed]],

Cell[TextData[{
  "The entire expression is enclosed in a ",
  StyleBox["math",
    FontFamily->"Courier"],
  " element. This must be the root element for every instance of MathML \
markup. The above example also uses four other presentation elements:"
}], "Text",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[TextData[{
  StyleBox["mrow",
    FontFamily->"Courier"],
  ":  displays its subelements in a horizontal row."
}], "BulletedList",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[TextData[{
  StyleBox["mi",
    FontFamily->"Courier"],
  ": represents an identifier such as the name of a function or a variable."
}], "BulletedList",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[TextData[{
  StyleBox["mo",
    FontFamily->"Courier"],
  ": represents an operator or a delimiter. "
}], "BulletedList",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[TextData[{
  StyleBox["mn",
    FontFamily->"Courier"],
  ": represents a number. "
}], "BulletedList",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell["\<\
Identifiers, operators, and numbers are each represented by a \
different type of element because each type of object has slightly different \
typesetting conventions for fonts, spacing, and so on. For example, variables \
are typically rendered in an italic font, numbers are displayed in a normal \
font, and operators are rendered with extra space around them, depending on \
whether they occur in a prefix, postfix, or infix position. \
\>", "Text",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[TextData[{
  "In addition to the ",
  StyleBox["mi",
    FontFamily->"Courier"],
  StyleBox[", ",
    FontFamily->"Times New Roman"],
  StyleBox["mn",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["mo",
    FontFamily->"Courier"],
  " elements, there are presentation elements corresponding to common \
notational structures such as fractions, square roots, subscripts, \
superscripts, and matrices. Any given formula can then be represented by \
decomposing it into its constituent parts and replacing each notational \
construct by the corresponding presentation elements. For example, the \
typeset expression ",
  Cell[BoxData[
      \(TraditionalForm\`\@x\/\(y\^2 - 1\)\)]],
  "would have the following MathML representation."
}], "Text",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\@x\/\(y\^2 - 1\)\)], "DisplayMath",
  Evaluatable->False,
  FontWeight->"Bold",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[BoxData[
    \("<math>\n <mfrac>\n  <msqrt>\n   <mi>x</mi>\n  </msqrt>\n  <mrow>\n   \
<msup>\n    <mi>y</mi>\n    <mn>2</mn>\n   </msup>\n   <mo>-</mo>\n   \
<mn>1</mn>\n  </mrow>\n </mfrac>\n</math>"\)], "Output",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}]
}, Closed]],

Cell[TextData[{
  "Here, the",
  StyleBox[" mfrac",
    FontFamily->"Courier"],
  ", ",
  StyleBox["msqrt",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["msup",
    FontFamily->"Courier"],
  " elements represent a fraction, a square root, and a superscripted \
expression, respectively. Each of these elements takes a fixed number of \
child elements, which have a specific meaning based on their position. These \
child elements are called arguments. For example, both the ",
  StyleBox["mfrac",
    FontFamily->"Courier"],
  " and ",
  StyleBox["msup",
    FontFamily->"Courier"],
  " elements take two arguments, with the following syntax."
}], "Text",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[TextData[{
  StyleBox["<mfrac>",
    FontFamily->"Courier"],
  " ",
  StyleBox["numerator denominator",
    FontSlant->"Italic"],
  " ",
  StyleBox["</mfrac>",
    FontFamily->"Courier"]
}], "IndentedText",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[TextData[{
  StyleBox["<msup>",
    FontFamily->"Courier"],
  " ",
  StyleBox["base superscript",
    FontSlant->"Italic"],
  " ",
  StyleBox["</msup>",
    FontFamily->"Courier"]
}], "IndentedText",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[TextData[{
  "As before, the ",
  StyleBox["mrow",
    FontFamily->"Courier"],
  " element is used to enclose other elements which appear in a horizontal \
row. For example, the typeset expression ",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\[ExponentialE]\^\(-x\)\ \
\[DifferentialD]x\)]],
  "would have the following MathML representation."
}], "Text",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\_0\%\[Infinity]\( \[ExponentialE]\^\(-x\)\) \
\[DifferentialD]x\)], "DisplayMath",
  Evaluatable->False,
  FontWeight->"Bold",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[BoxData[
    \("<math>\n <mrow>\n   <msubsup>\n    <mo>&int;</mo>\n    <mn>0</mn>\n    \
<mi>&inf;</mi>\n   </msubsup>\n   <msup>\n     <mi>&exp;</mi>\n     <mrow>\n  \
    <mo>-</mo>\n      <mi>x</mi>\n     </mrow>\n   </msup>\n    <mrow>\n     \
<mo>&dd;</mo>\n     <mi>x</mi>\n     </mrow>\n   </mrow>\n</math>"\)], \
"Output",
  CellEditDuplicate->False,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}]
}, Closed]],

Cell[TextData[{
  "Here, the limits of the integral are shown using the presentation element \
",
  StyleBox["msubsup",
    FontFamily->"Courier"],
  ", which takes three arguments, with the following syntax."
}], "Text",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[TextData[{
  StyleBox["<msubsup>",
    FontFamily->"Courier"],
  " ",
  StyleBox["base subscript superscript",
    FontSlant->"Italic"],
  " ",
  StyleBox["</msubsup>",
    FontFamily->"Courier"]
}], "IndentedText",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[TextData[{
  "Another notable feature is that the symbols representing the integral \
sign, the exponential, and the differential d are represented using the \
character entities ",
  StyleBox["&int;",
    FontFamily->"Courier"],
  " and ",
  StyleBox["&exp;",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["&dd;",
    FontFamily->"Courier"],
  " respectively. These are among approximately two thousand special symbols \
defined by the MathML DTD. These can be included in a document using a named \
entity reference or a character entity reference that uses the Unicode \
character code for that symbol. "
}], "Text",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[TextData[{
  "The ",
  StyleBox["mstyle",
    FontFamily->"Courier"],
  " element is used for applying styles to an equation. Any attributes \
specified in an ",
  StyleBox["mstyle",
    FontFamily->"Courier"],
  " element are inherited by all its child elements. Hence you can use this \
element to specify properties like the font size and color for an equation, \
as in the example below. Note the use of the entity ",
  StyleBox["&InvisibleTimes;",
    FontFamily->"Courier"],
  " to denote multiplication."
}], "Text",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`x\^2 - 2\ x + 1\)], "DisplayMath",
  Evaluatable->False,
  FontSize->18,
  FontColor->RGBColor[1, 0, 0],
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}],

Cell[BoxData[
    \("<math>\n<mstyle fontsize='24 pt' fontcolor='red'>\n <mrow>\n  <msup>\n \
   <mi>x</mi>\n   <mn>2</mn>\n  </msup>\n  <mo>-</mo>\n  <mrow>\n   \
<mn>2</mn>\n   <mo>&InvisibleTimes;</mo>\n   <mi>x</mi>\n  </mrow>\n  \
<mo>+</mo>\n  <mn>1</mn>\n </mrow>\n </mstyle>\n</math>"\)], "Output",
  CellEditDuplicate->False,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}]
}, Closed]],

Cell[TextData[{
  "The above examples are intended only to illustrate how presentation markup \
works through a sampling of some of its elements. To see a complete listing \
of all the presentation elements and attributes, see the MathML specification \
at ",
  ButtonBox["http://www.w3.org/TR/MathML2/",
    ButtonData:>{
      URL[ "http://www.w3.org/TR/MathML2/"], None},
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text",
  CellTags->{"PresentMathML", "i:80", "i:117", "b:5.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Content MathML", "Subsubsection",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[TextData[{
  "Content MathML consists of about 140 elements and 12 attributes, which \
encode the logical meaning of a mathematical expression. The content elements \
",
  StyleBox["ci",
    FontFamily->"Courier"],
  " and ",
  StyleBox["cn",
    FontFamily->"Courier"],
  " are used to represent identifiers and numbers, respectively. They are \
analogous to the ",
  StyleBox["mi",
    FontFamily->"Courier"],
  " and ",
  StyleBox["mn",
    FontFamily->"Courier"],
  " elements in presentation markup. For example, the typeset expression ",
  StyleBox["x + 1", "Input"],
  " would have the following ContentMathML representation."
}], "Text",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(x + 1\)], "DisplayMath",
  FontWeight->"Bold",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[BoxData[
    \("<math>\n <apply>\n  <plus/>\n  <ci>x</ci>\n  <cn>1</cn>\n </apply>\n\
</math>"\)], "Output",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}]
}, Closed]],

Cell[TextData[{
  "The ",
  StyleBox["apply",
    FontFamily->"Courier"],
  " element is used to apply operators or functions to expressions. The first \
argument of the ",
  StyleBox["apply",
    FontFamily->"Courier"],
  " element is usually an empty element indicating an operator or function. \
The remaining arguments represent one or more expressions to which the first \
argument is applied. In the above example, the first argument of the ",
  StyleBox["apply",
    FontFamily->"Courier"],
  " function is the empty element ",
  StyleBox["plus",
    FontFamily->"Courier"],
  " which denotes addition. "
}], "Text",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[TextData[{
  "The ",
  StyleBox["type",
    FontFamily->"Courier"],
  " attribute of ",
  StyleBox["cn",
    FontFamily->"Courier"],
  " describes the type of number encoded. It can take values ",
  StyleBox["real",
    FontFamily->"Courier"],
  ", ",
  StyleBox["integer",
    FontFamily->"Courier"],
  ", ",
  StyleBox["rational",
    FontFamily->"Courier"],
  ", ",
  StyleBox["complex-polar",
    FontFamily->"Courier"],
  ", ",
  StyleBox["complex-cartesian",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["constant",
    FontFamily->"Courier"],
  ". The empty element ",
  StyleBox["sep",
    FontFamily->"Courier"],
  " is used to separate different parts of a number such as the numerator and \
denominator of a fraction or the real and imaginary parts of a complex \
number. For example:"
}], "Text",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(1/2\)], "DisplayMath",
  FontWeight->"Bold",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[BoxData[
    \("<math>\n <cn type=\"rational\">1<sep/>2</cn>\n</math>"\)], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(3 + 4  \[ImaginaryI]\)], "DisplayMath",
  FontWeight->"Bold",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[BoxData[
    \("<math>\n <cn type=\"complex-cartesian\">3<sep/>4</cn>\n</math>"\)], \
"Output",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}]
}, Closed]],

Cell[TextData[StyleBox["The majority of content elements are empty elements \
representing specific operators or functions. The various elements are \
organized into groups named after the following specific elementary subfields \
of mathematics.",
  FontFamily->"Times New Roman"]], "Text",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[TextData[StyleBox["Arithmetic, Algebra, and Logic",
  FontFamily->"Times New Roman"]], "BulletedList",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[TextData[StyleBox["Elementary Functions",
  FontFamily->"Times New Roman"]], "BulletedList",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell["Calculus", "BulletedList",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell["Linear Algebra", "BulletedList",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell["Sequences and Series", "BulletedList",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell["Theory of Sets", "BulletedList",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell["Statistics", "BulletedList",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[TextData[{
  StyleBox["There are elements corresponding to most operators and functions \
that are encountered in high school mathematics. ",
    FontFamily->"Times New Roman"],
  "For example, basic arithmetic operators are represented by ",
  StyleBox["plus",
    FontFamily->"Courier"],
  ", ",
  StyleBox["minus",
    FontFamily->"Courier"],
  ", ",
  StyleBox["times",
    FontFamily->"Courier"],
  ", ",
  StyleBox["divide",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["power",
    FontFamily->"Courier"],
  ".  "
}], "Text",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\@x\/\(y\^2 - 1\)\)], "DisplayMath",
  FontWeight->"Bold",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[BoxData[
    \("<math>\n <apply>\n  <times/>\n  <apply>\n   <power/>\n   <ci>x</ci>\n  \
 <cn>1<sep/>2</cn>\n  </apply>\n  <apply>\n   <power/>\n   <apply>\n    \
<plus/>\n    <apply>\n     <power/>\n     <ci>y</ci>\n     <cn>2</cn>\n    \
</apply>\n    <cn>-1</cn>\n   </apply>\n   <cn>-1</cn>\n  </apply>\n </apply>\
\n</math>"\)], "Output",
  CellEditDuplicate->False,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}]
}, Closed]],

Cell[TextData[{
  "Integrals are specified using the ",
  StyleBox["int",
    FontFamily->"Courier"],
  " element. The variable of integration is represented using the element ",
  StyleBox["bvar",
    FontFamily->"Courier"],
  ". The upper and lower limits of integration are usually specified using \
the elements ",
  StyleBox["lowlimit",
    FontFamily->"Courier"],
  " and ",
  StyleBox["uplimit",
    FontFamily->"Courier"],
  ". "
}], "Text",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`\[Integral]\_a\%b x \[DifferentialD]x\)], "DisplayMath",\

  FontWeight->"Bold",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[BoxData[
    \("<math>\n <apply>\n  <int/>\n  <bvar>\n   <ci>x</ci>\n  </bvar>\n  \
<lowlimit>\n   <ci>a</ci>\n  </lowlimit>\n  <uplimit>\n   <ci>b</ci>\n  \
</uplimit>\n  <ci>x</ci>\n </apply>\n</math>"\)], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}]
}, Closed]],

Cell[TextData[{
  "The ",
  StyleBox["interval",
    FontFamily->"Courier"],
  " element is used to specify closed and open intervals. It takes the \
attribute ",
  StyleBox["closure",
    FontFamily->"Courier"],
  " which can take the values ",
  StyleBox["closed",
    FontFamily->"Courier"],
  ", ",
  StyleBox["open",
    FontFamily->"Courier"],
  ", ",
  StyleBox["closed-open",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["open-closed",
    FontFamily->"Courier"],
  " corresponding to the four types of intervals possible. The default value \
for ",
  StyleBox["closure",
    FontFamily->"Courier"],
  " is ",
  StyleBox["closed",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\([a, b]\)\)], "DisplayMath",
  FontWeight->"Bold",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[BoxData[
    \("<math>\n <interval>\n    <ci>a</ci>\n    <ci>b</ci>\n   </interval>\n\
</math>"\)], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\((0, 1\)\(]\)\)\)], "DisplayMath",
  FontWeight->"Bold",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[BoxData[
    \("<math>\n <interval closure='open-closed'>\n    <cn>0</cn>\n    \
<cn>1</cn>\n   </interval>\n</math>"\)], "Output",
  CellEditDuplicate->False,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}]
}, Closed]],

Cell[TextData[{
  "You can also use the ",
  StyleBox["interval",
    FontFamily->"Courier"],
  " element to specify the limits of a definite integral as an alternative to \
using ",
  StyleBox["uplimit",
    FontFamily->"Courier"],
  " and ",
  StyleBox["lowlimit",
    FontFamily->"Courier"],
  ". "
}], "Text",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(TraditionalForm\`\[Integral]\_a\%b x \[DifferentialD]x\)], "DisplayMath",\

  FontWeight->"Bold",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[BoxData[
    \("<math>\n <apply>\n  <int/>\n  <bvar>\n  <interval>\n    <ci>a</ci>\n   \
  <ci>b</ci>\n   </interval>\n  <ci>x</ci>\n </apply>\n</math>"\)], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}]
}, Closed]],

Cell[TextData[{
  "The ",
  StyleBox["matrix",
    FontFamily->"Courier"],
  " and ",
  StyleBox["matrixrow",
    FontFamily->"Courier"],
  " elements are used to represent a matrix and a row of a matrix \
respectively. The ",
  StyleBox["eq",
    FontFamily->"Courier"],
  " element is used to express equality. "
}], "Text",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    FormBox[
      RowBox[{"M", "=", 
        RowBox[{"(", GridBox[{
              {"a", "b"},
              {"c", "d"}
              }], ")"}]}], TraditionalForm]], "DisplayMath",
  FontWeight->"Bold",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}],

Cell[BoxData[
    \(\(\(<\)\(math\)\(>\)\(\[IndentingNewLine]\)\(<\)\(apply\)\(>\)\(\
\[IndentingNewLine]\)\(<\)\(\(eq\)\(/\)\)\(>\)\(\[IndentingNewLine]\)\(<\)\(\
ci\)\(>\)\(A\)\(<\)\(\(/\)\(ci\)\)\(>\)\(\[IndentingNewLine]\)\(<\)\(matrix\)\
\(>\)\(\[IndentingNewLine]\)\(<\)\(matrixrow\)\(>\)\(\[IndentingNewLine]\)\(<\
\)\(ci\)\(>\)\(a\)\(<\)\(\(/\)\(ci\)\)\(>\)\(\[IndentingNewLine]\)\(<\)\(ci\)\
\(>\)\(b\)\(<\)\(\(/\)\(ci\)\)\(>\)\(\[IndentingNewLine]\)\(<\)\(\(/\)\(\
matrixrow\)\)\(>\)\(\[IndentingNewLine]\)\(<\)\(matrixrow\)\(>\)\(\
\[IndentingNewLine]\)\(<\)\(ci\)\(>\)\(c\)\(<\)\(\(/\)\(ci\)\)\(>\)\(\
\[IndentingNewLine]\)\(<\)\(ci\)\(>\)\(d\)\(<\)\(\(/\)\(ci\)\)\(>\)\(\
\[IndentingNewLine]\)\(<\)\(\(/\)\(matrixrow\)\)\(>\)\(\[IndentingNewLine]\)\(\
<\)\(\(/\)\(matrix\)\)\(>\)\(\[IndentingNewLine]\)\(<\)\(\(/\)\(apply\)\)\(>\)\
\(\[IndentingNewLine]\)\(<\)\(math\)\(>\)\)\)], "Output",
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}]
}, Closed]],

Cell[TextData[{
  "The preceding examples are intended only to illustrate how content markup \
works through a representative sampling of some of its elements. To see a \
complete listing of all the content elements and attributes, see the MathML \
specification at ",
  ButtonBox["http://www.w3.org/TR/MathML2/.",
    ButtonData:>{
      URL[ "http://www.w3.org/TR/MathML2/"], None},
    ButtonStyle->"Hyperlink"],
  " "
}], "Text",
  CellTags->{"ContentMathML", "i:81", "i:117", "b:5.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Importing MathML", "Subsection",
  CellTags->{"ImportMathML", "i:82", "b:5.2"}],

Cell[TextData[{
  "There are two",
  " ",
  "ways to import MathML equations into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ":"
}], "Text",
  CellTags->{"ImportMathML", "i:82", "b:5.2"}],

Cell[TextData[{
  "Copy and paste MathML equations from another application, such as a web \
browser, directly into a notebook. When you paste a valid MathML expression \
into a notebook, ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " brings up a dialog box asking if you want to paste the literal markup or \
interpret it. If you choose to interpret the markup, it is automatically \
converted into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression. "
}], "BulletedList",
  CellTags->{"ImportMathML", "i:82", "b:5.2"}],

Cell[TextData[{
  "Use the ",
  StyleBox["Import",
    FontFamily->"Courier"],
  " command with ",
  StyleBox["\"MathML\"",
    FontFamily->"Courier"],
  " as the import format."
}], "BulletedList",
  CellTags->{"ImportMathML", "i:82", "b:5.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Import["\<test.mml\>", "\<MathML\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"ImportMathML", "i:82", "b:5.2"}],

Cell[BoxData[
    \(FormBox[
      TagBox[SuperscriptBox["x", "2"], "MathMLPresentationTag", 
        AutoDelete \[Rule] True], TraditionalForm]\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"i:82", "b:5.2"}]
}, Closed]],

Cell[TextData[{
  "By default, MathML markup is imported as a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " box expression. You can convert the boxes into an expression using the ",
  StyleBox["ToExpression",
    FontFamily->"Courier"],
  " command."
}], "Text",
  CellTags->{"ImportMathML", "i:82", "b:5.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[%]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"ImportMathML", "i:82", "b:5.2"}],

Cell[BoxData[
    \(x\^2\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"i:82", "b:5.2"}]
}, Closed]],

Cell[CellGroupData[{

Cell["MathML Conversion Options", "Subsubsection",
  CellTags->{"MathMLImportConvOpt", "i:82", "b:5.2"}],

Cell[TextData[{
  "The standard ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " feature of the ",
  StyleBox["Import",
    FontFamily->"Courier"],
  " function can be used for greater control over the export process. The \
syntax for specifying a conversion option is as follows. "
}], "Text",
  CellTags->{"MathMLImportConvOpt", "i:82", "b:5.2"}],

Cell[TextData[{
  StyleBox["Import[",
    FontFamily->"Courier"],
  StyleBox["file",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"MathML\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["ConversionOptions \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["option1",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value1",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["option1",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value2",
    FontSlant->"Italic"],
  StyleBox[", ...}]",
    FontFamily->"Courier"]
}], "IndentedText",
  CellTags->{"MathMLImportConvOpt", "i:82", "b:5.2"}],

Cell[TextData[{
  "For more information on the conversion options available for importing \
MathML, see ",
  ButtonBox["XML Import Conversion Options",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->{"MathMLImportConvOpt", "i:82", "b:5.2"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Generating MathML ", "Subsection",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  "5.0",
  " includes several functions for generating MathML from the boxes and \
expressions used internally by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to represent equations. You can enter an equation in a notebook using \
palettes, menus, or keyboard shortcuts and then convert it into MathML using \
one of these conversion functions. All the MathML conversion functions are \
located in the XML`MathML` context. "
}], "Text",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[TextData[{
  "You can use ",
  StyleBox["BoxesToMathML",
    FontFamily->"Courier"],
  " to generate MathML from a box structure. By default, this generates \
presentation markup only. "
}], "Text",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`BoxesToMathML[SuperscriptBox["\<x\>", "\<2\>"]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <msup>\n  \
<mi>x</mi>\n  <mn>2</mn>\n </msup>\n</math>"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"GenMathML", "i:83", "b:5.3"}]
}, Closed]],

Cell[TextData[{
  "Alternatively, you can use ",
  StyleBox["ExpressionToMathML",
    FontFamily->"Courier"],
  " to convert a typeset equation in a notebook into MathML. By default, this \
generates combined markup with both the presentation markup and content \
markup for the equation enclosed in a ",
  StyleBox["semantics",
    FontFamily->"Courier"],
  " element. "
}], "Text",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`ExpressionToMathML[x\^2]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <semantics>\n  \
<msup>\n   <mi>x</mi>\n   <mn>2</mn>\n  </msup>\n  <annotation-xml \
encoding='MathML-Content'>\n   <apply>\n    <power/>\n    <ci>x</ci>\n    <cn \
type='integer'>2</cn>\n   </apply>\n  </annotation-xml>\n </semantics>\n\
</math>"\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"GenMathML", "i:83", "b:5.3"}]
}, Closed]],

Cell[TextData[{
  "The ",
  StyleBox["annotation-xml",
    FontFamily->"Courier"],
  " element is used to provide additional information of a type specified by \
its encoding attribute. Here, the encoding attribute has the value ",
  StyleBox["\"MathML-Content\"",
    FontFamily->"Courier"],
  " indicating that the ",
  StyleBox["annotation-xml",
    FontFamily->"Courier"],
  " element contains content MathML. "
}], "Text",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[TextData[{
  "You can use the option ",
  StyleBox["\"Formats\"",
    FontFamily->"Courier"],
  " to generate either presentation MathML or content MathML only. You can \
also set the option ",
  StyleBox["\"Annotations\"",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["{}",
    FontFamily->"Courier"],
  " to suppress the header information. For more details, see ",
  ButtonBox["MathML Conversion Options",
    ButtonStyle->"AddOnsLinkText"],
  "."
}], "Text",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`ExpressionToMathML[
      x\^2 + 1, "\<Annotations\>"\  \[Rule] {}, \[IndentingNewLine]"\<Formats\
\>"\  \[Rule] {"\<PresentationMathML\>"}]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <mrow>\n  <msup>\n \
  <mi>x</mi>\n   <mn>2</mn>\n  </msup>\n  <mo>+</mo>\n  <mn>1</mn>\n </mrow>\n\
</math>"\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->{"GenMathML", "i:83", "b:5.3"}]
}, Closed]],

Cell[TextData[{
  "It is important to note that ",
  StyleBox["ExpressionToMathML",
    FontFamily->"Courier"],
  " evaluates its first argument before converting it to MathML. Hence, if \
you supply an expression that can be simplified on evaluation, you may get \
unexpected results. For example, suppose you want to generate the \
presentation markup for the following definite integral.  "
}], "Text",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\[Integral]\_0\%\[Infinity]\( \[ExponentialE]\^\(-x\)\) \
\[DifferentialD]x\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[BoxData[
    \(1\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->{"GenMathML", "i:83", "b:5.3"}]
}, Closed]],

Cell["\<\
Since the integral evaluates to give the result 1, the following \
command generates the MathML representation of 1 instead of the integral. \
\
\>", "Text",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`ExpressionToMathML[\[Integral]\_0\%\[Infinity]\( \
\[ExponentialE]\^\(-x\)\) \[DifferentialD]x, "\<Annotations\>"\  \[Rule] {}, \
\[IndentingNewLine]"\<Formats\>"\  \[Rule] {"\<PresentationMathML\>"}]\)], \
"Input",
  CellLabel->"In[7]:=",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <mn>1</mn>\n\
</math>"\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->{"GenMathML", "i:83", "b:5.3"}]
}, Closed]],

Cell[TextData[{
  "To get the MathML representation of the integral, you must force the \
integral to remain unevaluated by wrapping the ",
  StyleBox["Unevaluated",
    FontFamily->"Courier"],
  " function around it. "
}], "Text",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`ExpressionToMathML[
      Unevaluated[\[Integral]\_0\%\[Infinity]\( \[ExponentialE]\^\(-x\)\) \
\[DifferentialD]x], "\<Annotations\>"\  \[Rule] {}, \
\[IndentingNewLine]"\<Formats\>"\  \[Rule] {"\<PresentationMathML\>"}]\)], \
"Input",
  CellLabel->"In[8]:=",
  CellTags->{"GenMathML", "i:83", "b:5.3"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <mrow>\n  \
<msubsup>\n   <mo>&#8747;</mo>\n   <mn>0</mn>\n   <mi>&#8734;</mi>\n  \
</msubsup>\n  <mrow>\n   <msup>\n    <mi>&#8519;</mi>\n    <mrow>\n     \
<mo>-</mo>\n     <mi>x</mi>\n    </mrow>\n   </msup>\n   <mo>&#8290;</mo>\n   \
<mrow>\n    <mo>&#8518;</mo>\n    <mi>x</mi>\n   </mrow>\n  </mrow>\n </mrow>\
\n</math>"\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->{"GenMathML", "i:83", "b:5.3"}]
}, Closed]],

Cell[CellGroupData[{

Cell["Setting Options", "Subsubsection",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell["These are all the functions that generate MathML as output.", "Text",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell[TextData[StyleBox["BoxesToMathML",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell[TextData[StyleBox["ExpressionToMathML",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell[TextData[StyleBox["BoxesToSymbolicMathML",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell[TextData[StyleBox["ExpressionToSymbolicMathML",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell[TextData[StyleBox["Import",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell["These functions all accept the following options.", "Text",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell[TextData[{
  "\"",
  StyleBox["Annotations",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell[TextData[{
  "\"",
  StyleBox["Formats",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell[TextData[{
  "\"",
  StyleBox["NamespacePrefixes",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell["\<\
Using these options, you can control various features of the \
generated MathML, such as including an XML declaration or DTD declaration, \
generating presentation markup, content markup, or both, and using an \
explicit namespace declaration and namespace prefix.\
\>", "Text",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell[TextData[{
  "You can specify the options explicitly each time you evaluate one of the \
MathML functions. Alternatively, you can use the ",
  StyleBox["SetOptions",
    FontFamily->"Courier"],
  " command to change the default values of the options for a particular \
function. The option values you set are then used for all subsequent \
evaluations of that function. "
}], "Text",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell[TextData[{
  "For example, evaluating the following command ensures that the output for \
all subsequent evaluations of ",
  StyleBox["ExpressionToMathML",
    FontFamily->"Courier"],
  " will by default generate presentation MathML only and omit the header \
information in the output. "
}], "Text",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(SetOptions[
      XML`MathML`ExpressionToMathML, "\<Annotations\>"\  \[Rule] {}, \
"\<Formats\>"\  \[Rule] {"\<PresentationMathML\>"}]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->{"GenMathML", "i:84", "b:5.3"}],

Cell[BoxData[
    \({"Annotations" \[Rule] {}, "CheckXML" \[Rule] True, 
      "ElementFormatting" \[Rule] Automatic, "Entities" \[Rule] None, 
      "Formats" \[Rule] {"PresentationMathML"}, 
      "NamespacePrefixes" \[Rule] {}}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->{"GenMathML", "i:84", "b:5.3"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Exporting MathML", "Subsection",
  CellTags->{"ExportMathML", "b:5.4"}],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}],

Cell[TextData[{
  "You can use ",
  "Mathematica\[CloseCurlyQuote]",
  "s sophisticated typesetting capabilities to create properly formatted \
equations and then convert them into MathML for display on the web. There are \
several ways to export mathematical expressions from a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook as MathML."
}], "Text",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}],

Cell[TextData[{
  "Use the ",
  StyleBox["Edit \[RightTriangle] Copy As \[RightTriangle] MathML",
    FontFamily->"Helvetica"],
  " menu command. This copies the selected expression into the Clipboard in \
MathML format. This is a convenient way to copy a specific mathematical \
formula from a notebook and paste it into an HTML document. "
}], "BulletedList",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}],

Cell[TextData[{
  "Use the ",
  StyleBox["File \[RightTriangle] Save As Special \[RightTriangle] XML \
(XHTML+MathML)",
    FontFamily->"Helvetica"],
  " menu command. This converts your entire notebook into XHTML with all \
equations in the notebook saved as MathML. The equations are embedded in the \
XHTML file in the form of MathML \[OpenCurlyDoubleQuote]data islands,\
\[CloseCurlyDoubleQuote] which can be displayed by a web browser, either \
directly or using a special plug-in.  "
}], "BulletedList",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}],

Cell[TextData[{
  "Use the ",
  StyleBox["File \[RightTriangle] Save As Special \[RightTriangle] XML \
(NotebookML+MathML)",
    FontFamily->"Helvetica"],
  " menu command. This converts your entire notebook into NotebookML with all \
equations in the notebook saved as MathML. "
}], "BulletedList",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}],

Cell[TextData[{
  "Use the ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " function, with ",
  StyleBox["\"MathML\"",
    FontFamily->"Courier"],
  " as the export format or with ",
  StyleBox[".mml", "MR"],
  " as the file extension."
}], "BulletedList",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<test\>", x\^2, \ "\<MathML\>"]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}],

Cell[BoxData[
    \("test"\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! test\)\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}],

Cell["\<\
<math xmlns='http://www.w3.org/1998/Math/MathML'>
 <semantics>
  <msup>
   <mi>x</mi>
   <mn>2</mn>
  </msup>
  <annotation-xml encoding='MathML-Content'>
   <apply>
    <power/>
    <ci>x</ci>
    <cn type='integer'>2</cn>
   </apply>
  </annotation-xml>
 </semantics>
</math>\
\>", "Print",
  CellLabel->"From In[11]:=",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<test.mml\>", x\^2]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}],

Cell[BoxData[
    \("test.mml"\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! test.mml\)\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}],

Cell["\<\
<math xmlns='http://www.w3.org/1998/Math/MathML'>
 <semantics>
  <msup>
   <mi>x</mi>
   <mn>2</mn>
  </msup>
  <annotation-xml encoding='MathML-Content'>
   <apply>
    <power/>
    <ci>x</ci>
    <cn type='integer'>2</cn>
   </apply>
  </annotation-xml>
 </semantics>
</math>\
\>", "Print",
  CellLabel->"From In[13]:=",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}]
}, Closed]],

Cell[TextData[{
  "The resulting output contains both presentation markup and content markup \
for the expression, enclosed in a ",
  StyleBox["semantics",
    FontFamily->"Courier"],
  " element. You can choose to generate either presentation markup or content \
markup by changing the value of the option ",
  StyleBox["\"Formats\"",
    FontFamily->"Courier"],
  ". Note that the ",
  StyleBox["xmlns",
    FontFamily->"Courier"],
  " attribute is added to the top-level ",
  StyleBox["math",
    FontFamily->"Courier"],
  " element to provide information about the namespace of the enclosed \
elements."
}], "Text",
  CellTags->{"ExportMathML", "i:85", "b:5.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["MathML Conversion Options", "Subsubsection",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  "The standard ",
  StyleBox["ConversionOptions",
    FontFamily->"Courier"],
  " feature of the ",
  StyleBox["Export",
    FontFamily->"Courier"],
  " or ",
  StyleBox["ExportString",
    FontFamily->"Courier"],
  " functions can be used for greater control over the export process. The \
syntax for specifying a conversion option is as follows. "
}], "Text",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  StyleBox["Export[",
    FontFamily->"Courier"],
  StyleBox["file",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["expr",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"MathML\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["ConversionOptions \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["option1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["option2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ...}]",
    FontFamily->"Courier"]
}], "Program",
  FontWeight->"Bold",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  StyleBox["ExportString[",
    FontFamily->"Courier"],
  StyleBox["expr",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"MathML\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["ConversionOptions \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["option1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["option2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ...}]",
    FontFamily->"Courier"]
}], "Program",
  FontWeight->"Bold",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell["\<\
Conversion options can also be specified directly in any function \
that produces MathML as output, namely:\
\>", "Text",
  CellTags->{"i:86", "b:5.4"}],

Cell[TextData[StyleBox["XML`MathML`ExpressionToMathML",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[StyleBox["XML`MathML`BoxesToMathML",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[StyleBox["XML`MathML`BoxesToSymbolicMathML",
  FontFamily->"Courier"]], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  StyleBox["XML`MathML",
    FontFamily->"Courier"],
  " ",
  StyleBox["ExpressionToSymbolicMathML",
    FontFamily->"Courier"]
}], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell["\<\
The syntax for specifying a conversion option in one of these \
functions is as follows. \
\>", "Text",
  CellTags->{"i:86", "b:5.4"}],

Cell[TextData[{
  StyleBox["XML`MathML`ExpressionToMathML[",
    FontFamily->"Courier"],
  StyleBox["expr",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["\"MathML\",",
    FontFamily->"Courier"],
  " ",
  StyleBox["option1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value1",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[",",
    FontFamily->"Courier"],
  " ",
  StyleBox["option2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[" \[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value2",
    FontFamily->"Times",
    FontSlant->"Italic"],
  StyleBox[", ...]",
    FontFamily->"Courier"]
}], "Program",
  FontWeight->"Bold",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  "When exporting as MathML, you can use any of the ",
  ButtonBox["export conversion options",
    ButtonData:>"XML Export Conversion Options",
    ButtonStyle->"AddOnsLinkText"],
  " available for exporting general XML documents. "
}], "Text",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  "\"",
  StyleBox["AttributeQuoting",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  "\"",
  StyleBox["Annotations",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  "\"",
  StyleBox["CheckXML",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  "\"",
  StyleBox["ElementFormatting",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  "\"",
  StyleBox["Entities",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  "\"",
  StyleBox["NamespacePrefixes",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  "\"",
  StyleBox["PrefixCreation",
    FontFamily->"Courier"],
  "\""
}], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell["\<\
In addition, the following three conversion options are available \
specifically for exporting MathML.\
\>", "Text",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  "\"",
  StyleBox["Formats",
    FontFamily->"Courier"],
  "\": controls whether to export presentation MathML, content MathML, or \
both."
}], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  "\"",
  StyleBox["IncludeMarkupAnnotations",
    FontFamily->"Courier"],
  "\": controls whether to include the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " encoding of the expression as an annotation."
}], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  "\"",
  StyleBox["MathAttributes",
    FontFamily->"Courier"],
  "\": provides a way to insert additional attributes into the root tag of a \
MathML expression. "
}], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}],

Cell[TextData[{
  "\"",
  StyleBox["UseUnicodePlane1Characters",
    FontFamily->"Courier"],
  "\": controls whether to include a namespace prefix for each MathML \
element."
}], "BulletedList",
  CellTags->{"MathMLExportConvOpt", "i:86", "b:5.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Annotations\"", "Subsubsection",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell[TextData[{
  "This option controls which annotations are added to the output MathML. The \
value of this option is a list whose elements can be ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["DocumentHeader",
    FontFamily->"Courier"],
  StyleBox["\", \"",
    FontFamily->"Times New Roman"],
  StyleBox["XMLDeclaration",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  ", or ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["DOCTYPEDeclaration",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  ". The order of the elements in the list is not relevant. "
}], "Text",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell["XMLDeclaration", "Subsubsubsection",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell[TextData[{
  "When ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["XMLDeclaration",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  " is one of the annotations, an XML declaration is included in the header. \
This means that the statement ",
  StyleBox["<?xml version=\"1.0\"?>",
    FontFamily->"Courier"],
  " appears in the header."
}], "Text",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<test.mml\>", x\^2, "\<MathML\>", 
      ConversionOptions \[Rule] {"\<Formats\>" \[Rule] {"\<PresentationMathML\
\>"}, "\<Annotations\>"\  \[Rule] {"\<DocumentHeader\>", \
"\<XMLDeclaration\>"}}]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell[BoxData[
    \("test.mml"\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! test.mml\)\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell["\<\
<?xml version='1.0'?>
<math xmlns='http://www.w3.org/1998/Math/MathML'>
 <msup>
  <mi>x</mi>
  <mn>2</mn>
 </msup>
</math>\
\>", "Print",
  CellLabel->"From In[15]:=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}]
}, Closed]],

Cell["DOCTYPEDeclaration", "Subsubsubsection",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell[TextData[{
  "When ",
  StyleBox["\"DOCTYPEDeclaration\"",
    FontFamily->"Courier"],
  " is one of the annotations, then an XML document type declaration of the \
form ",
  StyleBox["\"<!DOCTYPE ... >\"",
    FontFamily->"Courier"],
  " appears in the header. This is a statement that specifies the DTD for the \
XML application in which the output is written.  "
}], "Text",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<test.mml\>", x\^2, "\<MathML\>", 
      ConversionOptions \[Rule] {"\<Formats\>" \[Rule] {"\<PresentationMathML\
\>"}, "\<Annotations\>"\  \[Rule] {"\<DocumentHeader\>", \
"\<DOCTYPEDeclaration\>"}}]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell[BoxData[
    \("test.mml"\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! test.mml\)\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell["\<\
<!DOCTYPE math PUBLIC '-//W3C//DTD MathML 2.0//EN' \
'http://www.w3.org/TR/MathML2/dtd/mathml2.dtd'>
<math xmlns='http://www.w3.org/1998/Math/MathML'>
 <msup>
  <mi>x</mi>
  <mn>2</mn>
 </msup>
</math>\
\>", "Print",
  CellLabel->"From In[17]:=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}]
}, Closed]],

Cell["DocumentHeader", "Subsubsubsection",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell[TextData[{
  "With the setting ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["Annotations",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  " \[Rule]",
  StyleBox[" {\"",
    FontFamily->"Times New Roman"],
  StyleBox["DocumentHeader",
    FontFamily->"Courier"],
  StyleBox["\", \"",
    FontFamily->"Times New Roman"],
  StyleBox["XMLDeclaration",
    FontFamily->"Courier"],
  StyleBox["\", \"",
    FontFamily->"Times New Roman"],
  StyleBox["DOCTYPEDeclaration",
    FontFamily->"Courier"],
  StyleBox["\"},",
    FontFamily->"Times New Roman"],
  " a header containing an XML declaration and a document type declaration \
for the MathML DTD is",
  " ",
  "automatically added to the output. "
}], "Text",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<test.mml\>", x\^2, "\<MathML\>", 
      ConversionOptions \[Rule] {"\<Formats\>" \[Rule] {"\<PresentationMathML\
\>"}, "\<Annotations\>"\  \[Rule] {"\<DocumentHeader\>", \
"\<DOCTYPEDeclaration\>", "\<XMLDeclaration\>"}}]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell[BoxData[
    \("test.mml"\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! test.mml\)\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell["\<\
<?xml version='1.0'?>
<!DOCTYPE math PUBLIC '-//W3C//DTD MathML 2.0//EN' \
'http://www.w3.org/TR/MathML2/dtd/mathml2.dtd'>
<math xmlns='http://www.w3.org/1998/Math/MathML'>
 <msup>
  <mi>x</mi>
  <mn>2</mn>
 </msup>
</math>\
\>", "Print",
  CellLabel->"From In[19]:=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}]
}, Closed]],

Cell[TextData[{
  "When",
  StyleBox[" \"",
    FontFamily->"Times New Roman"],
  StyleBox["Annotations",
    FontFamily->"Courier"],
  StyleBox["\" ",
    FontFamily->"Times New Roman"],
  "does not contain ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["DocumentHeader",
    FontFamily->"Courier"],
  StyleBox["\", ",
    FontFamily->"Times New Roman"],
  "then the output MathML has no header. This is true even if the",
  StyleBox[" \"",
    FontFamily->"Times New Roman"],
  StyleBox["Annotations",
    FontFamily->"Courier"],
  StyleBox["\" ",
    FontFamily->"Times New Roman"],
  "contains other elements such as",
  StyleBox[" \"",
    FontFamily->"Times New Roman"],
  StyleBox["XMLDeclaration",
    FontFamily->"Courier"],
  StyleBox["\" ",
    FontFamily->"Times New Roman"],
  "or",
  StyleBox[" \"",
    FontFamily->"Times New Roman"],
  StyleBox["DOCTYPEDeclaration",
    FontFamily->"Courier"],
  StyleBox["\". ",
    FontFamily->"Times New Roman"],
  "Thu",
  StyleBox["s \"",
    FontFamily->"Times New Roman"],
  StyleBox["DocumentHeader",
    FontFamily->"Courier"],
  StyleBox["\" ",
    FontFamily->"Times New Roman"],
  "is an overall switch that controls whether the structure has a header or \
not."
}], "Text",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<test.mml\>", x\^2, "\<MathML\>", 
      ConversionOptions \[Rule] {"\<Formats\>" \[Rule] {"\<PresentationMathML\
\>"}, "\<Annotations\>"\  \[Rule] {"\<DOCTYPEDeclaration\>", \
"\<XMLDeclaration\>"}}]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell[BoxData[
    \("test.mml"\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! test.mml\)\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}],

Cell["\<\
<math xmlns='http://www.w3.org/1998/Math/MathML'>
 <msup>
  <mi>x</mi>
  <mn>2</mn>
 </msup>
</math>\
\>", "Print",
  CellLabel->"From In[21]:=",
  CellTags->{"MathMLAnnotations", "i:87", "b:5.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"Formats\"", "Subsubsection",
  CellTags->{"MathMLFormats", "i:88", "b:5.4"}],

Cell[TextData[{
  "This option controls which type of MathML markup is generated. The value \
of the option is a list that can have as its elements",
  StyleBox[" \"",
    FontFamily->"Times New Roman"],
  StyleBox["PresentationMathML",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  ", or ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["ContentMathML",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  ", or both. The default setting is ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["Formats",
    FontFamily->"Courier"],
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" {\"",
    FontFamily->"Times New Roman"],
  StyleBox["PresentationMathML",
    FontFamily->"Courier"],
  StyleBox["\", \"",
    FontFamily->"Times New Roman"],
  StyleBox["ContentMathML", "MR"],
  StyleBox["\"}",
    FontFamily->"Times New Roman"],
  ", which generates both presentation and content MathML in parallel. "
}], "Text",
  CellTags->{"MathMLFormats", "i:88", "b:5.4"}],

Cell[" The following command exports presentation MathML only.", "Text",
  CellTags->{"MathMLFormats", "i:88", "b:5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[x\^2, "\<MathML\>", 
      ConversionOptions \[Rule] {"\<Formats\>" \[Rule] {"\<PresentationMathML\
\>"}}]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->{"MathMLFormats", "i:88", "b:5.4"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <msup>\n  \
<mi>x</mi>\n  <mn>2</mn>\n </msup>\n</math>"\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->{"MathMLFormats", "i:88", "b:5.4"}]
}, Closed]],

Cell["This command exports content MathML only. ", "Text",
  CellTags->{"MathMLFormats", "i:88", "b:5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[x\^2, "\<MathML\>", 
      ConversionOptions \[Rule] {"\<Formats\>" \[Rule] \
{"\<ContentMathML\>"}}]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"MathMLFormats", "i:88", "b:5.4"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <apply>\n  \
<power/>\n  <ci>x</ci>\n  <cn type='integer'>2</cn>\n </apply>\n</math>"\)], \
"Output",
  CellLabel->"Out[23]=",
  CellTags->{"MathMLFormats", "i:88", "b:5.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"IncludeMarkupAnnotations\"", "Subsubsection",
  CellTags->{"IncludeMarkupAnnotations", "i:89", "b:5.4"}],

Cell[TextData[{
  "This option determines whether an extra annotation should be added when \
exporting a formula containing constructs specific to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " that do not have a clear counterpart in MathML. "
}], "Text",
  CellTags->{"IncludeMarkupAnnotations", "i:89", "b:5.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<IncludeMarkupAnnotations\>\"",
              FontFamily->"Courier"], 
            StyleBox["True",
              FontFamily->"Courier"], 
            RowBox[{
              StyleBox[
                RowBox[{
                  StyleBox["Mathematica\[Hyphen]",
                    FontSlant->"Italic"], "specific"}]], " ", "information", 
              " ", "is", " ", "included", " ", "in", 
              RowBox[{"a", " ", "separate", " ", 
                StyleBox["annotation",
                  FontFamily->"Courier"], " ", \(\(element\)\(.\)\)}]}]},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              
              FontFamily->
                "Courier"], \(an\ extra\ annotation\ element\ is\ not\ \
added\)}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"IncludeMarkupAnnotations", "i:89", "b:5.4"}],

Cell["\<\
The option \"IncludeMarkupAnnotations\" and its possible \
values.\
\>", "Caption",
  CellTags->{"IncludeMarkupAnnotations", "i:89", "b:5.4"}],

Cell[TextData[{
  "With the default setting, ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["IncludeMarkupAnnotations",
    FontFamily->"Courier"],
  StyleBox["\" ",
    FontFamily->"Times New Roman"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["True",
    FontFamily->"Courier"],
  ", any ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " constructs that do not have a clear equivalent in MathML, are described \
by a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " annotation enclosed in a ",
  StyleBox["semantics",
    FontFamily->"Courier"],
  " element. This allows the resulting markup to be imported back into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " losslessly. For example, the ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "special character, \[Rule], does not have a corresponding character in \
Unicode. (Unicode has a right arrow character that looks the same but does \
not have the same code point.) Hence, when exporting such a character, an \
extra annotation is added to the markup. "
}], "Text",
  CellTags->{"IncludeMarkupAnnotations", "i:89", "b:5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExportString", "[", 
      RowBox[{\(a \[Rule] b\), ",", "\"\<MathML\>\"", ",", 
        RowBox[{"ConversionOptions", "\[Rule]", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{"\"\<Formats\>\"", 
                StyleBox[" ",
                  FontFamily->"Courier"], 
                StyleBox["\[Rule]",
                  FontFamily->"Courier"], 
                StyleBox[" ",
                  FontFamily->"Courier"], "\"\<PresentationMathML\>\""}], 
              ",", \("\<IncludeMarkupAnnotations\>" \[Rule] True\)}], 
            "}"}]}]}], "]"}]], "Input",
  CellTags->{"IncludeMarkupAnnotations", "i:89", "b:5.4"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <mrow>\n  \
<mi>a</mi>\n  <semantics>\n   <mo>&#8594;</mo>\n   <annotation \
encoding='Mathematica'>&quot;\\[Rule]&quot;</annotation>\n  </semantics>\n  \
<mi>b</mi>\n </mrow>\n</math>"\)], "Output",
  CellTags->{"IncludeMarkupAnnotations", "i:89", "b:5.4"}]
}, Closed]],

Cell[TextData[{
  "With the setting, ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["IncludeMarkupAnnotations",
    FontFamily->"Courier"],
  StyleBox["\" ",
    FontFamily->"Times New Roman"],
  StyleBox["\[Rule] ",
    FontFamily->"Courier"],
  StyleBox[" ",
    FontFamily->"Times New Roman"],
  StyleBox["False",
    FontFamily->"Courier"],
  ", no extra ",
  StyleBox["annotation",
    FontFamily->"Courier"],
  " is included for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-specific constructs. "
}], "Text",
  CellTags->{"IncludeMarkupAnnotations", "i:89", "b:5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ExportString", "[", 
      RowBox[{\(a \[Rule] b\), ",", "\"\<MathML\>\"", ",", 
        RowBox[{"ConversionOptions", "\[Rule]", 
          RowBox[{"{", 
            RowBox[{
              RowBox[{"\"\<Formats\>\"", 
                StyleBox[" ",
                  FontFamily->"Courier"], 
                StyleBox["\[Rule]",
                  FontFamily->"Courier"], 
                StyleBox[" ",
                  FontFamily->"Courier"], "\"\<PresentationMathML\>\""}], 
              ",", \("\<IncludeMarkupAnnotations\>" \[Rule] False\)}], 
            "}"}]}]}], "]"}]], "Input",
  CellTags->{"IncludeMarkupAnnotations", "i:89", "b:5.4"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <mrow>\n  \
<mi>a</mi>\n  <mo>&#8594;</mo>\n  <mi>b</mi>\n </mrow>\n</math>"\)], "Output",\

  CellTags->{"IncludeMarkupAnnotations", "i:89", "b:5.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"MathAttributes\"", "Subsubsection",
  CellTags->{"MathAttributes", "i:90", "b:5.4"}],

Cell[TextData[{
  "This conversion option provides a way to add attributes to the root \
element of a MathML expression. The option has the syntax ",
  StyleBox["\"MathAttributes\" \[Rule] {",
    FontFamily->"Courier"],
  StyleBox["attribute1 ",
    FontSlant->"Italic"],
  StyleBox["\[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value1",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox[" attribute2 ",
    FontSlant->"Italic"],
  StyleBox["\[Rule] ",
    FontFamily->"Courier"],
  StyleBox["value2",
    FontSlant->"Italic"],
  StyleBox[",... ",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  ". In the following example, we export a MathML expression and specify that \
it should be displayed in inline form."
}], "Text",
  CellTags->{"MathAttributes", "i:90", "b:5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[x\^2, "\<MathML\>", 
      ConversionOptions \[Rule] {"\<MathAttributes\>" \[Rule] {"\<display\>" \
\[Rule] \ "\<inline\>"}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"MathAttributes", "i:90", "b:5.4"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'\n    \
display='inline'>\n <semantics>\n  <msup>\n   <mi>x</mi>\n   <mn>2</mn>\n  \
</msup>\n  <annotation-xml encoding='MathML-Content'>\n   <apply>\n    \
<power/>\n    <ci>x</ci>\n    <cn type='integer'>2</cn>\n   </apply>\n  \
</annotation-xml>\n </semantics>\n</math>"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"MathAttributes", "i:90", "b:5.4"}]
}, Closed]],

Cell["\<\
You can also export a MathML expression in display form, as shown \
here. \
\>", "Text",
  CellTags->{"MathAttributes", "i:90", "b:5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[x\^2, "\<MathML\>", 
      ConversionOptions \[Rule] {"\<MathAttributes\>" \[Rule] {"\<display\>" \
\[Rule] \ "\<block\>"}}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"MathAttributes", "i:90", "b:5.4"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'\n    display='block'>\
\n <semantics>\n  <msup>\n   <mi>x</mi>\n   <mn>2</mn>\n  </msup>\n  \
<annotation-xml encoding='MathML-Content'>\n   <apply>\n    <power/>\n    \
<ci>x</ci>\n    <cn type='integer'>2</cn>\n   </apply>\n  </annotation-xml>\n \
</semantics>\n</math>"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"MathAttributes", "i:90", "b:5.4"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\"UseUnicodePlane1Characters\"", "Subsubsection",
  CellTags->{"UseUnicodePlane1Characters", "i:91", "b:5.4"}],

Cell["\<\
This conversion option controls whether characters belonging to \
plane 1 of Unicode should be replaced with similar characters in plane 0. \
This option is useful because currently most browsers cannot properly display \
plane 1 characters.\
\>", "Text",
  CellTags->{"UseUnicodePlane1Characters", "i:91", "b:5.4"}],

Cell[BoxData[
    FormBox[GridBox[{
          {
            StyleBox["option",
              FontSlant->"Italic"], 
            StyleBox["value",
              FontSlant->"Italic"], 
            StyleBox["effect",
              FontSlant->"Italic"]},
          {
            StyleBox["\"\<UseUnicodePlane1Characters\>\"",
              FontFamily->"Courier"], 
            StyleBox["True",
              
              FontFamily->
                "Courier"], \(special\ characters\ belonging\ to\ plane\ 1\ \
of\ Unicode\ are\ exported\ without\ being\ replaced\)},
          {
            StyleBox["",
              SingleLetterItalics->False], 
            StyleBox["False",
              FontFamily->"Courier"], 
            RowBox[{
            "special", " ", "characters", " ", "belonging", " ", "to", " ", 
              "plane", " ", "1", " ", "of", " ", "Unicode", " ", "are", " ", 
              "replaced", " ", "by", " ", "plane", " ", "0", " ", 
              "characters", " ", "with", " ", "an", " ", "attached", " ", 
              StyleBox["mathvariant",
                FontFamily->"Courier"], " ", "attribute"}]}
          }], NotebookDefault]], "DefinitionBox3Col",
  ShowStringCharacters->True,
  GridBoxOptions->{ColumnWidths->{0.28, 0.13, 0.59},
  RowLines->{True, False}},
  CellTags->{"UseUnicodePlane1Characters", "i:91", "b:5.4"}],

Cell["\<\
The option \"UseUnicodePlane1Characters\" and its possible \
values.\
\>", "Caption",
  CellTags->{"UseUnicodePlane1Characters", "i:91", "b:5.4"}],

Cell[TextData[{
  "With the default setting, ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["UseUnicodePlane1Characters",
    FontFamily->"Courier"],
  StyleBox["\" ",
    FontFamily->"Times New Roman"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox["  ",
    FontFamily->"Times New Roman"],
  StyleBox["True",
    FontFamily->"Courier"],
  StyleBox[", special characters belonging to plane 1 of Unicode (e.g., \
Gothic, scripted, and double-struck characters), are written out with their \
plane 1 numeric character codes. ",
    FontFamily->"Times New Roman"],
  "Here is an example involving the Gothic \"g\" character. "
}], "Text",
  CellTags->{"UseUnicodePlane1Characters", "i:91", "b:5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[\[GothicG], "\<MathML\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"UseUnicodePlane1Characters", "i:91", "b:5.4"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <semantics>\n  \
<mi>&#120100;</mi>\n  <annotation-xml encoding='MathML-Content'>\n   \
<ci>&#120100;</ci>\n  </annotation-xml>\n </semantics>\n</math>"\)], "Output",\

  CellLabel->"Out[1]=",
  CellTags->{"UseUnicodePlane1Characters", "i:91", "b:5.4"}]
}, Closed]],

Cell[TextData[{
  "With the setting ",
  StyleBox["\"",
    FontFamily->"Times New Roman"],
  StyleBox["UseUnicodePlane1Characters",
    FontFamily->"Courier"],
  StyleBox["\" ",
    FontFamily->"Times New Roman"],
  StyleBox["\[Rule]",
    FontFamily->"Courier"],
  StyleBox["  ",
    FontFamily->"Times New Roman"],
  StyleBox["False",
    FontFamily->"Courier"],
  StyleBox[", any special character belonging to plane 1 of Unicode is \
replaced by a corresponding plane 0 character with a suitable value of the ",
    FontFamily->"Times New Roman"],
  StyleBox["mathvariant",
    FontFamily->"Courier"],
  StyleBox[" attribute specified. ",
    FontFamily->"Times New Roman"]
}], "Text",
  CellTags->{"UseUnicodePlane1Characters", "i:91", "b:5.4"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[\[GothicG], "\<MathML\>", 
      ConversionOptions \[Rule] {"\<UseUnicodePlane1Characters\>" \[Rule] 
            False}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"UseUnicodePlane1Characters", "i:91", "b:5.4"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <semantics>\n  <mi \
mathvariant='fraktur'>g</mi>\n  <annotation-xml encoding='MathML-Content'>\n  \
 <ci>\n    <mi mathvariant='fraktur'>g</mi>\n   </ci>\n  </annotation-xml>\n \
</semantics>\n</math>"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"UseUnicodePlane1Characters", "i:91", "b:5.4"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Symbols for MathML Elements", "Subsection",
  CellTags->{"MathMLSymbols", "i:92", "b:5.5"}],

Cell[TextData[{
  "Certain content elements in MathML do not have a direct analog in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Therefore, a few symbols are specially defined in the XML`MathML` \
context to represent these elements. These symbols are listed below with the \
MathML markup they are meant to represent. "
}], "Text",
  CellTags->{"MathMLSymbols", "i:92", "b:5.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?XML`MathML`Symbols`*\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"MathMLSymbols", "i:92", "b:5.5"}],

Cell[BoxData[GridBox[{
        {
          StyleBox["XML`MathML`Symbols`",
            FontFamily->"Helvetica",
            FontSize->12,
            FontWeight->"Bold"]},
        {GridBox[{
              {
                ButtonBox[
                  StyleBox["Cardinality",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`Cardinality"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["CovariantDerivativeIndex",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`CovariantDerivativeIndex"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["IndefiniteSum",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`IndefiniteSum"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"]},
              {
                ButtonBox[
                  StyleBox["CartesianProduct",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`CartesianProduct"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["Declare",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`Declare"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["IntervalClosed",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`IntervalClosed"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"]},
              {
                ButtonBox[
                  StyleBox["Codomain",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`Codomain"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["DerivativeIndex",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`DerivativeIndex"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["IntervalClosedOpen",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`IntervalClosedOpen"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"]},
              {
                ButtonBox[
                  StyleBox["ConditionedIntegrate",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`ConditionedIntegrate"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["Divides",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`Divides"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["IntervalOpen",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`IntervalOpen"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"]},
              {
                ButtonBox[
                  StyleBox["ConditionedLimit",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`ConditionedLimit"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["Domain",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`Domain"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["IntervalOpenClosed",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`IntervalOpenClosed"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"]},
              {
                ButtonBox[
                  StyleBox["ConditionedList",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`ConditionedList"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["DomainIntegrate",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`DomainIntegrate"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["Moment",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`Moment"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"]},
              {
                ButtonBox[
                  StyleBox["ConditionedMax",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`ConditionedMax"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["DomainOfApplication",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`DomainOfApplication"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["MomentAbout",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`MomentAbout"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"]},
              {
                ButtonBox[
                  StyleBox["ConditionedMin",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`ConditionedMin"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["DomainProduct",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`DomainProduct"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["Multiscripts",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`Multiscripts"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"]},
              {
                ButtonBox[
                  StyleBox["ConditionedProduct",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`ConditionedProduct"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["DomainSum",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`DomainSum"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["Otherwise",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`Otherwise"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"]},
              {
                ButtonBox[
                  StyleBox["ConditionedSet",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`ConditionedSet"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["Image",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`Image"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["Piece",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`Piece"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"]},
              {
                ButtonBox[
                  StyleBox["ConditionedSum",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`ConditionedSum"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["IndefiniteProduct",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`IndefiniteProduct"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"], 
                ButtonBox[
                  StyleBox["Piecewise",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951743-8292581", 
                    "XML`MathML`Symbols`Piecewise"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`Symbols`"]}
              },
            RowMinHeight->{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1.05}]}
        },
      RowSpacings->{2, 3},
      ColumnAlignments->{Left},
      ColumnsEqual->True]], "Print",
  ShowCellLabel->False,
  CellFrameMargins->{{Inherited, Inherited}, {14, 14}},
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  ButtonBoxOptions->{Active->True},
  CellTags->{"MathMLSymbols", "i:92", "b:5.5"}]
}, Closed]],

Cell["\<\
Here are some examples that use these symbols. These all have a \
traditional typeset form.\
\>", "Text",
  CellTags->{"i:92", "b:5.5"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`Piecewise[\[IndentingNewLine]XML`MathML`Piece[r, 
        0 < y < 1], \[IndentingNewLine]XML`MathML`Piece[t, 
        0 < y < 1], \[IndentingNewLine]XML`MathML`Otherwise[2]]\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->{"i:92", "b:5.5"}],

Cell[BoxData[
    \(XML`MathML`Piecewise[XML`MathML`Piece[r, 0 < y < 1], 
      XML`MathML`Piece[t, 0 < y < 1], XML`MathML`Otherwise[2]]\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->{"i:92", "b:5.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`Multiscripts[G, {{a, None}}, {{None, c}}]\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->{"i:92", "b:5.5"}],

Cell[BoxData[
    \(XML`MathML`Multiscripts[G, {{a, None}}, {{None, c}}]\)], "Output",
  CellLabel->"Out[27]=",
  CellTags->{"i:92", "b:5.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ConditionedLimit[g[x], {x \[Rule] 2, x < 3}]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->{"i:92", "b:5.5"}],

Cell[BoxData[
    \(ConditionedLimit[g[x], {x \[Rule] 2, x < 3}]\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->{"i:92", "b:5.5"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ConditionedSum[f[x], {x, x < 10}]\)], "Input",
  CellLabel->"In[29]:=",
  CellTags->{"i:92", "b:5.5"}],

Cell[BoxData[
    \(ConditionedSum[f[x], {x, x < 10}]\)], "Output",
  CellLabel->"Out[29]=",
  CellTags->{"i:92", "b:5.5"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Appendix: XML Functions in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section",
  PageBreakAbove->True],

Cell[CellGroupData[{

Cell["Introduction ", "Subsection",
  CellTags->{"XMLFunctionsIntro", "i:93", "b:6.0"}],

Cell[TextData[{
  "The following functions are used for importing, exporting, and \
manipulating XML",
  ". These functions are all placed in the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context and are loaded automatically, when needed. "
}], "Text",
  CellTags->{"XMLFunctionsIntro", "i:93", "b:6.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?XML`*\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"XMLFunctionsIntro", "i:93", "b:6.0"}],

Cell[BoxData[GridBox[{
        {
          StyleBox["XML`",
            FontFamily->"Helvetica",
            FontSize->12,
            FontWeight->"Bold"]},
        {GridBox[{
              {
                ButtonBox[
                  StyleBox["FromSymbolicXML",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951728-4656356", 
                    "XML`FromSymbolicXML"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`"], 
                ButtonBox[
                  StyleBox["SymbolicXMLErrors",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951728-4656356", 
                    "XML`SymbolicXMLErrors"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`"], 
                ButtonBox[
                  StyleBox["ToCompactXML",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262951728-4656356", "XML`ToCompactXML"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`"], 
                ButtonBox[
                  StyleBox["ToVerboseXML",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262951728-4656356", "XML`ToVerboseXML"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`"], ""},
              {
                ButtonBox[
                  StyleBox["RawXML",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262951728-4656356", "XML`RawXML"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`"], 
                ButtonBox[
                  StyleBox["SymbolicXMLQ",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262951728-4656356", "XML`SymbolicXMLQ"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`"], 
                ButtonBox[
                  StyleBox["ToSymbolicXML",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262951728-4656356", "XML`ToSymbolicXML"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"XML`"], "", ""}
              },
            RowMinHeight->{1, 1.05}]}
        },
      RowSpacings->{2, 3},
      ColumnAlignments->{Left},
      ColumnsEqual->True]], "Print",
  ShowCellLabel->False,
  CellFrameMargins->{{Inherited, Inherited}, {14, 14}},
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  ButtonBoxOptions->{Active->True},
  CellTags->{"XMLFunctionsIntro", "i:93", "b:6.0"}]
}, Closed]],

Cell[TextData[{
  "An additional set of functions is found in the ",
  StyleBox["XML`Parser",
    FontFamily->"Courier"],
  " context."
}], "Text",
  CellTags->{"XMLFunctionsIntro", "i:93", "b:6.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?XML`Parser`*\)\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"XMLFunctionsIntro", "i:93", "b:6.0"}],

Cell[BoxData[GridBox[{
        {
          StyleBox["XML`Parser`",
            FontFamily->"Helvetica",
            FontSize->12,
            FontWeight->"Bold"]},
        {GridBox[{
              {
                ButtonBox[
                  StyleBox["InitializeXMLParser",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951729-7061535", 
                    "XML`Parser`InitializeXMLParser"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`Parser`"], 
                ButtonBox[
                  StyleBox["XMLGet",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  ButtonData:>{"Info3262951729-7061535", "XML`Parser`XMLGet"},
                  
                  ButtonFrame->"None",
                  ButtonNote->"XML`Parser`"], 
                ButtonBox[
                  StyleBox["XMLParser",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951729-7061535", 
                    "XML`Parser`XMLParser"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`Parser`"], ""},
              {
                ButtonBox[
                  StyleBox["ReleaseXMLParser",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951729-7061535", 
                    "XML`Parser`ReleaseXMLParser"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`Parser`"], 
                ButtonBox[
                  StyleBox["XMLGetString",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951729-7061535", 
                    "XML`Parser`XMLGetString"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`Parser`"], "", ""}
              },
            RowMinHeight->{1, 1.05}]}
        },
      RowSpacings->{2, 3},
      ColumnAlignments->{Left},
      ColumnsEqual->True]], "Print",
  ShowCellLabel->False,
  CellFrameMargins->{{Inherited, Inherited}, {14, 14}},
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  ButtonBoxOptions->{Active->True},
  CellTags->{"XMLFunctionsIntro", "i:93", "b:6.0"}]
}, Closed]],

Cell[TextData[{
  "The following functions are used for converting between NotebookML or \
ExpressionML and",
  " other formats. These functions are all placed in the ",
  StyleBox["XML`NotebookML`",
    FontFamily->"Courier"],
  " context and are loaded automatically, when needed. "
}], "Text",
  CellTags->{"XMLFunctionsIntro", "i:93", "b:6.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?XML`NotebookML`*\)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"XMLFunctionsIntro", "i:93", "b:6.0"}],

Cell[BoxData[GridBox[{
        {
          StyleBox["XML`NotebookML`",
            FontFamily->"Helvetica",
            FontSize->12,
            FontWeight->"Bold"]},
        {GridBox[{
              {
                ButtonBox[
                  StyleBox["ExpressionToSymbolicExpressionML",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951729-4263635", 
                    "XML`NotebookML`ExpressionToSymbolicExpressionML"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`NotebookML`"], 
                ButtonBox[
                  StyleBox["SymbolicExpressionMLToExpression",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951729-4263635", 
                    "XML`NotebookML`SymbolicExpressionMLToExpression"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`NotebookML`"]},
              {
                ButtonBox[
                  StyleBox["NotebookToSymbolicNotebookML",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951729-4263635", 
                    "XML`NotebookML`NotebookToSymbolicNotebookML"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`NotebookML`"], 
                ButtonBox[
                  StyleBox["SymbolicNotebookMLToNotebook",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3262951729-4263635", 
                    "XML`NotebookML`SymbolicNotebookMLToNotebook"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`NotebookML`"]}
              },
            RowMinHeight->{1, 1.05}]}
        },
      RowSpacings->{2, 3},
      ColumnAlignments->{Left},
      ColumnsEqual->True]], "Print",
  ShowCellLabel->False,
  CellFrameMargins->{{Inherited, Inherited}, {14, 14}},
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  ButtonBoxOptions->{Active->True},
  CellTags->{"XMLFunctionsIntro", "i:93", "b:6.0"}]
}, Closed]],

Cell[TextData[{
  "The following functions are used for",
  " converting between MathML and the boxes and expressions used internally \
by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to represent equations. These functions are all placed in the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context and are loaded automatically, when needed. "
}], "Text",
  CellTags->{"XMLFunctionsIntro", "i:93", "b:6.0"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?XML`MathML`*\)\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"XMLFunctionsIntro", "i:93", "b:6.0"}],

Cell[BoxData[GridBox[{
        {
          StyleBox["XML`MathML`",
            FontFamily->"Helvetica",
            FontSize->12,
            FontWeight->"Bold"]},
        {GridBox[{
              {
                ButtonBox[
                  StyleBox["BoxesToMathML",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3253363687-7261501", 
                    "XML`MathML`BoxesToMathML"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`"], 
                ButtonBox[
                  StyleBox["ExpressionToSymbolicMathML",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3253363687-7261501", 
                    "XML`MathML`ExpressionToSymbolicMathML"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`"], 
                ButtonBox[
                  StyleBox["SymbolicMathMLToBoxes",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3253363687-7261501", 
                    "XML`MathML`SymbolicMathMLToBoxes"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`"]},
              {
                ButtonBox[
                  StyleBox["BoxesToSymbolicMathML",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3253363687-7261501", 
                    "XML`MathML`BoxesToSymbolicMathML"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`"], 
                ButtonBox[
                  StyleBox["MathMLToBoxes",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3253363687-7261501", 
                    "XML`MathML`MathMLToBoxes"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`"], 
                ButtonBox[
                  StyleBox["SymbolicMathMLToExpression",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3253363687-7261501", 
                    "XML`MathML`SymbolicMathMLToExpression"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`"]},
              {
                ButtonBox[
                  StyleBox["ExpressionToMathML",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3253363687-7261501", 
                    "XML`MathML`ExpressionToMathML"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`"], 
                ButtonBox[
                  StyleBox["MathMLToExpression",
                    FontColor->RGBColor[0, 0, 1],
                    FontVariations->{"Underline"->True}],
                  
                  ButtonFunction:>(
                    Internal`PutInformation[ #, LongForm -> False]&),
                  ButtonEvaluator->Automatic,
                  
                  ButtonData:>{"Info3253363687-7261501", 
                    "XML`MathML`MathMLToExpression"},
                  ButtonFrame->"None",
                  ButtonNote->"XML`MathML`"], ""}
              },
            RowMinHeight->{1, 1, 1.05}]}
        },
      RowSpacings->{2, 3},
      ColumnAlignments->{Left},
      ColumnsEqual->True]], "Print",
  ShowCellLabel->False,
  CellFrameMargins->{{Inherited, Inherited}, {14, 14}},
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  ButtonBoxOptions->{Active->True},
  CellTags->{"XMLFunctionsIntro", "i:93", "b:6.0"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["XML Functions ", "Subsection",
  CellTags->"b:6.1"],

Cell[CellGroupData[{

Cell["SymbolicXMLQ", "ObjectName",
  CellTags->{"SymXMLQ", "i:94", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SymbolicXMLQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " returns ",
  StyleBox["True",
    FontFamily->"Courier"],
  " if the expression ",
  StyleBox["expr ", "TI"],
  "matches some basic patterns for a SymbolicXML expression and returns ",
  StyleBox["False",
    FontFamily->"Courier"],
  " otherwise.\n\[FilledSmallSquare] ",
  StyleBox["SymbolicXMLQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",True]", "MR"],
  " will perform a complete test on ",
  StyleBox["expr",
    FontSlant->"Italic"],
  " to determine if it is a well-formed SymbolicXML expression. \n\
\[FilledSmallSquare] ",
  StyleBox["SymbolicXMLQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[",False]", "MR"],
  " is equivalent to ",
  StyleBox["SymbolicXMLQ[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  "."
}], "Usage",
  CellTags->{"SymXMLQ", "i:94", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function is not a guarantee that the document is \
well formed, nor does it give hints about validation.\n\[FilledSmallSquare] \
This function exists only in the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context. Hence, when doing an evaluation, you must specify the function \
name as ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  StyleBox["SymbolicXMLQ", "MR"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"SymXMLQ", "i:94", "b:6.1"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"SymXMLQ", "i:94", "b:6.1"}],

Cell[TextData[{
  "In the following expression, the ",
  StyleBox["{",
    FontFamily->"Courier"],
  StyleBox["attribute",
    FontSlant->"Italic"],
  "\[Rule]",
  StyleBox["value",
    FontSlant->"Italic"],
  StyleBox["}",
    FontFamily->"Courier"],
  StyleBox["portion of the SymbolicXML statement is malformed; therefore, ",
    FontFamily->"Times New Roman"],
  StyleBox["SymbolicXMLQ",
    FontFamily->"Courier"],
  StyleBox[" returns the value ",
    FontFamily->"Times New Roman"],
  StyleBox["False",
    FontFamily->"Courier"],
  StyleBox[".",
    FontFamily->"Times New Roman"]
}], "Text",
  CellTags->{"SymXMLQ", "i:94", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`SymbolicXMLQ[XMLElement["\<2001: A Space Odyssey\>", {author}, {}], 
      True]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"SymXMLQ", "i:94", "b:6.1"}],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"SymXMLQ", "i:94", "b:6.1"}]
}, Closed]],

Cell[TextData[{
  "Here we have fixed our problem, and ",
  StyleBox["SymbolicXMLQ",
    FontFamily->"Courier"],
  " returns the value ",
  StyleBox["True",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"SymXMLQ", "i:94", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`SymbolicXMLQ[
      XMLElement["\<2001: A Space Odyssey\>", {"\<author\>"\  \[Rule] \ \
"\<Arthur C. Clarke\>"}, {}], True]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"SymXMLQ", "i:94", "b:6.1"}],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"SymXMLQ", "i:94", "b:6.1"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["FromSymbolicXML", "ObjectName",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FromSymbolicXML[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " converts a SymbolicXML expression ",
  StyleBox["expr", "TI"],
  " to a more native format, if one is available."
}], "Usage",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["FromSymbolicXML",
    FontFamily->"Courier"],
  " is the inverse of To ",
  StyleBox["SymbolicXML",
    FontFamily->"Courier"],
  ". Given a SymbolicXML expression, ",
  StyleBox["FromSymbolicXML",
    FontFamily->"Courier"],
  " will attempt to interpret the SymbolicXML."
}], "Notes",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  StyleBox["FromSymbolicXML", "MR"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[TextData[{
  "First, we create a NotebookML file using ",
  StyleBox["Export",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<example1\>", \ 
      Notebook[{Cell["\<I am a test file\>"]}], \ "\<XML\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[BoxData[
    \("example1"\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}]
}, Closed]],

Cell["Now import this NotebookML file as SymbolicXML.", "Text",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Import["\<example1\>", \ "\<SymbolicXML\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Declaration"]\)[
          "Version" \[Rule] "1.0"], \(XMLObject["Doctype"]\)["Notebook", 
          "System" \[Rule] "http://www.wolfram.com/XML/notebookml1.dtd"]}, 
      XMLElement[
        "Notebook", {"CreatedBy" \[Rule] 
            "Mathematica 5.0", {"http://www.w3.org/2000/xmlns/", 
              "xhtml"} \[Rule] 
            "http://www.w3.org/1999/xhtml", {"http://www.w3.org/2000/xmlns/", 
              "mathematica"} \[Rule] 
            "http://www.wolfram.com/XML/", {"http://www.w3.org/2000/xmlns/", 
              "xmlns"} \[Rule] "http://www.wolfram.com/XML/"}, {XMLElement[
            "List", {}, {XMLElement[
                "Cell", {}, {XMLElement[
                    "String", {}, {"I am a test file"}]}]}]}], {}, 
      "Valid" \[Rule] True]\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}]
}, Closed]],

Cell[TextData[{
  "Finally, we use the output as the argument for ",
  StyleBox["FromSymbolicXML",
    FontFamily->"Courier"],
  " to interpret the SymbolicXML as a notebook expression."
}], "Text",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`FromSymbolicXML[%]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[BoxData[
    \(Notebook[{Cell["I am a test file"]}]\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}]
}, Closed]],

Cell["As a second example, let us create a MathML file.", "Text",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<example2\>", \ x^3, \ "\<XML\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[BoxData[
    \("example2"\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(!! example2\),
      "Input"]], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell["\<\
<?xml version='1.0'?>
<!DOCTYPE Expression SYSTEM 'http://www.wolfram.com/XML/notebookml1.dtd'>
<Expression xmlns:mathematica='http://www.wolfram.com/XML/'
    xmlns='http://www.wolfram.com/XML/'>
 <Function>
  <Symbol>Power</Symbol>
  <Symbol>x</Symbol>
  <Number>3</Number>
 </Function>
</Expression>\
\>", "Print",
  CellLabel->"From In[6]:=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}]
}, Closed]],

Cell["Now we import the file as SymbolicXML.", "Text",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Import["\<example2\>", \ "\<SymbolicXML\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Declaration"]\)[
          "Version" \[Rule] "1.0"], \(XMLObject["Doctype"]\)["Expression", 
          "System" \[Rule] "http://www.wolfram.com/XML/notebookml1.dtd"]}, 
      XMLElement[
        "Expression", {{"http://www.w3.org/2000/xmlns/", 
              "mathematica"} \[Rule] 
            "http://www.wolfram.com/XML/", {"http://www.w3.org/2000/xmlns/", 
              "xmlns"} \[Rule] "http://www.wolfram.com/XML/"}, {XMLElement[
            "Function", {}, {XMLElement["Symbol", {}, {"Power"}], 
              XMLElement["Symbol", {}, {"x"}], 
              XMLElement["Number", {}, {"3"}]}]}], {}, 
      "Valid" \[Rule] True]\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}]
}, Closed]],

Cell[TextData[{
  "Finally, we use ",
  StyleBox["FromSymbolicXML",
    FontFamily->"Courier"],
  " to interpret the output as a box expression."
}], "Text",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`FromSymbolicXML[%]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}],

Cell[BoxData[
    \(x\^3\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->{"FromSymbolicXML", "i:95", "b:6.1"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ToSymbolicXML", "ObjectName",
  CellTags->{"ToSymbolicXML", "i:96", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ToSymbolicXML[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " converts an expression ",
  StyleBox["expr", "TI"],
  " to an appropriate XML format and returns the result as SymbolicXML."
}], "Usage",
  CellTags->{"ToSymbolicXML", "i:96", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ToSymbolicXML",
    FontFamily->"Courier"],
  " is the inverse of ",
  StyleBox["FromSymbolicXML",
    FontFamily->"Courier"],
  ". For example, if a notebook expression is given, the result is \
SymbolicXML representing a NotebookML expression."
}], "Notes",
  CellTags->{"ToSymbolicXML", "i:96", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] Use ",
  StyleBox["ToSymbolicXML",
    FontFamily->"Courier"],
  " if you only want to generate SymbolicXML with no output to a file. Once \
the SymbolicXML is generated, you can write it to a file with ",
  StyleBox["Export",
    FontFamily->"Courier"],
  "."
}], "Notes",
  CellTags->{"ToSymbolicXML", "i:96", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`ToS",
    FontFamily->"Courier"],
  StyleBox["ymbolicXML", "MR"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"ToSymbolicXML", "i:96", "b:6.1"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ToSymbolicXML", "i:96", "b:6.1"}],

Cell[TextData[{
  "This example will take the expression ",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          StyleBox["x",
            FontFamily->"Courier"], "2"], TraditionalForm]]],
  " and will return the corresponding SymbolicXML."
}], "Text",
  CellTags->{"ToSymbolicXML", "i:96", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`ToSymbolicXML[x^2]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->{"ToSymbolicXML", "i:96", "b:6.1"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Declaration"]\)[
          "Version" \[Rule] "1.0"], \(XMLObject["Doctype"]\)["Expression", 
          "System" \[Rule] "http://www.wolfram.com/XML/notebookml1.dtd"]}, 
      XMLElement[
        "Expression", {{"http://www.w3.org/2000/xmlns/", 
              "mathematica"} \[Rule] "http://www.wolfram.com/XML/", 
          "xmlns" \[Rule] "http://www.wolfram.com/XML/"}, {XMLElement[
            "Function", {}, {XMLElement["Symbol", {}, {"Power"}], 
              XMLElement["Symbol", {}, {"x"}], 
              XMLElement["Number", {}, {"2"}]}]}], {}]\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->{"ToSymbolicXML", "i:96", "b:6.1"}]
}, Closed]],

Cell["Here is an example using a notebook expression.", "Text",
  CellTags->{"ToSymbolicXML", "i:96", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`ToSymbolicXML[
      Notebook[{Cell["\<Here is a notebook example\>"]}]]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->{"ToSymbolicXML", "i:96", "b:6.1"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Declaration"]\)[
          "Version" \[Rule] "1.0"], \(XMLObject["Doctype"]\)["Notebook", 
          "System" \[Rule] "http://www.wolfram.com/XML/notebookml1.dtd"]}, 
      XMLElement[
        "Notebook", {"CreatedBy" \[Rule] 
            "Mathematica 5.0", {"http://www.w3.org/2000/xmlns/", 
              "xhtml"} \[Rule] 
            "http://www.w3.org/1999/xhtml", {"http://www.w3.org/2000/xmlns/", 
              "mathematica"} \[Rule] 
            "http://www.wolfram.com/XML/", {"http://www.w3.org/2000/xmlns/", 
              "xmlns"} \[Rule] "http://www.wolfram.com/XML/"}, {XMLElement[
            "List", {}, {XMLElement[
                "Cell", {}, {XMLElement[
                    "String", {}, {"Here is a notebook example"}]}]}]}], \
{}]\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->{"ToSymbolicXML", "i:96", "b:6.1"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SymbolicXMLErrors", "ObjectName",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SymbolicXMLErrors[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " returns a list of part specifications of places where there are errors in \
the SymbolicXML expression ",
  StyleBox["expr. ", "TI"],
  "It will return an error message for each error and will give an indication \
of the nature of the error."
}], "Usage",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function is intended as a utility for debugging \
only.\n\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  StyleBox["SymbolicXMLErrors", "MR"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}],

Cell["\<\
Here we have a very large SymbolicXML expression with one small \
error buried inside it.\
\>", "Text",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}],

Cell[BoxData[
    \(\(largeSymbolicXMLWithError = \
\(XMLObject["\<Document\>"]\)[{\(XMLObject["\<Declaration\>"]\)["\<Version\>" \
\[Rule] "\<1.0\>"]}, 
          XMLElement["\<Notebook\>", {{"\<http://www.w3.org/2000/xmlns/\>", "\
\<xmlns\>"} \[Rule] "\<http://www.wolfram.com/Mathematica\>", \
{"\<http://www.w3.org/2000/xmlns/\>", "\<mathematica\>"} \[Rule] \
"\<http://www.wolfram.com/Mathematica\>", "\<CreatedBy\>" \[Rule] \
"\<NotebookMLSave0.34\>"}, {XMLElement["\<List\>", {}, \
{XMLElement["\<Cell\>", {}, {XMLElement["\<BoxData\>", {}, \
{XMLElement["\<List\>", {}, {XMLElement["\<RowBox\>", {}, {XMLElement["\<List\
\>", {}, {XMLElement["\<String\>", {}, {"\<Needs\>"}], 
                                      XMLElement["\<String\>", {}, \
{"\<[\>"}], XMLElement["\<String\>", {}, {"\<\"XML`\"\>"}], 
                                      XMLElement["\<String\>", {}, \
{"\<]\>"}]}]}]}]}], 
                      XMLElement["\<Style\>", {}, {XMLElement["\<String\>", \
{}, {"\<Input\>"}]}]}], 
                  XMLElement["\<Cell\>", {}, {XMLElement["\<CellGroupData\>", \
{}, {XMLElement["\<List\>", {}, {XMLElement["\<Cell\>", {}, \
{XMLElement["\<BoxData\>", {}, {XMLElement["\<List\>", {}, \
{XMLElement["\<RowBox\>", {}, {XMLElement["\<List\>", {}, \
{XMLElement["\<String\>", {}, {"\<Export\>"}], 
                                        XMLElement["\<String\>", {}, \
{"\<[\>"}], 
                                        XMLElement["\<RowBox\>", {}, \
{XMLElement["\<List\>", {}, {XMLElement["\<String\>", {}, \
{"\<\"temp.xml\"\>"}], XMLElement["\<String\>", {}, {"\<,\>"}], 
                                        XMLElement["\<RowBox\>", {}, \
{XMLElement["\<List\>", {}, {XMLElement["\<String\>", {}, \
{"\<XMLElement\>"}], XMLElement["\<String\>", {}, {"\<[\>"}], 
                                        XMLElement["\<RowBox\>", {}, \
{XMLElement["\<List\>", {}, {XMLElement["\<String\>", {}, {"\<\"foo\"\>"}], 
                                        XMLElement["\<String\>", {}, \
{"\<,\>"}], 
                                        XMLElement["\<RowBox\>", {}, \
{XMLElement["\<List\>", {}, {XMLElement["\<String\>", {}, {"\<{\>"}], 
                                        XMLElement["\<String\>", {}, \
{"\<}\>"}]}]}], XMLElement["\<String\>", {}, {"\<,\>"}], 
                                        XMLElement["\<RowBox\>", {}, \
{XMLElement["\<List\>", {}, {XMLElement["\<String\>", {}, {"\<{\>"}], 
                                        XMLElement["\<String\>", {}, \
{"\<}\>"}]}]}]}]}], XMLElement["\<String\>", {}, {"\<]\>"}]}]}]}]}], 
                                        XMLElement["\<String\>", {}, \
{"\<]\>"}]}]}]}]}], 
                                  XMLElement["\<Style\>", {}, \
{XMLElement["\<String\>", {}, {"\<Input\>"}]}]}], 
                              XMLElement["\<Cell\>", {}, \
{XMLElement["\<BoxData\>", {}, {XMLElement["\<List\>", {}, \
{XMLElement["\<String\>", {}, {"\<\"temp.xml\"\>"}]}]}], 
                                  XMLElement["\<Style\>", {}, \
{XMLElement["\<String\>", {}, {"\<Output\>"}]}]}]}], 
                          XMLElement["\<Symbol\>", {}, {"\<Open\>"}]}]}], 
                  XMLElement["\<Cell\>", {}, {XMLElement["\<BoxData\>", {}, \
{XMLElement["\<List\>", {}, {XMLElement["\<RowBox\>", {XMLElement["\<List\>", \
{}, {XMLElement["\<String\>", {}, {"\<Export\>"}], 
                                      XMLElement["\<String\>", {}, \
{"\<[\>"}], 
                                      XMLElement["\<RowBox\>", {}, \
{XMLElement["\<List\>", {}, {XMLElement["\<String\>", {}, \
{"\<\"nb.xml\"\>"}], XMLElement["\<String\>", {}, {"\<,\>"}], 
                                        XMLElement["\<RowBox\>", {}, \
{XMLElement["\<List\>", {}, {XMLElement["\<String\>", {}, \
{"\<NotebookGet\>"}], XMLElement["\<String\>", {}, {"\<[\>"}], 
                                        XMLElement["\<RowBox\>", {}, \
{XMLElement["\<List\>", {}, {XMLElement["\<String\>", {}, \
{"\<SelectedNotebook\>"}], XMLElement["\<String\>", {}, {"\<[\>"}], 
                                        XMLElement["\<String\>", {}, \
{"\<]\>"}]}]}], XMLElement["\<String\>", {}, {"\<]\>"}]}]}]}]}], 
                                      XMLElement["\<String\>", {}, \
{"\<]\>"}]}]}]}]}], 
                      XMLElement["\<Style\>", {}, {XMLElement["\<String\>", \
{}, {"\<Input\>"}]}]}]}], 
              XMLElement["\<NotebookOptions\>", {}, \
{XMLElement["\<FrontEndVersion\>", {}, {"\<4.1 for Macintosh\>"}], 
                  XMLElement["\<ScreenRectangle\>", {}, \
{XMLElement["\<List\>", {}, {XMLElement["\<Number\>", {}, {"\<0.\>"}], 
                          XMLElement["\<Number\>", {}, {"\<800.\>"}]}], 
                      XMLElement["\<List\>", {}, {XMLElement["\<Number\>", \
{}, {"\<0.\>"}], XMLElement["\<Number\>", {}, {"\<580.\>"}]}]}], 
                  XMLElement["\<WindowSize\>", {}, {XMLElement["\<Number\>", \
{}, {"\<520.\>"}], XMLElement["\<Number\>", {}, {"\<458.\>"}]}], 
                  XMLElement["\<WindowMargins\>", {}, {XMLElement["\<List\>", \
{}, {XMLElement["\<Number\>", {}, {"\<9.\>"}], 
                          XMLElement["\<Symbol\>", {}, {"\<Automatic\>"}]}], 
                      XMLElement["\<List\>", {}, {XMLElement["\<Symbol\>", \
{}, {"\<Automatic\>"}], XMLElement["\<Number\>", {}, {"\<21.\>"}]}]}], 
                  XMLElement["\<MacintoshSystemPageSetup\>", {}, \
{"\<0@00D01804P000000]X2:?oQon82n@96D005:0?l0040D01804P000000]X2:000 \
0000I0000000000000000BL?00400@00000000000000000B0002I0000aP00000 \
8W800@0100<00P0000000000oW`10000\>"}]}]}], {}];\)\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}],

Cell[TextData[{
  StyleBox["SymbolicXMLQ",
    FontFamily->"Courier"],
  " indicates that there is an error in this expression, but it is very hard \
to find it."
}], "Text",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`SymbolicXMLQ[largeSymbolicXMLWithError, \ True]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[12]=",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}]
}, Closed]],

Cell[TextData[{
  "Using ",
  StyleBox["SymbolicXMLErrors",
    FontFamily->"Courier"],
  ", we get a part specification indicating exactly where the error occurred, \
as well as a message indicating the nature of the problem."
}], "Text",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`SymbolicXMLErrors[largeSymbolicXMLWithError]\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}],

Cell[BoxData[
    \(XMLElement::"argrx" \(\(:\)\(\ \)\) 
      "\!\(XMLElement\) called with \!\(2\) arguments; \!\(3\) arguments are \
expected."\)], "Message",
  CellLabel->"From In[13]:=",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}],

Cell[BoxData[
    \({{2, 3, 1, 3, 3, 3, 1, 3, 1, 3, 1}}\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}]
}, Closed]],

Cell[TextData[{
  "Here we see that ",
  StyleBox["XMLElement",
    FontFamily->"Courier"],
  " only has two arguments\[LongDash]the list for the attributes is missing."
}], "Text",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(largeSymbolicXMLWithError[\([2, 3, 1, 3, 3, 3, 1, 3, 1, 3, 
        1]\)]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}],

Cell[BoxData[
    \(XMLElement[
      "RowBox", {XMLElement[
          "List", {}, {XMLElement["String", {}, {"Export"}], 
            XMLElement["String", {}, {"["}], 
            XMLElement[
              "RowBox", {}, {XMLElement[
                  "List", {}, {XMLElement["String", {}, {"\"nb.xml\""}], 
                    XMLElement["String", {}, {","}], 
                    XMLElement[
                      "RowBox", {}, {XMLElement[
                          "List", {}, {XMLElement[
                              "String", {}, {"NotebookGet"}], 
                            XMLElement["String", {}, {"["}], 
                            XMLElement[
                              "RowBox", {}, {XMLElement[
                                  "List", {}, {XMLElement[
                                      "String", {}, {"SelectedNotebook"}], 
                                    XMLElement["String", {}, {"["}], 
                                    XMLElement["String", {}, {"]"}]}]}], 
                            XMLElement["String", {}, {"]"}]}]}]}]}], 
            XMLElement["String", {}, {"]"}]}]}]\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->{"SymbolicXMLErrors", "i:97", "b:6.1"}]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ToVerboseXML", "ObjectName",
  CellTags->{"ToVerboseXML", "i:98", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ToVerboseXML[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " will generate an equivalent SymbolicXML expression that explicitly \
exposes all the namespace information for the elements and the attributes in \
",
  StyleBox["expr", "TI"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["ToVerboseXML[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["pattern", "TI"],
  StyleBox["]", "MR"],
  " will expose only namespaces that match ",
  StyleBox["pattern", "TI"],
  "."
}], "Usage",
  CellTags->{"ToVerboseXML", "i:98", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  StyleBox["ToVerboseXML", "MR"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"ToVerboseXML", "i:98", "b:6.1"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"ToVerboseXML", "i:98", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`ToVerboseXML[
      XMLElement["\<Expression\>", {{"\<http://www.w3.org/2000/xmlns/\>", \
"\<mathematica\>"} \[Rule] "\<http://www.wolfram.com/XML/\>", "\<xmlns\>" \
\[Rule] "\<http://www.wolfram.com/XML/\>"}, {XMLElement["\<Function\>", {}, \
{XMLElement["\<Symbol\>", {}, {"\<MathMLForm\>"}], 
              XMLElement["\<Function\>", {}, {XMLElement["\<Symbol\>", {}, {"\
\<Power\>"}], XMLElement["\<Symbol\>", {}, {"\<x\>"}], 
                  XMLElement["\<Number\>", {}, {"\<2\>"}]}]}]}]]\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->{"ToVerboseXML", "i:98", "b:6.1"}],

Cell[BoxData[
    \(XMLElement[{"http://www.wolfram.com/XML/", 
        "Expression"}, {{"http://www.w3.org/2000/xmlns/", 
            "mathematica"} \[Rule] 
          "http://www.wolfram.com/XML/", {"http://www.w3.org/2000/xmlns/", 
            "xmlns"} \[Rule] 
          "http://www.wolfram.com/XML/"}, \
{XMLElement[{"http://www.wolfram.com/XML/", 
            "Function"}, {}, {XMLElement[{"http://www.wolfram.com/XML/", 
                "Symbol"}, {}, {"MathMLForm"}], 
            XMLElement[{"http://www.wolfram.com/XML/", 
                "Function"}, {}, {XMLElement[{"http://www.wolfram.com/XML/", 
                    "Symbol"}, {}, {"Power"}], 
                XMLElement[{"http://www.wolfram.com/XML/", 
                    "Symbol"}, {}, {"x"}], 
                XMLElement[{"http://www.wolfram.com/XML/", 
                    "Number"}, {}, {"2"}]}]}]}]\)], "Output",
  CellLabel->"Out[15]=",
  CellTags->{"ToVerboseXML", "i:98", "b:6.1"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ToCompactXML", "ObjectName",
  CellTags->{"ToCompactXML", "i:99", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ToCompactXML[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " will generate an equivalent SymbolicXML expression that suppresses all \
the redundant namespace information for the elements and the attributes in ",
  StyleBox["expr", "TI"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["ToCompactXML[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["pattern", "TI"],
  StyleBox["]", "MR"],
  " will suppress only namespaces that match ",
  StyleBox["pattern", "TI"],
  "."
}], "Usage",
  CellTags->{"ToCompactXML", "i:99", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  StyleBox["ToCompactXML", "MR"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"ToCompactXML", "i:99", "b:6.1"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"ToCompactXML", "i:99", "b:6.1"}],

Cell[TextData[{
  "In this example, we use the verbose XML generated in the example for ",
  StyleBox["ToVerboseXML",
    FontFamily->"Courier"],
  " as the argument for ",
  StyleBox["ToCompactXML",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"ToCompactXML", "i:99", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`ToCompactXML[
      XMLElement[{"\<http://www.wolfram.com/XML/\>", "\<Expression\>"}, \
{{"\<http://www.w3.org/2000/xmlns/\>", "\<mathematica\>"} \[Rule] \
"\<http://www.wolfram.com/XML/\>", {"\<http://www.w3.org/2000/xmlns/\>", \
"\<xmlns\>"} \[Rule] "\<http://www.wolfram.com/XML/\>"}, \
{XMLElement[{"\<http://www.wolfram.com/XML/\>", "\<Function\>"}, {}, \
{XMLElement[{"\<http://www.wolfram.com/XML/\>", "\<Symbol\>"}, {}, \
{"\<MathMLForm\>"}], 
              XMLElement[{"\<http://www.wolfram.com/XML/\>", "\<Function\>"}, \
{}, {XMLElement[{"\<http://www.wolfram.com/XML/\>", "\<Symbol\>"}, {}, \
{"\<Power\>"}], 
                  XMLElement[{"\<http://www.wolfram.com/XML/\>", \
"\<Symbol\>"}, {}, {"\<x\>"}], 
                  XMLElement[{"\<http://www.wolfram.com/XML/\>", \
"\<Number\>"}, {}, {"\<2\>"}]}]}]}]]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->{"ToCompactXML", "i:99", "b:6.1"}],

Cell[BoxData[
    \(XMLElement[
      "Expression", {{"http://www.w3.org/2000/xmlns/", "mathematica"} \[Rule] 
          "http://www.wolfram.com/XML/", 
        "xmlns" \[Rule] "http://www.wolfram.com/XML/"}, {XMLElement[
          "Function", {}, {XMLElement["Symbol", {}, {"MathMLForm"}], 
            XMLElement[
              "Function", {}, {XMLElement["Symbol", {}, {"Power"}], 
                XMLElement["Symbol", {}, {"x"}], 
                XMLElement["Number", {}, {"2"}]}]}]}]\)], "Output",
  CellLabel->"Out[16]=",
  CellTags->{"ToCompactXML", "i:99", "b:6.1"}]
}, Closed]],

Cell[TextData[{
  "In the following example, we suppress the first namespace by using the \
pattern-matching capabilities of ",
  StyleBox["ToCompactXML",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"ToCompactXML", "i:99", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`ToCompactXML[
      XMLElement["\<Expression\>", {{"\<http://www.w3.org/2000/xmlns/\>", \
"\<mathematica\>"} \[Rule] "\<http://www.wolfram.com/XML/\>", "\<xmlns\>" \
\[Rule] "\<http://www.wolfram.com/XML/\>"}, {XMLElement["\<Function\>", {}, \
{XMLElement["\<Symbol\>", {}, {"\<MathMLForm\>"}], 
              XMLElement["\<Function\>", {}, {XMLElement["\<Symbol\>", {}, {"\
\<Power\>"}], XMLElement["\<Symbol\>", {}, {"\<x\>"}], 
                  XMLElement["\<Number\>", {}, {"\<2\>"}]}]}]}], \ \
"\<http://www.wolfram.com/XML\>"]\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->{"ToCompactXML", "i:99", "b:6.1"}],

Cell[BoxData[
    \(XMLElement[
      "Expression", {{"http://www.w3.org/2000/xmlns/", "mathematica"} \[Rule] 
          "http://www.wolfram.com/XML/", 
        "xmlns" \[Rule] "http://www.wolfram.com/XML/"}, {XMLElement[
          "Function", {}, {XMLElement["Symbol", {}, {"MathMLForm"}], 
            XMLElement[
              "Function", {}, {XMLElement["Symbol", {}, {"Power"}], 
                XMLElement["Symbol", {}, {"x"}], 
                XMLElement["Number", {}, {"2"}]}]}]}]\)], "Output",
  CellLabel->"Out[17]=",
  CellTags->{"ToCompactXML", "i:99", "b:6.1"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["XMLGet", "ObjectName",
  CellTags->{"XMLGet", "i:100", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["XMLGet[", "MR"],
  StyleBox["filePath", "TI"],
  StyleBox["]", "MR"],
  " returns the XML expression tree corresponding to the contents of the file \
located at ",
  StyleBox["filePath.", "TI"],
  "  \n\[FilledSmallSquare] ",
  StyleBox["XMLGet[", "MR"],
  StyleBox["filePath, XMLParserObj", "TI"],
  StyleBox["]", "MR"],
  " uses the pre-initialized parser object to parse the file. "
}], "Usage",
  CellTags->{"XMLGet", "i:100", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function is similar to ",
  StyleBox["Import[", "MR"],
  StyleBox["file", "TI"],
  StyleBox[", \"XML\"].", "MR"],
  " However, ",
  StyleBox["Import", "MR"],
  " does not allow URL access, but ",
  StyleBox["XMLGet", "MR"],
  " can retrieve XML documents from a URL.\n\[FilledSmallSquare] This \
function exists only in the ",
  StyleBox["XML`Parser`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`Parser`XMLGet",
    FontFamily->"Courier"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`Parser`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"XMLGet", "i:100", "b:6.1"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"XMLGet", "i:100", "b:6.1"}],

Cell["For our first example, we create a file.", "Text",
  CellTags->{"XMLGet", "i:100", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<temp.xml\>", "\<Here is an example file.\>"]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->{"XMLGet", "i:100", "b:6.1"}],

Cell[BoxData[
    \("temp.xml"\)], "Output",
  CellLabel->"Out[18]=",
  CellTags->{"XMLGet", "i:100", "b:6.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(!! temp.xml\)\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->{"XMLGet", "i:100", "b:6.1"}],

Cell["\<\
<?xml version='1.0'?>
<!DOCTYPE Expression SYSTEM 'http://www.wolfram.com/XML/notebookml1.dtd'>
<Expression xmlns:mathematica='http://www.wolfram.com/XML/'
    xmlns='http://www.wolfram.com/XML/'>
 <String>Here is an example file.</String>
</Expression>\
\>", "Print",
  CellLabel->"From In[19]:=",
  CellTags->{"XMLGet", "i:100", "b:6.1"}]
}, Closed]],

Cell[TextData[{
  "Now we will use ",
  StyleBox["XMLGet",
    FontFamily->"Courier"],
  " to return the contents of the file as an XML expression."
}], "Text",
  CellTags->{"XMLGet", "i:100", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGet["\<temp.xml\>"]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->{"XMLGet", "i:100", "b:6.1"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Declaration"]\)[
          "Version" \[Rule] "1.0"], \(XMLObject["Doctype"]\)["Expression", 
          "System" \[Rule] "http://www.wolfram.com/XML/notebookml1.dtd"]}, 
      XMLElement[
        "Expression", {{"http://www.w3.org/2000/xmlns/", 
              "mathematica"} \[Rule] 
            "http://www.wolfram.com/XML/", {"http://www.w3.org/2000/xmlns/", 
              "xmlns"} \[Rule] "http://www.wolfram.com/XML/"}, {XMLElement[
            "String", {}, {"Here is an example file."}]}], {}, 
      "Valid" \[Rule] True]\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->{"XMLGet", "i:100", "b:6.1"}]
}, Closed]],

Cell["\<\
As a second example, we retrieve data via HTTP. The following \
command retrieves stock quotes from a website and returns the data as \
SymbolicXML.\
\>", "Text",
  CellTags->{"XMLGet", "i:100", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(XML`Parser`XMLGet["\<http://www.webservicex.net/stockquote.asmx/\
GetQuote?symbol=IBM\>"]\)\(\ \)\)\)], "Input",
  CellLabel->"In[21]:=",
  CellLabelAutoDelete->False,
  CellTags->{"XMLGet", "i:100", "b:6.1"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Declaration"]\)["Version" \[Rule] "1.0", 
          "Encoding" \[Rule] "utf-8"]}, 
      XMLElement[
        "string", {{"http://www.w3.org/2000/xmlns/", "xmlns"} \[Rule] 
            "http://www.webserviceX.NET/"}, \
{"<StockQuotes><Stock><Symbol>IBM</Symbol><Last>88.51</Last><Date>1/14/2003</\
Date><Time>4:00pm</Time><Change>+1.00</Change><Open>87.51</Open><High>88.51</\
High><Low>87.22</Low><Volume>7304300</Volume><MktCap>149.6B</MktCap><\
PreviousClose>87.51</PreviousClose><PercentageChange>+1.14%</PercentageChange>\
<AnnRange>54.01 - \
120.55</AnnRange><Earns>3.18</Earns><P-E>27.52</P-E><Name>INTL BUS \
MACHINE</Name></Stock></StockQuotes>"}], {}]\)], "Output",
  CellLabel->"Out[21]=",
  CellLabelAutoDelete->False,
  CellTags->{"XMLGet", "i:100", "b:6.1"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["XMLGetString", "ObjectName",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["XMLGetString[", "MR"],
  StyleBox["string", "TI"],
  StyleBox["]", "MR"],
  " returns the XML expression tree corresponding to",
  " ",
  StyleBox["string.", "TI"],
  "  \n\[FilledSmallSquare] ",
  StyleBox["XMLGetString[", "MR"],
  StyleBox["string, XMLParserObj", "TI"],
  StyleBox["]", "MR"],
  " uses the pre-initialized parser object to parse ",
  StyleBox["string", "TI"],
  ". "
}], "Usage",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function is similar to ",
  StyleBox["ImportString[", "MR"],
  StyleBox["string", "TI"],
  StyleBox[", \"XML\"]. ", "MR"],
  "However, it can take a pre-initialized XML parser.\n\[FilledSmallSquare] \
This function exists only in the ",
  StyleBox["XML`Parser`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`Parser`XMLGetString",
    FontFamily->"Courier"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`Parser`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}],

Cell[TextData[{
  "In this example, we use ",
  StyleBox["XMLGetString",
    FontFamily->"Courier"],
  " to simply import a string as SymbolicXML."
}], "Text",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString["\<<math><mi>x</mi><mo>+</mo><mn>5</mn></math>\>\
"]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[
        "math", {}, {XMLElement["mi", {}, {"x"}], 
          XMLElement["mo", {}, {"+"}], 
          XMLElement["mn", {}, {"5"}]}], {}]\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}]
}, Closed]],

Cell[TextData[{
  "The next example illustrates the use of ",
  StyleBox["XMLGetString",
    FontFamily->"Courier"],
  " with a ",
  "pre-initialized",
  " parser."
}], "Text",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}],

Cell[TextData[{
  "First we pre-initialize the parser according to a DTD at the remote URL \
and name that ",
  "pre-initialized",
  " parser ",
  StyleBox["XHTMLParser",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XHTMLParser = 
      XML`Parser`InitializeXMLParser["\<html\>", \
"\<http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\>"]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}],

Cell[BoxData[
    \(XML`Parser`XMLParser["html", 
      "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"]\)], "Output",\

  CellLabel->"Out[23]=",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}]
}, Closed]],

Cell["\<\
Now we can use the pre-initialized parser to validate the string on \
import.\
\>", "Text",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString["\<<html><head><title>test</title></head><body><\
p>Here is some text.</p></body></html>\>", 
      XHTMLParser, "\<ValidateAgainstDTD\>" \[Rule] True]\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Doctype"]\)["html", 
          "System" \[Rule] 
            "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"]}, 
      XMLElement[
        "html", {}, {XMLElement[
            "head", {}, {XMLElement["title", {}, {"test"}]}], 
          XMLElement[
            "body", {}, {XMLElement["p", {}, {"Here is some text."}]}]}], {}, 
      "Valid" \[Rule] True]\)], "Output",
  CellLabel->"Out[24]=",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}]
}, Closed]],

Cell[TextData[{
  "Since ",
  StyleBox["Valid",
    FontFamily->"Courier"],
  " \[Rule] ",
  StyleBox["True",
    FontFamily->"Courier"],
  " is in the output, we know that the string was validated successfully."
}], "Text",
  CellTags->{"XMLGetString", "i:101", "b:6.1"}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["InitializeXMLParser", "ObjectName",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["InitializeXMLParser[", "MR"],
  StyleBox["rootElement", "TI"],
  StyleBox[", ", "MR"],
  StyleBox["filePath", "TI"],
  StyleBox["]", "MR"],
  " creates an XMLParser with a list of entities corresponding to the \
contents of the file located at ",
  StyleBox["filePath ", "TI"],
  "and returns an XMLParser object to be used on XML documents that have a \
root element ",
  StyleBox["rootElement", "TI"],
  "."
}], "Usage",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`Parser`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`Parser`InitializeXMLParser",
    FontFamily->"Courier"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`Parser`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}],

Cell[TextData[{
  StyleBox["InitializeXMLParser", "MR"],
  " can be used to preload a DTD. If many documents with the same DTD are to \
be loaded again and again, a pre-initialized parser can speed up processing \
time."
}], "Text",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(mathMLParser = 
      XML`Parser`InitializeXMLParser["\<math\>", \
"\<http://www.w3.org/TR/MathML2/dtd/mathml2.dtd\>"]\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}],

Cell[BoxData[
    \(XML`Parser`XMLParser["math", 
      "http://www.w3.org/TR/MathML2/dtd/mathml2.dtd"]\)], "Output",
  CellLabel->"Out[25]=",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}]
}, Closed]],

Cell["\<\
Using the pre-initialized MathML parser is much faster than \
reloading the DTD.\
\>", "Text",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[\(XML`Parser`XMLGetString["\<<!DOCTYPE math SYSTEM \
'http://www.w3.org/TR/MathML2/dtd/mathml2.dtd'><math><mn>1</mn></math>\>", 
          mathMLParser];\)]\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}],

Cell[BoxData[
    \({0.`\ Second, Null}\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Timing[\(XML`Parser`XMLGetString["\<<!DOCTYPE math SYSTEM \
'http://www.w3.org/TR/MathML2/dtd/mathml2.dtd'><math><mn>1</mn></math>\>"];\)]\
\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}],

Cell[BoxData[
    \({0.`\ Second, Null}\)], "Output",
  CellLabel->"Out[27]=",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}]
}, Closed]],

Cell["\<\
Note that for validation to occur, a DOCTYPE declaration does not \
need to be present when using a pre-initialized parser.\
\>", "Text",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`Parser`XMLGetString["\<<math><mn>1</mn></math>\>", 
      mathMLParser, "\<ValidateAgainstDTD\>" \[Rule] True]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Doctype"]\)["math", 
          "System" \[Rule] "http://www.w3.org/TR/MathML2/dtd/mathml2.dtd"]}, 
      XMLElement["math", {}, {XMLElement["mn", {}, {"1"}]}], {}, 
      "Valid" \[Rule] True]\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->{"InitializeXMLParser", "i:102", "b:6.1"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ReleaseXMLParser", "ObjectName",
  CellTags->{"ReleaseXMLParser", "i:103", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ReleaseXMLParser[", "MR"],
  StyleBox["XMLParserObj", "TI"],
  StyleBox["]", "MR"],
  " frees up resources associated with the parser object ",
  StyleBox["XMLParserObj", "TI"],
  ". "
}], "Usage",
  CellTags->{"ReleaseXMLParser", "i:103", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`Parser`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`Parser`",
    FontFamily->"Courier"],
  StyleBox["ReleaseXMLParser", "MR"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`Parser`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"ReleaseXMLParser", "i:103", "b:6.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell["RawXML", "ObjectName",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["RawXML[", "MR"],
  StyleBox["xmlstring",
    FontSlant->"Italic"],
  StyleBox["]", "MR"],
  " represents a raw string fragment of XML that can be used inside a \
SymbolicXML expression. "
}], "Usage",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`Raw",
    FontFamily->"Courier"],
  StyleBox["XML", "MR"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell["Here is a raw string fragment of XML.", "Text",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(rawFragment = 
      ExportString[1, "\<MathML\>", 
        ConversionOptions \[Rule] {"\<Annotations\>" \[Rule] {}, \
"\<Formats\>" \[Rule] {"\<PresentationMathML\>"}}]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <mn>1</mn>\n\
</math>"\)], "Output",
  CellLabel->"Out[1]=",
  CellTags->{"RawXML", "i:104", "b:6.1"}]
}, Closed]],

Cell[TextData[{
  "Here is a composed SymbolicXML expression with an embedded fragment of ",
  StyleBox["RawXML", "MR"],
  "."
}], "Text",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(composedFragment\  = \ 
      XMLElement["\<p\>", {}, {XML`RawXML\ @\ rawFragment}]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[BoxData[
    \(XMLElement[
      "p", {}, {XML`RawXML[
          "<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <mn>1</mn>\n\
</math>"]}]\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->{"RawXML", "i:104", "b:6.1"}]
}, Closed]],

Cell["The composite expression exports as XML as it should.", "Text",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(ExportString[composedFragment, "\<XML\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[BoxData[
    \("<p><math xmlns='http://www.w3.org/1998/Math/MathML'>\n <mn>1</mn>\n\
</math></p>"\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->{"RawXML", "i:104", "b:6.1"}]
}, Closed]],

Cell["\<\
The composite expression and variants are recognized as \
SymbolicXML.\
\>", "Text",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`SymbolicXMLQ\ @\ composedFragment\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->{"RawXML", "i:104", "b:6.1"}]
}, Closed]],

Cell[TextData[{
  "Transforming the composite SymbolicXML expression via ",
  StyleBox["ToSymbolicXML",
    FontFamily->"Courier"],
  " expands out any ",
  StyleBox["RawXML", "MR"],
  " fragments into SymbolicXML fragments, if possible."
}], "Text",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`ToSymbolicXML\ @\ composedFragment\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[BoxData[
    \(XMLElement[
      "p", {}, {XMLElement[
          "math", {{"http://www.w3.org/2000/xmlns/", "xmlns"} \[Rule] 
              "http://www.w3.org/1998/Math/MathML"}, {XMLElement[
              "mn", {}, {"1"}]}]}]\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->{"RawXML", "i:104", "b:6.1"}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`ToSymbolicXML\ @\ \(XML`RawXML\ @\ rawFragment\)\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->{"RawXML", "i:104", "b:6.1"}],

Cell[BoxData[
    \(XMLElement[
      "math", {{"http://www.w3.org/2000/xmlns/", "xmlns"} \[Rule] 
          "http://www.w3.org/1998/Math/MathML"}, {XMLElement[
          "mn", {}, {"1"}]}]\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->{"RawXML", "i:104", "b:6.1"}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NotebookML Functions", "Subsection",
  CellTags->"b:6.2"],

Cell[CellGroupData[{

Cell["NotebookToSymbolicNotebookML", "ObjectName",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["NotebookToSymbolicNotebookML[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " converts ",
  StyleBox["expr", "TI"],
  " to NotebookML and returns the corresponding SymbolicXML. "
}], "Usage",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function takes the options ",
  ButtonBox["Annotations",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BoxFormats",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["GraphicsFormats",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["Stylesheets",
    ButtonData:>{"Exporting NotebookML: Conversion Options"},
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["FileName",
    ButtonData:>{"Exporting NotebookML: Conversion Options"},
    ButtonStyle->"AddOnsLink"],
  ", and ",
  ButtonBox["FilesDirectory",
    ButtonData:>{"Exporting NotebookML: Conversion Options"},
    ButtonStyle->"AddOnsLink"],
  "."
}], "Notes",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`NotebookML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`NotebookML`NotebookToSymbolicNotebookML",
    FontFamily->"Courier"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`NotebookML`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}],

Cell[CellGroupData[{

Cell["Examples", "ExampleSection",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`NotebookML`NotebookToSymbolicNotebookML[Cell["\<hi\>"]]\)], "Input",\

  CellLabel->"In[33]:=",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Declaration"]\)[
          "Version" \[Rule] "1.0"], \(XMLObject["Doctype"]\)["Cell", 
          "System" \[Rule] "http://www.wolfram.com/XML/notebookml1.dtd"]}, 
      XMLElement[
        "Cell", {"CreatedBy" \[Rule] 
            "Mathematica 5.0", {"http://www.w3.org/2000/xmlns/", 
              "xhtml"} \[Rule] 
            "http://www.w3.org/1999/xhtml", {"http://www.w3.org/2000/xmlns/", 
              "mathematica"} \[Rule] 
            "http://www.wolfram.com/XML/", {"http://www.w3.org/2000/xmlns/", 
              "xmlns"} \[Rule] "http://www.wolfram.com/XML/"}, {XMLElement[
            "String", {}, {"hi"}]}], {}]\)], "Output",
  CellLabel->"Out[33]=",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}]
}, Closed]],

Cell[BoxData[
    \(\(XML`NotebookML`NotebookToSymbolicNotebookML[
        SelectedNotebook[]];\)\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}],

Cell[TextData[{
  "When exporting GIF images for ",
  StyleBox["BoxData",
    FontFamily->"Courier"],
  " or ",
  StyleBox["GraphicsData",
    FontFamily->"Courier"],
  ", it is necessary to have a filename for naming them. You can control this \
using the \"",
  StyleBox["FileName",
    FontFamily->"Courier"],
  "\" option. By default, the GIF images are saved with the name ",
  StyleBox["\"temp.xml\"",
    FontFamily->"Courier"],
  ", as you can see in the ",
  StyleBox["\"src\"",
    FontFamily->"Courier"],
  " attribute on the ",
  StyleBox["\"img\"",
    FontFamily->"Courier"],
  " elements."
}], "Text",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`NotebookML`NotebookToSymbolicNotebookML[
      Cell[BoxData["\<hi\>"]], "\<BoxFormats\>" -> "\<GIF\>"]\)], "Input",
  CellLabel->"In[35]:=",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Declaration"]\)[
          "Version" \[Rule] "1.0"], \(XMLObject["Doctype"]\)["Cell", 
          "System" \[Rule] "http://www.wolfram.com/XML/notebookml1.dtd"]}, 
      XMLElement[
        "Cell", {"CreatedBy" \[Rule] 
            "Mathematica 5.0", {"http://www.w3.org/2000/xmlns/", 
              "xhtml"} \[Rule] 
            "http://www.w3.org/1999/xhtml", {"http://www.w3.org/2000/xmlns/", 
              "mathematica"} \[Rule] 
            "http://www.wolfram.com/XML/", {"http://www.w3.org/2000/xmlns/", 
              "xmlns"} \[Rule] "http://www.wolfram.com/XML/"}, {XMLElement[
            "BoxData", {}, {XMLElement[{"http://www.w3.org/1999/xhtml", 
                  "img"}, {"src" \[Rule] "NBMLFiles/temp_1.gif", 
                  "width" \[Rule] "520", "height" \[Rule] "15.", 
                  "border" \[Rule] "0", "align" \[Rule] "absmiddle", 
                  "alt" \[Rule] 
                    "[Graphics:NBMLFiles/temp_1.gif]"}, {}]}]}], {}]\)], \
"Output",
  CellLabel->"Out[35]=",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}]
}, Closed]],

Cell[TextData[{
  "By using the ",
  StyleBox["\"FileName\"",
    FontFamily->"Courier"],
  " option, the name of the images file can be changed."
}], "Text",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`NotebookML`NotebookToSymbolicNotebookML[
      Cell[BoxData["\<hi\>"]], "\<BoxFormats\>" -> "\<GIF\>", "\<FileName\>" -> \
"\<myFile\>"]\)], "Input",
  CellLabel->"In[36]:=",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Declaration"]\)[
          "Version" \[Rule] "1.0"], \(XMLObject["Doctype"]\)["Cell", 
          "System" \[Rule] "http://www.wolfram.com/XML/notebookml1.dtd"]}, 
      XMLElement[
        "Cell", {"CreatedBy" \[Rule] 
            "Mathematica 5.0", {"http://www.w3.org/2000/xmlns/", 
              "xhtml"} \[Rule] 
            "http://www.w3.org/1999/xhtml", {"http://www.w3.org/2000/xmlns/", 
              "mathematica"} \[Rule] 
            "http://www.wolfram.com/XML/", {"http://www.w3.org/2000/xmlns/", 
              "xmlns"} \[Rule] "http://www.wolfram.com/XML/"}, {XMLElement[
            "BoxData", {}, {XMLElement[{"http://www.w3.org/1999/xhtml", 
                  "img"}, {"src" \[Rule] "NBMLFiles/myFile_1.gif", 
                  "width" \[Rule] "520", "height" \[Rule] "15.", 
                  "border" \[Rule] "0", "align" \[Rule] "absmiddle", 
                  "alt" \[Rule] 
                    "[Graphics:NBMLFiles/myFile_1.gif]"}, {}]}]}], {}]\)], \
"Output",
  CellLabel->"Out[36]=",
  CellTags->{"NotebookToSymNBML", "i:105", "b:6.2"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ExpressionToSymbolicExpressionML", "ObjectName",
  CellTags->{"ExprToSymEML", "i:106", "b:6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ExpressionToSymbolicExpressionML[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " converts ",
  StyleBox["expr", "TI"],
  " to ExpressionML and returns the corresponding SymbolicXML. "
}], "Usage",
  CellTags->{"ExprToSymEML", "i:106", "b:6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`NotebookML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`NotebookML`NotebookToSymbolicExpressionML",
    FontFamily->"Courier"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`NotebookML`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"ExprToSymEML", "i:106", "b:6.2"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"ExprToSymEML", "i:106", "b:6.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`NotebookML`ExpressionToSymbolicExpressionML[
      Log[5 + Sin[x]]]\)], "Input",
  CellLabel->"In[37]:=",
  CellTags->{"ExprToSymEML", "i:106", "b:6.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Declaration"]\)[
          "Version" \[Rule] "1.0"], \(XMLObject["Doctype"]\)["Expression", 
          "System" \[Rule] "http://www.wolfram.com/XML/notebookml1.dtd"]}, 
      XMLElement[
        "Expression", {{"http://www.w3.org/2000/xmlns/", 
              "mathematica"} \[Rule] "http://www.wolfram.com/XML/", 
          "xmlns" \[Rule] "http://www.wolfram.com/XML/"}, {XMLElement[
            "Function", {}, {XMLElement["Symbol", {}, {"Log"}], 
              XMLElement[
                "Function", {}, {XMLElement["Symbol", {}, {"Plus"}], 
                  XMLElement["Number", {}, {"5"}], 
                  XMLElement[
                    "Function", {}, {XMLElement["Symbol", {}, {"Sin"}], 
                      XMLElement[
                        "Symbol", {}, {"x"}]}]}]}]}], {}]\)], "Output",
  CellLabel->"Out[37]=",
  CellTags->{"ExprToSymEML", "i:106", "b:6.2"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SymbolicNotebookMLToNotebook", "ObjectName",
  CellTags->{"SymNBMLToNB", "i:107", "b:6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SymbolicNotebookMLToNotebook[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " takes a SymbolicXML expression ",
  StyleBox["expr", "TI"],
  " that represents a NotebookML document and returns the corresponding \
notebook expression. "
}], "Usage",
  CellTags->{"SymNBMLToNB", "i:107", "b:6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`NotebookML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`NotebookML`",
    FontFamily->"Courier"],
  StyleBox["SymbolicNotebookMLToNotebook", "MR"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`NotebookML`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"SymNBMLToNB", "i:107", "b:6.2"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"SymNBMLToNB", "i:107", "b:6.2"}],

Cell[TextData[{
  "In this example, we will use the variable ",
  StyleBox["symbNB",
    FontFamily->"Courier"],
  " for ease of presentation. First we generate SymbolicXML from a notebook \
expression using ",
  StyleBox["NotebookToSymbolicNotebookML",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"SymNBMLToNB", "i:107", "b:6.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(symbNB = 
      XML`NotebookML`NotebookToSymbolicNotebookML[
        Notebook[{Cell["\<hi\>", "\<Text\>"]}]]\)], "Input",
  CellLabel->"In[38]:=",
  CellTags->{"SymNBMLToNB", "i:107", "b:6.2"}],

Cell[BoxData[
    \(\(XMLObject[
        "Document"]\)[{\(XMLObject["Declaration"]\)[
          "Version" \[Rule] "1.0"], \(XMLObject["Doctype"]\)["Notebook", 
          "System" \[Rule] "http://www.wolfram.com/XML/notebookml1.dtd"]}, 
      XMLElement[
        "Notebook", {"CreatedBy" \[Rule] 
            "Mathematica 5.0", {"http://www.w3.org/2000/xmlns/", 
              "xhtml"} \[Rule] 
            "http://www.w3.org/1999/xhtml", {"http://www.w3.org/2000/xmlns/", 
              "mathematica"} \[Rule] 
            "http://www.wolfram.com/XML/", {"http://www.w3.org/2000/xmlns/", 
              "xmlns"} \[Rule] "http://www.wolfram.com/XML/"}, {XMLElement[
            "List", {}, {XMLElement[
                "Cell", {"class" \[Rule] "Text"}, {XMLElement[
                    "String", {}, {"hi"}], 
                  XMLElement[
                    "Style", {}, {XMLElement[
                        "String", {}, {"Text"}]}]}]}]}], {}]\)], "Output",
  CellLabel->"Out[38]=",
  CellTags->{"SymNBMLToNB", "i:107", "b:6.2"}]
}, Closed]],

Cell[TextData[{
  "Now we use ",
  StyleBox["SymbolicNotebookMLToNotebook",
    FontFamily->"Courier"],
  " to recover the notebook expression."
}], "Text",
  CellTags->{"SymNBMLToNB", "i:107", "b:6.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`NotebookML`SymbolicNotebookMLToNotebook[symbNB]\)], "Input",
  CellLabel->"In[39]:=",
  CellTags->{"SymNBMLToNB", "i:107", "b:6.2"}],

Cell[BoxData[
    \(Notebook[{Cell["hi", "Text"]}]\)], "Output",
  CellLabel->"Out[39]=",
  CellTags->{"SymNBMLToNB", "i:107", "b:6.2"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SymbolicExpressionMLToExpression", "ObjectName",
  CellTags->{"SymEMLToExpr", "i:108", "b:6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SymbolicExpressionMLToExpression[", "MR"],
  StyleBox["expr", "TI"],
  StyleBox["]", "MR"],
  " takes a SymbolicXML expression ",
  StyleBox["expr", "TI"],
  " that represents an ExpressionML document and returns the corresponding \
expression. "
}], "Usage",
  CellTags->{"SymEMLToExpr", "i:108", "b:6.2"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`NotebookML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`NotebookML",
    FontFamily->"Courier"],
  StyleBox["SymbolicExpressionMLToExpression", "MR"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`NotebookML`",
    FontFamily->"Courier"],
  " context to your context path."
}], "Notes",
  CellTags->{"SymEMLToExpr", "i:108", "b:6.2"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"SymEMLToExpr", "i:108", "b:6.2"}],

Cell[TextData[{
  "In this example, we will use the variable ",
  StyleBox["symbExpr",
    FontFamily->"Courier"],
  " for ease of presentation. First we generate SymbolicXML from an \
expression using ",
  StyleBox["ExpressionToSymbolicExpressionML",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"SymEMLToExpr", "i:108", "b:6.2"}],

Cell[BoxData[
    \(\(symbExpr = 
        XML`NotebookML`ExpressionToSymbolicExpressionML[
          Log[5 + Sin[x]]];\)\)], "Input",
  CellLabel->"In[40]:=",
  CellTags->{"SymEMLToExpr", "i:108", "b:6.2"}],

Cell[TextData[{
  "Now we use ",
  StyleBox["SymbolicExpressionMLToExpression",
    FontFamily->"Courier"],
  " to recover the expression."
}], "Text",
  CellTags->{"SymEMLToExpr", "i:108", "b:6.2"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`NotebookML`SymbolicExpressionMLToExpression[symbExpr]\)], "Input",
  CellLabel->"In[41]:=",
  CellTags->{"SymEMLToExpr", "i:108", "b:6.2"}],

Cell[BoxData[
    \(Log[5 + Sin[x]]\)], "Output",
  CellLabel->"Out[41]=",
  CellTags->{"SymEMLToExpr", "i:108", "b:6.2"}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["MathML Functions", "Subsection",
  CellTags->{"MMLFunctionIntro", "b:6.3"}],

Cell[CellGroupData[{

Cell["BoxesToMathML", "ObjectName",
  CellTags->{"BoxesToMathML", "i:109", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BoxesToMathML[",
    FontFamily->"Courier"],
  StyleBox["boxes",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " converts the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " box structure, ",
  StyleBox["boxes",
    FontSlant->"Italic"],
  ", into a MathML-flavored XML text string. "
}], "Usage",
  CellTags->{"BoxesToMathML", "i:109", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] The output is in the form of presentation MathML, \
wherever possible. \n\[FilledSmallSquare] This function takes the options ",
  StyleBox["\"Formats\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Annotations\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"NamespacePrefixes\"",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\"Entities\"",
    FontFamily->"Courier"],
  ". For details about these options, see ",
  ButtonBox["MathML Options",
    ButtonData:>{"MathML Conversion Options"},
    ButtonStyle->"AddOnsLinkText"],
  ".\n\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`MathML`BoxesToMathML",
    FontFamily->"Courier"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context to your context path.\n\[FilledSmallSquare] See also: ",
  ButtonBox["MathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ExpressionToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["MathMLToExpression",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ExpressionToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SymbolicMathMLToExpression",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BoxesToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SymbolicMathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  "."
}], "Notes",
  CellTags->{"BoxesToMathML", "i:109", "b:6.3"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"BoxesToMathML", "i:109", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`BoxesToMathML[SuperscriptBox["\<x\>", "\<3\>"]]\)], "Input",
  CellLabel->"In[42]:=",
  CellTags->{"BoxesToMathML", "i:109", "b:6.3"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <msup>\n  \
<mi>x</mi>\n  <mn>3</mn>\n </msup>\n</math>"\)], "Output",
  CellLabel->"Out[42]=",
  CellTags->{"BoxesToMathML", "i:109", "b:6.3"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["MathMLToBoxes", "ObjectName",
  CellTags->{"MathMLToBoxes", "i:110", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MathMLToBoxes[",
    FontFamily->"Courier"],
  StyleBox["string",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " converts the string containing MathML-flavored XML text into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " box expression."
}], "Usage",
  CellTags->{"MathMLToBoxes", "i:110", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`MathML`MathMLToBoxes",
    FontFamily->"Courier"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context to your context path.\n\[FilledSmallSquare] See also: ",
  ButtonBox["BoxesToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ExpressionToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["MathMLToExpression",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ExpressionToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SymbolicMathMLToExpression",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BoxesToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SymbolicMathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  "."
}], "Notes",
  CellTags->{"MathMLToBoxes", "i:110", "b:6.3"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"MathMLToBoxes", "i:110", "b:6.3"}],

Cell[TextData[{
  "First we generate some MathML data using ",
  StyleBox["BoxesToMathML",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"MathMLToBoxes", "i:110", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`BoxesToMathML[SuperscriptBox["\<x\>", "\<2\>"]]\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->{"MathMLToBoxes", "i:110", "b:6.3"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <msup>\n  \
<mi>x</mi>\n  <mn>2</mn>\n </msup>\n</math>"\)], "Output",
  CellLabel->"Out[43]=",
  CellTags->{"MathMLToBoxes", "i:110", "b:6.3"}]
}, Closed]],

Cell[TextData[{
  "Now we take this MathML output and convert it back into a box expression \
using ",
  StyleBox["MathMLToBoxes",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"MathMLToBoxes", "i:110", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`MathMLToBoxes[%]\)], "Input",
  CellLabel->"In[44]:=",
  CellTags->{"MathMLToBoxes", "i:110", "b:6.3"}],

Cell[BoxData[
    \(FormBox[
      TagBox[SuperscriptBox["x", "2"], "MathMLPresentationTag", 
        AutoDelete \[Rule] True], TraditionalForm]\)], "Output",
  CellLabel->"Out[44]=",
  CellTags->{"MathMLToBoxes", "i:110", "b:6.3"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ExpressionToMathML", "ObjectName",
  CellTags->{"ExprToMathML", "i:111", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ExpressionToMathML[",
    FontFamily->"Courier"],
  StyleBox["e",
    FontFamily->"Courier",
    FontSlant->"Italic"],
  StyleBox["xpr",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " converts the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression, ",
  StyleBox["expr",
    FontSlant->"Italic"],
  ", into a MathML -flavored XML text string. "
}], "Usage",
  CellTags->{"ExprToMathML", "i:111", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] The output is in both presentation and content \
MathML, wherever possible.\n\[FilledSmallSquare] This function takes the \
options ",
  StyleBox["\"Formats\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"Annotations\"",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\"NamespacePrefixes\"",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\"Entities\"",
    FontFamily->"Courier"],
  ". For details about these options, see ",
  ButtonBox["MathML Options",
    ButtonData:>{"MathML Conversion Options"},
    ButtonStyle->"AddOnsLinkText"],
  ".\n\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`MathML`ExpressionToMathML",
    FontFamily->"Courier"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context to your context path.\n\[FilledSmallSquare] See also: ",
  ButtonBox["BoxesToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["MathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["MathMLToExpression",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ExpressionToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SymbolicMathMLToExpression",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BoxesToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SymbolicMathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  "."
}], "Notes",
  CellTags->{"ExprToMathML", "i:111", "b:6.3"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"ExprToMathML", "i:111", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`ExpressionToMathML[x + \ 3]\)], "Input",
  CellLabel->"In[45]:=",
  CellTags->{"ExprToMathML", "i:111", "b:6.3"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <semantics>\n  \
<mrow>\n   <mi>x</mi>\n   <mo>+</mo>\n   <mn>3</mn>\n  </mrow>\n  \
<annotation-xml encoding='MathML-Content'>\n   <apply>\n    <plus/>\n    \
<ci>x</ci>\n    <cn type='integer'>3</cn>\n   </apply>\n  </annotation-xml>\n \
</semantics>\n</math>"\)], "Output",
  CellLabel->"Out[45]=",
  CellTags->{"ExprToMathML", "i:111", "b:6.3"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["MathMLToExpression", "ObjectName",
  CellTags->{"MathMLToExpr", "i:112", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["MathMLToExpression[",
    FontFamily->"Courier"],
  StyleBox["string",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " converts the string containing MathML-flavored XML text into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression."
}], "Usage",
  CellTags->{"MathMLToExpr", "i:112", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`MathML`MathMLToExpression",
    FontFamily->"Courier"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context to your context path.\n\[FilledSmallSquare] See also: ",
  ButtonBox["BoxesToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["MathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ExpressionToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ExpressionToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SymbolicMathMLToExpression",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BoxesToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SymbolicMathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  "."
}], "Notes",
  CellTags->{"MathMLToExpr", "i:112", "b:6.3"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"MathMLToExpr", "i:112", "b:6.3"}],

Cell[TextData[{
  "Here is our example from ",
  StyleBox["ExpressionToMathML",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->{"MathMLToExpr", "i:112", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`ExpressionToMathML[3\  + \ x]\)], "Input",
  CellLabel->"In[46]:=",
  CellTags->{"MathMLToExpr", "i:112", "b:6.3"}],

Cell[BoxData[
    \("<math xmlns='http://www.w3.org/1998/Math/MathML'>\n <semantics>\n  \
<mrow>\n   <mi>x</mi>\n   <mo>+</mo>\n   <mn>3</mn>\n  </mrow>\n  \
<annotation-xml encoding='MathML-Content'>\n   <apply>\n    <plus/>\n    \
<ci>x</ci>\n    <cn type='integer'>3</cn>\n   </apply>\n  </annotation-xml>\n \
</semantics>\n</math>"\)], "Output",
  CellLabel->"Out[46]=",
  CellTags->{"MathMLToExpr", "i:112", "b:6.3"}]
}, Closed]],

Cell[TextData[{
  "Now we use ",
  StyleBox["MathMLToExpression",
    FontFamily->"Courier"],
  " to recover the original ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression."
}], "Text",
  CellTags->{"MathMLToExpr", "i:112", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`MathMLToExpression[%]\)], "Input",
  CellLabel->"In[47]:=",
  CellTags->{"MathMLToExpr", "i:112", "b:6.3"}],

Cell[BoxData[
    \(3 + x\)], "Output",
  CellLabel->"Out[47]=",
  CellTags->{"MathMLToExpr", "i:112", "b:6.3"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SymbolicMathMLToBoxes", "ObjectName",
  CellTags->{"SymMMLToBoxes", "i:113", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SymbolicMathMLToBoxes[",
    FontFamily->"Courier"],
  StyleBox["smml",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " converts the MathML-flavored SymbolicXML structure, ",
  StyleBox["smml",
    FontSlant->"Italic"],
  ", into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " box expression."
}], "Usage",
  CellTags->{"SymMMLToBoxes", "i:113", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context. Hence, when doing an evaluation, you must specify the function \
name as ",
  StyleBox["XML`MathML`SymbolicMathMLToBoxes",
    FontFamily->"Courier"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context to your context path.\n\[FilledSmallSquare] See also: ",
  ButtonBox["BoxesToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["MathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ExpressionToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["MathMLToExpression",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ExpressionToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SymbolicMathMLToExpression",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BoxesToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  "."
}], "Notes",
  CellTags->{"SymMMLToBoxes", "i:113", "b:6.3"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"SymMMLToBoxes", "i:113", "b:6.3"}],

Cell["First we generate some MathML flavored SymbolicXML.", "Text",
  CellTags->{"SymMMLToBoxes", "i:113", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`ExpressionToSymbolicMathML[x^2]\)], "Input",
  CellLabel->"In[48]:=",
  CellTags->{"SymMMLToBoxes", "i:113", "b:6.3"}],

Cell[BoxData[
    \(XMLElement[
      "math", {"xmlns" \[Rule] 
          "http://www.w3.org/1998/Math/MathML"}, {XMLElement[
          "semantics", {}, {XMLElement[
              "msup", {}, {XMLElement["mi", {}, {"x"}], 
                XMLElement["mn", {}, {"2"}]}], 
            XMLElement[
              "annotation-xml", {"encoding" \[Rule] 
                  "MathML-Content"}, {XMLElement[
                  "apply", {}, {XMLElement["power", {}, {}], 
                    XMLElement["ci", {}, {"x"}], 
                    XMLElement[
                      "cn", {"type" \[Rule] 
                          "integer"}, {"2"}]}]}]}]}]\)], "Output",
  CellLabel->"Out[48]=",
  CellTags->{"SymMMLToBoxes", "i:113", "b:6.3"}]
}, Closed]],

Cell[TextData[{
  "Now we use the above result as the argument to ",
  StyleBox["SymbolicMathMLToBoxes",
    FontFamily->"Courier"],
  " to convert the data back into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " box expression."
}], "Text",
  CellTags->{"SymMMLToBoxes", "i:113", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToBoxes[%]\)], "Input",
  CellLabel->"In[49]:=",
  CellTags->{"SymMMLToBoxes", "i:113", "b:6.3"}],

Cell[BoxData[
    \(FormBox[
      TagBox[TagBox[SuperscriptBox["x", "2"], "MathMLPresentationTag", 
          AutoDelete \[Rule] True], 
        "AnnotationsTagWrapper"[
          TagBox[SuperscriptBox["x", "2"], "MathMLContentTag", 
            AutoDelete \[Rule] True]], AutoDelete \[Rule] True], 
      TraditionalForm]\)], "Output",
  CellLabel->"Out[49]=",
  CellTags->{"SymMMLToBoxes", "i:113", "b:6.3"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["BoxesToSymbolicMathML", "ObjectName",
  CellTags->{"BoxesToSymMML", "i:114", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["BoxesToSymbolicMathML[",
    FontFamily->"Courier"],
  StyleBox["boxes",
    FontSlant->"Italic"],
  "] converts the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " box structure, ",
  StyleBox["boxes",
    FontSlant->"Italic"],
  ", into a MathML-flavored SymbolicXML structure."
}], "Usage",
  CellTags->{"BoxesToSymMML", "i:114", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function takes the options ",
  StyleBox["\"Formats\"",
    FontFamily->"Courier"],
  " and",
  StyleBox["\"Annotations\"",
    FontFamily->"Courier"],
  ". For details about these options, see ",
  ButtonBox["MathML Options",
    ButtonData:>{"MathML Conversion Options"},
    ButtonStyle->"AddOnsLinkText"],
  ".\n\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context. Hence, when doing an evaluation, you must specify the function \
name as ",
  StyleBox["XML`MathML`BoxesToSymbolicMathML",
    FontFamily->"Courier"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context to your context path.\n\[FilledSmallSquare] See also: ",
  ButtonBox["BoxesToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["MathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ExpressionToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["MathMLToExpression",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ExpressionToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SymbolicMathMLToExpression",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SymbolicMathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  "."
}], "Notes",
  CellTags->{"BoxesToSymMML", "i:114", "b:6.3"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"BoxesToSymMML", "i:114", "b:6.3"}],

Cell["First we generate some MathML-flavored SymbolicXML.", "Text",
  CellTags->{"BoxesToSymMML", "i:114", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`ExpressionToSymbolicMathML[x\  + \ 1]\)], "Input",
  CellLabel->"In[50]:=",
  CellTags->{"BoxesToSymMML", "i:114", "b:6.3"}],

Cell[BoxData[
    \(XMLElement[
      "math", {"xmlns" \[Rule] 
          "http://www.w3.org/1998/Math/MathML"}, {XMLElement[
          "semantics", {}, {XMLElement[
              "mrow", {}, {XMLElement["mi", {}, {"x"}], 
                XMLElement["mo", {}, {"+"}], XMLElement["mn", {}, {"1"}]}], 
            XMLElement[
              "annotation-xml", {"encoding" \[Rule] 
                  "MathML-Content"}, {XMLElement[
                  "apply", {}, {XMLElement["plus", {}, {}], 
                    XMLElement["ci", {}, {"x"}], 
                    XMLElement[
                      "cn", {"type" \[Rule] 
                          "integer"}, {"1"}]}]}]}]}]\)], "Output",
  CellLabel->"Out[50]=",
  CellTags->{"BoxesToSymMML", "i:114", "b:6.3"}]
}, Closed]],

Cell[TextData[{
  "Now we use the above result as the argument to ",
  StyleBox["SymbolicMathMLToBoxes",
    FontFamily->"Courier"],
  " to convert the data into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " box expression."
}], "Text",
  CellTags->{"BoxesToSymMML", "i:114", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToBoxes[%]\)], "Input",
  CellLabel->"In[51]:=",
  CellTags->{"BoxesToSymMML", "i:114", "b:6.3"}],

Cell[BoxData[
    \(FormBox[
      TagBox[TagBox[RowBox[{"x", "+", "1"}], "MathMLPresentationTag", 
          AutoDelete \[Rule] True], 
        "AnnotationsTagWrapper"[
          TagBox[RowBox[{"x", "+", "1"}], "MathMLContentTag", 
            AutoDelete \[Rule] True]], AutoDelete \[Rule] True], 
      TraditionalForm]\)], "Output",
  CellLabel->"Out[51]=",
  CellTags->{"BoxesToSymMML", "i:114", "b:6.3"}]
}, Closed]],

Cell[TextData[{
  "Finally, we can use this last result as the argument for ",
  StyleBox["BoxesToSymbolicMathML",
    FontFamily->"Courier"],
  " to recover the SymbolicMathML."
}], "Text",
  CellTags->{"BoxesToSymMML", "i:114", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`BoxesToSymbolicMathML[%]\)], "Input",
  CellLabel->"In[52]:=",
  CellTags->{"BoxesToSymMML", "i:114", "b:6.3"}],

Cell[BoxData[
    \(XMLElement[
      "math", {"xmlns" \[Rule] 
          "http://www.w3.org/1998/Math/MathML", \
{"http://www.wolfram.com/XML/", "form"} \[Rule] 
          "TraditionalForm", {"http://www.w3.org/2000/xmlns/", 
            "mathematica"} \[Rule] 
          "http://www.wolfram.com/XML/"}, {XMLElement[
          "semantics", {}, {XMLElement[
              "mrow", {}, {XMLElement["mi", {}, {"x"}], 
                XMLElement["mo", {}, {"+"}], XMLElement["mn", {}, {"1"}]}], 
            XMLElement[
              "annotation-xml", {"encoding" \[Rule] 
                  "MathML-Content"}, {XMLElement[
                  "apply", {}, {XMLElement["plus", {}, {}], 
                    XMLElement["ci", {}, {"x"}], 
                    XMLElement[
                      "cn", {"type" \[Rule] 
                          "integer"}, {"1"}]}]}]}]}]\)], "Output",
  CellLabel->"Out[52]=",
  CellTags->{"BoxesToSymMML", "i:114", "b:6.3"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["ExpressionToSymbolicMathML", "ObjectName",
  CellTags->{"ExprToSymMML", "i:115", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["ExpressionToSymbolicMathML[",
    FontFamily->"Courier"],
  StyleBox["expr",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  " converts the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression, ",
  StyleBox["expr",
    FontSlant->"Italic"],
  ", into a MathML-flavored SymbolicXML structure. "
}], "Usage",
  CellTags->{"ExprToSymMML", "i:115", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] The output is in the form of content MathMl, wherever \
possible.\n\[FilledSmallSquare] This function takes the options ",
  StyleBox["\"Formats\"",
    FontFamily->"Courier"],
  StyleBox[" and ",
    FontFamily->"Times New Roman"],
  StyleBox["\"Annotations\"",
    FontFamily->"Courier"],
  ". For details about these options, see ",
  ButtonBox["MathML Options",
    ButtonData:>{"MathML Conversion Options"},
    ButtonStyle->"AddOnsLinkText"],
  ".\n\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context. Hence, when doing an evaluation, you must specify the function \
name as ",
  StyleBox["XML`MathML`ExpressionToSymbolicMathML",
    FontFamily->"Courier"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context to your context path.\n\[FilledSmallSquare] See also: ",
  ButtonBox["BoxesToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["MathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ExpressionToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["MathMLToExpression",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["SymbolicMathMLToExpression",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BoxesToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SymbolicMathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  "."
}], "Notes",
  CellTags->{"ExprToSymMML", "i:115", "b:6.3"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"ExprToSymMML", "i:115", "b:6.3"}],

Cell["\<\
The following example will generate some MathML-flavored \
SymbolicXML.\
\>", "Text",
  CellTags->{"ExprToSymMML", "i:115", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`ExpressionToSymbolicMathML[x + y + z]\)], "Input",
  CellLabel->"In[53]:=",
  CellTags->{"ExprToSymMML", "i:115", "b:6.3"}],

Cell[BoxData[
    \(XMLElement[
      "math", {"xmlns" \[Rule] 
          "http://www.w3.org/1998/Math/MathML"}, {XMLElement[
          "semantics", {}, {XMLElement[
              "mrow", {}, {XMLElement["mi", {}, {"x"}], 
                XMLElement["mo", {}, {"+"}], XMLElement["mi", {}, {"y"}], 
                XMLElement["mo", {}, {"+"}], XMLElement["mi", {}, {"z"}]}], 
            XMLElement[
              "annotation-xml", {"encoding" \[Rule] 
                  "MathML-Content"}, {XMLElement[
                  "apply", {}, {XMLElement["plus", {}, {}], 
                    XMLElement["ci", {}, {"x"}], XMLElement["ci", {}, {"y"}], 
                    XMLElement["ci", {}, {"z"}]}]}]}]}]\)], "Output",
  CellLabel->"Out[53]=",
  CellTags->{"ExprToSymMML", "i:115", "b:6.3"}]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["SymbolicMathMLToExpression", "ObjectName",
  CellTags->{"SymMMLToExpr", "i:116", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["SymbolicMathMLToExpression[",
    FontFamily->"Courier"],
  StyleBox["smml",
    FontSlant->"Italic"],
  StyleBox["]",
    FontFamily->"Courier"],
  "converts the MathML-flavored SymbolicXML structure, ",
  StyleBox["smml",
    FontSlant->"Italic"],
  ", into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression. The output is in the form of content MathML, wherever \
possible."
}], "Usage",
  CellTags->{"SymMMLToExpr", "i:116", "b:6.3"}],

Cell[TextData[{
  "\[FilledSmallSquare] This function exists only in the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context. ",
  "Hence, when doing an evaluation, you must specify the function name as",
  " ",
  StyleBox["XML`MathML`SymbolicMathMLToExpression",
    FontFamily->"Courier"],
  ". To use the function without the context name prefix, you must first add \
the ",
  StyleBox["XML`MathML`",
    FontFamily->"Courier"],
  " context to your context path.\n\[FilledSmallSquare] See also: ",
  ButtonBox["BoxesToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["MathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["ExpressionToMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["MathMLToExpression",
    ButtonStyle->"RefGuideLink"],
  ", ",
  ButtonBox["ExpressionToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["BoxesToSymbolicMathML",
    ButtonStyle->"AddOnsLink"],
  ", ",
  ButtonBox["SymbolicMathMLToBoxes",
    ButtonStyle->"AddOnsLink"],
  "."
}], "Notes",
  CellTags->{"SymMMLToExpr", "i:116", "b:6.3"}],

Cell[CellGroupData[{

Cell["Example", "ExampleSection",
  CellTags->{"SymMMLToExpr", "i:116", "b:6.3"}],

Cell["\<\
The following example will generate some MathML-flavored \
SymbolicXML.\
\>", "Text",
  CellTags->{"SymMMLToExpr", "i:116", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`ExpressionToSymbolicMathML[x\ ^2]\)], "Input",
  CellLabel->"In[54]:=",
  CellTags->{"SymMMLToExpr", "i:116", "b:6.3"}],

Cell[BoxData[
    \(XMLElement[
      "math", {"xmlns" \[Rule] 
          "http://www.w3.org/1998/Math/MathML"}, {XMLElement[
          "semantics", {}, {XMLElement[
              "msup", {}, {XMLElement["mi", {}, {"x"}], 
                XMLElement["mn", {}, {"2"}]}], 
            XMLElement[
              "annotation-xml", {"encoding" \[Rule] 
                  "MathML-Content"}, {XMLElement[
                  "apply", {}, {XMLElement["power", {}, {}], 
                    XMLElement["ci", {}, {"x"}], 
                    XMLElement[
                      "cn", {"type" \[Rule] 
                          "integer"}, {"2"}]}]}]}]}]\)], "Output",
  CellLabel->"Out[54]=",
  CellTags->{"SymMMLToExpr", "i:116", "b:6.3"}]
}, Closed]],

Cell[TextData[{
  "Now we can take this result and use it as the argument to ",
  StyleBox["SymbolicMathMLToExpression",
    FontFamily->"Courier"],
  " to recover the original ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression."
}], "Text",
  CellTags->{"SymMMLToExpr", "i:116", "b:6.3"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToExpression[%]\)], "Input",
  CellLabel->"In[55]:=",
  CellTags->{"SymMMLToExpr", "i:116", "b:6.3"}],

Cell[BoxData[
    \(x\^2\)], "Output",
  CellLabel->"Out[55]=",
  CellTags->{"SymMMLToExpr", "i:116", "b:6.3"}]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Macintosh",
ScreenRectangle->{{33, 1152}, {0, 746}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
PrintingStyleEnvironment->"Printout",
ShowPageBreaks->False,
WindowSize->{697, 635},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingStartingPageNumber->1,
PrintingPageRange->{1, Automatic},
PrintingOptions->{"GraphicsPrintingFormat"->"RenderInFrontEnd"},
ShowSelection->True,
TaggingRules:>{"PaginationCache" -> {{2003, 5, 27, 16, 38, \
33.8271069`9.281839755021217}, {1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, \
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, \
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, \
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, \
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, \
2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, \
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, \
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, \
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, \
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, \
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, \
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, \
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, \
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, \
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, \
3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, \
4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, \
4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, \
4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, \
4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, \
4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, \
4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, \
4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, \
4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, \
4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, \
5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, \
5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, \
5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, \
5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, \
5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, \
5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, \
5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, \
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, \
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, \
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, \
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, \
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, \
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, \
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, \
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, \
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, \
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, \
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, \
6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, \
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, \
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, \
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, \
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, \
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, \
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, \
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, \
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, \
7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, \
8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, \
8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, \
8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, \
8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, \
8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, \
8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, \
8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, \
8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, \
8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, \
8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, \
8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8}}, "NextIndexingNumber" -> 118, \
"IndexEntries" -> {{"i:1", "W3C"}, {"i:10", "Character encoding"}, {"i:10", \
"XML declaration"}, {"i:100", 
  StyleBox[ "XMLGet", "MR"]}, {"i:101", 
  StyleBox[ "XMLGetString", "MR"]}, {"i:102", 
  StyleBox[ "InitializeXMLParser", "MR"]}, {"i:103", 
  StyleBox[ "ReleaseXMLParser", "MR"]}, {"i:104", 
  StyleBox[ "RawXML", "MR"]}, {"i:105", 
  StyleBox[ "NotebookToSymbolicNotebookML", "MR"]}, {"i:106", 
  StyleBox[ "ExpressionToSymbolicExpressionML", "MR"]}, {"i:107", 
  StyleBox[ "SymbolicNotebookMLToNotebook", "MR"]}, {"i:108", 
  StyleBox[ "SymbolicExpressionMLToExpression", "MR"]}, {"i:109", 
  StyleBox[ "BoxesToMathML", "MR"]}, {"i:110", 
  StyleBox[ "MathMLToBoxes", "MR"]}, {"i:111", 
  StyleBox[ "ExpressionToMathML", "MR"]}, {"i:112", 
  StyleBox[ "MathMLToExpression", "MR"]}, {"i:113", 
  StyleBox[ "SymbolicMathMLToBoxes", "MR"]}, {"i:114", 
  StyleBox[ "BoxesToSymbolicMathML", "MR"]}, {"i:115", 
  StyleBox[ "ExpressionToSymbolicMathML", "MR"]}, {"i:116", 
  StyleBox[ 
  "SymbolicMathMLToExpression", 
    "MR"]}, {"i:12", "Documents in XML"}, {"i:14", "Document type \
declarations"}, {"i:14", "W3C XML specification"}, {"i:14", 
  StyleBox[ "Doctype", "MR"]}, {"i:14", 
  StyleBox[ "Internal", "MR"]}, {"i:14", 
  StyleBox[ "Public", "MR"]}, {"i:14", 
  StyleBox[ "System", "MR"]}, {"i:17", 
  StyleBox[ 
  "Standalone", FontFamily -> 
    "Courier"]}, {"i:19", "Character encoding"}, {"i:20", "Document tree"}, \
{"i:20", "Epilog"}, {"i:20", "Processing instructions"}, {"i:20", "Prolog"}, \
{"i:20", 
  StyleBox[ 
  "Document", "MR"]}, {"i:21", "XML processing instructions"}, {"i:21", 
  StyleBox[ 
  "ProcessingInstruction", 
    "MR"]}, {"i:22", "Preserving CDATASection wrappers"}, {"i:22", "Raw \
character data"}, {"i:22", {
  StyleBox[ 
  "CDATASection", 
    "MR"], " "}}, {"i:23", "Overriding import formats"}, {"i:23", 
  StyleBox[ "Import", "MR"]}, {"i:24", "Importing string data"}, {"i:24", 
  StyleBox[ 
  "ImportString", 
    "MR"]}, {"i:25", "Initializing the parser"}, {"i:25", "Preinitialized \
parser object"}, {"i:25", "Retrieving files from web"}, {"i:25", 
  StyleBox[ "XMLGet", "MR"]}, {"i:25", 
  StyleBox[ 
  "XML`Parser`", FontFamily -> 
    "Courier"]}, {"i:26", "Importing XML string"}, {"i:26", 
  StyleBox[ 
  "XMLGetString", 
    "MR"]}, {"i:27", "Entity references"}, {"i:27", "Numeric entities"}, \
{"i:27", "Resolving Unicode characters"}, {"i:27", "Unicode characters"}, \
{"i:28", "Multiple conversion options"}, {"i:28", {"Controlling ", 
  StyleBox[ "Import", "MR"]}}, {"i:28", 
  StyleBox[ 
  "ConversionOptions", 
    "MR"]}, {"i:29", "Ignorable whitespace"}, {"i:29", "Normalizing \
whitespace"}, {"i:29", "Preserving whitespace"}, {"i:29", "Processing \
whitespace"}, {"i:29", "Stripping whitespace"}, {"i:29", "Whitespace"}, \
{"i:29", 
  StyleBox[ 
  "NormalizeWhitespace", 
    "MR"]}, {"i:3", "SVG"}, {"i:30", "Accessing remote DTD"}, {"i:30", \
"Remote DTD"}, {"i:30", 
  StyleBox[ 
  "AllowRemoteDTDAccess", 
    "MR"]}, {"i:31", "Entity delimiter characters"}, {"i:31", 
  StyleBox[ 
  "AllowUnrecognizedEntities", 
    "MR"]}, {"i:32", "Reading external DTD subsets"}, {"i:32", 
  StyleBox[ "ReadDTD", "MR"]}, {"i:33", "Validating XML"}, {"i:33", 
  StyleBox[ 
  "ValidateAgainstDTD", "MR"]}, {"i:34", "Default attributes"}, {"i:34", 
  StyleBox[ 
  "IncludeDefaultedAttributes", 
    "MR"]}, {"i:35", "Embedded objects"}, {"i:35", 
  StyleBox[ 
  "IncludeEmbeddedObjects", 
    "MR"]}, {"i:36", "Namespaces"}, {"i:36", "Non-standard namespaces"}, \
{"i:36", 
  StyleBox[ 
  "IncludeNamespaces", "MR"]}, {"i:37", "Character data"}, {"i:37", 
  StyleBox[ 
  "PreserveCDATASections", 
    "MR"]}, {"i:38", "Processing symbolic expressions"}, {"i:39", "Tree \
structure"}, {"i:39", "XML tree"}, {"i:40", "Extracting data"}, {"i:40", \
"Manipulating XML data"}, {"i:41", "Creating graphics"}, {"i:41", "MoDL"}, \
{"i:41", "Visualizing XML data"}, {"i:42", "Creating graphics"}, {"i:45", \
"XPath predicates"}, {"i:47", "Converting notebooks to HTML"}, {"i:47", \
"Exporting as HTML"}, {"i:48", "Verifying SymbolicXML"}, {"i:49", "Exporting \
XML data"}, {"i:49", 
  StyleBox[ "Export", "MR"]}, {"i:49", 
  StyleBox[ ".mml", FontFamily -> "Courier"]}, {"i:49", 
  StyleBox[ ".xml", FontFamily -> "Courier"]}, {"i:50", 
  StyleBox[ 
  "ExportString", 
    "MR"]}, {"i:51", "Controlling the export process"}, {"i:52", 
  StyleBox[ "Annotations", "MR"]}, {"i:52", 
  StyleBox[ "DOCTYPEDeclaration", "MR"]}, {"i:52", 
  StyleBox[ "XMLDeclaration", "MR"]}, {"i:53", 
  StyleBox[ "AttributeQuoting", "MR"]}, {"i:54", "Error checking"}, {"i:54", 
  StyleBox[ "CheckXML", "MR"]}, {"i:55", "Indenting elements"}, {"i:55", 
  StyleBox[ 
  "ElementFormatting", 
    "MR"]}, {"i:56", "Character replacement rules"}, {"i:56", 
  StyleBox[ "Entities", "MR"]}, {"i:57", "Declaring namespaces"}, {"i:57", 
  StyleBox[ 
  "NamespacePrefixes", 
    "MR"]}, {"i:58", "Automatic namespace declarations"}, {"i:58", 
  StyleBox[ 
  "PrefixCreation", 
    "MR"]}, {"i:6", "DOM API"}, {"i:6", "Pattern matching"}, {"i:6", "SAX \
API"}, {"i:6", "Tree structure"}, {"i:6", 
  StyleBox[ "J/Link", FontSlant -> "Italic"]}, {"i:63", 
  StyleBox[ "Number", "MR"]}, {"i:63", 
  StyleBox[ "String", FontFamily -> "Courier"]}, {"i:63", 
  StyleBox[ "Symbol", FontFamily -> "Courier"]}, {"i:64", 
  StyleBox[ "BoxData", "MR"]}, {"i:64", 
  StyleBox[ "CellGroupData", "MR"]}, {"i:64", 
  StyleBox[ "GraphicsData", "MR"]}, {"i:64", 
  StyleBox[ "OutputFormData", "MR"]}, {"i:64", 
  StyleBox[ "StyleData", "MR"]}, {"i:64", 
  StyleBox[ "TextData", "MR"]}, {"i:64", 
  StyleBox[ 
  "XMLData", "MR"]}, {"i:65", "Boxes"}, {"i:65", "Generic boxes"}, {"i:65", 
  StyleBox[ "CounterBox", "MR"]}, {"i:65", 
  StyleBox[ "FormBox", "MR"]}, {"i:65", 
  StyleBox[ "GridBox", "MR"]}, {"i:65", 
  StyleBox[ "InterpretationBox", "MR"]}, {"i:65", 
  StyleBox[ "OptionValueBox", "MR"]}, {"i:65", 
  StyleBox[ "RowBox", "MR"]}, {"i:65", 
  StyleBox[ "StyleBox", "MR"]}, {"i:65", 
  StyleBox[ "TagBox", "MR"]}, {"i:65", 
  StyleBox[ "ValueBox", "MR"]}, {"i:66", "Importing NotebookML"}, {"i:66", 
  StyleBox[ 
  ".nbml", FontFamily -> 
    "Courier"]}, {"i:68", "Applying functions to NotebookML"}, {"i:68", \
"Preprocessing notebooks"}, {"i:69", "Postprocessing NotebookML"}, {"i:7", \
"Child element"}, {"i:7", "Elements"}, {"i:7", {"Nesting ", 
  StyleBox[ 
  "XMLElement", "Input", FontWeight -> "Plain", FontVariations -> {
    "CompatibilityType" -> 0}], " commands"}}, {"i:72", 
  StyleBox[ "Annotations", "MR"]}, {"i:72", 
  StyleBox[ "StyleAdvisories", "MR"]}, {"i:72", 
  StyleBox[ "XMLDeclaration", "MR"]}, {"i:73", 
  StyleBox[ 
  "BoxFormats", 
    "MR"]}, {"i:74", "Changing graphics formats for export"}, {"i:74", 
  StyleBox[ "GraphicsFormats", "MR"]}, {"i:75", 
  StyleBox[ "alternate", "MR"]}, {"i:75", 
  StyleBox[ "charset", "MR"]}, {"i:75", 
  StyleBox[ "href", "MR"]}, {"i:75", 
  StyleBox[ "media", "MR"]}, {"i:75", 
  StyleBox[ "Stylesheets", "MR"]}, {"i:75", 
  StyleBox[ "title", "MR"]}, {"i:75", 
  StyleBox[ 
  "type", "MR"]}, {"i:76", "URI"}, {"i:77", "Cascading style sheets"}, \
{"i:78", "Displaying mathematics on the web"}, {"i:8", "Default namespace"}, \
{"i:8", "Implicit namespace"}, {"i:8", "Namespaces"}, {"i:80", "Equation \
styles in MathML"}, {"i:80", "MathML specification"}, {"i:80", "Presentation \
elements"}, {"i:80", 
  StyleBox[ "math", "MR"]}, {"i:80", 
  StyleBox[ "mi", "MR"]}, {"i:80", 
  StyleBox[ "mn", "MR"]}, {"i:80", 
  StyleBox[ "mo", "MR"]}, {"i:80", 
  StyleBox[ 
  "mrow", "MR"]}, {"i:81", "Content elements"}, {"i:81", "Content MathML"}, \
{"i:81", 
  StyleBox[ "ci", FontFamily -> "Courier"]}, {"i:81", 
  StyleBox[ 
  "cn", FontFamily -> 
    "Courier"]}, {"i:82", "Importing MathML"}, {"i:83", "Generating MathML"}, \
{"i:86", "MathML conversion options"}, {"i:88", 
  StyleBox[ "Formats", "MR"]}, {"i:89", 
  StyleBox[ "IncludeMarkupAnnotations", "MR"]}, {"i:90", 
  StyleBox[ 
  "MathAttributes", 
    "MR"]}, {"i:91", "Plane 0 Unicode characters"}, {"i:91", "Unicode \
characters"}, {"i:91", 
  StyleBox[ "mathvariant", "MR"]}, {"i:91", 
  StyleBox[ 
  "UseUnicodePlane1Characters", 
    "MR"]}, {"i:93", "Context paths"}, {"i:93", "XML functions"}, {"i:94", 
  StyleBox[ "SymbolicXMLQ", "MR"]}, {"i:95", 
  StyleBox[ "FromSymbolicXML", "MR"]}, {"i:96", 
  StyleBox[ "ToSymbolicXML", "MR"]}, {"i:97", 
  StyleBox[ "SymbolicXMLErrors", "MR"]}, {"i:98", 
  StyleBox[ "ToVerboseXML", "MR"]}, {"i:99", 
  StyleBox[ 
  "ToCompactXML", 
    "MR"]}, {"i:1", "XML", "introduction"}, {"i:10", "External DTD", {"and ", \

  StyleBox[ "XMLObject", FontFamily -> "Courier"]}}, {"i:10", 
  StyleBox[ "XMLObject", FontFamily -> "Courier"], 
  StyleBox[ 
  "Declaration", FontFamily -> 
    "Courier"]}, {"i:117", "Syntax", "MathML"}, {"i:12", 
  StyleBox[ "XMLObject", FontFamily -> "Courier"], 
  StyleBox[ 
  "Document", FontFamily -> 
    "Courier"]}, {"i:14", "DTD", "and internal subsets"}, {"i:14", "DTD", "in \
local file system"}, {"i:14", "DTD", "public"}, {"i:15", 
  StyleBox[ 
  "XMLObject", FontFamily -> 
    "Courier"], "overview"}, {"i:16", "Declaration", {"and ", 
  StyleBox[ "XMLObject", "MR"]}}, {"i:19", "External DTD", {"and ", 
  StyleBox[ 
  "XMLObject", 
    "MR"]}}, {"i:2", "Editing MathML", "introduction"}, {"i:2", "Mathematical \
notation", "on web page"}, {"i:2", "MathML", "introduction"}, {"i:2", "Native \
XML formats", "MathML"}, {"i:20", "Comments", "and epilog"}, {"i:20", "DTD \
declarations", "and prolog"}, {"i:20", "Validating XML", {"and ", 
  StyleBox[ 
  "XMLObject", 
    "MR"]}}, {"i:22", "Character data", "and CDATA"}, {"i:22", "Special \
characters", "and CDATA sections"}, {"i:22", "Wrappers", {"and ", 
  StyleBox[ 
  "CDATASection", 
    "MR"]}}, {"i:23", "File extensions", "and importing XML"}, {"i:23", "File \
formats", "and importing XML"}, {"i:23", "Importing XML", "and file \
extensions"}, {"i:23", "Importing XML", "and file formats"}, {"i:23", \
"Importing XML", "controlling output"}, {"i:23", "Recognized import formats", \
{"and ", 
  StyleBox[ 
  "Import", 
    "MR"]}}, {"i:24", "File extensions", "and importing string data"}, \
{"i:24", "File format", "and importing string data"}, {"i:24", "Importing \
string data", "and file extensions"}, {"i:24", "Recognized import formats", \
{"and ", 
  StyleBox[ 
  "ImportString", 
    "MR"]}}, {"i:24", "Strings", "and importing XML data"}, {"i:25", "DTD", \
"and initializing the parser"}, {"i:25", "Importing files", "from website"}, \
{"i:25", "URL", "and downloading files"}, {"i:25", "Website", "and \
downloading files"}, {"i:25", "XMLGet", "and context path"}, {"i:26", \
"SymbolicXML", "and importing XML strings"}, {"i:27", "DTD", "and resolving \
entity references"}, {"i:27", "DTD", "and validating XML data"}, {"i:27", \
"Validating XML", {"with ", 
  StyleBox[ 
  "Import", 
    "MR"]}}, {"i:28", "Importing XML", "and conversion options"}, {"i:29", \
"DTD", "and whitespace"}, {"i:29", "Formatting", "and ignorable whitespace"}, \
{"i:29", "Importing XML", "and processing whitespace"}, {"i:29", "Newline \
character", "and whitespace"}, {"i:29", "Pattern-matching", "and \
whitespace"}, {"i:29", "Space character", "and whitespace"}, {"i:29", \
"SymbolicXML", "and pattern-matching with whitespace"}, {"i:29", "Tab \
character", "and whitespace"}, {"i:3", "GIF", "and SVG"}, {"i:3", "JPEG", \
"and SVG"}, {"i:3", "Native XML formats", "SVG"}, {"i:3", "Scripts", "and \
SVG"}, {"i:3", "Two-dimensional graphics", "and SVG"}, {"i:30", "DTD", \
"accessing remote"}, {"i:30", "Network", "and accessing remote DTD"}, \
{"i:30", "Retrieving DTD", "across network"}, {"i:31", "Parser", "and \
undefined entities"}, {"i:31", "Undefined entities", "and parser behavior"}, \
{"i:32", "DTD", "and external subset"}, {"i:32", "Preinitialized parser", \
{"and ", 
  StyleBox[ 
  "ReadDTD", 
    "MR"]}}, {"i:33", "DTD", "validating XML"}, {"i:34", "Attributes", \
"default attributes in SymbolicXML"}, {"i:34", "DTD", "and default \
attributes"}, {"i:34", "SymbolicXML", "and default attributes"}, {"i:35", \
"Comments", "inclusion in document tree"}, {"i:35", "Document tree", "and \
comments"}, {"i:35", "Document tree", "and processing instructions"}, \
{"i:35", "Pattern-matching", {"and ", 
  StyleBox[ 
  "IncludeEmbeddedObjects", 
    "MR"]}}, {"i:35", "Processing instructions", "inclusion in document \
tree"}, {"i:36", "Attributes", {"and ", 
  StyleBox[ "IncludeNamespaces", "MR"]}}, {"i:36", "Elements", {"and ", 
  StyleBox[ 
  "IncludeNamespaces", 
    "MR"]}}, {"i:36", "Namespace", "and scoping"}, {"i:36", "Namespaces", \
"and non-standard use"}, {"i:37", "Pattern-matching", {"and ", 
  StyleBox[ 
  "PreserveCDATASections", "MR"]}}, {"i:38", "Pattern-matching", {"and ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"]}}, {"i:38", "Processing XML data", "introduction"}, {"i:38", \
"Transforming XML", "introduction"}, {"i:39", "Cell grouping", "and tree \
structure"}, {"i:4", "CSS", "and NotebookML"}, {"i:4", "MathML", "and \
NotebookML"}, {"i:4", "Native XML formats", "NotebookML"}, {"i:4", \
"NotebookML", "and MathML"}, {"i:4", "NotebookML", "introduction"}, {"i:4", \
"Style sheets", "CSS"}, {"i:4", "Style sheets", "XSLT"}, {"i:4", "SVG", "and \
NotebookML"}, {"i:40", "Pattern-matching", "and manipulating data"}, {"i:40", \
"Structured data", "and XML"}, {"i:41", "3D graphic", "from XML file"}, \
{"i:41", "Graphics", "from XML"}, {"i:42", "Graphics", "from XML file"}, \
{"i:43", "Pattern-matching", "and XSLT"}, {"i:43", "XSLT transformations", \
"introduction"}, {"i:44", "XSLT", "and inserting attribute values"}, {"i:45", \
"Predicates", "and XPath"}, {"i:45", "XSLT", "and XPath predicates"}, \
{"i:46", "XSLT", "traversing up the XML document"}, {"i:47", "SymbolicXML", \
"and notebook expressions"}, {"i:48", "SymbolicXML", "verifying syntax"}, \
{"i:48", "Syntax", "and SymbolicXML verification"}, {"i:49", "Converting \
expressions", "to XML data"}, {"i:49", "File extension", {"and ", 
  StyleBox[ "Export", "MR"]}}, {"i:49", "File extension", {"and ", 
  StyleBox[ 
  ".mml", FontFamily -> "Courier"]}}, {"i:49", "File extension", {"and ", 
  StyleBox[ 
  ".xml", FontFamily -> 
    "Courier"]}}, {"i:5", "ExpressionML", "introduction"}, {"i:5", "Native \
XML formats", "ExpressionML"}, {"i:51", "Conversion options", 
  StyleBox[ 
  "Export", 
    "MR"]}, {"i:52", "DTD", "specification on export"}, {"i:52", "Export \
conversion options", 
  StyleBox[ "Annotations", "MR"]}, {"i:53", "Attribute values", {"and ", 
  StyleBox[ "AttributeQuoting", "MR"]}}, {"i:53", "Conflicts", {"and ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " strings"}}, {"i:53", "Export conversion options", 
  StyleBox[ "AttributeQuoting", "MR"]}, {"i:53", "Quotes", {"and ", 
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " string conflicts"}}, {"i:54", "Export conversion options", 
  StyleBox[ 
  "CheckXML", 
    "MR"]}, {"i:54", "Processing time", "and error checking"}, {"i:55", \
"Export conversion options", 
  StyleBox[ "ElementFormatting", "MR"]}, {"i:56", "Character data", {"and ", 
  StyleBox[ "Export", "MR"]}}, {"i:56", "Export conversion options", 
  StyleBox[ 
  "Entities", "MR"]}, {"i:56", "Named character entities", {"and ", 
  StyleBox[ 
  "Export", 
    "MR"]}}, {"i:56", "Resolving entity names", "defined in HTML"}, {"i:56", \
"Resolving entity names", "defined in MathML"}, {"i:57", "Export conversion \
options", 
  StyleBox[ 
  "NamespacePrefixes", "MR"]}, {"i:58", "Export conversion options", 
  StyleBox[ 
  "PrefixCreation", 
    "MR"]}, {"i:58", "Namespace declaration", "automatic generation"}, \
{"i:58", "Namespace declaration", {"and ", 
  StyleBox[ 
  "PrefixCreation", 
    "MR"]}}, {"i:6", "Conversion options", "and exporting XML"}, {"i:6", \
"Conversion options", "and importing XML"}, {"i:6", "Importing XML", \
"overview"}, {"i:6", "Java", "and XML"}, {"i:6", "SymbolicXML", \
"introduction"}, {"i:60", "Cells", "and ExpressionML"}, {"i:60", \
"ExpressionML", "introduction"}, {"i:60", "NotebookML", "introduction"}, \
{"i:60", {
  StyleBox[ 
  "Mathematica", FontSlant -> 
    "Italic"], " notebooks"}, "and NotebookML"}, {"i:61", "Character data", \
"and NotebookML"}, {"i:61", "Data", "and NotebookML"}, {"i:61", "NotebookML", \
"data types"}, {"i:61", "NotebookML", "syntax"}, {"i:61", "Syntax", \
"NotebookML"}, {"i:61", "Typesetting information", {"and ", 
  StyleBox[ 
  "Box", "MR"], " representation"}}, {"i:62", "Color values", "and \
NotebookML"}, {"i:62", "NotebookML", "options"}, {"i:62", "NotebookML", \
"suboptions"}, {"i:63", "Character data", "and NotebookML"}, {"i:63", "String \
data", "and NotebookML"}, {"i:64", "Data", "and NotebookML"}, {"i:64", \
"NotebookML", "data"}, {"i:65", "Boxes", "generic"}, {"i:65", "Typesetting \
information", {"and ", 
  StyleBox[ 
  "Box", "MR"], " representation"}}, {"i:66", "NotebookML", "importing"}, \
{"i:67", "NotebookML", "converting to SymbolicXML"}, {"i:67", "SymbolicXML", \
"conversion from NotebookML"}, {"i:68", "NotebookML", "and preprocessing"}, \
{"i:7", "Attributes", {"and ", 
  StyleBox[ 
  "XMLElement", "Input", FontWeight -> "Plain", FontVariations -> {
    "CompatibilityType" -> 0}]}}, {"i:7", "Data", {"in ", 
  StyleBox[ 
  "XMLElement", "Input", FontWeight -> "Plain", FontVariations -> {
    "CompatibilityType" -> 
    0}]}}, {"i:7", "Naming conflicts", "and SymbolicXML"}, {"i:7", \
"Replicating nested structure", 
  StyleBox[ 
  "", "Input", FontWeight -> "Plain", FontVariations -> {"CompatibilityType" -> 
    0}]}, {"i:7", "Symbolic XML", "and strings"}, {"i:7", "SymbolicXML", \
{"and ", 
  StyleBox[ 
  "XMLElement", "Input", FontWeight -> "Plain", FontVariations -> {
    "CompatibilityType" -> 0}]}}, {"i:7", 
  StyleBox[ 
  "XMLElement", "Input", FontWeight -> "Plain", FontVariations -> {
    "CompatibilityType" -> 0}], "arguments"}, {"i:7", 
  StyleBox[ 
  "XMLElement", "Input", FontWeight -> "Plain", FontVariations -> {
    "CompatibilityType" -> 
    0}], "attributes"}, {"i:70", "GIF", "and exporting NotebookML"}, {"i:70", \
"Graphics", "exporting in NotebookML"}, {"i:70", "NotebookML", "exporting"}, \
{"i:71", "NotebookML", {"conversion options for ", 
  StyleBox[ 
  "Export", 
    "MR"]}}, {"i:72", "Class attributes", "and NotebookML"}, {"i:72", \
"NotebookML", "header information"}, {"i:74", "Exporting NotebookML", \
"graphics formats"}, {"i:75", "NotebookML", "stylesheets"}, {"i:76", "DTD", \
"ExpressionML location"}, {"i:76", "DTD", "NotebookML location"}, {"i:76", \
"Namespace", "ExpressionML"}, {"i:76", "Namespace", "MathML"}, {"i:76", \
"Namespace", "NotebookML"}, {"i:76", "Namespace", "XSLT"}, {"i:76", \
"Namespaces", "and URI"}, {"i:77", "CSS", "and NotebookML"}, {"i:78", \
"MathML", "introduction"}, {"i:79", "Combined markup", "MathML"}, {"i:79", \
"Content MathML", "introduction"}, {"i:79", "MathML", "combined markup"}, \
{"i:79", "MathML", "content MathML"}, {"i:79", "MathML", "presentation \
MathML"}, {"i:79", "MathML", "syntax"}, {"i:79", "Presentation MathML", \
"introduction"}, {"i:8", "SymbolicXML", "and namespaces"}, {"i:8", 
  StyleBox[ 
  "XMLElement", FontFamily -> 
    "Courier"], "and namespaces"}, {"i:80", "Character entities", "and \
MathML"}, {"i:80", "MathML", "delimiter"}, {"i:80", "MathML", "identifiers"}, \
{"i:80", "MathML", "number"}, {"i:80", "MathML", "operator"}, {"i:80", \
"MathML", "presentation elements"}, {"i:80", "MathML", "styles"}, {"i:80", \
"Presentation MathML", "syntax"}, {"i:80", "Special characters", "and \
MathML"}, {"i:80", "Styles", "and MathML"}, {"i:81", "Identifiers", "and \
content MathML"}, {"i:81", "MathML", "Content MathML"}, {"i:81", "Numbers", \
"and content MathML"}, {"i:82", "MathML", "import conversion options"}, \
{"i:82", "MathML", "importing"}, {"i:82", 
  StyleBox[ 
  "Import", 
    "MR"], "and MathML"}, {"i:83", "Boxes", "converting to MathML"}, {"i:83", \
"Expressions", "converting to MathML"}, {"i:83", "MathML", "from boxes"}, \
{"i:83", "MathML", "from expressions"}, {"i:84", "MathML", "controlling \
output"}, {"i:84", "MathML", "options"}, {"i:84", 
  StyleBox[ 
  "Import", FontFamily -> 
    "Courier"], "MathML"}, {"i:85", "MathML", "exporting"}, {"i:86", \
"Conversion options", "MathML"}, {"i:87", "Annotations", "for MathML"}, \
{"i:87", "MathML", "annotations"}, {"i:9", 
  StyleBox[ 
  "XMLObject", FontFamily -> 
    "Courier"], "introduction"}, {"i:90", "MathML", "root element \
attributes"}, {"i:91", "MathML", "and Unicode characters"}, {"i:92", \
"MathML", "miscellaneous symbols"}, {"i:92", "Symbols", "MathML elements"}, \
{"i:93", "MathML", "context path"}, {"i:93", "NotebookML", "context path"}, \
{"i:11", "Comments", {"and ", 
  StyleBox[ "XMLObject", "MR"]}, ""}, {"i:11", 
  StyleBox[ "XMLObject", FontFamily -> "Courier"], 
  StyleBox[ "Comment", FontFamily -> "Courier"], ""}, {"i:14", 
  StyleBox[ "XMLObject", "MR"], 
  StyleBox[ "Doctype", "MR"], ""}, {"i:19", "Declaration", {"and ", 
  StyleBox[ 
  "XMLObject", 
    "MR"]}, ""}, {"i:2", "Authoring MathML", "introduction", ""}, {"i:21", \
"Pseudoattributes", "and processing instructions", ""}, {"i:23", "Importing \
XML", "overview", ""}, {"i:25", "Context paths", "", ""}, {"i:28", \
"Conversion options", 
  StyleBox[ 
  "Import", 
    "MR"], ""}, {"i:32", "External DTD", "subsets", ""}, {"i:4", "XHTML", \
"and NotebookML", ""}, {"i:4", "XSLT transformations", "and NotebookML", ""}, \
{"i:42", "Visualizing XML data", "", ""}, {"i:49", "File formats", {"and ", 
  StyleBox[ 
  "Export", 
    "MR"]}, ""}, {"i:50", "Converting expressions", "to XML strings", ""}, \
{"i:51", "Specifying export conversion options", 
  StyleBox[ "", "MR"], ""}, {"i:52", 
  StyleBox[ "DocumentHeader", "MR"], "", ""}, {"i:54", 
  StyleBox[ 
  "Export", 
    "MR"], "and error checking", ""}, {"i:55", "Elements", "indentation on \
export", ""}, {"i:61", "Boxes", "", ""}, {"i:61", 
  StyleBox[ "TextData", "MR"], "", ""}, {"i:7", 
  StyleBox[ 
  "XMLElement", 
    "MR"], "introduction", ""}, {"i:75", "Pseudoattributes", "and \
NotebookML", ""}, {"i:8", "Explicit namespace prefix", "", ""}, {"i:8", \
"Namespace prefix", "", ""}, {"i:80", "Delimiters", "in presentation MathML", \
""}, {"i:80", "Identifiers", "in presentation MathML", ""}, {"i:80", \
"Numbers", "in presentation MathML", ""}, {"i:80", "Operators", "in \
presentation MathML", ""}, {"i:85", "Exporting MathML", "", ""}, {"i:91", \
"Plane 1 Unicode characters", "", ""}}},
DefaultNewCellStyle->"Text",
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "XMLMathIntro"->{
    Cell[1983, 66, 164, 5, 36, "Subsection",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[2150, 73, 646, 16, 56, "Text",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[2799, 91, 291, 9, 26, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3093, 102, 324, 8, 44, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3420, 112, 202, 4, 26, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3625, 118, 280, 7, 44, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3908, 127, 210, 4, 26, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[4121, 133, 450, 11, 56, "Text",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}]},
  "XMLFeaturesIntro"->{
    Cell[1983, 66, 164, 5, 36, "Subsection",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[2150, 73, 646, 16, 56, "Text",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[2799, 91, 291, 9, 26, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3093, 102, 324, 8, 44, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3420, 112, 202, 4, 26, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3625, 118, 280, 7, 44, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3908, 127, 210, 4, 26, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[4121, 133, 450, 11, 56, "Text",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}]},
  "i:1"->{
    Cell[1983, 66, 164, 5, 36, "Subsection",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[2150, 73, 646, 16, 56, "Text",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[2799, 91, 291, 9, 26, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3093, 102, 324, 8, 44, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3420, 112, 202, 4, 26, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3625, 118, 280, 7, 44, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3908, 127, 210, 4, 26, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[4121, 133, 450, 11, 56, "Text",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}]},
  "b:0.0"->{
    Cell[1983, 66, 164, 5, 36, "Subsection",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[2150, 73, 646, 16, 56, "Text",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[2799, 91, 291, 9, 26, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3093, 102, 324, 8, 44, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3420, 112, 202, 4, 26, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3625, 118, 280, 7, 44, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[3908, 127, 210, 4, 26, "BulletedList",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}],
    Cell[4121, 133, 450, 11, 56, "Text",
      CellTags->{"XMLMathIntro", "XMLFeaturesIntro", "i:1", "b:0.0"}]},
  "NativeXMLFormats"->{
    Cell[4608, 149, 83, 1, 36, "Subsection",
      CellTags->{"NativeXMLFormats", "b:0.1"}],
    Cell[4694, 152, 614, 13, 72, "Text",
      CellTags->{"NativeXMLFormats", "b:0.1"}],
    Cell[5333, 169, 81, 1, 34, "Subsubsection",
      CellTags->{"NativeXMLFormats", "i:2", "b:0.1"}],
    Cell[5417, 172, 698, 14, 88, "Text",
      CellTags->{"NativeXMLFormats", "i:2", "b:0.1"}],
    Cell[6118, 188, 652, 16, 72, "Text",
      CellTags->{"NativeXMLFormats", "i:2", "b:0.1"}],
    Cell[6807, 209, 78, 1, 34, "Subsubsection",
      CellTags->{"NativeXMLFormats", "i:3", "b:0.1"}],
    Cell[6888, 212, 590, 11, 72, "Text",
      CellTags->{"NativeXMLFormats", "i:3", "b:0.1"}],
    Cell[7515, 228, 85, 1, 34, "Subsubsection",
      CellTags->{"NativeXMLFormats", "i:4", "b:0.1"}],
    Cell[7603, 231, 567, 13, 72, "Text",
      CellTags->{"NativeXMLFormats", "i:4", "b:0.1"}],
    Cell[8173, 246, 809, 14, 104, "Text",
      CellTags->{"NativeXMLFormats", "i:4", "b:0.1"}],
    Cell[9019, 265, 87, 1, 34, "Subsubsection",
      CellTags->{"NativeXMLFormats", "i:5", "b:0.1"}],
    Cell[9109, 268, 436, 11, 56, "Text",
      CellTags->{"NativeXMLFormats", "i:5", "b:0.1"}]},
  "b:0.1"->{
    Cell[4608, 149, 83, 1, 36, "Subsection",
      CellTags->{"NativeXMLFormats", "b:0.1"}],
    Cell[4694, 152, 614, 13, 72, "Text",
      CellTags->{"NativeXMLFormats", "b:0.1"}],
    Cell[5333, 169, 81, 1, 34, "Subsubsection",
      CellTags->{"NativeXMLFormats", "i:2", "b:0.1"}],
    Cell[5417, 172, 698, 14, 88, "Text",
      CellTags->{"NativeXMLFormats", "i:2", "b:0.1"}],
    Cell[6118, 188, 652, 16, 72, "Text",
      CellTags->{"NativeXMLFormats", "i:2", "b:0.1"}],
    Cell[6807, 209, 78, 1, 34, "Subsubsection",
      CellTags->{"NativeXMLFormats", "i:3", "b:0.1"}],
    Cell[6888, 212, 590, 11, 72, "Text",
      CellTags->{"NativeXMLFormats", "i:3", "b:0.1"}],
    Cell[7515, 228, 85, 1, 34, "Subsubsection",
      CellTags->{"NativeXMLFormats", "i:4", "b:0.1"}],
    Cell[7603, 231, 567, 13, 72, "Text",
      CellTags->{"NativeXMLFormats", "i:4", "b:0.1"}],
    Cell[8173, 246, 809, 14, 104, "Text",
      CellTags->{"NativeXMLFormats", "i:4", "b:0.1"}],
    Cell[9019, 265, 87, 1, 34, "Subsubsection",
      CellTags->{"NativeXMLFormats", "i:5", "b:0.1"}],
    Cell[9109, 268, 436, 11, 56, "Text",
      CellTags->{"NativeXMLFormats", "i:5", "b:0.1"}]},
  "i:2"->{
    Cell[5333, 169, 81, 1, 34, "Subsubsection",
      CellTags->{"NativeXMLFormats", "i:2", "b:0.1"}],
    Cell[5417, 172, 698, 14, 88, "Text",
      CellTags->{"NativeXMLFormats", "i:2", "b:0.1"}],
    Cell[6118, 188, 652, 16, 72, "Text",
      CellTags->{"NativeXMLFormats", "i:2", "b:0.1"}]},
  "i:3"->{
    Cell[6807, 209, 78, 1, 34, "Subsubsection",
      CellTags->{"NativeXMLFormats", "i:3", "b:0.1"}],
    Cell[6888, 212, 590, 11, 72, "Text",
      CellTags->{"NativeXMLFormats", "i:3", "b:0.1"}]},
  "i:4"->{
    Cell[7515, 228, 85, 1, 34, "Subsubsection",
      CellTags->{"NativeXMLFormats", "i:4", "b:0.1"}],
    Cell[7603, 231, 567, 13, 72, "Text",
      CellTags->{"NativeXMLFormats", "i:4", "b:0.1"}],
    Cell[8173, 246, 809, 14, 104, "Text",
      CellTags->{"NativeXMLFormats", "i:4", "b:0.1"}]},
  "i:5"->{
    Cell[9019, 265, 87, 1, 34, "Subsubsection",
      CellTags->{"NativeXMLFormats", "i:5", "b:0.1"}],
    Cell[9109, 268, 436, 11, 56, "Text",
      CellTags->{"NativeXMLFormats", "i:5", "b:0.1"}]},
  "SymXMLIntro"->{
    Cell[9594, 285, 71, 1, 36, "Subsection",
      CellTags->{"SymXMLIntro", "b:0.2"}],
    Cell[9768, 293, 716, 19, 72, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[10487, 314, 646, 18, 57, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[11136, 334, 190, 6, 24, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[11329, 342, 114, 2, 29, "Program",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[11446, 346, 408, 12, 40, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[11857, 360, 258, 10, 24, "IndentedText",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[12118, 372, 219, 6, 25, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[12340, 380, 211, 8, 30, "Program",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[12554, 390, 483, 15, 56, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[13040, 407, 850, 18, 104, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[13893, 427, 782, 16, 104, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[14678, 445, 861, 14, 120, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[15542, 461, 778, 21, 72, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}]},
  "b:0.2"->{
    Cell[9594, 285, 71, 1, 36, "Subsection",
      CellTags->{"SymXMLIntro", "b:0.2"}],
    Cell[9690, 290, 75, 1, 34, "Subsubsection",
      CellTags->{"i:6", "b:0.2"}],
    Cell[9768, 293, 716, 19, 72, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[10487, 314, 646, 18, 57, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[11136, 334, 190, 6, 24, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[11329, 342, 114, 2, 29, "Program",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[11446, 346, 408, 12, 40, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[11857, 360, 258, 10, 24, "IndentedText",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[12118, 372, 219, 6, 25, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[12340, 380, 211, 8, 30, "Program",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[12554, 390, 483, 15, 56, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[13040, 407, 850, 18, 104, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[13893, 427, 782, 16, 104, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[14678, 445, 861, 14, 120, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[15542, 461, 778, 21, 72, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[16357, 487, 90, 1, 34, "Subsubsection",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[16450, 490, 292, 7, 41, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[16745, 499, 584, 24, 24, "IndentedText",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[17332, 525, 108, 1, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[17443, 528, 470, 19, 24, "IndentedText",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[17916, 549, 224, 7, 25, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[18143, 558, 121, 1, 26, "BulletedList",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[18267, 561, 373, 11, 44, "BulletedList",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[18643, 574, 678, 15, 80, "BulletedList",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[19324, 591, 409, 8, 56, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[19736, 601, 90, 1, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[19829, 604, 98, 1, 29, "Program",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[19930, 607, 119, 1, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20052, 610, 136, 4, 29, "Program",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20191, 616, 147, 4, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20341, 622, 281, 11, 149, "Program",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20625, 635, 109, 1, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20737, 638, 371, 8, 104, "Program",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[21145, 651, 96, 1, 34, "Subsubsection",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[21244, 654, 349, 6, 56, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[21596, 662, 105, 1, 34, "Subsubsubsection",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[21704, 665, 461, 10, 56, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[22168, 677, 222, 7, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[22393, 686, 201, 8, 104, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[22597, 696, 118, 1, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[22718, 699, 294, 7, 89, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23015, 708, 296, 9, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23314, 719, 200, 3, 23, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23517, 724, 107, 1, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23627, 727, 365, 10, 44, "BulletedList",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23995, 739, 308, 9, 44, "BulletedList",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[24306, 750, 257, 7, 40, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[24566, 759, 271, 11, 30, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[24840, 772, 375, 12, 40, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[25218, 786, 114, 1, 34, "Subsubsubsection",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[25335, 789, 250, 5, 40, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[25588, 796, 457, 12, 56, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[26048, 810, 428, 15, 209, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[26479, 827, 118, 1, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[26600, 830, 781, 15, 179, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[27384, 847, 104, 1, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[27491, 850, 494, 15, 62, "BulletedList",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[27988, 867, 656, 22, 62, "BulletedList",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[28681, 894, 95, 1, 34, "Subsubsection",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[28779, 897, 988, 28, 89, "Text",
      CellTags->{"XMLObject", "i:9", "i:15", "b:0.2"}],
    Cell[29770, 927, 131, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[29904, 931, 127, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30034, 935, 128, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30165, 939, 127, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30295, 943, 141, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30439, 947, 132, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30574, 951, 83, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[30660, 954, 304, 7, 40, "Text",
      CellTags->{"XMLObject", "i:10", "i:19", "b:0.2"}],
    Cell[30967, 963, 218, 7, 30, "Program",
      CellTags->{"XMLObject", "i:16", "i:19", "b:0.2"}],
    Cell[31188, 972, 90, 1, 24, "Text",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[31281, 975, 393, 13, 26, "BulletedList",
      CellTags->{"XMLObject", "i:17", "i:19", "b:0.2"}],
    Cell[31677, 990, 430, 10, 62, "BulletedList",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32110, 1002, 94, 1, 24, "Text",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32207, 1005, 126, 2, 29, "Program",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32336, 1009, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32448, 1012, 185, 4, 29, "Program",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32636, 1018, 79, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[32718, 1021, 239, 8, 24, "Text",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[32960, 1031, 163, 6, 30, "Program",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33126, 1039, 97, 1, 24, "Text",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33226, 1042, 90, 1, 29, "Program",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33319, 1045, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33431, 1048, 109, 1, 29, "Program",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33543, 1051, 80, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[33626, 1054, 320, 10, 40, "Text",
      CellTags->{"XMLObject", "i:12", "i:20", "b:0.2"}],
    Cell[33949, 1066, 221, 9, 30, "Program",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34173, 1077, 323, 9, 40, "Text",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34499, 1088, 177, 4, 24, "Text",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34679, 1094, 129, 5, 59, "Program",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34811, 1101, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34923, 1104, 235, 5, 44, "Program",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[35161, 1111, 822, 23, 72, "Text",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[35986, 1136, 79, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36068, 1139, 246, 7, 40, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36317, 1148, 213, 9, 30, "Program",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36533, 1159, 92, 1, 24, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36628, 1162, 304, 9, 26, "BulletedList",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36935, 1173, 213, 6, 26, "BulletedList",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[37151, 1181, 250, 6, 44, "BulletedList",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[37404, 1189, 230, 5, 40, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[37637, 1196, 252, 7, 60, "Program",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[37892, 1205, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[38004, 1208, 324, 8, 45, "Program",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[38331, 1218, 296, 9, 24, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[38630, 1229, 93, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[38726, 1232, 259, 7, 40, "Text",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[38988, 1241, 209, 7, 30, "Program",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[39200, 1250, 278, 6, 40, "Text",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[39481, 1258, 120, 1, 29, "Program",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[39604, 1261, 268, 5, 40, "Text",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[39875, 1268, 179, 4, 44, "Program",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[40057, 1274, 84, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[40144, 1277, 820, 22, 88, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[40967, 1301, 145, 4, 24, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41115, 1307, 93, 1, 29, "Program",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41211, 1310, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41323, 1313, 114, 1, 29, "Program",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41440, 1316, 419, 11, 56, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41862, 1329, 273, 7, 24, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}]},
  "i:6"->{
    Cell[9690, 290, 75, 1, 34, "Subsubsection",
      CellTags->{"i:6", "b:0.2"}],
    Cell[9768, 293, 716, 19, 72, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[10487, 314, 646, 18, 57, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[11136, 334, 190, 6, 24, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[11329, 342, 114, 2, 29, "Program",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[11446, 346, 408, 12, 40, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[11857, 360, 258, 10, 24, "IndentedText",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[12118, 372, 219, 6, 25, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[12340, 380, 211, 8, 30, "Program",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[12554, 390, 483, 15, 56, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[13040, 407, 850, 18, 104, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[13893, 427, 782, 16, 104, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[14678, 445, 861, 14, 120, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}],
    Cell[15542, 461, 778, 21, 72, "Text",
      CellTags->{"SymXMLIntro", "i:6", "b:0.2"}]},
  "XMLElement"->{
    Cell[16357, 487, 90, 1, 34, "Subsubsection",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[16450, 490, 292, 7, 41, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[16745, 499, 584, 24, 24, "IndentedText",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[17332, 525, 108, 1, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[17443, 528, 470, 19, 24, "IndentedText",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[17916, 549, 224, 7, 25, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[18143, 558, 121, 1, 26, "BulletedList",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[18267, 561, 373, 11, 44, "BulletedList",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[18643, 574, 678, 15, 80, "BulletedList",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[19324, 591, 409, 8, 56, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[19736, 601, 90, 1, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[19829, 604, 98, 1, 29, "Program",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[19930, 607, 119, 1, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20052, 610, 136, 4, 29, "Program",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20191, 616, 147, 4, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20341, 622, 281, 11, 149, "Program",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20625, 635, 109, 1, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20737, 638, 371, 8, 104, "Program",
      CellTags->{"XMLElement", "i:7", "b:0.2"}]},
  "i:7"->{
    Cell[16357, 487, 90, 1, 34, "Subsubsection",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[16450, 490, 292, 7, 41, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[16745, 499, 584, 24, 24, "IndentedText",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[17332, 525, 108, 1, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[17443, 528, 470, 19, 24, "IndentedText",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[17916, 549, 224, 7, 25, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[18143, 558, 121, 1, 26, "BulletedList",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[18267, 561, 373, 11, 44, "BulletedList",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[18643, 574, 678, 15, 80, "BulletedList",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[19324, 591, 409, 8, 56, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[19736, 601, 90, 1, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[19829, 604, 98, 1, 29, "Program",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[19930, 607, 119, 1, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20052, 610, 136, 4, 29, "Program",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20191, 616, 147, 4, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20341, 622, 281, 11, 149, "Program",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20625, 635, 109, 1, 24, "Text",
      CellTags->{"XMLElement", "i:7", "b:0.2"}],
    Cell[20737, 638, 371, 8, 104, "Program",
      CellTags->{"XMLElement", "i:7", "b:0.2"}]},
  "HandlingNamespaces"->{
    Cell[21145, 651, 96, 1, 34, "Subsubsection",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[21244, 654, 349, 6, 56, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[21596, 662, 105, 1, 34, "Subsubsubsection",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[21704, 665, 461, 10, 56, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[22168, 677, 222, 7, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[22393, 686, 201, 8, 104, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[22597, 696, 118, 1, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[22718, 699, 294, 7, 89, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23015, 708, 296, 9, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23314, 719, 200, 3, 23, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23517, 724, 107, 1, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23627, 727, 365, 10, 44, "BulletedList",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23995, 739, 308, 9, 44, "BulletedList",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[24306, 750, 257, 7, 40, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[24566, 759, 271, 11, 30, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[24840, 772, 375, 12, 40, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[25218, 786, 114, 1, 34, "Subsubsubsection",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[25335, 789, 250, 5, 40, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[25588, 796, 457, 12, 56, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[26048, 810, 428, 15, 209, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[26479, 827, 118, 1, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[26600, 830, 781, 15, 179, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[27384, 847, 104, 1, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[27491, 850, 494, 15, 62, "BulletedList",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[27988, 867, 656, 22, 62, "BulletedList",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}]},
  "i:8"->{
    Cell[21145, 651, 96, 1, 34, "Subsubsection",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[21244, 654, 349, 6, 56, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[21596, 662, 105, 1, 34, "Subsubsubsection",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[21704, 665, 461, 10, 56, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[22168, 677, 222, 7, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[22393, 686, 201, 8, 104, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[22597, 696, 118, 1, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[22718, 699, 294, 7, 89, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23015, 708, 296, 9, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23314, 719, 200, 3, 23, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23517, 724, 107, 1, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23627, 727, 365, 10, 44, "BulletedList",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[23995, 739, 308, 9, 44, "BulletedList",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[24306, 750, 257, 7, 40, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[24566, 759, 271, 11, 30, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[24840, 772, 375, 12, 40, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[25218, 786, 114, 1, 34, "Subsubsubsection",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[25335, 789, 250, 5, 40, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[25588, 796, 457, 12, 56, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[26048, 810, 428, 15, 209, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[26479, 827, 118, 1, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[26600, 830, 781, 15, 179, "Program",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[27384, 847, 104, 1, 24, "Text",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[27491, 850, 494, 15, 62, "BulletedList",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}],
    Cell[27988, 867, 656, 22, 62, "BulletedList",
      CellTags->{"HandlingNamespaces", "i:8", "b:0.2"}]},
  "XMLObject"->{
    Cell[28681, 894, 95, 1, 34, "Subsubsection",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[28779, 897, 988, 28, 89, "Text",
      CellTags->{"XMLObject", "i:9", "i:15", "b:0.2"}],
    Cell[29770, 927, 131, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[29904, 931, 127, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30034, 935, 128, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30165, 939, 127, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30295, 943, 141, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30439, 947, 132, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30574, 951, 83, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[30660, 954, 304, 7, 40, "Text",
      CellTags->{"XMLObject", "i:10", "i:19", "b:0.2"}],
    Cell[30967, 963, 218, 7, 30, "Program",
      CellTags->{"XMLObject", "i:16", "i:19", "b:0.2"}],
    Cell[31188, 972, 90, 1, 24, "Text",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[31281, 975, 393, 13, 26, "BulletedList",
      CellTags->{"XMLObject", "i:17", "i:19", "b:0.2"}],
    Cell[31677, 990, 430, 10, 62, "BulletedList",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32110, 1002, 94, 1, 24, "Text",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32207, 1005, 126, 2, 29, "Program",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32336, 1009, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32448, 1012, 185, 4, 29, "Program",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32636, 1018, 79, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[32718, 1021, 239, 8, 24, "Text",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[32960, 1031, 163, 6, 30, "Program",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33126, 1039, 97, 1, 24, "Text",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33226, 1042, 90, 1, 29, "Program",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33319, 1045, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33431, 1048, 109, 1, 29, "Program",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33543, 1051, 80, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[33626, 1054, 320, 10, 40, "Text",
      CellTags->{"XMLObject", "i:12", "i:20", "b:0.2"}],
    Cell[33949, 1066, 221, 9, 30, "Program",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34173, 1077, 323, 9, 40, "Text",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34499, 1088, 177, 4, 24, "Text",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34679, 1094, 129, 5, 59, "Program",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34811, 1101, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34923, 1104, 235, 5, 44, "Program",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[35161, 1111, 822, 23, 72, "Text",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[35986, 1136, 79, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36068, 1139, 246, 7, 40, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36317, 1148, 213, 9, 30, "Program",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36533, 1159, 92, 1, 24, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36628, 1162, 304, 9, 26, "BulletedList",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36935, 1173, 213, 6, 26, "BulletedList",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[37151, 1181, 250, 6, 44, "BulletedList",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[37404, 1189, 230, 5, 40, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[37637, 1196, 252, 7, 60, "Program",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[37892, 1205, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[38004, 1208, 324, 8, 45, "Program",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[38331, 1218, 296, 9, 24, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[38630, 1229, 93, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[38726, 1232, 259, 7, 40, "Text",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[38988, 1241, 209, 7, 30, "Program",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[39200, 1250, 278, 6, 40, "Text",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[39481, 1258, 120, 1, 29, "Program",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[39604, 1261, 268, 5, 40, "Text",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[39875, 1268, 179, 4, 44, "Program",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[40057, 1274, 84, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[40144, 1277, 820, 22, 88, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[40967, 1301, 145, 4, 24, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41115, 1307, 93, 1, 29, "Program",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41211, 1310, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41323, 1313, 114, 1, 29, "Program",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41440, 1316, 419, 11, 56, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41862, 1329, 273, 7, 24, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}]},
  "i:15"->{
    Cell[28681, 894, 95, 1, 34, "Subsubsection",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[28779, 897, 988, 28, 89, "Text",
      CellTags->{"XMLObject", "i:9", "i:15", "b:0.2"}],
    Cell[29770, 927, 131, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[29904, 931, 127, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30034, 935, 128, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30165, 939, 127, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30295, 943, 141, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}],
    Cell[30439, 947, 132, 2, 25, "BulletedList",
      CellTags->{"XMLObject", "i:15", "b:0.2"}]},
  "i:9"->{
    Cell[28779, 897, 988, 28, 89, "Text",
      CellTags->{"XMLObject", "i:9", "i:15", "b:0.2"}]},
  "i:19"->{
    Cell[30574, 951, 83, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[30660, 954, 304, 7, 40, "Text",
      CellTags->{"XMLObject", "i:10", "i:19", "b:0.2"}],
    Cell[30967, 963, 218, 7, 30, "Program",
      CellTags->{"XMLObject", "i:16", "i:19", "b:0.2"}],
    Cell[31188, 972, 90, 1, 24, "Text",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[31281, 975, 393, 13, 26, "BulletedList",
      CellTags->{"XMLObject", "i:17", "i:19", "b:0.2"}],
    Cell[31677, 990, 430, 10, 62, "BulletedList",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32110, 1002, 94, 1, 24, "Text",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32207, 1005, 126, 2, 29, "Program",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32336, 1009, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:19", "b:0.2"}],
    Cell[32448, 1012, 185, 4, 29, "Program",
      CellTags->{"XMLObject", "i:19", "b:0.2"}]},
  "i:10"->{
    Cell[30660, 954, 304, 7, 40, "Text",
      CellTags->{"XMLObject", "i:10", "i:19", "b:0.2"}]},
  "i:16"->{
    Cell[30967, 963, 218, 7, 30, "Program",
      CellTags->{"XMLObject", "i:16", "i:19", "b:0.2"}]},
  "i:17"->{
    Cell[31281, 975, 393, 13, 26, "BulletedList",
      CellTags->{"XMLObject", "i:17", "i:19", "b:0.2"}]},
  "i:11"->{
    Cell[32636, 1018, 79, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[32718, 1021, 239, 8, 24, "Text",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[32960, 1031, 163, 6, 30, "Program",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33126, 1039, 97, 1, 24, "Text",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33226, 1042, 90, 1, 29, "Program",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33319, 1045, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:11", "b:0.2"}],
    Cell[33431, 1048, 109, 1, 29, "Program",
      CellTags->{"XMLObject", "i:11", "b:0.2"}]},
  "i:20"->{
    Cell[33543, 1051, 80, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[33626, 1054, 320, 10, 40, "Text",
      CellTags->{"XMLObject", "i:12", "i:20", "b:0.2"}],
    Cell[33949, 1066, 221, 9, 30, "Program",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34173, 1077, 323, 9, 40, "Text",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34499, 1088, 177, 4, 24, "Text",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34679, 1094, 129, 5, 59, "Program",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34811, 1101, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[34923, 1104, 235, 5, 44, "Program",
      CellTags->{"XMLObject", "i:20", "b:0.2"}],
    Cell[35161, 1111, 822, 23, 72, "Text",
      CellTags->{"XMLObject", "i:20", "b:0.2"}]},
  "i:12"->{
    Cell[33626, 1054, 320, 10, 40, "Text",
      CellTags->{"XMLObject", "i:12", "i:20", "b:0.2"}]},
  "i:14"->{
    Cell[35986, 1136, 79, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36068, 1139, 246, 7, 40, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36317, 1148, 213, 9, 30, "Program",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36533, 1159, 92, 1, 24, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36628, 1162, 304, 9, 26, "BulletedList",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[36935, 1173, 213, 6, 26, "BulletedList",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[37151, 1181, 250, 6, 44, "BulletedList",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[37404, 1189, 230, 5, 40, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[37637, 1196, 252, 7, 60, "Program",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[37892, 1205, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[38004, 1208, 324, 8, 45, "Program",
      CellTags->{"XMLObject", "i:14", "b:0.2"}],
    Cell[38331, 1218, 296, 9, 24, "Text",
      CellTags->{"XMLObject", "i:14", "b:0.2"}]},
  "i:21"->{
    Cell[38630, 1229, 93, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[38726, 1232, 259, 7, 40, "Text",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[38988, 1241, 209, 7, 30, "Program",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[39200, 1250, 278, 6, 40, "Text",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[39481, 1258, 120, 1, 29, "Program",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[39604, 1261, 268, 5, 40, "Text",
      CellTags->{"XMLObject", "i:21", "b:0.2"}],
    Cell[39875, 1268, 179, 4, 44, "Program",
      CellTags->{"XMLObject", "i:21", "b:0.2"}]},
  "i:22"->{
    Cell[40057, 1274, 84, 1, 34, "Subsubsubsection",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[40144, 1277, 820, 22, 88, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[40967, 1301, 145, 4, 24, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41115, 1307, 93, 1, 29, "Program",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41211, 1310, 109, 1, 24, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41323, 1313, 114, 1, 29, "Program",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41440, 1316, 419, 11, 56, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}],
    Cell[41862, 1329, 273, 7, 24, "Text",
      CellTags->{"XMLObject", "i:22", "b:0.2"}]},
  "b:1.0"->{
    Cell[42280, 1348, 70, 1, 36, "Subsection",
      CellTags->"b:1.0"],
    Cell[42375, 1353, 102, 2, 33, "Subsubsection",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[42480, 1357, 290, 9, 24, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[42773, 1368, 243, 9, 41, "FramedBox",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[43019, 1379, 366, 15, 41, "FramedBox",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[43388, 1396, 612, 20, 56, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[44003, 1418, 671, 15, 72, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[44677, 1435, 340, 8, 40, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45020, 1445, 113, 1, 24, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45158, 1450, 117, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45278, 1455, 379, 18, 265, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45672, 1476, 242, 6, 20, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45939, 1486, 135, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[46077, 1491, 407, 9, 73, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[46499, 1503, 241, 7, 20, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[46765, 1514, 143, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[46911, 1519, 826, 17, 121, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[47752, 1539, 676, 18, 68, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[48431, 1559, 404, 13, 40, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[48860, 1576, 124, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[48987, 1581, 407, 9, 73, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[49409, 1593, 229, 7, 20, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[49663, 1604, 117, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[49783, 1609, 477, 15, 39, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[50275, 1627, 463, 11, 52, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[50775, 1643, 114, 2, 33, "Subsubsection",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[50892, 1647, 262, 7, 40, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[51157, 1656, 380, 15, 41, "FramedBox",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[51540, 1673, 459, 18, 40, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[52002, 1693, 437, 13, 40, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[52464, 1710, 195, 4, 42, "Input",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[52662, 1716, 262, 6, 41, "Output",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[52939, 1725, 656, 14, 84, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[53620, 1743, 185, 4, 26, "Input",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[53808, 1749, 233, 5, 41, "Output",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[54056, 1757, 374, 8, 36, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[54455, 1769, 193, 4, 42, "Input",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[54651, 1775, 294, 7, 41, "Output",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[54960, 1785, 532, 14, 52, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[55529, 1804, 102, 2, 33, "Subsubsection",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[55634, 1808, 897, 32, 56, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[56534, 1842, 181, 4, 24, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[56740, 1850, 209, 4, 42, "Input",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[56952, 1856, 1035, 23, 137, "Output",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[58002, 1882, 525, 15, 52, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[58530, 1899, 221, 6, 24, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[58754, 1907, 366, 14, 41, "FramedBox",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[59123, 1923, 516, 11, 56, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[59642, 1936, 645, 19, 56, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[60290, 1957, 878, 40, 41, "FramedBox",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[61171, 1999, 78, 1, 24, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[61252, 2002, 1113, 51, 41, "FramedBox",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[62368, 2055, 277, 8, 24, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[62682, 2068, 114, 2, 33, "Subsubsection",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[62799, 2072, 661, 24, 56, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[63485, 2100, 186, 4, 26, "Input",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[63674, 2106, 295, 7, 41, "Output",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[63984, 2116, 558, 16, 52, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[64545, 2134, 245, 7, 24, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[64793, 2143, 378, 14, 41, "FramedBox",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[65174, 2159, 523, 11, 56, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[65700, 2172, 369, 9, 40, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[66094, 2185, 238, 5, 42, "Input",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[66335, 2192, 207, 5, 41, "Output",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[66557, 2200, 643, 20, 52, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[67225, 2224, 285, 5, 58, "Input",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[67513, 2231, 525, 12, 89, "Output",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[68053, 2246, 680, 20, 52, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[68736, 2268, 960, 43, 41, "FramedBox",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[69699, 2313, 84, 1, 24, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[69786, 2316, 1077, 48, 57, "FramedBox",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[70866, 2366, 305, 9, 24, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}]},
  "UsingImport"->{
    Cell[42375, 1353, 102, 2, 33, "Subsubsection",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[42480, 1357, 290, 9, 24, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[42773, 1368, 243, 9, 41, "FramedBox",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[43019, 1379, 366, 15, 41, "FramedBox",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[43388, 1396, 612, 20, 56, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[44003, 1418, 671, 15, 72, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[44677, 1435, 340, 8, 40, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45020, 1445, 113, 1, 24, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45158, 1450, 117, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45278, 1455, 379, 18, 265, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45672, 1476, 242, 6, 20, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45939, 1486, 135, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[46077, 1491, 407, 9, 73, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[46499, 1503, 241, 7, 20, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[46765, 1514, 143, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[46911, 1519, 826, 17, 121, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[47752, 1539, 676, 18, 68, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[48431, 1559, 404, 13, 40, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[48860, 1576, 124, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[48987, 1581, 407, 9, 73, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[49409, 1593, 229, 7, 20, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[49663, 1604, 117, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[49783, 1609, 477, 15, 39, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[50275, 1627, 463, 11, 52, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}]},
  "i:23"->{
    Cell[42375, 1353, 102, 2, 33, "Subsubsection",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[42480, 1357, 290, 9, 24, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[42773, 1368, 243, 9, 41, "FramedBox",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[43019, 1379, 366, 15, 41, "FramedBox",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[43388, 1396, 612, 20, 56, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[44003, 1418, 671, 15, 72, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[44677, 1435, 340, 8, 40, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45020, 1445, 113, 1, 24, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45158, 1450, 117, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45278, 1455, 379, 18, 265, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45672, 1476, 242, 6, 20, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[45939, 1486, 135, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[46077, 1491, 407, 9, 73, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[46499, 1503, 241, 7, 20, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[46765, 1514, 143, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[46911, 1519, 826, 17, 121, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[47752, 1539, 676, 18, 68, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[48431, 1559, 404, 13, 40, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[48860, 1576, 124, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[48987, 1581, 407, 9, 73, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[49409, 1593, 229, 7, 20, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[49663, 1604, 117, 3, 26, "Input",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[49783, 1609, 477, 15, 39, "Output",
      CellTags->{"UsingImport", "i:23", "b:1.0"}],
    Cell[50275, 1627, 463, 11, 52, "Text",
      CellTags->{"UsingImport", "i:23", "b:1.0"}]},
  "UsingImportString"->{
    Cell[50775, 1643, 114, 2, 33, "Subsubsection",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[50892, 1647, 262, 7, 40, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[51157, 1656, 380, 15, 41, "FramedBox",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[51540, 1673, 459, 18, 40, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[52002, 1693, 437, 13, 40, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[52464, 1710, 195, 4, 42, "Input",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[52662, 1716, 262, 6, 41, "Output",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[52939, 1725, 656, 14, 84, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[53620, 1743, 185, 4, 26, "Input",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[53808, 1749, 233, 5, 41, "Output",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[54056, 1757, 374, 8, 36, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[54455, 1769, 193, 4, 42, "Input",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[54651, 1775, 294, 7, 41, "Output",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[54960, 1785, 532, 14, 52, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}]},
  "i:24"->{
    Cell[50775, 1643, 114, 2, 33, "Subsubsection",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[50892, 1647, 262, 7, 40, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[51157, 1656, 380, 15, 41, "FramedBox",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[51540, 1673, 459, 18, 40, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[52002, 1693, 437, 13, 40, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[52464, 1710, 195, 4, 42, "Input",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[52662, 1716, 262, 6, 41, "Output",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[52939, 1725, 656, 14, 84, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[53620, 1743, 185, 4, 26, "Input",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[53808, 1749, 233, 5, 41, "Output",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[54056, 1757, 374, 8, 36, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[54455, 1769, 193, 4, 42, "Input",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[54651, 1775, 294, 7, 41, "Output",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}],
    Cell[54960, 1785, 532, 14, 52, "Text",
      CellTags->{"UsingImportString", "i:24", "b:1.0"}]},
  "UsingXMLGet"->{
    Cell[55529, 1804, 102, 2, 33, "Subsubsection",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[55634, 1808, 897, 32, 56, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[56534, 1842, 181, 4, 24, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[56740, 1850, 209, 4, 42, "Input",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[56952, 1856, 1035, 23, 137, "Output",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[58002, 1882, 525, 15, 52, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[58530, 1899, 221, 6, 24, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[58754, 1907, 366, 14, 41, "FramedBox",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[59123, 1923, 516, 11, 56, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[59642, 1936, 645, 19, 56, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[60290, 1957, 878, 40, 41, "FramedBox",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[61171, 1999, 78, 1, 24, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[61252, 2002, 1113, 51, 41, "FramedBox",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[62368, 2055, 277, 8, 24, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}]},
  "i:25"->{
    Cell[55529, 1804, 102, 2, 33, "Subsubsection",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[55634, 1808, 897, 32, 56, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[56534, 1842, 181, 4, 24, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[56740, 1850, 209, 4, 42, "Input",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[56952, 1856, 1035, 23, 137, "Output",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[58002, 1882, 525, 15, 52, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[58530, 1899, 221, 6, 24, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[58754, 1907, 366, 14, 41, "FramedBox",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[59123, 1923, 516, 11, 56, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[59642, 1936, 645, 19, 56, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[60290, 1957, 878, 40, 41, "FramedBox",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[61171, 1999, 78, 1, 24, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[61252, 2002, 1113, 51, 41, "FramedBox",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}],
    Cell[62368, 2055, 277, 8, 24, "Text",
      CellTags->{"UsingXMLGet", "i:25", "b:1.0"}]},
  "UsingXMLGetString"->{
    Cell[62682, 2068, 114, 2, 33, "Subsubsection",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[62799, 2072, 661, 24, 56, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[63485, 2100, 186, 4, 26, "Input",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[63674, 2106, 295, 7, 41, "Output",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[63984, 2116, 558, 16, 52, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[64545, 2134, 245, 7, 24, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[64793, 2143, 378, 14, 41, "FramedBox",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[65174, 2159, 523, 11, 56, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[65700, 2172, 369, 9, 40, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[66094, 2185, 238, 5, 42, "Input",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[66335, 2192, 207, 5, 41, "Output",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[66557, 2200, 643, 20, 52, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[67225, 2224, 285, 5, 58, "Input",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[67513, 2231, 525, 12, 89, "Output",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[68053, 2246, 680, 20, 52, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[68736, 2268, 960, 43, 41, "FramedBox",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[69699, 2313, 84, 1, 24, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[69786, 2316, 1077, 48, 57, "FramedBox",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[70866, 2366, 305, 9, 24, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}]},
  "i:26"->{
    Cell[62682, 2068, 114, 2, 33, "Subsubsection",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[62799, 2072, 661, 24, 56, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[63485, 2100, 186, 4, 26, "Input",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[63674, 2106, 295, 7, 41, "Output",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[63984, 2116, 558, 16, 52, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[64545, 2134, 245, 7, 24, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[64793, 2143, 378, 14, 41, "FramedBox",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[65174, 2159, 523, 11, 56, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[65700, 2172, 369, 9, 40, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[66094, 2185, 238, 5, 42, "Input",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[66335, 2192, 207, 5, 41, "Output",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[66557, 2200, 643, 20, 52, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[67225, 2224, 285, 5, 58, "Input",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[67513, 2231, 525, 12, 89, "Output",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[68053, 2246, 680, 20, 52, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[68736, 2268, 960, 43, 41, "FramedBox",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[69699, 2313, 84, 1, 24, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[69786, 2316, 1077, 48, 57, "FramedBox",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}],
    Cell[70866, 2366, 305, 9, 24, "Text",
      CellTags->{"UsingXMLGetString", "i:26", "b:1.0"}]},
  "EntititiesValidation"->{
    Cell[71220, 2381, 100, 1, 36, "Subsection",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[71323, 2384, 436, 11, 56, "Text",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[71784, 2399, 324, 9, 122, "Input",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[72111, 2410, 749, 18, 89, "Output",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[72875, 2431, 202, 4, 24, "Text",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[73102, 2439, 248, 5, 58, "Input",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[73353, 2446, 388, 8, 57, "Output",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[73756, 2457, 637, 16, 72, "Text",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[74396, 2475, 416, 11, 40, "Text",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}]},
  "i:27"->{
    Cell[71220, 2381, 100, 1, 36, "Subsection",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[71323, 2384, 436, 11, 56, "Text",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[71784, 2399, 324, 9, 122, "Input",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[72111, 2410, 749, 18, 89, "Output",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[72875, 2431, 202, 4, 24, "Text",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[73102, 2439, 248, 5, 58, "Input",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[73353, 2446, 388, 8, 57, "Output",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[73756, 2457, 637, 16, 72, "Text",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[74396, 2475, 416, 11, 40, "Text",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}]},
  "b:1.1"->{
    Cell[71220, 2381, 100, 1, 36, "Subsection",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[71323, 2384, 436, 11, 56, "Text",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[71784, 2399, 324, 9, 122, "Input",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[72111, 2410, 749, 18, 89, "Output",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[72875, 2431, 202, 4, 24, "Text",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[73102, 2439, 248, 5, 58, "Input",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[73353, 2446, 388, 8, 57, "Output",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[73756, 2457, 637, 16, 72, "Text",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}],
    Cell[74396, 2475, 416, 11, 40, "Text",
      CellTags->{"EntititiesValidation", "i:27", "b:1.1"}]},
  "ConvOpt"->{
    Cell[74849, 2491, 74, 1, 36, "Subsection",
      CellTags->{"ConvOpt", "b:1.2"}]},
  "b:1.2"->{
    Cell[74849, 2491, 74, 1, 36, "Subsection",
      CellTags->{"ConvOpt", "b:1.2"}],
    Cell[74948, 2496, 90, 1, 34, "Subsubsection",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[75041, 2499, 394, 12, 40, "Text",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[75438, 2513, 603, 27, 24, "IndentedText",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76044, 2542, 329, 9, 40, "Text",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76376, 2553, 145, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76524, 2557, 146, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76673, 2561, 151, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76827, 2565, 133, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76963, 2569, 144, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[77110, 2573, 152, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[77265, 2577, 148, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[77416, 2581, 143, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[77562, 2585, 147, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[77746, 2592, 102, 1, 34, "Subsubsection",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[77851, 2595, 235, 5, 40, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[78089, 2602, 592, 17, 56, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[78684, 2621, 300, 10, 24, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[78987, 2633, 550, 14, 56, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[79540, 2649, 1425, 40, 118, "DefinitionBox3Col",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[80968, 2691, 132, 1, 15, "Caption",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[81103, 2694, 288, 9, 24, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[81416, 2707, 169, 3, 26, "Input",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[81588, 2712, 185, 4, 25, "Output",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[81788, 2719, 292, 9, 20, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[82105, 2732, 264, 5, 42, "Input",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[82372, 2739, 195, 4, 25, "Output",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[82582, 2746, 416, 12, 36, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[83035, 2763, 98, 1, 34, "Subsubsection",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],
    Cell[83136, 2766, 609, 18, 56, "Text",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],
    Cell[83748, 2786, 1124, 31, 80, "DefinitionBox3Col",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],
    Cell[84875, 2819, 128, 1, 15, "Caption",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],
    Cell[85006, 2822, 485, 16, 40, "Text",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],
    Cell[85528, 2843, 107, 1, 34, "Subsubsection",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[85638, 2846, 194, 4, 24, "Text",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[85835, 2852, 1543, 42, 136, "DefinitionBox3Col",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[87381, 2896, 147, 4, 15, "Caption",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[87531, 2902, 387, 10, 40, "Text",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[87943, 2916, 340, 9, 106, "Input",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[88286, 2927, 249, 5, 33, "Message",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[88538, 2934, 414, 7, 61, "Message",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[88955, 2943, 119, 3, 25, "Output",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[89089, 2949, 565, 18, 56, "Text",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[89679, 2971, 344, 9, 106, "Input",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[90026, 2982, 257, 5, 33, "Message",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[90286, 2989, 389, 8, 57, "Output",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[90690, 3000, 369, 13, 40, "Text",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[91084, 3017, 339, 9, 106, "Input",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[91426, 3028, 388, 8, 57, "Output",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[91863, 3042, 78, 1, 34, "Subsubsection",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[91944, 3045, 263, 5, 40, "Text",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[92210, 3052, 960, 27, 80, "DefinitionBox3Col",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[93173, 3081, 108, 1, 15, "Caption",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[93284, 3084, 574, 17, 56, "Text",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[93861, 3103, 625, 17, 72, "Text",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[94489, 3122, 357, 11, 40, "Text",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[94883, 3138, 90, 1, 34, "Subsubsection",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[94976, 3141, 149, 4, 24, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[95128, 3147, 1555, 40, 150, "DefinitionBox3Col",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[96686, 3189, 120, 1, 15, "Caption",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[96809, 3192, 635, 23, 40, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[97447, 3217, 369, 11, 40, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[97841, 3232, 251, 8, 106, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[98095, 3242, 251, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[98349, 3249, 227, 4, 19, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[98579, 3255, 251, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[98833, 3262, 270, 6, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[99106, 3270, 316, 10, 141, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[99437, 3283, 349, 11, 24, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[99811, 3298, 246, 7, 74, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[100060, 3307, 281, 8, 107, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[100356, 3318, 492, 16, 41, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[100873, 3338, 252, 8, 106, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[101128, 3348, 294, 9, 124, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[101459, 3362, 247, 7, 74, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[101709, 3371, 262, 8, 107, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[101986, 3382, 279, 9, 24, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[102290, 3395, 187, 4, 26, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[102480, 3401, 225, 4, 19, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[102708, 3407, 240, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[102951, 3414, 193, 4, 25, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[103159, 3421, 408, 11, 40, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[103592, 3436, 139, 3, 26, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[103734, 3441, 170, 4, 25, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[103919, 3448, 159, 4, 24, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[104103, 3456, 210, 6, 74, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[104316, 3464, 265, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[104584, 3471, 243, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[104830, 3478, 265, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[105098, 3485, 262, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[105363, 3492, 314, 10, 141, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[105692, 3505, 338, 9, 40, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[106067, 3519, 110, 1, 34, "Subsubsection",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[106180, 3522, 794, 19, 88, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[106977, 3543, 1075, 29, 98, "DefinitionBox3Col",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108055, 3574, 150, 4, 15, "Caption",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108208, 3580, 214, 5, 40, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108425, 3587, 253, 7, 90, "Input",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108681, 3596, 119, 1, 24, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108825, 3601, 155, 3, 26, "Input",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108983, 3606, 384, 8, 73, "Output",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[109382, 3617, 314, 10, 40, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[109721, 3631, 250, 5, 42, "Input",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[109974, 3638, 431, 9, 89, "Output",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[110420, 3650, 389, 11, 40, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[110834, 3665, 290, 5, 42, "Input",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[111127, 3672, 424, 10, 73, "Output",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[111600, 3688, 108, 1, 34, "Subsubsection",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[111711, 3691, 208, 4, 40, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[111922, 3697, 2096, 58, 180, "DefinitionBox3Col",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[114021, 3757, 140, 2, 15, "Caption",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[114164, 3761, 390, 10, 40, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[114557, 3773, 197, 7, 90, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[114757, 3782, 245, 6, 24, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[115027, 3792, 203, 4, 26, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[115233, 3798, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[115571, 3808, 483, 12, 56, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[116079, 3824, 208, 5, 26, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[116290, 3831, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[116628, 3841, 818, 26, 72, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[117471, 3871, 226, 5, 42, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[117700, 3878, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[118060, 3890, 212, 5, 42, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[118275, 3897, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[118635, 3909, 244, 5, 42, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[118882, 3916, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[119254, 3929, 98, 1, 34, "Subsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[119355, 3932, 139, 4, 24, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[119497, 3938, 2354, 65, 138, "DefinitionBox3Col",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[121854, 4005, 128, 1, 15, "Caption",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[121985, 4008, 179, 4, 24, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[122167, 4014, 314, 9, 119, "Program",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[122484, 4025, 353, 9, 122, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[122840, 4036, 110, 1, 33, "Subsubsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[122953, 4039, 585, 18, 56, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[123563, 4061, 189, 4, 26, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[123755, 4067, 941, 18, 153, "Output",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[124711, 4088, 111, 1, 33, "Subsubsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[124825, 4091, 659, 14, 72, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[125509, 4109, 190, 4, 26, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[125702, 4115, 523, 10, 73, "Output",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[126240, 4128, 115, 1, 33, "Subsubsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[126358, 4131, 659, 18, 72, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[127020, 4151, 557, 12, 72, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[127602, 4167, 144, 3, 26, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[127749, 4172, 850, 16, 137, "Output",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[128614, 4191, 114, 1, 33, "Subsubsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[128731, 4194, 651, 14, 72, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[129407, 4212, 199, 4, 26, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[129609, 4218, 553, 10, 73, "Output",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[130211, 4234, 98, 1, 34, "Subsubsection",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[130312, 4237, 747, 19, 72, "Text",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[131062, 4258, 1766, 47, 96, "DefinitionBox3Col",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[132831, 4307, 130, 2, 15, "Caption",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[132964, 4311, 197, 6, 24, "Text",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[133186, 4321, 180, 4, 26, "Input",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[133369, 4327, 193, 4, 25, "Output",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[133577, 4334, 253, 9, 24, "Text",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[133855, 4347, 270, 6, 42, "Input",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[134128, 4355, 246, 6, 41, "Output",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}]},
  "ImportConvOptIntro"->{
    Cell[74948, 2496, 90, 1, 34, "Subsubsection",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[75041, 2499, 394, 12, 40, "Text",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[75438, 2513, 603, 27, 24, "IndentedText",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76044, 2542, 329, 9, 40, "Text",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76376, 2553, 145, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76524, 2557, 146, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76673, 2561, 151, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76827, 2565, 133, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76963, 2569, 144, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[77110, 2573, 152, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[77265, 2577, 148, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[77416, 2581, 143, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[77562, 2585, 147, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}]},
  "i:28"->{
    Cell[74948, 2496, 90, 1, 34, "Subsubsection",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[75041, 2499, 394, 12, 40, "Text",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[75438, 2513, 603, 27, 24, "IndentedText",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76044, 2542, 329, 9, 40, "Text",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76376, 2553, 145, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76524, 2557, 146, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76673, 2561, 151, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76827, 2565, 133, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[76963, 2569, 144, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[77110, 2573, 152, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[77265, 2577, 148, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[77416, 2581, 143, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}],
    Cell[77562, 2585, 147, 2, 25, "BulletedList",
      CellTags->{"ImportConvOptIntro", "i:28", "b:1.2"}]},
  "NormalizeWhitespace"->{
    Cell[77746, 2592, 102, 1, 34, "Subsubsection",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[77851, 2595, 235, 5, 40, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[78089, 2602, 592, 17, 56, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[78684, 2621, 300, 10, 24, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[78987, 2633, 550, 14, 56, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[79540, 2649, 1425, 40, 118, "DefinitionBox3Col",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[80968, 2691, 132, 1, 15, "Caption",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[81103, 2694, 288, 9, 24, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[81416, 2707, 169, 3, 26, "Input",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[81588, 2712, 185, 4, 25, "Output",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[81788, 2719, 292, 9, 20, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[82105, 2732, 264, 5, 42, "Input",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[82372, 2739, 195, 4, 25, "Output",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[82582, 2746, 416, 12, 36, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}]},
  "i:29"->{
    Cell[77746, 2592, 102, 1, 34, "Subsubsection",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[77851, 2595, 235, 5, 40, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[78089, 2602, 592, 17, 56, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[78684, 2621, 300, 10, 24, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[78987, 2633, 550, 14, 56, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[79540, 2649, 1425, 40, 118, "DefinitionBox3Col",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[80968, 2691, 132, 1, 15, "Caption",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[81103, 2694, 288, 9, 24, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[81416, 2707, 169, 3, 26, "Input",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[81588, 2712, 185, 4, 25, "Output",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[81788, 2719, 292, 9, 20, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[82105, 2732, 264, 5, 42, "Input",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[82372, 2739, 195, 4, 25, "Output",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}],
    Cell[82582, 2746, 416, 12, 36, "Text",
      CellTags->{"NormalizeWhitespace", "i:29", "b:1.2"}]},
  "AllowRemoteDTD"->{
    Cell[83035, 2763, 98, 1, 34, "Subsubsection",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],
    Cell[83136, 2766, 609, 18, 56, "Text",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],
    Cell[83748, 2786, 1124, 31, 80, "DefinitionBox3Col",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],
    Cell[84875, 2819, 128, 1, 15, "Caption",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],
    Cell[85006, 2822, 485, 16, 40, "Text",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}]},
  "i:30"->{
    Cell[83035, 2763, 98, 1, 34, "Subsubsection",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],
    Cell[83136, 2766, 609, 18, 56, "Text",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],
    Cell[83748, 2786, 1124, 31, 80, "DefinitionBox3Col",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],
    Cell[84875, 2819, 128, 1, 15, "Caption",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}],
    Cell[85006, 2822, 485, 16, 40, "Text",
      CellTags->{"AllowRemoteDTD", "i:30", "b:1.2"}]},
  "AllowUnrecEntities"->{
    Cell[85528, 2843, 107, 1, 34, "Subsubsection",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[85638, 2846, 194, 4, 24, "Text",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[85835, 2852, 1543, 42, 136, "DefinitionBox3Col",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[87381, 2896, 147, 4, 15, "Caption",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[87531, 2902, 387, 10, 40, "Text",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[87943, 2916, 340, 9, 106, "Input",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[88286, 2927, 249, 5, 33, "Message",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[88538, 2934, 414, 7, 61, "Message",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[88955, 2943, 119, 3, 25, "Output",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[89089, 2949, 565, 18, 56, "Text",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[89679, 2971, 344, 9, 106, "Input",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[90026, 2982, 257, 5, 33, "Message",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[90286, 2989, 389, 8, 57, "Output",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[90690, 3000, 369, 13, 40, "Text",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[91084, 3017, 339, 9, 106, "Input",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[91426, 3028, 388, 8, 57, "Output",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}]},
  "i:31"->{
    Cell[85528, 2843, 107, 1, 34, "Subsubsection",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[85638, 2846, 194, 4, 24, "Text",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[85835, 2852, 1543, 42, 136, "DefinitionBox3Col",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[87381, 2896, 147, 4, 15, "Caption",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[87531, 2902, 387, 10, 40, "Text",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[87943, 2916, 340, 9, 106, "Input",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[88286, 2927, 249, 5, 33, "Message",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[88538, 2934, 414, 7, 61, "Message",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[88955, 2943, 119, 3, 25, "Output",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[89089, 2949, 565, 18, 56, "Text",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[89679, 2971, 344, 9, 106, "Input",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[90026, 2982, 257, 5, 33, "Message",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[90286, 2989, 389, 8, 57, "Output",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[90690, 3000, 369, 13, 40, "Text",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[91084, 3017, 339, 9, 106, "Input",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}],
    Cell[91426, 3028, 388, 8, 57, "Output",
      CellTags->{"AllowUnrecEntities", "i:31", "b:1.2"}]},
  "ReadDTD"->{
    Cell[91863, 3042, 78, 1, 34, "Subsubsection",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[91944, 3045, 263, 5, 40, "Text",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[92210, 3052, 960, 27, 80, "DefinitionBox3Col",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[93173, 3081, 108, 1, 15, "Caption",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[93284, 3084, 574, 17, 56, "Text",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[93861, 3103, 625, 17, 72, "Text",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[94489, 3122, 357, 11, 40, "Text",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}]},
  "i:32"->{
    Cell[91863, 3042, 78, 1, 34, "Subsubsection",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[91944, 3045, 263, 5, 40, "Text",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[92210, 3052, 960, 27, 80, "DefinitionBox3Col",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[93173, 3081, 108, 1, 15, "Caption",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[93284, 3084, 574, 17, 56, "Text",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[93861, 3103, 625, 17, 72, "Text",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}],
    Cell[94489, 3122, 357, 11, 40, "Text",
      CellTags->{"ReadDTD", "i:32", "b:1.2"}]},
  "Validate"->{
    Cell[94883, 3138, 90, 1, 34, "Subsubsection",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[94976, 3141, 149, 4, 24, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[95128, 3147, 1555, 40, 150, "DefinitionBox3Col",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[96686, 3189, 120, 1, 15, "Caption",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[96809, 3192, 635, 23, 40, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[97447, 3217, 369, 11, 40, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[97841, 3232, 251, 8, 106, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[98095, 3242, 251, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[98349, 3249, 227, 4, 19, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[98579, 3255, 251, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[98833, 3262, 270, 6, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[99106, 3270, 316, 10, 141, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[99437, 3283, 349, 11, 24, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[99811, 3298, 246, 7, 74, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[100060, 3307, 281, 8, 107, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[100356, 3318, 492, 16, 41, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[100873, 3338, 252, 8, 106, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[101128, 3348, 294, 9, 124, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[101459, 3362, 247, 7, 74, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[101709, 3371, 262, 8, 107, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[101986, 3382, 279, 9, 24, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[102290, 3395, 187, 4, 26, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[102480, 3401, 225, 4, 19, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[102708, 3407, 240, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[102951, 3414, 193, 4, 25, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[103159, 3421, 408, 11, 40, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[103592, 3436, 139, 3, 26, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[103734, 3441, 170, 4, 25, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[103919, 3448, 159, 4, 24, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[104103, 3456, 210, 6, 74, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[104316, 3464, 265, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[104584, 3471, 243, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[104830, 3478, 265, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[105098, 3485, 262, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[105363, 3492, 314, 10, 141, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[105692, 3505, 338, 9, 40, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}]},
  "i:33"->{
    Cell[94883, 3138, 90, 1, 34, "Subsubsection",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[94976, 3141, 149, 4, 24, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[95128, 3147, 1555, 40, 150, "DefinitionBox3Col",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[96686, 3189, 120, 1, 15, "Caption",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[96809, 3192, 635, 23, 40, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[97447, 3217, 369, 11, 40, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[97841, 3232, 251, 8, 106, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[98095, 3242, 251, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[98349, 3249, 227, 4, 19, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[98579, 3255, 251, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[98833, 3262, 270, 6, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[99106, 3270, 316, 10, 141, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[99437, 3283, 349, 11, 24, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[99811, 3298, 246, 7, 74, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[100060, 3307, 281, 8, 107, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[100356, 3318, 492, 16, 41, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[100873, 3338, 252, 8, 106, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[101128, 3348, 294, 9, 124, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[101459, 3362, 247, 7, 74, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[101709, 3371, 262, 8, 107, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[101986, 3382, 279, 9, 24, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[102290, 3395, 187, 4, 26, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[102480, 3401, 225, 4, 19, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[102708, 3407, 240, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[102951, 3414, 193, 4, 25, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[103159, 3421, 408, 11, 40, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[103592, 3436, 139, 3, 26, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[103734, 3441, 170, 4, 25, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[103919, 3448, 159, 4, 24, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[104103, 3456, 210, 6, 74, "Input",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[104316, 3464, 265, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[104584, 3471, 243, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[104830, 3478, 265, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[105098, 3485, 262, 5, 33, "Message",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[105363, 3492, 314, 10, 141, "Output",
      CellTags->{"Validate", "i:33", "b:1.2"}],
    Cell[105692, 3505, 338, 9, 40, "Text",
      CellTags->{"Validate", "i:33", "b:1.2"}]},
  "IncludeDefaultedAtts"->{
    Cell[106067, 3519, 110, 1, 34, "Subsubsection",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[106180, 3522, 794, 19, 88, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[106977, 3543, 1075, 29, 98, "DefinitionBox3Col",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108055, 3574, 150, 4, 15, "Caption",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108208, 3580, 214, 5, 40, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108425, 3587, 253, 7, 90, "Input",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108681, 3596, 119, 1, 24, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108825, 3601, 155, 3, 26, "Input",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108983, 3606, 384, 8, 73, "Output",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[109382, 3617, 314, 10, 40, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[109721, 3631, 250, 5, 42, "Input",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[109974, 3638, 431, 9, 89, "Output",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[110420, 3650, 389, 11, 40, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[110834, 3665, 290, 5, 42, "Input",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[111127, 3672, 424, 10, 73, "Output",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}]},
  "i:34"->{
    Cell[106067, 3519, 110, 1, 34, "Subsubsection",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[106180, 3522, 794, 19, 88, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[106977, 3543, 1075, 29, 98, "DefinitionBox3Col",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108055, 3574, 150, 4, 15, "Caption",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108208, 3580, 214, 5, 40, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108425, 3587, 253, 7, 90, "Input",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108681, 3596, 119, 1, 24, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108825, 3601, 155, 3, 26, "Input",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[108983, 3606, 384, 8, 73, "Output",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[109382, 3617, 314, 10, 40, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[109721, 3631, 250, 5, 42, "Input",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[109974, 3638, 431, 9, 89, "Output",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[110420, 3650, 389, 11, 40, "Text",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[110834, 3665, 290, 5, 42, "Input",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}],
    Cell[111127, 3672, 424, 10, 73, "Output",
      CellTags->{"IncludeDefaultedAtts", "i:34", "b:1.2"}]},
  "IncludeEmbeddedObjects"->{
    Cell[111600, 3688, 108, 1, 34, "Subsubsection",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[111711, 3691, 208, 4, 40, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[111922, 3697, 2096, 58, 180, "DefinitionBox3Col",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[114021, 3757, 140, 2, 15, "Caption",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[114164, 3761, 390, 10, 40, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[114557, 3773, 197, 7, 90, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[114757, 3782, 245, 6, 24, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[115027, 3792, 203, 4, 26, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[115233, 3798, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[115571, 3808, 483, 12, 56, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[116079, 3824, 208, 5, 26, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[116290, 3831, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[116628, 3841, 818, 26, 72, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[117471, 3871, 226, 5, 42, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[117700, 3878, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[118060, 3890, 212, 5, 42, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[118275, 3897, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[118635, 3909, 244, 5, 42, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[118882, 3916, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}]},
  "i:35"->{
    Cell[111600, 3688, 108, 1, 34, "Subsubsection",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[111711, 3691, 208, 4, 40, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[111922, 3697, 2096, 58, 180, "DefinitionBox3Col",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[114021, 3757, 140, 2, 15, "Caption",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[114164, 3761, 390, 10, 40, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[114557, 3773, 197, 7, 90, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[114757, 3782, 245, 6, 24, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[115027, 3792, 203, 4, 26, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[115233, 3798, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[115571, 3808, 483, 12, 56, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[116079, 3824, 208, 5, 26, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[116290, 3831, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[116628, 3841, 818, 26, 72, "Text",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[117471, 3871, 226, 5, 42, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[117700, 3878, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[118060, 3890, 212, 5, 42, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[118275, 3897, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[118635, 3909, 244, 5, 42, "Input",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}],
    Cell[118882, 3916, 323, 7, 57, "Output",
      CellTags->{"IncludeEmbeddedObjects", "i:35", "b:1.2"}]},
  "IncludeNamespaces"->{
    Cell[119254, 3929, 98, 1, 34, "Subsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[119355, 3932, 139, 4, 24, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[119497, 3938, 2354, 65, 138, "DefinitionBox3Col",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[121854, 4005, 128, 1, 15, "Caption",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[121985, 4008, 179, 4, 24, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[122167, 4014, 314, 9, 119, "Program",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[122484, 4025, 353, 9, 122, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[122840, 4036, 110, 1, 33, "Subsubsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[122953, 4039, 585, 18, 56, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[123563, 4061, 189, 4, 26, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[123755, 4067, 941, 18, 153, "Output",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[124711, 4088, 111, 1, 33, "Subsubsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[124825, 4091, 659, 14, 72, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[125509, 4109, 190, 4, 26, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[125702, 4115, 523, 10, 73, "Output",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[126240, 4128, 115, 1, 33, "Subsubsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[126358, 4131, 659, 18, 72, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[127020, 4151, 557, 12, 72, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[127602, 4167, 144, 3, 26, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[127749, 4172, 850, 16, 137, "Output",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[128614, 4191, 114, 1, 33, "Subsubsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[128731, 4194, 651, 14, 72, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[129407, 4212, 199, 4, 26, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[129609, 4218, 553, 10, 73, "Output",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}]},
  "i:36"->{
    Cell[119254, 3929, 98, 1, 34, "Subsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[119355, 3932, 139, 4, 24, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[119497, 3938, 2354, 65, 138, "DefinitionBox3Col",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[121854, 4005, 128, 1, 15, "Caption",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[121985, 4008, 179, 4, 24, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[122167, 4014, 314, 9, 119, "Program",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[122484, 4025, 353, 9, 122, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[122840, 4036, 110, 1, 33, "Subsubsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[122953, 4039, 585, 18, 56, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[123563, 4061, 189, 4, 26, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[123755, 4067, 941, 18, 153, "Output",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[124711, 4088, 111, 1, 33, "Subsubsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[124825, 4091, 659, 14, 72, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[125509, 4109, 190, 4, 26, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[125702, 4115, 523, 10, 73, "Output",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[126240, 4128, 115, 1, 33, "Subsubsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[126358, 4131, 659, 18, 72, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[127020, 4151, 557, 12, 72, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[127602, 4167, 144, 3, 26, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[127749, 4172, 850, 16, 137, "Output",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[128614, 4191, 114, 1, 33, "Subsubsubsection",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[128731, 4194, 651, 14, 72, "Text",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[129407, 4212, 199, 4, 26, "Input",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}],
    Cell[129609, 4218, 553, 10, 73, "Output",
      CellTags->{"IncludeNamespaces", "i:36", "b:1.2"}]},
  "PreserveCDATA"->{
    Cell[130211, 4234, 98, 1, 34, "Subsubsection",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[130312, 4237, 747, 19, 72, "Text",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[131062, 4258, 1766, 47, 96, "DefinitionBox3Col",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[132831, 4307, 130, 2, 15, "Caption",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[132964, 4311, 197, 6, 24, "Text",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[133186, 4321, 180, 4, 26, "Input",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[133369, 4327, 193, 4, 25, "Output",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[133577, 4334, 253, 9, 24, "Text",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[133855, 4347, 270, 6, 42, "Input",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[134128, 4355, 246, 6, 41, "Output",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}]},
  "i:37"->{
    Cell[130211, 4234, 98, 1, 34, "Subsubsection",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[130312, 4237, 747, 19, 72, "Text",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[131062, 4258, 1766, 47, 96, "DefinitionBox3Col",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[132831, 4307, 130, 2, 15, "Caption",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[132964, 4311, 197, 6, 24, "Text",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[133186, 4321, 180, 4, 26, "Input",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[133369, 4327, 193, 4, 25, "Output",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[133577, 4334, 253, 9, 24, "Text",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[133855, 4347, 270, 6, 42, "Input",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}],
    Cell[134128, 4355, 246, 6, 41, "Output",
      CellTags->{"PreserveCDATA", "i:37", "b:1.2"}]},
  "ManipulatingIntro"->{
    Cell[134534, 4374, 86, 1, 36, "Subsection",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[134623, 4377, 466, 11, 56, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[135092, 4390, 738, 18, 88, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[135833, 4410, 153, 4, 24, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[136011, 4418, 206, 5, 42, "Input",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[136220, 4425, 358, 8, 57, "Output",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[136593, 4436, 217, 5, 20, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[136835, 4445, 178, 4, 26, "Input",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[137016, 4451, 293, 7, 41, "Output",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[137324, 4461, 245, 7, 20, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[137594, 4472, 141, 3, 26, "Input",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[137738, 4477, 161, 3, 89, "Output",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}]},
  "i:38"->{
    Cell[134534, 4374, 86, 1, 36, "Subsection",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[134623, 4377, 466, 11, 56, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[135092, 4390, 738, 18, 88, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[135833, 4410, 153, 4, 24, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[136011, 4418, 206, 5, 42, "Input",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[136220, 4425, 358, 8, 57, "Output",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[136593, 4436, 217, 5, 20, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[136835, 4445, 178, 4, 26, "Input",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[137016, 4451, 293, 7, 41, "Output",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[137324, 4461, 245, 7, 20, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[137594, 4472, 141, 3, 26, "Input",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[137738, 4477, 161, 3, 89, "Output",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}]},
  "b:2.0"->{
    Cell[134534, 4374, 86, 1, 36, "Subsection",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[134623, 4377, 466, 11, 56, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[135092, 4390, 738, 18, 88, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[135833, 4410, 153, 4, 24, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[136011, 4418, 206, 5, 42, "Input",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[136220, 4425, 358, 8, 57, "Output",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[136593, 4436, 217, 5, 20, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[136835, 4445, 178, 4, 26, "Input",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[137016, 4451, 293, 7, 41, "Output",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[137324, 4461, 245, 7, 20, "Text",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[137594, 4472, 141, 3, 26, "Input",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}],
    Cell[137738, 4477, 161, 3, 89, "Output",
      CellTags->{"ManipulatingIntro", "i:38", "b:2.0"}]},
  "ManipulatingExample1"->{
    Cell[137948, 4486, 101, 1, 36, "Subsection",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[138052, 4489, 364, 8, 40, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[138419, 4499, 649, 18, 72, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[139071, 4519, 790, 14, 154, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[139864, 4535, 381, 10, 40, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[140248, 4547, 815, 25, 72, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[141066, 4574, 597, 13, 72, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[141666, 4589, 594, 11, 106, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[142263, 4602, 499, 10, 90, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[142765, 4614, 426, 12, 40, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[143194, 4628, 340, 7, 58, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[143537, 4637, 184, 4, 24, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[143746, 4645, 200, 5, 46, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[143949, 4652, 1421, 27, 169, "Output",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[145407, 4684, 222, 4, 38, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[145632, 4690, 291, 7, 25, "Output",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[145938, 4700, 520, 14, 52, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}]},
  "i:39"->{
    Cell[137948, 4486, 101, 1, 36, "Subsection",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[138052, 4489, 364, 8, 40, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[138419, 4499, 649, 18, 72, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[139071, 4519, 790, 14, 154, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[139864, 4535, 381, 10, 40, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[140248, 4547, 815, 25, 72, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[141066, 4574, 597, 13, 72, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[141666, 4589, 594, 11, 106, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[142263, 4602, 499, 10, 90, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[142765, 4614, 426, 12, 40, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[143194, 4628, 340, 7, 58, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[143537, 4637, 184, 4, 24, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[143746, 4645, 200, 5, 46, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[143949, 4652, 1421, 27, 169, "Output",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[145407, 4684, 222, 4, 38, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[145632, 4690, 291, 7, 25, "Output",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[145938, 4700, 520, 14, 52, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}]},
  "b:2.1"->{
    Cell[137948, 4486, 101, 1, 36, "Subsection",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[138052, 4489, 364, 8, 40, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[138419, 4499, 649, 18, 72, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[139071, 4519, 790, 14, 154, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[139864, 4535, 381, 10, 40, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[140248, 4547, 815, 25, 72, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[141066, 4574, 597, 13, 72, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[141666, 4589, 594, 11, 106, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[142263, 4602, 499, 10, 90, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[142765, 4614, 426, 12, 40, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[143194, 4628, 340, 7, 58, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[143537, 4637, 184, 4, 24, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[143746, 4645, 200, 5, 46, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[143949, 4652, 1421, 27, 169, "Output",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[145407, 4684, 222, 4, 38, "Input",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[145632, 4690, 291, 7, 25, "Output",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}],
    Cell[145938, 4700, 520, 14, 52, "Text",
      CellTags->{"ManipulatingExample1", "i:39", "b:2.1"}]},
  "ManipulatingExample2"->{
    Cell[146495, 4719, 98, 1, 36, "Subsection",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[146596, 4722, 359, 6, 56, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[146958, 4730, 473, 10, 56, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[147434, 4742, 150, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[147587, 4747, 249, 8, 24, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[147839, 4757, 205, 5, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[148069, 4766, 128, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[148200, 4771, 117, 3, 25, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[148332, 4777, 582, 13, 68, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[148917, 4792, 294, 6, 58, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[149236, 4802, 128, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[149367, 4807, 116, 3, 25, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[149498, 4813, 423, 12, 36, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[149946, 4829, 127, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[150076, 4834, 1739, 28, 313, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[151830, 4865, 429, 10, 56, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[152284, 4879, 234, 6, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[152521, 4887, 131, 3, 25, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[152667, 4893, 243, 9, 20, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[152935, 4906, 268, 5, 74, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[153206, 4913, 499, 8, 89, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[153720, 4924, 262, 9, 20, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[154007, 4937, 281, 6, 58, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[154291, 4945, 499, 8, 89, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[154805, 4956, 615, 14, 68, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[155423, 4972, 151, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[155577, 4977, 235, 4, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[155815, 4983, 144, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[155962, 4988, 241, 5, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[156206, 4995, 269, 7, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[156478, 5004, 292, 6, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[156795, 5014, 135, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[156933, 5019, 1084, 18, 121, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[158032, 5040, 469, 15, 36, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[158504, 5057, 561, 10, 73, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[159068, 5069, 280, 6, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[159351, 5077, 263, 5, 40, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[159617, 5084, 401, 7, 90, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[160043, 5095, 212, 5, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[160258, 5102, 807, 20, 179, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161080, 5125, 218, 5, 36, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161301, 5132, 160, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161464, 5137, 279, 6, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161768, 5147, 214, 5, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161985, 5154, 812, 20, 179, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}]},
  "i:40"->{
    Cell[146495, 4719, 98, 1, 36, "Subsection",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[146596, 4722, 359, 6, 56, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[146958, 4730, 473, 10, 56, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[147434, 4742, 150, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[147587, 4747, 249, 8, 24, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[147839, 4757, 205, 5, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[148069, 4766, 128, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[148200, 4771, 117, 3, 25, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[148332, 4777, 582, 13, 68, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[148917, 4792, 294, 6, 58, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[149236, 4802, 128, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[149367, 4807, 116, 3, 25, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[149498, 4813, 423, 12, 36, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[149946, 4829, 127, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[150076, 4834, 1739, 28, 313, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[151830, 4865, 429, 10, 56, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[152284, 4879, 234, 6, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[152521, 4887, 131, 3, 25, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[152667, 4893, 243, 9, 20, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[152935, 4906, 268, 5, 74, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[153206, 4913, 499, 8, 89, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[153720, 4924, 262, 9, 20, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[154007, 4937, 281, 6, 58, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[154291, 4945, 499, 8, 89, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[154805, 4956, 615, 14, 68, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[155423, 4972, 151, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[155577, 4977, 235, 4, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[155815, 4983, 144, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[155962, 4988, 241, 5, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[156206, 4995, 269, 7, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[156478, 5004, 292, 6, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[156795, 5014, 135, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[156933, 5019, 1084, 18, 121, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[158032, 5040, 469, 15, 36, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[158504, 5057, 561, 10, 73, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[159068, 5069, 280, 6, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[159351, 5077, 263, 5, 40, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[159617, 5084, 401, 7, 90, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[160043, 5095, 212, 5, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[160258, 5102, 807, 20, 179, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161080, 5125, 218, 5, 36, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161301, 5132, 160, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161464, 5137, 279, 6, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161768, 5147, 214, 5, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161985, 5154, 812, 20, 179, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}]},
  "b:2.2"->{
    Cell[146495, 4719, 98, 1, 36, "Subsection",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[146596, 4722, 359, 6, 56, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[146958, 4730, 473, 10, 56, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[147434, 4742, 150, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[147587, 4747, 249, 8, 24, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[147839, 4757, 205, 5, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[148069, 4766, 128, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[148200, 4771, 117, 3, 25, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[148332, 4777, 582, 13, 68, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[148917, 4792, 294, 6, 58, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[149236, 4802, 128, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[149367, 4807, 116, 3, 25, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[149498, 4813, 423, 12, 36, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[149946, 4829, 127, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[150076, 4834, 1739, 28, 313, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[151830, 4865, 429, 10, 56, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[152284, 4879, 234, 6, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[152521, 4887, 131, 3, 25, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[152667, 4893, 243, 9, 20, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[152935, 4906, 268, 5, 74, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[153206, 4913, 499, 8, 89, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[153720, 4924, 262, 9, 20, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[154007, 4937, 281, 6, 58, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[154291, 4945, 499, 8, 89, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[154805, 4956, 615, 14, 68, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[155423, 4972, 151, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[155577, 4977, 235, 4, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[155815, 4983, 144, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[155962, 4988, 241, 5, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[156206, 4995, 269, 7, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[156478, 5004, 292, 6, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[156795, 5014, 135, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[156933, 5019, 1084, 18, 121, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[158032, 5040, 469, 15, 36, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[158504, 5057, 561, 10, 73, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[159068, 5069, 280, 6, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[159351, 5077, 263, 5, 40, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[159617, 5084, 401, 7, 90, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[160043, 5095, 212, 5, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[160258, 5102, 807, 20, 179, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161080, 5125, 218, 5, 36, "Text",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161301, 5132, 160, 3, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161464, 5137, 279, 6, 42, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161768, 5147, 214, 5, 26, "Input",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}],
    Cell[161985, 5154, 812, 20, 179, "Output",
      CellTags->{"ManipulatingExample2", "i:40", "b:2.2"}]},
  "ManipulatingExample3"->{
    Cell[162846, 5180, 89, 1, 36, "Subsection",
      CellTags->{"ManipulatingExample3", "b:2.3"}],
    Cell[162960, 5185, 118, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[163081, 5188, 698, 17, 72, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[163782, 5207, 166, 4, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[163973, 5215, 152, 4, 26, "Input",
      Evaluatable->False,
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[164128, 5221, 1577, 43, 690, "Output",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[165720, 5267, 215, 6, 20, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[165938, 5275, 153, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[166094, 5280, 325, 9, 40, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[166422, 5291, 132, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[166557, 5296, 486, 13, 56, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[167046, 5311, 1195, 21, 250, "Input",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[168244, 5334, 201, 4, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[168470, 5342, 144, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[168617, 5347, 61603, 1789, 258, 52315, 1669, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[230223, 7138, 212, 5, 25, "Output",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[230450, 7146, 297, 7, 36, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[230784, 7158, 102, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[230889, 7161, 844, 23, 88, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[231736, 7186, 229, 6, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[231990, 7196, 250, 5, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[232243, 7203, 264, 6, 25, "Output",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[232522, 7212, 678, 21, 52, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[233203, 7235, 366, 7, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[233572, 7244, 927, 27, 88, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[234524, 7275, 254, 5, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[234781, 7282, 1319, 28, 153, "Output",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[236115, 7313, 772, 21, 68, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[236890, 7336, 484, 18, 40, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[237377, 7356, 306, 10, 40, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[237686, 7368, 367, 7, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[238056, 7377, 335, 6, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[238394, 7385, 341, 6, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[238738, 7393, 1174, 37, 88, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[239915, 7432, 507, 16, 40, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[240425, 7450, 408, 7, 90, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[240836, 7459, 802, 29, 56, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[241641, 7490, 196, 4, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[241840, 7496, 187, 4, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[242030, 7502, 241, 5, 42, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[242274, 7509, 147, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[242424, 7514, 199, 6, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[242626, 7522, 1195, 21, 250, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[243824, 7545, 918, 38, 56, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[244745, 7585, 673, 23, 56, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[245421, 7610, 206, 5, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[245652, 7619, 291, 6, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[245946, 7627, 601, 11, 121, "Output",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[246562, 7641, 1003, 31, 84, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[247568, 7674, 1217, 45, 72, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[248788, 7721, 189, 4, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[248980, 7727, 301, 6, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[249284, 7735, 166, 4, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[249475, 7743, 144, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[249622, 7748, 62786, 1804, 294, 52315, 1669, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[312411, 9554, 212, 5, 25, "Output",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}]},
  "b:2.3"->{
    Cell[162846, 5180, 89, 1, 36, "Subsection",
      CellTags->{"ManipulatingExample3", "b:2.3"}],
    Cell[162960, 5185, 118, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[163081, 5188, 698, 17, 72, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[163782, 5207, 166, 4, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[163973, 5215, 152, 4, 26, "Input",
      Evaluatable->False,
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[164128, 5221, 1577, 43, 690, "Output",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[165720, 5267, 215, 6, 20, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[165938, 5275, 153, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[166094, 5280, 325, 9, 40, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[166422, 5291, 132, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[166557, 5296, 486, 13, 56, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[167046, 5311, 1195, 21, 250, "Input",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[168244, 5334, 201, 4, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[168470, 5342, 144, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[168617, 5347, 61603, 1789, 258, 52315, 1669, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[230223, 7138, 212, 5, 25, "Output",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[230450, 7146, 297, 7, 36, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[230784, 7158, 102, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[230889, 7161, 844, 23, 88, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[231736, 7186, 229, 6, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[231990, 7196, 250, 5, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[232243, 7203, 264, 6, 25, "Output",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[232522, 7212, 678, 21, 52, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[233203, 7235, 366, 7, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[233572, 7244, 927, 27, 88, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[234524, 7275, 254, 5, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[234781, 7282, 1319, 28, 153, "Output",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[236115, 7313, 772, 21, 68, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[236890, 7336, 484, 18, 40, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[237377, 7356, 306, 10, 40, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[237686, 7368, 367, 7, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[238056, 7377, 335, 6, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[238394, 7385, 341, 6, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[238738, 7393, 1174, 37, 88, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[239915, 7432, 507, 16, 40, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[240425, 7450, 408, 7, 90, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[240836, 7459, 802, 29, 56, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[241641, 7490, 196, 4, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[241840, 7496, 187, 4, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[242030, 7502, 241, 5, 42, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[242274, 7509, 147, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[242424, 7514, 199, 6, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[242626, 7522, 1195, 21, 250, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[243824, 7545, 918, 38, 56, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[244745, 7585, 673, 23, 56, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[245421, 7610, 206, 5, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[245652, 7619, 291, 6, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[245946, 7627, 601, 11, 121, "Output",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[246562, 7641, 1003, 31, 84, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[247568, 7674, 1217, 45, 72, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[248788, 7721, 189, 4, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[248980, 7727, 301, 6, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[249284, 7735, 166, 4, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[249475, 7743, 144, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[249622, 7748, 62786, 1804, 294, 52315, 1669, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[312411, 9554, 212, 5, 25, "Output",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}]},
  "i:41"->{
    Cell[162960, 5185, 118, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[163081, 5188, 698, 17, 72, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[163782, 5207, 166, 4, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[163973, 5215, 152, 4, 26, "Input",
      Evaluatable->False,
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[164128, 5221, 1577, 43, 690, "Output",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[165720, 5267, 215, 6, 20, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[165938, 5275, 153, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[166094, 5280, 325, 9, 40, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[166422, 5291, 132, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[166557, 5296, 486, 13, 56, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[167046, 5311, 1195, 21, 250, "Input",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[168244, 5334, 201, 4, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[168470, 5342, 144, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[168617, 5347, 61603, 1789, 258, 52315, 1669, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[230223, 7138, 212, 5, 25, "Output",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}],
    Cell[230450, 7146, 297, 7, 36, "Text",
      CellTags->{"ManipulatingExample3", "i:41", "b:2.3"}]},
  "i:42"->{
    Cell[230784, 7158, 102, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[230889, 7161, 844, 23, 88, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[231736, 7186, 229, 6, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[231990, 7196, 250, 5, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[232243, 7203, 264, 6, 25, "Output",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[232522, 7212, 678, 21, 52, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[233203, 7235, 366, 7, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[233572, 7244, 927, 27, 88, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[234524, 7275, 254, 5, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[234781, 7282, 1319, 28, 153, "Output",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[236115, 7313, 772, 21, 68, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[236890, 7336, 484, 18, 40, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[237377, 7356, 306, 10, 40, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[237686, 7368, 367, 7, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[238056, 7377, 335, 6, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[238394, 7385, 341, 6, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[238738, 7393, 1174, 37, 88, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[239915, 7432, 507, 16, 40, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[240425, 7450, 408, 7, 90, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[240836, 7459, 802, 29, 56, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[241641, 7490, 196, 4, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[241840, 7496, 187, 4, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[242030, 7502, 241, 5, 42, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[242274, 7509, 147, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[242424, 7514, 199, 6, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[242626, 7522, 1195, 21, 250, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[243824, 7545, 918, 38, 56, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[244745, 7585, 673, 23, 56, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[245421, 7610, 206, 5, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[245652, 7619, 291, 6, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[245946, 7627, 601, 11, 121, "Output",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[246562, 7641, 1003, 31, 84, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[247568, 7674, 1217, 45, 72, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[248788, 7721, 189, 4, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[248980, 7727, 301, 6, 58, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[249284, 7735, 166, 4, 24, "Text",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[249475, 7743, 144, 3, 26, "Input",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[249622, 7748, 62786, 1804, 294, 52315, 1669, "GraphicsData", 
    "PostScript", "Graphics",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}],
    Cell[312411, 9554, 212, 5, 25, "Output",
      CellTags->{"ManipulatingExample3", "i:42", "b:2.3"}]},
  "ManipulatingExample4"->{
    Cell[312684, 9566, 171, 6, 36, "Subsection",
      CellTags->{"ManipulatingExample4", "i:43", "b:2.4"}],
    Cell[312858, 9574, 672, 13, 88, "Text",
      CellTags->{"ManipulatingExample4", "i:43", "b:2.4"}],
    Cell[313555, 9591, 89, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample4", "b:2.4"}],
    Cell[313647, 9594, 474, 11, 56, "Text",
      CellTags->{"ManipulatingExample4", "b:2.4"}],
    Cell[314124, 9607, 184, 7, 89, "Program",
      CellTags->{"ManipulatingExample4", "b:2.4"}],
    Cell[314311, 9616, 183, 6, 24, "Text",
      CellTags->{"ManipulatingExample4", "b:2.4"}],
    Cell[314497, 9624, 253, 6, 42, "Input",
      CellTags->{"ManipulatingExample4", "b:2.4"}],
    Cell[314753, 9632, 253, 6, 42, "Input",
      CellTags->{"ManipulatingExample4", "b:2.4"}],
    Cell[315043, 9643, 106, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[315152, 9646, 634, 15, 72, "Text",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[315789, 9663, 246, 8, 104, "Program",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[316038, 9673, 444, 15, 40, "Text",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[316485, 9690, 466, 9, 74, "Input",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[316988, 9704, 96, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[317087, 9707, 670, 21, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[317760, 9730, 670, 21, 299, "Program",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[318433, 9753, 911, 30, 72, "Text",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[319347, 9785, 1155, 21, 218, "Input",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[320527, 9810, 151, 3, 26, "Input",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[320681, 9815, 120, 3, 25, "Output",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[320850, 9824, 98, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[320951, 9827, 455, 9, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[321409, 9838, 530, 10, 72, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[321942, 9850, 423, 7, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[322368, 9859, 386, 9, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[322779, 9872, 402, 13, 186, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[323184, 9887, 635, 14, 89, "Output",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[323834, 9904, 385, 9, 36, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[324222, 9915, 270, 8, 104, "Program",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[324495, 9925, 564, 14, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[325084, 9943, 145, 3, 26, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[325232, 9948, 166, 3, 25, "Output",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[325413, 9954, 685, 19, 52, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326101, 9975, 306, 6, 74, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326432, 9985, 201, 4, 42, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326636, 9991, 118, 3, 25, "Output",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326769, 9997, 196, 6, 20, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326968, 10005, 124, 3, 26, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[327095, 10010, 587, 12, 106, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[327707, 10026, 157, 3, 26, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[327867, 10031, 141, 3, 25, "Output",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}]},
  "i:43"->{
    Cell[312684, 9566, 171, 6, 36, "Subsection",
      CellTags->{"ManipulatingExample4", "i:43", "b:2.4"}],
    Cell[312858, 9574, 672, 13, 88, "Text",
      CellTags->{"ManipulatingExample4", "i:43", "b:2.4"}]},
  "b:2.4"->{
    Cell[312684, 9566, 171, 6, 36, "Subsection",
      CellTags->{"ManipulatingExample4", "i:43", "b:2.4"}],
    Cell[312858, 9574, 672, 13, 88, "Text",
      CellTags->{"ManipulatingExample4", "i:43", "b:2.4"}],
    Cell[313555, 9591, 89, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample4", "b:2.4"}],
    Cell[313647, 9594, 474, 11, 56, "Text",
      CellTags->{"ManipulatingExample4", "b:2.4"}],
    Cell[314124, 9607, 184, 7, 89, "Program",
      CellTags->{"ManipulatingExample4", "b:2.4"}],
    Cell[314311, 9616, 183, 6, 24, "Text",
      CellTags->{"ManipulatingExample4", "b:2.4"}],
    Cell[314497, 9624, 253, 6, 42, "Input",
      CellTags->{"ManipulatingExample4", "b:2.4"}],
    Cell[314753, 9632, 253, 6, 42, "Input",
      CellTags->{"ManipulatingExample4", "b:2.4"}],
    Cell[315043, 9643, 106, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[315152, 9646, 634, 15, 72, "Text",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[315789, 9663, 246, 8, 104, "Program",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[316038, 9673, 444, 15, 40, "Text",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[316485, 9690, 466, 9, 74, "Input",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[316988, 9704, 96, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[317087, 9707, 670, 21, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[317760, 9730, 670, 21, 299, "Program",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[318433, 9753, 911, 30, 72, "Text",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[319347, 9785, 1155, 21, 218, "Input",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[320527, 9810, 151, 3, 26, "Input",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[320681, 9815, 120, 3, 25, "Output",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[320850, 9824, 98, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[320951, 9827, 455, 9, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[321409, 9838, 530, 10, 72, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[321942, 9850, 423, 7, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[322368, 9859, 386, 9, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[322779, 9872, 402, 13, 186, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[323184, 9887, 635, 14, 89, "Output",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[323834, 9904, 385, 9, 36, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[324222, 9915, 270, 8, 104, "Program",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[324495, 9925, 564, 14, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[325084, 9943, 145, 3, 26, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[325232, 9948, 166, 3, 25, "Output",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[325413, 9954, 685, 19, 52, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326101, 9975, 306, 6, 74, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326432, 9985, 201, 4, 42, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326636, 9991, 118, 3, 25, "Output",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326769, 9997, 196, 6, 20, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326968, 10005, 124, 3, 26, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[327095, 10010, 587, 12, 106, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[327707, 10026, 157, 3, 26, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[327867, 10031, 141, 3, 25, "Output",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}]},
  "i:44"->{
    Cell[315043, 9643, 106, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[315152, 9646, 634, 15, 72, "Text",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[315789, 9663, 246, 8, 104, "Program",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[316038, 9673, 444, 15, 40, "Text",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}],
    Cell[316485, 9690, 466, 9, 74, "Input",
      CellTags->{"ManipulatingExample4", "i:44", "b:2.4"}]},
  "i:45"->{
    Cell[316988, 9704, 96, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[317087, 9707, 670, 21, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[317760, 9730, 670, 21, 299, "Program",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[318433, 9753, 911, 30, 72, "Text",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[319347, 9785, 1155, 21, 218, "Input",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[320527, 9810, 151, 3, 26, "Input",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}],
    Cell[320681, 9815, 120, 3, 25, "Output",
      CellTags->{"ManipulatingExample4", "i:45", "b:2.4"}]},
  "i:46"->{
    Cell[320850, 9824, 98, 1, 34, "Subsubsection",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[320951, 9827, 455, 9, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[321409, 9838, 530, 10, 72, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[321942, 9850, 423, 7, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[322368, 9859, 386, 9, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[322779, 9872, 402, 13, 186, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[323184, 9887, 635, 14, 89, "Output",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[323834, 9904, 385, 9, 36, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[324222, 9915, 270, 8, 104, "Program",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[324495, 9925, 564, 14, 56, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[325084, 9943, 145, 3, 26, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[325232, 9948, 166, 3, 25, "Output",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[325413, 9954, 685, 19, 52, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326101, 9975, 306, 6, 74, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326432, 9985, 201, 4, 42, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326636, 9991, 118, 3, 25, "Output",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326769, 9997, 196, 6, 20, "Text",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[326968, 10005, 124, 3, 26, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[327095, 10010, 587, 12, 106, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[327707, 10026, 157, 3, 26, "Input",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}],
    Cell[327867, 10031, 141, 3, 25, "Output",
      CellTags->{"ManipulatingExample4", "i:46", "b:2.4"}]},
  "ManipulatingExample5"->{
    Cell[328069, 10041, 106, 1, 36, "Subsection",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[328178, 10044, 1016, 22, 104, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[329197, 10068, 287, 6, 38, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[329487, 10076, 202, 5, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[329714, 10085, 135, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[329852, 10090, 1252, 21, 345, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[331119, 10114, 615, 11, 67, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[331737, 10127, 134, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[331874, 10132, 124, 2, 28, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332001, 10136, 424, 10, 39, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332428, 10148, 116, 1, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332547, 10151, 263, 5, 42, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332813, 10158, 118, 2, 24, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332934, 10162, 376, 9, 41, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[333313, 10173, 287, 9, 25, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[333603, 10184, 271, 9, 26, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[333877, 10195, 202, 5, 25, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334082, 10202, 146, 4, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334231, 10208, 158, 4, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334392, 10214, 220, 4, 42, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334615, 10220, 198, 5, 24, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334816, 10227, 320, 6, 42, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[335139, 10235, 575, 16, 56, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[335717, 10253, 279, 7, 79, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[335999, 10262, 305, 6, 36, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[336307, 10270, 156, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[336466, 10275, 115, 1, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[336584, 10278, 363, 6, 74, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[336950, 10286, 97, 1, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[337072, 10291, 137, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[337212, 10296, 875, 17, 153, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[338102, 10316, 214, 6, 21, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[338341, 10326, 144, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[338488, 10331, 623, 9, 201, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339126, 10343, 114, 1, 18, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339265, 10348, 138, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339406, 10353, 116, 3, 27, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339537, 10359, 180, 4, 18, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339742, 10367, 157, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339902, 10372, 127, 3, 27, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[340044, 10378, 246, 7, 21, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[340315, 10389, 1130, 21, 234, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[341448, 10412, 875, 17, 179, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342338, 10432, 113, 1, 18, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342476, 10437, 113, 2, 28, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342592, 10441, 118, 3, 27, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342725, 10447, 106, 1, 18, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342834, 10450, 1180, 35, 92, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[344017, 10487, 311, 7, 42, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[344331, 10496, 204, 6, 23, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[344538, 10504, 170, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}]},
  "i:47"->{
    Cell[328069, 10041, 106, 1, 36, "Subsection",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[328178, 10044, 1016, 22, 104, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[329197, 10068, 287, 6, 38, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[329487, 10076, 202, 5, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[329714, 10085, 135, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[329852, 10090, 1252, 21, 345, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[331119, 10114, 615, 11, 67, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[331737, 10127, 134, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[331874, 10132, 124, 2, 28, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332001, 10136, 424, 10, 39, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332428, 10148, 116, 1, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332547, 10151, 263, 5, 42, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332813, 10158, 118, 2, 24, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332934, 10162, 376, 9, 41, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[333313, 10173, 287, 9, 25, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[333603, 10184, 271, 9, 26, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[333877, 10195, 202, 5, 25, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334082, 10202, 146, 4, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334231, 10208, 158, 4, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334392, 10214, 220, 4, 42, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334615, 10220, 198, 5, 24, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334816, 10227, 320, 6, 42, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[335139, 10235, 575, 16, 56, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[335717, 10253, 279, 7, 79, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[335999, 10262, 305, 6, 36, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[336307, 10270, 156, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[336466, 10275, 115, 1, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[336584, 10278, 363, 6, 74, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[336950, 10286, 97, 1, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[337072, 10291, 137, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[337212, 10296, 875, 17, 153, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[338102, 10316, 214, 6, 21, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[338341, 10326, 144, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[338488, 10331, 623, 9, 201, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339126, 10343, 114, 1, 18, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339265, 10348, 138, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339406, 10353, 116, 3, 27, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339537, 10359, 180, 4, 18, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339742, 10367, 157, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339902, 10372, 127, 3, 27, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[340044, 10378, 246, 7, 21, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[340315, 10389, 1130, 21, 234, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[341448, 10412, 875, 17, 179, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342338, 10432, 113, 1, 18, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342476, 10437, 113, 2, 28, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342592, 10441, 118, 3, 27, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342725, 10447, 106, 1, 18, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342834, 10450, 1180, 35, 92, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[344017, 10487, 311, 7, 42, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[344331, 10496, 204, 6, 23, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[344538, 10504, 170, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}]},
  "b:2.5"->{
    Cell[328069, 10041, 106, 1, 36, "Subsection",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[328178, 10044, 1016, 22, 104, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[329197, 10068, 287, 6, 38, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[329487, 10076, 202, 5, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[329714, 10085, 135, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[329852, 10090, 1252, 21, 345, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[331119, 10114, 615, 11, 67, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[331737, 10127, 134, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[331874, 10132, 124, 2, 28, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332001, 10136, 424, 10, 39, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332428, 10148, 116, 1, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332547, 10151, 263, 5, 42, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332813, 10158, 118, 2, 24, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[332934, 10162, 376, 9, 41, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[333313, 10173, 287, 9, 25, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[333603, 10184, 271, 9, 26, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[333877, 10195, 202, 5, 25, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334082, 10202, 146, 4, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334231, 10208, 158, 4, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334392, 10214, 220, 4, 42, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334615, 10220, 198, 5, 24, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[334816, 10227, 320, 6, 42, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[335139, 10235, 575, 16, 56, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[335717, 10253, 279, 7, 79, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[335999, 10262, 305, 6, 36, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[336307, 10270, 156, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[336466, 10275, 115, 1, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[336584, 10278, 363, 6, 74, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[336950, 10286, 97, 1, 22, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[337072, 10291, 137, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[337212, 10296, 875, 17, 153, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[338102, 10316, 214, 6, 21, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[338341, 10326, 144, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[338488, 10331, 623, 9, 201, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339126, 10343, 114, 1, 18, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339265, 10348, 138, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339406, 10353, 116, 3, 27, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339537, 10359, 180, 4, 18, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339742, 10367, 157, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[339902, 10372, 127, 3, 27, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[340044, 10378, 246, 7, 21, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[340315, 10389, 1130, 21, 234, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[341448, 10412, 875, 17, 179, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342338, 10432, 113, 1, 18, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342476, 10437, 113, 2, 28, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342592, 10441, 118, 3, 27, "Output",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342725, 10447, 106, 1, 18, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[342834, 10450, 1180, 35, 92, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[344017, 10487, 311, 7, 42, "BulletedList",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[344331, 10496, 204, 6, 23, "Text",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}],
    Cell[344538, 10504, 170, 3, 26, "Input",
      CellTags->{"ManipulatingExample5", "i:47", "b:2.5"}]},
  "VerifyingSym"->{
    Cell[344745, 10512, 97, 1, 36, "Subsection",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[344845, 10515, 553, 14, 56, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[345401, 10531, 161, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[345565, 10536, 461, 11, 56, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[346029, 10549, 245, 5, 42, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[346277, 10556, 610, 15, 72, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[346912, 10575, 141, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[347056, 10580, 2096, 29, 361, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[349167, 10612, 648, 15, 68, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[349840, 10631, 120, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[349963, 10636, 124, 3, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350124, 10644, 142, 3, 22, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350269, 10649, 141, 3, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350447, 10657, 185, 4, 22, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350635, 10663, 175, 4, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350825, 10670, 98, 1, 20, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350948, 10675, 352, 8, 58, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[351303, 10685, 144, 3, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[351462, 10691, 135, 4, 20, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[351622, 10699, 133, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[351758, 10704, 3928, 89, 713, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[355701, 10796, 237, 7, 20, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[355963, 10807, 384, 8, 58, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[356350, 10817, 4148, 90, 713, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[360513, 10910, 208, 6, 20, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[360746, 10920, 131, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[360880, 10925, 109, 3, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}]},
  "i:48"->{
    Cell[344745, 10512, 97, 1, 36, "Subsection",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[344845, 10515, 553, 14, 56, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[345401, 10531, 161, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[345565, 10536, 461, 11, 56, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[346029, 10549, 245, 5, 42, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[346277, 10556, 610, 15, 72, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[346912, 10575, 141, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[347056, 10580, 2096, 29, 361, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[349167, 10612, 648, 15, 68, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[349840, 10631, 120, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[349963, 10636, 124, 3, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350124, 10644, 142, 3, 22, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350269, 10649, 141, 3, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350447, 10657, 185, 4, 22, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350635, 10663, 175, 4, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350825, 10670, 98, 1, 20, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350948, 10675, 352, 8, 58, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[351303, 10685, 144, 3, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[351462, 10691, 135, 4, 20, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[351622, 10699, 133, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[351758, 10704, 3928, 89, 713, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[355701, 10796, 237, 7, 20, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[355963, 10807, 384, 8, 58, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[356350, 10817, 4148, 90, 713, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[360513, 10910, 208, 6, 20, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[360746, 10920, 131, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[360880, 10925, 109, 3, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}]},
  "b:2.6"->{
    Cell[344745, 10512, 97, 1, 36, "Subsection",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[344845, 10515, 553, 14, 56, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[345401, 10531, 161, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[345565, 10536, 461, 11, 56, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[346029, 10549, 245, 5, 42, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[346277, 10556, 610, 15, 72, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[346912, 10575, 141, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[347056, 10580, 2096, 29, 361, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[349167, 10612, 648, 15, 68, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[349840, 10631, 120, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[349963, 10636, 124, 3, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350124, 10644, 142, 3, 22, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350269, 10649, 141, 3, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350447, 10657, 185, 4, 22, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350635, 10663, 175, 4, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350825, 10670, 98, 1, 20, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[350948, 10675, 352, 8, 58, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[351303, 10685, 144, 3, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[351462, 10691, 135, 4, 20, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[351622, 10699, 133, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[351758, 10704, 3928, 89, 713, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[355701, 10796, 237, 7, 20, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[355963, 10807, 384, 8, 58, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[356350, 10817, 4148, 90, 713, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[360513, 10910, 208, 6, 20, "Text",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[360746, 10920, 131, 3, 26, "Input",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}],
    Cell[360880, 10925, 109, 3, 25, "Output",
      CellTags->{"VerifyingSym", "i:48", "b:2.6"}]},
  "b:3.0"->{
    Cell[361134, 10940, 70, 1, 36, "Subsection",
      CellTags->"b:3.0"],
    Cell[361229, 10945, 102, 2, 33, "Subsubsection",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[361334, 10949, 257, 9, 24, "Text",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[361594, 10960, 364, 15, 41, "FramedBox",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[361961, 10977, 487, 21, 41, "FramedBox",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[362451, 11000, 827, 25, 72, "Text",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[363281, 11027, 202, 6, 24, "Text",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[363508, 11037, 141, 3, 26, "Input",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[363652, 11042, 114, 3, 25, "Output",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[363803, 11050, 118, 3, 22, "Input",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[363924, 11055, 402, 13, 156, "Print",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[364341, 11071, 222, 7, 20, "Text",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[364588, 11082, 144, 3, 26, "Input",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[364735, 11087, 114, 3, 25, "Output",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[364886, 11095, 118, 3, 22, "Input",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[365007, 11100, 377, 18, 231, "Print",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[365399, 11121, 999, 39, 52, "Text",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[366423, 11164, 130, 3, 26, "Input",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[366556, 11169, 114, 3, 25, "Output",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[366707, 11177, 118, 3, 22, "Input",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[366828, 11182, 402, 13, 156, "Print",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[367245, 11198, 788, 33, 36, "Text",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[368058, 11235, 130, 3, 26, "Input",
      CellTags->{"UsingExport", "i:49", "b:3.0"}],
    Cell[368191, 11240, 114, 3, 25, "Output",
      CellTags->{"UsingExport", "i:49", "b: