(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    325982,       9145]*)
(*NotebookOutlinePosition[    376787,      10569]*)
(*  CellTagsIndexPosition[    375697,      10531]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Web Services Package", "Title"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"b:1.1"],

Cell[TextData[{
  "More and more the World Wide Web is being used for \
application-to-application communication. The programmatic interfaces made \
available over the web are often referred to as web services. There are many \
types of applications that can be considered web services but \
interoperability between applications is enhanced most by the use of familiar \
technologies such as XML and HTTP. These technologies allow applications \
using differing languages and platforms to interface in a familiar way. More \
information on web services can be found at ",
  StyleBox[ButtonBox["http://www.w3.org/2002/ws/",
    ButtonData:>{
      URL[ "http://www.w3.org/2002/ws/"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  "."
}], "Text",
  FontWeight->"Plain",
  CellTags->"b:1.1"],

Cell[TextData[StyleBox["Technology",
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.1"],

Cell[TextData[{
  "The web services client for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " allows users to call operations that are based on other platforms or \
languages that are not immediately accessible to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". This opens up a whole new realm to users of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"b:1.1"],

Cell[TextData[{
  "The World Wide Web Consortium (W3C) has introduced two Application \
Programming Interfaces (API) that are highly useful for \
application-to-application communication. These API's are Simple Object \
Access Protocol (SOAP) and Web Service Description Language (WSDL). These \
API's are the foundation for ",
  StyleBox["Mathematica\[CloseCurlyQuote]",
    FontSlant->"Italic"],
  "s web services client."
}], "Text",
  CellTags->"b:1.1"],

Cell["XML and HTTP", "Text",
  FontWeight->"Bold",
  CellTags->"b:1.1"],

Cell["\<\
A user interacts with the web service interfaces by sending XML messages over \
HTTP. XML and HTTP are useful for creating and sending messages because they \
are flexible and widely supported on many platforms and languages. This \
promotes interoperability between applications and allows applications using \
differing languages and platforms to interface.  The user may find knowledge \
of XML to be helpful, however, it is not required.\
\>", "Text",
  CellTags->"b:1.1"],

Cell["SOAP", "Text",
  FontWeight->"Bold",
  CellTags->"b:1.1"],

Cell[TextData[{
  "SOAP formally sets the conventions governing the format and processing \
rules of an XML message. SOAP is important because it standardizes the XML \
message used by the applications to communicate. Without SOAP or a similar \
protocol, applications would not know how to process XML messages. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " users are not required to know any specifics of SOAP, but for more \
information please see ",
  StyleBox[ButtonBox["http://www.w3.org/TR/SOAP/",
    ButtonData:>{
      URL[ "http://www.w3.org/TR/SOAP/"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  "."
}], "Text",
  FontWeight->"Plain",
  CellTags->"b:1.1"],

Cell["WSDL", "Text",
  FontWeight->"Bold",
  CellTags->"b:1.1"],

Cell[TextData[{
  "WSDL formally sets the format for describing a web service. By providing a \
Uniform Resource Identifier (URI) to a WSDL, applications can discover what \
operations a particular web service provides and how an operation\
\[CloseCurlyQuote]s messages look. With this information a client can bind to \
the operation and use it. A web services operation may be used without a \
WSDL, however, the WSDL is key for promoting a web service. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " users are not required to know any specifics of WSDL, but for more \
information please see ",
  StyleBox[ButtonBox["http://www.w3.org/TR/wsdl",
    ButtonData:>{
      URL[ "http://www.w3.org/TR/wsdl"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  "."
}], "Text",
  FontWeight->"Plain",
  CellTags->"b:1.1"],

Cell["XML Schema", "Text",
  FontWeight->"Bold",
  CellTags->"b:1.1"],

Cell[TextData[{
  "XML Schema is used to describe data types used in a web service. Using \
schema, a client can dynamically generate data types used in a web service. \
The client can validate data against a schema to make sure it correctly \
matches the definition for a data type. For more information please see ",
  StyleBox[ButtonBox["http://www.w3.org/XML/Schema",
    ButtonData:>{
      URL[ "http://www.w3.org/XML/Schema"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  ". The user is not required to know any specifics of XML Schema. However, \
it could be useful in determining whether a web service is supported by the \
Web Services Package."
}], "Text",
  CellTags->"b:1.1"],

Cell["WS-I Profiles", "Text",
  FontWeight->"Bold",
  CellTags->"b:1.1"],

Cell[TextData[{
  "WS-I Profiles specify implementation guidelines on how core web services \
specifications should be used together to develop interoperable web services. \
This specification gives guidelines for WSDL, SOAP, and Universal \
Description, Discovery and Integration (UDDI) implementations. The focus of \
this specification is easier integration among varying implementations of web \
services and their clients. The client uses these guidelines for the \
implementation.  A web service that follows these guidelines is more likely \
to work correctly with the client. For more information please see ",
  StyleBox[ButtonBox["http://www.ws-i.org/",
    ButtonData:>{
      URL[ "http://www.ws-i.org/"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  "."
}], "Text",
  CellTags->"b:1.1"],

Cell["Apache Axis", "Text",
  FontWeight->"Bold",
  CellTags->"b:1.1"],

Cell[TextData[{
  "Rather than implement a whole new engine, Apache Axis is used to implement \
part of the Web Services Package technology. It is a Java-based SOAP engine \
with extensive support for WSDL. This engine is used by the Web Services \
Package to invoke web service operations. Axis follows the SOAP 1.1 and WSDL \
1.1 specifications. For more details on Axis see ",
  StyleBox[ButtonBox["http://xml.apache.org/axis",
    ButtonData:>{
      URL[ "http://xml.apache.org/axis"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  ButtonBox[".",
    ButtonData:>{
      URL[ "http://xml.apache.org/axis"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"b:1.1"],

Cell["\<\
Despite being implemented in Java, the Web Services Package is designed to be \
Java independent. This means the user will not be required to provide Java \
parameters to functions, and Java objects will not be returned from \
functions. Therefore the user is not required to know Java to use this \
package.\
\>", "Text",
  CellTags->"b:1.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Getting Started", "Section"],

Cell[CellGroupData[{

Cell["Version Requirements", "Subsection",
  FontWeight->"Bold",
  CellTags->"b:1.2.1"],

Cell[TextData[{
  "The Web Services Package requires ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " 4.2 or later and is compatible with all platforms on which ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is available. The Web Services Package also requires a Java runtime that \
is 1.3.1 or later."
}], "Text",
  CellTags->"b:1.2.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Starting Simple", "Subsection",
  CellTags->"b:1.2.2"],

Cell[TextData[{
  "A user can discover and generate ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions for each web service operation using a WSDL file. The WSDL file \
specifies operations and data types that are used for a particular web \
service. A user generates functions that interface with these operations by \
passing a WSDL file to the ",
  StyleBox["InstallService",
    FontFamily->"Courier"],
  " function. ",
  StyleBox["InstallService",
    FontFamily->"Courier"],
  " creates a function for each operation defined in the WSDL."
}], "Text",
  CellTags->"b:1.2.2"],

Cell[BoxData[
    \(Needs["\<WebServices`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:1.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://www.xmethods.net/sd/2001/\
CurrencyExchangeService.wsdl\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"b:1.2.2"],

Cell[BoxData[
    \({getRate}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"b:1.2.2"]
}, Open  ]],

Cell[TextData[{
  "The functions created by ",
  StyleBox["InstallService",
    FontFamily->"Courier"],
  " are returned in a list. After the service is installed, a user can find \
information about the functions by using ",
  StyleBox["Information",
    FontFamily->"Courier"],
  ". ",
  StyleBox["Information",
    FontFamily->"Courier New"],
  " returns text describing the function that is provided by the WSDL file. \
It also contains a link that will bring up the OperationPalette for a \
function."
}], "Text",
  CellTags->"b:1.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?getRate\)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:1.2.2"],

Cell[BoxData["\<\"Returns the exchange rate between the two \
currencies\\n\\nPlease refer to \!\(\*ButtonBox[\\\"OperationPalette[getRate]\
\\\",           Active->True,            ButtonEvaluator->Automatic,          \
 ButtonFunction->OperationPalette[getRate],           \
ButtonStyle->\\\"Hyperlink\\\"]\) for help.\"\>"], "Print",
  CellTags->{"Info3277214259-7288901", "b:1.2.2"}]
}, Open  ]],

Cell[TextData[{
  "The OperationPalette is a palette that a user can navigate to discover how \
the web service operation works.  The OperationPalette lists the parameters \
needed to invoke the operation and the data returned by the operation. The \
OperationPalette also contains a Types section that may be used to view \
information about each type used by an operation.  A user can access this \
information by using hyperlinks or manual navigation. The OperationPalette \
reveals that two parameters of type ",
  StyleBox["{http://www.w3.org/1999/XMLSchema}string",
    FontSlant->"Italic"],
  " are required to invoke the ",
  StyleBox["getRate",
    FontFamily->"Courier"],
  " function.  The Types section specifies that the parameters for this \
function are represented by strings in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". A user can make calls to ",
  StyleBox["getRate",
    FontFamily->"Courier New"],
  " using two strings as parameters."
}], "Text",
  CellTags->"b:1.2.2"],

Cell[TextData[{
  "As a convenience the user can paste a template for a function call by \
clicking the ",
  StyleBox["Paste",
    FontFamily->"Arial"],
  " button in the OperationPalette.  This will paste the function as it \
should be called in ",
  StyleBox["Mathematica, ",
    FontSlant->"Italic"],
  "but it will contain place holders for the values."
}], "Text",
  CellTags->"b:1.2.2"],

Cell[BoxData[
    \(getRate \(["\<\[Placeholder]\>", "\<\[Placeholder]\>"]\)\)], "Input",
  CellTags->"b:1.2.2"],

Cell["\<\
The OperationPalette will specify an operation signature and data types \
required for an operation. But often further documentation is needed and can \
be found on websites documenting a particular web service.  \
\>", "Text",
  CellTags->"b:1.2.2"],

Cell[TextData[{
  "To find out more information about the Exchange Rate Web Service please \
visit ",
  StyleBox[ButtonBox["http://www.xmethods.com",
    ButtonData:>{
      URL[ 
      "http://www.xmethods.com/ve2/ViewListing.po?key=uuid:D784C184-99B2-DA25-\
ED45-3665D11A12E5"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  "."
}], "Text",
  CellTags->"b:1.2.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(getRate["\<US\>", "\<England\>"]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:1.2.2"],

Cell[BoxData[
    \(0.5982`\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:1.2.2"]
}, Open  ]],

Cell[TextData[{
  "When a function is evaluated, each function parses user input and creates \
a SOAP message. It then invokes the appropriate server operation and the \
function receives the results of the invocation and parses the results into \
data types ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " users will recognize."
}], "Text",
  CellTags->"b:1.2.2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compound Types", "Subsection",
  CellTags->"b:1.2.3"],

Cell[TextData[{
  "Some web service operations require compound types as parameters. Compound \
types are data that cannot be represented by a single simple value such as a \
string, integer, real, true or false. Compound types are a sequence of base \
types. They are bounded by a list in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". Items inside a compound type are represented by a rule. The left side of \
the rule is the description of the element. The description of the element \
contains its name but may also contain its type and other attributes \
describing it (See ",
  ButtonBox["Type Mapping",
    ButtonData:>"Type Mapping",
    ButtonStyle->"Hyperlink"],
  "). The right side of the rule will be the value of the element. The value \
of the element may be a simple or compound type."
}], "Text",
  CellTags->"b:1.2.3"],

Cell[TextData[{
  "In the example below, ",
  StyleBox["AuthorSearchRequest",
    FontFamily->"Courier"],
  " has a parameter that requires a compound value."
}], "Text",
  CellTags->"b:1.2.3"],

Cell[BoxData[
    \(Needs["\<WebServices`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:1.2.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://soap.amazon.com/schemas3/AmazonWebServices.\
wsdl\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"b:1.2.3"],

Cell[BoxData[
    \({KeywordSearchRequest, TextStreamSearchRequest, PowerSearchRequest, 
      BrowseNodeSearchRequest, AsinSearchRequest, BlendedSearchRequest, 
      UpcSearchRequest, SkuSearchRequest, AuthorSearchRequest, 
      ArtistSearchRequest, ActorSearchRequest, ManufacturerSearchRequest, 
      DirectorSearchRequest, ExchangeSearchRequest, ListManiaSearchRequest, 
      WishlistSearchRequest, SellerProfileSearchRequest, SellerSearchRequest, 
      MarketplaceSearchRequest, SimilaritySearchRequest, 
      GetShoppingCartRequest, ClearShoppingCartRequest, 
      AddShoppingCartItemsRequest, RemoveShoppingCartItemsRequest, 
      ModifyShoppingCartItemsRequest, 
      GetTransactionDetailsRequest}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"b:1.2.3"]
}, Open  ]],

Cell[TextData[{
  "This shows how to use the OperationPalette to see the signature of the \
method.  Using the OperationPalette, you can see that this method requires a \
complex type with a qualified name of ",
  StyleBox["{http://soap.amazon.com}AuthorRequest",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"b:1.2.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?AuthorSearchRequest\)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:1.2.3"],

Cell[BoxData["\<\"Documentation was not provided.\\n\\nPlease refer to \
\!\(\*ButtonBox[\\\"OperationPalette[AuthorSearchRequest]\\\",           \
Active->True,            ButtonEvaluator->Automatic,           \
ButtonFunction->OperationPalette[AuthorSearchRequest],           \
ButtonStyle->\\\"Hyperlink\\\"]\) for help.\"\>"], "Print",
  CellTags->{"Info3290922430-6355998", "b:1.2.3"}]
}, Open  ]],

Cell[TextData[{
  "As mentioned before, the OperationPalette can be used to inspect \
information about the type. The OperationPalette also can be used to paste a \
template of the type needed for the function.  In this case, a user may click \
the gray ",
  StyleBox["AuthorSearchRequest",
    FontFamily->"Arial"],
  " button, and it pastes an expression representing ",
  StyleBox["{http://soap.amazon.com}AuthorRequest",
    FontSlant->"Italic"],
  ". A user can tab through the placeholders to easily input the values of \
the expression.  The OperationPalette may be used as a reference for \
inputting these values. A user may click on the hyperlink, ",
  StyleBox["{http://soap.amazon.com}AuthorRequest",
    FontSlant->"Italic"],
  ", to go to documentation describing the type."
}], "Text",
  CellTags->"b:1.2.3"],

Cell[BoxData[
    \(AuthorSearchRequest[{"\<author\>" \[Rule] "\<\[Placeholder]\>", "\<page\
\>" \[Rule] "\<\[Placeholder]\>", "\<mode\>" \[Rule] "\<\[Placeholder]\>", \
"\<tag\>" \[Rule] "\<\[Placeholder]\>", "\<type\>" \[Rule] \
"\<\[Placeholder]\>", "\<devtag\>" \[Rule] "\<\[Placeholder]\>", "\<sort\>" \
\[Rule] "\<\[Placeholder]\>", "\<locale\>" \[Rule] "\<\[Placeholder]\>", \
"\<keywords\>" \[Rule] "\<\[Placeholder]\>", "\<price\>" \[Rule] "\<\
\[Placeholder]\>"}]\)], "Input",
  CellTags->"b:1.2.3"],

Cell[TextData[{
  "As mentioned before, often it is useful to visit the web site \
documentation for a web service to find how to properly use the operations.  \
To find out more information about the Amazon Web Services please visit ",
  StyleBox[ButtonBox["http://www.amazon.com/webservices",
    ButtonData:>{
      URL[ "http://www.amazon.com/webservices"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  ButtonBox[".",
    ButtonData:>{
      URL[ "http://www.amazon.com/webservices"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"b:1.2.3"],

Cell["\<\
Once the placeholders are filled, the user may invoke the function.\
\>", "Text",
  CellTags->"b:1.2.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(AuthorSearchRequest[{"\<author\>" \[Rule] "\<Stephen Wolfram\>", \
"\<page\>" \[Rule] "\<1\>", "\<mode\>" \[Rule] "\<books\>", "\<tag\>" \[Rule] \
"\<webservices-30\>", "\<type\>" \[Rule] "\<lite\>", "\<devtag\>" \[Rule] \
"\<D3VZJS46JD5U9D\>"}]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:1.2.3"],

Cell[BoxData[
    \({"TotalResults" \[Rule] "10", "TotalPages" \[Rule] "1", 
      "Details" \[Rule] {{"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/1579550088/webservices-\
30?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", 
            "Asin" \[Rule] "1579550088", 
            "ProductName" \[Rule] "A New Kind of Science", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "14 May, 2002", 
            "Manufacturer" \[Rule] "Wolfram Media", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/1579550088.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/1579550088.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/1579550088.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$44.95", "OurPrice" \[Rule] "$44.95", 
            "Availability" \[Rule] "Usually ships in 24 hours", 
            "UsedPrice" \[Rule] "$24.00"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/1579550223/webservices-\
30?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", 
            "Asin" \[Rule] "1579550223", 
            "ProductName" \[Rule] "The Mathematica Book, Fifth Edition", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "22 August, 2003", 
            "Manufacturer" \[Rule] "Wolfram Media", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/1579550223.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/1579550223.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/1579550223.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$49.95", "OurPrice" \[Rule] "$49.95", 
            "Availability" \[Rule] "Usually ships in 24 hours", 
            "UsedPrice" \[Rule] "$39.96"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/0201626640/webservices-\
30?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", 
            "Asin" \[Rule] "0201626640", 
            "ProductName" \[Rule] "Cellular Automata and Complexity", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "01 January, 1994", 
            "Manufacturer" \[Rule] "Perseus Books Group", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0201626640.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0201626640.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0201626640.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$35.00", "OurPrice" \[Rule] "$35.00", 
            "Availability" \[Rule] "Usually ships in 12 to 13 days", 
            "UsedPrice" \[Rule] "$19.44"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/1579550207/webservices-\
30?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", 
            "Asin" \[Rule] "1579550207", 
            "ProductName" \[Rule] 
              "A New Kind of Science: A New Kind of Science Explorer bundle", 
            "Catalog" \[Rule] "Book", 
            "Authors" \[Rule] {"Stephen Wolfram", "Wolfram Research Inc."}, 
            "ReleaseDate" \[Rule] "01 September, 2002", 
            "Manufacturer" \[Rule] "Wolfram Media Inc", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/1579550207.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/1579550207.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/1579550207.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$95.00", "OurPrice" \[Rule] "$95.00", 
            "Availability" \[Rule] 
              "Usually ships in 24 hours"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/0521585856/webservices-\
30?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", 
            "Asin" \[Rule] "0521585856", 
            "ProductName" \[Rule] 
              "Mathematica \[RegisteredTrademark] 3.0 Standard Add-on \
Packages", "Catalog" \[Rule] "Book", 
            "Authors" \[Rule] {"Stephen Wolfram", 
                "Inc. Staff Wolfram Research"}, 
            "ReleaseDate" \[Rule] "13 September, 1996", 
            "Manufacturer" \[Rule] "Cambridge University Press", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0521585856.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0521585856.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0521585856.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$40.00", "OurPrice" \[Rule] "$40.00", 
            "Availability" \[Rule] "Usually ships in 24 hours", 
            "UsedPrice" \[Rule] "$1.55"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/0201515024/webservices-\
30?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", 
            "Asin" \[Rule] "0201515024", 
            "ProductName" \[Rule] 
              "Mathematica: A System for Doing Mathematics by Computer", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "01 March, 1991", 
            "Manufacturer" \[Rule] "Addison-Wesley", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0201515024.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0201515024.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0201515024.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$51.95", 
            "Availability" \[Rule] "This item is currently not available.", 
            "UsedPrice" \[Rule] "$0.75"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/0201554798/webservices-\
30?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", 
            "Asin" \[Rule] "0201554798", 
            "ProductName" \[Rule] "Mathematica: The Student Book", 
            "Catalog" \[Rule] "Book", 
            "Authors" \[Rule] {"Stephen Wolfram", "George Beck"}, 
            "ReleaseDate" \[Rule] "01 May, 1994", 
            "Manufacturer" \[Rule] "Addison-Wesley Pub Co (Sd)", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0201554798.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0201554798.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0201554798.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$32.95", 
            "Availability" \[Rule] "This item is currently not available.", 
            "UsedPrice" \[Rule] "$1.80"}, {"Url" \[Rule] 
              
              "http://www.amazon.com/exec/obidos/ASIN/0201193345/webservices-\
30?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", 
            "Asin" \[Rule] "0201193345", 
            "ProductName" \[Rule] 
              "Mathematica: A system for doing mathematics by computer", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "1988", 
            "Manufacturer" \[Rule] 
              "Addison-Wesley Pub. Co., Advanced Book Program", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0201193345.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0201193345.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0201193345.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$39.95", 
            "Availability" \[Rule] "This item is currently not available.", 
            "UsedPrice" \[Rule] "$2.99"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/020151012X/webservices-\
30?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", 
            "Asin" \[Rule] "020151012X", 
            "ProductName" \[Rule] 
              "Mathematica: Reference Guide/for Mathematica Version 2", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "01 May, 1992", 
            "Manufacturer" \[Rule] "Addison-Wesley", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/020151012X.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/020151012X.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/020151012X.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$21.95", 
            "Availability" \[Rule] "This item is currently not available.", 
            "UsedPrice" \[Rule] "$7.50"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/1579550193/webservices-\
30?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", 
            "Asin" \[Rule] "1579550193", 
            "ProductName" \[Rule] "New Kind of Science: Notes from the Book", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "01 December, 2002", 
            "Manufacturer" \[Rule] "Wolfram Media Inc", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/1579550193.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/1579550193.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/1579550193.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$32.50", "OurPrice" \[Rule] "$32.50", 
            "Availability" \[Rule] "Special Order"}}}\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"b:1.2.3"]
}, Open  ]],

Cell["\<\
The result that is returned is similar to the input except that it is a bit \
more lengthy. It is a compound type as well. The syntax for the output is the \
same as the input, a rule. And as such a user will find the data contains \
pieces of data with descriptions on the left and values on the right. The \
OperationPalette can also be used to inspect information about the output \
type.\
\>", "Text",
  CellTags->"b:1.2.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Advanced Topics", "Section"],

Cell[CellGroupData[{

Cell["Type Mapping", "Subsection",
  CellTags->"Type Mapping"],

Cell[CellGroupData[{

Cell["Introduction", "Subsubsection",
  CellTags->"b:1.3.1.1"],

Cell[TextData[{
  "While invoking a web service, the user may be required to input parameters \
of several different types. Since Web Services is an XML-based standard, \
there needs to be some mapping between ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " types and XML types. The rule syntax is used to provide this mapping. The \
rule syntax may be compared to symbolic XML in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". However, the rule syntax offers two advantages over symbolic XML. The \
first advantage is that it may contain values other than strings. The user \
will not be required to transform values to and from strings. The second \
advantage is that it offers a shorter way to display an XML element."
}], "Text",
  CellTags->"b:1.3.1.1"],

Cell[TextData[{
  "The types of values supported by the rule syntax are ",
  StyleBox["Rule",
    FontFamily->"Courier"],
  ", ",
  StyleBox["XMLElement",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["List",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["String",
    FontFamily->"Courier New"],
  ", ",
  StyleBox["Integer",
    FontFamily->"Courier"],
  ", ",
  StyleBox["Real",
    FontFamily->"Courier"],
  ", ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["Null",
    FontFamily->"Courier"],
  ". This client does not have a validation mechanism to check the user\
\[CloseCurlyQuote]s input. Therefore, when passing ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "parameters to a web service function any type supported by the web \
services client may be used. Parameters are all eventually converted to \
strings. For SOAP-encoded web services, type information and other \
information is also added to these parameters using data from the WSDL before \
it is sent to the web service. This helps the web service discern the data \
sent."
}], "Text",
  CellTags->"b:1.3.1.1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic Rule Syntax", "Subsubsection",
  CellTags->"b:1.3.1.2"],

Cell[TextData[{
  "The basic format of the rule syntax is ",
  StyleBox["name_String->value_",
    FontSlant->"Italic"],
  ". This syntax is much shorter than the XMLElement of symbolic XML. The \
name of the element is specified on the left side and the value is specified \
on the right side. This syntax is used at two different times. When the user \
invokes a web service, the parameters, in rule syntax, are passed to the \
function and serialized into XML. When the user receives the result from the \
function, the message is deserialized from XML into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression. This expression follows the rule syntax. Therefore, the rule \
syntax plays a very important role in the Web Services Package.  "
}], "Text",
  CellTags->"b:1.3.1.2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Long Form", "Subsubsection",
  CellTags->"b:1.3.1.3"],

Cell[TextData[{
  "One advantage of using the rule syntax is that multiple forms may be used. \
So it is possible to provide and receive more or less of the information. The \
option ",
  StyleBox["LongForm",
    FontFamily->"Courier"],
  " controls how much information is returned during the deserialization of \
results. ",
  StyleBox["LongForm",
    FontFamily->"Courier"],
  " determines if the attributes will be returned with the names and values. \
If ",
  StyleBox["LongForm",
    FontFamily->"Courier"],
  " is set to ",
  StyleBox["False",
    FontFamily->"Courier"],
  ", then the function will return the basic rule syntax. If ",
  StyleBox["LongForm",
    FontFamily->"Courier"],
  " is set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  ", then the names, attributes, and values will all be returned. ",
  StyleBox["LongForm",
    FontFamily->"Courier"],
  " is set to ",
  StyleBox["False",
    FontFamily->"Courier"],
  " by default."
}], "Text",
  CellTags->"b:1.3.1.3"],

Cell[TextData[{
  "The basic rule syntax does not allow for the user to input attributes or a \
qualified name for an element. Most of the time this is okay, if the \
operation being called has a WSDL file associated with it. However, sometimes \
it is important for the user to be able to input the qualified name or the \
attributes of an element. Perhaps the user is using a web service without a \
WSDL. The long form syntax is ",
  StyleBox["{{namespace_String, name_String}, attributes:{___Rule}}->value_. \
",
    FontSlant->"Italic"],
  "The difference between the basic and full rule syntax is entirely on the \
left side. The full syntax contains a list of two items on the left side of \
the rule. The first item is the name, which is also specified on the left \
side in the basic syntax. The second item is the attributes list.  This is \
something that cannot be specified in the basic syntax."
}], "Text",
  CellTags->"b:1.3.1.3"],

Cell["\<\
When specifying the name in the full rule syntax, the user may specify the \
name as a single string. The user may also specify a qualified name as a list \
of two strings. The first string specifies the namespace URI for the \
qualified name and the second string specifies the local name.\
\>", "Text",
  CellTags->"b:1.3.1.3"],

Cell[TextData[{
  "When specifying attributes in the full rule syntax, the user may specify \
an attribute using a ",
  StyleBox["Rule",
    FontFamily->"Courier"],
  ". The left-hand side of the rule contains the name of the attribute. It \
may be a string or a qualified name as described earlier for the name. The \
right-hand side is the value of the attribute. The value may be a string, \
integer, real, true, false, or a qualified name as described earlier for the \
name. A qualified name may also be specified using a special string syntax of \
\"",
  StyleBox["{<namespaceURI>}name\".  ",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"b:1.3.1.3"],

Cell[TextData[{
  "One important attribute that could be set in order to use a web service is \
the type attribute. A type can be set by setting the type attribute in the ",
  StyleBox["http://www.w3.org/2001/XMLSchema-instance",
    FontSlant->"Italic"],
  " namespace.  An example of this follows in the bold code."
}], "Text",
  CellTags->"b:1.3.1.3"],

Cell[TextData[{
  StyleBox["{\"AuthorSearchRequest\", {\n    ", "InlineFormula"],
  StyleBox["{\"http://www.w3.org/2001/XMLSchema-instance\",\"type\"}->\n      \
\"{", "InlineFormula",
    FontWeight->"Bold"],
  StyleBox["urn:PI/DevCentral/SoapService",
    FontWeight->"Bold"],
  StyleBox["}", "InlineFormula",
    FontWeight->"Bold"],
  StyleBox["ActorRequest",
    FontWeight->"Bold"],
  StyleBox["\"", "InlineFormula",
    FontWeight->"Bold"],
  StyleBox["}}->{...}", "InlineFormula"]
}], "InlineFormula",
  CellTags->"b:1.3.1.3"],

Cell[TextData[{
  "As noted earlier, an attribute requiring a qualified name, such as the \
type, can also be set using a list.  The following example specifies the type \
as an array.  Sometimes for arrays it is important to also set the ",
  StyleBox["arrayType",
    FontFamily->"Courier New"],
  " attribute. This is italicized in the example."
}], "Text",
  CellTags->"b:1.3.1.3"],

Cell[TextData[{
  StyleBox["{\"doubleArray\", {\n    ", "InlineFormula"],
  StyleBox["{\"http://www.w3.org/2001/XMLSchema-instance\",\"type\"}->\n      \
  {\"", "InlineFormula",
    FontWeight->"Bold"],
  StyleBox["http://schemas.xmlsoap.org/soap/encoding/",
    FontWeight->"Bold"],
  StyleBox["\"",
    FontWeight->"Bold"],
  StyleBox[",\"", "InlineFormula",
    FontWeight->"Bold"],
  StyleBox["array",
    FontWeight->"Bold"],
  StyleBox["\"}, \n    ", "InlineFormula",
    FontWeight->"Bold"],
  StyleBox["{\"", "InlineFormula",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["http://schemas.xmlsoap.org/soap/encoding/",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\",\"arrayType\"}->\"xsd:double[]\"", "InlineFormula",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["}->{...}", "InlineFormula"]
}], "InlineFormula",
  CellTags->"b:1.3.1.3"],

Cell[BoxData[
    \(Needs["\<WebServices`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:1.3.1.3"],

Cell[CellGroupData[{

Cell[BoxData[
    StyleBox[\(InstallService["\<http://soap.amazon.com/schemas3/\
AmazonWebServices.wsdl\>"]\),
      FontSize->12]], "Input",
  CellLabel->"In[2]:=",
  CellTags->"b:1.3.1.3"],

Cell[BoxData[
    \({KeywordSearchRequest, TextStreamSearchRequest, PowerSearchRequest, 
      BrowseNodeSearchRequest, AsinSearchRequest, BlendedSearchRequest, 
      UpcSearchRequest, SkuSearchRequest, AuthorSearchRequest, 
      ArtistSearchRequest, ActorSearchRequest, ManufacturerSearchRequest, 
      DirectorSearchRequest, ExchangeSearchRequest, ListManiaSearchRequest, 
      WishlistSearchRequest, SellerProfileSearchRequest, SellerSearchRequest, 
      MarketplaceSearchRequest, SimilaritySearchRequest, 
      GetShoppingCartRequest, ClearShoppingCartRequest, 
      AddShoppingCartItemsRequest, RemoveShoppingCartItemsRequest, 
      ModifyShoppingCartItemsRequest, 
      GetTransactionDetailsRequest}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"b:1.3.1.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ActorSearchRequest[{{{"\<urn:PI/DevCentral/SoapService\>", \
"\<actor\>"}, {{"\<http://www.w3.org/2001/XMLSchema-instance\>", "\<type\>"} \
\[Rule] {"\<http://www.w3.org/1999/XMLSchema\>", "\<string\>"}}} \[Rule] \
"\<Cruise\>", {{"\<urn:PI/DevCentral/SoapService\>", "\<page\>"}, \
{{"\<http://www.w3.org/2001/XMLSchema-instance\>", "\<type\>"} \[Rule] \
{"\<http://www.w3.org/1999/XMLSchema\>", "\<string\>"}}} \[Rule] "\<1\>", {{"\
\<urn:PI/DevCentral/SoapService\>", "\<mode\>"}, \
{{"\<http://www.w3.org/2001/XMLSchema-instance\>", "\<type\>"} \[Rule] \
{"\<http://www.w3.org/1999/XMLSchema\>", "\<string\>"}}} \[Rule] "\<dvd\>", \
{{"\<urn:PI/DevCentral/SoapService\>", "\<tag\>"}, \
{{"\<http://www.w3.org/2001/XMLSchema-instance\>", "\<type\>"} \[Rule] \
{"\<http://www.w3.org/1999/XMLSchema\>", "\<string\>"}}} \[Rule] \
"\<webservices-20\>", {{"\<urn:PI/DevCentral/SoapService\>", "\<type\>"}, {{"\
\<http://www.w3.org/2001/XMLSchema-instance\>", "\<type\>"} \[Rule] \
{"\<http://www.w3.org/1999/XMLSchema\>", "\<string\>"}}} \[Rule] "\<lite\>", \
{{"\<urn:PI/DevCentral/SoapService\>", "\<devtag\>"}, \
{{"\<http://www.w3.org/2001/XMLSchema-instance\>", "\<type\>"} \[Rule] \
{"\<http://www.w3.org/1999/XMLSchema\>", "\<string\>"}}} \[Rule] \
"\<D3VZJS46JD5U9D\>", {{"\<urn:PI/DevCentral/SoapService\>", "\<version\>"}, \
{{"\<http://www.w3.org/2001/XMLSchema-instance\>", "\<type\>"} \[Rule] \
{"\<http://www.w3.org/1999/XMLSchema\>", "\<string\>"}}} \[Rule] "\<1.0\>"}, 
      LongForm \[Rule] True]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:1.3.1.3"],

Cell[BoxData[
    \({{{\*"\<\"\"\>", 
            "TotalResults"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                "type"} \[Rule] "xsd:string"}} \[Rule] 
        "50", {{\*"\<\"\"\>", 
            "TotalPages"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                "type"} \[Rule] "xsd:string"}} \[Rule] 
        "5", {{\*"\<\"\"\>", 
            "Details"}, {{"http://schemas.xmlsoap.org/soap/encoding/", 
                "arrayType"} \[Rule] 
              "amazon:Details[10]", \
{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
              "SOAP-ENC:Array"}} \[Rule] {{{{\*"\<\"\"\>", 
                  "Url"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/B0001JXOVC/webservices-\
20?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", {{\*"\<\"\"\>", 
                  "Asin"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "B0001JXOVC", {{\*"\<\"\"\>", 
                  "ProductName"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "The Last Samurai (Widescreen Edition)", {{\*"\<\"\"\>", 
                  "Catalog"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "DVD", {{\*"\<\"\"\>", 
                  "ReleaseDate"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "04 May, 2004", {{\*"\<\"\"\>", 
                  "Manufacturer"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Warner Home Video", {{\*"\<\"\"\>", 
                  "ImageUrlSmall"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B0001JXOVC.01.THUMBZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlMedium"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B0001JXOVC.01.MZZZZZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlLarge"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              
              "http://images.amazon.com/images/P/B0001JXOVC.01.LZZZZZZZ.jpg", \
{{\*"\<\"\"\>", "ListPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$29.95", {{\*"\<\"\"\>", 
                  "OurPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$19.47", {{\*"\<\"\"\>", 
                  "Availability"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Not yet released"}, {{{\*"\<\"\"\>", 
                  "Url"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/6305127689/webservices-\
20?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", {{\*"\<\"\"\>", 
                  "Asin"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "6305127689", {{\*"\<\"\"\>", 
                  "ProductName"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Top Gun", {{\*"\<\"\"\>", 
                  "Catalog"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "DVD", {{\*"\<\"\"\>", 
                  "ReleaseDate"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "19 August, 2003", {{\*"\<\"\"\>", 
                  "Manufacturer"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Paramount Studio", {{\*"\<\"\"\>", 
                  "ImageUrlSmall"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/6305127689.01.THUMBZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlMedium"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/6305127689.01.MZZZZZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlLarge"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/6305127689.01.LZZZZZZZ.jpg", \
{{\*"\<\"\"\>", "ListPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$19.99", {{\*"\<\"\"\>", 
                  "OurPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$16.39", {{\*"\<\"\"\>", 
                  "Availability"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Usually ships within 24 hours", {{\*"\<\"\"\>", 
                  "UsedPrice"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "$12.66"}, {{{\*"\<\"\"\>", 
                  "Url"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/B000063UR2/webservices-\
20?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", {{\*"\<\"\"\>", 
                  "Asin"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "B000063UR2", {{\*"\<\"\"\>", 
                  "ProductName"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Legend (Ultimate Edition)", {{\*"\<\"\"\>", 
                  "Catalog"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "DVD", {{\*"\<\"\"\>", 
                  "ReleaseDate"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "03 June, 2003", {{\*"\<\"\"\>", 
                  "Manufacturer"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Umvd", {{\*"\<\"\"\>", 
                  "ImageUrlSmall"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B000063UR2.01.THUMBZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlMedium"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B000063UR2.01.MZZZZZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlLarge"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B000063UR2.01.LZZZZZZZ.jpg", \
{{\*"\<\"\"\>", "ListPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$19.98", {{\*"\<\"\"\>", 
                  "OurPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$16.38", {{\*"\<\"\"\>", 
                  "Availability"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Usually ships within 24 hours", {{\*"\<\"\"\>", 
                  "UsedPrice"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "$14.99"}, {{{\*"\<\"\"\>", 
                  "Url"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/B00005JL78/webservices-\
20?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", {{\*"\<\"\"\>", 
                  "Asin"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "B00005JL78", {{\*"\<\"\"\>", 
                  "ProductName"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Minority Report (Widescreen Edition)", {{\*"\<\"\"\>", 
                  "Catalog"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "DVD", {{\*"\<\"\"\>", 
                  "ReleaseDate"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "17 December, 2002", {{\*"\<\"\"\>", 
                  "Manufacturer"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Universal Studios", {{\*"\<\"\"\>", 
                  "ImageUrlSmall"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00005JL78.01.THUMBZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlMedium"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00005JL78.01.MZZZZZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlLarge"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00005JL78.01.LZZZZZZZ.jpg", \
{{\*"\<\"\"\>", "ListPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$29.99", {{\*"\<\"\"\>", 
                  "OurPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$26.09", {{\*"\<\"\"\>", 
                  "Availability"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Usually ships within 24 hours", {{\*"\<\"\"\>", 
                  "UsedPrice"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "$4.89"}, {{{\*"\<\"\"\>", 
                  "Url"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/B00004RFFS/webservices-\
20?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", {{\*"\<\"\"\>", 
                  "Asin"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "B00004RFFS", {{\*"\<\"\"\>", 
                  "ProductName"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Interview with the Vampire - DTS", {{\*"\<\"\"\>", 
                  "Catalog"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "DVD", {{\*"\<\"\"\>", 
                  "ReleaseDate"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "03 February, 2004", {{\*"\<\"\"\>", 
                  "Manufacturer"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Warner Studios", {{\*"\<\"\"\>", 
                  "ImageUrlSmall"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00004RFFS.01.THUMBZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlMedium"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00004RFFS.01.MZZZZZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlLarge"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00004RFFS.01.LZZZZZZZ.jpg", \
{{\*"\<\"\"\>", "ListPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$19.97", {{\*"\<\"\"\>", 
                  "OurPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$16.38", {{\*"\<\"\"\>", 
                  "Availability"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Usually ships within 24 hours", {{\*"\<\"\"\>", 
                  "UsedPrice"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "$12.89"}, {{{\*"\<\"\"\>", 
                  "Url"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/B00005B6JZ/webservices-\
20?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", {{\*"\<\"\"\>", 
                  "Asin"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "B00005B6JZ", {{\*"\<\"\"\>", 
                  "ProductName"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "A Few Good Men (Special Edition)", {{\*"\<\"\"\>", 
                  "Catalog"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "DVD", {{\*"\<\"\"\>", 
                  "ReleaseDate"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "06 May, 2003", {{\*"\<\"\"\>", 
                  "Manufacturer"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Columbia/Tristar Studios", {{\*"\<\"\"\>", 
                  "ImageUrlSmall"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00005B6JZ.01.THUMBZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlMedium"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00005B6JZ.01.MZZZZZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlLarge"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00005B6JZ.01.LZZZZZZZ.jpg", \
{{\*"\<\"\"\>", "ListPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$14.95", {{\*"\<\"\"\>", 
                  "OurPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$12.26", {{\*"\<\"\"\>", 
                  "Availability"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Usually ships within 24 hours", {{\*"\<\"\"\>", 
                  "UsedPrice"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "$7.98"}, {{{\*"\<\"\"\>", 
                  "Url"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/0783226810/webservices-\
20?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", {{\*"\<\"\"\>", 
                  "Asin"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "0783226810", {{\*"\<\"\"\>", 
                  "ProductName"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Far and Away", {{\*"\<\"\"\>", 
                  "Catalog"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "DVD", {{\*"\<\"\"\>", 
                  "ReleaseDate"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "03 June, 2003", {{\*"\<\"\"\>", 
                  "Manufacturer"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Universal Studios", {{\*"\<\"\"\>", 
                  "ImageUrlSmall"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/0783226810.01.THUMBZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlMedium"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/0783226810.01.MZZZZZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlLarge"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/0783226810.01.LZZZZZZZ.jpg", \
{{\*"\<\"\"\>", "ListPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$14.98", {{\*"\<\"\"\>", 
                  "OurPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$12.28", {{\*"\<\"\"\>", 
                  "Availability"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Usually ships within 6 to 12 days", {{\*"\<\"\"\>", 
                  "UsedPrice"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "$9.00"}, {{{\*"\<\"\"\>", 
                  "Url"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/0800141741/webservices-\
20?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", {{\*"\<\"\"\>", 
                  "Asin"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "0800141741", {{\*"\<\"\"\>", 
                  "ProductName"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Jerry Maguire", {{\*"\<\"\"\>", 
                  "Catalog"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "DVD", {{\*"\<\"\"\>", 
                  "ReleaseDate"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "29 July, 2003", {{\*"\<\"\"\>", 
                  "Manufacturer"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Columbia/Tristar Studios", {{\*"\<\"\"\>", 
                  "ImageUrlSmall"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/0800141741.01.THUMBZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlMedium"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/0800141741.01.MZZZZZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlLarge"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/0800141741.01.LZZZZZZZ.jpg", \
{{\*"\<\"\"\>", "ListPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$14.95", {{\*"\<\"\"\>", 
                  "OurPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$12.26", {{\*"\<\"\"\>", 
                  "Availability"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Usually ships within 24 hours", {{\*"\<\"\"\>", 
                  "UsedPrice"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "$7.00"}, {{{\*"\<\"\"\>", 
                  "Url"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/B00002E237/webservices-\
20?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", {{\*"\<\"\"\>", 
                  "Asin"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "B00002E237", {{\*"\<\"\"\>", 
                  "ProductName"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "The Outsiders", {{\*"\<\"\"\>", 
                  "Catalog"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "DVD", {{\*"\<\"\"\>", 
                  "ReleaseDate"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "03 February, 2004", {{\*"\<\"\"\>", 
                  
                  "Manufacturer"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Warner Studios", {{\*"\<\"\"\>", 
                  "ImageUrlSmall"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00002E237.01.THUMBZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlMedium"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00002E237.01.MZZZZZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlLarge"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00002E237.01.LZZZZZZZ.jpg", \
{{\*"\<\"\"\>", "ListPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$14.97", {{\*"\<\"\"\>", 
                  "OurPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$12.28", {{\*"\<\"\"\>", 
                  "Availability"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Usually ships within 24 hours", {{\*"\<\"\"\>", 
                  "UsedPrice"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "$7.99"}, {{{\*"\<\"\"\>", 
                  "Url"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "http://www.amazon.com/exec/obidos/ASIN/B00000ILBL/webservices-\
20?dev-t=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1", {{\*"\<\"\"\>", 
                  "Asin"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "B00000ILBL", {{\*"\<\"\"\>", 
                  "ProductName"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Days of Thunder", {{\*"\<\"\"\>", 
                  "Catalog"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "DVD", {{\*"\<\"\"\>", 
                  "ReleaseDate"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "19 August, 2003", {{\*"\<\"\"\>", 
                  "Manufacturer"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Paramount Studio", {{\*"\<\"\"\>", 
                  "ImageUrlSmall"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00000ILBL.01.THUMBZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlMedium"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00000ILBL.01.MZZZZZZZ.jpg", \
{{\*"\<\"\"\>", 
                  "ImageUrlLarge"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "http://images.amazon.com/images/P/B00000ILBL.01.LZZZZZZZ.jpg", \
{{\*"\<\"\"\>", "ListPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$19.99", {{\*"\<\"\"\>", 
                  "OurPrice"}, {{"http://www.w3.org/1999/XMLSchema-instance", 
                      "type"} \[Rule] "xsd:string"}} \[Rule] 
              "$17.39", {{\*"\<\"\"\>", 
                  "Availability"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] 
              "Usually ships within 24 hours", {{\*"\<\"\"\>", 
                  "UsedPrice"}, \
{{"http://www.w3.org/1999/XMLSchema-instance", "type"} \[Rule] 
                    "xsd:string"}} \[Rule] "$10.98"}}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:1.3.1.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simple Type Mapping", "Subsubsection",
  CellTags->"b:1.3.1.4"],

Cell[TextData[{
  "The main reason rule syntax can use types such as integers, reals, and so \
on is because web services define strong types. Through SOAP encoding and \
WSDL files, data passed as parameters and returned as results is strongly \
typed. This means that either the data encoding or the WSDL file tells the \
client how to decode the data. This allows the client to serialize ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " types other than strings. It also allows the client to deserialize the \
XML types into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " types.  WSDL files also minimize the use of attributes allowing the basic \
rule syntax to contain a simple name and value rule."
}], "Text",
  CellTags->"b:1.3.1.4"],

Cell[BoxData[
    \(Needs["\<WebServices`\>"]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"b:1.3.1.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://terraservice.net/TerraService.asmx?WSDL\>"]\)],\
 "Input",
  CellLabel->"In[13]:=",
  CellTags->"b:1.3.1.4"],

Cell[BoxData[
    \({ConvertLonLatPtToNearestPlace, ConvertLonLatPtToUtmPt, 
      ConvertUtmPtToLonLatPt, ConvertPlaceToLonLatPt, CountPlacesInRect, 
      GetAreaFromPt, GetAreaFromRect, GetAreaFromTileId, GetLatLonMetrics, 
      GetPlaceFacts, GetPlaceList, GetPlaceListInRect, GetTheme, 
      GetTileMetaFromLonLatPt, GetTileMetaFromTileId, GetTile}\)], "Output",
  CellLabel->"Out[13]=",
  CellTags->"b:1.3.1.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ConvertUtmPtToLonLatPt[{"\<Zone\>" -> 47, "\<X\>" -> 
            480615.19670402736, "\<Y\>" -> 11114177.470906643}] // 
      InputForm\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"b:1.3.1.4"],

Cell["{\"Lon\" -> 98.9999999999999, \"Lat\" -> 89.99999999999997}", "Output",
  CellLabel->"Out[14]//InputForm=",
  CellTags->"b:1.3.1.4"]
}, Open  ]],

Cell[TextData[{
  "When the results are returned from the web service, XML is deserialized \
into rule syntax.  XML-base types are mapped into ",
  StyleBox["Mathematica-",
    FontSlant->"Italic"],
  "base types. The mappings for XML to ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "are defined in the following table. The base64 and base64binary types get \
decoded and stored as a string."
}], "Text",
  CellTags->"b:1.3.1.4"],

Cell[BoxData[GridBox[{
        {\(XML\ type\), 
          StyleBox[\(Mathematica\ Type\),
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}boolean"], 
          StyleBox[\(True, \ False\),
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}double"], 
          StyleBox["Real",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}float"], 
          StyleBox["Real",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}decimal"], 
          StyleBox["Real",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}int"], 
          StyleBox["Integer",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}integer"], 
          StyleBox["Integer",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}long"], 
          StyleBox["Integer",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}short"], 
          StyleBox["Integer",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}byte"], 
          StyleBox["Integer",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}nonPositiveInteger"], 
          StyleBox["Integer",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}negativeInteger"], 
          StyleBox["Integer",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}nonNegativeInteger"], 
          StyleBox["Integer",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}unsignedLong"], 
          StyleBox["Integer",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}unsignedInteger"], 
          StyleBox["Integer",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}unsignedInt"], 
          StyleBox["Integer",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}unsignedShort"], 
          StyleBox["Integer",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}unsignedByte"], 
          StyleBox["Integer",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}base64Binary"], 
          StyleBox[\(Decoded\ String\),
            FontFamily->"Courier"]},
        {Cell["{http://schemas.xmlsoap.org/soap/encoding/}base64"], 
          StyleBox[\(Decoded\ String\),
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}string"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}duration"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}dateTime"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}time"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}date"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}gYearMonth"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}gYear"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}gMonthDay"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}gDay"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}gMonth"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}hexBinary"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}anyURI"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}QName"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}normalizedString"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}token"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}language"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}Name"], 
          StyleBox["String",
            FontFamily->"Courier"]},
        {Cell["{http://www.w3.org/1999/XMLSchema}NCName"], 
          StyleBox["String",
            FontFamily->"Courier"]}
        },
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Text",
  TextAlignment->Center,
  CellTags->"b:1.3.1.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell["XML Schema support", "Subsubsection",
  CellTags->"b:1.3.1.5"],

Cell["\<\
WSDL files define data types using XML Schema. So XML Schema plays a big role \
in how web services work. XML Schema is a very large complex specification. \
It has many parts that fit very well with functional languages. However, some \
parts of the XML Schema specification are not easily implemented in a \
functional language. Therefore, the XML Schema is not completely supported in \
the Web Services Package. More support will be added as it becomes possible \
or needed. This section describes which features of XML Schema are supported \
and which are not.  \
\>", "Text",
  CellTags->"b:1.3.1.5"],

Cell["\<\
One more thing to consider for each of these features is that the Web \
Services Package does not validate the data types created using the XML \
Schema. So values of a particular data type are not checked to make sure they \
meet requirements set in the XML Schema specification and XML schema \
definitions provided by a WSDL. This may change in the future.\
\>", "Text",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  StyleBox["Built-in datatypes specified in XML Schema Part 2: Datatypes \
specification",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Examples",
    FontSlant->"Italic"],
  ": boolean, double, float, decimal, int, integer, long, short, byte, \
nonPositiveInteger, negativeInteger, nonNegativeInteger, unsignedLong, \
unsignedInteger, unsignedInt, unsignedShort, base64Binary, string, duration, \
dateTime, time, date, gYearMonth, gYear, gMonthDay, gDay, gMonth, hexBinary, \
anyURI, QName, normalizedString, token, language, Name, NCName.\n",
  StyleBox["Supported",
    FontSlant->"Italic"],
  ": Yes, this is supported and is documented in",
  StyleBox[" ",
    FontSlant->"Italic"],
  "the ",
  ButtonBox["Simple Type Mapping",
    ButtonData:>"b:1.3.1.4",
    ButtonStyle->"Hyperlink"],
  " section."
}], "Text",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  StyleBox["Enumeration\n",
    FontWeight->"Bold"],
  StyleBox["Example",
    FontSlant->"Italic"],
  ": \n",
  "      <simpleType name=\"Method\">\n        <restriction base=\"xsd:string\
\">\n          <enumeration value=\"And\"/>\n          <enumeration \
value=\"Or\"/>\n          <enumeration value=\"Boolean\"/>\n        \
</restriction>\n      </simpleType>\n",
  StyleBox["Supported",
    FontSlant->"Italic"],
  ": Yes, this is supported.  This is used within the OperationPalette.  The \
OperationPalette will list the valid enumeration values under the type name."
}], "Text",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  StyleBox["<xsd:complexType> with elements of both simple and complex types\n\
",
    FontWeight->"Bold"],
  StyleBox["Example",
    FontSlant->"Italic"],
  ":",
  StyleBox["\n",
    FontWeight->"Bold"],
  "      <complexType name=\"WolframSearchOptions\">\n        <sequence>\n    \
      <element minOccurs=\"0\" maxOccurs=\"1\" name=\"limit\" \
type=\"xsd:int\"/>\n          <element minOccurs=\"0\" maxOccurs=\"1\" \
name=\"set\" type=\"xsd:int\"/>\n          <element minOccurs=\"0\" \
maxOccurs=\"1\" name=\"category\" type=\"xsd:string\"/>\n          <element \
minOccurs=\"0\" maxOccurs=\"1\" name=\"returnTypes\" \
type=\"wolfram:ReturnTypeArray\"/>\n          <element minOccurs=\"0\" \
maxOccurs=\"1\" name=\"keywords\" type=\"wolfram:StringArray\"/>\n          \
<element minOccurs=\"0\" maxOccurs=\"1\" name=\"method\" \
type=\"wolfram:Method\"/>\n          <element minOccurs=\"0\" maxOccurs=\"1\" \
name=\"exclude\" type=\"wolfram:StringArray\"/>\n          <element \
minOccurs=\"0\" maxOccurs=\"1\" name=\"restrict\" \
type=\"wolfram:StringArray\"/>\n          <element minOccurs=\"0\" maxOccurs=\
\"1\" name=\"startYear\" type=\"xsd:int\"/>\n          <element minOccurs=\"0\
\" maxOccurs=\"1\" name=\"startMonth\" type=\"xsd:int\"/>\n          <element \
minOccurs=\"0\" maxOccurs=\"1\" name=\"startDay\" type=\"xsd:int\"/>\n        \
  <element minOccurs=\"0\" maxOccurs=\"1\" name=\"endYear\" \
type=\"xsd:int\"/>\n          <element minOccurs=\"0\" maxOccurs=\"1\" \
name=\"endMonth\" type=\"xsd:int\"/>\n          <element minOccurs=\"0\" \
maxOccurs=\"1\" name=\"endDay\" type=\"xsd:int\"/>\n          <element \
minOccurs=\"0\" maxOccurs=\"1\" name=\"sortBy\" type=\"wolfram:SortBy\"/>\n   \
     </sequence>\n      </complexType>\n",
  StyleBox["Supported: ",
    FontSlant->"Italic"],
  "Yes, this is supported. This is used to build the templates that are \
featured in the OperationPalette.  This is also used to serialize and \
deserialize data. This is used when binding XML Schema types to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " types and vice-versa."
}], "Text",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  StyleBox["<xsd:attribute> in <xsd:complexType>\n",
    FontWeight->"Bold"],
  StyleBox["Example: ",
    FontSlant->"Italic"],
  "\n      <complexType name=\"Address\">\n        <sequence>\n          \
<element minOccurs=\"0\" maxOccurs=\"1\" name=\"name\" type=\"xsd:string\"/>\n\
          <element minOccurs=\"0\" maxOccurs=\"1\" name=\"street\" \
type=\"xsd:string\"/>\n          <element minOccurs=\"0\" maxOccurs=\"1\" \
name=\"city\" type=\"xsd:string\"/>\n          <element minOccurs=\"0\" \
maxOccurs=\"1\" name=\"state\" type=\"xsd:string\"/>\n          <element \
minOccurs=\"0\" maxOccurs=\"1\" name=\"zip\" type=\"xsd:string\"/>\n          \
<xsd:attribute name=\"country\" type=\"xsd:NMTOKEN\" fixed=\"US\" />\n        \
</sequence>\n      </complexType>\n",
  StyleBox["Supported: ",
    FontSlant->"Italic"],
  "Yes, although this is not supported directly. If a user wants to submit an \
attribute as input, then the ",
  StyleBox["LongForm",
    FontFamily->"Courier"],
  " option must be used. If attributes are returned in output, then the ",
  StyleBox["LongForm",
    FontFamily->"Courier"],
  " option should be set to ",
  StyleBox["True",
    FontFamily->"Courier"],
  " to see this data. Attributes will always be strings. There is no type \
mapping associated with attributes. Attributes are not generated with the \
OperationPalette templates. A web service with an attribute defined in this \
way should not prevent use of the service."
}], "Text",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  StyleBox["Occurance Contraints for xsd:element: minOccurs, maxOccurs, \
default, fixed\n",
    FontWeight->"Bold"],
  StyleBox["Example:",
    FontSlant->"Italic"],
  StyleBox["\n",
    FontWeight->"Bold"],
  "      <complexType name=\"Address\">\n        <sequence>\n          \
<element minOccurs=\"0\" maxOccurs=\"1\" name=\"name\" type=\"xsd:string\"/>\n\
          <element minOccurs=\"0\" maxOccurs=\"1\" name=\"street\" \
type=\"xsd:string\"/>\n          <element minOccurs=\"0\" maxOccurs=\"1\" \
name=\"city\" type=\"xsd:string\"/>\n          <element minOccurs=\"0\" \
maxOccurs=\"1\" name=\"state\" type=\"xsd:string\"/>\n          <element \
minOccurs=\"0\" maxOccurs=\"1\" name=\"zip\" type=\"xsd:string\"/>\n        \
</sequence>\n      </complexType>\n",
  StyleBox["Supported: ",
    FontSlant->"Italic"],
  "Yes, although not directly. maxOccurs is used to determine if a type is an \
array. minOccurs is not used but it could be used for documentation along \
with maxOccurs. minOccurs could also be used to generate a smaller template \
in the OperationPalette for a given type. However, currently minOccurs is not \
used. This should not impact a user using a particular data type. The default \
and fixed attributes have not been considered for the Web Services Package. \
So if the default attribute is set and a value is missing, a default value \
will not be used with input or output. This could be added in the future. A \
web service with these attributes defined in this way should not prevent use \
of the service."
}], "Text",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  StyleBox["<xsd:ref> attribute for reference to global elements\n",
    FontWeight->"Bold"],
  StyleBox["Example:\n      ",
    FontSlant->"Italic"],
  "<complexType name=\"Expr\"> \n        <sequence> \n          <element \
maxOccurs=\"1\" ref=\"wolfram:Expression\" /> \n        </sequence> \n      \
</complexType>\n",
  StyleBox["Supported: ",
    FontSlant->"Italic"],
  "Yes, this is supported. If there is a ref defined, then the code will find \
the referenced element and use it instead of the element containing the ref. \
This is used for type mapping and generating templates in OperationPalette."
}], "Text",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  StyleBox["Derivation of new simple types by restriction of an existing \
simple type\n",
    FontWeight->"Bold"],
  StyleBox["Example:",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n      <",
    FontWeight->"Bold"],
  "xsd:simpleType name=\"myInteger\"",
  StyleBox[">\n",
    FontWeight->"Bold"],
  "        <xsd:restriction base=\"xsd:integer\">\n          \
<xsd:minInclusive value=\"10000\"/>\n          <xsd:maxInclusive \
value=\"99999\"/>\n        </xsd:restriction>\n      </xsd:simpleType>\n",
  StyleBox["Supported: ",
    FontSlant->"Italic"],
  "Yes, this is supported. The Web Services Package uses this specifically \
when generating templates in the OperationPalette. If a type is restricted to \
a base type, it will use the same template as the base type.  This is not \
used specifically in type mapping. However, there may be some use for it in \
the future. A web service with a type defined such as this should not prevent \
use of the service."
}], "Text",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  "Facets used with restriction element\n",
  StyleBox["Example:\n",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["   ",
    FontWeight->"Bold"],
  StyleBox["   <xsd:simpleType name=\"myInteger\">\n        <xsd:restriction \
base=\"xsd:integer\">\n          <xsd:minInclusive value=\"10000\"/>\n        \
  <xsd:maxInclusive value=\"99999\"/>\n        </xsd:restriction>\n      \
</xsd:simpleType>",
    FontWeight->"Plain"],
  StyleBox["\nSupported: ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["Yes, this is supported.  However, the Web Services Package does \
not use facets for type mapping. The only facet used is enumeration for \
documentation in the OperationPalette. A web service with a facet defined \
such as this should not prevent use of the service. These may be more useful \
to the Web Services Package if validation is used.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  StyleBox["List Type <xsd:list>\n",
    FontWeight->"Bold"],
  StyleBox["Example:\n",
    FontSlant->"Italic"],
  "      <xsd:simpleType name=\"listOfMyIntType\">\n        <xsd:list \
itemType=\"myInteger\"/>\n      </xsd:simpleType>\n      <listOfMyInt>20003 \
15037 95977 95945</listOfMyInt>\n",
  StyleBox["Supported: ",
    FontSlant->"Italic"],
  "No, this is not supported. ",
  StyleBox["A web service with a list defined such as this could prevent a \
user from using the service in Web Services Package. It could affect type \
mapping, documentation, and template generation.",
    FontWeight->"Plain"]
}], "Text",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  StyleBox["Union Type <xsd:union>\n",
    FontWeight->"Bold"],
  StyleBox["Example:\n",
    FontSlant->"Italic"],
  "      <xsd:simpleType name=\"zipUnion\">\n        <xsd:union \
memberTypes=\"Address listOfMyIntType\"/>\n      </xsd:simpleType>\n",
  StyleBox["Supported: ",
    FontSlant->"Italic"],
  "No, this is not supported. ",
  StyleBox["A web service with a union defined such as this could prevent a \
user from using the service in Web Services Package. It could affect type \
mapping, documentation, and template generation.",
    FontWeight->"Plain"]
}], "Text",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  "Derivation of a complex type from a simple type\n",
  StyleBox["Example:\n",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["      <xsd:complexType name=\"internationalPrice\">\n        \
<xsd:simpleContent>\n          <xsd:extension base=\"xsd:decimal\">\n         \
   <xsd:attribute name=\"currency\" type=\"xsd:string\"/>\n          \
</xsd:extension>\n        </xsd:simpleContent>\n      </xsd:complexType>\n",
    FontWeight->"Plain"],
  StyleBox["Supported: ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["No, this is not supported. A web service with a complex type \
defined such as this could prevent a user from using the service in Web \
Services Package. It could affect type mapping, documentation, and template \
generation.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  StyleBox["<xsd:anyType>\n",
    FontWeight->"Bold"],
  StyleBox["Example:\n",
    FontSlant->"Italic"],
  "      <xsd:element name=\"anything\" type=\"xsd:anyType\"/>\n",
  StyleBox["Supported: ",
    FontSlant->"Italic"],
  StyleBox["No, this is not supported. A web service with an element defined \
such as this could prevent a user from using the service in Web Services \
Package. It could affect type mapping, documentation, and template \
generation.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Plain",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  "<xsd:sequence>\n",
  StyleBox["Example:\n      ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["<xsd:complexType name=\"PurchaseOrderType\">\n        \
<xsd:sequence>\n          <xsd:element name=\"shipTo\" type=\"USAddress\"/>\n \
         <xsd:element name=\"billTo\" type=\"USAddress\"/>\n          \
<xsd:element name=\"items\" type=\"Items\"/>\n        </xsd:sequence>\n      \
</xsd:complexType>\n",
    FontWeight->"Plain"],
  StyleBox["Supported: ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["Yes, this is supported. If a complexType is defined as a sequence \
of elements, the type can be used within the Web Services Package. This is \
used during type mapping, documentation, and template generation.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  StyleBox["<xsd:choice>\n",
    FontWeight->"Bold"],
  StyleBox["Example:\n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["      ",
    FontWeight->"Bold"],
  "<xsd:complexType name=\"PurchaseOrderType\">\n        <sequence>\n         \
 <xsd:choice>\n            <xsd:group ref=\"shipAndBill\">\n            \
<xsd:element name=\"singleUSAddress\" type=\"USAddress\"/>\n          \
</xsd:choice>\n        </xsd:sequence>\n      </xsd:complexType>\n",
  StyleBox["Supported: ",
    FontSlant->"Italic"],
  StyleBox["No, this is not supported. A web service with a complexType \
defined such as this could prevent a user from using the service in Web \
Services Package. It could affect type mapping, documentation, and template \
generation.",
    FontWeight->"Plain"]
}], "Text",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  "<xsd:group>\n",
  StyleBox["Example:\n      ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["<xsd:group name=\"shipAndBill\">\n        <sequence>\n          \
<xsd:element name=\"shipTo\" type=\"USAddress\"/>\n          <xsd:element \
name=\"billTo\" type=\"USAddress\"/>\n        </sequence>\n      </xsd:group>\
\n",
    FontWeight->"Plain"],
  StyleBox["Supported: ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["No, this is not supported. A web service with a complexType \
defined such as this could prevent a user from using the service in Web \
Services Package. It could affect type mapping, documentation, and template \
generation.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  "<xsd:all>\n",
  StyleBox["Example:\n      ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["<xsd:complexType name=\"PurchaseOrderType\">\n        <xsd:all>\n \
         <xsd:element name=\"shipTo\" type=\"USAddress\"/>\n          \
<xsd:element name=\"billTo\" type=\"USAddress\"/>\n          <xsd:element \
name=\"items\" type=\"Items\"/>\n        </xsd:all>\n      <xsd:complexType>\n\
",
    FontWeight->"Plain"],
  StyleBox["Supported: ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["Yes, this is supported.  If a complexType is defined with all, \
the type can be used within the Web Services Package. This is used during \
type mapping, documentation, and template generation.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  "xsd:nil and xsd:nillable attribute\n",
  StyleBox["Example:\n      ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["<xsd:element name=\"shipDate\" type=\"xsd:date\" \
nillable=\"true\"/>\n      <shipDate xsi:nil=\"true\"/>\n",
    FontWeight->"Plain"],
  StyleBox["Supported: ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["Yes, this is supported.  During serialization of ",
    FontWeight->"Plain"],
  StyleBox["Mathematica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" data into XML, if a value is ",
    FontWeight->"Plain"],
  StyleBox["Null",
    FontFamily->"Courier",
    FontWeight->"Plain"],
  StyleBox[" for a piece of data that corresponds to an XML Schema element \
that is nillable, then an xsi:nil attribute is set to true in the XML.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  "Derivation of complex types by extension\n",
  StyleBox["Example: \n      ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["<complexType name=\"Address\">\n        <sequence>\n          \
<element name=\"name\" type=\"string\"/>\n          <element name=\"street\" \
type=\"string\"/>\n          <element name=\"city\" type=\"string\"/>\n       \
 </sequence>\n      </complexType>\n      <complexType name=\"USAddress\">\n  \
      <complexContent>\n          <extension base=\"Address\">\n            \
<sequence>\n              <element name=\"state\" type=\"USState\"/>\n        \
      <element name=\"zip\" type=\"positiveInteger\"/>\n            \
</sequence>\n          </extension>\n        </complexContent>\n      \
</complexType>\n      <complexType name=\"UKAddress\">\n        \
<complexContent>\n          <extension base=\"Address\">\n            \
<sequence>\n              <element name=\"postcode\" type=\"UKPostcode\"/>\n  \
          </sequence>\n          </extension>\n        </complexContent>\n    \
  </complexType>\n",
    FontWeight->"Plain"],
  StyleBox["Supported: ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["No, this is not supported. A web service with a complex type \
defined such as this could prevent a user from using the service in Web \
Services Package. It could affect type mapping, documentation, and template \
generation.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  StyleBox["Derivation of complex types by restriction\n",
    FontWeight->"Bold"],
  StyleBox["Example:\n",
    FontSlant->"Italic"],
  "      <complexType name=\"ConfirmedItems\">\n        <complexContent>\n    \
      <restriction base=\"Items\">\n            <sequence>\n              \
<!-- item element is different than in Items -->\n              <element \
name=\"item\" minOccurs=\"1\" maxOccurs=\"unbounded\"/>\n              <!-- \
remainder of definition is same as Items -->\n              <complexType>\n   \
             <sequence>\n                  <element name=\"productName\" \
type=\"string\"/>\n                  <element name=\"quantity\" \
type=\"positiveInteger\"/>\n                </sequence>\n              \
</complexType>\n            </sequence>\n          </restriction>\n        \
</complexContent>\n      </complexType>\n",
  StyleBox["Supported: ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["No, this is not supported. A web service with a complex type \
defined such as this could prevent a user from using the service in Web \
Services Package. It could affect type mapping, documentation, and template \
generation.",
    FontWeight->"Plain"]
}], "Text",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  "Abstract Types\n",
  StyleBox["Example:\n      ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["<complexType name=\"Vehicle\" abstract=\"true\"/>\n      \
<complexType name=\"Car\">\n        <complexContent>\n          <extension \
base=\"target:Vehicle\"/>\n        </complexContent>\n      </complexType>\n  \
    <complexType name=\"Plane\">\n        <complexContent>\n          \
<extension base=\"target:Vehicle\"/>\n        </complexContent>\n      \
</complexType>\n",
    FontWeight->"Plain"],
  StyleBox["Supported: ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["No, this is not supported. A web service with a complex type \
defined such as this could prevent a user from using the service in Web \
Services Package. It could affect type mapping, documentation, and template \
generation.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.1.5"],

Cell[TextData[{
  "Creation and use of derived types: final attribute, fixed attribute, and \
block attribute\n",
  StyleBox["Example:\n      ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["<complexType name=\"Address\" final=\"restriction\">\n        \
<sequence>\n          <element name=\"name\" type=\"string\"/>\n          \
<element name=\"street\" type=\"string\"/>\n          <element name=\"city\" \
type=\"string\"/>\n        </sequence>\n      </complexType>\n",
    FontWeight->"Plain"],
  StyleBox["Supported: ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["No, this is not supported. A web service with a complex type \
defined such as this could prevent a user from using the service in Web \
Services Package. It could affect type mapping, documentation, and template \
generation.",
    FontWeight->"Plain"]
}], "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.1.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Arrays", "Subsubsection",
  CellTags->"b:1.3.1.6"],

Cell[TextData[{
  "Arrays have special considerations within the Web Services Package. It is \
important for arrays to look like lists, which are familiar and convenient to \
users of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". One difference between arrays and other data types is arrays consist of \
only values in ",
  StyleBox["Mathematica. ",
    FontSlant->"Italic"],
  "Therefore, a user is only required to provide a list of values for arrays \
when using an array as an input to a function",
  StyleBox[". ",
    FontSlant->"Italic"],
  "Users are not required to provide names for each value of an array. When \
an array is returned as output, it is returned as a list of values as well. "
}], "Text",
  CellTags->"b:1.3.1.6"],

Cell[BoxData[
    \(Needs["\<WebServices`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:1.3.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://webservices.wolfram.com/services/\
SearchServices/WolframSearch2.wsdl\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"b:1.3.1.6"],

Cell[BoxData[
    \({GetCollections, GetLanguages, GetModes, GetMatchLocations, 
      GetReturnTypes, WolframQuickSearch, WolframSearch}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"b:1.3.1.6"]
}, Open  ]],

Cell[TextData[{
  StyleBox["WolframSearch",
    FontFamily->"Courier"],
  " can specify ",
  StyleBox["ReturnTypes",
    FontFamily->"Courier New"],
  " as a list of strings. It then returns a ",
  StyleBox["WolframSearchResult",
    FontFamily->"Courier"],
  " object. This object contains an array of ",
  StyleBox["WolframSearchMatch",
    FontFamily->"Courier New"],
  " objects."
}], "Text",
  CellTags->"b:1.3.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(WolframSearch[{"\<Query\>" \[Rule] "\<Wolfram Research\>", \ \
"\<Limit\>" \[Rule] 
          3, \ "\<ReturnTypes\>" \[Rule] {"\<Title\>", \ "\<URL\>"}}]\)], \
"Input",
  CellLabel->"In[3]:=",
  CellTags->"b:1.3.1.6"],

Cell[BoxData[
    \({"SearchTime" \[Rule] 0.050879`, "TotalMatches" \[Rule] 79500, 
      "Matches" \[Rule] {{"Title" \[Rule] 
              "<b>Wolfram</b> <b>Research</b>, Inc.", 
            "URL" \[Rule] "http://www.wolfram.com/"}, {"Title" \[Rule] 
              "Exploring Mathematics and Science with Mathematica", 
            "URL" \[Rule] 
              "http://www.wolfram.com/services/seminars/india2005/"}, \
{"Title" \[Rule] 
              "<b>Wolfram</b> <b>Research</b> Documentation Center: A \
Collection of Online <b>...</b>", 
            "URL" \[Rule] "http://documents.wolfram.com/"}}}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:1.3.1.6"]
}, Open  ]],

Cell["\<\
Something more familiar for output may be a simple string array.  This is \
demonstrated here.\
\>", "Text",
  CellTags->"b:1.3.1.6"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GetCollections[]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:1.3.1.6"],

Cell[BoxData[
    \({"Main Wolfram Site", "Wolfram Store", "Information Center", 
      "Documentation Center", "Mathematica 5 Documentation", 
      "Mathematica 6 Documentation", "Technical FAQs", 
      "All Wolfram websites", "Wolfram Forums", "MathGroup Archives", 
      "MathWorld/ScienceWorld", "Mathematical Functions", 
      "WolframScience.com", "StephenWolfram.com", 
      "All Wolfram Resources"}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:1.3.1.6"]
}, Open  ]],

Cell[TextData[{
  "Arrays can be defined in different ways within the WSDL file. The Web \
Services Package recognizes arrays that are defined in two different ways. \
The first way arrays can be recognized is using literal schema. The type \
definition will be a sequence of one element that has a ",
  StyleBox["maxOccurs",
    FontFamily->"Courier"],
  " attribute set to greater than 1 or unbounded. This is the preferred way \
to create arrays as specified in the WS-I Profiles guidelines. This is \
generally used with a doc/lit web service."
}], "Text",
  CellTags->"b:1.3.1.6"],

Cell["\<\
      <complexType name=\"StringArray\">
        <sequence>
          <element minOccurs=\"0\" maxOccurs=\"unbounded\" 
                   name=\"str\" type=\"xsd:string\"/>
        </sequence>
      </complexType>\
\>", "Text",
  FontFamily->"Courier New",
  CellTags->"b:1.3.1.6"],

Cell["\<\
The second way is with SOAP-encoded web services. These web services encode \
an array with an arrayType attribute and it is restricted to be a \
SOAP-encoded array. This method of encoding arrays is not the preferred \
method of using arrays with web services according to the WS-I Profiles \
guidelines. This is generally used with a rpc/encoded web service, which is \
also not recommended by the WS-I Profiles. However, since there are some nice \
rpc/encoded web services available, it is supported by the Web Services \
Package.\
\>", "Text",
  CellTags->"b:1.3.1.6"],

Cell["\<\
      <xsd:complexType name=\"ProductLineArray\">
        <xsd:complexContent>
          <xsd:restriction base=\"soapenc:Array\">
        \t<xsd:attribute ref=\"soapenc:arrayType\" 
\t                       wsdl:arrayType=\"typens:ProductLine[]\"/>
          </xsd:restriction>
        </xsd:complexContent>
      </xsd:complexType>\
\>", "Text",
  FontFamily->"Courier New",
  CellTags->"b:1.3.1.6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Expressions", "Subsubsection",
  CellTags->"b:1.3.1.7"],

Cell[TextData[{
  "Expressions are the foundation of the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " language and offer a very nice way to represent mathematical data and \
functions. Expressions can be represented using strings or ExpressionML in a \
web service. Representing an expression as a string has an nice advantage \
because it is simple and easy to read.  However, it is not as powerful as \
ExpressionML. Using ExpressionML, an expression can be recognized and \
validated using XML Schema or a DTD. The Web Services Package expects ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions to be represented by ExpressionML within a web service. So \
when the Web Services Package comes across ExpressionML, it converts it to an \
expression that a user can use like any other expression in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  When a web service expects an expression as input, the user can pass an \
expression as input and it will be converted to ExpressionML."
}], "Text",
  CellTags->"b:1.3.1.7"],

Cell[BoxData[
    \(<< WebServices`\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:1.3.1.7"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://webservices.wolfram.com/services/Integrator/\
Integrate.m?wsdl\>"]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->"b:1.3.1.7"],

Cell[BoxData[
    \({IntegrateExpression, IntegrateExpressionToGIF, IntegrateMathML, 
      IntegrateMathMLToGIF, IntegrateString, 
      IntegrateStringToGIF}\)], "Output",
  CellLabel->"Out[28]=",
  CellTags->"b:1.3.1.7"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?IntegrateExpression\)\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:1.3.1.7"],

Cell[BoxData["\<\"Integrates an equation with respect to x. The function is \
passed in as an InputForm Expression and the result is an InputForm \
Expression.\\n\\nPlease refer to \
\!\(\*ButtonBox[\\\"OperationPalette[IntegrateExpression]\\\",           \
Active->True,            ButtonEvaluator->Automatic,           \
ButtonFunction->OperationPalette[IntegrateExpression],           \
ButtonStyle->\\\"Hyperlink\\\"]\) for help.\"\>"], "Print",
  CellTags->{"Info3278164772-8849540", "b:1.3.1.7"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(IntegrateExpression[Sin[x]]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:1.3.1.7"],

Cell[BoxData[
    \(\(-Cos[x]\)\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:1.3.1.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MathML", "Subsubsection",
  CellTags->"b:1.3.1.8"],

Cell[TextData[{
  "MathML is an important technology that standardizes mathematical data \
representation. Since MathML is a public specification and not a proprietary \
specification, many applications support its use. MathML promotes \
interoperability between applications with interest in mathematical data \
representation. MathML is represented in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using symbolic XML and therefore symbolic XML is used as input and output \
of MathML in the Web Services Package."
}], "Text",
  CellTags->"b:1.3.1.8"],

Cell[BoxData[
    \(<< WebServices`\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"b:1.3.1.8"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://webservices.wolfram.com/services/Integrator/\
Integrate.m?wsdl\>"]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"b:1.3.1.8"],

Cell[BoxData[
    \({IntegrateExpression, IntegrateExpressionToGIF, IntegrateMathML, 
      IntegrateMathMLToGIF, IntegrateString, 
      IntegrateStringToGIF}\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->"b:1.3.1.8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?IntegrateMathML\)\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"b:1.3.1.8"],

Cell[BoxData["\<\"Integrates an equation with respect to x. The function is \
passed in as an MathML and the result is MathML.\\n\\nPlease refer to \
\!\(\*ButtonBox[\\\"OperationPalette[IntegrateMathML]\\\",           \
Active->True,            ButtonEvaluator->Automatic,           \
ButtonFunction->OperationPalette[IntegrateMathML],           \
ButtonStyle->\\\"Hyperlink\\\"]\) for help.\"\>"], "Print",
  CellTags->{"Info3278251906-4694478", "b:1.3.1.8"}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(mathml\  = \ 
      IntegrateMathML[
        XML`MathML`ExpressionToSymbolicMathML[Sin[x]]]\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->"b:1.3.1.8"],

Cell[BoxData[
    \(XMLElement[{"http://www.w3.org/1998/Math/MathML", 
        "math"}, {}, {XMLElement[{"http://www.w3.org/1998/Math/MathML", 
            "semantics"}, {}, \
{XMLElement[{"http://www.w3.org/1998/Math/MathML", 
                "mrow"}, {}, \
{XMLElement[{"http://www.w3.org/1998/Math/MathML", "mo"}, {}, {"-"}], 
                XMLElement[{"http://www.w3.org/1998/Math/MathML", 
                    "mrow"}, {}, \
{XMLElement[{"http://www.w3.org/1998/Math/MathML", "mi"}, {}, {"cos"}], 
                    XMLElement[{"http://www.w3.org/1998/Math/MathML", 
                        "mo"}, {}, {"\[InvisibleApplication]"}], 
                    XMLElement[{"http://www.w3.org/1998/Math/MathML", 
                        "mo"}, {}, {"("}], 
                    XMLElement[{"http://www.w3.org/1998/Math/MathML", 
                        "mi"}, {}, {"x"}], 
                    XMLElement[{"http://www.w3.org/1998/Math/MathML", 
                        "mo"}, {}, {")"}]}]}], 
            XMLElement[{"http://www.w3.org/1998/Math/MathML", 
                "annotation-xml"}, {"encoding" \[Rule] 
                  "MathML-Content"}, \
{XMLElement[{"http://www.w3.org/1998/Math/MathML", 
                    "apply"}, {}, \
{XMLElement[{"http://www.w3.org/1998/Math/MathML", "times"}, {}, {}], 
                    XMLElement[{"http://www.w3.org/1998/Math/MathML", 
                        "cn"}, {"type" \[Rule] "integer"}, {"-1"}], 
                    XMLElement[{"http://www.w3.org/1998/Math/MathML", 
                        "apply"}, {}, \
{XMLElement[{"http://www.w3.org/1998/Math/MathML", "cos"}, {}, {}], 
                        XMLElement[{"http://www.w3.org/1998/Math/MathML", 
                            "ci"}, {}, {"x"}]}]}]}]}]}]\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->"b:1.3.1.8"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(XML`MathML`SymbolicMathMLToExpression[mathml]\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->"b:1.3.1.8"],

Cell[BoxData[
    \(\(-Cos[x]\)\)], "Output",
  CellLabel->"Out[27]=",
  CellTags->"b:1.3.1.8"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Naming Services", "Subsection",
  CellTags->"b:1.3.2"],

Cell[TextData[{
  "There are two options for installing a web service. The first option \
allows the user to specify which context a web service will be installed \
into. This option may be utilized by supplying a second argument that \
specifies the context. The context should be specified using a string and \
must be defined under the legal rules specified by ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"b:1.3.2"],

Cell[BoxData[
    \(Needs["\<WebServices`\>"]\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"b:1.3.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://www.xmethods.net/sd/2001/BNQuoteService.wsdl\>\
", "\<BarnesAndNoble`\>"]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"b:1.3.2"],

Cell[BoxData[
    \({getPrice}\)], "Output",
  CellLabel->"Out[20]=",
  CellTags->"b:1.3.2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Context[getPrice]\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"b:1.3.2"],

Cell[BoxData[
    \("BarnesAndNoble`"\)], "Output",
  CellLabel->"Out[21]=",
  CellTags->"b:1.3.2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(getPrice["\<043935806X\>"]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"b:1.3.2"],

Cell[BoxData[
    \(17.99`\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->"b:1.3.2"]
}, Open  ]],

Cell[TextData[{
  "The second option available for installing a web service is the ",
  StyleBox["AllowShortContext",
    FontFamily->"Courier"],
  " option. By default the context of a web service is added to the ",
  StyleBox["$ContextPath",
    FontFamily->"Courier"],
  ". This allows users to call the functions using short names. However, if a \
user does not want the web service context added to ",
  StyleBox["$ContextPath",
    FontFamily->"Courier"],
  ", then the user should set",
  StyleBox[" AllowShortContext->False",
    FontFamily->"Courier New"],
  ". If this option is set to ",
  StyleBox["False",
    FontFamily->"Courier New"],
  ", then the entire context will need to be specified in order to call a \
function.  "
}], "Text",
  CellTags->"b:1.3.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://www.xmethods.net/sd/2001/\
CurrencyExchangeService.wsdl\>", AllowShortContext \[Rule] False]\)], "Input",\

  CellLabel->"In[4]:=",
  CellTags->"b:1.3.2"],

Cell[BoxData[
    \({CurrencyExchangeService`CurrencyExchangePort`getRate}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"b:1.3.2"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CurrencyExchangeService`CurrencyExchangePort`getRate["\<us\>", \
"\<england\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:1.3.2"],

Cell[BoxData[
    \(0.5571`\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:1.3.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Working with Messages", "Subsection",
  CellTags->"b:1.3.3"],

Cell[TextData[{
  "Sometimes it is useful to work directly with the request message that is \
sent to a web service. This message may be retrieved using the ",
  StyleBox["ToServiceRequest",
    FontFamily->"Courier New"],
  " function. ",
  StyleBox["ToServiceRequest",
    FontFamily->"Courier"],
  " is called by providing a web service function as the first parameter and \
its parameters as the additional parameters. The function will not invoke the \
web service operation. Rather the function will return the symbolic XML \
representation of the request message that would generally be sent to the web \
service."
}], "Text",
  CellTags->"b:1.3.3"],

Cell[BoxData[
    \(Needs["\<WebServices`\>"]\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->"b:1.3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://www.xmethods.net/sd/2001/CATrafficService.wsdl\
\>"]\)], "Input",
  CellLabel->"In[26]:=",
  CellTags->"b:1.3.3"],

Cell[BoxData[
    \({getTraffic}\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->"b:1.3.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(symbolicXML\  = ToServiceRequest[getTraffic, "\<101\>"]\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->"b:1.3.3"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"soapenv", 
          "Envelope"}, {{"xmlns", "soapenv"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", {"xmlns", 
              "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema", {"xmlns", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", {"xmlns", 
              "soapenc"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/encoding/"}, \
{XMLElement[{"soapenv", 
              "Body"}, {}, {XMLElement[{"ns0", 
                  "getTraffic"}, {{"soapenv", "encodingStyle"} \[Rule] 
                    "http://schemas.xmlsoap.org/soap/encoding/", {"xmlns", 
                      "ns0"} \[Rule] 
                    "urn:xmethods-CATraffic"}, {XMLElement[{\*"\<\"\"\>", 
                      "hwynums"}, {{"xsi", "type"} \[Rule] 
                        "xsd:string"}, {"101"}]}]}]}], {}]\)], "Output",
  CellLabel->"Out[27]=",
  CellTags->"b:1.3.3"]
}, Open  ]],

Cell[TextData[{
  "A user may change the request message to have different values or \
different attributes. In fact, the user may create an entirely new message. \
However, the message must still follow the format specified in the SOAP \
specification. Using ",
  StyleBox["ToServiceRequest",
    FontFamily->"Courier"],
  " gives the user a nice starting point. The request message can then be \
invoked using the ",
  StyleBox["InvokeServiceOperation",
    FontFamily->"Courier"],
  " function. The first parameter of this function is the symbol representing \
a web service function. The web service function specifies the endpoint URI \
internally along with other options for invoking the service. The second \
argument is the symbolic XML representation of the request message."
}], "Text",
  CellTags->"b:1.3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InvokeServiceOperation["\<http://services.xmethods.net:80/soap/servlet/\
rpcrouter\>", symbolicXML]\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->"b:1.3.3"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
          "Envelope"}, {{"http://www.w3.org/2000/xmlns/", "SOAP-ENV"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", \
{"http://www.w3.org/2000/xmlns/", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", \
{"http://www.w3.org/2000/xmlns/", "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema"}, \
{XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
              "Body"}, {}, {XMLElement[{"urn:xmethods-CATraffic", 
                  "getTrafficResponse"}, \
{{"http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"} \[Rule] 
                    "http://schemas.xmlsoap.org/soap/encoding/", \
{"http://www.w3.org/2000/xmlns/", "ns1"} \[Rule] 
                    "urn:xmethods-CATraffic"}, {XMLElement[{\*"\<\"\"\>", 
                      "return"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", "type"} \[Rule] 
                        "xsd:string"}, {"reported as of Friday, November 7, \
2003 at 15:17 . Slow for the Cone Zone US 101 [LOS ANGELES & VENTURA CO.'S] \
NO TRAFFIC RESTRICTIONS ARE REPORTED FOR THIS AREA. [CENTRAL COAST] NO \
TRAFFIC RESTRICTIONS ARE REPORTED FOR THIS AREA. [SAN FRANCISCO BAY AREA] THE \
SOUTHBOUND CONNECTOR TO EASTBOUND SR 152 /IN GILROY/ (SANTA CLARA CO) IS \
CLOSED FROM 2200 HRS EACH NIGHT TO 0500 HRS EACH MORNING THRU 11/8/03 - DUE \
TO CONSTRUCTION - A DETOUR IS AVAILABLE IS CLOSED FROM BERNAL RD TO THE JCT \
OF SR 85 /IN SAN JOSE/ (SANTA CLARA CO) FROM 0001 HRS TO 0500 HRS THRU \
11/8/03 - DUE TO CONSTRUCTION - A DETOUR IS AVAILABLE THE NORTHBOUND & \
SOUTHBOUND CONNECTORS TO NORTHBOUND & SOUTHBOUND I 880 /IN SAN JOSE/ (SANTA \
CLARA CO) ARE CLOSED FROM 2230 HRS EACH NIGHT TO 0600 HRS EACH MORNING THRU \
11/9/03 - DUE TO CONSTRUCTION - DETOURS ARE AVAILABLE [NORTHWEST CALIFORNIA] \
1-WAY CONTROLLED TRAFFIC 7 MI NORTH OF LEGGETT /CONFUSION HILL/ (MENDOCINO \
CO) FROM 0700 HRS TO 1900 HRS MONDAY THRU FRIDAY THRU 11/14/03 - DUE TO \
CONSTRUCTION - MOTORISTS ARE SUBJECT TO 20 MINUTE DELAYS"}]}]}]}], {}]\)], \
"Output",
  CellLabel->"Out[28]=",
  CellTags->"b:1.3.3"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InvokeServiceOperation[getTraffic, symbolicXML]\)], "Input",
  CellLabel->"In[29]:=",
  CellTags->"b:1.3.3"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
          "Envelope"}, {{"http://www.w3.org/2000/xmlns/", "SOAP-ENV"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", \
{"http://www.w3.org/2000/xmlns/", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", \
{"http://www.w3.org/2000/xmlns/", "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema"}, \
{XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
              "Body"}, {}, {XMLElement[{"urn:xmethods-CATraffic", 
                  "getTrafficResponse"}, \
{{"http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"} \[Rule] 
                    "http://schemas.xmlsoap.org/soap/encoding/", \
{"http://www.w3.org/2000/xmlns/", "ns1"} \[Rule] 
                    "urn:xmethods-CATraffic"}, {XMLElement[{\*"\<\"\"\>", 
                      "return"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", "type"} \[Rule] 
                        "xsd:string"}, {"reported as of Friday, November 7, \
2003 at 15:17 . Slow for the Cone Zone US 101 [LOS ANGELES & VENTURA CO.'S] \
NO TRAFFIC RESTRICTIONS ARE REPORTED FOR THIS AREA. [CENTRAL COAST] NO \
TRAFFIC RESTRICTIONS ARE REPORTED FOR THIS AREA. [SAN FRANCISCO BAY AREA] THE \
SOUTHBOUND CONNECTOR TO EASTBOUND SR 152 /IN GILROY/ (SANTA CLARA CO) IS \
CLOSED FROM 2200 HRS EACH NIGHT TO 0500 HRS EACH MORNING THRU 11/8/03 - DUE \
TO CONSTRUCTION - A DETOUR IS AVAILABLE IS CLOSED FROM BERNAL RD TO THE JCT \
OF SR 85 /IN SAN JOSE/ (SANTA CLARA CO) FROM 0001 HRS TO 0500 HRS THRU \
11/8/03 - DUE TO CONSTRUCTION - A DETOUR IS AVAILABLE THE NORTHBOUND & \
SOUTHBOUND CONNECTORS TO NORTHBOUND & SOUTHBOUND I 880 /IN SAN JOSE/ (SANTA \
CLARA CO) ARE CLOSED FROM 2230 HRS EACH NIGHT TO 0600 HRS EACH MORNING THRU \
11/9/03 - DUE TO CONSTRUCTION - DETOURS ARE AVAILABLE [NORTHWEST CALIFORNIA] \
1-WAY CONTROLLED TRAFFIC 7 MI NORTH OF LEGGETT /CONFUSION HILL/ (MENDOCINO \
CO) FROM 0700 HRS TO 1900 HRS MONDAY THRU FRIDAY THRU 11/14/03 - DUE TO \
CONSTRUCTION - MOTORISTS ARE SUBJECT TO 20 MINUTE DELAYS"}]}]}]}], {}]\)], \
"Output",
  CellLabel->"Out[29]=",
  CellTags->"b:1.3.3"]
}, Open  ]],

Cell[TextData[{
  "The result of this call is the response message. Sometimes it is useful to \
work directly with the response message. However, web service functions by \
default return a deserialized version of the response message. The original \
response message may be retrieved using the ",
  StyleBox["InvokeServiceOperation",
    FontFamily->"Courier"],
  " function. The first parameter is the web service function and the \
function\[CloseCurlyQuote]s parameters follow. ",
  StyleBox["InvokeServiceOperation",
    FontFamily->"Courier"],
  " invokes the service and returns the entire response message in symbolic \
XML. This will allow the user to customize how the data is deserialized into \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " representation."
}], "Text",
  CellTags->"b:1.3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(response\  = \ InvokeServiceOperation[getTraffic, "\<101\>"]\)], "Input",\

  CellLabel->"In[30]:=",
  CellTags->"b:1.3.3"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
          "Envelope"}, {{"http://www.w3.org/2000/xmlns/", "SOAP-ENV"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", \
{"http://www.w3.org/2000/xmlns/", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", \
{"http://www.w3.org/2000/xmlns/", "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema"}, \
{XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
              "Body"}, {}, {XMLElement[{"urn:xmethods-CATraffic", 
                  "getTrafficResponse"}, \
{{"http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"} \[Rule] 
                    "http://schemas.xmlsoap.org/soap/encoding/", \
{"http://www.w3.org/2000/xmlns/", "ns1"} \[Rule] 
                    "urn:xmethods-CATraffic"}, {XMLElement[{\*"\<\"\"\>", 
                      "return"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", "type"} \[Rule] 
                        "xsd:string"}, {"reported as of Friday, November 7, \
2003 at 15:17 . Slow for the Cone Zone US 101 [LOS ANGELES & VENTURA CO.'S] \
NO TRAFFIC RESTRICTIONS ARE REPORTED FOR THIS AREA. [CENTRAL COAST] NO \
TRAFFIC RESTRICTIONS ARE REPORTED FOR THIS AREA. [SAN FRANCISCO BAY AREA] THE \
SOUTHBOUND CONNECTOR TO EASTBOUND SR 152 /IN GILROY/ (SANTA CLARA CO) IS \
CLOSED FROM 2200 HRS EACH NIGHT TO 0500 HRS EACH MORNING THRU 11/8/03 - DUE \
TO CONSTRUCTION - A DETOUR IS AVAILABLE IS CLOSED FROM BERNAL RD TO THE JCT \
OF SR 85 /IN SAN JOSE/ (SANTA CLARA CO) FROM 0001 HRS TO 0500 HRS THRU \
11/8/03 - DUE TO CONSTRUCTION - A DETOUR IS AVAILABLE THE NORTHBOUND & \
SOUTHBOUND CONNECTORS TO NORTHBOUND & SOUTHBOUND I 880 /IN SAN JOSE/ (SANTA \
CLARA CO) ARE CLOSED FROM 2230 HRS EACH NIGHT TO 0600 HRS EACH MORNING THRU \
11/9/03 - DUE TO CONSTRUCTION - DETOURS ARE AVAILABLE [NORTHWEST CALIFORNIA] \
1-WAY CONTROLLED TRAFFIC 7 MI NORTH OF LEGGETT /CONFUSION HILL/ (MENDOCINO \
CO) FROM 0700 HRS TO 1900 HRS MONDAY THRU FRIDAY THRU 11/14/03 - DUE TO \
CONSTRUCTION - MOTORISTS ARE SUBJECT TO 20 MINUTE DELAYS"}]}]}]}], {}]\)], \
"Output",
  CellLabel->"Out[30]=",
  CellTags->"b:1.3.3"]
}, Open  ]],

Cell[TextData[{
  "Once a web service function is called using ",
  StyleBox["InvokeServiceOperation",
    FontFamily->"Courier"],
  ", the results come back in the form of a SOAP envelope. ",
  StyleBox["FromServiceResponse",
    FontFamily->"Courier"],
  " can be used to extract the results from the SOAP envelope. If the message \
uses SOAP encoding and provides types in the response message, the data will \
be deserialized into the proper ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " types.  If not, the SOAP envelope wrappers will be stripped and the \
response will be deserialized into a rule syntax expression with string \
values."
}], "Text",
  CellTags->"b:1.3.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FromServiceResponse[response]\)], "Input",
  CellLabel->"In[31]:=",
  CellTags->"b:1.3.3"],

Cell[BoxData[
    \("reported as of Friday, November 7, 2003 at 15:17 . Slow for the Cone \
Zone US 101 [LOS ANGELES & VENTURA CO.'S] NO TRAFFIC RESTRICTIONS ARE \
REPORTED FOR THIS AREA. [CENTRAL COAST] NO TRAFFIC RESTRICTIONS ARE REPORTED \
FOR THIS AREA. [SAN FRANCISCO BAY AREA] THE SOUTHBOUND CONNECTOR TO EASTBOUND \
SR 152 /IN GILROY/ (SANTA CLARA CO) IS CLOSED FROM 2200 HRS EACH NIGHT TO \
0500 HRS EACH MORNING THRU 11/8/03 - DUE TO CONSTRUCTION - A DETOUR IS \
AVAILABLE IS CLOSED FROM BERNAL RD TO THE JCT OF SR 85 /IN SAN JOSE/ (SANTA \
CLARA CO) FROM 0001 HRS TO 0500 HRS THRU 11/8/03 - DUE TO CONSTRUCTION - A \
DETOUR IS AVAILABLE THE NORTHBOUND & SOUTHBOUND CONNECTORS TO NORTHBOUND & \
SOUTHBOUND I 880 /IN SAN JOSE/ (SANTA CLARA CO) ARE CLOSED FROM 2230 HRS EACH \
NIGHT TO 0600 HRS EACH MORNING THRU 11/9/03 - DUE TO CONSTRUCTION - DETOURS \
ARE AVAILABLE [NORTHWEST CALIFORNIA] 1-WAY CONTROLLED TRAFFIC 7 MI NORTH OF \
LEGGETT /CONFUSION HILL/ (MENDOCINO CO) FROM 0700 HRS TO 1900 HRS MONDAY THRU \
FRIDAY THRU 11/14/03 - DUE TO CONSTRUCTION - MOTORISTS ARE SUBJECT TO 20 \
MINUTE DELAYS"\)], "Output",
  CellLabel->"Out[31]=",
  CellTags->"b:1.3.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Working Without a WSDL", "Subsection",
  CellTags->"b:1.3.4"],

Cell[TextData[{
  "Web services may work without a WSDL file, and sometimes the user may be \
forced into a situation where a WSDL file is not available. It is possible to \
use this client without a WSDL. Although it is much more convenient to use \
with a WSDL file. In order to use the client without a WSDL it may be useful \
for the user to take a look at the SOAP specification. This is available at  \
",
  StyleBox[ButtonBox["http://www.w3.org/TR/SOAP/",
    ButtonData:>{
      URL[ "http://www.w3.org/TR/SOAP/"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  "."
}], "Text",
  CellTags->"b:1.3.4"],

Cell[TextData[{
  "A user can invoke a web service using the ",
  StyleBox["InvokeServiceOperation",
    FontFamily->"Courier"],
  ". In order to properly invoke this function the user must provide a proper \
SOAP message. The ",
  StyleBox["ToServiceRequest",
    FontFamily->"Courier"],
  " function can be used to build a request message. In order to use this \
function, two parameters must be provided. The first parameter is a list of \
the parameter of the web service operation that will be invoked. The second \
parameter is a list of the header\[CloseCurlyQuote]s of the web service \
operation that will be invoked.  Both of these parameters should passed in as \
a list of rule syntax expressions or symbolic XML elements.  It is necessary \
to pass the full definition of the parameters since a WSDL is not present to \
provide information.  This includes the name, type, or any other information \
needed by the web service.  The options are also very important to building \
the SOAP envelope.  These are defined in the table here.  "
}], "Text",
  CellTags->"b:1.3.4"],

Cell[BoxData[GridBox[{
        {
          StyleBox["Option",
            "Text",
            FontFamily->"Times New Roman"], 
          StyleBox["Description",
            "Text",
            FontFamily->"Times New Roman"]},
        {
          StyleBox["OperationName",
            "Text"], 
          
          StyleBox[Cell[TextData[StyleBox[
            "Specifies the name of the operation tag for rpc-style calls and \
the root tag for single-document document-style calls.", "Text",
              FontFamily->"Times New Roman"]]],
            FontFamily->"Times New Roman"]},
        {
          StyleBox["OperationStyle",
            "Text"], 
          StyleBox[Cell[TextData[{
              StyleBox[
              "Specifies the operation style of the web service operation. \
This may be set to \[OpenCurlyDoubleQuote]document\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]rpc\[CloseCurlyDoubleQuote] only.  The default is  ",
                FontFamily->"Times New Roman"],
              StyleBox["Automatic",
                FontFamily->"Courier New"],
              StyleBox[". ",
                FontFamily->"Times New Roman"]
            }]],
            FontFamily->"Times New Roman"]},
        {
          StyleBox["SOAPActionURI",
            "Text"], 
          StyleBox[Cell[TextData[{
              StyleBox[
              "Specifies the SOAP action URI of the web service operation. \
The default is ",
                FontFamily->"Times New Roman"],
              StyleBox["Automatic",
                FontFamily->"Courier New"],
              StyleBox[".",
                FontFamily->"Times New Roman"]
            }]],
            TextAlignment->Left,
            FontFamily->"Times New Roman"]},
        {
          StyleBox["ReturnType",
            "Text"], 
          
          StyleBox[Cell[TextData[StyleBox[
            "Specifies the qualified name of the root element returned in the \
results. This is used for deserializing the results. The value should be a \n\
list of two strings, the first string being the namespace and the second \
string the name of the type.",
              FontFamily->"Times New Roman"]]],
            TextAlignment->Left,
            FontFamily->"Times New Roman"]},
        {
          StyleBox["TransportStyleURI",
            "Text"], 
          StyleBox[Cell[TextData[{
              StyleBox[
              "Specifies the style of transport used to invoke the call.  The \
default value is ",
                FontFamily->"Times New Roman"],
              StyleBox["Automatic",
                FontFamily->"Courier New"],
              StyleBox[".",
                FontFamily->"Times New Roman"]
            }]],
            FontFamily->"Times New Roman"]},
        {
          StyleBox["EncodingStyle",
            "Text"], 
          
          StyleBox[Cell[TextData[StyleBox[
            "Specifies whether the message should be encoded or use a message \
based on literal schema.  This may be set to \[OpenCurlyDoubleQuote]encoded\
\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]literal\
\[CloseCurlyDoubleQuote] only.  \nThe default is Automatic.",
              FontFamily->"Times New Roman"]]],
            TextAlignment->Left,
            FontFamily->"Times New Roman"]},
        {
          StyleBox["EncodingStyleURI",
            "Text"], 
          
          StyleBox[Cell[TextData[StyleBox[
            "Specifies the encoding of the parameters passed to a web service \
operation.  The value should be a list of strings representing a URI.",
              FontFamily->"Times New Roman"]]],
            FontFamily->"Times New Roman"]},
        {
          StyleBox["HeaderEncodingStyleURI",
            "Text"], 
          
          StyleBox[Cell[TextData[StyleBox[
            "Specifies the encoding of the header parameters passed to a web \
service operation.  The value should be a list of strings representing URIs.",
              
              FontFamily->"Times New Roman"]]],
            FontFamily->"Times New Roman"]},
        {
          StyleBox["Username",
            "Text"], 
          
          StyleBox[Cell[TextData[StyleBox[
            "Supplies authentication for an operation.  The value should be a \
string.",
              FontFamily->"Times New Roman"]]],
            "Text",
            FontFamily->"Times New Roman"]},
        {
          StyleBox["Password",
            "Text"], 
          
          StyleBox[Cell[TextData[StyleBox[
            "Supplies authentication for an operation.  The value should be a \
string.",
              FontFamily->"Times New Roman"]]],
            "Text",
            FontFamily->"Times New Roman"]}
        },
      ColumnAlignments->{Left},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Text",
  TextAlignment->Left,
  CellTags->"b:1.3.4"],

Cell[BoxData[
    \(Needs["\<WebServices`\>"]\)], "Input",
  CellLabel->"In[32]:=",
  CellTags->"b:1.3.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(msg = \ 
      ToServiceRequest[\[IndentingNewLine]{"\<zipcode\>" -> "\<61821\>"}, {}, \
\ OperationName -> {"\<urn:xmethods-Temperature\>", "\<getTemp\>"}]\)], \
"Input",
  CellLabel->"In[33]:=",
  CellTags->"b:1.3.4"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"soapenv", 
          "Envelope"}, {{"xmlns", "soapenv"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", {"xmlns", 
              "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema", {"xmlns", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", {"xmlns", 
              "soapenc"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/encoding/"}, \
{XMLElement[{"soapenv", 
              "Body"}, {}, {XMLElement[{"ns0", 
                  "getTemp"}, {{"xmlns", "ns0"} \[Rule] 
                    "urn:xmethods-Temperature"}, {XMLElement[{\*"\<\"\"\>", 
                      "zipcode"}, {}, {"61821"}]}]}]}], {}]\)], "Output",
  CellLabel->"Out[33]=",
  CellTags->"b:1.3.4"]
}, Open  ]],

Cell[TextData[{
  "The request message can then be invoked using the ",
  StyleBox["InvokeServiceOperation",
    FontFamily->"Courier"],
  " function. The first parameter of this function is the endpoint URI. The \
endpoint specifies where to send the request message. This URI is generally \
found in the WSDL."
}], "Text",
  CellTags->"b:1.3.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InvokeServiceOperation["\<http://services.xmethods.net:80/soap/servlet/\
rpcrouter\>", \ msg]\)], "Input",
  CellLabel->"In[34]:=",
  CellTags->"b:1.3.4"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
          "Envelope"}, {{"http://www.w3.org/2000/xmlns/", "SOAP-ENV"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", \
{"http://www.w3.org/2000/xmlns/", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", \
{"http://www.w3.org/2000/xmlns/", "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema"}, \
{XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
              "Body"}, {}, {XMLElement[{"urn:xmethods-Temperature", 
                  "getTempResponse"}, \
{{"http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"} \[Rule] 
                    "http://schemas.xmlsoap.org/soap/encoding/", \
{"http://www.w3.org/2000/xmlns/", "ns1"} \[Rule] 
                    "urn:xmethods-Temperature"}, {XMLElement[{\*"\<\"\"\>", 
                      "return"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", "type"} \[Rule] 
                        "xsd:float"}, {"37.0"}]}]}]}], {}]\)], "Output",
  CellLabel->"Out[34]=",
  CellTags->"b:1.3.4"]
}, Open  ]],

Cell[TextData[{
  "When using SOAP encoding, the client will add types to the elements in the \
parameters list passed to ",
  StyleBox["ToServiceRequest",
    FontFamily->"Courier"],
  " depending on the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " type. Therefore, in this example it is not necessary to add type \
information because SOAP encoding is specified. The simple types supported \
are defined here. However, when the results are returned, if the types are \
not encoded in the data returned, the values will not be converted from \
strings."
}], "Text",
  CellTags->"b:1.3.4"],

Cell[BoxData[GridBox[{
        {\(Mathematica\ Type\), \(XML\ type\)},
        {"String", \({\(\(http\)\(:\)\) // \(www . w3 . org/1999\)/XMLSchema} 
            string\)},
        {"Integer", \({\(\(http\)\(:\)\) // \(www . w3 . org/1999\)/
                  XMLSchema} int\)},
        {"Real", \({\(\(http\)\(:\)\) // \(www . w3 . org/1999\)/XMLSchema} 
            double\)},
        {\(True, \ 
          False\), \({\(\(http\)\(:\)\) // \(www . w3 . org/1999\)/XMLSchema} 
            boolean\)}
        },
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Text",
  TextAlignment->Center,
  CellTags->"b:1.3.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(msg = \ 
      ToServiceRequest[\[IndentingNewLine]{"\<zipcode\>" -> "\<61821\>"}, {}, \
\ OperationName -> {"\<urn:xmethods-Temperature\>", "\<getTemp\>"}, \ 
        EncodingStyle -> "\<encoded\>", 
        EncodingStyleURI \[Rule] \
{"\<http://schemas.xmlsoap.org/soap/encoding/\>"}]\)], "Input",
  CellLabel->"In[35]:=",
  CellTags->"b:1.3.4"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"soapenv", 
          "Envelope"}, {{"xmlns", "soapenv"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", {"xmlns", 
              "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema", {"xmlns", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", {"xmlns", 
              "soapenc"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/encoding/"}, \
{XMLElement[{"soapenv", 
              "Body"}, {}, {XMLElement[{"ns0", 
                  "getTemp"}, {{"soapenv", "encodingStyle"} \[Rule] 
                    "http://schemas.xmlsoap.org/soap/encoding/", {"xmlns", 
                      "ns0"} \[Rule] 
                    "urn:xmethods-Temperature"}, {XMLElement[{\*"\<\"\"\>", 
                      "zipcode"}, {{"xsi", "type"} \[Rule] 
                        "xsd:string"}, {"61821"}]}]}]}], {}]\)], "Output",
  CellLabel->"Out[35]=",
  CellTags->"b:1.3.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InvokeServiceOperation["\<http://services.xmethods.net:80/soap/servlet/\
rpcrouter\>", \ msg]\)], "Input",
  CellLabel->"In[36]:=",
  CellTags->"b:1.3.4"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
          "Envelope"}, {{"http://www.w3.org/2000/xmlns/", "SOAP-ENV"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", \
{"http://www.w3.org/2000/xmlns/", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", \
{"http://www.w3.org/2000/xmlns/", "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema"}, \
{XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
              "Body"}, {}, {XMLElement[{"urn:xmethods-Temperature", 
                  "getTempResponse"}, \
{{"http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"} \[Rule] 
                    "http://schemas.xmlsoap.org/soap/encoding/", \
{"http://www.w3.org/2000/xmlns/", "ns1"} \[Rule] 
                    "urn:xmethods-Temperature"}, {XMLElement[{\*"\<\"\"\>", 
                      "return"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", "type"} \[Rule] 
                        "xsd:float"}, {"37.0"}]}]}]}], {}]\)], "Output",
  CellLabel->"Out[36]=",
  CellTags->"b:1.3.4"]
}, Open  ]],

Cell[TextData[{
  "However, if the web service is expecting an XML type other than the type \
mapped from a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " type, it may be necessary to add type information. For example, a real \
maps to a double, but a real also represents a float in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". If a real value is passed as a parameter, it will be encoded as a \
double. A web service expecting a float may not handle this correctly. To \
correct this the user should specify the type. It may also be necessary to \
specify the type for compound types. Compound types do not have an XML type \
automatically associated with them."
}], "Text",
  CellTags->"b:1.3.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(msg\  = \ 
      ToServiceRequest[{{"\<zipcode\>", \
{{"\<http://www.w3.org/2001/XMLSchema-instance\>", \ "\<type\>"} \[Rule] \
{"\<http://www.w3.org/2001/XMLSchema\>", "\<string\>"}}} -> "\<61821\>"}, {}, \
\ \[IndentingNewLine]OperationName -> {"\<urn:xmethods-Temperature\>", \
"\<getTemp\>"}]\)], "Input",
  CellLabel->"In[37]:=",
  CellTags->"b:1.3.4"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"soapenv", 
          "Envelope"}, {{"xmlns", "soapenv"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", {"xmlns", 
              "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema", {"xmlns", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", {"xmlns", 
              "soapenc"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/encoding/"}, \
{XMLElement[{"soapenv", 
              "Body"}, {}, {XMLElement[{"ns0", 
                  "getTemp"}, {{"xmlns", "ns0"} \[Rule] 
                    "urn:xmethods-Temperature"}, {XMLElement[{\*"\<\"\"\>", 
                      "zipcode"}, {{"xsi", "type"} \[Rule] 
                        "xsd:string"}, {"61821"}]}]}]}], {}]\)], "Output",
  CellLabel->"Out[37]=",
  CellTags->"b:1.3.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(response\  = \ 
      InvokeServiceOperation["\<http://services.xmethods.net:80/soap/servlet/\
rpcrouter\>", \ msg]\)], "Input",
  CellLabel->"In[38]:=",
  CellTags->"b:1.3.4"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
          "Envelope"}, {{"http://www.w3.org/2000/xmlns/", "SOAP-ENV"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", \
{"http://www.w3.org/2000/xmlns/", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", \
{"http://www.w3.org/2000/xmlns/", "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema"}, \
{XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
              "Body"}, {}, {XMLElement[{"urn:xmethods-Temperature", 
                  "getTempResponse"}, \
{{"http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"} \[Rule] 
                    "http://schemas.xmlsoap.org/soap/encoding/", \
{"http://www.w3.org/2000/xmlns/", "ns1"} \[Rule] 
                    "urn:xmethods-Temperature"}, {XMLElement[{\*"\<\"\"\>", 
                      "return"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", "type"} \[Rule] 
                        "xsd:float"}, {"37.0"}]}]}]}], {}]\)], "Output",
  CellLabel->"Out[38]=",
  CellTags->"b:1.3.4"]
}, Open  ]],

Cell[TextData[{
  "Once a web service function is called using ",
  StyleBox["InvokeServiceOperation",
    FontFamily->"Courier"],
  " the results come back in the form of a SOAP envelope. ",
  StyleBox["FromServiceResponse",
    FontFamily->"Courier"],
  " can be used to extract the results from the SOAP envelope. If the message \
uses SOAP encoding and provides types in the response message, the data will \
be deserialized into the proper ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " types. If not, the SOAP envelope wrappers will be stripped and the \
response will be deserialized into a rule syntax expression with string \
values."
}], "Text",
  CellTags->"b:1.3.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(FromServiceResponse[response]\)], "Input",
  CellLabel->"In[39]:=",
  CellTags->"b:1.3.4"],

Cell[BoxData[
    \(37.`\)], "Output",
  CellLabel->"Out[39]=",
  CellTags->"b:1.3.4"]
}, Open  ]],

Cell[TextData[{
  "If a web service operation is used often, the operation can be installed \
more permanently using ",
  StyleBox["InstallServiceOperation",
    FontFamily->"Courier"],
  ".  ",
  StyleBox["InstallServiceOperation",
    FontFamily->"Courier"],
  " installs the operation as a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function. The first argument specifies the function name. It is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " symbol. The second argument is the endpoint URI. The third argument is a \
list of parameters, and the fourth argument is a list of headers. These last \
two arguments work similarly to ",
  StyleBox["ToServiceRequest",
    FontFamily->"Courier"],
  ". The major difference between ",
  StyleBox["InstallServiceOperation",
    FontFamily->"Courier"],
  " and ",
  StyleBox["ToServiceRequest",
    FontFamily->"Courier"],
  " is how the parameters are passed.  ",
  StyleBox["ToServiceRequest",
    FontFamily->"Courier"],
  " requires the values to be passed in the parameters. However, for ",
  StyleBox["InstallServiceOperation",
    FontFamily->"Courier"],
  ", the parameter values will be supplied later, when the function is \
called. Therefore, only the left side of the a parameter in rule syntax needs \
to be passed to ",
  StyleBox["InstallServiceOperation",
    FontFamily->"Courier"],
  ". Passing the left side specifies to the function what the parameter is.  \
However, in order for this to work correctly the user needs to use the left \
side of the rule syntax.  An example is provided here. It specifies the \
method ",
  StyleBox["getTemp",
    FontFamily->"Courier New"],
  ", which requires a parameter called zipcode. "
}], "Text",
  CellTags->"b:1.3.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallServiceOperation[
      TempService`getTempFromZipCode, \ \
"\<http://services.xmethods.net:80/soap/servlet/rpcrouter\>", \ \
\[IndentingNewLine]{{"\<zipcode\>", \
{{"\<http://www.w3.org/2001/XMLSchema-instance\>", \ "\<type\>"} \[Rule] \
{"\<http://www.w3.org/2001/XMLSchema\>", "\<string\>"}}}}, {}, 
      OperationName -> {"\<urn:xmethods-Temperature\>", "\<getTemp\>"}]\)], \
"Input",
  CellLabel->"In[42]:=",
  CellTags->"b:1.3.4"],

Cell[BoxData[
    \(getTempFromZipCode\)], "Output",
  CellLabel->"Out[42]=",
  CellTags->"b:1.3.4"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(getTempFromZipCode["\<61821\>"]\)], "Input",
  CellLabel->"In[43]:=",
  CellTags->"b:1.3.4"],

Cell[BoxData[
    \(37.`\)], "Output",
  CellLabel->"Out[43]=",
  CellTags->"b:1.3.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Uninstalling a Web Service", "Subsection",
  CellTags->"b:1.3.5"],

Cell[TextData[{
  StyleBox["UninstallServiceOperation",
    FontFamily->"Courier"],
  " and ",
  StyleBox["UninstallService",
    FontFamily->"Courier"],
  " can be used to remove a web service from ",
  StyleBox["Mathematica. ",
    FontSlant->"Italic"],
  "Uninstalling a service amounts to removing the OperationPalette and the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function defining the operation. ",
  StyleBox["UninstallServiceOperation",
    FontFamily->"Courier"],
  " takes a function as the parameter. If the function defines a web service \
operation, the operation is uninstalled. ",
  StyleBox["UninstallService",
    FontFamily->"Courier"],
  " takes a context pattern as its only parameter. It then uses ",
  StyleBox["UninstallServiceOperation",
    FontFamily->"Courier"],
  " to uninstall any function that is returned from the context pattern and \
is an installed service."
}], "Text",
  CellTags->"b:1.3.5"],

Cell[BoxData[
    \(Needs["\<WebServices`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"b:1.3.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://terraservice.net/TerraService.asmx?WSDL\>"]\)],\
 "Input",
  CellLabel->"In[2]:=",
  CellTags->"b:1.3.5"],

Cell[BoxData[
    \({ConvertLonLatPtToNearestPlace, ConvertLonLatPtToUtmPt, 
      ConvertUtmPtToLonLatPt, ConvertPlaceToLonLatPt, CountPlacesInRect, 
      GetAreaFromPt, GetAreaFromRect, GetAreaFromTileId, GetLatLonMetrics, 
      GetPlaceFacts, GetPlaceList, GetPlaceListInRect, GetTheme, 
      GetTileMetaFromLonLatPt, GetTileMetaFromTileId, GetTile}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"b:1.3.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \($InstalledServices\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"b:1.3.5"],

Cell[BoxData[
    \({ConvertLonLatPtToNearestPlace, ConvertLonLatPtToUtmPt, 
      ConvertPlaceToLonLatPt, ConvertUtmPtToLonLatPt, CountPlacesInRect, 
      GetAreaFromPt, GetAreaFromRect, GetAreaFromTileId, GetLatLonMetrics, 
      GetPlaceFacts, GetPlaceList, GetPlaceListInRect, GetTheme, GetTile, 
      GetTileMetaFromLonLatPt, GetTileMetaFromTileId}\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"b:1.3.5"]
}, Open  ]],

Cell[TextData[{
  "Once a service is installed, a user can use ",
  StyleBox["$InstalledServices",
    FontFamily->"Courier"],
  " to see which services are installed. The example demonstrates ",
  StyleBox["UninstallServiceOperation",
    FontFamily->"Courier"],
  ". ",
  StyleBox["$InstalledServices",
    FontFamily->"Courier"],
  " demonstrates that it is removed from ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"b:1.3.5"],

Cell[BoxData[
    \(UninstallServiceOperation[ConvertLonLatPtToNearestPlace]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"b:1.3.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \($InstalledServices\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"b:1.3.5"],

Cell[BoxData[
    \({ConvertLonLatPtToUtmPt, ConvertPlaceToLonLatPt, 
      ConvertUtmPtToLonLatPt, CountPlacesInRect, GetAreaFromPt, 
      GetAreaFromRect, GetAreaFromTileId, GetLatLonMetrics, GetPlaceFacts, 
      GetPlaceList, GetPlaceListInRect, GetTheme, GetTile, 
      GetTileMetaFromLonLatPt, GetTileMetaFromTileId}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"b:1.3.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OperationPalette[ConvertLonLatPtToNearestPlace]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"b:1.3.5"],

Cell[BoxData[
    \("Palette cannot be found."\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"b:1.3.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Context[ConvertLonLatPtToNearestPlace]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"b:1.3.5"],

Cell[BoxData[
    \("Global`"\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"b:1.3.5"]
}, Open  ]],

Cell[TextData[{
  "This example demonstrates ",
  StyleBox["UninstallService",
    FontFamily->"Courier"],
  ". ",
  StyleBox["$InstalledServices",
    FontFamily->"Courier"],
  " demonstrates that all the symbols in the context are removed from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"b:1.3.5"],

Cell[BoxData[
    \(UninstallService["\<TerraService`TerraServiceSoap`*\>"]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"b:1.3.5"],

Cell[CellGroupData[{

Cell[BoxData[
    \($InstalledServices\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"b:1.3.5"],

Cell[BoxData[
    \({}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"b:1.3.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OperationPalette[ConvertPlaceToLonLatPt]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"b:1.3.5"],

Cell[BoxData[
    \("Palette cannot be found."\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"b:1.3.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Working with Headers", "Subsection",
  CellTags->"b:1.3.6"],

Cell["\<\
Headers are an important component to web services as they allow web services \
to process a message without parsing the body of a SOAP message. The body \
will contain information directly related to the web service operation being \
invoked. However, a header generally contains more general content that is \
used to invoke any of the web service operations. For example, a header may \
contain a username and password.  It is useful to include the username and \
password as a header, because a separate component can be used to process the \
username and password without needing to know anything about the body.\
\>", "Text",
  CellTags->"b:1.3.6"],

Cell["\<\
The Web Services Package supports headers by including the header as part of \
the function signature of an operation. So it will look like any other \
parameter of the operation. If an operation requires a header that consists \
of an authentication object that includes two strings defining the username \
and password, then a compound object consisting of these two strings will be \
expected when calling this function.\
\>", "Text",
  CellTags->"b:1.3.6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Working with Sessions", "Subsection",
  CellTags->"b:1.3.7"],

Cell["\<\
Sessions are used by web services to persist user data over multiple calls to \
a web service.  For example, they can be used to save a \
user\[CloseCurlyQuote]s settings, data, or other things. Sessions are \
supported by the Web Services Package.  However, there are no special \
functions or options. If a web service provides operations that use sessions, \
then they should be used by the Java client.\
\>", "Text",
  CellTags->"b:1.3.7"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Authentication", "Subsection",
  CellTags->"b:1.3.8"],

Cell[TextData[{
  "Authentication is used by some web services to validate a user. This is \
based on functionality provided by HTTP. Digest and simple authentication \
should both be supported. A user can set the username and password by using \
the ",
  StyleBox["Username",
    FontFamily->"Courier"],
  " and ",
  StyleBox["Password",
    FontFamily->"Courier"],
  " options. These can be passed into any web service function. They will be \
used for authentication."
}], "Text",
  CellTags->"b:1.3.8"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Security Configuration", "Subsection",
  CellTags->"b:1.3.9"],

Cell[TextData[{
  "Security is important for users of the Web Services Package as ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " contains many commands for examining and deleting files and for launching \
arbitrary processes. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands may be executed by the client during type conversion. If the \
server returns a rogue expression or number, it could get executed in ",
  StyleBox["Mathematica.",
    FontSlant->"Italic"],
  "  This may occur since the Web Services Package uses ",
  StyleBox["ToExpression",
    FontFamily->"Courier"],
  " to convert data returned by a web service into a data type that is \
convenient for the user. For example, it converts data that is specified as \
an xsd:int into an integer in ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "using ",
  StyleBox["ToExpression",
    FontFamily->"Courier"],
  "."
}], "Text",
  CellTags->"b:1.3.9"],

Cell[TextData[{
  "While the client does not execute the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands until after the HTTP call is made, that does not mean that \
mischief cannot be caused on the client machine.  A rogue command can delete \
files on a user\[CloseCurlyQuote]s machine using input such as:"
}], "Text",
  CellTags->"b:1.3.9"],

Cell[TextData[StyleBox["\tDeleteFile[\"/etc/passwd\"]",
  FontWeight->"Bold"]], "Text",
  FontFamily->"Courier New",
  CellTags->"b:1.3.9"],

Cell["or start a telnet daemon using input such as:", "Text",
  CellTags->"b:1.3.9"],

Cell[TextData[StyleBox["\tRun[\"telnetd -d\"]",
  FontWeight->"Bold"]], "Text",
  FontFamily->"Courier New",
  CellTags->"b:1.3.9"],

Cell[TextData[{
  "These are just two commands that could cause mischief on a user\
\[CloseCurlyQuote]s machine. Therefore, it is very important to limit the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " commands that may be executed by default on the client. To achieve this, \
every piece of data that gets converted using ",
  StyleBox["ToExpression",
    FontFamily->"Courier"],
  " is checked for validity. If a symbol is not allowed, then a message is \
sent to the user."
}], "Text",
  CellTags->"b:1.3.9"],

Cell["\<\
Validation works by collecting all the symbols into a list and steadily \
reducing the list. If any symbols remain after reduction, the expression is \
not secure. The reduction process works with lists of symbol and context \
names that can either be allowed or disallowed according to the following \
steps:\:f35f\
\>", "Text",
  CellTags->"b:1.3.9"],

Cell[TextData[{
  "If ",
  StyleBox["AllowedContexts",
    FontFamily->"Courier"],
  " is a list, remove symbols with contexts on this list.\:f35f"
}], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"b:1.3.9"],

Cell[TextData[{
  "If ",
  StyleBox["AllowedContexts",
    FontFamily->"Courier"],
  " is not a list, remove symbols with contexts not in ",
  StyleBox["DisallowedContexts",
    FontFamily->"Courier"],
  ".\:f35f"
}], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"b:1.3.9"],

Cell[TextData[{
  "If ",
  StyleBox["AllowedSymbols",
    FontFamily->"Courier"],
  " is a list, remove symbols found in this list.\:f35f"
}], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"b:1.3.9"],

Cell[TextData[{
  "If ",
  StyleBox["AllowedSymbols",
    FontFamily->"Courier"],
  " is not a list, remove symbols that are not in ",
  StyleBox["DisallowedSymbols",
    FontFamily->"Courier"],
  ".\:f35f"
}], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"b:1.3.9"],

Cell["\<\
If no symbols remain, the expression is secure; otherwise, it is not \
secure.\
\>", "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellTags->"b:1.3.9"],

Cell["\<\
These tests allow users to be restrictive or flexible. Using the allowed \
lists is restrictive and is more secure, whereas using the disallowed lists \
is less restrictive with less security. It is up to each individual site to \
decide the appropriate balance.\
\>", "Text",
  CellTags->"b:1.3.9"],

Cell["\<\
When the server is started, a default security model is installed. This \
default security model looks like this:\
\>", "Text",
  CellTags->"b:1.3.9"],

Cell[CellGroupData[{

Cell[BoxData[
    \(WebServices`Security`AllowedContexts\)], "Input",
  CellLabel->"In[54]:=",
  CellTags->"b:1.3.9"],

Cell[BoxData[
    \({"Global`"}\)], "Output",
  CellLabel->"Out[54]=",
  CellTags->"b:1.3.9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(WebServices`Security`DisallowedContexts\)], "Input",
  CellLabel->"In[55]:=",
  CellTags->"b:1.3.9"],

Cell[BoxData[
    \(WebServices`Security`DisallowedContexts\)], "Output",
  CellLabel->"Out[55]=",
  CellTags->"b:1.3.9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(WebServices`Security`AllowedSymbols\)], "Input",
  CellLabel->"In[56]:=",
  CellTags->"b:1.3.9"],

Cell[BoxData[
    \(HoldComplete[Abort, AbortProtect, EditIn, Evaluate, MatchLocalNames, 
      MemoryConstrained, MemoryInUse, Above, AccountingForm, AbsoluteDashing, 
      AbsoluteOptions, AbsoluteThickness, AbsoluteTime, BaseForm, Baseline, 
      Below, BlankForm, Bottom, ButtonCell, Center, CForm, ColonForm, 
      ColumnForm, DigitQ, DisplayForm, DigitBlock, EngineeringForm, 
      ExportString, FontForm, Format, FortranForm, FromCharacterCode, 
      ImportString, InputForm, InterpretTemplate, Left, LetterQ, LowerCaseQ, 
      MatrixForm, FullForm, HorizontalForm, LongForm, MathMLForm, 
      MetaCharacters, NonAssociative, Normal, NumberForm, NumberFormat, 
      NumberMarks, NumberMultiplier, NumberPadding, NumberPoint, 
      NumberSeparator, NumberSigns, OutputForm, OutputMathEditExpression, 
      Overlaps, PaddedForm, Parenthesize, Plain, PrecedenceForm, Prefix, 
      Precision, PromptForm, Raw, Right, ScientificForm, SequenceForm, 
      SignPadding, SpaceForm, SpellingCorrection, StandardForm, StringForm, 
      TableAlignments, TableDepth, TableDirections, TableForm, TableHeadings, 
      TeXForm, TableSpacing, ToCharacterCode, ToDate, TraditionalForm, 
      TreeForm, $SuppressInputFormHeads, Active, AllowInlineCells, 
      AnimationCycleOffset, AnimationCycleRepetitions, AnimationDisplayTime, 
      AutoIndent, AutoIndentSpacings, AutoItalicWords, AutoOpenPalettes, 
      AutoScroll, AutoSpacing, AutoStyleOptions, Cell, CellAutoOverwrite, 
      CellBaseline, CellBoundingBox, CellBracketOptions, CellContents, 
      CellDingbat, CellEditDuplicate, CellElementsBoundingBox, 
      CellElementSpacings, CellEvaluationDuplicate, CellFrame, 
      CellFrameColor, CellFrameLabelMargins, CellFrameLabels, 
      CellFrameMargins, CellGroup, CellGroupData, CellGrouping, 
      CellGroupingRules, CellHorizontalScrolling, CellLabel, 
      CellLabelAutoDelete, CellLabelMargins, CellLabelPositioning, 
      CellMargins, CellObject, CellOpen, CellPasswords, CellPrint, CellSize, 
      CellStyle, CellTags, ClipboardNotebook, ConsolePrint, ConversionRules, 
      Copyable, DefaultDuplicateCellStyle, Deletable, DelimiterFlashTime, 
      Dialog, DialogProlog, DialogSymbols, DragAndDrop, Editable, 
      Evaluatable, EvaluationNotebook, Evaluator, ExitDialog, FontColor, 
      FontFamily, FrontEndExecute, GeneratedCell, GroupPageBreakWithin, 
      Hyphenation, ImageMargins, InputAliases, InitializationCell, 
      InputAutoReplacements, InputNotebook, LanguageCategory, LineIndent, 
      LineSpacing, Magnification, Notebook, PageBreakAbove, PageBreakBelow, 
      PageBreakWithin, PageWidth, ParagraphIndent, ParagraphSpacing, 
      PrintingStyleEnvironment, ScreenStyleEnvironment, Selectable, 
      SelectedNotebook, SelectionCreateCell, SelectionEvaluate, 
      SelectionEvaluateCreateCell, SelectionMove, SetSelectedNotebook, 
      ShowAutoStyles, ShowCellBracket, ShowCellLabel, ShowCellTags, 
      ShowCursorTracker, ShowPageBreaks, ShowSelection, 
      ShowSpecialCharacters, ShowStringCharacters, SingleLetterItalics, 
      StructuredSelection, StyleDefinitions, StyleForm, StylePrint, 
      TextAlignment, TextJustification, Visible, WindowClickSelect, 
      WindowElements, WindowFloating, WindowFrame, WindowMargins, 
      WindowMovable, WindowSize, WindowTitle, WindowToolbars, AdjustmentBox, 
      AdjustmentBoxOptions, AutoDelete, BoxData, Box, BoxBaselineShift, 
      BoxDimensions, BoxForm, BoxFormFormatTypes, BoxFrame, BoxMargins, 
      BoxRatios, BoxRegion, BoxStyle, ButtonBox, ButtonBoxOptions, Button, 
      ButtonContents, ButtonData, ButtonEvaluator, ButtonExpandable, 
      ButtonFrame, ButtonFunction, ButtonMargins, ButtonMinHeight, 
      ButtonNote, ButtonNotebook, ButtonSource, ButtonStyle, 
      ButtonStyleMenuListing, Column, ColumnAlignments, ColumnLines, 
      ColumnsEqual, ColumnSpacings, CounterBox, CounterBoxOptions, 
      CounterFunction, CounterIncrements, CounterStyle, 
      CounterStyleMenuListing, ColumnWidths, Decimal, DefaultNewCellStyle, 
      DeletionWarning, EqualColumns, EqualRows, ErrorBox, FontName, 
      FontPostScriptName, FontSize, FontSlant, FontSubstitutions, 
      FontTracking, FontWeight, FormBox, FractionBox, FrameBox, 
      ErrorBoxOptions, GridBaseline, GridBox, GridDefaultElement, 
      InterpretationBox, LimitsPositioning, MakeBoxes, MinSize, 
      MultilineFunction, OverscriptBox, ParentForm, RadicalBox, 
      RowAlignments, RowBox, RowLines, RowMinHeight, RowsEqual, RowSpacings, 
      ScriptBaselineShifts, ScriptMinSize, ScriptSizeMultipliers, 
      SpanAdjustments, SpanCharacterRounding, SpanMaxSize, SpanMinSize, 
      SqrtBox, StripBoxes, StripWrapperBoxes, StyleBox, SubscriptBox, 
      SubsuperscriptBox, SuperscriptBox, TagBox, ToBoxes, UnderoverscriptBox, 
      UnderscriptBox, $BoxForms, Abs, Accuracy, AccuracyGoal, Adams, AddTo, 
      AiryAi, AiryAiPrime, AiryBi, AiryBiPrime, AlgebraicRulesData, 
      AlgebraicRules, Algebraics, Analytic, Apart, ApartSquareFree, AppellF1, 
      ArcCos, ArcCosh, ArcCot, ArcCoth, ArcCsc, ArcCsch, ArcSec, ArcSech, 
      ArcSin, ArcSinh, ArcTan, ArcTanh, Arg, ArithmeticGeometricMean, 
      Assumptions, BernoulliB, BesselI, BesselJ, BesselK, BesselY, Beta, 
      BetaRegularized, Binomial, Booleans, C, Cancel, CarmichaelLambda, 
      Catalan, Ceiling, CellularAutomaton, CharacteristicPolynomial, 
      ChebyshevT, ChebyshevU, Chop, ClebschGordan, Coefficient, 
      CoefficientDomain, CoefficientList, CofactorExpansion, Collect, 
      Complexes, ComplexExpand, ComplexInfinity, ComplexityFunction, 
      ComposeSeries, Composition, Congruent, Conjugate, Constant, Constants, 
      ConstrainedMax, ConstrainedMin, ContinuedFraction, Cos, Cosh, 
      CoshIntegral, CosIntegral, Cot, Coth, Cyclotomic, D, DampingFactor, 
      Decompose, Decrement, DedekindEta, Csc, Csch, Cross, 
      DefaultValues, \[Degree], DegreeLexicographic, 
      DegreeReverseLexicographic, Denominator, Derivative, Det, 
      DifferenceOrder, DigitCount, DiracDelta, DirectedInfinity, Direction, 
      DiscreteDelta, Divide, DivideBy, DivisionFreeRowReduction, Divisors, 
      DivisorSigma, Dot, DoubleExponential, DoublyInfinite, DSolve, 
      DSolveConstants, Dt, \[ExponentialE], Eigensystem, Eigenvalues, 
      Eigenvectors, Eliminate, EliminationOrder, EllipticE, EllipticExp, 
      EllipticExpPrime, EllipticF, EllipticK, EllipticLog, EllipticNomeQ, 
      EllipticPi, EllipticReducedHalfPeriods, EllipticTheta, 
      EllipticThetaPrime, EquatedTo, Erf, Erfc, Erfi, EulerE, EulerGamma, 
      EulerPhi, WebServices`Security`Private`EvaluationMonitor, EvenQ, 
      ExactNumberQ, ExactRootIsolation, ExcludedForms, Exists, Exp, Expand, 
      ExpandAll, ExpandDenominator, ExpandNumerator, ExpIntegralE, 
      ExpIntegralEi, Exponent, ExponentFunction, ExponentPosition, 
      ExponentStep, ExpToTrig, ExtendedGCD, Factor, Factorial, Factorial2, 
      FactorInteger, FactorList, FactorSquareFree, FactorSquareFreeList, 
      FactorTerms, FactorTermsList, Fibonacci, 
      WebServices`Security`Private`FindFit, 
      WebServices`Security`Private`FindInstance, 
      WebServices`Security`Private`FindMaximum, FindMinimum, FindRoot, Fit, 
      FixedPoint, FixedPointList, Flat, Floor, Fold, FoldList, Fourier, 
      FourierCosTransform, FourierParameters, FourierSinTransform, 
      FourierTransform, FractionalPart, FresnelC, FresnelS, 
      FromContinuedFraction, FullSimplify, FunctionExpand, 
      FunctionInterpolation, Gamma, GammaRegularized, GaussianIntegers, 
      GaussKronrod, GaussPoints, GCD, GegenbauerC, GenerateConditions, 
      Generic, Glaisher, GoldenRatio, Gradient, GroebnerBasis, 
      HarmonicNumber, HermiteH, WebServices`Security`Private`Hessian, 
      Hypergeometric0F1, Hypergeometric0F1Regularized, Hypergeometric1F1, 
      Hypergeometric1F1Regularized, Hypergeometric2F1, 
      Hypergeometric2F1Regularized, HypergeometricPFQ, 
      HypergeometricPFQRegularized, HypergeometricU, \[ImaginaryI], Identity, 
      IdentityMatrix, Im, Implies, IncludeSingularTerm, Increment, 
      Indeterminate, Inequality, InexactNumbers, \[Infinity], Infix, Integer, 
      IntegerDigits, IntegerExponent, IntegerPart, IntegerQ, Integers, 
      Integrate, InterpolatingFunction, InterpolatingPolynomial, 
      Interpolation, InterpolationOrder, InterpolationPoints, 
      InverseBetaRegularized, InverseEllipticNomeQ, InverseErf, InverseErfc, 
      InverseFourier, InverseFourierCosTransform, InverseFourierSinTransform, 
      InverseFourierTransform, InverseFunction, InverseFunctions, 
      InverseGammaRegularized, InverseJacobiCD, InverseJacobiCN, 
      InverseJacobiCS, InverseJacobiDC, InverseJacobiDN, InverseJacobiDS, 
      InverseJacobiNC, InverseJacobiND, InverseJacobiNS, InverseJacobiSC, 
      InverseJacobiSD, InverseJacobiSN, InverseLaplaceTransform, 
      InverseSeries, InverseWeierstrassP, InverseZTransform, JacobiAmplitude, 
      Jacobian, JacobiCD, JacobiCN, JacobiCS, JacobiDC, JacobiDN, JacobiDS, 
      JacobiNC, JacobiND, JacobiNS, JacobiP, JacobiSC, JacobiSD, JacobiSN, 
      JacobiSymbol, JacobiZeta, JordanDecomposition, K, Khinchin, 
      KleinInvariantJ, KroneckerDelta, LaguerreL, LaplaceTransform, LCM, 
      LegendreP, LegendreQ, LegendreType, LerchPhi, Lexicographic, Limit, 
      LinearProgramming, LinearSolve, 
      WebServices`Security`Private`LinearSolveFunction, ListConvolve, 
      ListCorrelate, ListInterpolation, Log, LogGamma, LogicalExpand, 
      LogIntegral, LUDecomposition, MachineNumberQ, 
      WebServices`Security`Private`MachinePrecision, MainSolve, MakeRules, 
      MantissaExponent, MathieuC, MathieuCharacteristicA, 
      MathieuCharacteristicB, MathieuCharacteristicExponent, MathieuCPrime, 
      MathieuS, MathieuSPrime, MatrixExp, MatrixPower, MatrixQ, 
      WebServices`Security`Private`MatrixRank, MaxStepSize, 
      WebServices`Security`Private`Mean, WebServices`Security`Private`Median, 
      MeijerG, MaxRecursion, Method, WebServices`Security`Private`Minimize, 
      Minors, MinRecursion, Minus, Mod, Mode, Modular, ModularLambda, 
      Modulus, MoebiusMu, MonomialOrder, MonteCarlo, MultiDimensional, 
      Multinomial, MultiplicativeOrder, Multiplicity, N, NBernoulliB, 
      NDSolve, Negative, NevilleThetaC, NevilleThetaD, NevilleThetaN, 
      NevilleThetaS, Newton, NHoldAll, NHoldFirst, NHoldRest, NIntegrate, 
      WebServices`Security`Private`NMaximize, 
      WebServices`Security`Private`NMinimize, NonCommutativeMultiply, 
      NonConstants, NonNegative, NonPositive, 
      WebServices`Security`Private`Norm, NProduct, NProductExtraFactors, 
      NProductFactors, NRoots, Solve, NSum, NSumExtraTerms, NSumTerms, 
      Numerator, NumericFunction, NumericQ, NValues, O, OddQ, OneIdentity, 
      OneStepRowReduction, Operate, Order, Orderless, Oscillatory, OwnValues, 
      ParameterVariables, PartitionsP, PartitionsQ, \[Pi], Plus, Pochhammer, 
      PolyGamma, PolyLog, PolynomialGCD, PolynomialLCM, PolynomialMod, 
      PolynomialQ, PolynomialQuotient, PolynomialReduce, PolynomialRemainder, 
      Polynomials, Positive, Power, PowerExpand, PowerMod, PrecisionGoal, 
      PreDecrement, PreIncrement, Prime, PrimePi, PrimeQ, Primes, 
      PrincipalValue, Product, ProductLog, PseudoInverse, QRDecomposition, 
      WebServices`Security`Private`Quantile, QuasiMonteCarlo, QuasiNewton, 
      Quotient, Random, RationalFunctions, Rationalize, Rationals, Re, 
      RealBlockForm, RealDigits, Reals, Reduce, 
      WebServices`Security`Private`Refine, Residue, 
      WebServices`Security`Private`Resolve, Resultant, RiemannSiegelTheta, 
      RiemannSiegelZ, Root, RootReduce, Roots, RootSum, Round, RowReduce, 
      WebServices`Security`Private`RSolve, SameTest, SchurDecomposition, Sec, 
      Sech, SeedRandom, SequenceLimit, Series, SeriesCoefficient, SeriesData, 
      Signature, Simplify, Sin, SingularityDepth, 
      WebServices`Security`Private`SingularValueDecomposition, 
      WebServices`Security`Private`SingularValueList, Sinh, SinhIntegral, 
      SinIntegral, SixJSymbol, Solve, SolveAlways, SolveDelayed, 
      SphericalHarmonicY, Sqrt, 
      WebServices`Security`Private`StandardDeviation, StartingStepSize, 
      WebServices`Security`Private`StepMonitor, StieltjesGamma, StirlingS1, 
      StirlingS2, StoppingTest, StruveH, StruveL, Subresultants, Subtract, 
      SubtractFrom, Sum, Tan, Tanh, TargetFunctions, ThreeJSymbol, 
      TimeConstraint, Times, TimesBy, Together, Tolerance, ToRadicals, 
      ToRules, Tr, TransformationFunctions, Trapezoidal, Trig, TrigExpand, 
      TrigFactor, TrigFactorList, TrigReduce, TrigToExp, Underflow, UnitStep, 
      Using, Variables, WebServices`Security`Private`Variance, VectorQ, 
      VerifyConvergence, VerifySolutions, WeierstrassHalfPeriods, 
      WeierstrassInvariants, WeierstrassP, WeierstrassPPrime, 
      WeierstrassSigma, WeierstrassZeta, WorkingPrecision, WynnDegree, 
      ZeroTest, Zeta, 
      WebServices`Security`Private`$Assumptions, $MachinePrecision, \
$MachineEpsilon, $MaxExtraPrecision, $MaxMachineNumber, $MaxNumber, \
$MaxPrecision, $MaxRootDegree, $MinMachineNumber, $MinNumber, $MinPrecision, 
      ZTransform, $RandomState, ArgumentCountQ, AtomQ, Attributes, Byte, 
      ByteCount, ByteOrdering, Character, CharacterEncoding, 
      CharacterEncodingsPath, CharacterRange, Characters, Complex, 
      CompoundExpression, Context, Contexts, ContextToFilename, 
      ContextToFileName, Definition, Depth, Dimensions, DownValues, 
      EditDefinition, Expression, FullDefinition, Function, 
      WebServices`Security`Private`GeneratedParameters, Head, HeadCompose, 
      Heads, Hold, HoldAll, HoldAllComplete, HoldComplete, HoldFirst, 
      HoldForm, HoldPattern, HoldRest, Information, LeafCount, Level, 
      Listable, Literal, Locked, MakeExpression, NameQ, Names, Number, 
      NumberQ, OptionQ, Options, Out, Overflow, Part, Placeholder, Prepend, 
      PrependTo, PrimaryPlaceholder, Rational, Real, ReleaseHold, Removed, 
      Replace, ReplaceAll, ReplaceHeldPart, ReplaceList, ReplacePart, 
      ReplaceRepeated, Rest, Return, Reverse, RotateLeft, RotateRight, Rule, 
      RuleDelayed, SameQ, Scan, Sequence, SequenceHold, SetAccuracy, 
      SetPrecision, Shallow, Share, Short, Sign, Skeleton, Slot, 
      SlotSequence, WebServices`Security`Private`Sow, 
      WebServices`Security`Private`SparseArray, String, StringByteCount, 
      StringDrop, StringInsert, StringJoin, StringLength, StringMatchQ, 
      StringPosition, StringQ, StringReplace, StringReplacePart, 
      StringReverse, StringSkeleton, StringTake, StringToStream, SubValues, 
      Symbol, SymbolName, SyntaxLength, SyntaxQ, Temporary, Thread, Through, 
      ToHeldExpression, ToLowerCase, ToString, ToUpperCase, Unevaluated, 
      Unique, UnsameQ, Update, UpperCaseQ, ValueQ, Verbatim, Append, 
      AppendTo, Apply, Array, Complement, ComposeList, Count, DeleteCases, 
      Delimiters, DiagonalMatrix, Dispatch, Distribute, Drop, Element, 
      Extract, First, Flatten, FlattenAt, HashTable, HeldPart, Inner, Insert, 
      Intersection, Interval, IntervalIntersection, IntervalMemberQ, 
      IntervalUnion, Inverse, Join, Last, LatticeReduce, Length, List, ListQ, 
      Map, MapAll, MapAt, MapIndexed, MapThread, Max, 
      WebServices`Security`Private`Maximize, MaxIterations, 
      WebServices`Security`Private`Most, MemberQ, Min, Nest, NestList, 
      NestWhile, NestWhileList, NullSpace, OrderedQ, Ordering, Outer, 
      PadLeft, PadRight, Partition, Permutations, Pivoting, Range, 
      WebServices`Security`Private`Reap, Select, Sort, Split, Table, Take, 
      WebServices`Security`Private`Total, Transpose, Union, Alternatives, 
      And, BitAnd, BitNot, BitOr, BitXor, Blank, BlankNullSequence, 
      BlankSequence, Cases, Default, Equal, False, FreeQ, Greater, 
      GreaterEqual, If, IgnoreCase, Less, LessEqual, MatchQ, Nand, Nor, Not, 
      Optional, Or, Pattern, PatternTest, Position, Repeated, RepeatedNull, 
      Switch, True, TrueQ, Unequal, Which, Xor, AmbientLight, AspectRatio, 
      AspectRatioFixed, Axes, AxesEdge, AxesLabel, AxesOrigin, AxesStyle, 
      Axis, Boxed, Background, Circle, ClipFill, CMYKColor, ColorFunction, 
      ColorFunctionScaling, ColorOutput, ContourGraphics, ContourLines, 
      ContourPlot, Contours, ContourShading, ContourSmoothing, ContourStyle, 
      ColorSelectorSettings, Cuboid, Dashing, DefaultColor, DefaultFont, 
      DensityGraphics, DensityPlot, Disk, DisplayFunction, DisplayString, 
      Display, EdgeForm, Epilog, FaceForm, FaceGrids, FormatType, Frame, 
      FrameLabel, FrameStyle, FrameTicks, FullAxes, FullGraphics, Graphics, 
      Graphics3D, GraphicsArray, GraphicsData, GraphicsSpacing, GrayLevel, 
      GridLines, HiddenSurface, Hue, ImageResolution, ImageRotated, 
      ImageSize, Lighting, LightSources, Line, LineForm, ListContourPlot, 
      ListDensityPlot, ListPlot, ListPlot3D, MaxBend, MaxPoints, Mesh, 
      MeshRange, MeshStyle, Offset, ParametricPlot, ParametricPlot3D, Plot, 
      Plot3D, Plot3Matrix, PlotDivision, PlotJoined, PlotLabel, PlotPoints, 
      PlotRange, PlotRegion, PlotStyle, Point, PointForm, PointSize, Polygon, 
      PolygonIntersections, PostScript, Prolog, Raster, RasterArray, 
      Rectangle, RenderAll, RGBColor, RotateLabel, Scaled, SelectionAnimate, 
      Shading, Show, SphericalRegion, SurfaceColor, SurfaceGraphics, Text, 
      TextStyle, Thickness, Ticks, ToColor, ViewCenter, ViewPoint, 
      ViewVertical, $DefaultFont, $DisplayFunction, $FormatType, $TextStyle, 
      Break, Catch, Check, CheckAbort, CheckAll, Compile, Compiled, 
      CompiledFunction, CompileOptimizations, Condition, Continue, Do, For, 
      ForAll, Off, On, Throw, TimeConstrained, 
      While, $Aborted, $IterationLimit, $Line, $RecursionLimit, Begin, 
      BeginPackage, Block, DeclarePackage, End, EndAdd, EndPackage, Module, 
      With, AnchoredSearch, Find, Goto, Label, Record, RecordSeparators, 
      Word, WordSearch, WordSeparators, All, Automatic, Date, Debug, 
      FromDate, FromDigits, FullOptions, General, In, Input, InputStream, 
      InputString, InString, Interrupt, Message, MessageList, MessageName, 
      Messages, None, Null, Postfix, Print, Timing, Trace, TraceAbove, 
      TraceAction, TraceBackward, TraceDepth, TraceDialog, TraceForward, 
      TraceInternal, TraceLevel, TraceOff, TraceOn, TraceOriginal, 
      TracePrint, TraceScan, URL, XMLElement, 
      XMLObject, $, $Failed, $MessagePrePrint, $PrePrint, $PreRead, \
$TimeUnit, $TracePattern, $TracePostAction, $TracePreAction]\)], "Output",
  CellLabel->"Out[56]=",
  CellTags->"b:1.3.9"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(WebServices`Security`DisallowedSymbols\)], "Input",
  CellLabel->"In[57]:=",
  CellTags->"b:1.3.9"],

Cell[BoxData[
    \(WebServices`Security`DisallowedSymbols\)], "Output",
  CellLabel->"Out[57]=",
  CellTags->"b:1.3.9"]
}, Open  ]],

Cell["\<\
This model will allow any symbol in Global` context, in addition to a number \
of specific symbols.  This is a fairly restrictive model that provides a \
higher level of security.\
\>", "Text",
  CellTags->"b:1.3.9"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Debugging", "Subsection",
  CellTags->"b:1.3.10"],

Cell["\<\
While using a package, it is useful to include tools that help a user debug \
problems.  The Web Services Package provides a few symbols that should help \
debugging.  The debugging symbols are defined in the table.\
\>", "Text",
  CellTags->"b:1.3.10"],

Cell[BoxData[GridBox[{
        {"Symbol", "Description"},
        {"$PrintServiceRequest", 
          RowBox[{
            StyleBox["Uses",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["the",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], "Print", 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["function",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["to",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["print",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["the",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["message",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["in",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["XML",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["format",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["sent",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["to",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["a",
              FontFamily->"Times New Roman"], 
            StyleBox["  ",
              FontFamily->"Times New Roman"], 
            StyleBox["web",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            RowBox[{
              StyleBox["service",
                FontFamily->"Times New Roman"], "."}]}]},
        {"$PrintServiceResponse", 
          RowBox[{
            RowBox[{
              StyleBox["Uses",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["the",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["Print",
                FontFamily->"Courier"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["function",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["to",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["print",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["the",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["message",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["in",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["XML",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["format",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["received",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["from",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["a",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["web",
                FontFamily->"Times New Roman"], 
              StyleBox[" ",
                FontFamily->"Times New Roman"], 
              StyleBox["service",
                FontFamily->"Times New Roman"]}], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["\[IndentingNewLine]",
              FontFamily->"Times New Roman"], 
            
            StyleBox[\(before\ it\ is\ deserialized\ into\ a\ rule\ syntax\ \
\(\(expression\)\(.\)\)\),
              FontFamily->"Times New Roman"]}]},
        {"$PrintPerformanceNumbers", 
          
          StyleBox[\(Prints\ timing\ information\ that\ can\ be\ used\ to\ \
measure\ the\ performance\ of\ a\ web\ service\ \(\(call\)\(.\)\)\),
            FontFamily->"Times New Roman"]},
        {"$PrintWSDLDebug", 
          StyleBox[
            
            RowBox[{\(Prints\ information\ about\ web\ services\ being\ \
installed\ that\ can\ be\ used\ to\ debug . \ \ Information\ printed\ \
includes\ option\ values\), ",", 
              "\[IndentingNewLine]", \(parameter\ signatures\), ",", " ", 
              RowBox[{
              "and", " ", "the", " ", "endpoint", " ", "URI", " ", "for", " ",
                 "web", " ", "service", " ", 
                RowBox[{"operation", ".", Cell[TextData[StyleBox["",
                    FontFamily->"Times New Roman"]]]}]}]}],
            FontFamily->"Times New Roman"]},
        {"$PrintShortErrorMessages", 
          RowBox[{
            StyleBox["Specifies",
              FontFamily->"Times New Roman"], 
            StyleBox["  ",
              FontFamily->"Times New Roman"], 
            StyleBox["whether",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["error",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["messages",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["will",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["be",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["shortened",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["for",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["the",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["user",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["to",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["avoid",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["long",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["intimidating",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["error",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox[\(messages . \ \ The\),
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["default",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], 
            StyleBox["is",
              FontFamily->"Times New Roman"], 
            StyleBox[" ",
              FontFamily->"Times New Roman"], \(\(True\)\(.\)\)}]}
        },
      ColumnAlignments->{Left},
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Text",
  CellTags->"b:1.3.10"]
}, Open  ]],

Cell[CellGroupData[{

Cell["WS-I Profile Support", "Subsection",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  ButtonBox["WS-I Profiles",
    ButtonData:>{
      URL[ 
      "http://www.ws-i.org/Profiles/Basic/2003-08/BasicProfile-1.0a.htm"], 
      None},
    ButtonStyle->"Hyperlink"],
  " specify important new standards for building and using web services. The \
Web Services Package tries to follow the recommendations of the WS-I Profile. \
However, there are some recommendations that are not supported or required by \
the Web Services Package. This section documents the level of conformity by \
the Web Services Package to the WS-I Profile guidelines."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["3. Profile Conformance",
  FontSize->18,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell["3.1 Conformance of Artifacts", "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  StyleBox["* ",
    FontFamily->"Symbol"],
  StyleBox["MESSAGE\[LongDash]",
    FontWeight->"Bold"],
  "protocol elements that are exchanged, usually over a network, to effect a \
web service (e.g., SOAP/HTTP messages)\n*",
  StyleBox[" ",
    FontFamily->"Symbol"],
  StyleBox["DESCRIPTION\[LongDash]",
    FontWeight->"Bold"],
  "descriptions of types, messages, interfaces, and their concrete protocol \
and data format bindings, and the network access points associated with web \
services (e.g., WSDL descriptions) \n*",
  StyleBox[" ",
    FontFamily->"Symbol"],
  StyleBox["REGDATA\[LongDash]",
    FontWeight->"Bold"],
  "registry elements that are involved in the registration and discovery of \
web services (e.g. UDDI tModels) "
}], "Text",
  CellTags->"b:1.3.11"],

Cell["3.2 Conformance of Services, Consumers and Registries", "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  StyleBox["* ",
    FontFamily->"Symbol"],
  StyleBox["INSTANCE\[LongDash]",
    FontWeight->"Bold"],
  "software that implements a ",
  StyleBox["wsdl:port",
    FontFamily->"Courier New",
    FontSize->10],
  " or a ",
  StyleBox["uddi:bindingTemplate",
    FontFamily->"Courier New",
    FontSize->10],
  "\n",
  StyleBox["* ",
    FontFamily->"Symbol"],
  StyleBox["CONSUMER\[LongDash]",
    FontWeight->"Bold"],
  "software that invokes an INSTANCE \n*",
  StyleBox[" ",
    FontFamily->"Symbol"],
  StyleBox["REGISTRY\[LongDash]",
    FontWeight->"Bold"],
  "a UDDI registry, capable of managing REGDATA"
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  StyleBox["* SENDER\[LongDash]",
    FontWeight->"Bold"],
  "software that generates a message according to the protocol(s) associated \
with it \n* ",
  StyleBox["RECEIVER\[LongDash]",
    FontWeight->"Bold"],
  "software that consumes a message according to the protocol(s) associated \
with it (e.g., SOAP processors) "
}], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R0001 An INSTANCE MUST be described by a WSDL 1.1 service description, by a \
UDDI binding template, or both.
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["3.3 Conformance Annotation in Descriptions",
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R0002 A DESCRIPTION MAY contain conformance claims regarding instances, as \
specified in the conformance claim schema.
Not supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R0003 A DESCRIPTION\[CloseCurlyQuote]s conformance claims MUST be children \
of the ",
  StyleBox["wsdl:documentation",
    FontFamily->"Courier New",
    FontSize->10],
  " element of each of the elements: ",
  StyleBox["wsdl:port",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["wsdl:portType",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["wsdl:operation",
    FontFamily->"Courier New",
    FontSize->10],
  " (as a child element of ",
  StyleBox["wsdl:portType",
    FontFamily->"Courier New",
    FontSize->10],
  " but not of ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  ") and ",
  StyleBox["wsdl:message",
    FontFamily->"Courier New",
    FontSize->10],
  ".\nNot supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell["3.4 Conformance Annotation in Messages", "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.11"],

Cell["\<\
R0004 A MESSAGE MAY contain conformance claims, as specified in the \
conformance claim schema. 
Not supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R0005 A MESSAGE\[CloseCurlyQuote]s conformance claims MUST be carried as SOAP \
header blocks. 
Not supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R0006 A MESSAGE MAY contain conformance claims for more than one profile. 
Not supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R0007 A SENDER MUST NOT use the ",
  StyleBox["soap:mustUnderstand",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute when sending a SOAP header block containing a conformance \
claim.\nNot supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell["3.5 Conformance Annotation in Registry Data", "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R3020 REGDATA of type ",
  StyleBox["uddi:tModel",
    FontFamily->"Courier New",
    FontSize->10],
  " claiming conformance with a profile MUST be categorized using the \
ws-i-org:conformsTo:2002_12 taxonomy. \nNot supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R3030 REGDATA of type ",
  StyleBox["uddi:tModel",
    FontFamily->"Courier New",
    FontSize->10],
  " claiming conformance with a profile MUST use the \
ws-i-org:conformsTo:2002_12 categorization value corresponding to the \
conformance claim URI for that profile.\nNot supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R3021 A REGISTRY MUST support the WS-I conformance category system by adding \
the ws-i-org:conformsTo:2002_12 tModel definition to its registry content. 
Not supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R3005 REGDATA other than ",
  StyleBox["uddi:tModel",
    FontFamily->"Courier New",
    FontSize->10],
  " elements representing conformant web service types MUST NOT be \
categorized using the ws-i-org:conformsTo:2002_12 taxonomy and a \
categorization of \[OpenCurlyDoubleQuote]http://ws-i.org/profiles/basic/1.0\
\[CloseCurlyDoubleQuote]. \nNot supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R3004",
  " REGDATA of type ",
  StyleBox["uddi:tModel",
    FontFamily->"Courier New",
    FontSize->10],
  " MUST be constructed so that the conformance claim it makes is consistent \
with the conformance claim made by the ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " to which it refers. \nNot supported.",
  ""
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4. Messaging",
  FontSize->18,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell["4.1 XML Representation of SOAP Messages", "Text",
  FontWeight->"Bold",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.1 SOAP Messages and the Unicode BOM",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R4001 A RECEIVER MUST accept messages that include the Unicode Byte Order \
Mark (BOM).\nNot directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.2 SOAP Fault Syntax",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1000 When a MESSAGE contains a ",
  StyleBox["soap:Fault",
    FontFamily->"Courier New",
    FontSize->10],
  " element, that element MUST NOT have element children other than ",
  StyleBox["faultcode",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["faultstring",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["faultactor",
    FontFamily->"Courier New",
    FontSize->10],
  ", and ",
  StyleBox["detail",
    FontFamily->"Courier New",
    FontSize->10],
  ".\nSOAP faults are handled by Axis. This should be documented in the Axis \
documentation."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.3 SOAP Faults and Namespaces",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1001 When a MESSAGE contains a ",
  StyleBox["soap:Fault",
    FontFamily->"Courier New",
    FontSize->10],
  " element, its element children MUST be unqualified.\nSOAP faults are \
handled by Axis. This should be documented in the Axis documentation."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.4 SOAP Fault Extensibility",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1002 A RECEIVER MUST accept fault messages that have any number of \
elements, including zero, appearing as children of the ",
  StyleBox["detail",
    FontFamily->"Courier New",
    FontSize->10],
  " element. Such children can be qualified or unqualified. \nSOAP faults are \
handled by Axis. This should be documented in the Axis documentation."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1003 A RECEIVER MUST accept fault messages that have any number of \
qualified or unqualified attributes, including zero, appearing on the ",
  StyleBox["detail",
    FontFamily->"Courier New",
    FontSize->10],
  " element. The namespace of qualified attributes can be anything other than \
\[OpenCurlyDoubleQuote]http://schemas.xmlsoap.org/soap/envelope/\
\[CloseCurlyDoubleQuote]. \nSOAP faults are handled by Axis. This should be \
documented in the Axis documentation."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.5 SOAP Fault Language",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1016 A RECEIVER MUST accept fault messages that carry an ",
  StyleBox["xml:lang",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on the ",
  StyleBox["faultstring",
    FontFamily->"Courier New",
    FontSize->10],
  " element. \nSOAP faults are handled by Axis. This should be documented in \
the Axis documentation."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.6 SOAP Custom Fault Codes",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1004 When a MESSAGE contains a ",
  StyleBox["faultcode",
    FontFamily->"Courier New",
    FontSize->10],
  " element, the content of that element SHOULD be one of the fault codes \
defined in SOAP 1.1 or a namespace qualified fault code. \nSOAP faults are \
handled by Axis. This should be documented in the Axis documentation."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1031 When a MESSAGE contains a ",
  StyleBox["faultcode",
    FontFamily->"Courier New",
    FontSize->10],
  " element, the content of that element SHOULD NOT use the SOAP 1.1 \
\[OpenCurlyDoubleQuote]dot\[CloseCurlyDoubleQuote] notation to refine the \
meaning of the fault. \nSOAP faults are handled by Axis. This should be \
documented in the Axis documentation."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.7 SOAP encodingStyle Attribute",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1005 A MESSAGE MUST NOT contain ",
  StyleBox["soap:encodingStyle",
    FontFamily->"Courier New",
    FontSize->10],
  " attributes on any of the elements whose namespace name is \
\[OpenCurlyDoubleQuote]http://schemas.xmlsoap.org/soap/envelope/\
\[CloseCurlyDoubleQuote].\nNot supported. This is not supported as the Web \
Services Package supports rpc/encoded web services. This is required to be \
encoded."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1006 A MESSAGE MUST NOT contain ",
  StyleBox["soap:encodingStyle",
    FontFamily->"Courier New",
    FontSize->10],
  " attributes on any element that is a child of ",
  StyleBox["soap:Body",
    FontFamily->"Courier New",
    FontSize->10],
  ".\nNot supported. This is not supported as the Web Services Package \
supports rpc/encoded web services. This is required to be encoded."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1007 A MESSAGE described in an rpc-literal binding MUST NOT contain ",
  StyleBox["soap:encodingStyle",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on any elements that are grandchildren of ",
  StyleBox["soap:Body",
    FontFamily->"Courier New",
    FontSize->10],
  ".\nSupported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.8 SOAP\[CloseCurlyQuote]s use of XML",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R1008 A MESSAGE MUST NOT contain a Document Type Declaration (DTD).
Supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1009 A MESSAGE MUST NOT contain processing instructions.
Supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.9 SOAP and XML Declarations",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R1010 A RECEIVER MUST accept messages that contain an XML declaration.
Supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.10 SOAP Trailers",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1011 A MESSAGE MUST NOT have any element children of ",
  StyleBox["soap:Envelope",
    FontFamily->"Courier New",
    FontSize->10],
  " following the ",
  StyleBox["soap:Body",
    FontFamily->"Courier New",
    FontSize->10],
  " element. \nSupported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.11 Acceptable SOAP Character Encodings",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R1012 A MESSAGE MUST be serialized as either UTF-8 or UTF-16. 
Supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1018 The media type of a MESSAGE\[CloseCurlyQuote]s envelope MUST \
indicate the correct character encoding, using the ",
  StyleBox["charset",
    FontFamily->"Courier"],
  " parameter.\nNot directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.12 SOAP mustUnderstand Attribute",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1013 A MESSAGE containing a ",
  StyleBox["soap:mustUnderstand",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute MUST only use the lexical forms \[OpenCurlyDoubleQuote]0\
\[CloseCurlyDoubleQuote] and \
\[OpenCurlyDoubleQuote]1\[CloseCurlyDoubleQuote].\nSupported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.13 SOAP Body and Namespaces",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1014",
  " The children of the ",
  StyleBox["soap:Body",
    FontFamily->"Courier New",
    FontSize->10],
  " element in a MESSAGE MUST be namespace qualified. \nSupported.",
  ""
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.14 SOAP Envelope Namespace",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1015 A RECEIVER MUST generate a fault if they encounter a message whose \
document element has a local name of \[OpenCurlyDoubleQuote]Envelope\
\[CloseCurlyDoubleQuote] but a namespace name that is not \
\[OpenCurlyDoubleQuote]http://schemas.xmlsoap.org/soap/envelope/\
\[CloseCurlyDoubleQuote]. \nNot directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.1.15 Use of xsi:type Attributes",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1017 A RECEIVER MUST NOT mandate the use of the ",
  StyleBox["xsi:type",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute in messages except as required in order to indicate a derived \
type (see",
  ButtonBox[" XML Schema Part 1: Structures, Section 2.6.1",
    ButtonData:>{
      URL[ 
      "http://www.w3.org/TR/xmlschema-1/#Instance_Document_Constructions"], 
      None},
    ButtonStyle->"Hyperlink"],
  "). \nSupported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.2 SOAP Processing Model",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.2.1 Mandatory Headers",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R1025 A RECEIVER MUST handle messages in such a way that it appears that all \
checking of mandatory header blocks is performed before any actual \
processing. SOAP12
Not supported.  The client does not support processing headers.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.2.2 Generating mustUnderstand Faults",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1027 A RECEIVER MUST generate a \
\[OpenCurlyDoubleQuote]soap:MustUnderstand\[CloseCurlyDoubleQuote] fault when \
a message contains a mandatory header block (i.e., one that has a ",
  StyleBox["soap:mustUnderstand",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute with the value \
\[OpenCurlyDoubleQuote]1\[CloseCurlyDoubleQuote]) targeted at the receiver \
(via ",
  StyleBox["soap:actor",
    FontFamily->"Courier New",
    FontSize->10],
  ") that the receiver does not understand.\nNot supported.  The client does \
not support processing headers."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.2.3 SOAP Fault Processing",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R1028 When a fault is generated by a RECEIVER, further processing SHOULD NOT \
be performed on the SOAP message aside from that which is necessary to \
rollback, or compensate for, any effects of processing the message prior to \
the generation of the fault. 
Not supported.  The client does not support processing headers.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1029 Where the normal outcome of processing a SOAP message would have \
resulted in the transmission of a SOAP response, but rather a SOAP fault is \
generated instead, a RECEIVER MUST transmit a SOAP fault message in place of \
the response. 
Supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1030 A RECEIVER that generates a SOAP fault SHOULD notify the end user that \
a SOAP fault has been generated when practical, by whatever means is deemed \
appropriate to the circumstance. 
Not supported. The client does not do this by default.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.3 Use of SOAP in HTTP",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.3.1 HTTP Versions",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R1140 A MESSAGE SHOULD be sent using HTTP/1.1.
Supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1141 A MESSAGE MUST be sent using either HTTP/1.1 or HTTP/1.0.
Supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.3.2 Identifying SOAP Faults",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1107 A RECEIVER MUST interpret SOAP messages containing only a ",
  StyleBox["soap:Fault",
    FontFamily->"Courier New",
    FontSize->10],
  " element as a fault.\nNot directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.3.3 HTTP Methods and Extensions",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R1132 A HTTP request MESSAGE MUST use the HTTP POST method.
Supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1108 A MESSAGE MUST NOT use the HTTP Extension Framework (RFC2774).
Supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.3.4 SOAPAction Header Syntax",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1109 The value of the ",
  StyleBox["SOAPAction",
    FontFamily->"Courier New",
    FontSize->10],
  " HTTP header field in a HTTP request MESSAGE MUST be a quoted string.\nNot \
directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R1119 A RECEIVER MAY respond with a fault if the value of the ",
  StyleBox["SOAPAction",
    FontFamily->"Courier New",
    FontSize->10],
  " HTTP header field is not quoted. \nNot supported.  The client does not \
support SOAPAction headers."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.3.5 HTTP and TCP Ports",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1110 An INSTANCE MAY accept connections on TCP port 80 (HTTP).
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.3.6 HTTP Success Status Codes",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1124 An INSTANCE MUST use a 2xx HTTP status code for responses that indicate \
a successful outcome of a request.
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1111 An INSTANCE SHOULD use a \[OpenCurlyDoubleQuote]200 OK\
\[CloseCurlyDoubleQuote] HTTP status code for responses that contain a SOAP \
message that is not a SOAP fault.
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1112 An INSTANCE SHOULD use either a \[OpenCurlyDoubleQuote]200 OK\
\[CloseCurlyDoubleQuote] or \[OpenCurlyDoubleQuote]202 Accepted\
\[CloseCurlyDoubleQuote] HTTP status code for a response that does not \
contain a SOAP message but indicates successful HTTP outcome of a request.
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.3.7 HTTP Redirect Status Codes",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R1130 An INSTANCE MUST use HTTP status code \[OpenCurlyDoubleQuote]307 \
Temporary Redirect\[CloseCurlyDoubleQuote] when redirecting a request to a \
different endpoint.
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1131 A CONSUMER MAY automatically redirect a request when it encounters a \
\[OpenCurlyDoubleQuote]307 Temporary Redirect\[CloseCurlyDoubleQuote] HTTP \
status code in a response.
Supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.3.8 HTTP Client Error Status Codes",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R1125 An INSTANCE MUST use a 4xx HTTP status code for responses that indicate \
a problem with the format of the request.
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1113 An INSTANCE SHOULD use a \[OpenCurlyDoubleQuote]400 Bad Request\
\[CloseCurlyDoubleQuote] HTTP status code, if the request message is a \
malformed HTTP request or not well-formed XML.
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1114 An INSTANCE SHOULD use a \[OpenCurlyDoubleQuote]405 Method not Allowed\
\[CloseCurlyDoubleQuote] HTTP status code if the request method was not \
\[OpenCurlyDoubleQuote]POST\[CloseCurlyDoubleQuote].
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1115 An INSTANCE SHOULD use a \[OpenCurlyDoubleQuote]415 Unsupported Media \
Type\[CloseCurlyDoubleQuote] HTTP status code if the Content-Type HTTP \
request header did not have a value consistent with the value specified for \
the corresponding binding of the input message.
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.3.9 HTTP Server Error Status Codes",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R1126 An INSTANCE MUST use a \[OpenCurlyDoubleQuote]500 Internal Server Error\
\[CloseCurlyDoubleQuote] HTTP status code if the response message is a SOAP \
fault.
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["4.3.10 HTTP Cookies",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1120 An INSTANCE MAY use the HTTP state mechanism \
(\[OpenCurlyDoubleQuote]cookies\[CloseCurlyDoubleQuote]).
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1122 An INSTANCE using cookies SHOULD conform to RFC2965.
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1121 An INSTANCE SHOULD NOT require consumer support for cookies in order to \
function correctly.
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R1123 The value of the cookie MUST be considered to be opaque by the \
CONSUMER.
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5. Service Description",
  FontSize->18,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.1 Document Structure",
  FontSize->14,
  FontWeight->"Bold",
  FontSlant->"Plain"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.1.1 WSDL Schema Definitions",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R2028 A DESCRIPTION using the WSDL namespace (prefixed \
\[OpenCurlyDoubleQuote]wsdl\[CloseCurlyDoubleQuote] in this profile) MUST be \
valid according to the XML Schema found at \
http://schemas.xmlsoap.org/wsdl/2003-02-11.xsd. 
Required.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R2029 A DESCRIPTION using the WSDL SOAP binding namespace (prefixed \
\[OpenCurlyDoubleQuote]soapbind\[CloseCurlyDoubleQuote] in this profile) MUST \
be valid according to the XML Schema found at \
http://schemas.xmlsoap.org/wsdl/soap/2003-02-11.xsd. 
Required.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.1.2 WSDL and Schema Import",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R2001 A DESCRIPTION MUST only use the WSDL \[OpenCurlyDoubleQuote]import\
\[CloseCurlyDoubleQuote] statement to import another WSDL description. 
Required.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R2002 To import XML Schema definitions, a DESCRIPTION MUST use the XML Schema \
\[OpenCurlyDoubleQuote]import\[CloseCurlyDoubleQuote] statement. 
Required.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2003 A DESCRIPTION MUST use the XML Schema \[OpenCurlyDoubleQuote]import\
\[OpenCurlyDoubleQuote] statement only within the ",
  StyleBox["xsd:schema",
    FontFamily->"Courier New",
    FontSize->10],
  " element of the types section. \nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R2004 A DESCRIPTION MUST NOT use the XML Schema \[OpenCurlyDoubleQuote]import\
\[CloseCurlyDoubleQuote] statement to import a schema from any document whose \
root element is not \[OpenCurlyDoubleQuote]schema\[CloseCurlyDoubleQuote] \
from the namespace \[OpenCurlyDoubleQuote]http://www.w3.org/2001/XMLSchema\
\[CloseCurlyDoubleQuote]. 
Required.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2009 An XML Schema directly or indirectly imported by a DESCRIPTION MAY \
include the Unicode BOM.\nNot directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R2010 An XML Schema directly or indirectly imported by a DESCRIPTION MUST use \
either UTF-8 or UTF-16 encoding.
Required.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R2011 An XML Schema directly or indirectly imported by a DESCRIPTION MUST use \
version 1.0 of the eXtensible Markup Language W3C Recommendation.
Required.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.1.3 WSDL Import location Attribute Syntax",
  FontWeight->"Bold",
  FontVariations->{"Underline"->False}]], "Text",
  FontSlant->"Italic",
  FontVariations->{"Underline"->True},
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2007 A DESCRIPTION MUST specify a non-empty ",
  StyleBox["location",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on the ",
  StyleBox["wsdl:import",
    FontFamily->"Courier New",
    FontSize->10],
  " element. \nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.1.4 WSDL Import location Attribute Semantics",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2008 In a DESCRIPTION the value of the ",
  StyleBox["location",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute of a ",
  StyleBox["wsdl:import",
    FontFamily->"Courier New",
    FontSize->10],
  " element SHOULD be treated as a hint.\nNot supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.1.5 Placement of WSDL import Elements",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2022 When they appear in a DESCRIPTION, ",
  StyleBox["wsdl:import",
    FontFamily->"Courier New",
    FontSize->10],
  " elements MUST precede all other elements from the WSDL namespace except \
",
  StyleBox["wsdl:documentation",
    FontFamily->"Courier New",
    FontSize->10],
  ".\nNot directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2023 When they appear in a DESCRIPTION, ",
  StyleBox["wsdl:types",
    FontFamily->"Courier New",
    FontSize->10],
  " elements MUST precede all other elements from the WSDL namespace except \
",
  StyleBox["wsdl:documentation",
    FontFamily->"Courier New",
    FontSize->10],
  " and ",
  StyleBox["wsdl:import",
    FontFamily->"Courier New",
    FontSize->10],
  ".\nNot directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.1.6 XML Version Requirements",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R4004 A DESCRIPTION MUST use version 1.0 of the eXtensible Markup Language \
W3C Recommendation.
Required.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.1.7 WSDL and the Unicode BOM",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R4002 A DESCRIPTION MAY include the Unicode BOM.\nNot directly supported \
by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.1.8 Acceptable WSDL Character Encodings",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R4003 A DESCRIPTION MUST use either UTF-8 or UTF-16 encoding.
Required.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.1.9 Namespace Coercion",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2005",
  " The ",
  StyleBox["targetNamespace",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on the ",
  StyleBox["wsdl:definitions",
    FontFamily->"Courier New",
    FontSize->10],
  " element of a description that is being imported MUST have same the value \
as the ",
  StyleBox["namespace",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on the ",
  StyleBox["wsdl:import",
    FontFamily->"Courier New",
    FontSize->10],
  " element in the importing DESCRIPTION. \nRequired.",
  ""
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.1.10 WSDL documentation Element",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2020 The ",
  StyleBox["wsdl:documentation",
    FontFamily->"Courier New",
    FontSize->10],
  " element MAY occur as a child of the ",
  StyleBox["wsdl:import",
    FontFamily->"Courier New",
    FontSize->10],
  " element in a DESCRIPTION.\nSupported, but this will be ignored by the \
client."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2021 The ",
  StyleBox["wsdl:documentation",
    FontFamily->"Courier New",
    FontSize->10],
  " element MAY occur as a child of the ",
  StyleBox["wsdl:part",
    FontFamily->"Courier New",
    FontSize->10],
  " element in a DESCRIPTION.\nSupported, but this will be ignored by the \
client."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2024 The ",
  StyleBox["wsdl:documentation",
    FontFamily->"Courier New",
    FontSize->10],
  " element MAY occur as a first child of the ",
  StyleBox["wsdl:definitions",
    FontFamily->"Courier New",
    FontSize->10],
  " element in a DESCRIPTION.\nSupported, but this will be ignored by the \
client."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.1.11 WSDL Extensions",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R2025 A DESCRIPTION containing WSDL extensions MUST NOT use them to \
contradict other requirements of the profile.
Not supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2026 A DESCRIPTION SHOULD NOT include extension elements with a ",
  StyleBox["wsdl:required",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute value of \[OpenCurlyDoubleQuote]",
  StyleBox["true",
    FontFamily->"Courier"],
  "\[CloseCurlyDoubleQuote] on any WSDL construct (",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["wsdl:portType",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["wsdl:message",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["wsdl:types",
    FontFamily->"Courier New",
    FontSize->10],
  " or ",
  StyleBox["wsdl:import",
    FontFamily->"Courier New",
    FontSize->10],
  ") that claims conformance to the profile.\nNot supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2027 If during the processing of an element in the WSDL namespace in a \
description a consumer encounters a WSDL extension element amongst its \
element children that has a ",
  StyleBox["wsdl:required",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute with a boolean value of \[OpenCurlyDoubleQuote]true\
\[CloseCurlyDoubleQuote] that the consumer does not understand or cannot \
process, the CONSUMER MUST fail processing of that element in the WSDL \
namespace.\nNot supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.2 Types",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.2.1 QName References",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R2101 A DESCRIPTION MUST NOT use QName references to elements in namespaces \
that have been neither imported nor defined in the referring WSDL document. 
Required.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2102 A QName reference to a schema component in a DESCRIPTION MUST use \
the namespace defined in the ",
  StyleBox["targetNamespace",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on the ",
  StyleBox["xsd:schema",
    FontFamily->"Courier New",
    FontSize->10],
  " element, or to a namespace defined in the ",
  StyleBox["namespace",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on an ",
  StyleBox["xsd:import",
    FontFamily->"Courier New",
    FontSize->10],
  " element within the ",
  StyleBox["xsd:schema",
    FontFamily->"Courier New",
    FontSize->10],
  " element.\nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.2.2 Schema targetNamespace Syntax",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2105 All ",
  StyleBox["xsd:schema",
    FontFamily->"Courier New",
    FontSize->10],
  " elements contained in a ",
  StyleBox["wsdl:types",
    FontFamily->"Courier New",
    FontSize->10],
  " element of a DESCRIPTION MUST have a ",
  StyleBox["targetNamespace",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute with a valid and non-null value, UNLESS the ",
  StyleBox["xsd:schema",
    FontFamily->"Courier New",
    FontSize->10],
  " element has ",
  StyleBox["xsd:import",
    FontFamily->"Courier New",
    FontSize->10],
  " and/or ",
  StyleBox["xsd:annotation",
    FontFamily->"Courier New",
    FontSize->10],
  " as its only child element(s). \nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.2.3 soapenc:Array",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2110 In a DESCRIPTION array declarations MUST NOT extend or restrict the \
",
  StyleBox["soapenc:Array",
    FontFamily->"Courier New",
    FontSize->10],
  " type. \nNot required."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2111 In a DESCRIPTION array declarations MUST NOT use ",
  StyleBox["wsdl:arrayType",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute in the type declaration. \nNot required."
}], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R2112 In a DESCRIPTION array declaration wrapper elements SHOULD NOT be named \
using the convention ArrayOfXXX. 
Not supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2113 A MESSAGE containing serialized arrays MUST NOT include the ",
  StyleBox["soapenc:arrayType",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute. \nNot required."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.2.4 WSDL and Schema Definition Target Namespaces",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R2114 The target namespace for WSDL definitions and the target namespace for \
schema definitions in a DESCRIPTION MAY be the same.
Supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.3 Messages",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.3.1 Bindings and Parts",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2201 A document-literal binding in a DESCRIPTION MUST, in each of its ",
  StyleBox["soapbind:body",
    FontFamily->"Courier New",
    FontSize->10],
  " elements, have at most one part listed in the ",
  StyleBox["parts",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute, if the ",
  StyleBox["parts",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute is specified. \nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2210 If a document-literal binding in a DESCRIPTION does not specify the \
",
  StyleBox["parts",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on a ",
  StyleBox["soapbind:body",
    FontFamily->"Courier New",
    FontSize->10],
  " element, the corresponding abstract ",
  StyleBox["wsdl:message",
    FontFamily->"Courier New",
    FontSize->10],
  " MUST define zero or one ",
  StyleBox["wsdl:part",
    FontFamily->"Courier New",
    FontSize->10],
  " elements(s). \nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2202 A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MAY contain ",
  StyleBox["soapbind:body",
    FontFamily->"Courier New",
    FontSize->10],
  " elements that specify that zero parts form the ",
  StyleBox["soap:Body",
    FontFamily->"Courier New",
    FontSize->10],
  ". \nSupported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2203 An rpc-literal binding in a DESCRIPTION MUST refer, in its ",
  StyleBox["soapbind:body",
    FontFamily->"Courier New",
    FontSize->10],
  " element(s), only to ",
  StyleBox["wsdl:part",
    FontFamily->"Courier New",
    FontSize->10],
  " elements that have been defined using the ",
  StyleBox["type",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute. \nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2211 A MESSAGE described with an rpc-literal binding MUST NOT have the ",
  StyleBox["xsi:nil",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute with a value of \
\[OpenCurlyDoubleQuote]1\[CloseCurlyDoubleQuote] or \
\[OpenCurlyDoubleQuote]true\[CloseCurlyDoubleQuote] on the part accessors. \n\
Supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2207",
  " A ",
  StyleBox["wsdl:message",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MAY contain ",
  StyleBox["wsdl:part",
    FontFamily->"Courier New",
    FontSize->10],
  "s that use the ",
  StyleBox["elements",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute, provided those ",
  StyleBox["wsdl:part",
    FontFamily->"Courier New",
    FontSize->10],
  "s are not referred to by a ",
  StyleBox["soapbind:body",
    FontFamily->"Courier New",
    FontSize->10],
  " in an rpc-literal binding. \nSupported.",
  ""
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2204",
  " A document-literal binding in a DESCRIPTION MUST refer, in each of its ",
  StyleBox["soapbind:body",
    FontFamily->"Courier New",
    FontSize->10],
  " element(s), only to ",
  StyleBox["wsdl:part",
    FontFamily->"Courier New",
    FontSize->10],
  " element(s) that have been defined using the ",
  StyleBox["element",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute. \nRequired.",
  ""
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2208 A binding in a DESCRIPTION MAY contain ",
  StyleBox["soapbind:header",
    FontFamily->"Courier New",
    FontSize->10],
  " element(s) that refer to ",
  StyleBox["wsdl:part",
    FontFamily->"Courier New",
    FontSize->10],
  " element(s) in the same ",
  StyleBox["wsdl:message",
    FontFamily->"Courier New",
    FontSize->10],
  " that are referred to by its ",
  StyleBox["soapbind:body",
    FontFamily->"Courier New",
    FontSize->10],
  " element(s). \nNot directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.3.2 Bindings and Faults",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2205 A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MUST refer, in each of its ",
  StyleBox["soapbind:header",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["soapbind:headerfault",
    FontFamily->"Courier New",
    FontSize->10],
  ", and ",
  StyleBox["soapbind:fault",
    FontFamily->"Courier New",
    FontSize->10],
  " elements, only to ",
  StyleBox["wsdl:part",
    FontFamily->"Courier New",
    FontSize->10],
  " element(s) that have been defined using the ",
  StyleBox["element",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute. \nNot directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.3.3 Unbound portType Element Contents",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2209 A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION SHOULD bind every ",
  StyleBox["wsdl:part",
    FontFamily->"Courier New",
    FontSize->10],
  " of a ",
  StyleBox["wsdl:message",
    FontFamily->"Courier New",
    FontSize->10],
  " in the ",
  StyleBox["wsdl:portType",
    FontFamily->"Courier New",
    FontSize->10],
  " to which it refers to one of ",
  StyleBox["soapbind:body",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["soapbind:header",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["soapbind:fault",
    FontFamily->"Courier New",
    FontSize->10],
  ", or ",
  StyleBox["soapbind:headerfault",
    FontFamily->"Courier New",
    FontSize->10],
  ". \nNot directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.3.4 Declaration of part Elements",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2206 A ",
  StyleBox["wsdl:message",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION containing a ",
  StyleBox["wsdl:part",
    FontFamily->"Courier New",
    FontSize->10],
  " that uses the ",
  StyleBox["element",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute MUST refer, in that attribute, to a global element declaration. \
\nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.4 Port Types",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.4.1 Ordering of part Elements",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2301 The order of the elements in the ",
  StyleBox["soap:body",
    FontFamily->"Courier New",
    FontSize->10],
  " of a MESSAGE MUST be the same as that of the ",
  StyleBox["wsdl:part",
    FontFamily->"Courier New",
    FontSize->10],
  " element(s) in the ",
  StyleBox["wsdl:message",
    FontFamily->"Courier New",
    FontSize->10],
  " that describes it. \nSupported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.4.2 Allowed Operations",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2303 A DESCRIPTION MUST NOT use ",
  StyleBox["Solicit-Response",
    FontFamily->"Courier New"],
  " and ",
  StyleBox["Notification",
    FontFamily->"Courier"],
  " type operations in a ",
  StyleBox["wsdl:portType",
    FontFamily->"Courier New",
    FontSize->10],
  " definition. \nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.4.3 Distinctive Operations",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2304 A ",
  StyleBox["wsdl:portType",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MUST have operations with distinct values for their ",
  StyleBox["name",
    FontFamily->"Courier New",
    FontSize->10],
  " attributes. \nNot required, but recommended."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.4.4 parameterOrder Attribute Construction",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2305 A ",
  StyleBox["wsdl:portType",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MUST be constructed so that the ",
  StyleBox["parameterOrder",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute, if present, omits at most one ",
  StyleBox["wsdl:part",
    FontFamily->"Courier New",
    FontSize->10],
  " from the output message. \nNot required.  The ",
  StyleBox["parameterOrder",
    FontFamily->"Courier"],
  " attribute is not used in the client."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.4.5 Exclusivity of type and element Attributes",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2306",
  " A ",
  StyleBox["wsdl:message",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MUST NOT specify both ",
  StyleBox["type",
    FontFamily->"Courier New",
    FontSize->10],
  " and ",
  StyleBox["element",
    FontFamily->"Courier New",
    FontSize->10],
  " attributes on the same ",
  StyleBox["wsdl:part",
    FontFamily->"Courier New",
    FontSize->10],
  ". \nRequired.",
  ""
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.5 Bindings",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.5.1 Use of SOAP Binding",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2401 A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " element in a DESCRIPTION MUST use WSDL SOAP Binding as defined in ",
  StyleBox[ButtonBox["WSDL 1.1 Section 3",
    ButtonData:>{
      URL[ "http://www.w3.org/TR/wsdl#_soap-b"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  ". \nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6 SOAP Binding",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.1 Specifying the transport Attribute",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2701 The ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " element in a DESCRIPTION MUST be constructed so that its ",
  StyleBox["soapbind:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " child element specifies the ",
  StyleBox["transport",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute. \nNot required."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.2 HTTP Transport",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2702 A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " element in a DESCRIPTION MUST specify the HTTP transport protocol with \
SOAP binding. Specifically, the ",
  StyleBox["transport",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute of its ",
  StyleBox["soapbind:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " child MUST have the value \
\[OpenCurlyDoubleQuote]http://schemas.xmlsoap.org/soap/http\
\[CloseCurlyDoubleQuote]. \nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.3 Consistency of style Attribute",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2705 A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MUST use either a rpc-literal binding or a \
document-literal binding. \nNot required.  The rpc-encoded binding is \
supported as well."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.4 Encodings and the use Attribute",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2706 A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MUST use the value of \[OpenCurlyDoubleQuote]",
  StyleBox["literal",
    FontFamily->"Courier New",
    FontSize->10],
  "\[CloseCurlyDoubleQuote] for the ",
  StyleBox["use",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute in all ",
  StyleBox["soapbind:body",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["soapbind:fault",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["soapbind:header",
    FontFamily->"Courier New",
    FontSize->10],
  ", and ",
  StyleBox["soapbind:headerfault",
    FontFamily->"Courier New",
    FontSize->10],
  " elements. \nNot required.  The value \[OpenCurlyDoubleQuote]",
  StyleBox["encoded",
    FontFamily->"Courier New",
    FontSize->10],
  "\[CloseCurlyDoubleQuote] is valid as well."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.5 Default for use Attribute",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2707 A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION that contains one or more ",
  StyleBox["soapbind:body",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["soapbind:fault",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["soapbind:header",
    FontFamily->"Courier New",
    FontSize->10],
  ", or ",
  StyleBox["soapbind:headerfault",
    FontFamily->"Courier New",
    FontSize->10],
  " elements that do not specify the ",
  StyleBox["use",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute MUST be interpreted as though the value \
\[OpenCurlyDoubleQuote]",
  StyleBox["literal",
    FontFamily->"Courier New",
    FontSize->10],
  "\[CloseCurlyDoubleQuote] had been specified in each case. \nSupported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.6 Multiple Bindings for portType Elements",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2709 A ",
  StyleBox["wsdl:portType",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MAY have zero or more ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " elements that refer to it, defined in the same or other WSDL documents. \n\
Supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.7 Wire Signatures for Operations",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2710",
  " The operations in a ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MUST result in wire signatures that are different from \
one another. \nRequired.",
  ""
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.8 Multiple Ports on an Endpoint",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2711 A DESCRIPTION SHOULD NOT have more than one ",
  StyleBox["wsdl:port",
    FontFamily->"Courier New",
    FontSize->10],
  " with the same value for the ",
  StyleBox["location",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute of the ",
  StyleBox["soapbind:address",
    FontFamily->"Courier New",
    FontSize->10],
  " element. \nNot required, but recommended."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.9 Child Element for Document-Literal Bindings",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2712",
  " A document-literal binding MUST be represented on the wire as a MESSAGE \
with a ",
  StyleBox["soap:Body",
    FontFamily->"Courier New",
    FontSize->10],
  " whose child element is an instance of the global element declaration \
referenced by the corresponding ",
  StyleBox["wsdl:message",
    FontFamily->"Courier New",
    FontSize->10],
  " part. \nRequired.",
  ""
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.10 One-Way Operations",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R2714 For one-way operations, an INSTANCE MUST NOT return a HTTP response \
that contains a SOAP envelope. Specifically, the HTTP response entity-body \
must be empty. 
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R2750 A CONSUMER MUST ignore a SOAP response carried in a response from a \
one-way operation. 
One-way operations are not supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R2727 For one-way operations, a CONSUMER MUST NOT interpret a successful HTTP \
response status code (i.e., 2xx) to mean the message is valid or that the \
receiver would process it. 
One-way operations are not supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.11 Namespaces for soapbind Elements",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2716 A document-literal binding in a DESCRIPTION MUST NOT have the ",
  StyleBox["namespace ",
    FontFamily->"Courier New",
    FontSize->10],
  "attribute specified on contained ",
  StyleBox["soapbind:body",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["soapbind:header",
    FontFamily->"Courier New",
    FontSize->10],
  ", ",
  StyleBox["soapbind:headerfault",
    FontFamily->"Courier New",
    FontSize->10],
  ", and ",
  StyleBox["soapbind:fault",
    FontFamily->"Courier New",
    FontSize->10],
  " elements. \nNot required."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.12 Consistency of portType and binding Elements",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2718 A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MUST have the same set of ",
  StyleBox["wsdl:operation",
    FontFamily->"Courier New",
    FontSize->10],
  " elements as the ",
  StyleBox["wsdl:portType",
    FontFamily->"Courier New",
    FontSize->10],
  " to which it refers.\nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.13 Describing headerfault Elements",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2719",
  " A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MAY contain no ",
  StyleBox["soapbind:headerfault",
    FontFamily->"Courier New",
    FontSize->10],
  " elements if there are no known header faults. \nSupported.",
  ""
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.14 Enumeration of Faults",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2740 A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION SHOULD contain a ",
  StyleBox["soapbind:fault",
    FontFamily->"Courier New",
    FontSize->10],
  " describing each known fault. \nSupported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2741",
  " A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION SHOULD contain a ",
  StyleBox["soapbind:headerfault",
    FontFamily->"Courier New",
    FontSize->10],
  " describing each known header fault. \nSupported.",
  ""
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2742 A MESSAGE MAY contain a fault detail entry in a SOAP fault that is \
not described by a ",
  StyleBox["wsdl:fault",
    FontFamily->"Courier New",
    FontSize->10],
  " element in the corresponding WSDL description. \nSupported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2743 A MESSAGE MAY contain the details of a header-processing related \
fault in a SOAP header block that is not described by a ",
  StyleBox["wsdl:headerfault",
    FontFamily->"Courier New",
    FontSize->10],
  " element in the corresponding WSDL description. \nSupported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.15 Type and Name of SOAP Binding Elements",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2720 A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MUST use the attribute named ",
  StyleBox["part",
    FontFamily->"Courier New",
    FontSize->10],
  " with a schema type of \[OpenCurlyDoubleQuote]NMTOKEN\
\[CloseCurlyDoubleQuote] on all contained ",
  StyleBox["soapbind:header",
    FontFamily->"Courier New",
    FontSize->10],
  " and ",
  StyleBox["soapbind:headerfault",
    FontFamily->"Courier New",
    FontSize->10],
  " elements.\nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2749",
  " A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MUST NOT use the attribute named ",
  StyleBox["parts",
    FontFamily->"Courier New",
    FontSize->10],
  " on contained ",
  StyleBox["soapbind:header",
    FontFamily->"Courier New",
    FontSize->10],
  " and ",
  StyleBox["soapbind:headerfault",
    FontFamily->"Courier New",
    FontSize->10],
  " elements. \nRequired.",
  ""
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.16 name Attribute on Faults",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2721",
  " A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MUST have the ",
  StyleBox["name ",
    FontFamily->"Courier New",
    FontSize->10],
  "attribute specified on all contained ",
  StyleBox["soapbind:fault",
    FontFamily->"Courier New",
    FontSize->10],
  " elements. \nNot required.",
  ""
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2754 In a DESCRIPTION, the value of the ",
  StyleBox["name",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on a ",
  StyleBox["soapbind:fault",
    FontFamily->"Courier New",
    FontSize->10],
  " element MUST match the value of the ",
  StyleBox["name",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on its parent ",
  StyleBox["wsdl:fault",
    FontFamily->"Courier New",
    FontSize->10],
  " element. \nNot required."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.17 Omission of the use Attribute",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2722 A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION MAY specify the ",
  StyleBox["use",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on contained ",
  StyleBox["soapbind:fault",
    FontFamily->"Courier New",
    FontSize->10],
  " elements.\nNot supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2723 If in a ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION the ",
  StyleBox["use",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on a contained ",
  StyleBox["soapbind:fault",
    FontFamily->"Courier New",
    FontSize->10],
  " element is present, its value MUST be ",
  StyleBox["\[OpenCurlyDoubleQuote]literal\[CloseCurlyDoubleQuote]",
    FontFamily->"Courier"],
  ". \nNot supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2728 A ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in a DESCRIPTION that omits the ",
  StyleBox["use",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on a contained ",
  StyleBox["soapbind:fault",
    FontFamily->"Courier New",
    FontSize->10],
  " element MUST be interpreted as though ",
  StyleBox["use=\"literal\"",
    FontFamily->"Courier New",
    FontSize->10],
  " had been specified.\nNot supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.18 Consistency of Messages with Descriptions",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2724 If an INSTANCE receives a message that is inconsistent with its WSDL \
description, it SHOULD generate a ",
  StyleBox["soap:Fault",
    FontFamily->"Courier New",
    FontSize->10],
  " with a faultcode of ",
  StyleBox["\[OpenCurlyDoubleQuote]Client\[CloseCurlyDoubleQuote]",
    FontFamily->"Courier"],
  ", unless a ",
  StyleBox["\[OpenCurlyDoubleQuote]MustUnderstand\[CloseCurlyDoubleQuote]",
    FontFamily->"Courier"],
  " or ",
  StyleBox["\[OpenCurlyDoubleQuote]VersionMismatch\[CloseCurlyDoubleQuote]",
    FontFamily->"Courier"],
  " fault is generated. \nNot directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2725 If an INSTANCE receives a message that is inconsistent with its WSDL \
description, it MUST check for ",
  StyleBox["\[OpenCurlyDoubleQuote]VersionMismatch\[CloseCurlyDoubleQuote]",
    FontFamily->"Courier"],
  ", ",
  StyleBox["\[OpenCurlyDoubleQuote]MustUnderstand\[CloseCurlyDoubleQuote]",
    FontFamily->"Courier"],
  ", and ",
  StyleBox["\[OpenCurlyDoubleQuote]Client\[CloseCurlyDoubleQuote] ",
    FontFamily->"Courier"],
  "fault conditions in that order. \nNot directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.19 Response Wrappers",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2729 A MESSAGE described with an rpc-literal binding that is a response \
message MUST have a wrapper element whose name is the corresponding ",
  StyleBox["wsdl:operation",
    FontFamily->"Courier New",
    FontSize->10],
  " name suffixed with the string ",
  StyleBox["\[OpenCurlyDoubleQuote]Response\[CloseCurlyDoubleQuote]",
    FontFamily->"Courier"],
  ". \nNot required."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.20 Namespace for Part Accessors",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell["\<\
R2735 A MESSAGE described with an rpc-literal binding MUST place the part \
accessor elements for parameters and return value in no namespace. 
Supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.21 Namespaces for Children of Part Accessors",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2737 A MESSAGE described with an rpc-literal binding MUST namespace \
qualify the children of part accessor elements for the parameters and the \
return value with the ",
  StyleBox["targetNamespace",
    FontFamily->"Courier"],
  " in which their types are defined. \nSupported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.22 Required Headers",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2738 A MESSAGE MUST include all ",
  StyleBox["soapbind:header",
    FontFamily->"Courier New",
    FontSize->10],
  " elements specified on a ",
  StyleBox["wsdl:input",
    FontFamily->"Courier New",
    FontSize->10],
  " or ",
  StyleBox["wsdl:output",
    FontFamily->"Courier New",
    FontSize->10],
  " of a ",
  StyleBox["wsdl:operation",
    FontFamily->"Courier New",
    FontSize->10],
  " of a ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " that describes it. \nSupported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.23 Allowing Undescribed Headers",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2739 A MESSAGE MAY contain SOAP header blocks that are not described in \
the ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " that describes it. \nNot supported.  There is no way to add additional \
headers to a message unless you work directly with the message.  If the \
client receives a message with headers that are not described in the \
definition, they will not be processed."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2753 A MESSAGE containing SOAP header blocks that are not described in \
the appropriate ",
  StyleBox["wsdl:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " MAY have the ",
  StyleBox["mustUnderstand",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on such SOAP header blocks set to \[OpenCurlyDoubleQuote]1\
\[CloseCurlyDoubleQuote]. \nNot supported.  There is no way to add additional \
headers to a message unless you work directly with the message.  If the \
client receives a message with headers that are not described in the \
definition, they will not be processed."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.24 Ordering Headers",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2751 The order of ",
  StyleBox["soapbind:header",
    FontFamily->"Courier New",
    FontSize->10],
  " elements in ",
  StyleBox["soapbind:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " sections of a DESCRIPTION MUST be considered independent of the order of \
SOAP header blocks in the message. \nThe client does not support processing \
headers.  The headers will be placed in order when building a message on the \
client."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2752",
  " A MESSAGE MAY contain more than one instance of each SOAP header block \
for each ",
  StyleBox["soapbind:header",
    FontFamily->"Courier New",
    FontSize->10],
  " element in the appropriate child of ",
  StyleBox["soapbind:binding",
    FontFamily->"Courier New",
    FontSize->10],
  " in the corresponding description. \nThe client does not support \
processing headers.  ",
  ""
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.25 Describing SOAPAction",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2744 A HTTP request MESSAGE MUST contain a ",
  StyleBox["SOAPAction",
    FontFamily->"Courier New",
    FontSize->10],
  " HTTP header field with a quoted value equal to the value of the ",
  StyleBox["soapAction",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute of ",
  StyleBox["soapbind:operation",
    FontFamily->"Courier New",
    FontSize->10],
  ", if present in the corresponding WSDL description. \nSupported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2745 A HTTP request MESSAGE MUST contain a ",
  StyleBox["SOAPAction",
    FontFamily->"Courier New",
    FontSize->10],
  " HTTP header field with a quoted empty string value, if in the \
corresponding WSDL description, the ",
  StyleBox["soapAction",
    FontFamily->"Courier New",
    FontSize->10],
  " of ",
  StyleBox["soapbind:operation",
    FontFamily->"Courier New",
    FontSize->10],
  " is either not present or present with an empty string as its value. \nNot \
directly supported by the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " client, but may be supported by Axis."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.6.26 SOAP Binding Extensions",
  FontWeight->"Bold"]], "Text",
  FontSlant->"Italic",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2747 A CONSUMER MUST understand and process all WSDL 1.1 SOAP binding \
extension elements, irrespective of the presence or absence of the ",
  StyleBox["wsdl:required",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on an extension element and irrespective of the value of the ",
  StyleBox["wsdl:required",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute when present. \nExtensions are not supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R2748 A CONSUMER MUST NOT interpret the presence of the ",
  StyleBox["wsdl:required",
    FontFamily->"Courier New",
    FontSize->10],
  " attribute on a ",
  StyleBox["soapbind",
    FontFamily->"Courier New",
    FontSize->10],
  " extension element with a value of \[OpenCurlyDoubleQuote]",
  StyleBox["false",
    FontFamily->"Courier"],
  "\[CloseCurlyDoubleQuote] to mean the extension element is optional in the \
messages generated from the WSDL description. \nExtensions are not \
supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["5.7 Use of XML Schema",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R2800 A DESCRIPTION MAY use any construct from XML Schema 1.0. 
Not supported.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R2801 A DESCRIPTION MUST use XML Schema 1.0 recommendation as the basis of \
user-defined datatypes and structures. 
Required.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["6. Service Publication and Discovery",
  FontSize->18,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["6.1 bindingTemplates",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R3100 REGDATA of type ",
  StyleBox["uddi:bindingTemplate",
    FontFamily->"Courier New",
    FontSize->10],
  " representing a conformant INSTANCE MUST contain the ",
  StyleBox["uddi:accessPoint",
    FontFamily->"Courier New",
    FontSize->10],
  " element. \nRegistry functionality is not supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["6.2 tModels",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R3002 REGDATA of type ",
  StyleBox["uddi:tModel",
    FontFamily->"Courier New",
    FontSize->10],
  " representing a conformant web service type MUST use WSDL as the \
description language. \nRegistry functionality is not supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R3003 REGDATA of type ",
  StyleBox["uddi:tModel",
    FontFamily->"Courier New",
    FontSize->10],
  " representing a conformant web service type MUST be categorized using the \
uddi:types taxonomy and a categorization of \[OpenCurlyDoubleQuote]wsdlSpec\
\[CloseCurlyDoubleQuote]. \nRegistry functionality is not supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R3010 REGDATA of type ",
  StyleBox["uddi:tModel",
    FontFamily->"Courier New",
    FontSize->10],
  " representing a conformant web service type MUST follow ",
  StyleBox["V1.08 of the UDDI Best Practice for Using WSDL in a UDDI \
Registry",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True}],
  ". \nRegistry functionality is not supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R3011 The wsdl:binding that is referenced by REGDATA of type ",
  StyleBox["uddi:tModel",
    FontFamily->"Courier New",
    FontSize->10],
  " MUST itself conform to the profile. \nRegistry functionality is not \
supported."
}], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["7. Security",
  FontSize->18,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[StyleBox["7.1 Use of HTTPS",
  FontSize->14,
  FontWeight->"Bold"]], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R5000 An INSTANCE MAY require the use of HTTPS. 
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"],

Cell[TextData[{
  "R5001 If an INSTANCE requires the use of HTTPS, the location attribute of \
the ",
  StyleBox["soapbind:address",
    FontFamily->"Courier New",
    FontSize->10],
  " element in its ",
  StyleBox["wsdl:port",
    FontFamily->"Courier New",
    FontSize->10],
  " description MUST be a URI whose scheme is \[OpenCurlyDoubleQuote]https\
\[CloseCurlyDoubleQuote]; otherwise it MUST be a URI whose scheme is \
\[OpenCurlyDoubleQuote]http\[CloseCurlyDoubleQuote]. \nRequired."
}], "Text",
  CellTags->"b:1.3.11"],

Cell["\<\
R5010 An INSTANCE MAY require the use of HTTPS with mutual authentication. 
Not applicable.\
\>", "Text",
  CellTags->"b:1.3.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Examples", "Section"],

Cell[CellGroupData[{

Cell["Amazon", "Subsection",
  CellTags->"b:1.4.1"],

Cell[TextData[{
  StyleBox[ButtonBox["Amazon.com",
    ButtonData:>{
      URL[ "http://www.amazon.com"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  " is a well-known web retailer that specializes in books, music, movies, \
and many other products. Amazon has made a ",
  StyleBox[ButtonBox["web service",
    ButtonData:>{
      URL[ 
      "http://www.amazon.com/gp/browse.html/102-1833813-2986559?node=3435361"]\
, None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  " available that allows developers to interface with their database of \
products. A user can search for specific products, authors, artists, and so \
on. A query will return information (price, description, location, and so on) \
about the products that are found. This example demonstrates a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interface to the Amazon web service."
}], "Text",
  CellTags->"b:1.4.1"],

Cell[TextData[{
  "The Amazon web services are good demonstrations of using web services to \
retrieve data. This example searches the Amazon databases for books written \
by certain authors, published by a certain manufacturer, or containing a \
certain keyword. The example code then places the results in a new notebook. \
The example has one option. Setting the ",
  StyleBox["ShowPictures",
    FontFamily->"Courier"],
  " option to ",
  StyleBox["True",
    FontFamily->"Courier"],
  " will force the code to retrieve and display the cover image of the book."
}], "Text",
  CellTags->"b:1.4.1"],

Cell[TextData[{
  "To try this example, evaluate all the initialization cells (you can do \
this with the menu command ",
  StyleBox["Kernel\[RightTriangle]Evaluation\[RightTriangle]Evaluate \
Initialization",
    FontFamily->"Arial"],
  "). Then go to the examples here."
}], "Text",
  CellTags->"b:1.4.1"],

Cell[CellGroupData[{

Cell["Code", "SubsubsectionIcon",
  CellTags->"b:1.4.1"],

Cell[BoxData[{
    \(\(\(BeginPackage["\<WebServices`Examples`Amazon`\>", \
{"\<WebServices`\>", "\<JLink`\>"}];\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(AuthorSearch;\)\), "\n", 
    \(\(ManufacturerSearch;\)\), "\[IndentingNewLine]", 
    \(\(KeywordSearch;\)\), "\[IndentingNewLine]", 
    \(\(\(ShowPictures;\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(\(Begin["\<`Private`\>"];\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(InstallService["\<http://soap.amazon.com/schemas3/AmazonWebServices.\
wsdl\>"];\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(\(Options[
          AuthorSearch] = {ShowPictures \[Rule] 
            False};\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(\(AuthorSearch[keyword_String, pages_Integer, options___?OptionQ] := 
      Module[{result}, 
        result = 
          AuthorSearchRequest[{"\<author\>" \[Rule] 
                keyword, "\<page\>" \[Rule] 
                pages, "\<mode\>" \[Rule] "\<books\>", "\<tag\>" \[Rule] \
"\<webservices-20\>", "\<type\>" \[Rule] "\<lite\>", "\<devtag\>" \[Rule] \
"\<D3VZJS46JD5U9D\>", "\<version\>" \[Rule] "\<1.0\>"}]; \
\[IndentingNewLine]If[result === $Failed, 
          Return[$Failed]]; \[IndentingNewLine]result = "\<Details\>" /. 
            result; \[IndentingNewLine]NotebookPut[\[IndentingNewLine]\
resultNotebook["\<Amazon Author Search\>", keyword, result, 
            options]]\[IndentingNewLine]]\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(ManufacturerSearch[keyword_String, pages_Integer, 
          options___?OptionQ] := 
        Module[{result}, 
          result = 
            ManufacturerSearchRequest[{"\<manufacturer\>" \[Rule] 
                  keyword, "\<page\>" \[Rule] 
                  pages, "\<mode\>" \[Rule] "\<books\>", "\<tag\>" \[Rule] \
"\<webservices-20\>", "\<type\>" \[Rule] "\<lite\>", "\<devtag\>" \[Rule] \
"\<D3VZJS46JD5U9D\>", "\<version\>" \[Rule] "\<1.0\>"}]; \
\[IndentingNewLine]If[result === $Failed, 
            Return[$Failed]]; \[IndentingNewLine]result = "\<Details\>" /. 
              result; \[IndentingNewLine]NotebookPut[\[IndentingNewLine]\
resultNotebook["\<Amazon Manufacturer Search\>", keyword, result, 
              options]]\[IndentingNewLine]];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(KeywordSearch[keyword_String, pages_Integer, options___?OptionQ] := 
        Module[{result}, 
          result = 
            KeywordSearchRequest[{"\<keyword\>" \[Rule] 
                  keyword, "\<page\>" \[Rule] 
                  pages, "\<mode\>" \[Rule] "\<books\>", "\<tag\>" \[Rule] \
"\<webservices-20\>", "\<type\>" \[Rule] "\<lite\>", "\<devtag\>" \[Rule] \
"\<D3VZJS46JD5U9D\>", "\<version\>" \[Rule] "\<1.0\>"}]; \
\[IndentingNewLine]If[result === $Failed, 
            Return[$Failed]]; \[IndentingNewLine]result = "\<Details\>" /. 
              result; \[IndentingNewLine]NotebookPut[\[IndentingNewLine]\
resultNotebook["\<Amazon Keyword Search\>", keyword, result, 
              options]]\[IndentingNewLine]];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(resultNotebook[title_String, \ keyword_String, result_List, 
        options___?OptionQ] := \[IndentingNewLine]Notebook[
        Flatten[{\[IndentingNewLine]Cell[
              title, "\<Subtitle\>"], \[IndentingNewLine]Cell["\<Results for: \
\>" <> keyword, "\<Section\>"], \[IndentingNewLine]\(resultCells[#, 
                  options] &\)\  /@ \ result\[IndentingNewLine]}], 
        CellGrouping \[Rule] Manual, 
        WindowTitle \[Rule] \((title <> "\<: \>" <> 
              keyword)\)]\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(resultCells[d_List, options___?OptionQ] := 
      Module[{url, asin, productName, authorNames, releaseDate, manufacturer, 
          imageUrlMedium, listPrice, ourPrice, usedPrice, showPictures, 
          cellList}, {showPictures} = \({ShowPictures} /. 
              Flatten[{options}]\) /. 
            Options[AuthorSearch]; \[IndentingNewLine]url = "\<Url\>" /. 
            d; \[IndentingNewLine]asin = "\<Asin\>" /. 
            d; \[IndentingNewLine]productName = "\<ProductName\>" /. 
            d; \[IndentingNewLine]authorNames = "\<Authors\>" /. 
            d; \[IndentingNewLine]releaseDate = "\<ReleaseDate\>" /. 
            d; \[IndentingNewLine]manufacturer = "\<Manufacturer\>" /. 
            d; \[IndentingNewLine]imageUrlMedium = "\<ImageUrlMedium\>" /. 
            d; \[IndentingNewLine]listPrice = "\<ListPrice\>" /. 
            d; \[IndentingNewLine]ourPrice = "\<OurPrice\>" /. 
            d; \[IndentingNewLine]usedPrice = "\<UsedPrice\>" /. 
            d; \[IndentingNewLine]authorNames = 
          ToString[authorNames]; \[IndentingNewLine]authorNames = 
          StringDrop[authorNames, 1]; \[IndentingNewLine]authorNames = 
          StringDrop[authorNames, \(-1\)]; \[IndentingNewLine]If[
          TrueQ[showPictures], 
          imageUrlMedium = 
            getImageData[imageUrlMedium]; \[IndentingNewLine]If[
            StringMatchQ[imageUrlMedium, "\<GIF*\>"], 
            imageCell = 
              ToExpression[
                ExportString[
                  ImportString[imageUrlMedium, "\<GIF\>"], "\<MGFCell\>"]], 
            imageCell = 
              ToExpression[
                ExportString[
                  ImportString[
                    imageUrlMedium, "\<JPEG\>"], "\<MGFCell\>"]]];]; \
\[IndentingNewLine]{Cell[
            CellGroupData[
              Flatten[{\[IndentingNewLine]Cell[
                    TextData[{\[IndentingNewLine]ButtonBox[
                          StyleBox[productName, FontWeight -> "\<Bold\>"], 
                          ButtonData \[Rule] {URL[url], None}, 
                          ButtonStyle \[Rule] "\<Hyperlink\>"], "\< by \>", 
                        StyleBox[authorNames, 
                          FontSlant \[Rule] "\<Italic\>"]}], "\<Text\>", 
                    ShowGroupOpenCloseIcon \[Rule] True], 
                  If[TrueQ[showPictures], 
                    Cell[TextData[imageCell], "\<Text\>"], {}], 
                  Cell[TextData[{StyleBox["\<Release Date: \>", 
                          FontWeight \[Rule] "\<Bold\>"], 
                        releaseDate, "\<\n\>", \
\[IndentingNewLine]StyleBox["\<ASIN: \>", FontWeight \[Rule] "\<Bold\>"], 
                        asin, "\<\n\>", \[IndentingNewLine]StyleBox["\<List \
Price: \>", FontWeight \[Rule] "\<Bold\>"], 
                        listPrice, "\<\n\>", \
\[IndentingNewLine]StyleBox["\<Our Price: \>", 
                          FontWeight \[Rule] "\<Bold\>"], 
                        ourPrice}], "\<Text\>"]}], Closed]]}]\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(getImageData[url_String] := 
      JavaBlock[
        Module[{u, connection, stream, input = "\<\>", numRead = 0, 
            bytesRead = 0, buf}, 
          u = JavaNew["\<java.net.URL\>", 
              url]; \[IndentingNewLine]connection = 
            u@openConnection[]; \[IndentingNewLine]stream = 
            connection@getInputStream[]; \[IndentingNewLine]If[
            stream \[Equal] $Failed, 
            Return[URLError["\<Failed to open URL stream\>"]]]; \
\[IndentingNewLine]buf = 
            JavaNew["\<[B\>", 
              5000]; \[IndentingNewLine]While[\((numRead = 
                  stream@read[buf])\) > 0, 
            AddTo[bytesRead, numRead]; \[IndentingNewLine]input = 
              StringJoin[input, 
                ToString[
                  FromCharacterCode[\(If[# < 0, # + 256, #] &\) /@ 
                      Take[JavaObjectToExpression[buf], 
                        numRead]]]];]; \[IndentingNewLine]stream@
            close[]; \[IndentingNewLine]input]]\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(End[];\)\), "\n", 
    \(\(EndPackage[];\)\)}], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.1"]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", "SubsubsectionIcon",
  CellTags->"b:1.4.1"],

Cell[BoxData[
    \(AuthorSearch["\<Stephen Wolfram\>", 1]\)], "Input",
  CellTags->"b:1.4.1"],

Cell[BoxData[
    \(ManufacturerSearch["\<Addison-Wesley\>", 1]\)], "Input",
  CellTags->"b:1.4.1"],

Cell[BoxData[
    \(KeywordSearch["\<Mathematica\>", 1, 
      ShowPictures \[Rule] True]\)], "Input",
  CellTags->"b:1.4.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Google", "Subsection",
  CellTags->"b:1.4.2"],

Cell[TextData[{
  StyleBox[ButtonBox["Google.com",
    ButtonData:>{
      URL[ "http://www.google.com"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  " is a well-known web search engine. Google has made a ",
  StyleBox[ButtonBox["web service",
    ButtonData:>{
      URL[ "http://api.google.com"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  " available that allows developers to interface with their search engine \
within their own applications. A user can search for any topic on the web. A \
query will return data about the web pages that are found. This example \
demonstrates a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interface to the Google web service."
}], "Text",
  CellTags->"b:1.4.2"],

Cell["\<\
The Google web service is good demonstration of using web services to \
retrieve data. This example searches the Google databases for web pages \
containing a certain keyword. The example code then places the results in the \
notebook.\
\>", "Text",
  CellTags->"b:1.4.2"],

Cell[TextData[{
  "To try this example, evaluate all the initialization cells (you can do \
this with the menu command ",
  StyleBox["Kernel\[RightTriangle]Evaluation\[RightTriangle]Evaluate \
Initialization",
    FontFamily->"Arial"],
  "). Then go to the examples here."
}], "Text",
  CellTags->"b:1.4.2"],

Cell[CellGroupData[{

Cell["Code", "SubsubsectionIcon",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(<< WebServices`\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(\(InstallService["\<http://api.google.com/GoogleSearch.wsdl\>"];\)\)], \
"Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(\(Options[
          GoogleSearch] = {\[IndentingNewLine]MaxHits\  \[Rule] 
            10, \[IndentingNewLine]Filter \[Rule] 
            True, \[IndentingNewLine]IncludeURL\  \[Rule] \ 
            True\[IndentingNewLine]};\)\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(\($backgrounds = {RGBColor[0.960784, 0.878431, 0.666667], 
          RGBColor[0.964706, 0.929412, 0.839216]};\)\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(\(GoogleSearch::err = "\<Search Error.\>";\)\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(\(GoogleSearch::nomatch = "\<No page containing `1` found.\>";\)\)], \
"Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(GoogleSearch[str_String, 
        opts___] := \[IndentingNewLine]Module[{lis, results, matches, 
          filterQ, \ 
          urlQ}, \[IndentingNewLine]{matches, filterQ, 
            urlQ} = {MaxHits, Filter, IncludeURL}\  /. \ 
            Flatten[{opts, 
                Options\ @\ 
                  GoogleSearch}]; \
\[IndentingNewLine]\[IndentingNewLine]results = 
          GoogleSearchService`GoogleSearchPort`doGoogleSearch["\<\
3HB82PdQFHITKPmbmm5G/9aTfVHx/m95\>", str, \ 0, matches, filterQ, "\<\>", 
            True, "\<\>", "\<\>", "\<\>"]; \[IndentingNewLine]If[
          results === $Failed, \[IndentingNewLine]Message[
            GoogleSearch::err], \[IndentingNewLine]\(lis\  = \ \
"\<resultElements\>" /. results;\)\[IndentingNewLine]]; \[IndentingNewLine]If[
          lis === {} || lis === Null || 
            lis\  === \ "\<resultElements\>", \[IndentingNewLine]Message[
            GoogleSearch::nomatch, \ str], \[IndentingNewLine]$bg = 
            0; \[IndentingNewLine]Scan[CellPrint, 
            searchResultCells[lis, urlQ]]]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(searchResultCells[lis_, 
        urlQ_] := \(cellTemplate[formatSingleResult[#, urlQ]] &\)\  /@ \ 
        lis\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(cellTemplate[lis_] := \[IndentingNewLine]Cell[
        TextData\ @\ \(Flatten\ @\ {lis}\), "\<Print\>", \
\[IndentingNewLine]FontFamily -> "\<Times\>", \[IndentingNewLine]CellMargins \
\[Rule] {{Inherited, Inherited}, {0, 
              0}}, \[IndentingNewLine]CellDingbat \[Rule] 
          ToString[\(++$bg\)], \[IndentingNewLine]Background \[Rule] 
          Part[$backgrounds, Mod[$bg, 2, 1]]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(formatSingleResult[opts_, 
        urlQ_] := \[IndentingNewLine]Block[{u, 
          t}, \[IndentingNewLine]{u, t} = {"\<URL\>", "\<title\>"}\  /. \ 
            opts; \[IndentingNewLine]{\[IndentingNewLine]"\< \>", \
\[IndentingNewLine]webLink[
            StyleBox[formatTitle\ @\ t, FontWeight -> "\<Bold\>"], 
            u], \[IndentingNewLine]If[
            urlQ, {"\<\n\>", 
              webLink[StyleBox[u, "\<SmallText\>", 
                  FontColor \[Rule] GrayLevel[0.4]], 
                u]}, {}]\[IndentingNewLine]}\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(webLink[content_, url_] := \[IndentingNewLine]ButtonBox[
        content, \[IndentingNewLine]ButtonData \[RuleDelayed] {URL[url], 
            None}, \[IndentingNewLine]ButtonStyle -> "\<Hyperlink\>"\
\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(formatTitle[str_String] := translateAllEntities[str]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(decodeString[str_] := 
      StringReplace[
        str, {\[IndentingNewLine]"\<&lt;\>" -> "\<<\>", \
\[IndentingNewLine]"\<&gt;\>" -> "\<>\>", \[IndentingNewLine]"\<&amp;\>" -> "\
\<&\>", \[IndentingNewLine]"\<&quot;\>" -> "\<\"\>", \[IndentingNewLine]"\<\\\
\>" -> "\<\\[Backslash]\>"\[IndentingNewLine]}]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],

Cell[BoxData[
    \(translateAllEntities[str_] := 
      StringReplace[str, 
          Reverse\  /@ \ 
            System`Convert`MLStringDataDump`$UnicodeToHTML4Entities] // 
        decodeString\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "SubsubsectionIcon",
  CellTags->"b:1.4.2"],

Cell["\<\
Find the top 10 wolfram.com web pages containing all the given strings.\
\>", "Text",
  CellTags->"b:1.4.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GoogleSearch["\<Mathematica\>"]\)], "Input",
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["Wolfram Research, Inc.",
    ButtonData:>{
      URL[ "http://www.wolfram.com/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.wolfram.com/",
    ButtonData:>{
      URL[ "http://www.wolfram.com/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"1",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Mathematica</b>: The Way the World Calculates",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/mathematica/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.wolfram.com/products/mathematica/",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/mathematica/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"2",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Mathematica</b> Home Page",
    ButtonData:>{
      URL[ "http://www.mathematica-mpr.com/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.mathematica-mpr.com/",
    ButtonData:>{
      URL[ "http://www.mathematica-mpr.com/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"3",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["MathSource has moved",
    ButtonData:>{
      URL[ "http://www.mathsource.com/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.mathsource.com/",
    ButtonData:>{
      URL[ "http://www.mathsource.com/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"4",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["SpringerLink - Publication",
    ButtonData:>{
      URL[ "http://link.springer.de/link/service/journals/00229/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://link.springer.de/link/service/journals/00229/",
    ButtonData:>{
      URL[ "http://link.springer.de/link/service/journals/00229/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"5",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["SpringerLink - Publication",
    ButtonData:>{
      URL[ "http://link.springer.de/link/service/journals/10114/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://link.springer.de/link/service/journals/10114/",
    ButtonData:>{
      URL[ "http://link.springer.de/link/service/journals/10114/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"6",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["DOCUMENTA <b>MATHEMATICA</b>",
    ButtonData:>{
      URL[ "http://www.math.uiuc.edu/documenta/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.math.uiuc.edu/documenta/",
    ButtonData:>{
      URL[ "http://www.math.uiuc.edu/documenta/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"7",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["Calculus and <b>Mathematica</b> at UIUC",
    ButtonData:>{
      URL[ "http://www-cm.math.uiuc.edu/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www-cm.math.uiuc.edu/",
    ButtonData:>{
      URL[ "http://www-cm.math.uiuc.edu/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"8",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["The Integrator",
    ButtonData:>{
      URL[ "http://integrals.wolfram.com/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://integrals.wolfram.com/",
    ButtonData:>{
      URL[ "http://integrals.wolfram.com/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"9",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["ACTA <b>MATHEMATICA</b> UNIVERSITATIS COMENIANAE",
    ButtonData:>{
      URL[ "http://www.emis.de/journals/AMUC/_amuc.html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.emis.de/journals/AMUC/_amuc.html",
    ButtonData:>{
      URL[ "http://www.emis.de/journals/AMUC/_amuc.html"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"10",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.2"]
}, Closed]],

Cell["\<\
Search for pages containing all of the given strings, and return only the top \
two results.\
\>", "Text",
  CellTags->"b:1.4.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GoogleSearch["\<Hermite polynomial\>", MaxHits \[Rule] 2]\)], "Input",
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Hermite</b> <b>Polynomial</b> -- from MathWorld",
    ButtonData:>{
      URL[ "http://mathworld.wolfram.com/HermitePolynomial.html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://mathworld.wolfram.com/HermitePolynomial.html",
    ButtonData:>{
      URL[ "http://mathworld.wolfram.com/HermitePolynomial.html"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"1",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Hermite</b> <b>Polynomial</b>",
    ButtonData:>{
      URL[ "http://www.efunda.com/math/Hermite/index.cfm"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.efunda.com/math/Hermite/index.cfm",
    ButtonData:>{
      URL[ "http://www.efunda.com/math/Hermite/index.cfm"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"2",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.2"]
}, Closed]],

Cell["\<\
Display less verbose results and do not filter near-duplicate content and \
host crowding.\
\>", "Text",
  CellTags->"b:1.4.2"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GoogleSearch["\<Chebyshev\>", IncludeURL \[Rule] False, 
      Filter \[Rule] False]\)], "Input",
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b>",
    ButtonData:>{
      URL[ 
      "http://www-gap.dcs.st-and.ac.uk/~history/Mathematicians/Chebyshev.\
html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"1",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["One tailed version of <b>Chebyshev&#39;s</b> inequality \
- by Henry Bottomley",
    ButtonData:>{
      URL[ "http://www.btinternet.com/~se16/hgb/cheb.htm"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"2",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b>, Pafnuty Lvovich -- Encyclop\[AE]dia \
Britannica Online <b>...</b>",
    ButtonData:>{
      URL[ "http://www.britannica.com/eb/article?eu=23095"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"3",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b> Polynomial of the First Kind -- from \
MathWorld",
    ButtonData:>{
      URL[ 
      "http://mathworld.wolfram.com/ChebyshevPolynomialoftheFirstKind.html"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"4",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b> Polynomial of the Second Kind -- from \
MathWorld",
    ButtonData:>{
      URL[ 
      "http://mathworld.wolfram.com/ChebyshevPolynomialoftheSecondKind.html"],
       None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"5",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b> Polynomial",
    ButtonData:>{
      URL[ "http://www.efunda.com/math/Chebyshev/index.cfm"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"6",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b>",
    ButtonData:>{
      URL[ "http://www.mathsoc.spb.ru/pantheon/chebyshe/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"7",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["Butterworth / Bessel / <b>Chebyshev</b> Filters",
    ButtonData:>{
      URL[ "http://www-users.cs.york.ac.uk/~fisher/mkfilter/trad.html"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"8",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b>",
    ButtonData:>{
      URL[ 
      "http://www.nag.com/numeric/FL/manual/html/indexes/kwic/chebyshev.html"]\
, None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"9",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.2"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b>",
    ButtonData:>{
      URL[ 
      "http://www.nag.co.uk/numeric/FL/manual/html/indexes/kwic/chebyshev.\
html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"10",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.2"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Wolfram Search", "Subsection",
  CellTags->"b:1.4.3"],

Cell[TextData[{
  "Wolfram Research has a large amount of information on its ",
  StyleBox[ButtonBox["websites",
    ButtonData:>{
      URL[ "http://www.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  " that can be very useful to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " users. A ",
  StyleBox[ButtonBox["web service",
    ButtonData:>{
      URL[ "http://webservices.wolfram.com/wolframsearch/"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  " has been provided that allows users of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to search the Wolfram Research websites from within ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  This example demonstrates a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " interface to the Wolfram Search web service."
}], "Text",
  CellTags->"b:1.4.3"],

Cell[TextData[{
  "With this web service, a user can query the web documents directly from \
any application that supports web services. The service is similar to the \
functionality provided by ",
  StyleBox[ButtonBox["http://search.wolfram.com",
    ButtonData:>{
      URL[ "http://search.wolfram.com"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  "."
}], "Text",
  CellTags->"b:1.4.3"],

Cell[TextData[{
  "To try this example, evaluate all the initialization cells (you can do \
this with the menu command ",
  StyleBox["Kernel\[RightTriangle]Evaluation\[RightTriangle]Evaluate \
Initialization",
    FontFamily->"Arial"],
  "). Then go to the examples here."
}], "Text",
  CellTags->"b:1.4.3"],

Cell[CellGroupData[{

Cell["Code", "SubsubsectionIcon",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(Needs["\<WebServices`\>"]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(\(InstallService["\<http://webservices.wolfram.com/services/\
SearchServices/WolframSearch2.wsdl\>", 
        AllowShortContext \[Rule] False];\)\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(\(Options[
          WolframWebSearch] = {\[IndentingNewLine]MaxHits\  \[Rule] 
            10, \[IndentingNewLine]Method \[Rule] 
            And, \[IndentingNewLine]IncludeURL\  \[Rule] \ 
            True\[IndentingNewLine]};\)\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(\($backgrounds = {RGBColor[0.960784, 0.878431, 0.666667], 
          RGBColor[0.964706, 0.929412, 0.839216]};\)\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(\(WolframWebSearch::nomatch = "\<No page containing `1` \
found.\>";\)\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(WolframWebSearch[str_String, 
        opts___] := \[IndentingNewLine]Module[{lis, matches, multi, 
          urlQ}, \[IndentingNewLine]{matches, multi, 
            urlQ} = {MaxHits, Method, IncludeURL}\  /. \ 
            Flatten[{opts, 
                Options\ @\ WolframWebSearch}]; \[IndentingNewLine]lis\  = \ 
          WolframSearchService`WolframSearchPort`WolframSearch[{"\<Query\>" \
\[Rule] str, \ "\<Limit\>" \[Rule] 
                matches, "\<ReturnTypes\>" \[Rule] {"\<Title\>", \ "\<URL\>", \
"\<Score\>"}}]; \[IndentingNewLine]lis\  = \ "\<Matches\>" /. 
            lis; \[IndentingNewLine]If[
          lis === {} || lis === Null\  || \ 
            lis\  === "\<Matches\>", \[IndentingNewLine]Message[
            WolframWebSearch::nomatch, \ str], \[IndentingNewLine]$bg = 
            0; \[IndentingNewLine]Scan[CellPrint, 
            searchResultCells[lis, urlQ]]]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(searchResultCells[lis_, 
        urlQ_] := \(cellTemplate[formatSingleResult[#, urlQ]] &\)\  /@ \ 
        lis\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(cellTemplate[lis_] := \[IndentingNewLine]Cell[
        TextData\ @\ \(Flatten\ @\ {lis}\), "\<Print\>", \
\[IndentingNewLine]FontFamily -> "\<Times\>", \[IndentingNewLine]CellMargins \
\[Rule] {{Inherited, Inherited}, {0, 
              0}}, \[IndentingNewLine]CellDingbat \[Rule] 
          ToString[\(++$bg\)], \[IndentingNewLine]Background \[Rule] 
          Part[$backgrounds, Mod[$bg, 2, 1]]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(formatSingleResult[opts_, 
        urlQ_] := \[IndentingNewLine]Block[{u, t, 
          s}, \[IndentingNewLine]{u, t, 
            s} = {"\<URL\>", "\<Title\>", "\<Score\>"}\  /. \ 
            opts; \[IndentingNewLine]{\[IndentingNewLine]scoreIndicator[
            s], \[IndentingNewLine]"\< \>", \[IndentingNewLine]webLink[
            StyleBox[formatTitle\ @\ t, FontWeight -> "\<Bold\>"], 
            u], \[IndentingNewLine]If[
            urlQ, {"\<\n\>", 
              webLink[StyleBox[u, "\<SmallText\>", 
                  FontColor \[Rule] GrayLevel[0.4]], 
                u]}, {}]\[IndentingNewLine]}\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(scoreIndicator[
        r_] := \[IndentingNewLine]StyleBox[\[IndentingNewLine]StringJoin\ @\ 
          Table["\<|\>", {r}], \[IndentingNewLine]FontColor -> 
          RGBColor[0.269993, 0.308507, 
            0.6], \[IndentingNewLine]FontWeight -> "\<Bold\>"\
\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(webLink[content_, url_] := \[IndentingNewLine]ButtonBox[
        content, \[IndentingNewLine]ButtonData \[RuleDelayed] {URL[url], 
            None}, \[IndentingNewLine]ButtonStyle -> "\<Hyperlink\>"\
\[IndentingNewLine]]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(formatTitle[str_String] := translateAllEntities[str]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(decodeString[str_] := 
      StringReplace[
        str, {\[IndentingNewLine]"\<&lt;\>" -> "\<<\>", \
\[IndentingNewLine]"\<&gt;\>" -> "\<>\>", \[IndentingNewLine]"\<&amp;\>" -> "\
\<&\>", \[IndentingNewLine]"\<&quot;\>" -> "\<\"\>", \[IndentingNewLine]"\<\\\
\>" -> "\<\\[Backslash]\>"\[IndentingNewLine]}]\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],

Cell[BoxData[
    \(translateAllEntities[str_] := 
      StringReplace[str, 
          Reverse\  /@ \ 
            System`Convert`MLStringDataDump`$UnicodeToHTML4Entities] // 
        decodeString\)], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "SubsubsectionIcon",
  CellTags->"b:1.4.3"],

Cell["\<\
Find the top 10 wolfram.com web pages containing all the given strings.\
\>", "Text",
  CellTags->"b:1.4.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(WolframWebSearch["\<premier service\>"]\)], "Input",
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  " ",
  StyleBox[ButtonBox["Mathematica Service Program: FAQs about Premier \
Service",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/service/faqs.html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.wolfram.com/products/service/faqs.html",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/service/faqs.html"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"1",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  " ",
  StyleBox[ButtonBox["Mathematica Service Program: Premier Service",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/service/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.wolfram.com/products/service/",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/service/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"2",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  " ",
  StyleBox[ButtonBox["Mathematica Service Program: Premier Service Benefits",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/service/benefits.html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.wolfram.com/products/service/benefits.html",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/service/benefits.html"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"3",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  " ",
  StyleBox[ButtonBox["Premier Service",
    ButtonData:>{
      URL[ 
      "http://www.wolfram.com/services/customerservice/premservice.html"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.wolfram.com/services/customerservice/\
premservice.html",
    ButtonData:>{
      URL[ 
      "http://www.wolfram.com/services/customerservice/premservice.html"], 
      None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"4",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  " ",
  StyleBox[ButtonBox["Premier Service",
    ButtonData:>{
      URL[ 
      "http://documents.wolfram.com/v5/GettingStarted/FurtherInformation/\
PremierService.html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://documents.wolfram.com/v5/GettingStarted/\
FurtherInformation/PremierService.html",
    ButtonData:>{
      URL[ 
      "http://documents.wolfram.com/v5/GettingStarted/FurtherInformation/\
PremierService.html"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"5",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  " ",
  StyleBox[ButtonBox["Premier Service",
    ButtonData:>{
      URL[ "http://www.wolfram.com/services/premiersupport/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.wolfram.com/services/premiersupport/",
    ButtonData:>{
      URL[ "http://www.wolfram.com/services/premiersupport/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"6",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  StyleBox["||",
    FontWeight->"Bold",
    FontColor->GrayLevel[0.749996]],
  " ",
  StyleBox[ButtonBox["Mathematica Service Program: FAQs about Home-Use \
Licenses",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/service/faqshomeuse.html"], None},
    
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.wolfram.com/products/service/faqshomeuse.\
html",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/service/faqshomeuse.html"], None},
    
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"7",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  StyleBox["||",
    FontWeight->"Bold",
    FontColor->GrayLevel[0.749996]],
  " ",
  StyleBox[ButtonBox["Wolfram Research Customer Service Department",
    ButtonData:>{
      URL[ "http://www.wolfram.com/services/customerservice/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.wolfram.com/services/customerservice/",
    ButtonData:>{
      URL[ "http://www.wolfram.com/services/customerservice/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"8",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  StyleBox["||",
    FontWeight->"Bold",
    FontColor->GrayLevel[0.749996]],
  " ",
  StyleBox[ButtonBox["Mathematica Service",
    ButtonData:>{
      URL[ 
      "http://documents.wolfram.com/v4/GettingStarted/MathematicaServices.\
html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://documents.wolfram.com/v4/GettingStarted/\
MathematicaServices.html",
    ButtonData:>{
      URL[ 
      "http://documents.wolfram.com/v4/GettingStarted/MathematicaServices.\
html"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"9",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  StyleBox["||||",
    FontWeight->"Bold",
    FontColor->GrayLevel[0.749996]],
  " ",
  StyleBox[ButtonBox["Mathematica Home-Use Licenses",
    ButtonData:>{
      URL[ "http://www.wolfram.com/services/customerservice/homeuse.html"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.wolfram.com/services/customerservice/homeuse.\
html",
    ButtonData:>{
      URL[ "http://www.wolfram.com/services/customerservice/homeuse.html"], 
      None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"10",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.3"]
}, Closed]],

Cell[TextData[{
  "Search for pages containing ",
  StyleBox["any",
    FontSlant->"Italic"],
  " of the given strings, and return only the top two results."
}], "Text",
  CellTags->"b:1.4.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(WolframWebSearch["\<FuzzyLogic OR ControlSystems\>", 
      MaxHits \[Rule] 2]\)], "Input",
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  " ",
  StyleBox[ButtonBox["Introduction",
    ButtonData:>{
      URL[ 
      "http://documents.wolfram.com/applications/fuzzylogic/Introduction.\
html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://documents.wolfram.com/applications/fuzzylogic/\
Introduction.html",
    ButtonData:>{
      URL[ 
      "http://documents.wolfram.com/applications/fuzzylogic/Introduction.\
html"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"1",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  StyleBox["||",
    FontWeight->"Bold",
    FontColor->GrayLevel[0.749996]],
  " ",
  StyleBox[ButtonBox["Using the Application for the First Time",
    ButtonData:>{
      URL[ 
      "http://documents.wolfram.com/applications/control/GettingStarted/1.1.\
html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://documents.wolfram.com/applications/control/\
GettingStarted/1.1.html",
    ButtonData:>{
      URL[ 
      "http://documents.wolfram.com/applications/control/GettingStarted/1.1.\
html"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"2",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.3"]
}, Closed]],

Cell["Display less verbose results.", "Text",
  CellTags->"b:1.4.3"],

Cell[CellGroupData[{

Cell[BoxData[
    \(WolframWebSearch["\<velodrome\>", IncludeURL \[Rule] False]\)], "Input",\

  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  " ",
  StyleBox[ButtonBox["Vanishing Velodrome at the 1996 Olympics",
    ButtonData:>{
      URL[ 
      "http://www.wolfram.com/products/mathematica/usersanduses/experience/\
vanishing.html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"1",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  " ",
  StyleBox[ButtonBox["Key Features of Mathematica Used for the Velodrome",
    ButtonData:>{
      URL[ 
      "http://www.wolfram.com/products/mathematica/usersanduses/experience/\
velonotes.html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"2",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  " ",
  StyleBox[ButtonBox["Olympic Velodrome",
    ButtonData:>{
      URL[ "http://www.wolfram.com/news/velo2.html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"3",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|||||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  " ",
  StyleBox[ButtonBox["Mathematica Information Center: Olympic Velodrome \
Design",
    ButtonData:>{
      URL[ "http://library.wolfram.com/infocenter/Demos/122/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"4",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["||||",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  StyleBox["|",
    FontWeight->"Bold",
    FontColor->GrayLevel[0.749996]],
  " ",
  StyleBox[ButtonBox["Mathematica in Engineering: Overview",
    ButtonData:>{
      URL[ "http://www.wolfram.com/solutions/engineering/vanishing.html"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"5",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  StyleBox["||||",
    FontWeight->"Bold",
    FontColor->GrayLevel[0.749996]],
  " ",
  StyleBox[ButtonBox["Wolfram Research News Archive",
    ButtonData:>{
      URL[ "http://www.wolfram.com/news/archive/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"6",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  StyleBox["||||",
    FontWeight->"Bold",
    FontColor->GrayLevel[0.749996]],
  " ",
  StyleBox[ButtonBox["Mathematica User Experiences Archive",
    ButtonData:>{
      URL[ 
      "http://www.wolfram.com/products/mathematica/usersanduses/experience/"],
       None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"7",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  StyleBox["||||",
    FontWeight->"Bold",
    FontColor->GrayLevel[0.749996]],
  " ",
  StyleBox[ButtonBox["Mathematica in Engineering: Mathematica Applications in \
Engineering",
    ButtonData:>{
      URL[ "http://www.wolfram.com/solutions/engineering/users.html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"8",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216],
  CellTags->"b:1.4.3"],

Cell[TextData[{
  StyleBox["|",
    FontWeight->"Bold",
    FontColor->RGBColor[0.269993, 0.308507, 0.6]],
  StyleBox["||||",
    FontWeight->"Bold",
    FontColor->GrayLevel[0.749996]],
  " ",
  StyleBox[ButtonBox["Users and Uses of Mathematica for Students",
    ButtonData:>{
      URL[ 
      "http://www.wolfram.com/products/student/mathforstudents/users.html"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"9",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667],
  CellTags->"b:1.4.3"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["XMethods", "Subsection",
  CellTags->"b:1.4.4"],

Cell[TextData[{
  StyleBox[ButtonBox["XMethods.com",
    ButtonData:>{
      URL[ "http://www.xmethods.com"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  " is a website that lists publicly available web services. It is a great \
place for finding web services and advertising web services that you provide. \
This example queries the XMethods database and builds a notebook listing of \
each web service listed on XMethods. Each web service is listed with the \
title, description, and an ",
  StyleBox["InstallService",
    FontFamily->"Courier"],
  " function that can be used to install and use a service."
}], "Text",
  CellTags->"b:1.4.4"],

Cell[TextData[{
  "This example demonstrates using the XMethods Query Service to discover and \
use many of the web services available.  This example searches the XMethods \
database for the web services registered. Once the query is finished, a user \
can conveniently browse through the services and install the services that \
may be interesting. If ",
  StyleBox["GetServiceSummaries",
    FontFamily->"Courier"],
  " is called again, the code will match service IDs with cell tags.  If an \
ID exists as a cell tag, no new cells will be added.  If an ID does not \
exist, the appropriate cells are added for the service."
}], "Text",
  CellTags->"b:1.4.4"],

Cell[TextData[{
  "To try this example, evaluate all the initialization cells (you can do \
this with the menu command ",
  StyleBox["Kernel\[RightTriangle]Evaluation\[RightTriangle]Evaluate \
Initialization",
    FontFamily->"Arial"],
  "). Then go to the examples here."
}], "Text",
  CellTags->"b:1.4.4"],

Cell[CellGroupData[{

Cell["Code", "SubsubsectionIcon",
  CellTags->"b:1.4.4"],

Cell[BoxData[{
    \(\(\(BeginPackage["\<WebServices`Examples`XMethods`\>", {"\<WebServices`\
\>", "\<JLink`\>"}];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(GetServiceSummaries;\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(Begin["\<`Private`\>"];\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(\(InstallService["\<http://www.xmethods.net/wsdl/query.wsdl\>"];\)\(\
\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(\(GetServiceSummaries[] := 
      Module[{result}, 
        result = getAllServiceSummaries[]; \[IndentingNewLine]If[
          result === $Failed, Return[$Failed]]; \[IndentingNewLine]notebook = 
          EvaluationNotebook[]; \[IndentingNewLine]If[
          NotebookFind[notebook, "\<Results\>", All, {CellTags}] === $Failed, 
          SelectionMove[notebook, After, 
            EvaluationCell]; \[IndentingNewLine]NotebookWrite[notebook, 
            Cell["\<Results\>", "\<Section\>", 
              CellTags \[Rule] {"\<Results\>"}]];]; \
\[IndentingNewLine]printResult /@ result; \[IndentingNewLine]NotebookFind[
          notebook, "\<Results\>", 
          All, {CellTags}];]\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(\(printResult[result_List] := 
      Module[{name, id, shortDescription, wsdlURL, publisherID}, 
        name = "\<name\>" /. result; \[IndentingNewLine]id = "\<id\>" /. 
            result; \[IndentingNewLine]shortDescription = "\<shortDescription\
\>" /. result; \[IndentingNewLine]wsdlURL = "\<wsdlURL\>" /. 
            result; \[IndentingNewLine]publisherID = "\<publisherID\>" /. 
            result; \[IndentingNewLine]notebook = 
          EvaluationNotebook[]; \[IndentingNewLine]If[
          NotebookFind[notebook, id, All, {CellTags}, 
              AutoScroll \[Rule] False] === $Failed, 
          NotebookFind[notebook, "\<Results\>", All, {CellTags}, 
            AutoScroll \[Rule] False]; \[IndentingNewLine]SelectionMove[
            notebook, After, Cell, 
            AutoScroll \[Rule] False]; \[IndentingNewLine]NotebookWrite[
            notebook, 
            Cell[CellGroupData[{Cell[
                    BoxData[
                      RowBox[{name, 
                          StyleBox["\< from \>", 
                            FontWeight \[Rule] "\<Plain\>"], 
                          StyleBox[publisherID, 
                            FontWeight \[Rule] "\<Plain\>", 
                            FontSlant \[Rule] "\<Italic\>"], 
                          ButtonBox["\<(wsdl)\>", 
                            ButtonData \[Rule] {URL[wsdlURL], None}, 
                            ButtonStyle \[Rule] "\<Hyperlink\>"]}]], \
"\<Subsection\>", ShowGroupOpenCloseIcon \[Rule] True, 
                    CellDingbat \[Rule] None, CellTags \[Rule] {id}], 
                  Cell[shortDescription, "\<Text\>", 
                    ShowCellBracket \[Rule] False, 
                    CellMargins \[Rule] {{55, Inherited}, {Inherited, 
                          Inherited}}, CellFrame \[Rule] True, 
                    Background \[Rule] GrayLevel[0.850004]], 
                  Cell[BoxData[
                      RowBox[{"\<InstallService[\"\>" <> 
                            wsdlURL <> "\<\"]\>"}]], "\<Input\>", 
                    ShowCellBracket \[Rule] False, CellFrame \[Rule] True, 
                    CellMargins \[Rule] {{55, Inherited}, {Inherited, 
                          Inherited}}, 
                    Background \[Rule] GrayLevel[0.850004]]}, 
                Open]]];];]\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(End[];\)\), "\n", 
    \(\(EndPackage[];\)\)}], "Input",
  InitializationCell->True,
  CellTags->"b:1.4.4"]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "SubsubsectionIcon",
  CellTags->"b:1.4.4"],

Cell[BoxData[
    \(GetServiceSummaries[]\)], "Input",
  CellTags->"b:1.4.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TerraService", "Subsection",
  CellTags->"b:1.4.5"],

Cell[TextData[{
  StyleBox[ButtonBox["Terraservice.net",
    ButtonData:>{
      URL[ "http://terraservice.net/"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  " is a website that is provides access to aerial imagery and topographical \
maps of the United States. A ",
  StyleBox[ButtonBox["web service",
    ButtonData:>{
      URL[ "http://terraservice.net/webservices.aspx"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  " has been provided that allows developers to access this data. Developers \
can use this data to provide maps and aerial imagery in their applications. \
This allows users of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to use this data in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". This example demonstrates an interface to TerraService using ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " and ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".   "
}], "Text",
  CellTags->"b:1.4.5"],

Cell["\<\
Microsoft TerraServer Web Service is a programmable interface to the popular \
Microsoft TerraServer online database of high resolution United States \
Geological Survey (USGS) aerial imagery (DOQs) and scanned USGS topographical \
maps (DRGs).  The user can specify the place to display by using the Place \
Search field.  The place is expected to be a single string containing the \
city or well-known place name, state name, and country name separated by \
comma characters, such as \[OpenCurlyDoubleQuote]San Francisco, CA, USA\
\[CloseCurlyDoubleQuote]. Any of the three values may be missing. The \
navigation panel can be used to move in a particular direction. The Latitude \
and Longitude fields can be used to specify a place at a particular latitude \
and longitude.  The user can zoom in and zoom out using the Scale drop-down \
menu. The user can switch between aerial photographs and topological maps \
using the Theme drop-down menu.  \
\>", "Text",
  CellTags->"b:1.4.5"],

Cell[TextData[{
  "More information about TerraService may be found at ",
  StyleBox[ButtonBox["http://terraservice.net/",
    ButtonData:>{
      URL[ "http://terraservice.net/"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  ButtonBox[".",
    ButtonData:>{
      URL[ "http://terraservice.net/"], None},
    ButtonStyle->"Hyperlink"]
}], "Text",
  CellTags->"b:1.4.5"],

Cell[TextData[{
  "To try this example, you must have ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " installed.  Then go to the examples here and evaluate the cell."
}], "Text",
  CellTags->"b:1.4.5"],

Cell[BoxData[{
    \(\(Needs["\<GUIKit`\>"];\)\), "\[IndentingNewLine]", 
    \(GUIRun["\<TerraService\>"]\)}], "Input",
  CellLabel->"In[35]:=",
  CellTags->"b:1.4.5"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Web Services Navigator", "Subsection",
  CellTags->"b:1.4.6"],

Cell[TextData[{
  "Web Services Navigator is an example that demonstrates how you may \
interact dynamically with the functions installed by ",
  StyleBox["InstallService",
    FontFamily->"Courier"],
  ". This uses ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " to build a user interface for managing the web services installed in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ".  "
}], "Text",
  CellTags->"b:1.4.6"],

Cell[TextData[{
  "To try this example, you must have ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " installed. Then go to the examples here and evaluate the cell."
}], "Text",
  CellTags->"b:1.4.6"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Needs["\<GUIKit`\>"];\)\), "\[IndentingNewLine]", 
    \(GUIRun["\<WebServicesNavigator\>"]\)}], "Input",
  CellLabel->"In[11]:=",
  CellTags->"b:1.4.6"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject230277909577729, 
        JLink`Objects`JavaObject440933271207937]]], "Output",
  CellLabel->"Out[12]=",
  CellTags->"b:1.4.6"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
AutoGeneratedPackage->None,
ScreenStyleEnvironment->"Brackets",
WindowSize->{1236, 693},
WindowMargins->{{5, Automatic}, {Automatic, 15}},
ShowCellLabel->False,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "b:1.1"->{
    Cell[1838, 57, 52, 1, 65, "Section",
      CellTags->"b:1.1"],
    Cell[1893, 60, 825, 17, 59, "Text",
      CellTags->"b:1.1"],
    Cell[2721, 79, 89, 2, 25, "Text",
      CellTags->"b:1.1"],
    Cell[2813, 83, 423, 13, 25, "Text",
      CellTags->"b:1.1"],
    Cell[3239, 98, 457, 10, 42, "Text",
      CellTags->"b:1.1"],
    Cell[3699, 110, 71, 2, 25, "Text",
      CellTags->"b:1.1"],
    Cell[3773, 114, 486, 8, 42, "Text",
      CellTags->"b:1.1"],
    Cell[4262, 124, 63, 2, 25, "Text",
      CellTags->"b:1.1"],
    Cell[4328, 128, 719, 17, 42, "Text",
      CellTags->"b:1.1"],
    Cell[5050, 147, 63, 2, 25, "Text",
      CellTags->"b:1.1"],
    Cell[5116, 151, 860, 19, 59, "Text",
      CellTags->"b:1.1"],
    Cell[5979, 172, 69, 2, 25, "Text",
      CellTags->"b:1.1"],
    Cell[6051, 176, 725, 14, 59, "Text",
      CellTags->"b:1.1"],
    Cell[6779, 192, 72, 2, 25, "Text",
      CellTags->"b:1.1"],
    Cell[6854, 196, 836, 16, 59, "Text",
      CellTags->"b:1.1"],
    Cell[7693, 214, 70, 2, 25, "Text",
      CellTags->"b:1.1"],
    Cell[7766, 218, 717, 16, 42, "Text",
      CellTags->"b:1.1"],
    Cell[8486, 236, 353, 7, 42, "Text",
      CellTags->"b:1.1"]},
  "b:1.2.1"->{
    Cell[8935, 252, 87, 2, 39, "Subsection",
      CellTags->"b:1.2.1"],
    Cell[9025, 256, 359, 10, 25, "Text",
      CellTags->"b:1.2.1"]},
  "b:1.2.2"->{
    Cell[9421, 271, 60, 1, 39, "Subsection",
      CellTags->"b:1.2.2"],
    Cell[9484, 274, 597, 15, 42, "Text",
      CellTags->"b:1.2.2"],
    Cell[10084, 291, 105, 3, 29, "Input",
      CellTags->"b:1.2.2"],
    Cell[10214, 298, 164, 4, 29, "Input",
      CellTags->"b:1.2.2"],
    Cell[10381, 304, 90, 3, 27, "Output",
      CellTags->"b:1.2.2"],
    Cell[10486, 310, 541, 15, 42, "Text",
      CellTags->"b:1.2.2"],
    Cell[11052, 329, 92, 3, 29, "Input",
      CellTags->"b:1.2.2"],
    Cell[11147, 334, 387, 5, 64, "Print",
      CellTags->{"Info3277214259-7288901", "b:1.2.2"}],
    Cell[11549, 342, 1009, 22, 76, "Text",
      CellTags->"b:1.2.2"],
    Cell[12561, 366, 392, 11, 25, "Text",
      CellTags->"b:1.2.2"],
    Cell[12956, 379, 112, 2, 29, "Input",
      CellTags->"b:1.2.2"],
    Cell[13071, 383, 260, 5, 25, "Text",
      CellTags->"b:1.2.2"],
    Cell[13334, 390, 401, 12, 25, "Text",
      CellTags->"b:1.2.2"],
    Cell[13760, 406, 112, 3, 29, "Input",
      CellTags->"b:1.2.2"],
    Cell[13875, 411, 88, 3, 27, "Output",
      CellTags->"b:1.2.2"],
    Cell[13978, 417, 375, 9, 42, "Text",
      CellTags->"b:1.2.2"]},
  "Info3277214259-7288901"->{
    Cell[11147, 334, 387, 5, 64, "Print",
      CellTags->{"Info3277214259-7288901", "b:1.2.2"}]},
  "b:1.2.3"->{
    Cell[14390, 431, 59, 1, 39, "Subsection",
      CellTags->"b:1.2.3"],
    Cell[14452, 434, 849, 17, 59, "Text",
      CellTags->"b:1.2.3"],
    Cell[15304, 453, 193, 6, 25, "Text",
      CellTags->"b:1.2.3"],
    Cell[15500, 461, 105, 3, 29, "Input",
      CellTags->"b:1.2.3"],
    Cell[15630, 468, 158, 4, 29, "Input",
      CellTags->"b:1.2.3"],
    Cell[15791, 474, 775, 13, 103, "Output",
      CellTags->"b:1.2.3"],
    Cell[16581, 490, 330, 8, 25, "Text",
      CellTags->"b:1.2.3"],
    Cell[16936, 502, 104, 3, 29, "Input",
      CellTags->"b:1.2.3"],
    Cell[17043, 507, 390, 5, 64, "Print",
      CellTags->{"Info3290922430-6355998", "b:1.2.3"}],
    Cell[17448, 515, 823, 17, 59, "Text",
      CellTags->"b:1.2.3"],
    Cell[18274, 534, 509, 8, 49, "Input",
      CellTags->"b:1.2.3"],
    Cell[18786, 544, 597, 14, 42, "Text",
      CellTags->"b:1.2.3"],
    Cell[19386, 560, 114, 3, 25, "Text",
      CellTags->"b:1.2.3"],
    Cell[19525, 567, 325, 6, 29, "Input",
      CellTags->"b:1.2.3"],
    Cell[19853, 575, 10190, 174, 977, "Output",
      CellTags->"b:1.2.3"],
    Cell[30058, 752, 438, 8, 42, "Text",
      CellTags->"b:1.2.3"]},
  "Info3290922430-6355998"->{
    Cell[17043, 507, 390, 5, 64, "Print",
      CellTags->{"Info3290922430-6355998", "b:1.2.3"}]},
  "Type Mapping"->{
    Cell[30604, 770, 62, 1, 39, "Subsection",
      CellTags->"Type Mapping"]},
  "b:1.3.1.1"->{
    Cell[30691, 775, 62, 1, 35, "Subsubsection",
      CellTags->"b:1.3.1.1"],
    Cell[30756, 778, 782, 15, 59, "Text",
      CellTags->"b:1.3.1.1"],
    Cell[31541, 795, 1185, 39, 59, "Text",
      CellTags->"b:1.3.1.1"]},
  "b:1.3.1.2"->{
    Cell[32763, 839, 67, 1, 35, "Subsubsection",
      CellTags->"b:1.3.1.2"],
    Cell[32833, 842, 800, 15, 59, "Text",
      CellTags->"b:1.3.1.2"]},
  "b:1.3.1.3"->{
    Cell[33670, 862, 59, 1, 35, "Subsubsection",
      CellTags->"b:1.3.1.3"],
    Cell[33732, 865, 996, 31, 59, "Text",
      CellTags->"b:1.3.1.3"],
    Cell[34731, 898, 945, 16, 76, "Text",
      CellTags->"b:1.3.1.3"],
    Cell[35679, 916, 339, 6, 42, "Text",
      CellTags->"b:1.3.1.3"],
    Cell[36021, 924, 660, 14, 59, "Text",
      CellTags->"b:1.3.1.3"],
    Cell[36684, 940, 354, 7, 42, "Text",
      CellTags->"b:1.3.1.3"],
    Cell[37041, 949, 534, 15, 59, "InlineFormula",
      CellTags->"b:1.3.1.3"],
    Cell[37578, 966, 385, 8, 42, "Text",
      CellTags->"b:1.3.1.3"],
    Cell[37966, 976, 893, 26, 76, "InlineFormula",
      CellTags->"b:1.3.1.3"],
    Cell[38862, 1004, 107, 3, 29, "Input",
      CellTags->"b:1.3.1.3"],
    Cell[38994, 1011, 190, 5, 29, "Input",
      CellTags->"b:1.3.1.3"],
    Cell[39187, 1018, 777, 13, 103, "Output",
      CellTags->"b:1.3.1.3"],
    Cell[40001, 1036, 1594, 24, 229, "Input",
      CellTags->"b:1.3.1.3"],
    Cell[41598, 1062, 27570, 511, 2706, "Output",
      CellTags->"b:1.3.1.3"]},
  "b:1.3.1.4"->{
    Cell[69217, 1579, 69, 1, 35, "Subsubsection",
      CellTags->"b:1.3.1.4"],
    Cell[69289, 1582, 763, 15, 59, "Text",
      CellTags->"b:1.3.1.4"],
    Cell[70055, 1599, 108, 3, 29, "Input",
      CellTags->"b:1.3.1.4"],
    Cell[70188, 1606, 153, 4, 29, "Input",
      CellTags->"b:1.3.1.4"],
    Cell[70344, 1612, 419, 7, 46, "Output",
      CellTags->"b:1.3.1.4"],
    Cell[70800, 1624, 220, 5, 29, "Input",
      CellTags->"b:1.3.1.4"],
    Cell[71023, 1631, 138, 2, 29, "Output",
      CellTags->"b:1.3.1.4"],
    Cell[71176, 1636, 442, 11, 42, "Text",
      CellTags->"b:1.3.1.4"],
    Cell[71621, 1649, 5056, 120, 991, "Text",
      CellTags->"b:1.3.1.4"]},
  "b:1.3.1.5"->{
    Cell[76714, 1774, 68, 1, 35, "Subsubsection",
      CellTags->"b:1.3.1.5"],
    Cell[76785, 1777, 616, 10, 59, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[77404, 1789, 408, 7, 42, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[77815, 1798, 859, 23, 92, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[78677, 1823, 629, 15, 250, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[79309, 1840, 2157, 40, 567, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[81469, 1882, 1520, 31, 359, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[82992, 1915, 1599, 29, 351, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[84594, 1946, 663, 14, 200, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[85260, 1962, 1041, 24, 242, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[86304, 1988, 981, 23, 242, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[87288, 2013, 665, 16, 175, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[87956, 2031, 619, 15, 150, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[88578, 2048, 877, 20, 250, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[89458, 2070, 562, 15, 100, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[90023, 2087, 853, 20, 250, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[90879, 2109, 839, 20, 275, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[91721, 2131, 781, 20, 225, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[92505, 2153, 821, 20, 250, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[93329, 2175, 909, 26, 142, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[94241, 2203, 1508, 29, 725, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[95752, 2234, 1254, 24, 500, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[97009, 2260, 939, 22, 350, "Text",
      CellTags->"b:1.3.1.5"],
    Cell[97951, 2284, 919, 21, 250, "Text",
      CellTags->"b:1.3.1.5"]},
  "b:1.3.1.6"->{
    Cell[98907, 2310, 56, 1, 35, "Subsubsection",
      CellTags->"b:1.3.1.6"],
    Cell[98966, 2313, 752, 17, 59, "Text",
      CellTags->"b:1.3.1.6"],
    Cell[99721, 2332, 107, 3, 29, "Input",
      CellTags->"b:1.3.1.6"],
    Cell[99853, 2339, 180, 4, 29, "Input",
      CellTags->"b:1.3.1.6"],
    Cell[100036, 2345, 200, 4, 27, "Output",
      CellTags->"b:1.3.1.6"],
    Cell[100251, 2352, 421, 14, 25, "Text",
      CellTags->"b:1.3.1.6"],
    Cell[100697, 2370, 237, 6, 29, "Input",
      CellTags->"b:1.3.1.6"],
    Cell[100937, 2378, 670, 13, 65, "Output",
      CellTags->"b:1.3.1.6"],
    Cell[101622, 2394, 143, 4, 25, "Text",
      CellTags->"b:1.3.1.6"],
    Cell[101790, 2402, 98, 3, 29, "Input",
      CellTags->"b:1.3.1.6"],
    Cell[101891, 2407, 474, 9, 65, "Output",
      CellTags->"b:1.3.1.6"],
    Cell[102380, 2419, 585, 11, 42, "Text",
      CellTags->"b:1.3.1.6"],
    Cell[102968, 2432, 292, 9, 150, "Text",
      CellTags->"b:1.3.1.6"],
    Cell[103263, 2443, 583, 10, 59, "Text",
      CellTags->"b:1.3.1.6"],
    Cell[103849, 2455, 410, 11, 200, "Text",
      CellTags->"b:1.3.1.6"]},
  "b:1.3.1.7"->{
    Cell[104296, 2471, 61, 1, 35, "Subsubsection",
      CellTags->"b:1.3.1.7"],
    Cell[104360, 2474, 1067, 20, 76, "Text",
      CellTags->"b:1.3.1.7"],
    Cell[105430, 2496, 97, 3, 29, "Input",
      CellTags->"b:1.3.1.7"],
    Cell[105552, 2503, 174, 4, 29, "Input",
      CellTags->"b:1.3.1.7"],
    Cell[105729, 2509, 223, 5, 27, "Output",
      CellTags->"b:1.3.1.7"],
    Cell[105989, 2519, 106, 3, 29, "Input",
      CellTags->"b:1.3.1.7"],
    Cell[106098, 2524, 502, 7, 64, "Print",
      CellTags->{"Info3278164772-8849540", "b:1.3.1.7"}],
    Cell[106637, 2536, 109, 3, 29, "Input",
      CellTags->"b:1.3.1.7"],
    Cell[106749, 2541, 94, 3, 27, "Output",
      CellTags->"b:1.3.1.7"]},
  "Info3278164772-8849540"->{
    Cell[106098, 2524, 502, 7, 64, "Print",
      CellTags->{"Info3278164772-8849540", "b:1.3.1.7"}]},
  "b:1.3.1.8"->{
    Cell[106892, 2550, 56, 1, 35, "Subsubsection",
      CellTags->"b:1.3.1.8"],
    Cell[106951, 2553, 565, 11, 59, "Text",
      CellTags->"b:1.3.1.8"],
    Cell[107519, 2566, 98, 3, 29, "Input",
      CellTags->"b:1.3.1.8"],
    Cell[107642, 2573, 174, 4, 29, "Input",
      CellTags->"b:1.3.1.8"],
    Cell[107819, 2579, 223, 5, 27, "Output",
      CellTags->"b:1.3.1.8"],
    Cell[108079, 2589, 103, 3, 29, "Input",
      CellTags->"b:1.3.1.8"],
    Cell[108185, 2594, 461, 6, 64, "Print",
      CellTags->{"Info3278251906-4694478", "b:1.3.1.8"}],
    Cell[108683, 2605, 174, 5, 29, "Input",
      CellTags->"b:1.3.1.8"],
    Cell[108860, 2612, 1822, 32, 179, "Output",
      CellTags->"b:1.3.1.8"],
    Cell[110719, 2649, 128, 3, 29, "Input",
      CellTags->"b:1.3.1.8"],
    Cell[110850, 2654, 95, 3, 27, "Output",
      CellTags->"b:1.3.1.8"]},
  "Info3278251906-4694478"->{
    Cell[108185, 2594, 461, 6, 64, "Print",
      CellTags->{"Info3278251906-4694478", "b:1.3.1.8"}]},
  "b:1.3.2"->{
    Cell[111006, 2664, 60, 1, 39, "Subsection",
      CellTags->"b:1.3.2"],
    Cell[111069, 2667, 459, 10, 42, "Text",
      CellTags->"b:1.3.2"],
    Cell[111531, 2679, 106, 3, 29, "Input",
      CellTags->"b:1.3.2"],
    Cell[111662, 2686, 179, 4, 29, "Input",
      CellTags->"b:1.3.2"],
    Cell[111844, 2692, 92, 3, 27, "Output",
      CellTags->"b:1.3.2"],
    Cell[111973, 2700, 98, 3, 29, "Input",
      CellTags->"b:1.3.2"],
    Cell[112074, 2705, 99, 3, 27, "Output",
      CellTags->"b:1.3.2"],
    Cell[112210, 2713, 107, 3, 29, "Input",
      CellTags->"b:1.3.2"],
    Cell[112320, 2718, 88, 3, 27, "Output",
      CellTags->"b:1.3.2"],
    Cell[112423, 2724, 774, 20, 59, "Text",
      CellTags->"b:1.3.2"],
    Cell[113222, 2748, 199, 5, 29, "Input",
      CellTags->"b:1.3.2"],
    Cell[113424, 2755, 135, 3, 27, "Output",
      CellTags->"b:1.3.2"],
    Cell[113596, 2763, 159, 4, 29, "Input",
      CellTags->"b:1.3.2"],
    Cell[113758, 2769, 88, 3, 27, "Output",
      CellTags->"b:1.3.2"]},
  "b:1.3.3"->{
    Cell[113895, 2778, 66, 1, 39, "Subsection",
      CellTags->"b:1.3.3"],
    Cell[113964, 2781, 656, 14, 59, "Text",
      CellTags->"b:1.3.3"],
    Cell[114623, 2797, 106, 3, 29, "Input",
      CellTags->"b:1.3.3"],
    Cell[114754, 2804, 158, 4, 29, "Input",
      CellTags->"b:1.3.3"],
    Cell[114915, 2810, 94, 3, 27, "Output",
      CellTags->"b:1.3.3"],
    Cell[115046, 2818, 136, 3, 29, "Input",
      CellTags->"b:1.3.3"],
    Cell[115185, 2823, 983, 19, 103, "Output",
      CellTags->"b:1.3.3"],
    Cell[116183, 2845, 820, 16, 59, "Text",
      CellTags->"b:1.3.3"],
    Cell[117028, 2865, 180, 4, 29, "Input",
      CellTags->"b:1.3.3"],
    Cell[117211, 2871, 2202, 35, 274, "Output",
      CellTags->"b:1.3.3"],
    Cell[119450, 2911, 128, 3, 29, "Input",
      CellTags->"b:1.3.3"],
    Cell[119581, 2916, 2202, 35, 274, "Output",
      CellTags->"b:1.3.3"],
    Cell[121798, 2954, 817, 18, 59, "Text",
      CellTags->"b:1.3.3"],
    Cell[122640, 2976, 143, 4, 29, "Input",
      CellTags->"b:1.3.3"],
    Cell[122786, 2982, 2202, 35, 274, "Output",
      CellTags->"b:1.3.3"],
    Cell[125003, 3020, 692, 16, 59, "Text",
      CellTags->"b:1.3.3"],
    Cell[125720, 3040, 110, 3, 29, "Input",
      CellTags->"b:1.3.3"],
    Cell[125833, 3045, 1171, 17, 141, "Output",
      CellTags->"b:1.3.3"]},
  "b:1.3.4"->{
    Cell[127053, 3068, 67, 1, 39, "Subsection",
      CellTags->"b:1.3.4"],
    Cell[127123, 3071, 643, 14, 42, "Text",
      CellTags->"b:1.3.4"],
    Cell[127769, 3087, 1084, 19, 76, "Text",
      CellTags->"b:1.3.4"],
    Cell[128856, 3108, 4840, 130, 345, "Text",
      CellTags->"b:1.3.4"],
    Cell[133699, 3240, 106, 3, 29, "Input",
      CellTags->"b:1.3.4"],
    Cell[133830, 3247, 239, 6, 49, "Input",
      CellTags->"b:1.3.4"],
    Cell[134072, 3255, 797, 16, 84, "Output",
      CellTags->"b:1.3.4"],
    Cell[134884, 3274, 347, 8, 42, "Text",
      CellTags->"b:1.3.4"],
    Cell[135256, 3286, 174, 4, 29, "Input",
      CellTags->"b:1.3.4"],
    Cell[135433, 3292, 1117, 20, 122, "Output",
      CellTags->"b:1.3.4"],
    Cell[136565, 3315, 603, 14, 42, "Text",
      CellTags->"b:1.3.4"],
    Cell[137171, 3331, 639, 16, 97, "Text",
      CellTags->"b:1.3.4"],
    Cell[137835, 3351, 367, 8, 69, "Input",
      CellTags->"b:1.3.4"],
    Cell[138205, 3361, 984, 19, 103, "Output",
      CellTags->"b:1.3.4"],
    Cell[139226, 3385, 174, 4, 29, "Input",
      CellTags->"b:1.3.4"],
    Cell[139403, 3391, 1117, 20, 122, "Output",
      CellTags->"b:1.3.4"],
    Cell[140535, 3414, 726, 15, 59, "Text",
      CellTags->"b:1.3.4"],
    Cell[141286, 3433, 377, 8, 49, "Input",
      CellTags->"b:1.3.4"],
    Cell[141666, 3443, 858, 17, 84, "Output",
      CellTags->"b:1.3.4"],
    Cell[142561, 3465, 196, 5, 29, "Input",
      CellTags->"b:1.3.4"],
    Cell[142760, 3472, 1117, 20, 122, "Output",
      CellTags->"b:1.3.4"],
    Cell[143892, 3495, 690, 16, 59, "Text",
      CellTags->"b:1.3.4"],
    Cell[144607, 3515, 110, 3, 29, "Input",
      CellTags->"b:1.3.4"],
    Cell[144720, 3520, 86, 3, 27, "Output",
      CellTags->"b:1.3.4"],
    Cell[144821, 3526, 1754, 44, 110, "Text",
      CellTags->"b:1.3.4"],
    Cell[146600, 3574, 464, 10, 69, "Input",
      CellTags->"b:1.3.4"],
    Cell[147067, 3586, 100, 3, 27, "Output",
      CellTags->"b:1.3.4"],
    Cell[147204, 3594, 112, 3, 29, "Input",
      CellTags->"b:1.3.4"],
    Cell[147319, 3599, 86, 3, 27, "Output",
      CellTags->"b:1.3.4"]},
  "b:1.3.5"->{
    Cell[147454, 3608, 71, 1, 39, "Subsection",
      CellTags->"b:1.3.5"],
    Cell[147528, 3611, 949, 25, 59, "Text",
      CellTags->"b:1.3.5"],
    Cell[148480, 3638, 105, 3, 29, "Input",
      CellTags->"b:1.3.5"],
    Cell[148610, 3645, 150, 4, 29, "Input",
      CellTags->"b:1.3.5"],
    Cell[148763, 3651, 416, 7, 46, "Output",
      CellTags->"b:1.3.5"],
    Cell[149216, 3663, 98, 3, 29, "Input",
      CellTags->"b:1.3.5"],
    Cell[149317, 3668, 416, 7, 46, "Output",
      CellTags->"b:1.3.5"],
    Cell[149748, 3678, 463, 14, 42, "Text",
      CellTags->"b:1.3.5"],
    Cell[150214, 3694, 136, 3, 29, "Input",
      CellTags->"b:1.3.5"],
    Cell[150375, 3701, 98, 3, 29, "Input",
      CellTags->"b:1.3.5"],
    Cell[150476, 3706, 385, 7, 46, "Output",
      CellTags->"b:1.3.5"],
    Cell[150898, 3718, 127, 3, 29, "Input",
      CellTags->"b:1.3.5"],
    Cell[151028, 3723, 107, 3, 27, "Output",
      CellTags->"b:1.3.5"],
    Cell[151172, 3731, 118, 3, 29, "Input",
      CellTags->"b:1.3.5"],
    Cell[151293, 3736, 90, 3, 27, "Output",
      CellTags->"b:1.3.5"],
    Cell[151398, 3742, 341, 12, 25, "Text",
      CellTags->"b:1.3.5"],
    Cell[151742, 3756, 135, 3, 29, "Input",
      CellTags->"b:1.3.5"],
    Cell[151902, 3763, 98, 3, 29, "Input",
      CellTags->"b:1.3.5"],
    Cell[152003, 3768, 83, 3, 27, "Output",
      CellTags->"b:1.3.5"],
    Cell[152123, 3776, 121, 3, 29, "Input",
      CellTags->"b:1.3.5"],
    Cell[152247, 3781, 108, 3, 27, "Output",
      CellTags->"b:1.3.5"]},
  "b:1.3.6"->{
    Cell[152404, 3790, 65, 1, 39, "Subsection",
      CellTags->"b:1.3.6"],
    Cell[152472, 3793, 664, 10, 59, "Text",
      CellTags->"b:1.3.6"],
    Cell[153139, 3805, 470, 8, 42, "Text",
      CellTags->"b:1.3.6"]},
  "b:1.3.7"->{
    Cell[153646, 3818, 66, 1, 39, "Subsection",
      CellTags->"b:1.3.7"],
    Cell[153715, 3821, 453, 8, 42, "Text",
      CellTags->"b:1.3.7"]},
  "b:1.3.8"->{
    Cell[154205, 3834, 59, 1, 39, "Subsection",
      CellTags->"b:1.3.8"],
    Cell[154267, 3837, 506, 13, 42, "Text",
      CellTags->"b:1.3.8"]},
  "b:1.3.9"->{
    Cell[154810, 3855, 67, 1, 39, "Subsection",
      CellTags->"b:1.3.9"],
    Cell[154880, 3858, 953, 25, 59, "Text",
      CellTags->"b:1.3.9"],
    Cell[155836, 3885, 364, 8, 42, "Text",
      CellTags->"b:1.3.9"],
    Cell[156203, 3895, 139, 3, 26, "Text",
      CellTags->"b:1.3.9"],
    Cell[156345, 3900, 84, 1, 25, "Text",
      CellTags->"b:1.3.9"],
    Cell[156432, 3903, 131, 3, 26, "Text",
      CellTags->"b:1.3.9"],
    Cell[156566, 3908, 526, 12, 42, "Text",
      CellTags->"b:1.3.9"],
    Cell[157095, 3922, 362, 7, 42, "Text",
      CellTags->"b:1.3.9"],
    Cell[157460, 3931, 221, 7, 25, "Text",
      CellTags->"b:1.3.9"],
    Cell[157684, 3940, 287, 10, 25, "Text",
      CellTags->"b:1.3.9"],
    Cell[157974, 3952, 212, 7, 25, "Text",
      CellTags->"b:1.3.9"],
    Cell[158189, 3961, 280, 10, 25, "Text",
      CellTags->"b:1.3.9"],
    Cell[158472, 3973, 164, 5, 25, "Text",
      CellTags->"b:1.3.9"],
    Cell[158639, 3980, 309, 6, 42, "Text",
      CellTags->"b:1.3.9"],
    Cell[158951, 3988, 160, 4, 25, "Text",
      CellTags->"b:1.3.9"],
    Cell[159136, 3996, 117, 3, 29, "Input",
      CellTags->"b:1.3.9"],
    Cell[159256, 4001, 93, 3, 27, "Output",
      CellTags->"b:1.3.9"],
    Cell[159386, 4009, 120, 3, 29, "Input",
      CellTags->"b:1.3.9"],
    Cell[159509, 4014, 121, 3, 27, "Output",
      CellTags->"b:1.3.9"],
    Cell[159667, 4022, 116, 3, 29, "Input",
      CellTags->"b:1.3.9"],
    Cell[159786, 4027, 18754, 268, 2174, "Output",
      CellTags->"b:1.3.9"],
    Cell[178577, 4300, 119, 3, 29, "Input",
      CellTags->"b:1.3.9"],
    Cell[178699, 4305, 120, 3, 27, "Output",
      CellTags->"b:1.3.9"],
    Cell[178834, 4311, 226, 5, 25, "Text",
      CellTags->"b:1.3.9"]},
  "b:1.3.10"->{
    Cell[179097, 4321, 55, 1, 39, "Subsection",
      CellTags->"b:1.3.10"],
    Cell[179155, 4324, 263, 5, 25, "Text",
      CellTags->"b:1.3.10"],
    Cell[179421, 4331, 9056, 235, 171, "Text",
      CellTags->"b:1.3.10"]},
  "b:1.3.11"->{
    Cell[188514, 4571, 66, 1, 39, "Subsection",
      CellTags->"b:1.3.11"],
    Cell[188583, 4574, 605, 13, 42, "Text",
      CellTags->"b:1.3.11"],
    Cell[189191, 4589, 120, 3, 30, "Text",
      CellTags->"b:1.3.11"],
    Cell[189314, 4594, 90, 2, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[189407, 4598, 792, 21, 75, "Text",
      CellTags->"b:1.3.11"],
    Cell[190202, 4621, 115, 2, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[190320, 4625, 663, 25, 75, "Text",
      CellTags->"b:1.3.11"],
    Cell[190986, 4652, 375, 10, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[191364, 4664, 173, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[191540, 4671, 124, 2, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[191667, 4675, 182, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[191852, 4682, 910, 36, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[192765, 4720, 100, 2, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[192868, 4724, 159, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[193030, 4731, 158, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[193191, 4738, 137, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[193331, 4744, 271, 8, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[193605, 4754, 105, 2, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[193713, 4758, 283, 8, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[193999, 4768, 339, 9, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[194341, 4779, 217, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[194561, 4786, 415, 10, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[194979, 4798, 407, 14, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[195389, 4814, 110, 3, 30, "Text",
      CellTags->"b:1.3.11"],
    Cell[195502, 4819, 101, 2, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[195606, 4823, 144, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[195753, 4828, 271, 7, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[196027, 4837, 128, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[196158, 4842, 654, 24, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[196815, 4868, 137, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[196955, 4873, 309, 8, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[197267, 4883, 135, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[197405, 4888, 404, 9, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[197812, 4899, 531, 11, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[198346, 4912, 130, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[198479, 4917, 392, 12, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[198874, 4931, 134, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[199011, 4936, 387, 9, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[199401, 4947, 423, 10, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[199827, 4959, 139, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[199969, 4964, 467, 11, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[200439, 4977, 440, 12, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[200882, 4991, 360, 11, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[201245, 5004, 145, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[201393, 5009, 126, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[201522, 5015, 116, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[201641, 5021, 136, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[201780, 5026, 129, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[201912, 5032, 125, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[202040, 5037, 311, 11, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[202354, 5050, 147, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[202504, 5055, 121, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[202628, 5061, 371, 10, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[203002, 5073, 141, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[203146, 5078, 336, 9, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[203485, 5089, 136, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[203624, 5094, 237, 9, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[203864, 5105, 135, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[204002, 5110, 481, 10, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[204486, 5122, 138, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[204627, 5127, 501, 15, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[205131, 5144, 123, 3, 27, "Text",
      CellTags->"b:1.3.11"],
    Cell[205257, 5149, 128, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[205388, 5154, 278, 6, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[205669, 5162, 143, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[205815, 5167, 625, 16, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[206443, 5185, 132, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[206578, 5190, 371, 7, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[206952, 5199, 303, 7, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[207258, 5208, 293, 6, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[207554, 5216, 121, 3, 27, "Text",
      CellTags->"b:1.3.11"],
    Cell[207678, 5221, 124, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[207805, 5226, 105, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[207913, 5232, 122, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[208038, 5238, 134, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[208175, 5243, 349, 10, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[208527, 5255, 138, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[208668, 5260, 118, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[208789, 5266, 127, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[208919, 5272, 135, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[209057, 5277, 359, 11, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[209419, 5290, 300, 8, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[209722, 5300, 129, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[209854, 5305, 127, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[209984, 5311, 136, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[210123, 5316, 178, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[210304, 5323, 237, 6, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[210544, 5331, 345, 7, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[210892, 5340, 137, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[211032, 5345, 233, 6, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[211268, 5353, 239, 6, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[211510, 5361, 141, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[211654, 5366, 185, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[211842, 5373, 254, 6, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[212099, 5381, 268, 6, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[212370, 5389, 340, 7, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[212713, 5398, 141, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[212857, 5403, 227, 6, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[213087, 5411, 124, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[213214, 5416, 174, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[213391, 5423, 122, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[213516, 5429, 163, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[213682, 5436, 144, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[213829, 5443, 120, 3, 30, "Text",
      CellTags->"b:1.3.11"],
    Cell[213952, 5448, 165, 5, 27, "Text",
      CellTags->"b:1.3.11"],
    Cell[214120, 5455, 134, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[214257, 5460, 287, 7, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[214547, 5469, 309, 7, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[214859, 5478, 133, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[214995, 5483, 203, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[215201, 5490, 203, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[215407, 5497, 304, 8, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[215714, 5507, 395, 8, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[216112, 5517, 283, 7, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[216398, 5526, 170, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[216571, 5533, 203, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[216777, 5540, 227, 5, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[217007, 5547, 301, 11, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[217311, 5560, 151, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[217465, 5565, 326, 11, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[217794, 5578, 144, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[217941, 5583, 472, 15, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[218416, 5600, 558, 19, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[218977, 5621, 135, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[219115, 5626, 154, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[219272, 5633, 135, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[219410, 5638, 234, 7, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[219647, 5647, 146, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[219796, 5652, 119, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[219918, 5658, 129, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[220050, 5663, 582, 22, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[220635, 5687, 138, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[220776, 5692, 354, 12, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[221133, 5706, 352, 12, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[221488, 5720, 365, 12, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[221856, 5734, 127, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[221986, 5739, 178, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[222167, 5746, 829, 30, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[222999, 5778, 553, 12, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[223555, 5792, 107, 3, 27, "Text",
      CellTags->"b:1.3.11"],
    Cell[223665, 5797, 127, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[223795, 5802, 212, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[224010, 5809, 686, 24, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[224699, 5835, 140, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[224842, 5840, 742, 27, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[225587, 5869, 124, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[225714, 5874, 238, 8, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[225955, 5884, 247, 7, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[226205, 5893, 176, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[226384, 5900, 237, 7, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[226624, 5909, 155, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[226782, 5914, 190, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[226975, 5921, 110, 3, 27, "Text",
      CellTags->"b:1.3.11"],
    Cell[227088, 5926, 129, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[227220, 5931, 465, 15, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[227688, 5948, 558, 20, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[228249, 5970, 403, 15, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[228655, 5987, 447, 15, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[229105, 6004, 378, 10, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[229486, 6016, 621, 25, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[230110, 6043, 476, 17, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[230589, 6062, 654, 22, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[231246, 6086, 130, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[231379, 6091, 824, 30, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[232206, 6123, 144, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[232353, 6128, 959, 38, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[233315, 6168, 139, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[233457, 6173, 439, 16, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[233899, 6191, 112, 3, 27, "Text",
      CellTags->"b:1.3.11"],
    Cell[234014, 6196, 136, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[234153, 6201, 435, 15, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[234591, 6218, 129, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[234723, 6223, 354, 13, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[235080, 6238, 133, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[235216, 6243, 338, 11, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[235557, 6256, 148, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[235708, 6261, 552, 18, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[236263, 6281, 153, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[236419, 6286, 474, 21, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[236896, 6309, 110, 3, 27, "Text",
      CellTags->"b:1.3.11"],
    Cell[237009, 6314, 130, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[237142, 6319, 423, 13, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[237568, 6334, 114, 3, 27, "Text",
      CellTags->"b:1.3.11"],
    Cell[237685, 6339, 145, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[237833, 6344, 430, 15, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[238266, 6361, 125, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[238394, 6366, 565, 18, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[238962, 6386, 141, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[239106, 6391, 300, 9, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[239409, 6402, 142, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[239554, 6407, 950, 35, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[240507, 6444, 136, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[240646, 6449, 878, 32, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[241527, 6483, 150, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[241680, 6488, 358, 12, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[242041, 6502, 141, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[242185, 6507, 276, 10, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[242464, 6519, 140, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[242607, 6524, 441, 15, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[243051, 6541, 154, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[243208, 6546, 440, 15, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[243651, 6563, 130, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[243784, 6568, 232, 6, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[244019, 6576, 181, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[244203, 6583, 269, 6, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[244475, 6591, 144, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[244622, 6596, 620, 23, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[245245, 6621, 156, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[245404, 6626, 408, 15, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[245815, 6643, 143, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[245961, 6648, 342, 13, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[246306, 6663, 133, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[246442, 6668, 309, 11, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[246754, 6681, 334, 13, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[247091, 6696, 291, 8, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[247385, 6706, 332, 8, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[247720, 6716, 150, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[247873, 6721, 569, 20, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[248445, 6743, 504, 21, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[248952, 6766, 136, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[249091, 6771, 415, 17, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[249509, 6790, 516, 19, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[250028, 6811, 141, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[250172, 6816, 390, 15, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[250565, 6833, 520, 18, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[251088, 6853, 526, 19, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[251617, 6874, 153, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[251773, 6879, 756, 20, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[252532, 6901, 656, 16, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[253191, 6919, 129, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[253323, 6924, 436, 11, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[253762, 6937, 140, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[253905, 6942, 202, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[254110, 6949, 153, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[254266, 6954, 336, 8, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[254605, 6964, 128, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[254736, 6969, 579, 23, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[255318, 6994, 140, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[255461, 6999, 476, 11, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[255940, 7012, 663, 16, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[256606, 7030, 128, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[256737, 7035, 501, 14, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[257241, 7051, 454, 15, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[257698, 7068, 133, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[257834, 7073, 494, 15, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[258331, 7090, 655, 20, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[258989, 7112, 135, 3, 25, "Text",
      CellTags->"b:1.3.11"],
    Cell[259127, 7117, 492, 12, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[259622, 7131, 558, 16, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[260183, 7149, 119, 3, 27, "Text",
      CellTags->"b:1.3.11"],
    Cell[260305, 7154, 126, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[260434, 7160, 174, 5, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[260611, 7167, 134, 3, 30, "Text",
      CellTags->"b:1.3.11"],
    Cell[260748, 7172, 118, 3, 27, "Text",
      CellTags->"b:1.3.11"],
    Cell[260869, 7177, 361, 11, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[261233, 7190, 109, 3, 27, "Text",
      CellTags->"b:1.3.11"],
    Cell[261345, 7195, 291, 8, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[261639, 7205, 381, 9, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[262023, 7216, 424, 12, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[262450, 7230, 280, 8, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[262733, 7240, 109, 3, 30, "Text",
      CellTags->"b:1.3.11"],
    Cell[262845, 7245, 114, 3, 27, "Text",
      CellTags->"b:1.3.11"],
    Cell[262962, 7250, 112, 4, 50, "Text",
      CellTags->"b:1.3.11"],
    Cell[263077, 7256, 527, 14, 67, "Text",
      CellTags->"b:1.3.11"],
    Cell[263607, 7272, 139, 4, 50, "Text",
      CellTags->"b:1.3.11"]},
  "b:1.4.1"->{
    Cell[263847, 7286, 51, 1, 39, "Subsection",
      CellTags->"b:1.4.1"],
    Cell[263901, 7289, 964, 23, 59, "Text",
      CellTags->"b:1.4.1"],
    Cell[264868, 7314, 600, 13, 42, "Text",
      CellTags->"b:1.4.1"],
    Cell[265471, 7329, 307, 8, 25, "Text",
      CellTags->"b:1.4.1"],
    Cell[265803, 7341, 56, 1, 25, "SubsubsectionIcon",
      CellTags->"b:1.4.1"],
    Cell[265862, 7344, 7904, 151, 2029, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.1"],
    Cell[273803, 7500, 60, 1, 21, "SubsubsectionIcon",
      CellTags->"b:1.4.1"],
    Cell[273866, 7503, 94, 2, 29, "Input",
      CellTags->"b:1.4.1"],
    Cell[273963, 7507, 99, 2, 29, "Input",
      CellTags->"b:1.4.1"],
    Cell[274065, 7511, 125, 3, 29, "Input",
      CellTags->"b:1.4.1"]},
  "b:1.4.2"->{
    Cell[274239, 7520, 51, 1, 39, "Subsection",
      CellTags->"b:1.4.2"],
    Cell[274293, 7523, 793, 20, 42, "Text",
      CellTags->"b:1.4.2"],
    Cell[275089, 7545, 282, 6, 25, "Text",
      CellTags->"b:1.4.2"],
    Cell[275374, 7553, 307, 8, 25, "Text",
      CellTags->"b:1.4.2"],
    Cell[275706, 7565, 84, 2, 25, "SubsubsectionIcon",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[275793, 7569, 99, 3, 30, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[275895, 7574, 152, 4, 50, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[276050, 7580, 311, 7, 110, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[276364, 7589, 195, 4, 50, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[276562, 7595, 128, 3, 30, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[276693, 7600, 150, 4, 50, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[276846, 7606, 1166, 22, 410, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[278015, 7630, 194, 5, 50, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[278212, 7637, 500, 9, 150, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[278715, 7648, 637, 13, 250, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[279355, 7663, 305, 6, 110, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[279663, 7671, 136, 3, 30, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[279802, 7676, 391, 8, 150, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[280196, 7686, 260, 7, 110, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.2"],
    Cell[280493, 7698, 59, 1, 21, "SubsubsectionIcon",
      CellTags->"b:1.4.2"],
    Cell[280555, 7701, 118, 3, 25, "Text",
      CellTags->"b:1.4.2"],
    Cell[280698, 7708, 87, 2, 29, "Input",
      CellTags->"b:1.4.2"],
    Cell[280788, 7712, 566, 18, 49, "Print",
      CellTags->"b:1.4.2"],
    Cell[281357, 7732, 655, 18, 49, "Print",
      CellTags->"b:1.4.2"],
    Cell[282015, 7752, 596, 18, 49, "Print",
      CellTags->"b:1.4.2"],
    Cell[282614, 7772, 573, 18, 49, "Print",
      CellTags->"b:1.4.2"],
    Cell[283190, 7792, 657, 18, 49, "Print",
      CellTags->"b:1.4.2"],
    Cell[283850, 7812, 657, 18, 49, "Print",
      CellTags->"b:1.4.2"],
    Cell[284510, 7832, 608, 18, 49, "Print",
      CellTags->"b:1.4.2"],
    Cell[285121, 7852, 598, 18, 49, "Print",
      CellTags->"b:1.4.2"],
    Cell[285722, 7872, 576, 18, 49, "Print",
      CellTags->"b:1.4.2"],
    Cell[286301, 7892, 653, 18, 49, "Print",
      CellTags->"b:1.4.2"],
    Cell[286969, 7913, 139, 4, 21, "Text",
      CellTags->"b:1.4.2"],
    Cell[287133, 7921, 113, 2, 29, "Input",
      CellTags->"b:1.4.2"],
    Cell[287249, 7925, 678, 18, 49, "Print",
      CellTags->"b:1.4.2"],
    Cell[287930, 7945, 639, 18, 49, "Print",
      CellTags->"b:1.4.2"],
    Cell[288584, 7966, 137, 4, 21, "Text",
      CellTags->"b:1.4.2"],
    Cell[288746, 7974, 140, 3, 29, "Input",
      CellTags->"b:1.4.2"],
    Cell[288889, 7979, 420, 14, 33, "Print",
      CellTags->"b:1.4.2"],
    Cell[289312, 7995, 447, 13, 50, "Print",
      CellTags->"b:1.4.2"],
    Cell[289762, 8010, 454, 13, 50, "Print",
      CellTags->"b:1.4.2"],
    Cell[290219, 8025, 471, 15, 33, "Print",
      CellTags->"b:1.4.2"],
    Cell[290693, 8042, 473, 15, 33, "Print",
      CellTags->"b:1.4.2"],
    Cell[291169, 8059, 398, 12, 33, "Print",
      CellTags->"b:1.4.2"],
    Cell[291570, 8073, 385, 12, 33, "Print",
      CellTags->"b:1.4.2"],
    Cell[291958, 8087, 436, 13, 33, "Print",
      CellTags->"b:1.4.2"],
    Cell[292397, 8102, 419, 14, 33, "Print",
      CellTags->"b:1.4.2"],
    Cell[292819, 8118, 422, 14, 33, "Print",
      CellTags->"b:1.4.2"]},
  "b:1.4.3"->{
    Cell[293302, 8139, 59, 1, 39, "Subsection",
      CellTags->"b:1.4.3"],
    Cell[293364, 8142, 928, 27, 42, "Text",
      CellTags->"b:1.4.3"],
    Cell[294295, 8171, 427, 11, 25, "Text",
      CellTags->"b:1.4.3"],
    Cell[294725, 8184, 307, 8, 25, "Text",
      CellTags->"b:1.4.3"],
    Cell[295057, 8196, 84, 2, 25, "SubsubsectionIcon",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[295144, 8200, 109, 3, 29, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[295256, 8205, 229, 5, 29, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[295488, 8212, 314, 7, 109, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[295805, 8221, 195, 4, 29, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[296003, 8227, 154, 4, 29, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[296160, 8233, 994, 18, 209, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[297157, 8253, 194, 5, 29, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[297354, 8260, 500, 9, 149, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[297857, 8271, 718, 14, 209, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[298578, 8287, 365, 8, 129, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[298946, 8297, 305, 6, 109, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[299254, 8305, 136, 3, 29, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[299393, 8310, 391, 8, 149, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[299787, 8320, 260, 7, 29, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.3"],
    Cell[300084, 8332, 59, 1, 21, "SubsubsectionIcon",
      CellTags->"b:1.4.3"],
    Cell[300146, 8335, 118, 3, 25, "Text",
      CellTags->"b:1.4.3"],
    Cell[300289, 8342, 95, 2, 29, "Input",
      CellTags->"b:1.4.3"],
    Cell[300387, 8346, 774, 22, 49, "Print",
      CellTags->"b:1.4.3"],
    Cell[301164, 8370, 734, 21, 49, "Print",
      CellTags->"b:1.4.3"],
    Cell[301901, 8393, 782, 21, 49, "Print",
      CellTags->"b:1.4.3"],
    Cell[302686, 8416, 807, 26, 49, "Print",
      CellTags->"b:1.4.3"],
    Cell[303496, 8444, 860, 26, 49, "Print",
      CellTags->"b:1.4.3"],
    Cell[304359, 8472, 726, 21, 49, "Print",
      CellTags->"b:1.4.3"],
    Cell[305088, 8495, 885, 28, 49, "Print",
      CellTags->"b:1.4.3"],
    Cell[305976, 8525, 834, 24, 49, "Print",
      CellTags->"b:1.4.3"],
    Cell[306813, 8551, 898, 29, 49, "Print",
      CellTags->"b:1.4.3"],
    Cell[307714, 8582, 872, 27, 49, "Print",
      CellTags->"b:1.4.3"],
    Cell[308601, 8612, 192, 6, 21, "Text",
      CellTags->"b:1.4.3"],
    Cell[308818, 8622, 134, 3, 29, "Input",
      CellTags->"b:1.4.3"],
    Cell[308955, 8627, 812, 26, 49, "Print",
      CellTags->"b:1.4.3"],
    Cell[309770, 8655, 925, 29, 49, "Print",
      CellTags->"b:1.4.3"],
    Cell[310710, 8687, 68, 1, 21, "Text",
      CellTags->"b:1.4.3"],
    Cell[310803, 8692, 117, 3, 29, "Input",
      CellTags->"b:1.4.3"],
    Cell[310923, 8697, 551, 17, 33, "Print",
      CellTags->"b:1.4.3"],
    Cell[311477, 8716, 561, 17, 33, "Print",
      CellTags->"b:1.4.3"],
    Cell[312041, 8735, 475, 15, 33, "Print",
      CellTags->"b:1.4.3"],
    Cell[312519, 8752, 526, 16, 33, "Print",
      CellTags->"b:1.4.3"],
    Cell[313048, 8770, 598, 19, 33, "Print",
      CellTags->"b:1.4.3"],
    Cell[313649, 8791, 561, 18, 33, "Print",
      CellTags->"b:1.4.3"],
    Cell[314213, 8811, 614, 20, 33, "Print",
      CellTags->"b:1.4.3"],
    Cell[314830, 8833, 620, 19, 33, "Print",
      CellTags->"b:1.4.3"],
    Cell[315453, 8854, 618, 20, 33, "Print",
      CellTags->"b:1.4.3"]},
  "b:1.4.4"->{
    Cell[316132, 8881, 53, 1, 39, "Subsection",
      CellTags->"b:1.4.4"],
    Cell[316188, 8884, 682, 15, 42, "Text",
      CellTags->"b:1.4.4"],
    Cell[316873, 8901, 661, 12, 59, "Text",
      CellTags->"b:1.4.4"],
    Cell[317537, 8915, 307, 8, 25, "Text",
      CellTags->"b:1.4.4"],
    Cell[317869, 8927, 56, 1, 25, "SubsubsectionIcon",
      CellTags->"b:1.4.4"],
    Cell[317928, 8930, 3661, 70, 970, "Input",
      InitializationCell->True,
      CellTags->"b:1.4.4"],
    Cell[321626, 9005, 59, 1, 21, "SubsubsectionIcon",
      CellTags->"b:1.4.4"],
    Cell[321688, 9008, 77, 2, 29, "Input",
      CellTags->"b:1.4.4"]},
  "b:1.4.5"->{
    Cell[321814, 9016, 57, 1, 39, "Subsection",
      CellTags->"b:1.4.5"],
    Cell[321874, 9019, 1030, 29, 42, "Text",
      CellTags->"b:1.4.5"],
    Cell[322907, 9050, 997, 15, 76, "Text",
      CellTags->"b:1.4.5"],
    Cell[323907, 9067, 407, 12, 25, "Text",
      CellTags->"b:1.4.5"],
    Cell[324317, 9081, 207, 6, 25, "Text",
      CellTags->"b:1.4.5"],
    Cell[324527, 9089, 168, 4, 49, "Input",
      CellTags->"b:1.4.5"]},
  "b:1.4.6"->{
    Cell[324732, 9098, 67, 1, 39, "Subsection",
      CellTags->"b:1.4.6"],
    Cell[324802, 9101, 436, 13, 42, "Text",
      CellTags->"b:1.4.6"],
    Cell[325241, 9116, 206, 6, 25, "Text",
      CellTags->"b:1.4.6"],
    Cell[325472, 9126, 176, 4, 49, "Input",
      CellTags->"b:1.4.6"],
    Cell[325651, 9132, 279, 7, 27, "Output",
      CellTags->"b:1.4.6"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"b:1.1", 326697, 9164},
  {"b:1.2.1", 327899, 9201},
  {"b:1.2.2", 328057, 9206},
  {"Info3277214259-7288901", 329236, 9239},
  {"b:1.2.3", 329350, 9242},
  {"Info3290922430-6355998", 330538, 9275},
  {"Type Mapping", 330657, 9278},
  {"b:1.3.1.1", 330754, 9281},
  {"b:1.3.1.2", 330996, 9288},
  {"b:1.3.1.3", 331165, 9293},
  {"b:1.3.1.4", 332231, 9322},
  {"b:1.3.1.5", 332918, 9341},
  {"b:1.3.1.6", 334720, 9390},
  {"b:1.3.1.7", 335854, 9421},
  {"Info3278164772-8849540", 336587, 9440},
  {"b:1.3.1.8", 336707, 9443},
  {"Info3278251906-4694478", 337591, 9466},
  {"b:1.3.2", 337709, 9469},
  {"b:1.3.3", 338737, 9498},
  {"b:1.3.4", 340072, 9535},
  {"b:1.3.5", 342206, 9594},
  {"b:1.3.6", 343740, 9637},
  {"b:1.3.7", 343975, 9644},
  {"b:1.3.8", 344138, 9649},
  {"b:1.3.9", 344302, 9654},
  {"b:1.3.10", 346048, 9703},
  {"b:1.3.11", 346290, 9710},
  {"b:1.4.1", 365475, 10241},
  {"b:1.4.2", 366271, 10263},
  {"b:1.4.3", 370274, 10375},
  {"b:1.4.4", 374204, 10485},
  {"b:1.4.5", 374855, 10503},
  {"b:1.4.6", 375307, 10516}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 37, 0, 105, "Title"],

Cell[CellGroupData[{
Cell[1838, 57, 52, 1, 65, "Section",
  CellTags->"b:1.1"],
Cell[1893, 60, 825, 17, 59, "Text",
  CellTags->"b:1.1"],
Cell[2721, 79, 89, 2, 25, "Text",
  CellTags->"b:1.1"],
Cell[2813, 83, 423, 13, 25, "Text",
  CellTags->"b:1.1"],
Cell[3239, 98, 457, 10, 42, "Text",
  CellTags->"b:1.1"],
Cell[3699, 110, 71, 2, 25, "Text",
  CellTags->"b:1.1"],
Cell[3773, 114, 486, 8, 42, "Text",
  CellTags->"b:1.1"],
Cell[4262, 124, 63, 2, 25, "Text",
  CellTags->"b:1.1"],
Cell[4328, 128, 719, 17, 42, "Text",
  CellTags->"b:1.1"],
Cell[5050, 147, 63, 2, 25, "Text",
  CellTags->"b:1.1"],
Cell[5116, 151, 860, 19, 59, "Text",
  CellTags->"b:1.1"],
Cell[5979, 172, 69, 2, 25, "Text",
  CellTags->"b:1.1"],
Cell[6051, 176, 725, 14, 59, "Text",
  CellTags->"b:1.1"],
Cell[6779, 192, 72, 2, 25, "Text",
  CellTags->"b:1.1"],
Cell[6854, 196, 836, 16, 59, "Text",
  CellTags->"b:1.1"],
Cell[7693, 214, 70, 2, 25, "Text",
  CellTags->"b:1.1"],
Cell[7766, 218, 717, 16, 42, "Text",
  CellTags->"b:1.1"],
Cell[8486, 236, 353, 7, 42, "Text",
  CellTags->"b:1.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8876, 248, 34, 0, 65, "Section"],

Cell[CellGroupData[{
Cell[8935, 252, 87, 2, 39, "Subsection",
  CellTags->"b:1.2.1"],
Cell[9025, 256, 359, 10, 25, "Text",
  CellTags->"b:1.2.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9421, 271, 60, 1, 39, "Subsection",
  CellTags->"b:1.2.2"],
Cell[9484, 274, 597, 15, 42, "Text",
  CellTags->"b:1.2.2"],
Cell[10084, 291, 105, 3, 29, "Input",
  CellTags->"b:1.2.2"],

Cell[CellGroupData[{
Cell[10214, 298, 164, 4, 29, "Input",
  CellTags->"b:1.2.2"],
Cell[10381, 304, 90, 3, 27, "Output",
  CellTags->"b:1.2.2"]
}, Open  ]],
Cell[10486, 310, 541, 15, 42, "Text",
  CellTags->"b:1.2.2"],

Cell[CellGroupData[{
Cell[11052, 329, 92, 3, 29, "Input",
  CellTags->"b:1.2.2"],
Cell[11147, 334, 387, 5, 64, "Print",
  CellTags->{"Info3277214259-7288901", "b:1.2.2"}]
}, Open  ]],
Cell[11549, 342, 1009, 22, 76, "Text",
  CellTags->"b:1.2.2"],
Cell[12561, 366, 392, 11, 25, "Text",
  CellTags->"b:1.2.2"],
Cell[12956, 379, 112, 2, 29, "Input",
  CellTags->"b:1.2.2"],
Cell[13071, 383, 260, 5, 25, "Text",
  CellTags->"b:1.2.2"],
Cell[13334, 390, 401, 12, 25, "Text",
  CellTags->"b:1.2.2"],

Cell[CellGroupData[{
Cell[13760, 406, 112, 3, 29, "Input",
  CellTags->"b:1.2.2"],
Cell[13875, 411, 88, 3, 27, "Output",
  CellTags->"b:1.2.2"]
}, Open  ]],
Cell[13978, 417, 375, 9, 42, "Text",
  CellTags->"b:1.2.2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14390, 431, 59, 1, 39, "Subsection",
  CellTags->"b:1.2.3"],
Cell[14452, 434, 849, 17, 59, "Text",
  CellTags->"b:1.2.3"],
Cell[15304, 453, 193, 6, 25, "Text",
  CellTags->"b:1.2.3"],
Cell[15500, 461, 105, 3, 29, "Input",
  CellTags->"b:1.2.3"],

Cell[CellGroupData[{
Cell[15630, 468, 158, 4, 29, "Input",
  CellTags->"b:1.2.3"],
Cell[15791, 474, 775, 13, 103, "Output",
  CellTags->"b:1.2.3"]
}, Open  ]],
Cell[16581, 490, 330, 8, 25, "Text",
  CellTags->"b:1.2.3"],

Cell[CellGroupData[{
Cell[16936, 502, 104, 3, 29, "Input",
  CellTags->"b:1.2.3"],
Cell[17043, 507, 390, 5, 64, "Print",
  CellTags->{"Info3290922430-6355998", "b:1.2.3"}]
}, Open  ]],
Cell[17448, 515, 823, 17, 59, "Text",
  CellTags->"b:1.2.3"],
Cell[18274, 534, 509, 8, 49, "Input",
  CellTags->"b:1.2.3"],
Cell[18786, 544, 597, 14, 42, "Text",
  CellTags->"b:1.2.3"],
Cell[19386, 560, 114, 3, 25, "Text",
  CellTags->"b:1.2.3"],

Cell[CellGroupData[{
Cell[19525, 567, 325, 6, 29, "Input",
  CellTags->"b:1.2.3"],
Cell[19853, 575, 10190, 174, 977, "Output",
  CellTags->"b:1.2.3"]
}, Open  ]],
Cell[30058, 752, 438, 8, 42, "Text",
  CellTags->"b:1.2.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30545, 766, 34, 0, 65, "Section"],

Cell[CellGroupData[{
Cell[30604, 770, 62, 1, 39, "Subsection",
  CellTags->"Type Mapping"],

Cell[CellGroupData[{
Cell[30691, 775, 62, 1, 35, "Subsubsection",
  CellTags->"b:1.3.1.1"],
Cell[30756, 778, 782, 15, 59, "Text",
  CellTags->"b:1.3.1.1"],
Cell[31541, 795, 1185, 39, 59, "Text",
  CellTags->"b:1.3.1.1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32763, 839, 67, 1, 35, "Subsubsection",
  CellTags->"b:1.3.1.2"],
Cell[32833, 842, 800, 15, 59, "Text",
  CellTags->"b:1.3.1.2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[33670, 862, 59, 1, 35, "Subsubsection",
  CellTags->"b:1.3.1.3"],
Cell[33732, 865, 996, 31, 59, "Text",
  CellTags->"b:1.3.1.3"],
Cell[34731, 898, 945, 16, 76, "Text",
  CellTags->"b:1.3.1.3"],
Cell[35679, 916, 339, 6, 42, "Text",
  CellTags->"b:1.3.1.3"],
Cell[36021, 924, 660, 14, 59, "Text",
  CellTags->"b:1.3.1.3"],
Cell[36684, 940, 354, 7, 42, "Text",
  CellTags->"b:1.3.1.3"],
Cell[37041, 949, 534, 15, 59, "InlineFormula",
  CellTags->"b:1.3.1.3"],
Cell[37578, 966, 385, 8, 42, "Text",
  CellTags->"b:1.3.1.3"],
Cell[37966, 976, 893, 26, 76, "InlineFormula",
  CellTags->"b:1.3.1.3"],
Cell[38862, 1004, 107, 3, 29, "Input",
  CellTags->"b:1.3.1.3"],

Cell[CellGroupData[{
Cell[38994, 1011, 190, 5, 29, "Input",
  CellTags->"b:1.3.1.3"],
Cell[39187, 1018, 777, 13, 103, "Output",
  CellTags->"b:1.3.1.3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[40001, 1036, 1594, 24, 229, "Input",
  CellTags->"b:1.3.1.3"],
Cell[41598, 1062, 27570, 511, 2706, "Output",
  CellTags->"b:1.3.1.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[69217, 1579, 69, 1, 35, "Subsubsection",
  CellTags->"b:1.3.1.4"],
Cell[69289, 1582, 763, 15, 59, "Text",
  CellTags->"b:1.3.1.4"],
Cell[70055, 1599, 108, 3, 29, "Input",
  CellTags->"b:1.3.1.4"],

Cell[CellGroupData[{
Cell[70188, 1606, 153, 4, 29, "Input",
  CellTags->"b:1.3.1.4"],
Cell[70344, 1612, 419, 7, 46, "Output",
  CellTags->"b:1.3.1.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[70800, 1624, 220, 5, 29, "Input",
  CellTags->"b:1.3.1.4"],
Cell[71023, 1631, 138, 2, 29, "Output",
  CellTags->"b:1.3.1.4"]
}, Open  ]],
Cell[71176, 1636, 442, 11, 42, "Text",
  CellTags->"b:1.3.1.4"],
Cell[71621, 1649, 5056, 120, 991, "Text",
  CellTags->"b:1.3.1.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76714, 1774, 68, 1, 35, "Subsubsection",
  CellTags->"b:1.3.1.5"],
Cell[76785, 1777, 616, 10, 59, "Text",
  CellTags->"b:1.3.1.5"],
Cell[77404, 1789, 408, 7, 42, "Text",
  CellTags->"b:1.3.1.5"],
Cell[77815, 1798, 859, 23, 92, "Text",
  CellTags->"b:1.3.1.5"],
Cell[78677, 1823, 629, 15, 250, "Text",
  CellTags->"b:1.3.1.5"],
Cell[79309, 1840, 2157, 40, 567, "Text",
  CellTags->"b:1.3.1.5"],
Cell[81469, 1882, 1520, 31, 359, "Text",
  CellTags->"b:1.3.1.5"],
Cell[82992, 1915, 1599, 29, 351, "Text",
  CellTags->"b:1.3.1.5"],
Cell[84594, 1946, 663, 14, 200, "Text",
  CellTags->"b:1.3.1.5"],
Cell[85260, 1962, 1041, 24, 242, "Text",
  CellTags->"b:1.3.1.5"],
Cell[86304, 1988, 981, 23, 242, "Text",
  CellTags->"b:1.3.1.5"],
Cell[87288, 2013, 665, 16, 175, "Text",
  CellTags->"b:1.3.1.5"],
Cell[87956, 2031, 619, 15, 150, "Text",
  CellTags->"b:1.3.1.5"],
Cell[88578, 2048, 877, 20, 250, "Text",
  CellTags->"b:1.3.1.5"],
Cell[89458, 2070, 562, 15, 100, "Text",
  CellTags->"b:1.3.1.5"],
Cell[90023, 2087, 853, 20, 250, "Text",
  CellTags->"b:1.3.1.5"],
Cell[90879, 2109, 839, 20, 275, "Text",
  CellTags->"b:1.3.1.5"],
Cell[91721, 2131, 781, 20, 225, "Text",
  CellTags->"b:1.3.1.5"],
Cell[92505, 2153, 821, 20, 250, "Text",
  CellTags->"b:1.3.1.5"],
Cell[93329, 2175, 909, 26, 142, "Text",
  CellTags->"b:1.3.1.5"],
Cell[94241, 2203, 1508, 29, 725, "Text",
  CellTags->"b:1.3.1.5"],
Cell[95752, 2234, 1254, 24, 500, "Text",
  CellTags->"b:1.3.1.5"],
Cell[97009, 2260, 939, 22, 350, "Text",
  CellTags->"b:1.3.1.5"],
Cell[97951, 2284, 919, 21, 250, "Text",
  CellTags->"b:1.3.1.5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[98907, 2310, 56, 1, 35, "Subsubsection",
  CellTags->"b:1.3.1.6"],
Cell[98966, 2313, 752, 17, 59, "Text",
  CellTags->"b:1.3.1.6"],
Cell[99721, 2332, 107, 3, 29, "Input",
  CellTags->"b:1.3.1.6"],

Cell[CellGroupData[{
Cell[99853, 2339, 180, 4, 29, "Input",
  CellTags->"b:1.3.1.6"],
Cell[100036, 2345, 200, 4, 27, "Output",
  CellTags->"b:1.3.1.6"]
}, Open  ]],
Cell[100251, 2352, 421, 14, 25, "Text",
  CellTags->"b:1.3.1.6"],

Cell[CellGroupData[{
Cell[100697, 2370, 237, 6, 29, "Input",
  CellTags->"b:1.3.1.6"],
Cell[100937, 2378, 670, 13, 65, "Output",
  CellTags->"b:1.3.1.6"]
}, Open  ]],
Cell[101622, 2394, 143, 4, 25, "Text",
  CellTags->"b:1.3.1.6"],

Cell[CellGroupData[{
Cell[101790, 2402, 98, 3, 29, "Input",
  CellTags->"b:1.3.1.6"],
Cell[101891, 2407, 474, 9, 65, "Output",
  CellTags->"b:1.3.1.6"]
}, Open  ]],
Cell[102380, 2419, 585, 11, 42, "Text",
  CellTags->"b:1.3.1.6"],
Cell[102968, 2432, 292, 9, 150, "Text",
  CellTags->"b:1.3.1.6"],
Cell[103263, 2443, 583, 10, 59, "Text",
  CellTags->"b:1.3.1.6"],
Cell[103849, 2455, 410, 11, 200, "Text",
  CellTags->"b:1.3.1.6"]
}, Open  ]],

Cell[CellGroupData[{
Cell[104296, 2471, 61, 1, 35, "Subsubsection",
  CellTags->"b:1.3.1.7"],
Cell[104360, 2474, 1067, 20, 76, "Text",
  CellTags->"b:1.3.1.7"],
Cell[105430, 2496, 97, 3, 29, "Input",
  CellTags->"b:1.3.1.7"],

Cell[CellGroupData[{
Cell[105552, 2503, 174, 4, 29, "Input",
  CellTags->"b:1.3.1.7"],
Cell[105729, 2509, 223, 5, 27, "Output",
  CellTags->"b:1.3.1.7"]
}, Open  ]],

Cell[CellGroupData[{
Cell[105989, 2519, 106, 3, 29, "Input",
  CellTags->"b:1.3.1.7"],
Cell[106098, 2524, 502, 7, 64, "Print",
  CellTags->{"Info3278164772-8849540", "b:1.3.1.7"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[106637, 2536, 109, 3, 29, "Input",
  CellTags->"b:1.3.1.7"],
Cell[106749, 2541, 94, 3, 27, "Output",
  CellTags->"b:1.3.1.7"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[106892, 2550, 56, 1, 35, "Subsubsection",
  CellTags->"b:1.3.1.8"],
Cell[106951, 2553, 565, 11, 59, "Text",
  CellTags->"b:1.3.1.8"],
Cell[107519, 2566, 98, 3, 29, "Input",
  CellTags->"b:1.3.1.8"],

Cell[CellGroupData[{
Cell[107642, 2573, 174, 4, 29, "Input",
  CellTags->"b:1.3.1.8"],
Cell[107819, 2579, 223, 5, 27, "Output",
  CellTags->"b:1.3.1.8"]
}, Open  ]],

Cell[CellGroupData[{
Cell[108079, 2589, 103, 3, 29, "Input",
  CellTags->"b:1.3.1.8"],
Cell[108185, 2594, 461, 6, 64, "Print",
  CellTags->{"Info3278251906-4694478", "b:1.3.1.8"}]
}, Open  ]],

Cell[CellGroupData[{
Cell[108683, 2605, 174, 5, 29, "Input",
  CellTags->"b:1.3.1.8"],
Cell[108860, 2612, 1822, 32, 179, "Output",
  CellTags->"b:1.3.1.8"]
}, Open  ]],

Cell[CellGroupData[{
Cell[110719, 2649, 128, 3, 29, "Input",
  CellTags->"b:1.3.1.8"],
Cell[110850, 2654, 95, 3, 27, "Output",
  CellTags->"b:1.3.1.8"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[111006, 2664, 60, 1, 39, "Subsection",
  CellTags->"b:1.3.2"],
Cell[111069, 2667, 459, 10, 42, "Text",
  CellTags->"b:1.3.2"],
Cell[111531, 2679, 106, 3, 29, "Input",
  CellTags->"b:1.3.2"],

Cell[CellGroupData[{
Cell[111662, 2686, 179, 4, 29, "Input",
  CellTags->"b:1.3.2"],
Cell[111844, 2692, 92, 3, 27, "Output",
  CellTags->"b:1.3.2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[111973, 2700, 98, 3, 29, "Input",
  CellTags->"b:1.3.2"],
Cell[112074, 2705, 99, 3, 27, "Output",
  CellTags->"b:1.3.2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[112210, 2713, 107, 3, 29, "Input",
  CellTags->"b:1.3.2"],
Cell[112320, 2718, 88, 3, 27, "Output",
  CellTags->"b:1.3.2"]
}, Open  ]],
Cell[112423, 2724, 774, 20, 59, "Text",
  CellTags->"b:1.3.2"],

Cell[CellGroupData[{
Cell[113222, 2748, 199, 5, 29, "Input",
  CellTags->"b:1.3.2"],
Cell[113424, 2755, 135, 3, 27, "Output",
  CellTags->"b:1.3.2"]
}, Open  ]],

Cell[CellGroupData[{
Cell[113596, 2763, 159, 4, 29, "Input",
  CellTags->"b:1.3.2"],
Cell[113758, 2769, 88, 3, 27, "Output",
  CellTags->"b:1.3.2"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[113895, 2778, 66, 1, 39, "Subsection",
  CellTags->"b:1.3.3"],
Cell[113964, 2781, 656, 14, 59, "Text",
  CellTags->"b:1.3.3"],
Cell[114623, 2797, 106, 3, 29, "Input",
  CellTags->"b:1.3.3"],

Cell[CellGroupData[{
Cell[114754, 2804, 158, 4, 29, "Input",
  CellTags->"b:1.3.3"],
Cell[114915, 2810, 94, 3, 27, "Output",
  CellTags->"b:1.3.3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[115046, 2818, 136, 3, 29, "Input",
  CellTags->"b:1.3.3"],
Cell[115185, 2823, 983, 19, 103, "Output",
  CellTags->"b:1.3.3"]
}, Open  ]],
Cell[116183, 2845, 820, 16, 59, "Text",
  CellTags->"b:1.3.3"],

Cell[CellGroupData[{
Cell[117028, 2865, 180, 4, 29, "Input",
  CellTags->"b:1.3.3"],
Cell[117211, 2871, 2202, 35, 274, "Output",
  CellTags->"b:1.3.3"]
}, Open  ]],

Cell[CellGroupData[{
Cell[119450, 2911, 128, 3, 29, "Input",
  CellTags->"b:1.3.3"],
Cell[119581, 2916, 2202, 35, 274, "Output",
  CellTags->"b:1.3.3"]
}, Open  ]],
Cell[121798, 2954, 817, 18, 59, "Text",
  CellTags->"b:1.3.3"],

Cell[CellGroupData[{
Cell[122640, 2976, 143, 4, 29, "Input",
  CellTags->"b:1.3.3"],
Cell[122786, 2982, 2202, 35, 274, "Output",
  CellTags->"b:1.3.3"]
}, Open  ]],
Cell[125003, 3020, 692, 16, 59, "Text",
  CellTags->"b:1.3.3"],

Cell[CellGroupData[{
Cell[125720, 3040, 110, 3, 29, "Input",
  CellTags->"b:1.3.3"],
Cell[125833, 3045, 1171, 17, 141, "Output",
  CellTags->"b:1.3.3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[127053, 3068, 67, 1, 39, "Subsection",
  CellTags->"b:1.3.4"],
Cell[127123, 3071, 643, 14, 42, "Text",
  CellTags->"b:1.3.4"],
Cell[127769, 3087, 1084, 19, 76, "Text",
  CellTags->"b:1.3.4"],
Cell[128856, 3108, 4840, 130, 345, "Text",
  CellTags->"b:1.3.4"],
Cell[133699, 3240, 106, 3, 29, "Input",
  CellTags->"b:1.3.4"],

Cell[CellGroupData[{
Cell[133830, 3247, 239, 6, 49, "Input",
  CellTags->"b:1.3.4"],
Cell[134072, 3255, 797, 16, 84, "Output",
  CellTags->"b:1.3.4"]
}, Open  ]],
Cell[134884, 3274, 347, 8, 42, "Text",
  CellTags->"b:1.3.4"],

Cell[CellGroupData[{
Cell[135256, 3286, 174, 4, 29, "Input",
  CellTags->"b:1.3.4"],
Cell[135433, 3292, 1117, 20, 122, "Output",
  CellTags->"b:1.3.4"]
}, Open  ]],
Cell[136565, 3315, 603, 14, 42, "Text",
  CellTags->"b:1.3.4"],
Cell[137171, 3331, 639, 16, 97, "Text",
  CellTags->"b:1.3.4"],

Cell[CellGroupData[{
Cell[137835, 3351, 367, 8, 69, "Input",
  CellTags->"b:1.3.4"],
Cell[138205, 3361, 984, 19, 103, "Output",
  CellTags->"b:1.3.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[139226, 3385, 174, 4, 29, "Input",
  CellTags->"b:1.3.4"],
Cell[139403, 3391, 1117, 20, 122, "Output",
  CellTags->"b:1.3.4"]
}, Open  ]],
Cell[140535, 3414, 726, 15, 59, "Text",
  CellTags->"b:1.3.4"],

Cell[CellGroupData[{
Cell[141286, 3433, 377, 8, 49, "Input",
  CellTags->"b:1.3.4"],
Cell[141666, 3443, 858, 17, 84, "Output",
  CellTags->"b:1.3.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[142561, 3465, 196, 5, 29, "Input",
  CellTags->"b:1.3.4"],
Cell[142760, 3472, 1117, 20, 122, "Output",
  CellTags->"b:1.3.4"]
}, Open  ]],
Cell[143892, 3495, 690, 16, 59, "Text",
  CellTags->"b:1.3.4"],

Cell[CellGroupData[{
Cell[144607, 3515, 110, 3, 29, "Input",
  CellTags->"b:1.3.4"],
Cell[144720, 3520, 86, 3, 27, "Output",
  CellTags->"b:1.3.4"]
}, Open  ]],
Cell[144821, 3526, 1754, 44, 110, "Text",
  CellTags->"b:1.3.4"],

Cell[CellGroupData[{
Cell[146600, 3574, 464, 10, 69, "Input",
  CellTags->"b:1.3.4"],
Cell[147067, 3586, 100, 3, 27, "Output",
  CellTags->"b:1.3.4"]
}, Open  ]],

Cell[CellGroupData[{
Cell[147204, 3594, 112, 3, 29, "Input",
  CellTags->"b:1.3.4"],
Cell[147319, 3599, 86, 3, 27, "Output",
  CellTags->"b:1.3.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[147454, 3608, 71, 1, 39, "Subsection",
  CellTags->"b:1.3.5"],
Cell[147528, 3611, 949, 25, 59, "Text",
  CellTags->"b:1.3.5"],
Cell[148480, 3638, 105, 3, 29, "Input",
  CellTags->"b:1.3.5"],

Cell[CellGroupData[{
Cell[148610, 3645, 150, 4, 29, "Input",
  CellTags->"b:1.3.5"],
Cell[148763, 3651, 416, 7, 46, "Output",
  CellTags->"b:1.3.5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[149216, 3663, 98, 3, 29, "Input",
  CellTags->"b:1.3.5"],
Cell[149317, 3668, 416, 7, 46, "Output",
  CellTags->"b:1.3.5"]
}, Open  ]],
Cell[149748, 3678, 463, 14, 42, "Text",
  CellTags->"b:1.3.5"],
Cell[150214, 3694, 136, 3, 29, "Input",
  CellTags->"b:1.3.5"],

Cell[CellGroupData[{
Cell[150375, 3701, 98, 3, 29, "Input",
  CellTags->"b:1.3.5"],
Cell[150476, 3706, 385, 7, 46, "Output",
  CellTags->"b:1.3.5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[150898, 3718, 127, 3, 29, "Input",
  CellTags->"b:1.3.5"],
Cell[151028, 3723, 107, 3, 27, "Output",
  CellTags->"b:1.3.5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[151172, 3731, 118, 3, 29, "Input",
  CellTags->"b:1.3.5"],
Cell[151293, 3736, 90, 3, 27, "Output",
  CellTags->"b:1.3.5"]
}, Open  ]],
Cell[151398, 3742, 341, 12, 25, "Text",
  CellTags->"b:1.3.5"],
Cell[151742, 3756, 135, 3, 29, "Input",
  CellTags->"b:1.3.5"],

Cell[CellGroupData[{
Cell[151902, 3763, 98, 3, 29, "Input",
  CellTags->"b:1.3.5"],
Cell[152003, 3768, 83, 3, 27, "Output",
  CellTags->"b:1.3.5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[152123, 3776, 121, 3, 29, "Input",
  CellTags->"b:1.3.5"],
Cell[152247, 3781, 108, 3, 27, "Output",
  CellTags->"b:1.3.5"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[152404, 3790, 65, 1, 39, "Subsection",
  CellTags->"b:1.3.6"],
Cell[152472, 3793, 664, 10, 59, "Text",
  CellTags->"b:1.3.6"],
Cell[153139, 3805, 470, 8, 42, "Text",
  CellTags->"b:1.3.6"]
}, Open  ]],

Cell[CellGroupData[{
Cell[153646, 3818, 66, 1, 39, "Subsection",
  CellTags->"b:1.3.7"],
Cell[153715, 3821, 453, 8, 42, "Text",
  CellTags->"b:1.3.7"]
}, Open  ]],

Cell[CellGroupData[{
Cell[154205, 3834, 59, 1, 39, "Subsection",
  CellTags->"b:1.3.8"],
Cell[154267, 3837, 506, 13, 42, "Text",
  CellTags->"b:1.3.8"]
}, Open  ]],

Cell[CellGroupData[{
Cell[154810, 3855, 67, 1, 39, "Subsection",
  CellTags->"b:1.3.9"],
Cell[154880, 3858, 953, 25, 59, "Text",
  CellTags->"b:1.3.9"],
Cell[155836, 3885, 364, 8, 42, "Text",
  CellTags->"b:1.3.9"],
Cell[156203, 3895, 139, 3, 26, "Text",
  CellTags->"b:1.3.9"],
Cell[156345, 3900, 84, 1, 25, "Text",
  CellTags->"b:1.3.9"],
Cell[156432, 3903, 131, 3, 26, "Text",
  CellTags->"b:1.3.9"],
Cell[156566, 3908, 526, 12, 42, "Text",
  CellTags->"b:1.3.9"],
Cell[157095, 3922, 362, 7, 42, "Text",
  CellTags->"b:1.3.9"],
Cell[157460, 3931, 221, 7, 25, "Text",
  CellTags->"b:1.3.9"],
Cell[157684, 3940, 287, 10, 25, "Text",
  CellTags->"b:1.3.9"],
Cell[157974, 3952, 212, 7, 25, "Text",
  CellTags->"b:1.3.9"],
Cell[158189, 3961, 280, 10, 25, "Text",
  CellTags->"b:1.3.9"],
Cell[158472, 3973, 164, 5, 25, "Text",
  CellTags->"b:1.3.9"],
Cell[158639, 3980, 309, 6, 42, "Text",
  CellTags->"b:1.3.9"],
Cell[158951, 3988, 160, 4, 25, "Text",
  CellTags->"b:1.3.9"],

Cell[CellGroupData[{
Cell[159136, 3996, 117, 3, 29, "Input",
  CellTags->"b:1.3.9"],
Cell[159256, 4001, 93, 3, 27, "Output",
  CellTags->"b:1.3.9"]
}, Open  ]],

Cell[CellGroupData[{
Cell[159386, 4009, 120, 3, 29, "Input",
  CellTags->"b:1.3.9"],
Cell[159509, 4014, 121, 3, 27, "Output",
  CellTags->"b:1.3.9"]
}, Open  ]],

Cell[CellGroupData[{
Cell[159667, 4022, 116, 3, 29, "Input",
  CellTags->"b:1.3.9"],
Cell[159786, 4027, 18754, 268, 2174, "Output",
  CellTags->"b:1.3.9"]
}, Open  ]],

Cell[CellGroupData[{
Cell[178577, 4300, 119, 3, 29, "Input",
  CellTags->"b:1.3.9"],
Cell[178699, 4305, 120, 3, 27, "Output",
  CellTags->"b:1.3.9"]
}, Open  ]],
Cell[178834, 4311, 226, 5, 25, "Text",
  CellTags->"b:1.3.9"]
}, Open  ]],

Cell[CellGroupData[{
Cell[179097, 4321, 55, 1, 39, "Subsection",
  CellTags->"b:1.3.10"],
Cell[179155, 4324, 263, 5, 25, "Text",
  CellTags->"b:1.3.10"],
Cell[179421, 4331, 9056, 235, 171, "Text",
  CellTags->"b:1.3.10"]
}, Open  ]],

Cell[CellGroupData[{
Cell[188514, 4571, 66, 1, 39, "Subsection",
  CellTags->"b:1.3.11"],
Cell[188583, 4574, 605, 13, 42, "Text",
  CellTags->"b:1.3.11"],
Cell[189191, 4589, 120, 3, 30, "Text",
  CellTags->"b:1.3.11"],
Cell[189314, 4594, 90, 2, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[189407, 4598, 792, 21, 75, "Text",
  CellTags->"b:1.3.11"],
Cell[190202, 4621, 115, 2, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[190320, 4625, 663, 25, 75, "Text",
  CellTags->"b:1.3.11"],
Cell[190986, 4652, 375, 10, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[191364, 4664, 173, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[191540, 4671, 124, 2, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[191667, 4675, 182, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[191852, 4682, 910, 36, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[192765, 4720, 100, 2, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[192868, 4724, 159, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[193030, 4731, 158, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[193191, 4738, 137, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[193331, 4744, 271, 8, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[193605, 4754, 105, 2, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[193713, 4758, 283, 8, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[193999, 4768, 339, 9, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[194341, 4779, 217, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[194561, 4786, 415, 10, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[194979, 4798, 407, 14, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[195389, 4814, 110, 3, 30, "Text",
  CellTags->"b:1.3.11"],
Cell[195502, 4819, 101, 2, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[195606, 4823, 144, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[195753, 4828, 271, 7, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[196027, 4837, 128, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[196158, 4842, 654, 24, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[196815, 4868, 137, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[196955, 4873, 309, 8, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[197267, 4883, 135, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[197405, 4888, 404, 9, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[197812, 4899, 531, 11, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[198346, 4912, 130, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[198479, 4917, 392, 12, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[198874, 4931, 134, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[199011, 4936, 387, 9, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[199401, 4947, 423, 10, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[199827, 4959, 139, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[199969, 4964, 467, 11, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[200439, 4977, 440, 12, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[200882, 4991, 360, 11, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[201245, 5004, 145, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[201393, 5009, 126, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[201522, 5015, 116, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[201641, 5021, 136, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[201780, 5026, 129, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[201912, 5032, 125, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[202040, 5037, 311, 11, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[202354, 5050, 147, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[202504, 5055, 121, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[202628, 5061, 371, 10, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[203002, 5073, 141, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[203146, 5078, 336, 9, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[203485, 5089, 136, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[203624, 5094, 237, 9, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[203864, 5105, 135, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[204002, 5110, 481, 10, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[204486, 5122, 138, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[204627, 5127, 501, 15, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[205131, 5144, 123, 3, 27, "Text",
  CellTags->"b:1.3.11"],
Cell[205257, 5149, 128, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[205388, 5154, 278, 6, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[205669, 5162, 143, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[205815, 5167, 625, 16, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[206443, 5185, 132, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[206578, 5190, 371, 7, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[206952, 5199, 303, 7, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[207258, 5208, 293, 6, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[207554, 5216, 121, 3, 27, "Text",
  CellTags->"b:1.3.11"],
Cell[207678, 5221, 124, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[207805, 5226, 105, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[207913, 5232, 122, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[208038, 5238, 134, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[208175, 5243, 349, 10, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[208527, 5255, 138, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[208668, 5260, 118, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[208789, 5266, 127, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[208919, 5272, 135, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[209057, 5277, 359, 11, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[209419, 5290, 300, 8, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[209722, 5300, 129, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[209854, 5305, 127, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[209984, 5311, 136, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[210123, 5316, 178, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[210304, 5323, 237, 6, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[210544, 5331, 345, 7, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[210892, 5340, 137, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[211032, 5345, 233, 6, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[211268, 5353, 239, 6, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[211510, 5361, 141, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[211654, 5366, 185, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[211842, 5373, 254, 6, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[212099, 5381, 268, 6, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[212370, 5389, 340, 7, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[212713, 5398, 141, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[212857, 5403, 227, 6, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[213087, 5411, 124, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[213214, 5416, 174, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[213391, 5423, 122, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[213516, 5429, 163, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[213682, 5436, 144, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[213829, 5443, 120, 3, 30, "Text",
  CellTags->"b:1.3.11"],
Cell[213952, 5448, 165, 5, 27, "Text",
  CellTags->"b:1.3.11"],
Cell[214120, 5455, 134, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[214257, 5460, 287, 7, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[214547, 5469, 309, 7, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[214859, 5478, 133, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[214995, 5483, 203, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[215201, 5490, 203, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[215407, 5497, 304, 8, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[215714, 5507, 395, 8, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[216112, 5517, 283, 7, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[216398, 5526, 170, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[216571, 5533, 203, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[216777, 5540, 227, 5, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[217007, 5547, 301, 11, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[217311, 5560, 151, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[217465, 5565, 326, 11, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[217794, 5578, 144, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[217941, 5583, 472, 15, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[218416, 5600, 558, 19, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[218977, 5621, 135, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[219115, 5626, 154, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[219272, 5633, 135, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[219410, 5638, 234, 7, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[219647, 5647, 146, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[219796, 5652, 119, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[219918, 5658, 129, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[220050, 5663, 582, 22, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[220635, 5687, 138, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[220776, 5692, 354, 12, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[221133, 5706, 352, 12, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[221488, 5720, 365, 12, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[221856, 5734, 127, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[221986, 5739, 178, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[222167, 5746, 829, 30, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[222999, 5778, 553, 12, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[223555, 5792, 107, 3, 27, "Text",
  CellTags->"b:1.3.11"],
Cell[223665, 5797, 127, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[223795, 5802, 212, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[224010, 5809, 686, 24, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[224699, 5835, 140, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[224842, 5840, 742, 27, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[225587, 5869, 124, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[225714, 5874, 238, 8, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[225955, 5884, 247, 7, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[226205, 5893, 176, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[226384, 5900, 237, 7, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[226624, 5909, 155, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[226782, 5914, 190, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[226975, 5921, 110, 3, 27, "Text",
  CellTags->"b:1.3.11"],
Cell[227088, 5926, 129, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[227220, 5931, 465, 15, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[227688, 5948, 558, 20, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[228249, 5970, 403, 15, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[228655, 5987, 447, 15, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[229105, 6004, 378, 10, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[229486, 6016, 621, 25, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[230110, 6043, 476, 17, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[230589, 6062, 654, 22, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[231246, 6086, 130, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[231379, 6091, 824, 30, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[232206, 6123, 144, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[232353, 6128, 959, 38, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[233315, 6168, 139, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[233457, 6173, 439, 16, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[233899, 6191, 112, 3, 27, "Text",
  CellTags->"b:1.3.11"],
Cell[234014, 6196, 136, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[234153, 6201, 435, 15, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[234591, 6218, 129, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[234723, 6223, 354, 13, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[235080, 6238, 133, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[235216, 6243, 338, 11, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[235557, 6256, 148, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[235708, 6261, 552, 18, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[236263, 6281, 153, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[236419, 6286, 474, 21, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[236896, 6309, 110, 3, 27, "Text",
  CellTags->"b:1.3.11"],
Cell[237009, 6314, 130, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[237142, 6319, 423, 13, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[237568, 6334, 114, 3, 27, "Text",
  CellTags->"b:1.3.11"],
Cell[237685, 6339, 145, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[237833, 6344, 430, 15, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[238266, 6361, 125, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[238394, 6366, 565, 18, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[238962, 6386, 141, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[239106, 6391, 300, 9, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[239409, 6402, 142, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[239554, 6407, 950, 35, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[240507, 6444, 136, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[240646, 6449, 878, 32, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[241527, 6483, 150, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[241680, 6488, 358, 12, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[242041, 6502, 141, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[242185, 6507, 276, 10, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[242464, 6519, 140, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[242607, 6524, 441, 15, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[243051, 6541, 154, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[243208, 6546, 440, 15, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[243651, 6563, 130, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[243784, 6568, 232, 6, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[244019, 6576, 181, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[244203, 6583, 269, 6, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[244475, 6591, 144, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[244622, 6596, 620, 23, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[245245, 6621, 156, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[245404, 6626, 408, 15, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[245815, 6643, 143, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[245961, 6648, 342, 13, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[246306, 6663, 133, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[246442, 6668, 309, 11, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[246754, 6681, 334, 13, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[247091, 6696, 291, 8, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[247385, 6706, 332, 8, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[247720, 6716, 150, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[247873, 6721, 569, 20, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[248445, 6743, 504, 21, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[248952, 6766, 136, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[249091, 6771, 415, 17, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[249509, 6790, 516, 19, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[250028, 6811, 141, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[250172, 6816, 390, 15, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[250565, 6833, 520, 18, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[251088, 6853, 526, 19, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[251617, 6874, 153, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[251773, 6879, 756, 20, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[252532, 6901, 656, 16, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[253191, 6919, 129, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[253323, 6924, 436, 11, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[253762, 6937, 140, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[253905, 6942, 202, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[254110, 6949, 153, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[254266, 6954, 336, 8, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[254605, 6964, 128, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[254736, 6969, 579, 23, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[255318, 6994, 140, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[255461, 6999, 476, 11, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[255940, 7012, 663, 16, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[256606, 7030, 128, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[256737, 7035, 501, 14, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[257241, 7051, 454, 15, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[257698, 7068, 133, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[257834, 7073, 494, 15, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[258331, 7090, 655, 20, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[258989, 7112, 135, 3, 25, "Text",
  CellTags->"b:1.3.11"],
Cell[259127, 7117, 492, 12, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[259622, 7131, 558, 16, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[260183, 7149, 119, 3, 27, "Text",
  CellTags->"b:1.3.11"],
Cell[260305, 7154, 126, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[260434, 7160, 174, 5, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[260611, 7167, 134, 3, 30, "Text",
  CellTags->"b:1.3.11"],
Cell[260748, 7172, 118, 3, 27, "Text",
  CellTags->"b:1.3.11"],
Cell[260869, 7177, 361, 11, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[261233, 7190, 109, 3, 27, "Text",
  CellTags->"b:1.3.11"],
Cell[261345, 7195, 291, 8, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[261639, 7205, 381, 9, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[262023, 7216, 424, 12, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[262450, 7230, 280, 8, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[262733, 7240, 109, 3, 30, "Text",
  CellTags->"b:1.3.11"],
Cell[262845, 7245, 114, 3, 27, "Text",
  CellTags->"b:1.3.11"],
Cell[262962, 7250, 112, 4, 50, "Text",
  CellTags->"b:1.3.11"],
Cell[263077, 7256, 527, 14, 67, "Text",
  CellTags->"b:1.3.11"],
Cell[263607, 7272, 139, 4, 50, "Text",
  CellTags->"b:1.3.11"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[263795, 7282, 27, 0, 65, "Section"],

Cell[CellGroupData[{
Cell[263847, 7286, 51, 1, 39, "Subsection",
  CellTags->"b:1.4.1"],
Cell[263901, 7289, 964, 23, 59, "Text",
  CellTags->"b:1.4.1"],
Cell[264868, 7314, 600, 13, 42, "Text",
  CellTags->"b:1.4.1"],
Cell[265471, 7329, 307, 8, 25, "Text",
  CellTags->"b:1.4.1"],

Cell[CellGroupData[{
Cell[265803, 7341, 56, 1, 25, "SubsubsectionIcon",
  CellTags->"b:1.4.1"],
Cell[265862, 7344, 7904, 151, 2029, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.1"]
}, Closed]],

Cell[CellGroupData[{
Cell[273803, 7500, 60, 1, 21, "SubsubsectionIcon",
  CellTags->"b:1.4.1"],
Cell[273866, 7503, 94, 2, 29, "Input",
  CellTags->"b:1.4.1"],
Cell[273963, 7507, 99, 2, 29, "Input",
  CellTags->"b:1.4.1"],
Cell[274065, 7511, 125, 3, 29, "Input",
  CellTags->"b:1.4.1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[274239, 7520, 51, 1, 39, "Subsection",
  CellTags->"b:1.4.2"],
Cell[274293, 7523, 793, 20, 42, "Text",
  CellTags->"b:1.4.2"],
Cell[275089, 7545, 282, 6, 25, "Text",
  CellTags->"b:1.4.2"],
Cell[275374, 7553, 307, 8, 25, "Text",
  CellTags->"b:1.4.2"],

Cell[CellGroupData[{
Cell[275706, 7565, 84, 2, 25, "SubsubsectionIcon",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[275793, 7569, 99, 3, 30, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[275895, 7574, 152, 4, 50, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[276050, 7580, 311, 7, 110, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[276364, 7589, 195, 4, 50, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[276562, 7595, 128, 3, 30, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[276693, 7600, 150, 4, 50, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[276846, 7606, 1166, 22, 410, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[278015, 7630, 194, 5, 50, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[278212, 7637, 500, 9, 150, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[278715, 7648, 637, 13, 250, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[279355, 7663, 305, 6, 110, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[279663, 7671, 136, 3, 30, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[279802, 7676, 391, 8, 150, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"],
Cell[280196, 7686, 260, 7, 110, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.2"]
}, Closed]],

Cell[CellGroupData[{
Cell[280493, 7698, 59, 1, 21, "SubsubsectionIcon",
  CellTags->"b:1.4.2"],
Cell[280555, 7701, 118, 3, 25, "Text",
  CellTags->"b:1.4.2"],

Cell[CellGroupData[{
Cell[280698, 7708, 87, 2, 29, "Input",
  CellTags->"b:1.4.2"],
Cell[280788, 7712, 566, 18, 49, "Print",
  CellTags->"b:1.4.2"],
Cell[281357, 7732, 655, 18, 49, "Print",
  CellTags->"b:1.4.2"],
Cell[282015, 7752, 596, 18, 49, "Print",
  CellTags->"b:1.4.2"],
Cell[282614, 7772, 573, 18, 49, "Print",
  CellTags->"b:1.4.2"],
Cell[283190, 7792, 657, 18, 49, "Print",
  CellTags->"b:1.4.2"],
Cell[283850, 7812, 657, 18, 49, "Print",
  CellTags->"b:1.4.2"],
Cell[284510, 7832, 608, 18, 49, "Print",
  CellTags->"b:1.4.2"],
Cell[285121, 7852, 598, 18, 49, "Print",
  CellTags->"b:1.4.2"],
Cell[285722, 7872, 576, 18, 49, "Print",
  CellTags->"b:1.4.2"],
Cell[286301, 7892, 653, 18, 49, "Print",
  CellTags->"b:1.4.2"]
}, Closed]],
Cell[286969, 7913, 139, 4, 21, "Text",
  CellTags->"b:1.4.2"],

Cell[CellGroupData[{
Cell[287133, 7921, 113, 2, 29, "Input",
  CellTags->"b:1.4.2"],
Cell[287249, 7925, 678, 18, 49, "Print",
  CellTags->"b:1.4.2"],
Cell[287930, 7945, 639, 18, 49, "Print",
  CellTags->"b:1.4.2"]
}, Closed]],
Cell[288584, 7966, 137, 4, 21, "Text",
  CellTags->"b:1.4.2"],

Cell[CellGroupData[{
Cell[288746, 7974, 140, 3, 29, "Input",
  CellTags->"b:1.4.2"],
Cell[288889, 7979, 420, 14, 33, "Print",
  CellTags->"b:1.4.2"],
Cell[289312, 7995, 447, 13, 50, "Print",
  CellTags->"b:1.4.2"],
Cell[289762, 8010, 454, 13, 50, "Print",
  CellTags->"b:1.4.2"],
Cell[290219, 8025, 471, 15, 33, "Print",
  CellTags->"b:1.4.2"],
Cell[290693, 8042, 473, 15, 33, "Print",
  CellTags->"b:1.4.2"],
Cell[291169, 8059, 398, 12, 33, "Print",
  CellTags->"b:1.4.2"],
Cell[291570, 8073, 385, 12, 33, "Print",
  CellTags->"b:1.4.2"],
Cell[291958, 8087, 436, 13, 33, "Print",
  CellTags->"b:1.4.2"],
Cell[292397, 8102, 419, 14, 33, "Print",
  CellTags->"b:1.4.2"],
Cell[292819, 8118, 422, 14, 33, "Print",
  CellTags->"b:1.4.2"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[293302, 8139, 59, 1, 39, "Subsection",
  CellTags->"b:1.4.3"],
Cell[293364, 8142, 928, 27, 42, "Text",
  CellTags->"b:1.4.3"],
Cell[294295, 8171, 427, 11, 25, "Text",
  CellTags->"b:1.4.3"],
Cell[294725, 8184, 307, 8, 25, "Text",
  CellTags->"b:1.4.3"],

Cell[CellGroupData[{
Cell[295057, 8196, 84, 2, 25, "SubsubsectionIcon",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[295144, 8200, 109, 3, 29, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[295256, 8205, 229, 5, 29, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[295488, 8212, 314, 7, 109, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[295805, 8221, 195, 4, 29, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[296003, 8227, 154, 4, 29, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[296160, 8233, 994, 18, 209, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[297157, 8253, 194, 5, 29, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[297354, 8260, 500, 9, 149, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[297857, 8271, 718, 14, 209, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[298578, 8287, 365, 8, 129, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[298946, 8297, 305, 6, 109, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[299254, 8305, 136, 3, 29, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[299393, 8310, 391, 8, 149, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"],
Cell[299787, 8320, 260, 7, 29, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.3"]
}, Closed]],

Cell[CellGroupData[{
Cell[300084, 8332, 59, 1, 21, "SubsubsectionIcon",
  CellTags->"b:1.4.3"],
Cell[300146, 8335, 118, 3, 25, "Text",
  CellTags->"b:1.4.3"],

Cell[CellGroupData[{
Cell[300289, 8342, 95, 2, 29, "Input",
  CellTags->"b:1.4.3"],
Cell[300387, 8346, 774, 22, 49, "Print",
  CellTags->"b:1.4.3"],
Cell[301164, 8370, 734, 21, 49, "Print",
  CellTags->"b:1.4.3"],
Cell[301901, 8393, 782, 21, 49, "Print",
  CellTags->"b:1.4.3"],
Cell[302686, 8416, 807, 26, 49, "Print",
  CellTags->"b:1.4.3"],
Cell[303496, 8444, 860, 26, 49, "Print",
  CellTags->"b:1.4.3"],
Cell[304359, 8472, 726, 21, 49, "Print",
  CellTags->"b:1.4.3"],
Cell[305088, 8495, 885, 28, 49, "Print",
  CellTags->"b:1.4.3"],
Cell[305976, 8525, 834, 24, 49, "Print",
  CellTags->"b:1.4.3"],
Cell[306813, 8551, 898, 29, 49, "Print",
  CellTags->"b:1.4.3"],
Cell[307714, 8582, 872, 27, 49, "Print",
  CellTags->"b:1.4.3"]
}, Closed]],
Cell[308601, 8612, 192, 6, 21, "Text",
  CellTags->"b:1.4.3"],

Cell[CellGroupData[{
Cell[308818, 8622, 134, 3, 29, "Input",
  CellTags->"b:1.4.3"],
Cell[308955, 8627, 812, 26, 49, "Print",
  CellTags->"b:1.4.3"],
Cell[309770, 8655, 925, 29, 49, "Print",
  CellTags->"b:1.4.3"]
}, Closed]],
Cell[310710, 8687, 68, 1, 21, "Text",
  CellTags->"b:1.4.3"],

Cell[CellGroupData[{
Cell[310803, 8692, 117, 3, 29, "Input",
  CellTags->"b:1.4.3"],
Cell[310923, 8697, 551, 17, 33, "Print",
  CellTags->"b:1.4.3"],
Cell[311477, 8716, 561, 17, 33, "Print",
  CellTags->"b:1.4.3"],
Cell[312041, 8735, 475, 15, 33, "Print",
  CellTags->"b:1.4.3"],
Cell[312519, 8752, 526, 16, 33, "Print",
  CellTags->"b:1.4.3"],
Cell[313048, 8770, 598, 19, 33, "Print",
  CellTags->"b:1.4.3"],
Cell[313649, 8791, 561, 18, 33, "Print",
  CellTags->"b:1.4.3"],
Cell[314213, 8811, 614, 20, 33, "Print",
  CellTags->"b:1.4.3"],
Cell[314830, 8833, 620, 19, 33, "Print",
  CellTags->"b:1.4.3"],
Cell[315453, 8854, 618, 20, 33, "Print",
  CellTags->"b:1.4.3"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[316132, 8881, 53, 1, 39, "Subsection",
  CellTags->"b:1.4.4"],
Cell[316188, 8884, 682, 15, 42, "Text",
  CellTags->"b:1.4.4"],
Cell[316873, 8901, 661, 12, 59, "Text",
  CellTags->"b:1.4.4"],
Cell[317537, 8915, 307, 8, 25, "Text",
  CellTags->"b:1.4.4"],

Cell[CellGroupData[{
Cell[317869, 8927, 56, 1, 25, "SubsubsectionIcon",
  CellTags->"b:1.4.4"],
Cell[317928, 8930, 3661, 70, 970, "Input",
  InitializationCell->True,
  CellTags->"b:1.4.4"]
}, Closed]],

Cell[CellGroupData[{
Cell[321626, 9005, 59, 1, 21, "SubsubsectionIcon",
  CellTags->"b:1.4.4"],
Cell[321688, 9008, 77, 2, 29, "Input",
  CellTags->"b:1.4.4"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[321814, 9016, 57, 1, 39, "Subsection",
  CellTags->"b:1.4.5"],
Cell[321874, 9019, 1030, 29, 42, "Text",
  CellTags->"b:1.4.5"],
Cell[322907, 9050, 997, 15, 76, "Text",
  CellTags->"b:1.4.5"],
Cell[323907, 9067, 407, 12, 25, "Text",
  CellTags->"b:1.4.5"],
Cell[324317, 9081, 207, 6, 25, "Text",
  CellTags->"b:1.4.5"],
Cell[324527, 9089, 168, 4, 49, "Input",
  CellTags->"b:1.4.5"]
}, Open  ]],

Cell[CellGroupData[{
Cell[324732, 9098, 67, 1, 39, "Subsection",
  CellTags->"b:1.4.6"],
Cell[324802, 9101, 436, 13, 42, "Text",
  CellTags->"b:1.4.6"],
Cell[325241, 9116, 206, 6, 25, "Text",
  CellTags->"b:1.4.6"],

Cell[CellGroupData[{
Cell[325472, 9126, 176, 4, 49, "Input",
  CellTags->"b:1.4.6"],
Cell[325651, 9132, 279, 7, 27, "Output",
  CellTags->"b:1.4.6"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

