(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10813,        243]*)
(*NotebookOutlinePosition[     11518,        267]*)
(*  CellTagsIndexPosition[     11474,        263]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Amazon Web Services", "Title"],

Cell["\<\
This example demonstrates the Amazon Web Services.  The Amazon Web Services \
are good demenstrations of using Web Services to retrieve data.  This example \
searches the Amazon databases for books written by certain authors, published \
by a certain manufacturer, or containing a certain keyword.  The example code \
then places the results in a new notebook.  The example has one option.  \
Setting the ShowPictures option to True will force the code to retrieve and \
display the cover image of the book.\
\>", "Text"],

Cell["\<\
To try this example, evaluate all the initialization cells (you can do this \
with the menu command Kernel/Evaluation/Evaluate Initialization). Then go to \
the Example section.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Code", "Section"],

Cell[BoxData[{
    \(\(\(BeginPackage["\<WebServices`Examples`Amazon`\>", \
{"\<WebServices`\>", "\<JLink`\>"}];\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(AuthorSearch;\)\), "\n", 
    \(\(ManufacturerSearch;\)\), "\[IndentingNewLine]", 
    \(\(KeywordSearch;\)\), "\[IndentingNewLine]", 
    \(\(\(ShowPictures;\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(\(Begin["\<`Private`\>"];\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(InstallService["\<http://soap.amazon.com/schemas3/AmazonWebServices.\
wsdl\>"];\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(\(Options[
          AuthorSearch] = {ShowPictures \[Rule] 
            False};\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(\(AuthorSearch[keyword_String, pages_Integer, options___?OptionQ] := 
      Module[{result}, 
        result = 
          AuthorSearchRequest[{"\<author\>" \[Rule] 
                keyword, "\<page\>" \[Rule] 
                pages, "\<mode\>" \[Rule] "\<books\>", "\<tag\>" \[Rule] \
"\<webservices-20\>", "\<type\>" \[Rule] "\<lite\>", "\<devtag\>" \[Rule] \
"\<D3VZJS46JD5U9D\>", "\<version\>" \[Rule] "\<1.0\>"}]; \
\[IndentingNewLine]If[result === $Failed, 
          Return[$Failed]]; \[IndentingNewLine]result = "\<Details\>" /. 
            result; \[IndentingNewLine]NotebookPut[\[IndentingNewLine]\
resultNotebook["\<Amazon Author Search\>", keyword, result, 
            options]]\[IndentingNewLine]]\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(ManufacturerSearch[keyword_String, pages_Integer, 
          options___?OptionQ] := 
        Module[{result}, 
          result = 
            ManufacturerSearchRequest[{"\<manufacturer\>" \[Rule] 
                  keyword, "\<page\>" \[Rule] 
                  pages, "\<mode\>" \[Rule] "\<books\>", "\<tag\>" \[Rule] \
"\<webservices-20\>", "\<type\>" \[Rule] "\<lite\>", "\<devtag\>" \[Rule] \
"\<D3VZJS46JD5U9D\>", "\<version\>" \[Rule] "\<1.0\>"}]; \
\[IndentingNewLine]If[result === $Failed, 
            Return[$Failed]]; \[IndentingNewLine]result = "\<Details\>" /. 
              result; \[IndentingNewLine]NotebookPut[\[IndentingNewLine]\
resultNotebook["\<Amazon Manufacturer Search\>", keyword, result, 
              options]]\[IndentingNewLine]];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(KeywordSearch[keyword_String, pages_Integer, options___?OptionQ] := 
        Module[{result}, 
          result = 
            KeywordSearchRequest[{"\<keyword\>" \[Rule] 
                  keyword, "\<page\>" \[Rule] 
                  pages, "\<mode\>" \[Rule] "\<books\>", "\<tag\>" \[Rule] \
"\<webservices-20\>", "\<type\>" \[Rule] "\<lite\>", "\<devtag\>" \[Rule] \
"\<D3VZJS46JD5U9D\>", "\<version\>" \[Rule] "\<1.0\>"}]; \
\[IndentingNewLine]If[result === $Failed, 
            Return[$Failed]]; \[IndentingNewLine]result = "\<Details\>" /. 
              result; \[IndentingNewLine]NotebookPut[\[IndentingNewLine]\
resultNotebook["\<Amazon Keyword Search\>", keyword, result, 
              options]]\[IndentingNewLine]];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(resultNotebook[title_String, \ keyword_String, result_List, 
        options___?OptionQ] := \[IndentingNewLine]Notebook[
        Flatten[{\[IndentingNewLine]Cell[
              title, "\<Subtitle\>"], \[IndentingNewLine]Cell["\<Results for: \
\>" <> keyword, "\<Section\>"], \[IndentingNewLine]\(resultCells[#, 
                  options] &\)\  /@ \ result\[IndentingNewLine]}], 
        CellGrouping \[Rule] Manual, 
        WindowTitle \[Rule] \((title <> "\<: \>" <> 
              keyword)\)]\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(resultCells[d_List, options___?OptionQ] := 
      Module[{url, asin, productName, authorNames, releaseDate, manufacturer, 
          imageUrlMedium, listPrice, ourPrice, usedPrice, showPictures, 
          cellList}, {showPictures} = \({ShowPictures} /. 
              Flatten[{options}]\) /. 
            Options[AuthorSearch]; \[IndentingNewLine]url = "\<Url\>" /. 
            d; \[IndentingNewLine]asin = "\<Asin\>" /. 
            d; \[IndentingNewLine]productName = "\<ProductName\>" /. 
            d; \[IndentingNewLine]authorNames = "\<Authors\>" /. 
            d; \[IndentingNewLine]releaseDate = "\<ReleaseDate\>" /. 
            d; \[IndentingNewLine]manufacturer = "\<Manufacturer\>" /. 
            d; \[IndentingNewLine]imageUrlMedium = "\<ImageUrlMedium\>" /. 
            d; \[IndentingNewLine]listPrice = "\<ListPrice\>" /. 
            d; \[IndentingNewLine]ourPrice = "\<OurPrice\>" /. 
            d; \[IndentingNewLine]usedPrice = "\<UsedPrice\>" /. 
            d; \[IndentingNewLine]authorNames = 
          ToString[authorNames]; \[IndentingNewLine]authorNames = 
          StringDrop[authorNames, 1]; \[IndentingNewLine]authorNames = 
          StringDrop[authorNames, \(-1\)]; \[IndentingNewLine]If[
          TrueQ[showPictures], 
          imageUrlMedium = 
            getImageData[imageUrlMedium]; \[IndentingNewLine]If[
            StringMatchQ[imageUrlMedium, "\<GIF*\>"], 
            imageCell = 
              ToExpression[
                ExportString[
                  ImportString[imageUrlMedium, "\<GIF\>"], "\<MGFCell\>"]], 
            imageCell = 
              ToExpression[
                ExportString[
                  ImportString[
                    imageUrlMedium, "\<JPEG\>"], "\<MGFCell\>"]]];]; \
\[IndentingNewLine]{Cell[
            CellGroupData[
              Flatten[{\[IndentingNewLine]Cell[
                    TextData[{\[IndentingNewLine]ButtonBox[
                          StyleBox[productName, FontWeight -> "\<Bold\>"], 
                          ButtonData \[Rule] {URL[url], None}, 
                          ButtonStyle \[Rule] "\<Hyperlink\>"], "\< by \>", 
                        StyleBox[authorNames, 
                          FontSlant \[Rule] "\<Italic\>"]}], "\<Text\>", 
                    ShowGroupOpenCloseIcon \[Rule] True], 
                  If[TrueQ[showPictures], 
                    Cell[TextData[imageCell], "\<Text\>"], {}], 
                  Cell[TextData[{StyleBox["\<Release Date: \>", 
                          FontWeight \[Rule] "\<Bold\>"], 
                        releaseDate, "\<\n\>", \
\[IndentingNewLine]StyleBox["\<ASIN: \>", FontWeight \[Rule] "\<Bold\>"], 
                        asin, "\<\n\>", \[IndentingNewLine]StyleBox["\<List \
Price: \>", FontWeight \[Rule] "\<Bold\>"], 
                        listPrice, "\<\n\>", \
\[IndentingNewLine]StyleBox["\<Our Price: \>", 
                          FontWeight \[Rule] "\<Bold\>"], 
                        ourPrice}], "\<Text\>"]}], 
              Closed]]}]\n\), "\[IndentingNewLine]", 
    \(getImageData[url_String] := 
      JavaBlock[
        Module[{u, connection, stream, input = "\<\>", numRead = 0, 
            bytesRead = 0, buf}, 
          u = JavaNew["\<java.net.URL\>", 
              url]; \[IndentingNewLine]connection = 
            u@openConnection[]; \[IndentingNewLine]stream = 
            connection@getInputStream[]; \[IndentingNewLine]If[
            stream \[Equal] $Failed, 
            Return[URLError["\<Failed to open URL stream\>"]]]; \
\[IndentingNewLine]buf = 
            JavaNew["\<[B\>", 
              5000]; \[IndentingNewLine]While[\((numRead = 
                  stream@read[buf])\) > 0, 
            AddTo[bytesRead, numRead]; \[IndentingNewLine]input = 
              StringJoin[input, 
                ToString[
                  FromCharacterCode[\(If[# < 0, # + 256, #] &\) /@ 
                      Take[JavaObjectToExpression[buf], 
                        numRead]]]];]; \[IndentingNewLine]stream@
            close[]; \[IndentingNewLine]input]]\n\), "\[IndentingNewLine]", 
    \(\(End[];\)\), "\n", 
    \(\(EndPackage[];\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", "Section"],

Cell[BoxData[
    \(AuthorSearch["\<Stephen Wolfram\>", 1]\)], "Input"],

Cell[BoxData[
    \(ManufacturerSearch["\<Addison-Wesley\>", 1]\)], "Input"],

Cell[BoxData[
    \(KeywordSearch["\<Mathematica\>", 1, 
      ShowPictures \[Rule] True]\)], "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
AutoGeneratedPackage->None,
WindowSize->{520, 710},
WindowMargins->{{4, Automatic}, {Automatic, 4}},
StyleDefinitions -> "Default.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 36, 0, 115, "Title"],
Cell[1815, 55, 531, 8, 128, "Text"],
Cell[2349, 65, 201, 4, 52, "Text"],

Cell[CellGroupData[{
Cell[2575, 73, 23, 0, 59, "Section"],
Cell[2601, 75, 7862, 149, 2347, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[10500, 229, 27, 0, 39, "Section"],
Cell[10530, 231, 71, 1, 30, "Input"],
Cell[10604, 234, 76, 1, 30, "Input"],
Cell[10683, 237, 102, 2, 30, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

