(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18898,        598]*)
(*NotebookOutlinePosition[     19570,        621]*)
(*  CellTagsIndexPosition[     19526,        617]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Google Web Service", "Title"],

Cell["\<\
This example demonstrates the Google web service.  The Google web service is \
good demenstration of using Web Services to retrieve data.  This example \
searches the Google databases for web pages containing a certain keyword.  \
The example code then places the results in the notebook.\
\>", "Text"],

Cell["\<\
To try this example, evaluate all the initialization cells (you can do this \
with the menu command Kernel/Evaluation/Evaluate Initialization). Then go to \
the Example section.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Code", "Section",
  InitializationCell->True],

Cell[BoxData[
    \(<< WebServices`\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(InstallService["\<http://api.google.com/GoogleSearch.wsdl\>"];\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Options[
          GoogleSearch] = {\[IndentingNewLine]MaxHits\  \[Rule] 
            10, \[IndentingNewLine]Filter \[Rule] 
            True, \[IndentingNewLine]IncludeURL\  \[Rule] \ 
            True\[IndentingNewLine]};\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\($backgrounds = {RGBColor[0.960784, 0.878431, 0.666667], 
          RGBColor[0.964706, 0.929412, 0.839216]};\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(GoogleSearch::err = "\<Search Error.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(GoogleSearch::nomatch = "\<No page containing `1` found.\>";\)\)], \
"Input",
  InitializationCell->True],

Cell[BoxData[
    \(GoogleSearch[str_String, 
        opts___] := \[IndentingNewLine]Module[{lis, results, matches, 
          filterQ, \ 
          urlQ}, \[IndentingNewLine]{matches, filterQ, 
            urlQ} = {MaxHits, Filter, IncludeURL}\  /. \ 
            Flatten[{opts, 
                Options\ @\ 
                  GoogleSearch}]; \
\[IndentingNewLine]\[IndentingNewLine]results = 
          GoogleSearchService`GoogleSearchPort`doGoogleSearch["\<\
3HB82PdQFHITKPmbmm5G/9aTfVHx/m95\>", str, \ 0, matches, filterQ, "\<\>", 
            True, "\<\>", "\<\>", "\<\>"]; \[IndentingNewLine]If[
          results === $Failed, \[IndentingNewLine]Message[
            GoogleSearch::err], \[IndentingNewLine]\(lis\  = \ \
"\<resultElements\>" /. results;\)\[IndentingNewLine]]; \[IndentingNewLine]If[
          lis === {} || lis === Null || 
            lis\  === \ "\<resultElements\>", \[IndentingNewLine]Message[
            GoogleSearch::nomatch, \ str], \[IndentingNewLine]$bg = 
            0; \[IndentingNewLine]Scan[CellPrint, 
            searchResultCells[lis, urlQ]]]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(searchResultCells[lis_, 
        urlQ_] := \(cellTemplate[formatSingleResult[#, urlQ]] &\)\  /@ \ 
        lis\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(cellTemplate[lis_] := \[IndentingNewLine]Cell[
        TextData\ @\ \(Flatten\ @\ {lis}\), "\<Print\>", \
\[IndentingNewLine]FontFamily -> "\<Times\>", \[IndentingNewLine]CellMargins \
\[Rule] {{Inherited, Inherited}, {0, 
              0}}, \[IndentingNewLine]CellDingbat \[Rule] 
          ToString[\(++$bg\)], \[IndentingNewLine]Background \[Rule] 
          Part[$backgrounds, Mod[$bg, 2, 1]]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(formatSingleResult[opts_, 
        urlQ_] := \[IndentingNewLine]Block[{u, 
          t}, \[IndentingNewLine]{u, t} = {"\<URL\>", "\<title\>"}\  /. \ 
            opts; \[IndentingNewLine]{\[IndentingNewLine]"\< \>", \
\[IndentingNewLine]webLink[
            StyleBox[formatTitle\ @\ t, FontWeight -> "\<Bold\>"], 
            u], \[IndentingNewLine]If[
            urlQ, {"\<\n\>", 
              webLink[StyleBox[u, "\<SmallText\>", 
                  FontColor \[Rule] GrayLevel[0.4]], 
                u]}, {}]\[IndentingNewLine]}\[IndentingNewLine]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(webLink[content_, url_] := \[IndentingNewLine]ButtonBox[
        content, \[IndentingNewLine]ButtonData \[RuleDelayed] {URL[url], 
            None}, \[IndentingNewLine]ButtonStyle -> "\<Hyperlink\>"\
\[IndentingNewLine]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(formatTitle[str_String] := translateAllEntities[str]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(decodeString[str_] := 
      StringReplace[
        str, {\[IndentingNewLine]"\<&lt;\>" -> "\<<\>", \
\[IndentingNewLine]"\<&gt;\>" -> "\<>\>", \[IndentingNewLine]"\<&amp;\>" -> "\
\<&\>", \[IndentingNewLine]"\<&quot;\>" -> "\<\"\>", \[IndentingNewLine]"\<\\\
\>" -> "\<\\[Backslash]\>"\[IndentingNewLine]}]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(translateAllEntities[str_] := 
      StringReplace[str, 
          Reverse\  /@ \ 
            System`Convert`MLStringDataDump`$UnicodeToHTML4Entities] // 
        decodeString\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell["\<\
Find the top 10 wolfram.com web pages containing all the given strings.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GoogleSearch["\<Mathematica\>"]\)], "Input"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["Wolfram Research, Inc.",
    ButtonData:>{
      URL[ "http://www.wolfram.com/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.wolfram.com/",
    ButtonData:>{
      URL[ "http://www.wolfram.com/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"1",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Mathematica</b>: The Way the World Calculates",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/mathematica/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.wolfram.com/products/mathematica/",
    ButtonData:>{
      URL[ "http://www.wolfram.com/products/mathematica/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"2",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Mathematica</b> Home Page",
    ButtonData:>{
      URL[ "http://www.mathematica-mpr.com/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.mathematica-mpr.com/",
    ButtonData:>{
      URL[ "http://www.mathematica-mpr.com/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"3",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["MathSource has moved",
    ButtonData:>{
      URL[ "http://www.mathsource.com/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.mathsource.com/",
    ButtonData:>{
      URL[ "http://www.mathsource.com/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"4",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["SpringerLink - Publication",
    ButtonData:>{
      URL[ "http://link.springer.de/link/service/journals/00229/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://link.springer.de/link/service/journals/00229/",
    ButtonData:>{
      URL[ "http://link.springer.de/link/service/journals/00229/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"5",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["SpringerLink - Publication",
    ButtonData:>{
      URL[ "http://link.springer.de/link/service/journals/10114/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://link.springer.de/link/service/journals/10114/",
    ButtonData:>{
      URL[ "http://link.springer.de/link/service/journals/10114/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"6",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["DOCUMENTA <b>MATHEMATICA</b>",
    ButtonData:>{
      URL[ "http://www.math.uiuc.edu/documenta/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.math.uiuc.edu/documenta/",
    ButtonData:>{
      URL[ "http://www.math.uiuc.edu/documenta/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"7",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["Calculus and <b>Mathematica</b> at UIUC",
    ButtonData:>{
      URL[ "http://www-cm.math.uiuc.edu/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www-cm.math.uiuc.edu/",
    ButtonData:>{
      URL[ "http://www-cm.math.uiuc.edu/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"8",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["The Integrator",
    ButtonData:>{
      URL[ "http://integrals.wolfram.com/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://integrals.wolfram.com/",
    ButtonData:>{
      URL[ "http://integrals.wolfram.com/"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"9",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["ACTA <b>MATHEMATICA</b> UNIVERSITATIS COMENIANAE",
    ButtonData:>{
      URL[ "http://www.emis.de/journals/AMUC/_amuc.html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.emis.de/journals/AMUC/_amuc.html",
    ButtonData:>{
      URL[ "http://www.emis.de/journals/AMUC/_amuc.html"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"10",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216]]
}, Closed]],

Cell["\<\
Search for pages containing all of the given strings, and return only the top \
two results.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GoogleSearch["\<Hermite polynomial\>", MaxHits \[Rule] 2]\)], "Input"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Hermite</b> <b>Polynomial</b> -- from MathWorld",
    ButtonData:>{
      URL[ "http://mathworld.wolfram.com/HermitePolynomial.html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://mathworld.wolfram.com/HermitePolynomial.html",
    ButtonData:>{
      URL[ "http://mathworld.wolfram.com/HermitePolynomial.html"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"1",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Hermite</b> <b>Polynomial</b>",
    ButtonData:>{
      URL[ "http://www.efunda.com/math/Hermite/index.cfm"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  "\n",
  StyleBox[ButtonBox["http://www.efunda.com/math/Hermite/index.cfm",
    ButtonData:>{
      URL[ "http://www.efunda.com/math/Hermite/index.cfm"], None},
    ButtonStyle->"Hyperlink"], "SmallText",
    FontColor->GrayLevel[0.4]]
}], "Print",
  CellDingbat->"2",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216]]
}, Closed]],

Cell["\<\
Display less verbose results and do not filter near-duplicate content and \
host crowding.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GoogleSearch["\<Chebyshev\>", IncludeURL \[Rule] False, 
      Filter \[Rule] False]\)], "Input"],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b>",
    ButtonData:>{
      URL[ 
      "http://www-gap.dcs.st-and.ac.uk/~history/Mathematicians/Chebyshev.\
html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"1",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["One tailed version of <b>Chebyshev&#39;s</b> inequality \
- by Henry Bottomley",
    ButtonData:>{
      URL[ "http://www.btinternet.com/~se16/hgb/cheb.htm"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"2",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b>, Pafnuty Lvovich -- Encyclop\[AE]dia \
Britannica Online <b>...</b>",
    ButtonData:>{
      URL[ "http://www.britannica.com/eb/article?eu=23095"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"3",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b> Polynomial of the First Kind -- from \
MathWorld",
    ButtonData:>{
      URL[ 
      "http://mathworld.wolfram.com/ChebyshevPolynomialoftheFirstKind.html"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"4",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b> Polynomial of the Second Kind -- from \
MathWorld",
    ButtonData:>{
      URL[ 
      "http://mathworld.wolfram.com/ChebyshevPolynomialoftheSecondKind.html"],
       None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"5",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b> Polynomial",
    ButtonData:>{
      URL[ "http://www.efunda.com/math/Chebyshev/index.cfm"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"6",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b>",
    ButtonData:>{
      URL[ "http://www.mathsoc.spb.ru/pantheon/chebyshe/"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"7",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["Butterworth / Bessel / <b>Chebyshev</b> Filters",
    ButtonData:>{
      URL[ "http://www-users.cs.york.ac.uk/~fisher/mkfilter/trad.html"], 
      None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"8",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b>",
    ButtonData:>{
      URL[ 
      "http://www.nag.com/numeric/FL/manual/html/indexes/kwic/chebyshev.html"]\
, None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"9",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.960784, 0.878431, 0.666667]],

Cell[TextData[{
  " ",
  StyleBox[ButtonBox["<b>Chebyshev</b>",
    ButtonData:>{
      URL[ 
      "http://www.nag.co.uk/numeric/FL/manual/html/indexes/kwic/chebyshev.\
html"], None},
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"]
}], "Print",
  CellDingbat->"10",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontFamily->"Times",
  Background->RGBColor[0.964706, 0.929412, 0.839216]]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
AutoGeneratedPackage->None,
WindowSize->{499, 794},
WindowMargins->{{86, Automatic}, {Automatic, 1}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 35, 0, 95, "Title"],
Cell[1814, 55, 312, 5, 90, "Text"],
Cell[2129, 62, 201, 4, 71, "Text"],

Cell[CellGroupData[{
Cell[2355, 70, 51, 1, 73, "Section",
  InitializationCell->True],
Cell[2409, 73, 76, 2, 30, "Input",
  InitializationCell->True],
Cell[2488, 77, 129, 3, 50, "Input",
  InitializationCell->True],
Cell[2620, 82, 288, 6, 110, "Input",
  InitializationCell->True],
Cell[2911, 90, 172, 3, 50, "Input",
  InitializationCell->True],
Cell[3086, 95, 105, 2, 30, "Input",
  InitializationCell->True],
Cell[3194, 99, 127, 3, 50, "Input",
  InitializationCell->True],
Cell[3324, 104, 1143, 21, 410, "Input",
  InitializationCell->True],
Cell[4470, 127, 171, 4, 50, "Input",
  InitializationCell->True],
Cell[4644, 133, 477, 8, 150, "Input",
  InitializationCell->True],
Cell[5124, 143, 614, 12, 250, "Input",
  InitializationCell->True],
Cell[5741, 157, 282, 5, 110, "Input",
  InitializationCell->True],
Cell[6026, 164, 113, 2, 30, "Input",
  InitializationCell->True],
Cell[6142, 168, 368, 7, 150, "Input",
  InitializationCell->True],
Cell[6513, 177, 237, 6, 110, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[6787, 188, 26, 0, 43, "Section"],
Cell[6816, 190, 95, 2, 33, "Text"],

Cell[CellGroupData[{
Cell[6936, 196, 64, 1, 30, "Input"],
Cell[7003, 199, 543, 17, 49, "Print"],
Cell[7549, 218, 632, 17, 49, "Print"],
Cell[8184, 237, 573, 17, 49, "Print"],
Cell[8760, 256, 550, 17, 49, "Print"],
Cell[9313, 275, 634, 17, 49, "Print"],
Cell[9950, 294, 634, 17, 49, "Print"],
Cell[10587, 313, 585, 17, 49, "Print"],
Cell[11175, 332, 575, 17, 49, "Print"],
Cell[11753, 351, 553, 17, 49, "Print"],
Cell[12309, 370, 630, 17, 49, "Print"]
}, Closed]],
Cell[12954, 390, 116, 3, 49, "Text"],

Cell[CellGroupData[{
Cell[13095, 397, 90, 1, 30, "Input"],
Cell[13188, 400, 655, 17, 49, "Print"],
Cell[13846, 419, 616, 17, 49, "Print"]
}, Closed]],
Cell[14477, 439, 114, 3, 49, "Text"],

Cell[CellGroupData[{
Cell[14616, 446, 117, 2, 50, "Input"],
Cell[14736, 450, 397, 13, 33, "Print"],
Cell[15136, 465, 424, 12, 50, "Print"],
Cell[15563, 479, 431, 12, 50, "Print"],
Cell[15997, 493, 448, 14, 33, "Print"],
Cell[16448, 509, 450, 14, 33, "Print"],
Cell[16901, 525, 375, 11, 33, "Print"],
Cell[17279, 538, 362, 11, 33, "Print"],
Cell[17644, 551, 413, 12, 33, "Print"],
Cell[18060, 565, 396, 13, 33, "Print"],
Cell[18459, 580, 399, 13, 33, "Print"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

