(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3645,        104]*)
(*NotebookOutlinePosition[      4319,        127]*)
(*  CellTagsIndexPosition[      4275,        123]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["TerraService Java UI", "Title"],

Cell["\<\
This example demonstrates the TerraService from Microsoft using a Java UI.  \
Microsoft TerraServer Web Service is a programmable interface to the popular \
Microsoft TerraServer on-line database of high resolution USGS aerial imagery \
(DOQs) and scanned USGS topographical maps (DRGs).  The user can specify the \
place to display by using the \"Place Search\" field.  The place is expected \
to be a single string containing the city or well known place name, state \
name, and country name separated by comma characters, e.g. \"San Franicisco, \
CA, USA\". Any of the three values may be missing.  The navigation panel can \
be used to move in a particular direction.  The \"Latitude\" and \
\"Longitude\" fields can be used to specify a place at a particular latitude \
and longitude.  The user can zoom-in and zoom-out using the \"Scale\" drop \
down menu.  The user can switch between aerial photographs and topological \
maps using the \"Theme\" drop down menu.  \
\>", "Text"],

Cell[TextData[{
  "More information about the TerraService may be found at ",
  ButtonBox["http://terraservice.net/.",
    ButtonData:>{
      URL[ "http://terraservice.net/"], None},
    ButtonStyle->"Hyperlink"]
}], "Text"],

Cell["\<\
To try this example,you must have GUIKit installed.  Then go to the Example \
section and evaluate the cell.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Examples", "Section"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(Needs["\<GUIKit`\>"];\)\), "\[IndentingNewLine]", 
    \(GUIRun["\<TerraService\>"]\)}], "Input"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject383282411732993, 
        JLink`Objects`JavaObject440933271207937]]], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
AutoGeneratedPackage->None,
WindowSize->{664, 565},
WindowMargins->{{Automatic, 172}, {Automatic, 10}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 37, 0, 95, "Title"],
Cell[1816, 55, 995, 14, 185, "Text"],
Cell[2814, 71, 225, 6, 33, "Text"],
Cell[3042, 79, 132, 3, 33, "Text"],

Cell[CellGroupData[{
Cell[3199, 86, 27, 0, 73, "Section"],

Cell[CellGroupData[{
Cell[3251, 90, 120, 2, 50, "Input"],
Cell[3374, 94, 231, 5, 29, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

