(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     96594,       2283]*)
(*NotebookOutlinePosition[     99270,       2367]*)
(*  CellTagsIndexPosition[     99026,       2356]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["WebServices Validation", "Title"],

Cell["1. Rebuild Help Index and View Documentation", "Section"],

Cell[CellGroupData[{

Cell["2. Load Package", "Section"],

Cell[BoxData[
    \(<< WebServices`\)], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["3. Verify Version, Version Number, and ReleaseNumber", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(WebServices`Information`$Version\)], "Input"],

Cell[BoxData[
    \("Web Services Version 1.0b1 (April 2003)"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(WebServices`Information`$VersionNumber\)], "Input"],

Cell[BoxData[
    \(1.`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(WebServices`Information`$ReleaseNumber\)], "Input"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4. Test Simple Type Functions", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://www.xmethods.net/sd/BabelFishService.wsdl\>"]\)\
], "Input",
  CellTags->"b:0.1.0"],

Cell[BoxData[
    \({BabelFish}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?BabelFish\)\)], "Input"],

Cell[BoxData["\<\"Translates text of up to 5k in length, between a variety of \
languages.\\n\\nPlease refer to \
\!\(\*ButtonBox[\\\"OperationPalette[BabelFish]\\\",       Active->True,      \
  ButtonEvaluator->Automatic,       \
ButtonFunction->OperationPalette[BabelFish],       ButtonStyle->\\\"Hyperlink\
\\\"]\) for help.\"\>"], "Print",
  CellTags->"Info3259394655-1050866"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(BabelFish["\<en_de\>", \ "\<Hello.  I like to fish\>"]\)], "Input"],

Cell[BoxData[
    \("hallo. Ich mag fischen"\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["5. Test Compound Type Functions", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://soap.amazon.com/schemas/AmazonWebServices.wsdl\
\>"]\)], "Input",
  CellTags->"b:0.1.1"],

Cell[BoxData[
    \({KeywordSearchRequest, BrowseNodeSearchRequest, AsinSearchRequest, 
      UpcSearchRequest, AuthorSearchRequest, ArtistSearchRequest, 
      ActorSearchRequest, ManufacturerSearchRequest, DirectorSearchRequest, 
      ListManiaSearchRequest, SimilaritySearchRequest}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?AuthorSearchRequest\)\)], "Input",
  CellTags->"b:0.1.1"],

Cell[BoxData["\<\"Documentation was not provided.\\n\\nPlease refer to \
\!\(\*ButtonBox[\\\"OperationPalette[AuthorSearchRequest]\\\",       \
Active->True,        ButtonEvaluator->Automatic,       \
ButtonFunction->OperationPalette[AuthorSearchRequest],       \
ButtonStyle->\\\"Hyperlink\\\"]\) for help.\"\>"], "Print",
  CellTags->"Info3259394669-3242290"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(AuthorSearchRequest[{"\<author\>" -> "\<Stephen Wolfram\>", \ \
"\<page\>" -> "\<1\>", \ "\<mode\>" -> \ "\<books\>", \ "\<tag\>" -> \
"\<webservices-20\>", "\<type\>" -> "\<lite\>", \ "\<devtag\>" -> \
"\<D3VZJS46JD5U9D\>", \ \ "\<version\>" -> "\<1.0\>"}]\)], "Input",
  CellTags->"b:0.1.1"],

Cell[BoxData[
    \({"Details" \[Rule] {{"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/1579550088",\
 "Asin" \[Rule] "1579550088", "ProductName" \[Rule] "A New Kind of Science", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "14 May, 2002", 
            "Manufacturer" \[Rule] "Wolfram Media, Inc.", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/1579550088.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/1579550088.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/1579550088.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$44.95", "OurPrice" \[Rule] "$44.95", 
            "UsedPrice" \[Rule] "$43.94"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0521643147",\
 "Asin" \[Rule] "0521643147", "ProductName" \[Rule] "The Mathematica Book", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "15 March, 1999", 
            "Manufacturer" \[Rule] "Cambridge Univ Pr (Trd)", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0521643147.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0521643147.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0521643147.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$53.00", "OurPrice" \[Rule] "$37.10", 
            "UsedPrice" \[Rule] "$29.30"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0201626640",\
 "Asin" \[Rule] "0201626640", 
            "ProductName" \[Rule] "Cellular Automata and Complexity", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "July, 2002", 
            "Manufacturer" \[Rule] "Perseus Publishing", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0201626640.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0201626640.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0201626640.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$35.00", "OurPrice" \[Rule] "$35.00", 
            "UsedPrice" \[Rule] "$9.97"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0201193302",\
 "Asin" \[Rule] "0201193302", "ProductName" \[Rule] "Mathematica", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "August, 1990", 
            "Manufacturer" \[Rule] "Addison-Wesley Pub Co", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0201193302.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0201193302.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0201193302.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$39.95", "OurPrice" \[Rule] "$39.95", 
            "UsedPrice" \[Rule] "$3.00"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/020151012X",\
 "Asin" \[Rule] "020151012X", 
            "ProductName" \[Rule] 
              "Mathematica: Reference Guide/for Mathematica Version 2", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "May, 1992", 
            "Manufacturer" \[Rule] "Addison-Wesley Publishing", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/020151012X.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/020151012X.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/020151012X.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$21.95", "OurPrice" \[Rule] "$21.95", 
            "UsedPrice" \[Rule] "$14.28"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0521585856",\
 "Asin" \[Rule] "0521585856", 
            "ProductName" \[Rule] 
              "Mathematica \[RegisteredTrademark] 3.0 Standard Add-on \
Packages", "Catalog" \[Rule] "Book", 
            "Authors" \[Rule] {"Stephen Wolfram", 
                "Inc. Staff Wolfram Research"}, 
            "ReleaseDate" \[Rule] "December, 1996", 
            "Manufacturer" \[Rule] "Cambridge Univ Pr (Trd)", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0521585856.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0521585856.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0521585856.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$35.00", "OurPrice" \[Rule] "$35.00", 
            "UsedPrice" \[Rule] "$3.55"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/9971501244",\
 "Asin" \[Rule] "9971501244", 
            "ProductName" \[Rule] 
              "Theory and Application of Cellular Automata (Advanced Series \
on Complex Systems, Volume 1)", "Catalog" \[Rule] "Book", 
            "Authors" \[Rule] {"S. Wolfram"}, 
            "ReleaseDate" \[Rule] "June, 1986", 
            "Manufacturer" \[Rule] "World Scientific Pub Co", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/9971501244.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/9971501244.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/9971501244.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$32.00", "OurPrice" \[Rule] "$32.00", 
            "UsedPrice" \[Rule] "$39.00"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0124649904",\
 "Asin" \[Rule] "0124649904", 
            "ProductName" \[Rule] "The Mathematica Programmer", 
            "Catalog" \[Rule] "Book", 
            "Authors" \[Rule] {"Roman E. Maeder", "Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "January, 1994", 
            "Manufacturer" \[Rule] "Academic Press", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0124649904.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0124649904.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0124649904.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$48.00", "OurPrice" \[Rule] "$48.00", 
            "UsedPrice" \[Rule] "$15.00"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0201554798",\
 "Asin" \[Rule] "0201554798", 
            "ProductName" \[Rule] "Mathematica: The Student Book", 
            "Catalog" \[Rule] "Book", 
            "Authors" \[Rule] {"Stephen Wolfram", "George Beck"}, 
            "ReleaseDate" \[Rule] "July, 1900", 
            "Manufacturer" \[Rule] "Addison-Wesley Pub Co", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0201554798.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0201554798.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0201554798.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$32.95", "OurPrice" \[Rule] "$32.95", 
            "UsedPrice" \[Rule] "$3.95"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0201515024",\
 "Asin" \[Rule] "0201515024", 
            "ProductName" \[Rule] 
              "Mathematica: A System for Doing Mathematics by Computer", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "March, 1991", 
            "Manufacturer" \[Rule] "Addison-Wesley Pub Co", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0201515024.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0201515024.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0201515024.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$51.95", "OurPrice" \[Rule] "$51.95", 
            "UsedPrice" \[Rule] "$2.19"}}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["6. Test Message Functions", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://www.xmethods.net/sd/2001/CATrafficService.wsdl\
\>"]\)], "Input"],

Cell[BoxData[
    \({getTraffic}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(request\  = \ ToServiceRequest[getTraffic, "\<101\>"]\)], "Input"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"soapenv", 
          "Envelope"}, {{"xmlns", "soapenv"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", {"xmlns", 
              "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema", {"xmlns", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", {"xmlns", 
              "soapenc"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/encoding/"}, \
{XMLElement[{"soapenv", 
              "Body"}, {}, {XMLElement[{"ns0", 
                  "getTraffic"}, {{"soapenv", "encodingStyle"} \[Rule] 
                    "http://schemas.xmlsoap.org/soap/encoding/", {"xmlns", 
                      "ns0"} \[Rule] 
                    "urn:xmethods-CATraffic"}, {XMLElement[{\*"\<\"\"\>", 
                      "hwynums"}, {{"xsi", "type"} \[Rule] 
                        "xsd:string"}, {"101"}]}]}]}], {}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(response\  = \ getTraffic[request]\)], "Input"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
          "Envelope"}, {{"http://www.w3.org/2000/xmlns/", "SOAP-ENV"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", \
{"http://www.w3.org/2000/xmlns/", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", \
{"http://www.w3.org/2000/xmlns/", "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema"}, \
{XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
              "Body"}, {}, {XMLElement[{"urn:xmethods-CATraffic", 
                  "getTrafficResponse"}, \
{{"http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"} \[Rule] 
                    "http://schemas.xmlsoap.org/soap/encoding/", \
{"http://www.w3.org/2000/xmlns/", "ns1"} \[Rule] 
                    "urn:xmethods-CATraffic"}, {XMLElement[
                    "return", {{"http://www.w3.org/2001/XMLSchema-instance", 
                          "type"} \[Rule] 
                        "xsd:string"}, {"reported as of Tuesday, April 15, \
2003 at 09:24 . Slow for the Cone Zone US 101 [LOS ANGELES & VENTURA CO.'S] \
NO TRAFFIC RESTRICTIONS ARE REPORTED FOR THIS AREA. [CENTRAL COAST] NO \
TRAFFIC RESTRICTIONS ARE REPORTED FOR THIS AREA. [SAN FRANCISCO BAY AREA] THE \
SOUTHBOUND CONNECTOR TO SOUTHBOUND SR 85 /IN MOUNTAIN VIEW/ (SANTA CLARA CO) \
IS CLOSED FROM 2300 HRS EACH NIGHT TO 0500 HRS EACH MORNING THRU 4/19/03 - \
DUE TO CONSTRUCTION - A DETOUR IS AVAILABLE IS CLOSED TO SOUTHBOUND TRAFFIC \
FROM BAYSHORE BLVD TO OYSTER PT BLVD /IN SOUTH SAN FRANCISCO/ (SAN MATEO CO) \
FROM 0001 HRS TO 0500 HRS THRU 4/19/03 - DUE TO CONSTRUCTION - A DETOUR IS \
AVAILABLE [NORTHWEST CALIFORNIA] /AT THE CONFUSION HILL SLIDE/ FROM 7 MI \
NORTH OF LEGGETT TO THE JCT OF SR 271 (MENDOCINO CO) IS CURRENTLY OPEN. \
MOTORISTS ARE SUBJECT TO 20 MINUTE DELAYS MONDAY THRU FRIDAY FROM 0800 HRS TO \
1900 HRS - DUE TO CONSTRUCTION"}]}]}]}], {}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FromServiceResponse[response]\)], "Input"],

Cell[BoxData[
    \("reported as of Tuesday, April 15, 2003 at 09:24 . Slow for the Cone \
Zone US 101 [LOS ANGELES & VENTURA CO.'S] NO TRAFFIC RESTRICTIONS ARE \
REPORTED FOR THIS AREA. [CENTRAL COAST] NO TRAFFIC RESTRICTIONS ARE REPORTED \
FOR THIS AREA. [SAN FRANCISCO BAY AREA] THE SOUTHBOUND CONNECTOR TO \
SOUTHBOUND SR 85 /IN MOUNTAIN VIEW/ (SANTA CLARA CO) IS CLOSED FROM 2300 HRS \
EACH NIGHT TO 0500 HRS EACH MORNING THRU 4/19/03 - DUE TO CONSTRUCTION - A \
DETOUR IS AVAILABLE IS CLOSED TO SOUTHBOUND TRAFFIC FROM BAYSHORE BLVD TO \
OYSTER PT BLVD /IN SOUTH SAN FRANCISCO/ (SAN MATEO CO) FROM 0001 HRS TO 0500 \
HRS THRU 4/19/03 - DUE TO CONSTRUCTION - A DETOUR IS AVAILABLE [NORTHWEST \
CALIFORNIA] /AT THE CONFUSION HILL SLIDE/ FROM 7 MI NORTH OF LEGGETT TO THE \
JCT OF SR 271 (MENDOCINO CO) IS CURRENTLY OPEN. MOTORISTS ARE SUBJECT TO 20 \
MINUTE DELAYS MONDAY THRU FRIDAY FROM 0800 HRS TO 1900 HRS - DUE TO \
CONSTRUCTION"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(response\  = \ InvokeServiceOperation[getTraffic, \ request]\)], "Input"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
          "Envelope"}, {{"http://www.w3.org/2000/xmlns/", "SOAP-ENV"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", \
{"http://www.w3.org/2000/xmlns/", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", \
{"http://www.w3.org/2000/xmlns/", "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema"}, \
{XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
              "Body"}, {}, {XMLElement[{"urn:xmethods-CATraffic", 
                  "getTrafficResponse"}, \
{{"http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"} \[Rule] 
                    "http://schemas.xmlsoap.org/soap/encoding/", \
{"http://www.w3.org/2000/xmlns/", "ns1"} \[Rule] 
                    "urn:xmethods-CATraffic"}, {XMLElement[
                    "return", {{"http://www.w3.org/2001/XMLSchema-instance", 
                          "type"} \[Rule] 
                        "xsd:string"}, {"reported as of Tuesday, April 15, \
2003 at 09:24 . Slow for the Cone Zone US 101 [LOS ANGELES & VENTURA CO.'S] \
NO TRAFFIC RESTRICTIONS ARE REPORTED FOR THIS AREA. [CENTRAL COAST] NO \
TRAFFIC RESTRICTIONS ARE REPORTED FOR THIS AREA. [SAN FRANCISCO BAY AREA] THE \
SOUTHBOUND CONNECTOR TO SOUTHBOUND SR 85 /IN MOUNTAIN VIEW/ (SANTA CLARA CO) \
IS CLOSED FROM 2300 HRS EACH NIGHT TO 0500 HRS EACH MORNING THRU 4/19/03 - \
DUE TO CONSTRUCTION - A DETOUR IS AVAILABLE IS CLOSED TO SOUTHBOUND TRAFFIC \
FROM BAYSHORE BLVD TO OYSTER PT BLVD /IN SOUTH SAN FRANCISCO/ (SAN MATEO CO) \
FROM 0001 HRS TO 0500 HRS THRU 4/19/03 - DUE TO CONSTRUCTION - A DETOUR IS \
AVAILABLE [NORTHWEST CALIFORNIA] /AT THE CONFUSION HILL SLIDE/ FROM 7 MI \
NORTH OF LEGGETT TO THE JCT OF SR 271 (MENDOCINO CO) IS CURRENTLY OPEN. \
MOTORISTS ARE SUBJECT TO 20 MINUTE DELAYS MONDAY THRU FRIDAY FROM 0800 HRS TO \
1900 HRS - DUE TO CONSTRUCTION"}]}]}]}], {}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FromServiceResponse[response]\)], "Input"],

Cell[BoxData[
    \("reported as of Tuesday, April 15, 2003 at 09:24 . Slow for the Cone \
Zone US 101 [LOS ANGELES & VENTURA CO.'S] NO TRAFFIC RESTRICTIONS ARE \
REPORTED FOR THIS AREA. [CENTRAL COAST] NO TRAFFIC RESTRICTIONS ARE REPORTED \
FOR THIS AREA. [SAN FRANCISCO BAY AREA] THE SOUTHBOUND CONNECTOR TO \
SOUTHBOUND SR 85 /IN MOUNTAIN VIEW/ (SANTA CLARA CO) IS CLOSED FROM 2300 HRS \
EACH NIGHT TO 0500 HRS EACH MORNING THRU 4/19/03 - DUE TO CONSTRUCTION - A \
DETOUR IS AVAILABLE IS CLOSED TO SOUTHBOUND TRAFFIC FROM BAYSHORE BLVD TO \
OYSTER PT BLVD /IN SOUTH SAN FRANCISCO/ (SAN MATEO CO) FROM 0001 HRS TO 0500 \
HRS THRU 4/19/03 - DUE TO CONSTRUCTION - A DETOUR IS AVAILABLE [NORTHWEST \
CALIFORNIA] /AT THE CONFUSION HILL SLIDE/ FROM 7 MI NORTH OF LEGGETT TO THE \
JCT OF SR 271 (MENDOCINO CO) IS CURRENTLY OPEN. MOTORISTS ARE SUBJECT TO 20 \
MINUTE DELAYS MONDAY THRU FRIDAY FROM 0800 HRS TO 1900 HRS - DUE TO \
CONSTRUCTION"\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["7. Test Message Building Functions", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(msg\  = \ 
      ToServiceRequest[{{"\<zipcode\>", \
{{"\<http://www.w3.org/2001/XMLSchema-instance\>", \ "\<type\>"} \[Rule] \
{"\<http://www.w3.org/2001/XMLSchema\>", "\<string\>"}}} -> "\<61821\>"}, {}, \
\ \[IndentingNewLine]OperationName -> {"\<urn:xmethods-Temperature\>", \
"\<getTemp\>"}]\)], "Input"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"soapenv", 
          "Envelope"}, {{"xmlns", "soapenv"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", {"xmlns", 
              "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema", {"xmlns", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", {"xmlns", 
              "soapenc"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/encoding/"}, \
{XMLElement[{"soapenv", 
              "Body"}, {}, {XMLElement[{"ns0", 
                  "getTemp"}, {{"xmlns", "ns0"} \[Rule] 
                    "urn:xmethods-Temperature"}, {XMLElement[{\*"\<\"\"\>", 
                      "zipcode"}, {{"xsi", "type"} \[Rule] 
                        "xsd:string"}, {"61821"}]}]}]}], {}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(response\  = \ 
      InvokeServiceOperation["\<http://services.xmethods.net:80/soap/servlet/\
rpcrouter\>", \ msg]\)], "Input"],

Cell[BoxData[
    \(\(XMLObject["Document"]\)[{}, 
      XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
          "Envelope"}, {{"http://www.w3.org/2000/xmlns/", "SOAP-ENV"} \[Rule] 
            "http://schemas.xmlsoap.org/soap/envelope/", \
{"http://www.w3.org/2000/xmlns/", "xsi"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema-instance", \
{"http://www.w3.org/2000/xmlns/", "xsd"} \[Rule] 
            "http://www.w3.org/2001/XMLSchema"}, \
{XMLElement[{"http://schemas.xmlsoap.org/soap/envelope/", 
              "Body"}, {}, {XMLElement[{"urn:xmethods-Temperature", 
                  "getTempResponse"}, \
{{"http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle"} \[Rule] 
                    "http://schemas.xmlsoap.org/soap/encoding/", \
{"http://www.w3.org/2000/xmlns/", "ns1"} \[Rule] 
                    "urn:xmethods-Temperature"}, {XMLElement[
                    "return", {{"http://www.w3.org/2001/XMLSchema-instance", 
                          "type"} \[Rule] 
                        "xsd:float"}, {"79.0"}]}]}]}], {}]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FromServiceResponse[response]\)], "Input"],

Cell[BoxData[
    \(79.`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallServiceOperation[
      TempService`getTempFromZipCode, \ \
"\<http://services.xmethods.net:80/soap/servlet/rpcrouter\>", \ \
\[IndentingNewLine]{{"\<zipcode\>", \
{{"\<http://www.w3.org/2001/XMLSchema-instance\>", \ "\<type\>"} \[Rule] \
{"\<http://www.w3.org/2001/XMLSchema\>", "\<string\>"}}}}, {}, 
      OperationName -> {"\<urn:xmethods-Temperature\>", "\<getTemp\>"}]\)], \
"Input"],

Cell[BoxData[
    \(getTempFromZipCode\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(getTempFromZipCode["\<61821\>"]\)], "Input"],

Cell[BoxData[
    \(79.`\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["8. Test Advanced InstallService Functionality", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://www.xmethods.net/sd/2001/BNQuoteService.wsdl\>\
", "\<BarnesAndNoble`\>"]\)], "Input",
  CellTags->"b:0.3.1"],

Cell[BoxData[
    \({getPrice}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Context[getPrice]\)], "Input",
  CellTags->"b:0.3.1"],

Cell[BoxData[
    \("BarnesAndNoble`"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(getPrice["\<043935806X\>"]\)], "Input",
  CellTags->"b:0.3.1"],

Cell[BoxData[
    \(17.99`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://www.xmethods.net/sd/2001/\
CurrencyExchangeService.wsdl\>", AllowShortContext \[Rule] False]\)], "Input",\

  CellTags->"b:0.3.1"],

Cell[BoxData[
    \({CurrencyExchangeService`CurrencyExchangePort`getRate}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CurrencyExchangeService`CurrencyExchangePort`getRate["\<us\>", \
"\<england\>"]\)], "Input",
  CellTags->"b:0.3.1"],

Cell[BoxData[
    \(0.6367`\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["9. Test Uninstall Functions", "Section"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://terraservice.net/TerraService.asmx?WSDL \
\>"]\)], "Input",
  CellTags->"b:0.3.4"],

Cell[BoxData[
    \({ConvertLonLatPtToNearestPlace, ConvertLonLatPtToUtmPt, 
      ConvertUtmPtToLonLatPt, ConvertPlaceToLonLatPt, CountPlacesInRect, 
      GetAreaFromPt, GetAreaFromRect, GetAreaFromTileId, GetLatLonMetrics, 
      GetPlaceFacts, GetPlaceList, GetPlaceListInRect, GetTheme, 
      GetTileMetaFromLonLatPt, GetTileMetaFromTileId, GetTile}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \($InstalledServices\)], "Input",
  CellTags->"b:0.3.4"],

Cell[BoxData[
    \({ActorSearchRequest, ArtistSearchRequest, AsinSearchRequest, 
      AuthorSearchRequest, BabelFish, BrowseNodeSearchRequest, 
      ConvertLonLatPtToNearestPlace, ConvertLonLatPtToUtmPt, 
      ConvertPlaceToLonLatPt, ConvertUtmPtToLonLatPt, CountPlacesInRect, 
      DirectorSearchRequest, GetAreaFromPt, GetAreaFromRect, 
      GetAreaFromTileId, GetLatLonMetrics, GetPlaceFacts, GetPlaceList, 
      GetPlaceListInRect, getPrice, 
      CurrencyExchangeService`CurrencyExchangePort`getRate, 
      getTempFromZipCode, GetTheme, GetTile, GetTileMetaFromLonLatPt, 
      GetTileMetaFromTileId, getTraffic, KeywordSearchRequest, 
      ListManiaSearchRequest, ManufacturerSearchRequest, 
      SimilaritySearchRequest, UpcSearchRequest}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(UninstallServiceOperation[ConvertLonLatPtToNearestPlace]\)], "Input",
  CellTags->"b:0.3.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \($InstalledServices\)], "Input",
  CellTags->"b:0.3.4"],

Cell[BoxData[
    \({ActorSearchRequest, ArtistSearchRequest, AsinSearchRequest, 
      AuthorSearchRequest, BabelFish, BrowseNodeSearchRequest, 
      ConvertLonLatPtToUtmPt, ConvertPlaceToLonLatPt, ConvertUtmPtToLonLatPt, 
      CountPlacesInRect, DirectorSearchRequest, GetAreaFromPt, 
      GetAreaFromRect, GetAreaFromTileId, GetLatLonMetrics, GetPlaceFacts, 
      GetPlaceList, GetPlaceListInRect, getPrice, 
      CurrencyExchangeService`CurrencyExchangePort`getRate, 
      getTempFromZipCode, GetTheme, GetTile, GetTileMetaFromLonLatPt, 
      GetTileMetaFromTileId, getTraffic, KeywordSearchRequest, 
      ListManiaSearchRequest, ManufacturerSearchRequest, 
      SimilaritySearchRequest, UpcSearchRequest}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OperationPalette[ConvertLonLatPtToNearestPlace]\)], "Input",
  CellTags->"b:0.3.4"],

Cell[BoxData[
    \("Palette cannot be found."\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Context[ConvertLonLatPtToNearestPlace]\)], "Input",
  CellTags->"b:0.3.4"],

Cell[BoxData[
    \("Global`"\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(UninstallService["\<TerraService`TerraServiceSoap`*\>"]\)], "Input",
  CellTags->"b:0.3.4"],

Cell[CellGroupData[{

Cell[BoxData[
    \($InstalledServices\)], "Input",
  CellTags->"b:0.3.4"],

Cell[BoxData[
    \({ActorSearchRequest, ArtistSearchRequest, AsinSearchRequest, 
      AuthorSearchRequest, BabelFish, BrowseNodeSearchRequest, 
      DirectorSearchRequest, getPrice, 
      CurrencyExchangeService`CurrencyExchangePort`getRate, 
      getTempFromZipCode, getTraffic, KeywordSearchRequest, 
      ListManiaSearchRequest, ManufacturerSearchRequest, 
      SimilaritySearchRequest, UpcSearchRequest}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(OperationPalette[ConvertPlaceToLonLatPt]\)], "Input",
  CellTags->"b:0.3.4"],

Cell[BoxData[
    \("Palette cannot be found."\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["10.  Test Debugging Options", "Section"],

Cell[BoxData[
    \(\($PrintServiceRequest\  = \ True;\)\)], "Input"],

Cell[BoxData[
    \(\($PrintServiceResponse\  = \ True;\)\)], "Input"],

Cell[BoxData[
    \(\($PrintPerformanceNumbers\  = \ True;\)\)], "Input"],

Cell[BoxData[
    \(\($PrintWSDLDebug\  = \ True;\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(InstallService["\<http://soap.amazon.com/schemas/AmazonWebServices.wsdl\
\>"]\)], "Input",
  CellTags->"b:0.1.1"],

Cell[BoxData[
    InterpretationBox[\("Installing Service: "\[InvisibleSpace]{2003, 4, 15, 
          11, 26, 51}\),
      SequenceForm[ "Installing Service: ", {2003, 4, 15, 11, 26, 51}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Context: "\[InvisibleSpace]Null\),
      SequenceForm[ "Context: ", Null],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("WSDL URL: \
"\[InvisibleSpace]"http://soap.amazon.com/schemas/AmazonWebServices.wsdl"\),
      SequenceForm[ 
      "WSDL URL: ", "http://soap.amazon.com/schemas/AmazonWebServices.wsdl"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Options: "\[InvisibleSpace]{}\),
      SequenceForm[ "Options: ", {}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Service Name: \
"\[InvisibleSpace]"AmazonSearchService"\),
      SequenceForm[ "Service Name: ", "AmazonSearchService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Port Name: "\[InvisibleSpace]"AmazonSearchPort"\),
      SequenceForm[ "Port Name: ", "AmazonSearchPort"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("SOAP End Point: \
"\[InvisibleSpace]"http://soap.amazon.com/onca/soap"\),
      SequenceForm[ "SOAP End Point: ", "http://soap.amazon.com/onca/soap"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Transport: \
"\[InvisibleSpace]"http://schemas.xmlsoap.org/soap/http"\),
      SequenceForm[ "Transport: ", "http://schemas.xmlsoap.org/soap/http"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Style: "\[InvisibleSpace]"rpc"\),
      SequenceForm[ "Style: ", "rpc"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation Name: \
"\[InvisibleSpace]"KeywordSearchRequest"\),
      SequenceForm[ "Operation Name: ", "KeywordSearchRequest"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("SOAP Action URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "SOAP Action URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Header Params: "\[InvisibleSpace]{}\),
      SequenceForm[ "Header Params: ", {}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: \
"\[InvisibleSpace]{"http://schemas.xmlsoap.org/soap/encoding/"}\),
      SequenceForm[ 
      "Encoding Style: ", {"http://schemas.xmlsoap.org/soap/encoding/"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Namespace URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "Namespace URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: "\[InvisibleSpace]"encoded"\),
      SequenceForm[ "Encoding Style: ", "encoded"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Binding Parts: "\[InvisibleSpace]Null\),
      SequenceForm[ "Binding Parts: ", Null],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "KeywordSearchRequest"}\),
      
      SequenceForm[ 
      "Operation: ", {"urn:PI/DevCentral/SoapService", 
        "KeywordSearchRequest"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Params: "\[InvisibleSpace]{{{\*"\<\"\"\>", 
              "KeywordSearchRequest"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", 
                  "type"} \[Rule] {"urn:PI/DevCentral/SoapService", 
                  "KeywordRequest"}}}}\),
      SequenceForm[ 
      "Params: ", {{{"", "KeywordSearchRequest"}, {{
        "http://www.w3.org/2001/XMLSchema-instance", "type"} -> {
        "urn:PI/DevCentral/SoapService", "KeywordRequest"}}}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Return Type: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "ProductInfo"}\),
      SequenceForm[ 
      "Return Type: ", {"urn:PI/DevCentral/SoapService", "ProductInfo"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation Name: \
"\[InvisibleSpace]"BrowseNodeSearchRequest"\),
      SequenceForm[ "Operation Name: ", "BrowseNodeSearchRequest"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("SOAP Action URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "SOAP Action URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Header Params: "\[InvisibleSpace]{}\),
      SequenceForm[ "Header Params: ", {}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: \
"\[InvisibleSpace]{"http://schemas.xmlsoap.org/soap/encoding/"}\),
      SequenceForm[ 
      "Encoding Style: ", {"http://schemas.xmlsoap.org/soap/encoding/"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Namespace URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "Namespace URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: "\[InvisibleSpace]"encoded"\),
      SequenceForm[ "Encoding Style: ", "encoded"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Binding Parts: "\[InvisibleSpace]Null\),
      SequenceForm[ "Binding Parts: ", Null],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", 
          "BrowseNodeSearchRequest"}\),
      SequenceForm[ 
      "Operation: ", {"urn:PI/DevCentral/SoapService", 
        "BrowseNodeSearchRequest"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Params: "\[InvisibleSpace]{{{\*"\<\"\"\>", 
              "BrowseNodeSearchRequest"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", 
                  "type"} \[Rule] {"urn:PI/DevCentral/SoapService", 
                  "BrowseNodeRequest"}}}}\),
      SequenceForm[ 
      "Params: ", {{{"", "BrowseNodeSearchRequest"}, {{
        "http://www.w3.org/2001/XMLSchema-instance", "type"} -> {
        "urn:PI/DevCentral/SoapService", "BrowseNodeRequest"}}}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Return Type: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "ProductInfo"}\),
      SequenceForm[ 
      "Return Type: ", {"urn:PI/DevCentral/SoapService", "ProductInfo"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation Name: \
"\[InvisibleSpace]"AsinSearchRequest"\),
      SequenceForm[ "Operation Name: ", "AsinSearchRequest"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("SOAP Action URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "SOAP Action URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Header Params: "\[InvisibleSpace]{}\),
      SequenceForm[ "Header Params: ", {}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: \
"\[InvisibleSpace]{"http://schemas.xmlsoap.org/soap/encoding/"}\),
      SequenceForm[ 
      "Encoding Style: ", {"http://schemas.xmlsoap.org/soap/encoding/"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Namespace URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "Namespace URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: "\[InvisibleSpace]"encoded"\),
      SequenceForm[ "Encoding Style: ", "encoded"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Binding Parts: "\[InvisibleSpace]Null\),
      SequenceForm[ "Binding Parts: ", Null],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "AsinSearchRequest"}\),
      SequenceForm[ 
      "Operation: ", {"urn:PI/DevCentral/SoapService", "AsinSearchRequest"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Params: "\[InvisibleSpace]{{{\*"\<\"\"\>", 
              "AsinSearchRequest"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", 
                  "type"} \[Rule] {"urn:PI/DevCentral/SoapService", 
                  "AsinRequest"}}}}\),
      SequenceForm[ 
      "Params: ", {{{"", "AsinSearchRequest"}, {{
        "http://www.w3.org/2001/XMLSchema-instance", "type"} -> {
        "urn:PI/DevCentral/SoapService", "AsinRequest"}}}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Return Type: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "ProductInfo"}\),
      SequenceForm[ 
      "Return Type: ", {"urn:PI/DevCentral/SoapService", "ProductInfo"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation Name: "\[InvisibleSpace]"UpcSearchRequest"\
\),
      SequenceForm[ "Operation Name: ", "UpcSearchRequest"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("SOAP Action URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "SOAP Action URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Header Params: "\[InvisibleSpace]{}\),
      SequenceForm[ "Header Params: ", {}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: \
"\[InvisibleSpace]{"http://schemas.xmlsoap.org/soap/encoding/"}\),
      SequenceForm[ 
      "Encoding Style: ", {"http://schemas.xmlsoap.org/soap/encoding/"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Namespace URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "Namespace URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: "\[InvisibleSpace]"encoded"\),
      SequenceForm[ "Encoding Style: ", "encoded"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Binding Parts: "\[InvisibleSpace]Null\),
      SequenceForm[ "Binding Parts: ", Null],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "UpcSearchRequest"}\),
      SequenceForm[ 
      "Operation: ", {"urn:PI/DevCentral/SoapService", "UpcSearchRequest"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Params: "\[InvisibleSpace]{{{\*"\<\"\"\>", 
              "UpcSearchRequest"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", 
                  "type"} \[Rule] {"urn:PI/DevCentral/SoapService", 
                  "UpcRequest"}}}}\),
      SequenceForm[ 
      "Params: ", {{{"", "UpcSearchRequest"}, {{
        "http://www.w3.org/2001/XMLSchema-instance", "type"} -> {
        "urn:PI/DevCentral/SoapService", "UpcRequest"}}}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Return Type: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "ProductInfo"}\),
      SequenceForm[ 
      "Return Type: ", {"urn:PI/DevCentral/SoapService", "ProductInfo"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation Name: \
"\[InvisibleSpace]"AuthorSearchRequest"\),
      SequenceForm[ "Operation Name: ", "AuthorSearchRequest"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("SOAP Action URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "SOAP Action URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Header Params: "\[InvisibleSpace]{}\),
      SequenceForm[ "Header Params: ", {}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: \
"\[InvisibleSpace]{"http://schemas.xmlsoap.org/soap/encoding/"}\),
      SequenceForm[ 
      "Encoding Style: ", {"http://schemas.xmlsoap.org/soap/encoding/"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Namespace URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "Namespace URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: "\[InvisibleSpace]"encoded"\),
      SequenceForm[ "Encoding Style: ", "encoded"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Binding Parts: "\[InvisibleSpace]Null\),
      SequenceForm[ "Binding Parts: ", Null],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "AuthorSearchRequest"}\),
      SequenceForm[ 
      "Operation: ", {"urn:PI/DevCentral/SoapService", 
        "AuthorSearchRequest"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Params: "\[InvisibleSpace]{{{\*"\<\"\"\>", 
              "AuthorSearchRequest"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", 
                  "type"} \[Rule] {"urn:PI/DevCentral/SoapService", 
                  "AuthorRequest"}}}}\),
      SequenceForm[ 
      "Params: ", {{{"", "AuthorSearchRequest"}, {{
        "http://www.w3.org/2001/XMLSchema-instance", "type"} -> {
        "urn:PI/DevCentral/SoapService", "AuthorRequest"}}}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Return Type: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "ProductInfo"}\),
      SequenceForm[ 
      "Return Type: ", {"urn:PI/DevCentral/SoapService", "ProductInfo"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation Name: \
"\[InvisibleSpace]"ArtistSearchRequest"\),
      SequenceForm[ "Operation Name: ", "ArtistSearchRequest"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("SOAP Action URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "SOAP Action URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Header Params: "\[InvisibleSpace]{}\),
      SequenceForm[ "Header Params: ", {}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: \
"\[InvisibleSpace]{"http://schemas.xmlsoap.org/soap/encoding/"}\),
      SequenceForm[ 
      "Encoding Style: ", {"http://schemas.xmlsoap.org/soap/encoding/"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Namespace URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "Namespace URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: "\[InvisibleSpace]"encoded"\),
      SequenceForm[ "Encoding Style: ", "encoded"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Binding Parts: "\[InvisibleSpace]Null\),
      SequenceForm[ "Binding Parts: ", Null],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "ArtistSearchRequest"}\),
      SequenceForm[ 
      "Operation: ", {"urn:PI/DevCentral/SoapService", 
        "ArtistSearchRequest"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Params: "\[InvisibleSpace]{{{\*"\<\"\"\>", 
              "ArtistSearchRequest"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", 
                  "type"} \[Rule] {"urn:PI/DevCentral/SoapService", 
                  "ArtistRequest"}}}}\),
      SequenceForm[ 
      "Params: ", {{{"", "ArtistSearchRequest"}, {{
        "http://www.w3.org/2001/XMLSchema-instance", "type"} -> {
        "urn:PI/DevCentral/SoapService", "ArtistRequest"}}}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Return Type: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "ProductInfo"}\),
      SequenceForm[ 
      "Return Type: ", {"urn:PI/DevCentral/SoapService", "ProductInfo"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation Name: \
"\[InvisibleSpace]"ActorSearchRequest"\),
      SequenceForm[ "Operation Name: ", "ActorSearchRequest"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("SOAP Action URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "SOAP Action URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Header Params: "\[InvisibleSpace]{}\),
      SequenceForm[ "Header Params: ", {}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: \
"\[InvisibleSpace]{"http://schemas.xmlsoap.org/soap/encoding/"}\),
      SequenceForm[ 
      "Encoding Style: ", {"http://schemas.xmlsoap.org/soap/encoding/"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Namespace URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "Namespace URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: "\[InvisibleSpace]"encoded"\),
      SequenceForm[ "Encoding Style: ", "encoded"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Binding Parts: "\[InvisibleSpace]Null\),
      SequenceForm[ "Binding Parts: ", Null],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "ActorSearchRequest"}\),
      SequenceForm[ 
      "Operation: ", {"urn:PI/DevCentral/SoapService", "ActorSearchRequest"}],
      
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Params: "\[InvisibleSpace]{{{\*"\<\"\"\>", 
              "ActorSearchRequest"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", 
                  "type"} \[Rule] {"urn:PI/DevCentral/SoapService", 
                  "ActorRequest"}}}}\),
      SequenceForm[ 
      "Params: ", {{{"", "ActorSearchRequest"}, {{
        "http://www.w3.org/2001/XMLSchema-instance", "type"} -> {
        "urn:PI/DevCentral/SoapService", "ActorRequest"}}}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Return Type: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "ProductInfo"}\),
      SequenceForm[ 
      "Return Type: ", {"urn:PI/DevCentral/SoapService", "ProductInfo"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation Name: \
"\[InvisibleSpace]"ManufacturerSearchRequest"\),
      SequenceForm[ "Operation Name: ", "ManufacturerSearchRequest"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("SOAP Action URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "SOAP Action URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Header Params: "\[InvisibleSpace]{}\),
      SequenceForm[ "Header Params: ", {}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: \
"\[InvisibleSpace]{"http://schemas.xmlsoap.org/soap/encoding/"}\),
      SequenceForm[ 
      "Encoding Style: ", {"http://schemas.xmlsoap.org/soap/encoding/"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Namespace URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "Namespace URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: "\[InvisibleSpace]"encoded"\),
      SequenceForm[ "Encoding Style: ", "encoded"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Binding Parts: "\[InvisibleSpace]Null\),
      SequenceForm[ "Binding Parts: ", Null],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", 
          "ManufacturerSearchRequest"}\),
      SequenceForm[ 
      "Operation: ", {"urn:PI/DevCentral/SoapService", 
        "ManufacturerSearchRequest"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Params: "\[InvisibleSpace]{{{\*"\<\"\"\>", 
              "ManufacturerSearchRequest"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", 
                  "type"} \[Rule] {"urn:PI/DevCentral/SoapService", 
                  "ManufacturerRequest"}}}}\),
      SequenceForm[ 
      "Params: ", {{{"", "ManufacturerSearchRequest"}, {{
        "http://www.w3.org/2001/XMLSchema-instance", "type"} -> {
        "urn:PI/DevCentral/SoapService", "ManufacturerRequest"}}}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Return Type: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "ProductInfo"}\),
      SequenceForm[ 
      "Return Type: ", {"urn:PI/DevCentral/SoapService", "ProductInfo"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation Name: \
"\[InvisibleSpace]"DirectorSearchRequest"\),
      SequenceForm[ "Operation Name: ", "DirectorSearchRequest"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("SOAP Action URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "SOAP Action URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Header Params: "\[InvisibleSpace]{}\),
      SequenceForm[ "Header Params: ", {}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: \
"\[InvisibleSpace]{"http://schemas.xmlsoap.org/soap/encoding/"}\),
      SequenceForm[ 
      "Encoding Style: ", {"http://schemas.xmlsoap.org/soap/encoding/"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Namespace URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "Namespace URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: "\[InvisibleSpace]"encoded"\),
      SequenceForm[ "Encoding Style: ", "encoded"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Binding Parts: "\[InvisibleSpace]Null\),
      SequenceForm[ "Binding Parts: ", Null],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", 
          "DirectorSearchRequest"}\),
      SequenceForm[ 
      "Operation: ", {"urn:PI/DevCentral/SoapService", 
        "DirectorSearchRequest"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Params: "\[InvisibleSpace]{{{\*"\<\"\"\>", 
              "DirectorSearchRequest"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", 
                  "type"} \[Rule] {"urn:PI/DevCentral/SoapService", 
                  "DirectorRequest"}}}}\),
      SequenceForm[ 
      "Params: ", {{{"", "DirectorSearchRequest"}, {{
        "http://www.w3.org/2001/XMLSchema-instance", "type"} -> {
        "urn:PI/DevCentral/SoapService", "DirectorRequest"}}}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Return Type: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "ProductInfo"}\),
      SequenceForm[ 
      "Return Type: ", {"urn:PI/DevCentral/SoapService", "ProductInfo"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation Name: \
"\[InvisibleSpace]"ListManiaSearchRequest"\),
      SequenceForm[ "Operation Name: ", "ListManiaSearchRequest"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("SOAP Action URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "SOAP Action URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Header Params: "\[InvisibleSpace]{}\),
      SequenceForm[ "Header Params: ", {}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: \
"\[InvisibleSpace]{"http://schemas.xmlsoap.org/soap/encoding/"}\),
      SequenceForm[ 
      "Encoding Style: ", {"http://schemas.xmlsoap.org/soap/encoding/"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Namespace URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "Namespace URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: "\[InvisibleSpace]"encoded"\),
      SequenceForm[ "Encoding Style: ", "encoded"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Binding Parts: "\[InvisibleSpace]Null\),
      SequenceForm[ "Binding Parts: ", Null],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", 
          "ListManiaSearchRequest"}\),
      SequenceForm[ 
      "Operation: ", {"urn:PI/DevCentral/SoapService", 
        "ListManiaSearchRequest"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Params: "\[InvisibleSpace]{{{\*"\<\"\"\>", 
              "ListManiaSearchRequest"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", 
                  "type"} \[Rule] {"urn:PI/DevCentral/SoapService", 
                  "ListManiaRequest"}}}}\),
      SequenceForm[ 
      "Params: ", {{{"", "ListManiaSearchRequest"}, {{
        "http://www.w3.org/2001/XMLSchema-instance", "type"} -> {
        "urn:PI/DevCentral/SoapService", "ListManiaRequest"}}}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Return Type: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "ProductInfo"}\),
      SequenceForm[ 
      "Return Type: ", {"urn:PI/DevCentral/SoapService", "ProductInfo"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation Name: \
"\[InvisibleSpace]"SimilaritySearchRequest"\),
      SequenceForm[ "Operation Name: ", "SimilaritySearchRequest"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("SOAP Action URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "SOAP Action URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Header Params: "\[InvisibleSpace]{}\),
      SequenceForm[ "Header Params: ", {}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: \
"\[InvisibleSpace]{"http://schemas.xmlsoap.org/soap/encoding/"}\),
      SequenceForm[ 
      "Encoding Style: ", {"http://schemas.xmlsoap.org/soap/encoding/"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Namespace URI: \
"\[InvisibleSpace]"urn:PI/DevCentral/SoapService"\),
      SequenceForm[ "Namespace URI: ", "urn:PI/DevCentral/SoapService"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Encoding Style: "\[InvisibleSpace]"encoded"\),
      SequenceForm[ "Encoding Style: ", "encoded"],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Binding Parts: "\[InvisibleSpace]Null\),
      SequenceForm[ "Binding Parts: ", Null],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Operation: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", 
          "SimilaritySearchRequest"}\),
      SequenceForm[ 
      "Operation: ", {"urn:PI/DevCentral/SoapService", 
        "SimilaritySearchRequest"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Params: "\[InvisibleSpace]{{{\*"\<\"\"\>", 
              "SimilaritySearchRequest"}, \
{{"http://www.w3.org/2001/XMLSchema-instance", 
                  "type"} \[Rule] {"urn:PI/DevCentral/SoapService", 
                  "SimilarityRequest"}}}}\),
      SequenceForm[ 
      "Params: ", {{{"", "SimilaritySearchRequest"}, {{
        "http://www.w3.org/2001/XMLSchema-instance", "type"} -> {
        "urn:PI/DevCentral/SoapService", "SimilarityRequest"}}}}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Return Type: \
"\[InvisibleSpace]{"urn:PI/DevCentral/SoapService", "ProductInfo"}\),
      SequenceForm[ 
      "Return Type: ", {"urn:PI/DevCentral/SoapService", "ProductInfo"}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished Installing Service: \
"\[InvisibleSpace]{2003, 4, 15, 11, 26, 53}\),
      SequenceForm[ 
      "Finished Installing Service: ", {2003, 4, 15, 11, 26, 53}],
      Editable->False]], "Print"],

Cell[BoxData[
    \({KeywordSearchRequest, BrowseNodeSearchRequest, AsinSearchRequest, 
      UpcSearchRequest, AuthorSearchRequest, ArtistSearchRequest, 
      ActorSearchRequest, ManufacturerSearchRequest, DirectorSearchRequest, 
      ListManiaSearchRequest, SimilaritySearchRequest}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(KeywordSearchRequest[{"\<keyword\>" -> "\<Mathematica\>", \ "\<page\>" -> \
"\<1\>", \ "\<mode\>" -> \ "\<books\>", \ "\<tag\>" -> "\<webservices-20\>", \
"\<type\>" -> "\<lite\>", \ "\<devtag\>" -> "\<D3VZJS46JD5U9D\>", \ \ \
"\<version\>" -> "\<1.0\>"}]\)], "Input",
  CellTags->"b:0.1.1"],

Cell[BoxData[
    InterpretationBox[\("Building SOAPEnvelope: "\[InvisibleSpace]{2003, 4, 
          15, 11, 26, 59}\),
      SequenceForm[ "Building SOAPEnvelope: ", {2003, 4, 15, 11, 26, 59}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished Building SOAPEnvelope: \
"\[InvisibleSpace]{2003, 4, 15, 11, 26, 59}\),
      SequenceForm[ 
      "Finished Building SOAPEnvelope: ", {2003, 4, 15, 11, 26, 59}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("<soapenv:Envelope \
xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" \
xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \
xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \
xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">\n <soapenv:Body>\
\n  <ns0:KeywordSearchRequest \
soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" \
xmlns:ns0=\"urn:PI/DevCentral/SoapService\">\n   <KeywordSearchRequest \
xsi:type=\"ns0:KeywordRequest\">\n    <ns0:keyword xsi:type=\"ns1:string\" \
xmlns:ns1=\"http://www.w3.org/1999/XMLSchema\">Mathematica</ns0:keyword>\n    \
<ns0:page xsi:type=\"ns2:string\" \
xmlns:ns2=\"http://www.w3.org/1999/XMLSchema\">1</ns0:page>\n    <ns0:mode \
xsi:type=\"ns3:string\" \
xmlns:ns3=\"http://www.w3.org/1999/XMLSchema\">books</ns0:mode>\n    <ns0:tag \
xsi:type=\"ns4:string\" \
xmlns:ns4=\"http://www.w3.org/1999/XMLSchema\">webservices-20</ns0:tag>\n    \
<ns0:type xsi:type=\"ns5:string\" \
xmlns:ns5=\"http://www.w3.org/1999/XMLSchema\">lite</ns0:type>\n    \
<ns0:devtag xsi:type=\"ns6:string\" \
xmlns:ns6=\"http://www.w3.org/1999/XMLSchema\">D3VZJS46JD5U9D</ns0:devtag>\n  \
  <ns0:version xsi:type=\"ns7:string\" \
xmlns:ns7=\"http://www.w3.org/1999/XMLSchema\">1.0</ns0:version>\n   \
</KeywordSearchRequest>\n  </ns0:KeywordSearchRequest>\n </soapenv:Body>\n\
</soapenv:Envelope>"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Invoking: "\[InvisibleSpace]{2003, 4, 15, 11, 26, 
          59}\),
      SequenceForm[ "Invoking: ", {2003, 4, 15, 11, 26, 59}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished Invoking: "\[InvisibleSpace]{2003, 4, 15, 
          11, 27, 0}\),
      SequenceForm[ "Finished Invoking: ", {2003, 4, 15, 11, 27, 0}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("<SOAP-ENV:Envelope \
SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" \
xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" \
xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" \
xmlns:xsi=\"http://www.w3.org/1999/XMLSchema-instance\" \
xmlns:xsd=\"http://www.w3.org/1999/XMLSchema\" \
xmlns:amazon=\"urn:PI/DevCentral/SoapService\"><SOAP-ENV:Body><namesp484:\
KeywordSearchRequestResponse \
xmlns:namesp484=\"urn:PI/DevCentral/SoapService\"><return \
xsi:type=\"amazon:ProductInfo\"><Details \
SOAP-ENC:arrayType=\"amazon:Details[10]\" \
xsi:type=\"SOAP-ENC:Array\"><Details xsi:type=\"amazon:Details\"><Url \
xsi:type=\"xsd:string\">http://www.amazon.com/exec/obidos/redirect?tag=\
webservices-20%26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=\
ASIN/0521643147</Url><Asin \
xsi:type=\"xsd:string\">0521643147</Asin><ProductName \
xsi:type=\"xsd:string\">The Mathematica Book</ProductName><Catalog \
xsi:type=\"xsd:string\">Book</Catalog><Authors \
SOAP-ENC:arrayType=\"xsd:string[1]\" xsi:type=\"SOAP-ENC:Array\"><Author \
xsi:type=\"xsd:string\">Stephen Wolfram</Author></Authors><ReleaseDate \
xsi:type=\"xsd:string\">15 March, 1999</ReleaseDate><Manufacturer \
xsi:type=\"xsd:string\">Cambridge Univ Pr (Trd)</Manufacturer><ImageUrlSmall \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0521643147.01.\
THUMBZZZ.jpg</ImageUrlSmall><ImageUrlMedium \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0521643147.01.\
MZZZZZZZ.jpg</ImageUrlMedium><ImageUrlLarge \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0521643147.01.\
LZZZZZZZ.jpg</ImageUrlLarge><ListPrice \
xsi:type=\"xsd:string\">$53.00</ListPrice><OurPrice \
xsi:type=\"xsd:string\">$37.10</OurPrice><UsedPrice \
xsi:type=\"xsd:string\">$29.30</UsedPrice></Details><Details \
xsi:type=\"amazon:Details\"><Url \
xsi:type=\"xsd:string\">http://www.amazon.com/exec/obidos/redirect?tag=\
webservices-20%26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=\
ASIN/0387952349</Url><Asin \
xsi:type=\"xsd:string\">0387952349</Asin><ProductName \
xsi:type=\"xsd:string\">Mathematical Statistics with \
MATHEMATICA</ProductName><Catalog \
xsi:type=\"xsd:string\">Book</Catalog><Authors \
SOAP-ENC:arrayType=\"xsd:string[2]\" xsi:type=\"SOAP-ENC:Array\"><Author \
xsi:type=\"xsd:string\">Colin Rose</Author><Author \
xsi:type=\"xsd:string\">Murray D. Smith</Author></Authors><ReleaseDate \
xsi:type=\"xsd:string\">08 March, 2002</ReleaseDate><Manufacturer \
xsi:type=\"xsd:string\">Springer Verlag</Manufacturer><ImageUrlSmall \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0387952349.01.\
THUMBZZZ.jpg</ImageUrlSmall><ImageUrlMedium \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0387952349.01.\
MZZZZZZZ.jpg</ImageUrlMedium><ImageUrlLarge \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0387952349.01.\
LZZZZZZZ.jpg</ImageUrlLarge><ListPrice \
xsi:type=\"xsd:string\">$79.95</ListPrice><OurPrice \
xsi:type=\"xsd:string\">$79.95</OurPrice><UsedPrice \
xsi:type=\"xsd:string\">$35.00</UsedPrice></Details><Details \
xsi:type=\"amazon:Details\"><Url \
xsi:type=\"xsd:string\">http://www.amazon.com/exec/obidos/redirect?tag=\
webservices-20%26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=\
ASIN/1558606378</Url><Asin \
xsi:type=\"xsd:string\">1558606378</Asin><ProductName \
xsi:type=\"xsd:string\">Illustrating Evolutionary Computation With \
Mathematica</ProductName><Catalog \
xsi:type=\"xsd:string\">Book</Catalog><Authors \
SOAP-ENC:arrayType=\"xsd:string[1]\" xsi:type=\"SOAP-ENC:Array\"><Author \
xsi:type=\"xsd:string\">Christian Jacob</Author></Authors><ReleaseDate \
xsi:type=\"xsd:string\">01 February, 2001</ReleaseDate><Manufacturer \
xsi:type=\"xsd:string\">Morgan Kaufmann</Manufacturer><ImageUrlSmall \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/1558606378.01.\
THUMBZZZ.jpg</ImageUrlSmall><ImageUrlMedium \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/1558606378.01.\
MZZZZZZZ.jpg</ImageUrlMedium><ImageUrlLarge \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/1558606378.01.\
LZZZZZZZ.jpg</ImageUrlLarge><ListPrice \
xsi:type=\"xsd:string\">$69.95</ListPrice><OurPrice \
xsi:type=\"xsd:string\">$69.95</OurPrice><UsedPrice \
xsi:type=\"xsd:string\">$57.51</UsedPrice></Details><Details \
xsi:type=\"amazon:Details\"><Url \
xsi:type=\"xsd:string\">http://www.amazon.com/exec/obidos/redirect?tag=\
webservices-20%26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=\
ASIN/0122961056</Url><Asin \
xsi:type=\"xsd:string\">0122961056</Asin><ProductName \
xsi:type=\"xsd:string\">Mastering Mathematica: Programming Methods and \
Applications</ProductName><Catalog \
xsi:type=\"xsd:string\">Book</Catalog><Authors \
SOAP-ENC:arrayType=\"xsd:string[1]\" xsi:type=\"SOAP-ENC:Array\"><Author \
xsi:type=\"xsd:string\">John W. Gray</Author></Authors><ReleaseDate xsi:type=\
\"xsd:string\">January, 1998</ReleaseDate><Manufacturer xsi:type=\"xsd:string\
\">Academic Press</Manufacturer><ImageUrlSmall \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0122961056.01.\
THUMBZZZ.jpg</ImageUrlSmall><ImageUrlMedium \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0122961056.01.\
MZZZZZZZ.jpg</ImageUrlMedium><ImageUrlLarge \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0122961056.01.\
LZZZZZZZ.jpg</ImageUrlLarge><ListPrice \
xsi:type=\"xsd:string\">$52.95</ListPrice><OurPrice \
xsi:type=\"xsd:string\">$52.95</OurPrice><UsedPrice \
xsi:type=\"xsd:string\">$38.00</UsedPrice></Details><Details \
xsi:type=\"amazon:Details\"><Url \
xsi:type=\"xsd:string\">http://www.amazon.com/exec/obidos/redirect?tag=\
webservices-20%26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=\
ASIN/0805387005</Url><Asin \
xsi:type=\"xsd:string\">0805387005</Asin><ProductName \
xsi:type=\"xsd:string\">Mathematica for Physics</ProductName><Catalog \
xsi:type=\"xsd:string\">Book</Catalog><Authors \
SOAP-ENC:arrayType=\"xsd:string[2]\" xsi:type=\"SOAP-ENC:Array\"><Author \
xsi:type=\"xsd:string\">Robert L. Zimmerman</Author><Author \
xsi:type=\"xsd:string\">Fredrick Olness</Author></Authors><ReleaseDate \
xsi:type=\"xsd:string\">31 July, 2002</ReleaseDate><Manufacturer \
xsi:type=\"xsd:string\">Addison-Wesley Pub Co</Manufacturer><ImageUrlSmall \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0805387005.01.\
THUMBZZZ.jpg</ImageUrlSmall><ImageUrlMedium \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0805387005.01.\
MZZZZZZZ.jpg</ImageUrlMedium><ImageUrlLarge \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0805387005.01.\
LZZZZZZZ.jpg</ImageUrlLarge><ListPrice \
xsi:type=\"xsd:string\">$77.00</ListPrice><OurPrice \
xsi:type=\"xsd:string\">$77.00</OurPrice><UsedPrice \
xsi:type=\"xsd:string\">$46.33</UsedPrice></Details><Details \
xsi:type=\"amazon:Details\"><Url \
xsi:type=\"xsd:string\">http://www.amazon.com/exec/obidos/redirect?tag=\
webservices-20%26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=\
ASIN/0126709610</Url><Asin \
xsi:type=\"xsd:string\">0126709610</Asin><ProductName \
xsi:type=\"xsd:string\">Mathematica for Microeconomics</ProductName><Catalog \
xsi:type=\"xsd:string\">Book</Catalog><Authors \
SOAP-ENC:arrayType=\"xsd:string[1]\" xsi:type=\"SOAP-ENC:Array\"><Author \
xsi:type=\"xsd:string\">John Robert \
Stinespring</Author></Authors><ReleaseDate xsi:type=\"xsd:string\">15 \
December, 2001</ReleaseDate><Manufacturer xsi:type=\"xsd:string\">Academic \
Press</Manufacturer><ImageUrlSmall \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0126709610.01.\
THUMBZZZ.jpg</ImageUrlSmall><ImageUrlMedium \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0126709610.01.\
MZZZZZZZ.jpg</ImageUrlMedium><ImageUrlLarge \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0126709610.01.\
LZZZZZZZ.jpg</ImageUrlLarge><ListPrice \
xsi:type=\"xsd:string\">$49.95</ListPrice><OurPrice \
xsi:type=\"xsd:string\">$49.95</OurPrice><UsedPrice \
xsi:type=\"xsd:string\">$47.13</UsedPrice></Details><Details \
xsi:type=\"amazon:Details\"><Url \
xsi:type=\"xsd:string\">http://www.amazon.com/exec/obidos/redirect?tag=\
webservices-20%26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=\
ASIN/0471266108</Url><Asin \
xsi:type=\"xsd:string\">0471266108</Asin><ProductName \
xsi:type=\"xsd:string\">Numerical and Analytical Methods for Scientists and \
Engineers, Using Mathematica</ProductName><Catalog \
xsi:type=\"xsd:string\">Book</Catalog><Authors \
SOAP-ENC:arrayType=\"xsd:string[1]\" xsi:type=\"SOAP-ENC:Array\"><Author \
xsi:type=\"xsd:string\">Daniel Dubin</Author></Authors><ReleaseDate xsi:type=\
\"xsd:string\">April, 2003</ReleaseDate><Manufacturer \
xsi:type=\"xsd:string\">John Wiley &amp; Sons</Manufacturer><ImageUrlSmall \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0471266108.01.\
THUMBZZZ.jpg</ImageUrlSmall><ImageUrlMedium \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0471266108.01.\
MZZZZZZZ.jpg</ImageUrlMedium><ImageUrlLarge \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0471266108.01.\
LZZZZZZZ.jpg</ImageUrlLarge><ListPrice \
xsi:type=\"xsd:string\">$115.00</ListPrice><OurPrice \
xsi:type=\"xsd:string\">$115.00</OurPrice></Details><Details \
xsi:type=\"amazon:Details\"><Url \
xsi:type=\"xsd:string\">http://www.amazon.com/exec/obidos/redirect?tag=\
webservices-20%26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=\
ASIN/007135719X</Url><Asin \
xsi:type=\"xsd:string\">007135719X</Asin><ProductName \
xsi:type=\"xsd:string\">Schaum&apos;s Outline of \
Mathematica</ProductName><Catalog \
xsi:type=\"xsd:string\">Book</Catalog><Authors \
SOAP-ENC:arrayType=\"xsd:string[1]\" xsi:type=\"SOAP-ENC:Array\"><Author \
xsi:type=\"xsd:string\">Eugene Don</Author></Authors><ReleaseDate \
xsi:type=\"xsd:string\">30 September, 2000</ReleaseDate><Manufacturer \
xsi:type=\"xsd:string\">McGraw-Hill Trade</Manufacturer><ImageUrlSmall \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/007135719X.01.\
THUMBZZZ.jpg</ImageUrlSmall><ImageUrlMedium \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/007135719X.01.\
MZZZZZZZ.jpg</ImageUrlMedium><ImageUrlLarge \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/007135719X.01.\
LZZZZZZZ.jpg</ImageUrlLarge><ListPrice \
xsi:type=\"xsd:string\">$16.95</ListPrice><OurPrice \
xsi:type=\"xsd:string\">$11.87</OurPrice><UsedPrice \
xsi:type=\"xsd:string\">$9.86</UsedPrice></Details><Details \
xsi:type=\"amazon:Details\"><Url \
xsi:type=\"xsd:string\">http://www.amazon.com/exec/obidos/redirect?tag=\
webservices-20%26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=\
ASIN/1891289012</Url><Asin \
xsi:type=\"xsd:string\">1891289012</Asin><ProductName \
xsi:type=\"xsd:string\">Simplifying Mathematics Using the Ti-82-83 or \
Ti-85-86</ProductName><Catalog xsi:type=\"xsd:string\">Book</Catalog><Authors \
SOAP-ENC:arrayType=\"xsd:string[2]\" xsi:type=\"SOAP-ENC:Array\"><Author \
xsi:type=\"xsd:string\">Brian E. Smith</Author><Author \
xsi:type=\"xsd:string\">Dr. Brian Smith</Author></Authors><ReleaseDate \
xsi:type=\"xsd:string\">October, 1997</ReleaseDate><Manufacturer \
xsi:type=\"xsd:string\">Math Ware</Manufacturer><ImageUrlSmall \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/1891289012.01.\
THUMBZZZ.jpg</ImageUrlSmall><ImageUrlMedium \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/1891289012.01.\
MZZZZZZZ.jpg</ImageUrlMedium><ImageUrlLarge \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/1891289012.01.\
LZZZZZZZ.jpg</ImageUrlLarge><ListPrice \
xsi:type=\"xsd:string\">$17.95</ListPrice><OurPrice \
xsi:type=\"xsd:string\">$17.95</OurPrice></Details><Details \
xsi:type=\"amazon:Details\"><Url \
xsi:type=\"xsd:string\">http://www.amazon.com/exec/obidos/redirect?tag=\
webservices-20%26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=\
ASIN/0387950206</Url><Asin \
xsi:type=\"xsd:string\">0387950206</Asin><ProductName \
xsi:type=\"xsd:string\">The Mathematica Guidebook_Bk&amp;CD Rom 3 Vol \
Set</ProductName><Catalog xsi:type=\"xsd:string\">Book</Catalog><Authors \
SOAP-ENC:arrayType=\"xsd:string[1]\" xsi:type=\"SOAP-ENC:Array\"><Author \
xsi:type=\"xsd:string\">M. Trott</Author></Authors><ReleaseDate \
xsi:type=\"xsd:string\">July, 2003</ReleaseDate><Manufacturer \
xsi:type=\"xsd:string\">Springer Verlag</Manufacturer><ImageUrlSmall \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0387950206.01.\
THUMBZZZ.jpg</ImageUrlSmall><ImageUrlMedium \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0387950206.01.\
MZZZZZZZ.jpg</ImageUrlMedium><ImageUrlLarge \
xsi:type=\"xsd:string\">http://images.amazon.com/images/P/0387950206.01.\
LZZZZZZZ.jpg</ImageUrlLarge><ListPrice \
xsi:type=\"xsd:string\">$179.00</ListPrice><OurPrice \
xsi:type=\"xsd:string\">$179.00</OurPrice></Details></Details></return></\
namesp484:KeywordSearchRequestResponse></SOAP-ENV:Body></SOAP-ENV:Envelope>"\)\
], "Print"],

Cell[BoxData[
    InterpretationBox[\("Deserializing: "\[InvisibleSpace]{2003, 4, 15, 11, 
          27, 0}\),
      SequenceForm[ "Deserializing: ", {2003, 4, 15, 11, 27, 0}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished Deserializing: "\[InvisibleSpace]{2003, 4, 
          15, 11, 27, 1}\),
      SequenceForm[ "Finished Deserializing: ", {2003, 4, 15, 11, 27, 1}],
      Editable->False]], "Print"],

Cell[BoxData[
    \({"Details" \[Rule] {{"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0521643147",\
 "Asin" \[Rule] "0521643147", "ProductName" \[Rule] "The Mathematica Book", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Stephen Wolfram"}, 
            "ReleaseDate" \[Rule] "15 March, 1999", 
            "Manufacturer" \[Rule] "Cambridge Univ Pr (Trd)", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0521643147.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0521643147.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0521643147.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$53.00", "OurPrice" \[Rule] "$37.10", 
            "UsedPrice" \[Rule] "$29.30"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0387952349",\
 "Asin" \[Rule] "0387952349", 
            "ProductName" \[Rule] "Mathematical Statistics with MATHEMATICA", 
            "Catalog" \[Rule] "Book", 
            "Authors" \[Rule] {"Colin Rose", "Murray D. Smith"}, 
            "ReleaseDate" \[Rule] "08 March, 2002", 
            "Manufacturer" \[Rule] "Springer Verlag", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0387952349.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0387952349.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0387952349.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$79.95", "OurPrice" \[Rule] "$79.95", 
            "UsedPrice" \[Rule] "$35.00"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/1558606378",\
 "Asin" \[Rule] "1558606378", 
            "ProductName" \[Rule] 
              "Illustrating Evolutionary Computation With Mathematica", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Christian Jacob"}, 
            "ReleaseDate" \[Rule] "01 February, 2001", 
            "Manufacturer" \[Rule] "Morgan Kaufmann", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/1558606378.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/1558606378.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/1558606378.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$69.95", "OurPrice" \[Rule] "$69.95", 
            "UsedPrice" \[Rule] "$57.51"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0122961056",\
 "Asin" \[Rule] "0122961056", 
            "ProductName" \[Rule] 
              "Mastering Mathematica: Programming Methods and Applications", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"John W. Gray"}, 
            "ReleaseDate" \[Rule] "January, 1998", 
            "Manufacturer" \[Rule] "Academic Press", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0122961056.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0122961056.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0122961056.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$52.95", "OurPrice" \[Rule] "$52.95", 
            "UsedPrice" \[Rule] "$38.00"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0805387005",\
 "Asin" \[Rule] "0805387005", 
            "ProductName" \[Rule] "Mathematica for Physics", 
            "Catalog" \[Rule] "Book", 
            "Authors" \[Rule] {"Robert L. Zimmerman", "Fredrick Olness"}, 
            "ReleaseDate" \[Rule] "31 July, 2002", 
            "Manufacturer" \[Rule] "Addison-Wesley Pub Co", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0805387005.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0805387005.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0805387005.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$77.00", "OurPrice" \[Rule] "$77.00", 
            "UsedPrice" \[Rule] "$46.33"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0126709610",\
 "Asin" \[Rule] "0126709610", 
            "ProductName" \[Rule] "Mathematica for Microeconomics", 
            "Catalog" \[Rule] "Book", 
            "Authors" \[Rule] {"John Robert Stinespring"}, 
            "ReleaseDate" \[Rule] "15 December, 2001", 
            "Manufacturer" \[Rule] "Academic Press", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0126709610.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0126709610.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0126709610.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$49.95", "OurPrice" \[Rule] "$49.95", 
            "UsedPrice" \[Rule] "$47.13"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0471266108",\
 "Asin" \[Rule] "0471266108", 
            "ProductName" \[Rule] 
              "Numerical and Analytical Methods for Scientists and Engineers, \
Using Mathematica", "Catalog" \[Rule] "Book", 
            "Authors" \[Rule] {"Daniel Dubin"}, 
            "ReleaseDate" \[Rule] "April, 2003", 
            "Manufacturer" \[Rule] "John Wiley & Sons", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0471266108.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0471266108.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0471266108.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$115.00", 
            "OurPrice" \[Rule] "$115.00"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/007135719X",\
 "Asin" \[Rule] "007135719X", 
            "ProductName" \[Rule] "Schaum's Outline of Mathematica", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"Eugene Don"}, 
            "ReleaseDate" \[Rule] "30 September, 2000", 
            "Manufacturer" \[Rule] "McGraw-Hill Trade", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/007135719X.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/007135719X.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/007135719X.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$16.95", "OurPrice" \[Rule] "$11.87", 
            "UsedPrice" \[Rule] "$9.86"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/1891289012",\
 "Asin" \[Rule] "1891289012", 
            "ProductName" \[Rule] 
              "Simplifying Mathematics Using the Ti-82-83 or Ti-85-86", 
            "Catalog" \[Rule] "Book", 
            "Authors" \[Rule] {"Brian E. Smith", "Dr. Brian Smith"}, 
            "ReleaseDate" \[Rule] "October, 1997", 
            "Manufacturer" \[Rule] "Math Ware", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/1891289012.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/1891289012.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/1891289012.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$17.95", 
            "OurPrice" \[Rule] "$17.95"}, {"Url" \[Rule] 
              "http://www.amazon.com/exec/obidos/redirect?tag=webservices-20%\
26creative=D3VZJS46JD5U9D%26camp=2025%26link_code=sp1%26path=ASIN/0387950206",\
 "Asin" \[Rule] "0387950206", 
            "ProductName" \[Rule] 
              "The Mathematica Guidebook_Bk&CD Rom 3 Vol Set", 
            "Catalog" \[Rule] "Book", "Authors" \[Rule] {"M. Trott"}, 
            "ReleaseDate" \[Rule] "July, 2003", 
            "Manufacturer" \[Rule] "Springer Verlag", 
            "ImageUrlSmall" \[Rule] 
              "http://images.amazon.com/images/P/0387950206.01.THUMBZZZ.jpg", 
            "ImageUrlMedium" \[Rule] 
              "http://images.amazon.com/images/P/0387950206.01.MZZZZZZZ.jpg", 
            "ImageUrlLarge" \[Rule] 
              "http://images.amazon.com/images/P/0387950206.01.LZZZZZZZ.jpg", 
            "ListPrice" \[Rule] "$179.00", 
            "OurPrice" \[Rule] "$179.00"}}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(KeywordSearchRequest[{"\<author\>" -> "\<Stephen Wolfram\>", \ \
"\<page\>" -> "\<1\>", \ "\<mode\>" -> \ "\<books\>", \ "\<tag\>" -> \
"\<webservices-20\>", "\<type\>" -> "\<lite\>", \ "\<devtag\>" -> \
"\<D3VZJS46JD5U9D\>", \ \ "\<version\>" -> "\<1.0\>"}]\)], "Input",
  CellTags->"b:0.1.1"],

Cell[BoxData[
    InterpretationBox[\("Building SOAPEnvelope: "\[InvisibleSpace]{2003, 4, 
          15, 11, 27, 25}\),
      SequenceForm[ "Building SOAPEnvelope: ", {2003, 4, 15, 11, 27, 25}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished Building SOAPEnvelope: \
"\[InvisibleSpace]{2003, 4, 15, 11, 27, 25}\),
      SequenceForm[ 
      "Finished Building SOAPEnvelope: ", {2003, 4, 15, 11, 27, 25}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("<soapenv:Envelope \
xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" \
xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \
xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \
xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">\n <soapenv:Body>\
\n  <ns0:KeywordSearchRequest \
soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" \
xmlns:ns0=\"urn:PI/DevCentral/SoapService\">\n   <KeywordSearchRequest \
xsi:type=\"ns0:KeywordRequest\">\n    <ns0:author>Stephen \
Wolfram</ns0:author>\n    <ns0:page xsi:type=\"ns1:string\" \
xmlns:ns1=\"http://www.w3.org/1999/XMLSchema\">1</ns0:page>\n    <ns0:mode \
xsi:type=\"ns2:string\" \
xmlns:ns2=\"http://www.w3.org/1999/XMLSchema\">books</ns0:mode>\n    <ns0:tag \
xsi:type=\"ns3:string\" \
xmlns:ns3=\"http://www.w3.org/1999/XMLSchema\">webservices-20</ns0:tag>\n    \
<ns0:type xsi:type=\"ns4:string\" \
xmlns:ns4=\"http://www.w3.org/1999/XMLSchema\">lite</ns0:type>\n    \
<ns0:devtag xsi:type=\"ns5:string\" \
xmlns:ns5=\"http://www.w3.org/1999/XMLSchema\">D3VZJS46JD5U9D</ns0:devtag>\n  \
  <ns0:version xsi:type=\"ns6:string\" \
xmlns:ns6=\"http://www.w3.org/1999/XMLSchema\">1.0</ns0:version>\n   \
</KeywordSearchRequest>\n  </ns0:KeywordSearchRequest>\n </soapenv:Body>\n\
</soapenv:Envelope>"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Invoking: "\[InvisibleSpace]{2003, 4, 15, 11, 27, 
          25}\),
      SequenceForm[ "Invoking: ", {2003, 4, 15, 11, 27, 25}],
      Editable->False]], "Print"],

Cell[BoxData[
    \(InvokeServiceOperation::"native" \(\(:\)\(\ \)\) 
      "An error occurred:  Bad Request"\)], "Message"],

Cell[BoxData[
    InterpretationBox[\("Finished Invoking: "\[InvisibleSpace]{2003, 4, 15, 
          11, 27, 26}\),
      SequenceForm[ "Finished Invoking: ", {2003, 4, 15, 11, 27, 26}],
      Editable->False]], "Print"],

Cell[BoxData[
    \(InvokeServiceOperation::"rspns" \(\(:\)\(\ \)\) 
      "Invoke Failed.  Response is $Failed or Null."\)], "Message"],

Cell[BoxData[
    \($Failed\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\($PrintShortErrorMessages\  = \ False;\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(KeywordSearchRequest[{"\<author\>" -> "\<Stephen Wolfram\>", \ \
"\<page\>" -> "\<1\>", \ "\<mode\>" -> \ "\<books\>", \ "\<tag\>" -> \
"\<webservices-20\>", "\<type\>" -> "\<lite\>", \ "\<devtag\>" -> \
"\<D3VZJS46JD5U9D\>", \ \ "\<version\>" -> "\<1.0\>"}]\)], "Input",
  CellTags->"b:0.1.1"],

Cell[BoxData[
    InterpretationBox[\("Building SOAPEnvelope: "\[InvisibleSpace]{2003, 4, 
          15, 11, 27, 39}\),
      SequenceForm[ "Building SOAPEnvelope: ", {2003, 4, 15, 11, 27, 39}],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("Finished Building SOAPEnvelope: \
"\[InvisibleSpace]{2003, 4, 15, 11, 27, 39}\),
      SequenceForm[ 
      "Finished Building SOAPEnvelope: ", {2003, 4, 15, 11, 27, 39}],
      Editable->False]], "Print"],

Cell[BoxData[
    \("<soapenv:Envelope \
xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" \
xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" \
xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \
xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\">\n <soapenv:Body>\
\n  <ns0:KeywordSearchRequest \
soapenv:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" \
xmlns:ns0=\"urn:PI/DevCentral/SoapService\">\n   <KeywordSearchRequest \
xsi:type=\"ns0:KeywordRequest\">\n    <ns0:author>Stephen \
Wolfram</ns0:author>\n    <ns0:page xsi:type=\"ns1:string\" \
xmlns:ns1=\"http://www.w3.org/1999/XMLSchema\">1</ns0:page>\n    <ns0:mode \
xsi:type=\"ns2:string\" \
xmlns:ns2=\"http://www.w3.org/1999/XMLSchema\">books</ns0:mode>\n    <ns0:tag \
xsi:type=\"ns3:string\" \
xmlns:ns3=\"http://www.w3.org/1999/XMLSchema\">webservices-20</ns0:tag>\n    \
<ns0:type xsi:type=\"ns4:string\" \
xmlns:ns4=\"http://www.w3.org/1999/XMLSchema\">lite</ns0:type>\n    \
<ns0:devtag xsi:type=\"ns5:string\" \
xmlns:ns5=\"http://www.w3.org/1999/XMLSchema\">D3VZJS46JD5U9D</ns0:devtag>\n  \
  <ns0:version xsi:type=\"ns6:string\" \
xmlns:ns6=\"http://www.w3.org/1999/XMLSchema\">1.0</ns0:version>\n   \
</KeywordSearchRequest>\n  </ns0:KeywordSearchRequest>\n </soapenv:Body>\n\
</soapenv:Envelope>"\)], "Print"],

Cell[BoxData[
    InterpretationBox[\("Invoking: "\[InvisibleSpace]{2003, 4, 15, 11, 27, 
          39}\),
      SequenceForm[ "Invoking: ", {2003, 4, 15, 11, 27, 39}],
      Editable->False]], "Print"],

Cell[BoxData[
    \(Java::"excptn" \(\(:\)\(\ \)\) 
      "A Java exception occurred: AxisFault\n faultCode: \
{http://schemas.xmlsoap.org/soap/envelope/}Client\n faultSubcode: \n \
faultString: Bad Request\n faultActor: null\n faultNode: null\n faultDetail: \
\n\tstackTrace: AxisFault\n faultCode: \
{http://schemas.xmlsoap.org/soap/envelope/}Client\n faultSubcode: \n \
faultString: Bad Request\n faultActor: null\n faultNode: null\n faultDetail: \
\n\nBad Request\n\tat \
org.apache.axis.message.SOAPFaultBuilder.createFault(SOAPFaultBuilder.java:\
228)\n\tat \
org.apache.axis.message.SOAPFaultBuilder.endElement(SOAPFaultBuilder.java:147)\
\n\tat org.apache.axis.encoding.DeserializationContextImpl.endElement(\
DeserializationContextImpl.java:961)\n\tat \
org.apache.xerces.parsers.AbstractSAXParser.endElement(AbstractSAXParser.java:\
559)\n\tat \
org.apache.xerces.impl.XMLNamespaceBinder.handleEndElement(XMLNamespaceBinder.\
java:853)\n\tat \
org.apache.xerces.impl.XMLNamespaceBinder.endElement(XMLNamespaceBinder.java:\
643)\n\tat \
org.apache.xerces.impl.dtd.XMLDTDValidator.handleEndElement(XMLDTDValidator.\
java:2978)\n\tat \
org.apache.xerces.impl.dtd.XMLDTDValidator.endElement(XMLDTDValidator.java:\
918)\n\tat \
org.apache.xerces.impl.XMLDocumentFragmentScannerImpl.handleEndElement(\
XMLDocumentFragmentScannerImpl.java:1145)\n\tat \
org.apache.xerces.impl.XMLDocumentFragmentScannerImpl.scanEndElement(\
XMLDocumentFragmentScannerImpl.java:988)\n\tat \
org.apache.xerces.impl.XMLDocumentFragmentScannerImpl$\
FragmentContentDispatcher.dispatch(XMLDocumentFragmentScannerImpl.java:1446)\n\
\tat org.apache.xerces.impl.XMLDocumentFragmentScannerImpl.scanDocument(\
XMLDocumentFragmentScannerImpl.java:333)\n\tat \
org.apache.xerces.parsers.StandardParserConfiguration.parse(\
StandardParserConfiguration.java:529)\n\tat \
org.apache.xerces.parsers.StandardParserConfiguration.parse(\
StandardParserConfiguration.java:585)\n\tat \
org.apache.xerces.parsers.XMLParser.parse(XMLParser.java:147)\n\tat \
org.apache.xerces.parsers.AbstractSAXParser.parse(AbstractSAXParser.java:1148)\
\n\tat javax.xml.parsers.SAXParser.parse(Unknown Source)\n\tat \
org.apache.axis.encoding.DeserializationContextImpl.parse(\
DeserializationContextImpl.java:236)\n\tat \
org.apache.axis.SOAPPart.getAsSOAPEnvelope(SOAPPart.java:541)\n\tat \
org.apache.axis.Message.getSOAPEnvelope(Message.java:379)\n\tat \
org.apache.axis.client.Call.invokeEngine(Call.java:2395)\n\tat \
org.apache.axis.client.Call.invoke(Call.java:2365)\n\tat \
org.apache.axis.client.Call.invoke(Call.java:1568)\n\tat \
sun.reflect.GeneratedMethodAccessor4.invoke(Unknown Source)\n\tat \
sun.reflect.DelegatingMethodAccessorImpl.invoke(Unknown Source)\n\n\nBad \
Request\n\tat \
org.apache.axis.message.SOAPFaultBuilder.createFault(SOAPFaultBuilder.java:\
228)\n\tat \
org.apache.axis.message.SOAPFaultBuilder.endElement(SOAPFaultBuilder.java:147)\
\n\tat org.apache.axis.encoding.DeserializationContextImpl.endElement(\
DeserializationContextImpl.java:961)\n\tat \
org.apache.xerces.parsers.AbstractSAXParser.endElement(AbstractSAXParser.java:\
559)\n\tat \
org.apache.xerces.impl.XMLNamespaceBinder.handleEndElement(XMLNamespaceBinder.\
java:853)\n\tat \
org.apache.xerces.impl.XMLNamespaceBinder.endElement(XMLNamespaceBinder.java:\
643)\n\tat \
org.apache.xerces.impl.dtd.XMLDTDValidator.handleEndElement(XMLDTDValidator.\
java:2978)\n\tat \
org.apache.xerces.impl.dtd.XMLDTDValidator.endElement(XMLDTDValidator.java:\
918)\n\tat \
org.apache.xerces.impl.XMLDocumentFragmentScannerImpl.handleEndElement(\
XMLDocumentFragmentScannerImpl.java:1145)\n\tat \
org.apache.xerces.impl.XMLDocumentFragmentScannerImpl.scanEndElement(\
XMLDocumentFragmentScannerImpl.java:988)\n\tat \
org.apache.xerces.impl.XMLDocumentFragmentScannerImpl$\
FragmentContentDispatcher.dispatch(XMLDocumentFragmentScannerImpl.java:1446)\n\
\tat org.apache.xerces.impl.XMLDocumentFragmentScannerImpl.scanDocument(\
XMLDocumentFragmentScannerImpl.java:333)\n\tat \
org.apache.xerces.parsers.StandardParserConfiguration.parse(\
StandardParserConfiguration.java:529)\n\tat \
org.apache.xerces.parsers.StandardParserConfiguration.parse(\
StandardParserConfiguration.java:585)\n\tat \
org.apache.xerces.parsers.XMLParser.parse(XMLParser.java:147)\n\tat \
org.apache.xerces.parsers.AbstractSAXParser.parse(AbstractSAXParser.java:1148)\
\n\tat javax.xml.parsers.SAXParser.parse(Unknown Source)\n\tat \
org.apache.axis.encoding.DeserializationContextImpl.parse(\
DeserializationContextImpl.java:236)\n\tat \
org.apache.axis.SOAPPart.getAsSOAPEnvelope(SOAPPart.java:541)\n\tat \
org.apache.axis.Message.getSOAPEnvelope(Message.java:379)\n\tat \
org.apache.axis.client.Call.invokeEngine(Call.java:2395)\n\tat \
org.apache.axis.client.Call.invoke(Call.java:2365)\n\tat \
org.apache.axis.client.Call.invoke(Call.java:1568)\n\tat \
sun.reflect.GeneratedMethodAccessor4.invoke(Unknown Source)\n\tat \
sun.reflect.DelegatingMethodAccessorImpl.invoke(Unknown Source)."\)], \
"Message"],

Cell[BoxData[
    InterpretationBox[\("Finished Invoking: "\[InvisibleSpace]{2003, 4, 15, 
          11, 27, 40}\),
      SequenceForm[ "Finished Invoking: ", {2003, 4, 15, 11, 27, 40}],
      Editable->False]], "Print"],

Cell[BoxData[
    \(InvokeServiceOperation::"rspns" \(\(:\)\(\ \)\) 
      "Invoke Failed.  Response is $Failed or Null."\)], "Message"],

Cell[BoxData[
    \($Failed\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 979}},
WindowSize->{496, 740},
WindowMargins->{{33, Automatic}, {Automatic, 11}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "b:0.1.0"->{
    Cell[2683, 103, 128, 3, 50, "Input",
      CellTags->"b:0.1.0"]},
  "Info3259394655-1050866"->{
    Cell[2946, 117, 382, 6, 82, "Print",
      CellTags->"Info3259394655-1050866"]},
  "b:0.1.1"->{
    Cell[3637, 142, 133, 3, 70, "Input",
      CellTags->"b:0.1.1"],
    Cell[4110, 156, 80, 2, 30, "Input",
      CellTags->"b:0.1.1"],
    Cell[4591, 170, 313, 5, 110, "Input",
      CellTags->"b:0.1.1"],
    Cell[30741, 783, 133, 3, 70, "Input",
      CellTags->"b:0.1.1"],
    Cell[60198, 1596, 311, 5, 110, "Input",
      CellTags->"b:0.1.1"],
    Cell[85847, 2052, 314, 5, 110, "Input",
      CellTags->"b:0.1.1"],
    Cell[88813, 2126, 314, 5, 110, "Input",
      CellTags->"b:0.1.1"]},
  "Info3259394669-3242290"->{
    Cell[4193, 160, 361, 5, 82, "Print",
      CellTags->"Info3259394669-3242290"]},
  "b:0.3.1"->{
    Cell[25591, 597, 154, 3, 70, "Input",
      CellTags->"b:0.3.1"],
    Cell[25829, 608, 73, 2, 30, "Input",
      CellTags->"b:0.3.1"],
    Cell[25993, 618, 82, 2, 30, "Input",
      CellTags->"b:0.3.1"],
    Cell[26155, 628, 175, 4, 90, "Input",
      CellTags->"b:0.3.1"],
    Cell[26458, 640, 135, 3, 50, "Input",
      CellTags->"b:0.3.1"]},
  "b:0.3.4"->{
    Cell[26757, 656, 127, 3, 50, "Input",
      CellTags->"b:0.3.4"],
    Cell[27293, 671, 74, 2, 30, "Input",
      CellTags->"b:0.3.4"],
    Cell[28155, 690, 112, 2, 30, "Input",
      CellTags->"b:0.3.4"],
    Cell[28292, 696, 74, 2, 30, "Input",
      CellTags->"b:0.3.4"],
    Cell[29138, 716, 103, 2, 30, "Input",
      CellTags->"b:0.3.4"],
    Cell[29341, 726, 94, 2, 30, "Input",
      CellTags->"b:0.3.4"],
    Cell[29496, 734, 111, 2, 30, "Input",
      CellTags->"b:0.3.4"],
    Cell[29632, 740, 74, 2, 30, "Input",
      CellTags->"b:0.3.4"],
    Cell[30174, 756, 96, 2, 30, "Input",
      CellTags->"b:0.3.4"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"b:0.1.0", 97187, 2298},
  {"Info3259394655-1050866", 97287, 2301},
  {"b:0.1.1", 97387, 2304},
  {"Info3259394669-3242290", 97911, 2319},
  {"b:0.3.1", 98011, 2322},
  {"b:0.3.4", 98375, 2333}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 39, 0, 115, "Title"],
Cell[1818, 55, 63, 0, 59, "Section"],

Cell[CellGroupData[{
Cell[1906, 59, 34, 0, 59, "Section"],
Cell[1943, 61, 48, 1, 30, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2028, 67, 71, 0, 59, "Section"],

Cell[CellGroupData[{
Cell[2124, 71, 65, 1, 30, "Input"],
Cell[2192, 74, 75, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2304, 80, 71, 1, 30, "Input"],
Cell[2378, 83, 37, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2452, 89, 71, 1, 30, "Input"],
Cell[2526, 92, 35, 1, 29, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[2610, 99, 48, 0, 59, "Section"],

Cell[CellGroupData[{
Cell[2683, 103, 128, 3, 50, "Input",
  CellTags->"b:0.1.0"],
Cell[2814, 108, 45, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2896, 114, 47, 1, 30, "Input"],
Cell[2946, 117, 382, 6, 82, "Print",
  CellTags->"Info3259394655-1050866"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3365, 128, 87, 1, 30, "Input"],
Cell[3455, 131, 58, 1, 29, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[3562, 138, 50, 0, 59, "Section"],

Cell[CellGroupData[{
Cell[3637, 142, 133, 3, 70, "Input",
  CellTags->"b:0.1.1"],
Cell[3773, 147, 300, 4, 124, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4110, 156, 80, 2, 30, "Input",
  CellTags->"b:0.1.1"],
Cell[4193, 160, 361, 5, 82, "Print",
  CellTags->"Info3259394669-3242290"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4591, 170, 313, 5, 110, "Input",
  CellTags->"b:0.1.1"],
Cell[4907, 177, 9561, 157, 3126, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14517, 340, 44, 0, 59, "Section"],

Cell[CellGroupData[{
Cell[14586, 344, 110, 2, 70, "Input"],
Cell[14699, 348, 46, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14782, 354, 86, 1, 30, "Input"],
Cell[14871, 357, 935, 17, 257, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15843, 379, 67, 1, 30, "Input"],
Cell[15913, 382, 1988, 30, 770, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17938, 417, 62, 1, 30, "Input"],
Cell[18003, 420, 952, 13, 352, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18992, 438, 93, 1, 30, "Input"],
Cell[19088, 441, 1988, 30, 770, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21113, 476, 62, 1, 30, "Input"],
Cell[21178, 479, 952, 13, 352, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22179, 498, 53, 0, 59, "Section"],

Cell[CellGroupData[{
Cell[22257, 502, 329, 6, 150, "Input"],
Cell[22589, 510, 810, 15, 238, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23436, 530, 148, 3, 70, "Input"],
Cell[23587, 535, 1076, 18, 352, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24700, 558, 62, 1, 30, "Input"],
Cell[24765, 561, 38, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24840, 567, 416, 8, 190, "Input"],
Cell[25259, 577, 52, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25348, 583, 64, 1, 30, "Input"],
Cell[25415, 586, 38, 1, 29, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[25502, 593, 64, 0, 59, "Section"],

Cell[CellGroupData[{
Cell[25591, 597, 154, 3, 70, "Input",
  CellTags->"b:0.3.1"],
Cell[25748, 602, 44, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25829, 608, 73, 2, 30, "Input",
  CellTags->"b:0.3.1"],
Cell[25905, 612, 51, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25993, 618, 82, 2, 30, "Input",
  CellTags->"b:0.3.1"],
Cell[26078, 622, 40, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26155, 628, 175, 4, 90, "Input",
  CellTags->"b:0.3.1"],
Cell[26333, 634, 88, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26458, 640, 135, 3, 50, "Input",
  CellTags->"b:0.3.1"],
Cell[26596, 645, 41, 1, 29, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26686, 652, 46, 0, 59, "Section"],

Cell[CellGroupData[{
Cell[26757, 656, 127, 3, 50, "Input",
  CellTags->"b:0.3.4"],
Cell[26887, 661, 369, 5, 143, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27293, 671, 74, 2, 30, "Input",
  CellTags->"b:0.3.4"],
Cell[27370, 675, 770, 12, 276, "Output"]
}, Open  ]],
Cell[28155, 690, 112, 2, 30, "Input",
  CellTags->"b:0.3.4"],

Cell[CellGroupData[{
Cell[28292, 696, 74, 2, 30, "Input",
  CellTags->"b:0.3.4"],
Cell[28369, 700, 732, 11, 276, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29138, 716, 103, 2, 30, "Input",
  CellTags->"b:0.3.4"],
Cell[29244, 720, 60, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29341, 726, 94, 2, 30, "Input",
  CellTags->"b:0.3.4"],
Cell[29438, 730, 43, 1, 29, "Output"]
}, Open  ]],
Cell[29496, 734, 111, 2, 30, "Input",
  CellTags->"b:0.3.4"],

Cell[CellGroupData[{
Cell[29632, 740, 74, 2, 30, "Input",
  CellTags->"b:0.3.4"],
Cell[29709, 744, 428, 7, 162, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[30174, 756, 96, 2, 30, "Input",
  CellTags->"b:0.3.4"],
Cell[30273, 760, 60, 1, 29, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30382, 767, 46, 0, 59, "Section"],
Cell[30431, 769, 69, 1, 30, "Input"],
Cell[30503, 772, 70, 1, 30, "Input"],
Cell[30576, 775, 73, 1, 30, "Input"],
Cell[30652, 778, 64, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[30741, 783, 133, 3, 70, "Input",
  CellTags->"b:0.1.1"],
Cell[30877, 788, 222, 4, 25, "Print"],
Cell[31102, 794, 147, 3, 25, "Print"],
Cell[31252, 799, 260, 5, 44, "Print"],
Cell[31515, 806, 143, 3, 25, "Print"],
Cell[31661, 811, 193, 4, 25, "Print"],
Cell[31857, 817, 179, 3, 25, "Print"],
Cell[32039, 822, 223, 4, 25, "Print"],
Cell[32265, 828, 221, 4, 25, "Print"],
Cell[32489, 834, 145, 3, 25, "Print"],
Cell[32637, 839, 199, 4, 25, "Print"],
Cell[32839, 845, 219, 4, 25, "Print"],
Cell[33061, 851, 155, 3, 25, "Print"],
Cell[33219, 856, 252, 5, 44, "Print"],
Cell[33474, 863, 215, 4, 25, "Print"],
Cell[33692, 869, 171, 3, 25, "Print"],
Cell[33866, 874, 159, 3, 25, "Print"],
Cell[34028, 879, 282, 7, 44, "Print"],
Cell[34313, 888, 520, 10, 63, "Print"],
Cell[34836, 900, 252, 5, 25, "Print"],
Cell[35091, 907, 205, 4, 25, "Print"],
Cell[35299, 913, 219, 4, 25, "Print"],
Cell[35521, 919, 155, 3, 25, "Print"],
Cell[35679, 924, 252, 5, 44, "Print"],
Cell[35934, 931, 215, 4, 25, "Print"],
Cell[36152, 937, 171, 3, 25, "Print"],
Cell[36326, 942, 159, 3, 25, "Print"],
Cell[36488, 947, 292, 7, 44, "Print"],
Cell[36783, 956, 532, 10, 82, "Print"],
Cell[37318, 968, 252, 5, 25, "Print"],
Cell[37573, 975, 193, 4, 25, "Print"],
Cell[37769, 981, 219, 4, 25, "Print"],
Cell[37991, 987, 155, 3, 25, "Print"],
Cell[38149, 992, 252, 5, 44, "Print"],
Cell[38404, 999, 215, 4, 25, "Print"],
Cell[38622, 1005, 171, 3, 25, "Print"],
Cell[38796, 1010, 159, 3, 25, "Print"],
Cell[38958, 1015, 260, 5, 44, "Print"],
Cell[39221, 1022, 508, 10, 63, "Print"],
Cell[39732, 1034, 252, 5, 25, "Print"],
Cell[39987, 1041, 191, 4, 25, "Print"],
Cell[40181, 1047, 219, 4, 25, "Print"],
Cell[40403, 1053, 155, 3, 25, "Print"],
Cell[40561, 1058, 252, 5, 44, "Print"],
Cell[40816, 1065, 215, 4, 25, "Print"],
Cell[41034, 1071, 171, 3, 25, "Print"],
Cell[41208, 1076, 159, 3, 25, "Print"],
Cell[41370, 1081, 258, 5, 44, "Print"],
Cell[41631, 1088, 504, 10, 63, "Print"],
Cell[42138, 1100, 252, 5, 25, "Print"],
Cell[42393, 1107, 197, 4, 25, "Print"],
Cell[42593, 1113, 219, 4, 25, "Print"],
Cell[42815, 1119, 155, 3, 25, "Print"],
Cell[42973, 1124, 252, 5, 44, "Print"],
Cell[43228, 1131, 215, 4, 25, "Print"],
Cell[43446, 1137, 171, 3, 25, "Print"],
Cell[43620, 1142, 159, 3, 25, "Print"],
Cell[43782, 1147, 273, 6, 44, "Print"],
Cell[44058, 1155, 516, 10, 63, "Print"],
Cell[44577, 1167, 252, 5, 25, "Print"],
Cell[44832, 1174, 197, 4, 25, "Print"],
Cell[45032, 1180, 219, 4, 25, "Print"],
Cell[45254, 1186, 155, 3, 25, "Print"],
Cell[45412, 1191, 252, 5, 44, "Print"],
Cell[45667, 1198, 215, 4, 25, "Print"],
Cell[45885, 1204, 171, 3, 25, "Print"],
Cell[46059, 1209, 159, 3, 25, "Print"],
Cell[46221, 1214, 273, 6, 44, "Print"],
Cell[46497, 1222, 516, 10, 63, "Print"],
Cell[47016, 1234, 252, 5, 25, "Print"],
Cell[47271, 1241, 195, 4, 25, "Print"],
Cell[47469, 1247, 219, 4, 25, "Print"],
Cell[47691, 1253, 155, 3, 25, "Print"],
Cell[47849, 1258, 252, 5, 44, "Print"],
Cell[48104, 1265, 215, 4, 25, "Print"],
Cell[48322, 1271, 171, 3, 25, "Print"],
Cell[48496, 1276, 159, 3, 25, "Print"],
Cell[48658, 1281, 269, 6, 44, "Print"],
Cell[48930, 1289, 512, 10, 63, "Print"],
Cell[49445, 1301, 252, 5, 25, "Print"],
Cell[49700, 1308, 209, 4, 25, "Print"],
Cell[49912, 1314, 219, 4, 25, "Print"],
Cell[50134, 1320, 155, 3, 25, "Print"],
Cell[50292, 1325, 252, 5, 44, "Print"],
Cell[50547, 1332, 215, 4, 25, "Print"],
Cell[50765, 1338, 171, 3, 25, "Print"],
Cell[50939, 1343, 159, 3, 25, "Print"],
Cell[51101, 1348, 296, 7, 44, "Print"],
Cell[51400, 1357, 540, 10, 82, "Print"],
Cell[51943, 1369, 252, 5, 25, "Print"],
Cell[52198, 1376, 201, 4, 25, "Print"],
Cell[52402, 1382, 219, 4, 25, "Print"],
Cell[52624, 1388, 155, 3, 25, "Print"],
Cell[52782, 1393, 252, 5, 44, "Print"],
Cell[53037, 1400, 215, 4, 25, "Print"],
Cell[53255, 1406, 171, 3, 25, "Print"],
Cell[53429, 1411, 159, 3, 25, "Print"],
Cell[53591, 1416, 288, 7, 44, "Print"],
Cell[53882, 1425, 524, 10, 63, "Print"],
Cell[54409, 1437, 252, 5, 25, "Print"],
Cell[54664, 1444, 203, 4, 25, "Print"],
Cell[54870, 1450, 219, 4, 25, "Print"],
Cell[55092, 1456, 155, 3, 25, "Print"],
Cell[55250, 1461, 252, 5, 44, "Print"],
Cell[55505, 1468, 215, 4, 25, "Print"],
Cell[55723, 1474, 171, 3, 25, "Print"],
Cell[55897, 1479, 159, 3, 25, "Print"],
Cell[56059, 1484, 290, 7, 44, "Print"],
Cell[56352, 1493, 528, 10, 63, "Print"],
Cell[56883, 1505, 252, 5, 25, "Print"],
Cell[57138, 1512, 205, 4, 25, "Print"],
Cell[57346, 1518, 219, 4, 25, "Print"],
Cell[57568, 1524, 155, 3, 25, "Print"],
Cell[57726, 1529, 252, 5, 44, "Print"],
Cell[57981, 1536, 215, 4, 25, "Print"],
Cell[58199, 1542, 171, 3, 25, "Print"],
Cell[58373, 1547, 159, 3, 25, "Print"],
Cell[58535, 1552, 292, 7, 44, "Print"],
Cell[58830, 1561, 532, 10, 82, "Print"],
Cell[59365, 1573, 252, 5, 25, "Print"],
Cell[59620, 1580, 238, 5, 25, "Print"],
Cell[59861, 1587, 300, 4, 124, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[60198, 1596, 311, 5, 110, "Input",
  CellTags->"b:0.1.1"],
Cell[60512, 1603, 228, 4, 25, "Print"],
Cell[60743, 1609, 244, 5, 25, "Print"],
Cell[60990, 1616, 1390, 24, 538, "Print"],
Cell[62383, 1642, 202, 4, 25, "Print"],
Cell[62588, 1648, 218, 4, 25, "Print"],
Cell[62809, 1654, 13030, 219, 4737, "Print"],
Cell[75842, 1875, 210, 4, 25, "Print"],
Cell[76055, 1881, 228, 4, 25, "Print"],
Cell[76286, 1887, 9524, 160, 3088, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[85847, 2052, 314, 5, 110, "Input",
  CellTags->"b:0.1.1"],
Cell[86164, 2059, 228, 4, 25, "Print"],
Cell[86395, 2065, 244, 5, 25, "Print"],
Cell[86642, 2072, 1319, 23, 519, "Print"],
Cell[87964, 2097, 202, 4, 25, "Print"],
Cell[88169, 2103, 124, 2, 42, "Message"],
Cell[88296, 2107, 220, 4, 25, "Print"],
Cell[88519, 2113, 136, 2, 42, "Message"],
Cell[88658, 2117, 41, 1, 29, "Output"]
}, Open  ]],
Cell[88714, 2121, 74, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[88813, 2126, 314, 5, 110, "Input",
  CellTags->"b:0.1.1"],
Cell[89130, 2133, 228, 4, 25, "Print"],
Cell[89361, 2139, 244, 5, 25, "Print"],
Cell[89608, 2146, 1319, 23, 519, "Print"],
Cell[90930, 2171, 202, 4, 25, "Print"],
Cell[91135, 2177, 5013, 88, 2472, "Message"],
Cell[96151, 2267, 220, 4, 25, "Print"],
Cell[96374, 2273, 136, 2, 42, "Message"],
Cell[96513, 2277, 41, 1, 29, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

