(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     65924,       1978]*)
(*NotebookOutlinePosition[    153816,       4912]*)
(*  CellTagsIndexPosition[    153733,       4906]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell["Web Services - Part 2", "Title"],

Cell["Chris Williamson", "Author"],

Cell["Wolfram Research", "Affiliation"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Recap of Part 1", "Section"],

Cell[TextData[{
  "In part 1, you learned how to invoke a web service in ",
  StyleBox["Mathematica ",
    FontSlant->"Italic"],
  "using simple and compound types.  You also learned how web services are \
useful for retrieving data and invoking new functionality in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["What does Part 2 cover?", "Section"],

Cell[TextData[{
  "In part 2, you will learn how web services work using Web Services \
Package.  You will learn to work with web services messages directly and \
build a web services ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function.  "
}], "Text"],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["How do web services work?", "Section"],

Cell["\<\
1.  The Web Services Package takes user input and creates an XML \
message.\
\>", "Text"],

Cell["\<\
2.  The Web Services Package sends the XML message to the server \
hosting the web service.\
\>", "Text"],

Cell["\<\
3.  The server processes the request and builds an XML response \
message.\
\>", "Text"],

Cell["\<\
4.  The server sends the response back over HTTP to the Web \
Services Package.\
\>", "Text"],

Cell["\<\
5.  The Web Services Package processes the message and returns the \
result to the user.\
\>", "Text"],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Creating Request Messages", "Section"],

Cell[TextData[{
  "If a service has been installed, ",
  StyleBox["ToServiceRequest",
    FontFamily->"Courier New"],
  " can be used to create an XML message without sending it to the server.  \
",
  StyleBox["ToServiceRequest",
    FontFamily->"Courier New"],
  " takes the function and the functions parameters as its parameters.  The \
XML message generated is a SOAP message."
}], "Text"],

Cell[BoxData[{
    \(\(<< WebServices`;\)\), "\[IndentingNewLine]", 
    \(\(InstallService["\<http://www.xmethods.net/sd/2001/TemperatureService.\
wsdl\>"];\)\), "\[IndentingNewLine]", 
    \(msg\  = \ ToServiceRequest[getTemp, "\<61821\>"]\)}], "Input",
  CellLabel->"In[1]:="],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["What is SOAP?", "Section"],

Cell[TextData[{
  "Simple Object Access Protocol (SOAP) is a web services specification that \
formally specifies the conventions governing the format, processing rules, \
and communication of the XML messages used for web services.  Without SOAP, \
applications could process the SOAP messages incorrectly.  More information \
on SOAP may be found at ",
  StyleBox[ButtonBox["http://www.w3.org/TR/SOAP/",
    ButtonData:>{
      URL[ "http://www.w3.org/TR/SOAP/"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  "."
}], "Text"],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Creating Request Messages Manually", "Section"],

Cell[TextData[{
  "Using SOAP you can create a symbolic XML request message manually.   This \
is very useful if for some reason a web service does not work well with the \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions described in Part 1.  When creating messages manually it is \
useful to be familiar with SOAP as the message must follow the SOAP \
guidelines.  Often ",
  StyleBox["ToServiceRequest",
    FontFamily->"Courier New"],
  " can be used as a starting point."
}], "Text"],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Sending Request Messages", "Section"],

Cell[TextData[{
  "If a service has been installed, ",
  StyleBox["InvokeServiceOperation",
    FontFamily->"Courier New"],
  " can be used to send an XML message to the server.  ",
  StyleBox["InvokeServiceOperation",
    FontFamily->"Courier New"],
  " takes the function and an XML message as its parameters.  The function \
specifies certain attributes about the web service such as the URL to send \
the message to.  The XML response message is returned from the function.  The \
XML message returned is a SOAP message."
}], "Text"],

Cell[BoxData[
    \(response\  = \ InvokeServiceOperation[getTemp, \ msg]\)], "Input",
  CellLabel->"In[4]:="],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Processing Response Messages", "Section"],

Cell[TextData[{
  StyleBox["FromServiceResponse",
    FontFamily->"Courier New"],
  " can be used to process the XML response message.  ",
  StyleBox["FromServiceResponse",
    FontFamily->"Courier New"],
  " takes the response message its parameter.  The function returns a data \
type defined by the response or specified as an option."
}], "Text"],

Cell[BoxData[
    \(FromServiceResponse[response]\)], "Input",
  CellLabel->"In[5]:="],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Processing Response Messages Manually", "Section"],

Cell[TextData[{
  "Using SOAP you can process a symbolic XML response message manually as \
well. This is very useful if for some reason a web service's response does \
not work well with the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " functions described in Part 1. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " provides great tools for extracting and transforming data."
}], "Text"],

Cell[BoxData[
    \(First[
      Cases[response, \ 
        XMLElement[{"\<\>", "\<return\>"}, {___}, {val_String}] \
\[RuleDelayed] ToExpression[val], \ Infinity]]\)], "Input",
  CellLabel->"In[6]:="],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["What is WSDL?", "Section"],

Cell[TextData[{
  "Web Service Description Language (WSDL) is a web services specification \
that formally sets the rules for describing a web service. A WSDL is \
important because it lets the Web Services Package easily bind to a web \
service and use it. Without a WSDL, the Web Services Package does not know \
how to use a web service unless you manually tell it.  More information on \
WSDL may be found at ",
  StyleBox[ButtonBox["http://www.w3.org/TR/wsdl",
    ButtonData:>{
      URL[ "http://www.w3.org/TR/wsdl"], None},
    ButtonStyle->"Hyperlink"],
    FontVariations->{"Underline"->True}],
  "."
}], "Text"],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Working without a WSDL", "Section"],

Cell["\<\
There are different ways of retrieving information describing a web \
service. A WSDL file is the best way, but if a WSDL file doesn't work \
correctly or a WSDL file is not available it is still possible to use a web \
service.  If a WSDL doesn't work properly, it is possible to extract some \
useful data from it by examining it.  If a WSDL file is not available, the \
information needed to use the web service may be available on a web site or \
may be found by examining code.\
\>", "Text"],

Cell[TextData[{
  "For this example, we will extract useful information from a ",
  ButtonBox["WSDL",
    ButtonData:>{
      URL[ "http://www.xmethods.net/sd/2001/TemperatureService.wsdl"], None},
    ButtonStyle->"Hyperlink"],
  " and manually set up a web service call.  ",
  StyleBox["ToServiceRequest",
    FontFamily->"Courier New"],
  " can be used to build an XML message.  ",
  StyleBox["ToServiceRequest",
    FontFamily->"Courier New"],
  " takes three parameters: the function parameters, the headers, and the \
options.  Using the WSDL we discover this function expects a parameter called \
zipcode.  Also it is necessary to always specify the ",
  StyleBox["OperationName",
    FontFamily->"Courier New"],
  ".  ",
  StyleBox["OperationName",
    FontFamily->"Courier New"],
  " is always a qualified name.  This means it always has a namespace \
associated with the operation name.  ",
  StyleBox["OperationName",
    FontFamily->"Courier New"],
  " is also found in the WSDL. There are other options that may be required \
to use a web service in this way.  "
}], "Text"],

Cell[BoxData[
    \(msg = \ 
      ToServiceRequest[\[IndentingNewLine]{"\<zipcode\>" -> "\<61821\>"}, \
\[IndentingNewLine]{}, \ \[IndentingNewLine]OperationName -> \
{"\<urn:xmethods-Temperature\>", "\<getTemp\>"}]\)], "Input",
  CellLabel->"In[7]:="],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Working without a WSDL (cont)", "Section"],

Cell[TextData[{
  StyleBox["InvokeServiceOperation",
    FontFamily->"Courier New"],
  " can be used to send the message to the server.  ",
  StyleBox["InvokeServiceOperation",
    FontFamily->"Courier New"],
  " requires two parameters: an endpoint and the message.  The endpoint may \
be found in the WSDL.  "
}], "Text"],

Cell[BoxData[
    \(response\  = \ 
      InvokeServiceOperation["\<http://services.xmethods.net:80/soap/servlet/\
rpcrouter\>", \ msg]\)], "Input",
  CellLabel->"In[8]:="],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Working without a WSDL (cont)", "Section"],

Cell[TextData[{
  StyleBox["FromServiceResponse",
    FontFamily->"Courier New"],
  " can be used to process the response message.  ",
  StyleBox["FromServiceResponse",
    FontFamily->"Courier New"],
  " requires just one parameter: the response message.  However, often it is \
useful to specify the option ",
  StyleBox["ReturnType",
    FontFamily->"Courier New"],
  ". ",
  StyleBox["ReturnType",
    FontFamily->"Courier New"],
  " specifies the datatype of the result."
}], "Text"],

Cell[BoxData[
    \(FromServiceResponse[response, \ 
      ReturnType \[Rule] {"\<http://www.w3.org/2001/XMLSchema\>", \
"\<float\>"}]\)], "Input",
  CellLabel->"In[9]:="],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Long Form", "Section"],

Cell[TextData[{
  "Normally data is specified using the simple form of rule syntax. ",
  StyleBox["LongForm",
    FontFamily->"Courier New"],
  " can be used to specify input with attributes.  Attributes can be useful \
to annotate data. You can specify a type or an encoding using attributes.  \
Attributes can specified in simple rule syntax."
}], "Text"],

Cell["{name_String, attributes:{___}}->value_", "Text"],

Cell["{{namespace_String, name_String}, attributes:{___}}->value_", "Text"],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Installing an Operation", "Section"],

Cell[TextData[{
  StyleBox["InstallServiceOperation",
    FontFamily->"Courier New"],
  " can be used to install a web service operation as a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function.  ",
  StyleBox["InstallServiceOperation",
    FontFamily->"Courier New"],
  " requires four parameters: the symbol specifying the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " function to bind the web service operation to, the endpoint to send \
messages, the parameters for the web service operation, and any headers \
required.  However, often it is also useful to specify options.  The \
parameters are specified using the left hand side of the rule syntax.  Using \
",
  StyleBox["LongForm",
    FontFamily->"Courier New"],
  " you can annotate the parameters with useful information such as data \
type.  ",
  StyleBox["OperationName",
    FontFamily->"Courier New"],
  " is important for most web services and ",
  StyleBox["ReturnType",
    FontFamily->"Courier New"],
  " can help convert the results into a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " data type."
}], "Text"],

Cell[BoxData[
    \(InstallServiceOperation[\[IndentingNewLine]TempService`getTemperature, \
\ \[IndentingNewLine]"\<http://services.xmethods.net:80/soap/servlet/\
rpcrouter\>", \ \[IndentingNewLine]{{"\<zipcode\>", \
{{"\<http://www.w3.org/2001/XMLSchema-instance\>", \ "\<type\>"} \[Rule] \
{"\<http://www.w3.org/2001/XMLSchema\>", "\<string\>"}}}}, {}, \
\[IndentingNewLine]OperationName -> {"\<urn:xmethods-Temperature\>", \
"\<getTemp\>"}, \ \[IndentingNewLine]ReturnType\  \[Rule] \ \
{"\<http://www.w3.org/2001/XMLSchema\>", "\<string\>"}]\)], "Input",
  CellLabel->"In[10]:="],

Cell[BoxData[
    \(getTemperature["\<61821\>"]\)], "Input",
  CellLabel->"In[11]:="],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Exercises", "Section"],

Cell["\<\
Here are some exercises to work on that focus on using web services \
with compound data types.\
\>", "Text",
  CellDingbat->None],

Cell[CellGroupData[{

Cell["1. Find the distance between zip codes", "Subsection"],

Cell["\<\
Using the information supplied below create a web service function \
that calculates the distance between two zip codes.\
\>", "Text"],

Cell[TextData[{
  StyleBox["Endpoint:",
    FontWeight->"Bold"],
  " ",
  "http://webservices.imacination.com/distance/Distance.jws"
}], "Text"],

Cell[TextData[{
  StyleBox["Operation Name:",
    FontWeight->"Bold"],
  " ",
  "getDistance"
}], "Text"],

Cell[TextData[{
  StyleBox["Operation Namespace:",
    FontWeight->"Bold"],
  " ",
  "http://DefaultNamespace"
}], "Text"],

Cell[TextData[{
  StyleBox["Parameters:",
    FontWeight->"Bold"],
  " \n\tfromZip: a string specifying a zip code, \n\ttoZip: a string \
specifying a zip code"
}], "Text"],

Cell[TextData[{
  StyleBox["Return Type:",
    FontWeight->"Bold"],
  " double"
}], "Text"],

Cell[CellGroupData[{

Cell["Answer", "Subsubsection"],

Cell["First the package must be loaded.", "MathCaption"],

Cell[BoxData[
    \(Needs["\<WebServices`\>"]\)], "Input",
  CellLabel->"In[15]:="],

Cell[TextData[{
  StyleBox["InstallServiceOperation",
    FontFamily->"Courier New"],
  " should be used to install the function."
}], "MathCaption"],

Cell[BoxData[
    \(InstallServiceOperation[
      Zipcode`GetDistance, \ \
"\<http://webservices.imacination.com/distance/Distance.jws\>", \ \
\[IndentingNewLine]{{"\<fromZip\>", \
{{"\<http://www.w3.org/2001/XMLSchema-instance\>", \ "\<type\>"} \[Rule] \
{"\<http://www.w3.org/2001/XMLSchema\>", "\<string\>"}}}, \
\[IndentingNewLine]{"\<toZip\>", \
{{"\<http://www.w3.org/2001/XMLSchema-instance\>", \ "\<type\>"} \[Rule] \
{"\<http://www.w3.org/2001/XMLSchema\>", "\<string\>"}}}}, {}, \
\[IndentingNewLine]OperationName -> {"\<http://DefaultNamespace\>", \
"\<getDistance\>"}, \[IndentingNewLine]ReturnType -> \
{"\<http://www.w3.org/2001/XMLSchema\>", "\<double\>"}]\)], "Input",
  CellLabel->"In[16]:="],

Cell["After the function is installed, it may be called.", "MathCaption"],

Cell[BoxData[
    \(GetDistance["\<61821\>", \ "\<62656\>"]\)], "Input",
  CellLabel->"In[18]:="]
}, Closed]]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Naming a web service", "Section"],

Cell[TextData[{
  "Sometimes it may be important to install a web service in a context that \
is different from the context used by default with ",
  StyleBox["InstallService",
    FontFamily->"Courier New"],
  ".  This can be done by specifying a context as a second parameter to ",
  StyleBox["InstallService",
    FontFamily->"Courier New"],
  "."
}], "Text"],

Cell[BoxData[
    \(InstallService["\<http://www.xmethods.net/sd/2001/\
CurrencyExchangeService.wsdl\>", "\<Currency`\>"]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \(Context[getRate]\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \(getRate["\<US\>", \ "\<England\>"]\)], "Input",
  CellLabel->"In[6]:="],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Web Service functions and $ContextPath", "Section"],

Cell[TextData[{
  "Web service contexts are added to ",
  StyleBox["$ContextPath",
    FontFamily->"Courier New"],
  " automatically.  However, if it that is not desired, AllowShortContext can \
be used to do this.  Sometimes this is useful if there are multiple versions \
of a web service installed."
}], "Text"],

Cell[BoxData[
    \(InstallService["\<http://www.xmethods.net/sd/2001/\
CurrencyExchangeService.wsdl\>", AllowShortContext \[Rule] False]\)], "Input",\

  CellLabel->"In[7]:="],

Cell[BoxData[
    \(CurrencyExchangeService`CurrencyExchangePort`getRate["\<US\>", \ \
"\<England\>"]\)], "Input",
  CellLabel->"In[8]:="],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Uninstalling web services", "Section"],

Cell["\<\
UninstallService and UninstallServiceOperation can be used to \
uninstall a web service.  UninstallService requires a context and \
UninstallServiceOperation requires the symbol of a web service \
function.\
\>", "Text"],

Cell[BoxData[
    \($InstalledServices\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[
    \(UninstallServiceOperation[getTemp]\)], "Input",
  CellLabel->"In[11]:="],

Cell[BoxData[
    \($InstalledServices\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \(UninstallService["\<CurrencyExchangeService`CurrencyExchangePort`*\>"]\)\
], "Input",
  CellLabel->"In[13]:="],

Cell[BoxData[
    \($InstalledServices\)], "Input",
  CellLabel->"In[14]:="],

Cell[TextData[{
  ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous ",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Previous Slide"],
  "\[ThickSpace]",
  ButtonBox[" Next\[MediumSpace]\[FilledRightTriangle]",
    ButtonFunction:>FrontEndExecute[ {
        FrontEndToken[ 
          FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
    ButtonStyle->"SlidePreviousNextLink",
    ButtonFrame->"None",
    ButtonNote->"Next Slide"]
}], "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                
                CounterBox["SlideShowNavigationBar", {None, 
                  "SlideShowHeader", -1}]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{

Cell["Questions", "Section"],

Cell[TextData[ButtonBox["\[FilledLeftTriangle]\[MediumSpace]Previous",
  ButtonFunction:>FrontEndExecute[ {
      FrontEndToken[ 
        FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
  ButtonStyle->"SlidePreviousNextLink",
  ButtonFrame->"None",
  ButtonNote->"Previous Slide"]], "PreviousNext"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
ScreenStyleEnvironment->"SlideShow",
WindowToolbars->{},
WindowSize->{1051, 757},
WindowMargins->{{0, Automatic}, {Automatic, -1}},
ShowSelection->True,
CellLabelAutoDelete->False,
Magnification->1,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Wolfram Technology Conference 2004", "Title"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.  Make modifications to any definition using \
commands in the Format menu.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    PageWidth->WindowWidth,
    CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
    CellLabelMargins->{{12, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{24, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->12],
  
  Cell[StyleData[All, "SlideShow"],
    PageWidth->WindowWidth,
    ScrollingOptions->{"PagewiseDisplay"->True,
    "VerticalScrollRange"->Fit},
    ShowCellBracket->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    CellLabelMargins->{{2, Inherited}, {Inherited, Inherited}},
    ScriptMinSize->5,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
            TextData[ {
              ValueBox[ "FileName"]}], "Header"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    CellFrameLabelMargins->6,
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{27, Inherited}, {10, 30}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], Inherited},
    LineSpacing->{1, 11},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold",
    FontColor->RGBColor[0.286275, 0.294118, 0.627451]],
  
  Cell[StyleData["Title", "Presentation"],
    CellMargins->{{27, 50}, {10, 30}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Title", "SlideShow"],
    CellMargins->{{100, 50}, {10, 80}}],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {12, 30}},
    FontSize->24,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{27, Inherited}, {20, 2}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Presentation"],
    CellMargins->{{27, 50}, {20, 2}},
    LineSpacing->{1, 0},
    FontSize->36],
  
  Cell[StyleData["Subtitle", "SlideShow"],
    CellMargins->{{100, 50}, {30, 2}}],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{27, Inherited}, {8, 2}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->16],
  
  Cell[StyleData["Subsubtitle", "Presentation"],
    CellMargins->{{24, 10}, {20, 20}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Subsubtitle", "SlideShow"],
    CellMargins->{{100, 25}, {30, 10}}],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {12, 8}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellMargins->{{27, Inherited}, {8, 34}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->4,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], Inherited},
    LineSpacing->{1, 2},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->20,
    FontWeight->"Bold",
    FontColor->RGBColor[0.286275, 0.294118, 0.627451]],
  
  Cell[StyleData["Section", "Presentation"],
    CellMargins->{{40, 50}, {11, 32}},
    LineSpacing->{1, 0},
    FontSize->24],
  
  Cell[StyleData["Section", "SlideShow"],
    CellMargins->{{100, 50}, {11, 35}}],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{2, 0}, {7, 22}},
    FontSize->14,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellMargins->{{60, Inherited}, {8, 12}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold",
    FontColor->RGBColor[0.286275, 0.294118, 0.627451]],
  
  Cell[StyleData["Subsection", "Presentation"],
    CellMargins->{{72, 50}, {6, 15}},
    LineSpacing->{1, 0},
    FontSize->22],
  
  Cell[StyleData["Subsection", "SlideShow"],
    CellMargins->{{100, 50}, {8, 12}},
    LineSpacing->{1, 0}],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{2, 0}, {8, 22}},
    FontSize->12,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellMargins->{{60, Inherited}, {2, 10}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubsection",
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontColor->RGBColor[0.286275, 0.294118, 0.627451]],
  
  Cell[StyleData["Subsubsection", "Presentation"],
    CellMargins->{{72, 50}, {6, 12}},
    LineSpacing->{1, 0},
    FontSize->18],
  
  Cell[StyleData["Subsubsection", "SlideShow"],
    CellMargins->{{100, 50}, {6, 12}}],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{2, 0}, {7, 14}},
    FontSize->11,
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Body Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{60, 10}, {7, 7}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], Inherited},
    LineSpacing->{1, 3},
    CounterIncrements->"Text",
    FontFamily->"Helvetica"],
  
  Cell[StyleData["Text", "Presentation"],
    CellMargins->{{72, 50}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Text", "SlideShow"],
    CellMargins->{{100, 50}, {10, 10}},
    FontSize->16],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->0.5,
    Hyphenation->True,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{60, 10}, {6, 6}},
    DefaultNewInlineCellStyle->"None",
    LineSpacing->{1, 3},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"SmallText",
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Presentation"],
    CellMargins->{{24, 50}, {8, 8}},
    LineSpacing->{1, 5},
    FontSize->10],
  
  Cell[StyleData["SmallText", "SlideShow"],
    CellMargins->{{100, 50}, {8, 8}},
    LineSpacing->{1, 5},
    FontSize->10],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->0.5,
    Hyphenation->True,
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names. Some attributes for these styles are actually set in FormatType Styles \
(in the last section of this stylesheet). \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    CellMargins->{{66, 10}, {5, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    DefaultFormatType->DefaultInputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Mathematica",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "Presentation"],
    CellMargins->{{72, 50}, {8, 10}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Input", "SlideShow"],
    CellMargins->{{100, 50}, {8, 10}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Input", "Printout"],
    CellMargins->{{39, 0}, {4, 6}},
    LinebreakAdjustments->{0.85, 2, 10, 1, 1},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InputOnly"],
    CellMargins->{{66, 10}, {7, 7}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Mathematica",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    LinebreakAdjustments->{0.85, 2, 10, 0, 1},
    CounterIncrements->"Input",
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["InputOnly", "Presentation"],
    CellMargins->{{72, Inherited}, {8, 10}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["InputOnly", "SlideShow"],
    CellMargins->{{100, Inherited}, {8, 10}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["InputOnly", "Printout"],
    CellMargins->{{39, 0}, {4, 6}},
    LinebreakAdjustments->{0.85, 2, 10, 1, 1},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    CellMargins->{{66, 10}, {7, 5}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Output"],
  
  Cell[StyleData["Output", "Presentation"],
    CellMargins->{{72, 50}, {10, 8}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Output", "SlideShow"],
    CellMargins->{{100, 50}, {10, 8}},
    LineSpacing->{1, 0},
    FontSize->16],
  
  Cell[StyleData["Output", "Printout"],
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    CellMargins->{{66, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    AutoStyleOptions->{"UnmatchedBracketStyle"->None},
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Message",
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontColor->RGBColor[0.6, 0.100008, 0.100008]],
  
  Cell[StyleData["Message", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->14],
  
  Cell[StyleData["Message", "SlideShow"],
    CellMargins->{{100, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->14],
  
  Cell[StyleData["Message", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->7,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    CellMargins->{{66, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Print",
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "Presentation"],
    CellMargins->{{72, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->14],
  
  Cell[StyleData["Print", "SlideShow"],
    CellMargins->{{100, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    FontSize->14],
  
  Cell[StyleData["Print", "Printout"],
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    CellMargins->{{4, Inherited}, {Inherited, Inherited}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultOutputFormatType,
    LanguageCategory->None,
    FormatType->InputForm,
    CounterIncrements->"Graphics",
    ImageMargins->{{43, Inherited}, {Inherited, 0}},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->10],
  
  Cell[StyleData["Graphics", "Presentation"],
    ImageMargins->{{62, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "SlideShow"],
    ImageMargins->{{100, Inherited}, {Inherited, 0}}],
  
  Cell[StyleData["Graphics", "Printout"],
    ImageMargins->{{30, Inherited}, {Inherited, 0}},
    Magnification->0.8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontColor->RGBColor[0.392157, 0.396078, 0.717647]],
  
  Cell[StyleData["CellLabel", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["CellLabel", "SlideShow"],
    FontSize->12],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FrameLabel"],
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["FrameLabel", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["FrameLabel", "SlideShow"],
    FontSize->12],
  
  Cell[StyleData["FrameLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Presentation Specific", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BulletedList"],
    CellMargins->{{50, 10}, {7, 7}},
    CellFrameLabels->{{
      Cell[ "\[Bullet]", "BulletedList", CellBaseline -> Baseline], 
          Inherited}, {Inherited, Inherited}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], Inherited},
    CounterIncrements->"BulletedList",
    FontFamily->"Helvetica"],
  
  Cell[StyleData["BulletedList", "Presentation"],
    CellMargins->{{62, 50}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["BulletedList", "SlideShow"],
    CellMargins->{{90, 50}, {10, 10}},
    FontSize->16],
  
  Cell[StyleData["BulletedList", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->0.5,
    Hyphenation->True,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Author"],
    CellMargins->{{100, 27}, {2, 20}},
    FontFamily->"Times",
    FontSize->24,
    FontSlant->"Italic"],
  
  Cell[StyleData["Author", "Presentation"],
    CellMargins->{{200, 27}, {2, 50}},
    FontSize->28],
  
  Cell[StyleData["Author", "SlideShow"],
    CellMargins->{{200, 27}, {2, 50}},
    FontSize->28],
  
  Cell[StyleData["Author", "Printout"],
    CellMargins->{{100, 27}, {2, 20}},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Affiliation"],
    CellMargins->{{100, 27}, {30, 12}},
    FontFamily->"Times",
    FontSize->24,
    FontSlant->"Italic"],
  
  Cell[StyleData["Affiliation", "Presentation"],
    CellMargins->{{200, 27}, {2, 10}},
    FontSize->28],
  
  Cell[StyleData["Affiliation", "SlideShow"],
    CellMargins->{{200, 27}, {2, 10}},
    FontSize->28],
  
  Cell[StyleData["Affiliation", "Printout"],
    CellMargins->{{100, 27}, {2, 12}},
    FontSize->14]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Header Graphic", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ConferenceGraphicCell"],
    ShowCellBracket->False,
    CellMargins->{{0, 0}, {0, 0}},
    Evaluatable->False,
    PageBreakBelow->False,
    ImageMargins->{{0, 0}, {0, 0}},
    ImageRegion->{{0, 1}, {0, 1}},
    Background->GrayLevel[1],
    Magnification->1],
  
  Cell[StyleData["ConferenceGraphicCell", "Presentation"]],
  
  Cell[StyleData["ConferenceGraphicCell", "SlideShow"]],
  
  Cell[StyleData["ConferenceGraphicCell", "Printout"],
    FontSize->8,
    Magnification->0.75]
  }, Open  ]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Inline Formatting", "Section"],
  
  Cell["\<\
These styles are for modifying individual words or letters in a \
cell exclusive of the cell tag.\
\>", "Text"],
  
  Cell[StyleData["RM"],
    StyleMenuListing->None,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["BF"],
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["IT"],
    StyleMenuListing->None,
    FontSlant->"Italic"],
  
  Cell[StyleData["TR"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["TI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["TB"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["TBI"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["MR"],
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MO"],
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["MB"],
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["MBO"],
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SR"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SB"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SBO"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO10"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->7,
    FontWeight->"Plain",
    FontSlant->"Italic"]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->1,
    SingleLetterItalics->True],
  
  Cell[StyleData["InlineFormula", "Presentation"],
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["InlineFormula", "SlideShow"],
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{60, Inherited}, {Inherited, Inherited}},
    CellHorizontalScrolling->True,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->0,
    SingleLetterItalics->True,
    UnderoverscriptBoxOptions->{LimitsPositioning->True}],
  
  Cell[StyleData["DisplayFormula", "Presentation"],
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["DisplayFormula", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["DisplayFormula", "Printout"],
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Program"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{60, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    Hyphenation->False,
    LanguageCategory->"Formula",
    ScriptLevel->1,
    FontFamily->"Courier"],
  
  Cell[StyleData["Program", "Presentation"],
    CellMargins->{{24, 50}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Program", "SlideShow"],
    CellMargins->{{100, 50}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->16],
  
  Cell[StyleData["Program", "Printout"],
    CellMargins->{{2, 0}, {6, 6}},
    FontSize->9]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Outline Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline1"],
    CellMargins->{{60, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 50},
    ParagraphIndent->-38,
    CounterIncrements->"Outline1",
    CounterAssignments->{{"Outline2", 0}, {"Outline3", 0}, {"Outline4", 0}},
    FontSize->18,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}],
  
  Cell[StyleData["Outline1", "SlideShow"]],
  
  Cell[StyleData["Outline1", "Printout"],
    CounterBoxOptions->{CounterFunction:>CapitalRomanNumeral}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline2"],
    CellMargins->{{90, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 60},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    CounterAssignments->{{"Outline3", 0}, {"Outline4", 0}},
    FontSize->15,
    FontWeight->"Bold",
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}],
  
  Cell[StyleData["Outline2", "SlideShow"]],
  
  Cell[StyleData["Outline2", "Printout"],
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "A", "Z"], #]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline3"],
    CellMargins->{{120, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 70},
    ParagraphIndent->-21,
    CounterIncrements->"Outline3",
    CounterAssignments->{{"Outline4", 0}},
    FontSize->12,
    CounterBoxOptions->{CounterFunction:>Identity}],
  
  Cell[StyleData["Outline3", "SlideShow"]],
  
  Cell[StyleData["Outline3", "Printout"],
    CounterBoxOptions->{CounterFunction:>Identity}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Outline4"],
    CellMargins->{{150, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 80},
    ParagraphIndent->-18,
    CounterIncrements->"Outline4",
    FontSize->10,
    CounterBoxOptions->{CounterFunction:>(Part[ 
        CharacterRange[ "a", "z"], #]&)}],
  
  Cell[StyleData["Outline4", "SlideShow"]],
  
  Cell[StyleData["Outline4", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlink Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonFrame->"None",
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["Hyperlink", "SlideShow"]],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["MainBookLink", "SlideShow"]],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["AddOnsLink", "SlideShow"]],
  
  Cell[StyleData["AddOnsLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["RefGuideLink", "SlideShow"]],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLinkText"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLinkText", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["RefGuideLinkText", "SlideShow"]],
  
  Cell[StyleData["RefGuideLinkText", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["GettingStartedLink", "SlideShow"]],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DemosLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "Demos", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["DemosLink", "SlideShow"]],
  
  Cell[StyleData["DemosLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TourLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "Tour", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["TourLink", "SlideShow"]],
  
  Cell[StyleData["TourLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Presentation"],
    FontSize->16],
  
  Cell[StyleData["OtherInformationLink", "SlideShow"]],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MasterIndexLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0.269993, 0.308507, 0.6],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MasterIndex", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MasterIndexLink", "SlideShow"]],
  
  Cell[StyleData["MasterIndexLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Headers and Footers", "Section"],
  
  Cell[StyleData["Header"],
    CellMargins->{{0, 0}, {4, 1}},
    DefaultNewInlineCellStyle->"None",
    LanguageCategory->"NaturalLanguage",
    StyleMenuListing->None,
    FontSize->10,
    FontSlant->"Italic"],
  
  Cell[StyleData["Footer"],
    CellMargins->{{0, 0}, {0, 4}},
    DefaultNewInlineCellStyle->"None",
    LanguageCategory->"NaturalLanguage",
    StyleMenuListing->None,
    FontSize->9,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {4, 1}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard \
ButtonFunctions, for use in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, Placeholder]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Placeholder Styles", "Section"],
  
  Cell["\<\
The cells below define styles useful for making placeholder \
objects in palette templates.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Placeholder"],
    Placeholder->True,
    StyleMenuListing->None,
    FontSlant->"Italic",
    FontColor->RGBColor[0.890623, 0.864698, 0.384756],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["Placeholder", "Presentation"]],
  
  Cell[StyleData["Placeholder", "SlideShow"]],
  
  Cell[StyleData["Placeholder", "Printout"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PrimaryPlaceholder"],
    StyleMenuListing->None,
    DrawHighlighted->True,
    FontSlant->"Italic",
    Background->RGBColor[0.912505, 0.891798, 0.507774],
    TagBoxOptions->{Editable->False,
    Selectable->False,
    StripWrapperBoxes->False}],
  
  Cell[StyleData["PrimaryPlaceholder", "Presentation"]],
  
  Cell[StyleData["PrimaryPlaceholder", "SlideShow"]],
  
  Cell[StyleData["PrimaryPlaceholder", "Printout"]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["FormatType Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are mixed in with the styles \
of most cells.  If a cell's FormatType matches the name of one of the styles \
defined below, then that style is applied between the cell's style and its \
own options. This is particularly true of Input and Output.\
\>", "Text"],
  
  Cell[StyleData["CellExpression"],
    PageWidth->Infinity,
    CellMargins->{{6, Inherited}, {Inherited, Inherited}},
    ShowCellLabel->False,
    ShowSpecialCharacters->False,
    AllowInlineCells->False,
    Hyphenation->False,
    AutoItalicWords->{},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    Background->GrayLevel[1]],
  
  Cell[StyleData["InputForm"],
    InputAutoReplacements->{},
    AllowInlineCells->False,
    Hyphenation->False,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["OutputForm"],
    PageWidth->Infinity,
    TextAlignment->Left,
    LineSpacing->{0.6, 1},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["StandardForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    LineSpacing->{1.25, 0},
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["TraditionalForm"],
    InputAutoReplacements->{
      "->"->"\[Rule]", ":>"->"\[RuleDelayed]", "<="->"\[LessEqual]", 
        ">="->"\[GreaterEqual]", "!="->"\[NotEqual]", "=="->"\[Equal]", 
        Inherited},
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    LineSpacing->{1.25, 0},
    SingleLetterItalics->True,
    TraditionalFunctionNotation->True,
    DelimiterMatching->None,
    StyleMenuListing->None],
  
  Cell["\<\
The style defined below is mixed in to any cell that is in an \
inline cell within another.\
\>", "Text"],
  
  Cell[StyleData["InlineCell"],
    LanguageCategory->"Formula",
    ScriptLevel->1,
    StyleMenuListing->None],
  
  Cell[StyleData["InlineCellEditing"],
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Automatic Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are used to affect the display \
of certain types of objects in typeset expressions.  For example, \
\"UnmatchedBracket\" style defines how unmatched bracket, curly bracket, and \
parenthesis characters are displayed (typically by coloring them to make them \
stand out).\
\>", "Text"],
  
  Cell[StyleData["UnmatchedBracket"],
    StyleMenuListing->None,
    FontColor->RGBColor[0.760006, 0.330007, 0.8]],
  
  Cell[StyleData["Completions"],
    StyleMenuListing->None,
    FontFamily->"Courier"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles from HelpBrowser", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MathCaption"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{66, 12}, {2, 24}},
    PageBreakBelow->False,
    CellFrameMargins->{{8, 8}, {8, 2}},
    CellFrameColor->GrayLevel[0.700008],
    CellFrameLabelMargins->4,
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None,
    FontColor->GrayLevel[0.2]],
  
  Cell[StyleData["MathCaption", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MathCaption", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["MathCaption", "Printout"],
    CellMargins->{{39, 0}, {0, 14}},
    Hyphenation->True,
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ObjectName"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {8, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Mathematica",
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectName", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ObjectName", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["ObjectName", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Usage"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {8, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Mathematica",
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["Usage", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Usage", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["Usage", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Notes"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {8, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Mathematica",
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["Notes", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Notes", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["Notes", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineOutput"],
    ShowCellBracket->True,
    CellMargins->{{66, 4}, {8, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    "TwoByteSyntaxCharacterAutoReplacement"->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Mathematica",
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["InlineOutput", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["InlineOutput", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["InlineOutput", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Emphasis Boxes and Pictures", "Subsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Box"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["Box", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Box", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["Box", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DoubleBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->2,
    RowAlignments->Top}],
  
  Cell[StyleData["DoubleBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DoubleBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["DoubleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["1ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["1ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["1ColumnBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["1ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    SingleLetterItalics->False,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.31, 0.67}}],
  
  Cell[StyleData["2ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["2ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.46}],
  
  Cell[StyleData["2ColumnEvenBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnEvenBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["2ColumnEvenBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnSmallBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.35,
    ColumnAlignments->{Right, Left}}],
  
  Cell[StyleData["2ColumnSmallBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnSmallBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["2ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.32}],
  
  Cell[StyleData["3ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["3ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnSmallBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.24,
    ColumnAlignments->{Right, Center, Left}}],
  
  Cell[StyleData["3ColumnSmallBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnSmallBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["3ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["4ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    SingleLetterItalics->False,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.13, 0.35, 0.13, 0.35}}],
  
  Cell[StyleData["4ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["4ColumnBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["4ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["5ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.202}],
  
  Cell[StyleData["5ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["5ColumnBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["5ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["6ColumnBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.12, 0.22, 0.12, 0.12, 0.22, 0.12}}],
  
  Cell[StyleData["6ColumnBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["6ColumnBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["6ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FramedBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["FramedBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["FramedBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["FramedBox", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["DefinitionBox", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox3Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.35, 0.2, 0.45},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox3Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox3Col", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["DefinitionBox3Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox4Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.15, 0.35, 0.15, 0.35},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox4Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox4Col", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["DefinitionBox4Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox5Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->0.2,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox5Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox5Col", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["DefinitionBox5Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox6Col"],
    CellFrame->0.5,
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.13, 0.24, 0.13, 0.13, 0.24, 0.13},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox6Col", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["DefinitionBox6Col", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["DefinitionBox6Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{27, 12}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TopBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["TopBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{27, 12}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MiddleBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["MiddleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 2}},
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BottomBox"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{27, 12}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["BottomBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["BottomBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["BottomBox", "Printout"],
    CellMargins->{{2, 0}, {0, -5}},
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->2.2}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{27, 12}, {-2, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopSpanBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["TopSpanBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["TopSpanBox", "Printout"],
    CellMargins->{{2, 0}, {-2, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{27, 12}, {0, 0}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleSpanBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["MiddleSpanBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["MiddleSpanBox", "Printout"],
    CellMargins->{{2, 0}, {-5, 0}},
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Picture"],
    CellMargins->{{27, Inherited}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["Picture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Picture", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["Picture", "Printout"],
    CellMargins->{{2, Inherited}, {4, 4}},
    Magnification->0.65]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OpenCloseItemizedPicture"],
    CellMargins->{{88, 4}, {4, 4}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->False},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["OpenCloseItemizedPicture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["OpenCloseItemizedPicture", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["OpenCloseItemizedPicture", "Printout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedPicture"],
    CellMargins->{{88, 4}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedPicture", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ItemizedPicture", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["ItemizedPicture", "Printout"],
    CellMargins->{{77, 2}, {4, -4}},
    Magnification->0.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ListGraphic"],
    CellMargins->{{88, 4}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ListGraphic", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ListGraphic", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["ListGraphic", "Printout"],
    CellMargins->{{77, 2}, {4, -4}},
    Magnification->0.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ListNoteBox"],
    CellFrame->0.5,
    CellMargins->{{88, 12}, {8, 8}},
    CellHorizontalScrolling->True,
    CellFrameColor->RGBColor[0.74902, 0.694118, 0.552941],
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[0.964706, 0.929412, 0.839216],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["ListNoteBox", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ListNoteBox", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["ListNoteBox", "Printout"],
    CellMargins->{{77, 4}, {6, 2}},
    FontSize->10,
    Background->GrayLevel[0.900008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureGroup"],
    CellMargins->{{41, 4}, {0, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureGroup", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["PictureGroup", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["PictureGroup", "Printout"],
    CellMargins->{{76, 2}, {0, 0}},
    CellElementSpacings->{"CellMinHeight"->1,
    "ClosedCellHeight"->0},
    CellOpen->False]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Sound"],
    ShowCellBracket->True,
    CellMargins->{{27, Inherited}, {0, 8}},
    StyleMenuListing->None],
  
  Cell[StyleData["Sound", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["Sound", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["Sound", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Tables", "Subsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnTable"],
    CellMargins->{{35, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.34, 0.64},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnTable", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["2ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenTable"],
    CellMargins->{{35, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->0.49,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnEvenTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["2ColumnEvenTable", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["2ColumnEvenTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnTable"],
    CellMargins->{{35, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.28, 0.28, 0.43},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["3ColumnTable", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["3ColumnTable", "SlideShow"],
    CellMargins->{{100, 50}, {Inherited, Inherited}}],
  
  Cell[StyleData["3ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9]
  }, Closed]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Slide Show Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideShowNavigationBar"],
    CellFrame->True,
    CellMargins->{{0, 0}, {3, 50}},
    CellElementSpacings->{"CellMinHeight"->0.8125},
    CellGroupingRules->{"SectionGrouping", 0},
    CellFrameMargins->False,
    CellFrameColor->GrayLevel[1],
    CellFrameLabelMargins->False,
    CounterIncrements->"SlideShowNavigationBar",
    StyleMenuListing->None,
    FontSize->10,
    Background->GrayLevel[0.850004],
    Magnification->1,
    GridBoxOptions->{GridBaseline->Center,
    RowSpacings->0,
    ColumnSpacings->0,
    ColumnWidths->{3.5, 3.5, 3.5, 3.5, 40, 5, 4},
    RowAlignments->Baseline,
    ColumnAlignments->{
      Center, Center, Center, Center, Center, Center, Right, Center}}],
  
  Cell[StyleData["SlideShowNavigationBar", "Presentation"],
    FontSize->10,
    Magnification->1],
  
  Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
    Deletable->False,
    ShowCellBracket->False,
    CellMargins->{{-1, -1}, {-1, -1}},
    PageBreakAbove->True,
    CellFrameMargins->{{1, 1}, {0, 0}}],
  
  Cell[StyleData["SlideShowNavigationBar", "Printout"],
    CellOpen->False,
    FontSize->1]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideShowSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{0, 0}, {10, 0}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CellFrameMargins->{{12, 4}, {6, 12}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        "gridMathematica"->FormBox[ 
            RowBox[ {"grid", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], "webMathematica"->FormBox[ 
            RowBox[ {"web", 
              AdjustmentBox[ 
                StyleBox[ "Mathematica", FontSlant -> "Italic"], 
                BoxMargins -> {{-0.17499999999999999, 0}, {0, 0}}]}], 
            TextForm], Inherited},
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Plain",
    FontColor->GrayLevel[1],
    Background->RGBColor[0.408011, 0.440726, 0.8]],
  
  Cell[StyleData["SlideShowSection", "Presentation"],
    CellFrameMargins->{{20, 10}, {10, 18}},
    FontSize->27],
  
  Cell[StyleData["SlideShowSection", "SlideShow"],
    ShowCellBracket->False,
    PageBreakAbove->True],
  
  Cell[StyleData["SlideShowSection", "Printout"],
    CellMargins->{{18, 30}, {0, 30}},
    CellFrameMargins->5,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideHyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontSize->26,
    FontColor->GrayLevel[0.400015],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonMinHeight->0.85,
    ButtonMargins->0.5,
    ButtonNote->None}],
  
  Cell[StyleData["SlideHyperlink", "Presentation"],
    CellMargins->{{14, 10}, {6, 12}}],
  
  Cell[StyleData["SlideHyperlink", "SlideShow"]],
  
  Cell[StyleData["SlideHyperlink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlidePreviousNextLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Helvetica",
    FontSize->12,
    FontColor->GrayLevel[0.500008],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonMinHeight->0.85,
    ButtonMargins->0.5,
    ButtonNote->None}],
  
  Cell[StyleData["SlidePreviousNextLink", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["SlidePreviousNextLink", "SlideShow"]],
  
  Cell[StyleData["SlidePreviousNextLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PreviousNext"],
    CellMargins->{{60, 10}, {7, 7}},
    TextAlignment->0.75,
    LineSpacing->{1, 3},
    CounterIncrements->"PreviousNext",
    FontFamily->"Helvetica",
    FontSize->12,
    FontColor->GrayLevel[0.500008]],
  
  Cell[StyleData["PreviousNext", "Presentation"],
    CellMargins->{{24, 50}, {10, 10}},
    LineSpacing->{1, 5},
    FontSize->12],
  
  Cell[StyleData["PreviousNext", "SlideShow"],
    CellMargins->{{50, 50}, {50, 15}},
    FontSize->14],
  
  Cell[StyleData["PreviousNext", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->0.5,
    Hyphenation->True,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideTOCLink"],
    CellMargins->{{24, Inherited}, {Inherited, Inherited}},
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Helvetica",
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonMargins->1.5,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["SlideTOCLink", "Presentation"],
    CellMargins->{{35, 10}, {8, 8}},
    FontSize->18],
  
  Cell[StyleData["SlideTOCLink", "SlideShow"]],
  
  Cell[StyleData["SlideTOCLink", "Printout"],
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideTOC"],
    CellDingbat->"\[Bullet]",
    CellMargins->{{18, Inherited}, {Inherited, Inherited}},
    StyleMenuListing->None,
    FontFamily->"Helvetica"],
  
  Cell[StyleData["SlideTOC", "Presentation"],
    CellMargins->{{25, 10}, {10, 5}},
    FontSize->18],
  
  Cell[StyleData["SlideTOC", "SlideShow"],
    FontSize->14],
  
  Cell[StyleData["SlideTOC", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Open  ]]
  }, Open  ]]
  }]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "SlideShowHeader"->{
    Cell[1776, 53, 1679, 44, 20, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[3612, 108, 1679, 44, 20, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[6366, 191, 1679, 44, 20, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[9056, 272, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[12020, 369, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[15120, 460, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[18096, 546, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[21038, 632, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[24112, 721, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[26979, 807, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[30032, 898, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[33067, 985, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[37341, 1102, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[40268, 1190, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[43359, 1284, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[46261, 1369, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[50481, 1488, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[54552, 1630, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[57665, 1726, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[60737, 1818, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"],
    Cell[63856, 1918, 1679, 44, 75, "SlideShowNavigationBar",
      CellTags->"SlideShowHeader"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"SlideShowHeader", 151666, 4859}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 1679, 44, 20, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],
Cell[3458, 99, 38, 0, 145, "Title"],
Cell[3499, 101, 34, 0, 87, "Author"],
Cell[3536, 103, 39, 0, 47, "Affiliation"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3612, 108, 1679, 44, 20, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[5316, 156, 34, 0, 72, "Section"],
Cell[5353, 158, 339, 9, 66, "Text"],
Cell[5695, 169, 622, 16, 85, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6366, 191, 1679, 44, 20, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[8070, 239, 42, 0, 72, "Section"],
Cell[8115, 241, 267, 7, 65, "Text"],
Cell[8385, 250, 622, 16, 85, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9056, 272, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[10760, 320, 44, 0, 68, "Section"],
Cell[10807, 322, 99, 3, 33, "Text"],
Cell[10909, 327, 115, 3, 33, "Text"],
Cell[11027, 332, 98, 3, 33, "Text"],
Cell[11128, 337, 103, 3, 33, "Text"],
Cell[11234, 342, 112, 3, 33, "Text"],
Cell[11349, 347, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12020, 369, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[13724, 417, 44, 0, 68, "Section"],
Cell[13771, 419, 393, 10, 52, "Text"],
Cell[14167, 431, 279, 5, 70, "Input"],
Cell[14449, 438, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15120, 460, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[16824, 508, 32, 0, 68, "Section"],
Cell[16859, 510, 563, 12, 71, "Text"],
Cell[17425, 524, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18096, 546, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[19800, 594, 53, 0, 68, "Section"],
Cell[19856, 596, 508, 12, 71, "Text"],
Cell[20367, 610, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21038, 632, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[22742, 680, 43, 0, 68, "Section"],
Cell[22788, 682, 537, 11, 71, "Text"],
Cell[23328, 695, 110, 2, 30, "Input"],
Cell[23441, 699, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[24112, 721, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[25816, 769, 47, 0, 68, "Section"],
Cell[25866, 771, 350, 8, 52, "Text"],
Cell[26219, 781, 86, 2, 30, "Input"],
Cell[26308, 785, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26979, 807, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[28683, 855, 56, 0, 68, "Section"],
Cell[28742, 857, 412, 10, 52, "Text"],
Cell[29157, 869, 201, 5, 30, "Input"],
Cell[29361, 876, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30032, 898, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[31736, 946, 32, 0, 68, "Section"],
Cell[31771, 948, 622, 13, 71, "Text"],
Cell[32396, 963, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[33067, 985, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[34771, 1033, 41, 0, 68, "Section"],
Cell[34815, 1035, 506, 8, 71, "Text"],
Cell[35324, 1045, 1087, 26, 90, "Text"],
Cell[36414, 1073, 253, 5, 90, "Input"],
Cell[36670, 1080, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[37341, 1102, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[39045, 1150, 48, 0, 68, "Section"],
Cell[39096, 1152, 323, 8, 52, "Text"],
Cell[39422, 1162, 172, 4, 30, "Input"],
Cell[39597, 1168, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[40268, 1190, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[41972, 1238, 48, 0, 68, "Section"],
Cell[42023, 1240, 488, 14, 52, "Text"],
Cell[42514, 1256, 171, 4, 30, "Input"],
Cell[42688, 1262, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[43359, 1284, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[45063, 1332, 28, 0, 68, "Section"],
Cell[45094, 1334, 357, 7, 52, "Text"],
Cell[45454, 1343, 55, 0, 33, "Text"],
Cell[45512, 1345, 75, 0, 33, "Text"],
Cell[45590, 1347, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[46261, 1369, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[47965, 1417, 42, 0, 68, "Section"],
Cell[48010, 1419, 1122, 30, 109, "Text"],
Cell[49135, 1451, 584, 9, 150, "Input"],
Cell[49722, 1462, 85, 2, 30, "Input"],
Cell[49810, 1466, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[50481, 1488, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[52185, 1536, 28, 0, 68, "Section"],
Cell[52216, 1538, 140, 4, 33, "Text"],

Cell[CellGroupData[{
Cell[52381, 1546, 60, 0, 41, "Subsection"],
Cell[52444, 1548, 144, 3, 33, "Text"],
Cell[52591, 1553, 144, 5, 33, "Text"],
Cell[52738, 1560, 105, 5, 33, "Text"],
Cell[52846, 1567, 122, 5, 33, "Text"],
Cell[52971, 1574, 172, 5, 71, "Text"],
Cell[53146, 1581, 91, 4, 33, "Text"],

Cell[CellGroupData[{
Cell[53262, 1589, 31, 0, 29, "Subsubsection"],
Cell[53296, 1591, 56, 0, 45, "MathCaption"],
Cell[53355, 1593, 83, 2, 30, "Input"],
Cell[53441, 1597, 149, 4, 45, "MathCaption"],
Cell[53593, 1603, 710, 13, 130, "Input"],
Cell[54306, 1618, 73, 0, 45, "MathCaption"],
Cell[54382, 1620, 97, 2, 30, "Input"]
}, Closed]]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[54552, 1630, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[56256, 1678, 39, 0, 68, "Section"],
Cell[56298, 1680, 362, 9, 52, "Text"],
Cell[56663, 1691, 158, 3, 30, "Input"],
Cell[56824, 1696, 73, 2, 30, "Input"],
Cell[56900, 1700, 91, 2, 30, "Input"],
Cell[56994, 1704, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[57665, 1726, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[59369, 1774, 57, 0, 68, "Section"],
Cell[59429, 1776, 314, 7, 52, "Text"],
Cell[59746, 1785, 176, 4, 30, "Input"],
Cell[59925, 1791, 138, 3, 30, "Input"],
Cell[60066, 1796, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[60737, 1818, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[62441, 1866, 44, 0, 68, "Section"],
Cell[62488, 1868, 230, 5, 52, "Text"],
Cell[62721, 1875, 75, 2, 30, "Input"],
Cell[62799, 1879, 92, 2, 30, "Input"],
Cell[62894, 1883, 76, 2, 30, "Input"],
Cell[62973, 1887, 130, 3, 30, "Input"],
Cell[63106, 1892, 76, 2, 30, "Input"],
Cell[63185, 1896, 622, 16, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[63856, 1918, 1679, 44, 75, "SlideShowNavigationBar",
  CellTags->"SlideShowHeader"],

Cell[CellGroupData[{
Cell[65560, 1966, 28, 0, 68, "Section"],
Cell[65591, 1968, 305, 6, 33, "PreviousNext"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

