(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.1'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7909,        223]*)
(*NotebookOutlinePosition[      8583,        246]*)
(*  CellTagsIndexPosition[      8539,        242]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Wolfram Search Web Service", "Title"],

Cell[TextData[{
  "This example demonstrates the Wolfram Search web service.  The Wolfram \
Search web service provides an interface to functionality that searches the \
Wolfram Research websites. With this web service, a user can query the web \
documents directly from any application that supports web services. The \
service is similar to the functionality provided by ",
  StyleBox["http://search.wolfram.com",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True}],
  "."
}], "Text"],

Cell["\<\
To try this example, evaluate all the initialization cells (you can do this \
with the menu command Kernel/Evaluation/Evaluate Initialization). Then go to \
the Example section.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Code", "Section",
  InitializationCell->True],

Cell[BoxData[
    \(Needs["\<WebServices`\>"]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(InstallService["\<http://webservices.wolfram.com/services/\
SearchServices/WolframSearch2.wsdl\>", 
        AllowShortContext \[Rule] False];\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(Options[
          WolframWebSearch] = {\[IndentingNewLine]MaxHits\  \[Rule] 
            10, \[IndentingNewLine]Method \[Rule] 
            And, \[IndentingNewLine]IncludeURL\  \[Rule] \ 
            True\[IndentingNewLine]};\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\($backgrounds = {RGBColor[0.960784, 0.878431, 0.666667], 
          RGBColor[0.964706, 0.929412, 0.839216]};\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(\(WolframWebSearch::nomatch = "\<No page containing `1` \
found.\>";\)\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(WolframWebSearch[str_String, 
        opts___] := \[IndentingNewLine]Module[{lis, matches, multi, 
          urlQ}, \[IndentingNewLine]{matches, multi, 
            urlQ} = {MaxHits, Method, IncludeURL}\  /. \ 
            Flatten[{opts, 
                Options\ @\ WolframWebSearch}]; \[IndentingNewLine]lis\  = \ 
          WolframSearchService`WolframSearchPort`WolframSearch[{"\<Query\>" \
\[Rule] str, \ "\<Limit\>" \[Rule] 
                matches, "\<ReturnTypes\>" \[Rule] {"\<Title\>", \ "\<URL\>", \
"\<Score\>"}}]; \[IndentingNewLine]lis\  = \ "\<Matches\>" /. 
            lis; \[IndentingNewLine]If[
          lis === {} || lis === Null\  || \ 
            lis\  === "\<Matches\>", \[IndentingNewLine]Message[
            WolframWebSearch::nomatch, \ str], \[IndentingNewLine]$bg = 
            0; \[IndentingNewLine]Scan[CellPrint, 
            searchResultCells[lis, urlQ]]]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(searchResultCells[lis_, 
        urlQ_] := \(cellTemplate[formatSingleResult[#, urlQ]] &\)\  /@ \ 
        lis\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(cellTemplate[lis_] := \[IndentingNewLine]Cell[
        TextData\ @\ \(Flatten\ @\ {lis}\), "\<Print\>", \
\[IndentingNewLine]FontFamily -> "\<Times\>", \[IndentingNewLine]CellMargins \
\[Rule] {{Inherited, Inherited}, {0, 
              0}}, \[IndentingNewLine]CellDingbat \[Rule] 
          ToString[\(++$bg\)], \[IndentingNewLine]Background \[Rule] 
          Part[$backgrounds, Mod[$bg, 2, 1]]\[IndentingNewLine]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(formatSingleResult[opts_, 
        urlQ_] := \[IndentingNewLine]Block[{u, t, 
          s}, \[IndentingNewLine]{u, t, 
            s} = {"\<URL\>", "\<Title\>", "\<Score\>"}\  /. \ 
            opts; \[IndentingNewLine]{\[IndentingNewLine]scoreIndicator[
            s], \[IndentingNewLine]"\< \>", \[IndentingNewLine]webLink[
            StyleBox[formatTitle\ @\ t, FontWeight -> "\<Bold\>"], 
            u], \[IndentingNewLine]If[
            urlQ, {"\<\n\>", 
              webLink[StyleBox[u, "\<SmallText\>", 
                  FontColor \[Rule] GrayLevel[0.4]], 
                u]}, {}]\[IndentingNewLine]}\[IndentingNewLine]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(scoreIndicator[
        r_] := \[IndentingNewLine]StyleBox[\[IndentingNewLine]StringJoin\ @\ 
          Table["\<|\>", {r}], \[IndentingNewLine]FontColor -> 
          RGBColor[0.269993, 0.308507, 
            0.6], \[IndentingNewLine]FontWeight -> "\<Bold\>"\
\[IndentingNewLine]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(webLink[content_, url_] := \[IndentingNewLine]ButtonBox[
        content, \[IndentingNewLine]ButtonData \[RuleDelayed] {URL[url], 
            None}, \[IndentingNewLine]ButtonStyle -> "\<Hyperlink\>"\
\[IndentingNewLine]]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(formatTitle[str_String] := translateAllEntities[str]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(decodeString[str_] := 
      StringReplace[
        str, {\[IndentingNewLine]"\<&lt;\>" -> "\<<\>", \
\[IndentingNewLine]"\<&gt;\>" -> "\<>\>", \[IndentingNewLine]"\<&amp;\>" -> "\
\<&\>", \[IndentingNewLine]"\<&quot;\>" -> "\<\"\>", \[IndentingNewLine]"\<\\\
\>" -> "\<\\[Backslash]\>"\[IndentingNewLine]}]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(translateAllEntities[str_] := 
      StringReplace[str, 
          Reverse\  /@ \ 
            System`Convert`MLStringDataDump`$UnicodeToHTML4Entities] // 
        decodeString\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell["\<\
Find the top 10 wolfram.com web pages containing all the given strings.\
\>", "Text"],

Cell[BoxData[
    \(WolframWebSearch["\<premier service\>"]\)], "Input"],

Cell[TextData[{
  "Using google syntax, search for pages containing ",
  StyleBox["any",
    FontSlant->"Italic"],
  " of the given strings, and return only the top two results."
}], "Text"],

Cell[BoxData[
    \(WolframWebSearch["\<FuzzyLogic OR ControlSystems\>", 
      MaxHits \[Rule] 2]\)], "Input"],

Cell["Display less verbose results.", "Text"],

Cell[BoxData[
    \(WolframWebSearch["\<velodrome\>", IncludeURL \[Rule] False]\)], "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.1 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
AutoGeneratedPackage->None,
WindowSize->{642, 740},
WindowMargins->{{Automatic, 148}, {Automatic, 75}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 43, 0, 95, "Title"],
Cell[1822, 55, 509, 10, 90, "Text"],
Cell[2334, 67, 201, 4, 52, "Text"],

Cell[CellGroupData[{
Cell[2560, 75, 51, 1, 73, "Section",
  InitializationCell->True],
Cell[2614, 78, 86, 2, 30, "Input",
  InitializationCell->True],
Cell[2703, 82, 206, 4, 70, "Input",
  InitializationCell->True],
Cell[2912, 88, 291, 6, 110, "Input",
  InitializationCell->True],
Cell[3206, 96, 172, 3, 50, "Input",
  InitializationCell->True],
Cell[3381, 101, 131, 3, 30, "Input",
  InitializationCell->True],
Cell[3515, 106, 971, 17, 270, "Input",
  InitializationCell->True],
Cell[4489, 125, 171, 4, 50, "Input",
  InitializationCell->True],
Cell[4663, 131, 477, 8, 150, "Input",
  InitializationCell->True],
Cell[5143, 141, 695, 13, 250, "Input",
  InitializationCell->True],
Cell[5841, 156, 342, 7, 130, "Input",
  InitializationCell->True],
Cell[6186, 165, 282, 5, 110, "Input",
  InitializationCell->True],
Cell[6471, 172, 113, 2, 30, "Input",
  InitializationCell->True],
Cell[6587, 176, 368, 7, 150, "Input",
  InitializationCell->True],
Cell[6958, 185, 237, 6, 90, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[7232, 196, 26, 0, 43, "Section"],
Cell[7261, 198, 95, 2, 33, "Text"],
Cell[7359, 202, 72, 1, 30, "Input"],
Cell[7434, 205, 190, 5, 30, "Text"],
Cell[7627, 212, 111, 2, 30, "Input"],
Cell[7741, 216, 45, 0, 30, "Text"],
Cell[7789, 218, 92, 1, 30, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

