(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6689,        159]*)
(*NotebookOutlinePosition[      7363,        182]*)
(*  CellTagsIndexPosition[      7319,        178]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["XMethods Query Web Service ", "Title"],

Cell["\<\
This example demonstrates the XMethods Query Service.  XMethods.com is a web \
site that lists web services.  This example demonstrates using the XMethods \
Query Service to discover and use many of the web services available.  This \
example searches the XMethods database for the web services registered.  The \
example code then places the results in the notebook.  An InstallService \
function is placed in each of the Cells created for each service.  Once the \
query is finished, a user can conveniently browse through the services and \
install the services that may be interesting.  If GetServiceSummaries is \
called again, the code will match service id's with cell tags.  If an id \
exists as a cell tag no new cells will be added.  If an id does not exist the \
appropriate cells are added for the service.\
\>", "Text"],

Cell["\<\
To try this example, evaluate all the initialization cells (you can do this \
with the menu command Kernel/Evaluation/Evaluate Initialization). Then go to \
the Example section.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Code", "Section"],

Cell[BoxData[{
    \(\(\(BeginPackage["\<WebServices`Examples`XMethods`\>", {"\<WebServices`\
\>", "\<JLink`\>"}];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(GetServiceSummaries;\)\(\n\)
    \)\), "\[IndentingNewLine]", 
    \(\(\(Begin["\<`Private`\>"];\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(\(InstallService["\<http://www.xmethods.net/wsdl/query.wsdl\>"];\)\(\
\[IndentingNewLine]\)
    \)\), "\n", 
    \(\(\(GetServiceSummaries[] := 
      Module[{result}, 
        result = getAllServiceSummaries[]; \[IndentingNewLine]If[
          result === $Failed, Return[$Failed]]; \[IndentingNewLine]notebook = 
          EvaluationNotebook[]; \[IndentingNewLine]If[
          NotebookFind[notebook, "\<Results\>", All, {CellTags}] === $Failed, 
          SelectionMove[notebook, After, 
            EvaluationCell]; \[IndentingNewLine]NotebookWrite[notebook, 
            Cell["\<Results\>", "\<Section\>", 
              CellTags \[Rule] {"\<Results\>"}]];]; \
\[IndentingNewLine]printResult /@ result; \[IndentingNewLine]NotebookFind[
          notebook, "\<Results\>", 
          All, {CellTags}];]\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(printResult[result_List] := 
      Module[{name, id, shortDescription, wsdlURL, publisherID}, 
        name = "\<name\>" /. result; \[IndentingNewLine]id = "\<id\>" /. 
            result; \[IndentingNewLine]shortDescription = "\<shortDescription\
\>" /. result; \[IndentingNewLine]wsdlURL = "\<wsdlURL\>" /. 
            result; \[IndentingNewLine]publisherID = "\<publisherID\>" /. 
            result; \[IndentingNewLine]notebook = 
          EvaluationNotebook[]; \[IndentingNewLine]If[
          NotebookFind[notebook, id, All, {CellTags}, 
              AutoScroll \[Rule] False] === $Failed, 
          NotebookFind[notebook, "\<Results\>", All, {CellTags}, 
            AutoScroll \[Rule] False]; \[IndentingNewLine]SelectionMove[
            notebook, After, Cell, 
            AutoScroll \[Rule] False]; \[IndentingNewLine]NotebookWrite[
            notebook, 
            Cell[CellGroupData[{Cell[
                    BoxData[
                      RowBox[{name, 
                          StyleBox["\< from \>", 
                            FontWeight \[Rule] "\<Plain\>"], 
                          StyleBox[publisherID, 
                            FontWeight \[Rule] "\<Plain\>", 
                            FontSlant \[Rule] "\<Italic\>"], 
                          ButtonBox["\<(wsdl)\>", 
                            ButtonData \[Rule] {URL[wsdlURL], None}, 
                            ButtonStyle \[Rule] "\<Hyperlink\>"]}]], \
"\<Subsection\>", ShowGroupOpenCloseIcon \[Rule] True, 
                    CellDingbat \[Rule] None, CellTags \[Rule] {id}], 
                  Cell[shortDescription, "\<Text\>", 
                    ShowCellBracket \[Rule] False, 
                    CellMargins \[Rule] {{55, Inherited}, {Inherited, 
                          Inherited}}, CellFrame \[Rule] True, 
                    Background \[Rule] GrayLevel[0.850004]], 
                  Cell[BoxData[
                      RowBox[{"\<InstallService[\"\>" <> 
                            wsdlURL <> "\<\"]\>"}]], "\<Input\>", 
                    ShowCellBracket \[Rule] False, CellFrame \[Rule] True, 
                    CellMargins \[Rule] {{55, Inherited}, {Inherited, 
                          Inherited}}, 
                    Background \[Rule] GrayLevel[0.850004]]}, 
                Open]]];];]\[IndentingNewLine]\), "\n", 
    \(\(End[];\)\), "\n", 
    \(\(EndPackage[];\)\)}], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell[BoxData[
    \(GetServiceSummaries[]\)], "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
AutoGeneratedPackage->None,
WindowSize->{647, 564},
WindowMargins->{{128, Automatic}, {59, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 44, 0, 95, "Title"],
Cell[1823, 55, 842, 12, 166, "Text"],
Cell[2668, 69, 201, 4, 52, "Text"],

Cell[CellGroupData[{
Cell[2894, 77, 23, 0, 73, "Section"],
Cell[2920, 79, 3621, 68, 970, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[6578, 152, 26, 0, 43, "Section"],
Cell[6607, 154, 54, 1, 30, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

