(* :Author: Chris Williamson *)

Begin["`Package`"];

SchemaNamespaceQ;
SchemaBaseTypeQ;
SchemaInstanceNamespaceQ;
SchemaQ;
IsArray;
GetTargetNamespace;
GetIncludes;
GetIncludeSchemaLocation;
GetTypeDef;
GetTypeName;
GetElementDef;
GetElementMinOccurs;
GetElementMaxOccurs;
GetElementName;
GetElementNillable;
GetElementRef;
GetElementType;
GetElements;
GetRestrictionBase;
GetEnumerations;
QualifiedFormQ;
DefaultQualifiedFormQ;

End[];

Begin["SchemaUtilities`Private`"];

SchemaNamespaceQ[x_String] :=   
  StringMatchQ[x, "http://www.w3.org/1999/XMLSchema"] || 
  StringMatchQ[x, "http://www.w3.org/2000/XMLSchema"] || 
  StringMatchQ[x, "http://www.w3.org/2001/XMLSchema"  ]
  
SchemaNamespaceQ[___] := False

SchemaBaseTypeQ[x_String] :=   
  StringMatchQ[x, "boolean"] || 
  StringMatchQ[x, "int"] || 
  StringMatchQ[x, "integer"] ||
  StringMatchQ[x, "double"] ||
  StringMatchQ[x, "float"] || 
  StringMatchQ[x, "string"] || 
  StringMatchQ[x, "short"] || 
  StringMatchQ[x, "long"] || 
  StringMatchQ[x, "decimal"] || 
  StringMatchQ[x, "byte"] || 
  StringMatchQ[x, "nonPositiveInteger"] || 
  StringMatchQ[x, "negativeInteger"] || 
  StringMatchQ[x, "nonNegativeInteger"] || 
  StringMatchQ[x, "unsignedLong"] || 
  StringMatchQ[x, "unsignedInt"] || 
  StringMatchQ[x, "unsignedShort"] || 
  StringMatchQ[x, "unsignedByte"] || 
  StringMatchQ[x, "positiveInteger"] || 
  StringMatchQ[x, "duration"] || 
  StringMatchQ[x, "dateTime"] || 
  StringMatchQ[x, "time"] || 
  StringMatchQ[x, "date"] || 
  StringMatchQ[x, "gYearMonth"] || 
  StringMatchQ[x, "gYear"] || 
  StringMatchQ[x, "gMonthDay"] || 
  StringMatchQ[x, "gDay"] || 
  StringMatchQ[x, "gMonth"] || 
  StringMatchQ[x, "base64Binary"] || 
  StringMatchQ[x, "hexBinary"] || 
  StringMatchQ[x, "anyURI"] || 
  StringMatchQ[x, "QName"] || 
  StringMatchQ[x, "normalizedString"] || 
  StringMatchQ[x, "token"] || 
  StringMatchQ[x, "language"] || 
  StringMatchQ[x, "Name"] || 
  StringMatchQ[x, "NCName"] || 
  StringMatchQ[x, "anyType"]

SchemaBaseTypeQ[___] := False

(* Used to identify type *)
SchemaInstanceNamespaceQ[x_String] :=   
  StringMatchQ[x, "http://www.w3.org/1999/XMLSchema-instance"] || 
  StringMatchQ[x, "http://www.w3.org/2000/XMLSchema-instance"] || 
  StringMatchQ[x, "http://www.w3.org/2001/XMLSchema-instance"]

SchemaInstanceNamespaceQ[___] := False

SchemaQ[XMLElement[{_?SchemaNamespaceQ, "schema"}, {___}, {___}]] := True;

SchemaQ[___] := False;

IsArray[
  XMLElement[
    {_?SchemaNamespaceQ, "complexType"},
    {___},
    {___,
     XMLElement[
       {_?SchemaNamespaceQ, ("sequence" | "all")},
       {___},
       {element:XMLElement[
          {_?SchemaNamespaceQ, "element"}, 
          {___, {"", "maxOccurs"}->"unbounded", ___}, 
          {___}]
       }],
     ___}]] := True;

IsArray[
  XMLElement[
    {_?SchemaNamespaceQ, "complexType"},
    {___},
    {___,
     XMLElement[
       {_?SchemaNamespaceQ, ("sequence" | "all")},
       {___},
       {element:XMLElement[
          {_?SchemaNamespaceQ, "element"}, 
          {___, {"", "maxOccurs"}->maxOccurs_String, ___}, 
          {___}]
       }],
     ___}]] := 
  If[DigitQ[maxOccurs],
    If[ToExpression[maxOccurs] > 1, 
      True,
      False
    ],
    False
  ];

IsArray[___] = False;

(* Retrieves the targetNamespace from a schema *)
  
GetTargetNamespace[
  XMLElement[
    {_?SchemaNamespaceQ,"schema"},
    {___, {"","targetNamespace"}->targetNamespace_String,___},
    {___}]
  ] := targetNamespace;
          
GetTargetNamespace[___] := Null;

GetIncludes[
  XMLElement[
    {_?SchemaNamespaceQ, "schema"}, 
    {___}, 
    children:{___}]] := 

    Cases[
      children, 
      XMLElement[
        {_?SchemaNamespaceQ, ("include")}, 
        {___}, 
        {___}]];

GetIncludes[___] := {};

GetIncludeSchemaLocation[
  XMLElement[
  {_?SchemaNamespaceQ, "include"}, 
  {___, {"", "schemaLocation"}->schemaLocation_String, ___}, 
  {___}]] := schemaLocation; 

GetIncludeSchemaLocation[___] := Null;

GetTypeDef[
  typeName_String, 
  XMLElement[
    {_?SchemaNamespaceQ, "schema"}, 
    {___}, 
    children:{___}]] := 
  Module[{results},	
    results = 
      Cases[
        children, 
        XMLElement[
          {_?SchemaNamespaceQ, ("complexType" | "simpleType")}, 
          {___, {"", "name"}->typeName, ___}, 
          {___}]];
    If[Length[results] > 0, First[results], Null]
  ];

GetTypeDef[___] := Null;

GetTypeName[
  XMLElement[
    {_?SchemaNamespaceQ, ("simpleType" | "complexType")}, 
    {___,{"", "name"}->name_String,___}, 
    {___}]] := name;

GetTypeName[___] := Null;

GetElementDef[
  elementName_String, 
  schema:XMLElement[
    {_?SchemaNamespaceQ, "complexType"},
    {___},
    {___,
     XMLElement[
       {_?SchemaNamespaceQ, ("sequence" | "all")},
       {___},
       children:{___}],
     ___}]] := 
  Module[{results}, 
    results = 
      Cases[
        children, 
          element:XMLElement[
            {_?SchemaNamespaceQ, "element"}, 
            {___, {"", "name"}->elementName, ___}, 
            {___}] :> element];
    If[Length[results] > 0, First[results], Null]
  ];

GetElementDef[
  Null, 
  XMLElement[
    {_?SchemaNamespaceQ, "complexType"},
    {___},
    {___,
     XMLElement[
       {_?SchemaNamespaceQ, ("sequence" | "all")},
       {___},
       {element:XMLElement[
          {_?SchemaNamespaceQ, "element"}, 
          {___, {"", "maxOccurs"}->"unbounded", ___}, 
          {___}]
       }],
     ___}]] := element;

GetElementDef[
  elementName_String, 
  XMLElement[
    {_?SchemaNamespaceQ, "schema"},
    {___},
    children:{___}]] := 
  Module[{results}, 
    results = 
      Cases[
        children, 
        XMLElement[
          {_?SchemaNamespaceQ, "element"}, 
          {___, {"", "name"}->elementName, ___}, 
          {___}]];
    If[Length[results] > 0, First[results], Null]
  ];


GetElementDef[___] := Null;

GetElementName[
  XMLElement[
    {_?SchemaNamespaceQ, "element"}, 
    {___, {"", "name"}->name_String, ___}, 
    {___}]] := name;

GetElementName[___] := Null;

GetElementType[
  XMLElement[
    {_?SchemaNamespaceQ,"element"},
    {___,{"", "type"}->type_String,___},
    {___}]] := type;

GetElementType[
  XMLElement[
    {_?SchemaNamespaceQ, "element"},
    {___},
    {___, 
     type:XMLElement[
       {_?SchemaNamespaceQ, ("complexType" | "simpleType")}, 
       {___}, 
       {___}],
     ___}]] := type;

GetElementType[___] := Null;

GetElementRef[
  XMLElement[
    {_?SchemaNamespaceQ, "element"}, 
    {___, {"", "ref"}->name_String, ___}, 
    {___}]] := name;

GetElementRef[___] := Null;

GetElementNillable[
  XMLElement[
    {_?SchemaNamespaceQ, "element"}, 
    {___, {_?SchemaInstanceNamespaceQ, "nillable"}->nillable_String, ___}, 
    {___}]] := nillable;

GetElementNillable[___] := Null;

GetElementMaxOccurs[
  XMLElement[
    {_?SchemaNamespaceQ, "element"}, 
    {___, {"", "maxOccurs"}->maxOccurs_String, ___}, 
    {___}]] := maxOccurs;
                       
GetElementMaxOccurs[___] := Null;

GetElementMinOccurs[
  XMLElement[
    {_?SchemaNamespaceQ, "element"}, 
    {___, {"", "minOccurs"}->minOccurs_String, ___}, 
    {___}]] := minOccurs;

GetElementMinOccurs[___] := Null;

GetElements[
  XMLElement[
    {_?SchemaNamespaceQ, "complexType"}, 
    {___}, 
    children:{___}]] :=
  Cases[children, XMLElement[{_?SchemaNamespaceQ, "element"}, {___}, {___}], 3];

GetElements[___] := {};

GetRestrictionBase[type:XMLElement[{_?SchemaNamespaceQ, "simpleType"}, {___}, children:{___}]] :=
  Module[{results},	
    results = Cases[children,
      XMLElement[
        {_?SchemaNamespaceQ, "restriction"}, 
        {___, {"", "base"}->base_String, ___}, 
        {___}] :> base];
    If[Length[results] > 0, First[results], Null]
  ];  
  
GetRestrictionBase[___] := Null;

GetEnumerations[type:XMLElement[
  {_?SchemaNamespaceQ, "simpleType"}, 
  {___}, 
  {XMLElement[
    {_?SchemaNamespaceQ, "restriction"}, 
    {___}, 
    children:{___}]}]] :=
  Cases[
    children,
    XMLElement[
      {_?SchemaNamespaceQ, "enumeration"}, 
      {{"", "value"}->value_String}, 
      {}] :> value];

GetEnumerations[___] := {};

QualifiedFormQ[
  XMLElement[
    {_?SchemaNamespaceQ, "element"}, 
    {___, {"", "form"}->"qualified", ___}, 
    {___}]] := True;

QualifiedFormQ[
  XMLElement[
    {_?SchemaNamespaceQ, "element"}, 
    {___, {"", "form"}->"unqualified", ___}, 
    {___}]] := False;
  
QualifiedFormQ[_, True] := True;
  
QualifiedFormQ[___] := False;

DefaultQualifiedFormQ[XMLElement[
  {_?SchemaNamespaceQ, "schema"}, 
  {___,{"", "elementFormDefault"}->"qualified",___}, 
  {___}]] := True;

DefaultQualifiedFormQ[___] := False;

End[];