(*

   IF YOU WANT TO CUSTOMIZE YOUR SECURITY SYSTEM DO *NOT* MODIFY 
   THIS FILE. THE WAY TO CUSTOMIZE SECURITY IS DESCRIBED IN THE 
   SECURITY SECTION OF THE USER GUIDE.

*)


(* :Name: WebServices`Security` *)

(* :Title: Mathematica Server Pages Security *)

(* :Author: Tom Wickham-Jones *)

(* :Copyright: 
       webMathematica source code (c) 1999-2003,
       Wolfram Research, Inc. All rights reserved.
*)

(* :Mathematica Version: 4.2 *)

(* :Package Version: 2.0 *)

(* :History:
   Original Version by Tom Wickham-Jones as part of MSP tools.
   Developed January - August 2000.
*)

(*:Summary:
   This package provides security features to be used by 
   Mathematica Web Tools.
   
   
   InsecureExprQ[ expr] returns True if expr contains 'insecure symbols' 
   and False otherwise.
   
   Symbols are tested to see if they are allowed or not. The 
   following tests are performed that look at the names and contexts 
   of the symbols.  They steadily remove symbols from the expr,  
   if any remain then the expr is declared insecure.
   
   
   1) If AllowedContexts is set to a list of contexts then all symbols 
      with contexts on this list are allowed.
      
   2) If AllowedContexts is not a list of contexts then all symbols with 
      contexts not in DisallowedContexts are allowed.
   
   The remaining symbols are then tested as follows:
   
   3) If AllowedSymbols is set to a list of symbols then all symbols 
      that appear in the list are allowed.
      
   4) If AllowedSymbols is not set to a list of symbols then all symbols 
      that appear in DisallowedSymbols are not allowed.
      
   
   If any symbols are found that are disallowed then the expr is deemed to 
   be insecure.
      
   
   Using DisallowedSymbols and DisallowedContexts gives most flexibility 
   but with a higher risk.
   
   Using AllowedSymbols and AllowedContexts gives less flexibity but with 
   lower risk.
   
   See examples at bottom.
   
*)

Begin["`Package`"];

InsecureExprQ::usage="InsecureExprQ is used to determine if each of the Symbols in an 
  Expression is secure.  This is most useful to determine when using ToExpression.  This 
  function helps ensure the Expression will not do anything damaging."

SetSecurity::usage="SetSecurity is used to read the security configuration.  The first
  parameter is the directory of the security file and the second parameter is the name
  of the security file.  This function can also be called without parameters and the 
  function will look for a file SecurityConfiguration.m on the $Path."

End[];

Begin[ "`Security`Private`"]

defaultAllowedContexts = 
    {"Global`"}

defaultAllowedSymbols = 
    HoldComplete[
    (* Evaluations *) 
    Abort, AbortProtect,EditIn,Evaluate,MatchLocalNames,MemoryConstrained,MemoryInUse,
    (* Formatting *)
    Above, AccountingForm, AbsoluteDashing, AbsoluteOptions, AbsoluteThickness, AbsoluteTime,
    BaseForm,Baseline,Below,BlankForm,Bottom,ButtonCell,Center,CForm,ColonForm,ColumnForm,DigitQ,
    DisplayForm,DigitBlock,EngineeringForm,ExportString,FontForm,Format,FortranForm,FromCharacterCode,
    ImportString,InputForm,InterpretTemplate,Left,LetterQ,LowerCaseQ,MatrixForm,
    FullForm,HorizontalForm,LongForm,MathMLForm,MetaCharacters,NonAssociative,Normal,NumberForm,
    NumberFormat,NumberMarks,NumberMultiplier,NumberPadding,NumberPoint,NumberSeparator,NumberSigns,
    OutputForm,OutputMathEditExpression,Overlaps,PaddedForm,Parenthesize,Plain,PrecedenceForm,Prefix,
    Precision,PromptForm,Raw,Right,ScientificForm,SequenceForm,SignPadding,SpaceForm,SpellingCorrection,
    StandardForm,StringForm,TableAlignments,TableDepth,TableDirections,TableForm,TableHeadings,TeXForm,
    TableSpacing,ToCharacterCode,ToDate,TraditionalForm,TreeForm,$SuppressInputFormHeads,
    (* Notebook *)
    Active,AllowInlineCells,AnimationCycleOffset,AnimationCycleRepetitions,AnimationDisplayTime,
    AutoIndent,AutoIndentSpacings,AutoItalicWords,AutoOpenPalettes,AutoScroll,AutoSpacing,
    AutoStyleOptions,Cell,CellAutoOverwrite,CellBaseline,CellBoundingBox,CellBracketOptions,
    CellContents,CellDingbat,CellEditDuplicate,CellElementsBoundingBox,CellElementSpacings,
    CellEvaluationDuplicate,CellFrame,CellFrameColor,CellFrameLabelMargins,CellFrameLabels,
    CellFrameMargins,CellGroup,CellGroupData,CellGrouping,CellGroupingRules,CellHorizontalScrolling,
    CellLabel,CellLabelAutoDelete,CellLabelMargins,CellLabelPositioning,CellMargins,CellObject,CellOpen,
    CellPasswords,CellPrint,CellSize,CellStyle,CellTags,ClipboardNotebook,ConsolePrint,
    ConversionRules,Copyable,DefaultDuplicateCellStyle,Deletable,DelimiterFlashTime,Dialog,DialogProlog,
    DialogSymbols,DragAndDrop,Editable,Evaluatable,EvaluationNotebook,Evaluator,ExitDialog,FontColor,
    FontFamily,FrontEndExecute,GeneratedCell,GroupPageBreakWithin,Hyphenation,ImageMargins,InputAliases,
    InitializationCell,InputAutoReplacements,InputNotebook,LanguageCategory,LineIndent,LineSpacing,
    Magnification,Notebook,PageBreakAbove,PageBreakBelow,PageBreakWithin,PageWidth,ParagraphIndent,
    ParagraphSpacing,PrintingStyleEnvironment,ScreenStyleEnvironment,Selectable,SelectedNotebook,
    SelectionCreateCell,SelectionEvaluate,SelectionEvaluateCreateCell,SelectionMove,SetSelectedNotebook,
    ShowAutoStyles,ShowCellBracket,ShowCellLabel,ShowCellTags,ShowCursorTracker,ShowPageBreaks,
    ShowSelection,ShowSpecialCharacters,ShowStringCharacters,SingleLetterItalics,StructuredSelection,
    StyleDefinitions, StyleForm,StylePrint,TextAlignment,TextJustification,Visible,WindowClickSelect, 
    WindowElements, WindowFloating, WindowFrame, WindowMargins, WindowMovable, WindowSize, WindowTitle, 
    WindowToolbars,
    (*Boxes *)
    AdjustmentBox,AdjustmentBoxOptions,AutoDelete,BoxData,Box,BoxBaselineShift,BoxDimensions,BoxForm,
    BoxFormFormatTypes,BoxFrame,BoxMargins,BoxRatios,BoxRegion,BoxStyle,ButtonBox,ButtonBoxOptions,
    Button,ButtonContents,ButtonData,ButtonEvaluator,ButtonExpandable,ButtonFrame,ButtonFunction,
    ButtonMargins,ButtonMinHeight,ButtonNote,ButtonNotebook,ButtonSource,ButtonStyle,
    ButtonStyleMenuListing,Column,ColumnAlignments,ColumnLines,ColumnsEqual,ColumnSpacings,CounterBox,
    CounterBoxOptions,CounterFunction,CounterIncrements,CounterStyle,CounterStyleMenuListing,
    ColumnWidths,Decimal,DefaultNewCellStyle,DeletionWarning,EqualColumns,EqualRows,ErrorBox,FontName,
    FontPostScriptName,FontSize,FontSlant,FontSubstitutions,FontTracking,FontWeight,FormBox,FractionBox,
    FrameBox,ErrorBoxOptions,GridBaseline,GridBox,GridDefaultElement,InterpretationBox,LimitsPositioning,
    MakeBoxes,MinSize,MultilineFunction,OverscriptBox,ParentForm,RadicalBox,RowAlignments,RowBox,RowLines,
    RowMinHeight,RowsEqual,RowSpacings,ScriptBaselineShifts,ScriptMinSize,ScriptSizeMultipliers,
    SpanAdjustments,SpanCharacterRounding,SpanMaxSize,SpanMinSize,SqrtBox,StripBoxes,StripWrapperBoxes,
    StyleBox,SubscriptBox,SubsuperscriptBox,SuperscriptBox,TagBox,ToBoxes,UnderoverscriptBox,
    UnderscriptBox,$BoxForms,
    (*Math symbols *) 
    Abs,Accuracy,AccuracyGoal,Adams,AddTo,AiryAi,AiryAiPrime,AiryBi,AiryBiPrime,AlgebraicRulesData,
    AlgebraicRules,Algebraics,Analytic,Apart,ApartSquareFree,AppellF1,ArcCos, ArcCosh,ArcCot,ArcCoth,
    ArcCsc,ArcCsch,ArcSec,ArcSech,ArcSin,ArcSinh,ArcTan,ArcTanh,Arg,ArithmeticGeometricMean,Assumptions,
    BernoulliB,BesselI,BesselJ,BesselK,BesselY,Beta,BetaRegularized,Binomial,Booleans,C,Cancel,
    CarmichaelLambda,Catalan,Ceiling,CellularAutomaton,CharacteristicPolynomial,ChebyshevT,ChebyshevU,
    Chop,ClebschGordan,Coefficient,CoefficientDomain,CoefficientList,CofactorExpansion,Collect,
    Complexes,ComplexExpand,ComplexInfinity,ComplexityFunction,ComposeSeries,Composition,Congruent,
    Conjugate,Constant,Constants,ConstrainedMax,ConstrainedMin,ContinuedFraction,Cos,Cosh,CoshIntegral,
    CosIntegral,Cot,Coth,Cyclotomic,D,DampingFactor,Decompose,Decrement,DedekindEta,Csc,Csch,Cross,
    DefaultValues,Degree,DegreeLexicographic,DegreeReverseLexicographic,Denominator,Derivative,Det,
    DifferenceOrder,DigitCount,DiracDelta,DirectedInfinity,Direction,DiscreteDelta,Divide,DivideBy,
    DivisionFreeRowReduction,Divisors,DivisorSigma,Dot,DoubleExponential,DoublyInfinite,DSolve,
    DSolveConstants,Dt,E,Eigensystem,Eigenvalues,Eigenvectors,Eliminate,EliminationOrder,EllipticE,
    EllipticExp,EllipticExpPrime,EllipticF,EllipticK,EllipticLog,EllipticNomeQ,EllipticPi,
    EllipticReducedHalfPeriods,EllipticTheta,EllipticThetaPrime,EquatedTo,Erf,Erfc,Erfi,EulerE,
    EulerGamma,EulerPhi,EvaluationMonitor,EvenQ,ExactNumberQ,ExactRootIsolation,ExcludedForms,Exists,
    Exp,Expand,ExpandAll,ExpandDenominator,ExpandNumerator,ExpIntegralE,ExpIntegralEi,Exponent,
    ExponentFunction,ExponentPosition,ExponentStep,ExpToTrig,ExtendedGCD,Factor,Factorial,Factorial2,
    FactorInteger,FactorList,FactorSquareFree,FactorSquareFreeList,FactorTerms,FactorTermsList,
    Fibonacci,FindFit,FindInstance,FindMaximum,FindMinimum,FindRoot,Fit,FixedPoint,FixedPointList,
    Flat,Floor,Fold,FoldList,Fourier,FourierCosTransform,FourierParameters,FourierSinTransform,
    FourierTransform,FractionalPart,FresnelC,FresnelS,FromContinuedFraction,FullSimplify,FunctionExpand,
    FunctionInterpolation,Gamma,GammaRegularized,GaussianIntegers,GaussKronrod,GaussPoints,GCD,GegenbauerC,
    GenerateConditions,Generic,Glaisher,GoldenRatio,Gradient,GroebnerBasis,HarmonicNumber,HermiteH,
    Hessian,Hypergeometric0F1,Hypergeometric0F1Regularized,Hypergeometric1F1,Hypergeometric1F1Regularized,
    Hypergeometric2F1,Hypergeometric2F1Regularized,HypergeometricPFQ,HypergeometricPFQRegularized,
    HypergeometricU,I,Identity,IdentityMatrix,Im,Implies,IncludeSingularTerm,Increment,Indeterminate,
    Inequality,InexactNumbers,Infinity,Infix,Integer,IntegerDigits,IntegerExponent,IntegerPart,IntegerQ,
    Integers,Integrate,InterpolatingFunction,InterpolatingPolynomial,Interpolation,InterpolationOrder,
    InterpolationPoints,InverseBetaRegularized,InverseEllipticNomeQ,InverseErf,InverseErfc,InverseFourier,
    InverseFourierCosTransform,InverseFourierSinTransform,InverseFourierTransform,InverseFunction,
    InverseFunctions,InverseGammaRegularized,InverseJacobiCD,InverseJacobiCN,InverseJacobiCS,
    InverseJacobiDC,InverseJacobiDN,InverseJacobiDS,InverseJacobiNC,InverseJacobiND,InverseJacobiNS,
    InverseJacobiSC,InverseJacobiSD,InverseJacobiSN,InverseLaplaceTransform,InverseSeries,
    InverseWeierstrassP,InverseZTransform,JacobiAmplitude, Jacobian, JacobiCD, JacobiCN, JacobiCS, JacobiDC,
    JacobiDN, JacobiDS, JacobiNC, JacobiND, JacobiNS, JacobiP, JacobiSC, JacobiSD, JacobiSN, JacobiSymbol, 
    JacobiZeta, JordanDecomposition,K, Khinchin, KleinInvariantJ, KroneckerDelta,LaguerreL,LaplaceTransform,
    LCM,LegendreP,LegendreQ,LegendreType,LerchPhi,Lexicographic,Limit,LinearProgramming,LinearSolve,
    LinearSolveFunction,ListConvolve,ListCorrelate,ListInterpolation,Log,LogGamma,LogicalExpand,LogIntegral,
    LUDecomposition,MachineNumberQ,MachinePrecision,MainSolve,MakeRules,MantissaExponent,MathieuC,
    MathieuCharacteristicA,MathieuCharacteristicB,MathieuCharacteristicExponent,MathieuCPrime, MathieuS, 
    MathieuSPrime,MatrixExp,MatrixPower,MatrixQ,MatrixRank,MaxStepSize,Mean,Median,MeijerG,MaxRecursion,
    Method,Minimize,Minors,MinRecursion,Minus,Mod,Mode,Modular,ModularLambda,Modulus,MoebiusMu,
    MonomialOrder,MonteCarlo,MultiDimensional,Multinomial,MultiplicativeOrder,Multiplicity,N,NBernoulliB,
    NDSolve,Negative,NevilleThetaC,NevilleThetaD,NevilleThetaN,NevilleThetaS,Newton,NHoldAll,NHoldFirst,
    NHoldRest,NIntegrate,NMaximize,NMinimize,NonCommutativeMultiply,NonConstants,NonNegative,NonPositive,
    Norm,NProduct,NProductExtraFactors,NProductFactors,NRoots,Solve, NSum, NSumExtraTerms, NSumTerms,
    Numerator,NumericFunction,NumericQ,NValues,O,OddQ,OneIdentity,OneStepRowReduction,Operate,Order,
    Orderless,Oscillatory,OwnValues,ParameterVariables,PartitionsP,PartitionsQ,Pi,Plus,Pochhammer,
    PolyGamma,PolyLog,PolynomialGCD,PolynomialLCM,PolynomialMod,PolynomialQ,PolynomialQuotient,
    PolynomialReduce,PolynomialRemainder,Polynomials,Positive,Power,PowerExpand,PowerMod,PrecisionGoal,
    PreDecrement,PreIncrement,Prime,PrimePi,PrimeQ,Primes,PrincipalValue,Product,ProductLog,PseudoInverse,
    QRDecomposition,Quantile,QuasiMonteCarlo,QuasiNewton,Quotient,Random,RationalFunctions,Rationalize,
    Rationals,Re,RealBlockForm,RealDigits,Reals,Reduce,Refine,Residue,Resolve,Resultant,RiemannSiegelTheta,
    RiemannSiegelZ,Root,RootReduce,Roots,RootSum,Round,RowReduce,RSolve,SameTest,SchurDecomposition,Sec,
    Sech,SeedRandom,SequenceLimit,Series,SeriesCoefficient,SeriesData,Signature,Simplify,Sin,
    SingularityDepth,SingularValueDecomposition,SingularValueList,Sinh,SinhIntegral,SinIntegral,
    SixJSymbol,Solve,SolveAlways,SolveDelayed,SphericalHarmonicY,Sqrt,StandardDeviation,StartingStepSize,
    StepMonitor,StieltjesGamma,StirlingS1,StirlingS2,StoppingTest,StruveH,StruveL,Subresultants,Subtract,
    SubtractFrom,Sum,Tan,Tanh,TargetFunctions,ThreeJSymbol,TimeConstraint,Times,TimesBy,Together,
    Tolerance,ToRadicals,ToRules,Tr,TransformationFunctions,Trapezoidal,Trig,TrigExpand,TrigFactor, 
    TrigFactorList, TrigReduce, TrigToExp,Underflow,UnitStep,Using,Variables,Variance,VectorQ,
    VerifyConvergence,VerifySolutions,WeierstrassHalfPeriods,WeierstrassInvariants,WeierstrassP,
    WeierstrassPPrime,WeierstrassSigma,WeierstrassZeta,WorkingPrecision,WynnDegree,ZeroTest,Zeta,
    $Assumptions,$MachinePrecision,$MachineEpsilon,$MaxExtraPrecision,$MaxMachineNumber, $MaxNumber, 
    $MaxPrecision, $MaxRootDegree,$MinMachineNumber, $MinNumber, $MinPrecision,ZTransform,$RandomState,
    (*Expression*)
    ArgumentCountQ,AtomQ,Attributes,Byte,ByteCount,ByteOrdering,Character,CharacterEncoding,
    CharacterEncodingsPath,CharacterRange,Characters,Complex,CompoundExpression,Context,Contexts,
    ContextToFilename,ContextToFileName,Definition,Depth,Dimensions,DownValues,EditDefinition,
    Expression,FullDefinition,Function,GeneratedParameters,Head,HeadCompose,Heads,Hold,HoldAll,
    HoldAllComplete,HoldComplete,HoldFirst,HoldForm,HoldPattern,HoldRest,Information,LeafCount,Level,
    Listable,Literal,Locked,MakeExpression,NameQ,Names,Number,NumberQ,OptionQ,Options,Out,Overflow,Part,
    Placeholder,Prepend,PrependTo,PrimaryPlaceholder,Rational,Real,ReleaseHold,Removed,Replace,ReplaceAll,
    ReplaceHeldPart,ReplaceList,ReplacePart,ReplaceRepeated,Rest,Return,Reverse,RotateLeft,RotateRight,
    Rule,RuleDelayed,SameQ,Scan,Sequence,SequenceHold,SetAccuracy,SetPrecision,Shallow,Share,Short,Sign,
    Skeleton,Slot,SlotSequence,Sow,SparseArray,String,StringByteCount,StringDrop,StringInsert,StringJoin,
    StringLength,StringMatchQ,StringPosition,StringQ,StringReplace,StringReplacePart,StringReverse,
    StringSkeleton,StringTake,StringToStream,SubValues,Symbol, SymbolName,SyntaxLength,SyntaxQ,Temporary,
    Thread,Through,ToHeldExpression,ToLowerCase,ToString,ToUpperCase,Unevaluated,Unique,UnsameQ,Update,
    UpperCaseQ,ValueQ,Verbatim,
    (* List *)
    Append,AppendTo,Apply,Array,Complement,ComposeList,Count,DeleteCases,Delimiters,DiagonalMatrix,
    Dispatch,Distribute,Drop,Element,Extract,First,Flatten,FlattenAt,HashTable,HeldPart,Inner,Insert,
    Intersection,Interval,IntervalIntersection,IntervalMemberQ,IntervalUnion,Inverse,Join,Last,
    LatticeReduce,Length,List,ListQ,Map,MapAll,MapAt,MapIndexed,MapThread,Max,Maximize,MaxIterations,Most,
    MemberQ,Min,Nest,NestList,NestWhile,NestWhileList,NullSpace,OrderedQ,Ordering,Outer,PadLeft,PadRight,
    Partition,Permutations,Pivoting,Range,Reap,Select,Sort,Split,Table,Take,Total,Transpose,Union,
    (* Patterns and Logic *)
    Alternatives,And,BitAnd,BitNot,BitOr,BitXor,Blank,BlankNullSequence,BlankSequence,Cases,Default,
    Equal,False,FreeQ,Greater,GreaterEqual,If,IgnoreCase,Less,LessEqual,MatchQ,Nand,Nor,Not,Optional,Or,
    Pattern,PatternTest,Position,Repeated,RepeatedNull,Switch,True,TrueQ,Unequal,Which,Xor,
    (* Graphics *)
    AmbientLight,AspectRatio,AspectRatioFixed,Axes,AxesEdge,AxesLabel,AxesOrigin,AxesStyle,Axis,Boxed,
    Background,Circle,ClipFill,CMYKColor,ColorFunction,ColorFunctionScaling,ColorOutput,ContourGraphics,
    ContourLines,ContourPlot,Contours,ContourShading,ContourSmoothing,ContourStyle,
    ColorSelectorSettings,Cuboid,Dashing,DefaultColor,DefaultFont,DensityGraphics,DensityPlot,Disk,
    DisplayFunction,DisplayString,Display,EdgeForm,Epilog,FaceForm,FaceGrids,FormatType,Frame,
    FrameLabel,FrameStyle,FrameTicks,FullAxes,FullGraphics,Graphics,Graphics3D,GraphicsArray,
    GraphicsData,GraphicsSpacing,GrayLevel,GridLines,HiddenSurface,Hue,ImageResolution,ImageRotated,
    ImageSize,Lighting,LightSources,Line,LineForm,ListContourPlot,ListDensityPlot,ListPlot,ListPlot3D,
    MaxBend,MaxPoints,Mesh,MeshRange,MeshStyle,Offset,ParametricPlot,ParametricPlot3D,Plot,Plot3D,
    Plot3Matrix,PlotDivision, PlotJoined, PlotLabel, PlotPoints, PlotRange, PlotRegion, PlotStyle,
    Point,PointForm,PointSize,Polygon,PolygonIntersections,PostScript,Prolog,Raster,RasterArray,Rectangle,
    RenderAll,RGBColor,RotateLabel,Scaled,SelectionAnimate,Shading,Show,SphericalRegion,SurfaceColor, 
    SurfaceGraphics,Text,TextStyle,Thickness,Ticks,ToColor,ViewCenter,ViewPoint,ViewVertical,$DefaultFont,
    $DisplayFunction,$FormatType,$TextStyle,
    (* What are these? *)
    (*
    ActiveItem,AddOnHelpPath,After,Alias,AlignmentMarker,AllowScriptLevelChange,AutoEvaluateEvents,
    AutoGeneratedPackage,AutoloadPath,BackgroundTasksSettings,Backslash,Backward,Before,Bounds,Closed,
    ClosingAutoSave,CommonDefaultFormatTypes,Compose,ConfigurationPath,ContentsBoundingBox,
    Continuation,CounterAssignments,Cubics,DefaultFontProperties,DefaultFormatType,
    DefaultFormatTypeForStyle,DefaultInlineFormatType,DefaultInputFormatType,DefaultNaturalLanguage,
    DefaultNewInlineCellStyle,DefaultNotebook,DefaultOutputFormatType,DefaultStyleDefinitions,
    DefaultTextFormatType,DefaultTextInlineFormatType, DefineExternal,DelimiterMatching,
    DiacriticalPositioning,DialogIndent,DisplayAnimation,DisplayRules,Down,DrawHighlighted,Edit,
    EditButtonSettings,EditCellTagsSettings,Empty,Enter,ErrorNorm,ErrorsDialogSettings,
    EvaluationCompletionAction,EvaluationCell,EvaluatorNames,EventEvaluator,ExportAutoReplacements,
    ExternalCall,ExternalDataCharacterEncoding,FactorComplete,Fail,File,FileBrowse,FileFormat,FileName,
    FileNameDialogSettings,FindSettings,FitAll,Font,FontProperties,FontReencoding,FontVariations,
    FormatRules,FormatTypeAutoConvert,FormBoxOptions,Forward,ForwardBackward,FractionBoxOptions,
    FractionLine,FrameBoxOptions,FrontEndObject,FrontEndStackSize,FrontEndToken,FrontEndTokenExecute,
    FrontEndVersion,GenerateBitmapCaches, GetFileName,GlobalPreferences,GlobalSession,GraphicsGrouping,
    Grid,GridBoxOptions,GridCreationSettings,GridFrame,GridFrameMargins,Hash,HelpBrowserLookup,
    HelpBrowserNotebook,HelpBrowserSettings,Horizontal,HorizontalScrollPosition,HyperlinkCreationSettings,
    HyphenationOptions,ImageCache,ImageCacheValid,ImageOffset,ImageRangeCache,ImageRegion,
    ImportAutoReplacements,IncludeFileExtension,Indent,IndentingNewlineSpacings,IndentMaxFraction,
    IndexCreationOptions,InexactNumberQ,Inherited,InitializationCellEvaluation,InitializationCellWarning,
    InlineCounterAssignments,InlineCounterIncrements,InlineRules,InputAutoFormat,InputGrouping,
    InputSettings,InputToInputForm,InputToStandardForm,InsertionPointObject,Interactive,Interlaced,
    InterpolationPrecision,InterpretationBoxOptions,InterruptSettings,Language,Larger,LayoutInformation,
    LimitsPositioningTokens,LineBreak,LinebreakAdjustments,LineBreakWithin,LineWrapParts,LiteralSearch,
    LUBackSubstitution,MacintoshSystemPageSetup,Manual,MatchLocalNameQ,MathematicaNotation,MathMLText,
    MaxStepFraction,MaxSteps,MessageOptions,MethodOptions,MousePointerNote,MultilaunchWarning,
    NeedCurrentFrontEndPackagePacket,NeedCurrentFrontEndSymbolsPacket,NestedScriptRules,Next,
    NormalGrouping,Normalized,NormalSelection,NormFunction,NotElement,OLEData,Open,OpenSpecialOptions,
    OptimizationLevel,OptionInspectorSettings,OptionValueBox,OptionValueBoxOptions,OutputAutoOverwrite,
    OutputFormData,OutputGrouping,OutputToOutputForm,OutputToStandardForm,Over,Overscript,
    OverscriptBoxOptions,PageFooterLines, PageFooters, PageHeaderLines, PageHeaders, PageHeight,
    PalettePath, PaperWidth,ParentConnect,PasteBoxFormInlineCells,PeriodicInterpolation,PolynomialForm,
    PowerModList,Precedence,PreferencesPath,PreserveStyleSheet,Previous,PrintAction,PrintForm,
    PrintingCopies,PrintingOptions,PrintingPageRange,PrintingStartingPageNumber,PrintPrecision,
    PrivateCellOptions,PrivateEvaluationOptions,PrivateFontOptions,PrivateNotebookOptions,PrivatePaths,
    Quartics,RadicalBoxOptions,RandomSeed,RawData,RawMedium,Release,RenderingOptions,RepeatedString,Row,
    RuleCondition,RuleForm,RulerUnits,Saveable,SaveAutoDelete,ScreenRectangle,ScriptLevel,ScriptRules,
    ScrollingOptions,ScrollPosition,SectionGrouping,Selection,SelectionCell,SelectionCellCreateCell,
    SelectionCellDefaultStyle,SelectionCellParentStyle,SelectionDuplicateCell,SelectionSetStyle,
    SelectionStrategy,SendFontInformationToKernel,SetEvaluationNotebook,SetFileLoadingContext,
    SetNotebookStatusLine,SetValue,ShowClosedCellArea,ShowContents,ShowGroupOpenCloseIcon,ShowShortBoxForm,
    ShrinkWrapBoundingBox,SingularValues,Smaller,SoundAndGraphics,Space,SpanLineThickness,
    SpanningCharacters,SpanSymmetric,Sparse,SpellingDictionaries,SpellingDictionariesPath,SpellingOptions,
    SpellingSuggestionsPacket,Spherical,SqrtBoxOptions,StartupSound,StringBreak,StyleBoxAutoDelete,
    StyleBoxOptions,StyleData,StyleMenuListing, StyleNameDialogSettings,StyleSheetPath,Subscript,
    SubscriptBoxOptions, Subscripted, Subsuperscript,SubsuperscriptBoxOptions,SugarCube,Superscript,
    SuperscriptBoxOptions,SylvesterMatrix,Syntax, SyntaxForm,SystemException, SystemHelpPath, SystemStub,
    Tab,TabFilling,TabSpacings,TagBoxOptions,TaggingRules,TagStyle,TemporaryVariable,TensorQ,TensorRank,
    TextBoundingBox,TextData,TextForm,TextLine,TextParagraph,TitleGrouping,Toggle,ToggleFalse,TooBig,
    Top,TotalHeight,TraditionalFunctionNotation, TraditionalNotation, TraditionalOrder,TransparentColor,
    UnAlias,Underoverscript,UnderoverscriptBoxOptions,Underscript,UnderscriptBoxOptions,Up,Value,
    ValueBox,ValueBoxOptions,ValueForm,Verbose,Version, VersionNumber, Vertical,VerticalForm,
    ViewPointSelectorSettings,VisibleCell,WindowFrameElements,WindowWidth,ZeroWidthTimes,
    $AnimationDisplayFunction,$AnimationFunction,$ConditionHold,$InterfaceEnvironment,$Off,$PrintLiteral,
    $PSDirectDisplay,$RasterFunction,$RootDirectory,$SoundDisplay,$TraceOff,$TraceOn,
    *)
    (* Control statements *)
    Break,Catch,Check,CheckAbort,CheckAll,Compile,Compiled,CompiledFunction,CompileOptimizations,
    Condition,Continue,Do,For,ForAll,Off,On,Throw,TimeConstrained,While,$Aborted,$IterationLimit,
    $Line,$RecursionLimit,
    (*Packages *)
    Begin,BeginPackage,Block,DeclarePackage,End,EndAdd,EndPackage,Module,With,
    (* Find *)
    AnchoredSearch,Find,Goto,Label,Record,RecordSeparators,Word,WordSearch,WordSeparators,
    (* General *)
    All,Automatic,Date,Debug,FromDate,FromDigits,FullOptions,General,In,Input,InputStream,InputString,
    InString,Interrupt,Message,MessageList,MessageName,Messages,None,Null,Postfix,Print,Timing,Trace,
    TraceAbove,TraceAction,TraceBackward,TraceDepth,TraceDialog, TraceForward, TraceInternal, TraceLevel, 
    TraceOff, TraceOn, TraceOriginal, TracePrint, TraceScan,URL,XMLElement,XMLObject,$,$Failed,
    $MessagePrePrint,$PrePrint,$PreRead,$TimeUnit,$TracePattern,$TracePostAction,$TracePreAction
    ]

(* Symbols left out...
  BeginDialogPacket,BeginFrontEndInteractionPacket,BinaryGet,CallPacket,Clear,ClearAll,ClearAttributes,
  Close,CompletionsListPacket,Connect,ConsoleMessage,ConsoleMessagePacket,ConversionOptions,
  ConvertToBitmapPacket,ConvertToPostScript,ConvertToPostScriptPacket,CopyDirectory,CopyFile,
  CreateDirectory,CreatePalettePacket,CurrentlySpeakingPacket,Delete,DeleteContents,DeleteDirectory,
  DeleteFile,Directory,DirectoryName,DirectoryStack,DisableConsolePrintPacket,DisplayEndPacket,
  DisplayFlushImagePacket,DisplayPacket,DisplaySetSizePacket,DOSTextFormat,DumpGet,DumpSave,
  EnableConsolePrintPacket,Encode,EndDialogPacket,EndFrontEndInteractionPacket,EndOfFile,
  EnterExpressionPacket,EnterTextPacket,Environment,ErrorPacket,EvaluatePacket,Exit,Export,
  ExportPacket,ExpressionPacket,FEDisableConsolePrintPacket,FEEnableConsolePrintPacket,FileByteCount,
  FileDate,FileInformation,FileNames,FileType,FindList,FlushPrintOutputPacket,Get,GetBoundingBoxSizePacket,
  GetContext,GetFrontEndOptionsDataPacket,GetLinebreakInformationPacket,GetMenusPacket,
  GetPageBreakInformationPacket,HomeDirectory,HTMLSave,Import,InputNamePacket,InputPacket,
  InputStringPacket,InputToBoxFormPacket,Install,Launch,LicenseID,LinkActivate, LinkClose, LinkConnect, 
  LinkConnectedQ, LinkCreate, LinkError, LinkFlush, LinkHost, LinkInterrupt, LinkLaunch, LinkMode, 
  LinkObject, LinkOpen, LinkOptions, LinkPatterns, LinkProtocol, LinkRead, LinkReadHeld, LinkReadyQ, Links,
  LinkWrite, LinkWriteHeld,Listen,ListPlay,Loopback,MachineID,MachineName,MaxMemoryUsed,MenuPacket,
  MessagePacket,MessagesNotebook,Needs,NotebookApply, NotebookAutoSave, NotebookClose, NotebookConvert, 
  NotebookConvertSettings, NotebookCreate, NotebookCreateReturnObject, NotebookDefault, NotebookDelete, 
  NotebookDirectory, NotebookFind, NotebookFindReturnObject, NotebookGet, 
  NotebookGetLayoutInformationPacket,NotebookGetMisspellingsPacket, NotebookInformation, NotebookLocate,
  NotebookObject, NotebookOpen, NotebookOpenReturnObject, NotebookPath, NotebookPrint, NotebookPut, 
  NotebookPutReturnObject, NotebookRead, NotebookResetGeneratedCells, Notebooks, NotebookSave, 
  NotebookSaveAs,NotebookSelection, NotebookSetupLayoutInformationPacket, NotebooksMenu, NotebookWrite,
  NullRecords,NullWords,OpenAppend,OpenFunctionInspectorPacket,OpenRead,OpenTemporary,OpenWrite,
  OptionsPacket,OutputNamePacket,OutputStream,ParentDirectory,Path,Pause,Play,PlayRange,Protect,Protected,
  Put,PutAppend,Quit,Read,ReadList,ReadProtected,RecordLists,Reinstall,Remove,RenameDirectory,RenameFile,
  ResetDirectory,ResetMedium,ResumePacket,ReturnExpressionPacket,ReturnInputFormPacket,ReturnPacket,
  ReturnTextPacket,ResetMenusPacket,Run,RunThrough,SampleDepth,SampledSoundFunction,SampledSoundList,
  SampleRate,Save,Second,SessionTime,Set,SetAttributes,SetBoxFormNamesPacket,SetDelayed,SetDirectory,
  SetFileDate,SetOptions,SetOptionsPacket,SetSpeechParametersPacket,SetStreamPosition,Skip,Socket,Sound,
  SpeakTextPacket,Splice,Stack,StackBegin,StackComplete,StackInhibit,StreamPosition,Streams,Stub,
  SuspendPacket,SyntaxPacket,TagSet,TagSetDelayed,TagUnset,TeXSave,TextPacket,TextRendering,ThisLink,
  TimeUsed,TimeZone,ToExpression,ToFileName,TokenWords,TotalWidth,UndocumentedTestFEParserPacket,
  UndocumentedTestGetSelectionPacket,Uninstall,Unprotect,Unset,UpSet,UpSetDelayed,UpValues,V2Get,
  VerboseConvertToPostScriptPacket,Write,WriteString,$AddOnsDirectory,$BaseDirectory,$BatchInput,
  $BatchOutput,$ByteOrdering,$CharacterEncoding,$CommandLine,$Context,$ContextPath,$CreationDate,
  $CurrentLink,$DefaultPath,$Display,$DumpDates,$DumpSupported,$Echo,$Epilog,$ExportFormats,$FrontEnd,
  $HistoryLength,$HomeDirectory,$IgnoreEOF,$ImportFormats,$InitialDirectory,$Input,$Inspector,
  $InstallationDate,$InstallationDirectory,$Language,$LaunchDirectory,$LicenseExpirationDate,
  $LicenseID,$LicenseProcesses,$LicenseServer,$Linked,$LinkSupported,$MachineDomain,$MachineID,
  $MachineName,$MachineType,$MaxLicenseProcesses,$MessageList,$Messages,$ModuleNumber,$NetworkLicense,
  $NewMessage,$NewSymbol,$Notebooks,$NumberMarks,$OperatingSystem,$Output,$OutputForms,$Packages,
  $ParentLink,$ParentProcessID,$PasswordFile,$Path,$PathnameSeparator,$PipeSupported,$Post,$Pre,
  $PreferencesDirectory,$PrintForms,$ProcessID,$ProcessorType,$ProductInformation,$ProgramName,
  $ReleaseNumber,$SessionID,$SoundDisplayFunction,$SyntaxHandler,$System,$SystemCharacterEncoding,
  $SystemID,$TemporaryPrefix,$TopDirectory,$Urgent,$UserAddOnsDirectory,$UserBaseDirectory,$UserName,
  $Version,$VersionNumber
*)

SetAttributes[ SymbolSecureByContext, HoldFirst]

(*
    If AllowedContexts is a list return True if context of symbol is 
    not in list.   Else return True if context of symbol is in 
    DisallowedContexts.
*)

SymbolSecureByContext[ x_Symbol] := 
    If[ ListQ[ WebServices`Security`AllowedContexts],
            !MemberQ[ WebServices`Security`AllowedContexts, Context[x]],
            MemberQ[ WebServices`Security`DisallowedContexts, Context[ x]]]

SymbolSecureByContext[ x_] := False



InsecureExprQ[ e_HoldComplete] :=
    Module[ {work},
        work = Level[ e, {-1}, HoldComplete, Heads->True] ;
        work = Select[ work, SymbolSecureByContext] ;
        work = 
            Which[ 
                Head[ WebServices`Security`AllowedSymbols] === HoldComplete,
                    Complement[ work, WebServices`Security`AllowedSymbols],
                Head[ WebServices`Security`DisallowedSymbols] === HoldComplete,
                    Intersection[ work, WebServices`Security`DisallowedSymbols],
                True, HoldComplete[ HoldComplete]] ;
        work =!= HoldComplete[] && work =!= HoldComplete[ HoldComplete]
    ]

InsecureExprQ[ a_] := True

LoadSecurityConfiguration[ dir_, file_] :=
    Module[ {arg},
        arg = ToFileName[ dir, file] ;
        If[ FileType[ arg] === File,
            Get[ arg];
            True,
            False]
        ]

SecurityOpenQ = True;

SetSecurity[ ] :=
    SetSecurity[ None, None]

SetSecurity[ dir_, file_] :=
    Module[ {found = True},
        If[ SecurityOpenQ,
            If[ StringQ[ dir] && StringQ[ file],
                found = LoadSecurityConfiguration[ dir, file]] ;
            Which[ 
                MatchQ[ WebServices`Security`AllowedContexts, {___String}],
                    1,
                MatchQ[ WebServices`Security`DisallowedContexts, {___String}],
                    Clear[ WebServices`Security`AllowedContexts],
                True,
                    WebServices`Security`AllowedContexts = defaultAllowedContexts];

            Which[ 
                MatchQ[ WebServices`Security`AllowedSymbols, HoldComplete[___Symbol]],
                    1,
                MatchQ[ WebServices`Security`DisallowedSymbols, HoldComplete[___Symbol]],
                    Clear[ WebServices`Security`AllowedSymbols],
                True,
                    WebServices`Security`AllowedSymbols = defaultAllowedSymbols];

            LockProtectSymbol[ WebServices`Security`AllowedContexts];
            LockProtectSymbol[ WebServices`Security`DisallowedContexts];
            LockProtectSymbol[ WebServices`Security`AllowedSymbols];
            LockProtectSymbol[ WebServices`Security`DisallowedSymbols];
            LockProtectSymbol[ InsecureExprQ];
            SecurityOpenQ = False;
            ];
        found
    ]


SetAttributes[ LockProtectSymbol, HoldAllComplete]

LockProtectSymbol[sym_] :=
    (
    Protect[ sym] ;
    SetAttributes[ sym, Locked];
    )
    
WebServices`Package`$webServicesSecurityInitialized = True;    
    
End[]
