(* Patch For Chris.m :  Jason Harris,  June 20, 2003  at 18:35:31       *)
(* This file is machine generated from Patch For Chris.nb*)
(* Please consult the source file Patch For Chris.nb. *)


(*
   This is a patch for Mathematica versions 4.x.x to the XML function ToVerboseXML
*)

(*
   Platform effected: all
*)

(*
   Version Number: 4.x.x
*)

(*
   Problem Description: If you try to perform XML`ToVerboseXML on SymbolicXML which does not have any parts of the form 
   XMLElement[String_,__] then ToVerboseXML will leave the expression untouched. Whereas it should still perform 
   attribute namespace expansion.
*)

(*
   Force the loading of the XML functionality if not already loaded
*)

(*
   This is a patch for 4.2 and possibly earlier so it acts like 5.0 with respect to ToVerboseXML`
*)
If[
   $VersionNumber < 4.999,
   Module[
      {wasProtected},
      (
         wasProtected = Unprotect[XML`ToVerboseXML];
         XML`ToVerboseXML[
            System`Convert`XMLDump`data_,
            System`Convert`XMLDump`exposePatt_,
            System`Convert`XMLDump`options___Rule
         ] :=
            Block[
               {
                  System`Convert`XMLDump`$exposePatt = System`Convert`XMLDump`exposePatt,
                  System`Convert`XMLDump`$attributeNameSpaceConformance =
                     UnsameQ[
                        "ElementNameSpace",
                        "AttributesDefaultNameSpace" /. {System`Convert`XMLDump`options} /. Options[XML`ToVerboseXML]
                     ]
               },
               System`Convert`XMLDump`toVerboseXMLAux[System`Convert`XMLDump`data, ""]
            ];
         Protect[wasProtected];
         Null
      )
   ]
];

