(* :Title: RealTime3D *)

(* :Author: Don Neufeld *)

(* :Summary:
This package changes the default $DisplayFunction to support the
experimental interactive 3D graphics in Version 4.
*)
	
(* :Context: Graphics`RealTime3D` *)

(* :Copyright: Copyright 1999-2000, Wolfram Research, Inc.*)

(* :Package Version: 1.2.5 *)

(* :History:
	V1.0 by Don Neufeld, April 1998.
	V1.1 modified by John M. Novak, April 1998.
	V1.2 by John M. Novak, April 1998 -- added a cache for $DisplayFunction.
	   so that it may be reset to original value (by Default3D.m), added
	   check for a Windows notebook front end when package loads.
    V1.2.1 by John M. Novak, September 1998 -- allow Macintosh without
       issuing warning message.
    V1.2.2 by Don Neufeld, January 1999 -- add BoxRatios to allowed options
       now that the Front End supports it.
    V1.2.3 by John M. Novak, February 1999 -- force numericalization of
       input, since FE doesn't understand rationals, etc.
    V1.2.4 by John M. Novak, February 1999 -- modify to allow two-arg
       SurfaceGraphics object, modularize a key bit to help this along
    V1.2.5 by John M. Novak, January 2000 -- remove platform limitation
*)

(* :Keywords: RealTime, RealTime3D,interactive, Graphics, 3D *)

(* :Sources: *)

(* :Mathematica Version: 4.0 *)

(* :Limitation:
Only works in front ends where the Geometry celltype is supported
*)

BeginPackage["RealTime3D`", "Utilities`FilterOptions`"]

RealTimeGraphicsDisplayFunction::usage =
"RealTimeGraphicsDisplayFunction is display function which allows
Graphics3D and SurfaceGraphics objects to be rotated interactively in
the front end.";

Begin["`Private`"]

SupportedGraphicsOptions=
   {Boxed, Lighting, Mesh,
    SphericalRegion, ViewPoint, BoxRatios};

(* Note that input is numericalized via N, since the FE won't understand
   exact non-integer input. Hopefully the rendering engine can be modified
   in the future so that numericalization can occur after a scaling, to
   allow easier plotting of small values... *)
RealTimeGraphicsDisplayFunction[
        (h:(Graphics3D | SurfaceGraphics))[gr_, opts___?OptionQ], rtopts___] :=
   (printgraphic[
        h[gr, FilterOptions[SupportedGraphicsOptions, opts, rtopts]]
    ];h[gr, opts])/;Head[$FrontEnd] === FrontEndObject

(* rule to handle special case of SurfaceGraphics with second matrix *)
RealTimeGraphicsDisplayFunction[
        g:SurfaceGraphics[gr_, m_, opts___?OptionQ], rtopts___] :=
   (printgraphic[
        SurfaceGraphics[gr, m,
            FilterOptions[SupportedGraphicsOptions, opts, rtopts]]
    ];g)/;Head[$FrontEnd] === FrontEndObject

printgraphic[gr_] :=
   CellPrint[Cell[BoxData[N[gr]], "Graphics"]]

RealTimeGraphicsDisplayFunction[anygr_] := Display[$Display, anygr]

End[]

EndPackage[]

(* set $DisplayFunction -- first cache current value (if value hasn't already
   been cached) *)
If[!ValueQ[System`Private`$OriginalDisplayFunction],
    System`Private`$OriginalDisplayFunction = $DisplayFunction
];
$DisplayFunction = RealTimeGraphicsDisplayFunction;

(* $Display, $SoundDisplay, $SoundDisplayFunction, $AnimationFunction,
   and $RasterFunction are left unchanged by this mode *)

Null
