
Begin["System`"]

If[!ValueQ[$XPostScriptInterpreter], $XPostScriptInterpreter := "motifps"]

$DisplayTitle := StringForm["Mathematica Graphics:  Out[`1`]", $Line]
$SoundDisplayTitle := StringForm["Mathematica Sound:  Out[`1`]", $Line]
$AnimationDisplayTitle := StringForm["Mathematica Animation:  Out[`1`]", $Line]

Begin["`Private`"]

$XPostScriptLink := (
  $XPostScriptLink =
    LinkOpen[
     StringJoin[$XPostScriptInterpreter, " -mathlink -linkmode ParentConnect"],
     LinkMode->Launch];
  LinkConnect[$XPostScriptLink]
)

$DisplayLinkCommands[file_, title_] := 
   (If[NumberQ[$DisplayWidth], 
      LinkWrite[$XPostScriptLink, TextPacket["DisplayWidth"]];
      LinkWrite[$XPostScriptLink, TextPacket[ToString[$DisplayWidth]]];
    ];
    If[NumberQ[$DisplayHeight],
      LinkWrite[$XPostScriptLink, TextPacket["DisplayHeight"]];
      LinkWrite[$XPostScriptLink, TextPacket[ToString[$DisplayHeight]]];
    ];
    If[NumberQ[$DisplayXposition],
      LinkWrite[$XPostScriptLink, TextPacket["DisplayXposition"]];
      LinkWrite[$XPostScriptLink, TextPacket[ToString[$DisplayXposition]]];
    ];
    If[NumberQ[$DisplayYposition],
      LinkWrite[$XPostScriptLink, TextPacket["DisplayYposition"]];
      LinkWrite[$XPostScriptLink, TextPacket[ToString[$DisplayYposition]]];
    ];
    LinkWrite[$XPostScriptLink, TextPacket["DisplayTitle"]];
        LinkWrite[$XPostScriptLink, TextPacket[ToString[title]]];
    LinkWrite[$XPostScriptLink, TextPacket["RemoveFile"]];
        LinkWrite[$XPostScriptLink, TextPacket["True"]];
    LinkWrite[$XPostScriptLink, TextPacket["FileName"]];
        LinkWrite[$XPostScriptLink, TextPacket[ToString[file]]];)

Unprotect[ $DisplayFunction]

Clear[ $DisplayFunction]

$Display = {}

$DisplayFunction =
 	Module[{file = OpenTemporary[]},
		Display[ {$Display, file}, #] ;
		file = Close[file] ;
                $DisplayLinkCommands[file, $DisplayTitle];
		#]&
 
Unprotect[ $SoundDisplayFunction]

Clear[ $SoundDisplayFunction]

$SoundDisplay = {}

$SoundDisplayFunction =
 	Module[{file = OpenTemporary[]},
		Display[ {$SoundDisplay, file}, #] ;
		file = Close[file] ;
                $DisplayLinkCommands[file, $SoundDisplayTitle];
		#]&

End[]

(* Animation: all frames in one file, then animate *)

`$RasterFunction = Identity;
`$AnimationFunction = $MotifAnimationFunction;

Begin[ "`Private`"]

$MotifAnimationFunction =
 	Module[{file = OpenTemporary[]},
		System`DisplayAnimation[file, #] ;
		file = Close[file] ;
                $DisplayLinkCommands[file, $AnimationDisplayTitle];
		#]&

End[]

End[]
