$BatchInput::bitf = "Cannot set `1` to `2`; value must be True or False."
$BoxForms::formset = "Cannot set `1` to `2`; value must be a list which includes TraditionalForm and StandardForm."
$Cache::set = "Cannot set `1` to `2`; value must be True or False."
$CharacterEncoding::charcode = Import::charcode = ImportString::charcode = Export::charcode = ExportString::charcode = "`1` is not a valid character encoding. A valid encoding can be the name of an encoding file or an empty list."
$CharacterEncoding::charfile = "The file `1` contains an invalid character encoding. A valid encoding is {\"type\", {{n1, \"c1\"}, ...}}."
$CharacterEncoding::sjis = "The byte sequence {`1`, `2`} could not be interpreted as a character in the ShiftJIS character encoding."
$CharacterEncoding::utf8 = "The byte sequence `1` could not be interpreted as a character in the UTF-8 character encoding."
$ContextPath::cxlist = $Packages::cxlist = "Cannot set `1` to `2`; value must be a list of strings ending in `3`."
Experimental`$EqualTolerance::tolset = Experimental`$SameQTolerance::tolset = "Cannot set `1` to `2`; value must be a real number or +/- Infinity."
$HistoryLength::limset = "Cannot set $HistoryLength to `1`; value must be Infinity or a non-negative machine-size integer."
$IterationLimit::itlim = "Iteration limit of `1` exceeded."
$IterationLimit::aitlim = "Iteration limit of `1` exceeded during evaluation with assumptions."
$IterationLimit::limset = $RecursionLimit::limset = "Cannot set `1` to `2`; value must be Infinity or an integer at least `3`."
$Language::noset = "The license configuration for the Kernel does not allow $Language to be changed to `1`. All messages will be displayed in English."
$Language::notstr = "`1` is not a string. Only strings can be set as the value of $Language."
$MaxComputationSteps::complim="The number of computation steps has been exceeded `1`."
$MaxExtraPrecision::meprecset = "Cannot set $MaxExtraPrecision to `1`; value must be a positive number or Infinity."
$MaxPrecision::prec = "In increasing internal precision while attempting to evaluate `1`, the limit $MaxPrecision = `2` was reached. Increasing the value of $MaxPrecision may help resolve the uncertainty."
$MaxPrecision::precset = "Cannot set `1` to `2`; value must be a positive number or Infinity."
$MaxPiecewiseCases::npi = "The new value `1` of $MaxPiecewiseCases is not a positive integer or Infinity."
$MaxRootDegree::npi = "The new value `1` of $MaxRootDegree is not a positive machine-size integer."
$MinPrecision::preccon = $MaxPrecision::preccon = "Cannot set `1` such that $MaxPrecision < $MinPrecision."
$MinPrecision::preclck = $MaxPrecision::preclck = "`1` is currently under the control of internal routines. You cannot change it at this time."
$MinPrecision::precset = "Cannot set `1` to `2`; value must be a real number or +/- Infinity."
$ModuleNumber::modnc = "Newly created symbol names may conflict with existing ones."
$ModuleNumber::set = "Cannot set `1` to `2`; value must be a positive integer."
NumericalMath`$NumberBits::realx = "`1` is not an inexact real number."
$ParentLink::lnset = "Cannot set $ParentLink to `1`; value is not a LinkObject."
$ParentLink::notfe = "`1` has refused the responsibility of $ParentLink."
$PreRead::prstr = "$PreRead[\"`1`\"] results in `2`, which is not a string."
$RandomState::rndst = "`1` is not a valid random state."
$RecursionLimit::areclim = "Recursion depth of `1` exceeded during evaluation with assumptions."
$RecursionLimit::reclim = "Recursion depth of `1` exceeded."
$SyntaxHandler::sntxh = "$SyntaxHandler returned `1`, which is not a string or $Failed."
AccountingForm::expint = EngineeringForm::expint = NumberForm::expint = PaddedForm::expint = ScientificForm::expint = "Result `1` obtained by applying the value of the ExponentFunction option to `2` should be an integer or Null."
AccountingForm::iprf = EngineeringForm::iprf = NumberForm::iprf = PaddedForm::iprf = ScientificForm::iprf = "Formatting specification `1` should be a positive integer or a pair of positive integers."
Accuracy::mnprec = Precision::mnprec = "Value `1` would be inconsistent with $MinPrecision; bounding by $MinPrecision instead."
Accuracy::mxprec = Precision::mxprec = "Value `1` would be inconsistent with $MaxPrecision; bounding by $MaxPrecision instead."
NumberTheory`AlgebraicNumberFields`Algebraic::cfls = "`1` is not a list of rational numbers." 
AlgebraicRules::algdat = "`1` is not a valid AlgebraicRules object obtained from AlgebraicRules."
AlgebraicRules::newv = "`1` involves variables not among `2`."
Alias::almark = "Source string `1` contains context mark."
ArrayPlot::maxpt = "Value of option MaxPlotPoints->`1` must be a positive real number, Infinity, or a list containing positive real numbers or Infinity.";
ArrayPlot::dr = "Value of option DataRange->`1` must be of the form {xrange, yrange}, with xrange and yrange either All or of the form {xmin, xmax} with xmin <= xmax.";
ArrayPlot::crule = "Value of option ColorRules->`1` is not a valid list of color rules.";
ArrayPlot::mesh = "Value of option Mesh->`1` is not All, None, n, or a valid list of mesh specifications; using All instead.";
ArrayPlot::imgsz = "Value of option ImageSize->`1` is not Automatic or a valid image size specification.";
AspectRatio::aspr = "Value of option AspectRatio -> `1` is not a finite positive number or Automatic."
Attributes::attnf = "`1` is not a known attribute."
Attributes::attsl = "`1` is not a symbol, string, or list of symbols and strings."
Attributes::locked = ClearAll::locked = Protect::locked = SetOptions::locked = "Symbol `1` is locked."
Axes::axes = "`1` is not a valid axis specification."
AxesEdge::axedg = "`1` is not a valid axis edge specification."
BaseForm::basf = "Requested base `1` should be between 2 and `2`."
Experimental`BinaryExport::chtype = "First argument `1` is not a valid channel type."
Experimental`BinaryExport::coerce = "Coercing `1` to `2` zero."
Experimental`BinaryExport::format = "`1` is not a recognized BinaryExport format."
Experimental`BinaryExport::ignore = "Ignoring `1` because it does not match the `2` format."
Experimental`BinaryExport::nomatch = "Expression `1` does not match the format `2`."
Experimental`BinaryExportString::format = "`1` is not a recognized BinaryExportString format."
Experimental`BinaryImport::chtype = "First argument `1` is not a valid channel type."
Experimental`BinaryImport::format = "`1` is not a recognized BinaryImport format."
Experimental`BinaryImport::nffil = "File not found during `1`."
Experimental`BinaryImportString::format = "`1` is not a recognized BinaryImportString format."
BinaryRead::format = BinaryReadList::format = BinaryWrite::format = "`1` is not a recognized binary format."
BinaryRead::bfmt = BinaryReadList::bfmt = BinaryWrite::bfmt = "The stream `1` is open with BinaryFormat->False, which does not support binary operations on Windows."
BinaryWrite::nocoerce = "`1` cannot be coerced to the specified format."
BinaryWrite::memavail = "Could not allocate memory for BinaryWrite."
BinaryWrite::errfile = "There was an error accessing the file. `1`."
Block::lockt = Dialog::lockt = "Cannot localize locked symbol `1` in assignment `3` from local variable specification `2`."
Block::lockv = Dialog::lockv = "Cannot localize locked symbol `1` in local variable specification `2`."
Block::lvlist = Dialog::lvlist = Module::lvlist = With::lvlist = "Local variable specification `1` is not a List."
Block::lvset = Dialog::lvset = With::lvset = Module::lvset = "Local variable specification `1` contains `2` which is an assignment to `3`; only assignments to symbols are allowed."
Block::lvsym = Dialog::lvsym = Module::lvsym = "Local variable specification `1` contains `2` which is not a symbol or an assignment to a symbol."
Break::nofunc = "Function `1` not found enclosing `2`."
Break::nofwd = "No enclosing For, While, or Do found for `1`."
CellularAutomaton::rspec = "Neighbor specification (r, {r1, r2, ...}, or {off1, off2, ...}) expected at position 3 in the rule specification `1`."
CellularAutomaton::wtspec = "Weights specification (1 or {wt1, wt2, ...}) expected at position 2 of the color specification `1` in the rule specification `2`."
CellularAutomaton::kspec = "Positive integer greater than 1 expected for the color specification at position 1 of `1` in the rule specification `2`."
CellularAutomaton::nocol = "Color specification ({}) expected at position 2 in the rule specification `1`."
CellularAutomaton::gkspec = "Color specification (k, {k, 1}, or {k, {wt1, wt2, ...}}) expected at position 2 in the rule specification `1`."
CellularAutomaton::rnum = "List of length between 1 and 3 expected for the rule specification `1`."
CellularAutomaton::rsize = "The specified rule number `1` is greater than the largest possible rule number (`2`)."
CellularAutomaton::nspec = "Rule number specification (n or {n1, n2, ...} [0 <= ni < `1`]) expected at position 1 in the rule specification `2`."
CellularAutomaton::wtlen = "The number of weights specified (`1`) does not match the number of kernel elements (`2`)."
CellularAutomaton::initg = "Initial condition specification (aspec or {aspec, bspec}) expected for `1`."
CellularAutomaton::bgrnd = "Tensor of rank `1` with elements 0 <= e < `2` expected at position 2 of the initial condition specification `3`."
CellularAutomaton::stateg = "State specification (aspec or {{aspec1, off1}, {aspec2, off2}, ...}) expected at position 1 of the initial condition specification `1`."
CellularAutomaton::state = "Tensor of rank `1` with elements 0 <= e < `2` expected for the state in element `3` of the state block specification `4`."
CellularAutomaton::offg= "Offset specification ({offt, offx1, offx2, ...}) expected for `1`."
CellularAutomaton::ovflw = "The specified automaton rule is too large to be computed."
CellularAutomaton::steps = "Positive integer expected for the number of steps `1`."
CellularAutomaton::stoff = "Offset specification ({n1, n2, ...}) of length `1` expected in element `2` of the state block specification `3`."
CellularAutomaton::offtsqs = "Sequence specification (+n, -n, {+n}, {-n}, {m, n}, or {m, n, s}) expected for the temporal offset specification `1`."
CellularAutomaton::ttake = "Cannot take steps `1` through `2`."
CellularAutomaton::offxsqs = "Sequence specification (+n, -n, {+n}, {-n}, {m, n}, or {m, n, s}) expected for the spatial offset specification `1`."
CellularAutomaton::xtake = "Cannot take elements `1` through `2`."
CharacterRange::argtype = "Arguments `1` and `2` of `3` are not both strings of length 1."
Chop::tolnn = Rationalize::tolnn = "Tolerance specification `1` must be a non-negative number."
Circle::angle = "Starting angle is larger than ending angle in angle specification `1`."
Circle::radius = "Radius `1` is not a positive number or a pair of positive numbers."
Clear::spsym = ClearAll::spsym = "Special symbol `1` cannot be cleared."
Clear::ssym = ClearAll::ssym = Information::ssym = "`1` is not a symbol or a string."
ClearAll::clloc = "Cannot clear local variable `1`."
ClebschGordan::phy = "`1` is not physical."
ClebschGordan::tri = "`1` is not triangular."
Clip::rtwo = "The argument `1` at position `2` is expected to be a list of a lower clip bound and an upper clip bound."
Clip::vtwo = "The argument `1` at position `2` is expected to be a list of two lower and upper bound replacing values."
Close::spfile = "Cannot close special file `1`."
Coefficient::numv = Exponent::numv = "`1` takes exactly one variable."
ColorOutput::colpn = ToColor::colpn = "Result `1` obtained during color conversion by applying function `2` to color `3` contains a non-numerical argument."
ColumnForm::colmh = "Horizontal alignment specification `1` is not Left, Center, or Right."
ColumnForm::colmv = "Vertical alignment specification `1` is not Below, Center, or Above."
Compile::argset = "The assignment to `1` is illegal; it is not valid to assign a value to an argument."
Compile::iterset = "The assignment to `1` is illegal; the compiler cannot assign a value to an iterator variable."
Compile::ccon = "Non-numerical object `1` with attribute Constant cannot be compiled."
Compile::cif = "The type of the two results in `1` are incompatible because the rank of each is different. Evaluation will use the uncompiled function."
Compile::compfail = "Compilation of `1` failed because `2` was not a form suitable for the compiler."
Compile::cpapot = "Compilation of `1` can only proceed when `2` is Times, Plus or List; evaluation will use the uncompiled function."
Compile::cpbool = "`1` at position `2` of `3` should be of True | False type; evaluation will use the uncompiled function."
Compile::cpdsts = "Compile cannot determine the rank of the result of `1`; evaluation will use the uncompiled function."
Compile::cpint = "`1` at position `2` of `3` should be a machine-size integer; evaluation will use the uncompiled function."
Compile::cpintlt = "`1` at position `2` of `3` should be either a non-zero integer or a vector of non-zero integers; evaluation will use the uncompiled function."
Compile::cpintlt2 = "`1` at position `2` of `3` should be a non-zero integer, or a vector or matrix of non-zero integers; evaluation will use the uncompiled function."
Compile::cpiter = "Iterator at position `1` of `2` cannot be compiled; evaluation will use the uncompiled function."
Compile::cplist = "`1` should be a tensor of type Integer, Real, or Complex; evaluation will use the uncompiled function."
Compile::cpout = "Compile cannot work on Outer for tensors of different rank; evaluation will use the uncompiled function."
Compile::cppat = "Compile does not support patterns: `1` cannot be compiled; evaluation will use the uncompiled function."
Compile::cprank = "Compile cannot determine the rank of result tensor. The length of `1` in `2` is unknown at compiling time; evaluation will use the uncompiled function."
Compile::cpts = "The result after evaluating `1` should be a tensor. Non-tensor lists are not supported at present; evaluation will proceed with the uncompiled function."
Compile::cptype = "`2` not supported for type `1`; evaluation will use the uncompiled function."
Compile::cpw = "Cannot compile raw expression `1` of type `2`."
Compile::cret = "The type of return values in `1` are different. Evaluation will use the uncompiled function."
Compile::cret1 = "The type of Return expression `1` is incompatible with a previous Return expression."
Compile::cset = "Variable `1` of type `2` encountered in assignment of type `3`."
Compile::ctyp1 = "Number `1` in `2` is an invalid compiler variable. A symbol can be used as a valid variable."
Compile::ctyp2 = "Invalid type or rank specification in `1`."
Compile::ctyps = "Invalid subexpression type specification `1`."
Compile::exttensor = "`1` cannot be compiled and will be evaluated externally. The result is assumed to be a rank `3` tensor of type `2`."
Compile::extscalar = "`1` cannot be compiled and will be evaluated externally. The result is assumed to be of type `2`."
Compile::maxrank = "Rank specification `1` in `2` exceeds the rank limit (`3`)."
Compile::realcoerce = "Warning, compilation of `1` has coerced an exact number to an approximate real number."
Compile::cxcoerce = "Warning, compilation of `1` has coerced an exact number to an approximate complex number."
Compile::defn = "CompileValue `1` for `2` is not an expression of length 2."
Compile::part = "Part specification `1` cannot be compiled since the argument is not a tensor of sufficent rank. Evaluation will use the uncompiled function."
Compile::symdef = "The symbol `1` used in assignment `2` has not been declared as a local variable."
Compile::type = "Type specification `1` is not legal. A legal type is of the form {name, typepattern} or {name, typepattern, rank}."
Compile::initvar = "The variable `1` has not been initialized or has been initialized to Null."
Compile::nocomp="The expression `1` cannot be compiled due to the presence of `2`. Evaluation will use the uncompiled function."
CompiledFunction::ccf = "Result `1` of external evaluation does not have the correct form."
CompiledFunction::cfcode = "Invalid opcode `1`; a non-negative integer less than `2` is expected."
CompiledFunction::cfct = "Number of arguments `1` does not match the length `2` of the argument template."
CompiledFunction::cfex = "External evaluation error at instruction `1`; proceeding with uncompiled evaluation."
CompiledFunction::cfff = "Fifth argument `1` should be of the form Function[{args}, expr]."
CompiledFunction::cffv = "First operation `1` does not check for correct version number."
CompiledFunction::cfins = "Arguments in instruction number `1` do not have the correct form."
CompiledFunction::cflist = "Non-tensor object generated; proceeding with uncompiled evaluation."
CompiledFunction::cfn = "Numerical error encountered at instruction `1`; proceeding with uncompiled evaluation."
CompiledFunction::cfnlts = "Null tensor with rank > 1 encountered at instruction `1`; proceeding with uncompiled evaluation."
CompiledFunction::cfnv = "CompiledFunction object is invalid and cannot be used."
CompiledFunction::cfver = "Incorrect version number; CompiledFunction object cannot be used."
CompiledFunction::mldot = "MathLink compiler cannot interpret Dot, Det, and Inverse operations; proceeding with uncompiled evaluation."
CompiledFunction::cfsa = "Argument `1` at position `2` should be a `3`."
CompiledFunction::cfta = "Argument `1` at position `2` should be a rank `3` tensor of `4`s."
CompiledFunction::cfse = "Compiled expression `1` should be a `2`."
CompiledFunction::cfte = "Compiled expression `1` should be a rank `2` tensor of `3`s."
CompiledFunction::cfsec = "Warning: Compiled expression `1` was coerced to a `2`."
CompiledFunction::cftec = "Warning: Compiled expression `1` was coerced to a rank `2` tensor of `3`s."
CompiledFunction::orank = "The result of compiled Outer has encountered a result of lower rank than expected, due to a zero-length list; evaluation will use the uncompiled function."
ComplexExpand::exf = "Value of option TargetFunctions -> `1` does not contain any of the allowed functions `2`."
Condition::condp = "Pattern `1` appears on the right-hand side of condition `2`."
ConstrainedMax::cmnov = ConstrainedMin::cmnov = "No variables found."
ConstrainedMax::cmcons = ConstrainedMin::cmcons = "`1` is not a list of valid equalities or inequalities."
ConstrainedMax::cmfun = ConstrainedMin::cmfun = "`1` is not a linear function of `2` with real coefficients."
ConstrainedMax::cmnc = ConstrainedMin::cmnc = "Non-numerical constraint `1` encountered."
Context::cxdup = "Cannot set `1` to `2`, since a symbol already exists with name `3` and context `4`."
Context::cxname = "`1` is not a parsable context name ending in `2`."
Context::cxset = $Context::cxset = "Cannot set `1` to `2`; value is not a parsable context name ending in `3`."
Context::quote = "Warning, `1` is not a valid context. A valid context uses back quotes instead of forward quotes as in `2`."
Context::quote1 ="Warning, `1` is not a valid context. A valid context uses back quotes instead of forward quotes and ends in a back quote as in `2`."
ContextToFileName::cxfil = "ContextToFileName[`1`] evaluated to `2`; a string is expected; using `3`."
Continue::nofunc = "Function `1` not found enclosing `2`."
Continue::nofwd = "No enclosing For, While, or Do found for `1`."
ContinuedFraction::incomp = "Warning: ContinuedFraction terminated before `` terms."
ContinuedFraction::noterms = "`` does not have a terminating or periodic continued fraction expansion; specify an explicit number of terms to generate."
ContinuedFraction::start = "Warning: ContinuedFraction was unable to obtain at least one term using precision `1`.`2`"
ContinuedFraction::terms = "Warning: ContinuedFraction only obtained `1` of `2` requested terms using precision `3`.`4`"
ContourGraphics::ctpnt = "The contour is attempting to traverse a cell in which some of the points have not evaluated to numbers, and it will be dropped."
ContourGraphics::ctsm = "It is not possible to shade a ContourGraphics object if some of the mesh points do not evaluate to numbers."
ContourGraphics::gmat = DensityGraphics::gmat = SurfaceGraphics::gmat = "`1` is not a rectangular array larger than 2 x 2."
ContourGraphics::meshr = DensityGraphics::meshr = SurfaceGraphics::meshr = "Value of option MeshRange -> `1` is not of the form {{xmin, xmax}, {ymin, ymax}}."
ContourPlot::pllim = DensityPlot::pllim = ParametricPlot::pllim = Plot3D::pllim = Plot::pllim = ParametricPlot3D::pllim = Play::pllim = "Range specification `1` is not of the form {x, xmin, xmax}."
ContourPlot::plnr = DensityPlot::plnr = Plot::plnr = "`1` is not a machine-size real number at `2` = `3`."
ContourPlot::pptt = DensityPlot::pptt = Plot3D::pptt = "Value of option PlotPoints -> `1` is not an integer >= 2 or a list of two such integers."
Contours::ctnl = "Value of option Contours -> `1` is not a positive integer or a list of numbers."
ContourSmoothing::ctnsm = "Value of option ContourSmoothing -> `1` is not True, Automatic, False, or None."
CopyDirectory::dirne = DeleteDirectory::dirne = RenameDirectory::dirne = "Directory `1` not empty."
CopyDirectory::filex = CopyFile::filex = RenameDirectory::filex = RenameFile::filex = "Cannot overwrite existing file `1`."
CopyDirectory::nodir = DeleteDirectory::nodir = RenameDirectory::nodir = "Directory `1` not found."
CopyFile::fdir = DeleteFile::fdir = Export::fdir = Get::fdir = RenameFile::fdir = "`1` is a directory; a file is expected."
Cross::nonn1 = "The arguments are expected to be vectors of equal length, and the number of arguments is expected to be 1 less than their length."
Experimental`CylindricalAlgebraicDecomposition::deprec = "Experimental`CylindricalAlgebraicDecomposition will not be supported in future versions of Mathematica. Use System`CylindricalDecomposition instead."
CylindricalDecomposition::nrtpi = Experimental`GenericCylindricalAlgebraicDecomposition::nrtpi = "`1` is not a logical formula consisting of polynomial equations and inequalities in `2` with rational number coefficients."
D::dvar = "Multiple derivative specifier `1` does not have the form {variable, n} where n is a nonnegative machine integer."
Difference::dvar = "Difference specifier `1` does not have the form {variable, n} or {variable, n, h} where n is a nonnegative machine integer."
Dashing::dshn = AbsoluteDashing::dshn = "Argument in `1` is not a list of numbers."
Debug::dbug = "To inspect an expression, just evaluate it normally."
DeclarePackage::aldec = "Symbol `1` in `2` has already been declared."
DefaultFont::dfont = "$DefaultFont specification `1` is not of the form {\"name\", size}."
DefaultFont::font = "Value of option DefaultFont -> `1` cannot be used as a font; using global $DefaultFont instead."
DefineExternal::des = "A definition for external function `1` of `2` was not created because of a syntax error. The external function may still be called with ExternalCall[`2`, CallPacket[`1`, {args}]]."
Derivative::novar = "`1` cannot be interpreted. A partial derivative requires a subscript differentiation variable."
DiagonalMatrix::vec = "Input `1` to DiagonalMatrix is not a list of scalars."
Dialog::dpa = "Abort while evaluating DialogProlog `1` caught in dialog."
Dialog::exd = "To exit a dialog, use Return[] or Return[expr]. To exit the entire Mathematica session, type Exit[]."
DigitCount::base = "The base `1` at position 2 of `2` should be an integer greater than 1."
DigitCount::digp = "Positive integer or list of nonnegative integers less than the base `1` expected at position 3 in `2`."
Directory::dirx = "`1`"
Disk::angle = "Starting angle is larger than ending angle in angle specification `1`."
Disk::radius = "Radius `1` is not a positive number or a pair of positive numbers."
Display::badargs = "`1`"
Display::dispgif = "Too many arguments for GIF conversion."
Display::dopen = "There is an error opening the output file \"`1`\"."
Display::dwrite = "There is an error writing to the output file \"`1`\"."
Display::fname = "Filename `1` is not a string."
Display::gfile = "`1` is not a valid filename."
Display::image = Export::image = ExportString::image = "Value of option `1` -> `2` is not a list of two numbers or Automatic."
Display::noform = "`1` is not a recognized Display format. The available formats include `2`."
Display::nolink = "Link to display device could not be opened."
Display::pserr = "`1`"
Display::type = "`1` is not a graphics, notebook, cell, or box expression."
Dot::dotsh = "Tensors `1` and `2` have incompatible shapes."
Dot::dotpat = "Cannot combine array of pattern type with an ordinary array."
DownValues::itloc = UpValues::itloc = OwnValues::itloc = FormatValues::itloc = DefaultValues::itloc = NValues::itloc = Messages::itloc = SubValues::itloc = "`1` currently contains iterator localizations, and cannot be set (to `2`)."
DownValues::vlist = UpValues::vlist = OwnValues::vlist = FormatValues::vlist = DefaultValues::vlist = NValues::vlist = Messages::vlist = SubValues::vlist = "Cannot set `1` to `2`; value must be a list of rules."
DownValues::vrule = UpValues::vrule = OwnValues::vrule = FormatValues::vrule = DefaultValues::vrule = NValues::vrule = Messages::vrule = SubValues::vrule = "Cannot set `1` to `2`; value contains `3`, which is not a rule."
Drop::drop = "Cannot drop positions `1` through `2` in `3`."
DSolve::dsfun = NDSolve::dsfun = RSolve::dsfun = "`1` cannot be used as a function."
DSolve::dsvar = NDSolve::dsvar = RSolve::dsvar = "`1` cannot be used as a variable."
DSolve::deqx = NDSolve::deqx = "Supplied equations are not differential equations of the given functions."
RSolve::deqx = "Supplied equations are not difference equations of the given functions."
DSolve::dsmsm = RSolve::dsmsm = "Built-in routines cannot solve this problem. There is an equation that involves none of the dependent variables, or there is a dependent variable that does not appear in any equation."
DSolve::underdet = RSolve::underdet = NRSolve::underdet = "The system has more dependent variables than equations, so is underdetermined."
NDSolve::underdet = "There are more dependent variables, `1`, than equations, so the system is underdetermined."
DSolve::overdet = RSolve::overdet = NRSolve::overdet = "The system has fewer dependent variables than equations, so is overdetermined."
NDSolve::overdet = "There are fewer dependent variables, `1`, than equations, so the system is underdetermined."
DSolve::deqn = NDSolve::deqn = RSolve::deqn = NRSolve::deqn = "Equation or list of equations expected instead of `1` in the first argument `2`."
DSolve::ivar2 = NDSolve::ivar2 = RSolve::ivar2 = NRSolve::ivar2 = "The independent variable `1` should not appear in two different arguments of the dependent variable `2`."
DSolve::pde = "Partial differential equation may not have a general solution. Try loading Calculus`DSolveIntegrals` to find special solutions."
DSolve::twoivarg = NDSolve::twoivarg = RSolve::twoivarg = "The function `1` has two independent variables in one argument. The independent variables should be in separate arguments."
DSolve::alliv = NDSolve::alliv = RSolve::alliv = "The function `1` was specified without dependence on all of the independent variables. Each function must depend on all of the independent variables."
DSolve::baddv = NDSolve::baddv = RSolve::baddv = NRSolve::baddv = "The dependent variable `1` is not clearly specified in the form `2`."
DSolve::ndord = NDSolve::ndord = NDSolve`Reinitialize::ndord = "Derivative order `1` in term `2` should be a non-negative machine-sized integer."
RSolve::rord = "Recurrence order `1` of equation `2` is not a machine sized integer."
RSolve::piarg = "All arguments in position `1` of `2` should be either of the form `3` + Integer or q^Integer * `3`. Mixtures of these forms are not allowed."
DSolve::pdord = "The differential order of functions `1` is 0. All the functions must have positive differential order."
RSolve::pdord = "The recurrence order of functions `1` is 0. All the functions must have positive recurrence order."
NDSolve::pdord = "Some of the functions have zero differential order so the equations will be solved as a system of differential-algebraic equations."
DSolve::litarg = NDSolve::litarg = RSolve::litarg = "To avoid possible ambiguity, the arguments of the dependent variable in `1` should literally match the independent variables."
DSolve::bvimp = RSolve::bvimp = "General solution contains implicit solutions. In the boundary value problem these solutions will be ignored, so some of the solutions will be lost."
DSolve::bvlim = RSolve::bvlim = "For some branches of the general solution, unable to compute the limit at the given points. Some of the solutions may be lost."
DSolve::bvfail = RSolve::bvfail = "For some branches of the general solution, unable to solve the conditions."
DSolve::bvnul = RSolve::bvnul = "For some branches of the general solution, the given boundary conditions lead to an empty solution."
DSolve::bvnr = RSolve::bvnr = "For some branches of the general solution, the given boundary conditions does not restrict the existing freedom in the general solution."
DSolve::nolist = "List encountered within `1`. There should be no lists on either side of the equations."
DSolve::nlpde = "Solution requested to nonlinear partial differential equation. Trying to build a complete integral."
DumpGet::bgbf = "File `1` cannot be loaded, it is corrupted or is written on a different machine."
DumpGet::bgnew = "File `1` has been written by a newer version of DumpSave and cannot be loaded."
DumpGet::bgold = "Warning: file `1` has been written by an older version of DumpSave."
DumpGet::bgchk = "Checksum in binary file `1` does not agree."
DumpGet::bgcor = "Binary file `1` is corrupted."
DumpGet::valwarn = "Symbol `1` already has definition for `2`."
DumpSave::bschk = "Error in writing output file."
DumpSave::bsnosym = "`1` is not defined as a symbol or a context."
DumpSave::bsstm = "DumpSave will not write out stream information `1`."
DumpSave::outref = "Symbol `1` references an external object such as a file which will not be saved in the output."
EditDefinition::edsym = "`1` is not a symbol."
SparseArray`SVDArnoldi::svdwop = SingularValueList::svdwop = SingularValueDecomposition::svdwop = "The option `1` with value `2` is not accepted by `3`."
SparseArray`SVDArnoldi::noimp = SingularValueList::noimp = SingularValueDecomposition::noimp = "The generalize `1` for sparse matrices is not implemented yet."
SparseArray`SVDArnoldi::emeth = SparseArray`Arnoldi::emeth = SingularValueList::emeth = SingularValueDecomposition::emeth = Eigenvalues::emeth = Eigenvectors::emeth = Eigensystem::emeth = "The method specified by Method->`1` should be either Automatic or Arnoldi."
SingularValueList::take = "Cannot take singular values `1` through `2` out of the total of `3` singular values."
SingularValueDecomposition::take = "Cannot take singular values and singular vectors `1` through `2` out of the total of `3` singular values and singular vectors."
Eigenvalues::take = "Cannot take eigenvalues `1` through `2` out of the total of `3` eigenvalues."
Eigenvectors::take = "Cannot take eigenvectors `1` through `2` out of the total of `3` eigenvectors."
SparseArray`Arnoldi::take = Eigensystem::take = "Cannot take eigenvectors and eigenvalues `1` through `2` out of the total of `3` eigenvectors and eigenvalues."
SparseArray`SVDArnoldi::take = "Cannot take singular vectors and singular values `1` through `2` out of the total of `3` singular vectors and singular values."
SparseArray`Arnoldi::ars = Eigenvalues::ars = Eigenvectors::ars = Eigensystem::ars = "Method->Arnoldi is typically only effective to find a few eigenvalues and/or eigenvectors.  Finding the requested `1` out of the `2` eigenvalues and eigenvectors may to be faster with dense matrix methods."
SparseArray`SVDArnoldi::ars = SingularValueList::ars = SingularValueDecomposition::ars = "Method->Arnoldi is typically only effective to find a few singular values and/or singular vectors.  Finding the requested `1` out of the `2` singular values and singular vectors may to be faster with dense matrix methods."
SparseArray`Arnoldi::arall = Eigenvalues::arall = Eigenvectors::arall = Eigensystem::arall = "Method->Arnoldi cannot be used to compute more than `1` out of the `2` eigenvalues and/or eigenvectors."
SparseArray`SVDArnoldi::arall = SingularValueDecomposition::arall = SingularValueList::arall =  "Method->Arnoldi cannot be used to compute more than `1` out of the `2` singular values and/or singular vectors."
SparseArray`SVDArnoldi::arfac = SparseArray`Arnoldi::arfac = SingularValueDecomposition::arfac = SingularValueList::arfac = Eigenvalues::arfac = Eigenvectors::arfac = Eigensystem::arfac = "Arnoldi algorithm failed because it could not build an Arnoldi factorization."
SparseArray`Arnoldi::arh = Eigenvalues::arh = Eigenvectors::arh = Eigensystem::arh = "Because finding `1` out of the `2` eigenvalues and/or eigenvectors is likely to be faster with dense matrix methods, the sparse input matrix will be converted.  If fewer eigenvalues and/or eigenvectors would be sufficient, consider restricting this number using the second argument to `3`."
SparseArray`SVDArnoldi::arh = SingularValueDecomposition::arh = SingularValueList::arh = "Because finding `1` out of the `2` singular values and/or singular vectors is likely to be faster with dense matrix methods, the sparse input matrix will be converted.  If fewer singular values and/or singular vectors would be sufficient, consider restricting this number using the second argument to `3`."
SparseArray`Arnoldi::arhm = Eigenvalues::arhm = Eigenvectors::arhm = Eigensystem::arhm = "Because finding `1` out of the `2` eigenvalues and/or eigenvectors is likely to be faster with dense matrix methods, the sparse input matrix will be converted.  If fewer eigenvalues and/or eigenvectors at machine precision would be sufficient, consider using N on the matrix and restricting this number using the second argument to `3`."
SparseArray`SVDArnoldi::arhm = SingularValueDecomposition::arhm = SingularValueList::arhm = "Because finding `1` out of the `2` singular values and/or singular vectors is likely to be faster with dense matrix methods, the sparse input matrix will be converted.  If fewer singular values and/or singular vectors at machine precision would be sufficient, consider using N on the matrix and restricting this number using the second argument to `3`."
SparseArray`SVDArnoldi::armw = SparseArray`Arnoldi::armw = SingularValueDecomposition::armw = SingularValueList::armw = Eigenvalues::armw = Eigenvectors::armw = Eigensystem::armw = "The iterative Arnoldi method can only be used for matrices of machine numbers.  `1` will use dense matrix methods instead."
SparseArray`SVDArnoldi::arm = SparseArray`Arnoldi::arm = SingularValueDecomposition::arm = SingularValueList::arm = Eigenvalues::arm = Eigenvectors::arm = Eigensystem::arm = "Method->Arnoldi can only be used for matrices of machine numbers."
SparseArray`SVDArnoldi::armc = SparseArray`Arnoldi::armc = SingularValueDecomposition::armc = SingularValueList::armc = Eigenvalues::armc = Eigenvectors::armc = Eigensystem::armc = "The Arnoldi method has encountered an intermediate value which is not a machine number."
SparseArray`Arnoldi::argpd = Eigenvalues::argpd = Eigenvectors::argpd = Eigensystem::argpd = "The input matrices are sufficiently sparse that it is likely that the Arnoldi method would be faster for computing the requested eigenvalues and eigenvectors.  However, the algorithm requires that the second matrix be positive definite, so dense methods will be used.  If you know that the second matrix is positive definite, it is recommended that you choose Method->Arnoldi in `1`."
SparseArray`SVDArnoldi::argpd = SingularValueDecomposition::argpd = SingularValueList::argpd = "The input matrices are sufficiently sparse that it is likely that the Arnoldi method would be faster for computing the requested singular values and singular vectors.  However, the algorithm requires that the second matrix be positive definite, so dense methods will be used.  If you know that the second matrix is positive definite, it is recommended that you choose Method->Arnoldi in `1`."
SparseArray`Arnoldi::arconv = Eigenvalues::arconv = Eigenvectors::arconv = Eigensystem::arconv = "Could not find any eigenvalues to sufficient accuracy."
SparseArray`SVDArnoldi::arconv = SingularValueDecomposition::arconv = SingularValueList::arconv = "Could not find any singular values to sufficient accuracy."
SparseArray`SVDArnoldi::aribs = SparseArray`Arnoldi::aribs = SingularValueDecomposition::aribs = SingularValueList::aribs = Eigenvalues::aribs = Eigenvectors::aribs = Eigensystem::aribs = "No shifts could be applied during a cycle of the implicitly restarted Arnoldi iteration. Increasing the basis size with the method options Method->{Arnoldi, BasisSize->n}, where n is an integer no greater than the dimension of the matrix, may help."
SparseArray`SVDArnoldi::maxit = SparseArray`Arnoldi::maxit = SingularValueDecomposition::maxit = SingularValueList::maxit = Eigenvalues::maxit = Eigenvectors::maxit = Eigensystem::maxit = "Maximum number of iterations, `1`, has been reached by the Arnoldi algorithm without convergence to the specified tolerance.  You can use method options with Method->{Arnoldi, opts) to increase the basis size or the maximum number of iterations, reduce the tolerance, or choose an appropriate shift, any of which may help."
SparseArray`SVDArnoldi::maxit2 = SparseArray`Arnoldi::maxit2 = SingularValueDecomposition::maxit2 = SingularValueList::maxit2 = Eigenvalues::maxit2 = Eigenvectors::maxit2 = Eigensystem::maxit2 = "Maximum number of iterations, `1`, has been reached by the Arnoldi algorithm without convergence to the specified tolerance, but the current best computed value has been returned.  You can use method options with Method->{Arnoldi, opts} to increase the basis size or the maximum number of iterations, reduce the tolerance, or use an estimate as a shift, any of which may help."
SparseArray`SVDArnoldi::arstv = SparseArray`Arnoldi::arstv = SingularValueDecomposition::arstv = SingularValueList::arstv = Eigenvalues::arstv = Eigenvectors::arstv = Eigensystem::arstv = "The starting vector must have at least one nonzero component."
SparseArray`SVDArnoldi::arbsym = SparseArray`Arnoldi::arbsym = SingularValueDecomposition::arbsym = SingularValueList::arbsym = Eigenvalues::arbsym = Eigenvectors::arbsym = Eigensystem::arbsym = "You can only choose the Arnoldi method option Criteria->BothEnds for real symmetric matrices."
SparseArray`Arnoldi::arb2 = Eigenvalues::arb2 = Eigenvectors::arb2 = Eigensystem::arb2 = "With the Arnoldi method option Criteria->BothEnds, you need to request two or more eigenvalues and/or eigenvectors."
SparseArray`SVDArnoldi::arb2 = SingularValueDecomposition::arb2 = SingularValueList::arb2 = "With the Arnoldi method option Criteria->BothEnds, you need to request two or more singular values and/or singular vectors."
SparseArray`SVDArnoldi::arerr = SparseArray`Arnoldi::arerr = SingularValueDecomposition::arerr = SingularValueList::arerr = Eigenvalues::arerr = Eigenvectors::arerr = Eigensystem::arerr = "The Arnoldi algorithm has encountered a LAPACK error which prevents it from continuing."
SparseArray`SVDArnoldi::arbss =  SingularValueDecomposition::arbss = SingularValueList::arbss = "The values of the option BasisSize->`1` should be an integer greater than the double number of requested singular values and/or singular vectors, `2`, and at most double of smaller of the number of rows and columns of the matrix, `3`."
SparseArray`Arnoldi::arbss = Eigenvalues::arbss = Eigenvectors::arbss = Eigensystem::arbss = "The values of the option BasisSize->`1` should be an integer greater than the requested number of eigenvalues and/or eigenvectors, `2`, and at most the dimension of the matrix, `3`."
SparseArray`SVDArnoldi::arbs = SingularValueDecomposition::arbs = SingularValueList::arbs = "The values of the option BasisSize->`1` should be an integer greater than the double number of requested singular values and/or singular vectors plus one, `2`, and at most double of smaller of the number of rows and columns of the matrix, `3`."
SparseArray`Arnoldi::arbs = Eigenvalues::arbs = Eigenvectors::arbs = Eigensystem::arbs = "The values of the option BasisSize->`1` should be an integer greater than the requested number of eigenvalues and/or eigenvectors plus one, `2`, and at most the dimension of the matrix, `3`."
SparseArray`SVDArnoldi::lsgma = SingularValueDecomposition::lsgma = SingularValueList::lsgma = "The option Shift is used only for computing a few singular values close to the value of Shift - the second argument of `1` should be a positive small integer because computing other singular values may not be accurate."
SparseArray`Arnoldi::lsgma = Eigenvalues::lsgma = Eigenvectors::lsgma = Eigensystem::lsgma = "The option Shift is used only for computing a few eigenvalues close to the value of Shift - the second argument of `1` should be a positive small integer because computing other eigenvalues may not be accurate."
SparseArray`Arnoldi::bsing = Eigenvalues::bsing = Eigenvectors::bsing = Eigensystem::bsing = "The right-hand side matrix of the generalized eigenvalue problem is singular."
SparseArray`SVDArnoldi::bsing = SingularValueDecomposition::bsing = SingularValueList::bsing = "The right-hand side matrix of the generalized singular value problem is singular."
SparseArray`Arnoldi::eslct = Eigenvalues::eslct = Eigenvectors::eslct = Eigensystem::eslct = "A value of the option Criteria->`1` must be one of \"Magnitude\", \"RealPart\", \"ImaginaryPart\" or \"BothEnds\", with \"BothEnds\" appropriate for real symmetric eigenvalue problems only."
SparseArray`SVDArnoldi::eslct = SingularValueDecomposition::eslct = SingularValueList::eslct = "The value of the option Criteria->`1` can be \"Magnitude\" only."
SparseArray`SVDArnoldi::mcsgma = SparseArray`Arnoldi::mcsgma = SingularValueDecomposition::mcsgma = SingularValueList::mcsgma = Eigenvalues::mcsgma = Eigenvectors::mcsgma = Eigensystem::mcsgma = "Value of option Shift->`1` must be a machine number."
SparseArray`Arnoldi::svecnm = Eigenvalues::svecnm = Eigenvectors::svecnm = Eigensystem::svecnm = "A value of the option StartingVector->`1` must be a vector of machine numbers, of the same length as the row dimension of the matrix."
SparseArray`SVDArnoldi::svecnm = SingularValueDecomposition::svecnm = SingularValueList::svecnm = "A value of the option StartingVector->`1` must be a vector of machine numbers, of the length equal to the sum of the row and column dimensions of the matrix."
SparseArray`Arnoldi::ssing = Eigenvalues::ssing = Eigenvectors::ssing = Eigensystem::ssing = "Failed to factor the matrix involving the shift. This may be caused by the shift, `1`, corresponding exactly to an eigenvalue. Changing the shift value slightly might help."
SparseArray`SVDArnoldi::ssing = SingularValueDecomposition::ssing = SingularValueList::ssing = "Failed to factor the matrix involving the shift. This may be caused by the shift, `1`, corresponding exactly to a singular value. Changing the shift value slightly might help."
Element::bset = "The second argument `1` of Element should be one of: Primes, Integers, Rationals, Algebraics, Reals, Complexes, or Booleans."
EllipticLog::elld = "The arguments to `1` are inconsistent with the defining equation y^2 == x^3 + a x^2 + b x."
EllipticLog::ellnp = EllipticExp::ellnp = "The argument `1` is not an ordered pair; a list of length 2 is expected."
EllipticReducedHalfPeriods::nind = "Half periods `1` are not independent."
EllipticTheta::etype = EllipticThetaPrime::etype = "The first argument `1` is expected to be 1, 2, 3, or 4."
End::noctx = EndAdd::noctx = EndPackage::noctx = "No previous context defined."
Except::named = "Named pattern variables are not allowed in the first argument of `1`."
Except::lenmod = "A variable length pattern is not allowed as the second argument in `1`."
ExitDialog::cant = "No dialog to exit from."
Export::avibig = "Cannot export to AVI, because the size of the resulting data would exceed the 4 GB size limit of the AVI file format."
Export::avisize = "The rasterized size of a frame did not match the requested image size, and will be padded or cropped."
Export::bitcon = "BITPIX ConversionOption, `1`, and BITPIX in header, `2`, have conflicting values. Using header value."
Export::bitrange = "BITPIX value `1` does not cover data range. Try using `2`."
Export::bitval = "BITPIX value `1` is not a valid value."
Export::chtype = "First argument `1` is not a valid channel type."
Export::coerce = "Coercing `1` to `2` zero."
Export::covinv = Import::covinv = "The value \"`1`\" specified for the ConversionOptions option \"`2`\" is invalid."
Export::covrng = Import::covrng = "The value \"`1`\" specified for the ConversionOptions option \"`2`\" is out of range."
Export::createdir = "Export assumed `1` to be a directory into which to write an index.html file, but was unable to create this directory for you. Either create this directory and re-run HTMLSave, or choose a different destination for the HTML file."
Export::dffsr = "Cannot export a sound with multiple sample rates."
Export::errfile = Import::errfile = "There was an error accessing the file. `1`."
Export::errstruct = Import::errstruct = "Data structure error. `1`."
Export::fmterr = "Invalid `1` format."
Export::format = "`1` is not a recognized Export format."
Export::enc = "`1` is not a recognized Export Encoding."
Export::guess = "Could not guess format from channel `1`."
Export::h5error = Import::h5error = "An error occured when calling the HDF5 library function \"`1`\". (Errorcode `2`)."
Export::h5exist = "Could not append to the file because the dataset \"`1`\" already exists."
Export::h5noauto = "Could not coerce the expression into an array of integers or reals."
Export::ignore = "Ignoring `1` because it does not match the `2` format."
Export::int = "Warning: sparse array `1` to be exported in `2` format has integer entries. They will be converted to real entries."
Export::memavail = "Could not allocate memory for export of `1` format."
Export::no2dgr = "Two-dimensional graphics objects cannot be exported to `1` format. `1` format may be used for three-dimensional graphics."
Export::nocomp = "The given data cannot be exported to `1` format in compressed form. The data will be exported without compression."
Export::nodta = "`1` contains no data that can be exported to the `2` format."
Export::nodir = "Directory `1` does not exist."
Export::nofe = "A front end is not available; export of `1` requires a front end."
Rasterize::nofe = "A front end is not available; Rasterize requires a front end."
Export::nomatch = "Expression `1` does not match the format `2`."
Export::obs = Import::obs = "`1` is obsolete."
General::obsalt = "`1` is obsolete. Instead, use `2`."
Export::optv = "`1` is not a valid value for the ConversionOption \"MatrixStructure\". Acceptable values are \"Unsymmetric\", \"Symmetric\", \"SkewSymmetric\", \"Hermitian\", and \"Rectangular\". \"MatrixStructure\"->\"Unsymmetric\" is assumed."
Export::optsym = "ConversionOption \"MatrixStructure\"->\"Symmetric\" is specified, but the matrix `1` is not symmetric."
Export::optz = "ConversionOption \"MatrixStructure\"->\"SkewSymmetric\" is specified, but the matrix `1` is not skew-symmetric."
Export::optc = "ConversionOption \"MatrixStructure\"->\"Hermitian\" is specified, but the matrix `1` is not Hermitian."
Export::optcc = "Warning: ConversionOption \"MatrixStructure\"->\"Hermitian\" is specified, but the matrix `1` is not complex. Using \"MatrixStructure\"->\"Symmetric\" instead."
Export::padbits = "Padding bits with zeros to create an integer number of bytes."
Export::rank = "The sparse array `1` to be exported in `2` format is not a matrix of rank 2."
Export::type = "`1` cannot be exported to the `2` format."
Rasterize::type = "`1` cannot be rasterized."
Export::unsupfmt = Import::unsupfmt = "The `1` format is not currently supported on this platform."
Export::autofix = "There is an error in the SymbolicXML expression being exported. An automated attempt has been made to fix the error, however the fix may yield XML different to that desired.  The function XML`SymbolicXMLErrors will detail the errors in the SymbolicXML expression."
Export::badqte = "The quote character `1` is not a valid attribute quoting character. Attributes in the exported XML will be surrounded with single quotes."
Export::malsxml = "`1` is a malformed SymbolicXML expression. It may cause errors in the XML file."
Export::unrecov = "An unrecoverable error occurred while exporting the SymbolicXML."
Export::xmlmal = "Malformed SymbolicXML expression `1` encountered in export."
Export::xmlnopt = "An option was expected instead of `1` in the exporting of the SymbolicXML `2`."
Export::xmloptv = "The value of option `1` in `2` is not valid in the exporting of the SymbolicXML `3`."
Export::xmloptx = "Unknown option `1` encountered in the exporting of the SymbolicXML `2`."
ExportString::format = "`1` is not a recognized ExportString format."
ExportString::enc = "`1` is not a recognized ExportString Encoding."
ExtendedGCD::egcd = "Arguments in `1` should be integers."
ExtendedGCD::egcdz = "ExtendedGCD[0,0] has no unique solution."
LinearSolve::notrhsm = "Incorrect value of the second argument. Only the strings \"N\", \"T\", \"C\" or \"J\" are valid."
LinearSolve::rmeth = "Value of option Method -> `1` should be \"Cholesky\", \"Multifrontal\", \"Krylov\", \"CofactorExpansion\", \"OneStepRowReduction\", \"DivisionFreeRowReduction\", \"Direct\", \"IterativeRefinement\", or Automatic."
LinearSolve::mronly = "Only machine real code is available for sparse matrices. If your matrix is not too large, consider trying again after using Normal on the matrix."
LinearSolve::mconly = "Only machine number code is available for sparse matrices. If your matrix is not too large, consider trying again after using Normal on the matrix."
LinearSolve::mcovl = "The computation encountered machine number overflow.  Only machine number code is available for sparse matrices. If your matrix is not too large, consider trying again after using Normal on the matrix."
LinearSolve::nolib = "The library for the sparse method chosen is not available on this platform.  Try choosing another method."
LinearSolve::lupat = "Cannot compute solutions for Pattern type sparse matrices."
LinearSolve::sqmat = "The matrix `1` is not square.  A square matrix is needed to compute a factorization."
LinearSolve::npdef = "The matrix `1` is not positive definite."
LinearSolve::herm = "The matrix `1` is not Hermitian or real symmetric, which is necessary for Method->Cholesky."
LinearSolve::tmm = "Pre-factorization analysis indicates that the solution will require too much memory."
LinearSolve::sing1 = "The matrix `1` is singular so a factorization will not be saved."
LinearSolve::sqmat1 = "The matrix `1` is not square so a factorization will not be saved."
LinearSolve::kryme = "`1` is not a supported Krylov method."
LinearSolve::kryit = "Value of option MaxIterations -> `1` should be a positive integer or Automatic."
LinearSolve::krypre = "Value of option Preconditioner->`1` is not ILU or a user-defined function."
LinearSolve::krynor = "Value of option ResidualNormFunction->`1` is not a valid function."
LinearSolve::krynorv = "The result of applying the user-specified norm function `1` is not a valid number."
LinearSolve::krydia = "ILU preconditioner is specified, but since there are missing diagonal entries in the input matrix, no preconditioner will be used."
LinearSolve::krymit = "The maximum number of iterations, `1`, has been reached by the Krylov algorithm without convergence to the tolerance. The current best computed solution has been returned."
LinearSolve::krypr = "The result of applying the user-specified preconditioner `1` is not a list with length equal to the row dimension of the matrix."
LinearSolve::kryma = "The result of applying the user-specified matrix `1` is not a list with length equal to the row dimension of the matrix."
LinearSolve::krynom = "Non-numerical quantities were encountered during Krylov iteration. This could be because these linear equations have no solution."
LinearSolve::krynum = "Input to Krylov algorithm contains elements that are not explicit numbers"
LinearSolve::kryinfp = "Input to Krylov algorithm is of infinite precision. Iterations may become very slow due to expression size growth."
LinearSolve::lsnmod = "The option Modulus may be specified only for integer or rational matrices." 
LinearSolve::lsnzt = "The option ZeroTest may be specified only for integer or rational matrices."
LinearAlgebra`LinearSolve`IterativeRefinement::maxit = "Maximum number of iterations `1` reached without convergence."
LinearAlgebra`LinearSolve`IterativeRefinement::slwconv = "Slow convergence (less than `1` digits per iteration)."
LinearAlgebra`LinearSolve`IterativeRefinement::noconv = "No convergence."
LinearAlgebra`LinearSolve`IterativeRefinement::infprec = "Computations cannot be carried out in infinite precision."
LinearAlgebra`LinearSolve`IterativeRefinement::lcondn = "The matrix condition number `1` is too large for starting precision `2`. The method may not converge."
General::wrgopt = "The value `1` of the option `2` is incorrect."
LinearAlgebra`LinearSolve`IterativeRefinement::wrgopt1 = "The IterativeRefinement method option(s) is (are) incorrect."
LinearAlgebra`MatrixConditionNumber::nrmp = "The value `1` of the option Norm is incorrect. It should be 1 or Infinity."
Experimental`ExtendedLinearSolve::lsvs = Experimental`LinearSolveFunction::lsvs = Developer`SparseLinearSolve::lsvs = "Argument `1` is neither a non-empty vector of machine-sized numbers nor a list of same-length vectors of machine-sized numbers."
DiscreteMath`GraphPlot`GraphCoordinates::tsf = DiscreteMath`GraphPlot`GraphCoordinates3D::tsf  = DiscreteMath`GraphPlot`GraphPlot::tsf = SparseArray`GraphPlacement::tsf = DiscreteMath`GraphPlot`GraphPlot3D::tsf = SparseArray`GraphPlacement3D::tsf = "The value of option \"TreeSizeFunction\"->`1` does not evaluate to a machine-sized real number at `2`."
DiscreteMath`GraphPlot`GraphCoordinates::sqma = DiscreteMath`GraphPlot`GraphCoordinates3D::sqma  = DiscreteMath`GraphPlot`GraphPlot::sqma = SparseArray`GraphPlacement::sqma = DiscreteMath`GraphPlot`GraphPlot3D::sqma = SparseArray`GraphPlacement3D::sqma = "First argument `1` is not a square matrix."
DiscreteMath`GraphPlot`GraphCoordinates::coord = DiscreteMath`GraphPlot`GraphCoordinates3D::coord  = DiscreteMath`GraphPlot`GraphPlot::coord = SparseArray`GraphPlacement::coord = DiscreteMath`GraphPlot`GraphPlot3D::coord = SparseArray`GraphPlacement3D::coord = "The second argument of `1` must be a matrix of real machine numbers with the same row dimension as the first argument and a column dimension of 2 or 3."
DiscreteMath`GraphPlot`GraphCoordinates::coord3 = DiscreteMath`GraphPlot`GraphCoordinates3D::coord3  = DiscreteMath`GraphPlot`GraphPlot::coord3 = SparseArray`GraphPlacement::coord3 = DiscreteMath`GraphPlot`GraphPlot3D::coord3 = SparseArray`GraphPlacement3D::coord3 = "Warning: the second argument of `1` has a column dimension of 3. It will be treated as 3D instead."
DiscreteMath`GraphPlot`GraphCoordinates::coord2 = DiscreteMath`GraphPlot`GraphCoordinates3D::coord2  = DiscreteMath`GraphPlot`GraphPlot::coord2 = SparseArray`GraphPlacement::coord2 = DiscreteMath`GraphPlot`GraphPlot3D::coord2 = SparseArray`GraphPlacement3D::coord2 = "Warning: the second argument of `1` has a column dimension of 2. It will be treated as 3D instead."
DiscreteMath`GraphPlot`GraphCoordinates::vcoord = DiscreteMath`GraphPlot`GraphCoordinates3D::vcoord  = DiscreteMath`GraphPlot`GraphPlot::vcoord = SparseArray`GraphPlacement::vcoord = DiscreteMath`GraphPlot`GraphPlot3D::vcoord = SparseArray`GraphPlacement3D::vcoord = "Value of option VertexCoordinates->`1` must be a matrix of real machine numbers, with a row dimension of `2` and a column dimension of `3`."
DiscreteMath`GraphPlot`GraphCoordinates::mlv = DiscreteMath`GraphPlot`GraphCoordinates3D::mlv  = SparseArray`GraphPlacement::mlv = DiscreteMath`GraphPlot`GraphPlot3D::mlv = SparseArray`GraphPlacement3D::mlv = "The value of option RecursionMethod->`1` should be \"Multilevel\", Automatic, or None."
DiscreteMath`GraphPlot`GraphCoordinates::mlvcrs = DiscreteMath`GraphPlot`GraphCoordinates3D::mlvcrs  = SparseArray`GraphPlacement::mlvcrs = DiscreteMath`GraphPlot`GraphPlot3D::mlvcrs = SparseArray`GraphPlacement3D::mlvcrs = "The value of option CoarseningScheme->`1` should be \"MaximalIndependentVertexSet\", \"MaximalIndependentVertexSetInjection\", \"MaximalIndependentVertexSetRugeStuben\", \"MaximalIndependentVertexSetRugeStubenInjection\", \"MaximalIndependentEdgeSet\", \"MaximalIndependentEdgeSetHeavyEdge\", \"MaximalIndependentEdgeSetSmallestVertexWeight\", or \"Hybrid\"."
DiscreteMath`GraphPlot`GraphCoordinates::mlvran = DiscreteMath`GraphPlot`GraphCoordinates3D::mlvran  = SparseArray`GraphPlacement::mlvran = DiscreteMath`GraphPlot`GraphPlot3D::mlvran = SparseArray`GraphPlacement3D::mlvran = "The value of option Randomize->`1` should be Automatic, True, or False."
DiscreteMath`GraphPlot`GraphCoordinates::mlvmsz = DiscreteMath`GraphPlot`GraphCoordinates3D::mlvmsz  = SparseArray`GraphPlacement::mlvmsz = DiscreteMath`GraphPlot`GraphPlot3D::mlvmsz = SparseArray`GraphPlacement3D::mlvmsz = "The value of option MinSize->`1` should be Automatic or a positive machine integer."
DiscreteMath`GraphPlot`GraphCoordinates::step = DiscreteMath`GraphPlot`GraphCoordinates3D::step  = SparseArray`GraphPlacement::step = DiscreteMath`GraphPlot`GraphPlot3D::step = SparseArray`GraphPlacement3D::step = "The value of option Steplength->`1` should be Automatic or a positive machine real."
DiscreteMath`GraphPlot`GraphCoordinates::miter = DiscreteMath`GraphPlot`GraphCoordinates3D::miter  = SparseArray`GraphPlacement::miter = DiscreteMath`GraphPlot`GraphPlot3D::miter = SparseArray`GraphPlacement3D::miter = "The value of option MaxIterations->`1` should be Automatic or a positive machine integer."
DiscreteMath`GraphPlot`GraphCoordinates::stepc = DiscreteMath`GraphPlot`GraphCoordinates3D::stepc  = SparseArray`GraphPlacement::stepc = DiscreteMath`GraphPlot`GraphPlot3D::stepc = SparseArray`GraphPlacement3D::stepc = "The value of option StepControl->`1` should be Automatic, \"NonMonotonic\", \"Monotonic\", or \"StrictlyMonotonic\"."
DiscreteMath`GraphPlot`GraphCoordinates::engctl = DiscreteMath`GraphPlot`GraphCoordinates3D::engctl  = SparseArray`GraphPlacement::engctl = DiscreteMath`GraphPlot`GraphPlot3D::engctl = SparseArray`GraphPlacement3D::engctl = "The value of option EnergyControl->`1` should be Automatic, \"NonMonotonic\", or \"Monotonic\"."
DiscreteMath`GraphPlot`GraphCoordinates::infd = DiscreteMath`GraphPlot`GraphCoordinates3D::infd  = SparseArray`GraphPlacement::infd = DiscreteMath`GraphPlot`GraphPlot3D::infd = SparseArray`GraphPlacement3D::infd = "The value of option InferentialDistance->`1` should be Automatic or a positive machine integer."
DiscreteMath`GraphPlot`GraphCoordinates::octr = DiscreteMath`GraphPlot`GraphCoordinates3D::octr  = SparseArray`GraphPlacement::octr = DiscreteMath`GraphPlot`GraphPlot3D::octr = SparseArray`GraphPlacement3D::octr = "The value of option Octree->`1` should be Automatic, True, or False."
DiscreteMath`GraphPlot`GraphCoordinates::rfp = DiscreteMath`GraphPlot`GraphCoordinates3D::rfp  = SparseArray`GraphPlacement::rfp = DiscreteMath`GraphPlot`GraphPlot3D::rfp = SparseArray`GraphPlacement3D::rfp = "The value of option RepulsiveForcePower->`1` should be a negative machine number."
DiscreteMath`GraphPlot`GraphCoordinates::refm = DiscreteMath`GraphPlot`GraphCoordinates3D::refm  = SparseArray`GraphPlacement::refm = DiscreteMath`GraphPlot`GraphPlot3D::refm = SparseArray`GraphPlacement3D::refm = "The value of option RefinementMethod->`1` should be None, \"SpringElectricalModel\", or \"SpringModel\"."
DiscreteMath`GraphPlot`GraphCoordinates::mthd = DiscreteMath`GraphPlot`GraphCoordinates3D::mthd  = SparseArray`GraphPlacement::mthd = DiscreteMath`GraphPlot`GraphPlot3D::mthd = SparseArray`GraphPlacement3D::mthd = "The value of option Method->`1` should be Automatic, \"SpringElectricalModel\", \"SpringModel\", \"LayeredDrawing\", \"RadialDrawing\", or \"HighDimensionalEmbedding\"."
DiscreteMath`GraphPlot`GraphCoordinates::eig = DiscreteMath`GraphPlot`GraphCoordinates3D::eig  = SparseArray`GraphPlacement::eig = DiscreteMath`GraphPlot`GraphPlot3D::eig = SparseArray`GraphPlacement3D::eig = "HighDimensionalEmbedding method failed because eigenvectors of the covariant matrix can not be calculated."
DiscreteMath`GraphPlot`GraphCoordinates::rseed = DiscreteMath`GraphPlot`GraphCoordinates3D::rseed  = DiscreteMath`GraphPlot`GraphPlot3D::rseed = NMinimize::rseed = NMaximize::rseed = "Value of option RandomSeed -> `1` is not an integer or Automatic."
DiscreteMath`GraphPlot`GraphCoordinates::rooti = DiscreteMath`GraphPlot`GraphCoordinates3D::rooti  = DiscreteMath`GraphPlot`GraphPlot::rooti = DiscreteMath`GraphPlot`GraphPlot3D::rooti = "Value of method option Root -> `1` is not a vertex."
FaceGrids::fglst = "Value for option FaceGrids -> `1` is not None, All, or a list with 6 or fewer elements."
FaceGrids::fgstl = "`1` is not a valid grid style specification."
FaceGrids::gface = "`1` is not a valid face specification."
Factor::facim = FactorSquareFree::facim = "Factoring non-integer polynomials with respect to a modulus is not implemented."
Factor::facmm = "Factoring multivariate polynomials with respect to a modulus is not yet implemented; using FactorSquareFree instead."
Factor::priml = "Prime `1` is too large for this implementation."
Factor::ufac = FactorSquareFree::ufac = "Unable to perform the square-free factorization."
FactorInteger::faccp = "Unable to factor `1` completely."
FactorInteger::facn = "Argument `1` in `2` is not an exact number."
FactorInteger::facnf = "Unable to factor `1`."
FactorInteger::gfacnf = "Unable to factor `1` + `2` I."
FileNames::cdir = ParentDirectory::cdir = ResetDirectory::cdir = SetDirectory::cdir = "Cannot set current directory to `1`."
FindFit::bdmtd = FindMinimum::bdmtd = FindMaximum::bdmtd = "Value of option Method -> `1` is not Automatic, \"Gradient\", \"ConjugateGradient\", \"QuasiNewton\", \"Newton\", or \"LevenbergMarquardt\"."
FindMinimum::fddis = FindMaximum::fddis = FindFit::fddis = FindRoot::fddis = "The starting values `1` and `2` are not sufficiently distinct to begin a search."
FindMinimum::fdin = FindMaximum::fdin = FindFit::fdin = FindRoot::fdin = "Form of start specification `1` in `2` is inconsistent with other start specifications."
FindMinimum::lss = FindMaximum::lss = FindRoot::lss = "`1` should be a nonempty list of search specifications, each consisting of a variable and starting values."
FindFit::lss = "`1` should be a nonempty list of search specifications, each consisting of a variable and possibly starting values."
FindMinimum::fdss = FindMaximum::fdss = FindRoot::fdss = "Search specification `1` should be a list with a 2-5 elements."
FindFit::fdss = "Search specification `1` should be a list with 1-5 elements."
FindMinimum::srect = FindMaximum::srect = FindFit::srect = FindRoot::srect = "Value `1` in search specification `2` is not a number or array of numbers."
FindMinimum::scdims = FindMaximum::scdims = FindFit::scdims = FindRoot::scdims = "Values given in search specification `1` do not have consistent dimensions."
FindMinimum::snum = FindMaximum::snum = FindFit::snum = FindRoot::snum = "Value `1` in search specification `2` is not a number."
FindMinimum::fdssnv = FindMaximum::fdssnv = FindRoot::fdssnv = FindFit::fdssnv = "Search specification `1` without variables should be a list with a 1-4 elements."
FindMinimum::fdvc = FindMaximum::fdvc = FindFit::fdvc = FindRoot::fdvc = "Variable number `1` has value `2` which cannot be compared with the bounds `3`."
FindMinimum::bbound = FindMaximum::bbound = FindFit::bbound = FindRoot::bbound = "Search region bound `1` for variable number `2` is not a number or Infinity."
FindMinimum::linf = FindMaximum::linf = FindFit::linf = FindRoot::linf = "Lower bound for search region for variable number `1` is Infinity, leaving no values in the region."
FindMinimum::uinf = FindMaximum::uinf = FindFit::uinf = FindRoot::uinf = "Upper bound for search region for variable number `1` is -Infinity, leaving no values in the region."
FindMinimum::cvmit = FindMaximum::cvmit = FindFit::cvmit = FindRoot::cvmit = "Failed to converge to the requested accuracy or precision within `1` iterations."
FindMinimum::fmdig = FindMaximum::fmdig = FindFit::fmdig = "`1` working digits is insufficient to achieve the requested accuracy or precision."
FindMinimum::nzres = FindMaximum::nzres = FindFit::nzres = "The step size for Method->LevenbergMarquardt has become nearly zero at working precision `1`.  The residual appears to be nonzero, which can lead to poor convergence of the method.  It is recommended that you try Method->Newton or Method->QuasiNewton for better convergence."
FindMinimum::sctl = FindMaximum::sctl = FindFit::sctl = FindRoot::sctl = "The value of the option StepControl->`1` is not one of Automatic, LineSearch, TrustRegion, or None."
FindMinimum::scone = FindMaximum::scone = FindFit::scone = FindRoot::scone = "The method you have chosen is only compatible with StepControl->`1`."
FindFit::sdprec = FindMinimum::sdprec = "Line search unable to find a sufficient decrease in the function value with `1` digit precision."
FindMaximum::sdprec = "Line search unable to find a sufficient increase in the function value with `1` digit precision."
FindRoot::sdprec = "Line search unable to find a sufficient decrease in the merit function value with `1` digit precision."
FindMinimum::lstol = "The line search decreased the step size to within tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find a sufficient decrease in the function.  You may need more than `1` digits of working precision to meet these tolerances."
FindMaximum::lstol = "The line search decreased the step size to within tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find a sufficient increase in the function.  You may need more than `1` digits of working precision to meet these tolerances."
FindFit::lstol = "The line search decreased the step size to within tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find a sufficient decrease in the norm of the residual.  You may need more than `1` digits of working precision to meet these tolerances."
FindRoot::lstol = "The line search decreased the step size to within tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find a sufficient decrease in the merit function.  You may need more than `1` digits of working precision to meet these tolerances."
FindFit::lsbrak = FindMinimum::lsbrak = "Unable to bracket a minimum along the direction `2` from the point `1`."
FindMaximum::lsbrak = "Unable to bracket a maximum along the direction `2` from the point `1`."
FindRoot::btf = FindMinimum::btf = FindMaximum::btf = FindFit::btf = "The value of the option BacktrackingFactors->`1` should be a list {amin, amax} with 0 < amin <= amax < 1."
FindRoot::bddir = "The search direction `1` is not a descent direction for the merit function. The step will be taken without the line search."
FindMinimum::bddir = FindFit::bddir = "The search direction `1` is not a descent direction for the function.  Typically this occurs when the function is not smooth or the values of the function are much less accurate than the WorkingPrecision."
FindMaximum::bddir = "The search direction `1` is not a ascent direction for the function.  Typically this occurs when the function is not smooth or the values of the function are much less accurate than the WorkingPrecision."
FindMinimum::fmgl = FindMaximum::fmgl = FindFit::fmgl = "Gradient `1` is not a length `2` list of real numbers at `3` = `4`."
FindMinimum::fmgs = FindMaximum::fmgs = FindFit::fmgs = "Could not symbolically find the gradient of `1`. Try using the default method, giving two starting values for each variable."
FindMinimum::prax2 = FindMaximum::prax2 = FindFit::prax2 = "Method->PrincipalAxis requires two starting values in each variable." 
FindMinimum::fmhs = FindMaximum::fmhs = FindFit::fmhs = "Could not symbolically find the Hessian by differentiating the gradient `1`. Try using Method->QuasiNewton instead."
FindMinimum::fmgz = FindFit::fmgz = "Encountered a gradient which is effectively zero. The result returned may not be a minimum; it may be a maximum or a saddle point."
FindMaximum::fmgz = "Encountered a gradient which is effectively zero. The result returned may not be a maximum; it may be a minimum or a saddle point."
FindMinimum::fmmp = FindMaximum::fmmp = FindFit::fmmp = "Machine precision is insufficient to achieve the requested accuracy or precision."
FindMinimum::fmns = FindMaximum::fmns = FindFit::fmns = "Starting value `1` contains numbers which are not real."
FindMinimum::fmwar = FindMaximum::fmwar = FindFit::fmwar = "When Method -> LevenbergMarquardt, Newton or QuasiNewton only the first starting value in each dimension will be used."
FindFit::notlm = FindMinimum::notlm = "The objective function for the method LevenbergMarquardt must be in a least-squares form: Sum[f[i][x]^2,{i,1,n}] or Sum[w[i] f[i][x]^2,{i,1,n}] with positive w[i]."
FindMaximum::notlm = "The objective function for the method LevenbergMarquardt must be in a least-squares form: Sum[-f[i][x]^2,{i,1,n}] or Sum[w[i] f[i][x]^2,{i,1,n}] with negative w[i]."
FindMinimum::regex1 = FindMaximum::regex1 = FindFit::regex1 = FindRoot::regex1 = "Reached the point `1` which has component `2` equal to `3` which is outside the range `4`."
FindMinimum::regex = FindMaximum::regex = FindFit::regex = FindRoot::regex = "Reached the point `1` which is outside the region `2`."
FindMinimum::reged = FindMaximum::reged = FindFit::reged = FindRoot::reged = "The point `1` is at the edge of the search region `3` in coordinate `2` and the computed search direction points outside the region."
FindMinimum::streg = FindMaximum::streg = FindFit::streg = FindRoot::streg = "The starting point `1` is not in the search region `2`."
FindFit::sszero = FindMinimum::sszero = "The step size in the search has become less than the tolerance prescribed by the PrecisionGoal option, but the gradient is larger than the tolerance specified by the AccuracyGoal option. There is a possibility that the method has stalled at a point which is not a local minimum."
FindMaximum::sszero = "The step size in the search has become less than the tolerance prescribed by the PrecisionGoal option, but the gradient is larger than the tolerance specified by the AccuracyGoal option. There is a possibility that the method has stalled at a point which is not a local maximum."
FindRoot::sszero = "The step size in the search has become less than the tolerance prescribed by the PrecisionGoal option, but the function value is still greater than the tolerance prescribed by the AccuracyGoal option."
FindMinimum::stfail = FindMaximum::stfail = FindFit::stfail = FindRoot::stfail = "The method `1` failed to compute the next step."
FindMinimum::umtd = FindMaximum::umtd = FindFit::umtd = "The method `1` has returned `2` instead of a step for FindMinimum to use or a list {step, state}."
FindMinimum::lsm = FindMaximum::lsm = FindFit::lsm = FindRoot::lsm = "The method `1` is not a line search method."
FindMinimum::trm = FindMaximum::trm = FindFit::trm = FindRoot::trm = "The method `1` is not a trust region method."
FindMinimum::trmss = FindMaximum::trmss = FindFit::trmss = FindRoot::trmss = "The maximum trust region scaled step size `1` is not a positive real number."
FindMinimum::trsss = FindMaximum::trsss = FindFit::trsss = FindRoot::trsss = "The starting trust region scaled step size `1` is not a positive real number."
FindMinimum::trasr = FindMaximum::trasr = FindFit::trasr = FindRoot::trasr = "The value of the option AcceptableStepRatio->`1`, should be real number between 0 and 1/2."
FindRoot::umtd = "The method `1` has returned `2` instead of a step for FindRoot to use or a list {step, state}."
FindRoot::bdmtd = "Value of option Method -> `1` is not Automatic, Brent, Secant, or Newton."
FindRoot::eqlist = "In the first argument `1` only some of the components are equations."
FindRoot::fdst = FindMinimum::fdst = FindMaximum::fdst = FindFit::fdst = "Expression `1` in `2` is not a valid start specification; a number or pair of numbers is expected."
FindRoot::frdig = "`1` working digits is insufficient to achieve the absolute tolerance `2`."
FindRoot::sec2 = "Method->Secant requires two starting values for each dimension."
FindRoot::bbrac = "Method->Brent is only applicable to univariate real functions and requires two real starting values which bracket the root."
FindRoot::frn2 = "With Method->Newton only the first starting value in each dimension will be used."
FindRoot::frmp = "Machine precision is insufficient to achieve the accuracy `1`."
FindRoot::frns = "Starting value `1` in `2` is not a number."
FindRoot::jsing = "Encountered a singular Jacobian at the point `1` = `2`. Try perturbing the initial point(s)."
FindRoot::jsing1 = "Encountered a singular Jacobian at the point `1`. Try perturbing the initial point(s)."
FindRoot::zdamp = "The factors given in DampingFactor->`1` must all be strictly positive."
FindRoot::nveq = "The number of equations does not match the number of variables in `1`."
FindRoot::trcx = "The search has encountered a complex value and the trust region step control method is only implemented for real values."
FindFit::nlnrm = "The model `1` is linear in the parameters `2`, but the norm specified with NormFunction->`3` is non-Euclidean so the linear least-squares method specified with Method->`4` cannot be be used."
FindFit::lmnl = "The model `1` is linear in the parameters `2`, but a nonlinear method or non-Euclidean norm was specified, so nonlinear methods will be used."
FindFit::nlmod = "The model `1` is not linear in the parameters `2` so the linear-least squares method specified with Method->`3` cannot be used."
First::first = "`1` has a length of zero and no first element."
Fit::fitc = FindFit::fitc = "Number of coordinates (`1`) is not equal to the number of variables (`2`)."
Fit::fitd = FindFit::fitd = "First argument `1` in Fit is not a list or a rectangular array."
Fit::fitm = FindFit::fitm = "Unable to solve for the fit parameters; the design matrix is non-rectangular, non-numerical, or could not be inverted."
FlattenAt::flatp = "Expression `3` at position `1` of `2` has no parts and cannot be flattened."
FontForm::ffsp = "`1` is not a valid font specification of the form {\"font\", size}."
Format::forml = ToBoxForm::forml = "Recursion depth limit $RecursionLimit exceeded while formatting output."
Format::fttp = "Format type `1` is not a symbol."
Format::lcont = "Line continuation print object too wide."
Format::toobig = "Expression too big for output."
FormatType::ftype = "Value of option FormatType -> `1` is not valid."
Fourier::fpopt = InverseFourier::fpopt = "The value of the option FourierParameters->`1` should be a length 2 list"
Fourier::fpoptn = InverseFourier::fpoptn = "Both values of the option FourierParameters->`1` need to be numeric."
Fourier::fpopt2 = InverseFourier::fpopt2 = "Warning: the discrete Fourier transform may not be consistent with its inverse unless the second element of the option FourierParameters->`1` is an integer having no factors in common with the length of the input."
Fourier::fftl = InverseFourier::fftl = "Argument `1` is not a non-empty list or rectangular array of numeric quantities."
FrameLabel::fmlab = "Value of option FrameLabel -> `1` should be None or a label or a list with 2 or 4 labels."
FromContinuedFraction::root = "Unable to determine the appropriate root for the periodic continued fraction."
FromDate::fdls = "`1` is neither a list of 6 machine-size integers nor a list of 5 machine-size integers followed by a real number."
FromDigits::nlst = "The expression `1` is not a list of digits."
FrontEndObject::notavail = "A front end is not available; certain operations require a front end."
Function::attf = "Attributes `1` in `2` cannot be used as function attributes."
Function::fdup = Compile::fdup = "Duplicate parameter `1` found in `2`."
Function::fdups = "Conflicting parameters `1` and `3` found in `2`."
Function::flpar = "Parameter specification `1` in `2` should be a symbol or a list of symbols."
Function::fpct = "Too many parameters in `1` to be filled from `2`."
Function::slot = "`1` (in `2`) should contain a non-negative integer."
Function::slotn = "Slot number `1` in `2` cannot be filled from `3`."
Function::slotp = "`1` (in `2`) should contain a positive integer."
Function::slots = "SlotSequence[`1`] in `2` cannot be filled from `3`."
FunctionInterpolation::accg = "Value of option AccuracyGoal -> `1` is not Automatic, Infinity, or a machine-size integer."
FunctionInterpolation::argdim = "The dimension of the argument to an InterpolatingFunction function object in the input does not match the dimension of the InterpolatingFunction."
FunctionInterpolation::ncvb = "FunctionInterpolation failed to meet the prescribed accuracy and precision goals after `1` recursive bisections near `2` = `3`. Continuing to refine elsewhere."
FunctionInterpolation::npts = "Value of option InterpolationPoints -> `1` is not a machine-size integer >= 2."
FunctionInterpolation::nreal = "Near `1` = `2`, the function did not evaluate to a real number."
FunctionInterpolation::precg = "Value of option PrecisionGoal -> `1` is not Automatic, Infinity, or a positive machine-size real or integer."
FunctionInterpolation::range = "Argument `1` is not in the form of a range specification, {x, xmin, xmax}."
Gamma::gamc = "Gamma[`1`, `2`] is too ill-conditioned to compute."
GCD::exact = LCM::exact = "Argument `1` at position `2` is not an exact number."
General::altel = "Use `1` to specify assumptions for multiple variables."
General::altno = "Use multiple sets instead of Alternatives in `1`."
General::aofil = "`1` already open as `2`."
General::argb = "`1` called with `2` arguments; between `3` and `4` arguments are expected."
General::argbu = "`1` called with 1 argument; between `2` and `3` arguments are expected."
General::argct = "`1` called with `2` arguments."
General::argctu = "`1` called with 1 argument."
General::argf = "`1` called with `2` arguments; `3` or fewer arguments are expected."
General::argm = "`1` called with `2` arguments; `3` or more arguments are expected."
General::argmu = "`1` called with 1 argument; `2` or more arguments are expected."
General::argr = "`1` called with 1 argument; `2` arguments are expected."
General::argrx = "`1` called with `2` arguments; `3` arguments are expected."
General::argt = "`1` called with `2` arguments; `3` or `4` arguments are expected."
General::argtu = "`1` called with 1 argument; `2` or `3` arguments are expected."
General::argx = "`1` called with `2` arguments; 1 argument is expected."
General::base = "Requested base `1` in `2` should be between 2 and `3`."
General::bass = "`1` is not a well formed assumption."
General::bebal = "Unterminated uses of BeginPackage or Begin in `1`."
General::bktfn = "\"`1`\" should probably be \"`2`\".`4`"
General::bktmch = "\"`1`\" must be followed by \"`2`\", not \"`3`\".`4`"
General::bktmcp = "Expression \"`1`\" has no closing \"`2`\".`4`"
General::bktmop = "Expression \"`1`\" has no opening \"`2`\".`4`"
General::bktwrn = "\"`1`\" represents multiplication; use \"`2`\" to represent a function.`4`"
General::bktx = "\"`1`\" has extra \"`2`\" after it.`4`"
General::bmod = "Modulus `1` must be an integer or an irreducible univariate polynomial."
General::bool = "True or False expected at position `2` in `1`."
General::boxfmt = "`1` in `2` is not a box formatting type. A box formatting type is any member of $BoxForms."
General::byteord = "Value of option ByteOrdering -> `1` should be 1 or -1."
General::cadpr = "The cylindrical algebraic decomposition algorithm used by `1` failed due to a too low WorkingPrecision. Increasing the value of WorkingPrecision may allow the algorithm to succeed." 
General::cas = "Warning: Contradictory assumption(s) `1` encountered."
General::cfail = "Algorithm failed to converge."
General::color = "`1` is not a valid color or gray-level specification."
General::copt = "The option Compiled->`1` should be True, False, or a list starting with True or False, followed by options."
General::conopt = "Value of option ConversionOptions -> `1` is not a string option or a list of string options."
General::continfo = "\!\(`1`f\[DifferentialD]x\) is interpreted as \!\(`2`[f, x]\)."
General::cxls = "Context or non-empty list of contexts expected at position `1` in `2`."
General::cxt = "Invalid context specified at position `3` in `2`. A context must consist of valid symbol names separated by and ending with `4`."
General::dblk = "Value for option DigitBlock should be a positive integer, Infinity, or a pair of positive integers."
General::digit = "Digit at position `1` in `2` is too large to be used in base `3`."
General::dim = "Dimension `1` is not a positive integer giving a dimension to select for data associated with `2` dimensions."
General::dirdep = "Cannot get deeper in directory tree: `1`."
General::deprec = "`1` is deprecated and will not be supported in future versions of Mathematica.  Use `2` instead."
General::dstr = "Directory specification `1` is not a string."
General::dupsym = "The symbol `1` with context `2` already exists."
General::eival = "Unable to find all roots of the characteristic polynomial."
General::eivec = "Unable to find eigenvector for eigenvalue `1`."
General::eivn = "Incorrect number `1` of eigenvectors for eigenvalue `2` with multiplicity `3`."
General::enable = "`1` is not enabled in your version of Mathematica."
General::epoch = "`1` seconds is too far in the future.  Try a smaller amount of time."
General::estep = "Value of option `1` -> `2` is not a positive integer."
General::existinfo = "\!\(`1`\_x y\) is interpreted as `2`[x, y]."
General::fas = "Warning: One or more assumptions evaluated to False."
General::filro = "Attempt to modify a read-only file during `1`."
General::fmtval = "`1` is not a valid format type."
General::fnsym = "First argument in `1` is not a symbol or a string naming a symbol."
General::fstr = "File specification `1` is not a string of one or more characters."
General::globf = "Cannot open object obtained by expansion of `1`."
General::globm = "Too many matches for `1`: `2`."
General::globn = "No matches for `1`."
General::gprim = "`2` was encountered where a `1` primitive or directive was expected."
General::heads = "Heads `1` and `2` at positions `3` and `4` are expected to be the same."
General::hmdir = "\"~\" should be followed by \"/\": only the current user's home directory is supported."
General::idid = "`1` is not an integration direction specified by Forward or Backward."
General::ifexp = "The exponent `1` is not an integer."
General::ifpa = "The precision or accuracy `1` is not representable as a machine number."
General::ilsm = "List of machine-size integers expected at position `2` in `1`."
General::ilsmi = "Single or non-empty list of machine-size integers expected at position `2` in `1`."
General::ilsmn = "Single or list of non-negative machine-size integers expected at position `2` of `1`."
General::ilsmp = "Single or list of positive machine-size integers expected at position `2` of `1`."
General::incomma = "`1` is a structural element which is interpreted as an ordinary comma."
General::indet = "Indeterminate expression `1` encountered."
General::infy = "Infinite expression `1` encountered."
General::inf = "Input matrix contains an infinite entry."
General::initstate = "`1` cannot be used during initialization."
General::innf = "Non-negative integer or Infinity expected at position `2` in `1`."
General::interpfmt = "`1` is not a valid interpretation format. Valid interpretation formats include InputForm and any member of $BoxForms."
General::ipnf = "Positive integer or Infinity expected at position `2` in `1`."
General::ipnfm = "Positive machine-size integer or Infinity expected at position `2` in `1`."
General::int = "Integer expected at position `2` in `1`."
General::intinfo = "\!\(\[Integral]f\[DifferentialD]x\) or \!\(\[Integral]f\[CapitalDifferentialD]x\) is interpreted as Integrate[f, x]; \!\(\[Integral]\^b\%a f\[DifferentialD]x\) or \!\(\[Integral]\^b\%a f\[CapitalDifferentialD]x\) is interpreted as Integrate[f, {x,a,b}]."
General::intm = "Machine-size integer expected at position `2` in `1`."
General::intnm = "Non-negative machine-size integer expected at position `2` in `1`."
General::intnz = "Non-zero integer expected at position `2` in `1`."
General::intpm = "Positive machine-size integer expected at position `2` in `1`."
General::ioarg = "Argument in `1` is not valid for I/O operation."
General::ioerr = "I/O error occurred during `1`."
General::iopf = "Value of option `1` -> `2` should be an integer or Infinity."
General::iopa = "Value of option `1` -> `2` should be an integer or Automatic."
General::iopnf = "Value of option `1` -> `2` should be a non-negative integer or Infinity."
General::iopnm = "Value of option `1` -> `2` should be a non-negative machine-size integer."
General::ioppm = "Value of option `1` -> `2` should be a positive machine-size integer."
General::ioppf = "Value of option `1` -> `2` should be a positive integer or Infinity."
General::ioppfa = "Value of option `1` -> `2` should be a positive integer, Infinity, or Automatic."
General::isdir = "Cannot open directory for reading."
General::iterb = "Iterator `1` does not have appropriate bounds."
General::itflrw = "Warning: In evaluating `1` to find the number of iterations to use for `2`, $MaxExtraPrecision = `3` was encountered. An upper estimate will be used for the number of iterations."
General::itform = "Argument `1` at position `2` does not have the correct form for an iterator."
General::itraw = "Raw object `1` cannot be used as an iterator."
General::ittag = "Cannot use `1` as an iterator, since it contains no assignment tag."
General::ivar = "`1` is not a valid variable."
General::lconv = "QR algorithm failed to converge."
General::level = "Level specification `1` is not of the form n, {n}, or {m, n}."
General::list = "List expected at position `2` in `1`."
General::longp = "Pathname in `1` is too long."
General::lrgexp = "Exponent is out of bounds for function `1`."
General::lspec = "`1` is not a valid color, thickness, or dashing specification."
General::luc = "Result for `1` of badly conditioned matrix `2` may contain significant numerical errors."
General::markset = "Cannot set `1` to `2`; value must be one of True, False, and Automatic."
General::matrix = "Argument `1` at position `2` is not a nonempty rectangular matrix."
General::scalar = "Argument `1` at position `2` is not a scalar."
General::matsq = "Argument `1` at position `2` is not a nonempty square matrix."
General::mbox = "MatchBox cannot occur in transformation rule source."
General::mbrpos = "Position `2` in `1` must be one of `3`."
General::meprec = "Internal precision limit $MaxExtraPrecision = `1` reached while evaluating `2`."
General::mext = "Conflicting option setting. If Modulus is not 0, then Extension should be None."
General::mindet = "Input matrix contains an indeterminate entry."
General::nojvgr = "Cannot render using Java. Disabling Java graphics."
General::numnm = "Non-negative machine-size number expected at position `2` in `1`."
General::modgp = "Value of option `1` -> `2` should be a Gaussian prime number."
General::modint = "Modulus `1` must be an integer."
General::modm = "Modulus `1` is too large for this implementation."
General::modn = "Value of option `1` -> `2` should be an integer."
General::modp = "Value of option `1` -> `2` should be a prime number or zero."
General::mult = "Value of option Multiplicity -> `1` is not a positive integer."
General::nalg = "`1` is not an explicit algebraic number."
General::naobj = "`1` is not a valid Algebraic object."
General::ncomp = "Unable to decide whether `1` and `2` are equal. Assuming they are."
General::ncompl = "Symbolic or non-complex numerical arguments are expected."
General::newl = "The newline character after \"`1`\" is understood as a multiplication operator.`4`"
General::newsym = "Symbol `1` is new."
General::nfdir = "Directory not found during `1`."
General::nffil = "File not found during `1`."
General::niupf = "`1` is not an irreducible univariate polynomial function with rational coefficients."
General::nlist3 = "`1` is not a list of three numbers."
General::nmod = "`1` is not valid modulo `2`."
General::nonopt = "Options expected (instead of `1`) beyond position `2` in `3`. An option must be a rule or a list of rules."
General::noopen = "Cannot open `1`."
General::nord = "Invalid comparison with `1` attempted."
General::normal = "Nonatomic expression expected at position `1` in `2`."
General::nosym = "`1` does not contain a symbol to which to attach a rule."
General::notfound = "Symbol `1` not found."
General::notnorm = "Argument `1` must be a nonatomic expression."
General::notstr = "The format type `1` is valid only for string input."
General::noval = "Symbol `1` in part assignment does not have an immediate value."
General::npad = "Value for option NumberPadding -> `1` should be a string or a pair of strings."
General::npoly = "`1` is not a polynomial with rational number coefficients."
General::npolys = "`1` is not a list of polynomials with rational number coefficients."
General::npt = "Value for option `1` -> `2` is expected to be a string."
General::nptg = "Value for option `1` -> `2` is expected to be a `3`."
General::nptn = "Value for option `1` -> `2` is expected to be a number."
General::nsdims = "Matrices `1` and `2` must have the same number of rows and columns."
General::nsgn = "Value for option NumberSigns -> `1` should be a pair of strings or two pairs of strings."
General::nspr = "Value for option NumberSeparator -> `1` should be a string or a pair of strings."
General::numberm = "Machine-size number expected at position `2` in `1`."
General::nupf = "`1` is not a univariate polynomial function with rational coefficients."
General::openr = "`1` is open for input."
General::openw = "`1` is open for output."
General::openx = "`1` is not open."
General::optlist = "Value of option `1` -> `2` should be a list."
General::opset = "Option `1` is not set in `2`."
General::opstl = "Value of option `1` -> `2` should be a string or a list of strings."
General::optb = "Optional object `1` in `2` is not a single blank."
General::optrs = "Option specification `1` in `2` is not a rule for a symbol or string."
General::patc = "Mixed operation with SparseArrays of explicit and pattern type will result in a SparseArray of pattern type without explicit values."
General::moptrs = "Method option specification `1` in `2` is not a rule for a symbol or string."
General::opttf = "Value of option `1` -> `2` should be True or False."
General::opttfa = "Value of option `1` -> `2` should be True, False, or Automatic."
General::optv = "The value of option `1` in `2` is not valid."
General::optvg = "Value of option `1` -> `2` should be `3`."
General::optvp = "Invalid option value at position `1` in `2`.  Allowed values are `3`."
General::optx = "Unknown option `1` in `2`."
General::moptx = "Method option `1` in `2` is not one of `3`."
General::ovfl = "Overflow occurred in computation."
General::par = "Inappropriate parameter: `1` -> `2`."
General::partd = "Part specification `1` is longer than depth of object."
General::partialinfo = "\!\(`1`\_x y\) is interpreted as `2`[y, x]."
General::partw = "Part `1` of `2` does not exist."
General::patop = "Pattern `1` contains inappropriate optional object."
General::pcolor = "The shading function has produced colors of different types."
General::plln = "Limiting value `1` in `2` is not a machine-size real number."
General::poly = "`1` is not a polynomial."
General::polyx = "`1` is not a polynomial with exact coefficients."
General::precbd = "Requested precision `1` is not a machine sized real number between $MinPrecision and $MaxPrecision."
General::preclg = "Requested precision `1` is larger than $MaxPrecision. Using current $MaxPrecision of `2` instead. $MaxPrecision = Infinity specifies that any precision should be allowed."
General::precsm = "Requested precision `1` is smaller than $MinPrecision. Using $MinPrecision instead."
NDSolve::precw = "The precision of the differential equation (`1`) is less than WorkingPrecision (`2`)."
FindFit::precw = "The precision of the data and model function (`1`) is less than the specified WorkingPrecision (`2`)."
General::precw = "The precision of the argument function (`1`) is less than WorkingPrecision (`2`)."
General::primm = "Tried `1` primes, algorithm failed."
General::prims = "Prime `1` is too small, algorithm failed."
General::privv = "Privilege violation during `1`."
General::pspec = "Part specification `1` is neither an integer nor a list of integers."
General::pvec = "Unable to find principal vectors for eigenvalue `1`."
General::rawvar = "Parameter `1` in `2` is a raw expression and cannot be used as a variable."
General::rdeg = "`1` computation failed due to inability to use roots of the polynomial `2` of degree `3` which exceeds $MaxRootDegree. Increasing the value of $MaxRootDegree may allow `1` to succeed."
General::readp = "Symbol `1` is read protected."
General::real = "In attempting decide whether a solution `1` is real $MaxExtraPrecision `2` was encountered. The solution was assumed real. Increasing the value of $MaxExtraPrecision may help resolve the uncertainty."
Dot::rect = Tr::rect = "Non-rectangular tensor encountered."
General::rect = "Non-rectangular array encountered."
General::rectn = "Rectangular array of real numbers is expected at position `2` in `1`."
General::rectt = "Rectangular array expected at position `2` in `1`."
General::remote = "`1` cannot write an output file since the FrontEnd and Kernel do not share a common file system."
General::rnum = "`1` is not a valid root number."
General::rvalue = "`1` is not a variable with a value, so its value cannot be changed."
General::seqso = "Sequence specification (+n, -n, {+n}, {-n}, or {m, n}) expected at position `2` in `1`."
General::seqs = "Sequence specification (+n, -n, {+n}, {-n}, {m, n}, or {m, n, s}) expected at position `2` in `1`."
General::setp = "Part assignment to `1` could not be made."
General::setps = "`1` in assignment of part is not a symbol."
General::shdw = "Symbol `1` appears in multiple contexts `2`; definitions in context `3` may shadow or be shadowed by other definitions."
General::shdwcor = "Symbol `1` defined in `2` already exists in `3`. Select the version you want to use: `4`."
General::shlen = "The argument `1` should have at least two elements."
General::sign = "Unable to determine sign of `1`. The expression was assumed to be zero. Increasing the value of $MaxExtraPrecision may help resolve the uncertainty."
General::sing = "Matrix `1` is singular."
General::sntx = "Syntax error in or before \"`1`\".`4`"
General::sntxb = "Expression cannot begin with \"`1`\".`4`"
General::sntxc = "The comment starting at \"`1`\" has no closing \"*)\".`4`"
General::sntup = "Unexpected end of file (probably unclosed parenthesis).`4`"
General::sntue = "Unexpected end of file (probably unfinished expression).`4`"
General::sntxf = "\"`1`\" cannot be followed by \"`2`\".`4`"
General::sntxi = "Incomplete expression; more input is needed.`4`"
General::sntxpi = "Incomplete expression in result of $PreRead.`4`"
General::sntxpr = "Syntax error in result of $PreRead."
General::sntxq = "The string starting at \"`1`\" has no closing quote.`4`"
General::spell = "Possible spelling error: new symbol name \"`1`\" is similar to existing symbols `2`."
General::spell1 = "Possible spelling error: new symbol name \"`1`\" is similar to existing symbol \"`2`\"."
General::ssle = "Symbol, string, or HoldPattern[symbol] expected at position `2` in `1`."
General::stmtype = "FormatType option of stream `1` cannot be set to `2`. Use a string-based format such as OutputForm."
General::stop = "Further output of `1` will be suppressed during this calculation."
General::strbox = "`1` is an operator for representing textual boxes in strings."
General::stream = "`1` is not a string, InputStream[ ], or OutputStream[ ]."
General::string = "String expected at position `1` in `2`."
General::stringopt = "`1` in `2` is not a string. All options to `3` must be strings."
General::strmi = "First argument in `1` is not a valid file or string identifier."
General::strml = "`1` is not a string, stream, or list of strings and streams."
General::strmn = "Requested stream `1` does not match existing stream `2` with the same stream number."
General::strpatt = "String or string pattern expected at position `1` in `2`."
General::strpatts = "String/string pattern or list of such expected at position `1` in `2`."
General::strs = "String or non-empty list of strings expected at position `1` in `2`."
General::strse = "String or list of strings expected at position `1` in `2`."
General::suminfo = "\!\(`1`\^i\%imax f\) is interpreted as `2`[f, {i,imax}]."
General::sym = "Argument `1` at position `2` is expected to be a symbol."
General::sysname = "`1` is not a known SystemOption."
General::systrg = "`1` is not a string. SystemOptions must be strings."
General::tag = "Rule for `1` of `2` can only be attached to `3`."
General::toomany = "The length of the output of `1` should be a machine integer."
General::trace = "`1` --> `2`."
General::tsntxi = "\"`1`\" is incomplete; more input is needed.`4`"
General::uinfix = "An infix operator, \!\(x `1` y\) is by default interpreted as \!\(`2`[x, y]\)."
General::unfl = "Underflow occurred in computation."
General::uniclose = "`1` is a closing matchfix operator."
General::uniopen = "`1` is an opening matchfix operator."
General::unique = "There is more than one occurence of `1` in `2`.  `1` is required to be unique."
General::unuser = "Unknown user: `1`."
General::uprefix = "A prefix operator. \!\(`1` x\) is by default interpreted as \!\(`2`[x]\)."
General::upreinfix = "An infix and prefix operator. \!\(x `1` y\) is by default interpreted as \!\(`2`[x, y]\) ; \!\(`1` x\) is by default interpreted as \!\(`2`[x]\)."
General::write = "Tag `1` in `2` is Protected."
General::wrsym = "Symbol `1` is Protected."
General::ztest = "Unable to decide whether numeric quantities `1` are equal to zero. Assuming they are."
General::zval = "Non-numerical value `1` found at position `2` in first argument."
General::unpack = "Unpacking array in call to `1`."
General::unpack1 = "Unpacking array."
General::punpack = "Unpacking array to level `2` in call to `1`."
General::punpack1 = "Unpacking array to level `1`."
General::colfun= "The ColorFunction `1` does not produce a valid color or gray-level directive when applied to element `2`."
General::colfun1= "The ColorFunction `1` produces a color incompatible with the previous color when applied to element `2`."
General::rep = "`1` is not a valid replacement rule."
General::addsyms = "Autoloading file `1` added symbols `2` (not an error)."
General::autoload = "Symbol `1` has autoloading rules attached to load `2` which are disabled by the setting of $AutoLoad to False. The package can be loaded with Get and the evaluation repeated."
General::badsys1 = "File `1` returned symbols `2` that did not match the declared symbol list `3`."
General::badsys2 = "Loading file `1` has removed these system definitions `2`."
General::badsys3 = "Loading file `1` has added system definitions `2` that were not specified in the symbol list for that file."
General::badsys4 = "Loading file `1` returned `2`, it should return a list of the exported symbols."
General::sysfile = "Binary file loading of package `1` by symbol `2` failed."
General::dupv = "Duplicate variable `1` found in `2`."
LinearAlgebra`LAPACK`LANV2::blnsym1 = "The input arguments cannot be symbols for which no numerical values are defined."
General::blcmplx = "The input arguments cannot be complex numbers."
General::blvec = "Argument `1` at position `2` is not a nonempty vector."
General::blvecmat = "Argument `1` at position `2` is not a nonempty vector or matrix."
General::blnotn = "The value of the argument `1` in position `2` is not a number."
General::blncorr = "The value of the argument `1` in position `2` is incorrect."
General::blwarg = "The output argument `1` in position `2` is inconsistent with the input argument(s)."
General::blndim1= "The argument `1` in position `2` has incorrect dimension(s)."
General::blndim2 = "The arguments `1` and `2` have incorrect dimensions."
General::blrank = "The argument `1` evaluates to rank `2`. Rank `3` is expected."
General::blrank1 = "The argument `1` evaluates to rank `2`. Rank `3` or `4` is expected."
General::blnotsym = "The argument `1` at position `2` should not contain any symbol for which no numerical value is defined."
General::blnoval = "The symbol `1` at position `2` should have an immediate value defined."
General::blscas = "The argument `1` should be a symbol which has a scalar immediate value."
General::bldim = "The arguments `1` and `2` in `3` do not have compatible dimensions."
General::bldim1 = "The argument `1` should be a matrix of dimensions `2`-by-`3`."
General::blveclen = "The argument `1` should be a vector of length `2`."
General::blnotsq = "The argument `1` does not have the first dimension at least as large as the second dimension."
General::blnsetst = "The argument `1` at position `2` is not a string starting with one of the letters from the set: `3`."
General::blnulst = "The argument `1` at position `2` must be a non-empty string."
General::blreal = "The argument `1` cannot be of complex type."
General::blnegn = "The argument `1` should be non-negative." 
General::blnmpre = "Argument in `1` is not a positive real number or MachinePrecision symbol."
LinearAlgebra`BLAS`TestArgument::blapos = "The second argument `1` should be an integer which gives the argument position in `2` to test."
LinearAlgebra`BLAS`TestArgument::bltrank = "The required tensor rank `1` should be 0, 1, 2, or _."
General::blintli = "The argument `1` should have integer elements only."
General::blincor = "The arguments `1` and/or `2` are incorrect."
LinearAlgebra`LAPACK`PivotToPermutation::blnotpiv = LinearAlgebra`LAPACK`LASWP::blnotpiv = "The pivot vector `1` is incorrect."
LinearAlgebra`LAPACK`LARTG::blneqsym = "You cannot use the same symbol `1` in positions `2` and `3`."
LinearAlgebra`LAPACK`GESVX::blinstlu = "Warning: the LU factorization of the matrix `1` at position `2` can be unstable, and the solution of the system can be unreliable."
General::notperm = "The permutation vector `1` is incorrect."
General::accg = "Value of option AccuracyGoal -> `1` is not Automatic, Infinity, or a machine-sized real or integer."
General::precg = "Value of option PrecisionGoal -> `1` is not Automatic, Infinity, or a positive machine-size integer or real."
General::specset = "Cannot assign a value to special symbol `1`."
General::wprec = "Value of option WorkingPrecision -> `1` is not a positive machine-sized real or integer."
General::agpginf = "Both Accuracy and Precision goals are sufficiently large to allow effectively zero tolerance.  The numerical algorithm cannot solve the problem exactly."
Get::enkey = "Cannot decode encoded file; incorrect key or machine."
Get::notencode = "Warning: the file `1` is not encoded."
Get::path = "`1` in $Path is not a string."
Goto::nolabel = "Label `1` not found."
Graphics::debug = "`1`: `2`"
Graphics::gpt = "Coordinate `1` is not of the form {x, y}."
Graphics::gptn = "Coordinate `1` in `2` is not a floating-point number."
Graphics::hue = "`1` is not of length 1 or 3."
Graphics::realp = "Argument in `1` is not a positive real number."
Graphics::realu = "Argument in `1` is not a real number between 0 and 1."
Graphics3D::ambnt = "Value of option `1` -> `2` is not a valid GrayLevel or RGBColor specification."
Graphics3D::boxz = "Box for 3D graphics has zero size."
Graphics3D::gsing = Plot3D::gsing = "Singular homogeneous transformation generated."
Graphics3D::gsort = "More than 10^9 polygons to sort."
Graphics3D::lights = "Value of option `1` -> `2` is not of the form {{pos, col}, {pos, col}, ...}."
Graphics3D::ltcol = "Element `1` in LightSources option contains `2`, which is not a valid GrayLevel or RGBColor directive."
Graphics3D::psvf = "Function value at x = `1`, y = `2` was sent to infinity by perspective transformation."
Graphics3D::p3mat = "Value of option Plot3Matrix -> `1` is not a 4 x 4 numerical matrix."
GraphicsArray::obs = "GraphicsArray is obsolete. Switching to GraphicsGrid."
GraphicsArray::arrsp = "Value of option GraphicsSpacing -> `1` should be a number greater than 0 or a list of two such numbers."
GraphicsArray::prim = "Argument to GraphicsArray, `1`, should be a vector or a matrix of graphics objects."
GridLines::grid = "`1` is not a valid grid specification."
GroebnerBasis::badcf = Internal`GroebnerWalk::badcf = PolynomialReduce::badcf = Internal`DistributedTermsList::badcf = "Encountered bad coefficient `1`."
GroebnerBasis::coef = Internal`GroebnerWalk::coef = PolynomialReduce::coef = Internal`DistributedTermsList::coef = "Value of option CoefficientDomain -> `1` not valid."
GroebnerBasis::elmvar = Internal`GroebnerWalk::elmvar = PolynomialReduce::elmvar = Internal`DistributedTermsList::elmvar = "Term ordering `1` is not compatible with elimination variables."
GroebnerBasis::fltgb = Internal`GroebnerWalk::fltgb = PolynomialReduce::fltgb = Internal`DistributedTermsList::fltgb = "Excessive loss of precision during computation."
GroebnerBasis::intgb = Internal`GroebnerWalk::intgb = PolynomialReduce::intgb = Internal`DistributedTermsList::intgb = "Nontrivial denominator in `1` is invalid input for `2` over the integers."
GroebnerBasis::mnmord1 = Internal`GroebnerWalk::mnmord1 = PolynomialReduce::mnmord1 = Internal`DistributedTermsList::mnmord1 = "Value of option MonomialOrder -> `1` not valid."
GroebnerBasis::mnmord2 = Internal`GroebnerWalk::mnmord2 = PolynomialReduce::mnmord2 = Internal`DistributedTermsList::mnmord2 = "`1` does not order all terms formed from variables `2`."
GroebnerBasis::modflt = Internal`GroebnerWalk::modflt = PolynomialReduce::modflt = Internal`DistributedTermsList::modflt = "Cannot specify nonzero modulus when working with inexact coefficients."
GroebnerBasis::pdvar2 = Internal`GroebnerWalk::pdvar2 = PolynomialReduce::pdvar2 = Internal`DistributedTermsList::pdvar2 = "The polynomial domain variable `1` is improperly used in polynomial `2`."
GroebnerBasis::poly2 = Internal`GroebnerWalk::poly2 = PolynomialReduce::poly2 = Internal`DistributedTermsList::poly2 = Resultant::poly2 = "`1` is not a well-formed polynomial in `2`."
GroebnerBasis::varsrt = Internal`GroebnerWalk::varsrt = PolynomialReduce::varsrt = Internal`DistributedTermsList::varsrt = "Sorting of variables is not compatible with the given term ordering."
GroebnerBasis::wgtmat1 = Internal`GroebnerWalk::wgtmat1 = PolynomialReduce::wgtmat1 = Internal`DistributedTermsList::wgtmat1 = "`1` is not a valid weight matrix."
GroebnerBasis::wgtmat2 = Internal`GroebnerWalk::wgtmat2 = PolynomialReduce::wgtmat2 = Internal`DistributedTermsList::wgtmat2 = "Weight matrix based on variable list `1` is invalidated by the internal variable list `2`."
Internal`GroebnerWalk::gmeth1 = GroebnerBasis::gmeth1 = "Recursive use of `1` is invalid."
Internal`GroebnerWalk::gmeth2 = GroebnerBasis::gmeth2 = "Value of option Method -> `1` should be Buchberger or Internal`GroebnerWalk."
Internal`GroebnerWalk::gstrat = GroebnerBasis::gstrat = "Value of option Strategy -> `1` should be SugarCube, NormalSelection or None."
Internal`GroebnerWalk::parmvar = "Use weight matrix instead of parameter(s) `1`."
Developer`HermiteNormalForm::latm = LatticeReduce::latm = "Matrix contains entry that is not rational."
HorizontalForm::precd = VerticalForm::precd = "Precedence list `1` is not of the form {head, prec, assoc, ...}."
Save::wtype = "`1` in `2` must be a symbol, a string or a list of symbols and strings."
Import::chtype = "First argument `1` is not a valid channel type."
Import::dxfemp = "The DXF file being imported does not have any recognizable entities."
Import::dxfflg = "No flag found in DXF POLYLINE entity. Omitting this entity."
Import::dxflin = "No starting point x coordinate or ending point z coordinate found in DXF LINE entity. Omitting this entity."
Import::dxfply = "Encountered DXF POLYLINE entity that is not a polyface mesh. Omitting this entity."
Import::dxfvbf = "Encountered DXF POLYLINE entity with an unsupported vertex bit field. Omitting this vertex."
Import::fmterr = "Invalid `1` format."
Import::fnfnd = "`1`: file not found."
Import::format = "`1` is not a recognized Import format."
Import::enc = "`1` is not a recognized Import Encoding."
Import::guess = "Could not guess format from channel `1`."
Import::guesshb = "Could not guess format from channel `1`. Try using \"HarwellBoeing\" format."
Import::imgsze = "`1` dimensions cannot be determined automatically. Specify the size with the Dimensions option."
Import::intp = "`1` is not a positive integer."
Import::memavail = "Could not allocate memory for import of `1` format."
Import::nffil = "File not found during `1`."
Import::nlist = "`1` is not a list of strings."
Import::nlist2 = "`1` is not a list of two elements."
Import::nodta = "Insufficient data found for `1` format."
Import::nogeom = "The `1` file specifies vertices, but no geometries were found. The resulting graphic will only contain vertices."
Import::nofe = "A front end is not available; import of `1` requires a front end."
Import::nonintyear = "The two-digit-year conversion function produced the non-integer value `2` when Import attempted to interpret the field `1` as a date. This field will be interpreted as a string instead. Check that the value set for \"TwoDigitYearFunction\" in Import's ConversionOptions is correct; typically, it is a function that expects an integer from 0 to 99 as the argument and returns an integer representing the full year."
Import::objomit = "Curves or surfaces are specified but cannot be translated into a graphics primitive, and will be omitted."
Import::objattr = "Display or render attribute \"`1`\" is specified, but will be ignored."
Import::plynv = "PLY file has no recognizable vertex information."
Import::plyvr = "PLY file format is version number `1` (>1.0), which may not parse correctly."
Import::plyuk = "PLY file contains unknown keyword \"`1`\" which will be ignored."
Import::ribent = "`1` is not a RIB Entity file. RIB Entity files must have Entity Header."
Import::difvaluetype = "Invalid value type `1` encountered in file `2`. Suppressing subsequent output."
Import::difdim = "Wrong dimesions reported by file. Dimensions reported: `1`. Dimensions present: `2`."
Import::h5nodata = "The object \"`1`\" does not exist, or is not a dataset."
Import::h5empty = "The HDF5 file \"`1`\" does not contain any datasets."
Import::h5type = "The datatype of the dataset \"`1`\" is not currently supported."
Import::sdtscatd = "Import should be performed on the CATD file from the SDTS bundle i.e. \"????catd.ddf\"."
Import::sdtsmodnf = "Module type `1` not present in file."
Import::sdtsmodinv = "Module `1` does not have the proper form. If this is an old SDTS file, please update it."
Import::unsup = "Unsupported `1` format type."
Import::costr = "`1` in `2` is not a String.  ConversionOptions must be specified as string options."
Import::malxml = "There was a serious error during parsing -- the input is not a well-formed XML document."
Import::pdtder = "There was an error parsing the XML document.  This may be due to undeclared entities in the XML document, or an error loading the DTD.  Check that entities are correctly declared or use the \"AllowUnrecognizedEntities\" conversion option."
Import::texerr = "`1`"
Import::unrecxml = "The document was not a recognized type of XML.  Try Importing as a general \"XML\" document."
ImportString::format = "`1` is not a recognized ImportString format."
ImportString::enc = "`1` is not a recognized ImportString Encoding."
ImportString::string = "First argument `1` is not a string."
ImportString::bkslsh = ToExpression::bkslsh = "The string `1` contains single backslashes. Backslash characters inside strings are reprented by \\\\."
Inequality::ineq = "Inequality called with `1` arguments; the number of arguments is expected to be an odd number >= 3."
Developer`InequalityInstance::lowpr = Experimental`ExistsRealQ::lowpr = Experimental`ForAllRealQ::lowpr = Experimental`ImpliesRealQ::lowpr = "The precision of coefficients of system `1` was too low to decide whether there are any solutions."
Developer`InequalityInstance::nrpi = Experimental`ExistsRealQ::nrpi = Experimental`ForAllRealQ::nrpi = Experimental`ImpliesRealQ::nrpi = "`1` is not a logical formula consisting of polynomial equations and inequalities in `2` with real number coefficients."
Developer`InequalityInstance::weak = Experimental`ExistsRealQ::weak = Experimental`ForAllRealQ::weak = Experimental`ImpliesRealQ::weak = "No solution of the system of inequalities with inexact coefficients has been found. The solution `1` of the system with strong inequalities replaced by weak inequalities has been found. This means the original system may have solutions for some values of inexact coefficients within the error bounds."
Developer`InequalityInstance::wkno = Experimental`ExistsRealQ::wkno = Experimental`ForAllRealQ::wkno = Experimental`ImpliesRealQ::wkno = "No solution of the system of inequalities with inexact coefficients has been found, however the algorithm was not able to prove that the system has no solutions for any values of inexact coefficients within the error bounds."
Infix::group = Postfix::group = Prefix::group = "Grouping specification `1` is not NonAssociative, None, Left, or Right."
Information::basic = "?Name gives information on Name, ?Ab* on all symbols starting with Ab. ??Name gives more information."
Information::nomatch = "No symbol matching `1` found."
Information::notfound1 = "Symbol `1` not found."
Information::opt = "`1` is an invalid option."
Inner::incom = "Length `1` of dimension `2` in `3` is incommensurate with length `4` of dimension 1 in `5`."
Inner::inntf = "Transpose failed for `1`."
Inner::nolev = "Level `1` is not available in `2` (dimensions `3`)."
Insert::ins = "Cannot insert at position `1` in `2`"
IntegerDigits::ibase = IntegerExponent::ibase = "Base `1` is not an integer greater than 1."
Integrate::diffend = "`1` cannot be interpreted since `2` is followed by `3`. It may be necessary to use parentheses to ensure that `2` appears at the end of the integral."
Integrate::gener = "Unable to check convergence."
Integrate::idiv = "Integral of `1` does not converge on `2`."
Integrate::isum = "Warning: infinite subdivision of the integration domain has been used in computation of the definite integral `1`. If the integral is divergent, the result may be incorrect."
Integrate::mdiv = "The multivariate integral `1` does not converge."
Integrate::ilim = "Invalid integration variable or limit(s) in `1`."
Integrate::intmul = "The integral operator `1` cannot be nested directly inside of the integral operator `2`. Only identical integral operators can be nested inside each other without parentheses."
Integrate::intnest = "The integral `1` cannot be interpreted. The number of integral operators must match the number of differential operators."
Integrate::nodiffd = Integrate::novar = "`1` cannot be interpreted. Integrals are entered in the form \!\(\[Integral]f\[DifferentialD]x\), where \!\(\[DifferentialD]\) is entered as \[EscapeKey]dd\[EscapeKey]."
Integrate::wrongd = "`1` cannot be interpreted. Integrals use the differential d (entered as \[EscapeKey]dd\[EscapeKey]) not an ordinary keyboard d."
InterpolatingFunction::cmpile = "The InterpolatingFunction could not be compiled because it has symbolic data or abscissae which cannot be resolved with machine numbers."
InterpolatingFunction::dmval = "Input value `1` lies outside the range of data in the interpolating function. Extrapolation will be used."
InterpolatingFunction::dmvali = "The integration endpoint `1` in dimension `2` lies outside the range of data in the interpolating function. Extrapolation will be used."
InterpolatingFunction::dprec = "The precision of input value `1` and/or the interpolation grid is insufficient to compute the value."
InterpolatingPolynomial::ipdat = "First argument `1` should be a list of non-lists or a list of pairs."
InterpolatingPolynomial::ipdup = "The abscissae are not distinct."
InterpolatingPolynomial::ipf = "Ordinate `1` from data element number `2` should be a non-list or a non-empty vector."
InterpolatingPolynomial::ipval = "Abscissa `1` from data element number `2` should be a non-list."
InterpolatingPolynomial::ipvar = "`1` cannot be used as the variable in a polynomial."
InterpolatingPolynomial::moddata = "When interpolating data with a prime modulus p, values must be exact and valid modulo p."
Interpolation::inauto = ListInterpolation::inauto = "The function value at each grid point must be specified. It cannot be omitted or given as \"Automatic\"."
Interpolation::incon = ListInterpolation::incon = InterpolatingFunction::incon = "The `1` derivative was not specified consistently across other dimensions."
Interpolation::indat = ListInterpolation::indat = "Data point `1` contains abscissa `2` which is not a real number."
Interpolation::indatg = ListInterpolation::indatg = "The abscissa `2` in dimension `1` is not a real number."
Interpolation::inddp = ListInterpolation::inddp = "The point `1` in dimension `2` is duplicated."
Interpolation::indep = ListInterpolation::indep = InterpolatingFunction::indep = "An order-`1` derivative was specified in `2` without all corresponding lower-order derivatives."
Interpolation::inder = ListInterpolation::inder = "The order-`1` derivative of `2` is not a tensor of rank `1` with dimensions `3`."
Interpolation::indim = "The coordinates `1` in dimension `2` are not consistent with other coordinates in this dimension."
Interpolation::indimt = ListInterpolation::indimt = "The coordinate `1` in dimension `2` is not consistent with other values for this coordinate in this row of the data."
Interpolation::inhr = ListInterpolation::inhr = InterpolatingFunction::inhr = "Requested order is too high; order has been reduced to `1`."
Interpolation::inlen = "Inconsistent element `1` encountered; all data elements must have the same length."
Interpolation::innd = ListInterpolation::innd = "First argument in `1` does not contain a list of data and coordinates."
Interpolation::inord = ListInterpolation::inord = FunctionInterpolation::inord = "Value of option `1` -> `2` should be a non-negative machine-sized integer or a list of integers with length equal to the number of dimensions, `3`."
Interpolation::inpts = "The total number `1` of data points is not a multiple of the number `2` of points in dimension `3`."
Interpolation::mixedp = ListInterpolation::mixedp = "Equality of mixed partials in the `1` derivative of data `2` was not satisfied: using `3`."
Interpolation::per = ListInterpolation::per = "In dimension `1` the data at the endpoints of the fundamental period are not equal."
Interrupt::dgbgn = TraceDialog::dgbgn = "Entering Dialog; use Return[] to exit."
Interrupt::dgend = TraceDialog::dgend = "Exiting Dialog."
Interval::nvld = "The form `1` does not represent a valid interval."
Inverse::invc = "Result for inverse of badly conditioned matrix `1` may contain significant numerical errors."
InverseFunction::ifun = "Inverse functions are being used. Values may be lost for multivalued inverses."
InverseFunction::noinv = "The function `1` is not invertible."
JacobiSymbol::jcpo = "Second argument `1` in `2` should be an odd, positive integer."
Last::nolast = "`1` has a length of zero and no last element."
LegendreP::ltype = LegendreQ::ltype = "Legendre type `1` is expected to be 1, 2, or 3."
Limit::ldir = "Value of option Direction -> `1` should be a number or Automatic."
Limit::lim = "Limit specification `1` is not of the form x -> x0."
Limit::limf = "Unable to determine limit direction from `1`."
Import::mpsiv = "Warning: integer variables found in MPS data input and treated as real."
Import::mpsmr = "Warning: multiple right-hand sides found in MPS data input. Only the first one will be used."
Import::mpsbv = "Warning: binary variables found in MPS data input and treated as real."
DualLinearProgramming::lpbd = LinearProgramming::lpbd = "The input that specifies lower/upper bounds contains elements that are not real numbers, Infinity, or -Infinity."
DualLinearProgramming::lpdim = LinearProgramming::lpdim = "Invalid input: the dimensions of the input vectors/matrices must be the same."
DualLinearProgramming::lpnn = LinearProgramming::lpnn = ConstrainedMax::lpnn = ConstrainedMin::lpnn = "Input data to linear programming algorithm `1` contains elements that are empty matrices, invalid vectors/matrices, or not real numbers."
DualLinearProgramming::lprank2 = LinearProgramming::lprank2 = "`1` is not a matrix."
DualLinearProgramming::lprank1 = LinearProgramming::lprank1 = "`1` is not a vector."
DualLinearProgramming::lprank12 = LinearProgramming::lprank12 = "`1` must be a vector or a matrix with 2 columns."
DualLinearProgramming::lprank012 = LinearProgramming::lprank012 = "`1` must be a scalar, a vector, or a matrix with 2 columns."
DualLinearProgramming::lpsg = LinearProgramming::lpsg = "The second column of `1` must be a vector consisting of -1,  1, or 0, indicating respectively inequalities with <=, =>, or equality."
DualLinearProgramming::lpmethod = LinearProgramming::lpmethod = "`1` is not a valid method for linear programming."
ConstrainedMax::cmr = ConstrainedMin::cmr = DualLinearProgramming::cmr = LinearProgramming::cmr = "The constraint matrix `1` in `2` must be a matrix of real numbers."
ConstrainedMax::cmz = ConstrainedMin::cmz = DualLinearProgramming::cmz = LinearProgramming::cmz = "For the constraint matrix `1` in `2` to represent valid constraints, each row must have length greater than zero and contain at least one nonzero entry."
ConstrainedMax::cvr = ConstrainedMin::cvr = DualLinearProgramming::cvr = LinearProgramming::cvr = "The vector `1` in `2` must be a nonzero-length vector of real numbers."
ConstrainedMax::lptol = ConstrainedMin::lptol = DualLinearProgramming::lptol = LinearProgramming::lptol = "Value of option Tolerance -> `1` is not a positive real number or Automatic."
Optimization`LinearProgramming`Simplex::lpsiter = DualLinearProgramming::lpsiter = LinearProgramming::lpsiter = "The value of option MaxIterations->`1` should be a positive integer or Infinity."
Optimization`LinearProgramming`Simplex::lpsiter1 = DualLinearProgramming::lpsiter1 = LinearProgramming::lpsiter1 = "The number of iterations taken has exceeded the preset limit of MaxIterations = `1`. Try setting the MaxIterations option to a higher number."
Optimization`LinearProgramming`Simplex::lpsbnn = DualLinearProgramming::lpsbnn = LinearProgramming::lpsbnn = "Found lower bound and upper bound both set at `1`."
Optimization`LinearProgramming`Simplex::lpsom = DualLinearProgramming::lpsom = LinearProgramming::lpsom = "Warning: the value of the option \"ScalingMethod\"->\"Optimal\" is not allowed for non-machine number problems. \"ScalingMethod\"->\"NormalizeRow\" will be used instead."
Optimization`LinearProgramming`Simplex::lpsnf = ConstrainedMax::lpsnf = ConstrainedMin::lpsnf = DualLinearProgramming::lpsnf = LinearProgramming::lpsnf = "No solution can be found that satisfies the constraints."
Optimization`LinearProgramming`Simplex::lpspm = DualLinearProgramming::lpspm = LinearProgramming::lpspm = "Pricing method specification `1` is invalid."
Optimization`LinearProgramming`Simplex::lpssm = DualLinearProgramming::lpssm = LinearProgramming::lpssm = "Scaling method specification `1` is invalid."
Optimization`LinearProgramming`Simplex::lpsub = ConstrainedMax::lpsub = ConstrainedMin::lpsub = DualLinearProgramming::lpsub = LinearProgramming::lpsub = "This problem is unbounded."
DualLinearProgramming::lplop = LinearProgramming::lplop = "For a problem of this size, `1` uses the interior point algorithm, which only returns a result of machine precision. If a result of non-machine precision is needed, set the option to Method->`2`, though it may take longer computing time."
DualLinearProgramming::lpipp = LinearProgramming::lpipp = "Warning: Method->InteriorPoint specified for non-machine precision problem. A machine precision result will be given. If a non-machine precision result is needed, set the option to Method->`1`."
DualLinearProgramming::lpdinf = LinearProgramming::lpdinf = "The dual of this problem is infeasible, which implies that this problem is either unbounded or infeasible. Setting the option Method->`1` should give a more definite answer, though large problems may take longer computing time."
DualLinearProgramming::lpdinfp = LinearProgramming::lpdinfp = "The dual of this problem is possibly infeasible, which implies that this problem is either unbounded or infeasible. Setting the option Method->`1` should give a more definite answer, though large problems may take longer computing time."
DualLinearProgramming::lpsnfp = LinearProgramming::lpsnfp = "This problem is probably infeasible. Setting the option Method->`1` should give a more definite answer, though large problems may take longer computing time."
DualLinearProgramming::lpipcv = LinearProgramming::lpipcv = "Warning: the interior point algorithm cannot converge to the tolerance of `2`. The best residual achieved is `1`, and the solution at that residual has been returned. Setting the option Method->`3` should give a more definite answer, though large problems may take longer computing time."
DualLinearProgramming::lptols = LinearProgramming::lptols = "Warning: the supplied tolerance of `1` might be too small for the interior point algorithm. Typically a reasonable tolerance for the interior point algorithm is `2` (the square root of the machine epsilon)."
DualLinearProgramming::lpipncv = LinearProgramming::lpipncv = "The interior point algorithm cannot converge to the tolerance of `1`. The best residual achieved is `2`. The failure to converge might be because the problem is mildly infeasible. Setting the option Method->`3` should give a more definite answer, though large problems may take longer computing time."
DualLinearProgramming::lpitd = LinearProgramming::lpitd = "Value of option TreatDenseColumns->`1` is not True, False, or Automatic."
Optimization`LinearProgramming`Simplex::lpsdm2 = "The row dimensions of the second and third arguments do not match."
Optimization`LinearProgramming`Simplex::lpsdm3 = "The row dimensions of the fourth and fifth arguments do not match."
Optimization`LinearProgramming`Simplex::lpsdm4 = "The column dimension of the second argument does not match the length of the first argument."
Optimization`LinearProgramming`Simplex::lpsdm5 = "The length of the first argument does not match the length of the lower bound."
Optimization`LinearProgramming`Simplex::lpsdm6 = "The length of the first argument does not match the length of the upper bound."
Optimization`LinearProgramming`Simplex::lpsdm7 = "The column dimension of the fourth argument does not match the length of the first argument."
General::gfargs = "Generalized `1` arguments accept only matrices with machine real and complex elements."
General::nonnum = "`1` has received a matrix with non-numerical elements."
General::oflow = "Machine overflow encountered during computations."
Optimization`ModifiedCholeskyDecomposition::herm = CholeskyDecomposition::herm = "The matrix `1` is not Hermitian or real and symmetric."
Optimization`ModifiedCholeskyDecomposition::posdef = CholeskyDecomposition::posdef = "The matrix `1` is not sufficiently positive definite to complete the Cholesky decomposition to reasonable accuracy."
SingularValues::neqcols = SingularValueList::neqcols = SingularValueDecomposition::neqcols = "The matrices '1' and '2' must have the same number of columns."
LinearSolve::lsfail = "LinearSolve could not find solutions to the linear system."
General::lslc ="Coefficient matrix and target vector(s)/matrix do not have the same dimensions."
General::lsv = "Second argument `1` is neither a non-empty vector nor a non-empty matrix."
LinearSolve::nosol = "Linear equation encountered which has no solution."
Developer`LinearExpressionToMatrix::nonlin = Developer`LinearExpressionToSparseMatrix::nonlin = "The expression `1` is not linear in the variables `2`."
Developer`LinearExpressionToMatrix::lexp = Developer`LinearExpressionToSparseMatrix::lexp = "The first argument `1` is not a list of expressions or a list of equations."
LinkConnect::linkc = "`1` is dead; attempt to connect failed."
LinkObject::linkd = "`1` is closed; the connection is dead."
LinkObject::linkn = "Argument `1` in `2` has an invalid LinkObject number; the link may be dead."
LinkObject::linkv = LinkWrite::linkv = LinkWriteHeld::linkv = "Argument `1` in `2` is not a valid LinkObject."
LinkObject::linkw = "`1` is closed; attempt to write failed."
LinkObject::linkx = "Argument `1` in `2` is not an open LinkObject."
LinkOpen::linkh = "Value of option LinkHost -> `1` should be a string."
LinkOpen::linki = "MathLink could not be initialized."
LinkOpen::linkm = "Value of option LinkMode -> `1` should be Launch, ParentConnect, Listen, or Connect."
LinkOpen::linknm = "Either a link name or a value for the LinkMode option must be given."
LinkOpen::linkpl = "Value of option LinkProtocol -> `1` should be `2` or Automatic."
LinkOpen::links = "Too many open links."
LinkOpen::linke = "MathLink error: `1`"
LinkRead::linkep = "An unexpected end of packet was received."
LinkWriteHeld::linkhl = "Argument `1` in `2` is not a held expression."
ListConvolve::kldims = ListCorrelate::kldims = "The kernel `1` and list `2` are not both nonempty lists with the same tensor rank."
ListConvolve::nlen = ListCorrelate::nlen = "The end conditions cannot be satisfied. A zero length list will be returned."
ListConvolve::depth = ListCorrelate::depth = "The dimension `1` of the overhang parameters exceeds the rectangular rank of the kernel, `2`."
ListInterpolation::ingrdm = "The dimension of the data to be interpolated in the first argument is inconsistent with the dimension of the grid in the second argument."
ListPlay::lsamps = "The first argument to ListPlay must be a list of samples or a list of lists of samples."
ListPlay::silent = "Sound in channel `1` is silent."
ListPlot::lpn = "`1` is not a list of numbers or pairs of numbers."
LogicalExpand::elist = MainSolve::elist = Roots::elist = ToRules::elist = Solve::elist = Reduce::elist = System`Private`OldReduce::elist = Eliminate::elist = SolveAlways::elist = AlgebraicRules::elist = GroebnerBasis::elist = PolynomialReduce::elist = "List encountered during logical expansion of `1`."
LogicalExpand::eqf = MainSolve::eqf = Roots::eqf = ToRules::eqf = Solve::eqf = Reduce::eqf = System`Private`OldReduce::eqf = Eliminate::eqf = SolveAlways::eqf = AlgebraicRules::eqf = GroebnerBasis::eqf = PolynomialReduce::eqf = Internal`DistributedTermsList::eqf = "`1` is not a well-formed equation."
LUBackSubstitution::bpvt = "The pivot vector `1` is invalid."
LUBackSubstitution::singlu = "The LU decomposition matrix `1` is singular."
LUDecomposition::sq = "LUDecomposition accepts only square matrices."
MainSolve::ibool = Solve::ibool = Reduce::ibool = System`Private`OldReduce::ibool = AlgebraicRules::ibool = Eliminate::ibool = SolveAlways::ibool = "Value of option InverseFunctions -> `1` should be True, False, or Automatic."
MainSolve::method = Solve::method = Reduce::method = System`Private`OldReduce::method = AlgebraicRules::method = Eliminate::method = SolveAlways::method = "Value of option Method -> `1` should be 1, 2, or 3."
MainSolve::mode = Solve::mode = Reduce::mode = System`Private`OldReduce::mode = AlgebraicRules::mode = Eliminate::mode = SolveAlways::mode = "Value of option Mode -> `1` should be Generic, Modular, or Rational."
MainSolve::verif = Solve::verif = Reduce::verif = System`Private`OldReduce::verif = AlgebraicRules::verif = Eliminate::verif = "Potential solution `1` (possibly discarded by verifier) should be checked by hand. May require use of limits."
MapThread::mptc = "Incompatible dimensions of objects at positions {2, `1`} and {2, `2`} of `3`; dimensions are `4` and `5`."
MapThread::mptd = "Object `1` at position {2, `2`} in `3` has only `4` of required `5` dimensions."
MathieuCharacteristicA::nnord = MathieuCharacteristicB::nnord = "The order `1` is not non-negative."
MathieuCharacteristicB::zord = "There is no zero-th order MathieuCharacteristicB."
MathMLForm::boxfmt = "The default typesetting format used by MathMLForm is set in Internal`1`$DefaultMathMLBoxFormat. The current value `2` is not valid; it must be a member of $BoxForms. MathMLForm will resort to TraditionalForm."
MatrixPower::zvec = MatrixExp::zvec = "Cannot compute `1` because the argument matrix `2` has a zero eigenvector."
Algebra`MatrixPowerMod::arg1 = "The first argument `1` of MatrixPowerMod is not a square matrix with integer coefficients."
Algebra`MatrixPowerMod::arg2 = "The second argument `1` of MatrixPowerMod is not an integer."
Algebra`MatrixPowerMod::arg3 = "The third argument `1` of MatrixPowerMod is not a nonzero integer."
Experimental`Maximize::deprec = "Experimental`Maximize will not be supported in future versions of Mathematica. Use System`Maximize instead."
Maximize::consc = Minimize::consc = Experimental`Infimum::consc = Experimental`Supremum::consc = "The constraint `1` contains a nonreal constant `2`."
Maximize::consf = Minimize::consf = Experimental`Infimum::consf = Experimental`Supremum::consf = "Invalid constraint `1` encountered. Constraints should be equations, inequalities or variable domain specifications."
Maximize::consv = Minimize::consv = Experimental`Infimum::consv = Experimental`Supremum::consv = "The constraint `1` contains a nonconstant expression `2` independent of variables `3`."
Maximize::mixdom = Minimize::mixdom = Experimental`Infimum::mixdom = Experimental`Supremum::mixdom = "Exact optimization with mixed real and integer variables is not yet implemented."
Maximize::noobj = Minimize::noobj = Experimental`Infimum::noobj = Experimental`Supremum::noobj = "No objective function specified."
Maximize::nopmet = Minimize::nopmet = Experimental`Infimum::nopmet = Experimental`Supremum::nopmet = "This optimization problem cannot be solved with methods available to `1`."
Maximize::natt = "The maximum is not attained at any point satisfying the given constraints. "
Maximize::objc = Minimize::objc = Experimental`Infimum::objc = Experimental`Supremum::objc = "The objective function `1` contains a nonreal constant `2`."
Maximize::objv = Minimize::objv = Experimental`Infimum::objv = Experimental`Supremum::objv = "The objective function `1` contains a nonconstant expression `2` independent of variables `3`."
Maximize::vdom = Minimize::vdom = Experimental`Infimum::vdom = Experimental`Supremum::vdom = "Variable domain `1` should be either Reals or Integers."
Maximize::vlist = Minimize::vlist = Experimental`Infimum::vlist = Experimental`Supremum::vlist = FindInstance::vlist = "The variable list `1` should be nonempty."
Maximize::wksol = "Warning: There is no maximum in the region described by the contraints; returning a result on the boundary."
MeijerG::hdiv = "`1` does not exist. Arguments are not consistent."
MeijerG::rarg = "MeijerG is used with abstract optional parameter. `1` is not defined for every complex value of optional parameter."
MeshStyle::mesh = "`1` is not a valid MeshStyle specification; using the default."
Message::msgl = "$MessageList `1` not a list; reset to {}."
Message::name = "Message name `1` is not of the form symbol::name or symbol::name::language."
MessageName::messg = "`1` cannot be set to `2`. It must be set to a string."
Experimental`Minimize::deprec = "Experimental`Minimize will not be supported in future versions of Mathematica. Use System`Minimize instead."
Minimize::wksol = "Warning: There is no minimum in the region described by the contraints; returning a result on the boundary."
Minimize::natt = "The minimum is not attained at any point satisfying the given constraints."
Mod::divz = Quotient::divz = "Second argument in `1` should be non-zero."
N::arg = "Argument `1` is not of the form {precision, accuracy}."
NDSolve::acoeffs = "Unable to automatically determine the coefficients of the method `1`. Try specifying the coefficients as an option."
NDSolve::sprkdm = "The dimension `1` of the differential system in the method `2` is not even."
NDSolve::sprkqv = "The value of PositionsVariables->`1` of the method `2` is not a valid list of position variables."
NDSolve::sprkpqv = "The position variables `1` and momentum variables `2` of the method `3` are not consistent with the variables `4` of the differential system."
NDSolve::spltdep = "The differential system `1` in the method `2` depends on `3` which is ambiguous. The differential system should be in autonomous form."
NDSolve::spltdim = "The dimensions `1` of the equations in the method `2` are not compatible with the dimensions `3` of the differential system."
NDSolve::msols = "Multiple solutions found using DSolve in the method `1`."
NDSolve::ndsol = "No solution found using DSolve in the method `1`."
NDSolve::ndsnf = "Unable to create a NumericalFunction for the expression `1` in the method `2`."
NDSolve::ndspe = "Unable to process the equations `1` in the method `2`."
NDSolve::nlst = "`1` in the method `2` is not a list of length `3`."
NDSolve::nfun = "`1` of the method `2` is not a function."
NDSolve::sfun = "Invalid simplification function `1` in the method `2`."
NDSolve::csymb = "Value of option `1`->`2` of the method `3` is not a symbol."
NDSolve::bcart = "Warning: An insufficient number of boundary conditions have been specified for the direction of independent variable `1`. Artificial boundary effects may be present in the solution."
NDSolve::bcedge = "Boundary condition `1` is not specified on a single edge of the boundary of the computational domain."
NDSolve::bcnan = "Boundary conditions not numerical."
NDSolve::bcnorm = "Boundary condition `1` includes non-normal derivatives."
NDSolve::bdord = "Boundary condition `1` should have derivatives of order lower than the differential order of the partial differential equation."
NDSolve::bcsol = "Could not solve for equations at boundary points from the boundary conditions."
NDSolve::bcuns = "Boundary condition `1` cannot be satisfied in general."
NDSolve::bddo = "Value of option DifferenceOrder->`1` should be a positive integer or \"Pseudospectral\"."
NDSolve::bdmtd = "The value of the option Method->`1` is not a known built-in method, a symbol which could be a user-defined method, or a list with a name followed by method options."
NDSolve::nostep = " The method specified by Method -> `1` is not a known built-in method and has not been properly set up as a user-defined method with a Step function."
NDSolve::baddo = "The method `1` returned `2` for dense output data, which is not in the correct form."
NDSolve::bdstep = "The Step function for the Method -> `1` returned `2` which is not an acceptable form."
NDSolve::bvals = "Each boundary value equation must be given at one point only."
NDSolve::bvlin = "The differential equation(s) and/or boundary conditions are not linear in the dependent variables. NDSolve requires linearity to compute the solution of a multipoint boundary value problem."
NDSolve::bvluc = "The equations derived from the boundary conditions are numerically ill-conditioned. The boundary conditions may not be sufficient to uniquely define a solution. The computed solution may match the boundary conditions poorly."
NDSolve::bvls = "Unable to resolve the conditions derived from the given boundary conditions. It is possible there is no solution for the given boundary value problem."
NDSolve::bvlind = "Boundary conditions are not linearly independent."
NDSolve::bvaux = "Unable to solve auxiliary system for boundary condition at `1` == `2`"
NDSolve::bvep = "Value of option `1`->`2` should be a nonnegative real number."
NDSolve::bvcrat = "Value of option `1`->`2` should be a nonzero real number."
NDSolve::bvdae = "Differential-algebraic equations must be given as initial value problems."
NDSolve::cprec = "The precision `1` of the coefficients of the method `2` is not consistent with the working precision `3`."
NDSolve::cconst = "The coefficients `1` of `2` do not give a consistent method."
NDSolve::cdims = "The dimensions of the options `1`, `2` and `3` of the method `4` are not compatible."
NDSolve::cstruct = "The coefficients `1` of `2` do not have the correct structure."
NDSolve::submtd = "`1` is not a valid submethod."
DSolve::conarg = NDSolve::conarg = RSolve::conarg = "The arguments should be ordered consistently."
DSolve::dvnoarg = NDSolve::dvnoarg = RSolve::dvnoarg = "The function `1` appears with no arguments."
DSolve::ivhead = NDSolve::ivhead = RSolve::ivhead = "The independent variable `1` appears in the head of the expression `2`. The independent variables should always be arguments."
DSolve::dvleaf = NDSolve::dvleaf = RSolve::dvleaf = "The function `1` appears as the head of the expression `2`."
DSolve::der1 = NDSolve::der1 = "The derivative operator `1` in `2` should operate on only one function."
DSolve::derlen = NDSolve::derlen = "The length of the derivative operator `1` in `2` is not the same as the number of arguments."
DSolve::derarg = NDSolve::derarg = "The derivative operator `1` in `2` should act on the pure function."
DSolve::nestdv = NDSolve::nestdv = RSolve::nestdv = "The expression `1` has nested dependent variables."
DSolve::dvlen = NDSolve::dvlen = RSolve::dvlen = "The function `1` does not have the same number of arguments as independent variables (`2`)."
NDSolve::depvr = "The dependent variable cannot be found in the equation."
NDSolve::nodv = "No dependent variables were found in the equations.  Make sure that your functions appear with the independent variables in the arguments, as in x[t].  You may want to specify them explicitly using the DependentVariables option."
NDSolve::noout = "No functions were specified for output from NDSolve."
NDSolve::dvout = "The output function `1` is not one of the dependent variables, `2`."
NDSolve::uniss = "The spacing specified by MinStepSize->`1` and MaxStepSize->`2` for independent variable `3` cannot be used to construct a uniform grid on an interval of length `4`.  Using spacing `5` instead."
NDSolve::eerr = "Warning: Scaled local spatial error estimate of `1` at `2` = `3` in the direction of independent variable `4` is much greater than prescribed error tolerance. Grid spacing with `5` points may be too large to achieve the desired accuracy or precision.  A singularity may have formed or you may want to specify a smaller grid spacing using the MaxStepSize or MinPoints options."
NDSolve::eerri = "Warning: Estimated initial error on the specified spatial grid in the direction of independent variable `1` exceeds prescribed error tolerance."
NDSolve::ibcinc = "Warning: Boundary and initial conditions are inconsistent."
NDSolve::vdobj = "Encountered `1` which is not a valid `2` expression."
NDSolve::ininv = "Unable to ascertain the initial data for the invariants in the method `1`."
NDSolve::ivone = "Boundary values may only be specified for one independent variable. Initial values may only be specified at one value of the other independent variable."
NDSolve::maxit = "Maximum number of iterations `1` reached at `2` = `3`."
NDSolve::mmpts = "Number of steps for independent variable `1` required by MaxStepSize->`2` or MinPoints->`3` is greater than the number of steps allowed by MinStepSize->`4` and/or MaxPoints->`5`."
NDSolve::dored = "The maximum number of spatial points (`1`) for independent variable `2` allowed by MaxPoints->`3` or MinStepSize->`4` is to few for DifferenceOrder->`5`.  Spatial difference order for `2` will be reduced to `6`."
NDSolve::nerres = "The maximum number of spatial points (`1`) for independent variable `2` allowed by MaxPoints->`3` or MinStepSize->`4` is too few to compute a spatial error estimate."
NDSolve::eveerr = "The specified spatial grid in the direction of independent variable `1` has an even number of points (`2`) and the pseudospectral grid cannot be subdivided in two, so no spatial error estimate will be done on the final result in this direction."
NDSolve::stpmin = "The starting number of points determined by StartingStepSize->`3` and StartingPoints->`4` is `1` which is less than the minimum number of `2` grid points.  `2` will be used instead."
NDSolve::stpmax = "The starting number of points determined by StartingStepSize->`3` and StartingPoints->`4` is `1` which is greater than the maximum number of `2` grid points.  `2` will be used instead."
NDSolve::stps = "Only one of StartingPoints and StartingStepSize should be specified at a time.  StartingPoints->`1` will be used and StartingStepSize->`2` will be disregarded."
NDSolve::maxits = "The number of iterations `1` in the method `2` is not Automatic, a positive machine integer or Infinity."
NDSolve::maxsts = "The option `1`->`2` in the method `3` is not a positive machine integer or Infinity."
NDSolve::moptxn = "The option `1` of the method `2` is not one of `3`."
NDSolve::mrsti = "Number of steps `1` required by `2`->`3` should be a machine sized integer."
NDSolve::msti = "Number of steps `1` required by MaxStepSize->`2` for independent variable `3` should be a machine sized integer."
NDSolve::mxsst = "Using maximum number of grid points `1` allowed by the MaxPoints or MinStepSize options for independent variable `2`."
NDSolve::mxst = "Maximum number of `1` steps reached at the point `2` == `3`."
NDSolve::ncsm = "The number of coefficients `1` is not the same as the number of submethods `2` in the method `3`."
NDSolve::ndcf = "Repeated convergence test failure at `1` == `2`; unable to continue."
NDSolve::lsf = "Unable to solve required system of linear equations to `1` == `2`."
NDSolve::nderr = "Error test failure at `1` == `2`; unable to continue."
NDSolve::ndinnt = "Initial condition `1` is not a number or a rectangular array of numbers."
NDSolve::ndincd = NDSolve`Reinitialize::ndincd = "Initial conditions for derivatives of the function `1` do not have consistent dimensions."
NDSolve::ndincb = "Initial conditions are not of consistent dimensionality."
NDSolve::opdims = "The value of `1`->`2` of the method `3` is not a pair of positive integers {n, m} with n >= m and n*m equal to `4`."
NDSolve::opmdims = "The dimensions `1` of the matrix function in the method `2` are not compatible with the specified dimensions `4`."
NDSolve`Reinitialize::ndincb = "The new initial conditions need to have the same dimensions as the original ones."
NDSolve::ndlim = "Range specification `1` is not of the form {x, xend} or {x, xmin, xmax}."
NDSolve::ndmss = "Value of option `1` -> `2` is not a positive real number or Infinity."
NDSolve::ndnco = NDSolve`Reinitialize::ndnco = "The number of constraints (`1`) (initial conditions) is not equal to the total differential order of the system (`2`)."
NDSolve::ndncov = NDSolve`Reinitialize::ndncov = "The number of constraints (initial conditions) for function `1` is insufficient for its differential order (`2`)."
NDSolve::ndnl = "Endpoint `1` in `2` is not a real number."
NDSolve::ndnum = "Encountered non-numerical value for a derivative at `1` == `2`."
NDSolve::ndfdmc = "Computed derivatives do not have dimensionality consistent with the initial conditions."
NDSolve::ndode = "Input is not an ordinary differential equation."
NDSolve::ndrsd = "Step size was not decreased after a rejected step at `1` == `2`."
NDSolve::ndsnorm = "Value of option NormFunction -> `1` is not Automatic or a function which gives a legitmate norm."
NDSolve::ndsnr = "Step size was not real at `1` == `2`."
NDSolve::ndssc = "Step size changed sign at `1` == `2`."
NDSolve::ndsss = "Value of option StartingStepSize -> `1` is not a Positive real number or Automatic."
NDSolve::ndstab = "Stability check failed at `1` == `2`."
NDSolve::ndstf = "At `1` == `2`, system appears to be stiff. Methods Automatic, BDF or StiffnessSwitching may be more appropriate."
NDSolve::ndsv = NDSolve`Reinitialize::ndsv = "Cannot find starting value for the variable `1`."
NDSolve::ndsz = "At `1` == `2`, step size is effectively zero; singularity or stiff system suspected."
NDSolve::ndtol = "Tolerances requested by the AccuracyGoal and PrecisionGoal options could not be achieved at `1` == `2`."
NDSolve::ndtola = "A component of the solution at `1` == `2` is essentially zero and the tolerance specified by the AccuracyGoal option could not be achieved."
NDSolve`ProcessSolutions::nodata = "No solution data was computed between `1` == `2` and `1` == `3`."
NDSolve::ivcon = NDSolve`Reinitialize::ivcon = "The given initial conditions were not consistent with the differential-algebraic equations.  NDSolve will attempt to correct the values."
NDSolve::ivdae = "For differential-algebraic equations, initial conditions need to be given for either all of the non-algebraic variables or their derivatives."
NDSolve::ivres = "NDSolve has computed initial values which give a zero residual for the differential-algebraic system, but some components are different from those specified.  If you need those to be satisfied, it is recommended that you give initial conditions for all dependent variables and derivatives of them."
NDSolve::ntdv = "Cannot solve to find an explicit formula for the derivatives.  Consider using the option setting SolveDelayed->True."
NDSolve::ntcs = "Cannot solve constraint equations for initial conditions."
NDSolve::icord = NDSolve`Reinitialize::icord = "The differential order of the functions in the initial or boundary conditions should be strictly less than in the differential equations."
NDSolve::icorddae = NDSolve`Reinitialize::icorddae = "For a system treated as a differential algebraic equation, the differential order of the functions in the initial conditions should be equal or less than in the equations."
NDSolve::mdata = "An invalid `1` method data object was encountered at the point `2` == `3`."
NDSolve::pdeopt = "If the option `1` to NDSolve is a list, it must have length 2."
NDSolve::pdnbc = "Mixed periodic and Dirichlet/Neumann boundary conditions not allowed."
NDSolve::tponly = "Currently the only discretization method implemented is SpatialDiscretization->TensorProductGrid."
NDSolve::norm = "Invalid norm `1` in the method `2`."
NDSolve::rclist = "The value of the option `1`->`2` should be Automatic or a list of the coordinate lists for each spatial dimension."
NDSolve::coend = "The endpoints of the grid coordinates `1` do not match those specified in `2`."
NDSolve::coexp = "Because the coordinates were explicitly given for the direction of independent variable `1`, the values of options `2` will be disregarded for this direction."
NDSolve::ssrei = "The value of the option `1`->`2` should be a positive real number, Infinity, or Automatic."
NDSolve::ssre = "The value of the option `1`->`2` should be a positive real number or Automatic."
NDSolve::sfty = "The option `1`->`2` of the method `3` is not a real number x such that 0 < x <= 1."
NDSolve::stopt = "The integration was not completed because the StoppingTest evaluated to neither True nor False at `1` == `2`."
NDSolve::ndsstm = "`1` is not a `2` method in the method `3`."
NDSolve::ndsml = "The value of the option `1`->`2` should be a list of `3` methods in the method `4`."
NDSolve::mtdp = "`1` does not have a correctly defined property `2` in `3`."
Needs::nocont = "Context `1` was not created when Needs was evaluated."
NDSolve::aord = "The selection of the order for the method `1` failed."
NDSolve::sss = "Unable to determine a starting step size for the method `1`."
NDSolve::mconly = "For the method `1`, only machine real code is available. Unable to continue with complex values or beyond floating point exceptions."
NDSolve::nolib = "The library for the method `1` is missing so NDSolve is unable to compute the solution."
NDSolve::nodae = "The method `1` is not currently implemented to solve differential-algebraic equations.  Use Method->Automatic instead."
NDSolve::icfail = "Unable to find initial conditions which satisfy the residual function within specified tolerances.  Try giving initial conditions for both values and derivatives of the functions."
FindMinimum::initf = FindMaximum::initf = FindFit::initf = NDSolve::initf = "The initialization of the method `1` failed."
NDSolve::lsopt = "The option `1`->`2` should either be a single value or a list of length equal to the number of spatial independent variables, `3`."
NDSolve::molpde = "The option Method->MethodOfLines is only legitimate for partial differential equations with more than one independent variable."
NDSolve::chbvp = "The option Method->Chasing is only legitimate for boundary value problems with values specified at two or more distinct points."
NDSolve::jpde = "For PDE's, the Jacobian will be computed using finite differences unless you have chosen the MethodOfLines option ExpandEquationsSymbolically->True."
NDSolve::tvar = "Value of option `1`->`2` is not one of the independent variables, `3`."
NDSolve::tvic = "`1` cannot be used as the temporal independent variable because the conditions, `2`, for that dimension do not constitute sufficient initial conditions given at only one value of `1`."
NDSolve::ponly = "The method given in Method->`1` is only for equation processing and is not a time-stepping method."
NDSolve::mdo = "The value of \"MaxDifferenceOrder\"->`1` should be an integer from `2` through `3` for the method `4`."
NDSolve::eord = "The value of the option `1` -> `2` should give a positive machine integer greater than 1 for the method `3`."
NDSolve::mord = "Unable to ascertain the order of the method `1`."
NDSolve::imps = "The value of the option ImplicitSolver->`1` should be FixedPoint or Newton."
NDSolve::impsg = "The value of the option ImplicitSolver->`1` should be FixedPoint, Newton, or GMRES."
NDSolve::impsgm = "ImplicitSolver->GMRES may only be used with the BDF methods with VariableStepCoefficients->True."
NDSolve::impsitsf = "Unable to satisfy the ImplicitSolver tolerance for IterationSafetyFactor at `1` = `2`."
NDSolve::impsagpg = "Unable to satisfy the ImplicitSolver tolerances for AccuracyGoal and PrecisionGoal at `1` = `2`."
NDSolve::bw = "The value of the option `1`->`2` should be a positive integer or a list of two positive integers giving upper and lower band widths."
NDSolve::otype = "The value of the option `1`->`2` should be ModifiedGramSchmidt or ClassicalGramSchmidt."
NDSolve::scpar = "The value of the option `1`->`2` of the method `3` should be Automatic or a pair of real numbers 0 <= {a, b} <= 1."
NDSolve::subsp = "The value of the option `1`->`2` should be a positive integer or Automatic."
NDSolve::ssrb = "The value of the option `1`->`2` of the method `3` should be a pair of real numbers {0, 1} <= {a, b} <= {1, Infinity}."
NDSolve::rbnd = "The value of the option `1`->`2` of the method `3` should be a real number x such that `4` <= x <= `5`."
NDSolve::irkcargs = "The argument `1` in ImplicitRungeKuttaCoefficients is not `2`."
NDSolve::irkcopts = "The option `1` in ImplicitRungeKuttaCoefficients is not `2`."
NDSolve::irkcploss = "Only obtained precision `1` of requested precision `2`. Try increasing $MaxExtraPrecision"
NDSolve`Iterate::sivpd = "The first argument `1` to `2` should be a symbol assigned to a value which is a valid `3` object."
NDSolve::evnone = "No events were specified for the EventLocator method."
NDSolve::evnf = "The event number `1` was not found between `2` = `3` and `2` = `4`."
NDSolve::evdir = "The value of the option Direction -> `1` for the EventLocator method should be All, 1, or -1, or a list consisting of these values with length equal to the number of events (`2`)."
NDSolve::evact = "The value of the option `1` for the EventLocator method is a list with length different from the number of events (`2`) so it will be treated as a single action to take for all specified events."
NDSolve::evre = "The value of the event function at `1` = `2` was not a real number.  The event will be ignored in steps where it does not evaluate to real numbers at both ends."
NDSolve::evboo = "The value of the event function at `1` = `2` was not True or False.  When not True, the value will be considered as False."
NDSolve::evfrf = "The event function did not evaluate to a real number somewhere between `1` = `2` and `1` = `3`, preventing FindRoot from finding the root accurately."
NDSolve::evcvmit = "Event location failed to converge to the requested accuracy or precision within `4` iterations between `1` = `2` and `1` = `3`."
NDSolve::evlm = "The value of the option EventLocationMethod -> `1` is not Brent, LinearInterpolation, StepBegin or StepEnd."
NDSolve::evsa = "The value of the option SolutionApproximation -> `1` is not Automatic or CubicHermiteInterpolation."
NDSolve::exseq = "The value of the option `1` -> `2` for the method `3` should be either Automatic, a strictly increasing list of at least `4` positive machine integers or a function which generates such a list."
NDSolve::exmaxo = "The value of the option `1` -> `2` for the method `3` should be Automatic, Infinity, or an integer greater than or equal to `4`."
NDSolve::exmino = "The value of the option `1` -> `2` for the method `3` should be Automatic or an integer greater than or equal to `4`."
NDSolve::exsord = "The value of the option `1` -> `2` of the method `3` should be a positive integer strictly between `4` and `5`."
NDSolve::exordf = NDSolve::sssf = "The value of the option `1` -> `2` for the method `3` should be a list of `4` real numbers between 0 and 1."
NDSolve`FiniteDifferenceDerivative::deriv = "`1` should be a Derivative operator with non-negative integer order(s)."
NDSolve`FiniteDifferenceDerivative::ldim = "`1` should be a list with an element for each of the `2` dimensions."
NDSolve`FiniteDifferenceDerivative::grid = "The grid `1` given for dimension `2` is not an increasing list of distinct real coordinates."
NDSolve`FiniteDifferenceDerivative::aord = "The approximation order `1` given for dimension `2` should be a positive machine-sized integer or `3`."
NDSolve`FiniteDifferenceDerivative::per = "The specification of periodicity `1` given for dimension `2` should be either True or False."
NDSolve`FiniteDifferenceDerivative::spu = "The coordinates `1` for dimension `2` are not uniformly spaced. Periodic pseudospectral derivatives are computed on a uniform grid."
NDSolve`FiniteDifferenceDerivative::spc = "The coordinates `1` for dimension `2` do not have spacing proportional to the Chebyshev points -Cos[Range[0,`3`] Pi/`3`]. Nonperiodic pseudospectral derivatives are only computed for this spacing."
NDSolve`FiniteDifferenceDerivative::conw = "There are insufficient points in dimension `1` to generate consistent finite different weights."
NDSolve`FiniteDifferenceDerivative::ordred = "There are insufficient points in dimension `1` to achieve the requested approximation order. Order will be reduced to `2`."
NDSolve`FiniteDifferenceDerivativeFunction::ddim = "Data `1` is not a rectangular tensor with dimensions `2`."
NDSolve`FiniteDifferenceDerivativeFunction::spnum = "Data `1` is exact or symbolic. Spectral weight computation requires data with approximate numbers."
NestWhile::nwargs = NestWhileList::nwargs = "Argument `1` in `2` is not of the form n, {m, n}, {n, Infinity}, or All, where m and n are non-negative machine-size integers."
NestWhile::nres = NestWhileList::nres = "Insufficient results generated to return the `1` term in `2`."
NIntegrate::bdmtd = "The method specified by the Method option should be one of Automatic, GaussKronrod, DoubleExponential, Trapezoidal, Oscillatory, MonteCarlo, QuasiMonteCarlo, EvenOddSubdivision, or SymbolicPiecewiseSubdivision. Only methods EvenOddSubdivision and SymbolicPiecewiseSubdivision can be specified with submethods in the nested form Method->{method, Method->submethod}."
NIntegrate::comp = "For Method->Oscillatory, the integrand can only contain one term of the general form: f[x] w[x], where w is one of the following functions: Sin, Cos, BesselJ, or BesselY. Try using Expand on your function and apply NIntegrate[.., Method->Oscillatory] to each part."
NIntegrate::eonst = "EvenOddSubdivision cannot be its own submethod."
NIntegrate::ierr = "The argument in the oscillatory function must be of the form a + b x^n, where a and b are constants."
NIntegrate::inovf = "Overflow resulted when attempting to evaluate the integrand at `1` = `2`."
NIntegrate::inum = "Integrand `1` is not numerical at `2` = `3`."
NIntegrate::lzero = "Method->Oscillatory does not support negative, complex, or variable indices for BesselY and BesselJ."
NIntegrate::minmax = "MinRecursion (`1`) is greater than MaxRecursion (`2`)."
NIntegrate::mccnv = "The integral failed to converge after `1` iterations."
NIntegrate::nconv = "This oscillatory integral might not be convergent."
NIntegrate::ncvb = "NIntegrate failed to converge to prescribed accuracy after `1` recursive bisections in `2` near `3` = `4`."
NIntegrate::pwncvb = "NIntegrate failed to converge to prescribed accuracy after `1` recursive bisections."
NIntegrate::ncvi = "NIntegrate failed to converge to prescribed accuracy after `1` iterated refinements in `2` in the interval `3`."
NIntegrate::pwncvi = "NIntegrate failed to converge to prescribed accuracy after `1` iterated refinements."
NIntegrate::ncvs = "NIntegrate failed to converge near the apparently non-integrable singularity at `1` = `2`."
NIntegrate::ninf = "Invalid use of Infinity in integration limits `1`."
NIntegrate::nintp = "Encountered the non-number `1` at `2` = `3`."
NIntegrate::nlim = "`1` = `2` is not a valid limit of integration."
NIntegrate::noeval = "For oscillating integrals, individual points where evaluation takes place is not supported; the range has to be in the form {x, xmin, xmax}."
NIntegrate::oidiv = "The odd integrand `1` is being considered as zero over the specified region, but may actually be divergent."
NIntegrate::oscfm = "With Method->Oscillatory, the integrand should be a product of an oscillatory function w[x] and another function f[x] , as NIntegrate[ w[x] f[x],{x,a,Infinity}, Method->Oscillatory]. The function w should be Sin, Cos, BesselJ, or BesselY, and f[x] should be of the form a + b x^n for constant a and b."
NIntegrate::oscint = "This integral does not contain any of the oscillating functions Cos, Sin, BesselJ, or BesselY. Please use some other method of NIntegrate instead."
NIntegrate::osran = "Method->Oscillatory works only for one-dimensional integrals. The integration continues with the MultiDimensional method."
NIntegrate::osrn = "For oscillating integrals, the range has to contain one Infinity (or -Infinity) and be of non-zero length. The integration continues with the Gauss-Kronrod method."
NIntegrate::ploss = "Numerical integration stopping due to loss of precision. Achieved neither the requested PrecisionGoal nor AccuracyGoal; suspect one of the following: highly oscillatory integrand or the true value of the integral is 0. If your integrand is oscillatory on a (semi-)infinite interval try using the option Method->Oscillatory in NIntegrate."
NIntegrate::rnderr = "Numerical approximation has caused `1` to take the value `2` where the integrand is singular."
NIntegrate::singd = "NIntegrate's singularity handling has failed at point `1`=`2` for the specified precision goal. Try using larger values for any of $MaxExtraPrecision or the options WorkingPrecision, or SingularityDepth and MaxRecursion."
NIntegrate::slwcon = "Numerical integration converging too slowly; suspect one of the following: singularity, value of the integration being 0, oscillatory integrand, or insufficient WorkingPrecision. If your integrand is oscillatory try using the option Method->Oscillatory in NIntegrate."
NIntegrate::spnst = "SymbolicPiecewiseSubdivision can be used only once in the Method option."
NIntegrate::tmap = "NIntegrate is unable to achieve the tolerances specified by the PrecisionGoal and AccuracyGoal options because the working precision is insufficient.  Try increasing the setting of the WorkingPrecision option."
NIntegrate::vars = "Integration range specification `1` is not of the form {x, xmin, ..., xmax}."
NMinimize::bcons = NMaximize::bcons = "The following constraints are not valid: `1`. Constraints should be equalities, inequalities, or domain specifications involving the variables." 
NMinimize::lvar = NMaximize::lvar = "Variables `1` should be a list of variables, with each element being a variable, or a list containing a variable and lower and upper bounds for the starting region for that variable." 
NMinimize::cnft = "The point `1` better satisfies the constraints, but evaluates to `2` which is larger than the final result." 
NMaximize::cnft = "The point `1` better satisfies the constraints, but evaluates to `2` which is smaller than the final result." 
NMinimize::parchange = NMaximize::parchange = "Inappropriate parameter: `1` -> `2`, changed to `3`." 
NMinimize::nosat = NMaximize::nosat = "Obtained solution does not satisfy the following constraints within Tolerance -> `2`: `1`." 
NMinimize::workprec = NMaximize::workprec = "Precision of the input is less than WorkingPrecision. Precision of the input will be used in computation."
NMinimize::belt = NMaximize::belt = "Invalid integer elements: `1`. Currently only variables may have a specified domain."
NMinimize::elmt = NMaximize::elmt = "Invalid variable domain. All variables must be either Integers or Reals (Reals by default.)"
NMinimize::incst = NMaximize::incst = "`1` was unable to generate any initial points satisfying the inequality constraints `2`. The initial region specified may not contain any feasible points. Changing the initial region or specifying explicit initial points may provide a better solution."
NMinimize::nsol = NMaximize::nsol = "There are no points that satisfy the constraints `1`." 
NMinimize::cvdiv = NMaximize::cvdiv = "Failed to converge to a solution.  The function may be unbounded."
NMinimize::cvmit = NMaximize::cvmit = "Failed to converge to the requested accuracy or precision within `1` iterations."
NMinimize::ubnd = NMaximize::ubnd = "The problem is unbounded."
NMinimize::maxit = NMaximize::maxit = "Value of option MaxIterations -> `1` should be a non-negative integer or Automatic."
NMinimize::ropn = NMaximize::ropn = "Value of option `1` -> `2` should be a non-negative real number."
NMinimize::roprl = NMaximize::roprl = "Value of option `1` -> `2` should be a real number x greater than `3` <= x."
NMinimize::roprlu = NMaximize::roprlu = "Value of option `1` -> `2` should be a real number between `3` and `4`."
NMinimize::bdmtd = NMaximize::bdmtd = "Value of option Method -> `1` is not Automatic, \"DifferentialEvolution\", \"NelderMead\", \"RandomSearch\", or \"SimulatedAnnealing\"."
Norm::symb = "Norm has received a matrix with symbolic element(s)."
Norm::nvm = "The first Norm argument should be a number, vector or matrix."
NDSolve`ScaledVectorNorm::vinp = "The ScaledVectorNorm argument `1` at position 1 is not a list of numbers."
Norm::winp = NDSolve`ScaledVectorNorm::winp = "The weight vector argument `1` is not a nonempty list of numbers."
Norm::ptype = "Norm type, `1`, in position 2 should be a symbol, Infinity, or a real number greater than or equal to 1."
Norm::vlen = NDSolve`ScaledVectorNorm::vlen = "The vector `1` and the weight vector `2` are of unequal lengths."
NDSolve::urange = NDSolve`ScaledVectorNorm::urange = "The scaling vector has a zero component, so the zero absolute tolerance leads to an unbounded value."
NDSolve`ScaledVectorNorm::pinp = "Argument `1` at position 1 in `2` should be a real number greater than or equal to 1 or a function to compute the norm of the scaled vector."
NDSolve`ScaledVectorNorm::sinp = "The scaling vector argument `1` is not a nonempty list of numbers."
NDSolve`ScaledVectorNorm::tinp = "Argument `1` should be a list of nonnegative real numbers, {rtol, atol}, giving relative and absolute tolerances with at least one strictly positive."
NDSolve`ScaledVectorNorm::nvec = "No vector specified."
NDSolve::nfnan = "The value of the option NormFunction->`1` applied to the current scaled error vector was `2` which is not a number."
NDSolve`ScaledVectorNorm::fnnan = "The norm function applied to the scaled vector gave `1` which is not a number."
NDSolve::nfp = "The value of the option NormFunction->`1` applied to the current scaled error vector was `2` which is not a nonnegative real number."
NDSolve`ScaledVectorNorm::nfp = "The norm function applied to the scaled vector gave `1` which is not a nonnegative real number."
NotElement::bset = "The second argument `1` of NotElement should be one of: Primes, Integers, Rationals, Algebraics, Reals, Complexes, or Booleans."
NProduct::emcon = NSum::emcon = "Euler-Maclaurin sum failed to converge to requested error tolerance."
NProduct::istep = "Cannot get from `1` to `2` in steps of `3`."
NProduct::itfn = "`1` does not have the correct form for an iterator."
NProduct::nplim = "Limit of product `1` is not a number."
NProduct::npnum = "Multiplicand `1` is not numerical at point `2` = `3`."
NProduct::npst = "Product step size `1` is zero or not a number."
NProduct::npz = "Some factors are one. The algorithms are not very applicable."
System`Private`NRoot::bdst = "Starting value `1` is not sufficiently close to the true root."
System`Private`NRoot::nnum = "Starting value `1` is not a number."
NRoots::nomod = "NRoots does not take a modulus option."
NRoots::nnumeq = "`1` is expected to be a polynomial equation in the variable `2` with numeric coefficients."
System`Private`NRRoot::bpa = "Precision `2` is too low to find real roots of `1`."
System`Private`NRRoot::bfac = "Warning: Using factorization `1` = `2` * `3` which may not be correct. The difference is `4`."
NSolve::sfail = "Subsystem could not be solved for `1` at value `2`. The likely cause is failure to detect zero due to low precision. The likely effect is the loss of one or more solutions. Increasing WorkingPrecision might prevent some solutions from being lost."
NSolve::zerosol = "Scale of possible solution value `1` for variable `2` is too small. Must set this value to zero in order to avoid generation of spurious solutions. This may cause the loss of some solutions."
NSolve::closesols = "Some solutions in variables `1` are close together. This may cause solution components in other variables to suffer from loss of precision. Use of increased WorkingPrecision may resolve this."
NSolve::illcnd = "Possible ill conditioning detected in system. Likely cause is exact or approximate multiplicity. This may cause solutions to suffer from loss of precision. Use of sufficiently large WorkingPrecision may resolve this."
NSolve::nsolprec = "Cannot obtain small residual. Use of sufficiently large WorkingPrecision may resolve this."
NSolve::infsolns = "Infinite solution set has dimension at least `1`. Returning intersection of solutions with `2` == 1."
NSum::istep = "Cannot get from `1` to `2` in steps of `3`."
NSum::itfn = "`1` does not have the correct form for an iterator."
NSum::nslim = "Limit of summation `1` is not a number."
NSum::nsnum = "Summand (or its derivative) `1` is not numerical at point `2` = `3`."
NSum::nsst = "Summation step size `1` is zero or not a number."
NSum::nsumz = "Some terms are zero. The algorithms are not very applicable."
NumberTheory`AlgebraicNumberFields`NumberFieldRegulator::nofu = "The number field given by `1` contains no units of infinite order."
NumberForm::sigz = "In addition to the number of digits requested, one or more zeros will appear as placeholders."
General::dvec = "The dependency cannot be found for individual components of vector arguments, so the dependency will be treated in block form."
General::mpwc = "`1` was unable to convert `2` to Piecewise, because the required number `3` of piecewise cases exceeds the internal limit $MaxPiecewiseCases = `4`."
General::nomthd = "There is no method `1` for `2` objects."
General::nnum = "The function value `3` is not a number at `2` = `1`."
General::nnum1 = "The function value `2` is not a number when the arguments are `1`."
General::nlnum = "The function value `3` is not a list of numbers with dimensions `4` at `2` = `1`."
General::nlnum1 = "The function value `2` is not a list of numbers with dimensions `3` when the arguments are `1`."
General::ngnum = "The gradient is not a vector of numbers at `2` = `1`."
General::ngnum1 = "The gradient is not a vector of numbers when the arguments are `1`."
General::njnum = "The Jacobian is not a matrix of numbers at `2` = `1`."
General::njnum1 = "The Jacobian is not a matrix of numbers when the arguments are `1`."
General::nhnum = "The Hessian is not a matrix of numbers at `2` = `1`."
General::nhnum1 = "The Hessian is not a matrix of numbers when the arguments are `1`."
General::nrnum = "The function value `3` is not a real number at `2` = `1`."
General::nrnum1 = "The function value `2` is not a real number when the arguments are `1`."
General::nrlnum = "The function value `3` is not a list of real numbers with dimensions `4` at `2` = `1`."
General::nrlnum1 = "The function value `2` is not a list of real numbers with dimensions `3` when the arguments are `1`."
General::nbnum = "The function value `3` is not True or False at `2` = `1`."
General::nbnum1 = "The function value `2` is not True or False when the arguments are `1`."
General::nrgnum = "The gradient is not a vector of real numbers at `2` = `1`."
General::nrgnum1 = "The gradient is not a vector of real numbers of length when the arguments are `1`."
General::nrjnum = "The Jacobian is not a matrix of real numbers at `2` = `1`."
General::nrjnum1 = "The Jacobian is not a matrix of real numbers when the arguments are `1`."
General::nrhnum = "The Hessian is not a matrix of real numbers at `2` = `1`."
General::nrhnum1 = "The Hessian is not a matrix of real numbers when the arguments are `1`."
General::preal = "The parameter `1` should be real valued."
General::symd = "Unable to automatically compute the symbolic derivative of `1` with respect to the arguments `2`. Numerical approximations to derivatives will be used instead."
General::symd1 = "Unable to automatically compute the symbolic derivative of `1`. Numerical approximations to derivatives will be used instead."
General::symdv = "Unable to automatically compute the symbolic derivative for a function of vector arguments. Numerical approximations to derivatives will be used instead."
General::symfd = "Unable to compute the symbolic second derivative when the first derivative is computed using numerical approximations.  Numerical approximations will be used instead."
General::spsder= "The sparsity pattern must be explicitly given for the supplied derivative value function, `1`."
General::sdsh = "The sparsity pattern `1` is inconsistent with the dimensions, `2`, of the derivative."
General::tma = "Too much accuracy requested at start of problem: try increasing the value of the WorkingPrecision option or decreasing the values of the AccuracyGoal and/or PrecisionGoal options."
General::vardep = "The variable `1` has dependencies on the other variables, `2`.  Try using variables which do not depend on each other."
General::vloc = "The variable `1` cannot be localized so that it can be assigned to numerical values."
General::vexdep = "The variable `1` has dependencies in the current session which causes it to evaluate to `2` which cannot be used as a variable."
Experimental`CreateNumericalFunction::largd = "Argument specification `1` in `2` is not of the form {name, dimensions}."
Experimental`CreateNumericalFunction::dlist = "Dimension list expected instead of `1` in `2`."
Experimental`CreateNumericalFunction::largs = "Argument specification `1` in `2` is not of the form {name, sample value}."
Experimental`CreateNumericalFunction::nosamp = "Sample argument expected in specification `1`."
Experimental`CreateNumericalFunction::srect = "Sample argument `1` in specification `2` is not a number or array of numbers."
Experimental`CreateNumericalFunction::scdims = "Sample arguments given in specification `1` do not have consistent dimensions."
Experimental`CreateNumericalFunction::pval = "Sample parameter value `1` in `2` is not a number."
Experimental`CreateNumericalFunction::pdim = "Dimensions `1` in `2` for the parameter are inconsistent with the requirement that the parameter be a scalar."
Experimental`CreateNumericalFunction::dimsl = "`1` in list `2` is not a specification for the dimensions of an argument."
Experimental`CreateNumericalFunction::ardims = "The result dimensions for `1` cannot be computed automatically unless the option SampleArgument->True and argument values are given in the second argument."
Experimental`CreateNumericalFunction::jg = "You cannot specify values for both the Gradient and Jacobian options."
Experimental`CreateNumericalFunction::neargs = "The first argument should be a nonempty list of argument specifications."
Experimental`CreateNumericalFunction::arglist = "The sample arguments `1` should be given as a list with elements corresponding to the variables `2`."
Experimental`CreateNumericalFunction::msym = "The value of the option `1` should be a symbol."
Experimental`CreateNumericalFunction::rdim = "The fourth argument `1` should be a list of positive machine integers containing the result dimensions."
General::excf = "The value `1` of the option ExcludedForms is not a list."
General::stmb = "The value `1` of the option OptimizationSymbol is not a symbol."
General::strf = "The value `1` of the option StructuralForms is not a list."
General::colvl = "The value `1` of the option CompileOptimizations is not 0, 1, 2, All, or None."
Experimental`OptimizeExpression::lvl = "The value `1` of the option OptimizationLevel is not 0, 1 or 2."
Gradient::smeth = Jacobian::smeth = Hessian::smeth = "The method `1` in `2` for computing the derivative is not a function which will be evaluated to give the derivative or one of the strings \"FiniteDifference\" or \"Symbolic\"."
Gradient::spopt = Jacobian::spopt = Hessian::spopt = "The option Sparse->`1` should be Automatic, True, False, or a SparseArray pattern object with corresponding nonzero elements."
Testing`Internal`MVectorNorm::mrange = "Either a vector element or a norm outside machine precision boundaries."
Testing`Internal`MVectorNorm::mvntestp = "Incorrect p type in MTensor_VectorNorm() test driver; must be integer or real."
Testing`Internal`MVectorNorm::mvntestv = "Incorrect vector type in MTensor_VectorNorm() test driver; must be real or complex."
Testing`Internal`MScaledVectorNorm::mrange = "Either a vector element or a norm outside machine precision boundaries."
Testing`Internal`MScaledVectorNorm::mvntestp = "Incorrect p type in MTensor_VectorNorm() test driver; must be integer or real."
Testing`Internal`MScaledVectorNorm::mvntestv = "Incorrect vector type in MTensor_VectorNorm() test driver; must be real or complex."
NumericQ::set = "Cannot set `1` to `2`; the lhs argument must be a symbol and the rhs must be True or False."
NumericQ::unset = "Cannot clear `1`; the argument must be a symbol."
On::none = "Message `1` not found."
Optional::opdef = "The default value for the optional argument `1` contains a pattern."
Options::opmix = "Cannot mix streams and non-streams in `1`."
Options::opsym = "Second argument in `1` should be a symbol or a list of symbols."
PadLeft::level = PadRight::level = "The padding specification `1` involves `2` levels; the list `3` has only `4` level."
PadLeft::margin = PadRight::margin = "The list of margins `1` given in `2` must be of the same length (`3`) as the list of padded dimensions `4`"
ParametricPlot::bend = Plot::bend = "MaxBend `1` is not greater than or equal to 0."
ParametricPlot::pldiv = Plot::pldiv = "Value of option PlotDivision -> `1` is not greater than or equal to 1."
ParametricPlot::plld = Play::plld = Plot::plld = Plot3D::plld = ContourPlot::plld = DensityPlot::plld = ParametricPlot3D::plld = "Endpoints for `1` in `2` must have distinct machine-precision numerical values."
ParametricPlot::pptr = "`1` does not evaluate to a pair of real numbers at `2` = `3`."
ParametricPlot::ppts = ParametricPlot3D::ppts = Plot::ppts = "Value of option PlotPoints -> `1` is not an integer >= 2."
ParametricPlot3D::glims = ContourPlot::glims = DensityPlot::glims = Plot3D::glims = "Range specifications `1` and `2` contain the same iteration variable."
ParametricPlot3D::ppfun = "Argument `1` is not a list with three or four elements."
ParametricPlot3D::pplr = "`1` is not a list starting with three real numbers at `2` = `3`."
ParametricPlot3D::ppta = "Value of option PlotPoints -> `1` is not Automatic, an integer >= 2, or a list of two of these values."
ParametricPlot3D::ppx = "Graphics3D object calculated in ParametricPlot3D is empty."
ParentForm::deflt = "The ParentForm of `1` is not defined on $BoxForms."
Partition::ohpdm = "`1`-dimensional overhang parameter cannot indicate position in `2`-dimensional block."
Partition::ohp = ListConvolve::ohp = ListCorrelate::ohp = "Overhang parameters in `1` must be nonzero machine-size integers, or lists of nonzero machine-size integers."
Partition::pdep = "Depth `1` requested in object with dimensions `2`."
Partition::pttl = "Partition arguments `2` and `3` must be the same length (since both are lists)."
Experimental`IntegerPartitions::big = "`1` asks for partitions whose sizes are too big to fit in memory. It is possible that there do not exist partitions of these sizes, but Mathematica does not know how to determine this without trying to find them, which it cannot do."
Experimental`IntegerPartitions::inf = "`1` has infinitely many solutions."
Experimental`IntegerPartitions::infbig = "`1` has either no solutions or infinitely many. Mathematica cannot determine which, because if there does exist a solution it has a size that does not fit in memory, so Mathematica cannot find it."
Experimental`IntegerPartitions::mem = "`1` has been left unevaluated because the result of evaluating it would not fit in memory."
Experimental`IntegerPartitions::nninfseq = "Position `1` of `2` must be All, Infinity, a nonnegative integer, or a List whose first element (required) is a nonnegative integer, second element (optional) is a nonnegative integer or Infinity, and third element (optional) is a nonzero integer."
Experimental`IntegerPartitions::numbers = "To evaluate `1`, since the user has not input a list of numbers, Mathematica constructs one. In doing so it ignores the count input by the user. In this case it found there were too many numbers to fit in memory. When the count is small enough all those numbers are not needed, but unfortunately the current algorithm doesn't know how to deal with this case."
Experimental`IntegerPartitions::rat = "Position `1` of `2` must be a rational number."
Experimental`IntegerPartitions::rseq = "Position `1` of `2` must be All, a rational number, or a list of rational numbers."
Pattern::nodef = "No default setting found for `1` in position `2` when length is `3`."
Pattern::patm = "Too many (`1`) optional arguments required in `2`."
Pattern::patsym = "First element in pattern `1` is not a symbol."
Pattern::patvar = "First element in pattern `1` is not a valid pattern name."
Pattern::patv = "Name `1` used for both fixed and variable length patterns."
PatternTest::ptest = "No patterns found in test `1`."
Pick::incomp = "Expressions `1` and `2` have incompatible shapes."
Piecewise::pairs = "The first argument `1` of Piecewise is not a list of pairs."
Play::pfnum = "Function `1` (after normalization) never evaluates to a machine-size real number."
Play::playr = ListPlay::playr = "Value of option PlayRange -> `1` is not a list of two machine-size real numbers."
Play::plx = "First argument `1` does not contain any functions to play."
Play::sample = "Sample length `1` is not a positive machine-size integer."
Play::sdep = ListPlay::sdep = "Value of option SampleDepth -> `1` should be a positive machine-size integer."
Play::srate = ListPlay::srate = "Value of option SampleRate -> `1` should be a positive machine-size real number."
SparseArray::dims = "The dimensions `1` in `2` are not a list of positive integers."
SparseArray::exdims = "The dimensions cannot be determined from the positions `1`."
SparseArray::drnk = "The requested dimensions, `1`, have length inconsistent with the tensor rank (`2`) of the input."
SparseArray::pind = "The indices in `1` are not all positive."
SparseArray::ilist = "The implicit value `1` in `2` cannot be a list."
SparseArray::rect = "Rectangular array or list of rules expected at position 1 in `1`."
SparseArray::rule = "`1` in `2` is not a replacement rule."
SparseArray::rule1 = "The rule `1` is not of the form indices->values."
SparseArray::ntb = "Cannot convert the sparse array `1` to an ordinary array because the `2` elements required exceeds the current size limit."
SparseArray::pos = "The left hand side of `1` in `2` is not a position or pattern which will match a position."
SparseArray::posr = "The left hand side of `1` in `2` is not a position or a pattern which will match the position of an element in an array of rank `3`."
SparseArray::valnl = "The value specified by the rule `1` should not be a List."
General::spmat = "`1` is not a sparse matrix."
General::sparv = "Valid SparseArray expected at position `2` in `1`."
General::spts = "Scalar, rectangular tensor, or valid SparseArray expected at position `2` in `1`."
General::ptlen = "Objects of unequal length in `1` cannot be combined."
Take::take = Part::take = Set::take = Internal`BagPart::take = Subsets::take = "Cannot take positions `1` through `2` in `3`."
Plot3D::gval = "Function value `1` at grid point xi = `2`, yi = `3` is not a real number."
Plot3D::plnc = "`1` is neither a machine-size real number at `2`=`3` nor a list of a real number and a valid color directive."
PlotRange::gtype = Show::gtype = "`1` is not a type of graphics."
PlotRange::prng = "Value of option PlotRange -> `1` is not All, Automatic, or an appropriate list of range specifications."
PlotRegion::plotr = "Value of option PlotRegion -> `1` is not two pairs of real numbers in the form {{xmin, xmax}, {ymin, ymax}}."
Algebra`PolynomialGCDModList::nogcd = "Cannot compute the GCD of `1` and `2` mod `3`."	
Algebra`PolynomialMakeMonicModList::nprimemod = "Modulus `1` is not prime."
PolynomialMod::coef = "Value of option CoefficientDomain -> `1` should be Integers or Rationals."
PolynomialMod::polyi = "`1` is not valid input for PolynomialMod."
PolynomialMod::polym = "Modulus `1` is not a positive integer."
Algebra`PolynomialMakeMonicModList::nprimemod = "Modulus `1` is not prime."
Algebra`PolynomialModList::badmod = "Modulus `1` is not a positive integer."
Algebra`PolynomialModList::divby0 = "Cannot divide a univariate polynomial by zero."	
Algebra`PolynomialModList::ninv = "Cannot invert `1` modulo `2`."	
Algebra`PolynomialModList::nsfmod = "The polynomial `1` is not squarefree modulo `2`."	
Algebra`PolynomialModList::unipoly = "The argument `1` is not an integer vector."
Algebra`PolynomialPthRootModList::noroot = "The `1`th root of `2` modulo `1` does not exist."	
Algebra`PolynomialQuotientModList::divby0 = "Cannot divide a univariate polynomial by zero."
PowerMod::badmod = "The modulus `1` has too large prime factors."
PowerMod::divz = "Third argument in `1` should be non-zero."
PowerMod::ninv = "`1` is not invertible modulo `2`."
PowerMod::pmod = "The base and modulus arguments in `1` must be Gaussian integers."
PowerMod::root = "The equation x^`1` = `2` (mod `3`) has no integer solutions."
PowerModList::arg1 = "The first argument `1` of PowerModList is not an integer."
PowerModList::arg2 = "The second argument `1` of PowerModList is not rational."
PowerModList::arg3 = "The third argument `1` of PowerModList is not a positive integer."
PowerModList::nargs = "PowerModList requires 3 arguments, `1` were given."
Prime::intpp = Internal`QuadraticFundamentalUnit::intpp = "Positive integer argument expected in `1`."
Prime::largp = PrimePi::largp = "Argument `1` in `2` is too large for this implementation."
PrimePi::nsfmm = "Insufficient memory to allocate required sieves."
Product::prodwarn = "Warning: `1` contains a capital pi; use \[EscapeKey]prod\[EscapeKey] to enter a product sign."
Product::div = "Product does not converge."
Protect::pssl = "`1` is not a string, symbol, or list of strings and symbols."
Internal`QuadraticFundamentalUnit::fund = "The argument `1` of QuadraticFundamentalUnit is not the fundamental discriminant of a real quadratic number field."
Quantile::nquan = "The Quantile specification `1` should be a number or a list of numbers between 0 and 1."
Quantile::parm = "The Quantile parameters `1` should be given as a 2x2 matrix of real numbers {{a,b},{c,d}} or as a pair of real plot point parameters {a,b}."
General::tol = "Value of option Tolerance -> `1` is not a non-negative real number or Automatic."
General::tol2 = "Value of option Tolerance -> `1` is not a positive real number or Automatic."
Random::randn = "Range specification `1` in `2` is not a valid number or pair of numbers."
Random::randt = "Type specification `1` in `2` should be Real, Integer, or Complex."
Range::range = "Range specification in `1` is not a machine-size integer."
Raster::rscd = RasterArray::rscd = "Color `1` is incompatible with the previous color."
Raster::rslim = "Third argument `1` to `2` is not a list of two distinct real numbers."
Raster::rsrec = RasterArray::rsrec = "Second argument `1` in `2` is not a list of two coordinates."
Raster::rsval = "Non-numerical value `1` found at position `2` in first argument of `3`."
RasterArray::rscol = "Expression `1` at position `2` in first argument of `3` is not a valid color or gray-level directive."
RasterArray::obs = "RasterArray is obsolete. Translating to Raster."
RasterGraphics::argx = "Graphics called with 0 arguments; 1 argument is expected."
RasterGraphics::rrng = "Value of option `1` is not All, Automatic, or an appropriate range specification."
RasterGraphics::optx ="Unknown option `1` in `2`."
RasterGraphics::nonopt = "Options expected (instead of `2`) beyond position 1 in `1`. An option must be a rule or a list of rules."
RasterGraphics::gmat="`1` is not a rectangular array larger than 2 x 2."
RasterGraphics::zval = "Non-numerical value `1` found at position `2` in first argument."
Read::readf = ReadList::readf = Skip::readf = "`1` is not a valid format specification."
Read::readn = ReadList::readn = Skip::readn = "Syntax error reading a real number from `1`."
Read::readt = ReadList::readt = Skip::readt = "Syntax error reading `1` from `2`."
Read::readx = ReadList::readx = Skip::readx = "`1` reads no entries."
RealDigits::digs = "Unable to determine the number of terms in the list of digits."
RealDigits::period = "`1` has a period of `2` digits in base `3`. Use RealDigits[x, b, n] to request n digits."
RealDigits::ndig = "The number of digits to return cannot be determined."
RealDigits::rbase = MantissaExponent::rbase = "Base `1` is not a real number greater than 1."
RealDigits::realx = MantissaExponent::realx = "The value `1` is not a real number."
Reduce::bddom = "Value `1` of the domain argument should be Complexes, Reals, Algebraics, Rationals, Integers, Primes, or Automatic."
Rescale::nargs = "If the first argument is not a list or a SparseArray, two or three arguments are expected."
Rescale::rtwo = "The argument `1` at position `2` is expected to be a list of a lower bound and an upper bound."
Resolve::bddom = FindInstance::bddom = "Value `1` of the domain argument should be Complexes, Reals, Algebraics, Rationals, Integers, Primes, Booleans, or Automatic."
Resolve::ratnz = "Resolve was unable to eliminate quantifiers from the system with inexact coefficients. The answer was obtained by eliminating quantifiers from a corresponding exact system and numericizing the result."
Reduce::bdomv = "Warning: `1` is not a valid domain specification. Assuming it is a variable to eliminate."
Reduce::naqs = FindInstance::naqs = "`1` is not a quantified system of equations and inequalities."
Reduce::ratnz = "Reduce was unable to solve the system with inexact coefficients. The answer was obtained by solving a corresponding exact system and numericizing the result."
Reduce::inex = "Reduce was unable to solve the system with inexact coefficients or the system obtained by direct rationalization of inexact numbers present in the system. Since many of the methods used by Reduce require exact input, providing Reduce with an exact version of the system may help."
Reduce::nsmet = "This system cannot be solved with the methods available to Reduce."
FindInstance::fwsol = "Warning: FindInstance found only `1` instance(s), but it was not able to prove `2` instances do not exist."
FindInstance::nsmet = "The methods available to FindInstance are insufficient to find the requested instances or prove they do not exist."
FindInstance::exvar = "The system contains a nonconstant expression `1` independent of variables `2`."
FindInstance::boolv = "The system is not Boolean valued at `1`."
Reduce::cpow = Resolve::cpow = FindInstance::cpow = "`1` was unable to prove that a radical of an expression containing only real variables and parameters is real valued. If you are interested only in solutions for which all radicals contained in the input are real valued use `1` with domain argument Reals."
Reduce::croot = Resolve::croot = FindInstance::croot = "`1` was unable to prove that a Root object containing only real variables and parameters is real valued. If you are interested only in solutions for which all Root objects contained in the input are real valued use `1` with domain argument Reals."
Reduce::nric = Resolve::nric = FindInstance::nric = "The system `1` contains a nonreal constant `2` inside an inequality. With no domain argument given all constants appearing in inequalities should be real."
Reduce::nddc = Resolve::nddc = FindInstance::nddc = "The system `1` contains a nonreal constant `2`. With the domain `3` specified all constants should be real."
Reduce::useq = "The answer found by Reduce contains unsolved equation(s) `1`. A likely reason for this is that the solution set depends on branch cuts of Mathematica functions."
Reduce::rmod = FindInstance::rmod = "Modulus `1` must be a nonnegative integer other than 1."
Reduce::mdom = FindInstance::mdom = "Warning: ignoring domain specification `1`; option setting Modulus -> `2` implies domain integers modulo `2`."
Reduce::melem = FindInstance::melem = "Cannot use Element statements with option setting Modulus -> `1`."
Reduce::mineq = FindInstance::mineq = "Cannot use inequalities with option setting Modulus -> `1`."
Reduce::mcoef = FindInstance::mcoef = "The system `1` contains a nonrational constant `2`. With Modulus -> `3` all constants should be integers or rational numbers with denominators invertible modulo `3`."
Reduce::munsp = FindInstance::munsp = "`1` was unable to solve the system. Increasing the value of SystemOption MaxModularPoints may help."
Experimental`RegisterConverter::extensions = "Third argument should be a list of strings, and not `1`."
Experimental`RegisterConverter::mode = "First argument should be either Import or Export, and not `1`."
Experimental`RegisterConverter::noexe = "Could not find the executable `1` in any of `2`."
Experimental`RegisterConverter::source = "Fourth argument should be a string, pair of strings, or None, and not `1`."
RegularExpression::nocond = "No conditions allowed on right hand side `1` of RegularExpression replacement rule."
RegularExpression::error1 = "Error (\\ at end of pattern) in `1`"
RegularExpression::error2 = "Error (\\c at end of pattern) in `1`"
RegularExpression::error3 = "Error (unrecognized character follows \\) in `1`"
RegularExpression::error4 = "Error (numbers out of order in {} quantifier) in `1`"
RegularExpression::error5 = "Error (number too big in {} quantifier) in `1`"
RegularExpression::error6 = "Error (missing terminating ] for character class) in `1`"
RegularExpression::error7 = "Error (invalid escape sequence in character class) in `1`"
RegularExpression::error8 = "Error (range out of order in character class) in `1`"
RegularExpression::error9 = "Error (nothing to repeat) in `1`"
RegularExpression::error10 = "Error (operand of unlimited repeat could match the empty string) in `1`"
RegularExpression::error11 = "Error (internal error: unexpected repeat) in `1`"
RegularExpression::error12 = "Error (unrecognized character after (?) in `1`"
RegularExpression::error13 = "Error (POSIX named classes are supported only within a class) in `1`"
RegularExpression::error14 = "Error (missing )) in `1`"
RegularExpression::error15 = "Error (reference to non-existent subpattern) in `1`"
RegularExpression::error16 = "Error (erroffset passed as NULL) in `1`"
RegularExpression::error17 = "Error (unknown option bit(s) set) in `1`"
RegularExpression::error18 = "Error (missing ) after comment) in `1`"
RegularExpression::error19 = "Error (parentheses nested too deeply) in `1`"
RegularExpression::error20 = "Error (regular expression too large) in `1`"
RegularExpression::error21 = "Error (failed to get memory) in `1`"
RegularExpression::error22 = "Error (unmatched parentheses) in `1`"
RegularExpression::error23 = "Error (internal error: code overflow) in `1`"
RegularExpression::error24 = "Error (unrecognized character after (?<) in `1`"
RegularExpression::error25 = "Error (lookbehind assertion is not fixed length) in `1`"
RegularExpression::error26 = "Error (malformed number after (?() in `1`"
RegularExpression::error27 = "Error (conditional group contains more than two branches) in `1`"
RegularExpression::error28 = "Error (assertion expected after (?() in `1`"
RegularExpression::error29 = "Error ((?R or (?digits must be followed by )) in `1`"
RegularExpression::error30 = "Error (unknown POSIX class name) in `1`"
RegularExpression::error31 = "Error (POSIX collating elements are not supported) in `1`"
RegularExpression::error32 = "Error (this version of PCRE is not compiled with PCRE_UTF8 support) in `1`"
RegularExpression::error33 = "Error (spare error) in `1`"
RegularExpression::error34 = "Error (character value in \\x{...} sequence is too large) in `1`"
RegularExpression::error35 = "Error (invalid condition (?(0)) in `1`"
RegularExpression::error36 = "Error (\\C not allowed in lookbehind assertion) in `1`"
RegularExpression::error37 = "Error (PCRE does not support \\L, \\l, \\N, \\P, \\p, \\U, \\u, or \\X) in `1`"
RegularExpression::error38 = "Error (number after (?C is > 255) in `1`"
RegularExpression::error39 = "Error (closing ) for (?C expected) in `1`"
RegularExpression::error40 = "Error (recursive call could loop indefinitely) in `1`"
RegularExpression::error41 = "Error (unrecognized character after (?P) in `1`"
RegularExpression::error42 = "Error (syntax error after (?P) in `1`"
RegularExpression::error43 = "Error (two named groups have the same name) in `1`"
RegularExpression::error44 = "Error (invalid UTF-8 string) in `1`"
RegularExpression::error45 = "Error (missing \\E after \\Q) in `1`"
RegularExpression::error46 = "Error (missing newline after # in (?x) mode) in `1`"
RegularExpression::materr = "Error during match - positive match might be missed."
RegularExpression::maxrec = "Recursion limit exceeded - positive match might be missed."
Remove::relex = "Cannot remove lexical symbol `1` except automatically (when `2` is removed)."
Remove::remal = "Symbol `1` already removed."
Remove::rmlck = "Symbol `1` is Locked and cannot be removed."
Remove::rmnsm = "There are no symbols matching \"`1`\"."
Remove::rmptc = "Symbol `1` is Protected and cannot be removed."
Remove::spsym = "Special symbol `1` cannot be removed."
Remove::ssym = "`1` is not a symbol."
RenameDirectory::redev = RenameFile::redev = "Cannot rename to a different physical device; `1` will be copied to `2`, and the original will be deleted."
RenameFile::renfd = "Cannot rename a file into a directory."
Replace::erep = "`1` must be evaluated before use."
Replace::reps = ReplaceAll::reps = ReplaceRepeated::reps = ReplaceList::reps = "`1` is neither a list of replacement rules nor a valid dispatch table, and so cannot be used for replacing."
Replace::rmix = ReplaceAll::rmix = ReplaceRepeated::rmix = ReplaceList::rmix = "Elements of `1` are a mixture of lists and non-lists."
ReplacePart::psl = ReplaceHeldPart::psl = MapAt::psl = Delete::psl = FlattenAt::psl = Insert::psl = StringInsert::psl = StringReplacePart::psl = Extract::psl = "Position specification `1` in `2` is not an integer or a list of integers."
ReplaceRepeated::rrlim = "Exiting after `1` scanned `2` times."
ResetDirectory::dtop = "Directory stack is empty."
Experimental`Resolve::deprec = "Experimental`Resolve will not be supported in future versions of Mathematica. Use System`Resolve instead."
Resultant::method = "Invalid method for the resultant computation."
Resultant::var = "Not a valid variable in `1`."
Rest::norest = "Cannot take Rest of expression `1` with length zero."
Most::norest = "Cannot take Most of expression `1` with length zero."
Return::nofsdd = "No enclosing function, Scan, Do, or Dialog found for `1`."
Return::nofunc = "Function `1` not found enclosing `2`."
Return::obs = "Return's functionality of exiting a dialog is obsolete. To exit a dialog, use ExitDialog[] or ExitDialog[expr]. If an ExitDialog[expr] is encountered in the course of evaluation, the dialog will immediately be exited, returning expr."
Root::amb = "Root object `1` may be ambiguous. Changing the value of ExactRootIsolation option to Root to True and redoing the computations is recommended."
Root::deg = "`1` has less than `2` root(s) as a polynomial in `3`."
Root::mdeg = "The degree `1` of the input polynomial `2` is not an integer between 1 and $MaxRootDegree."
Root::npoly = "`1` is not a polynomial in `2`."
Root::nup = "`1` is not a univariate polynomial."
Root::overfl = "Overflow occurred during root isolation. The result may be incorrect."
Root::rnv = "`1` is neither a valid variable nor a valid root number."
Root::sbr = "Because of branch cuts, the series may represent a different root of `1` for some values of `2`."
Root::var = "`1` is not a valid variable."
Roots::badmod = "Cannot extract roots of input modulo `1`."
Roots::eqn = NRoots::eqn = "`1` is not an equation."
Roots::neq = NRoots::neq = "`1` is expected to be a polynomial in the variable `2`."
Roots::lexp = "Exponent of `1` in `2` is too large."
RootSum::pfn = "`1` is not a pure function."
RotateLeft::rotate = RotateRight::rotate = "Cannot rotate atomic expression `1`."
RotateLeft::rspec = RotateRight::rspec = "Rotation specification `1` should be a machine-size integer or list of machine-size integers."
RowReduce::rmeth = NullSpace::rmeth = Inverse::rmeth = "Value of option Method -> `1` should be CofactorExpansion, OneStepRowReduction, DivisionFreeRowReduction, or Automatic."
Rule::rhs = RuleDelayed::rhs = "Pattern `1` appears on the right-hand side of rule `2`."
Run::shell = "Cannot execute shell."
SchurDecomposition::schurf = HessenbergDecomposition::schurf = "`1` has received a matrix with infinite precision."
SchurDecomposition::schurn = HessenbergDecomposition::schurn = "`1` has received a matrix with non-numeric elements."
SeedRandom::seed = "Argument `1` in `2` should be an integer or a string."
SequenceLimit::seqlim = "The general form of the sequence could not be determined, and the result may be incorrect."
SequenceLimit::seqw = "Sequence of length `1` is too short for use with WynnDegree -> `2`."
SequenceLimit::wynn = "Value of option WynnDegree -> `1` should be a positive machine-size integer or Infinity."
Series::esss = "Essential singularity encountered in `1`."
Series::icm = "Series in `1` to be combined have unequal expansion points `2` and `3`."
Series::lss = "Logarithmic singularity encountered in `1`."
Series::nmer = "`1` is not a meromorphic function of `2` at `3`."
Series::sbyc = "Division by a series with no coefficients in `1`."
Series::serlim = "Series order specification `1` is not a machine-size integer."
Series::sspec = "Series specification `1` is not a list with three elements."
Series::vcnt = "Center point `2` of power series expansion involves the variable `1`."
SeriesData::csa = "Argument `1` in `2` is not a power series."
SeriesData::scmn = "Order of series `1` is negative."
SeriesData::scmp = "The constant term of series `1` does not match the expansion point of `2`."
SeriesData::sdatc = "Coefficient specification `1` in `2` is not a list."
SeriesData::sdatd = "Power denominator specification `1` in `2` is not a positive machine-size integer."
SeriesData::sdatn = "Order specification `1` in `2` is not a machine-size integer."
SeriesData::sdatv = "First argument `1` is not a valid variable."
SeriesData::slnc = "Argument `1` in Log is a series with no coefficients."
SeriesData::ssdn = "Attempt to evaluate a series at the number `1`; returning Indeterminate."
Set::patset = "Warning: `1` in assignment `2` represents a named pattern; use symbol::tag to represent a message name."
Set::inset = "Assignments cannot be performed during inspection."
Set::lhsr = SetDelayed::lhsr = Unset::lhsr = TagSet::lhsr = TagSetDelayed::lhsr = TagUnset::lhsr = UpSet::lhsr = UpSetDelayed::lhsr = "Replacing rule `1` with rule `2` since their left-hand sides and conditions are equivalent."
Set::setraw = SetDelayed::setraw = UpSet::setraw = UpSetDelayed::setraw = TagSet::setraw = TagSetDelayed::setraw = "Cannot assign to raw object `1`."
Set::setrpt = SetDelayed::setrpt = UpSet::setrpt = UpSetDelayed::setrpt = TagSet::setrpt = TagSetDelayed::setrpt = "Cannot assign to raw object `1` in pattern `2`."
Set::shape = SetDelayed::shape = "Lists `1` and `2` are not the same shape."
SetAccuracy::accbd = "Requested accuracy `1` is not a real number within the allowable range."
SetAccuracy::acclg = "Requested accuracy `1` would result in a precision greater than $MaxPrecision; bounding by $MaxPrecision instead."
SetAccuracy::accsm = "Requested accuracy `1` would result in a precision smaller than $MinPrecision; bounding by $MinPrecision instead."
SetFileDate::fdate = "Date specification should be either the number of seconds since Jan 1, 1900, or a {y, m, d, h, m, s} list."
SetFileDate::toobig = "Requested date is too far in the future."
SetOptions::changebf = "The BinaryFormat option of stream `1` cannot be changed to `2`."
SetOptions::optf = "`1` has incorrectly formed options `2`."
SetOptions::optnf = Options::optnf = AbsoluteOptions::optnf = "`1` is not a known option for `2`."
SetOptions::sstm = "Argument `1` is not a symbol or a stream."
SetStreamPosition::sbuf = "Requested position `1` in stream `2` is outside the file buffer; cannot reach outside the file buffer for non-disk files."
SetStreamPosition::stmrng = "Cannot set the current point in stream `2` to position `1`. The requested position exceeds the number of characters in the file."
Developer`SystemOptions::noset = "The value of SystemOption `1` cannot be modified."
Short::short = "Second argument `1` should be a positive real number."
Show::gcc = "Graphics of type `1` cannot be combined with other types of graphics."
Show::gcomb = "An error was encountered in combining the graphics objects in `1`."
Show::gmed = "No graphics output medium specified."
Show::shx = "No graphical objects to show."
Experimental`NumberScale::num = "Argument `1` should be a number."
Simplify::cfn = FullSimplify::cfn = "The cost function `1` does not evaluate to a real number at `2`."
Simplify::infd = FullSimplify::infd = "Expression `1` simplified to `2`."
Simplify::time = FullSimplify::time = "Time spent on a transformation exceeded `1` seconds, and the transformation was aborted. Increasing the value of TimeConstraint option may improve the result of simplification."
SingularValues::svdf = SingularValueList::svdf = SingularValueDecomposition::svdf = "`1` has received a matrix with infinite precision."
SingularValues::svdn = SingularValueList::svdn = SingularValueDecomposition::svdn = "`1` has received a matrix with non-numerical elements."
SingularValueList::gsvdta = SingularValueDecomposition::gsvdta = "Cannot take the second argument. Only one argument is permitted for generalized `1`."
Solve::circ = MainSolve::circ = Roots::circ = Reduce::circ = System`Private`OldReduce::circ = Eliminate::circ = SolveAlways::circ = AlgebraicRules::circ = "Removing solution `1` from list of solutions. It results from an underdetermined system of equations involving transcendental functions."
Solve::dinv = MainSolve::dinv = Eliminate::dinv = Roots::dinv = AlgebraicRules::dinv = Reduce::dinv = System`Private`OldReduce::dinv = SolveAlways::dinv = GroebnerBasis::dinv = PolynomialReduce::dinv = "The expression `1` involves unknowns in more than one argument, so inverse functions cannot be used."
Solve::incnst = "Inconsistent or redundant transcendental equation. After reduction, the bad equation is `1` == 0."
Solve::smod = "Unable to solve equations for modulus."
Solve::solex = MainSolve::solex = Roots::solex = Reduce::solex = System`Private`OldReduce::solex = Eliminate::solex = SolveAlways::solex = AlgebraicRules::solex = GroebnerBasis::solex = PolynomialReduce::solex = "`1` cannot handle one of the exponents."
Solve::svars = "Equations may not give solutions for all \"solve\" variables."
Solve::tdep = MainSolve::tdep = Roots::tdep = Reduce::tdep = System`Private`OldReduce::tdep = Eliminate::tdep = SolveAlways::tdep = AlgebraicRules::tdep = GroebnerBasis::tdep = PolynomialReduce::tdep = "The equations appear to involve the variables to be solved for in an essentially non-algebraic way."
Solve::ifun = Eliminate::ifun = SolveAlways::ifun = "Inverse functions are being used by `1`, so some solutions may not be found; use Reduce for complete solution information."
Reduce::ifun = System`Private`OldReduce::ifun = MainSolve::ifun = AlgebraicRules::ifun = "Inverse functions are being used by `1`, so some solutions may not be found."
Solve::ifun2 = Eliminate::ifun2 = Reduce::ifun2 = System`Private`OldReduce::ifun2 = MainSolve::ifun2 = AlgebraicRules::ifun2 = SolveAlways::ifun2 = "Cannot obtain solution with InverseFunctions->False option setting."
Sound::sdur = "Sound duration: `1` seconds"
Sound::srate = "Sample rate: `1` samples/second"
Sound::ssnf = "`1` out of `2` sample points did not evaluate to real numbers."
Sound::ssnm = "A good PlayRange could not be found since most of the samples are not evaluating to machine-size real numbers."
Sow::encl = "Expression `1` has no enclosing Reap."
Sow::enclt = "Tag `1` in `2` has no matching Reap."
Developer`SparseLinearSolve::deprec = "Developer`SparseLinearSolve is deprecated.  Use LinearSolve with SparseArray matrices instead."
Developer`SparseLinearSolve::spam = "The sparse matrix `1` is not specified in the form {{i1,j1}->a1,{i2,j2}->a2,...} with machine-sized integer position indices ik and jk and machine-sized real or complex values ak."
Developer`SparseLinearSolve::fovflw = Experimental`ExtendedLinearSolve::fovflw = Experimental`LinearSolveFunction::fovflw = "Machine overflow encountered factoring the sparse matrix."
Developer`SparseLinearSolve::sovflw = Experimental`ExtendedLinearSolve::sovflw = Experimental`LinearSolveFunction::sovflw = "Machine overflow encountered solving the sparse system."
Splice::splicd = "Missing right delimiter `1` at end of input file `2`."
Splice::splicf = "Cannot deduce output file name from `1`."
Splice::splict = "Cannot deduce output type from `1`."
Splice::splicx = "Syntax error in Mathematica input `1`."
Stack::stackx = "Expression number `1` does not exist in `2`; there are `3` expressions of the requested form."
StringCases::meta = StringFreeQ::meta = StringSplit::meta = StringReplaceList::meta = StringPosition::meta = StringReplace::meta = "Value of option MetaCharacters -> `1` is not None, Automatic, a string of length 3, or a list of three strings."
StringDrop::drop = "Cannot drop positions `1` through `2` in \"`3`\"."
StringForm::sfq = "Unmatched backquote in `1`."
StringForm::sfr = "Item `1` requested in \"`3`\" out of range; `2` items available."
StringInsert::ins = StringReplacePart::ins = "Cannot insert at position `2` in `1`."
StringMatchQ::nospell = " Warning: The SpellingCorrection option is ignored for patterns that are not a plain string."
StringExpression::cond = "Warning: Restrictions on pattern variable `1` in `2` are ignored as they are not associated with the first occurrence of `1`."
StringExpression::error = "Element `1` is not a valid string or pattern element in `2`."
StringReplace::srep = "`1` is not a valid string replacement rule."
StringReplacePart::ovlp = "Position `1` overlaps previous positions; new string `2` will not be inserted."
StringReplacePart::plen = Array::plen = "`1` and `2` should have the same length."
StringReplacePart::repart = "Cannot replace positions `1` through `2` in \"`3`\"."
StringReplacePart::spos = "Position specification {m, n} is expected at position `1` in `2`."
StringSplit::slen = "Positive integer, All, or Automatic expected at position `1` in `2`."
StringTake::take = "Cannot take positions `1` through `2` in \"`3`\"."
Subresultants::slpr = "The algorithm failed due to a too low precision of input."
Subscripted::subn = "Subscripting specification `1` is not of the form n or {n1, n2}."
Subscripted::subv = "Specifications for superscripts and subscripts overlap."
Subscripted::subx = "Positions specified by `1` are not available in expression of length `2`."
Subsets::nninfseq = "Position `1` of `2` must be All, Infinity, a nonnegative integer, or a List whose first element (required) is a nonnegative integer, second element (optional) is a nonnegative integer or Infinity, and third element (optional) is a nonzero integer."
Subsets::seq = "Position `1` of `2` must be All, None, an integer, or a List of 1, 2 or 3 integers, with the third (if present) nonzero, and with {0} disallowed."
Sum::div = "Sum does not converge."
Sum::gener = "Unable to check convergence."
Sum::sumwarn = "Warning: `1` contains a capital sigma; use \[EscapeKey]sum\[EscapeKey] to enter a summation sign."
SurfaceColor::albedo = "Albedo specification `1` in first argument of `2` is not a valid GrayLevel or RGBColor directive."
SurfaceColor::shine = "Shininess specification `1` in third argument of `2` is not a positive real number."
SurfaceColor::specl = "Specularity specification `1` in second argument of `2` is not a valid GrayLevel or RGBColor directive."
SurfaceGraphics::clip = "Value of option ClipFill -> `1` is not None, Automatic, a color, or a list of two such values."
SurfaceGraphics::noproj = Graphics3D::noproj = "Mathematica is unable to make a projection matrix; check the settings of ViewPoint, ViewCenter, and ViewVertical."
SurfaceGraphics::pmsr = DensityGraphics::pmsr = ContourGraphics::pmsr = "PlotRange `1` is so much smaller than MeshRange `2` that there is nothing left to plot."
SurfaceGraphics::shade = "Shading array `1` is not the same shape as the z-value array."
Switch::argct = "Switch called with `2` arguments. Switch must be called with an odd number of arguments."
Symbol::symname = "The string \"`1`\" cannot be used for a symbol name. A symbol name must start with a letter followed by letters and numbers."
Algebra`SymmetricPolynomials`SymmetricPolynomial::toobig = "Cannot create a polynomial with `1` terms."
Algebra`SymmetricPolynomials`SymmetricPolynomial::nmint = "`1` is not a nonnegative machine integer."
Algebra`SymmetricPolynomials`SymmetricPolynomial::hideg = "The degree `1` of an elementary symmetric polynomial cannot be higher that the number of variables `2`."
Algebra`SymmetricPolynomials`SymmetricPolynomial::nvarl = Algebra`SymmetricPolynomials`SymmetricReduction::nvarl = "`1` is not a list of variables."
Algebra`SymmetricPolynomials`SymmetricReduction::neql = "Lists `1` and `2` have different lengths."
Syntax::noinfo = "Input expression contains insufficient information to interpret result."
Syntax::snthex = "4 hexadecimal digits are required after \\: to construct a 16-bit character."
Syntax::sntoct1 = "3 octal digits are required after \\ to construct an 8-bit character."
Syntax::sntoct2 = "2 hexadecimal digits are required after \\. to construct an 8-bit character."
Syntax::sntufn = "Unknown unicode longname `1`."
Syntax::sntunc = "Unicode longname `1` in the string is unterminated."
Syntax::stresc = "Unknown string escape \\`1`."
Syntax::syntyp = "\\ operators can only be used between \( \)."
Syntax::com = "Warning: comma encountered with no adjacent expression; the expression will be treated as Null. `1`"
TableForm::tfal = "Value of option TableAlignments -> `1` should be a list of alignment specifications (Top, Bottom, and Center for row dimensions, or Left, Right, and Center for column dimensions)."
TableForm::tfdir = "Value of option TableDirections -> `1` should be Row, Column, or a non-empty list of these values."
TableForm::tfh = "TableHeadings option contained `1`, which is not Automatic, None, or a list of labels."
TableForm::tfsp = "Value of option TableSpacing -> `1` should be Automatic, a machine-size number, or a list of machine-size numbers."
TableForm::wtfsp = "Warning: TableSpacing value of `1` must be non-negative. Formatting will proceed with a value of 0."
TagSet::tagnf = TagSetDelayed::tagnf = TagUnset::tagnf = "Tag `1` not found in `2`."
TagSet::tagpos = TagSetDelayed::tagpos = TagUnset::tagpos = "Tag `1` in `2` is too deep for an assigned rule to be found."
TeXForm::unspt = "TeXForm of `1` is not supported."
Text::textn = "Text offset `1` is not a pair of numbers."
Text::textz = "Vector for text rotation cannot have value {0,0}."
Thickness::thkn = AbsoluteThickness::thkn = "The argument in `1` is not a number."
Thread::tdlen = "Objects of unequal length in `1` cannot be combined."
Thread::tpos = "Cannot thread over positions `1` through `2` in `3`."
Throw::nocatch = "Uncaught `1` returned to top level."
Ticks::ticks = "`1` is not a valid tick specification."
TimeConstrained::timc = Simplify::timc = FullSimplify::timc = Refine::timc = PiecewiseExpand::timc = "Number of seconds `1` is not a positive machine-size integer."
ToColor::colpc = ColorOutput::colpc = "Result `1` obtained during color conversion by applying function `2` to color `3` is not a GrayLevel, RGBColor, or CMYKColor color directive."
ToColor::colpw = ColorOutput::colpw = "Result `1` obtained during color conversion by applying function `2` to color `3` has the wrong number of arguments for that color."
ToColor::tocol = "First argument `1` in ToColor should be a valid color directive."
ToDate::tdn = "First argument `1` should be an integer or a real number."
ToExpression::esntx = "Could not parse `1` as Mathematica input."
ToExpression::esntxb = "Expression cannot begin with \"`1`\"."
ToExpression::esntxf = "\"`1`\" cannot be followed by \"`2`\"."
ToExpression::esntxi = "Incomplete expression \"`1`\"."
ToExpression::notstrbox = "`1` is not a string or a box. ToExpression can only interpret strings or boxes as Mathematica input."
NumberTheory`AlgebraicNumberFields`ToNumberFieldElement::nnfel = "`1` does not belong to the algebraic number field generated by `2`."
Total::tlauto = "The nested option for the Method option value Automatic can be \"ExtraPrecision\"->n, where n is an integer >= 0, or \"ExtraPrecision\"->Automatic, not `1`."
Total::tlep = "The value of the option \"ExtraPrecision\"->`1` should be a positive integer or Automatic."
Total::tlmth = "The value of the option Method->`1` should be Automatic or \"CompensatedSummation\"."
Total::tllen = "Lists of unequal length in `1` cannot be added."
ToString::notype = "FormatType `1` is not suitable for string-based output. Use a string-based format such as OutputForm."
Trace::tracb = TraceScan::tracb = TracePrint::tracb = TraceDialog::tracb = "Value of option `1` -> `2` should be False, True, All, or a list of two of these symbols."
Trace::tracd = TraceScan::tracd = TracePrint::tracd = TraceDialog::tracd = "Value of option `1` -> `2` should be False, True, or All."
TraceLevel::notrc = "No Trace function is currently active."
Transpose::diagnl = "Level rearrangement `1` would require collapsing dimensions of unequal lengths."
Transpose::newdims = "Level rearrangement `1` does not specify destination for level `2`."
Transpose::nmtx = "The first two levels of the one-dimensional list `1` cannot be transposed."
Transpose::perm = "The length of permutation `1` does not equal the depth of `2`."
Transpose::perm1 = "Entry `1` in permutation `2` is not a positive machine integer."
Transpose::perm2 = "Entry `1` is out of bounds for permutation `2`."
Transpose::tperm = "Permutation `1` is longer than the dimensions `2` of the array."
ConjugateTranspose::diagnl = "Level rearrangement `1` would require collapsing dimensions of unequal lengths."
ConjugateTranspose::newdims = "Level rearrangement `1` does not specify destination for level `2`."
ConjugateTranspose::nmtx = "The first two levels of the one-dimensional list `1` cannot be transposed."
ConjugateTranspose::perm = "The length of permutation `1` does not equal the depth of `2`."
ConjugateTranspose::perm1 = "Entry `1` in permutation `2` is not a positive machine integer."
ConjugateTranspose::perm2 = "Entry `1` is out of bounds for permutation `2`."
ConjugateTranspose::tperm = "Permutation `1` is longer than the dimensions `2` of the array."
UnAlias::alspr = "No previous alias found for `1`."
Uninstall::unlink = "External package `1` has not been installed."
Union::smtst = Intersection::smtst = Complement::smtst = "Application of the SameTest yielded `1`, which evaluates to `2`. The SameTest must evaluate to True or False at every pair of elements."
Unique::usym = "`1` is not a symbol or a valid symbol name."
Unset::cxun = "Cannot unset contexts."
Unset::norep = TagUnset::norep = "Assignment on `2` for `1` not found."
Unset::usraw = TagUnset::usraw = "Cannot unset raw object `1`."
Unset::usrpt = TagUnset::usrpt = "Cannot unset raw object `1` in pattern `2`."
ViewCenter::viewc = "A projection cannot be constructed for a ViewCenter which coincides with a ViewPoint."
ViewPoint::viewp = "A projection cannot be constructed for a ViewPoint inside the bounding box."
ViewVertical::viewv = "The ViewVertical vector must have a non-zero component perpendicular to a line from the ViewPoint to the ViewCenter."
With::dup = Module::dup = Block::dup = Dialog::dup = "Duplicate local variable `1` found in local variable specification `2`."
With::dups = Module::dups = "Conflicting local variables `1` and `3` found in local variable specification `2`."
With::lvw = "Local variable specification `1` contains `2` which is not an assignment to a symbol."
With::lvws = "Variable `1` in local variable specification `2` requires a value."
XMLElement::attlhs = "`1` in `2` is not a valid name for an attribute in an XMLElement.  It must be either a String (for the localname) or a List of two Strings (for the {namespace, localname} pair)."
XMLElement::attrhs = "`1` in `2` is not a valid value for an attribute in an XMLElement.  The value of the attribute must be a String."
XMLElement::attrslst = "`1` in `2` is not a List of attributes.  The second item in an XMLElement must be a List of attributes, even if it is an empty list."
XMLElement::attrule = "`1` in `2` is not a valid attribute.  Attributes must be specified in the form \"name\"->\"value\" or {\"namespace\",\"localname\"}->\"value\""
XMLElement::cnts = "`1` is not valid in the contents of an XMLElement. The contents of an XMLElement must consist of Strings and XMLElements."
XMLElement::cntsList = "`1` in `2` is not a List of contents.  The third item in an XMLElement must be a List of contents, even if it is an empty List."
XMLElement::name = "`1` in `2` is not a valid name for an XMLElement.  It must be either a String (for the localname) or a List of two Strings (for the {namespace, localname} pair)."
XMLElement::unqatt = "The attribute name (`1`) in `2` is not unique -- there is already an attribute with this name in the same XMLElement.  Two attributes with the same name cannot exist inside the same element."
XMLObject::decunsv = "`1` in `2` is not a valid setting for the Version option in an XMLObject[\"Declaration\"].  The only setting that is supported is \"1.0\"."
XMLObject::decvfst = "`1` in `2` is not a Version option.  The first option to XMLObject[\"Declaration\"] must be of the form \"Version\"->_String"
XMLObject::decvreq = "`1` has no \"Version\" option -- the \"Version\" option is required to be the first item in an XMLObject[\"Declaration\"]."
XMLObject::declfst = "The XMLObject[\"Declaration\"] is not in position 1 of `1`.  If present, an XMLObject[\"Declaration\"] must be the first item in the prolog of an XMLObject[\"Document\"]."
XMLObject::docbarg = "The argument at position `1` in `2` is expected to be a `3`"
XMLObject::docep = "`1` in `2` is not allowed in the List at position 3 of an XMLObject[\"Document\"].  Only XMLObject[\"Comment\"] and XMLObject[\"ProcessingInstruction\"] are allowed."
XMLObject::docprlgi = "`1` in `2` is not allowed in the prolog of an XMLObject[\"Document\"].  Only XMLObject[\"Declaration\"], XMLObject[\"Doctype\"], XMLObject[\"Comment\"] and XMLObject[\"ProccesingInstruction\"] are allowed in the prolog."
XMLObject::dtrtstr = "`1` in `2` is not a String.  The first item in an XMLObject[\"Doctype\"] must be a String that is the name of the root element."
XMLObject::slone = "`1` in `2` is not a vaid setting for the \"Standalone\" option to XMLObject[\"Declaration\"].  The option can only be set to \"yes\" or \"no\", and is case-sensitive."
XMLObject::unq = "There is more than one occurrence of `1` in `2`.  `1` is required to be unique."
XMLObject::unsenc = "`1` in `2` is not a supported setting for the encoding.  The only supported encodings are UTF-8 and US-ASCII."
XML`SymbolicXMLErrors::unknobj = "`1` is not a recognized SymbolicXML object.  The only valid SymbolicXML objects are XMLElement and XMLObject."
XML`MathML`BoxesToSymbolicMathML::attlhs = "`1` in `2` is not a valid name for an attribute to attach to the root <math> tag.  An attribute name must be either a String (for the localname) or a List of two Strings (for the {namespace, localname} pair)."
XML`MathML`BoxesToSymbolicMathML::attrhs = "`1` in `2` is not a valid value for an attribute to attach to the root <math> tag. The value of the attribute must be a String."
XML`MathML`BoxesToSymbolicMathML::attrule = "`1` is not a valid xml attribute to attach to the root <math> tag.  Attributes must be specified in the form \"name\"->\"value\" or {\"namespace\",\"localname\"}->\"value\""
XML`MathML`BoxesToSymbolicMathML::badba = "An error occurred when translating a box expression or an annotation to SymbolicMathML. The box expression or annotation has been ignored."
XML`MathML`BoxesToSymbolicMathML::incasmml = "Internal MathML processing error. Attributes where wrapped around a leaf tag which should never happen. The leaf is `1` and the converted attributes are `2`. Please report this."
XML`MathML`BoxesToSymbolicMathML::notboxes = XML`MathML`BoxesToMathML::notboxes = "`1` is not a valid box structure. The first argument in `2` must be a valid box structure."
XML`MathML`BoxesToSymbolicMathML::uncnvbxs = "The boxes `1` are not convertible to SymbolicXML."
XML`MathML`BoxesToSymbolicMathML::unrecf = "The format `1` is not a recognized annotation for MathML."
XML`MathML`SymbolicMathMLToBoxes::bmml = "The `1`, `2`, occurred without a surrounding xml tag. An attempt has been made to correct this defect."
XML`MathML`SymbolicMathMLToBoxes::incrt = "The SymbolicMathML structure being interpreted has the root tag \"`1`\" instead of the correct tag \"math\"."
XML`MathML`SymbolicMathMLToBoxes::invsmml = "The structure \"`1`\" attempting to be converted to boxes is not a valid SymbolicMathML structure."
XML`MathML`SymbolicMathMLToBoxes::malsmml = "The structure \"`1`\" attempting to be converted to boxes has a malformed XML structure."
XML`MathML`SymbolicMathMLToBoxes::nmmlr = "The structure \"`1`\" attempting to be converted to boxes has the root XML tag \"`2`\", which is not a recognized MathML tag."
XML`MathML`SymbolicMathMLToBoxes::unknstrc = "`1` is not a valid MathML structure."
XML`MathML`SymbolicMathMLToBoxes::unkntag = "`1` is not a valid MathML tag. The tag `1` is being treated as a symbol."
XML`MathML`SymbolicMathMLToExpression::invsmml = "The structure \"`1`\" attempting to be converted to an expression is not a valid SymbolicMathML structure."
XML`MathML`SymbolicMathMLToExpression::malsmml = "The structure \"`1`\" attempting to be converted to an expression has a malformed XML structure."
XML`MathML`SymbolicMathMLToExpression::nmmlr = "The structure \"`1`\" attempting to be converted to an expression has the root XML tag \"`2`\", which is not a recognized MathML tag."
XML`NotebookML`NotebookToSymbolicNotebookML::badobj = "Malformed notebook fragment `1` encountered.  The fragment is being converted to SymbolicExpressionML."
XML`NotebookML`NotebookToSymbolicNotebookML::filonb = "Filename, Notebook Expression, or NotebookObject expected at position 1 in `1`."
XML`NotebookML`NotebookToSymbolicNotebookML::nogrcnv = "A front end is not available. A front end is necessary to translate the `1` into the `2` graphics format."
XML`NotebookML`NotebookToSymbolicNotebookML::unrecbd = "There is no built in conversion for BoxData objects to `1`."
XML`NotebookML`NotebookToSymbolicNotebookML::unrecgd = "There is no built in conversion for GraphicsData encoded as `1` to `2`."
XML`NotebookML`SymbolicExpressionMLToExpression::nbmlns = "`1` is not in the NotebookML Namespace, it is in the null namespace. Mathematica is assuming that it was intended to be in the NotebookML Namespace."
XML`NotebookML`SymbolicNotebookMLToNotebook::noboxes = "A NotebookML BoxData element did not contain interpretable information.  It cannot be displayed correctly."
XML`NotebookML`SymbolicNotebookMLToNotebook::nogrphx = "A NotebookML GraphicsData element did not contain interpretable information.  It cannot be displayed correctly."
XML`NotebookML`SymbolicNotebookMLToNotebook::nbmlns = "`1` is not in the NotebookML Namespace, it is in the null namespace. Mathematica is assuming that it was intended to be in the NotebookML Namespace."
XML`NotebookML`SymbolicNotebookMLToNotebook::unknxml = "`1` is not a valid NotebookML expression."
XML`Parser`InitializeXMLParser::memfail = "XMLInit failed due to a problem allocating memory."
XML`Parser`InitializeXMLParser::nfprserr = "`1`"
XML`Parser`InitializeXMLParser::prserr = "`1`"
XML`Parser`ReleaseXMLParser::bparsr = "XMLParser object expected at position 1 in `1`"
XML`Parser`ReleaseXMLParser::ilgprsr = "XMLParser[`1`]"
XML`Parser`XMLGet::badop = "Option `1` cannot take a value of `2`.  It can only take `3`."
XML`Parser`XMLGet::ilgprsr = "XMLParser[`1`]"
XML`Parser`XMLGet::memfail = "XMLGet failed due to a problem allocating memory."
XML`Parser`XMLGet::nfprserr = "`1`"
XML`Parser`XMLGet::prserr = "`1`"
XML`Parser`XMLGet::put = "MathLink error when generating output.  MathLink error: `1`."
XML`Parser`XMLGet::unknop = "`1` is not a recognized option."
XML`Parser`XMLGet::xmlprsop = "XMLParser object or option expected at position `1` in `2`."
XML`Parser`XMLGetString::ilgprsr = "XMLParser[`1`]"
XML`Parser`XMLGetString::memfail = "XMLGetString failed due to a problem allocating memory."
XML`Parser`XMLGetString::nfprserr = "`1`"
XML`Parser`XMLGetString::prserr = "`1`"
XML`Parser`XMLGetString::xmlprsop = "XMLParser object or option expected at position `1` in `2`."
XML`SVG`GraphicsToSymbolicSVG::bdmgr = "There appears to be an error in the Graphics being converted. Some parts of the graphic expression may be incorrectly translated."
XML`SVG`GraphicsToSymbolicSVG::bsvgf = "Unexpected form: `1`"
XML`SVG`GraphicsToSymbolicSVG::bsvgns = "Unexpected ToSVGNumberString: `1`"
XML`SVG`GraphicsToSymbolicSVG::gtype = "`1` is not a type of graphics."
XML`SVG`GraphicsToSymbolicSVG::ncvrt = "Conversion from Graphics to SVG is missing a conversion for `1`"
XML`SVG`SymbolicSVGToGraphics::unsup = "SVG import is not currently supported."
