(* Messages for built-in symbols without refguide entries *)
Abort::usage = "Abort[ ] generates an interrupt to abort a computation."
AbortProtect::usage = "AbortProtect[expr] evaluates expr, saving any aborts until the evaluation is complete."
Above::usage = "Above is used to specify alignment in printforms such as ColumnForm and TableForm."
Abs::usage = "Abs[z] gives the absolute value of the real or complex number z."
AbsoluteDashing::usage = "AbsoluteDashing[{d1, d2, ... }] is a graphics directive which specifies that lines which follow are to be drawn dashed, with successive segments having absolute lengths d1, d2, ...  (repeated cyclically)."
AbsoluteOptions::usage = "AbsoluteOptions[expr] gives the absolute settings of options specified in an expression such as a graphics object. AbsoluteOptions[expr, name] gives the absolute setting for the option name. AbsoluteOptions[expr, {name1, name2, ... }] gives a list of the absolute settings for the options namei. AbsoluteOptions[object] gives the absolute settings for options associated with an external object such as a NotebookObject."
AbsolutePointSize::usage = "AbsolutePointSize[d] is a graphics directive which specifies that points which follow are to be shown if possible as circular regions with absolute diameter d."
AbsoluteThickness::usage = "AbsoluteThickness[d] is a graphics directive which specifies that lines which follow are to be drawn with absolute thickness d."
AbsoluteTime::usage = "AbsoluteTime[ ] gives the total number of seconds since the beginning of January 1, 1900, in your time zone."
AbsoluteTiming::usage = "AbsoluteTiming[expr] evaluates expr, returning a list of the absolute time that has elapsed, together with the result obtained."
AccountingForm::usage = "AccountingForm[expr] prints with all numbers in expr given in standard accounting notation. AccountingForm[expr, n] prints with numbers given to n-digit precision."
Accuracy::usage = "Accuracy[x] gives the effective number of digits to the right of the decimal point in the number x."
AccuracyGoal::usage = "AccuracyGoal is an option for various numerical operations which specifies how many effective digits of accuracy should be sought in the final result."
Active::usage = "Active is an option for ButtonBox, Cell and Notebook which specifies whether a button should be active."
Adams::usage = "Adams is a choice for the option Method of NDSolve. Method -> Adams uses the Adams-Moulton predictor-corrector method."
AddTo::usage = "x += dx adds dx to x and returns the new value of x."
AdjustmentBox::usage = "AdjustmentBox[box, opts] displays with the placement of box adjusted using the options given."
AiryAi::usage = "AiryAi[z] gives the Airy function Ai(z)."
AiryAiPrime::usage = "AiryAiPrime[z] gives the derivative of the Airy function Ai\[Prime](z)."
AiryBi::usage = "AiryBi[z] gives the Airy function Bi(z)."
AiryBiPrime::usage = "AiryBiPrime[z] gives the derivative of the Airy function Bi\[Prime](z)."
Algebra`PolynomialPowerMod::usage = "PolynomialPowerMod[poly1, n, {poly2, p}] gives the polynomial poly1^n reduced modulo poly2 and p, where n is an integer, p is a prime, and poly1 and poly2 are univariate polynomials in the same variable."
AlgebraicRulesData::usage = "AlgebraicRulesData is an object returned by AlgebraicRules. Its OutputForm appears to be a list of rules, but the rules will be used algebraically rather than syntactically by Replace and related functions."
Algebraics::usage = "Algebraics represents the domain of algebraic numbers, as in x \[Element] Algebraics."
All::usage = "All is a setting used for certain options. In Part and related functions, All specifies all parts at a particular level."
Alternatives::usage = "p1 | p2 | ...  is a pattern object which represents any of the patterns pi."
AmbientLight::usage = "AmbientLight is an option for Graphics3D and related functions that gives the level of simulated ambient illumination in a three-dimensional picture."
Analytic::usage = "Analytic is an option for Limit and Series. With Analytic -> True, unrecognized functions are treated as analytic, and processed using Taylor series expansions; with Analytic -> False, Taylor series are not used unless the function is recognized as analytic."
AnchoredSearch::usage = "AnchoredSearch is an option for Find and FindList which specifies whether the text searched for must be at the beginning of a record."
And::usage = "e1 && e2 && ...  is the logical AND function. It evaluates its arguments in order, giving False immediately if any of them are False, and True if they are all True."
AnimationDirection::usage = "AnimationDirection is an option for Cell which specifies the direction to run an animation which starts with the cell."
AnimationDisplayTime::usage = "AnimationDisplayTime is an option for Cell which specifies the minimum time in seconds for which a cell should be displayed in the course of an animation that runs through a sequence of selected cells."
Apart::usage = "Apart[expr] rewrites a rational expression as a sum of terms with minimal denominators. Apart[expr, var] treats all variables other than var as constants."
ApartSquareFree::usage = "ApartSquareFree[expr] writes expr as a sum of terms with denominators that are powers of square-free factors of the denominator of expr. ApartSquareFree[expr, var] treats all variables other than var as constants."
AppellF1::usage = "AppellF1[a, b1, b2, c, x, y] is the Appell hypergeometric function of two variables F1(a; b1, b2; c; x, y)."
Append::usage = "Append[expr, elem] gives expr with elem appended."
AppendTo::usage = "AppendTo[s, elem] appends elem to the value of s, and resets s to the result."
Apply::usage = "Apply[f, expr] or f @@ expr replaces the head of expr by f. Apply[f, expr, levelspec] replaces heads in parts of expr specified by levelspec."
ArcCos::usage = "ArcCos[z] gives the arc cosine of the complex number z."
ArcCosh::usage = "ArcCosh[z] gives the inverse hyperbolic cosine of the complex number z."
ArcCot::usage = "ArcCot[z] gives the arc cotangent of the complex number z."
ArcCoth::usage = "ArcCoth[z] gives the inverse hyperbolic cotangent of the complex number z."
ArcCsc::usage = "ArcCsc[z] gives the arc cosecant of the complex number z."
ArcCsch::usage = "ArcCsch[z] gives the inverse hyperbolic cosecant of the complex number z."
ArcSec::usage = "ArcSec[z] gives the arc secant of the complex number z."
ArcSech::usage = "ArcSech[z] gives the inverse hyperbolic secant of the complex number z."
ArcSin::usage = "ArcSin[z] gives the arc sine of the complex number z."
ArcSinh::usage = "ArcSinh[z] gives the inverse hyperbolic sine of the complex number z."
ArcTan::usage = "ArcTan[z] gives the arc tangent of the complex number z. ArcTan[x, y] gives the arc tangent of y/x, taking into account which quadrant the point (x, y) is in."
ArcTanh::usage = "ArcTanh[z] gives the hyperbolic arc tangent of the complex number z."
Arg::usage = "Arg[z] gives the argument of the complex number z."
ArgumentCountQ::usage = "ArgumentCountQ[head, len, min, max] tests whether the number len of arguments of a function head is between min and max."
ArithmeticGeometricMean::usage = "ArithmeticGeometricMean[a, b] gives the arithmetic-geometric mean of a and b."
Array::usage = "Array[f, n] generates a list of length n, with elements f[i]. Array[f, {n1, n2, ... }] generates an n1 by n2 by ... array of nested lists, with elements f[i1, i2, ... ]. Array[f, {n1, n2, ... }, {r1, r2, ... }] generates a list using the index origins ri (default 1). Array[f, dims, origin, h] uses head h, rather than List, for each level of the array."
ArrayDepth::usage = "ArrayDepth[expr] gives the depth to which expr is a full array, with all the parts at a particular level being lists of the same length, or is a SparseArray object."
ArrayPlot::usage = "ArrayPlot[array] generates a plot in which the values in an array are shown in a discrete array of squares."
ArrayQ::usage = "ArrayQ[expr] gives True if expr is a full array or a SparseArray object, and gives False otherwise. ArrayQ[expr, patt] requires expr to be a full array with a depth that matches the pattern patt. ArrayQ[expr, patt, test] requires also that test yield True when applied to each of the array elements in expr."
ArrayRules::usage = "ArrayRules[SparseArray[ ... ]] gives the rules {pos1->val1, pos2->val2, ... } specifying elements in a sparse array. ArrayRules[list] gives rules for SparseArray[list]."
AspectRatio::usage = "AspectRatio is an option for Graphics and related functions which specifies the ratio of height to width for a plot."
AspectRatioFixed::usage = "AspectRatioFixed is an option for Cell which specifies whether graphics in the cell should be constrained to stay the same shape when they are interactively resized using the front end."
Assuming::usage = "Assuming[assum, expr] evaluates expr with assum appended to $Assumptions, so that assum is included in the default assumptions used by functions such as Refine, Simplify and Integrate."
Assumptions::usage = "Assumptions is an option for functions such as Simplify, Refine and Integrate which specifies default assumptions to be made about symbolic quantities."
AtomQ::usage = "AtomQ[expr] yields True if expr is an expression which cannot be divided into subexpressions, and yields False otherwise."
Attributes::usage = "Attributes[symbol] gives the list of attributes for a symbol."
AutoDelete::usage = "AutoDelete is an option to TagBox."
AutoIndent::usage = "AutoIndent is an option for Cell which specifies what automatic indentation should be done at the beginning of a new line after an explicit return character has been entered."
AutoItalicWords::usage = "AutoItalicWords is an option for Cell which gives a list of words which should automatically be put in italics when they are entered."
Automatic::usage = "Automatic represents an option value that is to be chosen automatically by a built-in function."
AutoSpacing::usage = "AutoSpacing is an option for StyleBox and Cell which specifies whether spaces between successive characters should be adjusted automatically."
Axes::usage = "Axes is an option for graphics functions that specifies whether axes should be drawn."
AxesEdge::usage = "AxesEdge is an option for three-dimensional graphics functions that specifies on which edges of the bounding box axes should be drawn."
AxesLabel::usage = "AxesLabel is an option for graphics functions that specifies labels for axes."
AxesOrigin::usage = "AxesOrigin is an option for two-dimensional graphics functions which specifies where any axes drawn should cross."
AxesStyle::usage = "AxesStyle is an option for graphics functions which specifies how axes should be rendered."
Background::usage = "Background is an option which specifies the background color to use."
BaseForm::usage = "BaseForm[expr, n] prints with the numbers in expr given in base n."
Baseline::usage = "Baseline is a setting for GridBaseline."
Begin::usage = "Begin[\"context`\"] resets the current context."
BeginPackage::usage = "BeginPackage[\"context`\"] makes context` and System` the only active contexts. BeginPackage[\"context`\", {\"need1`\", \"need2`\", ... }] calls Needs on the needi."
Below::usage = "Below is used to specify alignment in printforms such as ColumnForm and TableForm."
BernoulliB::usage = "BernoulliB[n] gives the nth Bernoulli number. BernoulliB[n, x] gives the nth Bernoulli polynomial."
BesselI::usage = "BesselI[n, z] gives the modified Bessel function of the first kind I(n, z)."
BesselJ::usage = "BesselJ[n, z] gives the Bessel function of the first kind J(n, z)."
BesselK::usage = "BesselK[n, z] gives the modified Bessel function of the second kind K(n, z)."
BesselY::usage = "BesselY[n, z] gives the Bessel function of the second kind Y(n, z)."
Beta::usage = "Beta[a, b] gives the Euler beta function B(a, b). Beta[z, a, b] gives the incomplete beta function Bz(a, b)."
BetaRegularized::usage = "BetaRegularized[z, a, b] gives the regularized incomplete beta function I(z, a, b)."
BinaryRead::usage = "BinaryRead[stream] reads one byte of raw binary data from an input stream, and returns an integer from 0 to 255. BinaryRead[stream, type] reads an object of the specified type. BinaryRead[stream, {type1, type2, ... }] reads a sequence of objects of the specified types."
BinaryReadList::usage = "BinaryReadList[\"file\"] reads all remaining bytes from a file, and returns them as a list of integers from 0 to 255. BinaryReadList[\"file\", type] reads objects of the specified type from a file, until the end of the file is reached. The list of objects read is returned. BinaryReadList[\"file\", {type1, type2, ... }] reads objects with a sequence of types, until the end of the file is reached. BinaryReadList[\"file\", types, n] reads only the first n objects of the specified types."
BinaryWrite::usage = "BinaryWrite[channel, b] writes a byte of data, specified as an integer from 0 to 255. BinaryWrite[channel, {b1, b2, ... }] writes a sequence of bytes. BinaryWrite[channel, \"string\"] writes the raw sequence of characters in a string. BinaryWrite[channel, x, type] writes an object of the specified type. BinaryWrite[channel, {x1, x2, ... }, type] writes a sequence of objects of the specified type. BinaryWrite[channel, {x1, x2, ... }, {type1, type2, ... }] writes a sequence of objects with a sequence of types."
Binomial::usage = "Binomial[n, m] gives the binomial coefficient."
BitAnd::usage = "BitAnd[n1, n2, ... ] gives the bitwise AND of the integers ni."
BitNot::usage = "BitNot[n] gives the bitwise NOT of the integer n."
BitOr::usage = "BitOr[n1, n2, ... ] gives the bitwise OR of the integers ni."
BitXor::usage = "BitXor[n1, n2, ... ] gives the bitwise XOR of the integers ni."
Black::usage = "Black represents the color black in graphics or style specifications."
Blank::usage = "_ or Blank[ ] is a pattern object that can stand for any Mathematica expression. _h or Blank[h] can stand for any expression with head h."
BlankForm::usage = "BlankForm is an internal symbol used for formatting and printing."
BlankNullSequence::usage = "___ (three _ characters) or BlankNullSequence[ ] is a pattern object that can stand for any sequence of zero or more Mathematica expressions. ___h or BlankNullSequence[h] can stand for any sequence of expressions, all of which have head h."
BlankSequence::usage = "__ (two _ characters) or BlankSequence[ ] is a pattern object that can stand for any sequence of one or more Mathematica expressions. __h or BlankSequence[h] can stand for any sequence of one or more expressions, all of which have head h."
Block::usage = "Block[{x, y, ... }, expr] specifies that expr is to be evaluated with local values for the symbols x, y, ... . Block[{x = x0, ... }, expr] defines initial local values for x, ... ."
Blue::usage = "Blue represents the color blue in graphics or style specifications."
Boole::usage = "Boole[expr] yields 1 if expr is True and 0 if it is False."
Booleans::usage = "Booleans represents the domain of booleans, as in x \[Element] Booleans."
Bottom::usage = "Bottom is a setting for the TableAlignments option of TableForm."
Boxed::usage = "Boxed is an option for Graphics3D which specifies whether to draw the edges of the bounding box in a three-dimensional picture."
BoxRatios::usage = "BoxRatios is an option for Graphics3D which gives the ratios of side lengths for the bounding box of the three-dimensional picture."
BoxStyle::usage = "BoxStyle is an option for three-dimensional graphics functions which specifies how the bounding box should be rendered."
Break::usage = "Break[ ] exits the nearest enclosing Do, For or While."
Brown::usage = "Brown represents the color brown in graphics or style specifications."
ButtonBox::usage = "ButtonBox[boxes] represents a button in a notebook, displaying boxes and performing an action when it is clicked on. The default action is to paste boxes at your current insertion point. Other actions can be specified using options. ButtonBox objects are used to implement palette buttons, hyperlinks and other active elements in notebooks. ButtonBox objects are active when either they or the cell that contains them has the option Active->True."
ButtonData::usage = "ButtonData is an option for ButtonBox which specifies the second argument to give to the ButtonFunction for the button when the button is active and is clicked on."
ButtonEvaluator::usage = "ButtonEvaluator is an option for ButtonBox which specifies where the expression constructed from ButtonFunction should be sent for evaluation."
ButtonExpandable::usage = "ButtonExpandable is an option for ButtonBox which specifies whether the button should expand to fill any GridBox position in which it appears."
ButtonFrame::usage = "ButtonFrame is an option for ButtonBox which specifies the type of frame to display around a button."
ButtonFunction::usage = "ButtonFunction is an option for ButtonBox which specifies the function to execute when the button is active and is clicked on."
ButtonMargins::usage = "ButtonMargins is an option for ButtonBox which specifies how much space in printer's points to leave around the contents of a button when the button is displayed."
ButtonMinHeight::usage = "ButtonMinHeight is an option for ButtonBox which specifies the minimum total height in units of font size that should be allowed for the button."
ButtonNote::usage = "ButtonNote is an option for ButtonBox which specifies what should be displayed in the status line of the current notebook window when the button is active and the cursor is placed on top of it."
ButtonNotebook::usage = "ButtonNotebook[ ] gives the notebook, if any, that contains the button which initiated the current evaluation."
ButtonSource::usage = "ButtonSource is an option for ButtonBox which specifies the first argument to give to the ButtonFunction for the button when the button is active and is clicked on."
ButtonStyle::usage = "ButtonStyle is an option for ButtonBox which specifies the default properties for the button."
Byte::usage = "Byte represents a single byte of data in Read."
ByteCount::usage = "ByteCount[expr] gives the number of bytes used internally by Mathematica to store expr."
ByteOrdering::usage = "ByteOrdering is an option for the Import and Export functions, which specifies the byte ordering to use with the binary integer and real formats."
C::usage = "C[i] is the default form for the ith parameter or constant generated in representing the results of various symbolic computations."
Cancel::usage = "Cancel[expr] cancels out common factors in the numerator and denominator of expr."
CarmichaelLambda::usage = "CarmichaelLambda[n] gives the Carmichael function \[Lambda](n), defined as the smallest integer m such that k^m \[Congruent] 1 mod n for all k relatively prime to n."
Cases::usage = "Cases[{e1, e2, ... }, pattern] gives a list of the ei that match the pattern. Cases[{e1, ... }, pattern -> rhs] gives a list of the values of rhs corresponding to the ei that match the pattern. Cases[expr, pattern, levspec] gives a list of all parts of expr on levels specified by levspec which match the pattern. Cases[expr, pattern -> rhs, levspec] gives the values of rhs which match the pattern. Cases[expr, pattern, levspec, n] gives the first n parts in expr which match the pattern."
Catalan::usage = "Catalan is Catalan's constant, with numerical value approximately equal to 0.915966."
Catch::usage = "Catch[expr] returns the argument of the first Throw generated in the evaluation of expr. Catch[expr, form] returns value from the first Throw[value, tag] for which form matches tag. Catch[expr, form, f] returns f[value, tag]."
Ceiling::usage = "Ceiling[x] gives the smallest integer greater than or equal to x."
Cell::usage = "Cell[contents, \"style\"] represents a cell in a Mathematica notebook."
CellAutoOverwrite::usage = "CellAutoOverwrite is an option for Cell which specifies whether new output obtained by evaluating this cell should overwrite old output."
CellBaseline::usage = "CellBaseline is an option for Cell which specifies where the baseline of the cell should be assumed to be when it appears inside another cell."
CellDingbat::usage = "CellDingbat is an option for Cell which specifies what dingbat to use to emphasize a cell."
CellEditDuplicate::usage = "CellEditDuplicate is an option for Cell which specifies whether the front end should make a copy of the cell before actually applying any changes in its contents that you request."
CellEvaluationDuplicate::usage = "CellEvaluationDuplicate is an option for Cell which specifies whether the front end should make a copy of the cell before performing any evaluation of its contents that you request."
CellFrame::usage = "CellFrame is an option for Cell which specifies whether a frame should be drawn around a cell."
CellFrameMargins::usage = "CellFrameMargins is an option for Cell which specifies the absolute margins in printer's points to leave inside a frame that is drawn around a cell."
CellGroupData::usage = "CellGroupData[{cell1, cell2, ... }, Open] represents an open group of cells in a notebook. CellGroupData[{cell1, cell2, ... }, Closed] represents a closed group of cells."
CellGrouping::usage = "CellGrouping is an option for Notebook which specifies how cells in the notebook should be assembled into groups."
CellLabel::usage = "CellLabel is an option for Cell which gives the label to use for a particular cell."
CellLabelAutoDelete::usage = "CellLabelAutoDelete is an option for Cell which specifies whether a label for the cell should be automatically deleted if the contents of the cell are modified or the notebook containing the cell is saved in a file."
CellMargins::usage = "CellMargins is an option for Cell which specifies the absolute margins in printer's points to leave around a cell."
CellOpen::usage = "CellOpen is an option for Cell which specifies whether the contents of a cell should be explicitly displayed."
CellPrint::usage = "CellPrint[cell] inserts cell in a notebook immediately after the cell that is currently being evaluated. CellPrint[{cell1, cell2, ... }] inserts a sequence of cells."
CellTags::usage = "CellTags is an option for Cell which gives a list of tags to associate with a cell."
CellularAutomaton::usage = "CellularAutomaton[rnum, init, t] generates a list representing the evolution of cellular automaton rule rnum from initial condition init for t steps. CellularAutomaton[rnum, init, t, {offt, offx, ... }] keeps only the parts of the evolution list with the specified offsets."
Center::usage = "Center is used to specify alignment in printforms such as ColumnForm and TableForm."
CForm::usage = "CForm[expr] prints as a C language version of expr."
Character::usage = "Character represents a single character in Read."
CharacterEncoding::usage = "CharacterEncoding is an option for input and output functions which specifies what raw character encoding should be used."
CharacteristicPolynomial::usage = "CharacteristicPolynomial[m, x] gives the characteristic polynomial for the matrix m."
CharacterRange::usage = "CharacterRange[\"c1\", \"c2\"] yields a list of the characters in the range from \"c1\" to \"c2\"."
Characters::usage = "Characters[\"string\"] gives a list of the characters in a string."
ChebyshevT::usage = "ChebyshevT[n, x] gives the nth Chebyshev polynomial of the first kind."
ChebyshevU::usage = "ChebyshevU[n, x] gives the nth Chebyshev polynomial of the second kind."
Check::usage = "Check[expr, failexpr] evaluates expr, and returns the result, unless messages were generated, in which case it evaluates and returns failexpr. Check[expr, failexpr, s1::t1, s2::t2, ... ] checks only for the specified messages."
CheckAbort::usage = "CheckAbort[expr, failexpr] evaluates expr, returning failexpr if an abort occurs."
CheckAll::usage = "CheckAll[expr, f] evaluates expr and returns f[expr, HoldComplete[control1, ...]] where the control-i expressions are aborts, throws, or other flow control commands currently being executed (but stopped by CheckAll)."
CholeskyDecomposition::usage = "CholeskyDecomposition[m] gives the Cholesky decomposition of a matrix m."
Chop::usage = "Chop[expr] replaces approximate real numbers in expr that are close to zero by the exact integer 0."
Circle::usage = "Circle[{x, y}, r] is a two-dimensional graphics primitive that represents a circle of radius r centered at the point x, y. Circle[{x, y}, {rx, ry}] yields an ellipse with semi-axes rx and ry. Circle[{x, y}, r, {theta1, theta2}] represents a circular arc."
Clear::usage = "Clear[symbol1, symbol2, ... ] clears values and definitions for the symboli. Clear[\"form1\", \"form2\", ... ] clears values and definitions for all symbols whose names match any of the string patterns formi."
ClearAll::usage = "ClearAll[symb1, symb2, ... ] clears all values, definitions, attributes, messages and defaults associated with symbols. ClearAll[\"form1\", \"form2\", ... ] clears all symbols whose names textually match any of the formi."
ClearAttributes::usage = "ClearAttributes[s, attr] removes attr from the list of attributes of the symbol s."
ClebschGordan::usage = "ClebschGordan[{j1, m1}, {j2, m2}, {j, m}] gives the Clebsch-Gordan coefficient for the decomposition of |j, m> in terms of |j1, m1>|j2, m2>."
Clip::usage = "Clip[x] gives x clipped to be between -1 and +1. Clip[x, {min, max}] gives x for min \[LessEqual] x \[LessEqual] max, min for x < min and max for x > max. Clip[x, {min, max}, {vmin, vmax}] gives vmin for x < min and vmax for x > max."
ClipFill::usage = "ClipFill is an option for Plot3D and related functions that specifies how clipped parts of surfaces are to be drawn."
Close::usage = "Close[stream] closes a stream."
CMYKColor::usage = "CMYKColor[cyan, magenta, yellow, black] is a graphics directive which specifies that graphical objects which follow are to be displayed in the color given."
Coefficient::usage = "Coefficient[expr, form] gives the coefficient of form in the polynomial expr. Coefficient[expr, form, n] gives the coefficient of form^n in expr."
CoefficientArrays::usage = "CoefficientArrays[polys, vars] gives the arrays of coefficients of the variables vars in the polynomials polys."
CoefficientDomain::usage = "CoefficientDomain is an option for GroebnerBasis and PolynomialReduce. Valid choices are Integers, Rationals, RationalFunctions, or Polynomials[var]."
CoefficientList::usage = "CoefficientList[poly, var] gives a list of coefficients of powers of var in poly, starting with power 0. CoefficientList[poly, {var1, var2, ... }] gives an array of coefficients of the vari."
CofactorExpansion::usage = "CofactorExpansion is a possible value for the Method option in Inverse, LinearSolve, NullSpace, and RowReduce. Method -> CofactorExpansion will cause RowReduce and related functions to attempt to invert the leftmost n x n submatrix of a given matrix of n rows (if it has at least n columns), and to multiply by that inverse if it is exists. This will put the original matrix into reduced row-echelon form."
Collect::usage = "Collect[expr, x] collects together terms involving the same powers of objects matching x. Collect[expr, {x1, x2, ... }] collects together terms that involve the same powers of objects matching x1, x2, ... . Collect[expr, var, h] applies h to the expression that forms the coefficient of each term obtained."
ColonForm::usage = "ColonForm[a,b] prints as a: b."
ColorFunction::usage = "ColorFunction is an option for graphics functions which specifies a function to apply to determine colors of elements."
ColorFunctionScaling::usage = "ColorFunctionScaling is an option for graphics functions which specifies whether arguments supplied to a color function should be scaled to lie between 0 and 1."
ColorOutput::usage = "ColorOutput is an option for graphics functions which specifies the type of color output to produce."
ColumnAlignments::usage = "ColumnAlignments is an option for GridBox which specifies how entries in each column should be aligned."
ColumnForm::usage = "ColumnForm[{e1, e2, ... }] prints as a column with e1 above e2, etc. ColumnForm[list, horiz] specifies the horizontal alignment of each element. ColumnForm[list, horiz, vert] also specifies the vertical alignment of the whole column."
ColumnLines::usage = "ColumnLines is an option for GridBox which specifies whether lines should be drawn between adjacent columns."
ColumnsEqual::usage = "ColumnsEqual is an option for GridBox which specifies whether all columns in the grid should be assigned equal width."
ColumnSpacings::usage = "ColumnSpacings is an option for GridBox which specifies the spaces in ems that should be inserted between adjacent columns."
ColumnWidths::usage = "ColumnWidths is an option for GridBox which specifies the widths of columns in ems."
Compile::usage = "Compile[{x1, x2, ... }, expr] creates a compiled function which evaluates expr assuming numerical values of the xi. Compile[{{x1, t1}, ... }, expr] assumes that xi is of a type which matches ti. Compile[{{x1, t1, n1}, ... }, expr] assumes that xi is a rank ni array of objects each of a type which matches ti. Compile[vars, expr, {{p1, pt1}, ... }] assumes that subexpressions in expr which match pi are of types which match pti."
Compiled::usage = "Compiled is an option for various numerical and plotting functions which specifies whether the expressions they work with should automatically be compiled."
CompiledFunction::usage = "CompiledFunction[args, argregs, nregs, instr, func] represents compiled code for evaluating a compiled function."
Complement::usage = "Complement[eall, e1, e2, ... ] gives the elements in eall which are not in any of the ei."
Complex::usage = "Complex is the head used for complex numbers."
Complexes::usage = "Complexes represents the domain of complex numbers, as in x \[Element] Complexes."
ComplexExpand::usage = "ComplexExpand[expr] expands expr assuming that all variables are real. ComplexExpand[expr, {x1, x2, ... }] expands expr assuming that variables matching any of the xi are complex."
ComplexInfinity::usage = "ComplexInfinity represents a quantity with infinite magnitude, but undetermined complex phase."
ComplexityFunction::usage = "ComplexityFunction is an option for Simplify and FullSimplify which gives a function to rank the complexity of different forms of an expression."
ComposeList::usage = "ComposeList[{f1, f2, ... }, x] generates a list of the form {x, f1[x], f2[f1[x]], ... }."
ComposeSeries::usage = "ComposeSeries[series1, series2, ... ] composes several power series."
Composition::usage = "Composition[f1, f2, f3, ... ] represents a composition of the functions f1, f2, f3, ... ."
CompoundExpression::usage = "expr1; expr2; ...  evaluates the expri in turn, giving the last one as the result."
Condition::usage = "patt /; test is a pattern which matches only if the evaluation of test yields True. lhs :> rhs /; test represents a rule which applies only if the evaluation of test yields True. lhs := rhs /; test is a definition to be used only if test yields True."
Conjugate::usage = "Conjugate[z] or  gives the complex conjugate of the complex number z."
ConjugateTranspose::usage = "ConjugateTranspose[m] or  gives the conjugate transpose of m."
Constant::usage = "Constant is an attribute which indicates zero derivative of a symbol with respect to all parameters."
Constants::usage = "Constants is an option for Dt which gives a list of objects to be taken as constants."
Context::usage = "Context[ ] gives the current context. Context[symbol] gives the context in which a symbol appears."
Contexts::usage = "Contexts[ ] gives a list of all contexts. Contexts[\"string\"] gives a list of the contexts which match the string."
ContextToFilename::usage = "ContextToFilename is an obsolete function, superseded by ContextToFileName. ContextToFilename[\"context`\"] gives the string specifying the file name that is by convention associated with a particular context."
ContextToFileName::usage = "ContextToFileName[\"context`\"] gives the string specifying the file name that is by convention associated with a particular context."
Continue::usage = "Continue[ ] exits to the nearest enclosing Do, For or While in a procedural program."
ContinuedFraction::usage = "ContinuedFraction[x, n] generates a list of the first n terms in the continued fraction representation of x. ContinuedFraction[x] generates a list of all terms that can be obtained given the precision of x."
ContourGraphics::usage = "ContourGraphics[array] is a representation of a contour plot."
ContourLines::usage = "ContourLines is an option for contour plots which specifies whether to draw explicit contour lines."
ContourPlot::usage = "ContourPlot[f, {x, xmin, xmax}, {y, ymin, ymax}] generates a contour plot of f as a function of x and y."
Contours::usage = "Contours is an option for contour plots that specifies the contours to draw."
ContourShading::usage = "ContourShading is an option for contour plots which specifies whether the regions between contour lines should be shaded."
ContourStyle::usage = "ContourStyle is an option for contour plots that specifies the style in which contour lines should be drawn."
ConversionOptions::usage = "ConversionOptions is an option to Import and Export. Use it to pass special options to a particular format. For example: Import[\"table.txt\", \"Table\", ConversionOptions -> {\"DebitMark\" -> \"DB\"}]."
ConversionRules::usage = "ConversionRules is an option for Cell which can be set to a list of rules specifying how the contents of the cell are to be converted to external formats."
ConvertToPostScriptPacket::usage = "ConvertToPostScriptPacket is an internal symbol used for formatting."
Copyable::usage = "Copyable is an option for Cell which specifies whether a cell can be copied interactively using the front end."
CopyDirectory::usage = "CopyDirectory[\"dir1\", \"dir2\"] copies the directory dir1 to dir2."
CopyFile::usage = "CopyFile[\"file1\", \"file2\"] copies file1 to file2."
Cos::usage = "Cos[z] gives the cosine of z."
Cosh::usage = "Cosh[z] gives the hyperbolic cosine of z."
CoshIntegral::usage = "CoshIntegral[z] gives the hyperbolic cosine integral Chi(z)."
CosIntegral::usage = "CosIntegral[z] gives the cosine integral function Ci(z)."
Cot::usage = "Cot[z] gives the cotangent of z."
Coth::usage = "Coth[z] gives the hyperbolic cotangent of z."
Count::usage = "Count[list, pattern] gives the number of elements in list that match pattern. Count[expr, pattern, levelspec] gives the total number of subexpressions matching pattern that appear at the levels in expr specified by levelspec."
CreateDirectory::usage = "CreateDirectory[\"dir\"] creates a directory."
Cross::usage = "Cross[a, b] gives the vector cross product of a and b."
Csc::usage = "Csc[z] gives the cosecant of z."
Csch::usage = "Csch[z] gives the hyperbolic cosecant of z."
Cuboid::usage = "Cuboid[{xmin, ymin, zmin}] is a three-dimensional graphics primitive that represents a unit cuboid, oriented parallel to the axes. Cuboid[{xmin, ymin, zmin}, {xmax, ymax, zmax}] specifies a cuboid by giving the coordinates of opposite corners."
Cyan::usage = "Cyan represents the color cyan in graphics or style specifications."
Cyclotomic::usage = "Cyclotomic[n, x] gives the cyclotomic polynomial of order n in x."
CylindricalDecomposition::usage = "CylindricalDecomposition[ineqs, {x1, x2, ... }] finds a decomposition of the region represented by the inequalities ineqs into cylindrical parts whose directions correspond to the successive xi."
D::usage = "D[f, x] gives the partial derivative of f with respect to x. D[f, {x, n}] gives the nth partial derivative of f with respect to x. D[f, x1, x2, ... ] gives a mixed derivative."
DampingFactor::usage = "DampingFactor is an option for FindRoot, which can be used to control convergence behavior. DampingFactor -> n uses a damping factor of n in Newton's method."
Dashing::usage = "Dashing[{r1, r2, ... }] is a two-dimensional graphics directive which specifies that lines which follow are to be drawn dashed, with successive segments of lengths r1, r2, ...  (repeated cyclically). The ri is given as a fraction of the total width of the graph."
Date::usage = "Date[ ] gives the current local date and time in the form {year, month, day, hour, minute, second}."
Debug::usage = "Debug is an obsolete function, superseded by Trace. Debug[expr] evaluates expr, allowing you to stop at certain points in some control structures, and see what's happening or run commands. Debug[expr, {f1, f2, ...}] stops only in evaluation of the functions fi (and everything they call)."
Decimal::usage = "Decimal is a setting for the ColumnAlignments options of GridBox which states that numbers should align along the decimal place."
DeclarePackage::usage = "DeclarePackage[\"context`\", {\"name1\", \"name2\", ... }] declares that Needs[\"context`\"] should automatically be executed if a symbol with any of the specified names is ever used."
Decompose::usage = "Decompose[poly, x] decomposes a polynomial, if possible, into a composition of simpler polynomials."
Decrement::usage = "x-- decreases the value of x by 1, returning the old value of x."
DedekindEta::usage = "DedekindEta[t] gives the Dedekind eta modular elliptic function."
Default::usage = "Default[f], if defined, gives the default value for arguments of the function f obtained with a _. pattern object. Default[f, i] gives the default value to use when _. appears as the ith argument of f. Default[f, i, n] gives the default value for the ith argument out of a total of n arguments."
DefaultColor::usage = "DefaultColor is an option for graphics functions which specifies the default color to use for lines, points, etc."
DefaultDuplicateCellStyle::usage = "DefaultDuplicateCellStyle is an option for Notebook which specifies the default style to use for cells created by automatic duplication of other cells in the notebook."
DefaultFont::usage = "As of Version 3, DefaultFont has been superseded by TextStyle. DefaultFont is an option for graphics functions which specifies the default font to use for text."
DefaultNewCellStyle::usage = "DefaultNewCellStyle is an option for Notebook which specifies the default style to use for new cells created in the notebook."
DefaultValues::usage = "DefaultValues[f] gives a list of transformation rules corresponding to all defaults (values for Default[f[x,..],..], etc.) defined for the symbol f."
Definition::usage = "Definition[symbol] prints as the definitions given for a symbol."
Degree::usage = "Degree gives the number of radians in one degree. It has a numerical value of Pi/180."
DegreeLexicographic::usage = "DegreeLexicographic is a setting for the MonomialOrder option of GroebnerBasis and PolynomialReduce."
DegreeReverseLexicographic::usage = "DegreeReverseLexicographic is a setting for the MonomialOrder option of GroebnerBasis and PolynomialReduce."
Deletable::usage = "Deletable is an option for Cell which specifies whether the cell can be deleted interactively using the front end."
Delete::usage = "Delete[expr, n] deletes the element at position n in expr. If n is negative, the position is counted from the end. Delete[expr, {i, j, ... }] deletes the part at position {i, j, ... }. Delete[expr, {{i1, j1, ... }, {i2, j2, ... }, ... }] deletes parts at several positions."
DeleteCases::usage = "DeleteCases[expr, pattern] removes all elements of expr which match pattern. DeleteCases[expr, pattern, levspec] removes all parts of expr on levels specified by levspec which match pattern. DeleteCases[expr, pattern, levspec, n] removes the first n parts of expr which match pattern."
DeleteContents::usage = "DeleteContents is an option to DeleteDirectory. DeleteContents -> True deletes the directory and all files and directories it contains. DeleteContents -> False deletes the directory only if it contains no files."
DeleteDirectory::usage = "DeleteDirectory[\"dir\"] deletes the specified directory."
DeleteFile::usage = "DeleteFile[\"file\"] deletes a file. DeleteFile[{\"file1\", \"file2\", ... }] deletes a list of files."
DeletionWarning::usage = "DeletionWarning is an option to TagBox which determines whether the user will be warned about deleting the TagBox. This is useful if the TagBox expression is important for Mathematica to be able to FromBoxForm the expression correctly, and the user should know that deleting the TagBox could make a change in the result of FromBoxForm. The default value of DeletionWarning is None."
DelimiterFlashTime::usage = "DelimiterFlashTime is an option for cells and notebooks which specifies how long in seconds a delimiter should flash for when its matching delimiter is entered."
Delimiters::usage = "Delimiters is an option to Splice that specifies the delimiters to look for. The default is Delimiters -> {\"<*\", \"*>\"}."
Denominator::usage = "Denominator[expr] gives the denominator of expr."
DensityGraphics::usage = "DensityGraphics[array] is a representation of a density plot."
DensityPlot::usage = "DensityPlot[f, {x, xmin, xmax}, {y, ymin, ymax}] makes a density plot of f as a function of x and y."
Depth::usage = "Depth[expr] gives the maximum number of indices needed to specify any part of expr, plus one."
Derivative::usage = "f' represents the derivative of a function f of one argument. Derivative[n1, n2, ... ][f] is the general form, representing a function obtained from f by differentiating n1 times with respect to the first argument, n2 times with respect to the second argument, and so on."
Det::usage = "Det[m] gives the determinant of the square matrix m."
Developer`BesselSimplify::usage = "BesselSimplify[expr] transforms Bessel functions in expr, trying to either decrease the number of Bessel functions, or convert Bessel functions into more elementary functions."
Developer`BitLength::usage = "BitLength[n] gives the number of binary bits necessary to represent the integer n."
Developer`BitShiftLeft::usage = "BitShiftLeft[n, d] shifts the binary bits in the integer n to the left by d places, padding with zeros on the right."
Developer`BitShiftRight::usage = "BitShiftRight[n, d] shifts the binary bits in the integer n to the right by d places, dropping bits that are shifted past the units position on the right."
Developer`ClearCache::usage = "ClearCache[ ] clears internal caches of stored results."
Developer`ClipboardNotebook::usage = "ClipboardNotebook[ ] gives the notebook object corresponding to the invisible notebook corresponding to the clipboard for copy and paste operations."
Developer`FibonacciSimplify::usage = "FibonacciSimplify[expr, assum] tries to simplify combinations of symbolic Fibonacci numbers in expr using assumptions assum."
Developer`FileInformation::usage = "FileInformation[\"name\"] gives information about the file with the specified name."
Developer`FromPackedArray::usage = "FromPackedArray[expr] unpacks expr so that its internal representation is not a packed array."
Developer`GammaSimplify::usage = "GammaSimplify[expr] transforms gamma functions in expr, trying to either decrease the number of gamma functions, or convert combinations of them into more elementary functions."
Developer`HelpBrowserNotebook::usage = "HelpBrowserNotebook[ ] gives the notebook object corresponding to the notebook portion of the Help Browser window."
Developer`HermiteNormalForm::usage = "HermiteNormalForm[m] gives the Hermite normal form of an integer matrix m."
Developer`MachineIntegerQ::usage = "MachineIntegerQ[expr] returns True if expr corresponds to a machine-sized integer, and False otherwise."
Developer`MessagesNotebook::usage = "MessagesNotebook[ ] gives the notebook to which messages generated by the notebook front end will be sent."
Developer`NotebookConvert::usage = "NotebookConvert[\"name\"] converts a Mathematica notebook from a previous version of Mathematica to one for the current version."
Developer`NotebookInformation::usage = "NotebookInformation[obj] gives information about the notebook represented by the specified notebook object."
Developer`PackedArrayForm::usage = "PackedArrayForm[expr] prints with packed arrays in expr shown in summary form, without all of their elements explicitly given."
Developer`PackedArrayQ::usage = "PackedArrayQ[expr] returns True if expr is a packed array in its internal representation, and returns False otherwise. PackedArrayQ[expr, type] returns True if expr is a packed array of objects of the specified type. PackedArrayQ[expr, type, rank] returns True if expr is a packed array of the specified rank."
Developer`PartitionMap::usage = "PartitionMap[f, list, n] applies f to list after partitioning into non-overlapping sublists of length n. PartitionMap[f, list, n, d] applies f to sublists obtained by partitioning with offset d. PartitionMap[f, list, {n1, n2, ... }] applies f after partitioning a nested list into blocks of size n1 \[Cross] n2 \[Cross] \[Ellipsis] . PartitionMap[f, list, {n1, n2, ... }, {d1, d2, ... }] applies f after partitioning using offset di at level i. PartitionMap[f, list, n, d, {kL, kR}] specifies where sublists should begin and end. PartitionMap[f, list, n, d, {kL, kR}, padding] specifies what padding should be used."
Developer`PolyGammaSimplify::usage = "PolyGammaSimplify[expr] transforms polygamma functions in expr, trying to either decrease the number of polygamma functions, or convert combinations of them into more elementary functions."
Developer`PolyLogSimplify::usage = "PolyLogSimplify[expr] transforms polylogarithm functions in expr, trying to either decrease the number of polylogarithm functions, or convert combinations of them into more elementary functions."
Developer`PolynomialDivision::usage = "PolynomialDivision[p, q, x] gives a list of the quotient and remainder of p and q, treated as polynomials in x."
Developer`ReplaceAllUnheld::usage = "ReplaceAllUnheld[expr, rules] applies a rule or list of rules in an attempt to transform each subpart of expr that would be automatically evaluated."
Developer`ScaledVectorNorm::usage = "Developer`ScaledVectorNorm[p, {rtol, atol}][v, w] for real 1 <= p <= Infinity. rtol and atol are required to be real and >= 0. At least one of them must be > 0. Vectors v and w can be of any type." 
Developer`SetSystemOptions::usage = "SetSystemOptions[\"name\"->value] sets a specified system option."
Developer`SystemOptions::usage = "SystemOptions[ ] gives the current settings for all system options. SystemOptions[\"name\"] gives the current setting for the system option with the specified name."
Developer`ToPackedArray::usage = "ToPackedArray[expr] uses packed arrays if possible in the internal representation of expr."
Developer`TrigToRadicals::usage = "TrigToRadicals[expr] converts trigonometric functions to radicals whenever possible in expr."
Developer`ZeroQ::usage = "ZeroQ[expr] returns True if built-in transformations allow it to be determined that expr is numerically equal to zero, and returns False otherwise."
Developer`ZetaSimplify::usage = "ZetaSimplify[expr] transforms zeta functions in expr, trying to either decrease the number of zeta functions, or convert combinations of them into more elementary functions."
Developer`$MaxMachineInteger::usage = "$MaxMachineInteger gives the maximum integer that is represented internally as a single atomic data element on your computer system."
DiagonalMatrix::usage = "DiagonalMatrix[list] gives a matrix with the elements of list on the leading diagonal, and 0 elsewhere."
Dialog::usage = "Dialog[ ] initiates a dialog. Dialog[expr] initiates a dialog with expr as the current value of %."
DialogProlog::usage = "DialogProlog is an option for Dialog which can give an expression to evaluate before the dialog starts."
DialogSymbols::usage = "DialogSymbols is an option for Dialog which gives a list of symbols whose values should be localized in the dialog."
DifferenceOrder::usage = "DifferenceOrder is an option for NDSolve. For ordinary differential equations, it controls the order of the method used. If it is Automatic, methods with variable order may be used. For partial differential equations, it determines the order of finite difference approximations for spatial derivatives."
DigitBlock::usage = "DigitBlock is an option for NumberForm and related functions which specifies the maximum length of blocks of digits between breaks."
DigitCount::usage = "DigitCount[n, b, d] gives the number of d digits in the base b representation of n. DigitCount[n, b] gives a list of the numbers of 1, 2, \[Ellipsis], b - 1, 0 digits in the base b representation of n. DigitCount[n] gives a list of the numbers of 1, 2, \[Ellipsis], 9, 0 digits in the base 10 representation of n."
DigitQ::usage = "DigitQ[string] yields True if all the characters in the string are digits in the range 0 through 9, and yields False otherwise."
Dimensions::usage = "Dimensions[expr] gives a list of the dimensions of expr. Dimensions[expr, n] gives a list of the dimensions of expr down to level n."
DiracDelta::usage = "DiracDelta[x] represents the Dirac delta function \[Delta](x). DiracDelta[x1, x2, ... ] represents the multidimensional Dirac delta function \[Delta](x1, x2, \[Ellipsis])."
DirectedInfinity::usage = "DirectedInfinity[ ] represents an infinite numerical quantity whose direction in the complex plane is unknown. DirectedInfinity[z] represents an infinite numerical quantity that is a positive real multiple of the complex number z."
Direction::usage = "Direction is an option for Limit. Limit[expr, x -> x0, Direction -> 1] computes the limit as x approaches x0 from smaller values. Limit[expr, x -> x0, Direction -> -1] computes the limit as x approaches x0 from larger values. Direction -> Automatic uses Direction -> -1 except for limits at Infinity, where it is equivalent to Direction -> 1."
Directory::usage = "Directory[ ] gives the current working directory."
DirectoryName::usage = "DirectoryName[\"name\"] extracts the directory name from the specification for a file."
DirectoryStack::usage = "DirectoryStack[ ] gives the directory stack which represents the sequence of current directories used."
DiscreteDelta::usage = "DiscreteDelta[n1, n2, ... ] gives the discrete delta function \[Delta](n1, n2, \[Ellipsis]), equal to 1 if all the ni are zero, and 0 otherwise."
Disk::usage = "Disk[{x, y}, r] is a two-dimensional graphics primitive that represents a filled disk of radius r centered at the point x, y. Disk[{x, y}, {rx, ry}] yields an elliptical disk with semi-axes rx and ry. Disk[{x, y}, r, {theta1, theta2}] represents a segment of a disk."
Dispatch::usage = "Dispatch[{lhs1->rhs1, lhs2->rhs2, ... }] generates an optimized dispatch table representation of a list of rules. The object produced by Dispatch can be used to give the rules in expr /. rules."
Display::usage = "Display[channel, graphics] writes graphics or sound to the specified output channel in Mathematica PostScript format. Display[channel, graphics, \"format\"] writes graphics or sound in the specified format. Display[channel, expr, \"format\"] writes boxes, cells or notebook expressions in the specified format."
DisplayForm::usage = "DisplayForm[expr] prints with boxes inside expr shown in explicit two-dimensional or other form."
DisplayFunction::usage = "DisplayFunction is an option for graphics and sound functions that specifies a function to apply to graphics and sound objects in order to display them."
DisplayString::usage = "DisplayString[graphics] generates a string giving graphics or sound in Mathematica PostScript format. DisplayString[graphics, \"format\"] generates a string giving graphics or sound in the specified format. DisplayString[expr, \"format\"] generates a string giving boxes, cells or notebook expressions in the specified format."
Distribute::usage = "Distribute[f[x1, x2, ... ]] distributes f over Plus appearing in any of the xi. Distribute[expr, g] distributes over g. Distribute[expr, g, f] performs the distribution only if the head of expr is f."
Divide::usage = "x/y or Divide[x, y] is equivalent to x y^-1."
DivideBy::usage = "x /= c divides x by c and returns the new value of x."
DivisionFreeRowReduction::usage = "DivisionFreeRowReduction is a possible value for the Method options in Inverse, LinearSolve, NullSpace, and RowReduce. Method -> DivisionFreeRowReduction causes Gaussian elimination of symbolic matrices to initially clear denominators in each row and subsequently to not attempt to simplify pivots for row operations."
Divisors::usage = "Divisors[n] gives a list of the integers that divide n."
DivisorSigma::usage = "DivisorSigma[k, n] gives the sum of the kth powers of the positive divisors of n."
Do::usage = "Do[expr, {imax}] evaluates expr imax times. Do[expr, {i, imax}] evaluates expr with the variable i successively taking on the values 1 through imax (in steps of 1). Do[expr, {i, imin, imax}] starts with i = imin. Do[expr, {i, imin, imax, di}] uses steps di. Do[expr, {i, imin, imax}, {j, jmin, jmax}, ... ] evaluates expr looping over different values of j, etc. for each i."
DOSTextFormat::usage = "DOSTextFormat is an option for OpenRead, OpenWrite, and OpenAppend that specifies whether files should be opened in text mode. With DOSTextFormat -> True, Mathematica uses the normal text format for the type of computer on which Mathematica is running. Text mode typically entails translation of a text file's line-ending characters into the newline character \"\\n\". With DOSTextFormat -> False, files are opened in \"binary mode,\" in which no such translation is performed. On some systems, there is no difference between text mode and binary mode."
Dot::usage = "a.b.c or Dot[a, b, c] gives products of vectors, matrices and tensors."
DoubleExponential::usage = "DoubleExponential is a choice for the option Method of NIntegrate. Method -> DoubleExponential causes a doubly exponentially convergent algorithm to be used. For multi-dimensional integration, DoubleExponential refers to a Cartesian product of one-dimensional doubly exponentially convergent quadrature rules."
DoublyInfinite::usage = "DoublyInfinite is an option for LerchPhi. With DoublyInfinite -> True, the summation is taken from -Infinity to Infinity. With DoublyInfinite -> False, the summation is taken from zero to Infinity."
DownValues::usage = "DownValues[f] gives a list of transformation rules corresponding to all downvalues defined for the symbol f."
DragAndDrop::usage = "DragAndDrop is an option for Cell which specifies whether to allow drag-and-drop editing on the contents of the cell."
Drop::usage = "Drop[list, n] gives list with its first n elements dropped. Drop[list, -n] gives list with its last n elements dropped. Drop[list, {n}] gives list with its nth element dropped. Drop[list, {m, n}] gives list with elements m through n dropped. Drop[list, {m, n, s}] gives list with elements m through n in steps of s dropped. Drop[list, seq1, seq2, ... ] gives a nested list in which elements specified by seqi have been dropped at level i in list."
DSolve::usage = "DSolve[eqn, y, x] solves a differential equation for the function y, with independent variable x. DSolve[{eqn1, eqn2, ...  }, {y1, y2, ...  }, x] solves a list of differential equations. DSolve[eqn, y, {x1, x2, ... }] solves a partial differential equation."
DSolveConstants::usage = "DSolveConstants is an option to DSolve that determines the constants of integration which may be returned. The default is DSolveConstants -> C, which yields constants of integration C[1], C[2], ... ."
Dt::usage = "Dt[f, x] gives the total derivative of f with respect to x. Dt[f] gives the total differential of f. Dt[f, {x, n}] gives the nth total derivative of f with respect to x. Dt[f, x1, x2, ... ] gives a mixed total derivative."
DumpGet::usage = "DumpGet[ \"filename\"] reads in a file saved with DumpSave."
DumpSave::usage = "DumpSave[\"file.mx\", symbol] writes definitions associated with a symbol to a file in internal Mathematica format. DumpSave[\"file.mx\", \"context`\"] writes out definitions associated with all symbols in the specified context. DumpSave[\"file.mx\", {object1, object2, ... }] writes out definitions for several symbols or contexts. DumpSave[\"package`\", objects] chooses the name of the output file based on the computer system used."
E::usage = "E is the exponential constant e (base of natural logarithms), with numerical value approximately equal to 2.71828."
EdgeForm::usage = "EdgeForm[g] is a three-dimensional graphics directive which specifies that edges of polygons are to be drawn using the graphics directive or list of graphics directives g."
Edit::usage = "Edit[expr___] lets you edit the expressions expr."
Editable::usage = "Editable is an option for displayed objects, cells and notebooks which specifies whether their contents can be edited interactively using the front end."
EditDefinition::usage = "EditDefinition[syms___] lets you edit the rules attached to the symbols syms."
EditIn::usage = "EditIn[n__Integer] lets you edit input lines n. EditIn[] edits the previous input line."
Eigensystem::usage = "Eigensystem[m] gives a list {values, vectors} of the eigenvalues and eigenvectors of the square matrix m. Eigensystem[{m, a}] gives the generalized eigenvalues and eigenvectors of m with respect to a. Eigensystem[m, k] gives the eigenvalues and eigenvectors for the first k eigenvalues of m."
Eigenvalues::usage = "Eigenvalues[m] gives a list of the eigenvalues of the square matrix m. Eigenvalues[{m, a}] gives the generalized eigenvalues of m with respect to a. Eigenvalues[m, k] gives the first k eigenvalues of m."
Eigenvectors::usage = "Eigenvectors[m] gives a list of the eigenvectors of the square matrix m. Eigenvectors[{m, a}] gives the generalized eigenvectors of m with respect to a. Eigenvectors[m, k] gives the first k eigenvectors of m."
Element::usage = "Element[x, dom] asserts that x is an element of the domain dom. Element[{x1, x2, ... }, dom] asserts that all the xi are elements of dom. Element[patt, dom] asserts that any expression matching the pattern patt is an element of dom."
Eliminate::usage = "Eliminate[eqns, vars] eliminates variables between a set of simultaneous equations."
EliminationOrder::usage = "EliminationOrder is a setting for the MonomialOrder option of GroebnerBasis and PolynomialReduce."
EllipticE::usage = "EllipticE[m] gives the complete elliptic integral E(m). EllipticE[phi, m] gives the elliptic integral of the second kind E(phi|m)."
EllipticExp::usage = "EllipticExp[u, {a, b}] is the inverse for EllipticLog. It produces a list {x, y} such that u == EllipticLog[{x, y}, {a, b}]."
EllipticExpPrime::usage = "EllipticExpPrime[u, {a, b}] gives the derivative with respect to the first argument of EllipticExp[u, {a, b}]."
EllipticF::usage = "EllipticF[phi, m] gives the elliptic integral of the first kind F(phi|m)."
EllipticK::usage = "EllipticK[m] gives the complete elliptic integral of the first kind K(m)."
EllipticLog::usage = "EllipticLog[{x, y}, {a, b}] gives the generalized logarithm associated with the elliptic curve y^2 = x^3 + a x^2 + b x."
EllipticNomeQ::usage = "EllipticNomeQ[m] gives the nome q corresponding to the parameter m in an elliptic function."
EllipticPi::usage = "EllipticPi[n, m] gives the complete elliptic integral of the third kind Pi(n|m). EllipticPi[n, phi, m] gives the incomplete elliptic integral Pi(n; phi|m)."
EllipticReducedHalfPeriods::usage = "EllipticReducedHalfPeriods[{u, v}] gives a reduced pair of half periods {w, w'} corresponding to the same lattice as that of {u, v}."
EllipticTheta::usage = "EllipticTheta[a, u, q] gives the theta function theta_a(u, q) (where the index a is 1, 2, 3, or 4)."
EllipticThetaPrime::usage = "EllipticThetaPrime[a, u, q] gives the derivative with respect to u of the theta function EllipticTheta[a, u, q] (where the index a is 1, 2, 3, or 4)."
Encode::usage = "Encode[\"source\", \"dest\"] writes an encoded version of the file source to the file dest. <<dest decodes the file before reading its contents. Encode[\"source\", \"dest\", \"key\"] produces an encoded file which must be read in using Get[\"dest\", \"key\"]."
End::usage = "End[ ] returns the present context, and reverts to the previous one."
EndAdd::usage = "EndAdd[ ] returns the present context, and reverts to the previous one, prepending the present context to $ContextPath."
EndOfFile::usage = "EndOfFile is a symbol returned by Read when it reaches the end of a file."
EndPackage::usage = "EndPackage[ ] restores $Context and $ContextPath to their values before the preceding BeginPackage, and prepends the current context to the list $ContextPath."
EngineeringForm::usage = "EngineeringForm[expr] prints with all real numbers in expr given in engineering notation. EngineeringForm[expr, n] prints with numbers given to n-digit precision."
Environment::usage = "Environment[\"var\"] gives the value of an operating system environment variable."
Epilog::usage = "Epilog is an option for graphics functions which gives a list of graphics primitives to be rendered after the main part of the graphics is rendered."
Equal::usage = "lhs == rhs returns True if lhs and rhs are identical."
EqualColumns::usage = "EqualColumns is an option to GridBox which specifies whether the size of the columns are all set to the size of the largest column. The default value of EqualColumns is False."
EqualRows::usage = "EqualRows is an option to GridBox which specifies whether the size of the rows are all set to the size of the largest row. The default value of EqualRows is False."
EquatedTo::usage = "EquatedTo is an option for Roots, which specifies an expression to use in place of the variable in the solution."
Erf::usage = "Erf[z] gives the error function erf(z). Erf[z0, z1] gives the generalized error function erf(z1) - erf(z0)."
Erfc::usage = "Erfc[z] gives the complementary error function erfc(z)."
Erfi::usage = "Erfi[z] gives the imaginary error function erf(iz) / i."
ErrorBox::usage = "ErrorBox[boxes] represents boxes that cannot be interpreted in input or output."
EulerE::usage = "EulerE[n] gives the nth Euler number. EulerE[n, x] gives the nth Euler polynomial in x."
EulerGamma::usage = "EulerGamma is Euler's constant gamma, with numerical value approximately equal to 0.577216."
EulerPhi::usage = "EulerPhi[n] gives the Euler totient function."
Evaluatable::usage = "Evaluatable is an option for Cell which specifies whether a cell should be used as input to be evaluated by the Mathematica kernel."
Evaluate::usage = "Evaluate[expr] causes expr to be evaluated even if it appears as the argument of a function whose attributes specify that it should be held unevaluated."
EvaluationMonitor::usage = "EvaluationMonitor is an option for various numerical computation functions that gives an expression to evaluate whenever functions derived from the input are evaluated numerically."
EvaluationNotebook::usage = "EvaluationNotebook[ ] gives the notebook in which this function is being evaluated."
Evaluator::usage = "Evaluator is an option for Cell which gives the name of the kernel to use to evaluate the contents of a cell."
EvenQ::usage = "EvenQ[expr] gives True if expr is an even integer, and False otherwise."
ExactRootIsolation::usage = "ExactRootIsolation is an option for Root, which specifies whether exact isolating intervals rather then numeric approximations should be used to identify algebraic numbers."
Except::usage = "Except[c] is a pattern object which represents any expression except one that matches c. Except[c, p] represents any expression that matches p but not c."
ExcludedForms::usage = "ExcludedForms is an option for FullSimplify which can be set to a list of patterns for expressions that should not be touched if they are encountered at intermediate steps in the operation of FullSimplify."
Exists::usage = "Exists[x, expr] represents the statement that there exists a value of x for which expr is True. Exists[x, cond, expr] states that there exists an x satisfying the condition cond for which expr is True. Exists[{x1, x2, ... }, expr] states that there exist values for all the xi for which expr is True."
Exit::usage = "Exit[ ] terminates a Mathematica kernel session."
ExitDialog::usage = "ExitDialog[expr] returns the value expr from the current Dialog. ExitDialog[ ] returns the value Null."
Exp::usage = "Exp[z] is the exponential function."
Expand::usage = "Expand[expr] expands out products and positive integer powers in expr. Expand[expr, patt] leaves unexpanded any parts of expr that are free of the pattern patt."
ExpandAll::usage = "ExpandAll[expr] expands out all products and integer powers in any part of expr. ExpandAll[expr, patt] avoids expanding parts of expr that do not contain terms matching the pattern patt."
ExpandDenominator::usage = "ExpandDenominator[expr] expands out products and powers that appear as denominators in expr."
ExpandNumerator::usage = "ExpandNumerator[expr] expands out products and powers that appear in the numerator of expr."
Experimental`CompileEvaluate::usage = "CompileEvaluate[expr] compiles expr and then evaluates the resulting compiled code."
Experimental`ExistsRealQ::usage = "ExistsRealQ[ineqs, {x1, x2, ... }] tests whether there exist real values of the xi for which the inequalities and equations ineqs are satisfied."
Experimental`ExportObject::usage = "ExportObject[format] is an object that represents the function of an exported format."
Experimental`FileBrowse::usage = "FileBrowse[ ] brings up a file browser to pick the name of a file."
Experimental`ForAllRealQ::usage = "ForAllRealQ[ineqs, {x1, x2, ... }] tests whether for all real values of the xi the inequalities and equations ineqs are satisfied."
Experimental`ImpliesQ::usage = "ImpliesQ[expr1, expr2] tests whether the expression expr1 implies expr2."
Experimental`ImpliesRealQ::usage = "ImpliesRealQ[ineqs1, ineqs2] tests whether the inequalities and equations ineqs1 imply the ineqs2 for all real values of all variables."
Experimental`ImportObject::usage = "ImportObject[format] is an object that represents the function of an imported format."
Experimental`RegisterConverter::usage = "RegisterConverter[mode, format, extensions, source, function] registers the Import or Export format. Default file extensions are used. The source code can be either the name of a MathLink executable, a context name, a package name, or the symbol None. The function is either the handle to the MathLink code, or the name of a user-defined Mathematica function."
Experimental`ValueFunction::usage = "ValueFunction[symb] represents a function to be applied whenever the symbol symb gets a new value."
Experimental`$BinaryExportFormats::usage = "$BinaryExportFormats gives a list of possible BinaryExport formats."
Experimental`$BinaryImportFormats::usage = "$BinaryImportFormats gives a list of possible BinaryImport formats."
Experimental`$EqualTolerance::usage = "$EqualTolerance gives the number of decimal digits by which two numbers can disagree and still be considered equal according to Equal."
Experimental`$SameQTolerance::usage = "$SameQTolerance gives the number of decimal digits by which two numbers can disagree and still be considered the same according to SameQ."
ExpIntegralE::usage = "ExpIntegralE[n, z] gives the exponential integral function E(n, z)."
ExpIntegralEi::usage = "ExpIntegralEi[z] gives the exponential integral function Ei(z)."
Exponent::usage = "Exponent[expr, form] gives the maximum power with which form appears in the expanded form of expr. Exponent[expr, form, h] applies h to the set of exponents with which form appears in expr."
ExponentFunction::usage = "ExponentFunction is an option for NumberForm and related functions which determines the exponent to use in printing approximate real numbers."
ExponentStep::usage = "(Obsolete: see ExponentFunction) ExponentStep is an option for NumberForm and related functions, which determines the interval between possible exponents to use when printing approximate real numbers."
Export::usage = "Export[\"file.ext\", expr] exports data to a file, converting it to a format corresponding to the file extension ext. Export[\"file\", expr, \"format\"] exports data to a file, converting it to the specified format."
ExportString::usage = "ExportString[expr, \"format\"] generates a string corresponding to expr exported in the specified format."
Expression::usage = "Expression is a symbol that represents an ordinary Mathematica expression in Read and related functions."
ExpToTrig::usage = "ExpToTrig[expr] converts exponentials in expr to trigonometric functions."
ExtendedGCD::usage = "ExtendedGCD[n1, n2, ... ] gives the extended greatest common divisor of the integers ni."
Extension::usage = "Extension is an option for Factor, PolynomialGCD and related functions which specifies what algebraic numbers to allow in the coefficients of resulting polynomials."
Extract::usage = "Extract[expr, list] extracts the part of expr at the position specified by list. Extract[expr, {list1, list2, ... }] extracts a list of parts of expr. Extract[expr, ... , h] extracts parts of expr, wrapping each of them with head h before evaluation."
FaceForm::usage = "FaceForm[gf, gb] is a three-dimensional graphics directive which specifies that the front faces of polygons are to be drawn with the graphics primitive gf, and the back faces with gb."
FaceGrids::usage = "FaceGrids is an option for three-dimensional graphics functions that specifies grid lines to draw on the faces of the bounding box."
Factor::usage = "Factor[poly] factors a polynomial over the integers. Factor[poly, Modulus->p] factors a polynomial modulo a prime p. Factor[poly, Extension->{a1, a2, ... }] factors a polynomial allowing coefficients that are rational combinations of the algebraic numbers ai."
Factorial::usage = "n! gives the factorial of n."
Factorial2::usage = "n!! gives the double factorial of n."
FactorInteger::usage = "FactorInteger[n] gives a list of the prime factors of the integer n, together with their exponents."
FactorList::usage = "FactorList[poly] gives a list of the factors of a polynomial, together with their exponents."
FactorSquareFree::usage = "FactorSquareFree[poly] pulls out any multiple factors in a polynomial."
FactorSquareFreeList::usage = "FactorSquareFreeList[poly] gives a list of square-free factors of a polynomial, together with their exponents."
FactorTerms::usage = "FactorTerms[poly] pulls out any overall numerical factor in poly. FactorTerms[poly, x] pulls out any overall factor in poly that does not depend on x. FactorTerms[poly, {x1, x2, ... }] pulls out any overall factor in poly that does not depend on any of the xi."
FactorTermsList::usage = "FactorTermsList[poly, {x1, x2, ... }] gives a list of factors of poly. The first element in the list is the overall numerical factor. The second element is a factor that does not depend on any of the xi. Subsequent elements are factors which depend on progressively more of the xi."
False::usage = "False is the symbol for the Boolean value false."
Fibonacci::usage = "Fibonacci[n] gives the nth Fibonacci number. Fibonacci[n, x] gives the nth Fibonacci polynomial, using x as the variable."
FileByteCount::usage = "FileByteCount[\"file\"] gives the number of bytes in a file."
FileDate::usage = "FileDate[\"file\"] gives the date and time at which a file was last modified."
FileInformation::usage = "FileInformation[file] gives information about a file."
FileNames::usage = "FileNames[ ] lists all files in the current working directory. FileNames[\"form\"] lists all files in the current working directory whose names match the string pattern form. FileNames[{\"form1\", \"form2\", ... }] lists all files whose names match any of the formi. FileNames[forms, {\"dir1\", \"dir2\", ... }] lists files with names matching forms in any of the directories diri. FileNames[forms, dirs, n] includes files that are in subdirectories up to n levels down."
FileType::usage = "FileType[\"file\"] gives the type of a file, typically File, Directory or None."
Find::usage = "Find[stream, \"text\"] finds the first line in an input stream that contains the specified string. Find[stream, {\"text1\", \"text2\", ... }] finds the first line that contains any of the specified strings."
FindFit::usage = "FindFit[data, expr, pars, vars] finds numerical values of the parameters pars that make expr give a best fit to data as a function of vars. The data can have the form {{x1, y1, ... , f1}, {x2, y2, ... , f2}, ... }, where the number of coordinates x, y, ...  is equal to the number of variables in the list vars. The data can also be of the form {f1, f2, ... }, with a single coordinate assumed to take values 1, 2, ... ."
FindInstance::usage = "FindInstance[expr, vars] finds an instance of vars that makes the statement expr be True. FindInstance[expr, vars, dom] finds an instance over the domain dom. Common choices of dom are Complexes, Reals, Integers and Booleans. FindInstance[expr, vars, dom, n] finds n instances."
FindList::usage = "FindList[\"file\", \"text\"] gives a list of lines in the file that contain the specified string. FindList[\"file\", {\"text1\", \"text2\", ... }] gives a list of all lines that contain any of the specified strings. FindList[{\"file1\", ... }, ... ] gives a list of lines containing the specified strings in any of the filei. FindList[files, text, n] includes only the first n lines found."
FindMaximum::usage = "FindMaximum[f, {x, x0}] searches for a local maximum in f, starting from the point x = x0. FindMaximum[f, {{x, x0}, {y, y0}, ... }] searches for a local maximum in a function of several variables."
FindMinimum::usage = "FindMinimum[f, {x, x0}] searches for a local minimum in f, starting from the point x=x0. FindMinimum[f, {{x, x0}, {y, y0}, ... }] searches for a local minimum in a function of several variables."
FindRoot::usage = "FindRoot[lhs==rhs, {x, x0}] searches for a numerical solution to the equation lhs==rhs, starting with x=x0. FindRoot[{eqn1, eqn2, ... }, {{x, x0}, {y, y0}, ... }] searches for a numerical solution to the simultaneous equations eqni."
First::usage = "First[expr] gives the first element in expr."
Fit::usage = "Fit[data, funs, vars] finds a least-squares fit to a list of data as a linear combination of the functions funs of variables vars. The data can have the form {{x1, y1, ... , f1}, {x2, y2, ... , f2}, ... }, where the number of coordinates x, y, ...  is equal to the number of variables in the list vars. The data can also be of the form {f1, f2, ... }, with a single coordinate assumed to take values 1, 2, ... . The argument funs can be any list of functions that depend only on the objects vars."
FixedPoint::usage = "FixedPoint[f, expr] starts with expr, then applies f repeatedly until the result no longer changes."
FixedPointList::usage = "FixedPointList[f, expr] generates a list giving the results of applying f repeatedly, starting with expr, until the results no longer change."
Flat::usage = "Flat is an attribute that can be assigned to a symbol f to indicate that all expressions involving nested functions f should be flattened out. This property is accounted for in pattern matching."
Flatten::usage = "Flatten[list] flattens out nested lists. Flatten[list, n] flattens to level n. Flatten[list, n, h] flattens subexpressions with head h."
FlattenAt::usage = "FlattenAt[list, n] flattens out a sublist that appears as the nth element of list. If n is negative, the position is counted from the end. FlattenAt[expr, {i, j, ... }] flattens out the part of expr at position {i, j, ... }. FlattenAt[expr, {{i1, j1, ... }, {i2, j2, ... }, ... }] flattens out parts of expr at several positions."
Floor::usage = "Floor[x] gives the greatest integer less than or equal to x."
Fold::usage = "Fold[f, x, list] gives the last element of FoldList[f, x, list]."
FoldList::usage = "FoldList[f, x, {a, b, ... }] gives {x, f[x, a], f[f[x, a], b], ... }."
FontColor::usage = "FontColor is an option for Cell, StyleBox and StyleForm which specifies the default color in which to render text."
FontFamily::usage = "FontFamily is an option for Cell, StyleBox and StyleForm which specifies the font family in which text should be rendered."
FontForm::usage = "FontForm is an obsolete function, superseded by StyleForm. FontForm[expr, {\"font\", size}] specifies that expr should be printed in the specified font and size."
FontName::usage = "FontName is an option to StyleBox which changes the current font family and face. A sample specification of FontName is FontName -> Times-Roman. The default value of FontName is Automatic."
FontPostScriptName::usage = "FontPostScriptName is an option to StyleBox which changes the current font. A sample specification is FontPostScriptName -> Times-Roman. The default value is Automatic."
FontSize::usage = "FontSize is an option for Cell, StyleBox and StyleForm which specifies the default size in printer's points of the font in which to render text."
FontSlant::usage = "FontSlant is an option for Cell, StyleBox and StyleForm which specifies how slanted the characters should be in text in the cell."
FontSubstitutions::usage = "FontSubstitutions is an option for Cell, StyleBox and StyleForm which gives a list of substitutions to try for font family names."
FontTracking::usage = "FontTracking is an option for Cell, StyleBox and StyleForm which specifies how condensed or expanded you want the font in which text is rendered to be."
FontWeight::usage = "FontWeight is an option for Cell, StyleBox and StyleForm which specifies how heavy the characters in a font should be."
For::usage = "For[start, test, incr, body] executes start, then repeatedly evaluates body and incr until test fails to give True."
ForAll::usage = "ForAll[x, expr] represents the statement that expr is True for all values of x. ForAll[x, cond, expr] states that expr is True for all x satisfying the condition cond. ForAll[{x1, x2, ... }, expr] states that expr is True for all values of all the xi."
Format::usage = "Format[expr] prints as the formatted form of expr. Assigning values to Format[expr] defines print forms for expressions. Format[expr, form] gives a format for the specified form of output."
FormatType::usage = "FormatType is an option for output streams, graphics and functions such as Text which specifies the default format type to use when outputting expressions."
FormatValues::usage = "FormatValues[f] gives a list of transformation rules corresponding to all printing formats (values for Format[f[x,..],..], etc.) defined for the symbol f."
FormBox::usage = "FormBox[boxes, form] displays as boxes but specifies that rules associated with form should be used to interpret boxes on input."
FortranForm::usage = "FortranForm[expr] prints as a Fortran language version of expr."
Fourier::usage = "Fourier[list] finds the discrete Fourier transform of a list of complex numbers."
FourierCosTransform::usage = "FourierCosTransform[expr, t, \[Omega]] gives the symbolic Fourier cosine transform of expr. FourierCosTransform[expr, {t1, t2, ... }, {\[Omega]1, \[Omega]2, ... }] gives the multidimensional Fourier cosine transform of expr."
FourierParameters::usage = "FourierParameters is an option to Fourier transform functions that specifies the convention to follow for the overall constant and the frequency constant. For FourierParameters -> {a, b}, FourierTransform[expr, t, w] is equivalent to Sqrt[Abs[b]/((2 Pi)^(1-a))] Integrate[expr Exp[I b w t], {t,-Infinity,Infinity}]."
FourierSinTransform::usage = "FourierSinTransform[expr, t, \[Omega]] gives the symbolic Fourier sine transform of expr. FourierSinTransform[expr, {t1, t2, ... }, {\[Omega]1, \[Omega]2, ... }] gives the multidimensional Fourier sine transform of expr."
FourierTransform::usage = "FourierTransform[expr, t, \[Omega]] gives the symbolic Fourier transform of expr. FourierTransform[expr, {t1, t2, ... }, {\[Omega]1, \[Omega]2, ... }] gives the multidimensional Fourier transform of expr."
FractionalPart::usage = "FractionalPart[x] gives the fractional part of x."
FractionBox::usage = "FractionBox[x, y] represents x/y in input and output."
Frame::usage = "Frame is an option for two-dimensional graphics functions which specifies whether a frame should be drawn around the plot."
FrameBox::usage = "FrameBox[box] displays with a frame drawn around box."
FrameLabel::usage = "FrameLabel is an option for two-dimensional graphics functions that specifies labels to be placed on the edges of a frame around a plot."
FrameStyle::usage = "FrameStyle is an option for two-dimensional graphics functions that specifies how the edges of a frame should be rendered."
FrameTicks::usage = "FrameTicks is an option for two-dimensional graphics functions that specifies tick marks for the edges of a frame."
FreeQ::usage = "FreeQ[expr, form] yields True if no subexpression in expr matches form, and yields False otherwise. FreeQ[expr, form, levelspec] tests only those parts of expr on levels specified by levelspec."
FresnelC::usage = "FresnelC[z] gives the Fresnel integral C(z)."
FresnelS::usage = "FresnelS[z] gives the Fresnel integral S(z)."
FromCharacterCode::usage = "FromCharacterCode[n] gives a string consisting of the character with integer code n. FromCharacterCode[{n1, n2, ... }] gives a string consisting of the sequence of characters with codes ni. FromCharacterCode[{{n11, n12, ... }, {n21, ... }, ... }] gives a list of strings. FromCharacterCode[ ... , \"encoding\"] uses the specified character encoding."
FromContinuedFraction::usage = "FromContinuedFraction[list] reconstructs a number from the list of its continued fraction terms."
FromDate::usage = "FromDate[date] converts a date of the form {y, m, d, h, m, s} to an absolute number of seconds since the beginning of January 1, 1900."
FromDigits::usage = "FromDigits[list] constructs an integer from the list of its decimal digits. FromDigits[list, b] takes the digits to be given in base b."
FrontEndExecute::usage = "FrontEndExecute[expr] sends expr to be executed by the Mathematica front end."
FullAxes::usage = "FullAxes[graphics] returns the axes options of a graphics object."
FullDefinition::usage = "FullDefinition[symbol] prints as the definitions given for symbol, and all symbols on which these depend."
FullForm::usage = "FullForm[expr] prints as the full form of expr, with no special syntax."
FullGraphics::usage = "FullGraphics[g] takes a graphics object, and generates a new one in which objects specified by graphics options are given as explicit lists of graphics primitives."
FullOptions::usage = "FullOptions[expr] gives the full settings of options explicitly specified in an expression such as a graphics object. FullOptions[expr, name] gives the full setting for the option name. FullOptions[expr, {name1, name2, ... }] gives a list of the full settings for the options namei. FullOptions[object] gives the full settings for options associated with an external object such as a NotebookObject."
FullSimplify::usage = "FullSimplify[expr] tries a wide range of transformations on expr involving elementary and special functions, and returns the simplest form it finds. FullSimplify[expr, assum] does simplification using assumptions."
Function::usage = "Function[body] or body& is a pure function. The formal parameters are # (or #1), #2, etc. Function[x, body] is a pure function with a single formal parameter x. Function[{x1, x2, ... }, body] is a pure function with a list of formal parameters."
FunctionExpand::usage = "FunctionExpand[expr] tries to expand out special and certain other functions in expr, when possible reducing compound arguments to simpler ones. FunctionExpand[expr, assum] expands using assumptions."
FunctionInterpolation::usage = "FunctionInterpolation[expr, {x, xmin, xmax}] evaluates expr with x running from xmin to xmax and constructs an InterpolatingFunction object which represents an approximate function corresponding to the result. FunctionInterpolation[expr, {x, xmin, xmax}, {y, ymin, ymax}, ... ] constructs an InterpolatingFunction object with several arguments."
Gamma::usage = "Gamma[z] is the Euler gamma function. Gamma[a, z] is the incomplete gamma function. Gamma[a, z0, z1] is the generalized incomplete gamma function Gamma[a, z0] - Gamma[a, z1]."
GammaRegularized::usage = "GammaRegularized[a, z] is the regularized incomplete gamma function Q(a, z)."
GaussianIntegers::usage = "GaussianIntegers is an option for FactorInteger, PrimeQ, Factor and related functions which specifies whether factorization should be done over Gaussian integers."
GaussKronrod::usage = "GaussKronrod is a choice for the option Method of NIntegrate. Method -> GaussKronrod causes adaptive Gauss-Kronrod quadrature to be used. For multi-dimensional integration, GaussKronrod refers to a Cartesian product of one-dimensional Gauss-Kronrod quadrature rules."
GaussPoints::usage = "GaussPoints is an option for NIntegrate. With GaussPoints -> n, the Gaussian part of Gauss-Kronrod quadrature uses n points. With GaussPoints -> Automatic, an internal algorithm chooses the number of points."
GCD::usage = "GCD[n1, n2, ... ] gives the greatest common divisor of the integers ni."
Gear::usage = "Gear is a choice for the option Method of NDSolve. Method -> Gear is a backwards differentiation method specifically for stiff equations."
GegenbauerC::usage = "GegenbauerC[n, m, x] gives the n-th Gegenbauer polynomial in x for parameter m. GegenbauerC[n, x] gives the renormalized form Limit[ GegenbauerC[n, m, x]/m, m->0]."
General::usage = "General is a symbol to which general system messages are attached."
GenerateConditions::usage = "GenerateConditions is an option for Integrate that specifies whether explicit conditions on parameters should be generated in the results of definite integrals."
GeneratedCell::usage = "GeneratedCell is an option for Cell which indicates whether the cell was generated from the kernel."
GeneratedParameters::usage = "GeneratedParameters is an option which specifies how parameters generated to represent the results of various symbolic operations should be named."
Generic::usage = "Generic is a setting for the Mode option of Solve and related functions."
Get::usage = "<<name reads in a file, evaluating each expression in it, and returning the last one."
GetContext::usage = "GetContext[\"context`\"] loads the file named by ContextToFileName[\"context`\"], which gives the conventional filename for a package that defines \"context`\"."
Glaisher::usage = "Glaisher is Glaisher's constant with numerical value \[TildeEqual] 1.28243."
GoldenRatio::usage = "GoldenRatio is the golden ratio (1 + Sqrt[5])/2, with numerical value approximately equal to 1.61803."
Goto::usage = "Goto[tag] scans for Label[tag], and transfers control to that point."
Gradient::usage = "Gradient is an option for FindMinimum, which can be used to specify the gradient of the function whose minimum is being sought. With Gradient-> Automatic, the gradient is computed symbolically. A typical setting is Gradient -> {2 x, Sign[y]}. Gradient is also an allowed value for the Method option for FindMinimum."
Graphics::usage = "Graphics[primitives, options] represents a two-dimensional graphical image."
Graphics3D::usage = "Graphics3D[primitives, options] represents a three-dimensional graphical image."
GraphicsArray::usage = "GraphicsArray[{g1, g2, ... }] represents a row of graphics objects. GraphicsArray[{{g11, g12, ... }, ... }] represents a two-dimensional array of graphics objects."
GraphicsSpacing::usage = "GraphicsSpacing is an option for GraphicsArray which specifies the spacing between elements in the array."
Gray::usage = "Gray represents the color gray in graphics or style specifications."
GrayLevel::usage = "GrayLevel[level] is a graphics directive which specifies the gray-level intensity with which objects that follow should be displayed."
Greater::usage = "x > y yields True if x is determined to be greater than y. x1 > x2 > x3 yields True if the xi form a strictly decreasing sequence."
GreaterEqual::usage = "x >= y yields True if x is determined to be greater than or equal to y. x1 >= x2 >= x3 yields True if the xi form a non-increasing sequence."
Green::usage = "Green represents the color green in graphics or style specifications."
GridBaseline::usage = "GridBaseline is an option for GridBox which specifies where the baseline of the grid represented by the GridBox should be assumed to be."
GridBox::usage = "GridBox[{{box11, box12, ... }, {box21, box22, ... }, ... }] represents a two-dimensional grid of boxes or strings in input and output."
GridDefaultElement::usage = "GridDefaultElement is an option for GridBox which specifies what to insert when a new element is created interactively in a GridBox."
GridLines::usage = "GridLines is an option for two-dimensional graphics functions that specifies grid lines."
GroebnerBasis::usage = "GroebnerBasis[{poly1, poly2, ... }, {x1, x2, ... }] gives a list of polynomials that form a Groebner basis for the set of polynomials polyi. GroebnerBasis[{poly1, poly2, ... }, {x1, x2, ... }, {y1, y2, ... }] finds a Groebner basis in which the yi have been eliminated."
GroupPageBreakWithin::usage = "GroupPageBreakWithin is an option for Cell which specifies whether a page break should be allowed within the group of cells if the notebook that contains the group is printed."
HarmonicNumber::usage = "HarmonicNumber[n] gives the nth harmonic number Hn. HarmonicNumber[n, r] gives the harmonic number Hn(r) of order r."
HashTable::usage = "HashTable is a part of the object which is returned by Dispatch."
Head::usage = "Head[expr] gives the head of expr."
HeadCompose::usage = "HeadCompose[a, b, c, d] gives a[b][c][d]."
Heads::usage = "Heads is an option for functions which use level specifications that specifies whether heads of expressions should be included."
HeldPart::usage = "HeldPart[expr, pos] extracts the part or parts specified by pos, and wraps each of them in Hold. HeldPart[expr, i, j, ...] is an obsolete form, superseded by Extract[expr, {i, j, ...}, Hold]."
HermiteH::usage = "HermiteH[n, x] gives the n-th Hermite polynomial in x."
HessenbergDecomposition::usage = "HessenbergDecomposition[m] gives the Hessenberg decomposition of a matrix m."
HiddenSurface::usage = "HiddenSurface is an option for SurfaceGraphics which specifies whether hidden surfaces are to be eliminated."
Hold::usage = "Hold[expr] maintains expr in an unevaluated form."
HoldAll::usage = "HoldAll is an attribute which specifies that all arguments to a function are to be maintained in an unevaluated form."
HoldAllComplete::usage = "HoldAllComplete is an attribute which specifies that all arguments to a function are not to be modified or looked at in any way in the process of evaluation."
HoldComplete::usage = "HoldComplete[expr] shields expr completely from the standard Mathematica evaluation process, preventing even upvalues associated with expr from being used."
HoldFirst::usage = "HoldFirst is an attribute which specifies that the first argument to a function is to be maintained in an unevaluated form."
HoldForm::usage = "HoldForm[expr] prints as the expression expr, with expr maintained in an unevaluated form."
HoldPattern::usage = "HoldPattern[expr] is equivalent to expr for pattern matching, but maintains expr in an unevaluated form."
HoldRest::usage = "HoldRest is an attribute which specifies that all but the first argument to a function are to be maintained in an unevaluated form."
HomeDirectory::usage = "HomeDirectory[ ] gives your \"home\" directory."
HorizontalForm::usage = "HorizontalForm is an internal symbol used for formatting and printing."
HTMLSave::usage = "HTMLSave[\"file.html\"] saves an HTML version of the current input notebook in the front end. HTMLSave[\"file.html\", \"source.nb\"] saves an HTML version of the notebook from the file source.nb. HTMLSave[\"file.html\", notebook] saves an HTML version of the notebook corresponding to the specified notebook object."
Hue::usage = "Hue[h] is a graphics directive which specifies that objects which follow are to be displayed, if possible, in a color corresponding to hue h. Hue[h, s, b] specifies colors in terms of hue, saturation and brightness."
Hypergeometric0F1::usage = "Hypergeometric0F1[a, z] is the confluent hypergeometric function 0F1(; a; z)."
Hypergeometric0F1Regularized::usage = "Hypergeometric0F1Regularized[a, z] is the regularized confluent hypergeometric function Hypergeometric0F1[a, z]/Gamma[a]."
Hypergeometric1F1::usage = "Hypergeometric1F1[a, b, z] is the Kummer confluent hypergeometric function 1F1(a; b; z)."
Hypergeometric1F1Regularized::usage = "Hypergeometric1F1Regularized[a, b, z] is the regularized confluent hypergeometric function Hypergeometric1F1[a, b, z]/Gamma[b]."
Hypergeometric2F1::usage = "Hypergeometric2F1[a, b, c, z] is the hypergeometric function 2F1(a, b; c; z)."
Hypergeometric2F1Regularized::usage = "Hypergeometric2F1Regularized[a, b, c, z] is the regularized hypergeometric function Hypergeometric2F1[a, b, c, z]/Gamma[c]."
HypergeometricPFQ::usage = "HypergeometricPFQ[{a1, ... , ap}, {b1, ... , bq}, z] is the generalized hypergeometric function pFq(a; b; z)."
HypergeometricPFQRegularized::usage = "HypergeometricPFQRegularized[{a1, ... , ap}, {b1, ... , bq}, z] is the regularized generalized hypergeometric function HypergeometricPFQ[{a1, ... , ap}, {b1, ... , bq}, z]/(Gamma[b1] ... Gamma[bq])."
HypergeometricU::usage = "HypergeometricU[a, b, z] is the confluent hypergeometric function U(a, b, z)."
Hyphenation::usage = "Hyphenation is an option for Cell which specifies whether to allow hyphenation for words of text."
I::usage = "I represents the imaginary unit Sqrt[-1]."
Identity::usage = "Identity[expr] gives expr (the identity operation)."
IdentityMatrix::usage = "IdentityMatrix[n] gives the n by n identity matrix."
If::usage = "If[condition, t, f] gives t if condition evaluates to True, and f if it evaluates to False. If[condition, t, f, u] gives u if condition evaluates to neither True nor False."
IgnoreCase::usage = "IgnoreCase is an option for string manipulation and searching functions which specifies whether lower- and upper-case letters should be treated as equivalent."
Im::usage = "Im[z] gives the imaginary part of the complex number z."
ImageMargins::usage = "ImageMargins is an option for Cell which specifies the absolute margins in printer's points to leave around graphics in a cell."
ImageResolution::usage = "ImageResolution is an option for Export and Display which specifies at what resolution bitmap images should be rendered."
ImageRotated::usage = "ImageRotated is an option for Export and Display which specifies whether images should be rotated into landscape mode."
ImageSize::usage = "ImageSize is an option for Export, Display and other graphics functions, as well as for Cell, which specifies the absolute size of an image to render."
Implies::usage = "Implies[p, q] represents the logical implication p -> q."
Import::usage = "Import[\"file.ext\"] imports data from a file, assuming that it is in the format indicated by the file extension ext, and converts it to a Mathematica expression. Import[\"file\", \"format\"] imports data in the specified format from a file."
ImportString::usage = "ImportString[\"data\", \"format\"] imports data in the specified format from a string."
In::usage = "In[n] is a global object that is assigned to have a delayed value of the nth input line."
IncludeSingularTerm::usage = "IncludeSingularTerm is an option for LerchPhi and Zeta. With IncludeSingularTerm -> True, terms involving ((k + a)^2)^(-s/2) with k + a == 0 are included. With IncludeSingularTerm -> False, they are not."
Increment::usage = "x++ increases the value of x by 1, returning the old value of x."
Indeterminate::usage = "Indeterminate is a symbol that represents a numerical quantity whose magnitude cannot be determined."
Inequality::usage = "Inequality represents a sequence of relational statements."
InexactNumbers::usage = "InexactNumbers is a setting for the CoefficientDomain option of GroebnerBasis and PolynomialReduce."
Infinity::usage = "Infinity is a symbol that represents a positive infinite quantity."
Infix::usage = "Infix[f[e1, e2, ... ]] prints with f[e1, e2, ... ] given in default infix form: e1 ~ f ~ e2 ~ f ~ e3 ... . Infix[expr, h] prints with arguments separated by h: e1 h e2 h e3 ... ."
Information::usage = "Information[symbol] prints information about a symbol."
InitializationCell::usage = "InitializationCell is an option for Cell which specifies whether the cell should automatically be sent for evaluation by the Mathematica kernel when the notebook that contains it is opened."
Inner::usage = "Inner[f, list1, list2, g] is a generalization of Dot in which f plays the role of multiplication and g of addition."
Input::usage = "Input[ ] interactively reads in one Mathematica expression. Input[\"prompt\"] requests input, using the specified string as a prompt."
InputAliases::usage = "InputAliases is an option for cells and notebooks which specifies additional name aliases to be allowed on input."
InputAutoReplacements::usage = "InputAutoReplacements is an option for cells and notebooks which specifies strings of characters that should be replaced immediately on input."
InputForm::usage = "InputForm[expr] prints as a version of expr suitable for input to Mathematica."
InputNotebook::usage = "InputNotebook[ ] gives the current notebook into which keyboard input in the front end will be directed."
InputStream::usage = "InputStream[\"name\", n] is an object that represents an input stream for functions such as Read and Find."
InputString::usage = "InputString[ ] interactively reads in a character string. InputString[\"prompt\"] requests input, using the specified string as a prompt."
InputToBoxFormPacket::usage = "InputToBoxFormPacket is an internal symbol used for formatting."
Insert::usage = "Insert[list, elem, n] inserts elem at position n in list. If n is negative, the position is counted from the end. Insert[expr, elem, {i, j, ... }] inserts elem at position {i, j, ... } in expr. Insert[expr, elem, {{i1, j1, ... }, {i2, j2, ... }, ... }] inserts elem at several positions."
Install::usage = "Install[\"name\"] starts a MathLink-compatible external program and installs Mathematica definitions to call functions in it."
InString::usage = "InString[n] is a global object that is assigned to be the text of the nth input line."
Integer::usage = "Integer is the head used for integers."
IntegerDigits::usage = "IntegerDigits[n] gives a list of the decimal digits in the integer n. IntegerDigits[n, b] gives a list of the base-b digits in the integer n. IntegerDigits[n, b, len] pads the list on the left with zeros to give a list of length len."
IntegerExponent::usage = "IntegerExponent[n, b] gives the highest power of b that divides n."
IntegerPart::usage = "IntegerPart[x] gives the integer part of x."
IntegerQ::usage = "IntegerQ[expr] gives True if expr is an integer, and False otherwise."
Integers::usage = "Integers represents the domain of integers, as in x \[Element] Integers."
Integrate::usage = "Integrate[f, x] gives the indefinite integral of f with respect to x. Integrate[f, {x, xmin, xmax}] gives the definite integral of f with respect to x from xmin to xmax. Integrate[f, {x, xmin, xmax}, {y, ymin, ymax}] gives a multiple definite integral of f with respect to x and y."
InterpolatingFunction::usage = "InterpolatingFunction[domain, table] represents an approximate function whose values are found by interpolation."
InterpolatingPolynomial::usage = "InterpolatingPolynomial[data, var] gives a polynomial in the variable var which provides an exact fit to a list of data. The data can have the forms {{x1, f1}, {x2, f2}, ... } or {f1, f2, ... }, where in the second case, the xi are taken to have values 1, 2, ... . The fi can be replaced by {fi, dfi, ddfi, ... }, specifying derivatives at the points xi."
Interpolation::usage = "Interpolation[data] constructs an InterpolatingFunction object which represents an approximate function that interpolates the data. The data can have the forms {{x1, f1}, {x2, f2}, ... } or {f1, f2, ... }, where in the second case, the xi are taken to have values 1, 2, ... ."
InterpolationOrder::usage = "InterpolationOrder is an option to Interpolation and ListInterpolation. InterpolationOrder-> n specifies interpolating polynomials of order n. InterpolationOrder -> {n1,n2,...} specifies interpolating polynomials of order n1, n2, ... for dimensions 1,2,..., respectively."
InterpolationPoints::usage = "InterpolationPoints is an option to FunctionInterpolation[f, range] when elements of range are of the form {x, x1, x2} or x. It gives the number of points used in the new InterpolatingFunction."
InterpretationBox::usage = "InterpretationBox[boxes, expr] displays as boxes but is interpreted on input as expr."
InterpretTemplate::usage = "InterpretTemplate is an experimental function used for interpreting Mathematica input."
Interrupt::usage = "Interrupt[ ] generates an interrupt."
Intersection::usage = "Intersection[list1, list2, ... ] gives a sorted list of the elements common to all the listi."
Interval::usage = "Interval[{min, max}] represents the range of values between min and max. Interval[{min1, max1}, {min2, max2}, ... ] represents the union of the ranges min1 to max1, min2 to max2, ...."
IntervalIntersection::usage = "IntervalIntersection[interval1, interval2, ... ] gives the interval representing all points common to each of the intervali."
IntervalMemberQ::usage = "IntervalMemberQ[interval, x] gives True if the number x lies within the specified interval, and False otherwise. IntervalMemberQ[interval1, interval2] gives True if interval2 is completely contained within interval1."
IntervalUnion::usage = "IntervalUnion[interval1, interval2, ... ] gives the interval representing the set of all points in any of the intervali."
Inverse::usage = "Inverse[m] gives the inverse of a square matrix m."
InverseBetaRegularized::usage = "InverseBetaRegularized[s, a, b] gives the inverse of the regularized incomplete beta function."
InverseEllipticNomeQ::usage = "InverseEllipticNomeQ[q] gives the parameter m corresponding to the nome q in an elliptic function."
InverseErf::usage = "InverseErf[s] gives the inverse error function obtained as the solution for z in s = erf(z)."
InverseErfc::usage = "InverseErfc[s] gives the inverse complementary error function obtained as the solution for z in s = erfc(z)."
InverseFourier::usage = "InverseFourier[list] finds the discrete inverse Fourier transform of a list of complex numbers."
InverseFourierCosTransform::usage = "InverseFourierCosTransform[expr, \[Omega], t] gives the symbolic inverse Fourier cosine transform of expr. InverseFourierCosTransform[expr, {\[Omega]1, \[Omega]2, ... }, {t1, t2, ... }] gives the multidimensional inverse Fourier cosine transform of expr."
InverseFourierSinTransform::usage = "InverseFourierSinTransform[expr, \[Omega], t] gives the symbolic inverse Fourier sine transform of expr. InverseFourierSinTransform[expr, {\[Omega]1, \[Omega]2, ... }, {t1, t2, ... }] gives the multidimensional inverse Fourier sine transform of expr."
InverseFourierTransform::usage = "InverseFourierTransform[expr, \[Omega], t] gives the symbolic inverse Fourier transform of expr. InverseFourierTransform[expr, {\[Omega]1, \[Omega]2, ... }, {t1, t2, ... }] gives the multidimensional inverse Fourier transform of expr."
InverseFunction::usage = "InverseFunction[f] represents the inverse of the function f, defined so that InverseFunction[f][y] gives the value of x for which f[x] is equal to y. For a function with several arguments, InverseFunction[f, n, tot] represents the inverse with respect to the nth argument when there are tot arguments in all."
InverseFunctions::usage = "InverseFunctions is an option for Solve and related functions which specifies whether inverse functions should be used."
InverseGammaRegularized::usage = "InverseGammaRegularized[a, s] gives the inverse of the regularized incomplete gamma function."
InverseJacobiCD::usage = "InverseJacobiCD[v, m] gives a value of u for which the Jacobi elliptic function cd(u|m) is equal to v."
InverseJacobiCN::usage = "InverseJacobiCN[v, m] gives a value of u for which the Jacobi elliptic function cn(u|m) is equal to v."
InverseJacobiCS::usage = "InverseJacobiCS[v, m] gives a value of u for which the Jacobi elliptic function cs(u|m) is equal to v."
InverseJacobiDC::usage = "InverseJacobiDC[v, m] gives a value of u for which the Jacobi elliptic function dc(u|m) is equal to v."
InverseJacobiDN::usage = "InverseJacobiDN[v, m] gives a value of u for which the Jacobi elliptic function dn(u|m) is equal to v."
InverseJacobiDS::usage = "InverseJacobiDS[v, m] gives a value of u for which the Jacobi elliptic function ds(u|m) is equal to v."
InverseJacobiNC::usage = "InverseJacobiNC[v, m] gives a value of u for which the Jacobi elliptic function nc(u|m) is equal to v."
InverseJacobiND::usage = "InverseJacobiND[v, m] gives a value of u for which the Jacobi elliptic function nd(u|m) is equal to v."
InverseJacobiNS::usage = "InverseJacobiNS[v, m] gives a value of u for which the Jacobi elliptic function ns(u|m) is equal to v."
InverseJacobiSC::usage = "InverseJacobiSC[v, m] gives a value of u for which the Jacobi elliptic function sc(u|m) is equal to v."
InverseJacobiSD::usage = "InverseJacobiSD[v, m] gives a value of u for which the Jacobi elliptic function sd(u|m) is equal to v."
InverseJacobiSN::usage = "InverseJacobiSN[v, m] gives a value of u for which the Jacobi elliptic function sn(u|m) is equal to v."
InverseLaplaceTransform::usage = "InverseLaplaceTransform[expr, s, t] gives the inverse Laplace transform of expr. InverseLaplaceTransform[expr, {s1, s2, ... }, {t1, t2, ... }] gives the multidimensional inverse Laplace transform of expr."
InverseSeries::usage = "InverseSeries[s, x] takes the series s generated by Series, and gives a series for the inverse of the function represented by s."
InverseWeierstrassP::usage = "InverseWeierstrassP[p, {g2, g3}] gives a value of u for which the Weierstrass function WeierstrassP[u, {g2, g3}] is equal to p."
InverseZTransform::usage = "InverseZTransform[expr, z, n] gives the inverse Z transform of expr."
JacobiAmplitude::usage = "JacobiAmplitude[u, m] gives the amplitude am(u\[VerticalSeparator]m) for Jacobi elliptic functions."
Jacobian::usage = "Jacobian is an option for FindRoot. Jacobian -> Automatic attempts symbolic computation of the Jacobian of the system of functions whose root is being sought. A typical setting is Jacobian -> {{2 x, Sign[y]}, {y, x}}."
JacobiCD::usage = "JacobiCD[u, m] gives the Jacobi elliptic function cd(u|m)."
JacobiCN::usage = "JacobiCN[u, m] gives the Jacobi elliptic function cn(u|m)."
JacobiCS::usage = "JacobiCS[u, m] gives the Jacobi elliptic function cs(u|m)."
JacobiDC::usage = "JacobiDC[u, m] gives the Jacobi elliptic function dc(u|m)."
JacobiDN::usage = "JacobiDN[u, m] gives the Jacobi elliptic function dn(u|m)."
JacobiDS::usage = "JacobiDS[u, m] gives the Jacobi elliptic function ds(u|m)."
JacobiNC::usage = "JacobiNC[u, m] gives the Jacobi elliptic function nc(u|m)."
JacobiND::usage = "JacobiND[u, m] gives the Jacobi elliptic function nd(u|m)."
JacobiNS::usage = "JacobiNS[u, m] gives the Jacobi elliptic function ns(u|m)."
JacobiP::usage = "JacobiP[n, a, b, x] gives the n-th Jacobi polynomial in x for parameters a and b."
JacobiSC::usage = "JacobiSC[u, m] gives the Jacobi elliptic function sc(u|m)."
JacobiSD::usage = "JacobiSD[u, m] gives the Jacobi elliptic function sd(u|m)."
JacobiSN::usage = "JacobiSN[u, m] gives the Jacobi elliptic function sn(u|m)."
JacobiSymbol::usage = "JacobiSymbol[n, m] gives the Jacobi symbol, an integer function of n and m."
JacobiZeta::usage = "JacobiZeta[phi, m] gives the Jacobi zeta function Z(phi|m)."
Join::usage = "Join[list1, list2, ... ] concatenates lists together. Join can be used on any set of expressions that have the same head."
JordanDecomposition::usage = "JordanDecomposition[m] yields the Jordan decomposition of a square matrix m. The result is a list {s, j} where s is a similarity matrix and j is the Jordan canonical form of m."
K::usage = "K is a default generic name for a summation index in a symbolic sum."
Khinchin::usage = "Khinchin is Khinchin's constant, with numerical value \[TildeEqual] 2.68545."
KleinInvariantJ::usage = "KleinInvariantJ[tau] gives the Klein invariant modular elliptic function J(tau)."
KroneckerDelta::usage = "KroneckerDelta[n1, n2, ... ] gives the Kronecker delta \[Delta]n1n2..., equal to 1 if all the ni are equal, and 0 otherwise."
Label::usage = "Label[tag] represents a point in a compound expression to which control can be transferred using Goto."
LaguerreL::usage = "LaguerreL[n, a, x] gives the n-th generalized Laguerre polynomial in x for parameter a."
LanguageCategory::usage = "LanguageCategory is an option for Cell which determines in what category of language the contents of the cell should be assumed to be for purposes of spell checking and hyphenation."
LaplaceTransform::usage = "LaplaceTransform[expr, t, s] gives the Laplace transform of expr. LaplaceTransform[expr, {t1, t2, ... }, {s1, s2, ... }] gives the multidimensional Laplace transform of expr."
Last::usage = "Last[expr] gives the last element in expr."
LatticeReduce::usage = "LatticeReduce[{v1, v2, ... }] gives a reduced basis for the set of vectors vi."
LCM::usage = "LCM[n1, n2, ... ] gives the least common multiple of the integers ni."
LeafCount::usage = "LeafCount[expr] gives the total number of indivisible subexpressions in expr."
Left::usage = "Left is used to specify alignment in printforms such as ColumnForm and TableForm."
LegendreP::usage = "LegendreP[n, x] gives the n-th Legendre polynomial in x. LegendreP[n, m, x] gives the associated Legendre polynomial."
LegendreQ::usage = "LegendreQ[n, z] gives the n-th Legendre function of the second kind. LegendreQ[n, m, z] gives the associated Legendre function of the second kind."
LegendreType::usage = "LegendreType is an obsolete option, superseded by additional arguments to LegendreP and LegendreQ."
Length::usage = "Length[expr] gives the number of elements in expr."
LerchPhi::usage = "LerchPhi[z, s, a] gives the Lerch transcendent Phi(z, s, a)."
Less::usage = "x < y yields True if x is determined to be less than y. x1 < x2 < x3 yields True if the xi form a strictly increasing sequence."
LessEqual::usage = "x <= y yields True if x is determined to be less than or equal to y. x1 <= x2 <= x3 yields True if the xi form a non-decreasing sequence."
LetterQ::usage = "LetterQ[string] yields True if all the characters in the string are letters, and yields False otherwise."
Level::usage = "Level[expr, levelspec] gives a list of all subexpressions of expr on levels specified by levelspec. Level[expr, levelspec, f] applies f to the sequence of subexpressions."
LevenbergMarquardt::usage = "LevenbergMarquardt is a choice for the option Method of FindMinimum. Method -> LevenbergMarquardt specifies that the Levenberg-Marquardt method will be used."
Lexicographic::usage = "Lexicographic is a setting for the MonomialOrder option of GroebnerBasis and PolynomialReduce."
LicenseID::usage = "LicenseID is an option to Encode which specifies the required value of $LicenseID on the computer that reads the encoded file. If no value is specified, any value of $LicenseID is allowed on the file-reading computer. A setting for LicenseID must be a string."
Lighting::usage = "Lighting is an option for Graphics3D and related functions that specifies whether to use simulated illumination in three-dimensional pictures."
LightSources::usage = "LightSources is an option for Graphics3D and related functions that specifies the properties of point light sources for simulated illumination."
Limit::usage = "Limit[expr, x->x0] finds the limiting value of expr when x approaches x0."
LimitsPositioning::usage = "LimitsPositioning is an option for UnderoverscriptBox and related boxes which specifies whether to change the positioning of underscripts and overscripts in the way conventional for limits."
Line::usage = "Line[{pt1, pt2, ... }] is a graphics primitive which represents a line joining a sequence of points."
LinearProgramming::usage = "LinearProgramming[c, m, b] finds a vector x which minimizes the quantity c.x subject to the constraints m.x >= b and x >= 0.\nLinearProgramming[c, m, {{b1, s1}, {b2, s2}, ... }] finds a vector x which minimizes c.x subject to x >= 0 and linear constraints specified by the matrix m and the pairs {bi, si}. For each row mi of m, the corresponding constraint is mi.x >= bi if si == 1, or mi.x == bi if si == 0, or mi.x <= bi if si == -1.\nLinearProgramming[c, m, b, l] minimizes c.x subject to the constraints specified by m and b and x >= l.\nLinearProgramming[c, m, b, {l1, l2, ... }] minimizes c.x subject to the constraints specified by m and b and xi >= li.\nLinearProgramming[c, m, b, {{l1, u1}, {l2, u2}, ... }] minimizes c.x subject to the constraints specified by m and b and li <= xi <= ui."
LinearSolve::usage = "LinearSolve[m, b] finds an x which solves the matrix equation m.x==b. LinearSolve[m] generates a LinearSolveFunction[ ... ] which can be applied repeatedly to different b."
LinearSolveFunction::usage = "LinearSolveFunction[dimensions, data] represents a function for providing solutions to a matrix equation."
LineForm::usage = "LineForm[g] is a three-dimensional graphics directive that specifies that lines are to be drawn with the graphics directive g or the list of graphics directives g."
LineIndent::usage = "LineIndent is an option for Cell, StyleBox and StyleForm which specifies how many ems of indentation to add at the beginnings of lines for each level of nesting in an expression."
LineIndentMaxFraction::usage = "LineIndentMaxFraction is an option for Cell, StyleBox and StyleForm which specifies the maximum fraction of the total page width to indent at the beginnings of lines."
LineSpacing::usage = "LineSpacing is an option for Cell, StyleBox and StyleForm which specifies the spacing between successive lines of text."
LinkClose::usage = "LinkClose[link] closes an open MathLink connection."
LinkConnect::usage = "LinkConnect[\"name\"] connects to a MathLink link created by another program."
LinkCreate::usage = "LinkCreate[\"name\"] creates a MathLink link with the specified name for another program to connect to. LinkCreate[ ] picks an unused port on your computer system and creates a MathLink link on it."
LinkError::usage = "LinkError[link] returns error information for link in the form { errorNumber, errorExplanation }."
LinkFlush::usage = "LinkFlush[link] transmits immediately any locally buffered outgoing expressions."
LinkInterrupt::usage = "LinkInterrupt[link] sends an interrupt to the program at the other end of the specified MathLink connection."
LinkLaunch::usage = "LinkLaunch[\"prog\"] starts the external program prog and opens a MathLink connection to it."
LinkObject::usage = "LinkObject[\"name\", n] is an object that represents an active MathLink connection for functions such as LinkRead and LinkWrite."
LinkPatterns::usage = "LinkPatterns[link] gives a list of the patterns for which definitions were set up when the external program associated with the specified MathLink connection was installed."
LinkProtocol::usage = "LinkProtocol is an option to LinkLaunch, Install and related functions which specifies the underlying data transport protocol to use for a new MathLink link."
LinkRead::usage = "LinkRead[link] reads one expression from the specified MathLink connection. LinkRead[link, h] wraps h around the expression read before evaluating it."
LinkReadHeld::usage = "LinkReadHeld[link] reads an expression via MathLink from link and returns it wrapped in Hold."
LinkReadyQ::usage = "LinkReadyQ[link] tests whether there is an expression ready to read from the specified MathLink connection."
Links::usage = "Links[ ] gives a list of all MathLink connections that are currently open. Links[\"name\"] lists only links with the specified name."
LinkWrite::usage = "LinkWrite[link, expr] writes expr to the specified MathLink connection."
LinkWriteHeld::usage = "LinkWriteHeld[link, Hold[expr], (flush:True)] writes expr (without the Hold) via MathLink to link (synchronizing unless flush is False)."
List::usage = "{e1, e2, ... } is a list of elements."
Listable::usage = "Listable is an attribute that can be assigned to a symbol f to indicate that the function f should automatically be threaded over lists that appear as its arguments."
ListContourPlot::usage = "ListContourPlot[array] generates a contour plot from an array of height values."
ListConvolve::usage = "ListConvolve[ker, list] forms the convolution of the kernel ker with list. ListConvolve[ker, list, k] forms the cyclic convolution in which the kth element of ker is aligned with each element in list. ListConvolve[ker, list, {kL, kR}] forms the cyclic convolution whose first element contains list[[1]] ker[[kL]] and whose last element contains list[[-1]] ker[[kR]]. ListConvolve[ker, list, klist, p] forms the convolution in which list is padded at each end with repetitions of the element p. ListConvolve[ker, list, klist, {p1, p2, ... }] forms the convolution in which list is padded at each end with cyclic repetitions of the pi. ListConvolve[ker, list, klist, padding, g, h] forms a generalized convolution in which g is used in place of Times and h in place of Plus. ListConvolve[ker, list, klist, padding, g, h, lev] forms a convolution using elements at level lev in ker and list."
ListCorrelate::usage = "ListCorrelate[ker, list] forms the correlation of the kernel ker with list. ListCorrelate[ker, list, k] forms the cyclic correlation in which the kth element of ker is aligned with each element in list. ListCorrelate[ker, list, {kL, kR}] forms the cyclic correlation whose first element contains list[[1]] ker[[kL]] and whose last element contains list[[-1]] ker[[kR]]. ListCorrelate[ker, list, klist, p] forms the correlation in which list is padded at each end with repetitions of the element p. ListCorrelate[ker, list, klist, {p1, p2, ... }] forms the correlation in which list is padded at each end with cyclic repetitions of the pi. ListCorrelate[ker, list, klist, padding, g, h] forms a generalized correlation in which g is used in place of Times and h in place of Plus. ListCorrelate[ker, list, klist, padding, g, h, lev] forms a correlation using elements at level lev in ker and list."
ListDensityPlot::usage = "ListDensityPlot[array] generates a smooth density plot from an array of values."
ListInterpolation::usage = "ListInterpolation[array] constructs an InterpolatingFunction object which represents an approximate function that interpolates the array of values given. ListInterpolation[array, {{xmin, xmax}, {ymin, ymax}, ... }] specifies the domain of the grid from which the values in array are assumed to come."
ListPlay::usage = "ListPlay[{a1, a2, ... }] plays a sound whose amplitude is given by the sequence of levels ai."
ListPlot::usage = "ListPlot[{y1, y2, ... }] plots points corresponding to a list of values. The x coordinates are by default taken to be 1, 2, ... . ListPlot[{{x1, y1}, {x2, y2}, ... }] plots a list of points with specified x and y coordinates."
ListPlot3D::usage = "ListPlot3D[array] generates a three-dimensional plot of a surface representing an array of height values. ListPlot3D[array, shades] generates a plot with each element of the surface shaded according to the specification in shades."
ListQ::usage = "ListQ[expr] gives True if expr is a list, and False otherwise."
Literal::usage = "Literal has been renamed HoldPattern."
Locked::usage = "Locked is an attribute which, once assigned, prevents modification of any attributes of a symbol."
Log::usage = "Log[z] gives the natural logarithm of z (logarithm to base e). Log[b, z] gives the logarithm to base b."
LogGamma::usage = "LogGamma[z] gives the logarithm of the gamma function."
LogicalExpand::usage = "LogicalExpand[expr] expands out expressions containing logical connectives such as && and ||."
LogIntegral::usage = "LogIntegral[z] is the logarithmic integral function li(z)."
LongForm::usage = "LongForm is an option for Information. With LongForm -> True, the full information of a symbol is printed. With LongForm -> False the usage of a symbol is printed."
LowerCaseQ::usage = "LowerCaseQ[string] yields True if all the characters in the string are lower-case letters, and yields False otherwise."
LUDecomposition::usage = "LUDecomposition[m] generates a representation of the LU decomposition of a square matrix m."
MachineID::usage = "MachineID is an option to Encode which specifies the required value of $MachineID on the computer that reads the encoded file. If no value is specified, any value of $MachineID is allowed on the file-reading computer. A setting for MachineID must be a string."
MachineName::usage = "MachineName is an option to Encode which specifies the required value of $MachineName on the computer that reads the encoded file. If no value is specified, any value of $MachineName is allowed on the file-reading computer. A setting for MachineName must be a string."
MachineNumberQ::usage = "MachineNumberQ[expr] returns True if expr is a machine-precision real or complex number, and returns False otherwise."
MachinePrecision::usage = "MachinePrecision is a symbol used to indicate machine-number precision."
Magenta::usage = "Magenta represents the color magenta in graphics or style specifications."
Magnification::usage = "Magnification is an option for Cell which specifies at what magnification to display the cell."
MainSolve::usage = "MainSolve[eqns] is the underlying function for transforming systems of equations. Solve and Eliminate call it. The equations must be of the form lhs == rhs. They can be combined using && and ||. MainSolve returns False if no solutions to the equations exist, and True if all values of variables are solutions. MainSolve rearranges the equations using certain directives. MainSolve[eqns, vars, elim, rest] attempts to rearrange the equations eqns so as to solve for the variables vars, and eliminate the variables elim. The list rest can be included to specify the elimination order for any remaining variables."
MakeBoxes::usage = "MakeBoxes[expr, form] is the low-level function used in Mathematica sessions to convert expressions into boxes."
MakeExpression::usage = "MakeExpression[boxes, form] is the low-level function used in Mathematica sessions to construct expressions from boxes."
MakeRules::usage = "MakeRules is an option to Solve and related functions. With MakeRules -> True, the result is presented as an AlgebraicRulesData object. With MakeRules -> False, the result is presented as a list of rules."
MantissaExponent::usage = "MantissaExponent[x] gives a list containing the mantissa and exponent of a number x. MantissaExponent[x, b] gives the base-b mantissa and exponent of x."
Map::usage = "Map[f, expr] or f /@ expr applies f to each element on the first level in expr. Map[f, expr, levelspec] applies f to parts of expr specified by levelspec."
MapAll::usage = "MapAll[f, expr] or f //@ expr applies f to every subexpression in expr."
MapAt::usage = "MapAt[f, expr, n] applies f to the element at position n in expr. If n is negative, the position is counted from the end. MapAt[f, expr, {i, j, ... }] applies f to the part of expr at position {i, j, ... }. MapAt[f, expr, {{i1, j1, ... }, {i2, j2, ... }, ... }] applies f to parts of expr at several positions."
MapIndexed::usage = "MapIndexed[f, expr] applies f to the elements of expr, giving the part specification of each element as a second argument to f. MapIndexed[f, expr, levspec] applies f to all parts of expr on levels specified by levspec."
MapThread::usage = "MapThread[f, {{a1, a2, ... }, {b1, b2, ... }, ... }] gives {f[a1, b1, ... ], f[a2, b2, ... ], ... }. MapThread[f, {expr1, expr2, ... }, n] applies f to the parts of the expri at level n."
MatchLocalNameQ::usage = "MatchLocalNameQ is an internal symbol."
MatchLocalNames::usage = "MatchLocalNames is an option for Trace and related functions which specifies whether symbols such as x should match symbols with local names of the form x$nnn."
MatchQ::usage = "MatchQ[expr, form] returns True if the pattern form matches expr, and returns False otherwise."
MathieuC::usage = "MathieuC[a, q, z] gives the even Mathieu function with characteristic value a and parameter q."
MathieuCharacteristicA::usage = "MathieuCharacteristicA[r, q] gives the characteristic value a for even Mathieu functions with characteristic exponent r and parameter q."
MathieuCharacteristicB::usage = "MathieuCharacteristicB[r, q] gives the characteristic value b for odd Mathieu functions with characteristic exponent r and parameter q."
MathieuCharacteristicExponent::usage = "MathieuCharacteristicExponent[a, q] gives the characteristic exponent r for Mathieu functions with characteristic value a and parameter q."
MathieuCPrime::usage = "MathieuCPrime[a, q, z] gives the derivative with respect to z of the even Mathieu function with characteristic value a and parameter q."
MathieuS::usage = "MathieuS[a, q, z] gives the odd Mathieu function with characteristic value a and parameter q."
MathieuSPrime::usage = "MathieuSPrime[a, q, z] gives the derivative with respect to z of the odd Mathieu function with characteristic value a and parameter q."
MathMLForm::usage = "MathMLForm[expr] prints as a MathML form of expr."
MatrixExp::usage = "MatrixExp[mat] gives the matrix exponential of mat."
MatrixForm::usage = "MatrixForm[list] prints with the elements of list arranged in a regular array."
MatrixPower::usage = "MatrixPower[mat, n] gives the nth matrix power of mat."
MatrixQ::usage = "MatrixQ[expr] gives True if expr is a list of lists or a two-dimensional SparseArray object that can represent a matrix, and gives False otherwise. MatrixQ[expr, test] gives True only if test yields True when applied to each of the matrix elements in expr."
MatrixRank::usage = "MatrixRank[m] gives the rank of the matrix m."
Max::usage = "Max[x1, x2, ... ] yields the numerically largest of the xi. Max[{x1, x2, ... }, {y1, ... }, ... ] yields the largest element of any of the lists."
MaxBend::usage = "MaxBend is an option for Plot which measures the maximum bend angle between successive line segments on a curve."
Maximize::usage = "Maximize[f, {x, y, ... }] maximizes f with respect to x, y, ... . Maximize[{f, cons}, {x, y, ... }] maximizes f subject to the constraints cons."
MaxIterations::usage = "MaxIterations is an option for various functions that use an iterative algorithm. With MaxIterations -> n, a maximum of n iterations is used."
MaxMemoryUsed::usage = "MaxMemoryUsed[ ] gives the maximum number of bytes used to store all data for the current Mathematica session."
MaxPlotPoints::usage = "MaxPlotPoints is an option for ArrayPlot that specifies the maximum number of points that will explicitly be included in the output."
MaxPoints::usage = "MaxPoints is an option for NIntegrate. With MaxPoints -> n and Method->Automatic, the QuasiMonteCarlo method will be used at most n sample points. If the Method->MonteCarlo, the MonteCarlo method will be used at n sample points."
MaxRecursion::usage = "MaxRecursion is an option for various numerical functions that use a recursive algorithm. With MaxRecursion -> n, the maximum depth to which recursion is allowed to go is n even if convergence is not yet achieved."
MaxRelativeStepSize::usage = "MaxRelativeStepSize is an option to NDSolve that bounds the size of each step relative to the size of the domain of integration."
MaxStepSize::usage = "MaxStepSize is an option to NDSolve that bounds the size of each step."
Mean::usage = "Mean[list] gives the statistical mean of the elements in list."
Median::usage = "Median[list] gives the median of the elements in list."
MeijerG::usage = "MeijerG[{{a1, ... , an}, {an+1, ... , ap}}, {{b1, ... , bm}, {bm+1, ... , bq}}, z] is the Meijer G function."
MemberQ::usage = "MemberQ[list, form] returns True if an element of list matches form, and False otherwise. MemberQ[list, form, levelspec] tests all parts of list specified by levelspec."
MemoryConstrained::usage = "MemoryConstrained[expr, b] evaluates expr, stopping if more than b bytes of memory are requested. MemoryConstrained[expr, b, failexpr] returns failexpr if the memory constraint is not met."
MemoryInUse::usage = "MemoryInUse[ ] gives the number of bytes currently being used to store all data in the current Mathematica session."
Mesh::usage = "Mesh is an option for Plot3D, DensityPlot and other plotting functions that specifies what mesh should be drawn."
MeshRange::usage = "MeshRange is an option for ListPlot3D, SurfaceGraphics, ListContourPlot, ListDensityPlot and related functions which specifies the range of x and y coordinates that correspond to the array of z values given."
MeshStyle::usage = "MeshStyle is an option for Plot3D, DensityPlot and other plotting functions that specifies the style in which to draw a mesh."
Message::usage = "Message[symbol::tag] prints the message symbol::tag unless it has been switched off. Message[symbol::tag, e1, e2, ... ] prints a message, inserting the values of the ei as needed."
MessageList::usage = "MessageList[n] is a global object assigned to be a list of the names of messages generated during the processing of the nth input line."
MessageName::usage = "symbol::tag is a name for a message."
Messages::usage = "Messages[symbol] gives all the messages assigned to a particular symbol."
MetaCharacters::usage = "MetaCharacters is an option to StringPosition. With MetaCharacters -> None, no strings have special meanings. MetaCharacters -> {c1, c2, c3} specifies the metacharacters for pattern escape, single character matching and multiple character matching. MetaCharacters -> Automatic is equivalent to MetaCharacters -> {\"\\\\\", \".\", \"*\"}."
Method::usage = "Method is an option to Solve, related functions, and various numerical functions, which specifies what algorithm to use in evaluating the result."
Min::usage = "Min[x1, x2, ... ] yields the numerically smallest of the xi. Min[{x1, x2, ... }, {y1, ... }, ... ] yields the smallest element of any of the lists."
Minimize::usage = "Minimize[f, {x, y, ... }] minimizes f with respect to x, y, ... . Minimize[{f, cons}, {x, y, ... }] minimizes f subject to the constraints cons."
Minors::usage = "Minors[m] gives the minors of a matrix m. Minors[m, k] gives kth minors."
MinRecursion::usage = "MinRecursion is an option for NIntegrate and other numerical functions that use a recursive algorithm. With MinRecursion -> n, a minimum depth of recursion of n is used before tests for convergence begin."
MinSize::usage = "MinSize is an option of certain BoxForm primitives."
Minus::usage = "-x is the arithmetic negation of x."
Mod::usage = "Mod[m, n] gives the remainder on division of m by n. Mod[m, n, d] uses an offset d."
Mode::usage = "Mode is an option to Solve and related functions that specifies in what sense the equations are to be solved. The possible settings for Mode are Generic, Modular, and Rational."
Modular::usage = "Modular is a setting for the option Mode in Solve and related functions, which specifies that equations need be satisfied only modulo an integer."
ModularLambda::usage = "ModularLambda[tau] gives the modular lambda elliptic function."
Module::usage = "Module[{x, y, ... }, expr] specifies that occurrences of the symbols x, y, ...  in expr should be treated as local. Module[{x = x0, ... }, expr] defines initial values for x, ... ."
Modulus::usage = "Modulus->n is an option that can be given in certain algebraic functions to specify that integers should be treated modulo n. Equations for Modulus can be given in Solve and related functions."
MoebiusMu::usage = "MoebiusMu[n] gives the Moebius function mu(n)."
MonomialOrder::usage = "MonomialOrder is an option for GroebnerBasis and PolynomialReduce. Valid MonomialOrder options are: Lexicographic, DegreeLexicographic, DegreeReverseLexicographic, EliminationOrder, or a matrix of integers or rationals defining a valid weighting for the variables. These term order options all have the meanings associated with the various names that appear in the literature. A weight matrix must have full rank, and weight matrix specifications assume that Sort is set to False (the default). If not, an error will be issued."
MonteCarlo::usage = "MonteCarlo is a choice for the option Method of NIntegrate. Method -> MonteCarlo causes a Monte Carlo algorithm to be used."
Most::usage = "Most[expr] gives expr with the last element removed."
MultiDimensional::usage = "MultiDimensional is a choice for the option Method of NIntegrate. Method -> MultiDimensional causes a multi-dimensional algorithm to be used. Method -> MultiDimensional is only valid for integration in two or more dimensions."
MultilineFunction::usage = "MultilineFunction is an option of certain BoxForm primitives."
Multinomial::usage = "Multinomial[n1, n2, ... ] gives the multinomial coefficient (n1 + n2 + ...)!/(n1!n2!...)."
MultiplicativeOrder::usage = "MultiplicativeOrder[k, n] gives the multiplicative order of k modulo n, defined as the smallest integer m such that k^m \[Congruent] 1 mod n. MultiplicativeOrder[k, n, {r1, r2, ... }] gives the generalized multiplicative order of k modulo n, defined as the smallest integer m such that k^m \[Congruent] ri mod n for any i."
Multiplicity::usage = "Multiplicity is an option to Roots. Multiplicity -> n specifies that the multiplicity of each of the roots is n in the final result."
N::usage = "N[expr] gives the numerical value of expr. N[expr, n] attempts to give a result with n-digit precision."
NameQ::usage = "NameQ[\"string\"] yields True if there are any symbols whose names match the string pattern given, and yields False otherwise."
Names::usage = "Names[\"string\"] gives a list of the names of symbols which match the string. Names[\"string\", SpellingCorrection->True] includes names which match after spelling correction."
Nand::usage = "Nand[e1, e2, ... ] is the logical NAND function. It evaluates its arguments in order, giving True immediately if any of them are False, and False if they are all True."
NBernoulliB::usage = "NBernoulliB[n] gives the numerical value of the nth Bernoulli number. NBernoulliB[n, d] gives the result to d-digit precision."
NDSolve::usage = "NDSolve[eqns, y, {x, xmin, xmax}] finds a numerical solution to the ordinary differential equations eqns for the function y with the independent variable x in the range xmin to xmax. NDSolve[eqns, y, {x, xmin, xmax}, {t, tmin, tmax}] finds a numerical solution to the partial differential equations eqns. NDSolve[eqns, {y1, y2, ... }, {x, xmin, xmax}] finds numerical solutions for the functions yi."
Needs::usage = "Needs[\"context`\"] loads an appropriate file if the specified context is not already in $Packages. Needs[\"context`\", \"file\"] loads file if the specified context is not already in $Packages."
Negative::usage = "Negative[x] gives True if x is a negative number."
Nest::usage = "Nest[f, expr, n] gives an expression with f applied n times to expr."
NestList::usage = "NestList[f, expr, n] gives a list of the results of applying f to expr 0 through n times."
NestWhile::usage = "NestWhile[f, expr, test] starts with expr, then repeatedly applies f until applying test to the result no longer yields True. NestWhile[f, expr, test, m] supplies the most recent m results as arguments for test at each step. NestWhile[f, expr, test, All] supplies all results so far as arguments for test at each step. NestWhile[f, expr, test, m, max] applies f at most max times. NestWhile[f, expr, test, m, max, n] applies f an extra n times. NestWhile[f, expr, test, m, max, -n] returns the result found when f had been applied n fewer times."
NestWhileList::usage = "NestWhileList[f, expr, test] generates a list of the results of applying f repeatedly, starting with expr, and continuing until applying test to the result no longer yields True. NestWhileList[f, expr, test, m] supplies the most recent m results as arguments for test at each step. NestWhileList[f, expr, test, All] supplies all results so far as arguments for test at each step. NestWhileList[f, expr, test, m, max] applies f at most max times."
NevilleThetaC::usage = "NevilleThetaC[u, m] gives Neville's elliptic theta function theta_c(u|m)."
NevilleThetaD::usage = "NevilleThetaD[u, m] gives Neville's elliptic theta function theta_d(u|m)."
NevilleThetaN::usage = "NevilleThetaN[u, m] gives Neville's elliptic theta function theta_n(u|m)."
NevilleThetaS::usage = "NevilleThetaS[u, m] gives Neville's elliptic theta function theta_s(u|m)."
Newton::usage = "Newton is a choice for the option Method of FindMinimum. Method-> Newton specifies that the Newton method will be used."
NHoldAll::usage = "NHoldAll is an attribute which specifies that none of the arguments to a function should be affected by N."
NHoldFirst::usage = "NHoldFirst is an attribute which specifies that the first argument to a function should not be affected by N."
NHoldRest::usage = "NHoldRest is an attribute which specifies that all but the first argument to a function should not be affected by N."
NIntegrate::usage = "NIntegrate[f, {x, xmin, xmax}] gives a numerical approximation to the integral of f with respect to x from xmin to xmax."
NMaximize::usage = "NMaximize[f, {x, y, ... }] maximizes f numerically with respect to x, y, ... . NMaximize[{f, cons}, {x, y, ... }] maximizes f numerically subject to the constraints cons."
NMinimize::usage = "NMinimize[f, {x, y, ... }] minimizes f numerically with respect to x, y, ... . NMinimize[{f, cons}, {x, y, ... }] minimizes f numerically subject to the constraints cons."
NonAssociative::usage = "NonAssociative is a symbol that represents a non-associative operator in formatting functions."
NonCommutativeMultiply::usage = "a ** b ** c is a general associative, but non-commutative, form of multiplication."
NonConstants::usage = "NonConstants is an option for D which gives a list of objects to be taken to depend implicitly on the differentiation variables."
None::usage = "None is a setting used for certain options."
NonNegative::usage = "NonNegative[x] gives True if x is a non-negative number."
NonPositive::usage = "NonPositive[x] gives True if x is a non-positive number."
Nor::usage = "Nor[e1, e2, ... ] is the logical NOR function. It evaluates its arguments in order, giving False immediately if any of them are True, and True if they are all False."
Norm::usage = "Norm[expr] gives the norm of a number or array. Norm[expr, p] gives the p-norm."
Normal::usage = "Normal[expr] converts expr to a normal expression, from a variety of special forms."
Not::usage = "!expr is the logical NOT function. It gives False if expr is True, and True if it is False."
Notebook::usage = "Notebook[{cell1, cell2, ... }] represents a notebook that can be manipulated by the Mathematica front end."
NotebookApply::usage = "NotebookApply[notebook, data] writes data into a notebook at the current selection, replacing the first selection placeholder in data by the current selection, and then setting the current selection to be just after the data written. NotebookApply[notebook, data, sel] writes data into a notebook and then sets the current selection to be as specified by sel."
NotebookAutoSave::usage = "NotebookAutoSave is an option for Notebook which specifies whether the notebook should automatically be saved after each piece of output generated by evaluation in it."
NotebookClose::usage = "NotebookClose[notebook] closes the notebook corresponding to the specified notebook object."
NotebookCreate::usage = "NotebookCreate[ ] creates a new open notebook in the front end. NotebookCreate[options] sets up the specified options for the new notebook."
NotebookDelete::usage = "NotebookDelete[notebook] deletes the current selection corresponding to the specified notebook object."
NotebookFind::usage = "NotebookFind[notebook, data] sets the current selection in the specified notebook object to be the next occurrence of data. NotebookFind[notebook, data, Previous] sets the current selection to be the previous occurrence. NotebookFind[notebook, data, All] sets the current selection to be all occurrences. NotebookFind[notebook, data, dir, elems] searches the elements of cells specified by elems."
NotebookGet::usage = "NotebookGet[obj] gets the expression corresponding to the notebook represented by the notebook object obj. NotebookGet[ ] gets the expression corresponding to the currently selected notebook."
NotebookLocate::usage = "NotebookLocate[\"tag\"] locates all cells with the specified tag in your current input notebook, selecting the cells and scrolling to the position of the first one. NotebookLocate[{\"file\", \"tag\"}] if necessary opens the notebook stored in file, then locates cells with the specified tag."
NotebookObject::usage = "NotebookObject[fe, id] is an object that represents an open notebook in the front end."
NotebookOpen::usage = "NotebookOpen[\"name\"] opens an existing notebook with the specified name, returning the corresponding notebook object. NotebookOpen[\"name\", options] opens a notebook using the options given."
NotebookPrint::usage = "NotebookPrint[notebook] sends a notebook to your default printer. NotebookPrint[notebook, stream] sends a PostScript version of the notebook to the specified stream."
NotebookPut::usage = "NotebookPut[expr] creates a notebook corresponding to expr and makes it the currently selected notebook in the front end. NotebookPut[expr, obj] replaces the notebook represented by the notebook object obj with one corresponding to expr."
NotebookRead::usage = "NotebookRead[notebook] gives the expression corresponding to the current selection in the specified notebook object."
Notebooks::usage = "Notebooks[ ] gives a list of notebooks currently open in the front end."
NotebookSave::usage = "NotebookSave[notebook] saves the current version of a notebook in a file. NotebookSave[notebook, \"file\"] saves the notebook in the specified file."
NotebookSelection::usage = "NotebookSelection[notebook] represents the current selection in an open notebook in the front end."
NotebookWrite::usage = "NotebookWrite[notebook, data] writes data into a notebook at the current selection, setting the current selection to be just after the data written. NotebookWrite[notebook, data, sel] writes data into a notebook setting the current selection to be as specified by sel."
NProduct::usage = "NProduct[f, {i, imin, imax}] gives a numerical approximation to the product of the expressions f as evaluated for each i from imin to imax. NProduct[f, {i, imin, imax, di}] uses a step di in the product."
NProductExtraFactors::usage = "NProductExtraFactors is an option for NProduct which is used with the method Fit. NProductExtraFactors -> n uses n factors in the extrapolation process. NProductExtraFactors must be greater than twice WynnDegree."
NProductFactors::usage = "NProductFactors is an option for NProduct. NProductFactors -> n explicitly includes n factors in the product before extrapolation."
NRoots::usage = "NRoots[lhs==rhs, var] gives a list of numerical approximations to the roots of a polynomial equation. NRoots[lhs==rhs, var, n] uses n-digit precision in the computations."
NSolve::usage = "NSolve[lhs==rhs, var] gives a list of numerical approximations to the roots of a polynomial equation. NSolve[{eqn1, eqn2, ... }, {var1, var2, ... }] solves a system of polynomial equations."
NSum::usage = "NSum[f, {i, imin, imax}] gives a numerical approximation to the sum of the expressions f as evaluated for each i from imin to imax. NSum[f, {i, imin, imax, di}] uses a step di in the sum."
NSumExtraTerms::usage = "NSumExtraTerms is an option for NSum which is used with the method Fit. NSumExtraTerms -> n uses n terms in the extrapolation process. NSumExtraTerms must be greater than twice WynnDegree."
NSumTerms::usage = "NSumTerms is an option for NSum. NSumTerms -> n explicitly includes n terms in the sum before extrapolation."
Null::usage = "Null is a symbol used to indicate the absence of an expression or a result. When it appears as an output expression, no output is printed."
NullRecords::usage = "NullRecords is an option for Read and related functions which specifies whether null records should be taken to exist between repeated record separators."
NullSpace::usage = "NullSpace[m] gives a list of vectors that forms a basis for the null space of the matrix m."
NullWords::usage = "NullWords is an option for Read and related functions which specifies whether null words should be taken to exist between repeated word separators."
Number::usage = "Number represents an exact integer or an approximate real number in Read."
NumberForm::usage = "NumberForm[expr, n] prints with approximate real numbers in expr given to n-digit precision."
NumberFormat::usage = "NumberFormat is an option for NumberForm and related functions which specifies how the mantissa, base and exponent should be assembled into a final print form."
NumberMarks::usage = "NumberMarks is an option for InputForm and related functions that specifies whether ` marks should be included in the printed forms of approximate numbers."
NumberMultiplier::usage = "NumberMultiplier is an option for NumberForm and related functions which gives the string to use as a multiplication sign in scientific notation."
NumberPadding::usage = "NumberPadding is an option for NumberForm and related functions which gives strings to use as padding on the left- and right-hand sides of numbers."
NumberPoint::usage = "NumberPoint is an option for NumberForm and related functions which gives the string to use as a decimal point."
NumberQ::usage = "NumberQ[expr] gives True if expr is a number, and False otherwise."
NumberSeparator::usage = "NumberSeparator is an option for NumberForm and related functions which gives the string to insert at breaks between digits."
NumberSigns::usage = "NumberSigns is an option for NumberForm and related functions which gives strings to use as signs for negative and positive numbers."
Numerator::usage = "Numerator[expr] gives the numerator of expr."
NumericFunction::usage = "NumericFunction is an attribute that can be assigned to a symbol f to indicate that f[arg1, arg2, ... ] should be considered a numeric quantity whenever all the argi are numeric quantities."
NumericQ::usage = "NumericQ[expr] gives True if expr is a numeric quantity, and False otherwise."
NValues::usage = "NValues[f] gives a list of transformation rules corresponding to all numerical values (values for N[f[x,..],..], etc.) defined for the symbol f."
O::usage = "O[x]^n represents a term of order x^n. O[x]^n is generated to represent omitted higher-order terms in power series. O[x, x0]^n represents a term of order (x - x0)^n."
OddQ::usage = "OddQ[expr] gives True if expr is an odd integer, and False otherwise."
Off::usage = "Off[symbol::tag] switches off a message, so that it is no longer printed. Off[s] switches off tracing messages associated with the symbol s. Off[m1, m2, ... ] switches off several messages. Off[ ] switches off all tracing messages."
Offset::usage = "Offset[{dx, dy}, position] gives the position of a graphical object obtained by starting at the specified position and then moving by absolute offset {dx, dy}."
On::usage = "On[symbol::tag] switches on a message, so that it can be printed. On[s] switches on tracing for the symbol s. On[m1, m2, ... ] switches on several messages. On[ ] switches on tracing for all symbols."
OneIdentity::usage = "OneIdentity is an attribute that can be assigned to a symbol f to indicate that f[x], f[f[x]], etc. are all equivalent to x for the purpose of pattern matching."
OneStepRowReduction::usage = "OneStepRowReduction is a possible value for the Method option in Inverse, LinearSolve, NullSpace, and RowReduce. Method -> OneStepRowReduction causes matrix entries created in the process of Gaussian elimination (row reduction) of a matrix to be divided by the previous pivot. This is always an exact (remainder-free) division. Prior to starting the reduction, denominators are cleared in each row of the matrix."
OpenAppend::usage = "OpenAppend[\"file\"] opens a file to append output to it, and returns an OutputStream object."
OpenRead::usage = "OpenRead[\"file\"] opens a file to read data from, and returns an InputStream object."
OpenTemporary::usage = "OpenTemporary[ ] opens a temporary file to which output can be written, and returns an OutputStream object."
OpenWrite::usage = "OpenWrite[\"file\"] opens a file to write output to it, and returns an OutputStream object."
Operate::usage = "Operate[p, f[x, y]] gives p[f][x, y]. Operate[p, expr, n] applies p at level n in the head of expr."
Optional::usage = "p:v is a pattern object which represents an expression of the form p, which, if omitted, should be replaced by v."
OptionQ::usage = "OptionQ[e] returns True if e can be considered an option or list of options, and False otherwise."
Options::usage = "Options[symbol] gives the list of default options assigned to a symbol. Options[expr] gives the options explicitly specified in a particular expression such as a graphics object. Options[stream] or Options[\"sname\"] gives options associated with a particular stream. Options[object] gives options associated with an external object such as a NotebookObject. Options[obj, name] gives the setting for the option name. Options[obj, {name1, name2, ... }] gives a list of the settings for the options namei."
Or::usage = "e1 || e2 || ...  is the logical OR function. It evaluates its arguments in order, giving True immediately if any of them are True, and False if they are all False."
Orange::usage = "Orange represents the color orange in graphics or style specifications."
Order::usage = "Order[expr1, expr2] gives 1 if expr1 is before expr2 in canonical order, and -1 if expr1 is after expr2 in canonical order. It gives 0 if expr1 is identical to expr2."
OrderedQ::usage = "OrderedQ[h[e1, e2, ... ]] gives True if the ei are in canonical order, and False otherwise."
Ordering::usage = "Ordering[list] gives the positions in list at which each successive element of Sort[list] appears. Ordering[list, n] gives the positions in list at which the first n elements of Sort[list] appear. Ordering[list, -n] gives the positions of the last n elements of Sort[list]. Ordering[list, n, p] uses Sort[list, p]."
Orderless::usage = "Orderless is an attribute that can be assigned to a symbol f to indicate that the elements ei in expressions of the form f[e1, e2, ... ] should automatically be sorted into canonical order. This property is accounted for in pattern matching."
Oscillatory::usage = "Oscillatory is a choice for the option Method of NIntegrate. Method -> Oscillatory should be used only with integrands that contain one of the following oscillating functions: w in {Sin, Cos, BesselJ, BesselY}, i.e. f[x] w[x], and where the 1-dimensional range of integration contains at least one Infinity. The arguments to the oscillating functions should not be polynomials, but be some multiple of the integration variable in some power (e.g. Sin[a_. x_^r_.] instead of Sin[a_. x_^r_. +b_.]). When Bessel-functions are used the method might be slow."
Out::usage = "%n or Out[n] is a global object that is assigned to be the value produced on the nth output line. % gives the last result generated. %% gives the result before last. %% ... % (k times) gives the kth previous result."
Outer::usage = "Outer[f, list1, list2, ... ] gives the generalized outer product of the listi, forming all possible combinations of the lowest-level elements in each of them, and feeding them as arguments to f. Outer[f, list1, list2, ... , n] treats as separate elements only sublists at level n in the listi. Outer[f, list1, list2, ... , n1, n2, ... ] treats as separate elements only sublists at level ni in the corresponding listi."
OutputForm::usage = "OutputForm[expr] prints as a two-dimensional representation of expr using only keyboard characters."
OutputMathEditExpression::usage = "OutputMathEditExpression is an internal symbol used for formatting."
OutputStream::usage = "OutputStream[\"name\", n] is an object that represents an output stream for functions such as Write."
Overflow::usage = "Overflow[] is the result of a numerical calculation whose result is too large to represent."
Overlaps::usage = "Overlaps is an option to StringCases, StringCount and StringPosition that specifies how to treat overlapping substrings."
Overscript::usage = "Overscript[x, y] is an object that formats as x with an overscript y."
OverscriptBox::usage = "OverscriptBox[x, y] represents x with an overscript y in input and output."
OwnValues::usage = "OwnValues[f] gives a list of transformation rules corresponding to all ownvalues (values for f itself) defined for the symbol f."
PaddedForm::usage = "PaddedForm[expr, n] prints with all numbers in expr padded to leave room for a total of n digits. PaddedForm[expr, {n, f}] prints with approximate real numbers having exactly f digits to the right of the decimal point."
PadLeft::usage = "PadLeft[list, n] makes a list of length n by padding list with zeros on the left. PadLeft[list, n, x] pads by repeating the element x. PadLeft[list, n, {x1, x2, ... }] pads by cyclically repeating the elements xi. PadLeft[list, n, padding, m] leaves a margin of m elements of padding on the right. PadLeft[list, {n1, n2, ... }] makes a nested list with length ni at level i."
PadRight::usage = "PadRight[list, n] makes a list of length n by padding list with zeros on the right. PadRight[list, n, x] pads by repeating the element x. PadRight[list, n, {x1, x2, ... }] pads by cyclically repeating the elements xi. PadRight[list, n, padding, m] leaves a margin of m elements of padding on the left. PadRight[list, {n1, n2, ... }] makes a nested list with length ni at level i."
PageBreakAbove::usage = "PageBreakAbove is an option for Cell which specifies whether a page break should be made immediately above the cell if the notebook that contains the cell is printed."
PageBreakBelow::usage = "PageBreakBelow is an option for Cell which specifies whether a page break should be made immediately below the cell if the notebook that contains the cell is printed."
PageBreakWithin::usage = "PageBreakWithin is an option for Cell which specifies whether a page break should be allowed within the cell if the notebook that contains the cell is printed."
PageWidth::usage = "PageWidth is an option for output streams and for cells which specifies how wide each line of text should be allowed to be."
ParagraphIndent::usage = "ParagraphIndent is an option for Cell which specifies how far in printer's points to indent the first line of each paragraph of text."
ParagraphSpacing::usage = "ParagraphSpacing is an option for Cell, StyleBox and StyleForm which specifies how much extra space to leave between successive paragraphs of text."
ParameterVariables::usage = "ParameterVariables is an option for GroebnerBasis and PolynomialReduce. These variables will always be last in the ordering. By default, all variables that are not otherwise classified will become parameter variables. By specifying them explicitly one fixes their relative positions in the overall variable ordering."
ParametricPlot::usage = "ParametricPlot[{fx, fy}, {u, umin, umax}] produces a parametric plot of a curve with x and y coordinates fx and fy generated as a function of u. ParametricPlot[{{fx, fy}, {gx, gy}, ... }, {u, umin, umax}] plots several parametric curves."
ParametricPlot3D::usage = "ParametricPlot3D[{fx, fy, fz}, {u, umin, umax}] produces a three-dimensional space curve parametrized by a variable u which runs from umin to umax. ParametricPlot3D[{fx, fy, fz}, {u, umin, umax}, {v, vmin, vmax}] produces a three-dimensional surface parametrized by u and v. ParametricPlot3D[{fx, fy, fz, s}, ... ] shades the plot according to the color specification s. ParametricPlot3D[{{fx, fy, fz}, {gx, gy, gz}, ... }, ... ] plots several objects together."
ParentDirectory::usage = "ParentDirectory[ ] gives the parent of the current working directory. ParentDirectory[\"dir\"] gives the parent of the directory dir."
ParentForm::usage = "ParentForm sets the parent form for a boxes format."
Parenthesize::usage = "Parenthesize[ expr, fmt, prec, group] will represent expr in format fmt and parenthesize it if necessary."
Part::usage = "expr[[i]] or Part[expr, i] gives the ith part of expr. expr[[-i]] counts from the end. expr[[0]] gives the head of expr. expr[[i, j, ... ]] or Part[expr, i, j, ... ] is equivalent to expr[[i]] [[j]] ... . expr[[ {i1, i2, ... } ]] gives a list of the parts i1, i2, ...  of expr."
Partition::usage = "Partition[list, n] partitions list into non-overlapping sublists of length n. Partition[list, n, d] generates sublists with offset d. Partition[list, {n1, n2, ... }] partitions a nested list into blocks of size n1 \[Cross] n2 \[Cross] \[Ellipsis] . Partition[list, {n1, n2, ... }, {d1, d2, ... }] uses offset di at level i in list. Partition[list, n, d, {kL, kR}] specifies that the first element of list should appear at position kL in the first sublist, and the last element of list should appear at or after position kR in the last sublist. If additional elements are needed, Partition fills them in by treating list as cyclic. Partition[list, n, d, {kL, kR}, x] pads if necessary by repeating the element x. Partition[list, n, d, {kL, kR}, {x1, x2, ... }] pads if necessary by cyclically repeating the elements xi. Partition[list, n, d, {kL, kR}, {}] uses no padding, and so can yield sublists of different lengths. Partition[list, nlist, dlist, {klistL, klistR}, padlist] specifies alignments and padding in a nested list."
PartitionsP::usage = "PartitionsP[n] gives the number p(n) of unrestricted partitions of the integer n."
PartitionsQ::usage = "PartitionsQ[n] gives the number q(n) of partitions of the integer n into distinct parts."
Path::usage = "Path is an option for Get and related functions which gives a list of directories to search in attempting to find an external file."
Pattern::usage = "s:obj represents the pattern object obj, assigned the name s."
PatternTest::usage = "p?test is a pattern object that stands for any expression which matches p, and on which the application of test gives True."
Pause::usage = "Pause[n] pauses for at least n seconds."
Permutations::usage = "Permutations[list] generates a list of all possible permutations of the elements in list."
Pi::usage = "Pi is the constant pi, with numerical value approximately equal to 3.14159."
Pick::usage = "Pick[list, sel] picks out those elements of list for which the corresponding element of sel is True. Pick[list, sel, patt] picks out those elements of list for which the corresponding element of sel matches patt."
Piecewise::usage = "Piecewise[{{val1, cond1}, {val2, cond2}, ... }] represents a piecewise function with values vali in the regions defined by the conditions condi. Piecewise[{{val1, cond1}, ... }, val] uses default value val if none of the condi apply. The default for val is 0."
PiecewiseExpand::usage = "PiecewiseExpand[expr] expands nested piecewise functions in expr to give a single piecewise function. PiecewiseExpand[expr, assum] expands piecewise functions using assumptions. PiecewiseExpand[expr, assum, dom] does the expansion over the domain dom."
Pink::usage = "Pink represents the color pink in graphics or style specifications."
Pivoting::usage = "Pivoting is an option to certain matrix decomposition functions. With Pivoting -> False, no pivoting is done. With Pivoting -> True, column pivoting is carried out and the list of matrices returned is augmented by the appropriate permutation matrix."
Plain::usage = "Plain is an obsolete symbol. Prior to Version 2.0, it was a setting for the option TextRendering, which is also obsolete."
Play::usage = "Play[f, {t, tmin, tmax}] plays a sound whose amplitude is given by f as a function of time t in seconds between tmin and tmax."
PlayRange::usage = "PlayRange is an option for Play and related functions which specifies what range of sound amplitude levels should be included."
Plot::usage = "Plot[f, {x, xmin, xmax}] generates a plot of f as a function of x from xmin to xmax. Plot[{f1, f2, ... }, {x, xmin, xmax}] plots several functions fi."
Plot3D::usage = "Plot3D[f, {x, xmin, xmax}, {y, ymin, ymax}] generates a three-dimensional plot of f as a function of x and y. Plot3D[{f, s}, {x, xmin, xmax}, {y, ymin, ymax}] generates a three-dimensional plot in which the height of the surface is specified by f, and the shading is specified by s."
Plot3Matrix::usage = "Plot3Matrix is an option to Graphics3D and related functions that can be used to specify the explicit homogeneous perspective transformation matrix."
PlotDivision::usage = "PlotDivision is an option for Plot which specifies the maximum amount of subdivision to be used in attempting to generate a smooth curve."
PlotJoined::usage = "PlotJoined is an option for ListPlot that specifies whether the points plotted should be joined by a line."
PlotLabel::usage = "PlotLabel is an option for graphics functions that specifies an overall label for a plot."
PlotPoints::usage = "PlotPoints is an option for plotting functions that specifies how many initial sample points to use."
PlotRange::usage = "PlotRange is an option for graphics functions that specifies what points to include in a plot."
PlotRegion::usage = "PlotRegion is an option for graphics functions that specifies what region of the final display area a plot should fill."
PlotStyle::usage = "PlotStyle is an option for Plot and ListPlot that specifies the style of lines or points to be plotted."
Plus::usage = "x + y + z represents a sum of terms."
Pochhammer::usage = "Pochhammer[a, n] gives the Pochhammer symbol representing the product (a)(a+1) ... (a+n-1)."
Point::usage = "Point[coords] is a graphics primitive that represents a point."
PointForm::usage = "PointForm[g] is a three-dimensional graphics directive that specifies that points are to be drawn with the graphics directive g or the list of graphics directives g."
PointSize::usage = "PointSize[d] is a graphics directive which specifies that points which follow are to be shown if possible as circular regions with diameter d. The diameter d is given as a fraction of the total width of the plot."
PolyGamma::usage = "PolyGamma[z] gives the digamma function psi(z). PolyGamma[n, z] gives the nth derivative of the digamma function."
Polygon::usage = "Polygon[{pt1, pt2, ... }] is a graphics primitive that represents a filled polygon."
PolygonIntersections::usage = "PolygonIntersections is an option for Graphics3D which specifies whether intersecting polygons should be left unchanged."
PolyLog::usage = "PolyLog[n, z] gives the nth polylogarithm function of z. PolyLog[n, p, z] gives the Nielsen generalized polylogarithm function of z for parameters n and p."
PolynomialGCD::usage = "PolynomialGCD[poly1, poly2, ... ] gives the greatest common divisor of the polynomials polyi. PolynomialGCD[poly1, poly2, ... , Modulus->p] evaluates the GCD modulo the prime p."
PolynomialLCM::usage = "PolynomialLCM[poly1, poly2, ... ] gives the least common multiple of the polynomials polyi. PolynomialLCM[poly1, poly2, ... , Modulus->p] evaluates the LCM modulo the prime p."
PolynomialMod::usage = "PolynomialMod[poly, m] gives the polynomial poly reduced modulo m. PolynomialMod[poly, {m1, m2, ... }] reduces modulo all of the mi."
PolynomialQ::usage = "PolynomialQ[expr, var] yields True if expr is a polynomial in var, and yields False otherwise. PolynomialQ[expr, {var1, ... }] tests whether expr is a polynomial in the vari."
PolynomialQuotient::usage = "PolynomialQuotient[p, q, x] gives the quotient of p and q, treated as polynomials in x, with any remainder dropped."
PolynomialReduce::usage = "PolynomialReduce[poly, {poly1, poly2, ... }, {x1, x2, ... }] yields a list representing a reduction of poly in terms of the polyi. The list has the form {{a1, a2, ... }, b}, where b is minimal and a1 poly1 + a2 poly2 + ...  + b is exactly poly."
PolynomialRemainder::usage = "PolynomialRemainder[p, q, x] gives the remainder from dividing p by q, treated as polynomials in x."
Polynomials::usage = "Polynomials[var] is a setting for the CoefficientDomain option of GroebnerBasis and PolynomialReduce."
Position::usage = "Position[expr, pattern] gives a list of the positions at which objects matching pattern appear in expr. Position[expr, pattern, levspec] finds only objects that appear on levels specified by levspec. Position[expr, pattern, levspec, n] gives the positions of the first n objects found."
Positive::usage = "Positive[x] gives True if x is a positive number."
Postfix::usage = "Postfix[f[expr]] prints with f[expr] given in default postfix form: expr // f. Postfix[f[expr], h] prints as exprh."
Power::usage = "x^y gives x to the power y."
PowerExpand::usage = "PowerExpand[expr] expands all powers of products and powers."
PowerMod::usage = "PowerMod[a, b, n] gives a^b mod n. For negative b, PowerMod[a, b, n] gives modular inverses."
PrecedenceForm::usage = "PrecedenceForm[expr, prec] prints with expr parenthesized as it would be if it contained an operator with precedence prec."
Precision::usage = "Precision[x] gives the effective number of digits of precision in the number x."
PrecisionGoal::usage = "PrecisionGoal is an option for various numerical operations which specifies how many effective digits of precision should be sought in the final result."
PreDecrement::usage = "--x decreases the value of x by 1, returning the new value of x."
Prefix::usage = "Prefix[f[expr]] prints with f[expr] given in default prefix form: f @ expr. Prefix[f[expr], h] prints as hexpr."
PreIncrement::usage = "++x increases the value of x by 1, returning the new value of x."
Prepend::usage = "Prepend[expr, elem] gives expr with elem prepended."
PrependTo::usage = "PrependTo[s, elem] prepends elem to the value of s, and resets s to the result."
Prime::usage = "Prime[n] gives the nth prime number."
PrimePi::usage = "PrimePi[x] gives the number of primes less than or equal to x."
PrimeQ::usage = "PrimeQ[expr] yields True if expr is a prime number, and yields False otherwise."
Primes::usage = "Primes represents the domain of prime numbers, as in x \[Element] Primes."
PrincipalValue::usage = "PrincipalValue is an option for Integrate that specifies whether the Cauchy principal value should be found for a definite integral."
Print::usage = "Print[expr1, expr2, ... ] prints the expri concatenated together."
PrintingStyleEnvironment::usage = "PrintingStyleEnvironment is an option for notebooks which specifies the style environment to be used in printing the notebook on paper."
Product::usage = "Product[f, {i, imax}] evaluates the product of the expressions f as evaluated for each i from 1 to imax. Product[f, {i, imin, imax}] starts with i = imin. Product[f, {i, imin, imax, di}] uses steps di. Product[f, {i, imin, imax}, {j, jmin, jmax}, ... ] evaluates a product over multiple indices."
ProductLog::usage = "ProductLog[z] gives the principal solution for w in z = w e^w. ProductLog[k, z] gives the kth solution."
Prolog::usage = "Prolog is an option for graphics functions which gives a list of graphics primitives to be rendered before the main part of the graphics is rendered."
PromptForm::usage = "PromptForm[prompt, expr] prints as an output prompt and expression."
Protect::usage = "Protect[s1, s2, ... ] sets the attribute Protected for the symbols si. Protect[\"form1\", \"form2\", ... ] protects all symbols whose names match any of the string patterns formi."
Protected::usage = "Protected is an attribute which prevents any values associated with a symbol from being modified."
PseudoInverse::usage = "PseudoInverse[m] finds the pseudoinverse of a rectangular matrix."
Purple::usage = "Purple represents the color purple in graphics or style specifications."
Put::usage = "expr >> filename writes expr to a file. Put[expr1, expr2, ... , \"filename\"] writes a sequence of expressions expri to a file."
PutAppend::usage = "expr >>> filename appends expr to a file. PutAppend[expr1, expr2, ... , \"filename\"] appends a sequence of expressions expri to a file."
QRDecomposition::usage = "QRDecomposition[m] yields the QR decomposition for a numerical matrix m. The result is a list {q, r}, where q is an orthogonal matrix and r is an upper-triangular matrix."
Quantile::usage = "Quantile[list, q] gives the qth quantile of list. Quantile[list, {q1, q2, ... }] gives a list of quantiles q1, q2, ... . Quantile[list, q, {{a, b}, {c, d}}] uses the quantile definition specified by parameters a, b, c, d."
QuasiMonteCarlo::usage = "QuasiMonteCarlo is a choice for the option Method of NIntegrate. Method -> QuasiMonteCarlo causes the use of shifted Hammerslag points in a Monte Carlo type algorithm."
QuasiNewton::usage = "QuasiNewton is a choice for the option Method of FindMinimum. Method -> QuasiNewton specifies that the variable metric quasi-Newton method will be used."
Quit::usage = "Quit[ ] terminates a Mathematica kernel session."
Quotient::usage = "Quotient[m, n] gives the integer quotient of m and n. Quotient[m, n, d] uses an offset d."
RadicalBox::usage = "RadicalBox[x, n] represents the nth root of x in input and output."
Random::usage = "Random[ ] gives a uniformly distributed pseudorandom Real in the range 0 to 1. Random[type, range] gives a pseudorandom number of the specified type, lying in the specified range. Possible types are: Integer, Real and Complex. The default range is 0 to 1. You can give the range {min, max} explicitly; a range specification of max is equivalent to {0, max}."
Range::usage = "Range[imax] generates the list {1, 2, ... , imax}. Range[imin, imax] generates the list {imin, ... , imax}. Range[imin, imax, di] uses step di."
Raster::usage = "Raster[{{a11, a12, ... }, ... }] is a two-dimensional graphics primitive which represents a rectangular array of gray cells."
RasterArray::usage = "RasterArray[{{g11, g12, ... }, ... }] is a two-dimensional graphics primitive which represents a rectangular array of cells colored according to the graphics directives gij."
Rational::usage = "Rational is the head used for rational numbers."
RationalFunctions::usage = "RationalFunctions is a setting for the CoefficientDomain option of GroebnerBasis and PolynomialReduce."
Rationalize::usage = "Rationalize[x] takes Real numbers in x that are close to rationals, and converts them to exact Rational numbers. Rationalize[x, dx] performs the conversion whenever the error made is smaller in magnitude than dx."
Rationals::usage = "Rationals represents the domain of rational numbers, as in x \[Element] Rationals."
Raw::usage = "Raw[h, \"hexstring\"] constructs a raw data object with head h, and with contents corresponding to the binary bit pattern represented by the string hexstring, interpreted as a hexadecimal number."
RawMedium::usage = "RawMedium is an internal symbol."
Re::usage = "Re[z] gives the real part of the complex number z."
Read::usage = "Read[stream] reads one expression from an input stream, and returns the expression. Read[stream, type] reads one object of the specified type. Read[stream, {type1, type2, ... }] reads a sequence of objects of the specified types."
ReadList::usage = "ReadList[\"file\"] reads all the remaining expressions in a file, and returns a list of them. ReadList[\"file\", type] reads objects of the specified type from a file, until the end of the file is reached. The list of objects read is returned. ReadList[\"file\", {type1, type2, ... }] reads objects with a sequence of types, until the end of the file is reached. ReadList[\"file\", types, n] reads only the first n objects of the specified types."
ReadProtected::usage = "ReadProtected is an attribute which prevents values associated with a symbol from being seen."
Real::usage = "Real is the head used for real (floating-point) numbers."
RealBlockForm::usage = "RealBlockForm is an option of SchurDecomposition which specifies whether complex eigenvalues of a real input matrix should be returned as 2x2 real blocks or as complex values."
RealDigits::usage = "RealDigits[x] gives a list of the digits in the approximate real number x, together with the number of digits that are to the left of the decimal point. RealDigits[x, b] gives a list of base-b digits in x. RealDigits[x, b, len] gives a list of len digits. RealDigits[x, b, len, n] gives len digits starting with the coefficient of b^n."
Reals::usage = "Reals represents the domain of real numbers, as in x \[Element] Reals."
Reap::usage = "Reap[expr] gives the value of expr together with all expressions to which Sow has been applied during its evaluation. Expressions sown using Sow[e] or Sow[e, tagi] with different tags are given in different lists. Reap[expr, patt] reaps only expressions sown with tags that match patt. Reap[expr, {patt1, patt2, ... }] puts expressions associated with each of the patti in a separate list. Reap[expr, patt, f] returns {expr, {f[tag1, {e11, e12, ... }], ... }}."
Record::usage = "Record represents a record in Read, Find and related functions."
RecordLists::usage = "RecordLists is an option for ReadList which specifies whether objects from separate records should be returned in separate sublists."
RecordSeparators::usage = "RecordSeparators is an option for Read, Find and related functions which specifies the list of strings to be taken as delimiters for records."
Rectangle::usage = "Rectangle[{xmin, ymin}, {xmax, ymax}] is a two-dimensional graphics primitive that represents a filled rectangle, oriented parallel to the axes. Rectangle[{xmin, ymin}, {xmax, ymax}, graphics] gives a rectangle filled with the specified graphics."
Red::usage = "Red represents the color red in graphics or style specifications."
Reduce::usage = "Reduce[expr, vars] reduces the statement expr by solving equations or inequalities for vars and eliminating quantifiers. Reduce[expr, vars, dom] does the reduction over the domain dom. Common choices of dom are Reals, Integers and Complexes."
Refine::usage = "Refine[expr, assum] gives the form of expr that would be obtained if symbols in it were replaced by explicit numerical expressions satisfying the assumptions assum. Refine[expr] uses default assumptions specified by any enclosing Assuming constructs."
RegularExpression::usage = "RegularExpression[\"regex\"] represents the generalized regular expression specified by the string \"regex\"."
Reinstall::usage = "Reinstall[link] un-installs the specified external package and installs it again."
ReleaseHold::usage = "ReleaseHold[expr] removes Hold, HoldForm, HoldPattern and HoldComplete in expr."
Remove::usage = "Remove[symbol1, ... ] removes symbols completely, so that their names are no longer recognized by Mathematica. Remove[\"form1\", \"form2\", ... ] removes all symbols whose names match any of the string patterns formi."
Removed::usage = "Removed[string] is printed to indicate a symbol that has been removed."
RenameDirectory::usage = "RenameDirectory[\"dir1\", \"dir2\"] renames the directory dir1 to dir2."
RenameFile::usage = "RenameFile[\"file1\", \"file2\"] renames file1 to file2."
RenderAll::usage = "RenderAll is an option for Graphics3D which specifies whether or not PostScript should be generated for all polygons."
Repeated::usage = "p.. is a pattern object which represents a sequence of one or more expressions, each matching p."
RepeatedNull::usage = "p... is a pattern object which represents a sequence of zero or more expressions, each matching p."
RepeatedString::usage = "RepeatedString is an internal symbol used for formatting and printing."
Replace::usage = "Replace[expr, rules] applies a rule or list of rules in an attempt to transform the entire expression expr. Replace[expr, rules, levelspec] applies rules to parts of expr specified by levelspec."
ReplaceAll::usage = "expr /. rules applies a rule or list of rules in an attempt to transform each subpart of an expression expr."
ReplaceHeldPart::usage = "ReplaceHeldPart is an obsolete function. Its functionality is now provided by ReplacePart."
ReplaceList::usage = "ReplaceList[expr, rules] attempts to transform the entire expression expr by applying a rule or list of rules in all possible ways, and returns a list of the results obtained. ReplaceList[expr, rules, n] gives a list of at most n results."
ReplacePart::usage = "ReplacePart[expr, new, n] yields an expression in which the nth part of expr is replaced by new. ReplacePart[expr, new, {i, j, ... }] replaces the part at position {i, j, ... }. ReplacePart[expr, new, {{i1, j1, ... }, {i2, j2, ... }, ... }] replaces parts at several positions by new. ReplacePart[expr, new, pos, npos] replaces parts at positions pos in expr by parts at positions npos in new."
ReplaceRepeated::usage = "expr //. rules repeatedly performs replacements until expr no longer changes."
Rescale::usage = "Rescale[x, {min, max}] gives x rescaled to run from 0 to 1 over the range min to max. Rescale[x, {min, max}, {xmin, xmax}] gives x rescaled to run from xmin to xmax over the range min to max."
ResetDirectory::usage = "ResetDirectory[ ] resets the current working directory to its previous value."
ResetMedium::usage = "ResetMedium is an obsolete symbol, superseded by SetOptions in Version 2.0. ResetMedium[\"file\", options] resets the options associated with a file that is already open. ResetMedium[options] resets the options for the standard output."
Residue::usage = "Residue[expr, {x, x0}] finds the residue of expr at the point x = x0."
Resolve::usage = "Resolve[expr] attempts to resolve expr into a form that eliminates ForAll and Exists quantifiers. Resolve[expr, dom] works over the domain dom. Common choices of dom are Complexes, Reals and Booleans."
Rest::usage = "Rest[expr] gives expr with the first element removed."
Resultant::usage = "Resultant[poly1, poly2, var] computes the resultant of the polynomials poly1 and poly2 with respect to the variable var. Resultant[poly1, poly2, var, Modulus->p] computes the resultant modulo the prime p."
Return::usage = "Return[expr] returns the value expr from a function. Return[ ] returns the value Null."
ReturnInputFormPacket::usage = "ReturnInputFormPacket is an internal symbol used for formatting."
Reverse::usage = "Reverse[expr] reverses the order of the elements in expr."
RGBColor::usage = "RGBColor[red, green, blue] is a graphics directive which specifies that objects which follow are to be displayed, if possible, in the color given."
RiemannSiegelTheta::usage = "RiemannSiegelTheta[t] gives the Riemann-Siegel theta function."
RiemannSiegelZ::usage = "RiemannSiegelZ[t] gives the Riemann-Siegel function Z(t)."
Right::usage = "Right is used to specify alignment in printforms such as ColumnForm and TableForm."
Root::usage = "Root[f, k] represents the kth root of the polynomial equation f[x] == 0."
RootReduce::usage = "RootReduce[expr] attempts to reduce expr to a single Root object."
Roots::usage = "Roots[lhs==rhs, var] yields a disjunction of equations which represent the roots of a polynomial equation."
RootSum::usage = "RootSum[f, form] represents the sum of form[x] for all x that satisfy the polynomial equation f[x] == 0."
RotateLabel::usage = "RotateLabel is an option for two-dimensional graphics functions which specifies whether labels on vertical frame axes should be rotated to be vertical."
RotateLeft::usage = "RotateLeft[expr, n] cycles the elements in expr n positions to the left. RotateLeft[expr] cycles one position to the left. RotateLeft[expr, {n1, n2, ... }] cycles elements at successive levels ni positions to the left."
RotateRight::usage = "RotateRight[expr, n] cycles the elements in expr n positions to the right. RotateRight[expr] cycles one position to the right. RotateRight[expr, {n1, n2, ... }] cycles elements at successive levels ni positions to the right."
Round::usage = "Round[x] gives the integer closest to x."
RowAlignments::usage = "RowAlignments is an option for GridBox which specifies how entries in each row should be aligned."
RowBox::usage = "RowBox[{box1, box2, ... }] represents a row of boxes or strings in input and output."
RowLines::usage = "RowLines is an option for GridBox which specifies whether lines should be drawn between adjacent rows."
RowMinHeight::usage = "RowMinHeight is an option for GridBox which specifies the minimum total height in units of font size that should be allowed for each row."
RowReduce::usage = "RowReduce[m] gives the row-reduced form of the matrix m."
RowsEqual::usage = "RowsEqual is an option for GridBox which specifies whether all rows in the grid should be assigned equal total height."
RowSpacings::usage = "RowSpacings is an option for GridBox which specifies the spaces in x-heights that should be inserted between successive rows."
RSolve::usage = "RSolve[eqn, a[n], n] solves a recurrence equation for a[n]. RSolve[{eqn1, eqn2, ... }, {a1[n], a2[n], ... }, n] solves a system of recurrence equations. RSolve[eqn, a[n1, n2, ... ], {n1, n2, ... }] solves a partial recurrence equation."
Rule::usage = "lhs -> rhs represents a rule that transforms lhs to rhs."
RuleCondition::usage = "RuleCondition is an internal symbol."
RuleDelayed::usage = "lhs :> rhs represents a rule that transforms lhs to rhs, evaluating rhs only when the rule is used."
RuleForm::usage = "RuleForm is an internal symbol used for formatting and printing."
Run::usage = "Run[expr1, expr2, ... ] generates the printed form of the expressions expri, separated by spaces, and runs it as an external, operating system, command."
RungeKutta::usage = "RungeKutta is a choice for the option Method of NDSolve. Method -> RungeKutta uses a Runge-Kutta-Fehlberg method which is not recommended for stiff equations."
RunThrough::usage = "RunThrough[\"command\", expr] executes an external command, giving the printed form of expr as input, and taking the output, reading it as Mathematica input, and returning the result."
SameQ::usage = "lhs === rhs yields True if the expression lhs is identical to rhs, and yields False otherwise."
SameTest::usage = "SameTest is an option for functions like FixedPoint that specifies the comparison function to apply to pairs of results to determine whether they should be considered the same."
SampleDepth::usage = "SampleDepth is an option for sound primitives which specifies how many bits should be used to encode sound amplitude levels."
SampledSoundFunction::usage = "SampledSoundFunction[f, n, r] is a sound primitive, which represents a sound whose amplitude sampled r times a second is generated by applying the function f to successive integers from 1 to n."
SampledSoundList::usage = "SampledSoundList[{a1, a2, ... }, r] is a sound primitive, which represents a sound whose amplitude has levels ai sampled r times a second."
SampleRate::usage = "SampleRate is an option for sound primitives which specifies the number of samples per second to generate for sounds."
Save::usage = "Save[\"filename\", symbol] appends definitions associated with the specified symbol to a file. Save[\"filename\", \"form\"] appends definitions associated with all symbols whose names match the string pattern form. Save[\"filename\", \"context`\"] appends definitions associated with all symbols in the specified context. Save[\"filename\", {object1, object2, ... }] appends definitions associated with several objects."
Scaled::usage = "Scaled[{x, y, ... }] gives the position of a graphical object in terms of coordinates scaled to run from 0 to 1 across the whole plot range in each direction. Scaled[{dx, dy, ... }, {x0, y0, ... }] gives a position obtained by starting at ordinary coordinates {x0, y0, ... }, then moving by a scaled offset {dx, dy, ... }."
Scan::usage = "Scan[f, expr] evaluates f applied to each element of expr in turn. Scan[f, expr, levelspec] applies f to parts of expr specified by levelspec."
SchurDecomposition::usage = "SchurDecomposition[m] yields the Schur decomposition for a numerical matrix m. The result is a list {q, t} where q is an orthonormal matrix and t is a block upper-triangular matrix. SchurDecomposition[{m, a}] gives the generalized Schur decomposition of m with respect to a."
ScientificForm::usage = "ScientificForm[expr] prints with all real numbers in expr given in scientific notation. ScientificForm[expr, n] prints with numbers given to n-digit precision."
ScreenStyleEnvironment::usage = "ScreenStyleEnvironment is an option for notebooks which specifies the style environment to be used in displaying a notebook on the screen."
ScriptBaselineShifts::usage = "ScriptBaselineShifts is an option for StyleBox which specifies the minimum distance in x-heights to shift subscripts and superscripts."
ScriptMinSize::usage = "ScriptMinSize is an option for StyleBox which specifies the minimum font size to use in rendering subscripts, etc."
ScriptSizeMultipliers::usage = "ScriptSizeMultipliers is an option for StyleBox which specifies how much smaller to render each successive level of subscripts, etc."
Sec::usage = "Sec[z] gives the secant of z."
Sech::usage = "Sech[z] gives the hyperbolic secant of z."
Second::usage = "Second is a unit of time used by functions such as Timing."
SeedRandom::usage = "SeedRandom[n] resets the pseudorandom number generator, using the integer n as a seed. SeedRandom[ ] resets the generator, using as a seed the time of day."
Select::usage = "Select[list, crit] picks out all elements ei of list for which crit[ei] is True. Select[list, crit, n] picks out the first n elements for which crit[ei] is True."
Selectable::usage = "Selectable is an option for displayed objects, cells and notebooks which specifies whether their contents can be selected interactively using the front end."
SelectedNotebook::usage = "SelectedNotebook[ ] gives the currently selected notebook in the front end."
SelectionAnimate::usage = "SelectionAnimate[notebook] animates graphics in the current selection in a notebook. SelectionAnimate[notebook, t] animates graphics for t seconds."
SelectionCreateCell::usage = "SelectionCreateCell[notebook] copies the contents of the current selection in a notebook into a new cell. SelectionCreateCell[notebook, sel] sets the current selection after the copy to be as specified by sel."
SelectionEvaluate::usage = "SelectionEvaluate[notebook] replaces the current selection in a notebook with the result obtained by evaluating the contents of the selection in the kernel. SelectionEvaluate[notebook, sel] sets the current selection after the evaluation to be as specified by sel."
SelectionEvaluateCreateCell::usage = "SelectionEvaluateCreateCell[notebook] takes the current selection in a notebook and creates a new cell containing the result obtained by evaluating the contents of the selection using the kernel. SelectionEvaluateCreateCell[notebook, sel] sets the current selection after the evaluation to be as specified by sel."
SelectionMove::usage = "SelectionMove[obj, dir, unit] moves the current selection in an open notebook in the front end in the direction dir by the specified unit. SelectionMove[obj, dir, unit, n] repeats the move n times."
Sequence::usage = "Sequence[expr1, expr2, ... ] represents a sequence of arguments to be spliced automatically into any function."
SequenceForm::usage = "SequenceForm[expr1, expr2, ... ] prints as the textual concatenation of the printed forms of the expri."
SequenceHold::usage = "SequenceHold is an attribute which specifies that Sequence objects appearing in the arguments of a function should not automatically be flattened out."
SequenceLimit::usage = "SequenceLimit[list] returns the approximation given by Wynn's epsilon algorithm to the limit of a sequence whose first few terms are given by list. Warning: Wynn's epsilon algorithm can give finite results for divergent sequences."
Series::usage = "Series[f, {x, x0, n}] generates a power series expansion for f about the point x = x0 to order (x - x0)^n. Series[f, {x, x0, nx}, {y, y0, ny}] successively finds series expansions with respect to y, then x."
SeriesCoefficient::usage = "SeriesCoefficient[series, n] finds the coefficient of the nth order term in a power series. SeriesCoefficient[series, {n1, n2, ... }] finds a coefficient in a multivariate series."
SeriesData::usage = "SeriesData[x, x0, {a0, a1, ... }, nmin, nmax, den] represents a power series in the variable x about the point x0. The ai are the coefficients in the power series. The powers of (x-x0) that appear are nmin/den, (nmin+1)/den, ... , nmax/den."
SessionTime::usage = "SessionTime[ ] gives the total number of seconds of real time that have elapsed since the beginning of your Mathematica session."
Set::usage = "lhs = rhs evaluates rhs and assigns the result to be the value of lhs. From then on, lhs is replaced by rhs whenever it appears. {l1, l2, ... } = {r1, r2, ... } evaluates the ri, and assigns the results to be the values of the corresponding li."
SetAccuracy::usage = "SetAccuracy[expr, a] yields a version of expr in which all numbers have been set to have accuracy a."
SetAttributes::usage = "SetAttributes[s, attr] adds attr to the list of attributes of the symbol s."
SetDelayed::usage = "lhs := rhs assigns rhs to be the delayed value of lhs. rhs is maintained in an unevaluated form. When lhs appears, it is replaced by rhs, evaluated afresh each time."
SetDirectory::usage = "SetDirectory[\"dir\"] sets the current working directory."
SetFileDate::usage = "SetFileDate[\"file\"] sets the modification date for a file to be the current date."
SetOptions::usage = "SetOptions[s, name1->value1, name2->value2, ... ] sets the specified default options for a symbol s. SetOptions[stream, ... ] or SetOptions[\"name\", ... ] sets options associated with a particular stream. SetOptions[object, ... ] sets options associated with an external object such as a NotebookObject."
SetPrecision::usage = "SetPrecision[expr, p] yields a version of expr in which all numbers have been set to have precision p."
SetSelectedNotebook::usage = "SetSelectedNotebook[notebook] makes the specified notebook be the currently selected one in the front end."
SetStreamPosition::usage = "SetStreamPosition[stream, n] sets the current point in an open stream."
Shading::usage = "Shading is an option for SurfaceGraphics that specifies whether the surfaces should be shaded."
Shallow::usage = "Shallow[expr] prints as a shallow form of expr. Shallow[expr, depth] prints with all parts of expr below the specified depth given in skeleton form. Shallow[expr, {depth, length}] also gives parts whose lengths are above the specified limit in skeleton form. Shallow[expr, {depth, length}, form] uses skeleton form for any parts which match the pattern form."
Share::usage = "Share[expr] changes the way expr is stored internally, to try and minimize the amount of memory used. Share[ ] tries to minimize the memory used to store all expressions."
Short::usage = "Short[expr] prints as a short form of expr, less than about one line long. Short[expr, n] prints as a form of expr about n lines long."
Show::usage = "Show[graphics, options] displays two- and three-dimensional graphics, using the options specified. Show[g1, g2, ... ] shows several plots combined."
ShowAutoStyles::usage = "ShowAutoStyles is an option for Cell which specifies whether styles that are specified to be automatically used for various syntactic and other constructs should be shown."
ShowCellBracket::usage = "ShowCellBracket is an option for Cell which specifies whether to display the bracket that indicates the extent of the cell."
ShowCellLabel::usage = "ShowCellLabel is an option for Cell which specifies whether to display the label for a cell."
ShowCellTags::usage = "ShowCellTags is an option for Cell which specifies whether to display tags for a cell."
ShowCursorTracker::usage = "ShowCursorTracker is an option for Cell which specifies whether an elliptical spot should appear momentarily to guide the eye if the cursor position jumps."
ShowPageBreaks::usage = "ShowPageBreaks is an option for Notebook which specifies whether to indicate in the on-screen display of a notebook where page breaks would occur if the notebook were printed."
ShowSelection::usage = "ShowSelection is an option for Cell which specifies whether to show the current selection highlighted."
ShowSpecialCharacters::usage = "ShowSpecialCharacters is an option for Cell which specifies whether to replace [Name], :nnnn, etc. by explicit special characters."
ShowStringCharacters::usage = "ShowStringCharacters is an option for Cell which specifies whether to display \" when a string is entered."
Sign::usage = "Sign[x] gives -1, 0 or 1 depending on whether x is negative, zero, or positive."
Signature::usage = "Signature[list] gives the signature of the permutation needed to place the elements of list in canonical order."
SignPadding::usage = "SignPadding is an option for NumberForm and related functions which specifies whether padding should be inserted after signs."
Simplify::usage = "Simplify[expr] performs a sequence of algebraic and other transformations on expr, and returns the simplest form it finds. Simplify[expr, assum] does simplification using assumptions."
Sin::usage = "Sin[z] gives the sine of z."
SingleLetterItalics::usage = "SingleLetterItalics is an option for Cell which specifies whether single-letter names should be displayed in italics."
SingularityDepth::usage = "SingularityDepth is an option for NIntegrate. SingularityDepth -> n specifies that n recursive subdivisions can be done before a change of variable is used at the endpoints of the interval of integration."
SingularValueDecomposition::usage = "SingularValueDecomposition[m] gives the singular value decomposition for a numerical matrix m. The result is a list of matrices {u, w, v}, where w is a diagonal matrix, and m can be written as u . w . Conjugate[Transpose[v]]. SingularValueDecomposition[{m, a}] gives the generalized singular value decomposition of m with respect to a. SingularValueDecomposition[m, k] gives the singular value decomposition associated with the k largest singular values of m."
SingularValueList::usage = "SingularValueList[m] gives a list of the non-zero singular values of a numerical matrix m. SingularValueList[{m, a}] gives the generalized singular values of m with respect to a. SingularValueList[m, k] gives the k largest singular values of m."
Sinh::usage = "Sinh[z] gives the hyperbolic sine of z."
SinhIntegral::usage = "SinhIntegral[z] gives the hyperbolic sine integral function Shi(z)."
SinIntegral::usage = "SinIntegral[z] gives the sine integral function Si(z)."
SixJSymbol::usage = "SixJSymbol[{j1, j2, j3}, {j4, j5, j6}] gives the values of the Racah 6-j symbol."
Skeleton::usage = "Skeleton[n] represents a sequence of n omitted elements in an expression printed with Short or Shallow. The standard print form for Skeleton is <<n>>."
Skip::usage = "Skip[stream, type] skips one object of the specified type in an input stream. Skip[stream, type, n] skips n objects of the specified type."
Slot::usage = "# represents the first argument supplied to a pure function. #n represents the nth argument."
SlotSequence::usage = "## represents the sequence of arguments supplied to a pure function. ##n represents the sequence of arguments supplied to a pure function, starting with the nth argument."
Socket::usage = "Socket is a possible value returned by FileType and related functions."
Solve::usage = "Solve[eqns, vars] attempts to solve an equation or set of equations for the variables vars. Solve[eqns, vars, elims] attempts to solve the equations for vars, eliminating the variables elims."
SolveAlways::usage = "SolveAlways[eqns, vars] gives the values of parameters that make the equations eqns valid for all values of the variables vars."
SolveDelayed::usage = "SolveDelayed is an option to NDSolve. SolveDelayed -> False causes the derivatives to be solved for symbolically at the beginning. SolveDelayed -> True causes the ODEs to be evaluated numerically and the derivatives solved for at each step."
Sort::usage = "Sort[list] sorts the elements of list into canonical order. Sort[list, p] sorts using the ordering function p."
Sound::usage = "Sound[primitives] represents a sound."
Sow::usage = "Sow[e] specifies that e should be collected by the nearest enclosing Reap. Sow[e, tag] specifies that e should be collected by the nearest enclosing Reap whose pattern matches tag. Sow[e, {tag1, tag2, ... }] specifies that e should be collected once for each pattern that matches a tagi."
SpaceForm::usage = "SpaceForm[n] prints as n spaces."
SpanAdjustments::usage = "SpanAdjustments is an option of certain BoxForm primitives."
SpanCharacterRounding::usage = "SpanCharacterRounding is an option of certain BoxForm primitives."
SpanMaxSize::usage = "SpanMaxSize is an option of certain BoxForm primitives."
SpanMinSize::usage = "SpanMinSize is an option of certain BoxForm primitives."
SparseArray::usage = "SparseArray[{pos1->val1, pos2->val2, ... }] yields a sparse array in which values vali appear at positions posi. SparseArray[{pos1, pos2, ... }->{val1, val2, ... }] yields the same sparse array. SparseArray[list] yields a sparse array version of list. SparseArray[data, {d1, d2, ... }] yields a sparse array representing a d1 \[Cross] d2 \[Cross] ... array. SparseArray[data, dims, val] yields a sparse array in which unspecified elements are taken to have value val."
SpellingCorrection::usage = "SpellingCorrection is an option for StringMatchQ, Names and related functions which specifies whether strings should be considered to match even when a small fraction of the characters in them are different."
SphericalHarmonicY::usage = "SphericalHarmonicY[l, m, theta, phi] gives the spherical harmonic function of theta and phi for parameters l and m."
SphericalRegion::usage = "SphericalRegion is an option for three-dimensional graphics functions which specifies whether the final image should be scaled so that a sphere drawn around the three-dimensional bounding box would fit in the display area specified."
Splice::usage = "Splice[\"file\"] splices Mathematica output into an external file. It takes text enclosed between <* and *> in the file, evaluates the text as Mathematica input, and replaces the text with the resulting Mathematica output."
Split::usage = "Split[list] splits list into sublists consisting of runs of identical elements. Split[list, test] treats pairs of adjacent elements as identical whenever applying the function test to them yields True."
Sqrt::usage = "Sqrt[z] gives the square root of z."
SqrtBox::usage = "SqrtBox[x] represents the square root of x in input and output."
Stack::usage = "Stack[ ] shows the current evaluation stack, giving a list of the tags associated with evaluations that are currently being done. Stack[pattern] gives a list of expressions currently being evaluated which match the pattern."
StackBegin::usage = "StackBegin[expr] evaluates expr, starting a fresh evaluation stack."
StackComplete::usage = "StackComplete[expr] evaluates expr with intermediate expressions in evaluation chains included on the stack."
StackInhibit::usage = "StackInhibit[expr] evaluates expr without modifying the evaluation stack."
StandardDeviation::usage = "StandardDeviation[list] gives the standard deviation of the elements in list."
StandardForm::usage = "StandardForm[expr] prints as the standard Mathematica two-dimensional representation of expr."
StartingStepSize::usage = "StartingStepSize is an option to NDSolve. StartingStepSize -> r specifies an initial step size of r."
StepMonitor::usage = "StepMonitor is an option for iterative numerical computation functions that gives an expression to evaluate whenever a step is taken by the numerical method used."
StieltjesGamma::usage = "StieltjesGamma[n] gives the nth Stieltjes constant."
StirlingS1::usage = "StirlingS1[n, m] gives the Stirling number of the first kind."
StirlingS2::usage = "StirlingS2[n, m] gives the Stirling number of the second kind."
StoppingTest::usage = "StoppingTest is an option for NDSolve that can be used to stop the integration of the ode when a certain condition is found to be True. The condition can evaluate to True/False only and should contain the dependent and independent variables explicitly. This option cannot be used for linear boundary value problems."
StreamPosition::usage = "StreamPosition[stream] returns an integer which specifies the position of the current point in an open stream."
Streams::usage = "Streams[ ] gives a list of all streams that are currently open. Streams[\"name\"] lists only streams with the specified name."
String::usage = "String is the head of a character string \"text\"."
StringByteCount::usage = "StringByteCount[\"string\"] gives the total number of bytes used to store the characters in a string."
StringCases::usage = "StringCases[\"string\", patt] gives a list of the substrings in \"string\" that match the string expression patt. StringCases[\"string\", lhs -> rhs] gives a list of the values of rhs corresponding to the substrings that match the string expression lhs. StringCases[\"string\", p, n] includes only the first n substrings that match. StringCases[\"string\", {p1, p2, ... }] gives substrings that match any of the pi. StringCases[{s1, s2, ... }, p] gives the list of results for each of the si."
StringCount::usage = "StringCount[\"string\", \"sub\"] gives a count of the number of times \"sub\" appears as a substring of \"string\". StringCount[\"string\", patt] gives the number of substrings in \"string\" that match the general string expression patt. StringCount[\"string\", {patt1, patt2, ... }] counts the number of occurrences of any of the patti. StringCount[{s1, s2, ... }, p] gives the list of results for each of the si."
StringDrop::usage = "StringDrop[\"string\", n] gives \"string\" with its first n characters dropped. StringDrop[\"string\", -n] gives \"string\" with its last n characters dropped. StringDrop[\"string\", {n}] gives \"string\" with its nth character dropped. StringDrop[\"string\", {m, n}] gives \"string\" with characters m through n dropped. StringDrop[{s1, s2, ... }, spec] gives the list of results for each of the si."
StringExpression::usage = "s1 ~~ s2 ~~ ...  or StringExpression[s1, s2, ... ] represents a sequence of strings and symbolic string objects si."
StringForm::usage = "StringForm[\"controlstring\", expr1, ... ] prints as the text of the controlstring, with the printed forms of the expri embedded."
StringFreeQ::usage = "StringFreeQ[\"string\", patt] yields True if no substring in \"string\" matches the string expression patt, and yields False otherwise. StringFreeQ[\"string\", {patt1, patt2, ... }] yields True if no substring matches any of the patti. StringFreeQ[{s1, s2, ... }, p] gives the list of results for each of the si."
StringInsert::usage = "StringInsert[\"string\", \"snew\", n] yields a string with \"snew\" inserted starting at position n in \"string\". StringInsert[\"string\", \"snew\", -n] inserts at position n from the end of \"string\". StringInsert[\"string\", \"snew\", {n1, n2, ... }] inserts a copy of \"snew\" at each of the positions ni. StringInsert[{s1, s2, ... }, \"snew\", n] gives the list of results for each of the si."
StringJoin::usage = "\"s1\" <> \"s2\" <> ... , StringJoin[\"s1\", \"s2\", ... ] or StringJoin[{\"s1\", \"s2\", ... }] yields a string consisting of a concatenation of the si."
StringLength::usage = "StringLength[\"string\"] gives the number of characters in a string."
StringMatchQ::usage = "StringMatchQ[\"string\", patt] tests whether string matches the string pattern patt. StringMatchQ[\"string\", RegularExpression[\"regex\"]] tests whether string matches the specified regular expression. StringMatchQ[{s1, s2, ... }, p] gives the list of results for each of the si."
StringPosition::usage = "StringPosition[\"string\", \"sub\"] gives a list of the starting and ending character positions at which \"sub\" appears as a substring of \"string\". StringPosition[\"string\", patt] gives all positions at which substrings matching the general string expression patt appear in \"string\". StringPosition[\"string\", patt, n] includes only the first n occurrences of patt. StringPosition[\"string\", {patt1, patt2, ... }] gives positions of all the patti. StringPosition[{s1, s2, ... }, p] gives the list of results for each of the si."
StringQ::usage = "StringQ[expr] gives True if expr is a string, and False otherwise."
StringReplace::usage = "StringReplace[\"string\", s -> sp] or StringReplace[\"string\", {s1 -> sp1, s2 -> sp2, ... }] replaces the string expressions si by spi whenever they appear as substrings of \"string\". StringReplace[\"string\", srules, n] does only the first n replacements. StringReplace[{s1, s2, ... }, srules] gives the list of results for each of the si."
StringReplaceList::usage = "StringReplaceList[\"string\", s -> sp] or StringReplaceList[\"string\", {s1 -> sp1, s2 -> sp2, ... }] gives a list of the strings obtained by replacing each individual occurrence of substrings in \"string\" matching the string expressions si. StringReplaceList[\"string\", srules, n] gives a list of the first n results obtained. StringReplaceList[{s1, s2, ... }, srules] gives the list of results for each of the si."
StringReplacePart::usage = "StringReplacePart[\"string\", \"snew\", {m, n}] replaces the characters at positions m through n in \"string\" by \"snew\". StringReplacePart[\"string\", \"snew\", {{m1, n1}, {m2, n2}, ... }] inserts copies of \"snew\" at several positions. StringReplacePart[\"string\", {\"snew1\", \"snew2\", ... }, {{m1, n1}, {m2, n2}, ... }] replaces characters at positions mi through ni in \"string\" by \"snewi\"."
StringReverse::usage = "StringReverse[\"string\"] reverses the order of the characters in \"string\"."
StringSkeleton::usage = "StringSkeleton[n] represents a sequence of n omitted characters in a string printed with Short. The standard print form for StringSkeleton is an ellipsis."
StringSplit::usage = "StringSplit[\"string\"] splits \"string\" into a list of substrings separated by whitespace. StringSplit[\"string\", patt] splits into substrings separated by delimiters matching the string expression patt. StringSplit[\"string\", {p1, p2, ... }] splits at any of the pi. StringSplit[\"string\", patt -> val] inserts val at the position of each delimiter. StringSplit[\"string\", {p1 -> v1, ... }] inserts vi at the position of each delimiter pi. StringSplit[\"string\", patt, n] splits into at most n substrings. StringSplit[{s1, s2, ... }, p] gives the list of results for each of the si."
StringTake::usage = "StringTake[\"string\", n] gives a string containing the first n characters in \"string\". StringTake[\"string\", -n] gives the last n characters in \"string\". StringTake[\"string\", {n}] gives the nth character in \"string\". StringTake[\"string\", {m, n}] gives characters m through n in \"string\". StringTake[{s1, s2, ... }, spec] gives the list of results for each of the si."
StringToStream::usage = "StringToStream[\"string\"] opens an input stream for reading from a string."
StripBoxes::usage = "StripBoxes[expr] will strip out unnecessary boxes, spaces, and options from a format expression."
StripWrapperBoxes::usage = "StripWrapperBoxes is an option to TagBox."
StructuredSelection::usage = "StructuredSelection is an option for Cell which specifies whether to allow only complete subexpressions in the cell to be selected interactively using the front end."
StruveH::usage = "StruveH[n, z] gives the Struve function Hn(z)."
StruveL::usage = "StruveL[n, z] gives the modified Struve function Ln(z)."
Stub::usage = "Stub is an attribute which specifies that if a symbol is ever used, Needs should automatically be called on the context of the symbol."
StyleBox::usage = "StyleBox[boxes, options] represents output in which boxes are shown with the specified option settings. StyleBox[boxes, \"style\"] uses the option setting for the specified style in the current notebook."
StyleDefinitions::usage = "StyleDefinitions is an option for notebooks which gives definitions for the styles that can be used in a notebook."
StyleForm::usage = "StyleForm[expr, options] prints using the specified style options. StyleForm[expr, \"style\"] prints using the specified cell style in the current notebook."
StylePrint::usage = "StylePrint[expr, \"style\"] creates a new cell in the current notebook with the specified style, and prints expr into it. StylePrint[expr] uses the default style for the current notebook."
Subresultants::usage = "Subresultants[poly1, poly2, var] generates a list of the principal subresultant coefficients of the polynomials poly1 and poly2 with respect to the variable var."
Subscript::usage = "Subscript[x, y] is an object that formats as x with a subscript y."
SubscriptBox::usage = "SubscriptBox[x, y] represents x with a subscript y in input and output."
Subsets::usage = "Subsets[list] gives a list of all possible subsets of list. Subsets[list, n] gives all subsets containing at most n elements. Subsets[list, {n}] gives all subsets containing exactly n elements. Subsets[list, {nmin, nmax}] gives all subsets containing between nmin and nmax elements. Subsets[list, nspec, s] gives the first s subsets. Subsets[list, nspec, {s}] gives the sth subset."
Subsuperscript::usage = "Subsuperscript[x, y, z] is an object that formats as x with subscript y and superscript z."
SubsuperscriptBox::usage = "SubsuperscriptBox[x, y, z] represents x with subscript y and superscript z."
Subtract::usage = "x - y is equivalent to x + (-1 * y)."
SubtractFrom::usage = "x -= dx subtracts dx from x and returns the new value of x."
SubValues::usage = "SubValues[f] gives a list of transformation rules corresponding to all subvalues (values for f[x,..][..], etc.) defined for the symbol f."
Sum::usage = "Sum[f, {i, imax}] evaluates the sum of the expressions f as evaluated for each i from 1 to imax. Sum[f, {i, imin, imax}] starts with i = imin. Sum[f, {i, imin, imax, di}] uses steps di. Sum[f, {i, imin, imax}, {j, jmin, jmax}, ... ] evaluates a sum over multiple indices."
Superscript::usage = "Superscript[x, y] is an object that formats as x with a superscript y."
SuperscriptBox::usage = "SuperscriptBox[x, y] represents x with a superscript y in input and output."
SurfaceColor::usage = "SurfaceColor[dcol] is a three-dimensional graphics directive which specifies that the surfaces which follow should act as diffuse reflectors of light with a color given by dcol. SurfaceColor[dcol, scol] specifies that a specular reflection component should be included, with a color given by scol. SurfaceColor[dcol, scol, n] specifies that the reflection should occur with specular exponent n."
SurfaceGraphics::usage = "SurfaceGraphics[array] is a representation of a three-dimensional plot of a surface, with heights of each point on a grid specified by values in array. SurfaceGraphics[array, shades] represents a surface, whose parts are shaded according to the array shades."
Switch::usage = "Switch[expr, form1, value1, form2, value2, ... ] evaluates expr, then compares it with each of the formi in turn, evaluating and returning the valuei corresponding to the first match found."
Symbol::usage = "Symbol[\"name\"] refers to a symbol with the specified name."
SymbolName::usage = "SymbolName[symbol] gives the name of the specified symbol."
SyntaxLength::usage = "SyntaxLength[\"string\"] finds the number of characters starting at the beginning of a string that correspond to syntactically correct input for a single Mathematica expression."
SyntaxQ::usage = "SyntaxQ[\"string\"] returns True if the string corresponds to syntactically correct input for a single Mathematica expression, and returns False otherwise."
Table::usage = "Table[expr, {imax}] generates a list of imax copies of expr. Table[expr, {i, imax}] generates a list of the values of expr when i runs from 1 to imax. Table[expr, {i, imin, imax}] starts with i = imin. Table[expr, {i, imin, imax, di}] uses steps di. Table[expr, {i, imin, imax}, {j, jmin, jmax}, ... ] gives a nested list. The list associated with i is outermost."
TableAlignments::usage = "TableAlignments is an option for TableForm and MatrixForm which specifies how entries in each dimension should be aligned."
TableDepth::usage = "TableDepth is an option for TableForm and MatrixForm which specifies the maximum number of levels to be printed in tabular or matrix format."
TableDirections::usage = "TableDirections is an option for TableForm and MatrixForm which specifies whether successive dimensions should be arranged as rows or columns."
TableForm::usage = "TableForm[list] prints with the elements of list arranged in an array of rectangular cells."
TableHeadings::usage = "TableHeadings is an option for TableForm and MatrixForm which gives the labels to be printed for entries in each dimension of a table or matrix."
TableSpacing::usage = "TableSpacing is an option for TableForm and MatrixForm which specifies how many spaces should be left between each successive row or column."
TagBox::usage = "TagBox[boxes, tag] displays as boxes but maintains tag to guide the interpretation of boxes on input."
TagSet::usage = "f/: lhs = rhs assigns rhs to be the value of lhs, and associates the assignment with the symbol f."
TagSetDelayed::usage = "f/: lhs := rhs assigns rhs to be the delayed value of lhs, and associates the assignment with the symbol f."
TagUnset::usage = "f/: lhs =. removes any rules defined for lhs, associated with the symbol f."
Take::usage = "Take[list, n] gives the first n elements of list. Take[list, -n] gives the last n elements of list. Take[list, {m, n}] gives elements m through n of list. Take[list, {m, n, s}] gives elements m through n in steps of s. Take[list, seq1, seq2, ... ] gives a nested list in which elements specified by seqi are taken at level i in list."
Tan::usage = "Tan[z] gives the tangent of z."
Tanh::usage = "Tanh[z] gives the hyperbolic tangent of z."
TargetFunctions::usage = "TargetFunctions is an option to ComplexExpand. The value can be given as a list chosen from {Re, Im, Abs, Arg, Conjugate, Sign}. ComplexExpand will try to return results in terms of the functions requested."
Temporary::usage = "Temporary is an attribute assigned to symbols which are created as local variables by Module."
TeXForm::usage = "TeXForm[expr] prints as a TeX version of expr."
TeXSave::usage = "TeXSave is superseded by Export[ ... , \"TeX\"] in Version 5.1. TeXSave[\"file.tex\"] saves a TeX version of the currently selected notebook in the front end. TeXSave[\"file.tex\", \"source.nb\"] saves a TeX version of the notebook from the file \"source.nb\". TeXSave[\"file.tex\", notebook] saves a TeX version of the notebook corresponding to the specified notebook object."
Text::usage = "Text[expr, coords] is a graphics primitive that represents text corresponding to the printed form of expr, centered at the point specified by coords."
TextAlignment::usage = "TextAlignment is an option for Cell which specifies how successive lines of text should be aligned."
TextJustification::usage = ""
TextRendering::usage = "TextRendering is an obsolete option, not used in Versions 2.0 and later."
TextStyle::usage = "TextStyle is an option for graphics functions and for Text which specifies the default style and font options with which text should be rendered."
Thickness::usage = "Thickness[r] is a graphics directive which specifies that lines which follow are to be drawn with a thickness r. The thickness r is given as a fraction of the total width of the graphic."
ThisLink::usage = "ThisLink is used in patterns for external packages to distinguish between several instances of the same package."
Thread::usage = "Thread[f[args]] \"threads\" f over any lists that appear in args. Thread[f[args], h] threads f over any objects with head h that appear in args. Thread[f[args], h, n] threads f over objects with head h that appear in the first n args. Thread[f[args], h, -n] threads over the last n args. Thread[f[args], h, {m, n}] threads over arguments m through n."
ThreeJSymbol::usage = "ThreeJSymbol[{j1, m1}, {j2, m2}, {j3, m3}] gives the values of the Wigner 3-j symbol."
Through::usage = "Through[p[f1, f2][x]] gives p[f1[x], f2[x]]. Through[expr, h] performs the transformation wherever h occurs in the head of expr."
Throw::usage = "Throw[value] stops evaluation and returns value as the value of the nearest enclosing Catch. Throw[value, tag] is caught only by Catch[expr, form] where form is a pattern that matches tag."
Ticks::usage = "Ticks is an option for graphics functions that specifies tick marks for axes."
TimeConstrained::usage = "TimeConstrained[expr, t] evaluates expr, stopping after t seconds. TimeConstrained[expr, t, failexpr] returns failexpr if the time constraint is not met."
TimeConstraint::usage = "TimeConstraint is an option for Simplify and FullSimplify which gives the maximum number of seconds for which to try any particular transformation on any subpart of an expression."
Times::usage = "x*y*z or x y z represents a product of terms."
TimesBy::usage = "x *= c multiplies x by c and returns the new value of x."
TimeUsed::usage = "TimeUsed[ ] gives the total number of seconds of CPU time used so far in the current Mathematica session."
TimeZone::usage = "TimeZone[ ] gives the time zone set for your computer system."
Timing::usage = "Timing[expr] evaluates expr, and returns a list of time used, together with the result obtained."
ToBoxes::usage = "ToBoxes[expr] generates boxes corresponding to the printed form of expr in StandardForm. ToBoxes[expr, form] gives the boxes corresponding to output in the specified form."
ToCharacterCode::usage = "ToCharacterCode[\"string\"] gives a list of the integer codes corresponding to the characters in a string. ToCharacterCode[\"string\", \"encoding\"] gives integer codes according to the specified encoding."
ToColor::usage = "ToColor[color, form] converts color to form if form is GrayLevel, RGBColor or CMYKColor color is converted into it. Otherwise form[color] is evaluated and the result is expected to be a valid color directive."
ToDate::usage = "ToDate[time] converts an absolute time in seconds since the beginning of January 1, 1900 to a date of the form {y, m, d, h, m, s}."
ToExpression::usage = "ToExpression[input] gives the expression obtained by interpreting strings or boxes as Mathematica input. ToExpression[input, form] uses interpretation rules corresponding to the specified form. ToExpression[input, form, h] wraps the head h around the expression produced before evaluating it."
ToFileName::usage = "ToFileName[\"directory\", \"name\"] assembles a full file name from a directory name and a file name. ToFileName[{dir1, dir2, ... }, name] assembles a full file name from a hierarchy of directory names. ToFileName[{dir1, dir2, ... }] assembles a single directory name from a hierarchy of directory names."
Together::usage = "Together[expr] puts terms in a sum over a common denominator, and cancels factors in the result."
ToHeldExpression::usage = "ToHeldExpression[\"string\"] gives the expression obtained by taking string as Mathematica input, enclosed in Hold[]."
TokenWords::usage = "TokenWords is an option for Read and related functions which gives a list of token words to be used to delimit words."
Tolerance::usage = "Tolerance is an option to certain functions that specifies the numerical tolerance under which the calculation is to be effected. Tolerance -> r sets a tolerance of r."
ToLowerCase::usage = "ToLowerCase[string] yields a string in which all letters have been converted to lower case."
TooBig::usage = "TooBig is an internal symbol."
ToRadicals::usage = "ToRadicals[expr] attempts to express all Root objects in expr in terms of radicals."
ToRules::usage = "ToRules[eqns] takes logical combinations of equations, in the form generated by Roots and Reduce, and converts them to lists of rules, of the form produced by Solve."
ToString::usage = "ToString[expr] gives a string corresponding to the printed form of expr in OutputForm. ToString[expr, form] gives the string corresponding to output in the specified form."
Total::usage = "Total[list] gives the total of the elements in list. Total[list, n] totals all elements down to level n."
TotalWidth::usage = "TotalWidth is an option which can be set for output streams to specify the maximum total number of characters of text that should be printed for each output expression. Short forms of expressions are given if the number of characters needed to print the whole expression is too large."
ToUpperCase::usage = "ToUpperCase[string] yields a string in which all letters have been converted to upper case."
Tr::usage = "Tr[list] finds the trace of the matrix or tensor list. Tr[list, f] finds a generalized trace, combining terms with f instead of Plus. Tr[list, f, n] goes down to level n in list."
Trace::usage = "Trace[expr] generates a list of all expressions used in the evaluation of expr. Trace[expr, form] includes only those expressions which match form. Trace[expr, s] includes all evaluations which use transformation rules associated with the symbol s."
TraceAbove::usage = "TraceAbove is an option for Trace and related functions which specifies whether to include evaluation chains which contain the evaluation chain containing the pattern form sought."
TraceAction::usage = "TraceAction is an option for TracePrint and TraceDialog that specifies the function to be applied to each expression they trace."
TraceBackward::usage = "TraceBackward is an option for Trace and related functions which specifies whether to include preceding expressions on the evaluation chain that contains the pattern form sought."
TraceDepth::usage = "TraceDepth is an option for Trace and related functions which specifies the maximum nesting of evaluation chains that are to be included."
TraceDialog::usage = "TraceDialog[expr] initiates a dialog for every expression used in the evaluation of expr. TraceDialog[expr, form] initiates a dialog only for expressions which match form. TraceDialog[expr, s] initiates dialogs only for expressions whose evaluations use transformation rules associated with the symbol s."
TraceForward::usage = "TraceForward is an option for Trace and related functions which specifies whether to include later expressions on the evaluation chain that contains the pattern form sought."
TraceInternal::usage = "TraceInternal is an option for Trace and related functions which, if True or False, specifies whether to trace evaluations of expressions generated internally by Mathematica. The intermediate Automatic setting traces a selected set of internal evaluations including Messages and sets or unsets of visible symbols."
TraceLevel::usage = "TraceLevel[] returns the level currently being traced when it appears within Trace and related functions."
TraceOff::usage = "TraceOff is an option for Trace and related functions which specifies forms inside which tracing should be switched off."
TraceOn::usage = "TraceOn is an option for Trace and related functions which specifies when tracing should be switched on."
TraceOriginal::usage = "TraceOriginal is an option for Trace and related functions which specifies whether to test the form of each expression before its head and arguments are evaluated."
TracePrint::usage = "TracePrint[expr] prints all expressions used in the evaluation of expr. TracePrint[expr, form] includes only those expressions which match form. TracePrint[expr, s] includes all evaluations which use transformation rules associated with the symbol s."
TraceScan::usage = "TraceScan[f, expr] applies f to all expressions used in the evaluation of expr. TraceScan[f, expr, form] includes only those expressions which match form. TraceScan[f, expr, s] includes all evaluations which use transformation rules associated with the symbol s. TraceScan[f, expr, form, fp] applies f before evaluation and fp after evaluation to expressions used in the evaluation of expr."
TraditionalForm::usage = "TraditionalForm[expr] prints as an approximation to the traditional mathematical notation for expr."
TransformationFunctions::usage = "TransformationFunctions is an option for Simplify and FullSimplify which gives the list of functions to apply to try to transform parts of an expression."
Transpose::usage = "Transpose[list] transposes the first two levels in list. Transpose[list, {n1, n2, ... }] transposes list so that the levels 1, 2, ... in list correspond to levels n1, n2, ... in the result."
Trapezoidal::usage = "Trapezoidal is a choice for the option Method of NIntegrate. Method -> Trapezoidal causes a recursive trapezoidal algorithm to be used. This is particularly useful when the integrand is periodic and the interval of integration is exactly one period. For multi-dimensional integration Trapezoidal refers to a Cartesian product of one dimensional trapezoidal rules."
TreeForm::usage = "TreeForm[expr] prints with different levels in expr shown at different depths."
Trig::usage = "Trig is an option for algebraic manipulation functions which specifies whether trigonometric functions should be treated as rational functions of exponentials."
TrigExpand::usage = "TrigExpand[expr] expands out trigonometric functions in expr."
TrigFactor::usage = "TrigFactor[expr] factors trigonometric functions in expr."
TrigFactorList::usage = "TrigFactorList[expr] factors trigonometric functions in expr, yielding a list of lists containing trigonometric monomials and exponents."
TrigReduce::usage = "TrigReduce[expr] rewrites products and powers of trigonometric functions in expr in terms of trigonometric functions with combined arguments."
TrigToExp::usage = "TrigToExp[expr] converts trigonometric functions in expr to exponentials."
True::usage = "True is the symbol for the Boolean value true."
TrueQ::usage = "TrueQ[expr] yields True if expr is True, and yields False otherwise."
Tuples::usage = "Tuples[list, n] generates a list of all possible n-tuples of elements from list. Tuples[{list1, list2, ... }] generates a list of all possible tuples whose ith element is from listi."
Underflow::usage = "Underflow[] is the result of a numerical calculation whose result is too small to represent."
UnderoverscriptBox::usage = "UnderoverscriptBox[x, y, z] represents x with an underscript y and an overscript z in input and output."
Underscript::usage = "Underscript[x, y] is an object that formats as x with an underscript y."
UnderscriptBox::usage = "UnderscriptBox[x, y] represents x with an underscript y in input and output."
Unequal::usage = "lhs != rhs returns False if lhs and rhs are identical."
Unevaluated::usage = "Unevaluated[expr] represents the unevaluated form of expr when it appears as the argument to a function."
Uninstall::usage = "Uninstall[link] terminates an external program started by Install, and removes Mathematica definitions set up by it."
Union::usage = "Union[list1, list2, ... ] gives a sorted list of all the distinct elements that appear in any of the listi. Union[list] gives a sorted version of a list, in which all duplicated elements have been dropped."
Unique::usage = "Unique[ ] generates a new symbol, whose name is of the form $nnn. Unique[x] generates a new symbol, with a name of the form x$nnn. Unique[{x, y, ... }] generates a list of new symbols. Unique[\"xxx\"] generates a new symbol, with a name of the form xxxnnn."
UnitStep::usage = "UnitStep[x] represents the unit step function, equal to 0 for x < 0 and 1 for x \[GreaterEqual] 0. UnitStep[x1, x2, ... ] represents the multidimensional unit step function which is 1 only if none of the xi are negative."
Unprotect::usage = "Unprotect[s1, s2, ... ] removes the attribute Protected for the symbols si. Unprotect[\"form1\", \"form2\", ... ] unprotects all symbols whose names textually match any of the formi."
UnsameQ::usage = "lhs =!= rhs yields True if the expression lhs is not identical to rhs, and yields False otherwise."
Unset::usage = "lhs =. removes any rules defined for lhs."
Update::usage = "Update[symbol] tells Mathematica that hidden changes have been made which could affect values associated with a symbol. Update[ ] specifies that the value of any symbol could be affected."
UpperCaseQ::usage = "UpperCaseQ[string] yields True if all the characters in the string are upper-case letters, and yields False otherwise."
UpSet::usage = "lhs^=rhs assigns rhs to be the value of lhs, and associates the assignment with symbols that occur at level one in lhs."
UpSetDelayed::usage = "lhs^:=rhs assigns rhs to be the delayed value of lhs, and associates the assignment with symbols that occur at level one in lhs."
UpValues::usage = "UpValues[f] gives a list of transformation rules corresponding to all upvalues defined for the symbol f."
Using::usage = "Using is an option to Roots that specifies any subsidiary equations that are to be used."
V2Get::usage = "V2Get[name] reads in a file written by the V2.x versions."
ValueForm::usage = "ValueForm is an internal symbol."
ValueQ::usage = "ValueQ[expr] gives True if a value has been defined for expr, and gives False otherwise."
Variables::usage = "Variables[poly] gives a list of all independent variables in a polynomial."
Variance::usage = "Variance[list] gives the statistical variance of the elements in list."
VectorNorm::usage = "VectorNorm[p, v] or VectorNorm[p, v, w] for real 1 <= p <= Infinity. Vectors v and w can be of any type."
VectorQ::usage = "VectorQ[expr] gives True if expr is a list or a one-dimensional SparseArray object, none of whose elements are themselves lists, and gives False otherwise. VectorQ[expr, test] gives True only if test yields True when applied to each of the elements in expr."
Verbatim::usage = "Verbatim[expr] represents expr in pattern matching, requiring that expr be matched exactly as it appears, with no substitutions for blanks or other transformations."
VerifyConvergence::usage = "VerifyConvergence is an option to NSum and NProduct. VerifyConvergence -> True causes the limit of the terms and the limit of the ratio of the terms to be checked in the case of infinite sums and products. With VerifyConvergence -> False no checking is done."
VerifySolutions::usage = "VerifySolutions is an option to Solve and related functions. With VerifySolutions -> True, solutions are verified and extraneous solutions are eliminated. With VerifySolutions -> False, they are not. Note that only those numerical solutions that are obviously extraneous are eliminated."
VerticalForm::usage = "VerticalForm is an internal symbol used for formatting and printing."
ViewCenter::usage = "ViewCenter is an option for Graphics3D which gives the scaled coordinates of the point which appears at the center of the display area in the final plot."
ViewPoint::usage = "ViewPoint is an option for Graphics3D which gives the point in space from which the objects plotted are to be viewed."
ViewVertical::usage = "ViewVertical is an option for Graphics3D which specifies what direction in scaled coordinates should be vertical in the final image."
Visible::usage = "Visible is an option for Notebook which specifies whether the notebook should be explicitly displayed on the screen."
WeierstrassHalfPeriods::usage = "WeierstrassHalfPeriods[{g2, g3}] gives the half-periods {omega, omega'} for Weierstrass elliptic functions corresponding to the invariants {g2, g3}."
WeierstrassInvariants::usage = "WeierstrassInvariants[{omega, omega'}] gives the invariants {g2, g3} for Weierstrass elliptic functions corresponding to the half-periods {omega, omega'}."
WeierstrassP::usage = "WeierstrassP[u, {g2, g3}] gives the Weierstrass elliptic function."
WeierstrassPPrime::usage = "WeierstrassPPrime[u, {g2, g3}] gives the derivative of the Weierstrass elliptic function."
WeierstrassSigma::usage = "WeierstrassSigma[u, {g2, g3}] gives the Weierstrass sigma function."
WeierstrassZeta::usage = "WeierstrassZeta[u, {g2, g3}] gives the Weierstrass zeta function."
Which::usage = "Which[test1, value1, test2, value2, ... ] evaluates each of the testi in turn, returning the value of the valuei corresponding to the first one that yields True."
While::usage = "While[test, body] evaluates test, then body, repetitively, until test first fails to give True."
White::usage = "White represents the color white in graphics or style specifications."
WindowClickSelect::usage = "WindowClickSelect is an option for Notebook which specifies whether the window for the notebook should become selected if you click on it."
WindowElements::usage = "WindowElements is an option for Notebook which specifies the elements to include in the window used to display the notebook on the screen."
WindowFloating::usage = "WindowFloating is an option for Notebook which specifies whether the window for the notebook should float on top of other windows when it is displayed on the screen."
WindowFrame::usage = "WindowFrame is an option for Notebook which specifies the type of frame to draw around the window in which the notebook is displayed on the screen."
WindowMargins::usage = "WindowMargins is an option for Notebook which specifies what margins to leave around the window that is used to display the notebook on the screen."
WindowMovable::usage = "WindowMovable is an option for Notebook which specifies whether to allow the window for the notebook to be moved around interactively on the screen."
WindowSize::usage = "WindowSize is an option for Notebook which specifies the size of window that should be used to display a notebook on the screen."
WindowTitle::usage = "WindowTitle is an option for Notebook which specifies the title to give for the window used to display the notebook."
WindowToolbars::usage = "WindowToolbars is an option for Notebook which specifies the toolbars to include at the top of the window used to display the notebook on the screen."
With::usage = "With[{x = x0, y = y0, ... }, expr] specifies that in expr occurrences of the symbols x, y, ...  should be replaced by x0, y0, ... ."
Word::usage = "Word represents a word in Read, Find and related functions."
WordSearch::usage = "WordSearch is an option for Find and FindList which specifies whether the text searched for must appear as a word."
WordSeparators::usage = "WordSeparators is an option for Read, Find and related functions which specifies the list of strings to be taken as delimiters for words."
WorkingPrecision::usage = "WorkingPrecision is an option for various numerical operations which specifies how many digits of precision should be maintained in internal computations."
Write::usage = "Write[channel, expr1, expr2, ... ] writes the expressions expri in sequence, followed by a newline, to the specified output channel."
WriteString::usage = "WriteString[channel, expr1, expr2, ... ] converts the expri to strings, and then writes them in sequence to the specified output channel."
WynnDegree::usage = "WynnDegree is an option to NSum and NProduct that specifies the degree used with Wynn's epsilon algorithm for approximating the limit of a sequence. WynnDegree -> 1 gives Aitken's delta-squared algorithm."
XML`FromSymbolicXML::usage = "FromSymbolicXML[xmlexpr] will convert a SymbolicXML expression into a more native format, if one is available."
XML`MathML`BoxesToMathML::usage = "BoxesToMathML[boxes], will convert the Mathematica box structure, boxes, into a MathML flavored XML text string. Presentation markup is used wherever possible."
XML`MathML`BoxesToSymbolicMathML::usage = "BoxesToSymbolicMathML[boxes], will convert the Mathematica box structure, boxes, into a MathML flavored symbolic XML structure."
XML`MathML`ExpressionToMathML::usage = "ExpressionToMathML[expr], will convert the Mathematica expression, expr, into a MathML flavored XML text string. Content markup is used wherever possible."
XML`MathML`ExpressionToSymbolicMathML::usage = "ExpressionToSymbolicMathML[expr], will convert the Mathematica expression, expr, into a MathML flavored symbolic XML structure. Content markup is used wherever possible."
XML`MathML`MathMLToBoxes::usage = "MathMLToBoxes[mmlString], will convert the string containing MathML flavored XML text into a Mathematica box expression."
XML`MathML`MathMLToExpression::usage = "MathMLToBoxes[mmlString], will convert the string containing MathML flavored XML text into a Mathematica kernel expression."
XML`MathML`SymbolicMathMLToBoxes::usage = "SymbolicMathMLToBoxes[smml], will convert the MathML flavored symbolic XML structure, smml, into a Mathematica box expression."
XML`MathML`SymbolicMathMLToExpression::usage = "SymbolicMathMLToExpression[smml], will convert the MathML flavored symbolic XML structure, smml, into a Mathematica kernel expression."
XML`NotebookML`ExpressionToSymbolicExpressionML::usage = "ExpressionToSymbolicExpressionML[expr] converts expr to ExpressionML and returns the corresponding SymbolicXML."
XML`NotebookML`NotebookToSymbolicNotebookML::usage = "NotebookToSymbolicNotebookML[expr] converts expr to NotebookML and returns the corresponding SymbolicXML."
XML`NotebookML`SymbolicExpressionMLToExpression::usage = "SymbolicExpressionMLToExpression[expr] takes a SymbolicXML expr which represents an ExpressionML document, and returns the corresponding expression."
XML`NotebookML`SymbolicNotebookMLToNotebook::usage = "SymbolicNotebookMLToNotebook[expr] takes a SymbolicXML expr which represents a NotebookML document, and returns the corresponding Notebook expression."
XML`Parser`InitializeXMLParser::usage = "InitializeXMLParser[rootElement, filePath] creates an XML parser object to be used on XML documents that have a root element of 'rootElement'.  The parser will be initialized to recognize entities defined in the document type description located at 'filePath'. The expression returned by InitializeXMLParser is XMLParser[rootElement, filePath], and this object can be used as the second argument to XMLGet or XMLGetString."
XML`Parser`ReleaseXMLParser::usage = "ReleaseXMLParser[xmlParserObj] frees up resources associated with the specified XML parser object."
XML`Parser`XMLGet::usage = "XMLGet[filePath] returns the XML expression tree corresponding to the contents of the file located at 'filePath'. XMLGet[filePath, xmlParserObj] uses the specified preinitialized parser object to parse the file."
XML`Parser`XMLGetString::usage = "XMLGetString[string] returns the XML expression tree corresponding to 'string'. XMLGetString[string, xmlParserObj] uses the specified preintialized parser object to parse 'string'."
XML`Parser`XMLParser::usage = "XMLParser[rootElement, filePath] represents a parser object created by InitializeXMLParser for XML documents with a root element of 'rootElement' and corresponding to the DTD located at 'filePath'. The parser object can be used with XMLGet and XMLGetString in order to avoid reloading of a DTD."
XML`RawXML::usage = "RawXML[xmlstring] represents a raw string fragment of XML which can be used inside a SymbolicXML expression. It will be exported literally as XML when the SymbolicXML is exported as XML."
XML`SVG`GraphicsToSVG::usage = "GraphicsToSVG[graphics, options] converts graphics objects to an SVG flavored XML string."
XML`SVG`GraphicsToSymbolicSVG::usage = "GraphicsToSymbolicSVG[graphics, options] converts graphics objects to SVG flavored SymbolicXML."
XML`SVG`SVGToGraphics::usage = "This function is not implemented in this version of Mathematica. It is reserved for future expansion."
XML`SVG`SymbolicSVGToGraphics::usage = "This function is not implemented in this version of Mathematica. It is reserved for future expansion."
XML`SymbolicXMLErrors::usage = "SymbolicXMLErrors[expr] gives messages indicating the reasons (if any) why expr is not a valid SymbolicXML expression, and returns a list of part specifications indicating the location of the errors."
XML`SymbolicXMLQ::usage = "SymbolicXMLQ[expr] returns True if expr superficially looks like a SymbolicXML expression, otherwise it returns False.  SymbolicXMLQ[expr, True] will perform a complete test on expr to determine if it is a well formed SymbolicXML expression. SymbolicXMLQ[expr, False] is equivalent to SymbolicXMLQ[expr]."
XML`ToCompactXML::usage = "ToCompactXML[xmlexpr], will generate an equivalent symbolic XML expression which suppresses all the redundant namespace information for the elements and the attributes in xmlexpr. ToCompactXML[xmlexpr, pattern] will only suppress namespaces which match pattern."
XML`ToSymbolicXML::usage = "ToSymbolicXML[expr] translates expr to its appropriate XML format and returns it as SymbolicXML."
XML`ToVerboseXML::usage = "ToVerboseXML[xmlexpr], will generate an equivalent symbolic XML expression which explicitly exposes all the namespace information for the elements and the attributes in xmlexpr. ToVerboseXML[xmlexpr, pattern] will only expose namespaces which match pattern."
XMLElement::usage = "XMLElement[tag, attributes, contents] represents an XML element. Both the attributes and the contents are contained in Lists."
XMLObject::usage = "XMLObject[type][args] represents a node of the specified type in a SymbolicXML expression.  The type can be either \"Document\", \"Doctype\", \"Declaration\", \"Comment\", or \"ProcessingInstruction\"."
Xor::usage = "Xor[e1, e2, ... ] is the logical XOR (exclusive OR) function. It gives True if an odd number of the ei are True, and the rest are False. It gives False if an even number of the ei are True, and the rest are False."
Yellow::usage = "Yellow represents the color yellow in graphics or style specifications."
ZeroTest::usage = "ZeroTest is an option for LinearSolve and other linear algebra functions, which gives a function to be applied to combinations of matrix elements to determine whether they should be considered equal to zero."
Zeta::usage = "Zeta[s] gives the Riemann zeta function. Zeta[s, a] gives the generalized Riemann zeta function."
ZTransform::usage = "ZTransform[expr, n, z] gives the Z transform of expr."
$Aborted::usage = "$Aborted is a special symbol that is returned as the result from a calculation that has been aborted."
$Assumptions::usage = "$Assumptions is the default setting for the Assumptions option used in such functions as Simplify, Refine and Integrate."
$BaseDirectory::usage = "$BaseDirectory gives the base directory in which system-wide files to be loaded by Mathematica are conventionally placed."
$BatchInput::usage = "$BatchInput is True if input in the current session is being fed directly to the Mathematica kernel in batch mode."
$BatchOutput::usage = "$BatchOutput is True if output in the current session is being sent in batch mode, suitable for reading by other programs."
$BoxForms::usage = "$BoxForms is the list of box formats."
$ByteOrdering::usage = "$ByteOrdering gives the native ordering of bytes in binary data on your computer system."
$CharacterEncoding::usage = "$CharacterEncoding specifies the default raw character encoding to use for input and output functions."
$CommandLine::usage = "$CommandLine is a list of strings giving the elements of the original operating system command line with which Mathematica was invoked."
$ConditionHold::usage = "$ConditionHold is an internal symbol."
$Context::usage = "$Context is a global variable that gives the current context."
$ContextPath::usage = "$ContextPath is a global variable that gives a list of contexts, after $Context, to search in trying to find a symbol that has been entered."
$CreationDate::usage = "$CreationDate gives the date and time at which the particular release of the Mathematica kernel you are running was created."
$CurrentLink::usage = "$CurrentLink is the LinkObject representing the MathLink connection for an external program currently being installed or being called."
$DefaultFont::usage = "$DefaultFont gives the default font to use for text in graphics."
$DefaultPath::usage = "$DefaultPath is the default setting for $Path for this copy of Mathematica session."
$Display::usage = "$Display gives a list of files and pipes to be used with the default $DisplayFunction."
$DisplayFunction::usage = "$DisplayFunction gives the default setting for the option DisplayFunction in graphics functions."
$DumpDates::usage = "$DumpDates gives the list of all dates and times at which Dump was used in creating the Mathematica system you are running."
$DumpSupported::usage = "$DumpSupported is True if Dump can be used in the version of Mathematica you are running, and is False otherwise."
$Echo::usage = "$Echo gives a list of files and pipes to which all input is echoed."
$Epilog::usage = "$Epilog is a symbol whose value, if any, is evaluated when a dialog or a Mathematica session is terminated."
$ExportFormats::usage = "$ExportFormats gives a list of export formats currently supported in your Mathematica system."
$Failed::usage = "$Failed is a special symbol returned by certain functions when they cannot do what they were asked to do."
$FormatType::usage = "$FormatType gives the default format type to use for text that appears in graphics."
$FrontEnd::usage = "$FrontEnd is a global variable that specifies to what front end object, if any, the kernel is currently connected."
$HistoryLength::usage = "$HistoryLength specifies the number of previous lines of input and output to keep in a Mathematica session."
$HomeDirectory::usage = "$HomeDirectory gives your \[OpenCurlyDoubleQuote]home\[CloseCurlyDoubleQuote] directory."
$IgnoreEOF::usage = "$IgnoreEOF specifies whether Mathematica should terminate when it receives an end-of-file character as input."
$ImportFormats::usage = "$ImportFormats gives a list of import formats currently supported in your Mathematica system."
$InitialDirectory::usage = "$InitialDirectory gives the initial directory when the current Mathematica session was started."
$Input::usage = "$Input is a global variable whose value is the name of the stream from which input to Mathematica is currently being sought."
$Inspector::usage = "$Inspector is a global variable which gives a function to apply when the inspector is invoked from an interrupt menu."
$InstallationDate::usage = "$InstallationDate gives the date and time at which the copy of the Mathematica kernel you are running was installed."
$InstallationDirectory::usage = "$InstallationDirectory gives the top-level directory in which your Mathematica installation resides."
$IterationLimit::usage = "$IterationLimit gives the maximum length of evaluation chain used in trying to evaluate any expression."
$Language::usage = "$Language is a list of strings which give the names of languages to use for messages."
$LicenseExpirationDate::usage = "$LicenseExpirationDate is the date on which the license expires."
$LicenseProcesses::usage = "$LicenseProcesses is the number of Mathematica processes currently being run under the license."
$LicenseServer::usage = "$LicenseServer is a string containing the name of the machine serving the license."
$Line::usage = "$Line is a global variable that specifies the number of the current input line."
$Linked::usage = "$Linked is True if the Mathematica kernel is being run through MathLink."
$LinkSupported::usage = "$LinkSupported is True if MathLink can be used in the version of Mathematica you are running, and is False otherwise."
$MachineDomain::usage = "$MachineDomain is a string which gives the name of the network domain for the computer on which Mathematica is being run, if such a name is defined."
$MachineEpsilon::usage = "$MachineEpsilon gives the smallest machine-precision number which can be added to 1.0 to give a result that is distinguishable from 1.0."
$MachineID::usage = "$MachineID is a string which gives, if possible, a unique identification code for the computer on which Mathematica is being run."
$MachineName::usage = "$MachineName is a string which gives the assigned name of the computer on which Mathematica is being run, if such a name is defined."
$MachinePrecision::usage = "$MachinePrecision gives the number of decimal digits of precision used for machine-precision numbers."
$MachineType::usage = "$MachineType is a string giving the general type of computer on which Mathematica is being run."
$MaxExtraPrecision::usage = "$MaxExtraPrecision gives the maximum number of extra digits of precision to be used in functions such as N."
$MaxLicenseProcesses::usage = "$MaxLicenseProcesses is the maximum number of processes provided by the license."
$MaxMachineNumber::usage = "$MaxMachineNumber is the largest machine-precision number that can be used on a particular computer system."
$MaxNumber::usage = "$MaxNumber gives the magnitude of the maximum arbitrary-precision number that can be represented on a particular computer system."
$MaxPiecewiseCases::usage = "$MaxPiecewiseCases gives the maximum number of cases to allow in explicit Piecewise objects generated by expanding any single piecewise function."
$MaxPrecision::usage = "$MaxPrecision gives the maximum number of digits of precision to be allowed in arbitrary-precision numbers."
$MaxRootDegree::usage = "$MaxRootDegree is the upper bound for degrees of input polynomials handled by the Root function."
$MessageList::usage = "$MessageList is a global variable that gives a list of the names of messages generated during the evaluation of the current input line."
$MessagePrePrint::usage = "$MessagePrePrint is a global variable whose value, if set, is applied to expressions before they are included in the text of messages."
$Messages::usage = "$Messages gives the list of files and pipes to which message output is sent."
$MinMachineNumber::usage = "$MinMachineNumber is the smallest positive machine-precision number that can be used on a particular computer system."
$MinNumber::usage = "$MinNumber gives the magnitude of the minimum positive arbitrary-precision number that can be represented on a particular computer system."
$MinPrecision::usage = "$MinPrecision gives the minimum number of digits of precision to be allowed in arbitrary-precision numbers."
$ModuleNumber::usage = "$ModuleNumber gives the current serial number to be used for local variables that are created."
$NetworkLicense::usage = "$NetworkLicense gives True if using a network license, and False otherwise."
$NewMessage::usage = "$NewMessage is a global variable which, if set, is applied to the symbol name and tag of messages that are requested but have not yet been defined."
$NewSymbol::usage = "$NewSymbol is a global variable which, if set, is applied to the name and context of each new symbol that Mathematica creates."
$Notebooks::usage = "$Notebooks is True if Mathematica is being used with a notebook-based front end."
$NumberBits::usage = "$NumberBits[x] gives a list containing the sign, a list of the bits thought to be correct, a list of the bits not thought to be correct, and the binary exponent. The number x must have a head of Real."
$NumberMarks::usage = "$NumberMarks gives the default value for the option NumberMarks, which specifies whether ` marks should be included in the input form representations of approximate numbers."
$OperatingSystem::usage = "$OperatingSystem is a string giving the type of operating system under which Mathematica is being run."
$Output::usage = "$Output gives the list of files and pipes to which standard output from Mathematica is sent."
$OutputForms::usage = "$OutputForms is a list of the formatting functions that get stripped off when wrapped around the output."
$Packages::usage = "$Packages gives a list of the contexts corresponding to all packages which have been loaded in your current Mathematica session."
$ParentLink::usage = "$ParentLink is the MathLink LinkObject currently used for input and output by the Mathematica kernel in a particular session."
$ParentProcessID::usage = "$ParentProcessID gives the ID assigned to the process which invokes the Mathematica kernel by the operating system under which it is run."
$PasswordFile::usage = "$PasswordFile is a string giving the password file used when the kernel was started."
$Path::usage = "$Path gives the default list of directories to search in attempting to find an external file."
$PathnameSeparator::usage = "$PathnameSeparator is a string that should separate the names of directories and files in pathnames used by this operating system."
$PipeSupported::usage = "$PipeSupported is True if pipes can be used in the version of Mathematica you are running, and is False otherwise."
$Post::usage = "$Post is a global variable whose value, if set, is applied to every output expression."
$Pre::usage = "$Pre is a global variable whose value, if set, is applied to every input expression."
$PrePrint::usage = "$PrePrint is a global variable whose value, if set, is applied to every expression before it is printed."
$PreRead::usage = "$PreRead is a global variable whose value, if set, is applied to the text or box form of every input expression before it is fed to Mathematica."
$PrintForms::usage = "$PrintForms is the list of basic print forms. It is automatically updated when Format definitions using new printforms are made."
$PrintLiteral::usage = "$PrintLiteral is an internal symbol."
$ProcessID::usage = "$ProcessID gives the ID assigned to the Mathematica kernel process by the operating system under which it is run."
$ProcessorType::usage = "$ProcessorType is a string giving the architecture of processor on which Mathematica is being run."
$ProductInformation::usage = "$ProductInformation is a list of rules giving detailed information about the software product to which the current kernel belongs."
$ProgramName::usage = "$ProgramName is the name of the program being run under the license."
$RandomState::usage = "$RandomState gives a representation of the internal state of the pseudorandom generator used by Random."
$RecursionLimit::usage = "$RecursionLimit gives the current limit on the number of levels of recursion that Mathematica can use."
$ReleaseNumber::usage = "$ReleaseNumber is an integer which gives the current Mathematica kernel release number, and increases in successive releases."
$SessionID::usage = "$SessionID is a number set up to be unique to a particular Mathematica session."
$SoundDisplayFunction::usage = "$SoundDisplayFunction gives the default setting for the option DisplayFunction in sound functions."
$SuppressInputFormHeads::usage = "$SuppressInputFormHeads is a list of the heads of expressions whose InputForm should not be sent automatically to front ends."
$SyntaxHandler::usage = "$SyntaxHandler is a global variable which, if set, is applied to any input string that is found to contain a syntax error."
$System::usage = "$System is a string describing the type of computer system on which Mathematica is being run."
$SystemCharacterEncoding::usage = "$SystemCharacterEncoding gives the default raw character encoding for the computer system on which Mathematica is being run."
$SystemID::usage = "$SystemID is a short string that identifies the type of computer system on which Mathematica is being run."
$TemporaryPrefix::usage = "$TemporaryPrefix forms the initial part of filenames returned by OpenTemporary[]."
$TextStyle::usage = "$TextStyle gives the default style to use for text in graphics."
$TimeUnit::usage = "$TimeUnit gives the minimum time interval in seconds recorded on your computer system."
$TracePattern::usage = "$TracePattern is the currently active pattern argument to Trace and related functions. It can be reset during the trace to alter the set of expressions recorded or printed."
$TracePostAction::usage = "$TracePostAction is the currently active fourth argument to TraceScan (or the equivalent in related functions). It can be reset during the trace to alter the action taken after intercepted expressions are evaluated."
$TracePreAction::usage = "$TracePreAction is the currently active first argument to TraceScan (or the equivalent in related functions). It can be reset during the trace to alter the action taken before intercepted expressions are evaluated."
$Urgent::usage = "$Urgent gives the list of files and pipes to which urgent output from Mathematica is sent."
$UserBaseDirectory::usage = "$UserBaseDirectory gives the base directory in which user-specific files to be loaded by Mathematica are conventionally placed."
$UserName::usage = "$UserName gives the login name of the user who invoked the Mathematica kernel, as recorded by the operating system."
$Version::usage = "$Version is a string that represents the version of Mathematica you are running."
$VersionNumber::usage = "$VersionNumber is a real number which gives the current Mathematica kernel version number, and increases in successive versions."
Null
