(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5735,        139]*)
(*NotebookOutlinePosition[      6416,        163]*)
(*  CellTagsIndexPosition[      6372,        159]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "J/Link Example: A File Chooser Dialog\n\n",
  StyleBox["Code for the file chooser dialog from section 1.3.6 of the J/Link \
User Guide.\n\nYou need the Swing classes installed to run this example. \
Swing is a standard part of the JDK 1.2 version, but 1.1.x versions may have \
it as well. If you get a lot of LoadJavaClass::fail messages, you either do \
not have Swing, or you do not have a recent-enough version of it.\n\nTo try \
this example, evaluate all the initialization cells (you can do this with the \
menu command Kernel/Evaluation/Evaluate Initialization). Then go to the \
Examples section.",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell[TextData[{
  "Needs[\"JLink`\"]\n\nFileChooserDialog[] := FileChooserDialog[\"Select a \
file:\", \"Open\", Directory[]]\n\nFileChooserDialog[title_String, \
okText_String, dir_String] :=\n\tJavaBlock[\n\t\tModule[{dlg, frm, dummy, \
chosenFile, result = Null},\n\t\t\tInstallJava[];\n\t\t\tdlg = \
JavaNew[\"javax.swing.JFileChooser\"];\n\t\t\tIf[!JavaObjectQ[dlg],\n\t\t\t\t\
Print[\"You must have the Swing classes installed for this example.\"];\n\t\t\
\t\tReturn[$Failed]\n\t\t\t];\n\t\t\t\
dlg@setCurrentDirectory[JavaNew[\"java.io.File\", dir]];\n\t\t\t\
dlg@setDialogTitle[title];\n\t\t\t(* We cannot call JavaShow to display the \
JFileChooser dialog because it is not\n\t\t\t   a subclass of Window, and \
also because it has its own special showDialog()\n\t\t\t   method that should \
be invoked to display it and run its modal event loop.\n\t\t\t   Recall that \
on some platforms (notably Mac and Windows), JavaShow performs\n\t\t\t   some \
internal low-level steps to allow Java windows to come to the foreground\n\t\t\
\t   in front of the notebook window. Because we cannot call JavaShow here, \
the\n\t\t\t   dialog window does not reliably come to the foreground on all \
platforms\n\t\t\t   without a little help. The trick is to create a small \
window that we\n\t\t\t   can call JavaShow on before we display the dialog. \
The \"dummy\" window on\n\t\t\t   which we will call JavaShow is of type \
Dialog, because if it was a Frame\n\t\t\t   it would show up in the taskbar \
on Windows, which we want to avoid.\n\t\t\t*)\n\t\t\tfrm = \
JavaNew[\"java.awt.Frame\"]; (* Need a frame to host the dummy dialog. *)\n\t\
\t\tdummy = JavaNew[\"java.awt.Dialog\", frm];\n\t\t\t(* Put it offscreen. *)\
\n\t\t\tdummy@setLocation[-500, -500];\n",
  StyleBox["\t\t\tJavaShow[",
    PageWidth->Infinity,
    InitializationCell->True,
    ShowSpecialCharacters->False,
    FontFamily->"Courier New"],
  "dummy",
  StyleBox["];\n",
    PageWidth->Infinity,
    InitializationCell->True,
    ShowSpecialCharacters->False,
    FontFamily->"Courier New"],
  "\t\t\t(* On Linux and perhaps other UNIX platforms, we cannot put a dialog \
truly\n\t\t\t   offscreen until after it is shown. Thus we repeat the \
setLocation().\n\t\t\t*)\n\t\t\tdummy@setLocation[-500, -500];\n\t\t\t\
If[dlg@showDialog[Null, okText] === JFileChooser`APPROVEUOPTION,\n\t\t\t\t(* \
showDialog will not return until the dialog is dismissed. *)\n\t\t\t\t\
chosenFile = dlg@getSelectedFile[];\n\t\t\t\tIf[chosenFile =!= Null,\n\t\t\t\t\
\tresult = chosenFile@getPath[]\n\t\t\t\t]\n\t\t\t];\n\t\t\tfrm@dispose[];\n\t\
\t\tdummy@dispose[];\n\t\t\tresult\n\t\t]\n\t]"
}], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["\<\
These examples just return the full path of the selected file. They do not \
perform any actual file operations..\
\>", "Text"],

Cell["This is a simple \"Open\"-style dialog:", "Text"],

Cell["FileChooserDialog[]", "Input"],

Cell["This is a simple \"Save\"-style dialog:", "Text"],

Cell["FileChooserDialog[\"Save data as:\", \"Save\", Directory[]]", "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
AutoGeneratedPackage->None,
WindowSize->{747, 492},
WindowMargins->{{5, Automatic}, {Automatic, 2}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 728, 13, 286, "Title"],

Cell[CellGroupData[{
Cell[2492, 68, 26, 0, 47, "Subsection"],
Cell[2521, 70, 2745, 47, 876, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[5303, 122, 30, 0, 31, "Subsection"],
Cell[5336, 124, 137, 3, 33, "Text"],
Cell[5476, 129, 55, 0, 33, "Text"],
Cell[5534, 131, 36, 0, 30, "Input"],
Cell[5573, 133, 55, 0, 33, "Text"],
Cell[5631, 135, 76, 0, 30, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

