(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4903,        137]*)
(*NotebookOutlinePosition[      5584,        161]*)
(*  CellTagsIndexPosition[      5540,        157]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "J/Link Example: The GetURL Function\n\n",
  StyleBox["Code for the URL-reading functions from section 1.3.4 of the \
J/Link User Guide.\n\nTo try this example, evaluate all the initialization \
cells (you can do this with the menu command Kernel/Evaluation/Evaluate \
Initialization). Then go to the Examples section.",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell[TextData[{
  "Needs[\"JLink`\"]\n\nGetURL[url_String, opts___?OptionQ] :=\n\tJavaBlock[\n\
\t\tModule[{u, stream, numRead, outFile, buf},\n\t\t\tInstallJava[];\n\t\t\tu \
= JavaNew[\"java.net.URL\", url];\n\t\t\t(* This is where the error will show \
up if the URL is not valid.\n\t\t\t   A Java exception will be thrown during \
openStream, which\n\t\t\t   causes the method to return $Failed.\n\t\t\t*)\n\t\
\t\tstream = u@openStream[];\n\t\t\tIf[stream === $Failed, Return[$Failed]];\n\
\t\t\tbuf = JavaNew[\"[B\", 5000]; (* 5000 is an arbitrary buffer size *)\n\t\
\t\toutFile = OpenTemporary[DOSTextFormat->False, CharacterEncoding->{}];\n\t\
\t\tWhile[(numRead = stream@read[buf]) > 0,\n\t\t\t\t",
  StyleBox["WriteString[outFile, FromCharacterCode[If[# < 0, # + 256, #]& /@\n\
\t\t\t\t\t\tTake[JavaObjectToExpression[buf], numRead]]]\n",
    PageWidth->Infinity,
    InitializationCell->True,
    ShowSpecialCharacters->False],
  "\t\t\t];\n\t\t\tstream@close[];\n\t\t\tClose[outFile]   (* Close returns \
the filename *)\n\t\t]\n\t]\n\nUnprotect[Get];\nGet[s_String] :=\n\t\
Module[{tempFile, res},\n\t\ttempFile = GetURL[s];\n\t\tIf[tempFile =!= \
$Failed,\n\t\t\tres = Get[tempFile];\n\t\t\tDeleteFile[tempFile];\n\t\t\tres,\
\n\t\t(* else *)\n\t\t\t$Failed\n\t\t]\n\t] /; StringMatchQ[s, \"http://*\"]\n\
Protect[Get];\n\nNotebookOpenURL[url_String] := NotebookOpen[GetURL[url]]"
}], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell[TextData[{
  "If you use a proxy server to access the Internet, the examples below might \
fail, probably after a long timeout. On some systems you may need to call the \
",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " function SetInternetProxy with the correct values for your network. You \
can get these values from your system administrator or read them from your \
browser settings. Typical values might look something like:"
}], "Text"],

Cell["\<\
(** Uncomment, edit, and evaluate if necessary

SetInternetProxy[\"proxy.mycompany.com\", 8080]

**)\
\>", "Input"],

Cell["Try these:", "Text"],

Cell["<<http://www.wolfram.com/solutions/mathlink/jlink/hello.m", "Input"],

Cell["\<\
NotebookOpenURL[\"http://www.wolfram.com/solutions/mathlink/jlink/hello.nb\"]\
\
\>", "Input"],

Cell["Here is demonstration of how to read an image.", "Text"],

Cell["\<\
imgFile = GetURL[\"http://www.wolfram.com/images/gallery/infinity.gif\"];
img = Import[imgFile, \"GIF\"]; (* Use \"JPEG\" format specification for JPEG \
images *)
DeleteFile[imgFile];
Show[img]\
\>", "Input"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
AutoGeneratedPackage->None,
WindowSize->{800, 529},
WindowMargins->{{7, Automatic}, {Automatic, 3}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 440, 9, 218, "Title"],

Cell[CellGroupData[{
Cell[2204, 64, 26, 0, 47, "Subsection"],
Cell[2233, 66, 1491, 24, 714, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[3761, 95, 30, 0, 31, "Subsection"],
Cell[3794, 97, 453, 9, 71, "Text"],
Cell[4250, 108, 125, 6, 102, "Input"],
Cell[4378, 116, 26, 0, 33, "Text"],
Cell[4407, 118, 74, 0, 30, "Input"],
Cell[4484, 120, 104, 3, 30, "Input"],
Cell[4591, 125, 62, 0, 33, "Text"],
Cell[4656, 127, 219, 6, 84, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

