(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5200,        163]*)
(*NotebookOutlinePosition[      5881,        187]*)
(*  CellTagsIndexPosition[      5837,        183]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "J/Link Example: A Modal Input Dialog\n\n",
  StyleBox["Code for the GetAngle function from section 1.3.5 of the J/Link \
User Guide.\n\nThis example demonstrates the use of ",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["DoModal",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" to create a simple modal input dialog that returns a result to ",
    
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Mathematica",
    FontSize->12,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[".\n\nTo try this example, evaluate all the initialization cells \
(you can do this with the menu command Kernel/Evaluation/Evaluate \
Initialization). Then go to the Example section.",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell["\<\
Needs[\"JLink`\"]

GetAngle[] :=
\tJavaBlock[
\t\tModule[{frm, inputField, cbGroup, degBox, radBox, label, okButton, \
cancelButton, wasOKButton, angle},

\t\t\tInstallJava[];

\t\t\tfrm = JavaNew[\"com.wolfram.jlink.MathFrame\"];
\t\t\tlabel = JavaNew[\"java.awt.Label\", \"Enter an angle:\"];
\t\t\tinputField = JavaNew[\"java.awt.TextField\"];
\t\t\tcbGroup = JavaNew[\"java.awt.CheckboxGroup\"];
\t\t\tdegBox = JavaNew[\"java.awt.Checkbox\", \"degrees\", cbGroup, True];
\t\t\tradBox = JavaNew[\"java.awt.Checkbox\", \"radians\", cbGroup, False];
\t\t\tokButton = JavaNew[\"java.awt.Button\", \"OK\"];
\t\t\tcancelButton = JavaNew[\"java.awt.Button\", \"Cancel\"];
\t\t\t
\t\t\tfrm@setLayout[Null];
\t\t\tfrm@add[label];
\t\t\tfrm@add[inputField];
\t\t\tfrm@add[degBox];
\t\t\tfrm@add[radBox];
\t\t\tfrm@add[okButton];
\t\t\tfrm@add[cancelButton];
\t\t\t
\t\t\tfrm@setBounds[200, 200, 200, 160];
\t\t\tlabel@setBounds[20, 30, 150, 20];
\t\t\tinputField@setBounds[20, 70, 60, 28];
\t\t\tdegBox@setBounds[100, 60, 80, 20];
\t\t\tradBox@setBounds[100, 80, 80, 20];
\t\t\tokButton@setBounds[40, 120, 50, 20];
\t\t\tcancelButton@setBounds[100, 120, 50, 20];
\t\t\tfrm@setResizable[False];
\t\t\t
\t\t\tokButton@addActionListener[JavaNew[\"com.wolfram.jlink.\
MathActionListener\", \"(EndModal[]; True)&\"]];
\t\t\tcancelButton@addActionListener[JavaNew[\"com.wolfram.jlink.\
MathActionListener\", \"(EndModal[]; False)&\"]];
\t\t\t
\t\t\tJavaShow[frm];

\t\t\tfrm@setModal[];
\t\t\twasOKButton = DoModal[];
\t\t\t(* Even though the window may have been closed, it is perfectly OK to \
extract values fom the
\t\t\t   controls in the window.
\t\t\t*)
\t\t\tIf[TrueQ[wasOKButton],
\t\t\t\tangle = ToExpression[inputField@getText[]];
\t\t\t\tIf[angle =!= Null && degBox@getState[], angle *= Pi/180],
\t\t\t(* else *)
\t\t\t\t(* We will get here if the Cancel button was clicked (wasOKButton \
will be False),
\t\t\t\t   or if the dialog was closed by clicking in its close box \
(wasOKButton will be Null).
\t\t\t\t*)
\t\t\t\tangle = $Failed
\t\t\t];
\t\t\t(* If the cancel or OK buttons were clicked, frm is still visible, so \
we dispose it here. *)
\t\t\tfrm@dispose[];
\t\t\tangle
\t\t]
\t]\
\>", "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection"],

Cell["GetAngle[]", "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
AutoGeneratedPackage->None,
WindowSize->{768, 501},
WindowMargins->{{3, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 985, 26, 252, "Title"],

Cell[CellGroupData[{
Cell[2749, 81, 26, 0, 47, "Subsection"],
Cell[2778, 83, 2298, 69, 1056, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[5113, 157, 29, 0, 31, "Subsection"],
Cell[5145, 159, 27, 0, 30, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

