(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5976,        200]*)
(*NotebookOutlinePosition[      6657,        224]*)
(*  CellTagsIndexPosition[      6613,        220]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "J/Link Example: A Button Palette\n\n",
  StyleBox["Code for the Palette example from section 1.3 of the J/Link User \
Guide.\n",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\nThis example demonstrates the use of the ",
    FontFamily->"Arial",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["ShareFrontEnd",
    FontFamily->"Arial",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" function to allow Java interface elements interact with notebook \
windows in the same way that front end palettes can.\n\nBecause of current \
limitations with ShareFrontEnd, this example will not work with a remote \
kernel; the same machine must be running the kernel and the front end.\n",
    FontFamily->"Arial",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\nTo try this example, evaluate all the initialization cells (you \
can do this with the menu command Kernel/Evaluation/Evaluate Initialization). \
Then go to the Example section.",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell["\<\
BeginPackage[\"PaletteDemo`\", \"JLink`\"];

PaletteDemo;

Begin[\"`Private`\"];

paletteButton[label_String, buttonFunc_String] :=
\tJavaBlock[
\t\tModule[{button, listener},
\t\t\tbutton = JavaNew[\"java.awt.Button\"];
\t\t\tbutton@setLabel[label];
\t\t\t(* Note that the button function callbacks are private to this package, \
so we need
\t\t\t   to make sure that when they are called from Java their full names \
are used. Thus,
\t\t\t   we prepend this package's Private` context to the names we send to \
Java.
\t\t\t*)
\t\t\tlistener = JavaNew[\"com.wolfram.jlink.MathActionListener\", \
\"PaletteDemo`Private`\" <> buttonFunc];
\t\t\tbutton@addActionListener[listener];
\t\t\tbutton
\t\t]
\t]

showPalette[buttons:{__?JavaObjectQ}] :=
\tJavaBlock[
\t\tModule[{frm, tok},
\t\t\tfrm = JavaNew[\"com.wolfram.jlink.MathFrame\"];
\t\t\tfrm@setLayout[JavaNew[\"java.awt.GridLayout\", 0, 1]];
\t\t\tfrm@add[#]& /@ buttons;
\t\t\tReleaseJavaObject[buttons];
\t\t\tfrm@pack[];
\t\t\ttok = ShareFrontEnd[];
\t\t\t(* We use the frame's onClose method to unregister the request for
\t\t\t   front end sharing.
\t\t\t*)
\t\t\tfrm@onClose[\"UnshareFrontEnd[\" <> ToString[tok] <> \"]\"];
\t\t\tJavaShow[frm];
\t\t]
\t]

printButtonFunc[event_, _] :=
\tJavaBlock[
\t\tNotebookApply[SelectedNotebook[], event@getSource[]@getLabel[]];
\t\t(* We need to explicitly release the event object, since it was sent to
\t\t   Mathematica before the JavaBlock was entered. *)
\t\tReleaseJavaObject[event]
\t]

applyButtonFunc[event_, _] :=
\tJavaBlock[
\t\tWith[{nb = SelectedNotebook[]},
\t\t\tNotebookApply[nb, event@getSource[]@getLabel[], All];
\t\t\tReleaseJavaObject[event];
\t\t\tSelectionEvaluate[nb]
\t\t];
\t]

plotButtonFunc[event_, _] :=
\t(
\t\tPlot[x,{x,0,1}];
\t\tReleaseJavaObject[event];
\t)

printButtonFunc2[event_, _] :=
\tJavaBlock[
\t\tPrint[event@getSource[]@getLabel[]];
\t\tReleaseJavaObject[event];
\t]

PaletteDemo[] :=
\tJavaBlock[
\t\tModule[{btn1, btn2, btn3, btn4},
\t\t\tInstallJava[];
\t\t\tbtn1 = paletteButton[\"insertMe\", \"printButtonFunc\"];
\t\t\tbtn2 = paletteButton[\"Expand[\\[SelectionPlaceholder]]\", \
\"applyButtonFunc\"];
\t\t\tbtn3 = paletteButton[\"Create Plot\", \"plotButtonFunc\"];
\t\t\tbtn4 = paletteButton[\"printMe\", \"printButtonFunc2\"];
\t\t\tshowPalette[{btn1, btn2, btn3, btn4}]
\t\t]
\t]
\t
End[];
EndPackage[];\
\>", "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection"],

Cell["\<\
You should have called InstallJava prior to running this example.\
\>", "Text"],

Cell["PaletteDemo[]", "Input"],

Cell["\<\
Note that you can continue to use the front end normally while the palette \
window is visible and active.

When you are finished with the palette window, close it. This will shut down \
front end sharing and kernel sharing.\
\>", "Text"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
AutoGeneratedPackage->None,
WindowSize->{817, 512},
WindowMargins->{{6, Automatic}, {Automatic, 9}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 1246, 30, 320, "Title"],

Cell[CellGroupData[{
Cell[3010, 85, 26, 0, 47, "Subsection"],
Cell[3039, 87, 2467, 90, 1470, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[5543, 182, 29, 0, 31, "Subsection"],
Cell[5575, 184, 89, 2, 33, "Text"],
Cell[5667, 188, 30, 0, 30, "Input"],
Cell[5700, 190, 248, 6, 71, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

