(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5615,        148]*)
(*NotebookOutlinePosition[      6296,        172]*)
(*  CellTagsIndexPosition[      6252,        168]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "J/Link Example: A ProgressBar Dialog\n\n",
  StyleBox["Code for the progress-bar dialog from section 1.3.4 of the J/Link \
User Guide.\n\nThis example demonstrates a simple ",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\"non-interactive\"",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" user interface created from ",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Mathematica ",
    FontSize->12,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["(as described in section 1.2.7 of the User Guide). It makes no \
calls back to ",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Mathematica",
    FontSize->12,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" and does not return a result to ",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Mathematica",
    FontSize->12,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[".\n\nYou need the Swing classes installed to run this example. \
Swing is a standard part of the JDK 1.2 version, but 1.1.x versions may have \
it as well. If you get a lot of LoadClass::fail messages, you either do not \
have Swing, or you do not have a recent-enough version of it.\n\nTo try this \
example, evaluate all the initialization cells (you can do this with the menu \
command Kernel/Evaluation/Evaluate Initialization). Then go to the Example \
section.",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell[TextData[{
  "Needs[\"JLink`\"]\n\nShowProgressBar[title_String:\"Computation \
Progress\", caption_String:\"Percent complete:\", percent_Integer:0] :=\n\t\
Module[{frame, panel, label, bar},\n\t\tJavaBlock[\n\t\t\tInstallJava[];\n\t\t\
\tbar = JavaNew[\"javax.swing.JProgressBar\"];\n\t\t\tIf[!JavaObjectQ[bar],\n\
\t\t\t\tPrint[\"You must have the Swing classes installed for this \
example.\"];\n\t\t\t\tReturn[$Failed]\n\t\t\t];\n\t\t\tframe = \
JavaNew[\"javax.swing.JFrame\", title];\n\t\t\tframe@setSize[300, 110];\n\t\t\
\tframe@setResizable[False];\n\t\t\tframe@setLocation[400, 400];\n\t\t\tpanel \
= JavaNew[\"javax.swing.JPanel\"];\n\t\t\tpanel@setLayout[Null];\n\t\t\t\
frame@getContentPane[]@add[panel];\n\t\t\tlabel = \
JavaNew[\"javax.swing.JLabel\", caption];\n\t\t\tlabel@setBounds[20, 10, 260, \
20];\n\t\t\tpanel@add[label];\n\t\t\tbar@setBounds[20, 40, 260, 30];\n\t\t\t\
bar@setMinimum[0];\n\t\t\tbar@setMaximum[100];\n\t\t\tbar@setValue[percent];\n\
\t\t\tpanel@add[bar];\n\t\t\tJavaShow[frame];\n\t\t\tbar\n\t\t]\n\t]\n\n\
DestroyProgressBar[bar_?JavaObjectQ] :=\n\tJavaBlock[\n\t\t\
LoadClass[\"javax.swing.SwingUtilities\"];\n\t\t\
SwingUtilities`windowForComponent[bar]@dispose[];\n\t\tRelease",
  "Java",
  "Object[bar]\n\t]\n\n\n",
  StyleBox["ProgressBarDemo[] :=\n\tModule[{bar, n},\n\t\tbar = \
ShowProgressBar[];\n\t\tbar@setString[\"0%\"];\n\t\t\
bar@setStringPainted[True];\n\t\tn = 0;\n\t\tWhile[n <= 5,\n\t\t\t\
bar@setValue[n/5 * 100];\n\t\t\tbar@setString[ToString[n/5 * 100] <> \"%\"];\n\
\t\t\tPause[1]; (* This simulates the time-consuming computation. *)\n\t\t\t\
n++\n\t\t];\n\t\tDestroyProgressBar[bar];\n\t]",
    PageWidth->Infinity,
    InitializationCell->True,
    ShowSpecialCharacters->False]
}], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection"],

Cell["ProgressBarDemo[]", "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
AutoGeneratedPackage->None,
WindowSize->{786, 565},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 1846, 48, 320, "Title"],

Cell[CellGroupData[{
Cell[3610, 103, 26, 0, 47, "Subsection"],
Cell[3639, 105, 1845, 32, 966, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[5521, 142, 29, 0, 31, "Subsection"],
Cell[5553, 144, 34, 0, 30, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

