(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8757,        258]*)
(*NotebookOutlinePosition[      9428,        281]*)
(*  CellTagsIndexPosition[      9384,        277]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "J/Link Example: A \"RealTimeAlgebra\" Dialog\n\n",
  StyleBox["Code for the RealTimeAlgebra dialog from section 1.3 of the \
J/Link User Guide.\n\nThis example demonstrates many basic features of \
creating interactive user interface elements from ",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Mathematica",
    FontSize->12,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" code. It can be run in a modal way, using ",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["DoModal",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[", or modeless, using ",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["ShareKernel",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" or ",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["ShareFrontEnd",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[".\n\nTo try this example, evaluate all the initialization cells \
(you can do this with the menu command Kernel/Evaluation/Evaluate \
Initialization). Then go to the Examples section.",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell["\<\
Needs[\"JLink`\"]

CreateWindow[] :=
\tModule[{frame, slider, listener},
\t\tInstallJava[];
\t\t(* inText and outText are globals, because we need to refer to them by
\t\t   name in the scrollFunc. This also means we must create them outside
\t\t   the JavaBlock below.
\t\t*)
\t\tinText = JavaNew[\"java.awt.TextArea\", \"Expand[(x+1)^a]\", 8, 40];
\t\toutText = JavaNew[\"java.awt.TextArea\", 8, 40];
\t\t(* This frame could be created inside the JavaBlock, because it is \
returned
\t\t   from the JavaBlock and therefore will not be released, but it makes
\t\t   our intentions more clear to create it outside.
\t\t*)
\t\tframe = JavaNew[\"com.wolfram.jlink.MathFrame\", \"RealTimeAlgebra\"];
\t\tJavaBlock[
\t\t\tframe@setLayout[JavaNew[\"java.awt.BorderLayout\"]];
\t\t\t(* Note that we can refer to the Scrollbar`HORIZONTAL constant within \
the JavaNew
\t\t\t   command that first loads the Scrollbar class. Its value will not \
need to be
\t\t\t   resolved until that class has been loaded and all necessary \
definitions created.
\t\t\t*)
\t\t\tslider = JavaNew[\"java.awt.Scrollbar\", Scrollbar`HORIZONTAL, 0, 1, 0, \
20];
\t\t\t(* On JDK 1.4 and later, we want to set the Focusable property
\t\t\t   to avoid flashing the scroll thumb.
\t\t\t*)
\t\t\tLoadJavaClass[\"java.lang.System\"];
\t\t\tIf[ToExpression[System`getProperty[\"java.specification.version\"]] >= \
1.4,
\t\t\t\tslider@setFocusable[False]\t\t\t
\t\t\t];
\t\t\tframe@add[slider, ReturnAsJavaObject[BorderLayout`NORTH]];
\t\t\tframe@add[outText, ReturnAsJavaObject[BorderLayout`CENTER]];
\t\t\tframe@add[inText, ReturnAsJavaObject[BorderLayout`SOUTH]];
\t\t\tframe@pack[];
\t\t\t(* Use a fixed-width font for the output window to preserve
\t\t\t   formatting of multi-line expressions. *)
\t\t\toutText@setFont[JavaNew[\"java.awt.Font\", \"Courier\", Font`PLAIN, \
12]];
\t\t\tlistener = JavaNew[\"com.wolfram.jlink.MathAdjustmentListener\"];
\t\t\tlistener@setHandler[\"adjustmentValueChanged\", \"sliderFunc\"];
\t\t\tslider@addAdjustmentListener[listener];
\t\t\tframe@setLocation[200, 200];
\t\t\tJavaShow[frame]
\t\t];
\t\tframe
\t]

(* This is what will be called in response to moving the slider position: *)

sliderFunc[evt_, type_, scrollPos_] :=
\tJavaBlock[
\t\toutText@setText[
\t\t\tBlock[{a = scrollPos}, ToString[ToExpression[inText@getText[]]]]
\t\t];
\t\tReleaseJavaObject[evt]
\t]


RealTimeAlgebraModal[] :=
\tJavaBlock[
\t\t(* In the modal case, we can wrap the whole thing in JavaBlock and be \
sure that all the objects
\t\t   will get released, including the inTExt and outText ones needed during \
event handling.
\t\t*)
\t\tModule[{frm},
\t\t\tfrm = CreateWindow[];
\t\t\tfrm@setModal[];
\t\t\tDoModal[];
\t\t]
\t]

RealTimeAlgebraModeless[] :=
\tModule[{frm, token},
\t\tfrm = CreateWindow[];
\t\ttoken = ShareKernel[];
\t\t(* We use the MathFrame onClose method to specify code to be executed \
when the frame
\t\t   is closed. The use here is typical--we clean up the object references \
that
\t\t   need to persist throughout the lifetime of the window (otherwise we \
would leak
\t\t   these references), and we call UnshareKernel to unregister this \
application's
\t\t   request for kernel sharing.
\t\t*)
\t\tfrm@onClose[\"ReleaseJavaObject[inText, outText]; UnshareKernel[\" <> \
ToString[token] <> \"];\"];
\t\tReleaseJavaObject[frm];
\t]\
\>", "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["\<\
You should have called InstallJava prior to running these examples.\
\>", "Text"],

Cell["This runs the dialog in a modal way:", "Text"],

Cell["RealTimeAlgebraModal[]", "Input"],

Cell["\<\
Try entering Print[a] or Plot[Sin[a x],{x,0,2Pi}] in the bottom panel and \
drag the slider. Notice how the output appears in the notebook. Close the \
window to end the program.

For comparison, next run the dialog in a modeless way:\
\>", "Text"],

Cell["RealTimeAlgebraModeless[];", "Input"],

Cell["\<\
Note how you can continue to use the front end for computations while the \
RealTimeAlgebra window is up.

Try Print[a] in the lower panel now. Note that the Print output does not \
appear in the front end. When using ShareKernel, which is how modeless \
interfaces are implemented, the Java link is the kernel's $ParentLink while \
the slider is being dragged, so all side-effect output gets sent to Java, \
where it is discarded by the internal code of the MathListener class. You can \
get the output to appear in the front end by using ShareFrontEnd. Without \
closing the dialog, try this:\
\>", "Text"],

Cell["token = ShareFrontEnd[];", "Input"],

Cell["\<\
ShareFrontEnd returns a token we can pass to UnshareFrontEnd, below, to \
unregieter our interest in front end sharing.

Now try Print[a] or Plot[Sin[a x],{x,0,2Pi}] in the lower panel. Note how the \
output appears in the notebook. ShareFrontEnd is an extension to ShareKernel \
that causes certain kinds of output and some special commands (like \
notebook-manipulation functions) to be directed to the front end.

After you are finished with the modeless version, close its window and then \
execute the following to turn off front end sharing. This will have the \
effect of shutting down both front end and kernel sharing, as it unregisters \
the last remaining request for sharing.\
\>", "Text"],

Cell["UnshareFrontEnd[token]", "Input"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 949}},
AutoGeneratedPackage->None,
WindowSize->{824, 517},
WindowMargins->{{1, Automatic}, {Automatic, 2}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 1454, 40, 394, "Title"],

Cell[CellGroupData[{
Cell[3255, 97, 26, 0, 38, "Subsection"],
Cell[3284, 99, 3459, 100, 1488, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[6780, 204, 30, 0, 30, "Subsection"],
Cell[6813, 206, 91, 2, 33, "Text"],
Cell[6907, 210, 52, 0, 33, "Text"],
Cell[6962, 212, 39, 0, 30, "Input"],
Cell[7004, 214, 258, 6, 90, "Text"],
Cell[7265, 222, 43, 0, 30, "Input"],
Cell[7311, 224, 618, 11, 128, "Text"],
Cell[7932, 237, 41, 0, 30, "Input"],
Cell[7976, 239, 711, 13, 147, "Text"],
Cell[8690, 254, 39, 0, 30, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

