(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6218,        158]*)
(*NotebookOutlinePosition[      6899,        182]*)
(*  CellTagsIndexPosition[      6855,        178]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "J/Link Example: A \"RealTimePlotting\" Dialog\n\n",
  StyleBox["Code for a RealTimePlot dialog adapted from the RealTimeAlgebra \
example.\n\nAs you drag the slider the value of the parameter ",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["a",
    FontSize->12,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" is modified and the plotting command is reevaluated.\n\n\
Contributed by Tom Wickham-Jones",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell[TextData[{
  "Needs[\"JLink`\"]\n\n(* Set this to True to cause the front end to be used \
for rendering services. *)\nUseFrontEndForRendering = False;\n\n\
createWindow[graphicsCommand_] :=\n\tModule[{frame, slider, listener, text},\n\
\t\ttext =\n\t\t\tWhich[\n\t\t\t\tgraphicsCommand === \"\",\n\t\t\t\t\t\
\"Plot[Sin[x]^a, {x,0,4Pi}]\",\n\t\t\t\tStringQ[graphicsCommand],\n\t\t\t\t\t\
graphicsCommand,\n\t\t\t\tTrue,\n\t\t\t\t\tToString[graphicsCommand, \
InputForm]\n\t\t\t];\n\t\tInstallJava[];\n\t\tinText = \
JavaNew[\"java.awt.TextArea\", text, 4, 40];\n\t\tframe = \
JavaNew[\"com.wolfram.jlink.MathFrame\", \"RealTimePlotting\"];\n\t\tdrawArea \
= JavaNew[\"com.wolfram.jlink.MathCanvas\"];\n\t\tdrawArea@",
  StyleBox["setUsesFE[",
    PageWidth->Infinity,
    ShowSpecialCharacters->False],
  "UseFrontEndForRendering",
  StyleBox["];",
    PageWidth->Infinity,
    ShowSpecialCharacters->False],
  "\n\t\tdrawArea@setSize[400, 272];",
  StyleBox["\n",
    PageWidth->Infinity,
    ShowSpecialCharacters->False,
    FontFamily->"Courier New",
    FontSize->10],
  "\t\tJavaBlock[\n\t\t\tframe@setLayout[JavaNew[\"java.awt.BorderLayout\"]];\
\n\t\t\tslider = JavaNew[\"java.awt.Scrollbar\", Scrollbar`HORIZONTAL, 0, 1, \
0, 20];\n\t\t\tframe@add[slider, ReturnAsJavaObject[BorderLayout`NORTH]];\n\t\
\t\tframe@add[drawArea, ReturnAsJavaObject[BorderLayout`CENTER]];\n\t\t\t\
frame@add[inText, ReturnAsJavaObject[BorderLayout`SOUTH]];\n\t\t\t\
frame@pack[];\n\t\t\tlistener = \
JavaNew[\"com.wolfram.jlink.MathAdjustmentListener\"];\n\t\t\t\
listener@setHandler[\"adjustmentValueChanged\", \"sliderFunc\"];\n\t\t\t\
slider@addAdjustmentListener[listener];\n\t\t\tframe@setLocation[200, 200];\n\
\t\t\tframe@setSize[408, 394];\n\t\t\tJavaShow[frame]\n\t\t];\n\t\tframe\n\t]\
\n\n(* This is what will be called in response to moving the slider position: \
*)\n\nsliderFunc[evt_, type_, scrollPos_] :=\n\tJavaBlock[\n\t\t(* Keeping \
track of lastScrollPos is an optimization for Mac OSX, which will queue\n\t\t \
  up many ScrollBar events with the same scrollPos while the plot is drawing \
if you\n\t\t   hold down the scroll arrow. We don't want to keep rendering \
the image as we\n\t\t   service these redundant events.\n\t\t*)\n\t\t\
If[scrollPos =!= lastScrollPos,\n\t\t\tBlock[{a = scrollPos, $DisplayFunction \
= Identity, obj},\n\t\t\t\tobj = ToExpression[inText@getText[]];\n\t\t\t\tobj \
= Show[obj, PlotRange-> yRange];\n\t\t\t\t\
drawArea@setMathCommand[ToString[obj, InputForm]];\n\t\t\t\t\
drawArea@repaintNow[];\n\t\t\t\tlastScrollPos = scrollPos\n\t\t\t]\n\t\t];\n\t\
\tReleaseObject[evt]\n\t]\n\nRealTimePlot[text_String:\"\", opts___?OptionQ] \
:=\n\tJavaBlock[\n\t\t(* We can wrap the whole thing in JavaBlock and be sure \
that all the objects will get \n\t\t   released, including the inText and \
outText ones needed during event handling.\n\t\t*)\n\t\tBlock[{frm, yRange, \
lastScrollPos},\n\t\t\tyRange = PlotRange /. Flatten[{opts}] /. PlotRange -> \
{-1, 1};\n\t\t\tfrm = createWindow[text];\n\t\t\tfrm@setModal[];\n\t\t\t\
DoModal[];\n\t\t]\n\t]"
}], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples", "Subsection"],

Cell["\<\
This runs the plotting dialog, you can set the graphics command and the \
plotrange to be used.\
\>", "Text"],

Cell["RealTimePlot[]", "Input"],

Cell["\<\
You can set the graphics command and the PlotRange to be used:\
\>", "Text"],

Cell["RealTimePlot[\"Plot[Sin[x+a Pi/4], {x,0,4Pi}]\"]", "Input"],

Cell["RealTimePlot[PlotRange -> {0,1}]", "Input"],

Cell["\<\
RealTimePlot[\"ParametricPlot[{a/5. Sin[t], Cos[t]}, {t,0,2Pi}, \
AspectRatio->Automatic]\", PlotRange -> All]\
\>", "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
AutoGeneratedPackage->None,
WindowSize->{823, 547},
WindowMargins->{{1, Automatic}, {Automatic, 3}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 642, 17, 235, "Title"],

Cell[CellGroupData[{
Cell[2406, 72, 26, 0, 47, "Subsection"],
Cell[2435, 74, 3185, 55, 1308, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[5657, 134, 30, 0, 31, "Subsection"],
Cell[5690, 136, 119, 3, 33, "Text"],
Cell[5812, 141, 31, 0, 30, "Input"],
Cell[5846, 143, 86, 2, 33, "Text"],
Cell[5935, 147, 65, 0, 30, "Input"],
Cell[6003, 149, 49, 0, 30, "Input"],
Cell[6055, 151, 135, 3, 48, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

