(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5191,        159]*)
(*NotebookOutlinePosition[      5872,        183]*)
(*  CellTagsIndexPosition[      5828,        179]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "J/Link Example: Scribble\n\n",
  StyleBox["Code for the Scribble example from section 1.2.7 of the J/Link \
User Guide.\n",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\nThis example is a simple demonstration of drawing into a Java \
window with ",
    FontFamily->"Arial",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["Mathematica",
    FontFamily->"Arial",
    FontSize->12,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" code.\n\n",
    FontFamily->"Arial",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["To try this example, evaluate all the initialization cells (you \
can do this with the menu command Kernel/Evaluation/Evaluate Initialization). \
Then go to the Example section.",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell["\<\
Needs[\"JLink`\"]

Scribble[] :=
\tJavaBlock[
\t\tModule[{frame, mathCanvas, offscreen, g, mml, pts, mouseDraggedFunc},
\t\t\tInstallJava[];
\t\t\tframe = JavaNew[\"com.wolfram.jlink.MathFrame\", \"Scribble\"];
\t\t\tframe@setLayout[JavaNew[\"java.awt.BorderLayout\"]];
\t\t\tmathCanvas = JavaNew[\"com.wolfram.jlink.MathCanvas\"];
\t\t\tframe@add[\"Center\", mathCanvas];
\t\t\tframe@setSize[400, 400];
\t\t\tframe@layout[];
\t\t\tJavaShow[frame];
\t\t\t(* Now create the offscreen image and the graphics context
\t\t\t   for drawing into it.
\t\t\t*)
\t\t\toffscreen = mathCanvas@createImage[mathCanvas@getSize[]@width,
                                  \t\t mathCanvas@getSize[]@height];
\t\t\tg = offscreen@getGraphics[];
\t\t\t(* Now create the MathMouseMotionListener that will do the drawing
\t\t\t   and set its mouseDragged event handler callback.
\t\t\t*)
\t\t\tmml = JavaNew[\"com.wolfram.jlink.MathMouseMotionListener\"];
\t\t\t(* Because mouseDraggedFunc is local to this Module, its name is not
\t\t\t   really 'mouseDraggedFunc', but rather something link \
'mouseDraggedFunc$123'.
\t\t\t   We use the ToString trick to capture its true name.
\t\t\t*)
\t\t\tmml@setHandler[\"mouseDragged\", ToString[mouseDraggedFunc]];
\t\t\tmathCanvas@addMouseMotionListener[mml];
\t\t\tmouseDraggedFunc[_, x_, y_, _] :=
\t\t\t\t(g@drawLine[pts[[-1, 1]], pts[[-1, 2]], x, y];
\t\t\t\t mathCanvas@setImage[offscreen];
\t\t\t\t mathCanvas@repaintNow[];
\t\t\t\t AppendTo[pts, {x,y}];);
\t\t\t(* Initialize the pts list and run the program modally. *)
\t\t\tpts = {{0,0}};
\t\t\tframe@setModal[];
\t\t\tDoModal[];
\t\t\tpts
\t\t]
\t]\
\>", "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection"],

Cell["pts = Scribble[];", "Input"],

Cell["Click or drag the mouse to draw in the window.", "Text"],

Cell[TextData[{
  "Java's coordinate system has (0, 0) at the top left of the image, whereas \
",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " has (0, 0) at the bottom left. Therefore to have ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " render the drawing, we need to flip the points in the y direction: "
}], "Text"],

Cell["Show[Graphics[Line[({1, -1} * #)& /@ pts]], AspectRatio->1]", "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
AutoGeneratedPackage->None,
WindowSize->{814, 520},
WindowMargins->{{3, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 1040, 30, 252, "Title"],

Cell[CellGroupData[{
Cell[2804, 85, 26, 0, 47, "Subsection"],
Cell[2833, 87, 1738, 46, 750, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4608, 138, 29, 0, 31, "Subsection"],
Cell[4640, 140, 34, 0, 30, "Input"],
Cell[4677, 142, 62, 0, 33, "Text"],
Cell[4742, 144, 342, 9, 52, "Text"],
Cell[5087, 155, 76, 0, 30, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

