(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4304,        141]*)
(*NotebookOutlinePosition[      4985,        165]*)
(*  CellTagsIndexPosition[      4941,        161]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "J/Link Example: The SimpleModal Dialog\n\n",
  StyleBox["Code for the SimpleModal dialog from section 1.2.7 of the J/Link \
User Guide.\n\nThis example demonstrates basic use of the ",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["DoModal",
    FontSize->12,
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" function to create a modal inteface (as described in section \
1.2.7 of the User Guide).\n\nTo try this example, evaluate all the \
initialization cells (you can do this with the menu command \
Kernel/Evaluation/Evaluate Initialization). Then go to the Example section.",
    FontSize->12,
    FontWeight->"Plain",
    FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code", "Subsection"],

Cell["\<\
Needs[\"JLink`\"]

SimpleModal[] :=
\tJavaBlock[
\t\tModule[{frm, button, textField, windowListener, buttonListener, \
buttonFunc},

\t\t\t(* Create the GUI components. *)
\t\t\tfrm = JavaNew[\"com.wolfram.jlink.MathFrame\"];
\t\t\tbutton = JavaNew[\"java.awt.Button\"];
\t\t\ttextField = JavaNew[\"java.awt.TextField\"];

\t\t\t(* Configure their properties. *)
\t\t\tfrm@setLayout[JavaNew[\"java.awt.GridLayout\"]];
\t\t\tfrm@add[button];
\t\t\tfrm@add[textField];
\t\t\tbutton@setLabel[\"++\"];
\t\t\ttextField@setEditable[False];
\t\t\ttextField@setText[\"1\"];
\t\t\tfrm@pack[];

\t\t\t(* Create the listener and set its handler function. *)
\t\t\tbuttonListener = JavaNew[\"com.wolfram.jlink.MathActionListener\"];
\t\t\tbuttonListener@setHandler[\"actionPerformed\", ToString[buttonFunc]];
\t\t\tbutton@addActionListener[buttonListener];

\t\t\t(* Define buttonFunc. *)
\t\t\tbuttonFunc[_, _] :=
\t\t\t\tJavaBlock[
\t\t\t\t\tModule[{curText, newVal},
\t\t\t\t\t\tcurText = textField@getText[];
\t\t\t\t\t\tnewVal = ToExpression[curText] + 1;
\t\t\t\t\t\ttextField@setText[ToString[newVal]]
\t\t\t\t\t]
\t\t\t\t];

\t\t\tfrm@setLocation[200, 200];
\t\t\t(* Make the window visible and bring it in front of any
\t\t\t   notebook windows. *)
\t\t\tJavaShow[frm];

\t\t\t(* Tell the frame to end the modal loop when it is closed. *)
\t\t\tfrm@setModal[];

\t\t\t(* Enter the modal loop. *)
\t\t\tDoModal[];
\t\t]
\t]\
\>", "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection"],

Cell["\<\
You must have called InstallJava prior to running this example.\
\>", "Text"],

Cell["SimpleModal[]", "Input"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
AutoGeneratedPackage->None,
WindowSize->{760, 498},
WindowMargins->{{6, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 767, 17, 269, "Title"],

Cell[CellGroupData[{
Cell[2531, 72, 26, 0, 47, "Subsection"],
Cell[2560, 74, 1527, 52, 858, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4124, 131, 29, 0, 31, "Subsection"],
Cell[4156, 133, 87, 2, 33, "Text"],
Cell[4246, 137, 30, 0, 30, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

