
(* :Title: JLink *)

(* :Context: JLink` *)

(* :Author:
        Todd Gayley
        tgayley@wolfram.com
*)

(* :Package Version: 3.1 *)

(* :Mathematica Version: 4.0 *)
		     
(* :Copyright: J/Link source code (c) 1999-2005, Wolfram Research, Inc. All rights reserved.

   Use is governed by the terms of the J/Link license agreement, which can be found at
   www.wolfram.com/solutions/mathlink/jlink.
*)

(* :Discussion:
   J/Link is a Mathematica enhancement that integrates Java and Mathematica. You can use J/Link to call
   Java from Mathematica or call Mathematica from Java. Find out more at www.wolfram.com/solutions/mathlink/jlink.

   J/Link uses a special system wherein one package context (JLink`) has its implementation
   split among a number of .m files. Each component file has its own private context, and also
   potentially introduces public symbols (in the JLink` context) and so-called "package" symbols,
   where the term "package" comes from Java terminology, referring to symbols that are visible
   everywhere within the implementation of J/Link, but not to clients.
   
   This file is generated automatically from a tool that processes the component .m files in the JLink/Kernel
   directory. It contains only declarations, not implementation. Users who want to examine implementation
   details in the code can consult the appropriate .m files.
*)

(* :Keywords: Java MathLink *)



BeginPackage["JLink`"]


Java::usage = "Java is only used as a generic symbol for some messages."


(***************************************  Information Context  ******************************************)

(* Programmers can use these values (using their full context, as in JLink`Information`$ReleaseNumber)
   to test version information about a user's J/Link installation.
*)

`Information`$VersionNumber = 3.1
`Information`$ReleaseNumber = 0
`Information`$CreationID = 20050608174407
`Information`$CreationDate = {2005, 6, 8, 17, 44, 28.2238121}
`Information`$Version = "J/Link Version 3.1.0"


(********************************  Usage Messages (Public J/Link API)  **********************************)

(******** From InstallJava.m ********)

InstallJava::usage =
"InstallJava[] launches the Java runtime and prepares it to be used from Mathematica. Only one Java runtime is ever launched; subsequent calls to InstallJava after the first have no effect."

StartJava::usage =
"StartJava is deprecated. Use InstallJava instead."

UninstallJava::usage =
"UninstallJava[] shuts down the Java runtime that was started by InstallJava. It is provided mainly for developers who are actively recompiling Java classes for use in Mathematica and therefore need to shut down and restart the Java runtime to reload the modified classes. Users generally have no reason to call UninstallJava. The Java runtime is a shared resource used by potentially many Mathematica programs. You should leave it running unless you are absolutely sure you need to shut it down."

QuitJava::usage =
"QuitJava is deprecated. Use UninstallJava instead."

ReinstallJava::usage =
"ReinstallJava[] is a convenience function that calls UninstallJava followed by InstallJava. It takes the same arguments as InstallJava. See the usage messages for InstallJava and UninstallJava for more information."

RestartJava::usage =
"RestartJava is deprecated. Use ReinstallJava instead."

JavaLink::usage =
"JavaLink[] returns the MathLink LinkObject that is used to communicate with the J/Link Java runtime. It will return Null if Java is not running."

JavaUILink::usage =
"JavaUILink[] returns the MathLink LinkObject used by calls to Mathematica that originate from Java user-interface actions, or Null if no such link is present."

ClassPath::usage =
"ClassPath is an option to InstallJava that controls whether the Java runtime should include the contents of the CLASSPATH environment variable in its class search path. The default is ClassPath->Automatic, which means to include CLASSPATH. If you specify ClassPath->None, CLASSPATH will be ignored. You can also specify a string giving a classpath specification in the standard platform-specific notation. Users considering specifying a string as the value for the ClassPath option should probably use the more flexible AddToClassPath function instead. The main use for the ClassPath option is to set it to None, in case you want to specifically prevent J/Link from including the contents of the CLASSPATH variable in its search path."

CommandLine::usage =
"CommandLine is an option to InstallJava that specifies the first part of the command line that should be used to launch the Java runtime. You can use this option to specify a name other than \"java\" for the Java runtime, or if you have more than one version of Java installed and you need to specify the full path to the runtime you want launched. The value of this option does not specify the entire command line, however, as InstallJava may add some arguments to the end of the line, depending on other options."

JVMArguments::usage =
"JVMArguments is an option to InstallJava that allows you to specify additional command-line arguments passed to the Java virtual machine at startup. The string you specify is added to the command line used to launch Java. You can use this option to specify properties with the standard -D syntax, such as \"-Dsome.property=true\". This option is not supported on Mac OSX."

(******** From CallJava.m ********)

JavaObject::usage =
"JavaObject is used to denote an expression that refers to an object residing in Java."

JavaObjectQ::usage =
"JavaObjectQ[expr] gives True if expr is a reference to a Java object or Null, and gives False otherwise."

JavaClass::usage =
"JavaClass[\"classname\", n] represents a Java class with the specified name. The second argument is an integer index that is not relevant to users. JavaClass expressions cannot be typed in by the user; they are created by LoadJavaClass."

LoadClass::usage =
"LoadClass is deprecated. The new name is LoadJavaClass."

LoadJavaClass::usage =
"LoadJavaClass[\"classname\"] loads the specified class into Java and sets up definitions so that it can be used from Mathematica. You must specify the fully-qualified class name, for example \"java.awt.Frame\". It is safe to call LoadJavaClass multiple times on the same class; it simply returns right away without doing anything."

JavaNew::usage =
"JavaNew[javaclass, args] constructs a Java object of the specified JavaClass, passing the args to its constructor. You can also specify the class name instead of a JavaClass: JavaNew[\"classname\", args]. With this second form, the class will be loaded first if necessary."

MethodFunction::usage =
"MethodFunction[javaclass, method] returns a function that can be used to invoke the given method on objects of the given class. You can also specify the class by its fully-qualified name or by an object of the class, as in MethodFunction[\"classname\", method] or MethodFunction[javaobject, method]. mf = MethodFunction[cls, meth] followed by mf[obj, args] is identical to the more usual form obj@meth[args]. MethodFunction is purely an optimization--if you are executing the same method call hundreds or thousands of times you can use a MethodFunction to avoid repeating the extra internal steps necessary with the obj@meth[args] syntax. MethodFunction is mostly obsolete. Speed improvements in J/Link have made its benefits minimal."

FieldFunction::usage =
"FieldFunction[javaclass, field] returns a function that can be used to get or set the value of the given field in objects of the given class. You can also specify the class by its fully-qualified name or by an object of the class, as in FieldFunction[\"classname\", field] or FieldFunction[javaobject, field]. ff = FieldFunction[cls, meth] followed by ff[obj] is identical to the more usual form obj@field. FieldFunction is purely an optimization--if you are accessing the same field hundreds or thousands of times you can use a FieldFunction to avoid repeating the extra internal steps necessary with the obj@meth[args] syntax. FieldFunction is mostly obsolete. Speed improvements in J/Link have made its benefits minimal."

SetField::usage =
"SetField[obj@field, val] sets a value of an object field. It is an alternative syntax to obj@field = val. For static methods, use SetField[staticfield, val] (compared to staticfield = val). Supporting the obj@field = val syntax for fields is problematic because it requires rules to be created for the built-in function Set. SetField avoids this at the cost of breaking the simple correspondence between Java and Mathematica syntax."

StaticsVisible::usage =
"StaticsVisible is an option to LoadJavaClass (in J/Link) and LoadNETType (in .NET/Link) that specifies whether the class-specific context in which static method and field definitions are created should be placed on $ContextPath. If you load a class named \"com.foo.Bar\" containing a static method named baz, with the option StaticsVisible->True you could call the method simply with baz[args]. With StaticsVisible->False, you would have to write Bar`baz[args]. The default setting is False, to eliminate the possibility of name conflicts leading to shadowing problems."

AllowShortContext::usage =
"AllowShortContext is an option to LoadJavaClass (in J/Link) and LoadNETType (in .NET/Link) that specifies whether to create a class-specific context in \"short\" form. If you load a class named \"com.foo.Bar\" containing a static method named baz, with the option AllowShortContext->True you could call the method with Bar`baz[args]. With AllowShortContext->False, you would have to write com`foo`Bar`baz[args]. AllowShortContext->False allows you to avoid conflicts with other contexts in the system. The default is True."

UseTypeChecking::usage =
"UseTypeChecking is an option to LoadJavaClass that specifies whether to include or omit the type checking performed in Mathematica on arguments to Java calls. The default is UseTypeChecking->True. UseTypeChecking is largely superseded by the flag $RelaxedTypeChecking. If you use UseTypeChecking->False, you must make sure you pass methods exactly the argument types they expect. Also note that J/Link will not be able to correctly differentiate between multiple definitions of the same method that take the same number of arguments. Most users will have no use for this option."

Val::usage =
"Val is deprecated. The new name is JavaObjectToExpression."

JavaObjectToExpression::usage =
"JavaObjectToExpression[javaobject] converts the specified Java object reference into its value as a \"native\" Mathematica expression. Normally, all Java objects that have a meaningful \"by value\" representation in Mathematica are returned by value to Mathematica automatically. Such objects include strings, arrays (these become lists), and instances of so-called wrapper classes like java.lang.Integer. However, you can get a reference form of one of these types if you explicitly call JavaNew or use the ReturnAsJavaObject function. In such cases, you can use JavaObjectToExpression to retrieve the value. JavaObjectToExpression has no effect on objects that have no meaningful \"value\" representation in Mathematica."

ByRef::usage =
"ByRef is deprecated. The new name is ReturnAsJavaObject."

ReturnAsJavaObject::usage =
"ReturnAsJavaObject[expr] causes a Java method call or field access during the evaluation of expr to return its result as an object reference (that is, a JavaObject epxression), not a value. Most Java objects are returned as references normally, but those that have a meaningful Mathematica representation are returned \"by value\". Such objects include strings, arrays, and the so-called wrapper classes like java.lang.Integer. ReturnAsJavaObject overrides the normal behavior and forces any object returned to Mathematica to be sent only as a reference. It is typically used to avoid needlessly sending large arrays of numbers back and forth between Java and Mathematica. You can use ReturnAsJavaObject to cause only a reference to be sent, then use the JavaObjectToExpression function at the end if the final value is needed."

(******** From Exceptions.m ********)

GetJavaException::usage =
"GetJavaException[] returns the Java exception object that was thrown in the most recent call from Mathematica to Java. It returns Null if no exception was thrown in the most recent call. You can use GetJavaException in conjunction with $JavaExceptionHandler to implement a custom exception-handling scheme in Mathematica."

$JavaExceptionHandler::usage =
"$JavaExceptionHandler allows you to control how exceptions thrown in Java are handled in Mathematica. The default behavior is for exceptions to appear as messages in Mathematica. If you want to override this behavior (for example to temporarily silence messages from exceptions), assign a value to $JavaExceptionHandler. The value of $JavaExceptionHandler is treated as a function that will be passed 3 arguments: the symbol associated with the message (this will currently always be the symbol Java), the message tag (this will be the string \"excptn\" for a typical exception or \"pexcptn\" for an exception generated by a \"manual return\" method where the exception occurs after the method has manually sent its result back to Mathematica), and the descriptive string of text associated with the message. You will typically set $JavaExceptionHandler within a Block so that its effect will be limited to a precisely defined segment of code, as in the following example that silences messages: Block[{$JavaExceptionHandler = Null&}, obj@method[]]. You can use GetJavaException[] within your handler function to obtain the actual Java exception object that was thrown."

(******** From Reflection.m ********)

Constructors::usage =
"Constructors[javaclass] returns a list (in TableForm) of the Java declarations for all constructors of the specified class. You can also specify a class by its name or an object of that class, as in Constructors[\"java.net.URL\"] or Constructors[javaobject]."

Methods::usage =
"Methods[javaclass] returns a list (in TableForm) of the Java declarations for all methods of the specified class. You can also specify a class by its name or an object of that class, as in Methods[\"java.net.URL\"] or Methods[javaobject]. To make them easier to read, the declarations have had removed some keywords that are not very relevant to their use from Mathematica. These keywords are final, synchronized, and native. The public keyword is also removed, as the methods are always public."

Fields::usage =
"Fields[javaclass] returns a list (in TableForm) of the Java declarations for all fields of the specified class. You can also specify a class by its name or an object of that class, as in Fields[\"java.net.URL\"] or Fields[javaobject]. To make them easier to read, the declarations have had the keywords transient and volatile removed. The public keyword is also removed, as the fields are always public."

Inherited::usage =
"Inherited is an option to Methods and Fields (in J/Link) and NETTypeInfo (in .NET/Link). The default, Inherited->True, means include information about members inherited from superclasses."

(******** From JavaBlock.m ********)

JavaBlock::usage =
"JavaBlock[expr] causes all new Java objects returned to Mathematica during the evaluation of expr to be released when expr finishes. It is an error to refer to such an object after JavaBlock ends. See the usage message for ReleaseJavaObject for more information. JavaBlock only affects new objects, not additional references to ones that have previously been seen. If a JavaBlock returns a single JavaObject as a result, that object will not be released. JavaBlock is a way to mark a set of objects as temporary so they can be automatically cleaned up when the block of code ends."

BeginJavaBlock::usage =
"BeginJavaBlock[] and EndJavaBlock[] are equivalent to the JavaBlock function, except that they work across a larger span than the evaluation of a single expression. Every BeginJavaBlock[] must have a paired EndJavaBlock[]."

EndJavaBlock::usage =
"BeginJavaBlock[] and EndJavaBlock[] are equivalent to the JavaBlock function, except that they work across a larger span than the evaluation of a single expression. Every BeginJavaBlock[] must have a paired EndJavaBlock[]."

KeepObjects::usage =
"KeepObjects is a deprecated option to JavaBlock. Use the KeepJavaObject function instead."

KeepJavaObject::usage =
"KeepJavaObject[object] causes the specified object(s) not to be released when the current JavaBlock ends. KeepJavaObject allows an object to \"escape\" from the current JavaBlock, and it only has an effect if the object was in fact slated to be released by the current block. The object is promoted to the \"release\" list of the next-enclosing JavaBlock, if there is one, so it will be released when that block ends (unless you call KeepJavaObject again in the outer block). KeepJavaObject[object, Manual] causes the specified object to escape from all enclosing JavaBlocks, meaning that the object will only be released if you manually call ReleaseJavaObject."

ReleaseObject::usage =
"ReleaseObject is deprecated. The new name is ReleaseJavaObject."

ReleaseJavaObject::usage =
"ReleaseJavaObject[javaobject] tells the Java memory-management system to forget about any references to the specified JavaObject that are being maintained solely for the sake of Mathematica. The JavaObject in Mathematica is no longer valid after the call. You call ReleaseJavaObject when you are completely finished with an object in Mathematica, and you want to allow it to be garbage-collected in Java."

(******** From MakeJavaObject.m ********)

MakeJavaObject::usage =
"MakeJavaObject[expr] constructs a new Java object whose \"value\" is expr. The expression must be an integer (in which case the created object is of type java.lang.Integer), real (java.lang.Double), String (java.lang.String), or True/False (java.lang.Boolean). It can also be a list or matrix of numbers, Strings, or True/False, in which case the returned object is a Java array of the corresponding primitive type (for example, MakeJavaObject[{1,2,3}] would create an int[] with these values). MakeJavaObject is a shorthand for calling JavaNew. It is typically used when you need to call a Java method that is typed to take Object, and you want to pass it a numeric, String, or array value. You use MakeJavaObject to manually convert such arguments into Java objects before passing them to the method."

MakeJavaExpr::usage =
"MakeJavaExpr[expr] constructs a new Java object of the J/Link Expr class that represents the Mathematica expression expr."

(******** From Sharing.m ********)

ShareKernel::usage =
"ShareKernel[] initiates sharing of the kernel between the front end and a link to another program such as Java or .NET. You typically call ShareKernel to allow the kernel to respond to Java- or .NET-based user interfaces. For backwards compatibility, calling ShareKernel[] with no arguments initiates sharing with the Java link, but new code should specify the intended link, either by calling ShareKernel[JavaLink[]] or ShareKernel[NETLink[]]. If the specified link is already sharing the kernel, ShareKernel does nothing. ShareKernel returns a token that you should save and later pass to UnshareKernel to unregister the request for kernel sharing. ShareKernel is unnecessary in Mathematica 5.1 and later because the kernel is always ready for computations that originate in Java or .NET, even when busy with another computation."

UnshareKernel::usage =
"UnshareKernel[token] is used to \"unregister\" an earlier call to ShareKernel that returned the given token. When all calls to ShareKernel have had a corresponding call to UnshareKernel, kernel sharing is turned off and the front end returns to its normal state of having full control of the kernel. Turning off kernel sharing also stops execution of any periodical tasks established with AddPeriodical. UnshareKernel[linkobject] turns off all sharing of the kernel with the given link, no matter how many times ShareKernel has been called for that link (this form should only be used during development, not in production code). For backwards compatibility, UnshareKernel[] is equivalent to UnshareKernel[JavaLink[]], but new code should always include the link argument."

KernelSharedQ::usage =
"KernelSharedQ[] returns True if the kernel is currently being shared among two or more links, False otherwise. KernelSharedQ[link] returns True if the kernel is currently being shared with the specified link, False otherwise."

SharingLinks::usage =
"SharingLinks[] returns a list of the links currently sharing the kernel."

SharingPrompt::usage =
"SharingPrompt is a deprecated option to ShareKernel."

AddPeriodical::usage =
"AddPeriodical[expr, interval] adds the computation expr to the set of operations that are periodically performed automatically. It returns an integer ID that can be used in RemovePeriodical. The time interval is specified in seconds, and can be less than one second, although the timing is not expected to be very precise."

RemovePeriodical::usage =
"RemovePeriodical[id] removes the computation corresponding to the integer id from the set of operations that are periodically performed automatically. The id number must be one returned by AddPeriodical or Periodicals."

Periodical::usage =
"Periodical[id] returns information about the periodical task corresponding to the specified integer id. It returns a list with the form {id, code, seconds}. The id number must be one returned by AddPeriodical or Periodicals. "

Periodicals::usage =
"Periodicals[] returns a list of integer id numbers corresponding to the set of operations that are periodically performed automatically when the kernel is not busy with another computation."

SetPeriodicalInterval::usage =
"SetPeriodicalInterval[id, interval] resets the time interval for the periodical task with the given id."

$ThisPeriodical::usage =
"$ThisPeriodical is deprecated and will not function in Mathematica 5.1 and beyond. In earlier versions of Mathematica, $ThisPeriodical is a variable that holds the id of the currently-executing periodical task. You can use $ThisPeriodical from within your periodical task to alter its time interval for future calls (by calling SetPeriodicalInterval) or to remove it entirely (with RemovePeriodical)."

ShareFrontEnd::usage =
"ShareFrontEnd[link] initiates sharing of the notebook front end with an external program such as Java or .NET. For backwards compatibility, calling ShareFrontEnd[] with no arguments initiates sharing with the Java link, but new code should specify the intended link, either by calling ShareFrontEnd[JavaLink[]] or ShareFrontEnd[NETLink[]]. If the front end is already being shared by that link, ShareFrontEnd does nothing. ShareFrontEnd returns a token that you should save and later pass to UnshareFrontEnd to unregister the request for front end sharing."

UnshareFrontEnd::usage =
"UnshareFrontEnd[token] is used to \"unregister\" an earlier call to ShareFrontEnd that returned the given token. When all calls to ShareFrontEnd have had a corresponding call to UnshareFrontEnd, front end sharing is turned off. UnshareFrontEnd[linkobject] turns off sharing of the front end with the given link. For backwards compatibility, calling UnshareFrontEnd[] with no arguments turns off sharing with the Java link (thus it is equivalent to UnshareFrontEnd[JavaLink[]]), but programmers should always use UnshareFrontEnd[token], passing the token returned from a previous call to ShareFrontEnd."

FrontEndSharedQ::usage =
"FrontEndSharedQ[link] returns True if the front end is being shared with specified link, False otherwise. For backwards compatibility, calling FrontEndSharedQ[] with no arguments defaults to the Java link (thus it is equivalent to FrontEndSharedQ[JavaLink[]])."

(******** From Misc.m ********)

JavaShow::usage =
"JavaShow[windowObj] causes the specified Java window to be brought to the foreground, so that it appears in front of notebook windows. Use this function in place of standard Java window methods like setVisible (or its deprecated equivalent, show) and toFront. The effects those methods have are unfortunately not identical on different Java virtual machines and operating systems. JavaShow performs the required steps in VM-specific ways, so programs that use it will work identically on different configurations. The argument must be an object of a class that can represent a top-level window (i.e., an instance of the java.awt.Window class or a subclass)."

DoModal::usage =
"DoModal[] does not return until the Java side sends an expression of the form EvaluatePacket[EndModal[___]]. Use DoModal to have a program wait until some Java user-interface action signals that it can proceed. Typically, this would be used to implement a modal dialog box that needs to return a result to Mathematica when it is dismissed. DoModal returns the EndModal[args] expression."

EndModal::usage =
"EndModal is the head of an expression sent by Java to signal the end of a DoModal[] loop."

ServiceJava::usage =
"ServiceJava[] allows a single computation originating from Java to proceed. ServiceJava joins DoModal and ShareKernel as the means to allow computations to proceed that originate from Java. \"Originate\" from Java means that the call to Mathematica is in response to a user action in Java (like pressing a button), as opposed to a callback into Mathematica from a call to Java that originated from Mathematica. Use ServiceJava when you want a running Mathematica program to periodically allow computations from the Java user interface. ServiceJava, like ShareKernel, is unnecessary in Mathematica 5.1 and later because the kernel is always ready for computations that originate in Java, even when busy with another computation."

AppletViewer::usage =
"AppletViewer[class, params] displays a window with an applet of the named class running in it. The class can be given as a string or a JavaClass expression. The params argument is a list of strings, each specifying a name=value pair supplying applet properties that would normally appear in an HTML file in <PARAM> tags or other applet attributes (like WIDTH and HEIGHT attributes). A typical specification might be {\"WIDTH=400\", \"HEIGHT=400\"}."

PeekClasses::usage =
"PeekClasses[] returns a list of the classes currently loaded into Java by Mathematica. It is intended to be used only as a debugging aid."

PeekObjects::usage =
"PeekObjects[] returns a list of the Java objects that have been sent to Mathematica (and not yet released with ReleaseJavaObject). It is intended to be used only as a debugging aid."

SetInternetProxy::usage =
"SetInternetProxy[\"host\", port] sets proxy information in your Java session for accessing the Internet. If you use a proxy for accessing the Internet, you may need to call this function to enable Java code to use the Internet. Consult your network administrator for proxy settings. A typical example would look like SetInternetProxy[\"proxy.mycompany.com\", 8080]."

ShowJavaConsole::usage =
"ShowJavaConsole[] displays the Java console window and begins capturing output sent to the Java System.out and System.err streams. Anything written to these streams before ShowJavaConsole is first called will not appear, but subsequent output will be captured even if the window is closed and reopened. Only the most recent one thousand lines of output are displayed. ShowJavaConsole[\"stdout\"] captures only System.out, and ShowJavaConsole[\"stderr\"] captures only System.err."

JavaGC::usage =
"JavaGC[] requests the Java garbage collector to be run. It returns the number of bytes freed. JavaGC invokes the Java method Runtime.getRuntime().gc()."

InstanceOf::usage =
"InstanceOf[javaobject, javaclass] gives True if javaobject is an instance of the class or interface javaclass, or a subclass. Otherwise, it returns False. It mimics the behavior of the Java language's instanceof operator. The javaclass argument can be either the fully-qualified class name as a string, or a JavaClass expression."

SameObjectQ::usage =
"SameObjectQ[javaobject1, javaobject2] returns True if and only if the JavaObject expressions javaobject1 and javaobject2 refer to the same Java object. In other words, it behaves like the Java language's == operator as applied to object references."

JavaThrow::usage =
"JavaThrow[\"exceptionClassName\", \"detailMsg\"] causes the specified exception to be thrown in the Java thread that called the Mathematica program in which JavaThrow occurred. You can also call JavaThrow with an Exception object created by a call to JavaNew, instead of a string giving the name of the exception class. If you use the string form, the second argument is an optional detail message for the exception. It is up to the user to ensure that the exception being created has an appropriate constructor. JavaThrow is a specialized function that few programmers will have any use for."

GetClassPath::usage =
"GetClassPath[] is deprecated. Use JavaClassPath[] instead."

JavaClassPath::usage =
"JavaClassPath[] returns the class search path in use by the Java runtime. This includes classes specified via the CLASSPATH environment variable (if any), directories and files added by the user with AddToClassPath, and those directories automatically searched by J/Link. The result is a list of strings specifying directories and .jar or .zip files, in the same order that they will be searched for classes by the Java runtime."

AddToClassPath::usage =
"AddToClassPath[\"location1\", \"location2\", ...] adds the specified full paths to directories and jar or zip files to the J/Link class search path. If you specify a directory, it will be searched automatically for .jar and .zip files, in addition to appropriately nested .class files, so you do not have to name .jar or .zip files explicitly. Changes take effect immediately and apply only to the currently-running Java runtime. If you quit and restart Java, you will need to call AddToClassPath again."

$ExtraClassPath::usage =
"$ExtraClassPath is deprecated. Use the function AddToClassPath instead."

SetComplexClass::usage =
"SetComplexClass[\"classname\"] specifies the Java class to use for complex numbers sent from, and returned to, Mathematica."

GetComplexClass::usage =
"GetComplexClass[] returns the Java class used for complex numbers sent from, and returned to, Mathematica."

ParentClass::usage =
"ParentClass[javaclass] returns the JavaClass expression representing the parent class of javaclass. You can also specify an object of a class, as in ParentClass[javaobject]."

ClassName::usage =
"ClassName[javaclass] returns, as a string, the fully-qualified name of the Java class represented by javaclass. You can also specify an object of the class, as in ClassName[javaobject]."

GetClass::usage =
"GetClass[javaobject] returns the JavaClass that identifies the object's class."

ImplementJavaInterface::usage =
"ImplementJavaInterface[interfaces, handlerMappings] uses the Dynamic Proxy facility of Java to create a new Java class and return an object of that class that implements the named interface or list of interfaces by calling back into Mathematica. In short, it lets you create a Java object that implements a given Java interface entirely in Mathematica code. The handlerMappings argument is a list of rules that specify the name of the Java method and the name of the method that will be called in Mathematica to implement the body of that method, as in \"intfMeth1\"->\"mathHandlerMethod1\". The arguments passed to the Mathematica method will be exactly the arguments originally passed to the Java method."

JavaWindowToFront::usage =
"JavaWindowToFront is an internal symbol."

(******** From ArgumentTests.m ********)

AllowRaggedArrays::usage =
"AllowRaggedArrays[True] lets you pass ragged (i.e., non-rectangular) arrays to Java. For example, a method that takes int[][] could be passed {{1,2},{3}}. AllowRaggedArrays[True] can drastically reduce the speed with which large arrays are passed back and forth between Mathematica and Java. Call AllowRaggedArrays[False] to restore the default behavior."

$RelaxedTypeChecking::usage =
"$RelaxedTypeChecking is a flag that can be set to True to speed up the validation performed in Mathematica (via pattern tests) on arrays of data being sent as arguments to Java calls. For a very large matrix, it can be expensive to test that it is, say, a rectangular matrix of integers before it is sent to Java. The speed is gained by making the tests much less strict, so you must make sure that you pass methods exactly the arguments they expect. The default value is False. You can set and reset the value whenever you want; a typical use would be Block[{$RelaxedTypeChecking = True}, callToJava[largeMatrix]]."

(******** From EvaluateTo.m ********)

(* No usage messages for these is deliberate. These are not called from an interactive session, only from *)
(*  Java code in a Java front end. *)
EvaluateToImage
EvaluateToTypeset
$DefaultImageFormat
ConvertToCellExpression

(******** From FrontEndServer.m ********)

(* Usage messages for these are a bit superfluous, as they will typically be called from a MathLink or J/Link program, *)
(* not an interactive Mathematica session. *)

(* Prevent shadow warning from Developer`UseFrontEnd and Developer`ForceLaunch if user has previously done <<Developer` *)
`FrontEndServer`Private`wasOn = Head[General::shdw] =!= $Off
Off[General::shdw]

UseFrontEnd::usage = 
"UseFrontEnd[expr] evaluates expr in an environment where the kernel can make use of the services of the notebook front end. The most important such service is producing images involving typeset expressions. The front end will be launched if required. This function will typically be called only from an external program that is driving the kernel, not from code executing in a front end notebook."

ForceLaunch::usage =
"ForceLaunch is an option to ConnectToFrontEnd that forces a new instance of the front end to be launched as opposed to sharing a currently-running instance. The default is False. It is currently only supported on Windows (on other platforms a new instance is always launched)."

If[`FrontEndServer`Private`wasOn, On[General::shdw]]

CloseFrontEnd::usage = 
"CloseFrontEnd[] closes the link to the front end that was opened by UseFrontEnd[] or ConnectToFrontEnd[]. After using either of those functions, you should ensure that CloseFrontEnd[] is called before you quit the kernel."

ConnectToFrontEnd::usage = 
"ConnectToFrontEnd[] establishes a link to the notebook front end for use by the UseFrontEnd[] function. It returns True to indicate that the link was established correctly, and False otherwise. The front end will be launched if required. Although UseFrontEnd will call ConnectToFrontEnd if necessary, ConnectToFrontEnd is provided to allow programmers to conveniently control when the front end is launched and to receive a True/False indication if it was successful. This function will typically be called only from an external program that is driving the kernel, not from code executing in a front end notebook."

FrontEndLink::usage = 
"FrontEndLink[] returns the link to the front end that will be used by UseFrontEnd[]. It will be Null if no link to the front end has been established."

$FrontEndLaunchCommand::usage = 
"$FrontEndLaunchCommand specifies the command line that will be used by ConnectToFrontEnd[] to launch the front end. You can modify its value if you have some application-specific needs."

$FrontEndInitializationFunction::usage = 
"$FrontEndInitializationFunction is a function that you can assign to execute when the front end link is first established by ConnectToFrontEnd[]. Your function will be passed the link to the front end, and it should return False to indicate that your initialization was not successful and the front end connection should be abandoned. Any other return value will allow the front end connection to proceed normally."



(***********************************  End of Public J/Link API  *************************************)


(********************************  Package-Visiblity Declarations  **********************************)

(* These functions are not public, and not intended for users to call. *)

Begin["`Package`"]

(******** From Debug.m ********)

$Debug
$DebugLevel
$DebugExceptions
$DebugDups
$DebugCommandLine
DebugPrint
Assert
AssertAction
$AssertAction
Verify
VerifyAction
$VerifyAction
Trigger

(******** From InstallJava.m ********)

autoClassPath

$inPreemptiveCallFromJava

(* Experimental features for 6.0 *)
InstallJavaInternal
AsyncInstall

(* temporary *)
$InternalLink

(******** From CallJava.m ********)

(* Used in jlinkExternalCall to direct output to the appropriate link (JavaLink[] or JavaUILink[]). *)
getActiveJavaLink

(* These 5 are called directly from Java. *)
jlinkDefineExternal
loadClassAndCreateInstanceDefs
createInstanceDefs
loadClassFromJava
issueNoDefaultCtorMessage

(* Exported so that defs created as classes/objects are loaded can be cleared when Java is restarted. *)
clearJavaDefs
callAllUnloadClassMethods

(* Various methods for converting among class/name/index. *)
classIndexFromInstance
classNameFromIndex
classFromIndex
parentClassIndexFromClassIndex
classNameFromClass
classIndexFromClass

(******** From Java.m ********)

jCallJava
jLoadClass
jThrow
jGC
jReleaseObject
jReleaseAllObjects
jUnloadClass
jVal
jOnLoadClass
jOnUnloadClass
jSetComplex
jGetComplex
jReflect
jShow
jSameQ
jInstanceOf
jGetException
jAllowRaggedArrays
jConnectToFEServer
jDisconnectToFEServer
jPeekClasses
jPeekObjects
jClassPath
jAddToClassPath
jSetUserDir
jUIThreadWaitingQ
jAllowUIComputations
jForcePolling
jYieldTime
jGetConsole
jUILink
jGetWindowID
jAddTitleChangeListener

(******** From Exceptions.m ********)

(* All these are called only from Java *)
prepareForManualReturn
handleCleanException
autoException
manualException

(******** From JavaBlock.m ********)

addToJavaBlock
resetJavaBlock

(******** From Sharing.m ********)

myLinkReadyQ

(******** From Misc.m ********)

clearComplexClass
osIsWindows
osIsClassicMac
osIsMacOSX

isPreemptiveKernel
hasFrontEnd
hasServiceFrontEnd
hasLocalFrontEnd

registerWindow
unregisterWindow
windowID
unregisterAllWindows
windowRegisteredQ
getNextWindowID

titleChangedFunc

asyncEvaluate

contextIndependentOptions

(******** From ArgumentTests.m ********)

(* The isXXX functions are predicates used in function definitions for Java methods created during LoadJavaClass. *)


isRealList
isRealArray2
isRealArray3
isNumberList
isNumberArray2
isNumberArray3
isIntegerList
isIntegerArray2
isIntegerArray3
isString
isStringList
isStringArray2
isStringArray3
isTrueFalseList
isTrueFalseArray2
isTrueFalseArray3
isComplex
isComplexList
isComplexArray2
isComplexArray3
isObjectList
isObjectArray2
isObjectArray3
isBigInteger
isBigIntegerList
isBigIntegerArray2
isBigIntegerArray3
isBigDecimal
isBigDecimalList
isBigDecimalArray2
isBigDecimalArray3
isExprList
isExprArray2
isExprArray3
isJavaIntegerArray
isJavaRealArray
isJavaStringArray
isJavaBooleanArray
isJavaObjectArray
isJavaExprArray
isJavaComplexArray
isJavaBigDecimalArray
isJavaBigIntegerArray

$allowRaggedArrays



(* The ToFileName command below will create the full path to the JLink/Kernel directory
   regardless of how JLink.m was found, either via:
   
       <dir on $Path>/JLink/Kernel/init.m    (typical in 4.1)
       <dir on $Path>/JLink.m                (the case in 4.2 and later, where the JLink dir itself is on $Path)
       
   or if JLink.m was read in from a full pathname specification.
   
   We store this dir so we can use it below and also when InstallJava is called, to ensure that the JLink.jar
   file we use is the one right next to this JLink.m file.
*)
$jlinkDir = DirectoryName[System`Private`FindFile[$Input]]


End[]   (* Ends `Package` context *)

(* Make the Package` symbols visible to all implementation files as they are read in. *)
AppendTo[$ContextPath, "JLink`Package`"]


(********************************  Read in the Implementation Files  **********************************)

(
    Get[ToFileName[#, "Debug.m"]];
    Get[ToFileName[#, "InstallJava.m"]];
    Get[ToFileName[#, "CallJava.m"]];
    Get[ToFileName[#, "Java.m"]];
    Get[ToFileName[#, "Exceptions.m"]];
    Get[ToFileName[#, "Reflection.m"]];
    Get[ToFileName[#, "JavaBlock.m"]];
    Get[ToFileName[#, "MakeJavaObject.m"]];
    Get[ToFileName[#, "Sharing.m"]];
    Get[ToFileName[#, "Misc.m"]];
    Get[ToFileName[#, "ArgumentTests.m"]];
    Get[ToFileName[#, "EvaluateTo.m"]];
    Get[ToFileName[#, "FrontEndServer.m"]];
)& @ ToFileName[$jlinkDir, "Kernel"]


EndPackage[]
