(* :Title: Debug.m *)

(* :Author:
        Todd Gayley
        tgayley@wolfram.com
*)

(* :Package Version: 3.1 *)

(* :Mathematica Version: 4.0 *)
		     
(* :Copyright: J/Link source code (c) 1999-2005 Wolfram Research, Inc. All rights reserved.

   Use is governed by the terms of the J/Link license agreement, which can be found at
   www.wolfram.com/solutions/mathlink/jlink.
*)

(* :Discussion:
   Debugging utilities used within J/Link.
	
   This file is a component of the J/Link Mathematica source code.
   It is not a public API, and should never be loaded directly by users or programmers.

   J/Link uses a special system wherein one package context (JLink`) has its implementation
   split among a number of .m files. Each component file has its own private context, and also
   potentially introduces public symbols (in the JLink` context) and so-called "package" symbols,
   where the term "package" comes from Java terminology, referring to symbols that are visible
   everywhere within the implementation of J/Link, but not to clients. The JLink.m file itself
   is produced by an automated tool from the component files and contains only declarations.
   
   Do not modify the special comment markers that delimit Public- and Package-level exports.
*)



(*<!--Public From Debug.m

-->*)

(*<!--Package From Debug.m

$Debug
$DebugLevel
$DebugExceptions
$DebugDups
$DebugCommandLine
DebugPrint
Assert
AssertAction
$AssertAction
Verify
VerifyAction
$VerifyAction
Trigger

-->*)


(* Current context will be JLink`. *)

Begin["`Debug`Private`"]

$Debug = False
$DebugLevel = 0
$DebugExceptions = False
$DebugDups = False
If[!ValueQ[$DebugCommandLine], $DebugCommandLine = False]
SetAttributes[DebugPrint, HoldAll]
DebugPrint[e__, Trigger :> tst_] := Print[e] /; ($Debug && tst)
DebugPrint[e__, Trigger :> tst_] = Null
DebugPrint[lev_Integer, e__] := Print[e] /; ($Debug && $DebugLevel >= lev)
DebugPrint[lev_Integer, e__] = Null
DebugPrint[e__] := Print[e] /; $Debug
DebugPrint[e__] = Null
SetAttributes[Assert, HoldAll]
Options[Assert] = {AssertAction :> $AssertAction}
Assert[exprs__, action___?OptionQ] :=
	StackInhibit[
		Scan[Function[e, If[e =!= True, (AssertAction /. {action} /. Options[Assert])[e]], HoldAll], Hold[exprs]]
	] /; $Debug
Assert[___] = Null
$AssertAction = Function[e, Print["Assertion failed: ", HoldForm[e]]; (* Dialog[] *), HoldAll]
SetAttributes[Verify, HoldAll]
Options[Verify] = {VerifyAction :> $VerifyAction}
Verify[expr_, test_, action___?OptionQ] :=
	StackInhibit[
		(If[test[#] =!= True, (VerifyAction /. {action} /. Options[Verify])[expr, test]]; #)& [expr]
	] /; $Debug
Verify[expr_, __] := expr
$VerifyAction = Function[{e, t},
					   Print["Verify failed. Test was: ", t, "\nExpression was: ", HoldForm[e]]; Dialog[],
					   HoldAll
			   ]

End[]
