(* :Title: Java.m *)

(* :Author:
        Todd Gayley
        tgayley@wolfram.com
*)

(* :Package Version: 3.1 *)

(* :Mathematica Version: 4.0 *)
		     
(* :Copyright: J/Link source code (c) 1999-2005, Wolfram Research, Inc. All rights reserved.

   Use is governed by the terms of the J/Link license agreement, which can be found at
   www.wolfram.com/solutions/mathlink/jlink.
*)

(* :Discussion:
   Declarations of all the "j functions", which are the special calls into Java defined in
   Install.java. These must be declared in the `Package` context, but their defs are
   embedded in Install.java. Any new j functions added to Install.java must also be named here.
	
   This file is a component of the J/Link Mathematica source code.
   It is not a public API, and should never be loaded directly by users or programmers.

   J/Link uses a special system wherein one package context (JLink`) has its implementation
   split among a number of .m files. Each component file has its own private context, and also
   potentially introduces public symbols (in the JLink` context) and so-called "package" symbols,
   where the term "package" comes from Java terminology, referring to symbols that are visible
   everywhere within the implementation of J/Link, but not to clients. The JLink.m file itself
   is produced by an automated tool from the component files and contains only declarations.
   
   Do not modify the special comment markers that delimit Public- and Package-level exports.
*)



(*<!--Public From Java.m

-->*)

(*<!--Package From Java.m

jCallJava
jLoadClass
jThrow
jGC
jReleaseObject
jReleaseAllObjects
jUnloadClass
jVal
jOnLoadClass
jOnUnloadClass
jSetComplex
jGetComplex
jReflect
jShow
jSameQ
jInstanceOf
jGetException
jAllowRaggedArrays
jConnectToFEServer
jDisconnectToFEServer
jPeekClasses
jPeekObjects
jClassPath
jAddToClassPath
jSetUserDir
jUIThreadWaitingQ
jAllowUIComputations
jForcePolling
jYieldTime
jGetConsole
jUILink
jGetWindowID
jAddTitleChangeListener

-->*)
