//////////////////////////////////////////////////////////////////////////////////////
//
//   J/Link source code (c) 1999-2002, Wolfram Research, Inc. All rights reserved.
//
//   Use is governed by the terms of the J/Link license agreement, which can be found at
//   www.wolfram.com/solutions/mathlink/jlink.
//
//   Author: Todd Gayley
//
//////////////////////////////////////////////////////////////////////////////////////

package com.wolfram.jlink;

import java.io.FileDescriptor;
import java.net.InetAddress;
import java.security.Permission;


/**
 * This is a security manager that prevents code called from Mathematica from calling System.exit().
 * This manager makes no attempt to be "secure". For example, it does not prevent code from
 * installing a different security manager. Its only purpose is to prevent "accidental" calls to System.exit(),
 * which sometimes appear in code that people want to call using J/Link (for example, in main() functions).
 */
public class JLinkSecurityManager extends SecurityManager {

	// Singleton pattern.
	
	private static final JLinkSecurityManager instance = new JLinkSecurityManager();
	
	private static boolean allowExit = false;
	
	
	private JLinkSecurityManager() {}
	
	public static JLinkSecurityManager getInstance() {
		return instance;
	}
	
	public static void setAllowExit(boolean allow) {
		allowExit = allow;
	}
	
	////////////////////////  SecurityManager method overrides  ////////////////////////
	
	public void checkExit(int status) {
		if (!allowExit)
			throw new SecurityException("J/Link does not allow code called from Mathematica to call System.exit().");
	}

	// Allow all other operations
	public void checkCreateClassLoader() { } 
	public void checkAccess(Thread g) { }
	public void checkAccess(ThreadGroup g) { }
	public void checkExec(String cmd) { }
	public void checkRead(FileDescriptor fd) { }
	public void checkRead(String file) { }
	public void checkRead(String file, Object context) { }
	public void checkWrite(FileDescriptor fd) { }
	public void checkWrite(String file) { }
	public void checkDelete(String file) { }
	public void checkConnect(String host, int port) { }
	public void checkConnect(String host, int port, Object context) { }
	public void checkListen(int port) { }
	public void checkLink(String lib) { }
	public void checkAccept(String host, int port) { }
	public void checkMulticast(InetAddress maddr) { }
	public void checkMulticast(InetAddress maddr, byte ttl) { }
	public void checkPropertiesAccess() { }
	public void checkPropertyAccess(String key) { }
	public void checkPropertyAccess(String key, String def) { }
	public boolean checkTopLevelWindow(Object window) { return true; }
	public void checkPrintJobAccess() { }
	public void checkSystemClipboardAccess() { }
	public void checkAwtEventQueueAccess() { }
	public void checkPackageAccess(String pkg) { }
	public void checkPackageDefinition(String pkg) { }
	public void checkSetFactory() { }
	public void checkMemberAccess(Class clazz, int which) { }
	public void checkSecurityAccess(String provider) { }
	public void checkPermission(Permission perm) { }
	public void checkPermission(Permission perm, Object context) { }

}	
