(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    213400,       3507]*)
(*NotebookOutlinePosition[    375731,       9191]*)
(*  CellTagsIndexPosition[    375548,       9182]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Last Slide"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                CounterBox["SlideShowNavigationBar", "LastSlide"]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  Magnification->1],

Cell[CellGroupData[{

Cell[TextData[{
  "Quick introduction to building user interfaces with ",
  StyleBox["GUIKit",
    FontSlant->"Italic"]
}], "Chapter"],

Cell[TextData[{
  "This tutorial provides an introduction to constructing graphical user \
interfaces with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". "
}], "Text",
  ShowCellBracket->False,
  CellMargins->{{80, 80}, {6, 6}},
  LineSpacing->{1, 3},
  FontSize->14,
  Magnification->1],

Cell[TextData[{
  "You can change the examples in any of the slides and re-evaluate them in \
place. Normally changes you make will not be saved. To save them, explicitly \
use ",
  StyleBox["Save As...", "SR"],
  " in the ",
  StyleBox["File", "SR"],
  " menu."
}], "Text",
  ShowCellBracket->False,
  CellMargins->{{80, 80}, {6, 6}},
  LineSpacing->{1, 3},
  FontSize->14,
  Magnification->1],

Cell["\<\
The top of each slide has a toolbar with buttons to navigate between \
slides.\
\>", "Text",
  ShowCellBracket->False,
  CellMargins->{{80, 80}, {6, 6}},
  LineSpacing->{1, 3},
  FontSize->14,
  Magnification->1],

Cell[BoxData[GridBox[{
        {" ", 
          ButtonBox[Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001U000062000`400?l00000o`00003oI@3NLcT0
06D0gW<i00020=ic>F40ooo>0P3NLcT00080gW<iH@3oolh20=ic>@000P3NLcTQ0?oocP030;noVP3O
gk@0ooo>03d0ooo>0P3NLcT00080gW<i7`3oolh01@2OWh00410=000000000000P81W03d0ooo>0P3N
LcT00080gW<i7P3oolh01`3Ogk@00000030`9`2o_iX0H61>0000003Ogk@0?03oolh20=ic>@000P3N
LcTJ0?oocP050=oO]02o_iX0ooo>0?oocP3_kl400P2o_iX0103?cjL0_knJ0000002OWh0E0?oocP80
gmnd2@3oolh00`3?cjL0gmnd0?oocP0;0?oocP030>o_`@2o_iX0ooo>00/0ooo>0P3NLcT00080gW<i
1`3oolh00`3kkK/0ooo>0?oocP070?oocP060;noVP000000000000000010@3@0clnW0P3oolh01`1@
D44000000000000P81X0clnW0?oocP1`L5X00P0000002@0`<2L000000820I`3oolh000000410=03o
olh0@40d000000020?oocP0300000010@3@0ooo>00D0ooo>00D000000410=03oolh0gmnd020P6P02
00000009020P6P3Ogk@0ooo>0820I`000000_knJ0?oocP3?cjL0820J0080000000D0@40d0>o_`@2o
_iX000000820I`020?oocP0=0;noVP000000P81W0?oocP3?cjL0410=0000000P81X000000410=03o
olh000000410=0060?oocP80gW<i00020=ic>@L0ooo>00<0ggPn0?;7TP3oolh01`3oolh0102o_iX0
00000410=020P6L2010@3@0D0?oocP2?Sg@0000009nOP03_kl40<30W0820I`3Ogk@00000030`9`2o
_iX0H61>00000020P6L0ooo>00000010@3@0ooo>0410=00000020?oocP0300000010@3@0ooo>00D0
ooo>00D000000410=03oolh0L71J0000000208n?M00@0000001`L5X0ooo>0820I`000000_knJ0?oo
cP0P81X0410=0:n_S@2?Sg@00000061PCP2o_iX000000820I`80ooo>00d0_knJ00000020P6L0ooo>
020P6P0@40d0[jn=08n?M0000000@40d0?oocP000000@40d00H0ooo>0P3NLcT00080gW<i1`3oolh2
0=ic>@030>NIHP3ll/40ooo>00D0ooo>00T0_knJ00000020P6L0ooo>0820I`000000clnW051@@@00
00000`2o_iX03P3?cjL0Shmd0000002_[hd0ooo>0>o_`@000000P81W0?oocP000000@40d0?oocP10
@3@000000P3oolh00`000000@40d0?oocP050?oocP0500000010@3@0ooo>0410=00000000P3oolh0
2@000000@40d0?oocP20P6L000000;noVP3Ogk@00000071`FP020?oocP05030`9`0P81X0_knJ0000
0020P6L00P3oolh01P2o_iX000000820I`3?cjL00000071`FP80ooo>00D0<30W0410=03oolh00000
0410=0060?oocP80gW<i00020=ic>@L0ooo>0`3NLcT00`3PNd40m=6N0?oocP040?oocP090;noVP00
0000P81W0>o_`@1@D44000000=oO]01@D44000000080@40d00l0410=0410=02?Sg@000000:n_S@3o
olh0kno100000020P6L0ooo>00000010@3@0ooo>0410=00000000P3oolh00`000000@40d0?oocP05
0?oocP0500000010@3@0ooo>0410=00000000P3oolh02@000000@40d0?oocP20P6L000000;noVP3O
gk@00000071`FP020?oocP05030`9`0P81X0_knJ00000020P6L00P3oolh01P2o_iX000000820I`3?
cjL00000071`FP80ooo>00D0<30W0410=03oolh000000410=0060?oocP80gW<i00020=ic>@L0ooo>
103NLcT00`3RQD`0nnfk0?oocP030?oocP0N0;noVP00000000000000000@40d0Win00?oocP2OWh00
000009nOP03_kl4000000820I`3Ogk@00000030`9`2o_iX0D51100000020P6L0ooo>00000010@3@0
ooo>0410=0000000_knJ0<o?Y`000000D5111P3oolh01@000000@40d0?oocP10@3@000000080ooo>
01l000000410=03oolh0@40d0000001PH4h0gmnd020P6P0@40d0[jn=08n?M0000000H61>0;noVP00
0000410=0:n_S@3?cjL0_knJ00000020P6L0ooo>020P6P0@40d0[jn=08n?M0000000@40d0?oocP00
0000@40d00H0ooo>0P3NLcT00080gW<i1`3oolh30=ic>@030>^[M@3nn/T0ooo>00@0ooo>00H0_knJ
0000001PH4h0H61>0000003?cjL20?oocP07051@@@0000000000030`9`3_kl40ooo>09nOP0020000
000=030`9`000000P81W0?oocP000000@40d0?oocP10@3@00000020P6P000000410=0;noVP060?oo
cP0500000010@3@0ooo>0410=00000000P3oolh00`000000@40d0?oocP03000000030;noVP3?cjL0
820J0080000001@0@40d0>o_`@2o_iX00000030`9`000000L71J0;noVP000000P81W0?oocP2o_iX0
410=0000000P81X000000410=03oolh000000410=0H0ooo>0P3NLcT00080gW<i1`3oolh00`3NLcT0
hH160?KIY@070?oocP060;noVP000000P81W0;noVP000000P81W0`3oolh20<o?Y`@0ooo>00<0gmnd
0<o?Y`3oolh02@3oolh00`2o_iX0kno10?oocP060?oocP0300000010@3@0ooo>00L0ooo>00<0P81W
0000002o_iX00`3oolh00`3?cjL0gmnd0?oocP040?oocP80gmnd1@3oolh00`3_kl40_knJ0?oocP03
0?oocP0300000010@3@0ooo>00D0ooo>0P3NLcT00080gW<i1`3oolh00`3YXFT0oOO60?oocP070?oo
cP060;noVP000000@40d030`9`000000clnW3P3oolh00`3_kl40D51109nOP00;0?oocP0609nOP020
P6L00000020P6P20P6L0_knJ1P3oolh00`20P6L000000;noVP0<0?oocP030<o?Y`10@3@0clnW00P0
ooo>00<000000410=03oolh01@3oolh20=ic>@000P3NLcTA0?oocP050;noVP0000000000020P6P20
P6L03`3oolh00`3?cjL00000051@@@0;0?oocP030410=000000000000080000000<0P81W0?oocP3o
olh04`3oolh00`2?Sg@0000008n?M0080?oocP0300000010@3@0ooo>00D0ooo>0P3NLcT00080gW<i
9P3oolh00`3?cjL0kno10?oocP0V0?oocP030;noVP3oolh0ooo>00L0ooo>00<000000410=03oolh0
1@3oolh20=ic>@000P3NLcUI0?oocP030;noVP3?cjL0ooo>00D0ooo>0P3NLcT00080gW<iH@3oolh2
0=ic>@000P3NLcUQ0?oocP80gW<i00020=ic>F40ooo>0P3NLcT006D0gW<i001U0=ic>@00\
\>"], "Text",
              CellMargins->{{Inherited, 50}, {Inherited, Inherited}},
              Evaluatable->False,
              TextAlignment->Right,
              ImageSize->{101, 24},
              ImageMargins->{{0, 0}, {0, 0}},
              ImageRegion->{{0, 1}, {0, 1}}],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            Active->True,
            ButtonStyle->"Hyperlink",
            ButtonMargins->0,
            ButtonFrame->"None"]}
        },
      GridFrame->False,
      ColumnsEqual->True]], "Text",
  ShowCellBracket->False,
  CellMargins->{{Inherited, 90}, {Inherited, Inherited}},
  TextAlignment->Right,
  Magnification->1,
  GridBoxOptions->{ColumnAlignments->{Right},
  GridFrame->True}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000=B0000Lb000`400?l00000o`00003ooooooooo
ooooooooooooEOooool00?oooooooooooooooooooeGooooo003ooooooooooooooooooomEooooo`00
ooooooooooooooooooooEOooool0037oooon00SoooohoooonOoooo_oooonoooonooooocoooomoooo
o1Coooon00Wooooloooonoooookoooohoooon_ooonooooo^ooooloooooP05?ooooh00ooooogooook
oooooP02oooon`07ooooo?ooonooooojooooo_oooogoooojoooon`0BoooooP03oooon_oooogoooon
02Goooon00?oooojoooooOooooh04?ooooh00ooooo[ooookoooooP02ooooo006ooool?ooooKoooon
ooooo_oooo[oooom4_ooooh02?oooo_ooooboooonoooooCoooogoooolOooon_ooooe0ooooo/Coooo
oP0;oooonoooooWoooo`ooooo?ooooKooooZoooom?ooooKooookoooon?oooo/00_oooo`>oooooP05
oooooOooooCoooohoooonOoooo000_ooooD01oooon_ooooVoooojoooooCoooojoooomoooooP04Ooo
ooh02Ooooo[oooomooooo_oooocooooiooool_ooon_oooodoooom`02oooon`03oooon_ooookoooon
01Goooon00Coooomooooo_oooo[oooom5_ooooh01?oooo[oooonooooo?oooo/LoooooP03oooonooo
ookoooon0?ooooonIoooooiDooooo`00<Oooooh02?ooooSooooioooonoooookooookooooo?oooogo
oool5?ooooh02Ooooocooookooooo_ooooSoooojooookoooonkoooocoooon00DoooooP03oooooOoo
oo_oooon00;ooook00Ooooolooookooooo[oooonoooooOoooo[ooook01;oooon00?oooomooooo_oo
ooh07_ooooh00ooooocoooomoooooP02oooooP04ooooo?oooogooookoooooA7oooon00?oooojoooo
noooooh00_oooo`01_ooonkoooofooooo_ooookoooojoooooA;oooon00Sooookooool_oooo_ooood
oooomooooo7oooo[oooom@;ooooj00?ooookooooo_ooooh04Oooooh02ooooo_ooooiooookooooo_o
oooeoooojOooooCoooogoooonoooooOooooj00;ooool3oooooh01?ooooGoooohoooonOoooo02oooo
m@07oooojoooonKoooo[oooomOoooo[oooogoooon00AoooooP09oooon_oooogoooonooooo?ooooWo
oooboooojoooooCoooog00;ooook00?oooojooooo_ooooh05Oooooh01?oooo_oooomoooonooooodF
oooooP04oooon_ooookooooloooonacoooon00?ooookooooo_ooooh0ooooooiXoooooU?ooooo000a
oooooP08oooon?ooooWooookooooo_oooo_ooooloooooOoooo`DoooooP03ooooo?oooo_oooon00;o
oooi00Coooo]ooook_oooo?ooooh5?ooooh03?oooogooookooooo_oooo_oooojooooo?ooonoooooj
ooooo_oooogoooojoooonc?oooon00?ooookooooo?ooooh00_ooooh01?oooo_ooooloooon?oooodA
oooooP;ooooj0_ooooh00ooooogoooo`oooom`02oooooP03oooon_oooogoooon017oooon00_ooook
ooool_oooo_oooodoooomooooo7oooo[oooomOooooSooooioooon`0CoooooP;ooooi00Woooo^oooo
n_oooo?ooooYoooom?ooooSooooloooomoooooX00_oooo`?oooooP0=oooomOooooSoooojooookooo
oo3ooooeoooojoooonKoooo[oooomOoooo[oooogoooon00AoooooP09oooon_oooogoooonooooo?oo
ooWooooboooojoooooCoooog00;ooook00?oooojooooo_ooooh05Oooooh01_oooo[oooomoooonooo
oogoooonoooooACoooon00Coooojooooo_oooocooook7?ooooh00ooooogoooonoooooP3ooooooVSo
ooonDoooool0037oookl00SoooSfoooimooonoWoookloooknOooo?[ooogkooolnQCoookl00Wooocj
oooknOooo_coooWgooofm?ookN_oonk/oooclOoonoT05?ooo_`03?oooO_ooo_iooono?oonoWooocj
ooomnoool_3ooo[hooono?oooO_ooo[hoooknC?oookl00?oooSfoooknOooo_`00_ooo_`01?oonoWo
oocjooogmOoooO/Aooono007ooojn?oon?Koooklooono?oooO_ooo3^ooogm@02ooono003ooojn?oo
oO_oookl017oookl00_ooo_iooobl?oonoWoooCbooogmOoolNooon_YoooelooomoGoooWgoookn@0C
ooono00;ooogmOoonOOoonk/ooojn?oolo7oonWWooodl_oon?KooocjooogmOoon_P00_ooo?X?ooon
o003oooelooon?Kooo[h00;oono]00Sooo3^oooZj?ooinGoon_Yoooelooon_SoooOeooohmQ7oookl
00Wooo[hooomnoooo_cooocjoooimoool_3oon_Yooodl_oomoD00_oonoT00ooon_Soooklooono00E
ooono004ooojn?oooO_ooo_iooomn`;ooocj5?ooo_`01?oon_Soookloooln_oonoWoooono4koookl
>?ooo_djoooooQ[ooooo000aooonn`08ooohmOoonOKooo_hooonnooonoSooociooomn_ooo?TDooon
n`09ooolnOoonoSoookkoooim_oomO;ooo3]ooo^jooolNkooo[g01Coookk00cooogjoookn?ooo__o
oo[gooomn_ooo__oooKcooojmoooo__ooogjooojmooonoPcooonn`03ooogm?oon_Ooookk00;oookk
00Cooo_hooolnOoomoCooogj4Oooo_/02ooon_OoooSeooolnOooo__ooociooo^jooom_?ooogjooon
nooon_Oooogj01;oookk00_ooo_hooobkooonoSoooCaooogm?oolNkoon_Xoooel_oon?GoooWfoook
n00Cooonn`0;ooogm?oonOKoonk[ooojmooolo3oonWVooodlOoon?Gooociooogm?oon_L00_ooo?T?
ooonn`05oooel_oon?Gooo[gooo_k?ook^/00_oojnP01_ooi^?oonWVoooel_oon_OoooOdooohmA7o
ookk00Wooo[gooomn_ooo__ooocioooim_ool^ooon_XooodlOoomo@00_oonoP00ooon_Ooookkooon
n`0Dooonn`07ooomn_oon_Oooocioooim_ooo__ooocioookn00Dooonn`04ooojmoooo__ooocioook
n?ooookkAOooo_/]ooono1Goookm5?ooood^oooooQ7ooooo000aooonn`08ooohmOoonOKooo_hooon
nooonoSooociooomn_ooo?TDooonn`09ooolnOoonoSoookkoookn?oomO;ooo7^ooo_k?ool>gooo[g
01Coookk00cooogjoookn?ooo__ooo[gooomn_ooo__oooOdooojmoooo__ooogjooojmooonoPaooon
n`;ooogj00WoooGboookn?ooo?WooogjooonnooonoSooociooogm?oooOX04Oooo_/03?oon_OoooSe
oookn?oooO[ooociooo/jOool^oooo[gooonnooonoSooo[gooomnQ7oookk00_ooo_hooobkooonoSo
ooCaooogm?oolNkoon_Xoooel_oon?GoooWfoookn00Cooonn`0;ooogm?oonOKoonk[ooojmooolo3o
onWVooodlOoonOKooo[gooogm?oon_L00_ooo?T?ooonn`05oooel_oon?Gooo_hoooak_ookNX00_oo
jnP01_ooi^?oonSUoooel_oon_OoooOdooohmA7oookk00Wooo[gooomn_ooo__ooocioooim_ool^oo
on_XooodlOoomo@00_oonoP00ooon_Ooookkooonn`0Dooonn`04oookn?oom_?ooociooohm@?oooci
5?ooo_/01?oon_OoookkooolnOoonoSoooonndGoookk;_ooo_`CooonoAGoooom;_oooohAooooo`00
<Oooo?T02?oom_?oooOdoooim_ooo?WoooWfooojmooonoSooo[g5?ooo?T02Ooon_OoooWfooolnOoo
n_OoooCaoooak_ookncooo3]ooohm@0Doooln@0<oookn?oon_OooociooohmOoonoSooocioooel_oo
n?Gooocioookn?oon?GoooWf<Oooo?T02ooon?Gooo_hooocl?oomoCooo;_ooojmoooo?WoooWfoooj
mooomO;ooo_h017oooci00coooSeoooflooon?GoooSeooojmoooj>GooncYooohmOooo?WoooWfoooh
mOoonoPAoooln@0;oooim_ool>goooWfooobkooom_?oono/oooYi_oom?7oooKcooohmOoon_L04ooo
o?T02ooomO;oooOdooo/jOoon?Gooo7^oooWi?ool^ooooGbooogm?oomO;oooSe00;ooo[g3oooo?T0
1Ooolo3oooKcoooim_ookncooncY00;oonSU00OoonCRoooVi?oolo3oooWfoooel_oom_?ooo_h013o
ooci00WoooSeoookn?ooo?Wooo[gooogm?ool>goonWVooobkooomO800_oonOH00ooon?Gooocioool
n@0Doooln@05ooojmooolo3ooo[goooel_oonOH00_oon_LDoooln@04ooohmOooo?Wooo[goooim_oo
ooci??ooo?TAooolnQ3ooogj7?oooO/=ooomo0koookl7?ooo_d?ooonoQ;oooon2Oooool0037oooch
00OoooKboooglooonOGooochoooimOoon_Kooo_g00;ooo[f4ooonOD2ooogl`08ooojm_oon?Cooo;^
ooo_joookNWoonkZoooelOoon_HDoooim@0;oooglooon_KoooWeoookmoooo?SoooGaooohm?ooo?So
oo_gooohm?oonOD0<Oooo?P02ooon?Cooo_gooodl?oom_;ooo7]ooojm_ooo?SoooWeoooglooomO7o
ooWe017oooch00WoooSdooofl_oon?CoooC`ooojm_ooj>GooncXooogloooo?P00_oon?@00ooon_Ko
oochoooln00:oooln003ooojm_oonOGoooWe00;oooWe00_oooKbooo^j_oomo?ooo3/ooockoookNWo
onSUoooakOoolnooooGaooogl`03oooim@03oookmoooo?Soooch00goooch00[oooGaooogloook>So
ooSdoooakOooiN;ooo3/ooockooon?CoooGa0_oon?@00ooon_Kooochoooln003oooln003ooojm_oo
nOGoooWe00OoooWe00Gooo7]ooodl?oom_;oongYooo[i`02oooVh`04oooThOooiN;ooo7]oooflP;o
oo?_00?oooKboooimOoonOD02_oonOD03OoonoOooochoooln?ooo?SoooSdoookmoooo?Sooo[fooog
loool>coonWVooobk_oomO400_oonOD00ooon?Cooochoooln006oooln003oookmooonOGoooWe00[o
ooWe00Wooo[foooglooolNgoooSdooockooom_;oooSdoooglooon_H01_oonOD00ooon_Kooochoool
n00:oooln004ooohm?ooo?Sooo[foooimOooooch>Oooo?PDoooln@Wooogi6_oooOXFooomnaSoookl
6?ooo_d:ooonoQGoooon1Oooool0037ooogg0_oon?801ooon_Cooocfooojm?oonoGooocfoookmOoo
o?H04ooonoD02OoonO?oooSboookmOoonO?oooC^ooo`j_ook^Sooo3Zooogl@0Doookm@0<ooojm?oo
nO?ooocfooojm?ooo?Koooggooofl?oonO?oooggooolm_oonO?ooo[d<OoooOL02ooon_Cooocfoooe
kooomNoooo7[ooohl_oon_CoooOaoooekooom>koooK`017ooo[d00WoooK`ooodk_oom_3ooo?]ooof
l?ooj>?ooncWooofl?oon_@00_oomo400ooonO?ooo[dooojm008oooil`;ooo[d00?oooWcooohl_oo
n?800_oon?802ooomNooonkXooofl?ool>[ooo?]ooo]j?oojNCooo7[ooobk?oom>koooK`00?oooSb
1?oonO<00oooo?Koooggooomm`09ooomm`0=ooofl?oon?;oongXoooiloooknWoonGPooo_jOoolngo
ooWcooofl?oonO?oooSboookm@05ooomm`03ooolm_oonoGooo_e00Oooo_e00_ooo?]ooodk_oom_3o
onkXooo[i_ooin;oonKQoooUh?ooin;ooo7[ooofl002oooaj`05ooodk_oon?;oooWcooohl_oonO<0
2?oonoD04?ooo?KoooggooommooooOOoooWcooolm_oooOOooo_eooohl_oolN_oon[UooockOoom_3o
oo_eooojm?oonO<5ooomm`04ooolm_oonoGooo_eooojm0goooWc00GoooOaoooajooon?;ooo?]ooof
l002ooogl@SoooWc2_oonoD2ooomm`04oooilooooOOooo_eooojm?oooogg=_oooOLKooomn0cooogi
2_ooo_TFooonnQ?oookk5Oooo_`;ooono@coooom7?ooooh2ooooo`00;Oooo_H02OoooOGooo_coook
looono?oooK^ooogkooon?3ooo_coooil@02ooojlP03oooilOooo?Cooo_c01?ooo_c00Wooo[boool
m?oon_;oooC/oooajOooknSooo3Xooogkoooo?@05?oono<00ooonO7ooo_cooohl002oookl`06oooe
kOoon?3oookfooommOoon_;ooo_c4_ooo_H00ooooOGooocdooolm00Looolm00;oooilOoono?oooC/
ooogkoooln_ooo[booolm?oon?3oooK^oooekOoomnl04Ooon_803_oom^koooC/ooogkooom>coooK^
oooYh_ookNKoooO_oooklooon?3oooO_oooilOoon_;ooo_c2?ooo?@00ooono?ooo[boookl`04oook
l`0;oooilOoolNWooo_cooodk?oomnoooo7Yooo[i?oomNgoooO_oooilOoono<00ooooOD?ooonmP0>
ooommOoom^koooWaoooajOoon_;ooo3XoooVgoool>Sooo?[ooohl?oom^koooWaooohl?oon_8;oool
m00:ooojl_oon?3oooS`ooohl?oolNWooo?[ooodk?ook^Ooon_ToooWh0;oonKO00?oonOPooo`j?oo
m>`00_ool>P01oool^[oooK^ooogkooomnooooWaoookloooo?@00ooooOD00oooo?CooogeooonmP04
ooonmP0<ooojl_oooOGoookfooolm?oonO7ooo;Zooo[i?oom>coooS`ooolm?oono?ooo[b1Oooo_H0
1?oooOGooo_coooklooono<3ooolm0Oooo_c0oooo?@01ooonO7ooo?[ooojl_oomNgoooWaooojl_oo
nO401oooo?@:oookl`07ooolm?ooo_Koookfooojl_ooo_Kooocdoookl`3oooonmSGoookf6?ooo_LE
ooonn1?oooki4Oooo_XBoooona?ooool5?oooodJoooooP7ooooo000aooonm@08ooohkooonO3ooo_b
ooomm?oono;oooccooomm?oono8Gooonm@06ooollooom^gooo;Yooocj_ool^WoooW`5?ooo_D03?oo
oOCooo_booonmOoon_7ooogdooonmOoon>ooooccooonmOoooOCooo[aoooklQ;oooke2Oooo?<00ooo
no;oooS_ooohk`0Cooohk`0=ooofkOoon>oooo;YooodjooolNWoooO^oooil?oomNcooo?ZooobjOoo
m>_oooK]ooogkP03ooofk@GoooO^00?oooK]oooek?oomN`01?oomN`2ooo`j007ooocj_ool>Sooo;Y
oooXh?oojn?ooo;Yooofk@02ooocjP;oooG/00GoooS_oookl_oono;ooo_booojl@04oooil003oooh
kooomnkoooS_00CoooS_00_oooO^ooo_iooomnkooo7Yooocj_ook^KoonWQooobjOoom>_oooG/ooog
kP02ooojl@05oookl_oon_7oooS_oooil?oon_401?oonO000ooon_7ooo_boooklP04oooklP07oooi
l?ooln[oooO^ooo`j?oon>ooonoWoooVgP02ooo_i`05ooodjoooln[oooK]oooek?oomnh02ooonO00
2_oon>ooooO^ooogk_oomnkooo3XooobjOooln[oonkVoooZh_ooiml2oooVgP03oooWgoook^Kooo7Y
00;oonkV00Kooo3Xooocj_ooln[ooo?ZooodjooomN`6ooodj`GoooK]00[ooo?Zoooek?oom^goooG/
ooobjOooknOoonWQooo_iooolNWoooC[0_oolnX7oooek003ooohkooonO3oooW`00;oooW`00?ooo[a
oookl_oono800_oono800ooon_7ooogdooonm@02ooonm@05ooollooomNcooo_booogk_oono800_oo
o?<Dooonm@04ooolloooo_Goooccoookl_ooooke<_ooo_DIooonmQ;oookg4_ooo_P?ooonn@Woookj
2?ooooX@oooona7ooool4_oooodHoooooP00:Oooo_@6oooml`0;ooonm?oooO?oooS^oooikooon_3o
oogcoooklOooo?;ooogcoooklOooo_@05_oooO<01ooono7oooK/ooobjOoolnWooo;Yoooikoooo_@0
5?oooO<00ooono7ooogcooojl002oooml`04ooohk_oono7ooogcooollP;ooo[`0_oooO<_ooonm00<
ooojl?ooo?;oooG[ooohk_oolnWooo_aooomlooon_3oooS^ooogkOoonNoooocb1OoooO<5ooollPGo
oo[`00[oooW_ooodj_oom>[oooO]ooocjOoom^coonWPooo]i?oomngooo_a0_oomnd00ooonNoooo[`
ooojl003ooojl003oooikooomngoooO]00;oooO]00CoooS^oooejooolnWooo7X0_ool>L02OoolNSo
onoVoooZhOookNCoon[Qooo[h_oojN3oonKMoooXg`02oooYh003oooZhOook>?oonkU00;oongT00?o
oncSooo]i?ool^T01Ooomnd6ooojl009ooohk_ool^WoooK/ooo`iooom>[ooncSoooUg?ookNCoonkU
00;oooCZ00?oooO]ooofk?oon>h02?oonNl2ooojl003ooohk_oomngoooO]00;oooO]00Kooo3Woooc
jOoomN_oonoVoooZhOooimh2oooVg@06oooWg_oolNSoooG[oooaj?ool>Oooo?Y1?oomnd7ooofk0Ko
ooG[0_oonNl01ooon>koooK/ooocjOooj^7ooo;YoooejooonNl00_oon>h3oookl@Cooo[`1Ooono40
0ooooO?oookdooonm003ooonm00;ooomloooo_Coookdooonm?ooo?;oooG[ooojl?oomngooo_aoooj
l?ooo?805_ooo_@00oooo?;ooo_aooonm03oooonm33oookd5_ooo_DBooonmQ3oookg3oooo_P?ooon
n@kooooj3ooooo/@ooooo1;oooom5?ooooh002Woookd1Ooono402ooonNooooS^ooohk_oom>[oooG[
ooofk?oon>koooK/ooogkOoon>koooO]00GoooS^4Ooono402?ooo?;ooo[`ooodj_oolNSooo?Yoooa
j?oomngooocb5?oono402OoonNoooo_aooogkOoon_3ooo_aooofk?oonNoooo_aooojl002ooogk@03
ooojl?ooo?;oookd02koookd017ooo[`oooklOoom>[oooCZooo_i_oom>[oooK/ooodj_ool^Wooo7X
ooocjOoomN_oooK/oooejooolnWooo7Xooo^i@0;ooo]i0;oon_R00OooncSoooZhOook>?oonKMoooX
goook>?oonkU00;ooncS1oookN@3ooo^i@06ooo]i?ooknKooo3Wooo_i_ook^Gooo3W0_oolNP02Ooo
knKoon[Qooo^iOooj^7ooncSoooYh?ooi]goon[Qooo[hP02ooo/h`07ooo^iOoolnWoooK/ooofk?oo
mN_oooO]ooojl006oookl@?ooogc00goooW_ooohk_oomngooo7Xooofk?oolNSoooCZooo]i?ooiMco
ongTooo^iOoolNSooo3W00;ooo;Y1ooolNP01Oool>OoonkUooo^iOook^GoongT00Coon[Q00GoonSO
oooYh?ooj^7oonSOoooWgP04oooUg00:oooYh?oojn;oon[Qooo[h_ook>?oonkUooo_i_ook^Gooo3W
ooobj@Wooo7X00?ooo;Yoooaj?ookN@00_ookN@02_ook>?oonkUooo_i_oojN3oonkUooo`iooolnWo
ooCZoooejooonNl2ooojl004oooll_oooO?ooogcoooml`_ooocb00_ooo[`oooll_ooo?;ooocboooj
l?oom>[oooS^ooofk?oonNooooO]ooojl00FooollP06ooojl?oonNoooocboooll_oono7ooocboooo
o_@]ooonm1Koooke4_ooo_H@ooonm`ooookh3_ooo_T?oooonPoooook4?oooo`BoooooACoooon000S
ooollP03oooklOoon_3ooo[`00;ooo[`1Ooono401?oon>koooK/ooofk?oom^`2oooaj006ooobjOoo
m>[ooo?YooocjOoom>[ooo?Y1OoomN/00ooom^coooG[oooej`02oooej`goooCZ00Oooo?Yooo_i_oo
k>?oonoVooo]i?oolNSoooG[013oooCZ00goooG[ooofk?oom^coooG[ooodj_oom^coooCZooogkOoo
no7oooO]ooojl?ooo?;ooo_a00;oooW_5Oooo?801ooonNooooS^ooohk_oomngoooK/oooejooom>X0
3OoomN/00ooom>[ooo?Yooocj@05ooocj@05oooaj?oolnWoongTooo^iOoojn800_oolNP01?ook^Go
ongTooo/hoook^D3ooo`i`03ooo^iOook>?ooncS00WooncS00_oonkUooo_i_ook>?ooncSooo^iOoo
k>?oonkUoooUg?ooimkoonkUooo`i`02ooo^i@03ooo_i_ool>Oooo3W00Gooo3W00CoonkUooo/hooo
kNCoongT0oooknH02oool>Oooo7Xooo_i_ook>?oonSOooo[h_ooimkoonKMoooUg?ooi=_oonKM00;o
onON0_ooj=l00oooj^7ooncSooo/h`02ooo/h`03ooo]i?ook^GoonkU00OoonkU0_ook><03?oojn;o
onWPooo]i?oojN3oon_RoooWg_oohm[oonONoooXgooojn;oon[Qooo/h`Coon[Q00?oonSOoooWg_oo
imh00_ooimh4oooUg0Soon?J1Oooh]T01Ooohm[oonCKoooVgOooi]goonON00?oonSO2_ooj^400ooo
jn;oonoVoooaj003ooo]i006ooo/hooojn;ooncSoooXgoooj^7oongT0oook^D2oooaj003ooocjOoo
mN_oooG[00goooG[00_ooo?YoooejooomN_oooG[ooocjOook^Gooo;Yooo`ioool^Wooo7Xooocj@0A
oooej`03ooodj_oomN_oooO]00;oooO]00KoooG[ooodj_oomngoooK/ooogkOoonNlGooojl003oook
lOooo?;ooocb0?oooocb4Oooo?8Doooll`_ooocd1OoooO@>ooomm@gooogf3?oooOL=ooomn0coooki
3?ooo_X>ooonn`goookl1Oooo_d;oooooA3oooon000Soooll@06oookl?oom^_oooK[ooofjooolnSo
oo3V1Oook^@3ooo]h`?oonWO00?oonSNoooVg?ooi]`01oooi]`00oooiM_oon?IoooRf002oooSf@03
oooUfoooi]coonKL00;oonKL00?oonOMoooYgoooj^001Oooj^001OoojMooonSNoooWgOooimgoonSN
01;oon[P00oooncRooo^i?ooknGoonkTooo]hoool>KoonoUooobj?oom^_ooo?Xooofjooon>goooO/
ooodjOoomNX02_oomn`3ooohk@03oookl?ooo?7oooca00Ooooca00Cooo_`oooik_oonNkoooO/3_oo
m^/00ooomN[ooo?Xooocj005ooocj00<oooaiooolnSoonkTooo^i?oojn7ooo7Wooo`i_oojn7oon[P
oooYgoooj^3oon_Q3_ook>802oookN?ooncRoooZh?ooj^3oon_QoooYgooojn7oonCJoooVg?ooj^3o
ongS00;oon_Q00?ooncRooo]hoookN<01OookN<00oook>;oon_Qooo[h@05ooo[h@0:oooZh?ooi]co
onKLoooVg?oojn7oonSNoooZh?ooimgoonGKoooYg`;oon[P00GooncRooo^i?ookN?ooncRooo]h`02
ooo_i@?ooo3V2OoolNL01oooknGoonSNoooZh?ooj=koonWOoooTf_ooh]P01?ooi=X00oooi]coonOM
oooXgP07oooYg`03oooWgOooiM_oonKL00CoonKL00?oon?IoooRf?ooh]P02?ooh]P4oooSf@?oonCJ
00Coon?IoooUfoooi]coonKL1?oojMl2oooZh00;ooo/h_ooj^3oon[PoooYgoooj^3oon_QoooZh?oo
jMooonSNoooUfooojMl00_ookN<01oooj^3oonWOooo/h_ook^CoonoUooo]hoook>800_ookN<;ooo^
i00;ooo]hoook^CoonkTooo]hooojn7oon[Pooo/h_ooj^3ooncRooo[hOookN<03?ook^@00oookN?o
onkToooai`03oooai`03ooobj?oom>Wooo?X00;oooGZ00CoooCYooogk?oom^_oooS]6?oonNh00ooo
no3ooocaoooll@3oooollA;oooca4Oooo?8<oooll`?ooogc3OoooO@<ooomm@gooogf2ooooOL5ooom
n0Koookh3?ooo_T<ooonnPcoookk3Oooo_`2ooono@goooom3_ooooh002Coooc`0_oonnl00oooo?3o
ooW]ooogj`04ooogj`04ooofj_oom>SoooCXooodj0CoonoT00SoongRooo^hoook^?oonkSooo_i?oo
k^?oongRooo_i0;ooo7V00?oonoTooo^hoool>D01_oolNH8ooobi`06oooai_ooknCooncQooo]h_oo
knCooo7V4?ool^L00ooom>SoooGYooogj`02ooohk003ooofj_oon>coooGY00;oooS/00Cooo?Xooof
j_oon>coooO[0_oomNT:ooohk003oooikOoonnoooo__02?oooc`00cooo__ooohk?oonnoooo?Xoood
j?ool>GoooS/oooikOoon>coooKZooocj?oomNT@ooofjP0=oooejOool>Gooo3Uooocj?ool>Gooo?X
oooWg?ooj]oooo7Vooogjooom>Sooo?Xoooej@07ooofjP0=ooodj?ool^Oooo3Uooo_i?ool>GoonoT
oooai_ool^Oooo7Vooo^hoook>7oonSMooo[h002oooWg00:oooVfoooi=WoonOLoooWg?ooj=goonWN
ooo/hOoojn3oonWNoooZg`;oon_P00?oonoTooo`iOool^L02?oolnP02?oom>Sooo;Wooo/hOool^Oo
ongRooo^hoooimcoon?H0_ooj=d2oooYgP03oooZgoooj=goon[O00Soon[O0ooojMh2oooXg@;oonWN
00GoonKKoooWg?ooj=goonKKoooUfP03oooSf006oooTfOooimcoonSMoooXgOooimcoon[O1OookN80
1_ook^?oonoTooo_i?ooknCooo3Uooo_i0GoongR00Soon_Pooo/hOookN;ooncQoooZgooojMkoonKK
oooYgP;ooncQ0_oojn02ooo]hP05ooo`iOoolNKooo7VoooejOoon>`02ooonNd03?oomn_oooW]oooj
k_oonnooooKZooocj?oon>coooGYooohk?oom^[oooW]oooll0gooo__2?ooo?000ooon^koooW]oool
l03ooooll2coooc`4_ooo?4>ooollPgooogc3?oooO@;ooomm@_ooogf2ooooOL:ooonn0_oooki2ooo
o_X<ooonn`coookl3oooood<oooooP00<Oooo>l02?oom^WoooOZoooik?oonnkoooW/ooojkOoonnko
oo[]5oooo>l01_oon^goooOZooobi_oom>SoooS[oookkQCoooc_00Cooo_^ooojkOooo>ooooW/0_oo
o>l01_oomn[ooo[]ooolkoooo>oooo_^ooojkBWoooc_2?oonN`02ooom^WoooS[oooaiOoolnOooo3T
ooogj_oonNcoooS[ooofjOoolnOoooGX00GoooS[2ooonN`03Ooon>_ooo;Vooobi_oomNSooo;Voood
j?ooi][oon_OooociooonNcoooKYoooej?oon>/01_oonN`00ooon>_oooKYoooej005oooej00>ooof
jOoomNSooo?Wooo`i?oojmoooo7Uooo/h?ook^;oon[NoooVf_ookN7oonkRooo_hooolND2ooobiP03
ooociooomNSoooKY00;oooGX0_oom^T8oooej00;ooofjOoom>SoonoSoooej?ool>Cooo;VoooYgOoo
i=Woon_Oooo/h?oolND00_oolnL00oool>CoooCXoooej005oooej003ooodj?ool^Kooo;V00;ooo;V
01Cooo3Tooo_hooolNGooo;Vooo/h?ook^;ooo3Tooo/h?ooj=coonGIoooTfOoohmSoonOKooo]hOoo
l>CoonoSoooZg_ook^;oooCXoooej0CoooCX0ooom^T2ooogjPGoooKY00SoooCXooohjooonNcoooS[
oooej?oolnOoon_Oooo`i0;oooOZ0_oom^T00ooonNcoooS[ooojk@03ooojk@cooo_^00_oooW/oook
k_ooo>ooooc_ooofjOoolnOoooS[oooej?oonNcoooOZooojk@0Fooolk`03ooojkOoonNcoooc_0?oo
ooc_;?ooo>lAoooll0goooca0oooo?89ooomlPcooogc2_oooO@:ooomm@[ooogf1OoooOL5ooonm`[o
ookh2oooo_T:ooonnPcoookk2_ooo_`2ooooo0goooom2oooooh002oooo_]00[ooo[/ooohj_oolnKo
oo?VoooeiooomnWoooGWooofj?oomnWoooKX1?oon>X00ooomnWoooSZoookk@0@oookk@06oooijooo
mNOooo7Tooodi_oom^Sooo[/5?oonnd02?oon^coooSZoookkOoomnWooo[/oookkOoomNOoooW[=Ooo
nnd01_oon>[ooo_]oooeiooomNOooo7Tooojk0;ooo_]00?oooSZooobiOoomnT01Ooonnd00ooonN_o
ooSZooohjP07ooohjP0?oooijooon>[ooo;UooobiOoomNOooo;Uoooci_ooi=Soon[MooobiOoonN_o
ooKXoooeiooon>[oooW[00OoooSZ00?ooo[/oookkOoonnd01?oonnd2oooij`09ooofj?ookN3oooOY
ooo`hooolnKoongPoooWf_oolNCooo?V00;oooCV0_oom^P00ooon>[oooW[oooij`0<oooij`0?oooj
k?oon>[ooo7Tooohj_ool^GoooCVoooZgOoohmOoon_Nooo/gooolNCoooCVoooci_ook^7ooo;U00Ko
oo?V0_ool^D00oool>?oonoRooo_hP03ooo_hP07ooo^hOooj]goon_Nooo]h?oojMcoonKIoooTf002
oooSe`09oooVfOook=ooonoRooo^hOoojMcoongPooo`hooolNCooo;U00;oooCV1?oolnH00ooomNOo
ooOYooogj@04ooogj@0:ooodi_oomnWoooSZooogjOoolnKooo;UoooZgOookn;oooGWooofj0;oooGW
1_oon>X;oookk@03ooojk?oon>[ooo_]00;ooo_]00WoooGWooobiOoomnWoooCVooogjOoom^SoooW[
oookkOoon^`05?oonnd00ooonN_oooSZoookk@3ooookkB_ooo_]4?oonnh9oookk`?oooc_2oooo?0:
oooll@Wooocb2_ooo?<2ooolm0Oooogd2OoooOD9ooommPWooogg1ooooOP00oooo_Soookiooonn@08
ooonn@[oookj2_ooo_/;ooono0Coookm2?ooood9oooooP00<OoonnX01?oom^GoooOVooohiooonnX2
oooij003ooojjOoonNSooo_Z01Kooo_Z00KoooWXooodi?ool^;oooGTooofiOoon^TDoookjP04oooj
jOoon>Oooo_Zooojj@;ooo_Z00?oooGToooij?oonnX0=?oonnX02ooomnKooo_ZooofiOoomNCooo7Q
oooij?oonn[ooo[Yoooei?ook]kooo?S00GoooOV2_oomN@02ooom^GoooGTooo_goookmoooo;Rooo_
goool>3oon;CoooZf_oolN7oooKU00;ooo?S00?oooGTooofiOoomN@01_oomN@00ooom^GoooOVooog
iP04ooogiP0=ooohiooom^Gooo7Qooo[foool^;oongMooo_gooojm_oonOHooo`h?ool^;ooo?Soood
i002ooofi@07ooohiooonNSoooWXoooij?oomnKooo?Soooah@03ooobhP03oooahOook]koonkN00?o
onkN00koongMoooYfOook]koon[Jooo[foooi]OoonCEoooWf?ooj=Woon_Kooo]gOookmooon_Koooc
h`KoooCT0_oomN@00ooom>Cooo?Soooch`02oooch`;oooGT00KoonkNooo`h?ooln?oongMoooYfOoo
imP2oooSe008oooWf?ool>3oooGTooochoook=cooo;RooofiOoonNP>oookjP0<ooohiooon^Wooo_Z
oooij?oom^GoooCTooo[fooolN7oooSWoooij?oon>OoooOV4OoonnX00ooon^WoooSWoookjP02oook
jP09oooei?ool^;oooKUooodi?oon>OoooKUoooij?oon^WoooOV01Cooo_Z00?oooWXooohiooonnX0
oooonnX[oookjPcooo_[3?oonn`00ooonngoooc]ooolk@06ooolk@[oooc^2?ooo>l8oooll0Woooca
0_ooo?85ooomlPSooogc1ooooO@8ooomm@Oooogf1_oooOL2ooonm`Woookh2?ooo_T8ooonnP[oookk
2?ooo_`00ooooocoooomooooo@0:ooooo@Goooon000]oookjP04oooij?oomnKoooOVooohi`;ooo?S
00OoooGTooogi_oomNCoooKUooogi_oomNCoooSW00GoooOV00?ooo[Yoookj_oonnX03ooonnX01Ooo
m^Gooo;Roooei?oom^Gooo[Y01Cooo_Z00?ooo[YooohiooonnX00ooonnX00ooomNCoooWXoookjP0d
oookjP0<ooogi_oonn[oooGToooei?oolN7oooWXoookj_oon^WoooOVooochooomnKooo[Y3ooonnX0
1?oon^WoooCTooodi?oon>L2ooodi007oooRdoook]koooKUoookj_oon>OoooOVooojj@0AoookjP0;
ooogi_ookmooooKUooo_goool^;ooncLoooWf?ool>3ooo?Sooodi?oomN@01_oon>L2oookjP?ooo[Y
00?ooo_Zoooij?oomN@01?oomN@00ooom>CoonkNooodi002ooo`h00;ooo]gOooi]Ooon[Jooo^g_oo
kMgooo;Rooodi?ookmooooOVooohiooomnH00_oon>L01?oom^GoooCTooodi?ooln<5oooah@08oooc
hoool>3oon_Kooo]gOook]koon[JoooXfOooi]L2oooSe007oooUe_ook=cooo?SoooahOooj][ooo7Q
ooodi009oooch`03ooodi?oomnKoooKU00;oooKU00goooOVooodi?oomnKooo[Yoooij?oom^GoooCT
ooo[fooolN7oooSWoooij?oon>OoooOV017ooo_Z00?ooo[YooohiooonnX00_oonnX02Ooom>CoonoO
ooodi?oomnKoooSWoooei?oonNSooo[YooogiP0DoookjP03oooij?oon>Oooo_Z0?oooo_Z:_oonnX>
oookj`[ooo_/00?ooo_]ooolkOooo>d02?ooo>d9ooolkPSoooc_2?ooo?08oooll@?ooocb1OoooO88
oooml`Sooogd1ooooOD7ooommPKooogg0_ooo_L9ooonn0Soooki2?ooo_X9ooonn`[oookl2oooood6
oooooP00;OoonnT4ooojj0;oooGT00KoooOUooojj?oon>KoooSVoooiiooon>H6ooojj1;ooo_Y00Go
ooOUooobhOoomNCoooOUooojj00Doookj@03ooojj?oon>Kooo_Y00?ooo_Y00?oooGToooiiooonnT0
=?oonnT02ooomnGooo_Yoooei?oomNCooo3OoooiiooonnWooo[Xooohi_oom>?oooOU013ooo_Y00go
oo[Xoooch_oom^Cooo[Xoooei?ool^7oon;Booo^gOoom^Cooo_Yooohi_oomnGooo[X017ooo_Y00So
ooSVooo_g_oon>Kooo7Pooodhoook]goonSHooobh@?oooOU1_oon^P<oookj@0=ooojj?oolN3oooSV
ooodhooomNCooo;QoooXf?ook=_ooo?Rooo_g_oom^CoooSVoooah005ooohiPCoooOU1_oom^@01Ooo
mNCoonkMooo`goooln;oongL00;oonWI00SoonKFoooUeOooimOoonoNoooei?ooln;oon_JooochP_o
ooKT1?oomnD03OoonNOoooOUoooiiooonnWoooWWooofi?oom>?oon_Joooah?oon>KoooWWooohi_oo
mnD04OoonnT00ooon^SoooSVoookj@02oookj@03oooch_ook]goooCS00;oooSV00CoooGToooiiooo
n^SoooOU5?oonnT00ooonNOoooSVoookj@3ooookjBWooo_Y3_oonnX:oookj`;ooo_/2?ooo>`9oool
k@Soooc^2?ooo>l7oooll0Koooca0_oooO48ooomlPOooogc1ooooO@7ooomm@Sooogf0_oooOL6ooon
m`Ooookh2?ooo_T8ooonnPWoookk2?ooo_`2ooooo0[oooom1Oooooh0037ooo_Y0_oom^@01_oon>Ko
oo_Yooohi_oonNOooo[XoooiiaSooo_Y00CoooKTooodhooomnGoooSV5OoonnT00ooon^SoooWWoook
j@03oookj@03oooei?oonNOooo_Y027ooo_Y00?ooo[XoookjOoonnT04?oonnT01_oomnGooo_Yooof
i?oomnGooo?Roooii`;ooo_Y00?oooSVooodhooomnD04?oonnT03Ooon^Sooo?Rooofi?oon^SoooGT
ooo`goooi=Cooo3Ooooei?oonnWoooWWooogiOoon^P04OoonnT02?oon>KoonkMooohi_oolN3oooGT
ooo^gOooj=Sooo;Q0ooon>HBoookj@03oooiioool=ooooOU00;oooGT00Sooo7PoooZfOook]goooOU
ooo`gooon>KoooWWooochP;ooo_Y00?oooWWooohi_oon>H02Ooon>H04OoonNOoooSVooo`goooln;o
ooGTooo`goook=_oon[IoooWeoooiMGoonSHoooah?oon>KoooGTooo]g?oon>KoooWW00koooSV00go
oo[XooogiOoon^Sooo_Yoooiiooom^CoooCSooo[f_oolN3oooSVoooiiooon>KoooOU017ooo_Y00?o
oo[Xooohi_oonnT00_oonnT00oooln;oonkMooodh`02ooohiP04oooei?oonNOooo[XooogiACooo_Y
00?oooWWooohi_oonnT0oooonnTYoookj@gooo_Z2ooonn/3oookk0Ooooc/2Oooo>d8ooolkPSoooc_
1oooo?06oooll@;oooga1ooooO88oooml`Oooogd1ooooOD8ooommP;ooogg1_ooo_L7ooonn0Soooki
2?ooo_X:ooonn`Koookl0ooooo`:ooooo@Goooon000aoooki`08oooeh_oom^;oooSToookiooon>Co
ooWUoooji_oonNDHoooki`04oooghooom>7oooOSooohi1_ooo_W00?oooGRoooiiOoonnL08?oonnL0
0ooon^KoooOSoooki`0Aoooki`06oooghooonnOoooSToooiiOoon>CoooWU0ooonnL00ooom>7oooOS
oooki`0?oooki`09oooji_oom>7oooKRoooji_oom>7ooo3MoooWeOook]_ooo?P00;ooo_W00?oooST
oooji_oonnL04?oonnL02?oon>Cooo3Mooohi?oolMkoooCQooo^foooj=Kooo;O0ooon>@Boooki`0:
oooiiOool=goooOSooofh_oomn?ooo7NoooZf?ool=goooWUooo`g@;oooST00?oooGRoookiooonnL0
3_oonnL03_ool]ooooGRoooghoooln3oonkKooo[fOooimGoonSFoooYeoooln3ooo[Voooghoookmco
oo[V4?oonnL03?oomn?ooo[VoookiooonNGoooKRooodhOoojmWooo7Nooohi?oonNGoooSTooogha;o
oo_W00gooo[VoookiooonnOooo_WooodhOool]ooooCQoooghooon>CoooOSoooiiOoon^KoooOS01Co
oo_W00?oooWUooohi?oonnL0oooonnLYoooki`cooo_X2ooonnT4oookjPGooocZ1oooo>/9ooolk0Oo
ooc]1oooo>h7ooolk`?oooc`1?oooO06oooml@Oooogb1_oooO<8ooomm0Ooooge0ooooOH3ooonmPOo
ookg1oooo_P8ooonn@Soookj2?ooo_/4ooono0Gooool2oooood2oooooP00<OoonN@02?oolmooooCP
ooofhOoonNCoooKQooogh_oon>?oooOR6?oonN@01?oom^7ooo3Loooeh?oomn8Koooii003ooocgooo
mn;oooWT023oooWT00?oooSSoooeh?oonN@04OoonN@01?oomN3oooWTooodh?oom^42oooghP?oooWT
00?ooo;Noooeh?oonN@04?oonN@02?oomN3oooKQoooii?oomN3oongIoooWe?ookMWooo7M0_oonN@0
0ooom^7oooSSoooii00@oooii008ooofhOool=coooORooo_foool]kooncHoooVdoool=`3ooofhA;o
ooWT00[oooORooo^f_oomN3oooCPooobg_oolMgoonWFooo`g?oonNCooo7M0_oom^400ooom>3oooWT
oooii00>oooii00>ooo`g?oolmooooGPoooagOookMWoon[GoooUd_oojMKoon[Gooo`g?oon>?oooGP
ooo]fOoon><@oooii00<oooeh?oon>?oooWTooogh_oom>3ooo;NoooYe_ookm_oooKQooogh_oom^7o
ooGP5OoonN@01?oomn;ooo?Oooocgoool]h2ooofh@;oooOR00?oooSSoooeh?oonN@04ooonN@00ooo
mn;oooKQoooii03ooooii2SoooWT3?oonND6oooiiP?ooo[V2Ooon^L7ooojj0Kooo[Y1ooon^X2oooj
j`Gooo_[1ooonn`6oookk@Kooo_^1?oonnl00oooo>ooooc`oooll005oooll0Goooca1_ooo?86oool
l`;ooocd1?oooO@7ooomm@Kooogf1_oooOL5ooomn0;oookh1oooo_T7ooonnPOoookk2Oooo_`00ooo
o_goooomooooo@05ooooo@;oooon000aoooih`08ooocg_oom=ooooKPoooihooom^3oooOQooohh_oo
mn4Hoooih`03ooohh_ool]goooKP01coooWS00?ooo?NoooghOoonN<08?oonN<00ooon>;oooGOoooi
h`0Aoooih`04oooegooonN?ooo?Nooofh0;oooOQ0ooonN<00oool]goooGOoooih`0@oooih`;oooKP
00KoooWSoooghOook]WoonWEooo^fOoolmh2oooih`03ooofh?oon>;oooWS013oooWS00SoooKPooo`
fooom^3oonoJooobgOook=OoonKBooo`f`?oooKP4_oonN<02_oomn7oonkIoooegooom=oooo3Kooob
gOooj]Kooo;Moooihooom=l2ooofh003ooocg_oonN?oooWS00koooWS00Cooo3Kooocg_oomMoooo3K
0_ookMP02?ooiM7oonSDoooZe_ool=_oooSRoooegoookMSoooSR4?oonN<03?oomMooooSRoooihooo
mn7oooCOooobgOoojMGoonoJooofh?oomn7oooKPoooegaGoooWS00CoooKPooobgOool]gooo?N0_oo
m^02ooogh@03ooohh_oomMooooWS01?oooWS00?oooOQooofh?oonN<0oooonN<Yoooih`[oooWT1ooo
nND2oooji@Oooo[V2?oon^L8ooojj0Kooo[Y0ooon^X3oookjPOooo_[1Ooonn`6oookk@Kooo_^00?o
oo__ooolkoooo>l00oooo>l6oooll0Koooca1_ooo?84oooll`03ooomlooooOCooogd00Cooogd1Ooo
oOD7ooommPGooogg1?oooOP3ooonn0Ooooki1oooo_X8ooonn`Ooookl0_ooo_d7ooooo@7oooon000a
oooih@08ooocg?oom=goooKNoooihOoom]koooOOooohh?oommlHoooih@03oooggoool]_oooKN01co
ooWQ00?ooo?LoooggooonN408?oonN400ooon>3oooGMoooih@0Aoooih@06oooegOoonN7ooo?Loooe
gOoom=goooOO0ooonN400oool]_oooGMoooih@0@oooih@08ooohh?oom]koooWQoooggoook]OoonWC
ooo^eooom=d2oooih@03ooofg_oon>3oooWQ013oooWQ00_oooKNooo`fOoom]koonoHooobfoook=Ko
onK@ooo`fOoomMgoooKNooohh00Boooih@0:oooggoook]OoooGMooodgOoolM[ooo;KoooZe?ool]_o
ooWQooodg@;oooKN00?ooo?LoooihOoonN403_oonN401?ool=Wooo?LoooegOool=T2ooo]eP08oooU
coooj=;oon[Dooo`fOoon>3oooGMooo]e_oon>0@oooih@0<oooegOoon>3oooWQoooggooom=gooo;K
oooYdoookmSoooKNoooggooom]koooGM5OoonN401_oom]kooo;Kooobfoool]_oooGMooofgP;oooOO
00?oooSPoooegOoonN404ooonN400ooommooooKNoooih@3ooooihBSoooWQ2OoonN8:oooih`Oooo[T
2?oon^D5ooojiPOooo[W1_oon^P6oookj@Gooo_Z1_oonn/6oookk0Gooo_]1Oooo>h6ooolk`Goooc`
1_ooo?45ooollPGooogc1OoooO@7ooomm@Gooogf1_oooOL6ooonn0Ooooki1_ooo_X7ooonn`Ooookl
2Oooood0037oooWQ00Sooo?LooodgOoom]koooWQooofg_oommooooSPoooggaSoooWQ00?oooOOooob
fooom]h01?oonN400ooon>3oooWQoooih@0Eoooih@03ooocg?oommooooWQ023oooWQ00?oooSPoooe
gOoonN404OoonN401_oomMgoooWQooocg?oomMgooo?Looogg`?oooWQ00?ooo;KoooegOoonN404?oo
nN402?oon>3oooOOoooihOoommooonkGoooYdoook]OoooCM0_oonN400ooom]koooSPoooih@0@oooi
h@08ooofg_ool=WoooKNooo_f?ool]_ooncFoooVd?ool=T2ooofgQ?oooWQ00[oooOOooo_f?oomMgo
ooCMoooaf_ool]_oon[DooobfooonN7oooCM0_oom]h00ooolmcoooWQoooih@0>oooih@04ooo`fOoo
lmcoooGMooo`f@;oongF00SoonG?oooXd_ooj]Cooo3Iooohh?oomMgoongFooohh13oooWQ00coooGM
ooohh?oonN7oooOOooodgOool]_oonWCooo_f?oom]koooOOooofg_oomMdEoooih@06ooofg_ool]_o
oo;KooobfooomMgoooKN0ooon>000ooomMgoooWQoooih@0Boooih@03oooggooom]koooWQ0?ooooWQ
9ooonN4:oooihPWoooWS2?oon^@7oooji@Kooo[V1ooon^L6ooojj0Kooo_Y1OoonnX6oookj`Kooo_/
1Ooonnd6ooolkPGoooc_1Oooo?06oooll@Gooocb1OoooO<6ooomm0Goooge1_oooOH6ooomm`Koookh
1oooo_T5ooonnPWoookk1_ooo_`9ooooo@00<OoonMl02?oolm[oooCKooofg?oonMooooKLoooggOoo
n=koooOM6?oonMl00ooommgooo;Iooofg004oooig`03oooeg?oon=koooWO01GoooWO00?oooCKooog
gOoonMl08?oonMl00ooon=koooGLoooig`0Aoooig`06ooodfooommgooo?Joooeg?oolm[oooOM0ooo
nMl00oool]WoooSNoooig`0@oooig`;oooKL00KoooWOoooggOook]GoonWAooo^eOoom=/2oooig`03
ooofg?oon=koooWO013oooWO00SoooKLooo`eooom]coonoFooobfOook=CoonK>oooaf0;oooGL00?o
ooSNoooigooonMl04?oonMl02_oommgooo;Iooofg?oom=_ooo7HooobfOooj=3oonoFoooigooom=/2
ooofg003ooocf_oonMooooWO00koooWO00Cooo3Gooocf_oomMcooo3G0_ookMD02?ooiLkoonS@oooZ
d_ool=OoooSNoooeg?ookMGoooSN4?oonMl03?oomMcoooSNoooigooommgoooCKooobfOoojM7oonoF
ooofg?oommgoooKLoooeg1GoooWO00KoooKLooobfOool]Wooo;Ioooeg?oom]`2oooig`03ooohg_oo
mMcoooWO01?oooWO00?oooOMooofg?oonMl0oooonMlWoooig`WoooWP2OoonN42oooihPGooo[R1ooo
n^<6oooji0Kooo[U1_oon^H3oooji`;ooo_W1_oonnP6oookj@Gooo_Z1Ooonn/4oookk003ooolk?oo
o>goooc]00?oooc]1Oooo>h5ooolk`Goooc`1Oooo?400oooo?;ooogbooomlP02ooomlPGooogc1_oo
oO@5ooomm@Gooogf0ooooOL3ooonm`Koookh1Oooo_T7ooonnPOoookk1_ooo_`2ooooo0Koooom000a
ooohgP08ooobfOoolm[oooGKooohg_oomM_oooKLoooggOoom]`FooohgP05oooggOoon=koooKLoooa
f?oomM/01?oon=h00ooomM_oooOMooohgP0EooohgP;oooKL8Ooon=h00ooommgoooCKooohgP0Aoooh
gP06ooobfOoomM_ooo;Iooodfoool]WoooKL0ooon=h00oool=OoooOMooohgP0@ooohgP08ooodfooo
mM_oooSNooofg?ookMCoonS@ooo]e?oolmX2ooohgP03oooefooommgoooSN013oooSN00_oooGKooo_
e_oomM_oonkEoooaf?oojm?oonO?ooobfOoolMSooo?Joooef`0BooohgP0:ooofg?oolMSoooGKoooc
f_ool=Oooo7HoooVc_ookMCoooSNooocfP;oooGK00?ooo;Iooohg_oon=h03_oon=h01?ookmKooo;I
ooodfoookmH2ooo/e008oooUcOooilooonWAooo_e_oommgoooCKooo/e?oommd@ooohgP0<ooodfooo
mmgoooSNooofg?oolm[ooo7HoooXd?ook]GoooGKooofg?oomM_oooCK5Ooon=h01_oomM_ooo7Hoooa
f?oolMSoooGKooogg@;oooSN00?oooOMooodfooon=h04ooon=h00ooom]coooGKooohgP3oooohgROo
ooSN2_oon=l7ooohh0SoooWQ1_oonN86oooih`OoooWT0ooonND2oooji@Gooo[V1Ooon^L6ooojj0Go
oo[Y0_oon^X3oookjPGooo_[1Ooonn`5oookk@Cooo_^1_ooo>l4oooll0Goooca1Oooo?83oooll`;o
oogc1OoooO@5ooomm@Kooogf1OoooOL2ooomn0Coookh1_ooo_T6ooonnPKoookk1oooo_`00oooo_go
ooomooooo@04ooooo@00<Ooon=h02?ool]Wooo?Joooefooon=koooGKooofg?oommgoooKL5Ooon=h0
1_oom]cooo;Iooohg_oom]cooo7Hoooef`CoooSN00?oooGKoooggOoon=h05Ooon=h2ooofg27oooSN
00?oooOMooodfooon=h04Ooon=h01_oomM_oooKLooobfOoom=_ooo?Jooofg0;oooSN00?oooKLooo_
e_oommd04Ooon=h02?oom=_oooGKooohg_oom]coongDoooXd?ookMCooo?J0_oon=h00ooomM_oooOM
ooohgP0@ooohgP07oooefoookmKoooGKooo^eOoolMSoon_CoooWc`02ooobf@;ooo?J00?oooCKoooh
g_oon=h03ooon=h03Ooom]cooo7Hoooefooolm[ooo3Goooaf?ooi/koongDooohg_oom=_oooOMoooe
foool]T03ooon=h01OoommgoonoFoooefooom=_oonoF00;ooncD00SoonG=oooWcooojM7oonoFooog
gOoom=_ooncDoooggA3oooSN00coooCKoooggOoon=koooKLooocf_oolMSoonS@ooo^eOoomM_oooKL
oooefooom=/EooohgP05oooefooolMSooo7Hoooaf?oomM/00ooon=h00ooommgoooCKooohgP0Coooh
gP03ooofg?oomM_oooSN0?ooooSN9_oon=h:ooohg`OoooSP0_oonN07oooih@KoooWR1_oonN<6oooi
i0CoooWU00?ooo[Uoooji_oon^H01?oon^H6oooji`Gooo[X1Ooon^T2ooojjP?ooo_Z1Ooonn/5oook
k0Gooo_]1?oonnh6ooolk`Coooc`1Oooo?45ooollP?ooocc0_oooO<5ooomm0Goooge1OoooOH7ooom
m`;ooogh0_ooo_P6ooonn@Ooookj1_ooo_/7ooono003ooonoOoooogoooom00Coooom000aooohg004
ooobeooolmSoooGIooohg0;oooKJ00?oooOKoooff_oon=`05?oon=`01_oomMWooo7Fooohg?oom][o
oo7Foooef@CoooSL00?oooGIooogfooon=`05Ooon=`2oooffR7oooSL00?oooOKooodfOoon=`04Ooo
n=`2oooffP04ooobeooom=Wooo7FoooffP;oooSL00?oooKJooo^dooomm/04Ooon=`02?oom=WoooGI
ooohg?oom][oongCoooXc_ookM?ooo?H0_oon=`2ooogfa7oooSL00WoooGIooo_e?oom][oonkCoooa
e_oojm7oonO=ooocf?oom=T00_oolmP00oool]OoooSLooohg00?ooohg00=oooff_oolMKoooGIoooc
f?ool=Gooo;GoooVc?ookM?oooSLooodfOoon=coooGIooobe`0?ooohg005ooogfoookmCoooGIoood
fOookm@00_ook=802?ooilgoonS>oooZd?ookmCoooOKooodfOook=;oooOK4?oon=`03?oom=WoooOK
ooohg?oom][ooo?Hoooae_ooj<koonkCoooefOoom][oooGIooodfAGoooSL00GoooGIoooae_oolMKo
oo7Foooef@03ooohg003ooogfooom=WoooSL01?oooSL00?oooKJoooefOoon=`0oooon=`Vooohg0Wo
ooSM2Ooon=h7oooig`GoooWP1ooonN46oooihPCoooWS1_oon^@5oooji@Gooo[V1?oon^L5ooojj0Go
oo_Y1OoonnX4oookj`Gooo_/1?oonnd5ooolkPGoooc_1?ooo?05oooll@Cooocb1_oooO<4ooomm0Go
ooge1_oooOH4ooomm`Koookh1Oooo_T7ooonnPGoookk1oooo_`6ooooo@00<OoommX01?oolMGooo;F
ooodeooom]T2ooogfP03oooffOoomMSoooOJ01CoooOJ00KoooCGooo`e?oomm[oooGHooo`e?oom=L4
ooogfP03ooodeooom]WoooOJ01GoooOJ00?ooo;Foooef?oommX08?oommX00ooom]Wooo?GooogfP0A
ooogfP;oooGH00Cooo7Eooobe_ookM7oooGH0_oommX00ooomMSoongAoooff@0AooogfP08oooceooo
m=OoooOJoooef?ook=7oonS<ooo/dOool]HEooogfP09ooobe_ookM7oooCGooo[d?ool=CoonW>oooW
boool]KoooCG00?ooo;F4OoommX00ooomMSooo3Doooce`02ooo_d`08oooaeOooi/_oon_@ooogf_oo
lmOoooOJooodeooolMD?ooogfP05oooffOook];oooCGoooceoook]800_oojm002?ooil_oonS=ooo[
d?ook];oooKIoooceooojm3oooKI4?oommX02_oolmOoooKIooogf_oomMSooo;Fooo`e?ooj<coongA
ooodeooomMP2oooceaGoooOJ00GoooCGooo`e?ool=Cooo3Dooode`03ooogfP03oooffOoolmOoooOJ
01?oooOJ00?oooGHooodeooommX0oooommXVooogfPWoooOK1_oomm`2ooohg0KoooSM1ooon=h4oooh
g`KoooSP0ooon>42oooih@GoooWR1_oonN<4oooii0GoooWU1?oon^H5oooji`Cooo[X1Ooon^T3oooj
jPGooo_[1?oonn`5oookk@Cooo_^0_oonnl3ooolk`Coooc`1?ooo?45ooollPCooocc1OoooO@4ooom
m@Kooogf1OoooOL3ooomn0;oookh1Oooo_T5ooonnPOoookk1oooo_`00oooo_goooomooooo@01oooo
o@00<OoommP01?oolM?ooo;DooodeOoom]L2ooogf003ooofeooomMKoooOH01CoooOH00KoooCEooo`
d_oommSoooGFooo`d_oomMH4ooogf003ooodeOoom]OoooOH01GoooOH00?ooo7Coooee_oommP08?oo
mmP00ooom]Oooo?Eooogf00Aooogf0;oooGF00Cooo7Cooobe?ook]3oooGF0_oommP00ooomMKoong@
ooofe`0Aooogf008oooceOoom=GoooOHoooee_ook<ooonS:ooo/coool]@Eooogf005ooo`d_ook<oo
oo?EoooZcOool=800_ooilX00oool=;ooo?Eoooce@02ooobe17oooOH00goooGFooo`d_oolmGoonk@
ooo_dOoolM?oonK9ooo[c_oommSooo?Eooogf?oom=Gooo7C013oooOH00CoonoAooodeOoolmGoonk@
0_oojlh02?ooil[oonS;ooo[c_oolM?oooKGoooceOoojlkoooKG4?oommP03?oolmGoooKGooogf?oo
mMKooo;Dooo`d_ooj<[oon[=ooodeOoomMKooo7Cooobe1GoooOH00GoooCEooo`d_ool=;ooo3Boood
e@03ooogf003ooofeooolmGoooOH01?oooOH00?oooGFooodeOoommP0oooommPWooogf0OoooOI1_oo
mmX2ooohfPGoooSK1ooon=`5ooohg@KoooSN0ooon=l2oooig`CoooWP1OoonN44oooihPGoooWS0ooo
nN@00ooon^Cooo[Uoooji@03oooji@Cooo[V1?oon^L4ooojj0?ooo[Y00?ooo_Yoookj_oonnX00_oo
nnX5oookj`Cooo_/1?oonnd2oookkP;oooc^1?ooo>l5oooll0?oooca1Oooo?801?ooo??ooogcooom
looooO<5ooomm0Coooge1OoooOH4ooomm`03ooomn?ooo_Soookh00?oookh1Oooo_T5ooonnPKoookk
1_ooo_`00oooo_goooomooooo@01ooooo@00<OoommL01?oolM;ooo;Cooode?oom]H2oooge`03ooof
e_oomMGoooOG01CoooOG00GoooCDooo`dOoommOoooGEooobd`04oooge`03ooofe_oolmCoooKF01Ko
ooOG00?ooo?DooogeooommL08?oommL00ooom]Kooo?Doooge`0Aoooge`;oooGE00Cooo7Booobdooo
k/ooooGE0_oommL00ooomMGoong?ooofeP0Aoooge`08oooce?oom=CoooOGoooeeOook<koonS:ooo/
c_ool]<Eoooge`05oooce?ook<kooo;CoooZc?ool=400_ooilT00oookm3ooo?Dooobd`02ooobda7o
ooOG00?oooGEooo`dOoolm@00_ookm002?oolM;oonO9ooo[cOoolmCoooCDooogeooom=Cooo7B4?oo
mmL01?oolM;oooCDoooce?ook/l2ooo[c@08oooWbOooj<[oonc>oooad_oom]Kooo?Dooo[cOoom]H@
oooge`0<oooce?oom]KoooOGooofe_ool=7oono@oooWbOoojL_oooCDoooeeOoolM;ooo;C5OoommL0
1Ooom=Cooo3Aooo`dOool=7oooCD00?oooOG00?oooKFoooce?oommL04ooommL00ooomMGoooCDooog
e`3oooogebKoooOG2OoommP5ooogf@OoooSJ1_oon=/6ooohg0GoooSM1?oon=h6oooig`CoooWP1?oo
nN45oooihPCoooWS1?oon^@4oooji@Cooo[V1Ooon^L3ooojj0Cooo_Y1OoonnX4oookj`Cooo_/1?oo
nnd3ooolkPGoooc_1?ooo?04oooll@Cooocb1?oooO<5ooomm0Coooge1OoooOH5ooomm`Goookh1?oo
o_T6ooonnPGoookk2?ooo_`2ooooo@00<Ooom]D01?ool=3ooo7Aooocd_oomM@2ooofe@03oooee?oo
m=?oooKE01CoooKE00Gooo?Booo_cooom]GoooCCoooad@04ooofe@03ooocd_ool];oooGD01KoooKE
00?ooo;BooofeOoom]D08?oom]D00ooomMCooo;Booofe@0Aooofe@;oooCC00Cooo3@ooo_coookLgo
ooCC0_oom]D00ooom=?oonc=oooee00Aooofe@08ooobd_oolm;oooKEoooddooojlcoonO8ooo[c?oo
lM4Eooofe@0:ooocd_ook<gooo3@oooYb_ooklooonC5oooWb?ool=3ooo7Aooo^cP;ooo7A4Ooom]D0
0ooom=?oono?ooobdP02ooo^cP08ooo`d?ooi/OoonW:ooo`d?oolm;oooKEooocd_ool=0@ooofe@04
ooo`d?oolm;ooo;Booo]c@;oon[;00SoonS8oooXbOookLgooo;Boooee?ool];oon[;oooee13oooKE
00cooo;Boooee?oom]GoooGDooo^c_oojlcoonK7oooXbOoolm;oooCCooo`d?oolM4Eooofe@05oooc
d_ooklooono?ooo_cooolm800ooom]D00ooomMCooo;Booofe@0Cooofe@03oooddooolm;oooKE0?oo
ooKE9ooom]D7ooofePKoooKG1ooommP5ooogf@GoooOJ1Ooomm/2ooogg0?oooSL1Ooon=d4ooohgPCo
ooSO1?oon>04oooih@CoooWR1OoonN<4oooii0?oooWU1?oon^H4oooji`Cooo[X1?oon^T01?oon^[o
oo_Zoookj_oonnX3oookj`Cooo_/1?oonnd4oookkP?oooc_1?ooo?05oooll@Cooocb1?ooo?<4ooom
m0Goooge1?oooOH4ooomm`?ooogh0_ooo_P4ooonn@Koookj1_ooo_/5ooono07oookm0Oooood1oooo
o@00<Ooom]@01?ool<oooo7@ooocd_oomM<2ooofe003oooedooom=;oooKD01CoooKD00Gooo?Booo_
c_oom]CoooCBoooad002ooofe0;oooGC00?ooo?BooobdOoomM<05_oom]@00oool]7oooKDooofe00P
ooofe003oooedooolm;oooKD017oooKD0_oom=801?ool<ooono>ooo]cOoom=82ooofe003ooodd_oo
kLgoooGC017oooKD0_ool]401ooom]CoooCBoooZb_ooilOoon_;oooad?oom]@02OoomM<9ooofe00:
oooedooom=;ooo?Booo/c?oolM3oonW9oooad?oohl?oonO7ooo]c@;oonk=0_oolM0Aooofe003oood
d_ooklkooo;A00;oonk=00Sooo7@oooVa_ooj<Soono>ooocd_oom]Cooo?Booo`ca3oooKD00Cooo3?
ooocd_oolm;oonk=0oooj/X01ooojLWoong=ooocd_oom]Cooo;AoooZb_oomM<04?oom]@03?ool]7o
ooGCooofe?oomM?oonk=ooo[boooi/KoonS8ooocd_oom=;ooo3?oooad1GoooKD00Gooo?Booo_c_oo
klkoono>ooocdP03ooofe003oooedoool]7oooKD01?oooKD00?oooCBooocd_oom]@0oooom]@Uooof
e0SoooKE1_oom]H7oooge`GoooOH1OoommT5ooogfP?oooOK0_oon=/5ooohg0CoooSM1?oon=h4oooh
g`;oooSP0_oonN04oooih@CoooWR1?oonN<4oooii003oooiiOoon^Gooo[U00Cooo[V1?oon^L4oooj
j0?ooo[Y1?oonnX4oookj`Cooo_/1?oonnd2oookkP03ooolk_ooo>ooooc_00;oooc_1?ooo?03oool
l@Gooocb0_ooo?<2oooml`Cooogd1?oooOD5ooommPCooogg00Coooghooonn?ooo_Soookh1_ooo_T5
ooonnPGoookk1_ooo_`2ooooo@00<Ooom]801?ool<gooo7>ooocd?oomM42ooofdP03oooedOoom=3o
ooKB01CoooKB00Gooo;?ooo_c?oom];oooC@oooacP02ooofdP05ooodd?oolm3ooo?@ooobcooomM40
5_oom]800oool/ooooKBooofdP0JooofdP03oooedOoolm3oooC@00?oooC@00?ooo?@ooo`cOoom=00
4Ooom=02ooobc`04ooo_c?ookL_oonc:ooobc`;oooC@00?ooo;?ooo[bOoolm001_oom=000ooolLko
oo3=ooo`c@07ooo`c@0:oooac_ooklcoono<ooocd?oolLkoonW7oooU`ooojLOoonk;ooocd0Wooo;?
00?ooo?@ooofd_oom]801_oom]803?oom=3ooo?@ooodd?ook<[ooo7>oooYaoookL_oonC2oooWaOoo
jLOoong;ooo^b`;ooo7>3Ooom]84ooodd003ooobcoookL_ooo3=00;oonc:00Soono<oooU`oooilGo
onk;oooac_oomM7ooo?@ooo`cA3oooKB00Cooo3=ooocd?oom];oonk;0_ooj/P01oookL_oon[8ooo/
b_oom=3oooKBooobcoook<X04Ooom]803?ool/ooooGAooofd_oomM7oonk;ooo/b_ooilGoonS6oooc
d?oom=3ooo3=oooacQGoooKB00Gooo?@ooo_c?ooklcoono<ooocd003ooofdP03oooedOool/ooooKB
01?oooKB00?oooC@ooocd?oom]80oooom]8UooofdPSoooKC1ooom]@5oooge@KoooOF1?oommL5ooog
f0CoooOI1Ooon=X4ooohf`CoooSL1?oon=d4ooohgPCoooWO1?oonN03oooih@CoooWR1?oonN<3oooj
i0Cooo[U1?oon^H3oooji`Cooo[X0ooonnT4oookjP?ooo_[1?oonn`3oookk@Coooc^1?ooo>l3oool
l0Coooca1?ooo?84oooml`Cooogd1OoooOD3ooommPGooogg1Oooo_P4ooonn@Goookj1Oooo_/5ooon
o0;oooom000aooofdP04ooo`cOoolLkooo?@oooed@;oooKB00?oooGAooodd?oom]805?oom]801Ooo
l<goono<ooofd_oom=3ooo3=00;oooKB00GoooC@oooac_oolm3ooo;?oooed@0FooofdP03ooobcooo
m];oooKB01[oooKB00?oooC@ooo`cOoom=001?oolm000oool<gooo?@ooocd00>ooocd008ooobcooo
lm3ooo7>ooo`cOookL_oonc:oooZb?oolLh2ooocd004oooac_ooj/Sooo;?ooocd0;ooo;?3Ooolm00
2Ooom=3ooo;?ooocd?oom];oooC@ooo[bOooilGoon_9oooacP04ooofdP03ooodd?oolm3ooo?@00Wo
oo?@0_ool/l03Ooolm3ooo7>ooo`cOool<goon[8ooo^boooilGoon[8oooS`_ooiL?oonO5oooZb?oo
k<X00_ook//00ooolm3ooo;?ooobc`08ooobc`03ooocd?ool/oooo7>00;ooo3=0_ool/l03?ookL_o
oo3=ooo/b_ook<[oono<oooU`oooilGoong;ooo`cOoomM7ooo?@ooo`cA3oooKB00gooo3=ooocd?oo
m];oonk;oooZb?oojLOoong;ooo[bOook/_oooC@ooofd_ool/ooonk;017oooKB00[ooo;?oooedOoo
m];oooGAooo^boookL_oonW7oooZb?oom=3oooGA0_oolLhEooofdP05ooocd?ooklcooo3=ooo_c?oo
lm000ooom]800ooomM7ooo;?ooofdP0CooofdP03ooodd?oolm3oooKB0?ooooKB9Ooom]88ooofd`Oo
ooKD1OoommD5ooogePGoooOG1?oommP5ooogf@GoooSJ1?oon=/4ooohg0CoooSM1?oon=h4oooig`Co
ooWP0ooonN44oooihPCoooWS0ooon^@4oooji@Cooo[V0ooon^L4ooojj0?ooo_Y0ooonnX4oookj`Co
oo_/0ooonnd4ooolkPCoooc_0oooo?04oooll@Cooocb1?oooO<4ooomm0Coooge1?oooOH5ooomm`Co
ookh1?ooo_T6ooonnPGoookk1_ooo_`1ooooo@00<Ooom<l01?ook/[oono;oooacOoollh2ooodc`03
ooocc_ool/goooC?01CoooC?00coonk:ooo]bOoom<oooo;=ooo]bOoolLgoooC?ooobcOook/[ooo7=
ooo`c?oollhFooodc`03ooo`c?oom<ooooC?01[oooC?00?ooo7=ooo^b_oom<l00ooom<l00ooollko
oo7=ooodc`0>ooodc`0>ooocc_oolLgooo7=ooo`c?ookl_oonc9ooo[b?oojLKooo3<oooacOool/go
oo3<oooYa_ool<`3oooac@03ooo_boook/[ooo3<00[ooo7=00[ooo;=ooo^b_ook/[ooo;=ooo`c?oo
j<CoonC1oooXa?ookLWooo;=3_oolLd01?ool/gooo?>ooocc_oollh2oooac@0:ooo^b_ooj/Ooonk:
oooYaOooj/Ooon;0oooS`?ooiL;oonS4oooZa`;oonk:3Ooollh01ooolLgooo3<oooacOool/gooo3<
ooo[b?ook/X00_ooj/L02?ookLWoon?0oooWa?oojlSoono;ooodcooolLgoono;4?oom<l03Oook/[o
oo7=ooodcoook<WoonW5oooXa?oojlSoonW6ooo]bOool/gooo?>ooo`c?ook<T04Ooom<l03?ool<co
oo?>ooodcooollkoonc9oooZaoooj<CoonW6ooocc_oom<oooo7=ooo`c0ooooC?1?oollh00oool/go
oo?>ooo_b`03ooo/b@06ooo`c?ool/gooo;=ooocc_ool/gooo3<1Ooollh?ooodc`03ooobcOoolLgo
ooC?0?ooooC?9Ooom<l7ooodd0CoooCA0ooomM45oooedPCoooGC1_oomM@4oooee@CoooKF1?oom]L5
oooff0?oooKI00?oooKJooogf_oommX00_oommX3ooogf`?oooOL1Ooommd2oooggP04ooohg_oon=oo
ooSOooohg`?oooSP1?oon>44ooohhP?oooWS0ooonN@3oooii@?oooWV0_oonNL2oooji`Cooo[X0ooo
n^T3ooojjP?ooo[[00Cooo_[oookk?oonncooo_/0ooonnd4oookkP?ooo__00Cooo_`oooll?ooo?3o
ooc`0oooo?44ooollP?ooocc0oooo?@2ooomm0Coooge0ooooOH5ooomm`Cooogh1?ooo_T6ooonnPCo
ookk1_ooo_`0037oooC<00Cooo7:ooo`bOoolL[ooo?;0_oom<`00oooll_ooo;:ooodc00Dooodc00<
ooo[aOook<KoooC<ooobb_oojlGoono8ooodc?ool/[oonk7oooab_ool<Wooo?;5_oom<`00oool<Wo
ooC<ooodc00Jooodc003oooab_ookLKoooC<00?oooC<00?ooo?;ooo`bOoom<`02Ooom<`8ooocb`;o
oo7:00Coonk7ooo/a_oojlGooo;:0_ooll/00ooolL[oon[4ooocb`03ooodc0_ooo?;00?ooo;:ooo`
bOoolLX00_ookLH01_oolL[oono8oooX`_oohkkoonO1ooo/aP?ooo3900?oono8ooo`bOool/X01ooo
l/X00ooolL[oono8ooo^a`03ooo^a`0<ooo]a_ook<Koon_5oooW`Oooj/CoonW2oooW`Oooh;_oon6l
oooS__ooi/3oonS20_ooj/@9ooo^a`04ooo]a_ook/Oooo39ooo`b@?oono800Cooo7:ooo_b?ook<Ko
onk70_ooj/@02OoojlGoon:moooT__oojL;oonc6oooab_ook/Ooonc6ooobbP07ooodc003ooocbooo
m<coooC<00GoooC<00goonk7oooab_oom<coonc6oooY`_ooj<;oon_5oooY`oookLKooo;:ooocbooo
l<Woonc6017oooC<00cooo39ooocbooom<cooo?;ooo/a_ooj/CoonO1oooY`oooll_oooC<oooab_oo
l<T>ooodc005ooocboool/[ooo;:ooobb_oolLX00_ooklP02_ookLKoon[4oooZa?ooj/Coong6ooo_
b?ool<Wooo;:oooab_ook/L3ooobbP03oooab_ool/[ooo?;00koooC<00?ooo;:oooab_oom<`0oooo
m<`Vooodc0KoooC=1?oom<h2oooecPCoooG?1OoomM05oooed@GoooGB00?oooGCooofdooom]<01?oo
m]@4ooofe@CoooKF0ooom]L4ooogf0CoooOI0ooommX3ooogf`?oooOL00CoooSLooohgOoon=goooSM
0ooon=h3ooohg`CoooSP00?oooSQoooihOoonN400ooonN83oooih`?oooWT1?oonND2ooojiPCooo[W
0ooon^P3ooojj@;ooo[Z00Cooo_Zoookjooonn_ooo_[1?oonn`3oookk@?ooo_^00?ooo__ooolkooo
o>l01?ooo?03oooll@Cooocb1?ooo?<3ooomm0Coooge1?oooOH3ooomm`?ooogh0_ooo_P4ooonn@Go
ookj1?ooo_/5ooono000<Ooom<`01?ooll_ooo39ooo`bOooll/2ooodc003ooocboool/[oooC<01Co
ooC<00coon_5ooo/a_oom<cooo?;ooo[aOook/OoooC<ooobb_ooklSooo7:ooo`bOooll/Fooodc003
ooo`bOoom<coooC<01[oooC<00Sooo7:ooo]a_oom<coooC<ooocbooom<cooo?;ooo`b@Wooo?;00?o
oo;:ooo`bOool<T01_oolLX2ooo_b004ooo/a_oojL?oonW2ooo_b0;ooo7:00?oono8oooY`_oolLX0
1ooom<`00oooll_ooo7:oooabP05oooabP0;ooo`bOoolL[oong6ooo^aoooklSoonc6oooU_ooohKco
onBnoooY`_oojlD00_oojL8;oooV`0CoonFo00SoonK0oooU_oooiKooonBnoooQ_?ooi;koon>noooR
_@;oomjj00?oomnjoooQ_?ooh[d00_oohkh00oooi/3oonFooooU_`04oooU_`03oooV`?ooi;koon:m
00;oon>n1Oooi;h00oooil7oonK0oooV`003oooS_P;oomnj00?oon:moooT__ooi/000_ooi/000ooo
jL;oonW3oooY``02oooY``04oooY`_oojL?oon_5ooo`b@OoooC<00goonk7oooab_oom<coonc6oooY
`_ooj<;oon_5oooY`oookLKooo;:ooodc?ool<Woon_5017oooC<00cooo39ooocbooom<cooo?;ooo/
a_oojlGoonFooooY`_ooll_oooC<oooab_ool<TEooodc005oooab_ookLKoonk7ooo]a_ool/X00ooo
m<`00oooll_ooo39ooodc00Cooodc003ooobb_oolL[oooC<0?ooooC<9Ooom<`6ooodc@KoooC>1Ooo
mLl5oooed0GoooGA1OoomM801?oomM?oooKCooofdooom]<3ooofe0CoooKE1?oom]H4ooofe`?oooOH
0ooommT4ooogfPCoooOK0_oomm`01?oon=coooSMooohgOoon=d3ooohgPCoooSO0ooon>000ooon>7o
ooWQoooih@03oooihP?oooWS1?oonN@3oooii@?ooo[V0ooon^L3ooojj0?ooo[Y0_oon^X01?oonn[o
oo_[oookjooonn/4oookk0?ooo_]0ooonnh01?oonnooooc_ooolkoooo>l3oooll0?oooca1?ooo?83
oooll`Cooogd1?oooOD4ooommP?ooogg0ooooOP2ooonn0Coooki1Oooo_X5ooonn`Coookl000boood
c0;ooo7:00Gooo?;ooodc?oom<cooo;:ooo`b@04ooobbQ7ooo?;00coon[4ooo[aOooll_ooo7:oooY
`ooojlGoooC<oooab_ookLKooo39ooo_b?ool/X?ooocb`?ooo;:00Gooo?;ooodc?oom<coooC<oooa
bP0Looodc004oooab_ook/OoooC<ooodc0;ooo7:00?ooo39ooo^aooolLX02?oolLX2ooobbP03oooa
b_ool<Wooo3900Cooo390_ook/L01?oojlGoonW2oooX`_ooklP2ooo`b@03ooo^aooojL;oono800Co
oo391?oolLX9ooo`b@09ooo]a_ooklSoono8ooo]a_ooi/3oon:moooV`?oojL?oong600?oon_500?o
ong6ooo^aooojlD02_oojlD2ooo/aP;oon[400[oonW2oooU_ooojL;oonS2oooV`?ooh;_oomnjoooR
_Oooi;koonO10_oojL88ooo/aP04ooo[aOooj/Coon[4oooY``KoonW200goonO1oooY`oooi/3oonO1
oooY`oooh[goon>noooW`OoojL?oon_5oooZa?oojL?oong600?oonk70oooklP00ooolL[oooC<oood
c006ooodc004ooo^aooolL[oooC<ooo/aP;oonW200Ooon_5oooY`oookLKooo?;ooodc?oolL[oong6
00GoooC<3?ool/X02_ooklSooo;:ooobb_oolL[oon_5oooZa?ooi;koonS2oooab_ooll/2ooo_b003
ooocboool/[ooo;:00Oooo;:1Oooll/6oooabP05ooo^aooojlGoon_5ooo[aOooklP00ooolLX00ooo
l<Woong6oooabP02oooabP03ooocbooom<coooC<00koooC<00?ooo;:oooab_oom<`0oooom<`Uoood
c0OoooC=1Ooom<h6oooec`GoooG@1?oomM44oooedP;oooGC0_oom]<5ooofe0?oooKE1?oom]H4ooof
e`CoooOH0ooommT3ooogfPCoooOK0_oomm`01?oon=coooSMooohgOoon=d4ooohgP?oooSO0ooon>00
0ooon>7oooWQoooih@03oooihP?oooWS0ooonN@3oooii@Cooo[V0ooon^L3ooojj0?ooo[Y0_oon^X2
oookjP?ooo_[0ooonn`3oookk@?ooo_^00?ooo__ooolkoooo>l01?ooo?03oooll@Cooocb0oooo?<4
ooomm0Coooge1?oooOH3ooomm`?ooogh0_ooo_P4ooonn@Coookj1_ooo_/4ooono0005OoollTLooob
b003oooaaoookLCoong400?ooo3700?oonk5ooo/`oook/D00_ook/D00ooojl?oonS0oooX`00>oooX
`00:oooY`?oohkcoonBloooY`?ooj<3oon:koooT_?oojL3oonNooooU_@;oonJn4?ooj<001?ooj/;o
ong4ooo^aOooklH3ooo`a`05ooo]a?ool<Oooo37ooo`aooolLL04oool/P00ooolLOooo37ooo`a`02
ooo`a`04ooo^aOooj/;oono6ooo^a@?oong400?oon_3ooo]a?ookL@01?ookL@2ooo[``04oooZ`_oo
jL3oonS0oooW_`GoonJn00CoonNooooU_OooiKgoonBl0_ooh[/01Oooi[koonNooooW_oooiKgoon:k
00GoonJn00?oonW1ooo[`ooojl<00ooojl<3ooo/``03oooZ`_oojL3oonNo00;oonJn00OoonW1oooZ
`_oojL7oon>loooN^?ooh;Woon>l00;oonFm0oooi;`00oooi[koonS0oooW_`02oooW_`03oooX`?oo
jL3oonW000;oonW000?oonJnoooU_Oooi;`00_ooi;`01?ooh[_oon2ioooN^?ooh;T2oooO^0;oombf
00?oomfgoooN^?oogkP00_ooh;T00ooohkcoonFmoooT_006oooT_003oooR^ooohK[oon6j00Koomnh
00WoomjhoooO^?oog[SoomjhoooP^OoogKOoomnhoooQ^_oohk`00_ooi;`00ooohkcoonFmoooW_`02
oooW_`04oooY`?ook<?oong4ooo]a0Ooonc300Goonk5oooY`Ooojl?oong4oooX`002oooU_@08oooW
_oooiKgoonW0ooo[`oook<?oon_3oooY`?ook<<3ooo^a@;oong400?oono6ooo`aoooklH02?ooklH0
2_ook<?oonk5ooo_a_ook/GoonW0oooX`?ooh[_oonJnooo]a?ook<<2oooY`@03ooo/`ooojl?oon_3
00Ooon_31OoojL000oooj/;oon_3ooo[``02ooo[``03ooo/`ooojL7oonS000;oonS000?oon[2ooo/
`ooojl<00_ook<<00oooj/;oong4ooo/``04ooo/``03ooo_a_ool<Ooono600_oono60_ool<Oooooc
bBKooo?91ooollX4ooocb`GoooC<1_oom<d3ooodcPGoooC?00CoooC@oooed?oomM3oooG@1?oomM43
oooedPCoooGC0ooomM@4ooofe@?oooKF0ooom]L4oooff0;oooOI1?oommX3ooogf`?oooOL0_oommd0
1?oon=goooSNooohg_oon=h4ooohg`;oooSP0ooon>400ooon>;oooWRoooihP03oooih`?oooWT0ooo
nND2oooiiP04oooji_oon^Oooo[Woooji`?ooo[X0ooon^T3ooojjP03ooojjooonn_ooo_[00?ooo_/
0ooonnd4oookkP;ooo__1?ooo?03oooll@?ooocb0oooo?<01?ooo?Cooogdooomm?oooO@4ooomm@Co
oogf0ooooOL3ooomn003ooonn?ooo_Woooki00;oooki1Oooo_X4ooonn`Coookl000Eoooca`03ooob
a_ool<Gooo3501Wooo3500?oonk3oooZ`?ooj/001?ook<801Ooojl7oong2ooo]`_ookL;oonc2013o
on_100[oonc2oooV_?ooikgoonc2ooo[`OooiK_oonNmooo/`_ooj/3oonRn0_oojKl00ooojl7oonc2
ooo[`@0;ooo[`@?oonc21_ookL801OoojKooon_1ooo]`_ookL;oono401?ooo3500Woonk3ooo/`_oo
k<;oonc2ooo]`_oojl7oonRnoooZ`?oojKh00oooikd00oooi[coonNmoooW_@04oooW_@03oooV_?oo
i;_oonBk00KoonBk00?oon:ioooQ^?oohKP00oooh;L00ooogkOoomjfoooP]`02oooQ^004oooP]ooo
g[Koon6hoooS^POoonBk00?oonJloooS^_oohKP00_oohKP3oooP]`03oooQ^?ooh[Woon>j00;oon>j
00OoomngoooM]OoogkOoon6hoooS^_ooh[Woon2g00?oomng0oooh;L00ooohKSoomngoooP]`03oooQ
^003oooP]ooog[Koomfe00?oomfe1Ooog;@4oooK/`?oombd2?oogKD00ooog;CoomjfoooP]`03oooP
]`06oooQ^?ooh;OoomfeoooM]Ooog;Coomfe0_oog;@00ooogKGoom^coooL]002oooM]@03oooN]_oo
gKGoomjf00Coon6h00Coon2goooR^Oooi;_oonFk1_ooikd02_ooj;koon[0oooW_Oooj;koonVooooV
_?ooi;_oon:ioooS^_ooh[T4oooV_0;oonBk00CoonJloooW_Oooi[coonJl0_ooikd00ooojKkoonRn
oooW_@07oooW_@08oooU^oooikgoonRnoooW_Oooi;_oon>joooO]ooohKP2oooW_@;oonFk2_ooikd4
oooV_005oooU^ooohk[oon:ioooS^_ooi[`00_oojKh01OooikgoonFkoooU^oooiK_oonNm00;oonVn
00Koon[0ooo[`OoojKkoon_1ooo]`_ool<D4oooaa@gooo;600?ooo75ooo`aOoollL0oooollLUoooc
a`Gooo?81OoollT2ooodb@CoooC:1Ooom</4ooodc0CoooC=00CoooC>oooec_oomLkoooG>0ooomLl4
oooed0?oooGA1?oomM800ooomM?oooKCooofd`03ooofe0CoooKE0ooom]H2ooofe`04ooogeooommSo
ooOHooogf0?oooOI0ooommX3ooogf`03ooogg?oon=coooSM00?oooSM0ooon=h2ooohg`CoooSP0_oo
nN43oooihP?oooWS0ooonN@2oooii@?ooo[V0ooon^L3ooojj0Cooo[Y00?ooo[Zoookj_oonn/00_oo
nn/3oookk0?ooo_]0ooonnh00ooonnooooc_ooolk`03oooll0?oooca1?ooo?82oooll`03ooomlooo
oOCooogd00;ooogd0_oooOD5ooommP?ooogg0ooooOP00oooo_Soookiooonn@02ooonn@Goookj1?oo
o_/3ooono000<_oollL2ooo]`P05ooo_a?ool<Gooo35ooo_a?ook/<05?ool<D03OoolLGoonVnoooX
__ool<Goono4oooW_OoojKoooo75ooo^`ooojl7oong2ooo/`_ookl@03_ool<D00oool/Kooo?7ooob
aP05ooobaP03ooo]`_oolLGooo?701[ooo?700?ooo35ooo]`_oollL00ooollL00oool/Kooo35oooc
a`06oooca`Oooo;600[ooo?7oooba_oolLGooo75ooo`aOooklCoong2ooo/`_oojKkooo350_oolLD0
1OooklCoonVnooo`aOool/Kooo?700Kooo;600Cooo?7oooba_oolLGooo351Oook<802Oooj/3oon_1
ooo/`_oojl7oonFkoooQ^?ooiK_oonVoooo]`P05ooo[`@05oooZ`?oojKooonVnoooV_?ooiK/01_oo
i;/2oooU^`;oonBk00goon>joooP]ooohk[oon:ioooQ^?oogKGoombdoooN]_ooh;Ooon6hoooS^_oo
h[WoonFk00?oonBk00?oonFkoooW_Oooikd00oooikd6oooX_P0?oooW_Oooi[coon>joooU^ooohk[o
on:ioooW_Oooh;Ooon6hoooU^oooikgoonRnoooY_ooojl7ooo7500Cooo;60_oolLD00oool/Kooo?7
oooca`04oooca`08oooba_oollOoonc2ooo_a?oolLGoonc2oooY_oooikd2oooY_`06ooo_a?ool<Go
ono4ooo]`_ooj/3oonk34?ookL803Oooj/3oong2ooo]`_ook/?oonVooooW_OoohKSoonFkooo/`_oo
k/?oon_1oooZ`?ook/<02OookL84ooo^``;oong200Koon_1oooY_oooj/3oonc2ooo^`ooojl43oooY
_P09ooo[`OookL;oong2ooo]`_ook<;oon[0ooo]`_ook/?oono400;ooo3500?oono4oooaaOoollL0
3?oollL00ooolLGooo35oooca`3oooocabKooo?71OoollP4ooocb@03ooodbOoom<[oooC:00;oooC:
1_oom</4ooodc0CoooC=00CoooC>oooec_oomLkoooG>0ooomLl4oooed0?oooGA1?oomM800ooomM?o
ooKCooofd`03ooofe0CoooKE0ooom]H3ooofe`;oooOH1?oommT3ooogfP?oooOK00?oooOLooohg?oo
n=`00ooon=d3ooohgP?oooSO0_oon>03oooih@?oooWR0ooonN<3oooii0?oooWU0ooon^H2oooji`?o
oo[X1?oon^T2oookjP?ooo_[0ooonn`3oookk@?ooo_^00Cooo__ooolkoooo>ooooc_0_ooo?03oool
l@Cooocb0_ooo?<01?oooO?ooogdooomm?oooO@4ooomm@Cooogf0ooooOL2ooomn0;oookh1?ooo_T5
ooonnPGoookk0_ooo_`0037ooo;500?ooo74ooo_`oook/806Oookl<03Oool<?oonRmoooV^oookl?o
onk2oooV^ooojKgooo33ooo]`Oooj[ooonc0ooo[`?ook/802oookl<00oookL7oonc0ooo/`008ooo/
`003oooY_Ooojl3oono301Goono300[oonk2ooo]`Oookl?oono3ooo``oookL7oonZoooo``oookl?o
ong10_ook<000oooj[ooonc0ooo/`00;ooo/`003ooo[`?ooj[ooonZo00;oonZo0_oojKh01?ooj;go
onNloooT^OoojKh2oooZ_`03oooY__ooi;WoonVm00?oonZo00?oonc0ooo]`Oook<001?ook<000ooo
kL7oon_0oooY_P03oooY_P0:oooY_Oooi[_oonNloooX_Oooikcoon6goooO]_oohKOoonFjoooX_@;o
onVm00CoonZoooo[`?oojl3oonZo0_oojKh:oooW_0;oonJk00coonFjoooT^OooiK[oon>ioooR^?oo
gKCoombcoooO]_oohKOoon:hoooU^_ooi;T4oooW_003oooX_Oooj[ooon_000;oon_01oooj[l02ooo
jl3oonVnoooV^ooojKgoonFjoooS^OooikcoomnfoooQ]oooiK[oonVn00;oon_000?oonZoooo_`ooo
l/D03_ool/D01_ook<3oong1ooo_`oooj[ooonRmoooU^P;oonRm00Goong1ooo^`_ookl?oonk2oooZ
_`0Aooo```0<ooo/`?ookl?ooo33ooo``ooojl3oonRmoooR^?ooi[_oono3ooo``oookL7oonc02_oo
l<<00oook/;oong1ooo_``05ooo```;oono300?ooo33ooo]`OoojKh00_ooj[l01_ookl?ooo;5ooob
aOool/Gooo74ooo_`aCooo;500?ooo33ooo_`oool/D0ooool/DVoooba@Cooo;61?ool/L00ooollOo
oo?8ooocb004ooocb0Cooo?91OoollX3ooocb`03ooocc?oom<coooC<00CoooC=1?oom<h4ooodc`;o
ooC@1?oomM43oooedP?oooGC1?oomM@2ooofe@?oooKF0ooom]L3oooff003oooffOoommWoooOI00?o
ooOJ0_oomm/3ooogg0?oooOM0ooon=h2ooohg`?oooSP0ooon>400ooon>;oooWRoooihP03oooih`;o
ooWT0ooonND3oooiiP;ooo[W1?oon^P2ooojj@?ooo[Z00?ooo[[oookjooonn/00ooonn`3oookk@?o
oo_^0ooonnl3oooll0?oooca1?ooo?83oooll`;ooogd1?oooOD3ooommPGooogg0_oooOP00oooo_So
ookiooonn@02ooonn@Goookj0oooo_/3ooono000<Oool/@01?oolL?oono2ooo_`_oolL<8oooba003
oooa`oookl;oonk100goonk100?oono2oooX_?ooi[X00_ook/402Oooi[[oonRlooo``_ook;ooonZn
ooo/_ooojkooonk1ooo_`P0;ooo^`@Coono200Soonk1ooo``_ool/Cooo;4oooa`oookl;oong0ooo^
`AKooo;400?ooo32ooo_`_ool/@00_ool/@00oookl;oonbooooba003oooba003oooa`oook/7ooo;4
00cooo;400Gooo73ooo``_ool<;ooo32oooa``02ooo_`P04ooo/_ooojkooonRlooo_`P;ooo7300Co
ono2oooX_?ook/7ooo730_ool<88oooba003oooa`oookl;oono200;oono200Woonk1oooZ__ook;oo
onk1ooo/_oooiKWoon6foooU^OoojKd01oook/4<ooo_`P0>ooo^`Oook;ooonZnoooY_?ooj[koonRl
oooV^_oogkGoomfcoooQ]_ooi;SoonNkoooZ__oojKd5ooo^`@Soong001CoonbooooY_Oooj[koonZn
oooY_?ooi[[oonRloooU^Oooh[OoonNkoooO]Oooh;GoonFioooX_?oojKgoonVloooX_?oojkooonbo
ooo]`0gooo3200goon^oooo]`?ool<;oonbooooY_?ooiKWoonVloooX_?ookL3oono2ooo``_ookl;o
on^o00;ooo3200?ooo73oooba?ool/@03?ool/@02_ook/7ooo73oooba?ool/Coong0oooY_?ooiKWo
onRloooa`oool/@2ooo_`P[ooo;400?ooo73ooo``_ool<801oool<800ooolL?oong0oooZ_P02oooZ
_P06ooo_`_ool/Cooo;4oooba?oolL?oonk15?ool/@00oool<;oono2oooba03ooooba2Kooo;41?oo
l/D4ooobaP03oooca_oollOooo?700Cooo?70ooollP4ooocb@Gooo?:00?ooo?;ooodbooom</00ooo
m<`4ooodc@?oooC>1?oom<l4oooed0;oooGA0ooomM83oooed`03oooee?oom]CoooKD00?oooKE0ooo
m]H3ooofe`?oooKH0_oommT4ooogfP;oooOK0ooomm`00ooommgoooSMooohg@02ooohgP?oooSO0ooo
n>02ooohh@?oooWR0ooonN<3oooii0;oooWU0_oonNH01?oon^Kooo[Wooojiooon^L3ooojj0?ooo[Y
0_oon^X3oookj`?ooo_/0ooonnd3oookkP;ooo__00Coooc_oooll?ooo?3oooc`0_ooo?44ooollP?o
oocc1?oooO@2ooomm@Cooogf0ooooOL3ooomn003ooonn?ooo_Woooki00;oooki1Oooo_X3ooonn`?o
ookl000aoooa`P04ooo``Oook/3oonfoooo``AWooo7200coonRkoooW^_ool<7ooo31oooW^_oojKco
oo72ooo^`?oojkgoonk0ooo]_oool<4Doooa`P04ooo``OookKooonVlooo/_QKooo7200?oono0ooo^
`?oolL800_oolL800oook/3oonZmoooa`P03oooa`P03ooo``Oook/3ooo7200[ooo7200?ooo31ooo^
`?ook/001?ook/02ooo/_P04oooZ_OoojKcoonJiooo]_`;oonk000?ooo31oooY_?ook/003?oolL80
0oool<7oono0ooo^`002ooo/_P0=oooZ_Ooojkgoonfoooo[_Oooi;Ooon2doooT]oooj;_oonfoooo^
`?ookl3oonk0ooo_`00?oooa`P0;ooo``OoojkgoonRkoooX^oooik[oonFhoooN/ooog;7oon2doooS
]oooi[T00_ooj;/Aooo/_P0:oooZ_Oooik[oonVloooV^OoohkOoonRkoooO]?oohKGoonFhoooX^`;o
onVl00?oonRjooo/__oojkd03_oojkd02Oooik[oonVlooo[_OoojKcoonFhoooR]_ooi;Ooon>goooX
^P02oooY_005oooX^oooj;[oonfoooo]_oook/003Oool<400oookl3oonbnooo_`002ooo``@08ooo[
_Oooik[oonRjoooX^_ook/3ooo31ooo]_oook/0Eooo``@05ooo]_ooojKcoonZmoooZ_Oookl000ooo
lL800oool<7oonfooooa`P0Coooa`P03ooo_`?ook/3ooo720?oooo729OoolL85oooa``Cooo7400?o
oo;4ooobaOool/D00oool/D3ooobaPGooo;71?ool/P4ooocb@?ooo?:0oooll/3ooocc004oooccOoo
m<goooC=ooodc@?oooC>0ooom<l3ooodd0;oooCA0ooomM84oooed`?oooGD0_oomMD3ooofeP;oooKG
1?oom]P2oooff@03oooff_oomm[oooOK00;oooOK0ooomm`3ooogg@;oooON0ooon=l3ooohh0;oooSQ
0_oon>800ooon>?oooWSoooih`03oooii0?oooWU0ooonNH00ooonNOooo[Wooojj002ooojj0?ooo[Y
0_oon^X3ooojj`;ooo_/0ooonnd4oookkP?ooo__0_ooo?03oooll@?ooocb0oooo?<2ooolm0;ooogd
0ooooOD3ooommP?ooogg1?oooOP4ooonn@Goookj1?ooo_/1ooono000<OoolL401?ool<3oonjoooo]
__ool<0Ioooa`@0<oooX^_ooikWooo71ooo``?ooikWoonVkoooa`Oookkooon^looo^_oookKkooo30
5?oolL401?ool<3oonfnoooX^_ook;dFoooa`@03ooo__oook[oooo7100;ooo7100?oonjooooZ_?oo
lL400_oolL400oookkooonfnooo[_00<ooo^_`Goonfn00coonjoooo/_OoojkcoonVkoooX^_ooi[So
onbmooo^_oook;goonZloooU]oooj;XAooo[_009oooX^_ooj[coon^loooY^ooohkKoomncoooS]_oo
j;Woon^l00CoonZl4?oojk`03?ooj;WoonJhoooX^OooikWoonBfoooM/Ooog;3oon6doooS]_ooikWo
onRioooW^@_oon^l00?oonZlooo[_?ookKh00oook[l03Oook;goonRjoooZ_?ooikWoonJhooo[_?oo
h;?oon6doooV^?oojK_oon^loooZ_?oojK/03oook[l03_oolL7oon^looo]__ool<3oonjooooY^ooo
iKOoonNioooV^?ooj[coonbmooo]__ook;goonVk4Oook[l01_ooj[coonfnooo^_oook[ooonVkoooU
]`;oonRj0_ook[l00ooojkcoonfnooo^_`0Dooo^_`05ooo[_?ooj;[oonRjoooY^oook[l00ooolL40
0oool<3oonfnooo``003ooo``13ooo7100?oonnoooo^_ooolL40oooolL4Voooa`@Cooo721OoolL<5
oooba0Cooo;51?ool/H4oooba`?ooo?80ooollT4ooocbP?ooo?;0_ooll`01?oom<coooC=ooodcOoo
m<d4ooodcP;oooC?0ooom=02oooed@CoooGB0ooomM<2oooee003oooeeOoom]GoooKE00?oooKF0ooo
m]L2oooff0;oooKI0ooommX2ooogf`?oooOL0ooommd00ooommkoooSNooohgP02ooohg`?oooSP0_oo
n>42ooohhP04oooih_oonN?oooWSoooih`?oooWT0_oonND3oooiiP;ooo[W0_oon^P3ooojj@?ooo[Z
0_oon^/00ooonn_ooo_/oookk004oookk@;ooo_^0ooonnl3oooll0?oooca0oooo?83oooll`03oool
m?oooOCooogd00?oooge1?oooOH3ooomm`?ooogh1?ooo_T4ooonnPGoookk0Oooo_`0037ooo7000Co
oo2oooo^__ookKgooo2o6OoolL003?ooj;WoonRhooo`_oool;ooonRhoooZ^ooolL3oonnnooo[^ooo
k[koonfmooo`_aCooo7000Cooo2oooo]_Oooj;Woonbl5_oolL000oookkkoonjnoooa`002oooa`008
ooo^__oojk_ooo70ooo`_ooolL3ooo2oooo___ook;`Aooo__P0<ooo`_oook[koonfmooo[^oooj[_o
onNhooo^__ool;ooonnnooo^__ooj;Soon^k4Oook[h02?oojk_oonfmooo^__ook;coonFfoooQ/ooo
iKKoonZk5Oook[h03?oojK[oonRioooZ^oook;coonJgoooP/_oogk;oonJgoooU]_oojK[oonZkoooY
^Pgoonjn0oookkh04?ool;ooonjnoooY^_ook;coonRhoooW^?ookKgoon2boooS]Oooj;Soon^kooo]
_Oook;coon^kooo___ool;l<ooo__P0?ooo`_ooolL3oon^kooo^__ool;ooonnnooo[^oooiKKoonRi
oooX^?ook[koonnnooo`_oookkkoon^k017ooo7000Soonfmooo`_ooolL3ooo70ooo/_?ooikSoonZk
ooo[^`;ooo7000?oonnnooo`_ooolL003?oolL000oool;ooonfmooo[^`04ooo[^`03ooo/_?oojK[o
onNh00;oonNh00KoonVjooo[^ooojk_oon^koooZ^ooojKX4ooo]_@03ooo___oolL3ooo7000gooo70
00?oonnnooo^__oolL00oooolL0Uoooa`0Kooo710ooolL800oool/;ooo;3ooob``02ooob``Cooo;4
1Oool/D4ooobaP;ooo?71?oollP4ooocb@?ooo?:0_ooll/3ooodc0?oooC=0ooom<h3ooodc`03oood
d?oomM3oooG@00?oooGA0ooomM82oooed`;oooGD1?oom]D2ooofeP?oooKG0ooom]P00ooom]WoooOI
ooogfP02ooogfP;oooOK0ooomm`2ooogg@?oooSN0ooon=l2ooohh0?oooSQ0_oonN83oooih`;oooWT
0ooonND2oooiiP?ooo[W0_oon^P3ooojj@?ooo[Z00?ooo[[oookjooonn/00_oonn`3oookk@?ooo_^
0_oonnl00oooo>ooooc`oooll004oooll@;ooocb0oooo?<01?ooo?Cooogdooomm?oooO@3ooomm@?o
oogf0ooooOL3ooomn004ooonn?ooo_Woookiooonn@Coookj1?ooo_/2ooono000<Oool;l01?ookkko
onblooo]_OookkhIooo`_`;oonRi00[oonnnooo^__ooj;Soon^kooo`_oook[koonZkooo]_Oook;co
onnn5?ool;l01?ookkkoonbloooX^?oojk/Fooo`_`03ooo^__ookKgooo2o00;ooo2o00CoonfmoooZ
^oook[koonjn0_ool;l00oookkkoonblooo`_`0Aooo`_`;oonjn00Coon^koooZ^oooikSoonjn0ooo
l;l00oooj;Woonfmooo`_`0@ooo`_`08ooo]_Oookkkooo2oooo^__ooi[Ooon6coooV]oook;`Eooo`
_`09ooo[^ooojK[oonblooo^__ooikSoon2boooO/_ooikSoonJg00;oon^k00?oonblooo`_oool;l0
3oool;l03Oook[koonVjooo/_?ooj;SoonNhooo]_Ooogk;oonFfoooX^Ooojk_oonfmooo/_?oojk/0
4?ool;l03Oooj[_oonfmooo`_oookkkoonVjoooT]Oooj;SoonNhooo/_?ook[koonnnooo^__ooj;T0
4Oook;`01OoojK[oonblooo/_?ookKgoonRi00;oonFf00?oonRiooo/_?ook;`04?ook;`7ooo^_P05
ooo[^oooj;SoonRioooX^Oook;`00oook[h00oookKgoon^kooo`_`0Cooo`_`03ooo^__ookKgooo2o
0?oooo2o9?ool;l6ooo``0?ooo3100?ooo71oooa`_oolL800_oolL85oooa``Cooo740ooolLD4ooob
aPCooo;70oool/P3ooobb@03ooobb_ooll[ooo?;00?ooo?;0oooll`2ooocc@;ooo?>0_oom<h2oood
c`?oooC@0ooom=42oooddP?oooGC0ooomM@2oooee@?oooGF0ooom]L2oooff0?oooKI0_oom]X00ooo
m]_oooOKooogf`02ooogg0?oooOM0_oommh00ooommooooSOooohg`02ooohh0?oooSQ0_oon>82oooh
h`03oooihooonNCoooWT00?oooWU0ooonNH2oooii`;ooo[X0ooon^T3ooojjP?ooo[[0_oonn`3oook
k@?ooo_^0ooonnl00ooono3oooc`oooll@02oooll@?ooocb0oooo?<2ooolm004ooomm?oooOGoooge
ooomm@Cooogf0ooooOL4ooomn0Coooki0oooo_X4ooonn`7oookl000aooo`_@03ooo__?ook;[oonnl
01[ooo2m0_ooj;L2ooo__008oooX]_ooj[Wooo2mooo^_?ooj[Wooo2mooo]^oookk`Dooo`_@06ooo_
_?ook;[oonRfooo[^Oookkcoonjl5?ool;d01oook[coonfkooo`_Oook[coonnlooo]^oooj[T00_oo
k[`2ooo`_@03ooo__?ook;[ooo2m017ooo2m0_ook[`01?oojkWoonZioooW]_ook[`3ooo`_@03oooX
]oookK_ooo2m013ooo2m00Soonfkooo__?ool;goonjloooV]OoohK7oonJeooo[^AGooo2m00Ooon^i
oooY^?ook;[oonfkoooY^?ooi;?oomn`00;oonNf00?oonZiooo[^Oook[`04Oool;d03Oook[coonVh
ooo/^_ooj;KoonRgooo]^ooogk3oonFdoooX]ooojkWoonfkooo/^_oojkT04?ool;d03oooj[Woonbj
ooo`_Oool;goonVhoooT/oooj;KoonNfooo/^_ook[coonnlooo^_?ooj[Woonnlooo`_@0=ooo__004
ooo`_Oookkcoonbjooo__0;ooo2m00GoonbjoooX]_ooikKoonjlooo`_@0Aooo__0Oooo2m00Goonfk
oooY^?ooj[WoonVhooo^_003ooo`_@03ooo__?ookK_ooo2m01?ooo2m00?oonjlooo]^oool;d0oooo
l;dSooo`_@Kooo2n1?ool;l00ooolKoooo70oooa`003oooa`0Cooo710ooolL84oooa``?ooo;40ooo
l/D4ooobaP?ooo;700?ooo;8ooocb?oollP00ooollT3ooocbP?ooo?;0_ooll`3ooodc@?oooC>0ooo
m<l2ooodd003oooddOoomM7oooGA00?oooGB0_oomM<2oooee0;oooGE00?oooKEooofe_oom]H00ooo
m]L3oooff0;oooKI00CoooOJooogfooomm_oooOK0ooomm`2ooogg@;oooON00?oooSNooohgooon=l0
0ooon>02ooohh@;oooSR0ooonN<3oooii0;oooWU0_oonNH00ooonNOooo[Woooji`03ooojj004oooj
jOoon^[ooo[ZooojjP;ooo[[00Cooo_[oookk?oonncooo_/0_oonnd3oookkP?ooo__0_ooo?03oool
l@?ooocb0oooo?<00oooo?Cooogdooomm003ooomm@Cooogf0ooooOL3ooomn0?oooki1?ooo_X4ooon
n`7oookl000aooo`^P03ooo_^Oook;Oooo2j01[ooo2j0_ooj;@2ooo_^@08oooX/oooj[Kooo2jooo^
^Oooj[Kooo2jooo]^?ookkTDooo`^P06ooo_^Oook;OoonRcooo[]_ook[Woonfh5?ool;X01oook[Wo
onfhooo`^_ookKSoonjiooo]^?ooj[H00_ook[T2ooo`^P03ooo_^Oook;Oooo2j017ooo2j0_ook[T0
1?oojkKoonZfoooW/oook[T3ooo`^P03oooX]?ookKSooo2j013ooo2j00Soonfhooo_^Oool;[oonji
oooV/_oohJkoonJbooo[]QGooo2j00OoonbgoooY]OoojkKoonfhooo^^Oooi[;oomn]00;oonRd00?o
onZfooo[]_ook[T04Oool;X03Oook[WoonVeooo/]oooj;?oonVeooo]^?oogjgoonFaoooX]?oojkKo
onfhooo/]ooojkH04?ool;X03Oooj[Koonbgooo`^_ool;[oonVeoooT/Oooj;?oonNcooo/]oook[Wo
onniooo^^Oooj[H04Oool;X02?ook;Ooonniooo`^_ool;[oonjioooZ]_ooj;Coonni6Oool;X01Ooo
kKSoonVeoooY]OoojKGoonfh00?ooo2j00?oonniooo/]oool;X04oool;X00oook[Woonfhooo`^P3o
ooo`^R?ooo2j1oool;/3ooo`_003oooa_?oolKgooo6m00;ooo6m1?oolKh4oooa_`?ooo7000?ooo71
ooob`Oool/400oool/84ooob``;ooo;40oool/D4ooocaP;ooo?70ooollP3ooocb@03ooocb_oom<[o
ooC;00;oooC;0_oom<`3ooodc@;oooC>00?oooC?oooecooomLl00ooomM001?oomM7oooGBoooed_oo
mM82oooed`03ooofdooom]CoooKE00;oooKE0_oom]H3ooofe`03oooff?oommSoooOI00;oooOI0_oo
mmX2ooogf`;oooOL0ooon=d2ooohgP?oooSO0_oon>001?oon>7oooWQoooih_oonN83oooih`;oooWT
0ooonND2ooojiP;ooo[W0ooon^P2ooojj@;ooo[Z00?ooo_Zoookjooonn/00ooonn`3oookk@;ooo_^
00?ooo__ooolkoooo>l00_ooo?04oooll@;ooocb0_ooo?<3ooomm0?oooge0ooooOH4ooomm`;ooogh
1?ooo_T5ooonnP?oookk000aooo`^P03ooo_^Oook;Oooo2j01[ooo2j0_oojKD2ooo_^@08oooX/ooo
j[Kooo2jooo^^Oooj[Kooo2jooo]^?ookkTDooo`^P06ooo_^Oook;OoonRcooo[]_ook[Woonfh5?oo
l;X01oook[Woonfhooo`^_ookKSoonjiooo]^?ooj[H00_ook[T2ooo`^P03ooo_^Oook;Oooo2j017o
oo2j0_ook[T01?oojkKoonZfoooW/oook[T3ooo`^P03oooX]?ookKSooo2j013ooo2j00Soonfhooo_
^Oool;[oonjioooV/_oohJkoonJbooo[]QGooo2j00Woonjiooo[]_ook;Ooonjiooo_^Oooj;Coon2^
oooZ]_oojKD00_oojkH00oook[Wooo2jooo`^P0?ooo`^P08ooo^^OoojKGoonbgoooX/ooojKGoonfh
oooO[OooiK42ooo[]P03ooo]^?ook;Ooon^f013ooo2j00WoonZfooo/]oool;[ooo2joooY]Oooi;7o
onRcoooW/oook;L00_ool;X00oook[WoonZfooo`^P0@ooo`^P03ooo/]oookkWooo2j00;ooo2j00?o
on^foooY]OookkT06Oool;X01OookKSoonVeoooY]OoojKGoonfh00?ooo2j00?oonniooo/]oool;X0
4oool;X00oook[Woonfhooo`^P3oooo`^RCooo2j1_ool;/3ooo`_004oooa_?oolKgooo6moooa_@Go
oo6n1?oolKl3oooa`003oooa`Oool/7ooo;100?ooo;21?ool/<3oooba0;ooo;50ooollH3oooca`?o
oo?80ooollT00oooll[oooC:ooodb`02ooodb`;oooC<0ooom<d2ooodcP03ooodcooomLooooG?00?o
ooG@0_oomM42oooedP;oooGC00?oooKCooofe?oom]D00_oom]D2ooofeP?oooKG00?oooKHooogf?oo
mmT00_oommT2ooogfP;oooOK0ooomm`2ooohg@;oooSN0_oon=l3ooohh004ooohhOoonN7oooWRoooi
hP?oooWS0ooonN@01?oonNGoooWVoooji_oon^H3oooji`;ooo[X0_oon^T2ooojjP03oookj_oonn_o
oo_[00?ooo_/0_oonnd3oookkP03oookkoooo>ooooc`00;oooc`1?ooo?42ooollP?ooocc0ooooO@2
ooomm@Cooogf0ooooOL2ooomn0Coooki1?ooo_X4ooonn`00<Oool;T00oookkSoonbfooo`^@0Jooo`
^@0<ooo^^?ooj[Goonnhooo_^?ooj;;oonZeooo`^Oook[SoonZeooo`^OookKOoonnh5?ool;T01_oo
kkSoonbfoooX/_oojkGoonjhooo]]aCooo2i00Ooonjhooo]]oool;Woonbfooo_^?ookKOoonZe00;o
onjh00Cooo2iooo_^?ookKOoonfg4_ool;T2ooo^^004ooo[]Oooj[GoonNbooo^^0?ooo2i00?oonRc
ooo]]oool;T04?ool;T02?ookKOoonnhooo`^Oook[SoonJaoooQ[Oooi[7oon^e5Oool;T01oookKOo
onbfooo]]oook[Sooo2ioooZ]OoohZh00_ooj[D00oook[Soon^eooo^^00Aooo`^@0=ooo^^?oojKCo
onbfoooX/_oojKCoonfgoooO[?ooi[7oonbfoooZ]OookkSoonfgooo[]@0@ooo`^@09oooZ]Oook;Ko
oo2iooo`^OoojKCoonB`oooX/_ooik;oonbf00;ooo2i00?oonjhoooZ]Oool;T04?ool;T00oook;Ko
onnhooo`^@02ooo`^@03ooo[]OoojKCoonnh01Wooo2i00GoonfgoooY]?oojKCoonVdooo]]`03ooo`
^@03ooo_^?ook;Kooo2i01?ooo2i00?oonjhooo]]oool;T0ooool;TTooo`^@Kooo2j1?ool;/4oooa
_0Cooo6m0ooolKh4oooa_`03oooa`?ool/3ooo;000;ooo;11?ool/83ooob``;ooo;40_ool/D2oooc
a@?ooo?60_oollL3ooocb0;ooo?90ooom<X3ooodb`;oooC<0ooom<d01?oom<koooG>oooecooomLl3
oooed0;oooGA0_oomM800ooomM?oooKCooofd`02ooofe0;oooKE0ooom]H2ooofe`;oooOH0ooommT3
ooogfP03ooogfooommcoooOL00?oooSM0_oon=h2ooohg`;oooSP00?oooSQoooihOoonN400ooonN80
1?oonN?oooWToooii?oonN@2oooii@03ooojiOoon^Kooo[W00?ooo[W0_oon^P2ooojj@03ooojj_oo
nn[ooo_Z00;ooo_[0_oonn`3oookk@;ooo_^00?ooo__ooolkoooo>l00oooo?02oooll@?ooocb0ooo
o?<3ooomm0?oooge1?oooOH2ooomm`;ooogh00CoookhooonnOooo_Woooki1?ooo_X4ooonn`00<Ooo
kkP00oook[Ooon^eooo_^00Jooo_^00<ooo^]ooojKCoonjgooo^]oooik;oonVdooo_^?ookKOoonVd
ooo_^?ook;Koonjg5?ookkP01_ook[Ooon^eoooW/_ooj[Coonfgooo/]QCoonnh00Ooonfgooo/]_oo
k[OoonVdooo^]oook;KoonVd00;oonfg00Coonnhooo^]ooojkGoonbf4_ookkP01_ookKOoonbfooo/
]_ook;KoonNbooo]]`?oonnh00?oonRbooo/]_ookkP04?ookkP02?ook;Koonjgooo_^?ookKOoonF`
oooP[?ooiK3oonZd5OookkP01oook;Koon^eooo]]oookKOoonnhoooY]?oohZh00_oojkD00oookKOo
onZdooo]]`0Aooo_^00=ooo]]oooj;?oon^eoooW/_ooj;?oonbfoooO[?ooiK3oonnhooo[]OookkSo
onbfoooY]00@ooo_^009oooY]?oojkGoonnhooo_^?ooj;?oon>_oooW/_ooi[7oon^e00;oonnh00?o
onfgoooY]?ookkP04?ookkP00ooojkGoonjgooo_^002ooo_^003oooZ]?ooj;?oonjg01Woonnh00Go
onbfoooX/oooj;?oonRcooo/]P03ooo_^003ooo^]ooojkGoonnh01?oonnh00?oonfgooo/]_ookkP0
ooookkPTooo_^0Goonni0oookkX00oool;[ooo2kooo`^`03ooo`^`Cooo2l0_ool;d4ooo`_P?ooo6o
1?oolL03oooa`@;ooo720_oolL<2ooob``;ooo;40oool/D3ooobaP;ooo;70ooollP2ooocb@?ooo?:
0_ooll/2ooocc003ooodc?oom<goooC=00?oooC>0_oom<l2ooodd0?oooGA0_oomM82oooed`?oooGD
0_oom]D2ooofeP?oooKG0_oom]P2oooff@;oooOJ0ooomm/2ooogg0;oooOM0_oon=h2ooohg`?oooSP
0_oon>42ooohhP?oooWS0_oonN@2oooii@?oooWV0_oon^L3ooojj004ooojjOoon^[ooo[ZooojjP;o
oo[[0ooonn`3oookk@;ooo_^0ooonnl2oooll0?oooca0oooo?82oooll`;ooocd0_oooO@2ooomm@Co
oogf0ooooOL3ooomn0?oooki1?ooo_X3ooonn`00<OookkD00oook[Coon^booo_]@0Jooo_]@0<ooo^
]?oojK7oonjdooo^]?ooijooonVaooo_]OookKCoonZaooo_]OookKCoonjd5?ookkD01_ookKCoon^b
oooW[oooj[7oonfdooo//aCoonne00Ooonfdooo//oookkGoonVaooo^]?ook;?oonVa00;oonfd00Co
onneooo^]?oojk;oonbc4_ookkD01_ookKCoonbcooo//oookKCoonR`ooo]]0?oonne00?oonR_ooo/
/oookkD04?ookkD02?ook;?oonjdooo_]OookKCoonF]oooPZ_ooiJgoonZa5OookkD01oook;?oon^b
ooo]]?ook;?oonneoooY/OoohJX00_ook;<00oookKCoonZaooo]]00Aooo_]@06ooo]]?ooj;3oon^b
oooW[oooj;3oonfd0_ooiJd01OookkGoon^booo_]Oook;?oonVa013oonne00WoonVaooo[/_ookkGo
onneoooX/?oohjcoonN_oooV[_oojk800_ookkD00oookKCoonVaooo_]@0@ooo_]@03ooo[/_ook[Co
onne00;oonne00?oon^boooY/Oook[@06OookkD01Oook;?oonR`oooX/?ooj;3oonbc00?oonne00?o
onjdooo[/_ookkD04oookkD00oookKCoonbcooo_]@3oooo_]BCoonne1OookkH3ooo_]`03ooo`]ooo
l;Sooo2h00?ooo2h0_ool;T3ooo`^PGooo2k00?ooo2loooa_?oolK`00ooolKd3oooa_P?ooo6o0_oo
lL03ooob`@;ooo;20oool/<3oooba0;ooo;50ooollH2oooca`?ooo?80_oollT3ooodbP03ooodbooo
m<coooC<00?oooC=0_oom<h3oooec`;oooG@0_oomM42oooedP;oooGC00?oooKCooofe?oom]D00_oo
m]D2ooofeP;oooKG00CoooKHooogf?oommWoooOI0ooommX01?oomm_oooOLooogg?oomm`2ooohg@;o
ooSN0ooon=l01?oon>3oooSQooohhOoonN42oooihP?oooWS00CoooWToooiiOoonNGoooWU0_oon^H3
oooji`;ooo[X00Cooo[Yooojj_oon^[ooo_Z0_oonn/3oookk0;ooo_]0ooonnh00ooonnooooc_oool
l003oooll0;oooca00?ooocbooolloooo?<00_ooo?<2ooomm0?oooge0ooooOH4ooomm`03ooomn?oo
o_Soookh00?oooki0oooo_X3ooonn`00<Oookk<00oook[;oon^`ooo_/`0Jooo_/`07ooo^/_oojJoo
onjbooo^/_ooijgoonV_ooo_/`02ooo//AOoonnc00Koon^`oooZ[oooijgoonZ_ooo]/_ook;4Dooo_
/`07ooo]/_ook;7oonncoooY[oook[;oonbaoooY[`02ooo]/P04ooo_/oook[;oon^`ooo//A;oonnc
00Goonfbooo//Oook;7oonbaoooW[@02ooo]/P04ooo^/_ookk?oonR]ooo//A7oonnc00Soonbaooo^
/_ookk?oonfboooUZoooh:SoonF[oooZ[aGoonnc00coonbaooo[/?ookK;oonjbooo_/ooojk3oonF[
ooo^/_ook;7oonfboooZ[oookK8Aooo_/`0=ooo]/_ooj:koon^`oooZ[ooojJooonbaoooV[?ooiJ_o
onncooo[/?ookk?oonbaoooY[`0@ooo_/`09oooY[ooojk3oonncooo_/oooj:koon>ZoooW[OooiZco
on^`00;oonnc00?oonfboooY[oookk<04?ookk<00ooojk3oonjbooo_/`02ooo_/`03ooo//Ooojk3o
onjb00;oonjb5_ookk<00oook[;oon^`oooX[P02oooX[P06ooo//Oookk?oonncooo_/oook[;oon^`
5?ookk<00oookK;oonbaooo_/`3oooo_/bCoonnc1Oookk@3ooo_]@04ooo`]Oool;Kooo2fooo`]PCo
oo2g0oool;P4ooo`^@;ooo2j00Cooo6joooa^ooolK_ooo6k0_oolK`4oooa_@;ooo6n00?ooo6oooob
_oool[l00oool/02ooob`@?ooo;20_ool/<2oooca0?ooo?50_oollH2oooca`;ooo?800?oooC8oood
bOoom<T00_oom<X3ooodb`;oooC<00CoooC=oooec_oomLkoooG>0_oomLl2oooed0;oooGA00?oooGB
ooofd_oom]800_oom]<2ooofe0;oooKE0ooom]H2oooge`04ooogf?oommWoooOIooogf@;oooOJ0_oo
mm/2ooohg0;oooSM0_oon=h2ooohg`;oooSP0ooonN401?oonN;oooWSoooihooonN<2oooii004oooi
iOoon^Gooo[UooojiP?ooo[W0_oon^P2ooojj@;ooo_Z0_oonn/3oookk0;ooo_]0ooonnh2ooolk`?o
ooc`0_ooo?44ooollP04ooollooooO?ooogdooomm0?oooge0ooooOH2ooomm`;ooogh0_ooo_P3ooon
n@?oookj0oooo_/0037oonnc00?oonjbooo[/?ookk<06oookk<01_oojk3oonjbooo^/_ooijgoonV_
ooo_/`;oonfb5oookk<01_oojk3oonZ_oooW[OoojZooonfbooo//ACoonnc00Ooonfbooo//Oookk?o
onV_ooo^/_ook;7oonV_00;oonfb00Coonncooo^/_oojk3oonba4_ookk<02oookK;oonbaooo]/_oo
k;7oonJ/ooo]/_oojk3oonjbooo_/oooj:goonba017oonnc00Soonbaooo^/_ookk?oonfboooUZooo
h:SoonF[oooZ[aGoonnc00?oonbaooo[/?ookK800_ookk<01oook;7oonN]ooo_/oook;7oonfboooZ
[oookK804Oookk<03OookK;oonR^ooo[/?ook;7oonZ_ooo//Oooj:goonJ/ooo_/ooojk3oonncooo/
/OoojJl04?ookk<02OoojJooon^`ooo_/oookk?oonR^oooSZ_ooijgoonJ/ooo[/002ooo_/`03ooo]
/_oojJooonnc013oonnc00?oon^`ooo^/_ookk<00_ookk<01Oook;7oon^`ooo^/_ookK;oonba01Ko
onnc00Koon^`oooX[_ooj:koonJ/oooX[_oojZl3ooo_/`03ooo^/_oojk3oonnc01?oonnc00?oonfb
ooo//Oookk<0ooookk<Sooo_/`Koonnd0_ookkD2ooo`]@Cooo2f1?ool;L2ooo`^0Cooo2i00Cooo2j
oooa^_oolK[ooo6j0_oolK/2oooa_0Cooo6m0ooolKh2ooob_`;ooo;00oool/43ooob`P;ooo;30ooo
ll@2oooca@?ooo?600Cooo?7ooocb?oollSoooC80_oom<T2ooodbP?oooC;0_oom<`01?oom<goooG=
oooec_oomLh2oooec`;oooG@0ooomM42ooofdP;oooKC0_oom]@2ooofe@;oooKF0_oommL2ooogf0?o
ooOI0_oommX2ooogf`;oooSL0_oon=d2ooohgP;oooSO0_oon>02oooih@?oooWR0_oonN<2oooii004
oooiiOoon^Gooo[VooojiP?ooo[W0_oon^P2ooojj@?ooo_Z0_oonn/2oookk0?ooo_]0_oonnh2oool
k`?oooc`0_ooo?43ooollP;ooocc00?ooogcooomm?oooO@00ooooOD3ooommP;ooogg0ooooOP2ooon
n0;oooki0oooo_X3ooonn`00<Oook[400oookK3oonZ^ooo^/@0Kooo^/@05ooo[[oookK3oonf`oooV
Zoooj:d06_ook[42oooZ[P04oooVZooojJkoonf`ooo[[aCoonja00Ooonb`ooo[[oook[7oonR]ooo]
/?oojjooonR]00;oonb`00Coonjaooo]/?oojZkoon^_4_ook[402oook;3oon^_ooo//?oojjooon>Y
oooZ[_oojjooonf`ooo^/Oooij_oon^_017oonja00SoonZ^ooo]/?ook[7oonb`oooTZOoogjKoonBY
oooY[QGoonja00?oonf`ooo[[ooojjl00_ook[401ooojjooonJ[ooo^/Ooojjooonb`oooY[_ook;00
4Oook[400oook;3oonN/oooZ[P02ooo[[`08ooo//?ooij_oonFZooo^/OoojZkoonjaooo[[oooj:d@
ooo^/@09oooX[Ooojjooonjaooo^/Oooijcoon:XoooVZoooiJ[oonZ^00;oonja00?oonb`oooX[Ooo
k[404?ook[400ooojZkoonf`ooo^/@02ooo^/@05ooo[[ooojZkoonf`ooo//?oojjl05_ook[401ooo
jZkoonN/oooW[?ooiJ[oonN/oooX[OookK000_ook[400oookK3oonZ^ooo^/@0Cooo^/@03ooo//?oo
jjooonja0?ooonja8oook[44ooo^/PCoonjc0_ookk<3ooo_]0?oonne1?ookkH4ooo_]`?ooo2h0_oo
l;T3ooo`^P?ooo2k0oool;`2oooa_@?ooo6n0_oolKl2oooa`0;ooo7100?ooo;1ooob`_ool/800ooo
l/<2oooba0?ooo;50_oollH2oooca`;ooo?80ooollT01Oooll[oooC:ooodbooom<_oooC<00?oooC=
0_oom<h2oooec`04oooed?oomM7oooGAoooed@;oooGB0_oomM<3ooofe0;oooKE00CoooKFooofeooo
m]OoooKH0_oommP01?oommWoooOJooogf_oommX2ooogf`;oooOL0_oon=d2ooohgP;oooSO0_oon>00
1?oon>7oooWQoooih_oonN82oooih`;oooWT0ooonND01?oon^Kooo[Wooojiooon^L2ooojj0?ooo[Y
00Cooo[Zoookjooonn_ooo_[0_oonn`3oookk@;ooo_^00?ooo__ooolkoooo>l00_ooo?02oooll@?o
oocb0oooo?<2ooomm0;oooge1?oooOH2ooomm`;ooogh0_ooo_P3ooonn@?oookj0_ooo_/0037oonf`
00?oonb_oooY[OookK006oookK001OoojZkoonb_ooo/[oooiJ[oonN/01[oonf`0_oojJd01?oohjSo
onN/ooo/[ooojZhDooo]/007ooo[[ooojZkoonf`oooW[?ook:ooonZ^oooW[002ooo[[`04ooo]/?oo
k:ooonV]oooZ[Q;oonf`00_oon^_oooZ[_oojZkoon^_oooPY_ooj:goonZ^ooo/[oookK3oonJZoooZ
[P0Aooo]/008oooZ[_ook:ooonf`ooo[[ooohjSoomjUoooSZ?ooj:dFooo]/0;oon^_0_ookK001_oo
jZkoonBYooo]/?oojZkoon^_ooo/[a;oonf`00goon^_oooW[?oojjooonV]ooo]/?ook:ooonJ[oooT
ZOookK3oonV]ooo]/?oojZkoonN/013oonf`00WoonV]ooo[[oookK3oonf`oooVZooohJOoonFZoooT
ZOoojJd00_ookK000ooojjooonN/ooo]/00@ooo]/003oooY[Oook:ooonf`00;oonf`00GoonZ^oooY
[Oook:ooon^_oooZ[P0Fooo]/007oooY[OooiZ_oonJ[oooTZOooiZ_oonN/ooo/[`02ooo]/003ooo/
[ooojJgoonf`01?oonf`00?oon^_oooZ[_ookK00ooookK0Tooo]/0Coonfa1?ookK801?ook[;oonjc
ooo^/oook[<4ooo^]0?oonje0oook[H4ooo_]`;oonnh0oookkT2ooo_^P;oonnk00Cooo2kooo`_?oo
l;cooo2l0_ool;d2ooo`_P?ooo2o00?ooo6ooooa`?oolL400_oolL42oooa`P;ooo7300?ooo74ooob
a?ool/@00_ool/D2ooobaP;ooo;700?ooo;8ooocb?oollP00_oollT2ooocbP;ooo?;0_ooll`2oood
c@;oooC>0_oom<l2ooodd0;oooCA00?oooGAoooed_oomM<00_oomM<01OoomMCoooGEoooeeOoom]Go
ooKF00?oooKG0_oom]P01Ooom]WoooKJooogf_oomm[oooOK00?oooOL00CoooOMooogg_oommkoooSN
0_oon=l2ooohh0;oooSQ0_oon>82oooih`;oooWT0_oonND2oooiiP;oooWW00?ooo[Wooojj?oon^P0
0_oon^T2ooojjP;ooo[[00?ooo_[oookk?oonn`00_oonnd2oookkP;ooo__00Cooo_`oooll?ooo?3o
ooc`0_ooo?42ooollP?ooocc00?ooocdooomm?oooO@00_oooOD3ooommP?ooogg0_oooOP2ooonn0;o
ooki1?ooo_X1ooonn`00<OookJl00oook:koonV/ooo][`0Kooo][`05oooZ[Oook:koonb^oooUZOoo
ij/06_ookJl2oooY[004oooSYoooiZ[oonb^oooZ[ACoonf_00Ooon^^oooZ[OookJooonN[ooo/[_oo
jZgoonN[00;oon^^00Coonf_ooo/[_oojJcoonZ]4_ookJl02ooojjkoonZ]oooX[?oojjkoon6VoooW
ZooojZgoonb^ooo][oooiZ[oonZ]017oonf_00Soonb^ooo][oookJooon^^oooSYooogZCoon>WoooX
[1[oonf_00GoonZ]oooQY_ookJooonZ]ooo[[P02ooo][`03oooZ[Oook:koonf_00koonf_00goon^^
oooWZoook:koonV/ooo][oook:koonN[oooVZ_ookJooonV/ooo][ooojZgoonN[013oonf_00WoonZ]
ooo[[_ookJooonf_oooVZ_oohJKoonFYoooTZ?oojJ`00_ookJl00ooojjkoonN[ooo][`0@ooo][`03
oooY[?ook:koonf_00;oonf_0_oojJ`00oook:koonV/oooZ[@0Fooo][`07oooY[?ooiZ[oonN[oooS
YoooiZ[oonN[ooo/[P02ooo][`03ooo/[_oojJcoonf_01?oonf_00?oon^^oooZ[OookJl0ooookJlS
ooo][`Goonf`1?ookK44ooo^/PCoonjc0oook[@3ooo^]@03ooo^]_ookkKoonnf00?oonng0oookkP3
ooo_^@04ooo_^_ool;[ooo2kooo`^`?ooo2l0oool;d2ooo`_P;ooo6o0_oolL02oooa`@?ooo7200Co
oo73ooob`oool/Cooo;40_ool/D3ooobaP;ooo;70_oollP2ooocb@;ooo?:0_ooll/00ooollcoooC<
ooodc@02ooodc@03ooodc_oom<ooooC?00;oooC@0_oomM43oooedP;oooGC0_oomM@00ooom]GoooKF
ooofeP03ooofe`;oooKH00?oooKIooogfOoommX00_oomm/3ooogg0;oooOM0_oon=h2ooohg`04oooh
h?oon>7oooSQooohhP;oooWR0_oonN<2oooii0;oooWU0_oonNH00ooonNOooo[Wooojj002ooojj006
ooojjOoon^[ooo[Zooojj_oon^_ooo_[0ooonn`2oookk@;ooo_^0_oonnl2oooll0?oooca0oooo?83
oooll`04ooolm?oooOCooogeooomm@?ooogf1?oooOL00ooooOSoookhooonn003ooonn@?oookj0Ooo
o_/0037oonf^00?oonb]oooYZoookJh06oookJh01OoojZcoonb]ooo/[OooiJSoonNZ01[oonf^0_oo
jJ/01?oohjKoonJYooo/[OoojZ`Dooo][P07ooo[[OoojZcoonf^oooWZ_ook:goonZ/oooWZP02ooo[
[@04ooo][_ook:goonV[oooZ[1;oonf^00_oon^]oooZ[?ooij[oon^]oooPY?ooij[oonZ/ooo/[Ooo
kJkoonJYoooZ[00Dooo][P05ooo[[OoohjKoomjSoooSY_ooj:/06_ookJh01OoojZcoon6Uooo][_oo
jZcoon^]00;oonf^00?oonV[ooo/[OookJh03_ookJh03OoojjgoonNZooo/[OoojJ_oonf^ooo/[Ooo
j:_oonNZooo][_oojJ_oonf^oooZ[?ooijX04?ookJh02OoojZcoon^]ooo][_ookJkoonJYoooQYOoo
iJSoonBWoooYZ`02ooo][P03ooo[[Oooij[oonf^013oonf^00?oonV[ooo/[OookJh00_ookJh01Ooo
j:_oonJYooo/[Oooij[oonZ/01Koonf^00?oonV[oooVZOooijX00_oohJD01_ooij[oonb]ooo][_oo
kJkoonb]oooYZaCoonf^00?oon^]oooZ[?ookJh0ooookJhSooo][PGoonf_1?ookK05ooo^/@;oonjb
0oook[<3ooo^]003ooo^]OookkGoonne00?oonnf0oookkL4ooo_^004ooo_^Oool;Wooo2jooo`^P?o
oo2k0_ool;`2ooo`_@03ooo`__oolKkooo6o00?ooo6o00?ooo70oooa`OoolL400_oolL83ooob``;o
oo;40_ool/D2ooobaP;ooo?70_oollP2ooocb@;ooo?:0oooll/2ooodc0;oooC=00GoooC>ooodcooo
m<ooooC?oooed003oooed@05oooed_oomM?oooGCoooedooomM@00ooom]D2ooofeP05ooofeooom]So
ooKHoooffOoommT00ooommX2ooogf`;oooOL00?oooOMooohg_oon=h00_oon=l2ooohh0?oooSQ00?o
ooWRoooihooonN<00_oonN@2oooii@?oooWV0_oon^L2ooojj0;ooo[Y0_oon^X00ooon^_ooo_[oook
j`02oookk0;ooo_]0ooonnh01?oonnooooc_oooll?ooo?03oooll@;ooocb0oooo?<2ooomm0?oooge
0_oooOH3ooomm`?ooogh00?oookhooonnOooo_T00oooo_X2ooonn`00<Oook:`00ooojj_oonRYooo/
[00Kooo/[005oooYZ_oojj_oon^[oooTY_ooiZP06_ook:`2oooXZ@04oooRYOooiZOoon^[oooYZQCo
onb/00OoonZ[oooYZ_ook:coonJXooo[ZooojJ[oonJX00;oonZ[00Coonb/ooo[Zoooj:WoonVZ4_oo
k:`02ooojZ_oonVZoooVZ?oojZ_oomjRoooVZ?oojJ[oon^[ooo/[?ooiJOoonVZ01Coonb/00GoonZ[
oooSYOoohJCoon:UoooWZ@0Jooo/[005oooYZ_ooh:?oonb/oooYZ_oojZ/00_ook:`00oooj:Woon^[
ooo/[00>ooo/[00=oooZZoooiZSoon^[oooXZOook:coon^[oooWZOooiZSoonb/oooXZOook:coonVZ
oooVZ00@ooo/[009oooYZ_oojZ_oonb/ooo/[?ooiZOoomnSoooTY_oohjGoonRY00;oonb/00?oonZ[
oooVZ?ook:`04?ook:`00oooj:Woon^[ooo/[002ooo/[005oooWZOooiZOoon^[oooWZOoojJX05_oo
k:`01oooj:WoonJWoooVZ?ooh:?oomnSoooXZOoojj/00_ook:`00ooojj_oonRYooo/[00Cooo/[003
oooZZooojJ[oonb/0?ooonb/9?ook:`3ooo/[@?oonb^0_ookJh4ooo][`;oonf`1?ookK43ooo]/P03
ooo]/oook[?oonjc00?oonjd0oook[D2ooo^]P03ooo^]oookkOoonng00;oonnh0oookkT2ooo_^P04
ooo_^oool;_ooo2looo`_0?ooo2m0_ool;h2ooo`_`03ooo``?oolL3ooo7100;ooo710_oolL82oooa
``04oooaa?ool/Cooo;5oooba@;ooo;60_ool/L2ooobb0;ooo?90_oollX2ooocb`;ooo?<00Cooo?=
ooodcOoom<koooC>0_oom<l2ooodd004oooddOoomM7oooGBoooedP;oooGC0_oomM@00ooomMGoooKF
ooofeP02ooofe`;oooKH0_oom]T01?oom][oooOJooogfooomm/2ooogg0;oooOM0_oommh2ooohg`;o
ooSP0_oon>42ooohhP;oooWS0_oonN@2oooii@;oooWV00CoooWWooojiooon^Sooo[X0_oon^T3oooj
jP04ooojjooonn_ooo_/oookk0;ooo_]0_oonnh2oookk`03oookl?ooo?3oooc`00;oooca0oooo?82
oooll`;ooocd00?ooogdooommOoooOD00ooooOH3ooomm`?ooogh0oooo_T3ooonnP7oookk000aooo[
ZP03oooZZOooijOoon^Z01_oon^Z00GoonRXoooZZOoojZWoon>ToooUYP0Jooo[ZP;oonNW00Coon6S
oooUYOoojZWoonRX5?oojjX01ooojJWoonRXooo[Z_ooiJKoonZYoooXZ?ooiJH00_oojJT01?oojj[o
onZYoooWYoooj:PBooo[ZP0;oooYZOooj:SoonFVoooYZOoogZ7oonFVoooXZ?oojZWoon^ZoooTYOoo
j:P05?oojjX01OoojJWoonBUoooSY?oohZ?oonJW01[oon^Z00GoonRXoooOXOoojj[oonRXoooYZ@02
ooo[ZP03oooWYooojZWoon^Z00koon^Z00goonVYoooUY_oojZWoonNWooo[Z_oojZWoonJWoooUY_oo
jj[oonNWooo[Z_ooj:SoonFV013oon^Z00WoonRXoooYZOoojj[oon^ZoooWYoooh:;oon>ToooRXooo
ijL00_oojjX00ooojJWoonFVooo[ZP0@ooo[ZP03oooWYooojZWoon^Z00;oon^Z00GoonJWoooUYOoo
jZWoonJWoooXZ00Fooo[ZP07oooWYoooiJGoonFVoooOXOoogZ7oonRXoooZZ@02ooo[ZP03oooZZOoo
ijOoon^Z01?oon^Z00?oonVYoooXZ?oojjX0oooojjXTooo[ZPCoon^[0ooojj`01?ook:coonb]ooo/
[Oook:d4ooo/[P;oonb_1?ook;03ooo]/@;oonfb0oookK<3ooo]]0;oonje0oook[H2ooo^]`;oonjh
00?oonjiooo_^OookkT00_ookkX2ooo_^`;oonnl0_ookkd00oool;gooo2nooo`_`02ooo`_`;ooo30
0_ool<401?oolL;ooo73oooa`ooolL<2oooaa0;ooo750_ool/H2oooba`;ooo;800?ooo;9ooobb_oo
llX00_ooll/3ooocc0;ooo?=00?ooo?>ooodcooom<l00_oom=02ooodd@;oooCB0_oomM<2oooee0;o
ooGE00?oooGFooofeooom]L00_oom]P2oooff@;oooKJ00?oooKKooogg?oomm`00ooommd00ooommko
ooOOooogg`02ooohh0;oooSQ0ooon>82ooohh`03oooii?oonNGoooWU00?oooWV00GoooWWooojj?oo
n^Sooo[Xooojj@02ooojjP?ooo[[0_oonn`2oookk@?ooo_^00Cooo__oookl?oono3oooc`0_ooo?43
ooollP;ooocc0_ooo?@3ooomm@?ooogf0_oooOL3ooomn0Coooki0_ooo_X1ooonn`00<OoojjT00ooo
jZSoonNVooo[Z@0Kooo[Z@05oooXYooojZSoonZXoooSXoooiJD06_oojjT2oooWYP04oooQX_ooiJGo
onZXoooXYaCoon^Y00OoonVXoooXYooojjWoonFUoooZZ?ooj:OoonFU00;oonVX00Coon^YoooZZ?oo
ijKoonRW4_oojjT02ooojJSoonRWoooUYOoojJSoomnPoooVY_ooj:OoonZXooo[ZOoohj?oonRW01Co
on^Y00GoonVXoooVY_ooiJCoon>SoooWYP0Jooo[Z@05oooWY_oogj3oon^YoooXYooojJP00_oojjT0
0oooijKoonZXooo[Z@0>ooo[Z@04oooYZ?ooiJGoonZXoooWYP;oon^Y00OoonNVoooUYOoojjWoonNV
ooo[ZOooj:OoonJV013oon^Y00WoonRWoooYZ?oojjWoon^YoooZZ?oohj?oonBToooRX_ooijH00_oo
jjT00ooojJSoonFUooo[Z@0@ooo[Z@03oooWY_oojZSoon^Y00;oon^Y00GoonJVoooUY?oojZSoonJV
oooXY`0Fooo[Z@07oooWY_ooiJCoonFUoooOX?oogZ3oonRWoooZZ002ooo[Z@03oooZZ?ooijKoon^Y
01?oon^Y0_oojZSoooo[ZBGoon^Y1OoojjX2ooo[Z`04ooo/Zoook:coonb/ooo/[0?oonb]1?ook:h3
ooo/[`?oonf`0_ookK43ooo]/P?oonfc0_ook[@2ooo^]@?oonjf00Coonjgooo^^?ook[Soonnh0_oo
kkT2ooo_^P;oonnk0_ookk`3ooo`_@;ooo2n0_ool;l2ooo``0;ooo710_oolL82oooa``;ooo7400Co
oo75ooobaOool/Kooo;60_ool/L2ooobb004ooobbOoollWooo?:ooocbP;ooo?;0_ooll`2ooocc@03
ooodc_oom<ooooC?00;oooC@0_oom=401Ooom=;oooGBoooedooomM?oooGD00;oooGE00CoooGFooof
e_oom]OoooKG0_oom]P2oooff@;oooKJ00?oooOKooogg?oomm`00_oommd2oooggP04oooggooon=oo
ooSPooohh0;oooSQ0_oon>801?oon>?oooWSoooii?oonN@2oooii@;oooWV00CoooWWooojiooon^So
oo[X0_oon^T2ooojjP;ooo[[0ooonn`2oookk@;ooo_^0_oonnl01?oono3oooc`oooll?ooo?42oool
lP?ooocc0oooo?@2ooomm@?ooogf0_oooOL3ooomn0Coooki0oooo_X0037oon^X00?oonZWoooWYOoo
jjP06ooojjP01Oooj:KoonZWoooZYooohj;oonJU00koon^X00?oonVWoooWYOooj:H02Oooj:H2oooU
X`04oooOWooohj;oonNUoooUY1;oonRV00WoonNUoooYYooojJOoonRVooo[Z?ooiJCoonZWoooXY_oo
iJ@00_oojJL01?oojjSoonZWoooWYOooj:HAooo[Z00<oooZYooojJOoonRVoooVYOooijGoombMoooW
YOooj:KoonZWooo[Z?ooi:?oonRV5?oojjP01OoojJOoonJUoooUXoooi:?oonRV01[oon^X00GoonFT
oooPX?oojjSoonRVoooYY`02ooo[Z003oooWYOoojZOoon^X00koon^X00CoonVWoooUY?oojZOoonRV
0_oojjP01ooojJOoonFSooo[Z?ooijGoon^XoooZYoooijD04?oojjP01Oooj:KoonVWooo[Z?oojjSo
onZW00;oonFS00Koon6QoooWYOoojjSoon^XoooYYoooiJ@Aooo[Z003oooWYOoojZOoon^X00;oon^X
00GoonNUoooSX_oojJOoonJUoooXYP0Fooo[Z007oooWYOooiJ?oonFToooOWooogYooonRVoooZY`02
ooo[Z003oooZYoooijGoon^X0?ooon^X>_oojjP3ooo[Z@?oon^Z0_ook:X3ooo/Z`Coonb/0oook:d3
ooo/[P;oonf_0oookK02ooo]/@?oonfb00Coonfcooo^/oook[?oonjd0oook[D2ooo^]P;oonjg00?o
onngooo_^?ookkP00_ookkT2ooo_^P;oonnk0oool;`2ooo`_@03ooo`__ool;oooo2o00;ooo300_oo
lL42oooa`P;ooo730_oolL@01?ool/Cooo;5oooba_ool/H2oooba`?ooo;800?ooo?9ooocb_oollX0
0_ooll/00ooollcooo?=ooocc@02ooodcP;oooC?0_oom=02ooodd@;oooGB0_oomM<00ooomMCoooGE
oooee@02ooofeP;oooKG0_oom]P2oooff@03oooff_oomm[oooOK00;oooOL0_oommd2oooggP;oooSO
00KoooSPooohhOoon>7oooSQooohh_oon><2oooih`03oooii?oonNGoooWU00;oooWV00?oooWWoooj
iooon^P00_oon^P00ooon^Wooo[ZooojjP03ooojj`04oookk?oonngooo_]oookk@;ooo_^0ooonnl2
oooll0;oooca0oooo?82oooll`03ooolm?oooOCooogd00;oooge0ooooOH3ooomm`;ooogh0_ooo_T3
ooonnP7oookk000aoooZY`03oooYY_ooiZCoonZW01_oonZW00KoonNUoooXY_ooiZCoon2PoooTX_oo
j:H:oooWY@03oooXY_oojZOoonZW00coonVV0_ooiJ@01?ooh:3oonBRoooXY_ooiZ@EoooYYP06oooW
YOoojZOoonBSoooYY_ooijGoonBS0_ooj:H01?oojZOoonVVoooWYOooijD@oooZY`08oooYY_ooijGo
onRVoooWYOooiJCoonJToooKWOooijD2oooVY003oooZYoooiJCoonNU01CoonZW00GoonVVoooWYOoo
i:;oon>RoooWY@0IoooZY`06oooYY_ooi:?oon:QoooZYoooijGoonRV0_oojZL00oooijGoonVVoooZ
Y`0>oooZY`03oooXY_ooi:?oonZW00?oonZW00CoonRVoooTXooojZOoonNU0_oojZL00oooijGoonZW
oooZY`0>oooZY`05oooWYOooj:KoonZWoooZYooojJH00_ooi:<01_ooi:;oonNUoooZYooojZOoonRV
oooTXa7oonZW00?oonJToooYY_oojZL00_oojJH01OooiJCoon2PoooXY_ooiJCoonNU01KoonZW00Oo
onJToooTX_ooiZCoomjNoooMW_ooijGoonVV00;oonZW00?oonVVoooWYOoojZL0oooojZLioooZY`Go
onZX0ooojZT00ooojjWoon^Zooo[ZP02ooo[ZP?oon^[0_oojj`2ooo[[@Coonb^0_ook:l3ooo//0?o
onba0_ookK82ooo]/`?oonfd0_ookKD2ooo^]P;oonjg0oook[P2ooo^^@04ooo^^_ookk[oonnkooo_
^`;oonnl0_ookkd01?ookkkooo2nooo`_oool;l2ooo``0;ooo3100?ooo32oooa`_oolL<00ooolL@2
oooaa@;ooo760_ool/L00oool/Sooo;9ooobb@02ooobbP03ooocbooollcooo?<00?ooo?=00Gooo?>
oooccooom<ooooC?ooodd002ooodd@;oooCB00?oooGCoooee?oomM@00_oomMD2oooeeP04oooeeooo
m]OoooKHoooff0;oooKI00KoooKJoooffooomm_oooOKooogg?oommd2oooggP;oooOO0ooon>000ooo
n>7oooSRooohhP02ooohh`04ooohi?oonNCoooWToooii@;oooWV00CoooWWoooij?oonNSooo[X0_oo
n^T2ooojjP;ooo[[0_oon^`3oookk@;ooo_^0_oonnl01?oono3ooocaooollOooo?42ooollP?ooocc
0_ooo?@3ooomm@?ooogf0ooooOL2ooomn0?oooki0_ooo_X1ooonn`00<OoojZL00ooojJKoonJToooZ
Y`05oooZYaKoonRV00KoonFToooWYOooiJCoomnOoooSX_ooijD:oooVY003oooWYOooj:KoonRV00So
onRV1?oojJH2oooUY004oooPX?ooi:;oonRVoooVY0WoonVV2oooj:H01oooijGoonFToooVY?ooh:3o
on>RoooRXOooh:000_oohj801?ooi:?oon>RoooQX?oohZ44oooTXP03oooUY?ooj:KoonRV00WoonRV
00OoonNUoooUY?ooijGoonFToooTX_ooi:?oomZL00;oonFT00CoonBSoooYY_ooi:?oonJT5Oooj:H0
1?ooiZCoon>RoooRXOooiJ@JoooXYP09oooSX_oohJ3oonRVoooVY?ooijGoonVVoooXY_ooiJCoonNU
00ooonRV00?oonJToooTX_ooj:H00oooj:H01?ooiZCoon>RoooXY_ooiJ@2oooXYP03oooUY?ooj:Ko
onRV00koonRV00?oonFToooWYOooj:H00_ooj:H01?ooiJCoon>RoooSX_ooiJ@2oooXYP05oooVY?oo
i:;oonRVoooXY_oojJH03_oojZL00oooiZCoonVVoooXYP02oooVY005oooTX_oogIkoonNUoooTX_oo
iJ@05_ooj:H01oooi:?oon>RoooVY?oogIkoombMoooUY?ooj:H00_ooiZ@00oooijGoonFToooXYP0P
oooXYP03oooYY_oojZOoonZW0?ooonZW5ooojZL3oooZZ0CoonZY00?oon^Yooo[Z_oojjX00_oojjX3
ooo[Z`;oon^/0ooojjd3ooo/[P;oonb_0oook;03ooo//@;oonfb0oookK<2ooo]]0?oonfe00Goonjf
ooo^]oook[Ooonjgooo^^003ooo^^@04ooo^^_ookk[oonnkooo_^`;oonnl0_ookkd01?ookkkooo2n
ooo`_oool;l2ooo``0;ooo3100Cooo32oooa`_oolL?ooo730_oolL@2oooaa@;ooo760_ool/L00ooo
l/Sooo;9ooobb@02ooobbP;ooo?;0_ooll`2ooocc@;ooo?>00?oooC?ooodd?oom=000_oom=42oood
dP03oooddooomMCoooGD00;oooGE0_oomMH01OoomMOoooKGoooff?oom]SoooKI00?oooKJ00CoooKK
ooogg?oommcoooOM0ooommh01OoommooooSPooohh?oon>3oooSQ00?oooSR00?oooSSooohi?oonN@0
0_oonND2oooiiP;oooWW00CoooWXooojj?oon^Wooo[Y0_oon^X2ooojj`;ooo[/0_oonnd3oookkP;o
oo__00Cooo_`ooollOooo?7oooca0oooo?82oooll`;ooocd0ooooOD2ooommPCooogg0_oooOP3ooon
n@;oookj0Oooo_/0037oonZU00?oonVToooVX_oojZD01OoojZD@oooXY003oooVX_ooiJ;oonFR00;o
onFR00KoonJRoooTX?ooi:7oonBQoooOWOoohYl8oooVXPkoonRT0oooiZ802?ooij?oonBPoooTX?oo
gYgoon:OoooVX_ooi:7oonNS2?ooiZ8;oooXY007oooWXoooiJ;oonJRoooRWoooiJ;oonBQoooRW`02
oooTX@04oooVX_ooiJ;oonBPoooTX0?oonJR00?oonFRoooVX_ooij<00oooj:@00oooij?oonFRoooU
XP05oooUXP07oooTX?ooi:7oon>PoooRWooohj3oomVIoooTX002oooSX004oooVX_oohYooonBPoooV
XQ7oonFR00OoonNSoooXY?ooj:CoonFRoooTXOoohYooonFR01WoonRT00[oonNSoooSX?oohIooonRT
oooUX_ooiZ;oonNSoooXY?ooiJ;oonNS3oooj:@00oooiZ;oon>PoooXY003oooXY004oooVX_oohj3o
onRToooUXP;oonRT00?oonFRoooXY?ooj:@02_ooj:@02_ooiZ;oonFRoooUX_ooiZ;oonBPoooTXOoo
iZ;oonFRoooVX_ooi:02oooQW`08oooTX?ooiZ;oonJRoooTXOooi:3oonJRoooUX_ooiZ88oooWX`Ko
onRT00?oonBPoooUX_ooiZ800_ooi:401ooohYooombKoooUX_oohYooonBPoooTXOooiJ804_ooiZ80
3_ooiJ;oonJRoooSX?oohIooonBQoooLVooofY[oon:OoooUX_ooi:7oonBPoooUX_ooi:7oonJR2?oo
iJ800oooiZ;oonRToooXY00EoooXY003oooYY?oojZGoonZU0?ooonZU5ooojZD4oooZYP?oonZW00?o
on^Wooo[Z?oojjP00ooojjT4ooo[ZP;oon^[1?ook:`2ooo/[@;oonb^0oook:l00oook;3oonf`ooo]
/002ooo]/@;oonfb0oookK<2ooo^]004ooo^]Oook[Koonjfooo^]P;oonjg0_ook[P01?ookkSoonni
ooo_^_ookkX2ooo_^`;oonnl0_ool;d2ooo`_P;ooo2o0_ool<001?oolL7ooo72oooa`_oolL82oooa
``;ooo7400?ooo75oooba_ool/L00_ool/L2ooobb0;ooo;900?ooo?:ooocboooll/00_ooll`00ooo
llgooo?>ooodcP02ooodc`;oooC@0_oom=400ooom=;oooGCoooed`02oooee0;oooGE00GoooGFooof
eooom]OoooKGoooff002oooff@;oooKJ00?oooOKooogg?oomm`00_oommd01?oommkoooOOoooggooo
n=l2ooohh0;oooSQ0_oon>800ooon>?oooWSoooii002oooii@;oooWV0_oonNL2ooojj0;ooo[Y0_oo
n^X2ooojj`;ooo_/0_oonnd2oookkP?ooo__00Coooc`ooollOooo?7oooca0_ooo?83oooll`;ooocd
0_oooOD2ooommP?ooogg0ooooOP4ooonn@;oookj000aoooZX`03oooYX_ooiZ3oonZS01_oonZS00Go
onNQoooYX_oojJ;oon>NoooUX00EoooZX`03oooYX_ooiZ3oonJP00;oonJP0_oohih01?oogY_oon:M
oooUX?ooi9l2oooVX003oooWXOooj:;oonRR00CoonRR1OoojZ<6oooYXP07oooXX_ooiZ3oonVRoooT
WooojJ;oonNQoooTW`02oooXXP04oooZXoooj:;oonJPoooVX13oonZS00SoonVRoooWXOoojJ;oonNQ
oooUX?ooiZ3oom^IoooWX@;oonJP00?oonZSoooVX?ooij405OoojZ<01?ooij7oonJPoooUX?ooj:8J
oooZX`03oooTWooohikoonZS00?oonRR00?oonZSoooWXOoojJ803ooojZ<00oooj:;oonNQoooZX`03
oooZX`04oooXX_ooi9ooonZSoooWX@;oonZS00?oonNQoooZXooojZ<00ooojZ<;oooYXP03oooVX?oo
ij7oonVR00;oonVR00CoonJPoooSW_oohikoonJP0_oojJ82oooWX@03oooYX_ooj:;oonJP00OoonJP
00?oonFPoooSW_oohih01?oohih00ooogi_oon2LoooTW`02oooRW@05oooOVooofYSoon:MoooPW?oo
hId00_oohYd9oooSWP03oooUX?ooiZ3oonJP00KoonJP00_oonVRoooXX_ooi9ooonBOoooWXOoogY_o
omZHoooTWooojJ;oonNQoooVX00AoooYX_ooonZS;?oojZ<4oooZY0;oonZU1?oojjH4ooo[Y`;oon^X
0ooojjT3ooo/ZP;oonb[1?ook:`2ooo/[@;oonf^0_ookJl2ooo]/0?oonfa0_ookK801?ook[?oonjd
ooo^]?ook[@2ooo^]@;oonjf0_ookkL2ooo_^0;oonni0_ookkX01?ookk_ooo2kooo`_?ool;`2ooo`
_@;ooo2n00?ooo2ooooa`?oolL000_oolL42oooa`P;ooo7300?ooo74oooba?ool/D00_ool/H2ooob
a`03ooobb?oollWooo?900;ooo?:0_ooll/2ooocc003ooodcOoom<koooC>00;oooC?0_oom=000ooo
m=7oooGBoooedP02oooed`;oooGD00?oooGEooofe_oom]H00_oom]L2oooff0;oooKI00?oooOJooog
fooomm/00_oomm`00ooommgoooONooohgP02ooohg`;oooSP0_oon>42ooohhP03oooihooonNCoooWT
00;oooWU0_oonNH00ooonNOooo[Wooojj003ooojj@;ooo[Z0_oon^/01?oonncooo_]oookkOoonnd3
oookkP;ooo__00Coooc`ooollOooo?7oooca0_ooo?82oooll`03ooolm?oooOCoooge00;oooge0ooo
oOH2ooomm`?ooogh0_ooo_T3ooonnP00<OoojJ800oooj:7oonFOoooYXP0CoooYXP05oooXXOooij7o
onJPoooTW_oohYd00ooohih01OoohIcoon:MoooRWOoog9WoomnK00;oon>N00?oon6LoooOVoooh9`0
0_oohih01?ooi9ooonJPoooVX?ooiIl4oooVX003oooTWooohikoon>N00?oonBN00Goon>NoooOVooo
gY[oomjJoooOV`02oooLV@09oooIUooofiSoomjJoooMV_oogi_oomjJoooPW?ooi9koonBO00SoonJP
00?oonBOoooSW_ooi9h01?ooi9h01ooohYgoon6LoooSW_oogi_oon>NoooRWOoogi/00_oohYd01Ooo
i9koon>NoooQW?oohYgoonFO00GoonJP0oooiIl01?ooiZ3oonFOoooUWoooij43oooXX@08oooWXOoo
iIooonRQoooWXOooi9koonBOoooIUoooiIl2oooTW`03oooXXOooi9koonFO00KoonRQ0ooojJ800ooo
j:7oonJPoooVX009oooVX004oooTW_oohikoon>NoooUW`KoonJP00?oonBNoooSW_oohih03ooohih0
1_ooi9koon>NoooOVooogI[oon:MoooQW0;oon:M00CoonBNoooQW?oohikoonBN3?oohih01?ooi9ko
onFOoooUWoooi9l4oooVX004oooTWooohIcoonJPoooSWP;oonFO00?oon>NoooUWoooiZ000oooiZ00
0oooi9ooonFOoooVX008oooVX003oooTW_ooi9ooonJP00;oonJP00CoonBNoooPW?ooh9coonBN0_oo
iZ000oooi9ooon>NoooTWP0@oooSWP03oooOVoooh9coon>N00;oon6L00OoomnKoooIUooohYgoomnK
oooQW?ooh9coon:M01;oon>N00WoonBNoooTWooohIcoon6LoooTWooog9WoomRFoooRWOooiIl00_oo
i9lAoooVX003oooXXOoojJ;oonVR0?ooonVR:?oojJ84oooYX`?oonVT00?oonZToooZYOoojZD00_oo
jZD2oooZYPCoonZW0_oojZP2ooo[Z@?oon^Z0ooojj/2ooo[[0?oonb]0_ook:h3ooo/[`04ooo//?oo
k;7oonfaooo]/@;oonfb0_ookK<2ooo]]004ooo]]Oook[Koonjfooo^]P;oonjg00Coonjhooo^^Ooo
k[Woonni0_ookkX00oookk_oonnlooo__002ooo__@;ooo2n00Gooo2oooo``?ool<3ooo30ooo``@02
oooa`P;ooo730_oolL@2oooaa@;ooo;600Cooo;7ooobb?ool/Sooo;90_ool/X2ooocb`;ooo?<00?o
oo?=ooocc_oollh00_oom<l2ooodd003oooddOoom=;oooCB00;oooGC00KoooGDoooeeOoomMGoooGF
oooeeooom]L2oooff0;oooKI00?oooKJoooffooom]/00_oomm`2ooogg@05ooogg_oommooooOOooog
gooon>000ooon>400ooon>;oooSSooohh`02oooii0;oooWU00CoooWVoooiiooonNOoooWW0_oon^P0
0ooon^Wooo[ZooojjP02ooojj`03ooojk?oonncooo_]00;ooo_]0_oonnh01Ooonnoooo_`oookl?oo
o?3oooca00?ooocb0_ooo?<3ooolm0;oooge0_oooOH3ooomm`?ooogh0_ooo_T3ooonnP00<OoojJ80
0oooj:7oonFOoooYXP0BoooYXP03oooXXOoohIcoon2L00;oomnK1?oogYX01_oogI[oomjJoooNV_oo
fIOoombIoooOV`;oomjJ00GoomfJoooOVooohYgoon6LoooRW@03oooSWP05oooWXOooj:7oonRQoooX
XOooij400_ooiZ04oooTW`;oonFO00_oonBNoooSW_ooh9coon2LoooKV?oogY[oon:MoooQW?oohiko
onBOoooUW`02oooTW`?oonFO00?oonNQoooVX?oohih01_oohih2oooQW006oooPW?oog9WoombIoooL
VOoofIOoomZH0_oofIL02OoofYSoomVGoooKV?oofYSoomVGoooLVOoogY[oomfJoooOV`02oooPW004
oooRWOoohikoon:MoooQW0;oon>N00?oon6LoooPW?ooh9`00oooh9`01_oogY[oon6LoooPW?oogI[o
omjJoooGU@?oomjJ00Coon6LoooMV_oogi_oon6L1?ooh9`00ooohikoonNQoooVX002oooVX0CoonFO
00?oonJPoooTWooohih00ooohih01?oohIcoomjJoooKV?oog9T2oooQW0?oon2L0_oohI`CoooPW00:
oooOVooog9WoomZHoooMV_oogY[oomnKoooNV_ooh9coomfJoooOV`koon2L1?oohI`4oooPW003oooN
V_ooi9koon:M00;oonBO00?oon:MoooVX?ooj:401?ooj:4:oooYXP03oooVX?ooij7oonVR00;oonVR
00CoonJPoooRWOooh9coonBN0_ooiZ000oooi9ooonBNoooTW`0@oooSWP03oooOVooohIcoonBN00;o
on:M00WoomnKoooJV?oohikoon2LoooQW?oogi_oon>NoooTW_oohih04_oohI`02Ooogi_oon2LoooS
W_oofiSoomVGoooSW_ooiIooonBOoooUW`0@oooWXOooonVR;?oojJ85oooYX`03oooYY?oojZCoonZU
00CoonZU0_oojZH3oooZY`;oonZX1?oojjT3ooo[ZP;oon^[00?oon^/ooo/[Oook:d00_ook:d2ooo/
[P;oonb_0_ook;000oook;7oonfaooo]/P02ooo]/P06ooo]/oookKCoonfdooo]]?ookKGoonje0_oo
k[H2ooo^]`03ooo^^?ook[Woonji00;oonnj0_ookk/2ooo__0;oonnm0_ool;h2ooo`_`03ooo``?oo
l<7ooo3100;ooo720_oolL<2oooaa004oooaaOoolLKooo;6oooba`?ooo;800Cooo;9ooobb_ool/[o
oo?;0_ooll`3ooocc@04ooocc_oom<ooooC?ooodd0?oooCA00?oooCCoooedooomM<00_oomM@01?oo
mMGoooGFoooee_oom]L2oooff0?oooKI0_oom]/3ooogg003oooggOoommkoooON00;oooOO0_oon>00
0ooon>7oooSRooohhP02ooohh`;oooWT0_oonND01?oonNKoooWWoooiiooonNL2ooojj0;ooo[Y00Co
oo[Zooojjooon^_ooo[/0_oonn`2oookk@03oookk_oonnoooo__00;ooo_`00?oooc`ooollOooo?40
0_ooo?83oooll`;ooocd0_oooOD3ooommP?ooogg0_oooOP2ooonn@?oookj000aoooYX003oooXWooo
iIgoonVP01;oonVP00OoonROoooWWoooiiooonNOoooVW_ooi9coon>L00;oonBL00Goon6JoooSW?oo
hicoomfHoooPVP03oooTW0;oonFM0oooi9d3oooWW`OoonVP1_ooiil02OooiYkoonFMoooSW?oohico
omfHoooQV_ooi9goonBLoooUW@07oooWW`03oooYX?ooj9ooonNO00KoonNO00[oonFMoooTW?oohico
on:KoooQV_oohicoomfHoooQV_ooh9[oomfH0_ooh9X01?oohY_oon2JoooOVOoogiT2oooQVP?oon>L
00?oonFMoooWWoooiil02Oooiil01oooi9goonNOoooWWooohicoonBLoooJU_ooiYh00_ooi9d00ooo
j9ooonBLoooUW@0DoooWW`04oooVW_ooi9coon2JoooPVPGoonBM00?oonBLoooSW?ooi9`00oooi9`@
oooSW003oooNV?oogISoon6J00;oon>L00?oon6JoooSW?oohIX04_oohi`02?ooi9coonBMoooUWOoo
iIgoonBMoooRVoooj9ooonJN0_oojJ000oooiYkoonVPoooYX00>oooYX003oooVW_ooiiooonVP00;o
onVP00CoonJNoooSW?ooiIgoonJN0_oojJ02oooWW`03oooYX?ooiiooonNO00koonNO00Soon>LoooT
W?ooiYkoonBMoooTW?oogiWoomVEoooRV`;oon2J00CoomjHoooQV_oohY_oon6J3oooh9X3oooOV@09
oooMV?oogYSoon6JoooIUOooei?oomjHoooPV_oogiWoon6J00Koon:K2_oohIX2oooSW003oooTW?oo
i9goonBM00GoonBM1OooiId00oooj9ooonVPoooYX03ooooYX1_oonVP1?oojJ400ooojJ;oonZRoooZ
X`03oooZX`?oonZT0ooojZD3oooZYP?oon^W00?oon^Xooo[ZOoojjT00_oojjT2ooo[ZP;oonb[0_oo
k:`3ooo/[@04ooo/[_ook:ooonb_ooo][`;oonf`00Coonfaooo]/_ookK;oonfb0_ookK<2ooo^]004
ooo^]Oook[Koonjfooo^]P;oonjg00?oonnhooo_^OookkT00oookkX00oookk_oonnlooo`_002ooo`
_@03ooo`__ool;oooo2o00;ooo3000?ooo71oooa`_oolL800_oolL<2oooaa005ooobaOool/Kooo;6
oooba_ool/L00_ool/P01?ool/Wooo?:ooocb_ooll/2ooocc0;ooo?=00?oooC=ooodcooom<l00ooo
m=000ooom=7oooGBoooedP02oooed`;oooGE00CoooGFooofe_oom]KoooKG0_oom]P00ooom]WoooKJ
oooffP02ooogf`;oooOL00?oooOMooogg_oommh00_oon=l2ooohh004ooohhOoon>;oooSRooohh`;o
ooWS00?oooWToooiiOoonND00_oonNH00ooonNOooo[Xooojj002ooojj@;ooo[Z0_oon^/2oookk0;o
oo_]0_oonnh3oookk`03oooll?ooo?7oooca00?ooocb0_ooo?<2ooolm0?oooge0ooooOH00ooooOOo
ooghooomn002ooomn0?oooki0Oooo_X0037oonVO00?oonRNoooUWOoojIl05?oojIl00oooj9koonJM
oooTV`04oooTV`06oooRV_oohi_oon>KoooMUoooh9WoonBL0_ooi9/4oooVW@03oooXW_oojIooonVO
013oonVO0_ooiId01?ooh9WoonBKoooXW_ooiYd4oooYW`03oooWW_ooiYgoonJM00KoonJM00?oonFM
oooTVooohi/00_oohi/2oooTV`0=oooSVooohY[oonBKoooOV?oohi_oon:JoooOV?oohi_oon:JoooT
Vooohi_oon6IoooRVP05oooTV`coon>K00Ooon6IoooSVooohi_oomnHoooPVOoofICoon>K00;oon2I
00?oonBKoooPVOoohIT05Ooohi/00oooi9_oomnHoooNV005oooQV@03oooOV?oogYSoomjH00?oomjH
00?oomnHoooRV_oohYX03?oohYX02_oohIWoomfGoooLU_oogiSoon6IoooRV_ooh9Woon:JoooOV?oo
hITAoooRVP06oooSVoooiIgoonJMoooVWOooi9coon6I1?oojIl00oooiIgoonVOoooYW`0>oooYW`07
oooVWOooiikoonJMoooUWOooiYgoonBKoooPV@02oooTV`;oonJM00?oonBLoooTVoooiYd04?ooiYd0
2OoohY[oon6IoooTW?oohi_oon:JoooPVOoofICoom^FoooJU@02oooIU003oooJUOoofiKoom^F00?o
om^F3?oofYD00ooofICoomZEoooJU@02oooHT`03oooJUOooei?oomBA00CoomVD1OoofYD00ooog9Ko
omjHoooNV008oooNV0;oomfG00CoomnHoooPVOooh9Woon6I1?ooi9/00oooiIgoonNNoooYW`02oooX
W_ooonVO7_oojIl2oooYX0CoonVQ00CoonZQoooZX_oojZ;oonZR0ooojZ<3oooZY0;oonZU0ooojjH3
ooo[Y`;oon^X0_oojjT00ooojj[oonbZooo/ZP02ooo/Z`;oonb/0oook:d00oook:koonf^ooo][`02
ooo]/0?oonfa00?oonfbooo]/oook[<00oook[@01_ook[Goonjfooo^]_ook[Ooonngooo_^0?oonni
00?oonnjooo_^oookk/00_ool;`2ooo`_@03ooo`__ool;oooo2o00;ooo7000Oooo71oooa`_oolL;o
oo72oooa`ooolLCooo;400;ooo;500?ooo;6ooobaoool/L00_ool/P00ooollWooo?:ooocbP02oooc
b`03ooocc?oollgoooC=00;oooC>00KoooC?ooodd?oom=3oooCAoooedOoomM82oooed`;oooGD00?o
ooGEooofe_oom]H00_oom]L01Ooom]SoooKIoooffOoom][oooOJ00;oooOK00?oooOLoooggOoommd0
0_oommh2ooohg`03ooohh?oon>7oooSQ00;oooSR00?oooWSoooii?oonN@00_oonND01?oonNKoooWW
oooiiooon^L2ooojj003ooojjOoon^[ooo[Z00;ooo[[0_oonn`2oookk@?ooo_^00Cooo__oookl?oo
o?3oooc`0_ooo?42ooollP?ooocc00Cooocdooomm?oooOGoooge0_oooOH4ooomm`03ooomn?ooo_Wo
ooki00;oooki0Oooo_X0037oonVN00?oonRMoooUW?oojIh05OoojIh3oooXW@04oooYW_ooj9goonJL
oooTVP;oonFL00?oomnGoooRVOooiid01OooiY`00oooiIcoonJLoooXW@0AoooYWP;oonFL00CoomnG
oooTV_ooj9goonJL1?oojIh:oooXW@KoonNM00OoonJLoooTVoooiigoon>JoooVW?ooiIcoon>J00;o
onFL00CoonRMoooVW?ooi9_oonBK4?ooiid01?ooiYcoonBKoooWWOooiY`2oooTVP07oooKUOooiYco
onBJoooTV_ooj9goonBJoooUW00FoooWW@03oooVW?ooi9_oonRM00CoonNM1oooj9d>oooYWP04oooX
WOoohi[oon6HoooUW0;oonRM00CoonJLoooYW_ooiIcoonRM4_oojIh3oooXW@03oooVW?oohi[oonVN
00?oonVN00?oonFLoooYW_oojIh03_oojIh02OooiYcoonNMoooXWOooj9goonVNoooTV_oohi[oonFL
oooVW002oooXW@;oonJL00?oonVNoooXWOooj9d03_ooj9d01oooiIcoonBJoooXWOooiigoonJLoooT
Vooog9D00_ooi9X00oooi9_oon>JoooVW005oooWW@coonFL00?oonBJoooTVoooi9/00_oohIP01ooo
iIcoomfFoooFTOoohISoonBJoooSV_ooi9X01OooiI`00oooiigoonRMoooXW@0CoooXWOooonVN8_oo
jIh2oooYW`?oonVP00?oonZPoooZXOoojZ400_oojZ42oooZXP?oonZS0ooojZ@3ooo[Y@;oon^V0_oo
jjL3ooo[Z004ooo[ZOook:WoonbYooo/ZP?oonb[0_ook:`2ooo/[@;oonf^0oookJl01OookK3oonfa
ooo]/OookK;oonjb00;oonjc0_ook[@2ooo^]@05ooo^]_ookkOoonngooo_]oookkP00_ookkT2ooo_
^P05ooo`^oool;cooo2looo`_?ool;d00_ool;h00ooolKoooo70oooa`002oooa`@03oooa`_oolL?o
oo7300;ooo;400?ooo;5oooba_ool/H00_ool/L00oool/Sooo?9ooocb@02ooocbP;ooo?;00?oooC<
ooodcOoom<h00_oom<h2ooodc`04ooodd?oom=7oooGAoooedP;oooGC00?oooGDoooeeOoom]D00_oo
m]H2ooofe`03oooff?oom]WoooKI00;oooOJ00CoooOKooogg?oommcoooOM0_oommh2ooohg`;oooSP
0_oon>400ooon>;oooWRoooih`02oooii005oooiiOoonNKoooWVoooiiooon^L00_oon^P2ooojj@;o
oo[Z00Cooo[[oookjooonncooo_/0_oonnd2oookkP;ooo__00Coooc`ooollOooo?7oooca0oooo?80
1?ooo??ooocdooolm?oooO@2ooomm@;ooogf1?oooOL01?oooOSoookiooonnOooo_T2ooonnP00<Ooo
j9d00oooiicoonBKoooXW@0IoooXW@03oooVW?ooi9_oon>I00;oon>J00?oomfFoooQV?ooiI/01Ooo
i9/00oooiI_oonNLoooXW@0?oooXW@08oooWW?ooiI_oon:IoooRVOoogIKoon2GoooTVooohiT9oooU
V`03oooWW?ooj9goonRM00SoonRM00OoonNLoooUVoooj9goon>IoooWW?ooiI_oon>I00;oonJL00Co
onRMoooWW?ooiI_oonFK4?ooj9d02?ooiicoonFKoooXWOooiicoonFKoooTVooofiCoonNL0_ooi9/0
0oooj9goonBKoooUV`0FoooXW@03oooWW?ooiI_oonRM01[oonRM00Woon>IoooRVOooiI_oonNLoooX
WOooiYcoonRMoooUVoooii`05Oooj9d00oooiYcoon>IoooXW@03oooXW@03oooTVoooj9goonRM00ko
onRM00?oonFKoooVW?ooj9d00_ooj9d00ooohiWoon>JoooVW003oooXW@03oooTVooohiWoonFK013o
onFK00?oonBKoooPUoooi9/00_oohiX01ooohISoomZDoooPUooohISoon>IoooQV?ooi9/04?ooiI/0
3OooiYcoon>JoooTVoooi9_oon2GoooQV?ooiI_oomjFoooHT_oohi[oonJLoooUVoooiY`0ooooj9dl
oooXW@?oonRN1?ooj9l01?oojIooonVPoooYX?oojJ03oooYX@?oonVR0_oojJ<2oooZY0?oonZU0_oo
jZH3oooZY`;oon^X0ooojjT2ooo[ZP05ooo[Zooojjcoonb/ooo/[?ook:d00oook:h2ooo/[`05ooo/
/?ookK7oonfaooo]/OookK800_ookK<2ooo]]0;oonje0_ook[H01?ook[Ooonjhooo^^?ook[P2ooo_
^@06ooo_^_ookk_oonnkooo__?ookkgooo2m0_ool;h00oool;oooo30ooo``002ooo``@03oooa`_oo
lL?ooo7300;ooo740_oolLD00oool/Kooo;7oooba`02ooobb004ooobbOool/[ooo?:ooocb`;ooo?<
0_oolld00ooom<koooC?ooodc`02ooodd004oooddOoom=;oooCBoooed`;oooGD0_oomMD01?oomMKo
ooKGooofeooom]P3oooff@03oooff_oomm_oooOK00;oooOL00?oooOMooogg_oommh00_oon=l00ooo
n>3oooSQooohh@02ooohhP03ooohhooonN?oooWT00;oooWU0_oonNH01?oonNOoooWXooojj?oon^P2
ooojj@05ooojj_oon^_ooo[[ooojjooonn`00_oonnd2oookkP;ooo__00Cooo_`oooll?ooo?3oooca
0oooo?82oooll`;ooocd0ooooOD2ooommP?ooogg0_oooOP3ooonn@7oookj000aoooWV`03oooVV_oo
hiWoonNK01WoonNK0_ooiYX01OoohiWoonBIoooTVOoogYGoon:G00OoonJJ2oooii/00oooiI[oonBI
oooTV@05oooTV@;oon6G00Goom^CoooOU_oohYSoon:GoooTV@06oooSV@03oooUV_ooiY[oonNK00[o
onNK00OoonFJoooTVOooii_oon:GoooVV_ooi9Woon:G00;oonFJ00CoonNKoooVV_oohiWoonBI4?oo
ii/01?ooiY[oon>IoooWVoooiYX2oooTV@07oooJT_ooiY[oon>IoooSVOooii_oon:HoooTV@0FoooW
V`03oooUV_oohYOoonBI00GoonBI00?oon>IoooRUooohYP04OoohYP01?oohYOoomjEoooOU_ooh9H2
oooRU`04oooPU_oohYSoon2FoooRU`ooon:H1Oooi9T00oooiI[oon:HoooQU`04oooWV`03oooSVOoo
ii_oonNK00koonNK00?oonBIoooUV_ooii/00_ooii/00ooohYOoon:HoooUVP03oooWV`03oooTVOoo
hiWoonJJ013oonJJ00OoonBIoooQUooohiWoon>IoooTVOoohYOoomZB00;oon2F0_oohYL00oooiI[o
onJJoooVVP0?oooVVP?oonBI0_oohIL01oooiI[oomfDoooGT?oohYSoonBIoooSVOooiIX0ooooii/m
oooWV`;oonNL0oooiid01?ooj9goonRNoooXW_ooj9h4oooXW`;oonRP0_ooj:400ooojJ7oonVRoooY
XP03oooYX`?oonVT00CoonVUoooZY_oojZKoonZV0_oojZL2oooZZ0;oonZY00CoonZZooo[Z_oojj_o
on^[0_oojj`2ooo[[@04ooo/[_ook:ooonb_ooo/[`;oonb`0_ook;400oookK;oonfcooo]/`02ooo]
]005ooo]]OookKKoonffooo^]_ook[L00_ook[P00oook[Woonjjooo^^P02ooo_^`03ooo__?ookkgo
onnm00;oonnn0_ool;l2ooo``004ooo``Oool<;ooo73oooa``;ooo7400Cooo75oooaa_oolLKooo77
0oool/P01?ool/Wooo;:ooobb_ooll/2ooocc004oooccOoollkooo?>ooodc`;oooC@00GoooCAoood
d_oom=;oooCCoooed`02oooee004oooeeOoomMKoooGFoooee`;oooKH0_oom]T00ooom][oooKKooof
f`02ooogg003oooggOoommkoooON00;oooOO00?oooOPooohh?oon>400_oon>801Ooon>?oooSToooi
i?oonNCoooWU00;oooWV0_oonNL01Ooon^Sooo[YooojjOoon^Wooo[Z00;ooo[[0_oon^`2oookk@;o
oo_^0_oonnl2oookl0;oooca0oooo?801Oooo??ooocdooolm?ooo?Coooge00?ooogf0ooooOL2ooom
n003ooomnOooo_Woookj007oookj000aoooWVP03oooVVOoohiSoonNJ01_oonNJ00GoonBHoooVVOoo
iYWoomnEoooRU`0BoooWVPSoonFI0_oohYH01?oog9?oon2EoooTV?oohYL7oooUV@03oooVVOooii[o
onNJ00[oonNJ00OoonFIoooTV?ooii[oon:FoooVVOooi9Soon:F00;oonFI00CoonNJoooVVOoohiSo
onBH4?ooiiX02?ooiYWoon>HoooWV_ooiYWoonBHoooUVOoofi;oonJI0_oohiP00oooii[oon:GoooT
V00FoooWVP03oooUVOoohYOoonFI00GoonFI00?oon>HoooRUooohYL04_oohYL00ooogYCoon2EoooQ
UP02oooRU`03oooQU_oohYOoon6F00ooon:G00?oon>HoooUVOooiIT01?ooiIT00ooohYOoon6FoooW
VP03oooWVP03oooTV?ooii[oonNJ00goonNJ00?oonJIoooRUoooi9P00_ooiIT01?ooiYWoon6FoooQ
U_oohiP3oooUV@;oon>H00?oonJIoooUVOooiIT03?ooiIT2oooRU`0<oooRU_oogYCoon2EoooPUOoo
hIKoomnEoooGSooogI?oombCoooNU?oogiGoon:F4OoohYL03OoohIKoon:FoooRU_oogYCoon2EoooR
UooofI3oomF>oooOUOoohYKoon6FoooRU_ooi9P07ooohiP00oooi9SoonNJoooWVP3ooooWVQWoonNJ
0oooii/3oooWW0;oonRL00?oonRMoooXW_ooj9h00oooj9h01_ooj9ooonRPoooXX?ooj:3oonVPoooY
X@CoonVR0_oojJ<2oooYY0?oonZU00KoonZVoooZYooojZOoonZWoooZZ?oojZT2ooo[Z@;oon^Z0_oo
jj/2ooo[[0;oonb]00Soonb^ooo/[oook:ooonb_ooo//?ook;7oonfaooo]/P;oonfc0_ookK@2ooo]
]@;oonjf0_ook[L00oook[Soonjiooo^^@02ooo_^P03ooo_^oookkcoonnl00;oonnm0_ool;h3ooo`
`004ooo``OoolL;ooo72oooa``;ooo7400Cooo75oooaa_ool/Kooo;70_ool/P00oool/Wooo;:ooob
bP02ooocb`03ooocc?oollgooo?=00;ooo?>00?oooC?ooodd?oom=000_oom=401?oom=;oooCCoooe
dooomM@2oooee@03oooee_oomMOoooKG00;oooKH0_oom]T2oooff`05ooogfooommcoooOMoooggOoo
mmh00_oomml2ooohh0;oooSQ00?oooSRooohhooon><00_oonN@2oooii@;oooWV00CoooWWoooij?oo
n^Sooo[Y0ooon^X00ooon^_ooo[/ooojk002oookk@;ooo_^0_oonnl2oookl003oooll?ooo?7ooocb
00;ooocb00?oooccooolm?ooo?@00ooooOD2ooommPCooogg00?oooghooomnOooo_T00_ooo_T0037o
onNJ00?oonJIoooSV?ooiiX06oooiiX01Oooi9SoonJIoooVVOoogiGoon:F01[oonNJ0_oohiP01?oo
gYCoon:FoooVVOooi9PDoooWVP07oooUVOooi9SoonNJoooRU_ooiYWoonBHoooRUP02oooUV@04oooW
V_ooiYWoon>HoooTV13oonNJ00SoonJIoooSV?ooii[oonJIoooTV?ooiIWoom^BoooVV@;oon>H00?o
onNJoooRUoooi9P05_ooiiX00oooiYWoonBHoooWVP0JoooWVP09oooRUooohiSoonBHoooVVOooii[o
onFIoooWV_ooi9SoonJI01GoonNJ00?oonFIoooQU_ooiiX04oooiiX00oooiYWoon:FoooSV003oooT
V003oooRU_oohIKoon:G00?oonBH0_oohYLAoooTV00>oooSV?ooh9Goon:FoooRU_oohYOoon2EoooG
Sooog9?oomnEoooQU_ooh9Goon>HoooTV?oohYH?oooTV00=oooRUooohiSoon:GoooPUOoohYKoon>H
oooITOooehooon2EoooTV?oohiSoonBHoooWVP0OoooVVOooonNJ7OooiiX3oooWV`;oonNL0_ooj9`2
oooXW@?oonRN0_ooj9l2oooXX004oooYX?oojJ7oonVQoooYX@;oonVR0_oojJ<3oooYY0?oonZU00Ko
onZVoooZYooojZOoonZWoooZZ?oojZT2ooo[Z@04ooo[Z_oojj_oon^[ooo[Z`;oon^/0_ook:d02?oo
k:koonb_ooo/[oook:ooonb`ooo//OookK7oonfb0oookK<00oookKCoonfeooo]]@02ooo^]P;oonjg
00?oonjhooo^^Oook[T00_ookkX00oookk_oonnlooo__002ooo__@;ooo2n0_ool<02ooo``@03ooo`
`_oolL;ooo7300;ooo7400Cooo75oooaa_ool/Kooo;70oool/P2ooobbP06ooocbooollcooo?<oooc
c?oollgooo?>0_oom<l2ooodd0;oooCA00CoooCBoooedooomM?oooGD0_oomMD00ooomMKoooGGooof
e`02oooff006oooffOoom][oooKJoooffooomm_oooOL0_oommd00ooommkoooOOooogg`02ooohh0;o
ooSQ00?oooSRooohhooon><00_oonN@2oooii@;oooWV00CoooWWoooij?oon^Sooo[Y0ooon^X00ooo
n^_ooo[/ooojk002oookk@;ooo_^0_oonnl2oookl0;oooca0oooo?801?ooo??ooocdooolm?ooo?@2
ooomm@?ooogf0ooooOL01?oooOSooogiooomnOooo_T1ooonnP00<OooiYP00oooiIOoon:FoooVV00K
oooVV005oooSU_ooiIOoonFGoooNTooohI@06_ooiYP2oooRUP04oooLTOooh9CoonFGoooSUQCoonJH
00OoonBGoooSU_ooiYSoon6DoooUUooohiKoon6D00;oonBG00CoonJHoooUUooohYKoon>F4?ooiYP0
2?ooiIOoon:FoooVV?ooiIOoon>FoooUUooogI;oonBG0_oohYH00oooiYSoon6EoooSUP0FoooVV003
oooUUooohYKoonJH01[oonJH00Koon>FoooQUOoohiKoonFGoooVV?oohiHHoooVV003oooTUoooh9Co
onJH01CoonJH00?oon>FoooTUoooiYP00_ooiYP00oooi9Ooon>FoooTU`03oooVV0;oonBG4OooiYP0
3_ooiIOoon6DoooSU_oohiKoonBGoooQUOooeXgoom^AoooQU?oohiKoon6EoooUUoooiYSoon>F3ooo
iYP02Oooi9OoonFGoooTUooohIGoon>FoooUUooofY3oomR>oooQU002oooSUP03oooTUoooiYSoonJH
0?ooonJH>oooiYP3oooVV@;oonJJ00CoonNJoooWVoooii_oonNK0oooii`3oooWW@03oooWW_ooj9ko
onRO00;oonRO0_ooj:02oooXX@;oonRR0ooojJ<01?oojJCoonVUoooYYOoojJD2oooYYP?oonZW00Co
onZXoooZZOoojZWoonZZ0ooojj/2ooo[[0;oon^]00?oon^^ooo[[oook:l00_ook;02ooo//@03ooo/
/_ook;?oonfc00;oonfd0_ookKD01?ookKKoonfgooo^]oook[P2ooo^^@;oonjj00Coonnkooo__?oo
kkcoonnm0_ookkh00oookkoooo30ooo``002ooo``@;ooo3200Cooo33oooaa?oolLCooo750_oolLH0
1?oolLOooo;8ooobb?ool/T2ooobbP03ooobbooollcooo?<00;ooo?=00Cooo?>oooccooollooooC@
0_oom=400ooom=;oooCCooodd`02oooee003oooeeOoomMKoooGF00;oooGG0_oom]T2oooffP;oooKK
00CoooOLoooggOoommgoooON0_oomml00ooomn3oooSPooohh@02ooohhP05ooohhooon>CoooSToooi
i?oonND00_oonNH2oooii`03oooij?oon^Sooo[Y00?ooo[Z00?ooo[[ooojk?oon^`00_oonnd2oook
kP04oookkooono3ooo_`oookl0;oooca0_ooo?82oooll`?ooocd0_oooOD01?oooOKoooggooommooo
oOL2ooomn0;ooogi0_ooo_T0037oonJG00?oonFFoooRUOooiYL06oooiYL01OoohiGoonFFoooUU_oo
gY;oon6C01[oonJG0_oohYD01?oog93oon2CoooUU_oohiDDoooVU`07oooTU_oohiGoonJGoooQTooo
iIKoon>EoooQT`02oooTUP04oooVUoooiIKoon:EoooSUA3oonJG00SoonFFoooRUOooiYOoonFFoooS
UOooiIKoomfAoooTUP;oon:E00?oonJGoooQU?oohiD05_ooiYL00oooiIKoon:EoooVU`0JoooVU`06
oooSUOoohICoon>EoooUU_ooiYOoon>E6?ooiYL00oooi9Koon2CoooVU`0DoooVU`03oooSUOooi9Ko
onJG00;oonJG00?oon>EoooRUOooi9H00oooiYL00oooi9Koon>EoooVU`0@oooVU`0?oooUU_oohI?o
on>EoooRUOooi9Koon6DoooDRooofXooon6CoooSUOoohI?oonFFoooVUooohYGoonFF00koonJG0ooo
i9H02OoohI?oon>EoooUU_oofXooomR>oooPTooohICoon>EoooTUP3ooooVUcgoonJG0oooiYP2oooV
V@;oonNI0_ooiiX3oooWV`?oonNL0_ooiid2oooXWP;oonRO0oooj:02oooXX@?oonVR00?oonVSoooY
Y?oojJ@00_oojJ@00ooojJGoonZVoooZYP02oooZY`05oooZZ?oojZWoonZYoooZZOoojjX00ooojj/0
1?oojjcoon^]ooo[[Ooojjd3ooo/[`06ooo//?ook;7oonbaooo//_ookK;oonfc0_ookK@2ooo]]@03
ooo]]_ook[Koonjg00;oonjh00?oonjiooo^^_ookkX00_ookk/01?ookkcoonnmooo___ookkh2ooo`
_`03ooo``?ool<7ooo3100;ooo3200?ooo73oooaa?oolLD00_oolLD01OoolLKooo;7ooobb?ool/So
oo;900;ooo;:00Cooo?;ooocc?oollcooo?=0_oollh01?oollooooC?ooodd?oom=42oooddP03oood
dooomM?oooGD00;oooGE00CoooGFoooeeooomMOoooKH0_oom]T2oooffP04oooffooommcoooOLooog
g@;oooON0_oomml00ooomn3oooSQooohh@02ooohhP03ooohhooon>CoooWT00;oooWU00GoooWVoooi
iooonNOoooWWooojj002ooojj@05ooojj_oon^_ooo[[ooojjooon^`00ooonnd00ooonnkooo__oook
k`02oookl0;oooca0oooo?801?ooo??ooocdooolm?ooo?@2ooomm@?ooogf00Coooggooomn?oooOSo
oogh0oooo_T0037oonJF00?oonFEoooRU?ooiYH06oooiYH01OoohiCoonFEoooUUOoogY7oon6B01[o
onJF0_oohY@01?oog93oon2BoooUUOoohi@DoooVUP07oooTUOoohiCoonJFoooQT_ooiIGoon>DoooQ
TP02oooTU@04oooVU_ooiIGoon:DoooSU13oonJF00SoonFEoooRU?ooiYKoonFEoooSU?ooiIGoomf@
oooTU@;oon:D00?oonJFoooQTooohi@05_ooiYH00oooiIGoon:DoooVUP0JoooVUP06oooSU?oohI?o
on>DoooUUOooiYKoon>D6?ooiYH00oooi9Goon2BoooVUP0DoooVUP03oooSU?ooi9GoonJF00;oonJF
00?oon>DoooRU?ooi9D00oooiYH2oooUUA7oonJF00ooonFEoooQTooohiCoon:DoooTUOoohI?oomB:
oooJS_oohI;oon>DoooQT_ooiIGoonJFoooRU?ooiID03_ooiYH3oooTU@09oooQT_oohiCoonFEoooJ
S_oof8goon2BoooQT_oohiCoonBE0?ooonJF?OooiYH3oooVU`;oonJH00CoonNHoooWVOooiiWoonNI
0oooiiX2oooWV`?oonNL0_ooj9d2oooXWPCoonRO0_ooj:000ooojJ7oonVRoooYXP03oooYX`;oonVT
00?oonZUoooZY_oojZH00ooojZL01OoojZSoon^Yooo[ZOoojjWoon^Z00;oon^[00Goon^/ooo[[Ooo
jjgoonb]ooo/[P02ooo/[`;oonb`00Coonbaooo]/_ookK;oonfc0_ookK@2ooo]]@03ooo^]_ook[Oo
onjg00;oonjh00?oonjiooo_^_ookkX00_ookk/01Oookkcoonnmooo___ool;kooo2o00?ooo3000Go
oo31ooo``_oolL;ooo73oooaa002oooaa@04oooaa_ool/Oooo;7ooobb0;ooo;90_ool/X01?ooll_o
oo?<ooocc?oolld2oooccP08ooodcooom=3oooC@oooddOoom=;oooCCoooedooomM@2oooee@;oooGF
00CoooGGooofeooom]SoooKI0_oom]X01Ooom]_oooOLooogg?oommcoooOM00;oooON00?oooOOoooh
h?oon>000_oon>401?oon>;oooSSooohhooonN@2oooii@;oooWV00?oooWWoooij?oon^P00_oon^T2
ooojjP;ooo[[00Gooo[/oookk?oonngooo_]oookkP02oookk`;ooo_`0_ooo?43ooollP;ooocc00Co
oocdooommOoooOGoooge0_oooOH2ooomm`?ooogh0_ooo_T1ooonnP00<OooiYH00oooiIGoon:DoooV
UP0KoooVUP05oooSU?ooiIGoonFEoooNTOoohI806_ooiYH2oooRU004oooLT?ooh9;oonFEoooSU1Co
onJF00OoonBEoooSU?ooiYKoon6BoooUUOoohiCoon6B00;oonBE00CoonJFoooUUOoohYCoon>D4?oo
iYH03OooiIGoon:DoooVU_ooiIGoon>DoooUUOooh9;oonBEoooRU?oohI?oonJFoooRU?oohi@05_oo
iYH00oooiIGoon:DoooVUP0JoooVUP06oooSU?oohI?oon>DoooUUOooiYKoon>D6?ooiYH00oooi9Go
on2BoooVUP0DoooVUP03oooSU?ooi9GoonJF00;oonJF00?oon>DoooRU?ooi9D05oooiYH2oooSU00<
oooRU?ooi9Goon6CoooDR_oofXkoon6BoooSU?oohI;oonFEoooVU_oohYCoonFE3_ooiYH3oooTU@08
oooQT_oohiCoonFEoooMT?oof8goon2BoooQT_ooiIGooooVUSkoonJF0_ooiYL3oooVV0;oonNH0_oo
iiT3oooWVP;oonNK0_ooii`4oooXW@04oooXW_ooj9ooonROoooXW`;oonRP0_oojJ42oooYXP;oonVS
0ooojJ@01OoojZGoonZVoooZY_oojZKoonZW00;oonZX00CoonZYooo[ZOoojj[oon^Z0_oojj/01_oo
jjcoon^]ooo[[Oook:goonb^ooo/[`;oonb`0_ook;42ooo]/P06ooo]/oookKCoonfdooo]]?ookKGo
onjf0_ook[L00oook[Soonjiooo^^@02ooo_^P;oonnk00Coonnlooo__Oookkkooo2n0_ool;l01ooo
l<3ooo31ooo``Oool<;ooo72oooa`ooolL@00_oolLD2oooaaP03ooobaoool/Sooo;800;ooo;900Go
oo;:ooocc?oollcooo?<ooocc@02oooccP07ooodcooom=3oooC@oooddOoom=;oooCCoooed`02oooe
e007oooeeOoomMKoooGFoooeeooom]OoooKHoooff@02oooffP05oooffooommcoooOLooogg?oommd0
0_oommh01?oommooooSPooohhOoon>42ooohhP;oooSS00GoooWToooiiOoonNGoooWUoooiiP02oooi
i`;ooo[X00?ooo[Yooojj_oon^X00_oon^/00ooon^cooo_/oookk@02oookkP;ooo__0_oono03oool
l@04oooll_ooo??oooccoooll`;ooocd00?ooogeooomm_oooOH00_oooOH2ooomm`;ooogh0oooo_T0
037oonJD00?oonFCoooRT_ooiY@06oooiY@01Ooohi;oonFCoooUTooogXooon6A01[oonJD0_oohY80
1?oog8koon2@oooUTooohi8DoooVU007oooTTooohi;oonJDoooQTOooiI?oon>BoooQT@02oooTT`04
oooVU?ooiI?oon:BoooSTQ3oonJD00goonFCoooRT_ooiYCoonFCoooST_ooiYCoon6AoooTTooohY;o
on>BoooVU?ooiI?oonBC01KoonJD00?oonFCoooRT_ooiY@06_ooiY@2oooSTQcoonJD00?oonBCoooP
T?ooiY@05?ooiY@00ooohi;oonBCoooVU002oooVU003oooST_oohY;oonBC01OoonJD0_oohi803?oo
hY;oonBCoooQTOoodXOoomZ<oooQTOoohi;oon6AoooUToooiYCoon:BoooUT`koonJD0oooi9<02?oo
hI7oon>BoooUTooog8koomV<oooPT?oohI7oonFCooooiY@moooVU0CoonJE0_ooiYH4oooWU`;oonNH
0oooiiT2oooWVP;oonRK1?ooj9`01?ooj9goonRNoooXW_ooj9h2oooYW`;oonVP0_oojJ42oooYXP04
oooYXooojZ?oonZToooZY0;oonZU0_oojZH00ooojZOoon^Xooo[Z002ooo[Z@;oon^Z0_oojj/00ooo
k:coonb]ooo/[@02ooo/[P;oonb_00Coonf`ooo]/OookK7oonfb0_ookK<00oookKCoonjeooo^]@02
ooo^]P04ooo^]oook[Soonniooo_^@;oonnj0_ookk/01?ookkcooo2mooo`__ool;h2ooo`_`;ooo30
0_oolL801?oolL?ooo74oooaa?oolLD2ooobaP;ooo;700Gooo;8ooobbOool/Wooo?:ooocb`02oooc
c0;ooo?=00CoooC>ooodcooom=3oooC@0_oom=401?oomM;oooGCoooedooomM@2oooee@03oooee_oo
m]OoooKH00;oooKH0ooom]X01ooomm_oooOLoooggOoommgoooONoooggooon=l00_oon>001_oon>7o
ooSRooohh_oon>?oooWSoooii0;oooWU0_oonNH00ooonNOooo[Xooojj002ooojj@;ooo[Z0_oon^/0
0ooonncooo_]oookk@02oookkP;ooo__00?ooo_`oooll?ooo?400oooo?82oooll`04ooolm?oooOGo
oogeooomm@?ooogf0_oooOL2ooomn0?oooki000aoooTTP03oooSTOooh93oonBB01_oonBB00Goon6@
oooSTOoohi7oomb=oooOS`0JoooTTP;oon2@00Coom^<oooOSooohi7oon6@5?ooi9801ooohY7oon6@
oooTT_oohI3oon:AoooQT?ooghl00_oohY401?ooi9;oon>AoooPT?oohI0@oooTTP07oooSTOooh93o
onBBoooSTOoohI3oonBBoooOS`02oooRT@04oooSTOooi9;oon>AoooRTAKoonBB00?oon>AoooPT?oo
i9806_ooi9800ooohI3oon:AoooTTP0KoooTTP03oooRTOoogXkoonBB01CoonBB00?oon6@oooRTOoo
i9800_ooi9801OoohI3oon2@oooRTOooi9;oon>A01GoonBB0_oohI003?ooh93oon:AoooOSooochGo
omR;oooOSooohI3oomn?oooSTOooi9;oon2@oooST@koonBB0ooohY400oooghooon6@oooST@02oooH
R`03oooLSOoogXkoon>A0?ooonBB?_ooi982oooTT`;oonBD00?oonFDoooUUOooiID00_ooiID2oooU
UP?oonFG0_ooiIP3oooVV@05oooVV_ooiY_oonJKoooVVoooiY`00_ooii`01?ooiigoonNNoooWW_oo
iih2oooWW`05oooWX?ooj:7oonRQoooXXOooj:800_ooj:<01?ooj:CoonVToooYYOoojJD2oooYYP04
oooYYooojJSoonZXoooZZ@?oonZZ00CoonZ[oooZ[?oojZcoon^]0_oojjh2ooo[[`03ooo[/?ook;7o
onba00;oonbb00Coonbcooo/]?ook;Coonfe0_ookKH01OookKOoonfhooo]^?ook[Woonjj00;oonjk
0_ook[`01Oookkgoonnnooo___ookkooono000?ooo3100Gooo32ooo``oool<Cooo34oooaa@02oooa
aP04oooaaooolLSooo78ooobb@;ooo;:00Cooo;;ooobc?oollgooo?=0_oollh3ooocd006oooddOoo
m=;oooCCoooddooom=CoooGE0_oomMH2oooee`05oooef?oomMWoooKIoooff_oom]/00ooom]`01ooo
mmgoooONoooggooommooooOPoooghOoon>400_oon>801Ooon>?oooSTooohi?oon>CoooWU00;oooWV
0_oonNL00ooonNSoooWYooojj@02ooojjP05ooojjooon^cooo[/ooojkOoonnd00_oonnh01Ooonnoo
oo_`oookl?oono3oooca00;ooocb0oooo?<00oooo?Coooceooolm@03ooommP;ooogg0_oooOP1ooom
n@7oooki0Oooo_T0037oonBB00?oon>AoooPT?ooi9806oooi9801OoohI3oon>AoooSTOoog8goomn?
01[oonBB00Koon2@oooPSooog8goon2?oooRTOoohI0DoooTTP07oooRTOoohI3oonBBoooQT?oohY7o
on6@oooOS`02oooRT@04oooTT_oohi7oon2@oooQT17oonBB00Ooon:AoooTT_oohi7oon6@oooTT_oo
ghooon:A00?oonBB00?oon>AoooRTOooi9805Oooi9800ooohi7oon2@oooTTP0JoooTTP03oooQT?oo
hY7oonBB01_oonBB00?oon:AoooNS_ooi9805?ooi9800ooohI3oon:AoooTTP02oooTTP06oooQT?oo
h93oon:AoooTT_ooh93oon6@5?ooi9803_oohI3oon2@oooPT?oohY7oomn?ooo?Q?oofH_oomn?oooQ
T?ooh8ooon>AoooTT_ooh93oon>A3_ooi983oooRT@03oooOSooohI3oon>A00;oomR;00?oomb=oooN
S_oohi40ooooi98moooTTPCoonBC0_ooiI@4oooUU@;oonFF0oooiIL00oooiISoonJHoooVV002oooV
V@;oonJJ0oooiY/00oooiicoonNMoooWW@03oooWWP03oooWWoooij3oonNP00?oonRQ0_ooj:800ooo
j:?oonRToooXY002oooYY@06oooYY_oojJOoonVWoooYZ?oojZSoonZY0ooojZX00ooojZ_oonZ/ooo[
[@02ooo[[@06ooo[[_oojjooon^_ooo[/?ook;3oonba0_ook;801?ook;?oonbdooo/]?ookKD2ooo]
]P04ooo]]oookKSoonfhooo^^@;oonjj00Coonjkooo^_?ook[coonnm0_ookkh01?ookkooono0ooo`
`Oool<42ooo``P05ooo``oool<Cooo34oooaaOoolLH00_oolLL00ooolLSooo;9ooobb@02ooobbP06
ooobboool/cooo?=oooccOoollkooo??0ooolm001_oom=7oooCBoooddooom=?oooCDoooee@;oooGF
00?oooGGoooef?oomMP00_oom]T01?oom][oooKKooofg?oom]`2ooogg@03ooogg_oommooooOO00;o
ooOP00CoooSQooohh_oon>;oooSS0ooon>@01?oonNGoooWVoooiiooonNL2oooij005oooijOoon^[o
oo[Zooojj_oon^/00_oon^`00ooon^gooo_]oookkP02oookk`?ooo_`00?ooocaoooll_ooo?800ooo
o?<2ooolm004ooommOoooOKooogfooommP;ooogg0_oooOP1ooomn@7oooki0Oooo_T0037oonBB00?o
on>AoooPT?ooi9806oooi9801OoohI3oon>AoooSTOoog8goomn?01[oonBB00Koon6@oooPT?oog8go
on2?oooRTOoohI0DoooTTP07oooRTOoohI3oonBBoooQT?oohY7oon6@oooNSP03oooTTP03oooSTOoo
h93oon6@01?oonBB00Goon>AoooPT?ooi9;oomn?oooST@03oooTTP03oooSTOoohY7oonBB01GoonBB
00?oon>AoooPT?ooi9806_ooi9800ooohI3oon:AoooTTP0KoooTTP03oooRTOooh93oonBB01CoonBB
00?oon6@oooRTOooi9800_ooi9801_oohI3oon2@oooRTOoohi7oon2@oooQT1CoonBB00[oon2@oooN
S_oohI3oon:AoooNS_oocXCoomV;oooOSoooh93oon6@0_ooi9800oooh93oon>AoooTTP0=oooTTP?o
on:A00?oomn?oooQT?oohi400_oof8/2oooOS`03oooSTOooi9;oonBB0?ooonBB??ooi983oooTT`03
oooTU?ooiICoonFE00?oonFE0_ooiIH3oooUU`;oonFH00?oonJHoooVVOooiYT00_ooiYX3oooVV`03
oooWW?ooiigoonNM00?oonNN00?oonNOoooWX?ooij000oooj:400oooj:;oonRSoooXX`02oooXY003
oooYYOoojJKoonVV00;oonVW00?oonVXoooZZ?oojZT00_oojZX2oooZZ`05oooZ[?oojjgoon^]ooo[
[Ooojjh00_oojjl00ooojk3oonbaooo//@02ooo//P03ooo//oook;Coonfe00;oonfe0_ookKL01?oo
kKSoonjhooo^^Oook[X2ooo^^`;oonjl00?oonnmooo___ookkh00_ookkl01Oookl3ooo31ooo``_oo
l<;ooo3300;ooo3400Gooo75oooaa_oolLOooo77oooab002ooobb@;ooo;:00Kooo;;ooobc?oollgo
oo?=ooocc_oolll3ooocd006oooddOoom=;oooCCoooddooom=CoooGE0_oomMH2oooee`05oooef?oo
m]WoooKIoooff_oom]/00ooom]`01ooommgoooONoooggooommooooOPoooghOoon>400_oon>801_oo
n>?oooSTooohi?oon>CoooWUoooiiP;oooWW0_oonNP00ooonNWooo[ZooojjP02ooojj`;ooo[/00?o
oo[]oookkOoonnh00_oonnl3oookl003ooollOooo?;ooocb00?ooocc0_ooo?@01?ooo?Gooogeooom
m_oooOH3ooomm`;ooogh0_ooo_T0037oonBB00?oon>AoooPT?ooi9806oooi9801OoohI3oon>AoooS
TOoog8goomn?01[oonBB00Koon>AoooPT?oog8goon2?oooRTOoohI0DoooTTP07oooRTOoohI3oonBB
oooQT?oohY7oon6@oooNSP03oooTTP03oooSTOooh93oon6@01CoonBB00?oon>AoooTT_oohY401?oo
i9800ooohi7oon:AoooTTP0EoooTTP03oooSTOooh93oonBB01[oonBB00?oon6@oooRTOooi9806ooo
i9800ooohi7oon6@oooTTP0DoooTTP03oooQT?oohY7oonBB00;oonBB00Koon6@oooPT?oohY7oon>A
oooPT?oohI0DoooTTP0:oooPT?oogXkoon6@oooRTOoogXkoolj4oooIRoooghooon2@oooQT0;oonBB
00?oon2@oooSTOooi9803Oooi983oooRT@03oooOSooohI3oon>A00;oomR;00?oomj>oooOSooohi40
ooooi98noooTTP;oonBC0_ooi9@00oooiICoonFEoooUU@02oooUU@;oonFF0oooiIL00oooiISoonJH
oooVV002oooVV@03oooVV_ooiY_oonJK00;oonJK00?oonNLoooWWOooiid00oooiih2oooWW`05oooW
X?ooj:7oonRQoooXXOooj:800_ooj:<01Oooj:CoonVToooYYOoojJGoonVV00?oonVW00CoonZXoooZ
ZOoojZWoonZZ0_oojZ/01OoojZcoon^]ooo[[Ooojjgoon^^00;oon^_00?oonb`ooo//Oook;400_oo
k;801Oook;?oonbdooo/]?ookKGoonff00;oonfg00?oonfhooo^^?ook[T00_ook[X01?ook[_oonjl
ooo^_?ookkd2ooo__P;oonno00Goono0ooo``Oool<;ooo32ooo```02ooo`a004oooaaOoolLKooo76
oooaa`;ooo7800Gooo;9ooobb_ool/[ooo;;ooobc002ooocc@03ooocc_oolloooo?@00;ooo?@00Ko
ooCAooodd_oom=?oooCCooode?oomMD2oooeeP;oooGG00CoooGHoooffOoom]WoooKJ0_oom]/01?oo
m]coooOMoooggOoommh2ooogg`03ooogh?oomn7oooSQ00;oooSR00?oooSSooohi?oon>@00_oonND0
1_oonNKoooWWoooiiooonNOoooWXooojj@;ooo[Z0_oon^/01?oon^cooo[]ooojkOoonnd2oookkP05
oookkooono3ooo_`oookl?ooo?400_ooo?83oooll`;ooocd00CoooceooommOoooOKooogf0_oooOL2
ooomn07ooogi0Oooo_T1ooonn@00<_ooiI400ooohXooonFAoooUT@0JoooUT@05oooRSoooi93oonB@
oooMS?ooh8h06_ooiI401_ooi93oon6?oooMS?oohHkoon>@oooRSaCoonFA00Ooon>@oooRSoooiI7o
on:?oooST?oohXooomn=00?oonFA00?oonB@oooQSooohXl06oooiI400oooi93oon>@oooUT@0EoooU
T@03oooTT?oohHooonFA01[oonFA00?oon:?oooST?ooiI406oooiI400oooi93oon:?oooUT@0DoooU
T@04oooRSooohi3oonFAoooUT@;oon:?00Goon6?oooST?ooi93oon6?oooRS`0DoooUT@0:oooQSooo
ghgoon:?oooST?ooghgooln3oooJR_ooghgoon6?oooRS`;oonFA00?oon6?oooTT?ooiI403OooiI43
oooST005oooPS_oohXooon>@oooHR?oofHX00_ooh8h00oooi93oonFAoooUT@3ooooUTCcoonFA0_oo
iI82oooUT`03oooVToooiYCoonJD00;oonJD0_ooiYD2oooVUP;oonJG00?oonNGoooWV?ooiiP00ooo
iiT2oooWVP?oonNK0_ooj9`00oooj9goonRNoooXWP02oooXW`03oooXX?oojJ3oonVQ00;oonVQ00Co
onVRoooYXooojJ?oonVT0_oojZD2oooZYP;oonZW00?oonZXooo[ZOoojjT00_oojjX00ooojj_oon^/
ooo[[002ooo/[@03ooo/[_ook:ooonb_00;oonb`00Coonfaooo]/_ookK;oonfc0_ookK@00oook[Go
onjfooo^]`02ooo^]`05ooo^^?ook[Woonnjooo_^_ookk/00_ookk`01?ookkgooo2mooo`_oool;l2
ooo``005ooo``OoolL;ooo73oooa`ooolL@00_oolLD2ooobaP03ooobaoool/Sooo;900;ooo;:0_oo
ll/01Ooollcooo?=oooccOoollkoooC?00;oooC@00CoooCAooodd_oom=;oooGC0_oomM@01?oomMGo
ooGFoooee_oom]L2oooff0;oooKI00CoooKJooogfooommcoooOL0_oommd01?oommkoooOOooohh?oo
n>02ooohh@04ooohh_oon>?oooSSoooii0;oooWU0_oonNH00ooonNOoooWXooojj002ooojj@;ooo[Z
00Gooo[[ooojk?oonncooo_/oookk@02oookkP;ooo__00?ooo_`oooll?ooo?400oooo?82oooll`;o
oocd0_oooOD3ooommP;ooogg00?oooghooomnOooo_T00Oooo_T004ooon:900Goomn7oooQR?oohHSo
omZ4oooMQP0JoooRR@06oooQR?oogXOoomZ4oooNQ_ooh8Soomn75?oohXT01oooh8Soomn7oooRROoo
ghOoon28oooOQooog8D00ooohXT00ooohHSoomj7oooOQ`0KoooRR@03oooQR?ooh8Soon:901Goon:9
00?oon68oooNQooohXT06_oohXT00oooghOoon28oooRR@0KoooRR@03oooQR?ooghOoon:901Coon:9
00Coomn7oooPR?oohXWoon:90oooghL01?ooh8Soon68oooNQoooghLDoooRR@0:oooNQooog8Goomn7
oooPR?oog8GoolaloooGPooofhGoomf6oooOQ`;oon:900?oomj7oooQR?oohXT03OoohXT3oooPR005
oooMQ_ooghOoomn7oooAOoooeX800_oogHH00ooohHSoon:9oooRR@3ooooRRCcoon:90ooohXX01?oo
hX_oon>;oooSS?oohh`3oooSS@;oon>>0ooohhl01?ooi8ooonB@oooTTOooi942oooTTP04oooTTooo
iI?oonFDoooUU0?oonFE0_ooiIH2oooVU`04oooVV?ooiYWoonJIoooVVP;oonJK0_ooii`2oooWW@04
oooWW_ooiiooonNOoooXX0;oonRQ0_ooj:800oooj:?oonVToooYY002oooYY@04oooYY_oojJOoonZX
oooZZ0;oonZY00GoonZZoooZZooojjcoon^/ooo[[@02ooo[[P08ooo[[oook;3oonbaooo//Oook;;o
onbcooo/]?ookK@2ooo]]@06ooo]]_ookKOoonfgooo^^?ook[Woonjj0_ook[/01oookkcoonnmooo_
__ookkkoonnoooo_`?ool<000_ool<401Oool<;ooo33oooaa?oolLGooo7600?ooo7700Cooo;8ooob
bOool/[ooo;;0_ool/`02Ooollgooo?>ooocc_oolloooo?@ooodd?oom=7oooCBooodd`02ooode0;o
ooGE00GoooGFoooeeooomMSoooGHoooff@02oooffP06oooffooom]coooKLoooggOoommkoooOO0ooo
mn001?oon>7oooSRooohh_oon><2ooohi003oooiiOoonNKoooWV00;oooWW00CoooWXooojjOoon^[o
oo[Z0_oon^/2ooojk0;ooo_]00?ooo_^oookkooonnl00_oono000oooo?7ooocbooollP03oooll`03
ooolm?ooo?Goooce00?ooogf00Coooggooomn?oooOSooogh0Oooo_T004ooomn100GoomaooooNP?oo
gX3oomMloooJOP0JoooOP@06oooNP?oog7ooomMloooKO_oogH3oomao5?oogh401ooogH3oomaooooO
POoog7ooomf0oooLOooofGd00ooogh400ooogX3oomaooooLO`0coooOP@03oooNP?oog7ooomn101[o
omn100?oomaooooMP?oogh406ooogh400ooogX3oomaooooOP@0DoooOP@04oooLOooogH3oomn1oooO
P@?oomao00Coomf0oooNP?oofWkoomao5?oogh402_oog7ooomUmoooLOooogH3oomUmooo9M?ooeG_o
omQmoooJO_oog7l2oooOP@03oooLOooogX3oomn100goomn10ooogH001OoofWkoomaooooLOooocWOo
omAj00;oomUm00?oomj0oooOPOoogh40oooogh4loooOP@;oomn21?ooh8<2oooPQ0;oon250_ooh8H2
oooQQ`;oon680ooohHT2oooQRP03oooRRooohXcoon:<00;oon:=0_oohXh2oooSS`04oooST?oohi7o
on>AoooSTP;oonBC0_ooi9@2oooTU@04oooTU_ooiIOoonFGoooUV0;oonFI00CoonFJoooVVoooiY_o
onJL0_ooiYd01OooiYkoonNOoooWWoooij3oonNQ00;oonNR00GoonRSoooXY?ooj:GoonRUoooXYP02
oooYY`03oooYZ?oojJWoonVZ00?oonZ[0_oojZd01_oojjkoon^_ooo[/?oojk3oon^aooo[/P;oonbc
00?oonbdooo/]Oook;H00_ookKL00oookKSoonfiooo]^P02ooo^^`0;ooo^_?ook[goonjnooo___oo
kkooono0ooo_`Oookl;ooo32ooo``oool<@00_ool<D00ooolLKooo77oooab002oooab@08ooobb_oo
l/_ooo;<ooobcOool/kooo?>oooccooolm02ooocd@03ooodd_oom=?oooCD00?oooCE00?oooGFoooe
eooomMP00_oomMT01Ooom][oooKKooofg?oom]coooKM00;oooON00GoooOOooogh?oomn7oooOQoooh
hP02ooohh`03ooohi?oon>GoooWV00;oooWV0_oonNP2oooij@04ooojj_oon^_ooo[[ooojk0;ooo[]
0_oonnh00ooonnoooo_`oookl002oookl@;ooocb00?oooccooolm?ooo?@00_ooo?D2ooommP?ooogg
0_oooOP004ooomn200Goomb0oooNPOoogX7oomMmoooJO`0JoooOPP06oooNPOoog83oomMmoooKOooo
gH7oomb05?oogh801ooogH7oomb0oooOP_oog83oomf1oooLP?oofGh00ooogh800ooogX7oomb0oooL
P00coooOPP03oooNPOoog83oomn201[oomn200?oomb0oooMPOoogh806ooogh800ooogX7oomb0oooO
PP0DoooOPP04oooMPOoogX7oomn2oooOPP?oomb000Coomf1oooNPOoofGkoomb05?oogh802_oog83o
omUnoooLP?oogH7oomUnooo9MOooeGcoomQnoooJOooog802oooOPP03oooLP?oogX7oomn200goomn2
0ooogH43oooLP005ooo>N?ooe7_oomQnoooGOOoogX40oooogh8noooOPP?oomn30_ooh8@2oooPQ@?o
on260_ooh8L3oooQR005oooQROoohH[oon6:oooQR_oohH/00ooohX`2oooRS@04oooRS_oohXooon:?
oooST0;oon>A0_oohi800ooohi?oonBDoooTU002oooTU@03oooTU_ooi9OoonBG00;oonFH00?oonFI
oooUV_ooiIX00_ooiI/00oooiYcoonJMoooVW@02oooVWP06oooWWoooij3oonNQoooWXOooij;oonNS
0_ooj:@01Oooj:GoonRVoooXYooojJOoonVX00;oonVY00?oonVZoooZZooojZ`00_oojZd00ooojZko
on^_ooo[/002ooo[/@04ooo[/_oojk?oonbcooo/]0;oonbe00?oonbfooo]]oookKP00_ookKT00ooo
kK[oonjkooo^_002ooo^_@03ooo^__ookkooono000;oono100?oono2ooo``oool<<00_ool<D00ooo
l<Kooo77oooab002oooab@04oooab_ool/_ooo;;ooobc0;ooo;=00Cooo?>oooccooolm3ooo?@0_oo
lm801_oom=?oooCDooodeOoom=GoooGFoooee`;oooGH00GoooGIoooef_oom]_oooKKooofg002ooof
g@09ooofg_oommooooOOooogh?oomn7oooORooohh_oon>?oooST00;oooSU0ooonNH01OoonNOoooWX
oooijOoonNWooo[Z00;ooo[[0_oon^`01?oon^gooo_^oookk_oonnl2oookl0;ooo_a0_ooo?801Ooo
o??ooocdooolm?ooo?Coooce00;ooogf0_oooOL3ooomn000Cooogh801Ooog83oomj1oooNPOooeggo
omYo01[oomn200Koomj1oooLP?ooeggoom]ooooMPOoog80DoooOPP07oooMPOoog83oomn2oooLP?oo
gH7oomb0oooIOP03oooOPP03oooNPOoog83oomb003?oomn200?oomj1oooLP?oogh806_oogh82oooN
PAcoomn200?oomj1oooLP?oogh806?oogh82oooLP005oooKOooog83oomj1oooIO_oog8005?oogh80
2_oog83oomUnoooLP?oogH7oomUnooo9MOooeGcoomQnoooJOooog802oooOPP03oooLP?oogh;oomn2
00goomn21OoogH401_oog83oolihoooDNooof7koomImoooNPOooomn2?_oogh83oooOP`?oon2400Co
on25oooPQ_ooh8Koon260_ooh8L3oooQR0;oon690_oohHX2oooQR`03oooRS?oohXgoon:=00;oon:>
0_oohXl2oooST003oooSTOoohi;oon>B00;oon>C0_ooi9@01Oooi9GoonBFoooTUoooi9OoonFH00;o
onFI0_ooiIX02OooiI_oonJKoooVW?ooiYcoonJMoooVW_ooiYooonNOoooWX002oooWX@09oooWX_oo
ij?oonRToooXY?ooj:GoonRVoooXYooojJOoonVX00;oonVY00?oonVZoooZZooojZ`00_oojZd00ooo
jZkoonZ_ooo[[`02ooo[/@03ooo[/_oojk?oonbc00;oonbd00Coonbeooo/]_ookKOoonfh0_ookKT0
1_ookK[oonjkooo^_?ook[coonjmooo^_P;oonno0_ookl401_ookl;ooo33ooo`a?ool<Cooo35ooo`
aP;ooo7700Cooo78oooabOoolL[ooo;;0_ool/`01?ool/gooo;>ooocc_oolll2ooocd004ooocdOoo
m=;oooCCooode0;oooCE00goooCFoooeeooomMOoooGHoooefOoomM[oooKJoooffooom]coooKMooof
g_oommkoooOO00;oooOP00CoooOQooogh_oon>?oooSS0_oon>@01_oon>GoooSVoooii_oonNKoooWW
oooij0;oooWY00Cooo[Zooojjooon^_ooo[/0_oon^d01Ooonnkooo__oookkooonnoooo_`00;ooo_a
0_ooo?82oooll`;ooocd00?oooceooomm_oooOH00_oooOL2ooomn07ooogi001?oooOPP05oooLP?oo
gX7oomj1oooGOOoofWl06_oogh801_oogX7oomb0oooGOOoofgooomf1oooLP1Coomn200Ooomf1oooL
P?oogh;oomb0oooMPOoog83oomUn00?oomn200?oomj1oooLP?oog800<ooogh800ooogX7oomb0oooO
PP0hoooOPP03oooNPOoog83oomn201Soomn200Ooomb0oooJOooofGkoom]ooooNPOoof7koomUn017o
omn20ooogX402_oog83oomQnoooLP?oogH7oomQnooo9MOooeGcoomQnoooIO_oog802oooNP@03oooL
P?oogX7oomn200goomn200?oomf1oooNPOoogH400_oogH401_oofgooolihoooDNooofGkoomMmoooN
POooomn2?Ooogh84oooOP`;oon240oooh8D2oooPQP;oon270_oohHP3oooQR@05oooQR_oohH_oon6;
oooQRooohX`00_oohXd3oooRSP04oooRSooohi3oon>@oooST@;oon>B0_oohi<2oooTU005oooTUOoo
i9KoonBFoooTUoooiIP00_ooiIT2oooUVP03oooUVoooiY_oonJL00;oonJM00CoonJNoooVWoooiioo
onNP0_ooij401Oooij;oonNSoooXY?ooj:CoonRU00;oonRV00?oonVWoooYZ?oojJT00_oojJX01_oo
jZ_oonZ/oooZ[?oojZgoonZ^ooo[[`;oon^`00?oon^aooo[/_oojk<00oook;@01Oook;Goonbfooo]
]oookKSoonfi00;oonfj00Koonjkooo^_?ook[goonjmooo^__ookkl2ooo_`004ooo_`Oookl;ooo33
ooo`a0;ooo3500?ooo36oooaaooolLP00_oolLT01?oolL[ooo;;ooobc?ool/`2ooobc@07ooocc_oo
lloooo?@ooocdOoolm;oooCBooodd`02ooode003ooodeOoom=KoooGG00;oooGH00GoooGIoooef_oo
m]_oooKKooofg002ooofg@03ooogg_oommooooOP00;oooOQ00CoooORooohh_oon>?oooST0_oon>D0
1Ooon>KoooWVoooiiooonNOoooWX00;oooWY00Cooo[Zooojjooon^_ooo[/0_oon^d2oookkP;ooo__
00?ooo_`oooklOoono400_ooo?82oooll`;ooocd00Goooceooomm_oooOKooogfooomm`02ooomn07o
oogi001?oooOPP05oooLP?oogX7oomj1oooGOOoofWl06_oogh801_oogX7oomb0oooGOOoofgooomf1
oooLP1Coomn200Ooomj1oooMPOoogh;oomb0oooMPOoog83oomUn00?oomn200?oomj1oooLP?oog800
<ooogh800ooogX7oomb0oooOPP0hoooOPP03oooNPOoog83oomn201Soomn200Ooomb0oooJOooofGko
omb0oooNPOoof7koomUn017oomn20ooog8002_oofWooomMmoooJOooofgooomImooo9MOoodg_oomIm
oooGOOoofWl2oooLP003oooIO_oog83oomj100Ooomn200?oomf1oooLP?oog8000ooog8003?oofgoo
omb0oooLP?oofgooomYooooHO_oocWSoom=koooGOOooeGcoomb0oooMP@Coomb0oooogh8hoooOPPCo
omn30_ooh8@3oooPQ@?oon2600?oon27oooQR?oohHP00ooohHT01?oohH[oon6;oooQRooohH/2oooR
S0;oon:=00?oon:>oooRSooohXl00_oohi02oooST@03oooST_oohi?oon>C00;oonBD00CoonBEoooT
U_ooi9KoonBG0_ooiIP2oooUV@04oooUV_ooiI_oonJKoooVW0;oonJM0_ooiYh2oooWX0;oonNQ00[o
onNRoooWXoooj:?oonRToooXYOooj:KoonRWoooYYooojJSoonVY0_oojJX01OoojZ_oonZ/oooZ[Ooo
jZgoonZ^00;oon^_00Coon^`ooo[/Ooojk;oon^c0_ook;@2ooo/]@04ooo/]_ookKOoonfhooo]^@;o
onfj00Goonjkooo^_?ook[coonjmooo^_P02ooo__`03ooo_`?ookl7oono200;ooo330_ool<D00ooo
l<Kooo77oooab002oooab@04oooab_ool/_ooo;<ooobc0;ooo;=00?ooo?>oooccooolm000_oolm40
0ooom=;oooCCooode002ooode@09ooode_oomMOoooGHoooef?oomMWoooGJoooff_oom]_oooKL00;o
ooKM00SoooONoooggooomn3oooOPoooghOoomn;oooSRooohh`;oooST00?oooSUooohi_oonNH00_oo
nNL01?oonNSoooWYooojj_oon^X2ooojj`03ooojk?oon^gooo[]00;ooo_^0_oonnl00ooono3ooo_a
oookl@02ooollP;ooocc00GooocdooolmOooo?GoooceooommP02ooomm`;ooogh0OoooOT004ooomn2
00Goomb0oooNPOoogX7oomMmoooJO`0JoooOPP06oooNPOoog83oomYooooKOooogH7oomb05ooogh80
1?oogH7oomj1oooLP?oofGh4oooOPP03oooNPOoog83oomn203;oomn200?oomj1oooLP?oogh80>?oo
gh800ooogX7oomb0oooOPP0HoooOPP07oooLP?oofWooomUnoooLP?oogX7oomQnoooIOP0AoooOPP0=
oooNPOoogH7oomf1oooKOooof7koom]ooooLP?ooeggoolUeoooDNoooeggoomQnoooLP002oooMP@03
oooKOooogH7oomf100Goomf100?oomj1oooOP_oogH401OoogH43oooLP005oooKOooof7koomMmooo>
N?ood7T00_ooeG`4oooLP0;oomf1oooogh8ioooOPP;oomn31?ooh8@00oooh8Goon26oooPQP02oooP
QP;oon270_oohHP2oooQR@;oon6:0_oohH/2oooRS0;oon:=00?oon:>oooRSooohXl00_oohi000ooo
hi7oon>BoooSTP02oooST`03oooTU?ooi9GoonBE00;oonBF00CoonBGoooUV?ooiISoonFI0_ooiIX0
0oooiI_oonJKoooVW002oooVW@04oooVW_ooiYooonNOoooWX0;oonNQ00[oonNRoooXXoooj:?oonRT
oooXYOooj:KoonRWoooYYooojJSoonVY0_oojJX01ooojZ_oonZ/oooZ[?oojZgoonZ^oooZ[ooojjl0
0_oojk400ooojk;oon^cooo/]002ooo/]0;oonbf00Ooonfgooo]^?ookKWoonfiooo]^_ook[_oonjl
00;oonjm00Ooonjnooo__oookl3oono0ooo_`Oookl;ooo3300;ooo3400?ooo35ooo`a_oolLL00_oo
lLP01OoolLWooo7:ooobboool/_ooo;<00;ooo;=00?ooo?>oooccooolm000_oolm401_oom=;oooCC
ooode?oom=CoooCEoooeeP;oooGG00?oooGHoooefOoomMX00_oom]/01Ooom]coooKMooofg_oommko
ooOO00;oooOP00CoooOQooogh_oon>?oooSS0_oon>@00ooon>GoooSVoooiiP02oooii`04oooij?oo
nNWoooWYooojjP;ooo[[00?ooo[/ooojkOoon^d00_oonnh00ooonnoooo_`oookl002oookl@;ooocb
0_ooo?<2ooolm003ooolmOoooOKooogf00;ooogg0_oooOP1ooomn@00Cooogh801Ooog83oomj1oooN
POooeggoomYo01[oomn200Koomj1oooLP?oofgooom]ooooMPOoog80IoooOPP03oooLP?oofGkoomn2
00?oomn200?oomj1oooLP?oogh80<_oogh800ooogX7oomb0oooOPP0hoooOPP03oooNPOoog83oomn2
01Soomn200Ooomb0oooJOooofGkoomb0oooNPOoof7koomUn017oomn200goomj1oooMPOoogH7oom]o
oooHO_oofgooomb0oooGOOoobGGoomAkoooGOOoof7koomb000;oomf100Coom]ooooLP?oogH7oomf1
1?oog8000ooogH7oomn2oooOPP05oooOPP0>oooMPOoogX7oomj1oooJOooof7koomElooo>N?oodG[o
omMmoooEO?oog83oomf1oooLP?oogX7ooooOPS_oomn20_oogh<4oooPQ0;oon250_ooh8H2oooPQ`?o
on680_oohHT01OoohH[oon6;oooQRooohH_oon:<00;oon:=0_oohXh2oooRS`;oon>@0_oohi400ooo
hi;oon>CoooST`02oooTU004oooTUOooi9KoonBFoooTU`;oonFH0_ooiIT01?ooiI[oonFKoooVVooo
iY`2oooVW@05oooVW_ooiYooonNOoooWX?ooij400_ooij802Oooj:?oonRToooXY?ooj:GoonRVoooX
YooojJOoonVXoooYZ@02oooYZP03oooYZooojZcoonZ]00;oonZ^00Koon^_ooo[/?oojk3oon^aooo[
/_oojk<3ooo/]003ooo/]Oook;Koonfg00;oonfh00?oonfiooo]^_ook[/00_ook[`01?ook[goonjn
ooo__oookl02ooo_`@07ooo_`_ool<?ooo34ooo`a?ool<Gooo36oooaa`02oooab003oooabOoolL[o
oo;;00;ooo;<0_ool/d00ooollkooo??ooocd002ooocd@03ooodd_oom=?oooCD00;oooCE00KoooCF
oooeeooomMOoooGHoooefOoomMX2oooff`04ooofg?oom]goooKMoooggP;oooOO0_oomn400ooomn;o
ooSRooohh`02ooohi003ooohiOoon>KoooWV00;oooWW00CoooWXoooijOoon^[ooo[Z0_oon^/2oooj
k0;ooo[]0_oonnl2oookl0;ooo_a00?ooocbooolloooo?<00_ooo?@2ooolm@;ooogf0_oooOL2ooom
n07ooogi001?oooOPP05oooLP?oogX7oomj1oooGOOoofWl06_oogh801_oogX7oomf1oooJOooog83o
omf1oooLP1Woomn200?oomb0oooIO_oogh800ooogh800ooogX7oomb0oooOPP0boooOPP03oooNPOoo
g83oomn203Soomn200?oomj1oooLP?oogh806?oogh801ooog83oomYooooIO_oog83oomj1oooHO_oo
fGh03Ooogh801OoogH7oomb0oooLP?oog83oom]o00;oomYo00goomQnoooEO?oof7koomUnoooEO?oo
bGGoom9joooEO?ooeWgoomUnoooKOooofWooomQn00;oomYo0_oog8000ooogH7oomb0oooLP003oooL
P006oooNPOoogh;oomn2oooNPOoogh;oomb00_oogH42oooIOP06oooFOOoocgWoom9joooHO_ooeggo
omj10ooogh85oooNPOooomn2=_oogh83oooOP`?oon2400Coon25oooPQ_ooh8Koon260oooh8L01?oo
hHSoon69oooQROoohHT2oooQRP;oon6;0_oohX`00ooohXgoon:>oooRSP02oooRS`;oon>@0_oohi40
0ooohi;oon>CoooST`02oooTU005oooTUOooi9KoonBFoooTUoooiIP00_ooiIT2oooUVP03oooUVooo
iY_oonJL00;oonJM00CoonJNoooVWoooiiooonNP0_ooij401Oooij;oonRSoooXY?ooj:CoonRU00;o
onRV00KoonVWoooYZ?oojJWoonVYoooYZ_oojJ/2oooZ[003oooZ[OoojZkoonZ_00;oon^`00?oon^a
ooo[/_oojk<00_ook;@01?ook;Goonbfooo/]_ookKL2ooo]^004ooo]^OookK[oonjkooo^_0;oonjm
00?oonjnooo__oookl000_ookl401?ookl;ooo33ooo`a?ool<D2ooo`aP;ooo7700?ooo78oooabOoo
lLX00_ool//01_ool/cooo;=ooobcOoollkooo??ooocd0;ooo?A00?oooCBoooddooom=@00_oom=D0
1?oomMKoooGGoooef?oomMP2oooef@;oooKK00CoooKLooofgOoom]goooON0_oomml01Ooomn3oooOQ
ooogh_oon>;oooSS00;oooST00?oooSUooohi_oonNH00_oonNL01?oonNSoooWYoooijOoon^X2oooj
j`;ooo[/00Cooo[]oookk_oonnkooo__0_oono02oookl@;ooocb0_ooo?<2ooolm0;oooce00?ooogf
ooommooooOL00_oooOP1ooomn@00Cooogh801Ooog83oomj1oooNPOoofGkoomYo01coomn200CoomYo
oooMPOoogX7oomb06Ooogh800ooog83oomUnoooOPP03oooOPP03oooNPOoog83oomn203;oomn200?o
omj1oooLP?oogh80>Ooogh800ooogX7oomn2oooOPP0GoooOPP07oooMPOoofgooomUnoooLP?oogX7o
omQnoooJO`0=oooOPP?oomj100koomf1oooKOooofGkoomYooooFOOooe7_oomEloooGOOooe7_oolUe
oooAN_oodg_oomAkoooFO@;oomQn00KoomMmoooJOooofWooom]ooooLP?oogH45oooNP@;oomn200Co
omj1oooLP?oofgooomUn0_oofWl2oooEO005oooDNooocWSoom1ioooEO?ooe7/01?oofgl01Ooog83o
omf1oooLP?oog83oomf100koomj1oooogh8XoooOPP?oomn30_ooh8@3oooPQ@?oon2600?oon27oooQ
R?oohHP00ooohHT2oooQRP;oon6;0_oohX`2oooRS@03oooRS_oohXooon:?00;oon>@0_oohi401?oo
hi;oon>CoooSToooi9@2oooTU@;oonBF00?oonBGoooUV?ooiIP00_ooiIT01?ooiI[oonFKoooVVooo
iY`2oooVW@03oooVW_ooiYooonNO00;oonNP0_ooij801?ooij?oonRToooXYOooj:D2oooXYP07oooY
YooojJSoonVYoooYZOoojJ[oonV[oooZ[002oooZ[@09oooZ[_oojZooon^`ooo[/?oojk7oon^booo[
/oook;?oonbd00;oonbe00?oonbfooo]]oookKP00_ookKT01oookK[oonjkooo^_?ook[coonjmooo^
__ookkl00_ookl001?ookl7oono2ooo``oool<@2ooo`a@07ooo`a_oolLOooo78oooab?oolLWooo7:
ooobb`02ooobc006ooobcOool/kooo?>oooccooolm3ooo?A0_oolm801_oom=?oooCDooode?oom=Go
ooCFoooee`;oooGH00SoooGIoooef_oom][oooKKooofg?oom]goooKNoooggP;oooOO00?oooOPooog
hOoomn800_oon><2ooohi003ooohiOoon>KoooWV00;oooWW00CoooWXoooijOoonNWooo[Z0_oon^/0
0ooon^cooo[]ooojk@02oookkP06oookkooono3ooo_`oookl?oono7ooocb0_ooo?<3ooolm005oool
mOoooOKooogfooomm_oooOL00_oooOP1ooomn@00Cooogh800ooog83oomj1oooNP@02oooKOacoomn2
00CoomYooooMPOoogX7oomb06Ooogh800ooog83oomUnoooOPP03oooOPP03oooNPOoog83oomn203;o
omn200?oomj1oooLP?oogh806?oogh8EoooLP003oooKOooofWooomYo02?oomYo00GoomQnoooFOOoo
eGcoomMmoooJO`02oooEO0?oom]o00?oomYooooHO_oof7h01?oof7h00oooeWgoomEloooEO005oooE
O0;oom=k00Koolmiooo;M_ooc7Ooolegooo;M_oob7D2ooo;MP;oolag00?oolegooo?NOoocWP00ooo
cgT00ooodG[oom9joooEO00:oooEO0;oomIm0_oodg/01Oood7Woolagooo>N?oodG[oom1i00GoomEl
00?oomImoooIO_oofgl03_oofWl00ooofgooomb0oooLP002oooLP003oooMPOoogh;oomn20?ooomn2
8Ooogh83oooOP`?oon240_ooh8D2oooPQP?oon270_oohHP2oooQR@;oon6:0_oohH/01?oohXcoon:=
oooRSOoohXd2oooRSP03oooRSooohi3oon>@00;oon>A00Coon>BoooSToooi9CoonBD0_ooi9D2oooT
UP04oooTUoooiISoonFHoooUV@;oonFJ00?oonFKoooVVoooiY`00_ooiYd01?ooiYkoonJOoooWWooo
ij02oooWX@05oooWX_ooij?oonRToooXY?ooj:D00_ooj:H00ooojJOoonVXoooYZ@02oooYZP03oooZ
ZooojZcoonZ]00;oonZ^00KoonZ_ooo[/?oojk3oon^aooo[/_oojk<3ooo/]004ooo/]Oook;Koonfg
ooo]^0;oonfi00?oonfjooo^^oook[`00_ook[d02?ook[koonnoooo_`?ookl3oono1ooo_`_ool<?o
oo340_ool<D01oool<Kooo77oooaaooolLSooo79oooab_ool//00_ool/`01Oool/gooo;>ooocc_oo
lloooo?@00;ooo?A00?oooCBoooddooom=@00_oom=D02Ooom=KoooGGoooeeooomMSoooGIoooef_oo
m][oooKKooofg002ooofg@08ooogg_oommooooOPooogh?oomn7oooORooohh_oon><2ooohi003oooh
iOoon>KoooWV00;oooWW0_oonNP01?oonNWooo[Zooojjooon^/2ooojk004ooojkOoonnkooo_^oook
k`;ooo_`0_oono42ooollP;ooocc0_ooo?@00oooo?GooogfooommP02ooomm`;ooogh0OoooOT004oo
omn200Goomf1oooNPOoogX7oom]ooooJO`0LoooOPP04oooJOooogH7oomj1oooLP1Woomn200?oomb0
oooIO_oogh800ooogh800ooogX7oomb0oooOPP0boooOPP03oooNPOoogH7oomn201Soomn25OoogH4V
oooLP008oooJOoooeggoomImoooIO_oofgooomEloooGOOoog803oooKO`03oooHO_ooeGcoomEl00Ko
omEl00GoomImoooEO?oodg_oom=kooo@N@02ooo=M`;oolag0_oocGL00oooc7OoolQeooo;MP02ooo<
M`06ooo=MooocWSoolihooo>N?oocgWoom5j0_ooe7/6oooFO@;oomAk00CoomEloooBN_oocgWoolmi
0_ood7T2ooo>N005ooo=MooobWKool]fooo=Moooc7L01?oocWP00oood7Woom9joooFO@03oooJO`03
oooIO_oofWooomb000ooomb01OoogH400ooogX7oomn2oooOPP3ooooOPQ[oomn21?oogh<2oooPQ0?o
on250_ooh8H3oooPQ`;oon680_oohHT2oooQRP;oon6;00?oon:<oooRSOoohXd00_oohXh2oooRS`05
oooST?oohi7oon>AoooSTOoohi800_oohi<00oooi9CoonBEoooTU@02oooTUP03oooTUoooiISoonFI
00;oonFI00CoonFJoooUVoooiY_oonJL0_ooiYd01?ooiYkoonJOoooWWoooij02oooWX@0:oooWX_oo
ij?oonRToooXY?ooj:GoonRVoooXYooojJOoonVXoooYZ@;oonVZ00KoonZ[oooZ[?oojZgoonZ]oooZ
[_oojZl2ooo[/005ooo[/Ooojk;oon^cooo//oook;@00_ook;D00oook;Koonfgooo]^002ooo]^@07
ooo]^_ook[_oonjkooo^_?ook[goonjnooo__`02ooo_`003ooo_`Oookl;ooo3300;ooo3400Sooo35
ooo`a_oolLOooo77oooab?oolLWooo7:ooobb`;ooo;<0_ool/d00ooollkooo??ooocd002ooocd@03
ooodd_oom=?oooCD00;oooCE00WoooCFoooeeooomMSoooGHoooefOoomM[oooKJoooffooom]`00_oo
m]d02?oommkoooOOooogh?oomn3oooOQooogh_oon>;oooSS0_oon>@00ooon>GoooSVoooiiP02oooi
i`03oooij?oonNWoooWY00;ooo[Z00Cooo[[ooojk?oon^gooo[]0_oonnh00ooonnoooo_`oookl002
oookl@;ooocb0_ooo?<00oooo?Coooceooolm@02ooommP;ooogg0ooooOP0057oomn200?oomj1oooK
OooofWl07?oogh801?oofgooomj1oooMPOoog80IoooOPP03oooLP?oofGkoomn200?oomn200?oomj1
oooLP?oogh80K_oogh800ooogX7oomb0oooLP00GoooLP009oooKOooof7koomMmoooIO_oog83oomIm
oooHO_oog83oomYo00coom]o00CoomQnoooGOOooeggoomMm0_ooeG`01ooodg_oom5joooCNooodg_o
olmiooo8MOoocgT00_oodGX01_oodg_oomEloooEO?oodg_oomImoooGO@;oomIm00?oomUnoooGOOoo
eG`00_ooeG`4oooCN`03oooAN_ood7Woolmi00;oom1i0ooocWP01OoobgKoolagooo>N?oocWSoom5j
00;oom9j1?oodGX01?oodg_oomAkoooCNoooeG`2oooFO@03oooEO?ooeggoomUn00koomYo00Coom]o
oooLP?oog83oomf1oooogh8LoooOPPCoomn30_ooh8@2oooPQ@?oon260oooh8L2oooQR0;oon690_oo
hHX2oooQR`;oon:<0_oohXd00ooohXkoon:?oooRS`02oooST0;oon>A00?oon>BoooSTooohi<00_oo
i9@01Oooi9GoonBFoooTU_ooi9OoonFH00;oonFI0_ooiIX2oooUV`;oonJL00KoonJMoooVW_ooiYoo
onNOoooWX?ooij42oooWXP04oooWXoooj:CoonRUoooXY@;oonRV00?oonVWoooYZ?oojJT00_oojJX0
1_oojJ_oonZ/oooZ[?oojZgoonZ^oooZ[`;oon^`00Goon^aooo[/_oojk?oonbcooo/]002ooo/]@03
ooo/]_ookKOoonfh00;oonfi00Coonfjooo^^oook[coonjl0_ook[h00oookkooono0ooo_`@02ooo_
`P06ooo``oool<Cooo35ooo`aOool<Kooo770_oolLP00ooolLWooo7:ooobb`02ooobc0;ooo;=00?o
oo?>oooccooolm000_oolm401_oolm;oooCCooode?oom=CoooCEooodeP;oooGG00?oooGHoooefOoo
mMX00_oom]/01Ooom]coooKMooofgOoommkoooOO00;oooOP00GoooOQooogh_oon>?oooSSooohi002
ooohi@04ooohi_oonNKoooWWoooii`;oooWX00CoooWYooojj_oon^[ooo[[0_oon^`00ooon^gooo_^
oookkP02oookk`03oookl?oono7ooo_a00;ooocb0_ooo?<2ooolm0;oooce0_oooOH00ooooOOooogh
ooomn001ooomn@00DOoogh800ooogH7oomb0oooLP00LoooOPP04oooLP?oogh;oomf1oooLP1Woomn2
00?oomb0oooIO_oogh800ooogh800ooogX7oomb0oooOPP1_oooOPPGoomj15?oogH401ooog83oomUn
oooHO_oofWooomf1oooGOOoofGh03_oogX44oooMP@;oomb000goomUnoooFOOoofGkoom]ooooEO?oo
bGGoom=koooEO?ooeggoomYooooLP?oogH7oomb000;oomf10ooog8001OoofgooomQnoooHO_oof7ko
omMm00CoomQn00CoomEloooBN_oodg_oom=k0_ood7T01_oocgWoolagooo=MooocgWoom1ioooEO0;o
omIm00?oomQnoooIO_oofGh01?oof7h00ooofGkoom]ooooLP003oooLP003oooMPOoogh;oomj100_o
omj1oooogh8QoooOPP;oomn30oooh8@2oooPQ@?oon260_ooh8L3oooQR0;oon690_oohHX2oooQR`;o
on:<00?oon:=oooRS_oohXh00_oohXl2oooST0;oon>A00Coon>BoooSTooohi?oonBD0_ooi9D2oooT
UP;oonBG00?oonFHoooUVOooiIX00_ooiI/01?ooiY_oonJLoooVWOooiYd2oooVWP?oonNP00?oonNQ
oooWX_ooij<00_ooj:@01_ooj:GoonRVoooXYooojJOoonVXoooYZ@;oonVZ00KoonZ[oooZ[?oojZgo
onZ]oooZ[_oojZl2ooo[/005ooo[/Ooojk;oon^cooo//oook;@00_ook;D00oook;Koonfgooo]^002
ooo]^@03ooo]^_ook[_oonjl00;oonjm00Koonjnooo__oookl3oono0ooo_`Oookl82ooo```05ooo`
a?ool<Gooo36oooaaooolLP00_oolLT00ooolL[ooo;;ooobb`03ooobc@03ooocc_oolloooo?@00;o
oo?A00Oooo?Boooddooom=CoooCDooodeOoomMKoooGG00;oooGH00GoooGIoooef_oom]_oooKKooof
g002ooofg@08ooofg_oommooooOOooogh?oomn7oooORooohh_oon><2ooohi003ooohiOoonNKoooWV
00;oooWW00CoooWXoooijOoonNWooo[Z0_oon^/2ooojk003ooojkOoonnkooo__00;ooo__00?ooo_`
oooklOoono400_ooo?801Oooo??ooocdooolm?ooo?Coooce00;ooogf0_oooOL3ooomn000DOoogh80
0ooogH7oomb0oooLP00LoooOPP04oooLP?oogh;oomf1oooLP1Woomn200?oomb0oooIO_oogh800ooo
gh800ooogX7oomb0oooOPP1coooOPP03oooNPOoog83oomb001;oomb000OoomYooooGOOooeWgoomUn
oooLP?ooeGcoomMm01Coomb000[oomUnoooGOOoofGkoomb0oooIO_oobGGoomEloooHO_oofWooomf1
0_oogh800ooog83oomn2oooOPP0<oooOPP04oooNPOoog83oomb0oooLP0;oomQn00GoomElooo>N?oo
dG[oomMmoooEO003oooLP0Soomj1oooogh8coooOPP?oomn31?ooh8@01?ooh8Goon26oooPQ_ooh8H2
oooPQ`?oon680_oohHT2oooQRP;oon6;00?oon:<oooRSOoohXd00_oohXh2oooRS`;oon>@0_oohi42
oooSTP04oooSToooi9CoonBEoooTU@;oonBF0_ooi9L01oooiISoonFIoooUV_ooiI[oonFKoooVVooo
iY`00_ooiYd2oooVWP03oooWWoooij3oonNQ00;oonNR00CoonNSoooXY?ooj:CoonRU0_ooj:H01_oo
jJOoonVXoooYZOoojJWoonVZoooYZ`;oonZ/00?oonZ]oooZ[_oojZl00_oojk000ooojk7oon^booo[
/`03ooo/]005ooo/]Oook;Koonfgooo]^?ookKT00_ookKX2ooo^^`;oonjm00Ooonjnooo__oookl3o
ono0ooo_`Oookl;ooo3300;ooo3400?ooo35ooo`a_oolLL00_oolLP01?oolLWooo7:ooobboool/`3
ooobc@07ooocc_oolloooo?@ooocdOoolm;oooCBooodd`02ooode007ooodeOoom=KoooGGoooeeooo
mMSoooGIoooefP02oooff`05ooofg?oom]goooKMooogg_oomml00_oomn001?oomn7oooORooohh_oo
n><2ooohi003ooohiOoon>KoooWV00;oooWW00CoooWXoooijOoonNWooo[Z0_oon^/00ooon^cooo[]
ooojk@02oookkP;ooo__00Cooo_`oooklOoono7ooocb0oooo?<00oooo?Coooceooolm@02ooommP?o
oogg0OoooOP1ooomn@00DOoogh800ooogH7oomb0oooMP@0LoooOPP04oooLP?oogh;oomj1oooNPAWo
omn200?oomb0oooIO_oogh800ooogh800ooogX7oomb0oooOPP1_oooOPP03oooMPOoog83oomb001Ko
omb000Soom]ooooHO_ooeggoomUnoooLP?ooeWgoomMmoooMP@koomb01?oofWl02ooofgooomQnoooE
O?oof7koomb0oooGOOoobGGoomAkoooFOOooeggoom]o00?oomb03Ooogh800ooogX7oomf1oooLP002
oooLP008oooHO_ooeggoomElooo>N?oodG[oomMmoooEO?oogH7ooooOPSkoomn20_oogh<3oooPQ0?o
on250_ooh8H2oooPQ`;oon680ooohHT2oooQRP;oon6;0_oohX`2oooRS@03oooRS_oohXooon:?00;o
on>@0_oohi400ooohi;oon>CoooST`02oooTU003oooTUOooi9KoonBF00;oonBG00KoonFHoooUVOoo
iI[oonFJoooUVoooiY/2oooVW005oooVWOooiYkoonJOoooWWoooij000_ooij401Oooij;oonRSoooX
Y?ooj:CoonRU00;oonRV00?oonVWoooYZ?oojJT00_oojJX00ooojZ_oonZ/oooZ[002oooZ[P06oooZ
[ooojk3oon^aooo[/Ooojk;oon^c0_ook;@01?ook;Goonbfooo/]_ookKL2ooo]^0;oonfj00?oonjk
ooo^_?ook[d00_ook[h01oookkooono0ooo_`Oookl7oono2ooo``oool<@00_ool<D00oool<Kooo77
oooab002oooab@04oooab_ool/_ooo;;ooobc0;ooo;=00Sooo?>oooccooolm3ooo?@ooocd_oom=;o
ooCCooode0;oooCE00WoooGFoooeeooomMSoooGHoooefOoomM[oooKJoooffooom]`00_oom]d02?oo
m]koooOOooogh?oomn3oooOQooogh_oon>;oooSS0_oon>@00ooon>GoooSVoooiiP02oooii`04oooi
j?oonNWooo[ZooojjP;ooo[[00?ooo[/ooojkOoon^d00_oonnh2oookk`04oookl?oono7ooo_aoool
lP;ooocc0_ooo?@3ooolm@03ooomm_oooOOooogg00;ooogh0OoooOT0057oomn20_oogH4MoooOPP03
oooLP?oogh;oomn201[oomn200?oomb0oooIO_oogh800ooogh800ooogX7oomb0oooOPP28oooOPP07
oooLP?oofWooomUnoooLP?oogX7oomQnoooJO`08oooOPP03oooMPOoog83oomb000Woomb000[oomUn
oooGOOoofWooom]ooooFOOoobGGoom=koooFOOooeggoomYo0_oog8000ooofgooomn2oooOPP0<oooL
P00<oooKOooof7koomUnoooIO_ooeggoomEloooDNooocWSoolmioooEO?ooe7_oomYo6Ooog83ooooO
PRGoomn20ooogh<3oooPQ0;oon250_ooh8H2oooPQ`;oon680ooohHT2oooQRP;oon6;0_oohX`2oooR
S@03oooRS_oohXooon:?00;oon>@00Goon>AoooST_oohi;oon>BoooST`02oooTU003oooTUOooi9Ko
onBG00;oonBG0oooiIT01?ooiI[oonFKoooVVoooiY`2oooVW@05oooVW_ooiYooonNOoooWX?ooij40
0_ooij801?ooij?oonRSoooXY?ooj:D2oooXYP03oooYYooojJSoonVY00;oonVZ00OoonV[oooZ[?oo
jZgoonZ]oooZ[_oojZooon^`00;oon^a00Coon^booo[/oook;?oonbd0_ook;D02?ook;Koonfgooo]
^?ookKSoonfiooo]^_ook[_oonjl0_ook[d02?ook[koonnoooo_`?ookl3oono1ooo_`_ool<?ooo34
0_ool<D00oool<Kooo77oooab002oooab@03oooab_ool/_ooo;;00?ooo;=00?ooo?>oooccooolm00
0_oolm401_oom=;oooCCooode?oom=CoooCEoooeeP;oooGG00KoooGHoooefOoomM[oooKJoooffooo
m]`2ooofg@09ooogg_oommooooOOooogh?oomn7oooORooohh_oon>?oooST00;oooSU00?oooSVoooi
i_oonNL00_oonNP2oooij@04ooojj_oon^_ooo[[ooojk0;ooo[]0_oonnh2oookk`03oookl?oono7o
oo_a00;ooocb00Goooccooolm?ooo?Cooocdooolm@03ooommP03ooommooooOSooogh007ooogh003o
olZ00?oobX00ooo:P01EolZ00000ooo:P03oolZ00?oobX00EOo:P0000?oobX00ooo:P03oolZ005Go
bX00003oolZ00?oobX00ooo:P01EolZ00000\
\>"], "Text",
  ShowCellBracket->False,
  CellMargins->{{0, -3}, {Inherited, 30}},
  Evaluatable->False,
  ImageSize->{850, 115},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  Magnification->1],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Last Slide"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                CounterBox["SlideShowNavigationBar", "LastSlide"]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  Magnification->1],

Cell[CellGroupData[{

Cell[TextData[{
  "Building user interfaces with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "Section",
  CellTags->"ShiftReturn"],

Cell["\<\
This tutorial walks you through a number of steps that show how to produce a \
number of simple user interfaces.\
\>", "Text"],

Cell[TextData[{
  "After completing the tutorial, you should be able to build simple widgets \
and have a grasp of the utility of ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell["", "Text"],

Cell[TextData[{
  "The ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " package:"
}], "Text"],

Cell[TextData[{
  "Provides a way to build user interfaces that are integrated with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellMargins->{{54, Inherited}, {Inherited, Inherited}}],

Cell["\<\
Builds simple little widgets that do basic tasks and builds entire \
applications.\
\>", "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellMargins->{{54, Inherited}, {Inherited, Inherited}}],

Cell[TextData[{
  "Leverages Java technology, via ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  ", but no direct Java programming is required."
}], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellMargins->{{54, Inherited}, {Inherited, Inherited}}],

Cell[TextData[StyleBox["Runs without modification on multiple platforms and \
multiple deployment environments.",
  FontWeight->"Plain"]], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellMargins->{{54, Inherited}, {Inherited, Inherited}}],

Cell[TextData[{
  StyleBox["Allows ",
    FontWeight->"Plain"],
  StyleBox["Mathematica ",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["evaluations to interact with user interface components.",
    FontWeight->"Plain"]
}], "Text",
  CellDingbat->"\[FilledSmallCircle]",
  CellMargins->{{54, Inherited}, {Inherited, Inherited}}]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Last Slide"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                CounterBox["SlideShowNavigationBar", "LastSlide"]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  Magnification->1],

Cell[CellGroupData[{

Cell["Getting started", "Section",
  CellTags->"FunctionSyntax"],

Cell[TextData[{
  "First, load the ",
  StyleBox["GUIKit`", "MR",
    FontVariations->{"CompatibilityType"->0}],
  " package.     "
}], "Text"],

Cell[BoxData[
    \(Needs["\<GUIKit`\>"]\)], "InputOnly",
  CellLabel->"In[1]:="],

Cell["\<\
Then, define a panel that contains three widgets; each widget has a text \
property that is set to an initial value.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(panelExpr1 = \[IndentingNewLine]Widget["\<Panel\>", \
{\[IndentingNewLine]{Widget["\<Label\>", {"\<text\>" -> "\<Result:\>"}], \
\[IndentingNewLine]Widget["\<TextField\>", {"\<text\>" -> "\<some text\>"}, \ 
              Name -> "\<myText\>"]}, \[IndentingNewLine]Widget["\<Button\>", \
{"\<text\>" -> "\<OK\>"}, \ Name -> "\<myButton\>"]\ }]\)], "Input",
  CellLabel->"In[2]:="],

Cell[BoxData[
    \(Widget[
      "Panel", {{Widget["Label", {"text" \[Rule] "Result:"}], 
          Widget["TextField", {"text" \[Rule] "some text"}, 
            Name \[Rule] "myText"]}, 
        Widget["Button", {"text" \[Rule] "OK"}, 
          Name \[Rule] "myButton"]}]\)], "Output",
  CellLabel->"Out[2]="]
}, Open  ]],

Cell["\<\
Although nothing actually appears at this stage, the text field and button \
were given names.\
\>", "Text"]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Last Slide"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                CounterBox["SlideShowNavigationBar", "LastSlide"]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  Magnification->1],

Cell[CellGroupData[{

Cell["Running the user interface", "Section",
  CellTags->"FunctionSyntax"],

Cell[TextData[{
  "Evaluating ",
  StyleBox["GUIRun", "Program"],
  " on the widget expression will display the panel. The first time the ",
  StyleBox["GUIKit`", "MR",
    FontVariations->{"CompatibilityType"->0}],
  " package starts up there is a short delay for initialization."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(active1 = GUIRun[panelExpr1]\)], "Input",
  CellLabel->"In[3]:="],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject475402430578689, 
        JLink`Objects`JavaObject210201571491841]]], "Output",
  CellLabel->"Out[3]="]
}, Open  ]],

Cell[TextData[{
  StyleBox["GUIRun", "MR"],
  " returns a handle that can be used for interacting with the user \
interface. When the panel is displayed, it should look like the following."
}], "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000D2000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3Qh>@0
i^GX0>c[kP3`l?80l_;d03D0lo?d<P3hmoP20??cm0080??cm@3dm?D0mOGf
0?Ccm@3Ui>P0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn
0=kLg`3Th^00NiN]02EGQF/003ad00L05den06^;YP3blNh0l_7c06IVOP2X
ZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0f]SI06J5X@1:LI<0
/[g3J`36aML01`30a/D0B6j@06Z:Y03_ko40IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP3HeMH05den0;o7bP1]0<K5e`060;Jm_@0G
CGh0jn[]06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3I
eMD003ad0?ooo`1]0<g<g`060?ooo`00?7@0j>OZ06IVOP2XZK/0nocm0@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`1]0=;Ai0060?oo
o`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3IeMD003ad0?ooo`1]0=KGi`060?ooo`00?7@0inKY06IVOP2XZK/0nocm
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0a0=WJi`<0
00000`3If^L00`000000fM[W0=WJi`020=WJi`030000003If^L0fM[W02h0
fM[W00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn0=WEe@00?7@0oooo0300fM[W00D000000=WJi`3If^L0fM[W
000000020=WJi`050000003If^L0fM[W0=WJi`000000<@3If^L01P3oool0
03ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0
fMGE000lM03oool0;`3Ngn`00`000000g]o/0=kOk0030=kOk0030000003N
gn`0000000<0g]o/00<000000=kOk03Ngn`0;`3Ngn`01P3oool003ad0>OV
j@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000l
M03oool0;`3SiO000`000000hnG`0>?Ul0030>?Ul0060000003SiO000000
0000003SiO000000<P3SiO001P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40
IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool0;`3YjoD00`00
0000jN_e0>W[m@030>W[m@040000003YjoD000000>W[m@800000<P3YjoD0
1P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY
^`1VIWh0fMGE000lM03oool0;`3`lO`00`000000l?7l0?3ao0030?3ao003
0000003`lO`000000080l?7l00<000000?3ao03`lO`0<03`lO`01P3oool0
03ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0
fMGE000lM03oool0<03dmOd01@000000m?Gm0?Ceo@3dmOd000000080m?Gm
00D000000?Ceo@3dmOd0m?Gm0000000a0?Ceo@060?ooo`00?7@0inKY06IV
OP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?oo
o`0a0?Kgo@<000000`3fmod00`000000m_Om0?Kgo@020?Kgo@030000003f
mod0m_Om02h0m_Om00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo06d0n?cm00H0oooo000l
M03Wi^T0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WE
e@00?7@0oooo06d0oOgm00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IV
OP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo06d0oOgm00H0oooo
000lM03Vi^T0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
0=SDe000?7@0oooo06d0oOgm00H0oooo000lM03UiNP0IVIn0:RY^`3ko?d1
06IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@0UEhD0_lkL06d0oooo00H0
_lkK02EGQ@3QhN@0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0
IVIn0=WEe@1iU:T0EGfR0<3?gF/0oooo00L0eMoX05EmXP1iUJ/0gmgP06IV
OP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0f]OI0=oLf01i
U:T09EN5J`00?7@01`0GCGh0IXJQ0>3NfP3Lfmd0IVIn0:RY^`3ko?d00@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP3OgN00f]OI0=SDe00g0=OCe380dlk<
0`3Gdm@01`3He=@0fMGE0=[Gf@3OgN00IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOR@0h=oSC`2U[;800`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn903Pgn<00`2U[;80oooo0?ooo`1;0?oo
o`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhT
0>3Oh`030:F//P3oool0oooo04/0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOR@0h=oS00<0YJbb0?ooo`3oool0<P3o
ool00`000000oooo0?ooo`0F0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWhT0>3Oh`030:F//P3oool0oooo0380oooo
00<000000?ooo`3oool05P3oool0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn903Pgn<00`2U[;80oooo0?ooo`0b0?ooo`03
0000003oool0oooo01H0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP000000103Pgn<00`000000h=oS0>3Oh`030000
00<0h=oS0`0000030>3Oh`80000000D0h=oS0000003Pgn<000000>3Oh`02
000000030>3Oh`000000h=oS00@0h=oS00<0YJbb0?ooo`3oool0103oool3
000000<0oooo0`0000020?ooo`040000003oool0oooo00000080oooo00<0
00000?ooo`3oool00`0000050?ooo`8000000P3oool300000080oooo00H0
00000?ooo`3oool0oooo0000003oool2000000030?ooo`000000oooo01L0
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP0000000`3Pgn<010000000h=oS0>3Oh`0000030>3Oh`030000003Pgn<0
000000<0h=oS00<000000>3Oh`0000000P3Pgn<2000000040>3Oh`000000
h=oS000000P0h=oS00<0YJbb0?ooo`3oool00`3oool01`000000oooo0?oo
o`3oool000000?ooo`0000000`3oool00`000000oooo000000020?ooo`06
0000003oool0oooo0000003oool000000`3oool00`000000oooo0?ooo`02
0?ooo`040000003oool0oooo000000<0oooo00H000000?ooo`3oool00000
0?ooo`0000020?ooo`040000003oool0oooo000001P0oooo00@0YJbb06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000000`3Pgn<0
10000000h=oS0>3Oh`0000080>3Oh`040000003Pgn<0h=oS000000<0h=oS
00D000000>3Oh`000000h=oS000000080>3Oh`030:F//P3oool0oooo00H0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo000000020?oo
o`060000003oool0oooo0000003oool00000203oool010000000oooo0?oo
o`0000070?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`0F0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh000000080h=oS00@000000>3Oh`3Pgn<0h=oS1@000002
0>3Oh`8000000`3Pgn<02@000000h=oS0>3Oh`3Pgn<000000>3Oh`000000
h=oS000000080>3Oh`030:F//P3oool0oooo00@0oooo0P0000030?ooo`07
0000003oool0oooo0?ooo`000000oooo000000020?ooo`050000003oool0
oooo0000003oool01@0000040?ooo`030000003oool0oooo00D000000`3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
5P3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn1@0000020>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS00000003
0>3Oh`030000003Pgn<0000000<0h=oS00D000000>3Oh`000000h=oS0000
00080>3Oh`030:F//P3oool0oooo00<0oooo00L000000?ooo`3oool0oooo
0000003oool0000000<0oooo00D000000?ooo`00000000000?ooo`020000
00040?ooo`000000oooo000000<0oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000030?ooo`060000003oool0oooo0000003oool0
00000P3oool010000000oooo0?ooo`00000H0?ooo`040:F//P1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000@0h=oS00<00000
0>3Oh`3Pgn<00`0000030>3Oh`<000000P3Pgn<01P000000h=oS0>3Oh`3P
gn<000000>3Oh`@0000000<0h=oS0000003Pgn<0103Pgn<00`2U[;80oooo
0?ooo`040?ooo`<000000`3oool300000080oooo00<000000?ooo`000000
0P3oool010000000oooo0?ooo`3oool3000000@0oooo0`0000020?ooo`<0
00000P3oool010000000oooo0?ooo`3oool4000000030?ooo`000000oooo
01L0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP000000103Pgn<00`000000h=oS0>3Oh`0A0>3Oh`030000003Pgn<0
000000P0h=oS00<0YJbb0?ooo`3oool0803oool00`000000oooo0?ooo`0<
0?ooo`040000003oool0oooo000001P0oooo00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPD00000503Pgn<00`000000h=oS
000000080>3Oh`030:F//P3oool0oooo0200oooo00<000000?ooo`3oool0
303oool010000000oooo0?ooo`00000H0?ooo`040:F//P1VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWhT0>3Oh`030:F//P3oool0oooo
0380oooo00<000000?ooo`3oool05P3oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn903Pgn<00`2U[;80oooo0?ooo`0b
0?ooo`030000003oool0oooo01H0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOR@0h=oS00<0YJbb0?ooo`3oool0<P3o
ool00`000000oooo0?ooo`0F0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWhT0>3Oh`030:F//P3oool0oooo0380oooo
00<000000?ooo`3oool05P3oool0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn903Pgn<00`2U[;80oooo0?ooo`1;0?ooo`04
0:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhT0>3O
hdl0YJbb00<0IVIn0:RY^`3ko?d00@1VIWh0000306IVOP3gmoT0V9RW07D0
MgNB0@2HV:L10?Ogn@40IVIn00000`1VIWh0moOi0;bmc@1f0;bmc@40moOi
0@1VIWh0000306IVOP3gmoT0i>?S07H0i>?S0@3gmoT106IVOP0000<0IVIn
0?3am03oool0;`3oool00`3Thn<0W:Bi06]eS`0306]eS`0406afT01[MHl0
K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>CSh`2LY;T406]eS`04
06afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>cZjP2L
Y;T40:HiA0040:LjA02V>D@0YcY40:LjA0T0YSU400<0W:Bi0>cZjP3oool0
0`3oool10?3am040IVIn00005P1VIWh0h^7R0?_lo03kno`0nocm0?cko@3k
nod0nocm0?_lo03lo?d0o?cl0?cko@3lo?`0o?_l0?clo03ko?`0o?cl0?_l
o@3lno`0o?cm0?_ko@3ko?`20?clo0040?clo@3lo?`0no_m0?cloA@0o?_l
0P3ko?`00`2LY;T0JgF?08F9/00@08F9/00606]eS`2LY;T0nocm0?_lo@2L
Y;T0JgF?4@25RK001P1[MHl0W:Bi0?_lo03kno`0W:Bi0:HiA140ZSaE00L0
YSU409bT^@3ko?`0o?cl0?cko@3ko?d0h^7R0040IVIn0000101VIWh0h>3Q
0?Kgn@3gmoT20?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0moOh0?Ogn@3g
m_P0m_Oi0?Ogn@3fmoT00P3gmoT0103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@03
0?Kgn03gmoT0moOi01<0moOi0P3fmoT00`1[MHl0QHV`09bN_P0@09bN_P06
08F9/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03g
moP0YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh
0?Ogn@3gmoP0moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3a
m03`l_@@000000060?7am03`l_D0lO7d0?7bm03`l_@0lO7d5P3`lOD00`1[
MHl0/[G@0:NX`P0@0:NX`P060;:ed01[MHl0l?7d0?3am01[MHl0/[G@4@2W
Z<801@2b]M00JgF?0?3am@3al_@0YSU40080`U9K00<0beAI0<eIGP3=FEh0
2`3=FEh0103;E5T0`U9K0<9BF`2V>D@20?3am0030?7am03`l_@0g]gQ0040
IVIn00001`1VIWh0g=_P0>[[l03Zjo00j^c`0>W[k`0000000P3WinL20=kN
gP80inOW00<0ikf40>OWi`3WinL00`3WinL20>o_k`040000003Zjo00j^_`
0>[[k`80j^_`00<0j^__0>[[l03Zjo004P3Zjo020>[/l00406]eS`2f^M40
[Jk60:f^aPP0oooo00<0[Jk60:b^aP2][/H00`2][/H00`2/[/H0][WA06]e
S`020>[[k`0406]eS`2f^M40[Jk60:f^aP`0oooo0P2][/H00`2/[/H0][WA
06]eS`020>[[l0050:HiA03=FEh0beAI0<eFF`3>FEl02`3@FUl01`3>FEl0
cEIK0<]DF@3=FEh0YSU40>[[k`3Zjo000P3Zjnl10=cKh040IVIn0000101V
IWh0fMWO0>?UjP3Si>X20>?Uj`050000002<S8`0g]kN0>OWi`3Ng]h00P3W
inL00`36H`00inOW0>OWi`020>OWi`070>o_i`3_knl0kno_0000003Si>X0
hnC[0>?UjP020>?TjP030>?Tj`3SiN/0hnG[0180hnG[0P3Si>X01@1[MHl0
_;kD0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l
_]@0JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH02@0U
9CH30;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO
0?ooo`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0
hnGZ0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0g=kV00D0
00000>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW0>ONaP3_
S1000`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H05P3Lg^D0
1@1[MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h
^Lh01P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo02DU=P2h
^Lh01`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0g=kV0=cN
i@2V>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`0505<U803D
GF40dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IVOP0000@0
IVIn0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0ikF40=IJ
003FQ000olh00<iS00020=i[00050>neS03_knl0kno_0>o_k`0000000P3E
f>40103Een00e]SP0=KHh@3Fen4D0=KGh080e]SP00D0JgF?0<?5f@2l_M40
_;gA0?ooo`0702DU=PL0_;gA00H0`lGI06]eS`3Ef>40eMSQ06]eS`33aMT2
0;bmd@030?ooo`0U9CH0_;gA00L0_;gA00<0oooo02DU=P2l_M400P2l_M40
1@33aMT0JgF?0=KGh03Een40YSU40080eEeP00<0f61Q0=UQHP167QX00`3o
ool30=UQHP<0oooo00<0AQhJ0=UQHP3HH6400P3EGF001P2V>D@0e]SP0=GH
h@3Een00eMSQ0=GFg@40IVIn00001`1VIWh0d]CM0<oBg03@d]`0d=;M0=3B
g00000000`3WinL0303Wg/h0aTX00?O>003_[@00kkD00<i[0036FP00aV/0
0=j<BP3WY@00knO>000000<0d=;L00<0cm;L0=3Bg03?d]`0503@d]`20<oB
g@0306]eS`38bM/0`lCF0100`lCF00H0b<WK06]eS`3@d]`0d=;L06]eS`38
bM/20<?4eP030?ooo`0U9CH0`lCF00L0`lCF00<0oooo02DU=P33a=H00P33
a=H01`38bM/0JgF?0<oBg03?d]`0YSU40=MOG`3IHF800`3LIFD01@167QX0
oooo0?ooo`3oool0g6EU00<0oooo00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3G
Gel0YSU40=3Bg@80d=;L0@3?d]`10=;Dg@40IVIn0000701VIWh0d=;K0<_=
f03:cMT0blkH0<[=f0000000ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd0
0>NU003FS000cV/00>O6003oeP00knoW0>o_k`000000blgH0<_=f@3:cMT0
blkH0<[=f03;cMPD0<_=f@80blkI00<0JgF?0<_<gP38b]T02038b]T00`38
bMT0b<[I0<S:f@030<S:f@040<S9f@38b]T0blcN06]eS`80blgH00H0JgF?
0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U
9CH0b<[I0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:HiA03GGel0ffAT0>1W
I@3PIVD00P3NIfL00`167QX0oooo0?ooo`030?ooo`0:04HN6P3NIfL0gVMW
0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI0@3@d]/106IVOP00
00<0IVIn0<o?fP35b=@00`35b=@01P000000a/K60>ONeP3>N`00ijd00>ne
0080ijD000<0eY@00<ic003FU0000P3gaP020?Ogm`0400000035b=@0aLOD
0<G7e0<0aLOE5034amD20<C8e00306]eS`3@dN00bl_L0100bl_L00H0d=7P
06]eS`34am@0a<OD06]eS`3@dN020<_;g0030?ooo`0U9CH0bl_L00L0bl_L
00<0oooo02DU=P3;bm`00P3;bm`01`3@dN00JgF?0<G7e034am@0YSU40=]T
I03OIF@01@3PJVP01@167QX0oooo0?ooo`3oool0AQhJ00D0h6YX00@0gfET
0=]TI02V>D@0a<SE0P34b=@10<G7e@40cloJ0@1VIWh0000406IVOP3<c]X0
`/CB0<74d@80`LCB00H000000>OWi`3WinL0inOW0=J4003_]@020>NU0008
0=J4003>J`00ijd00?Ne003g_@00kno_0?Ogm`0000030<74dP030<;4d@31
a=80`LCB01@0`LCA0P31a=800`1[MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[
MHl0`/CB0<;4dP1[MHl0dm?R0P3?d=d00`3oool09BDf0<o@g@070<o@g@03
0?ooo`0U9CH0cm3M0080cm3M00L0dm?R06]eS`32a=80`LCA0:HiA03KI6@0
hFUU00D0h6aY1@3oool50>1/J@080>5YI@3KI6@0YSU40<74dP32a=40`LCA
0<74dP3<c]X106IVOP0000@0IVIn0<[<f02n`<l0_L3?0P2n`<h01@000000
W9bL0>OWi`3Wg]H0eX`00080gY@000@0eW/00<IS002m@P00kjD00P3g[@00
203g]@00oli:0000002n`<h0_/3?0;k0cP2n`<l0_L3>5@2n`<h20;g0cP03
06]eS`3Fe^@0dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@2
0=?Ch0030?ooo`0U9CH0oooo00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KF
i01[MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?oo
o`3oool0oooo103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:
c=P106IVOP0000L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_
01<0eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic003_W000mnoW0?Og
m`3oool000000;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;01@0^Kc<0P2j_<`0
0`1[MHl0f=SU0=?Ch@0@0=?Ch@060=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU
0P3Cdn400`3oool0KVf?06i]S`0806i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3H
f>D0JgF?0;Zlb`2j_<`0YSU40>1YJ03QKF`0i75]0>AaK`3TL6h30?ooo`03
04HN6P3TL6h0AQhJ00<0oooo0P3TL6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<
0;Zkc02i_</0][S80<W:f00106IVOP0000T0IVIn0<O9e`2d]/L0][S80;Jh
b@2f^LT0000008B4Q03Wimh00P3_knl01`36J`00mlH00>ne003_W000gX`0
0<i[003WW0000`3gmoL01@000000][W90;Nhb@2f^LT0]kW90080][S9502g
^<T20;Jhb@0406]eS`3Fe^@0f=SU0=SHiP<0f=SU1@3Hf>H30=SHi@80f=SV
0P3Hf>D02@3Fe^@0JgF?0;Nhb@2g^<T0JgF?0=KFi03Hf>D0f=SV0?ooo`0:
06i]S`0=02DU=P3Hf>H0f=SU0=SHi@3Fe^@0JgF?0;Nhb@2g^LT0YSU40>A^
K@3TM6l0ig5_0>AdK`030?ooo`0504HN6P3TM6l0i7A_0>AdK`167QX00`3o
ool02P3TM6l0ig5_0>AdK`3TKVd0YSU40;Jib@2f^<T0][W90;Bfa`37bML1
06IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L00`000000kno_0>o_k`020>o_
k`0;0>N]003gaPP0ijD00>ND003WS000knOF0=jD>@3_e[D0ooOg0?ooo`00
0000702d]/L01@1[MHl0eMGS0=cKi`3LfnL0gM_W00h0g=_W00H0eMGS06]e
S`2d]/L0];K706]eS`3EeN<20=cKi`030=gKi`0U9CH09BDf00T09BDf0`3L
fnL02@3EeN<0JgF?0;Bfa`2d]/L0YSU40>McK`3WMG80jWIc0>YhMP020?oo
o`0304HN6P3YOWP0jGih00<0jGih00P0AQhJ0?ooo`3oool0jWQf0>YfL`3W
MG80ig=_0:HiA0@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2d]/L00`2d
]/L01P000000S8b<0>o_k`3_knl0ilik0>o_k`80moOg00P0ii@00?OWcP3g
moL0moOg0>oWeP3gmoL0oooo000001`0];K700<0JgF?0=GDh`3PgnX0403P
gnX01P3Ee><0JgF?0;Bfa`2d]/L0JgF?0=GDha40h=oZ00T0eMCS06]eS`2d
]/L0];K70:HiA03ZNG<0jGah0>n1NP3bRH400P167QX01`3[V8/0jY^<0>fG
RP3[V8/0jY^<0>fGRP3[V8/00P167QX01@3bRH40kh5j0>UlN03ZNG<0YSU4
00@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2a/lP00`2a/lP01P000000
kno_0>o_k`3_knl0moO_0>o_k`80moOg00<0mnO60?Ogm`3oool00`3gmoL0
0`3oool000000;6cb00K0;6cb00306]eS`3]jo<0jNSa0100jNSa00H0kN_c
06]eS`2a/lP0/K?806]eS`3]jo<A0>WXl@0I0>g[l`1[MHl0/K?80;6cb02V
>D@0lH1e0?24O03eS8@0mif>0?:[UP3a/Y/0kKBK0>beW03a/Y/0kKBK0>be
W03a/Y/0kKBK0>beW03bZiH0mif>0?F<Q03`Q7`0lH1e0:HiA0040;6cb040
a/SG0@1VIWh0000306IVOP36b=L0^;O?00<0[jk700D000000:f][@3gmnl0
moOg0>o_k`060?Ogm`80ooOg0P3oool00`000000[jk70:n^a`0J0:n^a`03
06]eS`3BdN<0l_7g0100l_7g00H0d]7S06]eS`2_[/L0[jk706]eS`3BdN<A
0?;am`060=;Ah`1[MHl0[jk70:n^a`2V>D@0m8Ym0P3eT8D=0?:hWP80mI25
00<0m8Ym0:HiA02_[/L00P2_[/L10;Rgc`40a/SG0@1VIWh0000306IVOP30
`M40alOD02l0[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M
06]eS`24S:820:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;
g@1[MHl0Q8bR0P2/Zl@01`2AV:X0YSU40?nOS@3n_j@0n]bg0?[[]`3jjKH0
0P3ijKH0103jjKH0nNVf0?WY]P3jjKH20?WY]P060?[[]`3jg;L0o[nT0?nO
S@2V>D@0TIRZ0`2/Zl@10<O7e040`<7A0@1VIWh0000406IVOP30`M40d];O
0;FdbBl0Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P02
0:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh0
0`24S:80YSU40:HiA00?0:HiA00708B<XP2TXkh0Y:>n0:BS_P2e]<T0d];O
0<31d@0106IVOP0000H0IVIn0:RW_`3Vi^d0d];P0;blc`2a/<A_0:RW_`05
0;6`a02l_<l0d];P0>KVk@2XYkl00@1VIWh0000705QGJ027Qi/0emSR0?cl
o03ThnP0d=3P0<[:fP1]0;blc`060<[:fP3@d>00i>?X0?clo03Gf>80QhNK
0@1HEfP0000805QGJ01VIWh0UIB[0=OHhP3lo?`0l_7c0>c[kP3Qh^][0=OH
hP070>7Rj`3/jnh0l_7c0?clo03Gf>80UIB[06IVOP0105QGJ0000P1HEfP0
0`1VIWh0UIB[0=7AgP020?clo6d0oooo0P3lo?`00`3AdMh0UIB[06IVOP02
05QGJ0000`1HEfP206IVOP0308R7W@2EU:/0Z:No06`0Z:No00@0UIB[08R7
W@1VIWh0IVIn0`1HEfP000D0F5MXL@1VIWh505QGJ000\
\>"], "Text",
  Evaluatable->False,
  ImageSize->{123, 80},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell["\<\
Note how the arrangement of the widgets was carried out automatically, and \
resizing the window also resizes the widgets appropriately.\
\>", "Text"]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Last Slide"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                CounterBox["SlideShowNavigationBar", "LastSlide"]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  Magnification->1],

Cell[CellGroupData[{

Cell["Interacting with the panel", "Section",
  CellTags->"NumericalValues"],

Cell[TextData[{
  "This user interface does not have any interactivity built in to respond to \
particular events. Initially, you can query the runtime user interface to see \
what named widgets it contains using ",
  StyleBox["GUIInformation", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<WidgetNames\>"\  /. \ GUIInformation[active1]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \({"myButton", "myText"}\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]],

Cell[TextData[{
  "You can also see what events named widgets will respond to with ",
  StyleBox["GUIInformation", "MR"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\("\<EventNames\>"\)\(/.\)\(\ \)\(GUIInformation[
        active1\ , "\<myButton\>"]\)\(\ \)\)\)], "Input",
  CellLabel->"In[5]:="],

Cell[BoxData[
    \({"Action", "ActionPerformed", "Ancestor", "AncestorAdded", 
      "AncestorMoved", "AncestorRemoved", "AncestorResized", 
      "CaretPositionChanged", "Change", "Component", "ComponentAdded", 
      "ComponentHidden", "ComponentMoved", "ComponentRemoved", 
      "ComponentResized", "ComponentShown", "Container", "Focus", 
      "FocusGained", "FocusLost", "Hierarchy", "HierarchyBounds", 
      "HierarchyChanged", "InputMethod", "InputMethodTextChanged", "Item", 
      "ItemStateChanged", "Key", "KeyPressed", "KeyReleased", "KeyTyped", 
      "Mouse", "MouseClicked", "MouseDragged", "MouseEntered", "MouseExited", 
      "MouseMotion", "MouseMoved", "MousePressed", "MouseReleased", 
      "MouseWheel", "MouseWheelMoved", "PropertyChange", "StateChanged", 
      "VetoableChange"}\)], "Output",
  CellLabel->"Out[5]="]
}, Open  ]],

Cell[TextData[{
  "Note the event called ",
  StyleBox["Action", "MR"],
  ", which will be used in a later slide."
}], "Text"]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Last Slide"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                CounterBox["SlideShowNavigationBar", "LastSlide"]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  Magnification->1],

Cell[CellGroupData[{

Cell["Other commands for interacting", "Section",
  CellTags->"NumericalValues"],

Cell[TextData[{
  "Another useful introspective rule set is ",
  StyleBox["PropertyNames", "MR"],
  " that returns the list of a widget\[CloseCurlyQuote]s characteristics, \
which you can further process using optional string match filtering."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select["\<PropertyNames\>"\  /. \ 
        GUIInformation[
          active1, "\<myText\>"], \[IndentingNewLine]StringMatchQ[#, \
"\<*size*\>", \ IgnoreCase \[Rule] \ True] &]\)], "Input",
  CellLabel->"In[6]:="],

Cell[BoxData[
    \({"MaximumSize", "MaximumSizeSet", "MinimumSize", "MinimumSizeSet", 
      "PreferredScrollableViewportSize", "PreferredSize", "PreferredSizeSet", 
      "Size"}\)], "Output",
  CellLabel->"Out[6]="]
}, Open  ]],

Cell[TextData[{
  "There are other introspective commands that can query the interface. \
Additionally, ",
  StyleBox["WidgetReference", "MR"],
  " returns the underlying object from a name."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(active1\ @\ WidgetReference["\<myButton\>"]\)], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "javax.swing.JButton"] \[RightGuillemet]\),
      JLink`Objects`JavaObject386770596265985]], "Output",
  CellLabel->"Out[7]="]
}, Open  ]]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Last Slide"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                CounterBox["SlideShowNavigationBar", "LastSlide"]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  Magnification->1],

Cell[CellGroupData[{

Cell["Hooking up an event", "Section",
  CellTags->"NumericalValues"],

Cell[TextData[{
  "Now a new panel will be constructed. This adds an event handler to ",
  StyleBox["myButton", "MR"],
  " that causes the string ",
  StyleBox["button pressed", "MR"],
  " to be inserted in the notebook whenever the button is clicked."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(panelExpr2 = 
        Widget["\<Panel\>", {\[IndentingNewLine]{Widget["\<Label\>", {"\<text\
\>" -> "\<Result:\>"}], \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<some text\>"}, \ 
                Name -> "\<myText\>"]}, \
\[IndentingNewLine]Widget["\<Button\>", {"\<text\>" -> "\<OK\>", \
\[IndentingNewLine]BindEvent["\<action\>", \ 
                  Script[Print["\<button pressed\>"]]]}, \ 
              Name -> "\<myButton\>"]\ }];\)\), "\[IndentingNewLine]", 
    \(active2 = GUIRun[panelExpr2]\)}], "Input",
  CellLabel->"In[8]:="],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject457544392769537, 
        JLink`Objects`JavaObject329220131651585]]], "Output",
  CellLabel->"Out[9]="],

Cell[BoxData[
    \("button pressed"\)], "Print"],

Cell[BoxData[
    \("button pressed"\)], "Print"],

Cell[BoxData[
    \("button pressed"\)], "Print"]
}, Open  ]],

Cell["", "Text"]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Last Slide"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                CounterBox["SlideShowNavigationBar", "LastSlide"]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  Magnification->1],

Cell[CellGroupData[{

Cell["Hooking up an event - continued", "Section",
  CellTags->"NumericalValues"],

Cell["\<\
An alternative way to add an event handler to a widget is to place it \
anywhere in the enclosing definition and refer to the widget by its name.\
\>", "Text"],

Cell[BoxData[
    \(\(Widget["\<Panel\>", {\[IndentingNewLine]{Widget["\<Label\>", {"\<text\
\>" -> "\<Result:\>"}], \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<some text\>"}, \ 
              Name -> "\<myText\>"]}, \[IndentingNewLine]Widget["\<Button\>", \
{"\<text\>" -> "\<OK\>"}, \ 
            Name -> "\<myButton\>"], \
\[IndentingNewLine]BindEvent[{"\<myButton\>", "\<action\>"}, \ 
            Script[Print["\<button pressed\>"]]]}];\)\)], "InputOnly",
  CellLabel->"In[10]:="],

Cell[TextData[{
  "This definition has the same functionality as the definition ",
  StyleBox["panelExpr2", "MR"],
  " in the previous slide."
}], "Text"]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Last Slide"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                CounterBox["SlideShowNavigationBar", "LastSlide"]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  Magnification->1],

Cell[CellGroupData[{

Cell["Hooking up an event - continued", "Section"],

Cell["\<\
This definition adds an event handler that changes part of the panel by \
setting the property value of another widget.\
\>", "Text"],

Cell[BoxData[{
    \(\(panelExpr3 = 
        Widget["\<Panel\>", {\[IndentingNewLine]Widget["\<Button\>", {\
\[IndentingNewLine]"\<text\>" -> "\<Click Here\>", \
\[IndentingNewLine]BindEvent["\<action\>", 
                  Script[setText[]]]}], \
\[IndentingNewLine]Widget["\<TextField\>", {"\<columns\>" \[Rule] 20\ }, 
              Name \[Rule] "\<TextOutput\>"], \[IndentingNewLine]Script[\ 
              setText[] := \[IndentingNewLine]SetPropertyValue[{"\<TextOutput\
\>", "\<text\>"}, \[IndentingNewLine]ToString[Random[], \ 
                    InputForm]]\[IndentingNewLine]\ \ ]\[IndentingNewLine]}];\
\)\), "\[IndentingNewLine]", 
    \(\(active3 = GUIRun[panelExpr3];\)\)}], "InputOnly",
  CellLabel->"In[11]:="],

Cell["\<\
Every time the button is clicked a new random number is written into the text \
field. Once the button has been clicked, the panel should look something like \
the following.\
\>", "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002c0000D2000`400?l0
0000o`00003o/`1VIWh0000306IVOP3ko?d0nocm0:l0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0:h0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
[@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOZ/0YJbb
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;80
Z@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn0:F//P2Y0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0YJbb0:T0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP2U[;80Z@3oool0102U[;80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P2Y0?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb00H0oooo
0`0000030?ooo`030000003oool0oooo00<000001@3oool010000000oooo
0?ooo`3oool300000080oooo1@0000000`3oool000000000000300000080
oooo00<000000?ooo`3oool00`3oool3000000<0oooo0`0000040?ooo`03
0000003oool0oooo0080oooo0`0000020?ooo`D0000000<0oooo00000000
00000`0000040?ooo`040000003oool0oooo0?ooo`<000000`3oool30000
00D0oooo00<000000?ooo`3oool0>`3oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P050?ooo`050000003oool0
oooo0?ooo`000000103oool01@000000oooo0?ooo`3oool0000000@0oooo
00@000000?ooo`3oool000000`3oool010000000oooo0?ooo`0000050?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool01`00
0000oooo0?ooo`3oool000000?ooo`0000000`3oool01@000000oooo0?oo
o`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool010000000
oooo0?ooo`0000030?ooo`030000003oool0000000<0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0k0?ooo`040:F//P1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb00D0oooo00D00000
0?ooo`3oool0oooo000000040?ooo`060000003oool0oooo0?ooo`000000
oooo1@0000050?ooo`050000003oool0oooo0?ooo`0000001@3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo00L000000?oo
o`3oool0oooo0000003oool0000000<0oooo00D000000?ooo`3oool0oooo
000000070?ooo`050000003oool0oooo0?ooo`0000001@3oool010000000
oooo0?ooo`3oool5000000D0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo00000004000003`0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP2U[;801@3oool01@000000oooo0?ooo`3o
ool0000000@0oooo00L000000?ooo`3oool0oooo0000003oool000000080
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3oool01@00
0000oooo0?ooo`3oool0000000@0oooo100000040?ooo`030000003oool0
oooo00<0oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000P3o
ool00`000000oooo0?ooo`0k0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0YJbb00D0oooo00D000000?ooo`3oool0
oooo000000040?ooo`@000000`3oool00`000000oooo000000040?ooo`80
00001P3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?oo
o`000000103oool300000080oooo00D000000?ooo`3oool0oooo00000003
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00<0oooo00H000000?ooo`3oool00000
0?ooo`0000020?ooo`@00000103oool2000000<0oooo00<000000?ooo`00
0000?@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0:F//P050?ooo`050000003oool0oooo0?ooo`000000103oool0
0`000000oooo0?ooo`040?ooo`030000003oool0000000H0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0000
00030?ooo`050000003oool000000?ooo`0000000`3oool01@000000oooo
0?ooo`3oool0000000D0oooo00<000000?ooo`3oool00`3oool01P000000
oooo0?ooo`000000oooo00000080oooo00<000000?ooo`3oool01`3oool0
1P000000oooo0?ooo`000000oooo000003d0oooo00@0YJbb06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;801@3oool01@000000
oooo0?ooo`3oool0000000@0oooo00D000000?ooo`3oool0oooo00000003
0?ooo`8000000P3oool01`000000oooo0?ooo`3oool000000?ooo`000000
0`3oool00`000000oooo000000030?ooo`030000003oool0oooo0080oooo
00@000000?ooo`3oool000000`3oool00`000000oooo000000030?ooo`03
0000003oool0oooo008000000`3oool01`000000oooo0?ooo`3oool00000
0?ooo`0000000`3oool00`000000oooo000000030?ooo`040000003oool0
oooo0?ooo`8000000`3oool00`000000oooo0?ooo`020?ooo`050000003o
ool0oooo0?ooo`0000000`3oool2000003d0oooo00@0YJbb06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;801P3oool3000000H0
oooo0`0000050?ooo`040000003oool0oooo0?ooo`<000000`3oool30000
00<0oooo0`0000020?ooo`D000000P3oool3000000<0oooo0`0000040?oo
o`030000003oool0oooo0080oooo0`0000030?ooo`<000000`3oool30000
00D0oooo00@000000?ooo`3oool0oooo100000020?ooo`<000001@3oool0
0`000000oooo0?ooo`0k0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0YJbb0:T0oooo00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;80Z@3oool0102U[;80IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P2Y0?ooo`04
0:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb
0:T0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP2U[;80Z@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn
0?_lo@2XZK/0IVInZ`2U[;800`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVInZ`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVInZ`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVInZ`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000T0IVIn
0?_lo@2XZK/0IVIn0>7Pi03ViNP0k>_^0?3`lP3bl_@0D@3cloA>0?Sgn080
lo?d00P0lo?e0?Cdm@3emOH0m??e0>GTj01VIWh0Z:Vk0?_lo@40IVIn0000
201VIWh0nocm0:RY^`1VIWh0g]cO0>CRh01kUjd09EN5X`00?7@01`0GCGh0
Jh^V0?;akP3blO<0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk
06IVOP3Jf=T0IXFQ02M=Q@1=OL6T06V2kP0602M=Q@1ZRZ@0knoa06IVOP2X
ZK/0nocm0@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3HeMH05denY`29[N@0
1@0GCGh0jn[]06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1V
IWh0fMGE000lM029[N@0ooooX`3=c=l01`3oool0RJgT000lM03XinX0IVIn
0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad08^]
i03ooonS0=;Ai0070?ooo`2;[nD003ad0>OVj@1VIWh0Z:Vk0?_lo@0106IV
OP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0SZoV0?oooj<0e]OW00L0
oooo08f_i@00?7@0inKY06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm
0:RY^`1VIWh0fMGE000lM02A/NL0oooo>`3If^L300000080fM[W00<00000
0=WJi`0000000P3If^L300000080fM[W00@000000=WJi`3If^L00000103I
f^L00`000000fM[W0=WJi`020=WJi`030000003If^L0fM[W00<000000P3I
f^L00`000000fM[W0=WJi`020=WJi`<00000?03If^L01`3oool0TK7V000l
M03Wi^T0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3I
eMD003ad09Bdj03ooolj0=WJi`0;0000003If^L0fM[W0=WJi`000000fM[W
0000003If^L000000=WJi`0000000`3If^L01@000000fM[W0000003If^L0
000000D0fM[W00<000000=WJi`3If^L00P3If^L00`000000fM[W00000003
0=WJi`030000003If^L0000000<0fM[W00D000000=WJi`3If^L0fM[W0000
000k0=WJi`070?ooo`2E]>P003ad0>OVj@1VIWh0Z:Vk0?_lo@0106IVOP00
00P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0V;SZ0?ooocT0g]o/00<00000
0=kOk03Ngn`0103Ngn`01@000000g]o/0000003Ngn`0000000D0g]o/00<0
00000=kOk00000001@3Ngn`00`000000g]o/0=kOk0020=kOk0030000003N
gn`0000000D0g]o/00D000000=kOk03Ngn`0g]o/0000000o0=kOk0070?oo
o`2H^>T003ad0>OVj@1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2X
ZK/0IVIn0=WEe@00?7@0W;_Z0?ooocT0hnG`00<000000>?Ul03SiO00103S
iO001@000000hnG`0000003SiO00000000D0hnG`0P0000060>?Ul0030000
003SiO00hnG`0080hnG`00<000000>?Ul0000000100000000`3SiO000000
0>?Ul0020>?Ul0D00000>`3SiO001`3oool0W;_[000lM03Wi^T0IVIn0:RY
^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0:2nk03o
ooli0>W[m@030000003YjoD0jN_e00@0jN_e00D000000>W[m@000000jN_e
000000030>W[m@050000003YjoD000000>W[m@0000001@3YjoD600000003
0>W[m@000000jN_e0080jN_e00@000000>W[m@00000000000P3YjoD01@00
0000jN_e0>W[m@3YjoD0000003/0jN_e00L0oooo0:6nk000?7@0inKY06IV
OP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM02U
`Nd0oooo>@3`lO`00`000000l?7l0?3ao0040?3ao0030000003`lO`00000
0080l?7l0`0000020?3ao0040000003`lO`0l?7l000000@0l?7l00<00000
0?3ao03`lO`00P3`lO`00`000000l?7l0?3ao00300000080l?7l00<00000
0?3ao00000000P3`lO`3000003`0l?7l00L0oooo0:G2kP00?7@0inKY06IV
OP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM02Y
aNl0oooo>P3dmOd01`000000m?Gm0?Ceo@3dmOd000000?Ceo@0000002@3d
mOd00`000000m?Gm0?Ceo@050?Ceo@030000003dmOd0m?Gm0080m?Gm00<0
00000?Ceo@3dmOd0B@3dmOd01`3oool0ZLG_000lM03Wi^T0IVIn0:RY^`3k
o?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0:g8l03ooolk
0?Kgo@<000000P3fmod00`000000m_Om000000070?Kgo@030000003fmod0
m_Om00D0m_Om00<000000?Kgo@3fmod00P3fmod00`000000m_Om0?Kgo@19
0?Kgo@070?ooo`2/ao0003ad0>OVj@1VIWh0Z:Vk0?_lo@0106IVOP0000P0
IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0/L_b0?oooj<0n?cm00L0oooo0;7<
lP00?7@0inKY06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1V
IWh0fMGE000lM02dcO<0ooooX`3moOd01`3oool0]Lkc000lM03Wi^T0IVIn
0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0;O@
m03ooonS0?gmo@070?ooo`2hd?D003ad0>KVj@1VIWh0Z:Vk0?_lo@0106IV
OP0000P0IVIn0?_lo@2XZK/0IVIn0=SDe000?7@0^]?e0?oooj<0oOgm00L0
oooo0;[CmP00?7@0iNGX06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm
0:RY^`1VIWh0fMGE02EGQJL0_=Cf00D09EN50>7Qi01VIWh0Z:Vk0?_lo@01
06IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@1iU:T09df50:D0c^Oo00H0
9df507VEZ`3OgN00IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0
IVIn0=[Gf@3Og=P0NIBY02EGQJ<003ad00L05den06J6X@3Pg]X0g=_M06IV
OP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0gmgP0=[Gf@3H
e=@0D`3GdmA>0=?>c0<0em?D00L0f=CD0=WEe@3JemT0gmgP06IVOP2XZK/0
nocm0040IVIn00000`1VIWh0moOi09RHY`2]07MgTP40V9RW0@3gmoT106IV
OP0000<0IVIn0?Ogn@2l_Ld0[P2l_Ld10?Ogn@40IVIn00000`1VIWh0moOi
0>CSh`2^0>CSh`40moOi0@1VIWh0000306IVOP3`lO@0oooo06L0oooo00<0
i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT
^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0101/MY00JgF?06afT01/MY09
06]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W>T@0YSU4
0:LjA02W>T@90:HiA00309bT^@3/j^X0oooo00<0oooo0@3`lO@106IVOP00
01H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0o?cm0?cl
o03lnod0o?cl0?cko03lo?`0nocl0?clo03ko?d0o?_l0?clo@3knod0nocl
0P3lo?`0103lo?d0o?cl0?_ko@3lo?dW0?cko2H0nocl00<0nocm09bT^@1[
MHl04@25RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?
09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?clo03l
nod0nocm0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3f
moP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080
moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0V0?Og
nBH0m_Oi00<0moOi06]eS`25RK004@2LW[h01P25RK00JgF?0?Ogn@3gmoT0
JgF?08F9/140W9jn00P0QHV`06]eS`3fmoP0moOh0:HiA02Z?5D0`U9K0<ID
FPd0aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>40
0@1VIWh0000606IVOP3NgN40lO7d0?7am03`lO@0l?;d400000001P3alO@0
l?;e0?7am03al_@0l?;d0?7am4d0l?7e00<0l?7d06]eS`2b]M004@2WZ<80
1P2b]M00JgF?0?3am03`lO@0JgF?0;:ed140YjS200D0/[G@06]eS`3`lOD0
lO;d0:HiA0020<9BF`030<]DF@3=FEh0cEUN00/0cEUN00@0beAI0<9BF`32
DU/0YSU40P3`lO@00`3alO@0l?;d0=kMh@0106IVOP0000L0IVIn0=cKh03Z
jo00j^_`0>[/l03Yjnl000000080inOW0P3Ng]h20>OWi`030>NmQ03WinL0
inOW00<0inOW0P3_knl010000000j^_`0>[[l03Zjnl20>[[l0030>[[k`3Z
jo00j^_`02D0j^_`9P3Zk?000`3Zjnl0JgF?0;Jid@020:f^aPP0oooo00<0
[Jk60:b^aP2][/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`0406]eS`2f
^M40[Jk60:f^aP`0oooo0P2][/H00`2/[/H0][WA06]eS`020>[[l0050:Hi
A03=FEh0beAI0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK0<]DF@3=FEh0YSU4
0>[[k`3Zjo000P3Zjnl10=cKh040IVIn0000101VIWh0fMWO0>?UjP3Si>X2
0>?Uj`050000002<S8`0g]kN0>OWi`3Ng]h00P3WinL00`36H`00inOW0>OW
i`020>OWi`070>o_i`3_knl0kno_0000003Si>X0hnC[0>?UjP020>?TjP03
0>?Tj`3SiN/0hnG[02D0hnG[9P3Si>X00`3SiNX0JgF?0;bne0020;:bbP03
0?ooo`1^KHl0KVf?00@0KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0
JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH02@0U9CH3
0;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?oo
o`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ
0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0g=kV00D00000
0>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW0>ONaP3_S100
0`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H0CP3Lg^D01@1[
MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh0
1P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh0
1`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V
>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`0505<U803DGF40
dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn
0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0ikF40=IJ003F
Q000olh00<iS00020=i[00050>neS03_knl0kno_0>o_k`0000000P3Ef>40
103Een00e]SP0=KHh@3Fen4W0=KGh2H0e]SP00<0eMSQ06]eS`33aMT00P2l
_M400`3oool09BDf02DU=P0502DU=PL0_;gA00H0`lGI06]eS`3Ef>40eMSQ
06]eS`33aMT20;bmd@030?ooo`0U9CH0_;gA00L0_;gA00<0oooo02DU=P2l
_M400P2l_M401@33aMT0JgF?0=KGh03Een40YSU40080eEeP00<0f61Q0=UQ
HP167QX00`3oool30=UQHP<0oooo00<0AQhJ0=UQHP3HH6400P3EGF001P2V
>D@0e]SP0=GHh@3Een00eMSQ0=GFg@40IVIn00001`1VIWh0d]CM0<oBg03@
d]`0d=;M0=3Bg00000000`3WinL0303Wg/h0aTX00?O>003_[@00kkD00<i[
0036FP00aV/00=j<BP3WY@00knO>000000<0d=;L00<0cm;L0=3Bg03?d]`0
9`3@d]`V0<oBg@030=3Bg01[MHl0b<WK0140`lCF00H0b<WK06]eS`3@d]`0
d=;L06]eS`38bM/20<?4eP030?ooo`0U9CH0`lCF00L0`lCF00<0oooo02DU
=P33a=H00P33a=H01`38bM/0JgF?0<oBg03?d]`0YSU40=MOG`3IHF800`3L
IFD01@167QX0oooo0?ooo`3oool0g6EU00<0oooo00P0AQhJ0=aUI@3LIFD0
g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?d]`10=;Dg@40IVIn0000701V
IWh0d=;K0<_=f03:cMT0blkH0<[=f0000000ilJ]0>O6S03gcQP0kkd00?O6
003_[@00ijd00>NU003FS000cV/00>O6003oeP00knoW0>o_k`000000blgH
0<_=f@3:cMT0blkH0<[=f03;cMPW0<_=fBH0blkI00<0blgH06]eS`3;c=h0
2@38b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38b]T0blcN06]eS`80
blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38b]T0
b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:HiA03G
Gel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?ooo`030?ooo`0:04HN
6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI0@3@
d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P000000a/K60>ONeP3>
N`00ijd00>ne0080ijD000<0eY@00<ic003FU0000P3gaP020?Ogm`040000
0035b=@0aLOD0<G7e0<0aLOE9`34amDV0<C8e0030<C7e01[MHl0d=7P0140
bl_L00H0d=7P06]eS`34am@0a<OD06]eS`3@dN020<_;g0030?ooo`0U9CH0
bl_L00L0bl_L00<0oooo02DU=P3;bm`00P3;bm`01`3@dN00JgF?0<G7e034
am@0YSU40=]TI03OIF@01@3PJVP01@167QX0oooo0?ooo`3oool0AQhJ00D0
h6YX00@0gfET0=]TI02V>D@0a<SE0P34b=@10<G7e@40cloJ0@1VIWh00004
06IVOP3<c]X0`/CB0<74d@80`LCB00H000000>OWi`3WinL0inOW0=J4003_
]@020>NU00080=J4003>J`00ijd00?Ne003g_@00kno_0?Ogm`0000030<74
dP030<;4d@31a=80`LCB02L0`LCA9P31a=800`32a=80JgF?0=?ChP0A0<o@
g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?d=d00`3oool09BDf0<o@
g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M00L0dm?R06]eS`32a=80`LCA
0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/J@080>5YI@3KI6@0YSU40<74
dP32a=40`LCA0<74dP3<c]X106IVOP0000@0IVIn0<[<f02n`<l0_L3?0P2n
`<h01@000000W9bL0>OWi`3Wg]H0eX`00080gY@000@0eW/00<IS002m@P00
kjD00P3g[@00203g]@00oli:0000002n`<h0_/3?0;k0cP2n`<l0_L3>:02n
`<hV0;g0cP030;k0cP1[MHl0e]KT0140dm?P00H0e]KT06]eS`2n`<h0_/3>
06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo00P0oooo00/09BDf0=?Ch03C
dn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo
00@0AQhJ0?ooo`3oool0oooo103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0
c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`0
00000080kno_01<0eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic003_
W000mnoW0?Ogm`3oool000000;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;02L0
^Kc<9P2j_<`00`2j_</0JgF?0=SHi@0A0=?Ch@060=SHi@1[MHl0^[c;0;Zl
b`1[MHl0f=SU0P3Cdn400`3oool0KVf?06i]S`0806i]S`0>02DU=P3Cdn40
dm?Q0=?Ch@3Hf>D0JgF?0;Zlb`2j_<`0YSU40>1YJ03QKF`0i75]0>AaK`3T
L6h30?ooo`0304HN6P3TL6h0AQhJ00<0oooo0P3TL6h02@3TLFd0hFe/0>1Y
J02V>D@0^[c<0;Zkc02i_</0][S80<W:f00106IVOP0000T0IVIn0<O9e`2d
]/L0][S80;Jhb@2f^LT0000008B4Q03Wimh00P3_knl01`36J`00mlH00>ne
003_W000gX`00<i[003WW0000`3gmoL01@000000][W90;Nhb@2f^LT0]kW9
0080][S99`2g^<TV0;Jhb@050;Nhb@1[MHl0e]KT0=SHi@3Hf>H00`3Hf>D5
0=SHiP<0f=SU0P3Hf>H20=SHi@090=KFi01[MHl0]kS90;Nhb@1[MHl0e]KT
0=SHi@3Hf>H0oooo00X0KVf?00d09BDf0=SHiP3Hf>D0f=SU0=KFi01[MHl0
]kS90;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo00D0AQhJ0>AdK`3T
M6l0i7A_04HN6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^K@2V>D@0][W90;Jh
b@2f^LT0];K70<O9e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`030000
003_knl0kno_0080kno_00/0ijd00?O6203WY@00ii@00>N<003_imH0gY@i
0>oF]@3omoL0oooo0000001D0;Bfa`0506]eS`3EeN<0g=_W0=cKi`3MfnL0
3P3LfnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80g=_W00<0gM_W02DU
=P0U9CH02@0U9CH30=cKi`090=GEh`1[MHl0];K70;Bfa`2V>D@0ig=_0>Me
LP3ZMW<0jWQf0080oooo00<0AQhJ0>UnN03YOWP00`3YOWP020167QX0oooo
0?ooo`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d]/L10<K8e`40IVIn00000`1V
IWh0a/SG0;Bfa`030;Bfa`060000002<S8`0kno_0>o_k`3WcW/0kno_0P3g
moL0203WU000mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool00000E02d]/L00`1[
MHl0eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0];K70;Bfa`1[MHl0eMCS4@3P
gnX02@3Ee><0JgF?0;Bfa`2d]/L0YSU40>YiL`3YO7P0kh5j0?:9P@0204HN
6P070>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:0>^HR`0204HN6P050?:9P@3_
PGX0jGah0>YiL`2V>D@0102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;6c
b0030;6cb0060000003_knl0kno_0>o_k`3gmnl0kno_0P3gmoL00`3gilH0
moOg0?ooo`030?Ogm`030?ooo`000000/K?805<0/K?800<0JgF?0>g[l`3Y
j?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[la40jNSa01T0kN_c
06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0lZ^F0?6bV`3]]9/0
k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3gWHh0mHb40?24O03a
P7D0YSU400@0/K?80@36b=L106IVOP0000<0IVIn0<K8e`2h]ll00`2_[/L0
1@000000[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3omoL20?ooo`030000002_
[/L0[jk70580[jk700<0JgF?0=;Ah`3blOL0403blOL01P3BdN<0JgF?0:n^
a`2_[/L0JgF?0=;Aha40l_7g00H0d]7S06]eS`2_[/L0[jk70:HiA03dRWd2
0?F@Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^a`020:n^a`40^;O?0@36b=L1
06IVOP0000<0IVIn0<31d@37am@0I`2/Zl@01024S:80JgF?0<c;g@3kno`=
0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400@0Q8bR06]eS`3<bmd0no_l
3@3oool0103kno`0c<_M06]eS`24S:820:b[a007096HZP2V>D@0oin=0?jo
Y03jg;L0n^^g0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf0?[Y]P80nNVf00H0
n^^g0?[L]`3n_j@0oin=0:HiA02AV:X30:b[a040alOD0@30`M4106IVOP00
00@0IVIn0<31d@3Bd]l0]KC9I`2TXkh00`24S:80JgF?06]eS`0?06]eS`03
08B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80
Y:>n0:BS_P020:BS_P0308B<XP2V>D@0YSU400l0YSU400L0Q8bR0:BS_P2T
Xkh0Y:>n0;Fdb@3Bd]l0`<7A0040IVIn00001P1VIWh0Z:No0>KVk@3Bd^00
_;c?0;6`a:L0Z:No00D0/K340;blc`3Bd^00i^K]0:RW_`0106IVOP0000L0
F5MX08N7V`3Gf>80o?cl0>CSj03@d>00b/[J0:D0_;c?00H0b/[J0=3@h03T
hnP0o?cl0=OHhP27Qi/10?ooo`0000P0F5MX06IVOP2EU:/0emSR0?clo03b
lO<0k>_^0>7Rjj<0emSR00L0hN;[0>c[kP3blO<0o?cl0=OHhP2EU:/0IVIn
0040oooo000205QGJ00306IVOP2EU:/0dM7N0080o?clY@3oool20?clo003
0=7AgP2EU:/0IVIn0080oooo000305QGJ080IVIn00<0R8NM09FDZ`2XYkl0
Y02XYkl0102EU:/0R8NM06IVOP1VIWh30?ooo`001@1HEfRY06IVOP<0oooo
0@0000010?ooo`00\
\>"], "Text",
  Evaluatable->False,
  ImageSize->{179, 80},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Last Slide"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                CounterBox["SlideShowNavigationBar", "LastSlide"]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  Magnification->1],

Cell[CellGroupData[{

Cell["Widget summary", "Section"],

Cell[TextData[{
  StyleBox["Widget[\"", "Program",
    FontWeight->"Bold"],
  StyleBox["widgetname", "Program",
    FontSlant->"Italic"],
  StyleBox["\"", "Program",
    FontWeight->"Bold"],
  StyleBox[",", "Program"],
  StyleBox["{", "Program",
    FontWeight->"Bold"],
  StyleBox["contents", "Program",
    FontSlant->"Italic"],
  StyleBox["}", "Program",
    FontWeight->"Bold"],
  StyleBox[", ", "Program"],
  StyleBox["opts", "Program",
    FontSlant->"Italic"],
  StyleBox["]", "Program",
    FontWeight->"Bold"],
  " is the basic building block, used to construct user interfaces. "
}], "Text"],

Cell["\<\
The contents of the widget can include property settings, for example, the \
text to show in a label widget. \
\>", "Text"],

Cell["\<\
The contents can also include other widgets and code to react to various \
events.\
\>", "Text"]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Last Slide"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                CounterBox["SlideShowNavigationBar", "LastSlide"]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  Magnification->1],

Cell[CellGroupData[{

Cell["Widget summary - continued", "Section"],

Cell[TextData[{
  "The basics of building a user interface with the ",
  StyleBox["GUIKit`", "MR"],
  " package can be summarized as follows:"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Choosing widgets",
  FontSlant->"Italic"]], "Subsubsection"],

Cell["\<\
You can choose the widgets that you need for your application from the large \
collection of possible widgets that is provided. It is also possible to add \
new types of widgets.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Setting the state of the widgets",
  FontSlant->"Italic"]], "Subsubsection"],

Cell["\<\
The initial state of the properties of your widgets must be set. For example, \
setting properties such as text and images that are initially displayed. \
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Designing the layout of widgets",
  FontSlant->"Italic"]], "Subsubsection"],

Cell["\<\
The layout of your interface must be designed. The automatic layout features \
make this particularly easy.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Adding code to run the widgets",
  FontSlant->"Italic"]], "Subsubsection"],

Cell["\<\
You also need to add the code that reacts to different types of events that \
will drive the interface as users interact with it.\
\>", "Text"]
}, Open  ]]
}, Open  ]],

Cell[TextData[Cell[BoxData[GridBox[{
        {
          ButtonBox[
            StyleBox["\[FirstPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageFirst"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"First Slide"], 
          ButtonBox[
            StyleBox["\[LeftPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPagePrevious"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Previous Slide"], 
          ButtonBox[
            StyleBox["\[RightPointer]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageNext"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Next Slide"], 
          ButtonBox[
            StyleBox["\[LastPage]",
              "SR"],
            ButtonFunction:>FrontEndExecute[ {
                FrontEndToken[ 
                  FrontEnd`SelectedNotebook[ ], "ScrollPageLast"]}],
            ButtonStyle->"SlideHyperlink",
            ButtonNote->"Last Slide"], " ", 
          ButtonBox[
            StyleBox[
              RowBox[{
                CounterBox["SlideShowNavigationBar"], \(\(\ \)\(of\)\(\ \)\), 
                
                CounterBox["SlideShowNavigationBar", "LastSlide"]}],
              "SR"],
            ButtonFrame->"None"]}
        }]]]], "SlideShowNavigationBar",
  Magnification->1],

Cell[CellGroupData[{

Cell["Where to go from here", "Section",
  CellTags->"LastSlide"],

Cell["\<\
After working through this slide show you may want to look more at the \
documentation. In particular the following might be useful.\
\>", "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["The Examples Section",
  FontSlant->"Italic"]], "Subsubsection"],

Cell[TextData[{
  "The ",
  ButtonBox["Examples",
    ButtonData:>{"GUIKit: Examples, Introductory", None},
    ButtonStyle->"AddOnsLink"],
  " section shows many different interfaces from simple worked examples \
useful for learning the functionality, to large complete applications that \
are useful in their own right."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["The Widget Gallery",
  FontSlant->"Italic"]], "Subsubsection"],

Cell[TextData[{
  "The ",
  ButtonBox["Widget Gallery",
    ButtonData:>{"GUIKit: Introduction, Widget Gallery", None},
    ButtonStyle->"AddOnsLink"],
  " shows a visual tour of each of the widgets, with a visual list of useful \
properties and events."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["The GUIKit Site",
  FontSlant->"Italic"]], "Subsubsection"],

Cell[TextData[{
  ButtonBox["http://www.wolfram.com/solutions/mathlink/guikit/",
    ButtonData:>{
      URL[ "http://www.wolfram.com/solutions/mathlink/guikit/"], None},
    ButtonStyle->"Hyperlink"],
  " has further information and updates on the ",
  StyleBox["GUIKit`", "MR"],
  " package."
}], "Text"],

Cell[" ", "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1680}, {0, 967}},
ClosingAutoSave->False,
ScreenStyleEnvironment->"SlideShow",
PrintingStyleEnvironment->"Printout",
WindowToolbars->{},
WindowSize->{909, 521},
WindowMargins->{{39, Automatic}, {Automatic, 42}},
WindowTitle->"GUIKit Construction",
ScrollingOptions->{"VerticalScrollRange"->Fit},
PrintingCopies->1,
PrintingPageRange->{1, 6},
Magnification->1,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions for On-line Help", "Subtitle"],
  
  Cell["\<\
These styles are carefully tuned for all aspects of the online help. It's \
recommended that they remain unchanged.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    OpenSpecialOptions->{"ListAllFileTypes"->False},
    MultilaunchWarning->True,
    HelpBrowserSettings->{"ShowCategories"->True},
    FileNameDialogSettings->{"StringFormat"->True},
    NotebookConvertSettings->{"InputToInputForm"->True,
    "OutputToOutputForm"->True},
    PageWidth->WindowWidth,
    ShowAutoStyles->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Brackets"],
    PageWidth->WindowWidth,
    ShowAutoStyles->False,
    ScriptMinSize->9],
  
  Cell[StyleData[All, "SlideShow"],
    PageWidth->WindowWidth,
    ScrollingOptions->{"PagewiseDisplay"->True},
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    ShowCellBracket->False,
    ShowAutoStyles->False,
    ScriptMinSize->5,
    PrivateFontOptions->{"FontType"->"Outline"}],
  
  Cell[StyleData[All, "EnhancedPrintout"],
    OpenSpecialOptions->{"ListAllFileTypes"->False},
    MultilaunchWarning->True,
    HelpBrowserSettings->{"ShowCategories"->True},
    FileNameDialogSettings->{"StringFormat"->True},
    NotebookConvertSettings->{"InputToInputForm"->True,
    "OutputToOutputForm"->True},
    PageWidth->PaperWidth,
    ShowCellBracket->False,
    ScriptMinSize->5,
    FontFamily->"Palatino",
    PrivateFontOptions->{"FontType"->"Outline"}],
  
  Cell[StyleData[All, "EnhancedPrintoutNonGray"],
    OpenSpecialOptions->{"ListAllFileTypes"->False},
    MultilaunchWarning->True,
    HelpBrowserSettings->{"ShowCategories"->True},
    FileNameDialogSettings->{"StringFormat"->True},
    NotebookConvertSettings->{"InputToInputForm"->True,
    "OutputToOutputForm"->True},
    PageWidth->PaperWidth,
    ShowCellBracket->False,
    ScriptMinSize->5,
    FontFamily->"Palatino",
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Notebook Options", "Section"],
  
  Cell["\<\
  The options defined for the style below will be used at the Notebook level. \
 \
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Notebook"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"]}, {Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    PageFooters->{{None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2002 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2002 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}},
    PageHeaderLines->{True, True},
    PageFooterLines->{True, True},
    PrintingOptions->{"FacingPages"->True},
    CellLabelAutoDelete->False,
    CellFrameLabelMargins->6,
    StyleMenuListing->None],
  
  Cell[StyleData["Notebook", "Printout"],
    PageHeaders->{{Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"]}, {Cell[ 
            TextData[ {"Printed from the ", 
              StyleBox[ "Mathematica", FontSlant -> "Italic"], 
              " Help Browser"}], "PageHeader"], None, Cell[ 
            TextData[ {
              CounterBox[ "Page"]}], "PageNumber"]}},
    PageFooters->{{None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2002 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}, {None, Cell[ 
            
            TextData[ {
              "\[Copyright]1988-2002 Wolfram Research, Inc. All rights \
reserved."}], "PageFooter"], None}},
    PageHeaderLines->{True, True},
    PageFooterLines->{True, True},
    PrintingOptions->{"FacingPages"->True}],
  
  Cell[StyleData["Notebook", "EnhancedPrintout"],
    PageFooters->{{None, None, None}, {None, None, None}},
    PageHeaderLines->{True, True},
    PrintingOptions->{"PrintingMargins"->{{62, 62}, {62, 72}},
    "PageSize"->{602, 672},
    "PrintRegistrationMarks"->True,
    "FirstPageHeader"->False,
    "FacingPages"->True}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Headings", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Chapter"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{12, Inherited}, {10, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Plain"],
  
  Cell[StyleData["Chapter", "Printout"],
    CellMargins->{{2, 10}, {6, 30}},
    FontSize->14],
  
  Cell[StyleData["Chapter", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {6, 30}},
    FontFamily->"Futura",
    FontSize->14],
  
  Cell[StyleData["Chapter", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {6, 30}},
    FontFamily->"Futura",
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Section"],
    CellMargins->{{10, 4}, {12, 18}},
    CellGroupingRules->{"SectionGrouping", 30},
    ConversionRules:>{"HTML" -> {
      "<FONT SIZE=\"+2\" FACE=\"Helvetica, Arial\"><P><B>", 
      "</B></P></FONT>\n"}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    CounterIncrements->"Section",
    FontFamily->"Helvetica",
    FontSize->20,
    FontWeight->"Bold"],
  
  Cell[StyleData["Section", "SlideShow"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{0, 0}, {5, 0}},
    PageBreakBelow->False,
    CellFrameMargins->{{70, 36}, {3, 7}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Plain",
    FontColor->GrayLevel[1],
    Background->RGBColor[0.819608, 0.427451, 0.0235294]],
  
  Cell[StyleData["Section", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->18],
  
  Cell[StyleData["Section", "EnhancedPrintout"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, Inherited}, {8, 30}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Futura",
    FontSize->16],
  
  Cell[StyleData["Section", "EnhancedPrintoutNonGray"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{2, Inherited}, {8, 30}},
    CellGroupingRules->{"SectionGrouping", 30},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CounterIncrements->"Section",
    CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
    FontFamily->"Futura",
    FontSize->16]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{24, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 40},
    ConversionRules:>{"HTML" -> {
      "<LI TYPE=\"SQUARE\"><FONT SIZE=\"+1\" FACE=\"Helvetica, \
Arial\"><P><B>", "</B></P></FONT>\n"}},
    CellFrameLabelMargins->6,
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsection", "SlideShow"],
    CellDingbat->None,
    CellMargins->{{70, 0}, {4, 12}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "Printout"],
    CellMargins->{{9, 0}, {7, 24}},
    FontSize->12],
  
  Cell[StyleData["Subsection", "EnhancedPrintout"],
    CellMargins->{{9, 0}, {7, 20}},
    FontFamily->"Futura",
    FontSize->12],
  
  Cell[StyleData["Subsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {7, 20}},
    FontFamily->"Futura",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsection"],
    CellMargins->{{10, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    ConversionRules:>{"HTML" -> {"<FONT FACE=\"Helvetica, Arial\"><P><B>", 
      "</B></P></FONT>\n"}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsection", "Printout"],
    CellMargins->{{2, 0}, {7, 18}},
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {7, 18}},
    FontFamily->"Futura",
    FontSize->10],
  
  Cell[StyleData["Subsubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {7, 18}},
    FontFamily->"Futura",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionColor"],
    CellMargins->{{10, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    CellGroupingRules->{"SectionGrouping", 50},
    ConversionRules:>{"HTML" -> {
      "<FONT FACE=\"Helvetica, Arial\" COLOR=\"660099\"><P><B>", 
      "</B></P></FONT>\n"}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", 
                  BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.297993, 0, 0.454994]],
  
  Cell[StyleData["SubsubsectionColor", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{24, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->8},
    CellGroupingRules->{"SectionGrouping", 40},
    ConversionRules:>{"HTML" -> {
      "<LI TYPE=\"SQUARE\"><FONT FACE=\"Helvetica, Arial\"><P><B>", 
      "</B></P></FONT>\n"}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    CounterIncrements->"Section",
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubsectionIcon", "Printout"],
    CellDingbat->"\[FilledSquare]",
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{16, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{24, 4}, {0, 8}},
    CellElementSpacings->{"ClosedGroupTopMargin"->4},
    CellGroupingRules->{"SectionGrouping", 50},
    ConversionRules:>{"HTML" -> {
      "<LI TYPE=\"SQUARE\"><FONT FACE=\"Helvetica, Arial\"><P><B>", 
      "</B></P></FONT>\n"}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubsubsectionIcon", "Printout"],
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->10]
  }, Closed]]
  }, Open  ]],
  
  Cell[CellGroupData[{
  
  Cell["Text", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Text"],
    CellMargins->{{10, 4}, {0, 8}},
    ConversionRules:>{"HTML" -> {"<P>", "</P>"}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    Hyphenation->True,
    ParagraphSpacing->{0, 8},
    FontSize->12],
  
  Cell[StyleData["Text", "SlideShow"],
    CellMargins->{{70, 48}, {2, 7}},
    Hyphenation->False,
    FontSize->12],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->10],
  
  Cell[StyleData["Text", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Text", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CompactText"],
    CellMargins->{{10, 4}, {0, 8}},
    ConversionRules:>{"HTML" -> {"<FONT SIZE=\"-1\">", "</FONT>\n"}},
    Hyphenation->True,
    ParagraphSpacing->{0, 0},
    StyleMenuListing->None,
    FontSize->10],
  
  Cell[StyleData["CompactText", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->8],
  
  Cell[StyleData["CompactText", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->8],
  
  Cell[StyleData["CompactText", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Compact12Text"],
    CellMargins->{{10, 4}, {0, 8}},
    ConversionRules:>{"HTML" -> {"<P>", "</P>"}},
    Hyphenation->True,
    ParagraphSpacing->{0, 0},
    StyleMenuListing->None],
  
  Cell[StyleData["Compact12Text", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["Compact12Text", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["Compact12Text", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextSans"],
    CellMargins->{{10, 4}, {0, 8}},
    ConversionRules:>{"HTML" -> {
      "<FONT SIZE=\"-1\" FACE=\"Helvetica, Arial\">", "</FONT>\n"}},
    CellHorizontalScrolling->True,
    Hyphenation->True,
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["TextSans", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->8],
  
  Cell[StyleData["TextSans", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->8],
  
  Cell[StyleData["TextSans", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedText"],
    CellMargins->{{20, 4}, {0, 5}},
    ConversionRules:>{"HTML" -> {"<BLOCKQUOTE>", "</BLOCKQUOTE>"}},
    Hyphenation->True,
    LineSpacing->{1, 3},
    ParagraphIndent->-21,
    CounterIncrements->"ItemizedText",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedText", "Printout"],
    ParagraphIndent->-19,
    FontSize->11],
  
  Cell[StyleData["ItemizedText", "EnhancedPrintout"],
    ParagraphIndent->-18,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedText", "EnhancedPrintoutNonGray"],
    ParagraphIndent->-18,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextNote"],
    CellMargins->{{41, 4}, {0, 4}},
    ConversionRules:>{"HTML" -> {"<BLOCKQUOTE>", "</BLOCKQUOTE>"}},
    Hyphenation->True,
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextNote", "Printout"],
    CellMargins->{{38, 4}, {0, 4}},
    FontSize->11],
  
  Cell[StyleData["ItemizedTextNote", "EnhancedPrintout"],
    CellMargins->{{38, 4}, {0, 4}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedTextNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{38, 4}, {0, 4}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndentedText"],
    CellMargins->{{20, 4}, {0, 6}},
    ConversionRules:>{"HTML" -> {"<BLOCKQUOTE>", "</BLOCKQUOTE>"}},
    LineSpacing->{1, 3},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["IndentedText", "SlideShow"],
    CellMargins->{{80, 24}, {5, 5}},
    Hyphenation->False,
    FontSize->13],
  
  Cell[StyleData["IndentedText", "Printout"],
    FontSize->11],
  
  Cell[StyleData["IndentedText", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["IndentedText", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MathCaption"],
    CellDingbat->"\[Placeholder]",
    CellMargins->{{19, 62}, {0, 14}},
    ConversionRules:>{"HTML" -> {
      "<LI TYPE=\"SQUARE\"><P><FONT COLOR=\"000066\">", "</FONT></P></LI>"}},
    PageBreakBelow->False,
    CellFrameLabelMargins->4,
    Hyphenation->True,
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 8},
    FontColor->RGBColor[0, 0, 0.4]],
  
  Cell[StyleData["MathCaption", "SlideShow"],
    ShowCellBracket->False,
    CellMargins->{{36, 36}, {6, 6}}],
  
  Cell[StyleData["MathCaption", "Printout"],
    CellMargins->{{9, 0}, {0, 14}},
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["MathCaption", "EnhancedPrintout"],
    CellMargins->{{9, 0}, {0, 14}},
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["MathCaption", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {0, 14}},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SmallText"],
    CellMargins->{{10, 4}, {0, 8}},
    ConversionRules:>{"HTML" -> {"<FONT SIZE=\"1\"><P>", "</P></FONT>"}},
    Hyphenation->True,
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"SmallText",
    FontSize->9],
  
  Cell[StyleData["SmallText", "Printout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->1,
    FontSize->7],
  
  Cell[StyleData["SmallText", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->7],
  
  Cell[StyleData["SmallText", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {5, 5}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Input/Output", "Section"],
  
  Cell["\<\
The cells in this section define styles used for input and output to the \
kernel.  Be careful when modifying, renaming, or removing these styles, \
because the front end associates special meanings with these style names.    \
\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Input"],
    ShowCellBracket->True,
    CellMargins->{{46, 4}, {3, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Mathematica",
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    FontWeight->"Bold"],
  
  Cell[StyleData["Input", "SlideShow"],
    CellFrame->{{2, 2}, {0, 2}},
    ShowCellBracket->True,
    CellMargins->{{70, 50}, {0, 6}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellFrameMargins->{{5, 5}, {2, 5}},
    CellFrameColor->RGBColor[0.869993, 0.449989, 0.219989],
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["Input", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9],
  
  Cell[StyleData["Input", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9],
  
  Cell[StyleData["Input", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {4, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Output"],
    ShowCellBracket->True,
    CellMargins->{{47, 4}, {4, 2}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->None,
    FormatType->StandardForm],
  
  Cell[StyleData["Output", "SlideShow"],
    CellFrame->{{2, 2}, {2, 0}},
    ShowCellBracket->True,
    CellMargins->{{70, 50}, {6, 0}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellFrameMargins->{{8, 8}, {8, 4}},
    CellFrameColor->RGBColor[0.869993, 0.449989, 0.219989],
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["Output", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9],
  
  Cell[StyleData["Output", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9],
  
  Cell[StyleData["Output", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 4}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InputOnly"],
    ShowCellBracket->True,
    CellMargins->{{46, 4}, {8, 8}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Mathematica",
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["InputOnly", "SlideShow"],
    CellFrame->2,
    ShowCellBracket->True,
    CellMargins->{{70, 57}, {4, 4}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellFrameColor->RGBColor[0.869993, 0.449989, 0.219989],
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["InputOnly", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9],
  
  Cell[StyleData["InputOnly", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9],
  
  Cell[StyleData["InputOnly", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Message"],
    ShowCellBracket->True,
    CellMargins->{{47, 4}, {4, 2}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->None,
    FormatType->InputForm,
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Message", "SlideShow"],
    CellMargins->{{70, 30}, {4, 4}},
    FontSize->10,
    FontColor->RGBColor[0.699992, 0.4, 0]],
  
  Cell[StyleData["Message", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Message", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier",
    FontSize->9,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Message", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier",
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Print"],
    ShowCellBracket->True,
    CellMargins->{{47, 4}, {4, 2}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->None,
    FormatType->InputForm,
    StyleMenuListing->None],
  
  Cell[StyleData["Print", "SlideShow"],
    CellMargins->{{100, 50}, {6, 6}}],
  
  Cell[StyleData["Print", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{57, Inherited}, {Inherited, Inherited}},
    FontSize->9],
  
  Cell[StyleData["Print", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{57, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier",
    FontSize->9],
  
  Cell[StyleData["Print", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{57, Inherited}, {Inherited, Inherited}},
    FontFamily->"Courier",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Graphics"],
    ShowCellBracket->True,
    CellMargins->{{47, 4}, {4, 2}},
    CellGroupingRules->"GraphicsGrouping",
    PageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    DefaultFormatType->DefaultFormatTypeForOutput,
    LanguageCategory->None,
    FormatType->InputForm,
    StyleMenuListing->None,
    FontWeight->"Plain"],
  
  Cell[StyleData["Graphics", "SlideShow"],
    CellFrame->{{2, 2}, {2, 0}},
    ShowCellBracket->True,
    CellMargins->{{70, 50}, {6, 0}},
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellFrameMargins->{{8, 8}, {4, 4}},
    CellFrameColor->RGBColor[0.869993, 0.449989, 0.219989],
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["Graphics", "Printout"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    ImageSize->{250, 250},
    FontSize->9],
  
  Cell[StyleData["Graphics", "EnhancedPrintout"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    ImageSize->{250, 250},
    FontFamily->"Courier",
    FontSize->9],
  
  Cell[StyleData["Graphics", "EnhancedPrintoutNonGray"],
    ShowCellBracket->False,
    CellMargins->{{39, Inherited}, {Inherited, Inherited}},
    ImageSize->{250, 250},
    FontFamily->"Courier",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CellLabel"],
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain",
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["CellLabel", "SlideShow"],
    FontColor->RGBColor[0.699992, 0.4, 0]],
  
  Cell[StyleData["CellLabel", "Printout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["CellLabel", "EnhancedPrintout"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["CellLabel", "EnhancedPrintoutNonGray"],
    FontFamily->"Courier",
    FontSize->8,
    FontSlant->"Italic",
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Name"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["Name", "Printout"],
    FontSize->7,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Name", "EnhancedPrintout"],
    FontSize->7,
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["Name", "EnhancedPrintoutNonGray"],
    FontSize->7,
    FontColor->GrayLevel[0]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Hyperlinks", "Section"],
  
  Cell["\<\
The cells below define styles useful for making hypertext ButtonBoxes.  The \
\"Hyperlink\" style is for links within the same Notebook, or between \
Notebooks. The others point to the various sections of the help browser. \
These styles will modify individual words or letters in a cell exclusive of \
the cell tag.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Hyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonNote->ButtonData}],
  
  Cell[StyleData["Hyperlink", "Printout"],
    FontSize->11,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["Hyperlink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["Hyperlink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLink", "Printout"],
    FontSize->11,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MainBookLinkMR"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["MainBookLinkMR", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLinkMR", "EnhancedPrintout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["MainBookLinkMR", "EnhancedPrintoutNonGray"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLink", "EnhancedPrintout"],
    FontFamily->"WRICourier",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLink", "EnhancedPrintoutNonGray"],
    FontFamily->"WRICourier",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["AddOnsLinkText"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Times",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["AddOnsLinkText", "Printout"],
    FontSize->11,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLinkText", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["AddOnsLinkText", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["RefGuideLink", "EnhancedPrintout"],
    FontFamily->"WRICourier",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["RefGuideLink", "EnhancedPrintoutNonGray"],
    FontFamily->"WRICourier",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RefGuideLinkText"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["RefGuideLinkText", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["RefGuideLinkText", "EnhancedPrintout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["RefGuideLinkText", "EnhancedPrintoutNonGray"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GettingStartedLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["GettingStartedLink", "Printout"],
    FontSize->11,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["GettingStartedLink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["GettingStartedLink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLink", "Printout"],
    FontSize->11,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLink", "EnhancedPrintout"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLink", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino",
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["OtherInformationLinkMR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0, 0, 1],
    FontVariations->{"Underline"->True},
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
    Active->True,
    ButtonFrame->"None"}],
  
  Cell[StyleData["OtherInformationLinkMR", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLinkMR", "EnhancedPrintout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}],
  
  Cell[StyleData["OtherInformationLinkMR", "EnhancedPrintoutNonGray"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Palette Styles", "Section"],
  
  Cell["\<\
The cells below define styles that define standard ButtonFunctions, for use \
in palette buttons.\
\>", "Text"],
  
  Cell[StyleData["Paste"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, After]}]&)}],
  
  Cell[StyleData["Evaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["EvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionMove[ 
          FrontEnd`InputNotebook[ ], All, Cell, 1], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluate"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluate[ 
          FrontEnd`InputNotebook[ ], All]}]&)}],
  
  Cell[StyleData["CopyEvaluateCell"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`SelectionCreateCell[ 
          FrontEnd`InputNotebook[ ], All], 
        FrontEnd`NotebookApply[ 
          FrontEnd`InputNotebook[ ], #, All], 
        FrontEnd`SelectionEvaluateCreateCell[ 
          FrontEnd`InputNotebook[ ], All]}]&)}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Inline Formatting", "Section"],
  
  Cell["\<\
These styles are for modifying individual words or letters in a cell \
exclusive of the cell tag.\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["JT"],
    StyleMenuListing->None,
    FontFamily->"JFontText"],
  
  Cell[StyleData["JT", "Printout"]],
  
  Cell[StyleData["JT", "EnhancedPrintout"]],
  
  Cell[StyleData["JT", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["JS"],
    StyleMenuListing->None,
    FontFamily->"JFontSans"],
  
  Cell[StyleData["JS", "Printout"]],
  
  Cell[StyleData["JS", "EnhancedPrintout"]],
  
  Cell[StyleData["JS", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["JSB"],
    StyleMenuListing->None,
    FontFamily->"JFontSansBold"],
  
  Cell[StyleData["JSB", "Printout"]],
  
  Cell[StyleData["JSB", "EnhancedPrintout"]],
  
  Cell[StyleData["JSB", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["RM"],
    StyleMenuListing->None,
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["RM", "Printout"]],
  
  Cell[StyleData["RM", "EnhancedPrintout"]],
  
  Cell[StyleData["RM", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BF"],
    ConversionRules:>{"HTML" -> {"<B>", "</B>"}},
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["BF", "Printout"]],
  
  Cell[StyleData["BF", "EnhancedPrintout"]],
  
  Cell[StyleData["BF", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IT"],
    ConversionRules:>{"HTML" -> {"<I>", "</I>"}},
    StyleMenuListing->None,
    FontSlant->"Italic"],
  
  Cell[StyleData["IT", "Printout"]],
  
  Cell[StyleData["IT", "EnhancedPrintout"]],
  
  Cell[StyleData["IT", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TR"],
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["TR", "Printout"]],
  
  Cell[StyleData["TR", "EnhancedPrintout"]],
  
  Cell[StyleData["TR", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TI"],
    ConversionRules:>{"HTML" -> {"<I>", "</I>"}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSlant->"Italic"],
  
  Cell[StyleData["TI", "Printout"]],
  
  Cell[StyleData["TI", "EnhancedPrintout"]],
  
  Cell[StyleData["TI", "EnhancedPrintoutNonGray"]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TB"],
    ConversionRules:>{"HTML" -> {"<B>", "</B>"}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["TB", "Printout"]],
  
  Cell[StyleData["TB", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TB", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TBI"],
    ConversionRules:>{"HTML" -> {"<B><I>", "</B></I>"}},
    StyleMenuListing->None,
    FontFamily->"Times",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["TBI", "Printout"]],
  
  Cell[StyleData["TBI", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["TBI", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MR"],
    ConversionRules:>{"HTML" -> {"<TT>", "</TT>"}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->" "},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["MR", "Printout"]],
  
  Cell[StyleData["MR", "EnhancedPrintout"],
    HyphenationOptions->{"HyphenationCharacter"->""},
    FontFamily->"WriCourier"],
  
  Cell[StyleData["MR", "EnhancedPrintoutNonGray"],
    HyphenationOptions->{"HyphenationCharacter"->""},
    FontFamily->"WriCourier"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MO"],
    ConversionRules:>{"HTML" -> {"<TT><I>", "</TT></I>"}},
    HyphenationOptions->{"HyphenationCharacter"->""},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["MO", "Printout"]],
  
  Cell[StyleData["MO", "EnhancedPrintout"],
    HyphenationOptions->{"HyphenationCharacter"->""},
    FontFamily->"WriCourier"],
  
  Cell[StyleData["MO", "EnhancedPrintoutNonGray"],
    HyphenationOptions->{"HyphenationCharacter"->""},
    FontFamily->"WriCourier"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MB"],
    ConversionRules:>{"HTML" -> {"<TT><B>", "</TT></B>"}},
    HyphenationOptions->{"HyphenationCharacter"->""},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["MB", "Printout"]],
  
  Cell[StyleData["MB", "EnhancedPrintout"],
    HyphenationOptions->{"HyphenationCharacter"->""},
    FontFamily->"WriCourier"],
  
  Cell[StyleData["MB", "EnhancedPrintoutNonGray"],
    HyphenationOptions->{"HyphenationCharacter"->""},
    FontFamily->"WriCourier"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MBO"],
    ConversionRules:>{"HTML" -> {"<TT><I><B>", "</TT></I></B>"}},
    HyphenationOptions->{"HyphenationCharacter"->""},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["MBO", "Printout"]],
  
  Cell[StyleData["MBO", "EnhancedPrintout"],
    HyphenationOptions->{"HyphenationCharacter"->""},
    FontFamily->"WriCourier"],
  
  Cell[StyleData["MBO", "EnhancedPrintoutNonGray"],
    HyphenationOptions->{"HyphenationCharacter"->""},
    FontFamily->"WriCourier"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SR"],
    ConversionRules:>{"HTML" -> {"<Font=Helvetica, Arial>", "</Font>"}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Plain"],
  
  Cell[StyleData["SR", "Printout"]],
  
  Cell[StyleData["SR", "EnhancedPrintout"],
    FontFamily->"Futura"],
  
  Cell[StyleData["SR", "EnhancedPrintoutNonGray"],
    FontFamily->"Futura"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO"],
    ConversionRules:>{"HTML" -> {"<I><Font=Futura>", "</I></Font>"}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO", "Printout"],
    ConversionRules:>{"HTML" -> {"<I><Font=Futura>", "</I></Font>"}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO", "EnhancedPrintout"],
    FontFamily->"Futura"],
  
  Cell[StyleData["SO", "EnhancedPrintoutNonGray"],
    FontFamily->"Futura"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SB"],
    ConversionRules:>{"HTML" -> {"<B><Font=Futura>", "</B></Font>"}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SB", "Printout"],
    ConversionRules:>{"HTML" -> {"<B><Font=Futura>", "</B></Font>"}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Plain"],
  
  Cell[StyleData["SB", "EnhancedPrintout"],
    FontFamily->"Futura"],
  
  Cell[StyleData["SB", "EnhancedPrintoutNonGray"],
    FontFamily->"Futura"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SBO"],
    ConversionRules:>{"HTML" -> {"<B><I><Font=Futura>", "</B></I></Font>"}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SBO", "Printout"],
    ConversionRules:>{"HTML" -> {"<B><I><Font=Futura>", "</B></I></Font>"}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["SBO", "EnhancedPrintout"],
    FontFamily->"Futura"],
  
  Cell[StyleData["SBO", "EnhancedPrintoutNonGray"],
    FontFamily->"Futura"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["M4"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Math4",
    CharacterEncoding->"Math4"],
  
  Cell[StyleData["M4", "Printout"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Math4",
    CharacterEncoding->"Math4"],
  
  Cell[StyleData["M4", "EnhancedPrintout"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Math4",
    CharacterEncoding->"Math4"],
  
  Cell[StyleData["M4", "EnhancedPrintoutNonGray"],
    ShowCellBracket->True,
    StyleMenuListing->None,
    FontFamily->"Math4",
    CharacterEncoding->"Math4"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SO10"],
    ConversionRules:>{"HTML" -> {"<Font=Helvetica, Arial><I>", 
      "</Font></I>"}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "Printout"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->8,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "EnhancedPrintout"],
    StyleMenuListing->None,
    FontFamily->"Futura",
    FontSize->8,
    FontWeight->"Plain",
    FontSlant->"Italic"],
  
  Cell[StyleData["SO10", "EnhancedPrintoutNonGray"],
    StyleMenuListing->None,
    FontFamily->"Futura",
    FontSize->8,
    FontWeight->"Plain",
    FontSlant->"Italic"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["C1"],
    StyleMenuListing->None,
    FontColor->RGBColor[0.4, 0, 1]],
  
  Cell[StyleData["C1", "Printout"],
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1", "EnhancedPrintout"],
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["C1MR"],
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontColor->RGBColor[0.4, 0, 1]],
  
  Cell[StyleData["C1MR", "Printout"],
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1MR", "EnhancedPrintout"],
    FontColor->GrayLevel[0]],
  
  Cell[StyleData["C1MR", "EnhancedPrintoutNonGray"],
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[StyleData["KeyStroke"],
    Magnification->1.2]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Emphasis Boxes and Pictures", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Box"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["Box", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["Box", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["Box", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DoubleBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->2,
    RowAlignments->Top}],
  
  Cell[StyleData["DoubleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["DoubleBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["DoubleBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["1ColumnBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["1ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["1ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["1ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.31, 0.67}}],
  
  Cell[StyleData["2ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.46}],
  
  Cell[StyleData["2ColumnEvenBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnEvenBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnEvenBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnSmallBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.35,
    ColumnAlignments->{Right, Left}}],
  
  Cell[StyleData["2ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnSmallBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["2ColumnSmallBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.32}],
  
  Cell[StyleData["3ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnSmallBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnSpacings->1.5,
    ColumnWidths->0.24,
    ColumnAlignments->{Right, Center, Left}}],
  
  Cell[StyleData["3ColumnSmallBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnSmallBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["3ColumnSmallBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["4ColumnBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.13, 0.35, 0.13, 0.35}}],
  
  Cell[StyleData["4ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["4ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["4ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["5ColumnBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->0.202}],
  
  Cell[StyleData["5ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["5ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["5ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["6ColumnBox"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxFrame->0.5,
    BoxMargins->True},
    GridBoxOptions->{ColumnWidths->{0.12, 0.22, 0.12, 0.12, 0.22, 0.12}}],
  
  Cell[StyleData["6ColumnBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["6ColumnBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["6ColumnBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNoteBox"],
    CellFrame->0.5,
    CellMargins->{{41, 4}, {4, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    FrameBoxOptions->{BoxMargins->{{1, 1}, {1.5, 1.5}}},
    GridBoxOptions->{ColumnSpacings->1}],
  
  Cell[StyleData["ItemizedNoteBox", "Printout"],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedNoteBox", "EnhancedPrintout"],
    CellMargins->{{37, 4}, {6, 6}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedNoteBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{37, 4}, {6, 6}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.4, 0.6},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox3Col"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.35, 0.2, 0.45},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox3Col", "SlideShow"],
    CellFrame->2,
    CellMargins->{{70, 50}, {4, 4}},
    CellFrameMargins->{{5, 5}, {3, 3}},
    CellFrameColor->RGBColor[0.869993, 0.449989, 0.219989],
    FontSize->12,
    Background->RGBColor[1, 1, 0.8]],
  
  Cell[StyleData["DefinitionBox3Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox3Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox3Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox4Col"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.15, 0.35, 0.15, 0.35},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox4Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox4Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox4Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox5Col"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->0.2,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox5Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox5Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox5Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DefinitionBox6Col"],
    CellFrame->0.5,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.13, 0.24, 0.13, 0.13, 0.24, 0.13},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["DefinitionBox6Col", "Printout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox6Col", "EnhancedPrintout"],
    CellMargins->{{2, 4}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["DefinitionBox6Col", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 4}, {0, 8}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{11, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopBox", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontFamily->"Palatino",
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontFamily->"Palatino",
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{11, 4}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleBox", "Printout"],
    CellMargins->{{2, 0}, {0, 2}},
    Background->GrayLevel[1]],
  
  Cell[StyleData["MiddleBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 4}},
    FontFamily->"Palatino",
    Background->GrayLevel[1]],
  
  Cell[StyleData["MiddleBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 4}},
    FontFamily->"Palatino",
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BottomBox"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{11, 4}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["BottomBox", "Printout"],
    CellMargins->{{2, 0}, {0, -5}},
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->2.2}],
  
  Cell[StyleData["BottomBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, -5}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->2.2}],
  
  Cell[StyleData["BottomBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, -5}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->2.2}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{11, 4}, {-2, 8}},
    CellHorizontalScrolling->True,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["TopSpanBox", "Printout"],
    CellMargins->{{2, 0}, {-2, 8}},
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopSpanBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {-4, 8}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]],
  
  Cell[StyleData["TopSpanBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {-4, 8}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleSpanBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{11, 4}, {0, 0}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.9, 0.03},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleSpanBox", "Printout"],
    CellMargins->{{2, 0}, {-5, 0}},
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpanBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {-7, 0}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpanBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {-7, 0}},
    FontFamily->"Palatino",
    FontSize->10,
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Picture"],
    CellMargins->{{12, Inherited}, {0, 8}},
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["Picture", "Printout"],
    CellMargins->{{2, Inherited}, {0, 8}},
    Magnification->0.65],
  
  Cell[StyleData["Picture", "EnhancedPrintout"],
    CellMargins->{{2, Inherited}, {0, 8}},
    Magnification->0.65],
  
  Cell[StyleData["Picture", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, Inherited}, {0, 8}},
    Magnification->0.65]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedPicture"],
    CellMargins->{{41, 4}, {4, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedPicture", "Printout"],
    CellMargins->{{77, 2}, {4, -4}},
    Magnification->0.5],
  
  Cell[StyleData["ItemizedPicture", "EnhancedPrintout"],
    CellMargins->{{75, 2}, {4, -6}},
    Magnification->0.5],
  
  Cell[StyleData["ItemizedPicture", "EnhancedPrintoutNonGray"],
    CellMargins->{{75, 2}, {4, -6}},
    Magnification->0.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PictureGroup"],
    CellMargins->{{41, 4}, {0, 4}},
    CellGroupingRules->"GraphicsGrouping",
    CellHorizontalScrolling->True,
    StyleMenuListing->None],
  
  Cell[StyleData["PictureGroup", "Printout"],
    CellElementSpacings->{"ClosedCellHeight"->2},
    CellOpen->False,
    FontSize->12],
  
  Cell[StyleData["PictureGroup", "EnhancedPrintout"],
    CellElementSpacings->{"ClosedCellHeight"->2},
    CellOpen->False,
    FontSize->12],
  
  Cell[StyleData["PictureGroup", "EnhancedPrintoutNonGray"],
    CellElementSpacings->{"ClosedCellHeight"->2},
    CellOpen->False,
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Sound"],
    ShowCellBracket->True,
    CellMargins->{{10, Inherited}, {0, 8}},
    StyleMenuListing->None],
  
  Cell[StyleData["Sound", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["Sound", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["Sound", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Caption"],
    CellMargins->{{10, 4}, {0, 3}},
    PageBreakAbove->False,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["Caption", "Printout"],
    CellMargins->{{2, 4}, {2, 0}},
    FontSize->7],
  
  Cell[StyleData["Caption", "EnhancedPrintout"],
    CellMargins->{{5, 4}, {2, -2}},
    FontFamily->"Futura",
    FontSize->7],
  
  Cell[StyleData["Caption", "EnhancedPrintoutNonGray"],
    CellMargins->{{5, 4}, {2, -2}},
    FontFamily->"Futura",
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Tables", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.34, 0.64},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["2ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["2ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["2ColumnEvenTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->0.49,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["2ColumnEvenTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["2ColumnEvenTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["2ColumnEvenTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->{0.28, 0.28, 0.43},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["3ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["3ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["3ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Formulas and Programming", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineFormula"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->1,
    SingleLetterItalics->True,
    SpanMaxSize->Infinity,
    StyleMenuListing->None,
    GridBoxOptions->{ColumnWidths->Automatic}],
  
  Cell[StyleData["InlineFormula", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["InlineFormula", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["InlineFormula", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InlineOutput"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->None,
    StyleMenuListing->None,
    FontFamily->"Courier"],
  
  Cell[StyleData["InlineOutput", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5],
  
  Cell[StyleData["InlineOutput", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5],
  
  Cell[StyleData["InlineOutput", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}},
    FontSize->9.5]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayFormula"],
    CellMargins->{{42, Inherited}, {Inherited, 10}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    LanguageCategory->"Formula",
    ScriptLevel->0,
    SingleLetterItalics->True,
    SpanMaxSize->Infinity,
    StyleMenuListing->None,
    UnderoverscriptBoxOptions->{LimitsPositioning->True},
    GridBoxOptions->{ColumnWidths->Automatic}],
  
  Cell[StyleData["DisplayFormula", "Printout"]],
  
  Cell[StyleData["DisplayFormula", "EnhancedPrintout"],
    FontFamily->"Palatino"],
  
  Cell[StyleData["DisplayFormula", "EnhancedPrintoutNonGray"],
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DisplayMath"],
    CellMargins->{{42, 10}, {7, 7}},
    Evaluatable->False,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    DefaultFormatType->DefaultInputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
    AutoItalicWords->{},
    LanguageCategory->"Formula",
    FormatType->InputForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    CounterIncrements->"Input"],
  
  Cell[StyleData["DisplayMath", "Printout"],
    CellMargins->{{39, 0}, {6, 6}},
    FontSize->9],
  
  Cell[StyleData["DisplayMath", "EnhancedPrintout"],
    CellMargins->{{39, 0}, {4, 6}},
    FontFamily->"WRICourier",
    FontSize->9],
  
  Cell[StyleData["DisplayMath", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 0}, {4, 6}},
    FontFamily->"WRICourier",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedEquation"],
    CellMargins->{{45, 10}, {7, 7}},
    CellFrameLabels->{{None, Cell[ 
            TextData[ {"(", 
              CounterBox[ "NumberedEquation"], ")"}]]}, {None, None}},
    DefaultFormatType->DefaultInputFormatType,
    LanguageCategory->"Formula",
    CounterIncrements->"NumberedEquation",
    FormatTypeAutoConvert->False],
  
  Cell[StyleData["NumberedEquation", "Printout"],
    CellMargins->{{39, 55}, {0, 10}},
    FontSize->10],
  
  Cell[StyleData["NumberedEquation", "EnhancedPrintout"],
    CellMargins->{{39, 55}, {0, 10}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["NumberedEquation", "EnhancedPrintoutNonGray"],
    CellMargins->{{39, 55}, {0, 10}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["EquationNumber"],
    LineSpacing->{1.83, 0},
    LanguageCategory->"Formula"],
  
  Cell[StyleData["EquationNumber", "Printout"],
    LineSpacing->{1.7, 0}],
  
  Cell[StyleData["EquationNumber", "EnhancedPrintout"],
    LineSpacing->{1.7, 0},
    FontFamily->"Palatino"],
  
  Cell[StyleData["EquationNumber", "EnhancedPrintoutNonGray"],
    LineSpacing->{1.7, 0},
    FontFamily->"Palatino"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Program"],
    CellMargins->{{16, Inherited}, {Inherited, 10}},
    CellHorizontalScrolling->True,
    LanguageCategory->"Formula",
    FontFamily->"Courier"],
  
  Cell[StyleData["Program", "Printout"],
    CellMargins->{{42, 30}, {Inherited, 4}},
    FontSize->9.5],
  
  Cell[StyleData["Program", "EnhancedPrintout"],
    CellMargins->{{42, 30}, {Inherited, 4}},
    FontFamily->"WRICourier",
    FontSize->9.5],
  
  Cell[StyleData["Program", "EnhancedPrintoutNonGray"],
    CellMargins->{{42, 30}, {Inherited, 4}},
    FontFamily->"WRICourier",
    FontSize->9.5]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Unique Help Browser Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell["\<\
Standard Styles
\
\>", "Subsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InspectorLevel1"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{12, 10}, {2, 7}},
    CellGroupingRules->{"SectionGrouping", 60},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-38,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["InspectorLevel1", "Brackets"],
    HyphenationOptions->{"HyphenationCharacter"->"-"}],
  
  Cell[StyleData["InspectorLevel1", "SlideShow"],
    HyphenationOptions->{"HyphenationCharacter"->"-"}],
  
  Cell[StyleData["InspectorLevel1", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["InspectorLevel2"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{10, 4}, {0, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["InspectorLevel2", "Brackets"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{48, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["InspectorLevel2", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{48, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["InspectorLevel2", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ObjectName"],
    CellMargins->{{10, 4}, {1, 10}},
    CellGroupingRules->{"SectionGrouping", 50},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectName", "Brackets"],
    CellMargins->{{72, 4}, {1, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectName", "SlideShow"],
    CellMargins->{{72, 4}, {1, 14}},
    CellGroupingRules->{"SectionGrouping", 90},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectName", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubObjectNameClosed"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{10, 4}, {1, 10}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->False},
    CellGroupingRules->{"SectionGrouping", 90},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->14,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubObjectNameClosed", "Brackets"],
    CellMargins->{{72, 4}, {1, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubObjectNameClosed", "SlideShow"],
    CellMargins->{{72, 4}, {1, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubObjectNameClosed", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubObjectName"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{24, 4}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["SubObjectName", "Brackets"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{90, 4}, {1, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->12],
  
  Cell[StyleData["SubObjectName", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{90, 4}, {1, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->12],
  
  Cell[StyleData["SubObjectName", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GroupObjectName"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{10, 4}, {0, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectName", "Brackets"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{72, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectName", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{72, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectName", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["GroupObjectNameClosed"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{10, 4}, {0, 14}},
    PrivateCellOptions->{"DefaultCellGroupOpen"->False},
    CellGroupingRules->{"SectionGrouping", 80},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectNameClosed", "Brackets"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{72, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectNameClosed", "SlideShow"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{72, 10}, {2, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-27,
    CounterIncrements->"Outline2",
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["GroupObjectNameClosed", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ObjectNameWarningMessages"],
    CellMargins->{{10, 4}, {1, 10}},
    CellGroupingRules->{"SectionGrouping", 65},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectNameWarningMessages", "Brackets"],
    CellMargins->{{10, 4}, {1, 10}},
    CellGroupingRules->{"SectionGrouping", 65},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectNameWarningMessages", "SlideShow"],
    CellMargins->{{10, 4}, {1, 10}},
    CellGroupingRules->{"SectionGrouping", 65},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontFamily->"Courier",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["ObjectNameWarningMessages", "Printout"],
    CellMargins->{{2, 0}, {1, 10}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Command"],
    CellMargins->{{10, 4}, {0, 14}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    CounterIncrements->"Section",
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Command", "Printout"],
    CellMargins->{{2, 0}, {0, 14}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CharacterName"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{10, 4}, {0, 4}},
    CellFrameMargins->4,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None],
  
  Cell[StyleData["CharacterName", "Brackets"],
    CellMargins->{{72, 4}, {1, 14}},
    CellGroupingRules->{"SectionGrouping", 90},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["CharacterName", "SlideShow"],
    CellMargins->{{72, 4}, {1, 14}},
    CellGroupingRules->{"SectionGrouping", 90},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["CharacterName", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Usage"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{10, 4}, {0, 4}},
    CellFrameMargins->5,
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None],
  
  Cell[StyleData["Usage", "Brackets"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{72, 4}, {0, 4}},
    CellFrameMargins->5,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None],
  
  Cell[StyleData["Usage", "SlideShow"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    CellMargins->{{72, 4}, {0, 4}},
    CellFrameMargins->5,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None],
  
  Cell[StyleData["Usage", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ErrorMessage"],
    CellFrame->{{0, 0}, {0.5, 0.5}},
    ShowCellBracket->True,
    CellMargins->{{10, 4}, {0, 4}},
    CellGroupingRules->"OutputGrouping",
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    ShowCellLabel->False,
    CellLabelMargins->{{14, Inherited}, {Inherited, Inherited}},
    CellFrameMargins->5,
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FormatType->InputForm,
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 1]],
  
  Cell[StyleData["ErrorMessage", "Brackets"],
    CellMargins->{{72, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None],
  
  Cell[StyleData["ErrorMessage", "SlideShow"],
    CellMargins->{{72, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None],
  
  Cell[StyleData["ErrorMessage", "Printout"],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Notes"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["Notes", "Brackets"],
    CellMargins->{{72, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["Notes", "SlideShow"],
    CellMargins->{{72, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    ParagraphIndent->-10,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["Notes", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NotesList"],
    CellMargins->{{20, 4}, {2, 8}},
    CellHorizontalScrolling->True,
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ScriptLevel->1,
    SingleLetterItalics->True,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["NotesList", "Brackets"],
    CellMargins->{{82, 4}, {2, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ScriptLevel->1,
    SingleLetterItalics->True,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["NotesList", "SlideShow"],
    CellMargins->{{82, 4}, {2, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ScriptLevel->1,
    SingleLetterItalics->True,
    StyleMenuListing->None,
    FontFamily->"Times"],
  
  Cell[StyleData["NotesList", "Printout"],
    CellMargins->{{12, 0}, {2, 8}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{11, 4}, {0, 10}},
    CellGroupingRules->{"SectionGrouping", 70},
    CellFrameMargins->12,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontSize->13,
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 0.4]],
  
  Cell[StyleData["ExampleSection", "Printout"],
    CellMargins->{{3, 0}, {0, 10}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleText"],
    CellMargins->{{20, 40}, {0, 18}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 6},
    StyleMenuListing->None,
    FontColor->RGBColor[0, 0, 0.4]],
  
  Cell[StyleData["ExampleText", "Printout"],
    CellMargins->{{2, 80}, {0, 8}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->8,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ExampleSubsection"],
    ShowCellBracket->True,
    CellMargins->{{20, 4}, {0, 16}},
    CellGroupingRules->{"SectionGrouping", 80},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["ExampleSubsection", "Printout"],
    CellMargins->{{12, 0}, {0, 16}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["LineHead"],
    CellFrame->{{0, 0}, {0.5, 0}},
    CellMargins->{{10, 4}, {8, 18}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["LineHead", "Printout"],
    CellMargins->{{2, 0}, {8, 18}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FlushInput"],
    CellMargins->{{10, 4}, {1, 4}},
    Evaluatable->True,
    CellGroupingRules->"InputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultInputFormatType,
    ShowSpecialCharacters->Automatic,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FormatType->StandardForm,
    ShowStringCharacters->True,
    NumberMarks->True,
    StyleMenuListing->None,
    FontWeight->"Bold"],
  
  Cell[StyleData["FlushInput", "Printout"],
    CellMargins->{{2, 0}, {1, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FlushOutput"],
    CellMargins->{{10, Inherited}, {Inherited, Inherited}},
    CellEditDuplicate->True,
    CellGroupingRules->"OutputGrouping",
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    GroupPageBreakWithin->False,
    GeneratedCell->True,
    CellAutoOverwrite->True,
    CellLabelAutoDelete->False,
    CellLabelMargins->{{23, Inherited}, {Inherited, Inherited}},
    DefaultFormatType->DefaultOutputFormatType,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FormatType->StandardForm,
    StyleMenuListing->None],
  
  Cell[StyleData["FlushOutput", "Printout"],
    CellMargins->{{2, Inherited}, {Inherited, Inherited}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["DialogItem"],
    CellDingbat->"\[EmptyDiamond]",
    CellMargins->{{20, 4}, {0, 12}},
    CellGroupingRules->{"SectionGrouping", 70},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["DialogItem", "Printout"],
    CellMargins->{{12, 0}, {0, 12}},
    PageBreakBelow->False,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->8]
  }, Closed]],
  
  Cell[StyleData["GroupDivider"],
    CellMargins->{{10, Inherited}, {Inherited, Inherited}},
    CellEditDuplicate->True,
    CellGroupingRules->{"TitleGrouping", 0},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Highlight"],
    CellMargins->{{10, 4}, {0, 18}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["Highlight", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["UserNotes"],
    CellFrame->{{2, 0}, {0, 0.25}},
    CellMargins->{{10, 4}, {0, 4}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["UserNotes", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MoreInfo"],
    CellMargins->{{10, 4}, {0, 4}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontColor->GrayLevel[1],
    Background->RGBColor[0.700008, 0.4, 0.100008]],
  
  Cell[StyleData["MoreInfo", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["UserTips"],
    CellFrame->{{2, 0}, {0, 0.25}},
    CellMargins->{{10, 4}, {0, 4}},
    Hyphenation->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphIndent->-7,
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontColor->GrayLevel[1],
    Background->RGBColor[0.2, 0.500008, 0.700008]],
  
  Cell[StyleData["UserTips", "Printout"],
    CellMargins->{{2, 0}, {0, 4}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 3},
    FontSize->8,
    Background->GrayLevel[0.700008]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Theorem"],
    CellFrame->{{4, 0}, {0, 0}},
    CellMargins->{{12, 62}, {0, 14}},
    CellFrameMargins->4,
    CellFrameColor->RGBColor[0, 0, 0.8],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    LineSpacing->{1, 1},
    ParagraphSpacing->{0, 8}],
  
  Cell[StyleData["Theorem", "Printout"],
    CellMargins->{{2, 0}, {0, 14}},
    CellFrameMargins->3,
    CellFrameColor->GrayLevel[0.8],
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->9,
    FontColor->GrayLevel[0]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Commentary"],
    CellFrame->{{2, 0}, {0, 0}},
    CellMargins->{{36, 10}, {7, 7}},
    PageBreakBelow->False,
    CellFrameMargins->8,
    CellFrameColor->RGBColor[0, 0.2, 1],
    LineSpacing->{1, 3},
    FontSlant->"Italic"],
  
  Cell[StyleData["Commentary", "Printout"],
    CellMargins->{{36, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontSize->10],
  
  Cell[StyleData["Commentary", "EnhancedPrintout"],
    CellMargins->{{36, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Commentary", "EnhancedPrintoutNonGray"],
    CellMargins->{{36, 0}, {6, 6}},
    CellFrameColor->GrayLevel[0.8],
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Level1Icon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None],
  
  Cell[StyleData["Level1Icon", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Level2Icon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None],
  
  Cell[StyleData["Level2Icon", "Printout"],
    CellMargins->{{2, 0}, {0, 8}},
    HyphenationOptions->{"HyphenationCharacter"->"-"},
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Manual.nb Merge", "Subsection"],
  
  Cell[CellGroupData[{
  
  Cell["Function List", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionName"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{24, 10}, {10, 12}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    StyleMenuListing->None,
    FontFamily->"Courier",
    FontSize->14,
    FontWeight->"Bold",
    CellTags->"FunctionName"],
  
  Cell[StyleData["FunctionName", "Printout"],
    CellMargins->{{9, 0}, {10, 10}},
    FontSize->12],
  
  Cell[StyleData["FunctionName", "EnhancedPrintout"],
    CellMargins->{{9, 0}, {10, 10}},
    FontFamily->"Courier",
    FontSize->12],
  
  Cell[StyleData["FunctionName", "EnhancedPrintoutNonGray"],
    CellMargins->{{9, 0}, {10, 10}},
    FontFamily->"Courier",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{24, 10}, {0, 30}},
    CellGroupingRules->{"SectionGrouping", 50},
    PageBreakBelow->False,
    StyleMenuListing->None,
    FontSize->14,
    FontWeight->"Bold",
    CellTags->"FunctionSection"],
  
  Cell[StyleData["SubsectionIcon", "Printout"],
    CellMargins->{{20, 0}, {0, 20}},
    FontSize->13],
  
  Cell[StyleData["SubsectionIcon", "EnhancedPrintout"],
    CellMargins->{{20, 0}, {0, 20}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["SubsectionIcon", "EnhancedPrintoutNonGray"],
    CellMargins->{{20, 0}, {0, 20}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionSubsection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{36, 10}, {0, 6}},
    CellGroupingRules->{"SectionGrouping", 60},
    PageBreakBelow->False,
    StyleMenuListing->None,
    FontWeight->"Bold",
    CellTags->"FunctionSubsection"],
  
  Cell[StyleData["FunctionSubsection", "Printout"],
    CellMargins->{{30, 0}, {0, 6}}],
  
  Cell[StyleData["FunctionSubsection", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {0, 6}},
    FontFamily->"Palatino",
    FontSize->11],
  
  Cell[StyleData["FunctionSubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {0, 6}},
    FontFamily->"Palatino",
    FontSize->11]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SubsubsectionIcon"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{36, 10}, {0, 6}},
    CellGroupingRules->{"SectionGrouping", 60},
    PageBreakBelow->False,
    StyleMenuListing->None,
    FontWeight->"Bold",
    CellTags->"SubsubsectionIcon"],
  
  Cell[StyleData["SubsubsectionIcon", "Printout"],
    CellMargins->{{30, 0}, {0, 6}},
    FontSize->11],
  
  Cell[StyleData["SubsubsectionIcon", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {0, 6}},
    FontFamily->"Palatino",
    FontSize->9],
  
  Cell[StyleData["SubsubsectionIcon", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {0, 6}},
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescription"],
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None,
    FontWeight->"Plain"],
  
  Cell[StyleData["FunctionDescription", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescription", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescription", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescriptionRuled"],
    CellFrame->{{0, 0}, {0.25, 0.25}},
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionDescriptionRuled", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescriptionRuled", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescriptionRuleTop"],
    CellFrame->{{0, 0}, {0, 0.25}},
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescriptionRuleTop", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionDescriptionRuleBottom"],
    CellFrame->{{0, 0}, {0.25, 0}},
    CellMargins->{{36, 10}, {4, 0}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0.7, 0},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->11],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["FunctionDescriptionRuleBottom", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    TextJustification->0,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionExample"],
    CellMargins->{{36, 10}, {4, 0}},
    StyleMenuListing->None,
    FontSize->10],
  
  Cell[StyleData["FunctionExample", "Printout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontSize->9],
  
  Cell[StyleData["FunctionExample", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {4, 0}},
    FontFamily->"Palatino",
    FontSize->9],
  
  Cell[StyleData["FunctionExample", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {4, 0}},
    FontFamily->"Palatino",
    FontSize->9]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["FunctionTextNote"],
    CellMargins->{{36, 4}, {0, 4}},
    LineSpacing->{1, 3},
    ParagraphSpacing->{0, 4},
    LineIndent->0,
    StyleMenuListing->None],
  
  Cell[StyleData["FunctionTextNote", "Printout"],
    CellMargins->{{36, 4}, {0, 4}},
    FontSize->9],
  
  Cell[StyleData["FunctionTextNote", "EnhancedPrintout"],
    CellMargins->{{36, 4}, {0, 4}},
    FontFamily->"Palatino",
    FontSize->8],
  
  Cell[StyleData["FunctionTextNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{36, 4}, {0, 4}},
    FontFamily->"Palatino",
    FontSize->8]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["3ColumnFunctionTable"],
    CellMargins->{{36, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->{0.28, 0.28, 0.43},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["3ColumnFunctionTable", "Printout"],
    CellMargins->{{30, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintout"],
    CellMargins->{{30, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["3ColumnFunctionTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{30, 0}, {0, 8}},
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Browser Emulation", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextNormal"],
    CellMargins->{{12, 10}, {7, 7}},
    LineSpacing->{1, 3},
    CounterIncrements->"Text",
    StyleMenuListing->None,
    FontFamily->"Times",
    FontSize->12],
  
  Cell[StyleData["TextNormal", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BrowserEmulation"],
    CellMargins->{{12, 1}, {7, 24}},
    CellGroupingRules->{"SectionGrouping", 70},
    LineSpacing->{1, 3},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    GridBoxOptions->{ColumnWidths->0.25,
    ColumnAlignments->{Left},
    GridFrame->True,
    GridFrameMargins->0.5,
    ColumnLines->True}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CategoryDefs"],
    CellMargins->{{300, 10}, {7, 7}},
    LineSpacing->{1, 3},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    Background->RGBColor[1, 0.8, 0.6],
    GridBoxOptions->{ColumnAlignments->{Left},
    GridFrame->False,
    RowLines->True,
    ColumnLines->True}],
  
  Cell[StyleData["Text", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category1"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{12, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 50},
    StyleMenuListing->None,
    FontSize->16,
    FontWeight->"Bold"],
  
  Cell[StyleData["Category1", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category2"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{85, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 60},
    StyleMenuListing->None,
    FontSize->14,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 0.500008]],
  
  Cell[StyleData["Category2", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category3"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{157, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 70},
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Bold",
    FontColor->RGBColor[0.2, 0, 0.4]],
  
  Cell[StyleData["Category3", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Category4"],
    ShowCellBracket->False,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{230, 10}, {7, 7}},
    CellGroupingRules->{"SectionGrouping", 80},
    StyleMenuListing->None,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0.300008, 0.4]],
  
  Cell[StyleData["Category4", "Printout"],
    CellMargins->{{2, 2}, {6, 6}}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Misc", "Subsubsection"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["4ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.25,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["4ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["4ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["4ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["5ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.2,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["5ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["5ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["5ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["6ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.16,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["6ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["6ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["6ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["7ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.14,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["7ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["7ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["7ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["8ColumnTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnWidths->0.12,
    ColumnAlignments->{Left, Center}}],
  
  Cell[StyleData["8ColumnTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["8ColumnTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["8ColumnTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ABItemizedText"],
    CellMargins->{{20, 4}, {0, 5}},
    Hyphenation->True,
    LineSpacing->{1, 3},
    ParagraphIndent->-21,
    CounterIncrements->"ItemizedText",
    StyleMenuListing->None],
  
  Cell[StyleData["ABItemizedText", "Printout"],
    ParagraphIndent->-21,
    FontSize->11],
  
  Cell[StyleData["ABItemizedText", "EnhancedPrintout"],
    ParagraphIndent->-21,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ABItemizedText", "EnhancedPrintoutNonGray"],
    ParagraphIndent->-21,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ChapNumber"],
    CellMargins->{{12, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->42,
    FontWeight->"Plain"],
  
  Cell[StyleData["ChapNumber", "Printout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontSize->36],
  
  Cell[StyleData["ChapNumber", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Futura",
    FontSize->36],
  
  Cell[StyleData["ChapNumber", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Futura",
    FontSize->36]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ChapTitle"],
    CellMargins->{{12, Inherited}, {80, 10}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["ChapTitle", "Printout"],
    CellMargins->{{2, 10}, {80, 6}},
    FontSize->30],
  
  Cell[StyleData["ChapTitle", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {80, 6}},
    FontFamily->"Futura",
    FontSize->30],
  
  Cell[StyleData["ChapTitle", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {80, 6}},
    FontFamily->"Futura",
    FontSize->30]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item1"],
    CellMargins->{{28, 4}, {4, 4}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-23,
    CounterIncrements->"Item1",
    StyleMenuListing->None],
  
  Cell[StyleData["Item1", "Printout"],
    CellMargins->{{12, 0}, {0, 8}}],
  
  Cell[StyleData["Item1", "EnhancedPrintout"],
    CellMargins->{{12, 0}, {0, 8}},
    FontSize->10],
  
  Cell[StyleData["Item1", "EnhancedPrintoutNonGray"],
    CellMargins->{{12, 0}, {0, 8}},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item1Continued"],
    CellMargins->{{71, 4}, {2, 2}},
    CellGroupingRules->{"SectionGrouping", 15},
    CounterIncrements->"Item1Continued",
    StyleMenuListing->None],
  
  Cell[StyleData["Item1Continued", "Printout"],
    CellMargins->{{12, 0}, {0, 8}}],
  
  Cell[StyleData["Item1Continued", "EnhancedPrintout"],
    CellMargins->{{12, 0}, {0, 8}}],
  
  Cell[StyleData["Item1Continued", "EnhancedPrintoutNonGray"],
    CellMargins->{{12, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item2"],
    CellMargins->{{42, 4}, {3, 3}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-21,
    CounterIncrements->"Item2",
    StyleMenuListing->None],
  
  Cell[StyleData["Item2", "Printout"],
    CellMargins->{{40, 0}, {0, 4}},
    ParagraphIndent->-18,
    FontSize->10],
  
  Cell[StyleData["Item2", "EnhancedPrintout"],
    CellMargins->{{40, 0}, {0, 4}},
    ParagraphIndent->-18,
    FontSize->10],
  
  Cell[StyleData["Item2", "EnhancedPrintoutNonGray"],
    CellMargins->{{40, 0}, {0, 4}},
    ParagraphIndent->-18,
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item2Continued"],
    CellMargins->{{92, 4}, {2, 2}},
    CellGroupingRules->{"SectionGrouping", 15},
    CounterIncrements->"Item2Continued",
    StyleMenuListing->None],
  
  Cell[StyleData["Item2Continued", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["Item2Continued", "EnhancedPrintout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["Item2Continued", "EnhancedPrintoutNonGray"],
    CellMargins->{{27, 0}, {0, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item3"],
    CellMargins->{{94, 4}, {2, 2}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-23,
    CounterIncrements->"Item3",
    StyleMenuListing->None],
  
  Cell[StyleData["Item3", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["Item3", "EnhancedPrintout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["Item3", "EnhancedPrintoutNonGray"],
    CellMargins->{{27, 0}, {0, 4}},
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Item3Continued"],
    CellMargins->{{117, 4}, {2, 2}},
    CellGroupingRules->{"SectionGrouping", 15},
    CounterIncrements->"Item3Continued",
    StyleMenuListing->None],
  
  Cell[StyleData["Item3Continued", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["Item3Continued", "EnhancedPrintout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["Item3Continued", "EnhancedPrintoutNonGray"],
    CellMargins->{{27, 0}, {0, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedBottomBox"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{37, 4}, {4, 0}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["ItemizedBottomBox", "Printout"],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedBottomBox", "EnhancedPrintout"],
    CellMargins->{{37, 4}, {6, 0}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedBottomBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{37, 4}, {6, 0}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedBulletText"],
    CellMargins->{{20, 4}, {0, 5}},
    Hyphenation->True,
    LineSpacing->{1, 3},
    ParagraphIndent->-22,
    CounterIncrements->"ItemizedBulletText",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedBulletText", "Printout"],
    ParagraphIndent->-20,
    FontSize->11],
  
  Cell[StyleData["ItemizedBulletText", "EnhancedPrintout"],
    ParagraphIndent->-19,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedBulletText", "EnhancedPrintoutNonGray"],
    ParagraphIndent->-19,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNote"],
    CellMargins->{{41, 4}, {0, 12}},
    Hyphenation->True,
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedNote", "Printout"],
    CellMargins->{{38, 4}, {0, 9}},
    FontSize->11],
  
  Cell[StyleData["ItemizedNote", "EnhancedPrintout"],
    CellMargins->{{38, 4}, {0, 0}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedNote", "EnhancedPrintoutNonGray"],
    CellMargins->{{38, 4}, {0, 0}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedNoteBelow"],
    CellMargins->{{41, 4}, {0, 8}},
    Hyphenation->True,
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedNoteBelow", "Printout"],
    CellMargins->{{38, 4}, {0, 12}},
    FontSize->11],
  
  Cell[StyleData["ItemizedNoteBelow", "EnhancedPrintout"],
    CellMargins->{{38, 4}, {0, 8}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedNoteBelow", "EnhancedPrintoutNonGray"],
    CellMargins->{{38, 4}, {0, 8}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextBelowPic"],
    CellMargins->{{20, 4}, {0, 8}},
    Hyphenation->True,
    LineSpacing->{1, 3},
    ParagraphIndent->-22,
    CounterIncrements->"ItemizedText",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextBelowPic", "Printout"],
    CellMargins->{{20, 4}, {2, 12}},
    ParagraphIndent->-18,
    FontSize->11],
  
  Cell[StyleData["ItemizedTextBelowPic", "EnhancedPrintout"],
    CellMargins->{{20, 4}, {2, 12}},
    ParagraphIndent->-17,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedTextBelowPic", "EnhancedPrintoutNonGray"],
    CellMargins->{{20, 4}, {2, 12}},
    ParagraphIndent->-17,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTextNote2"],
    CellMargins->{{41, 4}, {0, 4}},
    Hyphenation->True,
    LineSpacing->{1, 2},
    CounterIncrements->"Text",
    StyleMenuListing->None],
  
  Cell[StyleData["ItemizedTextNote2", "Printout"],
    CellMargins->{{38, 4}, {0, 2}},
    FontSize->11],
  
  Cell[StyleData["ItemizedTextNote2", "EnhancedPrintout"],
    CellMargins->{{38, 4}, {0, 2}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["ItemizedTextNote2", "EnhancedPrintoutNonGray"],
    CellMargins->{{38, 4}, {0, 2}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ItemizedTopBox"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{37, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    LineIndent->0,
    StyleMenuListing->None,
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["ItemizedTopBox", "Printout"],
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedTopBox", "EnhancedPrintout"],
    CellMargins->{{37, 4}, {0, 6}},
    FontSize->10,
    Background->GrayLevel[0.900008]],
  
  Cell[StyleData["ItemizedTopBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{37, 4}, {0, 6}},
    FontSize->10,
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["MiddleSpacedBox"],
    CellFrame->{{0.5, 0.5}, {0, 0}},
    CellMargins->{{11, 4}, {0, -7}},
    CellHorizontalScrolling->True,
    PageBreakAbove->False,
    PageBreakBelow->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    FontWeight->"Plain",
    Background->RGBColor[1, 0.6, 0.6],
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->1,
    ColumnWidths->{0.31, 0.62},
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["MiddleSpacedBox", "Printout"],
    CellMargins->{{2, 0}, {0, 0}},
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpacedBox", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 0}},
    FontFamily->"Palatino",
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}],
  
  Cell[StyleData["MiddleSpacedBox", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 0}},
    FontFamily->"Palatino",
    Background->GrayLevel[1],
    GridBoxOptions->{RowMinHeight->1.8}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedItem1"],
    CellMargins->{{48, 4}, {4, 4}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-23,
    CounterIncrements->"NumberedItem1",
    StyleMenuListing->None],
  
  Cell[StyleData["NumberedItem1", "Printout"],
    CellMargins->{{12, 0}, {0, 8}}],
  
  Cell[StyleData["NumberedItem1", "EnhancedPrintout"],
    CellMargins->{{12, 0}, {0, 8}}],
  
  Cell[StyleData["NumberedItem1", "EnhancedPrintoutNonGray"],
    CellMargins->{{12, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedItem2"],
    CellMargins->{{71, 4}, {3, 3}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-21,
    CounterIncrements->"NumberedItem2",
    StyleMenuListing->None],
  
  Cell[StyleData["NumberedItem2", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem2", "EnhancedPrintout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem2", "EnhancedPrintoutNonGray"],
    CellMargins->{{27, 0}, {0, 4}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["NumberedItem3"],
    CellMargins->{{94, 4}, {2, 2}},
    CellGroupingRules->{"SectionGrouping", 15},
    ParagraphIndent->-23,
    CounterIncrements->"NumberedItem3",
    StyleMenuListing->None],
  
  Cell[StyleData["NumberedItem3", "Printout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem3", "EnhancedPrintout"],
    CellMargins->{{27, 0}, {0, 4}}],
  
  Cell[StyleData["NumberedItem3", "EnhancedPrintoutNonGray"],
    CellMargins->{{27, 0}, {0, 4}},
    StyleMenuListing->None]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageHeaderBold"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontSize->8,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  
  Cell[StyleData["Header", "Printout"]],
  
  Cell[StyleData["Header", "EnhancedPrintout"],
    FontFamily->"Futura"],
  
  Cell[StyleData["Header", "EnhancedPrintoutNonGray"],
    FontFamily->"Futura"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["S9"],
    ConversionRules:>{"HTML" -> {"<Font=Helvetica, Arial>", "</Font>"}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Plain"],
  
  Cell[StyleData["S9", "Printout"],
    FontSize->9,
    FontWeight->"Plain"],
  
  Cell[StyleData["S9", "EnhancedPrintout"],
    FontFamily->"Futura",
    FontSize->9,
    FontWeight->"Plain"],
  
  Cell[StyleData["S9", "EnhancedPrintoutNonGray"],
    FontFamily->"Futura",
    FontSize->9,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["S10"],
    ConversionRules:>{"HTML" -> {"<Font=Helvetica, Arial>", "</Font>"}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["S10", "Printout"],
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["S10", "EnhancedPrintout"],
    FontFamily->"Futura",
    FontSize->10,
    FontWeight->"Plain"],
  
  Cell[StyleData["S10", "EnhancedPrintoutNonGray"],
    FontFamily->"Futura",
    FontSize->10,
    FontWeight->"Plain"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SB9"],
    ConversionRules:>{"HTML" -> {"<Font=Helvetica, Arial>", "</Font>"}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9,
    FontWeight->"Bold",
    PrivateFontOptions->{"OperatorSubstitution"->False}],
  
  Cell[StyleData["SB9", "Printout"],
    FontSize->7],
  
  Cell[StyleData["SB9", "EnhancedPrintout"],
    FontFamily->"Futura",
    FontSize->7],
  
  Cell[StyleData["SB9", "EnhancedPrintoutNonGray"],
    FontFamily->"Futura",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SB10"],
    ConversionRules:>{"HTML" -> {"<Font=Helvetica, Arial>", "</Font>"}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold"],
  
  Cell[StyleData["SB10", "Printout"],
    FontSize->7],
  
  Cell[StyleData["SB10", "EnhancedPrintout"],
    FontFamily->"Futura",
    FontSize->7],
  
  Cell[StyleData["SB10", "EnhancedPrintoutNonGray"],
    FontFamily->"Futura",
    FontSize->7]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SingleRowTable"],
    CellMargins->{{10, 4}, {0, 8}},
    CellHorizontalScrolling->True,
    PageBreakWithin->False,
    AutoIndent->False,
    AutoSpacing->False,
    LineIndent->0,
    StyleMenuListing->None,
    GridBoxOptions->{RowSpacings->1.5,
    ColumnSpacings->2,
    ColumnAlignments->{Left}}],
  
  Cell[StyleData["SingleRowTable", "Printout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["SingleRowTable", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 8}}],
  
  Cell[StyleData["SingleRowTable", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 8}}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubsubsection"],
    CellMargins->{{10, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    ConversionRules:>{"HTML" -> {"<FONT FACE=\"Helvetica, Arial\"><P><B>", 
      "</B></P></FONT>\n"}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    StyleMenuListing->None,
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Subsubsubsection", "Printout"],
    CellMargins->{{2, 0}, {7, 18}},
    FontSize->10],
  
  Cell[StyleData["Subsubsubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {7, 18}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Subsubsubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {7, 18}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subsubtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 20},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subsubtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->14,
    FontSlant->"Italic"],
  
  Cell[StyleData["Subsubtitle", "Printout"],
    CellMargins->{{2, 10}, {8, 10}},
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {8, 10}},
    FontFamily->"Futura",
    FontSize->12],
  
  Cell[StyleData["Subsubtitle", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {8, 10}},
    FontFamily->"Futura",
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Subtitle"],
    CellMargins->{{12, Inherited}, {20, 15}},
    CellGroupingRules->{"TitleGrouping", 10},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Subtitle",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "Printout"],
    CellMargins->{{2, 10}, {10, 15}},
    FontSize->24],
  
  Cell[StyleData["Subtitle", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {10, 15}},
    FontFamily->"Futura",
    FontSize->24],
  
  Cell[StyleData["Subtitle", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {10, 15}},
    FontFamily->"Futura",
    FontSize->24]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TextBelow"],
    CellMargins->{{10, 4}, {0, 14}},
    ConversionRules:>{"HTML" -> {"<P>", "</P>"}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    Hyphenation->True,
    ParagraphSpacing->{0, 8},
    StyleMenuListing->None,
    FontSize->12],
  
  Cell[StyleData["TextBelow", "Printout"],
    CellMargins->{{2, 2}, {6, 12}},
    TextJustification->1,
    FontSize->10],
  
  Cell[StyleData["TextBelow", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 12}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["TextBelow", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 12}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Title"],
    CellMargins->{{12, Inherited}, {20, 40}},
    CellGroupingRules->{"TitleGrouping", 0},
    PageBreakBelow->False,
    DefaultNewInlineCellStyle->"None",
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    LanguageCategory->"NaturalLanguage",
    CounterIncrements->"Title",
    CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
        "Subtitle", 0}, {"Subsubtitle", 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->36,
    FontWeight->"Bold"],
  
  Cell[StyleData["Title", "Printout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontSize->30],
  
  Cell[StyleData["Title", "EnhancedPrintout"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Futura",
    FontSize->30],
  
  Cell[StyleData["Title", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 10}, {15, 30}},
    FontFamily->"Futura",
    FontSize->30]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Undersubsection"],
    CellMargins->{{10, 4}, {0, 18}},
    CellElementSpacings->{"ClosedGroupTopMargin"->18},
    ConversionRules:>{"HTML" -> {"<FONT FACE=\"Helvetica, Arial\"><P><B>", 
      "</B></P></FONT>\n"}},
    InputAutoReplacements->{"TeX"->StyleBox[ 
            RowBox[ {"T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "LaTeX"->StyleBox[ 
            RowBox[ {"L", 
              StyleBox[ 
                AdjustmentBox[ 
                "A", BoxMargins -> {{-0.35999999999999999, \
-0.10000000000000001}, {0, 0}}, BoxBaselineShift -> -0.20000000000000001], 
                FontSize -> Smaller], "T", 
              AdjustmentBox[ 
              "E", BoxMargins -> {{-0.074999999999999997, \
-0.085000000000000006}, {0, 0}}, BoxBaselineShift -> 0.5], "X"}]], 
        "mma"->"Mathematica", "Mma"->"Mathematica", "MMA"->"Mathematica", 
        Inherited},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["Undersubsection", "Printout"],
    CellMargins->{{2, 0}, {7, 10}},
    FontSize->10],
  
  Cell[StyleData["Undersubsection", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {7, 8}},
    FontFamily->"Futura",
    FontSize->10],
  
  Cell[StyleData["Undersubsection", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {7, 8}},
    FontFamily->"Futura",
    FontSize->10]
  }, Closed]]
  }, Closed]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["AuthorTools", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["BilateralCell"],
    CellMargins->{{10, 4}, {0, 8}},
    FontSize->12],
  
  Cell[StyleData["BilateralCell", "SlideShow"],
    CellMargins->{{36, 24}, {4, 4}},
    Background->GrayLevel[0.900008],
    GridBoxOptions->{ColumnWidths->{0.4, 0.6}}],
  
  Cell[StyleData["BilateralCell", "Printout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontSize->10],
  
  Cell[StyleData["BilateralCell", "EnhancedPrintout"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["BilateralCell", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 2}, {6, 6}},
    TextJustification->1,
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Slide Show Styles", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideShowNavigationBar"],
    CellFrame->True,
    ShowCellBracket->False,
    CellMargins->{{0, 0}, {0, 30}},
    CellElementSpacings->{"CellMinHeight"->0.8125},
    CellGroupingRules->{"SectionGrouping", 30},
    CellFrameMargins->False,
    CellFrameColor->GrayLevel[1],
    CellFrameLabelMargins->False,
    TextAlignment->Center,
    CounterIncrements->"SlideShowNavigationBar",
    FontSize->10,
    Background->GrayLevel[0.8],
    Magnification->1,
    GridBoxOptions->{GridBaseline->Center,
    RowSpacings->0,
    ColumnSpacings->0,
    ColumnWidths->{3.5, 3.5, 3.5, 3.5, 13, 5, 4},
    RowAlignments->Baseline,
    ColumnAlignments->{
      Center, Center, Center, Center, Center, Center, Right, Center}}],
  
  Cell[StyleData["SlideShowNavigationBar", "SlideShow"],
    ShowCellBracket->False,
    CellMargins->{{-1, -1}, {-1, -1}},
    PageBreakAbove->True,
    CellFrameMargins->{{1, 1}, {0, 0}}],
  
  Cell[StyleData["SlideShowNavigationBar", "Printout"],
    CellMargins->{{18, 4}, {4, 4}},
    LineSpacing->{1, 3},
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideShowSection"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{0, 0}, {10, 0}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Plain",
    FontColor->GrayLevel[1],
    Background->RGBColor[0.408011, 0.440726, 0.8]],
  
  Cell[StyleData["SlideShowSection", "SlideShow"],
    ShowCellBracket->False,
    PageBreakAbove->True],
  
  Cell[StyleData["SlideShowSection", "Printout"],
    CellMargins->{{18, 30}, {0, 30}},
    CellFrameMargins->5,
    FontSize->14]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SlideHyperlink"],
    StyleMenuListing->None,
    ButtonStyleMenuListing->Automatic,
    FontSize->26,
    FontColor->GrayLevel[0.400015],
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ #2]}]&),
    Active->True,
    ButtonMinHeight->0.85,
    ButtonMargins->0.5,
    ButtonNote->None}],
  
  Cell[StyleData["SlideHyperlink", "SlideShow"]],
  
  Cell[StyleData["SlideHyperlink", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    FontVariations->{"Underline"->False}]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Contents and Index", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContentsTitle"],
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{10, 4}, {0, 18}},
    CellGroupingRules->{"SectionGrouping", 60},
    LineSpacing->{1, 11},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->26,
    FontWeight->"Bold"],
  
  Cell[StyleData["ContentsTitle", "Printout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontSize->18],
  
  Cell[StyleData["ContentsTitle", "EnhancedPrintout"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontFamily->"Futura",
    FontSize->18],
  
  Cell[StyleData["ContentsTitle", "EnhancedPrintoutNonGray"],
    CellMargins->{{2, 0}, {0, 18}},
    PageBreakBelow->False,
    FontFamily->"Futura",
    FontSize->18]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContentsSection"],
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{35, 4}, {3, 18}},
    CellGroupingRules->{"SectionGrouping", 70},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["ContentsSection", "Printout"],
    CellMargins->{{20, 0}, {3, 18}},
    PageBreakBelow->False,
    FontSize->11],
  
  Cell[StyleData["ContentsSection", "EnhancedPrintout"],
    CellMargins->{{20, 0}, {3, 18}},
    PageBreakBelow->False,
    FontFamily->"Futura",
    FontSize->11],
  
  Cell[StyleData["ContentsSection", "EnhancedPrintoutNonGray"],
    CellMargins->{{20, 0}, {3, 18}},
    PageBreakBelow->False,
    FontFamily->"Futura",
    FontSize->11]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndexSection"],
    CellDingbat->"\[FilledSquare]",
    CellMargins->{{20, 4}, {5, 20}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->12,
    FontWeight->"Bold"],
  
  Cell[StyleData["IndexSection", "Printout"],
    CellMargins->{{12, 0}, {5, 20}},
    PageBreakBelow->False,
    FontSize->12]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Contents"],
    ShowGroupOpenCloseIcon->False,
    CellMargins->{{50, 4}, {0, 5}},
    CellGroupingRules->{"SectionGrouping", 90},
    StyleMenuListing->None],
  
  Cell[StyleData["Contents", "Printout"],
    CellMargins->{{40, 4}, {0, 5}},
    FontSize->11],
  
  Cell[StyleData["Contents", "EnhancedPrintout"],
    CellMargins->{{40, 5}, {0, 5}},
    FontFamily->"Palatino",
    FontSize->11],
  
  Cell[StyleData["Contents", "EnhancedPrintoutNonGray"],
    CellMargins->{{40, 5}, {0, 5}},
    FontFamily->"Palatino",
    FontSize->11]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Index"],
    CellMargins->{{21, 4}, {0, 0}},
    ParagraphIndent->-48,
    StyleMenuListing->None],
  
  Cell[StyleData["Index", "Printout"],
    CellMargins->{{13, 0}, {0, 0}},
    FontSize->10],
  
  Cell[StyleData["Index", "EnhancedPrintout"],
    CellMargins->{{13, 0}, {0, 0}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["Index", "EnhancedPrintoutNonGray"],
    CellMargins->{{13, 0}, {0, 0}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["IndexSubentry"],
    CellMargins->{{36, 4}, {0, 0}},
    ParagraphIndent->-48,
    StyleMenuListing->None],
  
  Cell[StyleData["IndexSubentry", "Printout"],
    CellMargins->{{24, 0}, {0, 0}},
    FontSize->10],
  
  Cell[StyleData["IndexSubentry", "EnhancedPrintout"],
    CellMargins->{{24, 0}, {0, 0}},
    FontFamily->"Palatino",
    FontSize->10],
  
  Cell[StyleData["IndexSubentry", "EnhancedPrintoutNonGray"],
    CellMargins->{{24, 0}, {0, 0}},
    FontFamily->"Palatino",
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Horizontal Lines", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["Line1"],
    CellFrame->{{0, 0}, {0, 0.5}},
    CellMargins->{{10, 4}, {-16, 9}},
    StyleMenuListing->None,
    FontSize->2],
  
  Cell[StyleData["Line1", "Printout"],
    CellMargins->{{2, 0}, {-16, 9}}]
  }, Closed]],
  
  Cell["\<\

The item above is horizontal 0.5 pt line\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ProgramTop"],
    CellFrame->{{0.5, 0.5}, {0, 0.5}},
    CellMargins->{{10, 4}, {-18, 18}},
    LineSpacing->{1, -4},
    StyleMenuListing->None,
    FontSize->4],
  
  Cell[StyleData["ProgramTop", "Printout"],
    CellMargins->{{2, 0}, {-18, 18}}]
  }, Closed]],
  
  Cell["\<\

The item above is a ProgramTop line
\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ProgramBottom"],
    CellFrame->{{0.5, 0.5}, {0.5, 0}},
    CellMargins->{{10, 4}, {-10, -2}},
    LineSpacing->{1, -4},
    StyleMenuListing->None,
    FontSize->4],
  
  Cell[StyleData["ProgramBottom", "Printout"],
    CellMargins->{{2, 0}, {-10, -2}}]
  }, Closed]],
  
  Cell["\<\

The item above is a ProgramBottom line
\
\>", "Text"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["SessionLabel"],
    CellFrame->{{0.5, 0}, {0, 0.5}},
    CellMargins->{{10, 4}, {-4, 18}},
    LineSpacing->{1, -3},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->9],
  
  Cell[StyleData["SessionLabel", "Printout"],
    CellMargins->{{2, 0}, {-4, 18}},
    FontSize->7]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Page Headers and Footers", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageHeader"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontSize->8,
    FontSlant->"Italic"],
  
  Cell[StyleData["PageHeader", "Printout"]],
  
  Cell[StyleData["PageHeader", "EnhancedPrintout"],
    FontFamily->"Futura"],
  
  Cell[StyleData["PageHeader", "EnhancedPrintoutNonGray"],
    FontFamily->"Futura"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageNumber"],
    CellMargins->{{0, 0}, {2, 0}},
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->8,
    FontWeight->"Bold"],
  
  Cell[StyleData["PageNumber", "Printout"]],
  
  Cell[StyleData["PageNumber", "EnhancedPrintout"],
    FontFamily->"Futura"],
  
  Cell[StyleData["PageNumber", "EnhancedPrintoutNonGray"],
    FontFamily->"Futura"]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["PageFooter"],
    StyleMenuListing->None,
    FontFamily->"Helvetica",
    FontSize->6],
  
  Cell[StyleData["PageFooter", "Printout"]],
  
  Cell[StyleData["PageFooter", "EnhancedPrintout"],
    FontFamily->"Futura"],
  
  Cell[StyleData["PageFooter", "EnhancedPrintoutNonGray"],
    FontFamily->"Futura"]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Automatic Styles", "Section"],
  
  Cell["\<\
The cells below define styles that are used to affect the display of certain \
types of objects in typeset expressions.  For example, \"UnmatchedBracket\" \
style defines how unmatched bracket, curly bracket, and parenthesis \
characters are displayed (typically by coloring them to make them stand out).\
\
\>", "Text"],
  
  Cell[StyleData["UnmatchedBracket"],
    StyleMenuListing->None]
  }, Closed]]
  }, Open  ]]
  }]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "ShiftReturn"->{
    Cell[147661, 1959, 144, 5, 39, "Section",
      CellTags->"ShiftReturn"]},
  "FunctionSyntax"->{
    Cell[151273, 2079, 64, 1, 38, "Section",
      CellTags->"FunctionSyntax"],
    Cell[154276, 2171, 75, 1, 38, "Section",
      CellTags->"FunctionSyntax"]},
  "NumericalValues"->{
    Cell[173276, 2527, 76, 1, 38, "Section",
      CellTags->"NumericalValues"],
    Cell[176851, 2632, 80, 1, 38, "Section",
      CellTags->"NumericalValues"],
    Cell[179919, 2726, 69, 1, 38, "Section",
      CellTags->"NumericalValues"],
    Cell[182997, 2820, 81, 1, 38, "Section",
      CellTags->"NumericalValues"]},
  "LastSlide"->{
    Cell[211845, 3448, 65, 1, 38, "Section",
      CellTags->"LastSlide"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"ShiftReturn", 374820, 9158},
  {"FunctionSyntax", 374921, 9161},
  {"NumericalValues", 375105, 9166},
  {"LastSlide", 375447, 9175}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 1652, 43, 20, "SlideShowNavigationBar"],

Cell[CellGroupData[{
Cell[3431, 98, 134, 4, 82, "Chapter"],
Cell[3568, 104, 300, 11, 32, "Text"],
Cell[3871, 117, 394, 13, 52, "Text"],
Cell[4268, 132, 222, 8, 32, "Text"],
Cell[4493, 142, 5037, 76, 38, "Text"],
Cell[9533, 220, 136448, 1690, 147, 136245, 1683, "GraphicsData", "Bitmap", \
"Text",
  Evaluatable->False],
Cell[145984, 1912, 1652, 43, 20, "SlideShowNavigationBar"],

Cell[CellGroupData[{
Cell[147661, 1959, 144, 5, 39, "Section",
  CellTags->"ShiftReturn"],
Cell[147808, 1966, 136, 3, 26, "Text"],
Cell[147947, 1971, 197, 6, 26, "Text"],
Cell[148147, 1979, 16, 0, 26, "Text"],
Cell[148166, 1981, 98, 5, 26, "Text"],
Cell[148267, 1988, 253, 7, 26, "Text"],
Cell[148523, 1997, 203, 5, 26, "Text"],
Cell[148729, 2004, 258, 7, 26, "Text"],
Cell[148990, 2013, 243, 4, 26, "Text"],
Cell[149236, 2019, 345, 10, 26, "Text"]
}, Open  ]],
Cell[149596, 2032, 1652, 43, 20, "SlideShowNavigationBar"],

Cell[CellGroupData[{
Cell[151273, 2079, 64, 1, 38, "Section",
  CellTags->"FunctionSyntax"],
Cell[151340, 2082, 143, 5, 26, "Text"],
Cell[151486, 2089, 81, 2, 46, "InputOnly"],
Cell[151570, 2093, 140, 3, 26, "Text"],

Cell[CellGroupData[{
Cell[151735, 2100, 400, 6, 113, "Input"],
Cell[152138, 2108, 313, 7, 56, "Output"]
}, Open  ]],
Cell[152466, 2118, 118, 3, 26, "Text"]
}, Open  ]],
Cell[152599, 2124, 1652, 43, 20, "SlideShowNavigationBar"],

Cell[CellGroupData[{
Cell[154276, 2171, 75, 1, 38, "Section",
  CellTags->"FunctionSyntax"],
Cell[154354, 2174, 293, 7, 26, "Text"],

Cell[CellGroupData[{
Cell[154672, 2185, 85, 2, 33, "Input"],
Cell[154760, 2189, 255, 6, 37, "Output"]
}, Open  ]],
Cell[155030, 2198, 201, 4, 26, "Text"],
Cell[155234, 2204, 16187, 268, 89, 16074, 264, "GraphicsData", "Bitmap", \
"Text",
  Evaluatable->False],
Cell[171424, 2474, 160, 3, 26, "Text"]
}, Open  ]],
Cell[171599, 2480, 1652, 43, 20, "SlideShowNavigationBar"],

Cell[CellGroupData[{
Cell[173276, 2527, 76, 1, 38, "Section",
  CellTags->"NumericalValues"],
Cell[173355, 2530, 269, 6, 43, "Text"],

Cell[CellGroupData[{
Cell[173649, 2540, 105, 2, 33, "Input"],
Cell[173757, 2544, 80, 2, 37, "Output"]
}, Open  ]],
Cell[173852, 2549, 139, 4, 26, "Text"],

Cell[CellGroupData[{
Cell[174016, 2557, 153, 3, 33, "Input"],
Cell[174172, 2562, 846, 13, 151, "Output"]
}, Open  ]],
Cell[175033, 2578, 126, 4, 26, "Text"]
}, Open  ]],
Cell[175174, 2585, 1652, 43, 20, "SlideShowNavigationBar"],

Cell[CellGroupData[{
Cell[176851, 2632, 80, 1, 38, "Section",
  CellTags->"NumericalValues"],
Cell[176934, 2635, 255, 5, 43, "Text"],

Cell[CellGroupData[{
Cell[177214, 2644, 232, 5, 53, "Input"],
Cell[177449, 2651, 218, 4, 56, "Output"]
}, Open  ]],
Cell[177682, 2658, 203, 5, 26, "Text"],

Cell[CellGroupData[{
Cell[177910, 2667, 100, 2, 33, "Input"],
Cell[178013, 2671, 202, 4, 37, "Output"]
}, Open  ]]
}, Open  ]],
Cell[178242, 2679, 1652, 43, 20, "SlideShowNavigationBar"],

Cell[CellGroupData[{
Cell[179919, 2726, 69, 1, 38, "Section",
  CellTags->"NumericalValues"],
Cell[179991, 2729, 264, 6, 43, "Text"],

Cell[CellGroupData[{
Cell[180280, 2739, 580, 11, 133, "Input"],
Cell[180863, 2752, 255, 6, 37, "Output"],
Cell[181121, 2760, 49, 1, 29, "Print"],
Cell[181173, 2763, 49, 1, 29, "Print"],
Cell[181225, 2766, 49, 1, 29, "Print"]
}, Open  ]],
Cell[181289, 2770, 16, 0, 26, "Text"]
}, Open  ]],
Cell[181320, 2773, 1652, 43, 20, "SlideShowNavigationBar"],

Cell[CellGroupData[{
Cell[182997, 2820, 81, 1, 38, "Section",
  CellTags->"NumericalValues"],
Cell[183081, 2823, 169, 3, 26, "Text"],
Cell[183253, 2828, 505, 9, 126, "InputOnly"],
Cell[183761, 2839, 154, 4, 26, "Text"]
}, Open  ]],
Cell[183930, 2846, 1652, 43, 20, "SlideShowNavigationBar"],

Cell[CellGroupData[{
Cell[185607, 2893, 50, 0, 38, "Section"],
Cell[185660, 2895, 143, 3, 26, "Text"],
Cell[185806, 2900, 726, 13, 246, "InputOnly"],
Cell[186535, 2915, 198, 4, 43, "Text"],
Cell[186736, 2921, 17745, 294, 89, 17632, 290, "GraphicsData", "Bitmap", \
"Text",
  Evaluatable->False]
}, Open  ]],
Cell[204496, 3218, 1652, 43, 20, "SlideShowNavigationBar"],

Cell[CellGroupData[{
Cell[206173, 3265, 33, 0, 38, "Section"],
Cell[206209, 3267, 601, 20, 27, "Text"],
Cell[206813, 3289, 133, 3, 26, "Text"],
Cell[206949, 3294, 106, 3, 26, "Text"]
}, Open  ]],
Cell[207070, 3300, 1652, 43, 20, "SlideShowNavigationBar"],

Cell[CellGroupData[{
Cell[208747, 3347, 45, 0, 38, "Section"],
Cell[208795, 3349, 154, 4, 26, "Text"],

Cell[CellGroupData[{
Cell[208974, 3357, 84, 1, 35, "Subsubsection"],
Cell[209061, 3360, 202, 4, 43, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[209300, 3369, 100, 1, 35, "Subsubsection"],
Cell[209403, 3372, 177, 3, 26, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[209617, 3380, 99, 1, 35, "Subsubsection"],
Cell[209719, 3383, 131, 3, 26, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[209887, 3391, 98, 1, 35, "Subsubsection"],
Cell[209988, 3394, 153, 3, 26, "Text"]
}, Open  ]]
}, Open  ]],
Cell[210168, 3401, 1652, 43, 20, "SlideShowNavigationBar"],

Cell[CellGroupData[{
Cell[211845, 3448, 65, 1, 38, "Section",
  CellTags->"LastSlide"],
Cell[211913, 3451, 156, 3, 26, "Text"],

Cell[CellGroupData[{
Cell[212094, 3458, 88, 1, 35, "Subsubsection"],
Cell[212185, 3461, 334, 8, 43, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[212556, 3474, 86, 1, 35, "Subsubsection"],
Cell[212645, 3477, 266, 7, 26, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[212948, 3489, 83, 1, 35, "Subsubsection"],
Cell[213034, 3492, 306, 8, 26, "Text"],
Cell[213343, 3502, 17, 0, 26, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

