(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1882302,      37751]*)
(*NotebookOutlinePosition[   2025010,      40907]*)
(*  CellTagsIndexPosition[   2021768,      40816]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["GUIKit`", "Title"],

Cell["Introduction", "Chapter",
  PageBreakAbove->False,
  CellTags->"Introduction:Tag"],

Cell[CellGroupData[{

Cell["Introduction", "Section",
  CellTags->"Introduction"],

Cell[TextData[{
  "The Java toolkit ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " introduced ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " users to a powerful new technology for ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programs to access the functionality of Java classes and, in particular, \
the extensive class library of Java graphical user interfaces. ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " builds on this ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " foundation by providing a higher-level ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression syntax for defining a graphical user interface along with a \
runtime environment for managing and deploying these reusable definitions."
}], "Text",
  CellTags->"Introduction"],

Cell[TextData[{
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " simplifies the construction and layout of common user interface \
programming and eliminates the need to write code using the underlying Java \
programming language. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " users will find that ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " allows them to quickly define interfaces as ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions and to program the logic of these user interfaces with \
familiar ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " programming language constructs."
}], "Text",
  CellTags->"Introduction"],

Cell[TextData[{
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " also expands on the set of tools available to existing ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " and Java programmers by providing a reusable deployment model that easily \
integrates interface definitions into their existing ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " add-ons and to develop a library of reusable ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "-enhanced user interface widgets."
}], "Text",
  CellTags->"Introduction"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Quick Tour", "Section",
  CellTags->"QuickTour"],

Cell[TextData[{
  "One powerful feature of ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " is to make it easy for users to load and execute prepackaged custom user \
interfaces whenever they need them."
}], "Text",
  CellTags->"QuickTour"],

Cell[TextData[{
  "Load the ",
  StyleBox["GUIKit`", "MR",
    FontVariations->{"CompatibilityType"->0}],
  " package before calling any ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " functions."
}], "Text",
  CellTags->"QuickTour"],

Cell[BoxData[
    \(\(Needs["\<GUIKit`\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"QuickTour"],

Cell[TextData[{
  "Here we execute an existing ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " definition and, after closing the dialog, the current values of the \
calculations are returned as results back to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"QuickTour"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIRunModal["\<Wolfram/Example/Calculator\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"QuickTour"],

Cell[BoxData[
    \({"FirstArgumentField" \[Rule] 45.6`, "SecondArgumentField" \[Rule] 489, 
      "SumField" \[Rule] 534.6`, "DifferenceField" \[Rule] \(-443.4`\), 
      "ProductField" \[Rule] 22298.4`, 
      "QuotientField" \[Rule] 0.0932515337423313`}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"QuickTour"]
}, Open  ]],

Cell["\<\
Here is a screen shot of what the previous interface would look like on a \
typical platform.\
\>", "Text",
  CellTags->"QuickTour"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>0000eB000`400?l0
0000o`00003oo`1VIWh?06IVOP0000<0IVIn0?_lo@3ko?d0o`3ko?d;0?_l
o@40IVIn00000`1VIWh0nocm0:RY^`3o0:RY^`X0Z:Vk0@3ko?d106IVOP00
00<0IVIn0?_lo@2XZK/0o`1VIWh906IVOP40Z:Vk0@3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVInF`3Pgn>[0:F//P0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0
h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[
i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK
0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[
jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
0P3Pgn<3000000040>3Oh`000000h=oS0>3Oh`80000000@0h=oS0000003P
gn<0h=oS0`0000020>3Oh`80000000@0h=oS0000003Pgn<0h=oS0`000002
0>3Oh`060000003Pgn<0h=oS0>3Oh`000000h=oS0P0000000`3Pgn<00000
0>3Oh`0a0>3Oh`030:F//P3[jn@0jn_T0400jn_T0`0000050>_[i0050000
003[jn@0jn_T0>_[i00000000P3[jn@00`000000jn_T0>_[i0030>_[i0<0
0000103[jn@00`000000jn_T0>_[i0020>_[i0<000000`3[jn@3000000<0
jn_T00<000000>_[i03[jn@00`3[jn@3000000D0jn_T00<000000>_[i03[
jn@00`3[jn@010000000jn_T0>_[i03[jn@300000080jn_T1@0000040>_[
i0030000003[jn@0jn_T00D000000P3[jn@00`000000jn_T0>_[i0070>_[
i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001P1VIWh0nocm0:RY^`1VIWh0
h=oS000000<0h=oS00@000000>3Oh`3Pgn<000000P3Pgn<2000000030>3O
h`000000h=oS0080h=oS00<000000>3Oh`0000000P3Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`000000
=@3Pgn<00`2U[;80jn_T0>_[i00o0>_[i0050000003[jn@0jn_T0>_[i000
0000103[jn@00`000000jn_T0>_[i0040>_[i0030000003[jn@0jn_T0080
jn_T00D000000>_[i03[jn@0jn_T000000030>_[i0050000003[jn@0jn_T
0>_[i00000000`3[jn@00`000000jn_T000000030>_[i0040000003[jn@0
jn_T000000@0jn_T00D000000>_[i03[jn@0jn_T000000040>_[i0030000
003[jn@0jn_T00<0jn_T00@000000>_[i03[jn@000000`3[jn@010000000
jn_T0>_[i00000070>_[i0050000003[jn@0jn_T0>_[i00000001@3[jn@0
0`000000jn_T0>_[i0070>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh000000080h=oS0P000000103Pgn<000000>3O
h`0000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`000000
0P3Pgn<00`000000h=oS000000050>3Oh`070000003Pgn<0h=oS0>3Oh`00
0000h=oS0000000e0>3Oh`030:F//P3[jn@0jn_T03/0jn_T0`0000050>_[
i0030000003[jn@0000000@000001@3[jn@00`000000jn_T0>_[i0020>_[
i0050000003[jn@0jn_T0>_[i00000000`3[jn@00`000000jn_T0>_[i005
0>_[i0030000003[jn@0jn_T00<0jn_T00@000000>_[i03[jn@00000103[
jn@01P000000jn_T0>_[i03[jn@000000>_[i0D0000000<0jn_T00000000
00000`0000000`3[jn@000000>_[i0020>_[i0050000003[jn@0jn_T0>_[
i00000000`3[jn@5000000<0jn_T00<000000>_[i03[jn@00P3[jn@00`00
0000jn_T0>_[i0070>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0000000D0h=oS00<000000>3Oh`0000000`3Pgn<0
0`000000h=oS000000030>3Oh`030000003Pgn<000000080h=oS00<00000
0>3Oh`000000100000000`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<0
000003D0h=oS00<0YJbb0>_[i03[jn@0@`3[jn@00`000000jn_T00000002
0>_[i0030000003[jn@0jn_T00D0jn_T00D000000>_[i03[jn@0jn_T0000
00030>_[i0050000003[jn@0jn_T0>_[i00000001`3[jn@00`000000jn_T
0>_[i0030>_[i0050000003[jn@0jn_T0>_[i00000000`3[jn@01`000000
jn_T0>_[i03[jn@000000>_[i00000000P3[jn@010000000jn_T0>_[i000
00020>_[i0040000003[jn@0jn_T000000<0jn_T00<000000>_[i03[jn@0
0P3[jn@010000000jn_T0>_[i00000020>_[i0030000003[jn@0jn_T00<0
jn_T00<000000>_[i03[jn@00P3[jn@00`000000jn_T0>_[i0060>_[i004
0:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh00000
00D0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<000000080h=oS00<000000>3Oh`0000000`3Pgn<01000
0000h=oS0000000000020>3Oh`030000003Pgn<0000003D0h=oS00<0YJbb
0>_[i03[jn@0@@3[jn@2000000<0jn_T00<000000>_[i00000001`3[jn@0
0`000000jn_T0>_[i0020>_[i0<00000103[jn@010000000jn_T0>_[i03[
jn@4000000@0jn_T0P0000040>_[i0050000003[jn@0jn_T0>_[i0000000
0`3[jn@01P000000jn_T0>_[i0000000jn_T000000<0jn_T00<000000>_[
i00000000`3[jn@3000000H0jn_T00H000000>_[i03[jn@000000>_[i000
00060>_[i0050000003[jn@0jn_T0>_[i0000000203[jn@0102U[;80IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000050>3Oh`03
0000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<00`0000001P3Pgn<0
0000000000000000h=oS00000080h=oS0`0000020>3Oh`050000003Pgn<0
00000000003Pgn<00`0000000`3Pgn<000000>3Oh`0a0>3Oh`030:F//P3[
jn@0jn_T04<0jn_T00H000000>_[i03[jn@000000>_[i00000080>_[i004
0000003[jn@0jn_T000000<0jn_T00D000000>_[i0000000jn_T00000003
0>_[i0030000003[jn@0jn_T00L0jn_T00<000000>_[i03[jn@00P3[jn@0
10000000jn_T0>_[i00000030>_[i0060000003[jn@0jn_T0000003[jn@0
00000`3[jn@00`000000jn_T000000020>_[i0050000003[jn@0jn_T0>_[
i00000001@3[jn@01P000000jn_T0>_[i0000000jn_T000000H0jn_T00<0
00000>_[i03[jn@00P3[jn@00`000000jn_T0>_[i0050>_[i0040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001P1VIWh0nocm0:RY^`1VIWh0h=oS000000<0
h=oS00<000000>3Oh`3Pgn<0303Pgn<00`000000h=oS0>3Oh`0>0>3Oh`03
0000003Pgn<0h=oS03<0h=oS00<0YJbb0>_[i03[jn@0?`3[jn@01@000000
jn_T0>_[i03[jn@0000000<0jn_T0P0000080>_[i0040000003[jn@0jn_T
000000<0jn_T00<000000>_[i03[jn@00P0000040>_[i0030000003[jn@0
jn_T0080jn_T00D000000>_[i03[jn@0jn_T000000040>_[i0040000003[
jn@0jn_T000000<0jn_T00@000000>_[i03[jn@0jn_T0P0000040>_[i080
00000P3[jn@01`000000jn_T0>_[i03[jn@000000>_[i00000000`3[jn@0
10000000jn_T0>_[i03[jn@200000080jn_T00D000000>_[i03[jn@0jn_T
000000040>_[i0030000003[jn@0jn_T00D0jn_T00@0YJbb06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS0`00000?0>3Oh`04
0000003Pgn<0h=oS000000d0h=oS00<000000>3Oh`3Pgn<0<`3Pgn<00`2U
[;80jn_T0>_[i0100>_[i0<000001@3[jn@00`000000jn_T0>_[i0030>_[
i0D000000P3[jn@3000000@0jn_T00<000000>_[i03[jn@00P3[jn@40000
0080jn_T0`0000020>_[i0D000000P3[jn@3000000D0jn_T00<000000>_[
i03[jn@00`3[jn@010000000jn_T0>_[i03[jn@3000000<0jn_T0`000005
0>_[i0040000003[jn@0jn_T0>_[i0<000000P3[jn@5000000H0jn_T00@0
YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS
00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i004
0:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3O
h`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3P
gn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWiK0>3Ohj/0YJbb00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS
Z`2U[;800`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
F`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0
jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W
0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000001@3Pgn<00`000000h=oS
0>3Oh`020>3Oh`<000000`3Pgn<2000000040>3Oh`000000h=oS0>3Oh`80
000000@0h=oS0000003Pgn<0h=oS0`0000020>3Oh`80000000<0h=oS0000
003Pgn<0=03Pgn<00`2U[;80jn_T0>_[i0160>_[i0<000000`3[jn@30000
00<0jn_T00<000000>_[i0000000100000020>_[i0<000000`3[jn@30000
00<0jn_T0`0000020>_[i0D00000103[jn@010000000jn_T0>_[i03[jn@3
000000<0jn_T0`0000030>_[i0<000000`3[jn@3000000@0jn_T00<00000
0>_[i03[jn@00P3[jn@3000000<0jn_T0`0000070>_[i0040:F//P1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000D0h=oS00D0
00000>3Oh`3Pgn<0h=oS000000030>3Oh`030000003Pgn<000000080h=oS
0P000000103Pgn<000000>3Oh`3Pgn<2000000030>3Oh`000000h=oS0080
h=oS00<000000>3Oh`000000>03Pgn<00`2U[;80jn_T0>_[i0150>_[i007
0000003[jn@0jn_T0>_[i0000000jn_T000000030>_[i0030000003[jn@0
jn_T00<0jn_T00<000000>_[i03[jn@00P3[jn@01`000000jn_T0>_[i03[
jn@000000>_[i00000000`3[jn@00`000000jn_T000000030>_[i0040000
003[jn@0jn_T000000L0jn_T00@000000>_[i03[jn@000000`3[jn@00`00
0000jn_T000000030>_[i0030000003[jn@0000000<0jn_T00<000000>_[
i00000000`3[jn@01@000000jn_T0>_[i03[jn@0000000<0jn_T00L00000
0>_[i03[jn@0jn_T0000003[jn@0000000<0jn_T00<000000>_[i03[jn@0
103[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn000000050>3Oh`050000003Pgn<0h=oS0>3Oh`0000000`3Pgn<00`00
0000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3O
h`0000001@3Pgn<00`000000h=oS0>3Oh`0f0>3Oh`030:F//P3[jn@0jn_T
0440jn_T0`0000050>_[i0030000003[jn@0jn_T00<0jn_T00<000000>_[
i03[jn@0103[jn@00`000000jn_T0>_[i0050>_[i0030000003[jn@00000
00<0jn_T00<000000>_[i00000000`3[jn@01@000000jn_T0>_[i03[jn@0
000000<0jn_T1@0000000`3[jn@000000>_[i0020>_[i0030000003[jn@0
000000<0jn_T00<000000>_[i00000000`3[jn@00`000000jn_T00000003
0>_[i0050000003[jn@0jn_T0>_[i00000001`3[jn@00`000000jn_T0>_[
i0030>_[i0030000003[jn@0jn_T00@0jn_T00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@000000P3Pgn<01@000000h=oS
0>3Oh`3Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000
h=oS000000030>3Oh`030000003Pgn<0000000D0h=oS00<000000>3Oh`3P
gn<0=P3Pgn<00`2U[;80jn_T0>_[i0190>_[i0030000003[jn@0jn_T00<0
jn_T00<000000>_[i03[jn@01@3[jn@00`000000jn_T0>_[i0040>_[i003
0000003[jn@0000000<0jn_T00<000000>_[i00000000`3[jn@00`000000
jn_T0>_[i0020>_[i0040000003[jn@0jn_T00000080jn_T00@000000>_[
i03[jn@000000`3[jn@00`000000jn_T000000030>_[i0030000003[jn@0
000000<0jn_T00<000000>_[i00000000`3[jn@01@000000jn_T0>_[i03[
jn@0000000L0jn_T00<000000>_[i03[jn@00`3[jn@00`000000jn_T0>_[
i0040>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0000000<0h=oS00@000000>3Oh`00000000000P3Pgn<01`000000
h=oS0>3Oh`3Pgn<000000>3Oh`0000000P3Pgn<2000000030>3Oh`000000
h=oS0080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0000000h
0>3Oh`030:F//P3[jn@0jn_T04L0jn_T0P0000040>_[i08000002@3[jn@0
10000000jn_T0>_[i03[jn@200000080jn_T100000020>_[i0050000003[
jn@0jn_T0>_[i00000001@3[jn@01P000000jn_T0>_[i0000000jn_T0000
0080jn_T00L000000>_[i03[jn@0jn_T0000003[jn@0000000<0jn_T00<0
00000>_[i00000000`3[jn@00`000000jn_T00000003000000@0jn_T00<0
00000>_[i03[jn@00`3[jn@2000000@0jn_T0P0000070>_[i0040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000<0h=oS
00D000000>3Oh`000000h=oS000000020>3Oh`<000000`3Pgn<200000004
0>3Oh`000000h=oS000000<0h=oS00<000000>3Oh`3Pgn<00`0000001P3P
gn<00000000000000000h=oS000003D0h=oS00<0YJbb0>_[i03[jn@0B@3[
jn@00`000000jn_T0>_[i0030>_[i0030000003[jn@0jn_T00H0jn_T00<0
00000>_[i03[jn@00`3[jn@00`000000jn_T000000050>_[i0050000003[
jn@0jn_T0>_[i00000001@3[jn@01P000000jn_T0>_[i0000000jn_T0000
0080jn_T00L000000>_[i03[jn@0jn_T0000003[jn@0000000<0jn_T00<0
00000>_[i00000000`3[jn@00`000000jn_T000000050>_[i0030000003[
jn@0000000L0jn_T00<000000>_[i03[jn@00`3[jn@00`000000jn_T0>_[
i0040>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0000000<0h=oS00<000000>3Oh`3Pgn<03@3Pgn<00`000000h=oS
0>3Oh`0;0>3Oh`030000003Pgn<0h=oS03H0h=oS00<0YJbb0>_[i03[jn@0
A@3[jn@01`000000jn_T0>_[i03[jn@000000>_[i00000000`3[jn@00`00
0000jn_T0>_[i0020>_[i0070000003[jn@0jn_T0>_[i0000000jn_T0000
00030>_[i0030000003[jn@0000000<0jn_T00<000000>_[i00000000`3[
jn@00`000000jn_T000000030>_[i0040000003[jn@0jn_T0>_[i0800000
0P3[jn@01`000000jn_T0>_[i03[jn@000000>_[i00000000`3[jn@00`00
0000jn_T000000030>_[i0030000003[jn@0000000<0jn_T00<000000>_[
i03[jn@00P0000030>_[i0070000003[jn@0jn_T0>_[i0000000jn_T0000
00030>_[i0030000003[jn@0jn_T00@0jn_T00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@00000403Pgn<00`000000h=oS
0>3Oh`0;0>3Oh`030000003Pgn<0h=oS03H0h=oS00<0YJbb0>_[i03[jn@0
AP3[jn@3000000<0jn_T0`0000060>_[i0<000000`3[jn@3000000<0jn_T
0`0000030>_[i0<000000`3[jn@3000000D0jn_T00@000000>_[i03[jn@0
jn_T0`0000030>_[i0<000000`3[jn@3000000<0jn_T0`0000040>_[i003
0000003[jn@0jn_T0080jn_T0`0000030>_[i0<000001`3[jn@0102U[;80
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U
[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101V
IWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb
06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0
YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F/
/P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`03
0:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOU/0h=oSZ`2U[;800`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn>[0:F/
/P0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3O
h`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3P
gn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0
h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn100000030>3Oh`040000003Pgn<0h=oS
000000<0h=oS00@000000>3Oh`3Pgn<0h=oS0`0000020>3Oh`030000003P
gn<0h=oS0080h=oS0`0000020>3Oh`050000003Pgn<0h=oS0>3Oh`000000
0P3Pgn<3000000<0h=oS0`0000020>3Oh`030000003Pgn<0h=oS02D0h=oS
00<0YJbb0>_[i03[jn@0AP3[jn@3000000D0jn_T00D000000>_[i03[jn@0
jn_T000000020>_[i0<000000`3[jn@00`000000jn_T0>_[i0030>_[i003
0000003[jn@0jn_T00<0jn_T0`0000030>_[i0<000000`3[jn@3000000@0
jn_T00<000000>_[i03[jn@00`3[jn@00`000000jn_T0>_[i0020>_[i003
0000003[jn@0jn_T00<0jn_T0`0000030>_[i0<000000`3[jn@3000000@0
jn_T00<000000>_[i03[jn@01P3[jn@0102U[;80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn000000030>3Oh`040000003Pgn<0h=oS
00000080h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3Oh`070000003P
gn<0h=oS0>3Oh`000000h=oS000000030>3Oh`070000003Pgn<0h=oS0>3O
h`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<00000
0>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`0W0>3Oh`030:F//P3[jn@0
jn_T04D0jn_T00D000000>_[i03[jn@0jn_T000000040>_[i0030000003[
jn@0jn_T00<0jn_T00D000000>_[i03[jn@0jn_T000000020>_[i0030000
003[jn@0jn_T00<0jn_T00<000000>_[i03[jn@00P3[jn@01`000000jn_T
0>_[i03[jn@000000>_[i00000000`3[jn@00`000000jn_T000000030>_[
i0050000003[jn@0jn_T0>_[i00000001@3[jn@00`000000jn_T0>_[i002
0>_[i0030000003[jn@0jn_T0080jn_T00L000000>_[i03[jn@0jn_T0000
003[jn@0000000<0jn_T00<000000>_[i00000000`3[jn@01@000000jn_T
0>_[i03[jn@0000000P0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP000000103Pgn<00`000000h=oS000000020>3O
h`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<00`000000h=oS0>3Oh`03
0>3Oh`050000003Pgn<0h=oS0>3Oh`0000001@3Pgn<01`000000h=oS0>3O
h`3Pgn<000000>3Oh`0000001@3Pgn<00`000000h=oS0>3Oh`0[0>3Oh`03
0:F//P3[jn@0jn_T04T0jn_T00<000000>_[i0000000100000080>_[i004
0000003[jn@0jn_T000000D0jn_T00<000000>_[i03[jn@01P3[jn@00`00
0000jn_T0>_[i0030>_[i0030000003[jn@0000000<0jn_T00D000000>_[
i03[jn@0jn_T000000050>_[i0030000003[jn@0jn_T0080jn_T00<00000
0>_[i03[jn@00P3[jn@01`000000jn_T0>_[i03[jn@000000>_[i0000000
0`3[jn@00`000000jn_T0>_[i0030>_[i0050000003[jn@0jn_T0>_[i000
0000203[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn000000040>3Oh`030000003Pgn<000000080h=oS00D000000>3O
h`3Pgn<0h=oS000000020>3Oh`D0000000<0h=oS0000003Pgn<00P3Pgn<5
000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`0000001@3Pgn<5
000002T0h=oS00<0YJbb0>_[i03[jn@0B@3[jn@00`000000jn_T00000002
0>_[i0030000003[jn@0jn_T00@0jn_T100000030>_[i0030000003[jn@0
jn_T00<0jn_T00<000000>_[i03[jn@01@3[jn@00`000000jn_T0>_[i003
0>_[i0030000003[jn@0000000<0jn_T00D000000>_[i03[jn@0jn_T0000
00050>_[i0030000003[jn@0jn_T00<0jn_T00D000000>_[i03[jn@0jn_T
000000030>_[i0030000003[jn@0000000<0jn_T00<000000>_[i03[jn@0
0`3[jn@01@000000jn_T0>_[i03[jn@0000000P0jn_T00@0YJbb06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000103Pgn<00`00
0000h=oS000000020>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<0
1P000000h=oS0>3Oh`3Pgn<000000>3Oh`8000000P3Pgn<01P000000h=oS
0>3Oh`3Pgn<000000>3Oh`8000000P3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<09`3Pgn<00`2U
[;80jn_T0>_[i0170>_[i08000000`3[jn@00`000000jn_T000000050>_[
i0050000003[jn@0jn_T0>_[i00000000`3[jn@00`000000jn_T0>_[i003
0>_[i0040000003[jn@0jn_T0>_[i0@00000103[jn@200000080jn_T00D0
00000>_[i03[jn@0jn_T000000030>_[i0030000003[jn@0jn_T00<0jn_T
00<000000>_[i03[jn@00`3[jn@010000000jn_T0>_[i03[jn@400000080
jn_T100000020>_[i0@00000103[jn@00`000000jn_T0>_[i0060>_[i004
0:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh00000
00@0h=oS00@000000>3Oh`000000h=oS0`000000103Pgn<0000000000000
00020>3Oh`<000000P3Pgn<00`000000h=oS000000020>3Oh`<000000P3P
gn<010000000h=oS0000000000030>3Oh`<000000`3Pgn<300000080h=oS
00<000000>3Oh`3Pgn<09@3Pgn<00`2U[;80jn_T0>_[i0190>_[i0060000
003[jn@0jn_T0000003[jn@000001@3[jn@01@000000jn_T0>_[i03[jn@0
000000@0jn_T00<000000>_[i03[jn@00`3[jn@010000000jn_T0>_[i000
00090>_[i0030000003[jn@0000000<0jn_T00D000000>_[i0000000jn_T
000000030>_[i0030000003[jn@0000000H0jn_T00@000000>_[i03[jn@0
00001@3[jn@00`000000jn_T0>_[i0030>_[i0030000003[jn@0jn_T00<0
jn_T00<000000>_[i0000000203[jn@0102U[;80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn000000030>3Oh`030000003Pgn<0h=oS
00<0h=oS00D000000>3Oh`3Pgn<0h=oS0000001<0>3Oh`030:F//P3[jn@0
jn_T04D0jn_T00D000000>_[i03[jn@0jn_T000000030>_[i08000001@3[
jn@01@000000jn_T0>_[i03[jn@0000000@0jn_T00<000000>_[i03[jn@0
0`3[jn@01@000000jn_T0>_[i03[jn@0000000@0jn_T00L000000>_[i03[
jn@0jn_T0000003[jn@0000000<0jn_T00<000000>_[i03[jn@00P000004
0>_[i08000001P3[jn@010000000jn_T0>_[i00000030>_[i0030000003[
jn@0000000<0jn_T00@000000>_[i03[jn@000001@3[jn@2000000P0jn_T
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0
00000`3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00<000000>3O
h`3Pgn<0B@3Pgn<00`2U[;80jn_T0>_[i0160>_[i0<000001@3[jn@00`00
0000jn_T0>_[i0040>_[i0<000000P3[jn@5000000030>_[i00000000000
00<000000P3[jn@400000080jn_T0`0000030>_[i0<00000103[jn@00`00
0000jn_T0>_[i0030>_[i0040000003[jn@0jn_T0>_[i0D000000P3[jn@3
000000<0jn_T0`0000030>_[i0@000000`3[jn@00`000000jn_T0>_[i006
0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0
Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T
0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3k
o?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn>[0:F//P0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3P
gn<70>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWiK0>3Ohj/0YJbb00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY
^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T
0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm
0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2X
ZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[
i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0h=oS00@000000`3P
gn<2000000040>3Oh`000000h=oS00000080h=oS00H000000>3Oh`3Pgn<0
00000>3Oh`0000150>3Oh`030:F//P3[jn@0jn_T04H0jn_T0`0000030>_[
i0<000000`3[jn@00`000000jn_T0>_[i00300000080jn_T1@0000000`3[
jn@0000000000003000000@0jn_T00@000000>_[i03[jn@0jn_T0`000003
0>_[i0<000000`3[jn@3000000<0jn_T0`0000020>_[i0D000000P3[jn@3
000000<0jn_T0`0000050>_[i0040000003[jn@0jn_T0>_[i0<000001`3[
jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
000000040>3Oh`030000003Pgn<000000080h=oS0P0000001@3Pgn<00000
0>3Oh`3Pgn<000000080h=oS00<000000>3Oh`3Pgn<0A@3Pgn<00`2U[;80
jn_T0>_[i0150>_[i0070000003[jn@0jn_T0>_[i0000000jn_T00000003
0>_[i0030000003[jn@0jn_T0080jn_T00D000000>_[i03[jn@0jn_T0000
00020>_[i0030000003[jn@0jn_T00<0jn_T00<000000>_[i03[jn@01@3[
jn@010000000jn_T0>_[i00000030>_[i0030000003[jn@0000000<0jn_T
00<000000>_[i00000000`3[jn@00`000000jn_T000000030>_[i0040000
003[jn@0jn_T000000@0jn_T00L000000>_[i03[jn@0jn_T0000003[jn@0
000000<0jn_T00<000000>_[i03[jn@00P3[jn@010000000jn_T0>_[i000
00030>_[i0030000003[jn@0jn_T00@0jn_T00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPD0h=oS00<000000>3Oh`000000
0`3Pgn<00`000000h=oS000000020>3Oh`040000003Pgn<0h=oS000004L0
h=oS00<0YJbb0>_[i03[jn@0B@3[jn@00`000000jn_T0>_[i0030>_[i003
0000003[jn@0jn_T0080jn_T00D000000>_[i03[jn@0jn_T000000030>_[
i0030000003[jn@0jn_T00<0jn_T00@000000>_[i03[jn@0jn_T1@000000
0`3[jn@000000>_[i0020>_[i0030000003[jn@0jn_T00<0jn_T00<00000
0>_[i00000000`3[jn@00`000000jn_T000000030>_[i0050000003[jn@0
jn_T0>_[i00000001`3[jn@00`000000jn_T0>_[i0030>_[i0030000003[
jn@0000000@000001@3[jn@00`000000jn_T0>_[i0040>_[i0040:F//P1V
IWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWh30>3Oh`800000
0P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000P3Pgn<01000
0000h=oS0>3Oh`0000170>3Oh`030:F//P3[jn@0jn_T04T0jn_T00<00000
0>_[i03[jn@00`3[jn@00`000000jn_T0>_[i0020>_[i0050000003[jn@0
jn_T0>_[i0000000103[jn@00`000000jn_T0>_[i0030>_[i0040000003[
jn@0jn_T00000080jn_T00@000000>_[i03[jn@000000`3[jn@00`000000
jn_T0>_[i004000000030>_[i0000000jn_T0080jn_T00<000000>_[i000
00000`3[jn@00`000000jn_T0>_[i0020>_[i0030000003[jn@0jn_T00@0
jn_T00<000000>_[i03[jn@00`3[jn@00`000000jn_T000000020>_[i004
0000003[jn@0jn_T0>_[i0@000001P3[jn@0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0>3Oh`02000000@0h=oS00H00000
0>3Oh`3Pgn<0h=oS0000003Pgn<2000000050>3Oh`00000000000>3Oh`00
0000A`3Pgn<00`2U[;80jn_T0>_[i0170>_[i0800000103[jn@2000000D0
jn_T00D000000>_[i03[jn@0jn_T000000050>_[i0030000003[jn@0jn_T
00<0jn_T00H000000>_[i03[jn@000000>_[i00000020>_[i0@000000P3[
jn@01@000000jn_T0>_[i03[jn@000000080jn_T0`0000030>_[i0<00000
1P3[jn@010000000jn_T0>_[i03[jn@2000000@0jn_T0P0000030>_[i003
0000003[jn@000000080jn_T00D000000>_[i03[jn@0jn_T000000060>_[
i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
000000H0h=oS00T000000>3Oh`3Pgn<0h=oS0000003Pgn<000000>3Oh`00
00000P3Pgn<010000000h=oS0>3Oh`0000150>3Oh`030:F//P3[jn@0jn_T
04T0jn_T00<000000>_[i03[jn@00`3[jn@00`000000jn_T0>_[i0020>_[
i0050000003[jn@0jn_T0>_[i00000001@3[jn@00`000000jn_T0>_[i003
0>_[i0060000003[jn@0jn_T0000003[jn@000000P3[jn@00`000000jn_T
0>_[i0030>_[i0070000003[jn@0jn_T0>_[i0000000jn_T000000030>_[
i0030000003[jn@0000000<0jn_T00<000000>_[i03[jn@00`3[jn@00`00
0000jn_T0>_[i0030>_[i0030000003[jn@0jn_T00<0jn_T00H000000>_[
i03[jn@000000>_[i00000020>_[i0050000003[jn@0jn_T0>_[i0000000
1P3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn000000040>3Oh`030000003Pgn<0h=oS05<0h=oS00<0YJbb0>_[i03[
jn@0A@3[jn@01`000000jn_T0>_[i03[jn@000000>_[i00000000`3[jn@0
0`000000jn_T0>_[i0020>_[i0070000003[jn@0jn_T0>_[i0000000jn_T
000000030>_[i0030000003[jn@0000000<0jn_T00@000000>_[i03[jn@0
jn_T0P0000020>_[i0070000003[jn@0jn_T0>_[i0000000jn_T00000003
0>_[i0030000003[jn@0000000<0jn_T00<000000>_[i00000000`3[jn@0
0`000000jn_T000000030>_[i0030000003[jn@0000000<0jn_T00<00000
0>_[i00000000`3[jn@010000000jn_T0>_[i03[jn@200000080jn_T00D0
00000>_[i03[jn@0jn_T000000060>_[i0040:F//P1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0h=oS00@00000EP3Pgn<00`2U[;80
jn_T0>_[i0160>_[i0<000000`3[jn@3000000H0jn_T0`0000030>_[i0<0
00000`3[jn@3000000D0jn_T00@000000>_[i03[jn@0jn_T0`0000030>_[
i0<000000`3[jn@3000000<0jn_T0`0000030>_[i0<000000`3[jn@30000
00<0jn_T0`0000050>_[i0040000003[jn@0jn_T0>_[i0<000001`3[jn@0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3P
gn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0
h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[
i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK
0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oSZ`2U[;800`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3P
gn<70>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWko0>3Oh`L0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVO_l0h=oS1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn000000040>3Oh`030000003Pgn<0h=oS00<000000`3P
gn<3000000<0h=oS0P0000001@3Pgn<000000>3Oh`000000h=oS00800000
0P3Pgn<300000080h=oS00<000000>3Oh`3Pgn<0g`3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000030>3Oh`040000
003Pgn<0h=oS000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000
h=oS000000020>3Oh`80000000@0h=oS0000003Pgn<000000P3Pgn<01@00
0000h=oS0>3Oh`3Pgn<000000><0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP0000000`3Pgn<010000000h=oS0>3Oh`00
00080>3Oh`040000003Pgn<0h=oS000000<0h=oS00D000000>3Oh`000000
h=oS000000050>3Oh`030000003Pgn<0h=oS0>80h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000000P3Pgn<010000000
h=oS0>3Oh`3Pgn<500000080h=oS0P0000030>3Oh`090000003Pgn<0h=oS
0>3Oh`000000h=oS0000003Pgn<0000000<0h=oS0P00003U0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh500000080h=oS
00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3O
h`0000000`3Pgn<01@000000h=oS0000003Pgn<000000080h=oS00D00000
0>3Oh`3Pgn<0h=oS0000003S0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0000000@0h=oS00<000000>3Oh`3Pgn<00`00
00030>3Oh`<000000P3Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`@0
00000P3Pgn<300000080h=oS00<000000>3Oh`3Pgn<0g`3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000040>3Oh`03
0000003Pgn<0h=oS0140h=oS00<000000>3Oh`000000jP3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@00000D0>3Oh`03
0000003Pgn<000000>X0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVO_l0h=oS1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0
h=oS1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn^`3Pgn<01@3Qh>@0i^GX0>c[kP3`l?80l_;d0240lo?d7P3hmoP20??c
m0080??cm@3dm?D0mOGf0?Ccm@3Ui>P0IVIn0:RY^`3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn^`3Pgn<0103Ng=l0i>;P07^G[@0UEhE3000lM007
01M=OP1[RjH0l_7^0?;al`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn^`3Pgn<0103Jf=T0IXFQ04YaT`2b_L=30<K5e`070<36a@18
KY00JXZT0>o_l@1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn^`3Pgn<00`3HeMH05den0;o7bP150<K5e`060;Jm_@0GCGh0jn[]06IV
OP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[/0h=oS00<0fMGE
000lM03oool0A@3=c=l01P3oool003ad0>SWjP1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`030=WEe@00?7@0oooo0280d]7T
00<000000=;Ai03BdN@0803BdN@01P3oool003ad0>OVj@1VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`030=WEe@00?7@0oooo
0280e]OW00<000000=KGi`3FenL0803FenL01P3oool003ad0>OVj@1VIWh0
Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`030=WEe@00
?7@0oooo00l0fM[W0`0000030=WJi`<000000P3If^L010000000fM[W0=WJ
i`0000020=WJi`040000003If^L000000=WJi`8000000`3If^L200000003
0=WJi`000000fM[W008000000P3If^L300000100fM[W00H0oooo000lM03W
i^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn^`3Pgn<0
0`3IeMD003ad0?ooo`0>0=WJi`070000003If^L0fM[W0=WJi`000000fM[W
000000030=WJi`030000003If^L000000080fM[W00D000000=WJi`3If^L0
00000=WJi`0200000080fM[W00<000000=WJi`0000000P3If^L200000005
0=WJi`000000fM[W0=WJi`0000000`3If^L00`000000fM[W0=WJi`0=0=WJ
i`060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVO[/0h=oS00<0fMGE000lM03oool03@3Ngn`00`000000g]o/0=kO
k0040=kOk0070000003Ngn`0g]o/0=kOk0000000g]o/000000020=kOk006
0000003Ngn`0g]o/0000003Ngn`000000`3Ngn`00`000000g]o/00000003
0=kOk0030000003Ngn`000000080g]o/00<000000=kOk03Ngn`04@3Ngn`0
1P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWjk0>3Oh`030=WEe@00?7@0oooo00d0hnG`00<000000>?Ul03SiO00
103SiO001`000000hnG`0>?Ul03SiO0000000>?Ul00000000P3SiO001P00
0000hnG`0>?Ul0000000hnG`000000<0hnG`00<000000>?Ul00000000`3S
iO000`000000hnG`000000020>?Ul0D000003`3SiO001P3oool003ad0>OV
j@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`03
0=WEe@00?7@0oooo00d0jN_e00<000000>W[m@3YjoD0103YjoD01P000000
jN_e0>W[m@3YjoD000000>W[m@80000000H0jN_e000000000000jN_e0000
003YjoD200000080jN_e00<000000>W[m@0000000`3YjoD00`000000jN_e
000000020>W[m@050000003YjoD0jN_e0>W[m@0000003`3YjoD01P3oool0
03ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk
0>3Oh`030=WEe@00?7@0oooo00d0l?7l00<000000?3ao03`lO`01@3`lO`3
00000080l?7l00<000000?3ao00000000P3`lO`01@000000l?7l0?3ao000
0000l?7l008000000P3`lO`010000000l?7l0?3ao03`lO`400000080l?7l
0`00000@0?3ao0060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh00004
06IVOP3ko?d0Z:Vk06IVO[/0h=oS00<0fMGE000lM03oool03P3dmOd01@00
0000m?Gm0?Ceo@3dmOd0000001/0m?Gm00<000000?Ceo@3dmOd0503dmOd0
1P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWjk0>3Oh`030=WEe@00?7@0oooo00l0m_Om0`00000L0?Kgo@030000
003fmod0m_Om01@0m_Om00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn^`3Pgn<00`3IeMD003ad0?ooo`150?Sl
o@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVO[/0h=oS00<0fMGE000lM03oool0A@3moOd01P3oool003ad0>OV
j@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`03
0=WEe@00?7@0oooo04D0oOgm00H0oooo000lM03Vi^T0IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn^`3Pgn<00`3He=@003ad0?ooo`15
0?gmo@060?ooo`00?7@0iNGX06IVOP2XZK/0nocm0@1VIWh0000406IVOP3k
o?d0Z:Vk06IVO[/0h=oS00<0fMGE02EGQ@2oc]`0A@3oool01P2oc]/09EN5
0>7Qi01VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3O
h`040=WEe@1iU:T0EGfR0<3?gD<0oooo00L0eMoX05EmXP1iUJ/0gmgP06IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`040=[G
f@3Og=P0NIBY02EGQD<003ad00L05den06J6X@3Pg]X0g=_M06IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`030=oMh03JemT0
f=CD02<0em?D7P3Cc/`30=OCe0070=SDe03IeMD0f]OI0=oMh01VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS
1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
F`3Pgn>[0:F//P0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWiK0>3Oh`030:F//P3oool0oooo0:L0oooo00@0YJbb06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0?ooo`3o
ool0Y`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2X
ZK/0IVInF`3Pgn<00`2U[;80oooo0?ooo`2R0?ooo`030000003oool0oooo
0080oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOS80h=oS1000000U0>3Oh`030:F//P3oool0oooo08d0oooo0P00000@
0?ooo`80000000<0oooo0000003oool00`3oool0102U[;80IVIn0:RY^`3k
o?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn=P3Pgn<00`000000h=oS0>3O
h`0R0>3Oh`030:F//P3oool0oooo08d0oooo00<000000?ooo`3oool0403o
ool00`000000oooo000000040?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0h=oS00@000000`3Pgn<3000000<0h=oS
0`0000030>3Oh`<000000P3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080
h=oS0P0000000`3Pgn<000000>3Oh`040>3Oh`80000000@0h=oS0000003P
gn<00000103Pgn<2000000040>3Oh`000000h=oS0>3Oh`80000000@0h=oS
0000003Pgn<000000P3Pgn<010000000h=oS0>3Oh`0000020>3Oh`<00000
0P3Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`80000000<0h=oS0000
003Pgn<0103Pgn<00`2U[;80oooo0?ooo`1o0?ooo`@000000P3oool00`00
0000oooo000000030?ooo`030000003oool0000000D0oooo00D000000?oo
o`3oool0oooo000000020?ooo`<000000`3oool00`000000oooo00000004
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0000000@0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0000
00030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3P
gn<00`000000h=oS000000020>3Oh`800000103Pgn<00`000000h=oS0>3O
h`02000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`3Pgn<00P00
0000103Pgn<000000>3Oh`3Pgn<2000000050>3Oh`000000h=oS0>3Oh`00
00000P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000<0
h=oS00<000000>3Oh`000000203Pgn<00`2U[;80oooo0?ooo`1n0?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`000000oooo000000030?oo
o`030000003oool0000000D0oooo00<000000?ooo`3oool00`3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`000000103oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@3P
gn<00`000000h=oS000000050>3Oh`030000003Pgn<0h=oS00<0h=oS00L0
00000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`00
00000`3Pgn<00`000000h=oS0>3Oh`020>3Oh`070000003Pgn<0h=oS0>3O
h`000000h=oS000000030>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS
000000030>3Oh`030000003Pgn<000000080h=oS00H000000>3Oh`3Pgn<0
00000>3Oh`0000050>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS0000
00080>3Oh`030:F//P3oool0oooo08<0oooo00D000000?ooo`000000oooo
000000030?ooo`030000003oool000000080oooo1@0000080?ooo`060000
003oool0oooo0000003oool00000103oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<200000080h=oS1@000000
0`3Pgn<000000>3Oh`040>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS
000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0
0`3Pgn<4000000030>3Oh`000000h=oS0080h=oS00L000000>3Oh`3Pgn<0
h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000000P3Pgn<01@00
0000h=oS0>3Oh`000000h=oS00D0000000<0h=oS0000003Pgn<00P3Pgn<0
0`000000h=oS000000080>3Oh`030:F//P3oool0oooo0840oooo0P000002
0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000P3oool0
10000000oooo0?ooo`0000090?ooo`060000003oool0oooo0000003oool0
0000103oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0>3Oh`02000000@0h=oS00L000000>3Oh`3Pgn<0h=oS0000003P
gn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<010000000h=oS0000
000000020>3Oh`030000003Pgn<000000080h=oS0P0000040>3Oh`060000
003Pgn<0h=oS0>3Oh`000000h=oS0P0000020>3Oh`030000003Pgn<0h=oS
0080000000<0h=oS0000003Pgn<00P3Pgn<01@000000h=oS000000000000
h=oS0080000000@0h=oS0000003Pgn<000000`3Pgn<010000000h=oS0000
000000020>3Oh`030000003Pgn<0000000P0h=oS00<0YJbb0?ooo`3oool0
O`3oool2000000@0oooo00@000000?ooo`00000000000P3oool00`000000
oooo000000030?ooo`030000003oool0000000D0oooo100000030?ooo`03
0000003oool0000000@0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP0000001`3Pgn<3000000<0h=oS0`0000030>3O
h`<000000P3Pgn<010000000h=oS0000000000030>3Oh`80000000<0h=oS
0000003Pgn<0103Pgn<300000080h=oS00<000000>3Oh`0000000P3Pgn<2
000000040>3Oh`000000h=oS000000<0h=oS00D000000>3Oh`000000h=oS
000000020>3Oh`040000003Pgn<0h=oS0>3Oh`<000000P3Pgn<01@000000
h=oS000000000000h=oS00<0000000<0h=oS0000003Pgn<0103Pgn<00`2U
[;80oooo0?ooo`1n0?ooo`030000003oool0oooo00@0oooo00@000000?oo
o`000000oooo0P0000020?ooo`070000003oool0oooo0?ooo`000000oooo
000000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`000000
103oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn000000040>3Oh`030000003Pgn<0h=oS01/0h=oS00<000000>3Oh`3P
gn<0;03Pgn<00`000000h=oS0>3Oh`060>3Oh`030:F//P3oool0oooo07h0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`000000103oool0102U[;80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn0>3Oh`04000001h0h=oS00<000000>3O
h`3Pgn<0;03Pgn<00`000000h=oS0>3Oh`060>3Oh`030:F//P3oool0oooo
07l0oooo100000020?ooo`030000003oool0oooo00D0oooo0P0000040?oo
o`030000003oool0oooo00@0oooo100000001@3oool000000000003oool0
000000@0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOU/0h=oS00<0YJbb0?ooo`3oool0XP3oool00`000000oooo0?oo
o`020?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWiK0>3Oh`030:F//P3oool0oooo0:80oooo00<000000?ooo`3oool0
0P3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVInF`3Pgn<00`2U[;80oooo0?ooo`2R0?ooo`030000003oool0oooo0080
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OU/0h=oS00<0YJbb0?ooo`3oool0XP3oool00`000000oooo0?ooo`020?oo
o`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK
0>3Oh`030:F//P3oool0oooo0:L0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oSZ`2U[;800`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3P
gn>[0:F//P0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWiK0>3Oh`030:F//P3oool0oooo0:L0oooo00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0?ooo`3oool0
Y`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVInF`3Pgn<00`2U[;80oooo0?ooo`2W0?ooo`040:F//P1VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWhR0>3Oh`@00000=@3Pgn<00`2U
[;80oooo0?ooo`2W0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101V
IWh0nocm0:RY^`1VIWhV0>3Oh`030000003Pgn<0h=oS0380h=oS00<0YJbb
0?ooo`3oool0Y`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn000000050>3Oh`030000003Pgn<0000000@0h=oS0`00
00020>3Oh`8000001@3Pgn<2000000040>3Oh`000000h=oS000000@0h=oS
0P000000103Pgn<000000>3Oh`3Pgn<2000000040>3Oh`000000h=oS0000
0080h=oS00@000000>3Oh`3Pgn<000000P3Pgn<300000080h=oS00H00000
0>3Oh`3Pgn<0h=oS0000003Pgn<2000000030>3Oh`000000h=oS01@0h=oS
00<0YJbb0?ooo`3oool0U`3oool3000000D0oooo00<000000?ooo`3oool0
1@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn000000050>3Oh`030000003Pgn<0000000<0h=oS00L000000>3Oh`3P
gn<0h=oS0000003Pgn<0000000D0h=oS00<000000>3Oh`3Pgn<00P000000
0`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<0h=oS0080000000@0h=oS
0000003Pgn<0h=oS0P0000001@3Pgn<000000>3Oh`3Pgn<000000080h=oS
00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`030000
003Pgn<0000001P0h=oS00<0YJbb0?ooo`3oool0UP3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01@3oool0102U[;80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000050>3O
h`030000003Pgn<0000000H0h=oS00@000000>3Oh`3Pgn<000001@3Pgn<0
1`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<01`000000h=oS
0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000020>3O
h`060000003Pgn<0h=oS0000003Pgn<000001@3Pgn<01`000000h=oS0>3O
h`3Pgn<000000>3Oh`000000603Pgn<00`2U[;80oooo0?ooo`2J0?ooo`03
0000003oool0000000@000001P3oool0102U[;80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn000000050>3Oh`030000003Pgn<00000
00@0h=oS0P0000030>3Oh`030000003Pgn<0h=oS00@0h=oS100000000`3P
gn<000000>3Oh`020>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS0000
00030>3Oh`030000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<00000
0>3Oh`05000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`000000
603Pgn<00`2U[;80oooo0?ooo`2J0?ooo`030000003oool000000080oooo
00<000000?ooo`3oool01@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn100000020>3Oh`040000003Pgn<000000000
0080h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000D0h=oS00H0
00000>3Oh`3Pgn<0h=oS0000003Pgn<200000080h=oS00<000000>3Oh`3P
gn<00P0000000`3Pgn<000000>3Oh`020>3Oh`050000003Pgn<000000000
003Pgn<00P000000103Pgn<000000>3Oh`0000030>3Oh`040000003Pgn<0
000000000080h=oS00<000000>3Oh`000000603Pgn<00`2U[;80oooo0?oo
o`2H0?ooo`8000000`3oool00`000000oooo000000070?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000D0h=oS
00D000000>3Oh`000000h=oS000000020>3Oh`<0000000@0h=oS00000000
000000001@3Pgn<300000080h=oS00<000000>3Oh`0000000P3Pgn<20000
00040>3Oh`000000h=oS000000<0h=oS00D000000>3Oh`000000h=oS0000
00020>3Oh`040000003Pgn<0h=oS0>3Oh`<000000P3Pgn<01@000000h=oS
000000000000h=oS00<0000000<0h=oS0000003Pgn<0503Pgn<00`2U[;80
oooo0?ooo`2J0?ooo`060000003oool0oooo0000003oool000001`3oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0000
000A0>3Oh`030000003Pgn<0h=oS02d0h=oS00<000000>3Oh`3Pgn<05P3P
gn<00`2U[;80oooo0?ooo`2F0?ooo`050000003oool0oooo0?ooo`000000
0`3oool2000000L0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOPD0000000<0h=oS0000003Pgn<02P3Pgn<00`000000
h=oS0>3Oh`0]0>3Oh`030000003Pgn<0h=oS01H0h=oS00<0YJbb0?ooo`3o
ool0U`3oool3000000D0oooo00<000000?ooo`3oool01@3oool0102U[;80
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U
[;80oooo0?ooo`2W0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101V
IWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3oool0oooo0:L0oooo00@0YJbb
06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0
YJbb0?ooo`3oool0Y`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80oooo0?ooo`2W0?ooo`040:F/
/P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`03
0:F//P3oool0oooo0:L0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOU/0h=oSZ`2U[;800`1VIWh0Z:Vk0?_lo@0106IV
OP0000<0IVIn0?Ogn@2HV:L0o`1gMi8907MgTP40V9RW0@3gmoT106IVOP00
00<0IVIn0?Ogn@2l_Ld0o`2l_Ld:0;bmc@40moOi0@1VIWh0000306IVOP3g
moT0i>?S0?l0i>?S2P3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`32
0?ooo`030>CSh`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[
MHl01P2LY;T0i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/
MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0
YcY40:HiA02W>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d
0@1VIWh0000F06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl
0?clo@3lo?`0o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0
no_m0?_lo080o?cl00@0o?cm0?clo03knod0o?cmA@3lnoa50?_lo1l0nocm
00<0W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]e
Sa40QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:HiA02L
Y;T0nocl0?clo03lnod0nocm0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0
moOi0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kg
n@3gmoT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0
moOi0?Ogn@140?OgnDD0m_Oi7`3gmoT00`1[MHl0QHV`09bN_P0@09bN_P06
08F9/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03g
moP0YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh
0?Ogn@3gmoP0moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3a
m03`l_@@000000060?7am03`l_D0lO7d0?7bm03`l_@0lO7dRP3`lODO0?3a
m00306]eS`2b]M00YjS20100YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b
]M0A0:NX`P050;:ed01[MHl0l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN
0<eIGP0;0<eIGP040<]DF@32DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03N
gN400@1VIWh0000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__000000020>OW
i`80g]kN0P3WinL00`3W_H@0inOW0>OWi`030>OWi`80kno_00@000000>[[
l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`0>CGeP030<O2d@040<O2g03Ii>/0
j^_[0=W9d@80al;A00X0dmOQ0<g2d@3=en/0j^_`0=o@d@37`]40dmg`0>[[
l03ZjnD0dl;A0P37`]400`3=en/0j^_`0>[[l0050>[[l0060=o@d@3CgO00
j^_`0>[[l03ZgM`0am3U0P3Zjo001P3Zjn/0fLWA0<O2g03Ojo00j^_`0>[M
g080al;A00@0alWQ0>C[i@3C`]40am3U0P3Zjo000`3TemH0al;F0=WTl004
0>[[l0060>CGeP37`]H0fNC`0>[[l03ZgM`0cMO[0P3Zjo00103Od=40al;L
0=o/j`3IbM420<O2d@050=?Hh@3=`]40cMS[0>[/l03Zgm`00P37`]401037
bN40i>cU0=?2d@37d>D20>[/l0050>CHeP37`]H0fNG`0>[/l03Zgm`00P37
`]404037`]H0fNG`0>[/l03ZiN40cL;A0<gHj`3Zk?00j]oL0<O2d@3Cgo00
j^c`0>[Og037`]40dmo`0>[/j`3IbM420<O2d@050=?Hh@3=`]40cMS[0>[/
l03Zgm`00P37`]402037bN40i>c[0=W9d@37`]`0gnc`0>[/l03Zk>D0dl;A
0P37`]40103=f>/0j^c`0>[/j`3IbM420<O2d@030=?Hh@3=`]40cMS[01l0
j^__00@0JgF?0;Jid@2][/H0[Jk6203oool00`2][/H0[:k60:f^aP030:f^
aP030:b^aP2f^M40JgF?0080j^__00@0JgF?0;Jid@2][/H0[Jk6303oool2
0:f^aP030:b^aP2f^M40JgF?0080j^_`00D0YSU40<eIGP3;E5T0cEIK0<iI
G`0;0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0j^__0>[[l0020>[[k`40
g=_P0@1VIWh0000406IVOP3IfMl0hnGZ0>?TjP80hnG[00D0000008b<S03N
g]h0inOW0=kNgP020>OWi`030<IS003WinL0inOW0080inOW00L0knoW0>o_
k`3_knl000000>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[0<B4@@0>41000P0>
4100100=3f`0QK2h0=3Ic`2:@0l200h@400:06Z>S`103`l0>gVh0=3Ij`2[
J`l03Q0@05jGgP3OiN/0hnFZ068?3`803Q0@00<0A8k;0=K8d@3@fN/01@3S
iN/03P2[J`l0HY?A0<O8gP3OiN/0hje^00eQWP37`]T0f^G[0>?Uc`2=A@l0
3@mS09K2f@3JiN/0hje/0P0>41002P0=AI40b>Fa06X?3`0=G9h0alkR0>?U
j`38STH03@m107^[eP3Fgn/30>?Uj`0<0<R>AP0=3d40Nj_A0=3Ij`3S[Fh0
@H2h0<O8gP3OiN/0Zf/?00d?H`2Fc/L0RT0?0P0>41001@1ZSXh0@0l?03]i
^03@fNX0hja[00803Q0@00/03DFA0<ST/01Z3`l03EbN0<O>hP3Si>X0b8i6
00d?@@1kZmH0e]oZ0>>XJ00200h@400@00d?AP2=a=h0c<SN0=o8T@143`l0
?WVh0<cCi@3S[6h03Q0@05jCd@3@fNX0hja^00h@401NTm40d=W>08Y03`80
3Q0@00D0JXj>040?3`0kNKP0d=WZ0>>/J`0200h@400800e5T@38i<h0SDD?
00d?H`2F`]T0f^CZ0>?TZP1R3`l200h@400404B>b@3Fb=40d=W>08Y03`80
3Q0@00@0JXj>040?3`0kNKP0d=WZ7`3SiNX01@1[MHl0_;kD0;:bbP2b//X0
oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0JgF?0>?UjP3S
iNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH02@0U9CH30;:bbP050;bn
e01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?ooo`3oool70=AL
G`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0
fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0g=kV00D000000>OWi`3WinL0
inOW0>OFcP020>OWi`050<ik003_U100inOW0>ONaP3_S1000`3_knl07`00
0000g=kV0=cNi@3Lg^D0g=kV0=cNi@31RT<03Q0@05jJgP3Lg^D0g=k908Q3
3`1WZ>D0`HY500h@401NTm@0d]W908Q33`0>4100GY?D0=;I[@1W3`l03C^2
0:o7f`3HgZd0I`l?00dkPP2eeND0g=k908Q33`1WZ>D01@3Lg^D06`3LgZd0
I`l?00dkPP2_`]@0d]WU0:EV3`0=3f<0U/;A0<kEi@3Lg/T0R4<?00d?H`2F
`]P0eMk908Q33`0=>h80[lOK0=SNi@3LgZd0I`l?00eLWP37c=h0g=kU0<6:
A@0=3d00Nj_D0=;Ii@030=cNi@1?0=bXJ`0>4100Gi?A0<_@hP2UJ0l03C^2
0:o2e03BfLT0R4<?00eLWP2cPT@03Q0@05jCe03BfLT0R4<?00h@401NTm@0
d]W908Q33`0=>h80[lOK0=SNi@3LgZd0I`l?00eLWP37c=h0g=kU0<6:A@0=
3d00Nj_D0=:oSP103`l03EbP0=;Ii@3La8h0@D>>0<7Ni@3La8h0@@l?03ai
^03;d>80g:Q[00h@401NTm40c]GU0=bXJ`0>4100GY?A0;F5A@0>4100GY?D
0=;Ib@28@`l03Q0@05jCe03BfLT0R4<?00dkPP2_am/0f=kU0=cNb@28@`l0
3@mS09K2f03EgZd0I`l?00dkPP2eeND0g=k908Q33`1WZ>D0`HY500h@401N
Tm@0d]W908Q33`0>4100GY?D0=;Ii@0O0=cNi@0506]eS`2o`MH0^;W>0;Ri
cP3oool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU
0=cNi@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U
9CH0^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AM
H@1C9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA002
0=cNi@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>42
0=GHh0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080
gV/000D0kkF<0>o_k`3_knl0kno_000000020=GHh@060=GGh03Ff>00e]RZ
06@?3`0=G9h0c=3P103Fen003`2lQD@03@m107^[d@39cMh0XVD?00d?@01k
Zm<0cm>Z06@?3`0=>h80[lKI0=BSJ@0>4100GY?C0<oCh0080=KGh00K0=JS
J@0>41003@m107nad@39]8X0?`l?00h@401QU]40alWK0=KGa@25@@l03@mS
09K2eP3AejX0I0l?00dkPP2_a]T0e=OP0=KGZP1T3`l03EbN0<O9f`3Fen00
_8E400d?@01kZm<0cm?P00<0e]OP0240e[f;040?3`0nNKP0bLfX06@?3`0=
3d40P;7A0<W=Z01T3`l0?7Vh0;B2A00=3d40Nj_A0<W=gP2RIPl03@m007^[
d`3?e:X0I0l?00dkPP2_a]T0e=SP0=KHZP1T3`l03EbN0<O9f`3Ff>00_8I4
00d?@01kZm<0]XA400d??`1kZm401037`]407`37/HP0@0l?03ai^039cMh0
eZ=Y00h@401NTm40c=7P0=JSJ@0>4100GY?A0;B2A00=3d40Nj_A0<W=gP2R
IPl03@m007^[d`3?e:X0I0l?00dkPP2_a]T0e=SP0=KHa@25@@l03@mS09K2
eP3AXfT03Q0@05jCd`3?e>000`3Ff>00202lQT@03@m107^[d@39cMh0XVH?
00d?@01kZm<0cmCP7`3Ef>401@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf
1`2l_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU
=P2l_M401`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP
0=GGh@2V>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool0
0`167QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM
0@1VIWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<
0>ONcP36BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh0
00000`3@d]`01@3?d]`0d9iW00h@401NTm<0c<oL00@0d=;L00l0d9iW00h@
400nOk`0al;A0:mi?`0=3cl0Nj_C0<c?YP1R3`l03C^20:o4eP2fPd<03@m0
07^[d@3:c=`0203@d]`06`2MH`l03@mS05iO3`0nOk`0[gU000eMPP1m?Pl0
3F2O0<O2e@3=d/40PD0?00d?H`2F`]D0cM:V068?3`0=>h80[lCF0<oBg03@
dZH0HPl?00eLWP37b=P0d=;L0;R3@`0=3d00Nj_C0<c?g0030=3Bg00O0=3B
YP1R3`l0?WZh0<NGIP0=?880O60?03io_037[8D0?Pl?05jCd`3;W6P03Q0@
03io_037`]40[gTo00d??`1kZm<0blnW064?3`0=>h80[lCG0<gBg@3?dZL0
H@l?00eLWP37b=T0cm;M0;J3@`0=3d00Nj_C09UR3`0500h@400P00eLWP37
/8H0?Pl?03ai^038b]/0ciiX00h@401NTm40bLcM0<nNJ00>4100GY?A0<VJ
J00>4100?Wnl0<O2d@2_NCl03@lo07^[d`3;cjL0H@l?00dkPP2_a=L0cM;M
0<oB``20@0l03@mS09K2e@2dPd<03@m007^[d@39c=d30<oBg@080<nNJ00>
4100?Wnl0<O2d@2_NCl03@lo07^[d`3;cmdO0=3Bg00306]eS`38bM/0`lCF
0100`lCF00H0b<WK06]eS`3@d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U
9CH0`lCF00L0`lCF00<0oooo02DU=P33a=H00P33a=H01`38bM/0JgF?0<oB
g03?d]`0YSU40=MOG`3IHF800`3LIFD01@167QX0oooo0?ooo`3oool0g6EU
00<0oooo00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L
0@3?d]`10=;Dg@40IVIn00007P1VIWh0d=;K0<_=f03:cMT0blkH0<[=f000
0000ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU003FS000cV/00>O6
003oeP00knoW0>o_k`000000blgH0<_=f@3:cMT0blkH0;:0@@0=3d00Nj_C
0<W<f@D0blgI0180bi]V00h@400>41003Q0@00d??`1kZm<0bLfT05l?3`0=
>h80[lCE0<ZKIP0>4100GY?A0<O4e@3:cMT0blgI0<W6d`39c=T30<_=f@0L
0<_=Y01O3`l03EbN0<RHIP0=3d40?3`?05jDe@2bP4403@mT09O2d@38bKl0
OSl?00d?H`2F`]<0bLfT05l?3`0=>h80[lCE0<[=f@3;cJ@0G`l?00eLWP37
a=D0b/gI0;>0@@0=3cl0Nj_C0<W=f@<0blgI00`0blfo07ho3`0=GYh0UUd?
03ai^038V6H03Cj50:nCI00=3d00Nj_C0<W>f@3;W6H300h@400S00d??`1k
Zm<0bLjT05l?3`0=>h80[lCE0<[>f@3;cZ@0G`l?00eLWP37a=D0b/kI0;>0
@@0=3cl0Nj_C0;60@@0=3d00O:_A0<S8e`3;cZ@0G`l?00eLWP38/XH0?0l?
03ai^037a=D0bYaV00h@401NTm40b<SG0<^LIP0>4100GY?C0<W<f@3;W6H0
0`0>4100500=3cl0Nj_C0<W>Y01O3`l03C^20:o4e@3:c]T0bljo07ho3`0=
3f<0U/;C0<VLIP0>4100GY?A0<O4e@3:c]T0blkI0<W6d`39c=T0biaV0`0>
41000`0=3cl0Nj_C0<W>f@0O0<_=f00306]eS`3;c=h0b<[I00P0b<[I00<0
b<WI0<S:f@38b]T00`38b]T01038bMT0b<[I0<_<gP1[MHl20<_=f00606]e
S`3;c=h0b<[I0<S:f@3oool09BDf1@38b]T04@38bMT0b<[I0<S:f@3oool0
9BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0eemO0=]TI03P
IfD0h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3oool02P167QX0gVMW0=iW
I`3PIVD0h6MU0=]TI03GGel0YSU40<[>f03:c]T20<_=f@40d=;K0@1VIWh0
000306IVOP3?cmX0aLSD00<0aLSD00H000000<K6aP3Wg]H0cW/00>N]003_
]@020>NU00030=JD003>L`00eY@00080mlH00P3gmoL02@000000aLSD0<G7
e035am@0aLOE0:il@00=3d00Nj_A0<K5e@060<C7e@0@0<C4d@37`]40UU`?
00d?H`2Ea]D0a<NQ05`?3`0=>h80[l?C0<C7X@1L3`l03Cb40:k3d@37`]40
UU`o07^/d`@0a<OE01/0a9MT00h@401NTm<0a<Nl07Tl3`0=?8<0[lCD0<B_
Q@0k3`l0GI?A0<O3^P1j?0l03@mS09K2d`34aj00G@l?00dkPP2_`]40al;A
0<O4W`1L3`l03C^20:o2d@37`[P0Nc/?00d?H`2Ea]D01@34amD02@2DGPl0
3Ca003/?3`1NTm<0a:n503/?@01MGCl03@mS09K4d`020<C8e00T0<C4d@37
`]40UU`?00d?H`2Eam@0a<RO05d?3`0=>h80[l;A0<O2d@37a9l0G0l?00dk
PP2_`]40al:h07/k3`0=3f<0ULOD0<B`Q00k3`l0>gbj0<K2d@37Tf<03Q0@
05fEd`34/8@0>`l?00dkP`2^aM80[gTo00h@400kNkX0a<GB0:mi?`0=3cl0
NjkC0P34b=@05@34a=40al;A09IL3`0=3f<0ULOD0<C8W`1M3`l03C^20:o2
d@37`]40alBj07Tl3`0=3f<0U/;B0<C8X01L3`l03Cb40:k3d@37`]40UU`o
07^/d`020<C8e0060<C4d@37`]40UU`?00d?H`2Eam@0a<SD7`34am@00`1[
MHl0d=7P0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P0P3;
bm`00`3oool09BDf0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080bl_L00L0
d=7P06]eS`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ0?ooo`3o
ool0oooo04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD0@35amD1
0<o?fP40IVIn0000101VIWh0c<kJ0<;4dP31a=420<74dP060000003WinL0
inOW0>OWi`3FQ000kkD00P3WY@00203FQ000cV/00>N]003g]@00mkd00>o_
k`3gmoL000000`31a=801P32a=40`IAS00h@401MTm40al;A0<;4d@@0`LCA
00d0TUd?00h@400>41003@lo07R/d@31a=40`LBN05/?3`0=>h80[l;A0<;4
d@31a;P0N3`?00803Q0@00<03Cb20:[4d@31a=400P31a=404031a;P0N3`?
00dlPP2Za=40`LCA0:Yj?`0jN[P0`LCA0<74^01h?0l03Cb207QM3`0>4100
3@mS09;4^01h?0l300h@400300eMWP31a9h0F`l?00<03Q0@00<03@lo07R/
d@31a=401@31a=402`2ZNSl03Q0@00d?H`2F`m40`LBh07Pl3`0>41003EbN
0<K3d@31a=80TUd?00803Q0@00@03@m007R/dP31a;P0N3`?0`0>41000`0=
GIh0`LBN05/?3`0300h@400600d?@01h[=80`LCB0<74dP31[8<0>Pl?0P0>
41001@0jN[P0`LCB0<6/P`0j3d00N7YS00803Q0@00D0>WZh0:Yj@00>4100
3Q0@03Yj^0020<74dP07099M3`0>41003Q0@00d?@01h[=80`LBh07Pl3`03
00h@400800eMWP2BG@l03Q0@00d?H`2Ba=80`LCB0<74^01h?0l200h@4004
00dlP`2Za=80`LCB099M3`803Q0@00@03@m007R/dP31a=80`LCB7`32a=80
0`1[MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R
0P3?d=d00`3oool09BDf0<o@g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M
00L0dm?R06]eS`32a=80`LCA0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/
J@080>5YI@3KI6@0YSU40<74dP32a=40`LCA0<74dP3<c]X106IVOP0000@0
IVIn0<[<f02n`<l0_L3?0P2n`<h01@000000W9bL0>OWi`3Wg]H0eX`00080
gY@000@0eW/00<IS002m@P00kjD00P3g[@00403g]@00oli:0000002n`<h0
_/3?0;k0cP2n`<l0_L2L05X?3`0=>h80[l;A0<G1c`2n`<h0_/3?0<?1d033
`<h60;k0cP050;k0W01J3`l03C^20:o1c`30`<h05P2n`<h02`31`M40al;@
0<70W01J3`l03C^20:o1c`30`<h0_/2L05X?3`0=G9h0al7?00T0_/3>00T0
_Y5Q00h@400=G9h0aL7?0;k0cP2WMcl03Q0@03]i^034`<h01`2m`<h02@2m
`9`0FPl?00dkPP2_`Ll0_l3>0;g0W01J3`l03EbN0<O1c`0M0;g0cP050;g0
W01J3`l03C^20:o1c`2o`<h00P2m`<h00`30`M40al;@0<30cP0>0;g0cQl0
_/3>00<0JgF?0=KFi03Cdn00403Cdn001P3Fe^@0JgF?0;k0cP2n`<h0JgF?
0=KFi080dm?P00<0oooo02DU=P3oool0203oool02`0U9CH0dm?P0=?Ch03C
dn00e]KT06]eS`2n`<l0_/3>0:HiA03PIVD0hFYZ00@0hfa/0`3oool01016
7QX0oooo0?ooo`3oool40>=/K0040>5ZJP3PIVD0YSU40;g0c`80_/3?0@2n
`<h10<[<f040IVIn00001`1VIWh0bL[H0;Jhb02i_</0^[c;0;Zlc0000000
0P3_knl06@3FW000eX`00=jD003FQ000kjD00=j<002mFP00eW<00>nL003g
knL0moOg0?ooo`000000^Kc<0;Zkc02i_</0^[c;0;Vlc02iSV003Q0@03Ue
]P34`]40al:h07/k?`1kZLh01`2i_<`01@2i_9X0E`l?00dkPP2_`Ll0_;c<
01D0^Kc<00`0S5X?00d?H`2F`/l0_[c<08aJ3`0=>Wl0Xkc<0;Vlc02i_9X0
E`l?00eLWP37`<h90;Vlc0090;VUO`0i3`l0>WVh0<2lc02i_<`0^HiQ00h@
401LTm00`;c<00P0^[c<00P0SEX?00djO`2T_<`0^[c<0;ZlVP1G3`l03EbN
0<O0cQh0^[c<00<0SEX?00djO`2T_<`00P2j_<`0102=FPl03@mS09K2c`2n
_<`>0;Zlc1l0^[c;00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?0;Zl
b`2j_</0JgF?0=SHi@80dm?Q00<0oooo06i]S`1^KHl0201^KHl03P0U9CH0
dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<0:HiA03PJFP0hFe/0>AaK@3T
LFl0i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^00T0i75]0>5]
K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039b]P00@1VIWh0000906IVOP37
bML0];K70;Jhb02f^<T0][W900000024Q8@0inON0080kno_00L0aV/00?O6
003_]@00ki`00=j<003>J`00ii`000<0moOg00D000000;Jib@2g^<T0][W9
0;Nib@020;Jhb@050;NRO@0g3`l03Q0@00h@400=EiP0202g^<T0102g^9P0
EPl?00diO@2Q^<TF0;Nhb@0308YG3`0=3el0R[S900D0]kS900<0]kRH05H?
3`0=EiP02P2g^<T00`2g^9P0EPln076Rb@020;Nhb@040;NhV01F3ch0LJ;9
0;Nhb@`0][S900<0][RH05H?3`0=EiP0902f^<T00`29E`l03@mO08Vhb@0?
0;JhbAl0]kS900@0JgF?0=KFi03Hf>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3H
f>H20=SHi@090=KFi01[MHl0]kS90;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo
00X0KVf?00d09BDf0=SHiP3Hf>D0f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0
i6i]0>AdK`3WLFl0i7A_00<0oooo00D0AQhJ0>AdK`3TM6l0i7A_04HN6P03
0?ooo`0:0>AdK`3WLFl0i7A_0>A^K@2V>D@0][W90;Jhb@2f^LT0];K70<O9
e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`030000003_knl0kno_0080
kno_00/0ijd00?O6203WY@00ii@00>N<003_imH0gY@i0>oF]@3omoL0oooo
0000002_0;Bfa`0506]eS`3EeN<0g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0
JgF?0;Bfa`2d]/L0JgF?0=GEh`80g=_W00<0gM_W02DU=P0U9CH02@0U9CH3
0=cKi`090=GEh`1[MHl0];K70;Bfa`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080
oooo00<0AQhJ0>UnN03YOWP00`3YOWP020167QX0oooo0?ooo`3ZN7H0jWIc
0>MeLP3WLfl0YSU4102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;Bfa`03
0;Bfa`060000002<S8`0kno_0>o_k`3WcW/0kno_0P3gmoL0203WU000mnO>
0?Ogm`3gmoL0knOF0?Ogm`3oool00000[`2d]/L00`1[MHl0eMCS0>3OjP0@
0>3OjP060=GDh`1[MHl0];K70;Bfa`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?
0;Bfa`2d]/L0YSU40>YiL`3YO7P0kh5j0?:9P@0204HN6P070>^HR`3ZVh`0
kIN:0>^HR`3ZVh`0kIN:0>^HR`0204HN6P050?:9P@3_PGX0jGah0>YiL`2V
>D@0102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;6cb0030;6cb0060000
003_knl0kno_0>o_k`3gmnl0kno_0P3gmoL00`3gilH0moOg0?ooo`030?Og
m`030?ooo`000000/K?80:h0/K?800<0JgF?0>g[l`3Yj?40403Yj?401P3]
jo<0JgF?0;6cb02a/lP0JgF?0>g[la40jNSa01T0kN_c06]eS`2a/lP0/K?8
0:HiA03aP7D0l8Al0?F<Q03gWHh0lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0
k;FL0?6bV`3]]9/0k;FL0?:[UP3gWHh0mHb40?24O03aP7D0YSU400@0/K?8
0@36b=L106IVOP0000<0IVIn0<K8e`2h]ll00`2_[/L01@000000[Jf]0?Og
k`3gmoL0kno_00H0moOg0P3omoL20?ooo`030000002_[/L0[jk70:d0[jk7
00<0JgF?0=;Ah`3blOL0403blOL01P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;A
ha40l_7g00H0d]7S06]eS`2_[/L0[jk70:HiA03dRWd20?F@Q@d0l[RN0P3e
T8D00`3dRWd0YSU40:n^a`020:n^a`40^;O?0@36b=L106IVOP0000<0IVIn
0<31d@37am@0`P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<
bmd0JgF?08B<XP80[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0
c<_M06]eS`24S:820:b[a007096HZP2V>D@0oin=0?joY03jg;L0n^^g0?[Y
]P020?WY]P040?[Y]P3ijKH0nNVf0?[Y]P80nNVf00H0n^^g0?[L]`3n_j@0
oin=0:HiA02AV:X30:b[a040alOD0@30`M4106IVOP0000@0IVIn0<31d@3B
d]l0]KC9`P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n
0080Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS
_P0308B<XP2V>D@0YSU400l0YSU400L0Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3B
d]l0`<7A0040IVIn00001P1VIWh0Z:No0>KVk@3Bd^00_;c?0;6`a?l0Z:No
0`2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`3oool0QhNK
0=OHhP3lo?`0i>?X0=3@h03:b]X0o`2l_<l10;blc`060<[:fP3@d>00i>?X
0?clo03Gf>80QhNK0@00M;l000080?ooo`1VIWh0UIB[0=OHhP3lo?`0l_7c
0>c[kP3Qh^_n0=OHhP070>7Rj`3/jnh0l_7c0?clo03Gf>80UIB[06IVOP01
0?ooo`000P3oool00`1VIWh0UIB[0=7AgP020?clo?l0oooo0@3oool20?cl
o0030=7AgP2EU:/0IVIn0080oooo00030?ooo`80IVIn00<0R8NM09FDZ`2X
Ykl0o`2XYkl0102EU:/0R8NM06IVOP1VIWh30?ooo`001@3ooooo06IVOPD0
IVIn1@3oool00001\
\>"], "Graphics",
  CellLabel->"From In[6]:=",
  Evaluatable->False,
  ImageSize->{270, 213},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"QuickTour"],

Cell[TextData[{
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " also provides a convenient ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression syntax for defining and executing your own simple or complex \
user interfaces:"
}], "Text",
  CellTags->"QuickTour"],

Cell["\<\
Here we create a simple resizable dialog with three very common user \
interface components.\
\>", "Text",
  CellTags->"QuickTour"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ 
      GUIRun[\[IndentingNewLine]Widget["\<Frame\>", \
{\[IndentingNewLine]{Widget["\<Label\>", {"\<text\>" -> "\<Label:\>"}], \
\[IndentingNewLine]Widget["\<TextField\>", {"\<text\>" -> "\<Input\>"}]}, \
\[IndentingNewLine]Widget["\<TextArea\>", {"\<text\>" -> "\<Content\>"}]\ }, \
\ Name\  \[Rule] \ "\<myFrame\>"]\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"QuickTour"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject162586725187585, 
        JLink`Objects`JavaObject470999317348353]]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"QuickTour"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"QuickTour"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000BR000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80oooo
0`0000040?ooo`<000000P3oool3000000040?ooo`0000000000000000<0
oooo0`0000030?ooo`@0000000D0oooo00000000000000000?ooo`030000
00<0oooo0`0000130?ooo`0306IVOP2XZK/0nocm0040IVIn00001P1VIWh0
nocm0:RY^`1VIWh0oooo000000<0oooo00@000000?ooo`3oool000000`3o
ool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo000000060?ooo`050000003oool0oooo0?oo
o`0000000`3oool01@000000oooo0?ooo`3oool000000480oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3oool000001P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0103oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool0A03oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2X
ZK/0IVIn0?ooo`0000060?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0
0`3oool500000080oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo04@0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000606IV
OP3ko?d0Z:Vk06IVOP3oool000001P3oool01@000000oooo0?ooo`3oool0
00000080oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000001@3o
ool01@000000oooo0?ooo`3oool000000080oooo0P0000020?ooo`050000
003oool0oooo0?ooo`000000AP3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00H0IVIn0?_lo@2XZK/0IVIn0?ooo`0000070?ooo`<000000P3oool20000
00030?ooo`000000000000<0oooo1@0000030?ooo`<000000P3oool20000
00030?ooo`000000000000<0oooo1@0000130?ooo`0306IVOP2XZK/0nocm
0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0oooo000000<0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
oooo04@0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP80oooo1000001]0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWhP0>3Ohe<0YJbb00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOR00h=oS00<0YJbb0?ooo`3oool0C`3oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn803P
gn<00`2U[;80oooo0?ooo`1?0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWhP0>3Oh`030:F//P3oool0oooo00<0oooo
00<000000?ooo`3oool0B@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn803Pgn<00`2U[;80oooo0?ooo`030?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0@@3oool0102U[;80
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn803Pgn<00`2U
[;80oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0@@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn1@0000020>3Oh`80000000D0h=oS0000003Pgn<000000>3O
h`02000000<0h=oS0`0000020>3Oh`030000003Pgn<0000000D0h=oS00<0
YJbb0?ooo`3oool00`3oool00`000000oooo000000030?ooo`040000003o
ool000000?ooo`8000000`3oool2000000030?ooo`000000oooo00800000
=P3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn000000050>3Oh`030000003Pgn<0h=oS0080000000<0h=oS00000000
00000P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000L0
h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo000000030?ooo`04
0000003oool0000000000080oooo00<000000?ooo`0000000P3oool20000
00030?ooo`000000oooo03H0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP0000001@3Pgn<01`000000h=oS0>3Oh`3P
gn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000050>3Oh`030000
003Pgn<0h=oS00D0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`000000
0`3oool00`000000oooo0000000g0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000H0h=oS100000000`3Pgn<0
00000>3Oh`020>3Oh`030000003Pgn<0000000@0000000<0h=oS0000003P
gn<01P3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`03
0000003oool0000003L0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP0000001@3Pgn<01P000000h=oS0>3Oh`3Pgn<0
00000>3Oh`8000000P3Pgn<00`000000h=oS000000030>3Oh`030000003P
gn<0000000L0h=oS00<0YJbb0?ooo`3oool00`3oool010000000oooo0000
000000020?ooo`040000003oool0000000000080oooo00<000000?ooo`00
00000`3oool00`000000oooo0000000g0?ooo`040:F//P1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000H0h=oS0`0000020>3O
h`040000003Pgn<00000000000<0h=oS0`0000020>3Oh`030000003Pgn<0
000000D0h=oS00<0YJbb0?ooo`3oool00`3oool010000000oooo0000003o
ool200000080oooo00@000000?ooo`00000000000P3oool010000000oooo
0?ooo`3oool4000003H0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP0000002`3Pgn<00`000000h=oS0>3Oh`090>3O
h`030000003Pgn<0h=oS00D0h=oS00<0YJbb0?ooo`3oool00`3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo03D0oooo00@0YJbb06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000002`3Pgn<0
0`000000h=oS0>3Oh`090>3Oh`030000003Pgn<0h=oS00D0h=oS00<0YJbb
0?ooo`3oool00`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo03D0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOR00h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?oo
o`190?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWhP0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0
B@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn803Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo04T0
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OR00h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`190?oo
o`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhP
0>3Oh`030:F//P3oool0oooo04l0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOR00h=oSD`2U[;800`1VIWh0Z:Vk0?_l
o@0106IVOP0000<0IVIn0?Ogn@2HV:L0M@1gMi8109RHY`40moOi0@1VIWh0
000306IVOP3gmoT0_;g=07H0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3T
hn<0MP3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`0_0?ooo`030>CS
h`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0
i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[
MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W
>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F
06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0
o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080
o?cl00@0o?cm0?clo03knod0o?cm503lno`20?_lo00309bT^@1[MHl0QHV`
0100QHV`00H0JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9/00606]eS`2L
Y;T0nocl0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_lo03lo?`0o?_m
0?_lo@3RhN800@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0m_Oh
0?Ogn@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi0?Kgn@020?Og
n@040?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3gmoT04`3gmoT2
0?Kgn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi06]e
S`25RK0A09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=
0<IEG0090<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q0040
IVIn00001P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm100000000H0lO7d0?3b
m@3alO@0lO;d0?3bm03alO@F0?3am@0306]eS`2b]M00YjS20100YjS200H0
/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e0?7b
m02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0`U9K
0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3Lfn00j^_`
0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0inOW0>OW
i`030>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`
0>[[l00B0>[[l080j^c`00@0JgF?0;Jid@2][/H0[Jk6203oool00`2][/H0
[:k60:f^aP030:f^aP030:b^aP2f^M40JgF?0080j^__00@0JgF?0;Jid@2]
[/H0[Jk6303oool20:f^aP030:b^aP2f^M40JgF?0080j^_`00D0YSU40<eI
GP3;E5T0cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0j^__
0>[[l0020>[[k`40g=_P0@1VIWh0000406IVOP3IfMl0hnGZ0>?TjP80hnG[
00D0000008b<S03Ng]h0inOW0=kNgP020>OWi`030<IS003WinL0inOW0080
inOW00L0knoW0>o_k`3_knl000000>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[
0>?Uj`3SiN/04P3SiN/20>?TjP0506]eS`2l_]@0/[;:0;:bbP3oool01P1^
KHl00`0U9CH0/[;:0;:bbP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[MHl0
_;kD0P2b//X00`3oool09BDf02DU=P0902DU=P<0/[;:00D0_;kD06]eS`3S
i>/0hnC[0:HiA0020<eIGP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3oool0
2P3DG5l0d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl106IV
OP0000<0IVIn0=OHgP3Lg^H00`3Lg^H01@000000inOW0>OWi`3WinL0imK>
0080inOW00D0cW/00>nD403WinL0imk60>n<40030>o_k`070000003Lg^H0
g=kU0=cNi@3Lg^H0g=kU0=cNiP0F0=cNi@0506]eS`2o`MH0^;W>0;RicP3o
ool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU0=cN
i@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U9CH0
^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C
9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA0020=cN
i@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>420=GH
h0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080gV/0
00D0kkF<0>o_k`3_knl0kno_000000020=GHh@040=GGh03Ff>00e]SQ0=KG
hA@0e]OP0P3Ff>001@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M40
1P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M40
1`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V
>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0
fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0
000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36
BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@
d]`00`3?d]`0d=;L0<oBg00D0=3Bg080cm;M00<0JgF?0<S9f`33a=H04033
a=H01P38bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80`lCF00<0oooo02DU=P33
a=H01`33a=H00`3oool09BDf0<?4eP020<?4eP070<S9f`1[MHl0cm;L0<oB
g02V>D@0eemO0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3o
ool020167QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`10<oB
g040d]CM0@1VIWh0000L06IVOP3@d]/0blgH0<[=f@3;c]P0b/gH0000003W
aZd0ilJ<0?O>603__@00mlH00>n]003W[@00ijD00=J<003>J`00ilH00?oF
003_knL0kno_0000003;cMP0blgI0<[=f@3;c]P0b/gH0<_=f1@0blgI0P3;
c]T00`1[MHl0blcN0<S:f@080<S:f@030<S9f@38b]T0b<[I00<0b<[I00@0
b<WI0<S:f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN0<S:f@38b]T0oooo02DU
=PD0b<[I0140b<WI0<S:f@38b]T0oooo02DU=P38b]T0b<WI0<S:f@3;c=h0
JgF?0<_>f03:cMP0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN6P3o
ool0oooo00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO0:Hi
A03:c]P0b/kI0P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0030<G8
e00600000036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD
00020?O60080moOg00@000000<G8e035am@0aLOD0`35amDD0<C7e@80a<SD
00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3A
h080bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;
g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3o
ool0oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040
aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000
inOW0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm
003_knl0moOg000000<0`LCB00<0`/CA0<74dP31a=805031a=420<74dP03
06]eS`3Cdn80cm3M0100cm3M00H0dm?R06]eS`32a=80`/CB06]eS`3Cdn82
0<o@g@030?ooo`0U9CH0cm3M00L0cm3M00<0oooo02DU=P3?d=d00P3?d=d0
1`3Cdn80JgF?0<;4dP31a=40YSU40=]TI03QJFD01@3PK6T50?ooo`D0h6aY
00P0hFUU0=]TI02V>D@0`LCB0<;4d@31a=40`LCB0<c>fP40IVIn0000101V
IWh0b/cH0;k0c`2m`<l20;k0cP050000002LW9`0inOW0>ONeP3FS0000P3N
U000103FN`00aV<00;e2003_Y@020?N]00080?Ne003ocTX000000;k0cP2n
`<l0_/3>0;k0c`2m`<hE0;k0cP80_L3>00<0JgF?0=KFi03Cdn00403Cdn00
1P3Fe^@0JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3oool0
203oool02`0U9CH0dm?P0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:HiA03P
IVD0hFYZ00@0hfa/0`3oool010167QX0oooo0?ooo`3oool40>=/K0040>5Z
JP3PIVD0YSU40;g0c`80_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0bL[H
0;Jhb02i_</0^[c;0;Zlc00000000P3_knl04`3FW000eX`00=jD003FQ000
kjD00=j<002mFP00eW<00>nL003gknL0moOg0?ooo`000000^Kc<0;Zkc02i
_</0^[c;0;Vlc02i_</0502i_<`20;Zlc00306]eS`3Hf>D0dm?Q0100dm?Q
00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?
00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0
h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3oool2
0>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H0040
IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OWgP02
0>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Ogm`050000
002f^LT0]kS90;Jib@2g^LT00P2f^<TD0;Nhb@80][S900@0JgF?0=KFi03H
f>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@090=KFi01[MHl0]kS9
0;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d09BDf0=SHiP3Hf>D0
f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo
00D0AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^
K@2V>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn00000`1VIWh0a/SG0;Bf
a`030;Bfa`030000003_knl0kno_0080kno_00/0ijd00?O6203WY@00ii@0
0>N<003_imH0gY@i0>oF]@3omoL0oooo0000000L0;Bfa`0506]eS`3EeN<0
g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80
g=_W00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GEh`1[MHl0];K70;Bf
a`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ0>UnN03YOWP00`3Y
OWP020167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d]/L10<K8
e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`060000002<S8`0kno_0>o_
k`3WcW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool0
0000702d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0];K70;Bf
a`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0YSU40>YiL`3YO7P0
kh5j0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:0>^HR`02
04HN6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L10<K8e`40IVIn0000
0`1VIWh0a/SG0;6cb0030;6cb0060000003_knl0kno_0>o_k`3gmnl0kno_
0P3gmoL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`000000/K?801/0/K?8
00<0JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[
la40jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0
lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3g
WHh0mHb40?24O03aP7D0YSU400@0/K?80@36b=L106IVOP0000<0IVIn0<K8
e`2h]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3omoL2
0?ooo`030000002_[/L0[jk701X0[jk700<0JgF?0=;Ah`3blOL0403blOL0
1P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0d]7S06]eS`2_[/L0
[jk70:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^a`020:n^
a`40^;O?0@36b=L106IVOP0000<0IVIn0<31d@37am@0;`2/Zl@01024S:80
JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400@0Q8bR
06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a007096H
ZP2V>D@0oin=0?joY03jg;L0n^^g0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf
0?[Y]P80nNVf00H0n^^g0?[L]`3n_j@0oin=0:HiA02AV:X30:b[a040alOD
0@30`M4106IVOP0000@0IVIn0<31d@3Bd]l0]KC9;`2TXkh00`24S:80JgF?
06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]eS`1[MHl0
3`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V>D@0YSU400l0YSU4
00L0Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040IVIn00001P1VIWh0
Z:No0>KVk@3Bd^00_;c?0;6`a6l0Z:No00D0/K340;blc`3Bd^00i^K]0:RW
_`0106IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@d>00b/[J06d0_;c?
00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ00000P0F5MX06IVOP2E
U:/0emSR0?clo03blO<0k>_^0>7Rjf/0emSR00L0hN;[0>c[kP3blO<0o?cl
0=OHhP2EU:/0IVIn0040F5MX000205QGJ00306IVOP2EU:/0dM7N0080o?cl
K@3oool20?clo0030=7AgP2EU:/0IVIn0080F5MX000305QGJ080IVIn00<0
R8NM09FDZ`2XYkl0K02XYkl0102EU:/0R8NM06IVOP1VIWh305QGJ0001@1H
EfQa06IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[4]:=",
  Evaluatable->False,
  ImageSize->{123, 74},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"QuickTour"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[4]=",
  CellTags->"QuickTour"]
}, Open  ]],

Cell[TextData[{
  "The following slide show provides a quick introduction to building your \
own user interface definitions with ",
  StyleBox["GUIKit.",
    FontSlant->"Italic"],
  "\n ",
  ButtonBox["Building with ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "GUIKitBuildingSlideShow.nb"], ""},
    ButtonStyle->"PageLink"],
  StyleBox[ButtonBox["GUIKit",
    ButtonData:>{
      FrontEnd`FileName[ {}, "GUIKitBuildingSlideShow.nb"], ""},
    ButtonStyle->"PageLink"],
    FontSlant->"Italic"],
  ButtonBox[" Slide Show",
    ButtonData:>{
      FrontEnd`FileName[ {}, "GUIKitBuildingSlideShow.nb"], ""},
    ButtonStyle->"PageLink"]
}], "Text",
  CellDingbat->"\[FilledSmallSquare]",
  CellTags->"QuickTour"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Release Notes", "Section",
  CellTags->"ReleaseNotes"],

Cell[TextData[StyleBox["Version 1.0.2\nNovember 2004", "SB"]],
  CellTags->"ReleaseNotes"],

Cell[CellGroupData[{

Cell["Version 1.0.0", "Subsection",
  CellDingbat->None,
  CellTags->"ReleaseNotes"],

Cell[TextData[{
  "This is the initial release of ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellDingbat->"\[FilledSmallSquare]",
  CellTags->"ReleaseNotes"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Version 1.0.1", "Subsection",
  CellDingbat->None,
  CellTags->"ReleaseNotes"],

Cell["Minor bug fixes", "Text",
  CellDingbat->"\[FilledSmallSquare]",
  CellTags->"ReleaseNotes"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Version 1.0.2", "Subsection",
  CellDingbat->None,
  CellTags->"ReleaseNotes"],

Cell["Fixes a potential startup failure on some Unix platforms.", "Text",
  CellDingbat->"\[FilledSmallSquare]",
  CellTags->"ReleaseNotes"],

Cell[TextData[{
  "Fixes a case where ",
  StyleBox["$ContextPath", "Program"],
  " may not be reset properly after a ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " ",
  StyleBox["Script", "Program"],
  " evaluates."
}], "Text",
  CellDingbat->"\[FilledSmallSquare]",
  CellTags->"ReleaseNotes"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Other Resources", "Section",
  CellTags->"OtherResources"],

Cell[TextData[{
  "For an overview introduction to ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " and its features, you may find the following 2003 Developer Conference \
slide show useful.\n ",
  StyleBox[ButtonBox["GUIKit: ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "GUIKitIntroSlideShow.nb"], ""},
    ButtonStyle->"PageLink"],
    FontSlant->"Italic"],
  StyleBox[ButtonBox["A",
    ButtonData:>{
      FrontEnd`FileName[ {}, "GUIKitIntroSlideShow.nb"], ""},
    ButtonStyle->"PageLink"],
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[ButtonBox[" Mathematica ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "GUIKitIntroSlideShow.nb"], ""},
    ButtonStyle->"PageLink"],
    FontSlant->"Italic"],
  StyleBox[ButtonBox["User Interface Framework Slide Show",
    ButtonData:>{
      FrontEnd`FileName[ {}, "GUIKitIntroSlideShow.nb"], ""},
    ButtonStyle->"PageLink"],
    FontVariations->{"CompatibilityType"->0}]
}], "Text",
  CellDingbat->"\[FilledSmallSquare]",
  CellTags->"OtherResources"],

Cell[TextData[ButtonBox["GUIKit online site",
  ButtonData:>{
    URL[ "http://www.wolfram.com/solutions/mathlink/guikit/"], None},
  ButtonStyle->"Hyperlink"]], "Text",
  CellDingbat->"\[FilledSmallSquare]",
  CellTags->"OtherResources"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Running GUIs", "Chapter",
  CellTags->"RunningIntro"],

Cell[TextData[{
  "One powerful feature of the ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " framework is to make it easy for users to load and execute prepackaged \
custom user interfaces whenever they need them."
}], "Text",
  CellTags->"RunningIntro"],

Cell[TextData[{
  "This section explains how to take advantage of existing user interface \
definitions. This includes not only what functions to use when loading the \
definitions, but also how to manipulate them after they are already executing \
and interacting with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"RunningIntro"],

Cell[CellGroupData[{

Cell["Executing GUIs", "Section",
  CellTags->"Executing"],

Cell[TextData[{
  "One of the most basic features of ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " is loading and executing an existing user interface application. This can \
be accomplished in one step in either a modal or modeless session with the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel using ",
  StyleBox["GUIRunModal", "MR"],
  " or ",
  StyleBox["GUIRun", "Program"],
  "."
}], "Text",
  CellTags->"Executing"],

Cell[TextData[{
  "Load the ",
  StyleBox["GUIKit`", "Program"],
  " package before calling any ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " functions."
}], "Text",
  CellTags->"Executing"],

Cell[BoxData[
    \(\(Needs["\<GUIKit`\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Executing"],

Cell[TextData[{
  "Here we load and execute an example user interface for a simple calculator \
that uses the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel for the calculations and, on closing, returns the results to the \
kernel."
}], "Text",
  CellTags->"Executing"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIRunModal["\<Wolfram/Example/Calculator\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Executing"],

Cell[BoxData[
    \({"FirstArgumentField" \[Rule] 45.6`, "SecondArgumentField" \[Rule] 489, 
      "SumField" \[Rule] 534.6`, "DifferenceField" \[Rule] \(-443.4`\), 
      "ProductField" \[Rule] 22298.4`, 
      "QuotientField" \[Rule] 0.0932515337423313`}\)], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Executing"]
}, Open  ]],

Cell["\<\
Here is a screen shot of what the previous interface would look like on a \
typical platform.\
\>", "Text",
  CellTags->"Executing"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>0000eB000`400?l0
0000o`00003oo`1VIWh?06IVOP0000<0IVIn0?_lo@3ko?d0o`3ko?d;0?_l
o@40IVIn00000`1VIWh0nocm0:RY^`3o0:RY^`X0Z:Vk0@3ko?d106IVOP00
00<0IVIn0?_lo@2XZK/0o`1VIWh906IVOP40Z:Vk0@3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVInF`3Pgn>[0:F//P0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0
h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[
i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK
0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[
jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
0P3Pgn<3000000040>3Oh`000000h=oS0>3Oh`80000000@0h=oS0000003P
gn<0h=oS0`0000020>3Oh`80000000@0h=oS0000003Pgn<0h=oS0`000002
0>3Oh`060000003Pgn<0h=oS0>3Oh`000000h=oS0P0000000`3Pgn<00000
0>3Oh`0a0>3Oh`030:F//P3[jn@0jn_T0400jn_T0`0000050>_[i0050000
003[jn@0jn_T0>_[i00000000P3[jn@00`000000jn_T0>_[i0030>_[i0<0
0000103[jn@00`000000jn_T0>_[i0020>_[i0<000000`3[jn@3000000<0
jn_T00<000000>_[i03[jn@00`3[jn@3000000D0jn_T00<000000>_[i03[
jn@00`3[jn@010000000jn_T0>_[i03[jn@300000080jn_T1@0000040>_[
i0030000003[jn@0jn_T00D000000P3[jn@00`000000jn_T0>_[i0070>_[
i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001P1VIWh0nocm0:RY^`1VIWh0
h=oS000000<0h=oS00@000000>3Oh`3Pgn<000000P3Pgn<2000000030>3O
h`000000h=oS0080h=oS00<000000>3Oh`0000000P3Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`000000
=@3Pgn<00`2U[;80jn_T0>_[i00o0>_[i0050000003[jn@0jn_T0>_[i000
0000103[jn@00`000000jn_T0>_[i0040>_[i0030000003[jn@0jn_T0080
jn_T00D000000>_[i03[jn@0jn_T000000030>_[i0050000003[jn@0jn_T
0>_[i00000000`3[jn@00`000000jn_T000000030>_[i0040000003[jn@0
jn_T000000@0jn_T00D000000>_[i03[jn@0jn_T000000040>_[i0030000
003[jn@0jn_T00<0jn_T00@000000>_[i03[jn@000000`3[jn@010000000
jn_T0>_[i00000070>_[i0050000003[jn@0jn_T0>_[i00000001@3[jn@0
0`000000jn_T0>_[i0070>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh000000080h=oS0P000000103Pgn<000000>3O
h`0000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`000000
0P3Pgn<00`000000h=oS000000050>3Oh`070000003Pgn<0h=oS0>3Oh`00
0000h=oS0000000e0>3Oh`030:F//P3[jn@0jn_T03/0jn_T0`0000050>_[
i0030000003[jn@0000000@000001@3[jn@00`000000jn_T0>_[i0020>_[
i0050000003[jn@0jn_T0>_[i00000000`3[jn@00`000000jn_T0>_[i005
0>_[i0030000003[jn@0jn_T00<0jn_T00@000000>_[i03[jn@00000103[
jn@01P000000jn_T0>_[i03[jn@000000>_[i0D0000000<0jn_T00000000
00000`0000000`3[jn@000000>_[i0020>_[i0050000003[jn@0jn_T0>_[
i00000000`3[jn@5000000<0jn_T00<000000>_[i03[jn@00P3[jn@00`00
0000jn_T0>_[i0070>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0000000D0h=oS00<000000>3Oh`0000000`3Pgn<0
0`000000h=oS000000030>3Oh`030000003Pgn<000000080h=oS00<00000
0>3Oh`000000100000000`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<0
000003D0h=oS00<0YJbb0>_[i03[jn@0@`3[jn@00`000000jn_T00000002
0>_[i0030000003[jn@0jn_T00D0jn_T00D000000>_[i03[jn@0jn_T0000
00030>_[i0050000003[jn@0jn_T0>_[i00000001`3[jn@00`000000jn_T
0>_[i0030>_[i0050000003[jn@0jn_T0>_[i00000000`3[jn@01`000000
jn_T0>_[i03[jn@000000>_[i00000000P3[jn@010000000jn_T0>_[i000
00020>_[i0040000003[jn@0jn_T000000<0jn_T00<000000>_[i03[jn@0
0P3[jn@010000000jn_T0>_[i00000020>_[i0030000003[jn@0jn_T00<0
jn_T00<000000>_[i03[jn@00P3[jn@00`000000jn_T0>_[i0060>_[i004
0:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh00000
00D0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<000000080h=oS00<000000>3Oh`0000000`3Pgn<01000
0000h=oS0000000000020>3Oh`030000003Pgn<0000003D0h=oS00<0YJbb
0>_[i03[jn@0@@3[jn@2000000<0jn_T00<000000>_[i00000001`3[jn@0
0`000000jn_T0>_[i0020>_[i0<00000103[jn@010000000jn_T0>_[i03[
jn@4000000@0jn_T0P0000040>_[i0050000003[jn@0jn_T0>_[i0000000
0`3[jn@01P000000jn_T0>_[i0000000jn_T000000<0jn_T00<000000>_[
i00000000`3[jn@3000000H0jn_T00H000000>_[i03[jn@000000>_[i000
00060>_[i0050000003[jn@0jn_T0>_[i0000000203[jn@0102U[;80IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000050>3Oh`03
0000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<00`0000001P3Pgn<0
0000000000000000h=oS00000080h=oS0`0000020>3Oh`050000003Pgn<0
00000000003Pgn<00`0000000`3Pgn<000000>3Oh`0a0>3Oh`030:F//P3[
jn@0jn_T04<0jn_T00H000000>_[i03[jn@000000>_[i00000080>_[i004
0000003[jn@0jn_T000000<0jn_T00D000000>_[i0000000jn_T00000003
0>_[i0030000003[jn@0jn_T00L0jn_T00<000000>_[i03[jn@00P3[jn@0
10000000jn_T0>_[i00000030>_[i0060000003[jn@0jn_T0000003[jn@0
00000`3[jn@00`000000jn_T000000020>_[i0050000003[jn@0jn_T0>_[
i00000001@3[jn@01P000000jn_T0>_[i0000000jn_T000000H0jn_T00<0
00000>_[i03[jn@00P3[jn@00`000000jn_T0>_[i0050>_[i0040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001P1VIWh0nocm0:RY^`1VIWh0h=oS000000<0
h=oS00<000000>3Oh`3Pgn<0303Pgn<00`000000h=oS0>3Oh`0>0>3Oh`03
0000003Pgn<0h=oS03<0h=oS00<0YJbb0>_[i03[jn@0?`3[jn@01@000000
jn_T0>_[i03[jn@0000000<0jn_T0P0000080>_[i0040000003[jn@0jn_T
000000<0jn_T00<000000>_[i03[jn@00P0000040>_[i0030000003[jn@0
jn_T0080jn_T00D000000>_[i03[jn@0jn_T000000040>_[i0040000003[
jn@0jn_T000000<0jn_T00@000000>_[i03[jn@0jn_T0P0000040>_[i080
00000P3[jn@01`000000jn_T0>_[i03[jn@000000>_[i00000000`3[jn@0
10000000jn_T0>_[i03[jn@200000080jn_T00D000000>_[i03[jn@0jn_T
000000040>_[i0030000003[jn@0jn_T00D0jn_T00@0YJbb06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS0`00000?0>3Oh`04
0000003Pgn<0h=oS000000d0h=oS00<000000>3Oh`3Pgn<0<`3Pgn<00`2U
[;80jn_T0>_[i0100>_[i0<000001@3[jn@00`000000jn_T0>_[i0030>_[
i0D000000P3[jn@3000000@0jn_T00<000000>_[i03[jn@00P3[jn@40000
0080jn_T0`0000020>_[i0D000000P3[jn@3000000D0jn_T00<000000>_[
i03[jn@00`3[jn@010000000jn_T0>_[i03[jn@3000000<0jn_T0`000005
0>_[i0040000003[jn@0jn_T0>_[i0<000000P3[jn@5000000H0jn_T00@0
YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS
00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i004
0:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3O
h`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3P
gn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWiK0>3Ohj/0YJbb00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS
Z`2U[;800`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
F`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0
jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W
0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000001@3Pgn<00`000000h=oS
0>3Oh`020>3Oh`<000000`3Pgn<2000000040>3Oh`000000h=oS0>3Oh`80
000000@0h=oS0000003Pgn<0h=oS0`0000020>3Oh`80000000<0h=oS0000
003Pgn<0=03Pgn<00`2U[;80jn_T0>_[i0160>_[i0<000000`3[jn@30000
00<0jn_T00<000000>_[i0000000100000020>_[i0<000000`3[jn@30000
00<0jn_T0`0000020>_[i0D00000103[jn@010000000jn_T0>_[i03[jn@3
000000<0jn_T0`0000030>_[i0<000000`3[jn@3000000@0jn_T00<00000
0>_[i03[jn@00P3[jn@3000000<0jn_T0`0000070>_[i0040:F//P1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000D0h=oS00D0
00000>3Oh`3Pgn<0h=oS000000030>3Oh`030000003Pgn<000000080h=oS
0P000000103Pgn<000000>3Oh`3Pgn<2000000030>3Oh`000000h=oS0080
h=oS00<000000>3Oh`000000>03Pgn<00`2U[;80jn_T0>_[i0150>_[i007
0000003[jn@0jn_T0>_[i0000000jn_T000000030>_[i0030000003[jn@0
jn_T00<0jn_T00<000000>_[i03[jn@00P3[jn@01`000000jn_T0>_[i03[
jn@000000>_[i00000000`3[jn@00`000000jn_T000000030>_[i0040000
003[jn@0jn_T000000L0jn_T00@000000>_[i03[jn@000000`3[jn@00`00
0000jn_T000000030>_[i0030000003[jn@0000000<0jn_T00<000000>_[
i00000000`3[jn@01@000000jn_T0>_[i03[jn@0000000<0jn_T00L00000
0>_[i03[jn@0jn_T0000003[jn@0000000<0jn_T00<000000>_[i03[jn@0
103[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn000000050>3Oh`050000003Pgn<0h=oS0>3Oh`0000000`3Pgn<00`00
0000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3O
h`0000001@3Pgn<00`000000h=oS0>3Oh`0f0>3Oh`030:F//P3[jn@0jn_T
0440jn_T0`0000050>_[i0030000003[jn@0jn_T00<0jn_T00<000000>_[
i03[jn@0103[jn@00`000000jn_T0>_[i0050>_[i0030000003[jn@00000
00<0jn_T00<000000>_[i00000000`3[jn@01@000000jn_T0>_[i03[jn@0
000000<0jn_T1@0000000`3[jn@000000>_[i0020>_[i0030000003[jn@0
000000<0jn_T00<000000>_[i00000000`3[jn@00`000000jn_T00000003
0>_[i0050000003[jn@0jn_T0>_[i00000001`3[jn@00`000000jn_T0>_[
i0030>_[i0030000003[jn@0jn_T00@0jn_T00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@000000P3Pgn<01@000000h=oS
0>3Oh`3Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000
h=oS000000030>3Oh`030000003Pgn<0000000D0h=oS00<000000>3Oh`3P
gn<0=P3Pgn<00`2U[;80jn_T0>_[i0190>_[i0030000003[jn@0jn_T00<0
jn_T00<000000>_[i03[jn@01@3[jn@00`000000jn_T0>_[i0040>_[i003
0000003[jn@0000000<0jn_T00<000000>_[i00000000`3[jn@00`000000
jn_T0>_[i0020>_[i0040000003[jn@0jn_T00000080jn_T00@000000>_[
i03[jn@000000`3[jn@00`000000jn_T000000030>_[i0030000003[jn@0
000000<0jn_T00<000000>_[i00000000`3[jn@01@000000jn_T0>_[i03[
jn@0000000L0jn_T00<000000>_[i03[jn@00`3[jn@00`000000jn_T0>_[
i0040>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0000000<0h=oS00@000000>3Oh`00000000000P3Pgn<01`000000
h=oS0>3Oh`3Pgn<000000>3Oh`0000000P3Pgn<2000000030>3Oh`000000
h=oS0080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0000000h
0>3Oh`030:F//P3[jn@0jn_T04L0jn_T0P0000040>_[i08000002@3[jn@0
10000000jn_T0>_[i03[jn@200000080jn_T100000020>_[i0050000003[
jn@0jn_T0>_[i00000001@3[jn@01P000000jn_T0>_[i0000000jn_T0000
0080jn_T00L000000>_[i03[jn@0jn_T0000003[jn@0000000<0jn_T00<0
00000>_[i00000000`3[jn@00`000000jn_T00000003000000@0jn_T00<0
00000>_[i03[jn@00`3[jn@2000000@0jn_T0P0000070>_[i0040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000<0h=oS
00D000000>3Oh`000000h=oS000000020>3Oh`<000000`3Pgn<200000004
0>3Oh`000000h=oS000000<0h=oS00<000000>3Oh`3Pgn<00`0000001P3P
gn<00000000000000000h=oS000003D0h=oS00<0YJbb0>_[i03[jn@0B@3[
jn@00`000000jn_T0>_[i0030>_[i0030000003[jn@0jn_T00H0jn_T00<0
00000>_[i03[jn@00`3[jn@00`000000jn_T000000050>_[i0050000003[
jn@0jn_T0>_[i00000001@3[jn@01P000000jn_T0>_[i0000000jn_T0000
0080jn_T00L000000>_[i03[jn@0jn_T0000003[jn@0000000<0jn_T00<0
00000>_[i00000000`3[jn@00`000000jn_T000000050>_[i0030000003[
jn@0000000L0jn_T00<000000>_[i03[jn@00`3[jn@00`000000jn_T0>_[
i0040>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0000000<0h=oS00<000000>3Oh`3Pgn<03@3Pgn<00`000000h=oS
0>3Oh`0;0>3Oh`030000003Pgn<0h=oS03H0h=oS00<0YJbb0>_[i03[jn@0
A@3[jn@01`000000jn_T0>_[i03[jn@000000>_[i00000000`3[jn@00`00
0000jn_T0>_[i0020>_[i0070000003[jn@0jn_T0>_[i0000000jn_T0000
00030>_[i0030000003[jn@0000000<0jn_T00<000000>_[i00000000`3[
jn@00`000000jn_T000000030>_[i0040000003[jn@0jn_T0>_[i0800000
0P3[jn@01`000000jn_T0>_[i03[jn@000000>_[i00000000`3[jn@00`00
0000jn_T000000030>_[i0030000003[jn@0000000<0jn_T00<000000>_[
i03[jn@00P0000030>_[i0070000003[jn@0jn_T0>_[i0000000jn_T0000
00030>_[i0030000003[jn@0jn_T00@0jn_T00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@00000403Pgn<00`000000h=oS
0>3Oh`0;0>3Oh`030000003Pgn<0h=oS03H0h=oS00<0YJbb0>_[i03[jn@0
AP3[jn@3000000<0jn_T0`0000060>_[i0<000000`3[jn@3000000<0jn_T
0`0000030>_[i0<000000`3[jn@3000000D0jn_T00@000000>_[i03[jn@0
jn_T0`0000030>_[i0<000000`3[jn@3000000<0jn_T0`0000040>_[i003
0000003[jn@0jn_T0080jn_T0`0000030>_[i0<000001`3[jn@0102U[;80
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U
[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101V
IWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb
06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0
YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F/
/P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`03
0:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOU/0h=oSZ`2U[;800`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn>[0:F/
/P0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3O
h`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3P
gn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0
h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn100000030>3Oh`040000003Pgn<0h=oS
000000<0h=oS00@000000>3Oh`3Pgn<0h=oS0`0000020>3Oh`030000003P
gn<0h=oS0080h=oS0`0000020>3Oh`050000003Pgn<0h=oS0>3Oh`000000
0P3Pgn<3000000<0h=oS0`0000020>3Oh`030000003Pgn<0h=oS02D0h=oS
00<0YJbb0>_[i03[jn@0AP3[jn@3000000D0jn_T00D000000>_[i03[jn@0
jn_T000000020>_[i0<000000`3[jn@00`000000jn_T0>_[i0030>_[i003
0000003[jn@0jn_T00<0jn_T0`0000030>_[i0<000000`3[jn@3000000@0
jn_T00<000000>_[i03[jn@00`3[jn@00`000000jn_T0>_[i0020>_[i003
0000003[jn@0jn_T00<0jn_T0`0000030>_[i0<000000`3[jn@3000000@0
jn_T00<000000>_[i03[jn@01P3[jn@0102U[;80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn000000030>3Oh`040000003Pgn<0h=oS
00000080h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3Oh`070000003P
gn<0h=oS0>3Oh`000000h=oS000000030>3Oh`070000003Pgn<0h=oS0>3O
h`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<00000
0>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`0W0>3Oh`030:F//P3[jn@0
jn_T04D0jn_T00D000000>_[i03[jn@0jn_T000000040>_[i0030000003[
jn@0jn_T00<0jn_T00D000000>_[i03[jn@0jn_T000000020>_[i0030000
003[jn@0jn_T00<0jn_T00<000000>_[i03[jn@00P3[jn@01`000000jn_T
0>_[i03[jn@000000>_[i00000000`3[jn@00`000000jn_T000000030>_[
i0050000003[jn@0jn_T0>_[i00000001@3[jn@00`000000jn_T0>_[i002
0>_[i0030000003[jn@0jn_T0080jn_T00L000000>_[i03[jn@0jn_T0000
003[jn@0000000<0jn_T00<000000>_[i00000000`3[jn@01@000000jn_T
0>_[i03[jn@0000000P0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP000000103Pgn<00`000000h=oS000000020>3O
h`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<00`000000h=oS0>3Oh`03
0>3Oh`050000003Pgn<0h=oS0>3Oh`0000001@3Pgn<01`000000h=oS0>3O
h`3Pgn<000000>3Oh`0000001@3Pgn<00`000000h=oS0>3Oh`0[0>3Oh`03
0:F//P3[jn@0jn_T04T0jn_T00<000000>_[i0000000100000080>_[i004
0000003[jn@0jn_T000000D0jn_T00<000000>_[i03[jn@01P3[jn@00`00
0000jn_T0>_[i0030>_[i0030000003[jn@0000000<0jn_T00D000000>_[
i03[jn@0jn_T000000050>_[i0030000003[jn@0jn_T0080jn_T00<00000
0>_[i03[jn@00P3[jn@01`000000jn_T0>_[i03[jn@000000>_[i0000000
0`3[jn@00`000000jn_T0>_[i0030>_[i0050000003[jn@0jn_T0>_[i000
0000203[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn000000040>3Oh`030000003Pgn<000000080h=oS00D000000>3O
h`3Pgn<0h=oS000000020>3Oh`D0000000<0h=oS0000003Pgn<00P3Pgn<5
000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`0000001@3Pgn<5
000002T0h=oS00<0YJbb0>_[i03[jn@0B@3[jn@00`000000jn_T00000002
0>_[i0030000003[jn@0jn_T00@0jn_T100000030>_[i0030000003[jn@0
jn_T00<0jn_T00<000000>_[i03[jn@01@3[jn@00`000000jn_T0>_[i003
0>_[i0030000003[jn@0000000<0jn_T00D000000>_[i03[jn@0jn_T0000
00050>_[i0030000003[jn@0jn_T00<0jn_T00D000000>_[i03[jn@0jn_T
000000030>_[i0030000003[jn@0000000<0jn_T00<000000>_[i03[jn@0
0`3[jn@01@000000jn_T0>_[i03[jn@0000000P0jn_T00@0YJbb06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000103Pgn<00`00
0000h=oS000000020>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<0
1P000000h=oS0>3Oh`3Pgn<000000>3Oh`8000000P3Pgn<01P000000h=oS
0>3Oh`3Pgn<000000>3Oh`8000000P3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<09`3Pgn<00`2U
[;80jn_T0>_[i0170>_[i08000000`3[jn@00`000000jn_T000000050>_[
i0050000003[jn@0jn_T0>_[i00000000`3[jn@00`000000jn_T0>_[i003
0>_[i0040000003[jn@0jn_T0>_[i0@00000103[jn@200000080jn_T00D0
00000>_[i03[jn@0jn_T000000030>_[i0030000003[jn@0jn_T00<0jn_T
00<000000>_[i03[jn@00`3[jn@010000000jn_T0>_[i03[jn@400000080
jn_T100000020>_[i0@00000103[jn@00`000000jn_T0>_[i0060>_[i004
0:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh00000
00@0h=oS00@000000>3Oh`000000h=oS0`000000103Pgn<0000000000000
00020>3Oh`<000000P3Pgn<00`000000h=oS000000020>3Oh`<000000P3P
gn<010000000h=oS0000000000030>3Oh`<000000`3Pgn<300000080h=oS
00<000000>3Oh`3Pgn<09@3Pgn<00`2U[;80jn_T0>_[i0190>_[i0060000
003[jn@0jn_T0000003[jn@000001@3[jn@01@000000jn_T0>_[i03[jn@0
000000@0jn_T00<000000>_[i03[jn@00`3[jn@010000000jn_T0>_[i000
00090>_[i0030000003[jn@0000000<0jn_T00D000000>_[i0000000jn_T
000000030>_[i0030000003[jn@0000000H0jn_T00@000000>_[i03[jn@0
00001@3[jn@00`000000jn_T0>_[i0030>_[i0030000003[jn@0jn_T00<0
jn_T00<000000>_[i0000000203[jn@0102U[;80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn000000030>3Oh`030000003Pgn<0h=oS
00<0h=oS00D000000>3Oh`3Pgn<0h=oS0000001<0>3Oh`030:F//P3[jn@0
jn_T04D0jn_T00D000000>_[i03[jn@0jn_T000000030>_[i08000001@3[
jn@01@000000jn_T0>_[i03[jn@0000000@0jn_T00<000000>_[i03[jn@0
0`3[jn@01@000000jn_T0>_[i03[jn@0000000@0jn_T00L000000>_[i03[
jn@0jn_T0000003[jn@0000000<0jn_T00<000000>_[i03[jn@00P000004
0>_[i08000001P3[jn@010000000jn_T0>_[i00000030>_[i0030000003[
jn@0000000<0jn_T00@000000>_[i03[jn@000001@3[jn@2000000P0jn_T
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0
00000`3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00<000000>3O
h`3Pgn<0B@3Pgn<00`2U[;80jn_T0>_[i0160>_[i0<000001@3[jn@00`00
0000jn_T0>_[i0040>_[i0<000000P3[jn@5000000030>_[i00000000000
00<000000P3[jn@400000080jn_T0`0000030>_[i0<00000103[jn@00`00
0000jn_T0>_[i0030>_[i0040000003[jn@0jn_T0>_[i0D000000P3[jn@3
000000<0jn_T0`0000030>_[i0@000000`3[jn@00`000000jn_T0>_[i006
0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0
Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T
0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3k
o?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn>[0:F//P0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3P
gn<70>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWiK0>3Ohj/0YJbb00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY
^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T
0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm
0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2X
ZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[
i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0h=oS00@000000`3P
gn<2000000040>3Oh`000000h=oS00000080h=oS00H000000>3Oh`3Pgn<0
00000>3Oh`0000150>3Oh`030:F//P3[jn@0jn_T04H0jn_T0`0000030>_[
i0<000000`3[jn@00`000000jn_T0>_[i00300000080jn_T1@0000000`3[
jn@0000000000003000000@0jn_T00@000000>_[i03[jn@0jn_T0`000003
0>_[i0<000000`3[jn@3000000<0jn_T0`0000020>_[i0D000000P3[jn@3
000000<0jn_T0`0000050>_[i0040000003[jn@0jn_T0>_[i0<000001`3[
jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
000000040>3Oh`030000003Pgn<000000080h=oS0P0000001@3Pgn<00000
0>3Oh`3Pgn<000000080h=oS00<000000>3Oh`3Pgn<0A@3Pgn<00`2U[;80
jn_T0>_[i0150>_[i0070000003[jn@0jn_T0>_[i0000000jn_T00000003
0>_[i0030000003[jn@0jn_T0080jn_T00D000000>_[i03[jn@0jn_T0000
00020>_[i0030000003[jn@0jn_T00<0jn_T00<000000>_[i03[jn@01@3[
jn@010000000jn_T0>_[i00000030>_[i0030000003[jn@0000000<0jn_T
00<000000>_[i00000000`3[jn@00`000000jn_T000000030>_[i0040000
003[jn@0jn_T000000@0jn_T00L000000>_[i03[jn@0jn_T0000003[jn@0
000000<0jn_T00<000000>_[i03[jn@00P3[jn@010000000jn_T0>_[i000
00030>_[i0030000003[jn@0jn_T00@0jn_T00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPD0h=oS00<000000>3Oh`000000
0`3Pgn<00`000000h=oS000000020>3Oh`040000003Pgn<0h=oS000004L0
h=oS00<0YJbb0>_[i03[jn@0B@3[jn@00`000000jn_T0>_[i0030>_[i003
0000003[jn@0jn_T0080jn_T00D000000>_[i03[jn@0jn_T000000030>_[
i0030000003[jn@0jn_T00<0jn_T00@000000>_[i03[jn@0jn_T1@000000
0`3[jn@000000>_[i0020>_[i0030000003[jn@0jn_T00<0jn_T00<00000
0>_[i00000000`3[jn@00`000000jn_T000000030>_[i0050000003[jn@0
jn_T0>_[i00000001`3[jn@00`000000jn_T0>_[i0030>_[i0030000003[
jn@0000000@000001@3[jn@00`000000jn_T0>_[i0040>_[i0040:F//P1V
IWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWh30>3Oh`800000
0P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000P3Pgn<01000
0000h=oS0>3Oh`0000170>3Oh`030:F//P3[jn@0jn_T04T0jn_T00<00000
0>_[i03[jn@00`3[jn@00`000000jn_T0>_[i0020>_[i0050000003[jn@0
jn_T0>_[i0000000103[jn@00`000000jn_T0>_[i0030>_[i0040000003[
jn@0jn_T00000080jn_T00@000000>_[i03[jn@000000`3[jn@00`000000
jn_T0>_[i004000000030>_[i0000000jn_T0080jn_T00<000000>_[i000
00000`3[jn@00`000000jn_T0>_[i0020>_[i0030000003[jn@0jn_T00@0
jn_T00<000000>_[i03[jn@00`3[jn@00`000000jn_T000000020>_[i004
0000003[jn@0jn_T0>_[i0@000001P3[jn@0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0>3Oh`02000000@0h=oS00H00000
0>3Oh`3Pgn<0h=oS0000003Pgn<2000000050>3Oh`00000000000>3Oh`00
0000A`3Pgn<00`2U[;80jn_T0>_[i0170>_[i0800000103[jn@2000000D0
jn_T00D000000>_[i03[jn@0jn_T000000050>_[i0030000003[jn@0jn_T
00<0jn_T00H000000>_[i03[jn@000000>_[i00000020>_[i0@000000P3[
jn@01@000000jn_T0>_[i03[jn@000000080jn_T0`0000030>_[i0<00000
1P3[jn@010000000jn_T0>_[i03[jn@2000000@0jn_T0P0000030>_[i003
0000003[jn@000000080jn_T00D000000>_[i03[jn@0jn_T000000060>_[
i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
000000H0h=oS00T000000>3Oh`3Pgn<0h=oS0000003Pgn<000000>3Oh`00
00000P3Pgn<010000000h=oS0>3Oh`0000150>3Oh`030:F//P3[jn@0jn_T
04T0jn_T00<000000>_[i03[jn@00`3[jn@00`000000jn_T0>_[i0020>_[
i0050000003[jn@0jn_T0>_[i00000001@3[jn@00`000000jn_T0>_[i003
0>_[i0060000003[jn@0jn_T0000003[jn@000000P3[jn@00`000000jn_T
0>_[i0030>_[i0070000003[jn@0jn_T0>_[i0000000jn_T000000030>_[
i0030000003[jn@0000000<0jn_T00<000000>_[i03[jn@00`3[jn@00`00
0000jn_T0>_[i0030>_[i0030000003[jn@0jn_T00<0jn_T00H000000>_[
i03[jn@000000>_[i00000020>_[i0050000003[jn@0jn_T0>_[i0000000
1P3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn000000040>3Oh`030000003Pgn<0h=oS05<0h=oS00<0YJbb0>_[i03[
jn@0A@3[jn@01`000000jn_T0>_[i03[jn@000000>_[i00000000`3[jn@0
0`000000jn_T0>_[i0020>_[i0070000003[jn@0jn_T0>_[i0000000jn_T
000000030>_[i0030000003[jn@0000000<0jn_T00@000000>_[i03[jn@0
jn_T0P0000020>_[i0070000003[jn@0jn_T0>_[i0000000jn_T00000003
0>_[i0030000003[jn@0000000<0jn_T00<000000>_[i00000000`3[jn@0
0`000000jn_T000000030>_[i0030000003[jn@0000000<0jn_T00<00000
0>_[i00000000`3[jn@010000000jn_T0>_[i03[jn@200000080jn_T00D0
00000>_[i03[jn@0jn_T000000060>_[i0040:F//P1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0h=oS00@00000EP3Pgn<00`2U[;80
jn_T0>_[i0160>_[i0<000000`3[jn@3000000H0jn_T0`0000030>_[i0<0
00000`3[jn@3000000D0jn_T00@000000>_[i03[jn@0jn_T0`0000030>_[
i0<000000`3[jn@3000000<0jn_T0`0000030>_[i0<000000`3[jn@30000
00<0jn_T0`0000050>_[i0040000003[jn@0jn_T0>_[i0<000001`3[jn@0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3P
gn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0
h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[
i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK
0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oSZ`2U[;800`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3P
gn<70>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWko0>3Oh`L0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVO_l0h=oS1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn000000040>3Oh`030000003Pgn<0h=oS00<000000`3P
gn<3000000<0h=oS0P0000001@3Pgn<000000>3Oh`000000h=oS00800000
0P3Pgn<300000080h=oS00<000000>3Oh`3Pgn<0g`3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000030>3Oh`040000
003Pgn<0h=oS000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000
h=oS000000020>3Oh`80000000@0h=oS0000003Pgn<000000P3Pgn<01@00
0000h=oS0>3Oh`3Pgn<000000><0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP0000000`3Pgn<010000000h=oS0>3Oh`00
00080>3Oh`040000003Pgn<0h=oS000000<0h=oS00D000000>3Oh`000000
h=oS000000050>3Oh`030000003Pgn<0h=oS0>80h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000000P3Pgn<010000000
h=oS0>3Oh`3Pgn<500000080h=oS0P0000030>3Oh`090000003Pgn<0h=oS
0>3Oh`000000h=oS0000003Pgn<0000000<0h=oS0P00003U0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh500000080h=oS
00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3O
h`0000000`3Pgn<01@000000h=oS0000003Pgn<000000080h=oS00D00000
0>3Oh`3Pgn<0h=oS0000003S0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0000000@0h=oS00<000000>3Oh`3Pgn<00`00
00030>3Oh`<000000P3Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`@0
00000P3Pgn<300000080h=oS00<000000>3Oh`3Pgn<0g`3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000040>3Oh`03
0000003Pgn<0h=oS0140h=oS00<000000>3Oh`000000jP3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@00000D0>3Oh`03
0000003Pgn<000000>X0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVO_l0h=oS1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0
h=oS1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn^`3Pgn<01@3Qh>@0i^GX0>c[kP3`l?80l_;d0240lo?d7P3hmoP20??c
m0080??cm@3dm?D0mOGf0?Ccm@3Ui>P0IVIn0:RY^`3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn^`3Pgn<0103Ng=l0i>;P07^G[@0UEhE3000lM007
01M=OP1[RjH0l_7^0?;al`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn^`3Pgn<0103Jf=T0IXFQ04YaT`2b_L=30<K5e`070<36a@18
KY00JXZT0>o_l@1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn^`3Pgn<00`3HeMH05den0;o7bP150<K5e`060;Jm_@0GCGh0jn[]06IV
OP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[/0h=oS00<0fMGE
000lM03oool0A@3=c=l01P3oool003ad0>SWjP1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`030=WEe@00?7@0oooo0280d]7T
00<000000=;Ai03BdN@0803BdN@01P3oool003ad0>OVj@1VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`030=WEe@00?7@0oooo
0280e]OW00<000000=KGi`3FenL0803FenL01P3oool003ad0>OVj@1VIWh0
Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`030=WEe@00
?7@0oooo00l0fM[W0`0000030=WJi`<000000P3If^L010000000fM[W0=WJ
i`0000020=WJi`040000003If^L000000=WJi`8000000`3If^L200000003
0=WJi`000000fM[W008000000P3If^L300000100fM[W00H0oooo000lM03W
i^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn^`3Pgn<0
0`3IeMD003ad0?ooo`0>0=WJi`070000003If^L0fM[W0=WJi`000000fM[W
000000030=WJi`030000003If^L000000080fM[W00D000000=WJi`3If^L0
00000=WJi`0200000080fM[W00<000000=WJi`0000000P3If^L200000005
0=WJi`000000fM[W0=WJi`0000000`3If^L00`000000fM[W0=WJi`0=0=WJ
i`060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVO[/0h=oS00<0fMGE000lM03oool03@3Ngn`00`000000g]o/0=kO
k0040=kOk0070000003Ngn`0g]o/0=kOk0000000g]o/000000020=kOk006
0000003Ngn`0g]o/0000003Ngn`000000`3Ngn`00`000000g]o/00000003
0=kOk0030000003Ngn`000000080g]o/00<000000=kOk03Ngn`04@3Ngn`0
1P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWjk0>3Oh`030=WEe@00?7@0oooo00d0hnG`00<000000>?Ul03SiO00
103SiO001`000000hnG`0>?Ul03SiO0000000>?Ul00000000P3SiO001P00
0000hnG`0>?Ul0000000hnG`000000<0hnG`00<000000>?Ul00000000`3S
iO000`000000hnG`000000020>?Ul0D000003`3SiO001P3oool003ad0>OV
j@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`03
0=WEe@00?7@0oooo00d0jN_e00<000000>W[m@3YjoD0103YjoD01P000000
jN_e0>W[m@3YjoD000000>W[m@80000000H0jN_e000000000000jN_e0000
003YjoD200000080jN_e00<000000>W[m@0000000`3YjoD00`000000jN_e
000000020>W[m@050000003YjoD0jN_e0>W[m@0000003`3YjoD01P3oool0
03ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk
0>3Oh`030=WEe@00?7@0oooo00d0l?7l00<000000?3ao03`lO`01@3`lO`3
00000080l?7l00<000000?3ao00000000P3`lO`01@000000l?7l0?3ao000
0000l?7l008000000P3`lO`010000000l?7l0?3ao03`lO`400000080l?7l
0`00000@0?3ao0060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh00004
06IVOP3ko?d0Z:Vk06IVO[/0h=oS00<0fMGE000lM03oool03P3dmOd01@00
0000m?Gm0?Ceo@3dmOd0000001/0m?Gm00<000000?Ceo@3dmOd0503dmOd0
1P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWjk0>3Oh`030=WEe@00?7@0oooo00l0m_Om0`00000L0?Kgo@030000
003fmod0m_Om01@0m_Om00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn^`3Pgn<00`3IeMD003ad0?ooo`150?Sl
o@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVO[/0h=oS00<0fMGE000lM03oool0A@3moOd01P3oool003ad0>OV
j@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`03
0=WEe@00?7@0oooo04D0oOgm00H0oooo000lM03Vi^T0IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn^`3Pgn<00`3He=@003ad0?ooo`15
0?gmo@060?ooo`00?7@0iNGX06IVOP2XZK/0nocm0@1VIWh0000406IVOP3k
o?d0Z:Vk06IVO[/0h=oS00<0fMGE02EGQ@2oc]`0A@3oool01P2oc]/09EN5
0>7Qi01VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3O
h`040=WEe@1iU:T0EGfR0<3?gD<0oooo00L0eMoX05EmXP1iUJ/0gmgP06IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`040=[G
f@3Og=P0NIBY02EGQD<003ad00L05den06J6X@3Pg]X0g=_M06IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`030=oMh03JemT0
f=CD02<0em?D7P3Cc/`30=OCe0070=SDe03IeMD0f]OI0=oMh01VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS
1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
F`3Pgn>[0:F//P0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWiK0>3Oh`030:F//P3oool0oooo0:L0oooo00@0YJbb06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0?ooo`3o
ool0Y`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2X
ZK/0IVInF`3Pgn<00`2U[;80oooo0?ooo`2R0?ooo`030000003oool0oooo
0080oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOS80h=oS1000000U0>3Oh`030:F//P3oool0oooo08d0oooo0P00000@
0?ooo`80000000<0oooo0000003oool00`3oool0102U[;80IVIn0:RY^`3k
o?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn=P3Pgn<00`000000h=oS0>3O
h`0R0>3Oh`030:F//P3oool0oooo08d0oooo00<000000?ooo`3oool0403o
ool00`000000oooo000000040?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0h=oS00@000000`3Pgn<3000000<0h=oS
0`0000030>3Oh`<000000P3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080
h=oS0P0000000`3Pgn<000000>3Oh`040>3Oh`80000000@0h=oS0000003P
gn<00000103Pgn<2000000040>3Oh`000000h=oS0>3Oh`80000000@0h=oS
0000003Pgn<000000P3Pgn<010000000h=oS0>3Oh`0000020>3Oh`<00000
0P3Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`80000000<0h=oS0000
003Pgn<0103Pgn<00`2U[;80oooo0?ooo`1o0?ooo`@000000P3oool00`00
0000oooo000000030?ooo`030000003oool0000000D0oooo00D000000?oo
o`3oool0oooo000000020?ooo`<000000`3oool00`000000oooo00000004
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0000000@0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0000
00030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3P
gn<00`000000h=oS000000020>3Oh`800000103Pgn<00`000000h=oS0>3O
h`02000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`3Pgn<00P00
0000103Pgn<000000>3Oh`3Pgn<2000000050>3Oh`000000h=oS0>3Oh`00
00000P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000<0
h=oS00<000000>3Oh`000000203Pgn<00`2U[;80oooo0?ooo`1n0?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`000000oooo000000030?oo
o`030000003oool0000000D0oooo00<000000?ooo`3oool00`3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`000000103oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@3P
gn<00`000000h=oS000000050>3Oh`030000003Pgn<0h=oS00<0h=oS00L0
00000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`00
00000`3Pgn<00`000000h=oS0>3Oh`020>3Oh`070000003Pgn<0h=oS0>3O
h`000000h=oS000000030>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS
000000030>3Oh`030000003Pgn<000000080h=oS00H000000>3Oh`3Pgn<0
00000>3Oh`0000050>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS0000
00080>3Oh`030:F//P3oool0oooo08<0oooo00D000000?ooo`000000oooo
000000030?ooo`030000003oool000000080oooo1@0000080?ooo`060000
003oool0oooo0000003oool00000103oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<200000080h=oS1@000000
0`3Pgn<000000>3Oh`040>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS
000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0
0`3Pgn<4000000030>3Oh`000000h=oS0080h=oS00L000000>3Oh`3Pgn<0
h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000000P3Pgn<01@00
0000h=oS0>3Oh`000000h=oS00D0000000<0h=oS0000003Pgn<00P3Pgn<0
0`000000h=oS000000080>3Oh`030:F//P3oool0oooo0840oooo0P000002
0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000P3oool0
10000000oooo0?ooo`0000090?ooo`060000003oool0oooo0000003oool0
0000103oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0>3Oh`02000000@0h=oS00L000000>3Oh`3Pgn<0h=oS0000003P
gn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<010000000h=oS0000
000000020>3Oh`030000003Pgn<000000080h=oS0P0000040>3Oh`060000
003Pgn<0h=oS0>3Oh`000000h=oS0P0000020>3Oh`030000003Pgn<0h=oS
0080000000<0h=oS0000003Pgn<00P3Pgn<01@000000h=oS000000000000
h=oS0080000000@0h=oS0000003Pgn<000000`3Pgn<010000000h=oS0000
000000020>3Oh`030000003Pgn<0000000P0h=oS00<0YJbb0?ooo`3oool0
O`3oool2000000@0oooo00@000000?ooo`00000000000P3oool00`000000
oooo000000030?ooo`030000003oool0000000D0oooo100000030?ooo`03
0000003oool0000000@0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP0000001`3Pgn<3000000<0h=oS0`0000030>3O
h`<000000P3Pgn<010000000h=oS0000000000030>3Oh`80000000<0h=oS
0000003Pgn<0103Pgn<300000080h=oS00<000000>3Oh`0000000P3Pgn<2
000000040>3Oh`000000h=oS000000<0h=oS00D000000>3Oh`000000h=oS
000000020>3Oh`040000003Pgn<0h=oS0>3Oh`<000000P3Pgn<01@000000
h=oS000000000000h=oS00<0000000<0h=oS0000003Pgn<0103Pgn<00`2U
[;80oooo0?ooo`1n0?ooo`030000003oool0oooo00@0oooo00@000000?oo
o`000000oooo0P0000020?ooo`070000003oool0oooo0?ooo`000000oooo
000000050?ooo`030000003oool0oooo00@0oooo00<000000?ooo`000000
103oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn000000040>3Oh`030000003Pgn<0h=oS01/0h=oS00<000000>3Oh`3P
gn<0;03Pgn<00`000000h=oS0>3Oh`060>3Oh`030:F//P3oool0oooo07h0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`000000103oool0102U[;80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn0>3Oh`04000001h0h=oS00<000000>3O
h`3Pgn<0;03Pgn<00`000000h=oS0>3Oh`060>3Oh`030:F//P3oool0oooo
07l0oooo100000020?ooo`030000003oool0oooo00D0oooo0P0000040?oo
o`030000003oool0oooo00@0oooo100000001@3oool000000000003oool0
000000@0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOU/0h=oS00<0YJbb0?ooo`3oool0XP3oool00`000000oooo0?oo
o`020?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWiK0>3Oh`030:F//P3oool0oooo0:80oooo00<000000?ooo`3oool0
0P3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVInF`3Pgn<00`2U[;80oooo0?ooo`2R0?ooo`030000003oool0oooo0080
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OU/0h=oS00<0YJbb0?ooo`3oool0XP3oool00`000000oooo0?ooo`020?oo
o`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK
0>3Oh`030:F//P3oool0oooo0:L0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oSZ`2U[;800`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3P
gn>[0:F//P0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWiK0>3Oh`030:F//P3oool0oooo0:L0oooo00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0?ooo`3oool0
Y`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVInF`3Pgn<00`2U[;80oooo0?ooo`2W0?ooo`040:F//P1VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWhR0>3Oh`@00000=@3Pgn<00`2U
[;80oooo0?ooo`2W0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101V
IWh0nocm0:RY^`1VIWhV0>3Oh`030000003Pgn<0h=oS0380h=oS00<0YJbb
0?ooo`3oool0Y`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn000000050>3Oh`030000003Pgn<0000000@0h=oS0`00
00020>3Oh`8000001@3Pgn<2000000040>3Oh`000000h=oS000000@0h=oS
0P000000103Pgn<000000>3Oh`3Pgn<2000000040>3Oh`000000h=oS0000
0080h=oS00@000000>3Oh`3Pgn<000000P3Pgn<300000080h=oS00H00000
0>3Oh`3Pgn<0h=oS0000003Pgn<2000000030>3Oh`000000h=oS01@0h=oS
00<0YJbb0?ooo`3oool0U`3oool3000000D0oooo00<000000?ooo`3oool0
1@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn000000050>3Oh`030000003Pgn<0000000<0h=oS00L000000>3Oh`3P
gn<0h=oS0000003Pgn<0000000D0h=oS00<000000>3Oh`3Pgn<00P000000
0`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<0h=oS0080000000@0h=oS
0000003Pgn<0h=oS0P0000001@3Pgn<000000>3Oh`3Pgn<000000080h=oS
00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`030000
003Pgn<0000001P0h=oS00<0YJbb0?ooo`3oool0UP3oool01@000000oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01@3oool0102U[;80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000050>3O
h`030000003Pgn<0000000H0h=oS00@000000>3Oh`3Pgn<000001@3Pgn<0
1`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<01`000000h=oS
0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000020>3O
h`060000003Pgn<0h=oS0000003Pgn<000001@3Pgn<01`000000h=oS0>3O
h`3Pgn<000000>3Oh`000000603Pgn<00`2U[;80oooo0?ooo`2J0?ooo`03
0000003oool0000000@000001P3oool0102U[;80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn000000050>3Oh`030000003Pgn<00000
00@0h=oS0P0000030>3Oh`030000003Pgn<0h=oS00@0h=oS100000000`3P
gn<000000>3Oh`020>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS0000
00030>3Oh`030000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<00000
0>3Oh`05000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`000000
603Pgn<00`2U[;80oooo0?ooo`2J0?ooo`030000003oool000000080oooo
00<000000?ooo`3oool01@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn100000020>3Oh`040000003Pgn<000000000
0080h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000D0h=oS00H0
00000>3Oh`3Pgn<0h=oS0000003Pgn<200000080h=oS00<000000>3Oh`3P
gn<00P0000000`3Pgn<000000>3Oh`020>3Oh`050000003Pgn<000000000
003Pgn<00P000000103Pgn<000000>3Oh`0000030>3Oh`040000003Pgn<0
000000000080h=oS00<000000>3Oh`000000603Pgn<00`2U[;80oooo0?oo
o`2H0?ooo`8000000`3oool00`000000oooo000000070?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000D0h=oS
00D000000>3Oh`000000h=oS000000020>3Oh`<0000000@0h=oS00000000
000000001@3Pgn<300000080h=oS00<000000>3Oh`0000000P3Pgn<20000
00040>3Oh`000000h=oS000000<0h=oS00D000000>3Oh`000000h=oS0000
00020>3Oh`040000003Pgn<0h=oS0>3Oh`<000000P3Pgn<01@000000h=oS
000000000000h=oS00<0000000<0h=oS0000003Pgn<0503Pgn<00`2U[;80
oooo0?ooo`2J0?ooo`060000003oool0oooo0000003oool000001`3oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0000
000A0>3Oh`030000003Pgn<0h=oS02d0h=oS00<000000>3Oh`3Pgn<05P3P
gn<00`2U[;80oooo0?ooo`2F0?ooo`050000003oool0oooo0?ooo`000000
0`3oool2000000L0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOPD0000000<0h=oS0000003Pgn<02P3Pgn<00`000000
h=oS0>3Oh`0]0>3Oh`030000003Pgn<0h=oS01H0h=oS00<0YJbb0?ooo`3o
ool0U`3oool3000000D0oooo00<000000?ooo`3oool01@3oool0102U[;80
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U
[;80oooo0?ooo`2W0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101V
IWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3oool0oooo0:L0oooo00@0YJbb
06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0
YJbb0?ooo`3oool0Y`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80oooo0?ooo`2W0?ooo`040:F/
/P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`03
0:F//P3oool0oooo0:L0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOU/0h=oSZ`2U[;800`1VIWh0Z:Vk0?_lo@0106IV
OP0000<0IVIn0?Ogn@2HV:L0o`1gMi8907MgTP40V9RW0@3gmoT106IVOP00
00<0IVIn0?Ogn@2l_Ld0o`2l_Ld:0;bmc@40moOi0@1VIWh0000306IVOP3g
moT0i>?S0?l0i>?S2P3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`32
0?ooo`030>CSh`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[
MHl01P2LY;T0i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/
MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0
YcY40:HiA02W>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d
0@1VIWh0000F06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl
0?clo@3lo?`0o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0
no_m0?_lo080o?cl00@0o?cm0?clo03knod0o?cmA@3lnoa50?_lo1l0nocm
00<0W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]e
Sa40QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:HiA02L
Y;T0nocl0?clo03lnod0nocm0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0
moOi0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kg
n@3gmoT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0
moOi0?Ogn@140?OgnDD0m_Oi7`3gmoT00`1[MHl0QHV`09bN_P0@09bN_P06
08F9/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03g
moP0YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh
0?Ogn@3gmoP0moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3a
m03`l_@@000000060?7am03`l_D0lO7d0?7bm03`l_@0lO7dRP3`lODO0?3a
m00306]eS`2b]M00YjS20100YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b
]M0A0:NX`P050;:ed01[MHl0l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN
0<eIGP0;0<eIGP040<]DF@32DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03N
gN400@1VIWh0000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__000000020>OW
i`80g]kN0P3WinL00`3W_H@0inOW0>OWi`030>OWi`80kno_00@000000>[[
l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`0>CGeP030<O2d@040<O2g03Ii>/0
j^_[0=W9d@80al;A00X0dmOQ0<g2d@3=en/0j^_`0=o@d@37`]40dmg`0>[[
l03ZjnD0dl;A0P37`]400`3=en/0j^_`0>[[l0050>[[l0060=o@d@3CgO00
j^_`0>[[l03ZgM`0am3U0P3Zjo001P3Zjn/0fLWA0<O2g03Ojo00j^_`0>[M
g080al;A00@0alWQ0>C[i@3C`]40am3U0P3Zjo000`3TemH0al;F0=WTl004
0>[[l0060>CGeP37`]H0fNC`0>[[l03ZgM`0cMO[0P3Zjo00103Od=40al;L
0=o/j`3IbM420<O2d@050=?Hh@3=`]40cMS[0>[/l03Zgm`00P37`]401037
bN40i>cU0=?2d@37d>D20>[/l0050>CHeP37`]H0fNG`0>[/l03Zgm`00P37
`]404037`]H0fNG`0>[/l03ZiN40cL;A0<gHj`3Zk?00j]oL0<O2d@3Cgo00
j^c`0>[Og037`]40dmo`0>[/j`3IbM420<O2d@050=?Hh@3=`]40cMS[0>[/
l03Zgm`00P37`]402037bN40i>c[0=W9d@37`]`0gnc`0>[/l03Zk>D0dl;A
0P37`]40103=f>/0j^c`0>[/j`3IbM420<O2d@030=?Hh@3=`]40cMS[01l0
j^__00@0JgF?0;Jid@2][/H0[Jk6203oool00`2][/H0[:k60:f^aP030:f^
aP030:b^aP2f^M40JgF?0080j^__00@0JgF?0;Jid@2][/H0[Jk6303oool2
0:f^aP030:b^aP2f^M40JgF?0080j^_`00D0YSU40<eIGP3;E5T0cEIK0<iI
G`0;0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0j^__0>[[l0020>[[k`40
g=_P0@1VIWh0000406IVOP3IfMl0hnGZ0>?TjP80hnG[00D0000008b<S03N
g]h0inOW0=kNgP020>OWi`030<IS003WinL0inOW0080inOW00L0knoW0>o_
k`3_knl000000>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[0<B4@@0>41000P0>
4100100=3f`0QK2h0=3Ic`2:@0l200h@400:06Z>S`103`l0>gVh0=3Ij`2[
J`l03Q0@05jGgP3OiN/0hnFZ068?3`803Q0@00<0A8k;0=K8d@3@fN/01@3S
iN/03P2[J`l0HY?A0<O8gP3OiN/0hje^00eQWP37`]T0f^G[0>?Uc`2=A@l0
3@mS09K2f@3JiN/0hje/0P0>41002P0=AI40b>Fa06X?3`0=G9h0alkR0>?U
j`38STH03@m107^[eP3Fgn/30>?Uj`0<0<R>AP0=3d40Nj_A0=3Ij`3S[Fh0
@H2h0<O8gP3OiN/0Zf/?00d?H`2Fc/L0RT0?0P0>41001@1ZSXh0@0l?03]i
^03@fNX0hja[00803Q0@00/03DFA0<ST/01Z3`l03EbN0<O>hP3Si>X0b8i6
00d?@@1kZmH0e]oZ0>>XJ00200h@400@00d?AP2=a=h0c<SN0=o8T@143`l0
?WVh0<cCi@3S[6h03Q0@05jCd@3@fNX0hja^00h@401NTm40d=W>08Y03`80
3Q0@00D0JXj>040?3`0kNKP0d=WZ0>>/J`0200h@400800e5T@38i<h0SDD?
00d?H`2F`]T0f^CZ0>?TZP1R3`l200h@400404B>b@3Fb=40d=W>08Y03`80
3Q0@00@0JXj>040?3`0kNKP0d=WZ7`3SiNX01@1[MHl0_;kD0;:bbP2b//X0
oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0JgF?0>?UjP3S
iNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH02@0U9CH30;:bbP050;bn
e01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?ooo`3oool70=AL
G`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0
fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0g=kV00D000000>OWi`3WinL0
inOW0>OFcP020>OWi`050<ik003_U100inOW0>ONaP3_S1000`3_knl07`00
0000g=kV0=cNi@3Lg^D0g=kV0=cNi@31RT<03Q0@05jJgP3Lg^D0g=k908Q3
3`1WZ>D0`HY500h@401NTm@0d]W908Q33`0>4100GY?D0=;I[@1W3`l03C^2
0:o7f`3HgZd0I`l?00dkPP2eeND0g=k908Q33`1WZ>D01@3Lg^D06`3LgZd0
I`l?00dkPP2_`]@0d]WU0:EV3`0=3f<0U/;A0<kEi@3Lg/T0R4<?00d?H`2F
`]P0eMk908Q33`0=>h80[lOK0=SNi@3LgZd0I`l?00eLWP37c=h0g=kU0<6:
A@0=3d00Nj_D0=;Ii@030=cNi@1?0=bXJ`0>4100Gi?A0<_@hP2UJ0l03C^2
0:o2e03BfLT0R4<?00eLWP2cPT@03Q0@05jCe03BfLT0R4<?00h@401NTm@0
d]W908Q33`0=>h80[lOK0=SNi@3LgZd0I`l?00eLWP37c=h0g=kU0<6:A@0=
3d00Nj_D0=:oSP103`l03EbP0=;Ii@3La8h0@D>>0<7Ni@3La8h0@@l?03ai
^03;d>80g:Q[00h@401NTm40c]GU0=bXJ`0>4100GY?A0;F5A@0>4100GY?D
0=;Ib@28@`l03Q0@05jCe03BfLT0R4<?00dkPP2_am/0f=kU0=cNb@28@`l0
3@mS09K2f03EgZd0I`l?00dkPP2eeND0g=k908Q33`1WZ>D0`HY500h@401N
Tm@0d]W908Q33`0>4100GY?D0=;Ii@0O0=cNi@0506]eS`2o`MH0^;W>0;Ri
cP3oool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU
0=cNi@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U
9CH0^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AM
H@1C9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA002
0=cNi@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>42
0=GHh0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080
gV/000D0kkF<0>o_k`3_knl0kno_000000020=GHh@060=GGh03Ff>00e]RZ
06@?3`0=G9h0c=3P103Fen003`2lQD@03@m107^[d@39cMh0XVD?00d?@01k
Zm<0cm>Z06@?3`0=>h80[lKI0=BSJ@0>4100GY?C0<oCh0080=KGh00K0=JS
J@0>41003@m107nad@39]8X0?`l?00h@401QU]40alWK0=KGa@25@@l03@mS
09K2eP3AejX0I0l?00dkPP2_a]T0e=OP0=KGZP1T3`l03EbN0<O9f`3Fen00
_8E400d?@01kZm<0cm?P00<0e]OP0240e[f;040?3`0nNKP0bLfX06@?3`0=
3d40P;7A0<W=Z01T3`l0?7Vh0;B2A00=3d40Nj_A0<W=gP2RIPl03@m007^[
d`3?e:X0I0l?00dkPP2_a]T0e=SP0=KHZP1T3`l03EbN0<O9f`3Ff>00_8I4
00d?@01kZm<0]XA400d??`1kZm401037`]407`37/HP0@0l?03ai^039cMh0
eZ=Y00h@401NTm40c=7P0=JSJ@0>4100GY?A0;B2A00=3d40Nj_A0<W=gP2R
IPl03@m007^[d`3?e:X0I0l?00dkPP2_a]T0e=SP0=KHa@25@@l03@mS09K2
eP3AXfT03Q0@05jCd`3?e>000`3Ff>00202lQT@03@m107^[d@39cMh0XVH?
00d?@01kZm<0cmCP7`3Ef>401@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf
1`2l_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU
=P2l_M401`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP
0=GGh@2V>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool0
0`167QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM
0@1VIWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<
0>ONcP36BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh0
00000`3@d]`01@3?d]`0d9iW00h@401NTm<0c<oL00@0d=;L00l0d9iW00h@
400nOk`0al;A0:mi?`0=3cl0Nj_C0<c?YP1R3`l03C^20:o4eP2fPd<03@m0
07^[d@3:c=`0203@d]`06`2MH`l03@mS05iO3`0nOk`0[gU000eMPP1m?Pl0
3F2O0<O2e@3=d/40PD0?00d?H`2F`]D0cM:V068?3`0=>h80[lCF0<oBg03@
dZH0HPl?00eLWP37b=P0d=;L0;R3@`0=3d00Nj_C0<c?g0030=3Bg00O0=3B
YP1R3`l0?WZh0<NGIP0=?880O60?03io_037[8D0?Pl?05jCd`3;W6P03Q0@
03io_037`]40[gTo00d??`1kZm<0blnW064?3`0=>h80[lCG0<gBg@3?dZL0
H@l?00eLWP37b=T0cm;M0;J3@`0=3d00Nj_C09UR3`0500h@400P00eLWP37
/8H0?Pl?03ai^038b]/0ciiX00h@401NTm40bLcM0<nNJ00>4100GY?A0<VJ
J00>4100?Wnl0<O2d@2_NCl03@lo07^[d`3;cjL0H@l?00dkPP2_a=L0cM;M
0<oB``20@0l03@mS09K2e@2dPd<03@m007^[d@39c=d30<oBg@080<nNJ00>
4100?Wnl0<O2d@2_NCl03@lo07^[d`3;cmdO0=3Bg00306]eS`38bM/0`lCF
0100`lCF00H0b<WK06]eS`3@d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U
9CH0`lCF00L0`lCF00<0oooo02DU=P33a=H00P33a=H01`38bM/0JgF?0<oB
g03?d]`0YSU40=MOG`3IHF800`3LIFD01@167QX0oooo0?ooo`3oool0g6EU
00<0oooo00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L
0@3?d]`10=;Dg@40IVIn00007P1VIWh0d=;K0<_=f03:cMT0blkH0<[=f000
0000ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU003FS000cV/00>O6
003oeP00knoW0>o_k`000000blgH0<_=f@3:cMT0blkH0;:0@@0=3d00Nj_C
0<W<f@D0blgI0180bi]V00h@400>41003Q0@00d??`1kZm<0bLfT05l?3`0=
>h80[lCE0<ZKIP0>4100GY?A0<O4e@3:cMT0blgI0<W6d`39c=T30<_=f@0L
0<_=Y01O3`l03EbN0<RHIP0=3d40?3`?05jDe@2bP4403@mT09O2d@38bKl0
OSl?00d?H`2F`]<0bLfT05l?3`0=>h80[lCE0<[=f@3;cJ@0G`l?00eLWP37
a=D0b/gI0;>0@@0=3cl0Nj_C0<W=f@<0blgI00`0blfo07ho3`0=GYh0UUd?
03ai^038V6H03Cj50:nCI00=3d00Nj_C0<W>f@3;W6H300h@400S00d??`1k
Zm<0bLjT05l?3`0=>h80[lCE0<[>f@3;cZ@0G`l?00eLWP37a=D0b/kI0;>0
@@0=3cl0Nj_C0;60@@0=3d00O:_A0<S8e`3;cZ@0G`l?00eLWP38/XH0?0l?
03ai^037a=D0bYaV00h@401NTm40b<SG0<^LIP0>4100GY?C0<W<f@3;W6H0
0`0>4100500=3cl0Nj_C0<W>Y01O3`l03C^20:o4e@3:c]T0bljo07ho3`0=
3f<0U/;C0<VLIP0>4100GY?A0<O4e@3:c]T0blkI0<W6d`39c=T0biaV0`0>
41000`0=3cl0Nj_C0<W>f@0O0<_=f00306]eS`3;c=h0b<[I00P0b<[I00<0
b<WI0<S:f@38b]T00`38b]T01038bMT0b<[I0<_<gP1[MHl20<_=f00606]e
S`3;c=h0b<[I0<S:f@3oool09BDf1@38b]T04@38bMT0b<[I0<S:f@3oool0
9BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0eemO0=]TI03P
IfD0h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3oool02P167QX0gVMW0=iW
I`3PIVD0h6MU0=]TI03GGel0YSU40<[>f03:c]T20<_=f@40d=;K0@1VIWh0
000306IVOP3?cmX0aLSD00<0aLSD00H000000<K6aP3Wg]H0cW/00>N]003_
]@020>NU00030=JD003>L`00eY@00080mlH00P3gmoL02@000000aLSD0<G7
e035am@0aLOE0:il@00=3d00Nj_A0<K5e@060<C7e@0@0<C4d@37`]40UU`?
00d?H`2Ea]D0a<NQ05`?3`0=>h80[l?C0<C7X@1L3`l03Cb40:k3d@37`]40
UU`o07^/d`@0a<OE01/0a9MT00h@401NTm<0a<Nl07Tl3`0=?8<0[lCD0<B_
Q@0k3`l0GI?A0<O3^P1j?0l03@mS09K2d`34aj00G@l?00dkPP2_`]40al;A
0<O4W`1L3`l03C^20:o2d@37`[P0Nc/?00d?H`2Ea]D01@34amD02@2DGPl0
3Ca003/?3`1NTm<0a:n503/?@01MGCl03@mS09K4d`020<C8e00T0<C4d@37
`]40UU`?00d?H`2Eam@0a<RO05d?3`0=>h80[l;A0<O2d@37a9l0G0l?00dk
PP2_`]40al:h07/k3`0=3f<0ULOD0<B`Q00k3`l0>gbj0<K2d@37Tf<03Q0@
05fEd`34/8@0>`l?00dkP`2^aM80[gTo00h@400kNkX0a<GB0:mi?`0=3cl0
NjkC0P34b=@05@34a=40al;A09IL3`0=3f<0ULOD0<C8W`1M3`l03C^20:o2
d@37`]40alBj07Tl3`0=3f<0U/;B0<C8X01L3`l03Cb40:k3d@37`]40UU`o
07^/d`020<C8e0060<C4d@37`]40UU`?00d?H`2Eam@0a<SD7`34am@00`1[
MHl0d=7P0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P0P3;
bm`00`3oool09BDf0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080bl_L00L0
d=7P06]eS`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ0?ooo`3o
ool0oooo04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD0@35amD1
0<o?fP40IVIn0000101VIWh0c<kJ0<;4dP31a=420<74dP060000003WinL0
inOW0>OWi`3FQ000kkD00P3WY@00203FQ000cV/00>N]003g]@00mkd00>o_
k`3gmoL000000`31a=801P32a=40`IAS00h@401MTm40al;A0<;4d@@0`LCA
00d0TUd?00h@400>41003@lo07R/d@31a=40`LBN05/?3`0=>h80[l;A0<;4
d@31a;P0N3`?00803Q0@00<03Cb20:[4d@31a=400P31a=404031a;P0N3`?
00dlPP2Za=40`LCA0:Yj?`0jN[P0`LCA0<74^01h?0l03Cb207QM3`0>4100
3@mS09;4^01h?0l300h@400300eMWP31a9h0F`l?00<03Q0@00<03@lo07R/
d@31a=401@31a=402`2ZNSl03Q0@00d?H`2F`m40`LBh07Pl3`0>41003EbN
0<K3d@31a=80TUd?00803Q0@00@03@m007R/dP31a;P0N3`?0`0>41000`0=
GIh0`LBN05/?3`0300h@400600d?@01h[=80`LCB0<74dP31[8<0>Pl?0P0>
41001@0jN[P0`LCB0<6/P`0j3d00N7YS00803Q0@00D0>WZh0:Yj@00>4100
3Q0@03Yj^0020<74dP07099M3`0>41003Q0@00d?@01h[=80`LBh07Pl3`03
00h@400800eMWP2BG@l03Q0@00d?H`2Ba=80`LCB0<74^01h?0l200h@4004
00dlP`2Za=80`LCB099M3`803Q0@00@03@m007R/dP31a=80`LCB7`32a=80
0`1[MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R
0P3?d=d00`3oool09BDf0<o@g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M
00L0dm?R06]eS`32a=80`LCA0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/
J@080>5YI@3KI6@0YSU40<74dP32a=40`LCA0<74dP3<c]X106IVOP0000@0
IVIn0<[<f02n`<l0_L3?0P2n`<h01@000000W9bL0>OWi`3Wg]H0eX`00080
gY@000@0eW/00<IS002m@P00kjD00P3g[@00403g]@00oli:0000002n`<h0
_/3?0;k0cP2n`<l0_L2L05X?3`0=>h80[l;A0<G1c`2n`<h0_/3?0<?1d033
`<h60;k0cP050;k0W01J3`l03C^20:o1c`30`<h05P2n`<h02`31`M40al;@
0<70W01J3`l03C^20:o1c`30`<h0_/2L05X?3`0=G9h0al7?00T0_/3>00T0
_Y5Q00h@400=G9h0aL7?0;k0cP2WMcl03Q0@03]i^034`<h01`2m`<h02@2m
`9`0FPl?00dkPP2_`Ll0_l3>0;g0W01J3`l03EbN0<O1c`0M0;g0cP050;g0
W01J3`l03C^20:o1c`2o`<h00P2m`<h00`30`M40al;@0<30cP0>0;g0cQl0
_/3>00<0JgF?0=KFi03Cdn00403Cdn001P3Fe^@0JgF?0;k0cP2n`<h0JgF?
0=KFi080dm?P00<0oooo02DU=P3oool0203oool02`0U9CH0dm?P0=?Ch03C
dn00e]KT06]eS`2n`<l0_/3>0:HiA03PIVD0hFYZ00@0hfa/0`3oool01016
7QX0oooo0?ooo`3oool40>=/K0040>5ZJP3PIVD0YSU40;g0c`80_/3?0@2n
`<h10<[<f040IVIn00001`1VIWh0bL[H0;Jhb02i_</0^[c;0;Zlc0000000
0P3_knl06@3FW000eX`00=jD003FQ000kjD00=j<002mFP00eW<00>nL003g
knL0moOg0?ooo`000000^Kc<0;Zkc02i_</0^[c;0;Vlc02iSV003Q0@03Ue
]P34`]40al:h07/k?`1kZLh01`2i_<`01@2i_9X0E`l?00dkPP2_`Ll0_;c<
01D0^Kc<00`0S5X?00d?H`2F`/l0_[c<08aJ3`0=>Wl0Xkc<0;Vlc02i_9X0
E`l?00eLWP37`<h90;Vlc0090;VUO`0i3`l0>WVh0<2lc02i_<`0^HiQ00h@
401LTm00`;c<00P0^[c<00P0SEX?00djO`2T_<`0^[c<0;ZlVP1G3`l03EbN
0<O0cQh0^[c<00<0SEX?00djO`2T_<`00P2j_<`0102=FPl03@mS09K2c`2n
_<`>0;Zlc1l0^[c;00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?0;Zl
b`2j_</0JgF?0=SHi@80dm?Q00<0oooo06i]S`1^KHl0201^KHl03P0U9CH0
dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<0:HiA03PJFP0hFe/0>AaK@3T
LFl0i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^00T0i75]0>5]
K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039b]P00@1VIWh0000906IVOP37
bML0];K70;Jhb02f^<T0][W900000024Q8@0inON0080kno_00L0aV/00?O6
003_]@00ki`00=j<003>J`00ii`000<0moOg00D000000;Jib@2g^<T0][W9
0;Nib@020;Jhb@050;NRO@0g3`l03Q0@00h@400=EiP0202g^<T0102g^9P0
EPl?00diO@2Q^<TF0;Nhb@0308YG3`0=3el0R[S900D0]kS900<0]kRH05H?
3`0=EiP02P2g^<T00`2g^9P0EPln076Rb@020;Nhb@040;NhV01F3ch0LJ;9
0;Nhb@`0][S900<0][RH05H?3`0=EiP0902f^<T00`29E`l03@mO08Vhb@0?
0;JhbAl0]kS900@0JgF?0=KFi03Hf>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3H
f>H20=SHi@090=KFi01[MHl0]kS90;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo
00X0KVf?00d09BDf0=SHiP3Hf>D0f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0
i6i]0>AdK`3WLFl0i7A_00<0oooo00D0AQhJ0>AdK`3TM6l0i7A_04HN6P03
0?ooo`0:0>AdK`3WLFl0i7A_0>A^K@2V>D@0][W90;Jhb@2f^LT0];K70<O9
e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`030000003_knl0kno_0080
kno_00/0ijd00?O6203WY@00ii@00>N<003_imH0gY@i0>oF]@3omoL0oooo
0000002_0;Bfa`0506]eS`3EeN<0g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0
JgF?0;Bfa`2d]/L0JgF?0=GEh`80g=_W00<0gM_W02DU=P0U9CH02@0U9CH3
0=cKi`090=GEh`1[MHl0];K70;Bfa`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080
oooo00<0AQhJ0>UnN03YOWP00`3YOWP020167QX0oooo0?ooo`3ZN7H0jWIc
0>MeLP3WLfl0YSU4102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;Bfa`03
0;Bfa`060000002<S8`0kno_0>o_k`3WcW/0kno_0P3gmoL0203WU000mnO>
0?Ogm`3gmoL0knOF0?Ogm`3oool00000[`2d]/L00`1[MHl0eMCS0>3OjP0@
0>3OjP060=GDh`1[MHl0];K70;Bfa`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?
0;Bfa`2d]/L0YSU40>YiL`3YO7P0kh5j0?:9P@0204HN6P070>^HR`3ZVh`0
kIN:0>^HR`3ZVh`0kIN:0>^HR`0204HN6P050?:9P@3_PGX0jGah0>YiL`2V
>D@0102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;6cb0030;6cb0060000
003_knl0kno_0>o_k`3gmnl0kno_0P3gmoL00`3gilH0moOg0?ooo`030?Og
m`030?ooo`000000/K?80:h0/K?800<0JgF?0>g[l`3Yj?40403Yj?401P3]
jo<0JgF?0;6cb02a/lP0JgF?0>g[la40jNSa01T0kN_c06]eS`2a/lP0/K?8
0:HiA03aP7D0l8Al0?F<Q03gWHh0lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0
k;FL0?6bV`3]]9/0k;FL0?:[UP3gWHh0mHb40?24O03aP7D0YSU400@0/K?8
0@36b=L106IVOP0000<0IVIn0<K8e`2h]ll00`2_[/L01@000000[Jf]0?Og
k`3gmoL0kno_00H0moOg0P3omoL20?ooo`030000002_[/L0[jk70:d0[jk7
00<0JgF?0=;Ah`3blOL0403blOL01P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;A
ha40l_7g00H0d]7S06]eS`2_[/L0[jk70:HiA03dRWd20?F@Q@d0l[RN0P3e
T8D00`3dRWd0YSU40:n^a`020:n^a`40^;O?0@36b=L106IVOP0000<0IVIn
0<31d@37am@0`P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<
bmd0JgF?08B<XP80[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0
c<_M06]eS`24S:820:b[a007096HZP2V>D@0oin=0?joY03jg;L0n^^g0?[Y
]P020?WY]P040?[Y]P3ijKH0nNVf0?[Y]P80nNVf00H0n^^g0?[L]`3n_j@0
oin=0:HiA02AV:X30:b[a040alOD0@30`M4106IVOP0000@0IVIn0<31d@3B
d]l0]KC9`P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n
0080Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS
_P0308B<XP2V>D@0YSU400l0YSU400L0Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3B
d]l0`<7A0040IVIn00001P1VIWh0Z:No0>KVk@3Bd^00_;c?0;6`a?l0Z:No
0`2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`3oool0QhNK
0=OHhP3lo?`0i>?X0=3@h03:b]X0o`2l_<l10;blc`060<[:fP3@d>00i>?X
0?clo03Gf>80QhNK0@00M;l000080?ooo`1VIWh0UIB[0=OHhP3lo?`0l_7c
0>c[kP3Qh^_n0=OHhP070>7Rj`3/jnh0l_7c0?clo03Gf>80UIB[06IVOP01
0?ooo`000P3oool00`1VIWh0UIB[0=7AgP020?clo?l0oooo0@3oool20?cl
o0030=7AgP2EU:/0IVIn0080oooo00030?ooo`80IVIn00<0R8NM09FDZ`2X
Ykl0o`2XYkl0102EU:/0R8NM06IVOP1VIWh30?ooo`001@3ooooo06IVOPD0
IVIn1@3oool00001\
\>"], "Graphics",
  CellLabel->"From In[6]:=",
  Evaluatable->False,
  ImageSize->{270, 213},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Executing"],

Cell[TextData[{
  "The ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " functions will search a path defined by the symbol ",
  StyleBox["$GUIPath", "Output"],
  " to discover user interfaces so that only a short path to the definition \
is necessary."
}], "Text",
  CellTags->"Executing"],

Cell["\<\
Here is another example that provides an input dialog for entering angles. \
With both examples, a modal session with the kernel is initiated so that \
control and the result is only returned to the kernel when the user is \
finished.\
\>", "Text",
  CellTags->"Executing"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIRunModal["\<Wolfram/Example/AngleDialog\>"]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Executing"],

Cell[BoxData[
    \(\(14\ \[Pi]\)\/45\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Executing"]
}, Open  ]],

Cell["\<\
Here is a screen shot of what the previous user interface would look like on \
a typical platform.\
\>", "Text",
  CellTags->"Executing"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003?0000/2000`400?l0
0000o`00003oc`1VIWh0000306IVOP3ko?d0nocm0</0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0<T0IVIn0@2XZK/10?_lo@40IVIn00000`1VIWh0nocm
06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3P
gn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh1
0?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IV
OP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IV
OP3ko?d0IVIn04h0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;bm00C0??cm100
n?Oh0P3clo@01@3cloD0m?Ce0?GemP3dloD0iNCX00H0h=oS00D0hN3T0>KU
j03/jnh0l?3b0?;bm00L0??cm1T0n?Oh0P3clo@01@3cloD0m?Ce0?GemP3d
loD0iNCX00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>
0>3Oh`040=kLg`3Th^00NiN]02EGQBL003ad00@05den06^;YP3blNh0l_7c
1P3Pgn<0103Ng=l0i>;P07^G[@0UEhDi000lM00401M=OP1[RjH0l_7^0?;a
l`D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`04
0=[Hf@1VQJ409df504em`BP0JH;^00<09df506Z:Y03_ko401P3Pgn<0103J
f=T0IXFQ04YaT`2b_L<i0<K5e`040<36a@18KY00JXZT0>o_l@D0h=oS0@1V
IWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`030=SEeP0GCGh0
RJgT02X0RJgT00<05den0>_Zk@3Pgn<01@3Pgn<00`3HeMH05den0;o7bP0k
0<K5e`030;Jm_@0GCGh0jn[]00D0h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP1>0>3Oh`040=WEe@00?7@0RJgT0?ooobL0cLcO00@0oooo
08V]i000?7@0j>OZ1P3Pgn<00`3IeMD003ad0?ooo`0k0<g<g`030?ooo`00
?7@0j>OZ00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>
0>3Oh`040=WEe@00?7@0RjgT0?ooobL0d]7T00@0oooo08^_i@00?7@0inKY
1P3Pgn<00`3IeMD003ad0?ooo`0k0=;Ai0030?ooo`00?7@0inKY00D0h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`040=WEe@00
?7@0SZoV0?ooobL0e]OW00@0oooo08f_i@00?7@0inKY1P3Pgn<00`3IeMD0
03ad0?ooo`0k0=KGi`030?ooo`00?7@0inKY00D0h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`040=WEe@00?7@0TK7W0?ooo`h0
fM[W0`0000030=WJi`030000003If^L0fM[W0080fM[W00<000000=WJi`3I
f^L02`3If^L0103oool0TK7V000lM03Wi^T60>3Oh`030=WEe@00?7@0oooo
00l0fM[W0`0000030=WJi`80000000@0fM[W0000003If^L000000`3If^L0
0`000000fM[W0=WJi`03000000<0fM[W0`0000020=WJi`030000003If^L0
fM[W00`0fM[W00<0oooo000lM03Wi^T01@3Pgn<106IVOP40nocm0@1VIWh0
000306IVOP3ko?d0IVIn04h0h=oS00@0fMGE000lM02D]>P0oooo3@3If^L0
1@000000fM[W0=WJi`3If^L000000080fM[W00D000000=WJi`3If^L0fM[W
0000000>0=WJi`040?ooo`2E]>P003ad0>OVj@H0h=oS00<0fMGE000lM03o
ool03P3If^L01`000000fM[W0=WJi`3If^L000000=WJi`0000000P3If^L2
000000030=WJi`000000fM[W0080fM[W00<000000=WJi`0000000`3If^L0
0`000000fM[W000000030=WJi`030000003If^L0000000h0fM[W00<0oooo
000lM03Wi^T01@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn
04h0h=oS00@0fMGE000lM02H^>X0oooo303Ngn`00`000000g]o/0=kOk003
0=kOk0030000003Ngn`0000000<0g]o/00<000000=kOk03Ngn`0303Ngn`0
103oool0V;SY000lM03Wi^T60>3Oh`030=WEe@00?7@0oooo00d0g]o/00<0
00000=kOk03Ngn`0103Ngn`01`000000g]o/0=kOk03Ngn`000000=kOk000
00000`3Ngn`00`000000g]o/000000050=kOk0030000003Ngn`0g]o/00<0
g]o/00<000000=kOk03Ngn`0303Ngn`00`3oool003ad0>OVj@050>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad
09bkjP3oool<0>?Ul0030000003SiO00hnG`00<0hnG`00H000000>?Ul000
000000000>?Ul000000?0>?Ul0040?ooo`2L^n/003ad0>OVj@H0h=oS00<0
fMGE000lM03oool03@3SiO000`000000hnG`0>?Ul0050>?Ul0@0000000<0
hnG`0000003SiO000P3SiO000`000000hnG`000000050>?Ul0D0000000<0
hnG`0000003SiO003@3SiO000`3oool003ad0>OVj@050>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad0:2nk03o
ool<0>W[m@030000003YjoD0jN_e00<0jN_e00@000000>W[m@000000jN_e
0P00000?0>W[m@040?ooo`2Q_^`003ad0>OVj@H0h=oS00<0fMGE000lM03o
ool03@3YjoD00`000000jN_e0>W[m@040>W[m@060000003YjoD0jN_e0>W[
m@000000jN_e0P0000020>W[m@030000003YjoD0000000<0jN_e00<00000
0>W[m@0000000`3YjoD00`000000jN_e0000000>0>W[m@030?ooo`00?7@0
inKY00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3O
h`040=WEe@00?7@0YL7]0?ooo``0l?7l00<000000?3ao03`lO`00`3`lO`0
0`000000l?7l000000020?3ao0030000003`lO`0l?7l00d0l?7l00@0oooo
0:G2kP00?7@0inKY1P3Pgn<00`3IeMD003ad0?ooo`0=0?3ao0030000003`
lO`0l?7l00D0l?7l0`0000020?3ao0040000003`lO`00000000000<0l?7l
0`0000030?3ao0<000000P3`lO`00`000000l?7l0?3ao00<0?3ao0030?oo
o`00?7@0inKY00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IV
OP1>0>3Oh`040=WEe@00?7@0ZLG_0?ooo`d0m?Gm00D000000?Ceo@3dmOd0
m?Gm000000020?Ceo@050000003dmOd0m?Gm0?Ceo@0000003P3dmOd0103o
ool0ZLG_000lM03Wi^T60>3Oh`030=WEe@00?7@0oooo00h0m?Gm00D00000
0?Ceo@3dmOd0m?Gm0000000I0?Ceo@030000003dmOd0m?Gm00`0m?Gm00<0
oooo000lM03Wi^T01@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn04h0h=oS00@0fMGE000lM02]b?00oooo3P3fmod3000000<0m_Om00<0
00000?Kgo@3fmod00P3fmod00`000000m_Om0?Kgo@0;0?Kgo@040?ooo`2/
ao0003ad0>OVj@H0h=oS00<0fMGE000lM03oool03`3fmod3000001X0m_Om
00<000000?Kgo@3fmod0303fmod00`3oool003ad0>OVj@050>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad0;7;
lP3ooolW0?Slo@040?ooo`2ac?8003ad0>OVj@H0h=oS00<0fMGE000lM03o
ool0>`3ho?d00`3oool003ad0>OVj@050>3Oh`40IVIn0@3ko?d106IVOP00
00<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad0;C=l`3ooolW0?gmo@04
0?ooo`2ec_<003ad0>OVj@H0h=oS00<0fMGE000lM03oool0>`3moOd00`3o
ool003ad0>OVj@050>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1V
IWh0CP3Pgn<0103IeMD003ad0;O@m03ooolW0?gmo@040?ooo`2hd?D003ad
0>KVj@H0h=oS00<0fMGE000lM03oool0>`3moOd00`3oool003ad0>KVj@05
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103H
e=@003ad0;[Cm@3ooolW0?gmo@040?ooo`2jdoH003ad0>GUj0H0h=oS00<0
f=CD000lM03oool0>`3moOd00`3oool003ad0>GUj0050>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<00`3IeMD09EN50;cDmP0Z
0;cDmP0302EGQ@3QhN@0h=oS00D0h=oS00<0fMGE02EGQ@2oc]`0>`3oool0
0`2oc]/09EN50>7Qi0050>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh0CP3Pgn<00`3IeMD0NIBY02M=Q@0Y0<kWo`0302M=Q@1iUJ/0gmgP
00H0h=oS00@0fMGE07VDZ@1EOJ80`<oM>@3oool0103EgnP0EGfR07VEZ`3O
gN050>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0
103JemT0gmcH07VDZ@0UEhDW000lM00401M=OP1VQZ40h=kJ0=cKg@H0h=oS
00@0f]OI0=oLf01iU:T09EN5>@00?7@0100GCGh0IXJQ0>3NfP3Lfmd50>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<00`3OgN00
f]OI0=SDe00E0=OCe100dlk<0`3Gdm@0103He=@0fMGE0=[Gf@3OgN060>3O
h`030=oMh03JemT0f=CD01h0em?D6@3Cc/`30=OCe0040=SDe03IeMD0f]OI
0=oMh0D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40
nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn
00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn
0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn0000
0`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1V
IWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP0A0>3OhjL0oooo4@3Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn0140h=oSYP2LW9h00`3oool0h=oS0>3Oh`0?0>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo
0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn
00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80h=oS00<0
W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3Oh`0@
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2L
W9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_l
o@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80
h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IV
OP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo
0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3P
gn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1V
IWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0
h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0
000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2L
W9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1V
IWh04@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bL
WP3oool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3P
gn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`0G0>3Oh`070<c@f@2GZ[h0
EGZM02AGQ01ENYd0UjZn0<c@f@0C0>3Oh`@000009P3Pgn<01`3<d=T0UjZn
05EjW@0TEh@0EGZM09NZ_P3<d=T0@03Pgn<00`2LW9h0oooo0>3Oh`0@0>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0
oooo0>3Oh`0E0>3Oh`0;0=kNhP2U]LD085B206j@[@2jbMH0loGf0;c;f@1`
TJl085B20:Fea@3Ng^805@3Pgn<00`000000h=oS0>3Oh`0Q0>3Oh`0;0=kN
hP2U]LD085B206j?[02ib=D0l_Ce0;c;f01`TJl085B20:Fea@3Ng^80?P3P
gn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`0E0>3Oh`0;0:Fea@1LPJ80
]/GB0?OgmP3inOP0n_[i0?cln`3moOd0_<cI0625YP2U]LD01P3Pgn<20000
00040>3Oh`000000h=oS0>3Oh`<000000`3Pgn<2000000040>3Oh`000000
h=oS000000@0h=oS0`0000030>3Oh`<000000`3Pgn<3000000h0h=oS00/0
YKG505^1X@2ea=00mOGd0?OgmP3inOP0no_j0?gmo02lc=T0H8FV0:Fea@05
0>3Oh`030000003Pgn<0h=oS0080h=oS0P000000103Pgn<000000>3Oh`3P
gn<2000000040>3Oh`000000h=oS00000080h=oS0P000000103Pgn<00000
0>3Oh`0000030>3Oh`030000003Pgn<0h=oS00<000005`3Pgn<00`2LW9h0
oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0
4@3Pgn<00`2LW9h0oooo0>3Oh`0D0>3Oh`0=0<c@f@0PE880/l??0??cl@3e
mO<0moOf0?Win03jn_T0o?ck0?gmo@2lc=T085B20<c@f@040>3Oh`030000
003Pgn<0h=oS0080000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS
000000020>3Oh`80000000<0h=oS0000003Pgn<00P3Pgn<01`000000h=oS
0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0h=oS00X0h=oS00d0c=3I021DPP2b`Ld0lO7_0??cl@3e
mO@0moOf0?Win03knoX0oOgl0;c<f@0PE880c=3I00@0h=oS00D000000>3O
h`3Pgn<0h=oS000000020>3Oh`80000000@0h=oS0000003Pgn<0h=oS0P00
0000103Pgn<000000>3Oh`0000020>3Oh`80000000<0h=oS0000003Pgn<0
0P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0h=oS01@0h=oS
00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3k
o?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0503Pgn<03@2GZ[h0JH^W0>o_
k03alNl0j>kV09[<V00TUR@0V<VG0>kck@3lo?/0oOgm072A[`2GZ[h0103P
gn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000001@3Pgn<01`000000
h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`03
0>3Oh`030000003Pgn<0h=oS00H0h=oS00<000000>3Oh`3Pgn<02`3Pgn<0
3@2GZ[h0J8VV0>c/j@3_kn`0lO7_0??cl@3emO@0moOf0?Win03knoX0oOgl
072A[`2GZ[h0103Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00<0
00000>3Oh`0000000`3Pgn<01@000000h=oS0000003Pgn<0000000<0h=oS
00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000
003Pgn<0h=oS01D0h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0503P
gn<03@1ENYd0[[k80>c/j@3_kn`0X=:N02ZX9`0RXR004i8@09S8U`3jn_T0
o?ck0;c;f@1ENYd0103Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`D0
000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS000000030>3Oh`D0
000000<0h=oS0000000000000`0000020>3Oh`8000003P3Pgn<03@1ENYd0
Zk[60>SXi@3/k>T0kno/0?7ak`3clo40mOGd0?OgmP3inOP0no_j0;c;f01E
NYd0103Pgn<00`000000h=oS0>3Oh`020>3Oh`@0000000<0h=oS0000003P
gn<00P3Pgn<00`000000h=oS000000020>3Oh`@0000000<0h=oS0000003P
gn<00P3Pgn<00`000000h=oS0>3Oh`02000001P0h=oS00<0W9bN0?ooo`3P
gn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS
00<0W9bN0?ooo`3Pgn<0503Pgn<03@0TEh@0gn7O0>[ZiP3/k>T0CKm:04;3
?`0h^CD08J4Q02JF8`3inOP0n_[i0??emP0TEh@0103Pgn<00`000000h=oS
0>3Oh`02000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`000000
0P3Pgn<2000000030>3Oh`00000000000080h=oS00L000000>3Oh`3Pgn<0
h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`00
0000h=oS0>3Oh`0:0>3Oh`0=02AGQ03Jg=X0iNGR0>SXi@3/k>T0kno/0?7a
k`3clo40mOGd0?OgmP3inOP0l_Ce02AGQ0040>3Oh`8000000P3Pgn<01`00
0000h=oS0>3Oh`3Pgn<000000>3Oh`0000000P3Pgn<2000000040>3Oh`00
0000h=oS000000<0h=oS00@000000>3Oh`00000000000P3Pgn<00`000000
h=oS000000030>3Oh`030000003Pgn<0h=oS01@0h=oS00<0W9bN0?ooo`3P
gn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS
00<0W9bN0?ooo`3Pgn<0503Pgn<03@1ENYd0Zk[50>OWh`3Zj^H0ZMbV05GE
D@13`cl0:JPV09[<V03gmoH0nOWh0;[9eP1ENYd01@3Pgn<2000000040>3O
h`000000h=oS0>3Oh`<000000`3Pgn<2000000060>3Oh`000000h=oS0000
003Pgn<000000P3Pgn<3000000<0h=oS0`0000030>3Oh`<000003@3Pgn<0
3@1ENYd0YkO10>;RgP3UiN80j>SU0>c/j@3_kn`0lO7_0??cl@3emO@0moOf
0;W8e@1ENYd0103Pgn<00`000000h=oS000000020>3Oh`<000000`3Pgn<2
000000040>3Oh`000000h=oS00000080h=oS0`0000020>3Oh`040000003P
gn<00000000000<0h=oS0`00000G0>3Oh`0309bLWP3oool0h=oS0100h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3o
ool0h=oS01@0h=oS00d0UjZn06J7X`3UiN40inOS0>;XgP2Yg:H0CKm:0:3B
WP3Xk^H0mOGc0?OgmP1^T:d0UjZn00P0h=oS00<000000>3Oh`3Pgn<0;03P
gn<03@2GZ[h0I8JQ0>3Pf`3Rh]h0iNGR0>SXi@3/k>T0kno/0?7ak`3clo40
mOGd06j?[02GZ[h04P3Pgn<00`000000h=oS0>3Oh`0X0>3Oh`0309bLWP3o
ool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A
0>3Oh`0309bLWP3oool0h=oS01@0h=oS00d0c=3I021DPP2Y^L<0iNGQ0>OW
h`3Zj^H0k>cY0>o_k03alNl0lo?a0;K5dP0PE880c=3I00P0h=oS00<00000
0>3Oh`3Pgn<0;03Pgn<03@3<d=T085B20:Je_`3Ph=/0h^;N0>GUhP3Xj>D0
k>cY0>o_k03alNl0]LC@021DPP3<d=T04P3Pgn<00`000000h=oS0000000X
0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS01D0h=oS00/0YKG505Ml
W02Y^L<0iNGQ0>OWh`3Zj^H0k>cY0>o_k02c`ll0G86R0:Fea@0i0>3Oh`0;
0:Fea@1ENYX0Y[Fo0>3Pf`3Rh]h0iNGR0>SXi@3/k>T0//7=05^1X@2U]LD0
?P3Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0
IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`0E0>3Oh`0;0=kNhP2U
]LD085B206J7X`2[^/D0gn7O0:jnb01YRjL085B20:Fea@3Ng^80>@3Pgn<0
2`3Ng^80YKG5021DPP1TQZ40YkO10=[LfP2[^/H0J8VV021DPP2U]LD0g]kR
03h0h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<05`3Pgn<01`3<d=T0
UjZn05EjW@0TEh@0EGZM09NZ_P3<d=T0?@3Pgn<01`3<d=T0UjZn05EjW@0T
Eh@0EGZM09NZ_P3<d=T0@03Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3O
h`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn0000
0`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80h=oS00<0W9bN
0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn
0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3Oh`0@0>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0
oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80h=oS
00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3k
o?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3O
h`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<0
0`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh1
0?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS
0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0
oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0
4@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3o
ool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1V
IWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<0
0`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS
0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`03
09bLWP3oool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40
nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0
XP3Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0
IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3o
ool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A
0>3Oh`0309bLWP3oool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<1
06IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?oo
o`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IV
OP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`050>3Oh`@0
00000P3Pgn<020000000h=oS0>3Oh`3Pgn<000000>3Oh`000000h=oS0P00
00020>3Oh`<00000R03Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`04
0>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`0000000`3Pgn<0
1@000000h=oS0000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS
000000270>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn
00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS00@0h=oS00<0
00000>3Oh`3Pgn<00P3Pgn<00`000000h=oS000000030>3Oh`050000003P
gn<000000>3Oh`0000001@3Pgn<00`000000h=oS0>3Oh`260>3Oh`0309bL
WP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IV
OP0A0>3Oh`0309bLWP3oool0oooo00<0oooo00<0h=oS0000003Pgn<00`3P
gn<00`000000h=oS000000030>3Oh`050000003Pgn<000000>3Oh`000000
0`3Pgn<2000000@0h=oSQ@3oool00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<609bLWP030>3Oh`00
0000h=oS00<0h=oS00@000000>3Oh`00000000000P3Pgn<01@000000h=oS
0000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3O
hhH0W9bN00<0oooo0>3Oh`3Pgn<03`3Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn01P0h=oS00<000000>3Oh`3Pgn<00P3Pgn<010000000
h=oS0000003Pgn<200000080h=oS100000020>3Oh`<00000V`3Pgn<106IV
OP40nocm0@1VIWh0000306IVOP3ko?d0IVIn01P0h=oS00<000000>3Oh`3P
gn<00P3Pgn<00`000000h=oS0>3Oh`070>3Oh`030000003Pgn<0h=oS09l0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0H0>3Oh`030000
003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`000000h=oS
0000002Q0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3P
gn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh1
0?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IV
OP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IV
OP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IV
OP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<1
06IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_l
o@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP00
00<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3k
o?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP39
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IV
OP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0
IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0FP3Pgn=P0:F//Pl0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1J0>3Oh`030:F/
/P3oool0oooo05`0oooo00<0YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn05X0h=oS00<0YJbb0?ooo`3oool0G03o
ool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh0FP3Pgn<00`2U[;80oooo0?ooo`1G0?ooo`030000003oool0
oooo0080oooo00<0YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40nocm0@1VIWh0
000306IVOP3ko?d0IVIn04H0h=oS1000000@0>3Oh`030:F//P3oool0oooo
05L0oooo00<000000?ooo`3oool00P3oool00`2U[;80h=oS0>3Oh`0=0>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0BP3Pgn<00`000000
h=oS0>3Oh`0=0>3Oh`030:F//P3oool0oooo05L0oooo00<000000?ooo`3o
ool00P3oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP00
00<0IVIn0?_lo@1VIWh03`3Pgn<5000000030>3Oh`000000h=oS0080h=oS
00@000000>3Oh`00000000000P3Pgn<300000080h=oS00<000000>3Oh`3P
gn<01@3Pgn<2000000040>3Oh`000000h=oS000000<0h=oS00<000000>3O
h`3Pgn<00`3Pgn<2000000040>3Oh`000000h=oS000000<0h=oS00<00000
0>3Oh`3Pgn<00P000000103Pgn<000000>3Oh`0000020>3Oh`<000000P3P
gn<00`000000h=oS0>3Oh`030>3Oh`030:F//P3oool0oooo04`0oooo0`00
00030?ooo`<000000P3oool00`000000oooo0?ooo`020?ooo`030:F//P3P
gn<0h=oS00d0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0?
0>3Oh`030000003Pgn<0h=oS00<0h=oS00L000000>3Oh`3Pgn<0h=oS0000
003Pgn<000000080h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<00000
00H0h=oS00<000000>3Oh`3Pgn<00P0000000`3Pgn<000000>3Oh`020>3O
h`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<00P0000000`3P
gn<000000>3Oh`020>3Oh`030000003Pgn<000000080h=oS0P000000103P
gn<000000>3Oh`0000030>3Oh`030000003Pgn<0h=oS00D0h=oS00<0YJbb
0?ooo`3oool0B`3oool01`000000oooo0?ooo`3oool000000?ooo`000000
0`3oool00`000000oooo000000040?ooo`030:F//P3Pgn<0h=oS00d0h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0?0>3Oh`030000003P
gn<0h=oS00<0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<000000080
h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS0>3Oh`040>3Oh`07
0000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0
h=oS0080h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS
00<000000>3Oh`0000000`3Pgn<01@000000h=oS0000003Pgn<0000000/0
h=oS00<0YJbb0?ooo`3oool0C`3oool00`000000oooo000000030?ooo`03
0000003oool0000000@0oooo00<0YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40
nocm0@1VIWh0000306IVOP3ko?d0IVIn00l0h=oS00<000000>3Oh`3Pgn<0
0`3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000P3Pgn<50000
00030>3Oh`000000h=oS00H0h=oS100000000`3Pgn<000000>3Oh`020>3O
h`030000003Pgn<0h=oS00<0h=oS100000000`3Pgn<000000>3Oh`020>3O
h`030000003Pgn<0000000<0h=oS00@000000>3Oh`000000h=oS1@000007
0>3Oh`030:F//P3oool0oooo04l0oooo00<000000?ooo`0000000`3oool0
0`000000oooo000000040?ooo`030:F//P3Pgn<0h=oS00d0h=oS0@1VIWh1
0?_lo@40IVIn00000`1VIWh0nocm06IVOP0?0>3Oh`D0000000<0h=oS0000
000000000P3Pgn<00`000000h=oS000000020>3Oh`060000003Pgn<0h=oS
0>3Oh`000000h=oS0P0000050>3Oh`060000003Pgn<0h=oS0>3Oh`000000
h=oS0P0000020>3Oh`030000003Pgn<0h=oS0080h=oS00H000000>3Oh`3P
gn<0h=oS0000003Pgn<200000080h=oS00<000000>3Oh`0000000P3Pgn<2
000000040>3Oh`000000h=oS000000<0h=oS00<000000>3Oh`3Pgn<01@3P
gn<00`2U[;80oooo0?ooo`1;0?ooo`@000000P3oool400000080oooo00<0
00000?ooo`3oool00P3oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh03`3Pgn<00`000000h=oS0>3Oh`03
0>3Oh`050000003Pgn<000000000003Pgn<00`0000020>3Oh`<000000P3P
gn<00`000000h=oS000000050>3Oh`<000000P3Pgn<010000000h=oS0000
000000060>3Oh`<000000P3Pgn<010000000h=oS0000000000030>3Oh`80
000000@0h=oS0000003Pgn<000000P3Pgn<300000080h=oS00<000000>3O
h`3Pgn<00`3Pgn<00`2U[;80oooo0?ooo`1;0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?oo
o`030:F//P3Pgn<0h=oS00d0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0
nocm06IVOP0?0>3Oh`030000003Pgn<0h=oS00T0h=oS00<000000>3Oh`3P
gn<0;P3Pgn<00`000000h=oS0>3Oh`0;0>3Oh`030:F//P3oool0oooo04`0
oooo00<000000?ooo`3oool00P3oool01`000000oooo0?ooo`3oool00000
0?ooo`000000103oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d1
06IVOP0000<0IVIn0?_lo@1VIWh03`3Pgn<5000000L0h=oS00<000000>3O
h`3Pgn<0;P3Pgn<00`000000h=oS0>3Oh`0;0>3Oh`030:F//P3oool0oooo
04`0oooo100000020?ooo`<000000P3oool00`000000oooo0?ooo`020?oo
o`030:F//P3Pgn<0h=oS00d0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0
nocm06IVOP1J0>3Oh`030:F//P3oool0oooo05L0oooo00<000000?ooo`3o
ool00P3oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP00
00<0IVIn0?_lo@1VIWh0FP3Pgn<00`2U[;80oooo0?ooo`1G0?ooo`030000
003oool0oooo0080oooo00<0YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn05X0h=oS00<0YJbb0?ooo`3oool0E`3o
ool00`000000oooo0?ooo`020?ooo`030:F//P3Pgn<0h=oS00d0h=oS0@1V
IWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1J0>3Oh`030:F//P3oool0
oooo05L0oooo00<000000?ooo`3oool00P3oool00`2U[;80h=oS0>3Oh`0=
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0FP3Pgn<00`2U
[;80oooo0?ooo`1L0?ooo`030:F//P3Pgn<0h=oS00d0h=oS0@1VIWh10?_l
o@40IVIn00000`1VIWh0nocm06IVOP1J0>3Ohf00YJbb3`3Pgn<106IVOP40
nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn
00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn
0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn0000
0`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0moOi09RHY`3907MgTP40V9RW
0@3gmoT106IVOP0000<0IVIn0?Ogn@2l_Ld0bP2l_Ld10?Ogn@40IVIn0000
0`1VIWh0moOi0>CSh`3:0>CSh`40moOi0@1VIWh0000306IVOP3`lO@0oooo
08@0oooo00<0i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?06afT01/MY09
06]eS`0609bT^@3Thn<0oooo0?ooo`3_k^h0a/WC102Y[KT0102Z[KT0ZJfi
0:Z]^@2Z[KT90:V]^@060<K9d`3_k^h0oooo0?ooo`3/j^X0W:Bi102V>D@0
102W>T@0YSU40:LjA02W>T@90:HiA00309bT^@3/j^X0oooo0080oooo0@3`
lO@106IVOP0001H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0no_m0?_lo@3k
o?`0o?cm0?clo03lnod0o?cl0?cko03lo?`0nocl0?clo03ko?d0o?_l0?cl
o@3knod0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?dV0?cko0060?Wgn@3Y
ind0em?N0<O2d@3LfN80jNO]103lno``0?_lo0/0nocm00<0W:Bi06]eS`25
RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0a/WC0:V]^A40_KkB00H0ZJfi
0<K9d`3kno`0o?cl09bT^@2V>D@A0:XlE@060:HiA02LY;T0o?cl0?cko@3k
o?d0h^7R0@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0m_Oh0?Og
n@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi0?Kgn@020?Ogn@04
0?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3gmoT0903gmoT0203Z
j^`0V9NM04Y;CP0>4100KFi_09nOX`37`]40g]_T0`3gmoT`0?Kgn@/0moOi
00<0JgF?08F9/02LW[h0402LW[h01P25RK00JgF?0?Ogn@3gmoT0ZJfi0<_<
fQ40`lGD00P0blcJ0:V]^@3gmoP0m_Oi0:HiA02Z?5D0`U9K0<IDFPd0aUEL
00P0aUAJ0<9BF`2Z?5D0YSU40?Ogn@3gmoP0moOi0>3Ph@40IVIn00001@1V
IWh0g]gQ0?7am03alO@0l?7d0100000000L0lO;d0?7am03`l_D0lO7d0?7b
m03`l_@0lO7d02D0l?7e00P0RXb>055BE03>c]@0l?7e0;jo`P0>4100J6I^
0=?@fc<0l?7e2`3`lO@00`1[MHl0/[G@0:NX`P0@0:NX`P060;:ed01[MHl0
l?7d0?3am02Y[KT0c<kK4@3:bmP01@3<c]/0ZJfi0?7bm03alOD0YSU40080
`U9K00<0beAI0<eIGP3=FEh02`3=FEh0203;E5T0`U9K0<9BF`2V>D@0l?7d
0?7am03`l_@0g]gQ0@1VIWh0000606IVOP3Lfn00j^_`0>[[l03Zk?000000
0P3WinL20=kNgP80inOW00<0ikf40>OWi`3WinL00`3WinL20>o_k`050000
003Zk>l0j^_`0>[[l03Zjnl00P3Zjo001`3Zjnl0gMcU0=7>fP37`]40dLkJ
0=cJh`3Ti>/00P3Zjo001@3Ph>P0dLkJ0<O2d@3Ed]d0inO]0080j^_`00<0
hn?Z0<O2d@37`]401P3Zjo001`3Mg>D0al;A0=oNiP3Mg>D0al;A0>CTj`3Z
jo000P37`]420>[[l080al;A0180emSL0;Je_037`]40al;A0;Nb`00>4100
BT]>0>?SjP3Zjo00i>C[0=7>fP3Rh^T0j^c`0>3Qj03Ac]X0al;A0=GCg@3W
j>d20>[/l080f=KP0`3Zk?020=SFh0<0j^c`0P3He^0K0>[/l0/0j^__00@0
JgF?0;Jid@2][/H0[Jk6203oool00`2][/H0[:k60:f^aP030:f^aP030:b^
aP2f^M40JgF?0080j^__00@0ZJfi0=3@g03>c]X0c/kJ303oool30<k>fP09
0=3@g02Y[KT0j^_`0>[[l02V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00H0
cUUO0<eFF`3;E5T0cEUN0:HiA03Zjo020>[[k`40g=_P0@1VIWh0000:06IV
OP3IfMl0hnGZ0>?TjP3SiN/0000008b<S03Ng]h0inOW0=kNgP80inOW00<0
aV<00>OWi`3WinL00P3WinL0203_knL0kno_0>o_k`000000hnGZ0>?TjP3S
i>/0hnGZ0P3Si>X0402?SiH0B4U<00h@401>D580S8jB0:^W]037`]40hnG[
0:JV[@16ATX03Q0@069SI`2n^lH0f][S0>?Uj`2l_/8200h@40H0hnG[00L0
Ti>I00h@402QXjL0UIJK00h@402[Yk@0h>;X00803Q0@00H0al;A0>?Uj`0>
41003Q0@0<O2d@2?TI@400h@400A06EWJ@2l_/80hnG[0<?5bP18BD`0WY^V
0>?TjP2VYZ`0ATI:00h@401RHfH0_[_60=[IhP3Si>X0MGMj06i^L`3Dd]d0
0P3Si>X00`1eMgX0KVic0=CBg@020>?TjP0307EgNP1^KW<0e=;M01/0hnCZ
2`3SiNX01@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b
//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0ZJfi0=;Cg`80dM7L00<0oooo
09BDW02DU9`02@2DU9`30=7Ag0050=;Cg`2Y[KT0hnC[0>?UjP2V>D@00P3=
FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo00T0e5aO0=1KH03=FEh0
cEUN0:HiA03SiNX0hnCZ0>?Uj`3IfMl00@1VIWh0000306IVOP3Gf=h0g=kV
0080g=kV00D000000>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100
inOW0>ONaP3_S1000`3_knl00`000000g=gV0=cNiP020=cNi@060=cNiP1_
L7@0ATI:0;6a^@3Lg^D0a<K<0P0>41001`37`]40YZR^00h@402GU9l0[[2f
04a>D02NX:D00P3Lg^D00`1<CU003Q0@0<O2d@050=cNi@0409FGV`0>4100
]k;00:j`]P803Q0@00H0]k;00=cNi@0>41003Q0@0<O2d@3Lg^D200h@4004
0<O2d@1bM7L03Q0@0;6]^P80al;A00`0d]7L0=[Kh`3Lg^D0C4i@00h@4037
`]40YZR^00h@402GU9l0[[2f04a>D02NX:D20=cNi@80LWAg0`3Lg^D2079d
M`<0g=kU0P1bM7LW0=cNi@0506]eS`2o`MH0^;W>0;RicP3oool01P1^KHl0
0`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU0=cNi@2Y[KT0e=KP
0P3DeMh00`3oool0U9BL0=CEgP070=CEgP030?ooo`2DU9`0e=GN0080e=GN
00T0e=KP0:V]^@3Lg^D0g=kV0:HiA03=FEh0dEYN0=AMH@1C9B000`3oool5
0=IOH`<0oooo00T0DbDP0=AMH@3AFUh0cEUN0:HiA03Lg^D0g=kV0=cNi@3G
f=h00@1VIWh0000706IVOP3Ee]d0eMSP0=KHh@3Ef>00000008b<S0020>OW
i`050>NeQ03FFP00eX@00?o>003>H`000P3NJ`001P3_]H`0kno_0>o_k`3_
knl000000=GHh080eMSQ00D0eMOP0::TZP0>4100UiBO0=GEg`020=KGh080
3Q0@00<0al;A04Y<C`0>41001@37`]40103Fen003Q0@00h@4037`]450=KG
h0803Q0@00H0al;A0=?Cg@0>41003Q0@0<O2d@3Fen0200h@40060<O2d@3F
en003Q0@00h@4037`]40a<K>0`0>4100101kO840]k;00<k<f03Fen0200h@
40030<O2d@1:C4l03Q0@00D0al;A:@3Ff>0;0=GHh@0506]eS`33aMT0_;gA
0;bmd@3oool01`0U9CH70;bmd@060<?5f@1[MHl0eMSQ0=GHh@2Y[KT0emSR
0P3Fen400`3oool0U9BL0=KGh@070=KGh@030?ooo`2DU9`0e]OQ0080e]OQ
00D0emSR0:V]^@3Een40eMOP0:HiA0020=EMH0030=QPH@3IHF80AQhJ00<0
oooo0`3IHF830?ooo`0304HN6P3IHF80f61Q0080eEeP00D0YSU40=GHh@3E
en00eMSQ0=GFg@0106IVOP0000H0IVIn0=;Dg@3?d]`0d=;L0=3Bg@000003
0>OWi`0<0>ONcP36BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU
003_ilh00000103@d]`00`1MGf<03Q0@0;bhaP030=3Bg0803Q0@00<0al;A
00h@400>4100100>41001@39a]@0d=;L00h@400>4100al;A00D0d=;L00@0
NG^000h@402YZK<0bLKD0P0>41001P37`]40d=;L00h@400>4100al;A0=3B
g0803Q0@00T0al;A05eOH`0>4100/Jfj0;Vka00>4100J6I^0<O2d@3@d]`0
0P0>41000`37`]403Q0@00h@400400h@40030<W6e03?d]d0cm;M02L0cm;M
2`3@d]`00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3Bg02Y
[KT0f]_T0P3Jfn<00`3oool0U9BL0=[Kh`070=[Kh`030?ooo`2DU9`0f]_S
0080f]_S00L0f]_T0:V]^@3?d]`0d=;L0:HiA03GGel0fF5R00<0g6EU00D0
AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`0704HN6P3LIFD0g6EU0=aUI@3I
HF80eemO0:HiA0020=3Bg040cm;L0@3Be=d106IVOP0001T0IVIn0=3Bf`3;
cMP0b/gI0<_>f0000000ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU
003FS000cV/00>O6003oeP00knoW0>o_k`000000b/kI0<_=f03;cMT0b/gI
00803Q0@00<0al;A0<_=f@3;cMT00`0>41002@3;cMT0AdU=00h@4037`]40
b/[G00h@4016ATX0bLWF0<_=f@0200h@40030<O2d@3;cMT0blgI00@0blgI
00<0RXbC04M9C@0>41000P0>41001P38am@0blgI00h@400>4100al;A0<[<
f0803Q0@00D0bLSE00h@400>4100al;A0<[;f00200h@400<0<W8e@3;cMT0
3Q0@00h@4037`]40AdU=00h@4037`]40b/_G00h@4016ATX0bLWF:@3;c]T;
0<_=f00306]eS`3;c=h0b<[I00P0b<[I00<0b<WI0<S:f@38b]T00`38b]T0
1038bMT0b<[I0<_<gP1[MHl20<_=f0060:V]^@3Mg^L0g=kU0=cNi@3oool0
U9BL203Lg^D00`3oool0U9BL0=cNi@020=cNi@090=gNi`2Y[KT0b/gH0<[=
f@2V>D@0eemO0=]TI03PIfD0h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3o
ool02@167QX0gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0YSU40<[>f@020<_=
f@40d=;K0@1VIWh0000306IVOP3?cmX0aLSD0080aLSD00H000000<K6aP3W
g]H0cW/00>N]003_]@020>NU00030=JD003>L`00eY@00080mlH00P3gmoL0
0`000000aLOD0<G8e0020<G7e0803Q0@00<0al;A0<G6e034amD01034amD0
1P25R9403Q0@09fMZ02[Yk@03Q0@08J6T080a<OE0P0>41020<O2d@H0a<OE
00H0a/CB0;Nb`00>4100IfM_0<G6e034amD200h@400=0;Je`P2`[[/03Q0@
07=cN`35a]@0LWAl00h@402`[k`0/Jfj00h@401cLg/0a/GC0<C7e@0200h@
40070<O2d@25R9003Q0@09fMY`2[Yk@03Q0@08J6S`0Z0<C8e0/0a<OD00<0
JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0ZJfi0>3Pj@80
g]kW00<0oooo09BDW03Ng^L01`3Ng^L00`3oool0U9BL0=kNi`020=kNi`07
0>3Pj@2Y[KT0a<OD0<G8e@2V>D@0ffAT0=mUI0050>1ZJ00504HN6P3oool0
oooo0?ooo`167QX01@3PJVP00`3OIF@0ffAT0:HiA0020<C8e040aLOE0@3?
cmX106IVOP0000H0IVIn0<c>fP32a=80`LCA0<74dP0000030>OWi`0=0=J4
003_]@00ijD00>NU003FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL00000
0<;4dP030<74dP0405MIG`0>4100_;S60<C3d@H0`LCA00@0PhJ>00h@400>
4100PhJ>0P31a=4400h@40H0`LCA00D0EeUO00h@400>4100L7=j0;6d`002
0<74d@0600h@401jOHD0A4I:00h@401`LgX0/KC00P31a=401@1`LgX03Q0@
04A6BP1UIfh0TYFO0080`LCA0P0>41000`37`]40`LCB08>6S`0200h@4003
08>6S`31a=80`LCB02T0`LCB2`32a=800`1[MHl0dm?R0<o@g@0@0<o@g@06
0=?ChP1[MHl0`/CB0<;4dP2Y[KT0h^;Z0P3QhNL00`3oool0U9BL0>7Qi`07
0>7Qi`030?ooo`2DU9`0hN7W0080hN7W00L0h^;Z0:V]^@31a=40`LCB0:Hi
A03KI6@0hFUU00D0h6aY1@3oool50>1/J@070>5YI@3KI6@0YSU40<;4d@31
a=40`LCB0<c>fP0106IVOP0000X0IVIn0<[<f02n`<l0_L3?0;k0cP000000
W9bL0>OWi`3Wg]H0eX`00P3NU000103FN`00aV<00;e2003_Y@020?N]000<
0?Ne003ocTX000000;k0c`2n`<h0_/3?0;k0cP29RiD03Q0@0:BP[036`M00
`l7?0P2n`<h20<G1d0P0_/3>0P0>41000`36`M00_/3>0;k0cP0J0;k0cP80
3Q0@00<0al;A0;g0cP2m`<h0;P2m`<h;0;k0cP0306]eS`3Fe^@0dm?P0100
dm?P00H0e]KT06]eS`2n`<h0_/3>0:V]^@3Ti>/20>?Sj0030?ooo`2DU9`0
oooo00P0oooo00H0U9BL0>?Sj03ShnP0hn?X0>CTj`2Y[KT20;k0cP030:Hi
A03PIVD0hFYZ00@0hfa/0`3oool010167QX0oooo0?ooo`3oool40>=/K003
0>5ZJP3PIVD0YSU40080_/3?0@2n`<h10<[<f040IVIn00001P1VIWh0bL[H
0;Jhb02i_</0^[c;00000080kno_00d0eY`00=J<003NU000eX@00>nU003N
S000_EX00=Ic003_W000mnoW0?Ogm`3oool000000080^Kc<00/0^[_<0;Vl
b`2`//00@TA904=4B@2RWj`0a/7@0<O2d@2?S9L0LW5i0<6oc`080;Vlc003
08F8T`1DEUd0^Kc<01`0^Kc<0P0>41000`36`M00^[c<0;Zlc00^0;Zlc0/0
^[c;00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?0;Zlb`2j_</0ZJfi
0>KVk@80h^;Y00<0oooo0;Rgb02h]lP0202h]lP01P2DU9`0h^;Y0>;Rj@3R
h^T0i^K]0:V]^@80^[c<00H0YSU40>1YJ03QKF`0i75]0>AaK`3TL6h30?oo
o`0304HN6P3TL6h0AQhJ00<0oooo0P3TL6h0203TLFd0hFe/0>1YJ02V>D@0
^[_<0;Vlb`2f^<P0bL[H0@1VIWh0000806IVOP37bML0];K70;Jhb02f^<T0
000008B4Q03Wimh20>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL
00030?Ogm`090000002f^<T0][W90;Nhb@2f^LT0]kW90:b^_P1lOXT0@D=8
00803Q0@00<0M7F009fO[@2g^<T09`2g^<T00`1[K7H0@D=80;Nhb@0`0;Jh
b@/0]kS900@0JgF?0=KFi03Hf>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H2
0=SHi@060=KFi01[MHl0]kS90;Nhb@2Y[KT0i^K]0P3UiN`00`3oool0^;O8
0;Rgb0080;Rgb00=09BDW03UiN`0iNG/0>GUk03Vi^d0ZJfi0;Nib@2f^LT0
YSU40>A^K@3TM6l0ig5_0>AdK`030?ooo`0504HN6P3TM6l0i7A_0>AdK`16
7QX00`3oool02@3TM6l0ig5_0>AdK`3TKVd0YSU40;Jhb@2f^LT0];K70<O9
e`0106IVOP0000<0IVIn0<K8e`2d]/L00P2d]/L00`000000kno_0>o_k`02
0>o_k`0;0>N]003gaPP0ijD00>ND003WS000knOF0=jD>@3_e[D0ooOg0?oo
o`000000LP2d]/L01@1[MHl0eMGS0=cKi`3LfnL0gM_W00h0g=_W00H0eMGS
06]eS`2d]/L0];K70:V]^@3UiN`30>OWk@/0U9BL0`3Wind02@3UiN`0ZJfi
0;Bfa`2d]/L0YSU40>McK`3WMG80jWIc0>YhMP020?ooo`0304HN6P3YOWP0
jGih00<0jGih00P0AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80ig=_0:HiA0<0
];K70@36b=L106IVOP0000<0IVIn0<K8e`2a/lP00P2a/lP01P000000S8b<
0>o_k`3_knl0ilik0>o_k`80moOg00P0ii@00?OWcP3gmoL0moOg0>oWeP3g
moL0oooo00000780/K?800<0JgF?0=GDh`3PgnX0403PgnX01P3Ee><0JgF?
0;6cb02a/lP0ZJfi0>GUk140jNW_00T0iNG/0:V]^@2a/lP0/K?80:HiA03Z
NG<0jGah0>n1NP3bRH400P167QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<0>fG
RP3[V8/00P167QX01@3bRH40kh5j0>UlN03ZNG<0YSU400<0/K?80@36b=L1
06IVOP0000<0IVIn0<K8e`2h]ll00P2_[/L01P000000kno_0>o_k`3_knl0
moO_0>o_k`80moOg00<0mnO60?Ogm`3oool00`3gmoL00`3oool000000:n^
a`1a0:n^a`0306]eS`3]jo<0jNSa0100jNSa00H0kN_c06]eS`2_[/L0[jk7
0:V]^@3dloLA0?3_m00I0?Ccm`2Y[KT0[jk70:n^a`2V>D@0lH1e0?24O03e
S8@0mif>0?:[UP3a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK0>be
W03bZiH0mif>0?F<Q03`Q7`0lH1e0:HiA0020:n^a`40^;O?0@36b=L106IV
OP0000<0IVIn0<31d@37am@00P2/Zl@01@000000[Jf]0?Ogk`3gmoL0kno_
00H0moOg0P3omoL20?ooo`030000002/Zl@0[:_40700[:_400<0JgF?0=;A
h`3blOL0403blOL01P3BdN<0JgF?0:b[a02/Zl@0ZJfi0>7QjA40lo;f00H0
hN7Y0:V]^@2/Zl@0[:_40:HiA03dRWd20?F@Q@d0l[RN0P3eT8D01P3dRWd0
YSU40:b[a02/Zl@0alOD0<31d@40IVIn0000101VIWh0`<7A0=;Bg`2e]<V3
0:BS_P0408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR
0P2TXkh0102g^l@0ZJfi0>7Qj@3moOd=0?ooo`040?gmo@3QhNT0ZJfi0;Nk
a080Y:>n00L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0
n^Vf0?WY]P3ijKH0n^Vf0P3ijKH02P3jjkL0n]bg0?joY03oWhd0YSU4096H
ZP2TXkh0]KC90=;Bg`30`M4106IVOP0000H0IVIn0:RW_`3Vi^d0d];P0;bl
c`2a/<B20:RW_`0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:RW_`2XYkl0
0P2XYkl00`2g^l@0ZJfi0:V]^@0?0:V]^@030;Nka02XYkl0Z:No0080Z:No
00<0Q8bR0:HiA02V>D@03`2V>D@01P24S:80/K340;blc`3Bd^00i^K]0:RW
_`40IVIn00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@h03:b]X0`@2l_<l0
1P3:b]X0d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000201HEfP0IVIn09FD
Z`3Gf>80o?cl0?;al`3/jnh0hN;[_`3Gf>801`3Qh^/0k>_^0?;al`3lo?`0
emSR09FDZ`1VIWh00@1HEfP00080F5MX00<0IVIn09FDZ`3AdMh00P3lo?c1
0?ooo`80o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0F5MX0P1VIWh00`28
Qid0UIB[0:RW_`300:RW_`0409FDZ`28Qid0IVIn06IVOP<0F5MX000505QG
J<D0IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  Evaluatable->False,
  ImageSize->{207, 176},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Executing"],

Cell[TextData[{
  "We are also free to execute an interface in a modeless fashion. Executing \
the previous calculator example again with ",
  StyleBox["GUIRun", "Output"],
  " immediately returns control to the kernel, but the calculator window \
continues to function.  Also note that in a modeless session there is no way \
for the interface to return a custom result to the kernel when closed as the \
result value of the call to ",
  StyleBox["GUIRun", "Output"],
  "."
}], "Text",
  CellTags->"Executing"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIRun["\<Wolfram/Example/Calculator\>"]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Executing"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject180685885145089, 
        JLink`Objects`JavaObject471665540595713]]], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Executing"]
}, Open  ]],

Cell[TextData[{
  "In the next two sections we explain the ",
  StyleBox["GUIObject", "Output"],
  " expression that is returned from ",
  StyleBox["GUIRun", "Output"],
  " and discuss some features of working with modeless windows. We will also \
discuss a technique of delaying the execution of the user interface, even if \
used with a modal session, so that we can customize its features before \
presenting it on screen."
}], "Text",
  CellTags->"Executing"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Loading GUIs", "Section",
  CellTags->"Loading"],

Cell[TextData[{
  "When you load an interface with ",
  StyleBox["GUIRun", "Output"],
  " or ",
  StyleBox["GUIRunModal", "Output"],
  " the widget definitions are turned into runtime widgets, and the graphical \
user interface is immediately displayed on the screen.  It may be useful to \
break up the two-step process of turning a definition into the runtime \
widgets and the actual display of the resulting interface to the screen so \
that either existing widget properties can be modified before display, or, as \
a speed improvement to the user, preload the widgets and then later display \
the interface on screen only when requested."
}], "Text",
  CellTags->"Loading"],

Cell[TextData[{
  StyleBox["GUILoad", "Output"],
  " provides this functionality by loading and creating a ",
  StyleBox["GUIObject", "Output"],
  " instance that defines the runtime classes in the same manner that ",
  StyleBox["GUIRun", "Output"],
  " works.  However, the interface is not displayed on screen. Only when you \
later call ",
  StyleBox["GUIRun", "Output"],
  ", ",
  StyleBox["GUIRunModal", "Output"],
  ", or ",
  StyleBox["ReleaseGUIObject", "Output"],
  " on the ",
  StyleBox["GUIObject,", "Output"],
  " will there be a visual display of the user interface."
}], "Text",
  CellTags->"Loading"],

Cell[BoxData[
    \(\(Needs["\<GUIKit`\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Loading"],

Cell[TextData[{
  "Here we use ",
  StyleBox["GUILoad", "Output"],
  " to create the ",
  StyleBox["GUIObject", "Output"],
  ", but there is no immediate display."
}], "Text",
  CellTags->"Loading"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = GUILoad["\<Wolfram/Example/Calculator\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Loading"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject92518578388993, 
        JLink`Objects`JavaObject245809316626433]]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Loading"]
}, Open  ]],

Cell["\<\
We are free to change some of the initial values of some of the widgets, such \
as the default text property of one of the input text fields.\
\>", "Text",
  CellTags->"Loading"],

Cell[BoxData[
    \(ref\ @\ 
      SetPropertyValue[{"\<FirstArgumentField\>", "\<text\>"}, \ 
        ToString[N[Pi], \ InputForm]]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Loading"],

Cell[TextData[{
  "We can pass the ",
  StyleBox["GUIObject", "Output"],
  " expression to ",
  StyleBox["GUI", "MR"],
  StyleBox["Run", "Output"],
  " or ",
  StyleBox["GUIRunModal", "Output"],
  " when we are ready to display the interface to the user.  If we decided \
not to display the ",
  StyleBox["GUIObject", "Output"],
  " definition, we would call ",
  StyleBox["ReleaseGUIObject", "Output"],
  " to remove any resources and definitions created by ",
  StyleBox["GUILoad", "Output"],
  "."
}], "Text",
  CellTags->"Loading"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIRun[ref]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Loading"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject92518578388993, 
        JLink`Objects`JavaObject245809316626433]]], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Loading"]
}, Open  ]],

Cell["\<\
Here is a screen shot of what the previous user interface would look like \
when initially shown.\
\>", "Text",
  CellTags->"Loading"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"Loading"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004>0000eB000`400?l0
0000o`00003oo`1VIWh?06IVOP0000<0IVIn0?_lo@3ko?d0o`3ko?d;0?_l
o@40IVIn00000`1VIWh0nocm0:RY^`3o0:RY^`X0Z:Vk0@3ko?d106IVOP00
00<0IVIn0?_lo@2XZK/0o`1VIWh906IVOP40Z:Vk0@3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVInF`3Pgn>[0:F//P0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0
h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[
i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK
0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[
jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
0P3Pgn<3000000040>3Oh`000000h=oS0>3Oh`80000000@0h=oS0000003P
gn<0h=oS0`0000020>3Oh`80000000@0h=oS0000003Pgn<0h=oS0`000002
0>3Oh`060000003Pgn<0h=oS0>3Oh`000000h=oS0P0000000`3Pgn<00000
0>3Oh`0a0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0
nocm0@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3Pgn<000000`3Pgn<01000
0000h=oS0>3Oh`0000020>3Oh`80000000<0h=oS0000003Pgn<00P3Pgn<0
0`000000h=oS000000020>3Oh`030000003Pgn<0000000<0h=oS00<00000
0>3Oh`0000000`3Pgn<00`000000h=oS0000000e0>3Oh`030:F//P3[jn@0
jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP0000000P3Pgn<2000000040>3Oh`000000h=oS000000<0h=oS
00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000020>3Oh`030000
003Pgn<0000000D0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<00000
03D0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000050>3Oh`030000003Pgn<0
000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS00000002
0>3Oh`030000003Pgn<0000000@0000000<0h=oS0000003Pgn<00P3Pgn<0
0`000000h=oS0000000e0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000001@3P
gn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<0
00000>3Oh`0000000P3Pgn<00`000000h=oS000000030>3Oh`040000003P
gn<0000000000080h=oS00<000000>3Oh`000000=@3Pgn<00`2U[;80jn_T
0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0000000D0h=oS00<000000>3Oh`0000000`3Pgn<00`000000
h=oS0>3Oh`03000000060>3Oh`00000000000000003Pgn<000000P3Pgn<3
00000080h=oS00D000000>3Oh`00000000000>3Oh`03000000030>3Oh`00
0000h=oS0340h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY
^`3ko?d106IVOP0000H0IVIn0?_lo@2XZK/0IVIn0>3Oh`0000030>3Oh`03
0000003Pgn<0h=oS00`0h=oS00<000000>3Oh`3Pgn<03P3Pgn<00`000000
h=oS0>3Oh`0c0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2X
ZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS0`00000?0>3O
h`040000003Pgn<0h=oS000000d0h=oS00<000000>3Oh`3Pgn<0<`3Pgn<0
0`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0
YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS
00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i004
0:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3O
h`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3P
gn>[0:F//P0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWko0>3Oh`L0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVO_l0h=oS1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWiK0>3Ohj/0YJbb00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[
jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
F`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0
jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W
0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0000000D0h=oS00<000000>3Oh`3Pgn<00P3Pgn<3000000<0h=oS0P00
0000103Pgn<000000>3Oh`3Pgn<2000000040>3Oh`000000h=oS0>3Oh`<0
00000P3Pgn<2000000030>3Oh`000000h=oS03@0h=oS00<0YJbb0>_[i03[
jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn000000050>3Oh`050000003Pgn<0h=oS0>3Oh`0000000`3Pgn<0
0`000000h=oS000000020>3Oh`80000000@0h=oS0000003Pgn<0h=oS0P00
00000`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<0000003P0h=oS00<0
YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn000000050>3Oh`050000003Pgn<0h=oS0>3Oh`00
00000`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000<0
h=oS00<000000>3Oh`0000001@3Pgn<00`000000h=oS0>3Oh`0f0>3Oh`03
0:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOP@000000P3Pgn<01@000000h=oS0>3Oh`3Pgn<0
000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS00000003
0>3Oh`030000003Pgn<0000000D0h=oS00<000000>3Oh`3Pgn<0=P3Pgn<0
0`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0000000<0h=oS00@000000>3Oh`0000000000
0P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000P3Pgn<20000
00030>3Oh`000000h=oS0080h=oS00<000000>3Oh`0000000`3Pgn<00`00
0000h=oS0000000h0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000000`3Pgn<0
1@000000h=oS0000003Pgn<000000080h=oS0`0000030>3Oh`80000000@0
h=oS0000003Pgn<000000`3Pgn<00`000000h=oS0>3Oh`03000000060>3O
h`00000000000000003Pgn<00000=@3Pgn<00`2U[;80jn_T0>_[i02W0>_[
i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
000000<0h=oS00<000000>3Oh`3Pgn<03@3Pgn<00`000000h=oS0>3Oh`0;
0>3Oh`030000003Pgn<0h=oS03H0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1000
000@0>3Oh`030000003Pgn<0h=oS00/0h=oS00<000000>3Oh`3Pgn<0=P3P
gn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0
h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[
i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK
0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[
jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
F`3Pgn>[0:F//P0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWko0>3Oh`L0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVO_l0h=oS1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWiK0>3Ohj/0YJbb00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0
Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T
0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3k
o?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[
i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWh4000000<0h=oS00@000000>3Oh`3Pgn<000000`3Pgn<010000000
h=oS0>3Oh`3Pgn<300000080h=oS00<000000>3Oh`3Pgn<00P3Pgn<30000
0080h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3Oh`<000000`3Pgn<3
00000080h=oS00<000000>3Oh`3Pgn<09@3Pgn<00`2U[;80jn_T0>_[i02W
0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0000000<0h=oS00@000000>3Oh`3Pgn<000000P3Pgn<01@000000h=oS
0>3Oh`3Pgn<000000080h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0
000000<0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS
00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`030000
003Pgn<0h=oS02L0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000040>3Oh`03
0000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3O
h`030000003Pgn<0h=oS00<0h=oS00D000000>3Oh`3Pgn<0h=oS00000005
0>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS000000050>3Oh`030000
003Pgn<0h=oS02/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000040>3Oh`03
0000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3O
h`D0000000<0h=oS0000003Pgn<00P3Pgn<5000000030>3Oh`000000h=oS
0080h=oS00<000000>3Oh`0000001@3Pgn<5000002T0h=oS00<0YJbb0>_[
i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn000000040>3Oh`030000003Pgn<000000080h=oS00D00000
0>3Oh`3Pgn<0h=oS000000020>3Oh`060000003Pgn<0h=oS0>3Oh`000000
h=oS0P0000020>3Oh`060000003Pgn<0h=oS0>3Oh`000000h=oS0P000002
0>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<0
0`000000h=oS0>3Oh`0W0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000103P
gn<010000000h=oS0000003Pgn<3000000040>3Oh`000000000000000080
h=oS0`0000020>3Oh`030000003Pgn<000000080h=oS0`0000020>3Oh`04
0000003Pgn<00000000000<0h=oS0`0000030>3Oh`<000000P3Pgn<00`00
0000h=oS0>3Oh`0U0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000000`3Pgn<0
0`000000h=oS0>3Oh`030>3Oh`050000003Pgn<0h=oS0>3Oh`000000C03P
gn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWh4000000<0h=oS00D000000>3Oh`3Pgn<0
h=oS000000030>3Oh`030000003Pgn<0h=oS04T0h=oS00<0YJbb0>_[i03[
jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2X
ZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk
0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0
jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY
^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T
0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm
0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2X
ZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oSZ`2U[;800`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3O
h`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3O
h`L0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
O_l0h=oS1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVInF`3Pgn>[0:F//P0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IV
OP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb
0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn
0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1V
IWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F/
/P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0>3Oh`040000
00<0h=oS0P000000103Pgn<000000>3Oh`0000020>3Oh`060000003Pgn<0
h=oS0000003Pgn<00000A@3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F/
/P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000@0
h=oS00<000000>3Oh`0000000P3Pgn<2000000050>3Oh`000000h=oS0>3O
h`0000000P3Pgn<00`000000h=oS0>3Oh`150>3Oh`030:F//P3[jn@0jn_T
0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOPD0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS00000002
0>3Oh`040000003Pgn<0h=oS000004L0h=oS00<0YJbb0>_[i03[jn@0Y`3[
jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
0`3Pgn<200000080h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<00000
0080h=oS00@000000>3Oh`3Pgn<00000A`3Pgn<00`2U[;80jn_T0>_[i02W
0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0h=oS00800000103Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`80
000000D0h=oS000000000000h=oS000000170>3Oh`030:F//P3[jn@0jn_T
0:L0jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP0000001P3Pgn<02@000000h=oS0>3Oh`3Pgn<000000>3Oh`000000
h=oS000000020>3Oh`040000003Pgn<0h=oS000004D0h=oS00<0YJbb0>_[
i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn000000040>3Oh`030000003Pgn<0h=oS05<0h=oS00<0YJbb
0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn0>3Oh`04000005H0h=oS00<0YJbb0>_[i03[jn@0Y`3[
jn@0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
F`3Pgn<00`2U[;80jn_T0>_[i02W0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3[jn@0jn_T0:L0
jn_T00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OU/0h=oS00<0YJbb0>_[i03[jn@0Y`3[jn@0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80jn_T0>_[i02W
0>_[i0040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWiK0>3Oh`030:F//P3[jn@0jn_T0:L0jn_T00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oSZ`2U[;800`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS
1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
o`3Pgn<70>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWko0>3Oh`L0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVO_l0h=oS1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn000000040>3Oh`030000003Pgn<0h=oS00<00000
0`3Pgn<3000000<0h=oS0P0000001@3Pgn<000000>3Oh`000000h=oS0080
00000P3Pgn<300000080h=oS00<000000>3Oh`3Pgn<0g`3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000030>3Oh`04
0000003Pgn<0h=oS000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`00
0000h=oS000000020>3Oh`80000000@0h=oS0000003Pgn<000000P3Pgn<0
1@000000h=oS0>3Oh`3Pgn<000000><0h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP0000000`3Pgn<010000000h=oS0>3O
h`0000080>3Oh`040000003Pgn<0h=oS000000<0h=oS00D000000>3Oh`00
0000h=oS000000050>3Oh`030000003Pgn<0h=oS0>80h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000000P3Pgn<01000
0000h=oS0>3Oh`3Pgn<500000080h=oS0P0000030>3Oh`090000003Pgn<0
h=oS0>3Oh`000000h=oS0000003Pgn<0000000<0h=oS0P00003U0>3Oh`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh500000080
h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<00000
0>3Oh`0000000`3Pgn<01@000000h=oS0000003Pgn<000000080h=oS00D0
00000>3Oh`3Pgn<0h=oS0000003S0>3Oh`0306IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0000000@0h=oS00<000000>3Oh`3Pgn<0
0`0000030>3Oh`<000000P3Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3O
h`@000000P3Pgn<300000080h=oS00<000000>3Oh`3Pgn<0g`3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000040>3O
h`030000003Pgn<0h=oS0140h=oS00<000000>3Oh`000000jP3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@00000D0>3O
h`030000003Pgn<000000>X0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3O
h`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3O
h`L0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
O_l0h=oS1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn^`3Pgn<01@3Qh>@0i^GX0>c[kP3`l?80l_;d0240lo?d7P3hmoP2
0??cm0080??cm@3dm?D0mOGf0?Ccm@3Ui>P0IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn^`3Pgn<0103Ng=l0i>;P07^G[@0UEhE3000l
M00701M=OP1[RjH0l_7^0?;al`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn^`3Pgn<0103Jf=T0IXFQ04YaT`2b_L=30<K5e`070<36
a@18KY00JXZT0>o_l@1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn^`3Pgn<00`3HeMH05den0;o7bP150<K5e`060;Jm_@0GCGh0jn[]
06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[/0h=oS00<0
fMGE000lM03oool0A@3=c=l01P3oool003ad0>SWjP1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`030=WEe@00?7@0oooo0280
d]7T00<000000=;Ai03BdN@0803BdN@01P3oool003ad0>OVj@1VIWh0Z:Vk
0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`030=WEe@00?7@0
oooo0280e]OW00<000000=KGi`3FenL0803FenL01P3oool003ad0>OVj@1V
IWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`030=WE
e@00?7@0oooo00l0fM[W0`0000030=WJi`<000000P3If^L010000000fM[W
0=WJi`0000020=WJi`040000003If^L000000=WJi`8000000`3If^L20000
00030=WJi`000000fM[W008000000P3If^L300000100fM[W00H0oooo000l
M03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn^`3P
gn<00`3IeMD003ad0?ooo`0>0=WJi`070000003If^L0fM[W0=WJi`000000
fM[W000000030=WJi`030000003If^L000000080fM[W00D000000=WJi`3I
f^L000000=WJi`0200000080fM[W00<000000=WJi`0000000P3If^L20000
00050=WJi`000000fM[W0=WJi`0000000`3If^L00`000000fM[W0=WJi`0=
0=WJi`060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000406IVOP3k
o?d0Z:Vk06IVO[/0h=oS00<0fMGE000lM03oool03@3Ngn`00`000000g]o/
0=kOk0040=kOk0070000003Ngn`0g]o/0=kOk0000000g]o/000000020=kO
k0060000003Ngn`0g]o/0000003Ngn`000000`3Ngn`00`000000g]o/0000
00030=kOk0030000003Ngn`000000080g]o/00<000000=kOk03Ngn`04@3N
gn`01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm
0:RY^`1VIWjk0>3Oh`030=WEe@00?7@0oooo00d0hnG`00<000000>?Ul03S
iO00103SiO001`000000hnG`0>?Ul03SiO0000000>?Ul00000000P3SiO00
1P000000hnG`0>?Ul0000000hnG`000000<0hnG`00<000000>?Ul0000000
0`3SiO000`000000hnG`000000020>?Ul0D000003`3SiO001P3oool003ad
0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3O
h`030=WEe@00?7@0oooo00d0jN_e00<000000>W[m@3YjoD0103YjoD01P00
0000jN_e0>W[m@3YjoD000000>W[m@80000000H0jN_e000000000000jN_e
0000003YjoD200000080jN_e00<000000>W[m@0000000`3YjoD00`000000
jN_e000000020>W[m@050000003YjoD0jN_e0>W[m@0000003`3YjoD01P3o
ool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWjk0>3Oh`030=WEe@00?7@0oooo00d0l?7l00<000000?3ao03`lO`01@3`
lO`300000080l?7l00<000000?3ao00000000P3`lO`01@000000l?7l0?3a
o0000000l?7l008000000P3`lO`010000000l?7l0?3ao03`lO`400000080
l?7l0`00000@0?3ao0060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVO[/0h=oS00<0fMGE000lM03oool03P3dmOd0
1@000000m?Gm0?Ceo@3dmOd0000001/0m?Gm00<000000?Ceo@3dmOd0503d
mOd01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm
0:RY^`1VIWjk0>3Oh`030=WEe@00?7@0oooo00l0m_Om0`00000L0?Kgo@03
0000003fmod0m_Om01@0m_Om00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn^`3Pgn<00`3IeMD003ad0?ooo`15
0?Slo@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000406IVOP3k
o?d0Z:Vk06IVO[/0h=oS00<0fMGE000lM03oool0A@3moOd01P3oool003ad
0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3O
h`030=WEe@00?7@0oooo04D0oOgm00H0oooo000lM03Vi^T0IVIn0:RY^`3k
o?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn^`3Pgn<00`3He=@003ad0?oo
o`150?gmo@060?ooo`00?7@0iNGX06IVOP2XZK/0nocm0@1VIWh0000406IV
OP3ko?d0Z:Vk06IVO[/0h=oS00<0fMGE02EGQ@2oc]`0A@3oool01P2oc]/0
9EN50>7Qi01VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWjk
0>3Oh`040=WEe@1iU:T0EGfR0<3?gD<0oooo00L0eMoX05EmXP1iUJ/0gmgP
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`04
0=[Gf@3Og=P0NIBY02EGQD<003ad00L05den06J6X@3Pg]X0g=_M06IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjk0>3Oh`030=oMh03J
emT0f=CD02<0em?D7P3Cc/`30=OCe0070=SDe03IeMD0f]OI0=oMh01VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0
h=oS1`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVInF`3Pgn>[0:F//P0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWiK0>3Oh`030:F//P3oool0oooo0:L0oooo00@0YJbb06IVOP2X
ZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0?oo
o`3oool0Y`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVInF`3Pgn<00`2U[;80oooo0?ooo`2W0?ooo`040:F//P1VIWh0
Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhb0>3Oh`@000009@3P
gn<00`2U[;80oooo0?ooo`2W0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWhf0>3Oh`030000003Pgn<0h=oS0280h=oS
00<0YJbb0?ooo`3oool0Y`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn0>3Oh`04000000<0h=oS0`0000030>3Oh`<0
00000`3Pgn<300000080h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3O
h`80000000<0h=oS0000003Pgn<0103Pgn<2000000040>3Oh`000000h=oS
000000@0h=oS0P000000103Pgn<000000>3Oh`3Pgn<2000000040>3Oh`00
0000h=oS00000080h=oS00@000000>3Oh`3Pgn<000000P3Pgn<300000080
h=oS00H000000>3Oh`3Pgn<0h=oS0000003Pgn<2000000030>3Oh`000000
h=oS00@0h=oS00<0YJbb0?ooo`3oool0Y`3oool0102U[;80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000040>3Oh`030000003P
gn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0000
00030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000P3P
gn<2000000@0h=oS00<000000>3Oh`3Pgn<00P0000000`3Pgn<000000>3O
h`020>3Oh`030000003Pgn<0h=oS0080000000@0h=oS0000003Pgn<0h=oS
0P0000001@3Pgn<000000>3Oh`3Pgn<000000080h=oS00<000000>3Oh`00
00000`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000P0
h=oS00<0YJbb0?ooo`3oool0Y`3oool0102U[;80IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn1@3Pgn<00`000000h=oS000000050>3O
h`030000003Pgn<0h=oS00<0h=oS00L000000>3Oh`3Pgn<0h=oS0000003P
gn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3O
h`020>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`07
0000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0
00000080h=oS00H000000>3Oh`3Pgn<000000>3Oh`0000050>3Oh`070000
003Pgn<0h=oS0>3Oh`000000h=oS000000080>3Oh`030:F//P3oool0oooo
0:L0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP<0h=oS0P0000020>3Oh`D0000000<0h=oS0000003Pgn<0103Pgn<0
1`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0h=oS00<0h=oS100000000`3Pgn<00000
0>3Oh`020>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3O
h`030000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<000000>3Oh`05
000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`000000203Pgn<0
0`2U[;80oooo0?ooo`2W0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0h=oS00800000103Pgn<01`000000h=oS0>3O
h`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`04
0000003Pgn<0000000000080h=oS00<000000>3Oh`0000000P3Pgn<20000
00@0h=oS00H000000>3Oh`3Pgn<0h=oS0000003Pgn<200000080h=oS00<0
00000>3Oh`3Pgn<00P0000000`3Pgn<000000>3Oh`020>3Oh`050000003P
gn<000000000003Pgn<00P000000103Pgn<000000>3Oh`0000030>3Oh`04
0000003Pgn<0000000000080h=oS00<000000>3Oh`000000203Pgn<00`2U
[;80oooo0?ooo`2W0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0000000L0h=oS0`0000030>3Oh`<000000`3Pgn<3
00000080h=oS00@000000>3Oh`00000000000`3Pgn<2000000030>3Oh`00
0000h=oS00@0h=oS0`0000020>3Oh`030000003Pgn<000000080h=oS0P00
0000103Pgn<000000>3Oh`0000030>3Oh`050000003Pgn<000000>3Oh`00
00000P3Pgn<010000000h=oS0>3Oh`3Pgn<300000080h=oS00D000000>3O
h`00000000000>3Oh`03000000030>3Oh`000000h=oS00@0h=oS00<0YJbb
0?ooo`3oool0Y`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn000000040>3Oh`030000003Pgn<0h=oS01/0h=oS00<0
00000>3Oh`3Pgn<0;03Pgn<00`000000h=oS0>3Oh`060>3Oh`030:F//P3o
ool0oooo0:L0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP3Pgn<01000000N0>3Oh`030000003Pgn<0h=oS02`0h=oS
00<000000>3Oh`3Pgn<01P3Pgn<00`2U[;80oooo0?ooo`2W0?ooo`040:F/
/P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`03
0:F//P3oool0oooo0:L0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0?ooo`3oool0Y`3oool0102U
[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<0
0`2U[;80oooo0?ooo`2W0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3oool0oooo0:L0oooo00@0
YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS
00<0YJbb0?ooo`3oool0Y`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVInF`3Pgn>[0:F//P0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Oh`L0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS1`3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<70>3Oh`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Ohj/0
YJbb00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0
h=oS00<0YJbb0?ooo`3oool0Y`3oool0102U[;80IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80oooo0?ooo`2W0?oo
o`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiK
0>3Oh`030:F//P3oool0oooo03l0oooo00<000000?ooo`3oool0I@3oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn8P3P
gn<4000003D0h=oS00<0YJbb0?ooo`3oool0?`3oool00`000000oooo0?oo
o`1U0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWhV0>3Oh`030000003Pgn<0h=oS0380h=oS00<0YJbb0?ooo`3oool0
?`3oool00`000000oooo0?ooo`1U0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000D0h=oS00<000000>3Oh`00
0000103Pgn<300000080h=oS0P0000050>3Oh`80000000@0h=oS0000003P
gn<00000103Pgn<2000000040>3Oh`000000h=oS0>3Oh`80000000@0h=oS
0000003Pgn<000000P3Pgn<010000000h=oS0>3Oh`0000020>3Oh`<00000
0P3Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`80000000<0h=oS0000
003Pgn<0503Pgn<00`2U[;80oooo0?ooo`0o0?ooo`@000000`3oool01@00
0000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`020?ooo`<000000`3oool300000080oooo1@000002
0?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`<000000`3oool3
000000<0oooo0`0000030?ooo`030000003oool0oooo00<0oooo0`000003
0?ooo`<000001`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn000000050>3Oh`030000003Pgn<0000000<0h=oS00L0
00000>3Oh`3Pgn<0h=oS0000003Pgn<0000000D0h=oS00<000000>3Oh`3P
gn<00P0000000`3Pgn<000000>3Oh`020>3Oh`030000003Pgn<0h=oS0080
000000@0h=oS0000003Pgn<0h=oS0P0000001@3Pgn<000000>3Oh`3Pgn<0
00000080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS00000003
0>3Oh`030000003Pgn<0000001P0h=oS00<0YJbb0?ooo`3oool0?`3oool0
1@000000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo000000030?ooo`040000003oool0oooo000000@0
oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<00000
0?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0
000000<0oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`00
00040?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`03
0000003oool0oooo00@0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP0000001@3Pgn<00`000000h=oS000000060>3O
h`040000003Pgn<0h=oS000000D0h=oS00L000000>3Oh`3Pgn<0h=oS0000
003Pgn<0000000<0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<00000
00<0h=oS00<000000>3Oh`0000000P3Pgn<01P000000h=oS0>3Oh`000000
h=oS000000D0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000001P0
h=oS00<0YJbb0?ooo`3oool0?`3oool01@000000oooo0?ooo`3oool00000
00H0oooo00@000000?ooo`3oool0oooo1@0000030?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00D000000?ooo`3oool0oooo000000050?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo
000000030?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool0
0000203oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP0000001@3Pgn<00`000000h=oS000000040>3Oh`8000000`3Pgn<00`00
0000h=oS0>3Oh`040>3Oh`@0000000<0h=oS0000003Pgn<00P3Pgn<01`00
0000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS0000
00020>3Oh`050000003Pgn<0h=oS0000003Pgn<01@0000000`3Pgn<00000
0>3Oh`020>3Oh`030000003Pgn<0000001P0h=oS00<0YJbb0?ooo`3oool0
?`3oool01@000000oooo0?ooo`3oool0000000H0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`04000000@0oooo00@000000?oo
o`3oool000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo00000003
0?ooo`030000003oool0oooo00@000000`3oool00`000000oooo0?ooo`02
0?ooo`@000001@3oool00`000000oooo0?ooo`040?ooo`040:F//P1VIWh0
Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWh400000080h=oS00@0
00000>3Oh`00000000000P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3O
h`0000001@3Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`8000000P3P
gn<00`000000h=oS0>3Oh`02000000030>3Oh`000000h=oS0080h=oS00D0
00000>3Oh`00000000000>3Oh`02000000040>3Oh`000000h=oS000000<0
h=oS00@000000>3Oh`00000000000P3Pgn<00`000000h=oS0000000H0>3O
h`030:F//P3oool0oooo03l0oooo00@000000?ooo`00000000001`3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0000000@0oooo00@00000
0?ooo`3oool0oooo100000020?ooo`050000003oool0oooo0?ooo`000000
1@3oool00`000000oooo0000000300000080oooo100000040?ooo`800000
0P3oool4000000<0oooo0`0000020?ooo`050000003oool0oooo0?ooo`00
00000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?oo
o`3oool0oooo0P0000070?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0000000D0h=oS00D000000>3Oh`000000h=oS
000000020>3Oh`<0000000@0h=oS00000000000000001@3Pgn<300000080
h=oS00<000000>3Oh`0000000P3Pgn<2000000040>3Oh`000000h=oS0000
00<0h=oS00D000000>3Oh`000000h=oS000000020>3Oh`040000003Pgn<0
h=oS0>3Oh`<000000P3Pgn<01@000000h=oS000000000000h=oS00<00000
00<0h=oS0000003Pgn<0503Pgn<00`2U[;80oooo0?ooo`0o0?ooo`050000
003oool0oooo0?ooo`000000103oool00`000000oooo000000040?ooo`03
0000003oool000000080oooo00<000000?ooo`0000000`3oool00`000000
oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000001@3oool00`00
0000oooo000000050?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`0000001@3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3o
ool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`040?ooo`040:F/
/P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh000000140
h=oS00<000000>3Oh`3Pgn<0;@3Pgn<00`000000h=oS0>3Oh`0F0>3Oh`03
0:F//P3oool0oooo03l0oooo00D000000?ooo`3oool0oooo000000050?oo
o`8000001@3oool2000000<0oooo0P0000040?ooo`030000003oool0oooo
0080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<0
00000?ooo`0000000`3oool010000000oooo0?ooo`0000040?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`07
0000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0
oooo0080oooo00@000000?ooo`3oool000000`3oool00`000000oooo0000
00030?ooo`030000003oool0oooo00@0oooo00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPD0000000<0h=oS0000003Pgn<0
2P3Pgn<00`000000h=oS0>3Oh`0]0>3Oh`030000003Pgn<0h=oS01H0h=oS
00<0YJbb0?ooo`3oool0?`3oool4000000L0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo
100000020?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`@00000
0P3oool3000000<0oooo100000020?ooo`<000000`3oool300000080oooo
1@0000020?ooo`<000000`3oool3000000L0oooo00@0YJbb06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0?ooo`3o
ool0?`3oool00`000000oooo0?ooo`1U0?ooo`040:F//P1VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3oool0oooo
03l0oooo00<000000?ooo`3oool0I@3oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVInF`3Pgn<00`2U[;80oooo0?ooo`0o
0?ooo`030000003oool0oooo06D0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOU/0h=oS00<0YJbb0?ooo`3oool0?`3o
ool00`000000oooo0?ooo`1U0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030:F//P3oool0oooo0:L0oooo
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU/0
h=oSZ`2U[;800`1VIWh0Z:Vk0?_lo@0106IVOP0000<0IVIn0?Ogn@2HV:L0
o`1gMi8907MgTP40V9RW0@3gmoT106IVOP0000<0IVIn0?Ogn@2l_Ld0o`2l
_Ld:0;bmc@40moOi0@1VIWh0000306IVOP3gmoT0i>?S0?l0i>?S2P3Thn<1
0?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`320?ooo`030>CSh`2LY;T0JgF?
00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3o
ool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0
i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0YcY42@2V
>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F06IVOP3RhN80
nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m0?clo03l
no`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080o?cl00@0o?cm
0?clo03knod0o?cmA@3lnoa50?_lo1l0nocm00<0W:Bi06]eS`25RK004025
RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3k
o?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?clo03lnod0nocm
0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi
0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0
moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@140?OgnDD0m_Oi
7`3gmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[
MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ
3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@01
06IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@000000060?7am03`
l_D0lO7d0?7bm03`l_@0lO7dRP3`lODO0?3am00306]eS`2b]M00YjS20100
YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0
l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32
DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3L
fn00j^_`0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0
inOW0>OWi`030>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Z
jnl0j^_`0>CGeP030<O2d@040<O2g03Ii>/0j^_[0=W9d@80al;A00X0dmOQ
0<g2d@3=en/0j^_`0=o@d@37`]40dmg`0>[[l03ZjnD0dl;A0P37`]400`3=
en/0j^_`0>[[l0050>[[l0060=o@d@3CgO00j^_`0>[[l03ZgM`0am3U0P3Z
jo001P3Zjn/0fLWA0<O2g03Ojo00j^_`0>[Mg080al;A00@0alWQ0>C[i@3C
`]40am3U0P3Zjo000`3TemH0al;F0=WTl0040>[[l0060>CGeP37`]H0fNC`
0>[[l03ZgM`0cMO[0P3Zjo00103Od=40al;L0=o/j`3IbM420<O2d@050=?H
h@3=`]40cMS[0>[/l03Zgm`00P37`]401037bN40i>cU0=?2d@37d>D20>[/
l0050>CHeP37`]H0fNG`0>[/l03Zgm`00P37`]404037`]H0fNG`0>[/l03Z
iN40cL;A0<gHj`3Zk?00j]oL0<O2d@3Cgo00j^c`0>[Og037`]40dmo`0>[/
j`3IbM420<O2d@050=?Hh@3=`]40cMS[0>[/l03Zgm`00P37`]402037bN40
i>c[0=W9d@37`]`0gnc`0>[/l03Zk>D0dl;A0P37`]40103=f>/0j^c`0>[/
j`3IbM420<O2d@030=?Hh@3=`]40cMS[01l0j^__00@0JgF?0;Jid@2][/H0
[Jk6203oool00`2][/H0[:k60:f^aP030:f^aP030:b^aP2f^M40JgF?0080
j^__00@0JgF?0;Jid@2][/H0[Jk6303oool20:f^aP030:b^aP2f^M40JgF?
0080j^_`00D0YSU40<eIGP3;E5T0cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0
beAI0<eIGP2V>D@0j^__0>[[l0020>[[k`40g=_P0@1VIWh0000406IVOP3I
fMl0hnGZ0>?TjP80hnG[00D0000008b<S03Ng]h0inOW0=kNgP020>OWi`03
0<IS003WinL0inOW0080inOW00L0knoW0>o_k`3_knl000000>?TjP3Si>/0
hnGZ0080hnCZ00<0hnC[0<B4@@0>41000P0>4100100=3f`0QK2h0=3Ic`2:
@0l200h@400:06Z>S`103`l0>gVh0=3Ij`2[J`l03Q0@05jGgP3OiN/0hnFZ
068?3`803Q0@00<0A8k;0=K8d@3@fN/01@3SiN/03P2[J`l0HY?A0<O8gP3O
iN/0hje^00eQWP37`]T0f^G[0>?Uc`2=A@l03@mS09K2f@3JiN/0hje/0P0>
41002P0=AI40b>Fa06X?3`0=G9h0alkR0>?Uj`38STH03@m107^[eP3Fgn/3
0>?Uj`0<0<R>AP0=3d40Nj_A0=3Ij`3S[Fh0@H2h0<O8gP3OiN/0Zf/?00d?
H`2Fc/L0RT0?0P0>41001@1ZSXh0@0l?03]i^03@fNX0hja[00803Q0@00/0
3DFA0<ST/01Z3`l03EbN0<O>hP3Si>X0b8i600d?@@1kZmH0e]oZ0>>XJ002
00h@400@00d?AP2=a=h0c<SN0=o8T@143`l0?WVh0<cCi@3S[6h03Q0@05jC
d@3@fNX0hja^00h@401NTm40d=W>08Y03`803Q0@00D0JXj>040?3`0kNKP0
d=WZ0>>/J`0200h@400800e5T@38i<h0SDD?00d?H`2F`]T0f^CZ0>?TZP1R
3`l200h@400404B>b@3Fb=40d=W>08Y03`803Q0@00@0JXj>040?3`0kNKP0
d=WZ7`3SiNX01@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:b
bP2b//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0
oooo02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@0
0P3=FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0e5aO0=1KH03=
FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3G
f=h0g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OFcP020>OWi`050<ik
003_U100inOW0>ONaP3_S1000`3_knl07`000000g=kV0=cNi@3Lg^D0g=kV
0=cNi@31RT<03Q0@05jJgP3Lg^D0g=k908Q33`1WZ>D0`HY500h@401NTm@0
d]W908Q33`0>4100GY?D0=;I[@1W3`l03C^20:o7f`3HgZd0I`l?00dkPP2e
eND0g=k908Q33`1WZ>D01@3Lg^D06`3LgZd0I`l?00dkPP2_`]@0d]WU0:EV
3`0=3f<0U/;A0<kEi@3Lg/T0R4<?00d?H`2F`]P0eMk908Q33`0=>h80[lOK
0=SNi@3LgZd0I`l?00eLWP37c=h0g=kU0<6:A@0=3d00Nj_D0=;Ii@030=cN
i@1?0=bXJ`0>4100Gi?A0<_@hP2UJ0l03C^20:o2e03BfLT0R4<?00eLWP2c
PT@03Q0@05jCe03BfLT0R4<?00h@401NTm@0d]W908Q33`0=>h80[lOK0=SN
i@3LgZd0I`l?00eLWP37c=h0g=kU0<6:A@0=3d00Nj_D0=:oSP103`l03EbP
0=;Ii@3La8h0@D>>0<7Ni@3La8h0@@l?03ai^03;d>80g:Q[00h@401NTm40
c]GU0=bXJ`0>4100GY?A0;F5A@0>4100GY?D0=;Ib@28@`l03Q0@05jCe03B
fLT0R4<?00dkPP2_am/0f=kU0=cNb@28@`l03@mS09K2f03EgZd0I`l?00dk
PP2eeND0g=k908Q33`1WZ>D0`HY500h@401NTm@0d]W908Q33`0>4100GY?D
0=;Ii@0O0=cNi@0506]eS`2o`MH0^;W>0;RicP3oool01P1^KHl00`0U9CH0
^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU0=cNi@1[MHl0_l7F0P2h^Lh0
0`3oool09BDf0;RicP070;RicP030?ooo`0U9CH0^;W>0080^;W>00T0_l7F
06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C9B000`3oool50=IOH`<0
oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA0020=cNi@030=cNiP3Lg^D0emSN
0040IVIn0000101VIWh0eMKM0=GHh03Ff>420=GHh0090000002<S8`0inOW
0>OWi`3W]H@0eUX00=J4003ocP00cV<00080gV/000D0kkF<0>o_k`3_knl0
kno_000000020=GHh@060=GGh03Ff>00e]RZ06@?3`0=G9h0c=3P103Fen00
3`2lQD@03@m107^[d@39cMh0XVD?00d?@01kZm<0cm>Z06@?3`0=>h80[lKI
0=BSJ@0>4100GY?C0<oCh0080=KGh00K0=JSJ@0>41003@m107nad@39]8X0
?`l?00h@401QU]40alWK0=KGa@25@@l03@mS09K2eP3AejX0I0l?00dkPP2_
a]T0e=OP0=KGZP1T3`l03EbN0<O9f`3Fen00_8E400d?@01kZm<0cm?P00<0
e]OP0240e[f;040?3`0nNKP0bLfX06@?3`0=3d40P;7A0<W=Z01T3`l0?7Vh
0;B2A00=3d40Nj_A0<W=gP2RIPl03@m007^[d`3?e:X0I0l?00dkPP2_a]T0
e=SP0=KHZP1T3`l03EbN0<O9f`3Ff>00_8I400d?@01kZm<0]XA400d??`1k
Zm401037`]407`37/HP0@0l?03ai^039cMh0eZ=Y00h@401NTm40c=7P0=JS
J@0>4100GY?A0;B2A00=3d40Nj_A0<W=gP2RIPl03@m007^[d`3?e:X0I0l?
00dkPP2_a]T0e=SP0=KHa@25@@l03@mS09K2eP3AXfT03Q0@05jCd`3?e>00
0`3Ff>00202lQT@03@m107^[d@39cMh0XVH?00d?@01kZm<0cmCP7`3Ef>40
1@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?0=GH
h@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M401`2l_M400`3oool0
9BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V>D@00P3EGF000`3H
H640fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@020=EM
H0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0000706IVOP3Be=d0
cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36BP00mlh00>n]003_
]@00cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@d]`01@3?d]`0d9iW
00h@401NTm<0c<oL00@0d=;L00l0d9iW00h@400nOk`0al;A0:mi?`0=3cl0
Nj_C0<c?YP1R3`l03C^20:o4eP2fPd<03@m007^[d@3:c=`0203@d]`06`2M
H`l03@mS05iO3`0nOk`0[gU000eMPP1m?Pl03F2O0<O2e@3=d/40PD0?00d?
H`2F`]D0cM:V068?3`0=>h80[lCF0<oBg03@dZH0HPl?00eLWP37b=P0d=;L
0;R3@`0=3d00Nj_C0<c?g0030=3Bg00O0=3BYP1R3`l0?WZh0<NGIP0=?880
O60?03io_037[8D0?Pl?05jCd`3;W6P03Q0@03io_037`]40[gTo00d??`1k
Zm<0blnW064?3`0=>h80[lCG0<gBg@3?dZL0H@l?00eLWP37b=T0cm;M0;J3
@`0=3d00Nj_C09UR3`0500h@400P00eLWP37/8H0?Pl?03ai^038b]/0ciiX
00h@401NTm40bLcM0<nNJ00>4100GY?A0<VJJ00>4100?Wnl0<O2d@2_NCl0
3@lo07^[d`3;cjL0H@l?00dkPP2_a=L0cM;M0<oB``20@0l03@mS09K2e@2d
Pd<03@m007^[d@39c=d30<oBg@080<nNJ00>4100?Wnl0<O2d@2_NCl03@lo
07^[d`3;cmdO0=3Bg00306]eS`38bM/0`lCF0100`lCF00H0b<WK06]eS`3@
d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U9CH0`lCF00L0`lCF00<0oooo
02DU=P33a=H00P33a=H01`38bM/0JgF?0<oBg03?d]`0YSU40=MOG`3IHF80
0`3LIFD01@167QX0oooo0?ooo`3oool0g6EU00<0oooo00P0AQhJ0=aUI@3L
IFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?d]`10=;Dg@40IVIn0000
7P1VIWh0d=;K0<_=f03:cMT0blkH0<[=f0000000ilJ]0>O6S03gcQP0kkd0
0?O6003_[@00ijd00>NU003FS000cV/00>O6003oeP00knoW0>o_k`000000
blgH0<_=f@3:cMT0blkH0;:0@@0=3d00Nj_C0<W<f@D0blgI0180bi]V00h@
400>41003Q0@00d??`1kZm<0bLfT05l?3`0=>h80[lCE0<ZKIP0>4100GY?A
0<O4e@3:cMT0blgI0<W6d`39c=T30<_=f@0L0<_=Y01O3`l03EbN0<RHIP0=
3d40?3`?05jDe@2bP4403@mT09O2d@38bKl0OSl?00d?H`2F`]<0bLfT05l?
3`0=>h80[lCE0<[=f@3;cJ@0G`l?00eLWP37a=D0b/gI0;>0@@0=3cl0Nj_C
0<W=f@<0blgI00`0blfo07ho3`0=GYh0UUd?03ai^038V6H03Cj50:nCI00=
3d00Nj_C0<W>f@3;W6H300h@400S00d??`1kZm<0bLjT05l?3`0=>h80[lCE
0<[>f@3;cZ@0G`l?00eLWP37a=D0b/kI0;>0@@0=3cl0Nj_C0;60@@0=3d00
O:_A0<S8e`3;cZ@0G`l?00eLWP38/XH0?0l?03ai^037a=D0bYaV00h@401N
Tm40b<SG0<^LIP0>4100GY?C0<W<f@3;W6H00`0>4100500=3cl0Nj_C0<W>
Y01O3`l03C^20:o4e@3:c]T0bljo07ho3`0=3f<0U/;C0<VLIP0>4100GY?A
0<O4e@3:c]T0blkI0<W6d`39c=T0biaV0`0>41000`0=3cl0Nj_C0<W>f@0O
0<_=f00306]eS`3;c=h0b<[I00P0b<[I00<0b<WI0<S:f@38b]T00`38b]T0
1038bMT0b<[I0<_<gP1[MHl20<_=f00606]eS`3;c=h0b<[I0<S:f@3oool0
9BDf1@38b]T04@38bMT0b<[I0<S:f@3oool09BDf0<S:f@38bMT0b<[I0<_<
gP1[MHl0blkH0<[=f02V>D@0eemO0=]TI03PIfD0h6IU0080gVMW00<0AQhJ
0?ooo`3oool00`3oool02P167QX0gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0
YSU40<[>f03:c]T20<_=f@40d=;K0@1VIWh0000306IVOP3?cmX0aLSD00<0
aLSD00H000000<K6aP3Wg]H0cW/00>N]003_]@020>NU00030=JD003>L`00
eY@00080mlH00P3gmoL02@000000aLSD0<G7e035am@0aLOE0:il@00=3d00
Nj_A0<K5e@060<C7e@0@0<C4d@37`]40UU`?00d?H`2Ea]D0a<NQ05`?3`0=
>h80[l?C0<C7X@1L3`l03Cb40:k3d@37`]40UU`o07^/d`@0a<OE01/0a9MT
00h@401NTm<0a<Nl07Tl3`0=?8<0[lCD0<B_Q@0k3`l0GI?A0<O3^P1j?0l0
3@mS09K2d`34aj00G@l?00dkPP2_`]40al;A0<O4W`1L3`l03C^20:o2d@37
`[P0Nc/?00d?H`2Ea]D01@34amD02@2DGPl03Ca003/?3`1NTm<0a:n503/?
@01MGCl03@mS09K4d`020<C8e00T0<C4d@37`]40UU`?00d?H`2Eam@0a<RO
05d?3`0=>h80[l;A0<O2d@37a9l0G0l?00dkPP2_`]40al:h07/k3`0=3f<0
ULOD0<B`Q00k3`l0>gbj0<K2d@37Tf<03Q0@05fEd`34/8@0>`l?00dkP`2^
aM80[gTo00h@400kNkX0a<GB0:mi?`0=3cl0NjkC0P34b=@05@34a=40al;A
09IL3`0=3f<0ULOD0<C8W`1M3`l03C^20:o2d@37`]40alBj07Tl3`0=3f<0
U/;B0<C8X01L3`l03Cb40:k3d@37`]40UU`o07^/d`020<C8e0060<C4d@37
`]40UU`?00d?H`2Eam@0a<SD7`34am@00`1[MHl0d=7P0<_;g00@0<_;g006
0=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3oool09BDf0<_;g007
0<_;g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]eS`35am@0a<OD0:Hi
A03KI6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo04HN6P050>1ZJ004
0=mUI03KI6@0YSU40<C8e@80a<SD0@35amD10<o?fP40IVIn0000101VIWh0
c<kJ0<;4dP31a=420<74dP060000003WinL0inOW0>OWi`3FQ000kkD00P3W
Y@00203FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL000000`31a=801P32
a=40`IAS00h@401MTm40al;A0<;4d@@0`LCA00d0TUd?00h@400>41003@lo
07R/d@31a=40`LBN05/?3`0=>h80[l;A0<;4d@31a;P0N3`?00803Q0@00<0
3Cb20:[4d@31a=400P31a=404031a;P0N3`?00dlPP2Za=40`LCA0:Yj?`0j
N[P0`LCA0<74^01h?0l03Cb207QM3`0>41003@mS09;4^01h?0l300h@4003
00eMWP31a9h0F`l?00<03Q0@00<03@lo07R/d@31a=401@31a=402`2ZNSl0
3Q0@00d?H`2F`m40`LBh07Pl3`0>41003EbN0<K3d@31a=80TUd?00803Q0@
00@03@m007R/dP31a;P0N3`?0`0>41000`0=GIh0`LBN05/?3`0300h@4006
00d?@01h[=80`LCB0<74dP31[8<0>Pl?0P0>41001@0jN[P0`LCB0<6/P`0j
3d00N7YS00803Q0@00D0>WZh0:Yj@00>41003Q0@03Yj^0020<74dP07099M
3`0>41003Q0@00d?@01h[=80`LBh07Pl3`0300h@400800eMWP2BG@l03Q0@
00d?H`2Ba=80`LCB0<74^01h?0l200h@400400dlP`2Za=80`LCB099M3`80
3Q0@00@03@m007R/dP31a=80`LCB7`32a=800`1[MHl0dm?R0<o@g@0@0<o@
g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?d=d00`3oool09BDf0<o@
g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M00L0dm?R06]eS`32a=80`LCA
0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/J@080>5YI@3KI6@0YSU40<74
dP32a=40`LCA0<74dP3<c]X106IVOP0000@0IVIn0<[<f02n`<l0_L3?0P2n
`<h01@000000W9bL0>OWi`3Wg]H0eX`00080gY@000@0eW/00<IS002m@P00
kjD00P3g[@00403g]@00oli:0000002n`<h0_/3?0;k0cP2n`<l0_L2L05X?
3`0=>h80[l;A0<G1c`2n`<h0_/3?0<?1d033`<h60;k0cP050;k0W01J3`l0
3C^20:o1c`30`<h05P2n`<h02`31`M40al;@0<70W01J3`l03C^20:o1c`30
`<h0_/2L05X?3`0=G9h0al7?00T0_/3>00T0_Y5Q00h@400=G9h0aL7?0;k0
cP2WMcl03Q0@03]i^034`<h01`2m`<h02@2m`9`0FPl?00dkPP2_`Ll0_l3>
0;g0W01J3`l03EbN0<O1c`0M0;g0cP050;g0W01J3`l03C^20:o1c`2o`<h0
0P2m`<h00`30`M40al;@0<30cP0>0;g0cQl0_/3>00<0JgF?0=KFi03Cdn00
403Cdn001P3Fe^@0JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P00<0oooo02DU
=P3oool0203oool02`0U9CH0dm?P0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>
0:HiA03PIVD0hFYZ00@0hfa/0`3oool010167QX0oooo0?ooo`3oool40>=/
K0040>5ZJP3PIVD0YSU40;g0c`80_/3?0@2n`<h10<[<f040IVIn00001`1V
IWh0bL[H0;Jhb02i_</0^[c;0;Zlc00000000P3_knl06@3FW000eX`00=jD
003FQ000kjD00=j<002mFP00eW<00>nL003gknL0moOg0?ooo`000000^Kc<
0;Zkc02i_</0^[c;0;Vlc02iSV003Q0@03Ue]P34`]40al:h07/k?`1kZLh0
1`2i_<`01@2i_9X0E`l?00dkPP2_`Ll0_;c<01D0^Kc<00`0S5X?00d?H`2F
`/l0_[c<08aJ3`0=>Wl0Xkc<0;Vlc02i_9X0E`l?00eLWP37`<h90;Vlc009
0;VUO`0i3`l0>WVh0<2lc02i_<`0^HiQ00h@401LTm00`;c<00P0^[c<00P0
SEX?00djO`2T_<`0^[c<0;ZlVP1G3`l03EbN0<O0cQh0^[c<00<0SEX?00dj
O`2T_<`00P2j_<`0102=FPl03@mS09K2c`2n_<`>0;Zlc1l0^[c;00<0JgF?
0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?0;Zlb`2j_</0JgF?0=SHi@80dm?Q
00<0oooo06i]S`1^KHl0201^KHl03P0U9CH0dm?Q0=?Ch@3Cdn40f=SU06]e
S`2j_</0^[c<0:HiA03PJFP0hFe/0>AaK@3TLFl0i71^0`3oool00`167QX0
i71^04HN6P030?ooo`80i71^00T0i75]0>5]K03PJFP0YSU40;Zlc02j^l`0
^Kc;0;Jhb039b]P00@1VIWh0000906IVOP37bML0];K70;Jhb02f^<T0][W9
00000024Q8@0inON0080kno_00L0aV/00?O6003_]@00ki`00=j<003>J`00
ii`000<0moOg00D000000;Jib@2g^<T0][W90;Nib@020;Jhb@050;NRO@0g
3`l03Q0@00h@400=EiP0202g^<T0102g^9P0EPl?00diO@2Q^<TF0;Nhb@03
08YG3`0=3el0R[S900D0]kS900<0]kRH05H?3`0=EiP02P2g^<T00`2g^9P0
EPln076Rb@020;Nhb@040;NhV01F3ch0LJ;90;Nhb@`0][S900<0][RH05H?
3`0=EiP0902f^<T00`29E`l03@mO08Vhb@0?0;JhbAl0]kS900@0JgF?0=KF
i03Hf>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@090=KFi01[MHl0
]kS90;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d09BDf0=SHiP3H
f>D0f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0
oooo00D0AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>AdK`3WLFl0i7A_
0>A^K@2V>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn00000`1VIWh0a/SG
0;Bfa`030;Bfa`030000003_knl0kno_0080kno_00/0ijd00?O6203WY@00
ii@00>N<003_imH0gY@i0>oF]@3omoL0oooo0000002_0;Bfa`0506]eS`3E
eN<0g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GE
h`80g=_W00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GEh`1[MHl0];K7
0;Bfa`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ0>UnN03YOWP0
0`3YOWP020167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d]/L1
0<K8e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`060000002<S8`0kno_
0>o_k`3WcW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0knOF0?Ogm`3o
ool00000[`2d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0];K7
0;Bfa`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0YSU40>YiL`3Y
O7P0kh5j0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:0>^H
R`0204HN6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L10<K8e`40IVIn
00000`1VIWh0a/SG0;6cb0030;6cb0060000003_knl0kno_0>o_k`3gmnl0
kno_0P3gmoL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`000000/K?80:h0
/K?800<0JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?
0>g[la40jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03g
WHh0lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[
UP3gWHh0mHb40?24O03aP7D0YSU400@0/K?80@36b=L106IVOP0000<0IVIn
0<K8e`2h]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3o
moL20?ooo`030000002_[/L0[jk70:d0[jk700<0JgF?0=;Ah`3blOL0403b
lOL01P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0d]7S06]eS`2_
[/L0[jk70:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^a`02
0:n^a`40^;O?0@36b=L106IVOP0000<0IVIn0<31d@37am@0`P2/Zl@01024
S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400@0
Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a007
096HZP2V>D@0oin=0?joY03jg;L0n^^g0?[Y]P020?WY]P040?[Y]P3ijKH0
nNVf0?[Y]P80nNVf00H0n^^g0?[L]`3n_j@0oin=0:HiA02AV:X30:b[a040
alOD0@30`M4106IVOP0000@0IVIn0<31d@3Bd]l0]KC9`P2TXkh00`24S:80
JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]eS`1[
MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V>D@0YSU400l0
YSU400L0Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040IVIn00001P1V
IWh0Z:No0>KVk@3Bd^00_;c?0;6`a?l0Z:No0`2XYkl01@2a/<@0_;c?0=;B
h03Vi^d0Z:No0040IVIn00001`0jKZD0QhNK0=OHhP3lo?`0i>?X0=3@h03:
b]X0o`2l_<l10;blc`060<[:fP3@d>00i>?X0?clo03Gf>80QhNK0@3oool0
000803Y^Y@1VIWh0UIB[0=OHhP3lo?`0l_7c0>c[kP3Qh^_n0=OHhP070>7R
j`3/jnh0l_7c0?clo03Gf>80UIB[06IVOP010?ooo`000P0jKZD00`1VIWh0
UIB[0=7AgP020?clo?l0oooo0@3oool20?clo0030=7AgP2EU:/0IVIn0080
oooo000303Y^Y@80IVIn00<0R8NM09FDZ`2XYkl0o`2XYkl01P2EU:/0R8NM
06IVOP1VIWh000000000B040W=oo000503Y^YOl0IVIn1@1VIWh01018M;l0
oooo0?ooo`3ogi`104Q8W000\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  Evaluatable->False,
  ImageSize->{270, 213},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Loading"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"Loading"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interacting with GUIs", "Section",
  CellTags->"InteractingIntro"],

Cell[TextData[{
  "This section discusses interacting with user interfaces already running \
using the ",
  StyleBox["GUIObject", "Output"],
  " expression as a handle on the widgets that make up the interface."
}], "Text",
  CellTags->"InteractingIntro"],

Cell[CellGroupData[{

Cell["Referencing Widgets", "Subsection",
  CellTags->"Referencing"],

Cell[TextData[{
  "When we have access to a ",
  StyleBox["GUIObject", "Output"],
  ", we can discover what special widgets are registered with unique \
reference string names. Using these names, we can modify and further discover \
member information about these widgets, such as what properties, method \
functions, and events exist to control them."
}], "Text",
  CellTags->"Referencing"],

Cell[BoxData[
    \(\(Needs["\<GUIKit`\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Referencing"],

Cell[TextData[{
  "Here we gain access to the ",
  StyleBox["GUIObject", "Output"],
  " associated with an interface created in a modeless session."
}], "Text",
  CellTags->"Referencing"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ GUIRun["\<Wolfram/Example/AngleDialog\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Referencing"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject440989927866369, 
        JLink`Objects`JavaObject210201571491841]]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Referencing"]
}, Open  ]],

Cell[TextData[{
  "We can easily take a dynamic snapshot of the interface as we use it by \
calling the utility ",
  StyleBox["GUIScreenShot", "Output"],
  " function."
}], "Text",
  CellTags->"Referencing"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // \ Show\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Referencing"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003?0000/2000`400?l0
0000o`00003oc`1VIWh0000306IVOP3ko?d0nocm0</0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0<T0IVIn0@2XZK/10?_lo@40IVIn00000`1VIWh0nocm
06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3P
gn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh1
0?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IV
OP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IV
OP3ko?d0IVIn04h0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;bm00C0??cm100
n?Oh0P3clo@01@3cloD0m?Ce0?GemP3dloD0iNCX00H0h=oS00D0hN3T0>KU
j03/jnh0l?3b0?;bm00L0??cm1T0n?Oh0P3clo@01@3cloD0m?Ce0?GemP3d
loD0iNCX00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>
0>3Oh`040=kLg`3Th^00NiN]02EGQBL003ad00@05den06^;YP3blNh0l_7c
1P3Pgn<0103Ng=l0i>;P07^G[@0UEhDi000lM00401M=OP1[RjH0l_7^0?;a
l`D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`04
0=[Hf@1VQJ409df504em`BP0JH;^00<09df506Z:Y03_ko401P3Pgn<0103J
f=T0IXFQ04YaT`2b_L<i0<K5e`040<36a@18KY00JXZT0>o_l@D0h=oS0@1V
IWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`030=SEeP0GCGh0
RJgT02X0RJgT00<05den0>_Zk@3Pgn<01@3Pgn<00`3HeMH05den0;o7bP0k
0<K5e`030;Jm_@0GCGh0jn[]00D0h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP1>0>3Oh`040=WEe@00?7@0RJgT0?ooobL0cLcO00@0oooo
08V]i000?7@0j>OZ1P3Pgn<00`3IeMD003ad0?ooo`0k0<g<g`030?ooo`00
?7@0j>OZ00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>
0>3Oh`040=WEe@00?7@0RjgT0?ooobL0d]7T00@0oooo08^_i@00?7@0inKY
1P3Pgn<00`3IeMD003ad0?ooo`0k0=;Ai0030?ooo`00?7@0inKY00D0h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`040=WEe@00
?7@0SZoV0?ooobL0e]OW00@0oooo08f_i@00?7@0inKY1P3Pgn<00`3IeMD0
03ad0?ooo`0k0=KGi`030?ooo`00?7@0inKY00D0h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`040=WEe@00?7@0TK7W0?ooo`h0
fM[W0`0000030=WJi`030000003If^L0fM[W0080fM[W00<000000=WJi`3I
f^L02`3If^L0103oool0TK7V000lM03Wi^T60>3Oh`030=WEe@00?7@0oooo
00l0fM[W0`0000030=WJi`80000000@0fM[W0000003If^L000000`3If^L0
0`000000fM[W0=WJi`03000000<0fM[W0`0000020=WJi`030000003If^L0
fM[W00`0fM[W00<0oooo000lM03Wi^T01@3Pgn<106IVOP40nocm0@1VIWh0
000306IVOP3ko?d0IVIn04h0h=oS00@0fMGE000lM02D]>P0oooo3@3If^L0
1@000000fM[W0=WJi`3If^L000000080fM[W00D000000=WJi`3If^L0fM[W
0000000>0=WJi`040?ooo`2E]>P003ad0>OVj@H0h=oS00<0fMGE000lM03o
ool03P3If^L01`000000fM[W0=WJi`3If^L000000=WJi`0000000P3If^L2
000000030=WJi`000000fM[W0080fM[W00<000000=WJi`0000000`3If^L0
0`000000fM[W000000030=WJi`030000003If^L0000000h0fM[W00<0oooo
000lM03Wi^T01@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn
04h0h=oS00@0fMGE000lM02H^>X0oooo303Ngn`00`000000g]o/0=kOk003
0=kOk0030000003Ngn`0000000<0g]o/00<000000=kOk03Ngn`0303Ngn`0
103oool0V;SY000lM03Wi^T60>3Oh`030=WEe@00?7@0oooo00d0g]o/00<0
00000=kOk03Ngn`0103Ngn`01`000000g]o/0=kOk03Ngn`000000=kOk000
00000`3Ngn`00`000000g]o/000000050=kOk0030000003Ngn`0g]o/00<0
g]o/00<000000=kOk03Ngn`0303Ngn`00`3oool003ad0>OVj@050>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad
09bkjP3oool<0>?Ul0030000003SiO00hnG`00<0hnG`00H000000>?Ul000
000000000>?Ul000000?0>?Ul0040?ooo`2L^n/003ad0>OVj@H0h=oS00<0
fMGE000lM03oool03@3SiO000`000000hnG`0>?Ul0050>?Ul0@0000000<0
hnG`0000003SiO000P3SiO000`000000hnG`000000050>?Ul0D0000000<0
hnG`0000003SiO003@3SiO000`3oool003ad0>OVj@050>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad0:2nk03o
ool<0>W[m@030000003YjoD0jN_e00<0jN_e00@000000>W[m@000000jN_e
0P00000?0>W[m@040?ooo`2Q_^`003ad0>OVj@H0h=oS00<0fMGE000lM03o
ool03@3YjoD00`000000jN_e0>W[m@040>W[m@060000003YjoD0jN_e0>W[
m@000000jN_e0P0000020>W[m@030000003YjoD0000000<0jN_e00<00000
0>W[m@0000000`3YjoD00`000000jN_e0000000>0>W[m@030?ooo`00?7@0
inKY00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3O
h`040=WEe@00?7@0YL7]0?ooo``0l?7l00<000000?3ao03`lO`00`3`lO`0
0`000000l?7l000000020?3ao0030000003`lO`0l?7l00d0l?7l00@0oooo
0:G2kP00?7@0inKY1P3Pgn<00`3IeMD003ad0?ooo`0=0?3ao0030000003`
lO`0l?7l00D0l?7l0`0000020?3ao0040000003`lO`00000000000<0l?7l
0`0000030?3ao0<000000P3`lO`00`000000l?7l0?3ao00<0?3ao0030?oo
o`00?7@0inKY00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IV
OP1>0>3Oh`040=WEe@00?7@0ZLG_0?ooo`d0m?Gm00D000000?Ceo@3dmOd0
m?Gm000000020?Ceo@050000003dmOd0m?Gm0?Ceo@0000003P3dmOd0103o
ool0ZLG_000lM03Wi^T60>3Oh`030=WEe@00?7@0oooo00h0m?Gm00D00000
0?Ceo@3dmOd0m?Gm0000000I0?Ceo@030000003dmOd0m?Gm00`0m?Gm00<0
oooo000lM03Wi^T01@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn04h0h=oS00@0fMGE000lM02]b?00oooo3P3fmod3000000<0m_Om00<0
00000?Kgo@3fmod00P3fmod00`000000m_Om0?Kgo@0;0?Kgo@040?ooo`2/
ao0003ad0>OVj@H0h=oS00<0fMGE000lM03oool03`3fmod3000001X0m_Om
00<000000?Kgo@3fmod0303fmod00`3oool003ad0>OVj@050>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad0;7;
lP3ooolW0?Slo@040?ooo`2ac?8003ad0>OVj@H0h=oS00<0fMGE000lM03o
ool0>`3ho?d00`3oool003ad0>OVj@050>3Oh`40IVIn0@3ko?d106IVOP00
00<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad0;C=l`3ooolW0?gmo@04
0?ooo`2ec_<003ad0>OVj@H0h=oS00<0fMGE000lM03oool0>`3moOd00`3o
ool003ad0>OVj@050>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1V
IWh0CP3Pgn<0103IeMD003ad0;O@m03ooolW0?gmo@040?ooo`2hd?D003ad
0>KVj@H0h=oS00<0fMGE000lM03oool0>`3moOd00`3oool003ad0>KVj@05
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103H
e=@003ad0;[Cm@3ooolW0?gmo@040?ooo`2jdoH003ad0>GUj0H0h=oS00<0
f=CD000lM03oool0>`3moOd00`3oool003ad0>GUj0050>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<00`3IeMD09EN50;cDmP0Z
0;cDmP0302EGQ@3QhN@0h=oS00D0h=oS00<0fMGE02EGQ@2oc]`0>`3oool0
0`2oc]/09EN50>7Qi0050>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh0CP3Pgn<00`3IeMD0NIBY02M=Q@0Y0<kWo`0302M=Q@1iUJ/0gmgP
00H0h=oS00@0fMGE07VDZ@1EOJ80`<oM>@3oool0103EgnP0EGfR07VEZ`3O
gN050>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0
103JemT0gmcH07VDZ@0UEhDW000lM00401M=OP1VQZ40h=kJ0=cKg@H0h=oS
00@0f]OI0=oLf01iU:T09EN5>@00?7@0100GCGh0IXJQ0>3NfP3Lfmd50>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<00`3OgN00
f]OI0=SDe00E0=OCe100dlk<0`3Gdm@0103He=@0fMGE0=[Gf@3OgN060>3O
h`030=oMh03JemT0f=CD01h0em?D6@3Cc/`30=OCe0040=SDe03IeMD0f]OI
0=oMh0D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40
nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn
00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn
0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn0000
0`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1V
IWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP0A0>3OhjL0oooo4@3Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn0140h=oSYP2LW9h00`3oool0h=oS0>3Oh`0?0>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo
0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn
00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80h=oS00<0
W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3Oh`0@
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2L
W9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_l
o@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80
h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IV
OP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo
0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3P
gn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1V
IWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0
h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0
000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2L
W9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1V
IWh04@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bL
WP3oool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3P
gn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`0G0>3Oh`070<c@f@2GZ[h0
EGZM02AGQ01ENYd0UjZn0<c@f@0C0>3Oh`@000009P3Pgn<01`3<d=T0UjZn
05EjW@0TEh@0EGZM09NZ_P3<d=T0@03Pgn<00`2LW9h0oooo0>3Oh`0@0>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0
oooo0>3Oh`0E0>3Oh`0;0=kNhP2U]LD085B206j@[@2jbMH0loGf0;c;f@1`
TJl085B20:Fea@3Ng^805@3Pgn<00`000000h=oS0>3Oh`0Q0>3Oh`0;0=kN
hP2U]LD085B206j?[02ib=D0l_Ce0;c;f01`TJl085B20:Fea@3Ng^80?P3P
gn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`0E0>3Oh`0;0:Fea@1LPJ80
]/GB0?OgmP3inOP0n_[i0?cln`3moOd0_<cI0625YP2U]LD01P3Pgn<20000
00040>3Oh`000000h=oS0>3Oh`<000000`3Pgn<2000000040>3Oh`000000
h=oS000000@0h=oS0`0000030>3Oh`<000000`3Pgn<3000000h0h=oS00/0
YKG505^1X@2ea=00mOGd0?OgmP3inOP0no_j0?gmo02lc=T0H8FV0:Fea@05
0>3Oh`030000003Pgn<0h=oS0080h=oS0P000000103Pgn<000000>3Oh`3P
gn<2000000040>3Oh`000000h=oS00000080h=oS0P000000103Pgn<00000
0>3Oh`0000030>3Oh`030000003Pgn<0h=oS00<000005`3Pgn<00`2LW9h0
oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0
4@3Pgn<00`2LW9h0oooo0>3Oh`0D0>3Oh`0=0<c@f@0PE880/l??0??cl@3e
mO<0moOf0?Win03jn_T0o?ck0?gmo@2lc=T085B20<c@f@040>3Oh`030000
003Pgn<0h=oS0080000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS
000000020>3Oh`80000000<0h=oS0000003Pgn<00P3Pgn<01`000000h=oS
0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0h=oS00X0h=oS00d0c=3I021DPP2b`Ld0lO7_0??cl@3e
mO@0moOf0?Win03knoX0oOgl0;c<f@0PE880c=3I00@0h=oS00D000000>3O
h`3Pgn<0h=oS000000020>3Oh`80000000@0h=oS0000003Pgn<0h=oS0P00
0000103Pgn<000000>3Oh`0000020>3Oh`80000000<0h=oS0000003Pgn<0
0P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0h=oS01@0h=oS
00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3k
o?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0503Pgn<03@2GZ[h0JH^W0>o_
k03alNl0j>kV09[<V00TUR@0V<VG0>kck@3lo?/0oOgm072A[`2GZ[h0103P
gn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000001@3Pgn<01`000000
h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`03
0>3Oh`030000003Pgn<0h=oS00H0h=oS00<000000>3Oh`3Pgn<02`3Pgn<0
3@2GZ[h0J8VV0>c/j@3_kn`0lO7_0??cl@3emO@0moOf0?Win03knoX0oOgl
072A[`2GZ[h0103Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00<0
00000>3Oh`0000000`3Pgn<01@000000h=oS0000003Pgn<0000000<0h=oS
00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000
003Pgn<0h=oS01D0h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0503P
gn<03@1ENYd0[[k80>c/j@3_kn`0X=:N02ZX9`0RXR004i8@09S8U`3jn_T0
o?ck0;c;f@1ENYd0103Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`D0
000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS000000030>3Oh`D0
000000<0h=oS0000000000000`0000020>3Oh`8000003P3Pgn<03@1ENYd0
Zk[60>SXi@3/k>T0kno/0?7ak`3clo40mOGd0?OgmP3inOP0no_j0;c;f01E
NYd0103Pgn<00`000000h=oS0>3Oh`020>3Oh`@0000000<0h=oS0000003P
gn<00P3Pgn<00`000000h=oS000000020>3Oh`@0000000<0h=oS0000003P
gn<00P3Pgn<00`000000h=oS0>3Oh`02000001P0h=oS00<0W9bN0?ooo`3P
gn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS
00<0W9bN0?ooo`3Pgn<0503Pgn<03@0TEh@0gn7O0>[ZiP3/k>T0CKm:04;3
?`0h^CD08J4Q02JF8`3inOP0n_[i0??emP0TEh@0103Pgn<00`000000h=oS
0>3Oh`02000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`000000
0P3Pgn<2000000030>3Oh`00000000000080h=oS00L000000>3Oh`3Pgn<0
h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`00
0000h=oS0>3Oh`0:0>3Oh`0=02AGQ03Jg=X0iNGR0>SXi@3/k>T0kno/0?7a
k`3clo40mOGd0?OgmP3inOP0l_Ce02AGQ0040>3Oh`8000000P3Pgn<01`00
0000h=oS0>3Oh`3Pgn<000000>3Oh`0000000P3Pgn<2000000040>3Oh`00
0000h=oS000000<0h=oS00@000000>3Oh`00000000000P3Pgn<00`000000
h=oS000000030>3Oh`030000003Pgn<0h=oS01@0h=oS00<0W9bN0?ooo`3P
gn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS
00<0W9bN0?ooo`3Pgn<0503Pgn<03@1ENYd0Zk[50>OWh`3Zj^H0ZMbV05GE
D@13`cl0:JPV09[<V03gmoH0nOWh0;[9eP1ENYd01@3Pgn<2000000040>3O
h`000000h=oS0>3Oh`<000000`3Pgn<2000000060>3Oh`000000h=oS0000
003Pgn<000000P3Pgn<3000000<0h=oS0`0000030>3Oh`<000003@3Pgn<0
3@1ENYd0YkO10>;RgP3UiN80j>SU0>c/j@3_kn`0lO7_0??cl@3emO@0moOf
0;W8e@1ENYd0103Pgn<00`000000h=oS000000020>3Oh`<000000`3Pgn<2
000000040>3Oh`000000h=oS00000080h=oS0`0000020>3Oh`040000003P
gn<00000000000<0h=oS0`00000G0>3Oh`0309bLWP3oool0h=oS0100h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3o
ool0h=oS01@0h=oS00d0UjZn06J7X`3UiN40inOS0>;XgP2Yg:H0CKm:0:3B
WP3Xk^H0mOGc0?OgmP1^T:d0UjZn00P0h=oS00<000000>3Oh`3Pgn<0;03P
gn<03@2GZ[h0I8JQ0>3Pf`3Rh]h0iNGR0>SXi@3/k>T0kno/0?7ak`3clo40
mOGd06j?[02GZ[h04P3Pgn<00`000000h=oS0>3Oh`0X0>3Oh`0309bLWP3o
ool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A
0>3Oh`0309bLWP3oool0h=oS01@0h=oS00d0c=3I021DPP2Y^L<0iNGQ0>OW
h`3Zj^H0k>cY0>o_k03alNl0lo?a0;K5dP0PE880c=3I00P0h=oS00<00000
0>3Oh`3Pgn<0;03Pgn<03@3<d=T085B20:Je_`3Ph=/0h^;N0>GUhP3Xj>D0
k>cY0>o_k03alNl0]LC@021DPP3<d=T04P3Pgn<00`000000h=oS0000000X
0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS01D0h=oS00/0YKG505Ml
W02Y^L<0iNGQ0>OWh`3Zj^H0k>cY0>o_k02c`ll0G86R0:Fea@0i0>3Oh`0;
0:Fea@1ENYX0Y[Fo0>3Pf`3Rh]h0iNGR0>SXi@3/k>T0//7=05^1X@2U]LD0
?P3Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0
IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`0E0>3Oh`0;0=kNhP2U
]LD085B206J7X`2[^/D0gn7O0:jnb01YRjL085B20:Fea@3Ng^80>@3Pgn<0
2`3Ng^80YKG5021DPP1TQZ40YkO10=[LfP2[^/H0J8VV021DPP2U]LD0g]kR
03h0h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<05`3Pgn<01`3<d=T0
UjZn05EjW@0TEh@0EGZM09NZ_P3<d=T0?@3Pgn<01`3<d=T0UjZn05EjW@0T
Eh@0EGZM09NZ_P3<d=T0@03Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3O
h`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn0000
0`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80h=oS00<0W9bN
0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn
0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3Oh`0@0>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0
oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80h=oS
00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3k
o?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3O
h`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<0
0`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh1
0?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS
0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0
oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0
4@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3o
ool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1V
IWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<0
0`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS
0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`03
09bLWP3oool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40
nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0
XP3Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0
IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3o
ool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A
0>3Oh`0309bLWP3oool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<1
06IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?oo
o`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IV
OP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`050>3Oh`@0
00000P3Pgn<020000000h=oS0>3Oh`3Pgn<000000>3Oh`000000h=oS0P00
00020>3Oh`<00000R03Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`04
0>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`0000000`3Pgn<0
1@000000h=oS0000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS
000000270>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn
00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS00@0h=oS00<0
00000>3Oh`3Pgn<00P3Pgn<00`000000h=oS000000030>3Oh`050000003P
gn<000000>3Oh`0000001@3Pgn<00`000000h=oS0>3Oh`260>3Oh`0309bL
WP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IV
OP0A0>3Oh`0309bLWP3oool0oooo00<0oooo00<0h=oS0000003Pgn<00`3P
gn<00`000000h=oS000000030>3Oh`050000003Pgn<000000>3Oh`000000
0`3Pgn<2000000@0h=oSQ@3oool00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<609bLWP030>3Oh`00
0000h=oS00<0h=oS00@000000>3Oh`00000000000P3Pgn<01@000000h=oS
0000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3O
hhH0W9bN00<0oooo0>3Oh`3Pgn<03`3Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn01P0h=oS00<000000>3Oh`3Pgn<00P3Pgn<010000000
h=oS0000003Pgn<200000080h=oS100000020>3Oh`<00000V`3Pgn<106IV
OP40nocm0@1VIWh0000306IVOP3ko?d0IVIn01P0h=oS00<000000>3Oh`3P
gn<00P3Pgn<00`000000h=oS0>3Oh`070>3Oh`030000003Pgn<0h=oS09l0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0H0>3Oh`030000
003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`000000h=oS
0000002Q0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3P
gn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh1
0?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IV
OP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IV
OP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IV
OP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<1
06IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_l
o@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP00
00<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3k
o?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP39
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IV
OP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0
IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0FP3Pgn=P0:F//Pl0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1J0>3Oh`030:F/
/P3oool0oooo05`0oooo00<0YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn05X0h=oS00<0YJbb0?ooo`3oool0G03o
ool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh0FP3Pgn<00`2U[;80oooo0?ooo`1G0?ooo`030000003oool0
oooo0080oooo00<0YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40nocm0@1VIWh0
000306IVOP3ko?d0IVIn04H0h=oS1000000@0>3Oh`030:F//P3oool0oooo
05L0oooo00<000000?ooo`3oool00P3oool00`2U[;80h=oS0>3Oh`0=0>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0BP3Pgn<00`000000
h=oS0>3Oh`0=0>3Oh`030:F//P3oool0oooo05L0oooo00<000000?ooo`3o
ool00P3oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP00
00<0IVIn0?_lo@1VIWh03`3Pgn<5000000030>3Oh`000000h=oS0080h=oS
00@000000>3Oh`00000000000P3Pgn<300000080h=oS00<000000>3Oh`3P
gn<01@3Pgn<2000000040>3Oh`000000h=oS000000<0h=oS00<000000>3O
h`3Pgn<00`3Pgn<2000000040>3Oh`000000h=oS000000<0h=oS00<00000
0>3Oh`3Pgn<00P000000103Pgn<000000>3Oh`0000020>3Oh`<000000P3P
gn<00`000000h=oS0>3Oh`030>3Oh`030:F//P3oool0oooo05L0oooo00<0
00000?ooo`3oool00P3oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh03`3Pgn<00`000000h=oS0>3Oh`03
0>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS000000020>3Oh`070000
003Pgn<0h=oS0>3Oh`000000h=oS000000060>3Oh`030000003Pgn<0h=oS
0080000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS0>3Oh`020>3O
h`030000003Pgn<0h=oS0080000000<0h=oS0000003Pgn<00P3Pgn<00`00
0000h=oS000000020>3Oh`80000000@0h=oS0000003Pgn<000000`3Pgn<0
0`000000h=oS0>3Oh`050>3Oh`030:F//P3oool0oooo05L0oooo00<00000
0?ooo`3oool00P3oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d1
06IVOP0000<0IVIn0?_lo@1VIWh03`3Pgn<00`000000h=oS0>3Oh`030>3O
h`070000003Pgn<0h=oS0>3Oh`000000h=oS000000020>3Oh`030000003P
gn<0h=oS00<0h=oS00<000000>3Oh`3Pgn<0103Pgn<01`000000h=oS0>3O
h`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`020>3Oh`07
0000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0
000000<0h=oS00D000000>3Oh`000000h=oS0000000;0>3Oh`030:F//P3o
ool0oooo05L0oooo00<000000?ooo`3oool00P3oool00`2U[;80h=oS0>3O
h`0=0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh03`3Pgn<0
0`000000h=oS0>3Oh`030>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS
000000020>3Oh`D0000000<0h=oS0000003Pgn<01P3Pgn<4000000030>3O
h`000000h=oS0080h=oS00<000000>3Oh`3Pgn<00`3Pgn<4000000030>3O
h`000000h=oS0080h=oS00<000000>3Oh`0000000`3Pgn<010000000h=oS
0000003Pgn<5000000L0h=oS00<0YJbb0?ooo`3oool0E`3oool00`000000
oooo0?ooo`020?ooo`030:F//P3Pgn<0h=oS00d0h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP0?0>3Oh`D0000000<0h=oS000000000000
0P3Pgn<00`000000h=oS000000020>3Oh`060000003Pgn<0h=oS0>3Oh`00
0000h=oS0P0000050>3Oh`060000003Pgn<0h=oS0>3Oh`000000h=oS0P00
00020>3Oh`030000003Pgn<0h=oS0080h=oS00H000000>3Oh`3Pgn<0h=oS
0000003Pgn<200000080h=oS00<000000>3Oh`0000000P3Pgn<200000004
0>3Oh`000000h=oS000000<0h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`2U
[;80oooo0?ooo`1G0?ooo`030000003oool0oooo0080oooo00<0YJbb0>3O
h`3Pgn<03@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn00l0
h=oS00<000000>3Oh`3Pgn<00`3Pgn<01@000000h=oS000000000000h=oS
00<000000P3Pgn<300000080h=oS00<000000>3Oh`0000001@3Pgn<30000
0080h=oS00@000000>3Oh`00000000001P3Pgn<300000080h=oS00@00000
0>3Oh`00000000000`3Pgn<2000000040>3Oh`000000h=oS00000080h=oS
0`0000020>3Oh`030000003Pgn<0h=oS00<0h=oS00<0YJbb0?ooo`3oool0
E`3oool00`000000oooo0?ooo`020?ooo`030:F//P3Pgn<0h=oS00d0h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0?0>3Oh`030000003P
gn<0h=oS00T0h=oS00<000000>3Oh`3Pgn<0;P3Pgn<00`000000h=oS0>3O
h`0;0>3Oh`030:F//P3oool0oooo05L0oooo00<000000?ooo`3oool00P3o
ool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh03`3Pgn<5000000L0h=oS00<000000>3Oh`3Pgn<0;P3Pgn<0
0`000000h=oS0>3Oh`0;0>3Oh`030:F//P3oool0oooo05L0oooo00<00000
0?ooo`3oool00P3oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d1
06IVOP0000<0IVIn0?_lo@1VIWh0FP3Pgn<00`2U[;80oooo0?ooo`1G0?oo
o`030000003oool0oooo0080oooo00<0YJbb0>3Oh`3Pgn<03@3Pgn<106IV
OP40nocm0@1VIWh0000306IVOP3ko?d0IVIn05X0h=oS00<0YJbb0?ooo`3o
ool0E`3oool00`000000oooo0?ooo`020?ooo`030:F//P3Pgn<0h=oS00d0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1J0>3Oh`030:F/
/P3oool0oooo05L0oooo00<000000?ooo`3oool00P3oool00`2U[;80h=oS
0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0FP3P
gn<00`2U[;80oooo0?ooo`1G0?ooo`030000003oool0oooo0080oooo00<0
YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn05X0h=oS00<0YJbb0?ooo`3oool0G03oool00`2U[;80h=oS0>3Oh`0=
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0FP3Pgn=P0:F/
/Pl0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn0000
0`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1V
IWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?Ogn@2H
V:L0b@1gMi8109RHY`40moOi0@1VIWh0000306IVOP3gmoT0_;g=0<X0_;g=
0@3gmoT106IVOP0000<0IVIn0?Ogn@3Thn<0bP3Thn<10?Ogn@40IVIn0000
0`1VIWh0l?7d0?ooo`240?ooo`030>CSh`2LY;T0JgF?00<0JgF?00@0K7J@
06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0knk^0<K9d`@0
ZJfi00@0ZZfi0:V]^@2Z[KT0ZZfi2@2Y[KT01P36bM<0knk^0?ooo`3oool0
k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0YcY42@2V>D@00`2LY;T0k>[Z
0?ooo`020?ooo`40l?7d0@1VIWh0000F06IVOP3RhN80nocl0?_ko03ko?d0
o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m0?clo03lno`0o?cl0?_lo03l
o?`0nocm0?cko03lo?d0no_m0?_lo080o?cl00@0o?cm0?clo03knod0o?cm
9P3lno`01P3imoT0jNO]0=OCgP37`]40g=WR0>WWk@@0o?_l<03ko?`;0?_l
o@0309bT^@1[MHl0QHV`0100QHV`00H0JgF?09bT^@3ko?d0nocm0<K9d`2Y
[KTA0;fndP060:V]^@36bM<0no_l0?clo02LY;T0YSU44@2Z?5D01P2V>D@0
W:Bi0?clo03lnod0nocm0>;QhP40IVIn0000101VIWh0h>3Q0?Kgn@3gmoT2
0?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Og
n@3fmoT00P3gmoT0103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0
moOi02@0moOi00P0j^[/09RGW@1:Bdh03Q0@06e^K`2OWj<0al;A0=kKi0<0
moOi<03fmoT;0?Ogn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3g
moT0moOi0:V]^@3;c=XA0<?5e0080<_<fP2Y[KT0moOh0?Kgn@2V>D@0ZSaE
0<9BF`36E5X=0<IEG0080<IDFP32DU/0ZSaE0:HiA03gmoT0moOh0?Ogn@3P
h>4106IVOP0000D0IVIn0=kMh@3alO@0lO7d0?3am00@000000070?7bm03a
lO@0l?;e0?7am03al_@0l?;d0?7am00U0?3am@0808Z<SP1ADU@0c/kD0?3a
m@2n_l803Q0@06QVKP3Cd=/c0?3am@/0l?7d00<0JgF?0;:ed02WZ<80402W
Z<801P2b]M00JgF?0?3am03`lO@0ZJfi0<c>fa40b/_H00D0c<kK0:V]^@3a
l_@0lO7e0:HiA0020<9BF`030<]DF@3=FEh0cEUN00/0cEUN00P0beAI0<9B
F`32DU/0YSU40?3am03alO@0l?;d0=kMh@40IVIn00001P1VIWh0g=_P0>[[
l03Zjo00j^c`00000080inOW0P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0
inOW0P3_knl01@000000j^c_0>[[l03Zjo00j^__0080j^_`00L0j^__0=gL
i@3Ac]X0al;A0=7>fP3Lf^<0i>C[0080j^_`00D0h>3X0=7>fP37`]40eM;M
0>OWk@020>[[l0030>?SjP37`]40al;A00H0j^_`00L0gMcU0<O2d@3Og^H0
gMcU0<O2d@3Ti>/0j^_`0080al;A0P3Zjo020<O2d@0B0=OHg02f]K`0al;A
0<O2d@2g//003Q0@04Y;CP3ShnX0j^_`0>CTj`3Ac]X0h^;Y0>[/l03PhNP0
dLkJ0<O2d@3Edmd0inS]0P3Zk?020=SFh0<0j^c`0P3He^030>[/l080f=KP
6`3Zk?0;0>[[k`0406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk60:b^aP2]
[/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`040:V]^@3@d=`0c/kJ0<k>
fP`0oooo0`3>c]X02@3@d=`0ZJfi0>[[l03Zjo00YSU40<eIGP3;E5T0cEIK
0<iIG`0;0=1JG`060<iIG`3=EU/0beAI0<eIGP2V>D@0j^_`0P3Zjnl10=cK
h040IVIn00002P1VIWh0fMWO0>?UjP3Si>X0hnG[0000002<S8`0g]kN0>OW
i`3Ng]h20>OWi`030<IS003WinL0inOW0080inOW00P0knoW0>o_k`3_knl0
00000>?UjP3Si>X0hnC[0>?UjP80hnCZ0100ShnF04Q9C00>4100CU1B08b>
TP2[Yk@0al;A0>?Uj`2VYZd0ATI:00h@401RHfL0_[_60=[Jh`3SiN/0_;k2
0P0>41060>?Uj`0709>CV@0>4100XJ>W09FFV`0>4100ZjNd0>3Rj00200h@
40060<O2d@3SiN/03Q0@00h@4037`]40Si6D100>41004@1UIfT0_;k20>?U
j`33aLX0B4U<09jKYP3Si>X0YZJ/04I6BP0>4100HV=V0;jkaP3JfN80hnCZ
07EgNP1^KW<0e=;M0080hnCZ00<0MGMj06i^L`3Dd]d00P3Si>X00`1eMgX0
KVic0=CBg@0K0>?TjP/0hnGZ00D0JgF?0;bne02b//X0/[;:0?ooo`0606i]
S`0302DU=P2b//X0/[;:00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ0:V]^@3B
dml20=7Ag0030?ooo`2DU9`0U9BL00T0U9BL0`3AdM`01@3Bdml0ZJfi0>?T
j`3SiNX0YSU40080cEUN00@0d5]P0=ALG`3oool0oooo1`3DG5l20?ooo`09
0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnGZ0>?TjP3SiN/0fMWO0040IVIn0000
0`1VIWh0emSN0=cNiP020=cNiP050000003WinL0inOW0>OWi`3We/h00P3W
inL01@3>N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_00<000000=cMiP3Lg^H0
0P3Lg^D01P3Lg^H0Kg1d04I6BP2a/KT0g=kU0<C6c0803Q0@00L0al;A0:JX
[P0>4100UiBO0:j`]P1<CU00WZ2U0080g=kU00<0C4i@00h@4037`]401@3L
g^D0102EUi/03Q0@0;Nb`02^/;H200h@40060;Nb`03Lg^D03Q0@00h@4037
`]40g=kU0P0>41001037`]40LWAg00h@402a[KX20<O2d@0<0=;Ag03Jfn<0
g=kU04a>D00>4100al;A0:JX[P0>4100UiBO0:j`]P1<CU00WZ2U0P3Lg^D2
079dM`<0g=kU0P1bM7L30=cNi@80LWAg9`3Lg^D01@1[MHl0_l7F0;RicP2h
^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cN
i@3Lg^D0ZJfi0=CFh080e=GN00<0oooo09BDW03DeMh01`3DeMh00`3oool0
U9BL0=CEgP020=CEgP090=CFh02Y[KT0g=kU0=cNiP2V>D@0cEUN0=5JGP3D
GF40DbDP00<0oooo1@3FGf<30?ooo`0905<U803DGF40dEYN0<eIGP2V>D@0
g=kU0=cNiP3Lg^D0emSN0040IVIn00001`1VIWh0eMKM0=GHh03Ff>40eMSP
0000002<S8`00P3WinL01@3W]H@0eUX00=J4003ocP00cV<00080gV/000H0
kkF<0>o_k`3_knl0kno_0000003Ef>020=GHh@050=GGh02RY:X03Q0@09ND
W`3EeMl00P3Fen0200h@40030<O2d@1:C4l03Q0@00D0al;A00@0e]OP00h@
400>4100al;A1@3Fen0200h@40060<O2d@3Cdmd03Q0@00h@4037`]40e]OP
0P0>41001P37`]40e]OP00h@400>4100al;A0<C6cP<03Q0@00@0Ngb10;Nb
`03>c=P0e]OP0P0>41000`37`]40BTa?00h@40050<O2dBT0e]SP2`3Ef>40
1@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?0=GH
h@3Ef>40ZJfi0=OHhP80e]OQ00<0oooo09BDW03Fen401`3Fen400`3oool0
U9BL0=KGh@020=KGh@050=OHhP2Y[KT0eMOQ0=GGh02V>D@00P3EGF000`3H
H640fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@020=EM
H0050:HiA03Ef>40eMOP0=GHh@3Ee]d00@1VIWh0000606IVOP3Be=d0cm;L
0=3Bg03@d]d000000`3WinL0303Wg/h0aTX00?O>003_[@00kkD00<i[0036
FP00aV/00=j<BP3WY@00knO>000000@0d=;L00<0GEmS00h@402l^<H00`3@
d]`200h@40030<O2d@0>41003Q0@00@03Q0@00D0bLKD0=3Bg00>41003Q0@
0<O2d@050=3Bg00407UkP00>4100ZJVc0<W6e0803Q0@00H0al;A0=3Bg00>
41003Q0@0<O2d@3@d]`200h@40090<O2d@1MGf<03Q0@0;6]^P2i^l@03Q0@
06QVKP37`]40d=;L00803Q0@00<0al;A00h@400>4100100>41000`39a]@0
cm;M0<oBg@0W0<oBg@/0d=;L00<0JgF?0<S9f`33a=H04033a=H01P38bM/0
JgF?0=3Bg03@d]`0ZJfi0=[Ki080f]_S00<0oooo09BDW03Jfn<01`3Jfn<0
0`3oool0U9BL0=[Kh`020=[Kh`070=[Ki02Y[KT0cm;L0=3Bg02V>D@0eemO
0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3oool01`167QX0
g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@00P3@d]`10<oBg040d]CM0@1VIWh0
000I06IVOP3@d]/0blgH0<[=f@3;c]P000000>O6[@3WaX`0mlhH0>nm003g
aP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl000000<[>
f@3;cMP0blgI0<[=f@0200h@40030<O2d@3;cMT0blgI00<03Q0@00T0blgI
04M9C@0>4100al;A0<[:e`0>4100ATI:0<W9eP3;cMT00P0>41000`37`]40
blgI0<_=f@040<_=f@0308Z<T`17BDd03Q0@00803Q0@00H0b<OD0<_=f@0>
41003Q0@0<O2d@3:c=P200h@40050<W8e@0>41003Q0@0<O2d@3:bmP00P0>
41003039b=D0blgI00h@400>4100al;A04M9C@0>4100al;A0<[;e`0>4100
ATI:0<W9eRT0blkI2`3;cMP00`1[MHl0blcN0<S:f@080<S:f@030<S9f@38
b]T0b<[I00<0b<[I00@0b<WI0<S:f@3;c=h0JgF?0P3;cMP01P2Y[KT0gMkW
0=cNi@3Lg^D0oooo09BDW0P0g=kU00<0oooo09BDW03Lg^D00P3Lg^D02@3M
g^L0ZJfi0<[=f03:cMT0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN
6P3oool0oooo00<0oooo00T0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO
0:HiA03:c]T00P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0020<G8
e00600000036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD
00020?O60080moOg00<000000<G7e035b=@00P35am@200h@40030<O2d@35
a]@0a<OE00@0a<OE00H0QHRA00h@402MWJP0ZjNd00h@4026QY020<C7e@80
3Q0@0P37`]460<C7e@060<K4dP2g//003Q0@06MWK`35a]@0a<OE0P0>4100
3@2f]L80/:jk00h@401cLg/0aLKD079dO00>4100/:nl0;6]^P0>4100Lg=k
0<K5d`34amD00P0>41001`37`]40QHR@00h@402MWJL0ZjNd00h@4026QXl0
:P34b=@;0<C7e00306]eS`3@dN00bl_L0100bl_L00H0d=7P06]eS`34am@0
a<OD0:V]^@3Ph>T20=kNi`030?ooo`2DU9`0g]kW00L0g]kW00<0oooo09BD
W03Ng^L00P3Ng^L01`3Ph>T0ZJfi0<C7e035b=D0YSU40=]TI03OIF@01@3P
JVP01@167QX0oooo0?ooo`3oool0AQhJ00D0h6YX00<0gfET0=]TI02V>D@0
0P34b=@10<G7e@40cloJ0@1VIWh0000606IVOP3<c]X0`/CB0<74d@31a=80
00000`3WinL03@3FQ000kkD00>NU003WY@00eX@00<i[003W[@00mkD00?Nm
003_knl0moOg00000032a=800`31a=80101GFEl03Q0@0;bhaP34`m460<74
d@0408>6SP0>41003Q0@08>6SP80`LCA100>41060<74d@0505MIG`0>4100
3Q0@071cNP2a]<000P31a=401P0>4100NWf504A6BP0>4100L7=j0;6d`080
`LCA00D0L7=j00h@4014ATX0IFM^09:EW`020<74d@803Q0@00<0al;A0<74
dP23QXl00P0>41000`23QXl0`LCB0<74dP0Y0<74dP/0`/CB00<0JgF?0=?C
hP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80ZJfi0>;RjP80hN7W00<0
oooo09BDW03QhNL01`3QhNL00`3oool0U9BL0>7Qi`020>7Qi`070>;RjP2Y
[KT0`LCA0<74dP2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T01`3QJFD0
ffAT0:HiA032a=40`LCA0<74dP3<c]X00@1VIWh0000:06IVOP3:c=P0_/3?
0;g0c`2n`<h0000009bLW03WinL0imkF0=J<0080gY@000@0eW/00<IS002m
@P00kjD00P3g[@00303g]@00oli:0000002n`<l0_/3>0;k0c`2n`<h0RH^E
00h@402TX:`0a/7@0<?1c`80_/3>0P35`M080;k0cP803Q0@00<0a/7@0;k0
cP2n`<h06P2n`<h200h@40030<O2d@2m`<h0_L3>02h0_L3>2`2n`<h00`1[
MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0cP2Y[KT0i>C[0P3S
hnP00`3oool0U9BL0?ooo`080?ooo`0609BDW03ShnP0hn?X0>?Sj03Ti>/0
ZJfi0P2n`<h00`2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3o
ool0oooo103SK6`00`3QJVX0h6IU0:HiA0020;k0c`40_/3>0@3:c=P106IV
OP0000H0IVIn0<W:f02f^<P0^Kc;0;Zlb`0000020>o_k`0=0=JL003FS000
gY@00=J4003_Y@00gX`00;eJ003FL`00ki`00?O_i`3gmoL0oooo00000002
0;Vlc00;0;Zkc02i_</0/;;00494B@13A4T0XYn/0<K1d037`]40ShbG079a
N@31_ll0202i_<`00`25R9<0E5IM0;Vlc00L0;Vlc0803Q0@00<0a/7@0;Zl
c02j_<`0;P2j_<`;0;Zlb`0306]eS`3Hf>D0dm?Q0100dm?Q00H0f=SU06]e
S`2j_</0^[c;0:V]^@3Vi^d20>;Rj@030?ooo`2h]lP0^;O800P0^;O800H0
U9BL0>;Rj@3Rh^T0h^;Y0>KVk@2Y[KT20;Zlc0060:HiA03PJFP0hFe/0>Aa
K@3TLFl0i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^00P0i75]
0>5]K03PJFP0YSU40;Zkc02i_</0][S80<W:f040IVIn0000201VIWh0alWG
0;Bfa`2f^<P0][S900000024Q8@0inON0P3_knl01`36J`00mlH00>ne003_
W000gX`00<i[003WW0000`3gmoL02@000000][S90;Jib@2g^<T0][W90;Ni
b@2/[[h0O7j90453B00200h@400307AeP02MWjd0]kS902L0]kS900<0Jfaf
0453B02g^<T0<02f^<T;0;Nhb@0406]eS`3Fe^@0f=SU0=SHiP<0f=SU1@3H
f>H30=SHi@80f=SV0P3Hf>D01P3Fe^@0JgF?0;Nhb@2g^<T0ZJfi0>KVk@80
iNG/00<0oooo0;Rgb02h]lP0202h]lP03@2DU9`0iNG/0>GUk03UiN`0i^K]
0:V]^@2g^LT0][W90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0
i7A_0>AdK`3TM6l0AQhJ00<0oooo00T0i7A_0>MaK`3TM6l0i6i]0:HiA02f
^<T0][W90;Bfa`37bML00@1VIWh0000306IVOP36b=L0];K70080];K700<0
00000>o_k`3_knl00P3_knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3N
U3T0kmJe0?ogm`3oool000000780];K700D0JgF?0=GEh`3LfnL0g=_W0=gK
i`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`2Y[KT0iNG/0`3Wind;09BDW0<0
inO]00T0iNG/0:V]^@2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3o
ool00`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0
igEb0>McK`2V>D@30;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?80080
/K?800H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0
moOg0?Ogm`3_imH0moOg0?ooo`00001b0;6cb00306]eS`3Ee><0h=oZ0100
h=oZ00H0eMCS06]eS`2a/lP0/K?80:V]^@3UiN`A0>WYk`090>GUk02Y[KT0
/K?80;6cb02V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]
UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:Hi
A0030;6cb040a/SG0@1VIWh0000306IVOP36b=L0^;O?0080[jk700H00000
0>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg
00<0oooo0000002_[/L0L@2_[/L00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[
l`1[MHl0[jk70:n^a`2Y[KT0m??g4@3`ko@06@3dloL0ZJfi0:n^a`2_[/L0
YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/
]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@00P2_[/L1
0;Rgc`40a/SG0@1VIWh0000306IVOP30`M40alOD0080[:_400D000000:f]
[@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3oool00`000000[:_40:b[a01`
0:b[a00306]eS`3BdN<0l_7g0100l_7g00H0d]7S06]eS`2/Zl@0[:_40:V]
^@3QhNTA0??bmP060>7Qj@2Y[KT0[:_40:b[a02V>D@0m8Ym0P3eT8D=0?:h
WP80mI2500H0m8Ym0:HiA02/Zl@0[:_40<O7e030`M4106IVOP0000@0IVIn
0<31d@3Bd]l0]KC9P`2TXkh01024S:80JgF?0<c;g@3kno`=0?ooo`040?_k
o03<bmd0JgF?08B<XP80Y:>n00@0]k_40:V]^@3QhNT0oOgm3@3oool0103m
oOd0hN7Y0:V]^@2g^l@20:BS_P07096HZP2V>D@0oin=0?joY03jg;L0n^^g
0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf0?[Y]P80nNVf00X0n^^g0?[L]`3n
_j@0oin=0:HiA02AV:X0Y:>n0;Fdb@3Bd]l0`<7A0@1VIWh0000606IVOP2X
Ykl0i^K]0=;Bh02l_<l0/K34PP2XYkl00`24S:80JgF?06]eS`0?06]eS`03
08B<XP2XYkl0Z:No0080Z:No00<0]k_40:V]^@2Y[KT03`2Y[KT00`2g^l@0
Z:No0:RW_`020:RW_`0308B<XP2V>D@0YSU400l0YSU400H0Q8bR0;6`a02l
_<l0d];P0>KVk@2XYkl106IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@
d>00b/[J0<40_;c?00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ000
00P0F5MX06IVOP2EU:/0emSR0?clo03blO<0k>_^0>7Rjkl0emSR00L0hN;[
0>c[kP3blO<0o?cl0=OHhP2EU:/0IVIn0040F5MX000205QGJ00306IVOP2E
U:/0dM7N0080o?cl`@3oool20?clo0030=7AgP2EU:/0IVIn0080F5MX0003
05QGJ080IVIn00<0R8NM09FDZ`2XYkl0`02XYkl0102EU:/0R8NM06IVOP1V
IWh305QGJ0001@1HEfS506IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  Evaluatable->False,
  ImageSize->{207, 176},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Referencing"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Referencing"]
}, Open  ]],

Cell["\<\
We can retrieve a list of all widgets in the interface that have been \
registered with unique string names and reference these widget instances by \
this reference name.\
\>", "Text",
  CellTags->"Referencing"],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<WidgetNames\>"\  /. \ GUIInformation[ref]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Referencing"],

Cell[BoxData[
    \({"actionMap", "cancelAction", "cancelButton", "degreesButton", "frame", 
      "inputField", "inputMap", "okButton", "radiansButton", 
      "rootPane"}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Referencing"]
}, Open  ]],

Cell[TextData[{
  "Here we can discover all property names available with the widget \
registered with the name \"inputField\". We can query and set these values \
using ",
  StyleBox["PropertyValue[{\"inputField\", \"propertyName\"}]", "Output"],
  " and ",
  StyleBox["SetPropertyValue[{\"inputField\", \"propertyName\"}, newValue]", 
    "Output"],
  "."
}], "Text",
  CellTags->"Referencing"],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<PropertyNames\>"\  /. \ 
      GUIInformation[ref, "\<inputField\>"]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"Referencing"],

Cell[BoxData[
    \({"AccessibleContext", "Action", "ActionCommand", "ActionListeners", 
      "ActionMap", "Actions", "AlignmentX", "AlignmentY", 
      "AncestorListeners", "Autoscrolls", "Background", "BackgroundSet", 
      "Border", "Bounds", "Caret", "CaretColor", "CaretListeners", 
      "CaretPosition", "Class", "ColorModel", "Columns", "Component", 
      "ComponentCount", "ComponentListeners", "ComponentOrientation", 
      "Components", "ContainerListeners", "Cursor", "CursorSet", 
      "DebugGraphicsOptions", "DisabledTextColor", "Displayable", "Document", 
      "DoubleBuffered", "DragEnabled", "DropTarget", "Editable", "Enabled", 
      "Focusable", "FocusAccelerator", "FocusCycleRoot", 
      "FocusCycleRootAncestor", "FocusListeners", "FocusOwner", 
      "FocusTraversable", "FocusTraversalKeys", "FocusTraversalKeysEnabled", 
      "FocusTraversalPolicy", "FocusTraversalPolicySet", "Font", "FontSet", 
      "Foreground", "ForegroundSet", "Graphics", "GraphicsConfiguration", 
      "Height", "HierarchyBoundsListeners", "HierarchyListeners", 
      "Highlighter", "HorizontalAlignment", "HorizontalVisibility", 
      "IgnoreRepaint", "InputContext", "InputMap", "InputMethodListeners", 
      "InputMethodRequests", "InputVerifier", "Insets", "KeyListeners", 
      "Keymap", "Layout", "Lightweight", "Locale", "Location", 
      "LocationOnScreen", "ManagingFocus", "Margin", "MaximumSize", 
      "MaximumSizeSet", "MinimumSize", "MinimumSizeSet", "MouseListeners", 
      "MouseMotionListeners", "MouseWheelListeners", "Name", 
      "NavigationFilter", "NextFocusableComponent", "NotifyAction", "Opaque", 
      "OptimizedDrawingEnabled", "PaintingTile", "Parent", "Peer", 
      "PreferredScrollableViewportSize", "PreferredSize", "PreferredSizeSet", 
      "PropertyChangeListeners", "RegisteredKeyStrokes", 
      "RequestFocusEnabled", "RootPane", "ScrollableTracksViewportHeight", 
      "ScrollableTracksViewportWidth", "ScrollOffset", "SelectedText", 
      "SelectedTextColor", "SelectionColor", "SelectionEnd", 
      "SelectionStart", "Showing", "Size", "Text", "Toolkit", "ToolTipText", 
      "TopLevelAncestor", "TransferHandler", "TreeLock", "UI", "UIClassID", 
      "Valid", "ValidateRoot", "VerifyInputWhenFocusTarget", 
      "VetoableChangeListeners", "Visible", "VisibleRect", "Width", "X", 
      "Y"}\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"Referencing"]
}, Open  ]],

Cell[TextData[{
  "We can also find out what method names exist that can be executed on this \
widget with ",
  StyleBox["InvokeMethod[{\"inputField\", \"methodName\"}, arguments]", 
    "Output"],
  " and even filter these names using string patterns."
}], "Text",
  CellTags->"Referencing"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Select["\<MethodNames\>"\  /. \ 
        GUIInformation[
          ref, "\<inputField\>"], \[IndentingNewLine]StringMatchQ[#, \
"\<*text*\>", \ IgnoreCase \[Rule] True] &]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"Referencing"],

Cell[BoxData[
    \({"GetAccessibleContext", "GetDisabledTextColor", "GetInputContext", 
      "GetSelectedText", "GetSelectedTextColor", "GetText", "GetToolTipText", 
      "SetDisabledTextColor", "SetSelectedTextColor", "SetText", 
      "SetToolTipText"}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"Referencing"]
}, Open  ]],

Cell[TextData[{
  "Additionally, we can discover what event names can be used to cause ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " code to execute whenever the event occurs by using ",
  StyleBox["BindEvent[{\"inputField\", \"eventName\"}, Script[code]]", 
    "Output"],
  "."
}], "Text",
  CellTags->"Referencing"],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<EventNames\>"\  /. \ 
      GUIInformation[ref, "\<inputField\>"]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"Referencing"],

Cell[BoxData[
    \({"Action", "ActionPerformed", "Ancestor", "AncestorAdded", 
      "AncestorMoved", "AncestorRemoved", "AncestorResized", "Caret", 
      "CaretPositionChanged", "CaretUpdate", "Component", "ComponentAdded", 
      "ComponentHidden", "ComponentMoved", "ComponentRemoved", 
      "ComponentResized", "ComponentShown", "Container", "Focus", 
      "FocusGained", "FocusLost", "Hierarchy", "HierarchyBounds", 
      "HierarchyChanged", "InputMethod", "InputMethodTextChanged", "Key", 
      "KeyPressed", "KeyReleased", "KeyTyped", "Mouse", "MouseClicked", 
      "MouseDragged", "MouseEntered", "MouseExited", "MouseMotion", 
      "MouseMoved", "MousePressed", "MouseReleased", "MouseWheel", 
      "MouseWheelMoved", "PropertyChange", "VetoableChange"}\)], "Output",
  CellLabel->"Out[7]=",
  CellTags->"Referencing"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Properties", "Subsection",
  CellTags->"Properties"],

Cell["\<\
One of the main concepts of working with user interfaces is the manipulation \
of widgets through their properties. There are a number of property-based \
functions that aid in discovering what properties exist on widgets in an \
interface and also querying and modifying their current values.\
\>", "Text",
  CellTags->"Properties"],

Cell[BoxData[
    \(\(Needs["\<GUIKit`\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Properties"],

Cell[TextData[{
  "Here we gain access to the ",
  StyleBox["GUIObject", "Output"],
  " associated with a user interface created in a modeless session."
}], "Text",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ GUIRun["\<Wolfram/Example/AngleDialog\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Properties"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject440989927866369, 
        JLink`Objects`JavaObject210201571491841]]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Properties"]
}, Open  ]],

Cell[TextData[{
  "We can easily take a dynamic snapshot of the interface as we use it by \
calling the utility ",
  StyleBox["GUIScreenShot", "Output"],
  " function."
}], "Text",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // \ Show\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Properties"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003?0000/2000`400?l0
0000o`00003oc`1VIWh0000306IVOP3ko?d0nocm0</0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0<T0IVIn0@2XZK/10?_lo@40IVIn00000`1VIWh0nocm
06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3P
gn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh1
0?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IV
OP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IV
OP3ko?d0IVIn04h0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;bm00C0??cm100
n?Oh0P3clo@01@3cloD0m?Ce0?GemP3dloD0iNCX00H0h=oS00D0hN3T0>KU
j03/jnh0l?3b0?;bm00L0??cm1T0n?Oh0P3clo@01@3cloD0m?Ce0?GemP3d
loD0iNCX00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>
0>3Oh`040=kLg`3Th^00NiN]02EGQBL003ad00@05den06^;YP3blNh0l_7c
1P3Pgn<0103Ng=l0i>;P07^G[@0UEhDi000lM00401M=OP1[RjH0l_7^0?;a
l`D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`04
0=[Hf@1VQJ409df504em`BP0JH;^00<09df506Z:Y03_ko401P3Pgn<0103J
f=T0IXFQ04YaT`2b_L<i0<K5e`040<36a@18KY00JXZT0>o_l@D0h=oS0@1V
IWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`030=SEeP0GCGh0
RJgT02X0RJgT00<05den0>_Zk@3Pgn<01@3Pgn<00`3HeMH05den0;o7bP0k
0<K5e`030;Jm_@0GCGh0jn[]00D0h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP1>0>3Oh`040=WEe@00?7@0RJgT0?ooobL0cLcO00@0oooo
08V]i000?7@0j>OZ1P3Pgn<00`3IeMD003ad0?ooo`0k0<g<g`030?ooo`00
?7@0j>OZ00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>
0>3Oh`040=WEe@00?7@0RjgT0?ooobL0d]7T00@0oooo08^_i@00?7@0inKY
1P3Pgn<00`3IeMD003ad0?ooo`0k0=;Ai0030?ooo`00?7@0inKY00D0h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`040=WEe@00
?7@0SZoV0?ooobL0e]OW00@0oooo08f_i@00?7@0inKY1P3Pgn<00`3IeMD0
03ad0?ooo`0k0=KGi`030?ooo`00?7@0inKY00D0h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`040=WEe@00?7@0TK7W0?ooo`h0
fM[W0`0000030=WJi`030000003If^L0fM[W0080fM[W00<000000=WJi`3I
f^L02`3If^L0103oool0TK7V000lM03Wi^T60>3Oh`030=WEe@00?7@0oooo
00l0fM[W0`0000030=WJi`80000000@0fM[W0000003If^L000000`3If^L0
0`000000fM[W0=WJi`03000000<0fM[W0`0000020=WJi`030000003If^L0
fM[W00`0fM[W00<0oooo000lM03Wi^T01@3Pgn<106IVOP40nocm0@1VIWh0
000306IVOP3ko?d0IVIn04h0h=oS00@0fMGE000lM02D]>P0oooo3@3If^L0
1@000000fM[W0=WJi`3If^L000000080fM[W00D000000=WJi`3If^L0fM[W
0000000>0=WJi`040?ooo`2E]>P003ad0>OVj@H0h=oS00<0fMGE000lM03o
ool03P3If^L01`000000fM[W0=WJi`3If^L000000=WJi`0000000P3If^L2
000000030=WJi`000000fM[W0080fM[W00<000000=WJi`0000000`3If^L0
0`000000fM[W000000030=WJi`030000003If^L0000000h0fM[W00<0oooo
000lM03Wi^T01@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn
04h0h=oS00@0fMGE000lM02H^>X0oooo303Ngn`00`000000g]o/0=kOk003
0=kOk0030000003Ngn`0000000<0g]o/00<000000=kOk03Ngn`0303Ngn`0
103oool0V;SY000lM03Wi^T60>3Oh`030=WEe@00?7@0oooo00d0g]o/00<0
00000=kOk03Ngn`0103Ngn`01`000000g]o/0=kOk03Ngn`000000=kOk000
00000`3Ngn`00`000000g]o/000000050=kOk0030000003Ngn`0g]o/00<0
g]o/00<000000=kOk03Ngn`0303Ngn`00`3oool003ad0>OVj@050>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad
09bkjP3oool<0>?Ul0030000003SiO00hnG`00<0hnG`00H000000>?Ul000
000000000>?Ul000000?0>?Ul0040?ooo`2L^n/003ad0>OVj@H0h=oS00<0
fMGE000lM03oool03@3SiO000`000000hnG`0>?Ul0050>?Ul0@0000000<0
hnG`0000003SiO000P3SiO000`000000hnG`000000050>?Ul0D0000000<0
hnG`0000003SiO003@3SiO000`3oool003ad0>OVj@050>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad0:2nk03o
ool<0>W[m@030000003YjoD0jN_e00<0jN_e00@000000>W[m@000000jN_e
0P00000?0>W[m@040?ooo`2Q_^`003ad0>OVj@H0h=oS00<0fMGE000lM03o
ool03@3YjoD00`000000jN_e0>W[m@040>W[m@060000003YjoD0jN_e0>W[
m@000000jN_e0P0000020>W[m@030000003YjoD0000000<0jN_e00<00000
0>W[m@0000000`3YjoD00`000000jN_e0000000>0>W[m@030?ooo`00?7@0
inKY00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3O
h`040=WEe@00?7@0YL7]0?ooo``0l?7l00<000000?3ao03`lO`00`3`lO`0
0`000000l?7l000000020?3ao0030000003`lO`0l?7l00d0l?7l00@0oooo
0:G2kP00?7@0inKY1P3Pgn<00`3IeMD003ad0?ooo`0=0?3ao0030000003`
lO`0l?7l00D0l?7l0`0000020?3ao0040000003`lO`00000000000<0l?7l
0`0000030?3ao0<000000P3`lO`00`000000l?7l0?3ao00<0?3ao0030?oo
o`00?7@0inKY00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IV
OP1>0>3Oh`040=WEe@00?7@0ZLG_0?ooo`d0m?Gm00D000000?Ceo@3dmOd0
m?Gm000000020?Ceo@050000003dmOd0m?Gm0?Ceo@0000003P3dmOd0103o
ool0ZLG_000lM03Wi^T60>3Oh`030=WEe@00?7@0oooo00h0m?Gm00D00000
0?Ceo@3dmOd0m?Gm0000000I0?Ceo@030000003dmOd0m?Gm00`0m?Gm00<0
oooo000lM03Wi^T01@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn04h0h=oS00@0fMGE000lM02]b?00oooo3P3fmod3000000<0m_Om00<0
00000?Kgo@3fmod00P3fmod00`000000m_Om0?Kgo@0;0?Kgo@040?ooo`2/
ao0003ad0>OVj@H0h=oS00<0fMGE000lM03oool03`3fmod3000001X0m_Om
00<000000?Kgo@3fmod0303fmod00`3oool003ad0>OVj@050>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad0;7;
lP3ooolW0?Slo@040?ooo`2ac?8003ad0>OVj@H0h=oS00<0fMGE000lM03o
ool0>`3ho?d00`3oool003ad0>OVj@050>3Oh`40IVIn0@3ko?d106IVOP00
00<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad0;C=l`3ooolW0?gmo@04
0?ooo`2ec_<003ad0>OVj@H0h=oS00<0fMGE000lM03oool0>`3moOd00`3o
ool003ad0>OVj@050>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1V
IWh0CP3Pgn<0103IeMD003ad0;O@m03ooolW0?gmo@040?ooo`2hd?D003ad
0>KVj@H0h=oS00<0fMGE000lM03oool0>`3moOd00`3oool003ad0>KVj@05
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103H
e=@003ad0;[Cm@3ooolW0?gmo@040?ooo`2jdoH003ad0>GUj0H0h=oS00<0
f=CD000lM03oool0>`3moOd00`3oool003ad0>GUj0050>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<00`3IeMD09EN50;cDmP0Z
0;cDmP0302EGQ@3QhN@0h=oS00D0h=oS00<0fMGE02EGQ@2oc]`0>`3oool0
0`2oc]/09EN50>7Qi0050>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh0CP3Pgn<00`3IeMD0NIBY02M=Q@0Y0<kWo`0302M=Q@1iUJ/0gmgP
00H0h=oS00@0fMGE07VDZ@1EOJ80`<oM>@3oool0103EgnP0EGfR07VEZ`3O
gN050>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0
103JemT0gmcH07VDZ@0UEhDW000lM00401M=OP1VQZ40h=kJ0=cKg@H0h=oS
00@0f]OI0=oLf01iU:T09EN5>@00?7@0100GCGh0IXJQ0>3NfP3Lfmd50>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<00`3OgN00
f]OI0=SDe00E0=OCe100dlk<0`3Gdm@0103He=@0fMGE0=[Gf@3OgN060>3O
h`030=oMh03JemT0f=CD01h0em?D6@3Cc/`30=OCe0040=SDe03IeMD0f]OI
0=oMh0D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40
nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn
00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn
0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn0000
0`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1V
IWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP0A0>3OhjL0oooo4@3Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn0140h=oSYP2LW9h00`3oool0h=oS0>3Oh`0?0>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo
0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn
00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80h=oS00<0
W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3Oh`0@
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2L
W9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_l
o@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80
h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IV
OP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo
0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3P
gn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1V
IWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0
h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0
000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2L
W9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1V
IWh04@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bL
WP3oool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3P
gn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`0G0>3Oh`070<c@f@2GZ[h0
EGZM02AGQ01ENYd0UjZn0<c@f@0C0>3Oh`@000009P3Pgn<01`3<d=T0UjZn
05EjW@0TEh@0EGZM09NZ_P3<d=T0@03Pgn<00`2LW9h0oooo0>3Oh`0@0>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0
oooo0>3Oh`0E0>3Oh`0;0=kNhP2U]LD085B206j@[@2jbMH0loGf0;c;f@1`
TJl085B20:Fea@3Ng^805@3Pgn<00`000000h=oS0>3Oh`0Q0>3Oh`0;0=kN
hP2U]LD085B206j?[02ib=D0l_Ce0;c;f01`TJl085B20:Fea@3Ng^80?P3P
gn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`0E0>3Oh`0;0:Fea@1LPJ80
]/GB0?OgmP3inOP0n_[i0?cln`3moOd0_<cI0625YP2U]LD01P3Pgn<20000
00040>3Oh`000000h=oS0>3Oh`<000000`3Pgn<2000000040>3Oh`000000
h=oS000000@0h=oS0`0000030>3Oh`<000000`3Pgn<3000000h0h=oS00/0
YKG505^1X@2ea=00mOGd0?OgmP3inOP0no_j0?gmo02lc=T0H8FV0:Fea@05
0>3Oh`030000003Pgn<0h=oS0080h=oS0P000000103Pgn<000000>3Oh`3P
gn<2000000040>3Oh`000000h=oS00000080h=oS0P000000103Pgn<00000
0>3Oh`0000030>3Oh`030000003Pgn<0h=oS00<000005`3Pgn<00`2LW9h0
oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0
4@3Pgn<00`2LW9h0oooo0>3Oh`0D0>3Oh`0=0<c@f@0PE880/l??0??cl@3e
mO<0moOf0?Win03jn_T0o?ck0?gmo@2lc=T085B20<c@f@040>3Oh`030000
003Pgn<0h=oS0080000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS
000000020>3Oh`80000000<0h=oS0000003Pgn<00P3Pgn<01`000000h=oS
0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0h=oS00X0h=oS00d0c=3I021DPP2b`Ld0lO7_0??cl@3e
mO@0moOf0?Win03knoX0oOgl0;c<f@0PE880c=3I00@0h=oS00D000000>3O
h`3Pgn<0h=oS000000020>3Oh`80000000@0h=oS0000003Pgn<0h=oS0P00
0000103Pgn<000000>3Oh`0000020>3Oh`80000000<0h=oS0000003Pgn<0
0P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0h=oS01@0h=oS
00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3k
o?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0503Pgn<03@2GZ[h0JH^W0>o_
k03alNl0j>kV09[<V00TUR@0V<VG0>kck@3lo?/0oOgm072A[`2GZ[h0103P
gn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000001@3Pgn<01`000000
h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`03
0>3Oh`030000003Pgn<0h=oS00H0h=oS00<000000>3Oh`3Pgn<02`3Pgn<0
3@2GZ[h0J8VV0>c/j@3_kn`0lO7_0??cl@3emO@0moOf0?Win03knoX0oOgl
072A[`2GZ[h0103Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00<0
00000>3Oh`0000000`3Pgn<01@000000h=oS0000003Pgn<0000000<0h=oS
00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000
003Pgn<0h=oS01D0h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0503P
gn<03@1ENYd0[[k80>c/j@3_kn`0X=:N02ZX9`0RXR004i8@09S8U`3jn_T0
o?ck0;c;f@1ENYd0103Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`D0
000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS000000030>3Oh`D0
000000<0h=oS0000000000000`0000020>3Oh`8000003P3Pgn<03@1ENYd0
Zk[60>SXi@3/k>T0kno/0?7ak`3clo40mOGd0?OgmP3inOP0no_j0;c;f01E
NYd0103Pgn<00`000000h=oS0>3Oh`020>3Oh`@0000000<0h=oS0000003P
gn<00P3Pgn<00`000000h=oS000000020>3Oh`@0000000<0h=oS0000003P
gn<00P3Pgn<00`000000h=oS0>3Oh`02000001P0h=oS00<0W9bN0?ooo`3P
gn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS
00<0W9bN0?ooo`3Pgn<0503Pgn<03@0TEh@0gn7O0>[ZiP3/k>T0CKm:04;3
?`0h^CD08J4Q02JF8`3inOP0n_[i0??emP0TEh@0103Pgn<00`000000h=oS
0>3Oh`02000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`000000
0P3Pgn<2000000030>3Oh`00000000000080h=oS00L000000>3Oh`3Pgn<0
h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`00
0000h=oS0>3Oh`0:0>3Oh`0=02AGQ03Jg=X0iNGR0>SXi@3/k>T0kno/0?7a
k`3clo40mOGd0?OgmP3inOP0l_Ce02AGQ0040>3Oh`8000000P3Pgn<01`00
0000h=oS0>3Oh`3Pgn<000000>3Oh`0000000P3Pgn<2000000040>3Oh`00
0000h=oS000000<0h=oS00@000000>3Oh`00000000000P3Pgn<00`000000
h=oS000000030>3Oh`030000003Pgn<0h=oS01@0h=oS00<0W9bN0?ooo`3P
gn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS
00<0W9bN0?ooo`3Pgn<0503Pgn<03@1ENYd0Zk[50>OWh`3Zj^H0ZMbV05GE
D@13`cl0:JPV09[<V03gmoH0nOWh0;[9eP1ENYd01@3Pgn<2000000040>3O
h`000000h=oS0>3Oh`<000000`3Pgn<2000000060>3Oh`000000h=oS0000
003Pgn<000000P3Pgn<3000000<0h=oS0`0000030>3Oh`<000003@3Pgn<0
3@1ENYd0YkO10>;RgP3UiN80j>SU0>c/j@3_kn`0lO7_0??cl@3emO@0moOf
0;W8e@1ENYd0103Pgn<00`000000h=oS000000020>3Oh`<000000`3Pgn<2
000000040>3Oh`000000h=oS00000080h=oS0`0000020>3Oh`040000003P
gn<00000000000<0h=oS0`00000G0>3Oh`0309bLWP3oool0h=oS0100h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3o
ool0h=oS01@0h=oS00d0UjZn06J7X`3UiN40inOS0>;XgP2Yg:H0CKm:0:3B
WP3Xk^H0mOGc0?OgmP1^T:d0UjZn00P0h=oS00<000000>3Oh`3Pgn<0;03P
gn<03@2GZ[h0I8JQ0>3Pf`3Rh]h0iNGR0>SXi@3/k>T0kno/0?7ak`3clo40
mOGd06j?[02GZ[h04P3Pgn<00`000000h=oS0>3Oh`0X0>3Oh`0309bLWP3o
ool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A
0>3Oh`0309bLWP3oool0h=oS01@0h=oS00d0c=3I021DPP2Y^L<0iNGQ0>OW
h`3Zj^H0k>cY0>o_k03alNl0lo?a0;K5dP0PE880c=3I00P0h=oS00<00000
0>3Oh`3Pgn<0;03Pgn<03@3<d=T085B20:Je_`3Ph=/0h^;N0>GUhP3Xj>D0
k>cY0>o_k03alNl0]LC@021DPP3<d=T04P3Pgn<00`000000h=oS0000000X
0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS01D0h=oS00/0YKG505Ml
W02Y^L<0iNGQ0>OWh`3Zj^H0k>cY0>o_k02c`ll0G86R0:Fea@0i0>3Oh`0;
0:Fea@1ENYX0Y[Fo0>3Pf`3Rh]h0iNGR0>SXi@3/k>T0//7=05^1X@2U]LD0
?P3Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0
IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`0E0>3Oh`0;0=kNhP2U
]LD085B206J7X`2[^/D0gn7O0:jnb01YRjL085B20:Fea@3Ng^80>@3Pgn<0
2`3Ng^80YKG5021DPP1TQZ40YkO10=[LfP2[^/H0J8VV021DPP2U]LD0g]kR
03h0h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<05`3Pgn<01`3<d=T0
UjZn05EjW@0TEh@0EGZM09NZ_P3<d=T0?@3Pgn<01`3<d=T0UjZn05EjW@0T
Eh@0EGZM09NZ_P3<d=T0@03Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3O
h`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn0000
0`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80h=oS00<0W9bN
0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn
0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3Oh`0@0>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0
oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80h=oS
00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3k
o?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3O
h`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<0
0`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh1
0?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS
0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0
oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0
4@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3o
ool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1V
IWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<0
0`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS
0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`03
09bLWP3oool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40
nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0
XP3Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0
IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3o
ool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A
0>3Oh`0309bLWP3oool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<1
06IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?oo
o`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IV
OP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`050>3Oh`@0
00000P3Pgn<020000000h=oS0>3Oh`3Pgn<000000>3Oh`000000h=oS0P00
00020>3Oh`<00000R03Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`04
0>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`0000000`3Pgn<0
1@000000h=oS0000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS
000000270>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn
00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS00@0h=oS00<0
00000>3Oh`3Pgn<00P3Pgn<00`000000h=oS000000030>3Oh`050000003P
gn<000000>3Oh`0000001@3Pgn<00`000000h=oS0>3Oh`260>3Oh`0309bL
WP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IV
OP0A0>3Oh`0309bLWP3oool0oooo00<0oooo00<0h=oS0000003Pgn<00`3P
gn<00`000000h=oS000000030>3Oh`050000003Pgn<000000>3Oh`000000
0`3Pgn<2000000@0h=oSQ@3oool00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<609bLWP030>3Oh`00
0000h=oS00<0h=oS00@000000>3Oh`00000000000P3Pgn<01@000000h=oS
0000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3O
hhH0W9bN00<0oooo0>3Oh`3Pgn<03`3Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn01P0h=oS00<000000>3Oh`3Pgn<00P3Pgn<010000000
h=oS0000003Pgn<200000080h=oS100000020>3Oh`<00000V`3Pgn<106IV
OP40nocm0@1VIWh0000306IVOP3ko?d0IVIn01P0h=oS00<000000>3Oh`3P
gn<00P3Pgn<00`000000h=oS0>3Oh`070>3Oh`030000003Pgn<0h=oS09l0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0H0>3Oh`030000
003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`000000h=oS
0000002Q0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3P
gn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh1
0?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IV
OP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IV
OP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IV
OP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<1
06IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_l
o@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP00
00<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3k
o?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP39
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IV
OP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0
IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0FP3Pgn=P0:F//Pl0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1J0>3Oh`030:F/
/P3oool0oooo05`0oooo00<0YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn05X0h=oS00<0YJbb0?ooo`3oool0G03o
ool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh0FP3Pgn<00`2U[;80oooo0?ooo`1G0?ooo`030000003oool0
oooo0080oooo00<0YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40nocm0@1VIWh0
000306IVOP3ko?d0IVIn04H0h=oS1000000@0>3Oh`030:F//P3oool0oooo
05L0oooo00<000000?ooo`3oool00P3oool00`2U[;80h=oS0>3Oh`0=0>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0BP3Pgn<00`000000
h=oS0>3Oh`0=0>3Oh`030:F//P3oool0oooo05L0oooo00<000000?ooo`3o
ool00P3oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP00
00<0IVIn0?_lo@1VIWh03`3Pgn<5000000030>3Oh`000000h=oS0080h=oS
00@000000>3Oh`00000000000P3Pgn<300000080h=oS00<000000>3Oh`3P
gn<01@3Pgn<2000000040>3Oh`000000h=oS000000<0h=oS00<000000>3O
h`3Pgn<00`3Pgn<2000000040>3Oh`000000h=oS000000<0h=oS00<00000
0>3Oh`3Pgn<00P000000103Pgn<000000>3Oh`0000020>3Oh`<000000P3P
gn<00`000000h=oS0>3Oh`030>3Oh`030:F//P3oool0oooo05L0oooo00<0
00000?ooo`3oool00P3oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh03`3Pgn<00`000000h=oS0>3Oh`03
0>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS000000020>3Oh`070000
003Pgn<0h=oS0>3Oh`000000h=oS000000060>3Oh`030000003Pgn<0h=oS
0080000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS0>3Oh`020>3O
h`030000003Pgn<0h=oS0080000000<0h=oS0000003Pgn<00P3Pgn<00`00
0000h=oS000000020>3Oh`80000000@0h=oS0000003Pgn<000000`3Pgn<0
0`000000h=oS0>3Oh`050>3Oh`030:F//P3oool0oooo05L0oooo00<00000
0?ooo`3oool00P3oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d1
06IVOP0000<0IVIn0?_lo@1VIWh03`3Pgn<00`000000h=oS0>3Oh`030>3O
h`070000003Pgn<0h=oS0>3Oh`000000h=oS000000020>3Oh`030000003P
gn<0h=oS00<0h=oS00<000000>3Oh`3Pgn<0103Pgn<01`000000h=oS0>3O
h`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`020>3Oh`07
0000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0
000000<0h=oS00D000000>3Oh`000000h=oS0000000;0>3Oh`030:F//P3o
ool0oooo05L0oooo00<000000?ooo`3oool00P3oool00`2U[;80h=oS0>3O
h`0=0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh03`3Pgn<0
0`000000h=oS0>3Oh`030>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS
000000020>3Oh`D0000000<0h=oS0000003Pgn<01P3Pgn<4000000030>3O
h`000000h=oS0080h=oS00<000000>3Oh`3Pgn<00`3Pgn<4000000030>3O
h`000000h=oS0080h=oS00<000000>3Oh`0000000`3Pgn<010000000h=oS
0000003Pgn<5000000L0h=oS00<0YJbb0?ooo`3oool0E`3oool00`000000
oooo0?ooo`020?ooo`030:F//P3Pgn<0h=oS00d0h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP0?0>3Oh`D0000000<0h=oS000000000000
0P3Pgn<00`000000h=oS000000020>3Oh`060000003Pgn<0h=oS0>3Oh`00
0000h=oS0P0000050>3Oh`060000003Pgn<0h=oS0>3Oh`000000h=oS0P00
00020>3Oh`030000003Pgn<0h=oS0080h=oS00H000000>3Oh`3Pgn<0h=oS
0000003Pgn<200000080h=oS00<000000>3Oh`0000000P3Pgn<200000004
0>3Oh`000000h=oS000000<0h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`2U
[;80oooo0?ooo`1G0?ooo`030000003oool0oooo0080oooo00<0YJbb0>3O
h`3Pgn<03@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn00l0
h=oS00<000000>3Oh`3Pgn<00`3Pgn<01@000000h=oS000000000000h=oS
00<000000P3Pgn<300000080h=oS00<000000>3Oh`0000001@3Pgn<30000
0080h=oS00@000000>3Oh`00000000001P3Pgn<300000080h=oS00@00000
0>3Oh`00000000000`3Pgn<2000000040>3Oh`000000h=oS00000080h=oS
0`0000020>3Oh`030000003Pgn<0h=oS00<0h=oS00<0YJbb0?ooo`3oool0
E`3oool00`000000oooo0?ooo`020?ooo`030:F//P3Pgn<0h=oS00d0h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0?0>3Oh`030000003P
gn<0h=oS00T0h=oS00<000000>3Oh`3Pgn<0;P3Pgn<00`000000h=oS0>3O
h`0;0>3Oh`030:F//P3oool0oooo05L0oooo00<000000?ooo`3oool00P3o
ool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh03`3Pgn<5000000L0h=oS00<000000>3Oh`3Pgn<0;P3Pgn<0
0`000000h=oS0>3Oh`0;0>3Oh`030:F//P3oool0oooo05L0oooo00<00000
0?ooo`3oool00P3oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d1
06IVOP0000<0IVIn0?_lo@1VIWh0FP3Pgn<00`2U[;80oooo0?ooo`1G0?oo
o`030000003oool0oooo0080oooo00<0YJbb0>3Oh`3Pgn<03@3Pgn<106IV
OP40nocm0@1VIWh0000306IVOP3ko?d0IVIn05X0h=oS00<0YJbb0?ooo`3o
ool0E`3oool00`000000oooo0?ooo`020?ooo`030:F//P3Pgn<0h=oS00d0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1J0>3Oh`030:F/
/P3oool0oooo05L0oooo00<000000?ooo`3oool00P3oool00`2U[;80h=oS
0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0FP3P
gn<00`2U[;80oooo0?ooo`1G0?ooo`030000003oool0oooo0080oooo00<0
YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn05X0h=oS00<0YJbb0?ooo`3oool0G03oool00`2U[;80h=oS0>3Oh`0=
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0FP3Pgn=P0:F/
/Pl0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn0000
0`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1V
IWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?Ogn@2H
V:L0b@1gMi8109RHY`40moOi0@1VIWh0000306IVOP3gmoT0_;g=0<X0_;g=
0@3gmoT106IVOP0000<0IVIn0?Ogn@3Thn<0bP3Thn<10?Ogn@40IVIn0000
0`1VIWh0l?7d0?ooo`240?ooo`030>CSh`2LY;T0JgF?00<0JgF?00@0K7J@
06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0knk^0<K9d`@0
ZJfi00@0ZZfi0:V]^@2Z[KT0ZZfi2@2Y[KT01P36bM<0knk^0?ooo`3oool0
k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0YcY42@2V>D@00`2LY;T0k>[Z
0?ooo`020?ooo`40l?7d0@1VIWh0000F06IVOP3RhN80nocl0?_ko03ko?d0
o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m0?clo03lno`0o?cl0?_lo03l
o?`0nocm0?cko03lo?d0no_m0?_lo080o?cl00@0o?cm0?clo03knod0o?cm
9P3lno`01P3imoT0jNO]0=OCgP37`]40g=WR0>WWk@@0o?_l<03ko?`;0?_l
o@0309bT^@1[MHl0QHV`0100QHV`00H0JgF?09bT^@3ko?d0nocm0<K9d`2Y
[KTA0;fndP060:V]^@36bM<0no_l0?clo02LY;T0YSU44@2Z?5D01P2V>D@0
W:Bi0?clo03lnod0nocm0>;QhP40IVIn0000101VIWh0h>3Q0?Kgn@3gmoT2
0?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Og
n@3fmoT00P3gmoT0103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0
moOi02@0moOi00P0j^[/09RGW@1:Bdh03Q0@06e^K`2OWj<0al;A0=kKi0<0
moOi<03fmoT;0?Ogn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3g
moT0moOi0:V]^@3;c=XA0<?5e0080<_<fP2Y[KT0moOh0?Kgn@2V>D@0ZSaE
0<9BF`36E5X=0<IEG0080<IDFP32DU/0ZSaE0:HiA03gmoT0moOh0?Ogn@3P
h>4106IVOP0000D0IVIn0=kMh@3alO@0lO7d0?3am00@000000070?7bm03a
lO@0l?;e0?7am03al_@0l?;d0?7am00U0?3am@0808Z<SP1ADU@0c/kD0?3a
m@2n_l803Q0@06QVKP3Cd=/c0?3am@/0l?7d00<0JgF?0;:ed02WZ<80402W
Z<801P2b]M00JgF?0?3am03`lO@0ZJfi0<c>fa40b/_H00D0c<kK0:V]^@3a
l_@0lO7e0:HiA0020<9BF`030<]DF@3=FEh0cEUN00/0cEUN00P0beAI0<9B
F`32DU/0YSU40?3am03alO@0l?;d0=kMh@40IVIn00001P1VIWh0g=_P0>[[
l03Zjo00j^c`00000080inOW0P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0
inOW0P3_knl01@000000j^c_0>[[l03Zjo00j^__0080j^_`00L0j^__0=gL
i@3Ac]X0al;A0=7>fP3Lf^<0i>C[0080j^_`00D0h>3X0=7>fP37`]40eM;M
0>OWk@020>[[l0030>?SjP37`]40al;A00H0j^_`00L0gMcU0<O2d@3Og^H0
gMcU0<O2d@3Ti>/0j^_`0080al;A0P3Zjo020<O2d@0B0=OHg02f]K`0al;A
0<O2d@2g//003Q0@04Y;CP3ShnX0j^_`0>CTj`3Ac]X0h^;Y0>[/l03PhNP0
dLkJ0<O2d@3Edmd0inS]0P3Zk?020=SFh0<0j^c`0P3He^030>[/l080f=KP
6`3Zk?0;0>[[k`0406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk60:b^aP2]
[/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`040:V]^@3@d=`0c/kJ0<k>
fP`0oooo0`3>c]X02@3@d=`0ZJfi0>[[l03Zjo00YSU40<eIGP3;E5T0cEIK
0<iIG`0;0=1JG`060<iIG`3=EU/0beAI0<eIGP2V>D@0j^_`0P3Zjnl10=cK
h040IVIn00002P1VIWh0fMWO0>?UjP3Si>X0hnG[0000002<S8`0g]kN0>OW
i`3Ng]h20>OWi`030<IS003WinL0inOW0080inOW00P0knoW0>o_k`3_knl0
00000>?UjP3Si>X0hnC[0>?UjP80hnCZ0100ShnF04Q9C00>4100CU1B08b>
TP2[Yk@0al;A0>?Uj`2VYZd0ATI:00h@401RHfL0_[_60=[Jh`3SiN/0_;k2
0P0>41060>?Uj`0709>CV@0>4100XJ>W09FFV`0>4100ZjNd0>3Rj00200h@
40060<O2d@3SiN/03Q0@00h@4037`]40Si6D100>41004@1UIfT0_;k20>?U
j`33aLX0B4U<09jKYP3Si>X0YZJ/04I6BP0>4100HV=V0;jkaP3JfN80hnCZ
07EgNP1^KW<0e=;M0080hnCZ00<0MGMj06i^L`3Dd]d00P3Si>X00`1eMgX0
KVic0=CBg@0K0>?TjP/0hnGZ00D0JgF?0;bne02b//X0/[;:0?ooo`0606i]
S`0302DU=P2b//X0/[;:00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ0:V]^@3B
dml20=7Ag0030?ooo`2DU9`0U9BL00T0U9BL0`3AdM`01@3Bdml0ZJfi0>?T
j`3SiNX0YSU40080cEUN00@0d5]P0=ALG`3oool0oooo1`3DG5l20?ooo`09
0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnGZ0>?TjP3SiN/0fMWO0040IVIn0000
0`1VIWh0emSN0=cNiP020=cNiP050000003WinL0inOW0>OWi`3We/h00P3W
inL01@3>N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_00<000000=cMiP3Lg^H0
0P3Lg^D01P3Lg^H0Kg1d04I6BP2a/KT0g=kU0<C6c0803Q0@00L0al;A0:JX
[P0>4100UiBO0:j`]P1<CU00WZ2U0080g=kU00<0C4i@00h@4037`]401@3L
g^D0102EUi/03Q0@0;Nb`02^/;H200h@40060;Nb`03Lg^D03Q0@00h@4037
`]40g=kU0P0>41001037`]40LWAg00h@402a[KX20<O2d@0<0=;Ag03Jfn<0
g=kU04a>D00>4100al;A0:JX[P0>4100UiBO0:j`]P1<CU00WZ2U0P3Lg^D2
079dM`<0g=kU0P1bM7L30=cNi@80LWAg9`3Lg^D01@1[MHl0_l7F0;RicP2h
^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cN
i@3Lg^D0ZJfi0=CFh080e=GN00<0oooo09BDW03DeMh01`3DeMh00`3oool0
U9BL0=CEgP020=CEgP090=CFh02Y[KT0g=kU0=cNiP2V>D@0cEUN0=5JGP3D
GF40DbDP00<0oooo1@3FGf<30?ooo`0905<U803DGF40dEYN0<eIGP2V>D@0
g=kU0=cNiP3Lg^D0emSN0040IVIn00001`1VIWh0eMKM0=GHh03Ff>40eMSP
0000002<S8`00P3WinL01@3W]H@0eUX00=J4003ocP00cV<00080gV/000H0
kkF<0>o_k`3_knl0kno_0000003Ef>020=GHh@050=GGh02RY:X03Q0@09ND
W`3EeMl00P3Fen0200h@40030<O2d@1:C4l03Q0@00D0al;A00@0e]OP00h@
400>4100al;A1@3Fen0200h@40060<O2d@3Cdmd03Q0@00h@4037`]40e]OP
0P0>41001P37`]40e]OP00h@400>4100al;A0<C6cP<03Q0@00@0Ngb10;Nb
`03>c=P0e]OP0P0>41000`37`]40BTa?00h@40050<O2dBT0e]SP2`3Ef>40
1@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?0=GH
h@3Ef>40ZJfi0=OHhP80e]OQ00<0oooo09BDW03Fen401`3Fen400`3oool0
U9BL0=KGh@020=KGh@050=OHhP2Y[KT0eMOQ0=GGh02V>D@00P3EGF000`3H
H640fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@020=EM
H0050:HiA03Ef>40eMOP0=GHh@3Ee]d00@1VIWh0000606IVOP3Be=d0cm;L
0=3Bg03@d]d000000`3WinL0303Wg/h0aTX00?O>003_[@00kkD00<i[0036
FP00aV/00=j<BP3WY@00knO>000000@0d=;L00<0GEmS00h@402l^<H00`3@
d]`200h@40030<O2d@0>41003Q0@00@03Q0@00D0bLKD0=3Bg00>41003Q0@
0<O2d@050=3Bg00407UkP00>4100ZJVc0<W6e0803Q0@00H0al;A0=3Bg00>
41003Q0@0<O2d@3@d]`200h@40090<O2d@1MGf<03Q0@0;6]^P2i^l@03Q0@
06QVKP37`]40d=;L00803Q0@00<0al;A00h@400>4100100>41000`39a]@0
cm;M0<oBg@0W0<oBg@/0d=;L00<0JgF?0<S9f`33a=H04033a=H01P38bM/0
JgF?0=3Bg03@d]`0ZJfi0=[Ki080f]_S00<0oooo09BDW03Jfn<01`3Jfn<0
0`3oool0U9BL0=[Kh`020=[Kh`070=[Ki02Y[KT0cm;L0=3Bg02V>D@0eemO
0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3oool01`167QX0
g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@00P3@d]`10<oBg040d]CM0@1VIWh0
000I06IVOP3@d]/0blgH0<[=f@3;c]P000000>O6[@3WaX`0mlhH0>nm003g
aP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl000000<[>
f@3;cMP0blgI0<[=f@0200h@40030<O2d@3;cMT0blgI00<03Q0@00T0blgI
04M9C@0>4100al;A0<[:e`0>4100ATI:0<W9eP3;cMT00P0>41000`37`]40
blgI0<_=f@040<_=f@0308Z<T`17BDd03Q0@00803Q0@00H0b<OD0<_=f@0>
41003Q0@0<O2d@3:c=P200h@40050<W8e@0>41003Q0@0<O2d@3:bmP00P0>
41003039b=D0blgI00h@400>4100al;A04M9C@0>4100al;A0<[;e`0>4100
ATI:0<W9eRT0blkI2`3;cMP00`1[MHl0blcN0<S:f@080<S:f@030<S9f@38
b]T0b<[I00<0b<[I00@0b<WI0<S:f@3;c=h0JgF?0P3;cMP01P2Y[KT0gMkW
0=cNi@3Lg^D0oooo09BDW0P0g=kU00<0oooo09BDW03Lg^D00P3Lg^D02@3M
g^L0ZJfi0<[=f03:cMT0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN
6P3oool0oooo00<0oooo00T0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO
0:HiA03:c]T00P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0020<G8
e00600000036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD
00020?O60080moOg00<000000<G7e035b=@00P35am@200h@40030<O2d@35
a]@0a<OE00@0a<OE00H0QHRA00h@402MWJP0ZjNd00h@4026QY020<C7e@80
3Q0@0P37`]460<C7e@060<K4dP2g//003Q0@06MWK`35a]@0a<OE0P0>4100
3@2f]L80/:jk00h@401cLg/0aLKD079dO00>4100/:nl0;6]^P0>4100Lg=k
0<K5d`34amD00P0>41001`37`]40QHR@00h@402MWJL0ZjNd00h@4026QXl0
:P34b=@;0<C7e00306]eS`3@dN00bl_L0100bl_L00H0d=7P06]eS`34am@0
a<OD0:V]^@3Ph>T20=kNi`030?ooo`2DU9`0g]kW00L0g]kW00<0oooo09BD
W03Ng^L00P3Ng^L01`3Ph>T0ZJfi0<C7e035b=D0YSU40=]TI03OIF@01@3P
JVP01@167QX0oooo0?ooo`3oool0AQhJ00D0h6YX00<0gfET0=]TI02V>D@0
0P34b=@10<G7e@40cloJ0@1VIWh0000606IVOP3<c]X0`/CB0<74d@31a=80
00000`3WinL03@3FQ000kkD00>NU003WY@00eX@00<i[003W[@00mkD00?Nm
003_knl0moOg00000032a=800`31a=80101GFEl03Q0@0;bhaP34`m460<74
d@0408>6SP0>41003Q0@08>6SP80`LCA100>41060<74d@0505MIG`0>4100
3Q0@071cNP2a]<000P31a=401P0>4100NWf504A6BP0>4100L7=j0;6d`080
`LCA00D0L7=j00h@4014ATX0IFM^09:EW`020<74d@803Q0@00<0al;A0<74
dP23QXl00P0>41000`23QXl0`LCB0<74dP0Y0<74dP/0`/CB00<0JgF?0=?C
hP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80ZJfi0>;RjP80hN7W00<0
oooo09BDW03QhNL01`3QhNL00`3oool0U9BL0>7Qi`020>7Qi`070>;RjP2Y
[KT0`LCA0<74dP2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T01`3QJFD0
ffAT0:HiA032a=40`LCA0<74dP3<c]X00@1VIWh0000:06IVOP3:c=P0_/3?
0;g0c`2n`<h0000009bLW03WinL0imkF0=J<0080gY@000@0eW/00<IS002m
@P00kjD00P3g[@00303g]@00oli:0000002n`<l0_/3>0;k0c`2n`<h0RH^E
00h@402TX:`0a/7@0<?1c`80_/3>0P35`M080;k0cP803Q0@00<0a/7@0;k0
cP2n`<h06P2n`<h200h@40030<O2d@2m`<h0_L3>02h0_L3>2`2n`<h00`1[
MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0cP2Y[KT0i>C[0P3S
hnP00`3oool0U9BL0?ooo`080?ooo`0609BDW03ShnP0hn?X0>?Sj03Ti>/0
ZJfi0P2n`<h00`2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3o
ool0oooo103SK6`00`3QJVX0h6IU0:HiA0020;k0c`40_/3>0@3:c=P106IV
OP0000H0IVIn0<W:f02f^<P0^Kc;0;Zlb`0000020>o_k`0=0=JL003FS000
gY@00=J4003_Y@00gX`00;eJ003FL`00ki`00?O_i`3gmoL0oooo00000002
0;Vlc00;0;Zkc02i_</0/;;00494B@13A4T0XYn/0<K1d037`]40ShbG079a
N@31_ll0202i_<`00`25R9<0E5IM0;Vlc00L0;Vlc0803Q0@00<0a/7@0;Zl
c02j_<`0;P2j_<`;0;Zlb`0306]eS`3Hf>D0dm?Q0100dm?Q00H0f=SU06]e
S`2j_</0^[c;0:V]^@3Vi^d20>;Rj@030?ooo`2h]lP0^;O800P0^;O800H0
U9BL0>;Rj@3Rh^T0h^;Y0>KVk@2Y[KT20;Zlc0060:HiA03PJFP0hFe/0>Aa
K@3TLFl0i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^00P0i75]
0>5]K03PJFP0YSU40;Zkc02i_</0][S80<W:f040IVIn0000201VIWh0alWG
0;Bfa`2f^<P0][S900000024Q8@0inON0P3_knl01`36J`00mlH00>ne003_
W000gX`00<i[003WW0000`3gmoL02@000000][S90;Jib@2g^<T0][W90;Ni
b@2/[[h0O7j90453B00200h@400307AeP02MWjd0]kS902L0]kS900<0Jfaf
0453B02g^<T0<02f^<T;0;Nhb@0406]eS`3Fe^@0f=SU0=SHiP<0f=SU1@3H
f>H30=SHi@80f=SV0P3Hf>D01P3Fe^@0JgF?0;Nhb@2g^<T0ZJfi0>KVk@80
iNG/00<0oooo0;Rgb02h]lP0202h]lP03@2DU9`0iNG/0>GUk03UiN`0i^K]
0:V]^@2g^LT0][W90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0
i7A_0>AdK`3TM6l0AQhJ00<0oooo00T0i7A_0>MaK`3TM6l0i6i]0:HiA02f
^<T0][W90;Bfa`37bML00@1VIWh0000306IVOP36b=L0];K70080];K700<0
00000>o_k`3_knl00P3_knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3N
U3T0kmJe0?ogm`3oool000000780];K700D0JgF?0=GEh`3LfnL0g=_W0=gK
i`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`2Y[KT0iNG/0`3Wind;09BDW0<0
inO]00T0iNG/0:V]^@2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3o
ool00`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0
igEb0>McK`2V>D@30;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?80080
/K?800H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0
moOg0?Ogm`3_imH0moOg0?ooo`00001b0;6cb00306]eS`3Ee><0h=oZ0100
h=oZ00H0eMCS06]eS`2a/lP0/K?80:V]^@3UiN`A0>WYk`090>GUk02Y[KT0
/K?80;6cb02V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]
UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:Hi
A0030;6cb040a/SG0@1VIWh0000306IVOP36b=L0^;O?0080[jk700H00000
0>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg
00<0oooo0000002_[/L0L@2_[/L00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[
l`1[MHl0[jk70:n^a`2Y[KT0m??g4@3`ko@06@3dloL0ZJfi0:n^a`2_[/L0
YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/
]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@00P2_[/L1
0;Rgc`40a/SG0@1VIWh0000306IVOP30`M40alOD0080[:_400D000000:f]
[@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3oool00`000000[:_40:b[a01`
0:b[a00306]eS`3BdN<0l_7g0100l_7g00H0d]7S06]eS`2/Zl@0[:_40:V]
^@3QhNTA0??bmP060>7Qj@2Y[KT0[:_40:b[a02V>D@0m8Ym0P3eT8D=0?:h
WP80mI2500H0m8Ym0:HiA02/Zl@0[:_40<O7e030`M4106IVOP0000@0IVIn
0<31d@3Bd]l0]KC9P`2TXkh01024S:80JgF?0<c;g@3kno`=0?ooo`040?_k
o03<bmd0JgF?08B<XP80Y:>n00@0]k_40:V]^@3QhNT0oOgm3@3oool0103m
oOd0hN7Y0:V]^@2g^l@20:BS_P07096HZP2V>D@0oin=0?joY03jg;L0n^^g
0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf0?[Y]P80nNVf00X0n^^g0?[L]`3n
_j@0oin=0:HiA02AV:X0Y:>n0;Fdb@3Bd]l0`<7A0@1VIWh0000606IVOP2X
Ykl0i^K]0=;Bh02l_<l0/K34PP2XYkl00`24S:80JgF?06]eS`0?06]eS`03
08B<XP2XYkl0Z:No0080Z:No00<0]k_40:V]^@2Y[KT03`2Y[KT00`2g^l@0
Z:No0:RW_`020:RW_`0308B<XP2V>D@0YSU400l0YSU400H0Q8bR0;6`a02l
_<l0d];P0>KVk@2XYkl106IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@
d>00b/[J0<40_;c?00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ000
00P0F5MX06IVOP2EU:/0emSR0?clo03blO<0k>_^0>7Rjkl0emSR00L0hN;[
0>c[kP3blO<0o?cl0=OHhP2EU:/0IVIn0040F5MX000205QGJ00306IVOP2E
U:/0dM7N0080o?cl`@3oool20?clo0030=7AgP2EU:/0IVIn0080F5MX0003
05QGJ080IVIn00<0R8NM09FDZ`2XYkl0`02XYkl0102EU:/0R8NM06IVOP1V
IWh305QGJ0001@1HEfS506IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  Evaluatable->False,
  ImageSize->{207, 176},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Properties"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Properties"]
}, Open  ]],

Cell["\<\
We can request a list of all property names available with the widget \
referred to by \"inputField\" in the dialog.\
\>", "Text",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \("\<PropertyNames\>"\  /. \ 
      GUIInformation[ref\ , "\<inputField\>"]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \({"AccessibleContext", "Action", "ActionCommand", "ActionListeners", 
      "ActionMap", "Actions", "AlignmentX", "AlignmentY", 
      "AncestorListeners", "Autoscrolls", "Background", "BackgroundSet", 
      "Border", "Bounds", "Caret", "CaretColor", "CaretListeners", 
      "CaretPosition", "Class", "ColorModel", "Columns", "Component", 
      "ComponentCount", "ComponentListeners", "ComponentOrientation", 
      "Components", "ContainerListeners", "Cursor", "CursorSet", 
      "DebugGraphicsOptions", "DisabledTextColor", "Displayable", "Document", 
      "DoubleBuffered", "DragEnabled", "DropTarget", "Editable", "Enabled", 
      "Focusable", "FocusAccelerator", "FocusCycleRoot", 
      "FocusCycleRootAncestor", "FocusListeners", "FocusOwner", 
      "FocusTraversable", "FocusTraversalKeys", "FocusTraversalKeysEnabled", 
      "FocusTraversalPolicy", "FocusTraversalPolicySet", "Font", "FontSet", 
      "Foreground", "ForegroundSet", "Graphics", "GraphicsConfiguration", 
      "Height", "HierarchyBoundsListeners", "HierarchyListeners", 
      "Highlighter", "HorizontalAlignment", "HorizontalVisibility", 
      "IgnoreRepaint", "InputContext", "InputMap", "InputMethodListeners", 
      "InputMethodRequests", "InputVerifier", "Insets", "KeyListeners", 
      "Keymap", "Layout", "Lightweight", "Locale", "Location", 
      "LocationOnScreen", "ManagingFocus", "Margin", "MaximumSize", 
      "MaximumSizeSet", "MinimumSize", "MinimumSizeSet", "MouseListeners", 
      "MouseMotionListeners", "MouseWheelListeners", "Name", 
      "NavigationFilter", "NextFocusableComponent", "NotifyAction", "Opaque", 
      "OptimizedDrawingEnabled", "PaintingTile", "Parent", "Peer", 
      "PreferredScrollableViewportSize", "PreferredSize", "PreferredSizeSet", 
      "PropertyChangeListeners", "RegisteredKeyStrokes", 
      "RequestFocusEnabled", "RootPane", "ScrollableTracksViewportHeight", 
      "ScrollableTracksViewportWidth", "ScrollOffset", "SelectedText", 
      "SelectedTextColor", "SelectionColor", "SelectionEnd", 
      "SelectionStart", "Showing", "Size", "Text", "Toolkit", "ToolTipText", 
      "TopLevelAncestor", "TransferHandler", "TreeLock", "UI", "UIClassID", 
      "Valid", "ValidateRoot", "VerifyInputWhenFocusTarget", 
      "VetoableChangeListeners", "Visible", "VisibleRect", "Width", "X", 
      "Y"}\)], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Properties"]
}, Open  ]],

Cell[TextData[{
  "We can use ",
  StyleBox["ToString", "MR"],
  " and ",
  StyleBox["ToExpression", "MR"],
  " with ",
  StyleBox["SetPropertyValue", "Output"],
  " to include conversion to ",
  StyleBox["String", "Program"],
  ", or ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression values using common optional arguments found with ",
  StyleBox["ToString", "Output"],
  " and ",
  StyleBox["ToExpression", "Output"],
  "."
}], "Text",
  CellTags->"Properties"],

Cell[BoxData[
    \(ref\ @\ 
      SetPropertyValue[{"\<inputField\>", \ "\<text\>"}, \ "\<a+a\>"]\)], \
"Input",
  CellLabel->"In[5]:=",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // \ Show\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"Properties"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003?0000/2000`400?l0
0000o`00003oc`1VIWh0000306IVOP3ko?d0nocm0</0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0<T0IVIn0@2XZK/10?_lo@40IVIn00000`1VIWh0nocm
06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3P
gn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh1
0?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IV
OP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IV
OP3ko?d0IVIn04h0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;bm00C0??cm100
n?Oh0P3clo@01@3cloD0m?Ce0?GemP3dloD0iNCX00H0h=oS00D0hN3T0>KU
j03/jnh0l?3b0?;bm00L0??cm1T0n?Oh0P3clo@01@3cloD0m?Ce0?GemP3d
loD0iNCX00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>
0>3Oh`040=kLg`3Th^00NiN]02EGQBL003ad00@05den06^;YP3blNh0l_7c
1P3Pgn<0103Ng=l0i>;P07^G[@0UEhDi000lM00401M=OP1[RjH0l_7^0?;a
l`D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`04
0=[Hf@1VQJ409df504em`BP0JH;^00<09df506Z:Y03_ko401P3Pgn<0103J
f=T0IXFQ04YaT`2b_L<i0<K5e`040<36a@18KY00JXZT0>o_l@D0h=oS0@1V
IWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`030=SEeP0GCGh0
RJgT02X0RJgT00<05den0>_Zk@3Pgn<01@3Pgn<00`3HeMH05den0;o7bP0k
0<K5e`030;Jm_@0GCGh0jn[]00D0h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP1>0>3Oh`040=WEe@00?7@0RJgT0?ooobL0cLcO00@0oooo
08V]i000?7@0j>OZ1P3Pgn<00`3IeMD003ad0?ooo`0k0<g<g`030?ooo`00
?7@0j>OZ00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>
0>3Oh`040=WEe@00?7@0RjgT0?ooobL0d]7T00@0oooo08^_i@00?7@0inKY
1P3Pgn<00`3IeMD003ad0?ooo`0k0=;Ai0030?ooo`00?7@0inKY00D0h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`040=WEe@00
?7@0SZoV0?ooobL0e]OW00@0oooo08f_i@00?7@0inKY1P3Pgn<00`3IeMD0
03ad0?ooo`0k0=KGi`030?ooo`00?7@0inKY00D0h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP1>0>3Oh`040=WEe@00?7@0TK7W0?ooo`h0
fM[W0`0000030=WJi`030000003If^L0fM[W0080fM[W00<000000=WJi`3I
f^L02`3If^L0103oool0TK7V000lM03Wi^T60>3Oh`030=WEe@00?7@0oooo
00l0fM[W0`0000030=WJi`80000000@0fM[W0000003If^L000000`3If^L0
0`000000fM[W0=WJi`03000000<0fM[W0`0000020=WJi`030000003If^L0
fM[W00`0fM[W00<0oooo000lM03Wi^T01@3Pgn<106IVOP40nocm0@1VIWh0
000306IVOP3ko?d0IVIn04h0h=oS00@0fMGE000lM02D]>P0oooo3@3If^L0
1@000000fM[W0=WJi`3If^L000000080fM[W00D000000=WJi`3If^L0fM[W
0000000>0=WJi`040?ooo`2E]>P003ad0>OVj@H0h=oS00<0fMGE000lM03o
ool03P3If^L01`000000fM[W0=WJi`3If^L000000=WJi`0000000P3If^L2
000000030=WJi`000000fM[W0080fM[W00<000000=WJi`0000000`3If^L0
0`000000fM[W000000030=WJi`030000003If^L0000000h0fM[W00<0oooo
000lM03Wi^T01@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn
04h0h=oS00@0fMGE000lM02H^>X0oooo303Ngn`00`000000g]o/0=kOk003
0=kOk0030000003Ngn`0000000<0g]o/00<000000=kOk03Ngn`0303Ngn`0
103oool0V;SY000lM03Wi^T60>3Oh`030=WEe@00?7@0oooo00d0g]o/00<0
00000=kOk03Ngn`0103Ngn`01`000000g]o/0=kOk03Ngn`000000=kOk000
00000`3Ngn`00`000000g]o/000000050=kOk0030000003Ngn`0g]o/00<0
g]o/00<000000=kOk03Ngn`0303Ngn`00`3oool003ad0>OVj@050>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad
09bkjP3oool<0>?Ul0030000003SiO00hnG`00<0hnG`00H000000>?Ul000
000000000>?Ul000000?0>?Ul0040?ooo`2L^n/003ad0>OVj@H0h=oS00<0
fMGE000lM03oool03@3SiO000`000000hnG`0>?Ul0050>?Ul0@0000000<0
hnG`0000003SiO000P3SiO000`000000hnG`000000050>?Ul0D0000000<0
hnG`0000003SiO003@3SiO000`3oool003ad0>OVj@050>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad0:2nk03o
ool<0>W[m@030000003YjoD0jN_e00<0jN_e00@000000>W[m@000000jN_e
0P00000?0>W[m@040?ooo`2Q_^`003ad0>OVj@H0h=oS00<0fMGE000lM03o
ool03@3YjoD00`000000jN_e0>W[m@040>W[m@060000003YjoD0jN_e0>W[
m@000000jN_e0P0000020>W[m@030000003YjoD0000000<0jN_e00<00000
0>W[m@0000000`3YjoD00`000000jN_e0000000>0>W[m@030?ooo`00?7@0
inKY00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1>0>3O
h`040=WEe@00?7@0YL7]0?ooo``0l?7l00<000000?3ao03`lO`00`3`lO`0
0`000000l?7l000000020?3ao0030000003`lO`0l?7l00d0l?7l00@0oooo
0:G2kP00?7@0inKY1P3Pgn<00`3IeMD003ad0?ooo`0=0?3ao0030000003`
lO`0l?7l00D0l?7l0`0000020?3ao0040000003`lO`00000000000<0l?7l
0`0000030?3ao0<000000P3`lO`00`000000l?7l0?3ao00<0?3ao0030?oo
o`00?7@0inKY00D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IV
OP1>0>3Oh`040=WEe@00?7@0ZLG_0?ooo`d0m?Gm00D000000?Ceo@3dmOd0
m?Gm000000020?Ceo@050000003dmOd0m?Gm0?Ceo@0000003P3dmOd0103o
ool0ZLG_000lM03Wi^T60>3Oh`030=WEe@00?7@0oooo00h0m?Gm00D00000
0?Ceo@3dmOd0m?Gm0000000I0?Ceo@030000003dmOd0m?Gm00`0m?Gm00<0
oooo000lM03Wi^T01@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn04h0h=oS00@0fMGE000lM02]b?00oooo3P3fmod3000000<0m_Om00<0
00000?Kgo@3fmod00P3fmod00`000000m_Om0?Kgo@0;0?Kgo@040?ooo`2/
ao0003ad0>OVj@H0h=oS00<0fMGE000lM03oool03`3fmod3000001X0m_Om
00<000000?Kgo@3fmod0303fmod00`3oool003ad0>OVj@050>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad0;7;
lP3ooolW0?Slo@040?ooo`2ac?8003ad0>OVj@H0h=oS00<0fMGE000lM03o
ool0>`3ho?d00`3oool003ad0>OVj@050>3Oh`40IVIn0@3ko?d106IVOP00
00<0IVIn0?_lo@1VIWh0CP3Pgn<0103IeMD003ad0;C=l`3ooolW0?gmo@04
0?ooo`2ec_<003ad0>OVj@H0h=oS00<0fMGE000lM03oool0>`3moOd00`3o
ool003ad0>OVj@050>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1V
IWh0CP3Pgn<0103IeMD003ad0;O@m03ooolW0?gmo@040?ooo`2hd?D003ad
0>KVj@H0h=oS00<0fMGE000lM03oool0>`3moOd00`3oool003ad0>KVj@05
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0103H
e=@003ad0;[Cm@3ooolW0?gmo@040?ooo`2jdoH003ad0>GUj0H0h=oS00<0
f=CD000lM03oool0>`3moOd00`3oool003ad0>GUj0050>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<00`3IeMD09EN50;cDmP0Z
0;cDmP0302EGQ@3QhN@0h=oS00D0h=oS00<0fMGE02EGQ@2oc]`0>`3oool0
0`2oc]/09EN50>7Qi0050>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh0CP3Pgn<00`3IeMD0NIBY02M=Q@0Y0<kWo`0302M=Q@1iUJ/0gmgP
00H0h=oS00@0fMGE07VDZ@1EOJ80`<oM>@3oool0103EgnP0EGfR07VEZ`3O
gN050>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<0
103JemT0gmcH07VDZ@0UEhDW000lM00401M=OP1VQZ40h=kJ0=cKg@H0h=oS
00@0f]OI0=oLf01iU:T09EN5>@00?7@0100GCGh0IXJQ0>3NfP3Lfmd50>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0CP3Pgn<00`3OgN00
f]OI0=SDe00E0=OCe100dlk<0`3Gdm@0103He=@0fMGE0=[Gf@3OgN060>3O
h`030=oMh03JemT0f=CD01h0em?D6@3Cc/`30=OCe0040=SDe03IeMD0f]OI
0=oMh0D0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40
nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn
00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn
0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn0000
0`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1V
IWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP0A0>3OhjL0oooo4@3Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn0140h=oSYP2LW9h00`3oool0h=oS0>3Oh`0?0>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo
0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn
00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80h=oS00<0
W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3Oh`0@
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2L
W9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_l
o@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80
h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IV
OP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo
0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3P
gn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1V
IWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0
h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0
000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2L
W9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1V
IWh04@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bL
WP3oool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3P
gn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`0G0>3Oh`070<c@f@2GZ[h0
EGZM02AGQ01ENYd0UjZn0<c@f@0C0>3Oh`@000009P3Pgn<01`3<d=T0UjZn
05EjW@0TEh@0EGZM09NZ_P3<d=T0@03Pgn<00`2LW9h0oooo0>3Oh`0@0>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0
oooo0>3Oh`0E0>3Oh`0;0=kNhP2U]LD085B206j@[@2jbMH0loGf0;c;f@1`
TJl085B20:Fea@3Ng^805@3Pgn<00`000000h=oS0>3Oh`0Q0>3Oh`0;0=kN
hP2U]LD085B206j?[02ib=D0l_Ce0;c;f01`TJl085B20:Fea@3Ng^80?P3P
gn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`0E0>3Oh`0;0:Fea@1LPJ80
]/GB0?OgmP3inOP0n_[i0?cln`3moOd0_<cI0625YP2U]LD01P3Pgn<20000
00040>3Oh`000000h=oS0>3Oh`<000000`3Pgn<2000000040>3Oh`000000
h=oS000000@0h=oS0`0000030>3Oh`<000000`3Pgn<3000000h0h=oS00/0
YKG505^1X@2ea=00mOGd0?OgmP3inOP0no_j0?gmo02lc=T0H8FV0:Fea@05
0>3Oh`030000003Pgn<0h=oS0080h=oS0P000000103Pgn<000000>3Oh`3P
gn<2000000040>3Oh`000000h=oS00000080h=oS0P000000103Pgn<00000
0>3Oh`0000030>3Oh`030000003Pgn<0h=oS00<000005`3Pgn<00`2LW9h0
oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0
4@3Pgn<00`2LW9h0oooo0>3Oh`0D0>3Oh`0=0<c@f@0PE880/l??0??cl@3e
mO<0moOf0?Win03jn_T0o?ck0?gmo@2lc=T085B20<c@f@040>3Oh`030000
003Pgn<0h=oS0080000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS
000000020>3Oh`80000000<0h=oS0000003Pgn<00P3Pgn<01`000000h=oS
0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0h=oS00X0h=oS00d0c=3I021DPP2b`Ld0lO7_0??cl@3e
mO@0moOf0?Win03knoX0oOgl0;c<f@0PE880c=3I00@0h=oS00D000000>3O
h`3Pgn<0h=oS000000020>3Oh`80000000@0h=oS0000003Pgn<0h=oS0P00
0000103Pgn<000000>3Oh`0000020>3Oh`80000000<0h=oS0000003Pgn<0
0P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0h=oS01@0h=oS
00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3k
o?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0503Pgn<03@2GZ[h0JH^W0>o_
k03alNl0j>kV09[<V00TUR@0V<VG0>kck@3lo?/0oOgm072A[`2GZ[h0103P
gn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000001@3Pgn<01`000000
h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`03
0>3Oh`030000003Pgn<0h=oS00H0h=oS00<000000>3Oh`3Pgn<02`3Pgn<0
3@2GZ[h0J8VV0>c/j@3_kn`0lO7_0??cl@3emO@0moOf0?Win03knoX0oOgl
072A[`2GZ[h0103Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00<0
00000>3Oh`0000000`3Pgn<01@000000h=oS0000003Pgn<0000000<0h=oS
00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000
003Pgn<0h=oS01D0h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0503P
gn<03@1ENYd0[[k80>c/j@3_kn`0X=:N02ZX9`0RXR004i8@09S8U`3jn_T0
o?ck0;c;f@1ENYd0103Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`D0
000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS000000030>3Oh`D0
000000<0h=oS0000000000000`0000020>3Oh`8000003P3Pgn<03@1ENYd0
Zk[60>SXi@3/k>T0kno/0?7ak`3clo40mOGd0?OgmP3inOP0no_j0;c;f01E
NYd0103Pgn<00`000000h=oS0>3Oh`020>3Oh`@0000000<0h=oS0000003P
gn<00P3Pgn<00`000000h=oS000000020>3Oh`@0000000<0h=oS0000003P
gn<00P3Pgn<00`000000h=oS0>3Oh`02000001P0h=oS00<0W9bN0?ooo`3P
gn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS
00<0W9bN0?ooo`3Pgn<0503Pgn<03@0TEh@0gn7O0>[ZiP3/k>T0CKm:04;3
?`0h^CD08J4Q02JF8`3inOP0n_[i0??emP0TEh@0103Pgn<00`000000h=oS
0>3Oh`02000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`000000
0P3Pgn<2000000030>3Oh`00000000000080h=oS00L000000>3Oh`3Pgn<0
h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`00
0000h=oS0>3Oh`0:0>3Oh`0=02AGQ03Jg=X0iNGR0>SXi@3/k>T0kno/0?7a
k`3clo40mOGd0?OgmP3inOP0l_Ce02AGQ0040>3Oh`8000000P3Pgn<01`00
0000h=oS0>3Oh`3Pgn<000000>3Oh`0000000P3Pgn<2000000040>3Oh`00
0000h=oS000000<0h=oS00@000000>3Oh`00000000000P3Pgn<00`000000
h=oS000000030>3Oh`030000003Pgn<0h=oS01@0h=oS00<0W9bN0?ooo`3P
gn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS
00<0W9bN0?ooo`3Pgn<0503Pgn<03@1ENYd0Zk[50>OWh`3Zj^H0ZMbV05GE
D@13`cl0:JPV09[<V03gmoH0nOWh0;[9eP1ENYd01@3Pgn<2000000040>3O
h`000000h=oS0>3Oh`<000000`3Pgn<2000000060>3Oh`000000h=oS0000
003Pgn<000000P3Pgn<3000000<0h=oS0`0000030>3Oh`<000003@3Pgn<0
3@1ENYd0YkO10>;RgP3UiN80j>SU0>c/j@3_kn`0lO7_0??cl@3emO@0moOf
0;W8e@1ENYd0103Pgn<00`000000h=oS000000020>3Oh`<000000`3Pgn<2
000000040>3Oh`000000h=oS00000080h=oS0`0000020>3Oh`040000003P
gn<00000000000<0h=oS0`00000G0>3Oh`0309bLWP3oool0h=oS0100h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3o
ool0h=oS01@0h=oS00d0UjZn06J7X`3UiN40inOS0>;XgP2Yg:H0CKm:0:3B
WP3Xk^H0mOGc0?OgmP1^T:d0UjZn00P0h=oS00<000000>3Oh`3Pgn<0;03P
gn<03@2GZ[h0I8JQ0>3Pf`3Rh]h0iNGR0>SXi@3/k>T0kno/0?7ak`3clo40
mOGd06j?[02GZ[h04P3Pgn<00`000000h=oS0>3Oh`0X0>3Oh`0309bLWP3o
ool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A
0>3Oh`0309bLWP3oool0h=oS01@0h=oS00d0c=3I021DPP2Y^L<0iNGQ0>OW
h`3Zj^H0k>cY0>o_k03alNl0lo?a0;K5dP0PE880c=3I00P0h=oS00<00000
0>3Oh`3Pgn<0;03Pgn<03@3<d=T085B20:Je_`3Ph=/0h^;N0>GUhP3Xj>D0
k>cY0>o_k03alNl0]LC@021DPP3<d=T04P3Pgn<00`000000h=oS0000000X
0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS01D0h=oS00/0YKG505Ml
W02Y^L<0iNGQ0>OWh`3Zj^H0k>cY0>o_k02c`ll0G86R0:Fea@0i0>3Oh`0;
0:Fea@1ENYX0Y[Fo0>3Pf`3Rh]h0iNGR0>SXi@3/k>T0//7=05^1X@2U]LD0
?P3Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0
IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`0E0>3Oh`0;0=kNhP2U
]LD085B206J7X`2[^/D0gn7O0:jnb01YRjL085B20:Fea@3Ng^80>@3Pgn<0
2`3Ng^80YKG5021DPP1TQZ40YkO10=[LfP2[^/H0J8VV021DPP2U]LD0g]kR
03h0h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<05`3Pgn<01`3<d=T0
UjZn05EjW@0TEh@0EGZM09NZ_P3<d=T0?@3Pgn<01`3<d=T0UjZn05EjW@0T
Eh@0EGZM09NZ_P3<d=T0@03Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3O
h`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn0000
0`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80h=oS00<0W9bN
0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn
0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3Oh`0@0>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0
oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS0:80h=oS
00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh0000306IVOP3k
o?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3O
h`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<0
0`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh1
0?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS
0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<00`2LW9h0
oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0
4@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS0100h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3o
ool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40nocm0@1V
IWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0XP3Pgn<0
0`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3oool0h=oS
0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A0>3Oh`03
09bLWP3oool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<106IVOP40
nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?ooo`3Pgn<0
XP3Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IVOP0000<0
IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`2R0>3Oh`0309bLWP3o
ool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0A
0>3Oh`0309bLWP3oool0h=oS0:80h=oS00<0W9bN0?ooo`3Pgn<0403Pgn<1
06IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0140h=oS00<0W9bN0?oo
o`3Pgn<0XP3Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3ko?d106IV
OP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`050>3Oh`@0
00000P3Pgn<020000000h=oS0>3Oh`3Pgn<000000>3Oh`000000h=oS0P00
00020>3Oh`<00000R03Pgn<00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn0@3k
o?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<00`2LW9h0oooo0>3Oh`04
0>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`0000000`3Pgn<0
1@000000h=oS0000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS
000000270>3Oh`0309bLWP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn
00000`1VIWh0nocm06IVOP0A0>3Oh`0309bLWP3oool0h=oS00@0h=oS00<0
00000>3Oh`3Pgn<00P3Pgn<00`000000h=oS000000030>3Oh`050000003P
gn<000000>3Oh`0000001@3Pgn<00`000000h=oS0>3Oh`260>3Oh`0309bL
WP3oool0h=oS0100h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IV
OP0A0>3Oh`0309bLWP3oool0oooo00<0oooo00<0h=oS0000003Pgn<00`3P
gn<00`000000h=oS000000030>3Oh`050000003Pgn<000000>3Oh`000000
0`3Pgn<2000000@0h=oSQ@3oool00`2LW9h0oooo0>3Oh`0@0>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh04@3Pgn<609bLWP030>3Oh`00
0000h=oS00<0h=oS00@000000>3Oh`00000000000P3Pgn<01@000000h=oS
0000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3O
hhH0W9bN00<0oooo0>3Oh`3Pgn<03`3Pgn<106IVOP40nocm0@1VIWh00003
06IVOP3ko?d0IVIn01P0h=oS00<000000>3Oh`3Pgn<00P3Pgn<010000000
h=oS0000003Pgn<200000080h=oS100000020>3Oh`<00000V`3Pgn<106IV
OP40nocm0@1VIWh0000306IVOP3ko?d0IVIn01P0h=oS00<000000>3Oh`3P
gn<00P3Pgn<00`000000h=oS0>3Oh`070>3Oh`030000003Pgn<0h=oS09l0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0H0>3Oh`030000
003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`000000h=oS
0000002Q0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3P
gn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh1
0?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IV
OP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IV
OP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IV
OP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<1
06IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_l
o@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP00
00<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3k
o?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP39
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IV
OP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40
IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0
IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0FP3Pgn=P0:F//Pl0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1J0>3Oh`030:F/
/P3oool0oooo05`0oooo00<0YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn05X0h=oS00<0YJbb0?ooo`3oool0G03o
ool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh0FP3Pgn<00`2U[;80oooo0?ooo`150?ooo`030000003oool0
oooo01@0oooo00<0YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40nocm0@1VIWh0
000306IVOP3ko?d0IVIn04H0h=oS1000000@0>3Oh`030:F//P3oool0oooo
04D0oooo00<000000?ooo`3oool0503oool00`2U[;80h=oS0>3Oh`0=0>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0BP3Pgn<00`000000
h=oS0>3Oh`0=0>3Oh`030:F//P3oool0oooo04D0oooo00<000000?ooo`3o
ool0503oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP00
00<0IVIn0?_lo@1VIWh03`3Pgn<5000000030>3Oh`000000h=oS0080h=oS
00@000000>3Oh`00000000000P3Pgn<300000080h=oS00<000000>3Oh`3P
gn<01@3Pgn<2000000040>3Oh`000000h=oS000000<0h=oS00<000000>3O
h`3Pgn<00`3Pgn<2000000040>3Oh`000000h=oS000000<0h=oS00<00000
0>3Oh`3Pgn<00P000000103Pgn<000000>3Oh`0000020>3Oh`<000000P3P
gn<00`000000h=oS0>3Oh`030>3Oh`030:F//P3oool0oooo04D0oooo0`00
00000`3oool000000?ooo`070?ooo`80000000<0oooo0000003oool01@3o
ool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh03`3Pgn<00`000000h=oS0>3Oh`030>3Oh`070000003Pgn<0
h=oS0>3Oh`000000h=oS000000020>3Oh`070000003Pgn<0h=oS0>3Oh`00
0000h=oS000000060>3Oh`030000003Pgn<0h=oS0080000000<0h=oS0000
003Pgn<00P3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS
0080000000<0h=oS0000003Pgn<00P3Pgn<00`000000h=oS000000020>3O
h`80000000@0h=oS0000003Pgn<000000`3Pgn<00`000000h=oS0>3Oh`05
0>3Oh`030:F//P3oool0oooo04D0oooo00<000000?ooo`3oool00P000003
0?ooo`050000003oool0oooo0?ooo`0000000P3oool2000000H0oooo00<0
YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn00l0h=oS00<000000>3Oh`3Pgn<00`3Pgn<01`000000h=oS0>3Oh`3P
gn<000000>3Oh`0000000P3Pgn<00`000000h=oS0>3Oh`030>3Oh`030000
003Pgn<0h=oS00@0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<00000
00<0h=oS00<000000>3Oh`3Pgn<00P3Pgn<01`000000h=oS0>3Oh`3Pgn<0
00000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`050000003P
gn<000000>3Oh`0000002`3Pgn<00`2U[;80oooo0?ooo`150?ooo`050000
003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
00<0oooo00<000000?ooo`3oool0103oool00`2U[;80h=oS0>3Oh`0=0>3O
h`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh03`3Pgn<00`000000
h=oS0>3Oh`030>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS00000002
0>3Oh`D0000000<0h=oS0000003Pgn<01P3Pgn<4000000030>3Oh`000000
h=oS0080h=oS00<000000>3Oh`3Pgn<00`3Pgn<4000000030>3Oh`000000
h=oS0080h=oS00<000000>3Oh`0000000`3Pgn<010000000h=oS0000003P
gn<5000000L0h=oS00<0YJbb0?ooo`3oool0A@3oool5000000030?ooo`00
0000000000<000000P3oool4000000H0oooo00<0YJbb0>3Oh`3Pgn<03@3P
gn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn00l0h=oS1@000000
0`3Pgn<00000000000020>3Oh`030000003Pgn<000000080h=oS00H00000
0>3Oh`3Pgn<0h=oS0000003Pgn<2000000D0h=oS00H000000>3Oh`3Pgn<0
h=oS0000003Pgn<200000080h=oS00<000000>3Oh`3Pgn<00P3Pgn<01P00
0000h=oS0>3Oh`3Pgn<000000>3Oh`8000000P3Pgn<00`000000h=oS0000
00020>3Oh`80000000@0h=oS0000003Pgn<000000`3Pgn<00`000000h=oS
0>3Oh`050>3Oh`030:F//P3oool0oooo04D0oooo00D000000?ooo`3oool0
oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo0?ooo`040?ooo`030:F//P3Pgn<0h=oS00d0h=oS0@1VIWh10?_l
o@40IVIn00000`1VIWh0nocm06IVOP0?0>3Oh`030000003Pgn<0h=oS00<0
h=oS00D000000>3Oh`00000000000>3Oh`0300000080h=oS0`0000020>3O
h`030000003Pgn<0000000D0h=oS0`0000020>3Oh`040000003Pgn<00000
000000H0h=oS0`0000020>3Oh`040000003Pgn<00000000000<0h=oS0P00
0000103Pgn<000000>3Oh`0000020>3Oh`<000000P3Pgn<00`000000h=oS
0>3Oh`030>3Oh`030:F//P3oool0oooo04D0oooo100000040?ooo`030000
003oool0oooo0080oooo0`0000070?ooo`030:F//P3Pgn<0h=oS00d0h=oS
0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP0?0>3Oh`030000003P
gn<0h=oS00T0h=oS00<000000>3Oh`3Pgn<0;P3Pgn<00`000000h=oS0>3O
h`0;0>3Oh`030:F//P3oool0oooo04D0oooo00<000000?ooo`3oool0503o
ool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn
0?_lo@1VIWh03`3Pgn<5000000L0h=oS00<000000>3Oh`3Pgn<0;P3Pgn<0
0`000000h=oS0>3Oh`0;0>3Oh`030:F//P3oool0oooo04D0oooo00<00000
0?ooo`3oool0503oool00`2U[;80h=oS0>3Oh`0=0>3Oh`40IVIn0@3ko?d1
06IVOP0000<0IVIn0?_lo@1VIWh0FP3Pgn<00`2U[;80oooo0?ooo`150?oo
o`030000003oool0oooo01@0oooo00<0YJbb0>3Oh`3Pgn<03@3Pgn<106IV
OP40nocm0@1VIWh0000306IVOP3ko?d0IVIn05X0h=oS00<0YJbb0?ooo`3o
ool0A@3oool00`000000oooo0?ooo`0D0?ooo`030:F//P3Pgn<0h=oS00d0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP1J0>3Oh`030:F/
/P3oool0oooo04D0oooo00<000000?ooo`3oool0503oool00`2U[;80h=oS
0>3Oh`0=0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0FP3P
gn<00`2U[;80oooo0?ooo`150?ooo`030000003oool0oooo01@0oooo00<0
YJbb0>3Oh`3Pgn<03@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0
IVIn05X0h=oS00<0YJbb0?ooo`3oool0G03oool00`2U[;80h=oS0>3Oh`0=
0>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0FP3Pgn=P0:F/
/Pl0h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40
IVIn0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm
0@1VIWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn0000
0`1VIWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?_l
o@1VIWh0b@3Pgn<106IVOP40nocm0@1VIWh0000306IVOP3ko?d0IVIn0<T0
h=oS0@1VIWh10?_lo@40IVIn00000`1VIWh0nocm06IVOP390>3Oh`40IVIn
0@3ko?d106IVOP0000<0IVIn0?_lo@1VIWh0b@3Pgn<106IVOP40nocm0@1V
IWh0000306IVOP3ko?d0IVIn0<T0h=oS0@1VIWh10?_lo@40IVIn00000`1V
IWh0nocm06IVOP390>3Oh`40IVIn0@3ko?d106IVOP0000<0IVIn0?Ogn@2H
V:L0b@1gMi8109RHY`40moOi0@1VIWh0000306IVOP3gmoT0_;g=0<X0_;g=
0@3gmoT106IVOP0000<0IVIn0?Ogn@3Thn<0bP3Thn<10?Ogn@40IVIn0000
0`1VIWh0l?7d0?ooo`240?ooo`030>CSh`2LY;T0JgF?00<0JgF?00@0K7J@
06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0knk^0<K9d`@0
ZJfi00@0ZZfi0:V]^@2Z[KT0ZZfi2@2Y[KT01P36bM<0knk^0?ooo`3oool0
k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0YcY42@2V>D@00`2LY;T0k>[Z
0?ooo`020?ooo`40l?7d0@1VIWh0000F06IVOP3RhN80nocl0?_ko03ko?d0
o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m0?clo03lno`0o?cl0?_lo03l
o?`0nocm0?cko03lo?d0no_m0?_lo080o?cl00@0o?cm0?clo03knod0o?cm
9P3lno`01P3imoT0jNO]0=OCgP37`]40g=WR0>WWk@@0o?_l<03ko?`;0?_l
o@0309bT^@1[MHl0QHV`0100QHV`00H0JgF?09bT^@3ko?d0nocm0<K9d`2Y
[KTA0;fndP060:V]^@36bM<0no_l0?clo02LY;T0YSU44@2Z?5D01P2V>D@0
W:Bi0?clo03lnod0nocm0>;QhP40IVIn0000101VIWh0h>3Q0?Kgn@3gmoT2
0?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Og
n@3fmoT00P3gmoT0103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0
moOi02@0moOi00P0j^[/09RGW@1:Bdh03Q0@06e^K`2OWj<0al;A0=kKi0<0
moOi<03fmoT;0?Ogn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3g
moT0moOi0:V]^@3;c=XA0<?5e0080<_<fP2Y[KT0moOh0?Kgn@2V>D@0ZSaE
0<9BF`36E5X=0<IEG0080<IDFP32DU/0ZSaE0:HiA03gmoT0moOh0?Ogn@3P
h>4106IVOP0000D0IVIn0=kMh@3alO@0lO7d0?3am00@000000070?7bm03a
lO@0l?;e0?7am03al_@0l?;d0?7am00U0?3am@0808Z<SP1ADU@0c/kD0?3a
m@2n_l803Q0@06QVKP3Cd=/c0?3am@/0l?7d00<0JgF?0;:ed02WZ<80402W
Z<801P2b]M00JgF?0?3am03`lO@0ZJfi0<c>fa40b/_H00D0c<kK0:V]^@3a
l_@0lO7e0:HiA0020<9BF`030<]DF@3=FEh0cEUN00/0cEUN00P0beAI0<9B
F`32DU/0YSU40?3am03alO@0l?;d0=kMh@40IVIn00001P1VIWh0g=_P0>[[
l03Zjo00j^c`00000080inOW0P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0
inOW0P3_knl01@000000j^c_0>[[l03Zjo00j^__0080j^_`00L0j^__0=gL
i@3Ac]X0al;A0=7>fP3Lf^<0i>C[0080j^_`00D0h>3X0=7>fP37`]40eM;M
0>OWk@020>[[l0030>?SjP37`]40al;A00H0j^_`00L0gMcU0<O2d@3Og^H0
gMcU0<O2d@3Ti>/0j^_`0080al;A0P3Zjo020<O2d@0B0=OHg02f]K`0al;A
0<O2d@2g//003Q0@04Y;CP3ShnX0j^_`0>CTj`3Ac]X0h^;Y0>[/l03PhNP0
dLkJ0<O2d@3Edmd0inS]0P3Zk?020=SFh0<0j^c`0P3He^030>[/l080f=KP
6`3Zk?0;0>[[k`0406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk60:b^aP2]
[/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`040:V]^@3@d=`0c/kJ0<k>
fP`0oooo0`3>c]X02@3@d=`0ZJfi0>[[l03Zjo00YSU40<eIGP3;E5T0cEIK
0<iIG`0;0=1JG`060<iIG`3=EU/0beAI0<eIGP2V>D@0j^_`0P3Zjnl10=cK
h040IVIn00002P1VIWh0fMWO0>?UjP3Si>X0hnG[0000002<S8`0g]kN0>OW
i`3Ng]h20>OWi`030<IS003WinL0inOW0080inOW00P0knoW0>o_k`3_knl0
00000>?UjP3Si>X0hnC[0>?UjP80hnCZ0100ShnF04Q9C00>4100CU1B08b>
TP2[Yk@0al;A0>?Uj`2VYZd0ATI:00h@401RHfL0_[_60=[Jh`3SiN/0_;k2
0P0>41060>?Uj`0709>CV@0>4100XJ>W09FFV`0>4100ZjNd0>3Rj00200h@
40060<O2d@3SiN/03Q0@00h@4037`]40Si6D100>41004@1UIfT0_;k20>?U
j`33aLX0B4U<09jKYP3Si>X0YZJ/04I6BP0>4100HV=V0;jkaP3JfN80hnCZ
07EgNP1^KW<0e=;M0080hnCZ00<0MGMj06i^L`3Dd]d00P3Si>X00`1eMgX0
KVic0=CBg@0K0>?TjP/0hnGZ00D0JgF?0;bne02b//X0/[;:0?ooo`0606i]
S`0302DU=P2b//X0/[;:00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ0:V]^@3B
dml20=7Ag0030?ooo`2DU9`0U9BL00T0U9BL0`3AdM`01@3Bdml0ZJfi0>?T
j`3SiNX0YSU40080cEUN00@0d5]P0=ALG`3oool0oooo1`3DG5l20?ooo`09
0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnGZ0>?TjP3SiN/0fMWO0040IVIn0000
0`1VIWh0emSN0=cNiP020=cNiP050000003WinL0inOW0>OWi`3We/h00P3W
inL01@3>N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_00<000000=cMiP3Lg^H0
0P3Lg^D01P3Lg^H0Kg1d04I6BP2a/KT0g=kU0<C6c0803Q0@00L0al;A0:JX
[P0>4100UiBO0:j`]P1<CU00WZ2U0080g=kU00<0C4i@00h@4037`]401@3L
g^D0102EUi/03Q0@0;Nb`02^/;H200h@40060;Nb`03Lg^D03Q0@00h@4037
`]40g=kU0P0>41001037`]40LWAg00h@402a[KX20<O2d@0<0=;Ag03Jfn<0
g=kU04a>D00>4100al;A0:JX[P0>4100UiBO0:j`]P1<CU00WZ2U0P3Lg^D2
079dM`<0g=kU0P1bM7L30=cNi@80LWAg9`3Lg^D01@1[MHl0_l7F0;RicP2h
^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cN
i@3Lg^D0ZJfi0=CFh080e=GN00<0oooo09BDW03DeMh01`3DeMh00`3oool0
U9BL0=CEgP020=CEgP090=CFh02Y[KT0g=kU0=cNiP2V>D@0cEUN0=5JGP3D
GF40DbDP00<0oooo1@3FGf<30?ooo`0905<U803DGF40dEYN0<eIGP2V>D@0
g=kU0=cNiP3Lg^D0emSN0040IVIn00001`1VIWh0eMKM0=GHh03Ff>40eMSP
0000002<S8`00P3WinL01@3W]H@0eUX00=J4003ocP00cV<00080gV/000H0
kkF<0>o_k`3_knl0kno_0000003Ef>020=GHh@050=GGh02RY:X03Q0@09ND
W`3EeMl00P3Fen0200h@40030<O2d@1:C4l03Q0@00D0al;A00@0e]OP00h@
400>4100al;A1@3Fen0200h@40060<O2d@3Cdmd03Q0@00h@4037`]40e]OP
0P0>41001P37`]40e]OP00h@400>4100al;A0<C6cP<03Q0@00@0Ngb10;Nb
`03>c=P0e]OP0P0>41000`37`]40BTa?00h@40050<O2dBT0e]SP2`3Ef>40
1@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?0=GH
h@3Ef>40ZJfi0=OHhP80e]OQ00<0oooo09BDW03Fen401`3Fen400`3oool0
U9BL0=KGh@020=KGh@050=OHhP2Y[KT0eMOQ0=GGh02V>D@00P3EGF000`3H
H640fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@020=EM
H0050:HiA03Ef>40eMOP0=GHh@3Ee]d00@1VIWh0000606IVOP3Be=d0cm;L
0=3Bg03@d]d000000`3WinL0303Wg/h0aTX00?O>003_[@00kkD00<i[0036
FP00aV/00=j<BP3WY@00knO>000000@0d=;L00<0GEmS00h@402l^<H00`3@
d]`200h@40030<O2d@0>41003Q0@00@03Q0@00D0bLKD0=3Bg00>41003Q0@
0<O2d@050=3Bg00407UkP00>4100ZJVc0<W6e0803Q0@00H0al;A0=3Bg00>
41003Q0@0<O2d@3@d]`200h@40090<O2d@1MGf<03Q0@0;6]^P2i^l@03Q0@
06QVKP37`]40d=;L00803Q0@00<0al;A00h@400>4100100>41000`39a]@0
cm;M0<oBg@0W0<oBg@/0d=;L00<0JgF?0<S9f`33a=H04033a=H01P38bM/0
JgF?0=3Bg03@d]`0ZJfi0=[Ki080f]_S00<0oooo09BDW03Jfn<01`3Jfn<0
0`3oool0U9BL0=[Kh`020=[Kh`070=[Ki02Y[KT0cm;L0=3Bg02V>D@0eemO
0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3oool01`167QX0
g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@00P3@d]`10<oBg040d]CM0@1VIWh0
000I06IVOP3@d]/0blgH0<[=f@3;c]P000000>O6[@3WaX`0mlhH0>nm003g
aP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl000000<[>
f@3;cMP0blgI0<[=f@0200h@40030<O2d@3;cMT0blgI00<03Q0@00T0blgI
04M9C@0>4100al;A0<[:e`0>4100ATI:0<W9eP3;cMT00P0>41000`37`]40
blgI0<_=f@040<_=f@0308Z<T`17BDd03Q0@00803Q0@00H0b<OD0<_=f@0>
41003Q0@0<O2d@3:c=P200h@40050<W8e@0>41003Q0@0<O2d@3:bmP00P0>
41003039b=D0blgI00h@400>4100al;A04M9C@0>4100al;A0<[;e`0>4100
ATI:0<W9eRT0blkI2`3;cMP00`1[MHl0blcN0<S:f@080<S:f@030<S9f@38
b]T0b<[I00<0b<[I00@0b<WI0<S:f@3;c=h0JgF?0P3;cMP01P2Y[KT0gMkW
0=cNi@3Lg^D0oooo09BDW0P0g=kU00<0oooo09BDW03Lg^D00P3Lg^D02@3M
g^L0ZJfi0<[=f03:cMT0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN
6P3oool0oooo00<0oooo00T0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO
0:HiA03:c]T00P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0020<G8
e00600000036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD
00020?O60080moOg00<000000<G7e035b=@00P35am@200h@40030<O2d@35
a]@0a<OE00@0a<OE00H0QHRA00h@402MWJP0ZjNd00h@4026QY020<C7e@80
3Q0@0P37`]460<C7e@060<K4dP2g//003Q0@06MWK`35a]@0a<OE0P0>4100
3@2f]L80/:jk00h@401cLg/0aLKD079dO00>4100/:nl0;6]^P0>4100Lg=k
0<K5d`34amD00P0>41001`37`]40QHR@00h@402MWJL0ZjNd00h@4026QXl0
:P34b=@;0<C7e00306]eS`3@dN00bl_L0100bl_L00H0d=7P06]eS`34am@0
a<OD0:V]^@3Ph>T20=kNi`030?ooo`2DU9`0g]kW00L0g]kW00<0oooo09BD
W03Ng^L00P3Ng^L01`3Ph>T0ZJfi0<C7e035b=D0YSU40=]TI03OIF@01@3P
JVP01@167QX0oooo0?ooo`3oool0AQhJ00D0h6YX00<0gfET0=]TI02V>D@0
0P34b=@10<G7e@40cloJ0@1VIWh0000606IVOP3<c]X0`/CB0<74d@31a=80
00000`3WinL03@3FQ000kkD00>NU003WY@00eX@00<i[003W[@00mkD00?Nm
003_knl0moOg00000032a=800`31a=80101GFEl03Q0@0;bhaP34`m460<74
d@0408>6SP0>41003Q0@08>6SP80`LCA100>41060<74d@0505MIG`0>4100
3Q0@071cNP2a]<000P31a=401P0>4100NWf504A6BP0>4100L7=j0;6d`080
`LCA00D0L7=j00h@4014ATX0IFM^09:EW`020<74d@803Q0@00<0al;A0<74
dP23QXl00P0>41000`23QXl0`LCB0<74dP0Y0<74dP/0`/CB00<0JgF?0=?C
hP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80ZJfi0>;RjP80hN7W00<0
oooo09BDW03QhNL01`3QhNL00`3oool0U9BL0>7Qi`020>7Qi`070>;RjP2Y
[KT0`LCA0<74dP2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T01`3QJFD0
ffAT0:HiA032a=40`LCA0<74dP3<c]X00@1VIWh0000:06IVOP3:c=P0_/3?
0;g0c`2n`<h0000009bLW03WinL0imkF0=J<0080gY@000@0eW/00<IS002m
@P00kjD00P3g[@00303g]@00oli:0000002n`<l0_/3>0;k0c`2n`<h0RH^E
00h@402TX:`0a/7@0<?1c`80_/3>0P35`M080;k0cP803Q0@00<0a/7@0;k0
cP2n`<h06P2n`<h200h@40030<O2d@2m`<h0_L3>02h0_L3>2`2n`<h00`1[
MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0cP2Y[KT0i>C[0P3S
hnP00`3oool0U9BL0?ooo`080?ooo`0609BDW03ShnP0hn?X0>?Sj03Ti>/0
ZJfi0P2n`<h00`2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3o
ool0oooo103SK6`00`3QJVX0h6IU0:HiA0020;k0c`40_/3>0@3:c=P106IV
OP0000H0IVIn0<W:f02f^<P0^Kc;0;Zlb`0000020>o_k`0=0=JL003FS000
gY@00=J4003_Y@00gX`00;eJ003FL`00ki`00?O_i`3gmoL0oooo00000002
0;Vlc00;0;Zkc02i_</0/;;00494B@13A4T0XYn/0<K1d037`]40ShbG079a
N@31_ll0202i_<`00`25R9<0E5IM0;Vlc00L0;Vlc0803Q0@00<0a/7@0;Zl
c02j_<`0;P2j_<`;0;Zlb`0306]eS`3Hf>D0dm?Q0100dm?Q00H0f=SU06]e
S`2j_</0^[c;0:V]^@3Vi^d20>;Rj@030?ooo`2h]lP0^;O800P0^;O800H0
U9BL0>;Rj@3Rh^T0h^;Y0>KVk@2Y[KT20;Zlc0060:HiA03PJFP0hFe/0>Aa
K@3TLFl0i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^00P0i75]
0>5]K03PJFP0YSU40;Zkc02i_</0][S80<W:f040IVIn0000201VIWh0alWG
0;Bfa`2f^<P0][S900000024Q8@0inON0P3_knl01`36J`00mlH00>ne003_
W000gX`00<i[003WW0000`3gmoL02@000000][S90;Jib@2g^<T0][W90;Ni
b@2/[[h0O7j90453B00200h@400307AeP02MWjd0]kS902L0]kS900<0Jfaf
0453B02g^<T0<02f^<T;0;Nhb@0406]eS`3Fe^@0f=SU0=SHiP<0f=SU1@3H
f>H30=SHi@80f=SV0P3Hf>D01P3Fe^@0JgF?0;Nhb@2g^<T0ZJfi0>KVk@80
iNG/00<0oooo0;Rgb02h]lP0202h]lP03@2DU9`0iNG/0>GUk03UiN`0i^K]
0:V]^@2g^LT0][W90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0
i7A_0>AdK`3TM6l0AQhJ00<0oooo00T0i7A_0>MaK`3TM6l0i6i]0:HiA02f
^<T0][W90;Bfa`37bML00@1VIWh0000306IVOP36b=L0];K70080];K700<0
00000>o_k`3_knl00P3_knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3N
U3T0kmJe0?ogm`3oool000000780];K700D0JgF?0=GEh`3LfnL0g=_W0=gK
i`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`2Y[KT0iNG/0`3Wind;09BDW0<0
inO]00T0iNG/0:V]^@2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3o
ool00`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0
igEb0>McK`2V>D@30;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?80080
/K?800H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0
moOg0?Ogm`3_imH0moOg0?ooo`00001b0;6cb00306]eS`3Ee><0h=oZ0100
h=oZ00H0eMCS06]eS`2a/lP0/K?80:V]^@3UiN`A0>WYk`090>GUk02Y[KT0
/K?80;6cb02V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]
UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:Hi
A0030;6cb040a/SG0@1VIWh0000306IVOP36b=L0^;O?0080[jk700H00000
0>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg
00<0oooo0000002_[/L0L@2_[/L00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[
l`1[MHl0[jk70:n^a`2Y[KT0m??g4@3`ko@06@3dloL0ZJfi0:n^a`2_[/L0
YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/
]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@00P2_[/L1
0;Rgc`40a/SG0@1VIWh0000306IVOP30`M40alOD0080[:_400D000000:f]
[@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3oool00`000000[:_40:b[a01`
0:b[a00306]eS`3BdN<0l_7g0100l_7g00H0d]7S06]eS`2/Zl@0[:_40:V]
^@3QhNTA0??bmP060>7Qj@2Y[KT0[:_40:b[a02V>D@0m8Ym0P3eT8D=0?:h
WP80mI2500H0m8Ym0:HiA02/Zl@0[:_40<O7e030`M4106IVOP0000@0IVIn
0<31d@3Bd]l0]KC9P`2TXkh01024S:80JgF?0<c;g@3kno`=0?ooo`040?_k
o03<bmd0JgF?08B<XP80Y:>n00@0]k_40:V]^@3QhNT0oOgm3@3oool0103m
oOd0hN7Y0:V]^@2g^l@20:BS_P07096HZP2V>D@0oin=0?joY03jg;L0n^^g
0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf0?[Y]P80nNVf00X0n^^g0?[L]`3n
_j@0oin=0:HiA02AV:X0Y:>n0;Fdb@3Bd]l0`<7A0@1VIWh0000606IVOP2X
Ykl0i^K]0=;Bh02l_<l0/K34PP2XYkl00`24S:80JgF?06]eS`0?06]eS`03
08B<XP2XYkl0Z:No0080Z:No00<0]k_40:V]^@2Y[KT03`2Y[KT00`2g^l@0
Z:No0:RW_`020:RW_`0308B<XP2V>D@0YSU400l0YSU400H0Q8bR0;6`a02l
_<l0d];P0>KVk@2XYkl106IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@
d>00b/[J0<40_;c?00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ000
00P0F5MX06IVOP2EU:/0emSR0?clo03blO<0k>_^0>7Rjkl0emSR00L0hN;[
0>c[kP3blO<0o?cl0=OHhP2EU:/0IVIn0040F5MX000205QGJ00306IVOP2E
U:/0dM7N0080o?cl`@3oool20?clo0030=7AgP2EU:/0IVIn0080F5MX0003
05QGJ080IVIn00<0R8NM09FDZ`2XYkl0`02XYkl0102EU:/0R8NM06IVOP1V
IWh305QGJ0001@1HEfS506IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[6]:=",
  Evaluatable->False,
  ImageSize->{207, 176},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Properties"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[6]=",
  CellTags->"Properties"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[
      ref\ @\ PropertyValue[{"\<inputField\>", \ "\<text\>"}]]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \(2\ a\)], "Output",
  CellLabel->"Out[7]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ToExpression[ref\ @\ PropertyValue[{"\<inputField\>", \ "\<text\>"}], \ 
      StandardForm, \ Hold]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \(Hold[a + a]\)], "Output",
  CellLabel->"Out[8]="]
}, Open  ]],

Cell[TextData[{
  "Any widget values that automatically have equivalent ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expressions as defined by ",
  StyleBox["J/Link",
    FontSlant->"Italic"],
  " can be returned or set using the standard ",
  StyleBox["PropertyValue", "Output"],
  " function."
}], "Text",
  CellTags->"Properties"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\ @\ PropertyValue[{"\<inputField\>", \ "\<visible\>"}]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"Properties"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[9]="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GUI Lifecycles", "Section",
  CellTags->"Lifecycles"],

Cell[TextData[{
  "Normally a live ",
  StyleBox["GUIObject", "Program"],
  " instance will shut down and dispose of itself through the normal user \
action of closing a window or other interface widget that performs the \
equivalent user interface closure. Sometimes, however, it is convenient to \
programmatically close a live modeless interface.  You can use ",
  StyleBox["CloseGUIObject", "Program"],
  " on an active ",
  StyleBox["GUIObject", "Program"],
  " instance to initiate a close action."
}], "Text",
  CellTags->"Lifecycles"],

Cell[TextData[{
  "Note that ",
  StyleBox["CloseGUIObject", "Program"],
  " only initiates a close request on the active interface and will not \
necessarily force the removal of all interface resources like ",
  StyleBox["ReleaseGUIObject", "Output"],
  " if an initial ",
  StyleBox["GUIRun", "Output"],
  " has requested the interface live on past its closing by using the option \
",
  StyleBox["ReleaseMethod -> Manual.", "Output"],
  " If you want to ensure the original lifecyle intent of a ",
  StyleBox["GUIRun", "Program"],
  " call, it is recommended that you use ",
  StyleBox["CloseGUIObject", "Program"],
  " instead of ",
  StyleBox["ReleaseGUIObject", "Program"],
  ", since this will still close and possibly remove all resources associated \
with an interface if ",
  StyleBox["ReleaseMethod -> Automatic", "Output"],
  " was used or also allow the interface to live on if ",
  StyleBox["ReleaseMethod -> Manual", "Output"],
  " was used."
}], "Text",
  CellTags->"Lifecycles"],

Cell[BoxData[
    \(\(Needs["\<GUIKit`\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Lifecycles"],

Cell["\<\
Here we create a live user interface object by loading a calculator \
example.\
\>", "Text",
  CellTags->"Lifecycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ GUIRun["\<Wolfram/Example/Calculator\>"]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Lifecycles"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject180685885145089, 
        JLink`Objects`JavaObject471665540595713]]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Lifecycles"]
}, Open  ]],

Cell[TextData[{
  "We can verify this user interface is active even if not displayed using ",
  StyleBox["GUIObjectQ", "Program"],
  "."
}], "Text",
  CellTags->"Lifecycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIObjectQ[ref\ ]\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Lifecycles"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Lifecycles"]
}, Open  ]],

Cell[TextData[{
  "Instead of closing the active window with the mouse, we programmatically \
request the window close using ",
  StyleBox["CloseGUIObject", "Program"],
  "."
}], "Text",
  CellTags->"Lifecycles"],

Cell[BoxData[
    \(CloseGUIObject[ref\ ]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Lifecycles"],

Cell[TextData[{
  "We now see that ",
  StyleBox["GUIObjectQ", "Output"],
  " correctly reports this user interface, and its runtime representation as \
a ",
  StyleBox["GUIObject", "Program"],
  " is no longer valid because ",
  StyleBox["GUIRun", "Program"],
  " was initiated with the default ",
  StyleBox["Automatic", "Program"],
  " release method."
}], "Text",
  CellTags->"Lifecycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIObjectQ[ref\ ]\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"Lifecycles"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[5]=",
  CellTags->"Lifecycles"]
}, Open  ]],

Cell[TextData[{
  "Here we request instead that the definition should still stay active after \
it is closed using the ",
  StyleBox["ReleaseMethod", "Output"],
  " option."
}], "Text",
  CellTags->"Lifecycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ 
      GUIRun["\<Wolfram/Example/Calculator\>", \ 
        ReleaseMethod \[Rule] Manual]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"Lifecycles"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject180685885145089, 
        JLink`Objects`JavaObject471665540595713]]], "Output",
  CellLabel->"Out[6]=",
  CellTags->"Lifecycles"]
}, Open  ]],

Cell[TextData[{
  "Instead of closing the active window with the mouse, we programmatically \
request the window close using ",
  StyleBox["CloseGUIObject", "Program"],
  "."
}], "Text",
  CellTags->"Lifecycles"],

Cell[BoxData[
    \(CloseGUIObject[ref\ ]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"Lifecycles"],

Cell[TextData[{
  "Here we see that ",
  StyleBox["GUIObjectQ", "Output"],
  " correctly reports that this definition is still active because of the \
initial ",
  StyleBox["Manual", "Output"],
  " release method."
}], "Text",
  CellTags->"Lifecycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIObjectQ[ref\ ]\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"Lifecycles"],

Cell[BoxData[
    \(True\)], "Output",
  CellLabel->"Out[8]=",
  CellTags->"Lifecycles"]
}, Open  ]],

Cell[TextData[{
  "We can force complete termination of the interface using ",
  StyleBox["ReleaseGUIObject", "Program"],
  "."
}], "Text",
  CellTags->"Lifecycles"],

Cell[BoxData[
    \(ReleaseGUIObject[ref\ ]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"Lifecycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIObjectQ[ref\ ]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"Lifecycles"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[10]=",
  CellTags->"Lifecycles"]
}, Open  ]],

Cell[TextData[{
  "If we decided that we wanted to dispose of an active modeless interface \
either before or after it is already displayed, we can use ",
  StyleBox["ReleaseGUIObject", "Output"],
  " to force shutdown and remove all resources allocated to the running user \
interface."
}], "Text",
  CellTags->"Lifecycles"],

Cell[TextData[{
  "Here we gain access to the ",
  StyleBox["GUIObject", "Output"],
  " associated with an interface created in a modeless session."
}], "Text",
  CellTags->"Lifecycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ GUIRun["\<Wolfram/Example/AngleDialog\>"]\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"Lifecycles"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject180685885145089, 
        JLink`Objects`JavaObject471665540595713]]], "Output",
  CellLabel->"Out[11]=",
  CellTags->"Lifecycles"]
}, Open  ]],

Cell[TextData[{
  "Once we call ",
  StyleBox["ReleaseGUIObject", "Output"],
  ", the interface is closed just as if the user themselves closed the user \
interface through normal interaction."
}], "Text",
  CellTags->"Lifecycles"],

Cell[BoxData[
    \(ReleaseGUIObject[ref]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"Lifecycles"],

Cell[TextData[{
  "We see that the resources and ",
  StyleBox["JavaObjects", "Output"],
  " associated with the user interface are now cleared."
}], "Text",
  CellTags->"Lifecycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"Lifecycles"],

Cell[BoxData[
    RowBox[{"GUIObject", "[", 
      RowBox[{
        TagBox[\(Removed["JavaObject75641856720897"]\),
          False,
          Editable->False], ",", 
        TagBox[\(Removed["JavaObject239886523170817"]\),
          False,
          Editable->False]}], "]"}]], "Output",
  CellLabel->"Out[13]=",
  CellTags->"Lifecycles"]
}, Open  ]],

Cell[TextData[{
  "We can also use the ",
  StyleBox["GUIObjectQ", "Program"],
  " function to determine a live ",
  StyleBox["GUIObject", "Program"],
  " reference from one that is now shut down."
}], "Text",
  CellTags->"Lifecycles"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIObjectQ[ref]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"Lifecycles"],

Cell[BoxData[
    \(False\)], "Output",
  CellLabel->"Out[14]=",
  CellTags->"Lifecycles"]
}, Open  ]],

Cell[TextData[{
  "However, it is probably more appropriate to use ",
  StyleBox["CloseGUIObject", "Output"],
  " to only initiate the close action on the active interface. The reason for \
this is that ",
  StyleBox["GUIRun", "Output"],
  " supports the option ",
  StyleBox["ReleaseMethod->Manual", "Output"],
  " to allow you to reuse a live definition even after it is closed and \
reopened."
}], "Text",
  CellTags->"Lifecycles"],

Cell[TextData[{
  "A common useful technique that takes advantage of the ",
  StyleBox["ReleaseMethod->Manual", "Output"],
  " option of ",
  StyleBox["GUIRun", "Output"],
  " is to define and use a single copy of a definition throughout a single \
kernel session, automatically handling the initial creation, as well as \
redisplaying it if it has happened to be closed manually by a user. The \
following 'wrapper' function for requesting a specific interface definition \
supports all these concepts nicely, where ",
  StyleBox["\"Wolfram/Example/PrimeFinder\"", "Output"],
  " represents the path to the definition you are interested in."
}], "Text",
  CellTags->"Lifecycles"],

Cell[BoxData[
    \(SingletonDialog[] := \((\[IndentingNewLine]If[\(! \
GUIObjectQ[$SingletonDialogObject]\), $SingletonDialogObject\  = 
            GUILoad["\<Wolfram/Example/PrimeFinder\>"]]; 
        GUIRunModal[$SingletonDialogObject, 
          ReleaseMethod \[Rule] Manual]\[IndentingNewLine])\)\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"Lifecycles"],

Cell[BoxData[
    \(SingletonDialog[]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"Lifecycles"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Building GUIs", "Chapter",
  CellTags->"DevelopingIntro"],

Cell["\<\
This section discusses developing new interfaces and the basic expressions \
that make up interface definitions.\
\>", "Text",
  CellTags->"DevelopingIntro"],

Cell[TextData[{
  "It may be useful to view the source code of many of the example interfaces \
as a way of learning how you can construct common dialogs, windows, and \
controls. These examples can be found within the installation of the ",
  StyleBox["GUIKit`", "Output"],
  " AddOn in the subdirectory ",
  StyleBox["\"GUIKit/GUI/Wolfram/Example/*\"", "Output"]
}], "Text",
  CellTags->"DevelopingIntro"],

Cell[TextData[{
  "The following slide show provides an introduction that you might find \
useful when building your own interface defintions with ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellTags->"DevelopingIntro"],

Cell[TextData[{
  ButtonBox["Building with ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "GUIKitBuildingSlideShow.nb"], ""},
    ButtonStyle->"PageLink"],
  StyleBox[ButtonBox["GUIKit ",
    ButtonData:>{
      FrontEnd`FileName[ {}, "GUIKitBuildingSlideShow.nb"], ""},
    ButtonStyle->"PageLink"],
    FontSlant->"Italic"],
  ButtonBox["Slide Show",
    ButtonData:>{
      FrontEnd`FileName[ {}, "GUIKitBuildingSlideShow.nb"], ""},
    ButtonStyle->"PageLink"]
}], "Text",
  CellTags->"DevelopingIntro"],

Cell[CellGroupData[{

Cell["Definition Building Blocks", "Section",
  CellTags->"BuildingBlocks"],

Cell[TextData[{
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " definitions are defined as a hierarchy of widgets, whether they are \
defined in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression format or in the XML format, GUIKitXML.  A single \
self-contained user interface definition should always begin with an \
outermost user interface widget--either an instance of a window or frame. The \
",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " framework also optionally provides an appropriate top-level window \
wrapper if the root interface definition widget is at least a user interface \
class that can live inside a window or frame, so you are not actually \
required to always use a top-level frame or window widget. This is convenient \
because it allows you to write reusable complex widgets by designing them \
with the root widget as ",
  StyleBox["Widget[\"Panel\"]", "Program"],
  ". This could be run by itself or reused as content in other developer\
\[CloseCurlyQuote]s  window definitions. Examples of reusing panel-designed \
higher-level widgets  exist in subsequent documentation sections."
}], "Text",
  CellTags->"BuildingBlocks"],

Cell[TextData[{
  "A ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " definition expression consists of a hierarchy of widget expressions."
}], "Text",
  CellTags->"BuildingBlocks"],

Cell[BoxData[
    RowBox[{
      StyleBox["Widget",
        FontWeight->"Bold"], 
      StyleBox["[",
        FontWeight->"Plain"], 
      RowBox[{
        StyleBox[\("path/Frame"\  | \ "class:className"\),
          "Output",
          FontWeight->"Plain"], 
        StyleBox[",",
          "Output",
          FontWeight->"Plain"], 
        StyleBox[" ",
          "Output",
          FontWeight->"Plain"], 
        RowBox[{
          StyleBox["{",
            "Output",
            FontWeight->"Plain"], 
          StyleBox["\n",
            "Output",
            FontWeight->"Plain"], 
          StyleBox["   ",
            "Output",
            FontWeight->"Plain"], 
          RowBox[{
            RowBox[{
              StyleBox["Widget",
                FontWeight->"Bold"], 
              StyleBox["[",
                "Output",
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox["\<\"path/Button\"\>",
                  "Output",
                  FontWeight->"Plain"], 
                StyleBox[",",
                  "Output",
                  FontWeight->"Plain"], 
                StyleBox[" ",
                  "Output",
                  FontWeight->"Plain"], 
                RowBox[{
                  StyleBox["{",
                    "Output",
                    FontWeight->"Plain"], 
                  StyleBox["\n",
                    "Output",
                    FontWeight->"Plain"], 
                  StyleBox["        ",
                    "Output",
                    FontWeight->"Plain"], 
                  RowBox[{
                    StyleBox["BindEvent",
                      "Output",
                      FontWeight->"Bold"], 
                    StyleBox["[",
                      "Output",
                      FontWeight->"Plain"], 
                    RowBox[{
                      StyleBox["\<\"event name\"\>",
                        "Output",
                        FontWeight->"Plain"], 
                      StyleBox[",",
                        "Output",
                        FontWeight->"Plain"], 
                      StyleBox[" ",
                        "Output",
                        FontWeight->"Plain"], 
                      RowBox[{
                        StyleBox["Script",
                          "Output",
                          FontWeight->"Bold"], 
                        StyleBox["[",
                          "Output",
                          FontWeight->"Plain"], 
                        StyleBox["expr",
                          "Output",
                          FontWeight->"Plain"], 
                        StyleBox["]",
                          "Output",
                          FontWeight->"Plain"]}]}], 
                    StyleBox["]",
                      "Output",
                      FontWeight->"Plain"]}], 
                  StyleBox["\n",
                    "Output",
                    FontWeight->"Plain"], 
                  StyleBox["        ",
                    "Output",
                    FontWeight->"Plain"], 
                  StyleBox["}",
                    "Output",
                    FontWeight->"Plain"]}], 
                StyleBox[",",
                  "Output",
                  FontWeight->"Plain"], 
                StyleBox[" ",
                  "Output",
                  FontWeight->"Plain"], 
                StyleBox[\(Name \[Rule] \ "button obj"\),
                  "Output",
                  FontWeight->"Plain"]}], 
              StyleBox["]",
                "Output",
                FontWeight->"Plain"]}], 
            StyleBox[",",
              "Output",
              FontWeight->"Plain"], 
            StyleBox["\n",
              "Output",
              FontWeight->"Plain"], 
            StyleBox["   ",
              "Output",
              FontWeight->"Plain"], 
            RowBox[{
              StyleBox["Script",
                "Output",
                FontWeight->"Bold"], 
              StyleBox["[",
                "Output",
                FontWeight->"Plain"], 
              StyleBox["\n",
                "Output",
                FontWeight->"Plain"], 
              StyleBox["      ",
                "Output",
                FontWeight->"Plain"], 
              RowBox[{
                StyleBox["expr",
                  "Output",
                  FontWeight->"Plain"], 
                StyleBox[";",
                  "Output",
                  FontWeight->"Plain"], 
                StyleBox["\n",
                  "Output",
                  FontWeight->"Plain"], 
                StyleBox["      ",
                  "Output",
                  FontWeight->"Plain"], 
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["Widget",
                        FontWeight->"Bold"], 
                      StyleBox["Reference",
                        "Output",
                        FontWeight->"Bold"]}]], 
                  StyleBox["[",
                    "Output",
                    FontWeight->"Plain"], 
                  StyleBox["\<\"model obj\"\>",
                    "Output",
                    FontWeight->"Plain"], 
                  StyleBox["]",
                    "Output",
                    FontWeight->"Plain"]}]}], 
              StyleBox["\n",
                "Output",
                FontWeight->"Plain"], 
              StyleBox["      ",
                "Output",
                FontWeight->"Plain"], 
              StyleBox["]",
                "Output",
                FontWeight->"Plain"]}]}], 
          StyleBox["\n",
            "Output",
            FontWeight->"Plain"], 
          StyleBox["   ",
            "Output",
            FontWeight->"Plain"], 
          StyleBox["}",
            "Output",
            FontWeight->"Plain"]}], 
        StyleBox[",",
          "Output",
          FontWeight->"Plain"], 
        StyleBox[" ",
          "Output",
          FontWeight->"Plain"], 
        StyleBox[\(Name\  \[Rule] \ "root frame"\),
          "Output",
          FontWeight->"Plain"]}], 
      StyleBox["]",
        FontWeight->"Plain"]}]], "Output",
  CellFrame->True,
  CellDingbat->None,
  CellEditDuplicate->False,
  GeneratedCell->False,
  CellAutoOverwrite->False,
  CellTags->"BuildingBlocks"],

Cell["\<\
Some of the building blocks that make up a user interface definition include \
the following.\
\>", "Text",
  CellTags->"BuildingBlocks"],

Cell["Request the creation of a new widget instance.", "Text",
  CellTags->"BuildingBlocks"],

Cell[BoxData[
    RowBox[{
      StyleBox["Widget",
        CellFrame->True,
        FontWeight->"Plain"], 
      StyleBox["[",
        "Output",
        CellFrame->True,
        FontWeight->"Plain"], 
      RowBox[{
        StyleBox[\("\<path\>"\  | \ "\<class:className\>"\),
          "Output",
          CellFrame->True,
          FontWeight->"Plain"], 
        StyleBox[",",
          "Output",
          CellFrame->True,
          FontWeight->"Plain"], 
        RowBox[{
          StyleBox["{",
            "Output",
            CellFrame->True,
            FontWeight->"Plain"], 
          StyleBox[\(definitions\ and\ child\ widgets\),
            "Output",
            CellFrame->True,
            FontWeight->"Plain",
            FontSlant->"Italic"], 
          StyleBox["}",
            "Output",
            CellFrame->True,
            FontWeight->"Plain"]}], 
        StyleBox[",",
          "Output",
          CellFrame->True,
          FontWeight->"Plain"], 
        StyleBox[" ",
          "Output",
          CellFrame->True,
          FontWeight->"Plain"], 
        StyleBox[\(Name\  \[Rule] \ "\<myName\>"\),
          "Output",
          CellFrame->True,
          FontWeight->"Plain"]}], 
      StyleBox["]",
        "Output",
        CellFrame->True,
        FontWeight->"Plain"]}]], "Input",
  CellDingbat->None,
  CellTags->"BuildingBlocks"],

Cell[TextData[{
  StyleBox["Reference an existing widget previously registered using the ",
    FontWeight->"Plain"],
  StyleBox["Name", "Output",
    FontWeight->"Plain"],
  StyleBox[" option. ",
    FontWeight->"Plain"]
}], "Text",
  CellDingbat->None,
  CellTags->"BuildingBlocks"],

Cell[BoxData[
    StyleBox[\(WidgetReference["\<myName\>"]\),
      "Output",
      FontWeight->"Plain"]], "Input",
  CellDingbat->None,
  CellTags->"BuildingBlocks"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" scripting code blocks contain arbitrary ",
    FontWeight->"Plain"],
  StyleBox["Mathematica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" programming code executed within the context of the user \
interface instance with access to the widget objects defined in the user \
interface. ",
    FontWeight->"Plain"]
}], "Text",
  CellDingbat->None,
  CellTags->"BuildingBlocks"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox["Script",
          "Output",
          FontWeight->"Plain"], 
        StyleBox["[",
          "Output",
          FontWeight->"Plain"], 
        StyleBox["expr",
          "Output",
          FontWeight->"Plain",
          FontSlant->"Italic"], 
        StyleBox["]",
          "Output",
          FontWeight->"Plain"]}], 
      StyleBox[" ",
        FontWeight->"Plain"]}]], "Input",
  CellDingbat->None,
  CellTags->"BuildingBlocks"],

Cell[TextData[{
  StyleBox["Event binding provides triggers for ",
    FontWeight->"Plain"],
  StyleBox["Mathematica",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" code to execute when certain events happen within the user \
interface.",
    FontWeight->"Plain"]
}], "Text",
  CellDingbat->None,
  CellTags->"BuildingBlocks"],

Cell[BoxData[
    RowBox[{
      StyleBox["BindEvent",
        "Output",
        FontWeight->"Plain"], 
      StyleBox["[",
        "Output",
        FontWeight->"Plain"], 
      RowBox[{
        StyleBox["\"\<eventName\>\"",
          "Output",
          FontWeight->"Plain"], 
        StyleBox[",",
          "Output",
          FontWeight->"Plain"], 
        StyleBox[" ",
          "Output",
          FontWeight->"Plain"], 
        RowBox[{
          StyleBox["Script",
            "Output",
            FontWeight->"Plain"], 
          StyleBox["[",
            "Output",
            FontWeight->"Plain"], 
          StyleBox["expr",
            "Output",
            FontWeight->"Plain",
            FontSlant->"Italic"], 
          StyleBox["]",
            "Output",
            FontWeight->"Plain"]}]}], 
      StyleBox["]",
        "Output",
        FontWeight->"Plain"]}]], "Input",
  CellDingbat->None,
  CellTags->"BuildingBlocks"],

Cell[TextData[StyleBox["Set or get the state and values of live widgets in \
the interface.",
  FontWeight->"Plain"]], "Text",
  CellDingbat->None,
  CellTags->"BuildingBlocks"],

Cell[BoxData[{
    StyleBox[\(\(SetPropertyValue[{"\<widgetName\>", "\<propertyName\>"}, \ 
            val]\ \ or\ \ \ {"\<widgetName\>", \ "\<propertyName\>"}\  \
\[Rule] \ val\)\(\ \ \)\),
      "Output",
      FontWeight->"Plain"], "\n", 
    StyleBox[\(PropertyValue[{"\<widgetName\>", \ "\<propertyName\>"}]\),
      "Output",
      FontWeight->"Plain"], "\n", 
    StyleBox[\(PropertyValue[{"\<widgetName\>", \ "\<propertyName\>", \ 
          index}]\),
      "Output",
      FontWeight->"Plain"]}], "Input",
  CellDingbat->None,
  CellTags->"BuildingBlocks"],

Cell[TextData[{
  "There is an equivalent set of XML elements that define a user interface \
definition analogous to the previous ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " building block expressions."
}], "Text",
  CellTags->"BuildingBlocks"],

Cell[CellGroupData[{

Cell["Widget Layout", "Subsection",
  CellTags->"LayoutIntro"],

Cell[TextData[{
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " definitions are defined as a hierarchy, a \[OpenCurlyDoubleQuote]tree\
\[CloseCurlyDoubleQuote] expression, of  widgets, but at the same time the \
definition\[CloseCurlyQuote]s nesting structure and list  depth also \
determines how the widgets will visually lay themselves out at runtime. The \
goal of the layout rules is to make the most common and useful forms easy to \
represent in the definition, and at the same time provide the necessary \
optional rules to allow for finer control over the layout.  Additionally, the \
layout rules follow familiar ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  list structures and do not require knowledge of the underlying Java \
rendering implementation layout APIs. This high-level abstraction of \
determining layout provides a simple, immediate, and intuitive layout as well \
as the necessary dynamic layout resizing features that all modern user \
interface dialogs are expected to adhere to when resized."
}], "Text",
  CellTags->"LayoutIntro"],

Cell[BoxData[
    \(\(Needs["\<GUIKit`\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"LayoutIntro"],

Cell[TextData[{
  "One can achieve a majority of the desired layout appearance of interface \
definitions by simply nesting widget expressions within other widget \
expressions and choosing the desired level of ",
  StyleBox["{...}", "Output"],
  " nesting to determine the resulting automatic vertical or horizontal \
grouping."
}], "Text",
  CellTags->"LayoutIntro"],

Cell[TextData[{
  "The following basic heuristics are followed in the ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " widget layout system. "
}], "Text",
  CellTags->"LayoutIntro"],

Cell[TextData[{
  "\[FilledSmallSquare] The outermost, top-level, list of widgets, ",
  StyleBox["children",
    FontSlant->"Italic"],
  " in ",
  StyleBox["Widget[", "Output"],
  StyleBox["comp", "Text",
    FontSlant->"Italic"],
  StyleBox[", ", "Output"],
  StyleBox["children", "Text",
    FontSlant->"Italic"],
  StyleBox["_List],", "Output"],
  " default to using a vertical (column) layout. \n\[FilledSmallSquare] Each \
subsequent nested list alternates between a horizontal (row) and vertical \
(column) layout.\n\[FilledSmallSquare] Each type of widget has its own \
default horizontal and vertical stretching characteristics.  For example, \
text fields automatically stretch in the horizontal direction but not \
vertically."
}], "FramedBox",
  CellTags->"LayoutIntro"],

Cell["Here are some examples of these default layout features.", "Text",
  CellTags->"LayoutIntro"],

Cell["\<\
By default, a list of children widgets are laid out vertically in a column \
starting from the left edge of the panel.\
\>", "Text",
  CellTags->"LayoutIntro"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
{\[IndentingNewLine]Widget["\<Button\>", {"\<text\>" -> "\<Button A\>"}], \
\[IndentingNewLine]Widget["\<Button\>", {"\<text\>" -> "\<Button B\>"}], \
\[IndentingNewLine]Widget["\<Button\>", {"\<text\>" -> "\<Button C\>"}]\ }\
\[IndentingNewLine]]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"LayoutIntro"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"LayoutIntro"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000KB000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3Qh>@0
i^GX0>c[kP3`l?80l_;d03D0lo?d<P3hmoP20??cm0080??cm@3dm?D0mOGf
0?Ccm@3Ui>P0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn
0=kLg`3Th^00NiN]02EGQF/003ad00L05den06^;YP3blNh0l_7c06IVOP2X
ZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0f]SI06J5X@1:LI<0
/[g3J`36aML01`30a/D0B6j@06Z:Y03_ko40IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP3HeMH05den0;o7bP1]0<K5e`060;Jm_@0G
CGh0jn[]06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3I
eMD003ad0?ooo`1]0<g<g`060?ooo`00?7@0j>OZ06IVOP2XZK/0nocm0@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`1]0=;Ai0060?oo
o`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3IeMD003ad0?ooo`1]0=KGi`060?ooo`00?7@0inKY06IVOP2XZK/0nocm
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0R0=WJi`D0
00000`3If^L2000000030=WJi`000000fM[W0080000000<0fM[W00000000
00000P3If^L300000080fM[W00D000000=WJi`3If^L0fM[W000000060=WJ
i`<00000903If^L01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool08P3If^L00`000000fM[W
0=WJi`020=WJi`030000003If^L000000080fM[W0P0000001@3If^L00000
0=WJi`3If^L000000080fM[W00L000000=WJi`3If^L0fM[W0000003If^L0
000000<0fM[W00<000000=WJi`3If^L00`3If^L01@000000fM[W0=WJi`3I
f^L0000002<0fM[W00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo0280g]o/00<000000=kO
k03Ngn`00P3Ngn`00`000000g]o/000000030=kOk0030000003Ngn`00000
0080g]o/00@000000=kOk03Ngn`000000`3Ngn`00`000000g]o/00000003
0=kOk0030000003Ngn`0g]o/0080g]o/00<000000=kOk03Ngn`09P3Ngn`0
1P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY
^`1VIWh0fMGE000lM03oool08P3SiO000`000000hnG`0>?Ul0020>?Ul003
0000003SiO00000000<0hnG`00<000000>?Ul00000000P3SiO0010000000
hnG`0>?Ul00000030>?Ul0030000003SiO00000000<0hnG`00<000000>?U
l03SiO000P3SiO000`000000hnG`0>?Ul00V0>?Ul0060?ooo`00?7@0inKY
06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad
0?ooo`0R0>W[m@D000000P3YjoD01`000000jN_e0>W[m@3YjoD000000>W[
m@0000000P3YjoD010000000jN_e0>W[m@0000030>W[m@040000003YjoD0
000000000080jN_e00<000000>W[m@3YjoD00P3YjoD00`000000jN_e0>W[
m@0V0>W[m@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0R0?3ao0030000003`lO`0l?7l
0080l?7l00<000000?3ao00000000`3`lO`700000080l?7l0`0000020?3a
o0040000003`lO`00000000000D0l?7l00<000000?3ao03`lO`09P3`lO`0
1P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY
^`1VIWh0fMGE000lM03oool08P3dmOd00`000000m?Gm0?Ceo@020?Ceo@03
0000003dmOd0m?Gm00D0m?Gm00@000000?Ceo@3dmOd000004P3dmOd01@00
0000m?Gm0?Ceo@3dmOd0000002<0m?Gm00H0oooo000lM03Wi^T0IVIn0:RY
^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo0280
m_Om1@0000080?Kgo@040000003fmod0m_Om000001<0m_Om0`00000T0?Kg
o@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP3IeMD003ad0?ooo`1]0?Slo@060?ooo`00?7@0inKY06IVOP2X
ZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`1]
0?gmo@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP3IeMD003ad0?ooo`1]0?gmo@060?ooo`00?7@0i^KY06IV
OP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3He=@003ad0?oo
o`1]0?gmo@060?ooo`00?7@0iNGX06IVOP2XZK/0nocm0@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP3IeMD09EN50;o>g01]0?ooo`060;o>f`0UEhD0hN7T
06IVOP2XZK/0nocm0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD0NIBY
05EmXP30cme[0?ooo`070=GOj01EOJ80NIF[0=oMh01VIWh0Z:Vk0?_lo@01
06IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=[Gf@3Og=P0NIBY02EGQF/003ad
00L05den06J6X@3Pg]X0g=_M06IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0gmgP0=[Gf@3He=@0=`3Gdm@b0=?>c0<0em?D00L0f=CD
0=WEe@3JemT0gmgP06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY
^`1VIWh0hN3T0>KUj03/jnh0l?3b0?;bm00e0??cm380n?Oh0P3clo@0203c
loD0m?Ce0?GemP3dloD0iNCX06IVOP2XZK/0nocm0@1VIWh0000806IVOP3k
o?d0Z:Vk06IVOP3Ng=l0i>;P07^G[@0UEhE[000lM00701M=OP1[RjH0l_7^
0?;al`1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=[H
f@1VQJ40BW6C0;:m`f/0a/GG00L0`<K504Q^T01ZRZ@0knoa06IVOP2XZK/0
nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0f=GF01M=OP2oalX0K@36
aML01P2f_Kd05den0>_Zk@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm
0:RY^`1VIWh0fMGE000lM03oool0K@3=c=l01P3oool003ad0>SWjP1VIWh0
Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool0
K@3BdN@01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0
nocm0:RY^`1VIWh0fMGE000lM03oool0K@3FenL01P3oool003ad0>OVj@1V
IWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03o
ool08P3If^L5000000<0fM[W0P0000000`3If^L000000=WJi`0200000003
0=WJi`00000000000080fM[W0`0000020=WJi`050000003If^L0fM[W0=WJ
i`000000103If^L5000002@0fM[W00H0oooo000lM03Wi^T0IVIn0:RY^`3k
o?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo0280fM[W
00<000000=WJi`3If^L00P3If^L00`000000fM[W000000020=WJi`800000
00D0fM[W0000003If^L0fM[W000000020=WJi`070000003If^L0fM[W0=WJ
i`000000fM[W000000030=WJi`030000003If^L0fM[W0080fM[W00<00000
0=WJi`3If^L00P3If^L00`000000fM[W0=WJi`0Q0=WJi`060?ooo`00?7@0
inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD0
03ad0?ooo`0R0=kOk0030000003Ngn`0g]o/0080g]o/00<000000=kOk000
00000`3Ngn`00`000000g]o/000000020=kOk0040000003Ngn`0g]o/0000
00<0g]o/00<000000=kOk00000000`3Ngn`00`000000g]o/0=kOk0020=kO
k0030000003Ngn`0g]o/0080g]o/00<000000=kOk03Ngn`08@3Ngn`01P3o
ool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1V
IWh0fMGE000lM03oool08P3SiO000`000000hnG`0>?Ul0020>?Ul0030000
003SiO00000000<0hnG`00<000000>?Ul00000000P3SiO0010000000hnG`
0>?Ul00000030>?Ul0030000003SiO00000000<0hnG`00<000000>?Ul03S
iO000P3SiO000`000000hnG`0>?Ul0020>?Ul0030000003SiO00hnG`0240
hnG`00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn0=WEe@00?7@0oooo0280jN_e1@0000020>W[m@070000003Y
joD0jN_e0>W[m@000000jN_e000000020>W[m@040000003YjoD0jN_e0000
00<0jN_e00@000000>W[m@00000000000P3YjoD00`000000jN_e0>W[m@02
0>W[m@D00000903YjoD01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn
00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool08P3`lO`00`000000
l?7l0?3ao0020?3ao0030000003`lO`0000000<0l?7l1`0000020?3ao0<0
00000P3`lO`010000000l?7l0000000000050?3ao0030000003`lO`0l?7l
0080l?7l00<000000?3ao03`lO`08@3`lO`01P3oool003ad0>OVj@1VIWh0
Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool0
8P3dmOd00`000000m?Gm0?Ceo@020?Ceo@030000003dmOd0m?Gm00D0m?Gm
00@000000?Ceo@3dmOd000004@3dmOd00`000000m?Gm0?Ceo@020?Ceo@03
0000003dmOd0m?Gm0240m?Gm00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d1
06IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo0280m_Om1@00
00080?Kgo@040000003fmod0m_Om00000140m_Om1@00000T0?Kgo@060?oo
o`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3IeMD003ad0?ooo`1]0?Slo@060?ooo`00?7@0inKY06IVOP2XZK/0nocm
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`1]0?gmo@06
0?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP3IeMD003ad0?ooo`1]0?gmo@060?ooo`00?7@0i^KY06IVOP2XZK/0
nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3He=@003ad0?ooo`1]0?gm
o@060?ooo`00?7@0iNGX06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP3IeMD09EN50;o>g01]0?ooo`060;o>f`0UEhD0hN7T06IVOP2X
ZK/0nocm0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD0NIBY05EmXP30
cme[0?ooo`070=GOj01EOJ80NIF[0=oMh01VIWh0Z:Vk0?_lo@0106IVOP00
00P0IVIn0?_lo@2XZK/0IVIn0=[Gf@3Og=P0NIBY02EGQF/003ad00L05den
06J6X@3Pg]X0g=_M06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY
^`1VIWh0gmgP0=[Gf@3He=@0=`3Gdm@b0=?>c0<0em?D00L0f=CD0=WEe@3J
emT0gmgP06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWic
0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWic
0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWic
0>3Oh`0306IVOP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0
hN3T0>KUj03/jnh0l?3b0?;bm00e0??cm380n?Oh0P3clo@0203cloD0m?Ce
0?GemP3dloD0iNCX06IVOP2XZK/0nocm0@1VIWh0000806IVOP3ko?d0Z:Vk
06IVOP3Ng=l0i>;P07^G[@0UEhE[000lM00701M=OP1[RjH0l_7^0?;al`1V
IWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=[Hf@1VQJ40
9df504em`F`0JH;^00H09df506Z:Y03_ko40IVIn0:RY^`3ko?d106IVOP00
00H0IVIn0?_lo@2XZK/0IVIn0=SEeP0GCGi_08V]i00501M=OP3[j^d0IVIn
0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad08V]
i03ooom[0<g<g`070?ooo`29[N@003ad0>SWjP1VIWh0Z:Vk0?_lo@0106IV
OP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0RjgT0?ooof/0d]7T00L0
oooo08^_i@00?7@0inKY06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm
0:RY^`1VIWh0fMGE000lM02>[nH0ooooJ`3FenL01`3oool0SJoU000lM03W
i^T0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD0
03ad096ai`3ooolP0=WJi`D000000`3If^L2000000030=WJi`000000fM[W
0080000000<0fM[W0000000000000P3If^L300000080fM[W00D000000=WJ
i`3If^L0fM[W000000040=WJi`030000003If^L0fM[W00<0fM[W00<00000
0=WJi`3If^L0803If^L01`3oool0TK7V000lM03Wi^T0IVIn0:RY^`3ko?d0
0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad09Bdj03ooolP0=WJ
i`030000003If^L0fM[W0080fM[W00<000000=WJi`0000000P3If^L20000
00050=WJi`000000fM[W0=WJi`0000000P3If^L01`000000fM[W0=WJi`3I
f^L000000=WJi`0000000`3If^L00`000000fM[W0=WJi`020=WJi`030000
003If^L0fM[W00<0fM[W00<000000=WJi`3If^L0803If^L01`3oool0UKCX
000lM03Wi^T0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IV
OP3IeMD003ad09RhjP3ooolP0=kOk0030000003Ngn`0g]o/0080g]o/00<0
00000=kOk00000000`3Ngn`00`000000g]o/000000020=kOk0040000003N
gn`0g]o/000000<0g]o/00<000000=kOk00000000`3Ngn`00`000000g]o/
0=kOk0030=kOk0D000008`3Ngn`01`3oool0V;SY000lM03Wi^T0IVIn0:RY
^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad09bkjP3o
oolP0>?Ul0030000003SiO00hnG`0080hnG`00<000000>?Ul00000000`3S
iO000`000000hnG`000000020>?Ul0040000003SiO00hnG`000000<0hnG`
00<000000>?Ul00000000`3SiO000`000000hnG`0>?Ul0030>?Ul0050000
003SiO00hnG`0>?Ul00000008`3SiO001`3oool0W;_[000lM03Wi^T0IVIn
0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0:2n
k03ooolP0>W[m@D000000P3YjoD01`000000jN_e0>W[m@3YjoD000000>W[
m@0000000P3YjoD010000000jN_e0>W[m@0000030>W[m@040000003YjoD0
000000000080jN_e00<000000>W[m@3YjoD0103YjoD00`000000jN_e0000
000T0>W[m@070?ooo`2Q_^`003ad0>OVj@1VIWh0Z:Vk0?_lo@0106IVOP00
00P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0YL7]0?ooob00l?7l00<00000
0?3ao03`lO`00P3`lO`00`000000l?7l000000030?3ao0L000000P3`lO`3
00000080l?7l00@000000?3ao000000000001`3`lO`00`000000l?7l0000
000T0?3ao0070?ooo`2U`^h003ad0>OVj@1VIWh0Z:Vk0?_lo@0106IVOP00
00P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0ZLG_0?ooob00m?Gm00<00000
0?Ceo@3dmOd00P3dmOd00`000000m?Gm0?Ceo@050?Ceo@040000003dmOd0
m?Gm000001<0m?Gm00<000000?Ceo@000000903dmOd01`3oool0ZLG_000l
M03Wi^T0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3I
eMD003ad0:g8l03ooolP0?Kgo@D00000203fmod010000000m_Om0?Kgo@00
000D0?Kgo@030000003fmod0m_Om02<0m_Om00L0oooo0:c7l000?7@0inKY
06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE000l
M02abo80ooooJ`3ho?d01`3oool0/Lcb000lM03Wi^T0IVIn0:RY^`3ko?d0
0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0;C=l`3ooom[0?gm
o@070?ooo`2ec_<003ad0>OVj@1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn
0?_lo@2XZK/0IVIn0=WEe@00?7@0]m3d0?ooof/0oOgm00L0oooo0;S@m@00
?7@0i^KY06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0
f=CD000lM02jdoD0ooooJ`3moOd01`3oool0^]?f000lM03UiNP0IVIn0:RY
^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3IeMD09EN5K`2le?H0
1@0UEhD0hN7T06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0fMGE07VDZ@0WCHD0K@3>iol01P0WCHD0NIF[0=oMh01VIWh0Z:Vk0?_l
o@40IVIn0000201VIWh0nocm0:RY^`1VIWh0f]OI0=oLf01iU:T09EN5J`00
?7@01`0GCGh0IXJQ0>3NfP3Lfmd0IVIn0:RY^`3ko?d00@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP3OgN00f]OI0=SDe00g0=OCe380dlk<0`3Gdm@01`3H
e=@0fMGE0=[Gf@3OgN00IVIn0:RY^`3ko?d00@1VIWh0000306IVOP3gmoT0
V9RW07D0MgNB0@2HV:L10?Ogn@40IVIn00000`1VIWh0moOi0;bmc@1f0;bm
c@40moOi0@1VIWh0000306IVOP3gmoT0i>?S07H0i>?S0@3gmoT106IVOP00
00<0IVIn0?3am03oool0;`3oool00`3Thn<0W:Bi06]eS`0306]eS`0406af
T01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>CSh`2LY;T4
06]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo
0>cZjP2LY;T40:HiA0040:LjA02V>D@0YcY40:LjA0T0YSU400<0W:Bi0>cZ
jP3oool00`3oool10?3am040IVIn00005P1VIWh0h^7R0?_lo03kno`0nocm
0?cko@3knod0nocm0?_lo03lo?d0o?cl0?cko@3lo?`0o?_l0?clo03ko?`0
o?cl0?_lo@3lno`0o?cm0?_ko@3ko?`20?clo0040?clo@3lo?`0no_m0?cl
oA@0o?_l0P3ko?`00`2LY;T0JgF?08F9/00@08F9/00606]eS`2LY;T0nocm
0?_lo@2LY;T0JgF?4@25RK001P1[MHl0W:Bi0?_lo03kno`0W:Bi0:HiA140
ZSaE00L0YSU409bT^@3ko?`0o?cl0?cko@3ko?d0h^7R0040IVIn0000101V
IWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0moOh
0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3gmoT0103gm_P0m_Oh0?Kgn@3gmoT3
0?Kgn@030?Kgn03gmoT0moOi01<0moOi0P3fmoT00`1[MHl0QHV`09bN_P0@
09bN_P0608F9/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?
0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V
>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3alO@0
lO7d0?3am03`l_@@000000060?7am03`l_D0lO7d0?7bm03`l_@0lO7d5P3`
lOD00`1[MHl0/[G@0:NX`P0@0:NX`P060;:ed01[MHl0l?7d0?3am01[MHl0
/[G@4@2WZ<801@2b]M00JgF?0?3am@3al_@0YSU40080`U9K00<0beAI0<eI
GP3=FEh02`3=FEh0103;E5T0`U9K0<9BF`2V>D@20?3am0030?7am03`l_@0
g]gQ0040IVIn00001`1VIWh0g=_P0>[[l03Zjo00j^c`0>W[k`0000000P3W
inL20=kNgP80inOW00<0ikf40>OWi`3WinL00`3WinL20>o_k`040000003Z
jo00j^_`0>[[k`80j^_`00<0j^__0>[[l03Zjo004P3Zjo020>[/l00406]e
S`2f^M40[Jk60:f^aPP0oooo00<0[Jk60:b^aP2][/H00`2][/H00`2/[/H0
][WA06]eS`020>[[k`0406]eS`2f^M40[Jk60:f^aP`0oooo0P2][/H00`2/
[/H0][WA06]eS`020>[[l0050:HiA03=FEh0beAI0<eFF`3>FEl02`3@FUl0
1`3>FEl0cEIK0<]DF@3=FEh0YSU40>[[k`3Zjo000P3Zjnl10=cKh040IVIn
0000101VIWh0fMWO0>?UjP3Si>X20>?Uj`050000002<S8`0g]kN0>OWi`3N
g]h00P3WinL00`36H`00inOW0>OWi`020>OWi`070>o_i`3_knl0kno_0000
003Si>X0hnC[0>?UjP020>?TjP030>?Tj`3SiN/0hnG[0180hnG[0P3Si>X0
1@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b
//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U
9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@
Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:Hi
A03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0
g=kV00D000000>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW
0>ONaP3_S1000`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H0
5P3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h
^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo
02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0
g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`05
05<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IV
OP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0
ikF40=IJ003FQ000olh00<iS00020=i[00050>neS03_knl0kno_0>o_k`00
00000P3Ef>40103Een00e]SP0=KHh@3Fen4D0=KGh080e]SP00D0JgF?0<?5
f@2l_M40_;gA0?ooo`0702DU=PL0_;gA00H0`lGI06]eS`3Ef>40eMSQ06]e
S`33aMT20;bmd@030?ooo`0U9CH0_;gA00L0_;gA00<0oooo02DU=P2l_M40
0P2l_M401@33aMT0JgF?0=KGh03Een40YSU40080eEeP00<0f61Q0=UQHP16
7QX00`3oool30=UQHP<0oooo00<0AQhJ0=UQHP3HH6400P3EGF001P2V>D@0
e]SP0=GHh@3Een00eMSQ0=GFg@40IVIn00001`1VIWh0d]CM0<oBg03@d]`0
d=;M0=3Bg00000000`3WinL0303Wg/h0aTX00?O>003_[@00kkD00<i[0036
FP00aV/00=j<BP3WY@00knO>000000<0d=;L00<0cm;L0=3Bg03?d]`0503@
d]`20<oBg@0306]eS`38bM/0`lCF0100`lCF00H0b<WK06]eS`3@d]`0d=;L
06]eS`38bM/20<?4eP030?ooo`0U9CH0`lCF00L0`lCF00<0oooo02DU=P33
a=H00P33a=H01`38bM/0JgF?0<oBg03?d]`0YSU40=MOG`3IHF800`3LIFD0
1@167QX0oooo0?ooo`3oool0g6EU00<0oooo00P0AQhJ0=aUI@3LIFD0g6EU
0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?d]`10=;Dg@40IVIn0000701VIWh0
d=;K0<_=f03:cMT0blkH0<[=f0000000ilJ]0>O6S03gcQP0kkd00?O6003_
[@00ijd00>NU003FS000cV/00>O6003oeP00knoW0>o_k`000000blgH0<_=
f@3:cMT0blkH0<[=f03;cMPD0<_=f@80blkI00<0JgF?0<_<gP38b]T02038
b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38b]T0blcN06]eS`80blgH
00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38b]T0b<[I
0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:HiA03GGel0
ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?ooo`030?ooo`0:04HN6P3N
IfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI0@3@d]/1
06IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P000000a/K60>ONeP3>N`00
ijd00>ne0080ijD000<0eY@00<ic003FU0000P3gaP020?Ogm`0400000035
b=@0aLOD0<G7e0<0aLOE5034amD20<C8e00306]eS`3@dN00bl_L0100bl_L
00H0d=7P06]eS`34am@0a<OD06]eS`3@dN020<_;g0030?ooo`0U9CH0bl_L
00L0bl_L00<0oooo02DU=P3;bm`00P3;bm`01`3@dN00JgF?0<G7e034am@0
YSU40=]TI03OIF@01@3PJVP01@167QX0oooo0?ooo`3oool0AQhJ00D0h6YX
00@0gfET0=]TI02V>D@0a<SE0P34b=@10<G7e@40cloJ0@1VIWh0000406IV
OP3<c]X0`/CB0<74d@80`LCB00H000000>OWi`3WinL0inOW0=J4003_]@02
0>NU00080=J4003>J`00ijd00?Ne003g_@00kno_0?Ogm`0000030<74dP03
0<;4d@31a=80`LCB01@0`LCA0P31a=800`1[MHl0dm?R0<o@g@0@0<o@g@06
0=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?d=d00`3oool09BDf0<o@g@07
0<o@g@030?ooo`0U9CH0cm3M0080cm3M00L0dm?R06]eS`32a=80`LCA0:Hi
A03KI6@0hFUU00D0h6aY1@3oool50>1/J@080>5YI@3KI6@0YSU40<74dP32
a=40`LCA0<74dP3<c]X106IVOP0000@0IVIn0<[<f02n`<l0_L3?0P2n`<h0
1@000000W9bL0>OWi`3Wg]H0eX`00080gY@000@0eW/00<IS002m@P00kjD0
0P3g[@00203g]@00oli:0000002n`<h0_/3?0;k0cP2n`<l0_L3>5@2n`<h2
0;g0cP0306]eS`3Fe^@0dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>06]e
S`3Fe^@20=?Ch0030?ooo`0U9CH0oooo00P0oooo00/09BDf0=?Ch03Cdn00
dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0
AQhJ0?ooo`3oool0oooo103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0c`40
_/3>0@3:c=P106IVOP0000L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`00000
0080kno_01<0eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic003_W000
mnoW0?Ogm`3oool000000;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;01@0^Kc<
0P2j_<`00`1[MHl0f=SU0=?Ch@0@0=?Ch@060=SHi@1[MHl0^[c;0;Zlb`1[
MHl0f=SU0P3Cdn400`3oool0KVf?06i]S`0806i]S`0>02DU=P3Cdn40dm?Q
0=?Ch@3Hf>D0JgF?0;Zlb`2j_<`0YSU40>1YJ03QKF`0i75]0>AaK`3TL6h3
0?ooo`0304HN6P3TL6h0AQhJ00<0oooo0P3TL6h02@3TLFd0hFe/0>1YJ02V
>D@0^[c<0;Zkc02i_</0][S80<W:f00106IVOP0000T0IVIn0<O9e`2d]/L0
][S80;Jhb@2f^LT0000008B4Q03Wimh00P3_knl01`36J`00mlH00>ne003_
W000gX`00<i[003WW0000`3gmoL01@000000][W90;Nhb@2f^LT0]kW90080
][S9502g^<T20;Jhb@0406]eS`3Fe^@0f=SU0=SHiP<0f=SU1@3Hf>H30=SH
i@80f=SV0P3Hf>D02@3Fe^@0JgF?0;Nhb@2g^<T0JgF?0=KFi03Hf>D0f=SV
0?ooo`0:06i]S`0=02DU=P3Hf>H0f=SU0=SHi@3Fe^@0JgF?0;Nhb@2g^LT0
YSU40>A^K@3TM6l0ig5_0>AdK`030?ooo`0504HN6P3TM6l0i7A_0>AdK`16
7QX00`3oool02P3TM6l0ig5_0>AdK`3TKVd0YSU40;Jib@2f^<T0][W90;Bf
a`37bML106IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L00`000000kno_0>o_
k`020>o_k`0;0>N]003gaPP0ijD00>ND003WS000knOF0=jD>@3_e[D0ooOg
0?ooo`000000702d]/L01@1[MHl0eMGS0=cKi`3LfnL0gM_W00h0g=_W00H0
eMGS06]eS`2d]/L0];K706]eS`3EeN<20=cKi`030=gKi`0U9CH09BDf00T0
9BDf0`3LfnL02@3EeN<0JgF?0;Bfa`2d]/L0YSU40>McK`3WMG80jWIc0>Yh
MP020?ooo`0304HN6P3YOWP0jGih00<0jGih00P0AQhJ0?ooo`3oool0jWQf
0>YfL`3WMG80ig=_0:HiA0@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2d
]/L00`2d]/L01P000000S8b<0>o_k`3_knl0ilik0>o_k`80moOg00P0ii@0
0?OWcP3gmoL0moOg0>oWeP3gmoL0oooo000001`0];K700<0JgF?0=GDh`3P
gnX0403PgnX01P3Ee><0JgF?0;Bfa`2d]/L0JgF?0=GDha40h=oZ00T0eMCS
06]eS`2d]/L0];K70:HiA03ZNG<0jGah0>n1NP3bRH400P167QX01`3[V8/0
jY^<0>fGRP3[V8/0jY^<0>fGRP3[V8/00P167QX01@3bRH40kh5j0>UlN03Z
NG<0YSU400@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2a/lP00`2a/lP0
1P000000kno_0>o_k`3_knl0moO_0>o_k`80moOg00<0mnO60?Ogm`3oool0
0`3gmoL00`3oool000000;6cb00K0;6cb00306]eS`3]jo<0jNSa0100jNSa
00H0kN_c06]eS`2a/lP0/K?806]eS`3]jo<A0>WXl@0I0>g[l`1[MHl0/K?8
0;6cb02V>D@0lH1e0?24O03eS8@0mif>0?:[UP3a/Y/0kKBK0>beW03a/Y/0
kKBK0>beW03a/Y/0kKBK0>beW03bZiH0mif>0?F<Q03`Q7`0lH1e0:HiA004
0;6cb040a/SG0@1VIWh0000306IVOP36b=L0^;O?00<0[jk700D000000:f]
[@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3oool00`000000[jk70:n^a`0J
0:n^a`0306]eS`3BdN<0l_7g0100l_7g00H0d]7S06]eS`2_[/L0[jk706]e
S`3BdN<A0?;am`060=;Ah`1[MHl0[jk70:n^a`2V>D@0m8Ym0P3eT8D=0?:h
WP80mI2500<0m8Ym0:HiA02_[/L00P2_[/L10;Rgc`40a/SG0@1VIWh00003
06IVOP30`M40alOD02l0[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103k
no`0c<_M06]eS`24S:820:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0
no_l0<c;g@1[MHl0Q8bR0P2/Zl@01`2AV:X0YSU40?nOS@3n_j@0n]bg0?[[
]`3jjKH00P3ijKH0103jjKH0nNVf0?WY]P3jjKH20?WY]P060?[[]`3jg;L0
o[nT0?nOS@2V>D@0TIRZ0`2/Zl@10<O7e040`<7A0@1VIWh0000406IVOP30
`M40d];O0;FdbBl0Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n
0:BS_P020:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh0
0P2TXkh00`24S:80YSU40:HiA00?0:HiA00708B<XP2TXkh0Y:>n0:BS_P2e
]<T0d];O0<31d@0106IVOP0000H0IVIn0:RW_`3Vi^d0d];P0;blc`2a/<A_
0:RW_`050;6`a02l_<l0d];P0>KVk@2XYkl00@1VIWh0000705QGJ027Qi/0
emSR0?clo03ThnP0d=3P0<[:fP1]0;blc`060<[:fP3@d>00i>?X0?clo03G
f>80QhNK0@1HEfP0000805QGJ01VIWh0UIB[0=OHhP3lo?`0l_7c0>c[kP3Q
h^][0=OHhP070>7Rj`3/jnh0l_7c0?clo03Gf>80UIB[06IVOP0105QGJ000
0P1HEfP00`1VIWh0UIB[0=7AgP020?clo6d0oooo0P3lo?`00`3AdMh0UIB[
06IVOP0205QGJ0000`1HEfP206IVOP0308R7W@2EU:/0Z:No06`0Z:No00@0
UIB[08R7W@1VIWh0IVIn0`1HEfP000D0F5MXL@1VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  Evaluatable->False,
  ImageSize->{123, 109},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutIntro"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"LayoutIntro"]
}, Open  ]],

Cell["\<\
Nesting lists within a vertical layout creates horizontal layouts of these \
internal groupings.\
\>", "Text",
  CellTags->"LayoutIntro"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
{\[IndentingNewLine]{Widget["\<Button\>", {"\<text\>" -> "\<Button A\>"}], \
\[IndentingNewLine]Widget["\<Button\>", {"\<text\>" -> "\<Button B\>"}]}, \
\[IndentingNewLine]Widget["\<Button\>", {"\<text\>" -> "\<Button C\>"}]\ }\
\[IndentingNewLine]]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"LayoutIntro"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"LayoutIntro"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002O0000Db000`400?l0
0000o`00003oW`1VIWh0000306IVOP3ko?d0nocm09/0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk09X0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
V@1VIWh10:RY^`40nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3Qh>@0
i^GX0>c[kP3`l?80l_;d04L0lo?dA03hmoP20??cm0080??cm@3dm?D0mOGf
0?Ccm@3Ui>P0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn
0=kLg`3Th^00NiN]02EGQHl003ad00L05den06^;YP3blNh0l_7c06IVOP2X
ZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0f]SI06J5X@1:LI<0
/[g3S`36aML01`30a/D0B6j@06Z:Y03_ko40IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP3HeMH05den0;o7bP2A0<K5e`060;Jm_@0G
CGh0jn[]06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3I
eMD003ad0?ooo`2A0<g<g`060?ooo`00?7@0j>OZ06IVOP2XZK/0nocm0@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`2A0=;Ai0060?oo
o`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3IeMD003ad0?ooo`2A0=KGi`060?ooo`00?7@0inKY06IVOP2XZK/0nocm
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0d0=WJi`D0
00000`3If^L2000000030=WJi`000000fM[W0080000000<0fM[W00000000
00000P3If^L300000080fM[W00D000000=WJi`3If^L0fM[W000000060=WJ
i`<00000=P3If^L01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool0=03If^L00`000000fM[W
0=WJi`020=WJi`030000003If^L000000080fM[W0P0000001@3If^L00000
0=WJi`3If^L000000080fM[W00L000000=WJi`3If^L0fM[W0000003If^L0
000000<0fM[W00<000000=WJi`3If^L00`3If^L01@000000fM[W0=WJi`3I
f^L0000003D0fM[W00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo03@0g]o/00<000000=kO
k03Ngn`00P3Ngn`00`000000g]o/000000030=kOk0030000003Ngn`00000
0080g]o/00@000000=kOk03Ngn`000000`3Ngn`00`000000g]o/00000003
0=kOk0030000003Ngn`0g]o/0080g]o/00<000000=kOk03Ngn`0>03Ngn`0
1P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY
^`1VIWh0fMGE000lM03oool0=03SiO000`000000hnG`0>?Ul0020>?Ul003
0000003SiO00000000<0hnG`00<000000>?Ul00000000P3SiO0010000000
hnG`0>?Ul00000030>?Ul0030000003SiO00000000<0hnG`00<000000>?U
l03SiO000P3SiO000`000000hnG`0>?Ul00h0>?Ul0060?ooo`00?7@0inKY
06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad
0?ooo`0d0>W[m@D000000P3YjoD01`000000jN_e0>W[m@3YjoD000000>W[
m@0000000P3YjoD010000000jN_e0>W[m@0000030>W[m@040000003YjoD0
000000000080jN_e00<000000>W[m@3YjoD00P3YjoD00`000000jN_e0>W[
m@0h0>W[m@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0d0?3ao0030000003`lO`0l?7l
0080l?7l00<000000?3ao00000000`3`lO`700000080l?7l0`0000020?3a
o0040000003`lO`00000000000D0l?7l00<000000?3ao03`lO`0>03`lO`0
1P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY
^`1VIWh0fMGE000lM03oool0=03dmOd00`000000m?Gm0?Ceo@020?Ceo@03
0000003dmOd0m?Gm00D0m?Gm00@000000?Ceo@3dmOd000004P3dmOd01@00
0000m?Gm0?Ceo@3dmOd0000003D0m?Gm00H0oooo000lM03Wi^T0IVIn0:RY
^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo03@0
m_Om1@0000080?Kgo@040000003fmod0m_Om000001<0m_Om0`00000f0?Kg
o@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP3IeMD003ad0?ooo`2A0?Slo@060?ooo`00?7@0inKY06IVOP2X
ZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`2A
0?gmo@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP3IeMD003ad0?ooo`2A0?gmo@060?ooo`00?7@0i^KY06IV
OP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3He=@003ad0?oo
o`2A0?gmo@060?ooo`00?7@0iNGX06IVOP2XZK/0nocm0@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP3IeMD09EN50;o>g02A0?ooo`060;o>f`0UEhD0hN7T
06IVOP2XZK/0nocm0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD0NIBY
05EmXP30cmf?0?ooo`070=GOj01EOJ80NIF[0=oMh01VIWh0Z:Vk0?_lo@01
06IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=[Gf@3Og=P0NIBY02EGQHl003ad
00L05den06J6X@3Pg]X0g=_M06IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0gmgP0=[Gf@3He=@0B@3GdmA40=?>c0<0em?D00L0f=CD
0=WEe@3JemT0gmgP06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWjG0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWjG0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWjG0>3Oh`0306IVOP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY
^`1VIWh0hN3T0>KUj03/jnh0l?3b0?;bm00Q0??cm1h0n?Oh0P3clo@01@3c
loD0m?Ce0?GemP3dloD0iNCX00<0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;b
m00P0??cm1d0n?Oh0P3clo@0203cloD0m?Ce0?GemP3dloD0iNCX06IVOP2X
ZK/0nocm0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3Ng=l0i>;P07^G[@0U
EhE3000lM00401M=OP1[RjH0l_7^0?;al`<0h=oS00@0g]cO0>CRh01kUjd0
9EN5@@00?7@01`0GCGh0Jh^V0?;akP3blO<0IVIn0:RY^`3ko?d00@1VIWh0
000806IVOP3ko?d0Z:Vk06IVOP3Jf=T0IXFQ02M=Q@1=OL5406V2kP0302M=
Q@1ZRZ@0knoa00<0h=oS00@0f]SI06J5X@1:LI<0/[g3@@36aML01`30a/D0
B6j@06Z:Y03_ko40IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk
06IVOP3HeMH05denA`29[N@00`0GCGh0jn[]0>3Oh`020>3Oh`030=SEeP0G
CGh0_lO:04<0a/GG00H0][fm01M=OP3[j^d0IVIn0:RY^`3ko?d106IVOP00
00P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0RJgT0?oood<0cLcO00@0oooo
08V]i000?7@0j>OZ0`3Pgn<00`3IeMD003ad0?ooo`130<g<g`060?ooo`00
?7@0j>OZ06IVOP2XZK/0nocm0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3I
eMD003ad08^]i03ooom30=;Ai0040?ooo`2;[nD003ad0>OVj@<0h=oS00<0
fMGE000lM03oool0@`3BdN@01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40
IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM02>[nH0oooo@`3FenL0
103oool0SJoU000lM03Wi^T30>3Oh`030=WEe@00?7@0oooo04<0e]OW00H0
oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0
IVIn0=WEe@00?7@0TK7W0?ooo``0fM[W1@0000030=WJi`80000000<0fM[W
0000003If^L00P0000000`3If^L00000000000020=WJi`<000000P3If^L0
1@000000fM[W0=WJi`3If^L0000000@0fM[W00<000000=WJi`3If^L00`3I
f^L00`000000fM[W0=WJi`0<0=WJi`040?ooo`2A/NH003ad0>OVj@<0h=oS
00<0fMGE000lM03oool03@3If^L5000000<0fM[W0P0000000`3If^L00000
0=WJi`02000000030=WJi`00000000000080fM[W0`0000020=WJi`050000
003If^L0fM[W0=WJi`000000103If^L5000000l0fM[W00H0oooo000lM03W
i^T0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00
?7@0U;CX0?ooo``0fM[W00<000000=WJi`3If^L00P3If^L00`000000fM[W
000000020=WJi`80000000D0fM[W0000003If^L0fM[W000000020=WJi`07
0000003If^L0fM[W0=WJi`000000fM[W000000030=WJi`030000003If^L0
fM[W0080fM[W00<000000=WJi`3If^L00`3If^L00`000000fM[W0=WJi`0<
0=WJi`040?ooo`2E]>P003ad0>OVj@<0h=oS00<0fMGE000lM03oool03@3I
f^L00`000000fM[W0=WJi`020=WJi`030000003If^L000000080fM[W0P00
00001@3If^L000000=WJi`3If^L000000080fM[W00L000000=WJi`3If^L0
fM[W0000003If^L0000000<0fM[W00<000000=WJi`3If^L00P3If^L00`00
0000fM[W0=WJi`020=WJi`030000003If^L0fM[W00`0fM[W00H0oooo000l
M03Wi^T0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WE
e@00?7@0V;SZ0?ooo``0g]o/00<000000=kOk03Ngn`00P3Ngn`00`000000
g]o/000000030=kOk0030000003Ngn`000000080g]o/00@000000=kOk03N
gn`000000`3Ngn`00`000000g]o/000000030=kOk0030000003Ngn`0g]o/
00<0g]o/1@00000?0=kOk0040?ooo`2H^>T003ad0>OVj@<0h=oS00<0fMGE
000lM03oool03@3Ngn`00`000000g]o/0=kOk0020=kOk0030000003Ngn`0
000000<0g]o/00<000000=kOk00000000P3Ngn`010000000g]o/0=kOk000
00030=kOk0030000003Ngn`0000000<0g]o/00<000000=kOk03Ngn`00P3N
gn`00`000000g]o/0=kOk0020=kOk0030000003Ngn`0g]o/00`0g]o/00H0
oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0
IVIn0=WEe@00?7@0W;_Z0?ooo``0hnG`00<000000>?Ul03SiO000P3SiO00
0`000000hnG`000000030>?Ul0030000003SiO0000000080hnG`00@00000
0>?Ul03SiO0000000`3SiO000`000000hnG`000000030>?Ul0030000003S
iO00hnG`00<0hnG`00D000000>?Ul03SiO00hnG`0000000?0>?Ul0040?oo
o`2L^n/003ad0>OVj@<0h=oS00<0fMGE000lM03oool03@3SiO000`000000
hnG`0>?Ul0020>?Ul0030000003SiO00000000<0hnG`00<000000>?Ul000
00000P3SiO0010000000hnG`0>?Ul00000030>?Ul0030000003SiO000000
00<0hnG`00<000000>?Ul03SiO000P3SiO000`000000hnG`0>?Ul0020>?U
l0030000003SiO00hnG`00`0hnG`00H0oooo000lM03Wi^T0IVIn0:RY^`3k
o?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0X;k/0?ooo``0
jN_e1@0000020>W[m@070000003YjoD0jN_e0>W[m@000000jN_e00000002
0>W[m@040000003YjoD0jN_e000000<0jN_e00@000000>W[m@0000000000
0P3YjoD00`000000jN_e0>W[m@040>W[m@030000003YjoD000000100jN_e
00@0oooo0:6nk000?7@0inKY0`3Pgn<00`3IeMD003ad0?ooo`0=0>W[m@D0
00000P3YjoD01`000000jN_e0>W[m@3YjoD000000>W[m@0000000P3YjoD0
10000000jN_e0>W[m@0000030>W[m@040000003YjoD0000000000080jN_e
00<000000>W[m@3YjoD00P3YjoD5000000l0jN_e00H0oooo000lM03Wi^T0
IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0
YL7]0?ooo``0l?7l00<000000?3ao03`lO`00P3`lO`00`000000l?7l0000
00030?3ao0L000000P3`lO`300000080l?7l00@000000?3ao00000000000
1`3`lO`00`000000l?7l0000000@0?3ao0040?ooo`2U`^h003ad0>OVj@<0
h=oS00<0fMGE000lM03oool03@3`lO`00`000000l?7l0?3ao0020?3ao003
0000003`lO`0000000<0l?7l1`0000020?3ao0<000000P3`lO`010000000
l?7l0000000000050?3ao0030000003`lO`0l?7l0080l?7l00<000000?3a
o03`lO`0303`lO`01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000
201VIWh0nocm0:RY^`1VIWh0fMGE000lM02YaNl0oooo303dmOd00`000000
m?Gm0?Ceo@020?Ceo@030000003dmOd0m?Gm00D0m?Gm00@000000?Ceo@3d
mOd000004`3dmOd00`000000m?Gm0000000@0?Ceo@040?ooo`2YaNl003ad
0>OVj@<0h=oS00<0fMGE000lM03oool03@3dmOd00`000000m?Gm0?Ceo@02
0?Ceo@030000003dmOd0m?Gm00D0m?Gm00@000000?Ceo@3dmOd000004@3d
mOd00`000000m?Gm0?Ceo@020?Ceo@030000003dmOd0m?Gm00`0m?Gm00H0
oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0
IVIn0=WEe@00?7@0[LS`0?ooo``0m_Om1@0000080?Kgo@040000003fmod0
m_Om000001@0m_Om00<000000?Kgo@3fmod03`3fmod0103oool0[<O`000l
M03Wi^T30>3Oh`030=WEe@00?7@0oooo00d0m_Om1@0000080?Kgo@040000
003fmod0m_Om00000140m_Om1@00000?0?Kgo@060?ooo`00?7@0inKY06IV
OP2XZK/0nocm0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0;7;
lP3ooom30?Slo@040?ooo`2ac?8003ad0>OVj@<0h=oS00<0fMGE000lM03o
ool0@`3ho?d01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000201V
IWh0nocm0:RY^`1VIWh0fMGE000lM02dcO<0oooo@`3moOd0103oool0]Lkc
000lM03Wi^T30>3Oh`030=WEe@00?7@0oooo04<0oOgm00H0oooo000lM03W
i^T0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00
?7@0]m3d0?oood<0oOgm00@0oooo0;S@m@00?7@0i^KY0`3Pgn<00`3IeMD0
03ad0?ooo`130?gmo@060?ooo`00?7@0i^KY06IVOP2XZK/0nocm0@1VIWh0
000806IVOP3ko?d0Z:Vk06IVOP3He=@003ad0;[Cm@3ooom30?gmo@040?oo
o`2jdoH003ad0>GUj0<0h=oS00<0f=CD000lM03oool0@`3moOd01P3oool0
03ad0>GUj01VIWh0Z:Vk0?_lo@40IVIn00001P1VIWh0nocm0:RY^`1VIWh0
fMGE02EGQDL0_=Cf00<09EN50>7Qi03Pgn<00P3Pgn<00`3IeMD09EN50;o>
g0130?ooo`060;o>f`0UEhD0hN7T06IVOP2XZK/0nocm0@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP3IeMD0NIBY02M=Q@150<kWo`0302M=Q@1iUJ/0gmgP
00<0h=oS00@0fMGE07VDZ@1EOJ80`<oM@@3oool01`3EgnP0EGfR07VEZ`3O
gN00IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3JemT0
gmcH07VDZ@0UEhE3000lM00401M=OP1VQZ40h=kJ0=cKg@<0h=oS00@0f]OI
0=oLf01iU:T09EN5@@00?7@01`0GCGh0IXJQ0>3NfP3Lfmd0IVIn0:RY^`3k
o?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3OgN00f]OI0=SDe00S0=OC
e1h0dlk<0`3Gdm@0103He=@0fMGE0=[Gf@3OgN030>3Oh`030=oMh03JemT0
f=CD0280em?D7@3Cc/`30=OCe0070=SDe03IeMD0f]OI0=oMh01VIWh0Z:Vk
0?_lo@0106IVOP0000<0IVIn0?Ogn@2HV:L0V@1gMi8109RHY`40moOi0@1V
IWh0000306IVOP3gmoT0_;g=09X0_;g=0@3gmoT106IVOP0000<0IVIn0?Og
n@3Thn<0VP3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`1C0?ooo`03
0>CSh`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2L
Y;T0i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@
2@1[MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:Hi
A02W>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0
000F06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3l
o?`0o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_l
o080o?cl00@0o?cm0?clo03knod0o?cm803lno`J0?_lo00309bT^@1[MHl0
QHV`0100QHV`00H0JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9/00606]e
S`2LY;T0nocl0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_lo03lo?`0
o?_m0?_lo@3RhN800@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0
m_Oh0?Ogn@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi0?Kgn@02
0?Ogn@040?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3gmoT07`3g
moTJ0?Kgn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi
06]eS`25RK0A09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36
E5X=0<IEG0090<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q
0040IVIn00001P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm100000000H0lO7d
0?3bm@3alO@0lO;d0?3bm03alO@j0?3am@0306]eS`2b]M00YjS20100YjS2
00H0/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e
0?7bm02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0
`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3Lfn00
j^_`0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0inOW
0>OWi`030>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0
j^_`0>[[l00N0>[[l1X0j^c`00@0JgF?0;Jid@2][/H0[Jk6203oool00`2]
[/H0[:k60:f^aP030:f^aP030:b^aP2f^M40JgF?0080j^__00@0JgF?0;Ji
d@2][/H0[Jk6303oool20:f^aP030:b^aP2f^M40JgF?0080j^_`00D0YSU4
0<eIGP3;E5T0cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0
j^__0>[[l0020>[[k`40g=_P0@1VIWh0000406IVOP3IfMl0hnGZ0>?TjP80
hnG[00D0000008b<S03Ng]h0inOW0=kNgP020>OWi`030<IS003WinL0inOW
0080inOW00L0knoW0>o_k`3_knl000000>?TjP3Si>/0hnGZ0080hnCZ00<0
hnC[0>?Uj`3SiN/07P3SiN/J0>?TjP0506]eS`2l_]@0/[;:0;:bbP3oool0
1P1^KHl00`0U9CH0/[;:0;:bbP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[
MHl0_;kD0P2b//X00`3oool09BDf02DU=P0902DU=P<0/[;:00D0_;kD06]e
S`3Si>/0hnC[0:HiA0020<eIGP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3o
ool02P3DG5l0d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl1
06IVOP0000<0IVIn0=OHgP3Lg^H00`3Lg^H01@000000inOW0>OWi`3WinL0
imK>0080inOW00D0cW/00>nD403WinL0imk60>n<40030>o_k`070000003L
g^H0g=kU0=cNi@3Lg^H0g=kU0=cNiP0j0=cNi@0506]eS`2o`MH0^;W>0;Ri
cP3oool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU
0=cNi@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U
9CH0^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AM
H@1C9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA002
0=cNi@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>42
0=GHh0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080
gV/000D0kkF<0>o_k`3_knl0kno_000000020=GHh@040=GGh03Ff>00e]SQ
0=KGhB00e]OP6P3Ff>001@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l
_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l
_M401`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GG
h@2V>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`16
7QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1V
IWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ON
cP36BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh00000
0`3@d]`00`3?d]`0d=;L0<oBg00P0=3Bg1X0cm;M00<0JgF?0<S9f`33a=H0
4033a=H01P38bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80`lCF00<0oooo02DU
=P33a=H01`33a=H00`3oool09BDf0<?4eP020<?4eP070<S9f`1[MHl0cm;L
0<oBg02V>D@0eemO0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD0
0`3oool020167QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`1
0<oBg040d]CM0@1VIWh0000L06IVOP3@d]/0blgH0<[=f@3;c]P0b/gH0000
003WaZd0ilJ<0?O>603__@00mlH00>n]003W[@00ijD00=J<003>J`00ilH0
0?oF003_knL0kno_0000003;cMP0blgI0<[=f@3;c]P0b/gH0<_=f200blgI
6P3;c]T00`1[MHl0blcN0<S:f@080<S:f@030<S9f@38b]T0b<[I00<0b<[I
00@0b<WI0<S:f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN0<S:f@38b]T0oooo
02DU=PD0b<[I0140b<WI0<S:f@38b]T0oooo02DU=P38b]T0b<WI0<S:f@3;
c=h0JgF?0<_>f03:cMP0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN
6P3oool0oooo00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO
0:HiA03:c]P0b/kI0P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e003
0<G8e00600000036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<0
0=JD00020?O60080moOg00@000000<G8e035am@0aLOD0`35amDP0<C7eAX0
a<SD00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?
0=3Ah080bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g002
0<_;g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN
6P3oool0oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8
e040aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P00
0000inOW0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD0
0?Nm003_knl0moOg000000<0`LCB00<0`/CA0<74dP31a=808031a=4J0<74
dP0306]eS`3Cdn80cm3M0100cm3M00H0dm?R06]eS`32a=80`/CB06]eS`3C
dn820<o@g@030?ooo`0U9CH0cm3M00L0cm3M00<0oooo02DU=P3?d=d00P3?
d=d01`3Cdn80JgF?0<;4dP31a=40YSU40=]TI03QJFD01@3PK6T50?ooo`D0
h6aY00P0hFUU0=]TI02V>D@0`LCB0<;4d@31a=40`LCB0<c>fP40IVIn0000
101VIWh0b/cH0;k0c`2m`<l20;k0cP050000002LW9`0inOW0>ONeP3FS000
0P3NU000103FN`00aV<00;e2003_Y@020?N]00080?Ne003ocTX000000;k0
cP2n`<l0_/3>0;k0c`2m`<hQ0;k0cQX0_L3>00<0JgF?0=KFi03Cdn00403C
dn001P3Fe^@0JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3o
ool0203oool02`0U9CH0dm?P0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:Hi
A03PIVD0hFYZ00@0hfa/0`3oool010167QX0oooo0?ooo`3oool40>=/K004
0>5ZJP3PIVD0YSU40;g0c`80_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0
bL[H0;Jhb02i_</0^[c;0;Zlc00000000P3_knl04`3FW000eX`00=jD003F
Q000kjD00=j<002mFP00eW<00>nL003gknL0moOg0?ooo`000000^Kc<0;Zk
c02i_</0^[c;0;Vlc02i_</0802i_<`J0;Zlc00306]eS`3Hf>D0dm?Q0100
dm?Q00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0
KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V
>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3o
ool20>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H
0040IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OW
gP020>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Ogm`05
0000002f^LT0]kS90;Jib@2g^LT00P2f^<TP0;NhbAX0][S900@0JgF?0=KF
i03Hf>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@090=KFi01[MHl0
]kS90;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d09BDf0=SHiP3H
f>D0f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0
oooo00D0AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>AdK`3WLFl0i7A_
0>A^K@2V>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn00000`1VIWh0a/SG
0;Bfa`030;Bfa`030000003_knl0kno_0080kno_00/0ijd00?O6203WY@00
ii@00>N<003_imH0gY@i0>oF]@3omoL0oooo000000100;Bfa`0506]eS`3E
eN<0g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GE
h`80g=_W00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GEh`1[MHl0];K7
0;Bfa`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ0>UnN03YOWP0
0`3YOWP020167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d]/L1
0<K8e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`060000002<S8`0kno_
0>o_k`3WcW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0knOF0?Ogm`3o
ool00000@02d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0];K7
0;Bfa`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0YSU40>YiL`3Y
O7P0kh5j0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:0>^H
R`0204HN6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L10<K8e`40IVIn
00000`1VIWh0a/SG0;6cb0030;6cb0060000003_knl0kno_0>o_k`3gmnl0
kno_0P3gmoL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`000000/K?803l0
/K?800<0JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?
0>g[la40jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03g
WHh0lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[
UP3gWHh0mHb40?24O03aP7D0YSU400@0/K?80@36b=L106IVOP0000<0IVIn
0<K8e`2h]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3o
moL20?ooo`030000002_[/L0[jk703h0[jk700<0JgF?0=;Ah`3blOL0403b
lOL01P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0d]7S06]eS`2_
[/L0[jk70:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^a`02
0:n^a`40^;O?0@36b=L106IVOP0000<0IVIn0<31d@37am@0D`2/Zl@01024
S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400@0
Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a007
096HZP2V>D@0oin=0?joY03jg;L0n^^g0?[Y]P020?WY]P040?[Y]P3ijKH0
nNVf0?[Y]P80nNVf00H0n^^g0?[L]`3n_j@0oin=0:HiA02AV:X30:b[a040
alOD0@30`M4106IVOP0000@0IVIn0<31d@3Bd]l0]KC9D`2TXkh00`24S:80
JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]eS`1[
MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V>D@0YSU400l0
YSU400L0Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040IVIn00001P1V
IWh0Z:No0>KVk@3Bd^00_;c?0;6`a9<0Z:No00D0/K340;blc`3Bd^00i^K]
0:RW_`0106IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@d>00b/[J0940
_;c?00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ00000P0F5MX06IV
OP2EU:/0emSR0?clo03blO<0k>_^0>7Rjhl0emSR00L0hN;[0>c[kP3blO<0
o?cl0=OHhP2EU:/0IVIn0040F5MX000205QGJ00306IVOP2EU:/0dM7N0080
o?clT@3oool20?clo0030=7AgP2EU:/0IVIn0080F5MX000305QGJ080IVIn
00<0R8NM09FDZ`2XYkl0T02XYkl0102EU:/0R8NM06IVOP1VIWh305QGJ000
1@1HEfRE06IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  Evaluatable->False,
  ImageSize->{159, 83},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutIntro"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"LayoutIntro"]
}, Open  ]],

Cell["\<\
Further nesting alternates with vertical and horizontal layout nesting.\
\>", "Text",
  CellTags->"LayoutIntro"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
{\[IndentingNewLine]{Widget["\<Button\>", {"\<text\>" -> "\<Button A\>"}], \
\[IndentingNewLine]{Widget["\<Button\>", {"\<text\>" -> "\<Button B-1\>"}], \
\[IndentingNewLine]Widget["\<Button\>", {"\<text\>" -> "\<Button B-2\>"}]}}, \
\[IndentingNewLine]Widget["\<Button\>", {"\<text\>" -> "\<Button C\>"}]\ }\
\[IndentingNewLine]]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"LayoutIntro"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"LayoutIntro"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002Y0000KB000`400?l0
0000o`00003oZ@1VIWh0000306IVOP3ko?d0nocm0:D0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0:@0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
X`1VIWh10:RY^`40nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3Qh>@0
i^GX0>c[kP3`l?80l_;d04`0lo?dB@3hmoP20??cm0080??cm@3dm?D0mOGf
0?Ccm@3Ui>P0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn
0=kLg`3Th^00NiN]02EGQIT003ad00L05den06^;YP3blNh0l_7c06IVOP2X
ZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0f]SI06J5X@1:LI<0
/[g3V@36aML01`30a/D0B6j@06Z:Y03_ko40IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP3HeMH05den0;o7bP2K0<K5e`060;Jm_@0G
CGh0jn[]06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3I
eMD003ad0?ooo`2K0<g<g`060?ooo`00?7@0j>OZ06IVOP2XZK/0nocm0@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`2K0=;Ai0060?oo
o`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3IeMD003ad0?ooo`2K0=KGi`060?ooo`00?7@0inKY06IVOP2XZK/0nocm
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0i0=WJi`D0
00000`3If^L2000000030=WJi`000000fM[W0080000000<0fM[W00000000
00000P3If^L300000080fM[W00D000000=WJi`3If^L0fM[W000000060=WJ
i`<00000>`3If^L01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool0>@3If^L00`000000fM[W
0=WJi`020=WJi`030000003If^L000000080fM[W0P0000001@3If^L00000
0=WJi`3If^L000000080fM[W00L000000=WJi`3If^L0fM[W0000003If^L0
000000<0fM[W00<000000=WJi`3If^L00`3If^L01@000000fM[W0=WJi`3I
f^L0000003X0fM[W00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo03T0g]o/00<000000=kO
k03Ngn`00P3Ngn`00`000000g]o/000000030=kOk0030000003Ngn`00000
0080g]o/00@000000=kOk03Ngn`000000`3Ngn`00`000000g]o/00000003
0=kOk0030000003Ngn`0g]o/0080g]o/00<000000=kOk03Ngn`0?@3Ngn`0
1P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY
^`1VIWh0fMGE000lM03oool0>@3SiO000`000000hnG`0>?Ul0020>?Ul003
0000003SiO00000000<0hnG`00<000000>?Ul00000000P3SiO0010000000
hnG`0>?Ul00000030>?Ul0030000003SiO00000000<0hnG`00<000000>?U
l03SiO000P3SiO000`000000hnG`0>?Ul00m0>?Ul0060?ooo`00?7@0inKY
06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad
0?ooo`0i0>W[m@D000000P3YjoD01`000000jN_e0>W[m@3YjoD000000>W[
m@0000000P3YjoD010000000jN_e0>W[m@0000030>W[m@040000003YjoD0
000000000080jN_e00<000000>W[m@3YjoD00P3YjoD00`000000jN_e0>W[
m@0m0>W[m@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0i0?3ao0030000003`lO`0l?7l
0080l?7l00<000000?3ao00000000`3`lO`700000080l?7l0`0000020?3a
o0040000003`lO`00000000000D0l?7l00<000000?3ao03`lO`0?@3`lO`0
1P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY
^`1VIWh0fMGE000lM03oool0>@3dmOd00`000000m?Gm0?Ceo@020?Ceo@03
0000003dmOd0m?Gm00D0m?Gm00@000000?Ceo@3dmOd000004P3dmOd01@00
0000m?Gm0?Ceo@3dmOd0000003X0m?Gm00H0oooo000lM03Wi^T0IVIn0:RY
^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo03T0
m_Om1@0000080?Kgo@040000003fmod0m_Om000001<0m_Om0`00000k0?Kg
o@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP3IeMD003ad0?ooo`2K0?Slo@060?ooo`00?7@0inKY06IVOP2X
ZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`2K
0?gmo@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP3IeMD003ad0?ooo`2K0?gmo@060?ooo`00?7@0i^KY06IV
OP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3He=@003ad0?oo
o`2K0?gmo@060?ooo`00?7@0iNGX06IVOP2XZK/0nocm0@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP3IeMD09EN50;o>g02K0?ooo`060;o>f`0UEhD0hN7T
06IVOP2XZK/0nocm0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD0NIBY
05EmXP30cmfI0?ooo`070=GOj01EOJ80NIF[0=oMh01VIWh0Z:Vk0?_lo@01
06IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=[Gf@3Og=P0NIBY02EGQIT003ad
00L05den06J6X@3Pg]X0g=_M06IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0gmgP0=[Gf@3He=@0CP3GdmA90=?>c0<0em?D00L0f=CD
0=WEe@3JemT0gmgP06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWjQ0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWjQ0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWjQ0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWi>0>3Oh`050>7Pi03ViNP0k>_^0?3`lP3bl_@09@3clo@R0?Sgn080
lo?d00P0lo?e0?Cdm@3emOH0m??e0>GTj01VIWh0Z:Vk0?_lo@40IVIn0000
101VIWh0nocm0:RY^`1VIWi>0>3Oh`040=kLg`3Th^00NiN]02EGQD/003ad
00L05den06^;YP3blNh0l_7c06IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWi>0>3Oh`040=[Hf@1VQJ40BW6C0;:m`d/0a/GG00L0`<K5
04Q^T01ZRZ@0knoa06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWi>0>3Oh`030=SEeP0GCGh0_lO:04d0a/GG00H0][fm01M=OP3[j^d0
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInCP3Pgn<00`3I
eMD003ad0?ooo`1=0<g<g`060?ooo`00?7@0j>OZ06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOTh0h=oS00<0fMGE000lM03oool0C@3B
dN@01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm
0:RY^`1VIWi>0>3Oh`030=WEe@00?7@0oooo04d0e]OW00H0oooo000lM03W
i^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInCP3Pgn<0
0`3IeMD003ad0?ooo`0=0=WJi`D000000`3If^L2000000030=WJi`000000
fM[W0080000000<0fM[W0000000000000P3If^L300000080fM[W00D00000
0=WJi`3If^L0fM[W000000040=WJi`D000001P3If^L5000000h0fM[W00H0
oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVInCP3Pgn<00`3IeMD003ad0?ooo`0=0=WJi`030000003If^L0fM[W0080
fM[W00<000000=WJi`0000000P3If^L2000000050=WJi`000000fM[W0=WJ
i`0000000P3If^L01`000000fM[W0=WJi`3If^L000000=WJi`0000000`3I
f^L00`000000fM[W0=WJi`020=WJi`030000003If^L0fM[W0080fM[W00<0
00000=WJi`3If^L0103If^L00`000000fM[W0=WJi`0?0=WJi`060?ooo`00
?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTh0
h=oS00<0fMGE000lM03oool03@3Ngn`00`000000g]o/0=kOk0020=kOk003
0000003Ngn`0000000<0g]o/00<000000=kOk00000000P3Ngn`010000000
g]o/0=kOk00000030=kOk0030000003Ngn`0000000<0g]o/00<000000=kO
k03Ngn`00P3Ngn`00`000000g]o/0=kOk0020=kOk0030000003Ngn`00000
008000000`3Ngn`00`000000g]o/0=kOk00>0=kOk0060?ooo`00?7@0inKY
06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTh0h=oS00<0
fMGE000lM03oool03@3SiO000`000000hnG`0>?Ul0020>?Ul0030000003S
iO00000000<0hnG`00<000000>?Ul00000000P3SiO0010000000hnG`0>?U
l00000030>?Ul0030000003SiO00000000<0hnG`00<000000>?Ul03SiO00
0P3SiO000`000000hnG`0>?Ul0020>?Ul0030000003SiO00hnG`00H0hnG`
00<000000>?Ul03SiO003@3SiO001P3oool003ad0>OVj@1VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWi>0>3Oh`030=WEe@00?7@0oooo
00d0jN_e1@0000020>W[m@070000003YjoD0jN_e0>W[m@000000jN_e0000
00020>W[m@040000003YjoD0jN_e000000<0jN_e00@000000>W[m@000000
00000P3YjoD00`000000jN_e0>W[m@020>W[m@D000002P3YjoD00`000000
jN_e0>W[m@0<0>W[m@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOTh0h=oS00<0fMGE000lM03oool03@3`lO`0
0`000000l?7l0?3ao0020?3ao0030000003`lO`0000000<0l?7l1`000002
0?3ao0<000000P3`lO`010000000l?7l0000000000050?3ao0030000003`
lO`0l?7l0080l?7l00<000000?3ao03`lO`01`3`lO`00`000000l?7l0?3a
o00<0?3ao0060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000906IV
OP3ko?d0Z:Vk06IVOP3Qh>@0i^GX0>c[kP3`l?80l_;d0240lo?d7P3hmoP2
0??cm0050??cm@3dm?D0mOGf0?Ccm@3Ui>P00`3Pgn<00`3IeMD003ad0?oo
o`0=0?Ceo@030000003dmOd0m?Gm0080m?Gm00<000000?Ceo@3dmOd01@3d
mOd010000000m?Gm0?Ceo@00000A0?Ceo@030000003dmOd0m?Gm0080m?Gm
00<000000?Ceo@3dmOd00`3dmOd01@000000m?Gm0?Ceo@3dmOd0000000h0
m?Gm00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_l
o@2XZK/0IVIn0=kLg`3Th^00NiN]02EGQD<003ad00@05den06^;YP3blNh0
l_7c0`3Pgn<00`3IeMD003ad0?ooo`0=0?Kgo@D00000203fmod010000000
m_Om0?Kgo@00000A0?Kgo@D000001`3fmod3000000l0m_Om00H0oooo000l
M03Wi^T0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=[H
f@1VQJ40BW6C0;:m`d<0a/GG00@0`<K504Q^T01ZRZ@0knoa0`3Pgn<00`3I
eMD003ad0?ooo`1=0?Slo@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP3HeMH05den0;o7bP150<K5e`030;Jm
_@0GCGh0jn[]00<0h=oS00<0fMGE000lM03oool0C@3moOd01P3oool003ad
0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE
000lM03oool0A@3=c=l00`3oool003ad0>SWjP030>3Oh`030=WEe@00?7@0
oooo04d0oOgm00H0oooo000lM03Vi^T0IVIn0:RY^`3ko?d106IVOP0000L0
IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo04D0d]7T00<0oooo000lM03W
i^T00`3Pgn<00`3He=@003ad0?ooo`1=0?gmo@060?ooo`00?7@0iNGX06IV
OP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?oo
o`150=KGi`030?ooo`00?7@0inKY00<0h=oS00<0fMGE02EGQ@2oc]`0C@3o
ool01P2oc]/09EN50>7Qi01VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm
0:RY^`1VIWh0fMGE000lM03oool03@3If^L5000000<0fM[W0P0000000`3I
f^L000000=WJi`02000000030=WJi`00000000000080fM[W0`0000020=WJ
i`050000003If^L0fM[W0=WJi`000000103If^L00`000000fM[W0=WJi`03
0=WJi`030000003If^L0fM[W00d0fM[W00<0oooo000lM03Wi^T00`3Pgn<0
103IeMD0NIBY05EmXP30cme;0?ooo`070=GOj01EOJ80NIF[0=oMh01VIWh0
Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo
00d0fM[W00<000000=WJi`3If^L00P3If^L00`000000fM[W000000020=WJ
i`80000000D0fM[W0000003If^L0fM[W000000020=WJi`070000003If^L0
fM[W0=WJi`000000fM[W000000030=WJi`030000003If^L0fM[W0080fM[W
00<000000=WJi`3If^L00`3If^L00`000000fM[W0=WJi`0=0=WJi`030?oo
o`00?7@0inKY00<0h=oS00@0f]OI0=oLf01iU:T09EN5B`00?7@01`0GCGh0
IXJQ0>3NfP3Lfmd0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP3IeMD003ad0?ooo`0=0=kOk0030000003Ngn`0g]o/0080g]o/00<0
00000=kOk00000000`3Ngn`00`000000g]o/000000020=kOk0040000003N
gn`0g]o/000000<0g]o/00<000000=kOk00000000`3Ngn`00`000000g]o/
0=kOk0030=kOk0D00000403Ngn`00`3oool003ad0>OVj@030>3Oh`030=oM
h03JemT0f=CD02L0em?D8P3Cc/`30=OCe0070=SDe03IeMD0f]OI0=oMh01V
IWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0
oooo00d0hnG`00<000000>?Ul03SiO000P3SiO000`000000hnG`00000003
0>?Ul0030000003SiO0000000080hnG`00@000000>?Ul03SiO0000000`3S
iO000`000000hnG`000000030>?Ul0030000003SiO00hnG`00<0hnG`00D0
00000>?Ul03SiO00hnG`0000000@0>?Ul0030?ooo`00?7@0inKY05H0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD0
03ad0?ooo`0=0>W[m@D000000P3YjoD01`000000jN_e0>W[m@3YjoD00000
0>W[m@0000000P3YjoD010000000jN_e0>W[m@0000030>W[m@040000003Y
joD0000000000080jN_e00<000000>W[m@3YjoD0103YjoD00`000000jN_e
0000000A0>W[m@030?ooo`00?7@0inKY05H0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0=0?3ao003
0000003`lO`0l?7l0080l?7l00<000000?3ao00000000`3`lO`700000080
l?7l0`0000020?3ao0040000003`lO`00000000000L0l?7l00<000000?3a
o00000004@3`lO`00`3oool003ad0>OVj@1F0>3Oh`0306IVOP2XZK/0nocm
0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool03@3dmOd0
0`000000m?Gm0?Ceo@020?Ceo@030000003dmOd0m?Gm00D0m?Gm00@00000
0?Ceo@3dmOd000004`3dmOd00`000000m?Gm0000000A0?Ceo@030?ooo`00
?7@0inKY00<0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;bm00U0??cm280n?Oh
0P3clo@0203cloD0m?Ce0?GemP3dloD0iNCX06IVOP2XZK/0nocm0@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0=0?Kgo@D00000203f
mod010000000m_Om0?Kgo@00000D0?Kgo@030000003fmod0m_Om0100m_Om
00<0oooo000lM03Wi^T00`3Pgn<0103Ng=l0i>;P07^G[@0UEhE;000lM007
01M=OP1[RjH0l_7^0?;al`1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn0=WEe@00?7@0oooo04D0n?cm00<0oooo000lM03Wi^T00`3P
gn<0103Jf=T0IXFQ02M=Q@1=OL5<06V2kP0602M=Q@1ZRZ@0knoa06IVOP2X
ZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`15
0?gmo@030?ooo`00?7@0inKY00<0h=oS00<0f=GF01M=OP29[N@0CP29[N@0
1@0GCGh0jn[]06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0fMGE000lM03oool0A@3moOd00`3oool003ad0>KVj@030>3Oh`040=WE
e@00?7@0RJgT0?oood/0cLcO00L0oooo08V]i000?7@0j>OZ06IVOP2XZK/0
nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0f=CD000lM03oool0A@3m
oOd00`3oool003ad0>GUj0030>3Oh`040=WEe@00?7@0RjgT0?oood/0d]7T
00L0oooo08^_i@00?7@0inKY06IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0fMGE02EGQ@2oc]`0A@3oool00`2oc]/09EN50>7Qi003
0>3Oh`040=WEe@00?7@0SZoV0?oood/0e]OW00L0oooo08f_i@00?7@0inKY
06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE07VD
Z@1EOJ80`<oM@`3oool0103EgnP0EGfR07VEZ`3OgN030>3Oh`040=WEe@00
?7@0TK7W0?ooo``0fM[W1@0000030=WJi`80000000<0fM[W0000003If^L0
0P0000000`3If^L00000000000020=WJi`<000000P3If^L01@000000fM[W
0=WJi`3If^L0000000@0fM[W1@0000080=WJi`030000003If^L0fM[W00d0
fM[W00L0oooo096aiP00?7@0inKY06IVOP2XZK/0nocm0040IVIn0000201V
IWh0nocm0:RY^`1VIWh0f]OI0=oLf01iU:T09EN5@`00?7@0100GCGh0IXJQ
0>3NfP3Lfmd30>3Oh`040=WEe@00?7@0U;CX0?ooo``0fM[W00<000000=WJ
i`3If^L00P3If^L00`000000fM[W000000020=WJi`80000000D0fM[W0000
003If^L0fM[W000000020=WJi`070000003If^L0fM[W0=WJi`000000fM[W
000000030=WJi`030000003If^L0fM[W0080fM[W00<000000=WJi`3If^L0
0P3If^L00`000000fM[W0=WJi`050=WJi`030000003If^L0fM[W00d0fM[W
00L0oooo09Fdj000?7@0inKY06IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0gmgP0=[Gf@3He=@08`3Gdm@N0=?>c0<0em?D00@0f=CD
0=WEe@3JemT0gmgP0`3Pgn<0103IeMD003ad09RhjP3oool<0=kOk0030000
003Ngn`0g]o/0080g]o/00<000000=kOk00000000`3Ngn`00`000000g]o/
000000020=kOk0040000003Ngn`0g]o/000000<0g]o/00<000000=kOk000
00000`3Ngn`00`000000g]o/0=kOk0020=kOk0030000003Ngn`0g]o/0080
g]o/00<000000=kOk00000000P0000030=kOk0030000003Ngn`0g]o/00d0
g]o/00L0oooo09Rhj@00?7@0inKY06IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWi>0>3Oh`040=WEe@00?7@0W;_Z0?ooo``0hnG`00<0
00000>?Ul03SiO000P3SiO000`000000hnG`000000030>?Ul0030000003S
iO0000000080hnG`00@000000>?Ul03SiO0000000`3SiO000`000000hnG`
000000030>?Ul0030000003SiO00hnG`0080hnG`00<000000>?Ul03SiO00
0P3SiO000`000000hnG`0>?Ul0050>?Ul0030000003SiO00hnG`00d0hnG`
00L0oooo09bkj`00?7@0inKY06IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWi>0>3Oh`040=WEe@00?7@0X;k/0?ooo``0jN_e1@000002
0>W[m@070000003YjoD0jN_e0>W[m@000000jN_e000000020>W[m@040000
003YjoD0jN_e000000<0jN_e00@000000>W[m@00000000000P3YjoD00`00
0000jN_e0>W[m@020>W[m@D00000203YjoD00`000000jN_e0>W[m@0=0>W[
m@070?ooo`2Q_^`003ad0>OVj@1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVInCP3Pgn<0103IeMD003ad0:G1k@3oool<0?3ao0030000
003`lO`0l?7l0080l?7l00<000000?3ao00000000`3`lO`700000080l?7l
0`0000020?3ao0040000003`lO`00000000000D0l?7l00<000000?3ao03`
lO`00P3`lO`00`000000l?7l0?3ao0030?3ao0030000003`lO`0000000l0
l?7l00L0oooo0:G2kP00?7@0inKY06IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWi>0>3Oh`040=WEe@00?7@0ZLG_0?ooo``0m?Gm00<0
00000?Ceo@3dmOd00P3dmOd00`000000m?Gm0?Ceo@050?Ceo@040000003d
mOd0m?Gm00000140m?Gm00<000000?Ceo@3dmOd00P3dmOd00`000000m?Gm
0?Ceo@040?Ceo@8000003`3dmOd01`3oool0ZLG_000lM03Wi^T0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTh0h=oS00@0fMGE000l
M02]b?00oooo303fmod5000000P0m_Om00@000000?Kgo@3fmod000004@3f
mod5000000P0m_Om00<000000?Kgo@3fmod03@3fmod01`3oool0[<O`000l
M03Wi^T0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTh0
h=oS00@0fMGE000lM02abo80ooooB`3ho?d01`3oool0/Lcb000lM03Wi^T0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTh0h=oS00@0
fMGE000lM02dcO<0ooooB`3moOd01`3oool0]Lkc000lM03Wi^T0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTh0h=oS00@0fMGE000l
M02gd?@0ooooB`3moOd01`3oool0^=3e000lM03Vi^T0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTh0h=oS00@0f=CD000lM02jdoD0
ooooB`3moOd01`3oool0^]?f000lM03UiNP0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOTh0h=oS00<0fMGE02EGQ@2le?H0CP2le?H0
1@0UEhD0hN7T06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWi>0>3Oh`030=WEe@1iU:T09df504d0c^Oo00H09df507VEZ`3OgN00IVIn
0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInCP3Pgn<0103JemT0
gmcH07VDZ@0UEhE;000lM00701M=OP1VQZ40h=kJ0=cKg@1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInCP3Pgn<00`3OgN00f]OI0=SD
e00W0=OCe280dlk<0`3Gdm@01`3He=@0fMGE0=[Gf@3OgN00IVIn0:RY^`3k
o?d00@1VIWh0000306IVOP3gmoT0V9RW0:<0MgNB0@2HV:L10?Ogn@40IVIn
00000`1VIWh0moOi0;bmc@2T0;bmc@40moOi0@1VIWh0000306IVOP3gmoT0
i>?S0:@0i>?S0@3gmoT106IVOP0000<0IVIn0?3am03oool0G@3oool00`3T
hn<0W:Bi06]eS`0306]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi
0>CSh`3oool0oooo0>CSh`2LY;T406]eS`0406afT01[MHl0K7J@06afT0T0
JgF?00H0W:Bi0>CSh`3oool0oooo0>cZjP2LY;T40:HiA0040:LjA02V>D@0
YcY40:LjA0T0YSU400<0W:Bi0>cZjP3oool00`3oool10?3am040IVIn0000
5P1VIWh0h^7R0?_lo03kno`0nocm0?cko@3knod0nocm0?_lo03lo?d0o?cl
0?cko@3lo?`0o?_l0?clo03ko?`0o?cl0?_lo@3lno`0o?cm0?_ko@3ko?`2
0?clo0040?clo@3lo?`0no_m0?cloB<0o?_l8@3ko?`00`2LY;T0JgF?08F9
/00@08F9/00606]eS`2LY;T0nocm0?_lo@2LY;T0JgF?4@25RK001P1[MHl0
W:Bi0?_lo03kno`0W:Bi0:HiA140ZSaE00L0YSU409bT^@3ko?`0o?cl0?ck
o@3ko?d0h^7R0040IVIn0000101VIWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kg
n03gmoT0moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3g
moT0103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0moOi0280moOi
8@3fmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[
MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ
3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@01
06IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@000000060?7am03`
l_D0lO7d0?7bm03`l_@0lO7dA03`lOD00`1[MHl0/[G@0:NX`P0@0:NX`P06
0;:ed01[MHl0l?7d0?3am01[MHl0/[G@4@2WZ<801@2b]M00JgF?0?3am@3a
l_@0YSU40080`U9K00<0beAI0<eIGP3=FEh02`3=FEh0103;E5T0`U9K0<9B
F`2V>D@20?3am0030?7am03`l_@0g]gQ0040IVIn00001`1VIWh0g=_P0>[[
l03Zjo00j^c`0>W[k`0000000P3WinL20=kNgP80inOW00<0ikf40>OWi`3W
inL00`3WinL20>o_k`040000003Zjo00j^_`0>[[k`80j^_`00<0j^__0>[[
l03Zjo008@3Zjo0Q0>[/l00406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk6
0:b^aP2][/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`0406]eS`2f^M40
[Jk60:f^aP`0oooo0P2][/H00`2/[/H0][WA06]eS`020>[[l0050:HiA03=
FEh0beAI0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK0<]DF@3=FEh0YSU40>[[
k`3Zjo000P3Zjnl10=cKh040IVIn0000101VIWh0fMWO0>?UjP3Si>X20>?U
j`050000002<S8`0g]kN0>OWi`3Ng]h00P3WinL00`36H`00inOW0>OWi`02
0>OWi`070>o_i`3_knl0kno_0000003Si>X0hnC[0>?UjP020>?TjP030>?T
j`3SiN/0hnG[0240hnG[8@3Si>X01@1[MHl0_;kD0;:bbP2b//X0oooo00H0
KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?
0;bne080/[;:00<0oooo02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0
hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo
00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1V
IWh0000306IVOP3Gf=h0g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OF
cP020>OWi`050<ik003_U100inOW0>ONaP3_S1000`3_knl01`000000g=kV
0=cNi@3Lg^D0g=kV0=cNi@3Lg^H0A03Lg^D01@1[MHl0_l7F0;RicP2h^Lh0
oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3L
g^D0JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool09BDf
0;RicP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40
DbDP00<0oooo1@3FGf<30?ooo`0505<U803DGF40dEYN0<eIGP2V>D@00P3L
g^D00`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn0=GFg@3Ef>00e]SQ0P3E
f>002@000000S8b<0>OWi`3WinL0ikF40=IJ003FQ000olh00<iS00020=i[
00050>neS03_knl0kno_0>o_k`0000000P3Ef>40103Een00e]SP0=KHh@3F
en4S0=KGh240e]SP00D0JgF?0<?5f@2l_M40_;gA0?ooo`0702DU=PL0_;gA
00H0`lGI06]eS`3Ef>40eMSQ06]eS`33aMT20;bmd@030?ooo`0U9CH0_;gA
00L0_;gA00<0oooo02DU=P2l_M400P2l_M401@33aMT0JgF?0=KGh03Een40
YSU40080eEeP00<0f61Q0=UQHP167QX00`3oool30=UQHP<0oooo00<0AQhJ
0=UQHP3HH6400P3EGF001P2V>D@0e]SP0=GHh@3Een00eMSQ0=GFg@40IVIn
00001`1VIWh0d]CM0<oBg03@d]`0d=;M0=3Bg00000000`3WinL0303Wg/h0
aTX00?O>003_[@00kkD00<i[0036FP00aV/00=j<BP3WY@00knO>000000<0
d=;L00<0cm;L0=3Bg03?d]`08`3@d]`Q0<oBg@0306]eS`38bM/0`lCF0100
`lCF00H0b<WK06]eS`3@d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U9CH0
`lCF00L0`lCF00<0oooo02DU=P33a=H00P33a=H01`38bM/0JgF?0<oBg03?
d]`0YSU40=MOG`3IHF800`3LIFD01@167QX0oooo0?ooo`3oool0g6EU00<0
oooo00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?
d]`10=;Dg@40IVIn0000701VIWh0d=;K0<_=f03:cMT0blkH0<[=f0000000
ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU003FS000cV/00>O6003o
eP00knoW0>o_k`000000blgH0<_=f@3:cMT0blkH0<[=f03;cMPS0<_=fB40
blkI00<0JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@04
0<S9f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U
9CH50<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN
06]eS`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0
oooo0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V
>D@0b/kH0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35
b=@01P000000a/K60>ONeP3>N`00ijd00>ne0080ijD000<0eY@00<ic003F
U0000P3gaP020?Ogm`0400000035b=@0aLOD0<G7e0<0aLOE8`34amDQ0<C8
e00306]eS`3@dN00bl_L0100bl_L00H0d=7P06]eS`34am@0a<OD06]eS`3@
dN020<_;g0030?ooo`0U9CH0bl_L00L0bl_L00<0oooo02DU=P3;bm`00P3;
bm`01`3@dN00JgF?0<G7e034am@0YSU40=]TI03OIF@01@3PJVP01@167QX0
oooo0?ooo`3oool0AQhJ00D0h6YX00@0gfET0=]TI02V>D@0a<SE0P34b=@1
0<G7e@40cloJ0@1VIWh0000406IVOP3<c]X0`/CB0<74d@80`LCB00H00000
0>OWi`3WinL0inOW0=J4003_]@020>NU00080=J4003>J`00ijd00?Ne003g
_@00kno_0?Ogm`0000030<74dP030<;4d@31a=80`LCB02<0`LCA8@31a=80
0`1[MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R
0P3?d=d00`3oool09BDf0<o@g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M
00L0dm?R06]eS`32a=80`LCA0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/
J@080>5YI@3KI6@0YSU40<74dP32a=40`LCA0<74dP3<c]X106IVOP0000@0
IVIn0<[<f02n`<l0_L3?0P2n`<h01@000000W9bL0>OWi`3Wg]H0eX`00080
gY@000@0eW/00<IS002m@P00kjD00P3g[@00203g]@00oli:0000002n`<h0
_/3?0;k0cP2n`<l0_L3>902n`<hQ0;g0cP0306]eS`3Fe^@0dm?P0100dm?P
00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo
00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0
h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo103SK6`0103Q
JVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:
f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<003NU000eX@0
0>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3oool000000;Vlc02j^l`0
^Kc;0;Zlb`2i_<`0^Kc;02<0^Kc<8@2j_<`00`1[MHl0f=SU0=?Ch@0@0=?C
h@060=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU0P3Cdn400`3oool0KVf?06i]
S`0806i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0JgF?0;Zlb`2j_<`0YSU4
0>1YJ03QKF`0i75]0>AaK`3TL6h30?ooo`0304HN6P3TL6h0AQhJ00<0oooo
0P3TL6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<0;Zkc02i_</0][S80<W:f001
06IVOP0000T0IVIn0<O9e`2d]/L0][S80;Jhb@2f^LT0000008B4Q03Wimh0
0P3_knl01`36J`00mlH00>ne003_W000gX`00<i[003WW0000`3gmoL01@00
0000][W90;Nhb@2f^LT0]kW90080][S98`2g^<TQ0;Jhb@0406]eS`3Fe^@0
f=SU0=SHiP<0f=SU1@3Hf>H30=SHi@80f=SV0P3Hf>D02@3Fe^@0JgF?0;Nh
b@2g^<T0JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]S`0=02DU=P3Hf>H0f=SU
0=SHi@3Fe^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3TM6l0ig5_0>AdK`030?oo
o`0504HN6P3TM6l0i7A_0>AdK`167QX00`3oool02P3TM6l0ig5_0>AdK`3T
KVd0YSU40;Jib@2f^<T0][W90;Bfa`37bML106IVOP0000<0IVIn0<K8e`2d
]/L00`2d]/L00`000000kno_0>o_k`020>o_k`0;0>N]003gaPP0ijD00>ND
003WS000knOF0=jD>@3_e[D0ooOg0?ooo`000000BP2d]/L01@1[MHl0eMGS
0=cKi`3LfnL0gM_W00h0g=_W00H0eMGS06]eS`2d]/L0];K706]eS`3EeN<2
0=cKi`030=gKi`0U9CH09BDf00T09BDf0`3LfnL02@3EeN<0JgF?0;Bfa`2d
]/L0YSU40>McK`3WMG80jWIc0>YhMP020?ooo`0304HN6P3YOWP0jGih00<0
jGih00P0AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80ig=_0:HiA0@0];K70@36
b=L106IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L01P000000S8b<0>o_k`3_
knl0ilik0>o_k`80moOg00P0ii@00?OWcP3gmoL0moOg0>oWeP3gmoL0oooo
000004X0];K700<0JgF?0=GDh`3PgnX0403PgnX01P3Ee><0JgF?0;Bfa`2d
]/L0JgF?0=GDha40h=oZ00T0eMCS06]eS`2d]/L0];K70:HiA03ZNG<0jGah
0>n1NP3bRH400P167QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<0>fGRP3[V8/0
0P167QX01@3bRH40kh5j0>UlN03ZNG<0YSU400@0];K70@36b=L106IVOP00
00<0IVIn0<K8e`2a/lP00`2a/lP01P000000kno_0>o_k`3_knl0moO_0>o_
k`80moOg00<0mnO60?Ogm`3oool00`3gmoL00`3oool000000;6cb0190;6c
b00306]eS`3]jo<0jNSa0100jNSa00H0kN_c06]eS`2a/lP0/K?806]eS`3]
jo<A0>WXl@0I0>g[l`1[MHl0/K?80;6cb02V>D@0lH1e0?24O03eS8@0mif>
0?:[UP3a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03bZiH0
mif>0?F<Q03`Q7`0lH1e0:HiA0040;6cb040a/SG0@1VIWh0000306IVOP36
b=L0^;O?00<0[jk700D000000:f][@3gmnl0moOg0>o_k`060?Ogm`80ooOg
0P3oool00`000000[jk70:n^a`180:n^a`0306]eS`3BdN<0l_7g0100l_7g
00H0d]7S06]eS`2_[/L0[jk706]eS`3BdN<A0?;am`060=;Ah`1[MHl0[jk7
0:n^a`2V>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0m8Ym0:HiA02_[/L00P2_
[/L10;Rgc`40a/SG0@1VIWh0000306IVOP30`M40alOD05d0[:_400@0Q8bR
06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a00408B<
XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01`2A
V:X0YSU40?nOS@3n_j@0n]bg0?[[]`3jjKH00P3ijKH0103jjKH0nNVf0?WY
]P3jjKH20?WY]P060?[[]`3jg;L0o[nT0?nOS@2V>D@0TIRZ0`2/Zl@10<O7
e040`<7A0@1VIWh0000406IVOP30`M40d];O0;FdbEd0Y:>n00<0Q8bR06]e
S`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP1[MHl0JgF?
00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80YSU40:HiA00?0:Hi
A00708B<XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31d@0106IVOP0000H0IVIn
0:RW_`3Vi^d0d];P0;blc`2a/<BM0:RW_`050;6`a02l_<l0d];P0>KVk@2X
Ykl00@1VIWh0000705QGJ027Qi/0emSR0?clo03ThnP0d=3P0<[:fP2K0;bl
c`060<[:fP3@d>00i>?X0?clo03Gf>80QhNK0@1HEfP0000805QGJ01VIWh0
UIB[0=OHhP3lo?`0l_7c0>c[kP3Qh^^I0=OHhP070>7Rj`3/jnh0l_7c0?cl
o03Gf>80UIB[06IVOP0105QGJ0000P1HEfP00`1VIWh0UIB[0=7AgP020?cl
o9/0oooo0P3lo?`00`3AdMh0UIB[06IVOP0205QGJ0000`1HEfP206IVOP03
08R7W@2EU:/0Z:No09X0Z:No00@0UIB[08R7W@1VIWh0IVIn0`1HEfP000D0
F5MXW`1VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[7]:=",
  Evaluatable->False,
  ImageSize->{169, 109},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutIntro"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]=",
  CellTags->"LayoutIntro"]
}, Open  ]],

Cell["\<\
Here we see how certain types of widgets default to maximize their sizes over \
other types of widgets, which adheres to typical user expectations.\
\>", "Text",
  CellTags->"LayoutIntro"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Frame\>", \
{\[IndentingNewLine]{Widget["\<Label\>", {"\<text\>" -> "\<Label:\>"}], \
\[IndentingNewLine]Widget["\<TextField\>", {"\<text\>" -> "\<Input\>"}]}, \
\[IndentingNewLine]Widget["\<TextArea\>", {"\<text\>" -> "\<Content\>"}]\ }, \
\ Name\  \[Rule] \ "\<myFrame\>"]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"LayoutIntro"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"LayoutIntro"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000BR000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80oooo
0`0000040?ooo`<000000P3oool3000000040?ooo`0000000000000000<0
oooo0`0000030?ooo`@0000000D0oooo00000000000000000?ooo`030000
00<0oooo0`0000130?ooo`0306IVOP2XZK/0nocm0040IVIn00001P1VIWh0
nocm0:RY^`1VIWh0oooo000000<0oooo00@000000?ooo`3oool000000`3o
ool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo000000060?ooo`050000003oool0oooo0?oo
o`0000000`3oool01@000000oooo0?ooo`3oool000000480oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3oool000001P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0103oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool0A03oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2X
ZK/0IVIn0?ooo`0000060?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0
0`3oool500000080oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo04@0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000606IV
OP3ko?d0Z:Vk06IVOP3oool000001P3oool01@000000oooo0?ooo`3oool0
00000080oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000001@3o
ool01@000000oooo0?ooo`3oool000000080oooo0P0000020?ooo`050000
003oool0oooo0?ooo`000000AP3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00H0IVIn0?_lo@2XZK/0IVIn0?ooo`0000070?ooo`<000000P3oool20000
00030?ooo`000000000000<0oooo1@0000030?ooo`<000000P3oool20000
00030?ooo`000000000000<0oooo1@0000130?ooo`0306IVOP2XZK/0nocm
0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0oooo000000<0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
oooo04@0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP80oooo1000001]0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWhP0>3Ohe<0YJbb00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOR00h=oS00<0YJbb0?ooo`3oool0C`3oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn803P
gn<00`2U[;80oooo0?ooo`1?0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWhP0>3Oh`030:F//P3oool0oooo00<0oooo
00<000000?ooo`3oool0B@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn803Pgn<00`2U[;80oooo0?ooo`030?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0@@3oool0102U[;80
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn803Pgn<00`2U
[;80oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0@@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn1@0000020>3Oh`80000000D0h=oS0000003Pgn<000000>3O
h`02000000<0h=oS0`0000020>3Oh`030000003Pgn<0000000D0h=oS00<0
YJbb0?ooo`3oool00`3oool00`000000oooo000000030?ooo`040000003o
ool000000?ooo`8000000`3oool2000000030?ooo`000000oooo00800000
=P3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn000000050>3Oh`030000003Pgn<0h=oS0080000000<0h=oS00000000
00000P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000L0
h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo000000030?ooo`04
0000003oool0000000000080oooo00<000000?ooo`0000000P3oool20000
00030?ooo`000000oooo03H0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP0000001@3Pgn<01`000000h=oS0>3Oh`3P
gn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000050>3Oh`030000
003Pgn<0h=oS00D0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`000000
0`3oool00`000000oooo0000000g0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000H0h=oS100000000`3Pgn<0
00000>3Oh`020>3Oh`030000003Pgn<0000000@0000000<0h=oS0000003P
gn<01P3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`03
0000003oool0000003L0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP0000001@3Pgn<01P000000h=oS0>3Oh`3Pgn<0
00000>3Oh`8000000P3Pgn<00`000000h=oS000000030>3Oh`030000003P
gn<0000000L0h=oS00<0YJbb0?ooo`3oool00`3oool010000000oooo0000
000000020?ooo`040000003oool0000000000080oooo00<000000?ooo`00
00000`3oool00`000000oooo0000000g0?ooo`040:F//P1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000H0h=oS0`0000020>3O
h`040000003Pgn<00000000000<0h=oS0`0000020>3Oh`030000003Pgn<0
000000D0h=oS00<0YJbb0?ooo`3oool00`3oool010000000oooo0000003o
ool200000080oooo00@000000?ooo`00000000000P3oool010000000oooo
0?ooo`3oool4000003H0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP0000002`3Pgn<00`000000h=oS0>3Oh`090>3O
h`030000003Pgn<0h=oS00D0h=oS00<0YJbb0?ooo`3oool00`3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo03D0oooo00@0YJbb06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000002`3Pgn<0
0`000000h=oS0>3Oh`090>3Oh`030000003Pgn<0h=oS00D0h=oS00<0YJbb
0?ooo`3oool00`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo03D0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOR00h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?oo
o`190?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWhP0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0
B@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn803Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo04T0
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OR00h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`190?oo
o`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhP
0>3Oh`030:F//P3oool0oooo04l0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOR00h=oSD`2U[;800`1VIWh0Z:Vk0?_l
o@0106IVOP0000<0IVIn0?Ogn@2HV:L0M@1gMi8109RHY`40moOi0@1VIWh0
000306IVOP3gmoT0_;g=07H0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3T
hn<0MP3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`0_0?ooo`030>CS
h`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0
i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[
MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W
>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F
06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0
o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080
o?cl00@0o?cm0?clo03knod0o?cm503lno`20?_lo00309bT^@1[MHl0QHV`
0100QHV`00H0JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9/00606]eS`2L
Y;T0nocl0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_lo03lo?`0o?_m
0?_lo@3RhN800@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0m_Oh
0?Ogn@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi0?Kgn@020?Og
n@040?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3gmoT04`3gmoT2
0?Kgn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi06]e
S`25RK0A09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=
0<IEG0090<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q0040
IVIn00001P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm100000000H0lO7d0?3b
m@3alO@0lO;d0?3bm03alO@F0?3am@0306]eS`2b]M00YjS20100YjS200H0
/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e0?7b
m02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0`U9K
0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3Lfn00j^_`
0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0inOW0>OW
i`030>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`
0>[[l00B0>[[l080j^c`00@0JgF?0;Jid@2][/H0[Jk6203oool00`2][/H0
[:k60:f^aP030:f^aP030:b^aP2f^M40JgF?0080j^__00@0JgF?0;Jid@2]
[/H0[Jk6303oool20:f^aP030:b^aP2f^M40JgF?0080j^_`00D0YSU40<eI
GP3;E5T0cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0j^__
0>[[l0020>[[k`40g=_P0@1VIWh0000406IVOP3IfMl0hnGZ0>?TjP80hnG[
00D0000008b<S03Ng]h0inOW0=kNgP020>OWi`030<IS003WinL0inOW0080
inOW00L0knoW0>o_k`3_knl000000>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[
0>?Uj`3SiN/04P3SiN/20>?TjP0506]eS`2l_]@0/[;:0;:bbP3oool01P1^
KHl00`0U9CH0/[;:0;:bbP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[MHl0
_;kD0P2b//X00`3oool09BDf02DU=P0902DU=P<0/[;:00D0_;kD06]eS`3S
i>/0hnC[0:HiA0020<eIGP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3oool0
2P3DG5l0d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl106IV
OP0000<0IVIn0=OHgP3Lg^H00`3Lg^H01@000000inOW0>OWi`3WinL0imK>
0080inOW00D0cW/00>nD403WinL0imk60>n<40030>o_k`070000003Lg^H0
g=kU0=cNi@3Lg^H0g=kU0=cNiP0F0=cNi@0506]eS`2o`MH0^;W>0;RicP3o
ool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU0=cN
i@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U9CH0
^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C
9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA0020=cN
i@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>420=GH
h0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080gV/0
00D0kkF<0>o_k`3_knl0kno_000000020=GHh@040=GGh03Ff>00e]SQ0=KG
hA@0e]OP0P3Ff>001@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M40
1P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M40
1`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V
>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0
fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0
000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36
BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@
d]`00`3?d]`0d=;L0<oBg00D0=3Bg080cm;M00<0JgF?0<S9f`33a=H04033
a=H01P38bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80`lCF00<0oooo02DU=P33
a=H01`33a=H00`3oool09BDf0<?4eP020<?4eP070<S9f`1[MHl0cm;L0<oB
g02V>D@0eemO0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3o
ool020167QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`10<oB
g040d]CM0@1VIWh0000L06IVOP3@d]/0blgH0<[=f@3;c]P0b/gH0000003W
aZd0ilJ<0?O>603__@00mlH00>n]003W[@00ijD00=J<003>J`00ilH00?oF
003_knL0kno_0000003;cMP0blgI0<[=f@3;c]P0b/gH0<_=f1@0blgI0P3;
c]T00`1[MHl0blcN0<S:f@080<S:f@030<S9f@38b]T0b<[I00<0b<[I00@0
b<WI0<S:f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN0<S:f@38b]T0oooo02DU
=PD0b<[I0140b<WI0<S:f@38b]T0oooo02DU=P38b]T0b<WI0<S:f@3;c=h0
JgF?0<_>f03:cMP0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN6P3o
ool0oooo00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO0:Hi
A03:c]P0b/kI0P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0030<G8
e00600000036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD
00020?O60080moOg00@000000<G8e035am@0aLOD0`35amDD0<C7e@80a<SD
00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3A
h080bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;
g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3o
ool0oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040
aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000
inOW0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm
003_knl0moOg000000<0`LCB00<0`/CA0<74dP31a=805031a=420<74dP03
06]eS`3Cdn80cm3M0100cm3M00H0dm?R06]eS`32a=80`/CB06]eS`3Cdn82
0<o@g@030?ooo`0U9CH0cm3M00L0cm3M00<0oooo02DU=P3?d=d00P3?d=d0
1`3Cdn80JgF?0<;4dP31a=40YSU40=]TI03QJFD01@3PK6T50?ooo`D0h6aY
00P0hFUU0=]TI02V>D@0`LCB0<;4d@31a=40`LCB0<c>fP40IVIn0000101V
IWh0b/cH0;k0c`2m`<l20;k0cP050000002LW9`0inOW0>ONeP3FS0000P3N
U000103FN`00aV<00;e2003_Y@020?N]00080?Ne003ocTX000000;k0cP2n
`<l0_/3>0;k0c`2m`<hE0;k0cP80_L3>00<0JgF?0=KFi03Cdn00403Cdn00
1P3Fe^@0JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3oool0
203oool02`0U9CH0dm?P0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:HiA03P
IVD0hFYZ00@0hfa/0`3oool010167QX0oooo0?ooo`3oool40>=/K0040>5Z
JP3PIVD0YSU40;g0c`80_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0bL[H
0;Jhb02i_</0^[c;0;Zlc00000000P3_knl04`3FW000eX`00=jD003FQ000
kjD00=j<002mFP00eW<00>nL003gknL0moOg0?ooo`000000^Kc<0;Zkc02i
_</0^[c;0;Vlc02i_</0502i_<`20;Zlc00306]eS`3Hf>D0dm?Q0100dm?Q
00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?
00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0
h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3oool2
0>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H0040
IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OWgP02
0>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Ogm`050000
002f^LT0]kS90;Jib@2g^LT00P2f^<TD0;Nhb@80][S900@0JgF?0=KFi03H
f>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@090=KFi01[MHl0]kS9
0;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d09BDf0=SHiP3Hf>D0
f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo
00D0AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^
K@2V>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn00000`1VIWh0a/SG0;Bf
a`030;Bfa`030000003_knl0kno_0080kno_00/0ijd00?O6203WY@00ii@0
0>N<003_imH0gY@i0>oF]@3omoL0oooo0000000L0;Bfa`0506]eS`3EeN<0
g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80
g=_W00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GEh`1[MHl0];K70;Bf
a`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ0>UnN03YOWP00`3Y
OWP020167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d]/L10<K8
e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`060000002<S8`0kno_0>o_
k`3WcW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool0
0000702d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0];K70;Bf
a`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0YSU40>YiL`3YO7P0
kh5j0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:0>^HR`02
04HN6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L10<K8e`40IVIn0000
0`1VIWh0a/SG0;6cb0030;6cb0060000003_knl0kno_0>o_k`3gmnl0kno_
0P3gmoL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`000000/K?801/0/K?8
00<0JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[
la40jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0
lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3g
WHh0mHb40?24O03aP7D0YSU400@0/K?80@36b=L106IVOP0000<0IVIn0<K8
e`2h]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3omoL2
0?ooo`030000002_[/L0[jk701X0[jk700<0JgF?0=;Ah`3blOL0403blOL0
1P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0d]7S06]eS`2_[/L0
[jk70:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^a`020:n^
a`40^;O?0@36b=L106IVOP0000<0IVIn0<31d@37am@0;`2/Zl@01024S:80
JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400@0Q8bR
06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a007096H
ZP2V>D@0oin=0?joY03jg;L0n^^g0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf
0?[Y]P80nNVf00H0n^^g0?[L]`3n_j@0oin=0:HiA02AV:X30:b[a040alOD
0@30`M4106IVOP0000@0IVIn0<31d@3Bd]l0]KC9;`2TXkh00`24S:80JgF?
06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]eS`1[MHl0
3`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V>D@0YSU400l0YSU4
00L0Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040IVIn00001P1VIWh0
Z:No0>KVk@3Bd^00_;c?0;6`a6l0Z:No00D0/K340;blc`3Bd^00i^K]0:RW
_`0106IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@d>00b/[J06d0_;c?
00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ00000P0F5MX06IVOP2E
U:/0emSR0?clo03blO<0k>_^0>7Rjf/0emSR00L0hN;[0>c[kP3blO<0o?cl
0=OHhP2EU:/0IVIn0040F5MX000205QGJ00306IVOP2EU:/0dM7N0080o?cl
K@3oool20?clo0030=7AgP2EU:/0IVIn0080F5MX000305QGJ080IVIn00<0
R8NM09FDZ`2XYkl0K02XYkl0102EU:/0R8NM06IVOP1VIWh305QGJ0001@1H
EfQa06IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[9]:=",
  Evaluatable->False,
  ImageSize->{123, 74},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutIntro"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]=",
  CellTags->"LayoutIntro"]
}, Open  ]],

Cell["\<\
Note that with the new size of the window, the defaults cause the text field \
to resize horizontally, while the text area expands in both directions:\
\>", "Text",
  CellTags->"LayoutIntro"],

Cell[BoxData[
    \(ref\ @\ 
      Script[\[IndentingNewLine]SetPropertyValue[{"\<myFrame\>", \ \
"\<size\>"}, \ \[IndentingNewLine]Widget["\<Dimension\>", \ {"\<width\>" \
\[Rule] 250, \ "\<height\>" \[Rule] 
                150}]]; \[IndentingNewLine]InvokeMethod[{"\<myFrame\>", \ \
"\<validate\>"}];\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"LayoutIntro"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"LayoutIntro"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003j0000UR000`400?l0
0000o`00003onP1VIWh0000306IVOP3ko?d0nocm0?H0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0?D0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
m01VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80oooo
0`0000040?ooo`<000000P3oool3000000040?ooo`0000000000000000<0
oooo0`0000030?ooo`@0000000D0oooo00000000000000000?ooo`030000
00<0oooo0`0000320?ooo`0306IVOP2XZK/0nocm0040IVIn00001P1VIWh0
nocm0:RY^`1VIWh0oooo000000<0oooo00@000000?ooo`3oool000000`3o
ool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo000000060?ooo`050000003oool0oooo0?oo
o`0000000`3oool01@000000oooo0?ooo`3oool000000<40oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3oool000001P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0103oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool0``3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2X
ZK/0IVIn0?ooo`0000060?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0
0`3oool500000080oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo0<<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000606IV
OP3ko?d0Z:Vk06IVOP3oool000001P3oool01@000000oooo0?ooo`3oool0
00000080oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000001@3o
ool01@000000oooo0?ooo`3oool000000080oooo0P0000020?ooo`050000
003oool0oooo0?ooo`000000a@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00H0IVIn0?_lo@2XZK/0IVIn0?ooo`0000070?ooo`<000000P3oool20000
00030?ooo`000000000000<0oooo1@0000030?ooo`<000000P3oool20000
00030?ooo`000000000000<0oooo1@0000320?ooo`0306IVOP2XZK/0nocm
0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0oooo000000<0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
oooo0<<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP80oooo1000003/0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWhP0>3Ohm80YJbb00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOR00h=oS00<0YJbb0?ooo`3oool0cP3oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn803P
gn<00`2U[;80oooo0?ooo`3>0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWhP0>3Oh`030:F//P3oool0oooo00<0oooo
00<000000?ooo`3oool0b03oool0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn803Pgn<00`2U[;80oooo0?ooo`030?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0`03oool0102U[;80
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn803Pgn<00`2U
[;80oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0`03oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn1@0000020>3Oh`80000000D0h=oS0000003Pgn<000000>3O
h`02000000<0h=oS0`0000020>3Oh`030000003Pgn<0000000D0h=oS00<0
YJbb0?ooo`3oool00`3oool00`000000oooo000000030?ooo`040000003o
ool000000?ooo`8000000`3oool2000000030?ooo`000000oooo00800000
]@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn000000050>3Oh`030000003Pgn<0h=oS0080000000<0h=oS00000000
00000P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000L0
h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo000000030?ooo`04
0000003oool0000000000080oooo00<000000?ooo`0000000P3oool20000
00030?ooo`000000oooo0;D0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP0000001@3Pgn<01`000000h=oS0>3Oh`3P
gn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000050>3Oh`030000
003Pgn<0h=oS00D0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`000000
0`3oool00`000000oooo0000002f0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000H0h=oS100000000`3Pgn<0
00000>3Oh`020>3Oh`030000003Pgn<0000000@0000000<0h=oS0000003P
gn<01P3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`03
0000003oool000000;H0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP0000001@3Pgn<01P000000h=oS0>3Oh`3Pgn<0
00000>3Oh`8000000P3Pgn<00`000000h=oS000000030>3Oh`030000003P
gn<0000000L0h=oS00<0YJbb0?ooo`3oool00`3oool010000000oooo0000
000000020?ooo`040000003oool0000000000080oooo00<000000?ooo`00
00000`3oool00`000000oooo0000002f0?ooo`040:F//P1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000H0h=oS0`0000020>3O
h`040000003Pgn<00000000000<0h=oS0`0000020>3Oh`030000003Pgn<0
000000D0h=oS00<0YJbb0?ooo`3oool00`3oool010000000oooo0000003o
ool200000080oooo00@000000?ooo`00000000000P3oool010000000oooo
0?ooo`3oool400000;D0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP0000002`3Pgn<00`000000h=oS0>3Oh`090>3O
h`030000003Pgn<0h=oS00D0h=oS00<0YJbb0?ooo`3oool00`3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo0;@0oooo00@0YJbb06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000002`3Pgn<0
0`000000h=oS0>3Oh`090>3Oh`030000003Pgn<0h=oS00D0h=oS00<0YJbb
0?ooo`3oool00`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo0;@0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOR00h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?oo
o`380?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWhP0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0
b03oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn803Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo0<P0
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OR00h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`380?oo
o`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhP
0>3Oh`030:F//P3oool0oooo0<h0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOR00h=oSdP2U[;800`1VIWh0Z:Vk0?_l
o@0106IVOP0000<0IVIn0?Ogn@2HV:L0m01gMi8109RHY`40moOi0@1VIWh0
000306IVOP3gmoT0_;g=0?D0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3T
hn<0m@3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`2^0?ooo`030>CS
h`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0
i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[
MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W
>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F
06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0
o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080
o?cl00@0o?cm0?clo03knod0o?cm?P3lno`o0?_lo1P0nocm00<0W:Bi06]e
S`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0
JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?cl
o03lnod0nocm0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT0
2`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi
0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0m
0?OgnCl0m_Oi603gmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0
moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:Xl
E@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0
moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@0000
00060?7am03`l_D0lO7d0?7bm03`l_@0lO7dO@3`lODH0?3am00306]eS`2b
]M00YjS20100YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P05
0;:ed01[MHl0l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eI
GP040<]DF@32DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0
000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3W
inL00`3W_H@0inOW0>OWi`030>OWi`80kno_00@000000>[[l03Zjo00j^__
0P3Zjo000`3Zjnl0j^_`0>[[l00l0>[[l3l0j^c`603Zjnl0101[MHl0][WA
0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[
MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Ji
d@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO
0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0
IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080
inOW00<0aV<00>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ
0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0l0>?Ujcl0hnCZ603SiNX0
1@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b
//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U
9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@
Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:Hi
A03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0
g=kV00D000000>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW
0>ONaP3_S1000`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H0
U@3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h
^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo
02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0
g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`05
05<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IV
OP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0
ikF40=IJ003FQ000olh00<iS00020=i[00050>neS03_knl0kno_0>o_k`00
00000P3Ef>40103Een00e]SP0=KHh@3Fen4n0=KGh3l0e]SP603Ef>401@1[
MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?0=GHh@3E
f>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M401`2l_M400`3oool09BDf
0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V>D@00P3EGF000`3HH640
fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@020=EMH006
0:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0000706IVOP3Be=d0cm;L
0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36BP00mlh00>n]003_]@00
cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@d]`00`3?d]`0d=;L0<oB
g00n0=3Bg3l0cm;M603@d]`00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[
MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP03
0?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0
fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3L
IFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IV
OP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH
0>nm003gaP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl0
00000<_=f03;cMT0b/gI0<_>f03:cMP0blgH?P3;cMTo0<_>fAP0blgH00<0
JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38
b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:
f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;
c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?oo
o`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH
0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P00
0000a/K60>ONeP3>N`00ijd00>ne0080ijD000<0eY@00<ic003FU0000P3g
aP020?Ogm`0400000035b=@0aLOD0<G7e0<0aLOE?P34amDo0<C8e1P0a<OD
00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3A
h080bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;
g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3o
ool0oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040
aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000
inOW0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm
003_knl0moOg000000<0`LCB00<0`/CA0<74dP31a=80?P31a=4o0<74dQP0
`/CB00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?
0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@02
0<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo
1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh0
000406IVOP3:c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<
00020=jD00040=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>BP000000
_/3>0;k0c`2n`<h0_/3?0;g0cSl0_/3>?`2m`<hH0;k0cP0306]eS`3Fe^@0
dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?oo
o`0U9CH0oooo00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?
0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo
103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP00
00L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<
003NU000eX@00>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3oool00000
0;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;03h0^Kc<?`2j_<`H0;Zlb`0306]e
S`3Hf>D0dm?Q0100dm?Q00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?C
h@030?ooo`1^KHl0KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[
MHl0^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ
0>A`KP167QX00`3oool20>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<
0;Vlb`2f^<P0bL[H0040IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Ji
b@000000Q8B40>OWgP020>o_k`070<I[003gaP00kkD00>nL003NS000cV/0
0>NL00030?Ogm`050000002f^LT0]kS90;Jib@2g^LT00P2f^<Tn0;NhbCl0
][S9602g^<T0101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SH
iP80f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool0
2P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03T
KVd0i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0
oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG
0@1VIWh0000306IVOP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_
knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool0
000009/0];K700D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[
MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0
g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3o
ool00`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0
igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0
];K700H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0
moOg0?Ogm`3_imH0moOg0?ooo`00002K0;Bfa`0306]eS`3Ee><0h=oZ0100
h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0
];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]
UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:Hi
A0040;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H00000
0>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg
00<0oooo0000002a/lP0VP2a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[
l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0
YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/
]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP1
0<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_
0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L0V@2_[/L0
0`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S
4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@
Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0
`<7A0<O7e02^0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;
g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<
bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf
0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03o
Whd0YSU4096HZP<0[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;B
g`2e]<V^0:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh0
0P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n
00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;B
g`30`M400@1VIWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34kP2XYkl0
1@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3l
o?`0i>?X0=3@h03:b]X0k02l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7
V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[jP3G
f>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX
00<0IVIn09FDZ`3AdMh00P3lo?c/0?ooo`80o?cl00<0dM7N09FDZ`1VIWh0
0P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW_`3[0:RW_`0409FDZ`28
Qid0IVIn06IVOP<0F5MX000505QGJ?00IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[11]:=",
  Evaluatable->False,
  ImageSize->{250, 150},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutIntro"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]=",
  CellTags->"LayoutIntro"]
}, Open  ]],

Cell[TextData[{
  "When simple nesting of widgets is not enough to achieve the desired layout \
or resizing characteristics, there are a number of additional ",
  StyleBox["Widget", "Output"],
  " interface definition expressions and options that can aid in tweaking the \
results. Namely, the additional definition expressions include ",
  StyleBox["WidgetGroup", "Output"],
  ", ",
  StyleBox["WidgetFill", "Output"],
  ", ",
  StyleBox["WidgetSpace", "Output"],
  ", ",
  StyleBox["WidgetAlign", "Output"],
  ", and the ",
  StyleBox["Widget", "Output"],
  " and ",
  StyleBox["WidgetGroup", "Program"],
  " options that can choose alternate default values for features, such as ",
  StyleBox["\"Stretching\"", "Output"],
  ", ",
  StyleBox["\"Alignment\"", "Output"],
  ", ",
  StyleBox["\"Grouping\"", "Output"],
  ", ",
  StyleBox["\"Spacing\"", "Output"],
  ", and ",
  StyleBox["\"Border\"", "Output"],
  " elements."
}], "Text",
  CellTags->"LayoutIntro"],

Cell["\<\
These additional expressions and options are introduced through the following \
visual examples.\
\>", "Text",
  CellTags->"LayoutIntro"]
}, Open  ]],

Cell[CellGroupData[{

Cell["WidgetGroup", "Subsection",
  CellTags->"WidgetGroup-Layout"],

Cell[TextData[{
  "When the default layout alignment based on the depth of the list nesting \
is not appropriate, you can use the form ",
  StyleBox["WidgetGroup", "Program"],
  StyleBox["[{", "Output"],
  "...",
  StyleBox["}, WidgetLayout -> Row]", "Output"],
  " or ",
  StyleBox["WidgetGroup[{", "Output"],
  "...",
  StyleBox["}, WidgetLayout -> Column]", "Output"],
  " to explicitly specify the next alignment."
}], "Text",
  CellTags->"WidgetGroup-Layout"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["{", "Output"],
  StyleBox["...", "Text"],
  StyleBox["}", "Output"],
  " is simply a shorthand form of ",
  StyleBox["WidgetGroup[{", "Output"],
  StyleBox["...", "Text"],
  StyleBox["}, WidgetLayout -> Automatic]", "Output"],
  ".\n\[FilledSmallSquare] ",
  StyleBox["WidgetGroup[{", "Output"],
  StyleBox["...", "Text"],
  StyleBox["}, WidgetLayout -> Row] ", "Output"],
  StyleBox["explicitly forces a horizontal layout of the child widgets", 
    "Text"],
  ".",
  StyleBox["\n", "Text"],
  "\[FilledSmallSquare] ",
  StyleBox["WidgetGroup[{", "Output"],
  StyleBox["...", "Text"],
  StyleBox["}, WidgetLayout -> Column] ", "Output"],
  StyleBox["explicitly forces a vertical layout of the child widgets", 
    "Text"],
  "."
}], "FramedBox",
  CellTags->"WidgetGroup-Layout"],

Cell[TextData[{
  "The basic forms of ",
  StyleBox["WidgetGroup", "MR"],
  " usage."
}], "Caption",
  CellTags->"WidgetGroup-Layout"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WidgetGroup[{", "Output"],
  StyleBox["group", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[", group", "Output"],
  Cell[BoxData[
      \(TraditionalForm\`\_2\)]],
  StyleBox[",", "Output"],
  StyleBox["...", "Text"],
  StyleBox["}, \n\tWidgetLayout -> {\"Grouping\" \[Rule] {Tabs, {\"Tab Label",
     "Output"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox["\", \"Tab Label", "Output"],
  Cell[BoxData[
      \(TraditionalForm\`\_2\)]],
  StyleBox["\",", "Output"],
  StyleBox["...", "Text"],
  StyleBox["}} }] \n  ", "Output"],
  StyleBox["will place the labeled tabs at the top of the generated tab pane. \
\n", "Text"],
  "\[FilledSmallSquare] ",
  StyleBox["We can also use the form: ", "Text"],
  StyleBox["\"Grouping\" \[Rule] {Tabs, Top, {\"Tab Label", "Output"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox["\", \"Tab Label", "Output"],
  Cell[BoxData[
      \(TraditionalForm\`\_2\)]],
  StyleBox["\",", "Output"],
  StyleBox["...", "Text"],
  StyleBox["}} \n  ", "Output"],
  StyleBox["replacing", "Text"],
  StyleBox[" Top ", "Output"],
  StyleBox["with either ", "Text"],
  StyleBox["Left, Right, ", "Output"],
  StyleBox["or", "Text"],
  StyleBox[" Bottom", "Output"],
  "."
}], "FramedBox",
  CellTags->"WidgetGroup-Layout"],

Cell["Groups displayed in tabbed panes.", "Caption",
  CellTags->"WidgetGroup-Layout"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WidgetGroup[{", "Output"],
  StyleBox["group", "MR"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[", group", "Output"],
  Cell[BoxData[
      \(TraditionalForm\`\_2\)]],
  StyleBox["}, WidgetLayout -> Split, Name -> \"mySplitPane\"] \n  ", 
    "Output"],
  StyleBox["will place a resizable split bar between the two groups and \
optionally name the generated split pane as", "Text"],
  StyleBox[" \"mySplitPane\" ", "MR"],
  StyleBox["for further interaction at runtime with the split pane \
properties.\n", "Text"],
  "\[FilledSmallSquare] ",
  StyleBox["We can also use the following forms. \n  ", "Text"],
  StyleBox["WidgetLayout -> {\"Grouping\" \[Rule] {Split, Vertical}}\n \
WidgetLayout -> {\"Grouping\" \[Rule] {Split, Horizontal}}", "Output"]
}], "FramedBox",
  CellTags->"WidgetGroup-Layout"],

Cell["Groups displayed in split panes.", "Caption",
  CellTags->"WidgetGroup-Layout"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WidgetGroup[{{", "Output"],
  StyleBox["...", "Text"],
  StyleBox["},{", "Output"],
  StyleBox["...", "Text"],
  StyleBox["},", "Output"],
  StyleBox["...", "Text"],
  StyleBox["}, WidgetLayout -> Grid] ", "Output"],
  StyleBox["explicitly requests a grid of evenly aligned elements as an \
alternative to multiple nested row and column lists, but this form has some \
limits as to resizing and staggering of child widget lists.", "Text"]
}], "FramedBox",
  CellTags->"WidgetGroup-Layout"],

Cell["Grid-based groupings.", "Caption",
  CellTags->"WidgetGroup-Layout"],

Cell["\<\
We can override what would normally be a vertical layout by explicitly \
choosing a top-level row layout.\
\>", "Text",
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", 
            WidgetGroup[{\[IndentingNewLine]Widget["\<Button\>", {"\<text\>" -> \
"\<Button A\>"}], \[IndentingNewLine]Widget["\<Button\>", {"\<text\>" -> \
"\<Button B\>"}], \[IndentingNewLine]Widget["\<Button\>", {"\<text\>" -> \
"\<Button C\>"}]\ }, \ 
              WidgetLayout \[Rule] 
                Row]\[IndentingNewLine]]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003[0000>B000`400?l0
0000o`00003ojP1VIWh10?ooo`0000<0IVIn0?_lo@3ko?d0i`3ko?d10?oo
o`0000<0IVIn0?_lo@2XZK/0iP2XZK/10?_lo@40oooo00000`1VIWh0nocm
0:RY^`3U06IVOP40Z:Vk0@3ko?d10?ooo`0000T0IVIn0?_lo@2XZK/0IVIn
0>7Pi03ViNP0k>_^0?3`lP3bl_@08@3clo@N0?Sgn080lo?d00D0lo?e0?Cd
m@3emOH0m??e0>GTj0030>3Oh`050>7Pi03ViNP0k>_^0?3`lP3bl_@0803c
lo@M0?Sgn080lo?d00D0lo?e0?Cdm@3emOH0m??e0>GTj0030>3Oh`050>7P
i03ViNP0k>_^0?3`lP3bl_@0803clo@M0?Sgn080lo?d00P0lo?e0?Cdm@3e
mOH0m??e0>GTj01VIWh0Z:Vk0?_lo@40oooo0000201VIWh0nocm0:RY^`1V
IWh0g]cO0>CRh01kUjd09EN5@`00?7@0100GCGh0Jh^V0?;akP3blO<30>3O
h`040=kLg`3Th^00NiN]02EGQD4003ad00@05den06^;YP3blNh0l_7c0`3P
gn<0103Ng=l0i>;P07^G[@0UEhE1000lM00701M=OP1[RjH0l_7^0?;al`1V
IWh0Z:Vk0?_lo@010?ooo`0000P0IVIn0?_lo@2XZK/0IVIn0=[Hf@1VQJ40
9df504em`D@0JH;^00<09df506Z:Y03_ko400`3Pgn<0103Jf=T0IXFQ04Ya
T`2b_L=10<K5e`040<36a@18KY00JXZT0>o_l@<0h=oS00@0f]SI06J5X@1:
LI<0/[g3@@36aML01`30a/D0B6j@06Z:Y03_ko40IVIn0:RY^`3ko?d00@3o
ool0000606IVOP3ko?d0Z:Vk06IVOP3HeMH05denA`29[N@00`0GCGh0jn[]
0>3Oh`020>3Oh`030=SEeP0GCGh0_lO:04<0a/GG00<0][fm01M=OP3[j^d0
0`3Pgn<00`3HeMH05den0;o7bP130<K5e`060;Jm_@0GCGh0jn[]06IVOP2X
ZK/0nocm0@3oool0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad08V]i03o
oom30<g<g`040?ooo`29[N@003ad0>SWjP<0h=oS00<0fMGE000lM03oool0
@`3=c=l00`3oool003ad0>SWjP030>3Oh`030=WEe@00?7@0oooo04<0cLcO
00H0oooo000lM03XinX0IVIn0:RY^`3ko?d10?ooo`0000P0IVIn0?_lo@2X
ZK/0IVIn0=WEe@00?7@0RjgT0?oood<0d]7T00@0oooo08^_i@00?7@0inKY
0`3Pgn<00`3IeMD003ad0?ooo`130=;Ai0030?ooo`00?7@0inKY00<0h=oS
00<0fMGE000lM03oool0@`3BdN@01P3oool003ad0>OVj@1VIWh0Z:Vk0?_l
o@40oooo0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM02>[nH0oooo@`3F
enL0103oool0SJoU000lM03Wi^T30>3Oh`030=WEe@00?7@0oooo04<0e]OW
00<0oooo000lM03Wi^T00`3Pgn<00`3IeMD003ad0?ooo`130=KGi`060?oo
o`00?7@0inKY06IVOP2XZK/0nocm0@3oool0000806IVOP3ko?d0Z:Vk06IV
OP3IeMD003ad096ai`3oool<0=WJi`D000000`3If^L2000000030=WJi`00
0000fM[W0080000000<0fM[W0000000000000P3If^L300000080fM[W00D0
00000=WJi`3If^L0fM[W000000040=WJi`030000003If^L0fM[W00<0fM[W
00<000000=WJi`3If^L0303If^L0103oool0TK7V000lM03Wi^T30>3Oh`03
0=WEe@00?7@0oooo00d0fM[W1@0000030=WJi`80000000<0fM[W0000003I
f^L00P0000000`3If^L00000000000020=WJi`<000000P3If^L01@000000
fM[W0=WJi`3If^L0000000@0fM[W1@00000?0=WJi`030?ooo`00?7@0inKY
00<0h=oS00<0fMGE000lM03oool03@3If^L5000000<0fM[W0P0000000`3I
f^L000000=WJi`02000000030=WJi`00000000000080fM[W0`0000020=WJ
i`050000003If^L0fM[W0=WJi`0000001P3If^L3000000l0fM[W00H0oooo
000lM03Wi^T0IVIn0:RY^`3ko?d10?ooo`0000P0IVIn0?_lo@2XZK/0IVIn
0=WEe@00?7@0U;CX0?ooo``0fM[W00<000000=WJi`3If^L00P3If^L00`00
0000fM[W000000020=WJi`80000000D0fM[W0000003If^L0fM[W00000002
0=WJi`070000003If^L0fM[W0=WJi`000000fM[W000000030=WJi`030000
003If^L0fM[W0080fM[W00<000000=WJi`3If^L00`3If^L00`000000fM[W
0=WJi`0<0=WJi`040?ooo`2E]>P003ad0>OVj@<0h=oS00<0fMGE000lM03o
ool03@3If^L00`000000fM[W0=WJi`020=WJi`030000003If^L000000080
fM[W0P0000001@3If^L000000=WJi`3If^L000000080fM[W00L000000=WJ
i`3If^L0fM[W0000003If^L0000000<0fM[W00<000000=WJi`3If^L00P3I
f^L00`000000fM[W0=WJi`020=WJi`030000003If^L0fM[W00`0fM[W00<0
oooo000lM03Wi^T00`3Pgn<00`3IeMD003ad0?ooo`0=0=WJi`030000003I
f^L0fM[W0080fM[W00<000000=WJi`0000000P3If^L2000000050=WJi`00
0000fM[W0=WJi`0000000P3If^L01`000000fM[W0=WJi`3If^L000000=WJ
i`0000000`3If^L00`000000fM[W0=WJi`030=WJi`050000003If^L0fM[W
0=WJi`0000003P3If^L01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40oooo
0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM02H^>X0oooo303Ngn`00`00
0000g]o/0=kOk0020=kOk0030000003Ngn`0000000<0g]o/00<000000=kO
k00000000P3Ngn`010000000g]o/0=kOk00000030=kOk0030000003Ngn`0
000000<0g]o/00<000000=kOk03Ngn`00`3Ngn`5000000l0g]o/00@0oooo
09Rhj@00?7@0inKY0`3Pgn<00`3IeMD003ad0?ooo`0=0=kOk0030000003N
gn`0g]o/0080g]o/00<000000=kOk00000000`3Ngn`00`000000g]o/0000
00020=kOk0040000003Ngn`0g]o/000000<0g]o/00<000000=kOk0000000
0`3Ngn`00`000000g]o/0=kOk0020=kOk0030000003Ngn`0g]o/0080g]o/
00<000000=kOk03Ngn`0303Ngn`00`3oool003ad0>OVj@030>3Oh`030=WE
e@00?7@0oooo00d0g]o/00<000000=kOk03Ngn`00P3Ngn`00`000000g]o/
000000030=kOk0030000003Ngn`000000080g]o/00@000000=kOk03Ngn`0
00000`3Ngn`00`000000g]o/000000030=kOk0030000003Ngn`0g]o/0080
g]o/00<000000=kOk03Ngn`04@3Ngn`01P3oool003ad0>OVj@1VIWh0Z:Vk
0?_lo@40oooo0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM02L^nX0oooo
303SiO000`000000hnG`0>?Ul0020>?Ul0030000003SiO00000000<0hnG`
00<000000>?Ul00000000P3SiO0010000000hnG`0>?Ul00000030>?Ul003
0000003SiO00000000<0hnG`00<000000>?Ul03SiO000`3SiO001@000000
hnG`0>?Ul03SiO00000000l0hnG`00@0oooo09bkj`00?7@0inKY0`3Pgn<0
0`3IeMD003ad0?ooo`0=0>?Ul0030000003SiO00hnG`0080hnG`00<00000
0>?Ul00000000`3SiO000`000000hnG`000000020>?Ul0040000003SiO00
hnG`000000<0hnG`00<000000>?Ul00000000`3SiO000`000000hnG`0>?U
l0020>?Ul0030000003SiO00hnG`0080hnG`00<000000>?Ul03SiO00303S
iO000`3oool003ad0>OVj@030>3Oh`030=WEe@00?7@0oooo00d0hnG`00<0
00000>?Ul03SiO000P3SiO000`000000hnG`000000030>?Ul0030000003S
iO0000000080hnG`00@000000>?Ul03SiO0000000`3SiO000`000000hnG`
000000030>?Ul0030000003SiO00hnG`0080hnG`00<000000>?Ul03SiO00
4@3SiO001P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40oooo0000201VIWh0
nocm0:RY^`1VIWh0fMGE000lM02P_^`0oooo303YjoD500000080jN_e00L0
00000>W[m@3YjoD0jN_e0000003YjoD000000080jN_e00@000000>W[m@3Y
joD000000`3YjoD010000000jN_e0000000000020>W[m@030000003YjoD0
jN_e00@0jN_e00<000000>W[m@000000403YjoD0103oool0XKk/000lM03W
i^T30>3Oh`030=WEe@00?7@0oooo00d0jN_e1@0000020>W[m@070000003Y
joD0jN_e0>W[m@000000jN_e000000020>W[m@040000003YjoD0jN_e0000
00<0jN_e00@000000>W[m@00000000000P3YjoD00`000000jN_e0>W[m@02
0>W[m@D000003`3YjoD00`3oool003ad0>OVj@030>3Oh`030=WEe@00?7@0
oooo00d0jN_e1@0000020>W[m@070000003YjoD0jN_e0>W[m@000000jN_e
000000020>W[m@040000003YjoD0jN_e000000<0jN_e00@000000>W[m@00
000000000P3YjoD00`000000jN_e0>W[m@020>W[m@030000003YjoD0jN_e
0140jN_e00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d10?ooo`0000P0IVIn
0?_lo@2XZK/0IVIn0=WEe@00?7@0YL7]0?ooo``0l?7l00<000000?3ao03`
lO`00P3`lO`00`000000l?7l000000030?3ao0L000000P3`lO`300000080
l?7l00@000000?3ao000000000001`3`lO`00`000000l?7l0000000@0?3a
o0040?ooo`2U`^h003ad0>OVj@<0h=oS00<0fMGE000lM03oool03@3`lO`0
0`000000l?7l0?3ao0020?3ao0030000003`lO`0000000<0l?7l1`000002
0?3ao0<000000P3`lO`010000000l?7l0000000000050?3ao0030000003`
lO`0l?7l0080l?7l00<000000?3ao03`lO`0303`lO`00`3oool003ad0>OV
j@030>3Oh`030=WEe@00?7@0oooo00d0l?7l00<000000?3ao03`lO`00P3`
lO`00`000000l?7l000000030?3ao0L000000P3`lO`300000080l?7l00@0
00000?3ao000000000001@3`lO`00`000000l?7l0?3ao00A0?3ao0060?oo
o`00?7@0inKY06IVOP2XZK/0nocm0@3oool0000806IVOP3ko?d0Z:Vk06IV
OP3IeMD003ad0:W5k`3oool<0?Ceo@030000003dmOd0m?Gm0080m?Gm00<0
00000?Ceo@3dmOd01@3dmOd010000000m?Gm0?Ceo@00000C0?Ceo@030000
003dmOd000000100m?Gm00@0oooo0:W5k`00?7@0inKY0`3Pgn<00`3IeMD0
03ad0?ooo`0=0?Ceo@030000003dmOd0m?Gm0080m?Gm00<000000?Ceo@3d
mOd01@3dmOd010000000m?Gm0?Ceo@00000A0?Ceo@030000003dmOd0m?Gm
0080m?Gm00<000000?Ceo@3dmOd0303dmOd00`3oool003ad0>OVj@030>3O
h`030=WEe@00?7@0oooo00d0m?Gm00<000000?Ceo@3dmOd00P3dmOd00`00
0000m?Gm0?Ceo@050?Ceo@040000003dmOd0m?Gm00000180m?Gm00D00000
0?Ceo@3dmOd0m?Gm0000000>0?Ceo@060?ooo`00?7@0inKY06IVOP2XZK/0
nocm0@3oool0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0:g8l03oool<
0?Kgo@D00000203fmod010000000m_Om0?Kgo@00000D0?Kgo@030000003f
mod0m_Om00l0m_Om00@0oooo0:c7l000?7@0inKY0`3Pgn<00`3IeMD003ad
0?ooo`0=0?Kgo@D00000203fmod010000000m_Om0?Kgo@00000A0?Kgo@D0
00003`3fmod00`3oool003ad0>OVj@030>3Oh`030=WEe@00?7@0oooo00d0
m_Om1@0000080?Kgo@040000003fmod0m_Om000001<0m_Om0`00000?0?Kg
o@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@3oool0000806IVOP3ko?d0
Z:Vk06IVOP3IeMD003ad0;7;lP3ooom30?Slo@040?ooo`2ac?8003ad0>OV
j@<0h=oS00<0fMGE000lM03oool0@`3ho?d00`3oool003ad0>OVj@030>3O
h`030=WEe@00?7@0oooo04<0n?cm00H0oooo000lM03Wi^T0IVIn0:RY^`3k
o?d10?ooo`0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0]<gc0?oood<0
oOgm00@0oooo0;G>l`00?7@0inKY0`3Pgn<00`3IeMD003ad0?ooo`130?gm
o@030?ooo`00?7@0inKY00<0h=oS00<0fMGE000lM03oool0@`3moOd01P3o
ool003ad0>OVj@1VIWh0Z:Vk0?_lo@40oooo0000201VIWh0nocm0:RY^`1V
IWh0fMGE000lM02gd?@0oooo@`3moOd0103oool0^=3e000lM03Vi^T30>3O
h`030=WEe@00?7@0oooo04<0oOgm00<0oooo000lM03Vi^T00`3Pgn<00`3I
eMD003ad0?ooo`130?gmo@060?ooo`00?7@0i^KY06IVOP2XZK/0nocm0@3o
ool0000806IVOP3ko?d0Z:Vk06IVOP3He=@003ad0;[Cm@3ooom30?gmo@04
0?ooo`2jdoH003ad0>GUj0<0h=oS00<0f=CD000lM03oool0@`3moOd00`3o
ool003ad0>GUj0030>3Oh`030=SDe000?7@0oooo04<0oOgm00H0oooo000l
M03UiNP0IVIn0:RY^`3ko?d10?ooo`0000H0IVIn0?_lo@2XZK/0IVIn0=WE
e@0UEhE70;cDmP0302EGQ@3QhN@0h=oS0080h=oS00<0fMGE02EGQ@2oc]`0
@`3oool00`2oc]/09EN50>7Qi0030>3Oh`030=WEe@0UEhD0_lkL04<0oooo
00H0_lkK02EGQ@3QhN@0IVIn0:RY^`3ko?d10?ooo`0000L0IVIn0?_lo@2X
ZK/0IVIn0=WEe@1iU:T09df504D0c^Oo00<09df507VEZ`3OgN000`3Pgn<0
103IeMD0NIBY05EmXP30cme10?ooo`040=GOj01EOJ80NIF[0=oMh0<0h=oS
00@0fMGE07VDZ@1EOJ80`<oM@@3oool01`3EgnP0EGfR07VEZ`3OgN00IVIn
0:RY^`3ko?d00@3oool0000806IVOP3ko?d0Z:Vk06IVOP3JemT0gmcH07VD
Z@0UEhE3000lM00401M=OP1VQZ40h=kJ0=cKg@<0h=oS00@0f]OI0=oLf01i
U:T09EN5@@00?7@0100GCGh0IXJQ0>3NfP3Lfmd30>3Oh`040=[Gf@3Og=P0
NIBY02EGQD4003ad00L05den06J6X@3Pg]X0g=_M06IVOP2XZK/0nocm0040
oooo00001`1VIWh0nocm0:RY^`1VIWh0gmgP0=[Gf@3He=@08`3Gdm@N0=?>
c0<0em?D00@0f=CD0=WEe@3JemT0gmgP0`3Pgn<00`3OgN00f]OI0=SDe00R
0=OCe1d0dlk<0`3Gdm@0103He=@0fMGE0=[Gf@3OgN030>3Oh`030=oMh03J
emT0f=CD0280em?D7@3Cc/`30=OCe0070=SDe03IeMD0f]OI0=oMh01VIWh0
Z:Vk0?_lo@010?ooo`0000<0IVIn0?Ogn@2HV:L0i@1gMi8109RHY`40moOi
0@3oool0000306IVOP3gmoT0_;g=0>H0_;g=0@3gmoT10?ooo`0000<0IVIn
0?Ogn@3Thn<0iP3Thn<10?Ogn@40oooo00000`1VIWh0l?7d0?ooo`2O0?oo
o`030>CSh`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl0
1P2LY;T0i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00
K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY4
0:HiA02W>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@3o
ool0000F06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?cl
o@3lo?`0o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m
0?_lo080o?cl00@0o?cm0?clo03knod0o?cm>@3lno`j0?_lo1<0nocm00<0
W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40
QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0
nocl0?clo03lnod0nocm0>;QhP010?ooo`0000@0IVIn0>3Ph@3fmoT0moOi
0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3g
moT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi
0?Ogn@0h0?OgnCX0m_Oi4`3gmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9
/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0
YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Og
n@3gmoP0moOi0>3Ph@010?ooo`0000H0IVIn0=kMh@3alO@0lO7d0?3am03`
l_@@000000060?7am03`l_D0lO7d0?7bm03`l_@0lO7dL`3`lODC0?3am003
06]eS`2b]M00YjS20100YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A
0:NX`P050;:ed01[MHl0l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN0<eI
GP0;0<eIGP040<]DF@32DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN40
0@3oool0000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__000000020>OWi`80
g]kN0P3WinL00`3W_H@0inOW0>OWi`030>OWi`80kno_00@000000>[[l03Z
jo00j^__0P3Zjo000`3Zjnl0j^_`0>[[l00g0>[[l3X0j^c`4`3Zjnl0101[
MHl0][WA0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k6
0;Jid@1[MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0
[:k60;Jid@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO
00L0cUUO0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn010?oo
o`0000@0IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0
g]kN0080inOW00<0aV<00>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`00
0000hnCZ0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0g0>?UjcX0hnCZ
4`3SiNX01@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b
//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo
02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=
FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0
cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@3oool0000306IVOP3Gf=h0
g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_
U100inOW0>ONaP3_S1000`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cN
i@3Lg^H0QP3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf
0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>
00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1
eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<3
0?ooo`0505<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OH
gP010?ooo`0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OW
i`3WinL0ikF40=IJ003FQ000olh00<iS00020=i[00050>neS03_knl0kno_
0>o_k`0000000P3Ef>40103Een00e]SP0=KHh@3Fen4i0=KGh3X0e]SP4`3E
f>401@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?
0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M401`2l_M400`3o
ool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V>D@00P3EGF00
0`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@02
0=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@3oool0000706IVOP3B
e=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36BP00mlh00>n]
003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@d]`00`3?d]`0
d=;L0<oBg00i0=3Bg3X0cm;M4`3@d]`00`1[MHl0b<WK0<?4eP0@0<?4eP06
0<S9f`1[MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP07
0<?4eP030?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:Hi
A03GGel0fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`08
04HN6P3LIFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3B
e=d10?ooo`0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3W
aX`0mlhH0>nm003gaP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_
i`3_knl000000<_=f03;cMT0b/gI0<_>f03:cMP0blgH>@3;cMTj0<_>fA<0
blgH00<0JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@04
0<S9f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U
9CH50<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN
06]eS`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0
oooo0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V
>D@0b/kH0<[>f@80blgI0@3@d]/10?ooo`0000<0IVIn0<o?fP35b=@00`35
b=@01P000000a/K60>ONeP3>N`00ijd00>ne0080ijD000<0eY@00<ic003F
U0000P3gaP020?Ogm`0400000035b=@0aLOD0<G7e0<0aLOE>@34amDj0<C8
e1<0a<OD00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0
JgF?0=3Ah080bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;
g0020<_;g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ005
04HN6P3oool0oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D2
0<C8e040aLOE0@3?cmX10?ooo`0000@0IVIn0<c>fP32a=80`LCA0P31a=80
1P000000inOW0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00
mkD00?Nm003_knl0moOg000000<0`LCB00<0`/CA0<74dP31a=80>@31a=4j
0<74dQ<0`/CB00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32
a=80JgF?0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf
0<o@g@020<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/
J@D0oooo1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ
0@3oool0000406IVOP3:c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0
imkF0=J<00020=jD00040=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>
BP000000_/3>0;k0c`2n`<h0_/3?0;g0cSX0_/3>>P2m`<hC0;k0cP0306]e
S`3Fe^@0dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?C
h0030?ooo`0U9CH0oooo00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[
MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3o
ool0oooo103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P1
0?ooo`0000L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0
eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3o
ool000000;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;03T0^Kc<>P2j_<`C0;Zl
b`0306]eS`3Hf>D0dm?Q0100dm?Q00H0f=SU06]eS`2j_</0^[c;06]eS`3H
f>D20=?Ch@030?ooo`1^KHl0KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q
0=SHi@1[MHl0^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0oooo
00<0AQhJ0>A`KP167QX00`3oool20>A`KP090>AaK@3QKF`0h6UX0:HiA02j
_<`0^[_<0;Vlb`2f^<P0bL[H0040oooo00002@1VIWh0alWG0;Bfa`2f^<P0
][S90;Jib@000000Q8B40>OWgP020>o_k`070<I[003gaP00kkD00>nL003N
S000cV/00>NL00030?Ogm`050000002f^LT0]kS90;Jib@2g^LT00P2f^<Ti
0;NhbCX0][S94`2g^<T0101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3H
f>D20=SHiP80f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SH
iP3oool02P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW9
0:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0
AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d
]/L0alWG0@3oool0000306IVOP36b=L0];K700<0];K700<000000>o_k`3_
knl00P3_knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?og
m`3oool0000008`0];K700D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`06
0=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P09
02DU=P<0g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3Z
N7H00P3oool00`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo0>Yh
MP3ZMW<0igEb0>McK`2V>D@40;Bfa`40a/SG0@3oool0000306IVOP36b=L0
];K700<0];K700H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND
003gilh0moOg0?Ogm`3_imH0moOg0?ooo`00002<0;Bfa`0306]eS`3Ee><0
h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GD
h`1[MHl0];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;
0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0
jWUc0:HiA0040;Bfa`40a/SG0@3oool0000306IVOP36b=L0/K?800<0/K?8
00H000000>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo
00<0moOg00<0oooo0000002a/lP0R`2a/lP00`1[MHl0kN_c0>WXl@0@0>WX
l@060>g[l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6c
b02a/lP0YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K
0>fdV`3/]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0
102a/lP10<K8e`40oooo00000`1VIWh0a/SG0;Rgc`030:n^a`050000002]
[Jd0moO_0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L0
RP2_[/L00`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[
MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b
^9h20?F@Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8e`40oooo0000
0`1VIWh0`<7A0<O7e02O0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0
no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`04
0?_ko03<bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3j
jkL0n^Vf0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg
0?joY03oWhd0YSU4096HZP<0[:_40@37am@10<31d@40oooo0000101VIWh0
`<7A0=;Bg`2e]<VO0:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS
_P2TXkh00P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n
0080Y:>n00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0
]KC90=;Bg`30`M400@3oool0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34
g`2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040oooo00001`1HEfP0QhNK
0=OHhP3lo?`0i>?X0=3@h03:b]X0g@2l_<l01P3:b]X0d=3P0>CSj03lo?`0
emSR08N7V`40oooo0000201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0
hN;[f`3Gf>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@3oool0
0080F5MX00<0IVIn09FDZ`3AdMh00P3lo?cM0?ooo`80o?cl00@0dM7N09FD
Z`1VIWh0F5MX0@3oool000<0F5MX0P1VIWh00`28Qid0UIB[0:RW_`3L0:RW
_`0409FDZ`28Qid0IVIn06IVOP80F5MX0@3oool000D0F5MXh@1VIWh405QG
J040oooo0000\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  Evaluatable->False,
  ImageSize->{235, 57},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]=",
  CellTags->"WidgetGroup-Layout"]
}, Open  ]],

Cell["\<\
Nested lists still use the automatic alternating horizontal and vertical \
layouts and so the child list will now be a column.\
\>", "Text",
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    \(\(ref\  = 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", 
            WidgetGroup[{\[IndentingNewLine]{Widget["\<Button\>", {"\<text\>" \
-> "\<Button A\>"}], \[IndentingNewLine]Widget["\<Button\>", {"\<text\>" -> "\
\<Button B\>"}]}, \[IndentingNewLine]Widget["\<Button\>", {"\<text\>" -> \
"\<Button C\>"}]\ }, \ 
              WidgetLayout \[Rule] 
                Row]\[IndentingNewLine]]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002O0000Db000`400?l0
0000o`00003oW`1VIWh0000306IVOP3ko?d0nocm09/0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk09X0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
V@1VIWh10:RY^`40nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3Qh>@0
i^GX0>c[kP3`l?80l_;d0240lo?d7P3hmoP20??cm0050??cm@3dm?D0mOGf
0?Ccm@3Ui>P0C03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_l
o@2XZK/0IVIn0=kLg`3Th^00NiN]02EGQD<003ad00@05den06^;YP3blNh0
l_7cC03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0
IVIn0=[Hf@1VQJ40BW6C0;:m`d<0a/GG00@0`<K504Q^T01ZRZ@0knoaC03P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=SE
eP0GCGh0_lO:04D0a/GG00<0][fm01M=OP3[j^d0C03Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo04D0
cLcO00<0oooo000lM03XinX0C03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo04D0d]7T00<0oooo000l
M03Wi^T0C03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2X
ZK/0IVIn0=WEe@00?7@0oooo04D0e]OW00<0oooo000lM03Wi^T0C03Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00
?7@0oooo00h0fM[W1@0000030=WJi`80000000<0fM[W0000003If^L00P00
00000`3If^L00000000000020=WJi`<000000P3If^L01@000000fM[W0=WJ
i`3If^L0000000@0fM[W1@00000@0=WJi`030?ooo`00?7@0inKY04`0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD0
03ad0?ooo`0>0=WJi`030000003If^L0fM[W0080fM[W00<000000=WJi`00
00000P3If^L2000000050=WJi`000000fM[W0=WJi`0000000P3If^L01`00
0000fM[W0=WJi`3If^L000000=WJi`0000000`3If^L00`000000fM[W0=WJ
i`020=WJi`030000003If^L0fM[W0080fM[W00<000000=WJi`3If^L03@3I
f^L00`3oool003ad0>OVj@1<0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool03P3Ngn`00`000000g]o/
0=kOk0020=kOk0030000003Ngn`0000000<0g]o/00<000000=kOk0000000
0P3Ngn`010000000g]o/0=kOk00000030=kOk0030000003Ngn`0000000<0
g]o/00<000000=kOk03Ngn`00P3Ngn`00`000000g]o/0=kOk0020=kOk003
0000003Ngn`0g]o/00d0g]o/00<0oooo000lM03Wi^T0C03Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo
00h0hnG`00<000000>?Ul03SiO000P3SiO000`000000hnG`000000030>?U
l0030000003SiO0000000080hnG`00@000000>?Ul03SiO0000000`3SiO00
0`000000hnG`000000030>?Ul0030000003SiO00hnG`0080hnG`00<00000
0>?Ul03SiO000P3SiO000`000000hnG`0>?Ul00=0>?Ul0030?ooo`00?7@0
inKY04`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP3IeMD003ad0?ooo`0>0>W[m@D000000P3YjoD01`000000jN_e0>W[
m@3YjoD000000>W[m@0000000P3YjoD010000000jN_e0>W[m@0000030>W[
m@040000003YjoD0000000000080jN_e00<000000>W[m@3YjoD00P3YjoD5
00000100jN_e00<0oooo000lM03Wi^T0C03Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo00h0l?7l00<0
00000?3ao03`lO`00P3`lO`00`000000l?7l000000030?3ao0L000000P3`
lO`300000080l?7l00@000000?3ao000000000001@3`lO`00`000000l?7l
0?3ao0020?3ao0030000003`lO`0l?7l00d0l?7l00<0oooo000lM03Wi^T0
C03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
0=WEe@00?7@0oooo00h0m?Gm00<000000?Ceo@3dmOd00P3dmOd00`000000
m?Gm0?Ceo@050?Ceo@040000003dmOd0m?Gm00000140m?Gm00<000000?Ce
o@3dmOd00P3dmOd00`000000m?Gm0?Ceo@0=0?Ceo@030?ooo`00?7@0inKY
00<0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;bm00P0??cm1d0n?Oh0P3clo@0
203cloD0m?Ce0?GemP3dloD0iNCX06IVOP2XZK/0nocm0@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0>0?Kgo@D00000203fmod01000
0000m_Om0?Kgo@00000A0?Kgo@D00000403fmod00`3oool003ad0>OVj@03
0>3Oh`040=kLg`3Th^00NiN]02EGQD4003ad00L05den06^;YP3blNh0l_7c
06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000l
M03oool0A@3ho?d00`3oool003ad0>OVj@030>3Oh`040=[Hf@1VQJ40BW6C
0;:m`d40a/GG00L0`<K504Q^T01ZRZ@0knoa06IVOP2XZK/0nocm0040IVIn
00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool0A@3moOd00`3oool0
03ad0>OVj@030>3Oh`030=SEeP0GCGh0_lO:04<0a/GG00H0][fm01M=OP3[
j^d0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00
?7@0oooo04D0oOgm00<0oooo000lM03Vi^T00`3Pgn<00`3IeMD003ad0?oo
o`130<g<g`060?ooo`00?7@0j>OZ06IVOP2XZK/0nocm0@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP3He=@003ad0?ooo`150?gmo@030?ooo`00?7@0iNGX
00<0h=oS00<0fMGE000lM03oool0@`3BdN@01P3oool003ad0>OVj@1VIWh0
Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE02EGQ@2oc]`0
A@3oool00`2oc]/09EN50>7Qi0030>3Oh`030=WEe@00?7@0oooo04<0e]OW
00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2X
ZK/0IVIn0=WEe@1iU:T0EGfR0<3?gD<0oooo00@0eMoX05EmXP1iUJ/0gmgP
0`3Pgn<00`3IeMD003ad0?ooo`0=0=WJi`D000000`3If^L2000000030=WJ
i`000000fM[W0080000000<0fM[W0000000000000P3If^L300000080fM[W
00D000000=WJi`3If^L0fM[W000000060=WJi`<000003`3If^L01P3oool0
03ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000201VIWh0nocm0:RY^`1VIWh0
f]OI0=oLf01iU:T09EN5@`00?7@0100GCGh0IXJQ0>3NfP3Lfmd30>3Oh`03
0=WEe@00?7@0oooo00d0fM[W00<000000=WJi`3If^L00P3If^L00`000000
fM[W000000020=WJi`80000000D0fM[W0000003If^L0fM[W000000020=WJ
i`070000003If^L0fM[W0=WJi`000000fM[W000000030=WJi`030000003I
f^L0fM[W00<0fM[W00D000000=WJi`3If^L0fM[W0000000>0=WJi`060?oo
o`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3OgN00f]OI0=SDe00S0=OCe1h0dlk<0`3Gdm@0103He=@0fMGE0=[Gf@3O
gN030>3Oh`030=WEe@00?7@0oooo00d0g]o/00<000000=kOk03Ngn`00P3N
gn`00`000000g]o/000000030=kOk0030000003Ngn`000000080g]o/00@0
00000=kOk03Ngn`000000`3Ngn`00`000000g]o/000000030=kOk0030000
003Ngn`0g]o/0080g]o/00<000000=kOk03Ngn`04@3Ngn`01P3oool003ad
0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWi>0>3O
h`030=WEe@00?7@0oooo00d0hnG`00<000000>?Ul03SiO000P3SiO000`00
0000hnG`000000030>?Ul0030000003SiO0000000080hnG`00@000000>?U
l03SiO0000000`3SiO000`000000hnG`000000030>?Ul0030000003SiO00
hnG`0080hnG`00<000000>?Ul03SiO004@3SiO001P3oool003ad0>OVj@1V
IWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWi>0>3Oh`030=WE
e@00?7@0oooo00d0jN_e1@0000020>W[m@070000003YjoD0jN_e0>W[m@00
0000jN_e000000020>W[m@040000003YjoD0jN_e000000<0jN_e00@00000
0>W[m@00000000000P3YjoD00`000000jN_e0>W[m@020>W[m@030000003Y
joD0jN_e0140jN_e00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVInCP3Pgn<00`3IeMD003ad0?ooo`0=0?3ao003
0000003`lO`0l?7l0080l?7l00<000000?3ao00000000`3`lO`700000080
l?7l0`0000020?3ao0040000003`lO`00000000000D0l?7l00<000000?3a
o03`lO`04@3`lO`01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000
2@1VIWh0nocm0:RY^`1VIWh0hN3T0>KUj03/jnh0l?3b0?;bm00Q0??cm1h0
n?Oh0P3clo@01@3cloD0m?Ce0?GemP3dloD0iNCX00<0h=oS00<0fMGE000l
M03oool03@3dmOd00`000000m?Gm0?Ceo@020?Ceo@030000003dmOd0m?Gm
00D0m?Gm00@000000?Ceo@3dmOd000004P3dmOd01@000000m?Gm0?Ceo@3d
mOd0000000h0m?Gm00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP00
00P0IVIn0?_lo@2XZK/0IVIn0=kLg`3Th^00NiN]02EGQD<003ad00@05den
06^;YP3blNh0l_7c0`3Pgn<00`3IeMD003ad0?ooo`0=0?Kgo@D00000203f
mod010000000m_Om0?Kgo@00000C0?Kgo@<000003`3fmod01P3oool003ad
0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000201VIWh0nocm0:RY^`1VIWh0f]SI
06J5X@0WCHD0CGg1A01YP^h00`0WCHD0JXZT0>o_l@030>3Oh`030=WEe@00
?7@0oooo04<0n?cm00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP00
00H0IVIn0?_lo@2XZK/0IVIn0=SEeP0GCGi708V]i00301M=OP3[j^d0h=oS
0080h=oS00<0fMGE000lM03oool0@`3moOd01P3oool003ad0>OVj@1VIWh0
Z:Vk0?_lo@40IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM029[N@0
oooo@`3=c=l0103oool0RJgT000lM03XinX30>3Oh`030=WEe@00?7@0oooo
04<0oOgm00H0oooo000lM03Vi^T0IVIn0:RY^`3ko?d106IVOP0000P0IVIn
0?_lo@2XZK/0IVIn0=WEe@00?7@0RjgT0?oood<0d]7T00@0oooo08^_i@00
?7@0inKY0`3Pgn<00`3He=@003ad0?ooo`130?gmo@060?ooo`00?7@0iNGX
06IVOP2XZK/0nocm0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad
08j_iP3ooom30=KGi`040?ooo`2=[nD003ad0>OVj@<0h=oS00<0fMGE02EG
Q@2oc]`0@`3oool01P2oc]/09EN50>7Qi01VIWh0Z:Vk0?_lo@40IVIn0000
201VIWh0nocm0:RY^`1VIWh0fMGE000lM02A/NL0oooo303If^L5000000<0
fM[W0P0000000`3If^L000000=WJi`02000000030=WJi`00000000000080
fM[W0`0000020=WJi`050000003If^L0fM[W0=WJi`000000103If^L00`00
0000fM[W0=WJi`030=WJi`030000003If^L0fM[W00`0fM[W00@0oooo096a
iP00?7@0inKY0`3Pgn<0103IeMD0NIBY05EmXP30cme10?ooo`070=GOj01E
OJ80NIF[0=oMh01VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0
IVIn0=WEe@00?7@0U;CX0?ooo``0fM[W00<000000=WJi`3If^L00P3If^L0
0`000000fM[W000000020=WJi`80000000D0fM[W0000003If^L0fM[W0000
00020=WJi`070000003If^L0fM[W0=WJi`000000fM[W000000030=WJi`03
0000003If^L0fM[W0080fM[W00<000000=WJi`3If^L00`3If^L00`000000
fM[W0=WJi`0<0=WJi`040?ooo`2E]>P003ad0>OVj@<0h=oS00@0f]OI0=oL
f01iU:T09EN5@@00?7@01`0GCGh0IXJQ0>3NfP3Lfmd0IVIn0:RY^`3ko?d0
0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad09RhjP3oool<0=kO
k0030000003Ngn`0g]o/0080g]o/00<000000=kOk00000000`3Ngn`00`00
0000g]o/000000020=kOk0040000003Ngn`0g]o/000000<0g]o/00<00000
0=kOk00000000`3Ngn`00`000000g]o/0=kOk0030=kOk0D000003`3Ngn`0
103oool0V;SY000lM03Wi^T30>3Oh`030=oMh03JemT0f=CD0280em?D7@3C
c/`30=OCe0070=SDe03IeMD0f]OI0=oMh01VIWh0Z:Vk0?_lo@0106IVOP00
00P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0W;_Z0?ooo``0hnG`00<00000
0>?Ul03SiO000P3SiO000`000000hnG`000000030>?Ul0030000003SiO00
00000080hnG`00@000000>?Ul03SiO0000000`3SiO000`000000hnG`0000
00030>?Ul0030000003SiO00hnG`00<0hnG`00D000000>?Ul03SiO00hnG`
0000000?0>?Ul0040?ooo`2L^n/003ad0>OVjD`0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0:2nk03oool<
0>W[m@D000000P3YjoD01`000000jN_e0>W[m@3YjoD000000>W[m@000000
0P3YjoD010000000jN_e0>W[m@0000030>W[m@040000003YjoD000000000
0080jN_e00<000000>W[m@3YjoD0103YjoD00`000000jN_e0000000@0>W[
m@040?ooo`2Q_^`003ad0>OVjD`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0:G1k@3oool<0?3ao0030000
003`lO`0l?7l0080l?7l00<000000?3ao00000000`3`lO`700000080l?7l
0`0000020?3ao0040000003`lO`00000000000L0l?7l00<000000?3ao000
0000403`lO`0103oool0YL;^000lM03Wi^U<0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM02YaNl0oooo303d
mOd00`000000m?Gm0?Ceo@020?Ceo@030000003dmOd0m?Gm00D0m?Gm00@0
00000?Ceo@3dmOd000004`3dmOd00`000000m?Gm0000000@0?Ceo@040?oo
o`2YaNl003ad0>OVjD`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000806IV
OP3ko?d0Z:Vk06IVOP3IeMD003ad0:g8l03oool<0?Kgo@D00000203fmod0
10000000m_Om0?Kgo@00000D0?Kgo@030000003fmod0m_Om00l0m_Om00@0
oooo0:c7l000?7@0inKYC03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0
IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0/L_b0?oood<0n?cm00@0oooo0;7<
lP00?7@0inKYC03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_l
o@2XZK/0IVIn0=WEe@00?7@0]<gc0?oood<0oOgm00@0oooo0;G>l`00?7@0
inKYC03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0
IVIn0=WEe@00?7@0]m3d0?oood<0oOgm00@0oooo0;S@m@00?7@0i^KYC03P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=SD
e000?7@0^]?e0?oood<0oOgm00@0oooo0;[CmP00?7@0iNGXC03Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn0=WEe@0UEhE7
0;cDmP0302EGQ@3QhN@0h=oS04/0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP3IeMD0NIBY02M=Q@150<kWo`0302M=Q@1i
UJ/0gmgP04`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0
Z:Vk06IVOP3JemT0gmcH07VDZ@0UEhE3000lM00401M=OP1VQZ40h=kJ0=cK
gD`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3OgN00f]OI0=SDe00S0=OCe1h0dlk<0`3Gdm@0103He=@0fMGE0=[Gf@3O
gN1<0>3Oh`0306IVOP2XZK/0nocm0040IVIn00000`1VIWh0moOi09RHY`2I
07MgTP40V9RW0@3gmoT106IVOP0000<0IVIn0?Ogn@2l_Ld0VP2l_Ld10?Og
n@40IVIn00000`1VIWh0moOi0>CSh`2J0>CSh`40moOi0@1VIWh0000306IV
OP3`lO@0oooo05<0oooo00<0i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?
06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0
101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0
W:Bi102V>D@0102W>T@0YSU40:LjA02W>T@90:HiA00309bT^@3/j^X0oooo
00<0oooo0@3`lO@106IVOP0001H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0
no_m0?_lo@3ko?`0o?cm0?clo03lnod0o?cl0?cko03lo?`0nocl0?clo03k
o?d0o?_l0?clo@3knod0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?dP0?ck
o1X0nocl00<0W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0
W:Bi06]eSa40QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@07
0:HiA02LY;T0nocl0?clo03lnod0nocm0>;QhP0106IVOP0000@0IVIn0>3P
h@3fmoT0moOi0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0
moKh0?Kgn@3gmoT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT0
0`3fmoP0moOi0?Ogn@0O0?OgnAX0m_Oi00<0JgF?08F9/02LW[h0402LW[h0
1P25RK00JgF?0?Ogn@3gmoT0JgF?08F9/140W9jn00P0QHV`06]eS`3fmoP0
moOh0:HiA02Z?5D0`U9K0<IDFPd0aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Og
n03gmoT0moOh0?Ogn@3Ph>400@1VIWh0000606IVOP3NgN40lO7d0?7am03`
lO@0l?;d400000001P3alO@0l?;e0?7am03al_@0l?;d0?7am3X0l?7e00<0
JgF?0;:ed02WZ<80402WZ<801P2b]M00JgF?0?3am03`lO@0JgF?0;:ed140
YjS200D0/[G@06]eS`3`lOD0lO;d0:HiA0020<9BF`030<]DF@3=FEh0cEUN
00/0cEUN00@0beAI0<9BF`32DU/0YSU40P3`lO@00`3alO@0l?;d0=kMh@01
06IVOP0000L0IVIn0=cKh03Zjo00j^_`0>[/l03Yjnl000000080inOW0P3N
g]h20>OWi`030>NmQ03WinL0inOW00<0inOW0P3_knl010000000j^_`0>[[
l03Zjnl20>[[l0030>[[k`3Zjo00j^_`01h0j^_`6P3Zk?00101[MHl0][WA
0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[
MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Ji
d@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO
0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0
IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080
inOW00<0aV<00>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ
0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0N0>?UjaX0hnCZ00D0JgF?
0;bne02b//X0/[;:0?ooo`0606i]S`0302DU=P2b//X0/[;:00D0/[;:00H0
_;kD06]eS`3SiNX0hnGZ06]eS`2l_]@20;:bbP030?ooo`0U9CH09BDf00T0
9BDf0`2b//X01@2l_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN00@0d5]P0=AL
G`3oool0oooo1`3DG5l20?ooo`0:0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnCZ
0>?UjP3Si>X0hnG[0=WIg`40IVIn00000`1VIWh0emSN0=cNiP030=cNiP05
0000003WinL0inOW0>OWi`3We/h00P3WinL01@3>N`00ki@@0>OWi`3Wg/H0
kh`@00<0kno_00L000000=cNiP3Lg^D0g=kU0=cNiP3Lg^D0g=kV03X0g=kU
00D0JgF?0;o1eP2h^Lh0^;W>0?ooo`0606i]S`0302DU=P2h^Lh0^;W>00D0
^;W>00H0_l7F06]eS`3Lg^D0g=kU06]eS`2o`MH20;RicP030?ooo`0U9CH0
^;W>00L0^;W>00<0oooo02DU=P2h^Lh00P2h^Lh02@2o`MH0JgF?0=cNiP3L
g^D0YSU40<eIGP3AFUh0e5eQ05<U80030?ooo`D0eUmS0`3oool01@1C9B00
e5eQ0=5JGP3=FEh0YSU40080g=kU00<0g=kV0=cNi@3Gf=h00@1VIWh00004
06IVOP3Ee]d0eMSP0=KHh@80eMSP00T0000008b<S03WinL0inOW0>NeQ03F
FP00eX@00?o>003>H`000P3NJ`001@3_]H`0kno_0>o_k`3_knl000000080
eMSQ00@0eMOP0=KHh03Ff>40e]OQ803Fen0J0=KHh00506]eS`33aMT0_;gA
0;bmd@3oool01`0U9CH70;bmd@060<?5f@1[MHl0eMSQ0=GHh@1[MHl0`lGI
0P2l_M400`3oool09BDf0;bmd@070;bmd@030?ooo`0U9CH0_;gA0080_;gA
00D0`lGI06]eS`3Fen00eMOQ0:HiA0020=EMH0030=QPH@3IHF80AQhJ00<0
oooo0`3IHF830?ooo`0304HN6P3IHF80f61Q0080eEeP00H0YSU40=KHh03E
f>40eMOP0=GHh@3Ee]d106IVOP0000L0IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@
d]`0000000<0inOW00`0imk>0<I:003gcP00kjd00>ne003>J`00aUX00<I[
003NS4X0ijD00>oWcP0000030=3Bg0030<oBg03@d]`0cm;L0200d=;L6P3?
d]d00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3Bg01[MHl0
b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP030?ooo`0U9CH0`lCF0080
`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU00D0AQhJ
0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aUI@3IHF80
eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn0=3Bf`3;
cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH0>nm003gaP00kjd00>N]
003WY@00eX`00<i[003WaP00omH00>o_i`3_knl000000<_=f03;cMT0b/gI
0<_>f03:cMP0blgH803;cMTJ0<_>f@0306]eS`3;c=h0b<[I00P0b<[I00<0
b<WI0<S:f@38b]T00`38b]T01038bMT0b<[I0<_<gP1[MHl20<_=f00606]e
S`3;c=h0b<[I0<S:f@3oool09BDf1@38b]T04@38bMT0b<[I0<S:f@3oool0
9BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0eemO0=]TI03P
IfD0h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3oool02P167QX0gVMW0=iW
I`3PIVD0h6MU0=]TI03GGel0YSU40<[>f03:c]T20<_=f@40d=;K0@1VIWh0
000306IVOP3?cmX0aLSD00<0aLSD00H000000<K6aP3Wg]H0cW/00>N]003_
]@020>NU00030=JD003>L`00eY@00080mlH00P3gmoL010000000aLSD0<G7
e035am@30<G7eB00a<OE6P34b=@00`1[MHl0d=7P0<_;g00@0<_;g0060=3A
h01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3oool09BDf0<_;g0070<_;
g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]eS`35am@0a<OD0:HiA03K
I6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo04HN6P050>1ZJ0040=mU
I03KI6@0YSU40<C8e@80a<SD0@35amD10<o?fP40IVIn0000101VIWh0c<kJ
0<;4dP31a=420<74dP060000003WinL0inOW0>OWi`3FQ000kkD00P3WY@00
203FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL000000`31a=800`32a=40
`LCB0<74dP0P0<74dAX0`LCB00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80
JgF?0<;4dP32a=80JgF?0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?d=d0
0`3oool09BDf0<o@g@020<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT
0>5YI@050>1/J@D0oooo1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA0<74
d@31a=80c<kJ0@1VIWh0000406IVOP3:c=P0_/3?0;g0c`80_/3>00D00000
09bLW03WinL0imkF0=J<00020=jD00040=Ik0036H`00_D800>nU0080mjd0
00P0mkD00?o>BP000000_/3>0;k0c`2n`<h0_/3?0;g0cR40_/3>6P2m`<h0
0`1[MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0cP1[MHl0e]KT
0P3Cdn000`3oool09BDf0?ooo`080?ooo`0;02DU=P3Cdn00dm?P0=?Ch03F
e^@0JgF?0;k0c`2n`<h0YSU40>1VI@3QJVX0103SK6`30?ooo`0404HN6P3o
ool0oooo0?ooo`@0hfa/00@0hFYZ0>1VI@2V>D@0_L3?0P2n`<l10;k0cP40
b/cH0@1VIWh0000706IVOP39b]P0][S80;Vlb`2j_</0^[c<000000020>o_
k`0C0=JL003FS000gY@00=J4003_Y@00gX`00;eJ003FL`00ki`00?O_i`3g
moL0oooo0000002i_<`0^[_<0;Vlb`2j_</0^Kc<0;Vlb`0P0;Vlc1X0^[c<
00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?0;Zlb`2j_</0JgF?0=SH
i@80dm?Q00<0oooo06i]S`1^KHl0201^KHl03P0U9CH0dm?Q0=?Ch@3Cdn40
f=SU06]eS`2j_</0^[c<0:HiA03PJFP0hFe/0>AaK@3TLFl0i71^0`3oool0
0`167QX0i71^04HN6P030?ooo`80i71^00T0i75]0>5]K03PJFP0YSU40;Zl
c02j^l`0^Kc;0;Jhb039b]P00@1VIWh0000906IVOP37bML0];K70;Jhb02f
^<T0][W900000024Q8@0inON0080kno_00L0aV/00?O6003_]@00ki`00=j<
003>J`00ii`000<0moOg00D000000;Jib@2g^<T0][W90;Nib@020;JhbB00
]kS96P2f^<T0101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SH
iP80f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool0
2P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03T
KVd0i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0
oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG
0@1VIWh0000306IVOP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_
knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool0
00000400];K700D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[
MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0
g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3o
ool00`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0
igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0
];K700H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0
moOg0?Ogm`3_imH0moOg0?ooo`0000100;Bfa`0306]eS`3Ee><0h=oZ0100
h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0
];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]
UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:Hi
A0040;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H00000
0>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg
00<0oooo0000002a/lP0?`2a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[
l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0
YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/
]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP1
0<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_
0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L0?P2_[/L0
0`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S
4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@
Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0
`<7A0<O7e01C0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;
g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<
bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf
0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03o
Whd0YSU4096HZP<0[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;B
g`2e]<UC0:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh0
0P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n
00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;B
g`30`M400@1VIWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34T`2XYkl0
1@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3l
o?`0i>?X0=3@h03:b]X0T@2l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7
V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[S`3G
f>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX
00<0IVIn09FDZ`3AdMh00P3lo?bA0?ooo`80o?cl00<0dM7N09FDZ`1VIWh0
0P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW_`2@0:RW_`0409FDZ`28
Qid0IVIn06IVOP<0F5MX000505QGJ9D0IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[15]:=",
  Evaluatable->False,
  ImageSize->{159, 83},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[15]=",
  CellTags->"WidgetGroup-Layout"]
}, Open  ]],

Cell[TextData[{
  "We can explicitly replace any and all lists of widgets with ",
  StyleBox["WidgetGroup", "Program"],
  " expressions."
}], "Text",
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", 
            WidgetGroup[{\[IndentingNewLine]{Widget["\<Button\>", {"\<text\>" \
-> "\<Button A\>"}], \
\[IndentingNewLine]WidgetGroup[{\[IndentingNewLine]Widget["\< Button\>", \
{"\<text\>" -> "\<Button B-1\>"}], \[IndentingNewLine]Widget["\<Button\>", {"\
\<text\>" -> "\<Button B-2\>"}]}, \ 
                    WidgetLayout \[Rule] 
                      Column]}, \[IndentingNewLine]Widget["\<Button\>", \
{"\<text\>" -> "\<Button C\>"}]\ }, \ 
              WidgetLayout \[Rule] 
                Row]\[IndentingNewLine]]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002W0000KB000`400?l0
0000o`00003oY`1VIWh0000306IVOP3ko?d0nocm0:<0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0:80Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
X@1VIWh10:RY^`40nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3Qh>@0
i^GX0>c[kP3`l?80l_;d02D0lo?d8P3hmoP20??cm0050??cm@3dm?D0mOGf
0?Ccm@3Ui>P0C03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_l
o@2XZK/0IVIn0=kLg`3Th^00NiN]02EGQD/003ad00@05den06^;YP3blNh0
l_7cC03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0
IVIn0=[Hf@1VQJ40BW6C0;:m`d/0a/GG00@0`<K504Q^T01ZRZ@0knoaC03P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=SE
eP0GCGh0_lO:04d0a/GG00<0][fm01M=OP3[j^d0C03Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo04d0
cLcO00<0oooo000lM03XinX0C03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo04d0d]7T00<0oooo000l
M03Wi^T0C03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2X
ZK/0IVIn0=WEe@00?7@0oooo04d0e]OW00<0oooo000lM03Wi^T0C03Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00
?7@0oooo00d0fM[W1@0000030=WJi`80000000<0fM[W0000003If^L00P00
00000`3If^L00000000000020=WJi`<000000P3If^L01@000000fM[W0=WJ
i`3If^L0000000@0fM[W1@0000060=WJi`D000003P3If^L00`3oool003ad
0>OVj@1<0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY
^`1VIWh0fMGE000lM03oool03@3If^L00`000000fM[W0=WJi`020=WJi`03
0000003If^L000000080fM[W0P0000001@3If^L000000=WJi`3If^L00000
0080fM[W00L000000=WJi`3If^L0fM[W0000003If^L0000000<0fM[W00<0
00000=WJi`3If^L00P3If^L00`000000fM[W0=WJi`020=WJi`030000003I
f^L0fM[W00@0fM[W00<000000=WJi`3If^L03`3If^L00`3oool003ad0>OV
j@1<0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0fMGE000lM03oool03@3Ngn`00`000000g]o/0=kOk0020=kOk0030000
003Ngn`0000000<0g]o/00<000000=kOk00000000P3Ngn`010000000g]o/
0=kOk00000030=kOk0030000003Ngn`0000000<0g]o/00<000000=kOk03N
gn`00P3Ngn`00`000000g]o/0=kOk0020=kOk0030000003Ngn`000000080
00000`3Ngn`00`000000g]o/0=kOk00>0=kOk0030?ooo`00?7@0inKY04`0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3I
eMD003ad0?ooo`0=0>?Ul0030000003SiO00hnG`0080hnG`00<000000>?U
l00000000`3SiO000`000000hnG`000000020>?Ul0040000003SiO00hnG`
000000<0hnG`00<000000>?Ul00000000`3SiO000`000000hnG`0>?Ul002
0>?Ul0030000003SiO00hnG`0080hnG`00<000000>?Ul03SiO001P3SiO00
0`000000hnG`0>?Ul00=0>?Ul0030?ooo`00?7@0inKY04`0h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?oo
o`0=0>W[m@D000000P3YjoD01`000000jN_e0>W[m@3YjoD000000>W[m@00
00000P3YjoD010000000jN_e0>W[m@0000030>W[m@040000003YjoD00000
00000080jN_e00<000000>W[m@3YjoD00P3YjoD5000000X0jN_e00<00000
0>W[m@3YjoD0303YjoD00`3oool003ad0>OVj@1<0>3Oh`0306IVOP2XZK/0
nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool03@3`
lO`00`000000l?7l0?3ao0020?3ao0030000003`lO`0000000<0l?7l1`00
00020?3ao0<000000P3`lO`010000000l?7l0000000000050?3ao0030000
003`lO`0l?7l0080l?7l00<000000?3ao03`lO`01`3`lO`00`000000l?7l
0?3ao00<0?3ao0030?ooo`00?7@0inKY04`0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0=0?Ceo@03
0000003dmOd0m?Gm0080m?Gm00<000000?Ceo@3dmOd01@3dmOd010000000
m?Gm0?Ceo@00000A0?Ceo@030000003dmOd0m?Gm0080m?Gm00<000000?Ce
o@3dmOd00`3dmOd01@000000m?Gm0?Ceo@3dmOd0000000h0m?Gm00<0oooo
000lM03Wi^T0C03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn0=WEe@00?7@0oooo00d0m_Om1@0000080?Kgo@040000003f
mod0m_Om00000140m_Om1@0000070?Kgo@<000003`3fmod00`3oool003ad
0>OVj@1<0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY
^`1VIWh0fMGE000lM03oool0C@3ho?d00`3oool003ad0>OVj@1<0>3Oh`03
06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000l
M03oool0C@3moOd00`3oool003ad0>OVj@1<0>3Oh`0306IVOP2XZK/0nocm
0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool0C@3moOd0
0`3oool003ad0>KVj@1<0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001`1V
IWh0nocm0:RY^`1VIWh0f=CD000lM03oool0C@3moOd00`3oool003ad0>GU
j01<0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0fMGE02EGQ@2oc]`0C@3oool00`2oc]/09EN50>7Qi01<0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE07VDZ@1E
OJ80`<oMB`3oool0103EgnP0EGfR07VEZ`3OgN1<0>3Oh`0306IVOP2XZK/0
nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0f]OI0=oLf01iU:T09EN5
B`00?7@0100GCGh0IXJQ0>3NfP3Lfme<0>3Oh`0306IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0gmgP0=[Gf@3He=@09`3Gdm@R0=?>
c0<0em?D00@0f=CD0=WEe@3JemT0gmgPC03Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInW`3Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInW`3Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInW`3Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000T0IVIn0?_lo@2XZK/0IVIn0>7Pi03ViNP0k>_^0?3`lP3bl_@0
9@3clo@R0?Sgn080lo?d00D0lo?e0?Cdm@3emOH0m??e0>GTj0030>3Oh`05
0>7Pi03ViNP0k>_^0?3`lP3bl_@0803clo@M0?Sgn080lo?d00P0lo?e0?Cd
m@3emOH0m??e0>GTj01VIWh0Z:Vk0?_lo@40IVIn0000201VIWh0nocm0:RY
^`1VIWh0g]cO0>CRh01kUjd09EN5B`00?7@0100GCGh0Jh^V0?;akP3blO<3
0>3Oh`040=kLg`3Th^00NiN]02EGQD4003ad00L05den06^;YP3blNh0l_7c
06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0f]SI06J5
X@1:LI<0/[g3B`36aML01030a/D0B6j@06Z:Y03_ko430>3Oh`040=[Hf@1V
QJ40BW6C0;:m`d40a/GG00L0`<K504Q^T01ZRZ@0knoa06IVOP2XZK/0nocm
0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0f=GF01M=OP2oalX0C@36aML0
0`2f_Kd05den0>_Zk@030>3Oh`030=SEeP0GCGh0_lO:04<0a/GG00H0][fm
01M=OP3[j^d0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
0=WEe@00?7@0oooo04d0cLcO00<0oooo000lM03XinX00`3Pgn<00`3IeMD0
03ad0?ooo`130<g<g`060?ooo`00?7@0j>OZ06IVOP2XZK/0nocm0@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`1=0=;Ai0030?ooo`00
?7@0inKY00<0h=oS00<0fMGE000lM03oool0@`3BdN@01P3oool003ad0>OV
j@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000l
M03oool0C@3FenL00`3oool003ad0>OVj@030>3Oh`030=WEe@00?7@0oooo
04<0e]OW00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000L0IVIn
0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo00d0fM[W1@0000030=WJi`800000
00<0fM[W0000003If^L00P0000000`3If^L00000000000020=WJi`<00000
0P3If^L01@000000fM[W0=WJi`3If^L0000000@0fM[W1@0000080=WJi`03
0000003If^L0fM[W00h0fM[W00<0oooo000lM03Wi^T00`3Pgn<00`3IeMD0
03ad0?ooo`0=0=WJi`D000000`3If^L2000000030=WJi`000000fM[W0080
000000<0fM[W0000000000000P3If^L300000080fM[W00D000000=WJi`3I
f^L0fM[W000000060=WJi`<000003`3If^L01P3oool003ad0>OVj@1VIWh0
Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool0
3@3If^L00`000000fM[W0=WJi`020=WJi`030000003If^L000000080fM[W
0P0000001@3If^L000000=WJi`3If^L000000080fM[W00L000000=WJi`3I
f^L0fM[W0000003If^L0000000<0fM[W00<000000=WJi`3If^L00P3If^L0
0`000000fM[W0=WJi`020=WJi`030000003If^L0fM[W00D0fM[W00<00000
0=WJi`3If^L03P3If^L00`3oool003ad0>OVj@030>3Oh`030=WEe@00?7@0
oooo00d0fM[W00<000000=WJi`3If^L00P3If^L00`000000fM[W00000002
0=WJi`80000000D0fM[W0000003If^L0fM[W000000020=WJi`070000003I
f^L0fM[W0=WJi`000000fM[W000000030=WJi`030000003If^L0fM[W00<0
fM[W00D000000=WJi`3If^L0fM[W0000000>0=WJi`060?ooo`00?7@0inKY
06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad
0?ooo`0=0=kOk0030000003Ngn`0g]o/0080g]o/00<000000=kOk0000000
0`3Ngn`00`000000g]o/000000020=kOk0040000003Ngn`0g]o/000000<0
g]o/00<000000=kOk00000000`3Ngn`00`000000g]o/0=kOk0020=kOk003
0000003Ngn`0g]o/0080g]o/00<000000=kOk00000000P0000030=kOk003
0000003Ngn`0g]o/00h0g]o/00<0oooo000lM03Wi^T00`3Pgn<00`3IeMD0
03ad0?ooo`0=0=kOk0030000003Ngn`0g]o/0080g]o/00<000000=kOk000
00000`3Ngn`00`000000g]o/000000020=kOk0040000003Ngn`0g]o/0000
00<0g]o/00<000000=kOk00000000`3Ngn`00`000000g]o/0=kOk0020=kO
k0030000003Ngn`0g]o/0140g]o/00H0oooo000lM03Wi^T0IVIn0:RY^`3k
o?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo00d0hnG`
00<000000>?Ul03SiO000P3SiO000`000000hnG`000000030>?Ul0030000
003SiO0000000080hnG`00@000000>?Ul03SiO0000000`3SiO000`000000
hnG`000000030>?Ul0030000003SiO00hnG`0080hnG`00<000000>?Ul03S
iO000P3SiO000`000000hnG`0>?Ul0050>?Ul0030000003SiO00hnG`00h0
hnG`00<0oooo000lM03Wi^T00`3Pgn<00`3IeMD003ad0?ooo`0=0>?Ul003
0000003SiO00hnG`0080hnG`00<000000>?Ul00000000`3SiO000`000000
hnG`000000020>?Ul0040000003SiO00hnG`000000<0hnG`00<000000>?U
l00000000`3SiO000`000000hnG`0>?Ul0020>?Ul0030000003SiO00hnG`
0140hnG`00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000L0IVIn
0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo00d0jN_e1@0000020>W[m@070000
003YjoD0jN_e0>W[m@000000jN_e000000020>W[m@040000003YjoD0jN_e
000000<0jN_e00@000000>W[m@00000000000P3YjoD00`000000jN_e0>W[
m@020>W[m@D00000203YjoD00`000000jN_e0>W[m@0>0>W[m@030?ooo`00
?7@0inKY00<0h=oS00<0fMGE000lM03oool03@3YjoD500000080jN_e00L0
00000>W[m@3YjoD0jN_e0000003YjoD000000080jN_e00@000000>W[m@3Y
joD000000`3YjoD010000000jN_e0000000000020>W[m@030000003YjoD0
jN_e0080jN_e00<000000>W[m@3YjoD04@3YjoD01P3oool003ad0>OVj@1V
IWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03o
ool03@3`lO`00`000000l?7l0?3ao0020?3ao0030000003`lO`0000000<0
l?7l1`0000020?3ao0<000000P3`lO`010000000l?7l0000000000050?3a
o0030000003`lO`0l?7l0080l?7l00<000000?3ao03`lO`00`3`lO`00`00
0000l?7l0000000@0?3ao0030?ooo`00?7@0inKY00<0h=oS00<0fMGE000l
M03oool03@3`lO`00`000000l?7l0?3ao0020?3ao0030000003`lO`00000
00<0l?7l1`0000020?3ao0<000000P3`lO`010000000l?7l000000000005
0?3ao0030000003`lO`0l?7l0140l?7l00H0oooo000lM03Wi^T0IVIn0:RY
^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo00d0
m?Gm00<000000?Ceo@3dmOd00P3dmOd00`000000m?Gm0?Ceo@050?Ceo@04
0000003dmOd0m?Gm00000140m?Gm00<000000?Ceo@3dmOd00P3dmOd00`00
0000m?Gm0?Ceo@040?Ceo@800000403dmOd00`3oool003ad0>OVj@030>3O
h`030=WEe@00?7@0oooo00d0m?Gm00<000000?Ceo@3dmOd00P3dmOd00`00
0000m?Gm0?Ceo@050?Ceo@040000003dmOd0m?Gm00000180m?Gm00D00000
0?Ceo@3dmOd0m?Gm0000000>0?Ceo@060?ooo`00?7@0inKY06IVOP2XZK/0
nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0=0?Kg
o@D00000203fmod010000000m_Om0?Kgo@00000A0?Kgo@D00000203fmod0
0`000000m_Om0?Kgo@0>0?Kgo@030?ooo`00?7@0inKY00<0h=oS00<0fMGE
000lM03oool03@3fmod5000000P0m_Om00@000000?Kgo@3fmod000004`3f
mod3000000l0m_Om00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo04d0n?cm00<0oooo000l
M03Wi^T00`3Pgn<00`3IeMD003ad0?ooo`130?Slo@060?ooo`00?7@0inKY
06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad
0?ooo`1=0?gmo@030?ooo`00?7@0inKY00<0h=oS00<0fMGE000lM03oool0
@`3moOd01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0
nocm0:RY^`1VIWh0fMGE000lM03oool0C@3moOd00`3oool003ad0>KVj@03
0>3Oh`030=WEe@00?7@0oooo04<0oOgm00H0oooo000lM03Vi^T0IVIn0:RY
^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=SDe000?7@0oooo04d0
oOgm00<0oooo000lM03UiNP00`3Pgn<00`3He=@003ad0?ooo`130?gmo@06
0?ooo`00?7@0iNGX06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP3IeMD09EN50;o>g01=0?ooo`030;o>f`0UEhD0hN7T00<0h=oS00<0
fMGE02EGQ@2oc]`0@`3oool01P2oc]/09EN50>7Qi01VIWh0Z:Vk0?_lo@40
IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE07VDZ@1EOJ80`<oMB`3oool0
103EgnP0EGfR07VEZ`3OgN030>3Oh`040=WEe@1iU:T0EGfR0<3?gD40oooo
00L0eMoX05EmXP1iUJ/0gmgP06IVOP2XZK/0nocm0040IVIn0000201VIWh0
nocm0:RY^`1VIWh0f]OI0=oLf01iU:T09EN5B`00?7@0100GCGh0IXJQ0>3N
fP3Lfmd30>3Oh`040=[Gf@3Og=P0NIBY02EGQD4003ad00L05den06J6X@3P
g]X0g=_M06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0
gmgP0=[Gf@3He=@09`3Gdm@R0=?>c0<0em?D00@0f=CD0=WEe@3JemT0gmgP
0`3Pgn<00`3OgN00f]OI0=SDe00R0=OCe1d0dlk<0`3Gdm@01`3He=@0fMGE
0=[Gf@3OgN00IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OYl0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OYl0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OYl0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000906IVOP3ko?d0Z:Vk06IV
OP3Qh>@0i^GX0>c[kP3`l?80l_;d02D0lo?d8P3hmoP20??cm0050??cm@3d
m?D0mOGf0?Ccm@3Ui>P0C03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0
IVIn0?_lo@2XZK/0IVIn0=kLg`3Th^00NiN]02EGQD/003ad00@05den06^;
YP3blNh0l_7cC03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_l
o@2XZK/0IVIn0=[Hf@1VQJ409df504em`D`0JH;^00<09df506Z:Y03_ko40
C03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn
0=SEeP0GCGi?08V]i00301M=OP3[j^d0h=oS04/0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad08V]i03ooom;
0<g<g`040?ooo`29[N@003ad0>SWjT`0h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad08^]i03ooom;0=;Ai004
0?ooo`2;[nD003ad0>OVjD`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00008
06IVOP3ko?d0Z:Vk06IVOP3IeMD003ad08j_iP3ooom;0=KGi`040?ooo`2=
[nD003ad0>OVjD`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3k
o?d0Z:Vk06IVOP3IeMD003ad096ai`3oool@0=WJi`D000000`3If^L20000
00030=WJi`000000fM[W0080000000<0fM[W0000000000000P3If^L30000
0080fM[W00D000000=WJi`3If^L0fM[W000000040=WJi`030000003If^L0
fM[W00<0fM[W00<000000=WJi`3If^L0403If^L0103oool0TK7V000lM03W
i^U<0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1V
IWh0fMGE000lM02D]>P0oooo403If^L00`000000fM[W0=WJi`020=WJi`03
0000003If^L000000080fM[W0P0000001@3If^L000000=WJi`3If^L00000
0080fM[W00L000000=WJi`3If^L0fM[W0000003If^L0000000<0fM[W00<0
00000=WJi`3If^L00P3If^L00`000000fM[W0=WJi`030=WJi`030000003I
f^L0fM[W0100fM[W00@0oooo09Fdj000?7@0inKYC03Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0V;SZ0?oo
oa00g]o/00<000000=kOk03Ngn`00P3Ngn`00`000000g]o/000000030=kO
k0030000003Ngn`000000080g]o/00@000000=kOk03Ngn`000000`3Ngn`0
0`000000g]o/000000030=kOk0030000003Ngn`0g]o/00<0g]o/1@00000C
0=kOk0040?ooo`2H^>T003ad0>OVjD`0h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad09bkjP3oool@0>?Ul003
0000003SiO00hnG`0080hnG`00<000000>?Ul00000000`3SiO000`000000
hnG`000000020>?Ul0040000003SiO00hnG`000000<0hnG`00<000000>?U
l00000000`3SiO000`000000hnG`0>?Ul0030>?Ul0050000003SiO00hnG`
0>?Ul00000004`3SiO00103oool0W;_[000lM03Wi^U<0>3Oh`0306IVOP2X
ZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM02P_^`0
oooo403YjoD500000080jN_e00L000000>W[m@3YjoD0jN_e0000003YjoD0
00000080jN_e00@000000>W[m@3YjoD000000`3YjoD010000000jN_e0000
000000020>W[m@030000003YjoD0jN_e00@0jN_e00<000000>W[m@000000
503YjoD0103oool0XKk/000lM03Wi^U<0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM02U`Nd0oooo403`lO`0
0`000000l?7l0?3ao0020?3ao0030000003`lO`0000000<0l?7l1`000002
0?3ao0<000000P3`lO`010000000l?7l0000000000070?3ao0030000003`
lO`0000001@0l?7l00@0oooo0:G2kP00?7@0inKYC03Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0ZLG_0?oo
oa00m?Gm00<000000?Ceo@3dmOd00P3dmOd00`000000m?Gm0?Ceo@050?Ce
o@040000003dmOd0m?Gm000001<0m?Gm00<000000?Ceo@000000503dmOd0
103oool0ZLG_000lM03Wi^U<0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
201VIWh0nocm0:RY^`1VIWh0fMGE000lM02]b?00oooo403fmod5000000P0
m_Om00@000000?Kgo@3fmod00000503fmod00`000000m_Om0?Kgo@0C0?Kg
o@040?ooo`2/ao0003ad0>OVjD`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0;7;lP3ooom;0?Slo@040?oo
o`2ac?8003ad0>OVjD`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000806IV
OP3ko?d0Z:Vk06IVOP3IeMD003ad0;C=l`3ooom;0?gmo@040?ooo`2ec_<0
03ad0>OVjD`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0
Z:Vk06IVOP3IeMD003ad0;O@m03ooom;0?gmo@040?ooo`2hd?D003ad0>KV
jD`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IV
OP3He=@003ad0;[Cm@3ooom;0?gmo@040?ooo`2jdoH003ad0>GUj4`0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3IeMD0
9EN5C`2le?H00`0UEhD0hN7T0>3Oh`1;0>3Oh`0306IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE07VDZ@0WCHD0C@3>iol00`0W
CHD0NIF[0=oMh01<0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000201VIWh0
nocm0:RY^`1VIWh0f]OI0=oLf01iU:T09EN5B`00?7@0100GCGh0IXJQ0>3N
fP3Lfme<0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY
^`1VIWh0gmgP0=[Gf@3He=@09`3Gdm@R0=?>c0<0em?D00@0f=CD0=WEe@3J
emT0gmgPC03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000<0IVIn0?Ogn@2H
V:L0X@1gMi8109RHY`40moOi0@1VIWh0000306IVOP3gmoT0_;g=0:80_;g=
0@3gmoT106IVOP0000<0IVIn0?Ogn@3Thn<0XP3Thn<10?Ogn@40IVIn0000
0`1VIWh0l?7d0?ooo`1K0?ooo`030>CSh`2LY;T0JgF?00<0JgF?00@0K7J@
06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0i>?S09bT^@@0
JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0
k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0YcY42@2V>D@00`2LY;T0k>[Z
0?ooo`030?ooo`40l?7d0@1VIWh0000F06IVOP3RhN80nocl0?_ko03ko?d0
o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m0?clo03lno`0o?cl0?_lo03l
o?`0nocm0?cko03lo?d0no_m0?_lo080o?cl00@0o?cm0?clo03knod0o?cm
8`3lno`O0?_lo00309bT^@1[MHl0QHV`0100QHV`00H0JgF?09bT^@3ko?d0
nocm09bT^@1[MHlA08F9/00606]eS`2LY;T0nocl0?_ko02LY;T0YSU44@2Z
?5D01`2V>D@0W:Bi0?_lo03lo?`0o?_m0?_lo@3RhN800@1VIWh0000406IV
OP3Ph>40m_Oi0?Ogn@80m_Oi00/0m_Oh0?Ogn@3gmoP0m_Oh0?Kgn@3gmoP0
moOi0?Ofn03fmoT0moOi0?Kgn@020?Ogn@040?Ofn03fmoP0m_Oi0?Ogn@<0
m_Oi00<0m_Oh0?Ogn@3gmoT08P3gmoTO0?Kgn@0306]eS`25RK00W9jn0100
W9jn00H0QHV`06]eS`3gmoT0moOi06]eS`25RK0A09bN_P0808F9/01[MHl0
m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=0<IEG0090<IDFP32DU/0ZSaE0:Hi
A03gmoP0moOi0?Ogn03gmoT0h>3Q0040IVIn00001P1VIWh0g]gQ0?7am03a
lO@0l?7d0?3bm100000000H0lO7d0?3bm@3alO@0lO;d0?3bm03alOA20?3a
m@0306]eS`2b]M00YjS20100YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b
]M0A0:NX`P050;:ed01[MHl0l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN
0<eIGP0;0<eIGP040<]DF@32DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03N
gN400@1VIWh0000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__000000020>OW
i`80g]kN0P3WinL00`3W_H@0inOW0>OWi`030>OWi`80kno_00@000000>[[
l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`0>[[l00Q0>[[l1l0j^c`00@0JgF?
0;Jid@2][/H0[Jk6203oool00`2][/H0[:k60:f^aP030:f^aP030:b^aP2f
^M40JgF?0080j^__00@0JgF?0;Jid@2][/H0[Jk6303oool20:f^aP030:b^
aP2f^M40JgF?0080j^_`00D0YSU40<eIGP3;E5T0cEIK0<iIG`0;0=1JG`07
0<iIG`3=EU/0beAI0<eIGP2V>D@0j^__0>[[l0020>[[k`40g=_P0@1VIWh0
000406IVOP3IfMl0hnGZ0>?TjP80hnG[00D0000008b<S03Ng]h0inOW0=kN
gP020>OWi`030<IS003WinL0inOW0080inOW00L0knoW0>o_k`3_knl00000
0>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[0>?Uj`3SiN/08@3SiN/O0>?TjP05
06]eS`2l_]@0/[;:0;:bbP3oool01P1^KHl00`0U9CH0/[;:0;:bbP050;:b
bP060;bne01[MHl0hnGZ0>?UjP1[MHl0_;kD0P2b//X00`3oool09BDf02DU
=P0902DU=P<0/[;:00D0_;kD06]eS`3Si>/0hnC[0:HiA0020<eIGP040=1K
H03DG5l0oooo0?ooo`L0e5aO0P3oool02P3DG5l0d5]P0<eIGP3=FEh0YSU4
0>?TjP3SiNX0hnCZ0>?Uj`3IfMl106IVOP0000<0IVIn0=OHgP3Lg^H00`3L
g^H01@000000inOW0>OWi`3WinL0imK>0080inOW00D0cW/00>nD403WinL0
imk60>n<40030>o_k`070000003Lg^H0g=kU0=cNi@3Lg^H0g=kU0=cNiP12
0=cNi@0506]eS`2o`MH0^;W>0;RicP3oool01P1^KHl00`0U9CH0^;W>0;Ri
cP050;RicP060;o1eP1[MHl0g=kU0=cNi@1[MHl0_l7F0P2h^Lh00`3oool0
9BDf0;RicP070;RicP030?ooo`0U9CH0^;W>0080^;W>00T0_l7F06]eS`3L
g^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C9B000`3oool50=IOH`<0oooo00D0
DbDP0=AMH@3AFUh0cEUN0:HiA0020=cNi@030=cNiP3Lg^D0emSN0040IVIn
0000101VIWh0eMKM0=GHh03Ff>420=GHh0090000002<S8`0inOW0>OWi`3W
]H@0eUX00=J4003ocP00cV<00080gV/000D0kkF<0>o_k`3_knl0kno_0000
00020=GHh@040=GGh03Ff>00e]SQ0=KGhB<0e]OP7`3Ff>001@1[MHl0`lGI
0;bmd@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?0=GHh@3Ef>40JgF?
0<?5f@80_;gA00<0oooo02DU=P2l_M401`2l_M400`3oool09BDf0;bmd@02
0;bmd@050<?5f@1[MHl0e]OP0=GGh@2V>D@00P3EGF000`3HH640fF5R04HN
6P030?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@020=EMH0060:HiA03F
f>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0000706IVOP3Be=d0cm;L0=3Bg03@
d]d0d=;L000000030>OWi`0<0>ONcP36BP00mlh00>n]003_]@00cV/00<IJ
0036J`00gXa:0>NU003_ilh000000`3@d]`00`3?d]`0d=;L0<oBg00S0=3B
g1l0cm;M00<0JgF?0<S9f`33a=H04033a=H01P38bM/0JgF?0=3Bg03@d]`0
JgF?0<S9f`80`lCF00<0oooo02DU=P33a=H01`33a=H00`3oool09BDf0<?4
eP020<?4eP070<S9f`1[MHl0cm;L0<oBg02V>D@0eemO0=UQHP030=aUI@05
04HN6P3oool0oooo0?ooo`3LIFD00`3oool020167QX0g6EU0=aUI@3LIFD0
fF5R0=MOG`2V>D@0d=;M0P3@d]`10<oBg040d]CM0@1VIWh0000L06IVOP3@
d]/0blgH0<[=f@3;c]P0b/gH0000003WaZd0ilJ<0?O>603__@00mlH00>n]
003W[@00ijD00=J<003>J`00ilH00?oF003_knL0kno_0000003;cMP0blgI
0<[=f@3;c]P0b/gH0<_=f2<0blgI7`3;c]T00`1[MHl0blcN0<S:f@080<S:
f@030<S9f@38b]T0b<[I00<0b<[I00@0b<WI0<S:f@3;c=h0JgF?0P3;cMP0
1P1[MHl0blcN0<S:f@38b]T0oooo02DU=PD0b<[I0140b<WI0<S:f@38b]T0
oooo02DU=P38b]T0b<WI0<S:f@3;c=h0JgF?0<_>f03:cMP0YSU40=MOG`3K
I6@0h6MU0>1VI@020=iWI`0304HN6P3oool0oooo00<0oooo00X0AQhJ0=iW
I`3NIfL0h6IU0>1WI@3KI6@0eemO0:HiA03:c]P0b/kI0P3;cMT10=3Bf`40
IVIn00000`1VIWh0cloJ0<G8e0030<G8e00600000036a/H0imkF0<ik003W
[@00kkD00P3WY@000`3FU000cW<00=JD00020?O60080moOg00@000000<G8
e035am@0aLOD0`35amDS0<C7eAl0a<SD00<0JgF?0=3Ah03;bm`0403;bm`0
1P3@dN00JgF?0<C7e034am@0JgF?0=3Ah080bl_L00<0oooo02DU=P3;bm`0
1`3;bm`00`3oool09BDf0<_;g0020<_;g0070=3Ah01[MHl0aLOD0<C7e02V
>D@0ffAT0=mUI0050>1ZJ00504HN6P3oool0oooo0?ooo`167QX01@3PJVP0
103OIF@0ffAT0:HiA034b=D20<C8e040aLOE0@3?cmX106IVOP0000@0IVIn
0<c>fP32a=80`LCA0P31a=801P000000inOW0>OWi`3WinL0eX@00>ne0080
ijD000P0eX@00<i[003W[@00mkD00?Nm003_knl0moOg000000<0`LCB00<0
`/CA0<74dP31a=808`31a=4O0<74dP0306]eS`3Cdn80cm3M0100cm3M00H0
dm?R06]eS`32a=80`/CB06]eS`3Cdn820<o@g@030?ooo`0U9CH0cm3M00L0
cm3M00<0oooo02DU=P3?d=d00P3?d=d01`3Cdn80JgF?0<;4dP31a=40YSU4
0=]TI03QJFD01@3PK6T50?ooo`D0h6aY00P0hFUU0=]TI02V>D@0`LCB0<;4
d@31a=40`LCB0<c>fP40IVIn0000101VIWh0b/cH0;k0c`2m`<l20;k0cP05
0000002LW9`0inOW0>ONeP3FS0000P3NU000103FN`00aV<00;e2003_Y@02
0?N]00080?Ne003ocTX000000;k0cP2n`<l0_/3>0;k0c`2m`<hT0;k0cQl0
_L3>00<0JgF?0=KFi03Cdn00403Cdn001P3Fe^@0JgF?0;k0cP2n`<h0JgF?
0=KFi080dm?P00<0oooo02DU=P3oool0203oool02`0U9CH0dm?P0=?Ch03C
dn00e]KT06]eS`2n`<l0_/3>0:HiA03PIVD0hFYZ00@0hfa/0`3oool01016
7QX0oooo0?ooo`3oool40>=/K0040>5ZJP3PIVD0YSU40;g0c`80_/3?0@2n
`<h10<[<f040IVIn00001`1VIWh0bL[H0;Jhb02i_</0^[c;0;Zlc0000000
0P3_knl04`3FW000eX`00=jD003FQ000kjD00=j<002mFP00eW<00>nL003g
knL0moOg0?ooo`000000^Kc<0;Zkc02i_</0^[c;0;Vlc02i_</08`2i_<`O
0;Zlc00306]eS`3Hf>D0dm?Q0100dm?Q00H0f=SU06]eS`2j_</0^[c;06]e
S`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40
dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0
oooo00<0AQhJ0>A`KP167QX00`3oool20>A`KP090>AaK@3QKF`0h6UX0:Hi
A02j_<`0^[_<0;Vlb`2f^<P0bL[H0040IVIn00002@1VIWh0alWG0;Bfa`2f
^<P0][S90;Jib@000000Q8B40>OWgP020>o_k`070<I[003gaP00kkD00>nL
003NS000cV/00>NL00030?Ogm`050000002f^LT0]kS90;Jib@2g^LT00P2f
^<TS0;NhbAl0][S900@0JgF?0=KFi03Hf>D0f=SV0`3Hf>D50=SHiP<0f=SU
0P3Hf>H20=SHi@090=KFi01[MHl0]kS90;Nhb@1[MHl0e]KT0=SHi@3Hf>H0
oooo00X0KVf?00d09BDf0=SHiP3Hf>D0f=SU0=KFi01[MHl0]kS90;Nib@2V
>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo00D0AQhJ0>AdK`3TM6l0i7A_04HN
6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^K@2V>D@0][W90;Jhb@2f^LT0];K7
0<O9e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`030000003_knl0kno_
0080kno_00/0ijd00?O6203WY@00ii@00>N<003_imH0gY@i0>oF]@3omoL0
oooo000000180;Bfa`0506]eS`3EeN<0g=_W0=cKi`3MfnL03P3LfnL01P3E
eN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80g=_W00<0gM_W02DU=P0U9CH02@0U
9CH30=cKi`090=GEh`1[MHl0];K70;Bfa`2V>D@0ig=_0>MeLP3ZMW<0jWQf
0080oooo00<0AQhJ0>UnN03YOWP00`3YOWP020167QX0oooo0?ooo`3ZN7H0
jWIc0>MeLP3WLfl0YSU4102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;Bf
a`030;Bfa`060000002<S8`0kno_0>o_k`3WcW/0kno_0P3gmoL0203WU000
mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool00000B02d]/L00`1[MHl0eMCS0>3O
jP0@0>3OjP060=GDh`1[MHl0];K70;Bfa`1[MHl0eMCS4@3PgnX02@3Ee><0
JgF?0;Bfa`2d]/L0YSU40>YiL`3YO7P0kh5j0?:9P@0204HN6P070>^HR`3Z
Vh`0kIN:0>^HR`3ZVh`0kIN:0>^HR`0204HN6P050?:9P@3_PGX0jGah0>Yi
L`2V>D@0102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;6cb0030;6cb006
0000003_knl0kno_0>o_k`3gmnl0kno_0P3gmoL00`3gilH0moOg0?ooo`03
0?Ogm`030?ooo`000000/K?804L0/K?800<0JgF?0>g[l`3Yj?40403Yj?40
1P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[la40jNSa01T0kN_c06]eS`2a/lP0
/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0lZ^F0?6bV`3]]9/0k;FL0?6bV`3]
]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3gWHh0mHb40?24O03aP7D0YSU400@0
/K?80@36b=L106IVOP0000<0IVIn0<K8e`2h]ll00`2_[/L01@000000[Jf]
0?Ogk`3gmoL0kno_00H0moOg0P3omoL20?ooo`030000002_[/L0[jk704H0
[jk700<0JgF?0=;Ah`3blOL0403blOL01P3BdN<0JgF?0:n^a`2_[/L0JgF?
0=;Aha40l_7g00H0d]7S06]eS`2_[/L0[jk70:HiA03dRWd20?F@Q@d0l[RN
0P3eT8D00`3dRWd0YSU40:n^a`020:n^a`40^;O?0@36b=L106IVOP0000<0
IVIn0<31d@37am@0F`2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_k
o03<bmd0JgF?08B<XP80[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103k
no`0c<_M06]eS`24S:820:b[a007096HZP2V>D@0oin=0?joY03jg;L0n^^g
0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf0?[Y]P80nNVf00H0n^^g0?[L]`3n
_j@0oin=0:HiA02AV:X30:b[a040alOD0@30`M4106IVOP0000@0IVIn0<31
d@3Bd]l0]KC9F`2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0
Y:>n0080Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P02
0:BS_P0308B<XP2V>D@0YSU400l0YSU400L0Q8bR0:BS_P2TXkh0Y:>n0;Fd
b@3Bd]l0`<7A0040IVIn00001P1VIWh0Z:No0>KVk@3Bd^00_;c?0;6`a9/0
Z:No00D0/K340;blc`3Bd^00i^K]0:RW_`0106IVOP0000L0F5MX08N7V`3G
f>80o?cl0>CSj03@d>00b/[J09T0_;c?00H0b/[J0=3@h03ThnP0o?cl0=OH
hP27Qi/105QGJ00000P0F5MX06IVOP2EU:/0emSR0?clo03blO<0k>_^0>7R
jiL0emSR00L0hN;[0>c[kP3blO<0o?cl0=OHhP2EU:/0IVIn0040F5MX0002
05QGJ00306IVOP2EU:/0dM7N0080o?clV@3oool20?clo0030=7AgP2EU:/0
IVIn0080F5MX000305QGJ080IVIn00<0R8NM09FDZ`2XYkl0V02XYkl0102E
U:/0R8NM06IVOP1VIWh305QGJ0001@1HEfRM06IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[17]:=",
  Evaluatable->False,
  ImageSize->{167, 109},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[17]=",
  CellTags->"WidgetGroup-Layout"]
}, Open  ]],

Cell[TextData[{
  "Here we see an example of the ",
  StyleBox["Grid", "Output"],
  " grouping."
}], "Text",
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
\[IndentingNewLine]WidgetGroup[{\[IndentingNewLine]{Widget["\<Label\>", \
{"\<text\>" -> "\<A:\>"}], \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<A content\>"}]}, \[IndentingNewLine]{Widget["\<Label\>", {"\
\<text\>" -> "\<B:\>"}], \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<B content is the largest of all\>"}]}, \
\[IndentingNewLine]{Widget["\<Label\>", {"\<text\>" -> "\<C:\>"}], \
\[IndentingNewLine]Widget["\<TextField\>", {"\<text\>" -> "\<C content is \
larger than A\>"}]}\[IndentingNewLine]}, \ 
              WidgetLayout \[Rule] 
                Grid]\[IndentingNewLine]]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002Z0000I2000`400?l0
0000o`00003oZP1VIWh0000306IVOP3ko?d0nocm0:H0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0:D0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
Y01VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPh0h=oS
U02U[;800`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
3P3Pgn<00`2U[;80oooo0?ooo`2@0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWh>0>3Oh`030:F//P3oool0oooo0900
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OPh0h=oS00<0YJbb0?ooo`3oool0T03oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn3P3Pgn<00`2U[;80oooo0?ooo`1;
0?ooo`@00000@@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn3P3Pgn<00`2U[;80oooo0?ooo`1?0?ooo`030000003o
ool0oooo03h0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOP80h=oS0`0000020>3Oh`030000003Pgn<0h=oS00@0h=oS
00<0YJbb0?ooo`3oool01@3oool3000000H0oooo0`0000030?ooo`<00000
0P3oool01P000000oooo0?ooo`3oool000000?ooo`8000000P3oool30000
0080oooo00H000000?ooo`3oool0oooo0000003oool2000000@0oooo00<0
00000?ooo`3oool00`0000050?ooo`030000003oool0oooo0080000000@0
oooo0000003oool00000103oool2000000040?ooo`000000oooo0?ooo`<0
00000P3oool00`000000oooo0?ooo`040?ooo`80000000<0oooo0000003o
ool00P3oool00`000000oooo0?ooo`02000000040?ooo`000000oooo0000
00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo0140oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000606IVOP3ko?d0Z:Vk06IVOP3Pgn<000000`3Pgn<00`000000h=oS0>3O
h`060>3Oh`030:F//P3oool0oooo00@0oooo00D000000?ooo`3oool0oooo
000000040?ooo`070000003oool0oooo0?ooo`000000oooo000000030?oo
o`030000003oool0000000<0oooo00<000000?ooo`0000000P3oool01`00
0000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0000
00050?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo000000020?ooo`80000000<0oooo0000003oool00P3o
ool00`000000oooo0?ooo`02000000030?ooo`000000oooo0080oooo00<0
00000?ooo`0000001P3oool010000000oooo0?ooo`0000030?ooo`030000
003oool000000080oooo0P0000000`3oool000000?ooo`020?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0A0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0000000d0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3o
ool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000P3oool0
0`000000oooo0?ooo`030?ooo`070000003oool0oooo0?ooo`000000oooo
000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0`3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo
00L000000?ooo`3oool0oooo0000003oool0000000D0oooo00<000000?oo
o`3oool0103oool010000000oooo0?ooo`0000030?ooo`030000003oool0
000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`03
0?ooo`D00000503oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn0000000=0>3Oh`030:F//P3oool0oooo00<0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`030000003oool000000080
oooo1@0000000`3oool000000?ooo`020?ooo`030000003oool0000000D0
oooo00<000000?ooo`3oool00P0000060?ooo`030000003oool0oooo00@0
000000<0oooo0000003oool00P3oool01P000000oooo0?ooo`3oool00000
0?ooo`D0000000<0oooo0000003oool01@3oool010000000oooo0?ooo`00
00030?ooo`030000003oool0oooo00@0000000<0oooo0000003oool00P3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000
503oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn0000000=0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3o
ool01`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool0
10000000oooo0000000000020?ooo`030000003oool000000080oooo00H0
00000?ooo`3oool0oooo0000003oool200000080oooo00<000000?ooo`00
00001@3oool00`000000oooo000000030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`0000000`3oool010000000oooo0000000000020?oo
o`030000003oool0oooo0080000000<0oooo0000003oool00P3oool01000
0000oooo0000000000050?ooo`030000003oool0oooo008000000P3oool0
0`000000oooo000000030?ooo`040000003oool0000000000080oooo00<0
00000?ooo`3oool0103oool00`000000oooo0000000E0?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000H0h=oS
00<000000>3Oh`3Pgn<0103Pgn<00`2U[;80oooo0?ooo`030?ooo`030000
003oool0oooo00P0oooo0`0000030?ooo`<000000P3oool01@000000oooo
000000000000oooo00<000000P3oool300000080oooo00D000000?ooo`00
000000000?ooo`03000000@0oooo00<000000?ooo`3oool00`0000050?oo
o`030000003oool0oooo00<000000P3oool00`000000oooo000000020?oo
o`80000000@0oooo0000003oool0oooo0`0000020?ooo`030000003oool0
000000<0oooo0`0000000`3oool000000?ooo`02000000<0oooo0`000002
0?ooo`040000003oool00000000000L0oooo00<000000?ooo`0000005@3o
ool0102U[;80IVIn0:RY^`3ko?d106IVOP0000H0IVIn0?_lo@2XZK/0IVIn
0>3Oh`0000030>3Oh`030000003Pgn<0h=oS00H0h=oS00<0YJbb0?ooo`3o
ool0103oool01@000000oooo0?ooo`3oool0000001H0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
01`0oooo00@000000?ooo`3oool000005P3oool00`000000oooo0000000E
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWh20>3Oh`<000002@3Pgn<00`2U[;80oooo0?ooo`050?ooo`<000005`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0L0?ooo`040000003o
ool0oooo000001L0oooo00<000000?ooo`3oool0503oool0102U[;80IVIn
0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn3P3Pgn<00`2U[;80
oooo0?ooo`2@0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0
nocm0:RY^`1VIWh>0>3Oh`030:F//P3oool0oooo0900oooo00@0YJbb06IV
OP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPh0h=oS00<0YJbb
0?ooo`3oool0T03oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn3P3Pgn<00`2U[;80oooo0?ooo`2@0?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWh>0>3Oh`030:F/
/P3oool0oooo0900oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOPh0h=oSU02U[;800`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInXP3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInXP3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInXP3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn3P3Pgn>D0:F//P0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWh>0>3Oh`030:F//P3oool0oooo0900
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OPh0h=oS00<0YJbb0?ooo`3oool0T03oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn3P3Pgn<00`2U[;80oooo0?ooo`2@
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWh>0>3Oh`030:F//P3oool0oooo05d0oooo1000000_0?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWh>0>3Oh`030:F/
/P3oool0oooo0640oooo00<000000?ooo`3oool0;03oool0102U[;80IVIn
0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@0000020>3Oh`03
0000003Pgn<0h=oS00@0h=oS00<0YJbb0?ooo`3oool00`3oool5000000H0
oooo0`0000030?ooo`<000000P3oool01P000000oooo0?ooo`3oool00000
0?ooo`8000000P3oool300000080oooo00H000000?ooo`3oool0oooo0000
003oool2000000@0oooo00<000000?ooo`3oool00`0000050?ooo`800000
00<0oooo0000003oool00P3oool00`000000oooo0?ooo`03000000D0oooo
00<000000?ooo`3oool00P000000103oool000000?ooo`0000040?ooo`80
000000@0oooo0000003oool0oooo0`0000030?ooo`<000000P3oool20000
00D0oooo0`0000030?ooo`030000003oool0oooo00@0oooo0P0000001P3o
ool000000?ooo`000000oooo000000D0oooo00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000103Pgn<00`000000h=oS
0>3Oh`060>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`00
0000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?oo
o`0000000P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3o
ool00`000000oooo000000050?ooo`030000003oool0000000<0oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`0000030?ooo`030000
003oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo
000000020?ooo`80000000<0oooo0000003oool00P3oool00`000000oooo
0?ooo`02000000030?ooo`000000oooo0080oooo00<000000?ooo`000000
0`3oool00`000000oooo000000050?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080
000000@0oooo0000003oool000001@3oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000040>3Oh`030000003Pgn<0
h=oS00H0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool0
1`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo
000000020?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool0
oooo0000003oool0000000D0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`030?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`000000203oool00`000000oooo000000030?ooo`030000003oool0
000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000P0oooo
00@000000?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool00`3oool02@000000oooo0?ooo`3oool0
00000?ooo`000000oooo000000050?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000@0h=oS00<000000>3Oh`3P
gn<01P3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`07
0000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0
00000080oooo1@0000000`3oool000000?ooo`020?ooo`030000003oool0
000000D0oooo00<000000?ooo`3oool00P0000060?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`000000100000040?ooo`030000003o
ool0oooo00@0000000<0oooo0000003oool00P3oool01P000000oooo0?oo
o`3oool000000?ooo`D000000P3oool2000000<0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool0103oool4000000040?ooo`000000oooo000000D0oooo00@0YJbb
06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPD000002@3P
gn<00`2U[;80oooo0?ooo`030?ooo`D000001@3oool01`000000oooo0?oo
o`3oool000000?ooo`0000000`3oool010000000oooo0000000000020?oo
o`030000003oool000000080oooo00H000000?ooo`3oool0oooo0000003o
ool200000080oooo00<000000?ooo`0000001@3oool00`000000oooo0000
00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P00
00020?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo000000030?ooo`040000003oool0000000000080oooo
00<000000?ooo`3oool00P0000000`3oool000000?ooo`020?ooo`030000
003oool0000000<0oooo00<000000?ooo`0000001@3oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool02@000000
oooo0?ooo`3oool000000?ooo`000000oooo000000050?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000@0h=oS
00<000000>3Oh`0000001P3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00`3oool3000000<0oooo
0`0000020?ooo`050000003oool000000000003oool00`0000020?ooo`<0
00000P3oool01@000000oooo000000000000oooo00<00000103oool00`00
0000oooo0?ooo`03000000@0oooo0`0000000`3oool000000?ooo`020000
00<0oooo0`0000050?ooo`030000003oool0oooo00<000000P3oool00`00
0000oooo000000020?ooo`80000000@0oooo0000003oool0oooo0`000003
0?ooo`<0000000@0oooo00000000000000001@3oool300000080oooo0`00
00050?ooo`<000000P3oool00`000000oooo000000050?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000@0h=oS
00<000000>3Oh`3Pgn<01P3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00@000000?ooo`3oool0
00003P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02@3oool00`000000oooo000000050?ooo`04
0:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWh50000
00T0h=oS00<0YJbb0?ooo`3oool00`3oool5000001L0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00P0oooo00@000000?ooo`3oool000003P3oool00`000000oooo0?ooo`0K
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool0
0`000000oooo000000050?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
101VIWh0nocm0:RY^`1VIWh>0>3Oh`030:F//P3oool0oooo0900oooo00@0
YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPh0h=oS
00<0YJbb0?ooo`3oool0T03oool0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn3P3Pgn<00`2U[;80oooo0?ooo`2@0?ooo`04
0:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWh>0>3O
h`030:F//P3oool0oooo0900oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOPh0h=oS00<0YJbb0?ooo`3oool0T03oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn3P3P
gn>D0:F//P0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjR0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjR0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjR0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWh>0>3Ohi@0YJbb00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOPh0h=oS00<0YJbb0?ooo`3oool0T03oool0102U[;80IVIn0:RY
^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn3P3Pgn<00`2U[;80oooo
0?ooo`2@0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm
0:RY^`1VIWh>0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3o
ool0RP3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn3P3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo
08X0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOPh0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`2:
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0000000D0h=oS00<000000>3Oh`0000001@3Pgn<00`2U[;80oooo0?oo
o`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3o
ool3000000<0oooo0`0000020?ooo`060000003oool0oooo0?ooo`000000
oooo0P0000020?ooo`<000000P3oool01P000000oooo0?ooo`3oool00000
0?ooo`800000G`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn000000050>3Oh`030000003Pgn<0h=oS00D0h=oS00<0
YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo000000020?ooo`07
0000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0
00000600oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP3Pgn<01@0000080>3Oh`030:F//P3oool0oooo00<0oooo1P00
00050?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool0oooo
0000003oool0000000<0oooo00<000000?ooo`0000000P3oool00`000000
oooo0?ooo`030?ooo`070000003oool0oooo0?ooo`000000oooo0000001P
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001P1VIWh0nocm0:RY^`1V
IWh0h=oS000000<0h=oS00<000000>3Oh`3Pgn<01P3Pgn<00`2U[;80oooo
0?ooo`030?ooo`8000000`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00<0oooo00L000000?ooo`3oool0oooo0000003oool00000
00<0oooo00<000000?ooo`0000000P3oool5000000030?ooo`000000oooo
0080oooo00<000000?ooo`000000H03oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`000000h=oS00000009
0>3Oh`030:F//P3oool0oooo00<0oooo00D000000?ooo`000000oooo0000
00060?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`04
0000003oool0000000000080oooo00<000000?ooo`0000000P3oool01P00
0000oooo0?ooo`3oool000000?ooo`8000000P3oool00`000000oooo0000
001P0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWh20>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0
0`3Pgn<00`2U[;80oooo0?ooo`030?ooo`050000003oool000000?ooo`00
00001`3oool3000000<0oooo0`0000020?ooo`050000003oool000000000
003oool00`0000020?ooo`<000000P3oool01@000000oooo000000000000
oooo00<00000G`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`000000h=oS000000090>3Oh`030:F//P3o
ool0oooo00<0oooo00D000000?ooo`000000oooo0000000H0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0GP3oool0102U[;80IVIn
0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<00`000000
h=oS0>3Oh`080>3Oh`030:F//P3oool0oooo00<0oooo00@000000?ooo`3o
ool000006@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
05h0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOPh0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`2:
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWh>0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0RP3o
ool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
3P3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo08X0oooo
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPh0
h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`2:0?ooo`04
0:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWh>0>3O
h`030:F//P3oool0oooo0900oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOPh0h=oSU02U[;800`1VIWh0Z:Vk0?_lo@01
06IVOP0000<0IVIn0?Ogn@2HV:L0Y01gMi8109RHY`40moOi0@1VIWh00003
06IVOP3gmoT0_;g=0:D0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3Thn<0
Y@3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`1N0?ooo`030>CSh`2L
Y;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S
0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl0
1P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0
YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F06IV
OP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m
0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080o?cl
00@0o?cm0?clo03knod0o?cm903lno`Q0?_lo00309bT^@1[MHl0QHV`0100
QHV`00H0JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9/00606]eS`2LY;T0
nocl0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_lo03lo?`0o?_m0?_l
o@3RhN800@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0m_Oh0?Og
n@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi0?Kgn@020?Ogn@04
0?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3gmoT08`3gmoTQ0?Kg
n@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi06]eS`25
RK0A09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=0<IE
G0090<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q0040IVIn
00001P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm100000000H0lO7d0?3bm@3a
lO@0lO;d0?3bm03alOA50?3am@0306]eS`2b]M00YjS20100YjS200H0/[G@
06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e0?7bm02V
>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0`U9K0:Hi
A080l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3Lfn00j^_`0>[[
l03Zk?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0inOW0>OWi`03
0>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`0>[[
l00R0>[[l240j^c`00@0JgF?0;Jid@2][/H0[Jk6203oool00`2][/H0[:k6
0:f^aP030:f^aP030:b^aP2f^M40JgF?0080j^__00@0JgF?0;Jid@2][/H0
[Jk6303oool20:f^aP030:b^aP2f^M40JgF?0080j^_`00D0YSU40<eIGP3;
E5T0cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0j^__0>[[
l0020>[[k`40g=_P0@1VIWh0000406IVOP3IfMl0hnGZ0>?TjP80hnG[00D0
000008b<S03Ng]h0inOW0=kNgP020>OWi`030<IS003WinL0inOW0080inOW
00L0knoW0>o_k`3_knl000000>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[0>?U
j`3SiN/08P3SiN/Q0>?TjP0506]eS`2l_]@0/[;:0;:bbP3oool01P1^KHl0
0`0U9CH0/[;:0;:bbP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[MHl0_;kD
0P2b//X00`3oool09BDf02DU=P0902DU=P<0/[;:00D0_;kD06]eS`3Si>/0
hnC[0:HiA0020<eIGP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3oool02P3D
G5l0d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl106IVOP00
00<0IVIn0=OHgP3Lg^H00`3Lg^H01@000000inOW0>OWi`3WinL0imK>0080
inOW00D0cW/00>nD403WinL0imk60>n<40030>o_k`070000003Lg^H0g=kU
0=cNi@3Lg^H0g=kU0=cNiP150=cNi@0506]eS`2o`MH0^;W>0;RicP3oool0
1P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU0=cNi@1[
MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U9CH0^;W>
0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C9B00
0`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA0020=cNi@03
0=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>420=GHh009
0000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080gV/000D0
kkF<0>o_k`3_knl0kno_000000020=GHh@040=GGh03Ff>00e]SQ0=KGhB@0
e]OP8@3Ff>001@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M401P33
aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M401`2l
_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V>D@0
0P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0fF5R
0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh00007
06IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36BP00
mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@d]`0
0`3?d]`0d=;L0<oBg00T0=3Bg240cm;M00<0JgF?0<S9f`33a=H04033a=H0
1P38bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80`lCF00<0oooo02DU=P33a=H0
1`33a=H00`3oool09BDf0<?4eP020<?4eP070<S9f`1[MHl0cm;L0<oBg02V
>D@0eemO0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3oool0
20167QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`10<oBg040
d]CM0@1VIWh0000L06IVOP3@d]/0blgH0<[=f@3;c]P0b/gH0000003WaZd0
ilJ<0?O>603__@00mlH00>n]003W[@00ijD00=J<003>J`00ilH00?oF003_
knL0kno_0000003;cMP0blgI0<[=f@3;c]P0b/gH0<_=f2@0blgI8@3;c]T0
0`1[MHl0blcN0<S:f@080<S:f@030<S9f@38b]T0b<[I00<0b<[I00@0b<WI
0<S:f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN0<S:f@38b]T0oooo02DU=PD0
b<[I0140b<WI0<S:f@38b]T0oooo02DU=P38b]T0b<WI0<S:f@3;c=h0JgF?
0<_>f03:cMP0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN6P3oool0
oooo00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO0:HiA03:
c]P0b/kI0P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0030<G8e006
00000036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD0002
0?O60080moOg00@000000<G8e035am@0aLOD0`35amDT0<C7eB40a<SD00<0
JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3Ah080
bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;g007
0=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3oool0
oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040aLOE
0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000inOW
0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm003_
knl0moOg000000<0`LCB00<0`/CA0<74dP31a=809031a=4Q0<74dP0306]e
S`3Cdn80cm3M0100cm3M00H0dm?R06]eS`32a=80`/CB06]eS`3Cdn820<o@
g@030?ooo`0U9CH0cm3M00L0cm3M00<0oooo02DU=P3?d=d00P3?d=d01`3C
dn80JgF?0<;4dP31a=40YSU40=]TI03QJFD01@3PK6T50?ooo`D0h6aY00P0
hFUU0=]TI02V>D@0`LCB0<;4d@31a=40`LCB0<c>fP40IVIn0000101VIWh0
b/cH0;k0c`2m`<l20;k0cP050000002LW9`0inOW0>ONeP3FS0000P3NU000
103FN`00aV<00;e2003_Y@020?N]00080?Ne003ocTX000000;k0cP2n`<l0
_/3>0;k0c`2m`<hU0;k0cR40_L3>00<0JgF?0=KFi03Cdn00403Cdn001P3F
e^@0JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3oool0203o
ool02`0U9CH0dm?P0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:HiA03PIVD0
hFYZ00@0hfa/0`3oool010167QX0oooo0?ooo`3oool40>=/K0040>5ZJP3P
IVD0YSU40;g0c`80_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0bL[H0;Jh
b02i_</0^[c;0;Zlc00000000P3_knl04`3FW000eX`00=jD003FQ000kjD0
0=j<002mFP00eW<00>nL003gknL0moOg0?ooo`000000^Kc<0;Zkc02i_</0
^[c;0;Vlc02i_</0902i_<`Q0;Zlc00306]eS`3Hf>D0dm?Q0100dm?Q00H0
f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?00P0
KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0h6UX
0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3oool20>A`
KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H0040IVIn
00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OWgP020>o_
k`070<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Ogm`050000002f
^LT0]kS90;Jib@2g^LT00P2f^<TT0;NhbB40][S900@0JgF?0=KFi03Hf>D0
f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@090=KFi01[MHl0]kS90;Nh
b@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d09BDf0=SHiP3Hf>D0f=SU
0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo00D0
AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^K@2V
>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn00000`1VIWh0a/SG0;Bfa`03
0;Bfa`030000003_knl0kno_0080kno_00/0ijd00?O6203WY@00ii@00>N<
003_imH0gY@i0>oF]@3omoL0oooo0000001;0;Bfa`0506]eS`3EeN<0g=_W
0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80g=_W
00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GEh`1[MHl0];K70;Bfa`2V
>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ0>UnN03YOWP00`3YOWP0
20167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d]/L10<K8e`40
IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`060000002<S8`0kno_0>o_k`3W
cW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool00000
B`2d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0];K70;Bfa`1[
MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0YSU40>YiL`3YO7P0kh5j
0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:0>^HR`0204HN
6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L10<K8e`40IVIn00000`1V
IWh0a/SG0;6cb0030;6cb0060000003_knl0kno_0>o_k`3gmnl0kno_0P3g
moL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`000000/K?804X0/K?800<0
JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[la40
jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0lZ^F
0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3gWHh0
mHb40?24O03aP7D0YSU400@0/K?80@36b=L106IVOP0000<0IVIn0<K8e`2h
]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3omoL20?oo
o`030000002_[/L0[jk704T0[jk700<0JgF?0=;Ah`3blOL0403blOL01P3B
dN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0d]7S06]eS`2_[/L0[jk7
0:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^a`020:n^a`40
^;O?0@36b=L106IVOP0000<0IVIn0<31d@37am@0GP2/Zl@01024S:80JgF?
0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400@0Q8bR06]e
S`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a007096HZP2V
>D@0oin=0?joY03jg;L0n^^g0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf0?[Y
]P80nNVf00H0n^^g0?[L]`3n_j@0oin=0:HiA02AV:X30:b[a040alOD0@30
`M4106IVOP0000@0IVIn0<31d@3Bd]l0]KC9GP2TXkh00`24S:80JgF?06]e
S`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]eS`1[MHl03`1[
MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V>D@0YSU400l0YSU400L0
Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040IVIn00001P1VIWh0Z:No
0>KVk@3Bd^00_;c?0;6`a9h0Z:No00D0/K340;blc`3Bd^00i^K]0:RW_`01
06IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@d>00b/[J09`0_;c?00H0
b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ00000P0F5MX06IVOP2EU:/0
emSR0?clo03blO<0k>_^0>7RjiX0emSR00L0hN;[0>c[kP3blO<0o?cl0=OH
hP2EU:/0IVIn0040F5MX000205QGJ00306IVOP2EU:/0dM7N0080o?clW03o
ool20?clo0030=7AgP2EU:/0IVIn0080F5MX000305QGJ080IVIn00<0R8NM
09FDZ`2XYkl0V`2XYkl0102EU:/0R8NM06IVOP1VIWh305QGJ0001@1HEfRP
06IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[19]:=",
  Evaluatable->False,
  ImageSize->{170, 100},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[19]=",
  CellTags->"WidgetGroup-Layout"]
}, Open  ]],

Cell["\<\
Here is an example that generates content within a set of tabbed panes.\
\>", "Text",
  CellTags->"WidgetGroup-Layout"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ 
      GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
\[IndentingNewLine]WidgetGroup[{\[IndentingNewLine]{Widget["\<Button\>", \
{"\<text\>" -> "\<Button A\>"}], \ 
                Widget["\<TextField\>", \ {"\<text\>" -> "\<someA\>"}]}, \
{Widget["\<Button\>", {"\<text\>" -> "\<Button B\>"}], \ 
                Widget["\<TextField\>", \ {"\<text\>" -> "\<someB\>"}]}\
\[IndentingNewLine]}, \ 
            Name -> "\<myTabPane\>", \[IndentingNewLine]WidgetLayout \[Rule] \
{"\<Grouping\>" \[Rule] {Tabs, \ 
                    Bottom, {"\<One\>", "\<Two\>"}}}]\[IndentingNewLine]]\
\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject5133274447873, 
        JLink`Objects`JavaObject218949966888961]]], "Output",
  CellLabel->"Out[20]=",
  CellTags->"WidgetGroup-Layout"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000JR000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3Pgn<0
gL:=0>BG?00L0>J;;0030>^G;P3QaXh0h=oS0540h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3QaXh0kYla0?^n>@0L0?o8
?0030?Vi>03^Wc40hLJ>0540h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00006
06IVOP3ko?d0Z:Vk06IVOP3MXE<0nKPh7P3oac`01@3i^3P0gJ5C0>3Oh`38
dLd0XK>k01X0TJNd00<0ZKVo0=3Fd03Pgn<0<@3Pgn<00`1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn096KW0020?cloP0J0000003l
o?h000000?cloP000000o?cn0000003lo?h000000?cloP000000o?cn0000
003lo?h000000?cloP000000o?cn0000003lo?h000000?cloP000000o?cn
0000003lo?h200000080o?cn00@0TI^L0=3Fd02fa<d0kO7c6P3oool00`3T
jN`0]/C=0=3Fd00a0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0TI^L0200o?cn00@0TI^L0:Vi_`3SjN/0o_km6P3oool0
0`3no_h0hnW/0:Vi_`0a0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1V
IWh0nocm0:RY^`1VIWh0TI^L0080o?cn00<000000?cloP3lo?h00`3lo?h3
000000<0o?cn00D000000?cloP3lo?h0o?cn000000020?cloP<000001@3l
o?h01P000000o?cn0?cloP2AVi`0TJNd0?KdlQ`0oooo00<0oOgl096W]03P
gn<0<03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn096KW0070?cloP050000003lo?h0o?cn0?cloP0000000P3lo?h01`00
0000o?cn0?cloP3lo?h000000?cloP0000000`3lo?h00`000000o?cn0?cl
oP050?cloP03096KW02AYk@0oooo01d0oooo00<0TJNd0>3Oh`3Pgn<0;`3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn096K
W0020?cloP050000003lo?h0o?cn0?cloP0000001@3lo?h00`000000o?cn
000000030?cloP030000003lo?h0000000P0o?cn00D000000?cloP3lo?h0
TI^L096W]0060?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3o
ool0oooo000000040?ooo`<000001P3oool00`2AYk@0h=oS0>3Oh`0_0>3O
h`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0TI^L
00H0o?cn00<000000?cloP3lo?h00`3lo?h00`000000o?cn000000030?cl
oP030000003lo?h0000000@000001`3lo?h00`2AVi`0TJNd0?[ioP050?[i
oP030000003jnOh0n_Wn00<0n_Wn00D000000?[ioP3jnOh0n_Wn00000003
0?[ioP050000003jnOh0n_Wn0?[ioP0000001@3jnOh00`2AYk@0h=oS0>3O
h`0_0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1V
IWh0TI^L0080o?cn00D000000?cloP3lo?h0o?cn000000050?cloP040000
003lo?h0000000000080o?cn00<000000?cloP0000000`3lo?h00`000000
o?cn0?cloP020?cloP050000003lo?h0o?cn096KW02AYk@01P3em?d00`00
0000mOCm0?Gdo@020?Gdo@070000003em?d000000?Gdo@000000mOCm0000
00020?Gdo@050000003em?d0mOCm0?Gdo@0000000`3em?d00`3fm?d0mOCm
096W]00a0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0TI^L00H0o?cn00<000000?cloP3lo?h00`3lo?h010000000o?cn
0000003lo?h2000000<0o?cn0`0000080?cloP03096KW02AYk@0lO7m00D0
lO7m00<000000?7ao@3alOd00P3alOd01`000000lO7m0000003alOd00000
0?7ao@0000000P3alOd01@000000lO7m0?7ao@3alOd0000000D0lO7m00<0
TJNd0>3Oh`3Pgn<0;`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn096KW0020?cloP030000003lo?h0o?cn0080o?cn00D0
00000?cloP3lo?h0o?cn0000000A0?cloP050000003lo?h0o?cn096KW02A
Yk@01P3Zj_T01@000000j^[i0>[Zn@3Zj_T000000080j^[i00<000000>[Z
n@0000000P3Zj_T00`000000j^[i000000030>[Zn@030000003Zj_T0j^[i
00<0j^[i00<0TJNd0>3Oh`3Pgn<0;`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn096KW0080?cloP<000005@3lo?h00`2A
Vi`0TJNd0>[Zn0050>[Zn0050000003Zj_P0j^[h0>[Zn00000000`3Zj_P0
1@000000j^[h0>[Zn03Zj_P000000080j^[h0`0000060>[Zn003096W]03P
gn<0h=oS02l0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP2AVi`00P3lo?h00`000000o?cn0?cloP0H0?cloP050000003l
o?h0o?cn096KW02AYk@01P3Ui_@00`000000iNKd0>GVm00E0>GVm003096W
]03Pgn<0h=oS02l0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP2AVi`0803lo?h00`2AVi`0TJNd0=oOl@030=oOl@D00000
5@3Ogo400`2AYk@0h=oS0>3Oh`0_0>3Oh`0306IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0TI^L0080o?cn00<000000?cloP3lo?h0
603lo?h01P000000o?cn0?cloP2AVi`0TJNd0=_Lk@X0fmg]103Kg>d?0=_M
k@03096W]03Pgn<0h=oS02l0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP2AVi`0803lo?h00`2AVi`0TJNd0=GGj@0M0=GG
j@03096W]03Pgn<0h=oS02l0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP2AVi`00P3lo?h00`000000o?cn0?cloP0H0?cl
oP050000003lo?h0o?cn096KW02AYk@07P3<cN800`2AYk@0h=oS0>3Oh`0_
0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0
TI^L0200o?cn00<0TI^L096W]036b=d07@36b=d00`2AYk@0h=oS0>3Oh`0_
0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0
TI^L0080o?cn01X000000?cloP000000o?cn0000003lo?h000000?cloP00
0000o?cn0000003lo?h000000?cloP000000o?cn0000003lo?h000000?cl
oP000000o?cn0000003lo?h000000?cloP8000000P3lo?h00`2AVi`0TJNd
0;jnf00I0;jnf080_[oH0P2n_]P00`2AYk@0h=oS0>3Oh`0_0>3Oh`0306IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT0240h=oS
D@1aKf@00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
0P2MWJ4P0>3Ohe00WIfQ00@0LFmT06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP3oool0L03Pgn<01@2MWJ40LFmT06IVOP2XZK/0nocm
0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0oooo0>3Ohfh0YJbb00H0h=oS
09fMX@1aKf@0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
0?ooo`3Pgn<0YJbb06`0oooo00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0
nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`2U[;80K03o
ool01`2U[;80h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP3oool0h=oS0:F//P1/0?ooo`070:F//P3Pgn<0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?oo
o`3Pgn<0YJbb06`0oooo00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm
0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`2U[;80K03oool0
1`2U[;80h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP3oool0h=oS0:F//P060?ooo`<000000`3oool300000080
oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`030000
0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`140?oo
o`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn
0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb00D0oooo00L000000?ooo`3oool0
oooo0000003oool0000000<0oooo00<000000?ooo`0000000P3oool01P00
0000oooo0?ooo`000000oooo000000<0oooo00<000000?ooo`0000001@3o
ool00`000000oooo0?ooo`140?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb
00P0oooo00@000000?ooo`3oool000000`3oool00`000000oooo00000002
0?ooo`060000003oool0oooo0000003oool000001P3oool5000004L0oooo
00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0oooo0>3Oh`2U[;801P3oool2000000<0oooo00L00000
0?ooo`3oool0oooo0000003oool000000080oooo00D000000?ooo`3oool0
00000?ooo`0500000080oooo00D000000?ooo`3oool0oooo000000170?oo
o`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn
0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb00D0oooo00L000000?ooo`3oool0
oooo0000003oool0000000<0oooo00D000000?ooo`00000000000?ooo`02
000000040?ooo`000000oooo000000<0oooo00L000000?ooo`3oool0oooo
0000003oool0000004P0oooo00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0
nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`2U[;801P3o
ool3000000<0oooo0`0000020?ooo`030000003oool000000080oooo00@0
00000?ooo`3oool0oooo0`0000040?ooo`030000003oool0000004P0oooo
00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0oooo0>3Oh`2U[;808@3oool00`000000oooo00000018
0?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0
IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb0280oooo00<000000?ooo`3o
ool0A`3oool01`2U[;80h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0:F//P1/0?ooo`070:F//P3P
gn<0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0
IVIn0?ooo`3Pgn<0YJbb06`0oooo00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2X
ZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`2U[;80
K03oool01`2U[;80h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh00007
06IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0:F//P1/0?ooo`070:F//P3Pgn<0
WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
0?ooo`3Pgn<0YJbb06`0oooo00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0
nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0oooo0>3Ohfh0YJbb00H0
h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn0?ooo`1`0>3Oh`0509fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP3oool0L03Pgn<01@2MWJ40LFmT06IVOP2XZK/0
nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0oooo0700h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000/0IVIn0?_lo@2XZK/0IVIn0?oo
o`3Pgn<0hN3T0>KUj03/jnh0l?3b0?;bm00b0??cm300n?Oh0P3clo@02`3c
loD0m?Ce0?GemP3dloD0iNCX0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040
IVIn00002P1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`3Ng=l0i>;P07^G[@0U
EhEV000lM00:01M=OP1[RjH0l_7^0?;al`3Pgn<0WIfQ075_I01VIWh0Z:Vk
0?_lo@40IVIn00002P1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`3Jf=T0IXFQ
04YaT`2b_L=V0<K5e`0:0<36a@18KY00JXZT0>o_l@3Pgn<0WIfQ075_I01V
IWh0Z:Vk0?_lo@40IVIn00002@1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`3H
eMH05den0;o7bP1X0<K5e`090;Jm_@0GCGh0jn[]0>3Oh`2MWJ40LFmT06IV
OP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`3I
eMD003ad0?ooo`1X0<g<g`090?ooo`00?7@0j>OZ0>3Oh`2MWJ40LFmT06IV
OP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`3I
eMD003ad0?ooo`1X0=;Ai0090?ooo`00?7@0inKY0>3Oh`2MWJ40LFmT06IV
OP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`3I
eMD003ad0?ooo`1X0=KGi`090?ooo`00?7@0inKY0>3Oh`2MWJ40LFmT06IV
OP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`3I
eMD003ad0?ooo`0O0=WJi`D000000`3If^L2000000030=WJi`000000fM[W
0080000000<0fM[W0000000000000P3If^L300000080fM[W00D000000=WJ
i`3If^L0fM[W000000040=WJi`030000003If^L0fM[W00<0fM[W00<00000
0=WJi`3If^L07P3If^L02@3oool003ad0>OVj@3Pgn<0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0fMGE
000lM03oool07`3If^L00`000000fM[W0=WJi`020=WJi`030000003If^L0
00000080fM[W0P0000001@3If^L000000=WJi`3If^L000000080fM[W00L0
00000=WJi`3If^L0fM[W0000003If^L0000000<0fM[W00<000000=WJi`3I
f^L00P3If^L00`000000fM[W0=WJi`030=WJi`030000003If^L0fM[W01h0
fM[W00T0oooo000lM03Wi^T0h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d00@1V
IWh0000906IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0=WEe@00?7@0oooo01l0
g]o/00<000000=kOk03Ngn`00P3Ngn`00`000000g]o/000000030=kOk003
0000003Ngn`000000080g]o/00@000000=kOk03Ngn`000000`3Ngn`00`00
0000g]o/000000030=kOk0030000003Ngn`0g]o/00<0g]o/1@00000Q0=kO
k0090?ooo`00?7@0inKY0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn
00002@1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`3IeMD003ad0?ooo`0O0>?U
l0030000003SiO00hnG`0080hnG`00<000000>?Ul00000000`3SiO000`00
0000hnG`000000020>?Ul0040000003SiO00hnG`000000<0hnG`00<00000
0>?Ul00000000`3SiO000`000000hnG`0>?Ul0030>?Ul0050000003SiO00
hnG`0>?Ul00000008@3SiO002@3oool003ad0>OVj@3Pgn<0WIfQ075_I01V
IWh0Z:Vk0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0
fMGE000lM03oool07`3YjoD500000080jN_e00L000000>W[m@3YjoD0jN_e
0000003YjoD000000080jN_e00@000000>W[m@3YjoD000000`3YjoD01000
0000jN_e0000000000020>W[m@030000003YjoD0jN_e00@0jN_e00<00000
0>W[m@0000008P3YjoD02@3oool003ad0>OVj@3Pgn<0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0fMGE
000lM03oool07`3`lO`00`000000l?7l0?3ao0020?3ao0030000003`lO`0
000000<0l?7l1`0000020?3ao0<000000P3`lO`010000000l?7l00000000
00070?3ao0030000003`lO`000000280l?7l00T0oooo000lM03Wi^T0h=oS
09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000906IVOP3ko?d0Z:Vk06IV
OP3oool0h=oS0=WEe@00?7@0oooo01l0m?Gm00<000000?Ceo@3dmOd00P3d
mOd00`000000m?Gm0?Ceo@050?Ceo@040000003dmOd0m?Gm000001<0m?Gm
00<000000?Ceo@0000008P3dmOd02@3oool003ad0>OVj@3Pgn<0WIfQ075_
I01VIWh0Z:Vk0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?ooo`3P
gn<0fMGE000lM03oool07`3fmod5000000P0m_Om00@000000?Kgo@3fmod0
0000503fmod00`000000m_Om0?Kgo@0Q0?Kgo@090?ooo`00?7@0inKY0>3O
h`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1V
IWh0oooo0>3Oh`3IeMD003ad0?ooo`1X0?Slo@090?ooo`00?7@0inKY0>3O
h`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1V
IWh0oooo0>3Oh`3IeMD003ad0?ooo`1X0?gmo@090?ooo`00?7@0inKY0>3O
h`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1V
IWh0oooo0>3Oh`3IeMD003ad0?ooo`1X0?gmo@090?ooo`00?7@0i^KY0>3O
h`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1V
IWh0oooo0>3Oh`3He=@003ad0?ooo`1X0?gmo@090?ooo`00?7@0iNGX0>3O
h`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1V
IWh0oooo0>3Oh`3IeMD09EN50;o>g01X0?ooo`090;o>f`0UEhD0hN7T0>3O
h`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00002P1VIWh0nocm0:RY^`1V
IWh0oooo0>3Oh`3IeMD0NIBY05EmXP30cmeV0?ooo`0:0=GOj01EOJ80NIF[
0=oMh03Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@40IVIn00002P1VIWh0nocm
0:RY^`1VIWh0oooo0>3Oh`3JemT0gmcH07VDZ@0UEhEV000lM00:01M=OP1V
QZ40h=kJ0=cKg@3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@40IVIn00002@1V
IWh0nocm0:RY^`1VIWh0oooo0>3Oh`3OgN00f]OI0=SDe00d0=OCe300dlk<
0`3Gdm@02P3He=@0fMGE0=[Gf@3OgN00h=oS09fMX@1aKf@0IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`1`0>3Oh`0509fMX@1a
Kf@0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW80oooo
00@0LFmT06IVOP2XZK/0nocm0@1VIWh0000306IVOP3gmoT0V9RW07D0MgNB
0@2HV:L10?Ogn@40IVIn00000`1VIWh0moOi0;bmc@1f0;bmc@40moOi0@1V
IWh0000306IVOP3gmoT0i>?S07H0i>?S0@3gmoT106IVOP0000<0IVIn0?3a
m03oool0;`3oool00`3Thn<0W:Bi06]eS`0306]eS`0406afT01[MHl0K7J@
06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>CSh`2LY;T406]eS`0406af
T01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>cZjP2LY;T4
0:HiA0040:LjA02V>D@0YcY40:LjA0T0YSU400<0W:Bi0>cZjP3oool00`3o
ool10?3am040IVIn00005P1VIWh0h^7R0?_lo03kno`0nocm0?cko@3knod0
nocm0?_lo03lo?d0o?cl0?cko@3lo?`0o?_l0?clo03ko?`0o?cl0?_lo@3l
no`0o?cm0?_ko@3ko?`20?clo0040?clo@3lo?`0no_m0?cloA@0o?_l0P3k
o?`00`2LY;T0JgF?08F9/00@08F9/00606]eS`2LY;T0nocm0?_lo@2LY;T0
JgF?4@25RK001P1[MHl0W:Bi0?_lo03kno`0W:Bi0:HiA140ZSaE00L0YSU4
09bT^@3ko?`0o?cl0?cko@3ko?d0h^7R0040IVIn0000101VIWh0h>3Q0?Kg
n@3gmoT20?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0
m_Oi0?Ogn@3fmoT00P3gmoT0103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kg
n03gmoT0moOi01<0moOi0P3fmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9
/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0
YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Og
n@3gmoP0moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`
l_@@000000060?7am03`l_D0lO7d0?7bm03`l_@0lO7d5P3`lOD00`1[MHl0
/[G@0:NX`P0@0:NX`P060;:ed01[MHl0l?7d0?3am01[MHl0/[G@4@2WZ<80
1@2b]M00JgF?0?3am@3al_@0YSU40080`U9K00<0beAI0<eIGP3=FEh02`3=
FEh0103;E5T0`U9K0<9BF`2V>D@20?3am0030?7am03`l_@0g]gQ0040IVIn
00001`1VIWh0g=_P0>[[l03Zjo00j^c`0>W[k`0000000P3WinL20=kNgP80
inOW00<0ikf40>OWi`3WinL00`3WinL20>o_k`040000003Zjo00j^_`0>[[
k`80j^_`00<0j^__0>[[l03Zjo004P3Zjo020>[/l00406]eS`2f^M40[Jk6
0:f^aPP0oooo00<0[Jk60:b^aP2][/H00`2][/H00`2/[/H0][WA06]eS`02
0>[[k`0406]eS`2f^M40[Jk60:f^aP`0oooo0P2][/H00`2/[/H0][WA06]e
S`020>[[l0050:HiA03=FEh0beAI0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK
0<]DF@3=FEh0YSU40>[[k`3Zjo000P3Zjnl10=cKh040IVIn0000101VIWh0
fMWO0>?UjP3Si>X20>?Uj`050000002<S8`0g]kN0>OWi`3Ng]h00P3WinL0
0`36H`00inOW0>OWi`020>OWi`070>o_i`3_knl0kno_0000003Si>X0hnC[
0>?UjP020>?TjP030>?Tj`3SiN/0hnG[0180hnG[0P3Si>X01@1[MHl0_;kD
0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0
JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH02@0U9CH3
0;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?oo
o`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ
0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0g=kV00D00000
0>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW0>ONaP3_S100
0`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H05P3Lg^D01@1[
MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh0
1P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh0
1`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V
>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`0505<U803DGF40
dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn
0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0ikF40=IJ003F
Q000olh00<iS00020=i[00050>neS03_knl0kno_0>o_k`0000000P3Ef>40
103Een00e]SP0=KHh@3Fen4D0=KGh080e]SP00D0JgF?0<?5f@2l_M40_;gA
0?ooo`0702DU=PL0_;gA00H0`lGI06]eS`3Ef>40eMSQ06]eS`33aMT20;bm
d@030?ooo`0U9CH0_;gA00L0_;gA00<0oooo02DU=P2l_M400P2l_M401@33
aMT0JgF?0=KGh03Een40YSU40080eEeP00<0f61Q0=UQHP167QX00`3oool3
0=UQHP<0oooo00<0AQhJ0=UQHP3HH6400P3EGF001P2V>D@0e]SP0=GHh@3E
en00eMSQ0=GFg@40IVIn00001`1VIWh0d]CM0<oBg03@d]`0d=;M0=3Bg000
00000`3WinL0303Wg/h0aTX00?O>003_[@00kkD00<i[0036FP00aV/00=j<
BP3WY@00knO>000000<0d=;L00<0cm;L0=3Bg03?d]`0503@d]`20<oBg@03
06]eS`38bM/0`lCF0100`lCF00H0b<WK06]eS`3@d]`0d=;L06]eS`38bM/2
0<?4eP030?ooo`0U9CH0`lCF00L0`lCF00<0oooo02DU=P33a=H00P33a=H0
1`38bM/0JgF?0<oBg03?d]`0YSU40=MOG`3IHF800`3LIFD01@167QX0oooo
0?ooo`3oool0g6EU00<0oooo00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0
YSU40=3Bg@80d=;L0@3?d]`10=;Dg@40IVIn0000701VIWh0d=;K0<_=f03:
cMT0blkH0<[=f0000000ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU
003FS000cV/00>O6003oeP00knoW0>o_k`000000blgH0<_=f@3:cMT0blkH
0<[=f03;cMPD0<_=f@80blkI00<0JgF?0<_<gP38b]T02038b]T00`38bMT0
b<[I0<S:f@030<S:f@040<S9f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<
gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0
b<[I0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3P
IVD00P3NIfL00`167QX0oooo0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1V
I@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI0@3@d]/106IVOP0000<0
IVIn0<o?fP35b=@00`35b=@01P000000a/K60>ONeP3>N`00ijd00>ne0080
ijD000<0eY@00<ic003FU0000P3gaP020?Ogm`0400000035b=@0aLOD0<G7
e0<0aLOE5034amD20<C8e00306]eS`3@dN00bl_L0100bl_L00H0d=7P06]e
S`34am@0a<OD06]eS`3@dN020<_;g0030?ooo`0U9CH0bl_L00L0bl_L00<0
oooo02DU=P3;bm`00P3;bm`01`3@dN00JgF?0<G7e034am@0YSU40=]TI03O
IF@01@3PJVP01@167QX0oooo0?ooo`3oool0AQhJ00D0h6YX00@0gfET0=]T
I02V>D@0a<SE0P34b=@10<G7e@40cloJ0@1VIWh0000406IVOP3<c]X0`/CB
0<74d@80`LCB00H000000>OWi`3WinL0inOW0=J4003_]@020>NU00080=J4
003>J`00ijd00?Ne003g_@00kno_0?Ogm`0000030<74dP030<;4d@31a=80
`LCB01@0`LCA0P31a=800`1[MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0
`/CB0<;4dP1[MHl0dm?R0P3?d=d00`3oool09BDf0<o@g@070<o@g@030?oo
o`0U9CH0cm3M0080cm3M00L0dm?R06]eS`32a=80`LCA0:HiA03KI6@0hFUU
00D0h6aY1@3oool50>1/J@080>5YI@3KI6@0YSU40<74dP32a=40`LCA0<74
dP3<c]X106IVOP0000@0IVIn0<[<f02n`<l0_L3?0P2n`<h01@000000W9bL
0>OWi`3Wg]H0eX`00080gY@000@0eW/00<IS002m@P00kjD00P3g[@00203g
]@00oli:0000002n`<h0_/3?0;k0cP2n`<l0_L3>5@2n`<h20;g0cP0306]e
S`3Fe^@0dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?C
h0030?ooo`0U9CH0oooo00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[
MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3o
ool0oooo103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P1
06IVOP0000L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0
eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3o
ool000000;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;01@0^Kc<0P2j_<`00`1[
MHl0f=SU0=?Ch@0@0=?Ch@060=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU0P3C
dn400`3oool0KVf?06i]S`0806i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0
JgF?0;Zlb`2j_<`0YSU40>1YJ03QKF`0i75]0>AaK`3TL6h30?ooo`0304HN
6P3TL6h0AQhJ00<0oooo0P3TL6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<0;Zk
c02i_</0][S80<W:f00106IVOP0000T0IVIn0<O9e`2d]/L0][S80;Jhb@2f
^LT0000008B4Q03Wimh00P3_knl01`36J`00mlH00>ne003_W000gX`00<i[
003WW0000`3gmoL01@000000][W90;Nhb@2f^LT0]kW90080][S9502g^<T2
0;Jhb@0406]eS`3Fe^@0f=SU0=SHiP<0f=SU1@3Hf>H30=SHi@80f=SV0P3H
f>D02@3Fe^@0JgF?0;Nhb@2g^<T0JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]
S`0=02DU=P3Hf>H0f=SU0=SHi@3Fe^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3T
M6l0ig5_0>AdK`030?ooo`0504HN6P3TM6l0i7A_0>AdK`167QX00`3oool0
2P3TM6l0ig5_0>AdK`3TKVd0YSU40;Jib@2f^<T0][W90;Bfa`37bML106IV
OP0000<0IVIn0<K8e`2d]/L00`2d]/L00`000000kno_0>o_k`020>o_k`0;
0>N]003gaPP0ijD00>ND003WS000knOF0=jD>@3_e[D0ooOg0?ooo`000000
702d]/L01@1[MHl0eMGS0=cKi`3LfnL0gM_W00h0g=_W00H0eMGS06]eS`2d
]/L0];K706]eS`3EeN<20=cKi`030=gKi`0U9CH09BDf00T09BDf0`3LfnL0
2@3EeN<0JgF?0;Bfa`2d]/L0YSU40>McK`3WMG80jWIc0>YhMP020?ooo`03
04HN6P3YOWP0jGih00<0jGih00P0AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80
ig=_0:HiA0@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L0
1P000000S8b<0>o_k`3_knl0ilik0>o_k`80moOg00P0ii@00?OWcP3gmoL0
moOg0>oWeP3gmoL0oooo000001`0];K700<0JgF?0=GDh`3PgnX0403PgnX0
1P3Ee><0JgF?0;Bfa`2d]/L0JgF?0=GDha40h=oZ00T0eMCS06]eS`2d]/L0
];K70:HiA03ZNG<0jGah0>n1NP3bRH400P167QX01`3[V8/0jY^<0>fGRP3[
V8/0jY^<0>fGRP3[V8/00P167QX01@3bRH40kh5j0>UlN03ZNG<0YSU400@0
];K70@36b=L106IVOP0000<0IVIn0<K8e`2a/lP00`2a/lP01P000000kno_
0>o_k`3_knl0moO_0>o_k`80moOg00<0mnO60?Ogm`3oool00`3gmoL00`3o
ool000000;6cb00K0;6cb00306]eS`3]jo<0jNSa0100jNSa00H0kN_c06]e
S`2a/lP0/K?806]eS`3]jo<A0>WXl@0I0>g[l`1[MHl0/K?80;6cb02V>D@0
lH1e0?24O03eS8@0mif>0?:[UP3a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a
/Y/0kKBK0>beW03bZiH0mif>0?F<Q03`Q7`0lH1e0:HiA0040;6cb040a/SG
0@1VIWh0000306IVOP36b=L0^;O?00<0[jk700D000000:f][@3gmnl0moOg
0>o_k`060?Ogm`80ooOg0P3oool00`000000[jk70:n^a`0J0:n^a`0306]e
S`3BdN<0l_7g0100l_7g00H0d]7S06]eS`2_[/L0[jk706]eS`3BdN<A0?;a
m`060=;Ah`1[MHl0[jk70:n^a`2V>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0
m8Ym0:HiA02_[/L00P2_[/L10;Rgc`40a/SG0@1VIWh0000306IVOP30`M40
alOD02l0[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]e
S`24S:820:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[
MHl0Q8bR0P2/Zl@01`2AV:X0YSU40?nOS@3n_j@0n]bg0?[[]`3jjKH00P3i
jKH0103jjKH0nNVf0?WY]P3jjKH20?WY]P060?[[]`3jg;L0o[nT0?nOS@2V
>D@0TIRZ0`2/Zl@10<O7e040`<7A0@1VIWh0000406IVOP30`M40d];O0;Fd
bBl0Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS
_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24
S:80YSU40:HiA00?0:HiA00708B<XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31
d@0106IVOP0000H0IVIn0:RW_`3Vi^d0d];P0;blc`2a/<A_0:RW_`050;6`
a02l_<l0d];P0>KVk@2XYkl00@1VIWh0000705QGJ027Qi/0emSR0?clo03T
hnP0d=3P0<[:fP1]0;blc`060<[:fP3@d>00i>?X0?clo03Gf>80QhNK0@1H
EfP0000805QGJ01VIWh0UIB[0=OHhP3lo?`0l_7c0>c[kP3Qh^][0=OHhP07
0>7Rj`3/jnh0l_7c0?clo03Gf>80UIB[06IVOP0105QGJ0000P1HEfP00`1V
IWh0UIB[0=7AgP020?clo6d0oooo0P3lo?`00`3AdMh0UIB[06IVOP0205QG
J0000`1HEfP206IVOP0308R7W@2EU:/0Z:No06`0Z:No00@0UIB[08R7W@1V
IWh0IVIn0`1HEfP000D0F5MXL@1VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[21]:=",
  Evaluatable->False,
  ImageSize->{123, 106},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[21]=",
  CellTags->"WidgetGroup-Layout"]
}, Open  ]],

Cell[TextData[{
  "Each element of the tabbed ",
  StyleBox["WidgetGroup", "MR"],
  " can be a list of widgets that populate one tab panel or a single widget \
whose contents will be placed within one pane."
}], "Text",
  CellTags->"WidgetGroup-Layout"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ 
      GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
\[IndentingNewLine]WidgetGroup[{\[IndentingNewLine]Widget["\<Wolfram/Example/\
PrimeFinder\>"], \
\[IndentingNewLine]Widget["\<Wolfram/Example/CellularGroup\>"]\
\[IndentingNewLine]}, \ 
            Name -> "\<myTabPane\>", \[IndentingNewLine]WidgetLayout \[Rule] \
{"\<Grouping\>" \[Rule] {Tabs, \ 
                    Top, {"\<One\>", "\<Two\>"}}}]\[IndentingNewLine]]\
\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject231053704822785, 
        JLink`Objects`JavaObject261268346765313]]], "Output",
  CellLabel->"Out[22]=",
  CellTags->"WidgetGroup-Layout"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004=0000l2000`400?l0
0000o`00003oo`1VIWh>06IVOP0000<0IVIn0?_lo@3ko?d0o`3ko?d:0?_l
o@40IVIn00000`1VIWh0nocm0:RY^`3o0:RY^`T0Z:Vk0@3ko?d106IVOP00
00<0IVIn0?_lo@2XZK/0o`1VIWh806IVOP40Z:Vk0@3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVIno`1aKf@6075_I00306IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0oooo0?l0WIfQ102MWJ40101aKf@0IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`160>3Oh`030000003Pgn<0h=oS0;T0h=oS00D0WIfQ075_I01VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`160>3Oh`030000
003Pgn<0h=oS0;T0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0000000@0h=oS00<000000>3O
h`3Pgn<00P000000103Pgn<000000>3Oh`0000020>3Oh`070000003Pgn<0
h=oS0000003Pgn<000000>3Oh`02000000<0h=oS0`0000020>3Oh`030000
003Pgn<0h=oS00@0h=oS00<000000>3Oh`3Pgn<00`0000050>3Oh`050000
003Pgn<0h=oS0>3Oh`0000000P3Pgn<300000080h=oS0P0000040>3Oh`04
0000003Pgn<0000000000080h=oS00L000000>3Oh`3Pgn<0h=oS0000003P
gn<000000080h=oS00@000000>3Oh`3Pgn<000000P3Pgn<3000000<0h=oS
00<000000>3Oh`3Pgn<0WP3Pgn<01@2MWJ40LFmT06IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`0000000`3Pgn<20000
00040>3Oh`000000h=oS0>3Oh`80000000D0h=oS0000003Pgn<0h=oS0000
00020>3Oh`040000003Pgn<0000000000080h=oS00<000000>3Oh`000000
0`3Pgn<00`000000h=oS000000060>3Oh`030000003Pgn<0000000<0h=oS
00<000000>3Oh`3Pgn<00P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3O
h`0000000`3Pgn<00`000000h=oS000000050>3Oh`8000000P3Pgn<00`00
0000h=oS000000030>3Oh`030000003Pgn<000000080h=oS00H000000>3O
h`3Pgn<000000>3Oh`0000030>3Oh`030000003Pgn<0h=oS0:40h=oS00D0
WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
0?ooo`3Pgn<000000080h=oS00D000000>3Oh`000000h=oS000000030>3O
h`030000003Pgn<000000080h=oS00H000000>3Oh`3Pgn<000000>3Oh`00
00030>3Oh`030000003Pgn<0000000D0h=oS00<000000>3Oh`3Pgn<0103P
gn<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS00<0h=oS00L0
00000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`00
00001@3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<0
0`000000h=oS000000020>3Oh`060000003Pgn<0h=oS0000003Pgn<00000
Y`3Pgn<01@2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm
0:RY^`1VIWh0oooo0>3Oh`0000000P3Pgn<01@000000h=oS0000003Pgn<0
000000<0h=oS00<000000>3Oh`0000000P3Pgn<01P000000h=oS0>3Oh`00
0000h=oS000000<0h=oS00<000000>3Oh`000000100000000`3Pgn<00000
0>3Oh`050>3Oh`030000003Pgn<0h=oS008000001P3Pgn<01`000000h=oS
0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000050>3O
h`070000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003P
gn<000000080h=oS00D000000>3Oh`3Pgn<000000>3Oh`0500000:<0h=oS
00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0
IVIn0?ooo`3Pgn<000000>3Oh`0000000P3Pgn<00`000000h=oS00000003
0>3Oh`050000003Pgn<000000000003Pgn<00P0000000`3Pgn<000000>3O
h`0200000080h=oS00<000000>3Oh`0000000`3Pgn<010000000h=oS0000
000000050>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0
0P3Pgn<200000080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS
000000050>3Oh`8000000P3Pgn<010000000h=oS0000000000020>3Oh`05
0000003Pgn<000000000003Pgn<00P000000103Pgn<000000>3Oh`000003
0>3Oh`030000003Pgn<0h=oS0:40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_l
o@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<000000>3Oh`00
00000P3Pgn<00`000000h=oS000000030>3Oh`050000003Pgn<000000>3O
h`0000000P3Pgn<01@000000h=oS0>3Oh`000000h=oS008000000`3Pgn<3
00000080h=oS00<000000>3Oh`000000103Pgn<00`000000h=oS0>3Oh`03
000000D0h=oS00@000000>3Oh`00000000000`3Pgn<3000000040>3Oh`00
00000000000000@0h=oS00@000000>3Oh`00000000000P3Pgn<02@000000
h=oS0000003Pgn<000000>3Oh`000000h=oS000000020>3Oh`040000003P
gn<0h=oS0>3Oh`<00000Y03Pgn<01@2MWJ40LFmT06IVOP2XZK/0nocm0040
IVIn00001P1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`8000000`3Pgn<00`00
0000h=oS0>3Oh`0=0>3Oh`030000003Pgn<0h=oS02L0h=oS00<000000>3O
h`3Pgn<0_`3Pgn<01@2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1V
IWh0nocm0:RY^`1VIWh0oooo0>3Oh`000000103Pgn<00`000000h=oS0>3O
h`0=0>3Oh`030000003Pgn<0h=oS0100h=oS00<000000>3Oh`3Pgn<0503P
gn<00`000000h=oS0>3Oh`0=0>3Oh`030000003Pgn<0h=oS0:l0h=oS00D0
WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3O
h`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0
WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01V
IWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn?o
0:F//P40YJbb00H0h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d106IVOP0000L0
IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb0?h0oooo00L0YJbb0>3Oh`2M
WJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0
oooo0>3Oh`2U[;80oP3oool01`2U[;80h=oS09fMX@1aKf@0IVIn0:RY^`3k
o?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0:F//P3n0?oo
o`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn
0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb0?h0oooo00L0YJbb0>3Oh`2MWJ40
LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0oooo
0>3Oh`2U[;80oP3oool01`2U[;80h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d0
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0:F//P3e0?ooo`03
0000003oool0oooo00H0oooo00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0
nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`2U[;80m@3o
ool00`000000oooo0?ooo`060?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb
0?D0oooo00<000000?ooo`3oool01P3oool01`2U[;80h=oS09fMX@1aKf@0
IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3oool0h=oS
0:F//P3e0?ooo`030000003oool0oooo00H0oooo00L0YJbb0>3Oh`2MWJ40
LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0oooo
0>3Oh`2U[;80m@3oool00`000000oooo0?ooo`060?ooo`070:F//P3Pgn<0
WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
0?ooo`3Pgn<0YJbb0?<0oooo00<000000?ooo`000000203oool01`2U[;80
h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP3oool0h=oS0:F//P3d0?ooo`800000203oool01`2U[;80h=oS09fM
X@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3o
ool0h=oS0:F//P3e0?ooo`030000003oool0oooo00H0oooo00L0YJbb0>3O
h`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0oooo0>3Oh`2U[;80oP3oool01`2U[;80h=oS09fMX@1aKf@0IVIn0:RY
^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0:F//P3n
0?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0
IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb0?h0oooo00L0YJbb0>3Oh`2M
WJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0
oooo0>3Oh`2U[;80oP3oool01`2U[;80h=oS09fMX@1aKf@0IVIn0:RY^`3k
o?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0:F//P3n0?oo
o`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn
0?_lo@2XZK/0IVIn0?ooo`3Pgn?o0:F//P40YJbb00H0h=oS09fMX@1aKf@0
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3O
h`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0
WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
0?ooo`0k0>3Oh`050>7Pi03ViNP0k>_^0?3`lP3bl_@08@3clo@N0?Sgn080
lo?d00D0lo?e0?Cdm@3emOH0m??e0>GTj0060>3Oh`050>7Pi03ViNP0k>_^
0?3`lP3bl_@05`3clo@D0?Sgn080lo?d00D0lo?e0?Cdm@3emOH0m??e0>GT
j00o0>3Oh`0509fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP3oool0>`3Pgn<0103Ng=l0i>;P07^G[@0UEhE3000lM004
01M=OP1[RjH0l_7^0?;al`H0h=oS00@0g]cO0>CRh01kUjd09EN5;`00?7@0
100GCGh0Jh^V0?;akP3blO<o0>3Oh`0509fMX@1aKf@0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP3oool0>`3Pgn<0103Jf=T0IXFQ
04YaT`2b_L=30<K5e`040<36a@18KY00JXZT0>o_l@H0h=oS00@0f]SI06J5
X@1:LI<0/[g3;`36aML01030a/D0B6j@06Z:Y03_ko4o0>3Oh`0509fMX@1a
Kf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP3oool0
>`3Pgn<00`3HeMH05den0;o7bP150<K5e`030;Jm_@0GCGh0jn[]00H0h=oS
00<0f=GF01M=OP2oalX0<@36aML00`2f_Kd05den0>_Zk@0o0>3Oh`0509fM
X@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP3o
ool0>`3Pgn<00`3IeMD003ad0?ooo`150<g<g`030?ooo`00?7@0j>OZ00H0
h=oS00<0fMGE000lM03oool0<@3=c=l00`3oool003ad0>SWjP0o0>3Oh`05
09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP3oool0>`3Pgn<00`3IeMD003ad0?ooo`150=;Ai0030?ooo`00?7@0inKY
00H0h=oS00<0fMGE000lM03oool0<@3BdN@00`3oool003ad0>OVj@0o0>3O
h`0509fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP3oool0>`3Pgn<00`3IeMD003ad0?ooo`150=KGi`030?ooo`00?7@0
inKY00H0h=oS00<0fMGE000lM03oool0<@3FenL00`3oool003ad0>OVj@0o
0>3Oh`0509fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP3oool0>`3Pgn<00`3IeMD003ad0?ooo`0=0=WJi`030000003I
f^L0fM[W00<0fM[W00<000000=WJi`3If^L00P3If^L3000000@0fM[W00D0
00000=WJi`3If^L0fM[W000000020=WJi`<000000`3If^L2000000040=WJ
i`000000fM[W0=WJi`<00000403If^L00`3oool003ad0>OVj@060>3Oh`03
0=WEe@00?7@0oooo00d0fM[W00<000000=WJi`3If^L00P3If^L00`000000
fM[W0=WJi`0300000080fM[W00H000000=WJi`3If^L0fM[W0000003If^L2
000000l0fM[W00<0oooo000lM03Wi^T0?`3Pgn<01@2MWJ40LFmT06IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0oooo03/0h=oS00<0
fMGE000lM03oool03@3If^L00`000000fM[W0=WJi`030=WJi`050000003I
f^L0fM[W0=WJi`0000000`3If^L01@000000fM[W0=WJi`3If^L0000000<0
fM[W00<000000=WJi`0000000`3If^L00`000000fM[W000000020=WJi`80
000000<0fM[W0000003If^L00P3If^L00`000000fM[W0=WJi`0=0=WJi`03
0?ooo`00?7@0inKY00H0h=oS00<0fMGE000lM03oool03@3If^L010000000
fM[W0=WJi`3If^L2000000030=WJi`000000fM[W0080fM[W00H000000=WJ
i`3If^L000000=WJi`0000020=WJi`030000003If^L0fM[W00h0fM[W00<0
oooo000lM03Wi^T0?`3Pgn<01@2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0oooo03/0h=oS00<0fMGE000lM03oool0
3@3Ngn`00`000000g]o/0=kOk0030=kOk0050000003Ngn`0g]o/0=kOk000
00001P3Ngn`00`000000g]o/000000020=kOk0030000003Ngn`0000000<0
g]o/00<000000=kOk00000000`3Ngn`00`000000g]o/0=kOk0020=kOk003
0000003Ngn`0g]o/00h0g]o/00<0oooo000lM03Wi^T01P3Pgn<00`3IeMD0
03ad0?ooo`0=0=kOk0080000003Ngn`0g]o/0000003Ngn`000000=kOk000
00070=kOk0050000003Ngn`0g]o/0=kOk0000000403Ngn`00`3oool003ad
0>OVj@0o0>3Oh`0509fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP3oool0>`3Pgn<00`3IeMD003ad0?ooo`0=0>?Ul0@0
00000P3SiO0010000000hnG`0>?Ul03SiO0500000080hnG`00<000000>?U
l00000000P3SiO000`000000hnG`000000030>?Ul0030000003SiO000000
00<0hnG`00<000000>?Ul03SiO000P00000A0>?Ul0030?ooo`00?7@0inKY
00H0h=oS00<0fMGE000lM03oool03@3SiO001`000000hnG`0>?Ul0000000
hnG`0000003SiO001@0000030>?Ul0050000003SiO00hnG`0>?Ul0000000
403SiO000`3oool003ad0>OVj@0o0>3Oh`0509fMX@1aKf@0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP3oool0>`3Pgn<00`3IeMD0
03ad0?ooo`0=0>W[m@060000003YjoD0jN_e0>W[m@000000jN_e0P000002
0>W[m@070000003YjoD0jN_e0>W[m@000000jN_e000000030>W[m@050000
003YjoD000000>W[m@0000000`3YjoD00`000000jN_e000000030>W[m@03
0000003YjoD0000000<0jN_e00<000000>W[m@3YjoD03@3YjoD00`3oool0
03ad0>OVj@060>3Oh`030=WEe@00?7@0oooo00d0jN_e00<000000>W[m@00
00000P3YjoD00`000000jN_e000000030>W[m@060000003YjoD0jN_e0000
003YjoD000000P3YjoD00`000000jN_e0>W[m@0>0>W[m@030?ooo`00?7@0
inKY03l0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn0?ooo`0k0>3Oh`030=WEe@00?7@0oooo00d0l?7l00T0
00000?3ao03`lO`0l?7l0000003`lO`000000?3ao00000000P3`lO`30000
0080l?7l00L000000?3ao03`lO`0l?7l0000003`lO`000000080l?7l0`00
00020?3ao0050000003`lO`0l?7l0?3ao00000000P3`lO`300000100l?7l
00<0oooo000lM03Wi^T01P3Pgn<00`3IeMD003ad0?ooo`0=0?3ao0030000
003`lO`000000080l?7l00<000000?3ao03`lO`00`0000020?3ao0040000
003`lO`0l?7l0?3ao0@000003`3`lO`00`3oool003ad0>OVj@0o0>3Oh`05
09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP3oool0>`3Pgn<00`3IeMD003ad0?ooo`0=0?Ceo@050000003dmOd0m?Gm
0?Ceo@000000<`3dmOd00`3oool003ad0>OVj@060>3Oh`030=WEe@00?7@0
oooo00d0m?Gm0P0000030?Ceo@030000003dmOd0m?Gm00/0m?Gm00<00000
0?Ceo@3dmOd03P3dmOd00`3oool003ad0>OVj@0o0>3Oh`0509fMX@1aKf@0
IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP3oool0>`3P
gn<00`3IeMD003ad0?ooo`0=0?Kgo@@000004P3fmod00`000000m_Om0?Kg
o@0O0?Kgo@030?ooo`00?7@0inKY00H0h=oS00<0fMGE000lM03oool03@3f
mod00`000000m_Om0?Kgo@020?Kgo@030000003fmod0m_Om00/0m_Om00<0
00000?Kgo@3fmod03P3fmod00`3oool003ad0>OVj@0o0>3Oh`0509fMX@1a
Kf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP3oool0
>`3Pgn<00`3IeMD003ad0?ooo`150?Slo@030?ooo`00?7@0inKY00H0h=oS
00<0fMGE000lM03oool0<@3ho?d00`3oool003ad0>OVj@0o0>3Oh`0509fM
X@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP3o
ool0>`3Pgn<00`3IeMD003ad0?ooo`150?gmo@030?ooo`00?7@0inKY00H0
h=oS00<0fMGE000lM03oool0<@3moOd00`3oool003ad0>OVj@0o0>3Oh`05
09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP3oool0>`3Pgn<00`3IeMD003ad0?ooo`150?gmo@030?ooo`00?7@0i^KY
00H0h=oS00<0fMGE000lM03oool0<@3moOd00`3oool003ad0>KVj@0o0>3O
h`0509fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP3oool0>`3Pgn<00`3He=@003ad0?ooo`150?gmo@030?ooo`00?7@0
iNGX00H0h=oS00<0f=CD000lM03oool0<@3moOd00`3oool003ad0>GUj00o
0>3Oh`0509fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP3oool0>`3Pgn<00`3IeMD09EN50;o>g0150?ooo`030;o>f`0U
EhD0hN7T00H0h=oS00<0fMGE02EGQ@2oc]`0<@3oool00`2oc]/09EN50>7Q
i00o0>3Oh`0509fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP3oool0>`3Pgn<0103IeMD0NIBY05EmXP30cme30?ooo`04
0=GOj01EOJ80NIF[0=oMh0H0h=oS00@0fMGE07VDZ@1EOJ80`<oM;`3oool0
103EgnP0EGfR07VEZ`3OgN0o0>3Oh`0509fMX@1aKf@0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP3oool0>`3Pgn<0103JemT0gmcH
07VDZ@0UEhE3000lM00401M=OP1VQZ40h=kJ0=cKg@H0h=oS00@0f]OI0=oL
f01iU:T09EN5;`00?7@0100GCGh0IXJQ0>3NfP3Lfmdo0>3Oh`0509fMX@1a
Kf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP3oool0
>`3Pgn<00`3OgN00f]OI0=SDe00S0=OCe1h0dlk<0`3Gdm@0103He=@0fMGE
0=[Gf@3OgN060>3Oh`030=oMh03JemT0f=CD01T0em?D503Cc/`30=OCe004
0=SDe03IeMD0f]OI0=oMh3l0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`<0h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`0Q0>3Ohn80oooo00@0LFmT06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP2AVi`00P3lo?h06P000000o?cn0000003lo?h000000?cl
oP000000o?cn0000003lo?h000000?cloP000000o?cn0000003lo?h00000
0?cloP000000o?cn0000003lo?h000000?cloP000000o?cn0P0000020?cl
oP03096KW02n_]P0_[kH0080_[oH6P2n_]P00`2AYk@0h=oS0>3Oh`320>3O
h`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0TI^L
0200o?cn00<0TI^L0<K8g@36b=d07036b=d00`2AYk@0h=oS0>3Oh`320>3O
h`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0TI^L
0080o?cn00<000000?cloP3lo?h0603lo?h010000000o?cn0?cloP2AVi`N
0<c=hP03096W]03Pgn<0h=oS0<80h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP2AVi`0803lo?h00`2AVi`0eMOY0=GGj@05
0=GGj@030000003EenT0eMOY00<0eMOY00D000000=GGj@3EenT0eMOY0000
00040=GGj@<000001@3EenT00`2AYk@0h=oS0>3Oh`320>3Oh`0306IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0TI^L0080o?cn00<0
00000?cloP3lo?h0603lo?h010000000o?cn0?cloP2AVi`70=_Mk@030000
003KgNd0fmg]00<0fmg]00H000000=_Mk@3KgNd0fmc]0000003Kg>d20=_M
k@050000003KgNd0fmg]0=_Mk@0000000`3KgNd00`3Kg>d0TJNd0>3Oh`33
0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0
TI^L00P0o?cn0`0000030?cloP050000003lo?h0o?cn0?cloP0000000P3l
o?h3000000P0o?cn00<0TI^L0=oOl@3Ogo401@3Ogo400`000000gmoa0=oO
l@020=oOl@070000003Ogo4000000=oOl@000000gmoa000000020=oOl@05
0000003Ogo40gmoa0=oOl@000000103Ogo400`2AYk@0h=oS0>3Oh`320>3O
h`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0TI^L
0080o?cn00<000000?cloP3lo?h00P3lo?h01@000000o?cn0?cloP3lo?h0
00000080o?cn00L000000?cloP3lo?h0o?cn0000003lo?h0000000<0o?cn
00<000000?cloP3lo?h00P3lo?h010000000o?cn0?cloP2AVi`70>GVm003
0000003Ui_@0iNKd0080iNKd00L000000>GVm0000000iNKd0000003Ui_@0
00000080iNKd00D000000>GVm03Ui_@0iNKd000000040>GVm003096W]03P
gn<0h=oS0<80h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP2AVi`01P3lo?h00`000000o?cn0?cloP030?cloP030000003l
o?h0000000<0o?cn00<000000?cloP0000002`3lo?h00`2AVi`0j^[h0>[Z
n0050>[Zn0050000003Zj_P0j^[h0>[Zn00000000P3Zj_P00`000000j^[h
000000020>[Zn0030000003Zj_P0000000<0j^[h00<000000>[Zn03Zj_P0
0P3Zj_P00`2AYk@0h=oS0>3Oh`320>3Oh`0306IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0TI^L0080o?cn00D000000?cloP3lo?h0
o?cn000000050?cloP030000003lo?h0000000<0o?cn00<000000?cloP00
0000100000040?cloP040000003lo?h0o?cn096KW0L0j^[i00D000000>[Z
n@3Zj_T0j^[i000000030>[Zn@050000003Zj_T0j^[i0>[Zn@0000000P3Z
j_T3000000D0j^[i00<0TJNd0>3Oh`3Pgn<0`P3Pgn<00`1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn096KW0060?cloP030000003l
o?h0o?cn00<0o?cn00@000000?cloP00000000000P3lo?h00`000000o?cn
000000030?cloP030000003lo?h0o?cn00D0o?cn00<0TI^L0?7ao@3alOd0
1@3alOd00`000000lO7m0?7ao@0D0?7ao@03096W]03Pgn<0h=oS0<80h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2AVi`0
0P3lo?h01@000000o?cn0?cloP3lo?h0000000D0o?cn00@000000?cloP00
0000o?cn0P0000030?cloP<000001@3lo?h01P000000o?cn0?cloP2AVi`0
mOCm0?Kdo@<0mOCm1@00000D0?Gdo@03096W]03Pgn<0h=oS0<80h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2AVi`01`3l
o?h01@000000o?cn0?cloP3lo?h0000001@0o?cn00<0TI^L0?[ioP3jnOh0
703jnOh00`2AYk@0h=oS0>3Oh`320>3Oh`0306IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0TI^L0080o?cn00<000000?cloP3lo?h0
0`3lo?h300000180o?cn00@000000?cloP3lo?h0TI^L7P3oool00`2AYk@0
h=oS0>3Oh`320>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh0TI^L0200o?cn00<0TI^L0?ooo`3oool0703oool00`2AYk@0
h=oS0>3Oh`320>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh0TI^L0080o?cn00<000000?cloP3lo?h0603lo?h01@000000
o?cn0?cloP2AVi`0oOgl01`0oooo00<0m_Cb096W]03Pgn<0``3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn096KW00P0?cl
oP03096KW03SjN`0o_kn01X0oooo00<0o_km0>?Yj`2Y^Kl0a03Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn096KW0020?cl
oP0J0000003lo?h000000?cloP000000o?cn0000003lo?h000000?cloP00
0000o?cn0000003lo?h000000?cloP000000o?cn0000003lo?h000000?cl
oP000000o?cn0000003lo?h200000080o?cn00<0TI^L0;K4c@3TjN`06P3o
ool00`3]lO<0]/C=0=3Fd0340>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
1P1VIWh0nocm0:RY^`1VIWh0gJ5C0?Vh>1h0olLl00@0nKPh0=fQD`3@e]00
ZKVo6P2AYk@00`2Q/k/0b=7=0>3Oh`340>3Oh`0306IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0hLJ>0>jO<@3i^CP0703ob3`00`3k
_ST0kYla0>76SP3S0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0h=oS0>76SP3[Ubh0703VRb`00`3TUc`0gL:=0>3Oh`3S
0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko
0>3Oh`H0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000306IVOP3gmoT0V9RW
0?l0MgNB201gMi8109RHY`40moOi0@1VIWh0000306IVOP3gmoT0_;g=0?l0
_;g=2@2l_Ld10?Ogn@40IVIn00000`1VIWh0moOi0>CSh`3o0>CSh`T0i>?S
0@3gmoT106IVOP0000<0IVIn0?3am03oool0`@3oool00`3Thn<0W:Bi06]e
S`0306]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0
oooo0>CSh`2LY;T406]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi
0>CSh`3oool0oooo0>cZjP2LY;T40:HiA0040:LjA02V>D@0YcY40:LjA0T0
YSU400<0W:Bi0>cZjP3oool00`3oool10?3am040IVIn00005P1VIWh0h^7R
0?_lo03kno`0nocm0?cko@3knod0nocm0?_lo03lo?d0o?cl0?cko@3lo?`0
o?_l0?clo03ko?`0o?cl0?_lo@3lno`0o?cm0?_ko@3ko?`20?clo0040?cl
o@3lo?`0no_m0?cloDD0o?_lA03ko?`O0?_lo@0309bT^@1[MHl0QHV`0100
QHV`00H0JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9/00606]eS`2LY;T0
nocl0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_lo03lo?`0o?_m0?_l
o@3RhN800@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0m_Oh0?Og
n@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi0?Kgn@020?Ogn@04
0?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3gmoT0A03gmoU40?Kg
nAl0moOi00<0JgF?08F9/02LW[h0402LW[h01P25RK00JgF?0?Ogn@3gmoT0
JgF?08F9/140W9jn00P0QHV`06]eS`3fmoP0moOh0:HiA02Z?5D0`U9K0<ID
FPd0aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>40
0@1VIWh0000606IVOP3NgN40lO7d0?7am03`lO@0l?;d400000001P3alO@0
l?;e0?7am03al_@0l?;d0?7am8T0l?7e7`3`lO@00`1[MHl0/[G@0:NX`P0@
0:NX`P060;:ed01[MHl0l?7d0?3am01[MHl0/[G@4@2WZ<801@2b]M00JgF?
0?3am@3al_@0YSU40080`U9K00<0beAI0<eIGP3=FEh02`3=FEh0103;E5T0
`U9K0<9BF`2V>D@20?3am0030?7am03`l_@0g]gQ0040IVIn00001`1VIWh0
g=_P0>[[l03Zjo00j^c`0>W[k`0000000P3WinL20=kNgP80inOW00<0ikf4
0>OWi`3WinL00`3WinL20>o_k`040000003Zjo00j^_`0>[[k`80j^_`00<0
j^__0>[[l03Zjo00@`3Zjo140>[/l1l0j^__00@0JgF?0;Jid@2][/H0[Jk6
203oool00`2][/H0[:k60:f^aP030:f^aP030:b^aP2f^M40JgF?0080j^__
00@0JgF?0;Jid@2][/H0[Jk6303oool20:f^aP030:b^aP2f^M40JgF?0080
j^_`00D0YSU40<eIGP3;E5T0cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0beAI
0<eIGP2V>D@0j^__0>[[l0020>[[k`40g=_P0@1VIWh0000406IVOP3IfMl0
hnGZ0>?TjP80hnG[00D0000008b<S03Ng]h0inOW0=kNgP020>OWi`030<IS
003WinL0inOW0080inOW00L0knoW0>o_k`3_knl000000>?TjP3Si>/0hnGZ
0080hnCZ00<0hnC[0>?Uj`3SiN/0@`3SiN]40>?TjQl0hnGZ00D0JgF?0;bn
e02b//X0/[;:0?ooo`0606i]S`0302DU=P2b//X0/[;:00D0/[;:00H0_;kD
06]eS`3SiNX0hnGZ06]eS`2l_]@20;:bbP030?ooo`0U9CH09BDf00T09BDf
0`2b//X01@2l_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN00@0d5]P0=ALG`3o
ool0oooo1`3DG5l20?ooo`0:0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnCZ0>?U
jP3Si>X0hnG[0=WIg`40IVIn00000`1VIWh0emSN0=cNiP030=cNiP050000
003WinL0inOW0>OWi`3We/h00P3WinL01@3>N`00ki@@0>OWi`3Wg/H0kh`@
00<0kno_00L000000=cNiP3Lg^D0g=kU0=cNiP3Lg^D0g=kV0:P0g=kU00D0
JgF?0;o1eP2h^Lh0^;W>0?ooo`0606i]S`0302DU=P2h^Lh0^;W>00D0^;W>
00H0_l7F06]eS`3Lg^D0g=kU06]eS`2o`MH20;RicP030?ooo`0U9CH0^;W>
00L0^;W>00<0oooo02DU=P2h^Lh00P2h^Lh02@2o`MH0JgF?0=cNiP3Lg^D0
YSU40<eIGP3AFUh0e5eQ05<U80030?ooo`D0eUmS0`3oool01@1C9B00e5eQ
0=5JGP3=FEh0YSU40080g=kU00<0g=kV0=cNi@3Gf=h00@1VIWh0000406IV
OP3Ee]d0eMSP0=KHh@80eMSP00T0000008b<S03WinL0inOW0>NeQ03FFP00
eX@00?o>003>H`000P3NJ`001@3_]H`0kno_0>o_k`3_knl000000080eMSQ
00@0eMOP0=KHh03Ff>40e]OQA@3Fen140=KHh1l0eMSQ00D0JgF?0<?5f@2l
_M40_;gA0?ooo`0702DU=PL0_;gA00H0`lGI06]eS`3Ef>40eMSQ06]eS`33
aMT20;bmd@030?ooo`0U9CH0_;gA00L0_;gA00<0oooo02DU=P2l_M400P2l
_M401@33aMT0JgF?0=KGh03Een40YSU40080eEeP00<0f61Q0=UQHP167QX0
0`3oool30=UQHP<0oooo00<0AQhJ0=UQHP3HH6400P3EGF001P2V>D@0e]SP
0=GHh@3Een00eMSQ0=GFg@40IVIn00001`1VIWh0d]CM0<oBg03@d]`0d=;M
0=3Bg00000000`3WinL0303Wg/h0aTX00?O>003_[@00kkD00<i[0036FP00
aV/00=j<BP3WY@00knO>000000<0d=;L00<0cm;L0=3Bg03?d]`0A@3@d]a4
0<oBgAl0d=;L00<0JgF?0<S9f`33a=H04033a=H01P38bM/0JgF?0=3Bg03@
d]`0JgF?0<S9f`80`lCF00<0oooo02DU=P33a=H01`33a=H00`3oool09BDf
0<?4eP020<?4eP070<S9f`1[MHl0cm;L0<oBg02V>D@0eemO0=UQHP030=aU
I@0504HN6P3oool0oooo0?ooo`3LIFD00`3oool020167QX0g6EU0=aUI@3L
IFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`10<oBg040d]CM0@1VIWh0000L06IV
OP3@d]/0blgH0<[=f@3;c]P0b/gH0000003WaZd0ilJ<0?O>603__@00mlH0
0>n]003W[@00ijD00=J<003>J`00ilH00?oF003_knL0kno_0000003;cMP0
blgI0<[=f@3;c]P0b/gH0<_=f4D0blgIA03;c]TO0<_=f00306]eS`3;c=h0
b<[I00P0b<[I00<0b<WI0<S:f@38b]T00`38b]T01038bMT0b<[I0<_<gP1[
MHl20<_=f00606]eS`3;c=h0b<[I0<S:f@3oool09BDf1@38b]T04@38bMT0
b<[I0<S:f@3oool09BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=f02V
>D@0eemO0=]TI03PIfD0h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3oool0
2P167QX0gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0YSU40<[>f03:c]T20<_=
f@40d=;K0@1VIWh0000306IVOP3?cmX0aLSD00<0aLSD00H000000<K6aP3W
g]H0cW/00>N]003_]@020>NU00030=JD003>L`00eY@00080mlH00P3gmoL0
10000000aLSD0<G7e035am@30<G7eDD0a<OEA034b=@O0<C7e00306]eS`3@
dN00bl_L0100bl_L00H0d=7P06]eS`34am@0a<OD06]eS`3@dN020<_;g003
0?ooo`0U9CH0bl_L00L0bl_L00<0oooo02DU=P3;bm`00P3;bm`01`3@dN00
JgF?0<G7e034am@0YSU40=]TI03OIF@01@3PJVP01@167QX0oooo0?ooo`3o
ool0AQhJ00D0h6YX00@0gfET0=]TI02V>D@0a<SE0P34b=@10<G7e@40cloJ
0@1VIWh0000406IVOP3<c]X0`/CB0<74d@80`LCB00H000000>OWi`3WinL0
inOW0=J4003_]@020>NU00080=J4003>J`00ijd00?Ne003g_@00kno_0?Og
m`0000030<74dP030<;4d@31a=80`LCB04D0`LCAA031a=8O0<;4dP0306]e
S`3Cdn80cm3M0100cm3M00H0dm?R06]eS`32a=80`/CB06]eS`3Cdn820<o@
g@030?ooo`0U9CH0cm3M00L0cm3M00<0oooo02DU=P3?d=d00P3?d=d01`3C
dn80JgF?0<;4dP31a=40YSU40=]TI03QJFD01@3PK6T50?ooo`D0h6aY00P0
hFUU0=]TI02V>D@0`LCB0<;4d@31a=40`LCB0<c>fP40IVIn0000101VIWh0
b/cH0;k0c`2m`<l20;k0cP050000002LW9`0inOW0>ONeP3FS0000P3NU000
103FN`00aV<00;e2003_Y@020?N]00080?Ne003ocTX000000;k0cP2n`<l0
_/3>0;k0c`2m`<i60;k0cT@0_L3>7`2n`<h00`1[MHl0e]KT0=?Ch00@0=?C
h0060=KFi01[MHl0_/3>0;k0cP1[MHl0e]KT0P3Cdn000`3oool09BDf0?oo
o`080?ooo`0;02DU=P3Cdn00dm?P0=?Ch03Fe^@0JgF?0;k0c`2n`<h0YSU4
0>1VI@3QJVX0103SK6`30?ooo`0404HN6P3oool0oooo0?ooo`@0hfa/00@0
hFYZ0>1VI@2V>D@0_L3?0P2n`<l10;k0cP40b/cH0@1VIWh0000706IVOP39
b]P0][S80;Vlb`2j_</0^[c<000000020>o_k`0C0=JL003FS000gY@00=J4
003_Y@00gX`00;eJ003FL`00ki`00?O_i`3gmoL0oooo0000002i_<`0^[_<
0;Vlb`2j_</0^Kc<0;Vlb`150;Vlc4@0^[c<7`2j_</00`1[MHl0f=SU0=?C
h@0@0=?Ch@060=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU0P3Cdn400`3oool0
KVf?06i]S`0806i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0JgF?0;Zlb`2j
_<`0YSU40>1YJ03QKF`0i75]0>AaK`3TL6h30?ooo`0304HN6P3TL6h0AQhJ
00<0oooo0P3TL6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<0;Zkc02i_</0][S8
0<W:f00106IVOP0000T0IVIn0<O9e`2d]/L0][S80;Jhb@2f^LT0000008B4
Q03Wimh00P3_knl01`36J`00mlH00>ne003_W000gX`00<i[003WW0000`3g
moL01@000000][W90;Nhb@2f^LT0]kW90080][S9A@2g^<U40;JhbAl0]kS9
00@0JgF?0=KFi03Hf>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@09
0=KFi01[MHl0]kS90;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d0
9BDf0=SHiP3Hf>D0f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3W
LFl0i7A_00<0oooo00D0AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>Ad
K`3WLFl0i7A_0>A^K@2V>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn0000
0`1VIWh0a/SG0;Bfa`030;Bfa`030000003_knl0kno_0080kno_00/0ijd0
0?O6203WY@00ii@00>N<003_imH0gY@i0>oF]@3omoL0oooo0000002^0;Bf
a`0506]eS`3EeN<0g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d
]/L0JgF?0=GEh`80g=_W00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GE
h`1[MHl0];K70;Bfa`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ
0>UnN03YOWP00`3YOWP020167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0
YSU4102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`060000
002<S8`0kno_0>o_k`3WcW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0
knOF0?Ogm`3oool00000[P2d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GD
h`1[MHl0];K70;Bfa`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0
YSU40>YiL`3YO7P0kh5j0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3Z
Vh`0kIN:0>^HR`0204HN6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L1
0<K8e`40IVIn00000`1VIWh0a/SG0;6cb0030;6cb0060000003_knl0kno_
0>o_k`3gmnl0kno_0P3gmoL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`00
0000/K?80:d0/K?800<0JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6c
b02a/lP0JgF?0>g[la40jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0
l8Al0?F<Q03gWHh0lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]
]9/0k;FL0?:[UP3gWHh0mHb40?24O03aP7D0YSU400@0/K?80@36b=L106IV
OP0000<0IVIn0<K8e`2h]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_
00H0moOg0P3omoL20?ooo`030000002_[/L0[jk70:`0[jk700<0JgF?0=;A
h`3blOL0403blOL01P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0
d]7S06]eS`2_[/L0[jk70:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0
YSU40:n^a`020:n^a`40^;O?0@36b=L106IVOP0000<0IVIn0<31d@37am@0
`@2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<
XP80[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24
S:820:b[a007096HZP2V>D@0oin=0?joY03jg;L0n^^g0?[Y]P020?WY]P04
0?[Y]P3ijKH0nNVf0?[Y]P80nNVf00H0n^^g0?[L]`3n_j@0oin=0:HiA02A
V:X30:b[a040alOD0@30`M4106IVOP0000@0IVIn0<31d@3Bd]l0]KC9`@2T
Xkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0
Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V
>D@0YSU400l0YSU400L0Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040
IVIn00001P1VIWh0Z:No0>KVk@3Bd^00_;c?0;6`a?l0Z:No0P2XYkl01@2a
/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3lo?`0
i>?X0=3@h03:b]X0o`2l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7V`40
F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[o@3Gf>80
1`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX00<0
IVIn09FDZ`3AdMh00P3lo?co0?ooo`80o?cl00<0dM7N09FDZ`1VIWh00P1H
EfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW_`3n0:RW_`0409FDZ`28Qid0
IVIn06IVOP<0F5MX000505QGJ?l0IVIn101VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[23]:=",
  Evaluatable->False,
  ImageSize->{269, 240},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[23]=",
  CellTags->"WidgetGroup-Layout"]
}, Open  ]],

Cell["\<\
Here is an example that uses a split pane and illustrates how we can \
optionally name the split pane so it can be manipulated using its properties \
at runtime.\
\>", "Text",
  CellTags->"WidgetGroup-Layout"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ 
      GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
\[IndentingNewLine]WidgetGroup[{\[IndentingNewLine]Widget["\<Button\>", \
{"\<text\>" -> "\<Button B\>"}], \
\[IndentingNewLine]WidgetGroup[{Widget["\<Button\>", {"\<text\>" -> "\<Button \
A\>"}], \ Widget["\<TextField\>", \ {"\<text\>" -> "\<some\>"}]}, \ 
                WidgetLayout \[Rule] Column]\[IndentingNewLine]}, \ 
            WidgetLayout \[Rule] {"\<Grouping\>" \[Rule] {Split, \ 
                    Vertical}}, \ 
            Name -> "\<mySplitPane\>"]\[IndentingNewLine]]\[IndentingNewLine]]\
\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject255777331740673, 
        JLink`Objects`JavaObject260075469930497]]], "Output",
  CellLabel->"Out[24]=",
  CellTags->"WidgetGroup-Layout"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // \ Show\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000KR000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0lNoR
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
L@2U[;80103akn80IVIn0:RY^`3ko?d106IVOP0000H0IVIn0?_lo@2XZK/0
IVIn075_I02U[;9_0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d00@1VIWh0
000606IVOP3ko?d0Z:Vk06IVOP1aKf@0YJbbK`3oool01@2U[;80lNoR06IV
OP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F//Vl0
oooo00D0YJbb0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2X
ZK/0IVIn075_I02U[;9_0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d00@1V
IWh0000606IVOP3ko?d0Z:Vk06IVOP1aKf@0YJbbK`3oool01@2U[;80lNoR
06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F/
/PH0oooo0`0000030?ooo`<000000P3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo00<00000DP3oool01@2U[;80lNoR06IVOP2X
ZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F//PD0oooo
00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?oo
o`0000000P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00<0
00000?ooo`3oool0C`3oool01@2U[;80lNoR06IVOP2XZK/0nocm0040IVIn
00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F//PP0oooo00@000000?ooo`3o
ool000000`3oool00`000000oooo000000020?ooo`060000003oool0oooo
0000003oool00000E@3oool01@2U[;80lNoR06IVOP2XZK/0nocm0040IVIn
00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F//PH0oooo0P0000030?ooo`07
0000003oool0oooo0?ooo`000000oooo000000020?ooo`050000003oool0
oooo0000003oool01@00001A0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d0
0@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1aKf@0YJbb1@3oool01`000000
oooo0?ooo`3oool000000?ooo`0000000`3oool01@000000oooo00000000
0000oooo0080000000@0oooo0000003oool000000`3oool00`000000oooo
0?ooo`1?0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d00@1VIWh0000606IV
OP3ko?d0Z:Vk06IVOP1aKf@0YJbb1P3oool3000000<0oooo0`0000020?oo
o`030000003oool000000080oooo00@000000?ooo`3oool0oooo0`00001B
0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0
Z:Vk06IVOP1aKf@0YJbbK`3oool01@2U[;80lNoR06IVOP2XZK/0nocm0040
IVIn00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F//Vl0oooo00D0YJbb0?7_
hP1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn075_I02U
[;9_0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3k
o?d0Z:Vk06IVOP1aKf@0YJbbK`3oool01@2U[;80lNoR06IVOP2XZK/0nocm
0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F//Vl0oooo00D0YJbb
0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn075_
I02U[;9_0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d00@1VIWh0000606IV
OP3ko?d0Z:Vk06IVOP1aKf@0YJbbK`3oool01@2U[;80lNoR06IVOP2XZK/0
nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT0740YJbb00@0lNoR
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0L@3P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I01a0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0LFmT0740h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000:
06IVOP3ko?d0Z:Vk06IVOP1aKf@0hN3T0>KUj03/jnh0l?3b0?;bm3@0lo?d
<@3hmoP20??cm0090??cm@3dm?D0mOGf0?Ccm@3Ui>P0lNoR06IVOP2XZK/0
nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=kLg`3Th^00NiN]
02EGQ@1Y000lM00801M=OP1[RjH0l_7^0?;al`3akn80IVIn0:RY^`3ko?d1
06IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_I03Jf=T0IXFQ04YaT`2b_L<0
J@36aML02030a/D0B6j@06Z:Y03_ko40lNoR06IVOP2XZK/0nocm0@1VIWh0
000806IVOP3ko?d0Z:Vk06IVOP1aKf@0f=GF01M=OP2oalY[0<K5e`070;Jm
_@0GCGh0jn[]0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2X
ZK/0IVIn075_I03IeMD003ad0?ooof/0cLcO00L0oooo000lM03XinX0lNoR
06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0LFmT0=WE
e@00?7@0ooooJ`3BdN@01`3oool003ad0>OVj@3akn80IVIn0:RY^`3ko?d0
0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1aKf@0fMGE000lM03ooom[0=KG
i`070?ooo`00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn
0?_lo@2XZK/0IVIn075_I03IeMD003ad0?ooob00fM[W1@0000030=WJi`80
000000<0fM[W0000003If^L00P0000000`3If^L00000000000020=WJi`<0
00000P3If^L01@000000fM[W0=WJi`3If^L0000000@0fM[W00<000000=WJ
i`3If^L00`3If^L00`000000fM[W0=WJi`0P0=WJi`070?ooo`00?7@0inKY
0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn075_
I03IeMD003ad0?ooob00fM[W00<000000=WJi`3If^L00P3If^L00`000000
fM[W000000020=WJi`80000000D0fM[W0000003If^L0fM[W000000020=WJ
i`070000003If^L0fM[W0=WJi`000000fM[W000000030=WJi`030000003I
f^L0fM[W0080fM[W00<000000=WJi`3If^L00`3If^L00`000000fM[W0=WJ
i`0P0=WJi`070?ooo`00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP00
00P0IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad0?ooob00g]o/00<00000
0=kOk03Ngn`00P3Ngn`00`000000g]o/000000030=kOk0030000003Ngn`0
00000080g]o/00@000000=kOk03Ngn`000000`3Ngn`00`000000g]o/0000
00030=kOk0030000003Ngn`0g]o/00<0g]o/1@00000S0=kOk0070?ooo`00
?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0
IVIn075_I03IeMD003ad0?ooob00hnG`00<000000>?Ul03SiO000P3SiO00
0`000000hnG`000000030>?Ul0030000003SiO0000000080hnG`00@00000
0>?Ul03SiO0000000`3SiO000`000000hnG`000000030>?Ul0030000003S
iO00hnG`00<0hnG`00D000000>?Ul03SiO00hnG`0000000S0>?Ul0070?oo
o`00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2X
ZK/0IVIn075_I03IeMD003ad0?ooob00jN_e1@0000020>W[m@070000003Y
joD0jN_e0>W[m@000000jN_e000000020>W[m@040000003YjoD0jN_e0000
00<0jN_e00@000000>W[m@00000000000P3YjoD00`000000jN_e0>W[m@04
0>W[m@030000003YjoD0000002@0jN_e00L0oooo000lM03Wi^T0lNoR06IV
OP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0LFmT0=WEe@00
?7@0oooo803`lO`00`000000l?7l0?3ao0020?3ao0030000003`lO`00000
00<0l?7l1`0000020?3ao0<000000P3`lO`010000000l?7l000000000007
0?3ao0030000003`lO`0000002@0l?7l00L0oooo000lM03Wi^T0lNoR06IV
OP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0LFmT0=WEe@00
?7@0oooo803dmOd00`000000m?Gm0?Ceo@020?Ceo@030000003dmOd0m?Gm
00D0m?Gm00@000000?Ceo@3dmOd000004`3dmOd00`000000m?Gm0000000T
0?Ceo@070?ooo`00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0
IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad0?ooob00m_Om1@0000080?Kg
o@040000003fmod0m_Om000001@0m_Om00<000000?Kgo@3fmod08`3fmod0
1`3oool003ad0>OVj@3akn80IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3k
o?d0Z:Vk06IVOP1aKf@0fMGE000lM03ooom[0?Slo@070?ooo`00?7@0inKY
0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn075_
I03IeMD003ad0?ooof/0oOgm00L0oooo000lM03Wi^T0lNoR06IVOP2XZK/0
nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0LFmT0=WEe@00?7@0oooo
J`3moOd01`3oool003ad0>KVj@3akn80IVIn0:RY^`3ko?d00@1VIWh00008
06IVOP3ko?d0Z:Vk06IVOP1aKf@0f=CD000lM03ooom[0?gmo@070?ooo`00
?7@0iNGX0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0
IVIn075_I03IeMD09EN50;o>g6/0oooo00L0_lkK02EGQ@3QhN@0lNoR06IV
OP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=WEe@1i
U:T0EGfR0<3?g@1Y0?ooo`080=GOj01EOJ80NIF[0=oMh03akn80IVIn0:RY
^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_I03JemT0gmcH07VD
Z@0UEhD0J@00?7@0200GCGh0IXJQ0>3NfP3Lfmd0lNoR06IVOP2XZK/0nocm
0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1aKf@0gmgP0=[Gf@3He=@f0=OC
e340dlk<0`3Gdm@0203He=@0fMGE0=[Gf@3OgN00lNoR06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0LFmT00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0lNoR00<0IVIn0:RY^`3ko?d0
0@1VIWh0000:06IVOP3ko?d0Z:Vk06IVOP1aKf@0hN3T0>KUj03/jnh0l?3b
0?;bm3@0lo?d<@3hmoP20??cm0090??cm@3dm?D0mOGf0?Ccm@3Ui>P0lNoR
06IVOP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=kL
g`3Th^00NiN]02EGQ@1Y000lM00801M=OP1[RjH0l_7^0?;al`3akn80IVIn
0:RY^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_I03Jf=T0IXFQ
02M=Q@1=OL40JP1YP^h01`0WCHD0JXZT0>o_l@3akn80IVIn0:RY^`3ko?d0
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1aKf@0f=GF01M=OP1]08V]i006
01M=OP3[j^d0lNoR06IVOP2XZK/0nocm0@1VIWh0000906IVOP3ko?d0Z:Vk
06IVOP1aKf@0fMGE000lM029[N@0oooo06T0cLcO00P0oooo08V]i000?7@0
j>OZ0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00002@1VIWh0nocm0:RY^`1VIWh0
LFmT0=WEe@00?7@0RjgT0?ooo`1Y0=;Ai0080?ooo`2;[nD003ad0>OVj@3a
kn80IVIn0:RY^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_I03I
eMD003ad08j_iP3oool0J@3FenL0203oool0SJoU000lM03Wi^T0lNoR06IV
OP2XZK/0nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP1aKf@0fMGE000l
M02A/NL0oooo0200fM[W1@0000030=WJi`80000000<0fM[W0000003If^L0
0P0000000`3If^L00000000000020=WJi`<000000P3If^L01@000000fM[W
0=WJi`3If^L0000000@0fM[W1@00000R0=WJi`080?ooo`2A/NH003ad0>OV
j@3akn80IVIn0:RY^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_
I03IeMD003ad09Bdj03oool0803If^L00`000000fM[W0=WJi`020=WJi`03
0000003If^L000000080fM[W0P0000001@3If^L000000=WJi`3If^L00000
0080fM[W00L000000=WJi`3If^L0fM[W0000003If^L0000000<0fM[W00<0
00000=WJi`3If^L00P3If^L00`000000fM[W0=WJi`020=WJi`030000003I
f^L0fM[W01l0fM[W00P0oooo09Fdj000?7@0inKY0?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=WEe@00?7@0V;SZ0?oo
o`0P0=kOk0030000003Ngn`0g]o/0080g]o/00<000000=kOk00000000`3N
gn`00`000000g]o/000000020=kOk0040000003Ngn`0g]o/000000<0g]o/
00<000000=kOk00000000`3Ngn`00`000000g]o/0=kOk0020=kOk0030000
003Ngn`0g]o/0080g]o/00<000000=kOk03Ngn`07`3Ngn`0203oool0V;SY
000lM03Wi^T0lNoR06IVOP2XZK/0nocm0@1VIWh0000906IVOP3ko?d0Z:Vk
06IVOP1aKf@0fMGE000lM02L^nX0oooo0200hnG`00<000000>?Ul03SiO00
0P3SiO000`000000hnG`000000030>?Ul0030000003SiO0000000080hnG`
00@000000>?Ul03SiO0000000`3SiO000`000000hnG`000000030>?Ul003
0000003SiO00hnG`0080hnG`00<000000>?Ul03SiO000P3SiO000`000000
hnG`0>?Ul00O0>?Ul0080?ooo`2L^n/003ad0>OVj@3akn80IVIn0:RY^`3k
o?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad0:2nk03o
ool0803YjoD500000080jN_e00L000000>W[m@3YjoD0jN_e0000003YjoD0
00000080jN_e00@000000>W[m@3YjoD000000`3YjoD010000000jN_e0000
000000020>W[m@030000003YjoD0jN_e0080jN_e1@00000R0>W[m@080?oo
o`2Q_^`003ad0>OVj@3akn80IVIn0:RY^`3ko?d106IVOP0000T0IVIn0?_l
o@2XZK/0IVIn075_I03IeMD003ad0:G1k@3oool0803`lO`00`000000l?7l
0?3ao0020?3ao0030000003`lO`0000000<0l?7l1`0000020?3ao0<00000
0P3`lO`010000000l?7l0000000000050?3ao0030000003`lO`0l?7l0080
l?7l00<000000?3ao03`lO`07`3`lO`0203oool0YL;^000lM03Wi^T0lNoR
06IVOP2XZK/0nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP1aKf@0fMGE
000lM02YaNl0oooo0200m?Gm00<000000?Ceo@3dmOd00P3dmOd00`000000
m?Gm0?Ceo@050?Ceo@040000003dmOd0m?Gm00000140m?Gm00<000000?Ce
o@3dmOd00P3dmOd00`000000m?Gm0?Ceo@0O0?Ceo@080?ooo`2YaNl003ad
0>OVj@3akn80IVIn0:RY^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn
075_I03IeMD003ad0:g8l03oool0803fmod5000000P0m_Om00@000000?Kg
o@3fmod000004@3fmod500000280m_Om00P0oooo0:c7l000?7@0inKY0?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=WE
e@00?7@0/L_b0?ooo`1Y0?Slo@080?ooo`2ac?8003ad0>OVj@3akn80IVIn
0:RY^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad
0;C=l`3oool0J@3moOd0203oool0]Lkc000lM03Wi^T0lNoR06IVOP2XZK/0
nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP1aKf@0fMGE000lM02gd?@0
oooo06T0oOgm00P0oooo0;S@m@00?7@0i^KY0?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=SDe000?7@0^]?e0?ooo`1Y
0?gmo@080?ooo`2jdoH003ad0>GUj03akn80IVIn0:RY^`3ko?d106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn075_I03IeMD09EN506d0_=Cf00H09EN50>7Q
i03akn80IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn075_
I03IeMD0NIBY02M=QF/0c^Oo00L09df507VEZ`3OgN00lNoR06IVOP2XZK/0
nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=[Gf@3Og=P0NIBY
02EGQ@1Y000lM00801M=OP1VQZ40h=kJ0=cKg@3akn80IVIn0:RY^`3ko?d1
06IVOP0000P0IVIn0?_lo@2XZK/0IVIn075_I03OgN00f]OI0=SDe3H0em?D
<@3Cc/`30=OCe0080=SDe03IeMD0f]OI0=oMh03akn80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVInLP1aKf@0103akn80IVIn0:RY^`3k
o?d106IVOP0000<0IVIn0?Ogn@2HV:L0M@1gMi8109RHY`40moOi0@1VIWh0
000306IVOP3gmoT0_;g=07H0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3T
hn<0MP3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`0_0?ooo`030>CS
h`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0
i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[
MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W
>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F
06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0
o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080
o?cl00@0o?cm0?clo03knod0o?cm503lno`20?_lo00309bT^@1[MHl0QHV`
0100QHV`00H0JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9/00606]eS`2L
Y;T0nocl0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_lo03lo?`0o?_m
0?_lo@3RhN800@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0m_Oh
0?Ogn@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi0?Kgn@020?Og
n@040?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3gmoT04`3gmoT2
0?Kgn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi06]e
S`25RK0A09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=
0<IEG0090<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q0040
IVIn00001P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm100000000H0lO7d0?3b
m@3alO@0lO;d0?3bm03alO@F0?3am@0306]eS`2b]M00YjS20100YjS200H0
/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e0?7b
m02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0`U9K
0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3Lfn00j^_`
0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0inOW0>OW
i`030>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`
0>[[l00B0>[[l080j^c`00@0JgF?0;Jid@2][/H0[Jk6203oool00`2][/H0
[:k60:f^aP030:f^aP030:b^aP2f^M40JgF?0080j^__00@0JgF?0;Jid@2]
[/H0[Jk6303oool20:f^aP030:b^aP2f^M40JgF?0080j^_`00D0YSU40<eI
GP3;E5T0cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0j^__
0>[[l0020>[[k`40g=_P0@1VIWh0000406IVOP3IfMl0hnGZ0>?TjP80hnG[
00D0000008b<S03Ng]h0inOW0=kNgP020>OWi`030<IS003WinL0inOW0080
inOW00L0knoW0>o_k`3_knl000000>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[
0>?Uj`3SiN/04P3SiN/20>?TjP0506]eS`2l_]@0/[;:0;:bbP3oool01P1^
KHl00`0U9CH0/[;:0;:bbP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[MHl0
_;kD0P2b//X00`3oool09BDf02DU=P0902DU=P<0/[;:00D0_;kD06]eS`3S
i>/0hnC[0:HiA0020<eIGP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3oool0
2P3DG5l0d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl106IV
OP0000<0IVIn0=OHgP3Lg^H00`3Lg^H01@000000inOW0>OWi`3WinL0imK>
0080inOW00D0cW/00>nD403WinL0imk60>n<40030>o_k`070000003Lg^H0
g=kU0=cNi@3Lg^H0g=kU0=cNiP0F0=cNi@0506]eS`2o`MH0^;W>0;RicP3o
ool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU0=cN
i@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U9CH0
^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C
9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA0020=cN
i@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>420=GH
h0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080gV/0
00D0kkF<0>o_k`3_knl0kno_000000020=GHh@040=GGh03Ff>00e]SQ0=KG
hA@0e]OP0P3Ff>001@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M40
1P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M40
1`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V
>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0
fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0
000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36
BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@
d]`00`3?d]`0d=;L0<oBg00D0=3Bg080cm;M00<0JgF?0<S9f`33a=H04033
a=H01P38bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80`lCF00<0oooo02DU=P33
a=H01`33a=H00`3oool09BDf0<?4eP020<?4eP070<S9f`1[MHl0cm;L0<oB
g02V>D@0eemO0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3o
ool020167QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`10<oB
g040d]CM0@1VIWh0000L06IVOP3@d]/0blgH0<[=f@3;c]P0b/gH0000003W
aZd0ilJ<0?O>603__@00mlH00>n]003W[@00ijD00=J<003>J`00ilH00?oF
003_knL0kno_0000003;cMP0blgI0<[=f@3;c]P0b/gH0<_=f1@0blgI0P3;
c]T00`1[MHl0blcN0<S:f@080<S:f@030<S9f@38b]T0b<[I00<0b<[I00@0
b<WI0<S:f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN0<S:f@38b]T0oooo02DU
=PD0b<[I0140b<WI0<S:f@38b]T0oooo02DU=P38b]T0b<WI0<S:f@3;c=h0
JgF?0<_>f03:cMP0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN6P3o
ool0oooo00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO0:Hi
A03:c]P0b/kI0P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0030<G8
e00600000036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD
00020?O60080moOg00@000000<G8e035am@0aLOD0`35amDD0<C7e@80a<SD
00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3A
h080bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;
g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3o
ool0oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040
aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000
inOW0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm
003_knl0moOg000000<0`LCB00<0`/CA0<74dP31a=805031a=420<74dP03
06]eS`3Cdn80cm3M0100cm3M00H0dm?R06]eS`32a=80`/CB06]eS`3Cdn82
0<o@g@030?ooo`0U9CH0cm3M00L0cm3M00<0oooo02DU=P3?d=d00P3?d=d0
1`3Cdn80JgF?0<;4dP31a=40YSU40=]TI03QJFD01@3PK6T50?ooo`D0h6aY
00P0hFUU0=]TI02V>D@0`LCB0<;4d@31a=40`LCB0<c>fP40IVIn0000101V
IWh0b/cH0;k0c`2m`<l20;k0cP050000002LW9`0inOW0>ONeP3FS0000P3N
U000103FN`00aV<00;e2003_Y@020?N]00080?Ne003ocTX000000;k0cP2n
`<l0_/3>0;k0c`2m`<hE0;k0cP80_L3>00<0JgF?0=KFi03Cdn00403Cdn00
1P3Fe^@0JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3oool0
203oool02`0U9CH0dm?P0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:HiA03P
IVD0hFYZ00@0hfa/0`3oool010167QX0oooo0?ooo`3oool40>=/K0040>5Z
JP3PIVD0YSU40;g0c`80_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0bL[H
0;Jhb02i_</0^[c;0;Zlc00000000P3_knl04`3FW000eX`00=jD003FQ000
kjD00=j<002mFP00eW<00>nL003gknL0moOg0?ooo`000000^Kc<0;Zkc02i
_</0^[c;0;Vlc02i_</0502i_<`20;Zlc00306]eS`3Hf>D0dm?Q0100dm?Q
00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?
00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0
h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3oool2
0>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H0040
IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OWgP02
0>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Ogm`050000
002f^LT0]kS90;Jib@2g^LT00P2f^<TD0;Nhb@80][S900@0JgF?0=KFi03H
f>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@090=KFi01[MHl0]kS9
0;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d09BDf0=SHiP3Hf>D0
f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo
00D0AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^
K@2V>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn00000`1VIWh0a/SG0;Bf
a`030;Bfa`030000003_knl0kno_0080kno_00/0ijd00?O6203WY@00ii@0
0>N<003_imH0gY@i0>oF]@3omoL0oooo0000000L0;Bfa`0506]eS`3EeN<0
g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80
g=_W00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GEh`1[MHl0];K70;Bf
a`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ0>UnN03YOWP00`3Y
OWP020167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d]/L10<K8
e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`060000002<S8`0kno_0>o_
k`3WcW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool0
0000702d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0];K70;Bf
a`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0YSU40>YiL`3YO7P0
kh5j0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:0>^HR`02
04HN6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L10<K8e`40IVIn0000
0`1VIWh0a/SG0;6cb0030;6cb0060000003_knl0kno_0>o_k`3gmnl0kno_
0P3gmoL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`000000/K?801/0/K?8
00<0JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[
la40jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0
lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3g
WHh0mHb40?24O03aP7D0YSU400@0/K?80@36b=L106IVOP0000<0IVIn0<K8
e`2h]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3omoL2
0?ooo`030000002_[/L0[jk701X0[jk700<0JgF?0=;Ah`3blOL0403blOL0
1P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0d]7S06]eS`2_[/L0
[jk70:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^a`020:n^
a`40^;O?0@36b=L106IVOP0000<0IVIn0<31d@37am@0;`2/Zl@01024S:80
JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400@0Q8bR
06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a007096H
ZP2V>D@0oin=0?joY03jg;L0n^^g0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf
0?[Y]P80nNVf00H0n^^g0?[L]`3n_j@0oin=0:HiA02AV:X30:b[a040alOD
0@30`M4106IVOP0000@0IVIn0<31d@3Bd]l0]KC9;`2TXkh00`24S:80JgF?
06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]eS`1[MHl0
3`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V>D@0YSU400l0YSU4
00L0Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040IVIn00001P1VIWh0
Z:No0>KVk@3Bd^00_;c?0;6`a6l0Z:No00D0/K340;blc`3Bd^00i^K]0:RW
_`0106IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@d>00b/[J06d0_;c?
00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ00000P0F5MX06IVOP2E
U:/0emSR0?clo03blO<0k>_^0>7Rjf/0emSR00L0hN;[0>c[kP3blO<0o?cl
0=OHhP2EU:/0IVIn0040F5MX000205QGJ00306IVOP2EU:/0dM7N0080o?cl
K@3oool20?clo0030=7AgP2EU:/0IVIn0080F5MX000305QGJ080IVIn00<0
R8NM09FDZ`2XYkl0K02XYkl0102EU:/0R8NM06IVOP1VIWh305QGJ0001@1H
EfQa06IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[25]:=",
  Evaluatable->False,
  ImageSize->{123, 110},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[25]=",
  CellTags->"WidgetGroup-Layout"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\ @\ 
      PropertyValue[{"\<mySplitPane\>", \ "\<dividerLocation\>"}]\)], "Input",\

  CellLabel->"In[26]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    \(24\)], "Output",
  CellLabel->"Out[26]=",
  CellTags->"WidgetGroup-Layout"]
}, Open  ]],

Cell["\<\
If we resize the panel a little larger, we can see that we can \
programmatically move the divider position.\
\>", "Text",
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    \(ref\ @\ 
      SetPropertyValue[{"\<mySplitPane\>", \ "\<dividerLocation\>"}, \ 
        50]\)], "Input",
  CellLabel->"In[27]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // \ Show\)], "Input",
  CellLabel->"In[28]:=",
  CellTags->"WidgetGroup-Layout"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002>0000[R000`400?l0
0000o`00003oSP1VIWh0000306IVOP3ko?d0nocm08X0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk08T0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
R01VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOXH0lNoR
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
Q03Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn075_I0240>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0LFmT08@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Q03Pgn<0103akn80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I0240>3Oh`040?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08@0h=oS
00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1a
Kf@0Q03Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn075_I0240>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT08@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Q03Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I0240>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@0Q03Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn075_I0240>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT08@0h=oS00@0lNoR06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Q03Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I0240>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
08@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@0Q03Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn075_I0240>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0LFmT08@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Q03Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I0240>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
LFmT08@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@0Q03Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn075_I0240>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08@0h=oS00@0lNoR06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Q03Pgn<0103a
kn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I024
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT08@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@0Q03Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I0240>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Q03Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_
I0240>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0LFmT08@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1aKf@0Q03Pgn<0103akn80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn075_I0240>3Oh`040?7_hP1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08@0YJbb00@0lNoR
06IVOP2XZK/0nocm0@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1aKf@0YJbb
PP3oool01@2U[;80lNoR06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm
0:RY^`1VIWh0LFmT0:F//X80oooo00D0YJbb0?7_hP1VIWh0Z:Vk0?_lo@01
06IVOP0000H0IVIn0?_lo@2XZK/0IVIn075_I02U[;:20?ooo`050:F//P3a
kn80IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1aKf@0
YJbbPP3oool01@2U[;80lNoR06IVOP2XZK/0nocm0040IVIn00001P1VIWh0
nocm0:RY^`1VIWh0LFmT0:F//X80oooo00D0YJbb0?7_hP1VIWh0Z:Vk0?_l
o@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn075_I02U[;860?ooo`<00000
0`3oool300000080oooo00@000000?ooo`3oool000000P3oool00`000000
oooo0?ooo`03000006D0oooo00D0YJbb0?7_hP1VIWh0Z:Vk0?_lo@0106IV
OP0000H0IVIn0?_lo@2XZK/0IVIn075_I02U[;850?ooo`070000003oool0
oooo0?ooo`000000oooo000000030?ooo`030000003oool000000080oooo
00H000000?ooo`3oool000000?ooo`0000030?ooo`030000003oool0oooo
0680oooo00D0YJbb0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_l
o@2XZK/0IVIn075_I02U[;880?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`0000000P3oool01P000000oooo0?ooo`000000oooo0000
06P0oooo00D0YJbb0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_l
o@2XZK/0IVIn075_I02U[;860?ooo`8000000`3oool01`000000oooo0?oo
o`3oool000000?ooo`0000000P3oool01@000000oooo0?ooo`000000oooo
00D00000I03oool01@2U[;80lNoR06IVOP2XZK/0nocm0040IVIn00001P1V
IWh0nocm0:RY^`1VIWh0LFmT0:F//PD0oooo00L000000?ooo`3oool0oooo
0000003oool0000000<0oooo00D000000?ooo`00000000000?ooo`020000
00040?ooo`000000oooo000000<0oooo00<000000?ooo`3oool0HP3oool0
1@2U[;80lNoR06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1V
IWh0LFmT0:F//PH0oooo0`0000030?ooo`<000000P3oool00`000000oooo
000000020?ooo`040000003oool0oooo0?ooo`<00000I@3oool01@2U[;80
lNoR06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0LFmT
0:F//X80oooo00D0YJbb0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn
0?_lo@2XZK/0IVIn075_I02U[;:20?ooo`050:F//P3akn80IVIn0:RY^`3k
o?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1aKf@0YJbbPP3oool01@2U
[;80lNoR06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0
LFmT0:F//X80oooo00D0YJbb0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000H0
IVIn0?_lo@2XZK/0IVIn075_I02U[;:20?ooo`050:F//P3akn80IVIn0:RY
^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1aKf@0YJbbPP3oool0
1@2U[;80lNoR06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1V
IWh0LFmT0:F//X80oooo00D0YJbb0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I0240:F//P040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Q03Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_
I0240>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00002P1VIWh0nocm0:RY
^`1VIWh0LFmT0>7Pi03ViNP0k>_^0?3`lP3bl_@m0??cm3/0n?Oh0P3clo@0
2@3cloD0m?Ce0?GemP3dloD0iNCX0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP00
00T0IVIn0?_lo@2XZK/0IVIn075_I03Ng=l0i>;P07^G[@0UEhD0O000?7@0
200GCGh0Jh^V0?;akP3blO<0lNoR06IVOP2XZK/0nocm0@1VIWh0000906IV
OP3ko?d0Z:Vk06IVOP1aKf@0f]SI06J5X@1:LI<0/[g307`0a/GG00P0`<K5
04Q^T01ZRZ@0knoa0?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000201VIWh0nocm
0:RY^`1VIWh0LFmT0=SEeP0GCGh0_lO:OP36aML01`2f_Kd05den0>_Zk@3a
kn80IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1aKf@0
fMGE000lM03ooomn0<g<g`070?ooo`00?7@0j>OZ0?7_hP1VIWh0Z:Vk0?_l
o@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad0?ooogh0
d]7T00L0oooo000lM03Wi^T0lNoR06IVOP2XZK/0nocm0040IVIn0000201V
IWh0nocm0:RY^`1VIWh0LFmT0=WEe@00?7@0ooooOP3FenL01`3oool003ad
0>OVj@3akn80IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IV
OP1aKf@0fMGE000lM03ooolZ0=WJi`D000000`3If^L2000000030=WJi`00
0000fM[W0080000000<0fM[W0000000000000P3If^L300000080fM[W00D0
00000=WJi`3If^L0fM[W000000040=WJi`030000003If^L0fM[W00<0fM[W
00<000000=WJi`3If^L0:@3If^L01`3oool003ad0>OVj@3akn80IVIn0:RY
^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1aKf@0fMGE000lM03o
oolZ0=WJi`030000003If^L0fM[W0080fM[W00<000000=WJi`0000000P3I
f^L2000000050=WJi`000000fM[W0=WJi`0000000P3If^L01`000000fM[W
0=WJi`3If^L000000=WJi`0000000`3If^L00`000000fM[W0=WJi`020=WJ
i`030000003If^L0fM[W00<0fM[W00<000000=WJi`3If^L0:@3If^L01`3o
ool003ad0>OVj@3akn80IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0
Z:Vk06IVOP1aKf@0fMGE000lM03ooolZ0=kOk0030000003Ngn`0g]o/0080
g]o/00<000000=kOk00000000`3Ngn`00`000000g]o/000000020=kOk004
0000003Ngn`0g]o/000000<0g]o/00<000000=kOk00000000`3Ngn`00`00
0000g]o/0=kOk0030=kOk0D00000;03Ngn`01`3oool003ad0>OVj@3akn80
IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1aKf@0fMGE
000lM03ooolZ0>?Ul0030000003SiO00hnG`0080hnG`00<000000>?Ul000
00000`3SiO000`000000hnG`000000020>?Ul0040000003SiO00hnG`0000
00<0hnG`00<000000>?Ul00000000`3SiO000`000000hnG`0>?Ul0030>?U
l0050000003SiO00hnG`0>?Ul0000000;03SiO001`3oool003ad0>OVj@3a
kn80IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1aKf@0
fMGE000lM03ooolZ0>W[m@D000000P3YjoD01`000000jN_e0>W[m@3YjoD0
00000>W[m@0000000P3YjoD010000000jN_e0>W[m@0000030>W[m@040000
003YjoD0000000000080jN_e00<000000>W[m@3YjoD0103YjoD00`000000
jN_e0000000]0>W[m@070?ooo`00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@01
06IVOP0000P0IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad0?ooobX0l?7l
00<000000?3ao03`lO`00P3`lO`00`000000l?7l000000030?3ao0L00000
0P3`lO`300000080l?7l00@000000?3ao000000000001`3`lO`00`000000
l?7l0000000]0?3ao0070?ooo`00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@01
06IVOP0000P0IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad0?ooobX0m?Gm
00<000000?Ceo@3dmOd00P3dmOd00`000000m?Gm0?Ceo@050?Ceo@040000
003dmOd0m?Gm000001<0m?Gm00<000000?Ceo@000000;@3dmOd01`3oool0
03ad0>OVj@3akn80IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk
06IVOP1aKf@0fMGE000lM03ooolZ0?Kgo@D00000203fmod010000000m_Om
0?Kgo@00000D0?Kgo@030000003fmod0m_Om02`0m_Om00L0oooo000lM03W
i^T0lNoR06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0
LFmT0=WEe@00?7@0ooooOP3ho?d01`3oool003ad0>OVj@3akn80IVIn0:RY
^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1aKf@0fMGE000lM03o
oomn0?gmo@070?ooo`00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP00
00P0IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad0?ooogh0oOgm00L0oooo
000lM03Vi^T0lNoR06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY
^`1VIWh0LFmT0=SDe000?7@0ooooOP3moOd01`3oool003ad0>GUj03akn80
IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1aKf@0fMGE
02EGQ@2oc]an0?ooo`070;o>f`0UEhD0hN7T0?7_hP1VIWh0Z:Vk0?_lo@01
06IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_I03IeMD0NIBY05EmXP30cmd0
O03oool0203EgnP0EGfR07VEZ`3OgN00lNoR06IVOP2XZK/0nocm0@1VIWh0
000906IVOP3ko?d0Z:Vk06IVOP1aKf@0f]OI0=oLf01iU:T09EN507`003ad
00P05den06J6X@3Pg]X0g=_M0?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000201V
IWh0nocm0:RY^`1VIWh0LFmT0=oMh03JemT0f=CD?`3Gdm@k0=?>c0<0em?D
00P0f=CD0=WEe@3JemT0gmgP0?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000101V
IWh0nocm0:RY^`1VIWj6075_I00306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWj60>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWj60>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWj60>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWj60?7_hP0306IVOP2XZK/0nocm0040IVIn00001@1V
IWh0nocm0:RY^`1VIWh0LFmT08@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Q03Pgn<0103akn80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I0240>3Oh`040?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08@0
h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1aKf@0Q03Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn075_I0240>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT08@0h=oS00@0lNoR06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Q03Pgn<0103akn80IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I0240>3Oh`04
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT
08@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1aKf@0Q03Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn075_I0240>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0LFmT08@0h=oS00@0lNoR06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Q03Pgn<0103akn80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I0240>3O
h`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
LFmT08@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@0Q03Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn075_I0240>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08@0h=oS00@0lNoR06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Q03Pgn<0103a
kn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I024
0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT08@0h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1aKf@0Q03Pgn<0103akn80IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn075_I0240>3Oh`040?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT08@0h=oS00@0lNoR06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0Q03Pgn<0
103akn80IVIn0:RY^`3ko?d106IVOP0000X0IVIn0?_lo@2XZK/0IVIn075_
I03Qh>@0i^GX0>c[kP3`l?80l_;d?@3clo@k0?Sgn080lo?d00T0lo?e0?Cd
m@3emOH0m??e0>GTj03akn80IVIn0:RY^`3ko?d00@1VIWh0000906IVOP3k
o?d0Z:Vk06IVOP1aKf@0g]cO0>CRh01kUjd09EN507`003ad00P05den06^;
YP3blNh0l_7c0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00002@1VIWh0nocm0:RY
^`1VIWh0LFmT0=[Hf@1VQJ409df504em`@1m06V2kP0702M=Q@1ZRZ@0knoa
0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn075_
I03HeMH05den0800RJgT00H05den0>_Zk@3akn80IVIn0:RY^`3ko?d106IV
OP0000T0IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad08V]i03oool0O03=
c=l0203oool0RJgT000lM03XinX0lNoR06IVOP2XZK/0nocm0@1VIWh00009
06IVOP3ko?d0Z:Vk06IVOP1aKf@0fMGE000lM02;[N@0oooo07`0d]7T00P0
oooo08^_i@00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00002@1VIWh0
nocm0:RY^`1VIWh0LFmT0=WEe@00?7@0SZoV0?ooo`1l0=KGi`080?ooo`2=
[nD003ad0>OVj@3akn80IVIn0:RY^`3ko?d106IVOP0000T0IVIn0?_lo@2X
ZK/0IVIn075_I03IeMD003ad096ai`3oool0:P3If^L5000000<0fM[W0P00
00000`3If^L000000=WJi`02000000030=WJi`00000000000080fM[W0`00
00020=WJi`050000003If^L0fM[W0=WJi`000000103If^L5000002/0fM[W
00P0oooo096aiP00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00002@1V
IWh0nocm0:RY^`1VIWh0LFmT0=WEe@00?7@0U;CX0?ooo`0Z0=WJi`030000
003If^L0fM[W0080fM[W00<000000=WJi`0000000P3If^L2000000050=WJ
i`000000fM[W0=WJi`0000000P3If^L01`000000fM[W0=WJi`3If^L00000
0=WJi`0000000`3If^L00`000000fM[W0=WJi`020=WJi`030000003If^L0
fM[W0080fM[W00<000000=WJi`3If^L0:03If^L0203oool0UKCX000lM03W
i^T0lNoR06IVOP2XZK/0nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP1a
Kf@0fMGE000lM02H^>X0oooo02X0g]o/00<000000=kOk03Ngn`00P3Ngn`0
0`000000g]o/000000030=kOk0030000003Ngn`000000080g]o/00@00000
0=kOk03Ngn`000000`3Ngn`00`000000g]o/000000030=kOk0030000003N
gn`0g]o/0080g]o/00<000000=kOk03Ngn`00P3Ngn`00`000000g]o/0=kO
k00X0=kOk0080?ooo`2H^>T003ad0>OVj@3akn80IVIn0:RY^`3ko?d106IV
OP0000T0IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad09bkjP3oool0:P3S
iO000`000000hnG`0>?Ul0020>?Ul0030000003SiO00000000<0hnG`00<0
00000>?Ul00000000P3SiO0010000000hnG`0>?Ul00000030>?Ul0030000
003SiO00000000<0hnG`00<000000>?Ul03SiO000P3SiO000`000000hnG`
0>?Ul0020>?Ul0030000003SiO00hnG`02P0hnG`00P0oooo09bkj`00?7@0
inKY0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00002@1VIWh0nocm0:RY^`1VIWh0
LFmT0=WEe@00?7@0X;k/0?ooo`0Z0>W[m@D000000P3YjoD01`000000jN_e
0>W[m@3YjoD000000>W[m@0000000P3YjoD010000000jN_e0>W[m@000003
0>W[m@040000003YjoD0000000000080jN_e00<000000>W[m@3YjoD00P3Y
joD5000002/0jN_e00P0oooo0:6nk000?7@0inKY0?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=WEe@00?7@0YL7]0?oo
o`0Z0?3ao0030000003`lO`0l?7l0080l?7l00<000000?3ao00000000`3`
lO`700000080l?7l0`0000020?3ao0040000003`lO`00000000000D0l?7l
00<000000?3ao03`lO`00P3`lO`00`000000l?7l0?3ao00X0?3ao0080?oo
o`2U`^h003ad0>OVj@3akn80IVIn0:RY^`3ko?d106IVOP0000T0IVIn0?_l
o@2XZK/0IVIn075_I03IeMD003ad0:W5k`3oool0:P3dmOd00`000000m?Gm
0?Ceo@020?Ceo@030000003dmOd0m?Gm00D0m?Gm00@000000?Ceo@3dmOd0
00004@3dmOd00`000000m?Gm0?Ceo@020?Ceo@030000003dmOd0m?Gm02P0
m?Gm00P0oooo0:W5k`00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000
2@1VIWh0nocm0:RY^`1VIWh0LFmT0=WEe@00?7@0[LS`0?ooo`0Z0?Kgo@D0
0000203fmod010000000m_Om0?Kgo@00000A0?Kgo@D00000:`3fmod0203o
ool0[<O`000lM03Wi^T0lNoR06IVOP2XZK/0nocm0@1VIWh0000906IVOP3k
o?d0Z:Vk06IVOP1aKf@0fMGE000lM02abo80oooo07`0n?cm00P0oooo0;7<
lP00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00002@1VIWh0nocm0:RY
^`1VIWh0LFmT0=WEe@00?7@0]<gc0?ooo`1l0?gmo@080?ooo`2ec_<003ad
0>OVj@3akn80IVIn0:RY^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn
075_I03IeMD003ad0;O@m03oool0O03moOd0203oool0^=3e000lM03Vi^T0
lNoR06IVOP2XZK/0nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP1aKf@0
f=CD000lM02jdoD0oooo07`0oOgm00P0oooo0;[CmP00?7@0iNGX0?7_hP1V
IWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0LFmT0=WEe@0U
EhD0P02le?H01P0UEhD0hN7T0?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000201V
IWh0nocm0:RY^`1VIWh0LFmT0=WEe@1iU:T09df5OP3>iol01`0WCHD0NIF[
0=oMh03akn80IVIn0:RY^`3ko?d00@1VIWh0000906IVOP3ko?d0Z:Vk06IV
OP1aKf@0f]OI0=oLf01iU:T09EN507`003ad00P05den06J6X@3Pg]X0g=_M
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000201VIWh0nocm0:RY^`1VIWh0LFmT
0=oMh03JemT0f=CD?`3Gdm@k0=?>c0<0em?D00P0f=CD0=WEe@3JemT0gmgP
0?7_hP1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWj5075_
I0040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00000`1VIWh0moOi09RHY`2807Mg
TP40V9RW0@3gmoT106IVOP0000<0IVIn0?Ogn@2l_Ld0R@2l_Ld10?Ogn@40
IVIn00000`1VIWh0moOi0>CSh`290>CSh`40moOi0@1VIWh0000306IVOP3`
lO@0oooo0480oooo00<0i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?06af
T01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0101/
MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0W:Bi
102V>D@0102W>T@0YSU40:LjA02W>T@90:HiA00309bT^@3/j^X0oooo00<0
oooo0@3`lO@106IVOP0001H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0no_m
0?_lo@3ko?`0o?cm0?clo03lnod0o?cl0?cko03lo?`0nocl0?clo03ko?d0
o?_l0?clo@3knod0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?dJ0?cko0l0
nocl00<0W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi
06]eSa40QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:Hi
A02LY;T0nocl0?clo03lnod0nocm0>;QhP0106IVOP0000@0IVIn0>3Ph@3f
moT0moOi0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh
0?Kgn@3gmoT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3f
moP0moOi0?Ogn@0I0?Ogn@l0m_Oi00<0JgF?08F9/02LW[h0402LW[h01P25
RK00JgF?0?Ogn@3gmoT0JgF?08F9/140W9jn00P0QHV`06]eS`3fmoP0moOh
0:HiA02Z?5D0`U9K0<IDFPd0aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03g
moT0moOh0?Ogn@3Ph>400@1VIWh0000606IVOP3NgN40lO7d0?7am03`lO@0
l?;d400000001P3alO@0l?;e0?7am03al_@0l?;d0?7am2T0l?7e00<0JgF?
0;:ed02WZ<80402WZ<801P2b]M00JgF?0?3am03`lO@0JgF?0;:ed140YjS2
00D0/[G@06]eS`3`lOD0lO;d0:HiA0020<9BF`030<]DF@3=FEh0cEUN00/0
cEUN00@0beAI0<9BF`32DU/0YSU40P3`lO@00`3alO@0l?;d0=kMh@0106IV
OP0000L0IVIn0=cKh03Zjo00j^_`0>[/l03Yjnl000000080inOW0P3Ng]h2
0>OWi`030>NmQ03WinL0inOW00<0inOW0P3_knl010000000j^_`0>[[l03Z
jnl20>[[l0030>[[k`3Zjo00j^_`01P0j^_`3`3Zk?00101[MHl0][WA0:f^
aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[MHl0
0P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Jid@1[
MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO0<eF
F`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0IVIn
0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080inOW
00<0aV<00>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ0>?T
j`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0H0>?Uj`l0hnCZ00D0JgF?0;bn
e02b//X0/[;:0?ooo`0606i]S`0302DU=P2b//X0/[;:00D0/[;:00H0_;kD
06]eS`3SiNX0hnGZ06]eS`2l_]@20;:bbP030?ooo`0U9CH09BDf00T09BDf
0`2b//X01@2l_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN00@0d5]P0=ALG`3o
ool0oooo1`3DG5l20?ooo`0:0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnCZ0>?U
jP3Si>X0hnG[0=WIg`40IVIn00000`1VIWh0emSN0=cNiP030=cNiP050000
003WinL0inOW0>OWi`3We/h00P3WinL01@3>N`00ki@@0>OWi`3Wg/H0kh`@
00<0kno_00L000000=cNiP3Lg^D0g=kU0=cNiP3Lg^D0g=kV02T0g=kU00D0
JgF?0;o1eP2h^Lh0^;W>0?ooo`0606i]S`0302DU=P2h^Lh0^;W>00D0^;W>
00H0_l7F06]eS`3Lg^D0g=kU06]eS`2o`MH20;RicP030?ooo`0U9CH0^;W>
00L0^;W>00<0oooo02DU=P2h^Lh00P2h^Lh02@2o`MH0JgF?0=cNiP3Lg^D0
YSU40<eIGP3AFUh0e5eQ05<U80030?ooo`D0eUmS0`3oool01@1C9B00e5eQ
0=5JGP3=FEh0YSU40080g=kU00<0g=kV0=cNi@3Gf=h00@1VIWh0000406IV
OP3Ee]d0eMSP0=KHh@80eMSP00T0000008b<S03WinL0inOW0>NeQ03FFP00
eX@00?o>003>H`000P3NJ`001@3_]H`0kno_0>o_k`3_knl000000080eMSQ
00@0eMOP0=KHh03Ff>40e]OQ6P3Fen0?0=KHh00506]eS`33aMT0_;gA0;bm
d@3oool01`0U9CH70;bmd@060<?5f@1[MHl0eMSQ0=GHh@1[MHl0`lGI0P2l
_M400`3oool09BDf0;bmd@070;bmd@030?ooo`0U9CH0_;gA0080_;gA00D0
`lGI06]eS`3Fen00eMOQ0:HiA0020=EMH0030=QPH@3IHF80AQhJ00<0oooo
0`3IHF830?ooo`0304HN6P3IHF80f61Q0080eEeP00H0YSU40=KHh03Ef>40
eMOP0=GHh@3Ee]d106IVOP0000L0IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@d]`0
000000<0inOW00`0imk>0<I:003gcP00kjd00>ne003>J`00aUX00<I[003N
S4X0ijD00>oWcP0000030=3Bg0030<oBg03@d]`0cm;L01X0d=;L3`3?d]d0
0`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3Bg01[MHl0b<WK
0P33a=H00`3oool09BDf0<?4eP070<?4eP030?ooo`0U9CH0`lCF0080`lCF
00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU00D0AQhJ0?oo
o`3oool0oooo0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aUI@3IHF80eemO
0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn0=3Bf`3;cMP0
b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH0>nm003gaP00kjd00>N]003W
Y@00eX`00<i[003WaP00omH00>o_i`3_knl000000<_=f03;cMT0b/gI0<_>
f03:cMP0blgH6P3;cMT?0<_>f@0306]eS`3;c=h0b<[I00P0b<[I00<0b<WI
0<S:f@38b]T00`38b]T01038bMT0b<[I0<_<gP1[MHl20<_=f00606]eS`3;
c=h0b<[I0<S:f@3oool09BDf1@38b]T04@38bMT0b<[I0<S:f@3oool09BDf
0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0eemO0=]TI03PIfD0
h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3oool02P167QX0gVMW0=iWI`3P
IVD0h6MU0=]TI03GGel0YSU40<[>f03:c]T20<_=f@40d=;K0@1VIWh00003
06IVOP3?cmX0aLSD00<0aLSD00H000000<K6aP3Wg]H0cW/00>N]003_]@02
0>NU00030=JD003>L`00eY@00080mlH00P3gmoL010000000aLSD0<G7e035
am@30<G7eAX0a<OE3`34b=@00`1[MHl0d=7P0<_;g00@0<_;g0060=3Ah01[
MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3oool09BDf0<_;g0070<_;g003
0?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]eS`35am@0a<OD0:HiA03KI6@0
gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo04HN6P050>1ZJ0040=mUI03K
I6@0YSU40<C8e@80a<SD0@35amD10<o?fP40IVIn0000101VIWh0c<kJ0<;4
dP31a=420<74dP060000003WinL0inOW0>OWi`3FQ000kkD00P3WY@00203F
Q000cV/00>N]003g]@00mkd00>o_k`3gmoL000000`31a=800`32a=40`LCB
0<74dP0J0<74d@l0`LCB00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80JgF?
0<;4dP32a=80JgF?0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?d=d00`3o
ool09BDf0<o@g@020<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT0>5Y
I@050>1/J@D0oooo1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA0<74d@31
a=80c<kJ0@1VIWh0000406IVOP3:c=P0_/3?0;g0c`80_/3>00D0000009bL
W03WinL0imkF0=J<00020=jD00040=Ik0036H`00_D800>nU0080mjd000P0
mkD00?o>BP000000_/3>0;k0c`2n`<h0_/3?0;g0cQ/0_/3>3`2m`<h00`1[
MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0cP1[MHl0e]KT0P3C
dn000`3oool09BDf0?ooo`080?ooo`0;02DU=P3Cdn00dm?P0=?Ch03Fe^@0
JgF?0;k0c`2n`<h0YSU40>1VI@3QJVX0103SK6`30?ooo`0404HN6P3oool0
oooo0?ooo`@0hfa/00@0hFYZ0>1VI@2V>D@0_L3?0P2n`<l10;k0cP40b/cH
0@1VIWh0000706IVOP39b]P0][S80;Vlb`2j_</0^[c<000000020>o_k`0C
0=JL003FS000gY@00=J4003_Y@00gX`00;eJ003FL`00ki`00?O_i`3gmoL0
oooo0000002i_<`0^[_<0;Vlb`2j_</0^Kc<0;Vlb`0J0;Vlc0l0^[c<00<0
JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?0;Zlb`2j_</0JgF?0=SHi@80
dm?Q00<0oooo06i]S`1^KHl0201^KHl03P0U9CH0dm?Q0=?Ch@3Cdn40f=SU
06]eS`2j_</0^[c<0:HiA03PJFP0hFe/0>AaK@3TLFl0i71^0`3oool00`16
7QX0i71^04HN6P030?ooo`80i71^00T0i75]0>5]K03PJFP0YSU40;Zlc02j
^l`0^Kc;0;Jhb039b]P00@1VIWh0000906IVOP37bML0];K70;Jhb02f^<T0
][W900000024Q8@0inON0080kno_00L0aV/00?O6003_]@00ki`00=j<003>
J`00ii`000<0moOg00D000000;Jib@2g^<T0][W90;Nib@020;JhbAX0]kS9
3`2f^<T0101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SHiP80
f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool02P1^
KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03TKVd0
i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0oooo
00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG0@1V
IWh0000306IVOP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_knl0
2`3W[@00mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool00000
02l0];K700D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[MHl0
];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0g=_W
00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3oool0
0`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0igEb
0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0];K7
00H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0moOg
0?Ogm`3_imH0moOg0?ooo`00000_0;Bfa`0306]eS`3Ee><0h=oZ0100h=oZ
00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0];K7
0;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]UhX0
jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:HiA004
0;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H000000>o_
k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg00<0
oooo0000002a/lP0;P2a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[l`1[
MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0YSU4
0?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0
lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP10<K8
e`40IVIn00000`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_0?Og
m`3_knl01P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L0;@2_[/L00`1[
MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S4@3b
lOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@Q@03
0?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0`<7A
0<O7e0120:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[
MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0
JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf0080
nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03oWhd0
YSU4096HZP<0[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;Bg`2e
]<U20:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2T
Xkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0
Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;Bg`30
`M400@1VIWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34PP2XYkl01@2a
/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3lo?`0
i>?X0=3@h03:b]X0P02l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7V`40
F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[OP3Gf>80
1`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX00<0
IVIn09FDZ`3AdMh00P3lo?b00?ooo`80o?cl00<0dM7N09FDZ`1VIWh00P1H
EfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW_`1o0:RW_`0409FDZ`28Qid0
IVIn06IVOP<0F5MX000505QGJ8@0IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[28]:=",
  Evaluatable->False,
  ImageSize->{142, 174},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[28]=",
  CellTags->"WidgetGroup-Layout"]
}, Open  ]],

Cell["\<\
We can also call a method by taking a percentage value instead of using the \
integer property value.\
\>", "Text",
  CellTags->"WidgetGroup-Layout"],

Cell[BoxData[
    \(ref\ @\ 
      InvokeMethod[{"\<mySplitPane\>", \ "\<setDividerLocation\>"}, \ 
        0.50]\)], "Input",
  CellLabel->"In[29]:=",
  CellTags->"WidgetGroup-Layout"]
}, Open  ]],

Cell[CellGroupData[{

Cell["WidgetFill", "Subsection",
  CellTags->"WidgetFill"],

Cell[TextData[{
  StyleBox["WidgetFill[]", "Output"],
  " elements can be useful as \"expanding springs\" that force themselves to \
expand as much as possible along the layout direction they are placed and \
force other widgets within their group to be \"pushed\" to one side."
}], "Text",
  CellTags->"WidgetFill"],

Cell[TextData[{
  "Perhaps the most common use of  ",
  StyleBox["WidgetFill[]", "Output"],
  " is to force a set of horizontal buttons to be right aligned in a dialog \
when resizing."
}], "Text",
  CellTags->"WidgetFill"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
{\[IndentingNewLine]Widget["\<TextArea\>", {"\<text\>"\  \[Rule] \ "\<Some \
content\>", \ "\<rows\>" \[Rule] 4, \ "\<columns\>" \[Rule] 
                    30}], \[IndentingNewLine]{\[IndentingNewLine]WidgetFill[],\
 \[IndentingNewLine]Widget["\<Button\>", {"\<text\>" \[Rule] "\<OK\>"}], \
\[IndentingNewLine]Widget["\<Button\>", {"\<text\>" \[Rule] "\<Cancel\>"}]\
\[IndentingNewLine]}\[IndentingNewLine]}]\ \[IndentingNewLine]];\)\)], "Input",\

  CellLabel->"In[30]:=",
  CellTags->"WidgetFill"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[31]:=",
  CellTags->"WidgetFill"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003J0000P2000`400?l0
0000o`00003ofP1VIWh0000306IVOP3ko?d0nocm0=H0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0=D0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
e01VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOUl0h=oS
00D0hN3T0>KUj03/jnh0l?3b0?;bm00C0??cm100n?Oh0P3clo@01@3cloD0
m?Ce0?GemP3dloD0iNCX00<0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;bm00L
0??cm1T0n?Oh0P3clo@0203cloD0m?Ce0?GemP3dloD0iNCX06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOUl0h=oS00@0g]cO0>CRh01k
Ujd09EN59`00?7@0100GCGh0Jh^V0?;akP3blO<30>3Oh`040=kLg`3Th^00
NiN]02EGQCT003ad00L05den06^;YP3blNh0l_7c06IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWiO0>3Oh`040=[Hf@1VQJ40BW6C0;:m
`bL0a/GG00@0`<K504Q^T01ZRZ@0knoa0`3Pgn<0103Jf=T0IXFQ04YaT`2b
_L<i0<K5e`070<36a@18KY00JXZT0>o_l@1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInG`3Pgn<00`3HeMH05den0;o7bP0Y0<K5e`03
0;Jm_@0GCGh0jn[]00<0h=oS00<0f=GF01M=OP2oalX0>`36aML01P2f_Kd0
5den0>_Zk@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiO
0>3Oh`030=WEe@00?7@0oooo02T0cLcO00<0oooo000lM03XinX00`3Pgn<0
0`3IeMD003ad0?ooo`0k0<g<g`060?ooo`00?7@0j>OZ06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOUl0h=oS00<0fMGE000lM03oool0
:@3BdN@00`3oool003ad0>OVj@030>3Oh`030=WEe@00?7@0oooo03/0d]7T
00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2X
ZK/0IVInG`3Pgn<00`3IeMD003ad0?ooo`0Y0=KGi`030?ooo`00?7@0inKY
00<0h=oS00<0fMGE000lM03oool0>`3FenL01P3oool003ad0>OVj@1VIWh0
Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiO0>3Oh`030=WEe@00
?7@0oooo00l0fM[W0`0000030=WJi`030000003If^L0fM[W0080fM[W00<0
00000=WJi`3If^L0303If^L00`3oool003ad0>OVj@030>3Oh`030=WEe@00
?7@0oooo00l0fM[W0`0000030=WJi`80000000@0fM[W0000003If^L00000
0`3If^L00`000000fM[W0=WJi`03000000<0fM[W0`0000020=WJi`030000
003If^L0fM[W00`0fM[W00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVInG`3Pgn<00`3IeMD003ad0?ooo`0>0=WJ
i`050000003If^L0fM[W0=WJi`0000000P3If^L01@000000fM[W0=WJi`3I
f^L0000000l0fM[W00<0oooo000lM03Wi^T00`3Pgn<00`3IeMD003ad0?oo
o`0>0=WJi`070000003If^L0fM[W0=WJi`000000fM[W000000020=WJi`80
000000<0fM[W0000003If^L00P3If^L00`000000fM[W000000030=WJi`03
0000003If^L0000000<0fM[W00<000000=WJi`0000003P3If^L01P3oool0
03ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiO
0>3Oh`030=WEe@00?7@0oooo00d0g]o/00<000000=kOk03Ngn`00`3Ngn`0
0`000000g]o/000000030=kOk0030000003Ngn`0g]o/00d0g]o/00<0oooo
000lM03Wi^T00`3Pgn<00`3IeMD003ad0?ooo`0=0=kOk0030000003Ngn`0
g]o/00@0g]o/00L000000=kOk03Ngn`0g]o/0000003Ngn`0000000<0g]o/
00<000000=kOk00000001@3Ngn`00`000000g]o/0=kOk0030=kOk0030000
003Ngn`0g]o/00`0g]o/00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVInG`3Pgn<00`3IeMD003ad0?ooo`0=0>?U
l0030000003SiO00hnG`00<0hnG`00H000000>?Ul000000000000>?Ul000
000@0>?Ul0030?ooo`00?7@0inKY00<0h=oS00<0fMGE000lM03oool03@3S
iO000`000000hnG`0>?Ul0050>?Ul0@0000000<0hnG`0000003SiO000P3S
iO000`000000hnG`000000050>?Ul0D0000000<0hnG`0000003SiO003@3S
iO001P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm
0:RY^`1VIWiO0>3Oh`030=WEe@00?7@0oooo00d0jN_e00<000000>W[m@3Y
joD00`3YjoD010000000jN_e0000003YjoD200000100jN_e00<0oooo000l
M03Wi^T00`3Pgn<00`3IeMD003ad0?ooo`0=0>W[m@030000003YjoD0jN_e
00@0jN_e00H000000>W[m@3YjoD0jN_e0000003YjoD200000080jN_e00<0
00000>W[m@0000000`3YjoD00`000000jN_e000000030>W[m@030000003Y
joD0000000h0jN_e00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVInG`3Pgn<00`3IeMD003ad0?ooo`0=0?3ao003
0000003`lO`0l?7l00<0l?7l00<000000?3ao00000000P3`lO`00`000000
l?7l0?3ao00>0?3ao0030?ooo`00?7@0inKY00<0h=oS00<0fMGE000lM03o
ool03@3`lO`00`000000l?7l0?3ao0050?3ao0<000000P3`lO`010000000
l?7l0000000000030?3ao0<000000`3`lO`300000080l?7l00<000000?3a
o03`lO`0303`lO`01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000
101VIWh0nocm0:RY^`1VIWiO0>3Oh`030=WEe@00?7@0oooo00h0m?Gm00D0
00000?Ceo@3dmOd0m?Gm000000020?Ceo@050000003dmOd0m?Gm0?Ceo@00
00003`3dmOd00`3oool003ad0>OVj@030>3Oh`030=WEe@00?7@0oooo00h0
m?Gm00D000000?Ceo@3dmOd0m?Gm0000000I0?Ceo@030000003dmOd0m?Gm
00`0m?Gm00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn
0?_lo@2XZK/0IVInG`3Pgn<00`3IeMD003ad0?ooo`0?0?Kgo@<000000`3f
mod00`000000m_Om0?Kgo@020?Kgo@030000003fmod0m_Om00`0m_Om00<0
oooo000lM03Wi^T00`3Pgn<00`3IeMD003ad0?ooo`0?0?Kgo@<000006P3f
mod00`000000m_Om0?Kgo@0<0?Kgo@060?ooo`00?7@0inKY06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOUl0h=oS00<0fMGE000lM03o
ool0:@3ho?d00`3oool003ad0>OVj@030>3Oh`030=WEe@00?7@0oooo03/0
n?cm00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVInG`3Pgn<00`3IeMD003ad0?ooo`0Y0?gmo@030?ooo`00?7@0
inKY00<0h=oS00<0fMGE000lM03oool0>`3moOd01P3oool003ad0>OVj@1V
IWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiO0>3Oh`030=WE
e@00?7@0oooo02T0oOgm00<0oooo000lM03Vi^T00`3Pgn<00`3IeMD003ad
0?ooo`0k0?gmo@060?ooo`00?7@0i^KY06IVOP2XZK/0nocm0@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOUl0h=oS00<0f=CD000lM03oool0:@3moOd00`3o
ool003ad0>GUj0030>3Oh`030=SDe000?7@0oooo03/0oOgm00H0oooo000l
M03UiNP0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInG`3P
gn<00`3IeMD09EN50;o>g00Y0?ooo`030;o>f`0UEhD0hN7T00<0h=oS00<0
fMGE02EGQ@2oc]`0>`3oool01P2oc]/09EN50>7Qi01VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWiO0>3Oh`040=WEe@1iU:T0EGfR0<3?
gBL0oooo00@0eMoX05EmXP1iUJ/0gmgP0`3Pgn<0103IeMD0NIBY05EmXP30
cmdi0?ooo`070=GOj01EOJ80NIF[0=oMh01VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInG`3Pgn<0103JemT0gmcH07VDZ@0UEhDW000l
M00401M=OP1VQZ40h=kJ0=cKg@<0h=oS00@0f]OI0=oLf01iU:T09EN5>@00
?7@01`0GCGh0IXJQ0>3NfP3Lfmd0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOUl0h=oS00<0gmgP0=[Gf@3He=@05@3Gdm@@0=?>c0<0
em?D00@0f=CD0=WEe@3JemT0gmgP0`3Pgn<00`3OgN00f]OI0=SDe00N0=OC
e1T0dlk<0`3Gdm@01`3He=@0fMGE0=[Gf@3OgN00IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP000000d@3oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0000003A0?ooo`0306IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh000000=40oooo00<0
IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000d@3o
ool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P00
00000`3oool00000000000040?ooo`<000000P3oool700000080oooo1000
000:0?ooo`<00000103oool300000080oooo0`000000103oool000000000
000000030?ooo`<000000`3oool4000000050?ooo`00000000000000003o
ool00`0000030?ooo`<00000O`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn0`0000020?ooo`040000003oool0oooo0000
00<0oooo00P000000?ooo`3oool000000?ooo`000000oooo00000080oooo
00<000000?ooo`3oool02`3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`000000
1P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3o
ool0oooo0000001n0?ooo`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0000000@0oooo00@000000?ooo`3oool000000`3oool0
20000000oooo0?ooo`000000oooo0000003oool000000P3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0800oooo00<0
IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000103o
ool010000000oooo0?ooo`0000030?ooo`080000003oool0oooo0000003o
ool000000?ooo`0000020?ooo`D000002@3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`3oool00`3oool500000080oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0800
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP00
0000oooo0`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo
000000090?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo0P0000020?ooo`050000003oool0oooo
0?ooo`0000001@3oool01@000000oooo0?ooo`3oool000000080oooo0P00
00020?ooo`050000003oool0oooo0?ooo`000000PP3oool00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P0000070?ooo`<00000
0P3oool3000000030?ooo`000000oooo00<0oooo0`00000;0?ooo`@00000
0`3oool300000080oooo0P0000000`3oool00000000000030?ooo`D00000
0`3oool300000080oooo0P0000000`3oool00000000000030?ooo`D00000
O`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
0P0000020?ooo`800000=03oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo0800oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3k
o?d0Z:Vk06IVOP000000oooo0P0000000`3oool000000?ooo`3;0?ooo`03
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh000000=40
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP00
0000d@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn0000003A0?ooo`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh000000=40oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP000000d@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00<0IVIn0?Ogn@2HV:L0e01gMi8109RHY`40moOi0@1VIWh0000306IVOP3g
moT0_;g=0=D0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3Thn<0e@3Thn<1
0?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`2>0?ooo`030>CSh`2LY;T0JgF?
00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3o
ool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0
i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0YcY42@2V
>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F06IVOP3RhN80
nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m0?clo03l
no`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080o?cl00@0o?cm
0?clo03knod0o?cm=03lno`c0?_lo0h0nocm00<0W:Bi06]eS`25RK004025
RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3k
o?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?clo03lnod0nocm
0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi
0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0
moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0c0?OgnC<0m_Oi
3P3gmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[
MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ
3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@01
06IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@000000060?7am03`
l_D0lO7d0?7bm03`l_@0lO7dI`3`lOD>0?3am00306]eS`2b]M00YjS20100
YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0
l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32
DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3L
fn00j^_`0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0
inOW0>OWi`030>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Z
jnl0j^_`0>[[l00b0>[[l3<0j^c`3P3Zjnl0101[MHl0][WA0:f^aP2][/H8
0?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0
101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Z
jo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0
cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3S
iNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<0
0>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX0
0P3Si>X00`3Si>/0hnG[0>?Uj`0b0>?Ujc<0hnCZ3P3SiNX01@1[MHl0_;kD
0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0
JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH02@0U9CH3
0;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?oo
o`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ
0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0g=kV00D00000
0>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW0>ONaP3_S100
0`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H0M@3Lg^D01@1[
MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh0
1P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh0
1`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V
>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`0505<U803DGF40
dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn
0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0ikF40=IJ003F
Q000olh00<iS00020=i[00050>neS03_knl0kno_0>o_k`0000000P3Ef>40
103Een00e]SP0=KHh@3Fen4d0=KGh3<0e]SP3P3Ef>401@1[MHl0`lGI0;bm
d@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5
f@80_;gA00<0oooo02DU=P2l_M401`2l_M400`3oool09BDf0;bmd@020;bm
d@050<?5f@1[MHl0e]OP0=GGh@2V>D@00P3EGF000`3HH640fF5R04HN6P03
0?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00
eMSQ0=GGh03Ef>40eMKM0@1VIWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0
d=;L000000030>OWi`0<0>ONcP36BP00mlh00>n]003_]@00cV/00<IJ0036
J`00gXa:0>NU003_ilh000000`3@d]`00`3?d]`0d=;L0<oBg00d0=3Bg3<0
cm;M3P3@d]`00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3B
g01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP030?ooo`0U9CH0
`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU
00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aU
I@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn
0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH0>nm003gaP00
kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl000000<_=f03;
cMT0b/gI0<_>f03:cMP0blgH=03;cMTc0<_>f@h0blgH00<0JgF?0<_<gP38
b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38b]T0blcN06]e
S`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38
b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:Hi
A03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?ooo`030?ooo`0:
04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI
0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P000000a/K60>ON
eP3>N`00ijd00>ne0080ijD000<0eY@00<ic003FU0000P3gaP020?Ogm`04
00000035b=@0aLOD0<G7e0<0aLOE=034amDc0<C8e0h0a<OD00<0JgF?0=3A
h03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3Ah080bl_L00<0
oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;g0070=3Ah01[
MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3oool0oooo0?oo
o`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040aLOE0@3?cmX1
06IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000inOW0>OWi`3W
inL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm003_knl0moOg
000000<0`LCB00<0`/CA0<74dP31a=80=031a=4c0<74dPh0`/CB00<0JgF?
0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M
00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@020<o@g@070=?C
hP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203Q
JFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:
c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<00020=jD0004
0=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>BP000000_/3>0;k0c`2n
`<h0_/3?0;g0cSD0_/3><`2m`<h>0;k0cP0306]eS`3Fe^@0dm?P0100dm?P
00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo
00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0
h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo103SK6`0103Q
JVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:
f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<003NU000eX@0
0>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3oool000000;Vlc02j^l`0
^Kc;0;Zlb`2i_<`0^Kc;03@0^Kc<<`2j_<`>0;Zlb`0306]eS`3Hf>D0dm?Q
0100dm?Q00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^
KHl0KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zl
c02V>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX0
0`3oool20>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0
bL[H0040IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B4
0>OWgP020>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Og
m`050000002f^LT0]kS90;Jib@2g^LT00P2f^<Td0;NhbC<0][S93P2g^<T0
101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0
e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U
9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>Ma
K`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_
0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG0@1VIWh00003
06IVOP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_knl02`3W[@00
mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool0000007/0];K7
00D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bf
a`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS
06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3oool00`167QX0
jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V
>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0];K700H00000
08b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_
imH0moOg0?ooo`00001k0;Bfa`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS
06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V
>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZK
S03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40
a/SG0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H000000>o_k`3_knl0
kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg00<0oooo0000
002a/lP0NP2a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?8
0;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`
Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fd
V`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn
00000`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_0?Ogm`3_knl0
1P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L0N@2_[/L00`1[MHl0d]7S
0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3B
dN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V
>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0`<7A0<O7e02>
0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR
0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<
XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0
n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03oWhd0YSU4096H
ZP<0[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;Bg`2e]<V>0:BS
_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24
S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:Hi
A02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1V
IWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34cP2XYkl01@2a/<@0_;c?
0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@
h03:b]X0c02l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000
201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[bP3Gf>801`3Qh^/0
k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX00<0IVIn09FD
Z`3AdMh00P3lo?c<0?ooo`80o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0
F5MX0P1VIWh00`28Qid0UIB[0:RW_`3;0:RW_`0409FDZ`28Qid0IVIn06IV
OP<0F5MX000505QGJ=00IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[31]:=",
  Evaluatable->False,
  ImageSize->{218, 128},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"WidgetFill"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[31]=",
  CellTags->"WidgetFill"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["WidgetSpace", "Subsection",
  CellTags->"WidgetSpace"],

Cell[TextData[{
  StyleBox["WidgetSpace", "Program"],
  StyleBox["[", "Output"],
  StyleBox["n",
    FontSlant->"Italic"],
  StyleBox["]", "Output"],
  " elements can be useful as simple spacers that create an explicit spacing \
element between widgets along the layout direction they are placed."
}], "Text",
  CellTags->"WidgetSpace"],

Cell["Here we add a little explicit spacing between the buttons.", "Text",
  CellTags->"WidgetSpace"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
{\[IndentingNewLine]Widget["\<TextArea\>", {"\<text\>"\  \[Rule] \ "\<Some \
content\>", \ "\<rows\>" \[Rule] 4, \ "\<columns\>" \[Rule] 
                    30}], \[IndentingNewLine]{\[IndentingNewLine]WidgetFill[],\
 \[IndentingNewLine]Widget["\<Button\>", {"\<text\>" \[Rule] "\<OK\>"}], \
\[IndentingNewLine]WidgetSpace[
                  10], \[IndentingNewLine]Widget["\<Button\>", {"\<text\>" \
\[Rule] "\<Cancel\>"}]\[IndentingNewLine]}\[IndentingNewLine]}]\ \
\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[32]:=",
  CellTags->"WidgetSpace"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[33]:=",
  CellTags->"WidgetSpace"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003J0000P2000`400?l0
0000o`00003ofP1VIWh0000306IVOP3ko?d0nocm0=H0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0=D0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
e01VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOUP0h=oS
00D0hN3T0>KUj03/jnh0l?3b0?;bm00C0??cm100n?Oh0P3clo@01@3cloD0
m?Ce0?GemP3dloD0iNCX00X0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;bm00L
0??cm1T0n?Oh0P3clo@0203cloD0m?Ce0?GemP3dloD0iNCX06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOUP0h=oS00@0g]cO0>CRh01k
Ujd09EN59`00?7@0100GCGh0Jh^V0?;akP3blO<:0>3Oh`040=kLg`3Th^00
NiN]02EGQCT003ad00L05den06^;YP3blNh0l_7c06IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWiH0>3Oh`040=[Hf@1VQJ40BW6C0;:m
`bL0a/GG00@0`<K504Q^T01ZRZ@0knoa2P3Pgn<0103Jf=T0IXFQ04YaT`2b
_L<i0<K5e`070<36a@18KY00JXZT0>o_l@1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInF03Pgn<00`3HeMH05den0;o7bP0Y0<K5e`03
0;Jm_@0GCGh0jn[]00X0h=oS00<0f=GF01M=OP2oalX0>`36aML01P2f_Kd0
5den0>_Zk@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiH
0>3Oh`030=WEe@00?7@0oooo02T0cLcO00<0oooo000lM03XinX02P3Pgn<0
0`3IeMD003ad0?ooo`0k0<g<g`060?ooo`00?7@0j>OZ06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOUP0h=oS00<0fMGE000lM03oool0
:@3BdN@00`3oool003ad0>OVj@0:0>3Oh`030=WEe@00?7@0oooo03/0d]7T
00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2X
ZK/0IVInF03Pgn<00`3IeMD003ad0?ooo`0Y0=KGi`030?ooo`00?7@0inKY
00X0h=oS00<0fMGE000lM03oool0>`3FenL01P3oool003ad0>OVj@1VIWh0
Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiH0>3Oh`030=WEe@00
?7@0oooo00l0fM[W0`0000030=WJi`030000003If^L0fM[W0080fM[W00<0
00000=WJi`3If^L0303If^L00`3oool003ad0>OVj@0:0>3Oh`030=WEe@00
?7@0oooo00l0fM[W0`0000030=WJi`80000000@0fM[W0000003If^L00000
0`3If^L00`000000fM[W0=WJi`03000000<0fM[W0`0000020=WJi`030000
003If^L0fM[W00`0fM[W00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVInF03Pgn<00`3IeMD003ad0?ooo`0>0=WJ
i`050000003If^L0fM[W0=WJi`0000000P3If^L01@000000fM[W0=WJi`3I
f^L0000000l0fM[W00<0oooo000lM03Wi^T02P3Pgn<00`3IeMD003ad0?oo
o`0>0=WJi`070000003If^L0fM[W0=WJi`000000fM[W000000020=WJi`80
000000<0fM[W0000003If^L00P3If^L00`000000fM[W000000030=WJi`03
0000003If^L0000000<0fM[W00<000000=WJi`0000003P3If^L01P3oool0
03ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiH
0>3Oh`030=WEe@00?7@0oooo00d0g]o/00<000000=kOk03Ngn`00`3Ngn`0
0`000000g]o/000000030=kOk0030000003Ngn`0g]o/00d0g]o/00<0oooo
000lM03Wi^T02P3Pgn<00`3IeMD003ad0?ooo`0=0=kOk0030000003Ngn`0
g]o/00@0g]o/00L000000=kOk03Ngn`0g]o/0000003Ngn`0000000<0g]o/
00<000000=kOk00000001@3Ngn`00`000000g]o/0=kOk0030=kOk0030000
003Ngn`0g]o/00`0g]o/00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVInF03Pgn<00`3IeMD003ad0?ooo`0=0>?U
l0030000003SiO00hnG`00<0hnG`00H000000>?Ul000000000000>?Ul000
000@0>?Ul0030?ooo`00?7@0inKY00X0h=oS00<0fMGE000lM03oool03@3S
iO000`000000hnG`0>?Ul0050>?Ul0@0000000<0hnG`0000003SiO000P3S
iO000`000000hnG`000000050>?Ul0D0000000<0hnG`0000003SiO003@3S
iO001P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm
0:RY^`1VIWiH0>3Oh`030=WEe@00?7@0oooo00d0jN_e00<000000>W[m@3Y
joD00`3YjoD010000000jN_e0000003YjoD200000100jN_e00<0oooo000l
M03Wi^T02P3Pgn<00`3IeMD003ad0?ooo`0=0>W[m@030000003YjoD0jN_e
00@0jN_e00H000000>W[m@3YjoD0jN_e0000003YjoD200000080jN_e00<0
00000>W[m@0000000`3YjoD00`000000jN_e000000030>W[m@030000003Y
joD0000000h0jN_e00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVInF03Pgn<00`3IeMD003ad0?ooo`0=0?3ao003
0000003`lO`0l?7l00<0l?7l00<000000?3ao00000000P3`lO`00`000000
l?7l0?3ao00>0?3ao0030?ooo`00?7@0inKY00X0h=oS00<0fMGE000lM03o
ool03@3`lO`00`000000l?7l0?3ao0050?3ao0<000000P3`lO`010000000
l?7l0000000000030?3ao0<000000`3`lO`300000080l?7l00<000000?3a
o03`lO`0303`lO`01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000
101VIWh0nocm0:RY^`1VIWiH0>3Oh`030=WEe@00?7@0oooo00h0m?Gm00D0
00000?Ceo@3dmOd0m?Gm000000020?Ceo@050000003dmOd0m?Gm0?Ceo@00
00003`3dmOd00`3oool003ad0>OVj@0:0>3Oh`030=WEe@00?7@0oooo00h0
m?Gm00D000000?Ceo@3dmOd0m?Gm0000000I0?Ceo@030000003dmOd0m?Gm
00`0m?Gm00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn
0?_lo@2XZK/0IVInF03Pgn<00`3IeMD003ad0?ooo`0?0?Kgo@<000000`3f
mod00`000000m_Om0?Kgo@020?Kgo@030000003fmod0m_Om00`0m_Om00<0
oooo000lM03Wi^T02P3Pgn<00`3IeMD003ad0?ooo`0?0?Kgo@<000006P3f
mod00`000000m_Om0?Kgo@0<0?Kgo@060?ooo`00?7@0inKY06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOUP0h=oS00<0fMGE000lM03o
ool0:@3ho?d00`3oool003ad0>OVj@0:0>3Oh`030=WEe@00?7@0oooo03/0
n?cm00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVInF03Pgn<00`3IeMD003ad0?ooo`0Y0?gmo@030?ooo`00?7@0
inKY00X0h=oS00<0fMGE000lM03oool0>`3moOd01P3oool003ad0>OVj@1V
IWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiH0>3Oh`030=WE
e@00?7@0oooo02T0oOgm00<0oooo000lM03Vi^T02P3Pgn<00`3IeMD003ad
0?ooo`0k0?gmo@060?ooo`00?7@0i^KY06IVOP2XZK/0nocm0@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOUP0h=oS00<0f=CD000lM03oool0:@3moOd00`3o
ool003ad0>GUj00:0>3Oh`030=SDe000?7@0oooo03/0oOgm00H0oooo000l
M03UiNP0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInF03P
gn<00`3IeMD09EN50;o>g00Y0?ooo`030;o>f`0UEhD0hN7T00X0h=oS00<0
fMGE02EGQ@2oc]`0>`3oool01P2oc]/09EN50>7Qi01VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWiH0>3Oh`040=WEe@1iU:T0EGfR0<3?
gBL0oooo00@0eMoX05EmXP1iUJ/0gmgP2P3Pgn<0103IeMD0NIBY05EmXP30
cmdi0?ooo`070=GOj01EOJ80NIF[0=oMh01VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInF03Pgn<0103JemT0gmcH07VDZ@0UEhDW000l
M00401M=OP1VQZ40h=kJ0=cKg@X0h=oS00@0f]OI0=oLf01iU:T09EN5>@00
?7@01`0GCGh0IXJQ0>3NfP3Lfmd0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOUP0h=oS00<0gmgP0=[Gf@3He=@05@3Gdm@@0=?>c0<0
em?D00@0f=CD0=WEe@3JemT0gmgP2P3Pgn<00`3OgN00f]OI0=SDe00N0=OC
e1T0dlk<0`3Gdm@01`3He=@0fMGE0=[Gf@3OgN00IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP000000d@3oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0000003A0?ooo`0306IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh000000=40oooo00<0
IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000d@3o
ool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P00
00000`3oool00000000000040?ooo`<000000P3oool700000080oooo1000
000:0?ooo`<00000103oool300000080oooo0`000000103oool000000000
000000030?ooo`<000000`3oool4000000050?ooo`00000000000000003o
ool00`0000030?ooo`<00000O`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn0`0000020?ooo`040000003oool0oooo0000
00<0oooo00P000000?ooo`3oool000000?ooo`000000oooo00000080oooo
00<000000?ooo`3oool02`3oool01@000000oooo0?ooo`3oool000000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000000`3oool01`000000oooo0?ooo`3oool000000?ooo`000000
1P3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3o
ool0oooo0000001n0?ooo`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0000000@0oooo00@000000?ooo`3oool000000`3oool0
20000000oooo0?ooo`000000oooo0000003oool000000P3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000000`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0800oooo00<0
IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000103o
ool010000000oooo0?ooo`0000030?ooo`080000003oool0oooo0000003o
ool000000?ooo`0000020?ooo`D000002@3oool00`000000oooo0?ooo`04
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`3oool00`3oool500000080oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0800
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP00
0000oooo0`0000030?ooo`050000003oool0oooo0?ooo`0000000P3oool0
1@000000oooo0000003oool000000080oooo00D000000?ooo`3oool0oooo
000000090?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool000000080oooo0P0000020?ooo`050000003oool0oooo
0?ooo`0000001@3oool01@000000oooo0?ooo`3oool000000080oooo0P00
00020?ooo`050000003oool0oooo0?ooo`000000PP3oool00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P0000070?ooo`<00000
0P3oool3000000030?ooo`000000oooo00<0oooo0`00000;0?ooo`@00000
0`3oool300000080oooo0P0000000`3oool00000000000030?ooo`D00000
0`3oool300000080oooo0P0000000`3oool00000000000030?ooo`D00000
O`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
0P0000020?ooo`800000=03oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo0800oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3k
o?d0Z:Vk06IVOP000000oooo0P0000000`3oool000000?ooo`3;0?ooo`03
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh000000=40
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP00
0000d@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn0000003A0?ooo`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh000000=40oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP000000d@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00<0IVIn0?Ogn@2HV:L0e01gMi8109RHY`40moOi0@1VIWh0000306IVOP3g
moT0_;g=0=D0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3Thn<0e@3Thn<1
0?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`2>0?ooo`030>CSh`2LY;T0JgF?
00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3o
ool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0
i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0YcY42@2V
>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F06IVOP3RhN80
nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m0?clo03l
no`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080o?cl00@0o?cm
0?clo03knod0o?cm=03lno`c0?_lo0h0nocm00<0W:Bi06]eS`25RK004025
RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3k
o?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?clo03lnod0nocm
0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi
0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0
moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0c0?OgnC<0m_Oi
3P3gmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[
MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ
3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@01
06IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@000000060?7am03`
l_D0lO7d0?7bm03`l_@0lO7dI`3`lOD>0?3am00306]eS`2b]M00YjS20100
YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0
l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32
DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3L
fn00j^_`0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0
inOW0>OWi`030>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Z
jnl0j^_`0>[[l00b0>[[l3<0j^c`3P3Zjnl0101[MHl0][WA0:f^aP2][/H8
0?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0
101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Z
jo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0
cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3S
iNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<0
0>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX0
0P3Si>X00`3Si>/0hnG[0>?Uj`0b0>?Ujc<0hnCZ3P3SiNX01@1[MHl0_;kD
0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0
JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH02@0U9CH3
0;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?oo
o`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ
0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0g=kV00D00000
0>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW0>ONaP3_S100
0`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H0M@3Lg^D01@1[
MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh0
1P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh0
1`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V
>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`0505<U803DGF40
dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn
0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0ikF40=IJ003F
Q000olh00<iS00020=i[00050>neS03_knl0kno_0>o_k`0000000P3Ef>40
103Een00e]SP0=KHh@3Fen4d0=KGh3<0e]SP3P3Ef>401@1[MHl0`lGI0;bm
d@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5
f@80_;gA00<0oooo02DU=P2l_M401`2l_M400`3oool09BDf0;bmd@020;bm
d@050<?5f@1[MHl0e]OP0=GGh@2V>D@00P3EGF000`3HH640fF5R04HN6P03
0?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00
eMSQ0=GGh03Ef>40eMKM0@1VIWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0
d=;L000000030>OWi`0<0>ONcP36BP00mlh00>n]003_]@00cV/00<IJ0036
J`00gXa:0>NU003_ilh000000`3@d]`00`3?d]`0d=;L0<oBg00d0=3Bg3<0
cm;M3P3@d]`00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3B
g01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP030?ooo`0U9CH0
`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU
00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aU
I@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn
0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH0>nm003gaP00
kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl000000<_=f03;
cMT0b/gI0<_>f03:cMP0blgH=03;cMTc0<_>f@h0blgH00<0JgF?0<_<gP38
b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38b]T0blcN06]e
S`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38
b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:Hi
A03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?ooo`030?ooo`0:
04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI
0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P000000a/K60>ON
eP3>N`00ijd00>ne0080ijD000<0eY@00<ic003FU0000P3gaP020?Ogm`04
00000035b=@0aLOD0<G7e0<0aLOE=034amDc0<C8e0h0a<OD00<0JgF?0=3A
h03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3Ah080bl_L00<0
oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;g0070=3Ah01[
MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3oool0oooo0?oo
o`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040aLOE0@3?cmX1
06IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000inOW0>OWi`3W
inL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm003_knl0moOg
000000<0`LCB00<0`/CA0<74dP31a=80=031a=4c0<74dPh0`/CB00<0JgF?
0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M
00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@020<o@g@070=?C
hP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203Q
JFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:
c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<00020=jD0004
0=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>BP000000_/3>0;k0c`2n
`<h0_/3?0;g0cSD0_/3><`2m`<h>0;k0cP0306]eS`3Fe^@0dm?P0100dm?P
00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo
00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0
h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo103SK6`0103Q
JVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:
f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<003NU000eX@0
0>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3oool000000;Vlc02j^l`0
^Kc;0;Zlb`2i_<`0^Kc;03@0^Kc<<`2j_<`>0;Zlb`0306]eS`3Hf>D0dm?Q
0100dm?Q00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^
KHl0KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zl
c02V>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX0
0`3oool20>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0
bL[H0040IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B4
0>OWgP020>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Og
m`050000002f^LT0]kS90;Jib@2g^LT00P2f^<Td0;NhbC<0][S93P2g^<T0
101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0
e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U
9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>Ma
K`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_
0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG0@1VIWh00003
06IVOP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_knl02`3W[@00
mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool0000007/0];K7
00D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bf
a`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS
06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3oool00`167QX0
jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V
>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0];K700H00000
08b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_
imH0moOg0?ooo`00001k0;Bfa`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS
06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V
>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZK
S03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40
a/SG0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H000000>o_k`3_knl0
kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg00<0oooo0000
002a/lP0NP2a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?8
0;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`
Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fd
V`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn
00000`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_0?Ogm`3_knl0
1P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L0N@2_[/L00`1[MHl0d]7S
0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3B
dN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V
>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0`<7A0<O7e02>
0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR
0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<
XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0
n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03oWhd0YSU4096H
ZP<0[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;Bg`2e]<V>0:BS
_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24
S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:Hi
A02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1V
IWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34cP2XYkl01@2a/<@0_;c?
0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@
h03:b]X0c02l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000
201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[bP3Gf>801`3Qh^/0
k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX00<0IVIn09FD
Z`3AdMh00P3lo?c<0?ooo`80o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0
F5MX0P1VIWh00`28Qid0UIB[0:RW_`3;0:RW_`0409FDZ`28Qid0IVIn06IV
OP<0F5MX000505QGJ=00IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[33]:=",
  Evaluatable->False,
  ImageSize->{218, 128},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"WidgetSpace"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[33]=",
  CellTags->"WidgetSpace"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["WidgetAlign", "Subsection",
  CellTags->"WidgetAlign"],

Cell[TextData[{
  StyleBox["WidgetAlign[]", "Output"],
  " elements work as placeholder elements within groups of widget lists, and, \
for each one that exists within sibling lists, they will attempt to align \
themselves with other ",
  StyleBox["WidgetAlign[]s", "Output"],
  " forcing a certain grid structure to exist without forcing the same number \
of widgets to exist between each align markers. They function somewhat \
analogous to tab markers in word processing documents."
}], "Text",
  CellTags->"WidgetAlign"],

Cell[TextData[{
  "Another more advanced form of ",
  StyleBox["WidgetAlign", "Output"],
  " is ",
  StyleBox["WidgetAlign[{", "Output"],
  "\"",
  StyleBox["widgetName",
    FontSlant->"Italic"],
  "\", ",
  StyleBox["After | Before", "Output"],
  "}, ",
  StyleBox["Before | After]", "Output"],
  ", which specifies that the very next widget following the ",
  StyleBox["WidgetAlign", "Output"],
  " should align its beginning or end (",
  StyleBox["Before", "Output"],
  " or ",
  StyleBox["After", "Output"],
  ") with another widget named \"",
  StyleBox["widgetName",
    FontSlant->"Italic"],
  "\" along either its beginning or end. This form has somewhat limited use \
and requires properly named widget dependencies in an appropriate location to \
work well."
}], "Text",
  CellTags->"WidgetAlign"],

Cell[TextData[{
  "Here we place ",
  StyleBox["WidgetAlign[]", "Output"],
  " marker elements where we would like sibling widget lists to align."
}], "Text",
  CellTags->"WidgetAlign"],

Cell[BoxData[
    \(\(Needs["\<GUIKit`\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"WidgetAlign"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
{\[IndentingNewLine]{Widget["\<TextField\>", {"\<text\>" -> "\<A1\>"}], \ \
\[IndentingNewLine]WidgetAlign[], \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<A2\>"}], \ \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<A3\>"}], \ \[IndentingNewLine]WidgetAlign[], \
\[IndentingNewLine]Widget["\<TextField\>", {"\<text\>" -> "\<A4\>"}]\
\[IndentingNewLine]}, \[IndentingNewLine]{Widget["\<TextField\>", {"\<text\>" \
-> "\<B1\>"}], \[IndentingNewLine]Widget["\<TextField\>", {"\<text\>" -> \
"\<B2\>"}], \[IndentingNewLine]WidgetAlign[], \
\[IndentingNewLine]Widget["\<TextField\>", {"\<text\>" -> "\<B3\>"}], \
\[IndentingNewLine]WidgetAlign[], \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<B4\>"}], \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<B5\>"}]\[IndentingNewLine]}\ \[IndentingNewLine]}]\
\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"WidgetAlign"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"WidgetAlign"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002Y0000CB000`400?l0
0000o`00003oZ@1VIWh0000306IVOP3ko?d0nocm0:D0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0:@0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
X`1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQP0YJbb
0`3Pgn<H0:F//P<0h=oS=@2U[;830>3OhaP0YJbb0`3Pgn<H0:F//P0306IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb01H0oooo
00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P0F0?ooo`050:F//P3Pgn<0h=oS0>3O
h`2U[;80<`3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb01H0oooo00D0YJbb
0>3Oh`3Pgn<0h=oS0:F//P0F0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0YJbb01H0oooo00D0YJbb0>3Oh`3Pgn<0
h=oS0:F//P0F0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;80<`3oool01@2U
[;80h=oS0>3Oh`3Pgn<0YJbb01H0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F/
/P0F0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0YJbb01H0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P0F0?ooo`05
0:F//P3Pgn<0h=oS0>3Oh`2U[;80<`3oool01@2U[;80h=oS0>3Oh`3Pgn<0
YJbb01H0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P0F0?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb01H0oooo
00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P0F0?ooo`050:F//P3Pgn<0h=oS0>3O
h`2U[;80<`3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb01H0oooo00D0YJbb
0>3Oh`3Pgn<0h=oS0:F//P0F0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0YJbb01H0oooo00D0YJbb0>3Oh`3Pgn<0
h=oS0:F//P0F0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;80<`3oool01@2U
[;80h=oS0>3Oh`3Pgn<0YJbb01H0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F/
/P0F0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0YJbb00D0oooo1@0000040?ooo`030000003oool0oooo00D0oooo
00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P050?ooo`D000000P3oool5000000D0
oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P050?ooo`D000000`3oool30000
02<0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P050?ooo`D000001@3oool0
0`000000oooo0?ooo`040?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;801@3o
ool5000000<0oooo0`0000060?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0YJbb00D0oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0?ooo`3oool0000000L0oooo00D0YJbb0>3Oh`3P
gn<0h=oS0:F//P050?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool00000203oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb00D0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo000000030?ooo`030000003o
ool0oooo0200oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P050?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`040?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;801@3oool00`000000
oooo0?ooo`020?ooo`030000003oool0000000<0oooo00<000000?ooo`3o
ool00`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0:F//P050?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000070?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;801@3o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
1`3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb00D0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0200
oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P050?ooo`030000003oool0oooo
0080oooo00<000000?ooo`000000100000050?ooo`050:F//P3Pgn<0h=oS
0>3Oh`2U[;801@3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00`3oool0102U[;80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P050?ooo`030000003o
ool0oooo0080oooo00D000000?ooo`3oool0oooo000000070?ooo`050:F/
/P3Pgn<0h=oS0>3Oh`2U[;801@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool0103oool01@2U[;80
h=oS0>3Oh`3Pgn<0YJbb00D0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo0200oooo00D0YJbb0>3O
h`3Pgn<0h=oS0:F//P050?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`050:F//P3Pgn<0
h=oS0>3Oh`2U[;801@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00`3oool0102U[;80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P050?ooo`D00000
103oool00`000000oooo0?ooo`050?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U
[;801@3oool5000000H0oooo00<000000?ooo`3oool00`3oool01@2U[;80
h=oS0>3Oh`3Pgn<0YJbb00D0oooo1@0000040?ooo`8000008`3oool01@2U
[;80h=oS0>3Oh`3Pgn<0YJbb00D0oooo1@0000030?ooo`030000003oool0
000000H0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P050?ooo`D000000P3o
ool4000000H0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP2U[;801@3oool00`000000oooo0?ooo`020?ooo`050000
003oool000000?ooo`0000001`3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb
00D0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00<0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P05
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0P0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;801@3o
ool00`000000oooo0?ooo`020?ooo`060000003oool0oooo0000003oool0
00001P3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb00D0oooo00<000000?oo
o`3oool00P3oool00`000000oooo000000090?ooo`040:F//P1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb00D0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`02000000L0oooo00D0YJbb
0>3Oh`3Pgn<0h=oS0:F//P050?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`050:F//P3P
gn<0h=oS0>3Oh`2U[;801@3oool00`000000oooo0?ooo`020?ooo`030000
003oool0000000<0oooo00<000000?ooo`3oool0803oool01@2U[;80h=oS
0>3Oh`3Pgn<0YJbb00D0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`3oool2000000H0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P05
0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3oool00000203o
ool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
0:F//P050?ooo`D00000103oool00`000000oooo0?ooo`050?ooo`050:F/
/P3Pgn<0h=oS0>3Oh`2U[;801@3oool5000000<0oooo0`0000060?ooo`05
0:F//P3Pgn<0h=oS0>3Oh`2U[;801@3oool5000000<0oooo0`00000S0?oo
o`050:F//P3Pgn<0h=oS0>3Oh`2U[;801@3oool5000000D0oooo00<00000
0?ooo`3oool0103oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb00D0oooo1@00
00030?ooo`@000001@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0:F//P0F0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U
[;805P3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb03<0oooo00D0YJbb0>3O
h`3Pgn<0h=oS0:F//P0F0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;805P3o
ool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
0:F//P0F0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;805P3oool01@2U[;80
h=oS0>3Oh`3Pgn<0YJbb03<0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P0F
0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;805P3oool0102U[;80IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P0F0?ooo`050:F/
/P3Pgn<0h=oS0>3Oh`2U[;805P3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb
03<0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P0F0?ooo`050:F//P3Pgn<0
h=oS0>3Oh`2U[;805P3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0:F//P0F0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U
[;805P3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb03<0oooo00D0YJbb0>3O
h`3Pgn<0h=oS0:F//P0F0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;805P3o
ool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
0:F//P0F0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;805P3oool01@2U[;80
h=oS0>3Oh`3Pgn<0YJbb03<0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P0F
0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;805P3oool0102U[;80IVIn0:RY
^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn602U[;830>3OhaP0YJbb
0`3Pgn<e0:F//P<0h=oS602U[;830>3OhaP0YJbb00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOZ40h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOZ40h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOZ40h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS<0YJbb0`3Pgn<I0:F//P<0h=oS
6@2U[;830>3Ohc<0YJbb00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP2U[;80<@3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb01L0
oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P0G0?ooo`050:F//P3Pgn<0h=oS
0>3Oh`2U[;80<@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn0:F//P0a0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;80
5`3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb01L0oooo00D0YJbb0>3Oh`3P
gn<0h=oS0:F//P0a0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0YJbb00D0oooo00<000000?ooo`3oool0:@3oool0
1@2U[;80h=oS0>3Oh`3Pgn<0YJbb01L0oooo00D0YJbb0>3Oh`3Pgn<0h=oS
0:F//P0G0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;80<@3oool0102U[;80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P050?oo
o`030000003oool0oooo02T0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P0G
0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;805`3oool01@2U[;80h=oS0>3O
h`3Pgn<0YJbb0340oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP2U[;801@3oool00`000000oooo0?ooo`0Y0?ooo`05
0:F//P3Pgn<0h=oS0>3Oh`2U[;805`3oool01@2U[;80h=oS0>3Oh`3Pgn<0
YJbb01L0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P0a0?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb00D0oooo
00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool000000240
oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P050?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`000000100000050?ooo`050:F//P3Pgn<0h=oS
0>3Oh`2U[;801@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<000001P3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb00D0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo01h0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP2U[;801@3oool00`000000oooo0?ooo`030?ooo`050000
003oool0oooo0?ooo`0000008@3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb
00D0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`000008
0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;801@3oool00`000000oooo0?oo
o`030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00`3o
ool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb00D0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo01h0oooo
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2U
[;801@3oool6000000@0oooo00<000000?ooo`3oool07`3oool01@2U[;80
h=oS0>3Oh`3Pgn<0YJbb00H0oooo1@0000040?ooo`030000003oool0oooo
00D0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P060?ooo`D000001P3oool0
0`000000oooo0?ooo`030?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;801P3o
ool500000080oooo1@00000O0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0YJbb00D0oooo0P0000030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool07`3oool01@2U[;80h=oS
0>3Oh`3Pgn<0YJbb00H0oooo00D000000?ooo`3oool0oooo000000050?oo
o`030000003oool0oooo00@0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P06
0?ooo`050000003oool0oooo0?ooo`0000001P3oool00`000000oooo0?oo
o`030?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;801P3oool01@000000oooo
0?ooo`3oool000000080oooo00@000000?ooo`3oool00000803oool0102U
[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P05
0?ooo`050000003oool000000?ooo`0000001@3oool00`000000oooo0?oo
o`0O0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;801`3oool00`000000oooo
000000070?ooo`030000003oool0oooo00<0oooo00D0YJbb0>3Oh`3Pgn<0
h=oS0:F//P070?ooo`030000003oool0000000D0oooo0P0000060?ooo`05
0:F//P3Pgn<0h=oS0>3Oh`2U[;801`3oool00`000000oooo000000040?oo
o`030000003oool000000200oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP2U[;801@3oool01@000000oooo0000003o
ool0000000<0oooo00<000000?ooo`0000008@3oool01@2U[;80h=oS0>3O
h`3Pgn<0YJbb00L0oooo00<000000?ooo`0000001`3oool00`000000oooo
0?ooo`030?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;801`3oool00`000000
oooo000000070?ooo`030000003oool0oooo00<0oooo00D0YJbb0>3Oh`3P
gn<0h=oS0:F//P070?ooo`030000003oool0000000@0oooo00<000000?oo
o`000000803oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn0:F//P050?ooo`050000003oool000000?ooo`000000103o
ool200000240oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P070?ooo`030000
003oool0000000<0oooo00D000000?ooo`3oool0oooo000000050?ooo`05
0:F//P3Pgn<0h=oS0>3Oh`2U[;801`3oool00`000000oooo000000030?oo
o`050000003oool0oooo0?ooo`0000001@3oool01@2U[;80h=oS0>3Oh`3P
gn<0YJbb00L0oooo00<000000?ooo`0000001@3oool200000200oooo00@0
YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;80
1@3oool010000000oooo0?ooo`0000060?ooo`030000003oool0oooo01l0
oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P080?ooo`030000003oool0oooo
00<0oooo0`0000060?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;80203oool0
0`000000oooo0?ooo`030?ooo`<000001P3oool01@2U[;80h=oS0>3Oh`3P
gn<0YJbb00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0N0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0YJbb00D0oooo00<000000?ooo`3oool0:@3oool01@2U[;80h=oS
0>3Oh`3Pgn<0YJbb01L0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P0G0?oo
o`050:F//P3Pgn<0h=oS0>3Oh`2U[;80<@3oool0102U[;80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P050?ooo`030000003o
ool0oooo02T0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P0G0?ooo`050:F/
/P3Pgn<0h=oS0>3Oh`2U[;805`3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb
0340oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP2U[;801@3oool00`000000oooo0?ooo`0Y0?ooo`050:F//P3Pgn<0
h=oS0>3Oh`2U[;805`3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb01L0oooo
00D0YJbb0>3Oh`3Pgn<0h=oS0:F//P0a0?ooo`040:F//P1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb00D0oooo00<000000?oo
o`3oool0:@3oool01@2U[;80h=oS0>3Oh`3Pgn<0YJbb01L0oooo00D0YJbb
0>3Oh`3Pgn<0h=oS0:F//P0G0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;80
<@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn0:F//P0a0?ooo`050:F//P3Pgn<0h=oS0>3Oh`2U[;805`3oool01@2U
[;80h=oS0>3Oh`3Pgn<0YJbb01L0oooo00D0YJbb0>3Oh`3Pgn<0h=oS0:F/
/P0a0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWhc0:F//P<0h=oS6@2U[;830>3OhaT0YJbb0`3Pgn<c0:F//P0306IV
OP2XZK/0nocm0040IVIn00000`1VIWh0moOi09RHY`2S07MgTP40V9RW0@3g
moT106IVOP0000<0IVIn0?Ogn@2l_Ld0Y02l_Ld10?Ogn@40IVIn00000`1V
IWh0moOi0>CSh`2T0>CSh`40moOi0@1VIWh0000306IVOP3`lO@0oooo05d0
oooo00<0i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?06afT01/MY0906]e
S`0609bT^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0101/MY00JgF?06af
T01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W
>T@0YSU40:LjA02W>T@90:HiA00309bT^@3/j^X0oooo00<0oooo0@3`lO@1
06IVOP0001H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0
o?cm0?clo03lnod0o?cl0?cko03lo?`0nocl0?clo03ko?d0o?_l0?clo@3k
nod0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?dS0?cko240nocl00<0W:Bi
06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`
00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl
0?clo03lnod0nocm0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3f
moT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0
m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Og
n@0R0?OgnB40m_Oi00<0JgF?08F9/02LW[h0402LW[h01P25RK00JgF?0?Og
n@3gmoT0JgF?08F9/140W9jn00P0QHV`06]eS`3fmoP0moOh0:HiA02Z?5D0
`U9K0<IDFPd0aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh0?Og
n@3Ph>400@1VIWh0000606IVOP3NgN40lO7d0?7am03`lO@0l?;d40000000
1P3alO@0l?;e0?7am03al_@0l?;d0?7am4@0l?7e00<0JgF?0;:ed02WZ<80
402WZ<801P2b]M00JgF?0?3am03`lO@0JgF?0;:ed140YjS200D0/[G@06]e
S`3`lOD0lO;d0:HiA0020<9BF`030<]DF@3=FEh0cEUN00/0cEUN00@0beAI
0<9BF`32DU/0YSU40P3`lO@00`3alO@0l?;d0=kMh@0106IVOP0000L0IVIn
0=cKh03Zjo00j^_`0>[/l03Yjnl000000080inOW0P3Ng]h20>OWi`030>Nm
Q03WinL0inOW00<0inOW0P3_knl010000000j^_`0>[[l03Zjnl20>[[l003
0>[[k`3Zjo00j^_`0240j^_`8@3Zk?00101[MHl0][WA0:f^aP2][/H80?oo
o`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0101[
MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Zjo00
1@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0cEUN
0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3SiNX0
hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<00>OW
i`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX00P3S
i>X00`3Si>/0hnG[0>?Uj`0Q0>?Ujb40hnCZ00D0JgF?0;bne02b//X0/[;:
0?ooo`0606i]S`0302DU=P2b//X0/[;:00D0/[;:00H0_;kD06]eS`3SiNX0
hnGZ06]eS`2l_]@20;:bbP030?ooo`0U9CH09BDf00T09BDf0`2b//X01@2l
_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN00@0d5]P0=ALG`3oool0oooo1`3D
G5l20?ooo`0:0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnCZ0>?UjP3Si>X0hnG[
0=WIg`40IVIn00000`1VIWh0emSN0=cNiP030=cNiP050000003WinL0inOW
0>OWi`3We/h00P3WinL01@3>N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_00L0
00000=cNiP3Lg^D0g=kU0=cNiP3Lg^D0g=kV04@0g=kU00D0JgF?0;o1eP2h
^Lh0^;W>0?ooo`0606i]S`0302DU=P2h^Lh0^;W>00D0^;W>00H0_l7F06]e
S`3Lg^D0g=kU06]eS`2o`MH20;RicP030?ooo`0U9CH0^;W>00L0^;W>00<0
oooo02DU=P2h^Lh00P2h^Lh02@2o`MH0JgF?0=cNiP3Lg^D0YSU40<eIGP3A
FUh0e5eQ05<U80030?ooo`D0eUmS0`3oool01@1C9B00e5eQ0=5JGP3=FEh0
YSU40080g=kU00<0g=kV0=cNi@3Gf=h00@1VIWh0000406IVOP3Ee]d0eMSP
0=KHh@80eMSP00T0000008b<S03WinL0inOW0>NeQ03FFP00eX@00?o>003>
H`000P3NJ`001@3_]H`0kno_0>o_k`3_knl000000080eMSQ00@0eMOP0=KH
h03Ff>40e]OQ8`3Fen0Q0=KHh00506]eS`33aMT0_;gA0;bmd@3oool01`0U
9CH70;bmd@060<?5f@1[MHl0eMSQ0=GHh@1[MHl0`lGI0P2l_M400`3oool0
9BDf0;bmd@070;bmd@030?ooo`0U9CH0_;gA0080_;gA00D0`lGI06]eS`3F
en00eMOQ0:HiA0020=EMH0030=QPH@3IHF80AQhJ00<0oooo0`3IHF830?oo
o`0304HN6P3IHF80f61Q0080eEeP00H0YSU40=KHh03Ef>40eMOP0=GHh@3E
e]d106IVOP0000L0IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@d]`0000000<0inOW
00`0imk>0<I:003gcP00kjd00>ne003>J`00aUX00<I[003NS4X0ijD00>oW
cP0000030=3Bg0030<oBg03@d]`0cm;L02<0d=;L8@3?d]d00`1[MHl0b<WK
0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3o
ool09BDf0<?4eP070<?4eP030?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]e
S`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo
0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d2
0=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:
cMP000000>O6[@3WaX`0mlhH0>nm003gaP00kjd00>N]003WY@00eX`00<i[
003WaP00omH00>o_i`3_knl000000<_=f03;cMT0b/gI0<_>f03:cMP0blgH
8`3;cMTQ0<_>f@0306]eS`3;c=h0b<[I00P0b<[I00<0b<WI0<S:f@38b]T0
0`38b]T01038bMT0b<[I0<_<gP1[MHl20<_=f00606]eS`3;c=h0b<[I0<S:
f@3oool09BDf1@38b]T04@38bMT0b<[I0<S:f@3oool09BDf0<S:f@38bMT0
b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0eemO0=]TI03PIfD0h6IU0080gVMW
00<0AQhJ0?ooo`3oool00`3oool02P167QX0gVMW0=iWI`3PIVD0h6MU0=]T
I03GGel0YSU40<[>f03:c]T20<_=f@40d=;K0@1VIWh0000306IVOP3?cmX0
aLSD00<0aLSD00H000000<K6aP3Wg]H0cW/00>N]003_]@020>NU00030=JD
003>L`00eY@00080mlH00P3gmoL010000000aLSD0<G7e035am@30<G7eB<0
a<OE8@34b=@00`1[MHl0d=7P0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7
e01[MHl0d=7P0P3;bm`00`3oool09BDf0<_;g0070<_;g0030?ooo`0U9CH0
bl_L0080bl_L00L0d=7P06]eS`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX
00D0AQhJ0?ooo`3oool0oooo04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8
e@80a<SD0@35amD10<o?fP40IVIn0000101VIWh0c<kJ0<;4dP31a=420<74
dP060000003WinL0inOW0>OWi`3FQ000kkD00P3WY@00203FQ000cV/00>N]
003g]@00mkd00>o_k`3gmoL000000`31a=800`32a=40`LCB0<74dP0S0<74
dB40`LCB00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80
JgF?0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@
g@020<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0
oooo1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1V
IWh0000406IVOP3:c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0imkF
0=J<00020=jD00040=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>BP00
0000_/3>0;k0c`2n`<h0_/3?0;g0cR@0_/3>8@2m`<h00`1[MHl0e]KT0=?C
h00@0=?Ch0060=KFi01[MHl0_/3>0;k0cP1[MHl0e]KT0P3Cdn000`3oool0
9BDf0?ooo`080?ooo`0;02DU=P3Cdn00dm?P0=?Ch03Fe^@0JgF?0;k0c`2n
`<h0YSU40>1VI@3QJVX0103SK6`30?ooo`0404HN6P3oool0oooo0?ooo`@0
hfa/00@0hFYZ0>1VI@2V>D@0_L3?0P2n`<l10;k0cP40b/cH0@1VIWh00007
06IVOP39b]P0][S80;Vlb`2j_</0^[c<000000020>o_k`0C0=JL003FS000
gY@00=J4003_Y@00gX`00;eJ003FL`00ki`00?O_i`3gmoL0oooo0000002i
_<`0^[_<0;Vlb`2j_</0^Kc<0;Vlb`0S0;Vlc240^[c<00<0JgF?0=SHi@3C
dn40403Cdn401P3Hf>D0JgF?0;Zlb`2j_</0JgF?0=SHi@80dm?Q00<0oooo
06i]S`1^KHl0201^KHl03P0U9CH0dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0
^[c<0:HiA03PJFP0hFe/0>AaK@3TLFl0i71^0`3oool00`167QX0i71^04HN
6P030?ooo`80i71^00T0i75]0>5]K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jh
b039b]P00@1VIWh0000906IVOP37bML0];K70;Jhb02f^<T0][W900000024
Q8@0inON0080kno_00L0aV/00?O6003_]@00ki`00=j<003>J`00ii`000<0
moOg00D000000;Jib@2g^<T0][W90;Nib@020;JhbB<0]kS98@2f^<T0101[
MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0e]KT
06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U9CH0
f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>MaK`3T
M6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_0>Ma
K`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG0@1VIWh0000306IV
OP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_knl02`3W[@00mlH8
0>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool0000004X0];K700D0
JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`1[
MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS06]e
S`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3oool00`167QX0jGih
0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V>D@4
0;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0];K700H0000008b<
S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_imH0
moOg0?ooo`00001:0;Bfa`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS06]e
S`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V>D@0
jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZKS03]
UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40a/SG
0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H000000>o_k`3_knl0kno_
0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg00<0oooo0000002a
/lP0B@2a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?80;6c
b01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`Q7`0
mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fdV`3/
]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn0000
0`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_0?Ogm`3_knl01P3g
moL20?ogm`80oooo00<000000:n^a`2_[/L0B02_[/L00`1[MHl0d]7S0?;a
m`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3BdN<0
JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V>D@0
[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0`<7A0<O7e01M0:b[
a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/
Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80
[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0n^Vf
0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03oWhd0YSU4096HZP<0
[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;Bg`2e]<UM0:BS_P03
08B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80
JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:HiA02V
>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1VIWh0
000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34W@2XYkl01@2a/<@0_;c?0=;B
h03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@h03:
b]X0V`2l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000201H
EfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[V@3Gf>801`3Qh^/0k>_^
0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX00<0IVIn09FDZ`3A
dMh00P3lo?bK0?ooo`80o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0F5MX
0P1VIWh00`28Qid0UIB[0:RW_`2J0:RW_`0409FDZ`28Qid0IVIn06IVOP<0
F5MX000505QGJ9l0IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  Evaluatable->False,
  ImageSize->{169, 77},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"WidgetAlign"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"WidgetAlign"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["WidgetLayout Options", "Subsection",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "As we have seen above, ",
  StyleBox["WidgetLayout", "Output"],
  " is an option for ",
  StyleBox["WidgetGroup", "Output"],
  " that can specify the grouping directions for the containing widgets. \
Actually, this form of ",
  StyleBox["WidgetLayout -> ", "Output"],
  StyleBox["groupValue",
    FontSlant->"Italic"],
  " is a shorthand form for ",
  StyleBox["WidgetLayout", "Program"],
  StyleBox[" -> {\"Grouping\" -> ", "Output"],
  StyleBox["groupValue",
    FontSlant->"Italic"],
  StyleBox["}", "Output"],
  ".",
  StyleBox[" ", "Output"],
  "As it turns out, there are a number of different suboptions of ",
  StyleBox["WidgetLayout", "Output"],
  " that provide different tweaks to layouts. The short form for grouping is \
available as it is very common to only use ",
  StyleBox["WidgetLayout ", "Output"],
  "to specify a grouping choice. "
}], "Text",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "One other short form use of ",
  StyleBox["WidgetLayout", "Output"],
  " is used with ",
  StyleBox["Widget", "Output"],
  " and that is for the special case when you want to create a user interface \
widget, but you do not want to have the widget automatically added to the \
layout of its parent widget. In this case, you would turn off any widget \
layout work using ",
  StyleBox["WidgetLayout -> None", "Output"],
  "."
}], "Text",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["WidgetLayout -> ", "Output"],
  StyleBox["groupValue", "Text",
    FontSlant->"Italic"],
  " is simply a shorthand form of ",
  StyleBox["WidgetLayout -> {\"Grouping\" -> ", "Output"],
  StyleBox["groupValue", "Text",
    FontSlant->"Italic"],
  StyleBox["}", "Output"],
  ". \n\[FilledSmallSquare] ",
  StyleBox["WidgetLayout -> None ", "Output"],
  "can be used as an option to ",
  StyleBox["Widget", "Output"],
  " to turn off any automatic interface layouts with its parent widget",
  ". "
}], "FramedBox",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "Forms of ",
  StyleBox["WidgetLayout", "MR"],
  " use."
}], "Caption",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "Along with ",
  StyleBox["\"Grouping\"", "Output"],
  ",",
  StyleBox[" ", "Output"],
  "which allows all forms previously documented for the short form of ",
  StyleBox["WidgetLayout", "Program"],
  ": ",
  StyleBox["Row", "Output"],
  ", ",
  StyleBox["Column", "Output"],
  ", ",
  StyleBox["Grid", "Output"],
  ", ",
  StyleBox["Automatic", "Output"],
  ", and ",
  StyleBox["None", "Output"],
  ", the following other ",
  StyleBox["WidgetLayout", "Output"],
  " suboptions exist."
}], "Text",
  CellTags->"LayoutOptions"],

Cell[CellGroupData[{

Cell["\"Grouping\"", "SubsubsectionIcon",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  StyleBox["\"Grouping\" -> ", "Output"],
  StyleBox["groupValue",
    FontSlant->"Italic"],
  " takes on all grouping values documented for ",
  StyleBox["WidgetLayout", "Output"],
  " short forms mentioned so far, and this suboption form must be used when \
combined with other ",
  StyleBox["WidgetLayout", "Output"],
  " suboptions for a given ",
  StyleBox["WidgetGroup", "Output"],
  "."
}], "Text",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "See examples of ",
  StyleBox["WidgetLayout -> ", "Output"],
  StyleBox["groupValue",
    FontSlant->"Italic"],
  " in the previous sections for examples of ",
  StyleBox["\"Grouping\"", "Output"],
  " use."
}], "Text",
  CellTags->"LayoutOptions"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Stretching\"", "SubsubsectionIcon",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "The ",
  StyleBox["\"Stretching\"", "Output"],
  " suboption is supported both for ",
  StyleBox["Widget", "Output"],
  " and ",
  StyleBox["WidgetGroup", "Program"],
  " and is useful to specify an explicit horizontal and vertical stretching \
for a widget that may be different than the default stretching \
characteristics for a given widget type.  Both a horizontal and vertical \
stretching value can be specified with allowable values: ",
  StyleBox["None", "Output"],
  ", ",
  StyleBox["False", "Output"],
  ", ",
  StyleBox["WidgetAlign", "Output"],
  ", ",
  StyleBox["True", "Output"],
  ",  and ",
  StyleBox["Maximize.", "Output"]
}], "Text",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Stretching\" -> {", "Output"],
  StyleBox["horizontal", "Text",
    FontSlant->"Italic"],
  StyleBox[", ", "Output"],
  StyleBox["vertical", "Text",
    FontSlant->"Italic"],
  StyleBox["}", "Output"],
  " overrides any default stretching characteristics for a given widget.\n \
\[FilledSmallSquare]  A stretching value of ",
  StyleBox["None", "Output"],
  " or ",
  StyleBox["False", "Output"],
  " will keep a widget from stretching from its initial size.\n \
\[FilledSmallSquare]  A stretching value of ",
  StyleBox["True", "Output"],
  " will allow stretching, but another widget with a ",
  StyleBox["Maximize", "Output"],
  " stretching may limit a stretching if it exists.\n\[FilledSmallSquare]  A \
stretching value of ",
  StyleBox["Maximize", "Output"],
  " will allow stretching and also prioritize this widget's stretching over \
others that may simply allow stretching.\n\[FilledSmallSquare]  A stretching \
value of ",
  StyleBox["WidgetAlign", "Output"],
  " will allow stretching, but only to the extent needed to make a widget the \
same size as sibling widgets in its list."
}], "FramedBox",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "Uses of ",
  StyleBox["\"Stretching\" ", "MR"],
  "suboption."
}], "Caption",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "By default, labels do not stretch and text fields do, but we can override \
this with explicit ",
  StyleBox["\"Stretching\"", "Output"],
  " values."
}], "Text",
  CellTags->"LayoutOptions"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ 
      GUIRun[\[IndentingNewLine]Widget["\<Frame\>", \
{\[IndentingNewLine]{Widget["\<Label\>", {"\<text\>" -> "\<Label:\>"}, \ 
                WidgetLayout \[Rule] {"\<Stretching\>" \[Rule] {True, \ 
                        False}}], \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<Input\>"}, \ 
                WidgetLayout \[Rule] {"\<Stretching\>" \[Rule] {False, \ 
                        False}}]}, \[IndentingNewLine]Widget["\<TextArea\>", \
{"\<text\>" -> "\<Content\>"}]\ }, \ 
          Name\  \[Rule] \ "\<myFrame\>"]\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"LayoutOptions"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject258333894246401, 
        JLink`Objects`JavaObject390200278646785]]], "Output",
  CellLabel->"Out[4]=",
  CellTags->"LayoutOptions"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"LayoutOptions"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000BR000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80oooo
0`0000040?ooo`<000000P3oool3000000040?ooo`0000000000000000<0
oooo0`0000030?ooo`@0000000D0oooo00000000000000000?ooo`030000
00<0oooo0`0000130?ooo`0306IVOP2XZK/0nocm0040IVIn00001P1VIWh0
nocm0:RY^`1VIWh0oooo000000<0oooo00@000000?ooo`3oool000000`3o
ool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo000000060?ooo`050000003oool0oooo0?oo
o`0000000`3oool01@000000oooo0?ooo`3oool000000480oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3oool000001P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0103oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool0A03oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2X
ZK/0IVIn0?ooo`0000060?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0
0`3oool500000080oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo04@0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000606IV
OP3ko?d0Z:Vk06IVOP3oool000001P3oool01@000000oooo0?ooo`3oool0
00000080oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000001@3o
ool01@000000oooo0?ooo`3oool000000080oooo0P0000020?ooo`050000
003oool0oooo0?ooo`000000AP3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00H0IVIn0?_lo@2XZK/0IVIn0?ooo`0000070?ooo`<000000P3oool20000
00030?ooo`000000000000<0oooo1@0000030?ooo`<000000P3oool20000
00030?ooo`000000000000<0oooo1@0000130?ooo`0306IVOP2XZK/0nocm
0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0oooo000000<0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
oooo04@0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP80oooo1000001]0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWiA0>3Ohb80YJbb00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOU40h=oS00<0YJbb0?ooo`3oool07P3oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInD@3P
gn<00`2U[;80oooo0?ooo`0N0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWiA0>3Oh`030:F//P3oool0oooo00<0oooo
00<000000?ooo`3oool0603oool0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVInD@3Pgn<00`2U[;80oooo0?ooo`030?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0403oool0102U[;80
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInD@3Pgn<00`2U
[;80oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0403oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn1@0000020>3Oh`80000000D0h=oS0000003Pgn<000000>3O
h`02000000<0h=oS0`0000020>3Oh`030000003Pgn<0000003H0h=oS00<0
YJbb0?ooo`3oool00`3oool00`000000oooo000000030?ooo`040000003o
ool000000?ooo`8000000`3oool2000000030?ooo`000000oooo00800000
1@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn000000050>3Oh`030000003Pgn<0h=oS0080000000<0h=oS00000000
00000P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000003P0
h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo000000030?ooo`04
0000003oool0000000000080oooo00<000000?ooo`0000000P3oool20000
00030?ooo`000000oooo00D0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP0000001@3Pgn<01`000000h=oS0>3Oh`3P
gn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000050>3Oh`030000
003Pgn<0h=oS03H0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`000000
0`3oool00`000000oooo000000060?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000H0h=oS100000000`3Pgn<0
00000>3Oh`020>3Oh`030000003Pgn<0000000@0000000<0h=oS0000003P
gn<0=`3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`03
0000003oool0000000H0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP0000001@3Pgn<01P000000h=oS0>3Oh`3Pgn<0
00000>3Oh`8000000P3Pgn<00`000000h=oS000000030>3Oh`030000003P
gn<0000003P0h=oS00<0YJbb0?ooo`3oool00`3oool010000000oooo0000
000000020?ooo`040000003oool0000000000080oooo00<000000?ooo`00
00000`3oool00`000000oooo000000060?ooo`040:F//P1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000H0h=oS0`0000020>3O
h`040000003Pgn<00000000000<0h=oS0`0000020>3Oh`030000003Pgn<0
000003H0h=oS00<0YJbb0?ooo`3oool00`3oool010000000oooo0000003o
ool200000080oooo00@000000?ooo`00000000000P3oool010000000oooo
0?ooo`3oool4000000D0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP0000002`3Pgn<00`000000h=oS0>3Oh`090>3O
h`030000003Pgn<0h=oS03H0h=oS00<0YJbb0?ooo`3oool00`3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo00@0oooo00@0YJbb06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000002`3Pgn<0
0`000000h=oS0>3Oh`090>3Oh`030000003Pgn<0h=oS03H0h=oS00<0YJbb
0?ooo`3oool00`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo00@0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOU40h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?oo
o`0H0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWiA0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0
603oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVInD@3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo01P0
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OU40h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`0H0?oo
o`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiA
0>3Oh`030:F//P3oool0oooo01h0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOU40h=oS8P2U[;800`1VIWh0Z:Vk0?_l
o@0106IVOP0000<0IVIn0?Ogn@2HV:L0M@1gMi8109RHY`40moOi0@1VIWh0
000306IVOP3gmoT0_;g=07H0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3T
hn<0MP3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`0_0?ooo`030>CS
h`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0
i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[
MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W
>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F
06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0
o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080
o?cl00@0o?cm0?clo03knod0o?cm503lno`20?_lo00309bT^@1[MHl0QHV`
0100QHV`00H0JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9/00606]eS`2L
Y;T0nocl0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_lo03lo?`0o?_m
0?_lo@3RhN800@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0m_Oh
0?Ogn@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi0?Kgn@020?Og
n@040?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3gmoT04`3gmoT2
0?Kgn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi06]e
S`25RK0A09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=
0<IEG0090<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q0040
IVIn00001P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm100000000H0lO7d0?3b
m@3alO@0lO;d0?3bm03alO@F0?3am@0306]eS`2b]M00YjS20100YjS200H0
/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e0?7b
m02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0`U9K
0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3Lfn00j^_`
0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0inOW0>OW
i`030>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`
0>[[l00B0>[[l080j^c`00@0JgF?0;Jid@2][/H0[Jk6203oool00`2][/H0
[:k60:f^aP030:f^aP030:b^aP2f^M40JgF?0080j^__00@0JgF?0;Jid@2]
[/H0[Jk6303oool20:f^aP030:b^aP2f^M40JgF?0080j^_`00D0YSU40<eI
GP3;E5T0cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0j^__
0>[[l0020>[[k`40g=_P0@1VIWh0000406IVOP3IfMl0hnGZ0>?TjP80hnG[
00D0000008b<S03Ng]h0inOW0=kNgP020>OWi`030<IS003WinL0inOW0080
inOW00L0knoW0>o_k`3_knl000000>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[
0>?Uj`3SiN/04P3SiN/20>?TjP0506]eS`2l_]@0/[;:0;:bbP3oool01P1^
KHl00`0U9CH0/[;:0;:bbP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[MHl0
_;kD0P2b//X00`3oool09BDf02DU=P0902DU=P<0/[;:00D0_;kD06]eS`3S
i>/0hnC[0:HiA0020<eIGP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3oool0
2P3DG5l0d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl106IV
OP0000<0IVIn0=OHgP3Lg^H00`3Lg^H01@000000inOW0>OWi`3WinL0imK>
0080inOW00D0cW/00>nD403WinL0imk60>n<40030>o_k`070000003Lg^H0
g=kU0=cNi@3Lg^H0g=kU0=cNiP0F0=cNi@0506]eS`2o`MH0^;W>0;RicP3o
ool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU0=cN
i@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U9CH0
^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C
9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA0020=cN
i@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>420=GH
h0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080gV/0
00D0kkF<0>o_k`3_knl0kno_000000020=GHh@040=GGh03Ff>00e]SQ0=KG
hA@0e]OP0P3Ff>001@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M40
1P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M40
1`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V
>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0
fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0
000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36
BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@
d]`00`3?d]`0d=;L0<oBg00D0=3Bg080cm;M00<0JgF?0<S9f`33a=H04033
a=H01P38bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80`lCF00<0oooo02DU=P33
a=H01`33a=H00`3oool09BDf0<?4eP020<?4eP070<S9f`1[MHl0cm;L0<oB
g02V>D@0eemO0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3o
ool020167QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`10<oB
g040d]CM0@1VIWh0000L06IVOP3@d]/0blgH0<[=f@3;c]P0b/gH0000003W
aZd0ilJ<0?O>603__@00mlH00>n]003W[@00ijD00=J<003>J`00ilH00?oF
003_knL0kno_0000003;cMP0blgI0<[=f@3;c]P0b/gH0<_=f1@0blgI0P3;
c]T00`1[MHl0blcN0<S:f@080<S:f@030<S9f@38b]T0b<[I00<0b<[I00@0
b<WI0<S:f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN0<S:f@38b]T0oooo02DU
=PD0b<[I0140b<WI0<S:f@38b]T0oooo02DU=P38b]T0b<WI0<S:f@3;c=h0
JgF?0<_>f03:cMP0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN6P3o
ool0oooo00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO0:Hi
A03:c]P0b/kI0P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0030<G8
e00600000036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD
00020?O60080moOg00@000000<G8e035am@0aLOD0`35amDD0<C7e@80a<SD
00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3A
h080bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;
g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3o
ool0oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040
aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000
inOW0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm
003_knl0moOg000000<0`LCB00<0`/CA0<74dP31a=805031a=420<74dP03
06]eS`3Cdn80cm3M0100cm3M00H0dm?R06]eS`32a=80`/CB06]eS`3Cdn82
0<o@g@030?ooo`0U9CH0cm3M00L0cm3M00<0oooo02DU=P3?d=d00P3?d=d0
1`3Cdn80JgF?0<;4dP31a=40YSU40=]TI03QJFD01@3PK6T50?ooo`D0h6aY
00P0hFUU0=]TI02V>D@0`LCB0<;4d@31a=40`LCB0<c>fP40IVIn0000101V
IWh0b/cH0;k0c`2m`<l20;k0cP050000002LW9`0inOW0>ONeP3FS0000P3N
U000103FN`00aV<00;e2003_Y@020?N]00080?Ne003ocTX000000;k0cP2n
`<l0_/3>0;k0c`2m`<hE0;k0cP80_L3>00<0JgF?0=KFi03Cdn00403Cdn00
1P3Fe^@0JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3oool0
203oool02`0U9CH0dm?P0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:HiA03P
IVD0hFYZ00@0hfa/0`3oool010167QX0oooo0?ooo`3oool40>=/K0040>5Z
JP3PIVD0YSU40;g0c`80_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0bL[H
0;Jhb02i_</0^[c;0;Zlc00000000P3_knl04`3FW000eX`00=jD003FQ000
kjD00=j<002mFP00eW<00>nL003gknL0moOg0?ooo`000000^Kc<0;Zkc02i
_</0^[c;0;Vlc02i_</0502i_<`20;Zlc00306]eS`3Hf>D0dm?Q0100dm?Q
00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?
00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0
h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3oool2
0>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H0040
IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OWgP02
0>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Ogm`050000
002f^LT0]kS90;Jib@2g^LT00P2f^<TD0;Nhb@80][S900@0JgF?0=KFi03H
f>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@090=KFi01[MHl0]kS9
0;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d09BDf0=SHiP3Hf>D0
f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo
00D0AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^
K@2V>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn00000`1VIWh0a/SG0;Bf
a`030;Bfa`030000003_knl0kno_0080kno_00/0ijd00?O6203WY@00ii@0
0>N<003_imH0gY@i0>oF]@3omoL0oooo0000000L0;Bfa`0506]eS`3EeN<0
g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80
g=_W00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GEh`1[MHl0];K70;Bf
a`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ0>UnN03YOWP00`3Y
OWP020167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d]/L10<K8
e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`060000002<S8`0kno_0>o_
k`3WcW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool0
0000702d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0];K70;Bf
a`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0YSU40>YiL`3YO7P0
kh5j0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:0>^HR`02
04HN6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L10<K8e`40IVIn0000
0`1VIWh0a/SG0;6cb0030;6cb0060000003_knl0kno_0>o_k`3gmnl0kno_
0P3gmoL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`000000/K?801/0/K?8
00<0JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[
la40jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0
lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3g
WHh0mHb40?24O03aP7D0YSU400@0/K?80@36b=L106IVOP0000<0IVIn0<K8
e`2h]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3omoL2
0?ooo`030000002_[/L0[jk701X0[jk700<0JgF?0=;Ah`3blOL0403blOL0
1P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0d]7S06]eS`2_[/L0
[jk70:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^a`020:n^
a`40^;O?0@36b=L106IVOP0000<0IVIn0<31d@37am@0;`2/Zl@01024S:80
JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400@0Q8bR
06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a007096H
ZP2V>D@0oin=0?joY03jg;L0n^^g0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf
0?[Y]P80nNVf00H0n^^g0?[L]`3n_j@0oin=0:HiA02AV:X30:b[a040alOD
0@30`M4106IVOP0000@0IVIn0<31d@3Bd]l0]KC9;`2TXkh00`24S:80JgF?
06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]eS`1[MHl0
3`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V>D@0YSU400l0YSU4
00L0Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040IVIn00001P1VIWh0
Z:No0>KVk@3Bd^00_;c?0;6`a6l0Z:No00D0/K340;blc`3Bd^00i^K]0:RW
_`0106IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@d>00b/[J06d0_;c?
00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ00000P0F5MX06IVOP2E
U:/0emSR0?clo03blO<0k>_^0>7Rjf/0emSR00L0hN;[0>c[kP3blO<0o?cl
0=OHhP2EU:/0IVIn0040F5MX000205QGJ00306IVOP2EU:/0dM7N0080o?cl
K@3oool20?clo0030=7AgP2EU:/0IVIn0080F5MX000305QGJ080IVIn00<0
R8NM09FDZ`2XYkl0K02XYkl0102EU:/0R8NM06IVOP1VIWh305QGJ0001@1H
EfQa06IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  Evaluatable->False,
  ImageSize->{123, 74},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutOptions"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"LayoutOptions"]
}, Open  ]],

Cell["This is more apparent with a window resize.", "Text",
  CellTags->"LayoutOptions"],

Cell[BoxData[
    \(ref\ @\ 
      SetPropertyValue[{"\<myFrame\>", \ "\<size\>"}, \ \
\[IndentingNewLine]ref\ @\ 
          Widget["\<Dimension\>", \ {"\<width\>" \[Rule] 
                250, \ "\<height\>" \[Rule] 150}]]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"LayoutOptions"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"LayoutOptions"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003j0000UR000`400?l0
0000o`00003onP1VIWh0000306IVOP3ko?d0nocm0?H0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0?D0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
m01VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80oooo
0`0000040?ooo`<000000P3oool3000000040?ooo`0000000000000000<0
oooo0`0000030?ooo`@0000000D0oooo00000000000000000?ooo`030000
00<0oooo0`0000320?ooo`0306IVOP2XZK/0nocm0040IVIn00001P1VIWh0
nocm0:RY^`1VIWh0oooo000000<0oooo00@000000?ooo`3oool000000`3o
ool010000000oooo0?ooo`0000030?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo000000060?ooo`050000003oool0oooo0?oo
o`0000000`3oool01@000000oooo0?ooo`3oool000000<40oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3oool000001P3o
ool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0
oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0103oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool0``3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2X
ZK/0IVIn0?ooo`0000060?ooo`050000003oool0oooo0?ooo`0000000P3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0
0`3oool500000080oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo0<<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000606IV
OP3ko?d0Z:Vk06IVOP3oool000001P3oool01@000000oooo0?ooo`3oool0
00000080oooo0P0000020?ooo`050000003oool0oooo0?ooo`0000001@3o
ool01@000000oooo0?ooo`3oool000000080oooo0P0000020?ooo`050000
003oool0oooo0?ooo`000000a@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00H0IVIn0?_lo@2XZK/0IVIn0?ooo`0000070?ooo`<000000P3oool20000
00030?ooo`000000000000<0oooo1@0000030?ooo`<000000P3oool20000
00030?ooo`000000000000<0oooo1@0000320?ooo`0306IVOP2XZK/0nocm
0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0oooo000000<0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0
oooo0<<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP80oooo1000003/0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWkb0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWk@0>3Ohb80YJbb00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVO]00h=oS00<0YJbb0?ooo`3oool07P3oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInd03P
gn<00`2U[;80oooo0?ooo`0N0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWk@0>3Oh`030:F//P3oool0oooo00<0oooo
00<000000?ooo`3oool0603oool0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVInd03Pgn<00`2U[;80oooo0?ooo`030?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0403oool0102U[;80
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInd03Pgn<00`2U
[;80oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0403oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn1@0000020>3Oh`80000000D0h=oS0000003Pgn<000000>3O
h`02000000<0h=oS0`0000020>3Oh`030000003Pgn<000000;D0h=oS00<0
YJbb0?ooo`3oool00`3oool00`000000oooo000000030?ooo`040000003o
ool000000?ooo`8000000`3oool2000000030?ooo`000000oooo00800000
1@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn000000050>3Oh`030000003Pgn<0h=oS0080000000<0h=oS00000000
00000P3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<000000;L0
h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo000000030?ooo`04
0000003oool0000000000080oooo00<000000?ooo`0000000P3oool20000
00030?ooo`000000oooo00D0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP0000001@3Pgn<01`000000h=oS0>3Oh`3P
gn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000050>3Oh`030000
003Pgn<0h=oS0;D0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`000000
0`3oool00`000000oooo000000060?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000H0h=oS100000000`3Pgn<0
00000>3Oh`020>3Oh`030000003Pgn<0000000@0000000<0h=oS0000003P
gn<0]P3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`03
0000003oool0000000H0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP0000001@3Pgn<01P000000h=oS0>3Oh`3Pgn<0
00000>3Oh`8000000P3Pgn<00`000000h=oS000000030>3Oh`030000003P
gn<000000;L0h=oS00<0YJbb0?ooo`3oool00`3oool010000000oooo0000
000000020?ooo`040000003oool0000000000080oooo00<000000?ooo`00
00000`3oool00`000000oooo000000060?ooo`040:F//P1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000H0h=oS0`0000020>3O
h`040000003Pgn<00000000000<0h=oS0`0000020>3Oh`030000003Pgn<0
00000;D0h=oS00<0YJbb0?ooo`3oool00`3oool010000000oooo0000003o
ool200000080oooo00@000000?ooo`00000000000P3oool010000000oooo
0?ooo`3oool4000000D0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP0000002`3Pgn<00`000000h=oS0>3Oh`090>3O
h`030000003Pgn<0h=oS0;D0h=oS00<0YJbb0?ooo`3oool00`3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo00@0oooo00@0YJbb06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000002`3Pgn<0
0`000000h=oS0>3Oh`090>3Oh`030000003Pgn<0h=oS0;D0h=oS00<0YJbb
0?ooo`3oool00`3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo00@0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVO]00h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?oo
o`0H0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWk@0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0
603oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVInd03Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo01P0
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
O]00h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`0H0?oo
o`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWk@
0>3Oh`030:F//P3oool0oooo01h0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO]00h=oS8P2U[;800`1VIWh0Z:Vk0?_l
o@0106IVOP0000<0IVIn0?Ogn@2HV:L0m01gMi8109RHY`40moOi0@1VIWh0
000306IVOP3gmoT0_;g=0?D0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3T
hn<0m@3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`2^0?ooo`030>CS
h`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0
i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[
MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W
>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F
06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0
o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080
o?cl00@0o?cm0?clo03knod0o?cm?P3lno`o0?_lo1P0nocm00<0W:Bi06]e
S`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0
JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?cl
o03lnod0nocm0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT0
2`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi
0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0m
0?OgnCl0m_Oi603gmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0
moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:Xl
E@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0
moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@0000
00060?7am03`l_D0lO7d0?7bm03`l_@0lO7dO@3`lODH0?3am00306]eS`2b
]M00YjS20100YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P05
0;:ed01[MHl0l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eI
GP040<]DF@32DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0
000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3W
inL00`3W_H@0inOW0>OWi`030>OWi`80kno_00@000000>[[l03Zjo00j^__
0P3Zjo000`3Zjnl0j^_`0>[[l00l0>[[l3l0j^c`603Zjnl0101[MHl0][WA
0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[
MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Ji
d@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO
0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0
IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080
inOW00<0aV<00>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ
0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0l0>?Ujcl0hnCZ603SiNX0
1@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b
//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U
9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@
Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:Hi
A03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0
g=kV00D000000>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW
0>ONaP3_S1000`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H0
U@3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h
^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo
02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0
g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`05
05<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IV
OP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0
ikF40=IJ003FQ000olh00<iS00020=i[00050>neS03_knl0kno_0>o_k`00
00000P3Ef>40103Een00e]SP0=KHh@3Fen4n0=KGh3l0e]SP603Ef>401@1[
MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?0=GHh@3E
f>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M401`2l_M400`3oool09BDf
0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V>D@00P3EGF000`3HH640
fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@020=EMH006
0:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0000706IVOP3Be=d0cm;L
0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36BP00mlh00>n]003_]@00
cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@d]`00`3?d]`0d=;L0<oB
g00n0=3Bg3l0cm;M603@d]`00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[
MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP03
0?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0
fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3L
IFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IV
OP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH
0>nm003gaP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl0
00000<_=f03;cMT0b/gI0<_>f03:cMP0blgH?P3;cMTo0<_>fAP0blgH00<0
JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38
b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:
f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;
c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?oo
o`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH
0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P00
0000a/K60>ONeP3>N`00ijd00>ne0080ijD000<0eY@00<ic003FU0000P3g
aP020?Ogm`0400000035b=@0aLOD0<G7e0<0aLOE?P34amDo0<C8e1P0a<OD
00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3A
h080bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;
g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3o
ool0oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040
aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000
inOW0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm
003_knl0moOg000000<0`LCB00<0`/CA0<74dP31a=80?P31a=4o0<74dQP0
`/CB00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?
0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@02
0<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo
1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh0
000406IVOP3:c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<
00020=jD00040=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>BP000000
_/3>0;k0c`2n`<h0_/3?0;g0cSl0_/3>?`2m`<hH0;k0cP0306]eS`3Fe^@0
dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?oo
o`0U9CH0oooo00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?
0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo
103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP00
00L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<
003NU000eX@00>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3oool00000
0;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;03h0^Kc<?`2j_<`H0;Zlb`0306]e
S`3Hf>D0dm?Q0100dm?Q00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?C
h@030?ooo`1^KHl0KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[
MHl0^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ
0>A`KP167QX00`3oool20>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<
0;Vlb`2f^<P0bL[H0040IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Ji
b@000000Q8B40>OWgP020>o_k`070<I[003gaP00kkD00>nL003NS000cV/0
0>NL00030?Ogm`050000002f^LT0]kS90;Jib@2g^LT00P2f^<Tn0;NhbCl0
][S9602g^<T0101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SH
iP80f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool0
2P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03T
KVd0i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0
oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG
0@1VIWh0000306IVOP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_
knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool0
000009/0];K700D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[
MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0
g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3o
ool00`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0
igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0
];K700H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0
moOg0?Ogm`3_imH0moOg0?ooo`00002K0;Bfa`0306]eS`3Ee><0h=oZ0100
h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0
];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]
UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:Hi
A0040;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H00000
0>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg
00<0oooo0000002a/lP0VP2a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[
l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0
YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/
]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP1
0<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_
0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L0V@2_[/L0
0`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S
4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@
Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0
`<7A0<O7e02^0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;
g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<
bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf
0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03o
Whd0YSU4096HZP<0[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;B
g`2e]<V^0:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh0
0P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n
00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;B
g`30`M400@1VIWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34kP2XYkl0
1@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3l
o?`0i>?X0=3@h03:b]X0k02l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7
V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[jP3G
f>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX
00<0IVIn09FDZ`3AdMh00P3lo?c/0?ooo`80o?cl00<0dM7N09FDZ`1VIWh0
0P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW_`3[0:RW_`0409FDZ`28
Qid0IVIn06IVOP<0F5MX000505QGJ?00IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[7]:=",
  Evaluatable->False,
  ImageSize->{250, 150},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutOptions"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]=",
  CellTags->"LayoutOptions"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Alignment\"", "SubsubsectionIcon",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "The ",
  StyleBox["\"Alignment\"", "Output"],
  " suboption is supported both for ",
  StyleBox["Widget", "Output"],
  " and ",
  StyleBox["WidgetGroup", "Output"],
  " and can be used to specify both horizontal and vertical alignments. The \
default alignment value along the vertical axis is ",
  StyleBox["Left", "Output"],
  " and can take values of ",
  StyleBox["Left", "Output"],
  ", ",
  StyleBox["Center", "Output"],
  " or ",
  StyleBox["Right", "Output"],
  ", and alignment on the horizontal axis defaults to ",
  StyleBox["Center", "Output"],
  ", allowing values of ",
  StyleBox["Top", "Output"],
  ", ",
  StyleBox["Center", "Output"],
  ", or ",
  StyleBox["Bottom", "Output"],
  ".  Using ",
  StyleBox["Automatic", "Output"],
  " for either of these axeswill choose the appropriate default."
}], "Text",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Alignment\" -> {Automatic, Automatic}", "Output"],
  " is equivalent to ",
  StyleBox["\"Alignment\" -> {Left, Center}", "Output"],
  "."
}], "FramedBox",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "Uses of ",
  StyleBox["\"Alignment\" ", "MR"],
  "suboption."
}], "Caption",
  CellTags->"LayoutOptions"],

Cell["\<\
It is very common to have a set of labels for text fields right align with \
the corresponding input fields.\
\>", "Text",
  CellTags->"LayoutOptions"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
\[IndentingNewLine]WidgetGroup[{\[IndentingNewLine]{Widget["\<Label\>", \
{"\<text\>" -> "\<One:\>"}, \ 
                    WidgetLayout \[Rule] {"\<Alignment\>" \[Rule] {Right, \ 
                            Automatic}}], \
\[IndentingNewLine]Widget["\<TextField\>", {"\<text\>" -> "\<A content\>"}]}, \
\[IndentingNewLine]{Widget["\<Label\>", {"\<text\>" -> "\<OneLonger:\>"}, \ 
                    WidgetLayout \[Rule] {"\<Alignment\>" \[Rule] {Right, \ 
                            Automatic}}], \
\[IndentingNewLine]Widget["\<TextField\>", {"\<text\>" -> "\<B content is the \
largest of all\>"}]}\[IndentingNewLine]}, \ 
              WidgetLayout \[Rule] 
                Grid]\[IndentingNewLine]]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"LayoutOptions"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"LayoutOptions"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003H0000CB000`400?l0
0000o`00003of01VIWh0000306IVOP3ko?d0nocm0=@0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0=<0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
dP1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS`0h=oS
U02U[;800`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
?03Pgn<00`2U[;80oooo0?ooo`2@0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWhl0>3Oh`030:F//P3oool0oooo0900
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OS`0h=oS00<0YJbb0?ooo`3oool0T03oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn9P3Pgn<400000180h=oS00<0YJbb
0?ooo`3oool0G@3oool4000002l0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVORX0h=oS00<000000>3Oh`3Pgn<03`3P
gn<00`2U[;80oooo0?ooo`1Q0?ooo`030000003oool0oooo02`0oooo00@0
YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS
0`0000030>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<300000080
h=oS1@0000020>3Oh`<000000P3Pgn<01@000000h=oS0>3Oh`3Pgn<00000
0080h=oS0P000000103Pgn<000000>3Oh`3Pgn<300000080h=oS00D00000
0>3Oh`3Pgn<0h=oS000000050>3Oh`030:F//P3oool0oooo00<0oooo1@00
00060?ooo`<000000`3oool300000080oooo00H000000?ooo`3oool0oooo
0000003oool200000080oooo0`0000020?ooo`060000003oool0oooo0?oo
o`000000oooo0P0000040?ooo`030000003oool0oooo00<000001@3oool2
000000030?ooo`000000oooo0080oooo00<000000?ooo`3oool00`000005
0?ooo`030000003oool0oooo0080000000@0oooo0000003oool00000103o
ool2000000040?ooo`000000oooo0?ooo`<000000`3oool300000080oooo
0P0000050?ooo`<000000`3oool00`000000oooo0?ooo`040?ooo`800000
00H0oooo0000003oool000000?ooo`0000050?ooo`040:F//P1VIWh0Z:Vk
0?_lo@40IVIn00001P1VIWh0nocm0:RY^`1VIWh0h=oS000000<0h=oS00@0
00000>3Oh`3Pgn<000000`3Pgn<00`000000h=oS000000030>3Oh`030000
003Pgn<0000000D0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<00000
00<0h=oS00<000000>3Oh`0000000P3Pgn<2000000030>3Oh`000000h=oS
0080h=oS00<000000>3Oh`0000002@3Pgn<00`2U[;80oooo0?ooo`030?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool01`00
0000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`030000003oool000000080oooo00L000000?ooo`3oool0oooo
0000003oool0000000<0oooo00<000000?ooo`0000001@3oool00`000000
oooo000000030?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool000000`3oool00`000000oooo000000030?ooo`030000003oool0oooo
0080oooo00<000000?ooo`0000000P3oool2000000030?ooo`000000oooo
0080oooo00<000000?ooo`3oool00P0000000`3oool000000?ooo`020?oo
o`030000003oool0000000<0oooo00<000000?ooo`0000001@3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`02000000040?ooo`000000oooo000000D0oooo00@0
YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000
1@3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000D0h=oS
00<000000>3Oh`3Pgn<00`3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3O
h`0000000`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<00000
00D0h=oS00<000000>3Oh`3Pgn<01`3Pgn<00`2U[;80oooo0?ooo`030?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`030?ooo`070000003oool0oooo0?ooo`000000oooo0000
00030?ooo`030000003oool000000080oooo00<000000?ooo`3oool00`3o
ool01`000000oooo0?ooo`3oool000000?ooo`0000001@3oool00`000000
oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3o
ool000000`3oool00`000000oooo000000080?ooo`030000003oool00000
00<0oooo00<000000?ooo`0000000`3oool01`000000oooo0?ooo`3oool0
00000?ooo`000000203oool010000000oooo0?ooo`0000050?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`09
0000003oool0oooo0?ooo`000000oooo0000003oool0000000D0oooo00@0
YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000
1@3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000@00000
00<0h=oS0000003Pgn<0103Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3O
h`0000000`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<00000
00@0000000<0h=oS0000003Pgn<0203Pgn<00`2U[;80oooo0?ooo`030?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`030?ooo`070000003oool0oooo0?ooo`000000oooo0000
00030?ooo`030000003oool000000080oooo1@0000000`3oool000000?oo
o`020?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool00P00
00060?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`000000
100000040?ooo`030000003oool0oooo00@0000000<0oooo0000003oool0
0P3oool01P000000oooo0?ooo`3oool000000?ooo`D000000P3oool20000
00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0
00000080oooo00<000000?ooo`3oool0103oool4000000040?ooo`000000
oooo000000D0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP0000001@3Pgn<010000000h=oS0000000000020>3Oh`03
0000003Pgn<0000000<0h=oS00<000000>3Oh`0000001@3Pgn<01P000000
h=oS0>3Oh`3Pgn<000000>3Oh`8000000P3Pgn<00`000000h=oS00000002
0>3Oh`80000000<0h=oS0000003Pgn<00P3Pgn<010000000h=oS00000000
00080>3Oh`030:F//P3oool0oooo00<0oooo1@0000050?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`040000003oool000000000
0080oooo00<000000?ooo`0000000P3oool01P000000oooo0?ooo`3oool0
00000?ooo`8000000P3oool00`000000oooo000000050?ooo`030000003o
ool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0200000080oooo00<000000?ooo`0000000`3oool00`000000oooo0?oo
o`020?ooo`030000003oool0000000<0oooo00@000000?ooo`0000000000
0P3oool00`000000oooo0?ooo`02000000030?ooo`000000oooo0080oooo
00<000000?ooo`0000000`3oool00`000000oooo000000050?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`09
0000003oool0oooo0?ooo`000000oooo0000003oool0000000D0oooo00@0
YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000
1@3Pgn<010000000h=oS0000003Pgn<2000000<0h=oS0`0000020>3Oh`03
0000003Pgn<0h=oS00@0h=oS0`0000020>3Oh`040000003Pgn<000000000
00<0h=oS0P000000103Pgn<000000>3Oh`3Pgn<300000080h=oS00D00000
0>3Oh`000000h=oS000000050>3Oh`030:F//P3oool0oooo00<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`<000000`3o
ool300000080oooo00D000000?ooo`00000000000?ooo`0300000080oooo
0`0000020?ooo`050000003oool000000000003oool00`0000040?ooo`03
0000003oool0oooo00<00000103oool3000000030?ooo`000000oooo0080
00000`3oool3000000D0oooo00<000000?ooo`3oool00`0000020?ooo`03
0000003oool000000080oooo0P000000103oool000000?ooo`3oool30000
00<0oooo0`000000103oool000000000000000050?ooo`<000000P3oool3
000000D0oooo0`0000020?ooo`030000003oool0000000D0oooo00@0YJbb
06IVOP2XZK/0nocm0@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3Pgn<00000
0`3Pgn<00`000000h=oS0>3Oh`0<0>3Oh`030000003Pgn<0h=oS02D0h=oS
00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0>0?ooo`040000003oool0oooo000000h0oooo00<000000?ooo`3o
ool06`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`0000001@3oool0102U[;80IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<3000000l0h=oS00<000000>3O
h`3Pgn<09@3Pgn<00`2U[;80oooo0?ooo`030?ooo`D000005`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0203oool010000000oooo0?ooo`00000>0?ooo`030000003oool0
oooo01/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0000000D0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOS`0h=oS00<0YJbb0?ooo`3oool0T03o
ool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
?03Pgn<00`2U[;80oooo0?ooo`2@0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWhl0>3Oh`030:F//P3oool0oooo0900
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OS`0h=oS00<0YJbb0?ooo`3oool0T03oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn?03Pgn<00`2U[;80oooo0?ooo`2@
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWhl0>3Ohi@0YJbb00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVO]00h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVO]00h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVO]00h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOS`0h=oSU02U[;800`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn?03Pgn<00`2U[;80oooo0?ooo`2@0?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhl0>3Oh`030:F/
/P3oool0oooo0900oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOS`0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000
oooo0?ooo`2:0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0
nocm0:RY^`1VIWhl0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?oo
o`3oool0RP3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn?03Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0
oooo08X0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOR@0h=oS0`0000030>3Oh`050000003Pgn<0h=oS0>3Oh`000000
0P3Pgn<300000080h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`2U[;80oooo
0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
0`3oool3000000<0oooo0`0000020?ooo`060000003oool0oooo0?ooo`00
0000oooo0P0000020?ooo`<000000P3oool01P000000oooo0?ooo`3oool0
00000?ooo`800000G`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn8`3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080
h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<00000
0>3Oh`3Pgn<01@3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00P3oool01`000000oooo0?ooo`3o
ool000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000
003oool000000080oooo00L000000?ooo`3oool0oooo0000003oool00000
00<0oooo00<000000?ooo`000000H03oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn8P3Pgn<00`000000h=oS0>3Oh`03
0>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000002`3Pgn<0
0`2U[;80oooo0?ooo`030?ooo`H000001@3oool00`000000oooo0?ooo`03
0?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000
003oool000000080oooo00<000000?ooo`3oool00`3oool01`000000oooo
0?ooo`3oool000000?ooo`000000H03oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn8P3Pgn<00`000000h=oS0>3Oh`03
0>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`00000010000007
0>3Oh`030:F//P3oool0oooo00<0oooo0P0000030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00`3oool01`000000oooo0?ooo`3o
ool000000?ooo`0000000`3oool00`000000oooo000000020?ooo`D00000
00<0oooo0000003oool00P3oool00`000000oooo0000001P0?ooo`040:F/
/P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhR0>3Oh`03
0000003Pgn<0h=oS00<0h=oS00@000000>3Oh`00000000000P3Pgn<00`00
0000h=oS000000030>3Oh`030000003Pgn<0h=oS00D0h=oS00<0YJbb0?oo
o`3oool00`3oool01@000000oooo0000003oool0000000H0oooo00L00000
0?ooo`3oool0oooo0000003oool0000000<0oooo00@000000?ooo`000000
00000P3oool00`000000oooo000000020?ooo`060000003oool0oooo0?oo
o`000000oooo0P0000020?ooo`030000003oool000000600oooo00@0YJbb
06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOR80h=oS00<0
00000>3Oh`3Pgn<00`3Pgn<010000000h=oS0000003Pgn<2000000<0h=oS
0`0000020>3Oh`030000003Pgn<0h=oS00<0h=oS00<0YJbb0?ooo`3oool0
0`3oool01@000000oooo0000003oool0000000L0oooo0`0000030?ooo`<0
00000P3oool01@000000oooo000000000000oooo00<000000P3oool30000
0080oooo00D000000?ooo`00000000000?ooo`03000005l0oooo00@0YJbb
06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOR<0h=oS00D0
00000>3Oh`3Pgn<0h=oS0000000D0>3Oh`030:F//P3oool0oooo00<0oooo
00D000000?ooo`000000oooo0000000H0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0GP3oool0102U[;80IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn903Pgn<3000001D0h=oS00<0YJbb0?oo
o`3oool00`3oool010000000oooo0?ooo`00000I0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool0GP3oool0102U[;80IVIn0:RY^`3k
o?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn?03Pgn<00`2U[;80oooo0?oo
o`030?ooo`030000003oool0oooo08X0oooo00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS`0h=oS00<0YJbb0?ooo`3oool0
0`3oool00`000000oooo0?ooo`2:0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWhl0>3Oh`030:F//P3oool0oooo00<0
oooo00<000000?ooo`3oool0RP3oool0102U[;80IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn?03Pgn<00`2U[;80oooo0?ooo`030?oo
o`030000003oool0oooo08X0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOS`0h=oS00<0YJbb0?ooo`3oool0T03oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn?03P
gn>D0:F//P0306IVOP2XZK/0nocm0040IVIn00000`1VIWh0moOi09RHY`3B
07MgTP40V9RW0@3gmoT106IVOP0000<0IVIn0?Ogn@2l_Ld0d`2l_Ld10?Og
n@40IVIn00000`1VIWh0moOi0>CSh`3C0>CSh`40moOi0@1VIWh0000306IV
OP3`lO@0oooo08`0oooo00<0i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?
06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0
101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0
W:Bi102V>D@0102W>T@0YSU40:LjA02W>T@90:HiA00309bT^@3/j^X0oooo
00<0oooo0@3`lO@106IVOP0001H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0
no_m0?_lo@3ko?`0o?cm0?clo03lnod0o?cl0?cko03lo?`0nocl0?clo03k
o?d0o?_l0?clo@3knod0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?dc0?ck
o3<0nocl3@3ko?d00`2LY;T0JgF?08F9/00@08F9/00606]eS`2LY;T0nocm
0?_lo@2LY;T0JgF?4@25RK001P1[MHl0W:Bi0?_lo03kno`0W:Bi0:HiA140
ZSaE00L0YSU409bT^@3ko?`0o?cl0?cko@3ko?d0h^7R0040IVIn0000101V
IWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0moOh
0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3gmoT0103gm_P0m_Oh0?Kgn@3gmoT3
0?Kgn@030?Kgn03gmoT0moOi0380moOi<`3fmoT=0?Ogn@0306]eS`25RK00
W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi06]eS`25RK0A09bN_P0808F9
/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=0<IEG0090<IDFP32DU/0
ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q0040IVIn00001P1VIWh0g]gQ
0?7am03alO@0l?7d0?3bm100000000H0lO7d0?3bm@3alO@0lO;d0?3bm03a
lOAV0?3am@d0l?7d00<0JgF?0;:ed02WZ<80402WZ<801P2b]M00JgF?0?3a
m03`lO@0JgF?0;:ed140YjS200D0/[G@06]eS`3`lOD0lO;d0:HiA0020<9B
F`030<]DF@3=FEh0cEUN00/0cEUN00@0beAI0<9BF`32DU/0YSU40P3`lO@0
0`3alO@0l?;d0=kMh@0106IVOP0000L0IVIn0=cKh03Zjo00j^_`0>[/l03Y
jnl000000080inOW0P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0inOW0P3_
knl010000000j^_`0>[[l03Zjnl20>[[l0030>[[k`3Zjo00j^_`0340j^_`
<`3Zk?0=0>[[k`0406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk60:b^aP2]
[/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`0406]eS`2f^M40[Jk60:f^
aP`0oooo0P2][/H00`2/[/H0][WA06]eS`020>[[l0050:HiA03=FEh0beAI
0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK0<]DF@3=FEh0YSU40>[[k`3Zjo00
0P3Zjnl10=cKh040IVIn0000101VIWh0fMWO0>?UjP3Si>X20>?Uj`050000
002<S8`0g]kN0>OWi`3Ng]h00P3WinL00`36H`00inOW0>OWi`020>OWi`07
0>o_i`3_knl0kno_0000003Si>X0hnC[0>?UjP020>?TjP030>?Tj`3SiN/0
hnG[0340hnG[<`3Si>X=0>?UjP0506]eS`2l_]@0/[;:0;:bbP3oool01P1^
KHl00`0U9CH0/[;:0;:bbP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[MHl0
_;kD0P2b//X00`3oool09BDf02DU=P0902DU=P<0/[;:00D0_;kD06]eS`3S
i>/0hnC[0:HiA0020<eIGP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3oool0
2P3DG5l0d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl106IV
OP0000<0IVIn0=OHgP3Lg^H00`3Lg^H01@000000inOW0>OWi`3WinL0imK>
0080inOW00D0cW/00>nD403WinL0imk60>n<40030>o_k`070000003Lg^H0
g=kU0=cNi@3Lg^H0g=kU0=cNiP1c0=cNi@0506]eS`2o`MH0^;W>0;RicP3o
ool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU0=cN
i@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U9CH0
^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C
9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA0020=cN
i@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>420=GH
h0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080gV/0
00D0kkF<0>o_k`3_knl0kno_000000020=GHh@040=GGh03Ff>00e]SQ0=KG
hC<0e]OP<`3Ff>0=0=GHh@0506]eS`33aMT0_;gA0;bmd@3oool01`0U9CH7
0;bmd@060<?5f@1[MHl0eMSQ0=GHh@1[MHl0`lGI0P2l_M400`3oool09BDf
0;bmd@070;bmd@030?ooo`0U9CH0_;gA0080_;gA00D0`lGI06]eS`3Fen00
eMOQ0:HiA0020=EMH0030=QPH@3IHF80AQhJ00<0oooo0`3IHF830?ooo`03
04HN6P3IHF80f61Q0080eEeP00H0YSU40=KHh03Ef>40eMOP0=GHh@3Ee]d1
06IVOP0000L0IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@d]`0000000<0inOW00`0
imk>0<I:003gcP00kjd00>ne003>J`00aUX00<I[003NS4X0ijD00>oWcP00
00030=3Bg0030<oBg03@d]`0cm;L03<0d=;L<`3?d]d=0=3Bg00306]eS`38
bM/0`lCF0100`lCF00H0b<WK06]eS`3@d]`0d=;L06]eS`38bM/20<?4eP03
0?ooo`0U9CH0`lCF00L0`lCF00<0oooo02DU=P33a=H00P33a=H01`38bM/0
JgF?0<oBg03?d]`0YSU40=MOG`3IHF800`3LIFD01@167QX0oooo0?ooo`3o
ool0g6EU00<0oooo00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0YSU40=3B
g@80d=;L0@3?d]`10=;Dg@40IVIn0000701VIWh0d=;K0<_=f03:cMT0blkH
0<[=f0000000ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU003FS000
cV/00>O6003oeP00knoW0>o_k`000000blgH0<_=f@3:cMT0blkH0<[=f03;
cMPc0<_=fC<0blkI3@3;cMP00`1[MHl0blcN0<S:f@080<S:f@030<S9f@38
b]T0b<[I00<0b<[I00@0b<WI0<S:f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN
0<S:f@38b]T0oooo02DU=PD0b<[I0140b<WI0<S:f@38b]T0oooo02DU=P38
b]T0b<WI0<S:f@3;c=h0JgF?0<_>f03:cMP0YSU40=MOG`3KI6@0h6MU0>1V
I@020=iWI`0304HN6P3oool0oooo00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU
0>1WI@3KI6@0eemO0:HiA03:c]P0b/kI0P3;cMT10=3Bf`40IVIn00000`1V
IWh0cloJ0<G8e0030<G8e00600000036a/H0imkF0<ik003W[@00kkD00P3W
Y@000`3FU000cW<00=JD00020?O60080moOg00@000000<G8e035am@0aLOD
0`35amDc0<C7eC<0a<SD3@34am@00`1[MHl0d=7P0<_;g00@0<_;g0060=3A
h01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3oool09BDf0<_;g0070<_;
g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]eS`35am@0a<OD0:HiA03K
I6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo04HN6P050>1ZJ0040=mU
I03KI6@0YSU40<C8e@80a<SD0@35amD10<o?fP40IVIn0000101VIWh0c<kJ
0<;4dP31a=420<74dP060000003WinL0inOW0>OWi`3FQ000kkD00P3WY@00
203FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL000000`31a=800`32a=40
`LCB0<74dP0c0<74dC<0`LCB3@32a=800`1[MHl0dm?R0<o@g@0@0<o@g@06
0=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?d=d00`3oool09BDf0<o@g@07
0<o@g@030?ooo`0U9CH0cm3M0080cm3M00L0dm?R06]eS`32a=80`LCA0:Hi
A03KI6@0hFUU00D0h6aY1@3oool50>1/J@080>5YI@3KI6@0YSU40<74dP32
a=40`LCA0<74dP3<c]X106IVOP0000@0IVIn0<[<f02n`<l0_L3?0P2n`<h0
1@000000W9bL0>OWi`3Wg]H0eX`00080gY@000@0eW/00<IS002m@P00kjD0
0P3g[@00203g]@00oli:0000002n`<h0_/3?0;k0cP2n`<l0_L3>=02n`<hc
0;g0cPd0_/3>00<0JgF?0=KFi03Cdn00403Cdn001P3Fe^@0JgF?0;k0cP2n
`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3oool0203oool02`0U9CH0dm?P
0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:HiA03PIVD0hFYZ00@0hfa/0`3o
ool010167QX0oooo0?ooo`3oool40>=/K0040>5ZJP3PIVD0YSU40;g0c`80
_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0bL[H0;Jhb02i_</0^[c;0;Zl
c00000000P3_knl04`3FW000eX`00=jD003FQ000kjD00=j<002mFP00eW<0
0>nL003gknL0moOg0?ooo`000000^Kc<0;Zkc02i_</0^[c;0;Vlc02i_</0
<`2i_<`c0;Zlc0d0^[c;00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?
0;Zlb`2j_</0JgF?0=SHi@80dm?Q00<0oooo06i]S`1^KHl0201^KHl03P0U
9CH0dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<0:HiA03PJFP0hFe/0>Aa
K@3TLFl0i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^00T0i75]
0>5]K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039b]P00@1VIWh0000906IV
OP37bML0];K70;Jhb02f^<T0][W900000024Q8@0inON0080kno_00L0aV/0
0?O6003_]@00ki`00=j<003>J`00ii`000<0moOg00D000000;Jib@2g^<T0
][W90;Nib@020;JhbC<0]kS9<`2f^<T=0;Nhb@0406]eS`3Fe^@0f=SU0=SH
iP<0f=SU1@3Hf>H30=SHi@80f=SV0P3Hf>D02@3Fe^@0JgF?0;Nhb@2g^<T0
JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]S`0=02DU=P3Hf>H0f=SU0=SHi@3F
e^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3TM6l0ig5_0>AdK`030?ooo`0504HN
6P3TM6l0i7A_0>AdK`167QX00`3oool02P3TM6l0ig5_0>AdK`3TKVd0YSU4
0;Jib@2f^<T0][W90;Bfa`37bML106IVOP0000<0IVIn0<K8e`2d]/L00`2d
]/L00`000000kno_0>o_k`020>o_k`0;0>N]003gaPP0ijD00>ND003WS000
knOF0=jD>@3_e[D0ooOg0?ooo`000000N@2d]/L01@1[MHl0eMGS0=cKi`3L
fnL0gM_W00h0g=_W00H0eMGS06]eS`2d]/L0];K706]eS`3EeN<20=cKi`03
0=gKi`0U9CH09BDf00T09BDf0`3LfnL02@3EeN<0JgF?0;Bfa`2d]/L0YSU4
0>McK`3WMG80jWIc0>YhMP020?ooo`0304HN6P3YOWP0jGih00<0jGih00P0
AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80ig=_0:HiA0@0];K70@36b=L106IV
OP0000<0IVIn0<K8e`2d]/L00`2d]/L01P000000S8b<0>o_k`3_knl0ilik
0>o_k`80moOg00P0ii@00?OWcP3gmoL0moOg0>oWeP3gmoL0oooo000007T0
];K700<0JgF?0=GDh`3PgnX0403PgnX01P3Ee><0JgF?0;Bfa`2d]/L0JgF?
0=GDha40h=oZ00T0eMCS06]eS`2d]/L0];K70:HiA03ZNG<0jGah0>n1NP3b
RH400P167QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<0>fGRP3[V8/00P167QX0
1@3bRH40kh5j0>UlN03ZNG<0YSU400@0];K70@36b=L106IVOP0000<0IVIn
0<K8e`2a/lP00`2a/lP01P000000kno_0>o_k`3_knl0moO_0>o_k`80moOg
00<0mnO60?Ogm`3oool00`3gmoL00`3oool000000;6cb01h0;6cb00306]e
S`3]jo<0jNSa0100jNSa00H0kN_c06]eS`2a/lP0/K?806]eS`3]jo<A0>WX
l@0I0>g[l`1[MHl0/K?80;6cb02V>D@0lH1e0?24O03eS8@0mif>0?:[UP3a
/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03bZiH0mif>0?F<
Q03`Q7`0lH1e0:HiA0040;6cb040a/SG0@1VIWh0000306IVOP36b=L0^;O?
00<0[jk700D000000:f][@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3oool0
0`000000[jk70:n^a`1g0:n^a`0306]eS`3BdN<0l_7g0100l_7g00H0d]7S
06]eS`2_[/L0[jk706]eS`3BdN<A0?;am`060=;Ah`1[MHl0[jk70:n^a`2V
>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0m8Ym0:HiA02_[/L00P2_[/L10;Rg
c`40a/SG0@1VIWh0000306IVOP30`M40alOD08`0[:_400@0Q8bR06]eS`3<
bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a00408B<XP1[MHl0
c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01`2AV:X0YSU4
0?nOS@3n_j@0n]bg0?[[]`3jjKH00P3ijKH0103jjKH0nNVf0?WY]P3jjKH2
0?WY]P060?[[]`3jg;L0o[nT0?nOS@2V>D@0TIRZ0`2/Zl@10<O7e040`<7A
0@1VIWh0000406IVOP30`M40d];O0;FdbH`0Y:>n00<0Q8bR06]eS`1[MHl0
3`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP1[MHl0JgF?00l0JgF?
00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80YSU40:HiA00?0:HiA00708B<
XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31d@0106IVOP0000H0IVIn0:RW_`3V
i^d0d];P0;blc`2a/<C<0:RW_`050;6`a02l_<l0d];P0>KVk@2XYkl00@1V
IWh0000705QGJ027Qi/0emSR0?clo03ThnP0d=3P0<[:fP3:0;blc`060<[:
fP3@d>00i>?X0?clo03Gf>80QhNK0@1HEfP0000805QGJ01VIWh0UIB[0=OH
hP3lo?`0l_7c0>c[kP3Qh^_80=OHhP070>7Rj`3/jnh0l_7c0?clo03Gf>80
UIB[06IVOP0105QGJ0000P1HEfP00`1VIWh0UIB[0=7AgP020?clo<X0oooo
0P3lo?`00`3AdMh0UIB[06IVOP0205QGJ0000`1HEfP206IVOP0308R7W@2E
U:/0Z:No0<T0Z:No00@0UIB[08R7W@1VIWh0IVIn0`1HEfP000D0F5MXcP1V
IWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[9]:=",
  Evaluatable->False,
  ImageSize->{216, 77},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutOptions"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]=",
  CellTags->"LayoutOptions"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Border\"", "SubsubsectionIcon",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "The ",
  StyleBox["\"Border\"", "Output"],
  " suboption is a convenient way of building common border styles around \
groups of widgets.  Three common types include borders specifying spacing \
only, a titled border with a name and ruled frame, and a simple line border \
with a thickness and optional color value."
}], "Text",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "\[FilledSmallSquare] ",
  StyleBox["\"Border\" -> ", "Output"],
  StyleBox["\"title\"", "Text",
    FontSlant->"Italic"],
  " creates a titled border style with a ruled outline.\n\
\[FilledSmallSquare]",
  StyleBox["\"Border\" -> {{", "Output"],
  StyleBox["left", "Text",
    FontSlant->"Italic"],
  StyleBox[", ", "Output"],
  StyleBox["right", "Text",
    FontSlant->"Italic"],
  StyleBox["},{", "Output"],
  StyleBox["top", "Text",
    FontSlant->"Italic"],
  StyleBox[", ", "Output"],
  StyleBox["bottom", "Text",
    FontSlant->"Italic"],
  StyleBox["}} ", "Output"],
  "specifies a border of spacing different for each of the four edges.\n \
\[FilledSmallSquare] ",
  StyleBox["\"Border\" -> ", "Output"],
  StyleBox["n", "Text",
    FontSlant->"Italic"],
  StyleBox[" ", "Output"],
  "creates a spacing border of equal margins in all directions.",
  StyleBox["\n",
    FontSlant->"Italic"],
  "\[FilledSmallSquare] ",
  StyleBox["\"Border\" -> {", "Output"],
  StyleBox["color", "Text",
    FontSlant->"Italic"],
  StyleBox[", ", "Output"],
  StyleBox["n", "Text",
    FontSlant->"Italic"],
  StyleBox["}", "Output",
    FontSlant->"Italic"],
  StyleBox[" ", "Output"],
  "creates a framed line border of thickness ",
  StyleBox["n ",
    FontSlant->"Italic"],
  "with",
  StyleBox[" color.\n",
    FontSlant->"Italic"],
  "\[FilledSmallSquare] ",
  StyleBox["\"Border\" -> {", "Output"],
  StyleBox["color", "Text",
    FontSlant->"Italic"],
  StyleBox[", {{", "Output"],
  StyleBox["left", "Text",
    FontSlant->"Italic"],
  StyleBox[", ", "Output"],
  StyleBox["right", "Text",
    FontSlant->"Italic"],
  StyleBox["},{", "Output"],
  StyleBox["top", "Text",
    FontSlant->"Italic"],
  StyleBox[", ", "Output"],
  StyleBox["bottom", "Text",
    FontSlant->"Italic"],
  StyleBox["}}", "Output"],
  StyleBox["}", "Output",
    FontSlant->"Italic"],
  StyleBox[" ", "Output"],
  "creates a framed line border of different edge thicknesses",
  StyleBox[" ",
    FontSlant->"Italic"],
  "with ",
  StyleBox["color",
    FontSlant->"Italic"],
  ".",
  StyleBox["\n",
    FontSlant->"Italic"],
  "\[FilledSmallSquare] ",
  StyleBox["\"Border\" -> {", "Output"],
  StyleBox["border", "Text",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  StyleBox[", ", "Output"],
  StyleBox["border", "Text",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\_2\)]],
  ", ...",
  StyleBox["}", "Output",
    FontSlant->"Italic"],
  StyleBox[" ", "Output"],
  StyleBox["creates a compound border style with each of any possible border \
styles nested together", "Text"],
  "."
}], "FramedBox",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "Uses of ",
  StyleBox["\"Border\" ", "MR"],
  "suboption."
}], "Caption",
  CellTags->"LayoutOptions"],

Cell["Here is a simple titled border.", "Text",
  CellTags->"LayoutOptions"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
\[IndentingNewLine]WidgetGroup[{\[IndentingNewLine]{Widget["\<Label\>", \
{"\<text\>" -> "\<Label:\>"}], \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<Input\>"}]}\ \[IndentingNewLine]\ }, \ 
              WidgetLayout \[Rule] {"\<Border\>"\  -> "\<TitleName\>"}]\ ]\
\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"LayoutOptions"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"LayoutOptions"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000DB000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS
K`3oool20>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh20>3Ohfh0W9bN00H0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`0Q0>3OhdL0YJbb0P3Pgn<01`2LW9h0
oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP80h=oS00<0W9bN0?ooo`3Pgn<08@3Pgn<00`2U[;80oooo0?ooo`13
0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3O
h`0Q0>3Oh`030:F//P3oool0oooo04<0oooo00D0YJbb0>3Oh`3Pgn<0W9bN
0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh20>3Oh`0309bLWP3oool0h=oS0240h=oS00<0YJbb0?ooo`3oool0
0`3oool00`000000oooo0?ooo`0m0?ooo`050:F//P3Pgn<0h=oS09bLWP3o
ool00P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`0Q0>3Oh`030:F//P3oool0oooo00<0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0e0?ooo`05
0:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`0Q0>3O
h`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0e0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
102LW9h0oooo0>3Oh`3Pgn<500000080h=oS0P0000001@3Pgn<000000>3O
h`000000h=oS008000000`3Pgn<300000080h=oS00<000000>3Oh`000000
1@3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0000000<0oooo
00@000000?ooo`000000oooo0P0000030?ooo`80000000<0oooo0000003o
ool00P00000Z0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<01@2L
W9h0oooo0>3Oh`3Pgn<0000000D0h=oS00<000000>3Oh`3Pgn<00P000000
0`3Pgn<00000000000020>3Oh`030000003Pgn<0000000<0h=oS00<00000
0>3Oh`0000001`3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0
000000<0oooo00@000000?ooo`00000000000P3oool00`000000oooo0000
00020?ooo`80000000<0oooo0000003oool0:P3oool01@2U[;80h=oS0>3O
h`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOP80h=oS00D0W9bN0?ooo`3Pgn<0h=oS000000050>3Oh`07
0000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0
000000D0h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`2U[;80oooo0?ooo`03
0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool0
0`000000oooo000000030?ooo`030000003oool0000002/0oooo00D0YJbb
0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWh20>3Oh`0509bLWP3oool0h=oS0>3Oh`000000
1P3Pgn<4000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`000000
100000000`3Pgn<000000>3Oh`060>3Oh`030:F//P3oool0oooo00<0oooo
00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000
003oool0000000<0oooo00<000000?ooo`000000:`3oool01@2U[;80h=oS
0>3Oh`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOP80h=oS00D0W9bN0?ooo`3Pgn<0h=oS000000050>3O
h`060000003Pgn<0h=oS0>3Oh`000000h=oS0P0000020>3Oh`030000003P
gn<0000000<0h=oS00<000000>3Oh`0000001`3Pgn<00`2U[;80oooo0?oo
o`030?ooo`040000003oool0000000000080oooo00@000000?ooo`000000
00000P3oool00`000000oooo000000030?ooo`030000003oool0000002/0
oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0509bLWP3oool0h=oS
0>3Oh`0000001P3Pgn<300000080h=oS00@000000>3Oh`00000000000`3P
gn<300000080h=oS00<000000>3Oh`0000001@3Pgn<00`2U[;80oooo0?oo
o`030?ooo`040000003oool000000?ooo`8000000P3oool010000000oooo
0000000000020?ooo`040000003oool0oooo0?ooo`@00000:P3oool01@2U
[;80h=oS0>3Oh`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOP80h=oS00D0W9bN0?ooo`3Pgn<0h=oS0000
000;0>3Oh`030000003Pgn<0h=oS00T0h=oS00<000000>3Oh`3Pgn<01@3P
gn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool0:@3oool01@2U[;80h=oS0>3Oh`2LW9h0oooo0080h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS
00D0W9bN0?ooo`3Pgn<0h=oS0000000;0>3Oh`030000003Pgn<0h=oS00T0
h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`2U[;80oooo0?ooo`030?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0:@3oool01@2U[;80
h=oS0>3Oh`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<08@3Pgn<00`2U
[;80oooo0?ooo`030?ooo`030000003oool0oooo03d0oooo00D0YJbb0>3O
h`3Pgn<0W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS0240h=oS00<0YJbb
0?ooo`3oool00`3oool00`000000oooo0?ooo`0m0?ooo`050:F//P3Pgn<0
h=oS09bLWP3oool00P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`0Q0>3Oh`030:F//P3o
ool0oooo00<0oooo00<000000?ooo`3oool0?@3oool01@2U[;80h=oS0>3O
h`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<08@3Pgn<00`2U[;80oooo
0?ooo`030?ooo`030000003oool0oooo03d0oooo00D0YJbb0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS0240h=oS00<0YJbb0?ooo`3o
ool0@`3oool01@2U[;80h=oS0>3Oh`2LW9h0oooo0080h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?oo
o`3Pgn<08@3Pgn=70:F//P80h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3o
ool0h=oS06X0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS06X0
h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS06X0h=oS00L0W9bN
0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh20>3Oh`0309bLWP3oool0h=oS06X0h=oS00L0W9bN0?ooo`3Pgn<0
h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3O
h`0309bLWP3oool0h=oS06X0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3o
ool0h=oS06X0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS06X0
h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS06X0h=oS00L0W9bN
0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh20>3Oh`0309bLWP3oool0h=oS00H0h=oS00H000000>3Oh`3Pgn<0
h=oS0000003Pgn<2000000040>3Oh`000000h=oS0>3Oh`<000000P3Pgn<0
0`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS0080000000@0h=oS
0000003Pgn<000000P3Pgn<010000000h=oS0>3Oh`0000020>3Oh`<00000
>P3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<01P3Pgn<01`00
0000h=oS0>3Oh`3Pgn<000000>3Oh`0000000P3Pgn<00`000000h=oS0000
00030>3Oh`030000003Pgn<0000000<0h=oS0P000000103Pgn<000000>3O
h`3Pgn<2000000050>3Oh`000000h=oS0>3Oh`0000000P3Pgn<00`000000
h=oS000000030>3Oh`030000003Pgn<0h=oS03L0h=oS00L0W9bN0?ooo`3P
gn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh2
0>3Oh`0309bLWP3oool0h=oS00H0h=oS00L000000>3Oh`3Pgn<0h=oS0000
003Pgn<000000080h=oS00<000000>3Oh`0000001@3Pgn<020000000h=oS
0>3Oh`000000h=oS0000003Pgn<000000`3Pgn<00`000000h=oS00000002
0>3Oh`060000003Pgn<0h=oS0000003Pgn<00000?@3Pgn<01`2LW9h0oooo
0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OP80h=oS00<0W9bN0?ooo`3oool00`3oool30>3Oh`070000003Pgn<0h=oS
0>3Oh`000000h=oS000000020>3Oh`030000003Pgn<0000000@0000000L0
h=oS0000003Pgn<0h=oS0000003Pgn<000000080h=oS100000001@3Pgn<0
00000>3Oh`3Pgn<000000080h=oS00<000000>3Oh`000000100000020>3O
hcL0oooo00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWh20>3Oh`H0W9bN0`3Pgn<01`000000h=oS0>3O
h`3Pgn<000000>3Oh`0000000P3Pgn<00`000000h=oS000000030>3Oh`05
0000003Pgn<000000>3Oh`0000000P3Pgn<00`000000h=oS000000030>3O
h`050000003Pgn<000000000003Pgn<00P000000103Pgn<000000>3Oh`00
00030>3Oh`030000003Pgn<0h=oS03P0W9bN00H0oooo0>3Oh`3Pgn<0IVIn
0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn2`3Pgn<010000000
h=oS0>3Oh`3Pgn<4000000040>3Oh`000000h=oS0>3Oh`<000000P3Pgn<0
0`000000h=oS000000020>3Oh`030000003Pgn<0h=oS00<000000P3Pgn<0
0`000000h=oS000000020>3Oh`040000003Pgn<0h=oS0>3Oh`<00000?P3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn2`3P
gn<00`000000h=oS0>3Oh`030>3Oh`040000003Pgn<0h=oS000000L0h=oS
0P0000030>3Oh`030000003Pgn<0h=oS04l0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPT0h=oS1@000000103Pgn<00000
0>3Oh`0000020>3Oh`030000003Pgn<0h=oS00D0h=oS00<000000>3Oh`3P
gn<00P3Pgn<00`000000h=oS0>3Oh`1?0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040
IVIn00000`1VIWh0moOi09RHY`1e07MgTP40V9RW0@3gmoT106IVOP0000<0
IVIn0?Ogn@2l_Ld0MP2l_Ld10?Ogn@40IVIn00000`1VIWh0moOi0>CSh`1f
0>CSh`40moOi0@1VIWh0000306IVOP3`lO@0oooo02l0oooo00<0i>?S09bT
^@1[MHl00`1[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0
oooo0?ooo`3Thn<0W:Bi101[MHl0101/MY00JgF?06afT01/MY0906]eS`06
09bT^@3Thn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W>T@0YSU40:LjA02W
>T@90:HiA00309bT^@3/j^X0oooo00<0oooo0@3`lO@106IVOP0001H0IVIn
0>;QhP3ko?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0o?cm0?clo03lnod0
o?cl0?cko03lo?`0nocl0?clo03ko?d0o?_l0?clo@3knod0nocl0P3lo?`0
103lo?d0o?cl0?_ko@3lo?dD0?cko080nocl00<0W:Bi06]eS`25RK004025
RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3k
o?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?clo03lnod0nocm
0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi
0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0
moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0C0?Ogn@80m_Oi
00<0JgF?08F9/02LW[h0402LW[h01P25RK00JgF?0?Ogn@3gmoT0JgF?08F9
/140W9jn00P0QHV`06]eS`3fmoP0moOh0:HiA02Z?5D0`U9K0<IDFPd0aUEL
00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>400@1VIWh0
000606IVOP3NgN40lO7d0?7am03`lO@0l?;d400000001P3alO@0l?;e0?7a
m03al_@0l?;d0?7am1H0l?7e00<0JgF?0;:ed02WZ<80402WZ<801P2b]M00
JgF?0?3am03`lO@0JgF?0;:ed140YjS200D0/[G@06]eS`3`lOD0lO;d0:Hi
A0020<9BF`030<]DF@3=FEh0cEUN00/0cEUN00@0beAI0<9BF`32DU/0YSU4
0P3`lO@00`3alO@0l?;d0=kMh@0106IVOP0000L0IVIn0=cKh03Zjo00j^_`
0>[/l03Yjnl000000080inOW0P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0
inOW0P3_knl010000000j^_`0>[[l03Zjnl20>[[l0030>[[k`3Zjo00j^_`
0180j^_`0P3Zk?00101[MHl0][WA0:f^aP2][/H80?ooo`030:f^aP2/[/H0
[Jk600<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0101[MHl0][WA0:f^aP2]
[/H<0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Zjo001@2V>D@0cEUN0<]D
F@3=EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`
0080j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@00
0000S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<00>OWi`3WinL00P3WinL0
1`3_knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[
0>?Uj`0B0>?Uj`80hnCZ00D0JgF?0;bne02b//X0/[;:0?ooo`0606i]S`03
02DU=P2b//X0/[;:00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ06]eS`2l_]@2
0;:bbP030?ooo`0U9CH09BDf00T09BDf0`2b//X01@2l_]@0JgF?0>?Tj`3S
i>/0YSU40080cEUN00@0d5]P0=ALG`3oool0oooo1`3DG5l20?ooo`0:0=AL
G`3@Ff00cEUN0<eIGP2V>D@0hnCZ0>?UjP3Si>X0hnG[0=WIg`40IVIn0000
0`1VIWh0emSN0=cNiP030=cNiP050000003WinL0inOW0>OWi`3We/h00P3W
inL01@3>N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_00L000000=cNiP3Lg^D0
g=kU0=cNiP3Lg^D0g=kV01H0g=kU00D0JgF?0;o1eP2h^Lh0^;W>0?ooo`06
06i]S`0302DU=P2h^Lh0^;W>00D0^;W>00H0_l7F06]eS`3Lg^D0g=kU06]e
S`2o`MH20;RicP030?ooo`0U9CH0^;W>00L0^;W>00<0oooo02DU=P2h^Lh0
0P2h^Lh02@2o`MH0JgF?0=cNiP3Lg^D0YSU40<eIGP3AFUh0e5eQ05<U8003
0?ooo`D0eUmS0`3oool01@1C9B00e5eQ0=5JGP3=FEh0YSU40080g=kU00<0
g=kV0=cNi@3Gf=h00@1VIWh0000406IVOP3Ee]d0eMSP0=KHh@80eMSP00T0
000008b<S03WinL0inOW0>NeQ03FFP00eX@00?o>003>H`000P3NJ`001@3_
]H`0kno_0>o_k`3_knl000000080eMSQ00@0eMOP0=KHh03Ff>40e]OQ503F
en020=KHh00506]eS`33aMT0_;gA0;bmd@3oool01`0U9CH70;bmd@060<?5
f@1[MHl0eMSQ0=GHh@1[MHl0`lGI0P2l_M400`3oool09BDf0;bmd@070;bm
d@030?ooo`0U9CH0_;gA0080_;gA00D0`lGI06]eS`3Fen00eMOQ0:HiA002
0=EMH0030=QPH@3IHF80AQhJ00<0oooo0`3IHF830?ooo`0304HN6P3IHF80
f61Q0080eEeP00H0YSU40=KHh03Ef>40eMOP0=GHh@3Ee]d106IVOP0000L0
IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@d]`0000000<0inOW00`0imk>0<I:003g
cP00kjd00>ne003>J`00aUX00<I[003NS4X0ijD00>oWcP0000030=3Bg003
0<oBg03@d]`0cm;L01@0d=;L0P3?d]d00`1[MHl0b<WK0<?4eP0@0<?4eP06
0<S9f`1[MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP07
0<?4eP030?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:Hi
A03GGel0fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`08
04HN6P3LIFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3B
e=d106IVOP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3W
aX`0mlhH0>nm003gaP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_
i`3_knl000000<_=f03;cMT0b/gI0<_>f03:cMP0blgH503;cMT20<_>f@03
06]eS`3;c=h0b<[I00P0b<[I00<0b<WI0<S:f@38b]T00`38b]T01038bMT0
b<[I0<_<gP1[MHl20<_=f00606]eS`3;c=h0b<[I0<S:f@3oool09BDf1@38
b]T04@38bMT0b<[I0<S:f@3oool09BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0
blkH0<[=f02V>D@0eemO0=]TI03PIfD0h6IU0080gVMW00<0AQhJ0?ooo`3o
ool00`3oool02P167QX0gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0YSU40<[>
f03:c]T20<_=f@40d=;K0@1VIWh0000306IVOP3?cmX0aLSD00<0aLSD00H0
00000<K6aP3Wg]H0cW/00>N]003_]@020>NU00030=JD003>L`00eY@00080
mlH00P3gmoL010000000aLSD0<G7e035am@30<G7eA@0a<OE0P34b=@00`1[
MHl0d=7P0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P0P3;
bm`00`3oool09BDf0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080bl_L00L0
d=7P06]eS`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ0?ooo`3o
ool0oooo04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD0@35amD1
0<o?fP40IVIn0000101VIWh0c<kJ0<;4dP31a=420<74dP060000003WinL0
inOW0>OWi`3FQ000kkD00P3WY@00203FQ000cV/00>N]003g]@00mkd00>o_
k`3gmoL000000`31a=800`32a=40`LCB0<74dP0D0<74d@80`LCB00<0JgF?
0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M
00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@020<o@g@070=?C
hP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203Q
JFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:
c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<00020=jD0004
0=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>BP000000_/3>0;k0c`2n
`<h0_/3?0;g0cQD0_/3>0P2m`<h00`1[MHl0e]KT0=?Ch00@0=?Ch0060=KF
i01[MHl0_/3>0;k0cP1[MHl0e]KT0P3Cdn000`3oool09BDf0?ooo`080?oo
o`0;02DU=P3Cdn00dm?P0=?Ch03Fe^@0JgF?0;k0c`2n`<h0YSU40>1VI@3Q
JVX0103SK6`30?ooo`0404HN6P3oool0oooo0?ooo`@0hfa/00@0hFYZ0>1V
I@2V>D@0_L3?0P2n`<l10;k0cP40b/cH0@1VIWh0000706IVOP39b]P0][S8
0;Vlb`2j_</0^[c<000000020>o_k`0C0=JL003FS000gY@00=J4003_Y@00
gX`00;eJ003FL`00ki`00?O_i`3gmoL0oooo0000002i_<`0^[_<0;Vlb`2j
_</0^Kc<0;Vlb`0D0;Vlc080^[c<00<0JgF?0=SHi@3Cdn40403Cdn401P3H
f>D0JgF?0;Zlb`2j_</0JgF?0=SHi@80dm?Q00<0oooo06i]S`1^KHl0201^
KHl03P0U9CH0dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<0:HiA03PJFP0
hFe/0>AaK@3TLFl0i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^
00T0i75]0>5]K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039b]P00@1VIWh0
000906IVOP37bML0];K70;Jhb02f^<T0][W900000024Q8@0inON0080kno_
00L0aV/00?O6003_]@00ki`00=j<003>J`00ii`000<0moOg00D000000;Ji
b@2g^<T0][W90;Nib@020;JhbA@0]kS90P2f^<T0101[MHl0e]KT0=SHi@3H
f>H30=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0e]KT06]eS`2g^<T0]kS9
06]eS`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0
e]KT06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@16
7QX0i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0i6i]0:Hi
A02f^LT0][S90;Jib@2d]/L0alWG0@1VIWh0000306IVOP36b=L0];K700<0
];K700<000000>o_k`3_knl00P3_knl02`3W[@00mlH80>NU003WU000ih`0
0>oWeP3NU3T0kmJe0?ogm`3oool0000001`0];K700D0JgF?0=GEh`3LfnL0
g=_W0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL0
0`3MfnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS06]eS`2d]/L0];K70:Hi
A03WLfl0igEb0>YfL`3ZN7H00P3oool00`167QX0jGih0>UnN0030>UnN008
04HN6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V>D@40;Bfa`40a/SG0@1V
IWh0000306IVOP36b=L0];K700<0];K700H0000008b<S03_knl0kno_0>O>
N`3_knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_imH0moOg0?ooo`00000L
0;Bfa`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0];K706]e
S`3Ee><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0
lXV10080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ
00D0lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40a/SG0@1VIWh0000306IV
OP36b=L0/K?800<0/K?800H000000>o_k`3_knl0kno_0?Ogk`3_knl20?Og
m`030?OWaP3gmoL0oooo00<0moOg00<0oooo0000002a/lP06`2a/lP00`1[
MHl0kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Y
j?406@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0
lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3e
S8@0l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn00000`1VIWh0a/SG0;Rg
c`030:n^a`050000002][Jd0moO_0?Ogm`3_knl01P3gmoL20?ogm`80oooo
00<000000:n^a`2_[/L06P2_[/L00`1[MHl0d]7S0?;am`0@0?;am`060=;A
h`1[MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0
YSU40?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V>D@0[jk70080[jk70@2h
]ll10<K8e`40IVIn00000`1VIWh0`<7A0<O7e00_0:b[a00408B<XP1[MHl0
c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?
0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400L0TIRZ0:Hi
A03oWhd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf
0P3ijKH01P3jjkL0n]bg0?joY03oWhd0YSU4096HZP<0[:_40@37am@10<31
d@40IVIn0000101VIWh0`<7A0=;Bg`2e]<T_0:BS_P0308B<XP1[MHl0JgF?
00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80JgF?06]eS`0?06]e
S`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:HiA02V>D@03`2V>D@01`24
S:80Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1VIWh0000606IVOP2XYkl0
i^K]0=;Bh02l_<l0/K34K`2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040
IVIn00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@h03:b]X0K@2l_<l01P3:
b]X0d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000201HEfP0IVIn09FDZ`3G
f>80o?cl0?;al`3/jnh0hN;[J`3Gf>801`3Qh^/0k>_^0?;al`3lo?`0emSR
09FDZ`1VIWh00@1HEfP00080F5MX00<0IVIn09FDZ`3AdMh00P3lo?a]0?oo
o`80o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0F5MX0P1VIWh00`28Qid0
UIB[0:RW_`1/0:RW_`0409FDZ`28Qid0IVIn06IVOP<0F5MX000505QGJ740
IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[11]:=",
  Evaluatable->False,
  ImageSize->{123, 81},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutOptions"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]=",
  CellTags->"LayoutOptions"]
}, Open  ]],

Cell[TextData[{
  "Note that some widgets, especially ",
  StyleBox["Widget[\"Panel\"]", "Program"],
  ",  can set a ",
  StyleBox["\"border\"", "Program"],
  " property directly, and so a widget layout ",
  StyleBox["\"Border\" ", "Program"],
  "option can be specified directly with some widgets."
}], "Text",
  CellTags->"LayoutOptions"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
{\[IndentingNewLine]{Widget["\<Label\>", {"\<text\>" -> "\<Label:\>"}], \
\[IndentingNewLine]Widget["\<TextField\>", {"\<text\>" -> "\<Input\>"}]}\ \
\[IndentingNewLine]\ }, \ 
            WidgetLayout \[Rule] {"\<Border\>"\  -> "\<TitleName\>"}]\
\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"LayoutOptions"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"LayoutOptions"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000DB000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS
K`3oool20>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh20>3Ohfh0W9bN00H0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`0Q0>3OhdL0YJbb0P3Pgn<01`2LW9h0
oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP80h=oS00<0W9bN0?ooo`3Pgn<08@3Pgn<00`2U[;80oooo0?ooo`13
0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3O
h`0Q0>3Oh`030:F//P3oool0oooo04<0oooo00D0YJbb0>3Oh`3Pgn<0W9bN
0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh20>3Oh`0309bLWP3oool0h=oS0240h=oS00<0YJbb0?ooo`3oool0
0`3oool00`000000oooo0?ooo`0m0?ooo`050:F//P3Pgn<0h=oS09bLWP3o
ool00P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`0Q0>3Oh`030:F//P3oool0oooo00<0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0e0?ooo`05
0:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`0Q0>3O
h`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0e0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
102LW9h0oooo0>3Oh`3Pgn<500000080h=oS0P0000001@3Pgn<000000>3O
h`000000h=oS008000000`3Pgn<300000080h=oS00<000000>3Oh`000000
1@3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0000000<0oooo
00@000000?ooo`000000oooo0P0000030?ooo`80000000<0oooo0000003o
ool00P00000Z0?ooo`050:F//P3Pgn<0h=oS09bLWP3oool00P3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<01@2L
W9h0oooo0>3Oh`3Pgn<0000000D0h=oS00<000000>3Oh`3Pgn<00P000000
0`3Pgn<00000000000020>3Oh`030000003Pgn<0000000<0h=oS00<00000
0>3Oh`0000001`3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0
000000<0oooo00@000000?ooo`00000000000P3oool00`000000oooo0000
00020?ooo`80000000<0oooo0000003oool0:P3oool01@2U[;80h=oS0>3O
h`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOP80h=oS00D0W9bN0?ooo`3Pgn<0h=oS000000050>3Oh`07
0000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0
000000D0h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`2U[;80oooo0?ooo`03
0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool0
0`000000oooo000000030?ooo`030000003oool0000002/0oooo00D0YJbb
0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWh20>3Oh`0509bLWP3oool0h=oS0>3Oh`000000
1P3Pgn<4000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`000000
100000000`3Pgn<000000>3Oh`060>3Oh`030:F//P3oool0oooo00<0oooo
00<000000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000
003oool0000000<0oooo00<000000?ooo`000000:`3oool01@2U[;80h=oS
0>3Oh`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOP80h=oS00D0W9bN0?ooo`3Pgn<0h=oS000000050>3O
h`060000003Pgn<0h=oS0>3Oh`000000h=oS0P0000020>3Oh`030000003P
gn<0000000<0h=oS00<000000>3Oh`0000001`3Pgn<00`2U[;80oooo0?oo
o`030?ooo`040000003oool0000000000080oooo00@000000?ooo`000000
00000P3oool00`000000oooo000000030?ooo`030000003oool0000002/0
oooo00D0YJbb0>3Oh`3Pgn<0W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0509bLWP3oool0h=oS
0>3Oh`0000001P3Pgn<300000080h=oS00@000000>3Oh`00000000000`3P
gn<300000080h=oS00<000000>3Oh`0000001@3Pgn<00`2U[;80oooo0?oo
o`030?ooo`040000003oool000000?ooo`8000000P3oool010000000oooo
0000000000020?ooo`040000003oool0oooo0?ooo`@00000:P3oool01@2U
[;80h=oS0>3Oh`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOP80h=oS00D0W9bN0?ooo`3Pgn<0h=oS0000
000;0>3Oh`030000003Pgn<0h=oS00T0h=oS00<000000>3Oh`3Pgn<01@3P
gn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool0:@3oool01@2U[;80h=oS0>3Oh`2LW9h0oooo0080h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS
00D0W9bN0?ooo`3Pgn<0h=oS0000000;0>3Oh`030000003Pgn<0h=oS00T0
h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`2U[;80oooo0?ooo`030?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0:@3oool01@2U[;80
h=oS0>3Oh`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<08@3Pgn<00`2U
[;80oooo0?ooo`030?ooo`030000003oool0oooo03d0oooo00D0YJbb0>3O
h`3Pgn<0W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS0240h=oS00<0YJbb
0?ooo`3oool00`3oool00`000000oooo0?ooo`0m0?ooo`050:F//P3Pgn<0
h=oS09bLWP3oool00P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`0Q0>3Oh`030:F//P3o
ool0oooo00<0oooo00<000000?ooo`3oool0?@3oool01@2U[;80h=oS0>3O
h`2LW9h0oooo0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<08@3Pgn<00`2U[;80oooo
0?ooo`030?ooo`030000003oool0oooo03d0oooo00D0YJbb0>3Oh`3Pgn<0
W9bN0?ooo`020>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS0240h=oS00<0YJbb0?ooo`3o
ool0@`3oool01@2U[;80h=oS0>3Oh`2LW9h0oooo0080h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?oo
o`3Pgn<08@3Pgn=70:F//P80h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3o
ool0h=oS06X0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS06X0
h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS06X0h=oS00L0W9bN
0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh20>3Oh`0309bLWP3oool0h=oS06X0h=oS00L0W9bN0?ooo`3Pgn<0
h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3O
h`0309bLWP3oool0h=oS06X0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3o
ool0h=oS06X0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS06X0
h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS06X0h=oS00L0W9bN
0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh20>3Oh`0309bLWP3oool0h=oS00H0h=oS00H000000>3Oh`3Pgn<0
h=oS0000003Pgn<2000000040>3Oh`000000h=oS0>3Oh`<000000P3Pgn<0
0`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS0080000000@0h=oS
0000003Pgn<000000P3Pgn<010000000h=oS0>3Oh`0000020>3Oh`<00000
>P3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<01P3Pgn<01`00
0000h=oS0>3Oh`3Pgn<000000>3Oh`0000000P3Pgn<00`000000h=oS0000
00030>3Oh`030000003Pgn<0000000<0h=oS0P000000103Pgn<000000>3O
h`3Pgn<2000000050>3Oh`000000h=oS0>3Oh`0000000P3Pgn<00`000000
h=oS000000030>3Oh`030000003Pgn<0h=oS03L0h=oS00L0W9bN0?ooo`3P
gn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh2
0>3Oh`0309bLWP3oool0h=oS00H0h=oS00L000000>3Oh`3Pgn<0h=oS0000
003Pgn<000000080h=oS00<000000>3Oh`0000001@3Pgn<020000000h=oS
0>3Oh`000000h=oS0000003Pgn<000000`3Pgn<00`000000h=oS00000002
0>3Oh`060000003Pgn<0h=oS0000003Pgn<00000?@3Pgn<01`2LW9h0oooo
0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OP80h=oS00<0W9bN0?ooo`3oool00`3oool30>3Oh`070000003Pgn<0h=oS
0>3Oh`000000h=oS000000020>3Oh`030000003Pgn<0000000@0000000L0
h=oS0000003Pgn<0h=oS0000003Pgn<000000080h=oS100000001@3Pgn<0
00000>3Oh`3Pgn<000000080h=oS00<000000>3Oh`000000100000020>3O
hcL0oooo00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWh20>3Oh`H0W9bN0`3Pgn<01`000000h=oS0>3O
h`3Pgn<000000>3Oh`0000000P3Pgn<00`000000h=oS000000030>3Oh`05
0000003Pgn<000000>3Oh`0000000P3Pgn<00`000000h=oS000000030>3O
h`050000003Pgn<000000000003Pgn<00P000000103Pgn<000000>3Oh`00
00030>3Oh`030000003Pgn<0h=oS03P0W9bN00H0oooo0>3Oh`3Pgn<0IVIn
0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn2`3Pgn<010000000
h=oS0>3Oh`3Pgn<4000000040>3Oh`000000h=oS0>3Oh`<000000P3Pgn<0
0`000000h=oS000000020>3Oh`030000003Pgn<0h=oS00<000000P3Pgn<0
0`000000h=oS000000020>3Oh`040000003Pgn<0h=oS0>3Oh`<00000?P3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn2`3P
gn<00`000000h=oS0>3Oh`030>3Oh`040000003Pgn<0h=oS000000L0h=oS
0P0000030>3Oh`030000003Pgn<0h=oS04l0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPT0h=oS1@000000103Pgn<00000
0>3Oh`0000020>3Oh`030000003Pgn<0h=oS00D0h=oS00<000000>3Oh`3P
gn<00P3Pgn<00`000000h=oS0>3Oh`1?0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040
IVIn00000`1VIWh0moOi09RHY`1e07MgTP40V9RW0@3gmoT106IVOP0000<0
IVIn0?Ogn@2l_Ld0MP2l_Ld10?Ogn@40IVIn00000`1VIWh0moOi0>CSh`1f
0>CSh`40moOi0@1VIWh0000306IVOP3`lO@0oooo02l0oooo00<0i>?S09bT
^@1[MHl00`1[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0
oooo0?ooo`3Thn<0W:Bi101[MHl0101/MY00JgF?06afT01/MY0906]eS`06
09bT^@3Thn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W>T@0YSU40:LjA02W
>T@90:HiA00309bT^@3/j^X0oooo00<0oooo0@3`lO@106IVOP0001H0IVIn
0>;QhP3ko?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0o?cm0?clo03lnod0
o?cl0?cko03lo?`0nocl0?clo03ko?d0o?_l0?clo@3knod0nocl0P3lo?`0
103lo?d0o?cl0?_ko@3lo?dD0?cko080nocl00<0W:Bi06]eS`25RK004025
RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3k
o?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?clo03lnod0nocm
0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi
0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0
moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0C0?Ogn@80m_Oi
00<0JgF?08F9/02LW[h0402LW[h01P25RK00JgF?0?Ogn@3gmoT0JgF?08F9
/140W9jn00P0QHV`06]eS`3fmoP0moOh0:HiA02Z?5D0`U9K0<IDFPd0aUEL
00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>400@1VIWh0
000606IVOP3NgN40lO7d0?7am03`lO@0l?;d400000001P3alO@0l?;e0?7a
m03al_@0l?;d0?7am1H0l?7e00<0JgF?0;:ed02WZ<80402WZ<801P2b]M00
JgF?0?3am03`lO@0JgF?0;:ed140YjS200D0/[G@06]eS`3`lOD0lO;d0:Hi
A0020<9BF`030<]DF@3=FEh0cEUN00/0cEUN00@0beAI0<9BF`32DU/0YSU4
0P3`lO@00`3alO@0l?;d0=kMh@0106IVOP0000L0IVIn0=cKh03Zjo00j^_`
0>[/l03Yjnl000000080inOW0P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0
inOW0P3_knl010000000j^_`0>[[l03Zjnl20>[[l0030>[[k`3Zjo00j^_`
0180j^_`0P3Zk?00101[MHl0][WA0:f^aP2][/H80?ooo`030:f^aP2/[/H0
[Jk600<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0101[MHl0][WA0:f^aP2]
[/H<0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Zjo001@2V>D@0cEUN0<]D
F@3=EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`
0080j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@00
0000S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<00>OWi`3WinL00P3WinL0
1`3_knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[
0>?Uj`0B0>?Uj`80hnCZ00D0JgF?0;bne02b//X0/[;:0?ooo`0606i]S`03
02DU=P2b//X0/[;:00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ06]eS`2l_]@2
0;:bbP030?ooo`0U9CH09BDf00T09BDf0`2b//X01@2l_]@0JgF?0>?Tj`3S
i>/0YSU40080cEUN00@0d5]P0=ALG`3oool0oooo1`3DG5l20?ooo`0:0=AL
G`3@Ff00cEUN0<eIGP2V>D@0hnCZ0>?UjP3Si>X0hnG[0=WIg`40IVIn0000
0`1VIWh0emSN0=cNiP030=cNiP050000003WinL0inOW0>OWi`3We/h00P3W
inL01@3>N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_00L000000=cNiP3Lg^D0
g=kU0=cNiP3Lg^D0g=kV01H0g=kU00D0JgF?0;o1eP2h^Lh0^;W>0?ooo`06
06i]S`0302DU=P2h^Lh0^;W>00D0^;W>00H0_l7F06]eS`3Lg^D0g=kU06]e
S`2o`MH20;RicP030?ooo`0U9CH0^;W>00L0^;W>00<0oooo02DU=P2h^Lh0
0P2h^Lh02@2o`MH0JgF?0=cNiP3Lg^D0YSU40<eIGP3AFUh0e5eQ05<U8003
0?ooo`D0eUmS0`3oool01@1C9B00e5eQ0=5JGP3=FEh0YSU40080g=kU00<0
g=kV0=cNi@3Gf=h00@1VIWh0000406IVOP3Ee]d0eMSP0=KHh@80eMSP00T0
000008b<S03WinL0inOW0>NeQ03FFP00eX@00?o>003>H`000P3NJ`001@3_
]H`0kno_0>o_k`3_knl000000080eMSQ00@0eMOP0=KHh03Ff>40e]OQ503F
en020=KHh00506]eS`33aMT0_;gA0;bmd@3oool01`0U9CH70;bmd@060<?5
f@1[MHl0eMSQ0=GHh@1[MHl0`lGI0P2l_M400`3oool09BDf0;bmd@070;bm
d@030?ooo`0U9CH0_;gA0080_;gA00D0`lGI06]eS`3Fen00eMOQ0:HiA002
0=EMH0030=QPH@3IHF80AQhJ00<0oooo0`3IHF830?ooo`0304HN6P3IHF80
f61Q0080eEeP00H0YSU40=KHh03Ef>40eMOP0=GHh@3Ee]d106IVOP0000L0
IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@d]`0000000<0inOW00`0imk>0<I:003g
cP00kjd00>ne003>J`00aUX00<I[003NS4X0ijD00>oWcP0000030=3Bg003
0<oBg03@d]`0cm;L01@0d=;L0P3?d]d00`1[MHl0b<WK0<?4eP0@0<?4eP06
0<S9f`1[MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP07
0<?4eP030?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:Hi
A03GGel0fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`08
04HN6P3LIFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3B
e=d106IVOP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3W
aX`0mlhH0>nm003gaP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_
i`3_knl000000<_=f03;cMT0b/gI0<_>f03:cMP0blgH503;cMT20<_>f@03
06]eS`3;c=h0b<[I00P0b<[I00<0b<WI0<S:f@38b]T00`38b]T01038bMT0
b<[I0<_<gP1[MHl20<_=f00606]eS`3;c=h0b<[I0<S:f@3oool09BDf1@38
b]T04@38bMT0b<[I0<S:f@3oool09BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0
blkH0<[=f02V>D@0eemO0=]TI03PIfD0h6IU0080gVMW00<0AQhJ0?ooo`3o
ool00`3oool02P167QX0gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0YSU40<[>
f03:c]T20<_=f@40d=;K0@1VIWh0000306IVOP3?cmX0aLSD00<0aLSD00H0
00000<K6aP3Wg]H0cW/00>N]003_]@020>NU00030=JD003>L`00eY@00080
mlH00P3gmoL010000000aLSD0<G7e035am@30<G7eA@0a<OE0P34b=@00`1[
MHl0d=7P0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P0P3;
bm`00`3oool09BDf0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080bl_L00L0
d=7P06]eS`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ0?ooo`3o
ool0oooo04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD0@35amD1
0<o?fP40IVIn0000101VIWh0c<kJ0<;4dP31a=420<74dP060000003WinL0
inOW0>OWi`3FQ000kkD00P3WY@00203FQ000cV/00>N]003g]@00mkd00>o_
k`3gmoL000000`31a=800`32a=40`LCB0<74dP0D0<74d@80`LCB00<0JgF?
0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M
00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@020<o@g@070=?C
hP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203Q
JFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:
c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<00020=jD0004
0=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>BP000000_/3>0;k0c`2n
`<h0_/3?0;g0cQD0_/3>0P2m`<h00`1[MHl0e]KT0=?Ch00@0=?Ch0060=KF
i01[MHl0_/3>0;k0cP1[MHl0e]KT0P3Cdn000`3oool09BDf0?ooo`080?oo
o`0;02DU=P3Cdn00dm?P0=?Ch03Fe^@0JgF?0;k0c`2n`<h0YSU40>1VI@3Q
JVX0103SK6`30?ooo`0404HN6P3oool0oooo0?ooo`@0hfa/00@0hFYZ0>1V
I@2V>D@0_L3?0P2n`<l10;k0cP40b/cH0@1VIWh0000706IVOP39b]P0][S8
0;Vlb`2j_</0^[c<000000020>o_k`0C0=JL003FS000gY@00=J4003_Y@00
gX`00;eJ003FL`00ki`00?O_i`3gmoL0oooo0000002i_<`0^[_<0;Vlb`2j
_</0^Kc<0;Vlb`0D0;Vlc080^[c<00<0JgF?0=SHi@3Cdn40403Cdn401P3H
f>D0JgF?0;Zlb`2j_</0JgF?0=SHi@80dm?Q00<0oooo06i]S`1^KHl0201^
KHl03P0U9CH0dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<0:HiA03PJFP0
hFe/0>AaK@3TLFl0i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^
00T0i75]0>5]K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039b]P00@1VIWh0
000906IVOP37bML0];K70;Jhb02f^<T0][W900000024Q8@0inON0080kno_
00L0aV/00?O6003_]@00ki`00=j<003>J`00ii`000<0moOg00D000000;Ji
b@2g^<T0][W90;Nib@020;JhbA@0]kS90P2f^<T0101[MHl0e]KT0=SHi@3H
f>H30=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0e]KT06]eS`2g^<T0]kS9
06]eS`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0
e]KT06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@16
7QX0i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0i6i]0:Hi
A02f^LT0][S90;Jib@2d]/L0alWG0@1VIWh0000306IVOP36b=L0];K700<0
];K700<000000>o_k`3_knl00P3_knl02`3W[@00mlH80>NU003WU000ih`0
0>oWeP3NU3T0kmJe0?ogm`3oool0000001`0];K700D0JgF?0=GEh`3LfnL0
g=_W0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL0
0`3MfnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS06]eS`2d]/L0];K70:Hi
A03WLfl0igEb0>YfL`3ZN7H00P3oool00`167QX0jGih0>UnN0030>UnN008
04HN6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V>D@40;Bfa`40a/SG0@1V
IWh0000306IVOP36b=L0];K700<0];K700H0000008b<S03_knl0kno_0>O>
N`3_knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_imH0moOg0?ooo`00000L
0;Bfa`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0];K706]e
S`3Ee><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0
lXV10080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ
00D0lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40a/SG0@1VIWh0000306IV
OP36b=L0/K?800<0/K?800H000000>o_k`3_knl0kno_0?Ogk`3_knl20?Og
m`030?OWaP3gmoL0oooo00<0moOg00<0oooo0000002a/lP06`2a/lP00`1[
MHl0kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Y
j?406@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0
lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3e
S8@0l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn00000`1VIWh0a/SG0;Rg
c`030:n^a`050000002][Jd0moO_0?Ogm`3_knl01P3gmoL20?ogm`80oooo
00<000000:n^a`2_[/L06P2_[/L00`1[MHl0d]7S0?;am`0@0?;am`060=;A
h`1[MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0
YSU40?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V>D@0[jk70080[jk70@2h
]ll10<K8e`40IVIn00000`1VIWh0`<7A0<O7e00_0:b[a00408B<XP1[MHl0
c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?
0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400L0TIRZ0:Hi
A03oWhd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf
0P3ijKH01P3jjkL0n]bg0?joY03oWhd0YSU4096HZP<0[:_40@37am@10<31
d@40IVIn0000101VIWh0`<7A0=;Bg`2e]<T_0:BS_P0308B<XP1[MHl0JgF?
00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80JgF?06]eS`0?06]e
S`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:HiA02V>D@03`2V>D@01`24
S:80Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1VIWh0000606IVOP2XYkl0
i^K]0=;Bh02l_<l0/K34K`2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040
IVIn00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@h03:b]X0K@2l_<l01P3:
b]X0d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000201HEfP0IVIn09FDZ`3G
f>80o?cl0?;al`3/jnh0hN;[J`3Gf>801`3Qh^/0k>_^0?;al`3lo?`0emSR
09FDZ`1VIWh00@1HEfP00080F5MX00<0IVIn09FDZ`3AdMh00P3lo?a]0?oo
o`80o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0F5MX0P1VIWh00`28Qid0
UIB[0:RW_`1/0:RW_`0409FDZ`28Qid0IVIn06IVOP<0F5MX000505QGJ740
IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  Evaluatable->False,
  ImageSize->{123, 81},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutOptions"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]=",
  CellTags->"LayoutOptions"]
}, Open  ]],

Cell["\<\
We can add a little inner spacing with a compound border of a title with a \
spacing border.\
\>", "Text",
  CellTags->"LayoutOptions"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
\[IndentingNewLine]WidgetGroup[{\[IndentingNewLine]{Widget["\<Label\>", \
{"\<text\>" -> "\<Label:\>"}], \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<Input\>"}]}\ \[IndentingNewLine]\ }, \ 
              WidgetLayout \[Rule] {"\<Border\>"\  \[Rule] {"\<TitleName\>", \
\ {{5, 5}, {10, 
                          30}}\ }\ \ }\[IndentingNewLine]]\ ]\
\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"LayoutOptions"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"LayoutOptions"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000NB000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS
K`3oool20>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh20>3Ohfh0W9bN00H0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`1Z0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`1Z0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`0V0>3Ohcd0YJbb1`3Pgn<01`2LW9h0
oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP80h=oS00<0W9bN0?ooo`3Pgn<09P3Pgn<00`2U[;80oooo0?ooo`0i
0?ooo`030:F//P3Pgn<0h=oS00D0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bL
WP3oool0h=oS02H0h=oS00<0YJbb0?ooo`3oool0>@3oool00`2U[;80h=oS
0>3Oh`050>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`0V0>3O
h`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0<`3oool00`2U
[;80h=oS0>3Oh`050>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3O
h`0V0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0[0?ooo`030:F//P3Pgn<0h=oS00D0h=oS00L0
W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS02H0h=oS00<0YJbb0?ooo`3o
ool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo02/0
oooo00<0YJbb0>3Oh`3Pgn<01@3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN
0?ooo`3Pgn<01P3Pgn<500000080h=oS0P0000001@3Pgn<000000>3Oh`00
0000h=oS008000000`3Pgn<300000080h=oS00<000000>3Oh`0000001@3P
gn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0000000<0oooo00@0
00000?ooo`000000oooo0P0000030?ooo`80000000<0oooo0000003oool0
0P00000P0?ooo`030:F//P3Pgn<0h=oS00D0h=oS00L0W9bN0?ooo`3Pgn<0
h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3O
h`0309bLWP3oool0h=oS00H0h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`00
0000h=oS0>3Oh`02000000030>3Oh`00000000000080h=oS00<000000>3O
h`0000000`3Pgn<00`000000h=oS000000070>3Oh`030:F//P3oool0oooo
00<0oooo00<000000?ooo`0000000`3oool010000000oooo000000000002
0?ooo`030000003oool000000080oooo0P0000000`3oool000000?ooo`0P
0?ooo`030:F//P3Pgn<0h=oS00D0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bL
WP3oool0h=oS00H0h=oS00<000000>3Oh`3Pgn<00`3Pgn<01`000000h=oS
0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000050>3O
h`030000003Pgn<0h=oS00D0h=oS00<0YJbb0?ooo`3oool00`3oool00`00
0000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?oo
o`0000000`3oool00`000000oooo0000000Q0?ooo`030:F//P3Pgn<0h=oS
00D0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS00H0h=oS00<0
00000>3Oh`3Pgn<0103Pgn<4000000030>3Oh`000000h=oS0080h=oS00<0
00000>3Oh`000000100000000`3Pgn<000000>3Oh`060>3Oh`030:F//P3o
ool0oooo00<0oooo00<000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000008@3o
ool00`2U[;80h=oS0>3Oh`050>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0
oooo0>3Oh`060>3Oh`030000003Pgn<0h=oS00<0h=oS00H000000>3Oh`3P
gn<0h=oS0000003Pgn<200000080h=oS00<000000>3Oh`0000000`3Pgn<0
0`000000h=oS000000070>3Oh`030:F//P3oool0oooo00<0oooo00@00000
0?ooo`00000000000P3oool010000000oooo0000000000020?ooo`030000
003oool0000000<0oooo00<000000?ooo`0000008@3oool00`2U[;80h=oS
0>3Oh`050>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`060>3O
h`030000003Pgn<0h=oS00@0h=oS0`0000020>3Oh`040000003Pgn<00000
000000<0h=oS0`0000020>3Oh`030000003Pgn<0000000D0h=oS00<0YJbb
0?ooo`3oool00`3oool010000000oooo0000003oool200000080oooo00@0
00000?ooo`00000000000P3oool010000000oooo0?ooo`3oool400000200
oooo00<0YJbb0>3Oh`3Pgn<01@3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN
0?ooo`3Pgn<01P3Pgn<00`000000h=oS0>3Oh`090>3Oh`030000003Pgn<0
h=oS00T0h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`2U[;80oooo0?ooo`03
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool07`3oool0
0`2U[;80h=oS0>3Oh`050>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`060>3Oh`030000003Pgn<0h=oS00T0h=oS00<000000>3Oh`3Pgn<0
2@3Pgn<00`000000h=oS0>3Oh`050>3Oh`030:F//P3oool0oooo00<0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0O0?ooo`030:F/
/P3Pgn<0h=oS00D0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3oool0h=oS
02H0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`0c0?oo
o`030:F//P3Pgn<0h=oS00D0h=oS00L0W9bN0?ooo`3Pgn<0h=oS06IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`0309bLWP3o
ool0h=oS02H0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?oo
o`0c0?ooo`030:F//P3Pgn<0h=oS00D0h=oS00L0W9bN0?ooo`3Pgn<0h=oS
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`03
09bLWP3oool0h=oS02H0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000
oooo0?ooo`0c0?ooo`030:F//P3Pgn<0h=oS00D0h=oS00L0W9bN0?ooo`3P
gn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh2
0>3Oh`0309bLWP3oool0h=oS02H0h=oS00<0YJbb0?ooo`3oool00`3oool0
0`000000oooo0?ooo`0c0?ooo`030:F//P3Pgn<0h=oS00D0h=oS00L0W9bN
0?ooo`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh20>3Oh`0309bLWP3oool0h=oS02H0h=oS00<0YJbb0?ooo`3oool0
>@3oool00`2U[;80h=oS0>3Oh`050>3Oh`0709bLWP3oool0h=oS0>3Oh`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2L
W9h0oooo0>3Oh`0V0>3Ohcd0YJbb1`3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0
W9bN0?ooo`3Pgn<0JP3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3P
gn<0JP3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<0JP3Pgn<0
1`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<0JP3Pgn<01`2LW9h0oooo
0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OP80h=oS00<0W9bN0?ooo`3Pgn<0JP3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0
W9bN0?ooo`3Pgn<0JP3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3P
gn<0JP3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<0JP3Pgn<0
1`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<0JP3Pgn<01`2LW9h0oooo
0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OP80h=oS00<0W9bN0?ooo`3Pgn<0JP3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0
W9bN0?ooo`3Pgn<0JP3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3P
gn<0JP3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<0JP3Pgn<0
1`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<0JP3Pgn<01`2LW9h0oooo
0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OP80h=oS00<0W9bN0?ooo`3Pgn<0JP3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0
W9bN0?ooo`3Pgn<0JP3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3P
gn<0JP3Pgn<01`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<0JP3Pgn<0
1`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOP80h=oS00<0W9bN0?ooo`3Pgn<01P3Pgn<01P000000h=oS
0>3Oh`3Pgn<000000>3Oh`80000000@0h=oS0000003Pgn<0h=oS0`000002
0>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<00P000000
103Pgn<000000>3Oh`0000020>3Oh`040000003Pgn<0h=oS00000080h=oS
0`00000j0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`060>3O
h`070000003Pgn<0h=oS0>3Oh`000000h=oS000000020>3Oh`030000003P
gn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<2000000040>3Oh`00
0000h=oS0>3Oh`80000000D0h=oS0000003Pgn<0h=oS000000020>3Oh`03
0000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0=`3Pgn<01`2LW9h0
oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP80h=oS00<0W9bN0?ooo`3Pgn<01P3Pgn<01`000000h=oS0>3Oh`3P
gn<000000>3Oh`0000000P3Pgn<00`000000h=oS000000050>3Oh`080000
003Pgn<0h=oS0000003Pgn<000000>3Oh`0000030>3Oh`030000003Pgn<0
00000080h=oS00H000000>3Oh`3Pgn<000000>3Oh`00000m0>3Oh`0709bL
WP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn0P3Pgn<00`2LW9h0oooo0?ooo`030?ooo`<0h=oS00L000000>3O
h`3Pgn<0h=oS0000003Pgn<000000080h=oS00<000000>3Oh`0000001000
00001`3Pgn<000000>3Oh`3Pgn<000000>3Oh`0000000P3Pgn<400000005
0>3Oh`000000h=oS0>3Oh`0000000P3Pgn<00`000000h=oS000000040000
0080h=oS=`3oool01`2LW9h0oooo0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS1P2LW9h30>3Oh`070000003P
gn<0h=oS0>3Oh`000000h=oS000000020>3Oh`030000003Pgn<0000000<0
h=oS00D000000>3Oh`000000h=oS000000020>3Oh`030000003Pgn<00000
00<0h=oS00D000000>3Oh`00000000000>3Oh`02000000040>3Oh`000000
h=oS000000<0h=oS00<000000>3Oh`3Pgn<0>02LW9h01P3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWh;0>3Oh`04
0000003Pgn<0h=oS0>3Oh`@0000000@0h=oS0000003Pgn<0h=oS0`000002
0>3Oh`030000003Pgn<000000080h=oS00<000000>3Oh`3Pgn<00`000002
0>3Oh`030000003Pgn<000000080h=oS00@000000>3Oh`3Pgn<0h=oS0`00
000n0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWh;0>3Oh`030000003Pgn<0h=oS00<0h=oS00@000000>3Oh`3Pgn<00000
1`3Pgn<2000000<0h=oS00<000000>3Oh`3Pgn<0C`3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn2@3Pgn<5000000040>3O
h`000000h=oS00000080h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`000000
h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS04l0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000306IVOP3gmoT0V9RW07D0MgNB0@2HV:L10?Ogn@40IVIn
00000`1VIWh0moOi0;bmc@1f0;bmc@40moOi0@1VIWh0000306IVOP3gmoT0
i>?S07H0i>?S0@3gmoT106IVOP0000<0IVIn0?3am03oool0;`3oool00`3T
hn<0W:Bi06]eS`0306]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi
0>CSh`3oool0oooo0>CSh`2LY;T406]eS`0406afT01[MHl0K7J@06afT0T0
JgF?00H0W:Bi0>CSh`3oool0oooo0>cZjP2LY;T40:HiA0040:LjA02V>D@0
YcY40:LjA0T0YSU400<0W:Bi0>cZjP3oool00`3oool10?3am040IVIn0000
5P1VIWh0h^7R0?_lo03kno`0nocm0?cko@3knod0nocm0?_lo03lo?d0o?cl
0?cko@3lo?`0o?_l0?clo03ko?`0o?cl0?_lo@3lno`0o?cm0?_ko@3ko?`2
0?clo0040?clo@3lo?`0no_m0?cloA@0o?_l0P3ko?`00`2LY;T0JgF?08F9
/00@08F9/00606]eS`2LY;T0nocm0?_lo@2LY;T0JgF?4@25RK001P1[MHl0
W:Bi0?_lo03kno`0W:Bi0:HiA140ZSaE00L0YSU409bT^@3ko?`0o?cl0?ck
o@3ko?d0h^7R0040IVIn0000101VIWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kg
n03gmoT0moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3g
moT0103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0moOi01<0moOi
0P3fmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[
MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ
3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@01
06IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@000000060?7am03`
l_D0lO7d0?7bm03`l_@0lO7d5P3`lOD00`1[MHl0/[G@0:NX`P0@0:NX`P06
0;:ed01[MHl0l?7d0?3am01[MHl0/[G@4@2WZ<801@2b]M00JgF?0?3am@3a
l_@0YSU40080`U9K00<0beAI0<eIGP3=FEh02`3=FEh0103;E5T0`U9K0<9B
F`2V>D@20?3am0030?7am03`l_@0g]gQ0040IVIn00001`1VIWh0g=_P0>[[
l03Zjo00j^c`0>W[k`0000000P3WinL20=kNgP80inOW00<0ikf40>OWi`3W
inL00`3WinL20>o_k`040000003Zjo00j^_`0>[[k`80j^_`00<0j^__0>[[
l03Zjo004P3Zjo020>[/l00406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk6
0:b^aP2][/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`0406]eS`2f^M40
[Jk60:f^aP`0oooo0P2][/H00`2/[/H0][WA06]eS`020>[[l0050:HiA03=
FEh0beAI0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK0<]DF@3=FEh0YSU40>[[
k`3Zjo000P3Zjnl10=cKh040IVIn0000101VIWh0fMWO0>?UjP3Si>X20>?U
j`050000002<S8`0g]kN0>OWi`3Ng]h00P3WinL00`36H`00inOW0>OWi`02
0>OWi`070>o_i`3_knl0kno_0000003Si>X0hnC[0>?UjP020>?TjP030>?T
j`3SiN/0hnG[0180hnG[0P3Si>X01@1[MHl0_;kD0;:bbP2b//X0oooo00H0
KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?
0;bne080/[;:00<0oooo02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0
hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo
00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1V
IWh0000306IVOP3Gf=h0g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OF
cP020>OWi`050<ik003_U100inOW0>ONaP3_S1000`3_knl01`000000g=kV
0=cNi@3Lg^D0g=kV0=cNi@3Lg^H05P3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0
oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3L
g^D0JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool09BDf
0;RicP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40
DbDP00<0oooo1@3FGf<30?ooo`0505<U803DGF40dEYN0<eIGP2V>D@00P3L
g^D00`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn0=GFg@3Ef>00e]SQ0P3E
f>002@000000S8b<0>OWi`3WinL0ikF40=IJ003FQ000olh00<iS00020=i[
00050>neS03_knl0kno_0>o_k`0000000P3Ef>40103Een00e]SP0=KHh@3F
en4D0=KGh080e]SP00D0JgF?0<?5f@2l_M40_;gA0?ooo`0702DU=PL0_;gA
00H0`lGI06]eS`3Ef>40eMSQ06]eS`33aMT20;bmd@030?ooo`0U9CH0_;gA
00L0_;gA00<0oooo02DU=P2l_M400P2l_M401@33aMT0JgF?0=KGh03Een40
YSU40080eEeP00<0f61Q0=UQHP167QX00`3oool30=UQHP<0oooo00<0AQhJ
0=UQHP3HH6400P3EGF001P2V>D@0e]SP0=GHh@3Een00eMSQ0=GFg@40IVIn
00001`1VIWh0d]CM0<oBg03@d]`0d=;M0=3Bg00000000`3WinL0303Wg/h0
aTX00?O>003_[@00kkD00<i[0036FP00aV/00=j<BP3WY@00knO>000000<0
d=;L00<0cm;L0=3Bg03?d]`0503@d]`20<oBg@0306]eS`38bM/0`lCF0100
`lCF00H0b<WK06]eS`3@d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U9CH0
`lCF00L0`lCF00<0oooo02DU=P33a=H00P33a=H01`38bM/0JgF?0<oBg03?
d]`0YSU40=MOG`3IHF800`3LIFD01@167QX0oooo0?ooo`3oool0g6EU00<0
oooo00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?
d]`10=;Dg@40IVIn0000701VIWh0d=;K0<_=f03:cMT0blkH0<[=f0000000
ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU003FS000cV/00>O6003o
eP00knoW0>o_k`000000blgH0<_=f@3:cMT0blkH0<[=f03;cMPD0<_=f@80
blkI00<0JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@04
0<S9f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U
9CH50<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN
06]eS`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0
oooo0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V
>D@0b/kH0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35
b=@01P000000a/K60>ONeP3>N`00ijd00>ne0080ijD000<0eY@00<ic003F
U0000P3gaP020?Ogm`0400000035b=@0aLOD0<G7e0<0aLOE5034amD20<C8
e00306]eS`3@dN00bl_L0100bl_L00H0d=7P06]eS`34am@0a<OD06]eS`3@
dN020<_;g0030?ooo`0U9CH0bl_L00L0bl_L00<0oooo02DU=P3;bm`00P3;
bm`01`3@dN00JgF?0<G7e034am@0YSU40=]TI03OIF@01@3PJVP01@167QX0
oooo0?ooo`3oool0AQhJ00D0h6YX00@0gfET0=]TI02V>D@0a<SE0P34b=@1
0<G7e@40cloJ0@1VIWh0000406IVOP3<c]X0`/CB0<74d@80`LCB00H00000
0>OWi`3WinL0inOW0=J4003_]@020>NU00080=J4003>J`00ijd00?Ne003g
_@00kno_0?Ogm`0000030<74dP030<;4d@31a=80`LCB01@0`LCA0P31a=80
0`1[MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R
0P3?d=d00`3oool09BDf0<o@g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M
00L0dm?R06]eS`32a=80`LCA0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/
J@080>5YI@3KI6@0YSU40<74dP32a=40`LCA0<74dP3<c]X106IVOP0000@0
IVIn0<[<f02n`<l0_L3?0P2n`<h01@000000W9bL0>OWi`3Wg]H0eX`00080
gY@000@0eW/00<IS002m@P00kjD00P3g[@00203g]@00oli:0000002n`<h0
_/3?0;k0cP2n`<l0_L3>5@2n`<h20;g0cP0306]eS`3Fe^@0dm?P0100dm?P
00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo
00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0
h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo103SK6`0103Q
JVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:
f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<003NU000eX@0
0>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3oool000000;Vlc02j^l`0
^Kc;0;Zlb`2i_<`0^Kc;01@0^Kc<0P2j_<`00`1[MHl0f=SU0=?Ch@0@0=?C
h@060=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU0P3Cdn400`3oool0KVf?06i]
S`0806i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0JgF?0;Zlb`2j_<`0YSU4
0>1YJ03QKF`0i75]0>AaK`3TL6h30?ooo`0304HN6P3TL6h0AQhJ00<0oooo
0P3TL6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<0;Zkc02i_</0][S80<W:f001
06IVOP0000T0IVIn0<O9e`2d]/L0][S80;Jhb@2f^LT0000008B4Q03Wimh0
0P3_knl01`36J`00mlH00>ne003_W000gX`00<i[003WW0000`3gmoL01@00
0000][W90;Nhb@2f^LT0]kW90080][S9502g^<T20;Jhb@0406]eS`3Fe^@0
f=SU0=SHiP<0f=SU1@3Hf>H30=SHi@80f=SV0P3Hf>D02@3Fe^@0JgF?0;Nh
b@2g^<T0JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]S`0=02DU=P3Hf>H0f=SU
0=SHi@3Fe^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3TM6l0ig5_0>AdK`030?oo
o`0504HN6P3TM6l0i7A_0>AdK`167QX00`3oool02P3TM6l0ig5_0>AdK`3T
KVd0YSU40;Jib@2f^<T0][W90;Bfa`37bML106IVOP0000<0IVIn0<K8e`2d
]/L00`2d]/L00`000000kno_0>o_k`020>o_k`0;0>N]003gaPP0ijD00>ND
003WS000knOF0=jD>@3_e[D0ooOg0?ooo`000000702d]/L01@1[MHl0eMGS
0=cKi`3LfnL0gM_W00h0g=_W00H0eMGS06]eS`2d]/L0];K706]eS`3EeN<2
0=cKi`030=gKi`0U9CH09BDf00T09BDf0`3LfnL02@3EeN<0JgF?0;Bfa`2d
]/L0YSU40>McK`3WMG80jWIc0>YhMP020?ooo`0304HN6P3YOWP0jGih00<0
jGih00P0AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80ig=_0:HiA0@0];K70@36
b=L106IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L01P000000S8b<0>o_k`3_
knl0ilik0>o_k`80moOg00P0ii@00?OWcP3gmoL0moOg0>oWeP3gmoL0oooo
000001`0];K700<0JgF?0=GDh`3PgnX0403PgnX01P3Ee><0JgF?0;Bfa`2d
]/L0JgF?0=GDha40h=oZ00T0eMCS06]eS`2d]/L0];K70:HiA03ZNG<0jGah
0>n1NP3bRH400P167QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<0>fGRP3[V8/0
0P167QX01@3bRH40kh5j0>UlN03ZNG<0YSU400@0];K70@36b=L106IVOP00
00<0IVIn0<K8e`2a/lP00`2a/lP01P000000kno_0>o_k`3_knl0moO_0>o_
k`80moOg00<0mnO60?Ogm`3oool00`3gmoL00`3oool000000;6cb00K0;6c
b00306]eS`3]jo<0jNSa0100jNSa00H0kN_c06]eS`2a/lP0/K?806]eS`3]
jo<A0>WXl@0I0>g[l`1[MHl0/K?80;6cb02V>D@0lH1e0?24O03eS8@0mif>
0?:[UP3a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03bZiH0
mif>0?F<Q03`Q7`0lH1e0:HiA0040;6cb040a/SG0@1VIWh0000306IVOP36
b=L0^;O?00<0[jk700D000000:f][@3gmnl0moOg0>o_k`060?Ogm`80ooOg
0P3oool00`000000[jk70:n^a`0J0:n^a`0306]eS`3BdN<0l_7g0100l_7g
00H0d]7S06]eS`2_[/L0[jk706]eS`3BdN<A0?;am`060=;Ah`1[MHl0[jk7
0:n^a`2V>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0m8Ym0:HiA02_[/L00P2_
[/L10;Rgc`40a/SG0@1VIWh0000306IVOP30`M40alOD02l0[:_400@0Q8bR
06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a00408B<
XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01`2A
V:X0YSU40?nOS@3n_j@0n]bg0?[[]`3jjKH00P3ijKH0103jjKH0nNVf0?WY
]P3jjKH20?WY]P060?[[]`3jg;L0o[nT0?nOS@2V>D@0TIRZ0`2/Zl@10<O7
e040`<7A0@1VIWh0000406IVOP30`M40d];O0;FdbBl0Y:>n00<0Q8bR06]e
S`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP1[MHl0JgF?
00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80YSU40:HiA00?0:Hi
A00708B<XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31d@0106IVOP0000H0IVIn
0:RW_`3Vi^d0d];P0;blc`2a/<A_0:RW_`050;6`a02l_<l0d];P0>KVk@2X
Ykl00@1VIWh0000705QGJ027Qi/0emSR0?clo03ThnP0d=3P0<[:fP1]0;bl
c`060<[:fP3@d>00i>?X0?clo03Gf>80QhNK0@1HEfP0000805QGJ01VIWh0
UIB[0=OHhP3lo?`0l_7c0>c[kP3Qh^][0=OHhP070>7Rj`3/jnh0l_7c0?cl
o03Gf>80UIB[06IVOP0105QGJ0000P1HEfP00`1VIWh0UIB[0=7AgP020?cl
o6d0oooo0P3lo?`00`3AdMh0UIB[06IVOP0205QGJ0000`1HEfP206IVOP03
08R7W@2EU:/0Z:No06`0Z:No00@0UIB[08R7W@1VIWh0IVIn0`1HEfP000D0
F5MXL@1VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[15]:=",
  Evaluatable->False,
  ImageSize->{123, 121},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutOptions"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[15]=",
  CellTags->"LayoutOptions"]
}, Open  ]],

Cell["Here we have added a simple red border three points thick.", "Text",
  CellTags->"LayoutOptions"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
\[IndentingNewLine]WidgetGroup[{\[IndentingNewLine]{Widget["\<Label\>", \
{"\<text\>" -> "\<Label:\>"}], \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<Input\>"}]}\ \[IndentingNewLine]\ }, \ 
              WidgetLayout \[Rule] {"\<Border\>"\  \[Rule] {RGBColor[1, 0, 
                        0], 3}}]\ ]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"LayoutOptions"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"LayoutOptions"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000?2000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0o`00
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0o`00
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0o`00
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0o`00
803Pgn==0:F//P<0o`0000<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOP<0o`00803Pgn<00`2U[;80oooo0?ooo`190?ooo`070:F/
/P3o0000o`000?l0001VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn0`3o000P0>3Oh`030:F//P3oool0oooo04T0oooo00L0YJbb0?l0
003o0000o`0006IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWh30?l00200h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?oo
o`130?ooo`070:F//P3o0000o`000?l0001VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn0`3o000P0>3Oh`030:F//P3oool0oooo00<0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0k0?ooo`07
0:F//P3o0000o`000?l0001VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn0`3o000P0>3Oh`030:F//P3oool0oooo00<0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0k0?ooo`070:F//P3o0000
o`000?l0001VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
0`3o000500000080h=oS0P0000001@3Pgn<000000>3Oh`000000h=oS0080
00000`3Pgn<300000080h=oS00<000000>3Oh`0000001@3Pgn<00`2U[;80
oooo0?ooo`030?ooo`030000003oool0000000<0oooo00@000000?ooo`00
0000oooo0P0000030?ooo`80000000<0oooo0000003oool00P00000`0?oo
o`070:F//P3o0000o`000?l0001VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0`3o00000`000000h=oS0>3Oh`030>3Oh`030000003P
gn<0h=oS0080000000<0h=oS0000000000000P3Pgn<00`000000h=oS0000
00030>3Oh`030000003Pgn<0000000L0h=oS00<0YJbb0?ooo`3oool00`3o
ool00`000000oooo000000030?ooo`040000003oool0000000000080oooo
00<000000?ooo`0000000P3oool2000000030?ooo`000000oooo0300oooo
00L0YJbb0?l0003o0000o`0006IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWh30?l000030000003Pgn<0h=oS00<0h=oS00L000000>3O
h`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000001@3P
gn<00`000000h=oS0>3Oh`050>3Oh`030:F//P3oool0oooo00<0oooo00<0
00000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003o
ool0000000<0oooo00<000000?ooo`000000<@3oool01`2U[;80o`000?l0
003o0000IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0
o`0000<000000>3Oh`3Pgn<0103Pgn<4000000030>3Oh`000000h=oS0080
h=oS00<000000>3Oh`000000100000000`3Pgn<000000>3Oh`060>3Oh`03
0:F//P3oool0oooo00<0oooo00<000000?ooo`0000000`3oool00`000000
oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`00
0000<@3oool01`2U[;80o`000?l0003o0000IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOP<0o`0000<000000>3Oh`3Pgn<00`3Pgn<0
1P000000h=oS0>3Oh`3Pgn<000000>3Oh`8000000P3Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0000000L0h=oS00<0YJbb0?ooo`3oool0
0`3oool010000000oooo0000000000020?ooo`040000003oool000000000
0080oooo00<000000?ooo`0000000`3oool00`000000oooo0000000a0?oo
o`070:F//P3o0000o`000?l0001VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0`3o00000`000000h=oS0>3Oh`040>3Oh`<000000P3P
gn<010000000h=oS0000000000030>3Oh`<000000P3Pgn<00`000000h=oS
000000050>3Oh`030:F//P3oool0oooo00<0oooo00@000000?ooo`000000
oooo0P0000020?ooo`040000003oool0000000000080oooo00@000000?oo
o`3oool0oooo1000000`0?ooo`070:F//P3o0000o`000?l0001VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3o00000`000000h=oS
0>3Oh`090>3Oh`030000003Pgn<0h=oS00T0h=oS00<000000>3Oh`3Pgn<0
1@3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool0;`3oool01`2U[;80o`000?l0003o0000IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0o`0000<000000>3O
h`3Pgn<02@3Pgn<00`000000h=oS0>3Oh`090>3Oh`030000003Pgn<0h=oS
00D0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo02l0oooo00L0YJbb0?l0003o0000o`0006IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh30?l00200h=oS00<0
YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`130?ooo`070:F//P3o
0000o`000?l0001VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0`3o000P0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3o
ool0@`3oool01`2U[;80o`000?l0003o0000IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOP<0o`00803Pgn<00`2U[;80oooo0?ooo`03
0?ooo`030000003oool0oooo04<0oooo00L0YJbb0?l0003o0000o`0006IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh30?l00200h=oS
00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`130?ooo`070:F/
/P3o0000o`000?l0001VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn0`3o000P0>3Oh`030:F//P3oool0oooo04T0oooo00L0YJbb0?l0
003o0000o`0006IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWh30?l00200h=oSC@2U[;830?l0000306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWic0?l0000306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWic0?l0000306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWic0?l0000306IVOP2XZK/0nocm0040IVIn0000
0`1VIWh0moOi09RHY`1e07MgTP40V9RW0@3gmoT106IVOP0000<0IVIn0?Og
n@2l_Ld0MP2l_Ld10?Ogn@40IVIn00000`1VIWh0moOi0>CSh`1f0>CSh`40
moOi0@1VIWh0000306IVOP3`lO@0oooo02l0oooo00<0i>?S09bT^@1[MHl0
0`1[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?oo
o`3Thn<0W:Bi101[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT^@3T
hn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W>T@0YSU40:LjA02W>T@90:Hi
A00309bT^@3/j^X0oooo00<0oooo0@3`lO@106IVOP0001H0IVIn0>;QhP3k
o?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0o?cm0?clo03lnod0o?cl0?ck
o03lo?`0nocl0?clo03ko?d0o?_l0?clo@3knod0nocl0P3lo?`0103lo?d0
o?cl0?_ko@3lo?dD0?cko080nocl00<0W:Bi06]eS`25RK004025RK001P1[
MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3ko?`0no_l
09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?clo03lnod0nocm0>;QhP01
06IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi0?Ogn03f
moP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0moKh0?Kg
n03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0C0?Ogn@80m_Oi00<0JgF?
08F9/02LW[h0402LW[h01P25RK00JgF?0?Ogn@3gmoT0JgF?08F9/140W9jn
00P0QHV`06]eS`3fmoP0moOh0:HiA02Z?5D0`U9K0<IDFPd0aUEL00T0aUAJ
0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>400@1VIWh0000606IV
OP3NgN40lO7d0?7am03`lO@0l?;d400000001P3alO@0l?;e0?7am03al_@0
l?;d0?7am1H0l?7e00<0JgF?0;:ed02WZ<80402WZ<801P2b]M00JgF?0?3a
m03`lO@0JgF?0;:ed140YjS200D0/[G@06]eS`3`lOD0lO;d0:HiA0020<9B
F`030<]DF@3=FEh0cEUN00/0cEUN00@0beAI0<9BF`32DU/0YSU40P3`lO@0
0`3alO@0l?;d0=kMh@0106IVOP0000L0IVIn0=cKh03Zjo00j^_`0>[/l03Y
jnl000000080inOW0P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0inOW0P3_
knl010000000j^_`0>[[l03Zjnl20>[[l0030>[[k`3Zjo00j^_`0180j^_`
0P3Zk?00101[MHl0][WA0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0
[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?oo
o`80[Jk600<0[:k60;Jid@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0
cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__
0@3Lfn0106IVOP0000@0IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<
0=kNgP3WinL0g]kN0080inOW00<0aV<00>OWi`3WinL00P3WinL01`3_knL0
kno_0>o_k`000000hnCZ0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0B
0>?Uj`80hnCZ00D0JgF?0;bne02b//X0/[;:0?ooo`0606i]S`0302DU=P2b
//X0/[;:00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ06]eS`2l_]@20;:bbP03
0?ooo`0U9CH09BDf00T09BDf0`2b//X01@2l_]@0JgF?0>?Tj`3Si>/0YSU4
0080cEUN00@0d5]P0=ALG`3oool0oooo1`3DG5l20?ooo`0:0=ALG`3@Ff00
cEUN0<eIGP2V>D@0hnCZ0>?UjP3Si>X0hnG[0=WIg`40IVIn00000`1VIWh0
emSN0=cNiP030=cNiP050000003WinL0inOW0>OWi`3We/h00P3WinL01@3>
N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_00L000000=cNiP3Lg^D0g=kU0=cN
iP3Lg^D0g=kV01H0g=kU00D0JgF?0;o1eP2h^Lh0^;W>0?ooo`0606i]S`03
02DU=P2h^Lh0^;W>00D0^;W>00H0_l7F06]eS`3Lg^D0g=kU06]eS`2o`MH2
0;RicP030?ooo`0U9CH0^;W>00L0^;W>00<0oooo02DU=P2h^Lh00P2h^Lh0
2@2o`MH0JgF?0=cNiP3Lg^D0YSU40<eIGP3AFUh0e5eQ05<U80030?ooo`D0
eUmS0`3oool01@1C9B00e5eQ0=5JGP3=FEh0YSU40080g=kU00<0g=kV0=cN
i@3Gf=h00@1VIWh0000406IVOP3Ee]d0eMSP0=KHh@80eMSP00T0000008b<
S03WinL0inOW0>NeQ03FFP00eX@00?o>003>H`000P3NJ`001@3_]H`0kno_
0>o_k`3_knl000000080eMSQ00@0eMOP0=KHh03Ff>40e]OQ503Fen020=KH
h00506]eS`33aMT0_;gA0;bmd@3oool01`0U9CH70;bmd@060<?5f@1[MHl0
eMSQ0=GHh@1[MHl0`lGI0P2l_M400`3oool09BDf0;bmd@070;bmd@030?oo
o`0U9CH0_;gA0080_;gA00D0`lGI06]eS`3Fen00eMOQ0:HiA0020=EMH003
0=QPH@3IHF80AQhJ00<0oooo0`3IHF830?ooo`0304HN6P3IHF80f61Q0080
eEeP00H0YSU40=KHh03Ef>40eMOP0=GHh@3Ee]d106IVOP0000L0IVIn0=;D
g@3?d]`0d=;L0=3Bg@3@d]`0000000<0inOW00`0imk>0<I:003gcP00kjd0
0>ne003>J`00aUX00<I[003NS4X0ijD00>oWcP0000030=3Bg0030<oBg03@
d]`0cm;L01@0d=;L0P3?d]d00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[
MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP03
0?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0
fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3L
IFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IV
OP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH
0>nm003gaP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl0
00000<_=f03;cMT0b/gI0<_>f03:cMP0blgH503;cMT20<_>f@0306]eS`3;
c=h0b<[I00P0b<[I00<0b<WI0<S:f@38b]T00`38b]T01038bMT0b<[I0<_<
gP1[MHl20<_=f00606]eS`3;c=h0b<[I0<S:f@3oool09BDf1@38b]T04@38
bMT0b<[I0<S:f@3oool09BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=
f02V>D@0eemO0=]TI03PIfD0h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3o
ool02P167QX0gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0YSU40<[>f03:c]T2
0<_=f@40d=;K0@1VIWh0000306IVOP3?cmX0aLSD00<0aLSD00H000000<K6
aP3Wg]H0cW/00>N]003_]@020>NU00030=JD003>L`00eY@00080mlH00P3g
moL010000000aLSD0<G7e035am@30<G7eA@0a<OE0P34b=@00`1[MHl0d=7P
0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3o
ool09BDf0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]e
S`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo
04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD0@35amD10<o?fP40
IVIn0000101VIWh0c<kJ0<;4dP31a=420<74dP060000003WinL0inOW0>OW
i`3FQ000kkD00P3WY@00203FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL0
00000`31a=800`32a=40`LCB0<74dP0D0<74d@80`LCB00<0JgF?0=?ChP3?
d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M00<0oooo
02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@020<o@g@070=?ChP1[MHl0
`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203QJFD0ffAT
0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:c=P0_/3?
0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<00020=jD00040=Ik0036
H`00_D800>nU0080mjd000P0mkD00?o>BP000000_/3>0;k0c`2n`<h0_/3?
0;g0cQD0_/3>0P2m`<h00`1[MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0
_/3>0;k0cP1[MHl0e]KT0P3Cdn000`3oool09BDf0?ooo`080?ooo`0;02DU
=P3Cdn00dm?P0=?Ch03Fe^@0JgF?0;k0c`2n`<h0YSU40>1VI@3QJVX0103S
K6`30?ooo`0404HN6P3oool0oooo0?ooo`@0hfa/00@0hFYZ0>1VI@2V>D@0
_L3?0P2n`<l10;k0cP40b/cH0@1VIWh0000706IVOP39b]P0][S80;Vlb`2j
_</0^[c<000000020>o_k`0C0=JL003FS000gY@00=J4003_Y@00gX`00;eJ
003FL`00ki`00?O_i`3gmoL0oooo0000002i_<`0^[_<0;Vlb`2j_</0^Kc<
0;Vlb`0D0;Vlc080^[c<00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?
0;Zlb`2j_</0JgF?0=SHi@80dm?Q00<0oooo06i]S`1^KHl0201^KHl03P0U
9CH0dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<0:HiA03PJFP0hFe/0>Aa
K@3TLFl0i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^00T0i75]
0>5]K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039b]P00@1VIWh0000906IV
OP37bML0];K70;Jhb02f^<T0][W900000024Q8@0inON0080kno_00L0aV/0
0?O6003_]@00ki`00=j<003>J`00ii`000<0moOg00D000000;Jib@2g^<T0
][W90;Nib@020;JhbA@0]kS90P2f^<T0101[MHl0e]KT0=SHi@3Hf>H30=SH
i@D0f=SV0`3Hf>D20=SHiP80f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3F
e^@0f=SU0=SHiP3oool02P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]e
S`2g^<T0]kW90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_
0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0
][S90;Jib@2d]/L0alWG0@1VIWh0000306IVOP36b=L0];K700<0];K700<0
00000>o_k`3_knl00P3_knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3N
U3T0kmJe0?ogm`3oool0000001`0];K700D0JgF?0=GEh`3LfnL0g=_W0=gK
i`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL0
9BDf02DU=P0902DU=P<0g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0
igEb0>YfL`3ZN7H00P3oool00`167QX0jGih0>UnN0030>UnN00804HN6P3o
ool0oooo0>YhMP3ZMW<0igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh00003
06IVOP36b=L0];K700<0];K700H0000008b<S03_knl0kno_0>O>N`3_knl2
0?Ogm`080>ND003gilh0moOg0?Ogm`3_imH0moOg0?ooo`00000L0;Bfa`03
06]eS`3Ee><0h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A
0>3OjP090=GDh`1[MHl0];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080
AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV1
0>n1NP3YO7P0jWUc0:HiA0040;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0
/K?800<0/K?800H000000>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OW
aP3gmoL0oooo00<0moOg00<0oooo0000002a/lP06`2a/lP00`1[MHl0kN_c
0>WXl@0@0>WXl@060>g[l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]
jo<0JgF?0;6cb02a/lP0YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fd
V`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al
0?60M@2V>D@0102a/lP10<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`030:n^
a`050000002][Jd0moO_0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<00000
0:n^a`2_[/L06P2_[/L00`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0
[jk70:n^a`1[MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:
O@80mI253@3b^9h20?F@Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8
e`40IVIn00000`1VIWh0`<7A0<O7e00_0:b[a00408B<XP1[MHl0c<_M0?_k
o0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3k
no`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0
o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH0
1P3jjkL0n]bg0?joY03oWhd0YSU4096HZP<0[:_40@37am@10<31d@40IVIn
0000101VIWh0`<7A0=;Bg`2e]<T_0:BS_P0308B<XP1[MHl0JgF?00l0JgF?
00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<
XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n
0:BS_P2TXkh0]KC90=;Bg`30`M400@1VIWh0000606IVOP2XYkl0i^K]0=;B
h02l_<l0/K34K`2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn0000
1`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@h03:b]X0K@2l_<l01P3:b]X0d=3P
0>CSj03lo?`0emSR08N7V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl
0?;al`3/jnh0hN;[J`3Gf>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1V
IWh00@1HEfP00080F5MX00<0IVIn09FDZ`3AdMh00P3lo?a]0?ooo`80o?cl
00<0dM7N09FDZ`1VIWh00P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW
_`1/0:RW_`0409FDZ`28Qid0IVIn06IVOP<0F5MX000505QGJ740IVIn1@1H
EfP00001\
\>"], "Graphics",
  CellLabel->"From In[17]:=",
  Evaluatable->False,
  ImageSize->{123, 60},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutOptions"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[17]=",
  CellTags->"LayoutOptions"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\"Spacing\"", "SubsubsectionIcon",
  CellTags->"LayoutOptions"],

Cell[TextData[{
  "The ",
  StyleBox["\"Spacing\" -> ", "Output"],
  StyleBox["n",
    FontSlant->"Italic"],
  " suboption allows a ",
  StyleBox["WidgetGroup", "Output"],
  " to specify an overall spacing element to exist between all widgets in the \
group."
}], "Text",
  CellTags->"LayoutOptions"],

Cell["\<\
Here we have forced a spacing of 30 points between all widgets in the \
group.\
\>", "Text",
  CellTags->"LayoutOptions"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
\[IndentingNewLine]WidgetGroup[{\[IndentingNewLine]{Widget["\<Label\>", \
{"\<text\>" -> "\<A:\>"}], \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<A content\>"}]}, \[IndentingNewLine]{Widget["\<Label\>", {"\
\<text\>" -> "\<B:\>"}], \[IndentingNewLine]Widget["\<TextField\>", \
{"\<text\>" -> "\<B content is the largest of all\>"}]}, \
\[IndentingNewLine]{Widget["\<Label\>", {"\<text\>" -> "\<C:\>"}], \
\[IndentingNewLine]Widget["\<TextField\>", {"\<text\>" -> "\<C content is \
larger than A\>"}]}\[IndentingNewLine]}, \ 
              WidgetLayout \[Rule] {"\<Grouping\>" -> 
                    Grid, \ "\<Spacing\>" \[Rule] 
                    30}]\[IndentingNewLine]]\[IndentingNewLine]];\)\)], \
"Input",
  CellLabel->"In[18]:=",
  CellTags->"LayoutOptions"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"LayoutOptions"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000350000VR000`400?l0
0000o`00003oa@1VIWh0000306IVOP3ko?d0nocm0<40nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0<00Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
_`1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0h=oS
U02U[;800`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
:@3Pgn<00`2U[;80oooo0?ooo`2@0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWhY0>3Oh`030:F//P3oool0oooo0900
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
ORT0h=oS00<0YJbb0?ooo`3oool0T03oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn:@3Pgn<00`2U[;80oooo0?ooo`1;
0?ooo`@00000@@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn:@3Pgn<00`2U[;80oooo0?ooo`1?0?ooo`030000003o
ool0oooo03h0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOP80h=oS0`0000020>3Oh`030000003Pgn<0h=oS01l0h=oS
00<0YJbb0?ooo`3oool01@3oool3000000H0oooo0`0000030?ooo`<00000
0P3oool01P000000oooo0?ooo`3oool000000?ooo`8000000P3oool30000
0080oooo00H000000?ooo`3oool0oooo0000003oool2000000@0oooo00<0
00000?ooo`3oool00`0000050?ooo`030000003oool0oooo0080000000@0
oooo0000003oool00000103oool2000000040?ooo`000000oooo0?ooo`<0
00000P3oool00`000000oooo0?ooo`040?ooo`80000000<0oooo0000003o
ool00P3oool00`000000oooo0?ooo`02000000040?ooo`000000oooo0000
00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo0140oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000606IVOP3ko?d0Z:Vk06IVOP3Pgn<000000`3Pgn<00`000000h=oS0>3O
h`0Q0>3Oh`030:F//P3oool0oooo00@0oooo00D000000?ooo`3oool0oooo
000000040?ooo`070000003oool0oooo0?ooo`000000oooo000000030?oo
o`030000003oool0000000<0oooo00<000000?ooo`0000000P3oool01`00
0000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0000
00050?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo000000020?ooo`80000000<0oooo0000003oool00P3o
ool00`000000oooo0?ooo`02000000030?ooo`000000oooo0080oooo00<0
00000?ooo`0000001P3oool010000000oooo0?ooo`0000030?ooo`030000
003oool000000080oooo0P0000000`3oool000000?ooo`020?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0A0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0000002P0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3o
ool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000P3oool0
0`000000oooo0?ooo`030?ooo`070000003oool0oooo0?ooo`000000oooo
000000050?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0`3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo
00L000000?ooo`3oool0oooo0000003oool0000000D0oooo00<000000?oo
o`3oool0103oool010000000oooo0?ooo`0000030?ooo`030000003oool0
000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`03
0?ooo`D00000503oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn0000000X0>3Oh`030:F//P3oool0oooo00<0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`030000003oool000000080
oooo1@0000000`3oool000000?ooo`020?ooo`030000003oool0000000D0
oooo00<000000?ooo`3oool00P0000060?ooo`030000003oool0oooo00@0
000000<0oooo0000003oool00P3oool01P000000oooo0?ooo`3oool00000
0?ooo`D0000000<0oooo0000003oool01@3oool010000000oooo0?ooo`00
00030?ooo`030000003oool0oooo00@0000000<0oooo0000003oool00P3o
ool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`000000
503oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn0000000X0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3o
ool01`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool0
10000000oooo0000000000020?ooo`030000003oool000000080oooo00H0
00000?ooo`3oool0oooo0000003oool200000080oooo00<000000?ooo`00
00001@3oool00`000000oooo000000030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`0000000`3oool010000000oooo0000000000020?oo
o`030000003oool0oooo0080000000<0oooo0000003oool00P3oool01000
0000oooo0000000000050?ooo`030000003oool0oooo008000000P3oool0
0`000000oooo000000030?ooo`040000003oool0000000000080oooo00<0
00000?ooo`3oool0103oool00`000000oooo0000000E0?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000H0h=oS
00<000000>3Oh`3Pgn<07`3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000
003oool0oooo00P0oooo0`0000030?ooo`<000000P3oool01@000000oooo
000000000000oooo00<000000P3oool300000080oooo00D000000?ooo`00
000000000?ooo`03000000@0oooo00<000000?ooo`3oool00`0000050?oo
o`030000003oool0oooo00<000000P3oool00`000000oooo000000020?oo
o`80000000@0oooo0000003oool0oooo0`0000020?ooo`030000003oool0
000000<0oooo0`0000000`3oool000000?ooo`02000000<0oooo0`000002
0?ooo`040000003oool00000000000L0oooo00<000000?ooo`0000005@3o
ool0102U[;80IVIn0:RY^`3ko?d106IVOP0000H0IVIn0?_lo@2XZK/0IVIn
0>3Oh`0000030>3Oh`030000003Pgn<0h=oS0240h=oS00<0YJbb0?ooo`3o
ool0103oool01@000000oooo0?ooo`3oool0000001H0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
01`0oooo00@000000?ooo`3oool000005P3oool00`000000oooo0000000E
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWh20>3Oh`<00000903Pgn<00`2U[;80oooo0?ooo`050?ooo`<000005`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0203oool00`000000oooo0?ooo`0L0?ooo`040000003o
ool0oooo000001L0oooo00<000000?ooo`3oool0503oool0102U[;80IVIn
0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn:@3Pgn<00`2U[;80
oooo0?ooo`2@0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0
nocm0:RY^`1VIWhY0>3Oh`030:F//P3oool0oooo0900oooo00@0YJbb06IV
OP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0h=oS00<0YJbb
0?ooo`3oool0T03oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn:@3Pgn<00`2U[;80oooo0?ooo`2@0?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhY0>3Oh`030:F/
/P3oool0oooo0900oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IV
OP3ko?d0Z:Vk06IVORT0h=oSU02U[;800`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn_@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn:@3Pgn>D0:F//P0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWhY0>3Oh`030:F//P3oool0oooo0900
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
ORT0h=oS00<0YJbb0?ooo`3oool0T03oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn:@3Pgn<00`2U[;80oooo0?ooo`2@
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWhY0>3Oh`030:F//P3oool0oooo05d0oooo1000000_0?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhY0>3Oh`030:F/
/P3oool0oooo0640oooo00<000000?ooo`3oool0;03oool0102U[;80IVIn
0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@0000020>3Oh`03
0000003Pgn<0h=oS01l0h=oS00<0YJbb0?ooo`3oool00`3oool5000000H0
oooo0`0000030?ooo`<000000P3oool01P000000oooo0?ooo`3oool00000
0?ooo`8000000P3oool300000080oooo00H000000?ooo`3oool0oooo0000
003oool2000000@0oooo00<000000?ooo`3oool00`0000050?ooo`800000
00<0oooo0000003oool00P3oool00`000000oooo0?ooo`03000000D0oooo
00<000000?ooo`3oool00P000000103oool000000?ooo`0000040?ooo`80
000000@0oooo0000003oool0oooo0`0000030?ooo`<000000P3oool20000
00D0oooo0`0000030?ooo`030000003oool0oooo00@0oooo0P0000001P3o
ool000000?ooo`000000oooo000000D0oooo00@0YJbb06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000103Pgn<00`000000h=oS
0>3Oh`0Q0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`00
0000oooo000000030?ooo`030000003oool0000000<0oooo00<000000?oo
o`0000000P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3o
ool00`000000oooo000000050?ooo`030000003oool0000000<0oooo00<0
00000?ooo`3oool00P3oool010000000oooo0?ooo`0000030?ooo`030000
003oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000oooo
000000020?ooo`80000000<0oooo0000003oool00P3oool00`000000oooo
0?ooo`02000000030?ooo`000000oooo0080oooo00<000000?ooo`000000
0`3oool00`000000oooo000000050?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080
000000@0oooo0000003oool000001@3oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000040>3Oh`030000003Pgn<0
h=oS0240h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool0
1`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo
000000020?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool0
oooo0000003oool0000000D0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`030?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`000000203oool00`000000oooo000000030?ooo`030000003oool0
000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000P0oooo
00@000000?ooo`3oool000001@3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool00`3oool02@000000oooo0?ooo`3oool0
00000?ooo`000000oooo000000050?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000@0h=oS00<000000>3Oh`3P
gn<08@3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`07
0000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0
00000080oooo1@0000000`3oool000000?ooo`020?ooo`030000003oool0
000000D0oooo00<000000?ooo`3oool00P0000060?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`000000100000040?ooo`030000003o
ool0oooo00@0000000<0oooo0000003oool00P3oool01P000000oooo0?oo
o`3oool000000?ooo`D000000P3oool2000000<0oooo00<000000?ooo`3o
ool00`3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool0103oool4000000040?ooo`000000oooo000000D0oooo00@0YJbb
06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPD00000903P
gn<00`2U[;80oooo0?ooo`030?ooo`D000001@3oool01`000000oooo0?oo
o`3oool000000?ooo`0000000`3oool010000000oooo0000000000020?oo
o`030000003oool000000080oooo00H000000?ooo`3oool0oooo0000003o
ool200000080oooo00<000000?ooo`0000001@3oool00`000000oooo0000
00030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P00
00020?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00P3o
ool00`000000oooo000000030?ooo`040000003oool0000000000080oooo
00<000000?ooo`3oool00P0000000`3oool000000?ooo`020?ooo`030000
003oool0000000<0oooo00<000000?ooo`0000001@3oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool02@000000
oooo0?ooo`3oool000000?ooo`000000oooo000000050?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000@0h=oS
00<000000>3Oh`0000008@3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool00`3oool3000000<0oooo
0`0000020?ooo`050000003oool000000000003oool00`0000020?ooo`<0
00000P3oool01@000000oooo000000000000oooo00<00000103oool00`00
0000oooo0?ooo`03000000@0oooo0`0000000`3oool000000?ooo`020000
00<0oooo0`0000050?ooo`030000003oool0oooo00<000000P3oool00`00
0000oooo000000020?ooo`80000000@0oooo0000003oool0oooo0`000003
0?ooo`<0000000@0oooo00000000000000001@3oool300000080oooo0`00
00050?ooo`<000000P3oool00`000000oooo000000050?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0000000@0h=oS
00<000000>3Oh`3Pgn<08@3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00@000000?ooo`3oool0
00003P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool02@3oool00`000000oooo000000050?ooo`04
0:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWh50000
02@0h=oS00<0YJbb0?ooo`3oool00`3oool5000001L0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00P0oooo00@000000?ooo`3oool000003P3oool00`000000oooo0?ooo`0K
0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0203oool0
0`000000oooo000000050?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
101VIWh0nocm0:RY^`1VIWhY0>3Oh`030:F//P3oool0oooo0900oooo00@0
YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0h=oS
00<0YJbb0?ooo`3oool0T03oool0102U[;80IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn:@3Pgn<00`2U[;80oooo0?ooo`2@0?ooo`04
0:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhY0>3O
h`030:F//P3oool0oooo0900oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVORT0h=oS00<0YJbb0?ooo`3oool0T03oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn:@3P
gn>D0:F//P0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjm0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWhY0>3Ohi@0YJbb00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVORT0h=oS00<0YJbb0?ooo`3oool0T03oool0102U[;80IVIn0:RY
^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn:@3Pgn<00`2U[;80oooo
0?ooo`2@0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm
0:RY^`1VIWhY0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3o
ool0RP3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn:@3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo
08X0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk
06IVORT0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`2:
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0000000D0h=oS00<000000>3Oh`000000803Pgn<00`2U[;80oooo0?oo
o`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3o
ool3000000<0oooo0`0000020?ooo`060000003oool0oooo0?ooo`000000
oooo0P0000020?ooo`<000000P3oool01P000000oooo0?ooo`3oool00000
0?ooo`800000G`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn000000050>3Oh`030000003Pgn<0h=oS0200h=oS00<0
YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo000000020?ooo`07
0000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0
00000600oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP3Pgn<01@00000S0>3Oh`030:F//P3oool0oooo00<0oooo1P00
00050?ooo`030000003oool0oooo00<0oooo00L000000?ooo`3oool0oooo
0000003oool0000000<0oooo00<000000?ooo`0000000P3oool00`000000
oooo0?ooo`030?ooo`070000003oool0oooo0?ooo`000000oooo0000001P
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001P1VIWh0nocm0:RY^`1V
IWh0h=oS000000<0h=oS00<000000>3Oh`3Pgn<08@3Pgn<00`2U[;80oooo
0?ooo`030?ooo`8000000`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00<0oooo00L000000?ooo`3oool0oooo0000003oool00000
00<0oooo00<000000?ooo`0000000P3oool5000000030?ooo`000000oooo
0080oooo00<000000?ooo`000000H03oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`000000h=oS0000000T
0>3Oh`030:F//P3oool0oooo00<0oooo00D000000?ooo`000000oooo0000
00060?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`04
0000003oool0000000000080oooo00<000000?ooo`0000000P3oool01P00
0000oooo0?ooo`3oool000000?ooo`8000000P3oool00`000000oooo0000
001P0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWh20>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0
7P3Pgn<00`2U[;80oooo0?ooo`030?ooo`050000003oool000000?ooo`00
00001`3oool3000000<0oooo0`0000020?ooo`050000003oool000000000
003oool00`0000020?ooo`<000000P3oool01@000000oooo000000000000
oooo00<00000G`3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`000000h=oS0000000T0>3Oh`030:F//P3o
ool0oooo00<0oooo00D000000?ooo`000000oooo0000000H0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0GP3oool0102U[;80IVIn
0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3Pgn<00`000000
h=oS0>3Oh`0S0>3Oh`030:F//P3oool0oooo00<0oooo00@000000?ooo`3o
ool000006@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
05h0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk
06IVORT0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`2:
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWhY0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0RP3o
ool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
:@3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo08X0oooo
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0
h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`2:0?ooo`04
0:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhY0>3O
h`030:F//P3oool0oooo0900oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVORT0h=oSU02U[;800`1VIWh0Z:Vk0?_lo@01
06IVOP0000<0IVIn0?Ogn@2HV:L0_`1gMi8109RHY`40moOi0@1VIWh00003
06IVOP3gmoT0_;g=0<00_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3Thn<0
`03Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`1i0?ooo`030>CSh`2L
Y;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S
0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl0
1P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0
YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F06IV
OP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m
0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080o?cl
00@0o?cm0?clo03knod0o?cm;@3lno`/0?_lo0L0nocm00<0W:Bi06]eS`25
RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?
09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?clo03l
nod0nocm0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3f
moP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080
moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0/0?Og
nB`0m_Oi1`3gmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0moOi
0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:XlE@32
DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi
0>3Ph@0106IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@00000006
0?7am03`l_D0lO7d0?7bm03`l_@0lO7dF@3`lOD70?3am00306]eS`2b]M00
YjS20100YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:e
d01[MHl0l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP04
0<]DF@32DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh00007
06IVOP3Lfn00j^_`0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3WinL0
0`3W_H@0inOW0>OWi`030>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Z
jo000`3Zjnl0j^_`0>[[l00[0>[[l2`0j^c`1`3Zjnl0101[MHl0][WA0:f^
aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[MHl0
0P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Jid@1[
MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO0<eF
F`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0IVIn
0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080inOW
00<0aV<00>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ0>?T
j`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0[0>?Ujb`0hnCZ1`3SiNX01@1[
MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b//X0
1P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH0
2@0U9CH30;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00
e5aO0?ooo`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03S
i>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0g=kV
00D000000>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW0>ON
aP3_S1000`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H0H03L
g^D01@1[MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh0
1@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo02DU
=P2h^Lh01`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0g=kV
0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`0505<U
803DGF40dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IVOP00
00@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0ikF4
0=IJ003FQ000olh00<iS00020=i[00050>neS03_knl0kno_0>o_k`000000
0P3Ef>40103Een00e]SP0=KHh@3Fen4]0=KGh2`0e]SP1`3Ef>401@1[MHl0
`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?0=GHh@3Ef>40
JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M401`2l_M400`3oool09BDf0;bm
d@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V>D@00P3EGF000`3HH640fF5R
04HN6P030?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@020=EMH0060:Hi
A03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0000706IVOP3Be=d0cm;L0=3B
g03@d]d0d=;L000000030>OWi`0<0>ONcP36BP00mlh00>n]003_]@00cV/0
0<IJ0036J`00gXa:0>NU003_ilh000000`3@d]`00`3?d]`0d=;L0<oBg00]
0=3Bg2`0cm;M1`3@d]`00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[MHl0
d=;L0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP030?oo
o`0U9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0fF5R
00<0g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3LIFD0
g6EU0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IVOP00
01`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH0>nm
003gaP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl00000
0<_=f03;cMT0b/gI0<_>f03:cMP0blgH;@3;cMT/0<_>f@L0blgH00<0JgF?
0<_<gP38b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38b]T0
blcN06]eS`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A
0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;c]P0
b/gH0:HiA03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?ooo`03
0?ooo`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>
f@80blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P000000
a/K60>ONeP3>N`00ijd00>ne0080ijD000<0eY@00<ic003FU0000P3gaP02
0?Ogm`0400000035b=@0aLOD0<G7e0<0aLOE;@34amD/0<C8e0L0a<OD00<0
JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3Ah080
bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;g007
0=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3oool0
oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040aLOE
0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000inOW
0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm003_
knl0moOg000000<0`LCB00<0`/CA0<74dP31a=80;@31a=4/0<74dPL0`/CB
00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?0=?C
hP80cm3M00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@020<o@
g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3P
K6T0203QJFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh00004
06IVOP3:c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<0002
0=jD00040=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>BP000000_/3>
0;k0c`2n`<h0_/3?0;g0cRh0_/3>;02m`<h70;k0cP0306]eS`3Fe^@0dm?P
0100dm?P00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?ooo`0U
9CH0oooo00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?0;k0
cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo103S
K6`0103QJVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP0000L0
IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<003N
U000eX@00>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3oool000000;Vl
c02j^l`0^Kc;0;Zlb`2i_<`0^Kc;02d0^Kc<;02j_<`70;Zlb`0306]eS`3H
f>D0dm?Q0100dm?Q00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@03
0?ooo`1^KHl0KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0
^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`
KP167QX00`3oool20>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vl
b`2f^<P0bL[H0040IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@00
0000Q8B40>OWgP020>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL
00030?Ogm`050000002f^LT0]kS90;Jib@2g^LT00P2f^<T]0;NhbB`0][S9
1`2g^<T0101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SHiP80
f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool02P1^
KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03TKVd0
i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0oooo
00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG0@1V
IWh0000306IVOP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_knl0
2`3W[@00mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool00000
06H0];K700D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[MHl0
];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0g=_W
00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3oool0
0`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0igEb
0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0];K7
00H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0moOg
0?Ogm`3_imH0moOg0?ooo`00001V0;Bfa`0306]eS`3Ee><0h=oZ0100h=oZ
00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0];K7
0;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]UhX0
jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:HiA004
0;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H000000>o_
k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg00<0
oooo0000002a/lP0I@2a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[l`1[
MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0YSU4
0?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0
lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP10<K8
e`40IVIn00000`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_0?Og
m`3_knl01P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L0I02_[/L00`1[
MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S4@3b
lOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@Q@03
0?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0`<7A
0<O7e01i0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[
MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0
JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf0080
nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03oWhd0
YSU4096HZP<0[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;Bg`2e
]<Ui0:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2T
Xkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0
Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;Bg`30
`M400@1VIWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34^@2XYkl01@2a
/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3lo?`0
i>?X0=3@h03:b]X0]`2l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7V`40
F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[]@3Gf>80
1`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX00<0
IVIn09FDZ`3AdMh00P3lo?bg0?ooo`80o?cl00<0dM7N09FDZ`1VIWh00P1H
EfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW_`2f0:RW_`0409FDZ`28Qid0
IVIn06IVOP<0F5MX000505QGJ;/0IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[19]:=",
  Evaluatable->False,
  ImageSize->{197, 154},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutOptions"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[19]=",
  CellTags->"LayoutOptions"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Layout Examples", "Section",
  CellTags->"LayoutExamples"],

Cell["\<\
It is perhaps easiest to see when to use certain layout elements by visually \
illustrating how they each combine to create a resizable dialog.  Here are a \
number of further examples that combine some of the previous layout features \
and common interface layout design patterns.\
\>", "Text",
  CellTags->"LayoutExamples"],

Cell[CellGroupData[{

Cell["Tabbed Pane Examples", "SubsectionIcon",
  CellTags->"LayoutExamples"],

Cell["\<\
Here is an example that generates content within a set of tabbed panes.\
\>", "Text",
  CellTags->"LayoutExamples"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ 
      GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
\[IndentingNewLine]WidgetGroup[{\[IndentingNewLine]{Widget["\<Button\>", \
{"\<text\>" -> "\<Button A\>"}], \ 
                Widget["\<TextField\>", \ {"\<text\>" -> "\<someA\>"}]}, \
{Widget["\<Button\>", {"\<text\>" -> "\<Button B\>"}], \ 
                Widget["\<TextField\>", \ {"\<text\>" -> "\<someB\>"}]}\
\[IndentingNewLine]}, \ 
            Name -> "\<myTabPane\>", \[IndentingNewLine]WidgetLayout \[Rule] \
{"\<Grouping\>" \[Rule] {Tabs, \ 
                    Bottom, {"\<One\>", "\<Two\>"}}}]\[IndentingNewLine]]\
\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"LayoutExamples"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject99201446838273, 
        JLink`Objects`JavaObject77868428165121]]], "Output",
  CellLabel->"Out[20]=",
  CellTags->"LayoutExamples"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"LayoutExamples"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000JR000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3Pgn<0
gL:=0>BG?00L0>J;;0030>^G;P3QaXh0h=oS0540h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3QaXh0kYla0?^n>@0L0?o8
?0030?Vi>03^Wc40hLJ>0540h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00006
06IVOP3ko?d0Z:Vk06IVOP3MXE<0nKPh7P3oac`01@3i^3P0gJ5C0>3Oh`38
dLd0XK>k01X0TJNd00<0ZKVo0=3Fd03Pgn<0<@3Pgn<00`1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn096KW00P0?cloP04096KW03@
e]00]/C=0>galaX0oooo00<0i>W/0;K4c@3@e]00<@3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn096KW00P0?cloP04096K
W02Y^Kl0hnW[0?knoAX0oooo00<0o_kn0>?Yk02Y^Kl0<@3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn096KW0080?cloP<0
00000`3lo?h01@000000o?cn0?cloP3lo?h000000080o?cn0`0000080?cl
oP03096KW02AYk@0m_Cb01`0oooo00<0oOgl096W]03Pgn<0<03Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn096KW0070?cl
oP050000003lo?h0o?cn0?cloP0000000P3lo?h01`000000o?cn0?cloP3l
o?h000000?cloP0000000`3lo?h00`000000o?cn0?cloP050?cloP03096K
W02AYk@0oooo01d0oooo00<0TJNd0>3Oh`3Pgn<0;`3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn096KW0060?cloP030000
003lo?h0o?cn00<0o?cn00<000000?cloP0000000`3lo?h00`000000o?cn
0000000;0?cloP03096KW02AYk@0oooo00D0oooo00<000000?ooo`3oool0
0`3oool01@000000oooo0?ooo`3oool0000000@0oooo0`0000060?ooo`03
096W]03Pgn<0h=oS02l0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP2AVi`01P3lo?h00`000000o?cn0?cloP030?cloP03
0000003lo?h0000000<0o?cn00<000000?cloP000000100000070?cloP03
096KW02AYk@0n_Wn00D0n_Wn00<000000?[ioP3jnOh00`3jnOh01@000000
n_Wn0?[ioP3jnOh0000000<0n_Wn00D000000?[ioP3jnOh0n_Wn00000005
0?[ioP03096W]03Pgn<0h=oS02l0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP2AVi`01P3lo?h00`000000o?cn0?cloP03
0?cloP040000003lo?h0000000000080o?cn00<000000?cloP0000000`3l
o?h00`000000o?cn0?cloP050?cloP03096KW02AYk@0mOCm00D0mOCm00<0
00000?Gdo@3em?d00P3em?d01`000000mOCm0000003em?d000000?Gdo@00
00000P3em?d01@000000mOCm0?Gdo@3em?d0000000<0mOCm00<0m_Cm0?Gd
o@2AYk@0<@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn096KW0060?cloP030000003lo?h0o?cn00<0o?cn00@000000?cl
oP000000o?cn0P0000030?cloP<00000203lo?h00`2AVi`0TJNd0?7ao@05
0?7ao@030000003alOd0lO7m0080lO7m00L000000?7ao@000000lO7m0000
003alOd000000080lO7m00D000000?7ao@3alOd0lO7m000000050?7ao@03
096W]03Pgn<0h=oS02l0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP2AVi`01`3lo?h01@000000o?cn0?cloP3lo?h00000
01@0o?cn00<0TI^L096W]03Zj_T01@3Zj_T01@000000j^[i0>[Zn@3Zj_T0
00000080j^[i00<000000>[Zn@0000000P3Zj_T00`000000j^[i00000003
0>[Zn@030000003Zj_T0j^[i00<0j^[i00<0TJNd0>3Oh`3Pgn<0;`3Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn096KW008
0?cloP<000005@3lo?h00`2AVi`0TJNd0>[Zn0050>[Zn0050000003Zj_P0
j^[h0>[Zn00000000`3Zj_P01@000000j^[h0>[Zn03Zj_P000000080j^[h
0`0000060>[Zn003096W]03Pgn<0h=oS02l0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2AVi`0803lo?h00`2AVi`0TJNd
0>GVm0050>GVm0030000003Ui_@0iNKd01D0iNKd00<0TJNd0>3Oh`3Pgn<0
;`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
096KW00P0?cloP03096KW02AYk@0gmoa00<0gmoa1@00000E0=oOl@03096W
]03Pgn<0h=oS02l0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP2AVi`0803lo?h00`2AVi`0TJNd0=_Lk@0:0=_Mk@@0fmc]
3`3KgNd00`2AYk@0h=oS0>3Oh`0_0>3Oh`0306IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0TI^L0200o?cn00<0TI^L096W]03EenT0
7@3EenT00`2AYk@0h=oS0>3Oh`0_0>3Oh`0306IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0TI^L0200o?cn00<0TI^L096W]03<cN80
7@3<cN800`2AYk@0h=oS0>3Oh`0_0>3Oh`0306IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0TI^L0200o?cn00<0TI^L096W]036b=d0
7@36b=d00`2AYk@0h=oS0>3Oh`0_0>3Oh`0306IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0TI^L0200o?cn00<0TI^L096W]02n_]P0
6@2n_]P20;jof080_[kH00<0TJNd0>3Oh`3Pgn<0;`3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I00Q0>3Ohe40LFmT
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80WIfQ
803Pgn=@09fMX@04075_I01VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0oooo0700h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IV
OP0000H0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn=^0:F//P060>3Oh`2MWJ40
LFmT06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3oool0
h=oS0:F//P1/0?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb06`0oooo00L0
YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm
0:RY^`1VIWh0oooo0>3Oh`2U[;80K03oool01`2U[;80h=oS09fMX@1aKf@0
IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3oool0h=oS
0:F//P1/0?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IV
OP0000L0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb06`0oooo00L0YJbb
0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY
^`1VIWh0oooo0>3Oh`2U[;801P3oool3000000<0oooo0`0000020?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool00`0000020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0A03oool01`2U
[;80h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP3oool0h=oS0:F//P050?ooo`070000003oool0oooo0?ooo`00
0000oooo000000030?ooo`030000003oool000000080oooo00H000000?oo
o`3oool000000?ooo`0000030?ooo`030000003oool0000000D0oooo00<0
00000?ooo`3oool0A03oool01`2U[;80h=oS09fMX@1aKf@0IVIn0:RY^`3k
o?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0:F//P080?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`0000000P3oool0
1P000000oooo0?ooo`000000oooo000000H0oooo1@0000170?ooo`070:F/
/P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3Pgn<0YJbb00H0oooo0P0000030?ooo`070000003oool0
oooo0?ooo`000000oooo000000020?ooo`050000003oool0oooo0000003o
ool01@0000020?ooo`050000003oool0oooo0?ooo`000000A`3oool01`2U
[;80h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP3oool0h=oS0:F//P050?ooo`070000003oool0oooo0?ooo`00
0000oooo000000030?ooo`050000003oool000000000003oool00P000000
103oool000000?ooo`0000030?ooo`070000003oool0oooo0?ooo`000000
oooo000000180?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb00H0oooo0`00
00030?ooo`<000000P3oool00`000000oooo000000020?ooo`040000003o
ool0oooo0?ooo`<00000103oool00`000000oooo000000180?ooo`070:F/
/P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3Pgn<0YJbb0240oooo00<000000?ooo`000000B03oool0
1`2U[;80h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP3oool0h=oS0:F//P0R0?ooo`030000003oool0oooo04L0
oooo00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1V
IWh0nocm0:RY^`1VIWh0oooo0>3Oh`2U[;80K03oool01`2U[;80h=oS09fM
X@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3o
ool0h=oS0:F//P1/0?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_l
o@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb06`0oooo
00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0oooo0>3Oh`2U[;80K03oool01`2U[;80h=oS09fMX@1a
Kf@0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3oool0
h=oS0:F//P1/0?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000H0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn=^0:F//P060>3Oh`2M
WJ40LFmT06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP3o
ool0L03Pgn<01@2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0oooo0700h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`1`0>3Oh`0509fMX@1aKf@0
IVIn0:RY^`3ko?d00@1VIWh0000;06IVOP3ko?d0Z:Vk06IVOP3oool0h=oS
0>7Pi03ViNP0k>_^0?3`lP3bl_@0<P3clo@`0?Sgn080lo?d00/0lo?e0?Cd
m@3emOH0m??e0>GTj03Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP00
00X0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0g]cO0>CRh01kUjd09EN5IP00
?7@02P0GCGh0Jh^V0?;akP3blO<0h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d1
06IVOP0000X0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0f]SI06J5X@1:LI<0
/[g3IP36aML02P30a/D0B6j@06Z:Y03_ko40h=oS09fMX@1aKf@0IVIn0:RY
^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0f=GF01M=
OP2oalX0J036aML02@2f_Kd05den0>_Zk@3Pgn<0WIfQ075_I01VIWh0Z:Vk
0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0fMGE000l
M03oool0J03=c=l02@3oool003ad0>SWjP3Pgn<0WIfQ075_I01VIWh0Z:Vk
0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0fMGE000l
M03oool0J03BdN@02@3oool003ad0>OVj@3Pgn<0WIfQ075_I01VIWh0Z:Vk
0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0fMGE000l
M03oool0J03FenL02@3oool003ad0>OVj@3Pgn<0WIfQ075_I01VIWh0Z:Vk
0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0fMGE000l
M03oool07`3If^L5000000<0fM[W0P0000000`3If^L000000=WJi`020000
00030=WJi`00000000000080fM[W0`0000020=WJi`050000003If^L0fM[W
0=WJi`000000103If^L00`000000fM[W0=WJi`030=WJi`030000003If^L0
fM[W01h0fM[W00T0oooo000lM03Wi^T0h=oS09fMX@1aKf@0IVIn0:RY^`3k
o?d00@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0=WEe@00?7@0
oooo01l0fM[W00<000000=WJi`3If^L00P3If^L00`000000fM[W00000002
0=WJi`80000000D0fM[W0000003If^L0fM[W000000020=WJi`070000003I
f^L0fM[W0=WJi`000000fM[W000000030=WJi`030000003If^L0fM[W0080
fM[W00<000000=WJi`3If^L00`3If^L00`000000fM[W0=WJi`0N0=WJi`09
0?ooo`00?7@0inKY0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn0000
2@1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`3IeMD003ad0?ooo`0O0=kOk003
0000003Ngn`0g]o/0080g]o/00<000000=kOk00000000`3Ngn`00`000000
g]o/000000020=kOk0040000003Ngn`0g]o/000000<0g]o/00<000000=kO
k00000000`3Ngn`00`000000g]o/0=kOk0030=kOk0D000008@3Ngn`02@3o
ool003ad0>OVj@3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000T0
IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0fMGE000lM03oool07`3SiO000`00
0000hnG`0>?Ul0020>?Ul0030000003SiO00000000<0hnG`00<000000>?U
l00000000P3SiO0010000000hnG`0>?Ul00000030>?Ul0030000003SiO00
000000<0hnG`00<000000>?Ul03SiO000`3SiO001@000000hnG`0>?Ul03S
iO0000000240hnG`00T0oooo000lM03Wi^T0h=oS09fMX@1aKf@0IVIn0:RY
^`3ko?d00@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0=WEe@00
?7@0oooo01l0jN_e1@0000020>W[m@070000003YjoD0jN_e0>W[m@000000
jN_e000000020>W[m@040000003YjoD0jN_e000000<0jN_e00@000000>W[
m@00000000000P3YjoD00`000000jN_e0>W[m@040>W[m@030000003YjoD0
00000280jN_e00T0oooo000lM03Wi^T0h=oS09fMX@1aKf@0IVIn0:RY^`3k
o?d00@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0=WEe@00?7@0
oooo01l0l?7l00<000000?3ao03`lO`00P3`lO`00`000000l?7l00000003
0?3ao0L000000P3`lO`300000080l?7l00@000000?3ao000000000001`3`
lO`00`000000l?7l0000000R0?3ao0090?ooo`00?7@0inKY0>3Oh`2MWJ40
LFmT06IVOP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0oooo
0>3Oh`3IeMD003ad0?ooo`0O0?Ceo@030000003dmOd0m?Gm0080m?Gm00<0
00000?Ceo@3dmOd01@3dmOd010000000m?Gm0?Ceo@00000C0?Ceo@030000
003dmOd000000280m?Gm00T0oooo000lM03Wi^T0h=oS09fMX@1aKf@0IVIn
0:RY^`3ko?d00@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0=WE
e@00?7@0oooo01l0m_Om1@0000080?Kgo@040000003fmod0m_Om000001@0
m_Om00<000000?Kgo@3fmod08@3fmod02@3oool003ad0>OVj@3Pgn<0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?oo
o`3Pgn<0fMGE000lM03oool0J03ho?d02@3oool003ad0>OVj@3Pgn<0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?oo
o`3Pgn<0fMGE000lM03oool0J03moOd02@3oool003ad0>OVj@3Pgn<0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?oo
o`3Pgn<0fMGE000lM03oool0J03moOd02@3oool003ad0>KVj@3Pgn<0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?oo
o`3Pgn<0f=CD000lM03oool0J03moOd02@3oool003ad0>GUj03Pgn<0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?oo
o`3Pgn<0fMGE02EGQ@2oc]`0J03oool02@2oc]/09EN50>7Qi03Pgn<0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000X0IVIn0?_lo@2XZK/0IVIn0?oo
o`3Pgn<0fMGE07VDZ@1EOJ80`<oMIP3oool02P3EgnP0EGfR07VEZ`3OgN00
h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d106IVOP0000X0IVIn0?_lo@2XZK/0
IVIn0?ooo`3Pgn<0f]OI0=oLf01iU:T09EN5IP00?7@02P0GCGh0IXJQ0>3N
fP3Lfmd0h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d106IVOP0000T0IVIn0?_l
o@2XZK/0IVIn0?ooo`3Pgn<0gmgP0=[Gf@3He=@0=03Gdm@`0=?>c0<0em?D
00X0f=CD0=WEe@3JemT0gmgP0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP3oool0L03Pgn<01@2MWJ40LFmT06IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWib0?ooo`04075_
I01VIWh0Z:Vk0?_lo@40IVIn00000`1VIWh0moOi09RHY`1e07MgTP40V9RW
0@3gmoT106IVOP0000<0IVIn0?Ogn@2l_Ld0MP2l_Ld10?Ogn@40IVIn0000
0`1VIWh0moOi0>CSh`1f0>CSh`40moOi0@1VIWh0000306IVOP3`lO@0oooo
02l0oooo00<0i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?06afT01/MY09
06]eS`0609bT^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0101/MY00JgF?
06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0W:Bi102V>D@0
102W>T@0YSU40:LjA02W>T@90:HiA00309bT^@3/j^X0oooo00<0oooo0@3`
lO@106IVOP0001H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0no_m0?_lo@3k
o?`0o?cm0?clo03lnod0o?cl0?cko03lo?`0nocl0?clo03ko?d0o?_l0?cl
o@3knod0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?dD0?cko080nocl00<0
W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40
QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0
nocl0?clo03lnod0nocm0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi
0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3g
moT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi
0?Ogn@0C0?Ogn@80m_Oi00<0JgF?08F9/02LW[h0402LW[h01P25RK00JgF?
0?Ogn@3gmoT0JgF?08F9/140W9jn00P0QHV`06]eS`3fmoP0moOh0:HiA02Z
?5D0`U9K0<IDFPd0aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh
0?Ogn@3Ph>400@1VIWh0000606IVOP3NgN40lO7d0?7am03`lO@0l?;d4000
00001P3alO@0l?;e0?7am03al_@0l?;d0?7am1H0l?7e00<0JgF?0;:ed02W
Z<80402WZ<801P2b]M00JgF?0?3am03`lO@0JgF?0;:ed140YjS200D0/[G@
06]eS`3`lOD0lO;d0:HiA0020<9BF`030<]DF@3=FEh0cEUN00/0cEUN00@0
beAI0<9BF`32DU/0YSU40P3`lO@00`3alO@0l?;d0=kMh@0106IVOP0000L0
IVIn0=cKh03Zjo00j^_`0>[/l03Yjnl000000080inOW0P3Ng]h20>OWi`03
0>NmQ03WinL0inOW00<0inOW0P3_knl010000000j^_`0>[[l03Zjnl20>[[
l0030>[[k`3Zjo00j^_`0180j^_`0P3Zk?00101[MHl0][WA0:f^aP2][/H8
0?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0
101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Z
jo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0
cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3S
iNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<0
0>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX0
0P3Si>X00`3Si>/0hnG[0>?Uj`0B0>?Uj`80hnCZ00D0JgF?0;bne02b//X0
/[;:0?ooo`0606i]S`0302DU=P2b//X0/[;:00D0/[;:00H0_;kD06]eS`3S
iNX0hnGZ06]eS`2l_]@20;:bbP030?ooo`0U9CH09BDf00T09BDf0`2b//X0
1@2l_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN00@0d5]P0=ALG`3oool0oooo
1`3DG5l20?ooo`0:0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnCZ0>?UjP3Si>X0
hnG[0=WIg`40IVIn00000`1VIWh0emSN0=cNiP030=cNiP050000003WinL0
inOW0>OWi`3We/h00P3WinL01@3>N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_
00L000000=cNiP3Lg^D0g=kU0=cNiP3Lg^D0g=kV01H0g=kU00D0JgF?0;o1
eP2h^Lh0^;W>0?ooo`0606i]S`0302DU=P2h^Lh0^;W>00D0^;W>00H0_l7F
06]eS`3Lg^D0g=kU06]eS`2o`MH20;RicP030?ooo`0U9CH0^;W>00L0^;W>
00<0oooo02DU=P2h^Lh00P2h^Lh02@2o`MH0JgF?0=cNiP3Lg^D0YSU40<eI
GP3AFUh0e5eQ05<U80030?ooo`D0eUmS0`3oool01@1C9B00e5eQ0=5JGP3=
FEh0YSU40080g=kU00<0g=kV0=cNi@3Gf=h00@1VIWh0000406IVOP3Ee]d0
eMSP0=KHh@80eMSP00T0000008b<S03WinL0inOW0>NeQ03FFP00eX@00?o>
003>H`000P3NJ`001@3_]H`0kno_0>o_k`3_knl000000080eMSQ00@0eMOP
0=KHh03Ff>40e]OQ503Fen020=KHh00506]eS`33aMT0_;gA0;bmd@3oool0
1`0U9CH70;bmd@060<?5f@1[MHl0eMSQ0=GHh@1[MHl0`lGI0P2l_M400`3o
ool09BDf0;bmd@070;bmd@030?ooo`0U9CH0_;gA0080_;gA00D0`lGI06]e
S`3Fen00eMOQ0:HiA0020=EMH0030=QPH@3IHF80AQhJ00<0oooo0`3IHF83
0?ooo`0304HN6P3IHF80f61Q0080eEeP00H0YSU40=KHh03Ef>40eMOP0=GH
h@3Ee]d106IVOP0000L0IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@d]`0000000<0
inOW00`0imk>0<I:003gcP00kjd00>ne003>J`00aUX00<I[003NS4X0ijD0
0>oWcP0000030=3Bg0030<oBg03@d]`0cm;L01@0d=;L0P3?d]d00`1[MHl0
b<WK0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H0
0`3oool09BDf0<?4eP070<?4eP030?ooo`0U9CH0`lCF0080`lCF00L0b<WK
06]eS`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU00D0AQhJ0?ooo`3oool0
oooo0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aUI@3IHF80eemO0:HiA03@
d]d20=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>
f03:cMP000000>O6[@3WaX`0mlhH0>nm003gaP00kjd00>N]003WY@00eX`0
0<i[003WaP00omH00>o_i`3_knl000000<_=f03;cMT0b/gI0<_>f03:cMP0
blgH503;cMT20<_>f@0306]eS`3;c=h0b<[I00P0b<[I00<0b<WI0<S:f@38
b]T00`38b]T01038bMT0b<[I0<_<gP1[MHl20<_=f00606]eS`3;c=h0b<[I
0<S:f@3oool09BDf1@38b]T04@38bMT0b<[I0<S:f@3oool09BDf0<S:f@38
bMT0b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0eemO0=]TI03PIfD0h6IU0080
gVMW00<0AQhJ0?ooo`3oool00`3oool02P167QX0gVMW0=iWI`3PIVD0h6MU
0=]TI03GGel0YSU40<[>f03:c]T20<_=f@40d=;K0@1VIWh0000306IVOP3?
cmX0aLSD00<0aLSD00H000000<K6aP3Wg]H0cW/00>N]003_]@020>NU0003
0=JD003>L`00eY@00080mlH00P3gmoL010000000aLSD0<G7e035am@30<G7
eA@0a<OE0P34b=@00`1[MHl0d=7P0<_;g00@0<_;g0060=3Ah01[MHl0a<OD
0<C7e01[MHl0d=7P0P3;bm`00`3oool09BDf0<_;g0070<_;g0030?ooo`0U
9CH0bl_L0080bl_L00L0d=7P06]eS`35am@0a<OD0:HiA03KI6@0gfET00D0
h6YX00D0AQhJ0?ooo`3oool0oooo04HN6P050>1ZJ0040=mUI03KI6@0YSU4
0<C8e@80a<SD0@35amD10<o?fP40IVIn0000101VIWh0c<kJ0<;4dP31a=42
0<74dP060000003WinL0inOW0>OWi`3FQ000kkD00P3WY@00203FQ000cV/0
0>N]003g]@00mkd00>o_k`3gmoL000000`31a=800`32a=40`LCB0<74dP0D
0<74d@80`LCB00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32
a=80JgF?0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf
0<o@g@020<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/
J@D0oooo1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ
0@1VIWh0000406IVOP3:c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0
imkF0=J<00020=jD00040=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>
BP000000_/3>0;k0c`2n`<h0_/3?0;g0cQD0_/3>0P2m`<h00`1[MHl0e]KT
0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0cP1[MHl0e]KT0P3Cdn000`3o
ool09BDf0?ooo`080?ooo`0;02DU=P3Cdn00dm?P0=?Ch03Fe^@0JgF?0;k0
c`2n`<h0YSU40>1VI@3QJVX0103SK6`30?ooo`0404HN6P3oool0oooo0?oo
o`@0hfa/00@0hFYZ0>1VI@2V>D@0_L3?0P2n`<l10;k0cP40b/cH0@1VIWh0
000706IVOP39b]P0][S80;Vlb`2j_</0^[c<000000020>o_k`0C0=JL003F
S000gY@00=J4003_Y@00gX`00;eJ003FL`00ki`00?O_i`3gmoL0oooo0000
002i_<`0^[_<0;Vlb`2j_</0^Kc<0;Vlb`0D0;Vlc080^[c<00<0JgF?0=SH
i@3Cdn40403Cdn401P3Hf>D0JgF?0;Zlb`2j_</0JgF?0=SHi@80dm?Q00<0
oooo06i]S`1^KHl0201^KHl03P0U9CH0dm?Q0=?Ch@3Cdn40f=SU06]eS`2j
_</0^[c<0:HiA03PJFP0hFe/0>AaK@3TLFl0i71^0`3oool00`167QX0i71^
04HN6P030?ooo`80i71^00T0i75]0>5]K03PJFP0YSU40;Zlc02j^l`0^Kc;
0;Jhb039b]P00@1VIWh0000906IVOP37bML0];K70;Jhb02f^<T0][W90000
0024Q8@0inON0080kno_00L0aV/00?O6003_]@00ki`00=j<003>J`00ii`0
00<0moOg00D000000;Jib@2g^<T0][W90;Nib@020;JhbA@0]kS90P2f^<T0
101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0
e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U
9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>Ma
K`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_
0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG0@1VIWh00003
06IVOP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_knl02`3W[@00
mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool0000001`0];K7
00D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bf
a`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS
06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3oool00`167QX0
jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V
>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0];K700H00000
08b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_
imH0moOg0?ooo`00000L0;Bfa`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS
06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V
>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZK
S03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40
a/SG0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H000000>o_k`3_knl0
kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg00<0oooo0000
002a/lP06`2a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?8
0;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`
Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fd
V`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn
00000`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_0?Ogm`3_knl0
1P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L06P2_[/L00`1[MHl0d]7S
0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3B
dN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V
>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0`<7A0<O7e00_
0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR
0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<
XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0
n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03oWhd0YSU4096H
ZP<0[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;Bg`2e]<T_0:BS
_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24
S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:Hi
A02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1V
IWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34K`2XYkl01@2a/<@0_;c?
0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@
h03:b]X0K@2l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000
201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[J`3Gf>801`3Qh^/0
k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX00<0IVIn09FD
Z`3AdMh00P3lo?a]0?ooo`80o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0
F5MX0P1VIWh00`28Qid0UIB[0:RW_`1/0:RW_`0409FDZ`28Qid0IVIn06IV
OP<0F5MX000505QGJ740IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[21]:=",
  Evaluatable->False,
  ImageSize->{123, 106},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutExamples"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[21]=",
  CellTags->"LayoutExamples"]
}, Open  ]],

Cell[TextData[{
  "Each element of the tabbed ",
  StyleBox["WidgetGroup", "MR"],
  " can be a list of widgets to populate one tab panel or a single widget \
whose contents will be placed within one pane."
}], "Text",
  CellTags->"LayoutExamples"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ 
      GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
\[IndentingNewLine]WidgetGroup[{\[IndentingNewLine]Widget["\<Wolfram/Example/\
PrimeFinder\>"], \
\[IndentingNewLine]Widget["\<Wolfram/Example/CellularGroup\>"]\
\[IndentingNewLine]}, \ 
            Name -> "\<myTabPane\>", \[IndentingNewLine]WidgetLayout \[Rule] \
{"\<Grouping\>" \[Rule] {Tabs, \ 
                    Top, {"\<One\>", "\<Two\>"}}}]\[IndentingNewLine]]\
\[IndentingNewLine]]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"LayoutExamples"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject149088515391489, 
        JLink`Objects`JavaObject152758296510465]]], "Output",
  CellLabel->"Out[22]=",
  CellTags->"LayoutExamples"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->"LayoutExamples"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004;0000kB000`400?l0
0000o`00003oo`1VIWh<06IVOP0000<0IVIn0?_lo@3ko?d0o`3ko?d80?_l
o@40IVIn00000`1VIWh0nocm0:RY^`3o0:RY^`L0Z:Vk0@3ko?d106IVOP00
00<0IVIn0?_lo@2XZK/0o`1VIWh606IVOP40Z:Vk0@3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVIno`1aKf@4075_I00306IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0oooo0?l0WIfQ0P2MWJ40101aKf@0IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ
075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?oo
o`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`160>3Oh`03
0000003Pgn<0h=oS0;L0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`160>3Oh`030000003Pgn<0h=oS
0;L0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn0?ooo`3Pgn<0000000@0h=oS00<000000>3Oh`3Pgn<00P00
0000103Pgn<000000>3Oh`0000020>3Oh`070000003Pgn<0h=oS0000003P
gn<000000>3Oh`02000000<0h=oS0`0000020>3Oh`030000003Pgn<0h=oS
00@0h=oS00<000000>3Oh`3Pgn<00`0000050>3Oh`050000003Pgn<0h=oS
0>3Oh`0000000P3Pgn<300000080h=oS0P0000040>3Oh`040000003Pgn<0
000000000080h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<000000080
h=oS00@000000>3Oh`3Pgn<000000P3Pgn<3000000<0h=oS00<000000>3O
h`3Pgn<0W03Pgn<01@2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1V
IWh0nocm0:RY^`1VIWh0oooo0>3Oh`0000000`3Pgn<2000000040>3Oh`00
0000h=oS0>3Oh`80000000D0h=oS0000003Pgn<0h=oS000000020>3Oh`04
0000003Pgn<0000000000080h=oS00<000000>3Oh`0000000`3Pgn<00`00
0000h=oS000000060>3Oh`030000003Pgn<0000000<0h=oS00<000000>3O
h`3Pgn<00P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3P
gn<00`000000h=oS000000050>3Oh`8000000P3Pgn<00`000000h=oS0000
00030>3Oh`030000003Pgn<000000080h=oS00H000000>3Oh`3Pgn<00000
0>3Oh`0000030>3Oh`030000003Pgn<0h=oS09l0h=oS00D0WIfQ075_I01V
IWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0
00000080h=oS00D000000>3Oh`000000h=oS000000030>3Oh`030000003P
gn<000000080h=oS00H000000>3Oh`3Pgn<000000>3Oh`0000030>3Oh`03
0000003Pgn<0000000D0h=oS00<000000>3Oh`3Pgn<0103Pgn<00`000000
h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS00<0h=oS00L000000>3Oh`3P
gn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000001@3Pgn<0
1`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS
000000020>3Oh`060000003Pgn<0h=oS0000003Pgn<00000Y@3Pgn<01@2M
WJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0
oooo0>3Oh`0000000P3Pgn<01@000000h=oS0000003Pgn<0000000<0h=oS
00<000000>3Oh`0000000P3Pgn<01P000000h=oS0>3Oh`000000h=oS0000
00<0h=oS00<000000>3Oh`000000100000000`3Pgn<000000>3Oh`050>3O
h`030000003Pgn<0h=oS008000001P3Pgn<01`000000h=oS0>3Oh`3Pgn<0
00000>3Oh`0000000`3Pgn<00`000000h=oS000000050>3Oh`070000003P
gn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<000000080
h=oS00D000000>3Oh`3Pgn<000000>3Oh`0500000:40h=oS00D0WIfQ075_
I01VIWh0Z:Vk0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn0?ooo`3P
gn<000000>3Oh`0000000P3Pgn<00`000000h=oS000000030>3Oh`050000
003Pgn<000000000003Pgn<00P0000000`3Pgn<000000>3Oh`0200000080
h=oS00<000000>3Oh`0000000`3Pgn<010000000h=oS0000000000050>3O
h`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<00P3Pgn<20000
0080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000050>3O
h`8000000P3Pgn<010000000h=oS0000000000020>3Oh`050000003Pgn<0
00000000003Pgn<00P000000103Pgn<000000>3Oh`0000030>3Oh`030000
003Pgn<0h=oS09l0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP00
00T0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<000000>3Oh`0000000P3Pgn<0
0`000000h=oS000000030>3Oh`050000003Pgn<000000>3Oh`0000000P3P
gn<01@000000h=oS0>3Oh`000000h=oS008000000`3Pgn<300000080h=oS
00<000000>3Oh`000000103Pgn<00`000000h=oS0>3Oh`03000000D0h=oS
00@000000>3Oh`00000000000`3Pgn<3000000040>3Oh`00000000000000
00@0h=oS00@000000>3Oh`00000000000P3Pgn<02@000000h=oS0000003P
gn<000000>3Oh`000000h=oS000000020>3Oh`040000003Pgn<0h=oS0>3O
h`<00000XP3Pgn<01@2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001P1V
IWh0nocm0:RY^`1VIWh0oooo0>3Oh`8000000`3Pgn<00`000000h=oS0>3O
h`0=0>3Oh`030000003Pgn<0h=oS02L0h=oS00<000000>3Oh`3Pgn<0_@3P
gn<01@2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY
^`1VIWh0oooo0>3Oh`000000103Pgn<00`000000h=oS0>3Oh`0=0>3Oh`03
0000003Pgn<0h=oS0100h=oS00<000000>3Oh`3Pgn<0503Pgn<00`000000
h=oS0>3Oh`0=0>3Oh`030000003Pgn<0h=oS0:d0h=oS00D0WIfQ075_I01V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3O
h`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0
WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`3o0>3O
h`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn0?ooo`3o0>3Oh`40h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_l
o@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn?n0:F//P060>3O
h`2MWJ40LFmT06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3oool0h=oS0:F//P3l0?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk
0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb0?`0
oooo00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1V
IWh0nocm0:RY^`1VIWh0oooo0>3Oh`2U[;80o03oool01`2U[;80h=oS09fM
X@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3o
ool0h=oS0:F//P3l0?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_l
o@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb0?`0oooo
00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0oooo0>3Oh`2U[;80l`3oool00`000000oooo0?ooo`06
0?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000L0
IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb0?<0oooo00<000000?ooo`3o
ool01P3oool01`2U[;80h=oS09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0:F//P3c0?ooo`030000003o
ool0oooo00H0oooo00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`2U[;80l`3oool00`00
0000oooo0?ooo`060?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_l
o@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb0?<0oooo
00<000000?ooo`3oool01P3oool01`2U[;80h=oS09fMX@1aKf@0IVIn0:RY
^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3oool0h=oS0:F//P3a
0?ooo`030000003oool0000000P0oooo00L0YJbb0>3Oh`2MWJ40LFmT06IV
OP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`2U
[;80lP3oool2000000P0oooo00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0
nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`2U[;80l`3o
ool00`000000oooo0?ooo`060?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb
0?`0oooo00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0oooo0>3Oh`2U[;80o03oool01`2U[;80h=oS
09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3oool0h=oS0:F//P3l0?ooo`070:F//P3Pgn<0WIfQ075_I01VIWh0Z:Vk
0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?ooo`3Pgn<0YJbb0?`0
oooo00L0YJbb0>3Oh`2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001`1V
IWh0nocm0:RY^`1VIWh0oooo0>3Oh`2U[;80o03oool01`2U[;80h=oS09fM
X@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3o
ool0h=oSoP2U[;801P3Pgn<0WIfQ075_I01VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0oooo0?l0h=oS0@3Pgn<01@2MWJ40LFmT06IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0oooo0?l0h=oS
0@3Pgn<01@2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh0oooo0?l0h=oS0@3Pgn<01@2MWJ40LFmT06IVOP2XZK/0nocm
0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0oooo03X0h=oS00D0hN3T0>KU
j03/jnh0l?3b0?;bm00Q0??cm1h0n?Oh0P3clo@01@3cloD0m?Ce0?GemP3d
loD0iNCX00H0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;bm00G0??cm1@0n?Oh
0P3clo@01@3cloD0m?Ce0?GemP3dloD0iNCX03h0h=oS00D0WIfQ075_I01V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3O
h`040=kLg`3Th^00NiN]02EGQD<003ad00@05den06^;YP3blNh0l_7c1P3P
gn<0103Ng=l0i>;P07^G[@0UEhD_000lM00401M=OP1[RjH0l_7^0?;alch0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`0j0>3Oh`040=[Hf@1VQJ40BW6C0;:m`d<0a/GG00@0`<K5
04Q^T01ZRZ@0knoa1P3Pgn<0103Jf=T0IXFQ04YaT`2b_L<_0<K5e`040<36
a@18KY00JXZT0>o_lCh0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3Oh`030=SEeP0GCGh0_lO:
04D0a/GG00<0][fm01M=OP3[j^d01P3Pgn<00`3HeMH05den0;o7bP0a0<K5
e`030;Jm_@0GCGh0jn[]03h0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3Oh`030=WEe@00?7@0
oooo04D0cLcO00<0oooo000lM03XinX01P3Pgn<00`3IeMD003ad0?ooo`0a
0<g<g`030?ooo`00?7@0j>OZ03h0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3Oh`030=WEe@00
?7@0oooo04D0d]7T00<0oooo000lM03Wi^T01P3Pgn<00`3IeMD003ad0?oo
o`0a0=;Ai0030?ooo`00?7@0inKY03h0h=oS00D0WIfQ075_I01VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3Oh`030=WE
e@00?7@0oooo04D0e]OW00<0oooo000lM03Wi^T01P3Pgn<00`3IeMD003ad
0?ooo`0a0=KGi`030?ooo`00?7@0inKY03h0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3Oh`03
0=WEe@00?7@0oooo00d0fM[W00<000000=WJi`3If^L00`3If^L00`000000
fM[W0=WJi`020=WJi`<00000103If^L01@000000fM[W0=WJi`3If^L00000
0080fM[W0`0000030=WJi`80000000@0fM[W0000003If^L0fM[W0`00000@
0=WJi`030?ooo`00?7@0inKY00H0h=oS00<0fMGE000lM03oool03@3If^L0
0`000000fM[W0=WJi`020=WJi`030000003If^L0fM[W00<000000P3If^L0
1P000000fM[W0=WJi`3If^L000000=WJi`8000003`3If^L00`3oool003ad
0>OVj@0n0>3Oh`0509fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP3oool0>P3Pgn<00`3IeMD003ad0?ooo`0=0=WJi`03
0000003If^L0fM[W00<0fM[W00D000000=WJi`3If^L0fM[W000000030=WJ
i`050000003If^L0fM[W0=WJi`0000000`3If^L00`000000fM[W00000003
0=WJi`030000003If^L000000080fM[W0P0000000`3If^L000000=WJi`02
0=WJi`030000003If^L0fM[W00d0fM[W00<0oooo000lM03Wi^T01P3Pgn<0
0`3IeMD003ad0?ooo`0=0=WJi`040000003If^L0fM[W0=WJi`80000000<0
fM[W0000003If^L00P3If^L01P000000fM[W0=WJi`000000fM[W00000080
fM[W00<000000=WJi`3If^L03P3If^L00`3oool003ad0>OVj@0n0>3Oh`05
09fMX@1aKf@0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP3oool0>P3Pgn<00`3IeMD003ad0?ooo`0=0=kOk0030000003Ngn`0g]o/
00<0g]o/00D000000=kOk03Ngn`0g]o/000000060=kOk0030000003Ngn`0
00000080g]o/00<000000=kOk00000000`3Ngn`00`000000g]o/00000003
0=kOk0030000003Ngn`0g]o/0080g]o/00<000000=kOk03Ngn`03P3Ngn`0
0`3oool003ad0>OVj@060>3Oh`030=WEe@00?7@0oooo00d0g]o/00P00000
0=kOk03Ngn`000000=kOk0000000g]o/000000L0g]o/00D000000=kOk03N
gn`0g]o/0000000@0=kOk0030?ooo`00?7@0inKY03h0h=oS00D0WIfQ075_
I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j
0>3Oh`030=WEe@00?7@0oooo00d0hnG`100000020>?Ul0040000003SiO00
hnG`0>?Ul0D000000P3SiO000`000000hnG`000000020>?Ul0030000003S
iO00000000<0hnG`00<000000>?Ul00000000`3SiO000`000000hnG`0>?U
l00200000140hnG`00<0oooo000lM03Wi^T01P3Pgn<00`3IeMD003ad0?oo
o`0=0>?Ul0070000003SiO00hnG`0000003SiO0000000>?Ul005000000<0
hnG`00D000000>?Ul03SiO00hnG`0000000@0>?Ul0030?ooo`00?7@0inKY
03h0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn0?ooo`0j0>3Oh`030=WEe@00?7@0oooo00d0jN_e00H00000
0>W[m@3YjoD0jN_e0000003YjoD200000080jN_e00L000000>W[m@3YjoD0
jN_e0000003YjoD0000000<0jN_e00D000000>W[m@000000jN_e00000003
0>W[m@030000003YjoD0000000<0jN_e00<000000>W[m@0000000`3YjoD0
0`000000jN_e0>W[m@0=0>W[m@030?ooo`00?7@0inKY00H0h=oS00<0fMGE
000lM03oool03@3YjoD00`000000jN_e000000020>W[m@030000003YjoD0
000000<0jN_e00H000000>W[m@3YjoD000000>W[m@0000020>W[m@030000
003YjoD0jN_e00h0jN_e00<0oooo000lM03Wi^T0?P3Pgn<01@2MWJ40LFmT
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0oooo03X0
h=oS00<0fMGE000lM03oool03@3`lO`02@000000l?7l0?3ao03`lO`00000
0?3ao0000000l?7l000000020?3ao0<000000P3`lO`01`000000l?7l0?3a
o03`lO`000000?3ao00000000P3`lO`300000080l?7l00D000000?3ao03`
lO`0l?7l000000020?3ao0<00000403`lO`00`3oool003ad0>OVj@060>3O
h`030=WEe@00?7@0oooo00d0l?7l00<000000?3ao00000000P3`lO`00`00
0000l?7l0?3ao00300000080l?7l00@000000?3ao03`lO`0l?7l1000000?
0?3ao0030?ooo`00?7@0inKY03h0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3Oh`030=WEe@00
?7@0oooo00d0m?Gm00D000000?Ceo@3dmOd0m?Gm0000000c0?Ceo@030?oo
o`00?7@0inKY00H0h=oS00<0fMGE000lM03oool03@3dmOd2000000<0m?Gm
00<000000?Ceo@3dmOd02`3dmOd00`000000m?Gm0?Ceo@0>0?Ceo@030?oo
o`00?7@0inKY03h0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3Oh`030=WEe@00?7@0oooo00d0
m_Om1000000B0?Kgo@030000003fmod0m_Om01l0m_Om00<0oooo000lM03W
i^T01P3Pgn<00`3IeMD003ad0?ooo`0=0?Kgo@030000003fmod0m_Om0080
m_Om00<000000?Kgo@3fmod02`3fmod00`000000m_Om0?Kgo@0>0?Kgo@03
0?ooo`00?7@0inKY03h0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3Oh`030=WEe@00?7@0oooo
04D0n?cm00<0oooo000lM03Wi^T01P3Pgn<00`3IeMD003ad0?ooo`0a0?Sl
o@030?ooo`00?7@0inKY03h0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3Oh`030=WEe@00?7@0
oooo04D0oOgm00<0oooo000lM03Wi^T01P3Pgn<00`3IeMD003ad0?ooo`0a
0?gmo@030?ooo`00?7@0inKY03h0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3Oh`030=WEe@00
?7@0oooo04D0oOgm00<0oooo000lM03Vi^T01P3Pgn<00`3IeMD003ad0?oo
o`0a0?gmo@030?ooo`00?7@0i^KY03h0h=oS00D0WIfQ075_I01VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3Oh`030=SD
e000?7@0oooo04D0oOgm00<0oooo000lM03UiNP01P3Pgn<00`3He=@003ad
0?ooo`0a0?gmo@030?ooo`00?7@0iNGX03h0h=oS00D0WIfQ075_I01VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3Oh`03
0=WEe@0UEhD0_lkL04D0oooo00<0_lkK02EGQ@3QhN@01P3Pgn<00`3IeMD0
9EN50;o>g00a0?ooo`030;o>f`0UEhD0hN7T03h0h=oS00D0WIfQ075_I01V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3O
h`040=WEe@1iU:T0EGfR0<3?gD<0oooo00@0eMoX05EmXP1iUJ/0gmgP1P3P
gn<0103IeMD0NIBY05EmXP30cmd_0?ooo`040=GOj01EOJ80NIF[0=oMh3h0
h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0?ooo`0j0>3Oh`040=[Gf@3Og=P0NIBY02EGQD<003ad00@05den
06J6X@3Pg]X0g=_M1P3Pgn<0103JemT0gmcH07VDZ@0UEhD_000lM00401M=
OP1VQZ40h=kJ0=cKgCh0h=oS00D0WIfQ075_I01VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn0?ooo`0j0>3Oh`030=oMh03JemT0f=CD
02<0em?D7P3Cc/`30=OCe0040=SDe03IeMD0f]OI0=oMh0H0h=oS00<0gmgP
0=[Gf@3He=@06@3Gdm@D0=?>c0<0em?D00@0f=CD0=WEe@3JemT0gmgP?P3P
gn<01@2MWJ40LFmT06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0oooo0?l0h=oS0@3Pgn<01@2MWJ40LFmT06IVOP2XZK/0nocm0040
IVIn00001@1VIWh0nocm0:RY^`1VIWh0oooo0240h=oSh03oool0101aKf@0
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn096KW0020?cl
oP0J0000003lo?h000000?cloP000000o?cn0000003lo?h000000?cloP00
0000o?cn0000003lo?h000000?cloP000000o?cn0000003lo?h000000?cl
oP000000o?cn0000003lo?h200000080o?cn00<0TI^L0;jnf02n_]P00P2n
_mPJ0;jnf003096W]03Pgn<0h=oS0<00h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP2AVi`0803lo?h00`2AVi`0a/SM0<K8
g@0L0<K8g@03096W]03Pgn<0h=oS0<00h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP2AVi`00P3lo?h00`000000o?cn0?cl
oP0H0?cloP040000003lo?h0o?cn096KW1h0c<gR00<0TJNd0>3Oh`3Pgn<0
`03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
096KW00P0?cloP03096KW03EenT0eMOY00D0eMOY00<000000=GGj@3EenT0
0`3EenT01@000000eMOY0=GGj@3EenT0000000@0eMOY0`0000050=GGj@03
096W]03Pgn<0h=oS0<00h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP2AVi`00P3lo?h00`000000o?cn0?cloP0H0?cloP04
0000003lo?h0o?cn096KW0L0fmg]00<000000=_Mk@3KgNd00`3KgNd01P00
0000fmg]0=_Mk@3Kg>d000000=_Lk@80fmg]00D000000=_Mk@3KgNd0fmg]
000000030=_Mk@030=_Lk@2AYk@0h=oS0<40h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2AVi`0203lo?h3000000<0o?cn
00D000000?cloP3lo?h0o?cn000000020?cloP<00000203lo?h00`2AVi`0
gmoa0=oOl@050=oOl@030000003Ogo40gmoa0080gmoa00L000000=oOl@00
0000gmoa0000003Ogo4000000080gmoa00D000000=oOl@3Ogo40gmoa0000
00040=oOl@03096W]03Pgn<0h=oS0<00h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP2AVi`00P3lo?h00`000000o?cn0?cl
oP020?cloP050000003lo?h0o?cn0?cloP0000000P3lo?h01`000000o?cn
0?cloP3lo?h000000?cloP0000000`3lo?h00`000000o?cn0?cloP020?cl
oP040000003lo?h0o?cn096KW0L0iNKd00<000000>GVm03Ui_@00P3Ui_@0
1`000000iNKd0000003Ui_@000000>GVm00000000P3Ui_@01@000000iNKd
0>GVm03Ui_@0000000@0iNKd00<0TJNd0>3Oh`3Pgn<0`03Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn096KW0060?cloP03
0000003lo?h0o?cn00<0o?cn00<000000?cloP0000000`3lo?h00`000000
o?cn0000000;0?cloP03096KW03Zj_P0j^[h00D0j^[h00D000000>[Zn03Z
j_P0j^[h000000020>[Zn0030000003Zj_P000000080j^[h00<000000>[Z
n00000000`3Zj_P00`000000j^[h0>[Zn0020>[Zn003096W]03Pgn<0h=oS
0<00h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP2AVi`00P3lo?h01@000000o?cn0?cloP3lo?h0000000D0o?cn00<00000
0?cloP0000000`3lo?h00`000000o?cn00000004000000@0o?cn00@00000
0?cloP3lo?h0TI^L1`3Zj_T01@000000j^[i0>[Zn@3Zj_T0000000<0j^[i
00D000000>[Zn@3Zj_T0j^[i000000020>[Zn@<000001@3Zj_T00`2AYk@0
h=oS0>3Oh`300>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh0TI^L00H0o?cn00<000000?cloP3lo?h00`3lo?h010000000
o?cn0000000000020?cloP030000003lo?h0000000<0o?cn00<000000?cl
oP3lo?h01@3lo?h00`2AVi`0lO7m0?7ao@050?7ao@030000003alOd0lO7m
01@0lO7m00<0TJNd0>3Oh`3Pgn<0`03Pgn<00`1VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn096KW0020?cloP050000003lo?h0o?cn
0?cloP0000001@3lo?h010000000o?cn0000003lo?h2000000<0o?cn0`00
00050?cloP060000003lo?h0o?cn096KW03em?d0m_Cm0`3em?d5000001@0
mOCm00<0TJNd0>3Oh`3Pgn<0`03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn096KW0070?cloP050000003lo?h0o?cn0?cl
oP000000503lo?h00`2AVi`0n_Wn0?[ioP0L0?[ioP03096W]03Pgn<0h=oS
0<00h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP2AVi`00P3lo?h00`000000o?cn0?cloP030?cloP<000004P3lo?h01000
0000o?cn0?cloP2AVi`N0?ooo`03096W]03Pgn<0h=oS0<00h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2AVi`0803lo?h0
0`2AVi`0oooo0?ooo`0L0?ooo`03096W]03Pgn<0h=oS0<00h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2AVi`00P3lo?h0
0`000000o?cn0?cloP0H0?cloP050000003lo?h0o?cn096KW03moO`0703o
ool00`3fm?80TJNd0>3Oh`310>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0TI^L0200o?cn00<0TI^L0>?Yk03no_h06P3o
ool00`3no_d0hnW[0:Vi_`320>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0TI^L0080o?cn01X000000?cloP000000o?cn
0000003lo?h000000?cloP000000o?cn0000003lo?h000000?cloP000000
o?cn0000003lo?h000000?cloP000000o?cn0000003lo?h000000?cloP80
00000P3lo?h00`2AVi`0]/C=0>CYk00J0?ooo`030>gal`2fa<d0d=K@0<80
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3M
XE<0nKPh7P3oac`0103i^3P0gJ5C0=3Fd02Y^KlJ096W]0030:6c^`38dLd0
h=oS0<80h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP3QaXh0kYla0?Vi>00L0?o8?0030?^n>@3^Wc40hLJ>0>40h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3Pgn<0hLJ>
0>^G;P0L0>J;;0030>BG?03M`Xd0h=oS0>40h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS103Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000<0IVIn0?Ogn@2HV:L0o`1gMi8607MgTP40V9RW0@3g
moT106IVOP0000<0IVIn0?Ogn@2l_Ld0o`2l_Ld70;bmc@40moOi0@1VIWh0
000306IVOP3gmoT0i>?S0?l0i>?S1`3Thn<10?Ogn@40IVIn00000`1VIWh0
l?7d0?ooo`2o0?ooo`030>CSh`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/
MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0
K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT
^@@0YSU400@0YcY40:HiA02W>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`03
0?ooo`40l?7d0@1VIWh0000F06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_k
o@3ko?d0nocl0?clo@3lo?`0o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm
0?cko03lo?d0no_m0?_lo080o?cl00@0o?cm0?clo03knod0o?cmA03lnoa4
0?_lo1h0nocm00<0W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3k
o?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:Xl
E@070:HiA02LY;T0nocl0?clo03lnod0nocm0>;QhP0106IVOP0000@0IVIn
0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03g
moT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3f
moT00`3fmoP0moOi0?Ogn@130?OgnD@0m_Oi7P3gmoT00`1[MHl0QHV`09bN
_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00
JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:Xl
E@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3a
lO@0lO7d0?3am03`l_@@000000060?7am03`l_D0lO7d0?7bm03`l_@0lO7d
R03`lODN0?3am00306]eS`2b]M00YjS20100YjS200H0/[G@06]eS`3`lO@0
l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e0?7bm02V>D@00P32DU/0
0`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0`U9K0:HiA080l?7d00<0
lO7d0?3bm03NgN400@1VIWh0000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__
000000020>OWi`80g]kN0P3WinL00`3W_H@0inOW0>OWi`030>OWi`80kno_
00@000000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`0>[[l0120>[[l4@0
j^c`7P3Zjnl0101[MHl0][WA0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk6
00<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<
0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=
EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080
j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000
S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<00>OWi`3WinL00P3WinL01`3_
knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?U
j`120>?Ujd@0hnCZ7P3SiNX01@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?
00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bn
e080/[;:00<0oooo02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[
0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0
e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0
000306IVOP3Gf=h0g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OFcP02
0>OWi`050<ik003_U100inOW0>ONaP3_S1000`3_knl01`000000g=kV0=cN
i@3Lg^D0g=kV0=cNi@3Lg^H0YP3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo
00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0
JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;Ri
cP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP
00<0oooo1@3FGf<30?ooo`0505<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D0
0`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>00
2@000000S8b<0>OWi`3WinL0ikF40=IJ003FQ000olh00<iS00020=i[0005
0>neS03_knl0kno_0>o_k`0000000P3Ef>40103Een00e]SP0=KHh@3Fen54
0=KGh4@0e]SP7P3Ef>401@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l
_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l
_M401`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GG
h@2V>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`16
7QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1V
IWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ON
cP36BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh00000
0`3@d]`00`3?d]`0d=;L0<oBg0140=3Bg4@0cm;M7P3@d]`00`1[MHl0b<WK
0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3o
ool09BDf0<?4eP070<?4eP030?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]e
S`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo
0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d2
0=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:
cMP000000>O6[@3WaX`0mlhH0>nm003gaP00kjd00>N]003WY@00eX`00<i[
003WaP00omH00>o_i`3_knl000000<_=f03;cMT0b/gI0<_>f03:cMP0blgH
A03;cMU40<_>fAh0blgH00<0JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I
0<S:f@030<S:f@040<S9f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38
b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I
0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD0
0P3NIfL00`167QX0oooo0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3P
IfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn
0<o?fP35b=@00`35b=@01P000000a/K60>ONeP3>N`00ijd00>ne0080ijD0
00<0eY@00<ic003FU0000P3gaP020?Ogm`0400000035b=@0aLOD0<G7e0<0
aLOEA034amE40<C8e1h0a<OD00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00
JgF?0<C7e034am@0JgF?0=3Ah080bl_L00<0oooo02DU=P3;bm`01`3;bm`0
0`3oool09BDf0<_;g0020<_;g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT
0=mUI0050>1ZJ00504HN6P3oool0oooo0?ooo`167QX01@3PJVP0103OIF@0
ffAT0:HiA034b=D20<C8e040aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32
a=80`LCA0P31a=801P000000inOW0>OWi`3WinL0eX@00>ne0080ijD000P0
eX@00<i[003W[@00mkD00?Nm003_knl0moOg000000<0`LCB00<0`/CA0<74
dP31a=80A031a=540<74dQh0`/CB00<0JgF?0=?ChP3?d=d0403?d=d01P3C
dn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?
d=d00`3oool09BDf0<o@g@020<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0
ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA
0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:c=P0_/3?0;g0c`80_/3>00D0
000009bLW03WinL0imkF0=J<00020=jD00040=Ik0036H`00_D800>nU0080
mjd000P0mkD00?o>BP000000_/3>0;k0c`2n`<h0_/3?0;g0cTD0_/3>A02m
`<hN0;k0cP0306]eS`3Fe^@0dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>
06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo00P0oooo00/09BDf0=?Ch03C
dn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo
00@0AQhJ0?ooo`3oool0oooo103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0
c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`0
00000080kno_01<0eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic003_
W000mnoW0?Ogm`3oool000000;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;04@0
^Kc<A02j_<`N0;Zlb`0306]eS`3Hf>D0dm?Q0100dm?Q00H0f=SU06]eS`2j
_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?00P0KVf?00h09BDf
0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0
i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3oool20>A`KP090>AaK@3Q
KF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H0040IVIn00002@1VIWh0
alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OWgP020>o_k`070<I[003g
aP00kkD00>nL003NS000cV/00>NL00030?Ogm`050000002f^LT0]kS90;Ji
b@2g^LT00P2f^<U40;NhbD@0][S97P2g^<T0101[MHl0e]KT0=SHi@3Hf>H3
0=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0e]KT06]eS`2g^<T0]kS906]e
S`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT
06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0
i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f
^LT0][S90;Jib@2d]/L0alWG0@1VIWh0000306IVOP36b=L0];K700<0];K7
00<000000>o_k`3_knl00P3_knl02`3W[@00mlH80>NU003WU000ih`00>oW
eP3NU3T0kmJe0?ogm`3oool000000:`0];K700D0JgF?0=GEh`3LfnL0g=_W
0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3M
fnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03W
Lfl0igEb0>YfL`3ZN7H00P3oool00`167QX0jGih0>UnN0030>UnN00804HN
6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0
000306IVOP36b=L0];K700<0];K700H0000008b<S03_knl0kno_0>O>N`3_
knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_imH0moOg0?ooo`00002/0;Bf
a`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3E
e><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV1
0080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0
lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40a/SG0@1VIWh0000306IVOP36
b=L0/K?800<0/K?800H000000>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`03
0?OWaP3gmoL0oooo00<0moOg00<0oooo0000002a/lP0Z`2a/lP00`1[MHl0
kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?40
6@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K
0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0
l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`03
0:n^a`050000002][Jd0moO_0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<0
00000:n^a`2_[/L0ZP2_[/L00`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[
MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU4
0?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll1
0<K8e`40IVIn00000`1VIWh0`<7A0<O7e02o0:b[a00408B<XP1[MHl0c<_M
0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;
g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03o
Whd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3i
jKH01P3jjkL0n]bg0?joY03oWhd0YSU4096HZP<0[:_40@37am@10<31d@40
IVIn0000101VIWh0`<7A0=;Bg`2e]<Vo0:BS_P0308B<XP1[MHl0JgF?00l0
JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80JgF?06]eS`0?06]eS`03
08B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80
Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1VIWh0000606IVOP2XYkl0i^K]
0=;Bh02l_<l0/K34o`2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn
00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@h03:b]X0o@2l_<l01P3:b]X0
d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80
o?cl0?;al`3/jnh0hN;[n`3Gf>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FD
Z`1VIWh00@1HEfP00080F5MX00<0IVIn09FDZ`3AdMh00P3lo?cm0?ooo`80
o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[
0:RW_`3l0:RW_`0409FDZ`28Qid0IVIn06IVOP<0F5MX000505QGJ?l0IVIn
0P1VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[23]:=",
  Evaluatable->False,
  ImageSize->{267, 237},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"LayoutExamples"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[23]=",
  CellTags->"LayoutExamples"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Split Pane Examples", "SubsectionIcon",
  CellTags->"LayoutExamples"],

Cell["\<\
Here is an example that uses a split pane and shows how we can optionally \
name the split pane so it can be manipulated using its properties at runtime.\
\
\>", "Text",
  CellTags->"LayoutExamples"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ 
      GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
\[IndentingNewLine]WidgetGroup[{\[IndentingNewLine]Widget["\<Button\>", \
{"\<text\>" -> "\<Button B\>"}], \
\[IndentingNewLine]WidgetGroup[{Widget["\<Button\>", {"\<text\>" -> "\<Button \
A\>"}], \ Widget["\<TextField\>", \ {"\<text\>" -> "\<some\>"}]}, 
                WidgetLayout \[Rule] Column]\[IndentingNewLine]}, \ 
            WidgetLayout \[Rule] {"\<Grouping\>" \[Rule] {Split, \ 
                    Vertical}}, \ 
            Name -> "\<mySplitPane\>"]\[IndentingNewLine]]\[IndentingNewLine]]\
\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->"LayoutExamples"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject322225391534081, 
        JLink`Objects`JavaObject260802292482049]]], "Output",
  CellLabel->"Out[24]=",
  CellTags->"LayoutExamples"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // \ Show\)], "Input",
  CellLabel->"In[25]:=",
  CellTags->"LayoutExamples"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000KR000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0lNoR
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0
L@2U[;80103akn80IVIn0:RY^`3ko?d106IVOP0000H0IVIn0?_lo@2XZK/0
IVIn075_I02U[;9_0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d00@1VIWh0
000606IVOP3ko?d0Z:Vk06IVOP1aKf@0YJbbK`3oool01@2U[;80lNoR06IV
OP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F//Vl0
oooo00D0YJbb0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2X
ZK/0IVIn075_I02U[;9_0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d00@1V
IWh0000606IVOP3ko?d0Z:Vk06IVOP1aKf@0YJbbK`3oool01@2U[;80lNoR
06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F/
/PH0oooo0`0000030?ooo`<000000P3oool010000000oooo0?ooo`000002
0?ooo`030000003oool0oooo00<00000DP3oool01@2U[;80lNoR06IVOP2X
ZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F//PD0oooo
00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?oo
o`0000000P3oool01P000000oooo0?ooo`000000oooo000000<0oooo00<0
00000?ooo`3oool0C`3oool01@2U[;80lNoR06IVOP2XZK/0nocm0040IVIn
00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F//PP0oooo00@000000?ooo`3o
ool000000`3oool00`000000oooo000000020?ooo`060000003oool0oooo
0000003oool00000E@3oool01@2U[;80lNoR06IVOP2XZK/0nocm0040IVIn
00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F//PH0oooo0P0000030?ooo`07
0000003oool0oooo0?ooo`000000oooo000000020?ooo`050000003oool0
oooo0000003oool01@00001A0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d0
0@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1aKf@0YJbb1@3oool01`000000
oooo0?ooo`3oool000000?ooo`0000000`3oool01@000000oooo00000000
0000oooo0080000000@0oooo0000003oool000000`3oool00`000000oooo
0?ooo`1?0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d00@1VIWh0000606IV
OP3ko?d0Z:Vk06IVOP1aKf@0YJbb1P3oool3000000<0oooo0`0000020?oo
o`030000003oool000000080oooo00@000000?ooo`3oool0oooo0`00001B
0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0
Z:Vk06IVOP1aKf@0YJbbK`3oool01@2U[;80lNoR06IVOP2XZK/0nocm0040
IVIn00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F//Vl0oooo00D0YJbb0?7_
hP1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn075_I02U
[;9_0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3k
o?d0Z:Vk06IVOP1aKf@0YJbbK`3oool01@2U[;80lNoR06IVOP2XZK/0nocm
0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0LFmT0:F//Vl0oooo00D0YJbb
0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn075_
I02U[;9_0?ooo`050:F//P3akn80IVIn0:RY^`3ko?d00@1VIWh0000606IV
OP3ko?d0Z:Vk06IVOP1aKf@0YJbbK`3oool01@2U[;80lNoR06IVOP2XZK/0
nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT0740YJbb00@0lNoR
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0L@3P
gn<0103akn80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
075_I01a0>3Oh`040?7_hP1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0LFmT0740h=oS00@0lNoR06IVOP2XZK/0nocm0@1VIWh0000:
06IVOP3ko?d0Z:Vk06IVOP1aKf@0hN3T0>KUj03/jnh0l?3b0?;bm3@0lo?d
<@3hmoP20??cm0090??cm@3dm?D0mOGf0?Ccm@3Ui>P0lNoR06IVOP2XZK/0
nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=kLg`3Th^00NiN]
02EGQ@1Y000lM00801M=OP1[RjH0l_7^0?;al`3akn80IVIn0:RY^`3ko?d1
06IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_I03Jf=T0IXFQ04YaT`2b_L<0
J@36aML02030a/D0B6j@06Z:Y03_ko40lNoR06IVOP2XZK/0nocm0@1VIWh0
000806IVOP3ko?d0Z:Vk06IVOP1aKf@0f=GF01M=OP2oalY[0<K5e`070;Jm
_@0GCGh0jn[]0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2X
ZK/0IVIn075_I03IeMD003ad0?ooof/0cLcO00L0oooo000lM03XinX0lNoR
06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0LFmT0=WE
e@00?7@0ooooJ`3BdN@01`3oool003ad0>OVj@3akn80IVIn0:RY^`3ko?d0
0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1aKf@0fMGE000lM03ooom[0=KG
i`070?ooo`00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn
0?_lo@2XZK/0IVIn075_I03IeMD003ad0?ooob00fM[W1@0000030=WJi`80
000000<0fM[W0000003If^L00P0000000`3If^L00000000000020=WJi`<0
00000P3If^L01@000000fM[W0=WJi`3If^L0000000@0fM[W00<000000=WJ
i`3If^L00`3If^L00`000000fM[W0=WJi`0P0=WJi`070?ooo`00?7@0inKY
0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn075_
I03IeMD003ad0?ooob00fM[W00<000000=WJi`3If^L00P3If^L00`000000
fM[W000000020=WJi`80000000D0fM[W0000003If^L0fM[W000000020=WJ
i`070000003If^L0fM[W0=WJi`000000fM[W000000030=WJi`030000003I
f^L0fM[W0080fM[W00<000000=WJi`3If^L00`3If^L00`000000fM[W0=WJ
i`0P0=WJi`070?ooo`00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP00
00P0IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad0?ooob00g]o/00<00000
0=kOk03Ngn`00P3Ngn`00`000000g]o/000000030=kOk0030000003Ngn`0
00000080g]o/00@000000=kOk03Ngn`000000`3Ngn`00`000000g]o/0000
00030=kOk0030000003Ngn`0g]o/00<0g]o/1@00000S0=kOk0070?ooo`00
?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0
IVIn075_I03IeMD003ad0?ooob00hnG`00<000000>?Ul03SiO000P3SiO00
0`000000hnG`000000030>?Ul0030000003SiO0000000080hnG`00@00000
0>?Ul03SiO0000000`3SiO000`000000hnG`000000030>?Ul0030000003S
iO00hnG`00<0hnG`00D000000>?Ul03SiO00hnG`0000000S0>?Ul0070?oo
o`00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2X
ZK/0IVIn075_I03IeMD003ad0?ooob00jN_e1@0000020>W[m@070000003Y
joD0jN_e0>W[m@000000jN_e000000020>W[m@040000003YjoD0jN_e0000
00<0jN_e00@000000>W[m@00000000000P3YjoD00`000000jN_e0>W[m@04
0>W[m@030000003YjoD0000002@0jN_e00L0oooo000lM03Wi^T0lNoR06IV
OP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0LFmT0=WEe@00
?7@0oooo803`lO`00`000000l?7l0?3ao0020?3ao0030000003`lO`00000
00<0l?7l1`0000020?3ao0<000000P3`lO`010000000l?7l000000000007
0?3ao0030000003`lO`0000002@0l?7l00L0oooo000lM03Wi^T0lNoR06IV
OP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0LFmT0=WEe@00
?7@0oooo803dmOd00`000000m?Gm0?Ceo@020?Ceo@030000003dmOd0m?Gm
00D0m?Gm00@000000?Ceo@3dmOd000004`3dmOd00`000000m?Gm0000000T
0?Ceo@070?ooo`00?7@0inKY0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0
IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad0?ooob00m_Om1@0000080?Kg
o@040000003fmod0m_Om000001@0m_Om00<000000?Kgo@3fmod08`3fmod0
1`3oool003ad0>OVj@3akn80IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3k
o?d0Z:Vk06IVOP1aKf@0fMGE000lM03ooom[0?Slo@070?ooo`00?7@0inKY
0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn075_
I03IeMD003ad0?ooof/0oOgm00L0oooo000lM03Wi^T0lNoR06IVOP2XZK/0
nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0LFmT0=WEe@00?7@0oooo
J`3moOd01`3oool003ad0>KVj@3akn80IVIn0:RY^`3ko?d00@1VIWh00008
06IVOP3ko?d0Z:Vk06IVOP1aKf@0f=CD000lM03ooom[0?gmo@070?ooo`00
?7@0iNGX0?7_hP1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0
IVIn075_I03IeMD09EN50;o>g6/0oooo00L0_lkK02EGQ@3QhN@0lNoR06IV
OP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=WEe@1i
U:T0EGfR0<3?g@1Y0?ooo`080=GOj01EOJ80NIF[0=oMh03akn80IVIn0:RY
^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_I03JemT0gmcH07VD
Z@0UEhD0J@00?7@0200GCGh0IXJQ0>3NfP3Lfmd0lNoR06IVOP2XZK/0nocm
0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1aKf@0gmgP0=[Gf@3He=@f0=OC
e340dlk<0`3Gdm@0203He=@0fMGE0=[Gf@3OgN00lNoR06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0LFmT00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0lNoR00<0IVIn0:RY^`3ko?d0
0@1VIWh0000:06IVOP3ko?d0Z:Vk06IVOP1aKf@0hN3T0>KUj03/jnh0l?3b
0?;bm3@0lo?d<@3hmoP20??cm0090??cm@3dm?D0mOGf0?Ccm@3Ui>P0lNoR
06IVOP2XZK/0nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=kL
g`3Th^00NiN]02EGQ@1Y000lM00801M=OP1[RjH0l_7^0?;al`3akn80IVIn
0:RY^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_I03Jf=T0IXFQ
02M=Q@1=OL40JP1YP^h01`0WCHD0JXZT0>o_l@3akn80IVIn0:RY^`3ko?d0
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1aKf@0f=GF01M=OP1]08V]i006
01M=OP3[j^d0lNoR06IVOP2XZK/0nocm0@1VIWh0000906IVOP3ko?d0Z:Vk
06IVOP1aKf@0fMGE000lM029[N@0oooo06T0cLcO00P0oooo08V]i000?7@0
j>OZ0?7_hP1VIWh0Z:Vk0?_lo@40IVIn00002@1VIWh0nocm0:RY^`1VIWh0
LFmT0=WEe@00?7@0RjgT0?ooo`1Y0=;Ai0080?ooo`2;[nD003ad0>OVj@3a
kn80IVIn0:RY^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_I03I
eMD003ad08j_iP3oool0J@3FenL0203oool0SJoU000lM03Wi^T0lNoR06IV
OP2XZK/0nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP1aKf@0fMGE000l
M02A/NL0oooo0200fM[W1@0000030=WJi`80000000<0fM[W0000003If^L0
0P0000000`3If^L00000000000020=WJi`<000000P3If^L01@000000fM[W
0=WJi`3If^L0000000@0fM[W1@00000R0=WJi`080?ooo`2A/NH003ad0>OV
j@3akn80IVIn0:RY^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_
I03IeMD003ad09Bdj03oool0803If^L00`000000fM[W0=WJi`020=WJi`03
0000003If^L000000080fM[W0P0000001@3If^L000000=WJi`3If^L00000
0080fM[W00L000000=WJi`3If^L0fM[W0000003If^L0000000<0fM[W00<0
00000=WJi`3If^L00P3If^L00`000000fM[W0=WJi`020=WJi`030000003I
f^L0fM[W01l0fM[W00P0oooo09Fdj000?7@0inKY0?7_hP1VIWh0Z:Vk0?_l
o@40IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=WEe@00?7@0V;SZ0?oo
o`0P0=kOk0030000003Ngn`0g]o/0080g]o/00<000000=kOk00000000`3N
gn`00`000000g]o/000000020=kOk0040000003Ngn`0g]o/000000<0g]o/
00<000000=kOk00000000`3Ngn`00`000000g]o/0=kOk0020=kOk0030000
003Ngn`0g]o/0080g]o/00<000000=kOk03Ngn`07`3Ngn`0203oool0V;SY
000lM03Wi^T0lNoR06IVOP2XZK/0nocm0@1VIWh0000906IVOP3ko?d0Z:Vk
06IVOP1aKf@0fMGE000lM02L^nX0oooo0200hnG`00<000000>?Ul03SiO00
0P3SiO000`000000hnG`000000030>?Ul0030000003SiO0000000080hnG`
00@000000>?Ul03SiO0000000`3SiO000`000000hnG`000000030>?Ul003
0000003SiO00hnG`0080hnG`00<000000>?Ul03SiO000P3SiO000`000000
hnG`0>?Ul00O0>?Ul0080?ooo`2L^n/003ad0>OVj@3akn80IVIn0:RY^`3k
o?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad0:2nk03o
ool0803YjoD500000080jN_e00L000000>W[m@3YjoD0jN_e0000003YjoD0
00000080jN_e00@000000>W[m@3YjoD000000`3YjoD010000000jN_e0000
000000020>W[m@030000003YjoD0jN_e0080jN_e1@00000R0>W[m@080?oo
o`2Q_^`003ad0>OVj@3akn80IVIn0:RY^`3ko?d106IVOP0000T0IVIn0?_l
o@2XZK/0IVIn075_I03IeMD003ad0:G1k@3oool0803`lO`00`000000l?7l
0?3ao0020?3ao0030000003`lO`0000000<0l?7l1`0000020?3ao0<00000
0P3`lO`010000000l?7l0000000000050?3ao0030000003`lO`0l?7l0080
l?7l00<000000?3ao03`lO`07`3`lO`0203oool0YL;^000lM03Wi^T0lNoR
06IVOP2XZK/0nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP1aKf@0fMGE
000lM02YaNl0oooo0200m?Gm00<000000?Ceo@3dmOd00P3dmOd00`000000
m?Gm0?Ceo@050?Ceo@040000003dmOd0m?Gm00000140m?Gm00<000000?Ce
o@3dmOd00P3dmOd00`000000m?Gm0?Ceo@0O0?Ceo@080?ooo`2YaNl003ad
0>OVj@3akn80IVIn0:RY^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn
075_I03IeMD003ad0:g8l03oool0803fmod5000000P0m_Om00@000000?Kg
o@3fmod000004@3fmod500000280m_Om00P0oooo0:c7l000?7@0inKY0?7_
hP1VIWh0Z:Vk0?_lo@40IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=WE
e@00?7@0/L_b0?ooo`1Y0?Slo@080?ooo`2ac?8003ad0>OVj@3akn80IVIn
0:RY^`3ko?d106IVOP0000T0IVIn0?_lo@2XZK/0IVIn075_I03IeMD003ad
0;C=l`3oool0J@3moOd0203oool0]Lkc000lM03Wi^T0lNoR06IVOP2XZK/0
nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP1aKf@0fMGE000lM02gd?@0
oooo06T0oOgm00P0oooo0;S@m@00?7@0i^KY0?7_hP1VIWh0Z:Vk0?_lo@40
IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=SDe000?7@0^]?e0?ooo`1Y
0?gmo@080?ooo`2jdoH003ad0>GUj03akn80IVIn0:RY^`3ko?d106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn075_I03IeMD09EN506d0_=Cf00H09EN50>7Q
i03akn80IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn075_
I03IeMD0NIBY02M=QF/0c^Oo00L09df507VEZ`3OgN00lNoR06IVOP2XZK/0
nocm0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0LFmT0=[Gf@3Og=P0NIBY
02EGQ@1Y000lM00801M=OP1VQZ40h=kJ0=cKg@3akn80IVIn0:RY^`3ko?d1
06IVOP0000P0IVIn0?_lo@2XZK/0IVIn075_I03OgN00f]OI0=SDe3H0em?D
<@3Cc/`30=OCe0080=SDe03IeMD0f]OI0=oMh03akn80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVInLP1aKf@0103akn80IVIn0:RY^`3k
o?d106IVOP0000<0IVIn0?Ogn@2HV:L0M@1gMi8109RHY`40moOi0@1VIWh0
000306IVOP3gmoT0_;g=07H0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3T
hn<0MP3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`0_0?ooo`030>CS
h`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0
i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[
MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W
>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F
06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0
o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080
o?cl00@0o?cm0?clo03knod0o?cm503lno`20?_lo00309bT^@1[MHl0QHV`
0100QHV`00H0JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9/00606]eS`2L
Y;T0nocl0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_lo03lo?`0o?_m
0?_lo@3RhN800@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0m_Oh
0?Ogn@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi0?Kgn@020?Og
n@040?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3gmoT04`3gmoT2
0?Kgn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi06]e
S`25RK0A09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=
0<IEG0090<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q0040
IVIn00001P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm100000000H0lO7d0?3b
m@3alO@0lO;d0?3bm03alO@F0?3am@0306]eS`2b]M00YjS20100YjS200H0
/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e0?7b
m02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0`U9K
0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3Lfn00j^_`
0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0inOW0>OW
i`030>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`
0>[[l00B0>[[l080j^c`00@0JgF?0;Jid@2][/H0[Jk6203oool00`2][/H0
[:k60:f^aP030:f^aP030:b^aP2f^M40JgF?0080j^__00@0JgF?0;Jid@2]
[/H0[Jk6303oool20:f^aP030:b^aP2f^M40JgF?0080j^_`00D0YSU40<eI
GP3;E5T0cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0j^__
0>[[l0020>[[k`40g=_P0@1VIWh0000406IVOP3IfMl0hnGZ0>?TjP80hnG[
00D0000008b<S03Ng]h0inOW0=kNgP020>OWi`030<IS003WinL0inOW0080
inOW00L0knoW0>o_k`3_knl000000>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[
0>?Uj`3SiN/04P3SiN/20>?TjP0506]eS`2l_]@0/[;:0;:bbP3oool01P1^
KHl00`0U9CH0/[;:0;:bbP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[MHl0
_;kD0P2b//X00`3oool09BDf02DU=P0902DU=P<0/[;:00D0_;kD06]eS`3S
i>/0hnC[0:HiA0020<eIGP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3oool0
2P3DG5l0d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl106IV
OP0000<0IVIn0=OHgP3Lg^H00`3Lg^H01@000000inOW0>OWi`3WinL0imK>
0080inOW00D0cW/00>nD403WinL0imk60>n<40030>o_k`070000003Lg^H0
g=kU0=cNi@3Lg^H0g=kU0=cNiP0F0=cNi@0506]eS`2o`MH0^;W>0;RicP3o
ool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU0=cN
i@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U9CH0
^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C
9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA0020=cN
i@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>420=GH
h0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080gV/0
00D0kkF<0>o_k`3_knl0kno_000000020=GHh@040=GGh03Ff>00e]SQ0=KG
hA@0e]OP0P3Ff>001@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M40
1P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M40
1`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V
>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0
fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0
000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36
BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@
d]`00`3?d]`0d=;L0<oBg00D0=3Bg080cm;M00<0JgF?0<S9f`33a=H04033
a=H01P38bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80`lCF00<0oooo02DU=P33
a=H01`33a=H00`3oool09BDf0<?4eP020<?4eP070<S9f`1[MHl0cm;L0<oB
g02V>D@0eemO0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3o
ool020167QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`10<oB
g040d]CM0@1VIWh0000L06IVOP3@d]/0blgH0<[=f@3;c]P0b/gH0000003W
aZd0ilJ<0?O>603__@00mlH00>n]003W[@00ijD00=J<003>J`00ilH00?oF
003_knL0kno_0000003;cMP0blgI0<[=f@3;c]P0b/gH0<_=f1@0blgI0P3;
c]T00`1[MHl0blcN0<S:f@080<S:f@030<S9f@38b]T0b<[I00<0b<[I00@0
b<WI0<S:f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN0<S:f@38b]T0oooo02DU
=PD0b<[I0140b<WI0<S:f@38b]T0oooo02DU=P38b]T0b<WI0<S:f@3;c=h0
JgF?0<_>f03:cMP0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN6P3o
ool0oooo00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO0:Hi
A03:c]P0b/kI0P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0030<G8
e00600000036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD
00020?O60080moOg00@000000<G8e035am@0aLOD0`35amDD0<C7e@80a<SD
00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3A
h080bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;
g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3o
ool0oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040
aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000
inOW0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm
003_knl0moOg000000<0`LCB00<0`/CA0<74dP31a=805031a=420<74dP03
06]eS`3Cdn80cm3M0100cm3M00H0dm?R06]eS`32a=80`/CB06]eS`3Cdn82
0<o@g@030?ooo`0U9CH0cm3M00L0cm3M00<0oooo02DU=P3?d=d00P3?d=d0
1`3Cdn80JgF?0<;4dP31a=40YSU40=]TI03QJFD01@3PK6T50?ooo`D0h6aY
00P0hFUU0=]TI02V>D@0`LCB0<;4d@31a=40`LCB0<c>fP40IVIn0000101V
IWh0b/cH0;k0c`2m`<l20;k0cP050000002LW9`0inOW0>ONeP3FS0000P3N
U000103FN`00aV<00;e2003_Y@020?N]00080?Ne003ocTX000000;k0cP2n
`<l0_/3>0;k0c`2m`<hE0;k0cP80_L3>00<0JgF?0=KFi03Cdn00403Cdn00
1P3Fe^@0JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3oool0
203oool02`0U9CH0dm?P0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:HiA03P
IVD0hFYZ00@0hfa/0`3oool010167QX0oooo0?ooo`3oool40>=/K0040>5Z
JP3PIVD0YSU40;g0c`80_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0bL[H
0;Jhb02i_</0^[c;0;Zlc00000000P3_knl04`3FW000eX`00=jD003FQ000
kjD00=j<002mFP00eW<00>nL003gknL0moOg0?ooo`000000^Kc<0;Zkc02i
_</0^[c;0;Vlc02i_</0502i_<`20;Zlc00306]eS`3Hf>D0dm?Q0100dm?Q
00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?
00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0
h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3oool2
0>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H0040
IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OWgP02
0>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Ogm`050000
002f^LT0]kS90;Jib@2g^LT00P2f^<TD0;Nhb@80][S900@0JgF?0=KFi03H
f>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@090=KFi01[MHl0]kS9
0;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d09BDf0=SHiP3Hf>D0
f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo
00D0AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^
K@2V>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn00000`1VIWh0a/SG0;Bf
a`030;Bfa`030000003_knl0kno_0080kno_00/0ijd00?O6203WY@00ii@0
0>N<003_imH0gY@i0>oF]@3omoL0oooo0000000L0;Bfa`0506]eS`3EeN<0
g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80
g=_W00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GEh`1[MHl0];K70;Bf
a`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ0>UnN03YOWP00`3Y
OWP020167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d]/L10<K8
e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`060000002<S8`0kno_0>o_
k`3WcW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool0
0000702d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0];K70;Bf
a`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0YSU40>YiL`3YO7P0
kh5j0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:0>^HR`02
04HN6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L10<K8e`40IVIn0000
0`1VIWh0a/SG0;6cb0030;6cb0060000003_knl0kno_0>o_k`3gmnl0kno_
0P3gmoL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`000000/K?801/0/K?8
00<0JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[
la40jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0
lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3g
WHh0mHb40?24O03aP7D0YSU400@0/K?80@36b=L106IVOP0000<0IVIn0<K8
e`2h]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3omoL2
0?ooo`030000002_[/L0[jk701X0[jk700<0JgF?0=;Ah`3blOL0403blOL0
1P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0d]7S06]eS`2_[/L0
[jk70:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^a`020:n^
a`40^;O?0@36b=L106IVOP0000<0IVIn0<31d@37am@0;`2/Zl@01024S:80
JgF?0<c;g@3kno`=0?ooo`040?