(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   2550850,      44675]*)
(*NotebookOutlinePosition[   2644459,      46619]*)
(*  CellTagsIndexPosition[   2643284,      46580]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Widget Gallery", "Chapter",
  PageBreakAbove->False,
  CellTags->"GalleryIntro"],

Cell["\<\
The following pages provide a visual tour of the possible user interface \
widgets available, as well as sample expressions representing common user \
interface design patterns that you can reuse and modify for specific needs.\
\>", "Text",
  CellTags->"GalleryIntro"],

Cell[TextData[StyleBox["Entry template:",
  FontSlant->"Italic"]], "Text",
  CellTags->"GalleryIntro"],

Cell[CellGroupData[{

Cell[TextData[{
  "Widget[\"",
  StyleBox["name",
    FontSlant->"Italic"],
  "\"]"
}], "ObjectName",
  CellTags->"GalleryIntro"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"", "Program"],
  StyleBox["propertyName", "Program",
    FontSlant->"Italic"],
  StyleBox["\" \[Rule] ", "Program"],
  StyleBox["value", "Program",
    FontSlant->"Italic"],
  StyleBox["\n", "Program"],
  "\[Ellipsis]"
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"GalleryIntro"],

Cell[TextData[{
  StyleBox["Events", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"", "Program"],
  StyleBox["eventName", "Program",
    FontSlant->"Italic"],
  StyleBox["\" - ", "Program"],
  StyleBox["description of when this event is triggered\n", "Text"],
  "\[Ellipsis]"
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"GalleryIntro"],

Cell[TextData[{
  StyleBox["Methods", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["InvokeMethod[\"", "Program"],
  StyleBox["methodName", "Program",
    FontSlant->"Italic"],
  StyleBox["\", ", "Program"],
  StyleBox["arg1", "Program",
    FontSlant->"Italic"],
  StyleBox[", ", "Program"],
  StyleBox["arg2", "Program",
    FontSlant->"Italic"],
  StyleBox[", \[Ellipsis]] - ", "Program"],
  StyleBox["description of what this method will do", "Text"]
}], "Notes",
  CellTags->"GalleryIntro"],

Cell[TextData[{
  "Each entry begins with the listing of the string name identifier used when \
defining a new instance of a widget using the following form. ",
  StyleBox["Widget[", "Program"],
  "\"",
  StyleBox["name",
    FontSlant->"Italic"],
  "\", ",
  StyleBox["{", "Program"],
  StyleBox["child widgets",
    FontSlant->"Italic"],
  ", ",
  StyleBox["scripts",
    FontSlant->"Italic"],
  ", ",
  StyleBox["bindevents",
    FontSlant->"Italic"],
  ", \[Ellipsis]",
  StyleBox["}", "Program"],
  ", ",
  StyleBox["options",
    FontSlant->"Italic"],
  StyleBox["]", "Program"]
}], "Text",
  CellTags->"GalleryIntro"],

Cell["\<\
The next sections list a few of the most common properties, events, and calls \
that this widget provides.\
\>", "Text",
  CellTags->"GalleryIntro"],

Cell[TextData[{
  "Property names are used with the forms ",
  StyleBox["PropertyValue[\"", "Program"],
  StyleBox["propertyName",
    FontSlant->"Italic"],
  StyleBox["\"]", "Program"],
  ",",
  StyleBox[" SetPropertyValue[\"", "Program"],
  StyleBox["propertyName",
    FontSlant->"Italic"],
  StyleBox["\", ", "Program"],
  StyleBox["value",
    FontSlant->"Italic"],
  StyleBox["]", "Program"],
  ", and the shorthand form of ",
  StyleBox["SetPropertyValue", "Program"],
  ", ",
  StyleBox["\"", "Program"],
  StyleBox["propertyName",
    FontSlant->"Italic"],
  StyleBox["\" \[Rule] ", "Program"],
  StyleBox["value. ",
    FontSlant->"Italic"],
  "All possible property names available to a widget can be discovered using \
",
  StyleBox["GUIInformation[", "Program"],
  StyleBox["runtime",
    FontSlant->"Italic"],
  StyleBox[", ", "Program"],
  StyleBox["widget",
    FontSlant->"Italic"],
  StyleBox[", \"PropertyNames\"]", "Program"],
  ".  Additionally, all possible forms for settable (writable) property \
values, including the datatypes of the property can be found by using ",
  StyleBox["GUIInformation[", "Program"],
  StyleBox["runtime",
    FontSlant->"Italic"],
  StyleBox[", ", "Program"],
  StyleBox["widget",
    FontSlant->"Italic"],
  StyleBox[", \"SetPropertyValuePatterns\"]", "Program"],
  " or ",
  StyleBox["GUIInformation[", "Program"],
  StyleBox["runtime",
    FontSlant->"Italic"],
  StyleBox[", ", "Program"],
  StyleBox["widget",
    FontSlant->"Italic"],
  StyleBox[", \"VerboseSetPropertyValuePatterns\"]", "Program"],
  ".  Gettable (readable) property values are returned with ",
  StyleBox["GUIInformation[", "Program"],
  StyleBox["runtime",
    FontSlant->"Italic"],
  StyleBox[", ", "Program"],
  StyleBox["widget",
    FontSlant->"Italic"],
  StyleBox[", \"PropertyValuePatterns\"].", "Program"]
}], "Text",
  CellTags->"GalleryIntro"],

Cell[TextData[{
  "Event names are used with the form ",
  StyleBox["BindEvent[\"", "Program"],
  StyleBox["eventName",
    FontSlant->"Italic"],
  StyleBox["\", Script[\[Ellipsis]]] ", "Program"],
  "to set up execution of script code when the event occurs. All possible \
event names available to a widget can be discovered using ",
  StyleBox["GUIInformation[", "Program"],
  StyleBox["runtime",
    FontSlant->"Italic"],
  StyleBox[", ", "Program"],
  StyleBox["widget",
    FontSlant->"Italic"],
  StyleBox[", \"EventNames\"]", "Program"],
  "."
}], "Text",
  CellTags->"GalleryIntro"],

Cell[TextData[{
  "There may also be common ",
  StyleBox["InvokeMethod", "Program"],
  " forms that are used to execute functions on widgets with possible \
multiple arguments included. All possible method names available to a widget \
can be discovered using ",
  StyleBox["GUIInformation[", "Program"],
  StyleBox["runtime",
    FontSlant->"Italic"],
  StyleBox[", ", "Program"],
  StyleBox["widget",
    FontSlant->"Italic"],
  StyleBox[", \"MethodNames\"]", "Program"],
  ".  Additionally, all possible forms for invoking a method, including the \
datatypes of the method parameters can be found by using ",
  StyleBox["GUIInformation[", "Program"],
  StyleBox["runtime",
    FontSlant->"Italic"],
  StyleBox[", ", "Program"],
  StyleBox["widget",
    FontSlant->"Italic"],
  StyleBox[", \"InvokeMethodPatterns\"]", "Program"],
  " or ",
  StyleBox["GUIInformation[", "Program"],
  StyleBox["runtime",
    FontSlant->"Italic"],
  StyleBox[", ", "Program"],
  StyleBox["widget",
    FontSlant->"Italic"],
  StyleBox[", \"VerboseInvokeMethodPatterns\"]", "Program"],
  "."
}], "Text",
  CellTags->"GalleryIntro"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Basic Widgets", "Section",
  CellTags->"ComponentGallery"],

Cell[CellGroupData[{

Cell["Widget[\"Frame\"]", "ObjectName",
  CellTags->"Frame"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"", "Program"],
  StyleBox["title\"", "MR"],
  StyleBox[" \[Rule] \"window title\"", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"Frame"],

Cell[TextData[StyleBox["Events", "SubsubsectionFirst"]], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"Frame"],

Cell[TextData[{
  StyleBox["Methods", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["InvokeMethod[\"dispose\"] - ", "Program"],
  StyleBox["requests that the frame close", "Text"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"Frame"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"Frame"],

Cell[TextData[{
  StyleBox["Widget[\"Frame\"]", "Program"],
  " is a container component where you can place all other components with \
visual content. ",
  StyleBox["Widget[\"Frame\"]", "Program"],
  " represents a complete window including any window title bar that, for \
example, allows you to set the window's text using the ",
  StyleBox["\"", "Program"],
  StyleBox["title\"", "MR"],
  " property."
}], "Text",
  CellTags->"Frame"],

Cell[TextData[{
  "However, if you are interested in designing reusable complex groups of \
interacting widgets that can function together as their own compound widget \
in other user interfaces, it is recommended you build them within a ",
  StyleBox["Widget[\"Panel\"]", "Program"],
  " and not ",
  StyleBox["Widget[\"Frame\"]", "Program"],
  " because using ",
  StyleBox["Widget[\"Frame\"]", "Program"],
  " forces this definition to only be deployable as its own standalone \
window."
}], "Text",
  CellTags->"Frame"],

Cell[BoxData[
    \(\(Needs["\<GUIKit`\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Frame"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\  = \ 
      GUIRun[\[IndentingNewLine]Widget["\<Frame\>", \
{\[IndentingNewLine]"\<title\>" \[Rule] \ "\<My Title\>", \
\[IndentingNewLine]WidgetGroup[{\ \[IndentingNewLine]Widget["\<Panel\>", \ 
                  WidgetLayout \[Rule] {"\<Stretching\>" \[Rule] {Maximize, \ 
                          Maximize}\ }]\[IndentingNewLine]\ }, \ 
              WidgetLayout \[Rule] {\ "\<Border\>" -> "\<Content\>"\ }], \
\[IndentingNewLine]{\[IndentingNewLine]WidgetFill[], \
\[IndentingNewLine]Widget["\<Button\>", {"\<text\>" \[Rule] "\<OK\>"}], \
\[IndentingNewLine]Widget["\<Button\>", {"\<text\>" \[Rule] "\<Cancel\>"}]\
\[IndentingNewLine]}\[IndentingNewLine]}]\ \[IndentingNewLine]]\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Frame"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject480710120964097, 
        JLink`Objects`JavaObject210201571491841]]], "Output",
  CellLabel->"Out[2]=",
  CellTags->"Frame"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Frame"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002L0000KR000`400?l0
0000o`00003oW01VIWh0000306IVOP3ko?d0nocm09P0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk09L0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
UP1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOR40h=oS
00D0hN3T0>KUj03/jnh0l?3b0?;bm00C0??cm100n?Oh0P3clo@01@3cloD0
m?Ce0?GemP3dloD0iNCX00<0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;bm00L
0??cm1T0n?Oh0P3clo@0203cloD0m?Ce0?GemP3dloD0iNCX06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOR40h=oS00@0g]cO0>CRh01k
Ujd09EN59`00?7@0100GCGh0Jh^V0?;akP3blO<30>3Oh`040=kLg`3Th^00
NiN]02EGQCT003ad00L05den06^;YP3blNh0l_7c06IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWhQ0>3Oh`040=[Hf@1VQJ409df504em
`BP0JH;^00<09df506Z:Y03_ko400`3Pgn<0103Jf=T0IXFQ04YaT`2b_L<i
0<K5e`070<36a@18KY00JXZT0>o_l@1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn8@3Pgn<00`3HeMH05den08V]i00Z08V]i00301M=
OP3[j^d0h=oS0080h=oS00<0f=GF01M=OP2oalX0>`36aML01P2f_Kd05den
0>_Zk@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhQ0>3O
h`040=WEe@00?7@0RJgT0?ooobL0cLcO00@0oooo08V]i000?7@0j>OZ0`3P
gn<00`3IeMD003ad0?ooo`0k0<g<g`060?ooo`00?7@0j>OZ06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOR40h=oS00@0fMGE000lM02;
[N@0oooo9`3BdN@0103oool0RjoU000lM03Wi^T30>3Oh`030=WEe@00?7@0
oooo03/0d]7T00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn8@3Pgn<0103IeMD003ad08j_iP3ooolW0=KGi`04
0?ooo`2=[nD003ad0>OVj@<0h=oS00<0fMGE000lM03oool0>`3FenL01P3o
ool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWhQ0>3Oh`040=WEe@00?7@0TK7W0?ooo`h0fM[W0`0000030=WJi`030000
003If^L0fM[W0080fM[W00<000000=WJi`3If^L02`3If^L0103oool0TK7V
000lM03Wi^T30>3Oh`030=WEe@00?7@0oooo00l0fM[W0`0000030=WJi`80
000000@0fM[W0000003If^L000000`3If^L00`000000fM[W0=WJi`030000
00<0fM[W0`0000020=WJi`030000003If^L0fM[W00`0fM[W00H0oooo000l
M03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn8@3P
gn<0103IeMD003ad09Bdj03oool=0=WJi`050000003If^L0fM[W0=WJi`00
00000P3If^L01@000000fM[W0=WJi`3If^L0000000h0fM[W00@0oooo09Fd
j000?7@0inKY0`3Pgn<00`3IeMD003ad0?ooo`0>0=WJi`070000003If^L0
fM[W0=WJi`000000fM[W000000020=WJi`80000000<0fM[W0000003If^L0
0P3If^L00`000000fM[W000000030=WJi`030000003If^L0000000<0fM[W
00<000000=WJi`0000003P3If^L01P3oool003ad0>OVj@1VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWhQ0>3Oh`040=WEe@00?7@0V;SZ
0?ooo``0g]o/00<000000=kOk03Ngn`00`3Ngn`00`000000g]o/00000003
0=kOk0030000003Ngn`0g]o/00`0g]o/00@0oooo09Rhj@00?7@0inKY0`3P
gn<00`3IeMD003ad0?ooo`0=0=kOk0030000003Ngn`0g]o/00@0g]o/00L0
00000=kOk03Ngn`0g]o/0000003Ngn`0000000<0g]o/00<000000=kOk000
00001@3Ngn`00`000000g]o/0=kOk0030=kOk0030000003Ngn`0g]o/00`0
g]o/00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn8@3Pgn<0103IeMD003ad09bkjP3oool<0>?Ul0030000003S
iO00hnG`00<0hnG`00H000000>?Ul000000000000>?Ul000000?0>?Ul004
0?ooo`2L^n/003ad0>OVj@<0h=oS00<0fMGE000lM03oool03@3SiO000`00
0000hnG`0>?Ul0050>?Ul0@0000000<0hnG`0000003SiO000P3SiO000`00
0000hnG`000000050>?Ul0D0000000<0hnG`0000003SiO003@3SiO001P3o
ool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWhQ0>3Oh`040=WEe@00?7@0X;k/0?ooo``0jN_e00<000000>W[m@3YjoD0
0`3YjoD010000000jN_e0000003YjoD2000000l0jN_e00@0oooo0:6nk000
?7@0inKY0`3Pgn<00`3IeMD003ad0?ooo`0=0>W[m@030000003YjoD0jN_e
00@0jN_e00H000000>W[m@3YjoD0jN_e0000003YjoD200000080jN_e00<0
00000>W[m@0000000`3YjoD00`000000jN_e000000030>W[m@030000003Y
joD0000000h0jN_e00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn8@3Pgn<0103IeMD003ad0:G1k@3oool<0?3a
o0030000003`lO`0l?7l00<0l?7l00<000000?3ao00000000P3`lO`00`00
0000l?7l0?3ao00=0?3ao0040?ooo`2U`^h003ad0>OVj@<0h=oS00<0fMGE
000lM03oool03@3`lO`00`000000l?7l0?3ao0050?3ao0<000000P3`lO`0
10000000l?7l0000000000030?3ao0<000000`3`lO`300000080l?7l00<0
00000?3ao03`lO`0303`lO`01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWhQ0>3Oh`040=WEe@00?7@0ZLG_0?oo
o`d0m?Gm00D000000?Ceo@3dmOd0m?Gm000000020?Ceo@050000003dmOd0
m?Gm0?Ceo@0000003P3dmOd0103oool0ZLG_000lM03Wi^T30>3Oh`030=WE
e@00?7@0oooo00h0m?Gm00D000000?Ceo@3dmOd0m?Gm0000000I0?Ceo@03
0000003dmOd0m?Gm00`0m?Gm00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn8@3Pgn<0103IeMD003ad0:g8l03o
ool>0?Kgo@<000000`3fmod00`000000m_Om0?Kgo@020?Kgo@030000003f
mod0m_Om00/0m_Om00@0oooo0:c7l000?7@0inKY0`3Pgn<00`3IeMD003ad
0?ooo`0?0?Kgo@<000006P3fmod00`000000m_Om0?Kgo@0<0?Kgo@060?oo
o`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OR40h=oS00@0fMGE000lM02abo80oooo9`3ho?d0103oool0/Lcb000lM03W
i^T30>3Oh`030=WEe@00?7@0oooo03/0n?cm00H0oooo000lM03Wi^T0IVIn
0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn8@3Pgn<0103IeMD0
03ad0;C=l`3ooolW0?gmo@040?ooo`2ec_<003ad0>OVj@<0h=oS00<0fMGE
000lM03oool0>`3moOd01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWhQ0>3Oh`040=WEe@00?7@0]m3d0?ooobL0
oOgm00@0oooo0;S@m@00?7@0i^KY0`3Pgn<00`3IeMD003ad0?ooo`0k0?gm
o@060?ooo`00?7@0i^KY06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOR40h=oS00@0f=CD000lM02jdoD0oooo9`3moOd0103oool0^]?f
000lM03UiNP30>3Oh`030=SDe000?7@0oooo03/0oOgm00H0oooo000lM03U
iNP0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn8@3Pgn<0
0`3IeMD09EN50;cDmP0Z0;cDmP0302EGQ@3QhN@0h=oS0080h=oS00<0fMGE
02EGQ@2oc]`0>`3oool01P2oc]/09EN50>7Qi01VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWhQ0>3Oh`030=WEe@1iU:T09df502T0c^Oo
00<09df507VEZ`3OgN000`3Pgn<0103IeMD0NIBY05EmXP30cmdi0?ooo`07
0=GOj01EOJ80NIF[0=oMh01VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn8@3Pgn<0103JemT0gmcH07VDZ@0UEhDW000lM00401M=OP1V
QZ40h=kJ0=cKg@<0h=oS00@0f]OI0=oLf01iU:T09EN5>@00?7@01`0GCGh0
IXJQ0>3NfP3Lfmd0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOR40h=oS00<0gmgP0=[Gf@3He=@05@3Gdm@@0=?>c0<0em?D00@0f=CD
0=WEe@3JemT0gmgP0`3Pgn<00`3OgN00f]OI0=SDe00N0=OCe1T0dlk<0`3G
dm@01`3He=@0fMGE0=[Gf@3OgN00IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOY@0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOY@0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOY@0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOY@0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOY@0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOP80h=oST03oool20>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Ohhl0W9bN00H0oooo0>3Oh`3P
gn<0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2;0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2;0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`060>3Oh`<000000`3P
gn<300000080h=oS00H000000>3Oh`3Pgn<0h=oS0000003Pgn<200000080
h=oS0`0000020>3Oh`060000003Pgn<0h=oS0>3Oh`000000h=oS0P00001S
0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`050>3Oh`070000
003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<00000
00<0h=oS00<000000>3Oh`0000000P3Pgn<01`000000h=oS0>3Oh`3Pgn<0
00000>3Oh`0000000`3Pgn<00`000000h=oS0000001T0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`040>3Oh`030000003Pgn<0h=oS00@0
h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<00000
0>3Oh`0000000P3Pgn<00`000000h=oS0>3Oh`030>3Oh`070000003Pgn<0
h=oS0>3Oh`000000h=oS0000001T0>3Oh`0709bLWP3oool0h=oS0>3Oh`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2L
W9h0oooo0?ooo`030?ooo`030>3Oh`000000h=oS00D0h=oS00L000000>3O
h`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000000P3P
gn<5000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`0000000`3P
gn=Q0?ooo`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<609bLWP030>3Oh`000000h=oS00D0
h=oS00H000000>3Oh`3Pgn<0h=oS0000003Pgn<200000080h=oS00<00000
0>3Oh`0000000P3Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`800000
0P3Pgn<00`000000h=oS000000030>3Ohf80W9bN00H0oooo0>3Oh`3Pgn<0
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn2@3Pgn<00`00
0000h=oS0>3Oh`050>3Oh`<000000P3Pgn<01@000000h=oS000000000000
h=oS00<000000P3Pgn<300000080h=oS00D000000>3Oh`00000000000>3O
h`03000006L0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOPX0h=oS00D000000>3Oh`3Pgn<0h=oS0000000=0>3Oh`030000
003Pgn<0h=oS00`0h=oS00<000000>3Oh`3Pgn<0IP3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn2`3Pgn<3000000h0h=oS
00<000000>3Oh`3Pgn<0303Pgn<00`000000h=oS0>3Oh`1V0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjD0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjD0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjD0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjD0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjD0>3Oh`0306IV
OP2XZK/0nocm0040IVIn00000`1VIWh0moOi09RHY`2F07MgTP40V9RW0@3g
moT106IVOP0000<0IVIn0?Ogn@2l_Ld0U`2l_Ld10?Ogn@40IVIn00000`1V
IWh0moOi0>CSh`2G0>CSh`40moOi0@1VIWh0000306IVOP3`lO@0oooo0500
oooo00<0i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?06afT01/MY0906]e
S`0609bT^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0101/MY00JgF?06af
T01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W
>T@0YSU40:LjA02W>T@90:HiA00309bT^@3/j^X0oooo00<0oooo0@3`lO@1
06IVOP0001H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0
o?cm0?clo03lnod0o?cl0?cko03lo?`0nocl0?clo03ko?d0o?_l0?clo@3k
nod0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?d:0?cko0030<O2d@3Wi>/0
moKh0180o?_l603ko?`00`2LY;T0JgF?08F9/00@08F9/00606]eS`2LY;T0
nocm0?_lo@2LY;T0JgF?4@25RK001P1[MHl0W:Bi0?_lo03kno`0W:Bi0:Hi
A140ZSaE00L0YSU409bT^@3ko?`0o?cl0?cko@3ko?d0h^7R0040IVIn0000
101VIWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0
moOh0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3gmoT0103gm_P0m_Oh0?Kgn@3g
moT30?Kgn@030?Kgn03gmoT0moOi00P0moOi00@03Q0@07ilQ@2g//00f]OQ
4P3gmoTH0?Kgn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3gmoT0
moOi06]eS`25RK0A09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9B
F`36E5X=0<IEG0090<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0
h>3Q0040IVIn00001P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm100000000H0
lO7d0?3bm@3alO@0lO;d0?3bm03alO@90?3am@803Q0@00<0J6U[0<O2d@3Y
j^l0:@3`lOD00`1[MHl0/[G@0:NX`P0@0:NX`P060;:ed01[MHl0l?7d0?3a
m01[MHl0/[G@4@2WZ<801@2b]M00JgF?0?3am@3al_@0YSU40080`U9K00<0
beAI0<eIGP3=FEh02`3=FEh0103;E5T0`U9K0<9BF`2V>D@20?3am0030?7a
m03`l_@0g]gQ0040IVIn00001`1VIWh0g=_P0>[[l03Zjo00j^c`0>W[k`00
00000P3WinL20=kNgP80inOW00<0ikf40>OWi`3WinL00`3WinL20>o_k`04
0000003Zjo00j^_`0>[[k`80j^_`0P37`]401@3Zjo00inO]0<O2d@3Wind0
j^_`0080al;A0P3Zjo00103@dMD03Q0@0:^W]03Mg>D90>[[l080al;A103Z
jo020<O2d@80j^c`00<0hnCZ0<O2d@37`]400P3Zk?002@3TiN/0dLkJ0>;R
j@3Zk?00h>7X0=7>fP37`]40eM?M0>OXk@080>[/l00406]eS`2f^M40[Jk6
0:f^aPP0oooo00<0[Jk60:b^aP2][/H00`2][/H00`2/[/H0][WA06]eS`02
0>[[k`0406]eS`2f^M40[Jk60:f^aP`0oooo0P2][/H00`2/[/H0][WA06]e
S`020>[[l0050:HiA03=FEh0beAI0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK
0<]DF@3=FEh0YSU40>[[k`3Zjo000P3Zjnl10=cKh040IVIn0000101VIWh0
fMWO0>?UjP3Si>X20>?Uj`050000002<S8`0g]kN0>OWi`3Ng]h00P3WinL0
0`36H`00inOW0>OWi`020>OWi`080>o_i`3_knl0kno_0000003Si>X0hnC[
0>?UjP3Si>X200h@40050<O2d@3@d]P03Q0@0;Nb`03Jf^<00P0>41001`3F
eMl0hnG[0>?Uj`3GfMh03Q0@08N4SP37`]40203SiN/200h@40040<O2d@3S
iN/0hnG[0>?Uj`803Q0@00<0al;A0>?TjP2l_L800P0>41020>?TjP0:0<?4
b@18BD`0WY^V0>?TjP2VYZ`0ATI:00h@401RHfH0_[_60=[IhPP0hnCZ00D0
JgF?0;bne02b//X0/[;:0?ooo`0606i]S`0302DU=P2b//X0/[;:00D0/[;:
00H0_;kD06]eS`3SiNX0hnGZ06]eS`2l_]@20;:bbP030?ooo`0U9CH09BDf
00T09BDf0`2b//X01@2l_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN00@0d5]P
0=ALG`3oool0oooo1`3DG5l20?ooo`0:0=ALG`3@Ff00cEUN0<eIGP2V>D@0
hnCZ0>?UjP3Si>X0hnG[0=WIg`40IVIn00000`1VIWh0emSN0=cNiP030=cN
iP050000003WinL0inOW0>OWi`3We/h00P3WinL01@3>N`00ki@@0>OWi`3W
g/H0kh`@00<0kno_00l000000=cNiP3Lg^D0g=kU0=cNiP1oPHD03Q0@0<O2
d@2NX:D03Q0@08n<U`3?cMT03Q0@07AbNP3BdM`00P3Lg^D01@2VZ:h03Q0@
00h@4037`]40f=SQ00L0g=kU0P0>41001037`]40g=kU0=cNi@3Lg^D200h@
40050<O2d@3Lg^D0C4i@00h@4037`]400P3Lg^D02@1<CU003Q0@0<O2d@2V
Z:h03Q0@09NDW`2^/;H0C4i@09jPY@090=cNi@0506]eS`2o`MH0^;W>0;Ri
cP3oool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU
0=cNi@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U
9CH0^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AM
H@1C9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA002
0=cNi@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>42
0=GHh0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080
gV/000D0kkF<0>o_k`3_knl0kno_000000020=GHh@0<0=GGh03Ff>00O7j3
00h@4037`]40Gf1T00h@401NGf<0al;A00h@401dLWX0d]7L0P3Fen001@1N
Gf<03Q0@00h@402UXJd0clgI00L0e]OP0P0>41001037`]40e]OP0=KGh03F
en0200h@40050<O2d@3Ff>003Q0@00h@4037`]400P3Ff>0200h@40030<O2
d@1:C4l03Q0@00D0al;A203Ff>001@1[MHl0`lGI0;bmd@2l_M40oooo00L0
9BDf1`2l_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo
02DU=P2l_M401`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0
e]OP0=GGh@2V>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3o
ool00`167QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40
eMKM0@1VIWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OW
i`0<0>ONcP36BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_
ilh000000`3@d]`04`3?d]`0WZ2W00h@402g//003Q0@0:NV/@0>4100^KS4
00h@402GU9l0cLgI0=3Bg02/[[H03Q0@0:NV/@0>4100MGEl0<O2d@3?dM/0
1P3@d]`200h@40040<O2d@3@d]`0d=;L0=3Bg0803Q0@00D0al;A0<oBg@0>
41003Q0@0<O2d@020<oBg@803Q0@00<0al;A00h@400>4100100>41000`39
a]@0cm;M0<oBg@060<oBg@0306]eS`38bM/0`lCF0100`lCF00H0b<WK06]e
S`3@d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U9CH0`lCF00L0`lCF00<0
oooo02DU=P33a=H00P33a=H01`38bM/0JgF?0<oBg03?d]`0YSU40=MOG`3I
HF800`3LIFD01@167QX0oooo0?ooo`3oool0g6EU00<0oooo00P0AQhJ0=aU
I@3LIFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?d]`10=;Dg@40IVIn
0000;01VIWh0d=;K0<_=f03:cMT0blkH0<[=f0000000ilJ]0>O6S03gcQP0
kkd00?O6003_[@00ijd00>NU003FS000cV/00>O6003oeP00knoW0>o_k`00
0000blgH0<_=f@3:cMT0blkH09VLY00>4100ShbG05YJH039bMH0FeeR096A
VP0>4100UiBO0<[;f03;cMT0FeaQ05UHG`39bMH0FeeR00h@402l^<H0b/[G
1P3;cMT200h@40040<O2d@3;cMT0blgI0<_=f@803Q0@00D0al;A0<_>f@0>
41003Q0@0<O2d@020<_>f@803Q0@00P0al;A04M9C@0>4100al;A0<[;e`0>
4100ATI:0<W9ePP0blkI00<0JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I
0<S:f@030<S:f@040<S9f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38
b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I
0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD0
0P3NIfL00`167QX0oooo0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3P
IfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn
0<o?fP35b=@00`35b=@01P000000a/K60>ONeP3>N`00ijd00>ne0080ijD0
00<0eY@00<ic003FU0000P3gaP020?Ogm`0G00000035b=@0aLOD0<G7e035
amD0[k6n00h@401IF5l0ShbG0<G6e02=T9X0F5YP00h@402a[KX0aLKD0:R[
]`0>4100ShbG0<G6e02=T9X03Q0@09jKYP36a=801P34amD200h@40040<O2
d@34amD0a<OE0<C7e@803Q0@00@0al;A0<C8e00>41003Q0@0P37`]402P34
b=@03Q0@00h@4037`]40QHR@00h@402MWJL0ZjNd00h@4026QXl90<C8e003
06]eS`3@dN00bl_L0100bl_L00H0d=7P06]eS`34am@0a<OD06]eS`3@dN02
0<_;g0030?ooo`0U9CH0bl_L00L0bl_L00<0oooo02DU=P3;bm`00P3;bm`0
1`3@dN00JgF?0<G7e034am@0YSU40=]TI03OIF@01@3PJVP01@167QX0oooo
0?ooo`3oool0AQhJ00D0h6YX00@0gfET0=]TI02V>D@0a<SE0P34b=@10<G7
e@40cloJ0@1VIWh0000406IVOP3<c]X0`/CB0<74d@80`LCB00H000000>OW
i`3WinL0inOW0=J4003_]@020>NU00080=J4003>J`00ijd00?Ne003g_@00
kno_0?Ogm`0000030<74dP070<;4d@2/[k/03Q0@00h@402f//00`LCA0;6d
`00200h@40090;6]^P31a=40L7=j00h@402a]<00`LCA0;6d`00>4100IFM^
00L0`LCA0P0>41000`37`]40`LCA0<74d@0300h@40030<74d@0>41003Q0@
00803Q0@0P31a=8200h@40030<O2d@31a=80PhJ?00803Q0@00<0PhJ?0<74
dP31a=802031a=800`1[MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0`/CB
0<;4dP1[MHl0dm?R0P3?d=d00`3oool09BDf0<o@g@070<o@g@030?ooo`0U
9CH0cm3M0080cm3M00L0dm?R06]eS`32a=80`LCA0:HiA03KI6@0hFUU00D0
h6aY1@3oool50>1/J@080>5YI@3KI6@0YSU40<74dP32a=40`LCA0<74dP3<
c]X106IVOP0000@0IVIn0<[<f02n`<l0_L3?0P2n`<h01@000000W9bL0>OW
i`3Wg]H0eX`00080gY@000@0eW/00<IS002m@P00kjD00P3g[@002`3g]@00
oli:0000002n`<h0_/3?0;k0cP2n`<l0_L3>00h@401IF5l0aL7@0080_/3>
00<0EUQM00h@4037`]403`2n`<h200h@40030<O2d@2n`<h0_/3>0080_/3>
0P36`M00102m`<h03Q0@00h@4036`M020;g0cP803Q0@00<0al;A0;g0cP2m
`<h03@2m`<h00`1[MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0
cP1[MHl0e]KT0P3Cdn000`3oool09BDf0?ooo`080?ooo`0;02DU=P3Cdn00
dm?P0=?Ch03Fe^@0JgF?0;k0c`2n`<h0YSU40>1VI@3QJVX0103SK6`30?oo
o`0404HN6P3oool0oooo0?ooo`@0hfa/00@0hFYZ0>1VI@2V>D@0_L3?0P2n
`<l10;k0cP40b/cH0@1VIWh0000706IVOP39b]P0][S80;Vlb`2j_</0^[c<
000000020>o_k`0E0=JL003FS000gY@00=J4003_Y@00gX`00;eJ003FL`00
ki`00?O_i`3gmoL0oooo0000002i_<`0^[_<0;Vlb`2j_</0^Kc<00h@402>
S9H0_kk>0080^Kc<00<0QHRC00h@4035`M003@2i_<`20<O2d@803Q0@1037
`]401P1QHf/0IfI]0<G1d02j_<`0QXRC05AFG@<0^[c<0P0>41000`36`M00
^[c<0;Zlc00=0;Zlc00306]eS`3Hf>D0dm?Q0100dm?Q00H0f=SU06]eS`2j
_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?00P0KVf?00h09BDf
0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0
i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3oool20>A`KP090>AaK@3Q
KF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H0040IVIn00002@1VIWh0
alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OWgP020>o_k`070<I[003g
aP00kkD00>nL003NS000cV/00>NL00030?Ogm`080000002f^LT0]kS90;Ji
b@2g^LT0][S906Y/MP2XZKT30;Nhb@030:RY^@1[K7H0]kS900`0]kS9200>
4100102g^<T0H65Z061QJP2g^<T60;Jhb@0306Y/MP11@dP0][S900l0][S9
00@0JgF?0=KFi03Hf>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@09
0=KFi01[MHl0]kS90;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d0
9BDf0=SHiP3Hf>D0f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3W
LFl0i7A_00<0oooo00D0AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>Ad
K`3WLFl0i7A_0>A^K@2V>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn0000
0`1VIWh0a/SG0;Bfa`030;Bfa`030000003_knl0kno_0080kno_00/0ijd0
0?O6203WY@00ii@00>N<003_imH0gY@i0>oF]@3omoL0oooo0000000m0;Bf
a`0506]eS`3EeN<0g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d
]/L0JgF?0=GEh`80g=_W00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GE
h`1[MHl0];K70;Bfa`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ
0>UnN03YOWP00`3YOWP020167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0
YSU4102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`060000
002<S8`0kno_0>o_k`3WcW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0
knOF0?Ogm`3oool00000?@2d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GD
h`1[MHl0];K70;Bfa`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0
YSU40>YiL`3YO7P0kh5j0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3Z
Vh`0kIN:0>^HR`0204HN6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L1
0<K8e`40IVIn00000`1VIWh0a/SG0;6cb0030;6cb0060000003_knl0kno_
0>o_k`3gmnl0kno_0P3gmoL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`00
0000/K?803`0/K?800<0JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6c
b02a/lP0JgF?0>g[la40jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0
l8Al0?F<Q03gWHh0lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]
]9/0k;FL0?:[UP3gWHh0mHb40?24O03aP7D0YSU400@0/K?80@36b=L106IV
OP0000<0IVIn0<K8e`2h]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_
00H0moOg0P3omoL20?ooo`030000002_[/L0[jk703/0[jk700<0JgF?0=;A
h`3blOL0403blOL01P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0
d]7S06]eS`2_[/L0[jk70:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0
YSU40:n^a`020:n^a`40^;O?0@36b=L106IVOP0000<0IVIn0<31d@37am@0
D02/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<
XP80[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24
S:820:b[a007096HZP2V>D@0oin=0?joY03jg;L0n^^g0?[Y]P020?WY]P04
0?[Y]P3ijKH0nNVf0?[Y]P80nNVf00H0n^^g0?[L]`3n_j@0oin=0:HiA02A
V:X30:b[a040alOD0@30`M4106IVOP0000@0IVIn0<31d@3Bd]l0]KC9D02T
Xkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0
Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V
>D@0YSU400l0YSU400L0Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040
IVIn00001P1VIWh0Z:No0>KVk@3Bd^00_;c?0;6`a900Z:No00D0/K340;bl
c`3Bd^00i^K]0:RW_`0106IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@
d>00b/[J08h0_;c?00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ000
00P0F5MX06IVOP2EU:/0emSR0?clo03blO<0k>_^0>7Rjh`0emSR00L0hN;[
0>c[kP3blO<0o?cl0=OHhP2EU:/0IVIn0040F5MX000205QGJ00306IVOP2E
U:/0dM7N0080o?clSP3oool20?clo0030=7AgP2EU:/0IVIn0080F5MX0003
05QGJ080IVIn00<0R8NM09FDZ`2XYkl0S@2XYkl0102EU:/0R8NM06IVOP1V
IWh305QGJ0001@1HEfRB06IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  Evaluatable->False,
  ImageSize->{156, 110},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Frame"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Frame"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"Panel\"]", "ObjectName",
  CellTags->"Panel"],

Cell[TextData[StyleBox["Properties", "SubsubsectionFirst"]], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"Panel"],

Cell[TextData[StyleBox["Events", "SubsubsectionFirst"]], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"Panel"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"Panel"],

Cell[TextData[{
  StyleBox["Widget[\"Panel\"]", "Program"],
  " is an empty container widget where you place all other widgets with \
visual content.  If you are interested in designing reusable complex groups \
of interacting widgets that can function together as their own compound \
widget in other user interfaces, it is recommended you build them within a ",
  StyleBox["Widget[\"Panel\"]", "Program"],
  " and not ",
  StyleBox["Widget[\"Frame\"]", "Program"],
  " because using ",
  StyleBox["Widget[\"Frame\"]", "Program"],
  " forces this definition to only be deployable as its own standalone \
window."
}], "Text",
  CellTags->"Panel"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ref", " ", "=", " ", 
      RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
        RowBox[{
          StyleBox["Widget",
            "Program"], "[", 
          RowBox[{"\"\<Panel\>\"", ",", 
            RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
                RowBox[{
                  StyleBox[
                    RowBox[{
                      StyleBox["Widget",
                        "Program"], "Group"}]], "[", 
                  RowBox[{
                    RowBox[{"{", " ", "\[IndentingNewLine]", 
                      RowBox[{
                        StyleBox["Widget",
                          "Program"], "[", 
                        RowBox[{"\"\<Panel\>\"", ",", " ", 
                          RowBox[{
                            StyleBox[
                              RowBox[{
                                StyleBox["Widget",
                                  "Program"], "Layout"}]], 
                            "\[Rule]", \({"\<Stretching\>" \[Rule] {Maximize, \
\ Maximize}\ }\)}]}], "]"}], "\[IndentingNewLine]", " ", "}"}], ",", " ", 
                    RowBox[{
                      StyleBox[
                        RowBox[{
                          StyleBox["Widget",
                            "Program"], "Layout"}]], 
                      "\[Rule]", \({\ "\<Border\>" -> "\<Content\>"\ }\)}]}], 
                  "]"}], ",", "\[IndentingNewLine]", 
                RowBox[{"{", "\[IndentingNewLine]", 
                  RowBox[{
                    RowBox[{
                      StyleBox[
                        RowBox[{
                          StyleBox["Widget",
                            "Program"], "Fill"}]], "[", "]"}], ",", 
                    "\[IndentingNewLine]", 
                    RowBox[{
                      StyleBox["Widget",
                        "Program"], 
                      "[", \("\<Button\>", {"\<text\>" \[Rule] "\<OK\>"}\), 
                      "]"}], ",", "\[IndentingNewLine]", 
                    RowBox[{
                      StyleBox["Widget",
                        "Program"], 
                      "[", \("\<Button\>", {"\<text\>" \[Rule] \
"\<Cancel\>"}\), "]"}]}], "\[IndentingNewLine]", "}"}]}], 
              "\[IndentingNewLine]", "}"}]}], "]"}], " ", 
        "\[IndentingNewLine]", "]"}]}]], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Panel"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject248415137038337, 
        JLink`Objects`JavaObject186406714474497]]], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Panel"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref]\  // Show\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"Panel"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002g0000W2000`400?l0
0000o`00003o]`1VIWh0000306IVOP3ko?d0nocm0;<0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0;80Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
/@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS`0h=oS
00D0hN3T0>KUj03/jnh0l?3b0?;bm00C0??cm100n?Oh0P3clo@01@3cloD0
m?Ce0?GemP3dloD0iNCX00<0h=oS00D0hN3T0>KUj03/jnh0l?3b0?;bm00L
0??cm1T0n?Oh0P3clo@0203cloD0m?Ce0?GemP3dloD0iNCX06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS`0h=oS00@0g]cO0>CRh01k
Ujd09EN59`00?7@0100GCGh0Jh^V0?;akP3blO<30>3Oh`040=kLg`3Th^00
NiN]02EGQCT003ad00L05den06^;YP3blNh0l_7c06IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWhl0>3Oh`040=[Hf@1VQJ409df504em
`BP0JH;^00<09df506Z:Y03_ko400`3Pgn<0103Jf=T0IXFQ04YaT`2b_L<i
0<K5e`070<36a@18KY00JXZT0>o_l@1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn?03Pgn<00`3HeMH05den08V]i00Z08V]i00301M=
OP3[j^d0h=oS0080h=oS00<0f=GF01M=OP2oalX0>`36aML01P2f_Kd05den
0>_Zk@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhl0>3O
h`040=WEe@00?7@0RJgT0?ooobL0cLcO00@0oooo08V]i000?7@0j>OZ0`3P
gn<00`3IeMD003ad0?ooo`0k0<g<g`060?ooo`00?7@0j>OZ06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS`0h=oS00@0fMGE000lM02;
[N@0oooo9`3BdN@0103oool0RjoU000lM03Wi^T30>3Oh`030=WEe@00?7@0
oooo03/0d]7T00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn?03Pgn<0103IeMD003ad08j_iP3ooolW0=KGi`04
0?ooo`2=[nD003ad0>OVj@<0h=oS00<0fMGE000lM03oool0>`3FenL01P3o
ool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWhl0>3Oh`040=WEe@00?7@0TK7W0?ooo`h0fM[W0`0000030=WJi`030000
003If^L0fM[W0080fM[W00<000000=WJi`3If^L02`3If^L0103oool0TK7V
000lM03Wi^T30>3Oh`030=WEe@00?7@0oooo00l0fM[W0`0000030=WJi`80
000000@0fM[W0000003If^L000000`3If^L00`000000fM[W0=WJi`030000
00<0fM[W0`0000020=WJi`030000003If^L0fM[W00`0fM[W00H0oooo000l
M03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn?03P
gn<0103IeMD003ad09Bdj03oool=0=WJi`050000003If^L0fM[W0=WJi`00
00000P3If^L01@000000fM[W0=WJi`3If^L0000000h0fM[W00@0oooo09Fd
j000?7@0inKY0`3Pgn<00`3IeMD003ad0?ooo`0>0=WJi`070000003If^L0
fM[W0=WJi`000000fM[W000000020=WJi`80000000<0fM[W0000003If^L0
0P3If^L00`000000fM[W000000030=WJi`030000003If^L0000000<0fM[W
00<000000=WJi`0000003P3If^L01P3oool003ad0>OVj@1VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWhl0>3Oh`040=WEe@00?7@0V;SZ
0?ooo``0g]o/00<000000=kOk03Ngn`00`3Ngn`00`000000g]o/00000003
0=kOk0030000003Ngn`0g]o/00`0g]o/00@0oooo09Rhj@00?7@0inKY0`3P
gn<00`3IeMD003ad0?ooo`0=0=kOk0030000003Ngn`0g]o/00@0g]o/00L0
00000=kOk03Ngn`0g]o/0000003Ngn`0000000<0g]o/00<000000=kOk000
00001@3Ngn`00`000000g]o/0=kOk0030=kOk0030000003Ngn`0g]o/00`0
g]o/00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn?03Pgn<0103IeMD003ad09bkjP3oool<0>?Ul0030000003S
iO00hnG`00<0hnG`00H000000>?Ul000000000000>?Ul000000?0>?Ul004
0?ooo`2L^n/003ad0>OVj@<0h=oS00<0fMGE000lM03oool03@3SiO000`00
0000hnG`0>?Ul0050>?Ul0@0000000<0hnG`0000003SiO000P3SiO000`00
0000hnG`000000050>?Ul0D0000000<0hnG`0000003SiO003@3SiO001P3o
ool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWhl0>3Oh`040=WEe@00?7@0X;k/0?ooo``0jN_e00<000000>W[m@3YjoD0
0`3YjoD010000000jN_e0000003YjoD2000000l0jN_e00@0oooo0:6nk000
?7@0inKY0`3Pgn<00`3IeMD003ad0?ooo`0=0>W[m@030000003YjoD0jN_e
00@0jN_e00H000000>W[m@3YjoD0jN_e0000003YjoD200000080jN_e00<0
00000>W[m@0000000`3YjoD00`000000jN_e000000030>W[m@030000003Y
joD0000000h0jN_e00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn?03Pgn<0103IeMD003ad0:G1k@3oool<0?3a
o0030000003`lO`0l?7l00<0l?7l00<000000?3ao00000000P3`lO`00`00
0000l?7l0?3ao00=0?3ao0040?ooo`2U`^h003ad0>OVj@<0h=oS00<0fMGE
000lM03oool03@3`lO`00`000000l?7l0?3ao0050?3ao0<000000P3`lO`0
10000000l?7l0000000000030?3ao0<000000`3`lO`300000080l?7l00<0
00000?3ao03`lO`0303`lO`01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWhl0>3Oh`040=WEe@00?7@0ZLG_0?oo
o`d0m?Gm00D000000?Ceo@3dmOd0m?Gm000000020?Ceo@050000003dmOd0
m?Gm0?Ceo@0000003P3dmOd0103oool0ZLG_000lM03Wi^T30>3Oh`030=WE
e@00?7@0oooo00h0m?Gm00D000000?Ceo@3dmOd0m?Gm0000000I0?Ceo@03
0000003dmOd0m?Gm00`0m?Gm00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn?03Pgn<0103IeMD003ad0:g8l03o
ool>0?Kgo@<000000`3fmod00`000000m_Om0?Kgo@020?Kgo@030000003f
mod0m_Om00/0m_Om00@0oooo0:c7l000?7@0inKY0`3Pgn<00`3IeMD003ad
0?ooo`0?0?Kgo@<000006P3fmod00`000000m_Om0?Kgo@0<0?Kgo@060?oo
o`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OS`0h=oS00@0fMGE000lM02abo80oooo9`3ho?d0103oool0/Lcb000lM03W
i^T30>3Oh`030=WEe@00?7@0oooo03/0n?cm00H0oooo000lM03Wi^T0IVIn
0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn?03Pgn<0103IeMD0
03ad0;C=l`3ooolW0?gmo@040?ooo`2ec_<003ad0>OVj@<0h=oS00<0fMGE
000lM03oool0>`3moOd01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWhl0>3Oh`040=WEe@00?7@0]m3d0?ooobL0
oOgm00@0oooo0;S@m@00?7@0i^KY0`3Pgn<00`3IeMD003ad0?ooo`0k0?gm
o@060?ooo`00?7@0i^KY06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOS`0h=oS00@0f=CD000lM02jdoD0oooo9`3moOd0103oool0^]?f
000lM03UiNP30>3Oh`030=SDe000?7@0oooo03/0oOgm00H0oooo000lM03U
iNP0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn?03Pgn<0
0`3IeMD09EN50;cDmP0Z0;cDmP0302EGQ@3QhN@0h=oS0080h=oS00<0fMGE
02EGQ@2oc]`0>`3oool01P2oc]/09EN50>7Qi01VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWhl0>3Oh`030=WEe@1iU:T09df502T0c^Oo
00<09df507VEZ`3OgN000`3Pgn<0103IeMD0NIBY05EmXP30cmdi0?ooo`07
0=GOj01EOJ80NIF[0=oMh01VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn?03Pgn<0103JemT0gmcH07VDZ@0UEhDW000lM00401M=OP1V
QZ40h=kJ0=cKg@<0h=oS00@0f]OI0=oLf01iU:T09EN5>@00?7@01`0GCGh0
IXJQ0>3NfP3Lfmd0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOS`0h=oS00<0gmgP0=[Gf@3He=@05@3Gdm@@0=?>c0<0em?D00@0f=CD
0=WEe@3JemT0gmgP0`3Pgn<00`3OgN00f]OI0=SDe00N0=OCe1T0dlk<0`3G
dm@01`3He=@0fMGE0=[Gf@3OgN00IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOZl0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOZl0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOZl0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOZl0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOZl0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOP80h=oSZ`3oool20>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWh20>3OhjX0W9bN00H0oooo0>3Oh`3P
gn<0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo
0>3Oh`2V0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3O
h`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`2V0>3Oh`0709bLWP3o
ool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`060>3Oh`<000000`3Pgn<300000080
h=oS00H000000>3Oh`3Pgn<0h=oS0000003Pgn<200000080h=oS0`000002
0>3Oh`060000003Pgn<0h=oS0>3Oh`000000h=oS0P00001n0>3Oh`0709bL
WP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn0P3Pgn<00`2LW9h0oooo0>3Oh`050>3Oh`070000003Pgn<0h=oS
0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<0
00000>3Oh`0000000P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`00
00000`3Pgn<00`000000h=oS0000001o0>3Oh`0709bLWP3oool0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<0
0`2LW9h0oooo0>3Oh`040>3Oh`030000003Pgn<0h=oS00@0h=oS00L00000
0>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`000000
0P3Pgn<00`000000h=oS0>3Oh`030>3Oh`070000003Pgn<0h=oS0>3Oh`00
0000h=oS0000001o0>3Oh`0709bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<00`2LW9h0oooo0?oo
o`030?ooo`030>3Oh`000000h=oS00D0h=oS00L000000>3Oh`3Pgn<0h=oS
0000003Pgn<0000000<0h=oS00<000000>3Oh`0000000P3Pgn<500000003
0>3Oh`000000h=oS0080h=oS00<000000>3Oh`0000000`3Pgn=l0?ooo`07
09bLWP3oool0h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn0P3Pgn<609bLWP030>3Oh`000000h=oS00D0h=oS00H00000
0>3Oh`3Pgn<0h=oS0000003Pgn<200000080h=oS00<000000>3Oh`000000
0P3Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`8000000P3Pgn<00`00
0000h=oS000000030>3Ohgd0W9bN00H0oooo0>3Oh`3Pgn<0IVIn0:RY^`3k
o?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn2@3Pgn<00`000000h=oS0>3O
h`050>3Oh`<000000P3Pgn<01@000000h=oS000000000000h=oS00<00000
0P3Pgn<300000080h=oS00D000000>3Oh`00000000000>3Oh`0300000880
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPX0
h=oS00D000000>3Oh`3Pgn<0h=oS0000000=0>3Oh`030000003Pgn<0h=oS
00`0h=oS00<000000>3Oh`3Pgn<0P@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn2`3Pgn<3000000h0h=oS00<000000>3O
h`3Pgn<0303Pgn<00`000000h=oS0>3Oh`210>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWj_0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWj_0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWj_0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWj_0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWj_0>3Oh`0306IVOP2XZK/0nocm
0040IVIn00000`1VIWh0moOi09RHY`2a07MgTP40V9RW0@3gmoT106IVOP00
00<0IVIn0?Ogn@2l_Ld0/P2l_Ld10?Ogn@40IVIn00000`1VIWh0moOi0>CS
h`2b0>CSh`40moOi0@1VIWh0000306IVOP3`lO@0oooo06/0oooo00<0i>?S
09bT^@1[MHl00`1[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT^@3T
hn<0oooo0?ooo`3Thn<0W:Bi101[MHl0101/MY00JgF?06afT01/MY0906]e
S`0609bT^@3Thn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W>T@0YSU40:Lj
A02W>T@90:HiA00309bT^@3/j^X0oooo00<0oooo0@3`lO@106IVOP0001H0
IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0o?cm0?clo03l
nod0o?cl0?cko03lo?`0nocl0?clo03ko?d0o?_l0?clo@3knod0nocl0P3l
o?`0103lo?d0o?cl0?_ko@3lo?dX0?cko2P0nocl0P3ko?d00`2LY;T0JgF?
08F9/00@08F9/00606]eS`2LY;T0nocm0?_lo@2LY;T0JgF?4@25RK001P1[
MHl0W:Bi0?_lo03kno`0W:Bi0:HiA140ZSaE00L0YSU409bT^@3ko?`0o?cl
0?cko@3ko?d0h^7R0040IVIn0000101VIWh0h>3Q0?Kgn@3gmoT20?Kgn@0;
0?Kgn03gmoT0moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT0
0P3gmoT0103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0moOi02L0
moOi:03fmoT20?Ogn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3g
moT0moOi06]eS`25RK0A09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE
0<9BF`36E5X=0<IEG0090<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03g
moT0h>3Q0040IVIn00001P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm1000000
00H0lO7d0?3bm@3alO@0lO;d0?3bm03alOA@0?3am@80l?7d00<0JgF?0;:e
d02WZ<80402WZ<801P2b]M00JgF?0?3am03`lO@0JgF?0;:ed140YjS200D0
/[G@06]eS`3`lOD0lO;d0:HiA0020<9BF`030<]DF@3=FEh0cEUN00/0cEUN
00@0beAI0<9BF`32DU/0YSU40P3`lO@00`3alO@0l?;d0=kMh@0106IVOP00
00L0IVIn0=cKh03Zjo00j^_`0>[/l03Yjnl000000080inOW0P3Ng]h20>OW
i`030>NmQ03WinL0inOW00<0inOW0P3_knl010000000j^_`0>[[l03Zjnl2
0>[[l0030>[[k`3Zjo00j^_`02H0j^_`:03Zk?020>[[k`0406]eS`2f^M40
[Jk60:f^aPP0oooo00<0[Jk60:b^aP2][/H00`2][/H00`2/[/H0][WA06]e
S`020>[[k`0406]eS`2f^M40[Jk60:f^aP`0oooo0P2][/H00`2/[/H0][WA
06]eS`020>[[l0050:HiA03=FEh0beAI0<eFF`3>FEl02`3@FUl01`3>FEl0
cEIK0<]DF@3=FEh0YSU40>[[k`3Zjo000P3Zjnl10=cKh040IVIn0000101V
IWh0fMWO0>?UjP3Si>X20>?Uj`050000002<S8`0g]kN0>OWi`3Ng]h00P3W
inL00`36H`00inOW0>OWi`020>OWi`070>o_i`3_knl0kno_0000003Si>X0
hnC[0>?UjP020>?TjP030>?Tj`3SiN/0hnG[02H0hnG[:03Si>X20>?UjP05
06]eS`2l_]@0/[;:0;:bbP3oool01P1^KHl00`0U9CH0/[;:0;:bbP050;:b
bP060;bne01[MHl0hnGZ0>?UjP1[MHl0_;kD0P2b//X00`3oool09BDf02DU
=P0902DU=P<0/[;:00D0_;kD06]eS`3Si>/0hnC[0:HiA0020<eIGP040=1K
H03DG5l0oooo0?ooo`L0e5aO0P3oool02P3DG5l0d5]P0<eIGP3=FEh0YSU4
0>?TjP3SiNX0hnCZ0>?Uj`3IfMl106IVOP0000<0IVIn0=OHgP3Lg^H00`3L
g^H01@000000inOW0>OWi`3WinL0imK>0080inOW00D0cW/00>nD403WinL0
imk60>n<40030>o_k`070000003Lg^H0g=kU0=cNi@3Lg^H0g=kU0=cNiP1B
0=cNi@0506]eS`2o`MH0^;W>0;RicP3oool01P1^KHl00`0U9CH0^;W>0;Ri
cP050;RicP060;o1eP1[MHl0g=kU0=cNi@1[MHl0_l7F0P2h^Lh00`3oool0
9BDf0;RicP070;RicP030?ooo`0U9CH0^;W>0080^;W>00T0_l7F06]eS`3L
g^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C9B000`3oool50=IOH`<0oooo00D0
DbDP0=AMH@3AFUh0cEUN0:HiA0020=cNi@030=cNiP3Lg^D0emSN0040IVIn
0000101VIWh0eMKM0=GHh03Ff>420=GHh0090000002<S8`0inOW0>OWi`3W
]H@0eUX00=J4003ocP00cV<00080gV/000D0kkF<0>o_k`3_knl0kno_0000
00020=GHh@040=GGh03Ff>00e]SQ0=KGhBP0e]OP:03Ff>020=GHh@0506]e
S`33aMT0_;gA0;bmd@3oool01`0U9CH70;bmd@060<?5f@1[MHl0eMSQ0=GH
h@1[MHl0`lGI0P2l_M400`3oool09BDf0;bmd@070;bmd@030?ooo`0U9CH0
_;gA0080_;gA00D0`lGI06]eS`3Fen00eMOQ0:HiA0020=EMH0030=QPH@3I
HF80AQhJ00<0oooo0`3IHF830?ooo`0304HN6P3IHF80f61Q0080eEeP00H0
YSU40=KHh03Ef>40eMOP0=GHh@3Ee]d106IVOP0000L0IVIn0=;Dg@3?d]`0
d=;L0=3Bg@3@d]`0000000<0inOW00`0imk>0<I:003gcP00kjd00>ne003>
J`00aUX00<I[003NS4X0ijD00>oWcP0000030=3Bg0030<oBg03@d]`0cm;L
02P0d=;L:03?d]d20=3Bg00306]eS`38bM/0`lCF0100`lCF00H0b<WK06]e
S`3@d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U9CH0`lCF00L0`lCF00<0
oooo02DU=P33a=H00P33a=H01`38bM/0JgF?0<oBg03?d]`0YSU40=MOG`3I
HF800`3LIFD01@167QX0oooo0?ooo`3oool0g6EU00<0oooo00P0AQhJ0=aU
I@3LIFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?d]`10=;Dg@40IVIn
0000701VIWh0d=;K0<_=f03:cMT0blkH0<[=f0000000ilJ]0>O6S03gcQP0
kkd00?O6003_[@00ijd00>NU003FS000cV/00>O6003oeP00knoW0>o_k`00
0000blgH0<_=f@3:cMT0blkH0<[=f03;cMPX0<_=fBP0blkI0P3;cMP00`1[
MHl0blcN0<S:f@080<S:f@030<S9f@38b]T0b<[I00<0b<[I00@0b<WI0<S:
f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN0<S:f@38b]T0oooo02DU=PD0b<[I
0140b<WI0<S:f@38b]T0oooo02DU=P38b]T0b<WI0<S:f@3;c=h0JgF?0<_>
f03:cMP0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN6P3oool0oooo
00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO0:HiA03:c]P0
b/kI0P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0030<G8e0060000
0036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD00020?O6
0080moOg00@000000<G8e035am@0aLOD0`35amDX0<C7eBP0a<SD0P34am@0
0`1[MHl0d=7P0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P
0P3;bm`00`3oool09BDf0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080bl_L
00L0d=7P06]eS`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ0?oo
o`3oool0oooo04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD0@35
amD10<o?fP40IVIn0000101VIWh0c<kJ0<;4dP31a=420<74dP060000003W
inL0inOW0>OWi`3FQ000kkD00P3WY@00203FQ000cV/00>N]003g]@00mkd0
0>o_k`3gmoL000000`31a=800`32a=40`LCB0<74dP0X0<74dBP0`LCB0P32
a=800`1[MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0
dm?R0P3?d=d00`3oool09BDf0<o@g@070<o@g@030?ooo`0U9CH0cm3M0080
cm3M00L0dm?R06]eS`32a=80`LCA0:HiA03KI6@0hFUU00D0h6aY1@3oool5
0>1/J@080>5YI@3KI6@0YSU40<74dP32a=40`LCA0<74dP3<c]X106IVOP00
00@0IVIn0<[<f02n`<l0_L3?0P2n`<h01@000000W9bL0>OWi`3Wg]H0eX`0
0080gY@000@0eW/00<IS002m@P00kjD00P3g[@00203g]@00oli:0000002n
`<h0_/3?0;k0cP2n`<l0_L3>:@2n`<hX0;g0cP80_/3>00<0JgF?0=KFi03C
dn00403Cdn001P3Fe^@0JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P00<0oooo
02DU=P3oool0203oool02`0U9CH0dm?P0=?Ch03Cdn00e]KT06]eS`2n`<l0
_/3>0:HiA03PIVD0hFYZ00@0hfa/0`3oool010167QX0oooo0?ooo`3oool4
0>=/K0040>5ZJP3PIVD0YSU40;g0c`80_/3?0@2n`<h10<[<f040IVIn0000
1`1VIWh0bL[H0;Jhb02i_</0^[c;0;Zlc00000000P3_knl04`3FW000eX`0
0=jD003FQ000kjD00=j<002mFP00eW<00>nL003gknL0moOg0?ooo`000000
^Kc<0;Zkc02i_</0^[c;0;Vlc02i_</0:02i_<`X0;Zlc080^[c;00<0JgF?
0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?0;Zlb`2j_</0JgF?0=SHi@80dm?Q
00<0oooo06i]S`1^KHl0201^KHl03P0U9CH0dm?Q0=?Ch@3Cdn40f=SU06]e
S`2j_</0^[c<0:HiA03PJFP0hFe/0>AaK@3TLFl0i71^0`3oool00`167QX0
i71^04HN6P030?ooo`80i71^00T0i75]0>5]K03PJFP0YSU40;Zlc02j^l`0
^Kc;0;Jhb039b]P00@1VIWh0000906IVOP37bML0];K70;Jhb02f^<T0][W9
00000024Q8@0inON0080kno_00L0aV/00?O6003_]@00ki`00=j<003>J`00
ii`000<0moOg00D000000;Jib@2g^<T0][W90;Nib@020;JhbBP0]kS9:02f
^<T20;Nhb@0406]eS`3Fe^@0f=SU0=SHiP<0f=SU1@3Hf>H30=SHi@80f=SV
0P3Hf>D02@3Fe^@0JgF?0;Nhb@2g^<T0JgF?0=KFi03Hf>D0f=SV0?ooo`0:
06i]S`0=02DU=P3Hf>H0f=SU0=SHi@3Fe^@0JgF?0;Nhb@2g^LT0YSU40>A^
K@3TM6l0ig5_0>AdK`030?ooo`0504HN6P3TM6l0i7A_0>AdK`167QX00`3o
ool02P3TM6l0ig5_0>AdK`3TKVd0YSU40;Jib@2f^<T0][W90;Bfa`37bML1
06IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L00`000000kno_0>o_k`020>o_
k`0;0>N]003gaPP0ijD00>ND003WS000knOF0=jD>@3_e[D0ooOg0?ooo`00
0000F02d]/L01@1[MHl0eMGS0=cKi`3LfnL0gM_W00h0g=_W00H0eMGS06]e
S`2d]/L0];K706]eS`3EeN<20=cKi`030=gKi`0U9CH09BDf00T09BDf0`3L
fnL02@3EeN<0JgF?0;Bfa`2d]/L0YSU40>McK`3WMG80jWIc0>YhMP020?oo
o`0304HN6P3YOWP0jGih00<0jGih00P0AQhJ0?ooo`3oool0jWQf0>YfL`3W
MG80ig=_0:HiA0@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2d]/L00`2d
]/L01P000000S8b<0>o_k`3_knl0ilik0>o_k`80moOg00P0ii@00?OWcP3g
moL0moOg0>oWeP3gmoL0oooo000005P0];K700<0JgF?0=GDh`3PgnX0403P
gnX01P3Ee><0JgF?0;Bfa`2d]/L0JgF?0=GDha40h=oZ00T0eMCS06]eS`2d
]/L0];K70:HiA03ZNG<0jGah0>n1NP3bRH400P167QX01`3[V8/0jY^<0>fG
RP3[V8/0jY^<0>fGRP3[V8/00P167QX01@3bRH40kh5j0>UlN03ZNG<0YSU4
00@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2a/lP00`2a/lP01P000000
kno_0>o_k`3_knl0moO_0>o_k`80moOg00<0mnO60?Ogm`3oool00`3gmoL0
0`3oool000000;6cb01G0;6cb00306]eS`3]jo<0jNSa0100jNSa00H0kN_c
06]eS`2a/lP0/K?806]eS`3]jo<A0>WXl@0I0>g[l`1[MHl0/K?80;6cb02V
>D@0lH1e0?24O03eS8@0mif>0?:[UP3a/Y/0kKBK0>beW03a/Y/0kKBK0>be
W03a/Y/0kKBK0>beW03bZiH0mif>0?F<Q03`Q7`0lH1e0:HiA0040;6cb040
a/SG0@1VIWh0000306IVOP36b=L0^;O?00<0[jk700D000000:f][@3gmnl0
moOg0>o_k`060?Ogm`80ooOg0P3oool00`000000[jk70:n^a`1F0:n^a`03
06]eS`3BdN<0l_7g0100l_7g00H0d]7S06]eS`2_[/L0[jk706]eS`3BdN<A
0?;am`060=;Ah`1[MHl0[jk70:n^a`2V>D@0m8Ym0P3eT8D=0?:hWP80mI25
00<0m8Ym0:HiA02_[/L00P2_[/L10;Rgc`40a/SG0@1VIWh0000306IVOP30
`M40alOD06/0[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M
06]eS`24S:820:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;
g@1[MHl0Q8bR0P2/Zl@01`2AV:X0YSU40?nOS@3n_j@0n]bg0?[[]`3jjKH0
0P3ijKH0103jjKH0nNVf0?WY]P3jjKH20?WY]P060?[[]`3jg;L0o[nT0?nO
S@2V>D@0TIRZ0`2/Zl@10<O7e040`<7A0@1VIWh0000406IVOP30`M40d];O
0;FdbF/0Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P02
0:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh0
0`24S:80YSU40:HiA00?0:HiA00708B<XP2TXkh0Y:>n0:BS_P2e]<T0d];O
0<31d@0106IVOP0000H0IVIn0:RW_`3Vi^d0d];P0;blc`2a/<B[0:RW_`05
0;6`a02l_<l0d];P0>KVk@2XYkl00@1VIWh0000705QGJ027Qi/0emSR0?cl
o03ThnP0d=3P0<[:fP2Y0;blc`060<[:fP3@d>00i>?X0?clo03Gf>80QhNK
0@1HEfP0000805QGJ01VIWh0UIB[0=OHhP3lo?`0l_7c0>c[kP3Qh^^W0=OH
hP070>7Rj`3/jnh0l_7c0?clo03Gf>80UIB[06IVOP0105QGJ0000P1HEfP0
0`1VIWh0UIB[0=7AgP020?clo:T0oooo0P3lo?`00`3AdMh0UIB[06IVOP02
05QGJ0000`1HEfP206IVOP0308R7W@2EU:/0Z:No0:P0Z:No00@0UIB[08R7
W@1VIWh0IVIn0`1HEfP000D0F5MX[@1VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  Evaluatable->False,
  ImageSize->{183, 156},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Panel"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"Panel"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"Button\"]", "ObjectName",
  CellTags->"Button"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"text\" \[Rule] \"text label\"\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"enabled\" \[Rule] True\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"icon\" \[Rule] Widget[\"Icon\", \[Ellipsis]]", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"Button"],

Cell[TextData[{
  StyleBox["Events", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"action\" - ", "Program"],
  StyleBox["triggered when the button is clicked", "Text"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"Button"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"Button"],

Cell[BoxData[
    \(\(ref\  = 
        GUIRun[\[IndentingNewLine]Widget["\<Button\>", {"\<text\>"\  \[Rule] \
\ "\<Submit\>"}]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Button"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Button"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000>B000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3Qh>@0
i^GX0>c[kP3`l?80l_;d03D0lo?d<P3hmoP20??cm0080??cm@3dm?D0mOGf
0?Ccm@3Ui>P0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn
0=kLg`3Th^00NiN]02EGQF/003ad00L05den06^;YP3blNh0l_7c06IVOP2X
ZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0f]SI06J5X@0WCHD0
CGg1K01YP^h01P0WCHD0JXZT0>o_l@1VIWh0Z:Vk0?_lo@40IVIn00001P1V
IWh0nocm0:RY^`1VIWh0f=GF01M=OVl0RJgT00D05den0>_Zk@1VIWh0Z:Vk
0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0RJgT0?oo
of/0cLcO00L0oooo08V]i000?7@0j>OZ06IVOP2XZK/0nocm0040IVIn0000
201VIWh0nocm0:RY^`1VIWh0fMGE000lM02;[N@0ooooJ`3BdN@01`3oool0
RjoU000lM03Wi^T0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk
06IVOP3IeMD003ad08j_iP3ooom[0=KGi`070?ooo`2=[nD003ad0>OVj@1V
IWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0
TK7W0?ooobH0fM[W100000030=WJi`80000000D0fM[W0000003If^L00000
0=WJi`0200000080fM[W00@000000=WJi`3If^L000000P3If^L010000000
fM[W0000003If^L2000002L0fM[W00L0oooo096aiP00?7@0inKY06IVOP2X
ZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM02D]>P0
oooo9@3If^L00`000000fM[W0=WJi`020=WJi`030000003If^L000000080
fM[W0P0000000`3If^L00000000000020=WJi`030000003If^L000000080
fM[W00P000000=WJi`3If^L000000=WJi`000000fM[W000002P0fM[W00L0
oooo09Fdj000?7@0inKY06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm
0:RY^`1VIWh0fMGE000lM02H^>X0oooo:P3Ngn`00`000000g]o/00000003
0=kOk0030000003Ngn`0000000<0g]o/00<000000=kOk00000000P3Ngn`0
20000000g]o/0=kOk0000000g]o/0000003Ngn`00000:03Ngn`01`3oool0
V;SY000lM03Wi^T0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk
06IVOP3IeMD003ad09bkjP3ooolX0>?Ul08000000P3SiO001`000000hnG`
0>?Ul03SiO0000000>?Ul00000000`3SiO000`000000hnG`000000020>?U
l0080000003SiO00hnG`0000003SiO0000000>?Ul000000X0>?Ul0070?oo
o`2L^n/003ad0>OVj@1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2X
ZK/0IVIn0=WEe@00?7@0X;k/0?ooobH0jN_e0P0000040>W[m@060000003Y
joD0jN_e0>W[m@000000jN_e0P0000020>W[m@050000003YjoD000000000
003YjoD00P0000001P3YjoD000000>W[m@000000jN_e000002P0jN_e00L0
oooo0:6nk000?7@0inKY06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm
0:RY^`1VIWh0fMGE000lM02U`Nd0oooo9@3`lO`00`000000l?7l0?3ao004
0?3ao0080000003`lO`0l?7l0?3ao0000000l?7l0000003`lO`200000080
l?7l00<000000?3ao00000000P3`lO`00`000000l?7l0?3ao004000002L0
l?7l00L0oooo0:G2kP00?7@0inKY06IVOP2XZK/0nocm0040IVIn0000201V
IWh0nocm0:RY^`1VIWh0fMGE000lM02YaNl0oooo9@3dmOd00`000000m?Gm
0?Ceo@020?Ceo@030000003dmOd0m?Gm00D0m?Gm00<000000?Ceo@3dmOd0
3@3dmOd00`000000m?Gm0?Ceo@0V0?Ceo@070?ooo`2YaNl003ad0>OVj@1V
IWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0
[LS`0?ooobH0m_Om100000080?Kgo@030000003fmod0m_Om00/0m_Om00<0
00000?Kgo@000000:03fmod01`3oool0[<O`000lM03Wi^T0IVIn0:RY^`3k
o?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0;7;lP3ooom[
0?Slo@070?ooo`2ac?8003ad0>OVj@1VIWh0Z:Vk0?_lo@0106IVOP0000P0
IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0]<gc0?ooof/0oOgm00L0oooo0;G>
l`00?7@0inKY06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1V
IWh0fMGE000lM02gd?@0ooooJ`3moOd01`3oool0^=3e000lM03Vi^T0IVIn
0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3He=@003ad0;[C
m@3ooom[0?gmo@070?ooo`2jdoH003ad0>GUj01VIWh0Z:Vk0?_lo@0106IV
OP0000H0IVIn0?_lo@2XZK/0IVIn0=WEe@0UEhE_0;cDmP0502EGQ@3QhN@0
IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD0NIBY
02M=Q@1]0<kWo`0602M=Q@1iUJ/0gmgP06IVOP2XZK/0nocm0@1VIWh00008
06IVOP3ko?d0Z:Vk06IVOP3JemT0gmcH07VDZ@0UEhE[000lM00701M=OP1V
QZ40h=kJ0=cKg@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0
IVIn0=oMh03JemT0f=CD03L0em?D<P3Cc/`30=OCe0070=SDe03IeMD0f]OI
0=oMh01VIWh0Z:Vk0?_lo@0106IVOP0000<0IVIn0?Ogn@2HV:L0M@1gMi81
09RHY`40moOi0@1VIWh0000306IVOP3gmoT0_;g=07H0_;g=0@3gmoT106IV
OP0000<0IVIn0?Ogn@3Thn<0MP3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d
0?ooo`0_0?ooo`030>CSh`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00
K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@
06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0
YSU400@0YcY40:HiA02W>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?oo
o`40l?7d0@1VIWh0000F06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3k
o?d0nocl0?clo@3lo?`0o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?ck
o03lo?d0no_m0?_lo080o?cl00@0o?cm0?clo03knod0o?cm503lno`20?_l
o00309bT^@1[MHl0QHV`0100QHV`00H0JgF?09bT^@3ko?d0nocm09bT^@1[
MHlA08F9/00606]eS`2LY;T0nocl0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0
W:Bi0?_lo03lo?`0o?_m0?_lo@3RhN800@1VIWh0000406IVOP3Ph>40m_Oi
0?Ogn@80m_Oi00/0m_Oh0?Ogn@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03f
moT0moOi0?Kgn@020?Ogn@040?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh
0?Ogn@3gmoT04`3gmoT20?Kgn@0306]eS`25RK00W9jn0100W9jn00H0QHV`
06]eS`3gmoT0moOi06]eS`25RK0A09bN_P0808F9/01[MHl0m_Oh0?Ogn02V
>D@0ZSaE0<9BF`36E5X=0<IEG0090<IDFP32DU/0ZSaE0:HiA03gmoP0moOi
0?Ogn03gmoT0h>3Q0040IVIn00001P1VIWh0g]gQ0?7am03alO@0l?7d0?3b
m100000000H0lO7d0?3bm@3alO@0lO;d0?3bm03alO@F0?3am@0306]eS`2b
]M00YjS20100YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P05
0;:ed01[MHl0l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eI
GP040<]DF@32DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0
000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3W
inL00`3W_H@0inOW0>OWi`030>OWi`80kno_00@000000>[[l03Zjo00j^__
0P3Zjo000`3Zjnl0j^_`0>[[l00B0>[[l080j^c`00@0JgF?0;Jid@2][/H0
[Jk6203oool00`2][/H0[:k60:f^aP030:f^aP030:b^aP2f^M40JgF?0080
j^__00@0JgF?0;Jid@2][/H0[Jk6303oool20:f^aP030:b^aP2f^M40JgF?
0080j^_`00D0YSU40<eIGP3;E5T0cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0
beAI0<eIGP2V>D@0j^__0>[[l0020>[[k`40g=_P0@1VIWh0000406IVOP3I
fMl0hnGZ0>?TjP80hnG[00D0000008b<S03Ng]h0inOW0=kNgP020>OWi`03
0<IS003WinL0inOW0080inOW00L0knoW0>o_k`3_knl000000>?TjP3Si>/0
hnGZ0080hnCZ00<0hnC[0>?Uj`3SiN/04P3SiN/20>?TjP0506]eS`2l_]@0
/[;:0;:bbP3oool01P1^KHl00`0U9CH0/[;:0;:bbP050;:bbP060;bne01[
MHl0hnGZ0>?UjP1[MHl0_;kD0P2b//X00`3oool09BDf02DU=P0902DU=P<0
/[;:00D0_;kD06]eS`3Si>/0hnC[0:HiA0020<eIGP040=1KH03DG5l0oooo
0?ooo`L0e5aO0P3oool02P3DG5l0d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0
hnCZ0>?Uj`3IfMl106IVOP0000<0IVIn0=OHgP3Lg^H00`3Lg^H01@000000
inOW0>OWi`3WinL0imK>0080inOW00D0cW/00>nD403WinL0imk60>n<4003
0>o_k`070000003Lg^H0g=kU0=cNi@3Lg^H0g=kU0=cNiP0F0=cNi@0506]e
S`2o`MH0^;W>0;RicP3oool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP06
0;o1eP1[MHl0g=kU0=cNi@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP07
0;RicP030?ooo`0U9CH0^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:Hi
A03=FEh0dEYN0=AMH@1C9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3A
FUh0cEUN0:HiA0020=cNi@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0
eMKM0=GHh03Ff>420=GHh0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4
003ocP00cV<00080gV/000D0kkF<0>o_k`3_knl0kno_000000020=GHh@04
0=GGh03Ff>00e]SQ0=KGhA@0e]OP0P3Ff>001@1[MHl0`lGI0;bmd@2l_M40
oooo00L09BDf1`2l_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA
00<0oooo02DU=P2l_M401`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5
f@1[MHl0e]OP0=GGh@2V>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0
fF5R0`3oool00`167QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GG
h03Ef>40eMKM0@1VIWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L0000
00030>OWi`0<0>ONcP36BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:
0>NU003_ilh000000`3@d]`00`3?d]`0d=;L0<oBg00D0=3Bg080cm;M00<0
JgF?0<S9f`33a=H04033a=H01P38bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80
`lCF00<0oooo02DU=P33a=H01`33a=H00`3oool09BDf0<?4eP020<?4eP07
0<S9f`1[MHl0cm;L0<oBg02V>D@0eemO0=UQHP030=aUI@0504HN6P3oool0
oooo0?ooo`3LIFD00`3oool020167QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V
>D@0d=;M0P3@d]`10<oBg040d]CM0@1VIWh0000L06IVOP3@d]/0blgH0<[=
f@3;c]P0b/gH0000003WaZd0ilJ<0?O>603__@00mlH00>n]003W[@00ijD0
0=J<003>J`00ilH00?oF003_knL0kno_0000003;cMP0blgI0<[=f@3;c]P0
b/gH0<_=f1@0blgI0P3;c]T00`1[MHl0blcN0<S:f@080<S:f@030<S9f@38
b]T0b<[I00<0b<[I00@0b<WI0<S:f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN
0<S:f@38b]T0oooo02DU=PD0b<[I0140b<WI0<S:f@38b]T0oooo02DU=P38
b]T0b<WI0<S:f@3;c=h0JgF?0<_>f03:cMP0YSU40=MOG`3KI6@0h6MU0>1V
I@020=iWI`0304HN6P3oool0oooo00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU
0>1WI@3KI6@0eemO0:HiA03:c]P0b/kI0P3;cMT10=3Bf`40IVIn00000`1V
IWh0cloJ0<G8e0030<G8e00600000036a/H0imkF0<ik003W[@00kkD00P3W
Y@000`3FU000cW<00=JD00020?O60080moOg00@000000<G8e035am@0aLOD
0`35amDD0<C7e@80a<SD00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?
0<C7e034am@0JgF?0=3Ah080bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3o
ool09BDf0<_;g0020<_;g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mU
I0050>1ZJ00504HN6P3oool0oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT
0:HiA034b=D20<C8e040aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80
`LCA0P31a=801P000000inOW0>OWi`3WinL0eX@00>ne0080ijD000P0eX@0
0<i[003W[@00mkD00?Nm003_knl0moOg000000<0`LCB00<0`/CA0<74dP31
a=805031a=420<74dP0306]eS`3Cdn80cm3M0100cm3M00H0dm?R06]eS`32
a=80`/CB06]eS`3Cdn820<o@g@030?ooo`0U9CH0cm3M00L0cm3M00<0oooo
02DU=P3?d=d00P3?d=d01`3Cdn80JgF?0<;4dP31a=40YSU40=]TI03QJFD0
1@3PK6T50?ooo`D0h6aY00P0hFUU0=]TI02V>D@0`LCB0<;4d@31a=40`LCB
0<c>fP40IVIn0000101VIWh0b/cH0;k0c`2m`<l20;k0cP050000002LW9`0
inOW0>ONeP3FS0000P3NU000103FN`00aV<00;e2003_Y@020?N]00080?Ne
003ocTX000000;k0cP2n`<l0_/3>0;k0c`2m`<hE0;k0cP80_L3>00<0JgF?
0=KFi03Cdn00403Cdn001P3Fe^@0JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P
00<0oooo02DU=P3oool0203oool02`0U9CH0dm?P0=?Ch03Cdn00e]KT06]e
S`2n`<l0_/3>0:HiA03PIVD0hFYZ00@0hfa/0`3oool010167QX0oooo0?oo
o`3oool40>=/K0040>5ZJP3PIVD0YSU40;g0c`80_/3?0@2n`<h10<[<f040
IVIn00001`1VIWh0bL[H0;Jhb02i_</0^[c;0;Zlc00000000P3_knl04`3F
W000eX`00=jD003FQ000kjD00=j<002mFP00eW<00>nL003gknL0moOg0?oo
o`000000^Kc<0;Zkc02i_</0^[c;0;Vlc02i_</0502i_<`20;Zlc00306]e
S`3Hf>D0dm?Q0100dm?Q00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?C
h@030?ooo`1^KHl0KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[
MHl0^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ
0>A`KP167QX00`3oool20>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<
0;Vlb`2f^<P0bL[H0040IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Ji
b@000000Q8B40>OWgP020>o_k`070<I[003gaP00kkD00>nL003NS000cV/0
0>NL00030?Ogm`050000002f^LT0]kS90;Jib@2g^LT00P2f^<TD0;Nhb@80
][S900@0JgF?0=KFi03Hf>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SH
i@090=KFi01[MHl0]kS90;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?
00d09BDf0=SHiP3Hf>D0f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>Ad
K`3WLFl0i7A_00<0oooo00D0AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:
0>AdK`3WLFl0i7A_0>A^K@2V>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn
00000`1VIWh0a/SG0;Bfa`030;Bfa`030000003_knl0kno_0080kno_00/0
ijd00?O6203WY@00ii@00>N<003_imH0gY@i0>oF]@3omoL0oooo0000000L
0;Bfa`0506]eS`3EeN<0g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bf
a`2d]/L0JgF?0=GEh`80g=_W00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`09
0=GEh`1[MHl0];K70;Bfa`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0
AQhJ0>UnN03YOWP00`3YOWP020167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3W
Lfl0YSU4102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`06
0000002<S8`0kno_0>o_k`3WcW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3g
moL0knOF0?Ogm`3oool00000702d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP06
0=GDh`1[MHl0];K70;Bfa`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d
]/L0YSU40>YiL`3YO7P0kh5j0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^H
R`3ZVh`0kIN:0>^HR`0204HN6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d
]/L10<K8e`40IVIn00000`1VIWh0a/SG0;6cb0030;6cb0060000003_knl0
kno_0>o_k`3gmnl0kno_0P3gmoL00`3gilH0moOg0?ooo`030?Ogm`030?oo
o`000000/K?801/0/K?800<0JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?
0;6cb02a/lP0JgF?0>g[la40jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03a
P7D0l8Al0?F<Q03gWHh0lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6b
V`3]]9/0k;FL0?:[UP3gWHh0mHb40?24O03aP7D0YSU400@0/K?80@36b=L1
06IVOP0000<0IVIn0<K8e`2h]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0
kno_00H0moOg0P3omoL20?ooo`030000002_[/L0[jk701X0[jk700<0JgF?
0=;Ah`3blOL0403blOL01P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g
00H0d]7S06]eS`2_[/L0[jk70:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3d
RWd0YSU40:n^a`020:n^a`40^;O?0@36b=L106IVOP0000<0IVIn0<31d@37
am@0;`2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?
08B<XP80[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]e
S`24S:820:b[a007096HZP2V>D@0oin=0?joY03jg;L0n^^g0?[Y]P020?WY
]P040?[Y]P3ijKH0nNVf0?[Y]P80nNVf00H0n^^g0?[L]`3n_j@0oin=0:Hi
A02AV:X30:b[a040alOD0@30`M4106IVOP0000@0IVIn0<31d@3Bd]l0]KC9
;`2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n
00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<
XP2V>D@0YSU400l0YSU400L0Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A
0040IVIn00001P1VIWh0Z:No0>KVk@3Bd^00_;c?0;6`a6l0Z:No00D0/K34
0;blc`3Bd^00i^K]0:RW_`0106IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CS
j03@d>00b/[J06d0_;c?00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QG
J00000P0F5MX06IVOP2EU:/0emSR0?clo03blO<0k>_^0>7Rjf/0emSR00L0
hN;[0>c[kP3blO<0o?cl0=OHhP2EU:/0IVIn0040F5MX000205QGJ00306IV
OP2EU:/0dM7N0080o?clK@3oool20?clo0030=7AgP2EU:/0IVIn0080F5MX
000305QGJ080IVIn00<0R8NM09FDZ`2XYkl0K02XYkl0102EU:/0R8NM06IV
OP1VIWh305QGJ0001@1HEfQa06IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  Evaluatable->False,
  ImageSize->{123, 57},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Button"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Button"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"Slider\"]", "ObjectName",
  CellTags->"Slider"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"value\" \[Rule] ", "Program"],
  StyleBox["integer\n", "Program",
    FontSlant->"Italic"],
  "\[FilledSmallSquare] ",
  StyleBox["\"minimum\" \[Rule] ", "Program"],
  StyleBox["integer\n", "Program",
    FontSlant->"Italic"],
  "\[FilledSmallSquare] ",
  StyleBox["\"maximum\" \[Rule] ", "Program"],
  StyleBox["integer", "Program",
    FontSlant->"Italic"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"Slider"],

Cell[TextData[{
  StyleBox["Events", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"change\" - ", "Program"],
  StyleBox["triggered when the slider position moves", "Text"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"Slider"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"Slider"],

Cell[BoxData[
    \(\(ref\  = 
        GUIRun[\[IndentingNewLine]Widget["\<Slider\>"]\[IndentingNewLine]];\)\
\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Slider"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"Slider"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003@0000>R000`400?l0
0000o`00003od01VIWh0000306IVOP3ko?d0nocm0<`0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0</0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
bP1VIWh10:RY^`40nocm0@1VIWh0003?06IVOP3ko?d0Z:Vk06IVOP1aKf@0
h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1a
Kf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3O
h`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT
0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0
LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03P
gn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_
I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS
075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0
h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1a
Kf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3O
h`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT
0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0
LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03P
gn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_
I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS
075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0
h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1a
Kf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS06IVOP2XZK/0nocm0040
IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT05l0h=oS00<0QiZV07f>V@1g
R980101gR9800`1hRI<0LX>=0>3Oh`1M0>3Oh`04075_I01VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWiO0>3Oh`0409nb_P1S[gH07Z/L
01bM6P<06iXJ00@06i/J01^J6P1=Qe/0LX>=GP3Pgn<00`1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_I01N0>3Oh`040:nob016
bT@08[hP01n_7@<07jhM00@07jdM01fQ6`0KVQX0N8VCG@3Pgn<0101aKf@0
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInG`3Pgn<01`2e
a<d0e=?Q0?ooo`3alO40hN7[0=CCh@3De>000P36a]800`2g]/@0MhRB0>3O
h`1M0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1V
IWh0LFmT05h0h=oS00L0]LC=0=CCh@3oool0lO7a0>7Qj`3Ddn40e=CP0080
a/KB00<0]kK407N8TP3Pgn<0G03Pgn<0101aKf@0IVIn0:RY^`3ko?d106IV
OP0000@0IVIn0?_lo@2XZK/0IVInG`3Pgn<01`2ea<d0e=?Q0?ooo`3alO40
hN7[0=CCh@3De>000P36a]800`2g]/@0MhRB0>3Oh`1M0>3Oh`0306IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0LFmT05h0h=oS00L0
]LC=0=CCh@3oool0lO7a0>7Qj`3Ddn40e=CP0080a/KB00<0]kK407N8TP3P
gn<0G03Pgn<0101aKf@0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2X
ZK/0IVInG`3Pgn<01`2ea<d0e=?Q0?ooo`3alO40hN7[0=CCh@3De>000P36
a]800`2g]/@0MhRB0>3Oh`1M0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT05h0h=oS00L0]LC=0=CCh@3oool0lO7a
0>7Qj`3Ddn40e=CP0080a/KB00<0]kK407N8TP3Pgn<0G03Pgn<0101aKf@0
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1`3Pgn<00`3D
dll0`l:m0?ooo`1E0?ooo`070;G4c@3Ddn40oooo0?7al@3QhN/0e=?Q0=CD
h0020<K6dP030;Nfa01gR980oooo05@0oooo00<0n?Sd0?GdkP3Pgn<01P3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn075_
I0060>3Oh`0309bLV@3Fe]D0l>gP05D0l>gP00L0]LC=0=CCh@3oool0lO7a
0>7Qj`3Ddn40e=CP0080a/KB00<0]kK407N8TP3`kN00E03`kN000`3gm_40
n_[g0>3Oh`050>3Oh`04075_I01VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0
nocm0:RY^`1VIWh70>3Oh`0309RGU03/jn@0l_7Y05D0l_7Y00L0]LC=0=CC
h@3oool0lO7a0>7Qj`3Ddn40e=CP0080a/KB00<0]kK407N8TP3blNT0E03b
lNT00`3cl^X0o_kn0>3Oh`060>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT00H0h=oS00<0/[6]0<k=a`3blNT0E@3b
lNT01`2ea<d0e=?Q0?ooo`3alO40hN7[0=CCh@3De>000P36a]800`2g]/@0
MhRB0?;aj@1D0?;aj@030?Ofl@3jn_L0h=oS00D0h=oS00@0LFmT06IVOP2X
ZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPL0h=oS00<0gMcE0<30
_02MW9T0E@2MW9T01`2ea<d0e=?Q0?ooo`3alO40hN7[0=CCh@3De>000P36
a]800`2g]/@0MhRB09fLV@1D09fLV@030?Shm03em>h0h=oS00H0h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0GP3P
gn<01`2ea<d0e=?Q0?ooo`3alO40hN7[0=CCh@3De>000P36a]800`2g]/@0
MhRB0>3Oh`1L0>3Oh`04075_I01VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0
nocm0:RY^`1VIWiO0>3Oh`070;G4c@3Ddn40oooo0?7al@3QhN/0e=?Q0=CD
h0020<K6dP030;Nfa01gR980h=oS05d0h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1aKf@0GP3Pgn<01`2ea<d0e=?Q0?oo
o`3alO40hN7[0=CCh@3De>000P36a]800`2g]/@0MhRB0>3Oh`1L0>3Oh`04
075_I01VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWiO0>3O
h`070;G4c@3Ddn40oooo0?7al@3QhN/0e=?Q0=CDh0020<K6dP030;Nfa01g
R980h=oS05d0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1aKf@0GP3Pgn<0102faLd0L=I_06CCHP1:bdP304S;AP0404K:
A00R_R007Z/L07f>VEd0h=oS00@0LFmT06IVOP2XZK/0nocm0@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOUl0h=oS00@0_/_C0:KB/@1`eVl0ImAV0`1Ve6D0
101Sdf80A/Y406>_MP27VZIN0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0LFmT05l0h=oS00<0_/_C0;K5c@2ea<d0102e
a<d00`2__lP0Wk:n0>3Oh`1M0>3Oh`04075_I01VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWk80>3Oh`0306IVOP2XZK/0nocm0040IVIn
0000bP1VIWh0nocm0:RY^`1VIWh0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0
LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03P
gn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_
I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS
075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0
h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1a
Kf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3O
h`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT
0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0
LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03P
gn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_
I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS
075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0
h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1a
Kf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3O
h`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT
0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0
LFmT0>3Oh`1aKf@0h=oS075_I03Pgn<0LFmT0>3Oh`1aKf@0h=oS075_I03P
gn<2075_I00306IVOP2XZK/0nocm0040IVIn00000`1VIWh0moOi09RHY`3:
07MgTP40V9RW0@3gmoT106IVOP0000<0IVIn0?Ogn@2l_Ld0b`2l_Ld10?Og
n@40IVIn00000`1VIWh0moOi0>CSh`3;0>CSh`40moOi0@1VIWh0000306IV
OP3`lO@0oooo08@0oooo00<0i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?
06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0
101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0
W:Bi102V>D@0102W>T@0YSU40:LjA02W>T@90:HiA00309bT^@3/j^X0oooo
00<0oooo0@3`lO@106IVOP0001H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0
no_m0?_lo@3ko?`0o?cm0?clo03lnod0o?cl0?cko03lo?`0nocl0?clo03k
o?d0o?_l0?clo@3knod0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?d`0?ck
o340nocl2P3ko?d00`2LY;T0JgF?08F9/00@08F9/00606]eS`2LY;T0nocm
0?_lo@2LY;T0JgF?4@25RK001P1[MHl0W:Bi0?_lo03kno`0W:Bi0:HiA140
ZSaE00L0YSU409bT^@3ko?`0o?cl0?cko@3ko?d0h^7R0040IVIn0000101V
IWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0moOh
0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3gmoT0103gm_P0m_Oh0?Kgn@3gmoT3
0?Kgn@030?Kgn03gmoT0moOi02l0moOi<@3fmoT:0?Ogn@0306]eS`25RK00
W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi06]eS`25RK0A09bN_P0808F9
/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=0<IEG0090<IDFP32DU/0
ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q0040IVIn00001P1VIWh0g]gQ
0?7am03alO@0l?7d0?3bm100000000H0lO7d0?3bm@3alO@0lO;d0?3bm03a
lOAQ0?3am@X0l?7d00<0JgF?0;:ed02WZ<80402WZ<801P2b]M00JgF?0?3a
m03`lO@0JgF?0;:ed140YjS200D0/[G@06]eS`3`lOD0lO;d0:HiA0020<9B
F`030<]DF@3=FEh0cEUN00/0cEUN00@0beAI0<9BF`32DU/0YSU40P3`lO@0
0`3alO@0l?;d0=kMh@0106IVOP0000L0IVIn0=cKh03Zjo00j^_`0>[/l03Y
jnl000000080inOW0P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0inOW0P3_
knl010000000j^_`0>[[l03Zjnl20>[[l0030>[[k`3Zjo00j^_`02h0j^_`
<@3Zk?0:0>[[k`0406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk60:b^aP2]
[/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`0406]eS`2f^M40[Jk60:f^
aP`0oooo0P2][/H00`2/[/H0][WA06]eS`020>[[l0050:HiA03=FEh0beAI
0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK0<]DF@3=FEh0YSU40>[[k`3Zjo00
0P3Zjnl10=cKh040IVIn0000101VIWh0fMWO0>?UjP3Si>X20>?Uj`050000
002<S8`0g]kN0>OWi`3Ng]h00P3WinL00`36H`00inOW0>OWi`020>OWi`07
0>o_i`3_knl0kno_0000003Si>X0hnC[0>?UjP020>?TjP030>?Tj`3SiN/0
hnG[02h0hnG[<@3Si>X:0>?UjP0506]eS`2l_]@0/[;:0;:bbP3oool01P1^
KHl00`0U9CH0/[;:0;:bbP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[MHl0
_;kD0P2b//X00`3oool09BDf02DU=P0902DU=P<0/[;:00D0_;kD06]eS`3S
i>/0hnC[0:HiA0020<eIGP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3oool0
2P3DG5l0d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl106IV
OP0000<0IVIn0=OHgP3Lg^H00`3Lg^H01@000000inOW0>OWi`3WinL0imK>
0080inOW00D0cW/00>nD403WinL0imk60>n<40030>o_k`070000003Lg^H0
g=kU0=cNi@3Lg^H0g=kU0=cNiP1[0=cNi@0506]eS`2o`MH0^;W>0;RicP3o
ool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU0=cN
i@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U9CH0
^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C
9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA0020=cN
i@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>420=GH
h0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080gV/0
00D0kkF<0>o_k`3_knl0kno_000000020=GHh@040=GGh03Ff>00e]SQ0=KG
hC00e]OP<@3Ff>0:0=GHh@0506]eS`33aMT0_;gA0;bmd@3oool01`0U9CH7
0;bmd@060<?5f@1[MHl0eMSQ0=GHh@1[MHl0`lGI0P2l_M400`3oool09BDf
0;bmd@070;bmd@030?ooo`0U9CH0_;gA0080_;gA00D0`lGI06]eS`3Fen00
eMOQ0:HiA0020=EMH0030=QPH@3IHF80AQhJ00<0oooo0`3IHF830?ooo`03
04HN6P3IHF80f61Q0080eEeP00H0YSU40=KHh03Ef>40eMOP0=GHh@3Ee]d1
06IVOP0000L0IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@d]`0000000<0inOW00`0
imk>0<I:003gcP00kjd00>ne003>J`00aUX00<I[003NS4X0ijD00>oWcP00
00030=3Bg0030<oBg03@d]`0cm;L0300d=;L<@3?d]d:0=3Bg00306]eS`38
bM/0`lCF0100`lCF00H0b<WK06]eS`3@d]`0d=;L06]eS`38bM/20<?4eP03
0?ooo`0U9CH0`lCF00L0`lCF00<0oooo02DU=P33a=H00P33a=H01`38bM/0
JgF?0<oBg03?d]`0YSU40=MOG`3IHF800`3LIFD01@167QX0oooo0?ooo`3o
ool0g6EU00<0oooo00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0YSU40=3B
g@80d=;L0@3?d]`10=;Dg@40IVIn0000701VIWh0d=;K0<_=f03:cMT0blkH
0<[=f0000000ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU003FS000
cV/00>O6003oeP00knoW0>o_k`000000blgH0<_=f@3:cMT0blkH0<[=f03;
cMP`0<_=fC40blkI2P3;cMP00`1[MHl0blcN0<S:f@080<S:f@030<S9f@38
b]T0b<[I00<0b<[I00@0b<WI0<S:f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN
0<S:f@38b]T0oooo02DU=PD0b<[I0140b<WI0<S:f@38b]T0oooo02DU=P38
b]T0b<WI0<S:f@3;c=h0JgF?0<_>f03:cMP0YSU40=MOG`3KI6@0h6MU0>1V
I@020=iWI`0304HN6P3oool0oooo00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU
0>1WI@3KI6@0eemO0:HiA03:c]P0b/kI0P3;cMT10=3Bf`40IVIn00000`1V
IWh0cloJ0<G8e0030<G8e00600000036a/H0imkF0<ik003W[@00kkD00P3W
Y@000`3FU000cW<00=JD00020?O60080moOg00@000000<G8e035am@0aLOD
0`35amD`0<C7eC40a<SD2P34am@00`1[MHl0d=7P0<_;g00@0<_;g0060=3A
h01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3oool09BDf0<_;g0070<_;
g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]eS`35am@0a<OD0:HiA03K
I6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo04HN6P050>1ZJ0040=mU
I03KI6@0YSU40<C8e@80a<SD0@35amD10<o?fP40IVIn0000101VIWh0c<kJ
0<;4dP31a=420<74dP060000003WinL0inOW0>OWi`3FQ000kkD00P3WY@00
203FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL000000`31a=800`32a=40
`LCB0<74dP0`0<74dC40`LCB2P32a=800`1[MHl0dm?R0<o@g@0@0<o@g@06
0=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?d=d00`3oool09BDf0<o@g@07
0<o@g@030?ooo`0U9CH0cm3M0080cm3M00L0dm?R06]eS`32a=80`LCA0:Hi
A03KI6@0hFUU00D0h6aY1@3oool50>1/J@080>5YI@3KI6@0YSU40<74dP32
a=40`LCA0<74dP3<c]X106IVOP0000@0IVIn0<[<f02n`<l0_L3?0P2n`<h0
1@000000W9bL0>OWi`3Wg]H0eX`00080gY@000@0eW/00<IS002m@P00kjD0
0P3g[@00203g]@00oli:0000002n`<h0_/3?0;k0cP2n`<l0_L3><@2n`<ha
0;g0cPX0_/3>00<0JgF?0=KFi03Cdn00403Cdn001P3Fe^@0JgF?0;k0cP2n
`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3oool0203oool02`0U9CH0dm?P
0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:HiA03PIVD0hFYZ00@0hfa/0`3o
ool010167QX0oooo0?ooo`3oool40>=/K0040>5ZJP3PIVD0YSU40;g0c`80
_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0bL[H0;Jhb02i_</0^[c;0;Zl
c00000000P3_knl04`3FW000eX`00=jD003FQ000kjD00=j<002mFP00eW<0
0>nL003gknL0moOg0?ooo`000000^Kc<0;Zkc02i_</0^[c;0;Vlc02i_</0
<02i_<`a0;Zlc0X0^[c;00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?
0;Zlb`2j_</0JgF?0=SHi@80dm?Q00<0oooo06i]S`1^KHl0201^KHl03P0U
9CH0dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<0:HiA03PJFP0hFe/0>Aa
K@3TLFl0i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^00T0i75]
0>5]K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039b]P00@1VIWh0000906IV
OP37bML0];K70;Jhb02f^<T0][W900000024Q8@0inON0080kno_00L0aV/0
0?O6003_]@00ki`00=j<003>J`00ii`000<0moOg00D000000;Jib@2g^<T0
][W90;Nib@020;JhbC00]kS9<@2f^<T:0;Nhb@0406]eS`3Fe^@0f=SU0=SH
iP<0f=SU1@3Hf>H30=SHi@80f=SV0P3Hf>D02@3Fe^@0JgF?0;Nhb@2g^<T0
JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]S`0=02DU=P3Hf>H0f=SU0=SHi@3F
e^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3TM6l0ig5_0>AdK`030?ooo`0504HN
6P3TM6l0i7A_0>AdK`167QX00`3oool02P3TM6l0ig5_0>AdK`3TKVd0YSU4
0;Jib@2f^<T0][W90;Bfa`37bML106IVOP0000<0IVIn0<K8e`2d]/L00`2d
]/L00`000000kno_0>o_k`020>o_k`0;0>N]003gaPP0ijD00>ND003WS000
knOF0=jD>@3_e[D0ooOg0?ooo`000000L@2d]/L01@1[MHl0eMGS0=cKi`3L
fnL0gM_W00h0g=_W00H0eMGS06]eS`2d]/L0];K706]eS`3EeN<20=cKi`03
0=gKi`0U9CH09BDf00T09BDf0`3LfnL02@3EeN<0JgF?0;Bfa`2d]/L0YSU4
0>McK`3WMG80jWIc0>YhMP020?ooo`0304HN6P3YOWP0jGih00<0jGih00P0
AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80ig=_0:HiA0@0];K70@36b=L106IV
OP0000<0IVIn0<K8e`2d]/L00`2d]/L01P000000S8b<0>o_k`3_knl0ilik
0>o_k`80moOg00P0ii@00?OWcP3gmoL0moOg0>oWeP3gmoL0oooo00000740
];K700<0JgF?0=GDh`3PgnX0403PgnX01P3Ee><0JgF?0;Bfa`2d]/L0JgF?
0=GDha40h=oZ00T0eMCS06]eS`2d]/L0];K70:HiA03ZNG<0jGah0>n1NP3b
RH400P167QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<0>fGRP3[V8/00P167QX0
1@3bRH40kh5j0>UlN03ZNG<0YSU400@0];K70@36b=L106IVOP0000<0IVIn
0<K8e`2a/lP00`2a/lP01P000000kno_0>o_k`3_knl0moO_0>o_k`80moOg
00<0mnO60?Ogm`3oool00`3gmoL00`3oool000000;6cb01`0;6cb00306]e
S`3]jo<0jNSa0100jNSa00H0kN_c06]eS`2a/lP0/K?806]eS`3]jo<A0>WX
l@0I0>g[l`1[MHl0/K?80;6cb02V>D@0lH1e0?24O03eS8@0mif>0?:[UP3a
/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03bZiH0mif>0?F<
Q03`Q7`0lH1e0:HiA0040;6cb040a/SG0@1VIWh0000306IVOP36b=L0^;O?
00<0[jk700D000000:f][@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3oool0
0`000000[jk70:n^a`1_0:n^a`0306]eS`3BdN<0l_7g0100l_7g00H0d]7S
06]eS`2_[/L0[jk706]eS`3BdN<A0?;am`060=;Ah`1[MHl0[jk70:n^a`2V
>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0m8Ym0:HiA02_[/L00P2_[/L10;Rg
c`40a/SG0@1VIWh0000306IVOP30`M40alOD08@0[:_400@0Q8bR06]eS`3<
bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a00408B<XP1[MHl0
c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01`2AV:X0YSU4
0?nOS@3n_j@0n]bg0?[[]`3jjKH00P3ijKH0103jjKH0nNVf0?WY]P3jjKH2
0?WY]P060?[[]`3jg;L0o[nT0?nOS@2V>D@0TIRZ0`2/Zl@10<O7e040`<7A
0@1VIWh0000406IVOP30`M40d];O0;FdbH@0Y:>n00<0Q8bR06]eS`1[MHl0
3`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP1[MHl0JgF?00l0JgF?
00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80YSU40:HiA00?0:HiA00708B<
XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31d@0106IVOP0000H0IVIn0:RW_`3V
i^d0d];P0;blc`2a/<C40:RW_`050;6`a02l_<l0d];P0>KVk@2XYkl00@1V
IWh0000705QGJ027Qi/0emSR0?clo03ThnP0d=3P0<[:fP320;blc`060<[:
fP3@d>00i>?X0?clo03Gf>80QhNK0@1HEfP0000805QGJ01VIWh0UIB[0=OH
hP3lo?`0l_7c0>c[kP3Qh^_00=OHhP070>7Rj`3/jnh0l_7c0?clo03Gf>80
UIB[06IVOP0105QGJ0000P1HEfP00`1VIWh0UIB[0=7AgP020?clo<80oooo
0P3lo?`00`3AdMh0UIB[06IVOP0205QGJ0000`1HEfP206IVOP0308R7W@2E
U:/0Z:No0<40Z:No00@0UIB[08R7W@1VIWh0IVIn0`1HEfP000D0F5MXaP1V
IWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  Evaluatable->False,
  ImageSize->{208, 58},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Slider"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"Slider"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"CheckBox\"]", "ObjectName",
  CellTags->"CheckBox"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"text\" \[Rule] \"text label\"\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"selected\" \[Rule] False", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"CheckBox"],

Cell[TextData[{
  StyleBox["Events", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"change\" - ", "Program"],
  StyleBox["triggered when the checkbox is clicked", "Text"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"CheckBox"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"CheckBox"],

Cell[BoxData[
    \(\(ref\  = 
        GUIRun[\[IndentingNewLine]Widget["\<CheckBox\>", \ {"\<text\>" -> \
"\<Choose\>"}]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"CheckBox"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"CheckBox"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000>B000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQD0h=oS
02D000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`000000h=oS0000
003Pgn<000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`000000h=oS
0000003Pgn<000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`000000
h=oS0000003Pgn<0000003T0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOP@0h=oS3@0LDH1R0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh40>3Oh`0901aAP03alNl0lo?a
0?Gem03gmoH0nOWh0?_knP3moO`0o_kn00<0oooo00<075600>3Oh`3Pgn<0
0P3Pgn<00`000000h=oS0>3Oh`0Q0>3Oh`030000003Pgn<0h=oS03L0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0h=oS
00X075600>o_k03alNl0lo?a0?Gem03gmoH0nOWh0?_knP3moO`0o_kn0P3o
ool00`0LDH00h=oS0>3Oh`040>3Oh`<000000P3Pgn<01@000000h=oS0>3O
h`3Pgn<000000080h=oS0`0000030>3Oh`<000000`3Pgn<3000000<0h=oS
0`00000k0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh40>3Oh`0=01aAP03/k>T0kno/0?7ak`3clo40mOGd0?OgmP3inOP0
no_j0?gmo03no_h0oooo01aAP0040>3Oh`8000000`3Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`000000
0`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS
0P00000i0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh40>3Oh`0=01aAP03Xj>D0k>cY0>o_k03alNl0lo?a0?Gem03gmoH0
nOWh0?_knP3moO`0o_kn01aAP0040>3Oh`030000003Pgn<0h=oS00@0h=oS
00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3O
h`0000000`3Pgn<00`000000h=oS0>3Oh`020>3Oh`040000003Pgn<0h=oS
000003h0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP@0h=oS00d075600>GUhP3Xj>D0k>cY0>o_k03alNl0lo?a0?Gem03g
moH0nOWh0?_knP3moO`0756000@0h=oS00<000000>3Oh`3Pgn<0103Pgn<0
1`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0h=oS008000000`3Pgn<6000003T0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0h=oS
00d075600>;RgP3UiN80j>SU0>c/j@3_kn`0lO7_0??cl@3emO@0moOf0?Wi
n03knoX0756000@0h=oS00<000000>3Oh`3Pgn<0103Pgn<200000080h=oS
00<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`030000
003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS
0>3Oh`0h0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh40>3Oh`0=01aAP03Ph=/0h^;N0>GUhP3Xj>D0k>cY0>o_k03alNl0
lo?a0?Gem03gmoH0nOWh01aAP0040>3Oh`030000003Pgn<0h=oS00@0h=oS
00@000000>3Oh`00000000000`3Pgn<3000000<0h=oS0`0000030>3Oh`<0
00000`3Pgn<3000000030>3Oh`000000h=oS03P0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0h=oS00d075600=kNf@3P
h=/0h^;N0>GUhP3Xj>D0k>cY0>o_k03alNl0lo?a0?Gem03gmoH0756000D0
h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000005H0h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0h=oS00d07560
0=cLe`3Ng]T0h>3K0>;RgP3UiN80j>SU0>c/j@3_kn`0lO7_0??cl@3emO@0
756000@0h=oS00<000000>3Oh`0000000P0000020>3Oh`030000003Pgn<0
h=oS01X0h=oS00<000000>3Oh`3Pgn<0=`3Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn103Pgn<03@0LDH00g=cG0=cLe`3N
g]T0h>3K0>;RgP3UiN80j>SU0>c/j@3_kn`0lO7_0??cl@0LDH00HP3Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn103Pgn<0
3@0LDH00g=cG0=cLe`3Lg=L0g]kI0>3Pf`3Rh]h0iNGR0>SXi@3/k>T0kno/
0?7ak`0LDH00103Pgn<00`000000h=oS0>3Oh`0Q0>3Oh`030000003Pgn<0
h=oS03L0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP@0h=oS3@0LDH1R0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWhE0>3Oh`0U0000003Pgn<000000>3Oh`000000h=oS
0000003Pgn<000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`000000
h=oS0000003Pgn<000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`00
0000h=oS0000003Pgn<000000>3Oh`000000h=oS0000000i0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IV
OP2XZK/0nocm0040IVIn00000`1VIWh0moOi09RHY`1e07MgTP40V9RW0@3g
moT106IVOP0000<0IVIn0?Ogn@2l_Ld0MP2l_Ld10?Ogn@40IVIn00000`1V
IWh0moOi0>CSh`1f0>CSh`40moOi0@1VIWh0000306IVOP3`lO@0oooo02l0
oooo00<0i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?06afT01/MY0906]e
S`0609bT^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0101/MY00JgF?06af
T01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W
>T@0YSU40:LjA02W>T@90:HiA00309bT^@3/j^X0oooo00<0oooo0@3`lO@1
06IVOP0001H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0
o?cm0?clo03lnod0o?cl0?cko03lo?`0nocl0?clo03ko?d0o?_l0?clo@3k
nod0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?dD0?cko080nocl00<0W:Bi
06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`
00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl
0?clo03lnod0nocm0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3f
moT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0
m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Og
n@0C0?Ogn@80m_Oi00<0JgF?08F9/02LW[h0402LW[h01P25RK00JgF?0?Og
n@3gmoT0JgF?08F9/140W9jn00P0QHV`06]eS`3fmoP0moOh0:HiA02Z?5D0
`U9K0<IDFPd0aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh0?Og
n@3Ph>400@1VIWh0000606IVOP3NgN40lO7d0?7am03`lO@0l?;d40000000
1P3alO@0l?;e0?7am03al_@0l?;d0?7am1H0l?7e00<0JgF?0;:ed02WZ<80
402WZ<801P2b]M00JgF?0?3am03`lO@0JgF?0;:ed140YjS200D0/[G@06]e
S`3`lOD0lO;d0:HiA0020<9BF`030<]DF@3=FEh0cEUN00/0cEUN00@0beAI
0<9BF`32DU/0YSU40P3`lO@00`3alO@0l?;d0=kMh@0106IVOP0000L0IVIn
0=cKh03Zjo00j^_`0>[/l03Yjnl000000080inOW0P3Ng]h20>OWi`030>Nm
Q03WinL0inOW00<0inOW0P3_knl010000000j^_`0>[[l03Zjnl20>[[l003
0>[[k`3Zjo00j^_`0180j^_`0P3Zk?00101[MHl0][WA0:f^aP2][/H80?oo
o`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0101[
MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Zjo00
1@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0cEUN
0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3SiNX0
hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<00>OW
i`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX00P3S
i>X00`3Si>/0hnG[0>?Uj`0B0>?Uj`80hnCZ00D0JgF?0;bne02b//X0/[;:
0?ooo`0606i]S`0302DU=P2b//X0/[;:00D0/[;:00H0_;kD06]eS`3SiNX0
hnGZ06]eS`2l_]@20;:bbP030?ooo`0U9CH09BDf00T09BDf0`2b//X01@2l
_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN00@0d5]P0=ALG`3oool0oooo1`3D
G5l20?ooo`0:0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnCZ0>?UjP3Si>X0hnG[
0=WIg`40IVIn00000`1VIWh0emSN0=cNiP030=cNiP050000003WinL0inOW
0>OWi`3We/h00P3WinL01@3>N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_00L0
00000=cNiP3Lg^D0g=kU0=cNiP3Lg^D0g=kV01H0g=kU00D0JgF?0;o1eP2h
^Lh0^;W>0?ooo`0606i]S`0302DU=P2h^Lh0^;W>00D0^;W>00H0_l7F06]e
S`3Lg^D0g=kU06]eS`2o`MH20;RicP030?ooo`0U9CH0^;W>00L0^;W>00<0
oooo02DU=P2h^Lh00P2h^Lh02@2o`MH0JgF?0=cNiP3Lg^D0YSU40<eIGP3A
FUh0e5eQ05<U80030?ooo`D0eUmS0`3oool01@1C9B00e5eQ0=5JGP3=FEh0
YSU40080g=kU00<0g=kV0=cNi@3Gf=h00@1VIWh0000406IVOP3Ee]d0eMSP
0=KHh@80eMSP00T0000008b<S03WinL0inOW0>NeQ03FFP00eX@00?o>003>
H`000P3NJ`001@3_]H`0kno_0>o_k`3_knl000000080eMSQ00@0eMOP0=KH
h03Ff>40e]OQ503Fen020=KHh00506]eS`33aMT0_;gA0;bmd@3oool01`0U
9CH70;bmd@060<?5f@1[MHl0eMSQ0=GHh@1[MHl0`lGI0P2l_M400`3oool0
9BDf0;bmd@070;bmd@030?ooo`0U9CH0_;gA0080_;gA00D0`lGI06]eS`3F
en00eMOQ0:HiA0020=EMH0030=QPH@3IHF80AQhJ00<0oooo0`3IHF830?oo
o`0304HN6P3IHF80f61Q0080eEeP00H0YSU40=KHh03Ef>40eMOP0=GHh@3E
e]d106IVOP0000L0IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@d]`0000000<0inOW
00`0imk>0<I:003gcP00kjd00>ne003>J`00aUX00<I[003NS4X0ijD00>oW
cP0000030=3Bg0030<oBg03@d]`0cm;L01@0d=;L0P3?d]d00`1[MHl0b<WK
0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3o
ool09BDf0<?4eP070<?4eP030?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]e
S`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo
0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d2
0=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:
cMP000000>O6[@3WaX`0mlhH0>nm003gaP00kjd00>N]003WY@00eX`00<i[
003WaP00omH00>o_i`3_knl000000<_=f03;cMT0b/gI0<_>f03:cMP0blgH
503;cMT20<_>f@0306]eS`3;c=h0b<[I00P0b<[I00<0b<WI0<S:f@38b]T0
0`38b]T01038bMT0b<[I0<_<gP1[MHl20<_=f00606]eS`3;c=h0b<[I0<S:
f@3oool09BDf1@38b]T04@38bMT0b<[I0<S:f@3oool09BDf0<S:f@38bMT0
b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0eemO0=]TI03PIfD0h6IU0080gVMW
00<0AQhJ0?ooo`3oool00`3oool02P167QX0gVMW0=iWI`3PIVD0h6MU0=]T
I03GGel0YSU40<[>f03:c]T20<_=f@40d=;K0@1VIWh0000306IVOP3?cmX0
aLSD00<0aLSD00H000000<K6aP3Wg]H0cW/00>N]003_]@020>NU00030=JD
003>L`00eY@00080mlH00P3gmoL010000000aLSD0<G7e035am@30<G7eA@0
a<OE0P34b=@00`1[MHl0d=7P0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7
e01[MHl0d=7P0P3;bm`00`3oool09BDf0<_;g0070<_;g0030?ooo`0U9CH0
bl_L0080bl_L00L0d=7P06]eS`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX
00D0AQhJ0?ooo`3oool0oooo04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8
e@80a<SD0@35amD10<o?fP40IVIn0000101VIWh0c<kJ0<;4dP31a=420<74
dP060000003WinL0inOW0>OWi`3FQ000kkD00P3WY@00203FQ000cV/00>N]
003g]@00mkd00>o_k`3gmoL000000`31a=800`32a=40`LCB0<74dP0D0<74
d@80`LCB00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80
JgF?0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@
g@020<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0
oooo1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1V
IWh0000406IVOP3:c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0imkF
0=J<00020=jD00040=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>BP00
0000_/3>0;k0c`2n`<h0_/3?0;g0cQD0_/3>0P2m`<h00`1[MHl0e]KT0=?C
h00@0=?Ch0060=KFi01[MHl0_/3>0;k0cP1[MHl0e]KT0P3Cdn000`3oool0
9BDf0?ooo`080?ooo`0;02DU=P3Cdn00dm?P0=?Ch03Fe^@0JgF?0;k0c`2n
`<h0YSU40>1VI@3QJVX0103SK6`30?ooo`0404HN6P3oool0oooo0?ooo`@0
hfa/00@0hFYZ0>1VI@2V>D@0_L3?0P2n`<l10;k0cP40b/cH0@1VIWh00007
06IVOP39b]P0][S80;Vlb`2j_</0^[c<000000020>o_k`0C0=JL003FS000
gY@00=J4003_Y@00gX`00;eJ003FL`00ki`00?O_i`3gmoL0oooo0000002i
_<`0^[_<0;Vlb`2j_</0^Kc<0;Vlb`0D0;Vlc080^[c<00<0JgF?0=SHi@3C
dn40403Cdn401P3Hf>D0JgF?0;Zlb`2j_</0JgF?0=SHi@80dm?Q00<0oooo
06i]S`1^KHl0201^KHl03P0U9CH0dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0
^[c<0:HiA03PJFP0hFe/0>AaK@3TLFl0i71^0`3oool00`167QX0i71^04HN
6P030?ooo`80i71^00T0i75]0>5]K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jh
b039b]P00@1VIWh0000906IVOP37bML0];K70;Jhb02f^<T0][W900000024
Q8@0inON0080kno_00L0aV/00?O6003_]@00ki`00=j<003>J`00ii`000<0
moOg00D000000;Jib@2g^<T0][W90;Nib@020;JhbA@0]kS90P2f^<T0101[
MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0e]KT
06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U9CH0
f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>MaK`3T
M6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_0>Ma
K`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG0@1VIWh0000306IV
OP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_knl02`3W[@00mlH8
0>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool0000001`0];K700D0
JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`1[
MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS06]e
S`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3oool00`167QX0jGih
0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V>D@4
0;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0];K700H0000008b<
S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_imH0
moOg0?ooo`00000L0;Bfa`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS06]e
S`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V>D@0
jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZKS03]
UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40a/SG
0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H000000>o_k`3_knl0kno_
0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg00<0oooo0000002a
/lP06`2a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?80;6c
b01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`Q7`0
mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fdV`3/
]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn0000
0`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_0?Ogm`3_knl01P3g
moL20?ogm`80oooo00<000000:n^a`2_[/L06P2_[/L00`1[MHl0d]7S0?;a
m`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3BdN<0
JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V>D@0
[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0`<7A0<O7e00_0:b[
a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/
Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80
[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0n^Vf
0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03oWhd0YSU4096HZP<0
[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;Bg`2e]<T_0:BS_P03
08B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80
JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:HiA02V
>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1VIWh0
000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34K`2XYkl01@2a/<@0_;c?0=;B
h03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@h03:
b]X0K@2l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000201H
EfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[J`3Gf>801`3Qh^/0k>_^
0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX00<0IVIn09FDZ`3A
dMh00P3lo?a]0?ooo`80o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0F5MX
0P1VIWh00`28Qid0UIB[0:RW_`1/0:RW_`0409FDZ`28Qid0IVIn06IVOP<0
F5MX000505QGJ740IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[7]:=",
  Evaluatable->False,
  ImageSize->{123, 57},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"CheckBox"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]=",
  CellTags->"CheckBox"]
}, Open  ]],

Cell[BoxData[
    \(\(ref\  = 
        GUIRun[\[IndentingNewLine]Widget["\<CheckBox\>", \ {"\<text\>" -> \
"\<Choose\>", \ \ "\<selected\>" \[Rule] 
                True}]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"CheckBox"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"CheckBox"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000>B000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQD0h=oS
02D000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`000000h=oS0000
003Pgn<000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`000000h=oS
0000003Pgn<000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`000000
h=oS0000003Pgn<0000003T0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOP@0h=oS3@0LDH1R0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh40>3Oh`0901aAP03clo40mOGc
0?OgmP3inOP0n_[i0?cln`3moOd0o_kn00<0oooo00<075600>3Oh`3Pgn<0
0P3Pgn<00`000000h=oS0>3Oh`0Q0>3Oh`030000003Pgn<0h=oS03L0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0h=oS
00X075600?7ak`3clo40mOGc0?OgmP3inOP0n_[i0?cln`3moOd0o_kn0P3o
ool00`0LDH00h=oS0>3Oh`040>3Oh`<000000P3Pgn<01@000000h=oS0>3O
h`3Pgn<000000080h=oS0`0000030>3Oh`<000000`3Pgn<3000000<0h=oS
0`00000k0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh40>3Oh`0=01aAP03_kn`0lO7_0??cl@3emO<08J4Q0?Win03jn_T0
o?ck0?gmo@3no_h0oooo01aAP0040>3Oh`8000000`3Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`000000
0`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS
0P00000i0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh40>3Oh`0401aAP03/k>T0kno/0?7ak`<08J4Q00H0nOWh0?[jn@3l
o?/0oOgm0?knoP0LDH040>3Oh`030000003Pgn<0h=oS00@0h=oS00L00000
0>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`000000
0`3Pgn<00`000000h=oS0>3Oh`020>3Oh`040000003Pgn<0h=oS000003h0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0
h=oS00<075600>[ZiP3/k>T01@0QXB401@3inOP0n_[i0?cln`3moOd07560
00@0h=oS00<000000>3Oh`3Pgn<0103Pgn<01`000000h=oS0>3Oh`3Pgn<0
00000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`030000003P
gn<0h=oS008000000`3Pgn<6000003T0h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOP@0h=oS00<075600>OWh`3Zj^H00P0Q
XB40203alNl08J4Q026Q8@0QXB40nOWh0?[jn@3lo?/07560103Pgn<00`00
0000h=oS0>3Oh`040>3Oh`8000000P3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`00
0000h=oS000000030>3Oh`030000003Pgn<0h=oS03P0h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0h=oS00L075600>GU
h@3Win<08J4Q0>c/j@3_kn`0lO7_00<08J4Q00<0nOWh0?[jn@0LDH00103P
gn<00`000000h=oS0>3Oh`040>3Oh`040000003Pgn<00000000000<0h=oS
0`0000030>3Oh`<000000`3Pgn<3000000<0h=oS0`0000000`3Pgn<00000
0>3Oh`0h0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh40>3Oh`0801aAP03Shml0iNGQ0>OWh`3Zj^H0k>cY0>o_k03alNl2
026Q8@030?OgmP3inOP0756000D0h=oS00L000000>3Oh`3Pgn<0h=oS0000
003Pgn<0000005H0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOP@0h=oS00d075600>;Rg@3Shml0iNGQ0>OWh`3Zj^H0k>cY
0>o_k03alNl08J4Q0?Gel`3gmoH0756000@0h=oS00<000000>3Oh`000000
0P0000020>3Oh`030000003Pgn<0h=oS01X0h=oS00<000000>3Oh`3Pgn<0
=`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
103Pgn<03@0LDH00h^;M0>;Rg@3Shml0iNGQ0>OWh`3Zj^H0k>cY0>o_k03a
lNl0lo?a0?Gel`0LDH00HP3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn103Pgn<03@0LDH00h^;M0>;Rg@3Rh]d0hn?O0>GU
h@3Win<0j^[V0>c/j@3_kn`0lO7_0??cl@0LDH00103Pgn<00`000000h=oS
0>3Oh`0Q0>3Oh`030000003Pgn<0h=oS03L0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0h=oS3@0LDH1R0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhE0>3Oh`0U0000
003Pgn<000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`000000h=oS
0000003Pgn<000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`000000
h=oS0000003Pgn<000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`00
0000h=oS0000000i0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm0040IVIn00000`1VIWh0
moOi09RHY`1e07MgTP40V9RW0@3gmoT106IVOP0000<0IVIn0?Ogn@2l_Ld0
MP2l_Ld10?Ogn@40IVIn00000`1VIWh0moOi0>CSh`1f0>CSh`40moOi0@1V
IWh0000306IVOP3`lO@0oooo02l0oooo00<0i>?S09bT^@1[MHl00`1[MHl0
101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3Thn<0
W:Bi101[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo
0?ooo`3/j^X0W:Bi102V>D@0102W>T@0YSU40:LjA02W>T@90:HiA00309bT
^@3/j^X0oooo00<0oooo0@3`lO@106IVOP0001H0IVIn0>;QhP3ko?`0no_l
0?_lo@3lnod0no_m0?_lo@3ko?`0o?cm0?clo03lnod0o?cl0?cko03lo?`0
nocl0?clo03ko?d0o?_l0?clo@3knod0nocl0P3lo?`0103lo?d0o?cl0?_k
o@3lo?dD0?cko080nocl00<0W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi
0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V
>D@A0:XlE@070:HiA02LY;T0nocl0?clo03lnod0nocm0>;QhP0106IVOP00
00@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi
0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0
moOi0`3fmoT00`3fmoP0moOi0?Ogn@0C0?Ogn@80m_Oi00<0JgF?08F9/02L
W[h0402LW[h01P25RK00JgF?0?Ogn@3gmoT0JgF?08F9/140W9jn00P0QHV`
06]eS`3fmoP0moOh0:HiA02Z?5D0`U9K0<IDFPd0aUEL00T0aUAJ0<9BF`2Z
?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>400@1VIWh0000606IVOP3NgN40
lO7d0?7am03`lO@0l?;d400000001P3alO@0l?;e0?7am03al_@0l?;d0?7a
m1H0l?7e00<0JgF?0;:ed02WZ<80402WZ<801P2b]M00JgF?0?3am03`lO@0
JgF?0;:ed140YjS200D0/[G@06]eS`3`lOD0lO;d0:HiA0020<9BF`030<]D
F@3=FEh0cEUN00/0cEUN00@0beAI0<9BF`32DU/0YSU40P3`lO@00`3alO@0
l?;d0=kMh@0106IVOP0000L0IVIn0=cKh03Zjo00j^_`0>[/l03Yjnl00000
0080inOW0P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0inOW0P3_knl01000
0000j^_`0>[[l03Zjnl20>[[l0030>[[k`3Zjo00j^_`0180j^_`0P3Zk?00
101[MHl0][WA0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0
[:k60;Jid@1[MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk6
00<0[:k60;Jid@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0
d5YO00L0cUUO0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn01
06IVOP0000@0IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3W
inL0g]kN0080inOW00<0aV<00>OWi`3WinL00P3WinL01`3_knL0kno_0>o_
k`000000hnCZ0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0B0>?Uj`80
hnCZ00D0JgF?0;bne02b//X0/[;:0?ooo`0606i]S`0302DU=P2b//X0/[;:
00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ06]eS`2l_]@20;:bbP030?ooo`0U
9CH09BDf00T09BDf0`2b//X01@2l_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN
00@0d5]P0=ALG`3oool0oooo1`3DG5l20?ooo`0:0=ALG`3@Ff00cEUN0<eI
GP2V>D@0hnCZ0>?UjP3Si>X0hnG[0=WIg`40IVIn00000`1VIWh0emSN0=cN
iP030=cNiP050000003WinL0inOW0>OWi`3We/h00P3WinL01@3>N`00ki@@
0>OWi`3Wg/H0kh`@00<0kno_00L000000=cNiP3Lg^D0g=kU0=cNiP3Lg^D0
g=kV01H0g=kU00D0JgF?0;o1eP2h^Lh0^;W>0?ooo`0606i]S`0302DU=P2h
^Lh0^;W>00D0^;W>00H0_l7F06]eS`3Lg^D0g=kU06]eS`2o`MH20;RicP03
0?ooo`0U9CH0^;W>00L0^;W>00<0oooo02DU=P2h^Lh00P2h^Lh02@2o`MH0
JgF?0=cNiP3Lg^D0YSU40<eIGP3AFUh0e5eQ05<U80030?ooo`D0eUmS0`3o
ool01@1C9B00e5eQ0=5JGP3=FEh0YSU40080g=kU00<0g=kV0=cNi@3Gf=h0
0@1VIWh0000406IVOP3Ee]d0eMSP0=KHh@80eMSP00T0000008b<S03WinL0
inOW0>NeQ03FFP00eX@00?o>003>H`000P3NJ`001@3_]H`0kno_0>o_k`3_
knl000000080eMSQ00@0eMOP0=KHh03Ff>40e]OQ503Fen020=KHh00506]e
S`33aMT0_;gA0;bmd@3oool01`0U9CH70;bmd@060<?5f@1[MHl0eMSQ0=GH
h@1[MHl0`lGI0P2l_M400`3oool09BDf0;bmd@070;bmd@030?ooo`0U9CH0
_;gA0080_;gA00D0`lGI06]eS`3Fen00eMOQ0:HiA0020=EMH0030=QPH@3I
HF80AQhJ00<0oooo0`3IHF830?ooo`0304HN6P3IHF80f61Q0080eEeP00H0
YSU40=KHh03Ef>40eMOP0=GHh@3Ee]d106IVOP0000L0IVIn0=;Dg@3?d]`0
d=;L0=3Bg@3@d]`0000000<0inOW00`0imk>0<I:003gcP00kjd00>ne003>
J`00aUX00<I[003NS4X0ijD00>oWcP0000030=3Bg0030<oBg03@d]`0cm;L
01@0d=;L0P3?d]d00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L
0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP030?ooo`0U
9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0fF5R00<0
g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3LIFD0g6EU
0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IVOP0001`0
IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH0>nm003g
aP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl000000<_=
f03;cMT0b/gI0<_>f03:cMP0blgH503;cMT20<_>f@0306]eS`3;c=h0b<[I
00P0b<[I00<0b<WI0<S:f@38b]T00`38b]T01038bMT0b<[I0<_<gP1[MHl2
0<_=f00606]eS`3;c=h0b<[I0<S:f@3oool09BDf1@38b]T04@38bMT0b<[I
0<S:f@3oool09BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0
eemO0=]TI03PIfD0h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3oool02P16
7QX0gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0YSU40<[>f03:c]T20<_=f@40
d=;K0@1VIWh0000306IVOP3?cmX0aLSD00<0aLSD00H000000<K6aP3Wg]H0
cW/00>N]003_]@020>NU00030=JD003>L`00eY@00080mlH00P3gmoL01000
0000aLSD0<G7e035am@30<G7eA@0a<OE0P34b=@00`1[MHl0d=7P0<_;g00@
0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3oool09BDf
0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]eS`35am@0
a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo04HN6P05
0>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD0@35amD10<o?fP40IVIn0000
101VIWh0c<kJ0<;4dP31a=420<74dP060000003WinL0inOW0>OWi`3FQ000
kkD00P3WY@00203FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL000000`31
a=800`32a=40`LCB0<74dP0D0<74d@80`LCB00<0JgF?0=?ChP3?d=d0403?
d=d01P3Cdn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M00<0oooo02DU=P3?
d=d01`3?d=d00`3oool09BDf0<o@g@020<o@g@070=?ChP1[MHl0`/CB0<74
d@2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203QJFD0ffAT0:HiA031
a=80`/CA0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:c=P0_/3?0;g0c`80
_/3>00D0000009bLW03WinL0imkF0=J<00020=jD00040=Ik0036H`00_D80
0>nU0080mjd000P0mkD00?o>BP000000_/3>0;k0c`2n`<h0_/3?0;g0cQD0
_/3>0P2m`<h00`1[MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0
cP1[MHl0e]KT0P3Cdn000`3oool09BDf0?ooo`080?ooo`0;02DU=P3Cdn00
dm?P0=?Ch03Fe^@0JgF?0;k0c`2n`<h0YSU40>1VI@3QJVX0103SK6`30?oo
o`0404HN6P3oool0oooo0?ooo`@0hfa/00@0hFYZ0>1VI@2V>D@0_L3?0P2n
`<l10;k0cP40b/cH0@1VIWh0000706IVOP39b]P0][S80;Vlb`2j_</0^[c<
000000020>o_k`0C0=JL003FS000gY@00=J4003_Y@00gX`00;eJ003FL`00
ki`00?O_i`3gmoL0oooo0000002i_<`0^[_<0;Vlb`2j_</0^Kc<0;Vlb`0D
0;Vlc080^[c<00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?0;Zlb`2j
_</0JgF?0=SHi@80dm?Q00<0oooo06i]S`1^KHl0201^KHl03P0U9CH0dm?Q
0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<0:HiA03PJFP0hFe/0>AaK@3TLFl0
i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^00T0i75]0>5]K03P
JFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039b]P00@1VIWh0000906IVOP37bML0
];K70;Jhb02f^<T0][W900000024Q8@0inON0080kno_00L0aV/00?O6003_
]@00ki`00=j<003>J`00ii`000<0moOg00D000000;Jib@2g^<T0][W90;Ni
b@020;JhbA@0]kS90P2f^<T0101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV
0`3Hf>D20=SHiP80f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU
0=SHiP3oool02P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0
]kW90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_0>AdK`3T
M6l0AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Ji
b@2d]/L0alWG0@1VIWh0000306IVOP36b=L0];K700<0];K700<000000>o_
k`3_knl00P3_knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe
0?ogm`3oool0000001`0];K700D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cK
i`060=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU
=P0902DU=P<0g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0igEb0>Yf
L`3ZN7H00P3oool00`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo
0>YhMP3ZMW<0igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36
b=L0];K700<0];K700H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`08
0>ND003gilh0moOg0?Ogm`3_imH0moOg0?ooo`00000L0;Bfa`0306]eS`3E
e><0h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP09
0=GDh`1[MHl0];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0
jiR;0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3Y
O7P0jWUc0:HiA0040;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?800<0
/K?800H000000>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0
oooo00<0moOg00<0oooo0000002a/lP06`2a/lP00`1[MHl0kN_c0>WXl@0@
0>WXl@060>g[l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?
0;6cb02a/lP0YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0
lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V
>D@0102a/lP10<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`030:n^a`050000
002][Jd0moO_0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<000000:n^a`2_
[/L06P2_[/L00`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^
a`1[MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI25
3@3b^9h20?F@Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn
00000`1VIWh0`<7A0<O7e00_0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo
00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?oo
o`040?_ko03<bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L
]`3jjkL0n^Vf0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0
n]bg0?joY03oWhd0YSU4096HZP<0[:_40@37am@10<31d@40IVIn0000101V
IWh0`<7A0=;Bg`2e]<T_0:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR
0:BS_P2TXkh00P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0
Y:>n0080Y:>n00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2T
Xkh0]KC90=;Bg`30`M400@1VIWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0
/K34K`2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0
QhNK0=OHhP3lo?`0i>?X0=3@h03:b]X0K@2l_<l01P3:b]X0d=3P0>CSj03l
o?`0emSR08N7V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/
jnh0hN;[J`3Gf>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1H
EfP00080F5MX00<0IVIn09FDZ`3AdMh00P3lo?a]0?ooo`80o?cl00<0dM7N
09FDZ`1VIWh00P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW_`1/0:RW
_`0409FDZ`28Qid0IVIn06IVOP<0F5MX000505QGJ740IVIn1@1HEfP00001
\
\>"], "Graphics",
  CellLabel->"From In[9]:=",
  Evaluatable->False,
  ImageSize->{123, 57},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"CheckBox"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]=",
  CellTags->"CheckBox"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"RadioButton\"]", "ObjectName",
  CellTags->"RadioButton"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"text\" \[Rule] \"text label\"\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"selected\" \[Rule] False", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"RadioButton"],

Cell[TextData[{
  StyleBox["Events", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"action\" - ", "Program"],
  StyleBox["triggered when the radio button is clicked", "Text"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"RadioButton"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"RadioButton"],

Cell[TextData[{
  StyleBox["Widget[\"RadioButton\"]", "Output"],
  "s are always used as a group and must also be added to a ",
  StyleBox["ButtonGroup", "MR"],
  " widget, which is not a visual widget itself nor is it added to a parent \
or layout, but is responsible for ensuring that only one radio button is \
selected within its set of managed buttons."
}], "Text",
  CellTags->"RadioButton"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \ \
{\[IndentingNewLine]Widget["\<RadioButton\>", {"\<text\>"\  \[Rule] \ \
"\<Choice A\>", \ \[IndentingNewLine]"\<selected\>"\  \[Rule] \ True}, \ 
                Name -> "\<buttonA\>"], \
\[IndentingNewLine]Widget["\<RadioButton\>", {"\<text\>"\  \[Rule] \ \
"\<Choice B\>", \ \[IndentingNewLine]"\<selected\>"\  \[Rule] \ False}, \ 
                Name -> "\<buttonB\>"], \
\[IndentingNewLine]Widget["\<RadioButton\>", {"\<text\>"\  \[Rule] \ \
"\<Choice C\>", \[IndentingNewLine]\ "\<selected\>"\  \[Rule] \ False}, \ 
                Name -> "\<buttonC\>"], \
\[IndentingNewLine]Widget["\<ButtonGroup\>", \
{\[IndentingNewLine]WidgetReference["\<buttonA\>"], \
\[IndentingNewLine]WidgetReference["\<buttonB\>"], \
\[IndentingNewLine]WidgetReference["\<buttonC\>"]}]\[IndentingNewLine]}]\ \
\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"RadioButton"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"RadioButton"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000KB000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPL0h=oS
00L0c=3I09NZ_P1ENYd095N405EjW@2GZ[h0c=3I06D0h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPD0h=oS00/0g]kR0:Fe
a@0PE880KXn/0;W8e@3bm?D0_<_H072A[`0PE880YKG50=kNhP1S0>3Oh`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh50>3Oh`0;
0:Fea@1KPJ40]LC@0?Gem03gmoH0nOWh0?_knP3moO`0_<cI0625YP2U]LD0
1`3Pgn<300000080h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3Oh`<0
00000P3Pgn<00`000000h=oS0>3Oh`03000000<0h=oS0`0000070>3Oh`<0
0000=@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn103Pgn<03@3<d=T085B20;;1c@3alNl0lo?a0?Gem03gmoH0nOWh0?_k
nP3moO`0_<cI021DPP3<d=T01@3Pgn<01`000000h=oS0>3Oh`3Pgn<00000
0>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`050000003Pgn<0
00000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`030000003P
gn<0h=oS00<0h=oS00D000000>3Oh`3Pgn<0h=oS0000000d0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh40>3Oh`0=09NZ
_P1XRJH0k>cY0>o_k03alNl0lo?a0?Gem03gmoH0nOWh0?_knP3moO`0L96_
09NZ_P040>3Oh`030000003Pgn<0h=oS00@0h=oS00L000000>3Oh`3Pgn<0
h=oS0000003Pgn<0000000<0h=oS00D000000>3Oh`000000h=oS00000005
0>3Oh`030000003Pgn<0h=oS00H0h=oS00<000000>3Oh`3Pgn<0=`3Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn103Pgn<0
3@1ENYd0Zk[60>SXi@3/k>T0kno/0?7ak`3clo40mOGd0?OgmP3inOP0no_j
0;c;f01ENYd0103Pgn<00`000000h=oS0>3Oh`040>3Oh`070000003Pgn<0
h=oS0>3Oh`000000h=oS000000030>3Oh`050000003Pgn<000000>3Oh`00
00001@3Pgn<5000000@0h=oS00<000000>3Oh`3Pgn<0=`3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn103Pgn<03@0TEh@0
f]cJ0>GUhP3Xj>D0k>cY0>o_k03alNl0lo?a0?Gem03gmoH0nOWh0?;dm@0T
Eh@0103Pgn<00`000000h=oS0>3Oh`040>3Oh`8000000P3Pgn<00`000000
h=oS000000030>3Oh`050000003Pgn<000000>3Oh`0000000`3Pgn<00`00
0000h=oS000000030>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3O
h`3Pgn<0=`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn103Pgn<03@1ENYd0YkO10>;RgP3UiN80j>SU0>c/j@3_kn`0lO7_
0??cl@3emO@0moOf0;W8e@1ENYd0103Pgn<00`000000h=oS0>3Oh`040>3O
h`040000003Pgn<00000000000<0h=oS0`0000020>3Oh`030000003Pgn<0
h=oS00<000000`3Pgn<3000000D0h=oS00<000000>3Oh`3Pgn<0=`3Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn103Pgn<0
3@2GZ[h0I8JQ0>3Pf`3Rh]h0iNGR0>SXi@3/k>T0kno/0?7ak`3clo40mOGd
06j?[02GZ[h01@3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`000000
7@3Pgn<01@000000h=oS0>3Oh`3Pgn<0000003@0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0h=oS00d0c=3I021DPP2V
]Kl0h>3K0>;RgP3UiN80j>SU0>c/j@3_kn`0lO7_0;G4d00PE880c=3I00H0
h=oS0`0000020>3Oh`030000003Pgn<0h=oS00T0h=oS00<000000>3Oh`3P
gn<0403Pgn<3000003D0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOPD0h=oS00/0YKG505EjVP2V]Kl0h>3K0>;RgP3UiN80
j>SU0>c/j@2b`Ld0Fh6Q0:Fea@1S0>3Oh`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh50>3Oh`0;0=kNhP2U]LD085B206B6X@2W
]l40f]cJ0:^jaP1XRJH085B20:Fea@3Ng^80H`3Pgn<00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1`3Pgn<01`3<d=T0UjZn05Ej
W@0TEh@0EGZM09NZ_P3<d=T0I@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn1`3Pgn<01`3<d=T0UjZn05EjW@0TEh@0EGZM
09NZ_P3<d=T0I@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn1@3Pgn<02`3Ng^80YKG5021DPP1^Sj`0^LSE0?;dm@2lbmP0
L96_021DPP2U]LD0g]kR06<0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOPD0h=oS00/0YKG505^1X@2ea=00mOGd0?OgmP3i
nOP0no_j0?gmo02lc=T0H8FV0:Fea@070>3Oh`<000000P3Pgn<01@000000
h=oS0>3Oh`3Pgn<000000080h=oS0`0000020>3Oh`030000003Pgn<0h=oS
00<000000`3Pgn<3000000D0h=oS1@00000e0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh40>3Oh`0=0<c@f@0PE880//7=
0?7ak`3clo40mOGd0?OgmP3inOP0no_j0?gmo02lc=T085B20<c@f@050>3O
h`070000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003P
gn<0000000<0h=oS00D000000>3Oh`000000h=oS000000030>3Oh`030000
003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`000000h=oS
0>3Oh`020>3Oh`030000003Pgn<0h=oS0380h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0h=oS00d0UjZn06R9YP3/k>T0
kno/0?7ak`3clo40mOGd0?OgmP3inOP0no_j0?gmo01`TJl0UjZn00@0h=oS
00<000000>3Oh`3Pgn<0103Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3O
h`0000000`3Pgn<01@000000h=oS0000003Pgn<0000000D0h=oS00<00000
0>3Oh`3Pgn<01P3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0
h=oS0380h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP@0h=oS00d0EGZM0:^jaP3Xj>D0k>cY0>o_k03alNl0lo?a0?Gem03g
moH0nOWh0?_knP2lbmP0EGZM00@0h=oS00<000000>3Oh`3Pgn<0103Pgn<0
1`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<01@000000h=oS
0000003Pgn<0000000D0h=oS1@0000040>3Oh`030000003Pgn<0h=oS0080
h=oS00<000000>3Oh`3Pgn<0<P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn103Pgn<03@0TEh@0f]cJ0>GUhP3Xj>D0k>cY
0>o_k03alNl0lo?a0?Gem03gmoH0nOWh0?;dm@0TEh@0103Pgn<00`000000
h=oS0>3Oh`040>3Oh`8000000P3Pgn<00`000000h=oS000000030>3Oh`05
0000003Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS000000030>3O
h`030000003Pgn<0h=oS0080h=oS1@00000e0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh40>3Oh`0=05EjW@2W]l40h^;N
0>GUhP3Xj>D0k>cY0>o_k03alNl0lo?a0?Gem03gmoH0^LSE05EjW@040>3O
h`030000003Pgn<0h=oS00@0h=oS00@000000>3Oh`00000000000`3Pgn<3
00000080h=oS00<000000>3Oh`3Pgn<00`0000030>3Oh`<000001@3Pgn<0
0`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS0380h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0h=oS00d0UjZn
06B6X@3Ph=/0h^;N0>GUhP3Xj>D0k>cY0>o_k03alNl0lo?a0?Gem01^Sj`0
UjZn00D0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000001`0h=oS
00<000000>3Oh`3Pgn<00P3Pgn<00`000000h=oS0>3Oh`0b0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh40>3Oh`0=0<c@
f@0PE880Y[Fo0>3Pf`3Rh]h0iNGR0>SXi@3/k>T0kno/0?7ak`2ea=0085B2
0<c@f@060>3Oh`<000000P3Pgn<00`000000h=oS0>3Oh`090>3Oh`030000
003Pgn<0h=oS00h0h=oS1@00000e0>3Oh`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh50>3Oh`0;0:Fea@1ENYX0Y[Fo0>3Pf`3R
h]h0iNGR0>SXi@3/k>T0//7=05^1X@2U]LD0H`3Pgn<00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@3Pgn<02`3Ng^80YKG5021D
PP1TQZ40YkO10=[LfP2[^/H0J8VV021DPP2U]LD0g]kR06<0h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPL0h=oS00L0c=3I
09NZ_P1ENYd095N405EjW@2GZ[h0c=3I06D0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQD0h=oS02X000000>3Oh`000000
h=oS0000003Pgn<000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`00
0000h=oS0000003Pgn<000000>3Oh`000000h=oS0000003Pgn<000000>3O
h`000000h=oS0000003Pgn<000000>3Oh`000000h=oS0000003Pgn<00000
0>3Oh`000000h=oS0000003Pgn<200000380h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPL0h=oS00L0c=3I09NZ_P1ENYd0
95N405EjW@2GZ[h0c=3I06D0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOPD0h=oS00/0g]kR0:Fea@0PE880KY2]0;[9eP3c
mOH0_<_I072A[`0PE880YKG50=kNhP050>3Oh`030000003Pgn<0h=oS02P0
h=oS00<000000>3Oh`3Pgn<0<03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn1@3Pgn<02`2U]LD0G86R0;K5dP3gmoH0nOWh
0?[jn@3lo?/0oOgm0;c<f@1PQJH0YKG500L0h=oS0`0000020>3Oh`050000
003Pgn<0h=oS0>3Oh`0000000P3Pgn<300000080h=oS00<000000>3Oh`3P
gn<00`0000030>3Oh`<000001@3Pgn<00`000000h=oS0>3Oh`030>3Oh`03
0000003Pgn<0h=oS0340h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOP@0h=oS00d0c=3I021DPP2c`ll0lo?a0?Gel`3gmoH0
nOWh0?[jn@3lo?/0oOgm0;c<f@0PE880c=3I00@0h=oS0P0000030>3Oh`03
0000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<01@000000
h=oS0000003Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`00
0000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS00<0h=oS0P00000b0>3O
h`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh40>3O
h`0=09NZ_P1YRjL0kno/0?7ak`3Xk^H0V/bH02BF902HbIL0k_?]0?cln`3m
oOd0L96_09NZ_P040>3Oh`030000003Pgn<0h=oS00@0h=oS00L000000>3O
h`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00D000000>3Oh`000000h=oS
000000050>3Oh`030000003Pgn<0h=oS00L0h=oS1@00000d0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh40>3Oh`0=05Ej
W@2^_/P0k>cY0>o_k02PdYh0:ZPW02:R800CTQ00V<RG0?[jn@3lo?/0_<_I
05EjW@040>3Oh`030000003Pgn<0h=oS00@0h=oS00L000000>3Oh`3Pgn<0
h=oS0000003Pgn<0000000<0h=oS00D000000>3Oh`000000h=oS00000005
0>3Oh`D000001@3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`000000
<P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
103Pgn<03@0TEh@0gn7O0>[ZiP3/k>T0CKm:04;3?`0h^CD08J4Q02JF8`3i
nOP0n_[i0??emP0TEh@0103Pgn<00`000000h=oS0>3Oh`040>3Oh`800000
0P3Pgn<00`000000h=oS000000030>3Oh`050000003Pgn<000000>3Oh`00
00000`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0h=oS00@0
h=oS00<000000>3Oh`000000=@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn103Pgn<03@1ENYd0Zk[50>OWh`3Zj^H0ZMbV
05GED@13`cl0:JPV09[<V03gmoH0nOWh0;[9eP1ENYd0103Pgn<00`000000
h=oS0>3Oh`040>3Oh`040000003Pgn<00000000000<0h=oS0`0000020>3O
h`030000003Pgn<0h=oS00<000000`3Pgn<3000000L0h=oS00<000000>3O
h`0000000P3Pgn<00`000000h=oS0>3Oh`0`0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh40>3Oh`0=09NZ_P1VQj<0iNGQ
0>OWh`3Rj=h0ZMbV04foBP2PdYh0j>kV0?Gel`3gmoH0KY2]09NZ_P050>3O
h`070000003Pgn<0h=oS0>3Oh`000000h=oS0000000N0>3Oh`030000003P
gn<0000003D0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOP@0h=oS00d0c=3I021DPP2Y^L<0iNGQ0>OWh`3Zj^H0k>cY0>o_
k03alNl0lo?a0;K5dP0PE880c=3I00@0h=oS00<000000>3Oh`0000000P00
00020>3Oh`030000003Pgn<0h=oS00T0h=oS00<000000>3Oh`3Pgn<04@3P
gn<01@000000h=oS0>3Oh`3Pgn<000000380h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPD0h=oS00/0YKG505MlW02Y^L<0
iNGQ0>OWh`3Zj^H0k>cY0>o_k02c`ll0G86R0:Fea@1S0>3Oh`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh50>3Oh`0;0=kNhP2U
]LD085B206J7X`2[^/D0gn7O0:jnb01YRjL085B20:Fea@3Ng^801@3Pgn<0
0`000000h=oS0>3Oh`0X0>3Oh`030000003Pgn<0h=oS0300h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPL0h=oS00L0c=3I
09NZ_P1ENYd095N405EjW@2GZ[h0c=3I06D0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQD0h=oS02X000000>3Oh`000000
h=oS0000003Pgn<000000>3Oh`000000h=oS0000003Pgn<000000>3Oh`00
0000h=oS0000003Pgn<000000>3Oh`000000h=oS0000003Pgn<000000>3O
h`000000h=oS0000003Pgn<000000>3Oh`000000h=oS0000003Pgn<00000
0>3Oh`000000h=oS0000003Pgn<200000380h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000306IVOP3gmoT0V9RW07D0MgNB0@2HV:L10?Ogn@40IVIn0000
0`1VIWh0moOi0;bmc@1f0;bmc@40moOi0@1VIWh0000306IVOP3gmoT0i>?S
07H0i>?S0@3gmoT106IVOP0000<0IVIn0?3am03oool0;`3oool00`3Thn<0
W:Bi06]eS`0306]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CS
h`3oool0oooo0>CSh`2LY;T406]eS`0406afT01[MHl0K7J@06afT0T0JgF?
00H0W:Bi0>CSh`3oool0oooo0>cZjP2LY;T40:HiA0040:LjA02V>D@0YcY4
0:LjA0T0YSU400<0W:Bi0>cZjP3oool00`3oool10?3am040IVIn00005P1V
IWh0h^7R0?_lo03kno`0nocm0?cko@3knod0nocm0?_lo03lo?d0o?cl0?ck
o@3lo?`0o?_l0?clo03ko?`0o?cl0?_lo@3lno`0o?cm0?_ko@3ko?`20?cl
o0040?clo@3lo?`0no_m0?cloA@0o?_l0P3ko?`00`2LY;T0JgF?08F9/00@
08F9/00606]eS`2LY;T0nocm0?_lo@2LY;T0JgF?4@25RK001P1[MHl0W:Bi
0?_lo03kno`0W:Bi0:HiA140ZSaE00L0YSU409bT^@3ko?`0o?cl0?cko@3k
o?d0h^7R0040IVIn0000101VIWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kgn03g
moT0moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3gmoT0
103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0moOi01<0moOi0P3f
moT00`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[MHl0
QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ3@36
EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@0106IV
OP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@000000060?7am03`l_D0
lO7d0?7bm03`l_@0lO7d5P3`lOD00`1[MHl0/[G@0:NX`P0@0:NX`P060;:e
d01[MHl0l?7d0?3am01[MHl0/[G@4@2WZ<801@2b]M00JgF?0?3am@3al_@0
YSU40080`U9K00<0beAI0<eIGP3=FEh02`3=FEh0103;E5T0`U9K0<9BF`2V
>D@20?3am0030?7am03`l_@0g]gQ0040IVIn00001`1VIWh0g=_P0>[[l03Z
jo00j^c`0>W[k`0000000P3WinL20=kNgP80inOW00<0ikf40>OWi`3WinL0
0`3WinL20>o_k`040000003Zjo00j^_`0>[[k`80j^_`00<0j^__0>[[l03Z
jo004P3Zjo020>[/l00406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk60:b^
aP2][/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`0406]eS`2f^M40[Jk6
0:f^aP`0oooo0P2][/H00`2/[/H0][WA06]eS`020>[[l0050:HiA03=FEh0
beAI0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK0<]DF@3=FEh0YSU40>[[k`3Z
jo000P3Zjnl10=cKh040IVIn0000101VIWh0fMWO0>?UjP3Si>X20>?Uj`05
0000002<S8`0g]kN0>OWi`3Ng]h00P3WinL00`36H`00inOW0>OWi`020>OW
i`070>o_i`3_knl0kno_0000003Si>X0hnC[0>?UjP020>?TjP030>?Tj`3S
iN/0hnG[0180hnG[0P3Si>X01@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?
00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bn
e080/[;:00<0oooo02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[
0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0
e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0
000306IVOP3Gf=h0g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OFcP02
0>OWi`050<ik003_U100inOW0>ONaP3_S1000`3_knl01`000000g=kV0=cN
i@3Lg^D0g=kV0=cNi@3Lg^H05P3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo
00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0
JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;Ri
cP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP
00<0oooo1@3FGf<30?ooo`0505<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D0
0`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>00
2@000000S8b<0>OWi`3WinL0ikF40=IJ003FQ000olh00<iS00020=i[0005
0>neS03_knl0kno_0>o_k`0000000P3Ef>40103Een00e]SP0=KHh@3Fen4D
0=KGh080e]SP00D0JgF?0<?5f@2l_M40_;gA0?ooo`0702DU=PL0_;gA00H0
`lGI06]eS`3Ef>40eMSQ06]eS`33aMT20;bmd@030?ooo`0U9CH0_;gA00L0
_;gA00<0oooo02DU=P2l_M400P2l_M401@33aMT0JgF?0=KGh03Een40YSU4
0080eEeP00<0f61Q0=UQHP167QX00`3oool30=UQHP<0oooo00<0AQhJ0=UQ
HP3HH6400P3EGF001P2V>D@0e]SP0=GHh@3Een00eMSQ0=GFg@40IVIn0000
1`1VIWh0d]CM0<oBg03@d]`0d=;M0=3Bg00000000`3WinL0303Wg/h0aTX0
0?O>003_[@00kkD00<i[0036FP00aV/00=j<BP3WY@00knO>000000<0d=;L
00<0cm;L0=3Bg03?d]`0503@d]`20<oBg@0306]eS`38bM/0`lCF0100`lCF
00H0b<WK06]eS`3@d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U9CH0`lCF
00L0`lCF00<0oooo02DU=P33a=H00P33a=H01`38bM/0JgF?0<oBg03?d]`0
YSU40=MOG`3IHF800`3LIFD01@167QX0oooo0?ooo`3oool0g6EU00<0oooo
00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?d]`1
0=;Dg@40IVIn0000701VIWh0d=;K0<_=f03:cMT0blkH0<[=f0000000ilJ]
0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU003FS000cV/00>O6003oeP00
knoW0>o_k`000000blgH0<_=f@3:cMT0blkH0<[=f03;cMPD0<_=f@80blkI
00<0JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9
f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH5
0<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]e
S`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo
0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0
b/kH0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@0
1P000000a/K60>ONeP3>N`00ijd00>ne0080ijD000<0eY@00<ic003FU000
0P3gaP020?Ogm`0400000035b=@0aLOD0<G7e0<0aLOE5034amD20<C8e003
06]eS`3@dN00bl_L0100bl_L00H0d=7P06]eS`34am@0a<OD06]eS`3@dN02
0<_;g0030?ooo`0U9CH0bl_L00L0bl_L00<0oooo02DU=P3;bm`00P3;bm`0
1`3@dN00JgF?0<G7e034am@0YSU40=]TI03OIF@01@3PJVP01@167QX0oooo
0?ooo`3oool0AQhJ00D0h6YX00@0gfET0=]TI02V>D@0a<SE0P34b=@10<G7
e@40cloJ0@1VIWh0000406IVOP3<c]X0`/CB0<74d@80`LCB00H000000>OW
i`3WinL0inOW0=J4003_]@020>NU00080=J4003>J`00ijd00?Ne003g_@00
kno_0?Ogm`0000030<74dP030<;4d@31a=80`LCB01@0`LCA0P31a=800`1[
MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?
d=d00`3oool09BDf0<o@g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M00L0
dm?R06]eS`32a=80`LCA0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/J@08
0>5YI@3KI6@0YSU40<74dP32a=40`LCA0<74dP3<c]X106IVOP0000@0IVIn
0<[<f02n`<l0_L3?0P2n`<h01@000000W9bL0>OWi`3Wg]H0eX`00080gY@0
00@0eW/00<IS002m@P00kjD00P3g[@00203g]@00oli:0000002n`<h0_/3?
0;k0cP2n`<l0_L3>5@2n`<h20;g0cP0306]eS`3Fe^@0dm?P0100dm?P00H0
e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo00P0
oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0h6IU
0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo103SK6`0103QJVX0
h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:f02f
^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<003NU000eX@00>nU
003NS000_EX00=Ic003_W000mnoW0?Ogm`3oool000000;Vlc02j^l`0^Kc;
0;Zlb`2i_<`0^Kc;01@0^Kc<0P2j_<`00`1[MHl0f=SU0=?Ch@0@0=?Ch@06
0=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU0P3Cdn400`3oool0KVf?06i]S`08
06i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0JgF?0;Zlb`2j_<`0YSU40>1Y
J03QKF`0i75]0>AaK`3TL6h30?ooo`0304HN6P3TL6h0AQhJ00<0oooo0P3T
L6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<0;Zkc02i_</0][S80<W:f00106IV
OP0000T0IVIn0<O9e`2d]/L0][S80;Jhb@2f^LT0000008B4Q03Wimh00P3_
knl01`36J`00mlH00>ne003_W000gX`00<i[003WW0000`3gmoL01@000000
][W90;Nhb@2f^LT0]kW90080][S9502g^<T20;Jhb@0406]eS`3Fe^@0f=SU
0=SHiP<0f=SU1@3Hf>H30=SHi@80f=SV0P3Hf>D02@3Fe^@0JgF?0;Nhb@2g
^<T0JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]S`0=02DU=P3Hf>H0f=SU0=SH
i@3Fe^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3TM6l0ig5_0>AdK`030?ooo`05
04HN6P3TM6l0i7A_0>AdK`167QX00`3oool02P3TM6l0ig5_0>AdK`3TKVd0
YSU40;Jib@2f^<T0][W90;Bfa`37bML106IVOP0000<0IVIn0<K8e`2d]/L0
0`2d]/L00`000000kno_0>o_k`020>o_k`0;0>N]003gaPP0ijD00>ND003W
S000knOF0=jD>@3_e[D0ooOg0?ooo`000000702d]/L01@1[MHl0eMGS0=cK
i`3LfnL0gM_W00h0g=_W00H0eMGS06]eS`2d]/L0];K706]eS`3EeN<20=cK
i`030=gKi`0U9CH09BDf00T09BDf0`3LfnL02@3EeN<0JgF?0;Bfa`2d]/L0
YSU40>McK`3WMG80jWIc0>YhMP020?ooo`0304HN6P3YOWP0jGih00<0jGih
00P0AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80ig=_0:HiA0@0];K70@36b=L1
06IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L01P000000S8b<0>o_k`3_knl0
ilik0>o_k`80moOg00P0ii@00?OWcP3gmoL0moOg0>oWeP3gmoL0oooo0000
01`0];K700<0JgF?0=GDh`3PgnX0403PgnX01P3Ee><0JgF?0;Bfa`2d]/L0
JgF?0=GDha40h=oZ00T0eMCS06]eS`2d]/L0];K70:HiA03ZNG<0jGah0>n1
NP3bRH400P167QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<0>fGRP3[V8/00P16
7QX01@3bRH40kh5j0>UlN03ZNG<0YSU400@0];K70@36b=L106IVOP0000<0
IVIn0<K8e`2a/lP00`2a/lP01P000000kno_0>o_k`3_knl0moO_0>o_k`80
moOg00<0mnO60?Ogm`3oool00`3gmoL00`3oool000000;6cb00K0;6cb003
06]eS`3]jo<0jNSa0100jNSa00H0kN_c06]eS`2a/lP0/K?806]eS`3]jo<A
0>WXl@0I0>g[l`1[MHl0/K?80;6cb02V>D@0lH1e0?24O03eS8@0mif>0?:[
UP3a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03bZiH0mif>
0?F<Q03`Q7`0lH1e0:HiA0040;6cb040a/SG0@1VIWh0000306IVOP36b=L0
^;O?00<0[jk700D000000:f][@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3o
ool00`000000[jk70:n^a`0J0:n^a`0306]eS`3BdN<0l_7g0100l_7g00H0
d]7S06]eS`2_[/L0[jk706]eS`3BdN<A0?;am`060=;Ah`1[MHl0[jk70:n^
a`2V>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0m8Ym0:HiA02_[/L00P2_[/L1
0;Rgc`40a/SG0@1VIWh0000306IVOP30`M40alOD02l0[:_400@0Q8bR06]e
S`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a00408B<XP1[
MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01`2AV:X0
YSU40?nOS@3n_j@0n]bg0?[[]`3jjKH00P3ijKH0103jjKH0nNVf0?WY]P3j
jKH20?WY]P060?[[]`3jg;L0o[nT0?nOS@2V>D@0TIRZ0`2/Zl@10<O7e040
`<7A0@1VIWh0000406IVOP30`M40d];O0;FdbBl0Y:>n00<0Q8bR06]eS`1[
MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP1[MHl0JgF?00l0
JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80YSU40:HiA00?0:HiA007
08B<XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31d@0106IVOP0000H0IVIn0:RW
_`3Vi^d0d];P0;blc`2a/<A_0:RW_`050;6`a02l_<l0d];P0>KVk@2XYkl0
0@1VIWh0000705QGJ027Qi/0emSR0?clo03ThnP0d=3P0<[:fP1]0;blc`06
0<[:fP3@d>00i>?X0?clo03Gf>80QhNK0@1HEfP0000805QGJ01VIWh0UIB[
0=OHhP3lo?`0l_7c0>c[kP3Qh^][0=OHhP070>7Rj`3/jnh0l_7c0?clo03G
f>80UIB[06IVOP0105QGJ0000P1HEfP00`1VIWh0UIB[0=7AgP020?clo6d0
oooo0P3lo?`00`3AdMh0UIB[06IVOP0205QGJ0000`1HEfP206IVOP0308R7
W@2EU:/0Z:No06`0Z:No00@0UIB[08R7W@1VIWh0IVIn0`1HEfP000D0F5MX
L@1VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[11]:=",
  Evaluatable->False,
  ImageSize->{123, 109},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"RadioButton"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]=",
  CellTags->"RadioButton"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"Label\"]", "ObjectName",
  CellTags->"Label"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"text\" \[Rule] \"text label\"", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"Label"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"Label"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Label\>", \ {"\<text\>" -> \
"\<Parameter:\>"}]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"Label"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"Label"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000<B000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000
1P3Pgn<2000000040>3Oh`000000h=oS000000@0h=oS0P000000103Pgn<0
00000>3Oh`0000020>3Oh`040000003Pgn<0h=oS00000080h=oS0`000002
0>3Oh`8000000P3Pgn<300000080h=oS00D000000>3Oh`3Pgn<0h=oS0000
00110>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1V
IWh0000000D0h=oS00<000000>3Oh`3Pgn<00P0000000`3Pgn<000000>3O
h`020>3Oh`030000003Pgn<0h=oS0080000000D0h=oS0000003Pgn<0h=oS
000000020>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`000000
0P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`000000A@3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn000000050>3O
h`070000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`070000003P
gn<0h=oS0>3Oh`000000h=oS000000020>3Oh`060000003Pgn<0h=oS0000
003Pgn<000001@3Pgn<010000000h=oS0>3Oh`0000050>3Oh`030000003P
gn<0h=oS04<0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOP@000000`3Pgn<4000000030>3Oh`000000h=oS00<0h=oS1000
00001@3Pgn<000000>3Oh`3Pgn<000000080h=oS00<000000>3Oh`000000
10000000103Pgn<000000>3Oh`3Pgn<5000000030>3Oh`000000h=oS04@0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP00
00000`3Pgn<00`000000h=oS000000030>3Oh`040000003Pgn<000000000
0080h=oS00H000000>3Oh`3Pgn<0h=oS0000003Pgn<2000000070>3Oh`00
000000000>3Oh`000000h=oS000000030>3Oh`030000003Pgn<000000080
h=oS00H000000>3Oh`3Pgn<0h=oS0000003Pgn<2000004@0h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP0000000`3Pgn<0
0`000000h=oS0>3Oh`0300000080h=oS00<000000>3Oh`0000000P3Pgn<3
00000080h=oS00<000000>3Oh`0000000P3Pgn<010000000h=oS0>3Oh`3P
gn<3000000040>3Oh`000000000000000080h=oS0`0000020>3Oh`050000
003Pgn<000000>3Oh`000000@@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn000000030>3Oh`030000003Pgn<0h=oS01d0
h=oS00<000000>3Oh`3Pgn<0C03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn1000000P0>3Oh`030000003Pgn<0h=oS04`0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000306IVOP3gmoT0V9RW07D0MgNB
0@2HV:L10?Ogn@40IVIn00000`1VIWh0moOi0;bmc@1f0;bmc@40moOi0@1V
IWh0000306IVOP3gmoT0i>?S07H0i>?S0@3gmoT106IVOP0000<0IVIn0?3a
m03oool0;`3oool00`3Thn<0W:Bi06]eS`0306]eS`0406afT01[MHl0K7J@
06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>CSh`2LY;T406]eS`0406af
T01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>cZjP2LY;T4
0:HiA0040:LjA02V>D@0YcY40:LjA0T0YSU400<0W:Bi0>cZjP3oool00`3o
ool10?3am040IVIn00005P1VIWh0h^7R0?_lo03kno`0nocm0?cko@3knod0
nocm0?_lo03lo?d0o?cl0?cko@3lo?`0o?_l0?clo03ko?`0o?cl0?_lo@3l
no`0o?cm0?_ko@3ko?`20?clo0040?clo@3lo?`0no_m0?cloA@0o?_l0P3k
o?`00`2LY;T0JgF?08F9/00@08F9/00606]eS`2LY;T0nocm0?_lo@2LY;T0
JgF?4@25RK001P1[MHl0W:Bi0?_lo03kno`0W:Bi0:HiA140ZSaE00L0YSU4
09bT^@3ko?`0o?cl0?cko@3ko?d0h^7R0040IVIn0000101VIWh0h>3Q0?Kg
n@3gmoT20?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0
m_Oi0?Ogn@3fmoT00P3gmoT0103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kg
n03gmoT0moOi01<0moOi0P3fmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9
/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0
YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Og
n@3gmoP0moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`
l_@@000000060?7am03`l_D0lO7d0?7bm03`l_@0lO7d5P3`lOD00`1[MHl0
/[G@0:NX`P0@0:NX`P060;:ed01[MHl0l?7d0?3am01[MHl0/[G@4@2WZ<80
1@2b]M00JgF?0?3am@3al_@0YSU40080`U9K00<0beAI0<eIGP3=FEh02`3=
FEh0103;E5T0`U9K0<9BF`2V>D@20?3am0030?7am03`l_@0g]gQ0040IVIn
00001`1VIWh0g=_P0>[[l03Zjo00j^c`0>W[k`0000000P3WinL20=kNgP80
inOW00<0ikf40>OWi`3WinL00`3WinL20>o_k`040000003Zjo00j^_`0>[[
k`80j^_`00<0j^__0>[[l03Zjo004P3Zjo020>[/l00406]eS`2f^M40[Jk6
0:f^aPP0oooo00<0[Jk60:b^aP2][/H00`2][/H00`2/[/H0][WA06]eS`02
0>[[k`0406]eS`2f^M40[Jk60:f^aP`0oooo0P2][/H00`2/[/H0][WA06]e
S`020>[[l0050:HiA03=FEh0beAI0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK
0<]DF@3=FEh0YSU40>[[k`3Zjo000P3Zjnl10=cKh040IVIn0000101VIWh0
fMWO0>?UjP3Si>X20>?Uj`050000002<S8`0g]kN0>OWi`3Ng]h00P3WinL0
0`36H`00inOW0>OWi`020>OWi`070>o_i`3_knl0kno_0000003Si>X0hnC[
0>?UjP020>?TjP030>?Tj`3SiN/0hnG[0180hnG[0P3Si>X01@1[MHl0_;kD
0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0
JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH02@0U9CH3
0;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?oo
o`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ
0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0g=kV00D00000
0>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW0>ONaP3_S100
0`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H05P3Lg^D01@1[
MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh0
1P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh0
1`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V
>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`0505<U803DGF40
dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn
0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0ikF40=IJ003F
Q000olh00<iS00020=i[00050>neS03_knl0kno_0>o_k`0000000P3Ef>40
103Een00e]SP0=KHh@3Fen4D0=KGh080e]SP00D0JgF?0<?5f@2l_M40_;gA
0?ooo`0702DU=PL0_;gA00H0`lGI06]eS`3Ef>40eMSQ06]eS`33aMT20;bm
d@030?ooo`0U9CH0_;gA00L0_;gA00<0oooo02DU=P2l_M400P2l_M401@33
aMT0JgF?0=KGh03Een40YSU40080eEeP00<0f61Q0=UQHP167QX00`3oool3
0=UQHP<0oooo00<0AQhJ0=UQHP3HH6400P3EGF001P2V>D@0e]SP0=GHh@3E
en00eMSQ0=GFg@40IVIn00001`1VIWh0d]CM0<oBg03@d]`0d=;M0=3Bg000
00000`3WinL0303Wg/h0aTX00?O>003_[@00kkD00<i[0036FP00aV/00=j<
BP3WY@00knO>000000<0d=;L00<0cm;L0=3Bg03?d]`0503@d]`20<oBg@03
06]eS`38bM/0`lCF0100`lCF00H0b<WK06]eS`3@d]`0d=;L06]eS`38bM/2
0<?4eP030?ooo`0U9CH0`lCF00L0`lCF00<0oooo02DU=P33a=H00P33a=H0
1`38bM/0JgF?0<oBg03?d]`0YSU40=MOG`3IHF800`3LIFD01@167QX0oooo
0?ooo`3oool0g6EU00<0oooo00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0
YSU40=3Bg@80d=;L0@3?d]`10=;Dg@40IVIn0000701VIWh0d=;K0<_=f03:
cMT0blkH0<[=f0000000ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU
003FS000cV/00>O6003oeP00knoW0>o_k`000000blgH0<_=f@3:cMT0blkH
0<[=f03;cMPD0<_=f@80blkI00<0JgF?0<_<gP38b]T02038b]T00`38bMT0
b<[I0<S:f@030<S:f@040<S9f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<
gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0
b<[I0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3P
IVD00P3NIfL00`167QX0oooo0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1V
I@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI0@3@d]/106IVOP0000<0
IVIn0<o?fP35b=@00`35b=@01P000000a/K60>ONeP3>N`00ijd00>ne0080
ijD000<0eY@00<ic003FU0000P3gaP020?Ogm`0400000035b=@0aLOD0<G7
e0<0aLOE5034amD20<C8e00306]eS`3@dN00bl_L0100bl_L00H0d=7P06]e
S`34am@0a<OD06]eS`3@dN020<_;g0030?ooo`0U9CH0bl_L00L0bl_L00<0
oooo02DU=P3;bm`00P3;bm`01`3@dN00JgF?0<G7e034am@0YSU40=]TI03O
IF@01@3PJVP01@167QX0oooo0?ooo`3oool0AQhJ00D0h6YX00@0gfET0=]T
I02V>D@0a<SE0P34b=@10<G7e@40cloJ0@1VIWh0000406IVOP3<c]X0`/CB
0<74d@80`LCB00H000000>OWi`3WinL0inOW0=J4003_]@020>NU00080=J4
003>J`00ijd00?Ne003g_@00kno_0?Ogm`0000030<74dP030<;4d@31a=80
`LCB01@0`LCA0P31a=800`1[MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0
`/CB0<;4dP1[MHl0dm?R0P3?d=d00`3oool09BDf0<o@g@070<o@g@030?oo
o`0U9CH0cm3M0080cm3M00L0dm?R06]eS`32a=80`LCA0:HiA03KI6@0hFUU
00D0h6aY1@3oool50>1/J@080>5YI@3KI6@0YSU40<74dP32a=40`LCA0<74
dP3<c]X106IVOP0000@0IVIn0<[<f02n`<l0_L3?0P2n`<h01@000000W9bL
0>OWi`3Wg]H0eX`00080gY@000@0eW/00<IS002m@P00kjD00P3g[@00203g
]@00oli:0000002n`<h0_/3?0;k0cP2n`<l0_L3>5@2n`<h20;g0cP0306]e
S`3Fe^@0dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?C
h0030?ooo`0U9CH0oooo00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[
MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3o
ool0oooo103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P1
06IVOP0000L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0
eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3o
ool000000;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;01@0^Kc<0P2j_<`00`1[
MHl0f=SU0=?Ch@0@0=?Ch@060=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU0P3C
dn400`3oool0KVf?06i]S`0806i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0
JgF?0;Zlb`2j_<`0YSU40>1YJ03QKF`0i75]0>AaK`3TL6h30?ooo`0304HN
6P3TL6h0AQhJ00<0oooo0P3TL6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<0;Zk
c02i_</0][S80<W:f00106IVOP0000T0IVIn0<O9e`2d]/L0][S80;Jhb@2f
^LT0000008B4Q03Wimh00P3_knl01`36J`00mlH00>ne003_W000gX`00<i[
003WW0000`3gmoL01@000000][W90;Nhb@2f^LT0]kW90080][S9502g^<T2
0;Jhb@0406]eS`3Fe^@0f=SU0=SHiP<0f=SU1@3Hf>H30=SHi@80f=SV0P3H
f>D02@3Fe^@0JgF?0;Nhb@2g^<T0JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]
S`0=02DU=P3Hf>H0f=SU0=SHi@3Fe^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3T
M6l0ig5_0>AdK`030?ooo`0504HN6P3TM6l0i7A_0>AdK`167QX00`3oool0
2P3TM6l0ig5_0>AdK`3TKVd0YSU40;Jib@2f^<T0][W90;Bfa`37bML106IV
OP0000<0IVIn0<K8e`2d]/L00`2d]/L00`000000kno_0>o_k`020>o_k`0;
0>N]003gaPP0ijD00>ND003WS000knOF0=jD>@3_e[D0ooOg0?ooo`000000
702d]/L01@1[MHl0eMGS0=cKi`3LfnL0gM_W00h0g=_W00H0eMGS06]eS`2d
]/L0];K706]eS`3EeN<20=cKi`030=gKi`0U9CH09BDf00T09BDf0`3LfnL0
2@3EeN<0JgF?0;Bfa`2d]/L0YSU40>McK`3WMG80jWIc0>YhMP020?ooo`03
04HN6P3YOWP0jGih00<0jGih00P0AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80
ig=_0:HiA0@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L0
1P000000S8b<0>o_k`3_knl0ilik0>o_k`80moOg00P0ii@00?OWcP3gmoL0
moOg0>oWeP3gmoL0oooo000001`0];K700<0JgF?0=GDh`3PgnX0403PgnX0
1P3Ee><0JgF?0;Bfa`2d]/L0JgF?0=GDha40h=oZ00T0eMCS06]eS`2d]/L0
];K70:HiA03ZNG<0jGah0>n1NP3bRH400P167QX01`3[V8/0jY^<0>fGRP3[
V8/0jY^<0>fGRP3[V8/00P167QX01@3bRH40kh5j0>UlN03ZNG<0YSU400@0
];K70@36b=L106IVOP0000<0IVIn0<K8e`2a/lP00`2a/lP01P000000kno_
0>o_k`3_knl0moO_0>o_k`80moOg00<0mnO60?Ogm`3oool00`3gmoL00`3o
ool000000;6cb00K0;6cb00306]eS`3]jo<0jNSa0100jNSa00H0kN_c06]e
S`2a/lP0/K?806]eS`3]jo<A0>WXl@0I0>g[l`1[MHl0/K?80;6cb02V>D@0
lH1e0?24O03eS8@0mif>0?:[UP3a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a
/Y/0kKBK0>beW03bZiH0mif>0?F<Q03`Q7`0lH1e0:HiA0040;6cb040a/SG
0@1VIWh0000306IVOP36b=L0^;O?00<0[jk700D000000:f][@3gmnl0moOg
0>o_k`060?Ogm`80ooOg0P3oool00`000000[jk70:n^a`0J0:n^a`0306]e
S`3BdN<0l_7g0100l_7g00H0d]7S06]eS`2_[/L0[jk706]eS`3BdN<A0?;a
m`060=;Ah`1[MHl0[jk70:n^a`2V>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0
m8Ym0:HiA02_[/L00P2_[/L10;Rgc`40a/SG0@1VIWh0000306IVOP30`M40
alOD02l0[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]e
S`24S:820:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[
MHl0Q8bR0P2/Zl@01`2AV:X0YSU40?nOS@3n_j@0n]bg0?[[]`3jjKH00P3i
jKH0103jjKH0nNVf0?WY]P3jjKH20?WY]P060?[[]`3jg;L0o[nT0?nOS@2V
>D@0TIRZ0`2/Zl@10<O7e040`<7A0@1VIWh0000406IVOP30`M40d];O0;Fd
bBl0Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS
_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24
S:80YSU40:HiA00?0:HiA00708B<XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31
d@0106IVOP0000H0IVIn0:RW_`3Vi^d0d];P0;blc`2a/<A_0:RW_`050;6`
a02l_<l0d];P0>KVk@2XYkl00@1VIWh0000705QGJ027Qi/0emSR0?clo03T
hnP0d=3P0<[:fP1]0;blc`060<[:fP3@d>00i>?X0?clo03Gf>80QhNK0@1H
EfP0000805QGJ01VIWh0UIB[0=OHhP3lo?`0l_7c0>c[kP3Qh^][0=OHhP07
0>7Rj`3/jnh0l_7c0?clo03Gf>80UIB[06IVOP0105QGJ0000P1HEfP00`1V
IWh0UIB[0=7AgP020?clo6d0oooo0P3lo?`00`3AdMh0UIB[06IVOP0205QG
J0000`1HEfP206IVOP0308R7W@2EU:/0Z:No06`0Z:No00@0UIB[08R7W@1V
IWh0IVIn0`1HEfP000D0F5MXL@1VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  Evaluatable->False,
  ImageSize->{123, 49},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Label"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]=",
  CellTags->"Label"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"TextField\"]", "ObjectName",
  CellTags->"TextField"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"text\" \[Rule] \"text content\"\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"enabled\" \[Rule] True", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"TextField"],

Cell[TextData[{
  StyleBox["Events", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"action\" - ", "Program"],
  StyleBox["triggered when ", "Text"],
  StyleBox["\[ReturnKey]", "KeyboardChars"],
  StyleBox[" is pressed", "Text"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"TextField"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"TextField"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<TextField\>", \ {"\<text\>" -> \
"\<Enter text here\>"}]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"TextField"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"TextField"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000=R000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0YJbb
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;80
L@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn0:F//P1a0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0YJbb00D0oooo00<000000?ooo`3oool0J@3oool0102U
[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P05
0?ooo`030000003oool0oooo06T0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;801@3oool00`000000oooo0?oo
o`1Y0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0YJbb00D0oooo1@0000000`3oool000000?ooo`020?ooo`040000
003oool0000000000080oooo0`0000020?ooo`030000003oool0oooo00@0
oooo0P0000020?ooo`<000000P3oool01P000000oooo0?ooo`3oool00000
0?ooo`800000103oool01@000000oooo0?ooo`3oool000000080oooo0`00
00020?ooo`030000003oool0oooo0080oooo0`00000W0?ooo`040:F//P1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb00D0oooo
00<000000?ooo`3oool00`3oool01`000000oooo0?ooo`3oool000000?oo
o`0000000P3oool01`000000oooo0?ooo`3oool000000?ooo`0000001P3o
ool010000000oooo0?ooo`0000030?ooo`060000003oool0oooo0000003o
ool000000P3oool00`000000oooo0?ooo`030?ooo`070000003oool0oooo
0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo00D0
00000?ooo`3oool0oooo0000000V0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb00D0oooo00<000000?ooo`3o
ool00`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00@00000
0?ooo`3oool000001`3oool01@000000oooo0?ooo`3oool0000000D0oooo
00L000000?ooo`3oool0oooo0000003oool0000000D0oooo00D000000?oo
o`3oool0oooo0000000Z0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0YJbb00D0oooo00<000000?ooo`3oool00`3o
ool01`000000oooo0?ooo`3oool000000?ooo`0000000P3oool500000003
0?ooo`000000oooo00D0oooo00<000000?ooo`3oool01@0000030?ooo`05
0000003oool0oooo0?ooo`0000001@3oool01P000000oooo0?ooo`3oool0
00000?ooo`D0000000<0oooo0000003oool00P3oool5000002H0oooo00@0
YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;80
1@3oool5000000030?ooo`00000000000080oooo00<000000?ooo`000000
0P3oool01P000000oooo0?ooo`3oool000000?ooo`8000001@3oool01000
0000oooo0?ooo`0000030?ooo`060000003oool0oooo0000003oool00000
0P3oool00`000000oooo0?ooo`030?ooo`8000000P3oool00`000000oooo
000000030?ooo`040000003oool0000000000080oooo00D000000?ooo`3o
ool0oooo0000000V0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0YJbb00D0oooo00<000000?ooo`3oool00`3oool0
1@000000oooo000000000000oooo00<000000P3oool300000080oooo00<0
00000?ooo`0000000`3oool300000080oooo0`0000020?ooo`040000003o
ool0oooo0?ooo`@00000103oool010000000oooo0000000000030?ooo`<0
00000P3oool00`000000oooo000000020?ooo`<000009`3oool0102U[;80
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P050?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0>03oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn0:F//P050?ooo`D000001`3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0h0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0YJbb00D0oooo00<000000?ooo`3oool0J@3o
ool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
0:F//P050?ooo`030000003oool0oooo06T0oooo00@0YJbb06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;801@3oool00`000000
oooo0?ooo`1Y0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0YJbb00D0oooo00<000000?ooo`3oool0J@3oool0102U
[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P1a
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWic0:F//P0306IVOP2XZK/0nocm0040IVIn00000`1VIWh0moOi09RHY`1e
07MgTP40V9RW0@3gmoT106IVOP0000<0IVIn0?Ogn@2l_Ld0MP2l_Ld10?Og
n@40IVIn00000`1VIWh0moOi0>CSh`1f0>CSh`40moOi0@1VIWh0000306IV
OP3`lO@0oooo02l0oooo00<0i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?
06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0
101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0
W:Bi102V>D@0102W>T@0YSU40:LjA02W>T@90:HiA00309bT^@3/j^X0oooo
00<0oooo0@3`lO@106IVOP0001H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0
no_m0?_lo@3ko?`0o?cm0?clo03lnod0o?cl0?cko03lo?`0nocl0?clo03k
o?d0o?_l0?clo@3knod0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?dD0?ck
o080nocl00<0W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0
W:Bi06]eSa40QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@07
0:HiA02LY;T0nocl0?clo03lnod0nocm0>;QhP0106IVOP0000@0IVIn0>3P
h@3fmoT0moOi0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0
moKh0?Kgn@3gmoT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT0
0`3fmoP0moOi0?Ogn@0C0?Ogn@80m_Oi00<0JgF?08F9/02LW[h0402LW[h0
1P25RK00JgF?0?Ogn@3gmoT0JgF?08F9/140W9jn00P0QHV`06]eS`3fmoP0
moOh0:HiA02Z?5D0`U9K0<IDFPd0aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Og
n03gmoT0moOh0?Ogn@3Ph>400@1VIWh0000606IVOP3NgN40lO7d0?7am03`
lO@0l?;d400000001P3alO@0l?;e0?7am03al_@0l?;d0?7am1H0l?7e00<0
JgF?0;:ed02WZ<80402WZ<801P2b]M00JgF?0?3am03`lO@0JgF?0;:ed140
YjS200D0/[G@06]eS`3`lOD0lO;d0:HiA0020<9BF`030<]DF@3=FEh0cEUN
00/0cEUN00@0beAI0<9BF`32DU/0YSU40P3`lO@00`3alO@0l?;d0=kMh@01
06IVOP0000L0IVIn0=cKh03Zjo00j^_`0>[/l03Yjnl000000080inOW0P3N
g]h20>OWi`030>NmQ03WinL0inOW00<0inOW0P3_knl010000000j^_`0>[[
l03Zjnl20>[[l0030>[[k`3Zjo00j^_`0180j^_`0P3Zk?00101[MHl0][WA
0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[
MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Ji
d@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO
0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0
IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080
inOW00<0aV<00>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ
0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0B0>?Uj`80hnCZ00D0JgF?
0;bne02b//X0/[;:0?ooo`0606i]S`0302DU=P2b//X0/[;:00D0/[;:00H0
_;kD06]eS`3SiNX0hnGZ06]eS`2l_]@20;:bbP030?ooo`0U9CH09BDf00T0
9BDf0`2b//X01@2l_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN00@0d5]P0=AL
G`3oool0oooo1`3DG5l20?ooo`0:0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnCZ
0>?UjP3Si>X0hnG[0=WIg`40IVIn00000`1VIWh0emSN0=cNiP030=cNiP05
0000003WinL0inOW0>OWi`3We/h00P3WinL01@3>N`00ki@@0>OWi`3Wg/H0
kh`@00<0kno_00L000000=cNiP3Lg^D0g=kU0=cNiP3Lg^D0g=kV01H0g=kU
00D0JgF?0;o1eP2h^Lh0^;W>0?ooo`0606i]S`0302DU=P2h^Lh0^;W>00D0
^;W>00H0_l7F06]eS`3Lg^D0g=kU06]eS`2o`MH20;RicP030?ooo`0U9CH0
^;W>00L0^;W>00<0oooo02DU=P2h^Lh00P2h^Lh02@2o`MH0JgF?0=cNiP3L
g^D0YSU40<eIGP3AFUh0e5eQ05<U80030?ooo`D0eUmS0`3oool01@1C9B00
e5eQ0=5JGP3=FEh0YSU40080g=kU00<0g=kV0=cNi@3Gf=h00@1VIWh00004
06IVOP3Ee]d0eMSP0=KHh@80eMSP00T0000008b<S03WinL0inOW0>NeQ03F
FP00eX@00?o>003>H`000P3NJ`001@3_]H`0kno_0>o_k`3_knl000000080
eMSQ00@0eMOP0=KHh03Ff>40e]OQ503Fen020=KHh00506]eS`33aMT0_;gA
0;bmd@3oool01`0U9CH70;bmd@060<?5f@1[MHl0eMSQ0=GHh@1[MHl0`lGI
0P2l_M400`3oool09BDf0;bmd@070;bmd@030?ooo`0U9CH0_;gA0080_;gA
00D0`lGI06]eS`3Fen00eMOQ0:HiA0020=EMH0030=QPH@3IHF80AQhJ00<0
oooo0`3IHF830?ooo`0304HN6P3IHF80f61Q0080eEeP00H0YSU40=KHh03E
f>40eMOP0=GHh@3Ee]d106IVOP0000L0IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@
d]`0000000<0inOW00`0imk>0<I:003gcP00kjd00>ne003>J`00aUX00<I[
003NS4X0ijD00>oWcP0000030=3Bg0030<oBg03@d]`0cm;L01@0d=;L0P3?
d]d00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3Bg01[MHl0
b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP030?ooo`0U9CH0`lCF0080
`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU00D0AQhJ
0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aUI@3IHF80
eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn0=3Bf`3;
cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH0>nm003gaP00kjd00>N]
003WY@00eX`00<i[003WaP00omH00>o_i`3_knl000000<_=f03;cMT0b/gI
0<_>f03:cMP0blgH503;cMT20<_>f@0306]eS`3;c=h0b<[I00P0b<[I00<0
b<WI0<S:f@38b]T00`38b]T01038bMT0b<[I0<_<gP1[MHl20<_=f00606]e
S`3;c=h0b<[I0<S:f@3oool09BDf1@38b]T04@38bMT0b<[I0<S:f@3oool0
9BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0eemO0=]TI03P
IfD0h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3oool02P167QX0gVMW0=iW
I`3PIVD0h6MU0=]TI03GGel0YSU40<[>f03:c]T20<_=f@40d=;K0@1VIWh0
000306IVOP3?cmX0aLSD00<0aLSD00H000000<K6aP3Wg]H0cW/00>N]003_
]@020>NU00030=JD003>L`00eY@00080mlH00P3gmoL010000000aLSD0<G7
e035am@30<G7eA@0a<OE0P34b=@00`1[MHl0d=7P0<_;g00@0<_;g0060=3A
h01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3oool09BDf0<_;g0070<_;
g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]eS`35am@0a<OD0:HiA03K
I6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo04HN6P050>1ZJ0040=mU
I03KI6@0YSU40<C8e@80a<SD0@35amD10<o?fP40IVIn0000101VIWh0c<kJ
0<;4dP31a=420<74dP060000003WinL0inOW0>OWi`3FQ000kkD00P3WY@00
203FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL000000`31a=800`32a=40
`LCB0<74dP0D0<74d@80`LCB00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80
JgF?0<;4dP32a=80JgF?0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?d=d0
0`3oool09BDf0<o@g@020<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT
0>5YI@050>1/J@D0oooo1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA0<74
d@31a=80c<kJ0@1VIWh0000406IVOP3:c=P0_/3?0;g0c`80_/3>00D00000
09bLW03WinL0imkF0=J<00020=jD00040=Ik0036H`00_D800>nU0080mjd0
00P0mkD00?o>BP000000_/3>0;k0c`2n`<h0_/3?0;g0cQD0_/3>0P2m`<h0
0`1[MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0cP1[MHl0e]KT
0P3Cdn000`3oool09BDf0?ooo`080?ooo`0;02DU=P3Cdn00dm?P0=?Ch03F
e^@0JgF?0;k0c`2n`<h0YSU40>1VI@3QJVX0103SK6`30?ooo`0404HN6P3o
ool0oooo0?ooo`@0hfa/00@0hFYZ0>1VI@2V>D@0_L3?0P2n`<l10;k0cP40
b/cH0@1VIWh0000706IVOP39b]P0][S80;Vlb`2j_</0^[c<000000020>o_
k`0C0=JL003FS000gY@00=J4003_Y@00gX`00;eJ003FL`00ki`00?O_i`3g
moL0oooo0000002i_<`0^[_<0;Vlb`2j_</0^Kc<0;Vlb`0D0;Vlc080^[c<
00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?0;Zlb`2j_</0JgF?0=SH
i@80dm?Q00<0oooo06i]S`1^KHl0201^KHl03P0U9CH0dm?Q0=?Ch@3Cdn40
f=SU06]eS`2j_</0^[c<0:HiA03PJFP0hFe/0>AaK@3TLFl0i71^0`3oool0
0`167QX0i71^04HN6P030?ooo`80i71^00T0i75]0>5]K03PJFP0YSU40;Zl
c02j^l`0^Kc;0;Jhb039b]P00@1VIWh0000906IVOP37bML0];K70;Jhb02f
^<T0][W900000024Q8@0inON0080kno_00L0aV/00?O6003_]@00ki`00=j<
003>J`00ii`000<0moOg00D000000;Jib@2g^<T0][W90;Nib@020;JhbA@0
]kS90P2f^<T0101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SH
iP80f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool0
2P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03T
KVd0i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0
oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG
0@1VIWh0000306IVOP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_
knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool0
000001`0];K700D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[
MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0
g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3o
ool00`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0
igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0
];K700H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0
moOg0?Ogm`3_imH0moOg0?ooo`00000L0;Bfa`0306]eS`3Ee><0h=oZ0100
h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0
];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]
UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:Hi
A0040;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H00000
0>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg
00<0oooo0000002a/lP06`2a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[
l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0
YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/
]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP1
0<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_
0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L06P2_[/L0
0`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S
4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@
Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0
`<7A0<O7e00_0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;
g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<
bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf
0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03o
Whd0YSU4096HZP<0[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;B
g`2e]<T_0:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh0
0P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n
00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;B
g`30`M400@1VIWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34K`2XYkl0
1@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3l
o?`0i>?X0=3@h03:b]X0K@2l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7
V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[J`3G
f>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX
00<0IVIn09FDZ`3AdMh00P3lo?a]0?ooo`80o?cl00<0dM7N09FDZ`1VIWh0
0P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW_`1/0:RW_`0409FDZ`28
Qid0IVIn06IVOP<0F5MX000505QGJ740IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[15]:=",
  Evaluatable->False,
  ImageSize->{123, 54},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"TextField"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[15]=",
  CellTags->"TextField"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"PasswordField\"]", "ObjectName",
  CellTags->"PasswordField"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"text\" \[Rule] \"text content\"\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"enabled\" \[Rule] True", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"PasswordField"],

Cell[TextData[{
  StyleBox["Events", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"action\" - ", "Program"],
  StyleBox["triggered when ", "Text"],
  StyleBox["\[ReturnKey]", "KeyboardChars"],
  StyleBox[" is pressed", "Text"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"PasswordField"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"PasswordField"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<PasswordField\>", \ {"\<text\>" -> \
"\<Should not see\>"}]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"PasswordField"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"PasswordField"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000>2000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0YJbb
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;80
L@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn0:F//P1a0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0YJbb00D0oooo00<000000?ooo`3oool0J@3oool0102U
[;80IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P05
0?ooo`030000003oool0oooo06T0oooo00@0YJbb06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;801@3oool00`000000oooo0?oo
o`1Y0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0YJbb00D0oooo00<000000?ooo`3oool0J@3oool0102U[;80IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P050?ooo`03
0000003oool0oooo06T0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP2U[;801@3oool00`000000oooo0?ooo`1Y0?oo
o`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
YJbb00D0oooo00<000000?ooo`3oool0J@3oool0102U[;80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P050?ooo`050000003o
ool000000?ooo`000000103oool00`000000oooo000000040?ooo`030000
003oool0000000@0oooo00<000000?ooo`000000103oool00`000000oooo
000000040?ooo`030000003oool0000000@0oooo00<000000?ooo`000000
103oool00`000000oooo000000040?ooo`030000003oool0000000@0oooo
00<000000?ooo`000000103oool00`000000oooo000000040?ooo`030000
003oool0000000@0oooo00<000000?ooo`000000103oool00`000000oooo
0000000<0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0YJbb00D0oooo00D000000?ooo`000000oooo000000040?oo
o`030000003oool0000000@0oooo00<000000?ooo`000000103oool00`00
0000oooo000000040?ooo`030000003oool0000000@0oooo00<000000?oo
o`000000103oool00`000000oooo000000040?ooo`030000003oool00000
00@0oooo00<000000?ooo`000000103oool00`000000oooo000000040?oo
o`030000003oool0000000@0oooo00<000000?ooo`000000103oool00`00
0000oooo000000040?ooo`030000003oool0000000`0oooo00@0YJbb06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;801@3oool0
10000000oooo0?ooo`0000060?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo00/0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP2U[;801@3oool600000080oooo1@0000020?ooo`D00000
0P3oool500000080oooo1@0000020?ooo`D000000P3oool500000080oooo
1@0000020?ooo`D000000P3oool500000080oooo1@0000020?ooo`D00000
0P3oool500000080oooo1@00000;0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb00D0oooo00@000000?ooo`3o
ool000001P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0;0?oo
o`040:F//P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
YJbb00D0oooo00<000000?ooo`3oool0J@3oool0102U[;80IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P050?ooo`030000003o
ool0oooo06T0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP2U[;801@3oool00`000000oooo0?ooo`1Y0?ooo`040:F/
/P1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb00D0
oooo00<000000?ooo`3oool0J@3oool0102U[;80IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P050?ooo`030000003oool0oooo
06T0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP2U[;80L@3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn
0?_lo@2XZK/0IVInL`2U[;800`1VIWh0Z:Vk0?_lo@0106IVOP0000<0IVIn
0?Ogn@2HV:L0M@1gMi8109RHY`40moOi0@1VIWh0000306IVOP3gmoT0_;g=
07H0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3Thn<0MP3Thn<10?Ogn@40
IVIn00000`1VIWh0l?7d0?ooo`0_0?ooo`030>CSh`2LY;T0JgF?00<0JgF?
00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0i>?S
09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?oo
o`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0YcY42@2V>D@00`2L
Y;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F06IVOP3RhN80nocl0?_k
o03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m0?clo03lno`0o?cl
0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080o?cl00@0o?cm0?clo03k
nod0o?cm503lno`20?_lo00309bT^@1[MHl0QHV`0100QHV`00H0JgF?09bT
^@3ko?d0nocm09bT^@1[MHlA08F9/00606]eS`2LY;T0nocl0?_ko02LY;T0
YSU44@2Z?5D01`2V>D@0W:Bi0?_lo03lo?`0o?_m0?_lo@3RhN800@1VIWh0
000406IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0m_Oh0?Ogn@3gmoP0m_Oh0?Kg
n@3gmoP0moOi0?Ofn03fmoT0moOi0?Kgn@020?Ogn@040?Ofn03fmoP0m_Oi
0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3gmoT04`3gmoT20?Kgn@0306]eS`25RK00
W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi06]eS`25RK0A09bN_P0808F9
/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=0<IEG0090<IDFP32DU/0
ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q0040IVIn00001P1VIWh0g]gQ
0?7am03alO@0l?7d0?3bm100000000H0lO7d0?3bm@3alO@0lO;d0?3bm03a
lO@F0?3am@0306]eS`2b]M00YjS20100YjS200H0/[G@06]eS`3`lO@0l?7d
06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e0?7bm02V>D@00P32DU/00`3;
E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0`U9K0:HiA080l?7d00<0lO7d
0?3bm03NgN400@1VIWh0000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__0000
00020>OWi`80g]kN0P3WinL00`3W_H@0inOW0>OWi`030>OWi`80kno_00@0
00000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`0>[[l00B0>[[l080j^c`
00@0JgF?0;Jid@2][/H0[Jk6203oool00`2][/H0[:k60:f^aP030:f^aP03
0:b^aP2f^M40JgF?0080j^__00@0JgF?0;Jid@2][/H0[Jk6303oool20:f^
aP030:b^aP2f^M40JgF?0080j^_`00D0YSU40<eIGP3;E5T0cEIK0<iIG`0;
0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0j^__0>[[l0020>[[k`40g=_P
0@1VIWh0000406IVOP3IfMl0hnGZ0>?TjP80hnG[00D0000008b<S03Ng]h0
inOW0=kNgP020>OWi`030<IS003WinL0inOW0080inOW00L0knoW0>o_k`3_
knl000000>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[0>?Uj`3SiN/04P3SiN/2
0>?TjP0506]eS`2l_]@0/[;:0;:bbP3oool01P1^KHl00`0U9CH0/[;:0;:b
bP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[MHl0_;kD0P2b//X00`3oool0
9BDf02DU=P0902DU=P<0/[;:00D0_;kD06]eS`3Si>/0hnC[0:HiA0020<eI
GP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3oool02P3DG5l0d5]P0<eIGP3=
FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl106IVOP0000<0IVIn0=OHgP3L
g^H00`3Lg^H01@000000inOW0>OWi`3WinL0imK>0080inOW00D0cW/00>nD
403WinL0imk60>n<40030>o_k`070000003Lg^H0g=kU0=cNi@3Lg^H0g=kU
0=cNiP0F0=cNi@0506]eS`2o`MH0^;W>0;RicP3oool01P1^KHl00`0U9CH0
^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU0=cNi@1[MHl0_l7F0P2h^Lh0
0`3oool09BDf0;RicP070;RicP030?ooo`0U9CH0^;W>0080^;W>00T0_l7F
06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C9B000`3oool50=IOH`<0
oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA0020=cNi@030=cNiP3Lg^D0emSN
0040IVIn0000101VIWh0eMKM0=GHh03Ff>420=GHh0090000002<S8`0inOW
0>OWi`3W]H@0eUX00=J4003ocP00cV<00080gV/000D0kkF<0>o_k`3_knl0
kno_000000020=GHh@040=GGh03Ff>00e]SQ0=KGhA@0e]OP0P3Ff>001@1[
MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?0=GHh@3E
f>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M401`2l_M400`3oool09BDf
0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V>D@00P3EGF000`3HH640
fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@020=EMH006
0:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0000706IVOP3Be=d0cm;L
0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36BP00mlh00>n]003_]@00
cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@d]`00`3?d]`0d=;L0<oB
g00D0=3Bg080cm;M00<0JgF?0<S9f`33a=H04033a=H01P38bM/0JgF?0=3B
g03@d]`0JgF?0<S9f`80`lCF00<0oooo02DU=P33a=H01`33a=H00`3oool0
9BDf0<?4eP020<?4eP070<S9f`1[MHl0cm;L0<oBg02V>D@0eemO0=UQHP03
0=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3oool020167QX0g6EU0=aU
I@3LIFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`10<oBg040d]CM0@1VIWh0000L
06IVOP3@d]/0blgH0<[=f@3;c]P0b/gH0000003WaZd0ilJ<0?O>603__@00
mlH00>n]003W[@00ijD00=J<003>J`00ilH00?oF003_knL0kno_0000003;
cMP0blgI0<[=f@3;c]P0b/gH0<_=f1@0blgI0P3;c]T00`1[MHl0blcN0<S:
f@080<S:f@030<S9f@38b]T0b<[I00<0b<[I00@0b<WI0<S:f@3;c=h0JgF?
0P3;cMP01P1[MHl0blcN0<S:f@38b]T0oooo02DU=PD0b<[I0140b<WI0<S:
f@38b]T0oooo02DU=P38b]T0b<WI0<S:f@3;c=h0JgF?0<_>f03:cMP0YSU4
0=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN6P3oool0oooo00<0oooo00X0
AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO0:HiA03:c]P0b/kI0P3;cMT1
0=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0030<G8e00600000036a/H0imkF
0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD00020?O60080moOg00@0
00000<G8e035am@0aLOD0`35amDD0<C7e@80a<SD00<0JgF?0=3Ah03;bm`0
403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3Ah080bl_L00<0oooo02DU
=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;g0070=3Ah01[MHl0aLOD
0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3oool0oooo0?ooo`167QX0
1@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040aLOE0@3?cmX106IVOP00
00@0IVIn0<c>fP32a=80`LCA0P31a=801P000000inOW0>OWi`3WinL0eX@0
0>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm003_knl0moOg000000<0
`LCB00<0`/CA0<74dP31a=805031a=420<74dP0306]eS`3Cdn80cm3M0100
cm3M00H0dm?R06]eS`32a=80`/CB06]eS`3Cdn820<o@g@030?ooo`0U9CH0
cm3M00L0cm3M00<0oooo02DU=P3?d=d00P3?d=d01`3Cdn80JgF?0<;4dP31
a=40YSU40=]TI03QJFD01@3PK6T50?ooo`D0h6aY00P0hFUU0=]TI02V>D@0
`LCB0<;4d@31a=40`LCB0<c>fP40IVIn0000101VIWh0b/cH0;k0c`2m`<l2
0;k0cP050000002LW9`0inOW0>ONeP3FS0000P3NU000103FN`00aV<00;e2
003_Y@020?N]00080?Ne003ocTX000000;k0cP2n`<l0_/3>0;k0c`2m`<hE
0;k0cP80_L3>00<0JgF?0=KFi03Cdn00403Cdn001P3Fe^@0JgF?0;k0cP2n
`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3oool0203oool02`0U9CH0dm?P
0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:HiA03PIVD0hFYZ00@0hfa/0`3o
ool010167QX0oooo0?ooo`3oool40>=/K0040>5ZJP3PIVD0YSU40;g0c`80
_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0bL[H0;Jhb02i_</0^[c;0;Zl
c00000000P3_knl04`3FW000eX`00=jD003FQ000kjD00=j<002mFP00eW<0
0>nL003gknL0moOg0?ooo`000000^Kc<0;Zkc02i_</0^[c;0;Vlc02i_</0
502i_<`20;Zlc00306]eS`3Hf>D0dm?Q0100dm?Q00H0f=SU06]eS`2j_</0
^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?00P0KVf?00h09BDf0=?C
h@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0i75_
0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3oool20>A`KP090>AaK@3QKF`0
h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H0040IVIn00002@1VIWh0alWG
0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OWgP020>o_k`070<I[003gaP00
kkD00>nL003NS000cV/00>NL00030?Ogm`050000002f^LT0]kS90;Jib@2g
^LT00P2f^<TD0;Nhb@80][S900@0JgF?0=KFi03Hf>D0f=SV0`3Hf>D50=SH
iP<0f=SU0P3Hf>H20=SHi@090=KFi01[MHl0]kS90;Nhb@1[MHl0e]KT0=SH
i@3Hf>H0oooo00X0KVf?00d09BDf0=SHiP3Hf>D0f=SU0=KFi01[MHl0]kS9
0;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo00D0AQhJ0>AdK`3TM6l0
i7A_04HN6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^K@2V>D@0][W90;Jhb@2f
^LT0];K70<O9e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`030000003_
knl0kno_0080kno_00/0ijd00?O6203WY@00ii@00>N<003_imH0gY@i0>oF
]@3omoL0oooo0000000L0;Bfa`0506]eS`3EeN<0g=_W0=cKi`3MfnL03P3L
fnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80g=_W00<0gM_W02DU=P0U
9CH02@0U9CH30=cKi`090=GEh`1[MHl0];K70;Bfa`2V>D@0ig=_0>MeLP3Z
MW<0jWQf0080oooo00<0AQhJ0>UnN03YOWP00`3YOWP020167QX0oooo0?oo
o`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d]/L10<K8e`40IVIn00000`1VIWh0
a/SG0;Bfa`030;Bfa`060000002<S8`0kno_0>o_k`3WcW/0kno_0P3gmoL0
203WU000mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool00000702d]/L00`1[MHl0
eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0];K70;Bfa`1[MHl0eMCS4@3PgnX0
2@3Ee><0JgF?0;Bfa`2d]/L0YSU40>YiL`3YO7P0kh5j0?:9P@0204HN6P07
0>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:0>^HR`0204HN6P050?:9P@3_PGX0
jGah0>YiL`2V>D@0102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;6cb003
0;6cb0060000003_knl0kno_0>o_k`3gmnl0kno_0P3gmoL00`3gilH0moOg
0?ooo`030?Ogm`030?ooo`000000/K?801/0/K?800<0JgF?0>g[l`3Yj?40
403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[la40jNSa01T0kN_c06]e
S`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0lZ^F0?6bV`3]]9/0k;FL
0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3gWHh0mHb40?24O03aP7D0
YSU400@0/K?80@36b=L106IVOP0000<0IVIn0<K8e`2h]ll00`2_[/L01@00
0000[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3omoL20?ooo`030000002_[/L0
[jk701X0[jk700<0JgF?0=;Ah`3blOL0403blOL01P3BdN<0JgF?0:n^a`2_
[/L0JgF?0=;Aha40l_7g00H0d]7S06]eS`2_[/L0[jk70:HiA03dRWd20?F@
Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^a`020:n^a`40^;O?0@36b=L106IV
OP0000<0IVIn0<31d@37am@0;`2/Zl@01024S:80JgF?0<c;g@3kno`=0?oo
o`040?_ko03<bmd0JgF?08B<XP80[:_400@0Q8bR06]eS`3<bmd0no_l3@3o
ool0103kno`0c<_M06]eS`24S:820:b[a007096HZP2V>D@0oin=0?joY03j
g;L0n^^g0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf0?[Y]P80nNVf00H0n^^g
0?[L]`3n_j@0oin=0:HiA02AV:X30:b[a040alOD0@30`M4106IVOP0000@0
IVIn0<31d@3Bd]l0]KC9;`2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<
XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n
0:BS_P020:BS_P0308B<XP2V>D@0YSU400l0YSU400L0Q8bR0:BS_P2TXkh0
Y:>n0;Fdb@3Bd]l0`<7A0040IVIn00001P1VIWh0Z:No0>KVk@3Bd^00_;c?
0;6`a6l0Z:No00D0/K340;blc`3Bd^00i^K]0:RW_`0106IVOP0000L0F5MX
08N7V`3Gf>80o?cl0>CSj03@d>00b/[J06d0_;c?00H0b/[J0=3@h03ThnP0
o?cl0=OHhP27Qi/105QGJ00000P0F5MX06IVOP2EU:/0emSR0?clo03blO<0
k>_^0>7Rjf/0emSR00L0hN;[0>c[kP3blO<0o?cl0=OHhP2EU:/0IVIn0040
F5MX000205QGJ00306IVOP2EU:/0dM7N0080o?clK@3oool20?clo0030=7A
gP2EU:/0IVIn0080F5MX000305QGJ080IVIn00<0R8NM09FDZ`2XYkl0K02X
Ykl0102EU:/0R8NM06IVOP1VIWh305QGJ0001@1HEfQa06IVOPD0F5MX0000
\
\>"], "Graphics",
  CellLabel->"From In[17]:=",
  Evaluatable->False,
  ImageSize->{123, 56},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"PasswordField"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[17]=",
  CellTags->"PasswordField"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"List\"]", "ObjectName",
  CellTags->"List"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"items\" \[Rule] {", "Program"],
  StyleBox["item1", "Program",
    FontSlant->"Italic"],
  StyleBox[", ", "Program"],
  StyleBox["item2", "Program",
    FontSlant->"Italic"],
  StyleBox[", \[Ellipsis]}\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"visibleRowCount\" \[Rule] ", "Program"],
  StyleBox["integer\n", "Program",
    FontSlant->"Italic"],
  "\[FilledSmallSquare] ",
  StyleBox["\"selectedValues\"", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"List"],

Cell[TextData[{
  StyleBox["Events", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"listSelection\" - ", "Program"],
  StyleBox["triggered when there is a change in the current selection", 
    "Text"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"List"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"List"],

Cell[BoxData[
    \(\(Needs["\<GUIKit`\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"List"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
{\[IndentingNewLine]Widget["\<ScrollPane\>", \
{\[IndentingNewLine]"\<viewportView\>" -> 
                    Widget["\<List\>", \ \
{\[IndentingNewLine]"\<visibleRowCount\>" \[Rule] 
                          3, \[IndentingNewLine]"\<items\>" \[Rule] 
                          Script[{"\<Choice A\>", \ "\<Choice B\>", \ \
"\<Choice C\>", \ \ "\<Choice D\>", \ \ "\<Choice E\>"}]\[IndentingNewLine]}]\
\ }]\ }]\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"List"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"List"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000Eb000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0Oifi
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
H03oool00`3Dd<P0k>gd08^<V@0<09fNZ`0608Z;V@3Si^d0Oifi06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0H03oool00`3D
d<P0U9FR0=gNh@0<0=WJi0060=gNh@2DUJ80Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0H03oool00`3Dd<P0U9FR0?oo
o`0<0<_<fP060?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1oWKT0H03oool00`3Dd<P0U9FR0?ooo`0<0<_<fP06
0?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT00`3oool300000080oooo00D000000?ooo`3oool0oooo0000
00020?ooo`<000000P3oool00`000000oooo0?ooo`03000000<0oooo0`00
00070?ooo`<00000=P3oool00`3Dd<P0U9FR0?ooo`0<0<_<fP060?ooo`2D
UJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT00P3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool0
0`000000oooo000000030?ooo`050000003oool000000?ooo`0000000`3o
ool00`000000oooo000000030?ooo`030000003oool0oooo00<0oooo00D0
00000?ooo`3oool0oooo0000000e0?ooo`030=C@b02DUJ80oooo00D0blcJ
00<0?cdm0<_<fP3;c=X0103;c=X01P3oool0U9FR07nM^@1VIWh0Z:Vk0?_l
o@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`0000001P3oool0
1`000000oooo0?ooo`3oool000000?ooo`0000000`3oool01@000000oooo
0000003oool0000000D0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`0h0?ooo`030=C@b02DUJ80oooo00@0blcJ0`0o?Cd50<_<fP06
0?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP1oWKT0oooo000000060?ooo`070000003oool0oooo0?ooo`000000
oooo000000030?ooo`050000003oool000000?ooo`0000001@3oool50000
00@0oooo00<000000?ooo`3oool0>03oool00`3Dd<P0U9FR0?ooo`030<c=
f`D0?cdm103<cM/01P3oool0U9FR07nM^@1VIWh0Z:Vk0?_lo@40IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`0000001P3oool200000080oooo
00<000000?ooo`0000000`3oool01@000000oooo0000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo03P0oooo00<0e=3809BEXP3oool00P3Ad^0303lm?@04
0=7Bh00o?Cd0?cdm03lm?@<0dM;P00H0oooo09BEXP1oWKT0IVIn0:RY^`3k
o?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000H0oooo
00@000000?ooo`00000000000`3oool300000080oooo00<000000?ooo`3o
ool00`0000030?ooo`<000001@3oool00`000000oooo0?ooo`0h0?ooo`04
0=C@b02DUJ80oooo0=WJi0<0?cdm0`3If^@303lm?@80fM[T00H0oooo09BE
XP1oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@020?ooo`070000003oool0oooo0?ooo`000000oooo0000000M0?ooo`05
0000003oool0oooo0?ooo`000000=@3oool00`3Dd<P0U9FR0?ooo`020>?S
j`0303lm?@3Shn/0hn?[00<0hn?[00X0?cdm0>?Sj`3Shn/0hn?[0?ooo`2D
UJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT00`3oool300000080oooo00<000000?ooo`3oool02@3oool00`000000
oooo0?ooo`0@0?ooo`<00000=P3oool00`3Dd<P0U9FR0?ooo`0<0>c/l@06
0?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT0H03oool00`3Dd<P0U9FR0?ooo`0<0?Cdm`060?ooo`2DUJ80
Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
H03oool00`3Dd<P0U9FR0?ooo`0<0?_lo0060?ooo`2DUJ80Oifi06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0H03oool00`3D
d<P0U9FR0?ooo`0=0?ooo`0509BEXP1oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0H03oool00`3Dd<P0U9FR0=KFf`0<
0?ooo`060=KFf`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1oWKT0H03oool01@3Dd<P0e]_I08n@WP2e]Kh0];Bn00D0
];Bm00/0/kBm0;Bd_@2c];d0];Bm0;>c_@2<SI`0e]_I07nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@1P0?ooo`0:0=C@
b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0
n_[m0?_koP3knoh0no_n0=C@b01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT0H03oool02P3Dd<P0k>kc0>c_m03^ko@0
ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n0?_k
oP3Dd<P0Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1V
IWh0Oifi0600oooo00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Ce
n@3gmoT0n?Sk0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@1P0?ooo`0:
0=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk
00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT00`3oool300000080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`<000000P3oool00`000000oooo0?oo
o`03000000<0oooo0`0000050?ooo`D00000=P3oool02P3Dd<P0k>kc0>c_
m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/20?Win`090?[jo@3knoh0
no_n0?_koP3Dd<P0Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh0Oifi0080oooo00L000000?ooo`3oool0oooo0000003oool0
000000<0oooo00<000000?ooo`0000000`3oool01@000000oooo0000003o
ool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0<`3o
ool02P3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/2
0?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi06IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`0000001P3oool01`00
0000oooo0?ooo`3oool000000?ooo`0000000`3oool01@000000oooo0000
003oool0000000D0oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo03<0oooo00X0e=380>c^l`3/ko@0
k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0P3inO/02@3jn_d0no_n0?_k
oP3knoh0e=3807nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2X
ZK/0IVIn07nM^@3oool0000000H0oooo00L000000?ooo`3oool0oooo0000
003oool0000000<0oooo00D000000?ooo`000000oooo000000050?ooo`D0
0000103oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo03<0
oooo00<0e=380>g`lP2;S9X01@2MWZ`00`2MWZ/0WIj/09fN[00309fN[007
09fO[02=Si/0e=3807nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn07nM^@3oool0000000H0oooo0P0000020?ooo`030000003o
ool0000000<0oooo00D000000?ooo`000000oooo000000030?ooo`030000
003oool0000000<0oooo00<000000?ooo`3oool00P3oool5000003H0oooo
00<0e=3809BEXP3Mg^400`3@dMl608jEXP<0d=7O00H0gMkQ09BEXP1oWKT0
IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0
000000H0oooo00@000000?ooo`00000000000`3oool300000080oooo00<0
00000?ooo`3oool00`0000030?ooo`<000001@3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo03<0oooo00D0e=3809BEXP3oool0moOi
0>c/l@060?ooo`0:0=CEh@3>cmd0c<gK0<g>g03oool0U9FR07nM^@1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00L0
00000?ooo`3oool0oooo0000003oool0000001`0oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`0c0?ooo`040=C@b02DUJ80oooo0?Og
n@80k>ca1P2>UJ802@3>cmd0c<gK0<g>g03oool0U9FR07nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@030?ooo`<00000
0P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00h0oooo
1@00000f0?ooo`050=C@b02DUJ80oooo0?Ogn@3/k?401P3oool02P3DeN40
c]3M0<c=f`3=c]`0oooo09BEXP1oWKT0IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn07nM^@1P0?ooo`040=C@b02DUJ80oooo0?Ogn@80
k>ca1P2>UJ802@3>d=d0c<gK0<g>g03oool0U9FR07nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@1P0?ooo`050=C@b02D
UJ80oooo0?Ogn@3/k?401P3oool02P3DeN00c/oL0<c=f`3=c]`0oooo09BE
XP1oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@1P0?ooo`040=C@b02DUJ80oooo0?Ogn@80k>ca1P2>UJ802@3>cmd0c<gK
0<g>g03oool0U9FR07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@1P0?ooo`030=C@b02DUJ80e]KK00`0oooo00H0e]KK
09BEXP1oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
07nM^@1P0?ooo`030=C@b03moOX0T96O00D0]kNo00<0];Bm0;Ng_`2g]kl0
102g]kl01P2@TIl0e=3807nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0600oooo00<0e=380>c]m02;S9T0302MWZ/01P2:
RiT0hnK]07nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0Oifi0600oooo00<0e=3809BEXP3Mg^40303If^@01P3Mg^40U9FR07nM
^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0600
oooo00<0e=3809BEXP3oool0303;c=X01P3oool0U9FR07nM^@1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0600oooo00<0e=38
09BEXP3oool0303;c=X01P3oool0U9FR07nM^@1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi00<0oooo0`0000020?ooo`050000
003oool0oooo0?ooo`0000000P3oool300000080oooo00<000000?ooo`3o
ool00`0000030?ooo`<000001@3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0380oooo00<0e=3809BEXP3oool0303;c=X01P3oool0
U9FR07nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo
00<000000?ooo`0000000`3oool01@000000oooo0000003oool0000000<0
oooo00<000000?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0<P3oool00`3Dd<P0
U9FR0?ooo`0<0<_<fP060?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo000000060?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`050000003oool000000?oo
o`0000001@3oool00`000000oooo0?ooo`070?ooo`D00000=@3oool00`3D
d<P0U9FR0?ooo`020<_<fP0303lm?@3;c=X0blcJ00<0blcJ00X0?cdm0<_<
fP3;c=X0blcJ0?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP1oWKT0oooo000000060?ooo`070000003oool0oooo
0?ooo`000000oooo000000030?ooo`050000003oool000000?ooo`000000
1@3oool5000000D0oooo00D000000?ooo`3oool0oooo0000000e0?ooo`04
0=C@b02DUJ80oooo0<c=f`<0?cdm0`3<cM/303lm?@80c<gK00H0oooo09BE
XP1oWKT0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM
^@3oool0000000H0oooo0P0000020?ooo`030000003oool0000000<0oooo
00D000000?ooo`000000oooo000000030?ooo`030000003oool0000000<0
oooo00<000000?ooo`3oool0103oool00`000000oooo0000000f0?ooo`03
0=C@b02DUJ80oooo0080dM;P0`0o?Cd0103Ad^00?cdm03lm?@0o?Cd30=7B
h0060?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP1oWKT0oooo000000060?ooo`040000003oool00000000000<0
oooo0`0000020?ooo`030000003oool0oooo00<000000`3oool3000000L0
oooo00<000000?ooo`000000=P3oool00`3Dd<P0U9FR0?ooo`030=WJi0D0
?cdm103If^@01P3oool0U9FR07nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0080oooo00L000000?ooo`3oool0oooo0000
003oool0000001h0oooo00<000000?ooo`000000=P3oool00`3Dd<P0U9FR
0?ooo`040>?Sj`<0?cdm1@3Shn/01P3oool0U9FR07nM^@1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi00<0oooo0`0000020?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0e0?ooo`030=C@b02DUJ80oooo00D0k>ca00<0?cdm0>c/
l@3/k?40103/k?401P3oool0U9FR07nM^@1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0600oooo00<0e=3809BEXP3oool0303d
m?L01P3oool0U9FR07nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0Oifi0600oooo00<0e=3809BEXP3oool0303ko?`01P3oool0
U9FR07nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0600oooo00<0e=3809BEXP3oool03@3oool01@2DUJ80Oifi06IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0600oooo00<0
e=3809BEXP3Fe]/0303oool01P3Fe]/0U9FR07nM^@1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0600oooo00D0e=380=KKf@2?
T9h0]KFn0;Bd_P050;Bd_@0;0;>d_@2d];d0/kBm0;Bd_@2c/kd0S8fL0=KK
f@1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0
Oifi00<0IVIn0:RY^`3ko?d00@1VIWh0000306IVOP3gmoT0V9RW07D0MgNB
0@2HV:L10?Ogn@40IVIn00000`1VIWh0moOi0;bmc@1f0;bmc@40moOi0@1V
IWh0000306IVOP3gmoT0i>?S07H0i>?S0@3gmoT106IVOP0000<0IVIn0?3a
m03oool0;`3oool00`3Thn<0W:Bi06]eS`0306]eS`0406afT01[MHl0K7J@
06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>CSh`2LY;T406]eS`0406af
T01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>cZjP2LY;T4
0:HiA0040:LjA02V>D@0YcY40:LjA0T0YSU400<0W:Bi0>cZjP3oool00`3o
ool10?3am040IVIn00005P1VIWh0h^7R0?_lo03kno`0nocm0?cko@3knod0
nocm0?_lo03lo?d0o?cl0?cko@3lo?`0o?_l0?clo03ko?`0o?cl0?_lo@3l
no`0o?cm0?_ko@3ko?`20?clo0040?clo@3lo?`0no_m0?cloA@0o?_l0P3k
o?`00`2LY;T0JgF?08F9/00@08F9/00606]eS`2LY;T0nocm0?_lo@2LY;T0
JgF?4@25RK001P1[MHl0W:Bi0?_lo03kno`0W:Bi0:HiA140ZSaE00L0YSU4
09bT^@3ko?`0o?cl0?cko@3ko?d0h^7R0040IVIn0000101VIWh0h>3Q0?Kg
n@3gmoT20?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0
m_Oi0?Ogn@3fmoT00P3gmoT0103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kg
n03gmoT0moOi01<0moOi0P3fmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9
/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0
YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Og
n@3gmoP0moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`
l_@@000000060?7am03`l_D0lO7d0?7bm03`l_@0lO7d5P3`lOD00`1[MHl0
/[G@0:NX`P0@0:NX`P060;:ed01[MHl0l?7d0?3am01[MHl0/[G@4@2WZ<80
1@2b]M00JgF?0?3am@3al_@0YSU40080`U9K00<0beAI0<eIGP3=FEh02`3=
FEh0103;E5T0`U9K0<9BF`2V>D@20?3am0030?7am03`l_@0g]gQ0040IVIn
00001`1VIWh0g=_P0>[[l03Zjo00j^c`0>W[k`0000000P3WinL20=kNgP80
inOW00<0ikf40>OWi`3WinL00`3WinL20>o_k`040000003Zjo00j^_`0>[[
k`80j^_`00<0j^__0>[[l03Zjo004P3Zjo020>[/l00406]eS`2f^M40[Jk6
0:f^aPP0oooo00<0[Jk60:b^aP2][/H00`2][/H00`2/[/H0][WA06]eS`02
0>[[k`0406]eS`2f^M40[Jk60:f^aP`0oooo0P2][/H00`2/[/H0][WA06]e
S`020>[[l0050:HiA03=FEh0beAI0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK
0<]DF@3=FEh0YSU40>[[k`3Zjo000P3Zjnl10=cKh040IVIn0000101VIWh0
fMWO0>?UjP3Si>X20>?Uj`050000002<S8`0g]kN0>OWi`3Ng]h00P3WinL0
0`36H`00inOW0>OWi`020>OWi`070>o_i`3_knl0kno_0000003Si>X0hnC[
0>?UjP020>?TjP030>?Tj`3SiN/0hnG[0180hnG[0P3Si>X01@1[MHl0_;kD
0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0
JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH02@0U9CH3
0;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?oo
o`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ
0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0g=kV00D00000
0>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW0>ONaP3_S100
0`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H05P3Lg^D01@1[
MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh0
1P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh0
1`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V
>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`0505<U803DGF40
dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn
0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0ikF40=IJ003F
Q000olh00<iS00020=i[00050>neS03_knl0kno_0>o_k`0000000P3Ef>40
103Een00e]SP0=KHh@3Fen4D0=KGh080e]SP00D0JgF?0<?5f@2l_M40_;gA
0?ooo`0702DU=PL0_;gA00H0`lGI06]eS`3Ef>40eMSQ06]eS`33aMT20;bm
d@030?ooo`0U9CH0_;gA00L0_;gA00<0oooo02DU=P2l_M400P2l_M401@33
aMT0JgF?0=KGh03Een40YSU40080eEeP00<0f61Q0=UQHP167QX00`3oool3
0=UQHP<0oooo00<0AQhJ0=UQHP3HH6400P3EGF001P2V>D@0e]SP0=GHh@3E
en00eMSQ0=GFg@40IVIn00001`1VIWh0d]CM0<oBg03@d]`0d=;M0=3Bg000
00000`3WinL0303Wg/h0aTX00?O>003_[@00kkD00<i[0036FP00aV/00=j<
BP3WY@00knO>000000<0d=;L00<0cm;L0=3Bg03?d]`0503@d]`20<oBg@03
06]eS`38bM/0`lCF0100`lCF00H0b<WK06]eS`3@d]`0d=;L06]eS`38bM/2
0<?4eP030?ooo`0U9CH0`lCF00L0`lCF00<0oooo02DU=P33a=H00P33a=H0
1`38bM/0JgF?0<oBg03?d]`0YSU40=MOG`3IHF800`3LIFD01@167QX0oooo
0?ooo`3oool0g6EU00<0oooo00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0
YSU40=3Bg@80d=;L0@3?d]`10=;Dg@40IVIn0000701VIWh0d=;K0<_=f03:
cMT0blkH0<[=f0000000ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU
003FS000cV/00>O6003oeP00knoW0>o_k`000000blgH0<_=f@3:cMT0blkH
0<[=f03;cMPD0<_=f@80blkI00<0JgF?0<_<gP38b]T02038b]T00`38bMT0
b<[I0<S:f@030<S:f@040<S9f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<
gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0
b<[I0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3P
IVD00P3NIfL00`167QX0oooo0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1V
I@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI0@3@d]/106IVOP0000<0
IVIn0<o?fP35b=@00`35b=@01P000000a/K60>ONeP3>N`00ijd00>ne0080
ijD000<0eY@00<ic003FU0000P3gaP020?Ogm`0400000035b=@0aLOD0<G7
e0<0aLOE5034amD20<C8e00306]eS`3@dN00bl_L0100bl_L00H0d=7P06]e
S`34am@0a<OD06]eS`3@dN020<_;g0030?ooo`0U9CH0bl_L00L0bl_L00<0
oooo02DU=P3;bm`00P3;bm`01`3@dN00JgF?0<G7e034am@0YSU40=]TI03O
IF@01@3PJVP01@167QX0oooo0?ooo`3oool0AQhJ00D0h6YX00@0gfET0=]T
I02V>D@0a<SE0P34b=@10<G7e@40cloJ0@1VIWh0000406IVOP3<c]X0`/CB
0<74d@80`LCB00H000000>OWi`3WinL0inOW0=J4003_]@020>NU00080=J4
003>J`00ijd00?Ne003g_@00kno_0?Ogm`0000030<74dP030<;4d@31a=80
`LCB01@0`LCA0P31a=800`1[MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0
`/CB0<;4dP1[MHl0dm?R0P3?d=d00`3oool09BDf0<o@g@070<o@g@030?oo
o`0U9CH0cm3M0080cm3M00L0dm?R06]eS`32a=80`LCA0:HiA03KI6@0hFUU
00D0h6aY1@3oool50>1/J@080>5YI@3KI6@0YSU40<74dP32a=40`LCA0<74
dP3<c]X106IVOP0000@0IVIn0<[<f02n`<l0_L3?0P2n`<h01@000000W9bL
0>OWi`3Wg]H0eX`00080gY@000@0eW/00<IS002m@P00kjD00P3g[@00203g
]@00oli:0000002n`<h0_/3?0;k0cP2n`<l0_L3>5@2n`<h20;g0cP0306]e
S`3Fe^@0dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?C
h0030?ooo`0U9CH0oooo00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[
MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3o
ool0oooo103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P1
06IVOP0000L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0
eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3o
ool000000;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;01@0^Kc<0P2j_<`00`1[
MHl0f=SU0=?Ch@0@0=?Ch@060=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU0P3C
dn400`3oool0KVf?06i]S`0806i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0
JgF?0;Zlb`2j_<`0YSU40>1YJ03QKF`0i75]0>AaK`3TL6h30?ooo`0304HN
6P3TL6h0AQhJ00<0oooo0P3TL6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<0;Zk
c02i_</0][S80<W:f00106IVOP0000T0IVIn0<O9e`2d]/L0][S80;Jhb@2f
^LT0000008B4Q03Wimh00P3_knl01`36J`00mlH00>ne003_W000gX`00<i[
003WW0000`3gmoL01@000000][W90;Nhb@2f^LT0]kW90080][S9502g^<T2
0;Jhb@0406]eS`3Fe^@0f=SU0=SHiP<0f=SU1@3Hf>H30=SHi@80f=SV0P3H
f>D02@3Fe^@0JgF?0;Nhb@2g^<T0JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]
S`0=02DU=P3Hf>H0f=SU0=SHi@3Fe^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3T
M6l0ig5_0>AdK`030?ooo`0504HN6P3TM6l0i7A_0>AdK`167QX00`3oool0
2P3TM6l0ig5_0>AdK`3TKVd0YSU40;Jib@2f^<T0][W90;Bfa`37bML106IV
OP0000<0IVIn0<K8e`2d]/L00`2d]/L00`000000kno_0>o_k`020>o_k`0;
0>N]003gaPP0ijD00>ND003WS000knOF0=jD>@3_e[D0ooOg0?ooo`000000
702d]/L01@1[MHl0eMGS0=cKi`3LfnL0gM_W00h0g=_W00H0eMGS06]eS`2d
]/L0];K706]eS`3EeN<20=cKi`030=gKi`0U9CH09BDf00T09BDf0`3LfnL0
2@3EeN<0JgF?0;Bfa`2d]/L0YSU40>McK`3WMG80jWIc0>YhMP020?ooo`03
04HN6P3YOWP0jGih00<0jGih00P0AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80
ig=_0:HiA0@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L0
1P000000S8b<0>o_k`3_knl0ilik0>o_k`80moOg00P0ii@00?OWcP3gmoL0
moOg0>oWeP3gmoL0oooo000001`0];K700<0JgF?0=GDh`3PgnX0403PgnX0
1P3Ee><0JgF?0;Bfa`2d]/L0JgF?0=GDha40h=oZ00T0eMCS06]eS`2d]/L0
];K70:HiA03ZNG<0jGah0>n1NP3bRH400P167QX01`3[V8/0jY^<0>fGRP3[
V8/0jY^<0>fGRP3[V8/00P167QX01@3bRH40kh5j0>UlN03ZNG<0YSU400@0
];K70@36b=L106IVOP0000<0IVIn0<K8e`2a/lP00`2a/lP01P000000kno_
0>o_k`3_knl0moO_0>o_k`80moOg00<0mnO60?Ogm`3oool00`3gmoL00`3o
ool000000;6cb00K0;6cb00306]eS`3]jo<0jNSa0100jNSa00H0kN_c06]e
S`2a/lP0/K?806]eS`3]jo<A0>WXl@0I0>g[l`1[MHl0/K?80;6cb02V>D@0
lH1e0?24O03eS8@0mif>0?:[UP3a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a
/Y/0kKBK0>beW03bZiH0mif>0?F<Q03`Q7`0lH1e0:HiA0040;6cb040a/SG
0@1VIWh0000306IVOP36b=L0^;O?00<0[jk700D000000:f][@3gmnl0moOg
0>o_k`060?Ogm`80ooOg0P3oool00`000000[jk70:n^a`0J0:n^a`0306]e
S`3BdN<0l_7g0100l_7g00H0d]7S06]eS`2_[/L0[jk706]eS`3BdN<A0?;a
m`060=;Ah`1[MHl0[jk70:n^a`2V>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0
m8Ym0:HiA02_[/L00P2_[/L10;Rgc`40a/SG0@1VIWh0000306IVOP30`M40
alOD02l0[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]e
S`24S:820:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[
MHl0Q8bR0P2/Zl@01`2AV:X0YSU40?nOS@3n_j@0n]bg0?[[]`3jjKH00P3i
jKH0103jjKH0nNVf0?WY]P3jjKH20?WY]P060?[[]`3jg;L0o[nT0?nOS@2V
>D@0TIRZ0`2/Zl@10<O7e040`<7A0@1VIWh0000406IVOP30`M40d];O0;Fd
bBl0Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS
_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24
S:80YSU40:HiA00?0:HiA00708B<XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31
d@0106IVOP0000H0IVIn0:RW_`3Vi^d0d];P0;blc`2a/<A_0:RW_`050;6`
a02l_<l0d];P0>KVk@2XYkl00@1VIWh0000705QGJ027Qi/0emSR0?clo03T
hnP0d=3P0<[:fP1]0;blc`060<[:fP3@d>00i>?X0?clo03Gf>80QhNK0@1H
EfP0000805QGJ01VIWh0UIB[0=OHhP3lo?`0l_7c0>c[kP3Qh^][0=OHhP07
0>7Rj`3/jnh0l_7c0?clo03Gf>80UIB[06IVOP0105QGJ0000P1HEfP00`1V
IWh0UIB[0=7AgP020?clo6d0oooo0P3lo?`00`3AdMh0UIB[06IVOP0205QG
J0000`1HEfP206IVOP0308R7W@2EU:/0Z:No06`0Z:No00@0UIB[08R7W@1V
IWh0IVIn0`1HEfP000D0F5MXL@1VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  Evaluatable->False,
  ImageSize->{123, 87},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"List"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"List"]
}, Open  ]],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Panel\>", \
{\[IndentingNewLine]Widget["\<ScrollPane\>", \
{\[IndentingNewLine]"\<viewportView\>" -> 
                    Widget["\<List\>", \ \
{\[IndentingNewLine]"\<visibleRowCount\>" \[Rule] 
                          6, \[IndentingNewLine]"\<items\>" \[Rule] 
                          Script[\ 
                            Table[\ 
                              Random[], \ {20}]]\[IndentingNewLine]}]\ }]\ }]\
\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"List"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"List"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002<0000RR000`400?l0
0000o`00003oS01VIWh0000306IVOP3ko?d0nocm08P0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk08L0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
QP1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX@0Oifi
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
L@3oool00`3Dd<P0k>gd08^<V@0<09fNZ`0608Z;V@3Si^d0Oifi06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0L@3oool00`3D
d<P0U9FR0=gNh@0<0=WJi0060=gNh@2DUJ80Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0L@3oool00`3Dd<P0U9FR0?oo
o`0<0<_<fP060?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1oWKT0L@3oool00`3Dd<P0U9FR0?ooo`0<0<_<fP06
0?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT00P3oool3000000<0oooo00<000000?ooo`3oool00`000004
0?ooo`030000003oool0oooo0080oooo0`0000030?ooo`<000000`3oool3
000000@0oooo00<000000?ooo`3oool00P3oool3000000<0oooo00<00000
0?ooo`3oool00`3oool3000000<0oooo0`0000030?ooo`<000001@3oool0
10000000oooo0?ooo`3oool3000000<0oooo0`0000030?ooo`<000001@3o
ool00`000000oooo0?ooo`070?ooo`030=C@b02DUJ80oooo00`0blcJ00H0
oooo09BEXP1oWKT0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0
IVIn07nM^@3oool0000000<0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo0080oooo00L000000?ooo`3o
ool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool0
0`000000oooo0?ooo`020?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool01`3oool00`3Dd<P0U9FR0?oo
o`050<_<fP0303lm?@3;c=X0blcJ00@0blcJ00H0oooo09BEXP1oWKT0IVIn
0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool00000
00<0oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000
00070?ooo`040000003oool0oooo000000@0oooo00L000000?ooo`3oool0
oooo0000003oool0000000<0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo00000004000000D0oooo00<000000?ooo`0000000`3oool00`00
0000oooo000000030?ooo`030000003oool0000000@00000203oool00`3D
d<P0U9FR0?ooo`040<_<fP<0?cdm1@3;c=X01P3oool0U9FR07nM^@1VIWh0
Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`000000
0`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
00@0oooo100000030?ooo`050000003oool0oooo0?ooo`0000000`3oool0
0`000000oooo000000030?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`0000000P3oool00`000000oooo0?ooo`040?ooo`030000003oool0
000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo00000002
0?ooo`030000003oool0oooo00L0oooo00<0e=3809BEXP3oool00`3<cM/5
03lm?@@0c<gK00H0oooo09BEXP1oWKT0IVIn0:RY^`3ko?d106IVOP0000L0
IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000<0oooo00<000000?ooo`3o
ool00`3oool3000000@0oooo00<000000?ooo`3oool00`3oool200000080
oooo100000030?ooo`<00000103oool01@000000oooo0?ooo`3oool00000
00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`@000000P3oool4
000000@0oooo0P0000030?ooo`030000003oool0000000@0oooo0P000002
0?ooo`050000003oool0oooo0?ooo`0000000P3oool3000000<0oooo00<0
00000?ooo`0000002@3oool00`3Dd<P0U9FR0?ooo`020=7Bh0<0?cdm00@0
dM;P03lm?@0o?Cd0?cdm0`3Ad^001P3oool0U9FR07nM^@1VIWh0Z:Vk0?_l
o@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`0000000`3oool0
0`000000oooo0?ooo`020?ooo`090000003oool0oooo0?ooo`000000oooo
0000003oool0000000L0oooo00<000000?ooo`0000001@3oool02@000000
oooo0?ooo`3oool000000?ooo`000000oooo000000030?ooo`050000003o
ool0oooo0?ooo`000000103oool010000000oooo0?ooo`0000050?ooo`03
0000003oool0oooo00L0oooo00H000000?ooo`3oool000000?ooo`000006
0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool0
1P000000oooo0?ooo`000000oooo000000T0oooo00@0e=3809BEXP3oool0
fM[T0`0o?Cd30=WJi0<0?cdm0P3If^@01P3oool0U9FR07nM^@1VIWh0Z:Vk
0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`0000000`3o
ool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?ooo`000000
0P3oool2000000<0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?oo
o`8000000`3oool01@000000oooo0?ooo`3oool0000000@0oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo000000030?ooo`030000003o
ool0000000<0oooo00@000000?ooo`3oool0oooo0P0000020?ooo`070000
003oool0oooo0?ooo`000000oooo000000030?ooo`030000003oool00000
00<0oooo00@000000?ooo`3oool0oooo0P0000090?ooo`030=C@b02DUJ80
oooo0080hn?[00<0?cdm0>?Sj`3Shn/00`3Shn/02P0o?Cd0hn?[0>?Sj`3S
hn/0oooo09BEXP1oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@020?ooo`<000001P3oool3000000@0oooo00<000000?oo
o`3oool00P3oool3000000<0oooo100000020?ooo`<00000103oool00`00
0000oooo0?ooo`020?ooo`<000000P3oool500000080oooo0`0000030?oo
o`<000000`3oool3000000D0oooo00@000000?ooo`3oool0oooo0`000003
0?ooo`<000000`3oool3000000D0oooo00<000000?ooo`3oool01`3oool0
0`3Dd<P0U9FR0?ooo`0<0>c/l@060?ooo`2DUJ80Oifi06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0L@3oool00`3Dd<P0U9FR
0?ooo`0<0?Cdm`060?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT0L@3oool00`3Dd<P0U9FR0?ooo`0<0?_l
o0060?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0L@3oool00`3Dd<P0U9FR0?ooo`0=0?ooo`0509BEXP1o
WKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
L@3oool00`3Dd<P0U9FR0=KFf`0<0?ooo`060=KFf`2DUJ80Oifi06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0L@3oool01@3D
d<P0e]_I08n@WP2e]Kh0];Bn00D0];Bm00/0/kBm0;Bd_@2c];d0];Bm0;>c
_@2<SI`0e]_I07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@1a0?ooo`0:0=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??c
m`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0
IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0L@3o
ool02P3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/2
0?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi06IVOP2XZK/0nocm0040
IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0740oooo00X0e=380>c^l`3/
ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0P3inO/02@3jn_d0no_n
0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@1a0?ooo`0:0=C@b03/k_<0k>od0>k_m03_l?D0l?7f
0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01o
WKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
0P3oool3000000<0oooo00<000000?ooo`000000100000020?ooo`<00000
0P3oool5000000030?ooo`000000000000<000000P3oool3000000<0oooo
0`0000020?ooo`D000000`3oool00`000000oooo0?ooo`020?ooo`<00000
0`3oool3000000<0oooo0`0000050?ooo`050000003oool0oooo0?ooo`00
00001@3oool3000000<0oooo0`0000030?ooo`<000000`3oool3000000<0
oooo00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk
0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000<0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`050000003o
ool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool00000
00<0oooo00@000000?ooo`3oool000001P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000040?ooo`070000003oool0oooo0?ooo`000000oooo000000030?oo
o`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool03@00
0000oooo0?ooo`3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Og
n@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000<0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`05
0000003oool0oooo0?ooo`0000001@3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3o
ool0000000D0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000001000
00020?ooo`030000003oool0oooo0080oooo00D000000?ooo`3oool0oooo
000000050?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0
0`3oool03@000000oooo0?ooo`3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3c
loL0m?Gi0?Ogn@3hn?/00P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3o
ool0000000<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`030?ooo`030000003oool000000080oooo00<000000?ooo`3oool0
0P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo000000030?ooo`030000003oool0oooo00<0
oooo00d000000?ooo`3oool0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g
0?Cen@3gmoT0n?Sk0080nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0
IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo
000000030?ooo`030000003oool0oooo00H0oooo00@000000?ooo`3oool0
oooo0P0000060?ooo`030000003oool0oooo00<0oooo00<000000?ooo`00
00000`3oool010000000oooo0?ooo`3oool2000000H0oooo00D000000?oo
o`3oool0oooo000000050?ooo`8000000P3oool400000080oooo10000003
0?ooo`030000003oool0000000@0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`030000003oool0000000<000000P3oool01P000000oooo0?oo
o`3oool000000?ooo`@000000`3oool02P3Dd<P0k>kc0>c_m03^ko@0ko3e
0?3amP3cloL0m?Gi0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3D
d<P0Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0
Oifi0?ooo`0000000`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`030?ooo`050000003oool000000?ooo`000000
1`3oool00`000000oooo000000050?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`0000001@3oool010000000oooo0?ooo`0000030?ooo`03
0000003oool0000000D0oooo00L000000?ooo`3oool0oooo0000003oool0
000000H0oooo00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3g
moT0n?Sk0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000<0
oooo00<000000?ooo`3oool00P3oool01`000000oooo0?ooo`3oool00000
0?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0
000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo00000003
0?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00P000003
0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00@0oooo0P0000050?ooo`040000003o
ool0oooo000000<0oooo00@000000?ooo`3oool00000103oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool02P3D
d<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/20?Win`09
0?[jo@3knoh0no_n0?_koP3Dd<P0Oifi06IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo0`0000060?ooo`<000000`3o
ool3000000<0oooo0`0000030?ooo`<000000`3oool3000000<0oooo0`00
00030?ooo`<00000103oool00`000000oooo0?ooo`020?ooo`<000000`3o
ool400000080oooo100000040?ooo`030000003oool0oooo00D000000P3o
ool3000000<0oooo100000020?ooo`<000000`3oool400000080oooo00X0
e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0P3inO/0
2@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@1a0?ooo`0:0=C@b03/k_<0k>od0>k_
m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3knoh0
no_n0=C@b01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT0L@3oool02P3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0
m?Gi0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi06IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0740oooo
00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0P3i
nO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@1a0?ooo`0:0=C@b03/k_<0k>od
0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3k
noh0no_n0=C@b01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0L@3oool02P3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3c
loL0m?Gi0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0740
oooo00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk
0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@1a0?ooo`0:0=C@b03/k_<0
k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_k
oP3knoh0no_n0=C@b01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1oWKT0L@3oool02P3Dd<P0k>kc0>c_m03^ko@0ko3e0?3a
mP3cloL0m?Gi0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0740oooo00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0
n?Sk0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`<000000`3o
ool00`000000oooo0?ooo`03000000<0oooo0`0000030?ooo`<00000103o
ool00`000000oooo0?ooo`020?ooo`<00000103oool00`000000oooo0?oo
o`020?ooo`<000001@3oool010000000oooo0?ooo`3oool3000000<0oooo
0`0000030?ooo`<000000`3oool3000000<0oooo0`0000040?ooo`030000
003oool0oooo0080oooo0`00000?0?ooo`0:0=C@b03/k_<0k>od0>k_m03_
l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3knoh0no_n
0=C@b01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP1oWKT0oooo000000030?ooo`030000003oool0oooo0080oooo00L00000
0?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`000000
0`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool0
0`000000oooo0?ooo`020?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003o
ool0000000<0oooo00<000000?ooo`0000000`3oool01@000000oooo0?oo
o`3oool0000000<0oooo00D000000?ooo`3oool0oooo0000000>0?ooo`0:
0=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk
00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo000000030?ooo`030000003o
ool0oooo0080oooo00L000000?ooo`3oool0oooo0000003oool0000000<0
oooo00<000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo00000004000000030?ooo`00
0000oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0000
00030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool00`3o
ool01@000000oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool0
303oool02P3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3h
n?/20?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi06IVOP2XZK/0nocm
0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`0000000`3oool0
0`000000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`000000oooo
000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0
oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000P3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003o
ool0oooo00@000000`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00`0oooo00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Ce
n@3gmoT0n?Sk0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0
Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool00000
00<0oooo00<000000?ooo`3oool00`3oool3000000<0oooo0`0000030?oo
o`<00000103oool00`000000oooo0?ooo`020?ooo`<00000103oool00`00
0000oooo0?ooo`020?ooo`<000000`3oool00`000000oooo000000030?oo
o`<00000103oool200000080oooo100000030?ooo`<000000P3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3oool2
000000l0oooo00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3g
moT0n?Sk0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000<0
oooo00<000000?ooo`3oool00P3oool01`000000oooo0?ooo`3oool00000
0?ooo`0000000`3oool00`000000oooo000000030?ooo`050000003oool0
00000?ooo`0000000`3oool02@000000oooo0?ooo`3oool000000?ooo`00
0000oooo000000030?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo000000020?ooo`050000003oool0oooo0?ooo`0000001@3o
ool00`000000oooo000000050?ooo`070000003oool0oooo0?ooo`000000
oooo000000030?ooo`050000003oool000000?ooo`0000001`3oool00`00
0000oooo0?ooo`0<0?ooo`0:0=C@b03/k_<0k>od0>k_m03_l?D0l?7f0??c
m`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3knoh0no_n0=C@b01oWKT0
IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo
000000030?ooo`030000003oool0oooo0080oooo00L000000?ooo`3oool0
oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`00
0000oooo0?ooo`02000000<0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`8000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo0P00
00020?ooo`070000003oool0oooo0?ooo`000000oooo000000030?ooo`03
0000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000
oooo000000030?ooo`030000003oool0oooo008000000`3oool01@000000
oooo0?ooo`3oool0000000h0oooo00X0e=380>c^l`3/ko@0k^od0>o`m@3`
lOH0lo?g0?Cen@3gmoT0n?Sk0P3inO/02@3jn_d0no_n0?_koP3knoh0e=38
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@020?ooo`<000001P3oool3000000<0oooo0`0000030?ooo`<00000103o
ool00`000000oooo0?ooo`020?ooo`<00000103oool00`000000oooo0?oo
o`020?ooo`<000001@3oool010000000oooo0?ooo`3oool3000000<0oooo
0`0000030?ooo`<000000`3oool3000000<0oooo0`0000040?ooo`030000
003oool0oooo0080oooo0`00000?0?ooo`0:0=C@b03/k_<0k>od0>k_m03_
l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3knoh0no_n
0=C@b01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0L@3oool02P3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi
0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi06IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0740oooo00X0
e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0P3inO/0
2@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@1a0?ooo`0:0=C@b03/k_<0k>od0>k_
m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3knoh0
no_n0=C@b01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT0L@3oool02P3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0
m?Gi0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi06IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0740oooo
00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0P3i
nO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@1a0?ooo`0:0=C@b03/k_<0k>od
0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3k
noh0no_n0=C@b01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0L@3oool02P3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3c
loL0m?Gi0?Ogn@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0740
oooo00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk
0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@1a0?ooo`0:0=C@b03/k_<0
k>od0>k_m03_l?D0l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_k
oP3knoh0no_n0=C@b01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1oWKT00P3oool3000000<0oooo00D000000?ooo`3oool0
oooo000000040?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`<0
00000`3oool3000000<0oooo0`0000030?ooo`<000000P3oool500000003
0?ooo`000000000000<00000103oool010000000oooo0?ooo`3oool30000
00<0oooo0`0000020?ooo`D0000000<0oooo0000000000000`0000020?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool02P3D
d<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Ogn@3hn?/20?Win`09
0?[jo@3knoh0no_n0?_koP3Dd<P0Oifi06IVOP2XZK/0nocm0040IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`0000000`3oool00`000000oooo
0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`00
00000`3oool00`000000oooo000000030?ooo`030000003oool0000000<0
oooo00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000050?oo
o`030000003oool0oooo00D0oooo00@000000?ooo`3oool000000`3oool0
0`000000oooo000000030?ooo`040000003oool0oooo000000D0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00<0oooo00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Ce
n@3gmoT0n?Sk0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0
Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool00000
00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`050?oo
o`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`00
0000oooo000000030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`0000000`3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo
0?ooo`0000001@3oool010000000oooo0?ooo`3oool5000000D0oooo00<0
00000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000D0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00<0oooo00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g
0?Cen@3gmoT0n?Sk0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0
000000<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`05
0?ooo`030000003oool0000000<0oooo00<000000?ooo`0000000`3oool0
0`000000oooo000000030?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00
00020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`0000000`3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0080oooo00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Ce
n@3gmoT0n?Sk0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0
Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool00000
00<0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?oo
o`8000000P3oool01@000000oooo0?ooo`3oool000000080oooo0`000003
0?ooo`<000000P3oool400000080oooo100000040?ooo`8000001P3oool0
0`000000oooo0?ooo`030?ooo`060000003oool0oooo0000003oool00000
0P3oool400000080oooo100000060?ooo`030000003oool0oooo00<0oooo
00D000000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo0080
oooo00X0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk
0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo000000070?ooo`030000003o
ool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`030000003oool0000000D0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00H0
00000?ooo`3oool000000?ooo`0000020?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool03P000000
oooo0?ooo`3oool0e=380>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3g
moT0n?Sk0P3inO/02@3jn_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000<0
oooo00<000000?ooo`3oool00`3oool2000000<0oooo00L000000?ooo`3o
ool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool0
0`000000oooo000000030?ooo`040000003oool0oooo000000@0oooo00L0
00000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`00
00000`3oool00`000000oooo000000030?ooo`040000003oool0oooo0?oo
o`8000000`3oool00`000000oooo0?ooo`020?ooo`070000003oool0oooo
0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`0>0000003o
ool0oooo0?ooo`3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Og
n@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi06IVOP2XZK/0
nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo0`000007
0?ooo`030000003oool0oooo0080oooo0`0000030?ooo`<000000`3oool3
000000<0oooo0`0000030?ooo`@000000P3oool3000000<0oooo0`000003
0?ooo`<000000`3oool3000000D0oooo00@000000?ooo`3oool0oooo1000
00020?ooo`<000000`3oool3000000<0oooo0`0000020?ooo`D0000000<0
oooo0000000000000`0000020?ooo`0:0=C@b03/k_<0k>od0>k_m03_l?D0
l?7f0??cm`3dmOT0moOi0?Shn`80nOWk00T0n_[m0?_koP3knoh0no_n0=C@
b01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0L@3oool02P3Dd<P0k>kc0>c_m03^ko@0ko3e0?3amP3cloL0m?Gi0?Og
n@3hn?/20?Win`090?[jo@3knoh0no_n0?_koP3Dd<P0Oifi06IVOP2XZK/0
nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0740oooo00X0e=38
0>c^l`3/ko@0k^od0>o`m@3`lOH0lo?g0?Cen@3gmoT0n?Sk0P3inO/02@3j
n_d0no_n0?_koP3knoh0e=3807nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn07nM^@1a0?ooo`030=C@b03]l?80RhbJ00D0WIj/
00<0WIj[09fN[02MWZ`00`2MWZ`01`2MWj`0SHnK0=C@b01oWKT0IVIn0:RY
^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0L@3oool00`3D
d<P0U9FR0=gNh@0<0=3Ag`060=gNh@2DUJ80Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0L@3oool0103Dd<P0U9FR0?oo
o`3gmoT20>c/l@80j>S^00d0h^?[0=_Li@3Kg>D0e=GQ0<k?g@3<cM/0cLkL
0?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0Oifi0740oooo00@0e=3809BEXP3oool0moOi0P3/k?420>SXkP0=
0>;Rj`3KfnH0fm_V0=CEh@3>cmd0c<gK0<g>g03oool0U9FR07nM^@1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@1a0?ooo`04
0=C@b02DUJ80oooo0?Ogn@80k>ca0P3XjNl03@3ShnX0fm_V0=_KiP3DeN40
c]3M0<c=f`3=c]`0oooo09BEXP1oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT0L@3oool0103Dd<P0U9FR0?ooo`3gmoT2
0>c/l@80j>W^00d0h^?Z0=_Li@3Kg>D0eMGQ0<o?g03<cM/0cLkL0?ooo`2D
UJ80Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0740oooo00@0e=3809BEXP3oool0moOi0P3/k?4608jEXP090<o?g@3<
cM/0cLkL0?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0080oooo0`0000030?ooo`040000003oool0oooo
000000H0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`02
0?ooo`<000000`3oool3000000<0oooo0`0000030?ooo`<00000103oool0
0`000000oooo0?ooo`040?ooo`040000003oool0oooo0?ooo`<000000`3o
ool3000000<0oooo00<000000?ooo`3oool00`3oool3000000@0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`05000000P0oooo00D0
e=3809BEXP3oool0moOi0>c/l@060?ooo`0:0=CEh03>cm`0c<gK0<g>g03o
ool0U9FR07nM^@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1V
IWh0Oifi0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000
oooo000000030?ooo`030000003oool0000000<0oooo00D000000?ooo`3o
ool0oooo000000060?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`0000000`3oool010000000oooo0?ooo`0000040?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`040?ooo`050000
003oool0oooo0?ooo`0000002`3oool0103Dd<P0U9FR0?ooo`3gmoT20>c/
l@H0SYFR00T0c]3M0<c=f`3=c]`0oooo09BEXP1oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo000000030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo1@000005
0?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000103o
ool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3oool0
oooo1@0000030?ooo`030000003oool0oooo00P0oooo00D0e=3809BEXP3o
ool0moOi0>c/l@060?ooo`0:0=CEh03>cm`0c<gK0<g>g03oool0U9FR07nM
^@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?oo
o`0000000`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`040000003oool0oooo000000<0oooo100000050?ooo`050000
003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
00<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool01`3oool0103Dd<P0U9FR0?ooo`3g
moT20>c/l@H0SYFR00T0c/oM0<c=f`3=c]`0oooo09BEXP1oWKT0IVIn0:RY
^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo00000003
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo0`000004
0?ooo`800000103oool2000000<0oooo0`0000040?ooo`030000003oool0
oooo0080oooo00<000000?ooo`0000000P3oool01@000000oooo0?ooo`3o
ool0000000<0oooo0P0000040?ooo`040000003oool0oooo0?ooo`@00000
103oool00`000000oooo0?ooo`020?ooo`030000003oool0000000H0oooo
00<000000?ooo`3oool01P3oool01@3Dd<P0U9FR0?ooo`3gmoT0k>ca00H0
oooo00X0e=GQ0<k@g@3<cM/0cLkL0?ooo`2DUJ80Oifi06IVOP2XZK/0nocm
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo000000030?ooo`03
0000003oool0oooo00D0oooo00H000000?ooo`3oool000000?ooo`000003
0?ooo`030000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000
00050?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3o
ool01@000000oooo0000003oool0000000@0oooo00<000000?ooo`000000
0P3oool01@000000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`3o
ool00P3oool010000000oooo0?ooo`0000050?ooo`030000003oool00000
00@0oooo00<000000?ooo`0000001P3oool00`000000oooo0?ooo`060?oo
o`040=C@b02DUJ80oooo0?Ogn@80k>ca1P2>UJ802@3?cmd0c<gK0<g>g03o
ool0U9FR07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0
IVIn07nM^@3oool0000000<0oooo00<000000?ooo`3oool01@3oool01000
0000oooo0?ooo`3oool2000000@0oooo0P0000030?ooo`070000003oool0
oooo0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo
00<000000?ooo`0000000`3oool00`000000oooo0?ooo`02000000D0oooo
0P0000020?ooo`070000003oool0oooo0?ooo`000000oooo000000030?oo
o`030000003oool0oooo0080oooo00@000000?ooo`3oool000000`3oool0
0`000000oooo0?ooo`02000000D0oooo0P0000020?ooo`050000003oool0
oooo0?ooo`000000203oool01@3Dd<P0U9FR0?ooo`3gmoT0k>ca00H0oooo
00X0e=GQ0<k?g03<cM/0cLkL0?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool3000000D0oooo1@00
00030?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3o
ool3000000<0oooo0`0000030?ooo`<000000`3oool3000000@0oooo00<0
00000?ooo`3oool0103oool010000000oooo0?ooo`3oool3000000<0oooo
0`0000020?ooo`D000000P3oool3000000@0oooo00<000000?ooo`3oool0
103oool010000000oooo0?ooo`3oool3000000T0oooo00@0e=3809BEXP3o
ool0moOi0P3/k?420>WYkP0=0>?SjP3Kg>D0fmcU0=CEh03>cm`0c<gK0<g>
g03oool0U9FR07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@1a0?ooo`040=C@b02DUJ80oooo0?Ogn@80k>ca0P3Xj>l0
3@3Rh^X0fm_U0=_Ki@3DeN00c]3M0<c=f`3=c]`0oooo09BEXP1oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0L@3oool0
103Dd<P0U9FR0?ooo`3gmoT20>c/l@80j>W^00d0hn;[0=_KiP3KfnH0e=GP
0<k?g03<cM/0cLkL0?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0740oooo00@0e=3809BEXP3oool0moOi
0P3/k?420>WYkP0=0>?SjP3KfnH0fm_V0=CEh03>cmd0c<gK0<g>g03oool0
U9FR07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
07nM^@1a0?ooo`030=C@b02DUJ80e]KK00`0oooo00H0e]KK09BEXP1oWKT0
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@1a0?oo
o`030=C@b03moOX0T96O00D0]kNo00<0];Bm0;Ng_`2g]kl0102g]kl01P2@
TIl0e=3807nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0Oifi0740oooo00<0e=380>c]m02;S9T0302MWZ/01P2:RiT0hnK]07nM
^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0740
oooo00<0e=3809BEXP3Mg^40303If^@01P3Mg^40U9FR07nM^@1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0740oooo00<0e=38
09BEXP3oool0303;c=X01P3oool0U9FR07nM^@1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0740oooo00<0e=3809BEXP3oool0
303;c=X01P3oool0U9FR07nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0080oooo0`0000030?ooo`030000003oool0oooo
00<00000103oool00`000000oooo0?ooo`020?ooo`<00000103oool00`00
0000oooo0?ooo`020?ooo`<000000`3oool3000000<0oooo0`0000020?oo
o`D0000000<0oooo0000000000000`0000020?ooo`<000000`3oool30000
00<0oooo00<000000?ooo`3oool00`3oool3000000<0oooo0`0000020?oo
o`D000000P3oool3000000T0oooo00<0e=3809BEXP3oool0303;c=X01P3o
ool0U9FR07nM^@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1V
IWh0Oifi0?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`050000
003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool00000
00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`070000003oool0
oooo0?ooo`000000oooo000000030?ooo`030000003oool0000000<0oooo
00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`020?ooo`07
0000003oool0oooo0?ooo`000000oooo000000030?ooo`040000003oool0
oooo000000@0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0
oooo00@000000?ooo`3oool00000103oool01@000000oooo0?ooo`3oool0
000000P0oooo00<0e=3809BEXP3oool0303;c=X01P3oool0U9FR07nM^@1V
IWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`00
00000`3oool00`000000oooo0?ooo`020?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`050?ooo`050000003oool0oooo
0?ooo`0000001`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
000000<0oooo00D000000?ooo`3oool0oooo000000050?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`040000
003oool0oooo000000P0oooo00<000000?ooo`0000000`3oool01@000000
oooo0?ooo`3oool0000000L0oooo00<000000?ooo`3oool01P3oool00`3D
d<P0U9FR0?ooo`020<_<fP0303lm?@3;c=X0blcJ00<0blcJ00X0?cdm0<_<
fP3;c=X0blcJ0?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP1oWKT0oooo000000030?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0
oooo00D0oooo00D000000?ooo`3oool0oooo000000040?ooo`@000001@3o
ool00`000000oooo000000030?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool00`3oool010000000oooo0?ooo`0000030?ooo`030000
003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000070?ooo`03
0000003oool0000000<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00H0oooo00@0e=3809BEXP3o
ool0c<gK0`0o?Cd30<c=f`<0?cdm0P3<cM/01P3oool0U9FR07nM^@1VIWh0
Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`000000
0`3oool00`000000oooo0?ooo`020?ooo`@00000103oool010000000oooo
0?ooo`3oool4000000@0oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0000000<000000P3oool4000000H0oooo00<000000?oo
o`3oool00`3oool00`000000oooo000000030?ooo`030000003oool00000
00<00000103oool00`000000oooo0?ooo`030?ooo`8000000P3oool01@00
0000oooo0?ooo`3oool0000000D0oooo00<000000?ooo`0000000`000009
0?ooo`030=C@b02DUJ80oooo0080dM;P0`0o?Cd0103Ad^00?cdm03lm?@0o
?Cd30=7Bh0060?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP1oWKT0oooo000000030?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00`3oool00`000000oooo000000030?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3oool01`00
0000oooo0?ooo`3oool000000?ooo`0000001@3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`0000000`3o
ool00`000000oooo000000080?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`0000000`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0000000`0oooo00<0e=3809BEXP3oool00`3If^@503lm?@@0fM[T00H0
oooo09BEXP1oWKT0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0
IVIn07nM^@3oool0000000<0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool000000080oooo0P0000040?ooo`030000003oool0
oooo00<0oooo0P0000030?ooo`050000003oool0oooo0?ooo`0000000P3o
ool00`000000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`000000
oooo000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`00
00000`3oool010000000oooo0?ooo`0000070?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo00000003
0?ooo`040000003oool0oooo000000/0oooo00<0e=3809BEXP3oool0103S
hn/303lm?@D0hn?[00H0oooo09BEXP1oWKT0IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`<000001P3oool3000000@0
oooo00<000000?ooo`3oool00P3oool4000000<0oooo00<000000?ooo`3o
ool00P3oool3000000<0oooo100000020?ooo`<000000`3oool3000000<0
oooo0`0000030?ooo`<000000`3oool4000000030?ooo`000000000000<0
00000P3oool3000000<0oooo0`0000030?ooo`<000000`3oool4000000P0
oooo00<0e=3809BEXP3oool01@3/k?400`0o?Cd0k>ca0>c/l@040>c/l@06
0?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT0L@3oool00`3Dd<P0U9FR0?ooo`0<0?Cdm`060?ooo`2DUJ80
Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
L@3oool00`3Dd<P0U9FR0?ooo`0<0?_lo0060?ooo`2DUJ80Oifi06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0L@3oool00`3D
d<P0U9FR0?ooo`0=0?ooo`0509BEXP1oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0L@3oool00`3Dd<P0U9FR0=KFf`0<
0?ooo`060=KFf`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1oWKT0L@3oool01@3Dd<P0e]_I08n@WP2e]Kh0];Bn00D0
];Bm00/0/kBm0;Bd_@2c];d0];Bm0;>c_@2<SI`0e]_I07nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInQ01oWKT00`1VIWh0Z:Vk
0?_lo@0106IVOP0000<0IVIn0?Ogn@2HV:L0QP1gMi8109RHY`40moOi0@1V
IWh0000306IVOP3gmoT0_;g=08L0_;g=0@3gmoT106IVOP0000<0IVIn0?Og
n@3Thn<0Q`3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`100?ooo`03
0>CSh`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2L
Y;T0i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@
2@1[MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:Hi
A02W>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0
000F06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3l
o?`0o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_l
o080o?cl00@0o?cm0?clo03knod0o?cm6P3lno`=0?_lo00309bT^@1[MHl0
QHV`0100QHV`00H0JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9/00606]e
S`2LY;T0nocl0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_lo03lo?`0
o?_m0?_lo@3RhN800@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0
m_Oh0?Ogn@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi0?Kgn@02
0?Ogn@040?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3gmoT06@3g
moT=0?Kgn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi
06]eS`25RK0A09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36
E5X=0<IEG0090<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q
0040IVIn00001P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm100000000H0lO7d
0?3bm@3alO@0lO;d0?3bm03alO@W0?3am@0306]eS`2b]M00YjS20100YjS2
00H0/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e
0?7bm02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0
`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3Lfn00
j^_`0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0inOW
0>OWi`030>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0
j^_`0>[[l00H0>[[l0d0j^c`00@0JgF?0;Jid@2][/H0[Jk6203oool00`2]
[/H0[:k60:f^aP030:f^aP030:b^aP2f^M40JgF?0080j^__00@0JgF?0;Ji
d@2][/H0[Jk6303oool20:f^aP030:b^aP2f^M40JgF?0080j^_`00D0YSU4
0<eIGP3;E5T0cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0
j^__0>[[l0020>[[k`40g=_P0@1VIWh0000406IVOP3IfMl0hnGZ0>?TjP80
hnG[00D0000008b<S03Ng]h0inOW0=kNgP020>OWi`030<IS003WinL0inOW
0080inOW00L0knoW0>o_k`3_knl000000>?TjP3Si>/0hnGZ0080hnCZ00<0
hnC[0>?Uj`3SiN/0603SiN/=0>?TjP0506]eS`2l_]@0/[;:0;:bbP3oool0
1P1^KHl00`0U9CH0/[;:0;:bbP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[
MHl0_;kD0P2b//X00`3oool09BDf02DU=P0902DU=P<0/[;:00D0_;kD06]e
S`3Si>/0hnC[0:HiA0020<eIGP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3o
ool02P3DG5l0d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl1
06IVOP0000<0IVIn0=OHgP3Lg^H00`3Lg^H01@000000inOW0>OWi`3WinL0
imK>0080inOW00D0cW/00>nD403WinL0imk60>n<40030>o_k`070000003L
g^H0g=kU0=cNi@3Lg^H0g=kU0=cNiP0W0=cNi@0506]eS`2o`MH0^;W>0;Ri
cP3oool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU
0=cNi@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U
9CH0^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AM
H@1C9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA002
0=cNi@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>42
0=GHh0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080
gV/000D0kkF<0>o_k`3_knl0kno_000000020=GHh@040=GGh03Ff>00e]SQ
0=KGhAX0e]OP3@3Ff>001@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l
_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l
_M401`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GG
h@2V>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`16
7QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1V
IWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ON
cP36BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh00000
0`3@d]`00`3?d]`0d=;L0<oBg00J0=3Bg0d0cm;M00<0JgF?0<S9f`33a=H0
4033a=H01P38bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80`lCF00<0oooo02DU
=P33a=H01`33a=H00`3oool09BDf0<?4eP020<?4eP070<S9f`1[MHl0cm;L
0<oBg02V>D@0eemO0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD0
0`3oool020167QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`1
0<oBg040d]CM0@1VIWh0000L06IVOP3@d]/0blgH0<[=f@3;c]P0b/gH0000
003WaZd0ilJ<0?O>603__@00mlH00>n]003W[@00ijD00=J<003>J`00ilH0
0?oF003_knL0kno_0000003;cMP0blgI0<[=f@3;c]P0b/gH0<_=f1X0blgI
3@3;c]T00`1[MHl0blcN0<S:f@080<S:f@030<S9f@38b]T0b<[I00<0b<[I
00@0b<WI0<S:f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN0<S:f@38b]T0oooo
02DU=PD0b<[I0140b<WI0<S:f@38b]T0oooo02DU=P38b]T0b<WI0<S:f@3;
c=h0JgF?0<_>f03:cMP0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN
6P3oool0oooo00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO
0:HiA03:c]P0b/kI0P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e003
0<G8e00600000036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<0
0=JD00020?O60080moOg00@000000<G8e035am@0aLOD0`35amDJ0<C7e@d0
a<SD00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?
0=3Ah080bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g002
0<_;g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN
6P3oool0oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8
e040aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P00
0000inOW0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD0
0?Nm003_knl0moOg000000<0`LCB00<0`/CA0<74dP31a=806P31a=4=0<74
dP0306]eS`3Cdn80cm3M0100cm3M00H0dm?R06]eS`32a=80`/CB06]eS`3C
dn820<o@g@030?ooo`0U9CH0cm3M00L0cm3M00<0oooo02DU=P3?d=d00P3?
d=d01`3Cdn80JgF?0<;4dP31a=40YSU40=]TI03QJFD01@3PK6T50?ooo`D0
h6aY00P0hFUU0=]TI02V>D@0`LCB0<;4d@31a=40`LCB0<c>fP40IVIn0000
101VIWh0b/cH0;k0c`2m`<l20;k0cP050000002LW9`0inOW0>ONeP3FS000
0P3NU000103FN`00aV<00;e2003_Y@020?N]00080?Ne003ocTX000000;k0
cP2n`<l0_/3>0;k0c`2m`<hK0;k0cPd0_L3>00<0JgF?0=KFi03Cdn00403C
dn001P3Fe^@0JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3o
ool0203oool02`0U9CH0dm?P0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:Hi
A03PIVD0hFYZ00@0hfa/0`3oool010167QX0oooo0?ooo`3oool40>=/K004
0>5ZJP3PIVD0YSU40;g0c`80_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0
bL[H0;Jhb02i_</0^[c;0;Zlc00000000P3_knl04`3FW000eX`00=jD003F
Q000kjD00=j<002mFP00eW<00>nL003gknL0moOg0?ooo`000000^Kc<0;Zk
c02i_</0^[c;0;Vlc02i_</06P2i_<`=0;Zlc00306]eS`3Hf>D0dm?Q0100
dm?Q00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0
KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V
>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3o
ool20>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H
0040IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OW
gP020>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Ogm`05
0000002f^LT0]kS90;Jib@2g^LT00P2f^<TJ0;Nhb@d0][S900@0JgF?0=KF
i03Hf>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@090=KFi01[MHl0
]kS90;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d09BDf0=SHiP3H
f>D0f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0
oooo00D0AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>AdK`3WLFl0i7A_
0>A^K@2V>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn00000`1VIWh0a/SG
0;Bfa`030;Bfa`030000003_knl0kno_0080kno_00/0ijd00?O6203WY@00
ii@00>N<003_imH0gY@i0>oF]@3omoL0oooo0000000]0;Bfa`0506]eS`3E
eN<0g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GE
h`80g=_W00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GEh`1[MHl0];K7
0;Bfa`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ0>UnN03YOWP0
0`3YOWP020167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d]/L1
0<K8e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`060000002<S8`0kno_
0>o_k`3WcW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0knOF0?Ogm`3o
ool00000;@2d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0];K7
0;Bfa`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0YSU40>YiL`3Y
O7P0kh5j0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:0>^H
R`0204HN6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L10<K8e`40IVIn
00000`1VIWh0a/SG0;6cb0030;6cb0060000003_knl0kno_0>o_k`3gmnl0
kno_0P3gmoL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`000000/K?802`0
/K?800<0JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?
0>g[la40jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03g
WHh0lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[
UP3gWHh0mHb40?24O03aP7D0YSU400@0/K?80@36b=L106IVOP0000<0IVIn
0<K8e`2h]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3o
moL20?ooo`030000002_[/L0[jk702/0[jk700<0JgF?0=;Ah`3blOL0403b
lOL01P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0d]7S06]eS`2_
[/L0[jk70:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^a`02
0:n^a`40^;O?0@36b=L106IVOP0000<0IVIn0<31d@37am@0@02/Zl@01024
S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400@0
Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a007
096HZP2V>D@0oin=0?joY03jg;L0n^^g0?[Y]P020?WY]P040?[Y]P3ijKH0
nNVf0?[Y]P80nNVf00H0n^^g0?[L]`3n_j@0oin=0:HiA02AV:X30:b[a040
alOD0@30`M4106IVOP0000@0IVIn0<31d@3Bd]l0]KC9@02TXkh00`24S:80
JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]eS`1[
MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V>D@0YSU400l0
YSU400L0Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040IVIn00001P1V
IWh0Z:No0>KVk@3Bd^00_;c?0;6`a800Z:No00D0/K340;blc`3Bd^00i^K]
0:RW_`0106IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@d>00b/[J07h0
_;c?00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ00000P0F5MX06IV
OP2EU:/0emSR0?clo03blO<0k>_^0>7Rjg`0emSR00L0hN;[0>c[kP3blO<0
o?cl0=OHhP2EU:/0IVIn0040F5MX000205QGJ00306IVOP2EU:/0dM7N0080
o?clOP3oool20?clo0030=7AgP2EU:/0IVIn0080F5MX000305QGJ080IVIn
00<0R8NM09FDZ`2XYkl0O@2XYkl0102EU:/0R8NM06IVOP1VIWh305QGJ000
1@1HEfR206IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  Evaluatable->False,
  ImageSize->{140, 138},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"List"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"List"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"ComboBox\"]", "ObjectName",
  CellTags->"ComboBox"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"items\" \[Rule] {", "Program"],
  StyleBox["item1", "Program",
    FontSlant->"Italic"],
  StyleBox[", ", "Program"],
  StyleBox["item2", "Program",
    FontSlant->"Italic"],
  StyleBox[", \[Ellipsis]}\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"selectedItem\"\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"editable\" \[Rule] False\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"autocomplete\" \[Rule] True", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"ComboBox"],

Cell[TextData[{
  StyleBox["Events", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"action\" - ", "Program"],
  StyleBox["triggered when there is a change in the current selection", 
    "Text"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"ComboBox"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"ComboBox"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<ComboBox\>", \ {\
\[IndentingNewLine]"\<items\>" \[Rule] 
                Script[{"\<Choice A\>", \ "\<Choice B\>", \ "\<Choice C\>", \ \
\ "\<Choice D\>", \ \ "\<Choice E\>"}]\[IndentingNewLine]}]\ \
\[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"ComboBox"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"ComboBox"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000=B000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0Oifi
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
H02b];l00`3/kO@0RhbI09fNZ`0<09fNZ`0608Z;V@2d]kh0Oifi06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0H02b];l00`2D
UJ80gMkQ0=WJi00<0=WJi0060=gNh@2DUJ80Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0H02b];l00`2DUJ80oooo0<_<
fP0<0<_<fP060?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1oWKT0H02b];l00`2DUJ80oooo0<_<fP0<0<_<fP06
0?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT00`2b];l300000080/[Bo00D000000;:d_`2b];l0/[Bo0000
00020;:d_`<000000P2b];l00`000000/[Bo0;:d_`03000000<0/[Bo0`00
00050;:d_`030000002b];l0/[Bo00<0/[Bo00<000000;:d_`2b];l0<P2b
];l00`2DUJ80oooo0<_<fP0<0<_<fP060?ooo`2DUJ80Oifi06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P2b];l01`000000
/[Bo0;:d_`2b];l000000;:d_`0000000`2b];l00`000000/[Bo00000003
0;:d_`050000002b];l000000;:d_`0000000`2b];l00`000000/[Bo0000
00030;:d_`030000002b];l0/[Bo0080/[Bo00<000000;:d_`2b];l00`2b
];l00`000000/[Bo0;:d_`0b0;:d_`0309BEXP3oool0blcJ00D0blcJ00<0
?cdm0<_<fP3;c=X0103;c=X01P3oool0U9FR07nM^@1VIWh0Z:Vk0?_lo@40
IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0;:d_`0000001P2b];l01`00
0000/[Bo0;:d_`2b];l000000;:d_`0000000`2b];l01@000000/[Bo0000
002b];l0000000D0/[Bo00<000000;:d_`2b];l01`2b];l5000003D0/[Bo
00<0U9FR0?ooo`3<cM/0103<cM/303lm?@D0c<gK00H0oooo09BEXP1oWKT0
IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l0
000000H0/[Bo00L000000;:d_`2b];l0/[Bo0000002b];l0000000<0/[Bo
00D000000;:d_`000000/[Bo000000050;:d_`D000001@2b];l01@000000
/[Bo0;:d_`2b];l0000003D0/[Bo00<0U9FR0?ooo`3Ad^000`3Ad^0503lm
?@@0dM;P00H0oooo09BEXP1oWKT0IVIn0:RY^`3ko?d106IVOP0000L0IVIn
0?_lo@2XZK/0IVIn07nM^@2b];l0000000H0/[Bo0P0000020;:d_`030000
002b];l0000000<0/[Bo00D000000;:d_`000000/[Bo000000030;:d_`03
0000002b];l0000000<0/[Bo00<000000;:d_`2b];l0102b];l00`000000
/[Bo0000000f0;:d_`0309BEXP3oool0fM[T0080fM[T0`0o?Cd0103If^@0
?cdm03lm?@0o?Cd30=WJi0060?ooo`2DUJ80Oifi06IVOP2XZK/0nocm0@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo000000060;:d_`040000
002b];l00000000000<0/[Bo0`0000020;:d_`030000002b];l0/[Bo00<0
00000`2b];l3000000L0/[Bo00<000000;:d_`000000=P2b];l0102DUJ80
oooo0=WJi03If^@303lm?@<0fM[T0`0o?Cd20=WJi0060?ooo`2DUJ80Oifi
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P2b
];l01`000000/[Bo0;:d_`2b];l000000;:d_`0000007P2b];l00`000000
/[Bo0000000f0;:d_`0309BEXP3oool0hn?[0080hn?[00<0?cdm0>?Sj`3S
hn/00`3Shn/02P0o?Cd0hn?[0>?Sj`3Shn/0oooo09BEXP1oWKT0IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@030;:d_`<00000
0P2b];l00`000000/[Bo0;:d_`090;:d_`030000002b];l0/[Bo0140/[Bo
00<000000;:d_`2b];l0=@2b];l00`2DUJ80oooo0>c/l@0<0>c/l@060?oo
o`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0H02b];l00`2DUJ80oooo0?Cdm`0<0?Cdm`060?ooo`2DUJ80Oifi
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0H02b
];l00`2DUJ80oooo0?_lo00<0?_lo0060?ooo`2DUJ80Oifi06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0H02b];l00`2DUJ80
oooo0?ooo`0=0?ooo`0509BEXP1oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT0H02b];l00`2DUJ80e]KK0?ooo`0<0?oo
o`060=KFf`2DUJ80Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0H02b];l0103oool0Si2N0;Fe_P2d];h50;Bd_@0<0;>d
_@2d];d0];Bm0;>d_@2d];d0/k>m08b=W02d]kh0Oifi06IVOP2XZK/0nocm
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0Oifi00<0IVIn0:RY^`3ko?d0
0@1VIWh0000306IVOP3gmoT0V9RW07D0MgNB0@2HV:L10?Ogn@40IVIn0000
0`1VIWh0moOi0;bmc@1f0;bmc@40moOi0@1VIWh0000306IVOP3gmoT0i>?S
07H0i>?S0@3gmoT106IVOP0000<0IVIn0?3am03oool0;`3oool00`3Thn<0
W:Bi06]eS`0306]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CS
h`3oool0oooo0>CSh`2LY;T406]eS`0406afT01[MHl0K7J@06afT0T0JgF?
00H0W:Bi0>CSh`3oool0oooo0>cZjP2LY;T40:HiA0040:LjA02V>D@0YcY4
0:LjA0T0YSU400<0W:Bi0>cZjP3oool00`3oool10?3am040IVIn00005P1V
IWh0h^7R0?_lo03kno`0nocm0?cko@3knod0nocm0?_lo03lo?d0o?cl0?ck
o@3lo?`0o?_l0?clo03ko?`0o?cl0?_lo@3lno`0o?cm0?_ko@3ko?`20?cl
o0040?clo@3lo?`0no_m0?cloA@0o?_l0P3ko?`00`2LY;T0JgF?08F9/00@
08F9/00606]eS`2LY;T0nocm0?_lo@2LY;T0JgF?4@25RK001P1[MHl0W:Bi
0?_lo03kno`0W:Bi0:HiA140ZSaE00L0YSU409bT^@3ko?`0o?cl0?cko@3k
o?d0h^7R0040IVIn0000101VIWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kgn03g
moT0moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3gmoT0
103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0moOi01<0moOi0P3f
moT00`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[MHl0
QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ3@36
EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@0106IV
OP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@000000060?7am03`l_D0
lO7d0?7bm03`l_@0lO7d5P3`lOD00`1[MHl0/[G@0:NX`P0@0:NX`P060;:e
d01[MHl0l?7d0?3am01[MHl0/[G@4@2WZ<801@2b]M00JgF?0?3am@3al_@0
YSU40080`U9K00<0beAI0<eIGP3=FEh02`3=FEh0103;E5T0`U9K0<9BF`2V
>D@20?3am0030?7am03`l_@0g]gQ0040IVIn00001`1VIWh0g=_P0>[[l03Z
jo00j^c`0>W[k`0000000P3WinL20=kNgP80inOW00<0ikf40>OWi`3WinL0
0`3WinL20>o_k`040000003Zjo00j^_`0>[[k`80j^_`00<0j^__0>[[l03Z
jo004P3Zjo020>[/l00406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk60:b^
aP2][/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`0406]eS`2f^M40[Jk6
0:f^aP`0oooo0P2][/H00`2/[/H0][WA06]eS`020>[[l0050:HiA03=FEh0
beAI0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK0<]DF@3=FEh0YSU40>[[k`3Z
jo000P3Zjnl10=cKh040IVIn0000101VIWh0fMWO0>?UjP3Si>X20>?Uj`05
0000002<S8`0g]kN0>OWi`3Ng]h00P3WinL00`36H`00inOW0>OWi`020>OW
i`070>o_i`3_knl0kno_0000003Si>X0hnC[0>?UjP020>?TjP030>?Tj`3S
iN/0hnG[0180hnG[0P3Si>X01@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?
00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bn
e080/[;:00<0oooo02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[
0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0
e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0
000306IVOP3Gf=h0g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OFcP02
0>OWi`050<ik003_U100inOW0>ONaP3_S1000`3_knl01`000000g=kV0=cN
i@3Lg^D0g=kV0=cNi@3Lg^H05P3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo
00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0
JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;Ri
cP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP
00<0oooo1@3FGf<30?ooo`0505<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D0
0`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>00
2@000000S8b<0>OWi`3WinL0ikF40=IJ003FQ000olh00<iS00020=i[0005
0>neS03_knl0kno_0>o_k`0000000P3Ef>40103Een00e]SP0=KHh@3Fen4D
0=KGh080e]SP00D0JgF?0<?5f@2l_M40_;gA0?ooo`0702DU=PL0_;gA00H0
`lGI06]eS`3Ef>40eMSQ06]eS`33aMT20;bmd@030?ooo`0U9CH0_;gA00L0
_;gA00<0oooo02DU=P2l_M400P2l_M401@33aMT0JgF?0=KGh03Een40YSU4
0080eEeP00<0f61Q0=UQHP167QX00`3oool30=UQHP<0oooo00<0AQhJ0=UQ
HP3HH6400P3EGF001P2V>D@0e]SP0=GHh@3Een00eMSQ0=GFg@40IVIn0000
1`1VIWh0d]CM0<oBg03@d]`0d=;M0=3Bg00000000`3WinL0303Wg/h0aTX0
0?O>003_[@00kkD00<i[0036FP00aV/00=j<BP3WY@00knO>000000<0d=;L
00<0cm;L0=3Bg03?d]`0503@d]`20<oBg@0306]eS`38bM/0`lCF0100`lCF
00H0b<WK06]eS`3@d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U9CH0`lCF
00L0`lCF00<0oooo02DU=P33a=H00P33a=H01`38bM/0JgF?0<oBg03?d]`0
YSU40=MOG`3IHF800`3LIFD01@167QX0oooo0?ooo`3oool0g6EU00<0oooo
00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?d]`1
0=;Dg@40IVIn0000701VIWh0d=;K0<_=f03:cMT0blkH0<[=f0000000ilJ]
0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU003FS000cV/00>O6003oeP00
knoW0>o_k`000000blgH0<_=f@3:cMT0blkH0<[=f03;cMPD0<_=f@80blkI
00<0JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9
f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH5
0<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]e
S`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo
0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0
b/kH0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@0
1P000000a/K60>ONeP3>N`00ijd00>ne0080ijD000<0eY@00<ic003FU000
0P3gaP020?Ogm`0400000035b=@0aLOD0<G7e0<0aLOE5034amD20<C8e003
06]eS`3@dN00bl_L0100bl_L00H0d=7P06]eS`34am@0a<OD06]eS`3@dN02
0<_;g0030?ooo`0U9CH0bl_L00L0bl_L00<0oooo02DU=P3;bm`00P3;bm`0
1`3@dN00JgF?0<G7e034am@0YSU40=]TI03OIF@01@3PJVP01@167QX0oooo
0?ooo`3oool0AQhJ00D0h6YX00@0gfET0=]TI02V>D@0a<SE0P34b=@10<G7
e@40cloJ0@1VIWh0000406IVOP3<c]X0`/CB0<74d@80`LCB00H000000>OW
i`3WinL0inOW0=J4003_]@020>NU00080=J4003>J`00ijd00?Ne003g_@00
kno_0?Ogm`0000030<74dP030<;4d@31a=80`LCB01@0`LCA0P31a=800`1[
MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?
d=d00`3oool09BDf0<o@g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M00L0
dm?R06]eS`32a=80`LCA0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/J@08
0>5YI@3KI6@0YSU40<74dP32a=40`LCA0<74dP3<c]X106IVOP0000@0IVIn
0<[<f02n`<l0_L3?0P2n`<h01@000000W9bL0>OWi`3Wg]H0eX`00080gY@0
00@0eW/00<IS002m@P00kjD00P3g[@00203g]@00oli:0000002n`<h0_/3?
0;k0cP2n`<l0_L3>5@2n`<h20;g0cP0306]eS`3Fe^@0dm?P0100dm?P00H0
e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo00P0
oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0h6IU
0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo103SK6`0103QJVX0
h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:f02f
^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<003NU000eX@00>nU
003NS000_EX00=Ic003_W000mnoW0?Ogm`3oool000000;Vlc02j^l`0^Kc;
0;Zlb`2i_<`0^Kc;01@0^Kc<0P2j_<`00`1[MHl0f=SU0=?Ch@0@0=?Ch@06
0=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU0P3Cdn400`3oool0KVf?06i]S`08
06i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0JgF?0;Zlb`2j_<`0YSU40>1Y
J03QKF`0i75]0>AaK`3TL6h30?ooo`0304HN6P3TL6h0AQhJ00<0oooo0P3T
L6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<0;Zkc02i_</0][S80<W:f00106IV
OP0000T0IVIn0<O9e`2d]/L0][S80;Jhb@2f^LT0000008B4Q03Wimh00P3_
knl01`36J`00mlH00>ne003_W000gX`00<i[003WW0000`3gmoL01@000000
][W90;Nhb@2f^LT0]kW90080][S9502g^<T20;Jhb@0406]eS`3Fe^@0f=SU
0=SHiP<0f=SU1@3Hf>H30=SHi@80f=SV0P3Hf>D02@3Fe^@0JgF?0;Nhb@2g
^<T0JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]S`0=02DU=P3Hf>H0f=SU0=SH
i@3Fe^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3TM6l0ig5_0>AdK`030?ooo`05
04HN6P3TM6l0i7A_0>AdK`167QX00`3oool02P3TM6l0ig5_0>AdK`3TKVd0
YSU40;Jib@2f^<T0][W90;Bfa`37bML106IVOP0000<0IVIn0<K8e`2d]/L0
0`2d]/L00`000000kno_0>o_k`020>o_k`0;0>N]003gaPP0ijD00>ND003W
S000knOF0=jD>@3_e[D0ooOg0?ooo`000000702d]/L01@1[MHl0eMGS0=cK
i`3LfnL0gM_W00h0g=_W00H0eMGS06]eS`2d]/L0];K706]eS`3EeN<20=cK
i`030=gKi`0U9CH09BDf00T09BDf0`3LfnL02@3EeN<0JgF?0;Bfa`2d]/L0
YSU40>McK`3WMG80jWIc0>YhMP020?ooo`0304HN6P3YOWP0jGih00<0jGih
00P0AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80ig=_0:HiA0@0];K70@36b=L1
06IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L01P000000S8b<0>o_k`3_knl0
ilik0>o_k`80moOg00P0ii@00?OWcP3gmoL0moOg0>oWeP3gmoL0oooo0000
01`0];K700<0JgF?0=GDh`3PgnX0403PgnX01P3Ee><0JgF?0;Bfa`2d]/L0
JgF?0=GDha40h=oZ00T0eMCS06]eS`2d]/L0];K70:HiA03ZNG<0jGah0>n1
NP3bRH400P167QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<0>fGRP3[V8/00P16
7QX01@3bRH40kh5j0>UlN03ZNG<0YSU400@0];K70@36b=L106IVOP0000<0
IVIn0<K8e`2a/lP00`2a/lP01P000000kno_0>o_k`3_knl0moO_0>o_k`80
moOg00<0mnO60?Ogm`3oool00`3gmoL00`3oool000000;6cb00K0;6cb003
06]eS`3]jo<0jNSa0100jNSa00H0kN_c06]eS`2a/lP0/K?806]eS`3]jo<A
0>WXl@0I0>g[l`1[MHl0/K?80;6cb02V>D@0lH1e0?24O03eS8@0mif>0?:[
UP3a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03bZiH0mif>
0?F<Q03`Q7`0lH1e0:HiA0040;6cb040a/SG0@1VIWh0000306IVOP36b=L0
^;O?00<0[jk700D000000:f][@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3o
ool00`000000[jk70:n^a`0J0:n^a`0306]eS`3BdN<0l_7g0100l_7g00H0
d]7S06]eS`2_[/L0[jk706]eS`3BdN<A0?;am`060=;Ah`1[MHl0[jk70:n^
a`2V>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0m8Ym0:HiA02_[/L00P2_[/L1
0;Rgc`40a/SG0@1VIWh0000306IVOP30`M40alOD02l0[:_400@0Q8bR06]e
S`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a00408B<XP1[
MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01`2AV:X0
YSU40?nOS@3n_j@0n]bg0?[[]`3jjKH00P3ijKH0103jjKH0nNVf0?WY]P3j
jKH20?WY]P060?[[]`3jg;L0o[nT0?nOS@2V>D@0TIRZ0`2/Zl@10<O7e040
`<7A0@1VIWh0000406IVOP30`M40d];O0;FdbBl0Y:>n00<0Q8bR06]eS`1[
MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP1[MHl0JgF?00l0
JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80YSU40:HiA00?0:HiA007
08B<XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31d@0106IVOP0000H0IVIn0:RW
_`3Vi^d0d];P0;blc`2a/<A_0:RW_`050;6`a02l_<l0d];P0>KVk@2XYkl0
0@1VIWh0000705QGJ027Qi/0emSR0?clo03ThnP0d=3P0<[:fP1]0;blc`06
0<[:fP3@d>00i>?X0?clo03Gf>80QhNK0@1HEfP0000805QGJ01VIWh0UIB[
0=OHhP3lo?`0l_7c0>c[kP3Qh^][0=OHhP070>7Rj`3/jnh0l_7c0?clo03G
f>80UIB[06IVOP0105QGJ0000P1HEfP00`1VIWh0UIB[0=7AgP020?clo6d0
oooo0P3lo?`00`3AdMh0UIB[06IVOP0205QGJ0000`1HEfP206IVOP0308R7
W@2EU:/0Z:No06`0Z:No00@0UIB[08R7W@1VIWh0IVIn0`1HEfP000D0F5MX
L@1VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[7]:=",
  Evaluatable->False,
  ImageSize->{123, 53},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"ComboBox"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]=",
  CellTags->"ComboBox"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"TextArea\"]", "ObjectName",
  CellTags->"TextArea"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"text\" \[Rule] \"text content\"\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"rows\" \[Rule] ", "Program"],
  StyleBox["integer\n", "Program",
    FontSlant->"Italic"],
  "\[FilledSmallSquare] ",
  StyleBox["\"columns\" \[Rule] ", "Program"],
  StyleBox["integer\n", "Program",
    FontSlant->"Italic"],
  "\[FilledSmallSquare] ",
  StyleBox["\"lineWrap\" \[Rule] ", "Program"],
  StyleBox["False", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"TextArea"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"TextArea"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<TextArea\>", \ {\
\[IndentingNewLine]"\<text\>" -> "\<Multiple lines of running text\>", \ \
\[IndentingNewLine]"\<rows\>" \[Rule] 
                4, \[IndentingNewLine]"\<lineWrap\>" \[Rule] 
                True}]\ \[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"TextArea"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"TextArea"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001n0000IR000`400?l0
0000o`00003oOP1VIWh0000306IVOP3ko?d0nocm07X0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07T0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
N01VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS<0oooo
0`0000100?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWhf0?ooo`030000003oool0oooo03d0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPP0oooo1@0000030?ooo`800000
00<0oooo0000000000000`0000000`3oool0000000000004000000050?oo
o`00000000000000003oool01@0000001@3oool00000000000000000oooo
00<000000P3oool4000000/0oooo0`0000030?ooo`@0000000<0oooo0000
000000000P3oool2000000@0oooo0`00000L0?ooo`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh90?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool00P0000020?ooo`050000003oool0oooo
0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo0000000:0?ooo`070000003oool0oooo0?oo
o`000000oooo000000060?ooo`040000003oool0oooo000000@0oooo00D0
00000?ooo`3oool0oooo0000000K0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh90?ooo`030000003oool0oooo00<0oooo
00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?oo
o`0000000P3oool01@000000oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo00D0
00000?ooo`3oool0oooo0000000:0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool01@3oool2000000D0oooo00<000000?ooo`3oool0
7@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
2@3oool00`000000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`00
00000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`000000
2P3oool00`000000oooo0?ooo`030?ooo`D000000`3oool2000000D0oooo
00<000000?ooo`3oool07@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn2@3oool2000000@0oooo00D000000?ooo`3oool0
oooo000000020?ooo`8000000P3oool00`000000oooo0?ooo`0200000080
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooo`80
00000P3oool010000000oooo0?ooo`0000020?ooo`8000002P3oool00`00
0000oooo0?ooo`030?ooo`050000003oool0oooo0?ooo`0000000P3oool0
10000000oooo0?ooo`0000040?ooo`030000003oool0oooo01d0oooo00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPP0oooo0P00
0000103oool000000000003oool200000080oooo0P000000103oool00000
0000003oool200000080oooo0P0000000`3oool00000000000030?ooo`<0
00000`3oool2000000030?ooo`000000000000@0oooo0P0000000`3oool0
0000000000080?ooo`D000000`3oool300000080oooo0P0000020?ooo`80
00000P3oool5000001`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOT40oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`0M0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWhV0?ooo`030000003oool0oooo04d0oooo00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0oooo00<0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP000000M@3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0000001e0?ooo`03
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh000000280
oooo0`00001@0?ooo`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh0000002<0oooo00<000000?ooo`3oool0C`3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`000000103oool0
00000000000000020?ooo`80000000@0oooo000000000000oooo1@000004
0?ooo`<000000P3oool500000080oooo100000030?ooo`D000000`3oool4
000000T0oooo1@0000020?ooo`D0000000D0oooo00000000000000000?oo
o`0300000080oooo100000020?ooo`@000002`3oool3000000<0oooo1@00
00000`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P00
00030?ooo`040000003oool0oooo00000080oooo0P0000040?ooo`030000
003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000040?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo00@0oooo00D00000
0?ooo`3oool0oooo000000090?ooo`050000003oool0oooo0?ooo`000000
0`3oool01`000000oooo0?ooo`3oool0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOP8000000`3oool010000000oooo0?ooo`000003
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo0080oooo00D00000
0?ooo`3oool0oooo000000040?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool01@000000oooo
0?ooo`3oool0000000<0oooo00L000000?ooo`3oool0oooo06IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh2000000040?ooo`000000
oooo00000080oooo00D000000?ooo`3oool0oooo000000040?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool00`000000oooo
0?ooo`020?ooo`050000003oool0oooo0?ooo`000000103oool00`000000
oooo0?ooo`020?ooo`D000002`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo0080oooo00D000000?ooo`3oool0oooo000000020?oo
o`D000000`3oool3000000X0oooo00D000000?ooo`3oool0oooo00000003
0?ooo`070000003oool0oooo0?ooo`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn0P000000103oool000000?ooo`0000020?ooo`05
0000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool20000
0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
o`050000003oool0oooo0?ooo`0000002`3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo0080oooo0P0000020?ooo`040000003oool0
oooo000000<0oooo00@000000?ooo`3oool000000`3oool00`000000oooo
0?ooo`070?ooo`050000003oool0oooo0?ooo`0000000`3oool01`000000
oooo0?ooo`3oool0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP<0000000@0oooo000000000000oooo0P0000020?ooo`800000103o
ool00`000000oooo0?ooo`020?ooo`D000000P3oool3000000<0oooo0P00
00000`3oool00000000000050?ooo`030000003oool0oooo00<0oooo0`00
000<0?ooo`030000003oool0oooo0080oooo0`0000030?ooo`80000000<0
oooo000000000000103oool3000000@0oooo1000000:0?ooo`<000000`3o
ool50000000306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWh3000000030?ooo`000000000000/0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool0;@3oool01`000000oooo0?ooo`3oool0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0000000@0oooo00000000
000000002@3oool2000000d0oooo00<000000?ooo`3oool02P3oool20000
01<0oooo0P0000060?ooo`030000003oool0oooo02L0oooo0`0000000`1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0000001e0?oo
o`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh00000
07D0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP000000M@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn0000001e0?ooo`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0000007D0oooo00<0IVIn0:RY^`3ko?d00@1VIWh00003
06IVOP3gmoT0V9RW07P0MgNB0@2HV:L10?Ogn@40IVIn00000`1VIWh0moOi
0;bmc@1i0;bmc@40moOi0@1VIWh0000306IVOP3gmoT0i>?S07T0i>?S0@3g
moT106IVOP0000<0IVIn0?3am03oool0<P3oool00`3Thn<0W:Bi06]eS`03
06]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo
0>CSh`2LY;T406]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CS
h`3oool0oooo0>cZjP2LY;T40:HiA0040:LjA02V>D@0YcY40:LjA0T0YSU4
00<0W:Bi0>cZjP3oool00`3oool10?3am040IVIn00005P1VIWh0h^7R0?_l
o03kno`0nocm0?cko@3knod0nocm0?_lo03lo?d0o?cl0?cko@3lo?`0o?_l
0?clo03ko?`0o?cl0?_lo@3lno`0o?cm0?_ko@3ko?`20?clo0040?clo@3l
o?`0no_m0?cloAD0o?_l103ko?`00`2LY;T0JgF?08F9/00@08F9/00606]e
S`2LY;T0nocm0?_lo@2LY;T0JgF?4@25RK001P1[MHl0W:Bi0?_lo03kno`0
W:Bi0:HiA140ZSaE00L0YSU409bT^@3ko?`0o?cl0?cko@3ko?d0h^7R0040
IVIn0000101VIWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kgn03gmoT0moOh0?Kg
n03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3gmoT0103gm_P0m_Oh
0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0moOi01@0moOi103fmoT00`1[MHl0
QHV`09bN_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h0
2025RK00JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0
`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@0106IVOP0000H0IVIn
0=kMh@3alO@0lO7d0?3am03`l_@@000000060?7am03`l_D0lO7d0?7bm03`
l_@0lO7d6@3`lOD00`1[MHl0/[G@0:NX`P0@0:NX`P060;:ed01[MHl0l?7d
0?3am01[MHl0/[G@4@2WZ<801@2b]M00JgF?0?3am@3al_@0YSU40080`U9K
00<0beAI0<eIGP3=FEh02`3=FEh0103;E5T0`U9K0<9BF`2V>D@20?3am003
0?7am03`l_@0g]gQ0040IVIn00001`1VIWh0g=_P0>[[l03Zjo00j^c`0>W[
k`0000000P3WinL20=kNgP80inOW00<0ikf40>OWi`3WinL00`3WinL20>o_
k`040000003Zjo00j^_`0>[[k`80j^_`00<0j^__0>[[l03Zjo004`3Zjo04
0>[/l00406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk60:b^aP2][/H00`2]
[/H00`2/[/H0][WA06]eS`020>[[k`0406]eS`2f^M40[Jk60:f^aP`0oooo
0P2][/H00`2/[/H0][WA06]eS`020>[[l0050:HiA03=FEh0beAI0<eFF`3>
FEl02`3@FUl01`3>FEl0cEIK0<]DF@3=FEh0YSU40>[[k`3Zjo000P3Zjnl1
0=cKh040IVIn0000101VIWh0fMWO0>?UjP3Si>X20>?Uj`050000002<S8`0
g]kN0>OWi`3Ng]h00P3WinL00`36H`00inOW0>OWi`020>OWi`070>o_i`3_
knl0kno_0000003Si>X0hnC[0>?UjP020>?TjP030>?Tj`3SiN/0hnG[01<0
hnG[103Si>X01@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:b
bP2b//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0
oooo02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@0
0P3=FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0e5aO0=1KH03=
FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3G
f=h0g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OFcP020>OWi`050<ik
003_U100inOW0>ONaP3_S1000`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV
0=cNi@3Lg^H06@3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<0
9BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80
^;W>00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;RicP020;RicP09
0;o1eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3F
Gf<30?ooo`0505<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU
0=OHgP0106IVOP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<
0>OWi`3WinL0ikF40=IJ003FQ000olh00<iS00020=i[00050>neS03_knl0
kno_0>o_k`0000000P3Ef>40103Een00e]SP0=KHh@3Fen4E0=KGh0@0e]SP
00D0JgF?0<?5f@2l_M40_;gA0?ooo`0702DU=PL0_;gA00H0`lGI06]eS`3E
f>40eMSQ06]eS`33aMT20;bmd@030?ooo`0U9CH0_;gA00L0_;gA00<0oooo
02DU=P2l_M400P2l_M401@33aMT0JgF?0=KGh03Een40YSU40080eEeP00<0
f61Q0=UQHP167QX00`3oool30=UQHP<0oooo00<0AQhJ0=UQHP3HH6400P3E
GF001P2V>D@0e]SP0=GHh@3Een00eMSQ0=GFg@40IVIn00001`1VIWh0d]CM
0<oBg03@d]`0d=;M0=3Bg00000000`3WinL0303Wg/h0aTX00?O>003_[@00
kkD00<i[0036FP00aV/00=j<BP3WY@00knO>000000<0d=;L00<0cm;L0=3B
g03?d]`05@3@d]`40<oBg@0306]eS`38bM/0`lCF0100`lCF00H0b<WK06]e
S`3@d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U9CH0`lCF00L0`lCF00<0
oooo02DU=P33a=H00P33a=H01`38bM/0JgF?0<oBg03?d]`0YSU40=MOG`3I
HF800`3LIFD01@167QX0oooo0?ooo`3oool0g6EU00<0oooo00P0AQhJ0=aU
I@3LIFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?d]`10=;Dg@40IVIn
0000701VIWh0d=;K0<_=f03:cMT0blkH0<[=f0000000ilJ]0>O6S03gcQP0
kkd00?O6003_[@00ijd00>NU003FS000cV/00>O6003oeP00knoW0>o_k`00
0000blgH0<_=f@3:cMT0blkH0<[=f03;cMPE0<_=f@@0blkI00<0JgF?0<_<
gP38b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38b]T0blcN
06]eS`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9
f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;c]P0b/gH
0:HiA03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?ooo`030?oo
o`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80
blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P000000a/K6
0>ONeP3>N`00ijd00>ne0080ijD000<0eY@00<ic003FU0000P3gaP020?Og
m`0400000035b=@0aLOD0<G7e0<0aLOE5@34amD40<C8e00306]eS`3@dN00
bl_L0100bl_L00H0d=7P06]eS`34am@0a<OD06]eS`3@dN020<_;g0030?oo
o`0U9CH0bl_L00L0bl_L00<0oooo02DU=P3;bm`00P3;bm`01`3@dN00JgF?
0<G7e034am@0YSU40=]TI03OIF@01@3PJVP01@167QX0oooo0?ooo`3oool0
AQhJ00D0h6YX00@0gfET0=]TI02V>D@0a<SE0P34b=@10<G7e@40cloJ0@1V
IWh0000406IVOP3<c]X0`/CB0<74d@80`LCB00H000000>OWi`3WinL0inOW
0=J4003_]@020>NU00080=J4003>J`00ijd00?Ne003g_@00kno_0?Ogm`00
00030<74dP030<;4d@31a=80`LCB01D0`LCA1031a=800`1[MHl0dm?R0<o@
g@0@0<o@g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?d=d00`3oool0
9BDf0<o@g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M00L0dm?R06]eS`32
a=80`LCA0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/J@080>5YI@3KI6@0
YSU40<74dP32a=40`LCA0<74dP3<c]X106IVOP0000@0IVIn0<[<f02n`<l0
_L3?0P2n`<h01@000000W9bL0>OWi`3Wg]H0eX`00080gY@000@0eW/00<IS
002m@P00kjD00P3g[@00203g]@00oli:0000002n`<h0_/3?0;k0cP2n`<l0
_L3>5P2n`<h40;g0cP0306]eS`3Fe^@0dm?P0100dm?P00H0e]KT06]eS`2n
`<h0_/3>06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo00P0oooo00/09BDf
0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/
K0<0oooo00@0AQhJ0?ooo`3oool0oooo103SK6`0103QJVX0h6IU0:HiA02m
`<l20;k0c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:f02f^<P0^Kc;0;Zl
b`2j_<`000000080kno_01<0eY`00=J<003NU000eX@00>nU003NS000_EX0
0=Ic003_W000mnoW0?Ogm`3oool000000;Vlc02j^l`0^Kc;0;Zlb`2i_<`0
^Kc;01D0^Kc<102j_<`00`1[MHl0f=SU0=?Ch@0@0=?Ch@060=SHi@1[MHl0
^[c;0;Zlb`1[MHl0f=SU0P3Cdn400`3oool0KVf?06i]S`0806i]S`0>02DU
=P3Cdn40dm?Q0=?Ch@3Hf>D0JgF?0;Zlb`2j_<`0YSU40>1YJ03QKF`0i75]
0>AaK`3TL6h30?ooo`0304HN6P3TL6h0AQhJ00<0oooo0P3TL6h02@3TLFd0
hFe/0>1YJ02V>D@0^[c<0;Zkc02i_</0][S80<W:f00106IVOP0000T0IVIn
0<O9e`2d]/L0][S80;Jhb@2f^LT0000008B4Q03Wimh00P3_knl01`36J`00
mlH00>ne003_W000gX`00<i[003WW0000`3gmoL01@000000][W90;Nhb@2f
^LT0]kW90080][S95@2g^<T40;Jhb@0406]eS`3Fe^@0f=SU0=SHiP<0f=SU
1@3Hf>H30=SHi@80f=SV0P3Hf>D02@3Fe^@0JgF?0;Nhb@2g^<T0JgF?0=KF
i03Hf>D0f=SV0?ooo`0:06i]S`0=02DU=P3Hf>H0f=SU0=SHi@3Fe^@0JgF?
0;Nhb@2g^LT0YSU40>A^K@3TM6l0ig5_0>AdK`030?ooo`0504HN6P3TM6l0
i7A_0>AdK`167QX00`3oool02P3TM6l0ig5_0>AdK`3TKVd0YSU40;Jib@2f
^<T0][W90;Bfa`37bML106IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L00`00
0000kno_0>o_k`020>o_k`0;0>N]003gaPP0ijD00>ND003WS000knOF0=jD
>@3_e[D0ooOg0?ooo`0000007`2d]/L01@1[MHl0eMGS0=cKi`3LfnL0gM_W
00h0g=_W00H0eMGS06]eS`2d]/L0];K706]eS`3EeN<20=cKi`030=gKi`0U
9CH09BDf00T09BDf0`3LfnL02@3EeN<0JgF?0;Bfa`2d]/L0YSU40>McK`3W
MG80jWIc0>YhMP020?ooo`0304HN6P3YOWP0jGih00<0jGih00P0AQhJ0?oo
o`3oool0jWQf0>YfL`3WMG80ig=_0:HiA0@0];K70@36b=L106IVOP0000<0
IVIn0<K8e`2d]/L00`2d]/L01P000000S8b<0>o_k`3_knl0ilik0>o_k`80
moOg00P0ii@00?OWcP3gmoL0moOg0>oWeP3gmoL0oooo000001l0];K700<0
JgF?0=GDh`3PgnX0403PgnX01P3Ee><0JgF?0;Bfa`2d]/L0JgF?0=GDha40
h=oZ00T0eMCS06]eS`2d]/L0];K70:HiA03ZNG<0jGah0>n1NP3bRH400P16
7QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<0>fGRP3[V8/00P167QX01@3bRH40
kh5j0>UlN03ZNG<0YSU400@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2a
/lP00`2a/lP01P000000kno_0>o_k`3_knl0moO_0>o_k`80moOg00<0mnO6
0?Ogm`3oool00`3gmoL00`3oool000000;6cb00N0;6cb00306]eS`3]jo<0
jNSa0100jNSa00H0kN_c06]eS`2a/lP0/K?806]eS`3]jo<A0>WXl@0I0>g[
l`1[MHl0/K?80;6cb02V>D@0lH1e0?24O03eS8@0mif>0?:[UP3a/Y/0kKBK
0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03bZiH0mif>0?F<Q03`Q7`0
lH1e0:HiA0040;6cb040a/SG0@1VIWh0000306IVOP36b=L0^;O?00<0[jk7
00D000000:f][@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3oool00`000000
[jk70:n^a`0M0:n^a`0306]eS`3BdN<0l_7g0100l_7g00H0d]7S06]eS`2_
[/L0[jk706]eS`3BdN<A0?;am`060=;Ah`1[MHl0[jk70:n^a`2V>D@0m8Ym
0P3eT8D=0?:hWP80mI2500<0m8Ym0:HiA02_[/L00P2_[/L10;Rgc`40a/SG
0@1VIWh0000306IVOP30`M40alOD0380[:_400@0Q8bR06]eS`3<bmd0no_l
3@3oool0103kno`0c<_M06]eS`24S:820:b[a00408B<XP1[MHl0c<_M0?_k
o0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01`2AV:X0YSU40?nOS@3n
_j@0n]bg0?[[]`3jjKH00P3ijKH0103jjKH0nNVf0?WY]P3jjKH20?WY]P06
0?[[]`3jg;L0o[nT0?nOS@2V>D@0TIRZ0`2/Zl@10<O7e040`<7A0@1VIWh0
000406IVOP30`M40d];O0;FdbC80Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl0
0`24S:80Y:>n0:BS_P020:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR
0:BS_P2TXkh00P2TXkh00`24S:80YSU40:HiA00?0:HiA00708B<XP2TXkh0
Y:>n0:BS_P2e]<T0d];O0<31d@0106IVOP0000H0IVIn0:RW_`3Vi^d0d];P
0;blc`2a/<Ab0:RW_`050;6`a02l_<l0d];P0>KVk@2XYkl00@1VIWh00007
05QGJ027Qi/0emSR0?clo03ThnP0d=3P0<[:fP1`0;blc`060<[:fP3@d>00
i>?X0?clo03Gf>80QhNK0@1HEfP0000805QGJ01VIWh0UIB[0=OHhP3lo?`0
l_7c0>c[kP3Qh^]^0=OHhP070>7Rj`3/jnh0l_7c0?clo03Gf>80UIB[06IV
OP0105QGJ0000P1HEfP00`1VIWh0UIB[0=7AgP020?clo700oooo0P3lo?`0
0`3AdMh0UIB[06IVOP0205QGJ0000`1HEfP206IVOP0308R7W@2EU:/0Z:No
06l0Z:No00@0UIB[08R7W@1VIWh0IVIn0`1HEfP000D0F5MXM01VIWh505QG
J000\
\>"], "Graphics",
  CellLabel->"From In[9]:=",
  Evaluatable->False,
  ImageSize->{126, 102},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"TextArea"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]=",
  CellTags->"TextArea"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"TextPanel\"]", "ObjectName",
  CellTags->"TextPanel"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"text\" \[Rule] \"text content\"\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"path\" \[Rule] \"relative filesystem path\" | \"URL path\"\n", 
    "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"contentType\" \[Rule] \"text/plain\" | \"text/html\" |  \
\"text/rtf\" | \"text/html;charEncoding\"\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"editable\" \[Rule] True | False", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"TextPanel"],

Cell[TextData[{
  StyleBox["Events\n", "SubsubsectionFirst"],
  "\[FilledSmallSquare] ",
  StyleBox["\"hyperlinkUpdate\" - ", "Program"],
  StyleBox["triggered whenever a hyperlink in the text is activated (", 
    "Text"],
  StyleBox["only fired when panel is not editable", "Text",
    FontSlant->"Italic"],
  StyleBox[")", "Text"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"TextPanel"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"TextPanel"],

Cell[TextData[{
  "There are three default text widgets provided within ",
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  ": ",
  StyleBox["Widget[\"TextField\"]", "Output"],
  ",  ",
  StyleBox["Widget[\"TextArea\"]", "Output"],
  ", and ",
  StyleBox["Widget[\"TextPanel\"]", "Output"],
  ".  ",
  StyleBox["Widget[\"TextField\"]", "Output"],
  " is typically used for single line input using a single font, while ",
  StyleBox["Widget[\"TextArea\"] ", "Output"],
  "would typically be used to display or take multiple line input also in a \
single font style. ",
  StyleBox["Widget[\"TextPanel\"]", "Output"],
  " is used less often, but has the benefit of displaying stylized text \
either as plain text, HTML 3.2 compliant text, or RTF styled text. This \
widget would typically be useful to simplify laying out slightly more \
complicated text blocks using a single text string but including style \
information. You can also take advantage of the ",
  StyleBox["\"path\"", "Program"],
  " property by specifying an external source for the text content, either as \
a relative local file or even URL-based paths. You can also support eventing \
off hyperlinks in any HTML you provide in the text, allowing for custom \
hyperlink actions or forwarding standard web URLs to a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " front end to open in the user\[CloseCurlyQuote]s chosen web browser."
}], "Text",
  CellTags->"TextPanel"],

Cell[TextData[{
  "In its most basic form, ",
  StyleBox["Widget[\"TextPanel\"]", "Program"],
  " can display plain text just as ",
  StyleBox["Widget[\"TextArea\"]", "Program"],
  "."
}], "Text",
  CellTags->"TextPanel"],

Cell[BoxData[
    \(\(Needs["\<GUIKit`\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"TextPanel"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<TextPanel\>", \ {\
\[IndentingNewLine]"\<preferredSize\>" \[Rule] 
                Widget["\<Dimension\>", {"\<width\>" \[Rule] 
                      50, "\<height\>" \[Rule] 
                      80}], \[IndentingNewLine]"\<text\>" -> "\<Multiple \
lines of running text\>"}]\ \[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"TextPanel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"TextPanel"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000LR000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOR40oooo
1000001>0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWhU0?ooo`030000003oool0oooo04/0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0oooo00<000000?ooo`3oool0
0P3oool2000000040?ooo`000000oooo000000<0oooo00<000000?ooo`00
00000`3oool01@000000oooo0000003oool0000000<0oooo00<000000?oo
o`3oool00P0000000`3oool000000?ooo`030?ooo`8000000P3oool30000
0080oooo00H000000?ooo`3oool0oooo0000003oool2000003P0oooo00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0oooo00D0
00000?ooo`3oool0oooo000000020?ooo`80000000<0oooo0000003oool0
0P3oool00`000000oooo000000030?ooo`050000003oool000000?ooo`00
00000`3oool00`000000oooo000000020?ooo`800000103oool010000000
oooo0?ooo`0000030?ooo`060000003oool0oooo0000003oool000000P3o
ool00`000000oooo0?ooo`0g0?ooo`0306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWh30?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo000000030?ooo`030000003oool0000000<0oooo
00D000000?ooo`000000oooo000000030?ooo`030000003oool0000000<0
oooo00<000000?ooo`3oool00P3oool010000000oooo0?ooo`0000070?oo
o`050000003oool0oooo0?ooo`000000>@3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo
000000030?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
1@0000030?ooo`050000003oool0oooo0?ooo`000000>@3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3oool200000080
oooo00H000000?ooo`3oool0oooo0000003oool200000080oooo00@00000
0?ooo`00000000000P3oool010000000oooo0000003oool200000080oooo
00<000000?ooo`0000000P3oool2000000@0oooo00@000000?ooo`3oool0
00000`3oool01P000000oooo0?ooo`000000oooo00000080oooo00<00000
0?ooo`3oool0=`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn0`3oool01@000000oooo0000003oool0000000<0oooo00@0
00000?ooo`000000oooo0P0000020?ooo`040000003oool0000000000080
oooo00@000000?ooo`000000oooo0P0000030?ooo`80000000<0oooo0000
003oool00P3oool300000080oooo0`0000020?ooo`040000003oool0oooo
0?ooo`@00000>03oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn:P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo03L0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOQT0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo03L0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOP<0oooo00<000000?ooo`3oool0K@3oool0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo05P0oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0oooo00<00000
0?ooo`3oool04P3oool00`000000oooo0?ooo`1H0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh30?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`3oool00P0000001@3oool000000?oo
o`000000oooo0080000000D0oooo0000003oool000000?ooo`0200000080
oooo00<000000?ooo`3oool00`0000050?ooo`050000003oool000000?oo
o`0000000`3oool00`000000oooo0?ooo`03000000<0oooo0`0000060?oo
o`<000000`3oool00`000000oooo0?ooo`0W0?ooo`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh30?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`0000000P3oool2000000040?ooo`000000
oooo00000080oooo00@000000?ooo`00000000000P3oool01@000000oooo
0000003oool0000000<0oooo00<000000?ooo`3oool00P3oool01@000000
oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool00`00
0000oooo000000030?ooo`030000003oool0oooo0080oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo02L0oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0oooo00T00000
0?ooo`000000oooo0000003oool000000?ooo`0000000`3oool01@000000
oooo0000003oool000000080oooo00<000000?ooo`0000000`3oool01@00
0000oooo0000003oool0000000P0oooo00D000000?ooo`000000oooo0000
00030?ooo`030000003oool0000000P0oooo00<000000?ooo`3oool00`3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
9`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
0`3oool02@000000oooo0000003oool000000?ooo`000000oooo00000003
0?ooo`050000003oool000000?ooo`0000000P3oool00`000000oooo0000
00030?ooo`040000003oool000000?ooo`D00000103oool01@000000oooo
0000003oool0000000<0oooo00<000000?ooo`000000100000020?ooo`80
00001P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?oo
o`3oool09`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn0`3oool02@000000oooo0000003oool000000?ooo`000000oooo
000000030?ooo`050000003oool000000?ooo`0000000P3oool010000000
oooo0000000000020?ooo`050000003oool000000?ooo`0000000`3oool0
0`000000oooo0?ooo`020?ooo`040000003oool000000?ooo`8000000P3o
ool00`000000oooo000000030?ooo`030000003oool0000000<0oooo00<0
00000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool09`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn0`3oool2000000<0oooo0P0000000`3oool00000
0?ooo`020?ooo`030000003oool0000000<0000000D0oooo0000003oool0
00000?ooo`0200000080oooo00<000000?ooo`3oool00`0000050?ooo`06
0000003oool000000?ooo`000000oooo0P0000030?ooo`<000000`3oool3
000000H0oooo0`0000020?ooo`<00000:03oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3oool2000000<0oooo0P000007
0?ooo`030000003oool0000000X0oooo00<000000?ooo`3oool0203oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02L0oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
00000080oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0000001h0oooo00<000000?ooo`3oool09P3oool0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3oool0
0`000000oooo0?ooo`1]0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWh30?ooo`030000003oool0oooo06d0oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0oooo00<00000
0?ooo`3oool0K@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn0`3oool00`000000oooo0?ooo`1]0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0
nocm0040IVIn00000`1VIWh0moOi09RHY`1e07MgTP40V9RW0@3gmoT106IV
OP0000<0IVIn0?Ogn@2l_Ld0MP2l_Ld10?Ogn@40IVIn00000`1VIWh0moOi
0>CSh`1f0>CSh`40moOi0@1VIWh0000306IVOP3`lO@0oooo02l0oooo00<0
i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT
^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0101/MY00JgF?06afT01/MY09
06]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W>T@0YSU4
0:LjA02W>T@90:HiA00309bT^@3/j^X0oooo00<0oooo0@3`lO@106IVOP00
01H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0o?cm0?cl
o03lnod0o?cl0?cko03lo?`0nocl0?clo03ko?d0o?_l0?clo@3knod0nocl
0P3lo?`0103lo?d0o?cl0?_ko@3lo?dD0?cko080nocl00<0W:Bi06]eS`25
RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?
09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?clo03l
nod0nocm0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3f
moP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080
moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0C0?Og
n@80m_Oi00<0JgF?08F9/02LW[h0402LW[h01P25RK00JgF?0?Ogn@3gmoT0
JgF?08F9/140W9jn00P0QHV`06]eS`3fmoP0moOh0:HiA02Z?5D0`U9K0<ID
FPd0aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>40
0@1VIWh0000606IVOP3NgN40lO7d0?7am03`lO@0l?;d400000001P3alO@0
l?;e0?7am03al_@0l?;d0?7am1H0l?7e00<0JgF?0;:ed02WZ<80402WZ<80
1P2b]M00JgF?0?3am03`lO@0JgF?0;:ed140YjS200D0/[G@06]eS`3`lOD0
lO;d0:HiA0020<9BF`030<]DF@3=FEh0cEUN00/0cEUN00@0beAI0<9BF`32
DU/0YSU40P3`lO@00`3alO@0l?;d0=kMh@0106IVOP0000L0IVIn0=cKh03Z
jo00j^_`0>[/l03Yjnl000000080inOW0P3Ng]h20>OWi`030>NmQ03WinL0
inOW00<0inOW0P3_knl010000000j^_`0>[[l03Zjnl20>[[l0030>[[k`3Z
jo00j^_`0180j^_`0P3Zk?00101[MHl0][WA0:f^aP2][/H80?ooo`030:f^
aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0101[MHl0][WA
0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Zjo001@2V>D@0
cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0cEUN0:HiA03Z
jnl0j^_`0080j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3SiNX0hnCZ0P3S
iN/01@000000S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<00>OWi`3WinL0
0P3WinL01`3_knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX00P3Si>X00`3S
i>/0hnG[0>?Uj`0B0>?Uj`80hnCZ00D0JgF?0;bne02b//X0/[;:0?ooo`06
06i]S`0302DU=P2b//X0/[;:00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ06]e
S`2l_]@20;:bbP030?ooo`0U9CH09BDf00T09BDf0`2b//X01@2l_]@0JgF?
0>?Tj`3Si>/0YSU40080cEUN00@0d5]P0=ALG`3oool0oooo1`3DG5l20?oo
o`0:0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnCZ0>?UjP3Si>X0hnG[0=WIg`40
IVIn00000`1VIWh0emSN0=cNiP030=cNiP050000003WinL0inOW0>OWi`3W
e/h00P3WinL01@3>N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_00L000000=cN
iP3Lg^D0g=kU0=cNiP3Lg^D0g=kV01H0g=kU00D0JgF?0;o1eP2h^Lh0^;W>
0?ooo`0606i]S`0302DU=P2h^Lh0^;W>00D0^;W>00H0_l7F06]eS`3Lg^D0
g=kU06]eS`2o`MH20;RicP030?ooo`0U9CH0^;W>00L0^;W>00<0oooo02DU
=P2h^Lh00P2h^Lh02@2o`MH0JgF?0=cNiP3Lg^D0YSU40<eIGP3AFUh0e5eQ
05<U80030?ooo`D0eUmS0`3oool01@1C9B00e5eQ0=5JGP3=FEh0YSU40080
g=kU00<0g=kV0=cNi@3Gf=h00@1VIWh0000406IVOP3Ee]d0eMSP0=KHh@80
eMSP00T0000008b<S03WinL0inOW0>NeQ03FFP00eX@00?o>003>H`000P3N
J`001@3_]H`0kno_0>o_k`3_knl000000080eMSQ00@0eMOP0=KHh03Ff>40
e]OQ503Fen020=KHh00506]eS`33aMT0_;gA0;bmd@3oool01`0U9CH70;bm
d@060<?5f@1[MHl0eMSQ0=GHh@1[MHl0`lGI0P2l_M400`3oool09BDf0;bm
d@070;bmd@030?ooo`0U9CH0_;gA0080_;gA00D0`lGI06]eS`3Fen00eMOQ
0:HiA0020=EMH0030=QPH@3IHF80AQhJ00<0oooo0`3IHF830?ooo`0304HN
6P3IHF80f61Q0080eEeP00H0YSU40=KHh03Ef>40eMOP0=GHh@3Ee]d106IV
OP0000L0IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@d]`0000000<0inOW00`0imk>
0<I:003gcP00kjd00>ne003>J`00aUX00<I[003NS4X0ijD00>oWcP000003
0=3Bg0030<oBg03@d]`0cm;L01@0d=;L0P3?d]d00`1[MHl0b<WK0<?4eP0@
0<?4eP060<S9f`1[MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf
0<?4eP070<?4eP030?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0
cm;L0:HiA03GGel0fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@03
0?ooo`0804HN6P3LIFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040
cm;L0@3Be=d106IVOP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP00000
0>O6[@3WaX`0mlhH0>nm003gaP00kjd00>N]003WY@00eX`00<i[003WaP00
omH00>o_i`3_knl000000<_=f03;cMT0b/gI0<_>f03:cMP0blgH503;cMT2
0<_>f@0306]eS`3;c=h0b<[I00P0b<[I00<0b<WI0<S:f@38b]T00`38b]T0
1038bMT0b<[I0<_<gP1[MHl20<_=f00606]eS`3;c=h0b<[I0<S:f@3oool0
9BDf1@38b]T04@38bMT0b<[I0<S:f@3oool09BDf0<S:f@38bMT0b<[I0<_<
gP1[MHl0blkH0<[=f02V>D@0eemO0=]TI03PIfD0h6IU0080gVMW00<0AQhJ
0?ooo`3oool00`3oool02P167QX0gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0
YSU40<[>f03:c]T20<_=f@40d=;K0@1VIWh0000306IVOP3?cmX0aLSD00<0
aLSD00H000000<K6aP3Wg]H0cW/00>N]003_]@020>NU00030=JD003>L`00
eY@00080mlH00P3gmoL010000000aLSD0<G7e035am@30<G7eA@0a<OE0P34
b=@00`1[MHl0d=7P0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0
d=7P0P3;bm`00`3oool09BDf0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080
bl_L00L0d=7P06]eS`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ
0?ooo`3oool0oooo04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD
0@35amD10<o?fP40IVIn0000101VIWh0c<kJ0<;4dP31a=420<74dP060000
003WinL0inOW0>OWi`3FQ000kkD00P3WY@00203FQ000cV/00>N]003g]@00
mkd00>o_k`3gmoL000000`31a=800`32a=40`LCB0<74dP0D0<74d@80`LCB
00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?0=?C
hP80cm3M00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@020<o@
g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3P
K6T0203QJFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh00004
06IVOP3:c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<0002
0=jD00040=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>BP000000_/3>
0;k0c`2n`<h0_/3?0;g0cQD0_/3>0P2m`<h00`1[MHl0e]KT0=?Ch00@0=?C
h0060=KFi01[MHl0_/3>0;k0cP1[MHl0e]KT0P3Cdn000`3oool09BDf0?oo
o`080?ooo`0;02DU=P3Cdn00dm?P0=?Ch03Fe^@0JgF?0;k0c`2n`<h0YSU4
0>1VI@3QJVX0103SK6`30?ooo`0404HN6P3oool0oooo0?ooo`@0hfa/00@0
hFYZ0>1VI@2V>D@0_L3?0P2n`<l10;k0cP40b/cH0@1VIWh0000706IVOP39
b]P0][S80;Vlb`2j_</0^[c<000000020>o_k`0C0=JL003FS000gY@00=J4
003_Y@00gX`00;eJ003FL`00ki`00?O_i`3gmoL0oooo0000002i_<`0^[_<
0;Vlb`2j_</0^Kc<0;Vlb`0D0;Vlc080^[c<00<0JgF?0=SHi@3Cdn40403C
dn401P3Hf>D0JgF?0;Zlb`2j_</0JgF?0=SHi@80dm?Q00<0oooo06i]S`1^
KHl0201^KHl03P0U9CH0dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<0:Hi
A03PJFP0hFe/0>AaK@3TLFl0i71^0`3oool00`167QX0i71^04HN6P030?oo
o`80i71^00T0i75]0>5]K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039b]P0
0@1VIWh0000906IVOP37bML0];K70;Jhb02f^<T0][W900000024Q8@0inON
0080kno_00L0aV/00?O6003_]@00ki`00=j<003>J`00ii`000<0moOg00D0
00000;Jib@2g^<T0][W90;Nib@020;JhbA@0]kS90P2f^<T0101[MHl0e]KT
0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0e]KT06]eS`2g
^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U9CH0f=SV0=SH
i@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>MaK`3TM6l00`3o
ool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0
i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG0@1VIWh0000306IVOP36b=L0
];K700<0];K700<000000>o_k`3_knl00P3_knl02`3W[@00mlH80>NU003W
U000ih`00>oWeP3NU3T0kmJe0?ogm`3oool0000001`0];K700D0JgF?0=GE
h`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS
0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS06]eS`2d]/L0
];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3oool00`167QX0jGih0>UnN003
0>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V>D@40;Bfa`40
a/SG0@1VIWh0000306IVOP36b=L0];K700<0];K700H0000008b<S03_knl0
kno_0>O>N`3_knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_imH0moOg0?oo
o`00000L0;Bfa`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0
];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V>D@0jWUc0>Ul
N03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;
0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40a/SG0@1VIWh0
000306IVOP36b=L0/K?800<0/K?800H000000>o_k`3_knl0kno_0?Ogk`3_
knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg00<0oooo0000002a/lP06`2a
/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?80;6cb01[MHl0
kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`Q7`0mHb40?NM
SP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lZ^F
0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn00000`1VIWh0
a/SG0;Rgc`030:n^a`050000002][Jd0moO_0?Ogm`3_knl01P3gmoL20?og
m`80oooo00<000000:n^a`2_[/L06P2_[/L00`1[MHl0d]7S0?;am`0@0?;a
m`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^
a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V>D@0[jk70080
[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0`<7A0<O7e00_0:b[a00408B<
XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024
S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400L0
TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0n^Vf0?WY]P3i
jKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03oWhd0YSU4096HZP<0[:_40@37
am@10<31d@40IVIn0000101VIWh0`<7A0=;Bg`2e]<T_0:BS_P0308B<XP1[
MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80JgF?06]e
S`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:HiA02V>D@03`2V
>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1VIWh0000606IV
OP2XYkl0i^K]0=;Bh02l_<l0/K34K`2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0
Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@h03:b]X0K@2l
_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000201HEfP0IVIn
09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[J`3Gf>801`3Qh^/0k>_^0?;al`3l
o?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX00<0IVIn09FDZ`3AdMh00P3l
o?a]0?ooo`80o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0F5MX0P1VIWh0
0`28Qid0UIB[0:RW_`1/0:RW_`0409FDZ`28Qid0IVIn06IVOP<0F5MX0005
05QGJ740IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  Evaluatable->False,
  ImageSize->{123, 114},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"TextPanel"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"TextPanel"]
}, Open  ]],

Cell[TextData[{
  StyleBox["Widget[\"TextPanel\"]", "Program"],
  " would typically be used to display HTML or RTF styled content."
}], "Text",
  CellTags->"TextPanel"],

Cell[TextData[{
  "Here we display stylized text using HTML along with correctly setting the \
",
  StyleBox["\"contentType\"", "Program"],
  " property."
}], "Text",
  CellTags->"TextPanel"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<TextPanel\>", \ {\
\[IndentingNewLine]"\<preferredSize\>" \[Rule] 
                Widget["\<Dimension\>", {"\<width\>" \[Rule] 
                      50, "\<height\>" \[Rule] 
                      80}], \[IndentingNewLine]"\<contentType\>"\  \[Rule] \ \
"\<text/html\>", \[IndentingNewLine]"\<text\>" -> "\<<html><body>Multiple \
<b>lines</b> of <i>running text</i></body></html>\>"}]\ \[IndentingNewLine]];\
\)\)], "Input",
  CellLabel->"In[4]:=",
  CellTags->"TextPanel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"TextPanel"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000LR000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0oooo
100000160?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWhX0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
@`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
:03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0oooo
00<000000?ooo`3oool00P3oool3000000050?ooo`00000000000?ooo`00
00000`3oool2000000030?ooo`000000oooo0080oooo0P0000000`3oool0
0000000000020?ooo`040000003oool0oooo0?ooo`8000000P3oool40000
00H0oooo0P0000030?ooo`<000000P3oool00`000000oooo0?ooo`020000
00030?ooo`000000000002h0oooo00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOP<0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0200000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00D000000?ooo`3oool0oooo000000090?ooo`05
0000003oool000000?ooo`0000000`3oool01P000000oooo0?ooo`000000
oooo00000080oooo00<000000?ooo`000000;@3oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn103oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo008000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000`3oool010000000oooo0?ooo`00000:
0?ooo`030000003oool0oooo00<000001@3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo02`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOP@0oooo00<000000?ooo`3oool00P3oool0
1@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo
000000020?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000
oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3oool0oooo0`000007
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`020?ooo`030000003oool0oooo02`0oooo00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0oooo0P00
00030?ooo`050000003oool0oooo0?ooo`0000000P3oool200000080oooo
00<000000?ooo`3oool00P0000020?ooo`040000003oool0oooo000000<0
oooo0P0000020?ooo`040000003oool0oooo000000<0oooo00<000000?oo
o`3oool0103oool010000000oooo0?ooo`0000030?ooo`050000003oool0
oooo0?ooo`000000103oool00`000000oooo0?ooo`0/0?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh40?ooo`040000003o
ool000000?ooo`8000000`3oool020000000oooo0?ooo`000000oooo0000
003oool000000P3oool01@000000oooo0000003oool0000000<0oooo00P0
00000?ooo`3oool000000?ooo`000000oooo00000080oooo00D000000?oo
o`3oool0oooo000000060?ooo`050000003oool0oooo0?ooo`0000000P3o
ool010000000oooo0?ooo`3oool2000000<0oooo00<000000?ooo`3oool0
;03oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
0`3oool2000000050?ooo`00000000000?ooo`0000000`3oool010000000
oooo0000000000020?ooo`80000000<0oooo0000000000000P3oool20000
0080oooo0P0000000`3oool00000000000020?ooo`8000000`3oool50000
00@0oooo100000020?ooo`<0000000<0oooo0000000000000P3oool60000
02`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OSD0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0[0?oo
o`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhO0?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0[0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWhP0?ooo`<00000D03oool00`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn8@3oool00`000000oooo0?ooo`1?0?oo
o`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhQ0?oo
o`030000003oool0oooo04l0oooo00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOP<0oooo0`0000030?ooo`030000003oool0oooo
00<000000P3oool2000000030?ooo`000000oooo00<0000000@0oooo0000
00000000oooo0`0000000`3oool000000?ooo`0200000080oooo0`000002
0?ooo`<000001@3oool<000000050?ooo`00000000000000003oool01000
00020?ooo`@00000203oool3000000<0oooo0`00000C0?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh40?ooo`040000003o
ool0oooo0?ooo`8000000`3oool010000000oooo0?ooo`0000020?ooo`<0
000000T0oooo0000003oool0oooo0000003oool000000?ooo`0000000P3o
ool200000080oooo00@000000?ooo`3oool000000P3oool01@000000oooo
0?ooo`3oool0000000D0oooo0P0000020?ooo`8000000P3oool200000080
oooo0P0000000`3oool00000000000030?ooo`030000003oool000000080
oooo0P0000060?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo0?ooo`0B0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWh40?ooo`070000003oool0oooo0?ooo`000000oooo0000
00020?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool0
00000P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?oo
o`3oool0oooo000000020?ooo`040000003oool0oooo000000T0oooo0P00
00020?ooo`8000000P3oool200000080oooo0P0000000`3oool000000000
00070?ooo`<000001P3oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool04P3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn103oool010000000oooo0?ooo`0000020?ooo`04
0000003oool0oooo00000080oooo00D000000?ooo`3oool0oooo00000002
0?ooo`040000003oool0oooo000000<0oooo00@000000?ooo`3oool00000
0`3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo00L0
oooo0P0000020?ooo`8000000P3oool200000080oooo0P0000000`3oool0
00000000000400000080oooo0`0000070?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`0B0?ooo`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh40?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool000000P3oool01@000000oooo0?oo
o`3oool000000080oooo00@000000?ooo`3oool000000`3oool010000000
oooo0?ooo`0000030?ooo`040000003oool0oooo00000080oooo1@000005
0?ooo`8000000P3oool200000080oooo0P0000020?ooo`80000000<0oooo
0000000000000P3oool2000000040?ooo`0000000000000000P0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0180oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0oooo
00@000000?ooo`3oool000000`3oool00`000000oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool010000000oooo0?ooo`000002
0?ooo`80000000@0oooo00000000000000000P3oool010000000oooo0?oo
o`0000020?ooo`050000003oool0oooo0?ooo`0000001@3oool200000080
oooo0P0000020?ooo`<0000000@0oooo000000000000oooo0P0000020?oo
o`80000000<0oooo0000000000000P3oool00`000000oooo0?ooo`040?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0B
0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh4
0?ooo`030000003oool0000000@0oooo00@000000?ooo`000000oooo0P00
00020?ooo`8000000P3oool00`000000oooo0000000200000080oooo00D0
00000?ooo`3oool000000?ooo`02000000<0oooo00@000000?ooo`3oool0
oooo0`0000060?ooo`80000000D0oooo00000000000000000?ooo`030000
00030?ooo`000000000000<0oooo100000030?ooo`@000001`3oool30000
00<0oooo1000000B0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWh40?ooo`030000003oool0000000@0oooo00<000000?oo
o`0000002@3oool010000000oooo0?ooo`00000=0?ooo`030000003oool0
oooo00X0oooo0P00000W0?ooo`030000003oool0oooo0180oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0oooo0P000006
0?ooo`800000203oool200000080oooo00<000000?ooo`3oool02P3oool2
000000`0oooo0P0000020?ooo`8000008`3oool010000000oooo0?ooo`00
000A0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWh30?ooo`<000001P3oool3000000P0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00T0oooo0`00
00020?ooo`800000903oool300000140oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000306IVOP3gmoT0V9RW07D0MgNB0@2HV:L10?Ogn@40IVIn00000`1V
IWh0moOi0;bmc@1f0;bmc@40moOi0@1VIWh0000306IVOP3gmoT0i>?S07H0
i>?S0@3gmoT106IVOP0000<0IVIn0?3am03oool0;`3oool00`3Thn<0W:Bi
06]eS`0306]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3o
ool0oooo0>CSh`2LY;T406]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0
W:Bi0>CSh`3oool0oooo0>cZjP2LY;T40:HiA0040:LjA02V>D@0YcY40:Lj
A0T0YSU400<0W:Bi0>cZjP3oool00`3oool10?3am040IVIn00005P1VIWh0
h^7R0?_lo03kno`0nocm0?cko@3knod0nocm0?_lo03lo?d0o?cl0?cko@3l
o?`0o?_l0?clo03ko?`0o?cl0?_lo@3lno`0o?cm0?_ko@3ko?`20?clo004
0?clo@3lo?`0no_m0?cloA@0o?_l0P3ko?`00`2LY;T0JgF?08F9/00@08F9
/00606]eS`2LY;T0nocm0?_lo@2LY;T0JgF?4@25RK001P1[MHl0W:Bi0?_l
o03kno`0W:Bi0:HiA140ZSaE00L0YSU409bT^@3ko?`0o?cl0?cko@3ko?d0
h^7R0040IVIn0000101VIWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kgn03gmoT0
moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3gmoT0103g
m_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0moOi01<0moOi0P3fmoT0
0`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[MHl0QHV`
4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ3@36EE`0
2@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@0106IVOP00
00H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@000000060?7am03`l_D0lO7d
0?7bm03`l_@0lO7d5P3`lOD00`1[MHl0/[G@0:NX`P0@0:NX`P060;:ed01[
MHl0l?7d0?3am01[MHl0/[G@4@2WZ<801@2b]M00JgF?0?3am@3al_@0YSU4
0080`U9K00<0beAI0<eIGP3=FEh02`3=FEh0103;E5T0`U9K0<9BF`2V>D@2
0?3am0030?7am03`l_@0g]gQ0040IVIn00001`1VIWh0g=_P0>[[l03Zjo00
j^c`0>W[k`0000000P3WinL20=kNgP80inOW00<0ikf40>OWi`3WinL00`3W
inL20>o_k`040000003Zjo00j^_`0>[[k`80j^_`00<0j^__0>[[l03Zjo00
4P3Zjo020>[/l00406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk60:b^aP2]
[/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`0406]eS`2f^M40[Jk60:f^
aP`0oooo0P2][/H00`2/[/H0][WA06]eS`020>[[l0050:HiA03=FEh0beAI
0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK0<]DF@3=FEh0YSU40>[[k`3Zjo00
0P3Zjnl10=cKh040IVIn0000101VIWh0fMWO0>?UjP3Si>X20>?Uj`050000
002<S8`0g]kN0>OWi`3Ng]h00P3WinL00`36H`00inOW0>OWi`020>OWi`07
0>o_i`3_knl0kno_0000003Si>X0hnC[0>?UjP020>?TjP030>?Tj`3SiN/0
hnG[0180hnG[0P3Si>X01@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<0
9BDf0;:bbP2b//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bne080
/[;:00<0oooo02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[0>?T
j`2V>D@00P3=FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0e5aO
0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh00003
06IVOP3Gf=h0g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OFcP020>OW
i`050<ik003_U100inOW0>ONaP3_S1000`3_knl01`000000g=kV0=cNi@3L
g^D0g=kV0=cNi@3Lg^H05P3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo00H0
KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0JgF?
0;o1eP80^;W>00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;RicP02
0;RicP090;o1eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP00<0
oooo1@3FGf<30?ooo`0505<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D00`3L
g^H0g=kU0=OHgP0106IVOP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>002@00
0000S8b<0>OWi`3WinL0ikF40=IJ003FQ000olh00<iS00020=i[00050>ne
S03_knl0kno_0>o_k`0000000P3Ef>40103Een00e]SP0=KHh@3Fen4D0=KG
h080e]SP00D0JgF?0<?5f@2l_M40_;gA0?ooo`0702DU=PL0_;gA00H0`lGI
06]eS`3Ef>40eMSQ06]eS`33aMT20;bmd@030?ooo`0U9CH0_;gA00L0_;gA
00<0oooo02DU=P2l_M400P2l_M401@33aMT0JgF?0=KGh03Een40YSU40080
eEeP00<0f61Q0=UQHP167QX00`3oool30=UQHP<0oooo00<0AQhJ0=UQHP3H
H6400P3EGF001P2V>D@0e]SP0=GHh@3Een00eMSQ0=GFg@40IVIn00001`1V
IWh0d]CM0<oBg03@d]`0d=;M0=3Bg00000000`3WinL0303Wg/h0aTX00?O>
003_[@00kkD00<i[0036FP00aV/00=j<BP3WY@00knO>000000<0d=;L00<0
cm;L0=3Bg03?d]`0503@d]`20<oBg@0306]eS`38bM/0`lCF0100`lCF00H0
b<WK06]eS`3@d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U9CH0`lCF00L0
`lCF00<0oooo02DU=P33a=H00P33a=H01`38bM/0JgF?0<oBg03?d]`0YSU4
0=MOG`3IHF800`3LIFD01@167QX0oooo0?ooo`3oool0g6EU00<0oooo00P0
AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?d]`10=;D
g@40IVIn0000701VIWh0d=;K0<_=f03:cMT0blkH0<[=f0000000ilJ]0>O6
S03gcQP0kkd00?O6003_[@00ijd00>NU003FS000cV/00>O6003oeP00knoW
0>o_k`000000blgH0<_=f@3:cMT0blkH0<[=f03;cMPD0<_=f@80blkI00<0
JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38
b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:
f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;
c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?oo
o`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH
0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P00
0000a/K60>ONeP3>N`00ijd00>ne0080ijD000<0eY@00<ic003FU0000P3g
aP020?Ogm`0400000035b=@0aLOD0<G7e0<0aLOE5034amD20<C8e00306]e
S`3@dN00bl_L0100bl_L00H0d=7P06]eS`34am@0a<OD06]eS`3@dN020<_;
g0030?ooo`0U9CH0bl_L00L0bl_L00<0oooo02DU=P3;bm`00P3;bm`01`3@
dN00JgF?0<G7e034am@0YSU40=]TI03OIF@01@3PJVP01@167QX0oooo0?oo
o`3oool0AQhJ00D0h6YX00@0gfET0=]TI02V>D@0a<SE0P34b=@10<G7e@40
cloJ0@1VIWh0000406IVOP3<c]X0`/CB0<74d@80`LCB00H000000>OWi`3W
inL0inOW0=J4003_]@020>NU00080=J4003>J`00ijd00?Ne003g_@00kno_
0?Ogm`0000030<74dP030<;4d@31a=80`LCB01@0`LCA0P31a=800`1[MHl0
dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?d=d0
0`3oool09BDf0<o@g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M00L0dm?R
06]eS`32a=80`LCA0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/J@080>5Y
I@3KI6@0YSU40<74dP32a=40`LCA0<74dP3<c]X106IVOP0000@0IVIn0<[<
f02n`<l0_L3?0P2n`<h01@000000W9bL0>OWi`3Wg]H0eX`00080gY@000@0
eW/00<IS002m@P00kjD00P3g[@00203g]@00oli:0000002n`<h0_/3?0;k0
cP2n`<l0_L3>5@2n`<h20;g0cP0306]eS`3Fe^@0dm?P0100dm?P00H0e]KT
06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo00P0oooo
00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0h6IU0>5Z
JP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo103SK6`0103QJVX0h6IU
0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:f02f^<P0
^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<003NU000eX@00>nU003N
S000_EX00=Ic003_W000mnoW0?Ogm`3oool000000;Vlc02j^l`0^Kc;0;Zl
b`2i_<`0^Kc;01@0^Kc<0P2j_<`00`1[MHl0f=SU0=?Ch@0@0=?Ch@060=SH
i@1[MHl0^[c;0;Zlb`1[MHl0f=SU0P3Cdn400`3oool0KVf?06i]S`0806i]
S`0>02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0JgF?0;Zlb`2j_<`0YSU40>1YJ03Q
KF`0i75]0>AaK`3TL6h30?ooo`0304HN6P3TL6h0AQhJ00<0oooo0P3TL6h0
2@3TLFd0hFe/0>1YJ02V>D@0^[c<0;Zkc02i_</0][S80<W:f00106IVOP00
00T0IVIn0<O9e`2d]/L0][S80;Jhb@2f^LT0000008B4Q03Wimh00P3_knl0
1`36J`00mlH00>ne003_W000gX`00<i[003WW0000`3gmoL01@000000][W9
0;Nhb@2f^LT0]kW90080][S9502g^<T20;Jhb@0406]eS`3Fe^@0f=SU0=SH
iP<0f=SU1@3Hf>H30=SHi@80f=SV0P3Hf>D02@3Fe^@0JgF?0;Nhb@2g^<T0
JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]S`0=02DU=P3Hf>H0f=SU0=SHi@3F
e^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3TM6l0ig5_0>AdK`030?ooo`0504HN
6P3TM6l0i7A_0>AdK`167QX00`3oool02P3TM6l0ig5_0>AdK`3TKVd0YSU4
0;Jib@2f^<T0][W90;Bfa`37bML106IVOP0000<0IVIn0<K8e`2d]/L00`2d
]/L00`000000kno_0>o_k`020>o_k`0;0>N]003gaPP0ijD00>ND003WS000
knOF0=jD>@3_e[D0ooOg0?ooo`000000702d]/L01@1[MHl0eMGS0=cKi`3L
fnL0gM_W00h0g=_W00H0eMGS06]eS`2d]/L0];K706]eS`3EeN<20=cKi`03
0=gKi`0U9CH09BDf00T09BDf0`3LfnL02@3EeN<0JgF?0;Bfa`2d]/L0YSU4
0>McK`3WMG80jWIc0>YhMP020?ooo`0304HN6P3YOWP0jGih00<0jGih00P0
AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80ig=_0:HiA0@0];K70@36b=L106IV
OP0000<0IVIn0<K8e`2d]/L00`2d]/L01P000000S8b<0>o_k`3_knl0ilik
0>o_k`80moOg00P0ii@00?OWcP3gmoL0moOg0>oWeP3gmoL0oooo000001`0
];K700<0JgF?0=GDh`3PgnX0403PgnX01P3Ee><0JgF?0;Bfa`2d]/L0JgF?
0=GDha40h=oZ00T0eMCS06]eS`2d]/L0];K70:HiA03ZNG<0jGah0>n1NP3b
RH400P167QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<0>fGRP3[V8/00P167QX0
1@3bRH40kh5j0>UlN03ZNG<0YSU400@0];K70@36b=L106IVOP0000<0IVIn
0<K8e`2a/lP00`2a/lP01P000000kno_0>o_k`3_knl0moO_0>o_k`80moOg
00<0mnO60?Ogm`3oool00`3gmoL00`3oool000000;6cb00K0;6cb00306]e
S`3]jo<0jNSa0100jNSa00H0kN_c06]eS`2a/lP0/K?806]eS`3]jo<A0>WX
l@0I0>g[l`1[MHl0/K?80;6cb02V>D@0lH1e0?24O03eS8@0mif>0?:[UP3a
/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03bZiH0mif>0?F<
Q03`Q7`0lH1e0:HiA0040;6cb040a/SG0@1VIWh0000306IVOP36b=L0^;O?
00<0[jk700D000000:f][@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3oool0
0`000000[jk70:n^a`0J0:n^a`0306]eS`3BdN<0l_7g0100l_7g00H0d]7S
06]eS`2_[/L0[jk706]eS`3BdN<A0?;am`060=;Ah`1[MHl0[jk70:n^a`2V
>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0m8Ym0:HiA02_[/L00P2_[/L10;Rg
c`40a/SG0@1VIWh0000306IVOP30`M40alOD02l0[:_400@0Q8bR06]eS`3<
bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a00408B<XP1[MHl0
c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01`2AV:X0YSU4
0?nOS@3n_j@0n]bg0?[[]`3jjKH00P3ijKH0103jjKH0nNVf0?WY]P3jjKH2
0?WY]P060?[[]`3jg;L0o[nT0?nOS@2V>D@0TIRZ0`2/Zl@10<O7e040`<7A
0@1VIWh0000406IVOP30`M40d];O0;FdbBl0Y:>n00<0Q8bR06]eS`1[MHl0
3`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP1[MHl0JgF?00l0JgF?
00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80YSU40:HiA00?0:HiA00708B<
XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31d@0106IVOP0000H0IVIn0:RW_`3V
i^d0d];P0;blc`2a/<A_0:RW_`050;6`a02l_<l0d];P0>KVk@2XYkl00@1V
IWh0000705QGJ027Qi/0emSR0?clo03ThnP0d=3P0<[:fP1]0;blc`060<[:
fP3@d>00i>?X0?clo03Gf>80QhNK0@1HEfP0000805QGJ01VIWh0UIB[0=OH
hP3lo?`0l_7c0>c[kP3Qh^][0=OHhP070>7Rj`3/jnh0l_7c0?clo03Gf>80
UIB[06IVOP0105QGJ0000P1HEfP00`1VIWh0UIB[0=7AgP020?clo6d0oooo
0P3lo?`00`3AdMh0UIB[06IVOP0205QGJ0000`1HEfP206IVOP0308R7W@2E
U:/0Z:No06`0Z:No00@0UIB[08R7W@1VIWh0IVIn0`1HEfP000D0F5MXL@1V
IWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  Evaluatable->False,
  ImageSize->{123, 114},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"TextPanel"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"TextPanel"]
}, Open  ]],

Cell["In this version, we use RTF instead.", "Text",
  CellTags->"TextPanel"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<TextPanel\>", \ {\
\[IndentingNewLine]"\<preferredSize\>" \[Rule] 
                Widget["\<Dimension\>", {"\<width\>" \[Rule] 
                      50, "\<height\>" \[Rule] 
                      80}], \[IndentingNewLine]"\<contentType\>"\  \[Rule] \ \
"\<text/rtf\>", \[IndentingNewLine]"\<text\>" -> "\<{\\rtf1 Multiple \\b \
lines\\b0  of \\i running text}\>"}]\ \[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"TextPanel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"TextPanel"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000LR000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOR<0oooo
0`00001=0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWhR0?ooo`050000003oool0oooo0?ooo`000000C03oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn103oool00`000000
oooo0?ooo`020?ooo`030000003oool000000080oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00@000000?ooo`3oool0oooo0`0000050?ooo`800000
0P3oool200000080oooo00<000000?ooo`3oool00P3oool010000000oooo
00000000000f0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWh40?ooo`060000003oool0oooo0?ooo`000000oooo0P000002
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
0P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000
=`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
103oool01@000000oooo0?ooo`3oool0000000<0oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo00000080oooo00H000000?ooo`3oool000000?ooo`0000030?ooo`03
0000003oool0oooo0080oooo00@000000?ooo`3oool000001P3oool20000
00<0oooo00<000000?ooo`3oool0=@3oool00`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn1@3oool01@000000oooo0?ooo`3oool0
00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000020?ooo`040000003oool0oooo00000080oooo00H000000?ooo`3o
ool000000?ooo`0000030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool01@0000030?ooo`8000000P3oool00`000000oooo0?ooo`0e
0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh5
0?ooo`8000000P3oool010000000oooo0?ooo`0000020?ooo`80000000@0
oooo0000003oool0oooo0P0000001@3oool000000?ooo`3oool000000080
oooo0P0000001P3oool000000?ooo`3oool000000?ooo`8000001@3oool0
10000000oooo0?ooo`0000020?ooo`050000003oool0oooo0000003oool0
0P0000020?ooo`030000003oool0oooo03@0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPD0oooo00D000000?ooo`000000
oooo000000020?ooo`060000003oool0oooo0000003oool000000`3oool0
0`000000oooo000000030?ooo`060000003oool0oooo0000003oool00000
103oool00`000000oooo000000040?ooo`<000000P3oool200000080oooo
00@000000?ooo`3oool0oooo1@00000e0?ooo`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWh]0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool0=03oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn703oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0=03oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInL`3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInL`3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInL`3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInL`3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3oool00`000000
oooo0?ooo`1]0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWh30?ooo`030000003oool0oooo0180oooo00<000000?ooo`3o
ool0F03oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn0`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo05P0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0
oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020000
00050?ooo`000000oooo0000003oool00P0000001@3oool000000?ooo`00
0000oooo008000000P3oool00`000000oooo0?ooo`03000000D0oooo0P00
0000103oool000000000003oool200000080oooo0P0000020?ooo`@00000
0`3oool4000000H0oooo0`0000030?ooo`030000003oool0oooo0280oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0oooo
00@000000?ooo`3oool000000P3oool00`000000oooo000000020?ooo`80
000000@0oooo0000003oool000000P3oool010000000oooo000000000002
0?ooo`050000003oool000000?ooo`0000000`3oool00`000000oooo0?oo
o`020?ooo`80000000@0oooo000000000000oooo0P0000020?ooo`800000
00<0oooo0000000000000P3oool2000000030?ooo`00000000000080oooo
0P0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`0R0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWh30?ooo`090000003oool000000?ooo`000000oooo0000003o
ool0000000<0oooo00D000000?ooo`000000oooo000000020?ooo`030000
003oool0000000<0oooo00D000000?ooo`000000oooo000000080?ooo`80
000000@0oooo000000000000oooo0P0000020?ooo`80000000<0oooo0000
000000001`3oool4000000@0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo0280oooo00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOP<0oooo00T000000?ooo`000000oooo0000
003oool000000?ooo`0000000`3oool01@000000oooo0000003oool00000
0080oooo00<000000?ooo`0000000`3oool010000000oooo0000003oool5
000000@0oooo0P000000103oool000000000003oool200000080oooo0P00
00000`3oool0000000000004000000030?ooo`0000000000008000001P3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0
8P3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
0`3oool02@000000oooo0000003oool000000?ooo`000000oooo00000003
0?ooo`050000003oool000000?ooo`0000000P3oool010000000oooo0000
000000020?ooo`050000003oool000000?ooo`0000000`3oool00`000000
oooo0?ooo`020?ooo`80000000@0oooo000000000000oooo0P0000020?oo
o`80000000<0oooo0000000000000P3oool2000000030?ooo`0000000000
0080oooo0P0000040?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`0R0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWh30?ooo`8000000`3oool2000000030?ooo`000000
oooo0080oooo00<000000?ooo`0000000`0000001@3oool000000?ooo`00
0000oooo008000000P3oool00`000000oooo0?ooo`03000000D0oooo0P00
0000103oool000000000003oool5000000<0oooo100000030?ooo`@00000
1P3oool300000080oooo0`00000S0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh30?ooo`8000000`3oool2000000L0oooo
00<000000?ooo`0000002P3oool00`000000oooo0?ooo`080?ooo`800000
8`3oool00`000000oooo0?ooo`0R0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh30?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool01@3oool00`000000oooo000000020?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0203oool2000000030?oo
o`00000000000240oooo00<000000?ooo`3oool08@3oool00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3oool00`000000oooo
0?ooo`1]0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh30?ooo`030000003oool0oooo06d0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0oooo00<000000?ooo`3oool0
K@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
0`3oool00`000000oooo0?ooo`1]0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWic0?ooo`0306IVOP2XZK/0nocm0040IVIn
00000`1VIWh0moOi09RHY`1e07MgTP40V9RW0@3gmoT106IVOP0000<0IVIn
0?Ogn@2l_Ld0MP2l_Ld10?Ogn@40IVIn00000`1VIWh0moOi0>CSh`1f0>CS
h`40moOi0@1VIWh0000306IVOP3`lO@0oooo02l0oooo00<0i>?S09bT^@1[
MHl00`1[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo
0?ooo`3Thn<0W:Bi101[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT
^@3Thn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W>T@0YSU40:LjA02W>T@9
0:HiA00309bT^@3/j^X0oooo00<0oooo0@3`lO@106IVOP0001H0IVIn0>;Q
hP3ko?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0o?cm0?clo03lnod0o?cl
0?cko03lo?`0nocl0?clo03ko?d0o?_l0?clo@3knod0nocl0P3lo?`0103l
o?d0o?cl0?_ko@3lo?dD0?cko080nocl00<0W:Bi06]eS`25RK004025RK00
1P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3ko?`0
no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?clo03lnod0nocm0>;Q
hP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi0?Og
n03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0moKh
0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0C0?Ogn@80m_Oi00<0
JgF?08F9/02LW[h0402LW[h01P25RK00JgF?0?Ogn@3gmoT0JgF?08F9/140
W9jn00P0QHV`06]eS`3fmoP0moOh0:HiA02Z?5D0`U9K0<IDFPd0aUEL00T0
aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>400@1VIWh00006
06IVOP3NgN40lO7d0?7am03`lO@0l?;d400000001P3alO@0l?;e0?7am03a
l_@0l?;d0?7am1H0l?7e00<0JgF?0;:ed02WZ<80402WZ<801P2b]M00JgF?
0?3am03`lO@0JgF?0;:ed140YjS200D0/[G@06]eS`3`lOD0lO;d0:HiA002
0<9BF`030<]DF@3=FEh0cEUN00/0cEUN00@0beAI0<9BF`32DU/0YSU40P3`
lO@00`3alO@0l?;d0=kMh@0106IVOP0000L0IVIn0=cKh03Zjo00j^_`0>[/
l03Yjnl000000080inOW0P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0inOW
0P3_knl010000000j^_`0>[[l03Zjnl20>[[l0030>[[k`3Zjo00j^_`0180
j^_`0P3Zk?00101[MHl0][WA0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk6
00<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<
0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=
EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080
j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000
S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<00>OWi`3WinL00P3WinL01`3_
knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?U
j`0B0>?Uj`80hnCZ00D0JgF?0;bne02b//X0/[;:0?ooo`0606i]S`0302DU
=P2b//X0/[;:00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ06]eS`2l_]@20;:b
bP030?ooo`0U9CH09BDf00T09BDf0`2b//X01@2l_]@0JgF?0>?Tj`3Si>/0
YSU40080cEUN00@0d5]P0=ALG`3oool0oooo1`3DG5l20?ooo`0:0=ALG`3@
Ff00cEUN0<eIGP2V>D@0hnCZ0>?UjP3Si>X0hnG[0=WIg`40IVIn00000`1V
IWh0emSN0=cNiP030=cNiP050000003WinL0inOW0>OWi`3We/h00P3WinL0
1@3>N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_00L000000=cNiP3Lg^D0g=kU
0=cNiP3Lg^D0g=kV01H0g=kU00D0JgF?0;o1eP2h^Lh0^;W>0?ooo`0606i]
S`0302DU=P2h^Lh0^;W>00D0^;W>00H0_l7F06]eS`3Lg^D0g=kU06]eS`2o
`MH20;RicP030?ooo`0U9CH0^;W>00L0^;W>00<0oooo02DU=P2h^Lh00P2h
^Lh02@2o`MH0JgF?0=cNiP3Lg^D0YSU40<eIGP3AFUh0e5eQ05<U80030?oo
o`D0eUmS0`3oool01@1C9B00e5eQ0=5JGP3=FEh0YSU40080g=kU00<0g=kV
0=cNi@3Gf=h00@1VIWh0000406IVOP3Ee]d0eMSP0=KHh@80eMSP00T00000
08b<S03WinL0inOW0>NeQ03FFP00eX@00?o>003>H`000P3NJ`001@3_]H`0
kno_0>o_k`3_knl000000080eMSQ00@0eMOP0=KHh03Ff>40e]OQ503Fen02
0=KHh00506]eS`33aMT0_;gA0;bmd@3oool01`0U9CH70;bmd@060<?5f@1[
MHl0eMSQ0=GHh@1[MHl0`lGI0P2l_M400`3oool09BDf0;bmd@070;bmd@03
0?ooo`0U9CH0_;gA0080_;gA00D0`lGI06]eS`3Fen00eMOQ0:HiA0020=EM
H0030=QPH@3IHF80AQhJ00<0oooo0`3IHF830?ooo`0304HN6P3IHF80f61Q
0080eEeP00H0YSU40=KHh03Ef>40eMOP0=GHh@3Ee]d106IVOP0000L0IVIn
0=;Dg@3?d]`0d=;L0=3Bg@3@d]`0000000<0inOW00`0imk>0<I:003gcP00
kjd00>ne003>J`00aUX00<I[003NS4X0ijD00>oWcP0000030=3Bg0030<oB
g03@d]`0cm;L01@0d=;L0P3?d]d00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9
f`1[MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP070<?4
eP030?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03G
Gel0fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`0804HN
6P3LIFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d1
06IVOP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0
mlhH0>nm003gaP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_
knl000000<_=f03;cMT0b/gI0<_>f03:cMP0blgH503;cMT20<_>f@0306]e
S`3;c=h0b<[I00P0b<[I00<0b<WI0<S:f@38b]T00`38b]T01038bMT0b<[I
0<_<gP1[MHl20<_=f00606]eS`3;c=h0b<[I0<S:f@3oool09BDf1@38b]T0
4@38bMT0b<[I0<S:f@3oool09BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH
0<[=f02V>D@0eemO0=]TI03PIfD0h6IU0080gVMW00<0AQhJ0?ooo`3oool0
0`3oool02P167QX0gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0YSU40<[>f03:
c]T20<_=f@40d=;K0@1VIWh0000306IVOP3?cmX0aLSD00<0aLSD00H00000
0<K6aP3Wg]H0cW/00>N]003_]@020>NU00030=JD003>L`00eY@00080mlH0
0P3gmoL010000000aLSD0<G7e035am@30<G7eA@0a<OE0P34b=@00`1[MHl0
d=7P0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`0
0`3oool09BDf0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P
06]eS`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0
oooo04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD0@35amD10<o?
fP40IVIn0000101VIWh0c<kJ0<;4dP31a=420<74dP060000003WinL0inOW
0>OWi`3FQ000kkD00P3WY@00203FQ000cV/00>N]003g]@00mkd00>o_k`3g
moL000000`31a=800`32a=40`LCB0<74dP0D0<74d@80`LCB00<0JgF?0=?C
hP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M00<0
oooo02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@020<o@g@070=?ChP1[
MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203QJFD0
ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:c=P0
_/3?0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<00020=jD00040=Ik
0036H`00_D800>nU0080mjd000P0mkD00?o>BP000000_/3>0;k0c`2n`<h0
_/3?0;g0cQD0_/3>0P2m`<h00`1[MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[
MHl0_/3>0;k0cP1[MHl0e]KT0P3Cdn000`3oool09BDf0?ooo`080?ooo`0;
02DU=P3Cdn00dm?P0=?Ch03Fe^@0JgF?0;k0c`2n`<h0YSU40>1VI@3QJVX0
103SK6`30?ooo`0404HN6P3oool0oooo0?ooo`@0hfa/00@0hFYZ0>1VI@2V
>D@0_L3?0P2n`<l10;k0cP40b/cH0@1VIWh0000706IVOP39b]P0][S80;Vl
b`2j_</0^[c<000000020>o_k`0C0=JL003FS000gY@00=J4003_Y@00gX`0
0;eJ003FL`00ki`00?O_i`3gmoL0oooo0000002i_<`0^[_<0;Vlb`2j_</0
^Kc<0;Vlb`0D0;Vlc080^[c<00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0
JgF?0;Zlb`2j_</0JgF?0=SHi@80dm?Q00<0oooo06i]S`1^KHl0201^KHl0
3P0U9CH0dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<0:HiA03PJFP0hFe/
0>AaK@3TLFl0i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^00T0
i75]0>5]K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039b]P00@1VIWh00009
06IVOP37bML0];K70;Jhb02f^<T0][W900000024Q8@0inON0080kno_00L0
aV/00?O6003_]@00ki`00=j<003>J`00ii`000<0moOg00D000000;Jib@2g
^<T0][W90;Nib@020;JhbA@0]kS90P2f^<T0101[MHl0e]KT0=SHi@3Hf>H3
0=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0e]KT06]eS`2g^<T0]kS906]e
S`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT
06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0
i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f
^LT0][S90;Jib@2d]/L0alWG0@1VIWh0000306IVOP36b=L0];K700<0];K7
00<000000>o_k`3_knl00P3_knl02`3W[@00mlH80>NU003WU000ih`00>oW
eP3NU3T0kmJe0?ogm`3oool0000001`0];K700D0JgF?0=GEh`3LfnL0g=_W
0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3M
fnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03W
Lfl0igEb0>YfL`3ZN7H00P3oool00`167QX0jGih0>UnN0030>UnN00804HN
6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0
000306IVOP36b=L0];K700<0];K700H0000008b<S03_knl0kno_0>O>N`3_
knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_imH0moOg0?ooo`00000L0;Bf
a`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3E
e><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV1
0080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0
lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40a/SG0@1VIWh0000306IVOP36
b=L0/K?800<0/K?800H000000>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`03
0?OWaP3gmoL0oooo00<0moOg00<0oooo0000002a/lP06`2a/lP00`1[MHl0
kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?40
6@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K
0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0
l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`03
0:n^a`050000002][Jd0moO_0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<0
00000:n^a`2_[/L06P2_[/L00`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[
MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU4
0?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll1
0<K8e`40IVIn00000`1VIWh0`<7A0<O7e00_0:b[a00408B<XP1[MHl0c<_M
0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;
g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03o
Whd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3i
jKH01P3jjkL0n]bg0?joY03oWhd0YSU4096HZP<0[:_40@37am@10<31d@40
IVIn0000101VIWh0`<7A0=;Bg`2e]<T_0:BS_P0308B<XP1[MHl0JgF?00l0
JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80JgF?06]eS`0?06]eS`03
08B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80
Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1VIWh0000606IVOP2XYkl0i^K]
0=;Bh02l_<l0/K34K`2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn
00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@h03:b]X0K@2l_<l01P3:b]X0
d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80
o?cl0?;al`3/jnh0hN;[J`3Gf>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FD
Z`1VIWh00@1HEfP00080F5MX00<0IVIn09FDZ`3AdMh00P3lo?a]0?ooo`80
o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[
0:RW_`1/0:RW_`0409FDZ`28Qid0IVIn06IVOP<0F5MX000505QGJ740IVIn
1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[7]:=",
  Evaluatable->False,
  ImageSize->{123, 114},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"TextPanel"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]=",
  CellTags->"TextPanel"]
}, Open  ]],

Cell[TextData[{
  "Although you can always specify the text content inline using the ",
  StyleBox["\"text\"", "Program"],
  " property, it may be more convenient to store your HTML or RTF in an \
external file and specify its relative or URL location using the ",
  StyleBox["\"path\"", "Program"],
  " property."
}], "Text",
  CellTags->"TextPanel"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<TextPanel\>", \ {\
\[IndentingNewLine]"\<preferredSize\>" \[Rule] 
                Widget["\<Dimension\>", {"\<width\>" \[Rule] 
                      130, "\<height\>" \[Rule] 
                      210}], \[IndentingNewLine]"\<contentType\>"\  \[Rule] \ \
"\<text/html\>", \[IndentingNewLine]"\<editable\>" \[Rule] 
                False, \[IndentingNewLine]"\<path\>" -> \
"\<Wolfram/Example/sampleText.html\>"}]\ \[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"TextPanel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"TextPanel"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002:0000m2000`400?l0
0000o`00003oRP1VIWh0000306IVOP3ko?d0nocm08H0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk08D0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
Q01VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOR/0oooo
0P0000090?ooo`<000000P3oool2000000<0oooo0`0000001@3oool00000
000000000000oooo00<0000000@0oooo00000000000000001@3oool20000
00@0oooo00D000000?ooo`3oool0oooo000000050?ooo`<000006`3oool0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn:@3oool6
000000P0oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`00
00000`3oool00`000000oooo000000030?ooo`050000003oool0oooo0?oo
o`0000001P3oool00`000000oooo000000020?ooo`8000000P3oool20000
00@0oooo00D000000?ooo`3oool0oooo0000000J0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhY0?ooo`H00000203oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool00`3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`020?ooo`070000003oool000000?ooo`00
0000oooo000000030?ooo`050000003oool0oooo0?ooo`0000006P3oool0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn:03oool8
000000L0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0oooo00@0oooo00<000000?ooo`3oool00P3oool01`000000oooo
0000003oool000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0
000001X0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVORP0oooo200000070?ooo`050000003oool0oooo0?ooo`0000000`3o
ool5000000030?ooo`000000oooo0080oooo00D000000?ooo`3oool0oooo
000000060?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000000J
0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhY
0?ooo`H00000203oool01@000000oooo0?ooo`3oool0000000<0oooo00@0
00000?ooo`3oool0oooo100000020?ooo`8000000P3oool00`000000oooo
0?ooo`040?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000
oooo0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo0000000J
0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhY
0?ooo`H00000203oool00`000000oooo0?ooo`03000000<0oooo0`000002
0?ooo`040000003oool0000000000080oooo0P0000060?ooo`<0000000D0
oooo00000000000000000?ooo`03000000040?ooo`000000000000000080
oooo0`00000K0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWh[0?ooo`8000002P3oool01@000000oooo0?ooo`3oool00000
01P0oooo00<000000?ooo`3oool0:`3oool00`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn=`3oool01@000000oooo0?ooo`3oool0
000001P0oooo00<000000?ooo`3oool0:`3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn=P3oool3000004T0oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOR/0oooo0P000009
0?ooo`<000000P3oool2000000<0oooo0`0000001@3oool0000000000000
0000oooo00<0000000@0oooo00000000000000001P3oool300000080oooo
0`000000103oool000000000000000020?ooo`<00000703oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn:@3oool6000000P0
oooo00T000000?ooo`3oool0oooo0000003oool000000?ooo`0000000`3o
ool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`000000
1P3oool01@000000oooo0?ooo`3oool000000080oooo00D000000?ooo`3o
ool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000006`3oool0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn:@3oool6
000000P0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo00<0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0oooo00@0oooo00D000000?ooo`3oool0oooo000000020?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0M0?oo
o`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhX0?oo
o`P000001`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<00000
0?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool0103oool01@000000oooo0?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo01d0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVORP0
oooo200000070?ooo`050000003oool0oooo0?ooo`0000000`3oool50000
00030?ooo`000000oooo0080oooo00D000000?ooo`3oool0oooo00000006
0?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool000000080oooo1@00000K0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWhY0?ooo`H00000203oool01@000000oooo
0?ooo`3oool0000000<0oooo00@000000?ooo`3oool0oooo100000020?oo
o`8000000P3oool00`000000oooo0?ooo`040?ooo`060000003oool0oooo
0?ooo`000000oooo0`0000020?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool06@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn:@3oool6000000P0oooo00<000000?ooo`3oool0
0`0000030?ooo`<000000P3oool010000000oooo0000000000020?ooo`80
0000203oool3000000<0oooo00@000000?ooo`0000000000103oool30000
01`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OR/0oooo0P00000:0?ooo`050000003oool0oooo0?ooo`000000AP3oool0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn=`3oool0
1@000000oooo0?ooo`3oool0000004H0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOSH0oooo0`0000190?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh30?ooo`030410@030
`<00`<3007T0`<300`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn0`3oooml0410@0<0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOSh0oooo0P0000120?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhn0?ooo`030000003o
ool000000440oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOT00oooo00<000000?ooo`3oool0?`3oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3oool3000000<0oooo0`00
00040?ooo`T0000000@0oooo00000000000000000P3oool3000000L0oooo
0`0000030?ooo`<000001@3oool300000080oooo0P0000030?ooo`030000
003oool0oooo0080oooo0P0000030?ooo`<000000P3oool3000000030?oo
o`000000000000D0oooo0P0000030?ooo`<000000P3oool00`000000oooo
0?ooo`02000000030?ooo`000000000001D0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`040?ooo`040000003oool0oooo00000080
oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo
0?ooo`0000001@3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool0103oool020000000oooo0?ooo`000000oooo0000003o
ool000000P3oool2000000<0oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool000000080oooo0P0000060?ooo`050000003oool0
00000?ooo`0000000`3oool01P000000oooo0?ooo`000000oooo00000080
oooo00<000000?ooo`000000503oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn103oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00@0oooo00@000000?ooo`3oool000000P3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool01`3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool01`3o
ool010000000oooo0?ooo`0000030?ooo`800000103oool00`000000oooo
0?ooo`03000000<0oooo00@000000?ooo`3oool0oooo0P0000060?ooo`03
0000003oool0oooo00<000001@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo01<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOPD0oooo1@0000070?ooo`040000003oool0oooo0000
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0
oooo00L0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo00H0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0000000<0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`0000040?ooo`030000003oool0oooo00@0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool04`3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@3oool01@000000oooo0?ooo`3o
ool0000000L0oooo00@000000?ooo`3oool000000P3oool01@000000oooo
0?ooo`3oool000000080oooo1@0000050?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0080oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0
oooo00000080oooo00D000000?ooo`3oool0oooo000000020?ooo`050000
003oool0oooo0?ooo`0000001P3oool010000000oooo0?ooo`0000030?oo
o`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0C
0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh5
0?ooo`050000003oool0oooo0?ooo`0000001`3oool01@000000oooo0000
00000000oooo00<000000P3oool010000000oooo0?ooo`0000030?ooo`03
0000003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool01@00
0000oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000`3o
ool010000000oooo0?ooo`0000030?ooo`040000003oool0oooo000000H0
oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo
0?ooo`8000000`3oool00`000000oooo0?ooo`0C0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh60?ooo`030000003oool0
000000P0oooo00@000000?ooo`3oool000000P3oool010000000oooo0000
000000040?ooo`<000001`3oool3000000<0oooo100000050?ooo`<00000
00<0oooo000000000000100000000`3oool00000000000030?ooo`040000
003oool0oooo0?ooo`<00000103oool2000000030?ooo`000000oooo00<0
oooo100000020?ooo`<0000000<0oooo0000000000000P3oool6000001<0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPH0
oooo00<000000?ooo`000000203oool00`000000oooo0?ooo`0L0?ooo`03
0000003oool0oooo00/0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0B0?ooo`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWh70?ooo`030000003oool0oooo00H0
oooo0P00000N0?ooo`040000003oool0oooo000000X0oooo00<000000?oo
o`3oool01`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?oo
o`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh70?oo
o`030000003oool0oooo00L0oooo00@000000?ooo`3oool00000703oool3
000001<0oooo0P00000<0?ooo`800000:`3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVInPP3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn103oool00`000000oooo00000002
000000@0oooo1`000000103oool000000000000000040?ooo`80000000<0
oooo0000000000000P0000020?ooo`80000000<0oooo0000000000000P00
00000`3oool000000000000200000540oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOP@0oooo0P0000020?ooo`8000000P3o
ool200000080oooo0P0000000`3oool00000000000020?ooo`8000000P3o
ool2000000030?ooo`000000oooo008000000P3oool2000000030?ooo`00
0000oooo0080000000<0oooo0000000000000`3oool00`000000oooo0?oo
o`1>0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWh40?ooo`040000003oool0oooo0?ooo`8000000P3oool200000080oooo
0P0000000`3oool00000000000020?ooo`8000000P3oool2000000<0oooo
0P0000020?ooo`8000000`3oool2000000030?ooo`000000000005@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPL0oooo
0`0000020?ooo`8000000P3oool2000000030?ooo`00000000000080oooo
0P0000020?ooo`8000000`3oool200000080oooo0P0000030?ooo`800000
00<0oooo0000000000001000001@0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh60?ooo`<000000`3oool200000080oooo
0P0000000`3oool00000000000020?ooo`8000000P3oool2000000<0oooo
0P0000020?ooo`8000000`3oool2000000030?ooo`00000000000080oooo
0P00001@0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh50?ooo`<00000103oool200000080oooo0P0000000`3oool00000
000000020?ooo`8000000P3oool2000000<0oooo0P0000020?ooo`800000
0`3oool2000000030?ooo`00000000000080oooo0P00001@0?ooo`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh40?ooo`<00000
103oool3000000050?ooo`00000000000000003oool01@0000020?ooo`@0
000000D0oooo00000000000000000?ooo`0400000080oooo0P0000020?oo
o`@00000D@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn103oool2000000<0oooo00<000000?ooo`3oool01`3oool20000
00L0oooo00<000000?ooo`3oool01P3oool010000000oooo0?ooo`3oool2
000005L0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP@0oooo0P0000020?ooo`8000002@3oool2000000L0oooo00@00000
0?ooo`3oool0oooo0P0000030?ooo`040000003oool0oooo0?ooo`800000
E`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
1@3oool3000000030?ooo`000000oooo00L0oooo0`00000;0?ooo`800000
1P3oool3000005L0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOX80oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOPD0oooo1`0000020?ooo`D000000P3oool3000000030?oo
o`000000000000<000000`3oool4000005d0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPL0oooo0`0000050?ooo`<00000
0P3oool3000000030?ooo`000000oooo00<000000`3oool300000080oooo
00<000000?ooo`3oool0FP3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn1`3oool3000000D0oooo0`0000020?ooo`<00000
0`3oool300000080oooo0`00001P0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh70?ooo`<000001@3oool300000080oooo
0`0000030?ooo`<000000P3oool300000600oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPL0oooo0`0000050?ooo`<00000
0P3oool3000000<0oooo0`0000020?ooo`L00000G03oool00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1`3oool3000000D0oooo
0`0000020?ooo`<000000`3oool300000080oooo0`000000103oool00000
00000000001L0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWh70?ooo`<000001@3oool300000080oooo0`0000030?ooo`<0
00000`3oool2000000030?ooo`000000000005d0oooo00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPL0oooo0`0000040?ooo`@0
000000<0oooo00000000000010000000103oool000000000000000040?oo
o`<00000GP3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn1`3oool3000000/0oooo0P0000030?ooo`<00000I@3oool00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3oool01000
0000oooo0?ooo`3oool3000000<0oooo00<000000?ooo`0000000P000004
0?ooo`040000003oool0oooo0?ooo`<00000I@3oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0`3oool010000000oooo0?oo
o`3oool3000000<0oooo00<000000?ooo`0000000P0000040?ooo`040000
003oool0oooo0?ooo`<00000I@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn0`3oool;000000040?ooo`00000000000000
00L0oooo1000001U0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWj20?ooo`0306IVOP2XZK/0nocm0040IVIn00000`1VIWh0
moOi09RHY`2407MgTP40V9RW0@3gmoT106IVOP0000<0IVIn0?Ogn@2l_Ld0
Q@2l_Ld10?Ogn@40IVIn00000`1VIWh0moOi0>CSh`250>CSh`40moOi0@1V
IWh0000306IVOP3`lO@0oooo03h0oooo00<0i>?S09bT^@1[MHl00`1[MHl0
101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3Thn<0
W:Bi101[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo
0?ooo`3/j^X0W:Bi102V>D@0102W>T@0YSU40:LjA02W>T@90:HiA00309bT
^@3/j^X0oooo00<0oooo0@3`lO@106IVOP0001H0IVIn0>;QhP3ko?`0no_l
0?_lo@3lnod0no_m0?_lo@3ko?`0o?cm0?clo03lnod0o?cl0?cko03lo?`0
nocl0?clo03ko?d0o?_l0?clo@3knod0nocl0P3lo?`0103lo?d0o?cl0?_k
o@3lo?dI0?cko0`0nocl00<0W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi
0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V
>D@A0:XlE@070:HiA02LY;T0nocl0?clo03lnod0nocm0>;QhP0106IVOP00
00@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi
0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0
moOi0`3fmoT00`3fmoP0moOi0?Ogn@0H0?Ogn@`0m_Oi00<0JgF?08F9/02L
W[h0402LW[h01P25RK00JgF?0?Ogn@3gmoT0JgF?08F9/140W9jn00P0QHV`
06]eS`3fmoP0moOh0:HiA02Z?5D0`U9K0<IDFPd0aUEL00T0aUAJ0<9BF`2Z
?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>400@1VIWh0000606IVOP3NgN40
lO7d0?7am03`lO@0l?;d400000001P3alO@0l?;e0?7am03al_@0l?;d0?7a
m2D0l?7e00<0JgF?0;:ed02WZ<80402WZ<801P2b]M00JgF?0?3am03`lO@0
JgF?0;:ed140YjS200D0/[G@06]eS`3`lOD0lO;d0:HiA0020<9BF`030<]D
F@3=FEh0cEUN00/0cEUN00@0beAI0<9BF`32DU/0YSU40P3`lO@00`3alO@0
l?;d0=kMh@0106IVOP0000L0IVIn0=cKh03Zjo00j^_`0>[/l03Yjnl00000
0080inOW0P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0inOW0P3_knl01000
0000j^_`0>[[l03Zjnl20>[[l0030>[[k`3Zjo00j^_`01L0j^_`303Zk?00
101[MHl0][WA0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0
[:k60;Jid@1[MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk6
00<0[:k60;Jid@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0
d5YO00L0cUUO0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn01
06IVOP0000@0IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3W
inL0g]kN0080inOW00<0aV<00>OWi`3WinL00P3WinL01`3_knL0kno_0>o_
k`000000hnCZ0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0G0>?Uj``0
hnCZ00D0JgF?0;bne02b//X0/[;:0?ooo`0606i]S`0302DU=P2b//X0/[;:
00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ06]eS`2l_]@20;:bbP030?ooo`0U
9CH09BDf00T09BDf0`2b//X01@2l_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN
00@0d5]P0=ALG`3oool0oooo1`3DG5l20?ooo`0:0=ALG`3@Ff00cEUN0<eI
GP2V>D@0hnCZ0>?UjP3Si>X0hnG[0=WIg`40IVIn00000`1VIWh0emSN0=cN
iP030=cNiP050000003WinL0inOW0>OWi`3We/h00P3WinL01@3>N`00ki@@
0>OWi`3Wg/H0kh`@00<0kno_00L000000=cNiP3Lg^D0g=kU0=cNiP3Lg^D0
g=kV02D0g=kU00D0JgF?0;o1eP2h^Lh0^;W>0?ooo`0606i]S`0302DU=P2h
^Lh0^;W>00D0^;W>00H0_l7F06]eS`3Lg^D0g=kU06]eS`2o`MH20;RicP03
0?ooo`0U9CH0^;W>00L0^;W>00<0oooo02DU=P2h^Lh00P2h^Lh02@2o`MH0
JgF?0=cNiP3Lg^D0YSU40<eIGP3AFUh0e5eQ05<U80030?ooo`D0eUmS0`3o
ool01@1C9B00e5eQ0=5JGP3=FEh0YSU40080g=kU00<0g=kV0=cNi@3Gf=h0
0@1VIWh0000406IVOP3Ee]d0eMSP0=KHh@80eMSP00T0000008b<S03WinL0
inOW0>NeQ03FFP00eX@00?o>003>H`000P3NJ`001@3_]H`0kno_0>o_k`3_
knl000000080eMSQ00@0eMOP0=KHh03Ff>40e]OQ6@3Fen0<0=KHh00506]e
S`33aMT0_;gA0;bmd@3oool01`0U9CH70;bmd@060<?5f@1[MHl0eMSQ0=GH
h@1[MHl0`lGI0P2l_M400`3oool09BDf0;bmd@070;bmd@030?ooo`0U9CH0
_;gA0080_;gA00D0`lGI06]eS`3Fen00eMOQ0:HiA0020=EMH0030=QPH@3I
HF80AQhJ00<0oooo0`3IHF830?ooo`0304HN6P3IHF80f61Q0080eEeP00H0
YSU40=KHh03Ef>40eMOP0=GHh@3Ee]d106IVOP0000L0IVIn0=;Dg@3?d]`0
d=;L0=3Bg@3@d]`0000000<0inOW00`0imk>0<I:003gcP00kjd00>ne003>
J`00aUX00<I[003NS4X0ijD00>oWcP0000030=3Bg0030<oBg03@d]`0cm;L
01T0d=;L303?d]d00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L
0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP030?ooo`0U
9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0fF5R00<0
g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3LIFD0g6EU
0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IVOP0001`0
IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH0>nm003g
aP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl000000<_=
f03;cMT0b/gI0<_>f03:cMP0blgH6@3;cMT<0<_>f@0306]eS`3;c=h0b<[I
00P0b<[I00<0b<WI0<S:f@38b]T00`38b]T01038bMT0b<[I0<_<gP1[MHl2
0<_=f00606]eS`3;c=h0b<[I0<S:f@3oool09BDf1@38b]T04@38bMT0b<[I
0<S:f@3oool09BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0
eemO0=]TI03PIfD0h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3oool02P16
7QX0gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0YSU40<[>f03:c]T20<_=f@40
d=;K0@1VIWh0000306IVOP3?cmX0aLSD00<0aLSD00H000000<K6aP3Wg]H0
cW/00>N]003_]@020>NU00030=JD003>L`00eY@00080mlH00P3gmoL01000
0000aLSD0<G7e035am@30<G7eAT0a<OE3034b=@00`1[MHl0d=7P0<_;g00@
0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3oool09BDf
0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]eS`35am@0
a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo04HN6P05
0>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD0@35amD10<o?fP40IVIn0000
101VIWh0c<kJ0<;4dP31a=420<74dP060000003WinL0inOW0>OWi`3FQ000
kkD00P3WY@00203FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL000000`31
a=800`32a=40`LCB0<74dP0I0<74d@`0`LCB00<0JgF?0=?ChP3?d=d0403?
d=d01P3Cdn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M00<0oooo02DU=P3?
d=d01`3?d=d00`3oool09BDf0<o@g@020<o@g@070=?ChP1[MHl0`/CB0<74
d@2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203QJFD0ffAT0:HiA031
a=80`/CA0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:c=P0_/3?0;g0c`80
_/3>00D0000009bLW03WinL0imkF0=J<00020=jD00040=Ik0036H`00_D80
0>nU0080mjd000P0mkD00?o>BP000000_/3>0;k0c`2n`<h0_/3?0;g0cQX0
_/3>302m`<h00`1[MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0
cP1[MHl0e]KT0P3Cdn000`3oool09BDf0?ooo`080?ooo`0;02DU=P3Cdn00
dm?P0=?Ch03Fe^@0JgF?0;k0c`2n`<h0YSU40>1VI@3QJVX0103SK6`30?oo
o`0404HN6P3oool0oooo0?ooo`@0hfa/00@0hFYZ0>1VI@2V>D@0_L3?0P2n
`<l10;k0cP40b/cH0@1VIWh0000706IVOP39b]P0][S80;Vlb`2j_</0^[c<
000000020>o_k`0C0=JL003FS000gY@00=J4003_Y@00gX`00;eJ003FL`00
ki`00?O_i`3gmoL0oooo0000002i_<`0^[_<0;Vlb`2j_</0^Kc<0;Vlb`0I
0;Vlc0`0^[c<00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?0;Zlb`2j
_</0JgF?0=SHi@80dm?Q00<0oooo06i]S`1^KHl0201^KHl03P0U9CH0dm?Q
0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<0:HiA03PJFP0hFe/0>AaK@3TLFl0
i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^00T0i75]0>5]K03P
JFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039b]P00@1VIWh0000906IVOP37bML0
];K70;Jhb02f^<T0][W900000024Q8@0inON0080kno_00L0aV/00?O6003_
]@00ki`00=j<003>J`00ii`000<0moOg00D000000;Jib@2g^<T0][W90;Ni
b@020;JhbAT0]kS9302f^<T0101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV
0`3Hf>D20=SHiP80f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU
0=SHiP3oool02P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0
]kW90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_0>AdK`3T
M6l0AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Ji
b@2d]/L0alWG0@1VIWh0000306IVOP36b=L0];K700<0];K700<000000>o_
k`3_knl00P3_knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe
0?ogm`3oool0000002/0];K700D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cK
i`060=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU
=P0902DU=P<0g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0igEb0>Yf
L`3ZN7H00P3oool00`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo
0>YhMP3ZMW<0igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36
b=L0];K700<0];K700H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`08
0>ND003gilh0moOg0?Ogm`3_imH0moOg0?ooo`00000[0;Bfa`0306]eS`3E
e><0h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP09
0=GDh`1[MHl0];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0
jiR;0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3Y
O7P0jWUc0:HiA0040;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?800<0
/K?800H000000>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0
oooo00<0moOg00<0oooo0000002a/lP0:P2a/lP00`1[MHl0kN_c0>WXl@0@
0>WXl@060>g[l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?
0;6cb02a/lP0YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0
lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V
>D@0102a/lP10<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`030:n^a`050000
002][Jd0moO_0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<000000:n^a`2_
[/L0:@2_[/L00`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^
a`1[MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI25
3@3b^9h20?F@Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn
00000`1VIWh0`<7A0<O7e00n0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo
00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?oo
o`040?_ko03<bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L
]`3jjkL0n^Vf0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0
n]bg0?joY03oWhd0YSU4096HZP<0[:_40@37am@10<31d@40IVIn0000101V
IWh0`<7A0=;Bg`2e]<Tn0:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR
0:BS_P2TXkh00P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0
Y:>n0080Y:>n00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2T
Xkh0]KC90=;Bg`30`M400@1VIWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0
/K34OP2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0
QhNK0=OHhP3lo?`0i>?X0=3@h03:b]X0O02l_<l01P3:b]X0d=3P0>CSj03l
o?`0emSR08N7V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/
jnh0hN;[NP3Gf>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1H
EfP00080F5MX00<0IVIn09FDZ`3AdMh00P3lo?al0?ooo`80o?cl00<0dM7N
09FDZ`1VIWh00P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW_`1k0:RW
_`0409FDZ`28Qid0IVIn06IVOP<0F5MX000505QGJ800IVIn1@1HEfP00001
\
\>"], "Graphics",
  CellLabel->"From In[9]:=",
  Evaluatable->False,
  ImageSize->{138, 244},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"TextPanel"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]=",
  CellTags->"TextPanel"]
}, Open  ]],

Cell[TextData[{
  "In the following example, we take advantage of the fact that not only can \
we bind to events when a hyperlink in HTML text is activated or rolled over \
with the mouse, but we can choose to take any action we want based on the \
URL.  By default, no action will take place with hyperlinks in HTML, but we \
can use the ability of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to open URLs in an external browser and also override the use of URLs to \
provide links that actually open up in the Help Browser instead of an \
external web browser."
}], "Text",
  CellTags->"TextPanel"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<TextPanel\>", \ {\
\[IndentingNewLine]"\<preferredSize\>" \[Rule] 
                Widget["\<Dimension\>", {"\<width\>" \[Rule] 
                      180, "\<height\>" \[Rule] 
                      100}], \[IndentingNewLine]"\<contentType\>"\  \[Rule] \ \
"\<text/html\>", \[IndentingNewLine]"\<editable\>" \[Rule] 
                False, \[IndentingNewLine]"\<text\>" -> "\<<html><body><p><a \
href='http://www.wolfram.com'>Web - Wolfram Research</a><ul><li><a \
href='http://localhost/HelpBrowser/RefGuide/Plot'>Help Browser - \
Plot</a><li><a href='http://localhost/HelpBrowser/RefGuide/Map'>Help Browser \
- Map</a></ul></body></html>\>", \
\[IndentingNewLine]BindEvent["\<hyperlinkUpdate\>", \
\[IndentingNewLine]Script[\[IndentingNewLine]\(If[\ 
                      StringMatchQ[\ 
                        InvokeMethod[{PropertyValue[{"\<#\>", \
"\<eventType\>"}], "\<toString\>"}], \ "\<Activated\>", 
                        IgnoreCase \[Rule] 
                          True], \
\[IndentingNewLine]\[IndentingNewLine]prefixString = \
"\<http://localhost/HelpBrowser/\>"; \[IndentingNewLine]urlString\  = \ 
                        InvokeMethod[{PropertyValue[{"\<#\>", \ "\<URL\>"}], \
\ "\<toExternalForm\>"}]; \[IndentingNewLine]\[IndentingNewLine]If[\ 
                        StringMatchQ[urlString, 
                          prefixString\  <> \ "\<*\>"], \
\[IndentingNewLine]{category, \ item}\  = 
                          ToExpression["\<{\>"\  \
<> \[IndentingNewLine]StringReplace[\ 
                                StringDrop[urlString, \ 
                                  StringLength[
                                    prefixString]], \ "\</\>" -> "\<,\>"] <> \
"\<}\>"]; \[IndentingNewLine]FrontEndExecute[{FrontEnd`HelpBrowserLookup[
                              category, \ 
                              item]}], \
\[IndentingNewLine]FrontEndExecute[{FrontEnd`NotebookLocate[{URL[urlString], 
                                None}]}]\[IndentingNewLine]]\
\[IndentingNewLine]];\)\[IndentingNewLine]]\[IndentingNewLine]]\
\[IndentingNewLine]}]\ \[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[10]:=",
  CellTags->"TextPanel"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"TextPanel"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002l0000QR000`400?l0
0000o`00003o_01VIWh0000306IVOP3ko?d0nocm0;P0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0;L0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
]P1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTL0oooo
0`000?mG0?ooo`<0003o403oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn=@3ooomd0000o`/0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTP0oooo00<0003o0?ooo`3oool0
E`3oool00`000?l0oooo0?ooo`0?0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh[0?ooo`800000203oool30000o`<0oooo
0`000?l20?ooo`<0003o00L0oooo0000o`000?l0003o0?ooo`000?l0oooo
0080003o1P3oool60000o`80oooo0`000?l40?ooo`<0003o1@3oool01@00
0?l0oooo0?ooo`3oool0003o00@0oooo0`000?l40?ooo`<0003o00@0oooo
0000o`000?l0003o3`3oool30000o`<0oooo00<0003o0?ooo`3oool00`00
0?l00`3oool0003o0000o`030000o`030?ooo`000?l0oooo0080003o3P3o
ool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn:@3o
ool6000000L0oooo00<0003o0?ooo`3oool00`3oool010000?l0oooo0?oo
o`000?l30?ooo`030000o`3oool0003o0080oooo0P000?l20?ooo`030000
o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00P3oool010000?l0oooo
0?ooo`000?l40?ooo`050000o`3oool0oooo0?ooo`000?l00`3oool20000
o`80oooo0P000?l40?ooo`040000o`3oool0oooo0000o`80oooo00L0003o
0?ooo`3oool0oooo0000o`3oool0003o0140oooo00@0003o0?ooo`3oool0
oooo0P000?l30?ooo`030000o`3oool0003o00<0oooo00<0003o0?ooo`3o
ool00P000?l20?ooo`030000o`3oool0oooo00/0oooo00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0oooo1P0000070?ooo`03
0000o`3oool0oooo00<0oooo00@0003o0?ooo`3oool0003o1@3oool01000
0?l0oooo0?ooo`000?l30?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool00P3oool010000?l0oooo0?ooo`000?l40?ooo`050000o`3o
ool0oooo0?ooo`000?l00`3oool01`000?l0oooo0000o`3oool0003o0?oo
o`000?l01P3oool010000?l0oooo0?ooo`000?l50?ooo`030000o`3oool0
oooo00l0oooo00L0003o0?ooo`3oool0oooo0000o`3oool0003o0080oooo
00<0003o0?ooo`000?l00`3oool010000?l0oooo0?ooo`000?l30?ooo`03
0000o`3oool0oooo00/0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVORP0oooo200000060?ooo`030000o`3oool0oooo00<0
oooo00@0003o0?ooo`3oool0003o1@3oool010000?l0oooo0?ooo`000?l3
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool00P3oool0
10000?l0oooo0?ooo`000?l40?ooo`050000o`3oool0oooo0?ooo`000?l0
0`3oool01`000?l0oooo0000o`3oool0003o0?ooo`000?l0103oool20000
o`<0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`060?oo
o`<0003o1P3oool010000?l0oooo0?ooo`000?l20?ooo`040000o`3oool0
oooo0000o`80oooo10000?l20?ooo`050000o`3oool0oooo0?ooo`000?l0
3@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
:03oool8000000H0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo
0?ooo`050000o`050?ooo`000?l0oooo0?ooo`000?l00`3oool00`000?l0
oooo0?ooo`040?ooo`030000o`3oool0oooo0080oooo00@0003o0?ooo`3o
ool0003o103oool01@000?l0oooo0?ooo`3oool0003o0080oooo00D0003o
0?ooo`3oool0oooo0000o`030?ooo`040000o`3oool0oooo0000o`D0oooo
1@000?l00`3oool0003o0?ooo`0@0?ooo`040000o`3oool0oooo0000o`80
oooo00@0003o0?ooo`3oool0003o1@3oool010000?l0oooo0?ooo`000?l3
0?ooo`030000o`3oool0oooo00/0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVORT0oooo1P0000070?ooo`L0003o0P3oool0
20000?l0oooo0?ooo`3oool0003o0?ooo`000?l0oooo0`000?l20?ooo`03
0000o`3oool0oooo00@0oooo1@000?l20?ooo`<0003o0`3oool01@000?l0
oooo0?ooo`3oool0003o0080oooo00D0003o0?ooo`3oool0oooo0000o`03
0?ooo`040000o`3oool0oooo0000o`80oooo00@0003o0?ooo`3oool0003o
0`3oool40000oa00oooo00@0003o0?ooo`3oool0003o0`3oool01@000?l0
oooo0000o`3oool0003o00<0oooo00<0003o0?ooo`000?l00P000?l20?oo
o`030000o`3oool0oooo00/0oooo00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVORT0oooo1P0000070?ooo`030000o`3oool0oooo
00<0oooo00@0003o0?ooo`3oool0oooo0`000?l20?ooo`050000o`3oool0
oooo0000o`3oool00P000?l70?ooo`050000o`3oool0oooo0?ooo`000?l0
0`3oool010000?l0oooo0000o`000?l20?ooo`<0003o0P3oool30000o`05
0?ooo`000?l0003o0000o`3oool00`000?l20?ooo`<0003o0`3oool30000
o`80oooo00@0003o0?ooo`000?l0003o3P3oool00`000?l0oooo0000o`04
0?ooo`030000o`3oool0003o0080oooo0`000?l30?ooo`040000o`3oool0
003o0000o`h0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOR/0oooo0P0000090?ooo`030000o`3oool0oooo00<0oooo00<0
003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`0;0?ooo`050000o`3o
ool0oooo0?ooo`000?l0>03oool00`000?l0oooo0000o`040?ooo`030000
o`3oool0003o01X0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOSH0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo
0?ooo`050?ooo`80003o3@3oool01@000?l0oooo0?ooo`3oool0003o03P0
oooo0P000?l60?ooo`80003o6P3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn=@3oool30000o`<0oooo0`000?l70?ooo`03
0000o`3oool0oooo00X0oooo1@000?lh0?ooo`<0003o1P3oool30000oaT0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[@0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTL0
oooo0`000?mZ0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWhe0?ooog40003o3P3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInB03oool00`000?l0oooo0?ooo`1Y0?ooo`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh[0?ooo`80
0000203oool30000o`<0oooo0`000?l20?ooo`<0003o00L0oooo0000o`00
0?l0003o0?ooo`000?l0oooo0080003o1P3oool60000o`80oooo0`000?l4
0?ooo`<0003o1@3oool01@000?l0oooo0?ooo`3oool0003o00@0oooo0`00
0?l40?ooo`<0003o00@0oooo0000o`000?l0003o3`3oool30000o`D0oooo
0`000?l20?ooo`<0003o0`3oool20000oa00oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0oooo1P0000070?ooo`030000
o`3oool0oooo00<0oooo00@0003o0?ooo`3oool0003o0`3oool00`000?l0
oooo0000o`020?ooo`80003o0P3oool00`000?l0oooo0?ooo`040?ooo`03
0000o`3oool0oooo0080oooo00@0003o0?ooo`3oool0003o103oool01@00
0?l0oooo0?ooo`3oool0003o00<0oooo0P000?l20?ooo`80003o103oool0
10000?l0oooo0?ooo`000?l20?ooo`070000o`3oool0oooo0?ooo`000?l0
oooo0000o`0A0?ooo`030000o`3oool0oooo00D0oooo00@0003o0?ooo`3o
ool0003o0`3oool01P000?l0oooo0?ooo`000?l0oooo0000o`l0oooo00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0oooo1P00
00070?ooo`030000o`3oool0oooo00<0oooo00@0003o0?ooo`3oool0003o
1@3oool010000?l0oooo0?ooo`000?l30?ooo`030000o`3oool0oooo00@0
oooo00<0003o0?ooo`3oool00P3oool010000?l0oooo0?ooo`000?l40?oo
o`050000o`3oool0oooo0?ooo`000?l00`3oool01`000?l0oooo0000o`3o
ool0003o0?ooo`000?l01P3oool010000?l0oooo0?ooo`000?l50?ooo`03
0000o`3oool0oooo00l0oooo00<0003o0?ooo`3oool01@3oool010000?l0
oooo0?ooo`000?l30?ooo`040000o`3oool0oooo0000oa40oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVORP0oooo20000006
0?ooo`030000o`3oool0oooo00<0oooo00@0003o0?ooo`3oool0003o1@3o
ool010000?l0oooo0?ooo`000?l30?ooo`030000o`3oool0oooo00@0oooo
00<0003o0?ooo`3oool00P3oool010000?l0oooo0?ooo`000?l40?ooo`05
0000o`3oool0oooo0?ooo`000?l00`3oool01`000?l0oooo0000o`3oool0
003o0?ooo`000?l0103oool20000o`<0oooo00<0003o0?ooo`3oool00`3o
ool00`000?l0oooo0?ooo`060?ooo`<0003o1P3oool00`000?l0oooo0?oo
o`050?ooo`040000o`3oool0oooo0000o`<0oooo00@0003o0?ooo`3oool0
003o4@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn:03oool8000000H0oooo00<0003o0?ooo`3oool00`3oool00`000?l0
oooo0?ooo`050000o`050?ooo`000?l0oooo0?ooo`000?l00`3oool00`00
0?l0oooo0?ooo`040?ooo`030000o`3oool0oooo0080oooo00@0003o0?oo
o`3oool0003o103oool01@000?l0oooo0?ooo`3oool0003o0080oooo00D0
003o0?ooo`3oool0oooo0000o`030?ooo`040000o`3oool0oooo0000o`D0
oooo1@000?l00`3oool0003o0?ooo`0@0?ooo`D0003o0`3oool010000?l0
oooo0?ooo`000?l30?ooo`040000o`3oool0oooo0000oa40oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVORT0oooo1P000007
0?ooo`L0003o0P3oool020000?l0oooo0?ooo`3oool0003o0?ooo`000?l0
oooo0`000?l20?ooo`030000o`3oool0oooo00@0oooo1@000?l20?ooo`<0
003o0`3oool01@000?l0oooo0?ooo`3oool0003o0080oooo00D0003o0?oo
o`3oool0oooo0000o`030?ooo`040000o`3oool0oooo0000o`80oooo00@0
003o0?ooo`3oool0003o0`3oool40000oa00oooo00<0003o0?ooo`3oool0
0P3oool010000?l0oooo0?ooo`000?l20?ooo`050000o`3oool0oooo0?oo
o`000?l00P3oool00`000?l0oooo0?ooo`0?0?ooo`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWhY0?ooo`H000001`3oool00`00
0?l0oooo0?ooo`030?ooo`040000o`3oool0oooo0?ooo`<0003o0P3oool0
1@000?l0oooo0?ooo`000?l0oooo0080003o1`3oool01@000?l0oooo0?oo
o`3oool0003o00<0oooo00@0003o0?ooo`000?l0003o0P3oool30000o`80
oooo0`000?l01@3oool0003o0000o`000?l0oooo00<0003o0P3oool30000
o`<0oooo0`000?l20?ooo`040000o`3oool0003o0000o`h0oooo00<0003o
0?ooo`3oool00P3oool010000?l0oooo0?ooo`000?l30?ooo`<0003o0P3o
ool30000oa00oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOR/0oooo0P0000090?ooo`030000o`3oool0oooo00<0oooo00<0
003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`0;0?ooo`050000o`3o
ool0oooo0?ooo`000?l0>03oool00`000?l0oooo0?ooo`020?ooo`040000
o`3oool0oooo0000o`T0oooo00<0003o0?ooo`3oool03`3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn=P3oool00`000?l0
oooo0?ooo`030?ooo`030000o`3oool0oooo00D0oooo0P000?l=0?ooo`05
0000o`3oool0oooo0?ooo`000?l0>03oool00`000?l0oooo0?ooo`020?oo
o`040000o`3oool0003o0000o`T0oooo00<0003o0?ooo`3oool03`3oool0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn=@3oool3
0000o`<0oooo0`000?l70?ooo`030000o`3oool0oooo00X0oooo1@000?lh
0?ooo`H0003o0`3oool00`000?l0oooo0?ooo`0I0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjd0?ooo`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh30?oooi80003o7`3oool0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1P3oool0
0`000?l0oooo0?ooo`020?ooo`030000o`3oool0oooo00@0oooo0`000?l3
0?ooo`<0003o4P3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0
oooo00@0oooo0`000?l20?ooo`<0003o00D0oooo0000o`000?l0003o0?oo
o`030000o`<0oooo20000?l01@3oool0003o0000o`000?l0oooo00<0003o
103oool30000o`<0oooo0`000?l20?ooo`<0003o0P3oool30000o`@0oooo
0`000?l20?ooo`P0003o103oool30000o`80oooo0`000?l0103oool0003o
0000o`000?lP0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWh60?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`3o
ool00`3oool01`000?l0oooo0?ooo`3oool0003o0?ooo`000?l00`3oool0
0`000?l0oooo0?ooo`0?0?ooo`030000o`3oool0oooo0080oooo00<0003o
0?ooo`3oool00`3oool01@000?l0oooo0?ooo`3oool0003o0080oooo00D0
003o0?ooo`3oool0oooo0000o`030?ooo`050000o`3oool0oooo0?ooo`00
0?l00`3oool010000?l0oooo0?ooo`000?l30?ooo`050000o`3oool0oooo
0?ooo`000?l01P3oool00`000?l0oooo0?ooo`020?ooo`050000o`3oool0
oooo0?ooo`000?l00`3oool00`000?l0oooo0000o`020?ooo`040000o`3o
ool0oooo0000o`<0oooo0P000?l30?ooo`040000o`3oool0oooo0000o`@0
oooo00D0003o0?ooo`3oool0oooo0000o`020?ooo`050000o`3oool0oooo
0?ooo`000?l08@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn1@3oool00`000?l0oooo0000o`020?ooo`030000o`3oool0
003o00@0oooo00<0003o0?ooo`3oool00`3oool01@000?l0oooo0?ooo`3o
ool0003o0100oooo00<0003o0?ooo`000?l00P3oool00`000?l0oooo0000
o`040?ooo`050000o`3oool0oooo0?ooo`000?l00P3oool01@000?l0oooo
0?ooo`3oool0003o00<0oooo00D0003o0?ooo`3oool0oooo0000o`030?oo
o`040000o`3oool0oooo0000o`<0oooo00D0003o0?ooo`3oool0oooo0000
o`060?ooo`050000o`3oool0oooo0?ooo`000?l0103oool00`000?l0oooo
0?ooo`060?ooo`040000o`3oool0oooo0000o`@0oooo00D0003o0?ooo`3o
ool0oooo0000o`020?ooo`030000o`3oool0oooo0080oooo00<0003o0?oo
o`3oool0103oool01@000?l0oooo0?ooo`3oool0003o0240oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPD0oooo00<0003o
0?ooo`000?l00P3oool00`000?l0oooo0000o`040?ooo`030000o`3oool0
oooo00<0oooo00D0003o0?ooo`3oool0oooo0000o`060?ooo`<0003o1`3o
ool00`000?l0oooo0000o`020?ooo`030000o`3oool0003o00@0oooo00D0
003o0?ooo`3oool0oooo0000o`020?ooo`050000o`3oool0oooo0?ooo`00
0?l00`3oool00`000?l0oooo0?ooo`020?ooo`@0003o0P3oool01@000?l0
oooo0?ooo`3oool0003o00<0oooo00<0003o0?ooo`3oool0103oool00`00
0?l0oooo0?ooo`020000o`@0oooo00<0003o0?ooo`3oool0103oool20000
o`<0oooo00<0003o0?ooo`3oool00`3oool40000o`80oooo00<0003o0?oo
o`3oool00P3oool00`000?l0oooo0?ooo`040?ooo`050000o`3oool0oooo
0?ooo`000?l08@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn1@3oool01P000?l0oooo0?ooo`000?l0oooo0000o`80oooo
00@0003o0?ooo`3oool0oooo1@000?l00`3oool0003o0?ooo`020?ooo`03
0000o`3oool0oooo00h0oooo00H0003o0?ooo`3oool0003o0?ooo`000?l2
0?ooo`050000o`3oool0oooo0?ooo`000?l00`3oool010000?l0oooo0?oo
o`000?l30?ooo`050000o`3oool0oooo0?ooo`000?l01`3oool010000?l0
oooo0?ooo`000?l30?ooo`050000o`3oool0oooo0?ooo`000?l01P3oool0
10000?l0oooo0?ooo`000?l50?ooo`D0003o00<0oooo0000o`3oool0103o
ool50000o`@0oooo00@0003o0?ooo`3oool0003o103oool00`000?l0oooo
0?ooo`040?ooo`050000o`3oool0oooo0?ooo`000?l08@3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@3oool01P000?l0
oooo0?ooo`000?l0oooo0000o`80oooo00D0003o0?ooo`3oool0oooo0000
o`030?ooo`040000o`3oool0003o0000o`80oooo00<0003o0?ooo`3oool0
3P3oool01P000?l0oooo0?ooo`000?l0oooo0000o`80oooo00D0003o0?oo
o`3oool0oooo0000o`030?ooo`040000o`3oool0oooo0000o`<0oooo00<0
003o0?ooo`3oool00`000?l20?ooo`060000o`3oool0oooo0?ooo`000?l0
oooo0`000?l20?ooo`80003o0P3oool00`000?l0oooo0?ooo`040?ooo`D0
003o103oool01`000?l0oooo0?ooo`3oool0003o0?ooo`000?l00P3oool0
10000?l0oooo0?ooo`000?l30?ooo`80003o0`3oool00`000?l0oooo0000
o`020000o`<0oooo00D0003o0?ooo`3oool0oooo0000o`020?ooo`80003o
0P3oool00`000?l0oooo0?ooo`0O0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh40?ooo`030000o`3oool0oooo0080oooo
00D0003o0?ooo`3oool0oooo0000o`040?ooo`<0003o0P3oool010000?l0
oooo0000o`000?l@0?ooo`030000o`3oool0oooo0080oooo00D0003o0?oo
o`3oool0oooo0000o`040?ooo`<0003o0`3oool00`000?l0oooo0?ooo`04
0000o`030?ooo`000?l0oooo0080003o00@0oooo0000o`000?l0003o0`3o
ool010000?l0oooo0000o`000?l20?ooo`80003o1`3oool00`000?l0oooo
0?ooo`020?ooo`030000o`3oool0oooo0080oooo0`000?l30?ooo`<0003o
0`3oool30000o`80oooo0`000?l30?ooo`040000o`3oool0003o0000o`80
oooo0`000?l30?ooo`040000o`3oool0003o0000ob80oooo00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0oooo00<0003o0?oo
o`3oool00P3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0oooo
00H0oooo00<0003o0?ooo`3oool04@3oool00`000?l0oooo0?ooo`020?oo
o`030000o`3oool0oooo0080oooo00<0003o0?ooo`3oool01`3oool01@00
0?l0oooo0?ooo`3oool0003o01d0oooo00<0003o0?ooo`3oool00P3oool0
0`000?l0oooo0?ooo`0U0?ooo`030000o`3oool0oooo02<0oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0oooo00<0003o
0?ooo`3oool00P3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0
oooo00D0oooo0P000?lC0?ooo`030000o`3oool0oooo0080oooo00<0003o
0?ooo`3oool00P3oool00`000?l0oooo0?ooo`060?ooo`80003o0`3oool0
10000?l0oooo0?ooo`000?lJ0?ooo`030000o`3oool0oooo0080oooo00<0
003o0?ooo`3oool0903oool20000obD0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOP<0oooo0`000?l20?ooo`<0003o0P3o
ool30000o`L0oooo00<0003o0?ooo`3oool0403oool30000o`80oooo0`00
0?l20?ooo`<0003o203oool00`000?l0oooo0?ooo`020?ooo`<0003o6@3o
ool60000obP0oooo00<0003o0?ooo`3oool08`3oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn]03oool00`1VIWh0Z:Vk0?_l
o@0106IVOP0000<0IVIn0?Ogn@2HV:L0]P1gMi8109RHY`40moOi0@1VIWh0
000306IVOP3gmoT0_;g=0;L0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3T
hn<0]`3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`1`0?ooo`030>CS
h`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0
i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[
MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W
>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F
06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0
o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080
o?cl00@0o?cm0?clo03knod0o?cm:P3lno`Y0?_lo0@0nocm00<0W:Bi06]e
S`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0
JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?cl
o03lnod0nocm0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT0
2`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi
0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0Y
0?OgnBT0m_Oi103gmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0
moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:Xl
E@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0
moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@0000
00060?7am03`l_D0lO7d0?7bm03`l_@0lO7dD`3`lOD40?3am00306]eS`2b
]M00YjS20100YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P05
0;:ed01[MHl0l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eI
GP040<]DF@32DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0
000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3W
inL00`3W_H@0inOW0>OWi`030>OWi`80kno_00@000000>[[l03Zjo00j^__
0P3Zjo000`3Zjnl0j^_`0>[[l00X0>[[l2T0j^c`103Zjnl0101[MHl0][WA
0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[
MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Ji
d@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO
0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0
IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080
inOW00<0aV<00>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ
0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0X0>?UjbT0hnCZ103SiNX0
1@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b
//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U
9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@
Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:Hi
A03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0
g=kV00D000000>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW
0>ONaP3_S1000`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H0
E`3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h
^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo
02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0
g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`05
05<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IV
OP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0
ikF40=IJ003FQ000olh00<iS00020=i[00050>neS03_knl0kno_0>o_k`00
00000P3Ef>40103Een00e]SP0=KHh@3Fen4Z0=KGh2T0e]SP103Ef>401@1[
MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?0=GHh@3E
f>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M401`2l_M400`3oool09BDf
0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V>D@00P3EGF000`3HH640
fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@020=EMH006
0:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0000706IVOP3Be=d0cm;L
0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36BP00mlh00>n]003_]@00
cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@d]`00`3?d]`0d=;L0<oB
g00Z0=3Bg2T0cm;M103@d]`00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[
MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP03
0?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0
fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3L
IFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IV
OP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH
0>nm003gaP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl0
00000<_=f03;cMT0b/gI0<_>f03:cMP0blgH:P3;cMTY0<_>f@@0blgH00<0
JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38
b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:
f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;
c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?oo
o`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH
0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P00
0000a/K60>ONeP3>N`00ijd00>ne0080ijD000<0eY@00<ic003FU0000P3g
aP020?Ogm`0400000035b=@0aLOD0<G7e0<0aLOE:P34amDY0<C8e0@0a<OD
00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3A
h080bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;
g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3o
ool0oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040
aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000
inOW0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm
003_knl0moOg000000<0`LCB00<0`/CA0<74dP31a=80:P31a=4Y0<74dP@0
`/CB00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?
0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@02
0<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo
1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh0
000406IVOP3:c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<
00020=jD00040=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>BP000000
_/3>0;k0c`2n`<h0_/3?0;g0cR/0_/3>:@2m`<h40;k0cP0306]eS`3Fe^@0
dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?oo
o`0U9CH0oooo00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?
0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo
103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP00
00L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<
003NU000eX@00>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3oool00000
0;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;02X0^Kc<:@2j_<`40;Zlb`0306]e
S`3Hf>D0dm?Q0100dm?Q00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?C
h@030?ooo`1^KHl0KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[
MHl0^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ
0>A`KP167QX00`3oool20>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<
0;Vlb`2f^<P0bL[H0040IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Ji
b@000000Q8B40>OWgP020>o_k`070<I[003gaP00kkD00>nL003NS000cV/0
0>NL00030?Ogm`050000002f^LT0]kS90;Jib@2g^LT00P2f^<TZ0;NhbBT0
][S9102g^<T0101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SH
iP80f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool0
2P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03T
KVd0i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0
oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG
0@1VIWh0000306IVOP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_
knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool0
000005d0];K700D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[
MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0
g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3o
ool00`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0
igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0
];K700H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0
moOg0?Ogm`3_imH0moOg0?ooo`00001M0;Bfa`0306]eS`3Ee><0h=oZ0100
h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0
];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]
UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:Hi
A0040;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H00000
0>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg
00<0oooo0000002a/lP0G02a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[
l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0
YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/
]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP1
0<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_
0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L0F`2_[/L0
0`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S
4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@
Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0
`<7A0<O7e01`0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;
g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<
bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf
0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03o
Whd0YSU4096HZP<0[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;B
g`2e]<U`0:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh0
0P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n
00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;B
g`30`M400@1VIWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34/02XYkl0
1@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3l
o?`0i>?X0=3@h03:b]X0[P2l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7
V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[[03G
f>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX
00<0IVIn09FDZ`3AdMh00P3lo?b^0?ooo`80o?cl00<0dM7N09FDZ`1VIWh0
0P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW_`2]0:RW_`0409FDZ`28
Qid0IVIn06IVOP<0F5MX000505QGJ;80IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[11]:=",
  Evaluatable->False,
  ImageSize->{188, 134},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"TextPanel"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]=",
  CellTags->"TextPanel"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Widget[\"Icon\"]
Widget[\"ImageLabel\"]\
\>", "ObjectName",
  CellTags->"Images"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"path\" \[Rule] \"relative filesystem path\" | \"URL path\"\n", 
    "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"data\" \[Rule] ", "Program"],
  StyleBox["\"byte per character string data\" | ", "Program",
    FontSlant->"Italic"],
  StyleBox["Script[ExportString[\[Ellipsis], \"", "Program"],
  StyleBox["format", "Program",
    FontSlant->"Italic"],
  StyleBox["\", ", "Program"],
  StyleBox["options", "Program",
    FontSlant->"Italic"],
  StyleBox["]]", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"Images"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"Images"],

Cell[BoxData[
    \(\(Needs["\<GUIKit`\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Images"],

Cell[BoxData[
    \(\(ref\  = \ 
        GUIRun[\[IndentingNewLine]Widget["\<Button\>", \ \
{\[IndentingNewLine]"\<text\>" -> "\<Stop\>", \ \[IndentingNewLine]"\<icon\>" \
\[Rule] Widget["\<Icon\>", {"\<path\>" -> "\<Wolfram/Example/Stop16.gif\>"}]\
\[IndentingNewLine]\ \ }\ ]\ \[IndentingNewLine]];\)\)], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Images"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Images"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000>b000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3Qh>@0
i^GX0>c[kP3`l?80l_;d03D0lo?d<P3hmoP20??cm0080??cm@3dm?D0mOGf
0?Ccm@3Ui>P0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn
0=kLg`3Th^00NiN]02EGQF/003ad00L05den06^;YP3blNh0l_7c06IVOP2X
ZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0f]SI06J5X@0WCHD0
CGg1K01YP^h01P0WCHD0JXZT0>o_l@1VIWh0Z:Vk0?_lo@40IVIn00001P1V
IWh0nocm0:RY^`1VIWh0f=GF01M=OVl0RJgT00D05den0>_Zk@1VIWh0Z:Vk
0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0RJgT0?oo
of/0cLcO00L0oooo08V]i000?7@0j>OZ06IVOP2XZK/0nocm0040IVIn0000
201VIWh0nocm0:RY^`1VIWh0fMGE000lM02;[N@0ooooJ`3BdN@01`3oool0
RjoU000lM03Wi^T0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk
06IVOP3IeMD003ad08j_iP3ooom40=KGi`030000003FenL0e]OW02@0e]OW
00L0oooo08f_i@00?7@0inKY06IVOP2XZK/0nocm0040IVIn0000201VIWh0
nocm0:RY^`1VIWh0fMGE000lM02A/NL0oooo8`3If^L;0?oooaH0fM[W00<0
00000=WJi`3If^L0903If^L01`3oool0TK7V000lM03Wi^T0IVIn0:RY^`3k
o?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad09Bdj03ooolR
0=WJi`0303<cIP1VIYT0<c=V00P0<c=V00<0oooo0=WJi`3If^L01@3If^L4
00000080fM[W0P0000020=WJi`<000000P3If^L010000000fM[W00000000
000S0=WJi`070?ooo`2E]>P003ad0>OVj@1VIWh0Z:Vk0?_lo@0106IVOP00
00P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0V;SZ0?ooob80g]o/00`0<c=V
0<c<o`2d]=X0VYZo0;BdfP2FU[`0WIc307AdVP2?SkD0M7BJ03<cIP3oool6
0=kOk0030000003Ngn`0g]o/0080g]o/00<000000=kOk00000000P3Ngn`0
1P000000g]o/0=kOk03Ngn`000000=kOk08000000P3Ngn`00`000000g]o/
0=kOk00P0=kOk0070?ooo`2H^>T003ad0>OVj@1VIWh0Z:Vk0?_lo@0106IV
OP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0W;_Z0?ooob80hnG`00`0
<c=V0<c<o`2FU[`0];CJ09ZJ_`2d]=X0Shne09JF_01dM9X0Shne03<cIP3o
ool;0>?Ul0030000003SiO0000000080hnG`00L000000>?Ul03SiO00hnG`
0000003SiO00000000<0hnG`00<000000>?Ul03SiO00803SiO001`3oool0
W;_[000lM03Wi^T0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk
06IVOP3IeMD003ad09bkjP3ooolR0>?Ul00<03<cIP3<c?l0WIc309JF_02d
]=X0VYZo0;BdfP2?SkD0UYJl07AdVP0c<fH0oooo2@3SiO0200000080hnG`
00@000000>?Ul03SiO0000000`3SiO000`000000hnG`000000030>?Ul003
0000003SiO00hnG`0200hnG`00L0oooo09bkj`00?7@0inKY06IVOP2XZK/0
nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM02P_^`0oooo
8P3YjoD0300c<fH0c<co07emX`2WYld0UYJl0;BdfP2MW<<0[joE08N6[02F
U[`0<c=V0?ooo`L0jN_e0P0000040>W[m@040000003YjoD0jN_e000000<0
jN_e00@000000>W[m@00000000000P3YjoD00`000000jN_e0>W[m@0P0>W[
m@070?ooo`2Q_^`003ad0>OVj@1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn
0?_lo@2XZK/0IVIn0=WEe@00?7@0YL7]0?ooob80l?7l00`0<c=V0<c<o`2?
SkD0OGfS0:NWc@2JV[l0/K7G09fL``2_[mD0QhJ/03<cIP3oool60?3ao003
0000003`lO`0l?7l00<0l?7l0`0000020?3ao0<000000P3`lO`010000000
l?7l00000000000S0?3ao0070?ooo`2U`^h003ad0>OVj@1VIWh0Z:Vk0?_l
o@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0YL7]0?ooob80
l?7l00`0<c=V0<c<o`1dM9X0Shne07emX`2_[mD0VYZo0;BdfP2MW<<0[joE
03<cIP3oool60?3ao0030000003`lO`0l?7l0080l?7l00<000000?3ao000
0000;`3`lO`01`3oool0YL;^000lM03Wi^T0IVIn0:RY^`3ko?d00@1VIWh0
000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0:W5k`3ooolR0?Ceo@0<03<c
IP3<c?l0Shne07AdVP2?SkD0QhJ/0:n_e@2JV[l0];CJ09fL``0c<fH0oooo
1`3dmOd400000080m?Gm00<000000?Ceo@3dmOd0;@3dmOd01`3oool0ZLG_
000lM03Wi^T0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IV
OP3IeMD003ad0:g8l03ooolR0?Kgo@0<03<cIP3<c?l0M7BJ08n?]@1dM9X0
TI6g08N6[02a/ML0WIc30;BdfP0c<fH0oooo?@3fmod01`3oool0[<O`000l
M03Wi^T0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3I
eMD003ad0;7;lP3ooolR0?Slo@0303<cIP3<c?l0c<co00L0c<co00<0IVJI
0?ooo`3ho?d0?03ho?d01`3oool0/Lcb000lM03Wi^T0IVIn0:RY^`3ko?d0
0@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0;C=l`3ooolR0?gm
o@/0<c=V?P3moOd01`3oool0]Lkc000lM03Wi^T0IVIn0:RY^`3ko?d00@1V
IWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0;O@m03ooom[0?gmo@07
0?ooo`2hd?D003ad0>KVj@1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_l
o@2XZK/0IVIn0=SDe000?7@0^]?e0?ooof/0oOgm00L0oooo0;[CmP00?7@0
iNGX06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0fMGE
02EGQFl0_=Cf00D09EN50>7Qi01VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn
0?_lo@2XZK/0IVIn0=WEe@1iU:T09df506d0c^Oo00H09df507VEZ`3OgN00
IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=[Gf@3Og=P0
NIBY02EGQF/003ad00L05den06J6X@3Pg]X0g=_M06IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0gmgP0=[Gf@3He=@0=`3Gdm@b0=?>
c0<0em?D00L0f=CD0=WEe@3JemT0gmgP06IVOP2XZK/0nocm0040IVIn0000
0`1VIWh0moOi09RHY`1e07MgTP40V9RW0@3gmoT106IVOP0000<0IVIn0?Og
n@2l_Ld0MP2l_Ld10?Ogn@40IVIn00000`1VIWh0moOi0>CSh`1f0>CSh`40
moOi0@1VIWh0000306IVOP3`lO@0oooo02l0oooo00<0i>?S09bT^@1[MHl0
0`1[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?oo
o`3Thn<0W:Bi101[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT^@3T
hn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W>T@0YSU40:LjA02W>T@90:Hi
A00309bT^@3/j^X0oooo00<0oooo0@3`lO@106IVOP0001H0IVIn0>;QhP3k
o?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0o?cm0?clo03lnod0o?cl0?ck
o03lo?`0nocl0?clo03ko?d0o?_l0?clo@3knod0nocl0P3lo?`0103lo?d0
o?cl0?_ko@3lo?dD0?cko080nocl00<0W:Bi06]eS`25RK004025RK001P1[
MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3ko?`0no_l
09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?clo03lnod0nocm0>;QhP01
06IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi0?Ogn03f
moP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0moKh0?Kg
n03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0C0?Ogn@80m_Oi00<0JgF?
08F9/02LW[h0402LW[h01P25RK00JgF?0?Ogn@3gmoT0JgF?08F9/140W9jn
00P0QHV`06]eS`3fmoP0moOh0:HiA02Z?5D0`U9K0<IDFPd0aUEL00T0aUAJ
0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>400@1VIWh0000606IV
OP3NgN40lO7d0?7am03`lO@0l?;d400000001P3alO@0l?;e0?7am03al_@0
l?;d0?7am1H0l?7e00<0JgF?0;:ed02WZ<80402WZ<801P2b]M00JgF?0?3a
m03`lO@0JgF?0;:ed140YjS200D0/[G@06]eS`3`lOD0lO;d0:HiA0020<9B
F`030<]DF@3=FEh0cEUN00/0cEUN00@0beAI0<9BF`32DU/0YSU40P3`lO@0
0`3alO@0l?;d0=kMh@0106IVOP0000L0IVIn0=cKh03Zjo00j^_`0>[/l03Y
jnl000000080inOW0P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0inOW0P3_
knl010000000j^_`0>[[l03Zjnl20>[[l0030>[[k`3Zjo00j^_`0180j^_`
0P3Zk?00101[MHl0][WA0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0
[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?oo
o`80[Jk600<0[:k60;Jid@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0
cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__
0@3Lfn0106IVOP0000@0IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<
0=kNgP3WinL0g]kN0080inOW00<0aV<00>OWi`3WinL00P3WinL01`3_knL0
kno_0>o_k`000000hnCZ0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0B
0>?Uj`80hnCZ00D0JgF?0;bne02b//X0/[;:0?ooo`0606i]S`0302DU=P2b
//X0/[;:00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ06]eS`2l_]@20;:bbP03
0?ooo`0U9CH09BDf00T09BDf0`2b//X01@2l_]@0JgF?0>?Tj`3Si>/0YSU4
0080cEUN00@0d5]P0=ALG`3oool0oooo1`3DG5l20?ooo`0:0=ALG`3@Ff00
cEUN0<eIGP2V>D@0hnCZ0>?UjP3Si>X0hnG[0=WIg`40IVIn00000`1VIWh0
emSN0=cNiP030=cNiP050000003WinL0inOW0>OWi`3We/h00P3WinL01@3>
N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_00L000000=cNiP3Lg^D0g=kU0=cN
iP3Lg^D0g=kV01H0g=kU00D0JgF?0;o1eP2h^Lh0^;W>0?ooo`0606i]S`03
02DU=P2h^Lh0^;W>00D0^;W>00H0_l7F06]eS`3Lg^D0g=kU06]eS`2o`MH2
0;RicP030?ooo`0U9CH0^;W>00L0^;W>00<0oooo02DU=P2h^Lh00P2h^Lh0
2@2o`MH0JgF?0=cNiP3Lg^D0YSU40<eIGP3AFUh0e5eQ05<U80030?ooo`D0
eUmS0`3oool01@1C9B00e5eQ0=5JGP3=FEh0YSU40080g=kU00<0g=kV0=cN
i@3Gf=h00@1VIWh0000406IVOP3Ee]d0eMSP0=KHh@80eMSP00T0000008b<
S03WinL0inOW0>NeQ03FFP00eX@00?o>003>H`000P3NJ`001@3_]H`0kno_
0>o_k`3_knl000000080eMSQ00@0eMOP0=KHh03Ff>40e]OQ503Fen020=KH
h00506]eS`33aMT0_;gA0;bmd@3oool01`0U9CH70;bmd@060<?5f@1[MHl0
eMSQ0=GHh@1[MHl0`lGI0P2l_M400`3oool09BDf0;bmd@070;bmd@030?oo
o`0U9CH0_;gA0080_;gA00D0`lGI06]eS`3Fen00eMOQ0:HiA0020=EMH003
0=QPH@3IHF80AQhJ00<0oooo0`3IHF830?ooo`0304HN6P3IHF80f61Q0080
eEeP00H0YSU40=KHh03Ef>40eMOP0=GHh@3Ee]d106IVOP0000L0IVIn0=;D
g@3?d]`0d=;L0=3Bg@3@d]`0000000<0inOW00`0imk>0<I:003gcP00kjd0
0>ne003>J`00aUX00<I[003NS4X0ijD00>oWcP0000030=3Bg0030<oBg03@
d]`0cm;L01@0d=;L0P3?d]d00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[
MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP03
0?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0
fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3L
IFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IV
OP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH
0>nm003gaP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl0
00000<_=f03;cMT0b/gI0<_>f03:cMP0blgH503;cMT20<_>f@0306]eS`3;
c=h0b<[I00P0b<[I00<0b<WI0<S:f@38b]T00`38b]T01038bMT0b<[I0<_<
gP1[MHl20<_=f00606]eS`3;c=h0b<[I0<S:f@3oool09BDf1@38b]T04@38
bMT0b<[I0<S:f@3oool09BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=
f02V>D@0eemO0=]TI03PIfD0h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3o
ool02P167QX0gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0YSU40<[>f03:c]T2
0<_=f@40d=;K0@1VIWh0000306IVOP3?cmX0aLSD00<0aLSD00H000000<K6
aP3Wg]H0cW/00>N]003_]@020>NU00030=JD003>L`00eY@00080mlH00P3g
moL010000000aLSD0<G7e035am@30<G7eA@0a<OE0P34b=@00`1[MHl0d=7P
0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3o
ool09BDf0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]e
S`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo
04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD0@35amD10<o?fP40
IVIn0000101VIWh0c<kJ0<;4dP31a=420<74dP060000003WinL0inOW0>OW
i`3FQ000kkD00P3WY@00203FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL0
00000`31a=800`32a=40`LCB0<74dP0D0<74d@80`LCB00<0JgF?0=?ChP3?
d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M00<0oooo
02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@020<o@g@070=?ChP1[MHl0
`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203QJFD0ffAT
0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:c=P0_/3?
0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<00020=jD00040=Ik0036
H`00_D800>nU0080mjd000P0mkD00?o>BP000000_/3>0;k0c`2n`<h0_/3?
0;g0cQD0_/3>0P2m`<h00`1[MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0
_/3>0;k0cP1[MHl0e]KT0P3Cdn000`3oool09BDf0?ooo`080?ooo`0;02DU
=P3Cdn00dm?P0=?Ch03Fe^@0JgF?0;k0c`2n`<h0YSU40>1VI@3QJVX0103S
K6`30?ooo`0404HN6P3oool0oooo0?ooo`@0hfa/00@0hFYZ0>1VI@2V>D@0
_L3?0P2n`<l10;k0cP40b/cH0@1VIWh0000706IVOP39b]P0][S80;Vlb`2j
_</0^[c<000000020>o_k`0C0=JL003FS000gY@00=J4003_Y@00gX`00;eJ
003FL`00ki`00?O_i`3gmoL0oooo0000002i_<`0^[_<0;Vlb`2j_</0^Kc<
0;Vlb`0D0;Vlc080^[c<00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?
0;Zlb`2j_</0JgF?0=SHi@80dm?Q00<0oooo06i]S`1^KHl0201^KHl03P0U
9CH0dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<0:HiA03PJFP0hFe/0>Aa
K@3TLFl0i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^00T0i75]
0>5]K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039b]P00@1VIWh0000906IV
OP37bML0];K70;Jhb02f^<T0][W900000024Q8@0inON0080kno_00L0aV/0
0?O6003_]@00ki`00=j<003>J`00ii`000<0moOg00D000000;Jib@2g^<T0
][W90;Nib@020;JhbA@0]kS90P2f^<T0101[MHl0e]KT0=SHi@3Hf>H30=SH
i@D0f=SV0`3Hf>D20=SHiP80f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3F
e^@0f=SU0=SHiP3oool02P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]e
S`2g^<T0]kW90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_
0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0
][S90;Jib@2d]/L0alWG0@1VIWh0000306IVOP36b=L0];K700<0];K700<0
00000>o_k`3_knl00P3_knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3N
U3T0kmJe0?ogm`3oool0000001`0];K700D0JgF?0=GEh`3LfnL0g=_W0=gK
i`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL0
9BDf02DU=P0902DU=P<0g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0
igEb0>YfL`3ZN7H00P3oool00`167QX0jGih0>UnN0030>UnN00804HN6P3o
ool0oooo0>YhMP3ZMW<0igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh00003
06IVOP36b=L0];K700<0];K700H0000008b<S03_knl0kno_0>O>N`3_knl2
0?Ogm`080>ND003gilh0moOg0?Ogm`3_imH0moOg0?ooo`00000L0;Bfa`03
06]eS`3Ee><0h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A
0>3OjP090=GDh`1[MHl0];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080
AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV1
0>n1NP3YO7P0jWUc0:HiA0040;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0
/K?800<0/K?800H000000>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OW
aP3gmoL0oooo00<0moOg00<0oooo0000002a/lP06`2a/lP00`1[MHl0kN_c
0>WXl@0@0>WXl@060>g[l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]
jo<0JgF?0;6cb02a/lP0YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fd
V`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al
0?60M@2V>D@0102a/lP10<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`030:n^
a`050000002][Jd0moO_0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<00000
0:n^a`2_[/L06P2_[/L00`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0
[jk70:n^a`1[MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:
O@80mI253@3b^9h20?F@Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8
e`40IVIn00000`1VIWh0`<7A0<O7e00_0:b[a00408B<XP1[MHl0c<_M0?_k
o0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3k
no`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0
o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH0
1P3jjkL0n]bg0?joY03oWhd0YSU4096HZP<0[:_40@37am@10<31d@40IVIn
0000101VIWh0`<7A0=;Bg`2e]<T_0:BS_P0308B<XP1[MHl0JgF?00l0JgF?
00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<
XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n
0:BS_P2TXkh0]KC90=;Bg`30`M400@1VIWh0000606IVOP2XYkl0i^K]0=;B
h02l_<l0/K34K`2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn0000
1`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@h03:b]X0K@2l_<l01P3:b]X0d=3P
0>CSj03lo?`0emSR08N7V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl
0?;al`3/jnh0hN;[J`3Gf>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1V
IWh00@1HEfP00080F5MX00<0IVIn09FDZ`3AdMh00P3lo?a]0?ooo`80o?cl
00<0dM7N09FDZ`1VIWh00P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW
_`1/0:RW_`0409FDZ`28Qid0IVIn06IVOP<0F5MX000505QGJ740IVIn1@1H
EfP00001\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  Evaluatable->False,
  ImageSize->{123, 59},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Images"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Images"]
}, Open  ]],

Cell[TextData[{
  "There are two main icon- and image-related components: ",
  StyleBox["Widget[\"Icon\"] ", "Output"],
  "and ",
  StyleBox["Widget[\"ImageLabel\"]", "Output"],
  ".  Both widgets support a ",
  StyleBox["\"path\"", "Output"],
  " property for specifying a relative file pathname to find a GIF, JPEG, or \
PNG image to use as the image data.  Additionally, they also support a ",
  StyleBox["\"data\"", "Output"],
  " property taking a ",
  StyleBox["String", "Output"],
  " of image data. This ",
  StyleBox["String", "Output"],
  " of image data is easily produced from ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " using ",
  StyleBox["Script[ ExportString[graphics, \"format\"], options]", "Output"],
  " supporting ",
  StyleBox["\"GIF\"", "Output"],
  ", ",
  StyleBox["\"JPEG\"", "Output"],
  ", or ",
  StyleBox["\"PNG\" ", "Output"],
  "image formats."
}], "Text",
  CellTags->"Images"],

Cell[TextData[{
  "Many widgets take an ",
  StyleBox["\"icon\"", "Output"],
  " property, such as buttons and menu items, and so a ",
  StyleBox["Widget[\"Icon\"]", "Output"],
  " instance would be used when setting an icon property on another widget. \
",
  StyleBox["Widget[\"ImageLabel\"]", "Output"],
  ", as its name implies,  is identical in functionality to ",
  StyleBox["Widget[\"Label\"]", "Output"],
  ", except that it will easily display an image as its label instead of \
text.  ",
  StyleBox["Widget[\"ImageLabel\"]", "Output"],
  " is useful when basic image display is needed in a user interface."
}], "Text",
  CellTags->"Images"],

Cell[TextData[{
  "Additionally, there is also ",
  StyleBox["Widget[\"MathPanel\"]", "Output"],
  " with the ",
  StyleBox["\"mathCommand\"", "Output"],
  " property ",
  StyleBox["String", "Output"],
  ". This widget actually stores the command that is executed in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " to regenerate the graphics and uses its own size to determine the width \
and height of the resulting graphics.  ",
  StyleBox["Widget[\"Icon\"]", "Output"],
  " and ",
  StyleBox["Widget[\"ImageLabel\"]", "Output"],
  " simply take externally created image data, either from the filesystem \
using the ",
  StyleBox["\"path\"", "Output"],
  " property or a ",
  StyleBox["\"data\"", "Output"],
  " ",
  StyleBox["String", "Output"],
  " property easily generated from a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " ",
  StyleBox["Script[ExportString[\[Ellipsis]]]", "Output"],
  " call."
}], "Text",
  CellTags->"Images"],

Cell[BoxData[
    RowBox[{
      RowBox[{"ref", " ", "=", " ", 
        RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
          RowBox[{
            StyleBox["Widget",
              "Output"], "[", 
            RowBox[{"\"\<Panel\>\"", ",", 
              RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{
                      RowBox[{
                        StyleBox["Widget",
                          "Output"], "[", 
                        RowBox[{"\"\<Button\>\"", ",", " ", 
                          RowBox[{"{", 
                            RowBox[{"\"\<icon\>\"", "\[Rule]", 
                              RowBox[{
                                StyleBox["Widget",
                                  "Output"], 
                                "[", \("\<Icon\>", {"\<path\>" -> \
"\<Wolfram/Example/Stop16.gif\>"}\), "]"}]}], "}"}]}], "]"}], ",", 
                      "\[IndentingNewLine]", 
                      RowBox[{
                        StyleBox["Widget",
                          "Output"], "[", 
                        RowBox[{"\"\<Button\>\"", ",", " ", 
                          RowBox[{"{", 
                            RowBox[{"\"\<icon\>\"", "\[Rule]", 
                              RowBox[{
                                StyleBox["Widget",
                                  "Output"], 
                                "[", \("\<Icon\>", {"\<path\>" -> \
"\<Wolfram/Example/Play16.gif\>"}\), "]"}]}], "}"}]}], "]"}]}], "}"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{
                    StyleBox["Widget",
                      "Output"], "[", 
                    RowBox[{"\"\<Button\>\"", ",", " ", 
                      RowBox[{"{", 
                        RowBox[{
                        "\"\<icon\>\"", "\[Rule]", "\[IndentingNewLine]", 
                          RowBox[{
                            StyleBox["Widget",
                              "Output"], 
                            "[", \("\<Icon\>", {\[IndentingNewLine]"\<data\>" \
-> Script[\ ExportString[\ ToBoxes[a + b\/c\^4], \ "\<GIF\>", \ 
                                    ConversionOptions \[Rule] \
{"\<Transparency\>" \[Rule] GrayLevel[1]}]]}\), "]"}]}], "}"}]}], "]"}]}], 
                "\[IndentingNewLine]", "}"}]}], "]"}], " ", 
          "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Images"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"Images"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000IB000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3Qh>@0
i^GX0>c[kP3`l?80l_;d03D0lo?d<P3hmoP20??cm0080??cm@3dm?D0mOGf
0?Ccm@3Ui>P0IVIn0:RY^`3ko?d106IVOP0000P0IVIn0?_lo@2XZK/0IVIn
0=kLg`3Th^00NiN]02EGQF/003ad00L05den06^;YP3blNh0l_7c06IVOP2X
ZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0f]SI06J5X@1:LI<0
/[g3J`36aML01`30a/D0B6j@06Z:Y03_ko40IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP3HeMH05den0;o7bP1]0<K5e`060;Jm_@0G
CGh0jn[]06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3I
eMD003ad0?ooo`1]0<g<g`060?ooo`00?7@0j>OZ06IVOP2XZK/0nocm0@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`1]0=;Ai0060?oo
o`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3IeMD003ad0?ooo`1]0=KGi`060?ooo`00?7@0inKY06IVOP2XZK/0nocm
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0k0=WJi`<0
0000;`3If^L01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1V
IWh0nocm0:RY^`1VIWh0fMGE000lM03oool0>P3If^L01@000000fM[W0=WJ
i`3If^L0000002h0fM[W00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IV
OP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo03X0g]o/00<00000
0=kOk03Ngn`0<03Ngn`01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn
00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool0>P3Ngn`00`000000
g]o/0=kOk0050=kOk0<00000:03Ngn`01P3oool003ad0>OVj@1VIWh0Z:Vk
0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool0>P3N
gn`01@000000g]o/0=kOk03Ngn`0000000@0g]o/00<000000=kOk03Ngn`0
9`3Ngn`01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0
nocm0:RY^`1VIWh0fMGE000lM03oool0>`3Ngn`400000080g]o/1000000X
0=kOk0060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP3IeMD003ad0?ooo`110>?Ul0030000003SiO00000002T0
hnG`00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn0=WEe@00?7@0oooo0480hnG`0P00000Y0>?Ul0060?ooo`00
?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3I
eMD003ad0?ooo`130>?Ul0030000003SiO00hnG`02L0hnG`00H0oooo000l
M03Wi^T0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WE
e@00?7@0oooo06d0hnG`00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IV
OP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo02@0jN_e1@000005
0>W[m@030000003YjoD0jN_e03`0jN_e00H0oooo000lM03Wi^T0IVIn0:RY
^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo02<0
jN_e00D000000>W[m@3YjoD0jN_e000000060>W[m@030000003YjoD0jN_e
03`0jN_e00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000L0IVIn
0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo02<0jN_e00D000000>W[m@3YjoD0
jN_e000000040>W[m@D000001P3YjoD?000002L0jN_e00H0oooo000lM03W
i^T0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00
?7@0oooo02@0jN_e100000060>W[m@030000003YjoD0jN_e03`0jN_e00H0
oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0
IVIn0=WEe@00?7@0oooo02<0jN_e00D000000>W[m@3YjoD0jN_e00000006
0>W[m@030000003YjoD0jN_e03`0jN_e00H0oooo000lM03Wi^T0IVIn0:RY
^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo02@0
l?7l0`0000160?3ao0060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`1]0?3ao0060?ooo`00
?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3I
eMD003ad0?ooo`1]0?3ao0060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`1]0?3ao0060?oo
o`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3IeMD003ad0?ooo`0l0?Ceo@D00000;03dmOd01P3oool003ad0>OVj@1V
IWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03o
ool0?@3dmOd01@000000m?Gm0?Ceo@3dmOd0000002/0m?Gm00H0oooo000l
M03Wi^T0IVIn0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0=WE
e@00?7@0oooo03d0m?Gm00D000000?Ceo@3dmOd0m?Gm0000000[0?Ceo@06
0?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP3IeMD003ad0?ooo`0m0?Ceo@050000003dmOd0m?Gm0?Ceo@000000
:`3dmOd01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0
nocm0:RY^`1VIWh0fMGE000lM03oool0?@3fmod200000080m_Om00<00000
0?Kgo@3fmod0:@3fmod01P3oool003ad0>OVj@1VIWh0Z:Vk0?_lo@40IVIn
00001`1VIWh0nocm0:RY^`1VIWh0fMGE000lM03oool0?@3ho?d010000000
n?cm00000000000/0?Slo@060?ooo`00?7@0inKY06IVOP2XZK/0nocm0@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD003ad0?ooo`0m0?gmo@030000
003moOd0oOgm02d0oOgm00H0oooo000lM03Wi^T0IVIn0:RY^`3ko?d106IV
OP0000L0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0oooo03`0oOgm0P00000_
0?gmo@060?ooo`00?7@0i^KY06IVOP2XZK/0nocm0@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP3He=@003ad0?ooo`1]0?gmo@060?ooo`00?7@0iNGX06IV
OP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3IeMD09EN50;o>
g01]0?ooo`060;o>f`0UEhD0hN7T06IVOP2XZK/0nocm0@1VIWh0000806IV
OP3ko?d0Z:Vk06IVOP3IeMD0NIBY05EmXP30cme[0?ooo`070=GOj01EOJ80
NIF[0=oMh01VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn
0=[Gf@3Og=P0NIBY02EGQF/003ad00L05den06J6X@3Pg]X0g=_M06IVOP2X
ZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0gmgP0=[Gf@3He=@0
=`3Gdm@b0=?>c0<0em?D00L0f=CD0=WEe@3JemT0gmgP06IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`0306IVOP2XZK/0nocm
0040IVIn00002@1VIWh0nocm0:RY^`1VIWh0hN3T0>KUj03/jnh0l?3b0?;b
m00D0??cm140n?Oh0P3clo@01@3cloD0m?Ce0?GemP3dloD0iNCX00<0h=oS
00D0hN3T0>KUj03/jnh0l?3b0?;bm00D0??cm140n?Oh0P3clo@01@3cloD0
m?Ce0?GemP3dloD0iNCX00h0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00008
06IVOP3ko?d0Z:Vk06IVOP3Ng=l0i>;P07^G[@0UEhDY000lM00401M=OP1[
RjH0l_7^0?;al`<0h=oS00@0g]cO0>CRh01kUjd09EN5:@00?7@0100GCGh0
Jh^V0?;akP3blO<>0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000201VIWh0
nocm0:RY^`1VIWh0f]SI06J5X@0WCHD0CGg1:P1YP^h00`0WCHD0JXZT0>o_
l@030>3Oh`040=[Hf@1VQJ40BW6C0;:m`bT0a/GG00@0`<K504Q^T01ZRZ@0
knoa3P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0
IVIn0=SEeP0GCGh]08V]i00301M=OP3[j^d0h=oS0080h=oS00<0f=GF01M=
OP2oalX0:`36aML00`2f_Kd05den0>_Zk@0>0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM029[N@0oooo:@3=
c=l0103oool0RJgT000lM03XinX30>3Oh`030=WEe@00?7@0oooo02/0cLcO
00<0oooo000lM03XinX03P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0
IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0RjgT0?ooobT0d]7T00@0oooo08^_
i@00?7@0inKY0`3Pgn<00`3IeMD003ad0?ooo`0[0=;Ai0030?ooo`00?7@0
inKY00h0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk
06IVOP3IeMD003ad08j_iP3ooolY0=KGi`040?ooo`2=[nD003ad0>OVj@<0
h=oS00<0fMGE000lM03oool04`3FenL00`3oool0e]OW0=KGi`0E0=KGi`03
0?ooo`00?7@0inKY00h0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000806IV
OP3ko?d0Z:Vk06IVOP3IeMD003ad096ai`3oool?0=WJi`/0oooo3`3If^L0
103oool0TK7V000lM03Wi^T30>3Oh`030=WEe@00?7@0oooo0180fM[W00<0
<c=V0?ooo`3oool05P3If^L00`3oool003ad0>OVj@0>0>3Oh`0306IVOP2X
ZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0fMGE000lM02D]>P0
oooo3P3If^L00`0c<fH0IVJI03<cIP0803<cIP030?ooo`3If^L0fM[W00d0
fM[W00@0oooo09Fdj000?7@0inKY0`3Pgn<00`3IeMD003ad0?ooo`0B0=WJ
i`80<c=V0P3ooolE0=WJi`030?ooo`00?7@0inKY00h0h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad09RhjP3o
ool>0=kOk00<03<cIP3<c?l0];CJ09ZJ_`2d]=X0UYJl09fL``1dM9X0Shne
07AdVP0c<fH0oooo3`3Ngn`0103oool0V;SY000lM03Wi^T30>3Oh`030=WE
e@00?7@0oooo0180g]o/00<0<c=V09VIc00c<fH00P3ooolD0=kOk0030?oo
o`00?7@0inKY00h0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3k
o?d0Z:Vk06IVOP3IeMD003ad09bkjP3oool>0>?Ul00<03<cIP3<c?l0UYJl
0;BdfP2JV[l0];CJ08n?]@2FU[`0M7BJ08n?]@0c<fH0oooo3`3SiO00103o
ool0W;_[000lM03Wi^T30>3Oh`030=WEe@00?7@0oooo0180hnG`00@0<c=V
09VIc01VIYT0<c=V0P3ooolC0>?Ul0030?ooo`00?7@0inKY00h0h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3IeMD003ad
09bkjP3oool>0>?Ul00<03<cIP3<c?l0WIc309JF_02d]=X0VYZo0;BdfP2?
SkD0UYJl07AdVP0c<fH0oooo3`3SiO00103oool0W;_[000lM03Wi^T30>3O
h`030=WEe@00?7@0oooo0180hnG`00D0<c=V09VIc01VIYT0IVJI03<cIP02
0?oooa80hnG`00<0oooo000lM03Wi^T03P3Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0X;k/0?ooo`h0jN_e
00`0<c=V0<c<o`1mOJ<0YjO=09JF_02d]=X0WIc30:n_e@27QZ`0UYJl03<c
IP3oool?0>W[m@040?ooo`2Q_^`003ad0>OVj@<0h=oS00<0fMGE000lM03o
ool04P3YjoD00`0c<fH0VIW<06IVV@0206IVV@0303<cIP3oool0oooo0140
jN_e00<0oooo000lM03Wi^T03P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0YL7]0?ooo`h0l?7l00`0<c=V
0<c<o`2?SkD0OGfS0:NWc@2JV[l0/K7G09fL``2_[mD0QhJ/03<cIP3oool?
0?3ao0040?ooo`2U`^h003ad0>OVj@<0h=oS00<0fMGE000lM03oool04P3`
lO`00`0c<fH0VIW<06IVV@0306IVV@0303<cIP3`lO`0l?7l0100l?7l00<0
oooo000lM03Wi^T03P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn
0?_lo@2XZK/0IVIn0=WEe@00?7@0YL7]0?ooo`h0l?7l00`0<c=V0<c<o`1d
M9X0Shne07emX`2_[mD0VYZo0;BdfP2MW<<0[joE03<cIP3oool?0?3ao004
0?ooo`2U`^h003ad0>OVj@<0h=oS00<0fMGE000lM03oool04P3`lO`00`0c
<fH0VIW<06IVV@0206IVV@0303<cIP3`lO`0l?7l0140l?7l00<0oooo000l
M03Wi^T03P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2X
ZK/0IVIn0=WEe@00?7@0ZLG_0?ooo`h0m?Gm00`0<c=V0<c<o`2?SkD0M7BJ
08n?]@27QZ`0[joE09ZJ_`2d]=X0WIc303<cIP3oool?0?Ceo@040?ooo`2Y
aNl003ad0>OVj@<0h=oS00<0fMGE000lM03oool04P3dmOd01@0c<fH0VIW<
06IVV@1VIYT0<c=V01@0m?Gm00<0oooo000lM03Wi^T03P3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0[LS`
0?ooo`h0m_Om00`0<c=V0<c<o`1dM9X0Shne07AdVP2ATKL0QhJ/0;6ae`2M
W<<0];CJ03<cIP3oool?0?Kgo@040?ooo`2/ao0003ad0>OVj@<0h=oS00<0
fMGE000lM03oool04P3fmod0100c<fH0VIW<06IVV@0c<fHE0?Kgo@030?oo
o`00?7@0inKY00h0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3k
o?d0Z:Vk06IVOP3IeMD003ad0;7;lP3oool>0?Slo@0303<cIP3<c?l0c<co
00L0c<co00<0IVJI0?ooo`3ho?d03P3ho?d0103oool0/Lcb000lM03Wi^T3
0>3Oh`030=WEe@00?7@0oooo0180n?cm00<0<c=V09VIc00c<fH05P3ho?d0
0`3oool003ad0>OVj@0>0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000201V
IWh0nocm0:RY^`1VIWh0fMGE000lM02dcO<0oooo3P3moOd;03<cIQ00oOgm
00@0oooo0;G>l`00?7@0inKY0`3Pgn<00`3IeMD003ad0?ooo`0B0?gmo@03
03<cIP1VIYT0oOgm01H0oOgm00<0oooo000lM03Wi^T03P3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=WEe@00?7@0]m3d
0?ooobT0oOgm00@0oooo0;S@m@00?7@0i^KY0`3Pgn<00`3IeMD003ad0?oo
o`0B0?gmo@0303<cIP3moOd0oOgm01H0oOgm00<0oooo000lM03Vi^T03P3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn0=SD
e000?7@0^]?e0?ooobT0oOgm00@0oooo0;[CmP00?7@0iNGX0`3Pgn<00`3H
e=@003ad0?ooo`0[0?gmo@030?ooo`00?7@0iNGX00h0h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3IeMD09EN5;@2le?H0
0`0UEhD0hN7T0>3Oh`020>3Oh`030=WEe@0UEhD0_lkL02/0oooo00<0_lkK
02EGQ@3QhN@03P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn0=WEe@1iU:T09df502/0c^Oo00<09df507VEZ`3OgN000`3P
gn<0103IeMD0NIBY05EmXP30cmdY0?ooo`040=GOj01EOJ80NIF[0=oMh0h0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP3J
emT0gmcH07VDZ@0UEhDY000lM00401M=OP1VQZ40h=kJ0=cKg@<0h=oS00@0
f]OI0=oLf01iU:T09EN5:@00?7@0100GCGh0IXJQ0>3NfP3Lfmd>0>3Oh`03
06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0gmgP0=[G
f@3He=@05P3Gdm@A0=?>c0<0em?D00@0f=CD0=WEe@3JemT0gmgP0`3Pgn<0
0`3OgN00f]OI0=SDe00F0=OCe140dlk<0`3Gdm@0103He=@0fMGE0=[Gf@3O
gN0>0>3Oh`0306IVOP2XZK/0nocm0040IVIn00000`1VIWh0moOi09RHY`1e
07MgTP40V9RW0@3gmoT106IVOP0000<0IVIn0?Ogn@2l_Ld0MP2l_Ld10?Og
n@40IVIn00000`1VIWh0moOi0>CSh`1f0>CSh`40moOi0@1VIWh0000306IV
OP3`lO@0oooo02l0oooo00<0i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?
06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0
101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0
W:Bi102V>D@0102W>T@0YSU40:LjA02W>T@90:HiA00309bT^@3/j^X0oooo
00<0oooo0@3`lO@106IVOP0001H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0
no_m0?_lo@3ko?`0o?cm0?clo03lnod0o?cl0?cko03lo?`0nocl0?clo03k
o?d0o?_l0?clo@3knod0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?dD0?ck
o080nocl00<0W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0
W:Bi06]eSa40QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@07
0:HiA02LY;T0nocl0?clo03lnod0nocm0>;QhP0106IVOP0000@0IVIn0>3P
h@3fmoT0moOi0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0
moKh0?Kgn@3gmoT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT0
0`3fmoP0moOi0?Ogn@0C0?Ogn@80m_Oi00<0JgF?08F9/02LW[h0402LW[h0
1P25RK00JgF?0?Ogn@3gmoT0JgF?08F9/140W9jn00P0QHV`06]eS`3fmoP0
moOh0:HiA02Z?5D0`U9K0<IDFPd0aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Og
n03gmoT0moOh0?Ogn@3Ph>400@1VIWh0000606IVOP3NgN40lO7d0?7am03`
lO@0l?;d400000001P3alO@0l?;e0?7am03al_@0l?;d0?7am1H0l?7e00<0
JgF?0;:ed02WZ<80402WZ<801P2b]M00JgF?0?3am03`lO@0JgF?0;:ed140
YjS200D0/[G@06]eS`3`lOD0lO;d0:HiA0020<9BF`030<]DF@3=FEh0cEUN
00/0cEUN00@0beAI0<9BF`32DU/0YSU40P3`lO@00`3alO@0l?;d0=kMh@01
06IVOP0000L0IVIn0=cKh03Zjo00j^_`0>[/l03Yjnl000000080inOW0P3N
g]h20>OWi`030>NmQ03WinL0inOW00<0inOW0P3_knl010000000j^_`0>[[
l03Zjnl20>[[l0030>[[k`3Zjo00j^_`0180j^_`0P3Zk?00101[MHl0][WA
0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[
MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Ji
d@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO
0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0
IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080
inOW00<0aV<00>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ
0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0B0>?Uj`80hnCZ00D0JgF?
0;bne02b//X0/[;:0?ooo`0606i]S`0302DU=P2b//X0/[;:00D0/[;:00H0
_;kD06]eS`3SiNX0hnGZ06]eS`2l_]@20;:bbP030?ooo`0U9CH09BDf00T0
9BDf0`2b//X01@2l_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN00@0d5]P0=AL
G`3oool0oooo1`3DG5l20?ooo`0:0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnCZ
0>?UjP3Si>X0hnG[0=WIg`40IVIn00000`1VIWh0emSN0=cNiP030=cNiP05
0000003WinL0inOW0>OWi`3We/h00P3WinL01@3>N`00ki@@0>OWi`3Wg/H0
kh`@00<0kno_00L000000=cNiP3Lg^D0g=kU0=cNiP3Lg^D0g=kV01H0g=kU
00D0JgF?0;o1eP2h^Lh0^;W>0?ooo`0606i]S`0302DU=P2h^Lh0^;W>00D0
^;W>00H0_l7F06]eS`3Lg^D0g=kU06]eS`2o`MH20;RicP030?ooo`0U9CH0
^;W>00L0^;W>00<0oooo02DU=P2h^Lh00P2h^Lh02@2o`MH0JgF?0=cNiP3L
g^D0YSU40<eIGP3AFUh0e5eQ05<U80030?ooo`D0eUmS0`3oool01@1C9B00
e5eQ0=5JGP3=FEh0YSU40080g=kU00<0g=kV0=cNi@3Gf=h00@1VIWh00004
06IVOP3Ee]d0eMSP0=KHh@80eMSP00T0000008b<S03WinL0inOW0>NeQ03F
FP00eX@00?o>003>H`000P3NJ`001@3_]H`0kno_0>o_k`3_knl000000080
eMSQ00@0eMOP0=KHh03Ff>40e]OQ503Fen020=KHh00506]eS`33aMT0_;gA
0;bmd@3oool01`0U9CH70;bmd@060<?5f@1[MHl0eMSQ0=GHh@1[MHl0`lGI
0P2l_M400`3oool09BDf0;bmd@070;bmd@030?ooo`0U9CH0_;gA0080_;gA
00D0`lGI06]eS`3Fen00eMOQ0:HiA0020=EMH0030=QPH@3IHF80AQhJ00<0
oooo0`3IHF830?ooo`0304HN6P3IHF80f61Q0080eEeP00H0YSU40=KHh03E
f>40eMOP0=GHh@3Ee]d106IVOP0000L0IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@
d]`0000000<0inOW00`0imk>0<I:003gcP00kjd00>ne003>J`00aUX00<I[
003NS4X0ijD00>oWcP0000030=3Bg0030<oBg03@d]`0cm;L01@0d=;L0P3?
d]d00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3Bg01[MHl0
b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP030?ooo`0U9CH0`lCF0080
`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU00D0AQhJ
0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aUI@3IHF80
eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn0=3Bf`3;
cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH0>nm003gaP00kjd00>N]
003WY@00eX`00<i[003WaP00omH00>o_i`3_knl000000<_=f03;cMT0b/gI
0<_>f03:cMP0blgH503;cMT20<_>f@0306]eS`3;c=h0b<[I00P0b<[I00<0
b<WI0<S:f@38b]T00`38b]T01038bMT0b<[I0<_<gP1[MHl20<_=f00606]e
S`3;c=h0b<[I0<S:f@3oool09BDf1@38b]T04@38bMT0b<[I0<S:f@3oool0
9BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0eemO0=]TI03P
IfD0h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3oool02P167QX0gVMW0=iW
I`3PIVD0h6MU0=]TI03GGel0YSU40<[>f03:c]T20<_=f@40d=;K0@1VIWh0
000306IVOP3?cmX0aLSD00<0aLSD00H000000<K6aP3Wg]H0cW/00>N]003_
]@020>NU00030=JD003>L`00eY@00080mlH00P3gmoL010000000aLSD0<G7
e035am@30<G7eA@0a<OE0P34b=@00`1[MHl0d=7P0<_;g00@0<_;g0060=3A
h01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3oool09BDf0<_;g0070<_;
g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]eS`35am@0a<OD0:HiA03K
I6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo04HN6P050>1ZJ0040=mU
I03KI6@0YSU40<C8e@80a<SD0@35amD10<o?fP40IVIn0000101VIWh0c<kJ
0<;4dP31a=420<74dP060000003WinL0inOW0>OWi`3FQ000kkD00P3WY@00
203FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL000000`31a=800`32a=40
`LCB0<74dP0D0<74d@80`LCB00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80
JgF?0<;4dP32a=80JgF?0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?d=d0
0`3oool09BDf0<o@g@020<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT
0>5YI@050>1/J@D0oooo1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA0<74
d@31a=80c<kJ0@1VIWh0000406IVOP3:c=P0_/3?0;g0c`80_/3>00D00000
09bLW03WinL0imkF0=J<00020=jD00040=Ik0036H`00_D800>nU0080mjd0
00P0mkD00?o>BP000000_/3>0;k0c`2n`<h0_/3?0;g0cQD0_/3>0P2m`<h0
0`1[MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0cP1[MHl0e]KT
0P3Cdn000`3oool09BDf0?ooo`080?ooo`0;02DU=P3Cdn00dm?P0=?Ch03F
e^@0JgF?0;k0c`2n`<h0YSU40>1VI@3QJVX0103SK6`30?ooo`0404HN6P3o
ool0oooo0?ooo`@0hfa/00@0hFYZ0>1VI@2V>D@0_L3?0P2n`<l10;k0cP40
b/cH0@1VIWh0000706IVOP39b]P0][S80;Vlb`2j_</0^[c<000000020>o_
k`0C0=JL003FS000gY@00=J4003_Y@00gX`00;eJ003FL`00ki`00?O_i`3g
moL0oooo0000002i_<`0^[_<0;Vlb`2j_</0^Kc<0;Vlb`0D0;Vlc080^[c<
00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?0;Zlb`2j_</0JgF?0=SH
i@80dm?Q00<0oooo06i]S`1^KHl0201^KHl03P0U9CH0dm?Q0=?Ch@3Cdn40
f=SU06]eS`2j_</0^[c<0:HiA03PJFP0hFe/0>AaK@3TLFl0i71^0`3oool0
0`167QX0i71^04HN6P030?ooo`80i71^00T0i75]0>5]K03PJFP0YSU40;Zl
c02j^l`0^Kc;0;Jhb039b]P00@1VIWh0000906IVOP37bML0];K70;Jhb02f
^<T0][W900000024Q8@0inON0080kno_00L0aV/00?O6003_]@00ki`00=j<
003>J`00ii`000<0moOg00D000000;Jib@2g^<T0][W90;Nib@020;JhbA@0
]kS90P2f^<T0101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SH
iP80f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool0
2P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03T
KVd0i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0
oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG
0@1VIWh0000306IVOP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_
knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool0
000001`0];K700D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[
MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0
g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3o
ool00`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0
igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0
];K700H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0
moOg0?Ogm`3_imH0moOg0?ooo`00000L0;Bfa`0306]eS`3Ee><0h=oZ0100
h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0
];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]
UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:Hi
A0040;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H00000
0>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg
00<0oooo0000002a/lP06`2a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[
l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0
YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/
]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP1
0<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_
0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L06P2_[/L0
0`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S
4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@
Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0
`<7A0<O7e00_0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;
g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<
bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf
0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03o
Whd0YSU4096HZP<0[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;B
g`2e]<T_0:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh0
0P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n
00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;B
g`30`M400@1VIWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34K`2XYkl0
1@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3l
o?`0i>?X0=3@h03:b]X0K@2l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7
V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[J`3G
f>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX
00<0IVIn09FDZ`3AdMh00P3lo?a]0?ooo`80o?cl00<0dM7N09FDZ`1VIWh0
0P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW_`1/0:RW_`0409FDZ`28
Qid0IVIn06IVOP<0F5MX000505QGJ740IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  Evaluatable->False,
  ImageSize->{123, 101},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Images"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"Images"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"ref", " ", "=", " ", 
        RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
          RowBox[{
            StyleBox["Widget",
              "Output"], "[", 
            RowBox[{"\"\<Panel\>\"", ",", 
              RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{
                      RowBox[{
                        StyleBox["Widget",
                          "Output"], 
                        "[", \("\<ImageLabel\>", \
{\[IndentingNewLine]"\<data\>" \[Rule] \ 
                            Script[
                              ExportString[
                                ToBoxes[f[\[Beta]], 
                                  TraditionalForm], \ "\<GIF\>", \ \ \
ConversionOptions \[Rule] {"\<Transparency\>" \[Rule] GrayLevel[1]}]]\ }\), 
                        "]"}], ",", "\[IndentingNewLine]", 
                      RowBox[{
                        StyleBox[
                          RowBox[{
                            StyleBox["Widget",
                              "Output"], "Align"}]], "[", "]"}], ",", 
                      "\[IndentingNewLine]", 
                      RowBox[{
                        StyleBox["Widget",
                          "Output"], "[", "\"\<TextField\>\"", "]"}]}], "}"}],
                   ",", "\[IndentingNewLine]", 
                  RowBox[{"{", 
                    RowBox[{
                      RowBox[{
                        StyleBox["Widget",
                          "Output"], 
                        "[", \("\<ImageLabel\>", \
{\[IndentingNewLine]"\<data\>" \[Rule] \ 
                            Script[
                              ExportString[
                                ToBoxes[\(f''\)[\[Beta]], 
                                  TraditionalForm], \ "\<GIF\>", \ \ \
ConversionOptions \[Rule] {"\<Transparency\>" \[Rule] GrayLevel[1]}]]\ }\), 
                        "]"}], ",", "\[IndentingNewLine]", 
                      RowBox[{
                        StyleBox[
                          RowBox[{
                            StyleBox["Widget",
                              "Output"], "Align"}]], "[", "]"}], ",", 
                      "\[IndentingNewLine]", 
                      RowBox[{
                        StyleBox["Widget",
                          "Output"], "[", "\"\<TextField\>\"", "]"}]}], 
                    "}"}]}], "\[IndentingNewLine]", "}"}]}], "]"}], 
          "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
  CellLabel->"In[6]:=",
  CellTags->"Images"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"Images"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000CB000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVORD0h=oS
CP2U[;800`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
9@3Pgn<00`2U[;80oooo0?ooo`1:0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWhU0>3Oh`030:F//P3oool0oooo04X0
oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OP80h=oS0P00000Q0>3Oh`030:F//P3oool0oooo04X0oooo00@0YJbb06IV
OP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP80h=oS00<00000
0>3Oh`0000003P3Pgn<2000000H0h=oS00<000000>3Oh`3Pgn<01`3Pgn<0
0`2U[;80oooo0?ooo`1:0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
101VIWh0nocm0:RY^`1VIWh50>3Oh`030000003Pgn<0h=oS00X0h=oS00@0
00000>3Oh`3Pgn<000001P3Pgn<00`000000h=oS0>3Oh`060>3Oh`030:F/
/P3oool0oooo04X0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOPD0h=oS00<000000>3Oh`3Pgn<02@3Pgn<010000000
h=oS0>3Oh`3Pgn<4000000@0h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`2U
[;80oooo0?ooo`1:0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101V
IWh0nocm0:RY^`1VIWh50>3Oh`030000003Pgn<0h=oS00T0h=oS00D00000
0>3Oh`3Pgn<0h=oS000000030>3Oh`050000003Pgn<0h=oS0>3Oh`000000
1`3Pgn<00`2U[;80oooo0?ooo`1:0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40
IVIn0000101VIWh0nocm0:RY^`1VIWh60>3Oh`030000003Pgn<0h=oS00P0
h=oS00<000000>3Oh`3Pgn<00P3Pgn<010000000h=oS0>3Oh`0000030>3O
h`030000003Pgn<0h=oS00D0h=oS00<0YJbb0?ooo`3oool0BP3oool0102U
[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1P3Pgn<0
0`000000h=oS0>3Oh`080>3Oh`030000003Pgn<0h=oS0080h=oS00@00000
0>3Oh`3Pgn<000000`3Pgn<00`000000h=oS0>3Oh`050>3Oh`030:F//P3o
ool0oooo04X0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOPH0h=oS00<000000>3Oh`3Pgn<0203Pgn<00`000000h=oS
0>3Oh`020>3Oh`040000003Pgn<00000000000<0h=oS00<000000>3Oh`3P
gn<01@3Pgn<00`2U[;80oooo0?ooo`1:0?ooo`040:F//P1VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWh50>3Oh`<000002@3Pgn<00`00
0000h=oS0>3Oh`030>3Oh`040000003Pgn<0h=oS00000080h=oS00<00000
0>3Oh`3Pgn<01@3Pgn<00`2U[;80oooo0?ooo`1:0?ooo`040:F//P1VIWh0
Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWh60>3Oh`050000003P
gn<0h=oS0>3Oh`0000000P3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000D0
h=oS00@000000>3Oh`3Pgn<000000P3Pgn<00`000000h=oS0>3Oh`050>3O
h`030:F//P3oool0oooo04X0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOPL0h=oS00@000000>3Oh`00000000000P3P
gn<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS00<0h=oS0P00
00020>3Oh`030000003Pgn<0h=oS00H0h=oS00<0YJbb0?ooo`3oool0BP3o
ool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
203Pgn<2000000050>3Oh`000000h=oS0>3Oh`000000103Pgn<00`000000
h=oS0>3Oh`050>3Oh`030000003Pgn<0h=oS00L0h=oS00<0YJbb0?ooo`3o
ool0BP3oool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn2`3Pgn<010000000h=oS0>3Oh`00000F0>3Oh`030:F//P3oool0
oooo04X0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0
Z:Vk06IVORD0h=oS00<0YJbb0?ooo`3oool0BP3oool0102U[;80IVIn0:RY
^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn9@3Pgn<00`2U[;80oooo
0?ooo`1:0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm
0:RY^`1VIWhU0>3Oh`030:F//P3oool0oooo04X0oooo00@0YJbb06IVOP2X
ZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVORD0h=oSCP2U[;800`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInL`3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn9@3Pgn=>0:F/
/P0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhU0>3O
h`030:F//P3oool0oooo04X0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVORD0h=oS00<0YJbb0?ooo`3oool0BP3oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3P
gn<200000240h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?oo
o`140?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY
^`1VIWh20>3Oh`030000003Pgn<0000000P0h=oS0P0000060>3Oh`030000
003Pgn<0h=oS00d0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo
0?ooo`140?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm
0:RY^`1VIWh50>3Oh`030000003Pgn<0h=oS00@0h=oS00@000000>3Oh`3P
gn<000001P3Pgn<00`000000h=oS0>3Oh`0<0>3Oh`030:F//P3oool0oooo
00<0oooo00<000000?ooo`3oool0A03oool0102U[;80IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@3Pgn<00`000000h=oS0>3Oh`03
0>3Oh`040000003Pgn<0h=oS0>3Oh`@00000103Pgn<00`000000h=oS0>3O
h`0;0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0A03o
ool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
1@3Pgn<00`000000h=oS0>3Oh`030>3Oh`050000003Pgn<0h=oS0>3Oh`00
00000`3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000d0h=oS00<0YJbb0?oo
o`3oool00`3oool00`000000oooo0?ooo`140?ooo`040:F//P1VIWh0Z:Vk
0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWh60>3Oh`030000003Pgn<0
h=oS0080h=oS00<000000>3Oh`3Pgn<00P3Pgn<010000000h=oS0>3Oh`00
00030>3Oh`030000003Pgn<0h=oS00/0h=oS00<0YJbb0?ooo`3oool00`3o
ool00`000000oooo0?ooo`140?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWh60>3Oh`030000003Pgn<0h=oS0080h=oS
00<000000>3Oh`3Pgn<00P3Pgn<010000000h=oS0>3Oh`0000030>3Oh`03
0000003Pgn<0h=oS00/0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000
oooo0?ooo`140?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0
nocm0:RY^`1VIWh60>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3O
h`3Pgn<00P3Pgn<010000000h=oS0000000000030>3Oh`030000003Pgn<0
h=oS00/0h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`14
0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWh50>3Oh`<000000`3Pgn<00`000000h=oS0>3Oh`030>3Oh`040000003P
gn<0h=oS00000080h=oS00<000000>3Oh`3Pgn<02`3Pgn<00`2U[;80oooo
0?ooo`030?ooo`030000003oool0oooo04@0oooo00@0YJbb06IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPH0h=oS00<000000>3Oh`3P
gn<00P3Pgn<00`000000h=oS0>3Oh`030>3Oh`040000003Pgn<0h=oS0000
0080h=oS00<000000>3Oh`3Pgn<02`3Pgn<00`2U[;80oooo0?ooo`030?oo
o`030000003oool0oooo04@0oooo00@0YJbb06IVOP2XZK/0nocm0@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOPL0h=oS00<000000>3Oh`0000000P3Pgn<0
0`000000h=oS0>3Oh`030>3Oh`8000000P3Pgn<00`000000h=oS0>3Oh`0<
0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0A03oool0
102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn203P
gn<2000000<0h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`000000h=oS0>3O
h`0=0>3Oh`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0A03o
ool0102U[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
9@3Pgn<00`2U[;80oooo0?ooo`030?ooo`030000003oool0oooo04@0oooo
00@0YJbb06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVORD0
h=oS00<0YJbb0?ooo`3oool00`3oool00`000000oooo0?ooo`140?ooo`04
0:F//P1VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhU0>3O
h`030:F//P3oool0oooo00<0oooo00<000000?ooo`3oool0A03oool0102U
[;80IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn9@3Pgn<0
0`2U[;80oooo0?ooo`1:0?ooo`040:F//P1VIWh0Z:Vk0?_lo@40IVIn0000
101VIWh0nocm0:RY^`1VIWhU0>3Ohdh0YJbb00<0IVIn0:RY^`3ko?d00@1V
IWh0000306IVOP3gmoT0V9RW07D0MgNB0@2HV:L10?Ogn@40IVIn00000`1V
IWh0moOi0;bmc@1f0;bmc@40moOi0@1VIWh0000306IVOP3gmoT0i>?S07H0
i>?S0@3gmoT106IVOP0000<0IVIn0?3am03oool0;`3oool00`3Thn<0W:Bi
06]eS`0306]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3o
ool0oooo0>CSh`2LY;T406]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0
W:Bi0>CSh`3oool0oooo0>cZjP2LY;T40:HiA0040:LjA02V>D@0YcY40:Lj
A0T0YSU400<0W:Bi0>cZjP3oool00`3oool10?3am040IVIn00005P1VIWh0
h^7R0?_lo03kno`0nocm0?cko@3knod0nocm0?_lo03lo?d0o?cl0?cko@3l
o?`0o?_l0?clo03ko?`0o?cl0?_lo@3lno`0o?cm0?_ko@3ko?`20?clo004
0?clo@3lo?`0no_m0?cloA@0o?_l0P3ko?`00`2LY;T0JgF?08F9/00@08F9
/00606]eS`2LY;T0nocm0?_lo@2LY;T0JgF?4@25RK001P1[MHl0W:Bi0?_l
o03kno`0W:Bi0:HiA140ZSaE00L0YSU409bT^@3ko?`0o?cl0?cko@3ko?d0
h^7R0040IVIn0000101VIWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kgn03gmoT0
moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3gmoT0103g
m_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0moOi01<0moOi0P3fmoT0
0`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[MHl0QHV`
4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ3@36EE`0
2@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@0106IVOP00
00H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@000000060?7am03`l_D0lO7d
0?7bm03`l_@0lO7d5P3`lOD00`1[MHl0/[G@0:NX`P0@0:NX`P060;:ed01[
MHl0l?7d0?3am01[MHl0/[G@4@2WZ<801@2b]M00JgF?0?3am@3al_@0YSU4
0080`U9K00<0beAI0<eIGP3=FEh02`3=FEh0103;E5T0`U9K0<9BF`2V>D@2
0?3am0030?7am03`l_@0g]gQ0040IVIn00001`1VIWh0g=_P0>[[l03Zjo00
j^c`0>W[k`0000000P3WinL20=kNgP80inOW00<0ikf40>OWi`3WinL00`3W
inL20>o_k`040000003Zjo00j^_`0>[[k`80j^_`00<0j^__0>[[l03Zjo00
4P3Zjo020>[/l00406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk60:b^aP2]
[/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`0406]eS`2f^M40[Jk60:f^
aP`0oooo0P2][/H00`2/[/H0][WA06]eS`020>[[l0050:HiA03=FEh0beAI
0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK0<]DF@3=FEh0YSU40>[[k`3Zjo00
0P3Zjnl10=cKh040IVIn0000101VIWh0fMWO0>?UjP3Si>X20>?Uj`050000
002<S8`0g]kN0>OWi`3Ng]h00P3WinL00`36H`00inOW0>OWi`020>OWi`07
0>o_i`3_knl0kno_0000003Si>X0hnC[0>?UjP020>?TjP030>?Tj`3SiN/0
hnG[0180hnG[0P3Si>X01@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<0
9BDf0;:bbP2b//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bne080
/[;:00<0oooo02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[0>?T
j`2V>D@00P3=FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0e5aO
0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh00003
06IVOP3Gf=h0g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OFcP020>OW
i`050<ik003_U100inOW0>ONaP3_S1000`3_knl01`000000g=kV0=cNi@3L
g^D0g=kV0=cNi@3Lg^H05P3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo00H0
KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0JgF?
0;o1eP80^;W>00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;RicP02
0;RicP090;o1eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP00<0
oooo1@3FGf<30?ooo`0505<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D00`3L
g^H0g=kU0=OHgP0106IVOP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>002@00
0000S8b<0>OWi`3WinL0ikF40=IJ003FQ000olh00<iS00020=i[00050>ne
S03_knl0kno_0>o_k`0000000P3Ef>40103Een00e]SP0=KHh@3Fen4D0=KG
h080e]SP00D0JgF?0<?5f@2l_M40_;gA0?ooo`0702DU=PL0_;gA00H0`lGI
06]eS`3Ef>40eMSQ06]eS`33aMT20;bmd@030?ooo`0U9CH0_;gA00L0_;gA
00<0oooo02DU=P2l_M400P2l_M401@33aMT0JgF?0=KGh03Een40YSU40080
eEeP00<0f61Q0=UQHP167QX00`3oool30=UQHP<0oooo00<0AQhJ0=UQHP3H
H6400P3EGF001P2V>D@0e]SP0=GHh@3Een00eMSQ0=GFg@40IVIn00001`1V
IWh0d]CM0<oBg03@d]`0d=;M0=3Bg00000000`3WinL0303Wg/h0aTX00?O>
003_[@00kkD00<i[0036FP00aV/00=j<BP3WY@00knO>000000<0d=;L00<0
cm;L0=3Bg03?d]`0503@d]`20<oBg@0306]eS`38bM/0`lCF0100`lCF00H0
b<WK06]eS`3@d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U9CH0`lCF00L0
`lCF00<0oooo02DU=P33a=H00P33a=H01`38bM/0JgF?0<oBg03?d]`0YSU4
0=MOG`3IHF800`3LIFD01@167QX0oooo0?ooo`3oool0g6EU00<0oooo00P0
AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?d]`10=;D
g@40IVIn0000701VIWh0d=;K0<_=f03:cMT0blkH0<[=f0000000ilJ]0>O6
S03gcQP0kkd00?O6003_[@00ijd00>NU003FS000cV/00>O6003oeP00knoW
0>o_k`000000blgH0<_=f@3:cMT0blkH0<[=f03;cMPD0<_=f@80blkI00<0
JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38
b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:
f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;
c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?oo
o`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH
0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P00
0000a/K60>ONeP3>N`00ijd00>ne0080ijD000<0eY@00<ic003FU0000P3g
aP020?Ogm`0400000035b=@0aLOD0<G7e0<0aLOE5034amD20<C8e00306]e
S`3@dN00bl_L0100bl_L00H0d=7P06]eS`34am@0a<OD06]eS`3@dN020<_;
g0030?ooo`0U9CH0bl_L00L0bl_L00<0oooo02DU=P3;bm`00P3;bm`01`3@
dN00JgF?0<G7e034am@0YSU40=]TI03OIF@01@3PJVP01@167QX0oooo0?oo
o`3oool0AQhJ00D0h6YX00@0gfET0=]TI02V>D@0a<SE0P34b=@10<G7e@40
cloJ0@1VIWh0000406IVOP3<c]X0`/CB0<74d@80`LCB00H000000>OWi`3W
inL0inOW0=J4003_]@020>NU00080=J4003>J`00ijd00?Ne003g_@00kno_
0?Ogm`0000030<74dP030<;4d@31a=80`LCB01@0`LCA0P31a=800`1[MHl0
dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?d=d0
0`3oool09BDf0<o@g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M00L0dm?R
06]eS`32a=80`LCA0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/J@080>5Y
I@3KI6@0YSU40<74dP32a=40`LCA0<74dP3<c]X106IVOP0000@0IVIn0<[<
f02n`<l0_L3?0P2n`<h01@000000W9bL0>OWi`3Wg]H0eX`00080gY@000@0
eW/00<IS002m@P00kjD00P3g[@00203g]@00oli:0000002n`<h0_/3?0;k0
cP2n`<l0_L3>5@2n`<h20;g0cP0306]eS`3Fe^@0dm?P0100dm?P00H0e]KT
06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo00P0oooo
00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0h6IU0>5Z
JP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo103SK6`0103QJVX0h6IU
0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:f02f^<P0
^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<003NU000eX@00>nU003N
S000_EX00=Ic003_W000mnoW0?Ogm`3oool000000;Vlc02j^l`0^Kc;0;Zl
b`2i_<`0^Kc;01@0^Kc<0P2j_<`00`1[MHl0f=SU0=?Ch@0@0=?Ch@060=SH
i@1[MHl0^[c;0;Zlb`1[MHl0f=SU0P3Cdn400`3oool0KVf?06i]S`0806i]
S`0>02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0JgF?0;Zlb`2j_<`0YSU40>1YJ03Q
KF`0i75]0>AaK`3TL6h30?ooo`0304HN6P3TL6h0AQhJ00<0oooo0P3TL6h0
2@3TLFd0hFe/0>1YJ02V>D@0^[c<0;Zkc02i_</0][S80<W:f00106IVOP00
00T0IVIn0<O9e`2d]/L0][S80;Jhb@2f^LT0000008B4Q03Wimh00P3_knl0
1`36J`00mlH00>ne003_W000gX`00<i[003WW0000`3gmoL01@000000][W9
0;Nhb@2f^LT0]kW90080][S9502g^<T20;Jhb@0406]eS`3Fe^@0f=SU0=SH
iP<0f=SU1@3Hf>H30=SHi@80f=SV0P3Hf>D02@3Fe^@0JgF?0;Nhb@2g^<T0
JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]S`0=02DU=P3Hf>H0f=SU0=SHi@3F
e^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3TM6l0ig5_0>AdK`030?ooo`0504HN
6P3TM6l0i7A_0>AdK`167QX00`3oool02P3TM6l0ig5_0>AdK`3TKVd0YSU4
0;Jib@2f^<T0][W90;Bfa`37bML106IVOP0000<0IVIn0<K8e`2d]/L00`2d
]/L00`000000kno_0>o_k`020>o_k`0;0>N]003gaPP0ijD00>ND003WS000
knOF0=jD>@3_e[D0ooOg0?ooo`000000702d]/L01@1[MHl0eMGS0=cKi`3L
fnL0gM_W00h0g=_W00H0eMGS06]eS`2d]/L0];K706]eS`3EeN<20=cKi`03
0=gKi`0U9CH09BDf00T09BDf0`3LfnL02@3EeN<0JgF?0;Bfa`2d]/L0YSU4
0>McK`3WMG80jWIc0>YhMP020?ooo`0304HN6P3YOWP0jGih00<0jGih00P0
AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80ig=_0:HiA0@0];K70@36b=L106IV
OP0000<0IVIn0<K8e`2d]/L00`2d]/L01P000000S8b<0>o_k`3_knl0ilik
0>o_k`80moOg00P0ii@00?OWcP3gmoL0moOg0>oWeP3gmoL0oooo000001`0
];K700<0JgF?0=GDh`3PgnX0403PgnX01P3Ee><0JgF?0;Bfa`2d]/L0JgF?
0=GDha40h=oZ00T0eMCS06]eS`2d]/L0];K70:HiA03ZNG<0jGah0>n1NP3b
RH400P167QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<0>fGRP3[V8/00P167QX0
1@3bRH40kh5j0>UlN03ZNG<0YSU400@0];K70@36b=L106IVOP0000<0IVIn
0<K8e`2a/lP00`2a/lP01P000000kno_0>o_k`3_knl0moO_0>o_k`80moOg
00<0mnO60?Ogm`3oool00`3gmoL00`3oool000000;6cb00K0;6cb00306]e
S`3]jo<0jNSa0100jNSa00H0kN_c06]eS`2a/lP0/K?806]eS`3]jo<A0>WX
l@0I0>g[l`1[MHl0/K?80;6cb02V>D@0lH1e0?24O03eS8@0mif>0?:[UP3a
/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03bZiH0mif>0?F<
Q03`Q7`0lH1e0:HiA0040;6cb040a/SG0@1VIWh0000306IVOP36b=L0^;O?
00<0[jk700D000000:f][@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3oool0
0`000000[jk70:n^a`0J0:n^a`0306]eS`3BdN<0l_7g0100l_7g00H0d]7S
06]eS`2_[/L0[jk706]eS`3BdN<A0?;am`060=;Ah`1[MHl0[jk70:n^a`2V
>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0m8Ym0:HiA02_[/L00P2_[/L10;Rg
c`40a/SG0@1VIWh0000306IVOP30`M40alOD02l0[:_400@0Q8bR06]eS`3<
bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a00408B<XP1[MHl0
c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01`2AV:X0YSU4
0?nOS@3n_j@0n]bg0?[[]`3jjKH00P3ijKH0103jjKH0nNVf0?WY]P3jjKH2
0?WY]P060?[[]`3jg;L0o[nT0?nOS@2V>D@0TIRZ0`2/Zl@10<O7e040`<7A
0@1VIWh0000406IVOP30`M40d];O0;FdbBl0Y:>n00<0Q8bR06]eS`1[MHl0
3`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP1[MHl0JgF?00l0JgF?
00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80YSU40:HiA00?0:HiA00708B<
XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31d@0106IVOP0000H0IVIn0:RW_`3V
i^d0d];P0;blc`2a/<A_0:RW_`050;6`a02l_<l0d];P0>KVk@2XYkl00@1V
IWh0000705QGJ027Qi/0emSR0?clo03ThnP0d=3P0<[:fP1]0;blc`060<[:
fP3@d>00i>?X0?clo03Gf>80QhNK0@1HEfP0000805QGJ01VIWh0UIB[0=OH
hP3lo?`0l_7c0>c[kP3Qh^][0=OHhP070>7Rj`3/jnh0l_7c0?clo03Gf>80
UIB[06IVOP0105QGJ0000P1HEfP00`1VIWh0UIB[0=7AgP020?clo6d0oooo
0P3lo?`00`3AdMh0UIB[06IVOP0205QGJ0000`1HEfP206IVOP0308R7W@2E
U:/0Z:No06`0Z:No00@0UIB[08R7W@1VIWh0IVIn0`1HEfP000D0F5MXL@1V
IWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[7]:=",
  Evaluatable->False,
  ImageSize->{123, 77},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Images"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[7]=",
  CellTags->"Images"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      RowBox[{"ref", " ", "=", " ", 
        RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
          RowBox[{
            StyleBox["Widget",
              "Output"], "[", 
            RowBox[{"\"\<Panel\>\"", ",", 
              RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                  RowBox[{
                    StyleBox["Widget",
                      "Output"], 
                    "[", \("\<Label\>", {"\<text\>" -> "\<Sample Plot\>"}\), 
                    "]"}], ",", "\[IndentingNewLine]", 
                  RowBox[{
                    StyleBox["Widget",
                      "Output"], 
                    "[", \("\<ImageLabel\>", {\[IndentingNewLine]"\<data\>" \
\[Rule] \ Script[ExportString[\ 
                            Plot3D[Sin[x\ y], {x, 0, Pi}, {y, 0, Pi}, \ 
                              DisplayFunction \[Rule] 
                                Identity], \ "\<GIF\>", \ \ ConversionOptions \
\[Rule] {"\<Transparency\>" \[Rule] GrayLevel[1]}]]\ }\), "]"}]}], 
                "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
          "]"}]}], ";"}]], "Input",
  CellLabel->"In[8]:=",
  CellTags->"Images"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"Images"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004X00017B000`400?l0
0000o`00003oo`1VIWhY06IVOP0000<0IVIn0?_lo@3ko?d0o`3ko?dU0?_l
o@40IVIn00000`1VIWh0nocm0:RY^`3o0:RY^b@0Z:Vk0@3ko?d106IVOP00
00<0IVIn0?_lo@2XZK/0o`1VIWhS06IVOP40Z:Vk0@3ko?d106IVOP0000@0
IVIn0?_lo@2XZK/0IVIno`3Pgn<Q0>3Oh`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWko0>3Ohb40h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS8@3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<Q0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Ohb40h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[h0h=oS
0P00001P0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWjm0>3Oh`040000003Pgn<0h=oS00000100h=oS0P00001=0>3Oh`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjo0>3Oh`03
0000003Pgn<0h=oS00h0h=oS00@000000>3Oh`3Pgn<00000C03Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn`03Pgn<00`00
0000h=oS0>3Oh`0=0>3Oh`040000003Pgn<0h=oS000004`0h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO[d0h=oS00@00000
0>3Oh`3Pgn<000003`3Pgn<010000000h=oS0>3Oh`00001<0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjn0>3Oh`800000
403Pgn<010000000h=oS0>3Oh`00001<0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWkA0>3Oh`800000C@3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInbP3Pgn<2000005@0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO/P0
h=oS1@00001C0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWk50>3Oh`<000000`3Pgn<2000005<0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO/<0h=oS0P0000060>3Oh`03
0000003Pgn<000000580h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVO/00h=oS100000070>3Oh`040000003Pgn<0h=oS0000
0540h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
O[d0h=oS0`0000030>3Oh`030000003Pgn<0h=oS00D0h=oS00@000000>3O
h`3Pgn<00000D@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn^`3Pgn<2000000h0h=oS00D000000>3Oh`3Pgn<0h=oS0000
001@0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWjh0>3Oh`<00000403Pgn<00`000000h=oS0>3Oh`020>3Oh`030000003P
gn<0h=oS04d0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVO[H0h=oS0P00000C0>3Oh`030000003Pgn<0h=oS0080h=oS00<0
00000>3Oh`3Pgn<0C@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn/`3Pgn<3000000030>3Oh`000000h=oS01<0h=oS00@0
00000>3Oh`3Pgn<0h=oS0P00001>0>3Oh`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWja0>3Oh`8000006@3Pgn<00`000000h=oS
0>3Oh`030>3Oh`030000003Pgn<0h=oS04/0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOZh0h=oS0`00000K0>3Oh`030000
003Pgn<0h=oS00<0h=oS00<000000>3Oh`3Pgn<0B`3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn[03Pgn<2000001h0h=oS
00<000000>3Oh`3Pgn<0103Pgn<00`000000h=oS0>3Oh`1:0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWjY0>3Oh`<00000
803Pgn<00`000000h=oS0>3Oh`040>3Oh`030000003Pgn<0h=oS04X0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOZH0h=oS
0`0000020>3Oh`030000003Pgn<0h=oS01h0h=oS00<000000>3Oh`3Pgn<0
1@3Pgn<00`000000h=oS0>3Oh`190>3Oh`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWjT0>3Oh`8000009P3Pgn<00`000000h=oS
0>3Oh`060>3Oh`030000003Pgn<0h=oS04P0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX00h=oS1000000M0>3Oh`<00000
:03Pgn<00`000000h=oS0>3Oh`060>3Oh`030000003Pgn<0h=oS04P0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOX00h=oS
00<000000>3Oh`3Pgn<0703Pgn<2000002/0h=oS00<000000>3Oh`3Pgn<0
1`3Pgn<00`000000h=oS0>3Oh`170>3Oh`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWj10>3Oh`030000003Pgn<0h=oS01P0h=oS
0`00000]0>3Oh`030000003Pgn<0h=oS00L0h=oS0P0000180>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj20>3Oh`030000
003Pgn<0h=oS01D0h=oS0P0000030>3Oh`030000003Pgn<0h=oS02X0h=oS
00<000000>3Oh`3Pgn<0203Pgn<00`000000h=oS0>3Oh`160>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj00>3Oh`040000
003Pgn<0h=oS000001<0h=oS0`00000b0>3Oh`030000003Pgn<0h=oS00T0
h=oS00<000000>3Oh`3Pgn<0A@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInP@3Pgn<200000140h=oS0`00000e0>3Oh`03
0000003Pgn<0h=oS00X0h=oS00<000000>3Oh`3Pgn<0A03Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInTP3Pgn<2000003P0
h=oS00<000000>3Oh`3Pgn<02P3Pgn<00`000000h=oS0>3Oh`140>3Oh`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWj?0>3Oh`<0
000000<0h=oS0000003Pgn<0=`3Pgn<00`000000h=oS0>3Oh`0;0>3Oh`03
0000003Pgn<0h=oS04<0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOXd0h=oS0P00000m0>3Oh`030000003Pgn<0h=oS00`0
h=oS00<000000>3Oh`3Pgn<0@P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInRP3Pgn<300000400h=oS00<000000>3Oh`3P
gn<02`3Pgn<00`000000h=oS0>3Oh`120>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWj80>3Oh`800000@`3Pgn<00`000000
h=oS0>3Oh`0;0>3Oh`800000@`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInQ@3Pgn<3000004D0h=oS00<000000>3Oh`3P
gn<03@3Pgn<00`000000h=oS0>3Oh`100>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWj30>3Oh`8000000`3Pgn<00`000000
h=oS0>3Oh`120>3Oh`030000003Pgn<0h=oS00d0h=oS00<000000>3Oh`3P
gn<0@03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVInP03Pgn<3000004X0h=oS00<000000>3Oh`3Pgn<03P3Pgn<00`000000
h=oS0>3Oh`0o0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWim0>3Oh`<00000C@3Pgn<00`000000h=oS0>3Oh`0?0>3Oh`03
0000003Pgn<0h=oS03h0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOW/0h=oS0P00001@0>3Oh`030000003Pgn<0h=oS00l0
h=oS00<000000>3Oh`3Pgn<0?P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInN03Pgn<3000000030>3Oh`000000h=oS04h0
h=oS0P00000B0>3Oh`030000003Pgn<0h=oS03d0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWH0h=oS0P00001B0>3Oh`80
000000<0UgV`0000003Pgn<04P3Pgn<00`000000h=oS0>3Oh`0l0>3Oh`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`<0
0000D@3Pgn<3000000<0UgV`0P00000B0>3Oh`800000?@3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInL@3Pgn<200000540
h=oS0`00000609Mi/08000004P3Pgn<2000003d0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOVh0h=oS1000001?0>3Oh`<0
000000<0Ug^c0000002GNK001P2GNK02000001<0h=oS00<000000>3Oh`3P
gn<0>`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVInK03Pgn<200000500h=oS0`00000309Mi/00309Mk/`000000UgV`00H0
UgV`0P00000D0>3Oh`030000003Pgn<0h=oS00D0h=oS1@00000`0>3Oh`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWi90>3Oh`D0
00006`3Pgn<3000004l0h=oS0`0000001@2GNk<0UgV`09Mk/`2GNK00Ug^c
00<0UgV`00<0000009Mi/02GNK00102GNK000`000000UgV`0000000D0>3O
h`030000003Pgn<0h=oS00H0h=oS00<000000>3Oh`3Pgn<0<03Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInB`3Pgn<00`00
0000h=oS0>3Oh`0H0>3Oh`<00000D03Pgn<20000000309Mi/0000000Ug^c
00D0UgV`00@0Ug^c09Mi/02GNk<000001P2GNK000`000000UgV`0000000D
0>3Oh`030000003Pgn<0h=oS00H0h=oS00<000000>3Oh`3Pgn<0<03Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInB`3Pgn<0
0`000000h=oS0>3Oh`0F0>3Oh`<00000C`3Pgn<300000080UgV`00P0VGjd
09Mi/0000000Ug^c09Mi/02GNk<0UgV`09Mk/`<0UgV`00<0000009Mi/02G
NK00102GNK000`000000UgV`0000000E0>3Oh`030000003Pgn<0h=oS00D0
h=oS00<000000>3Oh`3Pgn<0<03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInB`3Pgn<00`000000h=oS0>3Oh`0C0>3Oh`<0
00000P3Pgn<00`000000h=oS0>3Oh`1:0>3Oh`<0000000P0UgV`09Un]02G
NK00VGjd09Mi/02IO[@0UgV`000000D0UgV`00@0Ug^c09Mi/02GNk<00000
1P2GNK000`000000UgV`0000000F0>3Oh`030000003Pgn<0h=oS00@0h=oS
00<000000>3Oh`3Pgn<0<03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVInB`3Pgn<00`000000h=oS0>3Oh`0A0>3Oh`800000
D03Pgn<20000000309Un]0000000UgV`0080UgV`00/0VGjd09Mi/02GNK00
VGjd09Mi/0000000Ug^c09Mi/02GNk<0UgV`09Mk/`0209Mi/00309Mk/`2G
NK00000000H0UgV`00<0000009Mi/00000005@3Pgn<2000000@0h=oS0P00
000b0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWi:0>3Oh`800000403Pgn<3000004l0h=oS0`0000002P2IO[@0Ug^c09Un
]0000000UgV`09Un]02GNK00VGjd09Mi/02IO[@209Mi/0030000002GNk<0
UgV`00<0UgV`00D0Ug^c09Mi/02GNK00Ug^c0000000609Mi/0030000002G
NK00000001@0h=oS0`00000h0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWiJ0>3Oh`800000C`3Pgn<30000000409Un]02G
Nk<0VGjd09Mk/`<0VGjd00@0000009Mi/02GNK00VGjd0P2GNK001`2IO[@0
UgV`09Un]0000000Ug^c09Mi/02GNk<00P2GNK00102GNk<0UgV`09Mi/000
000609Mi/0030000002GNK00000001L0h=oS00<000000>3Oh`3Pgn<0=@3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInE`3P
gn<300000080h=oS00<000000>3Oh`3Pgn<0BP3Pgn<20000000609V0]P00
0000VGjd09Mk/`2IO[@0Ug^c0P2IO[@02@2GNk<0VGjd0000002GNK00VGjd
09Mi/02IO[@0UgV`09Un]00209Mi/0030000002GNK00UgV`0080UgV`00D0
Ug^c09Mi/02GNK00Ug^c0000000609Mi/0040000002GNK00UgV`000001H0
h=oS00<000000>3Oh`3Pgn<0=@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInE@3Pgn<2000004l0h=oS0`000000102IP;H0
VGjd09V0]P00000209Un]00309Mk/`2IO[@0Ug^c00<0VGjd00@0000009Mi
/02GNK00VGjd0P2GNK001`2IO[@0UgV`09Un]0000000Ug^c09Mi/02GNk<0
0`2GNK00102GNk<0UgV`09Mi/000000509Mi/0040000002GNK00UgV`0000
01L0h=oS00<000000>3Oh`3Pgn<0=03Pgn<00`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVInDP3Pgn<3000004h0h=oS0`0000002`2I
P;H0VGjd09V0]P2IO[@0VH2f09Un]02IP;H0000009Mk/`2IO[@0Ug^c0080
VGjd00<0Ug^c09Un]00000000P2GNK001@2IO[@0UgV`09Un]02GNK00VGjd
0080UgV`00H0000009Mi/02GNK00Ug^c09Mi/02GNk<209Mi/00309Mk/`00
0000UgV`00@0UgV`00@0000009Mi/02GNK000000603Pgn<00`000000h=oS
0>3Oh`0c0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWi?0>3Oh`<00000C`3Pgn<20000000?09V0]P000000VH2f09Un]02I
P;H0VGjd09V0]P2IO[@0VH2f09Un]0000000VGjd09Mk/`2IO[@0Ug^c0080
VGjd00D0Ug^c09Un]0000000UgV`09Un]00209Mi/00609Un]02GNK00UgV`
09Un]0000000Ug^c102GNK00102GNk<0UgV`09Mi/000000509Mi/0040000
002GNK00UgV`000001P0h=oS00<000000>3Oh`3Pgn<0<`3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInC@3Pgn<200000003
0>3Oh`000000h=oS04`0h=oS0`00000409V0]P0<0000002IP;H0VGjd09V0
]P2IO[@0VH2f09Un]02IP;H0000009Mk/`2IO[@0Ug^c0P2IO[@0102GNk<0
VGjd09Un]000000209Mi/00<09Un]02GNK00VGjd09Mi/02IO[@0UgV`0000
002GNk<0UgV`09Mk/`2GNK00Ug^c0P2GNK000`2GNk<0000009Mi/00409Mi
/0050000002GNK00UgV`09Mi/0000000603Pgn<00`000000h=oS0>3Oh`0b
0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWi:
0>3Oh`<00000103Pgn<00`000000h=oS0>3Oh`170>3Oh`<000001`2IP;H0
3@000000VH2f09Un]02IP;H0VGjd09V0]P2IO[@0VH2f0000002IO[@0Ug^c
09Un]02GNk<00P2IO[@03P2GNk<0VGjd0000002GNK00VGjd09Mi/02IO[@0
UgV`09Un]02GNK00VGjd09Mi/0000000Ug^c102GNK00102GNk<0UgV`09Mi
/000000409Mi/0030000002GNK00000000800000603Pgn<2000003<0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTP0h=oS
0P00001?0>3Oh`80000000<0VX:h0000002IP;H01`2IP;H030000000VGjd
09V0]P2IO[@0VH2f09Un]02IP;H0VGjd09V0]P000000VGjd09Mk/`80VGjd
00@0Ug^c09Un]02IO[@000000`2GNK001`2IO[@0UgV`09Mi/02GNK00VGjd
09Mi/00000000P2GNK000`2GNk<0UgV`09Mk/`0209Mi/00409Mk/`000000
UgV`09Mi/0@000000P2FO;D00`000000h=oS0>3Oh`0G0>3Oh`030000003P
gn<0h=oS0340h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOTD0h=oS0`00001>0>3Oh`<00000102JP[P00`000000VH2f09V0
]P0509V0]P0:0000002IP;H0VGjd09V0]P2IO[@0VH2f09Un]02IP;H0VGjd
00000080VGjd00@0Ug^c09Un]02IO[@0Ug^c0P2IO[@010000000UgV`09Un
]02GNK0209Un]00509Mi/02IO[@0UgV`0000002GNk<0102GNK0209Mk/`@0
00000P2FO;D00`000000UWbe09Il]@0209Il]@030000003Pgn<0h=oS01L0
h=oS00<000000>3Oh`3Pgn<0<03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn@`3Pgn<2000000030>3Oh`000000h=oS04/0
h=oS0`00000709Z2^0030000002IP;H0VH2f00H0VH2f00/0000009V0]P2I
O[@0VH2f09Un]02IP;H0VGjd09V0]P000000VGjd09Mk/`0209Un]00509Mk
/`2IO[@0VGjd09Un]0000000202GNK0010000000UgV`09Mk/`2GNK0209Mk
/`80000000<0UWjg0000002FO;D00`2FO;D00`000000UWbe09Il]@0209Il
]@030000003Pgn<0h=oS01P0h=oS00<000000>3Oh`3Pgn<0;`3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn@03Pgn<30000
04h0h=oS0P000000102JQ;X0000009Z4^P2JQ;X609Z2^0030000002IP;H0
VH2f00H0VH2f00T0000009V0]P2IO[@0VH2f09Un]02IP;H0VGjd09V0]P00
00000P2IO[@0202GNk<0VGjd09Un]02GNk<0VGjd09Mk/`000000Ug^c202G
NK000`000000Ug^c000000020000000509In]`2FO;D0UWjg09Il]@000000
0`2FO;D00`000000UWbe09Il]@0209Il]@030000003Pgn<0h=oS01P0h=oS
00<000000>3Oh`3Pgn<0;`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn?@3Pgn<3000004h0h=oS0`00000409Z4^P030000
002JP[P0VX:h00D0VX:h00<0000009V0]P2IP;H01P2IP;H010000000VH2f
09Un]02IP;H209Un]00509V0]P2IO[@0VH2f0000002GNk<00P2IO[@01@2G
Nk<0VGjd09Mk/`2IO[@0000000L0Ug^c10000000202FO[L0UWbe09In]`2F
O;D0UWjg09Il]@2FO[L000000`2FO;D00`000000UWbe09Il]@0309Il]@03
0000003Pgn<0h=oS01P0h=oS00<000000>3Oh`3Pgn<0;P3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn>`3Pgn<2000004h0
h=oS0`00000709Z4^P030000002JQ;X0VX:h00H0VX:h00<0000009V0]P2I
P;H01@2IP;H010000000VH2f09V0]P2IO[@309V0]P0509Un]02IP;H00000
09Un]02GNk<00P2IO[@01@2GNk<0VGjd09Mk/`2IO[@000000080Ug^c1000
000209In]`0:0000002FO[L0UWbe09In]`2FO;D0UWjg09Il]@2FO[L0UWbe
000000<0UWbe00<0000009Il]@2FO;D00`2FO;D00`000000h=oS0>3Oh`0I
0>3Oh`030000003Pgn<0h=oS02d0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOSP0h=oS0`0000000`3Pgn<000000>3Oh`1;
0>3Oh`80000000<0VhJk0000002KQ[/01`2JQ;X00`000000VX:h09Z2^005
09Z2^00309Z4^P000000VH2f00L0VH2f00<0000009Un]02IP;H0102IO[@0
0`2IP;H0000009Mk/`0209Un]00409Mk/`2IO[@0Ug^c09V0]P@000001P2F
O[L02P000000UWjg09In]`2FO;D0UWjg09Il]@2FO[L0UWbe09In]`000003
09Il]@030000002FO;D0UWbe00<0UWbe00<000000>3Oh`3Pgn<06@3Pgn<2
000002h0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOQL0h=oS0P00000M0>3Oh`800000CP3Pgn<3000000@0VhJk00<00000
09^6^`2JQ;X01@2JQ;X00`000000VXBj09V0]P0609Z2^0030000002IP;H0
VH2f00H0VH2f00<0000009V0]P2IO[@0102IP;H0102IO[@0000009Un]02G
Nk<309Un]080000000<0UWjg0000002FO[L0202FO[L02P000000UWjg09Il
]@2FO[L0UWbe09In]`2FO;D0UWjg09Il]@00000309Il]@030000002FO;D0
UWbe0080UWbe00<000000>3Oh`3Pgn<06@3Pgn<2000002h0h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQH0h=oS00@00000
0>3Oh`3Pgn<000006@3Pgn<3000004d0h=oS0`00000709^6^`030000002J
Q;X0VXBj00H0VXBj00<0000009Z4^P2JP[P0102JP[P00`2JQ;X0000009V0
]P0709V0]P030000002IO[@0VH2f00D0VGjd00<0VH2f0000002IP;H00`00
000409In]`030000002FO[L0UWjg00H0UWjg00X0000009Il]@2FO[L0UWbe
09In]`2FO;D0UWjg09Il]@2FO[L000000`2FO;D00`000000UWbe09Il]@03
09Il]@030000003Pgn<0h=oS01T0h=oS00<000000>3Oh`3Pgn<0;03Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn5P3Pgn<0
10000000h=oS0>3Oh`00000G0>3Oh`800000C03Pgn<40000000309b8_@00
0000VhJk00L0VhJk00<0000009^6^`2KQ[/01P2JQ;X00`000000VXBj09Z4
^P0509Z2^00309Z4^P000000VH2f00H0VH2f00<0000009V0]P2IO[@01@2I
P;H3000000L0UWjg00<0000009In]`2FO[L01P2FO[L02P000000UWjg09Il
]@2FO[L0UWbe09In]`2FO;D0UWjg09Il]@00000309Il]@030000002FO;D0
UWbe00<0UWbe00<000000>3Oh`3Pgn<05`3Pgn<2000000030>3Oh`000000
h=oS02`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOQH0h=oS00@000000>3Oh`3Pgn<00000503Pgn<3000000030>3Oh`00
0000h=oS04L0h=oS1000000609b8_@030000002KQ[/0VhJk00H0VhJk00<0
000009Z4^P2JQ;X01@2JQ;X00`000000VXBj09Z2^00409Z2^00309V0]P2J
Q;X0000000P0VH2f00<0000009V0]P2IP;H0100000000`2GP[/0000009In
]`0709In]`030000002FO[L0UWjg00H0UWjg00/0000009In]`2FO;D0UWjg
09Il]@2FO[L0UWbe09In]`2FO;D0UWjg0000000209Il]@030000002FO;D0
UWbe00<0UWbe00<000000>3Oh`3Pgn<05P3Pgn<00`000000O>K?0:g`Z`03
000002`0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOQH0h=oS00@000000>3Oh`3Pgn<000004P3Pgn<2000004/0h=oS0P00
00000`2MRkl0000009f;_`0709b8_@030000002KQ[/0VhJk00H0VhJk00<0
000009^6^`2JQ;X01P2JQ;X01@000000VXBj09V0]P2JQ;X0VH2f00<0VXBj
00<0000009V0]P2IP;H01@2IP;H4000000H0UWjg00<0000009In]`2FO[L0
1P2FO[L00`000000UWjg09In]`0609In]`0:0000002FO[L0UWbe09In]`2F
O;D0UWjg09Il]@2FO[L0UWbe00000080UWbe00<0000009Il]@2FO;D0102F
O;D00`000000h=oS0>3Oh`0D0>3Oh`80000000D0[O2[000000000000_N7a
0000000/0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWhG0>3Oh`800000403Pgn<3000004/0h=oS0P00000409f;_`030000
002LR;d0W8Rm00D0W8Rm00<0000009^6^`2KQ[/01P2KQ[/00`000000VXBj
09Z4^P0609Z4^P030000002JQ;X0VXBj00<0VXBj00<0VH2f09Z4^P000000
1@2IP;H20000000;09N2^`000000UWjg09N2^`2FO[L0Uh:k09In]`2GP[/0
UWjg09N2^`000000202FO[L00`000000UWjg09In]`0609In]`0:0000002F
O;D0UWjg09Il]@2FO[L0UWbe09In]`2FO;D0UWjg00000080UWbe00<00000
09Il]@2FO;D0102FO;D00`000000h=oS0>3Oh`0B0>3Oh`D000000`2mhO42
000002/0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVORH0h=oS0`00001;0>3Oh`<000001P2MRkl00`000000WH^o09f;_`06
09b8_@030000002KQ[/0VhJk00D0VhJk00<0000009^6^`2JQ;X01P2JQ;X0
1@000000VXBj09V0]P2JQ;X0VH2f00@0VXBj00<0000009V0]P0000000P00
000409N2^`030000002FO[L0UWjg00D0UWjg00<0000009In]`2FO[L01P2F
O[L00`000000UWjg09In]`0609In]`060000002FO[L0UWbe09In]`2FO;D0
UWjg0P2FO;D01@2FO[L0UWbe0000002FO;D0000000H0UWbe00<000000>3O
h`3Pgn<04@3Pgn<4000000H0_N7a0P00000Z0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWhT0>3Oh`8000000P3Pgn<00`00
0000h=oS0>3Oh`170>3Oh`80000000<0WHk30000002MRkl01`2MRkl00`00
0000W8Rm09b8_@0509b8_@030000002KQ[/0VhJk00H0VhJk00<0000009Z4
^P2JQ;X01@2JQ;X00`000000VXBj09Z4^P0509Z4^P<000001`2GP[/01`00
0000UWjg09N2^`2FO[L0Uh:k09In]`2GP[/00P2FO[L00`000000UWjg09In
]`0509In]`030000002FO[L0UWjg00H0UWjg00H0000009In]`2FO[L0UWbe
09In]`2FO;D209In]`0509Il]@2FO[L0000009Il]@0000001`2FO;D00`00
0000h=oS0>3Oh`0?0>3Oh`@000001`2mhO43000002T0h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOR40h=oS0`00001;0>3O
h`<00000102MS/<00`000000WH^o09f;_`0509f;_`030000002MRkl0W8Rm
00D0W8Rm00<0000009^6^`2KQ[/01P2KQ[/00`000000VXBj09Z4^P0309Z4
^P0409^6^`2JQ;X0VXBj00000080VXBj100000000`2GP[/0000009N2^`07
09N2^`030000002FO[L0UWjg00D0UWjg00<0Uh:k0000002FO[L01`2FO[L0
0`000000UWjg09In]`0609In]`040000002FO[L0UWjg09In]`<0UWbe0P2F
O[L3000000H0UWbe0P00000@0>3Oh`D0000000<0`NWa0;gQl@2mhO400P2m
hO400`31jO40_m[]00000002000002T0h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOQl0h=oS0P00001;0>3Oh`<000001`2M
S/<00`000000WH^o09f;_`0509f;_`030000002MRkl0W8Rm00D0W8Rm00<0
000009^6^`2KQ[/01P2KQ[/00`000000VXBj09Z4^P0309Z4^P0309N7_`2J
Q;X0000000<000001P2GP[/00`000000Uh:k09N2^`0509N2^`070000002F
O[L0Uh:k09In]`2GP[/0UWjg09N2^`0209In]`030000002FO[L0UWjg00H0
UWjg00<0000009In]`2FO[L01P2FO[L00`000000UWbe09Il]@0209Il]@03
09V0]P2FO[L00000008000000P2FO;D00`000000UWbe09Il]@0300000003
09J7`@000000h=oS00h0h=oS1P0000000`2mhO40_m[]0<7Yl@0400000004
09nQe@000000h=oS000002P0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOQd0h=oS0P00001;0>3Oh`80000000<0Wi?70000
002MS/<01`2MS/<00`000000WH^o09f;_`0609f;_`030000002MRkl0W8Rm
00D0W8Rm00<0000009^6^`2KQ[/01P2KQ[/00`000000VXBj09Z4^P040000
000309N7_`000000Uh:k00L0Uh:k00<0000009N2^`2GP[/01P2GP[/00`00
0000UWjg09In]`0409In]`0309N2^`2FO[L0000000L0UWjg00<0000009In
]`2FO[L01P2FO[L010000000VH2f09Il]@2IP;H30000000509V0]P2FO;D0
VH2f0000002FO;D00`0000001P2FQl40VH_309J7`@2IRl<0UXO1000000`0
h=oS2`00000609nQe@800000:03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn7@3Pgn<3000004P0h=oS0P0000001@2MS/<0
Wi?709f>``2OTlL0000000P0WHk300<0000009f;_`2MRkl01@2MRkl00`00
0000W8Rm09b8_@0509b8_@030000002KQ[/0VhJk00D0VhJk100000000`2F
Ql40VXBj09N7_`0209Z4^P0309N7_`000000Uh:k00H0Uh:k00<0000009N2
^`2GP[/01P2GP[/01P000000Uh:k09In]`2GP[/0UWjg09N2^`80UWjg00<0
Uh:k0000002FO[L01`2FO[L00`000000UWjg09In]`0509In]`@0000000@0
UWbe09V0]P2FO;D0VH2f100000001P2FQl40000009J7`@2IRl<0UXO109V;
``80UXO100<000000>3Oh`3Pgn<02@3Pgn<800000080/<3V00<0000009nQ
e@2OXMD01@2OXMD00`000000h=oS0000000W0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWhM0>3Oh`<00000A@3Pgn<30000
000709nCa`2MS/<0Wi?709f>``2OTlL0WHk30000000809f>``030000002M
Rkl0WH^o00D0WH^o00<0000009f;_`2LR;d01@2LR;d00`000000VhJk09^6
^`0309^6^`80000000<0W8Rm0000002GQkl0102JQ;X0102FQl40VXBj09Z4
^P00000709N2^`030000002GP[/0Uh:k00H0Uh:k00<0000009In]`2FO[L0
102FO[L00`2GP[/0UWjg0000000809In]`030000002FO[L0UWjg0080UWjg
00<0VH2f0000000000000P0000000`2IP;H0UWbe000000030000000309J7
`@2IRl<000000080UXO100P0VH_30000002FQl40VH_309J7`@2IRl<0UXO1
000000X0h=oS200000030;30iP030000002OXMD0Wj7E00H0Wj7E00<00000
0>3Oh`0000009P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn5@3Pgn<5000000<0h=oS00@000000>3Oh`3Pgn<00000@P3P
gn<20000000:09nCa`000000Wi?709f>``2OTlL0WHk309nCa`2MS/<0Wi?7
000000P0WHk300<0000009f;_`2MRkl01P2MRkl00`000000W8Rm09b8_@03
09b8_@0409f;_`2LR;d0000009^6^`<00000102GQkl01@000000VXBj09N7
_`2JQ;X0UXO10080VXBj00<0UhNo0000002GP[/01`2GP[/00`000000Uh:k
09N2^`0509N2^`060000002GP[/0UWjg09N2^`2FO[L0Uh:k102FO[L00`00
0000UWjg09In]`0509In]`040000002IP;H0UWjg09V0]P80000000<0UWjg
09V0]P0000000`0000001@2GP[/0VH_309J7`@2FQl40VH_30080UXO100L0
000009V;``2FQl40VH_30000002FQl40VH_300<0UXO100<000000>3Oh`3P
gn<01@3Pgn<:000000@0/<3V00<0000009nQe@2OXMD01@2OXMD00`000000
h=oS0000000V0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWhG0>3Oh`030000003Pgn<0h=oS0080h=oS0`0000020>3Oh`03
0000003Pgn<0h=oS03`0h=oS0`00000409nCa`090000002OTlL0WHk309nC
a`2MS/<0Wi?709f>``2OTlL0000000P0WHk300<0000009f;_`2MRkl01@2M
Rkl010000000W8Rm09b8_@2LR;d209f;_`0409b8_@0000000000000000L0
UhNo00<0000009N7_`2JQ;X00`2JQ;X00`2FQl40VXBj0000000809N2^`03
0000002GP[/0Uh:k00H0Uh:k00<0000009In]`2FO[L00`2FO[L0102GP[/0
UWjg09N2^`00000609In]`0309V0]P2FO[L0000000H0000000L0UXO10000
002FQl40UXO109V;``2FQl40VH_30080UXO100X0VH_309J7`@000000UXO1
09V;``2FQl40000009V;``2FQl40VH_30P2FQl400`000000h=oS0>3Oh`04
0>3Oh`X000001P2``>H00`000000Xj7C09nQe@0509nQe@<000009@3Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn5`3Pgn<0
0`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS00<0h=oS00<00000
0>3Oh`3Pgn<0>03Pgn<3000000L0Wi?700T0000009nCa`2MS/<0Wi?709f>
``2OTlL0WHk309nCa`000000202MS/<00`000000WH^o09f;_`0609f;_`03
0000002MRkl0000000<0000000P0VH_30000002GQkl0W8Rm09N7_`2LR;d0
UhNo09b8_@80UhNo00H0000009Z4^P2JQ;X0UhNo09Z4^P2GQkl209Z4^P03
09J7`@000000Uh:k00H0Uh:k00<0000009N2^`2GP[/01P2GP[/01@000000
UWjg09N2^`2FO[L0Uh:k00@0UWjg00@0000009In]`2FO[L0UWjg0P2IP;H6
000000H0UXO100@0000009V;``2FQl40VH_30P2FQl402@2IRl<0UXO109J7
`@000000VH_309J7`@2IRl<0UXO10000000209J7`@0309V;``2FQl400000
00D0h=oS2@0000000`0>000000000;30iP050;30iP030000002OXMD0Wj7E
00D0Wj7E00@000000>3Oh`3Pgn<00000903Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn3`3Pgn<4000000@0h=oS00<00000
0>3Oh`3Pgn<00P3Pgn<00`000000h=oS0>3Oh`040>3Oh`030000003Pgn<0
h=oS03<0h=oS100000000`2QVLd0000009nCa`0709nCa`0:0000002OTlL0
WHk309nCa`2MS/<0Wi?709f>``2OTlL0WHk3000000L0WHk300<0000009f;
_`2MRkl01@2MRkl300000080UXO100D0VH_309J7`@2FQl40VH_300000006
09N7_`0409b8_@2GQkl0000009N7_`<0VXBj00@0UXO109Z4^P2JQ;X00000
202GP[/00`000000Uh:k09N2^`0509N2^`030000002FO[L0UWjg00<0UWjg
00H0Uh:k09In]`2JQ;X0UWjg0000002IP;H50000000309J7`@000000UXO1
00L0UXO100D0000009J7`@2FQl40UXO109V;``0209J7`@0:09V;``2FQl40
UXO10000002IRl<0UXO109V;``2FQl40000009V;``80UXO100<000000>3O
h`3Pgn<00P3Pgn<9000000803P0000<000000;30iP2``>H00P2``>H70000
0080Wj7E00D0WIoE09nQe@000000h=oS000000070>3Oh`@000006@3Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn5`3Pgn<0
0`000000h=oS0>3Oh`020>3Oh`8000001P3Pgn<200000300h=oS0`000000
1`2OTlL0XIW=0:6Ic@2QVLd0Wi?70:6Ic@000000202OTlL02@000000Wi?7
09f>``2OTlL0WHk309nCa`2MS/<0Wi?70000000809f>``030000002MRkl0
WH^o00@0000000X0VH_30000002FQl40W8Rm09V;``2FQl40W8Rm09V;``2F
Ql4000000P2GQkl00`2LR;d0UhNo09b8_@0309N7_`050000002JQ;X0UhNo
09Z4^P2FQl400P2JQ;X00`2GQkl0000009N2^`0709N2^`030000002GP[/0
Uh:k00D0Uh:k00D0000009In]`2GP[/0UWjg09Z4^P0309In]`D000001P2F
Ql400`000000UXO109J7`@0609J7`@030000002FQl40VH_30080UXO100L0
VH_309J7`@2FQl40VH_30000002FQl40VH_300<0UXO100D0000009J7`@2I
Rl<0UXO1000000020>3Oh`T000000`0>0005000000<0TY7?00@0000008Un
`@29O/40RGk11@0000020>3Oh`030000003Pgn<0h=oS00@0h=oS00<00000
0>3Oh`3Pgn<06P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn5P3Pgn<2000000@0h=oS00<000000>3Oh`3Pgn<01`3Pgn<0
0`000000h=oS0>3Oh`0[0>3Oh`80000000L0XIW=0000002QVLd0XIW=09nC
a`2QVLd0Wi?70080XIW=00<0000009nCa`2OTlL01P2OTlL02@000000Wi?7
09f>``2OTlL0WHk309nCa`2MS/<0Wi?70000000709f>``@000001P2IRl<0
10000000UXO109J7`@2IRl<209J7`@0309V;``2LR;d0000000D0UhNo00@0
W8Rm09N7_`000000UhNo102JQ;X0102FQl40VXBj09Z4^P00000709N2^`03
0000002GP[/0Uh:k00D0Uh:k00@0VXBj0000002FO[L0UWjg1@0000000`2F
Ql40000009J7`@0709J7`@030000002FQl40UXO100H0UXO100L0000009J7
`@2FQl40VH_309N2^`2FQl40VH_30080UXO100L0000009V;``2FQl40VH_3
09J7`@2IRl<0000000<0UXO100<000000>3Oh`0000002000000300h00080
00000P2BTLl00`2FSl/0TY7?09J?b`0309:Ac`0300000029O/40RGk100@0
RGk100D000000>3Oh`3Pgn<0h=oS000000060>3Oh`030000003Pgn<0h=oS
01T0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OQ`0h=oS00<000000>3Oh`3Pgn<0203Pgn<00`000000h=oS0>3Oh`0X0>3O
h`800000102QVLd00`000000XIW=09nCa`020:6Ic@0409nCa`2QVLd0XIW=
000000P0Wi?700D0000009f>``2OTlL0WHk309nCa`0209f>``0409nCa`00
0000WHk309f>``@0000000<0VXk60000002IRl<01@2IRl<0202FQl40WHk3
0000002LR;d0VH_309J7`@2LR;d0VH_30P2FQl401@000000W8Rm09N7_`2G
Qkl0W8Rm00<0UhNo00H0000009N7_`2JQ;X0UhNo09Z4^P2FQl4209Z4^P03
09J7`@000000Uh:k00H0Uh:k00<0000009N2^`2GP[/00`2GP[/209Z4^PH0
00001@2FQl400`000000UXO109J7`@0509J7`@030000002FQl40UXO100H0
UXO100D0000009J7`@2IRl<0UXO109V;``0209J7`@0409N2^`2IRl<0UXO1
000000D0UXO100<0000009J7`@2IRl<02P00000400h000030000002U[=`0
000000D0TY7?00<0UXo;09:Ac`0000001`29O/4010000000h=oS0>3Oh`00
00070>3Oh`030000003Pgn<0h=oS01P0h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOQ/0h=oS0`00000:0>3Oh`030000003P
gn<0h=oS02@0h=oS0`0000060:6Ic@050000002QVLd0XIW=0:6Ic@2OTlL0
0P2QVLd00`2OTlL0000009nCa`0709nCa`050000002OTlL0WHk309nCa`2M
S/<00P2OTlL40000000709Z>aP2IRl<0WHk309V;``2JS/H0VH_300000006
09V;``0:09J7`@000000UXO109V;``2LR;d0UXO109V;``2LR;d0UXO10000
00D0UhNo00D0W8Rm09N7_`2GQkl0000009N7_`0409Z4^P0309N7_`2JQ;X0
000000L0Uh:k00@0VXBj0000002JQ;X0VXBj1`00000809J7`@030000002F
Ql40UXO100H0UXO100<0000009J7`@2FQl401P2FQl403P000000UXO109V;
``2FQl40VH_309J7`@2IRl<0UXO109V;``000000UXO109V;``2FQl40VH_3
0P2FQl400`000000UXO109J7`@09000000@03P0000<000000:F/g0000000
0P2BTLl00`2FSl/0TY7?09:Ac`0209:Ac`0300000029O/40RGk100D0RGk1
00D000000>3Oh`3Pgn<0h=oS000000040>3Oh`040000003Pgn<0h=oS0000
01T0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OQ/0h=oS00<000000>3Oh`3Pgn<02`3Pgn<00`000000h=oS0>3Oh`0Q0>3O
h`80000000<0XYg@0000002QVLd01`2QVLd00`000000XIW=09nCa`020:6I
c@0409nCa`2QVLd0XIW=000000L0Wi?700D0000009f>``2OTlL0WHk309nC
a`020000000;09Z>aP000000VXk609Z>aP2IRl<0VXk609V;``2JS/H0VH_3
09Z>aP000000102IRl<01@2FQl40WHk309J7`@2MS/<000000080UXO100T0
VH_309J7`@2FQl40VH_309J7`@000000W8Rm09N7_`2LR;d0102GQkl01P00
0000VXBj09Z4^P2GQkl0VXBj09N7_`80VXBj00H0000009Z4^P2GP[/0Uh:k
09Z4^P2GP[/209Z4^P@0000000@0UXO100000000000000000P2FQl400`00
0000UXO109J7`@0609J7`@030000002FQl40UXO100H0UXO100<0000009J7
`@2FQl401P2FQl402P000000UXO109J7`@2IRl<0UXO109V;``2FQl40VH_3
09J7`@00000709J7`@X00000100>00001@000000WJKL0:F/g02U[=`00000
00<0TY7?00D0UXo;09:Ac`2FSl/0TY7?0000000608Un`@030000003Pgn<0
h=oS00<00000103Pgn<2000001X0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOQ/0h=oS00<000000>3Oh`3Pgn<0303Pgn<0
0`000000h=oS0>3Oh`0N0>3Oh`800000102RWM000`000000XIW=0:6Ic@05
0:6Ic@050000002QVLd0Wi?70:6Ic@2OTlL00P2QVLd00`2OTlL0000009nC
a`0709nCa`040000002OTlL00000000000@0VXk600T0000009Z>aP2JS/H0
VH_309Z>aP2IRl<0WHk309V;``0000001@2IRl<02@2FQl40WHk309J7`@00
0000VH_309b8_@2FQl40VH_309b8_@0209J7`@030000002GQkl0UhNo0080
UhNo00D0W8Rm09N7_`2GQkl0000009N7_`0409Z4^P0609J7`@2GQkl0UhNo
0000002JQ;X0Uh:k100000000`2FQl40000009J7`@02000000D0UXO100<0
000009J7`@2FQl401`2FQl400`000000UXO109J7`@0509J7`@030000002F
Ql40UXO100L0UXO100<0000009J7`@2FQl401P2FQl400`000000UXO109J7
`@0500000080WJKL1`00000200h000<000000P2U[=`00`2MY]`0000009:A
c`0609:Ac`0300000029O/40RGk100D0RGk100D000000>3Oh`3Pgn<0h=oS
0000000P0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWhK0>3Oh`8000003P3Pgn<00`000000h=oS0>3Oh`0J0>3Oh`<00000
1P2RWM000`000000XIW=0:6Ic@050:6Ic@030000002QVLd0XIW=00<0XIW=
00@0Wi?70:6Ic@2QVLd00000102OTlL00`2QVLd0Wi?700000002000000H0
VXk600L0000009Z>aP2IRl<0VXk609V;``2JS/H0VH_30080VXk600X00000
09V;``2IRl<0UXO109f>``2FQl40WHk309J7`@000000VH_30`2FQl401`2I
Rl<0UXO109b8_@2IRl<0000009N7_`2LR;d01@2GQkl01@000000UhNo09N7
_`2GQkl0UXO100H00000102FQl43000000P0UXO100<0000009J7`@2FQl40
1P2FQl400`000000UXO109J7`@0609J7`@030000002FQl40UXO100H0UXO1
00<0000009J7`@2FQl401@2FQl44000000D0WJKL00<0000009fVg0000000
1@00000200h000<0000000<0YJcL09fVg02U[=`00P2U[=`02@000000TY7?
09J?b`2BTLl0UXo;09:Ac`2FSl/0TY7?0000000608Un`@030000003Pgn<0
h=oS0080h=oS00<000000>3Oh`3Pgn<07@3Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn6`3Pgn<00`000000h=oS0>3Oh`0>
0>3Oh`030000003Pgn<0h=oS01D0h=oS100000000`2SXM<000000::Md007
0::Md0030000002QVLd0XIW=00D0XIW=00D000000:6Ic@2OTlL0XIW=09nC
a`020:6Ic@0409nCa`000000Wi?70:6Ic@@0000000<0Wi?70000002FSl/0
1`2JS/H02@000000VXk609V;``2JS/H0VH_309Z>aP2IRl<0VXk600000003
09V;``0809J7`@2MS/<0UXO109f>``2FQl40000009V;``2LR;d209J7`@04
09V;``2FQl40UXO1000000H0UhNo1P000000102FQl40UXW409J7`@000003
09J7`@<000000P2FQl400`000000UXO109J7`@0609J7`@030000002FQl40
UXO100H0UXO100<0000009J7`@2FQl401P2FQl400`000000UXO109J7`@07
09J7`@030000002FQl40UXO100@0000000<0V:3I0000002MYM`01`2MY]`0
0`000000WJKL000000040000000300h0000000000000008000000`2U[=`0
0`2MY]`0YJcL0000000709:Ac`0300000029O/40RGk100@0RGk100<00000
0>3Oh`3Pgn<00P3Pgn<00`000000h=oS0>3Oh`0M0>3Oh`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhK0>3Oh`800000403Pgn<0
0`000000h=oS0>3Oh`0@0>3Oh`@000001P2SXM<00`000000XYg@0::Md005
0::Md0030000002QVLd0XIW=00D0XIW=00<000000:6Ic@2QVLd01@2QVLd3
0000000709J?b`2OTlL0UXo;09nCa`2GTld0Wi?70000000709Z>aP060000
002JS/H0VXk609V;``2JS/H0VH_30P2JS/H050000000UXO109f>``2FQl40
WHk309J7`@2IRl<0UXO109f>``000000VH_309J7`@2LR;d0VH_309J7`@2L
R;d0VH_309J7`@000000UhNo100000000`2FRL@0000009J7`@0209J7`@03
09J9a02FQl40UXO10080UXO10`00000609J7`@030000002FQl40UXO100D0
UXO100<0000009J7`@2FQl401`2FQl400`000000UXO109J7`@0509J7`@03
0000002FQl40UXO100D0UXO11@0000001`2MWmD0WJGL09RPf@2MWmD0WJGL
09RPf@0000001`2MY]`00`000000WJKL000000060000000300h000000000
000000P000001@2BTLl00`000000RGk108Un`@0408Un`@030000003Pgn<0
h=oS00<0h=oS00<000000>3Oh`3Pgn<0703Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn6P3Pgn<200000180h=oS00<00000
0>3Oh`3Pgn<03@3Pgn<200000080Y:GG00<000000:>Qd`2SXM<01@2SXM<0
0`000000XYg@0::Md0060::Md0030000002QVLd0XIW=00D0XIW=00<00000
0:6Ic@2QVLd0100000002`2LUll0000009nCa`2FSl/0Wi?709NCc@2OTlL0
UXo;09nCa`000000UXo;00L0VXk60140000009Z>aP2JS/H0VH_309Z>aP2I
Rl<0VXk609V;``000000UXO109V;``2FQl40WHk309J7`@2MS/<0UXO10000
000709J7`@<000001P2FRL@01@000000UXO109J7`@2FQl40UXW400@00000
202FQl400`000000UXO109J7`@0609J7`@030000002FQl40UXO100H0UXO1
00<0000009J7`@2FQl401P2FQl400`000000UXO109J7`@040000000=09fO
e@2FVM@0000009fUg02MWmD0V:3I09fUg02MWmD0V:3I09fUg02MWmD00000
09fUg00709fVg0030000002MY]`0000000L000001`29QLP00`000000P7Fm
0000000300000080TY7?00<0000008Un`@29O/401029O/400`000000h=oS
0>3Oh`030>3Oh`030000003Pgn<0h=oS01/0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPP0h=oS0P0000040>3Oh`800000
103Pgn<2000000@0h=oS00<000000>3Oh`3Pgn<04P3Pgn<00`000000h=oS
0>3Oh`0:0>3Oh`800000102TYML00`000000Xj7C0:>Qd`060:>Qd`030000
002RWM00XYg@00D0XYg@00<000000:6Ic@2QVLd0102QVLd40000000909^B
bP2HULl0Vi;:09bGc`2KT/X0V9G?0000002OTlL0Ui?=0080Wi?700@0UXo;
09nCa`2OTlL000001`2JS/H04P000000VXk609V;``2JS/H0VH_309Z>aP2I
Rl<0VXk60000002MS/<0UXO109f>``2FQl40WHk309J7`@2JS/H0UXO10000
0080UXO1100000000`2FRlH0000009J9a00409J9a00409J7`@2FRlH00000
09J7`@<0000000D0UXO109J9a02FQl40UXO10000000709J7`@030000002F
Ql40UXO100H0UXO100<0000009J7`@2FQl401P2FQl400`000000UXO109J7
`@0509J7`@@000000140VicC09NLe`2KW=<0UicG09fOe@2KW=<0UicG0000
002HX=T0WIoE09fUg02HX=T0WIoE09fUg02MWmD0V:3I0000000809fVg0@0
000000H03P00000000000000000009NLe`00000608V5b00300000020MKd0
P7Fm00<0P7Fm1000000508Un`@030000003Pgn<0h=oS00<0h=oS0P00000L
0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh7
0>3Oh`040000003Pgn<0h=oS000000P0h=oS00@000000>3Oh`3Pgn<00000
0`3Pgn<2000001@0h=oS00<000000>3Oh`3Pgn<01P3Pgn<3000000L0Y:GG
00<000000:>Qd`2SXM<01@2SXM<00`000000XYg@0::Md0060::Md0030000
002QVLd0000000<000000P2LUll02@000000V9G?09bGc`2KT/X0W9O?09^B
bP2LUll0Vi;:0000000209nCa`0609J?b`2OTlL0UXo;09nCa`2FSl/00000
202JS/H00`000000VXk609V;``0309Z>aP0909V;``000000UXO109f>``2I
Rl<0UXO109Z>aP2FQl40VH_300@0000000L0UX_609J9a02FRlH0UXW409J;
aP2FRL@0000000D0UXW40`00000309J7`@0509J9a02FQl40UXW409J7`@00
0000202FQl400`000000UXO109J7`@0609J7`@030000002FQl40UXO100H0
UXO100<0000009J7`@2FQl40100000005P2KW=<0UiKA0000002MWmD0UicG
09^Ld`2MWmD0UYWD09fOe@2FVM@0WIoE0000002MYM`0UicG09fUg02MWmD0
V:3I09fUg02HX=T0WJGL0000002MYM`209fVg0@0WJGL0P2MY]`600000003
09fOe@2GW=L0000000L0RHG800<00000081e_@20MKd01020MKd010000000
Nfbf00000000000308Un`@030000003Pgn<0h=oS00<0h=oS0P00000L0>3O
h`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh70>3O
h`040000003Pgn<0h=oS000000/0h=oS00D000000>3Oh`3Pgn<0h=oS0000
000F0>3Oh`030000003Pgn<0h=oS0080h=oS0`0000020:F/g0030000002T
YML0Y:GG00D0Y:GG00<000000:>Qd`2SXM<01P2SXM<00`000000XYg@0::M
d0040::Md0<000001P2LUll04@000000Wi?709bGc`2KT/X0W9O?09^BbP2L
Ull0Vi;:09bGc`000000UXo;09nCa`2GTld0Wi?709J?b`2OTlL0000000P0
VXk600D0000009Z>aP2MS/<0VXk609J7`@0309Z>aP030000002FQl40UXO1
00@0000000L0UX_60000002FRlH0UXW409J;aP2FRL@0UX_60080UXW400@0
UX_60000002FRL@0UXW40`0000000`2FQl40UX_60000000209J7`@0609J9
a02FQl40UXW409J7`@2FRL@00000202FQl400`000000UXO109J7`@0609J7
`@030000002FQl40UXO100D0UXO1100000006`2GU]40VicC09NFd@2KW=<0
UiKA09^Ld`000000UicG09^Ld`2GW=L0WIoE09^Ld`2GW=L0WIoE09JIe02M
WmD0000009fUg02MWmD0UicG09fUg02HX=T0WIoE09fUg02HX=T0000009fV
g00209fUg00309^Zh@2MY]`0000000<000000P2IiO/2000000@0UicG00<0
000008V5b029QLP01029QLP00`000000P7Fm081e_@05081e_@030000001k
K;H0Nfbf00<0000000<0RGk10000003Pgn<01@3Pgn<00`000000h=oS0>3O
h`0I0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1V
IWh0h=oS00@000000P3Pgn<010000000h=oS0>3Oh`0000090>3Oh`800000
103Pgn<00`000000h=oS0>3Oh`0E0>3Oh`@0000000H0YJcL0:BUe`2U[=`0
Y:GG0:F/g00000080:BUe`030000002SXM<0Xj7C00D0Xj7C00<000000::M
d02RWM001000000209^Ld`030000002QVLd0W9O?00D0W9O?00X0000009bG
c`2KT/X0V9G?09^BbP2LUll0Vi;:09bGc`000000UXo;0P2OTlL01@2GTld0
Wi?709J?b`2OTlL0000000P0VXk600@0000009Z>aP2JS/H0VXk61P000006
09J;aP050000002FRlH0UXW409J;aP2FRL@00`2FRlH3000000D0UXW400<0
000009J7`@2FQl401P2FQl400`000000UXO109J7`@0609J7`@030000002F
Ql40UXO100H0UXO100<0000009J7`@2FQl40100000005`2HULl0000009^L
d`2GU]40VicC09NFd@2KW=<0UiKA09^Ld`2GU]40VicC0000002MWmD0VicC
09NLe`2KW=<0UicG09^Ld`2MWmD0UicG0000002MYM`0V:3I0080WJGL00D0
WIoE09RPf@2MYM`0WIoE0000000209fUg0<000000P2IiO/00`2OeOX0VNGk
000000020000000609fOe@2FVM@0UicG09NLe`2MWmD000001P29QLP00`00
0000P7Fm081e_@05081e_@030000001kK;H0Nfbf00<0Nfbf0P0000060>3O
h`030000003Pgn<0h=oS01T0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOPL0h=oS00@000000>3Oh`3Pgn<000002@3Pgn<0
0`000000h=oS0>3Oh`030>3Oh`8000005@3Pgn<01@0000003P000:F/g02V
]><0000000H0YJcL00<000000:BUe`2TYML01P2TYML00`000000Xj7C0:>Q
d`040:>Qd`<00000102KW=<00`2RWM00VicC0000000709bGc`090000002L
Ull0Vi;:09bGc`2KT/X0W9O?09^BbP2HULl000000080Wi?700H0UXo;09nC
a`2OTlL0UXo;09nCa`00000709Z>aPD000000`2FSLL00`000000UX_609J;
aP0609J;aP030000002FRlH0UXW400<0UX_60P0000000`2FRlH0000009J9
a00409J9a00309J7`@2FRlH0000000L0UXO100<0000009J7`@2FQl401P2F
Ql400`000000UXO109J7`@0509J7`@@000001P2HULl06`000000UiKA09^L
d`2GU]40VicC09NFd@2KW=<0UiKA09^Ld`000000UYWD09NLe`2MWmD0UYWD
09fOe@2KW=<0UicG09^Ld`2GW=L0000009fOe@2HX=T0WIoE09RPf@2MWmD0
WJGL09RPf@030000000409WUn`2OeOX0VNGk09oEnP80VNGk0`00000309NL
e`0509fOe@2GW=L0UicG09NLe`0000001@29QLP00`000000P7Fm081e_@05
081e_@030000001kK;H0Nfbf00@0Nfbf00<000000>3Oh`3Pgn<01@3Pgn<0
0`000000h=oS0>3Oh`0H0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWh80>3Oh`8000002P3Pgn<3000000<0h=oS00<00000
0>3Oh`3Pgn<04P3Pgn<2000000050:F/g02V]><0YJcL0:F/g00000000P2U
[=`01P2TYML0YJcL0:F/g02U[=`0Y:GG000000L0Y:GG00<000000:>Qd`2S
XM<01000000209fOe@040000002KW=<0VicC0::Md0@0VicC00<0000009bG
c`2LUll01@2LUll04@000000W9O?09^BbP2LUll0Vi;:09bGc`2KT/X0W9O?
0000002FSl/0Wi?709J?b`2OTlL0UXo;09nCa`2FSl/000000080VXk61000
00000`2FSl/0000009J=a`0609J=a`030000002FRlH0UX_600D0UX_600<0
000009J;aP2FRlH00`000000102FRlH0UXW409J;aP00000709J9a0030000
002FQl40UXO100H0UXO100<0000009J7`@2FQl401P2FQl400`000000UXO1
09J7`@040000000309NCc@000000V9G?00L0V9G?01@0000009^Ld`2GU]40
VicC09NFd@2KW=<0UiKA09^Ld`2GU]40VicC0000002MWmD0UYWD09fOe@2G
W=L0VicC09fOe@2FVM@0WIoE00000080WJGL00<0V:3I09fUg02HX=T00P00
000209oEnP8000000`2IiO/2000000040:O0j`2``>H0Yl3[000000@0UicG
00<0WIoE09NLe`0000001P29QLP00`000000P7Fm081e_@04081e_@030000
001kK;H0Nfbf00@0Nfbf00<000000>3Oh`3Pgn<01P3Pgn<00`000000h=oS
0>3Oh`0G0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWhI0>3Oh`030000003Pgn<0h=oS0100h=oS0`000000102U[=`0Y[CS
0:Jdh`2U[=`20:Jdh`030:F/g0000000YJcL0080YJcL00D0Y:GG0:F/g02U
[=`0YJcL000000060:BUe`<000001P2MWmD00`000000VicC09^Ld`0509^L
d`030000002LUll0W9O?00D0W9O?00/0000009bGc`2KT/X0W9O?09^BbP2L
Ull0Vi;:09bGc`000000Wi?709J?b`0209nCa`0309J?b`2OTlL0000000<0
000000L0UXg709J?b`2FSLL0UXo;09J=a`2FSl/0000000H0UXg700<00000
09J;aP2FRlH01@2FRlH300000080UX_600D0UXW409J;aP2FRL@0UX_60000
000809J9a0030000002FQl40UXO100D0UXO100<0000009J7`@2FQl401@2F
Ql44000000H0Ui?=00<0000009REc`2HULl01P2HULl04@000000UiKA09^L
d`2GU]40VicC09NFd@2KW=<0UiKA09^Ld`000000UYWD09fOe@2KW=<0UicG
09^Ld`2GW=L0WIoE0080UicG00<0000009RPf@0000000P00000609oEnP`0
0000102GW=L00`000000RHG808V5b00308V5b00300000020MKd0P7Fm00D0
P7Fm00<0000007]/]P1kK;H0101kK;H00`000000h=oS0>3Oh`050>3Oh`03
0000003Pgn<0h=oS01L0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOQT0h=oS0P00000=0>3Oh`@000000P2V]><02@000000
Y[CS0:F/g02U[=`0Y[CS0:F/g02V]><0YJcL000000070:F/g0030000002U
[=`0Y:GG00@0000000<0Wj7E09fUg00000001`2MWmD01@000000VicC09^L
d`2KW=<0XYg@0080VicC00<0XYg@0000002LUll01P2LUll01P000000W9O?
09J?b`2KT/X0W9O?09^BbP80W9O?00<0000009nCa`0000000`0000000`2G
Tld0000009J?b`0709J?b`030000002FSLL0UXg700@0UXg700<0000009J;
aP2FRlH00P2FRlH30000000;09J;aP000000UX_609J;aP2FQl40UX_609J9
a02FRlH0UXW409J;aP0000001`2FRL@00`000000UXO109J7`@0609J7`@03
0000002FQl40UXO100@0000000<0Ui?=0000002GTld01`2GTld00`000000
V9G?09REc`0609REc`0B0000002KW=<0UiKA09^Ld`2GU]40VicC09NFd@2K
W=<0UiKA09^Ld`000000UicG09^Ld`2MWmD0UicG09fOe@2GW=L0WIoE0`00
000809oEnP<0000000H0TYCB08nCd`2BU=80SIGF09:DdP2=UMH200000080
PGg51P00000408V5b00300000020MKd0P7Fm00D0P7Fm00<0000007]/]P1k
K;H0101kK;H00`000000h=oS0>3Oh`050>3Oh`800000603Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn6@3Pgn<00`000000
h=oS0>3Oh`090>3Oh`<000001P2V]><01P000000YJcL0:F/g02V]><0YJcL
0:Jdh`<0YJcL00<000000:F/g02U[=`0102U[=`3000000<0WJGL00@0Wj7E
09fUg02OXMD000001`2MWmD00`000000VicC09^Ld`0509^Ld`030000002L
Ull0W9O?00D0W9O?00<0000009bGc`2LUll00P2LUll50000000309:Ac`2G
Tld0Ui?=00<0Ui?=00T0000009J?b`2FSLL0UXo;09J=a`2FSl/0UXg709J?
b`0000001`2FSLL4000000D0UX_600T0000009J;aP2FRlH0UX_609J9a02F
RlH0UXW409J;aP000000202FRL@00`000000UXO109J7`@0209J7`@H00000
00@0UXo;09:Ac`2GTld0UXo;0P2GTld00`000000Ui?=09NCc@0609NCc@03
0000002HULl0V9G?00H0V9G?00/0000009NFd@2KW=<0UiKA09^Ld`2GU]40
VicC09NFd@2KW=<0000009fOe@0209NLe`@000000P2Qa_<00`000000WmGj
09oEnP0409oEnP8000000`2V]><00`000000TYCB08nCd`0409:DdP800000
1@21OLD010000000NFnl00000000000208V5b00300000020MKd0P7Fm00D0
P7Fm00<0000007]/]P1kK;H0101kK;H00`000000h=oS0>3Oh`070>3Oh`03
0000003Pgn<0h=oS01D0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOQT0h=oS00<000000>3Oh`3Pgn<01`3Pgn<200000080
Yk[W00<000000:Jdh`2V]><01@2V]><00`000000YJcL0:F/g0020:F/g004
0:Jdh`2U[=`0Y[CS00000080YJcL10000000102U[=`0WJKL0000002TYML2
09fUg00509nQe@2MYM`0Wj7E09fUg00000001`2MWmD00`000000VicC09^L
d`0509^Ld`050000002LUll0W9O?09bGc`2KW=<00P2LUll50000000409:A
c`2HULl0TY7?00000080Ui?=00H0UXo;09:Ac`2FSl/0Ui?=09:Ac`000007
09J?b`0309J=a`000000UXg700<0UXg70`00000809J;aP060000002FRlH0
UXO109J;aP2FRL@0UX_60P2FRL@00`000000UXW409J9a00509J9a0H00000
00H0Ui?=09J?b`2GTld0000009:Ac`2FSl/509NCc@0309:Ac`000000Ui?=
00L0Ui?=00<0000009REc`2HULl01P2HULl020000000VicC09NFd@2KW=<0
UiKA09^Ld`2GU]40VicC1@0000050:76l`040:K>m@2Qa_<0000000000080
WmGj0P0000050:Jdh`050000002BU=80TYCB08nCd`2=UMH00P2BU=800`00
0000PGg500000004085ma@040000001iKk`0NFnl07U__080000000<0RHG8
00000020MKd01P20MKd00`000000Nfbf07]/]P0307]/]P030000003Pgn<0
h=oS00L0h=oS00<000000>3Oh`3Pgn<05@3Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn6@3Pgn<2000000H0h=oS0P000005
0:Nji`030000002V]><0Y[CS00D0Y[CS00@000000:Jdh`2U[=`0Y[CS0`2U
[=`3000000H0WJKL00T0000009fUg02MYM`0WJGL09nQe@2MYM`0Wj7E09fU
g00000001`2MWmD00`2OXMD0000009^Ld`0509^Ld`030000002LUll0W9O?
00@0000000<0UiKA0000002GTld01P2GTld00`000000Ui?=09NCc@0509NC
c@060000002JS/H0UXo;09J=a`2FSl/0UXg70P2FSl/00`000000UXg70000
0002000000<0UXg700<0000009J;aP2FRlH01@2FRlH010000000UX_609J;
aP2FRlH209J9a0<0UX_600<0000009J9a02FRL@0100000000`2FSl/00000
09:Ac`0209NCc@0609J?b`2GTld0TY7?09J?b`2GTld000000`2GTld00`2F
Sl/0TY7?09NCc@0209NCc@030000002GTld0Ui?=00D0Ui?=00<0000009RE
c`2HULl01@2HULl01@2LUll0UiKA0000002GU]40VicC00@0000000D0Xkk/
0:6okP2Q_nh000000:K>m@020:76l`030:K>m@2Qa_<0Y/ke00<0XLKc1000
00070:Jdh`030000002?Tm<0TYCB0080TYCB00@0SIGF09:DdP0000000000
1@21OLD00`000000NFnl07U__00207U__0<000001P20MKd00`000000Nfbf
07]/]P0407]/]P030000003Pgn<0h=oS00L0h=oS00<000000>3Oh`3Pgn<0
503Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
6@3Pgn<00`000000h=oS0>3Oh`020>3Oh`<000001`2W^^L00`000000Y[CS
0:Jdh`050:Jdh`030000002U[=`0YJcL00@0000000<0WZkS0:6`h`000000
0P2MY]`00`2Q/><0WJKL09fVg00209fVg0090000002TYML0WJGL09fUg02O
XMD0WJGL09nQe@2MYM`0000000L0WIoE00<0000009^Ld`2KW=<00P2KW=<5
000000H0UiKA00d0000009:Ac`2HULl0TY7?09REc`2BTLl0V9G?0000002B
TLl0UXo;09NCc@2BTLl0UXo;0080Ui?=00<0000009J?b`2FSl/0102FSl/3
000000H0UXg700<0000009J;aP2FRlH01P2FRlH00`000000UX_609J;aP02
09J;aPH000001P2FSl/02`000000TY7?09J?b`2GTld0UXo;09NCc@2FSl/0
Ui?=0000002BTLl0UXo;00<0Ui?=00@0UXo;09:Ac`2FSl/00000202GTld0
0`000000V9G?09REc`0209REc`<0UiKA100000050:6okP030:>nk02M^^d0
00000080XLKc00<0Y/ke0:76l`2Qa_<00P2Qa_<200000005093^j`000000
_m[]0;oJk@0000001P2V]><00`000000TYCB08nCd`0209:DdP0508nCd`2B
U=800000085ma@0000001021OLD00`000000NFnl07U__00307U__0040000
001dIkD00000000000@0P7Fm00<0000007]/]P1kK;H0101kK;H00`000000
h=oS0>3Oh`080>3Oh`030000003Pgn<0h=oS01<0h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQP0h=oS00<000000>3Oh`00
00000`0000020:O0j`030000002W^^L0Yk[W00H0Yk[W00<000000:Jdh`2V
]><0102V]><300000080WZkS0P2Q/><00`2MY]`0XK3S0000000409fVg009
0:6`h`2MY]`0Vj[Q09fVg0000000WJGL09nQe@2MYM`0Wj7E0080WJGL00<0
Y:GG0000002MWmD0102MWmD00`2OXMD0000000000003000000<0UYWD00<0
000009NFd@2GU]401@2GU]400`000000Ui?=09NCc@0409NCc@0409REc`00
0000Ui?=09J?b`<0Ui?=00<0UXo;09:Ac`0000000P2FSl/30000000309Z>
aP2FSl/0000000H0UXg700<0000009J;aP2FRlH01@2FRlH60000000409J?
b`2DSl`0UXo;000000P0UXo;00d0000009NCc@2FSl/0Ui?=09J?b`2GTld0
TY7?09J?b`2GTld0000009NCc@2FSl/0TY7?00@0Ui?=00<0000009NCc@2G
Tld01P2GTld00`000000V9G?09REc`0209NFd@0<09VHd@000000000009ff
jP2N/nH000000:6okP2M^^d0Xkk/0:6okP2M^^d0Xkk/0`2Q_nh00`000000
XLKc0:76l`020:76l`80000000L0T>k[000000000000_m[]0<CJjP2of^d0
000000L0Y[CS00X0000009:DdP2BU=80Si?C09:DdP2?Tm<0TYCB00000021
OLD000000`21OLD00`000000NFnl07U__00407U__0030000001dIkD0M6Ne
008000000P20MKd00`000000Nfbf07]/]P0407]/]P030000003Pgn<0h=oS
00P0h=oS00<000000>3Oh`3Pgn<04`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn603Pgn<2000000L0Yl3[00<000000:Nj
i`2W^^L01P2W^^L00`000000Y[CS0:Jdh`030000000709jciP2V]><00000
0:6`h`2N[^<0Vj[Q0:6`h`0209j^h`030:6`h`000000WJKL00@0WJKL00D0
YJcL09^Zh@2MY]`0000009nQe@0309fUg00309nQe@2MYM`000000080WIoE
100000000`2GW=L0000009JIe00209JIe00509^Ld`2FVM@0VicC09JIe000
00001`2GU]4020000000TY7?09REc`2GTld0TY7?09REc`2BTLl000000`2G
Tld0102BTLl0UXo;09NCc@2GTld30000000309J?b`2JS/H0UXo;0080UXo;
00<0000009Z>aP2FSLL00`2FSLL00`2FSl/0UXg70000000209J;aP@00000
00/0UXo;0000002FSl/0U8o<09J?b`2DSl`0UXo;09B?c02FSl/0U8o<0000
000809J?b`090000002BTLl0Ui?=09J?b`2GTld0UXo;09NCc@2FSl/00000
0080Ui?=00L0UXo;09NCc@2BTLl0UXo;09NCc@2BTLl0000000P0Ui?=00<0
000009NFd@0000000P00000409jciP030000002Q_nh0XKo^00H0XKo^00@0
X;g]0000002Vc_D0Y/ke0P0000000`2@k^/00000000000030;oJk@`00000
1@2BU=800`000000PGg500000003085ma@030000001iKk`0NFnl00@0NFnl
00<0000007AW]@1dIkD00P1dIkD200000003081e_@000000Nfbf00@0Nfbf
00<000000>3Oh`3Pgn<02@3Pgn<2000001<0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQP0h=oS0P0000080:O0j`030000
002W^^L0Yk[W00D0Yk[W0`00000609jciP090000002U[=`0XK3S0:6`h`2N
[^<0XK3S09j^h`2Q/><0000000<0WJKL00T0Vj[Q0:F/g02U[=`0WJKL0000
002MYM`0Y:GG09nQe@2MYM`01@00000609NLe`030000002KW=<0UYWD00@0
UYWD00<0000009NFd@2GU]401@2GU]4010000000V9G?09:Ac`2HULl309NC
c@0309REc`000000TY7?00<0Ui?=1000000709J?b`040000002FSLL0UXg7
09J?b`H0000000l0Ti3=09J?b`2CT<d0UXo;09>@c@2FSl/0000009J?b`2D
Sl`0UXo;09B?c02FSl/0U8o<09J?b`000000202FSl/02P000000Ui?=09J?
b`2GTld0UXo;09NCc@2FSl/0Ui?=0000002BTLl709NCc@080000002GTld0
Ui?=09NCc@2HULl0Ui?=09REc`2GTld3000000L0W[?V00<0WKKZ0000002Q
_nh00P2Q_nh01@2P_Nd0W[[/0:2mk@2P_Nd0XLKc00H0000000<0e_KS0000
000000000P0000040:6`h`0300000029S]80RHkB00<0RHkB00<0000007Yh
a@0000000`0000001@2BU=80TYGC00000021OLD0000000<0PGg500<00000
07U__01iKk`00`1iKk`00`000000M6Ne07AW]@0407AW]@8000001P1kK;H0
0`000000h=oS0>3Oh`080>3Oh`8000004`3Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn4@3Pgn<2000000D0h=oS00<00000
0>3Oh`000000202W`>/00`000000Yk[W0:Nji`040000000509jjk02Q]^L0
000009jciP2V]><0102N/nH02P000000XK3S09^Zh@2Q/><0WJKL0:6`h`2M
Y]`0XK3S09j^h`00000609fVg0D0000000D0Uj?M09RPf@2BW=X0Uj?M0000
000609NLe`040000002FVM@0UYWD09^Ld`@0UYWD00<0000009NFd@2GU]40
1@2GU]402@000000Ui?=09:Ac`2HULl0TY7?09REc`2BTLl0000009NCc@03
0000000409:Ac`2FSl/0Ui?=000000@0UXo;1`00000409B?c00>0000002F
Sl/0Ti3=09J?b`2CT<d0UXo;09>@c@2FSl/0000009J?b`2DSl`0UXo;09B?
c02FSl/209B?c00309J?b`000000UXo;00H0UXo;00d0000009:Ac`2FSl/0
Ui?=09J?b`2BTLl0Ui?=09J?b`2GTld0000009NCc@2BTLl0UXo;00@0Ui?=
00@0TY7?0000002HULl0Ui?=100000000`2N[^<0Vj[Q0000000809jciP04
0:6fi`000000X;g]0:6okP<0XLKc0P00000309WUn`@0000000<0_m[]0000
002Q/><01@2Q/><00`000000RHkB08V>dP0408V>dP030000001jN<D0NWS5
0080NWS50`000002085ma@0400000021OLD0PGg5000000D0NFnl00<00000
07AW]@1dIkD01@1dIkD3000000@0Nfbf00<000000>3Oh`3Pgn<02@3Pgn<0
0`000000h=oS0>3Oh`0A0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWh@0>3Oh`040000003Pgn<0h=oS000000@0h=oS0P00
00000`3Pgn<00000000000060:O0j`<000001`2N^^`010000000W[?V09jc
iP2V]><309jciP090000002Q/><0WZkS09j^h`2Q/><0WZkS0:6`h`2N[^<0
00000080WJKL100000000`2GXmd0TjKR0000000209RPf@0509NSg@2HX=T0
Uj?M09RPf@0000001`2GW=L020000000UYWD09JIe02FVM@0VicC09JIe02K
W=<000001`2GU]401P000000Ui?=09REc`2BTLl0V9G?09:Ac`<0000000@0
TY7?09NCc@2GTld0Ui?=1`00000309:Ac`030000002DSl`0U8o<00D0U8o<
00h0000009J?b`2FSl/0Ti3=09J?b`2CT<d0UXo;09B?c02FSl/0000009J?
b`2DSl`0UXo;09B?c0<0UXo;00<0000009J?b`2FSl/01P2FSl/02@000000
Ui?=09J?b`2GTld0UXo;09NCc@2FSl/0Ui?=0000000209NCc@0509J?b`2B
TLl0Ui?=09:Ac`2GTld01000000609^Zh@030000002N/nH0W[?V00H0W[?V
00@0WZkS0000002P_Nd0XKo^0`00000309WUn`@0000000@0_m[]0;gHk@2o
f^d000001`2Q/><00`000000RHkB08V>dP0308V>dP030000001jN<D0NWS5
00@0NWS50`0000001021OLD00000085ma@00000607U__0030000001dIkD0
M6Ne00@0M6Ne00@00000079S/P1bHk8000000`1kK;H00`000000h=oS0>3O
h`0:0>3Oh`030000003Pgn<0h=oS0100h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOQ00h=oS00@000000>3Oh`3Pgn<00000
103Pgn<00`000000h=oS0>3Oh`020>3Oh`030000002W`>/0Yl3[00<00000
0P2P_Nd02@000000WK[]0:6fi`2N^^`0XKKW09jjk02Q]^L0W[[/00000007
09jciP030000002Q/><0WZkS0080WZkS1@0000001`2CY^80WJGL09>VhP2G
Xmd0TjKR09fUg00000000`2GXmd01@2HX=T0Uj?M09RPf@2GXmd0000000H0
UicG00<0000009JIe02FVM@01@2FVM@00`000000UiKA09NFd@0209NFd@05
09^Ld`2GU]40TYGC0000002HULl02P00000309:Ac`030000002BTLl0TY7?
0080TY7?00D0UXo;09:Ac`2FSl/0000009J?b`0609B?c00<0000002FSl/0
U8o<09J?b`2CT<d0UXo;09B?c02FSl/0000009J?b`2DSl`0UXo;102DSl`0
0`000000UXo;09J?b`0609J?b`0<0000002BTLl0Ui?=09J?b`2GTld0UXo;
09NCc@2BTLl0Ui?=0000002BTLl0Ui?=100000000`2GXmd0WJKL00000002
09^Zh@0709j^h`2KZ^40WZkS09^Zh@2N[^<0Vj[Q0000000209ffjP<0W[?V
0`2M]^X3000000@0VNGk100000001`2mf>d0_m[]0;gHk@2of^d0_MS]0;oJ
k@0000001P2Q/><00`000000RHkB08V>dP0408V>dP030000001jN<D0NWS5
00@0NWS500H00000079[^`0000000000085ma@00000607U__0030000001d
IkD0M6Ne00D0M6Ne00<00000079S/P1bHk800P0000000`1kK;H000000>3O
h`0<0>3Oh`030000003Pgn<0h=oS00l0h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOQ00h=oS00@000000>3Oh`3Pgn<00000
0`3Pgn<00`000000h=oS0>3Oh`040>3Oh`8000001P2P_Nd00`000000W[[/
09jjk00309jjk0030:6fi`2N^^`0000000<0W[?V00<0XKKW09j^h`2Q]^L0
1@00000309N[i@0:09^Zh@000000Uj?M09NSg@2CY^80WJGL09>VhP2MYM`0
TjKR00000080V:3I00D0Uj?M09RPf@2GXmd0V:3I0000000709NLe`030000
002FVM@0UYWD00@0UYWD00D0000009NFd@2GU]40VicC09:Ed`07000000@0
TYCB00<0000009:Ac`2BTLl01@2BTLl00`000000TY7?09J?b`0409:Ac`03
0000002DSl`0U8o<00D0U8o<00D0000009J?b`2FSl/0U8o<09J?b`0209B?
c00309J?b`000000UXo;00H0U8o<00<0UXo;0000002FSl/01`2FSl/01@00
0000Ui?=09:Ac`2GTld0TY7?00H0000000P0Vj[Q09fVg02GXmd0Vj[Q09fV
g02GXmd0000009j^h`L0Vj[Q00<0WZkS0000002N[^<0102M]^X200000003
0:CNn`2IiO/0Y=kk00H000000P2mf>d00`2of^d0_MS]0;oJk@020;gHk@03
0;oJk@000000XK3S00H0XK3S00<0000008V>dP29S]800`29S]800`000000
NWS507Yha@0407Yha@040000001bJk/0LV^k079[^`<000001@1iKk`00`00
0000M6Ne07AW]@0507AW]@030000001bHk80LV>b0080LV>b0`00000<0>3O
h`030000003Pgn<0h=oS00l0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOQ00h=oS00@000000>3Oh`3Pgn<000000`3Pgn<2
000000H0h=oS00<000000:2mk@2P_Nd01@2P_Nd010000000WKKZ09jjk02Q
]^L409jjk0030000002N/nH0W[?V00<0000000@0UJcV09Jek@000000Vj[Q
1P2GZnD020000000TjKR09fUg02CY^80WJGL09>VhP2GXmd000000P2GXmd0
1P2HX=T0TYcJ09NSg@2HX=T0Uj?M000000H0UicG00<0000009JIe02FVM@0
0P2FVM@90000000409:Ed`000000Si?C09NFd@D0TYCB00<0000009:Ac`2B
TLl01@2BTLl02P000000TY7?09:Ac`2BTLl0UXo;09:Ac`2FSl/0TY7?0000
002FSl/609B?c0040000002FSl/0U8o<09B?c0@0UXo;00<0000009J?b`2F
TL`01@2FTL`00`000000UXo;09J?b`0509J?b`H00000102HX=T00`000000
WJGL09NSg@0209fVg00:09NSg@2MY]`0Uj?M09fUg0000000WZkS09^Zh@2N
[^<0Vj[Q09j^h`80Vj[Q00@0WZkS0000002M]^X0WKKZ0`0000000`2XjoX0
VNGk0:CNn`020:CNn`<0000000@0f_k?0000003Fm^<000000P2mf>d00`2o
f^d0_MS]0;oJk@020;oJk@D000000`2Q/><00`000000RHkB08V>dP0308V>
dP030000001jN<D0NWS500@0NWS500<00000079[^`1bJk/00P1bJk/20000
00H0NFnl00<0000007AW]@1dIkD0101dIkD00`000000LV>b079S/P04079S
/P030000003Pgn<0h=oS00/0h=oS0P00000?0>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWhA0>3Oh`800000103Pgn<00`00
0000h=oS0>3Oh`060>3Oh`8000001P2P_Nd01@000000W[[/09jjk02N^^`0
WKKZ00D0000000L0TZkY09ffjP2E[>H0UJcV09N[i@2B[^T0000000H0Uj_U
00`0000009NSg@2GXmd0TjKR09NSg@2CY^80WJGL09>VhP000000V:3I09NS
g@2HX=T309NSg@030000002GW=L0UicG0080UicG1`0000000`2BUM<0SYSI
096GeP03000000D0TYGC00<0000009:DdP2BU=801@2BU=800`000000TY7?
09:Ac`0509:Ac`030000002FSl/0TY7?00@0TY7?00<0000009B?c02DSl`0
1@2DSl`00`000000UXo;09J?b`0409J?b`0309:Ac`000000UXo;00L0UXo;
00<0000009J?b`2FSl/0100000000`2GW=L0000009RPf@0709RPf@0;0000
002GXmd0WJKL09NSg@2MYM`0WJKL09NSg@2KZ^40Uj?M09fUg0000000102K
Z^4309j^h`<000000`2Tg_/00`2OeOX0Y=kk0:CNn`020000000707cVc`00
0000f_k?0000003Fm^<0b_OZ0=Kfh`0200000080_m[]0`00000209jciP03
00000023SMD0PhgE00H000001029S]800`000000NWS507Yha@0407Yha@03
0000001bJk/0LV^k0080LV^k0`00000407U__0030000001dIkD0M6Ne00@0
M6Ne00<00000079S/P1bHk80101bHk800`000000h=oS0>3Oh`0;0>3Oh`03
0000003Pgn<0h=oS00h0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOQL0h=oS00<000000>3Oh`3Pgn<0203Pgn<00`000000
X;g]0:2mk@020:2mk@H00000102F]Nd02P000000TZkY09:^j@2E[>H0WKKZ
09:^j@2M]^X0000009^Zh@2E[>H509N[i@080000002CY^80WJGL09>VhP2M
YM`0TjKR09fUg000000409NSg@L0000000@0TYcJ08jHf@2BW=X000000`2A
UmH30000000408jHf@000000TYGC08nCd`@0TYGC00<0000008nCd`2GU]40
1@2BU=800`000000TY7?09:Ac`0509:Ac`040000002BTLl0TY7?09J?b`@0
TY7?00<0000009J?b`2DSl`0102DSl`00`2FSl/0000009J?b`0209J?b`05
09:Ac`2FSl/0TY7?09NCc@000000102FSl/6000000H0UicG00<0000009RP
f@2HX=T01P2HX=T03@000000Uj?M09fVg02CY^80WJGL09NSg@2MY]`0WJGL
09NSg@000000WZkS09^Zh@2N[^<0100000001`2Vc_D0WmGj000000000000
Y=kk09WUn`2XjoX00P0000001@1li/l000000000003Jo/l0000000D0e_KS
0`0000001P2N/nH0XK3S09jciP2Q/><0W[?V000000H0PhgE00@0000007Ee
a@00000000000P29S]800`000000NWS507Yha@0407Yha@030000001bJk/0
LV^k0080LV^k0P0000000`1^HkH0000007U__00207U__0030000001dIkD0
M6Ne00D0M6Ne00<00000079S/P1bHk800`1bHk800`000000h=oS0>3Oh`0<
0>3Oh`030000003Pgn<0h=oS00H0h=oS0P0000050>3Oh`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhG0>3Oh`8000002P3Pgn<4
000000<0U;[a00<0000009Jek@2F]Nd01@2F]Nd02@000000WKKZ09N[i@2B
[^T0Uj_U09:^j@2GZnD0000009^Zh@0509N[i@0409^Zh@000000TjKR09NS
g@80TjKR1P00000209:LfP0908jShP2BW=X0000009:LfP2>V=T0TYcJ08jH
f@2BW=X0SYSI00<0000000L0Si?C09NLe`2?Tm<0UicG0000002?Tm<0TIOF
00@0TYGC00<0Si?C0000002BU=801P2BU=800`000000TY7?09:Ac`0509:A
c`090000002BTLl0TY7?09:Ac`2FSl/0Ui?=09:Ac`000000UXo;00<0U8o<
0P2FSl/01P2BTLl0000009NCc@2BTLl0Ui?=09:Ac`P0000000@0TYGC09NL
e`2BUM<00000202GW=L00`000000V:3I09RPf@0609RPf@060000002MYM`0
Uj?M09fUg02GXmd0WJGL0P2GXmd00`2MYM`00000000000020000000409oE
nP2Vc_D0Y/ke0:CNn`<0Y/ke00<0Y=kk0000000>0000100000020=[nc`03
0000003Fm^<0e_KS0080e_KS0P0000020;oJk@090000002Q/><0W[?V0:6`
h`2N/nH0XK3S09jciP000000RHkB00D0PhgE00<0000007Eea@1eMLD00P00
00000`29S]80000007Yha@0407Yha@030000001bJk/0LV^k00<0LV^k00<0
000006iS]P1^HkH00P0000000`1iKk`0000007AW]@0607AW]@030000001b
Hk80LV>b00@0LV>b00<000000>3Oh`3Pgn<0303Pgn<00`000000h=oS0>3O
h`040>3Oh`040000003Pgn<0h=oS000000@0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQL0h=oS00<000000>3Oh`3Pgn<0
2P3Pgn<00`000000U;[a09Bjl@0409Bjl@030000002F]Nd0U[G]00@0U[G]
00H0000009:^j@2B[^T0WKKZ09:^j@2M]^X209:^j@050000002KZ^40Uj_U
09^Zh@2GZnD01`00000308jShP0<0000002BW=X0SZ?R09:LfP2>Xn80TYcJ
08jKf`000000SYSI09:LfP2>V=T0TYcJ0`000003096GeP0508jHf@2BUM<0
SYSI09:Ed`0000000P2BUM<01P2AUmH0Si?C09:Ed`2BUM<0000009NFd@H0
TYCB00<0000009:Ac`2BTLl01@2BTLl00`000000TY7?09:Ac`0509:Ac`03
0000002FSl/0UXo;0080TY7?1`0000003@2BUM<0UYWD09:Ed`2FVM@00000
09NLe`2BUM<0UicG09:Ed`2GW=L0UYWD09NLe`000000202GW=L00`000000
V:3I09RPf@0609RPf@040000002MYM`0WJGL09NSg@80WJGL0P0000020:76
l`090000002Vc_D0ZMKg09oEnP2Vc_D0WmGj0:K>m@2Tg_/0Y/ke00800000
0P2@k^/200000080f_k?00@000000=Kfh`3Fm^<0e_KS0P0000040;oJk@03
0000002N/nH0W[?V00@0W[?V00@0000008>=e@23SMD0RHkB0`23SMD00`00
0000MGG507Eea@0207Eea@8000001P1jN<D00`000000NFnl079[^`02079[
^`8000000`1^HkH3000000H0M6Ne00<00000079S/P1bHk80101bHk800`00
0000h=oS0>3Oh`0<0>3Oh`030000003Pgn<0h=oS00H0h=oS00<000000>3O
h`3Pgn<00`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn5P3Pgn<00`000000h=oS0>3Oh`0<0>3Oh`030000002D^_40U;[a
00@0U;[a00<0000009Jek@2F]Nd0102F]Nd01@000000WKKZ09:^j@2GZnD0
TZkY00L00000102=YND00`000000TjKR09:LfP0208jShP0908fUi@000000
TYcJ09:LfP2>Vm/0TYcJ08jShP2BW=X0SZ?R00@0000000d0TYcJ08jHf@2B
W=X0000008jHf@2GW=L0TYGC08jHf@2GW=L0Si?C0000002BUM<0Si?C00@0
TYGC00<0Si?C0000002BU=801P2BU=800`000000TY7?09:Ac`0309:Ac`80
TYCB00@0000009:Ac`2BTLl0TY7?2000000309:Ed`040000002BUM<0TYGC
09JIe0@0TYGC00T0000009NLe`2BUM<0UicG09:Ed`2GW=L0TYGC09NLe`00
0000202GW=L00`000000V:3I09RPf@0609RPf@030000002CY^80WJGL00<0
00001@2Qa_<020000000Y/ke09oEnP2Ye_L0Y/ke0:WFm`0000003P000P2@
k^/:000000L0_m[]00<0000009jciP2N/nH00`2N/nH00`2Q]^L0000008>=
e@0208>=e@0308V>dP23SMD0000000<0MGG500<0KW?707Eea@0000000P00
00001@1dN/X0NWS507Yha@1jN<D0000000@0LV^k00<0000006iS]P000000
101^HkH00`000000M6Ne07AW]@0407AW]@030000001bHk80LV>b00@0LV>b
00<000000>3Oh`3Pgn<03@3Pgn<00`000000h=oS0>3Oh`060>3Oh`030000
003Pgn<0h=oS0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOQH0h=oS00<000000>3Oh`0000003@3Pgn<00`000000U;[a
09Bjl@0409Bjl@030000002F]Nd0U[G]0080U[G]1P00000408f[jP050000
002=ZnX0SJGU08fUi@2E[>H00P2=YND030000000SZ?R08jShP2>Xn80TYcJ
09>VhP2>Xn80000008jShP2BW=X0SZ?R09:LfP<0000000L0TYcJ08jHf@2B
W=X0SYSI09:LfP2>V=T000000080TYGC00H0SYSI096GeP2?Tm<0UicG08jH
f@00000209:Ed`0708nCd`2BUM<0TYGC09:Ed`000000Si?C09NFd@0509:D
dP050000002BTLl0TYCB09:Ac`2BU=801`0000001@2?Tm<0TYGC08nCd`2B
UM<0000000L0TYGC0140000009:Ed`2BUM<0TYGC09JIe02BUM<0UYWD09:E
d`000000TYGC09NLe`2FVM@0UicG09:Ed`2GW=L0TYGC0000000809NLe`03
0000002HX=T0V:3I00@0V:3I00@0Uj?M00000000000000002@2Qa_<00`00
0000ZMKg0:K>m@0200000080T>k[100000020=[m^P060000003Jo/l0f_k?
0000003Fm^<03P001`2of^d500000080WZkS00<0000008>=e@23SMD01023
SMD00`000000MGG507Eea@0307Eea@080000001[I[X000000000001dN/X0
NWS50000001iKk`4079[^`800000101^HkH3000000D0M6Ne00<00000079S
/P1bHk800`1bHk800`000000h=oS0>3Oh`0>0>3Oh`030000003Pgn<0h=oS
0080h=oS00@000000>3Oh`3Pgn<00000103Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn5P3Pgn<2000000l0h=oS00<00000
09Bjl@2D^_400P2D^_46000000<0SK;_00<0000008f[jP2=ZnX01@2=ZnX0
0`000000TjKR08fUi@0208fUi@0308f[jP2CY^80000000@0SZ?R00<0TjKR
09:LfP0000000`0000005@2?Wmh0TYcJ08jKf`000000TYcJ08jHf@2BW=X0
SYSI09:LfP2>V=T0000008jHf@2?Tm<0UicG08jHf@2?Tm<0SYSI0000002B
UM<0Si?C096GeP0408nCd`030000002BU=80TYCB0080TYCB1`00000208nC
d`0309:DdP000000Si?C00D0TYGC00<0Si?C0000002BUM<01P2BUM<00`00
0000TYGC09JIe00509:Ed`090000002GW=L0UYWD09:Ed`2GW=L0UYWD09NL
e`2BUM<0000000P0UicG00@0000009RPf@2HX=T0V:3I100000000`2M]^X0
Xkk/000000090:76l`X000000P3JoKX01@000000f_k?0>Cee0000000gOKM
0080e_KS00<000000;oJk@2of^d0100000000`2Q]^L0000008>=e@0208>=
e@D000001023SMD00`000000MGG507Eea@0307Eea@040000001[I[X0JfJj
079[^`80000000<0M7[:0000001bJk/00`1bJk/00`000000KV>f00000004
06iS]P030000001^H;80000000@0M6Ne00<00000079S/P1bHk80101bHk80
0`000000h=oS0>3Oh`0<0>3Oh`<00000103Pgn<2000000D0h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQH0h=oS00<00000
0>3Oh`3Pgn<03`3Pgn<4000000<0R;Kd00<0000008fbk`2=/^l0102=/^l0
0`000000SJ_Z08f[jP0408f[jP080000002=ZnX0SJGU09>VhP2=YND0TjKR
08fUi@00000408jShP@000000P2BW=X02`2>Xn80TYcJ08nOgP2?Wmh00000
09:LfP2>V=T0TYcJ08jHf@2BW=X000000080TIOF0P2BUM<01`2GW=L0Si?C
09:Ed`000000TYGC08nCd`2GU]40200000001@2=UMH0Si?C08fEeP000000
TYCB00H0Si?C00H0000008nCd`2BUM<0Si?C09:Ed`2?Tm<209:Ed`030000
002BUM<0TYGC00D0TYGC00T0000009:Ed`2BUM<0UYWD09:Ed`2FVM@0TYGC
09JIe00000000P2GW=L00`2BUM<0UicG09:Ed`0209NLe`030000002GW=L0
UicG00<0UicG00<0TYcJ09NLe`0000000`00000209fjk@060:>nk02M^^d0
Xkk/09ffjP2M^^d000001P2Qa_<2000000030:S[nP2IiO/0Z>_j00800000
00@0YOKF0000003<nJd000000P3JoKX010000000f_k?0000000000050=Kf
h`8000001P2Q]^L00`000000PhgE08>=e@0308>=e@040000001[M<X00000
00000080PhgE00L0000007Eea@1eMLD0MGG506ica`1eMLD0000000D0JfJj
0P000004079[^`040000001^HkH0KV>f000000<0KV>f00<0000006iP/P1^
H;800P00000207AW]@030000001^HkH0LV>b00@0LV>b00<000000>3Oh`3P
gn<03P3Pgn<00`000000h=oS0>3Oh`090>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWhF0>3Oh`030000003Pgn<000000100
h=oS00<0000008Rfm028]_@01028]_@00`000000SK;_08fbk`0408fbk`03
0000002=ZnX0SJ_Z00@0SJ_Z00<0000008fUi@2=YND00`2=YND00`2=ZnX0
000000000002000000<0SZ?R00`0000008jShP2>Vm/0SioN08jKf`2?Wmh0
SY_K0000002>V=T0TYcJ08jHf@2BW=X=000000@0SIGF00T0000008fEeP2?
Tm<0SIGF08nCd`2=UMH0Si?C08fEeP0000001@2?Tm<00`2BU=80000008nC
d`0509:Ed`0308nCd`000000TYGC00H0TYGC00<0000009:Ed`2BUM<01P2B
UM<01@000000TYGC09NLe`2BUM<0UicG0080TYGC00@0000009NLe`2GW=L0
TYcJ100000003@2N[^<0WKKZ0000002S_^`0WK[]0:>nk02M^^d0WKKZ0:6o
kP2M]^X0Xkk/0:2mk@0000000P2Qa_<30000000609WUn`2XjoX0Z>_j0:S[
nP000000YOKF100000020=[m^P030000003Jo/l03P0000D0e_KS0P000000
0`36gn/000000:6fi`050:6fi`0500000023SMD0OiKP08>=e@1oU^000P23
SMD00`000000KW?706ica`020000000308>=e@000000MGG500@0MGG500@0
000006]V^P1[I[X0J6Fl0P1[I[X2000000@0LV^k00<0000006iS]P000000
0`1^HkH00`000000KV2b06iP/P0206iP/P030000001dIkD0000000H0LV>b
00<000000>3Oh`3Pgn<03`3Pgn<00`000000h=oS0>3Oh`080>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhF0>3Oh`800000
4P3Pgn<2000000D0R;Kd00<0000008fbk`2=/^l0102=/^l00`000000SJ_Z
08b^k00408f[jP040000002=ZnX0SJGU08fUi@<0000000@0SJGU08jShP2>
Xn80SZ?R3P0000001028V]h0RiOJ08^GfP00000208^GfP0508jHf@2;UmX0
SYSI08^GfP0000001P2=UMH02@000000SIGF08fEeP2?Tm<0SIGF08nCd`2=
UMH0Si?C0000000708nCd`060000002?Tm<0TYGC08nCd`2BUM<0Si?C0P2B
UM<00`000000TYGC09:Ed`0409:Ed`03096GeP000000TYGC00H0TYGC00D0
000009NLe`2BUM<0TYGC09NLe`060000000509j^h`2M]^X0WZkS09N[i@2M
]^X00P2N[^<02@000000WK[]09fjk@2S_^`0WKKZ0:2mk@2S_^`0XKo^0:>n
k00300000080Z>_j00<0VNGk0:S[nP2XjoX01P0000001P3<nJd000000=[m
^P000000f_k?000000D0e_KS00D000000<KYkP36gn/0a^W^000000070:6f
i`0300000023SMD0PhgE0080PhgE00<0OiKP0000001^LlL00`1^LlL20000
00D0MGG500X0000006]V^P1[I[X0J6Fl06ica`1[I[X0000006YO/`000000
NFnl0P1bJk/010000000KV>f06iS]P00000306iS]P030000001^H;80KV2b
0080KV2b0`000005079S/P030000003Pgn<0h=oS00l0h=oS00<000000>3O
h`3Pgn<0203Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn0`3Pgn<2000000@0h=oS0P0000040>3Oh`8000001@3Pgn<00`00
0000h=oS0>3Oh`0C0>3Oh`0300000028]_@0R;Kd00<0R;Kd00D0000008fb
k`28]_@0SK;_08Rfm00C000000@0QigR00P0000008RJgP27WN80R9[N08nO
gP28V]h0QigR000000@0RiOJ00H0R9[N0000002;UmX0SYSI08^GfP2>V=T2
08^GfP030000002?Tm<0RiOJ00D0SIGF00D0000008nCd`2=UMH0Si?C08fE
eP0208nCd`0308fEeP000000Si?C00@0Si?C00<0TYCB0000002?Tm<01@2B
UM<00`2?Tm<0000009:Ed`0409:Ed`0308nCd`2GU]40000000L0TYGC1@00
0000502GZnD0Vj[Q09N[i@2KZ^40000009j^h`2M]^X0Uj_U09ffjP2N[^<0
WKKZ09j^h`2M]^X0000009fjk@2S_^`0WK[]0:>nk02P_Nd0Xkk/0P000000
102Ye_L0Y=kk0000000000020:S[nPL0000000<0c?V]0000003JoKX01000
00030=Kfh`8000001@36gn/00`000000XKKW0:6fi`040:6fi`0400000023
SMD0PhgE07nFh080PhgE00<0000006]dbP1eMLD00`1^LlL3000000@0MGG5
00<0000006]V^P1bJk/00`1[I[X01P000000J6Fl000000000000LV^k0000
00<0KV>f00@0000006iS]P1^HkH000001P1^H;800`000000KV>f079S/P04
079S/P030000003Pgn<0h=oS00h0h=oS0P0000090>3Oh`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`040000003Pgn<0
h=oS000000P0h=oS00@000000>3Oh`3Pgn<000000`3Pgn<00`000000h=oS
0000000E0>3Oh`X0000000@0Nj_a07ZamP24[Nl000000P23Y^/300000003
08>Vj`000000PjK[00@0QJ?W00D0000008NMhP27WN80QigR08FSi`0208NM
hP050000002?Wmh0R9[N08RJgP27WN800P28V]h010000000R9[N08^GfP28
V]h308^GfP090000002;UmX0RiOJ08^GfP2>V=T0RiOJ08jHf@000000Si?C
00D0SIGF00D0000008fEeP2?Tm<0SIGF08nCd`0208fEeP0308nCd`000000
Si?C00H0Si?C00D0000008nCd`2BUM<0Si?C09:Ed`0208nCd`0309NFd@00
0000TYGC00@0TYGC0P2AUmH00`000000TYGC09:Ed`0400000080Uj?M00<0
000009^Zh@2KZ^40102KZ^400`2GZnD0000009ffjP0209j^h`0609ffjP2N
[^<0Uj_U09ffjP2N[^<000000P2P_Nd3000000H0Y=kk1`0000000`2]l:/0
3P0000000004000000030>Clb@3Jo/l00000008000000P36jNh00`36gn/0
a^W^0<KOj`020<KOj`D000000`2Q]^L020000000PhgE08>=e@23SMD0OiKP
08>=e@000000JgC:101^LlL00`000000J6Fl0000000307Eea@030000001[
I[X0JfJj00<0JfJj00H0000006IN]@1VG[D0IFo800h00000000406iS]P03
0000001^HkH0000000H0KV2b0`0000001@1^HkH0LV>b079S/P1bHk800000
00d0h=oS0`0000000`3Pgn<000000>3Oh`080>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh20>3Oh`040000003Pgn<0h=oS
000000/0h=oS00@000000>3Oh`3Pgn<0h=oS0P00000G0>3Oh`030000001j
/OH0N[7f00<0N[7f00L0000007^[l@24[Nl0Nj_a08B]k`1kZo40Q:g_0080
000000D0PjK[08B]k`23Y^/0PjK[0000000608FSi`0<00000025XnL0QigR
08NMhP2?Wmh0QJ?W08NMhP000000R9[N08NMhP28V]h0QigR0P28V]h01`00
0000RiOJ08^GfP28V]h0RiOJ08RJgP0000000P2;UmX01@2>V=T0RiOJ08jH
f@2;UmX0000000L0SIGF00@0000008fEeP2?Tm<0SIGF0`2?Tm<00`2=UMH0
000008nCd`0508nCd`060000002?Tm<0TYGC09:Ed`2?Tm<0UiKA0P2?Tm<0
1@000000Si?C09:Ed`2?Tm<0TIOF00H000001P2GXmd01P000000Vj[Q09^Z
h@2GZnD0Vj[Q09N[i@80Vj[Q00T0000009j^h`2N[^<0WKKZ09N[i@2N[^<0
WKKZ09j^h`2M]^X00`0000020:CNn`030:WFm`2Tg_/0ZMKg00<0Y=kk0P00
00000`2WmnD000000:GfeP02000000030<ci[@00000000000080000000@0
iO^j0000003Jo/l0i?c90P3TmM@010000000i?GD0000000000020<KOj`<0
000000<0ZlG/0:O0j`0000000P25UM/50000000508>=e@1oU^00QIGK08>=
e@0000001@1^LlL00`000000J6Fl05eQ_P020000000307Eea@000000JfJj
00<0JfJj00<0KW?70000001ZGk<00`1VG[D20000000406iS]P1bHk80KV>f
00000080KV>f00<0000006iP/P1^H;80101^H;800`000000KV2b00000003
079S/P030000003Pgn<0h=oS00L0h=oS100000040>3Oh`030000003Pgn<0
h=oS00L0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOP80h=oS00@000000>3Oh`3Pgn<000002@3Pgn<2000000@0h=oS00<0
00000>3Oh`3Pgn<05`3Pgn<00`000000N[7f07ZamP0307ZamP030000001j
/OH0Q:g_00@0000000P0Q:g_07ZTk@23Y^/0PjK[08B]k`23Y^/0000008>V
j`@0QJ?W00@0000008>Mi027WN80QJ?W0`27WN800`000000QigR08RJgP02
08RJgP0408NMhP28V]h0000008RJgPD0RiOJ00P0000008^GfP2;UmX0SYSI
08^GfP2>V=T0RiOJ000000L0SIGF00<0000008fEeP2?Tm<0102=UMH00`00
0000Si?C08nCd`0208nCd`<0TYCB00<0000008nCd`2?Tm<00P2?Tm<70000
000609:LfP2GXmd0TYcJ09:LfP000000Uj_U1`2GXmd00`000000Vj[Q09^Z
h@0309^Zh@0809N[i@2KZ^40000009ffjP2N[^<0WKKZ09j^h`2M]^X20000
0080Y/ke00<000000:CNn`2Tg_/0102Tg_/2000000030:Ogi@0000000000
00<0000000`0[O2[000000000000f_fj0000003UnkX0f_fj0000003TmM@0
f_k?0>Clb@0000040=gfg@8000000P2W`>/0102[aN`0Yl3[0:O0j`000003
08FEf`0407nFh025UM/0000006]dbP8000000P23SMD010000000JgC:07Ee
a@1[M<X206ica`030000001XIK`0J6Fl0080J6Fl0`00000406]V^P030000
001XIK`0JUnc00<0IUje00<0000006]V^P1^HkH00P1^HkH00`000000KV>f
0000000606iP/P030000001^H;80KV2b0080000000<0LV>b0000003Pgn<0
1@3Pgn<3000000P0h=oS00<000000>3Oh`3Pgn<01`3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3Pgn<010000000h=oS
0>3Oh`0000090>3Oh`030000003Pgn<0h=oS00<0h=oS0P00000I0>3Oh`03
0000001j/OH0N[7f0080N[7f0`0000001`1j/OH0Nj_a08B]k`1kZo400000
08>Vj`24[Nl01023Y^/00`000000QJ?W08FSi`0308FSi`0300000027WN80
QigR0080QigR00H0QJ?W08NMhP000000SioN08RJgP27WN8308RJgP080000
0028V]h0RiOJ08RJgP2;UmX0R9[N08^GfP00000608^GfP030000002=UMH0
SIGF00@0SIGF00<0000008fEeP2=UMH01@2?Tm<010000000TYCB09:DdP2B
U=88000000@0TYcJ00<0000009NSg@2BW=X00`2BW=X00`2GXmd0000009NS
g@0709NSg@050000002KZ^40Uj_U09^Zh@2GZnD0102KZ^400`000000WZkS
09ffjP02000000D0Y/ke0P0000020:CNn`80000000<0YoOU000000000000
1@0000002@3<nJd000000=[m^P3JoKX000000>Clb@000000i?GD0>Clb@02
000000030>Cee03Fm^<0gOKM0080000000<0d>CV0000002W`>/00`2W`>/0
2@2[aN`0Yl3[00000025UM/0OiKP08>=e@1oU^00QIGK0000000206]dbP80
000000<0PhgE0000001^LlL00P1^LlL01P1[M<X0MGG50000001MHKh0J6Fl
05eQ_P80J6Fl00<0000006]V^P1[I[X00P1[I[X010000000IUje06YO/`1Z
Gk<206IN]@<000000`1^HkH2000000H0KV2b00<0000006iP/P1^H;800P1^
HkH300000080h=oS0`00000<0>3Oh`030000003Pgn<0h=oS00H0h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP<0h=oS0P00
000:0>3Oh`<000000`3Pgn<00`000000h=oS0>3Oh`0I0>3Oh`X0000000<0
Q:g_07^[l@0000000P23Y^/01@24[Nl0PjK[08>Vj`000000PjK[00@0QJ?W
00<0PjK[00000025XnL01027WN800`000000R9[N08RJgP0208RJgP0308nO
gP28V]h0000000H0RiOJ00<0000008^GfP2;UmX0102;UmX00`000000SIGF
08fEeP0208fEePh00000102>V=T02@000000UicG08jHf@2BW=X0SYSI09:L
fP2>V=T0TYcJ0000000209:LfP0309NSg@2?Wmh0TYcJ0080TYcJ00<00000
09NSg@2GXmd01P2GXmd00`000000Vj[Q09^Zh@0509^Zh@<00000202Vc_D<
0000000D0<ci[@00000000000=[m^P000000iO^j0000003Jo/l0i?c90000
003Fm^<0i?GD0=Kfh`3TmM@000000<KYkP3CkNH0a^W^0000002Wa^l60:O0
j`0300000025UM/0QIGK0080QIGK00D0000006]dbP1[M<X0IWK?06]dbP02
0000000606]dbP1eMLD0JgC:07Eea@1[M<X000000`1XIK`0101MHKh0J6Fl
00000000000406]V^P090000001VG[D0J6Fl06YO/`1VG[D0JUnc0000001Z
Gk<0000000<0KV>f0P00000506iP/P030000001^H;80KV2b00<0KV2b00@0
KV>f00000000000000003`3Pgn<00`000000h=oS0>3Oh`060>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhE0>3Oh`030000
003Pgn<0h=oS01L0h=oS1000000506fWm0030000001]Yo@0KJOd02l00000
0`2;UmX02@000000RiOJ08^GfP2;UmX0SYSI08^GfP2>V=T0RiOJ00000006
08jHf@030000002BW=X0TYcJ00H0TYcJ00P0000009:LfP2BW=X0Uj?M09:L
fP2GXmd0TYcJ000000P0Uj?M00@0000009^Zh@2KZ^40Vj[Q100000020:6o
kP030000002Vc_D0Y/ke00@0Y/ke0P0000000`2dm?<0Z>_j0;Cdl`020000
0080YoOU1`0000005P3JoKX000000>Clb@000000i?c90>Cee0000000i?GD
0=Kfh`3TmM@0e_KS0000003@i>H0dngV0=3TiP3CkNH0d>CV0000002W`>/0
YlK_0:O0j`2Wa^l20:O0j`0600000025UM/0QIGK07nFh025UM/000001@1[
M<X30000000707AjbP1^LlL0JgC:06ica`000000J6Fl05eQ_P0206QU_003
0000001PG;H000000080JfJj00X0KW?70000001VG[D0JUnc06IN]@1ZGk<0
J6Fl0000001VG[D0JUnc0P0000000`1^HkH000000000000606iP/P070000
001^H;80KV>f06iP/P1^HkH0KV2b0000000A0>3Oh`030000003Pgn<0h=oS
00H0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OQ@0h=oS00<000000>3Oh`3Pgn<05@3Pgn<3000000@0h=oS0P00000406fW
m0040000001]Yo@0KJOd07NSkP80KJOd00<0000007ZTk@1hWnX00`1gXnh0
0`000000N9oZ07ROjP0407^LiP070000001kW>H0NicV086Ih@23WN@0NicV
00000006086Ih@0300000024Umh0Q9ON00@0Q9ON00P0000008FEf`25UM/0
QIGK08^GfP25UM/0RiOJ00000080RiOJ00D0QIGK08^GfP2;UmX0RiOJ0000
000308^GfP0408jHf@2;UmX0SYSI000000L0SYSI00T0000008jHf@2BW=X0
SYSI09:LfP2>V=T0TYcJ08jHf@0000001P2BW=X00`2GXmd0000009>VhP03
09NSg@0309:LfP2GXmd0Uj?M00@0000000@0XKo^0:76l`2Q_nh0XLKc0`2Q
_nh200000080Y/ke0P0000001@2dm?<0Z>_j0:S[nP2XjoX000000080YoOU
0`0000000`2]l:/0000000000002000000040=[m^P000000i?c90>Gk^P<0
000000<03P000=gfg@3Mm]d00P0000000`3CkNH0d>CV0=3TiP030=3TiPT0
00000`25UM/0101oU^00000006]dbP1UKlP306]dbP070000001FG[l00000
06]dbP1eMLD0JgC:0000000206QU_00605eQ_P1XIK`0J6Fl0000001PG;H0
00000P1[I[X010000000IUje06QU_01ZGk<206IN]@080000001ZGk<0IUje
06IN]@1WGK<0000006iS]P00000606iP/P080000001^H;80KV2b06iS]P1^
H;80KV>f06iP/P00000@0>3Oh`030000003Pgn<0h=oS00H0h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQ@0h=oS0`00000B
0>3Oh`<000002@3Pgn<00`000000KJOd06fWm00206fWm0040000001]Yo@0
KJOd07NSkP80KJOd00h0000007ROjP1gXnh0N9oZ07NSkP1hWnX0000007RO
jP1kW>H0NZC]07^LiP1jY>d0000008>Mi0<0NicV00<0PigT00000021VN40
1@21VN400`000000Q9ON08BGgP0408BGgP080000002;UmX0QIGK08^GfP24
Umh0RiOJ08FEf`00000608^GfP090000002;UmX0RiOJ08jHf@2;UmX0SYSI
08^GfP2>V=T0000000L0SYSI00<0000009:LfP2GW=L01@2BW=X01@000000
TYcJ09NSg@2BW=X0Uj?M0080TYcJ00@0000009NSg@2GXmd0Uj?M10000002
09ffjP030000002Q_nh0XKo^00D0XKo^00D0XLKc0:6okP2Qa_<0000000h0
00040:S[nP090;Cdl`000000YoOU0:Ogi@000000[O2[0000002]l:/00000
0080c?V]00<000000=[m^P3JoKX01@0000000`3Zm</0i?c9000000020000
00<0d>CV100000020;K?k@0300000027WN80QigR00<0QigR0`00000208FE
f`070000001[M<X0JgC:06]dbP1UKlP0JgC:0000000205eQ_P80000000<0
JgC:0000001MHKh00P1XIK`00`1MHKh0J6Fl00000002061L]P090000001[
I[X0000006IN]@1ZGk<0IUje06YO/`1VG[D000000080JUnc0`1WGK<30000
00D0KV2b00<0000006iP/P1^HkH0101^H;800`000000h=oS0>3Oh`0>0>3O
h`030000003Pgn<0h=oS00H0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOQ@0h=oS00<000000>3Oh`3Pgn<03`3Pgn<30000
00d0h=oS0`00000206fWm0070000001]Yo@0KJOd06fWm01gXnh0000007RO
jP0407NSkP0307ROjP000000NicV0080NicV00H0NZC]07^LiP000000PigT
07^LiP21VN4207^LiP0300000021VN40PIWQ00@0PIWQ00<0000008BGgP24
Umh01024Umh020000000RiOJ08BGgP2;UmX0QIGK08^GfP24Umh000000P2;
UmX01@25UM/0RiOJ08FEf`2;UmX000000080RiOJ00D0SYSI08^GfP2>V=T0
RiOJ0000000708jHf@0909:LfP000000SY_K09:LfP2>V=T0TYcJ08jHf@2B
W=X0000000@0TYcJ1P00000709ffjP030000002Q_nh0XLKc00<0XKo^00D0
XLKc0:6okP00000000000:WFm`02000000040;Cdl`2XjoX0000000000080
YoOU0`000000102]l:/000000<ci[@3<nJd2000000040=[m^P0000000000
00000080iO^j00@000000>Clb@3To<T000000P3TmM@3000000H0]/o]00<0
000008NMhP27WN801027WN801P000000IWK?000000000000QIGK000000@0
JgC:00D0000005IN_`1TI;`0EUjo06AT_0030000000C06QU_01MHKh0J6Fl
06QU_0000000H5bf06IN]@1PG;H0000006]V^P000000IUje06QU_01VG[D0
JUnc06IN]@000000JUnc06IN]@0406MM/`800000101^H;8020000000KV2b
06iP/P1^HkH0KV2b06iS]P1^H;800000403Pgn<00`000000h=oS0>3Oh`06
0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhD
0>3Oh`030000003Pgn<0h=oS00`0h=oS0`00000A0>3Oh`030000001MWo<0
000000D000000P1]Yo@00`000000N9oZ07ROjP0207ROjP80NZC]00<00000
07ZTk@1kW>H00`1kW>H01`000000NicV07^LiP1kW>H0PigT07^LiP000000
1@21VN400`000000Q9ON08BGgP0408BGgP080000002;UmX0QIGK08^GfP24
Umh0RiOJ08FEf`00000608^GfP090000002;UmX0RiOJ08^GfP2>V=T0RiOJ
08jHf@2;UmX0000000D0SYSI00D0R9[N09:LfP000000TYcJ08jKf`0209NL
e`030000000>0000000000@000000P2GZnD00`2N[^<0Uj_U0000000809ff
jP040000002Q_nh0XKo^0:6okP80XLKc0P0000020:WFm`030:CNn`2df?80
Y=kk00D0000000<03P000000000000000`0000000`3<nJd0000000000002
000000080>Gk^P000000iO^j0>Gk^P0>0000i?c90>[db`0000030>Cee003
00h0003Fm^<03P0000L0]/o]00<0000008NMhP27WN800`27WN8010000000
IWK?06Ifc`1VM/l2000000D0JgC:00<0000005eQ_P1MHKh00`1MHKh01P00
0000J6Fl06QU_01MHKh0J6Fl000000@0H5bf0P00000206IN]@0506YO/`1X
IK`0IUje0000001VG[D01@1WGK<2000000D0KV2b00@0000006iS]P1^H;80
KV>f0P1^H;800`000000h=oS0>3Oh`0>0>3Oh`030000003Pgn<0h=oS00H0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQ@0
h=oS0P00000;0>3Oh`8000005@3Pgn<2000000<0GIoc00<0000005fOl`00
00003000000207^LiP0300000023WN@0NicV00@0NicV00<00000086Ih@21
VN400`21VN400`000000Q9ON08BGgP0408BGgP0800000025UM/0QIGK08^G
fP25UM/0RiOJ08FEf`00000608^GfP030000002;UmX0RiOJ00@0RiOJ00H0
000008jHf@2>V=T0TYcJ08RJgP2BW=X7000000@0TjKR00D0000009j^h`2G
ZnD0Uj_U09j^h`0309N[i@030000002M]^X0WKKZ00H0WKKZ00<000000:6o
kP2Q_nh00P000000102fioH0Y=kk0:WFm`2fioH20:CNn`8000000P2dm?<2
000000030:Ogi@00000000000080000000X0c?V]00000000000000000>Gk
^P000000iO^j0000003/nKX000000P3To<T01P000000i?GD0>Cee03TmM@0
00000=c^gP80dngV00<000000;K?k@2fcnd0102fcnd00`000000QigR08NM
hP0408NMhP040000001VM/l0IWK?06Ifc`800000101[M<X01P000000EUjo
06AT_01FG[l0I6Bl05IN_`8000000`1XIK`00`1MHKh0000006IN]@02061L
]P0306IN]@000000JUnc00@0IUje00<0000006YO/`1VG[D01@1WGK<30000
00<0KV2b00D0000006iP/P1^HkH0KV2b06iS]P0206iP/P030000003Pgn<0
h=oS00h0h=oS00<000000>3Oh`3Pgn<01@3Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn503Pgn<00`000000h=oS0>3Oh`07
0>3Oh`<000006@3Pgn<01P000000GIoc05fOl`1MWo<0000006fWm0<0GIoc
00<0000006JJkP1VV^h00P1VV^h0101VX?40KY[[0000001^V^/700000004
08>Mi01kW>H0000008>Mi0@0PIWQ00<0000008BGgP24Umh01024Umh02000
0000RiOJ08^GfP24Umh0RiOJ08BGgP2;UmX000001P2;UmX00`000000RiOJ
08^GfP0208^GfPP0000000D0TYcJ08jShP2BW=X0TYcJ0000000609>VhP03
0000002GZnD0Uj_U00H0Uj_U00<0000009ffjP2M]^X00P2M]^X00`2Q]^L0
WKKZ0:6fi`03000000<0ZMKg00<0]^Of0:WFm`2Tg_/00P0000030;Cdl`03
00h0002Um]H0000000@000000P3<nJd02@000000f_fj0>Gk^P000000iO^j
0000003To<T0k?Vj00h000020>Clb@090000003TmM@0i?GD0000003Lk]h0
dngV0=Kfh`3Ti=<0e_KS00T000001027WN800`000000IWK?06Ifc`0206If
c`<0000000@0IWK?06]dbP1[M<X00000101MHKh010000000FUVg0000001M
HKh206QU_0030000001PG;H0H5bf0080H5bf0P00000206YO/`80IUje00<0
JUnc0000001VG[D01@1WGK<010000000JUnc00000000000206iP/P030000
001^H;80KV2b00@0KV2b00<000000>3Oh`3Pgn<03P3Pgn<00`000000h=oS
0>3Oh`050>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWhC0>3Oh`030000003Pgn<0h=oS00D0h=oS0`00000M0>3Oh`800000
0P1MWo<00`000000GIoc06fWm00205fOl`030000001VV^h0KY[[00<0IY[^
00T0000006jJj`1^V^/0KY[[07BEi01^V^/0000007ZGh`1dUN@08P000000
2P2?Wmh0R9[N08nOgP28V]h0000009:LfP2>Xn80TYcJ08jShP2BW=X208jS
hP030000002CY^80TjKR00D0TjKR00<0000009j^h`2GZnD00P2GZnD01@2N
[^<0Uj_U09N[i@2N[^<000000080WKKZ100000020:K>m@8000000P2Tg_/0
0`2Ye_L00000000000030;Cdl`80000000<0YoOU00000034oLH00`000002
0<ci[@80000000X0iO^j0000003UnkX000000>ci^P3UnkX000000>[db`3T
o<T03P000P3TmM@01@000000dngV0=Kfh`3Vk]<0dngV0080000000@0a]o[
0000002B[^T0Uj_U0`2B[^T00`000000IgkF000000030000000308NMhP00
0000IWK?0080IWK?00@00000051Pa01FG[l03P000P1[M<X00`000000GF6n
05eQ_P0305eQ_P080000001JFKL0000006QU_01MHKh00000061L]P1VG[D2
061L]P0406IN]@000000000000000080JUnc00@0IUje0000001ZGk<0IUje
101WGK<00`000000JUnc06YO/`020000000606iP/P000000KV>f06iS]P1^
H;80KV>f0P1^H;800`000000h=oS0>3Oh`0>0>3Oh`030000003Pgn<0h=oS
00D0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OQ<0h=oS0`0000020>3Oh`<000008@3Pgn<50000000505fOl`1]Yo@0GIoc
06JPl@0000000P1VV^h0101^V^/0IY[^06JJkP00000506jJj`070000001d
UN@0M9GT07BEi01kW>H0M9GT0000000507ZGh`030000001oU^00OiKP00@0
OiKP00<0000008BGgP24Umh01024Umh00`000000R9[N08RJgP0408RJgP0A
0000002?Wmh0R9[N08nOgP28V]h0SioN08jKf`000000SZ?R09:LfP2>Xn80
TYcJ08jShP2CY^80TYcJ08jShP0000001`2CY^800`000000Uj_U09N[i@05
09N[i@<00000202Vc_D3000000<0]?Cc0P0000000`39o]`0YoOU00000003
000000030<Oj]P000000c?V]0080000000X0iO^j0000003UnkX000000>Cl
b@3/nKX000000>[db`3To<T000000P3TmM@020000000i^kC0=?]iP3Ti=<0
e_KS00000036gn/0a=[Z0P36gn/01`000000TZkY09:^j@2B[^T0Uj_U09:^
j@000000101WO]H2000000@0IWK?00H0000005IN_`1@H<@0000007AjbP00
000305eQ_P03061L]P1MHKh000000080FUVg00<0000006QU_00000001@1P
G;H010000000HU^d069K]000000206YO/`030000001WGK<0Iefc00@0Iefc
00D0000006MM/`1^H;80000006iS]P030000000306iP/P1^HkH0KV2b0080
KV2b00<000000>3Oh`3Pgn<03P3Pgn<00`000000h=oS0>3Oh`050>3Oh`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhC0>3Oh`03
0000003Pgn<00000008000009@3Pgn<00`000000BIC`04VDl00400000080
GIoc00L0000006JJkP1VV^h0IY[^06jJj`1VV^h0000000@0KY[[00<00000
07^LiP1dUN@00`1dUN@00`000000NYOS07ZGh`0307ZGh`030000001jUn<0
OiKP00@0OiKP00<0000008BGgP24Umh01024Umh00`000000R9[N08RJgP04
08RJgP040000002?Wmh0SioN08RJgP80SioN00<0R9[N08jKf`0000000P2>
Xn801P2BW=X0SZ?R09:LfP2>Xn80TYcJ000000L0TjKR00@0000009N[i@2G
ZnD0Uj_U100000020:6okP030000002Vc_D0Y/ke00D0Y/ke0P0000020;KW
mPT0000000<0a?g60000000000000P000000203JoKX000000>Gk^P000000
iO^j0000003/nKX0iO^j1`0000020=Kfh`8000001036gn/00`34f^X0a]o[
0000000409:^j@030000001WO]H0IgkF00<0IgkF0P00000306Ifc`040000
001FG[l0EUjo05IN_`<0000000H0I6Bl05IN_`1UKlP0EUjo0000001PG;H2
05YI]`050000001XIK`00000061L]P1VG[D00P1PG;H01`000000HU^d069K
]01RFk@0000006YO/`0000001`1WGK<01`000000Iefc06MM/`000000JUnc
06MM/`0000000P1^HkH406iP/P030000003Pgn<0h=oS00d0h=oS00<00000
0>3Oh`3Pgn<01@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn2`3Pgn<5000000<0h=oS0P00000Y0>3Oh`060000000iQNT0
BIC`03V5j@000000EiS`1P00000206JJkP030000001^V^/0KY[[00<0KY[[
00L0000007BEi01dUN@0N9oZ07BEi01kW>H0000000D0NYOS00<0000007nF
h01oU^00101oU^000`000000Q9ON08BGgP0408BGgP0300000028V]h0R9[N
00@0R9[N00h0000008RJgP2?Wmh0SY_K08RJgP2?Wmh0R9[N08nOgP000000
TYcJ08jShP2BW=X0SZ?R09:LfP80SioN00<0000009>VhP2CY^80102CY^84
000000L0XKo^00<000000:K>m@2Vc_D00P2Vc_D2000000@0]^Of0P000000
1`2dm?<0_OS]000000000000bOkL00000034oLH0100000001`3JoKX00000
0>Gk^P000000iO^j0000003/nKX0100000020>kd``030000003Zm</0j_C;
008000002036gn/3000000<0TZkY00<0000006MneP1WO]H00`1WO]H20000
000406Ifc`1[M<X00000051Pa0@0EUjo00<0000005eQ_P1MHKh00P1MHKh0
0`000000FUVg05YI]`0205YI]`8000001@1PG;H010000000HU^d069K]01R
Fk@3000000H0Iefc00H0000006iS]P1ZGk<0JUnc0000001^HkH300000005
06iS]P1^H;80KV2b06iP/P0000003`3Pgn<00`000000h=oS0>3Oh`050>3O
h`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh=0>3O
h`030000003Pgn<0h=oS00@0h=oS00<000000>3Oh`3Pgn<0:03Pgn<20000
000304VDl00iQNT000000080BIC`00@0EiS`04VDl0000000FYC]1`000002
06jJj`030000001dUN@0M9GT00<0M9GT00<0000007ZGh`1jUn<00`1jUn<0
0`000000OiKP07nFh00307nFh00300000024Umh0Q9ON00@0Q9ON00<00000
08RJgP28V]h01028V]h04@000000SioN08RJgP2?Wmh0R9[N08nOgP28V]h0
SioN08RJgP000000SZ?R09:LfP2>Xn80SioN08jShP2?Wmh000000080TjKR
1000000209ffjP030000002Q_nh0XKo^00L0XKo^00H000000:K>m@000000
00000;KWmP2XjoX30;KWmP050000002mn>d0_OS]0;ghk@0000000P39o]`0
10000000a?g60000000000020=[m^P80000000<0iO^j0000003UnkX01000
00000`3_mkd0k?Vj000000020>kd``050000003Zm</0j_C;0000003TmM@0
0P0000020<KOj`@0000000<0YlK_0000001`S=l01000000506MneP060000
001@H<@000000000001VM/l00000101FG[l20000000506AT_01FG[l0I6Bl
05IN_`000000101JFKL00`000000H5bf06IN]@02061L]P0306IN]@000000
H5bf00@0HU^d00<0000006MM/`1WGK<0101WGK<03P000000Iefc06YO/`1Z
Gk<0000006YO/`1WGK<0000006iS]P000000LV>b06iS]P1^H;800000403P
gn<00`000000h=oS0>3Oh`040>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWh=0>3Oh`030000003Pgn<0h=oS00D0h=oS0P00
000Y0>3Oh`D0000000D0EiS`04VDl01GV?00BIC`0000000405ZDk@030000
001TTnT0I9?Y00H000000P1dUN@00`000000NYOS07ZGh`0407ZGh`030000
001oU^00OiKP00<0OiKP00<0000008BGgP24Umh01024Umh00`000000R9[N
08RJgP0408RJgP0300000028V]h0SioN0080R9[N00P0SioN08RJgP2?Wmh0
000008jShP2?Wmh0SZ?R08nOgPD000000P2M]^X00`2B[^T0WKKZ09ffjP02
09ffjP030000002Q_nh0XKo^00D0XKo^00<0X;g]0000000000001P2fioH0
1@000000_OS]0;ghk@2mn>d000000080bOkL00X000000<CmaP0000000000
0=[m^P3Jo/l000000=[m^P000000iO^j0P0000001P3_mkd0k?Vj0>ci^P00
0000koNm00000080k_C300@000000>[db`3Zm</0000G0`3Vk]<02P3TmM@0
00000000002[aN`0YlK_0:_5k02Wa^l0ZlG/0:O6k`000003072<g`800000
101WO]H010000000D634051Pa01@H<@200000003051Pa01FG[l0EUjo0080
EUjo0P000000101FG[l0I6Bl05IN_`00000405YI]`800000101PG;H00`00
0000HU^d069K]003069K]08000001@1WGK<00`000000JUnc06YO/`0206YO
/`050000001^HkH0000006iS]P1[I[X00P0000000`1bHk8000000>3Oh`0?
0>3Oh`030000003Pgn<0h=oS00@0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOPd0h=oS00<000000>3Oh`3Pgn<01`3Pgn<0
0`000000h=oS0>3Oh`0W0>3Oh`80000000P0:HO[000000000000000004VD
l01GV?00000005NHl0<0FYC]00<0000006BCj@1TTnT0101TTnT00`000000
KYCV0000000600000080NYOS00<0000007nFh01oU^000P1oU^002@24Umh0
000008RJgP24Umh0R9[N08BGgP28V]h0Q9ON0000000608RJgP030000002?
Wmh0SioN00<0SioN1`00000409F/iP030000002M]^X0WKKZ0080WKKZ00@0
UJcV09Jek@2M]^X000000P2Q_nh0102P_Nd0XKo^0:6okP2P_Nd200000004
0:WFm`2df?80000000000080]^Of0P0000020;ghk@8000000P39o]`30000
000:0=[nc`000000f_fj0000003JoKX000000>Gk^P000000k?Vj00000080
k?Vj00<000000>og_@0000000P3^m<<010000000j_C;0>[db`0000020>K^
d`80i?GD00@000000=?]iP000000ZlG/102Wa^l00`2[aN`00000072<g`03
072<g`<000000`1WO]H010000000D634051Pa01@H<@200000080EUjo00P0
D63405IN_`000000DUJh0000001FG[l0I6Bl000000D0FUVg0P000000101V
G[D0H5bf061L]P000006069K]0<000000P1VG[D206MM/`030000001ZGk<0
JUnc0080JUnc0P00000406iS]P<000003P3Pgn<2000000H0h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPd0h=oS00<00000
0>3Oh`3Pgn<0203Pgn<00`000000h=oS0>3Oh`0X0>3Oh`030000000YQn/0
:HO[00D0000000D0EiS`05ZDk@1JU>d0FYC]0000000506BCj@030000001^
U>H0KYCV00<0KYCV00<0000007BEi01dUN@0700000001@2>Xn80SJGU08jS
hP2=YND0000000@0UJcV00H0TjKR09F/iP2GZnD0000009ffjP2B[^T209ff
jP0609N[i@2M]^X0WKKZ0000002S_^`0XKo^0`0000001P2df?80ZMKg0:WF
m`2df?80ZMKg0;CHlP`0000000H0f_k?0000003Jo/l000000=[m^P3UnkX2
000000050>ci^P000000koNm0>ci^P0000000P3_mkd010000000k_C30>kd
``0000020>[db`090000003TmM@0i?GD0>K^d`0>0000dngV0>CTd`3Ji]h0
000000@0ZlG/0P2Wa^l00`000000L8cO072<g`02072<g`030000001=HlT0
00000080IgkF00<00000051Pa01@H<@00P1@H<@01P000000EUjo051Pa01P
G;H0D63400000080DUJh00<0000005eQ_P0000001@1JFKL010000000FUVg
0000001VG[D2061L]P030000001RFk@0HU^d00<0HU^d00D0000006IN]@1V
G[D0000006YO/`0206MM/`030000001ZGk<0JUnc00<0JUnc00<0000006iS
]P1^HkH00P1^HkH00`1[I[X0M6Ne0000000>0>3Oh`8000001P3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn303Pgn<20000
00/0h=oS00<000000>3Oh`3Pgn<0:03Pgn<20000000402V7j`0000000000
03V5j@<0000000@0GIoc05ZDk@1JU>d000001@1TTnT00`000000KYCV06jD
iP0206jDiP030000001dUN@0M9GT00@0M9GT00<0000007ZGh`1jUn<00`1j
Un<00`000000PIWQ086Ih@04086Ih@050000002?Wmh0QigR08NMhP2?Wmh0
0P27WN800`000000SZ?R08jShP0508jShP030000002E[>H0Uj_U00D0UJcV
00<0000009ffjP2M]^X01@2M]^X300000080ZMKg00<0]=Sb0:WFm`2df?80
0`2Ye_L2000000040;KWmP31jO40]^Of000000<0b_OZ00D000000<Wng000
0000f_k?000000020=[m^P0<0000003JoKX000000>Gk^P000000k?Vj0000
003/nKX000000>og_@3/nKX000000P3^m<<010000000j_C;0>[db`000003
0>K^d`030000003CkNH0i>CC0080dngV00<0f^KN0000000000000P000002
0:_5k0030000001`S=l0L8cO0080L8cO00H0000004eSb@1=HlT0000006Mn
eP000004051Pa08000000P1@H<@0201FG[l0000005YI]`1;E;X0DUJh0000
001FG[l00000101JFKL00`000000FUVg05YI]`020000000306IN]@000000
HU^d00@0HU^d00D0000006IN]@1VG[D0IUje0000000206IN]@030000001Z
Gk<0JUnc00<0JUnc0P00000406iS]P0306]V^P000000h=oS00`0h=oS0`00
00060>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWhJ0>3Oh`800000:@3Pgn<500000080>HGY1@0000000`1/U^P0I9?Y06BC
j@0306BCj@030000001^U>H0KYCV0080KYCV00<0000007BEi01dUN@00`1d
UN@00`000000NYOS07ZGh`0407ZGh`0300000021VN40PIWQ00@0PIWQ00<0
000008NMhP27WN801027WN800`000000SZ?R08jShP0408jShP0308fUi@00
0000Uj_U00D0UJcV00@0Uj_U0000002M]^X0WKKZ10000000402Wa^l0XLKc
000000000000]=Sb0:WFm`2df?80ZMKg0;CHlP0000003P000;KWmP31jO40
]^Of0;Cdl`0000030<[gjP0700000039o]`000000=[nc`000000f_fj0=[n
c`03000000090>ci^P000000k?Vj0000003_mkd0k?Vj0000003_mkd00000
0080k_C300@000000>[db`3Zm</000000P3Vk]<00`3TmM@000000>CTd`02
0=3TiP070=[VgP00000000000<CJjP000000QJ?W08>Vj`04000000<0L8cO
00@0000004eSb@1=HlT0CF?90`000004051Pa08000000`1FG[l010000000
DUJh059F^01BE[P2000000D0FUVg00@0000005YI]`1KF;D0FeRe0P000005
069K]0030000001VG[D0IUje0080IUje0`00000606YO/`080000001^HkH0
JfJj06iS]P1[I[X0M6Ne06]V^P00000<0>3Oh`<000001P3Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn703Pgn<00`000000
h=oS0>3Oh`0W0>3Oh`030000000?Mn803gOR008000000P0iQNT00`000000
BIC`04R9jP0500000080I9?Y00<0000006jDiP1^U>H00`1^U>H00`000000
M9GT07BEi00307BEi0030000001jUn<0NYOS00<0NYOS00<00000086Ih@21
VN401021VN400`000000QigR08NMhP0408NMhP030000002>Xn80SZ?R00H0
SZ?R00<0000009F/iP2E[>H0102GZnD3000000050:O6k`2Qa_<0YlK_0:O6
k`2Qa_<00`2Wa^l2000000050:WFm`00000000000<7Yl@2dm?<00P2fioH2
00000080b_OZ0P0000001P3Go=d0bOkL0000003Jo/l000000=[m^P<00000
00@0iO^j0000003/nKX000000P3/nKX01P000000k?Vj0>og_@000000k_C3
0>og_@@000000P3Vk]<01P000000dngV0=3TiP3Vk]<0dngV000000<0a=[Z
00<0000008>Vj`23Y^/00`23Y^/300000080L8cO00<0000004eSb@1=HlT0
0P1=HlT00`000000D634051Pa002051Pa00600000018D;H00000051Pa01F
G[l00000101BE[P00`000000FUVg05YI]`0305YI]`050000001JFKL0FUVg
061L]P1KF;D00P000005069K]0030000001VG[D0IUje00<0IUje0P000005
06YO/`80000000<0KV>f07AW]@1^HkH00P1^HkH00`000000h=oS0>3Oh`09
0>3Oh`040000000001L00000000000H0h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOQd0h=oS00<000000>3Oh`3Pgn<09`3P
gn<0100000003gOR00mghP0?Mn820000000303V5j@000000B8WZ0080B8WZ
00<0000005b=i`1GS^X01P00000206jDiP030000001dUN@0M9GT00@0M9GT
00<0000007ZGh`1jUn<00`1jUn<00`000000PIWQ086Ih@04086Ih@030000
0027WN80QigR00@0QigR00@0000008jShP2>Xn80SZ?R102=YND00`000000
Uj_U09N[i@0400000080WK[]00D000000:76l`2Wa^l0YlK_0:76l`030:O6
k`80XLKc0P0000030;KWmP030<7Yl@2fioH0000000<0b_OZ00H000000=Ol
g@39o]`0bOkL0000003Jo/l300000080i?c90P0000020>ci^P030000003/
nKX000000080koNm1P0000000`3ak<40k_C300000002000000040>K^d`3C
kNH00000000000D0a=[Z00/0000008>Vj`25XnL0PjK[08FSi`23Y^/00000
04m]dP000000L8cO0000000404eSb@8000000`1@H<@01P000000BeBj04]D
^P000000D634000000@0DUJh0P00000405YI]`070000001JFKL0FeRe05YI
]`1KF;D0FUVg00000004069K]003061L]P000000IUje00D0IUje00<00000
06YO/`1ZGk<0101ZGk<20000000506]V^P1^HkH0JfJj06iS]P0000002`3P
gn<01@000000000G0000003Pgn<0000000D0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQh0h=oS00<000000>3Oh`3Pgn<0
9`3Pgn<0100000003gOR00mghP0?Mn8400000080BIC`00@0B8WZ0000001J
U>d0G8gW0P1GS^X00`1LSNL0000006F@i`0700000080M9GT00<0000007ZG
h`1jUn<0101jUn<00`000000PIWQ086Ih@04086Ih@0300000027WN80QigR
00@0QigR00D0000008fUi@2>Xn80SZ?R09>VhP050000000309fjk@2M]^X0
WK[]0080WK[]00@0WKKZ09fjk@000000XLKc0P2Wa^l30:76l`8000000P2d
f?8200000080]^Of00P000000<[gjP3:mnX0b_OZ0000003Go=d0bOkL0=Ol
g@D000000P3To<T01@000000iO^j0000003/nKX000000080k?Vj0`000002
0?;c_0070000003blk`0l_>l0000003^m<<0lNc100h000020>k/a`800000
1`34f^X00`000000PjK[08>Vj`0308>Vj`030000001?KM80CfgB00<00000
101=HlT200000080D63400@0000004Q@]P18D;H0BeBj0P000005059F^080
00000`1JFKL01P000000FUVg05YI]`1KF;D0FUVg061L]P800000101RFk@0
0`000000IUje06IN]@0406IN]@<00000101ZGk<20000000606]V^P1dIkD0
KV>f06]V^P1^HkH000002@3Pgn<01P000000000G00005`000000h=oS0000
00D0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OQl0h=oS0P00000X0>3Oh`80000000@03gOR0000000YNN@0:GWT0`000002
04R9jP030000001GS^X0EhkZ0080EhkZ00<0000006F@i`1UT>L00`1UT>L0
0`000000KYCV07BEi00L0000000509N[i@2B[^T0Uj_U09:^j@0000000`2M
^^d0202M]^X0WK[]09fjk@2M]^X0WK[]0000002Wa^l0XLKc0`0000060;CH
lP`000000P3Jo/l01@000000i?c90000003UnkX000000080k?Vj10000000
1`3blk`000000?;c_03blk`000000>kd``0>00000P3ak<401P3^m<<00000
0>kd``3^k<L000000>K^d`8000001034f^X4000000@0PjK[00D0000004m]
dP1?KM80CfgB0000000404eSb@0300000010D;/000000080D63400@00000
04]D^P1;E;X0B52f0P000004059F^0030000001CE;D0000000<0FUVg00@0
000005]H]@1JFKL0FeRe0P1JFKL2000000<0HU^d00<0H5bf0000001VG[D0
1@1VG[D00`000000JfJj0000000306YO/`080000001dIkD0000006iS]P1[
I[X0KV>f07AW]@0000090>3Oh`030000000001L000000080h=oS00<00000
0>3Oh`3Pgn<00`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn8@3Pgn<00`000000h=oS0>3Oh`0V0>3Oh`@000000P0YNN@0
0`0YQn/00000000000030000000505b=i`1GS^X0EhkZ05N>jP0000001@1U
T>L010000000M9GT06jDiP1dUN@206jDiP040000001kW>H0NYOS07^LiP80
NYOS00<0NicV00000023WN@01@23WN@00`000000SJGU08fUi@0408fUi@04
0000002B[^T0TZkY09N[i@80TZkY00D0Uj_U09:^j@000000WK[]09ffjP02
09fjk@0309ffjP2M^^d0WK[]00<00000202df?82000000<0`NWa00h00000
0=?]iP3:mnX0b_OZ0000003Go=d000000=[nc`3TmM@000000>Clb@000000
iO^j00000080k?Vj0`0000020?;c_0040000003blk`0l_>l00000080l_>l
00L000000>kd``3ak<4000000>k/a`3Zm</0000000@0i^kC100000040>3O
h`D000000`1?KM82000000<0CF?900H00000041@^`10D;/00000051Pa000
000404]D^P030000001BE[P0DUJh0080DUJh00<00000059F^01CE;D00P00
0000101JFKL0000005YI]`1JFKL205]H]@0405YI]`000000H5bf000000<0
HU^d00<0000006IN]@1VG[D0101VG[D00`000000J6Fl06]V^P0200000009
06YO/`000000JfJj06iS]P000000M6Ne06iS]P1[I[X0000000P0h=oS00@0
000000005`0001L000000P3Pgn<00`000000h=oS0>3Oh`030>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhR0>3Oh`030000
003Pgn<0h=oS02H0h=oS00@0000000QXfP00000000000`0YNN@00`000000
>HGY03V5j@03000000<0EhkZ00<0000006F@i`1UT>L00P1UT>L010000000
KYCV07BEi01^U>H207BEi0080000001jUn<0NicV07ZGh`1kW>H0NYOS07^L
iP00000608>Mi0030000002=YND0SJGU00D0SJGU00P0000009:^j@2GZnD0
TZkY09N[i@2B[^T0Uj_U00000080WK[]00<0WKKZ09fjk@2M^^d00P000000
0`2Wa^l0Y/ke000000060;CHlP8000000`31jO4200000080b_OZ0P000000
1@3Go=d000000=[nc`3TmM@000000080i?c900<000000>ci^P0000000P00
00020>og_@030000003blk`000000080l_>l00P000000>kd``3dkK/00000
0>kd``3dkK/000000>[db`80k^c700D000000>K^d`3Vk]<0i^kC0000000<
0>3Oh`8000000`1?KM8200000080CF?900@00000041@^`10D;/0@52k0P00
00001018D;H0BeBj04]D^P1;E;X2000000@0DUJh00@0000005=D]@1CE;D0
DeBe0P0000000`1JFKL0FeRe061L]P0205YI]`030000001PG;H0H5bf0080
000000<0H5bf0000001VG[D01@1VG[D00`000000JfJj06]V^P0206]V^P<0
000000L0M6Ne06]V^P000000JfJj07AW]@1[I[X0000000L0h=oS00@00000
00005`00000000000P3Pgn<00`000000h=oS0>3Oh`030>3Oh`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhS0>3Oh`030000003P
gn<0h=oS02H0h=oS00<0000000QXfP08J=X00P000000100YNN@0000003V5
j@0eO>D203V5j@D000001@1UT>L00`000000M9GT06jDiP0206jDiP0307BE
i0000000NicV0080NYOS00@0NicV07ZGh`1jUn<000001P23WN@00`000000
SJGU08fUi@0408fUi@040000002B[^T0TZkY09N[i@@0TZkY00<0000009fj
k@2M^^d00P0000000`2[aN`0Y/ke0:_5k0020:O6k`8000000P2df?820000
00@0`NWa00D000000=?]iP3:mnX0e_KS000000020=Olg@040000003Jo/l0
i?GD00000080i?c910000000103^m<<000000>og_@0000020?;c_0030000
003blk`000000080l_>l00D000000>kd``3ak<40k_C3000000020>k/a`05
0000003Vk]<0j^?90>K^d`0000003`3Pgn<01P000000CfgB04m]dP000000
>4nn00000080CF?900@00000041@^`10D;/0@52k0P0000001018D;H0BeBj
04]D^P1;E;X2000000<0DUJh00<00000059F^01CE;D00P1CE;D2000000<0
FUVg00<0FeRe0000001PG;H00`1PG;H2000000L0IUje00<0000006]V^P1[
I[X00`1[I[X20000000607AW]@000000KV>f06]V^P1bHk8000001P3Pgn<0
0`000000000G00005`0200000080h=oS00<000000>3Oh`3Pgn<00`3Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn903Pgn<2
000002L0h=oS0P0000000`08J=X00000000000020000000703V5j@0eO>D0
>HGY03V5j@000000EXcX04R9jP0500000080II3W00h0000007BEi01dUN@0
M9GT06jDiP1dUN@0000007ZGh`1kW>H0NYOS07^LiP1jUn<0NicV000000H0
PigT00<0000008fUi@2=YND0102=YND00`000000TZkY09:^j@0209:^j@D0
000000P0YlK_0:K>m@2Wa^l0YlK_0:K>m@2[aN`0Y/ke0:_5k0<000001@31
jO401@0>0000b_OZ0<[gjP3:mnX000000080eocM00H000000=[nc`3TmM@0
i?c90000003To<T3000000030>kd``3_mkd000000080koNm00<000000?;c
_00000000P3blk`010000000k_C30?C]^`0000020>kd``040000003^k<L0
k^c7000000<0i^kC00<000000>3Oh`3Pgn<03`3Pgn<020000000CfgB04m]
dP000000>4nn0000001=HlT000001010D;/020000000BeBj04Q@]P1;E;X0
B52f0000001;D;H000000P1BE[P00`000000DeBe05=D]@0305=D]@070000
001JFKL0FUVg05]H]@1PG;H0FUVg00000004061L]P8000001P1VG[D00`00
0000JfJj06]V^P0306]V^P030000001eMLD000000080000000<0M6Ne06]V
^P0000001P3Pgn<010000000000G0000000000030>3Oh`030000003Pgn<0
h=oS00<0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVORH0h=oS00<000000>3Oh`3Pgn<09P3Pgn<30000000400mghP000000
000000000080>HGY00H0000004R9jP1FS>P0B8WZ05J<j000000205b=i`H0
00000P1dUN@020000000NicV07ZGh`1kW>H0NYOS07^LiP1jUn<000001P23
WN@00`000000SJGU08fUi@0208fUi@L00000102M^^d01`000000YlK_0:O6
k`2[aN`0Y/ke0:_5k02Vc_D00P0000020;CHlP8000000P31jO4200000080
b_OZ0P0000000`3Fm^<0eocM000000020>Cee0090=[nc`00000000000000
003Zm</0i?c90000003^m<<000000080koNm00`000000?;c_03blk`00000
0?;c_0000000l_>l0?C]^`000000k_C30?C]^`0000020>k/a`050000003V
k]<0i^kC0>K^d`0000004`3Pgn<300000080>4nn0P000004041@^`800000
0`1;E;X010000000B52f04]@]P000002059F^0030000001CE;D0DeBe0080
DeBe0P00000205YI]`0305]H]@1JFKL0000000D0H5bf00<0000006IN]@1V
G[D0101VG[D00`000000JfJj06]V^P0406]V^P030000001eMLD0MGG500<0
000000<0M6Ne0000003Pgn<0103Pgn<010000000000G0000000000040>3O
h`030000003Pgn<0h=oS0080h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVORL0h=oS00<000000>3Oh`3Pgn<09`3Pgn<20000
000300QXfP0?Mn80000000@0000000P0B8WZ05J<j018RNX0B8WZ0000001U
T>L0G8gW06F@i`80G8gW00<0000006bFj00000005000000409:^j@030000
002M^^d0WK[]00D0WK[]0P000000202Vc_D0ZlG/000000000000]=Sb0;gH
k@2df?80_MS]0P2df?8@000000050>[db`3To<T000000>kd``0000000P3_
mkd01P000000l_>l0?;c_0000000l_>l000000<0l_>l00L000000?C]^`3^
m<<000000>k/a`3Zm</000000080i^kC00<000000>3Oh`3Pgn<0503Pgn<2
00000080>4nn0P000004041@^`80000000@0B52f04]D^P1;E;X000000P1;
D;H00`000000DUJh0000000505=D]@8000000`1JFKL00`000000H5bf061L
]P03061L]P<000001@1VG[D00`000000JfJj06]V^P0306]V^P060000001e
MLD0MGG507Eea@000000MGG50P0000040>3Oh`D00000103Pgn<00`000000
h=oS0>3Oh`020>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWhX0>3Oh`030000003Pgn<0h=oS02L0h=oS0`0000001008J=X0
000002Uii00YNN@30000000304R9jP1FS>P0000000@0G8gW00P0II3W0000
001^U>H0KYCV06bFj01^U>H0K9KX000000H0NicV00<0000008>Vj`2=YND0
0`25XnL00`2=ZnX0000009:^j@0609:^j@030000002M^^d0WK[]00@0WK[]
00H0X;g]00000000000000000;CHlP2mf>d50;CHlP8000000`36jNh01@00
0000dngV0=?]iP3CkNH0000000<0gOKM00H000000>Cee03TmM@000000>[d
b`0000020>kd``060000003_mkd0koNm00h0003blk`000000P3blk`00`00
0000l_>l0000000:000001P0h=oS00D0000003Q?_P0hCkh0>4nn00000004
041@^`070000000nB[D0000004]D^P18D;H0000004Q@]P0204]@]P800000
1@1CE;D00`000000FUVg0000000205YI]`03061L]P000000H5bf00@0H5bf
00@0000006QU_000000000000`1VG[D00`000000JfJj06]V^P0406]V^P05
0000001eMLD0MGG5081e_@0000000P1eMLD010000000h=oS0>3Oh`3Pgn<5
000000@0h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn:@3Pgn<2000002P0h=oS1@000003
02Uii0D0000000<0II3W05b=i`1UT>L00P1LSNL01P000000K9KX06bFj01^
U>H0K9KX000000H0NicV00D0000008fUi@25XnL0PjK[08fUi@0308FSi`03
0000002B[^T0TZkY00@0TZkY00<0000009fjk@2M^^d00P2M^^d01P2P_Nd0
00000000002[aN`0Y/ke000000D0]=Sb0P0000040<KYkP060000003:mnX0
dngV0=Kfh`000000e_KS0P3Mm]d03P000000i?GD0>Cee0000000j_C;0>Cl
b@000000k_C30000003_mkd0k_C30000003_mkd0l_>l100000002`0>0000
00000?C]^`3dkK/000000?C]^`3di[X000000?CV^P3dkK/0000001X0h=oS
00<0000003Q?_P0hCkh00P000003041@^`0600000018D;H0?TZe0000001;
E;X00000101;D;H2000000@0DeBe00@0000005YI]`1JFKL000000P1JFKL0
0`000000H5bf061L]P03061L]P040000001XIK`0J6Fl06QU_080000000<0
IUje0000001[I[X01@1[I[X00`000000MGG507Eea@0207Eea@030000001e
MLD000000080h=oS1P0000040>3Oh`030000003Pgn<0h=oS0080h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOR/0h=oS00<0
00000>3Oh`3Pgn<09P3Pgn<20000000300QXfP000000000000<0:GWT00<0
000004R9jP0eO>D00`00000405b=i`030000001/U^P0KYCV0080KYCV00<0
000007^LiP1kW>H0101kW>H010000000PjK[08fUi@23Y^/308FSi`030000
002B[^T0TZkY00D0TZkY00<0000009fjk@2M^^d00P0000001@2Wa^l0ZlG/
0:_5k02Wa^l0ZlG/0080000000<0]=Sb0000000000001036jNh2000000<0
dngV00D000000=gfg@3Mm]d0gOKM000000020>Cee0090000003To<T0j_C;
0000003^m<<000000>og_@3^m<<0koNm00D000000`3dkK/010000000m>fk
0?C]^`0000020?C]^`040000003dkK/0m>fk000001/0h=oS00<0000003Q?
_P0hCkh00P000003041@^`030000000nB[D000000080BeBj00<0000004]@
]P1;D;H00P1;D;H00`000000DeBe05=D]@0305=D]@060000001JFKL0FUVg
0000001JFKL000001@1PG;H00`000000J6Fl06QU_00306QU_0<000001@1[
I[X00`000000MGG507Eea@0307Eea@040000001eMLD000000>3Oh`D00000
1@3Pgn<00`000000h=oS0>3Oh`020>3Oh`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh/0>3Oh`030000003Pgn<0h=oS02H0h=oS
0P0000001P00ELl026SJ000000000000:GWT00000080B8WZ00<0=GcU04R9
jP0000001@00000506bFj0030000001kW>H0NicV00@0NicV00<0000008FS
i`25XnL00`25XnL00`23Y^/0000009:^j@0309:^j@D0000000L0ZlG/0:K>
m@2[aN`0Y/ke0:_5k02Vc_D0ZlG/0080YlK_00<000000<KYkP36jNh00`36
jNh00`000000b_OZ0=?]iP020=?]iP050000003Fm^<0gOKM0=gfg@000000
0P3TmM@010000000j_C;0>[db`0000020>kd``030000003^m<<0000000<0
00000P3dkK/010000000m>fk0?C]^`0000020?C]^`070000003di[X0m>fk
0000003ak<40m>Jj0000000M0>3Oh`050000000hCkh0000003E6]P000000
0P10D;/01P000000?TZe04Q@]P000000BeBj000000@0Be2f0P00000405=D
]@040000001JFKL0FUVg05YI]`8000001P1PG;H00`000000J6Fl06QU_004
06QU_08000001@1[I[X00`000000MGG507Eea@0207Eea@030000001eMLD0
000000H000001@3Pgn<00`000000h=oS0>3Oh`020>3Oh`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh]0>3Oh`030000003Pgn<0
h=oS02H0h=oS0`0000000`00ELl000000000000200000080B8WZ00H0=GcU
04R9jP000000EhkZ05b=i`1FS>P400000080KYCV00<0000007^LiP1kW>H0
101kW>H00`000000PjK[08FSi`0208FSi`L000000`2M^^d00`2M]^X00000
0:O6k`020:_5k0040:O6k`2[aN`0YlK_0:_5k080000000<0^=G_00000000
00000P36jNh00`000000dngV0=Kfh`020=?]iP050000003Mm]d0gOKM0=gf
g@0000000`3TmM@00`000000j_C;0>[db`030000000300h0000000000000
0080m>fk00<000000?C]^`0000000P3dkK/01@000000m>fk0?C]^`3dkK/0
00000080m>fk00@000000?CV^P3ak<4000007@3Pgn<01P000000>4nn03Q?
_P000000=DJf00000080@52k00<0000003i:]@0nB[D00P00000504]@]P80
000000@0DUJh05=D]@1CE;D00000101JFKL2000000D0H5bf00<0000006QU
_01XIK`0101XIK`010000000M7[:00000000000306]V^P030000001eMLD0
MGG500<0MGG500<0000007Eea@0000001@0000060>3Oh`070000003Pgn<0
h=oS0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
;P3Pgn<00`000000h=oS0>3Oh`0V0>3Oh`@000000P0IKml300000080B8WZ
00<0000005b=i`1LSNL00P1LSNL00`1GS^X0000006bFj00>000000@0SJ_Z
00D0000009fjk@2M^^d0WK[]09ffjP0309fjk@050000002Wa^l0YlK_0:_5
k02Wa^l00P0000050;SEk`<000000`3CkNH01@000000gOKM0=gfg@3Mm]d0
000000<0i?GD00<000000>[db`0000000`0000030>kd``030000003blk`0
00000080m>fk00@000000?C]^`3dkK/000000P3dkK/01`000000m>Jj0?C]
^`000000m>Jj0?C]^`0000007`3Pgn<00`000000>4nn0000000203E6]P06
00000010D;/0000004Q@]P0nB[D0B52f0P00000404]@]P030000001BE[P0
00000080DeBe00<0000005YI]`1JFKL00`1JFKL00`000000H5bf061L]P03
061L]P030000001XIK`0J6Fl00D0J6Fl00<0000007Yha@1dN/X00`000000
0`1[I[X0000007Eea@0407Eea@L000001P3Pgn<01`000000h=oS0>3Oh`3P
gn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVORl0h=oS
0P00000W0>3Oh`@000000`0IKml30000000304R9jP000000EhkZ00@0G8gW
00<0000006bFj01/U^P00P1/U^P010000000NicV07ZTk@23WN@207ZTk@03
08>Mi0000000S:k/00H0SJ_Z00<0000009fjk@2M]^X00P2M^^d01@2M]^X0
WK[]09ffjP000000YlK_008000000`2heNl00`2mf>d0^=G_0;SEk`020000
00030<KOj`36jNh0000000d000000P3Zm</02@000000k_C30>kd``000000
m>fk0>kd``0>0000l_>l000000020?C]^`0:0000003dkK/0m>fk0?C]^`00
0000m>fk0000003ak<40m>Jj00000240h=oS0P00000303E6]P800000100n
B[D00`000000Be2f04]@]P0204]@]P070000001JFKL0DUJh0000001BE[P0
DeBe0000000405YI]`<00000101PG;H00`000000J6Fl06QU_00406QU_003
0000001dN/X0NWS500<0M7[:3@0000070>3Oh`070000003Pgn<0h=oS0>3O
h`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn<@3Pgn<0
0`000000h=oS0>3Oh`0U0>3Oh`0400000000=kL00000000000<06FoO00<0
000003Eli@0000000P00000305N>jP0305b=i`000000K9KX00@0K9KX00P0
000007^LiP1jY>d0PigT07^LiP1jY>d0PigT000000H0SJ_Z00@0000009fj
k@2M^^d0WKKZ0P2M^^d0102M]^X0Xkk/0000000000050;SEk`050;CHlP00
000000000<KOj`36jNh00`36gn/01@000000dngV0=?]iP3CkNH0000000<0
g>kN00d000000>Cee03Vk]<000000>[db`3Vk]<000000>kd``3^k<L00000
0>kd``3ak<4000000080m>fk00@000000?C]^`3dkK/000000P3dkK/01`00
0000m>fk0?CV^P000000m>Jj0?C]^`0000008P3Pgn<2000000<0=DJf0P00
00000`18D;H0?TZe04Q@]P02000000@0Be2f00H00000059F^01BE[P00000
05=D]@00000505YI]`030000001XIK`0000000<0H5bf00<0000006QU_01X
IK`0101XIK`020000000M7[:07Yha@1dN/X0NWS507AjbP1jN<D000000P2?
Wmh01P27WN80SioN08NMhP2?Wmh0000008nOgP<000001`3Pgn<01`000000
h=oS0>3Oh`3Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOS80h=oS00<000000>3Oh`3Pgn<09@3Pgn<50000000701U_g`000000
=GcU03Eli@18RNX0000000h0000200000080EhkZ00<0000006bFj01/U^P0
0`1/U^P010000000NicV07ZTk@23WN@207ZTk@030000002=ZnX0SJ_Z00D0
SJ_Z00<0000009fjk@2M^^d0100000020:O6k`8000000P2heNl2000000H0
a]o[00D000000=?]iP3@i>H0dngV000000030=c^gP050000003Vk]<0i^kC
0>Cee00000000P3Zm</02@0>0000j_C;0>kd``0>0000m>fk0>kd``000000
m>fk000000020?C]^`0:00h0003dkK/0m>fk0?C]^`000000m>fk0000003d
kK/0m>Jj000002<0h=oS0P00000403E6]P030000000nB[D0?TZe0080?TZe
0P0000001018D;H0Be2f04]@]P000003059F^08000001@1JFKL00`000000
J6Fl06QU_00200000003061L]P000000J6Fl00D0J6Fl00<0000007AjbP1d
N/X00P1dN/X0101jN<D0M7[:07AjbP00000608nOgP030000002?Wmh00000
00P0h=oS00L000000>3Oh`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWhc0>3Oh`030000003Pgn<0h=oS02D0h=oS1`00
000403Eli@030000001GS^X0000000H000000P1/U^P020000000NicV07ZT
k@23WN@0NZC]08>Mi0000000TZkY0P2=ZnX00`2E[>H00000000000030000
00L0YlK_00<0ZlG/0000000000001P36gn/2000000<0dngV00T000000>K^
d`3CkNH0i^kC0000003TmM@0i^kC0>Cee00>00000P3Zm</01`000000k_C3
0>kd``000000m>fk0>kd``0000000P3dkK/00`000000m>fk000000030?C]
^`040000003dkK/0m>Jj00000080m>fk00<000000>3Oh`3Pgn<08P3Pgn<2
000000<0=DJf0P0000001P18D;H0?TZe04Q@]P000000Be2f00000080Be2f
00<00000059F^01BE[P00P1BE[P2000000@0FUVg00<0000006QU_01MHKh0
0P1XIK`3000000H0J6Fl00P0000007Yha@1dN/X0NWS507AjbP1jN<D0M7[:
000000H0SioN0P0000090>3Oh`070000003Pgn<0h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn=03Pgn<2000002L0h=oS
0P00000200QXfP<000000`0eO>D01P000000EhkZ05J<j01GS^X0EXcX0000
0080KY[[3@0000001P2M]^X0U[G]09Jek@2M]^X000000:_5k0D0YlK_00D0
ZlG/000000000000]/o]000000040<KOj`0>0000003CkNH0dngV0=3TiP3C
kNH000000>K^d`3CkNH0i^kC0000003TmM@0i^kC0>Cee00000020>[db`05
0000003^k<L0k_C30>kd``0000000P3ak<400`000000m>fk000000020?C]
^`040000003dkK/0m>fk0?C]^`H000009P3Pgn<01`000000=DJf03E6]P0e
A[H0000003i:]@0000000P0nB[D01`000000Be2f04Q@]P000000B52f04]@
]P000000101BE[P00`000000FUVg05YI]`0305YI]`040000001XIK`0GF6n
06QU_080I6Bl0P00000506QU_0030000001dN/X0NWS500<0M7[:00<0NWS5
07AjbP0000000`2?Wmh3000000030>3Oh`000000h=oS00L0h=oS00L00000
0>3Oh`3Pgn<0h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWhf0>3Oh`030000003Pgn<0h=oS02D0h=oS0P00000300QXfP<00000
00L0=GcU0000001GS^X0EhkZ05J<j01GS^X0000000H0KY[[00<0000008>V
j`23Y^/00`23Y^/00`000000U[G]09Jek@0509Jek@030000002[aN`0YlK_
0080ZlG/0P0000040;K?k@80000000`0a]o[0000003@i>H0dngV0=3TiP3C
kNH000000=?]iP3Vk]<0dngV0=Kfh`0000020>Cee00;0000003Zm</0k^c7
0>[db`000000k_C30>k/a`000000lNc10>kd``0000000P3dkK/900000080
m^Bf00<000000>3Oh`3Pgn<09P3Pgn<010000000=DJf03E6]P0eA[H20000
000904Q@]P0nB[D0000004Q@]P1;D;H0B52f0000001;D;H0000000<0DUJh
00<0DeBe000000000000101JFKL020000000J6Fl06QU_01MHKh0IFo806AT
_0000000M7[:0P00000306]V^P040000001dN/X0NWS507AjbP80NWS50P1d
N/X01P000000SioN000000000000]?Cc00000080h=oS00<000000>3Oh`3P
gn<01`3Pgn<01P000000h=oS0>3Oh`1VIWh0Z:Vk0?_lo@40IVIn0000101V
IWh0nocm0:RY^`1VIWhg0>3Oh`030000003Pgn<0h=oS02D0h=oS0`000002
00QXfP030000000eO>D00000008000000P1GS^X205J<j0030000001^V^/0
KY[[00@0KY[[00<0000008>Vj`23Y^/00`23Y^/00`000000U[G]09Jek@05
09Jek@040000002[aN`00000000000P0]/o]0P0000030=?]iP060000003F
m^<0i^kC0=?]iP3Vk]<000000P3Vk]<01@3TmM@000000>[db`3Zm</00000
0080k_C300@000000?C]^`3^m<<0m>fk1@000000103di[X0m^Bf0?CV^P00
00020?KT]P040000003fi;H0m^Bf000002P0h=oS00/0000003E6]P0eA[H0
=DJf0000000nB[D0000003i:]@18D;H0000004]@]P0204Q@]P800000101B
E[P0101CE;D0000000000000000305YI]`030000001XIK`0J6Fl0080I6Bl
00@0IFo80000001dN/X0M7[:0`0000000`1[I[X0000007AjbP0307AjbP@0
00000P2dm?<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS00H0
h=oS00H000000>3Oh`3Pgn<0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn>03Pgn<00`000000h=oS0>3Oh`0U0>3Oh`@0000000@026SJ
0000000YNN@0=GcU0`00000305N>jP030000001^V^/0KY[[00<0KY[[00<0
000008>Vj`23Y^/00`23Y^/00`000000U[G]09Jek@0509Jek@800000202f
cnd200000080a=[Z10000000103Vk]<0e_KS0>K^d`0000030>Cee0090000
003Vk]<0j_C;0>[db`000000k^c70>kd``000000m>fk00@000000P3di[X0
1`000000m>Jj0?CV^P3di[X000000?CV^P0000000P3fi;H00`000000h=oS
0>3Oh`0X0>3Oh`040000000eA[H0=DJf00000080?TZe00@0000003i:]@00
0000Be2f0`18D;H2000000<0DUJh00D0DeBe0000001MHKh0GF6n00000002
05YI]`030000001XIK`0GF6n00<0J6Fl00<0000007AjbP1dN/X00`1dN/X6
0000000409>VhP2E[>H0TjKR09F/iP8000001P3Pgn<00`000000h=oS0>3O
h`050>3Oh`060000003Pgn<0h=oS06IVOP2XZK/0nocm0@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOST0h=oS0P00000V0>3Oh`80000000L005G?00000000
0000000003Eli@0YNN@0=GcU00D000001P1^V^/00`000000PjK[08>Vj`03
08>Vj`030000002F]Nd0U[G]00@0000000<0Xkk/0:6okP0000001@2fcnd2
000000@0a=[Z0P0000020=3TiQ4000000P3ak<4010000000lNc10000003f
i;H20?CV^P040000003fi;H0m^Bf00000080m^Bf00<000000>3Oh`3Pgn<0
:@3Pgn<00`000000=DJf0000000303i:]@80000000<0Be2f04Q@]P18D;H0
0P18D;H00`000000DUJh059F^002059F^0070000001MHKh0GF6n05eQ_P00
0000FUVg0000000206QU_00505eQ_P1XIK`0GF6n06AT_00000001P1dN/X0
10000000TjKR09>VhP2E[>H309>VhP8000001`3Pgn<00`000000h=oS0>3O
h`050>3Oh`060000003Pgn<0h=oS06IVOP2XZK/0nocm0@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOS/0h=oS00<000000>3Oh`3Pgn<0903Pgn<200000004
00QXfP00ELl00000000000<0=GcU00<0000005N>jP1GS^X0400000001`2S
_^`0XKo^0:>nk02Q_nh0Xkk/0:6okP2S_^`00P0000000`2fcnd000000000
00050<CJjP070000003@i>H0e=cN0=3TiP3Dg=h0d>CV000000030=[VgP08
00005`3Ti=<0i>CC0>K^d`000000i^kC0>[Sb@0000030>k/a`030000003a
k<4000000080m>Jj00L000000?CV^P3di[X0m>Jj0000003fi;H000000080
m^Bf00<000000>3Oh`3Pgn<0:P3Pgn<010000000=DJf03E6]P00000203i:
]@80000000D0Be2f04Q@]P18D;H0B52f04]@]P02000000<0DUJh00D00000
05eQ_P1MHKh0GF6n06AT_00300000080I6Bl00@0IUje06E_b01TI;`00000
1P1dN/X00`000000UJcV09>VhP0209>VhP0409F/iP000000_OS]000000P0
h=oS00<000000>3Oh`3Pgn<0103Pgn<01P000000h=oS0>3Oh`1VIWh0Z:Vk
0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWhl0>3Oh`030000003Pgn<0
h=oS02@0h=oS0P0000000`00ELl026SJ001Ec`020000000303Eli@000000
EhkZ00<0EhkZ00@0000007ROjP1^V^/0KY[[0`1hWnX00`000000S:k/08b^
k00308b^k0070000002Q_nh0Xkk/0:6okP2S_^`0XKo^0:>nk0030:6okP03
00000034f^X0a=[Z00@0a=[Z00<000000=3TiP3@i>H00`3@i>H03@000000
f^KN0=[VgP3Ji]h000000>K^d`3Ti=<0i^kC0000003Vk]<0j^?90>K^d`00
00000P3^k<L01`000000lNc10?7/`@000000lNc10000003fi;H00P3di[X0
10000000m^Bf0?CV^P0000020?KT]P030000003Pgn<0h=oS02/0h=oS00<0
000003E6]P0000000`0nB[D20000000504]@]P18D;H0B52f04Q@]P1;D;H0
0P000000101CE;D0DUJh059F^000000505eQ_P80000000<0IFo806AT_01T
I;`00P1TI;`00`000000M7[:07AjbP0407AjbP070000002CY^80UJcV09>V
hP000000_OS]0000000:0>3Oh`030000003Pgn<0h=oS00<0h=oS00H00000
0>3Oh`3Pgn<0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
?@3Pgn<00`000000h=oS0>3Oh`0T0>3Oh`<000000P00ELl4000000@0EhkZ
00P0000007ROjP1hWnX0KY[[06fWm01^V^/0N9oZ000000D0S:k/0P000000
0`2S_^`0XKo^0:>nk0020:6okP80000000<0]/o]0000000000000P34f^X2
00000080d>CV00@0e=cN0=3TiP00000000000`3Ji]h02@0001L0i>CC0>CT
d`3Ti=<0i^kC0000003ZhlT0i^kC000000020>k/a`0400h0003ZhlT0lNc1
00000080m>Jj00@000000?CV^P3di[X000000P3fi;H010000000m^Bf0?KT
]P00000_0>3Oh`800000100nB[D00`000000B52f04Q@]P0204Q@]P0704]@
]P000000EUjo0000001BE[P0FUVg0000000505eQ_P080000001dN/X00000
0000001TI;`0IFo806AT_000000607AjbP060000002CY^8000000000002m
n>d00000303Pgn<00`000000h=oS0>3Oh`020>3Oh`060000003Pgn<0h=oS
06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOSh0h=oS0P00
000U0>3Oh`D000000P0YNN@0100>0000000000000000000205N>jP030000
001hWnX0N9oZ0080N9oZ00<0KY[[0000002<[^`01@2<[^`0102=/^l00000
0:O0j`2Q_nh2000000050;K?k@2[aN`0ZlG/0;K?k@2[aN`00P0000020=3T
iP040=CLgP3@i>H0d>CV000000@0f^KN00T000000>CTd`3Ti=<0i^kC0>CT
d`000000i^kC0>[Sb@0000000`3^k<L01`000000lNc10?7/`@000000lNc1
0000003fi;H00P3di[X010000000m>Jj0?KT]P0000020?KT]P030000003P
gn<0h=oS02h0h=oS00<0000003i:]@0nB[D00P0nB[D2000000<0B52f00T0
Be2f0000001FG[l0EUjo0000001CE;D0000005eQ_P1TI;`00P1MHKh00`1T
I;`0GF6n0000000207AjbP<0000000<0IFo80000001dN/X00P1dN/X50000
0080_OS]00<000000>3Oh`3Pgn<02P3Pgn<00`000000h=oS0>3Oh`030>3O
h`050000003Pgn<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOT00h=oS00<000000>3Oh`3Pgn<0903Pgn<01000000005G?00000000
000302Uii0030000001GS^X0000000H000000P1hWnX01@000000S:k/08b^
k02<[^`0U[G]00D0000000H0ZlG/0;K?k@2[aN`0ZlG/0;K?k@2[aN`20000
00030;S:i`00000000000080d>CV00<000000=[VgP3Ji]h00P3Ji]h02P3@
i>H000000>K^d`3Vk]<0i>CC0000003Vk]<0j^?90>K^d`0000020>k/a`07
0000003ak<40lNc10000003di[X0lNc1000000020?CV^P040000003fi;H0
m^Bf00000080m^Bf00<000000>3Oh`3Pgn<0;`3Pgn<2000000@0?TZe0P00
00001`18D;H0Be2f04Q@]P000000EUjo05YI]`1FG[l00P00000605eQ_P03
0000001dN/X0M7[:00<0M7[:1@00000309F/iP80Uj_U0P00000>0>3Oh`03
0000003Pgn<0h=oS0080h=oS00D000000>3Oh`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn@@3Pgn<00`000000h=oS0>3Oh`0S0>3O
h`8000000P00ELl01P000000:GWT02Uii00YNN@0000005ZDk@<0EhkZ00<0
000007ZTk@1jY>d01`00000409Jek@0<0000002fcnd0ZlG/0;K?k@2[aN`0
]/o]0000002mf>d0^<[W0<CJjP2hb^L0_MS]0P0000050=[VgP090000003J
i]h0i>CC0>K^d`000000i^kC0>[Sb@3Vk]<0000000<0k^c700d000000?7/
`@3ak<4000000?CV^P000000m>Jj0?KT]P3di[X000000?KT]P3di[X00000
0080m^Bf00<000000>3Oh`3Pgn<0<03Pgn<00`000000?TZe03i:]@0203i:
]@040000001;E;X0000004]D^P80Be2f00@0000005IN_`1FG[l0EUjo0P00
000505eQ_P030000001dN/X0M7[:00D0M7[:00<0000009F/iP2GZnD0102G
ZnD200000100h=oS00T000000>3Oh`3Pgn<0h=oS0000003Pgn<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOT80h=oS00<000000>3O
h`3Pgn<08`3Pgn<300000005001Ec`000000000002Uii00000000`1GS^X0
0`1JU>d0EhkZ0000000507ZTk@030000002F]Nd0U[G]00D0U[G]0P000000
202fcnd000000000002hb^L0]/o]0<SBhP2hb^L0_MS]0P0000001P39en@0
00000000003Ji]h0d>CV000000<0i^kC00D0i>CC0000003Vk]<0j^?90000
00030>k/a`0=0000003ZhlT0lNc10000003di[X0lNc10000003fi;H0m>Jj
0000003di[X0m^Bf000000020?KT]P030000003Pgn<0h=oS0380h=oS00D0
000003i:]@0nB[D0?TZe0000000204]D^P0400000018D;H0Be2f000000@0
EUjo0P00000505eQ_P030000001dN/X0M7[:00@0M7[:00<0000009F/iP2G
ZnD00`2GZnD200000180h=oS00P000000>3Oh`3Pgn<000000>3Oh`1VIWh0
Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWi30>3Oh`800000903P
gn<300000003001Ec`000000000000800000101GS^X00`000000NZC]07ZT
k@0407ZTk@030000002F]Nd0U[G]00D0U[G]0P0000001`2fcnd0_MS]0<7<
hP2mf>d0^<[W0;gHk@0000001@39en@3000000<0i>CC00D000000>K^d`3Z
hlT0i^kC000000020>k/a`070000003ak<40lNc10?7/`@000000m>Jj0000
00030?CV^P030000003fi;H0000000@00000=@3Pgn<02P000000?TZe03i:
]@0nB[D0000004]D^P1BE[P0000004]D^P00000205IN_`0405YI]`1FG[l0
000006]dbP8000000`1MHKh00`000000M7[:07AjbP0507AjbP040000002E
[>H0UJcV09F/iP8000004`3Pgn<020000000h=oS0>3Oh`000000h=oS06IV
OP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTD0h=oS00<00000
0>3Oh`3Pgn<08P3Pgn<01000000005G?00000000000202Uii0@0000000<0
FYC]05b=i`0000001P1jY>d00`000000U[G]09Jek@04000000080:O0j`2S
_^`000000;gHk@2hb^L0_MS]0;K?k@0000060<WGi0030000003Dg=h0e=cN
00P000000P3^k<L01@000000lNc10?7/`@000000lNc100L0000000D0l]nk
0000003dg[L0m=jg0000000f0>3Oh`040000000nB[D0?TZe000000<0BeBj
0P00000505IN_`030000001dN/X0JgC:00<0000000<0GF6n0000001dN/X0
1@1dN/X01P000000UJcV000000000000b_OZ000001@0h=oS00L000000>3O
h`000000h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWi60>3Oh`030000003Pgn<0h=oS0280h=oS00@00000001Ec`0000000000
0`0YNN@00`000000FYC]0000000;000000090:>nk02W`>/0XKo^0:>nk02W
`>/0Xkk/0:O0j`000000]/o]008000001P39en@00`000000e=cN0=CLgP02
0=CLgP070000003LgmP0g=oH0=cOf0000000i>CC0>CJc008000000030?;O
^`3ZhlT0000000<0l]nk00@000000?CN]`3dg[L00000>03Pgn<01`000000
?TZe03i:]@000000BeBj05IN_`1;E;X00P00000205IN_`0805YI]`1FG[l0
000006]dbP1dN/X0JgC:07AjbP1[M<X:00000080b_OZ00<000000>3Oh`3P
gn<0503Pgn<01P000000h=oS0000001VIWh0Z:Vk0?_lo@40IVIn0000101V
IWh0nocm0:RY^`1VIWi70>3Oh`030000003Pgn<0h=oS0280h=oS00<00000
001Ec`00ELl00P00000202Uii0030000001JU>d0FYC]0080FYC]00<00000
08B]k`24[Nl01024[Nl02P000000Xkk/0:>nk02W`>/0Xkk/0:O0j`2S_^`0
Yl3[0:>nk00000060<WGi0800000103Dg=h01@000000g=oH0=cOf03LgmP0
000000<0i>CC00P000000>[Sb@3ZhlT0j^?90000003bgk/0j^?900000080
l]nk00D000000?;O^`3bgk/0l]nk000000020?CN]`030000003Pgn<0h=oS
03L0h=oS00<0000003i:]@000000101;E;X00`000000EUjo05IN_`0305IN
_`030000001[M<X0M7[:00@0JgC:00D0000009>VhP2E[>H0TjKR09F/iP03
09>VhP800000603Pgn<20000000306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWi80>3Oh`8000008`3Pgn<200000003001Ec`000000
000000<00000101JU>d00`000000Q:g_08B]k`0408B]k`040000002S_^`0
Yl3[0:O0j`80Xkk/0P0000000`2hb^L000000<WGi0030<WGi0030000003D
g=h0e=cN00<0e=cN00L000000=cOf03LgmP0g=oH0000003Ti=<0i=[<0080
i>CC00X000000>[Sb@3ZhlT0j^?90000003ZhlT000000?;O^`3ZhlT00000
0`3bgk/010000000m=jg0?CN]`00000k0>3Oh`80000000@0BeBj059F^01F
G[l0BeBj0`00000305IN_`040000001[M<X0JgC:07AjbP<0JgC:00<00000
09N[i@2CY^800`2CY^800`2E[>H000000000000I0>3Oh`80000000<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTX0h=oS00<00000
0>3Oh`3Pgn<08@3Pgn<3000000<0:GWT0`00000205ZDk@0300000024[Nl0
Q:g_00D0Q:g_00<000000:>nk02S_^`00P000000102hb^L0ZlG/0:_5k02h
b^L2000000030<WGi0000000e=cN00@0e=cN00H000000=cOf03LgmP0g=oH
0000003Tf/`30>CTd`050000003ZhlT0j^?90>[Sb@0000000P3ZhlT01000
0000l]nk0?;O^`0000030?;O^`040000003dg[L0m=jg000003`0h=oS0P00
000404]D^P040000001UKlP0000000000080EUjo00/0000007AjbP1[M<X0
M7[:06]dbP1dN/X0JgC:0000002E[>H0TjKR09F/iP02000000030<KYkP00
0000h=oS01P0h=oS0P0000000`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVInB`3Pgn<00`000000h=oS0>3Oh`0Q0>3Oh`<00000100Y
NN@5000000@0Q:g_1@0000002@2[aN`0]/o]0;S:i`2[aN`0^<[W0:_5k02f
cnd0^<[W000000050=CLgP030000003LgmP0g=oH0080g=oH00D000000>CT
d`3Ti=<0i=[<000000020>[Sb@080>CJc00>0000j^?90?;O^`000000j^?9
0?;O^`0000030?;O^`040000003dg[L0m=jg000003h0h=oS00H0000004]D
^P1BE[P0BeBj05IN_`00000306E_b0<000001P1[M<X01`000000TjKR0000
00000000a^W^0<[gjP0000005P3Pgn<400000080h=oS00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOT`0h=oS00<000000>3Oh`3P
gn<08@3Pgn<01000000005G?00000000000302Uii0030000001VV^h0IY[^
00D000000P2=/^l02@2F]Nd0SK;_0000002hb^L0ZlG/0;S:i`2[aN`0^<[W
0;K?k@02000000030;S:i`00000000000080e=cN00<000000=cOf03LgmP0
0P3LgmP00`000000i>CC0>CJc0020>CTd`080000003ZhlT0j^?90000003Z
hlT0j][30>[Sb@0000020?;O^`050000003bgk/0l]nk0?;O^`0000000P3d
g[L00`000000h=oS0>3Oh`0m0>3Oh`030000001;E;X0BeBj0080BeBj00<0
000006E_b01UKlP00P1UKlP9000000040<[gjP36jNh0b_OZ000001<0h=oS
100000060>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWi=0>3Oh`8000008P3Pgn<50000000302Uii0000000IY[^00<0IY[^
00<0000008fbk`2=/^l00P2F]Nd00`2=/^l0U[G]08fbk`02000000070;S:
i`2[aN`0000000000031c>80^<[W0<7<hP020;S:i`<000000`3LgmP00`00
0000i>CC0>CTd`020>CTd`0;0000003ZhlT0j^?90>[Sb@000000j^?90?7/
`@000000l]nk0>[Sb@0000000`3bgk/010000000m=jg0?CN]`0000110>3O
h`80000000<0BeBj059F^00000001@1UKlP010000000SioN08nOgP27WN82
08nOgP0608NMhP2?Wmh0000000000036jNh000003`3Pgn<4000000X0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTl0h=oS
00<000000>3Oh`3Pgn<0803Pgn<30000000402Uii00000000000000000@0
IY[^00<0000009Jek@2=/^l00P2=/^l00`2F]Nd0SK;_09Jek@0300000006
0;K?k@31c>80]/o]0<7<hP2mf>d0^<[W0P0000020<SBhP<000000P3Ti=<0
103Tf/`0i>CC0000003Tf/`20>[Sb@0500h0003Zf/<0j^?90>[Sb@000000
0P3bgk/01@000000l]nk0?;O^`3bgk/000000080m=jg00<000000>3Oh`3P
gn<0@@3Pgn<010000000BeBj04]D^P00000506E_b0030000002?Wmh0SioN
00H0SioN00<000000>3Oh`3Pgn<02P3Pgn<4000000h0h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU00h=oS00<000000>3O
h`3Pgn<0803Pgn<300000080:GWT1000000206JJkP030000002F]Nd0U[G]
00@000000P2M^^d01`000000^<[W0<7<hP31c>80^<[W0<7<hP0000001@38
d^8010000000d]KK0000000000020>CTd`0;0000003ZhlT0j^?90000003Z
hlT0lNc10>[J``000000l]nk0>[Sb@0000000`3bgk/010000000m=jg0?CN
]`0000150>3Oh`030000001;E;X0000000D0IFo800@0000008nOgP2?Wmh0
QigR0`2?Wmh2000000T0h=oS1000000B0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWiA0>3Oh`030000003Pgn<0h=oS0200
h=oS00@00000001Ec`00000000000P0YNN@00`000000KJOd000000040000
00L0WK[]0P0000000`2hb^L00000000000050<SBhP030000003Be]/0d]KK
0080d]KK0`0000020>[Sb@050000003ZhlT0j^?90>[Sb@0000000P3bgk/0
1@000000l]nk0?;O^`3bgk/000000080m=jg00<000000>3Oh`3Pgn<0A03P
gn<3000000D0IFo800@0000008nOgP2?Wmh0SioN0P0000080>3Oh`<00000
5P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
DP3Pgn<200000240h=oS00<00000000g]`0000000P000000200YNN@00000
06JPl@1hWnX0IZ3a06jJj`000000XKo^1P2M^^d00`2S_^`0000000000005
0<SBhP8000001@3Be]/00`000000g=oH0=[Ed`07000000030?;O^`000000
l]nk0080l]nk00@000000?CN]`3dg[L00000B@3Pgn<400000080IFo800@0
000008nOgP00000000001P3Pgn<4000001T0h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU@0h=oS00<000000>3Oh`3Pgn<0
7`3Pgn<01000000003Ng0000000eO>D30000000506fWm01VX?40KJOd06jJ
j`000000102M^^d01P2S_^`000000000002W`>/0ZlG/000000<0b=;R00<0
00000=;Ff`3Be]/0103Be]/01@000000f]GC0=[Ed`3LgmP0000000<0i=[<
00<000000>CJc03Tf/`02@00001=0>3Oh`@00000103Pgn<4000001d0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOUD0h=oS
00<000000>3Oh`3Pgn<07`3Pgn<20000000302Uii00eO>D0:GWT00@00000
00<0IZ3a06fWm00000000P2M^^d2000000080:_5k02W`>/0ZlG/0:O0j`2[
aN`000000<SBhP0000050=;Ff`80000000T0f]GC0=cOf03JeM<000000=[E
d`3Tf/`0f]GC0000003Zf/<00P3Tf/`01@000000j][30>[J``3Zf/<00000
0080k]bn00<000000>3Oh`3Pgn<0D03Pgn<400000240h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOUH0h=oS00<000000>3O
h`3Pgn<07`3Pgn<20000000602Uii00eO>D0=GcU02Uii0000000Nj_a1@00
00030:O0j`060:_5k02W`>/0ZlG/0:O0j`2Wa^l000001@3Be]/01`000000
f]GC0=[Ed`3LgmP0f]GC0=cOf00000000`3Tf/`01@000000i=[<0>[J``3T
f/`0000000<0j][300@000000>kL_P3^g;h00000CP3Pgn<4000002D0h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOUL0h=oS
0P00000P0>3Oh`<0000000@0:GWT03Eli@000000Nj_a101gXnh00`000000
YlK_0:_5k0030:O0j`040:O6k`00000000000;S:i`8000000P3Be]/02`00
0000f]GC0=cOf03JeM<0g=oH0=[Ed`000000i=[<0=[Ed`3Tf/`0000000<0
i=[<00D000000>[J``3Zf/<0j][3000000020>kL_P030000003Pgn<0h=oS
04T0h=oS1000000Y0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWiI0>3Oh`030000003Pgn<0h=oS01h0h=oS1P00000507^[
l@8000000P2Wa^l2000000030;S:i`2[aN`0^<[W0080^<[W0P0000001`3L
gmP0f]GC0=cOf03JeM<0g=oH0000003JeM<00P3Tf/`01P000000j][30>CJ
c03Zf/<0i=[<00000080j][300D000000>kL_P3^g;h0k]bn000000180>3O
h`<00000;@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVInFP3Pgn<00`000000h=oS0>3Oh`0N0>3Oh`80000000<0>HGY03El
i@0000002@0000060;S:i`80000000H0`LcR0000003JeM<0g=oH0=[Ed`00
00020>CJc0030=[Ed`000000i=[<00<0i=[<00D000000>[J``3Zf/<0j][3
000000020>kL_P030000003Pgn<0h=oS04<0h=oS1000000`0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWiK0>3Oh`030000
003Pgn<0h=oS01h0h=oS0P000000100iQNT0=GcU03V5j@00000508B]k`03
08Rfm0000000^<[W00@0^<[W00<000000<7<hP31c>800P31c>8200000003
0=[Ed`000000f]GC0080i=[<00D000000>CJc03Zf/<0i=[<000000030>[J
``050000003^g;h0k]bn0>kL_P000000@@3Pgn<4000003@0h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOU`0h=oS0P00000O
0>3Oh`<000000P0iQNT00`000000R;Kd08B]k`0408B]k`80000000<0^<[W
0000000000001`31c>8200000080i=[<00<000000>CJc03Zf/<00P3Tf/`0
1@000000j][30>[J``3Zf/<000000080k]bn00<000000>3Oh`3Pgn<0?03P
gn<4000003P0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOUh0h=oS00<000000>3Oh`3Pgn<0703Pgn<70000000408B]k`28
]_@0Q:g_08Rfm0@000001`31c>82000000040<O<gP3Be]/00000000000@0
i=[<00D000000>[J``3Zf/<0j][3000000030>kL_P030000003Pgn<0h=oS
03P0h=oS1000000l0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWiO0>3Oh`030000003Pgn<0h=oS01`0h=oS0`0000000`0i
QNT0B8WZ0000000400000080U[G]00<0U;[a08fbk`0000001031c>820000
00060<O<gP3Be]/0alcN0<O<gP000000dm7G0P0000020>CJc0040000003Z
f/<0j][3000000<0k]bn00<000000>3Oh`3Pgn<0=@3Pgn<400000400h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOV00h=oS
00<000000>3Oh`3Pgn<0703Pgn<00`00000003Ng0000000303V5j@0:0000
002F]Nd0U;[a08fbk`2D^_40U[G]09Bjl@2F]Nd000000<7<hP80000000H0
d]KK0<O<gP3Be]/0alcN0=;Ff`0000040=?Ae`<000000P3Zf/<01@000000
k]bn0>kL_P3^g;h0000003@0h=oS0`0000140>3Oh`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWiQ0>3Oh`800000703Pgn<20000
0003000g]`00000000000080>HGY00<0000009Jek@2F]Nd0102F]Nd20000
00030<O<gP3Be]/0alcN00<0alcN00<000000=?Ae`3CdML00`3CdML00`00
0000f]GC0=[Ed`0300000080k]bn00<000000>3Oh`3Pgn<0;`3Pgn<40000
04L0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OV<0h=oS00<000000>3Oh`3Pgn<06@3Pgn<010000000h=oS00000000=kL5
00000080U[G]0`0000020:>nk00600000037c=h0d]KK0<O<gP3Be]/00000
1@3CdML01@000000gm?;0=[Ed`3JeM<000000080gm?;0`00000]0>3Oh`@0
0000B`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVInI03Pgn<00`000000h=oS0>3Oh`0H0>3Oh`030000003Pgn<0h=oS0080
000000<0BIC`04R9jP19U?000`0000000`2Q_nh0Xkk/0:>nk0030:>nk080
000000<0alcN0000003CdML0103CdML01@000000f]GC0=[Ed`3JeM<00000
00@0gm?;00<000000>3Oh`3Pgn<0:03Pgn<4000004l0h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOVD0h=oS00<000000>3O
h`3Pgn<05`3Pgn<010000000h=oS0>3Oh`3Pgn<2000000@0BIC`00<00000
0:6okP2Q_nh00`2S_^`0102Q_nh0Xkk/0000000000050=?Ae`030000003J
eM<0gm?;0080f]GC00D000000=oCb`3Odl/0gm?;0000000W0>3Oh`@00000
D`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
IP3Pgn<00`000000h=oS0>3Oh`0F0>3Oh`030000003Pgn<0h=oS0080h=oS
1@0000000`19U?000000000000020:6okP<000000P2[aN`01@000000dm7G
0=?Ae`3CdML0000000@0f]GC00<000000=oCb`3Odl/00P3Odl/00`000000
h=oS0>3Oh`0Q0>3Oh`@00000E`3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVInI`3Pgn<2000001H0h=oS00<000000>3Oh`3P
gn<00P3Pgn<300000080EiS`1@0000002`2``>H0ZlG/0:_5k02[aN`0/<3V
0:_5k0000000dm7G0000003JeM<0gm?;0080f]GC00<000000=oCb`3Odl/0
0P3Odl/00`000000h=oS0>3Oh`0O0>3Oh`<00000F`3Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInJ@3Pgn<00`000000h=oS
0>3Oh`0C0>3Oh`030000003Pgn<0h=oS00<0h=oS0`00000505NHl0050000
002[aN`0/<3V0:_5k02``>H00`2[aN`00`000000f]GC0=[Ed`020=[Ed`03
0000003Odl/0gm?;0080gm?;00<000000>3Oh`3Pgn<0703Pgn<4000005h0
h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOVX0
h=oS00<000000>3Oh`3Pgn<04P3Pgn<00`000000h=oS0>3Oh`040>3Oh`03
00000000=kL0000000@0EiS`00@000000:_5k02[aN`0/<3V0P2[aN`20000
00030<7<hP00000000000080f]GC00D000000=oCb`3Odl/0gm?;0000000K
0>3Oh`@00000HP3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVInJ`3Pgn<00`000000h=oS0>3Oh`0A0>3Oh`030000003Pgn<0
h=oS00D0h=oS1@00000205NHl0030000002[aN`0ZlG/0080000000D0`LcR
0;S:i`2``>H0`LcR0;S:i`02000000@0gm?;00<000000>3Oh`3Pgn<05@3P
gn<4000006H0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOV`0h=oS0P00000@0>3Oh`030000003Pgn<0h=oS00L0h=oS0`00
00000`1VX?40000000000003000000030;S:i`31c>80/<3V00<0^<[W0P00
00001@31c>8000000000003Odl/0000001@0h=oS1000001Z0>3Oh`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWi^0>3Oh`030000
003Pgn<0h=oS00d0h=oS00<000000>3Oh`3Pgn<0203Pgn<3000000@0IZ3a
00<000000;S:i`2hb^L00`2hb^L010000000`LcR0<O<gP37c=h20<7<hP03
0000003Pgn<0h=oS00l0h=oS1000001^0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWi_0>3Oh`030000003Pgn<0h=oS00`0
h=oS00<000000>3Oh`3Pgn<02@3Pgn<00`00000003Ng0000000300000004
06JPl@00000000000;S:i`8000000P37c=h20<7<hP030<O<gP000000h=oS
00h0h=oS0`00001b0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWi`0>3Oh`030000003Pgn<0h=oS00/0h=oS00<000000>3O
h`3Pgn<02P3Pgn<30000000307^[l@1]Yo@0000000<0000000<0alcN0<7<
hP31c>800P31c>800`37c=h000000>3Oh`0;0>3Oh`@00000M@3Pgn<00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInL@3Pgn<20000
00/0h=oS00<000000>3Oh`3Pgn<0303Pgn<200000080Nj_a00@0KJOd07^[
l@1]Yo@000000`37c=h2000000T0h=oS1000001i0>3Oh`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWic0>3Oh`030000003Pgn<0
h=oS00P0h=oS00<000000>3Oh`3Pgn<03@3Pgn<2000000D0Nj_a00<00000
0<O<gP0000001`3Pgn<4000007d0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0
000406IVOP3ko?d0Z:Vk06IVOW@0h=oS00<000000>3Oh`3Pgn<01`3Pgn<0
0`000000h=oS0>3Oh`0?0>3Oh`L00000103Pgn<400000840h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWD0h=oS00<00000
0>3Oh`3Pgn<01P3Pgn<00`000000h=oS0>3Oh`0F0>3Oh`@00000Q@3Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInMP3Pgn<2
000000H0h=oS00<000000>3Oh`3Pgn<04`3Pgn<3000008T0h=oS00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWP0h=oS00<00000
0>3Oh`3Pgn<00`3Pgn<00`000000h=oS0>3Oh`0?0>3Oh`@00000S03Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInN@3Pgn<0
0`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS00/0h=oS1000002@
0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWij
0>3Oh`050000003Pgn<0h=oS0>3Oh`0000002@3Pgn<4000009@0h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW/0h=oS0P00
00000`3Pgn<000000>3Oh`040>3Oh`@00000V03Pgn<00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInO@3Pgn<2000000030>3Oh`00
0000000000800000W03Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVInOP3Pgn<200000:00h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS8@3Pgn<00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<Q0>3Oh`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Ohb40h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS8@3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3P
gn<Q0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWko0>3Ohb40h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVO_l0h=oS8@3Pgn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn5@3Pgn<00`000000h=oS0>3Oh`3o0>3Oh`T0h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQD0h=oS00<0
00000>3Oh`3Pgn<0o`3Pgn<90>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0h=oS00@000000`3Pgn<2000000040>3Oh`00
0000h=oS00000080h=oS00L000000>3Oh`3Pgn<000000>3Oh`000000h=oS
008000000P3Pgn<00`000000h=oS0>3Oh`03000000D0h=oS00<000000>3O
h`3Pgn<00`3Pgn<00`000000h=oS0>3Oh`0300000080h=oS0P00003Z0>3O
h`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh00000
00@0h=oS00<000000>3Oh`0000000P3Pgn<2000000050>3Oh`000000h=oS
0>3Oh`0000000P3Pgn<010000000h=oS0000000000020>3Oh`050000003P
gn<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000
003Pgn<0h=oS00<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS
0000003[0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh50>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`000000
0P3Pgn<01P000000h=oS0>3Oh`000000h=oS000000<0h=oS00D000000>3O
h`000000h=oS000000080>3Oh`030000003Pgn<0h=oS00<0h=oS00<00000
0>3Oh`0000000`3Pgn<00`000000h=oS0000003[0>3Oh`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh30>3Oh`8000000`3Pgn<4
000000050>3Oh`000000h=oS0>3Oh`0000000P3Pgn<00`000000h=oS0000
00030>3Oh`040000003Pgn<000000>3Oh`D00000103Pgn<400000080h=oS
00<000000>3Oh`0000000`3Pgn<00`000000h=oS0000003[0>3Oh`0306IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0h=oS00800000
103Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`80000000H0h=oS0000
00000000h=oS0000003Pgn<200000080h=oS00D000000>3Oh`000000h=oS
000000030>3Oh`030000003Pgn<0h=oS0080h=oS00T000000>3Oh`3Pgn<0
h=oS0000003Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS0000003[
0>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0
000000L0h=oS0`0000020>3Oh`030000003Pgn<000000080h=oS00D00000
0>3Oh`3Pgn<000000>3Oh`0200000080h=oS00<000000>3Oh`3Pgn<00`00
00050>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS000000020>3Oh`<0
000000@0h=oS0000000000000000jP3Pgn<00`1VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn000000040>3Oh`030000003Pgn<0h=oS
01<0h=oS00<000000>3Oh`3Pgn<0203Pgn<01`000000h=oS0>3Oh`3Pgn<0
00000>3Oh`0000001`3Pgn<00`000000h=oS0>3Oh`3Y0>3Oh`0306IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0h=oS00@000005P3P
gn<00`000000h=oS0>3Oh`080>3Oh`@000000P3Pgn<00`000000h=oS0>3O
h`050>3Oh`030000003Pgn<0h=oS0>T0h=oS00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS8@3Pgn<00`1VIWh0Z:Vk0?_l
o@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIno`3Pgn<Q0>3Oh`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWko0>3Ohb40h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO_l0h=oS8@3P
gn<00`1VIWh0Z:Vk0?_lo@0106IVOP0000<0IVIn0?Ogn@2HV:L0o`1gMi8S
07MgTP40V9RW0@3gmoT106IVOP0000<0IVIn0?Ogn@2l_Ld0o`2l_LdT0;bm
c@40moOi0@1VIWh0000306IVOP3gmoT0i>?S0?l0i>?S903Thn<10?Ogn@40
IVIn00000`1VIWh0l?7d0?ooo`3L0?ooo`030>CSh`2LY;T0JgF?00<0JgF?
00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0i>?S
09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?oo
o`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0YcY42@2V>D@00`2L
Y;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F06IVOP3RhN80nocl0?_k
o03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m0?clo03lno`0o?cl
0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080o?cl00@0o?cm0?clo03k
nod0o?cmCP3lnoa=0?_lo2P0nocm00<0W:Bi06]eS`25RK004025RK001P1[
MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3ko?`0no_l
09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?clo03lnod0nocm0>;QhP01
06IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi0?Ogn03f
moP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0moKh0?Kg
n03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@1=0?OgnDd0m_Oi:03gmoT0
0`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[MHl0QHV`
4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ3@36EE`0
2@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@0106IVOP00
00H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@000000060?7am03`l_D0lO7d
0?7bm03`l_@0lO7dV`3`lODX0?3am00306]eS`2b]M00YjS20100YjS200H0
/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e0?7b
m02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0`U9K
0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3Lfn00j^_`
0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0inOW0>OW
i`030>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`
0>[[l01<0>[[l4d0j^c`:03Zjnl0101[MHl0][WA0:f^aP2][/H80?ooo`03
0:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0101[MHl0
][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Zjo001@2V
>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0cEUN0:Hi
A03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3SiNX0hnCZ
0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<00>OWi`3W
inL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX00P3Si>X0
0`3Si>/0hnG[0>?Uj`1<0>?Ujdd0hnCZ:03SiNX01@1[MHl0_;kD0;:bbP2b
//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0JgF?0>?U
jP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH02@0U9CH30;:bbP05
0;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?ooo`3oool7
0=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3S
iN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0g=kV00D000000>OWi`3W
inL0inOW0>OFcP020>OWi`050<ik003_U100inOW0>ONaP3_S1000`3_knl0
1`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H0``3Lg^D01@1[MHl0_l7F
0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0
JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh01`2h^Lh0
0`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V>D@0cEUN
0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`0505<U803DGF40dEYN0<eI
GP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn0=GFg@3E
f>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0ikF40=IJ003FQ000olh0
0<iS00020=i[00050>neS03_knl0kno_0>o_k`0000000P3Ef>40103Een00
e]SP0=KHh@3Fen5>0=KGh4d0e]SP:03Ef>401@1[MHl0`lGI0;bmd@2l_M40
oooo00L09BDf1`2l_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA
00<0oooo02DU=P2l_M401`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5
f@1[MHl0e]OP0=GGh@2V>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0
fF5R0`3oool00`167QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GG
h03Ef>40eMKM0@1VIWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L0000
00030>OWi`0<0>ONcP36BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:
0>NU003_ilh000000`3@d]`00`3?d]`0d=;L0<oBg01>0=3Bg4d0cm;M:03@
d]`00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3Bg01[MHl0
b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP030?ooo`0U9CH0`lCF0080
`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU00D0AQhJ
0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aUI@3IHF80
eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn0=3Bf`3;
cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH0>nm003gaP00kjd00>N]
003WY@00eX`00<i[003WaP00omH00>o_i`3_knl000000<_=f03;cMT0b/gI
0<_>f03:cMP0blgHCP3;cMU=0<_>fBP0blgH00<0JgF?0<_<gP38b]T02038
b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38b]T0blcN06]eS`80blgH
00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38b]T0b<[I
0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:HiA03GGel0
ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?ooo`030?ooo`0:04HN6P3N
IfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI0@3@d]/1
06IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P000000a/K60>ONeP3>N`00
ijd00>ne0080ijD000<0eY@00<ic003FU0000P3gaP020?Ogm`0400000035
b=@0aLOD0<G7e0<0aLOECP34amE=0<C8e2P0a<OD00<0JgF?0=3Ah03;bm`0
403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3Ah080bl_L00<0oooo02DU
=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;g0070=3Ah01[MHl0aLOD
0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3oool0oooo0?ooo`167QX0
1@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040aLOE0@3?cmX106IVOP00
00@0IVIn0<c>fP32a=80`LCA0P31a=801P000000inOW0>OWi`3WinL0eX@0
0>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm003_knl0moOg000000<0
`LCB00<0`/CA0<74dP31a=80CP31a=5=0<74dRP0`/CB00<0JgF?0=?ChP3?
d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M00<0oooo
02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@020<o@g@070=?ChP1[MHl0
`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203QJFD0ffAT
0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:c=P0_/3?
0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<00020=jD00040=Ik0036
H`00_D800>nU0080mjd000P0mkD00?o>BP000000_/3>0;k0c`2n`<h0_/3?
0;g0cTl0_/3>C@2m`<hX0;k0cP0306]eS`3Fe^@0dm?P0100dm?P00H0e]KT
06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo00P0oooo
00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0h6IU0>5Z
JP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo103SK6`0103QJVX0h6IU
0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:f02f^<P0
^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<003NU000eX@00>nU003N
S000_EX00=Ic003_W000mnoW0?Ogm`3oool000000;Vlc02j^l`0^Kc;0;Zl
b`2i_<`0^Kc;04h0^Kc<C@2j_<`X0;Zlb`0306]eS`3Hf>D0dm?Q0100dm?Q
00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?
00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0
h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3oool2
0>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H0040
IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OWgP02
0>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Ogm`050000
002f^LT0]kS90;Jib@2g^LT00P2f^<U>0;NhbDd0][S9:02g^<T0101[MHl0
e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0e]KT06]e
S`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U9CH0f=SV
0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>MaK`3TM6l0
0`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_0>MaK`3T
M6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG0@1VIWh0000306IVOP36
b=L0];K700<0];K700<000000>o_k`3_knl00P3_knl02`3W[@00mlH80>NU
003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool000000<T0];K700D0JgF?
0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`1[MHl0
eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS06]eS`2d
]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3oool00`167QX0jGih0>Un
N0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V>D@40;Bf
a`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0];K700H0000008b<S03_
knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_imH0moOg
0?ooo`0000390;Bfa`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS06]eS`2d
]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V>D@0jWUc
0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZKS03]UhX0
jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40a/SG0@1V
IWh0000306IVOP36b=L0/K?800<0/K?800H000000>o_k`3_knl0kno_0?Og
k`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg00<0oooo0000002a/lP0
b02a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?80;6cb01[
MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`Q7`0mHb4
0?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0
lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn00000`1V
IWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_0?Ogm`3_knl01P3gmoL2
0?ogm`80oooo00<000000:n^a`2_[/L0a`2_[/L00`1[MHl0d]7S0?;am`0@
0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3BdN<0JgF?
0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V>D@0[jk7
0080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0`<7A0<O7e03L0:b[a004
08B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@0
1024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_4
00L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0n^Vf0?WY
]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03oWhd0YSU4096HZP<0[:_4
0@37am@10<31d@40IVIn0000101VIWh0`<7A0=;Bg`2e]<WL0:BS_P0308B<
XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80JgF?
06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:HiA02V>D@0
3`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1VIWh00006
06IVOP2XYkl0i^K]0=;Bh02l_<l0/K34o`2XYklM0:RW_`050;6`a02l_<l0
d];P0>KVk@2XYkl00@1VIWh0000705QGJ027Qi/0emSR0?clo03ThnP0d=3P
0<[:fP3o0;blca/0_;c?00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QG
J00000P0F5MX06IVOP2EU:/0emSR0?clo03blO<0k>_^0>7Rjol0emSR6@3G
f>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX
00<0IVIn09FDZ`3AdMh00P3lo?co0?oooa/0oooo0P3lo?`00`3AdMh0UIB[
06IVOP0205QGJ0000`1HEfP206IVOP0308R7W@2EU:/0Z:No0?l0Z:No6P2X
Ykl0102EU:/0R8NM06IVOP1VIWh305QGJ0001@1HEfSo06IVOQl0IVIn1@1H
EfP00001\
\>"], "Graphics",
  CellLabel->"From In[9]:=",
  Evaluatable->False,
  ImageSize->{296, 285},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Images"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[9]=",
  CellTags->"Images"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Advanced Components", "Section",
  CellTags->"ComponentGallery"],

Cell[CellGroupData[{

Cell["\<\
Widget[\"MenuBar\"]
Widget[\"Menu\"]
Widget[\"MenuItem\"]\
\>", "ObjectName",
  CellTags->"Menu"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"Menu"],

Cell[BoxData[
    RowBox[{
      RowBox[{"ref", "  ", "=", " ", 
        RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
          RowBox[{
            StyleBox["Widget",
              "Output"], "[", 
            RowBox[{"\"\<Frame\>\"", ",", 
              RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                  RowBox[{"\"\<menus\>\"", "\[Rule]", "\[IndentingNewLine]", 
                    RowBox[{
                      StyleBox["Widget",
                        "Output"], "[", 
                      RowBox[{"\"\<MenuBar\>\"", ",", 
                        RowBox[{"{", "\[IndentingNewLine]", 
                          RowBox[{
                            RowBox[{
                              StyleBox["Widget",
                                "Output"], "[", 
                              RowBox[{"\"\<Menu\>\"", ",", 
                                RowBox[{"{", 
                                  
                                  RowBox[{\("\<text\>" \[Rule] "\<Menu A\>"\),
                                     ",", "\[IndentingNewLine]", 
                                    RowBox[{
                                      StyleBox["Widget",
                                        "Output"], 
                                      "[", \("\<MenuItem\>", {"\<text\>" -> "\
\< Item A-1\>"}\), "]"}], ",", "\[IndentingNewLine]", 
                                    RowBox[{
                                      StyleBox["Widget",
                                        "Output"], 
                                      "[", \("\<MenuItem\>", {"\<text\>" -> "\
\< Item A-2\>"}\), "]"}], ",", "\[IndentingNewLine]", 
                                    RowBox[{
                                      StyleBox["Widget",
                                        "Output"], "[", 
                                      "\"\<MenuSeparator\>\"", "]"}], ",", 
                                    "\[IndentingNewLine]", 
                                    RowBox[{
                                      StyleBox["Widget",
                                        "Output"], 
                                      "[", \("\<MenuItem\>", {"\<text\>" -> "\
\< Item A-3\>"}\), "]"}]}], "\[IndentingNewLine]", "}"}]}], "]"}], ",", 
                            "\[IndentingNewLine]", 
                            RowBox[{
                              StyleBox["Widget",
                                "Output"], "[", 
                              RowBox[{"\"\<Menu\>\"", ",", 
                                RowBox[{"{", 
                                  
                                  RowBox[{\("\<text\>" \[Rule] "\<Menu B\>"\),
                                     ",", "\[IndentingNewLine]", 
                                    RowBox[{
                                      StyleBox["Widget",
                                        "Output"], 
                                      "[", \("\<MenuItem\>", {"\<text\>" -> "\
\< Item B-1\>"}\), "]"}]}], "\[IndentingNewLine]", "}"}]}], "]"}]}], 
                          "\[IndentingNewLine]", "}"}]}], "]"}]}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{
                    StyleBox["Widget",
                      "Output"], "[", "\"\<TextArea\>\"", "]"}]}], 
                "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
          "]"}]}], ";"}]], "Input",
  CellLabel->"In[10]:=",
  CellTags->"Menu"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"Menu"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002M0000[b000`400?l0
0000o`00003oW@1VIWh0000306IVOP3ko?d0nocm09T0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk09P0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
U`1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOYD0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOUT0LFmT
?03oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
0?7_hP1G09fMX@03075_I03oool0oooo03X0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3akn80ooooE@3Pgn<00`2MWJ40
LFmT0?ooo`0k0?ooo`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm
0:RY^`1VIWh0lNoR0?ooo`3Pgn<0D`3oool00`3Pgn<0WIfQ075_I00l0?oo
o`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0lNoR
0?ooo`3Pgn<0D`3oool00`3Pgn<0WIfQ075_I00l0?ooo`0306IVOP2XZK/0
nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0lNoR0?ooo`3Pgn<0D`3o
ool00`3Pgn<0WIfQ075_I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0lNoR0?ooo`3Pgn<0D`3oool00`3Pgn<0WIfQ
075_I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY
^`1VIWh0lNoR0?ooo`3Pgn<0D`3oool00`3Pgn<0WIfQ075_I00l0?ooo`03
06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0lNoR0?oo
o`3Pgn<0D`3oool00`3Pgn<0WIfQ075_I00l0?ooo`0306IVOP2XZK/0nocm
0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0lNoR0?ooo`3Pgn<05P3oool3
00000080oooo0P0000020?ooo`<000000P3oool010000000oooo0?ooo`00
00020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3o
ool00`000000oooo0?ooo`040?ooo`<000005@3oool00`3Pgn<0WIfQ075_
I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0lNoR0?ooo`3Pgn<05`3oool010000000oooo0?ooo`0000030?ooo`07
0000003oool0oooo0?ooo`000000oooo000000020?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`030?ooo`050000003oool0oooo0?ooo`000000503oool00`3Pgn<0WIfQ
075_I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY
^`1VIWh0lNoR0?ooo`3Pgn<05`3oool010000000oooo0?ooo`0000030?oo
o`030000003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`020?ooo`H000002@3oool00`000000oooo0?ooo`0B
0?ooo`030>3Oh`2MWJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP3akn80oooo0>3Oh`0G0?ooo`040000003o
ool0oooo000000<0oooo1@0000001@3oool000000?ooo`3oool000000080
oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?oo
o`<000001@3oool00`000000oooo0?ooo`0B0?ooo`030>3Oh`2MWJ40LFmT
03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3akn80oooo0>3Oh`0G0?ooo`040000003oool0oooo000000<0oooo00L0
00000?ooo`3oool0oooo0000003oool000000080oooo00@000000?ooo`3o
ool000001@3oool010000000oooo0?ooo`0000080?ooo`8000005@3oool0
0`3Pgn<0WIfQ075_I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn00001`1V
IWh0nocm0:RY^`1VIWh0lNoR0?ooo`3Pgn<05`3oool00`000000oooo0?oo
o`0300000080oooo0`0000020?ooo`<0000000<0oooo0000000000001P3o
ool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo0180oooo
00<0h=oS09fMX@1aKf@0?03oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000L0
IVIn0?_lo@2XZK/0IVIn0?7_hP3oool0h=oS01L0oooo00@000000?ooo`3o
ool000005P3oool2000000L0oooo00D000000?ooo`3oool0oooo0000000D
0?ooo`030>3Oh`2MWJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP3akn80oooo0>3Oh`0F0?ooo`<0000000<0
oooo0000003oool05@3oool2000000P0oooo0`00000E0?ooo`030>3Oh`2M
WJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP3akn80oooo0>3Oh`1C0?ooo`030>3Oh`2MWJ40LFmT03`0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3akn80
oooo0>3Oh`1C0?ooo`030>3Oh`2MWJ40LFmT03`0oooo00<0IVIn0:RY^`3k
o?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3akn80oooo0>3Oh`1C0?oo
o`030>3Oh`2MWJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh00007
06IVOP3ko?d0Z:Vk06IVOP3akn80oooo0>3Oh`1C0?ooo`030>3Oh`2MWJ40
LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP3akn80oooo0>3Oh`1C0?ooo`030>3Oh`2MWJ40LFmT03`0oooo00<0
IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3akn80oooo
0>3Oh`1C0?ooo`030>3Oh`2MWJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3akn80oooo0>3Oh`1C09fMX@03
0>3Oh`2MWJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP3akn80oooo0>3Oh`1C0?ooo`030>3Oh`2MWJ40LFmT
03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3akn80oooo0>3Oh`1C0?ooo`030>3Oh`2MWJ40LFmT03`0oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3akn80oooo0>3O
h`1C0?ooo`030>3Oh`2MWJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP3akn80oooo0>3Oh`1C0?ooo`030>3O
h`2MWJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP3akn80oooo0>3Oh`1C0?ooo`030>3Oh`2MWJ40LFmT03`0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3a
kn80oooo0>3Oh`1C0?ooo`030>3Oh`2MWJ40LFmT03`0oooo00<0IVIn0:RY
^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3akn80oooo0>3Oh`0F
0?ooo`<000000P3oool200000080oooo0`0000020?ooo`040000003oool0
oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooo`030000003oool0oooo00<0oooo1@00000D0?ooo`030>3Oh`2M
WJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP3akn80oooo0>3Oh`0G0?ooo`040000003oool0oooo000000<0
oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo00@00000
0?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool05P3oool00`3Pgn<0WIfQ075_
I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0lNoR0?ooo`3Pgn<05`3oool010000000oooo0?ooo`0000030?ooo`03
0000003oool0oooo00<0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0?ooo`020?ooo`H000001P3oool00`000000oooo0?ooo`0E0?oo
o`030>3Oh`2MWJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh00007
06IVOP3ko?d0Z:Vk06IVOP3akn80oooo0>3Oh`0G0?ooo`040000003oool0
oooo000000<0oooo1@0000001@3oool000000?ooo`3oool000000080oooo
00<000000?ooo`3oool00`3oool010000000oooo0?ooo`0000020?ooo`<0
00000`3oool00`000000oooo0?ooo`0D0?ooo`030>3Oh`2MWJ40LFmT03`0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3a
kn80oooo0>3Oh`0G0?ooo`040000003oool0oooo000000<0oooo00L00000
0?ooo`3oool0oooo0000003oool000000080oooo00@000000?ooo`3oool0
00001@3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo
01<0oooo00<0h=oS09fMX@1aKf@0?03oool00`1VIWh0Z:Vk0?_lo@0106IV
OP0000L0IVIn0?_lo@2XZK/0IVIn0?7_hP3oool0h=oS01L0oooo00<00000
0?ooo`3oool00`0000020?ooo`<000000P3oool3000000030?ooo`000000
000000H0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?oo
o`0B0?ooo`030>3Oh`2MWJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP3akn80oooo0>3Oh`0G0?ooo`040000
003oool0oooo000001H0oooo0P0000070?ooo`050000003oool0oooo0?oo
o`000000503oool00`3Pgn<0WIfQ075_I00l0?ooo`0306IVOP2XZK/0nocm
0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0lNoR0?ooo`3Pgn<05P3oool3
000000030?ooo`000000oooo01D0oooo0P0000080?ooo`<000005@3oool0
0`3Pgn<0WIfQ075_I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn00001`1V
IWh0nocm0:RY^`1VIWh0lNoR0?ooo`3Pgn<0D`3oool00`3Pgn<0WIfQ075_
I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0lNoR0?ooo`3Pgn<0D`3oool00`3Pgn<0WIfQ075_I00l0?ooo`0306IV
OP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0lNoR0?ooo`3P
gn<0D`3oool00`3Pgn<0WIfQ075_I00l0?ooo`0306IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0lNoR0?ooo`3Pgn<0D`3oool00`3P
gn<0WIfQ075_I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0lNoR0?ooo`3Pgn<0D`3oool00`3Pgn<0WIfQ075_I00l
0?ooo`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0
lNoR0?ooo`3Pgn<0D`3oool00`3Pgn<0WIfQ075_I00l0?ooo`0306IVOP2X
ZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0lNoR0?ooo`3Pgn<0
D`3oool00`3Pgn<0WIfQ075_I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn
00001`1VIWh0nocm0:RY^`1VIWh0lNoR0?ooo`3Pgn<0D`3oool00`3Pgn<0
WIfQ075_I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm
0:RY^`1VIWh0lNoR0?ooo`3Pgn<0D`3oool00`3Pgn<0WIfQ075_I00l0?oo
o`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0lNoR
0?ooo`3Pgn<0D`3oool00`3Pgn<0WIfQ075_I00l0?ooo`0306IVOP2XZK/0
nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0lNoR0?ooo`3Pgn<0D`3o
ool00`3Pgn<0WIfQ075_I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0lNoR0?ooo`3Pgn<05P3oool300000080oooo
0P0000020?ooo`<000000P3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`040?ooo`<000005@3oool00`3Pgn<0WIfQ075_I00l0?ooo`03
06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0lNoR0?oo
o`3Pgn<05`3oool010000000oooo0?ooo`0000030?ooo`070000003oool0
oooo0?ooo`000000oooo000000020?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo01@0oooo00<0h=oS09fMX@1aKf@0?03oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?7_hP3oool0h=oS
01L0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`03
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3o
ool6000000L0oooo00<000000?ooo`3oool0503oool00`3Pgn<0WIfQ075_
I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0lNoR0?ooo`3Pgn<05`3oool010000000oooo0?ooo`0000030?ooo`D0
000000D0oooo0000003oool0oooo000000020?ooo`030000003oool0oooo
00<0oooo00@000000?ooo`3oool000000P3oool3000000<0oooo00<00000
0?ooo`3oool0503oool00`3Pgn<0WIfQ075_I00l0?ooo`0306IVOP2XZK/0
nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0lNoR0?ooo`3Pgn<05`3o
ool010000000oooo0?ooo`0000030?ooo`070000003oool0oooo0?ooo`00
0000oooo000000020?ooo`040000003oool0oooo000000D0oooo00@00000
0?ooo`3oool00000203oool00`000000oooo0?ooo`0D0?ooo`030>3Oh`2M
WJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP3akn80oooo0>3Oh`0G0?ooo`030000003oool0oooo00<00000
0P3oool300000080oooo0`0000000`3oool00000000000060?ooo`040000
003oool0oooo000000P0oooo00<000000?ooo`3oool0503oool00`3Pgn<0
WIfQ075_I00l0?ooo`0306IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm
0:RY^`1VIWh0lNoR0?ooo`3Pgn<05`3oool010000000oooo0?ooo`00000F
0?ooo`800000203oool2000001H0oooo00<0h=oS09fMX@1aKf@0?03oool0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn0?7_hP3o
ool0h=oS01H0oooo0`0000000`3oool000000?ooo`0E0?ooo`8000002@3o
ool00`000000oooo0?ooo`0D0?ooo`030>3Oh`2MWJ40LFmT03`0oooo00<0
IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3akn80oooo
0>3Oh`1C0?ooo`030>3Oh`2MWJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3akn80oooo0>3Oh`1C0?ooo`03
0>3Oh`2MWJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP3akn80oooo0>3Oh`1C0?ooo`030>3Oh`2MWJ40LFmT
03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP3akn80oooo0>3Oh`1C0?ooo`030>3Oh`2MWJ40LFmT03`0oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP3akn80oooo0>3O
h`1C0?ooo`030>3Oh`2MWJ40LFmT03`0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000606IVOP3ko?d0Z:Vk06IVOP3akn80ooooE@3Pgn<00`2MWJ40LFmT
0?ooo`0k0?ooo`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0lNoR05H0oooo00<0WIfQ075_I03oool0>@3oool01@2MWJ40oooo
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWiH0?7_hP03
075_I02MWJ40WIfQ03T0WIfQ00@0oooo06IVOP2XZK/0nocm0@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOS40/[BoI03Ph^/00`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn<@2b];mT0>3Rj`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWha0;:d_f@0h>;[00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS40/[BoI03Ph^/00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn<@2b];mT0>3R
j`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWha0;:d
_f@0h>;[00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OPH0/[Bo00<000000;:d_`2b];l00`2b];l00`000000/[Bo0;:d_`030000
0080/[Bo00D000000;:d_`2b];l0/[Bo000000020;:d_`@00000102b];l0
0`000000/[Bo0;:d_`020;:d_`030000002b];l0/[Bo00H0/[Bo1P3Ph^/0
0`000000h>;[0>3Rj`030>3Rj`030000003Ph^/0h>;[00<000000P3Ph^/0
1@000000h>;[0>3Rj`3Ph^/000000080h>;[100000040>3Rj`@00000?@3P
h^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1P2b
];l00`000000/[Bo0;:d_`030;:d_`030000002b];l0000000<0/[Bo00<0
00000;:d_`0000000`2b];l00`000000/[Bo000000030;:d_`030000002b
];l0/[Bo0080/[Bo00<000000;:d_`2b];l00P2b];l00`000000/[Bo0;:d
_`060;:d_`H0h>;[00<000000>3Rj`3Ph^/00`3Ph^/00`000000h>;[0000
00030>3Rj`030000003Ph^/0000000<0h>;[00<000000>3Rj`0000000`3P
h^/00`000000h>;[0>3Rj`020>3Rj`050000003Ph^/0h>;[0>3Rj`000000
?03Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
1P2b];l010000000/[Bo0;:d_`0000020;:d_`030000002b];l0000000D0
/[Bo00L000000;:d_`2b];l0/[Bo0000002b];l0000000<0/[Bo00<00000
0;:d_`2b];l00P2b];l6000000P0/[Bo1P3Ph^/010000000h>;[0>3Rj`00
00020>3Rj`030000003Ph^/0000000D0h>;[00L000000>3Rj`3Ph^/0h>;[
0000003Ph^/0000000<0h>;[00<000000>3Rj`3Ph^/00P3Ph^/01@000000
h>;[0>3Rj`3Ph^/0000003`0h>;[00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOPH0/[Bo00@000000;:d_`2b];l000000P2b];l0
0`000000/[Bo00000004000000030;:d_`000000/[Bo0080/[Bo00<00000
0;:d_`0000000`2b];l00`000000/[Bo0;:d_`030;:d_`040000002b];l0
/[Bo000000T0/[Bo1P3Ph^/010000000h>;[0>3Rj`0000020>3Rj`030000
003Ph^/0000000@0000000<0h>;[0000003Ph^/00P3Ph^/00`000000h>;[
000000030>3Rj`030000003Ph^/0h>;[0080h>;[00D000000>3Rj`3Ph^/0
h>;[0000000l0>3Rj`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWh60;:d_`090000002b];l000000;:d_`000000/[Bo0000002b
];l0000000<0/[Bo00<000000;:d_`0000000`2b];l00`000000/[Bo0000
00030;:d_`030000002b];l0/[Bo00<0/[Bo00@000000;:d_`2b];l00000
2@2b];l60>3Rj`090000003Ph^/000000>3Rj`000000h>;[0000003Ph^/0
000000<0h>;[00<000000>3Rj`0000000`3Ph^/00`000000h>;[00000003
0>3Rj`030000003Ph^/0h>;[0080h>;[1000000m0>3Rj`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh60;:d_`070000002b];l0
00000;:d_`000000/[Bo000000020;:d_`<000000P2b];l400000080/[Bo
00D000000;:d_`2b];l0/[Bo000000050;:d_`040000002b];l0/[Bo0000
00T0/[Bo1P3Ph^/01`000000h>;[0000003Ph^/000000>3Rj`0000000P3P
h^/300000080h>;[100000020>3Rj`050000003Ph^/0h>;[0>3Rj`000000
103Ph^/01@000000h>;[0>3Rj`3Ph^/0000003`0h>;[00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPH0/[Bo0P0000030;:d_`80
0000602b];l2000000X0/[Bo1P3Ph^/2000000<0h>;[0P00000F0>3Rj`05
0000003Ph^/0h>;[0>3Rj`000000?03Ph^/00`1VIWh0Z:Vk0?_lo@0106IV
OP0000@0IVIn0?_lo@2XZK/0IVIn1P2b];l2000000<0/[Bo0P00000H0;:d
_`8000002P2b];l60>3Rj`8000000`3Ph^/2000001H0h>;[1000000m0>3R
j`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWha0;:d
_f@0h>;[00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IV
OS40/[BoI03Ph^/00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn<@2b];mT0>3Rj`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWha0;:d_f@0h>;[00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOS40/[BoI03Ph^/00`1VIWh0Z:Vk0?_lo@0106IV
OP0000<0IVIn0?Ogn@2HV:L0U`1gMi8109RHY`40moOi0@1VIWh0000306IV
OP3gmoT0_;g=09P0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3Thn<0V03T
hn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`1A0?ooo`030>CSh`2LY;T0
JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?oo
o`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2L
Y;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0YcY4
2@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F06IVOP3R
hN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m0?cl
o03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080o?cl00@0
o?cm0?clo03knod0o?cm7`3lno`I0?_lo00309bT^@1[MHl0QHV`0100QHV`
00H0JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9/00606]eS`2LY;T0nocl
0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_lo03lo?`0o?_m0?_lo@3R
hN800@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0m_Oh0?Ogn@3g
moP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi0?Kgn@020?Ogn@040?Of
n03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3gmoT07P3gmoTI0?Kgn@03
06]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi06]eS`25RK0A
09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=0<IEG009
0<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q0040IVIn0000
1P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm100000000H0lO7d0?3bm@3alO@0
lO;d0?3bm03alO@h0?3am@0306]eS`2b]M00YjS20100YjS200H0/[G@06]e
S`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e0?7bm02V>D@0
0P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0`U9K0:HiA080
l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3Lfn00j^_`0>[[l03Z
k?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0inOW0>OWi`030>OW
i`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`0>[[l00M
0>[[l1T0j^c`00@0JgF?0;Jid@2][/H0[Jk6203oool00`2][/H0[:k60:f^
aP030:f^aP030:b^aP2f^M40JgF?0080j^__00@0JgF?0;Jid@2][/H0[Jk6
303oool20:f^aP030:b^aP2f^M40JgF?0080j^_`00D0YSU40<eIGP3;E5T0
cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0j^__0>[[l002
0>[[k`40g=_P0@1VIWh0000406IVOP3IfMl0hnGZ0>?TjP80hnG[00D00000
08b<S03Ng]h0inOW0=kNgP020>OWi`030<IS003WinL0inOW0080inOW00L0
knoW0>o_k`3_knl000000>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[0>?Uj`3S
iN/07@3SiN/I0>?TjP0506]eS`2l_]@0/[;:0;:bbP3oool01P1^KHl00`0U
9CH0/[;:0;:bbP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[MHl0_;kD0P2b
//X00`3oool09BDf02DU=P0902DU=P<0/[;:00D0_;kD06]eS`3Si>/0hnC[
0:HiA0020<eIGP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3oool02P3DG5l0
d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl106IVOP0000<0
IVIn0=OHgP3Lg^H00`3Lg^H01@000000inOW0>OWi`3WinL0imK>0080inOW
00D0cW/00>nD403WinL0imk60>n<40030>o_k`070000003Lg^H0g=kU0=cN
i@3Lg^H0g=kU0=cNiP0h0=cNi@0506]eS`2o`MH0^;W>0;RicP3oool01P1^
KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU0=cNi@1[MHl0
_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U9CH0^;W>0080
^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C9B000`3o
ool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA0020=cNi@030=cN
iP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>420=GHh0090000
002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080gV/000D0kkF<
0>o_k`3_knl0kno_000000020=GHh@040=GGh03Ff>00e]SQ0=KGhAl0e]OP
6@3Ff>001@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M401P33aMT0
JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M401`2l_M40
0`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V>D@00P3E
GF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0fF5R0=QP
H@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0000706IV
OP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36BP00mlh0
0>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@d]`00`3?
d]`0d=;L0<oBg00O0=3Bg1T0cm;M00<0JgF?0<S9f`33a=H04033a=H01P38
bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80`lCF00<0oooo02DU=P33a=H01`33
a=H00`3oool09BDf0<?4eP020<?4eP070<S9f`1[MHl0cm;L0<oBg02V>D@0
eemO0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3oool02016
7QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`10<oBg040d]CM
0@1VIWh0000L06IVOP3@d]/0blgH0<[=f@3;c]P0b/gH0000003WaZd0ilJ<
0?O>603__@00mlH00>n]003W[@00ijD00=J<003>J`00ilH00?oF003_knL0
kno_0000003;cMP0blgI0<[=f@3;c]P0b/gH0<_=f1l0blgI6@3;c]T00`1[
MHl0blcN0<S:f@080<S:f@030<S9f@38b]T0b<[I00<0b<[I00@0b<WI0<S:
f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN0<S:f@38b]T0oooo02DU=PD0b<[I
0140b<WI0<S:f@38b]T0oooo02DU=P38b]T0b<WI0<S:f@3;c=h0JgF?0<_>
f03:cMP0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN6P3oool0oooo
00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO0:HiA03:c]P0
b/kI0P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0030<G8e0060000
0036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD00020?O6
0080moOg00@000000<G8e035am@0aLOD0`35amDO0<C7eAT0a<SD00<0JgF?
0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3Ah080bl_L
00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;g0070=3A
h01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3oool0oooo
0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040aLOE0@3?
cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000inOW0>OW
i`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm003_knl0
moOg000000<0`LCB00<0`/CA0<74dP31a=807`31a=4I0<74dP0306]eS`3C
dn80cm3M0100cm3M00H0dm?R06]eS`32a=80`/CB06]eS`3Cdn820<o@g@03
0?ooo`0U9CH0cm3M00L0cm3M00<0oooo02DU=P3?d=d00P3?d=d01`3Cdn80
JgF?0<;4dP31a=40YSU40=]TI03QJFD01@3PK6T50?ooo`D0h6aY00P0hFUU
0=]TI02V>D@0`LCB0<;4d@31a=40`LCB0<c>fP40IVIn0000101VIWh0b/cH
0;k0c`2m`<l20;k0cP050000002LW9`0inOW0>ONeP3FS0000P3NU000103F
N`00aV<00;e2003_Y@020?N]00080?Ne003ocTX000000;k0cP2n`<l0_/3>
0;k0c`2m`<hP0;k0cQT0_L3>00<0JgF?0=KFi03Cdn00403Cdn001P3Fe^@0
JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3oool0203oool0
2`0U9CH0dm?P0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:HiA03PIVD0hFYZ
00@0hfa/0`3oool010167QX0oooo0?ooo`3oool40>=/K0040>5ZJP3PIVD0
YSU40;g0c`80_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0bL[H0;Jhb02i
_</0^[c;0;Zlc00000000P3_knl04`3FW000eX`00=jD003FQ000kjD00=j<
002mFP00eW<00>nL003gknL0moOg0?ooo`000000^Kc<0;Zkc02i_</0^[c;
0;Vlc02i_</07`2i_<`I0;Zlc00306]eS`3Hf>D0dm?Q0100dm?Q00H0f=SU
06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?00P0KVf?
00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0h6UX0>5]
K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3oool20>A`KP09
0>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H0040IVIn0000
2@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OWgP020>o_k`07
0<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Ogm`050000002f^LT0
]kS90;Jib@2g^LT00P2f^<TO0;NhbAT0][S900@0JgF?0=KFi03Hf>D0f=SV
0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@090=KFi01[MHl0]kS90;Nhb@1[
MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d09BDf0=SHiP3Hf>D0f=SU0=KF
i01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo00D0AQhJ
0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^K@2V>D@0
][W90;Jhb@2f^LT0];K70<O9e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bf
a`030000003_knl0kno_0080kno_00/0ijd00?O6203WY@00ii@00>N<003_
imH0gY@i0>oF]@3omoL0oooo0000000n0;Bfa`0506]eS`3EeN<0g=_W0=cK
i`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80g=_W00<0
gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GEh`1[MHl0];K70;Bfa`2V>D@0
ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ0>UnN03YOWP00`3YOWP02016
7QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d]/L10<K8e`40IVIn
00000`1VIWh0a/SG0;Bfa`030;Bfa`060000002<S8`0kno_0>o_k`3WcW/0
kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool00000?P2d
]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0];K70;Bfa`1[MHl0
eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0YSU40>YiL`3YO7P0kh5j0?:9
P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:0>^HR`0204HN6P05
0?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L10<K8e`40IVIn00000`1VIWh0
a/SG0;6cb0030;6cb0060000003_knl0kno_0>o_k`3gmnl0kno_0P3gmoL0
0`3gilH0moOg0?ooo`030?Ogm`030?ooo`000000/K?803d0/K?800<0JgF?
0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[la40jNSa
01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0lZ^F0?6b
V`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3gWHh0mHb4
0?24O03aP7D0YSU400@0/K?80@36b=L106IVOP0000<0IVIn0<K8e`2h]ll0
0`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3omoL20?ooo`03
0000002_[/L0[jk703`0[jk700<0JgF?0=;Ah`3blOL0403blOL01P3BdN<0
JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0d]7S06]eS`2_[/L0[jk70:Hi
A03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^a`020:n^a`40^;O?
0@36b=L106IVOP0000<0IVIn0<31d@37am@0D@2/Zl@01024S:80JgF?0<c;
g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400@0Q8bR06]eS`3<
bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a007096HZP2V>D@0
oin=0?joY03jg;L0n^^g0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf0?[Y]P80
nNVf00H0n^^g0?[L]`3n_j@0oin=0:HiA02AV:X30:b[a040alOD0@30`M41
06IVOP0000@0IVIn0<31d@3Bd]l0]KC9D@2TXkh00`24S:80JgF?06]eS`0?
06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl0
0`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V>D@0YSU400l0YSU400L0Q8bR
0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040IVIn00001P1VIWh0Z:No0>KV
k@3Bd^00_;c?0;6`a940Z:No00D0/K340;blc`3Bd^00i^K]0:RW_`0106IV
OP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@d>00b/[J08l0_;c?00H0b/[J
0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ00000P0F5MX06IVOP2EU:/0emSR
0?clo03blO<0k>_^0>7Rjhd0emSR00L0hN;[0>c[kP3blO<0o?cl0=OHhP2E
U:/0IVIn0040F5MX000205QGJ00306IVOP2EU:/0dM7N0080o?clS`3oool2
0?clo0030=7AgP2EU:/0IVIn0080F5MX000305QGJ080IVIn00<0R8NM09FD
Z`2XYkl0SP2XYkl0102EU:/0R8NM06IVOP1VIWh305QGJ0001@1HEfRC06IV
OPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[11]:=",
  Evaluatable->False,
  ImageSize->{157, 175},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Menu"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]=",
  CellTags->"Menu"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"ToolBar\"]", "ObjectName",
  CellTags->"ToolBar"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"floatable\" \[Rule] False\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"rollover\" \[Rule] True", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"ToolBar"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"ToolBar"],

Cell[BoxData[
    RowBox[{
      RowBox[{"ref", "  ", "=", " ", 
        RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
          RowBox[{
            StyleBox["Widget",
              "Output"], "[", 
            RowBox[{"\"\<Frame\>\"", ",", 
              RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                  RowBox[{
                    StyleBox["Widget",
                      "Output"], "[", 
                    RowBox[{"\"\<ToolBar\>\"", ",", 
                      RowBox[{"{", "\[IndentingNewLine]", 
                        RowBox[{
                          RowBox[{
                            StyleBox["Widget",
                              "Output"], "[", 
                            RowBox[{"\"\<Button\>\"", ",", 
                              RowBox[{"{", "\[IndentingNewLine]", 
                                RowBox[{"\"\<icon\>\"", "\[Rule]", 
                                  RowBox[{
                                    StyleBox["Widget",
                                      "Output"], 
                                    "[", \("\<Icon\>", {"\<path\>" -> \
"\<Wolfram/Example/Stop16.gif\>"}\), "]"}]}], "\[IndentingNewLine]", "}"}]}], 
                            "]"}], ",", "\[IndentingNewLine]", 
                          RowBox[{
                            StyleBox["Widget",
                              "Output"], "[", 
                            RowBox[{"\"\<Button\>\"", ",", 
                              RowBox[{"{", "\[IndentingNewLine]", 
                                RowBox[{"\"\<icon\>\"", "\[Rule]", 
                                  RowBox[{
                                    StyleBox["Widget",
                                      "Output"], 
                                    "[", \("\<Icon\>", {"\<path\>" -> \
"\<Wolfram/Example/Play16.gif\>"}\), "]"}]}], "\[IndentingNewLine]", "}"}]}], 
                            "]"}], ",", "\[IndentingNewLine]", 
                          RowBox[{
                            StyleBox["Widget",
                              "Output"], "[", "\"\<MenuSeparator\>\"", "]"}], 
                          ",", "\[IndentingNewLine]", 
                          RowBox[{
                            StyleBox["Widget",
                              "Output"], "[", 
                            RowBox[{"\"\<Button\>\"", ",", 
                              RowBox[{"{", "\[IndentingNewLine]", 
                                RowBox[{"\"\<icon\>\"", "\[Rule]", 
                                  RowBox[{
                                    StyleBox["Widget",
                                      "Output"], 
                                    "[", \("\<Icon\>", {"\<path\>" -> \
"\<Wolfram/Example/Delete16.gif\>"}\), "]"}]}], "\[IndentingNewLine]", 
                                "}"}]}], "]"}], ",", "\[IndentingNewLine]", 
                          RowBox[{
                            StyleBox["Widget",
                              "Output"], 
                            "[", \("\<Label\>", {"\<text\>" -> "\<Search: \
\>"}\), "]"}], ",", "\[IndentingNewLine]", 
                          RowBox[{
                            StyleBox["Widget",
                              "Output"], "[", "\"\<TextField\>\"", "]"}], ",",
                           "\[IndentingNewLine]", \("\<floatable\>" \[Rule] 
                            False\), ",", 
                          "\[IndentingNewLine]", \("\<rollover\>" \[Rule] 
                            True\)}], "}"}], 
                      ",", \(Name \[Rule] "\<toolBar\>"\)}], "]"}], ",", 
                  "\[IndentingNewLine]", 
                  RowBox[{
                    StyleBox["Widget",
                      "Output"], 
                    "[", \("\<TextArea\>", \ {"\<columns\>" \[Rule] 
                        30, \ "\<rows\>" \[Rule] 5}\), "]"}]}], 
                "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
          "]"}]}], ";"}]], "Input",
  CellLabel->"In[12]:=",
  CellTags->"ToolBar"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"ToolBar"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003J0000T2000`400?l0
0000o`00003ofP1VIWh0000306IVOP3ko?d0nocm0=H0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0=D0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
e01VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80h=oS
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOWL0h=oS
FP2U[;80103Pgn<0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn<P3Pgn<00`2o_lD0h=oS0>3Oh`120>3Oh`030:F//P3oool0oooo05H0
oooo00D0YJbb0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn<P3Pgn<00`2o_lD0h=oS0>3Oh`120>3Oh`030:F//P3oool0oooo
05H0oooo00D0YJbb0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn<P3Pgn<00`2o_lD0h=oS0>3Oh`120>3Oh`030:F//P3oool0
oooo05H0oooo00D0YJbb0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn
0?_lo@2XZK/0IVIn<P3Pgn<00`2o_lD0h=oS0>3Oh`120>3Oh`030:F//P3o
ool0oooo05H0oooo00D0YJbb0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn8@3Pgn<00`3oool0h=oS0>3Oh`0>0>3Oh`030;no
a@3Pgn<0h=oS00T0h=oS2@3oool`0>3Oh`030:F//P3oool0oooo05H0oooo
00D0YJbb0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn1`3Pgn<;0?ooo`h0h=oS00<0<c=V0?ooo`3oool03`3Pgn<00`2o_lD0
h=oS0>3Oh`080>3Oh`T0<c<c00<0oooo0>3Oh`3Pgn<0;P3Pgn<00`2U[;80
oooo0?ooo`1F0?ooo`050:F//P3Pgn<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOPH0h=oS00<0<c=V06IVV@0c<fH0200c<fH00`3o
ool0h=oS0>3Oh`0<0>3Oh`80<c=V0P3oool>0>3Oh`030;noa@3Pgn<0h=oS
00P0h=oS00@0<c<c0?ooo`3<c<`0c<c<0`2IVIT00`1VIVH0<c<c0?ooo`08
0>3Oh`@000000`3Pgn<3000000<0h=oS0P000000103Pgn<000000>3Oh`00
00040>3Oh`<000000P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`00
00001@3Pgn<00`2U[;80oooo0?ooo`1F0?ooo`050:F//P3Pgn<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPH0h=oS00`0<c=V0<c<
o`2d]=X0VYZo0;BdfP2FU[`0WIc307AdVP2?SkD0M7BJ03<cIP3oool>0>3O
h`0303<cIP2IVL`0<c=V0080oooo3@3Pgn<00`2o_lD0h=oS0>3Oh`080>3O
h`0:03<c<`3oool0VIVI0<c<c01VIVH0VIVI03<c<`1VIVH0<c<c0?ooo`L0
h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`000000h=oS000000030>3Oh`03
0000003Pgn<000000080h=oS0P0000000`3Pgn<000000>3Oh`020>3Oh`07
0000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0
h=oS00D0h=oS00<0YJbb0?ooo`3oool0EP3oool01@2U[;80h=oS06IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh60>3Oh`0<03<cIP3<
c?l0UYJl0;BdfP2JV[l0];CJ08n?]@2FU[`0M7BJ08n?]@0c<fH0oooo3P3P
gn<0100c<fH0VIW<06IVV@0c<fH20?ooo``0h=oS00<0_ko50>3Oh`3Pgn<0
203Pgn<02P0c<c<0oooo09VIV@3<c<`0IVIV09VIV@0c<c<0IVIV03<c<`3o
ool<0>3Oh`030000003Pgn<0000000D0h=oS00L000000>3Oh`3Pgn<0h=oS
0000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<00`3Pgn<01@000000
h=oS0>3Oh`3Pgn<0000000L0h=oS00<0YJbb0?ooo`3oool0EP3oool01@2U
[;80h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh6
0>3Oh`0<03<cIP3<c?l0WIc309JF_02d]=X0VYZo0;BdfP2?SkD0UYJl07Ad
VP0c<fH0oooo3P3Pgn<01@0c<fH0VIW<06IVV@1VIYT0<c=V0080oooo2`3P
gn<00`2o_lD0h=oS0>3Oh`080>3Oh`0:03<c<`3oool0VIVI0<c<c01VIVH0
VIVI03<c<`1VIVH0<c<c0?ooo`X0h=oS0P0000020>3Oh`D000000P3Pgn<4
000000030>3Oh`000000h=oS0080h=oS00<000000>3Oh`3Pgn<00`3Pgn<0
1@000000h=oS0>3Oh`3Pgn<0000000L0h=oS00<0YJbb0?ooo`3oool0EP3o
ool01@2U[;80h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh60>3Oh`0<03<cIP3<c?l0OGfS0:NWc@2FU[`0];CJ09fL``2_[mD0
QhJ/09JF_00c<fH0oooo3P3Pgn<00`0c<fH0VIW<06IVV@0206IVV@0303<c
IP3oool0oooo00X0h=oS00<0_ko50>3Oh`3Pgn<0203Pgn<02P0c<c<0oooo
09VIV@3<c<`0IVIV09VIV@0c<c<0IVIV03<c<`3oool80>3Oh`800000103P
gn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<010000000
h=oS0000000000020>3Oh`060000003Pgn<0h=oS0>3Oh`000000h=oS0P00
00020>3Oh`030000003Pgn<0h=oS00D0h=oS00<0YJbb0?ooo`3oool0EP3o
ool01@2U[;80h=oS06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWh60>3Oh`0<03<cIP3<c?l0Shne07emX`2WYld0VYZo0;6ae`2MW<<0
[joE08N6[00c<fH0oooo3P3Pgn<00`0c<fH0VIW<06IVV@0306IVV@0303<c
IP3Pgn<0h=oS00T0h=oS00<0_ko50>3Oh`3Pgn<0203Pgn<02P0c<c<0oooo
09VIV@3<c<`0IVIV09VIV@0c<c<0IVIV03<c<`3oool70>3Oh`030000003P
gn<0h=oS00D0h=oS0`0000030>3Oh`<000000P3Pgn<00`000000h=oS0000
00020>3Oh`<000000P3Pgn<010000000h=oS0000000000020>3Oh`030000
003Pgn<0h=oS00<0h=oS00<0YJbb0?ooo`3oool0EP3oool01@2U[;80h=oS
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh60>3Oh`0<
03<cIP3<c?l0M7BJ08n?]@1mOJ<0[joE09ZJ_`2d]=X0WIc30:n_e@0c<fH0
oooo3P3Pgn<00`0c<fH0VIW<06IVV@0206IVV@0303<cIP3Pgn<0h=oS00X0
h=oS00<0_ko50>3Oh`3Pgn<0203Pgn<02P0c<c<0oooo09VIV@3<c<`0IVIV
09VIV@0c<c<0IVIV03<c<`3oool70>3Oh`030000003Pgn<0h=oS0080h=oS
00<000000>3Oh`3Pgn<05@3Pgn<00`000000h=oS0>3Oh`090>3Oh`030:F/
/P3oool0oooo05H0oooo00D0YJbb0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn1P3Pgn<0300c<fH0c<co08n?]@1dM9X0Shne
08N6[02_[mD0VYZo0;BdfP2MW<<0<c=V0?ooo`h0h=oS00D0<c=V09VIc01V
IYT0IVJI03<cIP0=0>3Oh`030;noa@3Pgn<0h=oS00P0h=oS00@0<c<c0?oo
o`3<c<`0c<c<0`2IVIT0101VIVH0<c<c0?ooo`3oool70>3Oh`@00000603P
gn<00`000000h=oS0>3Oh`090>3Oh`030:F//P3oool0oooo05H0oooo00D0
YJbb0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
1P3Pgn<0300c<fH0c<co07AdVP2?SkD0M7BJ096A]`27QZ`0/K7G09fL``2d
]=X0<c=V0?ooo`h0h=oS00@0<c=V09VIc01VIYT0<c=V3P3Pgn<00`2o_lD0
h=oS0>3Oh`070>3Oh`/0<c<c00<0oooo0>3Oh`3Pgn<0;@3Pgn<00`2U[;80
oooo0?ooo`1F0?ooo`050:F//P3Pgn<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOPH0h=oS00<0<c=V0<c<o`3<c?l01`3<c?l00`1V
IYT0oooo0>3Oh`0=0>3Oh`0303<cIP2IVL`0<c=V00l0h=oS00<0_ko50>3O
h`3Pgn<01`3Pgn<00`0c<c<0c<c<0<c<c0020<c<c0@0VIVI00<0IVIV03<c
<`3oool0;`3Pgn<00`2U[;80oooo0?ooo`1F0?ooo`050:F//P3Pgn<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOPH0h=oS2`0c<fH?
0>3Oh`0303<cIP1VIYT0h=oS00l0h=oS00<0_ko50>3Oh`3Pgn<01`3Pgn<;
03<c<c00h=oS00<0YJbb0?ooo`3oool0EP3oool01@2U[;80h=oS06IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhP0>3Oh`0303<cIP3P
gn<0h=oS00l0h=oS00<0_ko50>3Oh`3Pgn<02`3Pgn<303<c<c@0h=oS00<0
YJbb0?ooo`3oool0EP3oool01@2U[;80h=oS06IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWhb0>3Oh`030;noa@3Pgn<0h=oS0480h=oS
00<0YJbb0?ooo`3oool0EP3oool01@2U[;80h=oS06IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWhb0>3Oh`030;noa@3Pgn<0h=oS0480
h=oS00<0YJbb0?ooo`3oool0EP3oool01@2U[;80h=oS06IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWig0>3Oh`030:F//P3oool0oooo
05H0oooo00D0YJbb0>3Oh`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVInM`3Pgn=J0:F//P040>3Oh`1VIWh0Z:Vk0?_lo@40IVIn0000
101VIWh0nocm0:RY^`1VIWkB0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
0`1VIWh0moOi09RHY`3D07MgTP40V9RW0@3gmoT106IVOP0000<0IVIn0?Og
n@2l_Ld0e@2l_Ld10?Ogn@40IVIn00000`1VIWh0moOi0>CSh`3E0>CSh`40
moOi0@1VIWh0000306IVOP3`lO@0oooo08h0oooo00<0i>?S09bT^@1[MHl0
0`1[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?oo
o`3Thn<0W:Bi101[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT^@3T
hn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W>T@0YSU40:LjA02W>T@90:Hi
A00309bT^@3/j^X0oooo00<0oooo0@3`lO@106IVOP0001H0IVIn0>;QhP3k
o?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0o?cm0?clo03lnod0o?cl0?ck
o03lo?`0nocl0?clo03ko?d0o?_l0?clo@3knod0nocl0P3lo?`0103lo?d0
o?cl0?_ko@3lo?dd0?cko3<0nocl3P3ko?d00`2LY;T0JgF?08F9/00@08F9
/00606]eS`2LY;T0nocm0?_lo@2LY;T0JgF?4@25RK001P1[MHl0W:Bi0?_l
o03kno`0W:Bi0:HiA140ZSaE00L0YSU409bT^@3ko?`0o?cl0?cko@3ko?d0
h^7R0040IVIn0000101VIWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kgn03gmoT0
moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3gmoT0103g
m_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0moOi03<0moOi<`3fmoT>
0?Ogn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi06]e
S`25RK0A09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=
0<IEG0090<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q0040
IVIn00001P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm100000000H0lO7d0?3b
m@3alO@0lO;d0?3bm03alOAW0?3am@h0l?7d00<0JgF?0;:ed02WZ<80402W
Z<801P2b]M00JgF?0?3am03`lO@0JgF?0;:ed140YjS200D0/[G@06]eS`3`
lOD0lO;d0:HiA0020<9BF`030<]DF@3=FEh0cEUN00/0cEUN00@0beAI0<9B
F`32DU/0YSU40P3`lO@00`3alO@0l?;d0=kMh@0106IVOP0000L0IVIn0=cK
h03Zjo00j^_`0>[/l03Yjnl000000080inOW0P3Ng]h20>OWi`030>NmQ03W
inL0inOW00<0inOW0P3_knl010000000j^_`0>[[l03Zjnl20>[[l0030>[[
k`3Zjo00j^_`0380j^_`<`3Zk?0>0>[[k`0406]eS`2f^M40[Jk60:f^aPP0
oooo00<0[Jk60:b^aP2][/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`04
06]eS`2f^M40[Jk60:f^aP`0oooo0P2][/H00`2/[/H0][WA06]eS`020>[[
l0050:HiA03=FEh0beAI0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK0<]DF@3=
FEh0YSU40>[[k`3Zjo000P3Zjnl10=cKh040IVIn0000101VIWh0fMWO0>?U
jP3Si>X20>?Uj`050000002<S8`0g]kN0>OWi`3Ng]h00P3WinL00`36H`00
inOW0>OWi`020>OWi`070>o_i`3_knl0kno_0000003Si>X0hnC[0>?UjP02
0>?TjP030>?Tj`3SiN/0hnG[0380hnG[<`3Si>X>0>?UjP0506]eS`2l_]@0
/[;:0;:bbP3oool01P1^KHl00`0U9CH0/[;:0;:bbP050;:bbP060;bne01[
MHl0hnGZ0>?UjP1[MHl0_;kD0P2b//X00`3oool09BDf02DU=P0902DU=P<0
/[;:00D0_;kD06]eS`3Si>/0hnC[0:HiA0020<eIGP040=1KH03DG5l0oooo
0?ooo`L0e5aO0P3oool02P3DG5l0d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0
hnCZ0>?Uj`3IfMl106IVOP0000<0IVIn0=OHgP3Lg^H00`3Lg^H01@000000
inOW0>OWi`3WinL0imK>0080inOW00D0cW/00>nD403WinL0imk60>n<4003
0>o_k`070000003Lg^H0g=kU0=cNi@3Lg^H0g=kU0=cNiP1e0=cNi@0506]e
S`2o`MH0^;W>0;RicP3oool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP06
0;o1eP1[MHl0g=kU0=cNi@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP07
0;RicP030?ooo`0U9CH0^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:Hi
A03=FEh0dEYN0=AMH@1C9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3A
FUh0cEUN0:HiA0020=cNi@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0
eMKM0=GHh03Ff>420=GHh0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4
003ocP00cV<00080gV/000D0kkF<0>o_k`3_knl0kno_000000020=GHh@04
0=GGh03Ff>00e]SQ0=KGhC@0e]OP<`3Ff>0>0=GHh@0506]eS`33aMT0_;gA
0;bmd@3oool01`0U9CH70;bmd@060<?5f@1[MHl0eMSQ0=GHh@1[MHl0`lGI
0P2l_M400`3oool09BDf0;bmd@070;bmd@030?ooo`0U9CH0_;gA0080_;gA
00D0`lGI06]eS`3Fen00eMOQ0:HiA0020=EMH0030=QPH@3IHF80AQhJ00<0
oooo0`3IHF830?ooo`0304HN6P3IHF80f61Q0080eEeP00H0YSU40=KHh03E
f>40eMOP0=GHh@3Ee]d106IVOP0000L0IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@
d]`0000000<0inOW00`0imk>0<I:003gcP00kjd00>ne003>J`00aUX00<I[
003NS4X0ijD00>oWcP0000030=3Bg0030<oBg03@d]`0cm;L03@0d=;L<`3?
d]d>0=3Bg00306]eS`38bM/0`lCF0100`lCF00H0b<WK06]eS`3@d]`0d=;L
06]eS`38bM/20<?4eP030?ooo`0U9CH0`lCF00L0`lCF00<0oooo02DU=P33
a=H00P33a=H01`38bM/0JgF?0<oBg03?d]`0YSU40=MOG`3IHF800`3LIFD0
1@167QX0oooo0?ooo`3oool0g6EU00<0oooo00P0AQhJ0=aUI@3LIFD0g6EU
0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?d]`10=;Dg@40IVIn0000701VIWh0
d=;K0<_=f03:cMT0blkH0<[=f0000000ilJ]0>O6S03gcQP0kkd00?O6003_
[@00ijd00>NU003FS000cV/00>O6003oeP00knoW0>o_k`000000blgH0<_=
f@3:cMT0blkH0<[=f03;cMPd0<_=fC<0blkI3P3;cMP00`1[MHl0blcN0<S:
f@080<S:f@030<S9f@38b]T0b<[I00<0b<[I00@0b<WI0<S:f@3;c=h0JgF?
0P3;cMP01P1[MHl0blcN0<S:f@38b]T0oooo02DU=PD0b<[I0140b<WI0<S:
f@38b]T0oooo02DU=P38b]T0b<WI0<S:f@3;c=h0JgF?0<_>f03:cMP0YSU4
0=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN6P3oool0oooo00<0oooo00X0
AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO0:HiA03:c]P0b/kI0P3;cMT1
0=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0030<G8e00600000036a/H0imkF
0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD00020?O60080moOg00@0
00000<G8e035am@0aLOD0`35amDd0<C7eC<0a<SD3P34am@00`1[MHl0d=7P
0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3o
ool09BDf0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]e
S`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo
04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD0@35amD10<o?fP40
IVIn0000101VIWh0c<kJ0<;4dP31a=420<74dP060000003WinL0inOW0>OW
i`3FQ000kkD00P3WY@00203FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL0
00000`31a=800`32a=40`LCB0<74dP0d0<74dC<0`LCB3P32a=800`1[MHl0
dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?d=d0
0`3oool09BDf0<o@g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M00L0dm?R
06]eS`32a=80`LCA0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/J@080>5Y
I@3KI6@0YSU40<74dP32a=40`LCA0<74dP3<c]X106IVOP0000@0IVIn0<[<
f02n`<l0_L3?0P2n`<h01@000000W9bL0>OWi`3Wg]H0eX`00080gY@000@0
eW/00<IS002m@P00kjD00P3g[@00203g]@00oli:0000002n`<h0_/3?0;k0
cP2n`<l0_L3>=@2n`<hc0;g0cPh0_/3>00<0JgF?0=KFi03Cdn00403Cdn00
1P3Fe^@0JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3oool0
203oool02`0U9CH0dm?P0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:HiA03P
IVD0hFYZ00@0hfa/0`3oool010167QX0oooo0?ooo`3oool40>=/K0040>5Z
JP3PIVD0YSU40;g0c`80_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0bL[H
0;Jhb02i_</0^[c;0;Zlc00000000P3_knl04`3FW000eX`00=jD003FQ000
kjD00=j<002mFP00eW<00>nL003gknL0moOg0?ooo`000000^Kc<0;Zkc02i
_</0^[c;0;Vlc02i_</0=02i_<`c0;Zlc0h0^[c;00<0JgF?0=SHi@3Cdn40
403Cdn401P3Hf>D0JgF?0;Zlb`2j_</0JgF?0=SHi@80dm?Q00<0oooo06i]
S`1^KHl0201^KHl03P0U9CH0dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<
0:HiA03PJFP0hFe/0>AaK@3TLFl0i71^0`3oool00`167QX0i71^04HN6P03
0?ooo`80i71^00T0i75]0>5]K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039
b]P00@1VIWh0000906IVOP37bML0];K70;Jhb02f^<T0][W900000024Q8@0
inON0080kno_00L0aV/00?O6003_]@00ki`00=j<003>J`00ii`000<0moOg
00D000000;Jib@2g^<T0][W90;Nib@020;JhbC@0]kS9<`2f^<T>0;Nhb@04
06]eS`3Fe^@0f=SU0=SHiP<0f=SU1@3Hf>H30=SHi@80f=SV0P3Hf>D02@3F
e^@0JgF?0;Nhb@2g^<T0JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]S`0=02DU
=P3Hf>H0f=SU0=SHi@3Fe^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3TM6l0ig5_
0>AdK`030?ooo`0504HN6P3TM6l0i7A_0>AdK`167QX00`3oool02P3TM6l0
ig5_0>AdK`3TKVd0YSU40;Jib@2f^<T0][W90;Bfa`37bML106IVOP0000<0
IVIn0<K8e`2d]/L00`2d]/L00`000000kno_0>o_k`020>o_k`0;0>N]003g
aPP0ijD00>ND003WS000knOF0=jD>@3_e[D0ooOg0?ooo`000000N`2d]/L0
1@1[MHl0eMGS0=cKi`3LfnL0gM_W00h0g=_W00H0eMGS06]eS`2d]/L0];K7
06]eS`3EeN<20=cKi`030=gKi`0U9CH09BDf00T09BDf0`3LfnL02@3EeN<0
JgF?0;Bfa`2d]/L0YSU40>McK`3WMG80jWIc0>YhMP020?ooo`0304HN6P3Y
OWP0jGih00<0jGih00P0AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80ig=_0:Hi
A0@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L01P000000
S8b<0>o_k`3_knl0ilik0>o_k`80moOg00P0ii@00?OWcP3gmoL0moOg0>oW
eP3gmoL0oooo000007/0];K700<0JgF?0=GDh`3PgnX0403PgnX01P3Ee><0
JgF?0;Bfa`2d]/L0JgF?0=GDha40h=oZ00T0eMCS06]eS`2d]/L0];K70:Hi
A03ZNG<0jGah0>n1NP3bRH400P167QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<
0>fGRP3[V8/00P167QX01@3bRH40kh5j0>UlN03ZNG<0YSU400@0];K70@36
b=L106IVOP0000<0IVIn0<K8e`2a/lP00`2a/lP01P000000kno_0>o_k`3_
knl0moO_0>o_k`80moOg00<0mnO60?Ogm`3oool00`3gmoL00`3oool00000
0;6cb01j0;6cb00306]eS`3]jo<0jNSa0100jNSa00H0kN_c06]eS`2a/lP0
/K?806]eS`3]jo<A0>WXl@0I0>g[l`1[MHl0/K?80;6cb02V>D@0lH1e0?24
O03eS8@0mif>0?:[UP3a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK
0>beW03bZiH0mif>0?F<Q03`Q7`0lH1e0:HiA0040;6cb040a/SG0@1VIWh0
000306IVOP36b=L0^;O?00<0[jk700D000000:f][@3gmnl0moOg0>o_k`06
0?Ogm`80ooOg0P3oool00`000000[jk70:n^a`1i0:n^a`0306]eS`3BdN<0
l_7g0100l_7g00H0d]7S06]eS`2_[/L0[jk706]eS`3BdN<A0?;am`060=;A
h`1[MHl0[jk70:n^a`2V>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0m8Ym0:Hi
A02_[/L00P2_[/L10;Rgc`40a/SG0@1VIWh0000306IVOP30`M40alOD08h0
[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:82
0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR
0P2/Zl@01`2AV:X0YSU40?nOS@3n_j@0n]bg0?[[]`3jjKH00P3ijKH0103j
jKH0nNVf0?WY]P3jjKH20?WY]P060?[[]`3jg;L0o[nT0?nOS@2V>D@0TIRZ
0`2/Zl@10<O7e040`<7A0@1VIWh0000406IVOP30`M40d];O0;FdbHh0Y:>n
00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<
XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80YSU4
0:HiA00?0:HiA00708B<XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31d@0106IV
OP0000H0IVIn0:RW_`3Vi^d0d];P0;blc`2a/<C>0:RW_`050;6`a02l_<l0
d];P0>KVk@2XYkl00@1VIWh0000705QGJ027Qi/0emSR0?clo03ThnP0d=3P
0<[:fP3<0;blc`060<[:fP3@d>00i>?X0?clo03Gf>80QhNK0@1HEfP00008
05QGJ01VIWh0UIB[0=OHhP3lo?`0l_7c0>c[kP3Qh^_:0=OHhP070>7Rj`3/
jnh0l_7c0?clo03Gf>80UIB[06IVOP0105QGJ0000P1HEfP00`1VIWh0UIB[
0=7AgP020?clo<`0oooo0P3lo?`00`3AdMh0UIB[06IVOP0205QGJ0000`1H
EfP206IVOP0308R7W@2EU:/0Z:No0</0Z:No00@0UIB[08R7W@1VIWh0IVIn
0`1HEfP000D0F5MXd01VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  Evaluatable->False,
  ImageSize->{218, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"ToolBar"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]=",
  CellTags->"ToolBar"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"PopupMenu\"]", "ObjectName",
  CellTags->"PopupMenu"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"PopupMenu"],

Cell[BoxData[
    RowBox[{
      RowBox[{"ref", "  ", "=", " ", 
        RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
          RowBox[{
            StyleBox["Widget",
              "Output"], "[", 
            RowBox[{"\"\<Frame\>\"", ",", 
              RowBox[{"{", "\[IndentingNewLine]", 
                RowBox[{
                  RowBox[{
                    StyleBox["Widget",
                      "Output"], 
                    "[", \("\<TextArea\>", \ {"\<columns\>" \[Rule] 
                        30, \ "\<rows\>" \[Rule] 5}, \ 
                    Name -> "\<messageArea\>"\), "]"}], ",", 
                  "\[IndentingNewLine]", "\[IndentingNewLine]", 
                  RowBox[{
                    StyleBox["Widget",
                      "Output"], "[", 
                    RowBox[{"\"\<PopupMenu\>\"", ",", 
                      RowBox[{"{", "\[IndentingNewLine]", 
                        RowBox[{
                          RowBox[{
                            StyleBox["Widget",
                              "Output"], 
                            "[", \("\<MenuItem\>", {"\<text\>" -> "\<Item \
1\>"}\), "]"}], ",", "\[IndentingNewLine]", 
                          RowBox[{
                            StyleBox["Widget",
                              "Output"], 
                            "[", \("\<MenuItem\>", {"\<text\>" -> "\<Item \
2\>"}\), "]"}], ",", "\[IndentingNewLine]", 
                          RowBox[{
                            StyleBox["Widget",
                              "Output"], "[", "\"\<MenuSeparator\>\"", "]"}], 
                          ",", "\[IndentingNewLine]", 
                          RowBox[{
                            StyleBox["Widget",
                              "Output"], 
                            "[", \("\<MenuItem\>", {"\<text\>" -> "\<Item \
3\>"}\), "]"}]}], "\[IndentingNewLine]", "}"}], 
                      ",", \(Name \[Rule] "\<popupMenu\>"\)}], "]"}], ",", 
                  "\[IndentingNewLine]", 
                  "\[IndentingNewLine]", \(BindEvent[{"\<messageArea\>", \
"\<mousePressed\>"}, \[IndentingNewLine]Script[\ \[IndentingNewLine]\ \(If[
                          TrueQ[
                            PropertyValue[{"\<#\>", "\<popupTrigger\>"}]], \
\[IndentingNewLine]InvokeMethod[{"\<popupMenu\>", "\<show\>"}, 
                            PropertyValue[{"\<#\>", "\<component\>"}], 
                            PropertyValue[{"\<#\>", "\<x\>"}], 
                            PropertyValue[{"\<#\>", "\<y\>"}]]];\)\
\[IndentingNewLine]]]\), ",", 
                  "\[IndentingNewLine]", \(BindEvent[{"\<messageArea\>", \
"\<mouseReleased\>"}, \[IndentingNewLine]Script[\[IndentingNewLine]\(If[
                          TrueQ[PropertyValue[{"\<#\>", \
"\<popupTrigger\>"}]], InvokeMethod[{"\<popupMenu\>", "\<show\>"}, 
                            PropertyValue[{"\<#\>", "\<component\>"}], 
                            PropertyValue[{"\<#\>", "\<x\>"}], 
                            PropertyValue[{"\<#\>", "\<y\>"}]]];\)\
\[IndentingNewLine]]]\)}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
                "}"}]}], "]"}], "\[IndentingNewLine]", "]"}]}], 
      ";"}]], "Input",
  CellLabel->"In[14]:=",
  CellTags->"PopupMenu"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"PopupMenu"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003J0000NR000`400?l0
0000o`00003ofP1VIWh0000306IVOP3ko?d0nocm0=H0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0=D0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
e01VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVO]80oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80oooo
B`1aKfAE0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWhb0?ooo`030?7_hP2MWJ40WIfQ04L0WIfQ00<0LFmT0?ooo`3oool0
D`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
<P3oool00`3akn80oooo0>3Oh`160>3Oh`0309fMX@1aKf@0oooo05@0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80oooo
00<0lNoR0?ooo`3Pgn<0A@3oool00`3Pgn<0WIfQ075_I01E0?ooo`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhb0?ooo`030?7_
hP3oool0h=oS04D0oooo00<0h=oS09fMX@1aKf@0E@3oool00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80oooo
0>3Oh`150?ooo`030>3Oh`2MWJ40LFmT05D0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80oooo00<0lNoR0?ooo`3Pgn<0
A@3oool00`3Pgn<0WIfQ075_I01E0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWhb0?ooo`030?7_hP3oool0h=oS04D0oooo
00<0h=oS09fMX@1aKf@0E@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80oooo0>3Oh`150?ooo`030>3O
h`2MWJ40LFmT05D0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOS80oooo00<0lNoR0?ooo`3Pgn<04`3oool300000080oooo
0P0000020?ooo`<000000P3oool010000000oooo0?ooo`0000020?ooo`03
0000003oool0oooo00<0oooo0`00000E0?ooo`030>3Oh`2MWJ40LFmT05D0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80
oooo00<0lNoR0?ooo`3Pgn<0503oool010000000oooo0?ooo`0000030?oo
o`070000003oool0oooo0?ooo`000000oooo000000020?ooo`040000003o
ool0oooo000000@0oooo00D000000?ooo`3oool0oooo0000000D0?ooo`03
0>3Oh`2MWJ40LFmT05D0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOS80oooo00<0lNoR0?ooo`3Pgn<0503oool010000000
oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo0180oooo00<0h=oS09fMX@1aKf@0E@3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80oooo0>3Oh`0D
0?ooo`040000003oool0oooo000000<0oooo1@0000001@3oool000000?oo
o`3oool000000080oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`0B0?ooo`030>3Oh`2MWJ40LFmT05D0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80oooo00<0lNoR0?ooo`3Pgn<0
503oool010000000oooo0?ooo`0000030?ooo`070000003oool0oooo0?oo
o`000000oooo000000020?ooo`040000003oool0oooo000000H0oooo0P00
000E0?ooo`030>3Oh`2MWJ40LFmT05D0oooo00<0IVIn0:RY^`3ko?d00@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOS80oooo00<0lNoR0?ooo`3Pgn<0503o
ool00`000000oooo0?ooo`0300000080oooo0`0000020?ooo`<0000000<0
oooo0000000000002@3oool00`000000oooo0?ooo`0B0?ooo`030>3Oh`2M
WJ40LFmT05D0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOS80oooo00<0lNoR0?ooo`3Pgn<0503oool010000000oooo0?oo
o`00000D0?ooo`050000003oool0oooo0?ooo`000000503oool00`3Pgn<0
WIfQ075_I01E0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWhb0?ooo`030?7_hP3oool0h=oS01<0oooo0`0000000`3oool0
00000?ooo`0D0?ooo`<000005@3oool00`3Pgn<0WIfQ075_I01E0?ooo`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhb0?ooo`03
0?7_hP3oool0h=oS04D0oooo00<0h=oS09fMX@1aKf@0E@3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80
oooo0>3Oh`150?ooo`030>3Oh`2MWJ40LFmT05D0oooo00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80oooo00<0lNoR0?ooo`3P
gn<0A@3oool00`3Pgn<0WIfQ075_I01E0?ooo`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWhb0?ooo`030?7_hP3oool0h=oS04D0
oooo00<0h=oS09fMX@1aKf@0E@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80oooo0>3Oh`150?ooo`03
0>3Oh`2MWJ40LFmT05D0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOS80oooo00<0lNoR0?ooo`3Pgn<0A@3oool00`3Pgn<0
WIfQ075_I01E0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWhb0?ooo`030?7_hP3oool0h=oS04D0WIfQ00<0h=oS09fMX@1a
Kf@0E@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn<P3oool00`3akn80oooo0>3Oh`150?ooo`030>3Oh`2MWJ40LFmT05D0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80
oooo00<0lNoR0?ooo`3Pgn<0A@3oool00`3Pgn<0WIfQ075_I01E0?ooo`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhb0?ooo`03
0?7_hP3oool0h=oS04D0oooo00<0h=oS09fMX@1aKf@0E@3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80
oooo0>3Oh`150?ooo`030>3Oh`2MWJ40LFmT05D0oooo00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80oooo00<0lNoR0?ooo`3P
gn<0A@3oool00`3Pgn<0WIfQ075_I01E0?ooo`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWhb0?ooo`030?7_hP3oool0h=oS04D0
oooo00<0h=oS09fMX@1aKf@0E@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80oooo0>3Oh`0C0?ooo`<0
00000P3oool200000080oooo0`0000020?ooo`040000003oool0oooo0000
0080oooo00<000000?ooo`3oool00P3oool5000001@0oooo00<0h=oS09fM
X@1aKf@0E@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn<P3oool00`3akn80oooo0>3Oh`0D0?ooo`040000003oool0oooo
000000<0oooo00L000000?ooo`3oool0oooo0000003oool000000080oooo
00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`0F0?ooo`03
0>3Oh`2MWJ40LFmT05D0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOS80oooo00<0lNoR0?ooo`3Pgn<0503oool010000000
oooo0?ooo`0000030?ooo`030000003oool0oooo00<0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo01D0oooo00<0h=oS09fMX@1aKf@0E@3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80oooo0>3Oh`0D
0?ooo`040000003oool0oooo000000<0oooo1@0000001@3oool000000?oo
o`3oool000000080oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`0D0?ooo`030>3Oh`2MWJ40LFmT05D0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80oooo00<0lNoR0?ooo`3Pgn<0
503oool010000000oooo0?ooo`0000030?ooo`070000003oool0oooo0?oo
o`000000oooo000000020?ooo`040000003oool0oooo000000L0oooo00<0
00000?ooo`3oool04`3oool00`3Pgn<0WIfQ075_I01E0?ooo`0306IVOP2X
ZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhb0?ooo`030?7_hP3o
ool0h=oS01@0oooo00<000000?ooo`3oool00`0000020?ooo`<000000P3o
ool3000000030?ooo`000000000000T0oooo00<000000?ooo`3oool04P3o
ool00`3Pgn<0WIfQ075_I01E0?ooo`0306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWhb0?ooo`030?7_hP3oool0h=oS01@0oooo00@0
00000?ooo`3oool00000503oool01@000000oooo0?ooo`3oool0000001@0
oooo00<0h=oS09fMX@1aKf@0E@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80oooo0>3Oh`0C0?ooo`<0
000000<0oooo0000003oool0503oool3000001D0oooo00<0h=oS09fMX@1a
Kf@0E@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn<P3oool00`3akn80oooo0>3Oh`150?ooo`030>3Oh`2MWJ40LFmT05D0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80
oooo00<0lNoR0?ooo`3Pgn<0A@3oool00`3Pgn<0WIfQ075_I01E0?ooo`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhb0?ooo`03
0?7_hP3oool0h=oS04D0oooo00<0h=oS09fMX@1aKf@0E@3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80
oooo0>3Oh`150?ooo`030>3Oh`2MWJ40LFmT05D0oooo00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80oooo00<0lNoR0?ooo`3P
gn<0A@3oool00`3Pgn<0WIfQ075_I01E0?ooo`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWhb0?ooo`030?7_hP3oool0h=oS04D0
/[Bo00<0h=oS09fMX@1aKf@0E@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00@0IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80oooo0>3Oh`150;:d_`03
0>3Oh`2MWJ40LFmT05D0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOS80oooo00<0lNoR0?ooo`3Pgn<0A@2b];l00`3Pgn<0
WIfQ075_I01E0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWhb0?ooo`030?7_hP3oool0h=oS04D0/[Bo00<0h=oS09fMX@1a
Kf@0E@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn<P3oool00`3akn80oooo0>3Oh`150;:d_`030>3Oh`2MWJ40LFmT05D0
oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80
oooo00<0lNoR0?ooo`3Pgn<0A@2b];l00`3Pgn<0WIfQ075_I01E0?ooo`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhb0?ooo`03
0?7_hP3oool0h=oS01<0/[Bo0`0000020;:d_`8000000P2b];l300000080
/[Bo00@000000;:d_`2b];l000000P2b];l00`000000/[Bo0;:d_`030;:d
_`<000005@2b];l00`3Pgn<0WIfQ075_I01E0?ooo`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWhb0?ooo`030?7_hP3oool0h=oS
01@0/[Bo00@000000;:d_`2b];l000000`2b];l01`000000/[Bo0;:d_`2b
];l000000;:d_`0000000P2b];l010000000/[Bo0;:d_`0000060;:d_`03
0000002b];l0/[Bo01@0/[Bo00<0h=oS09fMX@1aKf@0E@3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80
oooo0>3Oh`0D0;:d_`040000002b];l0/[Bo000000<0/[Bo00<000000;:d
_`2b];l00`2b];l010000000/[Bo0;:d_`0000020;:d_`030000002b];l0
/[Bo00@0/[Bo00<000000;:d_`2b];l0502b];l00`3Pgn<0WIfQ075_I01E
0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhb
0?ooo`030?7_hP3oool0h=oS01@0/[Bo00@000000;:d_`2b];l000000`2b
];l5000000050;:d_`000000/[Bo0;:d_`0000000P2b];l00`000000/[Bo
0;:d_`040;:d_`030000002b];l0/[Bo01@0/[Bo00<0h=oS09fMX@1aKf@0
E@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
<P3oool00`3akn80oooo0>3Oh`0D0;:d_`040000002b];l0/[Bo000000<0
/[Bo00L000000;:d_`2b];l0/[Bo0000002b];l000000080/[Bo00@00000
0;:d_`2b];l000001P2b];l00`000000/[Bo0;:d_`0D0;:d_`030>3Oh`2M
WJ40LFmT05D0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOS80oooo00<0lNoR0?ooo`3Pgn<0502b];l00`000000/[Bo0;:d
_`0300000080/[Bo0`0000020;:d_`<0000000<0/[Bo0000000000001`2b
];l00`000000/[Bo0;:d_`0D0;:d_`030>3Oh`2MWJ40LFmT05D0oooo00<0
IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80oooo00<0
lNoR0?ooo`3Pgn<0502b];l010000000/[Bo0;:d_`00000E0;:d_`800000
5P2b];l00`3Pgn<0WIfQ075_I01E0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWhb0?ooo`030?7_hP3oool0h=oS01<0/[Bo
0`0000000`2b];l000000;:d_`0E0;:d_`030000002b];l0/[Bo01@0/[Bo
00<0h=oS09fMX@1aKf@0E@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80oooo0>3Oh`150;:d_`030>3O
h`2MWJ40LFmT05D0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOS80oooo00<0lNoR0?ooo`3Pgn<0A@2b];l00`3Pgn<0WIfQ
075_I01E0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWhb0?ooo`030?7_hP3oool0h=oS04D0/[Bo00<0h=oS09fMX@1aKf@0
E@3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
<P3oool00`3akn80oooo0>3Oh`150;:d_`030>3Oh`2MWJ40LFmT05D0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80oooo
00<0lNoR0?ooo`3Pgn<0A@2b];l00`3Pgn<0WIfQ075_I01E0?ooo`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhb0?ooo`030?7_
hP3oool0h=oS04H0h=oS00<0WIfQ075_I03oool0E03oool00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn<P3oool00`3akn80oooo
0?ooo`160?ooo`0309fMX@1aKf@0oooo05@0oooo00<0IVIn0:RY^`3ko?d0
0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOS80ooooBP3akn800`1aKf@0oooo
0?ooo`1C0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWkB0?ooo`0306IVOP2XZK/0nocm0040IVIn00000`1VIWh0moOi09RH
Y`3D07MgTP40V9RW0@3gmoT106IVOP0000<0IVIn0?Ogn@2l_Ld0e@2l_Ld1
0?Ogn@40IVIn00000`1VIWh0moOi0>CSh`3E0>CSh`40moOi0@1VIWh00003
06IVOP3`lO@0oooo08h0oooo00<0i>?S09bT^@1[MHl00`1[MHl0101/MY00
JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[
MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT^@3Thn<0oooo0?ooo`3/
j^X0W:Bi102V>D@0102W>T@0YSU40:LjA02W>T@90:HiA00309bT^@3/j^X0
oooo00<0oooo0@3`lO@106IVOP0001H0IVIn0>;QhP3ko?`0no_l0?_lo@3l
nod0no_m0?_lo@3ko?`0o?cm0?clo03lnod0o?cl0?cko03lo?`0nocl0?cl
o03ko?d0o?_l0?clo@3knod0nocl0P3lo?`0103lo?d0o?cl0?_ko@3lo?dd
0?cko3<0nocl3P3ko?d00`2LY;T0JgF?08F9/00@08F9/00606]eS`2LY;T0
nocm0?_lo@2LY;T0JgF?4@25RK001P1[MHl0W:Bi0?_lo03kno`0W:Bi0:Hi
A140ZSaE00L0YSU409bT^@3ko?`0o?cl0?cko@3ko?d0h^7R0040IVIn0000
101VIWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0
moOh0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3gmoT0103gm_P0m_Oh0?Kgn@3g
moT30?Kgn@030?Kgn03gmoT0moOi03<0moOi<`3fmoT>0?Ogn@0306]eS`25
RK00W9jn0100W9jn00H0QHV`06]eS`3gmoT0moOi06]eS`25RK0A09bN_P08
08F9/01[MHl0m_Oh0?Ogn02V>D@0ZSaE0<9BF`36E5X=0<IEG0090<IDFP32
DU/0ZSaE0:HiA03gmoP0moOi0?Ogn03gmoT0h>3Q0040IVIn00001P1VIWh0
g]gQ0?7am03alO@0l?7d0?3bm100000000H0lO7d0?3bm@3alO@0lO;d0?3b
m03alOAW0?3am@h0l?7d00<0JgF?0;:ed02WZ<80402WZ<801P2b]M00JgF?
0?3am03`lO@0JgF?0;:ed140YjS200D0/[G@06]eS`3`lOD0lO;d0:HiA002
0<9BF`030<]DF@3=FEh0cEUN00/0cEUN00@0beAI0<9BF`32DU/0YSU40P3`
lO@00`3alO@0l?;d0=kMh@0106IVOP0000L0IVIn0=cKh03Zjo00j^_`0>[/
l03Yjnl000000080inOW0P3Ng]h20>OWi`030>NmQ03WinL0inOW00<0inOW
0P3_knl010000000j^_`0>[[l03Zjnl20>[[l0030>[[k`3Zjo00j^_`0380
j^_`<`3Zk?0>0>[[k`0406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk60:b^
aP2][/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`0406]eS`2f^M40[Jk6
0:f^aP`0oooo0P2][/H00`2/[/H0][WA06]eS`020>[[l0050:HiA03=FEh0
beAI0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK0<]DF@3=FEh0YSU40>[[k`3Z
jo000P3Zjnl10=cKh040IVIn0000101VIWh0fMWO0>?UjP3Si>X20>?Uj`05
0000002<S8`0g]kN0>OWi`3Ng]h00P3WinL00`36H`00inOW0>OWi`020>OW
i`070>o_i`3_knl0kno_0000003Si>X0hnC[0>?UjP020>?TjP030>?Tj`3S
iN/0hnG[0380hnG[<`3Si>X>0>?UjP0506]eS`2l_]@0/[;:0;:bbP3oool0
1P1^KHl00`0U9CH0/[;:0;:bbP050;:bbP060;bne01[MHl0hnGZ0>?UjP1[
MHl0_;kD0P2b//X00`3oool09BDf02DU=P0902DU=P<0/[;:00D0_;kD06]e
S`3Si>/0hnC[0:HiA0020<eIGP040=1KH03DG5l0oooo0?ooo`L0e5aO0P3o
ool02P3DG5l0d5]P0<eIGP3=FEh0YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl1
06IVOP0000<0IVIn0=OHgP3Lg^H00`3Lg^H01@000000inOW0>OWi`3WinL0
imK>0080inOW00D0cW/00>nD403WinL0imk60>n<40030>o_k`070000003L
g^H0g=kU0=cNi@3Lg^H0g=kU0=cNiP1e0=cNi@0506]eS`2o`MH0^;W>0;Ri
cP3oool01P1^KHl00`0U9CH0^;W>0;RicP050;RicP060;o1eP1[MHl0g=kU
0=cNi@1[MHl0_l7F0P2h^Lh00`3oool09BDf0;RicP070;RicP030?ooo`0U
9CH0^;W>0080^;W>00T0_l7F06]eS`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AM
H@1C9B000`3oool50=IOH`<0oooo00D0DbDP0=AMH@3AFUh0cEUN0:HiA002
0=cNi@030=cNiP3Lg^D0emSN0040IVIn0000101VIWh0eMKM0=GHh03Ff>42
0=GHh0090000002<S8`0inOW0>OWi`3W]H@0eUX00=J4003ocP00cV<00080
gV/000D0kkF<0>o_k`3_knl0kno_000000020=GHh@040=GGh03Ff>00e]SQ
0=KGhC@0e]OP<`3Ff>0>0=GHh@0506]eS`33aMT0_;gA0;bmd@3oool01`0U
9CH70;bmd@060<?5f@1[MHl0eMSQ0=GHh@1[MHl0`lGI0P2l_M400`3oool0
9BDf0;bmd@070;bmd@030?ooo`0U9CH0_;gA0080_;gA00D0`lGI06]eS`3F
en00eMOQ0:HiA0020=EMH0030=QPH@3IHF80AQhJ00<0oooo0`3IHF830?oo
o`0304HN6P3IHF80f61Q0080eEeP00H0YSU40=KHh03Ef>40eMOP0=GHh@3E
e]d106IVOP0000L0IVIn0=;Dg@3?d]`0d=;L0=3Bg@3@d]`0000000<0inOW
00`0imk>0<I:003gcP00kjd00>ne003>J`00aUX00<I[003NS4X0ijD00>oW
cP0000030=3Bg0030<oBg03@d]`0cm;L03@0d=;L<`3?d]d>0=3Bg00306]e
S`38bM/0`lCF0100`lCF00H0b<WK06]eS`3@d]`0d=;L06]eS`38bM/20<?4
eP030?ooo`0U9CH0`lCF00L0`lCF00<0oooo02DU=P33a=H00P33a=H01`38
bM/0JgF?0<oBg03?d]`0YSU40=MOG`3IHF800`3LIFD01@167QX0oooo0?oo
o`3oool0g6EU00<0oooo00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0YSU4
0=3Bg@80d=;L0@3?d]`10=;Dg@40IVIn0000701VIWh0d=;K0<_=f03:cMT0
blkH0<[=f0000000ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU003F
S000cV/00>O6003oeP00knoW0>o_k`000000blgH0<_=f@3:cMT0blkH0<[=
f03;cMPd0<_=fC<0blkI3P3;cMP00`1[MHl0blcN0<S:f@080<S:f@030<S9
f@38b]T0b<[I00<0b<[I00@0b<WI0<S:f@3;c=h0JgF?0P3;cMP01P1[MHl0
blcN0<S:f@38b]T0oooo02DU=PD0b<[I0140b<WI0<S:f@38b]T0oooo02DU
=P38b]T0b<WI0<S:f@3;c=h0JgF?0<_>f03:cMP0YSU40=MOG`3KI6@0h6MU
0>1VI@020=iWI`0304HN6P3oool0oooo00<0oooo00X0AQhJ0=iWI`3NIfL0
h6IU0>1WI@3KI6@0eemO0:HiA03:c]P0b/kI0P3;cMT10=3Bf`40IVIn0000
0`1VIWh0cloJ0<G8e0030<G8e00600000036a/H0imkF0<ik003W[@00kkD0
0P3WY@000`3FU000cW<00=JD00020?O60080moOg00@000000<G8e035am@0
aLOD0`35amDd0<C7eC<0a<SD3P34am@00`1[MHl0d=7P0<_;g00@0<_;g006
0=3Ah01[MHl0a<OD0<C7e01[MHl0d=7P0P3;bm`00`3oool09BDf0<_;g007
0<_;g0030?ooo`0U9CH0bl_L0080bl_L00L0d=7P06]eS`35am@0a<OD0:Hi
A03KI6@0gfET00D0h6YX00D0AQhJ0?ooo`3oool0oooo04HN6P050>1ZJ004
0=mUI03KI6@0YSU40<C8e@80a<SD0@35amD10<o?fP40IVIn0000101VIWh0
c<kJ0<;4dP31a=420<74dP060000003WinL0inOW0>OWi`3FQ000kkD00P3W
Y@00203FQ000cV/00>N]003g]@00mkd00>o_k`3gmoL000000`31a=800`32
a=40`LCB0<74dP0d0<74dC<0`LCB3P32a=800`1[MHl0dm?R0<o@g@0@0<o@
g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?d=d00`3oool09BDf0<o@
g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M00L0dm?R06]eS`32a=80`LCA
0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/J@080>5YI@3KI6@0YSU40<74
dP32a=40`LCA0<74dP3<c]X106IVOP0000@0IVIn0<[<f02n`<l0_L3?0P2n
`<h01@000000W9bL0>OWi`3Wg]H0eX`00080gY@000@0eW/00<IS002m@P00
kjD00P3g[@00203g]@00oli:0000002n`<h0_/3?0;k0cP2n`<l0_L3>=@2n
`<hc0;g0cPh0_/3>00<0JgF?0=KFi03Cdn00403Cdn001P3Fe^@0JgF?0;k0
cP2n`<h0JgF?0=KFi080dm?P00<0oooo02DU=P3oool0203oool02`0U9CH0
dm?P0=?Ch03Cdn00e]KT06]eS`2n`<l0_/3>0:HiA03PIVD0hFYZ00@0hfa/
0`3oool010167QX0oooo0?ooo`3oool40>=/K0040>5ZJP3PIVD0YSU40;g0
c`80_/3?0@2n`<h10<[<f040IVIn00001`1VIWh0bL[H0;Jhb02i_</0^[c;
0;Zlc00000000P3_knl04`3FW000eX`00=jD003FQ000kjD00=j<002mFP00
eW<00>nL003gknL0moOg0?ooo`000000^Kc<0;Zkc02i_</0^[c;0;Vlc02i
_</0=02i_<`c0;Zlc0h0^[c;00<0JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0
JgF?0;Zlb`2j_</0JgF?0=SHi@80dm?Q00<0oooo06i]S`1^KHl0201^KHl0
3P0U9CH0dm?Q0=?Ch@3Cdn40f=SU06]eS`2j_</0^[c<0:HiA03PJFP0hFe/
0>AaK@3TLFl0i71^0`3oool00`167QX0i71^04HN6P030?ooo`80i71^00T0
i75]0>5]K03PJFP0YSU40;Zlc02j^l`0^Kc;0;Jhb039b]P00@1VIWh00009
06IVOP37bML0];K70;Jhb02f^<T0][W900000024Q8@0inON0080kno_00L0
aV/00?O6003_]@00ki`00=j<003>J`00ii`000<0moOg00D000000;Jib@2g
^<T0][W90;Nib@020;JhbC@0]kS9<`2f^<T>0;Nhb@0406]eS`3Fe^@0f=SU
0=SHiP<0f=SU1@3Hf>H30=SHi@80f=SV0P3Hf>D02@3Fe^@0JgF?0;Nhb@2g
^<T0JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]S`0=02DU=P3Hf>H0f=SU0=SH
i@3Fe^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3TM6l0ig5_0>AdK`030?ooo`05
04HN6P3TM6l0i7A_0>AdK`167QX00`3oool02P3TM6l0ig5_0>AdK`3TKVd0
YSU40;Jib@2f^<T0][W90;Bfa`37bML106IVOP0000<0IVIn0<K8e`2d]/L0
0`2d]/L00`000000kno_0>o_k`020>o_k`0;0>N]003gaPP0ijD00>ND003W
S000knOF0=jD>@3_e[D0ooOg0?ooo`000000N`2d]/L01@1[MHl0eMGS0=cK
i`3LfnL0gM_W00h0g=_W00H0eMGS06]eS`2d]/L0];K706]eS`3EeN<20=cK
i`030=gKi`0U9CH09BDf00T09BDf0`3LfnL02@3EeN<0JgF?0;Bfa`2d]/L0
YSU40>McK`3WMG80jWIc0>YhMP020?ooo`0304HN6P3YOWP0jGih00<0jGih
00P0AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80ig=_0:HiA0@0];K70@36b=L1
06IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L01P000000S8b<0>o_k`3_knl0
ilik0>o_k`80moOg00P0ii@00?OWcP3gmoL0moOg0>oWeP3gmoL0oooo0000
07/0];K700<0JgF?0=GDh`3PgnX0403PgnX01P3Ee><0JgF?0;Bfa`2d]/L0
JgF?0=GDha40h=oZ00T0eMCS06]eS`2d]/L0];K70:HiA03ZNG<0jGah0>n1
NP3bRH400P167QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<0>fGRP3[V8/00P16
7QX01@3bRH40kh5j0>UlN03ZNG<0YSU400@0];K70@36b=L106IVOP0000<0
IVIn0<K8e`2a/lP00`2a/lP01P000000kno_0>o_k`3_knl0moO_0>o_k`80
moOg00<0mnO60?Ogm`3oool00`3gmoL00`3oool000000;6cb01j0;6cb003
06]eS`3]jo<0jNSa0100jNSa00H0kN_c06]eS`2a/lP0/K?806]eS`3]jo<A
0>WXl@0I0>g[l`1[MHl0/K?80;6cb02V>D@0lH1e0?24O03eS8@0mif>0?:[
UP3a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03bZiH0mif>
0?F<Q03`Q7`0lH1e0:HiA0040;6cb040a/SG0@1VIWh0000306IVOP36b=L0
^;O?00<0[jk700D000000:f][@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3o
ool00`000000[jk70:n^a`1i0:n^a`0306]eS`3BdN<0l_7g0100l_7g00H0
d]7S06]eS`2_[/L0[jk706]eS`3BdN<A0?;am`060=;Ah`1[MHl0[jk70:n^
a`2V>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0m8Ym0:HiA02_[/L00P2_[/L1
0;Rgc`40a/SG0@1VIWh0000306IVOP30`M40alOD08h0[:_400@0Q8bR06]e
S`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a00408B<XP1[
MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01`2AV:X0
YSU40?nOS@3n_j@0n]bg0?[[]`3jjKH00P3ijKH0103jjKH0nNVf0?WY]P3j
jKH20?WY]P060?[[]`3jg;L0o[nT0?nOS@2V>D@0TIRZ0`2/Zl@10<O7e040
`<7A0@1VIWh0000406IVOP30`M40d];O0;FdbHh0Y:>n00<0Q8bR06]eS`1[
MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP1[MHl0JgF?00l0
JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80YSU40:HiA00?0:HiA007
08B<XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31d@0106IVOP0000H0IVIn0:RW
_`3Vi^d0d];P0;blc`2a/<C>0:RW_`050;6`a02l_<l0d];P0>KVk@2XYkl0
0@1VIWh0000705QGJ027Qi/0emSR0?clo03ThnP0d=3P0<[:fP3<0;blc`06
0<[:fP3@d>00i>?X0?clo03Gf>80QhNK0@1HEfP0000805QGJ01VIWh0UIB[
0=OHhP3lo?`0l_7c0>c[kP3Qh^_:0=OHhP070>7Rj`3/jnh0l_7c0?clo03G
f>80UIB[06IVOP0105QGJ0000P1HEfP00`1VIWh0UIB[0=7AgP020?clo<`0
oooo0P3lo?`00`3AdMh0UIB[06IVOP0205QGJ0000`1HEfP206IVOP0308R7
W@2EU:/0Z:No0</0Z:No00@0UIB[08R7W@1VIWh0IVIn0`1HEfP000D0F5MX
d01VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[15]:=",
  Evaluatable->False,
  ImageSize->{218, 122},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"PopupMenu"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[15]=",
  CellTags->"PopupMenu"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"Tree\"]", "ObjectName",
  CellTags->"Tree"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"Tree"],

Cell[BoxData[
    RowBox[{
      RowBox[{"ref", " ", "=", " ", 
        RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
          RowBox[{
            StyleBox["Widget",
              "Output"], "[", "\"\<Tree\>\"", "]"}], "\[IndentingNewLine]", 
          "]"}]}], ";"}]], "Input",
  CellLabel->"In[16]:=",
  CellTags->"Tree"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"Tree"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001k0000HR000`400?l0
0000o`00003oN`1VIWh0000306IVOP3ko?d0nocm07L0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk07H0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
M@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOW<0oooo
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQ@0oooo
401SHf=?0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWhD0?ooo`h0c/iS00<0U9AS06=SH`3oool0CP3oool00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@3oool707RH]@P0oooo
00<0c/iS0>o_k`3gkg/00P3gkg/00`3WgV/0mnmk0?O_N`040?O_N`040>ON
J`3gkg/0U9AS06=SH`D0oooo00@000000?ooo`3oool0oooo0`0000030?oo
o`<000000`3oool2000000030?ooo`000000oooo03D0oooo00<0IVIn0:RY
^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0oooo00@0N9Re0=;<
_`36_Zh0`[RX0P31^:L00`30]jH0`kZZ07RH]@070?ooo`040<k>H`3_knl0
mnmk0>ONJ`<0mnmk00@0imi[0?O_N`3gkg/0imi[0`3gkg/00`2DU6<0Hf=S
0?ooo`040?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`00
00000`3oool00`000000oooo000000020?ooo`800000=P3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn103oool02@1hV;D0
i>7I0=cHc`3HdlT000000=KAaP3Bc<00clRk07RH]@070?ooo`030<k>H`3_
knl0mnmk00/0mnmk00<0U9AS06=SH`3oool0103oool010000000oooo0?oo
o`0000030?ooo`030000003oool0000000<0oooo00<000000?ooo`000000
0`3oool00`000000oooo0?ooo`0d0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh40?ooo`0907RH]@3bl^h0l?3/0>g]i`00
0000j^WS0>?Pf@3Ke/`0N9Re00L0oooo00@0c/iS0>o_k`3gkg/0imi[0P3g
kg/0103WgV/0mnmk0?O_N`3WgV/20?O_N`040>ONJ`3gkg/0U9AS06=SH`D0
oooo00@000000?ooo`3oool000000`3oool00`000000oooo000000030?oo
o`030000003oool0000000<0oooo00<000000?ooo`3oool0=03oool00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn103oool00`1h
V;D0mOGa00000004000000030=oKdP1hV;D0oooo00H0oooo00<0c/iS0>o_
k`3gkg/02`3gkg/00`2DU6<0Hf=S0?ooo`040?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo00000002
0?ooo`800000=P3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_l
o@2XZK/0IVIn103oool02@1hV;D0moOe0?Ogm@3gmo@000000?Kfm03al>/0
iN7J07RH]@070?ooo`050<k>H`3_knl0mnmk0?O_N`3WgV/00P3gkg/00`3W
gV/0mnmk0?O_N`030?O_N`030>ONJ`2DU6<0Hf=S00@0oooo0`0000020?oo
o`<000000`3oool3000000<0oooo0P0000000`3oool000000?ooo`0e0?oo
o`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh40?oo
o`0907RH]@3lo?/0oOgk0?gmn`000000o?ck0?clnP3gm_<0N9Re00L0oooo
00<0c/iS0>o_k`3WgV/01@3gkg/0103WgV/0mnmk0?O_N`3WgV/20?O_N`03
09BDH`1SHf<0oooo00@0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0d0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWh40?ooo`0307RH]@3oool0oooo00D0oooo00<0N9Re0?ooo`3o
ool01@3oool00`3>cV<0kno_0>o_k`0;0>o_k`0309BDH`1SHf<0oooo00D0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0d0?ooo`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh50?ooo`L0
N9Re203oool>0<k>H`0309BDH`3oool0oooo04h0oooo00<0IVIn0:RY^`3k
o?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOQD0oooo00@0c/iS0>ONJ`3>
cV<0imi[0P3>cV<00`2DU6<0oooo0?ooo`1E0?ooo`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWhF0?ooo`@0c/iS00<0U9AS0?oo
o`3oool0EP3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVInL`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVInL`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVInL`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2X
ZK/0IVIn503oool@06=SH`X0oooo00<000000?ooo`3oool0@P3oool00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn503oool>0<k>
H`0309BDH`1SHf<0oooo00T0oooo00<000000?ooo`3oool0@P3oool00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@3oool707RH
]@P0oooo00<0c/iS0>o_k`3gkg/00P3gkg/00`3WgV/0mnmk0?O_N`040?O_
N`040>ONJ`3gkg/0U9AS06=SH`D0oooo0`0000020?ooo`040000003oool0
0000000000<0oooo0`0000020?ooo`040000003oool0oooo0?ooo`800000
0P3oool3000002h0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOP@0oooo00@0N9Re0=;<_`36_Zh0`[RX0P31^:L00`30]jH0
`kZZ07RH]@070?ooo`040<k>H`3_knl0mnmk0>ONJ`<0mnmk00@0imi[0?O_
N`3gkg/0imi[0`3gkg/00`2DU6<0Hf=S0?ooo`030?ooo`060000003oool0
oooo0?ooo`000000oooo0P0000020?ooo`030000003oool0000000<0oooo
00<000000?ooo`0000000`3oool010000000oooo0?ooo`0000030?ooo`03
0000003oool0oooo02/0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOP@0oooo00T0N9Re0>CQf@3Lf<l0f=?90000003FdLH0
d/c00<o8^`1hV;D01`3oool00`3>cV<0kno_0?O_N`0;0?O_N`0309BDH`1S
Hf<0oooo00H0oooo00@000000?ooo`3oool000000`3oool00`000000oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0/0?ooo`0306IVOP2XZK/0nocm0040IVIn
0000101VIWh0nocm0:RY^`1VIWh40?ooo`0907RH]@3bl^h0l?3/0>g]i`00
0000j^WS0>?Pf@3Ke/`0N9Re00L0oooo00@0c/iS0>o_k`3gkg/0imi[0P3g
kg/0103WgV/0mnmk0?O_N`3WgV/20?O_N`040>ONJ`3gkg/0U9AS06=SH`D0
oooo0P0000030?ooo`070000003oool0oooo0?ooo`000000oooo00000003
0?ooo`030000003oool0000000<0oooo00@000000?ooo`3oool0oooo0P00
000_0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1V
IWh40?ooo`0307RH]@3emO40000000@0000000<0gm_B07RH]@3oool01P3o
ool00`3>cV<0kno_0?O_N`0;0?O_N`0309BDH`1SHf<0oooo00<0oooo00H0
00000?ooo`3oool0oooo0000003oool200000080oooo00<000000?ooo`00
00000`3oool010000000oooo0000000000020?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`3oool0:`3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn103oool02@1hV;D0moOe0?Ogm@3g
mo@000000?Kfm03al>/0iN7J07RH]@070?ooo`050<k>H`3_knl0mnmk0?O_
N`3WgV/00P3gkg/00`3WgV/0mnmk0?O_N`030?O_N`030>ONJ`2DU6<0Hf=S
00D0oooo0`0000020?ooo`040000003oool00000000000<0oooo0`000002
0?ooo`030000003oool0000000<000000P3oool3000002h0oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOP@0oooo00T0N9Re
0?cln`3moO/0oOgk0000003lo?/0o?cj0?Ofl`1hV;D01`3oool00`3>cV<0
kno_0>ONJ`050?O_N`040>ONJ`3gkg/0mnmk0>ONJ`80mnmk00<0U9AS06=S
H`3oool06@3oool00`000000oooo0?ooo`0b0?ooo`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWh40?ooo`0307RH]@3oool0oooo
00D0oooo00<0N9Re0?ooo`3oool01@3oool00`3>cV<0kno_0>o_k`0;0>o_
k`0309BDH`1SHf<0oooo01T0oooo00<000000?ooo`3oool0<P3oool00`1V
IWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@3oool707RH
]@P0oooo3P3>cV<00`2DU6<0oooo0?ooo`1>0?ooo`0306IVOP2XZK/0nocm
0040IVIn0000101VIWh0nocm0:RY^`1VIWhE0?ooo`040<k>H`3WgV/0c/iS
0>ONJ`80c/iS00<0U9AS0?ooo`3oool0E@3oool00`1VIWh0Z:Vk0?_lo@01
06IVOP0000@0IVIn0?_lo@2XZK/0IVIn5P3oool40<k>H`0309BDH`3oool0
oooo05H0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk
06IVOQ@0oooo401SHf=?0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101V
IWh0nocm0:RY^`1VIWhD0?ooo`h0c/iS00<0U9AS06=SH`3oool0CP3oool0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn1@3oool7
07RH]@P0oooo00<0c/iS0>o_k`3gkg/00P3gkg/00`3WgV/0mnmk0?O_N`04
0?O_N`040>ONJ`3gkg/0U9AS06=SH`D0oooo0`0000030?ooo`<000000P3o
ool00`000000oooo0?ooo`0300000080oooo00<000000?ooo`3oool00P3o
ool3000002l0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOP@0oooo00@0N9Re0=;<_`36_Zh0`[RX0P31^:L00`30]jH0`kZZ
07RH]@070?ooo`040<k>H`3_knl0mnmk0>ONJ`<0mnmk00@0imi[0?O_N`3g
kg/0imi[0`3gkg/00`2DU6<0Hf=S0?ooo`030?ooo`070000003oool0oooo
0?ooo`000000oooo000000030?ooo`050000003oool000000?ooo`000000
0`3oool00`000000oooo000000030?ooo`050000003oool0oooo0?ooo`00
0000;P3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0
IVIn103oool02@1hV;D0i>7I0=cHc`3HdlT000000=KAaP3Bc<00clRk07RH
]@070?ooo`030<k>H`3_knl0mnmk00/0mnmk00<0U9AS06=SH`3oool00`3o
ool00`000000oooo0?ooo`030?ooo`090000003oool0oooo0?ooo`000000
oooo0000003oool0000000<0oooo00<000000?ooo`0000001P3oool00`00
0000oooo0?ooo`0]0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0
nocm0:RY^`1VIWh40?ooo`0907RH]@3bl^h0l?3/0>g]i`000000j^WS0>?P
f@3Ke/`0N9Re00L0oooo00@0c/iS0>o_k`3gkg/0imi[0P3gkg/0103WgV/0
mnmk0?O_N`3WgV/20?O_N`040>ONJ`3gkg/0U9AS06=SH`@0oooo00<00000
0?ooo`3oool00`3oool02@000000oooo0?ooo`3oool000000?ooo`000000
oooo000000030?ooo`030000003oool0000000@0oooo0P00000`0?ooo`03
06IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh40?ooo`03
07RH]@3emO40000000@0000000<0gm_B07RH]@3oool01P3oool00`3>cV<0
kno_0?O_N`0;0?O_N`0309BDH`1SHf<0oooo00<0oooo00L000000?ooo`3o
ool0oooo0000003oool0000000<0oooo00D000000?ooo`000000oooo0000
00030?ooo`040000003oool0000000000080oooo00D000000?ooo`3oool0
oooo0000000^0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm
0:RY^`1VIWh40?ooo`0907RH]@3gmoD0moOe0?Ogm0000000m_Kd0?7`j`3U
hMX0N9Re00L0oooo00D0c/iS0>o_k`3gkg/0mnmk0>ONJ`020?O_N`030>ON
J`3gkg/0mnmk00<0mnmk00<0imi[09BDH`1SHf<01@3oool3000000<0oooo
0`0000020?ooo`030000003oool0oooo00<000000P3oool00`000000oooo
000000020?ooo`<00000;`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000@0
IVIn0?_lo@2XZK/0IVIn103oool02@1hV;D0o?ck0?gmn`3moO/000000?cl
n`3lo?X0moKc07RH]@070?ooo`030<k>H`3_knl0imi[00D0mnmk00@0imi[
0?O_N`3gkg/0imi[0P3gkg/00`2DU6<0Hf=S0?ooo`0?0?ooo`030000003o
ool0oooo03`0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOP@0oooo00<0N9Re0?ooo`3oool01@3oool00`1hV;D0oooo0?oo
o`050?ooo`030<k>H`3_knl0kno_00/0kno_00<0U9AS06=SH`3oool03`3o
ool00`000000oooo0?ooo`0l0?ooo`0306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWh50?ooo`L0N9Re203oool>0<k>H`0309BDH`3o
ool0oooo04h0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0
Z:Vk06IVOQD0oooo00@0c/iS0>ONJ`3>cV<0imi[0P3>cV<00`2DU6<0oooo
0?ooo`1E0?ooo`0306IVOP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY
^`1VIWhF0?ooo`@0c/iS00<0U9AS0?ooo`3oool0EP3oool00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInL`3oool00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInL`3oool00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVInL`3oool00`1VIWh0Z:Vk
0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn401SHf=S0?ooo`0306IV
OP2XZK/0nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWh>0<k>H`0309BD
H`1SHf<0oooo0680oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3k
o?d0Z:Vk06IVOP3>cV<0kno_0`3gkg/00`3WgV/0mnmk0?O_N`040?O_N`04
0>ONJ`3gkg/0U9AS06=SH`D0oooo0P0000040?ooo`050000003oool0oooo
0?ooo`000000103oool3000000<0oooo0`0000160?ooo`0306IVOP2XZK/0
nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0c/iS0>o_k`3gkg/0imi[
0`3gkg/0103WgV/0mnmk0?O_N`3WgV/30?O_N`0309BDH`1SHf<0oooo00<0
oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool0
000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo
00<000000?ooo`3oool0@`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000H0
IVIn0?_lo@2XZK/0IVIn0<k>H`3_knl<0?O_N`0309BDH`1SHf<0oooo00<0
oooo00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`17
0?ooo`0306IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0
c/iS0>o_k`3gkg/0imi[0P3gkg/0103WgV/0mnmk0?O_N`3WgV/20?O_N`04
0>ONJ`3gkg/0U9AS06=SH`L0oooo00D000000?ooo`3oool0oooo00000003
0?ooo`040000003oool0oooo0?ooo`D0000000<0oooo0000000000000`00
00150?ooo`0306IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1V
IWh0c/iS0>o_k``0mnmk00<0U9AS06=SH`3oool01P3oool01@000000oooo
0?ooo`3oool0000000<0oooo0P0000020?ooo`070000003oool0oooo0?oo
o`000000oooo000000030?ooo`030000003oool0oooo04<0oooo00<0IVIn
0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP3>cV<0kno_0P3g
kg/0103WgV/0mnmk0?O_N`3WgV/50?O_N`030>ONJ`2DU6<0Hf=S00L0oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool000000080
oooo0`0000030?ooo`<00000AP3oool00`1VIWh0Z:Vk0?_lo@0106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn0<k>H`3_knl0imi[00D0mnmk00@0imi[0?O_
N`3gkg/0imi[0P3gkg/00`2DU6<0Hf=S0?ooo`060?ooo`050000003oool0
oooo0?ooo`000000E`3oool00`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn0<k>H`0=0>o_k`0309BDH`1SHf<0oooo00H0oooo00<0
00000?ooo`0000001000001E0?ooo`0306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWh>0<k>H`0309BDH`3oool0oooo0680oooo00<0
IVIn0:RY^`3ko?d00@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP3oool0c/iS
0>ONJ`3>cV<0imi[0080c/iS00<0U9AS0?ooo`3oool0J@3oool00`1VIWh0
Z:Vk0?_lo@0106IVOP0000@0IVIn0?_lo@2XZK/0IVIn0P3oool40<k>H`03
09BDH`3oool0oooo06X0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000406IV
OP3ko?d0Z:Vk06IVOW<0oooo00<0IVIn0:RY^`3ko?d00@1VIWh0000306IV
OP3gmoT0V9RW07D0MgNB0@2HV:L10?Ogn@40IVIn00000`1VIWh0moOi0;bm
c@1f0;bmc@40moOi0@1VIWh0000306IVOP3gmoT0i>?S07H0i>?S0@3gmoT1
06IVOP0000<0IVIn0?3am03oool0;`3oool00`3Thn<0W:Bi06]eS`0306]e
S`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>CS
h`2LY;T406]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3o
ool0oooo0>cZjP2LY;T40:HiA0040:LjA02V>D@0YcY40:LjA0T0YSU400<0
W:Bi0>cZjP3oool00`3oool10?3am040IVIn00005P1VIWh0h^7R0?_lo03k
no`0nocm0?cko@3knod0nocm0?_lo03lo?d0o?cl0?cko@3lo?`0o?_l0?cl
o03ko?`0o?cl0?_lo@3lno`0o?cm0?_ko@3ko?`20?clo0040?clo@3lo?`0
no_m0?cloA@0o?_l0P3ko?`00`2LY;T0JgF?08F9/00@08F9/00606]eS`2L
Y;T0nocm0?_lo@2LY;T0JgF?4@25RK001P1[MHl0W:Bi0?_lo03kno`0W:Bi
0:HiA140ZSaE00L0YSU409bT^@3ko?`0o?cl0?cko@3ko?d0h^7R0040IVIn
0000101VIWh0h>3Q0?Kgn@3gmoT20?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03f
moT0moOh0?Ogn@3gm_P0m_Oi0?Ogn@3fmoT00P3gmoT0103gm_P0m_Oh0?Kg
n@3gmoT30?Kgn@030?Kgn03gmoT0moOi01<0moOi0P3fmoT00`1[MHl0QHV`
09bN_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h02025
RK00JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0`U9K
0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@0106IVOP0000H0IVIn0=kM
h@3alO@0lO7d0?3am03`l_@@000000060?7am03`l_D0lO7d0?7bm03`l_@0
lO7d5P3`lOD00`1[MHl0/[G@0:NX`P0@0:NX`P060;:ed01[MHl0l?7d0?3a
m01[MHl0/[G@4@2WZ<801@2b]M00JgF?0?3am@3al_@0YSU40080`U9K00<0
beAI0<eIGP3=FEh02`3=FEh0103;E5T0`U9K0<9BF`2V>D@20?3am0030?7a
m03`l_@0g]gQ0040IVIn00001`1VIWh0g=_P0>[[l03Zjo00j^c`0>W[k`00
00000P3WinL20=kNgP80inOW00<0ikf40>OWi`3WinL00`3WinL20>o_k`04
0000003Zjo00j^_`0>[[k`80j^_`00<0j^__0>[[l03Zjo004P3Zjo020>[/
l00406]eS`2f^M40[Jk60:f^aPP0oooo00<0[Jk60:b^aP2][/H00`2][/H0
0`2/[/H0][WA06]eS`020>[[k`0406]eS`2f^M40[Jk60:f^aP`0oooo0P2]
[/H00`2/[/H0][WA06]eS`020>[[l0050:HiA03=FEh0beAI0<eFF`3>FEl0
2`3@FUl01`3>FEl0cEIK0<]DF@3=FEh0YSU40>[[k`3Zjo000P3Zjnl10=cK
h040IVIn0000101VIWh0fMWO0>?UjP3Si>X20>?Uj`050000002<S8`0g]kN
0>OWi`3Ng]h00P3WinL00`36H`00inOW0>OWi`020>OWi`070>o_i`3_knl0
kno_0000003Si>X0hnC[0>?UjP020>?TjP030>?Tj`3SiN/0hnG[0180hnG[
0P3Si>X01@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b
//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo
02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=
FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0
cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0
g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_
U100inOW0>ONaP3_S1000`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cN
i@3Lg^H05P3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf
0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>
00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1
eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<3
0?ooo`0505<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OH
gP0106IVOP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OW
i`3WinL0ikF40=IJ003FQ000olh00<iS00020=i[00050>neS03_knl0kno_
0>o_k`0000000P3Ef>40103Een00e]SP0=KHh@3Fen4D0=KGh080e]SP00D0
JgF?0<?5f@2l_M40_;gA0?ooo`0702DU=PL0_;gA00H0`lGI06]eS`3Ef>40
eMSQ06]eS`33aMT20;bmd@030?ooo`0U9CH0_;gA00L0_;gA00<0oooo02DU
=P2l_M400P2l_M401@33aMT0JgF?0=KGh03Een40YSU40080eEeP00<0f61Q
0=UQHP167QX00`3oool30=UQHP<0oooo00<0AQhJ0=UQHP3HH6400P3EGF00
1P2V>D@0e]SP0=GHh@3Een00eMSQ0=GFg@40IVIn00001`1VIWh0d]CM0<oB
g03@d]`0d=;M0=3Bg00000000`3WinL0303Wg/h0aTX00?O>003_[@00kkD0
0<i[0036FP00aV/00=j<BP3WY@00knO>000000<0d=;L00<0cm;L0=3Bg03?
d]`0503@d]`20<oBg@0306]eS`38bM/0`lCF0100`lCF00H0b<WK06]eS`3@
d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U9CH0`lCF00L0`lCF00<0oooo
02DU=P33a=H00P33a=H01`38bM/0JgF?0<oBg03?d]`0YSU40=MOG`3IHF80
0`3LIFD01@167QX0oooo0?ooo`3oool0g6EU00<0oooo00P0AQhJ0=aUI@3L
IFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?d]`10=;Dg@40IVIn0000
701VIWh0d=;K0<_=f03:cMT0blkH0<[=f0000000ilJ]0>O6S03gcQP0kkd0
0?O6003_[@00ijd00>NU003FS000cV/00>O6003oeP00knoW0>o_k`000000
blgH0<_=f@3:cMT0blkH0<[=f03;cMPD0<_=f@80blkI00<0JgF?0<_<gP38
b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38b]T0blcN06]e
S`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38
b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:Hi
A03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?ooo`030?ooo`0:
04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI
0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P000000a/K60>ON
eP3>N`00ijd00>ne0080ijD000<0eY@00<ic003FU0000P3gaP020?Ogm`04
00000035b=@0aLOD0<G7e0<0aLOE5034amD20<C8e00306]eS`3@dN00bl_L
0100bl_L00H0d=7P06]eS`34am@0a<OD06]eS`3@dN020<_;g0030?ooo`0U
9CH0bl_L00L0bl_L00<0oooo02DU=P3;bm`00P3;bm`01`3@dN00JgF?0<G7
e034am@0YSU40=]TI03OIF@01@3PJVP01@167QX0oooo0?ooo`3oool0AQhJ
00D0h6YX00@0gfET0=]TI02V>D@0a<SE0P34b=@10<G7e@40cloJ0@1VIWh0
000406IVOP3<c]X0`/CB0<74d@80`LCB00H000000>OWi`3WinL0inOW0=J4
003_]@020>NU00080=J4003>J`00ijd00?Ne003g_@00kno_0?Ogm`000003
0<74dP030<;4d@31a=80`LCB01@0`LCA0P31a=800`1[MHl0dm?R0<o@g@0@
0<o@g@060=?ChP1[MHl0`/CB0<;4dP1[MHl0dm?R0P3?d=d00`3oool09BDf
0<o@g@070<o@g@030?ooo`0U9CH0cm3M0080cm3M00L0dm?R06]eS`32a=80
`LCA0:HiA03KI6@0hFUU00D0h6aY1@3oool50>1/J@080>5YI@3KI6@0YSU4
0<74dP32a=40`LCA0<74dP3<c]X106IVOP0000@0IVIn0<[<f02n`<l0_L3?
0P2n`<h01@000000W9bL0>OWi`3Wg]H0eX`00080gY@000@0eW/00<IS002m
@P00kjD00P3g[@00203g]@00oli:0000002n`<h0_/3?0;k0cP2n`<l0_L3>
5@2n`<h20;g0cP0306]eS`3Fe^@0dm?P0100dm?P00H0e]KT06]eS`2n`<h0
_/3>06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo00P0oooo00/09BDf0=?C
h03Cdn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0
oooo00@0AQhJ0?ooo`3oool0oooo103SK6`0103QJVX0h6IU0:HiA02m`<l2
0;k0c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j
_<`000000080kno_01<0eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic
003_W000mnoW0?Ogm`3oool000000;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;
01@0^Kc<0P2j_<`00`1[MHl0f=SU0=?Ch@0@0=?Ch@060=SHi@1[MHl0^[c;
0;Zlb`1[MHl0f=SU0P3Cdn400`3oool0KVf?06i]S`0806i]S`0>02DU=P3C
dn40dm?Q0=?Ch@3Hf>D0JgF?0;Zlb`2j_<`0YSU40>1YJ03QKF`0i75]0>Aa
K`3TL6h30?ooo`0304HN6P3TL6h0AQhJ00<0oooo0P3TL6h02@3TLFd0hFe/
0>1YJ02V>D@0^[c<0;Zkc02i_</0][S80<W:f00106IVOP0000T0IVIn0<O9
e`2d]/L0][S80;Jhb@2f^LT0000008B4Q03Wimh00P3_knl01`36J`00mlH0
0>ne003_W000gX`00<i[003WW0000`3gmoL01@000000][W90;Nhb@2f^LT0
]kW90080][S9502g^<T20;Jhb@0406]eS`3Fe^@0f=SU0=SHiP<0f=SU1@3H
f>H30=SHi@80f=SV0P3Hf>D02@3Fe^@0JgF?0;Nhb@2g^<T0JgF?0=KFi03H
f>D0f=SV0?ooo`0:06i]S`0=02DU=P3Hf>H0f=SU0=SHi@3Fe^@0JgF?0;Nh
b@2g^LT0YSU40>A^K@3TM6l0ig5_0>AdK`030?ooo`0504HN6P3TM6l0i7A_
0>AdK`167QX00`3oool02P3TM6l0ig5_0>AdK`3TKVd0YSU40;Jib@2f^<T0
][W90;Bfa`37bML106IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L00`000000
kno_0>o_k`020>o_k`0;0>N]003gaPP0ijD00>ND003WS000knOF0=jD>@3_
e[D0ooOg0?ooo`000000702d]/L01@1[MHl0eMGS0=cKi`3LfnL0gM_W00h0
g=_W00H0eMGS06]eS`2d]/L0];K706]eS`3EeN<20=cKi`030=gKi`0U9CH0
9BDf00T09BDf0`3LfnL02@3EeN<0JgF?0;Bfa`2d]/L0YSU40>McK`3WMG80
jWIc0>YhMP020?ooo`0304HN6P3YOWP0jGih00<0jGih00P0AQhJ0?ooo`3o
ool0jWQf0>YfL`3WMG80ig=_0:HiA0@0];K70@36b=L106IVOP0000<0IVIn
0<K8e`2d]/L00`2d]/L01P000000S8b<0>o_k`3_knl0ilik0>o_k`80moOg
00P0ii@00?OWcP3gmoL0moOg0>oWeP3gmoL0oooo000001`0];K700<0JgF?
0=GDh`3PgnX0403PgnX01P3Ee><0JgF?0;Bfa`2d]/L0JgF?0=GDha40h=oZ
00T0eMCS06]eS`2d]/L0];K70:HiA03ZNG<0jGah0>n1NP3bRH400P167QX0
1`3[V8/0jY^<0>fGRP3[V8/0jY^<0>fGRP3[V8/00P167QX01@3bRH40kh5j
0>UlN03ZNG<0YSU400@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2a/lP0
0`2a/lP01P000000kno_0>o_k`3_knl0moO_0>o_k`80moOg00<0mnO60?Og
m`3oool00`3gmoL00`3oool000000;6cb00K0;6cb00306]eS`3]jo<0jNSa
0100jNSa00H0kN_c06]eS`2a/lP0/K?806]eS`3]jo<A0>WXl@0I0>g[l`1[
MHl0/K?80;6cb02V>D@0lH1e0?24O03eS8@0mif>0?:[UP3a/Y/0kKBK0>be
W03a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03bZiH0mif>0?F<Q03`Q7`0lH1e
0:HiA0040;6cb040a/SG0@1VIWh0000306IVOP36b=L0^;O?00<0[jk700D0
00000:f][@3gmnl0moOg0>o_k`060?Ogm`80ooOg0P3oool00`000000[jk7
0:n^a`0J0:n^a`0306]eS`3BdN<0l_7g0100l_7g00H0d]7S06]eS`2_[/L0
[jk706]eS`3BdN<A0?;am`060=;Ah`1[MHl0[jk70:n^a`2V>D@0m8Ym0P3e
T8D=0?:hWP80mI2500<0m8Ym0:HiA02_[/L00P2_[/L10;Rgc`40a/SG0@1V
IWh0000306IVOP30`M40alOD02l0[:_400@0Q8bR06]eS`3<bmd0no_l3@3o
ool0103kno`0c<_M06]eS`24S:820:b[a00408B<XP1[MHl0c<_M0?_ko0d0
oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01`2AV:X0YSU40?nOS@3n_j@0
n]bg0?[[]`3jjKH00P3ijKH0103jjKH0nNVf0?WY]P3jjKH20?WY]P060?[[
]`3jg;L0o[nT0?nOS@2V>D@0TIRZ0`2/Zl@10<O7e040`<7A0@1VIWh00004
06IVOP30`M40d];O0;FdbBl0Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24
S:80Y:>n0:BS_P020:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS
_P2TXkh00P2TXkh00`24S:80YSU40:HiA00?0:HiA00708B<XP2TXkh0Y:>n
0:BS_P2e]<T0d];O0<31d@0106IVOP0000H0IVIn0:RW_`3Vi^d0d];P0;bl
c`2a/<A_0:RW_`050;6`a02l_<l0d];P0>KVk@2XYkl00@1VIWh0000705QG
J027Qi/0emSR0?clo03ThnP0d=3P0<[:fP1]0;blc`060<[:fP3@d>00i>?X
0?clo03Gf>80QhNK0@1HEfP0000805QGJ01VIWh0UIB[0=OHhP3lo?`0l_7c
0>c[kP3Qh^][0=OHhP070>7Rj`3/jnh0l_7c0?clo03Gf>80UIB[06IVOP01
05QGJ0000P1HEfP00`1VIWh0UIB[0=7AgP020?clo6d0oooo0P3lo?`00`3A
dMh0UIB[06IVOP0205QGJ0000`1HEfP206IVOP0308R7W@2EU:/0Z:No06`0
Z:No00@0UIB[08R7W@1VIWh0IVIn0`1HEfP000D0F5MXL@1VIWh505QGJ000
\
\>"], "Graphics",
  CellLabel->"From In[17]:=",
  Evaluatable->False,
  ImageSize->{123, 98},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Tree"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[17]=",
  CellTags->"Tree"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Widget[\"Table\"]", "ObjectName",
  CellTags->"Table"],

Cell[TextData[{
  StyleBox["Properties", "SubsubsectionFirst"],
  "\n\[FilledSmallSquare] ",
  StyleBox["\"items\" \[Rule] {{", "Program"],
  StyleBox["row0col0", "Program",
    FontSlant->"Italic"],
  StyleBox[", ", "Program"],
  StyleBox["row0col1", "Program",
    FontSlant->"Italic"],
  StyleBox[", \[Ellipsis]}, {", "Program"],
  StyleBox["row1col0", "Program",
    FontSlant->"Italic"],
  StyleBox[", ", "Program"],
  StyleBox["row1col1", "Program",
    FontSlant->"Italic"],
  StyleBox[", \[Ellipsis]}\[Ellipsis]}\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"tableHeader\" \[Rule] Null\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"rowSelectionAllowed\" \[Rule] True\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"columnSelectionAllowed\" \[Rule] True\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"columnEditable\" \[Rule] {False, True, True, \[Ellipsis]}\n", 
    "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"prototype\" \[Rule] {False, \"string\", ", "Program"],
  StyleBox["number", "Program",
    FontSlant->"Italic"],
  StyleBox[", \[Ellipsis]", "Program"],
  StyleBox["}\n", "Program"],
  "\[FilledSmallSquare] ",
  StyleBox["\"model\"", "Program"]
}], "Notes",
  CellFrame->{{0, 0}, {0.5, 0}},
  CellTags->"Table"],

Cell[CellGroupData[{

Cell["Examples", "ContentsSection",
  CellTags->"Table"],

Cell[BoxData[
    \(\(Needs["\<GUIKit`\>"];\)\)], "Input",
  CellLabel->"In[1]:=",
  CellTags->"Table"],

Cell[BoxData[
    RowBox[{
      RowBox[{"ref", " ", "=", " ", 
        RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
          RowBox[{
            StyleBox["Widget",
              "Output"], "[", \("\<Table\>", {}, \ 
            InitialArguments \[Rule] {2, 3}\), "]"}], "\[IndentingNewLine]", 
          "]"}]}], ";"}]], "Input",
  CellLabel->"In[2]:=",
  CellTags->"Table"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // \ Show\)], "Input",
  CellLabel->"In[3]:=",
  CellTags->"Table"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003Y0000@R000`400?l0
0000o`00003oj@1VIWh0000306IVOP3ko?d0nocm0>D0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0>@0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
h`1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO^40P820
00<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTX0oooo
00<0P8200?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`040820
P01VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWi:0?ooo`03
0820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool01020P800
IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInBP3oool00`20
P800oooo0?ooo`180?ooo`030820P03oool0oooo04P0oooo00@0P82006IV
OP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTX0oooo00<0P820
0?ooo`3oool0B03oool00`20P800oooo0?ooo`180?ooo`040820P01VIWh0
Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWi:0?ooo`030820P03o
ool0oooo04P0oooo00<0P8200?ooo`3oool0B03oool01020P800IVIn0:RY
^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInBP3oool00`20P800oooo
0?ooo`180?ooo`030820P03oool0oooo04P0oooo00@0P82006IVOP2XZK/0
nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOTX0oooo00<0P8200?ooo`3o
ool0B03oool00`20P800oooo0?ooo`180?ooo`040820P01VIWh0Z:Vk0?_l
o@40IVIn0000101VIWh0nocm0:RY^`1VIWi:0?ooo`030820P03oool0oooo
04P0oooo00<0P8200?ooo`3oool0B03oool01020P800IVIn0:RY^`3ko?d1
06IVOP0000@0IVIn0?_lo@2XZK/0IVInBP3oool00`20P800oooo0?ooo`18
0?ooo`030820P03oool0oooo04P0oooo00@0P82006IVOP2XZK/0nocm0@1V
IWh0000406IVOP3ko?d0Z:Vk06IVOTX0oooo00<0P8200?ooo`3oool0B03o
ool00`20P800oooo0?ooo`180?ooo`040820P01VIWh0Z:Vk0?_lo@40IVIn
0000101VIWh0nocm0:RY^`1VIWi:0?ooo`030820P03oool0oooo04P0oooo
00<0P8200?ooo`3oool0B03oool01020P800IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVInBP3oool00`20P800oooo0?ooo`180?ooo`03
0820P03oool0oooo04P0oooo00@0P82006IVOP2XZK/0nocm0@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOTX0oooo00<0P8200?ooo`3oool0B03oool00`20
P800oooo0?ooo`180?ooo`040820P01VIWh0Z:Vk0?_lo@40IVIn0000101V
IWh0nocm0:RY^`1VIWi:0?ooo`030820P03oool0oooo04P0oooo00<0P820
0?ooo`3oool0B03oool01020P800IVIn0:RY^`3ko?d106IVOP0000@0IVIn
0?_lo@2XZK/0IVInBP3oool00`20P800oooo0?ooo`180?ooo`030820P03o
ool0oooo04P0oooo00@0P82006IVOP2XZK/0nocm0@1VIWh0000406IVOP3k
o?d0Z:Vk06IVO^40P82000<0IVIn0:RY^`3ko?d00@1VIWh0000406IVOP3k
o?d0Z:Vk06IVOTX0/[Bo00<0P8200?ooo`3oool0B03oool00`20P800oooo
0?ooo`180?ooo`040820P01VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0/[Bo04P0oooo00<0/[Bo0820P03oool0B@3oool00`20P800
oooo0?ooo`180?ooo`040820P01VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0/[Bo04P0oooo00<0/[Bo0820P03oool0B@3oool00`20
P800oooo0?ooo`180?ooo`040820P01VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0/[Bo04P0oooo00<0/[Bo0820P03oool0B@3oool0
0`20P800oooo0?ooo`180?ooo`040820P01VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0/[Bo04P0oooo00<0/[Bo0820P03oool0B@3o
ool00`20P800oooo0?ooo`180?ooo`040820P01VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0/[Bo04P0oooo00<0/[Bo0820P03oool0
B@3oool00`20P800oooo0?ooo`180?ooo`040820P01VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0/[Bo04P0oooo00<0/[Bo0820P03o
ool0B@3oool00`20P800oooo0?ooo`180?ooo`040820P01VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0/[Bo04P0oooo00<0/[Bo0820
P03oool0B@3oool00`20P800oooo0?ooo`180?ooo`040820P01VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0/[Bo04P0oooo00<0/[Bo
0820P03oool0B@3oool00`20P800oooo0?ooo`180?ooo`040820P01VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0/[Bo04P0oooo00<0
/[Bo0820P03oool0B@3oool00`20P800oooo0?ooo`180?ooo`040820P01V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0/[Bo04P0oooo
00<0/[Bo0820P03oool0B@3oool00`20P800oooo0?ooo`180?ooo`040820
P01VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0/[Bo04P0
oooo00<0/[Bo0820P03oool0B@3oool00`20P800oooo0?ooo`180?ooo`04
0820P01VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0/[Bo
04P0oooo00<0/[Bo0820P03oool0B@3oool00`20P800oooo0?ooo`180?oo
o`040820P01VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
/[Bo04P0oooo00<0/[Bo0820P03oool0B@3oool00`20P800oooo0?ooo`18
0?ooo`040820P01VIWh0Z:Vk0?_lo@40IVIn0000101VIWh0nocm0:RY^`1V
IWi:0;:d_`030820P03oool0oooo04P0oooo00<0P8200?ooo`3oool0B03o
ool01020P800IVIn0:RY^`3ko?d106IVOP0000<0IVIn0?Ogn@2HV:L0h`1g
Mi8109RHY`40moOi0@1VIWh0000306IVOP3gmoT0_;g=0>@0_;g=0@3gmoT1
06IVOP0000<0IVIn0?Ogn@3Thn<0i03Thn<10?Ogn@40IVIn00000`1VIWh0
l?7d0?ooo`2M0?ooo`030>CSh`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/
MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0
K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT
^@@0YSU400@0YcY40:HiA02W>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`03
0?ooo`40l?7d0@1VIWh0000F06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_k
o@3ko?d0nocl0?clo@3lo?`0o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm
0?cko03lo?d0no_m0?_lo080o?cl00@0o?cm0?clo03knod0o?cm>@3lno`h
0?_lo1<0nocm00<0W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3k
o?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:Xl
E@070:HiA02LY;T0nocl0?clo03lnod0nocm0>;QhP0106IVOP0000@0IVIn
0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03g
moT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3f
moT00`3fmoP0moOi0?Ogn@0h0?OgnCP0m_Oi4`3gmoT00`1[MHl0QHV`09bN
_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00
JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:Xl
E@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3a
lO@0lO7d0?3am03`l_@@000000060?7am03`l_D0lO7d0?7bm03`l_@0lO7d
L@3`lODC0?3am00306]eS`2b]M00YjS20100YjS200H0/[G@06]eS`3`lO@0
l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e0?7bm02V>D@00P32DU/0
0`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0`U9K0:HiA080l?7d00<0
lO7d0?3bm03NgN400@1VIWh0000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__
000000020>OWi`80g]kN0P3WinL00`3W_H@0inOW0>OWi`030>OWi`80kno_
00@000000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`0>[[l00g0>[[l3P0
j^c`4`3Zjnl0101[MHl0][WA0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk6
00<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<
0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=
EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080
j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000
S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<00>OWi`3WinL00P3WinL01`3_
knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?U
j`0g0>?UjcP0hnCZ4`3SiNX01@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?
00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bn
e080/[;:00<0oooo02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[
0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0
e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0
000306IVOP3Gf=h0g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OFcP02
0>OWi`050<ik003_U100inOW0>ONaP3_S1000`3_knl01`000000g=kV0=cN
i@3Lg^D0g=kV0=cNi@3Lg^H0Q03Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo
00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0
JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;Ri
cP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP
00<0oooo1@3FGf<30?ooo`0505<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D0
0`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>00
2@000000S8b<0>OWi`3WinL0ikF40=IJ003FQ000olh00<iS00020=i[0005
0>neS03_knl0kno_0>o_k`0000000P3Ef>40103Een00e]SP0=KHh@3Fen4i
0=KGh3P0e]SP4`3Ef>401@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l
_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l
_M401`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GG
h@2V>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`16
7QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1V
IWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ON
cP36BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh00000
0`3@d]`00`3?d]`0d=;L0<oBg00i0=3Bg3P0cm;M4`3@d]`00`1[MHl0b<WK
0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3o
ool09BDf0<?4eP070<?4eP030?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]e
S`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo
0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d2
0=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:
cMP000000>O6[@3WaX`0mlhH0>nm003gaP00kjd00>N]003WY@00eX`00<i[
003WaP00omH00>o_i`3_knl000000<_=f03;cMT0b/gI0<_>f03:cMP0blgH
>@3;cMTh0<_>fA<0blgH00<0JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I
0<S:f@030<S:f@040<S9f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38
b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I
0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD0
0P3NIfL00`167QX0oooo0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3P
IfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn
0<o?fP35b=@00`35b=@01P000000a/K60>ONeP3>N`00ijd00>ne0080ijD0
00<0eY@00<ic003FU0000P3gaP020?Ogm`0400000035b=@0aLOD0<G7e0<0
aLOE>@34amDh0<C8e1<0a<OD00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00
JgF?0<C7e034am@0JgF?0=3Ah080bl_L00<0oooo02DU=P3;bm`01`3;bm`0
0`3oool09BDf0<_;g0020<_;g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT
0=mUI0050>1ZJ00504HN6P3oool0oooo0?ooo`167QX01@3PJVP0103OIF@0
ffAT0:HiA034b=D20<C8e040aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32
a=80`LCA0P31a=801P000000inOW0>OWi`3WinL0eX@00>ne0080ijD000P0
eX@00<i[003W[@00mkD00?Nm003_knl0moOg000000<0`LCB00<0`/CA0<74
dP31a=80>@31a=4h0<74dQ<0`/CB00<0JgF?0=?ChP3?d=d0403?d=d01P3C
dn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?
d=d00`3oool09BDf0<o@g@020<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0
ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA
0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:c=P0_/3?0;g0c`80_/3>00D0
000009bLW03WinL0imkF0=J<00020=jD00040=Ik0036H`00_D800>nU0080
mjd000P0mkD00?o>BP000000_/3>0;k0c`2n`<h0_/3?0;g0cSX0_/3>>02m
`<hC0;k0cP0306]eS`3Fe^@0dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>
06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo00P0oooo00/09BDf0=?Ch03C
dn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo
00@0AQhJ0?ooo`3oool0oooo103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0
c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`0
00000080kno_01<0eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic003_
W000mnoW0?Ogm`3oool000000;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;03T0
^Kc<>02j_<`C0;Zlb`0306]eS`3Hf>D0dm?Q0100dm?Q00H0f=SU06]eS`2j
_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?00P0KVf?00h09BDf
0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0
i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3oool20>A`KP090>AaK@3Q
KF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H0040IVIn00002@1VIWh0
alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OWgP020>o_k`070<I[003g
aP00kkD00>nL003NS000cV/00>NL00030?Ogm`050000002f^LT0]kS90;Ji
b@2g^LT00P2f^<Ti0;NhbCP0][S94`2g^<T0101[MHl0e]KT0=SHi@3Hf>H3
0=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0e]KT06]eS`2g^<T0]kS906]e
S`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT
06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0
i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f
^LT0][S90;Jib@2d]/L0alWG0@1VIWh0000306IVOP36b=L0];K700<0];K7
00<000000>o_k`3_knl00P3_knl02`3W[@00mlH80>NU003WU000ih`00>oW
eP3NU3T0kmJe0?ogm`3oool0000008X0];K700D0JgF?0=GEh`3LfnL0g=_W
0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3M
fnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03W
Lfl0igEb0>YfL`3ZN7H00P3oool00`167QX0jGih0>UnN0030>UnN00804HN
6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0
000306IVOP36b=L0];K700<0];K700H0000008b<S03_knl0kno_0>O>N`3_
knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_imH0moOg0?ooo`00002:0;Bf
a`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3E
e><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV1
0080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0
lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40a/SG0@1VIWh0000306IVOP36
b=L0/K?800<0/K?800H000000>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`03
0?OWaP3gmoL0oooo00<0moOg00<0oooo0000002a/lP0R@2a/lP00`1[MHl0
kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?40
6@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K
0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0
l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`03
0:n^a`050000002][Jd0moO_0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<0
00000:n^a`2_[/L0R02_[/L00`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[
MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU4
0?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll1
0<K8e`40IVIn00000`1VIWh0`<7A0<O7e02M0:b[a00408B<XP1[MHl0c<_M
0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;
g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03o
Whd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3i
jKH01P3jjkL0n]bg0?joY03oWhd0YSU4096HZP<0[:_40@37am@10<31d@40
IVIn0000101VIWh0`<7A0=;Bg`2e]<VM0:BS_P0308B<XP1[MHl0JgF?00l0
JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80JgF?06]eS`0?06]eS`03
08B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80
Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1VIWh0000606IVOP2XYkl0i^K]
0=;Bh02l_<l0/K34g@2XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn
00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@h03:b]X0f`2l_<l01P3:b]X0
d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80
o?cl0?;al`3/jnh0hN;[f@3Gf>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FD
Z`1VIWh00@1HEfP00080F5MX00<0IVIn09FDZ`3AdMh00P3lo?cK0?ooo`80
o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[
0:RW_`3J0:RW_`0409FDZ`28Qid0IVIn06IVOP<0F5MX000505QGJ=l0IVIn
1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[3]:=",
  Evaluatable->False,
  ImageSize->{233, 66},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Table"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[3]=",
  CellTags->"Table"]
}, Open  ]],

Cell["\<\
Here we set up a basic table sitting inside a scrollview that allows large \
table growth and the ability to display column headers. We also name the \
table model that lives within the table since it contains some useful \
properties that may be worth changing:\
\>", "Text",
  CellTags->"Table"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"ref", " ", "=", " ", 
      RowBox[{"GUIRun", "[", "\[IndentingNewLine]", 
        RowBox[{
          StyleBox["Widget",
            "Output"], "[", 
          RowBox[{"\"\<Panel\>\"", ",", 
            RowBox[{"{", "\[IndentingNewLine]", 
              RowBox[{
                StyleBox["Widget",
                  "Output"], "[", 
                RowBox[{"\"\<ScrollPane\>\"", ",", 
                  RowBox[{"{", "\[IndentingNewLine]", 
                    RowBox[{
                      RowBox[{"\"\<preferredSize\>\"", "\[Rule]", 
                        RowBox[{
                          StyleBox["Widget",
                            "Output"], 
                          "[", \("\<Dimension\>", \ {"\<width\>" \[Rule] 
                              200, \ "\<height\>" \[Rule] 110}\), "]"}]}], 
                      ",", "\[IndentingNewLine]", 
                      RowBox[{"\"\<viewportView\>\"", "\[Rule]", 
                        RowBox[{
                          StyleBox["Widget",
                            "Output"], 
                          "[", \("\<Table\>", {\[IndentingNewLine]"\<items\>" \
\[Rule] {{"\<a1\>", "\<b1\>", "\<c1\>"}, {"\<a2\>", "\<b2\>", "\<c2\>"}}, \
\[IndentingNewLine]PropertyValue["\<model\>", 
                              Name -> \ \
"\<myTableModel\>"]\[IndentingNewLine]}, \ Name -> "\<myTable\>"\), "]"}]}]}],
                     "\[IndentingNewLine]", "}"}]}], "]"}], 
              "\[IndentingNewLine]", "}"}]}], "]"}], "\[IndentingNewLine]", 
        "]"}]}]], "Input",
  CellLabel->"In[4]:=",
  CellTags->"Table"],

Cell[BoxData[
    InterpretationBox[\(\[SkeletonIndicator]  
        GUIObject  \[SkeletonIndicator]\),
      GUIObject[ 
      JLink`Objects`JavaObject299046627442689, 
        JLink`Objects`JavaObject187864402886657]]], "Output",
  CellLabel->"Out[4]=",
  CellTags->"Table"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[5]:=",
  CellTags->"Table"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003@0000T2000`400?l0
0000o`00003od01VIWh0000306IVOP3ko?d0nocm0<`0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0</0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
bP1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO/P0Oifi
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS
00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM
^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0
h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`04
07nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3O
h`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40
IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2X
ZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101o
WKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@36
0>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1V
IWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IV
OP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0
101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY
^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk
0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3P
gn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm
0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0
Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS
00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM
^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0
P82000@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0@@3oool00`20P800oooo0?ooo`0o0?ooo`030820P03oool0oooo
03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@110?ooo`030820P03oool0oooo03l0oooo00<0P820
0?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0440oooo00<0P8200?ooo`3oool0?`3o
ool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool2000000030?oo
o`000000oooo00D00000=@3oool01020P800oooo0000003oool200000080
oooo1@00000e0?ooo`030820P03oool0oooo00<000000P3oool5000003D0
oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2X
ZK/0IVIn07nM^@3oool000000080oooo0P0000020?ooo`030000003oool0
oooo03H0oooo00@0P8200?ooo`00000000000P3oool010000000oooo0?oo
o`00000h0?ooo`030820P03oool0000000<0oooo00@000000?ooo`3oool0
0000>03oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0Oifi0?ooo`0000000`3oool01@000000oooo0?ooo`3o
ool0000003L0oooo00<0P8200?ooo`0000000`3oool01@000000oooo0?oo
o`3oool0000003L0oooo00<0P8200?ooo`0000001`3oool00`000000oooo
0?ooo`0e0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1oWKT00P3oool4000000@0oooo00<000000?ooo`3o
ool0=03oool00`20P800oooo000000030?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0=03oool00`20P800oooo000000080?ooo`03
0000003oool0oooo03@0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000<0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0c0?ooo`040820P03oool0
000000000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0c0?ooo`030820P03oool0000000<0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0c0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool3000000H0oooo
00<000000?ooo`3oool0<`3oool01020P800oooo0000003oool2000000H0
oooo00<000000?ooo`3oool0<`3oool00`20P800oooo0?ooo`03000000H0
oooo00<000000?ooo`3oool0<`3oool01@20P800Oifi06IVOP2XZK/0nocm
0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi00L0oooo00D000000?oo
o`3oool0oooo0000000e0?ooo`030820P03oool0000000D0oooo00D00000
0?ooo`3oool0oooo0000000e0?ooo`030820P03oool0oooo00D0oooo00D0
00000?ooo`3oool0oooo0000000e0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0203oool3000003H0
oooo00<0P8200?ooo`0000001P3oool3000003H0oooo00<0P8200?ooo`3o
ool01P3oool3000003H0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@110?ooo`030820P03oool0oooo
03l0oooo00<0P8200?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0
nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0440oooo00<0P820
0?ooo`3oool0?`3oool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0
IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0@@3o
ool00`20P800oooo0?ooo`0o0?ooo`030820P03oool0oooo03l0oooo00D0
P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
07nM^@110?ooo`030820P03oool0oooo03l0oooo00<0P8200?ooo`3oool0
?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh0Oifi0<H0P82000@0Oifi06IVOP2XZK/0nocm0@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT0@@2b];l00`20P800oooo0?ooo`0o0?oo
o`030820P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@2b];lo0?ooo`030;:d_`20
P800oooo0400oooo00<0P8200?ooo`3oool0?`3oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi0;:d_cl0
oooo00<0/[Bo0820P03oool0@03oool00`20P800oooo0?ooo`0o0?ooo`05
0820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP1oWKT0/[Bo0?ooo`02000000030?ooo`000000oooo0080oooo00<00000
0?ooo`3oool0=03oool01@2b];l0P8200?ooo`000000oooo00800000103o
ool00`000000oooo0?ooo`0e0?ooo`030820P03oool0oooo00<00000103o
ool00`000000oooo0?ooo`0e0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo000000020?ooo`80
00000`3oool00`000000oooo0?ooo`0d0?ooo`030;:d_`20P800oooo0080
00000P3oool01@000000oooo0?ooo`3oool0000003L0oooo00<0P8200?oo
o`0000000`3oool01@000000oooo0?ooo`3oool0000003L0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM
^@2b];l0000000<0oooo00D000000?ooo`3oool0oooo0000000f0?ooo`04
0;:d_`20P800oooo000000<0oooo00D000000?ooo`3oool0oooo0000000g
0?ooo`030820P03oool0000000L0oooo00<000000?ooo`3oool0=@3oool0
1@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0Oifi0;:d_`3oool0100000030?ooo`030000003oool0oooo03@0oooo
00@0/[Bo0820P03oool000000`3oool01@000000oooo0?ooo`3oool00000
03L0oooo00<0P8200?ooo`0000001`3oool00`000000oooo0?ooo`0e0?oo
o`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP1oWKT0/[Bo000000030?ooo`050000003oool0oooo0?ooo`000000
=P3oool00`2b];l0P8200?ooo`0200000080oooo00D000000?ooo`3oool0
oooo0000000g0?ooo`030820P03oool0000000<0oooo00D000000?ooo`3o
ool0oooo0000000g0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo0?ooo`0300000080oooo00<0
00000?ooo`000000=P3oool01@2b];l0P8200?ooo`000000oooo00800000
0P3oool00`000000oooo0000000g0?ooo`030820P03oool0oooo00<00000
0P3oool00`000000oooo0000000g0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo1`3oool20000
03H0oooo00@0/[Bo0820P03oool000001P3oool2000003L0oooo00<0P820
0?ooo`3oool01P3oool2000003L0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l80?ooo`030000
003oool0oooo03@0oooo00@0/[Bo0820P03oool000001`3oool00`000000
oooo0?ooo`0e0?ooo`030820P03oool0oooo00L0oooo00<000000?ooo`3o
ool0=@3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001P1VIWh0
nocm0:RY^`1VIWh0Oifi0;:d_cl0oooo00<0/[Bo0820P03oool0@03oool0
0`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo?`3oool00`2b];l0P820
0?ooo`100?ooo`030820P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0
Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@2b];lo0?oo
o`030;:d_`20P800oooo0400oooo00<0P8200?ooo`3oool0?`3oool01@20
P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0440/[Bo00<0P8200?ooo`3oool0?`3oool00`20P800oooo0?ooo`0o
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0@@1aKf@00`3Pgn<0LFmT075_I00o075_I0030>3Oh`1a
Kf@0LFmT03l0LFmT00D0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000H0
IVIn0?_lo@2XZK/0IVIn07nM^@3ooolo09fMX@03075_I03Pgn<0oooo03l0
WIfQ00<0LFmT0>3Oh`3oool0?`2MWJ401P1aKf@0h=oS07nM^@1VIWh0Z:Vk
0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80?@3P
gn<01@2MWJ40LFmT0>3Oh`3oool0lNoR03d0h=oS00D0WIfQ075_I03Pgn<0
oooo0?7_hP0m0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR03d0h=oS00D0
WIfQ075_I03Pgn<0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3a
kn80?@3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0m0>3Oh`0509fMX@1a
Kf@0h=oS0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR03d0
h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1V
IWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3O
h`3oool0lNoR03d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0m0>3Oh`07
09fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn07nM^@3oool0lNoR01@0h=oS00<000000>3Oh`3Pgn<00`3P
gn<00`000000h=oS0>3Oh`0P0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80
5@3Pgn<5000002<0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0G0>3Oh`<0
00008`3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0D0>3Oh`030000003P
gn<0h=oS00<0h=oS00<000000>3Oh`3Pgn<0803Pgn<01@2MWJ40LFmT0>3O
h`3oool0lNoR01D0h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`000000h=oS
0>3Oh`0P0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn805P3Pgn<01@000000
h=oS0>3Oh`3Pgn<000000280h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2X
ZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80
5@3Pgn<5000002<0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0E0>3Oh`03
0000003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<0803Pgn<01@2MWJ40
LFmT0>3Oh`3oool0lNoR01D0h=oS00<000000>3Oh`3Pgn<09@3Pgn<01`2M
WJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP1oWKT0oooo0?7_hP0E0>3Oh`050000003Pgn<0h=oS0>3Oh`00
00008`3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR01D0h=oS00<000000>3O
h`3Pgn<00P3Pgn<00`000000h=oS0>3Oh`0P0>3Oh`0509fMX@1aKf@0h=oS
0?ooo`3akn805@3Pgn<00`000000h=oS0>3Oh`0U0>3Oh`0709fMX@1aKf@0
h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
07nM^@3oool0lNoR01H0h=oS00<000000>3Oh`000000903Pgn<01@2MWJ40
LFmT0>3Oh`3oool0lNoR01D0h=oS1@00000S0>3Oh`0509fMX@1aKf@0h=oS
0?ooo`3akn805@3Pgn<00`000000h=oS0>3Oh`0U0>3Oh`0709fMX@1aKf@0
h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
07nM^@3oool0lNoR01H0h=oS00<000000>3Oh`000000903Pgn<01@2MWJ40
LFmT0>3Oh`3oool0lNoR01D0h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`00
0000h=oS0>3Oh`0P0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn805@3Pgn<0
0`000000h=oS0>3Oh`0U0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR01H0
h=oS00<000000>3Oh`000000903Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR
01D0h=oS00<000000>3Oh`3Pgn<00P3Pgn<00`000000h=oS0>3Oh`0P0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn805P3Pgn<01@000000h=oS0>3Oh`3P
gn<000000280h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn805`3Pgn<00`00
0000h=oS0>3Oh`0S0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn805@3Pgn<5
000002<0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0G0>3Oh`<000008`3P
gn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS
0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR03d0h=oS00L0
WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm
0:RY^`1VIWh0Oifi0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0
lNoR03d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0m0>3Oh`0709fMX@1a
Kf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0
IVIn07nM^@3oool0lNoR03d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0m
0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80?@3Pgn<01`2MWJ40LFmT0>3O
h`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1o
WKT0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80?@3Pgn<0
1@2MWJ40LFmT0>3Oh`3oool0lNoR03d0h=oS00L0WIfQ075_I03Pgn<0Oifi
06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi0?oo
och0lNoR00@0WIfQ075_I03Pgn<0oooo?P3akn80102MWJ40LFmT0>3Oh`3o
ooln0?7_hP0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@100?ooo`03075_I03Pgn<0oooo03l0
oooo00<0LFmT0>3Oh`3oool0?`3oool01P1aKf@0h=oS07nM^@1VIWh0Z:Vk
0?_lo@40IVIn0000101VIWh0nocm0:RY^`1VIWk807nM^@0306IVOP2XZK/0
nocm0040IVIn00000`1VIWh0moOi09RHY`3:07MgTP40V9RW0@3gmoT106IV
OP0000<0IVIn0?Ogn@2l_Ld0b`2l_Ld10?Ogn@40IVIn00000`1VIWh0moOi
0>CSh`3;0>CSh`40moOi0@1VIWh0000306IVOP3`lO@0oooo08@0oooo00<0
i>?S09bT^@1[MHl00`1[MHl0101/MY00JgF?06afT01/MY0906]eS`0609bT
^@3Thn<0oooo0?ooo`3Thn<0W:Bi101[MHl0101/MY00JgF?06afT01/MY09
06]eS`0609bT^@3Thn<0oooo0?ooo`3/j^X0W:Bi102V>D@0102W>T@0YSU4
0:LjA02W>T@90:HiA00309bT^@3/j^X0oooo00<0oooo0@3`lO@106IVOP00
01H0IVIn0>;QhP3ko?`0no_l0?_lo@3lnod0no_m0?_lo@3ko?`0o?cm0?cl
o03lnod0o?cl0?cko03lo?`0nocl0?clo03ko?d0o?_l0?clo@3knod0nocl
0P3lo?`0103lo?d0o?cl0?_ko@3lo?d`0?cko340nocl2P3ko?d00`2LY;T0
JgF?08F9/00@08F9/00606]eS`2LY;T0nocm0?_lo@2LY;T0JgF?4@25RK00
1P1[MHl0W:Bi0?_lo03kno`0W:Bi0:HiA140ZSaE00L0YSU409bT^@3ko?`0
o?cl0?cko@3ko?d0h^7R0040IVIn0000101VIWh0h>3Q0?Kgn@3gmoT20?Kg
n@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Ogn@3f
moT00P3gmoT0103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0moOi
02l0moOi<@3fmoT:0?Ogn@0306]eS`25RK00W9jn0100W9jn00H0QHV`06]e
S`3gmoT0moOi06]eS`25RK0A09bN_P0808F9/01[MHl0m_Oh0?Ogn02V>D@0
ZSaE0<9BF`36E5X=0<IEG0090<IDFP32DU/0ZSaE0:HiA03gmoP0moOi0?Og
n03gmoT0h>3Q0040IVIn00001P1VIWh0g]gQ0?7am03alO@0l?7d0?3bm100
000000H0lO7d0?3bm@3alO@0lO;d0?3bm03alOAQ0?3am@X0l?7d00<0JgF?
0;:ed02WZ<80402WZ<801P2b]M00JgF?0?3am03`lO@0JgF?0;:ed140YjS2
00D0/[G@06]eS`3`lOD0lO;d0:HiA0020<9BF`030<]DF@3=FEh0cEUN00/0
cEUN00@0beAI0<9BF`32DU/0YSU40P3`lO@00`3alO@0l?;d0=kMh@0106IV
OP0000L0IVIn0=cKh03Zjo00j^_`0>[/l03Yjnl000000080inOW0P3Ng]h2
0>OWi`030>NmQ03WinL0inOW00<0inOW0P3_knl010000000j^_`0>[[l03Z
jnl20>[[l0030>[[k`3Zjo00j^_`02h0j^_`<@3Zk?0:0>[[k`0406]eS`2f
^M40[Jk60:f^aPP0oooo00<0[Jk60:b^aP2][/H00`2][/H00`2/[/H0][WA
06]eS`020>[[k`0406]eS`2f^M40[Jk60:f^aP`0oooo0P2][/H00`2/[/H0
][WA06]eS`020>[[l0050:HiA03=FEh0beAI0<eFF`3>FEl02`3@FUl01`3>
FEl0cEIK0<]DF@3=FEh0YSU40>[[k`3Zjo000P3Zjnl10=cKh040IVIn0000
101VIWh0fMWO0>?UjP3Si>X20>?Uj`050000002<S8`0g]kN0>OWi`3Ng]h0
0P3WinL00`36H`00inOW0>OWi`020>OWi`070>o_i`3_knl0kno_0000003S
i>X0hnC[0>?UjP020>?TjP030>?Tj`3SiN/0hnG[02h0hnG[<@3Si>X:0>?U
jP0506]eS`2l_]@0/[;:0;:bbP3oool01P1^KHl00`0U9CH0/[;:0;:bbP05
0;:bbP060;bne01[MHl0hnGZ0>?UjP1[MHl0_;kD0P2b//X00`3oool09BDf
02DU=P0902DU=P<0/[;:00D0_;kD06]eS`3Si>/0hnC[0:HiA0020<eIGP04
0=1KH03DG5l0oooo0?ooo`L0e5aO0P3oool02P3DG5l0d5]P0<eIGP3=FEh0
YSU40>?TjP3SiNX0hnCZ0>?Uj`3IfMl106IVOP0000<0IVIn0=OHgP3Lg^H0
0`3Lg^H01@000000inOW0>OWi`3WinL0imK>0080inOW00D0cW/00>nD403W
inL0imk60>n<40030>o_k`070000003Lg^H0g=kU0=cNi@3Lg^H0g=kU0=cN
iP1[0=cNi@0506]eS`2o`MH0^;W>0;RicP3oool01P1^KHl00`0U9CH0^;W>
0;RicP050;RicP060;o1eP1[MHl0g=kU0=cNi@1[MHl0_l7F0P2h^Lh00`3o
ool09BDf0;RicP070;RicP030?ooo`0U9CH0^;W>0080^;W>00T0_l7F06]e
S`3Lg^H0g=kU0:HiA03=FEh0dEYN0=AMH@1C9B000`3oool50=IOH`<0oooo
00D0DbDP0=AMH@3AFUh0cEUN0:HiA0020=cNi@030=cNiP3Lg^D0emSN0040
IVIn0000101VIWh0eMKM0=GHh03Ff>420=GHh0090000002<S8`0inOW0>OW
i`3W]H@0eUX00=J4003ocP00cV<00080gV/000D0kkF<0>o_k`3_knl0kno_
000000020=GHh@040=GGh03Ff>00e]SQ0=KGhC00e]OP<@3Ff>0:0=GHh@05
06]eS`33aMT0_;gA0;bmd@3oool01`0U9CH70;bmd@060<?5f@1[MHl0eMSQ
0=GHh@1[MHl0`lGI0P2l_M400`3oool09BDf0;bmd@070;bmd@030?ooo`0U
9CH0_;gA0080_;gA00D0`lGI06]eS`3Fen00eMOQ0:HiA0020=EMH0030=QP
H@3IHF80AQhJ00<0oooo0`3IHF830?ooo`0304HN6P3IHF80f61Q0080eEeP
00H0YSU40=KHh03Ef>40eMOP0=GHh@3Ee]d106IVOP0000L0IVIn0=;Dg@3?
d]`0d=;L0=3Bg@3@d]`0000000<0inOW00`0imk>0<I:003gcP00kjd00>ne
003>J`00aUX00<I[003NS4X0ijD00>oWcP0000030=3Bg0030<oBg03@d]`0
cm;L0300d=;L<@3?d]d:0=3Bg00306]eS`38bM/0`lCF0100`lCF00H0b<WK
06]eS`3@d]`0d=;L06]eS`38bM/20<?4eP030?ooo`0U9CH0`lCF00L0`lCF
00<0oooo02DU=P33a=H00P33a=H01`38bM/0JgF?0<oBg03?d]`0YSU40=MO
G`3IHF800`3LIFD01@167QX0oooo0?ooo`3oool0g6EU00<0oooo00P0AQhJ
0=aUI@3LIFD0g6EU0=UQHP3GGel0YSU40=3Bg@80d=;L0@3?d]`10=;Dg@40
IVIn0000701VIWh0d=;K0<_=f03:cMT0blkH0<[=f0000000ilJ]0>O6S03g
cQP0kkd00?O6003_[@00ijd00>NU003FS000cV/00>O6003oeP00knoW0>o_
k`000000blgH0<_=f@3:cMT0blkH0<[=f03;cMP`0<_=fC40blkI2P3;cMP0
0`1[MHl0blcN0<S:f@080<S:f@030<S9f@38b]T0b<[I00<0b<[I00@0b<WI
0<S:f@3;c=h0JgF?0P3;cMP01P1[MHl0blcN0<S:f@38b]T0oooo02DU=PD0
b<[I0140b<WI0<S:f@38b]T0oooo02DU=P38b]T0b<WI0<S:f@3;c=h0JgF?
0<_>f03:cMP0YSU40=MOG`3KI6@0h6MU0>1VI@020=iWI`0304HN6P3oool0
oooo00<0oooo00X0AQhJ0=iWI`3NIfL0h6IU0>1WI@3KI6@0eemO0:HiA03:
c]P0b/kI0P3;cMT10=3Bf`40IVIn00000`1VIWh0cloJ0<G8e0030<G8e006
00000036a/H0imkF0<ik003W[@00kkD00P3WY@000`3FU000cW<00=JD0002
0?O60080moOg00@000000<G8e035am@0aLOD0`35amD`0<C7eC40a<SD2P34
am@00`1[MHl0d=7P0<_;g00@0<_;g0060=3Ah01[MHl0a<OD0<C7e01[MHl0
d=7P0P3;bm`00`3oool09BDf0<_;g0070<_;g0030?ooo`0U9CH0bl_L0080
bl_L00L0d=7P06]eS`35am@0a<OD0:HiA03KI6@0gfET00D0h6YX00D0AQhJ
0?ooo`3oool0oooo04HN6P050>1ZJ0040=mUI03KI6@0YSU40<C8e@80a<SD
0@35amD10<o?fP40IVIn0000101VIWh0c<kJ0<;4dP31a=420<74dP060000
003WinL0inOW0>OWi`3FQ000kkD00P3WY@00203FQ000cV/00>N]003g]@00
mkd00>o_k`3gmoL000000`31a=800`32a=40`LCB0<74dP0`0<74dC40`LCB
2P32a=800`1[MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0`/CB0<;4dP1[
MHl0dm?R0P3?d=d00`3oool09BDf0<o@g@070<o@g@030?ooo`0U9CH0cm3M
0080cm3M00L0dm?R06]eS`32a=80`LCA0:HiA03KI6@0hFUU00D0h6aY1@3o
ool50>1/J@080>5YI@3KI6@0YSU40<74dP32a=40`LCA0<74dP3<c]X106IV
OP0000@0IVIn0<[<f02n`<l0_L3?0P2n`<h01@000000W9bL0>OWi`3Wg]H0
eX`00080gY@000@0eW/00<IS002m@P00kjD00P3g[@00203g]@00oli:0000
002n`<h0_/3?0;k0cP2n`<l0_L3><@2n`<ha0;g0cPX0_/3>00<0JgF?0=KF
i03Cdn00403Cdn001P3Fe^@0JgF?0;k0cP2n`<h0JgF?0=KFi080dm?P00<0
oooo02DU=P3oool0203oool02`0U9CH0dm?P0=?Ch03Cdn00e]KT06]eS`2n
`<l0_/3>0:HiA03PIVD0hFYZ00@0hfa/0`3oool010167QX0oooo0?ooo`3o
ool40>=/K0040>5ZJP3PIVD0YSU40;g0c`80_/3?0@2n`<h10<[<f040IVIn
00001`1VIWh0bL[H0;Jhb02i_</0^[c;0;Zlc00000000P3_knl04`3FW000
eX`00=jD003FQ000kjD00=j<002mFP00eW<00>nL003gknL0moOg0?ooo`00
0000^Kc<0;Zkc02i_</0^[c;0;Vlc02i_</0<02i_<`a0;Zlc0X0^[c;00<0
JgF?0=SHi@3Cdn40403Cdn401P3Hf>D0JgF?0;Zlb`2j_</0JgF?0=SHi@80
dm?Q00<0oooo06i]S`1^KHl0201^KHl03P0U9CH0dm?Q0=?Ch@3Cdn40f=SU
06]eS`2j_</0^[c<0:HiA03PJFP0hFe/0>AaK@3TLFl0i71^0`3oool00`16
7QX0i71^04HN6P030?ooo`80i71^00T0i75]0>5]K03PJFP0YSU40;Zlc02j
^l`0^Kc;0;Jhb039b]P00@1VIWh0000906IVOP37bML0];K70;Jhb02f^<T0
][W900000024Q8@0inON0080kno_00L0aV/00?O6003_]@00ki`00=j<003>
J`00ii`000<0moOg00D000000;Jib@2g^<T0][W90;Nib@020;JhbC00]kS9
<@2f^<T:0;Nhb@0406]eS`3Fe^@0f=SU0=SHiP<0f=SU1@3Hf>H30=SHi@80
f=SV0P3Hf>D02@3Fe^@0JgF?0;Nhb@2g^<T0JgF?0=KFi03Hf>D0f=SV0?oo
o`0:06i]S`0=02DU=P3Hf>H0f=SU0=SHi@3Fe^@0JgF?0;Nhb@2g^LT0YSU4
0>A^K@3TM6l0ig5_0>AdK`030?ooo`0504HN6P3TM6l0i7A_0>AdK`167QX0
0`3oool02P3TM6l0ig5_0>AdK`3TKVd0YSU40;Jib@2f^<T0][W90;Bfa`37
bML106IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L00`000000kno_0>o_k`02
0>o_k`0;0>N]003gaPP0ijD00>ND003WS000knOF0=jD>@3_e[D0ooOg0?oo
o`000000L@2d]/L01@1[MHl0eMGS0=cKi`3LfnL0gM_W00h0g=_W00H0eMGS
06]eS`2d]/L0];K706]eS`3EeN<20=cKi`030=gKi`0U9CH09BDf00T09BDf
0`3LfnL02@3EeN<0JgF?0;Bfa`2d]/L0YSU40>McK`3WMG80jWIc0>YhMP02
0?ooo`0304HN6P3YOWP0jGih00<0jGih00P0AQhJ0?ooo`3oool0jWQf0>Yf
L`3WMG80ig=_0:HiA0@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2d]/L0
0`2d]/L01P000000S8b<0>o_k`3_knl0ilik0>o_k`80moOg00P0ii@00?OW
cP3gmoL0moOg0>oWeP3gmoL0oooo00000740];K700<0JgF?0=GDh`3PgnX0
403PgnX01P3Ee><0JgF?0;Bfa`2d]/L0JgF?0=GDha40h=oZ00T0eMCS06]e
S`2d]/L0];K70:HiA03ZNG<0jGah0>n1NP3bRH400P167QX01`3[V8/0jY^<
0>fGRP3[V8/0jY^<0>fGRP3[V8/00P167QX01@3bRH40kh5j0>UlN03ZNG<0
YSU400@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2a/lP00`2a/lP01P00
0000kno_0>o_k`3_knl0moO_0>o_k`80moOg00<0mnO60?Ogm`3oool00`3g
moL00`3oool000000;6cb01`0;6cb00306]eS`3]jo<0jNSa0100jNSa00H0
kN_c06]eS`2a/lP0/K?806]eS`3]jo<A0>WXl@0I0>g[l`1[MHl0/K?80;6c
b02V>D@0lH1e0?24O03eS8@0mif>0?:[UP3a/Y/0kKBK0>beW03a/Y/0kKBK
0>beW03a/Y/0kKBK0>beW03bZiH0mif>0?F<Q03`Q7`0lH1e0:HiA0040;6c
b040a/SG0@1VIWh0000306IVOP36b=L0^;O?00<0[jk700D000000:f][@3g
mnl0moOg0>o_k`060?Ogm`80ooOg0P3oool00`000000[jk70:n^a`1_0:n^
a`0306]eS`3BdN<0l_7g0100l_7g00H0d]7S06]eS`2_[/L0[jk706]eS`3B
dN<A0?;am`060=;Ah`1[MHl0[jk70:n^a`2V>D@0m8Ym0P3eT8D=0?:hWP80
mI2500<0m8Ym0:HiA02_[/L00P2_[/L10;Rgc`40a/SG0@1VIWh0000306IV
OP30`M40alOD08@0[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0
c<_M06]eS`24S:820:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l
0<c;g@1[MHl0Q8bR0P2/Zl@01`2AV:X0YSU40?nOS@3n_j@0n]bg0?[[]`3j
jKH00P3ijKH0103jjKH0nNVf0?WY]P3jjKH20?WY]P060?[[]`3jg;L0o[nT
0?nOS@2V>D@0TIRZ0`2/Zl@10<O7e040`<7A0@1VIWh0000406IVOP30`M40
d];O0;FdbH@0Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS
_P020:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2T
Xkh00`24S:80YSU40:HiA00?0:HiA00708B<XP2TXkh0Y:>n0:BS_P2e]<T0
d];O0<31d@0106IVOP0000H0IVIn0:RW_`3Vi^d0d];P0;blc`2a/<C40:RW
_`050;6`a02l_<l0d];P0>KVk@2XYkl00@1VIWh0000705QGJ027Qi/0emSR
0?clo03ThnP0d=3P0<[:fP320;blc`060<[:fP3@d>00i>?X0?clo03Gf>80
QhNK0@1HEfP0000805QGJ01VIWh0UIB[0=OHhP3lo?`0l_7c0>c[kP3Qh^_0
0=OHhP070>7Rj`3/jnh0l_7c0?clo03Gf>80UIB[06IVOP0105QGJ0000P1H
EfP00`1VIWh0UIB[0=7AgP020?clo<80oooo0P3lo?`00`3AdMh0UIB[06IV
OP0205QGJ0000`1HEfP206IVOP0308R7W@2EU:/0Z:No0<40Z:No00@0UIB[
08R7W@1VIWh0IVIn0`1HEfP000D0F5MXaP1VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[5]:=",
  Evaluatable->False,
  ImageSize->{208, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Table"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[5]=",
  CellTags->"Table"]
}, Open  ]],

Cell[TextData[{
  "We can set and get the entire table contents using the ",
  StyleBox["\"items\"", "MR"],
  " property as well as set and get individual rows using the indexed ",
  StyleBox["\"item\"", "MR"],
  " property."
}], "Text",
  CellTags->"Table"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\ @\ PropertyValue[{"\<myTable\>", \ "\<items\>"}]\)], "Input",
  CellLabel->"In[6]:=",
  CellTags->"Table"],

Cell[BoxData[
    \({{"a1", "b1", "c1"}, {"a2", "b2", "c2"}}\)], "Output",
  CellLabel->"Out[6]=",
  CellTags->"Table"]
}, Open  ]],

Cell["\<\
By default, most data stored in tables will be strings and left aligned \
within the cells.  However, it is possible to store, display, and retrieve \
boolean, numbers, and images within table columns with more native controls \
using checkboxes, right-aligned text, and images, respectively. See the Table \
Cell Supported Datatypes section for a more detailed explanation with \
examples.\
\>", "Text",
  CellTags->"Table"],

Cell[BoxData[
    \(ref\ @\ 
      SetPropertyValue[{"\<myTable\>", \ "\<items\>"}, \[IndentingNewLine]\ 
        Table[ToString[{i, j}], {i, 1, 4}, {j, 1, 3}]]\)], "Input",
  CellLabel->"In[7]:=",
  CellTags->"Table"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[8]:=",
  CellTags->"Table"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003@0000T2000`400?l0
0000o`00003od01VIWh0000306IVOP3ko?d0nocm0<`0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0</0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
bP1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO/P0Oifi
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS
00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM
^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0
h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`04
07nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3O
h`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0aP20P800101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn07nM^@110?ooo`030820P03oool0oooo03l0oooo
00<0P8200?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040
IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi00<0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02H0
oooo00D0P8200?ooo`3oool0oooo000000080?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool09P3oool01@20P800oooo0?ooo`3oool0
000000P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0V
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?oo
o`0000090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
9@3oool01020P800oooo0?ooo`0000090?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool09@3oool01@20P800Oifi06IVOP2XZK/0nocm
0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?oo
o`3oool00`3oool01@000000oooo0?ooo`3oool0000000H0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0
oooo000000D0oooo00D000000?ooo`3oool0oooo000000040?ooo`D00000
0`3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000D0
oooo00D000000?ooo`3oool0oooo000000050?ooo`<00000103oool00`00
0000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000D0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo02D0oooo00@0P8200?ooo`3oool000001@3oool00`000000oooo
0?ooo`060?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`050000
00T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?oo
o`040820P03oool0oooo00000080oooo1@0000090?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`00
00020?ooo`D000002`3oool01@000000oooo0?ooo`3oool0000002L0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0
IVIn07nM^@3oool0000000<0oooo00@000000?ooo`3oool000002P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo02@0oooo00<0P820
0?ooo`0000000`3oool010000000oooo0?ooo`00000;0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0903oool00`20P800oooo0000
00030?ooo`040000003oool0oooo000000`0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0T0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool01`000000
oooo0?ooo`3oool000000?ooo`0000002P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo02D0oooo00@0P8200?ooo`3oool000000`3o
ool00`000000oooo0000000<0?ooo`050000003oool0oooo0?ooo`000000
9`3oool01020P800oooo0?ooo`0000030?ooo`030000003oool0000000X0
oooo0P0000040?ooo`030000003oool0oooo02D0oooo00D0P82007nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?oo
o`070000003oool0oooo0?ooo`000000oooo000000080?ooo`030000003o
ool0000000D0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?oo
o`0000030?ooo`030000003oool0000000`0oooo00D000000?ooo`3oool0
oooo0000000W0?ooo`040820P03oool0oooo000000<0oooo00<000000?oo
o`000000303oool01@000000oooo0?ooo`3oool0000002L0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@020?ooo`030000003oool0oooo0080oooo0P0000090?ooo`8000001@3o
ool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000@0oooo
0P0000080?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`0U0?ooo`040820P03oool0oooo000000@0oooo0P0000080?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT00`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0V0?ooo`050820P03oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`070?ooo`<000000`3oool00`000000oooo0?ooo`0V0?ooo`050820
P03oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`070?ooo`<0
00000`3oool00`000000oooo0?ooo`0V0?ooo`050820P01oWKT0IVIn0:RY
^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0@@3oool00`20
P800oooo0?ooo`0o0?ooo`030820P03oool0oooo03l0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@11
0?ooo`030820P03oool0oooo03l0oooo00<0P8200?ooo`3oool0?`3oool0
1@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1V
IWh0Oifi0440oooo00<0P8200?ooo`3oool0?`3oool00`20P800oooo0?oo
o`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1oWKT0@@3oool00`20P800oooo0?ooo`0o0?ooo`030820
P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@360820P00407nM^@1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0440oooo00<0P8200?oo
o`3oool0?`3oool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool09P3oool01@20P800oooo0?ooo`3oool0000000P0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0V0?ooo`050820P03o
ool0oooo0?ooo`000000203oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo02H0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0U0?ooo`04
0820P03oool0oooo000000T0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000T0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0
IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3o
ool010000000oooo0?ooo`3oool3000000<0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02D0oooo
00@0P8200?ooo`3oool000000`3oool3000000<0oooo00<000000?ooo`3o
ool00P3oool5000000<0oooo00<000000?ooo`3oool09@3oool01020P800
oooo0?ooo`0000030?ooo`<000000`3oool00`000000oooo0?ooo`030?oo
o`<00000103oool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?ooo`040820P03o
ool0oooo00000080oooo00D000000?ooo`3oool0oooo000000080?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool09@3oool01020P800
oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000001`3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool09@3o
ool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0Oifi0080oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
9@3oool01020P800oooo0?ooo`0000060?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?ooo`04
0820P03oool0oooo000000H0oooo00<000000?ooo`3oool02@3oool01@00
0000oooo0?ooo`3oool0000002L0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000L0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo02@0oooo00<0P8200?ooo`0000001`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
903oool00`20P800oooo000000070?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0T0?ooo`050820
P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT00P3oool00`000000oooo0?ooo`020?ooo`8000002P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo02D0oooo00@0P8200?ooo`3o
ool00000103oool2000000`0oooo00D000000?ooo`3oool0oooo0000000W
0?ooo`040820P03oool0oooo000000@0oooo0P00000:0?ooo`800000103o
ool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`000000
1@3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000H0
oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool00000
02L0oooo00@0P8200?ooo`3oool000001P3oool00`000000oooo0?ooo`09
0?ooo`050000003oool0oooo0?ooo`0000009`3oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`060?ooo`80
00001@3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo0000
0080oooo00D000000?ooo`3oool0oooo000000070?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U0?ooo`040820P03o
ool0oooo00000080oooo00D000000?ooo`3oool0oooo000000070?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U0?oo
o`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT00`3oool00`000000oooo0?ooo`03000000X0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0V0?ooo`050820P03oool0
oooo0?ooo`0000000P3oool3000000T0oooo0`0000030?ooo`030000003o
ool0oooo02H0oooo00D0P8200?ooo`3oool0oooo000000020?ooo`<00000
2@3oool3000000<0oooo00<000000?ooo`3oool09P3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0440
oooo00<0P8200?ooo`3oool0?`3oool00`20P800oooo0?ooo`0o0?ooo`05
0820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0@@3oool00`20P800oooo0?ooo`0o0?ooo`030820P03oool0oooo
03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@110?ooo`030820P03oool0oooo03l0oooo00<0P820
0?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0440oooo00<0P8200?ooo`3oool0?`3o
ool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP20P800101oWKT0IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@110?ooo`03
0820P03oool0oooo03l0oooo00<0P8200?ooo`3oool0?`3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo02H0oooo00D0P8200?ooo`3oool0oooo00000008
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool09P3oool0
1@20P800oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0V0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
9@3oool01020P800oooo0?ooo`0000090?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`0000090?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool09@3oool01@20
P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0080oooo00<000000?ooo`3oool01@0000020?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0U
0?ooo`040820P03oool0oooo00000080oooo1@0000020?ooo`030000003o
ool0oooo0080oooo1@0000030?ooo`030000003oool0oooo02D0oooo00@0
P8200?ooo`3oool000000P3oool500000080oooo00<000000?ooo`3oool0
0`3oool3000000@0oooo00<000000?ooo`3oool09@3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080
oooo00D000000?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`000003
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000<0oooo00<0
00000?ooo`3oool0203oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool09@3oool01@20P800Oifi06IVOP2XZK/0nocm0040
IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`0000040?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000@0oooo00<00000
0?ooo`3oool02`3oool01@000000oooo0?ooo`3oool0000002L0oooo00D0
P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
07nM^@3oool0000000H0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo02@0oooo00<0P8200?ooo`00
00001P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0903oool00`20P800oooo000000060?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0T0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000H0oooo00<00000
0?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000002L0oooo00@0
P8200?ooo`3oool000001P3oool00`000000oooo0?ooo`070?ooo`800000
103oool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`00
00001@3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo0000
00H0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0
000002L0oooo00@0P8200?ooo`3oool000001P3oool00`000000oooo0?oo
o`090?ooo`050000003oool0oooo0?ooo`0000009`3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`060?oo
o`8000001@3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo
00000080oooo00D000000?ooo`3oool0oooo000000070?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U0?ooo`040820
P03oool0oooo00000080oooo00D000000?ooo`3oool0oooo000000070?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT00`3oool00`000000oooo0?ooo`03000000X0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0V0?ooo`050820P03o
ool0oooo0?ooo`0000000P3oool3000000T0oooo0`0000030?ooo`030000
003oool0oooo02H0oooo00D0P8200?ooo`3oool0oooo000000020?ooo`<0
00002@3oool3000000<0oooo00<000000?ooo`3oool09P3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0440oooo00<0P8200?ooo`3oool0?`3oool00`20P800oooo0?ooo`0o0?oo
o`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT0@@3oool00`20P800oooo0?ooo`0o0?ooo`030820P03oool0
oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn07nM^@110?ooo`030820P03oool0oooo03l0oooo00<0
P8200?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0440oooo00<0P8200?ooo`3oool0
?`3oool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP20P800101oWKT0
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@110;:d
_`030820P03oool0oooo03l0oooo00<0P8200?ooo`3oool0?`3oool01@20
P800Oifi06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0
Oifi0;:d_`80oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo02D0oooo00<0/[Bo0820P03oool00P3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool09P3oool01@20P800oooo0?ooo`3oool0000000P0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0V0?ooo`050820
P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1o
WKT0/[Bo0?ooo`0000090?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool0903oool01@2b];l0P8200?ooo`3oool0000000T0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0U0?ooo`040820P03o
ool0oooo000000T0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000806IV
OP3ko?d0Z:Vk06IVOP1oWKT0/[Bo0?ooo`0000040?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo02@0oooo00D0/[Bo0820P03oool0oooo0000
00040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3o
ool5000000<0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?oo
o`0000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
0`3oool3000000@0oooo00<000000?ooo`3oool09@3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0Oifi0;:d
_`3oool00000103oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0903oool01@2b];l0P8200?ooo`3o
ool0000000@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo02D0oooo00@0P8200?ooo`3oool00000
103oool00`000000oooo0?ooo`070?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY
^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo0?ooo`00
00040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0T0?ooo`050;:d_`20P800oooo0?ooo`000000
103oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`0000040?ooo`03
0000003oool0oooo00/0oooo00D000000?ooo`3oool0oooo0000000W0?oo
o`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP1oWKT0/[Bo000000050?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0S0?ooo`040;:d_`20
P800oooo000000D0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo02@0oooo00<0P8200?ooo`000000
1@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0903oool01@20P800Oifi06IVOP2XZK/0nocm0040
IVIn0000201VIWh0nocm0:RY^`1VIWh0Oifi0;:d_`3oool00000103oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0903oool01@2b];l0P8200?ooo`3oool0000000@0oooo00<0
00000?ooo`3oool02`3oool01@000000oooo0?ooo`3oool0000002L0oooo
00@0P8200?ooo`3oool00000103oool00`000000oooo0?ooo`090?ooo`80
0000103oool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY
^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo0?ooo`00
00020?ooo`030000003oool0000000T0oooo00<000000?ooo`0000001@3o
ool00`000000oooo0?ooo`0T0?ooo`050;:d_`20P800oooo0?ooo`000000
0P3oool00`000000oooo0000000=0?ooo`050000003oool0oooo0?ooo`00
00009`3oool01020P800oooo0?ooo`0000020?ooo`030000003oool00000
00d0oooo00D000000?ooo`3oool0oooo0000000W0?ooo`050820P01oWKT0
IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo
0?ooo`0000030?ooo`8000002P3oool2000000D0oooo00<000000?ooo`3o
ool0903oool01@2b];l0P8200?ooo`3oool0000000<0oooo0P0000090?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U
0?ooo`040820P03oool0oooo000000<0oooo0P0000090?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U0?ooo`050820
P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1o
WKT0/[Bo0P3oool01@000000oooo0?ooo`3oool0000000/0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0U0?ooo`030;:d_`20P800
oooo0080oooo00D000000?ooo`3oool0oooo0000000:0?ooo`<000000`3o
ool00`000000oooo0?ooo`0V0?ooo`050820P03oool0oooo0?ooo`000000
0`3oool00`000000oooo0?ooo`080?ooo`<000000`3oool00`000000oooo
0?ooo`0V0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000606IV
OP3ko?d0Z:Vk06IVOP1oWKT0/[Bo?`3oool00`2b];l0P8200?ooo`100?oo
o`030820P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@2b];lo0?ooo`030;:d_`20
P800oooo0400oooo00<0P8200?ooo`3oool0?`3oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi0;:d_cl0
oooo00<0/[Bo0820P03oool0@03oool00`20P800oooo0?ooo`0o0?ooo`05
0820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0@@2b];l00`20P800oooo0?ooo`0o0?ooo`030820P03oool0oooo
03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@11075_I0030>3Oh`1aKf@0LFmT03l0LFmT00<0h=oS
075_I01aKf@0?`1aKf@01@3Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn0000
1P1VIWh0nocm0:RY^`1VIWh0Oifi0?ooocl0WIfQ00<0LFmT0>3Oh`3oool0
?`2MWJ400`1aKf@0h=oS0?ooo`0o09fMX@06075_I03Pgn<0Oifi06IVOP2X
ZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0m
0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3O
h`3oool0lNoR03d0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm
0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80?@3Pgn<0
1@2MWJ40LFmT0>3Oh`3oool0lNoR03d0h=oS00D0WIfQ075_I03Pgn<0oooo
0?7_hP0m0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR03d0h=oS00D0WIfQ
075_I03Pgn<0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80
?@3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh00007
06IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0
h=oS0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR03d0h=oS
00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0Oifi0?ooo`3akn80503Pgn<00`000000h=oS0>3Oh`03
0>3Oh`030000003Pgn<0h=oS0200h=oS00D0WIfQ075_I03Pgn<0oooo0?7_
hP0E0>3Oh`D000008`3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR01L0h=oS
0`00000S0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR01@0h=oS00<00000
0>3Oh`3Pgn<00`3Pgn<00`000000h=oS0>3Oh`0P0>3Oh`0509fMX@1aKf@0
h=oS0?ooo`3akn805@3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000003P
gn<0h=oS0200h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0F0>3Oh`050000
003Pgn<0h=oS0>3Oh`0000008P3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_
hP0E0>3Oh`D000008`3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR01D0h=oS
00<000000>3Oh`3Pgn<00P3Pgn<00`000000h=oS0>3Oh`0P0>3Oh`0509fM
X@1aKf@0h=oS0?ooo`3akn805@3Pgn<00`000000h=oS0>3Oh`0U0>3Oh`07
09fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn07nM^@3oool0lNoR01D0h=oS00D000000>3Oh`3Pgn<0h=oS
0000000S0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn805@3Pgn<00`000000
h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS0200h=oS00D0WIfQ075_I03P
gn<0oooo0?7_hP0E0>3Oh`030000003Pgn<0h=oS02D0h=oS00L0WIfQ075_
I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0Oifi0?ooo`3akn805P3Pgn<00`000000h=oS0000000T0>3Oh`0509fM
X@1aKf@0h=oS0?ooo`3akn805@3Pgn<5000002<0h=oS00D0WIfQ075_I03P
gn<0oooo0?7_hP0E0>3Oh`030000003Pgn<0h=oS02D0h=oS00L0WIfQ075_
I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0Oifi0?ooo`3akn805P3Pgn<00`000000h=oS0000000T0>3Oh`0509fM
X@1aKf@0h=oS0?ooo`3akn805@3Pgn<00`000000h=oS0>3Oh`020>3Oh`03
0000003Pgn<0h=oS0200h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0E0>3O
h`030000003Pgn<0h=oS02D0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2X
ZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80
5P3Pgn<00`000000h=oS0000000T0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3a
kn805@3Pgn<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS0200
h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0F0>3Oh`050000003Pgn<0h=oS
0>3Oh`0000008P3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0G0>3Oh`03
0000003Pgn<0h=oS02<0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0E0>3O
h`D000008`3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR01L0h=oS0`00000S
0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0
IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR03d0h=oS00D0WIfQ075_I03P
gn<0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80?@3Pgn<0
1`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS0?oo
o`3akn80?@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR03d0h=oS00L0WIfQ
075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY
^`1VIWh0Oifi0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR
03d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0m0>3Oh`0709fMX@1aKf@0
h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
07nM^@3oool0lNoR03d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0m0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn80?@3Pgn<01`2MWJ40LFmT0>3Oh`1o
WKT0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0
oooo?P3akn80102MWJ40LFmT0>3Oh`3oooln0?7_hP0409fMX@1aKf@0h=oS
0?oooch0lNoR00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0400oooo00<0LFmT0>3Oh`3oool0
?`3oool00`1aKf@0h=oS0?ooo`0o0?ooo`06075_I03Pgn<0Oifi06IVOP2X
ZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO/P0Oifi00<0IVIn0:RY
^`3ko?d00@1VIWh0000306IVOP3gmoT0V9RW0<X0MgNB0@2HV:L10?Ogn@40
IVIn00000`1VIWh0moOi0;bmc@3;0;bmc@40moOi0@1VIWh0000306IVOP3g
moT0i>?S0</0i>?S0@3gmoT106IVOP0000<0IVIn0?3am03oool0Q03oool0
0`3Thn<0W:Bi06]eS`0306]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0
W:Bi0>CSh`3oool0oooo0>CSh`2LY;T406]eS`0406afT01[MHl0K7J@06af
T0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>cZjP2LY;T40:HiA0040:LjA02V
>D@0YcY40:LjA0T0YSU400<0W:Bi0>cZjP3oool00`3oool10?3am040IVIn
00005P1VIWh0h^7R0?_lo03kno`0nocm0?cko@3knod0nocm0?_lo03lo?d0
o?cl0?cko@3lo?`0o?_l0?clo03ko?`0o?cl0?_lo@3lno`0o?cm0?_ko@3k
o?`20?clo0040?clo@3lo?`0no_m0?cloC00o?_l<@3ko?`:0?_lo@0309bT
^@1[MHl0QHV`0100QHV`00H0JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9
/00606]eS`2LY;T0nocl0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_l
o03lo?`0o?_m0?_lo@3RhN800@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80
m_Oi00/0m_Oh0?Ogn@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi
0?Kgn@020?Ogn@040?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3g
moT0;`3gmoTa0?Kgn@X0moOi00<0JgF?08F9/02LW[h0402LW[h01P25RK00
JgF?0?Ogn@3gmoT0JgF?08F9/140W9jn00P0QHV`06]eS`3fmoP0moOh0:Hi
A02Z?5D0`U9K0<IDFPd0aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0
moOh0?Ogn@3Ph>400@1VIWh0000606IVOP3NgN40lO7d0?7am03`lO@0l?;d
400000001P3alO@0l?;e0?7am03al_@0l?;d0?7am640l?7e2P3`lO@00`1[
MHl0/[G@0:NX`P0@0:NX`P060;:ed01[MHl0l?7d0?3am01[MHl0/[G@4@2W
Z<801@2b]M00JgF?0?3am@3al_@0YSU40080`U9K00<0beAI0<eIGP3=FEh0
2`3=FEh0103;E5T0`U9K0<9BF`2V>D@20?3am0030?7am03`l_@0g]gQ0040
IVIn00001`1VIWh0g=_P0>[[l03Zjo00j^c`0>W[k`0000000P3WinL20=kN
gP80inOW00<0ikf40>OWi`3WinL00`3WinL20>o_k`040000003Zjo00j^_`
0>[[k`80j^_`00<0j^__0>[[l03Zjo00;P3Zjo0a0>[/l0X0j^__00@0JgF?
0;Jid@2][/H0[Jk6203oool00`2][/H0[:k60:f^aP030:f^aP030:b^aP2f
^M40JgF?0080j^__00@0JgF?0;Jid@2][/H0[Jk6303oool20:f^aP030:b^
aP2f^M40JgF?0080j^_`00D0YSU40<eIGP3;E5T0cEIK0<iIG`0;0=1JG`07
0<iIG`3=EU/0beAI0<eIGP2V>D@0j^__0>[[l0020>[[k`40g=_P0@1VIWh0
000406IVOP3IfMl0hnGZ0>?TjP80hnG[00D0000008b<S03Ng]h0inOW0=kN
gP020>OWi`030<IS003WinL0inOW0080inOW00L0knoW0>o_k`3_knl00000
0>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[0>?Uj`3SiN/0;P3SiN/a0>?TjPX0
hnGZ00D0JgF?0;bne02b//X0/[;:0?ooo`0606i]S`0302DU=P2b//X0/[;:
00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ06]eS`2l_]@20;:bbP030?ooo`0U
9CH09BDf00T09BDf0`2b//X01@2l_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN
00@0d5]P0=ALG`3oool0oooo1`3DG5l20?ooo`0:0=ALG`3@Ff00cEUN0<eI
GP2V>D@0hnCZ0>?UjP3Si>X0hnG[0=WIg`40IVIn00000`1VIWh0emSN0=cN
iP030=cNiP050000003WinL0inOW0>OWi`3We/h00P3WinL01@3>N`00ki@@
0>OWi`3Wg/H0kh`@00<0kno_00L000000=cNiP3Lg^D0g=kU0=cNiP3Lg^D0
g=kV06/0g=kU00D0JgF?0;o1eP2h^Lh0^;W>0?ooo`0606i]S`0302DU=P2h
^Lh0^;W>00D0^;W>00H0_l7F06]eS`3Lg^D0g=kU06]eS`2o`MH20;RicP03
0?ooo`0U9CH0^;W>00L0^;W>00<0oooo02DU=P2h^Lh00P2h^Lh02@2o`MH0
JgF?0=cNiP3Lg^D0YSU40<eIGP3AFUh0e5eQ05<U80030?ooo`D0eUmS0`3o
ool01@1C9B00e5eQ0=5JGP3=FEh0YSU40080g=kU00<0g=kV0=cNi@3Gf=h0
0@1VIWh0000406IVOP3Ee]d0eMSP0=KHh@80eMSP00T0000008b<S03WinL0
inOW0>NeQ03FFP00eX@00?o>003>H`000P3NJ`001@3_]H`0kno_0>o_k`3_
knl000000080eMSQ00@0eMOP0=KHh03Ff>40e]OQ<03Fen0a0=KHh0X0eMSQ
00D0JgF?0<?5f@2l_M40_;gA0?ooo`0702DU=PL0_;gA00H0`lGI06]eS`3E
f>40eMSQ06]eS`33aMT20;bmd@030?ooo`0U9CH0_;gA00L0_;gA00<0oooo
02DU=P2l_M400P2l_M401@33aMT0JgF?0=KGh03Een40YSU40080eEeP00<0
f61Q0=UQHP167QX00`3oool30=UQHP<0oooo00<0AQhJ0=UQHP3HH6400P3E
GF001P2V>D@0e]SP0=GHh@3Een00eMSQ0=GFg@40IVIn00001`1VIWh0d]CM
0<oBg03@d]`0d=;M0=3Bg00000000`3WinL0303Wg/h0aTX00?O>003_[@00
kkD00<i[0036FP00aV/00=j<BP3WY@00knO>000000<0d=;L00<0cm;L0=3B
g03?d]`0<03@d]`a0<oBg@X0d=;L00<0JgF?0<S9f`33a=H04033a=H01P38
bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80`lCF00<0oooo02DU=P33a=H01`33
a=H00`3oool09BDf0<?4eP020<?4eP070<S9f`1[MHl0cm;L0<oBg02V>D@0
eemO0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3oool02016
7QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`10<oBg040d]CM
0@1VIWh0000L06IVOP3@d]/0blgH0<[=f@3;c]P0b/gH0000003WaZd0ilJ<
0?O>603__@00mlH00>n]003W[@00ijD00=J<003>J`00ilH00?oF003_knL0
kno_0000003;cMP0blgI0<[=f@3;c]P0b/gH0<_=f300blgI<@3;c]T:0<_=
f00306]eS`3;c=h0b<[I00P0b<[I00<0b<WI0<S:f@38b]T00`38b]T01038
bMT0b<[I0<_<gP1[MHl20<_=f00606]eS`3;c=h0b<[I0<S:f@3oool09BDf
1@38b]T04@38bMT0b<[I0<S:f@3oool09BDf0<S:f@38bMT0b<[I0<_<gP1[
MHl0blkH0<[=f02V>D@0eemO0=]TI03PIfD0h6IU0080gVMW00<0AQhJ0?oo
o`3oool00`3oool02P167QX0gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0YSU4
0<[>f03:c]T20<_=f@40d=;K0@1VIWh0000306IVOP3?cmX0aLSD00<0aLSD
00H000000<K6aP3Wg]H0cW/00>N]003_]@020>NU00030=JD003>L`00eY@0
0080mlH00P3gmoL010000000aLSD0<G7e035am@30<G7eC00a<OE<@34b=@:
0<C7e00306]eS`3@dN00bl_L0100bl_L00H0d=7P06]eS`34am@0a<OD06]e
S`3@dN020<_;g0030?ooo`0U9CH0bl_L00L0bl_L00<0oooo02DU=P3;bm`0
0P3;bm`01`3@dN00JgF?0<G7e034am@0YSU40=]TI03OIF@01@3PJVP01@16
7QX0oooo0?ooo`3oool0AQhJ00D0h6YX00@0gfET0=]TI02V>D@0a<SE0P34
b=@10<G7e@40cloJ0@1VIWh0000406IVOP3<c]X0`/CB0<74d@80`LCB00H0
00000>OWi`3WinL0inOW0=J4003_]@020>NU00080=J4003>J`00ijd00?Ne
003g_@00kno_0?Ogm`0000030<74dP030<;4d@31a=80`LCB0300`LCA<@31
a=8:0<;4dP0306]eS`3Cdn80cm3M0100cm3M00H0dm?R06]eS`32a=80`/CB
06]eS`3Cdn820<o@g@030?ooo`0U9CH0cm3M00L0cm3M00<0oooo02DU=P3?
d=d00P3?d=d01`3Cdn80JgF?0<;4dP31a=40YSU40=]TI03QJFD01@3PK6T5
0?ooo`D0h6aY00P0hFUU0=]TI02V>D@0`LCB0<;4d@31a=40`LCB0<c>fP40
IVIn0000101VIWh0b/cH0;k0c`2m`<l20;k0cP050000002LW9`0inOW0>ON
eP3FS0000P3NU000103FN`00aV<00;e2003_Y@020?N]00080?Ne003ocTX0
00000;k0cP2n`<l0_/3>0;k0c`2m`<ha0;k0cS40_L3>2P2n`<h00`1[MHl0
e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0cP1[MHl0e]KT0P3Cdn00
0`3oool09BDf0?ooo`080?ooo`0;02DU=P3Cdn00dm?P0=?Ch03Fe^@0JgF?
0;k0c`2n`<h0YSU40>1VI@3QJVX0103SK6`30?ooo`0404HN6P3oool0oooo
0?ooo`@0hfa/00@0hFYZ0>1VI@2V>D@0_L3?0P2n`<l10;k0cP40b/cH0@1V
IWh0000706IVOP39b]P0][S80;Vlb`2j_</0^[c<000000020>o_k`0C0=JL
003FS000gY@00=J4003_Y@00gX`00;eJ003FL`00ki`00?O_i`3gmoL0oooo
0000002i_<`0^[_<0;Vlb`2j_</0^Kc<0;Vlb`0`0;Vlc340^[c<2P2j_</0
0`1[MHl0f=SU0=?Ch@0@0=?Ch@060=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU
0P3Cdn400`3oool0KVf?06i]S`0806i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3H
f>D0JgF?0;Zlb`2j_<`0YSU40>1YJ03QKF`0i75]0>AaK`3TL6h30?ooo`03
04HN6P3TL6h0AQhJ00<0oooo0P3TL6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<
0;Zkc02i_</0][S80<W:f00106IVOP0000T0IVIn0<O9e`2d]/L0][S80;Jh
b@2f^LT0000008B4Q03Wimh00P3_knl01`36J`00mlH00>ne003_W000gX`0
0<i[003WW0000`3gmoL01@000000][W90;Nhb@2f^LT0]kW90080][S9<02g
^<Ta0;Jhb@X0]kS900@0JgF?0=KFi03Hf>D0f=SV0`3Hf>D50=SHiP<0f=SU
0P3Hf>H20=SHi@090=KFi01[MHl0]kS90;Nhb@1[MHl0e]KT0=SHi@3Hf>H0
oooo00X0KVf?00d09BDf0=SHiP3Hf>D0f=SU0=KFi01[MHl0]kS90;Nib@2V
>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo00D0AQhJ0>AdK`3TM6l0i7A_04HN
6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^K@2V>D@0][W90;Jhb@2f^LT0];K7
0<O9e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`030000003_knl0kno_
0080kno_00/0ijd00?O6203WY@00ii@00>N<003_imH0gY@i0>oF]@3omoL0
oooo0000001a0;Bfa`0506]eS`3EeN<0g=_W0=cKi`3MfnL03P3LfnL01P3E
eN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80g=_W00<0gM_W02DU=P0U9CH02@0U
9CH30=cKi`090=GEh`1[MHl0];K70;Bfa`2V>D@0ig=_0>MeLP3ZMW<0jWQf
0080oooo00<0AQhJ0>UnN03YOWP00`3YOWP020167QX0oooo0?ooo`3ZN7H0
jWIc0>MeLP3WLfl0YSU4102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;Bf
a`030;Bfa`060000002<S8`0kno_0>o_k`3WcW/0kno_0P3gmoL0203WU000
mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool00000L@2d]/L00`1[MHl0eMCS0>3O
jP0@0>3OjP060=GDh`1[MHl0];K70;Bfa`1[MHl0eMCS4@3PgnX02@3Ee><0
JgF?0;Bfa`2d]/L0YSU40>YiL`3YO7P0kh5j0?:9P@0204HN6P070>^HR`3Z
Vh`0kIN:0>^HR`3ZVh`0kIN:0>^HR`0204HN6P050?:9P@3_PGX0jGah0>Yi
L`2V>D@0102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;6cb0030;6cb006
0000003_knl0kno_0>o_k`3gmnl0kno_0P3gmoL00`3gilH0moOg0?ooo`03
0?Ogm`030?ooo`000000/K?80700/K?800<0JgF?0>g[l`3Yj?40403Yj?40
1P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[la40jNSa01T0kN_c06]eS`2a/lP0
/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0lZ^F0?6bV`3]]9/0k;FL0?6bV`3]
]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3gWHh0mHb40?24O03aP7D0YSU400@0
/K?80@36b=L106IVOP0000<0IVIn0<K8e`2h]ll00`2_[/L01@000000[Jf]
0?Ogk`3gmoL0kno_00H0moOg0P3omoL20?ooo`030000002_[/L0[jk706l0
[jk700<0JgF?0=;Ah`3blOL0403blOL01P3BdN<0JgF?0:n^a`2_[/L0JgF?
0=;Aha40l_7g00H0d]7S06]eS`2_[/L0[jk70:HiA03dRWd20?F@Q@d0l[RN
0P3eT8D00`3dRWd0YSU40:n^a`020:n^a`40^;O?0@36b=L106IVOP0000<0
IVIn0<31d@37am@0Q02/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_k
o03<bmd0JgF?08B<XP80[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103k
no`0c<_M06]eS`24S:820:b[a007096HZP2V>D@0oin=0?joY03jg;L0n^^g
0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf0?[Y]P80nNVf00H0n^^g0?[L]`3n
_j@0oin=0:HiA02AV:X30:b[a040alOD0@30`M4106IVOP0000@0IVIn0<31
d@3Bd]l0]KC9Q02TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0
Y:>n0080Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P02
0:BS_P0308B<XP2V>D@0YSU400l0YSU400L0Q8bR0:BS_P2TXkh0Y:>n0;Fd
b@3Bd]l0`<7A0040IVIn00001P1VIWh0Z:No0>KVk@3Bd^00_;c?0;6`a<@0
Z:No00D0/K340;blc`3Bd^00i^K]0:RW_`0106IVOP0000L0F5MX08N7V`3G
f>80o?cl0>CSj03@d>00b/[J0<80_;c?00H0b/[J0=3@h03ThnP0o?cl0=OH
hP27Qi/105QGJ00000P0F5MX06IVOP2EU:/0emSR0?clo03blO<0k>_^0>7R
jl00emSR00L0hN;[0>c[kP3blO<0o?cl0=OHhP2EU:/0IVIn0040F5MX0002
05QGJ00306IVOP2EU:/0dM7N0080o?cl`P3oool20?clo0030=7AgP2EU:/0
IVIn0080F5MX000305QGJ080IVIn00<0R8NM09FDZ`2XYkl0`@2XYkl0102E
U:/0R8NM06IVOP1VIWh305QGJ0001@1HEfS606IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[8]:=",
  Evaluatable->False,
  ImageSize->{208, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Table"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[8]=",
  CellTags->"Table"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\ @\ PropertyValue[{"\<myTable\>", \ "\<item\>", 2}]\)], "Input",
  CellLabel->"In[9]:=",
  CellTags->"Table"],

Cell[BoxData[
    \({"{2, 1}", "{2, 2}", "{2, 3}"}\)], "Output",
  CellLabel->"Out[9]=",
  CellTags->"Table"]
}, Open  ]],

Cell[BoxData[
    \(ref\ @\ 
      SetPropertyValue[{"\<myTable\>", \ "\<item\>", 
          1}, \[IndentingNewLine]\ {"\<10\>", "\<100\>", "\<1000\>"}]\)], \
"Input",
  CellLabel->"In[10]:=",
  CellTags->"Table"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[11]:=",
  CellTags->"Table"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003@0000T2000`400?l0
0000o`00003od01VIWh0000306IVOP3ko?d0nocm0<`0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0</0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
bP1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO/P0Oifi
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS
00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM
^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0
h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`04
07nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3O
h`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0aP20P800101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn07nM^@110?ooo`030820P03oool0oooo03l0oooo
00<0P8200?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040
IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi00<0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02H0
oooo00D0P8200?ooo`3oool0oooo000000080?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool09P3oool01@20P800oooo0?ooo`3oool0
000000P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0V
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?oo
o`0000090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
9@3oool01020P800oooo0?ooo`0000090?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool09@3oool01@20P800Oifi06IVOP2XZK/0nocm
0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?oo
o`3oool00`3oool01@000000oooo0?ooo`3oool0000000H0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0
oooo000000D0oooo00D000000?ooo`3oool0oooo000000040?ooo`D00000
0`3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000D0
oooo00D000000?ooo`3oool0oooo000000050?ooo`<00000103oool00`00
0000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000D0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo02D0oooo00@0P8200?ooo`3oool000001@3oool00`000000oooo
0?ooo`060?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`050000
00T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?oo
o`040820P03oool0oooo00000080oooo1@0000090?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`00
00020?ooo`D000002`3oool01@000000oooo0?ooo`3oool0000002L0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0
IVIn07nM^@3oool0000000<0oooo00@000000?ooo`3oool000002P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo02@0oooo00<0P820
0?ooo`0000000`3oool010000000oooo0?ooo`00000;0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0903oool00`20P800oooo0000
00030?ooo`040000003oool0oooo000000`0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0T0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool01`000000
oooo0?ooo`3oool000000?ooo`0000002P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo02D0oooo00@0P8200?ooo`3oool000000`3o
ool00`000000oooo0000000<0?ooo`050000003oool0oooo0?ooo`000000
9`3oool01020P800oooo0?ooo`0000030?ooo`030000003oool0000000X0
oooo0P0000040?ooo`030000003oool0oooo02D0oooo00D0P82007nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?oo
o`070000003oool0oooo0?ooo`000000oooo000000080?ooo`030000003o
ool0000000D0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?oo
o`0000030?ooo`030000003oool0000000`0oooo00D000000?ooo`3oool0
oooo0000000W0?ooo`040820P03oool0oooo000000<0oooo00<000000?oo
o`000000303oool01@000000oooo0?ooo`3oool0000002L0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@020?ooo`030000003oool0oooo0080oooo0P0000090?ooo`8000001@3o
ool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000@0oooo
0P0000080?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`0U0?ooo`040820P03oool0oooo000000@0oooo0P0000080?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT00`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0V0?ooo`050820P03oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`070?ooo`<000000`3oool00`000000oooo0?ooo`0V0?ooo`050820
P03oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`070?ooo`<0
00000`3oool00`000000oooo0?ooo`0V0?ooo`050820P01oWKT0IVIn0:RY
^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0@@3oool00`20
P800oooo0?ooo`0o0?ooo`030820P03oool0oooo03l0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@11
0?ooo`030820P03oool0oooo03l0oooo00<0P8200?ooo`3oool0?`3oool0
1@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1V
IWh0Oifi0440oooo00<0P8200?ooo`3oool0?`3oool00`20P800oooo0?oo
o`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1oWKT0@@3oool00`20P800oooo0?ooo`0o0?ooo`030820
P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@360820P00407nM^@1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0440oooo00<0P8200?oo
o`3oool0?`3oool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool09P3oool01@20P800oooo0?ooo`3oool0000000P0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0V0?ooo`050820P03o
ool0oooo0?ooo`000000203oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo02H0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0U0?ooo`04
0820P03oool0oooo000000T0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000T0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0
IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3o
ool010000000oooo0?ooo`3oool3000000<0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02D0oooo
00@0P8200?ooo`3oool000000`3oool3000000<0oooo00<000000?ooo`3o
ool00P3oool5000000<0oooo00<000000?ooo`3oool09@3oool01020P800
oooo0?ooo`0000030?ooo`<000000`3oool00`000000oooo0?ooo`030?oo
o`<00000103oool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?ooo`040820P03o
ool0oooo00000080oooo00D000000?ooo`3oool0oooo000000080?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool09@3oool01020P800
oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000001`3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool09@3o
ool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0Oifi0080oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
9@3oool01020P800oooo0?ooo`0000060?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?ooo`04
0820P03oool0oooo000000H0oooo00<000000?ooo`3oool02@3oool01@00
0000oooo0?ooo`3oool0000002L0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000L0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo02@0oooo00<0P8200?ooo`0000001`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
903oool00`20P800oooo000000070?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0T0?ooo`050820
P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT00P3oool00`000000oooo0?ooo`020?ooo`8000002P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo02D0oooo00@0P8200?ooo`3o
ool00000103oool2000000`0oooo00D000000?ooo`3oool0oooo0000000W
0?ooo`040820P03oool0oooo000000@0oooo0P00000:0?ooo`800000103o
ool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`000000
1@3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000H0
oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool00000
02L0oooo00@0P8200?ooo`3oool000001P3oool00`000000oooo0?ooo`09
0?ooo`050000003oool0oooo0?ooo`0000009`3oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`060?ooo`80
00001@3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo0000
0080oooo00D000000?ooo`3oool0oooo000000070?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U0?ooo`040820P03o
ool0oooo00000080oooo00D000000?ooo`3oool0oooo000000070?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U0?oo
o`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT00`3oool00`000000oooo0?ooo`03000000X0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0V0?ooo`050820P03oool0
oooo0?ooo`0000000P3oool3000000T0oooo0`0000030?ooo`030000003o
ool0oooo02H0oooo00D0P8200?ooo`3oool0oooo000000020?ooo`<00000
2@3oool3000000<0oooo00<000000?ooo`3oool09P3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0440
oooo00<0P8200?ooo`3oool0?`3oool00`20P800oooo0?ooo`0o0?ooo`05
0820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0@@3oool00`20P800oooo0?ooo`0o0?ooo`030820P03oool0oooo
03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@110?ooo`030820P03oool0oooo03l0oooo00<0P820
0?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0440oooo00<0P8200?ooo`3oool0?`3o
ool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP20P800101oWKT0IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@110?ooo`03
0820P03oool0oooo03l0oooo00<0P8200?ooo`3oool0?`3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo02H0oooo00D0P8200?ooo`3oool0oooo00000008
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool09P3oool0
1@20P800oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0V0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
9@3oool01020P800oooo0?ooo`0000090?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`0000090?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool09@3oool01@20
P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0080oooo00<000000?ooo`3oool01@0000020?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0U
0?ooo`040820P03oool0oooo00000080oooo1@0000020?ooo`030000003o
ool0oooo0080oooo1@0000030?ooo`030000003oool0oooo02D0oooo00@0
P8200?ooo`3oool000000P3oool500000080oooo00<000000?ooo`3oool0
0`3oool3000000@0oooo00<000000?ooo`3oool09@3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080
oooo00D000000?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`000003
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000<0oooo00<0
00000?ooo`3oool0203oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool09@3oool01@20P800Oifi06IVOP2XZK/0nocm0040
IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`0000040?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000@0oooo00<00000
0?ooo`3oool02`3oool01@000000oooo0?ooo`3oool0000002L0oooo00D0
P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
07nM^@3oool0000000H0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo02@0oooo00<0P8200?ooo`00
00001P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0903oool00`20P800oooo000000060?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0T0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000H0oooo00<00000
0?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000002L0oooo00@0
P8200?ooo`3oool000001P3oool00`000000oooo0?ooo`070?ooo`800000
103oool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`00
00001@3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo0000
00H0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0
000002L0oooo00@0P8200?ooo`3oool000001P3oool00`000000oooo0?oo
o`090?ooo`050000003oool0oooo0?ooo`0000009`3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`060?oo
o`8000001@3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo
00000080oooo00D000000?ooo`3oool0oooo000000070?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U0?ooo`040820
P03oool0oooo00000080oooo00D000000?ooo`3oool0oooo000000070?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT00`3oool00`000000oooo0?ooo`03000000X0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0V0?ooo`050820P03o
ool0oooo0?ooo`0000000P3oool3000000T0oooo0`0000030?ooo`030000
003oool0oooo02H0oooo00D0P8200?ooo`3oool0oooo000000020?ooo`<0
00002@3oool3000000<0oooo00<000000?ooo`3oool09P3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0440oooo00<0P8200?ooo`3oool0?`3oool00`20P800oooo0?ooo`0o0?oo
o`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT0@@3oool00`20P800oooo0?ooo`0o0?ooo`030820P03oool0
oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn07nM^@110?ooo`030820P03oool0oooo03l0oooo00<0
P8200?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0440oooo00<0P8200?ooo`3oool0
?`3oool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP20P800101oWKT0
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@110;:d
_`030820P03oool0oooo03l0oooo00<0P8200?ooo`3oool0?`3oool01@20
P800Oifi06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0
Oifi0;:d_cl0oooo00<0/[Bo0820P03oool0@03oool00`20P800oooo0?oo
o`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3k
o?d0Z:Vk06IVOP1oWKT0/[Bo?`3oool00`2b];l0P8200?ooo`100?ooo`03
0820P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l20?ooo`030000003oool0
oooo0080oooo0`00000e0?ooo`030;:d_`20P800oooo0080oooo00<00000
0?ooo`3oool00P3oool3000000<0oooo0`00000`0?ooo`050820P03oool0
oooo0?ooo`000000103oool3000000<0oooo0`0000030?ooo`<00000:P3o
ool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY
^`1VIWh0Oifi0;:d_`80oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo0380oooo00<0/[Bo0820P03oool00P3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3oool0
0`000000oooo0?ooo`0]0?ooo`050820P03oool0oooo0?ooo`0000000`3o
ool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000
oooo000000030?ooo`030000003oool0oooo02L0oooo00D0P82007nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l2
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?oo
o`0b0?ooo`030;:d_`20P800oooo0080oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0
;@3oool01@20P800oooo0?ooo`3oool0000000<0oooo00L000000?ooo`3o
ool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool0
0`000000oooo0?ooo`0W0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo0P3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0<P3oool00`2b];l0
P8200?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo000000030?ooo`030000003oool0oooo02d0oooo00D0P8200?oo
o`3oool0oooo000000030?ooo`070000003oool0oooo0?ooo`000000oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0
9`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm
0:RY^`1VIWh0Oifi0;:d_`80oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0oooo0380oooo00<0/[Bo0820P03oool00P3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3o
ool00`000000oooo0?ooo`0]0?ooo`050820P03oool0oooo0?ooo`000000
0`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`00
0000oooo000000030?ooo`030000003oool0oooo02L0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn07nM^@2b
];l000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000003@0
oooo00H0/[Bo0820P03oool000000?ooo`0000030?ooo`070000003oool0
oooo0?ooo`000000oooo000000030?ooo`030000003oool0oooo02d0oooo
00D0P8200?ooo`000000oooo000000030?ooo`070000003oool0oooo0?oo
o`000000oooo000000030?ooo`030000003oool0000000<0oooo00<00000
0?ooo`3oool09`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0Oifi0;:d_`3oool00P0000030?ooo`050000
003oool0oooo0?ooo`000000=03oool0102b];l0P8200?ooo`3oool20000
00<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<0
00000?ooo`3oool0;@3oool00`20P800oooo0?ooo`02000000<0oooo00L0
00000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`00
00000`3oool00`000000oooo0?ooo`0W0?ooo`050820P01oWKT0IVIn0:RY
^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo0P3oool0
0`000000oooo0?ooo`020?ooo`<00000=@3oool00`2b];l0P8200?ooo`02
0?ooo`030000003oool0oooo0080oooo0`0000030?ooo`<00000<03oool0
1@20P800oooo0?ooo`3oool0000000@0oooo0`0000030?ooo`<000000`3o
ool3000002X0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000H0
IVIn0?_lo@2XZK/0IVIn07nM^@2b];lo0?ooo`030;:d_`20P800oooo0400
oooo00<0P8200?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm
0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi0;:d_cl0oooo00<0/[Bo
0820P03oool0@03oool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0
IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo
?`3oool00`2b];l0P8200?ooo`100?ooo`030820P03oool0oooo03l0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@110;:d_`030820P03oool0oooo03l0oooo00<0P8200?ooo`3o
ool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0440LFmT00<0h=oS075_I01aKf@0?`1aKf@00`3P
gn<0LFmT075_I00o075_I0050>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000606IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo?`2MWJ400`1aKf@0h=oS0?oo
o`0o09fMX@03075_I03Pgn<0oooo03l0WIfQ00H0LFmT0>3Oh`1oWKT0IVIn
0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR
03d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0
h=oS0?ooo`3akn80?@3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0m0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3Oh`3o
ool0lNoR03d0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80?@3Pgn<01@2M
WJ40LFmT0>3Oh`3oool0lNoR03d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_
hP0m0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR03d0h=oS00D0WIfQ075_
I03Pgn<0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80?@3P
gn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0D0>3Oh`030000003Pgn<0h=oS
00<0h=oS00<000000>3Oh`3Pgn<0803Pgn<01@2MWJ40LFmT0>3Oh`3oool0
lNoR01D0h=oS1@00000S0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn805`3P
gn<3000002<0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80503Pgn<00`00
0000h=oS0>3Oh`030>3Oh`030000003Pgn<0h=oS0200h=oS00D0WIfQ075_
I03Pgn<0oooo0?7_hP0E0>3Oh`030000003Pgn<0h=oS0080h=oS00<00000
0>3Oh`3Pgn<0803Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR01H0h=oS00D0
00000>3Oh`3Pgn<0h=oS0000000R0>3Oh`0709fMX@1aKf@0h=oS07nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0
lNoR01D0h=oS1@00000S0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn805@3P
gn<00`000000h=oS0>3Oh`020>3Oh`030000003Pgn<0h=oS0200h=oS00D0
WIfQ075_I03Pgn<0oooo0?7_hP0E0>3Oh`030000003Pgn<0h=oS02D0h=oS
00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0
nocm0:RY^`1VIWh0Oifi0?ooo`3akn805@3Pgn<01@000000h=oS0>3Oh`3P
gn<0000002<0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0E0>3Oh`030000
003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<0803Pgn<01@2MWJ40LFmT
0>3Oh`3oool0lNoR01D0h=oS00<000000>3Oh`3Pgn<09@3Pgn<01`2MWJ40
LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP1oWKT0oooo0?7_hP0F0>3Oh`030000003Pgn<0000002@0h=oS00D0
WIfQ075_I03Pgn<0oooo0?7_hP0E0>3Oh`D000008`3Pgn<01@2MWJ40LFmT
0>3Oh`3oool0lNoR01D0h=oS00<000000>3Oh`3Pgn<09@3Pgn<01`2MWJ40
LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP1oWKT0oooo0?7_hP0F0>3Oh`030000003Pgn<0000002@0h=oS00D0
WIfQ075_I03Pgn<0oooo0?7_hP0E0>3Oh`030000003Pgn<0h=oS0080h=oS
00<000000>3Oh`3Pgn<0803Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR01D0
h=oS00<000000>3Oh`3Pgn<09@3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_
hP0F0>3Oh`030000003Pgn<0000002@0h=oS00D0WIfQ075_I03Pgn<0oooo
0?7_hP0E0>3Oh`030000003Pgn<0h=oS0080h=oS00<000000>3Oh`3Pgn<0
803Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR01H0h=oS00D000000>3Oh`3P
gn<0h=oS0000000R0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR01L0h=oS
00<000000>3Oh`3Pgn<08`3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR01D0
h=oS1@00000S0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn805`3Pgn<30000
02<0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT
0>3Oh`3oool0lNoR03d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0m0>3O
h`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn
0?_lo@2XZK/0IVIn07nM^@3oool0lNoR03d0h=oS00D0WIfQ075_I03Pgn<0
oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80?@3Pgn<01`2M
WJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP1oWKT0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3a
kn80?@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR03d0h=oS00L0WIfQ075_
I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0Oifi0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR03d0
h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0m0>3Oh`0709fMX@1aKf@0h=oS
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM
^@3oooln0?7_hP0409fMX@1aKf@0h=oS0?oooch0lNoR00@0WIfQ075_I03P
gn<0oooo?P3akn801`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0@03oool00`1aKf@0h=oS0?oo
o`0o0?ooo`03075_I03Pgn<0oooo03l0oooo00H0LFmT0>3Oh`1oWKT0IVIn
0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVInb01oWKT00`1VIWh0
Z:Vk0?_lo@0106IVOP0000<0IVIn0?Ogn@2HV:L0bP1gMi8109RHY`40moOi
0@1VIWh0000306IVOP3gmoT0_;g=0</0_;g=0@3gmoT106IVOP0000<0IVIn
0?Ogn@3Thn<0b`3Thn<10?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`240?oo
o`030>CSh`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl0
1P2LY;T0i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00
K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY4
0:HiA02W>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1V
IWh0000F06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?cl
o@3lo?`0o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m
0?_lo080o?cl00@0o?cm0?clo03knod0o?cm<03lno`a0?_lo0X0nocm00<0
W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40
QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0
nocl0?clo03lnod0nocm0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi
0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3g
moT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi
0?Ogn@0_0?OgnC40m_Oi2P3gmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9
/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0
YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Og
n@3gmoP0moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`
l_@@000000060?7am03`l_D0lO7d0?7bm03`l_@0lO7dH@3`lOD:0?3am003
06]eS`2b]M00YjS20100YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A
0:NX`P050;:ed01[MHl0l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN0<eI
GP0;0<eIGP040<]DF@32DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN40
0@1VIWh0000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__000000020>OWi`80
g]kN0P3WinL00`3W_H@0inOW0>OWi`030>OWi`80kno_00@000000>[[l03Z
jo00j^__0P3Zjo000`3Zjnl0j^_`0>[[l00^0>[[l340j^c`2P3Zjnl0101[
MHl0][WA0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k6
0;Jid@1[MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0
[:k60;Jid@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO
00L0cUUO0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IV
OP0000@0IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0
g]kN0080inOW00<0aV<00>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`00
0000hnCZ0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?Uj`0^0>?Ujc40hnCZ
2P3SiNX01@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b
//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo
02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=
FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0
cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0
g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_
U100inOW0>ONaP3_S1000`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cN
i@3Lg^H0J`3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf
0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>
00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1
eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<3
0?ooo`0505<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OH
gP0106IVOP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OW
i`3WinL0ikF40=IJ003FQ000olh00<iS00020=i[00050>neS03_knl0kno_
0>o_k`0000000P3Ef>40103Een00e]SP0=KHh@3Fen4`0=KGh340e]SP2P3E
f>401@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?
0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l_M401`2l_M400`3o
ool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GGh@2V>D@00P3EGF00
0`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@02
0=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1VIWh0000706IVOP3B
e=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ONcP36BP00mlh00>n]
003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh000000`3@d]`00`3?d]`0
d=;L0<oBg00`0=3Bg340cm;M2P3@d]`00`1[MHl0b<WK0<?4eP0@0<?4eP06
0<S9f`1[MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP07
0<?4eP030?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:Hi
A03GGel0fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`08
04HN6P3LIFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3B
e=d106IVOP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3W
aX`0mlhH0>nm003gaP00kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_
i`3_knl000000<_=f03;cMT0b/gI0<_>f03:cMP0blgH<03;cMTa0<_>f@X0
blgH00<0JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@04
0<S9f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U
9CH50<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN
06]eS`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0
oooo0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V
>D@0b/kH0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35
b=@01P000000a/K60>ONeP3>N`00ijd00>ne0080ijD000<0eY@00<ic003F
U0000P3gaP020?Ogm`0400000035b=@0aLOD0<G7e0<0aLOE<034amDa0<C8
e0X0a<OD00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0
JgF?0=3Ah080bl_L00<0oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;
g0020<_;g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ005
04HN6P3oool0oooo0?ooo`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D2
0<C8e040aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=80
1P000000inOW0>OWi`3WinL0eX@00>ne0080ijD000P0eX@00<i[003W[@00
mkD00?Nm003_knl0moOg000000<0`LCB00<0`/CA0<74dP31a=80<031a=4a
0<74dPX0`/CB00<0JgF?0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32
a=80JgF?0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf
0<o@g@020<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/
J@D0oooo1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ
0@1VIWh0000406IVOP3:c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0
imkF0=J<00020=jD00040=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>
BP000000_/3>0;k0c`2n`<h0_/3?0;g0cS40_/3><@2m`<h:0;k0cP0306]e
S`3Fe^@0dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?C
h0030?ooo`0U9CH0oooo00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[
MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3o
ool0oooo103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P1
06IVOP0000L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0
eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3o
ool000000;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;0300^Kc<<@2j_<`:0;Zl
b`0306]eS`3Hf>D0dm?Q0100dm?Q00H0f=SU06]eS`2j_</0^[c;06]eS`3H
f>D20=?Ch@030?ooo`1^KHl0KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q
0=SHi@1[MHl0^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0oooo
00<0AQhJ0>A`KP167QX00`3oool20>A`KP090>AaK@3QKF`0h6UX0:HiA02j
_<`0^[_<0;Vlb`2f^<P0bL[H0040IVIn00002@1VIWh0alWG0;Bfa`2f^<P0
][S90;Jib@000000Q8B40>OWgP020>o_k`070<I[003gaP00kkD00>nL003N
S000cV/00>NL00030?Ogm`050000002f^LT0]kS90;Jib@2g^LT00P2f^<T`
0;NhbC40][S92P2g^<T0101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3H
f>D20=SHiP80f=SU00T0e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SH
iP3oool02P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW9
0:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0
AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d
]/L0alWG0@1VIWh0000306IVOP36b=L0];K700<0];K700<000000>o_k`3_
knl00P3_knl02`3W[@00mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?og
m`3oool000000740];K700D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`06
0=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P09
02DU=P<0g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3Z
N7H00P3oool00`167QX0jGih0>UnN0030>UnN00804HN6P3oool0oooo0>Yh
MP3ZMW<0igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0
];K700<0];K700H0000008b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND
003gilh0moOg0?Ogm`3_imH0moOg0?ooo`00001a0;Bfa`0306]eS`3Ee><0
h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GD
h`1[MHl0];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;
0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0
jWUc0:HiA0040;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0/K?800<0/K?8
00H000000>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo
00<0moOg00<0oooo0000002a/lP0L02a/lP00`1[MHl0kN_c0>WXl@0@0>WX
l@060>g[l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6c
b02a/lP0YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K
0>fdV`3/]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0
102a/lP10<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`030:n^a`050000002]
[Jd0moO_0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L0
K`2_[/L00`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[
MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b
^9h20?F@Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn0000
0`1VIWh0`<7A0<O7e0240:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0
no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`04
0?_ko03<bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3j
jkL0n^Vf0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg
0?joY03oWhd0YSU4096HZP<0[:_40@37am@10<31d@40IVIn0000101VIWh0
`<7A0=;Bg`2e]<V40:BS_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS
_P2TXkh00P2TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n
0080Y:>n00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0
]KC90=;Bg`30`M400@1VIWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34
a02XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK
0=OHhP3lo?`0i>?X0=3@h03:b]X0`P2l_<l01P3:b]X0d=3P0>CSj03lo?`0
emSR08N7V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0
hN;[`03Gf>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP0
0080F5MX00<0IVIn09FDZ`3AdMh00P3lo?c20?ooo`80o?cl00<0dM7N09FD
Z`1VIWh00P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[0:RW_`310:RW_`04
09FDZ`28Qid0IVIn06IVOP<0F5MX000505QGJ<H0IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[11]:=",
  Evaluatable->False,
  ImageSize->{208, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Table"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[11]=",
  CellTags->"Table"]
}, Open  ]],

Cell["We can also change the column headers.", "Text",
  CellTags->"Table"],

Cell[BoxData[
    \(ref\ @\ 
      SetPropertyValue[{"\<myTableModel\>", \ "\<columnIdentifiers\>"}, \ \
\[IndentingNewLine]{"\<One\>", "\<Two\>", "\<Three\>"}]\)], "Input",
  CellLabel->"In[12]:=",
  CellTags->"Table"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[13]:=",
  CellTags->"Table"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003@0000T2000`400?l0
0000o`00003od01VIWh0000306IVOP3ko?d0nocm0<`0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0</0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
bP1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO/P0Oifi
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS
00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM
^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0
h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`04
07nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3O
h`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0aP20P800101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn07nM^@110?ooo`030820P03oool0oooo03l0oooo
00<0P8200?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040
IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi00<0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02H0
oooo00D0P8200?ooo`3oool0oooo000000080?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool09P3oool01@20P800oooo0?ooo`3oool0
000000P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0V
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?oo
o`0000090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
9@3oool01020P800oooo0?ooo`0000090?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool09@3oool01@20P800Oifi06IVOP2XZK/0nocm
0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?oo
o`3oool00`3oool01@000000oooo0?ooo`3oool0000000H0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0
oooo000000D0oooo00D000000?ooo`3oool0oooo000000040?ooo`D00000
0`3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000D0
oooo00D000000?ooo`3oool0oooo000000050?ooo`<00000103oool00`00
0000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000D0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo02D0oooo00@0P8200?ooo`3oool000001@3oool00`000000oooo
0?ooo`060?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`050000
00T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?oo
o`040820P03oool0oooo00000080oooo1@0000090?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`00
00020?ooo`D000002`3oool01@000000oooo0?ooo`3oool0000002L0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0
IVIn07nM^@3oool0000000<0oooo00@000000?ooo`3oool000002P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo02@0oooo00<0P820
0?ooo`0000000`3oool010000000oooo0?ooo`00000;0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0903oool00`20P800oooo0000
00030?ooo`040000003oool0oooo000000`0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0T0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool01`000000
oooo0?ooo`3oool000000?ooo`0000002P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo02D0oooo00@0P8200?ooo`3oool000000`3o
ool00`000000oooo0000000<0?ooo`050000003oool0oooo0?ooo`000000
9`3oool01020P800oooo0?ooo`0000030?ooo`030000003oool0000000X0
oooo0P0000040?ooo`030000003oool0oooo02D0oooo00D0P82007nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?oo
o`070000003oool0oooo0?ooo`000000oooo000000080?ooo`030000003o
ool0000000D0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?oo
o`0000030?ooo`030000003oool0000000`0oooo00D000000?ooo`3oool0
oooo0000000W0?ooo`040820P03oool0oooo000000<0oooo00<000000?oo
o`000000303oool01@000000oooo0?ooo`3oool0000002L0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@020?ooo`030000003oool0oooo0080oooo0P0000090?ooo`8000001@3o
ool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000@0oooo
0P0000080?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`0U0?ooo`040820P03oool0oooo000000@0oooo0P0000080?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT00`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`0V0?ooo`050820P03oool0oooo0?ooo`000000103oool00`000000oooo
0?ooo`070?ooo`<000000`3oool00`000000oooo0?ooo`0V0?ooo`050820
P03oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`070?ooo`<0
00000`3oool00`000000oooo0?ooo`0V0?ooo`050820P01oWKT0IVIn0:RY
^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0@@3oool00`20
P800oooo0?ooo`0o0?ooo`030820P03oool0oooo03l0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@11
0?ooo`030820P03oool0oooo03l0oooo00<0P8200?ooo`3oool0?`3oool0
1@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1V
IWh0Oifi0440oooo00<0P8200?ooo`3oool0?`3oool00`20P800oooo0?oo
o`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1oWKT0@@3oool00`20P800oooo0?ooo`0o0?ooo`030820
P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@360820P00407nM^@1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0440oooo00<0P8200?oo
o`3oool0?`3oool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool09P3oool01@20P800oooo0?ooo`3oool0000000P0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0V0?ooo`050820P03o
ool0oooo0?ooo`000000203oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo02H0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0U0?ooo`04
0820P03oool0oooo000000T0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000T0oooo00<00000
0?ooo`3oool02P3oool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0
IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3o
ool010000000oooo0?ooo`3oool3000000<0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02D0oooo
00@0P8200?ooo`3oool000000`3oool3000000<0oooo00<000000?ooo`3o
ool00P3oool5000000<0oooo00<000000?ooo`3oool09@3oool01020P800
oooo0?ooo`0000030?ooo`<000000`3oool00`000000oooo0?ooo`030?oo
o`<00000103oool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool0
10000000oooo0?ooo`0000030?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?ooo`040820P03o
ool0oooo00000080oooo00D000000?ooo`3oool0oooo000000080?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool09@3oool01020P800
oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000001`3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool09@3o
ool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0Oifi0080oooo00<000000?ooo`3oool0103oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
9@3oool01020P800oooo0?ooo`0000060?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?ooo`04
0820P03oool0oooo000000H0oooo00<000000?ooo`3oool02@3oool01@00
0000oooo0?ooo`3oool0000002L0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000L0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo02@0oooo00<0P8200?ooo`0000001`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
903oool00`20P800oooo000000070?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0T0?ooo`050820
P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT00P3oool00`000000oooo0?ooo`020?ooo`8000002P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo02D0oooo00@0P8200?ooo`3o
ool00000103oool2000000`0oooo00D000000?ooo`3oool0oooo0000000W
0?ooo`040820P03oool0oooo000000@0oooo0P00000:0?ooo`800000103o
ool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`000000
1@3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000H0
oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool00000
02L0oooo00@0P8200?ooo`3oool000001P3oool00`000000oooo0?ooo`09
0?ooo`050000003oool0oooo0?ooo`0000009`3oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo
00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`060?ooo`80
00001@3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo0000
0080oooo00D000000?ooo`3oool0oooo000000070?ooo`050000003oool0
oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U0?ooo`040820P03o
ool0oooo00000080oooo00D000000?ooo`3oool0oooo000000070?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U0?oo
o`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT00`3oool00`000000oooo0?ooo`03000000X0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`0V0?ooo`050820P03oool0
oooo0?ooo`0000000P3oool3000000T0oooo0`0000030?ooo`030000003o
ool0oooo02H0oooo00D0P8200?ooo`3oool0oooo000000020?ooo`<00000
2@3oool3000000<0oooo00<000000?ooo`3oool09P3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0440
oooo00<0P8200?ooo`3oool0?`3oool00`20P800oooo0?ooo`0o0?ooo`05
0820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0@@3oool00`20P800oooo0?ooo`0o0?ooo`030820P03oool0oooo
03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@110?ooo`030820P03oool0oooo03l0oooo00<0P820
0?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0440oooo00<0P8200?ooo`3oool0?`3o
ool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP20P800101oWKT0IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@110?ooo`03
0820P03oool0oooo03l0oooo00<0P8200?ooo`3oool0?`3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo02H0oooo00D0P8200?ooo`3oool0oooo00000008
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool09P3oool0
1@20P800oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0V0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo
0?ooo`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
9@3oool01020P800oooo0?ooo`0000090?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`0000090?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool09@3oool01@20
P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0080oooo00<000000?ooo`3oool01@0000020?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0U
0?ooo`040820P03oool0oooo00000080oooo1@0000020?ooo`030000003o
ool0oooo0080oooo1@0000030?ooo`030000003oool0oooo02D0oooo00@0
P8200?ooo`3oool000000P3oool500000080oooo00<000000?ooo`3oool0
0`3oool3000000@0oooo00<000000?ooo`3oool09@3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080
oooo00D000000?ooo`3oool0oooo0000000<0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`000003
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000<0oooo00<0
00000?ooo`3oool0203oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool09@3oool01@20P800Oifi06IVOP2XZK/0nocm0040
IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`0000040?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000@0oooo00<00000
0?ooo`3oool02`3oool01@000000oooo0?ooo`3oool0000002L0oooo00D0
P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
07nM^@3oool0000000H0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo02@0oooo00<0P8200?ooo`00
00001P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0903oool00`20P800oooo000000060?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`0T0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`040?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000H0oooo00<00000
0?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000002L0oooo00@0
P8200?ooo`3oool000001P3oool00`000000oooo0?ooo`070?ooo`800000
103oool00`000000oooo0?ooo`0U0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`00
00001@3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo0000
00H0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0
000002L0oooo00@0P8200?ooo`3oool000001P3oool00`000000oooo0?oo
o`090?ooo`050000003oool0oooo0?ooo`0000009`3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`060?oo
o`8000001@3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo
00000080oooo00D000000?ooo`3oool0oooo000000070?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U0?ooo`040820
P03oool0oooo00000080oooo00D000000?ooo`3oool0oooo000000070?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0U
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT00`3oool00`000000oooo0?ooo`03000000X0oooo00<0
00000?ooo`3oool00P3oool00`000000oooo0?ooo`0V0?ooo`050820P03o
ool0oooo0?ooo`0000000P3oool3000000T0oooo0`0000030?ooo`030000
003oool0oooo02H0oooo00D0P8200?ooo`3oool0oooo000000020?ooo`<0
00002@3oool3000000<0oooo00<000000?ooo`3oool09P3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0440oooo00<0P8200?ooo`3oool0?`3oool00`20P800oooo0?ooo`0o0?oo
o`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT0@@3oool00`20P800oooo0?ooo`0o0?ooo`030820P03oool0
oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn07nM^@110?ooo`030820P03oool0oooo03l0oooo00<0
P8200?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0440oooo00<0P8200?ooo`3oool0
?`3oool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP20P800101oWKT0
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@110;:d
_`030820P03oool0oooo03l0oooo00<0P8200?ooo`3oool0?`3oool01@20
P800Oifi06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0
Oifi0;:d_cl0oooo00<0/[Bo0820P03oool0@03oool00`20P800oooo0?oo
o`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3k
o?d0Z:Vk06IVOP1oWKT0/[Bo?`3oool00`2b];l0P8200?ooo`100?ooo`03
0820P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l20?ooo`030000003oool0
oooo0080oooo0`00000e0?ooo`030;:d_`20P800oooo0080oooo00<00000
0?ooo`3oool00P3oool3000000<0oooo0`00000`0?ooo`050820P03oool0
oooo0?ooo`000000103oool3000000<0oooo0`0000030?ooo`<00000:P3o
ool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY
^`1VIWh0Oifi0;:d_`80oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0oooo0380oooo00<0/[Bo0820P03oool00P3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3oool0
0`000000oooo0?ooo`0]0?ooo`050820P03oool0oooo0?ooo`0000000`3o
ool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000
oooo000000030?ooo`030000003oool0oooo02L0oooo00D0P82007nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l2
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?oo
o`0b0?ooo`030;:d_`20P800oooo0080oooo00D000000?ooo`3oool0oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0
;@3oool01@20P800oooo0?ooo`3oool0000000<0oooo00L000000?ooo`3o
ool0oooo0000003oool0000000<0oooo00<000000?ooo`0000000`3oool0
0`000000oooo0?ooo`0W0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo0P3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0<P3oool00`2b];l0
P8200?ooo`020?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo000000030?ooo`030000003oool0oooo02d0oooo00D0P8200?oo
o`3oool0oooo000000030?ooo`070000003oool0oooo0?ooo`000000oooo
000000030?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool0
9`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm
0:RY^`1VIWh0Oifi0;:d_`80oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0oooo0380oooo00<0/[Bo0820P03oool00P3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3o
ool00`000000oooo0?ooo`0]0?ooo`050820P03oool0oooo0?ooo`000000
0`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`00
0000oooo000000030?ooo`030000003oool0oooo02L0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000T0IVIn0?_lo@2XZK/0IVIn07nM^@2b
];l000000?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000003@0
oooo00H0/[Bo0820P03oool000000?ooo`0000030?ooo`070000003oool0
oooo0?ooo`000000oooo000000030?ooo`030000003oool0oooo02d0oooo
00D0P8200?ooo`000000oooo000000030?ooo`070000003oool0oooo0?oo
o`000000oooo000000030?ooo`030000003oool0000000<0oooo00<00000
0?ooo`3oool09`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0Oifi0;:d_`3oool00P0000030?ooo`050000
003oool0oooo0?ooo`000000=03oool0102b];l0P8200?ooo`3oool20000
00<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<0
00000?ooo`3oool0;@3oool00`20P800oooo0?ooo`02000000<0oooo00L0
00000?ooo`3oool0oooo0000003oool0000000<0oooo00<000000?ooo`00
00000`3oool00`000000oooo0?ooo`0W0?ooo`050820P01oWKT0IVIn0:RY
^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo0P3oool0
0`000000oooo0?ooo`020?ooo`<00000=@3oool00`2b];l0P8200?ooo`02
0?ooo`030000003oool0oooo0080oooo0`0000030?ooo`<00000<03oool0
1@20P800oooo0?ooo`3oool0000000@0oooo0`0000030?ooo`<000000`3o
ool3000002X0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000H0
IVIn0?_lo@2XZK/0IVIn07nM^@2b];lo0?ooo`030;:d_`20P800oooo0400
oooo00<0P8200?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm
0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi0;:d_cl0oooo00<0/[Bo
0820P03oool0@03oool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0
IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo
?`3oool00`2b];l0P8200?ooo`100?ooo`030820P03oool0oooo03l0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@110;:d_`030820P03oool0oooo03l0oooo00<0P8200?ooo`3o
ool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0440LFmT00<0h=oS075_I01aKf@0?`1aKf@00`3P
gn<0LFmT075_I00o075_I0050>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000606IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo?`2MWJ400`1aKf@0h=oS0?oo
o`0o09fMX@03075_I03Pgn<0oooo03l0WIfQ00H0LFmT0>3Oh`1oWKT0IVIn
0:RY^`3ko?d106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR
03d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0
h=oS0?ooo`3akn80?@3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0m0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3Oh`3o
ool0lNoR03d0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80?@3Pgn<01@2M
WJ40LFmT0>3Oh`3oool0lNoR03d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_
hP0m0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR03d0h=oS00D0WIfQ075_
I03Pgn<0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80?@3P
gn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IV
OP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0@0>3Oh`<000000`3Pgn<01@00
0000h=oS0>3Oh`3Pgn<000000080h=oS0`00000M0>3Oh`0509fMX@1aKf@0
h=oS0?ooo`3akn803`3Pgn<00`000000h=oS0>3Oh`030>3Oh`050000003P
gn<0h=oS0>3Oh`000000103Pgn<3000001`0h=oS00D0WIfQ075_I03Pgn<0
oooo0?7_hP0<0>3Oh`050000003Pgn<0h=oS0>3Oh`0000000`3Pgn<00`00
0000h=oS000000040>3Oh`<000000`3Pgn<3000001T0h=oS00L0WIfQ075_
I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1V
IWh0Oifi0?ooo`3akn803`3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080
h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<00000
0>3Oh`3Pgn<06P3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00l0h=oS00<0
00000>3Oh`3Pgn<00`3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS
00D000000>3Oh`3Pgn<0h=oS0000000K0>3Oh`0509fMX@1aKf@0h=oS0?oo
o`3akn80303Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00<00000
0>3Oh`0000000`3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`000000
0`3Pgn<00`000000h=oS0>3Oh`0F0>3Oh`0709fMX@1aKf@0h=oS07nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0
lNoR00h0h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS00000003
0>3Oh`030000003Pgn<000000200h=oS00D0WIfQ075_I03Pgn<0oooo0?7_
hP0?0>3Oh`030000003Pgn<0h=oS0080h=oS00L000000>3Oh`000000h=oS
0000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS0000000K0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn80303Pgn<01@000000h=oS0>3Oh`3P
gn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3O
h`030>3Oh`030000003Pgn<0h=oS01X0h=oS00L0WIfQ075_I03Pgn<0Oifi
06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?oo
o`3akn803P3Pgn<00`000000h=oS0>3Oh`030>3Oh`030000003Pgn<00000
00<0h=oS00<000000>3Oh`0000001000000L0>3Oh`0509fMX@1aKf@0h=oS
0?ooo`3akn803`3Pgn<00`000000h=oS0>3Oh`020>3Oh`070000003Pgn<0
00000>3Oh`000000h=oS000000020>3Oh`050000003Pgn<0h=oS0>3Oh`00
00006`3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00`0h=oS00D000000>3O
h`3Pgn<0h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS1@000000
0`3Pgn<0000000000003000001P0h=oS00L0WIfQ075_I03Pgn<0Oifi06IV
OP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3a
kn803P3Pgn<00`000000h=oS0>3Oh`030>3Oh`040000003Pgn<000000000
0080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`0J0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn803`3Pgn<01@000000h=oS0>3Oh`3P
gn<000000080h=oS00<000000>3Oh`0000000P3Pgn<00`000000h=oS0000
00030>3Oh`030000003Pgn<0h=oS01T0h=oS00D0WIfQ075_I03Pgn<0oooo
0?7_hP0<0>3Oh`040000003Pgn<0h=oS0>3Oh`8000000P3Pgn<010000000
h=oS0000000000020>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS0000
00030>3Oh`030000003Pgn<0h=oS01H0h=oS00L0WIfQ075_I03Pgn<0Oifi
06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?oo
o`3akn803P3Pgn<00`000000h=oS0>3Oh`030>3Oh`040000003Pgn<00000
0>3Oh`8000000`3Pgn<3000001d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_
hP0?0>3Oh`050000003Pgn<0h=oS0>3Oh`0000000`3Pgn<01@000000h=oS
0>3Oh`3Pgn<000000080h=oS0`00000L0>3Oh`0509fMX@1aKf@0h=oS0?oo
o`3akn80303Pgn<01P000000h=oS0>3Oh`3Pgn<000000>3Oh`8000000P3P
gn<00`000000h=oS000000020>3Oh`<000000`3Pgn<3000001T0h=oS00L0
WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm
0:RY^`1VIWh0Oifi0?ooo`3akn803`3Pgn<01@000000h=oS0>3Oh`3Pgn<0
000002T0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0?0>3Oh`030000003P
gn<0h=oS02/0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0<0>3Oh`050000
003Pgn<0h=oS0>3Oh`000000;03Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_
hP0@0>3Oh`<00000:P3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00d0h=oS
1@00000[0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn802P3Pgn<500000003
0>3Oh`000000h=oS02/0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0
nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80?@3P
gn<01@2MWJ40LFmT0>3Oh`3oool0lNoR03d0h=oS00D0WIfQ075_I03Pgn<0
oooo0?7_hP0m0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR03d0h=oS00D0
WIfQ075_I03Pgn<0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3a
kn80?@3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0m0>3Oh`0509fMX@1a
Kf@0h=oS0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR03d0
h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1V
IWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3O
h`3oool0lNoR03d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0m0>3Oh`07
09fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_l
o@2XZK/0IVIn07nM^@3oooln0?7_hP0409fMX@1aKf@0h=oS0?oooch0lNoR
00@0WIfQ075_I03Pgn<0oooo?P3akn801`2MWJ40LFmT0>3Oh`1oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0@03oool0
0`1aKf@0h=oS0?ooo`0o0?ooo`03075_I03Pgn<0oooo03l0oooo00H0LFmT
0>3Oh`1oWKT0IVIn0:RY^`3ko?d106IVOP0000@0IVIn0?_lo@2XZK/0IVIn
b01oWKT00`1VIWh0Z:Vk0?_lo@0106IVOP0000<0IVIn0?Ogn@2HV:L0bP1g
Mi8109RHY`40moOi0@1VIWh0000306IVOP3gmoT0_;g=0</0_;g=0@3gmoT1
06IVOP0000<0IVIn0?Ogn@3Thn<0b`3Thn<10?Ogn@40IVIn00000`1VIWh0
l?7d0?ooo`240?ooo`030>CSh`2LY;T0JgF?00<0JgF?00@0K7J@06]eS`1/
MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0i>?S09bT^@@0JgF?00@0
K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3oool0k>[Z09bT
^@@0YSU400@0YcY40:HiA02W>T@0YcY42@2V>D@00`2LY;T0k>[Z0?ooo`03
0?ooo`40l?7d0@1VIWh0000F06IVOP3RhN80nocl0?_ko03ko?d0o?_m0?_k
o@3ko?d0nocl0?clo@3lo?`0o?_m0?clo03lno`0o?cl0?_lo03lo?`0nocm
0?cko03lo?d0no_m0?_lo080o?cl00@0o?cm0?clo03knod0o?cm<03lno`a
0?_lo0X0nocm00<0W:Bi06]eS`25RK004025RK001P1[MHl0W:Bi0?_lo@3k
o?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3ko?`0no_l09bT^@2V>D@A0:Xl
E@070:HiA02LY;T0nocl0?clo03lnod0nocm0>;QhP0106IVOP0000@0IVIn
0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi0?Ogn03fmoP0m_Oi0?Ogn03g
moT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0moKh0?Kgn03fmoT0moOi0`3f
moT00`3fmoP0moOi0?Ogn@0_0?OgnC40m_Oi2P3gmoT00`1[MHl0QHV`09bN
_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00
JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:Xl
E@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3a
lO@0lO7d0?3am03`l_@@000000060?7am03`l_D0lO7d0?7bm03`l_@0lO7d
H@3`lOD:0?3am00306]eS`2b]M00YjS20100YjS200H0/[G@06]eS`3`lO@0
l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0l?7e0?7bm02V>D@00P32DU/0
0`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32DU/0`U9K0:HiA080l?7d00<0
lO7d0?3bm03NgN400@1VIWh0000706IVOP3Lfn00j^_`0>[[l03Zk?00jN__
000000020>OWi`80g]kN0P3WinL00`3W_H@0inOW0>OWi`030>OWi`80kno_
00@000000>[[l03Zjo00j^__0P3Zjo000`3Zjnl0j^_`0>[[l00^0>[[l340
j^c`2P3Zjnl0101[MHl0][WA0:f^aP2][/H80?ooo`030:f^aP2/[/H0[Jk6
00<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0101[MHl0][WA0:f^aP2][/H<
0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Zjo001@2V>D@0cEUN0<]DF@3=
EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0cEUN0:HiA03Zjnl0j^_`0080
j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3SiNX0hnCZ0P3SiN/01@000000
S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<00>OWi`3WinL00P3WinL01`3_
knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX00P3Si>X00`3Si>/0hnG[0>?U
j`0^0>?Ujc40hnCZ2P3SiNX01@1[MHl0_;kD0;:bbP2b//X0oooo00H0KVf?
00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0JgF?0>?UjP3SiNX0JgF?0;bn
e080/[;:00<0oooo02DU=P0U9CH02@0U9CH30;:bbP050;bne01[MHl0hnC[
0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?ooo`3oool70=ALG`80oooo00X0
e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3SiN/0fMWO0@1VIWh0
000306IVOP3Gf=h0g=kV00<0g=kV00D000000>OWi`3WinL0inOW0>OFcP02
0>OWi`050<ik003_U100inOW0>ONaP3_S1000`3_knl01`000000g=kV0=cN
i@3Lg^D0g=kV0=cNi@3Lg^H0J`3Lg^D01@1[MHl0_l7F0;RicP2h^Lh0oooo
00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0JgF?0=cNi@3Lg^D0
JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh01`2h^Lh00`3oool09BDf0;Ri
cP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V>D@0cEUN0=5JGP3DGF40DbDP
00<0oooo1@3FGf<30?ooo`0505<U803DGF40dEYN0<eIGP2V>D@00P3Lg^D0
0`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn0=GFg@3Ef>00e]SQ0P3Ef>00
2@000000S8b<0>OWi`3WinL0ikF40=IJ003FQ000olh00<iS00020=i[0005
0>neS03_knl0kno_0>o_k`0000000P3Ef>40103Een00e]SP0=KHh@3Fen4`
0=KGh340e]SP2P3Ef>401@1[MHl0`lGI0;bmd@2l_M40oooo00L09BDf1`2l
_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5f@80_;gA00<0oooo02DU=P2l
_M401`2l_M400`3oool09BDf0;bmd@020;bmd@050<?5f@1[MHl0e]OP0=GG
h@2V>D@00P3EGF000`3HH640fF5R04HN6P030?ooo`<0fF5R0`3oool00`16
7QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00eMSQ0=GGh03Ef>40eMKM0@1V
IWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0d=;L000000030>OWi`0<0>ON
cP36BP00mlh00>n]003_]@00cV/00<IJ0036J`00gXa:0>NU003_ilh00000
0`3@d]`00`3?d]`0d=;L0<oBg00`0=3Bg340cm;M2P3@d]`00`1[MHl0b<WK
0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3Bg01[MHl0b<WK0P33a=H00`3o
ool09BDf0<?4eP070<?4eP030?ooo`0U9CH0`lCF0080`lCF00L0b<WK06]e
S`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU00D0AQhJ0?ooo`3oool0oooo
0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aUI@3IHF80eemO0:HiA03@d]d2
0=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn0=3Bf`3;cMP0b/gI0<_>f03:
cMP000000>O6[@3WaX`0mlhH0>nm003gaP00kjd00>N]003WY@00eX`00<i[
003WaP00omH00>o_i`3_knl000000<_=f03;cMT0b/gI0<_>f03:cMP0blgH
<03;cMTa0<_>f@X0blgH00<0JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I
0<S:f@030<S:f@040<S9f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38
b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I
0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD0
0P3NIfL00`167QX0oooo0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3P
IfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn
0<o?fP35b=@00`35b=@01P000000a/K60>ONeP3>N`00ijd00>ne0080ijD0
00<0eY@00<ic003FU0000P3gaP020?Ogm`0400000035b=@0aLOD0<G7e0<0
aLOE<034amDa0<C8e0X0a<OD00<0JgF?0=3Ah03;bm`0403;bm`01P3@dN00
JgF?0<C7e034am@0JgF?0=3Ah080bl_L00<0oooo02DU=P3;bm`01`3;bm`0
0`3oool09BDf0<_;g0020<_;g0070=3Ah01[MHl0aLOD0<C7e02V>D@0ffAT
0=mUI0050>1ZJ00504HN6P3oool0oooo0?ooo`167QX01@3PJVP0103OIF@0
ffAT0:HiA034b=D20<C8e040aLOE0@3?cmX106IVOP0000@0IVIn0<c>fP32
a=80`LCA0P31a=801P000000inOW0>OWi`3WinL0eX@00>ne0080ijD000P0
eX@00<i[003W[@00mkD00?Nm003_knl0moOg000000<0`LCB00<0`/CA0<74
dP31a=80<031a=4a0<74dPX0`/CB00<0JgF?0=?ChP3?d=d0403?d=d01P3C
dn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M00<0oooo02DU=P3?d=d01`3?
d=d00`3oool09BDf0<o@g@020<o@g@070=?ChP1[MHl0`/CB0<74d@2V>D@0
ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203QJFD0ffAT0:HiA031a=80`/CA
0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:c=P0_/3?0;g0c`80_/3>00D0
000009bLW03WinL0imkF0=J<00020=jD00040=Ik0036H`00_D800>nU0080
mjd000P0mkD00?o>BP000000_/3>0;k0c`2n`<h0_/3?0;g0cS40_/3><@2m
`<h:0;k0cP0306]eS`3Fe^@0dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>
06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo00P0oooo00/09BDf0=?Ch03C
dn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo
00@0AQhJ0?ooo`3oool0oooo103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0
c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`0
00000080kno_01<0eY`00=J<003NU000eX@00>nU003NS000_EX00=Ic003_
W000mnoW0?Ogm`3oool000000;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;0300
^Kc<<@2j_<`:0;Zlb`0306]eS`3Hf>D0dm?Q0100dm?Q00H0f=SU06]eS`2j
_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^KHl0KVf?00P0KVf?00h09BDf
0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zlc02V>D@0h6UX0>5]K03TLFd0
i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX00`3oool20>A`KP090>AaK@3Q
KF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0bL[H0040IVIn00002@1VIWh0
alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B40>OWgP020>o_k`070<I[003g
aP00kkD00>nL003NS000cV/00>NL00030?Ogm`050000002f^LT0]kS90;Ji
b@2g^LT00P2f^<T`0;NhbC40][S92P2g^<T0101[MHl0e]KT0=SHi@3Hf>H3
0=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0e]KT06]eS`2g^<T0]kS906]e
S`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U9CH0f=SV0=SHi@3Hf>D0e]KT
06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>MaK`3TM6l00`3oool01@167QX0
i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_0>MaK`3TM6l0i6i]0:HiA02f
^LT0][S90;Jib@2d]/L0alWG0@1VIWh0000306IVOP36b=L0];K700<0];K7
00<000000>o_k`3_knl00P3_knl02`3W[@00mlH80>NU003WU000ih`00>oW
eP3NU3T0kmJe0?ogm`3oool000000740];K700D0JgF?0=GEh`3LfnL0g=_W
0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bfa`1[MHl0eMGS0P3LfnL00`3M
fnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS06]eS`2d]/L0];K70:HiA03W
Lfl0igEb0>YfL`3ZN7H00P3oool00`167QX0jGih0>UnN0030>UnN00804HN
6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V>D@40;Bfa`40a/SG0@1VIWh0
000306IVOP36b=L0];K700<0];K700H0000008b<S03_knl0kno_0>O>N`3_
knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_imH0moOg0?ooo`00001a0;Bf
a`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS06]eS`2d]/L0];K706]eS`3E
e><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V>D@0jWUc0>UlN03_PGX0lXV1
0080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZKS03]UhX0jiR;0080AQhJ00D0
lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40a/SG0@1VIWh0000306IVOP36
b=L0/K?800<0/K?800H000000>o_k`3_knl0kno_0?Ogk`3_knl20?Ogm`03
0?OWaP3gmoL0oooo00<0moOg00<0oooo0000002a/lP0L02a/lP00`1[MHl0
kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?80;6cb01[MHl0kN_c4@3Yj?40
6@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`Q7`0mHb40?NMSP3bZiH0lK:K
0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lZ^F0?NMSP3eS8@0
l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn00000`1VIWh0a/SG0;Rgc`03
0:n^a`050000002][Jd0moO_0?Ogm`3_knl01P3gmoL20?ogm`80oooo00<0
00000:n^a`2_[/L0K`2_[/L00`1[MHl0d]7S0?;am`0@0?;am`060=;Ah`1[
MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3BdN<0JgF?0:n^a`2_[/L0YSU4
0?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V>D@0[jk70080[jk70@2h]ll1
0<K8e`40IVIn00000`1VIWh0`<7A0<O7e0240:b[a00408B<XP1[MHl0c<_M
0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR0P2/Zl@01024S:80JgF?0<c;
g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400L0TIRZ0:HiA03o
Whd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0n^Vf0?WY]P3ijKH0n^Vf0P3i
jKH01P3jjkL0n]bg0?joY03oWhd0YSU4096HZP<0[:_40@37am@10<31d@40
IVIn0000101VIWh0`<7A0=;Bg`2e]<V40:BS_P0308B<XP1[MHl0JgF?00l0
JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80JgF?06]eS`0?06]eS`03
08B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:HiA02V>D@03`2V>D@01`24S:80
Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1VIWh0000606IVOP2XYkl0i^K]
0=;Bh02l_<l0/K34a02XYkl01@2a/<@0_;c?0=;Bh03Vi^d0Z:No0040IVIn
00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@h03:b]X0`P2l_<l01P3:b]X0
d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000201HEfP0IVIn09FDZ`3Gf>80
o?cl0?;al`3/jnh0hN;[`03Gf>801`3Qh^/0k>_^0?;al`3lo?`0emSR09FD
Z`1VIWh00@1HEfP00080F5MX00<0IVIn09FDZ`3AdMh00P3lo?c20?ooo`80
o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0F5MX0P1VIWh00`28Qid0UIB[
0:RW_`310:RW_`0409FDZ`28Qid0IVIn06IVOP<0F5MX000505QGJ<H0IVIn
1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  Evaluatable->False,
  ImageSize->{208, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Table"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[13]=",
  CellTags->"Table"]
}, Open  ]],

Cell["\<\
We can add and remove rows and columns using the model component.\
\>", "Text",
  CellTags->"Table"],

Cell[BoxData[
    \(ref\ @\ 
      InvokeMethod[{"\<myTableModel\>", \ "\<addRow\>"}, \ {"\<x\>", "\<y\>", \
"\<z\>"}]\)], "Input",
  CellLabel->"In[14]:=",
  CellTags->"Table"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[15]:=",
  CellTags->"Table"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003@0000T2000`400?l0
0000o`00003od01VIWh0000306IVOP3ko?d0nocm0<`0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0</0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
bP1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO/P0Oifi
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS
00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0<H0P82000@0Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0@@3oool00`20P800oooo0?oo
o`0o0?ooo`030820P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@110?ooo`040820
P03oool0oooo000003h0oooo00<0P8200?ooo`3oool0?`3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0440oooo00D0P8200?ooo`3oool0oooo0000000m0?ooo`030820P03oool0
oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn
0?_lo@2XZK/0IVIn07nM^@3oool0000000<0oooo00<000000?ooo`3oool0
>@3oool01@20P800oooo0?ooo`3oool0000003d0oooo00<0P8200?ooo`00
00001000000k0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0000000l0?oo
o`050820P03oool0oooo0?ooo`000000?@3oool01020P800oooo0?ooo`00
000n0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1oWKT00`3oool00`000000oooo0?ooo`0k0?ooo`060820
P03oool0oooo0000003oool00000?03oool01@20P800oooo0?ooo`3oool0
000003d0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn07nM^@030?ooo`030000003oool0oooo03/0oooo00H0
P8200?ooo`3oool000000?ooo`00000l0?ooo`050820P03oool0oooo0?oo
o`000000?@3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`000000?03oool0
0`20P800oooo000000030?ooo`030000003oool0oooo03T0oooo00<0P820
0?ooo`3oool00P3oool00`000000oooo0?ooo`0j0?ooo`050820P01oWKT0
IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo
000000030?ooo`030000003oool0oooo03T0oooo00<0P8200?ooo`000000
0`3oool00`000000oooo0?ooo`0i0?ooo`030820P03oool0000000@00000
>`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh0Oifi0440oooo00<0P8200?ooo`3oool0?`3oool00`20P800
oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT0@@3oool00`20P800oooo0?ooo`0o0?oo
o`030820P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@110?ooo`030820P03oool0
oooo03l0oooo00<0P8200?ooo`3oool0?`3oool01@20P800Oifi06IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0440oooo00<0
P8200?ooo`3oool0?`3oool00`20P800oooo0?ooo`0o0?ooo`050820P01o
WKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
@@3oool00`20P800oooo0?ooo`0o0?ooo`030820P03oool0oooo03l0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@110?ooo`030820P03oool0oooo03l0oooo00<0P8200?ooo`3o
ool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0<H0P82000@0Oifi06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0@@3oool00`20P800oooo0?ooo`0o
0?ooo`030820P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@030?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0V0?ooo`050820P03oool0oooo0?ooo`000000203oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo02H0oooo00D0P8200?ooo`3oool0
oooo000000080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3o
ool09P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo02D0oooo00@0P8200?oo
o`3oool000002@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo02D0oooo00@0P8200?ooo`3oool000002@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo02D0oooo00D0P82007nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`030000
003oool0oooo00<0oooo00D000000?ooo`3oool0oooo000000060?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool09@3oool01020P800
oooo0?ooo`0000050?ooo`050000003oool0oooo0?ooo`000000103oool5
000000<0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`00
00050?ooo`050000003oool0oooo0?ooo`0000001@3oool3000000@0oooo
00<000000?ooo`3oool09@3oool01@20P800Oifi06IVOP2XZK/0nocm0040
IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`0000050?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0U0?ooo`040820P03oool0oooo000000D0oooo00<00000
0?ooo`3oool01P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool09@3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3oool0
1@0000090?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
9@3oool01020P800oooo0?ooo`0000020?ooo`D000002@3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo02D0oooo00@0P8200?ooo`3o
ool000000P3oool5000000/0oooo00D000000?ooo`3oool0oooo0000000W
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP1oWKT0oooo000000030?ooo`040000003oool0oooo000000X0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0T0?ooo`03
0820P03oool0000000<0oooo00@000000?ooo`3oool000002`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo02@0oooo00<0P8200?oo
o`0000000`3oool010000000oooo0?ooo`00000<0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0903oool01@20P800Oifi06IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00L0
00000?ooo`3oool0oooo0000003oool0000000X0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0U0?ooo`040820P03oool0oooo0000
00<0oooo00<000000?ooo`000000303oool01@000000oooo0?ooo`3oool0
000002L0oooo00@0P8200?ooo`3oool000000`3oool00`000000oooo0000
000:0?ooo`800000103oool00`000000oooo0?ooo`0U0?ooo`050820P01o
WKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
0P3oool01`000000oooo0?ooo`3oool000000?ooo`000000203oool00`00
0000oooo000000050?ooo`030000003oool0oooo02D0oooo00@0P8200?oo
o`3oool000000`3oool00`000000oooo0000000<0?ooo`050000003oool0
oooo0?ooo`0000009`3oool01020P800oooo0?ooo`0000030?ooo`030000
003oool0000000`0oooo00D000000?ooo`3oool0oooo0000000W0?ooo`05
0820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT00P3oool00`000000oooo0?ooo`020?ooo`8000002@3oool20000
00D0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`000004
0?ooo`800000203oool01@000000oooo0?ooo`3oool0000000<0oooo00<0
00000?ooo`3oool09@3oool01020P800oooo0?ooo`0000040?ooo`800000
203oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool09@3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi00<0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool09P3oool01@20P800oooo0?ooo`3oool0000000@0oooo00<00000
0?ooo`3oool01`3oool3000000<0oooo00<000000?ooo`3oool09P3oool0
1@20P800oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01`3o
ool3000000<0oooo00<000000?ooo`3oool09P3oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0440oooo
00<0P8200?ooo`3oool0?`3oool00`20P800oooo0?ooo`0o0?ooo`050820
P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0@@3oool00`20P800oooo0?ooo`0o0?ooo`030820P03oool0oooo03l0
oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@110?ooo`030820P03oool0oooo03l0oooo00<0P8200?oo
o`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0440oooo00<0P8200?ooo`3oool0?`3oool0
0`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP20P800101oWKT0IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@110?ooo`030820
P03oool0oooo03l0oooo00<0P8200?ooo`3oool0?`3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi00<0
oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo02H0oooo00D0P8200?ooo`3oool0oooo000000080?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool09P3oool01@20
P800oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0V0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool09@3o
ool01020P800oooo0?ooo`0000090?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`0000090?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool09@3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0080oooo00@000000?ooo`3oool0oooo0`0000030?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0U
0?ooo`040820P03oool0oooo000000<0oooo0`0000030?ooo`030000003o
ool0oooo0080oooo1@0000030?ooo`030000003oool0oooo02D0oooo00@0
P8200?ooo`3oool000000`3oool3000000<0oooo00<000000?ooo`3oool0
0`3oool3000000@0oooo00<000000?ooo`3oool09@3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080
oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool09@3oool01020
P800oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`000000203o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo02D0oooo00@0
P8200?ooo`3oool000000P3oool01@000000oooo0?ooo`3oool0000000L0
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo
02D0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@020?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo02D0oooo00@0P8200?ooo`3oool000001P3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool09@3o
ool01020P800oooo0?ooo`0000060?ooo`030000003oool0oooo00T0oooo
00D000000?ooo`3oool0oooo0000000W0?ooo`050820P01oWKT0IVIn0:RY
^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo00000007
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0T0?ooo`030820P03oool0000000L0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo02@0oooo00<0P8200?ooo`0000001`3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0903oool0
1@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1V
IWh0Oifi0080oooo00<000000?ooo`3oool00P3oool2000000X0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0U0?ooo`040820P03o
ool0oooo000000@0oooo0P00000<0?ooo`050000003oool0oooo0?ooo`00
00009`3oool01020P800oooo0?ooo`0000040?ooo`8000002P3oool20000
00@0oooo00<000000?ooo`3oool09@3oool01@20P800Oifi06IVOP2XZK/0
nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003oool0
000000D0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`00
00060?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo
0000000W0?ooo`040820P03oool0oooo000000H0oooo00<000000?ooo`3o
ool02@3oool01@000000oooo0?ooo`3oool0000002L0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@02
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool01P3o
ool2000000D0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?oo
o`0000020?ooo`050000003oool0oooo0?ooo`0000001`3oool01@000000
oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool09@3oool01020
P800oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000001`3o
ool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0
9@3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh0Oifi00<0oooo00<000000?ooo`3oool00`00000:0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool09P3oool01@20P800
oooo0?ooo`3oool000000080oooo0`0000090?ooo`<000000`3oool00`00
0000oooo0?ooo`0V0?ooo`050820P03oool0oooo0?ooo`0000000P3oool3
000000T0oooo0`0000030?ooo`030000003oool0oooo02H0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@110?ooo`030820P03oool0oooo03l0oooo00<0P8200?ooo`3oool0?`3o
ool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0Oifi0440oooo00<0P8200?ooo`3oool0?`3oool00`20P800oooo
0?ooo`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1oWKT0@@3oool00`20P800oooo0?ooo`0o0?ooo`03
0820P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@110?ooo`030820P03oool0oooo
03l0oooo00<0P8200?ooo`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0
nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0P82000@0Oifi
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0@@3o
ool00`20P800oooo0?ooo`0o0?ooo`030820P03oool0oooo03l0oooo00D0
P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
07nM^@030?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0V0?ooo`050820P03oool0oooo0?ooo`00
0000203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02H0
oooo00D0P8200?ooo`3oool0oooo000000080?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool09P3oool01@20P800Oifi06IVOP2XZK/0
nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo02D0oooo00@0P8200?ooo`3oool000002@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo02D0oooo00@0P8200?ooo`3oool00000
2@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo02D0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@020?ooo`030000003oool0oooo00D000000P3oool00`000000
oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool09@3oool01020P800oooo0?ooo`0000020?ooo`D000000P3oool00`00
0000oooo0?ooo`020?ooo`D000000`3oool00`000000oooo0?ooo`0U0?oo
o`040820P03oool0oooo00000080oooo1@0000020?ooo`030000003oool0
oooo00<0oooo0`0000040?ooo`030000003oool0oooo02D0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@020?ooo`050000003oool0oooo0?ooo`000000303oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo02D0oooo00@0P8200?ooo`3oool0
00000`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`0000030?oo
o`030000003oool0oooo00P0oooo00D000000?ooo`3oool0oooo00000003
0?ooo`030000003oool0oooo02D0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo02D0oooo00@0P8200?ooo`3oool00000
103oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`0000040?ooo`03
0000003oool0oooo00/0oooo00D000000?ooo`3oool0oooo0000000W0?oo
o`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP1oWKT0oooo000000060?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0T0?ooo`030820P03o
ool0000000H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo02@0oooo00<0P8200?ooo`0000001P3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0903oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool09@3oool01020P800oooo0?ooo`0000060?ooo`03
0000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo0000000W0?oo
o`040820P03oool0oooo000000H0oooo00<000000?ooo`3oool01`3oool2
000000@0oooo00<000000?ooo`3oool09@3oool01@20P800Oifi06IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`050?ooo`030000003o
ool0000000D0oooo00<000000?ooo`3oool09@3oool01020P800oooo0?oo
o`0000060?ooo`030000003oool0oooo00T0oooo00D000000?ooo`3oool0
oooo0000000W0?ooo`040820P03oool0oooo000000H0oooo00<000000?oo
o`3oool02@3oool01@000000oooo0?ooo`3oool0000002L0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@020?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0
1P3oool2000000D0oooo00<000000?ooo`3oool09@3oool01020P800oooo
0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000001`3oool01@00
0000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool09@3oool0
1020P800oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`000000
1`3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3o
ool09@3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi00<0oooo00<000000?ooo`3oool00`00000:0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool09P3oool01@20
P800oooo0?ooo`3oool000000080oooo0`0000090?ooo`<000000`3oool0
0`000000oooo0?ooo`0V0?ooo`050820P03oool0oooo0?ooo`0000000P3o
ool3000000T0oooo0`0000030?ooo`030000003oool0oooo02H0oooo00D0
P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
07nM^@110?ooo`030820P03oool0oooo03l0oooo00<0P8200?ooo`3oool0
?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh0Oifi0440oooo00<0P8200?ooo`3oool0?`3oool00`20P800
oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT0@@3oool00`20P800oooo0?ooo`0o0?oo
o`030820P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@110?ooo`030820P03oool0
oooo03l0oooo00<0P8200?ooo`3oool0?`3oool01@20P800Oifi06IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0P82000@0
Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
@@2b];l00`20P800oooo0?ooo`0o0?ooo`030820P03oool0oooo03l0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0
IVIn07nM^@2b];lo0?ooo`030;:d_`20P800oooo0400oooo00<0P8200?oo
o`3oool0?`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001P1V
IWh0nocm0:RY^`1VIWh0Oifi0;:d_cl0oooo00<0/[Bo0820P03oool0@03o
ool00`20P800oooo0?ooo`0o0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo0P3oool00`000000
oooo0?ooo`020?ooo`<00000=@3oool00`2b];l0P8200?ooo`020?ooo`03
0000003oool0oooo0080oooo0`0000030?ooo`<00000<03oool01@20P800
oooo0?ooo`3oool0000000@0oooo0`0000030?ooo`<000000`3oool30000
02X0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_l
o@2XZK/0IVIn07nM^@2b];l20?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo0?ooo`0b0?ooo`030;:d_`20P800oooo0080oooo
00D000000?ooo`3oool0oooo000000030?ooo`030000003oool0000000<0
oooo00<000000?ooo`3oool0;@3oool01@20P800oooo0?ooo`3oool00000
00<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo00<0
00000?ooo`0000000`3oool00`000000oooo0?ooo`0W0?ooo`050820P01o
WKT0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0
/[Bo0P3oool01@000000oooo0?ooo`3oool0000000<0oooo00<000000?oo
o`3oool0<P3oool00`2b];l0P8200?ooo`020?ooo`050000003oool0oooo
0?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0
oooo02d0oooo00D0P8200?ooo`3oool0oooo000000030?ooo`070000003o
ool0oooo0?ooo`000000oooo000000030?ooo`030000003oool0000000<0
oooo00<000000?ooo`3oool09`3oool01@20P800Oifi06IVOP2XZK/0nocm
0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi0;:d_`80oooo00D00000
0?ooo`3oool0oooo000000030?ooo`030000003oool0oooo0380oooo00<0
/[Bo0820P03oool00P3oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`0000000`3oool00`000000oooo0?ooo`0]0?ooo`050820
P03oool0oooo0?ooo`0000000`3oool01`000000oooo0?ooo`3oool00000
0?ooo`0000000`3oool00`000000oooo000000030?ooo`030000003oool0
oooo02L0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn
0?_lo@2XZK/0IVIn07nM^@2b];l20?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`0b0?ooo`030;:d_`20P800oooo0080
oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003oool00000
00<0oooo00<000000?ooo`3oool0;@3oool01@20P800oooo0?ooo`3oool0
000000<0oooo00L000000?ooo`3oool0oooo0000003oool0000000<0oooo
00<000000?ooo`0000000`3oool00`000000oooo0?ooo`0W0?ooo`050820
P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000906IVOP3ko?d0Z:Vk06IVOP1o
WKT0/[Bo0000003oool0000000<0oooo00D000000?ooo`3oool0oooo0000
000d0?ooo`060;:d_`20P800oooo0000003oool000000`3oool01`000000
oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0?ooo`0]
0?ooo`050820P03oool000000?ooo`0000000`3oool01`000000oooo0?oo
o`3oool000000?ooo`0000000`3oool00`000000oooo000000030?ooo`03
0000003oool0oooo02L0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l0oooo008000000`3oool0
1@000000oooo0?ooo`3oool0000003@0oooo00@0/[Bo0820P03oool0oooo
0P0000030?ooo`070000003oool0oooo0?ooo`000000oooo000000030?oo
o`030000003oool0oooo02d0oooo00<0P8200?ooo`3oool00P0000030?oo
o`070000003oool0oooo0?ooo`000000oooo000000030?ooo`030000003o
ool0000000<0oooo00<000000?ooo`3oool09`3oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi0;:d_`80
oooo00<000000?ooo`3oool00P3oool3000003D0oooo00<0/[Bo0820P03o
ool00P3oool00`000000oooo0?ooo`020?ooo`<000000`3oool300000300
oooo00D0P8200?ooo`3oool0oooo000000040?ooo`<000000`3oool30000
00<0oooo0`00000Z0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000606IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo?`3oool00`2b];l0P8200?oo
o`100?ooo`030820P03oool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@2b];lo0?ooo`03
0;:d_`20P800oooo0400oooo00<0P8200?ooo`3oool0?`3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi
0;:d_cl0oooo00<0/[Bo0820P03oool0@03oool00`20P800oooo0?ooo`0o
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0@@2b];l00`20P800oooo0?ooo`0o0?ooo`030820P03o
ool0oooo03l0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn07nM^@11075_I0030>3Oh`1aKf@0LFmT03l0LFmT
00<0h=oS075_I01aKf@0?`1aKf@01@3Pgn<0Oifi06IVOP2XZK/0nocm0040
IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi0?ooocl0WIfQ00<0LFmT0>3O
h`3oool0?`2MWJ400`1aKf@0h=oS0?ooo`0o09fMX@06075_I03Pgn<0Oifi
06IVOP2XZK/0nocm0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo
0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80?@3Pgn<01@2MWJ40
LFmT0>3Oh`3oool0lNoR03d0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2X
ZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80
?@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR03d0h=oS00D0WIfQ075_I03P
gn<0oooo0?7_hP0m0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR03d0h=oS
00D0WIfQ075_I03Pgn<0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS0?oo
o`3akn80?@3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0m0>3Oh`0509fM
X@1aKf@0h=oS0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR
03d0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80403Pgn<3000000<0h=oS
00D000000>3Oh`3Pgn<0h=oS000000020>3Oh`<000007@3Pgn<01@2MWJ40
LFmT0>3Oh`3oool0lNoR00l0h=oS00<000000>3Oh`3Pgn<00`3Pgn<01@00
0000h=oS0>3Oh`3Pgn<0000000@0h=oS0`00000L0>3Oh`0509fMX@1aKf@0
h=oS0?ooo`3akn80303Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS
00<000000>3Oh`000000103Pgn<3000000<0h=oS0`00000I0>3Oh`0709fM
X@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2X
ZK/0IVIn07nM^@3oool0lNoR00l0h=oS00D000000>3Oh`3Pgn<0h=oS0000
00020>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`03
0000003Pgn<0h=oS01X0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0?0>3O
h`030000003Pgn<0h=oS00<0h=oS00D000000>3Oh`3Pgn<0h=oS00000003
0>3Oh`050000003Pgn<0h=oS0>3Oh`0000006`3Pgn<01@2MWJ40LFmT0>3O
h`3oool0lNoR00`0h=oS00D000000>3Oh`3Pgn<0h=oS000000030>3Oh`03
0000003Pgn<0000000<0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0
000000<0h=oS00<000000>3Oh`3Pgn<05P3Pgn<01`2MWJ40LFmT0>3Oh`1o
WKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0
oooo0?7_hP0>0>3Oh`030000003Pgn<0h=oS00<0h=oS00<000000>3Oh`00
00000`3Pgn<00`000000h=oS0000000P0>3Oh`0509fMX@1aKf@0h=oS0?oo
o`3akn803`3Pgn<00`000000h=oS0>3Oh`020>3Oh`070000003Pgn<00000
0>3Oh`000000h=oS000000020>3Oh`050000003Pgn<0h=oS0>3Oh`000000
6`3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00`0h=oS00D000000>3Oh`3P
gn<0h=oS000000030>3Oh`030000003Pgn<0000000<0h=oS00<000000>3O
h`3Pgn<00`3Pgn<00`000000h=oS0>3Oh`0J0>3Oh`0709fMX@1aKf@0h=oS
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM
^@3oool0lNoR00h0h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0000000@00000703Pgn<01@2MWJ40LFmT
0>3Oh`3oool0lNoR00l0h=oS00<000000>3Oh`3Pgn<00P3Pgn<01`000000
h=oS0000003Pgn<000000>3Oh`0000000P3Pgn<01@000000h=oS0>3Oh`3P
gn<0000001/0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0<0>3Oh`050000
003Pgn<0h=oS0>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`D0
000000<0h=oS0000000000000`00000H0>3Oh`0709fMX@1aKf@0h=oS07nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3o
ool0lNoR00h0h=oS00<000000>3Oh`3Pgn<00`3Pgn<010000000h=oS0000
000000020>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0
6P3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00l0h=oS00D000000>3Oh`3P
gn<0h=oS000000020>3Oh`030000003Pgn<000000080h=oS00<000000>3O
h`0000000`3Pgn<00`000000h=oS0>3Oh`0I0>3Oh`0509fMX@1aKf@0h=oS
0?ooo`3akn80303Pgn<010000000h=oS0>3Oh`3Pgn<200000080h=oS00@0
00000>3Oh`00000000000P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3O
h`0000000`3Pgn<00`000000h=oS0>3Oh`0F0>3Oh`0709fMX@1aKf@0h=oS
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM
^@3oool0lNoR00h0h=oS00<000000>3Oh`3Pgn<00`3Pgn<010000000h=oS
0000003Pgn<2000000<0h=oS0`00000M0>3Oh`0509fMX@1aKf@0h=oS0?oo
o`3akn803`3Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00D00000
0>3Oh`3Pgn<0h=oS000000020>3Oh`<00000703Pgn<01@2MWJ40LFmT0>3O
h`3oool0lNoR00`0h=oS00H000000>3Oh`3Pgn<0h=oS0000003Pgn<20000
0080h=oS00<000000>3Oh`0000000P3Pgn<3000000<0h=oS0`00000I0>3O
h`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn
0?_lo@2XZK/0IVIn07nM^@3oool0lNoR00l0h=oS00D000000>3Oh`3Pgn<0
h=oS0000000Y0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn803`3Pgn<00`00
0000h=oS0>3Oh`0[0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80303Pgn<0
1@000000h=oS0>3Oh`3Pgn<0000002`0h=oS00L0WIfQ075_I03Pgn<0Oifi
06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?oo
o`3akn80403Pgn<3000002X0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0=
0>3Oh`D00000:`3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00X0h=oS1@00
00000`3Pgn<000000>3Oh`0[0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0
Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR
03d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0
h=oS0?ooo`3akn80?@3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0m0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn80?@3Pgn<01@2MWJ40LFmT0>3Oh`3o
ool0lNoR03d0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80?@3Pgn<01@2M
WJ40LFmT0>3Oh`3oool0lNoR03d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_
hP0m0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR03d0h=oS00D0WIfQ075_
I03Pgn<0oooo0?7_hP0m0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80?@3P
gn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000606IV
OP3ko?d0Z:Vk06IVOP1oWKT0oooo?P3akn80102MWJ40LFmT0>3Oh`3oooln
0?7_hP0409fMX@1aKf@0h=oS0?oooch0lNoR00L0WIfQ075_I03Pgn<0Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0400
oooo00<0LFmT0>3Oh`3oool0?`3oool00`1aKf@0h=oS0?ooo`0o0?ooo`06
075_I03Pgn<0Oifi06IVOP2XZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk
06IVO/P0Oifi00<0IVIn0:RY^`3ko?d00@1VIWh0000306IVOP3gmoT0V9RW
0<X0MgNB0@2HV:L10?Ogn@40IVIn00000`1VIWh0moOi0;bmc@3;0;bmc@40
moOi0@1VIWh0000306IVOP3gmoT0i>?S0</0i>?S0@3gmoT106IVOP0000<0
IVIn0?3am03oool0Q03oool00`3Thn<0W:Bi06]eS`0306]eS`0406afT01[
MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>CSh`2LY;T406]e
S`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>cZ
jP2LY;T40:HiA0040:LjA02V>D@0YcY40:LjA0T0YSU400<0W:Bi0>cZjP3o
ool00`3oool10?3am040IVIn00005P1VIWh0h^7R0?_lo03kno`0nocm0?ck
o@3knod0nocm0?_lo03lo?d0o?cl0?cko@3lo?`0o?_l0?clo03ko?`0o?cl
0?_lo@3lno`0o?cm0?_ko@3ko?`20?clo0040?clo@3lo?`0no_m0?cloC00
o?_l<@3ko?`:0?_lo@0309bT^@1[MHl0QHV`0100QHV`00H0JgF?09bT^@3k
o?d0nocm09bT^@1[MHlA08F9/00606]eS`2LY;T0nocl0?_ko02LY;T0YSU4
4@2Z?5D01`2V>D@0W:Bi0?_lo03lo?`0o?_m0?_lo@3RhN800@1VIWh00004
06IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0m_Oh0?Ogn@3gmoP0m_Oh0?Kgn@3g
moP0moOi0?Ofn03fmoT0moOi0?Kgn@020?Ogn@040?Ofn03fmoP0m_Oi0?Og
n@<0m_Oi00<0m_Oh0?Ogn@3gmoT0;`3gmoTa0?Kgn@X0moOi00<0JgF?08F9
/02LW[h0402LW[h01P25RK00JgF?0?Ogn@3gmoT0JgF?08F9/140W9jn00P0
QHV`06]eS`3fmoP0moOh0:HiA02Z?5D0`U9K0<IDFPd0aUEL00T0aUAJ0<9B
F`2Z?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>400@1VIWh0000606IVOP3N
gN40lO7d0?7am03`lO@0l?;d400000001P3alO@0l?;e0?7am03al_@0l?;d
0?7am640l?7e2P3`lO@00`1[MHl0/[G@0:NX`P0@0:NX`P060;:ed01[MHl0
l?7d0?3am01[MHl0/[G@4@2WZ<801@2b]M00JgF?0?3am@3al_@0YSU40080
`U9K00<0beAI0<eIGP3=FEh02`3=FEh0103;E5T0`U9K0<9BF`2V>D@20?3a
m0030?7am03`l_@0g]gQ0040IVIn00001`1VIWh0g=_P0>[[l03Zjo00j^c`
0>W[k`0000000P3WinL20=kNgP80inOW00<0ikf40>OWi`3WinL00`3WinL2
0>o_k`040000003Zjo00j^_`0>[[k`80j^_`00<0j^__0>[[l03Zjo00;P3Z
jo0a0>[/l0X0j^__00@0JgF?0;Jid@2][/H0[Jk6203oool00`2][/H0[:k6
0:f^aP030:f^aP030:b^aP2f^M40JgF?0080j^__00@0JgF?0;Jid@2][/H0
[Jk6303oool20:f^aP030:b^aP2f^M40JgF?0080j^_`00D0YSU40<eIGP3;
E5T0cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0beAI0<eIGP2V>D@0j^__0>[[
l0020>[[k`40g=_P0@1VIWh0000406IVOP3IfMl0hnGZ0>?TjP80hnG[00D0
000008b<S03Ng]h0inOW0=kNgP020>OWi`030<IS003WinL0inOW0080inOW
00L0knoW0>o_k`3_knl000000>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[0>?U
j`3SiN/0;P3SiN/a0>?TjPX0hnGZ00D0JgF?0;bne02b//X0/[;:0?ooo`06
06i]S`0302DU=P2b//X0/[;:00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ06]e
S`2l_]@20;:bbP030?ooo`0U9CH09BDf00T09BDf0`2b//X01@2l_]@0JgF?
0>?Tj`3Si>/0YSU40080cEUN00@0d5]P0=ALG`3oool0oooo1`3DG5l20?oo
o`0:0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnCZ0>?UjP3Si>X0hnG[0=WIg`40
IVIn00000`1VIWh0emSN0=cNiP030=cNiP050000003WinL0inOW0>OWi`3W
e/h00P3WinL01@3>N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_00L000000=cN
iP3Lg^D0g=kU0=cNiP3Lg^D0g=kV06/0g=kU00D0JgF?0;o1eP2h^Lh0^;W>
0?ooo`0606i]S`0302DU=P2h^Lh0^;W>00D0^;W>00H0_l7F06]eS`3Lg^D0
g=kU06]eS`2o`MH20;RicP030?ooo`0U9CH0^;W>00L0^;W>00<0oooo02DU
=P2h^Lh00P2h^Lh02@2o`MH0JgF?0=cNiP3Lg^D0YSU40<eIGP3AFUh0e5eQ
05<U80030?ooo`D0eUmS0`3oool01@1C9B00e5eQ0=5JGP3=FEh0YSU40080
g=kU00<0g=kV0=cNi@3Gf=h00@1VIWh0000406IVOP3Ee]d0eMSP0=KHh@80
eMSP00T0000008b<S03WinL0inOW0>NeQ03FFP00eX@00?o>003>H`000P3N
J`001@3_]H`0kno_0>o_k`3_knl000000080eMSQ00@0eMOP0=KHh03Ff>40
e]OQ<03Fen0a0=KHh0X0eMSQ00D0JgF?0<?5f@2l_M40_;gA0?ooo`0702DU
=PL0_;gA00H0`lGI06]eS`3Ef>40eMSQ06]eS`33aMT20;bmd@030?ooo`0U
9CH0_;gA00L0_;gA00<0oooo02DU=P2l_M400P2l_M401@33aMT0JgF?0=KG
h03Een40YSU40080eEeP00<0f61Q0=UQHP167QX00`3oool30=UQHP<0oooo
00<0AQhJ0=UQHP3HH6400P3EGF001P2V>D@0e]SP0=GHh@3Een00eMSQ0=GF
g@40IVIn00001`1VIWh0d]CM0<oBg03@d]`0d=;M0=3Bg00000000`3WinL0
303Wg/h0aTX00?O>003_[@00kkD00<i[0036FP00aV/00=j<BP3WY@00knO>
000000<0d=;L00<0cm;L0=3Bg03?d]`0<03@d]`a0<oBg@X0d=;L00<0JgF?
0<S9f`33a=H04033a=H01P38bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80`lCF
00<0oooo02DU=P33a=H01`33a=H00`3oool09BDf0<?4eP020<?4eP070<S9
f`1[MHl0cm;L0<oBg02V>D@0eemO0=UQHP030=aUI@0504HN6P3oool0oooo
0?ooo`3LIFD00`3oool020167QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@0
d=;M0P3@d]`10<oBg040d]CM0@1VIWh0000L06IVOP3@d]/0blgH0<[=f@3;
c]P0b/gH0000003WaZd0ilJ<0?O>603__@00mlH00>n]003W[@00ijD00=J<
003>J`00ilH00?oF003_knL0kno_0000003;cMP0blgI0<[=f@3;c]P0b/gH
0<_=f300blgI<@3;c]T:0<_=f00306]eS`3;c=h0b<[I00P0b<[I00<0b<WI
0<S:f@38b]T00`38b]T01038bMT0b<[I0<_<gP1[MHl20<_=f00606]eS`3;
c=h0b<[I0<S:f@3oool09BDf1@38b]T04@38bMT0b<[I0<S:f@3oool09BDf
0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0eemO0=]TI03PIfD0
h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3oool02P167QX0gVMW0=iWI`3P
IVD0h6MU0=]TI03GGel0YSU40<[>f03:c]T20<_=f@40d=;K0@1VIWh00003
06IVOP3?cmX0aLSD00<0aLSD00H000000<K6aP3Wg]H0cW/00>N]003_]@02
0>NU00030=JD003>L`00eY@00080mlH00P3gmoL010000000aLSD0<G7e035
am@30<G7eC00a<OE<@34b=@:0<C7e00306]eS`3@dN00bl_L0100bl_L00H0
d=7P06]eS`34am@0a<OD06]eS`3@dN020<_;g0030?ooo`0U9CH0bl_L00L0
bl_L00<0oooo02DU=P3;bm`00P3;bm`01`3@dN00JgF?0<G7e034am@0YSU4
0=]TI03OIF@01@3PJVP01@167QX0oooo0?ooo`3oool0AQhJ00D0h6YX00@0
gfET0=]TI02V>D@0a<SE0P34b=@10<G7e@40cloJ0@1VIWh0000406IVOP3<
c]X0`/CB0<74d@80`LCB00H000000>OWi`3WinL0inOW0=J4003_]@020>NU
00080=J4003>J`00ijd00?Ne003g_@00kno_0?Ogm`0000030<74dP030<;4
d@31a=80`LCB0300`LCA<@31a=8:0<;4dP0306]eS`3Cdn80cm3M0100cm3M
00H0dm?R06]eS`32a=80`/CB06]eS`3Cdn820<o@g@030?ooo`0U9CH0cm3M
00L0cm3M00<0oooo02DU=P3?d=d00P3?d=d01`3Cdn80JgF?0<;4dP31a=40
YSU40=]TI03QJFD01@3PK6T50?ooo`D0h6aY00P0hFUU0=]TI02V>D@0`LCB
0<;4d@31a=40`LCB0<c>fP40IVIn0000101VIWh0b/cH0;k0c`2m`<l20;k0
cP050000002LW9`0inOW0>ONeP3FS0000P3NU000103FN`00aV<00;e2003_
Y@020?N]00080?Ne003ocTX000000;k0cP2n`<l0_/3>0;k0c`2m`<ha0;k0
cS40_L3>2P2n`<h00`1[MHl0e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>
0;k0cP1[MHl0e]KT0P3Cdn000`3oool09BDf0?ooo`080?ooo`0;02DU=P3C
dn00dm?P0=?Ch03Fe^@0JgF?0;k0c`2n`<h0YSU40>1VI@3QJVX0103SK6`3
0?ooo`0404HN6P3oool0oooo0?ooo`@0hfa/00@0hFYZ0>1VI@2V>D@0_L3?
0P2n`<l10;k0cP40b/cH0@1VIWh0000706IVOP39b]P0][S80;Vlb`2j_</0
^[c<000000020>o_k`0C0=JL003FS000gY@00=J4003_Y@00gX`00;eJ003F
L`00ki`00?O_i`3gmoL0oooo0000002i_<`0^[_<0;Vlb`2j_</0^Kc<0;Vl
b`0`0;Vlc340^[c<2P2j_</00`1[MHl0f=SU0=?Ch@0@0=?Ch@060=SHi@1[
MHl0^[c;0;Zlb`1[MHl0f=SU0P3Cdn400`3oool0KVf?06i]S`0806i]S`0>
02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0JgF?0;Zlb`2j_<`0YSU40>1YJ03QKF`0
i75]0>AaK`3TL6h30?ooo`0304HN6P3TL6h0AQhJ00<0oooo0P3TL6h02@3T
LFd0hFe/0>1YJ02V>D@0^[c<0;Zkc02i_</0][S80<W:f00106IVOP0000T0
IVIn0<O9e`2d]/L0][S80;Jhb@2f^LT0000008B4Q03Wimh00P3_knl01`36
J`00mlH00>ne003_W000gX`00<i[003WW0000`3gmoL01@000000][W90;Nh
b@2f^LT0]kW90080][S9<02g^<Ta0;Jhb@X0]kS900@0JgF?0=KFi03Hf>D0
f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@090=KFi01[MHl0]kS90;Nh
b@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d09BDf0=SHiP3Hf>D0f=SU
0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo00D0
AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^K@2V
>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn00000`1VIWh0a/SG0;Bfa`03
0;Bfa`030000003_knl0kno_0080kno_00/0ijd00?O6203WY@00ii@00>N<
003_imH0gY@i0>oF]@3omoL0oooo0000001a0;Bfa`0506]eS`3EeN<0g=_W
0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80g=_W
00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GEh`1[MHl0];K70;Bfa`2V
>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ0>UnN03YOWP00`3YOWP0
20167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d]/L10<K8e`40
IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`060000002<S8`0kno_0>o_k`3W
cW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool00000
L@2d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0];K70;Bfa`1[
MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0YSU40>YiL`3YO7P0kh5j
0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:0>^HR`0204HN
6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L10<K8e`40IVIn00000`1V
IWh0a/SG0;6cb0030;6cb0060000003_knl0kno_0>o_k`3gmnl0kno_0P3g
moL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`000000/K?80700/K?800<0
JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[la40
jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0lZ^F
0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3gWHh0
mHb40?24O03aP7D0YSU400@0/K?80@36b=L106IVOP0000<0IVIn0<K8e`2h
]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_00H0moOg0P3omoL20?oo
o`030000002_[/L0[jk706l0[jk700<0JgF?0=;Ah`3blOL0403blOL01P3B
dN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0d]7S06]eS`2_[/L0[jk7
0:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^a`020:n^a`40
^;O?0@36b=L106IVOP0000<0IVIn0<31d@37am@0Q02/Zl@01024S:80JgF?
0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_400@0Q8bR06]e
S`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[a007096HZP2V
>D@0oin=0?joY03jg;L0n^^g0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf0?[Y
]P80nNVf00H0n^^g0?[L]`3n_j@0oin=0:HiA02AV:X30:b[a040alOD0@30
`M4106IVOP0000@0IVIn0<31d@3Bd]l0]KC9Q02TXkh00`24S:80JgF?06]e
S`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]eS`1[MHl03`1[
MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V>D@0YSU400l0YSU400L0
Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040IVIn00001P1VIWh0Z:No
0>KVk@3Bd^00_;c?0;6`a<@0Z:No00D0/K340;blc`3Bd^00i^K]0:RW_`01
06IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@d>00b/[J0<80_;c?00H0
b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ00000P0F5MX06IVOP2EU:/0
emSR0?clo03blO<0k>_^0>7Rjl00emSR00L0hN;[0>c[kP3blO<0o?cl0=OH
hP2EU:/0IVIn0040F5MX000205QGJ00306IVOP2EU:/0dM7N0080o?cl`P3o
ool20?clo0030=7AgP2EU:/0IVIn0080F5MX000305QGJ080IVIn00<0R8NM
09FDZ`2XYkl0`@2XYkl0102EU:/0R8NM06IVOP1VIWh305QGJ0001@1HEfS6
06IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[15]:=",
  Evaluatable->False,
  ImageSize->{208, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Table"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[15]=",
  CellTags->"Table"]
}, Open  ]],

Cell[BoxData[
    \(ref\ @\ 
      InvokeMethod[{"\<myTableModel\>", \ "\<addColumn\>"}, \ "\<Id\>", {"\<1\
\>", "\<2\>", "\<3\>", "\<4\>", "\<5\>"}]\)], "Input",
  CellLabel->"In[16]:=",
  CellTags->"Table"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[17]:=",
  CellTags->"Table"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003@0000T2000`400?l0
0000o`00003od01VIWh0000306IVOP3ko?d0nocm0<`0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0</0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
bP1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO/P0Oifi
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS
00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0<H0P82000@0Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?oo
o`0^0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3oool0;P3o
ool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0Oifi0340oooo00@0P8200?ooo`3oool00000;@3oool00`20P800
oooo0?ooo`0_0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?oo
o`050820P03oool0oooo0?ooo`000000;03oool00`20P800oooo0?ooo`0_
0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000<0oooo
00<000000?ooo`3oool0:@3oool01@20P800oooo0?ooo`3oool0000002`0
oooo00<0P8200?ooo`0000001000000[0?ooo`030820P03oool0oooo00<0
0000:`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`000000;03oool01@20
P800oooo0?ooo`3oool0000002`0oooo00@0P8200?ooo`3oool00000;P3o
ool00`20P800oooo000000030?ooo`030000003oool0oooo02P0oooo00D0
P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
07nM^@030?ooo`030000003oool0oooo02/0oooo00H0P8200?ooo`3oool0
00000?ooo`00000[0?ooo`050820P03oool0oooo0?ooo`000000;@3oool0
0`20P800oooo0?ooo`030?ooo`030000003oool0oooo02P0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@030?ooo`030000003oool0oooo02/0oooo00H0P8200?ooo`3oool00000
0?ooo`00000[0?ooo`050820P03oool0oooo0?ooo`000000;@3oool00`20
P800oooo0?ooo`030?ooo`030000003oool0oooo02P0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@02
0?ooo`030000003oool0000002`0oooo00<0P8200?ooo`0000000`3oool0
0`000000oooo0?ooo`0X0?ooo`030820P03oool0oooo0080oooo00<00000
0?ooo`3oool0:P3oool00`20P800oooo00000003000002/0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM
^@3oool0000000<0oooo00<000000?ooo`3oool0:@3oool00`20P800oooo
000000030?ooo`030000003oool0oooo02P0oooo00<0P8200?ooo`000000
1000000[0?ooo`030820P03oool0000002h0oooo00D0P82007nM^@1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`03
0820P03oool0oooo02h0oooo00<0P8200?ooo`3oool0;`3oool01020P800
oooo0?ooo`00000]0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?ooo`0^
0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3oool01000000Z
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?ooo`0^0?ooo`030820P03o
ool0oooo02l0oooo00<0P8200?ooo`3oool0;P3oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0340oooo
00<0P8200?ooo`3oool0;P3oool00`20P800oooo0?ooo`0_0?ooo`030820
P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`030820P03oool0oooo02h0
oooo00<0P8200?ooo`3oool0;`3oool00`20P800oooo0?ooo`0^0?ooo`05
0820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0<@3oool00`20P800oooo0?ooo`0^0?ooo`030820P03oool0oooo
02l0oooo00<0P8200?ooo`3oool0;P3oool01@20P800Oifi06IVOP2XZK/0
nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0P82000@0Oifi
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3o
ool00`20P800oooo0?ooo`0^0?ooo`030820P03oool0oooo02l0oooo00<0
P8200?ooo`3oool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi00<0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01H0oooo
00D0P8200?ooo`3oool0oooo000000080?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool05@3oool01@20P800oooo0?ooo`3oool00000
00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0F0?oo
o`030820P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0E
0?ooo`040820P03oool0oooo000000T0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0D0?ooo`040820P03oool0oooo000000T0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0E0?ooo`030820
P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool05@3oool01020P800oooo0?ooo`000005
0?ooo`050000003oool0oooo0?ooo`000000103oool5000000<0oooo00<0
00000?ooo`3oool0503oool01020P800oooo0?ooo`0000050?ooo`050000
003oool0oooo0?ooo`0000001@3oool3000000@0oooo00<000000?ooo`3o
ool05@3oool00`20P800oooo0?ooo`020?ooo`030000003oool0oooo02T0
oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@020?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
01D0oooo00@0P8200?ooo`3oool000001@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0503oool0
1020P800oooo0?ooo`0000050?ooo`030000003oool0oooo00H0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo01D0oooo
00<0P8200?ooo`3oool00P3oool00`000000oooo0?ooo`0Y0?ooo`050820
P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT00P3oool00`000000oooo0?ooo`05000000T0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0E0?ooo`040820P03oool0oooo0000
0080oooo1@0000090?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0503oool01020P800oooo0?ooo`0000020?ooo`D000002`3oool0
1@000000oooo0?ooo`3oool0000001L0oooo00<0P8200?ooo`0000001000
000Z0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP1oWKT0oooo000000030?ooo`040000003oool0oooo0000
00X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0D0?oo
o`030820P03oool0000000<0oooo00@000000?ooo`3oool000002`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo00<0P820
0?ooo`0000000`3oool010000000oooo0?ooo`00000<0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0503oool00`20P800oooo0000
00020?ooo`030000003oool0oooo02T0oooo00D0P82007nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`070000
003oool0oooo0?ooo`000000oooo0000000:0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool05@3oool01020P800oooo0?ooo`000003
0?ooo`030000003oool0000000`0oooo00D000000?ooo`3oool0oooo0000
000F0?ooo`040820P03oool0oooo000000<0oooo00<000000?ooo`000000
2P3oool2000000@0oooo00<000000?ooo`3oool05@3oool01P20P800oooo
0?ooo`000000oooo000002/0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`070000003oool0
oooo0?ooo`000000oooo000000080?ooo`030000003oool0000000D0oooo
00<000000?ooo`3oool05@3oool01020P800oooo0?ooo`0000030?ooo`03
0000003oool0000000`0oooo00D000000?ooo`3oool0oooo0000000F0?oo
o`040820P03oool0oooo000000<0oooo00<000000?ooo`000000303oool0
1@000000oooo0?ooo`3oool0000001L0oooo00H0P8200?ooo`3oool00000
0?ooo`00000[0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`020?oo
o`8000002@3oool2000000D0oooo00<000000?ooo`3oool05@3oool01020
P800oooo0?ooo`0000040?ooo`800000203oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`3oool0503oool01020P800oooo0?oo
o`0000040?ooo`800000203oool01@000000oooo0?ooo`3oool0000000<0
oooo00<000000?ooo`3oool05@3oool01020P800oooo0?ooo`3oool20000
02/0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo01H0oooo00D0P8200?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo00L0oooo0`0000030?ooo`030000003oool0oooo01D0oooo00D0
P8200?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00L0oooo
0`0000030?ooo`030000003oool0oooo01H0oooo00<0P8200?ooo`3oool0
0P3oool00`000000oooo0?ooo`0Y0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800
oooo0?ooo`0^0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3o
ool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0340oooo00<0P8200?ooo`3oool0;P3oool00`20
P800oooo0?ooo`0_0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a
0?ooo`030820P03oool0oooo02h0oooo00<0P8200?ooo`3oool0;`3oool0
0`20P800oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?oo
o`0^0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3oool0;P3o
ool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0Oifi0<H0P82000@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?ooo`0^0?ooo`03
0820P03oool0oooo02l0oooo00<0P8200?ooo`3oool0;P3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
00<0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo01H0oooo00D0P8200?ooo`3oool0oooo00000008
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool05@3oool0
1@20P800oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0F0?ooo`030820P03oool0oooo02h0oooo00D0
P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
07nM^@020?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`0E0?ooo`040820P03oool0oooo000000T0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0D0?ooo`04
0820P03oool0oooo000000T0oooo00<000000?ooo`3oool02P3oool00`00
0000oooo0?ooo`0E0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@02
0?ooo`040000003oool0oooo0?ooo`<000000`3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool05@3o
ool01020P800oooo0?ooo`0000030?ooo`<000000`3oool00`000000oooo
0?ooo`020?ooo`D000000`3oool00`000000oooo0?ooo`0D0?ooo`040820
P03oool0oooo000000<0oooo0`0000030?ooo`030000003oool0oooo00<0
oooo0`0000040?ooo`030000003oool0oooo01D0oooo00<0P8200?ooo`3o
ool00`00000[0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool010000000oooo0?ooo`000003
0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0E0?ooo`040820P03oool0oooo00000080oooo00D0
00000?ooo`3oool0oooo000000080?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0503oool01020P800oooo0?ooo`0000020?ooo`05
0000003oool0oooo0?ooo`0000001`3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool05@3oool00`20P800oooo00000003
0?ooo`030000003oool0oooo02P0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo01D0oooo00@0P8200?ooo`3oool00000
1P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0503oool01020P800oooo0?ooo`0000060?ooo`03
0000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo0000000G0?oo
o`030820P03oool0oooo00<0oooo00<000000?ooo`3oool0:03oool01@20
P800Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0
Oifi0?ooo`0000001`3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool0503oool00`20P800oooo0000
00070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`0C0?ooo`030820P03oool0000000L0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo01@0oooo00<0P8200?ooo`3oool00`3oool00`000000oooo0?oo
o`0X0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`020?ooo`800000
2P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01D0oooo
00@0P8200?ooo`3oool00000103oool2000000`0oooo00D000000?ooo`3o
ool0oooo0000000F0?ooo`040820P03oool0oooo000000@0oooo0P00000:
0?ooo`800000103oool00`000000oooo0?ooo`0E0?ooo`040820P03oool0
oooo0?ooo`800000:`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`050?ooo`030000003oool0000000D0oooo
00<000000?ooo`3oool05@3oool01020P800oooo0?ooo`0000060?ooo`03
0000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo0000000F0?oo
o`040820P03oool0oooo000000H0oooo00<000000?ooo`3oool02@3oool0
1@000000oooo0?ooo`3oool0000001L0oooo00<0P8200?ooo`3oool00`3o
ool00`000000oooo0?ooo`0X0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool010000000oooo
0?ooo`0000030?ooo`030000003oool0oooo00H0oooo0P0000050?ooo`03
0000003oool0oooo01D0oooo00@0P8200?ooo`3oool000000P3oool01@00
0000oooo0?ooo`3oool0000000L0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`030000003oool0oooo01@0oooo00@0P8200?ooo`3oool00000
0P3oool01@000000oooo0?ooo`3oool0000000L0oooo00D000000?ooo`3o
ool0oooo000000030?ooo`030000003oool0oooo01D0oooo00<0P8200?oo
o`0000000`3oool00`000000oooo0?ooo`0X0?ooo`050820P01oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00`3oool0
0`000000oooo0?ooo`03000000X0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`0F0?ooo`050820P03oool0oooo0?ooo`0000000P3o
ool3000000T0oooo0`0000030?ooo`030000003oool0oooo01D0oooo00D0
P8200?ooo`3oool0oooo000000020?ooo`<000002@3oool3000000<0oooo
00<000000?ooo`3oool05P3oool00`20P800oooo0?ooo`03000002/0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@0a0?ooo`030820P03oool0oooo02h0oooo00<0P8200?ooo`3o
ool0;`3oool00`20P800oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY
^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20
P800oooo0?ooo`0^0?ooo`030820P03oool0oooo02l0oooo00<0P8200?oo
o`3oool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0340oooo00<0P8200?ooo`3oool0;P3oool0
0`20P800oooo0?ooo`0_0?ooo`030820P03oool0oooo02h0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@0a0?ooo`030820P03oool0oooo02h0oooo00<0P8200?ooo`3oool0;`3o
ool00`20P800oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP20P800101oWKT0IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`03
0820P03oool0oooo02h0oooo00<0P8200?ooo`3oool0;`3oool00`20P800
oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT00`3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool05P3oool01@20
P800oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0E0?ooo`050820P03oool0oooo0?ooo`000000203o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01H0oooo00<0
P8200?ooo`3oool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo
00@0P8200?ooo`3oool000002@3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo01@0oooo00@0P8200?ooo`3oool000002@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00<0P8200?oo
o`3oool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3oool01@000002
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0E0?ooo`040820P03oool0oooo00000080oooo1@00
00020?ooo`030000003oool0oooo0080oooo1@0000030?ooo`030000003o
ool0oooo01@0oooo00@0P8200?ooo`3oool000000P3oool500000080oooo
00<000000?ooo`3oool00`3oool3000000@0oooo00<000000?ooo`3oool0
5@3oool00`20P800oooo00000004000002X0oooo00D0P82007nM^@1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`05
0000003oool0oooo0?ooo`000000303oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo01D0oooo00@0P8200?ooo`3oool000000`3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0oooo00<00000
0?ooo`3oool0503oool01020P800oooo0?ooo`0000030?ooo`030000003o
ool0oooo00P0oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0oooo01D0oooo00@0P8200?ooo`3oool00000;@3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool05@3oool01020
P800oooo0?ooo`0000040?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0D0?ooo`040820P03oool0
oooo000000@0oooo00<000000?ooo`3oool02`3oool01@000000oooo0?oo
o`3oool0000001L0oooo00D0P8200?ooo`3oool0oooo0000000/0?ooo`05
0820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP1oWKT0oooo000000060?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0103oool00`000000oooo0?ooo`0D0?ooo`030820P03oool0
000000H0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo01<0oooo00<0P8200?ooo`0000001P3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0503oool00`20P800oooo0?ooo`020?ooo`030000003oool0
oooo02T0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn07nM^@020?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo01D0oooo00@0P8200?ooo`3oool000001P3oool00`000000oooo
0?ooo`090?ooo`050000003oool0oooo0?ooo`0000005P3oool01020P800
oooo0?ooo`0000060?ooo`030000003oool0oooo00L0oooo0P0000040?oo
o`030000003oool0oooo01D0oooo00<0P8200?ooo`3oool00`3oool00`00
0000oooo0?ooo`0X0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`04
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`0000001@3oool0
0`000000oooo0?ooo`0E0?ooo`040820P03oool0oooo000000H0oooo00<0
00000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000001H0oooo
00@0P8200?ooo`3oool000001P3oool00`000000oooo0?ooo`090?ooo`05
0000003oool0oooo0?ooo`0000005`3oool00`20P800oooo0?ooo`030?oo
o`030000003oool0oooo02P0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`040000003oool0
oooo000000<0oooo00<000000?ooo`3oool01P3oool2000000D0oooo00<0
00000?ooo`3oool05@3oool01020P800oooo0?ooo`0000020?ooo`050000
003oool0oooo0?ooo`0000001`3oool01@000000oooo0?ooo`3oool00000
00<0oooo00<000000?ooo`3oool0503oool01020P800oooo0?ooo`000002
0?ooo`050000003oool0oooo0?ooo`0000001`3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`3oool05@3oool00`20P800oooo
000000030?ooo`030000003oool0oooo02P0oooo00D0P82007nM^@1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@030?ooo`03
0000003oool0oooo00<000002P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo01H0oooo00D0P8200?ooo`3oool0oooo000000020?oo
o`<000002@3oool3000000<0oooo00<000000?ooo`3oool05@3oool01@20
P800oooo0?ooo`3oool000000080oooo0`0000090?ooo`<000000`3oool0
0`000000oooo0?ooo`0F0?ooo`030820P03oool0oooo00<00000:`3oool0
1@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1V
IWh0Oifi0340oooo00<0P8200?ooo`3oool0;P3oool00`20P800oooo0?oo
o`0_0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`030820
P03oool0oooo02h0oooo00<0P8200?ooo`3oool0;`3oool00`20P800oooo
0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?ooo`0^0?ooo`03
0820P03oool0oooo02l0oooo00<0P8200?ooo`3oool0;P3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0340oooo00<0P8200?ooo`3oool0;P3oool00`20P800oooo0?ooo`0_0?oo
o`030820P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360820P00407nM^@1VIWh0
Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0340/[Bo00<0
P8200?ooo`3oool0;P3oool00`20P800oooo0?ooo`0_0?ooo`030820P03o
ool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000H0
IVIn0?_lo@2XZK/0IVIn07nM^@2b];l_0?ooo`030;:d_`20P800oooo02l0
oooo00<0P8200?ooo`3oool0;`3oool00`20P800oooo0?ooo`0^0?ooo`05
0820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IV
OP1oWKT0/[Bo;`3oool00`2b];l0P8200?ooo`0_0?ooo`030820P03oool0
oooo02l0oooo00<0P8200?ooo`3oool0;P3oool01@20P800Oifi06IVOP2X
ZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi0;:d_`80oooo
00<000000?ooo`3oool00P3oool3000002D0oooo00<0/[Bo0820P03oool0
0P3oool00`000000oooo0?ooo`020?ooo`<000000`3oool3000001l0oooo
00D0P8200?ooo`3oool0oooo000000040?ooo`<000000`3oool3000000<0
oooo0`00000J0?ooo`050820P03oool0oooo0?ooo`000000;03oool01@20
P800Oifi06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0
Oifi0;:d_`80oooo00D000000?ooo`3oool0oooo000000030?ooo`030000
003oool0oooo0280oooo00<0/[Bo0820P03oool00P3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000
oooo0?ooo`0L0?ooo`050820P03oool0oooo0?ooo`0000000`3oool01`00
0000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`030000003oool0oooo01L0oooo00D0P8200?ooo`3oool0oooo
0000000/0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000606IV
OP3ko?d0Z:Vk06IVOP1oWKT0/[Bo0P3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool08P3oool00`2b];l0P8200?ooo`02
0?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0000
00030?ooo`030000003oool0oooo01`0oooo00D0P8200?ooo`3oool0oooo
000000030?ooo`070000003oool0oooo0?ooo`000000oooo000000030?oo
o`030000003oool0000000<0oooo00<000000?ooo`3oool05`3oool01@20
P800oooo0?ooo`3oool0000002`0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l20?ooo`050000
003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0R0?ooo`03
0;:d_`20P800oooo0080oooo00D000000?ooo`3oool0oooo000000030?oo
o`030000003oool0000000<0oooo00<000000?ooo`3oool0703oool01@20
P800oooo0?ooo`3oool0000000<0oooo00L000000?ooo`3oool0oooo0000
003oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo
0?ooo`0G0?ooo`050820P03oool0oooo0?ooo`000000;03oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi
0;:d_`80oooo00D000000?ooo`3oool0oooo000000030?ooo`030000003o
ool0oooo0280oooo00<0/[Bo0820P03oool00P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`0000000`3oool00`000000oooo
0?ooo`0L0?ooo`050820P03oool0oooo0?ooo`0000000`3oool01`000000
oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo00000003
0?ooo`030000003oool0oooo01L0oooo00D0P8200?ooo`3oool0oooo0000
000/0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000906IVOP3k
o?d0Z:Vk06IVOP1oWKT0/[Bo0000003oool0000000<0oooo00D000000?oo
o`3oool0oooo0000000T0?ooo`060;:d_`20P800oooo0000003oool00000
0`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`00
0000oooo0?ooo`0L0?ooo`050820P03oool000000?ooo`0000000`3oool0
1`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo
000000030?ooo`030000003oool0oooo01L0oooo00D0P8200?ooo`000000
oooo0000000/0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00007
06IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo0?ooo`02000000<0oooo00D00000
0?ooo`3oool0oooo0000000T0?ooo`040;:d_`20P800oooo0?ooo`800000
0`3oool01`000000oooo0?ooo`3oool000000?ooo`0000000`3oool00`00
0000oooo0?ooo`0L0?ooo`030820P03oool0oooo008000000`3oool01`00
0000oooo0?ooo`3oool000000?ooo`0000000`3oool00`000000oooo0000
00030?ooo`030000003oool0oooo01L0oooo00<0P8200?ooo`3oool00P00
000/0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3k
o?d0Z:Vk06IVOP1oWKT0/[Bo0P3oool00`000000oooo0?ooo`020?ooo`<0
00009@3oool00`2b];l0P8200?ooo`020?ooo`030000003oool0oooo0080
oooo0`0000030?ooo`<000007`3oool01@20P800oooo0?ooo`3oool00000
00@0oooo0`0000030?ooo`<000000`3oool3000001X0oooo00D0P8200?oo
o`3oool0oooo0000000/0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo;`3oool00`2b];l0P820
0?ooo`0_0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3oool0
;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm
0:RY^`1VIWh0Oifi0;:d_bl0oooo00<0/[Bo0820P03oool0;`3oool00`20
P800oooo0?ooo`0_0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@2b
];l_0?ooo`030;:d_`20P800oooo02l0oooo00<0P8200?ooo`3oool0;`3o
ool00`20P800oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@2b];l00`20P800oooo
0?ooo`0^0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3oool0
;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh0Oifi0340LFmT00<0h=oS075_I01aKf@0;P1aKf@00`3Pgn<0
LFmT075_I00_075_I0030>3Oh`1aKf@0LFmT02h0LFmT00D0h=oS07nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@3oool_
09fMX@03075_I03Pgn<0oooo02h0WIfQ00<0LFmT0>3Oh`3oool0;`2MWJ40
0`1aKf@0h=oS0?ooo`0^09fMX@06075_I03Pgn<0Oifi06IVOP2XZK/0nocm
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0]0>3Oh`05
09fMX@1aKf@0h=oS0?ooo`3akn80;03Pgn<01@2MWJ40LFmT0>3Oh`3oool0
lNoR02d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0/0>3Oh`0709fMX@1a
Kf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0
IVIn07nM^@3oool0lNoR02d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0/
0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80;@3Pgn<01@2MWJ40LFmT0>3O
h`3oool0lNoR02`0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm
0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80;@3Pgn<0
1@2MWJ40LFmT0>3Oh`3oool0lNoR02`0h=oS00D0WIfQ075_I03Pgn<0oooo
0?7_hP0]0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80;03Pgn<01`2MWJ40
LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP1oWKT0oooo0?7_hP0]0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80
;03Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR02d0h=oS00D0WIfQ075_I03P
gn<0oooo0?7_hP0/0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR00P0h=oS
0`0000030>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<3000001D0
h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP070>3Oh`030000003Pgn<0h=oS
00<0h=oS00D000000>3Oh`3Pgn<0h=oS000000040>3Oh`<000004`3Pgn<0
1@2MWJ40LFmT0>3Oh`3oool0lNoR00@0h=oS00D000000>3Oh`3Pgn<0h=oS
000000030>3Oh`030000003Pgn<0000000@0h=oS0`0000030>3Oh`<00000
4@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00`0h=oS00<000000>3Oh`3P
gn<00P0000000`3Pgn<000000>3Oh`0H0>3Oh`0709fMX@1aKf@0h=oS07nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3o
ool0lNoR00L0h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3Oh`070000
003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003Pgn<0h=oS
0180h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP070>3Oh`030000003Pgn<0
h=oS00<0h=oS00D000000>3Oh`3Pgn<0h=oS000000030>3Oh`050000003P
gn<0h=oS0>3Oh`0000004P3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00@0
h=oS00D000000>3Oh`3Pgn<0h=oS000000030>3Oh`030000003Pgn<00000
00<0h=oS00L000000>3Oh`3Pgn<0h=oS0000003Pgn<0000000<0h=oS00<0
00000>3Oh`3Pgn<03P3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00`0h=oS
00<000000>3Oh`0000000P3Pgn<2000001T0h=oS00L0WIfQ075_I03Pgn<0
Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi
0?ooo`3akn801P3Pgn<00`000000h=oS0>3Oh`030>3Oh`030000003Pgn<0
000000<0h=oS00<000000>3Oh`000000603Pgn<01@2MWJ40LFmT0>3Oh`3o
ool0lNoR00L0h=oS00<000000>3Oh`3Pgn<00P3Pgn<01`000000h=oS0000
003Pgn<000000>3Oh`0000000P3Pgn<01@000000h=oS0>3Oh`3Pgn<00000
0180h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP040>3Oh`050000003Pgn<0
h=oS0>3Oh`0000000`3Pgn<00`000000h=oS000000030>3Oh`030000003P
gn<0h=oS00<0h=oS00<000000>3Oh`3Pgn<04P3Pgn<01@2MWJ40LFmT0>3O
h`3oool0lNoR00`0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS
0>3Oh`0G0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR00H0h=oS00<00000
0>3Oh`3Pgn<00`3Pgn<00`000000h=oS000000030>3Oh`030000003Pgn<0
000000@00000503Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00L0h=oS00<0
00000>3Oh`3Pgn<00P3Pgn<01`000000h=oS0000003Pgn<000000>3Oh`00
00000P3Pgn<01@000000h=oS0>3Oh`3Pgn<000000180h=oS00D0WIfQ075_
I03Pgn<0oooo0?7_hP040>3Oh`050000003Pgn<0h=oS0>3Oh`0000000`3P
gn<00`000000h=oS000000030>3Oh`D0000000<0h=oS0000000000000`00
000@0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80303Pgn<00`000000h=oS
000000030>3Oh`030000003Pgn<0h=oS01L0h=oS00L0WIfQ075_I03Pgn<0
Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi
0?ooo`3akn801P3Pgn<00`000000h=oS0>3Oh`030>3Oh`040000003Pgn<0
000000000080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3O
h`0B0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn801`3Pgn<01@000000h=oS
0>3Oh`3Pgn<000000080h=oS00<000000>3Oh`0000000P3Pgn<00`000000
h=oS000000030>3Oh`030000003Pgn<0h=oS0100h=oS00D0WIfQ075_I03P
gn<0oooo0?7_hP040>3Oh`040000003Pgn<0h=oS0>3Oh`8000000P3Pgn<0
10000000h=oS0000000000020>3Oh`070000003Pgn<0h=oS0>3Oh`000000
h=oS000000030>3Oh`030000003Pgn<0h=oS00h0h=oS00D0WIfQ075_I03P
gn<0oooo0?7_hP0<0>3Oh`030000003Pgn<000000080h=oS0P00000I0>3O
h`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn
0?_lo@2XZK/0IVIn07nM^@3oool0lNoR00H0h=oS00<000000>3Oh`3Pgn<0
0`3Pgn<010000000h=oS0000003Pgn<2000000<0h=oS0`00000E0>3Oh`05
09fMX@1aKf@0h=oS0?ooo`3akn801`3Pgn<01@000000h=oS0>3Oh`3Pgn<0
000000<0h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3Oh`<000004`3P
gn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00@0h=oS00H000000>3Oh`3Pgn<0
h=oS0000003Pgn<200000080h=oS00<000000>3Oh`0000000P3Pgn<30000
00<0h=oS0`00000A0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80303Pgn<0
0`000000h=oS0>3Oh`02000000030>3Oh`000000h=oS01P0h=oS00L0WIfQ
075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY
^`1VIWh0Oifi0?ooo`3akn801`3Pgn<01@000000h=oS0>3Oh`3Pgn<00000
0240h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP070>3Oh`030000003Pgn<0
h=oS0280h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP040>3Oh`050000003P
gn<0h=oS0>3Oh`000000903Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00`0
h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS0>3Oh`0G0>3Oh`07
09fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn07nM^@3oool0lNoR00P0h=oS0`00000R0>3Oh`0509fMX@1a
Kf@0h=oS0?ooo`3akn801@3Pgn<500000280h=oS00D0WIfQ075_I03Pgn<0
oooo0?7_hP020>3Oh`D0000000<0h=oS0000003Pgn<08`3Pgn<01@2MWJ40
LFmT0>3Oh`3oool0lNoR00`0h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`00
0000h=oS0>3Oh`0G0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR02d0h=oS
00D0WIfQ075_I03Pgn<0oooo0?7_hP0/0>3Oh`0509fMX@1aKf@0h=oS0?oo
o`3akn80;@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR02`0h=oS00L0WIfQ
075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY
^`1VIWh0Oifi0?ooo`3akn80;@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR
02`0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0]0>3Oh`0509fMX@1aKf@0
h=oS0?ooo`3akn80;03Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0]0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn80;03Pgn<01@2MWJ40LFmT0>3Oh`3o
ool0lNoR02d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0/0>3Oh`0709fM
X@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2X
ZK/0IVIn07nM^@3oool0lNoR02d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_
hP0/0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80;@3Pgn<01@2MWJ40LFmT
0>3Oh`3oool0lNoR02`0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0
nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi0?ooobh0lNoR00@0
WIfQ075_I03Pgn<0oooo;@3akn80102MWJ40LFmT0>3Oh`3oool^0?7_hP04
09fMX@1aKf@0h=oS0?ooobd0lNoR00L0WIfQ075_I03Pgn<0Oifi06IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0300oooo00<0
LFmT0>3Oh`3oool0;P3oool00`1aKf@0h=oS0?ooo`0_0?ooo`03075_I03P
gn<0oooo02h0oooo00H0LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d106IVOP00
00@0IVIn0?_lo@2XZK/0IVInb01oWKT00`1VIWh0Z:Vk0?_lo@0106IVOP00
00<0IVIn0?Ogn@2HV:L0bP1gMi8109RHY`40moOi0@1VIWh0000306IVOP3g
moT0_;g=0</0_;g=0@3gmoT106IVOP0000<0IVIn0?Ogn@3Thn<0b`3Thn<1
0?Ogn@40IVIn00000`1VIWh0l?7d0?ooo`240?ooo`030>CSh`2LY;T0JgF?
00<0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0i>?S0?ooo`3o
ool0i>?S09bT^@@0JgF?00@0K7J@06]eS`1/MY00K7J@2@1[MHl01P2LY;T0
i>?S0?ooo`3oool0k>[Z09bT^@@0YSU400@0YcY40:HiA02W>T@0YcY42@2V
>D@00`2LY;T0k>[Z0?ooo`030?ooo`40l?7d0@1VIWh0000F06IVOP3RhN80
nocl0?_ko03ko?d0o?_m0?_ko@3ko?d0nocl0?clo@3lo?`0o?_m0?clo03l
no`0o?cl0?_lo03lo?`0nocm0?cko03lo?d0no_m0?_lo080o?cl00@0o?cm
0?clo03knod0o?cm<03lno`a0?_lo0X0nocm00<0W:Bi06]eS`25RK004025
RK001P1[MHl0W:Bi0?_lo@3ko?d0W:Bi06]eSa40QHV`00H0JgF?09bT^@3k
o?`0no_l09bT^@2V>D@A0:XlE@070:HiA02LY;T0nocl0?clo03lnod0nocm
0>;QhP0106IVOP0000@0IVIn0>3Ph@3fmoT0moOi0P3fmoT02`3fmoP0moOi
0?Ogn03fmoP0m_Oi0?Ogn03gmoT0moKh0?Kgn@3gmoT0m_Oi0080moOi00@0
moKh0?Kgn03fmoT0moOi0`3fmoT00`3fmoP0moOi0?Ogn@0_0?OgnC40m_Oi
2P3gmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0moOi0?Ogn@1[
MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:XlE@32DU/0aUAJ
3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0moOi0>3Ph@01
06IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@000000060?7am03`
l_D0lO7d0?7bm03`l_@0lO7dH@3`lOD:0?3am00306]eS`2b]M00YjS20100
YjS200H0/[G@06]eS`3`lO@0l?7d06]eS`2b]M0A0:NX`P050;:ed01[MHl0
l?7e0?7bm02V>D@00P32DU/00`3;E5T0cEUN0<eIGP0;0<eIGP040<]DF@32
DU/0`U9K0:HiA080l?7d00<0lO7d0?3bm03NgN400@1VIWh0000706IVOP3L
fn00j^_`0>[[l03Zk?00jN__000000020>OWi`80g]kN0P3WinL00`3W_H@0
inOW0>OWi`030>OWi`80kno_00@000000>[[l03Zjo00j^__0P3Zjo000`3Z
jnl0j^_`0>[[l00^0>[[l340j^c`2P3Zjnl0101[MHl0][WA0:f^aP2][/H8
0?ooo`030:f^aP2/[/H0[Jk600<0[Jk600<0[:k60;Jid@1[MHl00P3Zjnl0
101[MHl0][WA0:f^aP2][/H<0?ooo`80[Jk600<0[:k60;Jid@1[MHl00P3Z
jo001@2V>D@0cEUN0<]DF@3=EU/0cUUO00/0d5YO00L0cUUO0<eFF`3;E5T0
cEUN0:HiA03Zjnl0j^_`0080j^__0@3Lfn0106IVOP0000@0IVIn0=WIg`3S
iNX0hnCZ0P3SiN/01@000000S8b<0=kNgP3WinL0g]kN0080inOW00<0aV<0
0>OWi`3WinL00P3WinL01`3_knL0kno_0>o_k`000000hnCZ0>?Tj`3SiNX0
0P3Si>X00`3Si>/0hnG[0>?Uj`0^0>?Ujc40hnCZ2P3SiNX01@1[MHl0_;kD
0;:bbP2b//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0
JgF?0>?UjP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH02@0U9CH3
0;:bbP050;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?oo
o`3oool70=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ
0>?TjP3SiN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0g=kV00D00000
0>OWi`3WinL0inOW0>OFcP020>OWi`050<ik003_U100inOW0>ONaP3_S100
0`3_knl01`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H0J`3Lg^D01@1[
MHl0_l7F0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh0
1P2o`MH0JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh0
1`2h^Lh00`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V
>D@0cEUN0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`0505<U803DGF40
dEYN0<eIGP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn
0=GFg@3Ef>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0ikF40=IJ003F
Q000olh00<iS00020=i[00050>neS03_knl0kno_0>o_k`0000000P3Ef>40
103Een00e]SP0=KHh@3Fen4`0=KGh340e]SP2P3Ef>401@1[MHl0`lGI0;bm
d@2l_M40oooo00L09BDf1`2l_M401P33aMT0JgF?0=GHh@3Ef>40JgF?0<?5
f@80_;gA00<0oooo02DU=P2l_M401`2l_M400`3oool09BDf0;bmd@020;bm
d@050<?5f@1[MHl0e]OP0=GGh@2V>D@00P3EGF000`3HH640fF5R04HN6P03
0?ooo`<0fF5R0`3oool00`167QX0fF5R0=QPH@020=EMH0060:HiA03Ff>00
eMSQ0=GGh03Ef>40eMKM0@1VIWh0000706IVOP3Be=d0cm;L0=3Bg03@d]d0
d=;L000000030>OWi`0<0>ONcP36BP00mlh00>n]003_]@00cV/00<IJ0036
J`00gXa:0>NU003_ilh000000`3@d]`00`3?d]`0d=;L0<oBg00`0=3Bg340
cm;M2P3@d]`00`1[MHl0b<WK0<?4eP0@0<?4eP060<S9f`1[MHl0d=;L0=3B
g01[MHl0b<WK0P33a=H00`3oool09BDf0<?4eP070<?4eP030?ooo`0U9CH0
`lCF0080`lCF00L0b<WK06]eS`3?d]`0cm;L0:HiA03GGel0fF5R00<0g6EU
00D0AQhJ0?ooo`3oool0oooo0=aUI@030?ooo`0804HN6P3LIFD0g6EU0=aU
I@3IHF80eemO0:HiA03@d]d20=3Bg040cm;L0@3Be=d106IVOP0001`0IVIn
0=3Bf`3;cMP0b/gI0<_>f03:cMP000000>O6[@3WaX`0mlhH0>nm003gaP00
kjd00>N]003WY@00eX`00<i[003WaP00omH00>o_i`3_knl000000<_=f03;
cMT0b/gI0<_>f03:cMP0blgH<03;cMTa0<_>f@X0blgH00<0JgF?0<_<gP38
b]T02038b]T00`38bMT0b<[I0<S:f@030<S:f@040<S9f@38b]T0blcN06]e
S`80blgH00H0JgF?0<_<gP38b]T0b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38
b]T0b<[I0?ooo`0U9CH0b<[I0<S9f@38b]T0blcN06]eS`3;c]P0b/gH0:Hi
A03GGel0ffAT0>1WI@3PIVD00P3NIfL00`167QX0oooo0?ooo`030?ooo`0:
04HN6P3NIfL0gVMW0>1VI@3PIfD0ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI
0@3@d]/106IVOP0000<0IVIn0<o?fP35b=@00`35b=@01P000000a/K60>ON
eP3>N`00ijd00>ne0080ijD000<0eY@00<ic003FU0000P3gaP020?Ogm`04
00000035b=@0aLOD0<G7e0<0aLOE<034amDa0<C8e0X0a<OD00<0JgF?0=3A
h03;bm`0403;bm`01P3@dN00JgF?0<C7e034am@0JgF?0=3Ah080bl_L00<0
oooo02DU=P3;bm`01`3;bm`00`3oool09BDf0<_;g0020<_;g0070=3Ah01[
MHl0aLOD0<C7e02V>D@0ffAT0=mUI0050>1ZJ00504HN6P3oool0oooo0?oo
o`167QX01@3PJVP0103OIF@0ffAT0:HiA034b=D20<C8e040aLOE0@3?cmX1
06IVOP0000@0IVIn0<c>fP32a=80`LCA0P31a=801P000000inOW0>OWi`3W
inL0eX@00>ne0080ijD000P0eX@00<i[003W[@00mkD00?Nm003_knl0moOg
000000<0`LCB00<0`/CA0<74dP31a=80<031a=4a0<74dPX0`/CB00<0JgF?
0=?ChP3?d=d0403?d=d01P3Cdn80JgF?0<;4dP32a=80JgF?0=?ChP80cm3M
00<0oooo02DU=P3?d=d01`3?d=d00`3oool09BDf0<o@g@020<o@g@070=?C
hP1[MHl0`/CB0<74d@2V>D@0ffAT0>5YI@050>1/J@D0oooo1@3PK6T0203Q
JFD0ffAT0:HiA031a=80`/CA0<74d@31a=80c<kJ0@1VIWh0000406IVOP3:
c=P0_/3?0;g0c`80_/3>00D0000009bLW03WinL0imkF0=J<00020=jD0004
0=Ik0036H`00_D800>nU0080mjd000P0mkD00?o>BP000000_/3>0;k0c`2n
`<h0_/3?0;g0cS40_/3><@2m`<h:0;k0cP0306]eS`3Fe^@0dm?P0100dm?P
00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?ooo`0U9CH0oooo
00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?0;k0cP2V>D@0
h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo103SK6`0103Q
JVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP0000L0IVIn0<W:
f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<003NU000eX@0
0>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3oool000000;Vlc02j^l`0
^Kc;0;Zlb`2i_<`0^Kc;0300^Kc<<@2j_<`:0;Zlb`0306]eS`3Hf>D0dm?Q
0100dm?Q00H0f=SU06]eS`2j_</0^[c;06]eS`3Hf>D20=?Ch@030?ooo`1^
KHl0KVf?00P0KVf?00h09BDf0=?Ch@3Cdn40dm?Q0=SHi@1[MHl0^[c;0;Zl
c02V>D@0h6UX0>5]K03TLFd0i75_0>A`KP<0oooo00<0AQhJ0>A`KP167QX0
0`3oool20>A`KP090>AaK@3QKF`0h6UX0:HiA02j_<`0^[_<0;Vlb`2f^<P0
bL[H0040IVIn00002@1VIWh0alWG0;Bfa`2f^<P0][S90;Jib@000000Q8B4
0>OWgP020>o_k`070<I[003gaP00kkD00>nL003NS000cV/00>NL00030?Og
m`050000002f^LT0]kS90;Jib@2g^LT00P2f^<T`0;NhbC40][S92P2g^<T0
101[MHl0e]KT0=SHi@3Hf>H30=SHi@D0f=SV0`3Hf>D20=SHiP80f=SU00T0
e]KT06]eS`2g^<T0]kS906]eS`3Fe^@0f=SU0=SHiP3oool02P1^KHl03@0U
9CH0f=SV0=SHi@3Hf>D0e]KT06]eS`2g^<T0]kW90:HiA03TKVd0i7A_0>Ma
K`3TM6l00`3oool01@167QX0i7A_0>AdK`3TM6l0AQhJ00<0oooo00X0i7A_
0>MaK`3TM6l0i6i]0:HiA02f^LT0][S90;Jib@2d]/L0alWG0@1VIWh00003
06IVOP36b=L0];K700<0];K700<000000>o_k`3_knl00P3_knl02`3W[@00
mlH80>NU003WU000ih`00>oWeP3NU3T0kmJe0?ogm`3oool000000740];K7
00D0JgF?0=GEh`3LfnL0g=_W0=gKi`0>0=cKi`060=GEh`1[MHl0];K70;Bf
a`1[MHl0eMGS0P3LfnL00`3MfnL09BDf02DU=P0902DU=P<0g=_W00T0eMGS
06]eS`2d]/L0];K70:HiA03WLfl0igEb0>YfL`3ZN7H00P3oool00`167QX0
jGih0>UnN0030>UnN00804HN6P3oool0oooo0>YhMP3ZMW<0igEb0>McK`2V
>D@40;Bfa`40a/SG0@1VIWh0000306IVOP36b=L0];K700<0];K700H00000
08b<S03_knl0kno_0>O>N`3_knl20?Ogm`080>ND003gilh0moOg0?Ogm`3_
imH0moOg0?ooo`00001a0;Bfa`0306]eS`3Ee><0h=oZ0100h=oZ00H0eMCS
06]eS`2d]/L0];K706]eS`3Ee><A0>3OjP090=GDh`1[MHl0];K70;Bfa`2V
>D@0jWUc0>UlN03_PGX0lXV10080AQhJ00L0jiR;0>ZKS03]UhX0jiR;0>ZK
S03]UhX0jiR;0080AQhJ00D0lXV10>n1NP3YO7P0jWUc0:HiA0040;Bfa`40
a/SG0@1VIWh0000306IVOP36b=L0/K?800<0/K?800H000000>o_k`3_knl0
kno_0?Ogk`3_knl20?Ogm`030?OWaP3gmoL0oooo00<0moOg00<0oooo0000
002a/lP0L02a/lP00`1[MHl0kN_c0>WXl@0@0>WXl@060>g[l`1[MHl0/K?8
0;6cb01[MHl0kN_c4@3Yj?406@3]jo<0JgF?0;6cb02a/lP0YSU40?60M@3`
Q7`0mHb40?NMSP3bZiH0lK:K0>fdV`3/]I`0lK:K0>fdV`3/]I`0lK:K0>fd
V`3/]I`0lZ^F0?NMSP3eS8@0l8Al0?60M@2V>D@0102a/lP10<K8e`40IVIn
00000`1VIWh0a/SG0;Rgc`030:n^a`050000002][Jd0moO_0?Ogm`3_knl0
1P3gmoL20?ogm`80oooo00<000000:n^a`2_[/L0K`2_[/L00`1[MHl0d]7S
0?;am`0@0?;am`060=;Ah`1[MHl0[jk70:n^a`1[MHl0d]7S4@3blOL01P3B
dN<0JgF?0:n^a`2_[/L0YSU40?B:O@80mI253@3b^9h20?F@Q@030?B:O@2V
>D@0[jk70080[jk70@2h]ll10<K8e`40IVIn00000`1VIWh0`<7A0<O7e024
0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR
0P2/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<
XP80[:_400L0TIRZ0:HiA03oWhd0o[nT0?[L]`3jjkL0n^Vf0080nNVf00@0
n^Vf0?WY]P3ijKH0n^Vf0P3ijKH01P3jjkL0n]bg0?joY03oWhd0YSU4096H
ZP<0[:_40@37am@10<31d@40IVIn0000101VIWh0`<7A0=;Bg`2e]<V40:BS
_P0308B<XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24
S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR0:Hi
A02V>D@03`2V>D@01`24S:80Y:>n0:BS_P2TXkh0]KC90=;Bg`30`M400@1V
IWh0000606IVOP2XYkl0i^K]0=;Bh02l_<l0/K34a02XYkl01@2a/<@0_;c?
0=;Bh03Vi^d0Z:No0040IVIn00001`1HEfP0QhNK0=OHhP3lo?`0i>?X0=3@
h03:b]X0`P2l_<l01P3:b]X0d=3P0>CSj03lo?`0emSR08N7V`40F5MX0000
201HEfP0IVIn09FDZ`3Gf>80o?cl0?;al`3/jnh0hN;[`03Gf>801`3Qh^/0
k>_^0?;al`3lo?`0emSR09FDZ`1VIWh00@1HEfP00080F5MX00<0IVIn09FD
Z`3AdMh00P3lo?c20?ooo`80o?cl00<0dM7N09FDZ`1VIWh00P1HEfP000<0
F5MX0P1VIWh00`28Qid0UIB[0:RW_`310:RW_`0409FDZ`28Qid0IVIn06IV
OP<0F5MX000505QGJ<H0IVIn1@1HEfP00001\
\>"], "Graphics",
  CellLabel->"From In[17]:=",
  Evaluatable->False,
  ImageSize->{208, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Table"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[17]=",
  CellTags->"Table"]
}, Open  ]],

Cell[BoxData[
    \(ref\ @\ 
      InvokeMethod[{"\<myTableModel\>", \ "\<removeRow\>"}, 0]\)], "Input",
  CellLabel->"In[18]:=",
  CellTags->"Table"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[19]:=",
  CellTags->"Table"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003@0000T2000`400?l0
0000o`00003od01VIWh0000306IVOP3ko?d0nocm0<`0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0</0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
bP1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO/P0Oifi
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS
00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM
^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0
h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn
0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`04
07nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0
nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0
IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3O
h`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0aP20P800101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`030820P03oool0oooo02h0oooo
00<0P8200?ooo`3oool0;`3oool00`20P800oooo0?ooo`0^0?ooo`050820
P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0<@3oool01020P800oooo0?ooo`00000]0?ooo`030820P03oool0oooo
02l0oooo00<0P8200?ooo`3oool0;P3oool01@20P800Oifi06IVOP2XZK/0
nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0340oooo00D0P820
0?ooo`3oool0oooo0000000/0?ooo`030820P03oool0oooo02l0oooo00<0
P8200?ooo`3oool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn
00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`0000000`3oool00`000000
oooo0?ooo`0Y0?ooo`050820P03oool0oooo0?ooo`000000;03oool00`20
P800oooo00000004000002/0oooo00<0P8200?ooo`3oool00`00000[0?oo
o`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT00P3oool00`000000oooo0000000/0?ooo`050820P03oool0
oooo0?ooo`000000;03oool01020P800oooo0?ooo`00000^0?ooo`030820
P03oool0000000<0oooo00<000000?ooo`3oool0:03oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi00<0
oooo00<000000?ooo`3oool0:`3oool01P20P800oooo0?ooo`000000oooo
000002/0oooo00D0P8200?ooo`3oool0oooo0000000]0?ooo`030820P03o
ool0oooo00<0oooo00<000000?ooo`3oool0:03oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi00<0oooo
00<000000?ooo`3oool0:`3oool01P20P800oooo0?ooo`000000oooo0000
02/0oooo00D0P8200?ooo`3oool0oooo0000000]0?ooo`030820P03oool0
oooo00<0oooo00<000000?ooo`3oool0:03oool01@20P800Oifi06IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<0
00000?ooo`000000;03oool00`20P800oooo000000030?ooo`030000003o
ool0oooo02P0oooo00<0P8200?ooo`3oool00P3oool00`000000oooo0?oo
o`0Z0?ooo`030820P03oool0000000<00000:`3oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`00
00000`3oool00`000000oooo0?ooo`0Y0?ooo`030820P03oool0000000<0
oooo00<000000?ooo`3oool0:03oool00`20P800oooo00000004000002/0
oooo00<0P8200?ooo`000000;P3oool01@20P800Oifi06IVOP2XZK/0nocm
0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0340oooo00<0P8200?oo
o`3oool0;P3oool00`20P800oooo0?ooo`0_0?ooo`040820P03oool0oooo
000002d0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn
0?_lo@2XZK/0IVIn07nM^@0a0?ooo`030820P03oool0oooo02h0oooo00<0
P8200?ooo`3oool0;`3oool00`20P800oooo0?ooo`04000002X0oooo00D0
P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
07nM^@0a0?ooo`030820P03oool0oooo02h0oooo00<0P8200?ooo`3oool0
;`3oool00`20P800oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800
oooo0?ooo`0^0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3o
ool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0340oooo00<0P8200?ooo`3oool0;P3oool00`20
P800oooo0?ooo`0_0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a
0?ooo`030820P03oool0oooo02h0oooo00<0P8200?ooo`3oool0;`3oool0
0`20P800oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP20P800101oWKT0IVIn0:RY
^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`030820
P03oool0oooo02h0oooo00<0P8200?ooo`3oool0;`3oool00`20P800oooo
0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1oWKT00`3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool05P3oool01@20P800
oooo0?ooo`3oool0000000P0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`0E0?ooo`050820P03oool0oooo0?ooo`000000203oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo01H0oooo00<0P820
0?ooo`3oool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00@0
P8200?ooo`3oool000002@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo01@0oooo00@0P8200?ooo`3oool000002@3oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00<0P8200?ooo`3o
ool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3oool00`3oool01@00
0000oooo0?ooo`3oool0000000H0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0E0?ooo`040820P03oool0oooo000000D0oooo00D0
00000?ooo`3oool0oooo000000040?ooo`D000000`3oool00`000000oooo
0?ooo`0D0?ooo`040820P03oool0oooo000000D0oooo00D000000?ooo`3o
ool0oooo000000050?ooo`<00000103oool00`000000oooo0?ooo`0E0?oo
o`030820P03oool0oooo0080oooo00<000000?ooo`3oool0:@3oool01@20
P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool05@3oool0
1020P800oooo0?ooo`0000050?ooo`030000003oool0oooo00L0oooo00<0
00000?ooo`3oool0103oool00`000000oooo0?ooo`0D0?ooo`040820P03o
ool0oooo000000D0oooo00<000000?ooo`3oool01P3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool05@3oool00`20P800
oooo0?ooo`020?ooo`030000003oool0oooo02T0oooo00D0P82007nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?oo
o`030000003oool0oooo00D000002@3oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo01D0oooo00@0P8200?ooo`3oool000000P3oool5
000000T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0D
0?ooo`040820P03oool0oooo00000080oooo1@00000;0?ooo`050000003o
ool0oooo0?ooo`0000005`3oool00`20P800oooo00000004000002X0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0
IVIn07nM^@3oool0000000<0oooo00@000000?ooo`3oool000002P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo01@0oooo00<0P820
0?ooo`0000000`3oool010000000oooo0?ooo`00000;0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool04`3oool00`20P800oooo0000
00030?ooo`040000003oool0oooo000000`0oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`0D0?ooo`030820P03oool000000080oooo
00<000000?ooo`3oool0:@3oool01@20P800Oifi06IVOP2XZK/0nocm0040
IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00L000000?ooo`3o
ool0oooo0000003oool0000000X0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0E0?ooo`040820P03oool0oooo000000<0oooo00<0
00000?ooo`000000303oool01@000000oooo0?ooo`3oool0000001H0oooo
00@0P8200?ooo`3oool000000`3oool00`000000oooo0000000:0?ooo`80
0000103oool00`000000oooo0?ooo`0E0?ooo`060820P03oool0oooo0000
003oool00000:`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn0000
1@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00L000000?ooo`3oool0oooo
0000003oool0000000P0oooo00<000000?ooo`0000001@3oool00`000000
oooo0?ooo`0E0?ooo`040820P03oool0oooo000000<0oooo00<000000?oo
o`000000303oool01@000000oooo0?ooo`3oool0000001H0oooo00@0P820
0?ooo`3oool000000`3oool00`000000oooo0000000<0?ooo`050000003o
ool0oooo0?ooo`0000005`3oool01P20P800oooo0?ooo`000000oooo0000
02/0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@020?ooo`030000003oool0oooo0080oooo0P000009
0?ooo`8000001@3oool00`000000oooo0?ooo`0E0?ooo`040820P03oool0
oooo000000@0oooo0P0000080?ooo`050000003oool0oooo0?ooo`000000
0`3oool00`000000oooo0?ooo`0D0?ooo`040820P03oool0oooo000000@0
oooo0P0000080?ooo`050000003oool0oooo0?ooo`0000000`3oool00`00
0000oooo0?ooo`0E0?ooo`040820P03oool0oooo0?ooo`800000:`3oool0
1@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1V
IWh0Oifi00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool05P3o
ool01@20P800oooo0?ooo`3oool0000000@0oooo00<000000?ooo`3oool0
1`3oool3000000<0oooo00<000000?ooo`3oool05@3oool01@20P800oooo
0?ooo`3oool0000000@0oooo00<000000?ooo`3oool01`3oool3000000<0
oooo00<000000?ooo`3oool05P3oool00`20P800oooo0?ooo`020?ooo`03
0000003oool0oooo02T0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`030820P03oool0oooo
02h0oooo00<0P8200?ooo`3oool0;`3oool00`20P800oooo0?ooo`0^0?oo
o`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk
06IVOP1oWKT0<@3oool00`20P800oooo0?ooo`0^0?ooo`030820P03oool0
oooo02l0oooo00<0P8200?ooo`3oool0;P3oool01@20P800Oifi06IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0340oooo00<0
P8200?ooo`3oool0;P3oool00`20P800oooo0?ooo`0_0?ooo`030820P03o
ool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0
IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`030820P03oool0oooo02h0oooo
00<0P8200?ooo`3oool0;`3oool00`20P800oooo0?ooo`0^0?ooo`050820
P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0aP20P800101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@0a0?ooo`030820P03oool0oooo02h0oooo00<0P8200?oo
o`3oool0;`3oool00`20P800oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00`3oool0
0`000000oooo0?ooo`060?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool05P3oool01@20P800oooo0?ooo`3oool0000000P0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?ooo`050820P03o
ool0oooo0?ooo`000000203oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo01H0oooo00<0P8200?ooo`3oool0;P3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080
oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0:0?ooo`03
0000003oool0oooo01D0oooo00@0P8200?ooo`3oool000002@3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo01@0oooo00@0P8200?oo
o`3oool000002@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo01D0oooo00<0P8200?ooo`3oool0;P3oool01@20P800Oifi06IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00@0
00000?ooo`3oool0oooo0`0000030?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0E0?ooo`040820
P03oool0oooo000000<0oooo0`0000030?ooo`030000003oool0oooo0080
oooo1@0000030?ooo`030000003oool0oooo01@0oooo00@0P8200?ooo`3o
ool000000`3oool3000000<0oooo00<000000?ooo`3oool00`3oool30000
00@0oooo00<000000?ooo`3oool05@3oool00`20P800oooo0?ooo`030000
02/0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@020?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo01D0oooo00@0P8200?ooo`3oool000000P3oool01@000000oooo
0?ooo`3oool0000000P0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0D0?ooo`040820P03oool0oooo00000080oooo00D000000?oo
o`3oool0oooo000000070?ooo`050000003oool0oooo0?ooo`0000000`3o
ool00`000000oooo0?ooo`0E0?ooo`030820P03oool0000000<0oooo00<0
00000?ooo`3oool0:03oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool05@3oool01020P800oooo0?ooo`0000060?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0D0?ooo`040820P03oool0oooo000000H0oooo00<000000?oo
o`3oool02@3oool01@000000oooo0?ooo`3oool0000001L0oooo00<0P820
0?ooo`3oool00`3oool00`000000oooo0?ooo`0X0?ooo`050820P01oWKT0
IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo
000000070?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0D0?ooo`030820P03oool0000000L0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo01<0oooo00<0P8200?ooo`0000001`3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0
503oool00`20P800oooo0?ooo`030?ooo`030000003oool0oooo02P0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@020?ooo`030000003oool0oooo0080oooo0P00000:0?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool05@3oool01020P800
oooo0?ooo`0000040?ooo`800000303oool01@000000oooo0?ooo`3oool0
000001H0oooo00@0P8200?ooo`3oool00000103oool2000000X0oooo0P00
00040?ooo`030000003oool0oooo01D0oooo00@0P8200?ooo`3oool0oooo
0P00000[0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`0000001@3oool00`000000
oooo0?ooo`0E0?ooo`040820P03oool0oooo000000H0oooo00<000000?oo
o`3oool02@3oool01@000000oooo0?ooo`3oool0000001H0oooo00@0P820
0?ooo`3oool000001P3oool00`000000oooo0?ooo`090?ooo`050000003o
ool0oooo0?ooo`0000005`3oool00`20P800oooo0?ooo`030?ooo`030000
003oool0oooo02P0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`040000003oool0oooo0000
00<0oooo00<000000?ooo`3oool01P3oool2000000D0oooo00<000000?oo
o`3oool05@3oool01020P800oooo0?ooo`0000020?ooo`050000003oool0
oooo0?ooo`0000001`3oool01@000000oooo0?ooo`3oool0000000<0oooo
00<000000?ooo`3oool0503oool01020P800oooo0?ooo`0000020?ooo`05
0000003oool0oooo0?ooo`0000001`3oool01@000000oooo0?ooo`3oool0
000000<0oooo00<000000?ooo`3oool05@3oool00`20P800oooo00000003
0?ooo`030000003oool0oooo02P0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@030?ooo`030000003o
ool0oooo00<000002P3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo01H0oooo00D0P8200?ooo`3oool0oooo000000020?ooo`<00000
2@3oool3000000<0oooo00<000000?ooo`3oool05@3oool01@20P800oooo
0?ooo`3oool000000080oooo0`0000090?ooo`<000000`3oool00`000000
oooo0?ooo`0F0?ooo`030820P03oool0oooo00<00000:`3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0340oooo00<0P8200?ooo`3oool0;P3oool00`20P800oooo0?ooo`0_0?oo
o`030820P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`030820P03oool0
oooo02h0oooo00<0P8200?ooo`3oool0;`3oool00`20P800oooo0?ooo`0^
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?ooo`0^0?ooo`030820P03o
ool0oooo02l0oooo00<0P8200?ooo`3oool0;P3oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0340oooo
00<0P8200?ooo`3oool0;P3oool00`20P800oooo0?ooo`0_0?ooo`030820
P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@360820P00407nM^@1VIWh0Z:Vk0?_l
o@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0340/[Bo00<0P8200?oo
o`3oool0;P3oool00`20P800oooo0?ooo`0_0?ooo`030820P03oool0oooo
02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_l
o@2XZK/0IVIn07nM^@2b];l20?ooo`030000003oool0oooo00H0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`0E0?ooo`030;:d_`20
P800oooo0080oooo00<000000?ooo`3oool01P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo01D0oooo00D0P8200?ooo`3oool0oooo
000000080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
5P3oool00`20P800oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo0?ooo`000009
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0503oool0
1@2b];l0P8200?ooo`3oool0000000T0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0D0?ooo`040820P03oool0oooo000000T0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0E0?ooo`030820
P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00P0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l0oooo00000080oooo1@000002
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0D0?ooo`050;:d_`20P800oooo0?ooo`0000000P3o
ool500000080oooo00<000000?ooo`3oool00P3oool5000000<0oooo00<0
00000?ooo`3oool0503oool01020P800oooo0?ooo`0000020?ooo`D00000
0P3oool00`000000oooo0?ooo`030?ooo`<00000103oool00`000000oooo
0?ooo`0E0?ooo`030820P03oool0000000@00000:P3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn0000201VIWh0nocm0:RY^`1VIWh0Oifi0;:d
_`3oool000000`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0503oool01@2b];l0P8200?ooo`3o
ool0000000<0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo01@0oooo00@0P8200?ooo`3oool00000
0`3oool00`000000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`00
00000`3oool00`000000oooo0?ooo`0E0?ooo`040820P03oool0oooo0000
02d0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_l
o@2XZK/0IVIn07nM^@2b];l0oooo000000@0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo01@0oooo
00D0/[Bo0820P03oool0oooo000000040?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0D0?ooo`04
0820P03oool0oooo000000@0oooo00<000000?ooo`3oool02`3oool01@00
0000oooo0?ooo`3oool0000001L0oooo00D0P8200?ooo`3oool0oooo0000
000/0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP1oWKT0/[Bo000000060?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0C0?ooo`04
0;:d_`20P800oooo000000H0oooo00<000000?ooo`3oool02@3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo00<0P8200?oo
o`0000001P3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0503oool00`20P800oooo0?ooo`020?oo
o`030000003oool0oooo02T0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000P0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l0oooo000000H0oooo
00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo01@0oooo00D0/[Bo0820P03oool0oooo000000060?ooo`03
0000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo0000000F0?oo
o`040820P03oool0oooo000000H0oooo00<000000?ooo`3oool01`3oool2
000000@0oooo00<000000?ooo`3oool05@3oool00`20P800oooo0?ooo`03
0?ooo`030000003oool0oooo02P0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l0oooo000000H0
oooo00<000000?ooo`3oool01@3oool00`000000oooo000000050?ooo`03
0000003oool0oooo01@0oooo00D0/[Bo0820P03oool0oooo000000060?oo
o`030000003oool0oooo00T0oooo00D000000?ooo`3oool0oooo0000000F
0?ooo`040820P03oool0oooo000000H0oooo00<000000?ooo`3oool02@3o
ool01@000000oooo0?ooo`3oool0000001L0oooo00<0P8200?ooo`3oool0
0`3oool00`000000oooo0?ooo`0X0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo0?ooo`000002
0?ooo`050000003oool0oooo0?ooo`000000203oool2000000D0oooo00<0
00000?ooo`3oool0503oool01@2b];l0P8200?ooo`3oool000000080oooo
00D000000?ooo`3oool0oooo000000070?ooo`050000003oool0oooo0?oo
o`0000000`3oool00`000000oooo0?ooo`0D0?ooo`040820P03oool0oooo
00000080oooo00D000000?ooo`3oool0oooo000000070?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0E0?ooo`030820
P03oool0000000<0oooo00<000000?ooo`3oool0:03oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi0;:d
_`80oooo00<000000?ooo`3oool00`00000:0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool05@3oool00`2b];l0P8200?ooo`020?oo
o`030000003oool0oooo00<000002@3oool3000000<0oooo00<000000?oo
o`3oool05@3oool01@20P800oooo0?ooo`3oool000000080oooo0`000009
0?ooo`<000000`3oool00`000000oooo0?ooo`0F0?ooo`030820P03oool0
oooo00<00000:`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn0000
1P1VIWh0nocm0:RY^`1VIWh0Oifi0;:d_bl0oooo00<0/[Bo0820P03oool0
;`3oool00`20P800oooo0?ooo`0_0?ooo`030820P03oool0oooo02h0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0
IVIn07nM^@2b];l_0?ooo`030;:d_`20P800oooo02l0oooo00<0P8200?oo
o`3oool0;`3oool00`20P800oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo;`3o
ool00`2b];l0P8200?ooo`0_0?ooo`030820P03oool0oooo02l0oooo00<0
P8200?ooo`3oool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0340/[Bo00<0P8200?ooo`3oool0
;P3oool00`20P800oooo0?ooo`0_0?ooo`030820P03oool0oooo02h0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@0a075_I0030>3Oh`1aKf@0LFmT02h0LFmT00<0h=oS075_I01a
Kf@0;`1aKf@00`3Pgn<0LFmT075_I00^075_I0050>3Oh`1oWKT0IVIn0:RY
^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo;`2MWJ40
0`1aKf@0h=oS0?ooo`0^09fMX@03075_I03Pgn<0oooo02l0WIfQ00<0LFmT
0>3Oh`3oool0;P2MWJ401P1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@40IVIn
00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80;@3Pgn<01@2MWJ40
LFmT0>3Oh`3oool0lNoR02`0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0]
0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80;03Pgn<01`2MWJ40LFmT0>3O
h`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1o
WKT0oooo0?7_hP0]0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80;03Pgn<0
1@2MWJ40LFmT0>3Oh`3oool0lNoR02d0h=oS00D0WIfQ075_I03Pgn<0oooo
0?7_hP0/0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR02d0h=oS00D0WIfQ
075_I03Pgn<0oooo0?7_hP0/0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80
;@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR02`0h=oS00L0WIfQ075_I03P
gn<0Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0
Oifi0?ooo`3akn80;@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR02`0h=oS
00D0WIfQ075_I03Pgn<0oooo0?7_hP0]0>3Oh`0509fMX@1aKf@0h=oS0?oo
o`3akn80;03Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP080>3Oh`<00000
0`3Pgn<01@000000h=oS0>3Oh`3Pgn<000000080h=oS0`00000E0>3Oh`05
09fMX@1aKf@0h=oS0?ooo`3akn801`3Pgn<00`000000h=oS0>3Oh`030>3O
h`050000003Pgn<0h=oS0>3Oh`000000103Pgn<3000001<0h=oS00D0WIfQ
075_I03Pgn<0oooo0?7_hP040>3Oh`050000003Pgn<0h=oS0>3Oh`000000
0`3Pgn<00`000000h=oS000000040>3Oh`<000000`3Pgn<300000140h=oS
00D0WIfQ075_I03Pgn<0oooo0?7_hP0<0>3Oh`030000003Pgn<0h=oS0080
000000<0h=oS0000003Pgn<0603Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_
hP070>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<01`000000h=oS
0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`0B0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn801`3Pgn<00`000000h=oS0>3Oh`03
0>3Oh`050000003Pgn<0h=oS0>3Oh`0000000`3Pgn<01@000000h=oS0>3O
h`3Pgn<000000180h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP040>3Oh`05
0000003Pgn<0h=oS0>3Oh`0000000`3Pgn<00`000000h=oS000000030>3O
h`070000003Pgn<0h=oS0>3Oh`000000h=oS000000030>3Oh`030000003P
gn<0h=oS00h0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0<0>3Oh`030000
003Pgn<000000080h=oS0P00000I0>3Oh`0709fMX@1aKf@0h=oS07nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0
lNoR00H0h=oS00<000000>3Oh`3Pgn<00`3Pgn<00`000000h=oS00000003
0>3Oh`030000003Pgn<0000001P0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_
hP070>3Oh`030000003Pgn<0h=oS0080h=oS00L000000>3Oh`000000h=oS
0000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS0000000B0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn80103Pgn<01@000000h=oS0>3Oh`3P
gn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3O
h`030>3Oh`030000003Pgn<0h=oS0180h=oS00D0WIfQ075_I03Pgn<0oooo
0?7_hP0<0>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<0
5`3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh00007
06IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP060>3Oh`030000003Pgn<0
h=oS00<0h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS00000004
000001@0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP070>3Oh`030000003P
gn<0h=oS0080h=oS00L000000>3Oh`000000h=oS0000003Pgn<000000080
h=oS00D000000>3Oh`3Pgn<0h=oS0000000B0>3Oh`0509fMX@1aKf@0h=oS
0?ooo`3akn80103Pgn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00<0
00000>3Oh`0000000`3Pgn<5000000030>3Oh`000000000000<00000403P
gn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00`0h=oS00<000000>3Oh`000000
0`3Pgn<00`000000h=oS0>3Oh`0G0>3Oh`0709fMX@1aKf@0h=oS07nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0
lNoR00H0h=oS00<000000>3Oh`3Pgn<00`3Pgn<010000000h=oS00000000
00020>3Oh`030000003Pgn<0000000<0h=oS00<000000>3Oh`3Pgn<04P3P
gn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00L0h=oS00D000000>3Oh`3Pgn<0
h=oS000000020>3Oh`030000003Pgn<000000080h=oS00<000000>3Oh`00
00000`3Pgn<00`000000h=oS0>3Oh`0@0>3Oh`0509fMX@1aKf@0h=oS0?oo
o`3akn80103Pgn<010000000h=oS0>3Oh`3Pgn<200000080h=oS00@00000
0>3Oh`00000000000P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`00
00000`3Pgn<00`000000h=oS0>3Oh`0>0>3Oh`0509fMX@1aKf@0h=oS0?oo
o`3akn80303Pgn<00`000000h=oS000000020>3Oh`8000006@3Pgn<01`2M
WJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP1oWKT0oooo0?7_hP060>3Oh`030000003Pgn<0h=oS00<0h=oS
00@000000>3Oh`000000h=oS0P0000030>3Oh`<000005@3Pgn<01@2MWJ40
LFmT0>3Oh`3oool0lNoR00L0h=oS00D000000>3Oh`3Pgn<0h=oS00000003
0>3Oh`050000003Pgn<0h=oS0>3Oh`0000000P3Pgn<3000001<0h=oS00D0
WIfQ075_I03Pgn<0oooo0?7_hP040>3Oh`060000003Pgn<0h=oS0>3Oh`00
0000h=oS0P0000020>3Oh`030000003Pgn<000000080h=oS0`0000030>3O
h`<000004@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00`0h=oS00<00000
0>3Oh`3Pgn<00P0000000`3Pgn<000000>3Oh`0H0>3Oh`0709fMX@1aKf@0
h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
07nM^@3oool0lNoR00L0h=oS00D000000>3Oh`3Pgn<0h=oS0000000Q0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn801`3Pgn<00`000000h=oS0>3Oh`0R
0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80103Pgn<01@000000h=oS0>3O
h`3Pgn<0000002@0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0<0>3Oh`03
0000003Pgn<0h=oS00<0h=oS00<000000>3Oh`3Pgn<05`3Pgn<01`2MWJ40
LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk
06IVOP1oWKT0oooo0?7_hP080>3Oh`<000008P3Pgn<01@2MWJ40LFmT0>3O
h`3oool0lNoR00D0h=oS1@00000R0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3a
kn800P3Pgn<5000000030>3Oh`000000h=oS02<0h=oS00D0WIfQ075_I03P
gn<0oooo0?7_hP0<0>3Oh`030000003Pgn<0h=oS00<0h=oS00<000000>3O
h`3Pgn<05`3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0]0>3Oh`0509fM
X@1aKf@0h=oS0?ooo`3akn80;03Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR
02d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0/0>3Oh`0709fMX@1aKf@0
h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn
07nM^@3oool0lNoR02d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0/0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn80;@3Pgn<01@2MWJ40LFmT0>3Oh`3o
ool0lNoR02`0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040
IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80;@3Pgn<01@2M
WJ40LFmT0>3Oh`3oool0lNoR02`0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_
hP0]0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80;03Pgn<01`2MWJ40LFmT
0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IV
OP1oWKT0oooo0?7_hP0]0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80;03P
gn<01@2MWJ40LFmT0>3Oh`3oool0lNoR02d0h=oS00D0WIfQ075_I03Pgn<0
oooo0?7_hP0/0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@3oool^0?7_hP0409fMX@1a
Kf@0h=oS0?ooobd0lNoR00@0WIfQ075_I03Pgn<0oooo;P3akn80102MWJ40
LFmT0>3Oh`3oool]0?7_hP0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0`0?ooo`03075_I03P
gn<0oooo02h0oooo00<0LFmT0>3Oh`3oool0;`3oool00`1aKf@0h=oS0?oo
o`0^0?ooo`06075_I03Pgn<0Oifi06IVOP2XZK/0nocm0@1VIWh0000406IV
OP3ko?d0Z:Vk06IVO/P0Oifi00<0IVIn0:RY^`3ko?d00@1VIWh0000306IV
OP3gmoT0V9RW0<X0MgNB0@2HV:L10?Ogn@40IVIn00000`1VIWh0moOi0;bm
c@3;0;bmc@40moOi0@1VIWh0000306IVOP3gmoT0i>?S0</0i>?S0@3gmoT1
06IVOP0000<0IVIn0?3am03oool0Q03oool00`3Thn<0W:Bi06]eS`0306]e
S`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>CS
h`2LY;T406]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0W:Bi0>CSh`3o
ool0oooo0>cZjP2LY;T40:HiA0040:LjA02V>D@0YcY40:LjA0T0YSU400<0
W:Bi0>cZjP3oool00`3oool10?3am040IVIn00005P1VIWh0h^7R0?_lo03k
no`0nocm0?cko@3knod0nocm0?_lo03lo?d0o?cl0?cko@3lo?`0o?_l0?cl
o03ko?`0o?cl0?_lo@3lno`0o?cm0?_ko@3ko?`20?clo0040?clo@3lo?`0
no_m0?cloC00o?_l<@3ko?`:0?_lo@0309bT^@1[MHl0QHV`0100QHV`00H0
JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9/00606]eS`2LY;T0nocl0?_k
o02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_lo03lo?`0o?_m0?_lo@3RhN80
0@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80m_Oi00/0m_Oh0?Ogn@3gmoP0
m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi0?Kgn@020?Ogn@040?Ofn03f
moP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3gmoT0;`3gmoTa0?Kgn@X0moOi
00<0JgF?08F9/02LW[h0402LW[h01P25RK00JgF?0?Ogn@3gmoT0JgF?08F9
/140W9jn00P0QHV`06]eS`3fmoP0moOh0:HiA02Z?5D0`U9K0<IDFPd0aUEL
00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0moOh0?Ogn@3Ph>400@1VIWh0
000606IVOP3NgN40lO7d0?7am03`lO@0l?;d400000001P3alO@0l?;e0?7a
m03al_@0l?;d0?7am640l?7e2P3`lO@00`1[MHl0/[G@0:NX`P0@0:NX`P06
0;:ed01[MHl0l?7d0?3am01[MHl0/[G@4@2WZ<801@2b]M00JgF?0?3am@3a
l_@0YSU40080`U9K00<0beAI0<eIGP3=FEh02`3=FEh0103;E5T0`U9K0<9B
F`2V>D@20?3am0030?7am03`l_@0g]gQ0040IVIn00001`1VIWh0g=_P0>[[
l03Zjo00j^c`0>W[k`0000000P3WinL20=kNgP80inOW00<0ikf40>OWi`3W
inL00`3WinL20>o_k`040000003Zjo00j^_`0>[[k`80j^_`00<0j^__0>[[
l03Zjo00;P3Zjo0a0>[/l0X0j^__00@0JgF?0;Jid@2][/H0[Jk6203oool0
0`2][/H0[:k60:f^aP030:f^aP030:b^aP2f^M40JgF?0080j^__00@0JgF?
0;Jid@2][/H0[Jk6303oool20:f^aP030:b^aP2f^M40JgF?0080j^_`00D0
YSU40<eIGP3;E5T0cEIK0<iIG`0;0=1JG`070<iIG`3=EU/0beAI0<eIGP2V
>D@0j^__0>[[l0020>[[k`40g=_P0@1VIWh0000406IVOP3IfMl0hnGZ0>?T
jP80hnG[00D0000008b<S03Ng]h0inOW0=kNgP020>OWi`030<IS003WinL0
inOW0080inOW00L0knoW0>o_k`3_knl000000>?TjP3Si>/0hnGZ0080hnCZ
00<0hnC[0>?Uj`3SiN/0;P3SiN/a0>?TjPX0hnGZ00D0JgF?0;bne02b//X0
/[;:0?ooo`0606i]S`0302DU=P2b//X0/[;:00D0/[;:00H0_;kD06]eS`3S
iNX0hnGZ06]eS`2l_]@20;:bbP030?ooo`0U9CH09BDf00T09BDf0`2b//X0
1@2l_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN00@0d5]P0=ALG`3oool0oooo
1`3DG5l20?ooo`0:0=ALG`3@Ff00cEUN0<eIGP2V>D@0hnCZ0>?UjP3Si>X0
hnG[0=WIg`40IVIn00000`1VIWh0emSN0=cNiP030=cNiP050000003WinL0
inOW0>OWi`3We/h00P3WinL01@3>N`00ki@@0>OWi`3Wg/H0kh`@00<0kno_
00L000000=cNiP3Lg^D0g=kU0=cNiP3Lg^D0g=kV06/0g=kU00D0JgF?0;o1
eP2h^Lh0^;W>0?ooo`0606i]S`0302DU=P2h^Lh0^;W>00D0^;W>00H0_l7F
06]eS`3Lg^D0g=kU06]eS`2o`MH20;RicP030?ooo`0U9CH0^;W>00L0^;W>
00<0oooo02DU=P2h^Lh00P2h^Lh02@2o`MH0JgF?0=cNiP3Lg^D0YSU40<eI
GP3AFUh0e5eQ05<U80030?ooo`D0eUmS0`3oool01@1C9B00e5eQ0=5JGP3=
FEh0YSU40080g=kU00<0g=kV0=cNi@3Gf=h00@1VIWh0000406IVOP3Ee]d0
eMSP0=KHh@80eMSP00T0000008b<S03WinL0inOW0>NeQ03FFP00eX@00?o>
003>H`000P3NJ`001@3_]H`0kno_0>o_k`3_knl000000080eMSQ00@0eMOP
0=KHh03Ff>40e]OQ<03Fen0a0=KHh0X0eMSQ00D0JgF?0<?5f@2l_M40_;gA
0?ooo`0702DU=PL0_;gA00H0`lGI06]eS`3Ef>40eMSQ06]eS`33aMT20;bm
d@030?ooo`0U9CH0_;gA00L0_;gA00<0oooo02DU=P2l_M400P2l_M401@33
aMT0JgF?0=KGh03Een40YSU40080eEeP00<0f61Q0=UQHP167QX00`3oool3
0=UQHP<0oooo00<0AQhJ0=UQHP3HH6400P3EGF001P2V>D@0e]SP0=GHh@3E
en00eMSQ0=GFg@40IVIn00001`1VIWh0d]CM0<oBg03@d]`0d=;M0=3Bg000
00000`3WinL0303Wg/h0aTX00?O>003_[@00kkD00<i[0036FP00aV/00=j<
BP3WY@00knO>000000<0d=;L00<0cm;L0=3Bg03?d]`0<03@d]`a0<oBg@X0
d=;L00<0JgF?0<S9f`33a=H04033a=H01P38bM/0JgF?0=3Bg03@d]`0JgF?
0<S9f`80`lCF00<0oooo02DU=P33a=H01`33a=H00`3oool09BDf0<?4eP02
0<?4eP070<S9f`1[MHl0cm;L0<oBg02V>D@0eemO0=UQHP030=aUI@0504HN
6P3oool0oooo0?ooo`3LIFD00`3oool020167QX0g6EU0=aUI@3LIFD0fF5R
0=MOG`2V>D@0d=;M0P3@d]`10<oBg040d]CM0@1VIWh0000L06IVOP3@d]/0
blgH0<[=f@3;c]P0b/gH0000003WaZd0ilJ<0?O>603__@00mlH00>n]003W
[@00ijD00=J<003>J`00ilH00?oF003_knL0kno_0000003;cMP0blgI0<[=
f@3;c]P0b/gH0<_=f300blgI<@3;c]T:0<_=f00306]eS`3;c=h0b<[I00P0
b<[I00<0b<WI0<S:f@38b]T00`38b]T01038bMT0b<[I0<_<gP1[MHl20<_=
f00606]eS`3;c=h0b<[I0<S:f@3oool09BDf1@38b]T04@38bMT0b<[I0<S:
f@3oool09BDf0<S:f@38bMT0b<[I0<_<gP1[MHl0blkH0<[=f02V>D@0eemO
0=]TI03PIfD0h6IU0080gVMW00<0AQhJ0?ooo`3oool00`3oool02P167QX0
gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0YSU40<[>f03:c]T20<_=f@40d=;K
0@1VIWh0000306IVOP3?cmX0aLSD00<0aLSD00H000000<K6aP3Wg]H0cW/0
0>N]003_]@020>NU00030=JD003>L`00eY@00080mlH00P3gmoL010000000
aLSD0<G7e035am@30<G7eC00a<OE<@34b=@:0<C7e00306]eS`3@dN00bl_L
0100bl_L00H0d=7P06]eS`34am@0a<OD06]eS`3@dN020<_;g0030?ooo`0U
9CH0bl_L00L0bl_L00<0oooo02DU=P3;bm`00P3;bm`01`3@dN00JgF?0<G7
e034am@0YSU40=]TI03OIF@01@3PJVP01@167QX0oooo0?ooo`3oool0AQhJ
00D0h6YX00@0gfET0=]TI02V>D@0a<SE0P34b=@10<G7e@40cloJ0@1VIWh0
000406IVOP3<c]X0`/CB0<74d@80`LCB00H000000>OWi`3WinL0inOW0=J4
003_]@020>NU00080=J4003>J`00ijd00?Ne003g_@00kno_0?Ogm`000003
0<74dP030<;4d@31a=80`LCB0300`LCA<@31a=8:0<;4dP0306]eS`3Cdn80
cm3M0100cm3M00H0dm?R06]eS`32a=80`/CB06]eS`3Cdn820<o@g@030?oo
o`0U9CH0cm3M00L0cm3M00<0oooo02DU=P3?d=d00P3?d=d01`3Cdn80JgF?
0<;4dP31a=40YSU40=]TI03QJFD01@3PK6T50?ooo`D0h6aY00P0hFUU0=]T
I02V>D@0`LCB0<;4d@31a=40`LCB0<c>fP40IVIn0000101VIWh0b/cH0;k0
c`2m`<l20;k0cP050000002LW9`0inOW0>ONeP3FS0000P3NU000103FN`00
aV<00;e2003_Y@020?N]00080?Ne003ocTX000000;k0cP2n`<l0_/3>0;k0
c`2m`<ha0;k0cS40_L3>2P2n`<h00`1[MHl0e]KT0=?Ch00@0=?Ch0060=KF
i01[MHl0_/3>0;k0cP1[MHl0e]KT0P3Cdn000`3oool09BDf0?ooo`080?oo
o`0;02DU=P3Cdn00dm?P0=?Ch03Fe^@0JgF?0;k0c`2n`<h0YSU40>1VI@3Q
JVX0103SK6`30?ooo`0404HN6P3oool0oooo0?ooo`@0hfa/00@0hFYZ0>1V
I@2V>D@0_L3?0P2n`<l10;k0cP40b/cH0@1VIWh0000706IVOP39b]P0][S8
0;Vlb`2j_</0^[c<000000020>o_k`0C0=JL003FS000gY@00=J4003_Y@00
gX`00;eJ003FL`00ki`00?O_i`3gmoL0oooo0000002i_<`0^[_<0;Vlb`2j
_</0^Kc<0;Vlb`0`0;Vlc340^[c<2P2j_</00`1[MHl0f=SU0=?Ch@0@0=?C
h@060=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU0P3Cdn400`3oool0KVf?06i]
S`0806i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0JgF?0;Zlb`2j_<`0YSU4
0>1YJ03QKF`0i75]0>AaK`3TL6h30?ooo`0304HN6P3TL6h0AQhJ00<0oooo
0P3TL6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<0;Zkc02i_</0][S80<W:f001
06IVOP0000T0IVIn0<O9e`2d]/L0][S80;Jhb@2f^LT0000008B4Q03Wimh0
0P3_knl01`36J`00mlH00>ne003_W000gX`00<i[003WW0000`3gmoL01@00
0000][W90;Nhb@2f^LT0]kW90080][S9<02g^<Ta0;Jhb@X0]kS900@0JgF?
0=KFi03Hf>D0f=SV0`3Hf>D50=SHiP<0f=SU0P3Hf>H20=SHi@090=KFi01[
MHl0]kS90;Nhb@1[MHl0e]KT0=SHi@3Hf>H0oooo00X0KVf?00d09BDf0=SH
iP3Hf>D0f=SU0=KFi01[MHl0]kS90;Nib@2V>D@0i6i]0>AdK`3WLFl0i7A_
00<0oooo00D0AQhJ0>AdK`3TM6l0i7A_04HN6P030?ooo`0:0>AdK`3WLFl0
i7A_0>A^K@2V>D@0][W90;Jhb@2f^LT0];K70<O9e`40IVIn00000`1VIWh0
a/SG0;Bfa`030;Bfa`030000003_knl0kno_0080kno_00/0ijd00?O6203W
Y@00ii@00>N<003_imH0gY@i0>oF]@3omoL0oooo0000001a0;Bfa`0506]e
S`3EeN<0g=_W0=cKi`3MfnL03P3LfnL01P3EeN<0JgF?0;Bfa`2d]/L0JgF?
0=GEh`80g=_W00<0gM_W02DU=P0U9CH02@0U9CH30=cKi`090=GEh`1[MHl0
];K70;Bfa`2V>D@0ig=_0>MeLP3ZMW<0jWQf0080oooo00<0AQhJ0>UnN03Y
OWP00`3YOWP020167QX0oooo0?ooo`3ZN7H0jWIc0>MeLP3WLfl0YSU4102d
]/L10<K8e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`060000002<S8`0
kno_0>o_k`3WcW/0kno_0P3gmoL0203WU000mnO>0?Ogm`3gmoL0knOF0?Og
m`3oool00000L@2d]/L00`1[MHl0eMCS0>3OjP0@0>3OjP060=GDh`1[MHl0
];K70;Bfa`1[MHl0eMCS4@3PgnX02@3Ee><0JgF?0;Bfa`2d]/L0YSU40>Yi
L`3YO7P0kh5j0?:9P@0204HN6P070>^HR`3ZVh`0kIN:0>^HR`3ZVh`0kIN:
0>^HR`0204HN6P050?:9P@3_PGX0jGah0>YiL`2V>D@0102d]/L10<K8e`40
IVIn00000`1VIWh0a/SG0;6cb0030;6cb0060000003_knl0kno_0>o_k`3g
mnl0kno_0P3gmoL00`3gilH0moOg0?ooo`030?Ogm`030?ooo`000000/K?8
0700/K?800<0JgF?0>g[l`3Yj?40403Yj?401P3]jo<0JgF?0;6cb02a/lP0
JgF?0>g[la40jNSa01T0kN_c06]eS`2a/lP0/K?80:HiA03aP7D0l8Al0?F<
Q03gWHh0lZ^F0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL0?6bV`3]]9/0k;FL
0?:[UP3gWHh0mHb40?24O03aP7D0YSU400@0/K?80@36b=L106IVOP0000<0
IVIn0<K8e`2h]ll00`2_[/L01@000000[Jf]0?Ogk`3gmoL0kno_00H0moOg
0P3omoL20?ooo`030000002_[/L0[jk706l0[jk700<0JgF?0=;Ah`3blOL0
403blOL01P3BdN<0JgF?0:n^a`2_[/L0JgF?0=;Aha40l_7g00H0d]7S06]e
S`2_[/L0[jk70:HiA03dRWd20?F@Q@d0l[RN0P3eT8D00`3dRWd0YSU40:n^
a`020:n^a`40^;O?0@36b=L106IVOP0000<0IVIn0<31d@37am@0Q02/Zl@0
1024S:80JgF?0<c;g@3kno`=0?ooo`040?_ko03<bmd0JgF?08B<XP80[:_4
00@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:820:b[
a007096HZP2V>D@0oin=0?joY03jg;L0n^^g0?[Y]P020?WY]P040?[Y]P3i
jKH0nNVf0?[Y]P80nNVf00H0n^^g0?[L]`3n_j@0oin=0:HiA02AV:X30:b[
a040alOD0@30`M4106IVOP0000@0IVIn0<31d@3Bd]l0]KC9Q02TXkh00`24
S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0Y:>n0080Y:>n00<0Q8bR06]e
S`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<XP2V>D@0YSU4
00l0YSU400L0Q8bR0:BS_P2TXkh0Y:>n0;Fdb@3Bd]l0`<7A0040IVIn0000
1P1VIWh0Z:No0>KVk@3Bd^00_;c?0;6`a<@0Z:No00D0/K340;blc`3Bd^00
i^K]0:RW_`0106IVOP0000L0F5MX08N7V`3Gf>80o?cl0>CSj03@d>00b/[J
0<80_;c?00H0b/[J0=3@h03ThnP0o?cl0=OHhP27Qi/105QGJ00000P0F5MX
06IVOP2EU:/0emSR0?clo03blO<0k>_^0>7Rjl00emSR00L0hN;[0>c[kP3b
lO<0o?cl0=OHhP2EU:/0IVIn0040F5MX000205QGJ00306IVOP2EU:/0dM7N
0080o?cl`P3oool20?clo0030=7AgP2EU:/0IVIn0080F5MX000305QGJ080
IVIn00<0R8NM09FDZ`2XYkl0`@2XYkl0102EU:/0R8NM06IVOP1VIWh305QG
J0001@1HEfS606IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[19]:=",
  Evaluatable->False,
  ImageSize->{208, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Table"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[19]=",
  CellTags->"Table"]
}, Open  ]],

Cell[BoxData[
    \(ref\ @\ 
      InvokeMethod[{"\<myTableModel\>", \ "\<insertRow\>"}, \ 
        2, \ {"\<i\>", "\<j\>", "\<k\>"}]\)], "Input",
  CellLabel->"In[20]:=",
  CellTags->"Table"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[21]:=",
  CellTags->"Table"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003@0000T2000`400?l0
0000o`00003od01VIWh0000306IVOP3ko?d0nocm0<`0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0</0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
bP1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO/P0Oifi
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS
00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0<H0P82000@0Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?oo
o`0^0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3oool0;P3o
ool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0Oifi0340oooo00@0P8200?ooo`3oool00000;@3oool00`20P800
oooo0?ooo`0_0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?oo
o`050820P03oool0oooo0?ooo`000000;03oool00`20P800oooo0?ooo`0_
0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000<0oooo
00<000000?ooo`3oool0:@3oool01@20P800oooo0?ooo`3oool0000002`0
oooo00<0P8200?ooo`0000001000000[0?ooo`030820P03oool0oooo00<0
0000:`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`000000;03oool01@20
P800oooo0?ooo`3oool0000002`0oooo00@0P8200?ooo`3oool00000;P3o
ool00`20P800oooo000000030?ooo`030000003oool0oooo02P0oooo00D0
P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
07nM^@030?ooo`030000003oool0oooo02/0oooo00H0P8200?ooo`3oool0
00000?ooo`00000[0?ooo`050820P03oool0oooo0?ooo`000000;@3oool0
0`20P800oooo0?ooo`030?ooo`030000003oool0oooo02P0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@030?ooo`030000003oool0oooo02/0oooo00H0P8200?ooo`3oool00000
0?ooo`00000[0?ooo`050820P03oool0oooo0?ooo`000000;@3oool00`20
P800oooo0?ooo`030?ooo`030000003oool0oooo02P0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@02
0?ooo`030000003oool0000002`0oooo00<0P8200?ooo`0000000`3oool0
0`000000oooo0?ooo`0X0?ooo`030820P03oool0oooo0080oooo00<00000
0?ooo`3oool0:P3oool00`20P800oooo00000003000002/0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM
^@3oool0000000<0oooo00<000000?ooo`3oool0:@3oool00`20P800oooo
000000030?ooo`030000003oool0oooo02P0oooo00<0P8200?ooo`000000
1000000[0?ooo`030820P03oool0000002h0oooo00D0P82007nM^@1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`03
0820P03oool0oooo02h0oooo00<0P8200?ooo`3oool0;`3oool01020P800
oooo0?ooo`00000]0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?ooo`0^
0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3oool01000000Z
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?ooo`0^0?ooo`030820P03o
ool0oooo02l0oooo00<0P8200?ooo`3oool0;P3oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0340oooo
00<0P8200?ooo`3oool0;P3oool00`20P800oooo0?ooo`0_0?ooo`030820
P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`030820P03oool0oooo02h0
oooo00<0P8200?ooo`3oool0;`3oool00`20P800oooo0?ooo`0^0?ooo`05
0820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP1oWKT0<@3oool00`20P800oooo0?ooo`0^0?ooo`030820P03oool0oooo
02l0oooo00<0P8200?ooo`3oool0;P3oool01@20P800Oifi06IVOP2XZK/0
nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0P82000@0Oifi
06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3o
ool00`20P800oooo0?ooo`0^0?ooo`030820P03oool0oooo02l0oooo00<0
P8200?ooo`3oool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi00<0oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01H0oooo
00D0P8200?ooo`3oool0oooo000000080?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool05@3oool01@20P800oooo0?ooo`3oool00000
00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0F0?oo
o`030820P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`030000003oool0
oooo00L0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0E
0?ooo`040820P03oool0oooo000000T0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`0D0?ooo`040820P03oool0oooo000000T0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0E0?ooo`030820
P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`030000003oool0oooo00<0
oooo00D000000?ooo`3oool0oooo000000060?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool05@3oool01020P800oooo0?ooo`000005
0?ooo`050000003oool0oooo0?ooo`000000103oool5000000<0oooo00<0
00000?ooo`3oool0503oool01020P800oooo0?ooo`0000050?ooo`050000
003oool0oooo0?ooo`0000001@3oool3000000@0oooo00<000000?ooo`3o
ool05@3oool00`20P800oooo0?ooo`020?ooo`030000003oool0oooo02T0
oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@020?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0203oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
01D0oooo00@0P8200?ooo`3oool000001@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0503oool0
1020P800oooo0?ooo`0000050?ooo`030000003oool0oooo00H0oooo00D0
00000?ooo`3oool0oooo000000030?ooo`030000003oool0oooo01D0oooo
00<0P8200?ooo`3oool00P3oool00`000000oooo0?ooo`0Y0?ooo`050820
P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT00P3oool00`000000oooo0?ooo`05000000T0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0E0?ooo`040820P03oool0oooo0000
0080oooo1@0000090?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0503oool01020P800oooo0?ooo`0000020?ooo`D000002`3oool0
1@000000oooo0?ooo`3oool0000001L0oooo00<0P8200?ooo`0000001000
000Z0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP1oWKT0oooo000000030?ooo`040000003oool0oooo0000
00X0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0D0?oo
o`030820P03oool0000000<0oooo00@000000?ooo`3oool000002`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo00<0P820
0?ooo`0000000`3oool010000000oooo0?ooo`00000<0?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool0503oool00`20P800oooo0000
00020?ooo`030000003oool0oooo02T0oooo00D0P82007nM^@1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`070000
003oool0oooo0?ooo`000000oooo0000000:0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool05@3oool01020P800oooo0?ooo`000003
0?ooo`030000003oool0000000`0oooo00D000000?ooo`3oool0oooo0000
000F0?ooo`040820P03oool0oooo000000<0oooo00<000000?ooo`000000
2P3oool2000000@0oooo00<000000?ooo`3oool05@3oool01P20P800oooo
0?ooo`000000oooo000002/0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`070000003oool0
oooo0?ooo`000000oooo000000080?ooo`030000003oool0000000D0oooo
00<000000?ooo`3oool05@3oool01020P800oooo0?ooo`0000030?ooo`03
0000003oool0000000`0oooo00D000000?ooo`3oool0oooo0000000F0?oo
o`040820P03oool0oooo000000<0oooo00<000000?ooo`000000303oool0
1@000000oooo0?ooo`3oool0000001L0oooo00H0P8200?ooo`3oool00000
0?ooo`00000[0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`000000oooo0?ooo`020?oo
o`8000002@3oool2000000D0oooo00<000000?ooo`3oool05@3oool01020
P800oooo0?ooo`0000040?ooo`800000203oool01@000000oooo0?ooo`3o
ool0000000<0oooo00<000000?ooo`3oool0503oool01020P800oooo0?oo
o`0000040?ooo`800000203oool01@000000oooo0?ooo`3oool0000000<0
oooo00<000000?ooo`3oool05@3oool01020P800oooo0?ooo`3oool20000
02/0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_l
o@2XZK/0IVIn07nM^@030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo01H0oooo00D0P8200?ooo`3oool0oooo000000040?ooo`030000003o
ool0oooo00L0oooo0`0000030?ooo`030000003oool0oooo01D0oooo00D0
P8200?ooo`3oool0oooo000000040?ooo`030000003oool0oooo00L0oooo
0`0000030?ooo`030000003oool0oooo01H0oooo00<0P8200?ooo`3oool0
0P3oool00`000000oooo0?ooo`0Y0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800
oooo0?ooo`0^0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3o
ool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0340oooo00<0P8200?ooo`3oool0;P3oool00`20
P800oooo0?ooo`0_0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a
0?ooo`030820P03oool0oooo02h0oooo00<0P8200?ooo`3oool0;`3oool0
0`20P800oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?oo
o`0^0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3oool0;P3o
ool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0Oifi0<H0P82000@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?ooo`0^0?ooo`03
0820P03oool0oooo02l0oooo00<0P8200?ooo`3oool0;P3oool01@20P800
Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi
0340oooo00<0P8200000003oool0;P3oool00`20P800oooo0?ooo`0_0?oo
o`030820P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@01
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`030820P03oool0
000002h0oooo00<0P8200?ooo`3oool0;`3oool00`20P800oooo0?ooo`0^
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP1oWKT0oooo0000000_0?ooo`030820P03oool0000002h0oooo
00<0P8200?ooo`0000000P3oool00`000000oooo0?ooo`0Z0?ooo`030820
P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000002l0oooo00<0P8200?oo
o`000000;P3oool01@20P800oooo0000003oool0000002d0oooo00<0P820
0?ooo`3oool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`000000;`3oool00`20P800oooo
0000000^0?ooo`050820P03oool000000?ooo`000000;@3oool00`20P800
oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00007
06IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0000000_0?ooo`030820P03oool0
000002h0oooo00@0P8200?ooo`0000000000;P3oool00`20P800oooo0?oo
o`0^0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP1oWKT0oooo0000000_0?ooo`030820P03oool0000002h0
oooo00D0P8200?ooo`000000oooo0000000]0?ooo`030820P03oool0oooo
02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn07nM^@3oool0000002l0oooo00<0P8200?ooo`000000;P3o
ool00`20P800oooo000000020?ooo`030000003oool0oooo02X0oooo00<0
P8200?ooo`3oool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn
00001@1VIWh0nocm0:RY^`1VIWh0Oifi0340oooo00<0P8200?ooo`3oool0
;P3oool00`20P800oooo0000000_0?ooo`030820P03oool0oooo02h0oooo
00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0
IVIn07nM^@3oool0000002l0oooo00<0P8200?ooo`000000;P3oool00`20
P800oooo0000000_0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a
0?ooo`030820P03oool0oooo02h0oooo00<0P8200?ooo`3oool0;`3oool0
0`20P800oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?oo
o`0^0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3oool0;P3o
ool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0Oifi0340oooo00<0P8200?ooo`3oool0;P3oool00`20P800oooo
0?ooo`0_0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`03
0820P03oool0oooo02h0oooo00<0P8200?ooo`3oool0;`3oool00`20P800
oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh00005
06IVOP3ko?d0Z:Vk06IVOP1oWKT0aP20P800101oWKT0IVIn0:RY^`3ko?d1
06IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`030820P03oool0
oooo02h0oooo00<0P8200?ooo`3oool0;`3oool00`20P800oooo0?ooo`0^
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT00`3oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool05P3oool01@20P800oooo0?oo
o`3oool0000000P0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0E0?ooo`050820P03oool0oooo0?ooo`000000203oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo01H0oooo00<0P8200?ooo`3o
ool0;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0:0?ooo`030000003oool0oooo01D0oooo00@0P8200?oo
o`3oool000002@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo01@0oooo00@0P8200?ooo`3oool000002@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo01D0oooo00<0P8200?ooo`3oool0;P3o
ool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0Oifi0080oooo00@000000?ooo`3oool0oooo0`0000030?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0E0?ooo`040820P03oool0oooo000000<0oooo0`0000030?oo
o`030000003oool0oooo0080oooo1@0000030?ooo`030000003oool0oooo
01@0oooo00@0P8200?ooo`3oool000000`3oool3000000<0oooo00<00000
0?ooo`3oool00`3oool3000000@0oooo00<000000?ooo`3oool05@3oool0
0`20P800oooo0?ooo`03000002/0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`040000003o
ool0oooo000000<0oooo00<000000?ooo`3oool01`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo01D0oooo00@0P8200?ooo`3oool0
00000P3oool01@000000oooo0?ooo`3oool0000000P0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`0D0?ooo`040820P03oool0oooo
00000080oooo00D000000?ooo`3oool0oooo000000070?ooo`050000003o
ool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0E0?ooo`030820
P03oool0000000<0oooo00<000000?ooo`3oool0:03oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0080
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool05@3oool01020P800
oooo0?ooo`0000060?ooo`030000003oool0oooo00L0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0D0?ooo`040820P03oool0oooo
000000H0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3o
ool0000001L0oooo00<0P8200?ooo`3oool00`3oool00`000000oooo0?oo
o`0X0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3k
o?d0Z:Vk06IVOP1oWKT0oooo000000070?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0D0?ooo`03
0820P03oool0000000L0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo00<0P8200?ooo`00
00001`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0503oool00`20P800oooo0?ooo`030?ooo`03
0000003oool0oooo02P0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?ooo`030000003oool0oooo
0080oooo0P00000:0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool05@3oool01020P800oooo0?ooo`0000040?ooo`800000303oool0
1@000000oooo0?ooo`3oool0000001H0oooo00@0P8200?ooo`3oool00000
103oool2000000X0oooo0P0000040?ooo`030000003oool0oooo01D0oooo
00@0P8200?ooo`3oool0oooo0P00000[0?ooo`050820P01oWKT0IVIn0:RY
^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT00P3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`0000001@3oool00`000000oooo0?ooo`0E0?ooo`040820P03oool0oooo
000000H0oooo00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3o
ool0000001H0oooo00@0P8200?ooo`3oool000001P3oool00`000000oooo
0?ooo`090?ooo`050000003oool0oooo0?ooo`0000005`3oool00`20P800
oooo0?ooo`030?ooo`030000003oool0oooo02P0oooo00D0P82007nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@020?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`3oool01P3oool2
000000D0oooo00<000000?ooo`3oool05@3oool01020P800oooo0?ooo`00
00020?ooo`050000003oool0oooo0?ooo`0000001`3oool01@000000oooo
0?ooo`3oool0000000<0oooo00<000000?ooo`3oool0503oool01020P800
oooo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`0000001`3oool0
1@000000oooo0?ooo`3oool0000000<0oooo00<000000?ooo`3oool05@3o
ool00`20P800oooo000000030?ooo`030000003oool0oooo02P0oooo00D0
P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
07nM^@030?ooo`030000003oool0oooo00<000002P3oool00`000000oooo
0?ooo`020?ooo`030000003oool0oooo01H0oooo00D0P8200?ooo`3oool0
oooo000000020?ooo`<000002@3oool3000000<0oooo00<000000?ooo`3o
ool05@3oool01@20P800oooo0?ooo`3oool000000080oooo0`0000090?oo
o`<000000`3oool00`000000oooo0?ooo`0F0?ooo`030820P03oool0oooo
00<00000:`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0340oooo00<0P8200?ooo`3oool0;P3oool0
0`20P800oooo0?ooo`0_0?ooo`030820P03oool0oooo02h0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@0a0?ooo`030820P03oool0oooo02h0oooo00<0P8200?ooo`3oool0;`3o
ool00`20P800oooo0?ooo`0^0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo
0?ooo`0^0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3oool0
;P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm
0:RY^`1VIWh0Oifi0340oooo00<0P8200?ooo`3oool0;P3oool00`20P800
oooo0?ooo`0_0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360820
P00407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0
Oifi0340/[Bo00<0P8200?ooo`3oool0;P3oool00`20P800oooo0?ooo`0_
0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l20?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`0E0?ooo`030;:d_`20P800oooo0080oooo00<000000?ooo`3oool0
1P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo01D0oooo
00D0P8200?ooo`3oool0oooo000000080?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool05P3oool00`20P800oooo0?ooo`0^0?ooo`05
0820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IV
OP1oWKT0/[Bo0?ooo`0000090?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool0503oool01@2b];l0P8200?ooo`3oool0000000T0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0D0?ooo`040820
P03oool0oooo000000T0oooo00<000000?ooo`3oool02P3oool00`000000
oooo0?ooo`0E0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l0
oooo00000080oooo1@0000020?ooo`030000003oool0oooo00@0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0D0?ooo`050;:d_`20
P800oooo0?ooo`0000000P3oool500000080oooo00<000000?ooo`3oool0
0P3oool5000000<0oooo00<000000?ooo`3oool0503oool01020P800oooo
0?ooo`0000020?ooo`D000000P3oool00`000000oooo0?ooo`030?ooo`<0
0000103oool00`000000oooo0?ooo`0E0?ooo`030820P03oool0000000@0
0000:P3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn0000201VIWh0
nocm0:RY^`1VIWh0Oifi0;:d_`3oool000000`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0503o
ool01@2b];l0P8200?ooo`3oool0000000<0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01@0oooo
00@0P8200?ooo`3oool000000`3oool00`000000oooo0?ooo`080?ooo`05
0000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0E0?oo
o`040820P03oool0oooo000002d0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l0oooo000000@0
oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo01@0oooo00D0/[Bo0820P03oool0oooo000000040?oo
o`030000003oool0oooo00T0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0D0?ooo`040820P03oool0oooo000000@0oooo00<00000
0?ooo`3oool02`3oool01@000000oooo0?ooo`3oool0000001L0oooo00D0
P8200?ooo`3oool0oooo0000000/0?ooo`050820P01oWKT0IVIn0:RY^`3k
o?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0/[Bo000000060?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0C0?ooo`040;:d_`20P800oooo000000H0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo01<0oooo00<0P8200?ooo`0000001P3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0503oool0
0`20P800oooo0?ooo`020?ooo`030000003oool0oooo02T0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn07nM
^@2b];l0oooo000000H0oooo00<000000?ooo`3oool01`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo01@0oooo00D0/[Bo0820P03o
ool0oooo000000060?ooo`030000003oool0oooo00T0oooo00D000000?oo
o`3oool0oooo0000000F0?ooo`040820P03oool0oooo000000H0oooo00<0
00000?ooo`3oool01`3oool2000000@0oooo00<000000?ooo`3oool05@3o
ool00`20P800oooo0?ooo`030?ooo`030000003oool0oooo02P0oooo00D0
P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000P0IVIn0?_lo@2XZK/0IVIn
07nM^@2b];l0oooo000000H0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo000000050?ooo`030000003oool0oooo01@0oooo00D0/[Bo0820
P03oool0oooo000000060?ooo`030000003oool0oooo00T0oooo00D00000
0?ooo`3oool0oooo0000000F0?ooo`040820P03oool0oooo000000H0oooo
00<000000?ooo`3oool02@3oool01@000000oooo0?ooo`3oool0000001L0
oooo00<0P8200?ooo`3oool00`3oool00`000000oooo0?ooo`0X0?ooo`05
0820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000806IVOP3ko?d0Z:Vk06IV
OP1oWKT0/[Bo0?ooo`0000020?ooo`050000003oool0oooo0?ooo`000000
203oool2000000D0oooo00<000000?ooo`3oool0503oool01@2b];l0P820
0?ooo`3oool000000080oooo00D000000?ooo`3oool0oooo000000070?oo
o`050000003oool0oooo0?ooo`0000000`3oool00`000000oooo0?ooo`0D
0?ooo`040820P03oool0oooo00000080oooo00D000000?ooo`3oool0oooo
000000070?ooo`050000003oool0oooo0?ooo`0000000`3oool00`000000
oooo0?ooo`0E0?ooo`030820P03oool0000000<0oooo00<000000?ooo`3o
ool0:03oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001P1VIWh0
nocm0:RY^`1VIWh0Oifi0;:d_`80oooo00<000000?ooo`3oool00`00000:
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool05@3oool0
0`2b];l0P8200?ooo`020?ooo`030000003oool0oooo00<000002@3oool3
000000<0oooo00<000000?ooo`3oool05@3oool01@20P800oooo0?ooo`3o
ool000000080oooo0`0000090?ooo`<000000`3oool00`000000oooo0?oo
o`0F0?ooo`030820P03oool0oooo00<00000:`3oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001P1VIWh0nocm0:RY^`1VIWh0Oifi0;:d_bl0
oooo00<0/[Bo0820P03oool0;`3oool00`20P800oooo0?ooo`0_0?ooo`03
0820P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000H0IVIn0?_lo@2XZK/0IVIn07nM^@2b];l_0?ooo`030;:d_`20P800
oooo02l0oooo00<0P8200?ooo`3oool0;`3oool00`20P800oooo0?ooo`0^
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0
Z:Vk06IVOP1oWKT0/[Bo;`3oool00`2b];l0P8200?ooo`0_0?ooo`030820
P03oool0oooo02l0oooo00<0P8200?ooo`3oool0;P3oool01@20P800Oifi
06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0340
/[Bo00<0P8200?ooo`3oool0;P3oool00`20P800oooo0?ooo`0_0?ooo`03
0820P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a075_I0030>3Oh`1aKf@0LFmT
02h0LFmT00<0h=oS075_I01aKf@0;`1aKf@00`3Pgn<0LFmT075_I00^075_
I0050>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000606IVOP3ko?d0Z:Vk
06IVOP1oWKT0oooo;`2MWJ400`1aKf@0h=oS0?ooo`0^09fMX@03075_I03P
gn<0oooo02l0WIfQ00<0LFmT0>3Oh`3oool0;P2MWJ401P1aKf@0h=oS07nM
^@1VIWh0Z:Vk0?_lo@40IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi0?oo
o`3akn80;@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR02`0h=oS00D0WIfQ
075_I03Pgn<0oooo0?7_hP0]0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80
;03Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh00007
06IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0]0>3Oh`0509fMX@1aKf@0
h=oS0?ooo`3akn80;03Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR02d0h=oS
00D0WIfQ075_I03Pgn<0oooo0?7_hP0/0>3Oh`0709fMX@1aKf@0h=oS07nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3o
ool0lNoR02d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0/0>3Oh`0509fM
X@1aKf@0h=oS0?ooo`3akn80;@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR
02`0h=oS00L0WIfQ075_I03Pgn<0Oifi06IVOP2XZK/0nocm0040IVIn0000
1`1VIWh0nocm0:RY^`1VIWh0Oifi0?ooo`3akn80;@3Pgn<01@2MWJ40LFmT
0>3Oh`3oool0lNoR02`0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0]0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn80;03Pgn<01`2MWJ40LFmT0>3Oh`1o
WKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0
oooo0?7_hP080>3Oh`<000000`3Pgn<01@000000h=oS0>3Oh`3Pgn<00000
0080h=oS0`00000E0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn801`3Pgn<0
0`000000h=oS0>3Oh`030>3Oh`050000003Pgn<0h=oS0>3Oh`000000103P
gn<3000001<0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP040>3Oh`050000
003Pgn<0h=oS0>3Oh`0000000`3Pgn<00`000000h=oS000000040>3Oh`<0
00000`3Pgn<300000140h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0<0>3O
h`030000003Pgn<0h=oS0080000000<0h=oS0000003Pgn<0603Pgn<01`2M
WJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0
Z:Vk06IVOP1oWKT0oooo0?7_hP070>3Oh`050000003Pgn<0h=oS0>3Oh`00
00000P3Pgn<01`000000h=oS0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<0
0`000000h=oS0>3Oh`0B0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn801`3P
gn<00`000000h=oS0>3Oh`030>3Oh`050000003Pgn<0h=oS0>3Oh`000000
0`3Pgn<01@000000h=oS0>3Oh`3Pgn<000000180h=oS00D0WIfQ075_I03P
gn<0oooo0?7_hP040>3Oh`050000003Pgn<0h=oS0>3Oh`0000000`3Pgn<0
0`000000h=oS000000030>3Oh`070000003Pgn<0h=oS0>3Oh`000000h=oS
000000030>3Oh`030000003Pgn<0h=oS00h0h=oS00D0WIfQ075_I03Pgn<0
oooo0?7_hP0<0>3Oh`030000003Pgn<000000080h=oS0P00000I0>3Oh`07
09fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn07nM^@3oool0lNoR00H0h=oS00<000000>3Oh`3Pgn<00`3P
gn<00`000000h=oS000000030>3Oh`030000003Pgn<0000001P0h=oS00D0
WIfQ075_I03Pgn<0oooo0?7_hP070>3Oh`030000003Pgn<0h=oS0080h=oS
00L000000>3Oh`000000h=oS0000003Pgn<000000080h=oS00D000000>3O
h`3Pgn<0h=oS0000000B0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80103P
gn<01@000000h=oS0>3Oh`3Pgn<0000000<0h=oS00<000000>3Oh`000000
0`3Pgn<00`000000h=oS0>3Oh`030>3Oh`030000003Pgn<0h=oS0180h=oS
00D0WIfQ075_I03Pgn<0oooo0?7_hP0<0>3Oh`030000003Pgn<0000000<0
h=oS00<000000>3Oh`3Pgn<05`3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn
0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_
hP060>3Oh`030000003Pgn<0h=oS00<0h=oS00<000000>3Oh`0000000`3P
gn<00`000000h=oS00000004000001@0h=oS00D0WIfQ075_I03Pgn<0oooo
0?7_hP070>3Oh`030000003Pgn<0h=oS0080h=oS00L000000>3Oh`000000
h=oS0000003Pgn<000000080h=oS00D000000>3Oh`3Pgn<0h=oS0000000B
0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80103Pgn<01@000000h=oS0>3O
h`3Pgn<0000000<0h=oS00<000000>3Oh`0000000`3Pgn<5000000030>3O
h`000000000000<00000403Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00`0
h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`0G0>3Oh`07
09fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_l
o@2XZK/0IVIn07nM^@3oool0lNoR00H0h=oS00<000000>3Oh`3Pgn<00`3P
gn<010000000h=oS0000000000020>3Oh`030000003Pgn<0000000<0h=oS
00<000000>3Oh`3Pgn<04P3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00L0
h=oS00D000000>3Oh`3Pgn<0h=oS000000020>3Oh`030000003Pgn<00000
0080h=oS00<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`0@0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn80103Pgn<010000000h=oS0>3Oh`3P
gn<200000080h=oS00@000000>3Oh`00000000000P3Pgn<01`000000h=oS
0>3Oh`3Pgn<000000>3Oh`0000000`3Pgn<00`000000h=oS0>3Oh`0>0>3O
h`0509fMX@1aKf@0h=oS0?ooo`3akn80303Pgn<00`000000h=oS00000002
0>3Oh`8000006@3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d0
0@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP060>3Oh`03
0000003Pgn<0h=oS00<0h=oS00@000000>3Oh`000000h=oS0P0000030>3O
h`<000005@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00L0h=oS00D00000
0>3Oh`3Pgn<0h=oS000000030>3Oh`050000003Pgn<0h=oS0>3Oh`000000
0P3Pgn<3000001<0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP040>3Oh`06
0000003Pgn<0h=oS0>3Oh`000000h=oS0P0000020>3Oh`030000003Pgn<0
00000080h=oS0`0000030>3Oh`<000004@3Pgn<01@2MWJ40LFmT0>3Oh`3o
ool0lNoR00`0h=oS00<000000>3Oh`3Pgn<00P0000000`3Pgn<000000>3O
h`0H0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR00L0h=oS00D000000>3O
h`3Pgn<0h=oS0000000Q0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn801`3P
gn<00`000000h=oS0>3Oh`0R0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80
103Pgn<01@000000h=oS0>3Oh`3Pgn<0000002@0h=oS00D0WIfQ075_I03P
gn<0oooo0?7_hP0<0>3Oh`030000003Pgn<0h=oS00<0h=oS00<000000>3O
h`3Pgn<05`3Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1V
IWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP080>3Oh`<00000
8P3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR00D0h=oS1@00000R0>3Oh`05
09fMX@1aKf@0h=oS0?ooo`3akn800P3Pgn<5000000030>3Oh`000000h=oS
02<0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0<0>3Oh`030000003Pgn<0
h=oS00<0h=oS00<000000>3Oh`3Pgn<05`3Pgn<01`2MWJ40LFmT0>3Oh`1o
WKT0IVIn0:RY^`3ko?d00@1VIWh0000706IVOP3ko?d0Z:Vk06IVOP1oWKT0
oooo0?7_hP0]0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80;03Pgn<01@2M
WJ40LFmT0>3Oh`3oool0lNoR02d0h=oS00D0WIfQ075_I03Pgn<0oooo0?7_
hP0/0>3Oh`0709fMX@1aKf@0h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP00
00L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0lNoR02d0h=oS00D0WIfQ075_
I03Pgn<0oooo0?7_hP0/0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3akn80;@3P
gn<01@2MWJ40LFmT0>3Oh`3oool0lNoR02`0h=oS00L0WIfQ075_I03Pgn<0
Oifi06IVOP2XZK/0nocm0040IVIn00001`1VIWh0nocm0:RY^`1VIWh0Oifi
0?ooo`3akn80;@3Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR02`0h=oS00D0
WIfQ075_I03Pgn<0oooo0?7_hP0]0>3Oh`0509fMX@1aKf@0h=oS0?ooo`3a
kn80;03Pgn<01`2MWJ40LFmT0>3Oh`1oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000706IVOP3ko?d0Z:Vk06IVOP1oWKT0oooo0?7_hP0]0>3Oh`0509fMX@1a
Kf@0h=oS0?ooo`3akn80;03Pgn<01@2MWJ40LFmT0>3Oh`3oool0lNoR02d0
h=oS00D0WIfQ075_I03Pgn<0oooo0?7_hP0/0>3Oh`0709fMX@1aKf@0h=oS
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000H0IVIn0?_lo@2XZK/0IVIn07nM
^@3oool^0?7_hP0409fMX@1aKf@0h=oS0?ooobd0lNoR00@0WIfQ075_I03P
gn<0oooo;P3akn80102MWJ40LFmT0>3Oh`3oool]0?7_hP0709fMX@1aKf@0
h=oS07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
07nM^@0`0?ooo`03075_I03Pgn<0oooo02h0oooo00<0LFmT0>3Oh`3oool0
;`3oool00`1aKf@0h=oS0?ooo`0^0?ooo`06075_I03Pgn<0Oifi06IVOP2X
ZK/0nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO/P0Oifi00<0IVIn0:RY
^`3ko?d00@1VIWh0000306IVOP3gmoT0V9RW0<X0MgNB0@2HV:L10?Ogn@40
IVIn00000`1VIWh0moOi0;bmc@3;0;bmc@40moOi0@1VIWh0000306IVOP3g
moT0i>?S0</0i>?S0@3gmoT106IVOP0000<0IVIn0?3am03oool0Q03oool0
0`3Thn<0W:Bi06]eS`0306]eS`0406afT01[MHl0K7J@06afT0T0JgF?00H0
W:Bi0>CSh`3oool0oooo0>CSh`2LY;T406]eS`0406afT01[MHl0K7J@06af
T0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>cZjP2LY;T40:HiA0040:LjA02V
>D@0YcY40:LjA0T0YSU400<0W:Bi0>cZjP3oool00`3oool10?3am040IVIn
00005P1VIWh0h^7R0?_lo03kno`0nocm0?cko@3knod0nocm0?_lo03lo?d0
o?cl0?cko@3lo?`0o?_l0?clo03ko?`0o?cl0?_lo@3lno`0o?cm0?_ko@3k
o?`20?clo0040?clo@3lo?`0no_m0?cloC00o?_l<@3ko?`:0?_lo@0309bT
^@1[MHl0QHV`0100QHV`00H0JgF?09bT^@3ko?d0nocm09bT^@1[MHlA08F9
/00606]eS`2LY;T0nocl0?_ko02LY;T0YSU44@2Z?5D01`2V>D@0W:Bi0?_l
o03lo?`0o?_m0?_lo@3RhN800@1VIWh0000406IVOP3Ph>40m_Oi0?Ogn@80
m_Oi00/0m_Oh0?Ogn@3gmoP0m_Oh0?Kgn@3gmoP0moOi0?Ofn03fmoT0moOi
0?Kgn@020?Ogn@040?Ofn03fmoP0m_Oi0?Ogn@<0m_Oi00<0m_Oh0?Ogn@3g
moT0;`3gmoTa0?Kgn@X0moOi00<0JgF?08F9/02LW[h0402LW[h01P25RK00
JgF?0?Ogn@3gmoT0JgF?08F9/140W9jn00P0QHV`06]eS`3fmoP0moOh0:Hi
A02Z?5D0`U9K0<IDFPd0aUEL00T0aUAJ0<9BF`2Z?5D0YSU40?Ogn03gmoT0
moOh0?Ogn@3Ph>400@1VIWh0000606IVOP3NgN40lO7d0?7am03`lO@0l?;d
400000001P3alO@0l?;e0?7am03al_@0l?;d0?7am640l?7e2P3`lO@00`1[
MHl0/[G@0:NX`P0@0:NX`P060;:ed01[MHl0l?7d0?3am01[MHl0/[G@4@2W
Z<801@2b]M00JgF?0?3am@3al_@0YSU40080`U9K00<0beAI0<eIGP3=FEh0
2`3=FEh0103;E5T0`U9K0<9BF`2V>D@20?3am0030?7am03`l_@0g]gQ0040
IVIn00001`1VIWh0g=_P0>[[l03Zjo00j^c`0>W[k`0000000P3WinL20=kN
gP80inOW00<0ikf40>OWi`3WinL00`3WinL20>o_k`040000003Zjo00j^_`
0>[[k`80j^_`00<0j^__0>[[l03Zjo00;P3Zjo0a0>[/l0X0j^__00@0JgF?
0;Jid@2][/H0[Jk6203oool00`2][/H0[:k60:f^aP030:f^aP030:b^aP2f
^M40JgF?0080j^__00@0JgF?0;Jid@2][/H0[Jk6303oool20:f^aP030:b^
aP2f^M40JgF?0080j^_`00D0YSU40<eIGP3;E5T0cEIK0<iIG`0;0=1JG`07
0<iIG`3=EU/0beAI0<eIGP2V>D@0j^__0>[[l0020>[[k`40g=_P0@1VIWh0
000406IVOP3IfMl0hnGZ0>?TjP80hnG[00D0000008b<S03Ng]h0inOW0=kN
gP020>OWi`030<IS003WinL0inOW0080inOW00L0knoW0>o_k`3_knl00000
0>?TjP3Si>/0hnGZ0080hnCZ00<0hnC[0>?Uj`3SiN/0;P3SiN/a0>?TjPX0
hnGZ00D0JgF?0;bne02b//X0/[;:0?ooo`0606i]S`0302DU=P2b//X0/[;:
00D0/[;:00H0_;kD06]eS`3SiNX0hnGZ06]eS`2l_]@20;:bbP030?ooo`0U
9CH09BDf00T09BDf0`2b//X01@2l_]@0JgF?0>?Tj`3Si>/0YSU40080cEUN
00@0d5]P0=ALG`3oool0oooo1`3DG5l20?ooo`0:0=ALG`3@Ff00cEUN0<eI
GP2V>D@0hnCZ0>?UjP3Si>X0hnG[0=WIg`40IVIn00000`1VIWh0emSN0=cN
iP030=cNiP050000003WinL0inOW0>OWi`3We/h00P3WinL01@3>N`00ki@@
0>OWi`3Wg/H0kh`@00<0kno_00L000000=cNiP3Lg^D0g=kU0=cNiP3Lg^D0
g=kV06/0g=kU00D0JgF?0;o1eP2h^Lh0^;W>0?ooo`0606i]S`0302DU=P2h
^Lh0^;W>00D0^;W>00H0_l7F06]eS`3Lg^D0g=kU06]eS`2o`MH20;RicP03
0?ooo`0U9CH0^;W>00L0^;W>00<0oooo02DU=P2h^Lh00P2h^Lh02@2o`MH0
JgF?0=cNiP3Lg^D0YSU40<eIGP3AFUh0e5eQ05<U80030?ooo`D0eUmS0`3o
ool01@1C9B00e5eQ0=5JGP3=FEh0YSU40080g=kU00<0g=kV0=cNi@3Gf=h0
0@1VIWh0000406IVOP3Ee]d0eMSP0=KHh@80eMSP00T0000008b<S03WinL0
inOW0>NeQ03FFP00eX@00?o>003>H`000P3NJ`001@3_]H`0kno_0>o_k`3_
knl000000080eMSQ00@0eMOP0=KHh03Ff>40e]OQ<03Fen0a0=KHh0X0eMSQ
00D0JgF?0<?5f@2l_M40_;gA0?ooo`0702DU=PL0_;gA00H0`lGI06]eS`3E
f>40eMSQ06]eS`33aMT20;bmd@030?ooo`0U9CH0_;gA00L0_;gA00<0oooo
02DU=P2l_M400P2l_M401@33aMT0JgF?0=KGh03Een40YSU40080eEeP00<0
f61Q0=UQHP167QX00`3oool30=UQHP<0oooo00<0AQhJ0=UQHP3HH6400P3E
GF001P2V>D@0e]SP0=GHh@3Een00eMSQ0=GFg@40IVIn00001`1VIWh0d]CM
0<oBg03@d]`0d=;M0=3Bg00000000`3WinL0303Wg/h0aTX00?O>003_[@00
kkD00<i[0036FP00aV/00=j<BP3WY@00knO>000000<0d=;L00<0cm;L0=3B
g03?d]`0<03@d]`a0<oBg@X0d=;L00<0JgF?0<S9f`33a=H04033a=H01P38
bM/0JgF?0=3Bg03@d]`0JgF?0<S9f`80`lCF00<0oooo02DU=P33a=H01`33
a=H00`3oool09BDf0<?4eP020<?4eP070<S9f`1[MHl0cm;L0<oBg02V>D@0
eemO0=UQHP030=aUI@0504HN6P3oool0oooo0?ooo`3LIFD00`3oool02016
7QX0g6EU0=aUI@3LIFD0fF5R0=MOG`2V>D@0d=;M0P3@d]`10<oBg040d]CM
0@1VIWh0000L06IVOP3@d]/0blgH0<[=f@3;c]P0b/gH0000003WaZd0ilJ<
0?O>603__@00mlH00>n]003W[@00ijD00=J<003>J`00ilH00?oF003_knL0
kno_0000003;cMP0blgI0<[=f@3;c]P0b/gH0<_=f300blgI<@3;c]T:0<_=
f00306]eS`3;c=h0b<[I00P0b<[I00<0b<WI0<S:f@38b]T00`38b]T01038
bMT0b<[I0<_<gP1[MHl20<_=f00606]eS`3;c=h0b<[I0<S:f@3oool09BDf
1@38b]T04@38bMT0b<[I0<S:f@3oool09BDf0<S:f@38bMT0b<[I0<_<gP1[
MHl0blkH0<[=f02V>D@0eemO0=]TI03PIfD0h6IU0080gVMW00<0AQhJ0?oo
o`3oool00`3oool02P167QX0gVMW0=iWI`3PIVD0h6MU0=]TI03GGel0YSU4
0<[>f03:c]T20<_=f@40d=;K0@1VIWh0000306IVOP3?cmX0aLSD00<0aLSD
00H000000<K6aP3Wg]H0cW/00>N]003_]@020>NU00030=JD003>L`00eY@0
0080mlH00P3gmoL010000000aLSD0<G7e035am@30<G7eC00a<OE<@34b=@:
0<C7e00306]eS`3@dN00bl_L0100bl_L00H0d=7P06]eS`34am@0a<OD06]e
S`3@dN020<_;g0030?ooo`0U9CH0bl_L00L0bl_L00<0oooo02DU=P3;bm`0
0P3;bm`01`3@dN00JgF?0<G7e034am@0YSU40=]TI03OIF@01@3PJVP01@16
7QX0oooo0?ooo`3oool0AQhJ00D0h6YX00@0gfET0=]TI02V>D@0a<SE0P34
b=@10<G7e@40cloJ0@1VIWh0000406IVOP3<c]X0`/CB0<74d@80`LCB00H0
00000>OWi`3WinL0inOW0=J4003_]@020>NU00080=J4003>J`00ijd00?Ne
003g_@00kno_0?Ogm`0000030<74dP030<;4d@31a=80`LCB0300`LCA<@31
a=8:0<;4dP0306]eS`3Cdn80cm3M0100cm3M00H0dm?R06]eS`32a=80`/CB
06]eS`3Cdn820<o@g@030?ooo`0U9CH0cm3M00L0cm3M00<0oooo02DU=P3?
d=d00P3?d=d01`3Cdn80JgF?0<;4dP31a=40YSU40=]TI03QJFD01@3PK6T5
0?ooo`D0h6aY00P0hFUU0=]TI02V>D@0`LCB0<;4d@31a=40`LCB0<c>fP40
IVIn0000101VIWh0b/cH0;k0c`2m`<l20;k0cP050000002LW9`0inOW0>ON
eP3FS0000P3NU000103FN`00aV<00;e2003_Y@020?N]00080?Ne003ocTX0
00000;k0cP2n`<l0_/3>0;k0c`2m`<ha0;k0cS40_L3>2P2n`<h00`1[MHl0
e]KT0=?Ch00@0=?Ch0060=KFi01[MHl0_/3>0;k0cP1[MHl0e]KT0P3Cdn00
0`3oool09BDf0?ooo`080?ooo`0;02DU=P3Cdn00dm?P0=?Ch03Fe^@0JgF?
0;k0c`2n`<h0YSU40>1VI@3QJVX0103SK6`30?ooo`0404HN6P3oool0oooo
0?ooo`@0hfa/00@0hFYZ0>1VI@2V>D@0_L3?0P2n`<l10;k0cP40b/cH0@1V
IWh0000706IVOP39b]P0][S80;Vlb`2j_</0^[c<000000020>o_k`0C0=JL
003FS000gY@00=J4003_Y@00gX`00;eJ003FL`00ki`00?O_i`3gmoL0oooo
0000002i_<`0^[_<0;Vlb`2j_</0^Kc<0;Vlb`0`0;Vlc340^[c<2P2j_</0
0`1[MHl0f=SU0=?Ch@0@0=?Ch@060=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU
0P3Cdn400`3oool0KVf?06i]S`0806i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3H
f>D0JgF?0;Zlb`2j_<`0YSU40>1YJ03QKF`0i75]0>AaK`3TL6h30?ooo`03
04HN6P3TL6h0AQhJ00<0oooo0P3TL6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<
0;Zkc02i_</0][S80<W:f00106IVOP0000T0IVIn0<O9e`2d]/L0][S80;Jh
b@2f^LT0000008B4Q03Wimh00P3_knl01`36J`00mlH00>ne003_W000gX`0
0<i[003WW0000`3gmoL01@000000][W90;Nhb@2f^LT0]kW90080][S9<02g
^<Ta0;Jhb@X0]kS900@0JgF?0=KFi03Hf>D0f=SV0`3Hf>D50=SHiP<0f=SU
0P3Hf>H20=SHi@090=KFi01[MHl0]kS90;Nhb@1[MHl0e]KT0=SHi@3Hf>H0
oooo00X0KVf?00d09BDf0=SHiP3Hf>D0f=SU0=KFi01[MHl0]kS90;Nib@2V
>D@0i6i]0>AdK`3WLFl0i7A_00<0oooo00D0AQhJ0>AdK`3TM6l0i7A_04HN
6P030?ooo`0:0>AdK`3WLFl0i7A_0>A^K@2V>D@0][W90;Jhb@2f^LT0];K7
0<O9e`40IVIn00000`1VIWh0a/SG0;Bfa`030;Bfa`030000003_knl0kno_
0080kno_00/0ijd00?O6203WY@00ii@00>N<003_imH0gY@i0>oF]@3omoL0
oooo0000001a0;Bfa`0506]eS`3EeN<0g=_W0=cKi`3MfnL03P3LfnL01P3E
eN<0JgF?0;Bfa`2d]/L0JgF?0=GEh`80g=_W00<0gM_W02DU=P0U9CH02@0U
9CH30=cKi`090=GEh`1[MHl0];K70;Bfa`2V>D@0ig=_0>MeLP3ZMW<0jWQf
0080oooo00<0AQhJ0>UnN03YOWP00`3YOWP020167QX0oooo0?ooo`3ZN7H0
jWIc0>MeLP3WLfl0YSU4102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;Bf
a`030;Bfa`060000002<S8`0kno_0>o_k`3WcW/0kno_0P3gmoL0203WU000
mnO>0?Ogm`3gmoL0knOF0?Ogm`3oool00000L@2d]/L00`1[MHl0eMCS0>3O
jP0@0>3OjP060=GDh`1[MHl0];K70;Bfa`1[MHl0eMCS4@3PgnX02@3Ee><0
JgF?0;Bfa`2d]/L0YSU40>YiL`3YO7P0kh5j0?:9P@0204HN6P070>^HR`3Z
Vh`0kIN:0>^HR`3ZVh`0kIN:0>^HR`0204HN6P050?:9P@3_PGX0jGah0>Yi
L`2V>D@0102d]/L10<K8e`40IVIn00000`1VIWh0a/SG0;6cb0030;6cb006
0000003_knl0kno_0>o_k`3gmnl0kno_0P3gmoL00`3gilH0moOg0?ooo`03
0?Ogm`030?ooo`000000/K?80700/K?800<0JgF?0>g[l`3Yj?40403Yj?40
1P3]jo<0JgF?0;6cb02a/lP0JgF?0>g[la40jNSa01T0kN_c06]eS`2a/lP0
/K?80:HiA03aP7D0l8Al0?F<Q03gWHh0lZ^F0?6bV`3]]9/0k;FL0?6bV`3]
]9/0k;FL0?6bV`3]]9/0k;FL0?:[UP3gWHh0mHb40?24O03aP7D0YSU400@0
/K?80@36b=L106IVOP0000<0IVIn0<K8e`2h]ll00`2_[/L01@000000[Jf]
0?Ogk`3gmoL0kno_00H0moOg0P3omoL20?ooo`030000002_[/L0[jk706l0
[jk700<0JgF?0=;Ah`3blOL0403blOL01P3BdN<0JgF?0:n^a`2_[/L0JgF?
0=;Aha40l_7g00H0d]7S06]eS`2_[/L0[jk70:HiA03dRWd20?F@Q@d0l[RN
0P3eT8D00`3dRWd0YSU40:n^a`020:n^a`40^;O?0@36b=L106IVOP0000<0
IVIn0<31d@37am@0Q02/Zl@01024S:80JgF?0<c;g@3kno`=0?ooo`040?_k
o03<bmd0JgF?08B<XP80[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103k
no`0c<_M06]eS`24S:820:b[a007096HZP2V>D@0oin=0?joY03jg;L0n^^g
0?[Y]P020?WY]P040?[Y]P3ijKH0nNVf0?[Y]P80nNVf00H0n^^g0?[L]`3n
_j@0oin=0:HiA02AV:X30:b[a040alOD0@30`M4106IVOP0000@0IVIn0<31
d@3Bd]l0]KC9Q02TXkh00`24S:80JgF?06]eS`0?06]eS`0308B<XP2TXkh0
Y:>n0080Y:>n00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P02
0:BS_P0308B<XP2V>D@0YSU400l0YSU400L0Q8bR0:BS_P2TXkh0Y:>n0;Fd
b@3Bd]l0`<7A0040IVIn00001P1VIWh0Z:No0>KVk@3Bd^00_;c?0;6`a<@0
Z:No00D0/K340;blc`3Bd^00i^K]0:RW_`0106IVOP0000L0F5MX08N7V`3G
f>80o?cl0>CSj03@d>00b/[J0<80_;c?00H0b/[J0=3@h03ThnP0o?cl0=OH
hP27Qi/105QGJ00000P0F5MX06IVOP2EU:/0emSR0?clo03blO<0k>_^0>7R
jl00emSR00L0hN;[0>c[kP3blO<0o?cl0=OHhP2EU:/0IVIn0040F5MX0002
05QGJ00306IVOP2EU:/0dM7N0080o?cl`P3oool20?clo0030=7AgP2EU:/0
IVIn0080F5MX000305QGJ080IVIn00<0R8NM09FDZ`2XYkl0`@2XYkl0102E
U:/0R8NM06IVOP1VIWh305QGJ0001@1HEfS606IVOPD0F5MX0000\
\>"], "Graphics",
  CellLabel->"From In[21]:=",
  Evaluatable->False,
  ImageSize->{208, 144},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"Table"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellLabel->"Out[21]=",
  CellTags->"Table"]
}, Open  ]],

Cell["We can also query and change individual cells.", "Text",
  CellTags->"Table"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ref\ @\ 
      InvokeMethod[{"\<myTableModel\>", \ "\<getValueAt\>"}, \ 1, 
        1]\)], "Input",
  CellLabel->"In[22]:=",
  CellTags->"Table"],

Cell[BoxData[
    \("{3, 2}"\)], "Output",
  CellLabel->"Out[22]=",
  CellTags->"Table"]
}, Open  ]],

Cell[BoxData[
    \(ref\ @\ 
      InvokeMethod[{"\<myTableModel\>", \ "\<setValueAt\>"}, \ "\<Test\>", 1, 
        1]\)], "Input",
  CellLabel->"In[23]:=",
  CellTags->"Table"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GUIScreenShot[ref] // Show\)], "Input",
  CellLabel->"In[24]:=",
  CellTags->"Table"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003@0000T2000`400?l0
0000o`00003od01VIWh0000306IVOP3ko?d0nocm0<`0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk0</0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
bP1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVO/P0Oifi
00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0
aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2XZK/0
IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0<H0h=oS00@0Oifi06IVOP2XZK/0nocm0@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0aP3Pgn<0101oWKT0IVIn0:RY^`3k
o?d106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@360>3Oh`0407nM^@1V
IWh0Z:Vk0?_lo@40IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0<H0h=oS
00@0Oifi06IVOP2XZK/0nocm0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP1o
WKT0aP3Pgn<0101oWKT0IVIn0:RY^`3ko?d106IVOP0000D0IVIn0?_lo@2X
ZK/0IVIn07nM^@360>3Oh`0407nM^@1VIWh0Z:Vk0?_lo@40IVIn00001@1V
IWh0nocm0:RY^`1VIWh0Oifi0<H0P82000@0Oifi06IVOP2XZK/0nocm0@1V
IWh0000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?oo
o`0^0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3oool0;P3o
ool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0Oifi0340oooo00@0P8200?ooo`3oool00000;@3oool00`20P800
oooo0?ooo`0_0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM^@1V
IWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?oo
o`050820P03oool0oooo0?ooo`000000;03oool00`20P800oooo0?ooo`0_
0?ooo`030820P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_l
o@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM^@3oool0000000<0oooo
00<000000?ooo`3oool0:@3oool01@20P800oooo0?ooo`3oool0000002`0
oooo00<0P8200?ooo`0000001000000[0?ooo`030820P03oool0oooo00<0
0000:`3oool01@20P800Oifi06IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0Oifi0080oooo00<000000?ooo`000000;03oool01@20
P800oooo0?ooo`3oool0000002`0oooo00@0P8200?ooo`3oool00000;P3o
ool00`20P800oooo000000030?ooo`030000003oool0oooo02P0oooo00D0
P82007nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn
07nM^@030?ooo`030000003oool0oooo02/0oooo00H0P8200?ooo`3oool0
00000?ooo`00000[0?ooo`050820P03oool0oooo0?ooo`000000;@3oool0
0`20P800oooo0?ooo`030?ooo`030000003oool0oooo02P0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM
^@030?ooo`030000003oool0oooo02/0oooo00H0P8200?ooo`3oool00000
0?ooo`00000[0?ooo`050820P03oool0oooo0?ooo`000000;@3oool00`20
P800oooo0?ooo`030?ooo`030000003oool0oooo02P0oooo00D0P82007nM
^@1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@02
0?ooo`030000003oool0000002`0oooo00<0P8200?ooo`0000000`3oool0
0`000000oooo0?ooo`0X0?ooo`030820P03oool0oooo0080oooo00<00000
0?ooo`3oool0:P3oool00`20P800oooo00000003000002/0oooo00D0P820
07nM^@1VIWh0Z:Vk0?_lo@0106IVOP0000L0IVIn0?_lo@2XZK/0IVIn07nM
^@3oool0000000<0oooo00<000000?ooo`3oool0:@3oool00`20P800oooo
000000030?ooo`030000003oool0oooo02P0oooo00<0P8200?ooo`000000
1000000[0?ooo`030820P03oool0000002h0oooo00D0P82007nM^@1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn07nM^@0a0?ooo`03
0820P03oool0oooo02h0oooo00<0P8200?ooo`3oool0;`3oool01020P800
oooo0?ooo`00000]0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0
000506IVOP3ko?d0Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?ooo`0^
0?ooo`030820P03oool0oooo02l0oooo00<0P8200?ooo`3oool01000000Z
0?ooo`050820P01oWKT0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0
Z:Vk06IVOP1oWKT0<@3oool00`20P800oooo0?ooo`0^0?ooo`030820P03o
ool0oooo02l0oooo00<0P8200?ooo`3oool0;P3oool01@20P800Oifi06IV
OP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0Oifi0340oooo
00<0P8200?ooo`3oool0;P3oool00`20P800oooo0?ooo`0_0?ooo`030820
P03oool0oooo02h0oooo00D0P82007nM^@1VIWh0Z:Vk0?_lo@0106IVO