(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     19063,        377]*)
(*NotebookOutlinePosition[     19809,        403]*)
(*  CellTagsIndexPosition[     19765,        399]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " Example: \nIncrement Controls"
}], "Section"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002O0000>B000`400?l0
0000o`00003oW`1VIWh0000306IVOP3ko?d0nocm09/0nocm0@1VIWh00003
06IVOP3ko?d0Z:Vk09X0Z:Vk0@3ko?d106IVOP0000<0IVIn0?_lo@2XZK/0
V@1VIWh10:RY^`40nocm0@1VIWh0000406IVOP3ko?d0Z:Vk06IVOSh0h=oS
00D0hN3T0>KUj03/jnh0l?3b0?;bm00L0??cm1T0n?Oh0P3clo@01@3cloD0
m?Ce0?GemP3dloD0iNCX01P0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh00004
06IVOP3ko?d0Z:Vk06IVOSh0h=oS00@0g]cO0>CRh01kUjd09EN5>@00?7@0
100GCGh0Jh^V0?;akP3blO<H0>3Oh`0306IVOP2XZK/0nocm0040IVIn0000
101VIWh0nocm0:RY^`1VIWhk0:F//P<0h=oS00@0f]SI06J5X@1:LI<0/[g3
>@36aML01030a/D0B6j@06Z:Y03_ko4H0>3Oh`0306IVOP2XZK/0nocm0040
IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb03T0oooo00L0YJbb0>3Oh`3P
gn<0h=oS0=SEeP0GCGh0_lO:03/0a/GG00<0][fm01M=OP3[j^d0603Pgn<0
0`1VIWh0Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P0i
0?ooo`070:F//P3Pgn<0h=oS0>3Oh`3IeMD003ad0?ooo`0k0<g<g`030?oo
o`00?7@0j>OZ01P0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3k
o?d0Z:Vk06IVOP2U[;80>@3oool01`2U[;80h=oS0>3Oh`3Pgn<0fMGE000l
M03oool04`3BdN@00`000000d]7T0=;Ai00U0=;Ai0030?ooo`00?7@0inKY
00L0h=oS3@0LDH040>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0
nocm0:RY^`1VIWh0YJbb03T0oooo00L0YJbb0>3Oh`3Pgn<0h=oS0=WEe@00
?7@0oooo01<0e]OW00<000000=KGi`3FenL09@3FenL00`3oool003ad0>OV
j@070>3Oh`0901aAP03clo40mOGc0?OgmP3inOP0n_[i0?cln`3moOd0o_kn
00<0oooo00<075600>3Oh`3Pgn<00P3Pgn<00`1VIWh0Z:Vk0?_lo@0106IV
OP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P0i0?ooo`070:F//P3Pgn<0h=oS
0>3Oh`3IeMD003ad0?ooo`0>0=WJi`80000000D0fM[W0000003If^L00000
0=WJi`02000000<0fM[W0P000000103If^L000000=WJi`3If^L200000003
0=WJi`000000fM[W008000000P3If^L3000000l0fM[W00<0oooo000lM03W
i^T01`3Pgn<02P0LDH00lO7_0??cl@3emO<0moOf0?Win03jn_T0o?ck0?gm
o@3no_h20?ooo`0301aAP03Pgn<0h=oS0080h=oS00<0IVIn0:RY^`3ko?d0
0@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;80<@3oool00`000000oooo
0?ooo`050?ooo`070:F//P3Pgn<0h=oS0>3Oh`3IeMD003ad0?ooo`0=0=WJ
i`030000003If^L0fM[W0080000000<0fM[W0000000000000P3If^L00`00
0000fM[W000000020=WJi`80000000@0fM[W0000003If^L0fM[W0P000000
1@3If^L000000=WJi`3If^L0000000<0fM[W00<000000=WJi`3If^L0303I
f^L00`3oool003ad0>OVj@070>3Oh`0=01aAP03_kn`0lO7_0??cl@3emO<0
8J4Q0?Win03jn_T0o?ck0?gmo@3no_h0oooo01aAP0040>3Oh`0306IVOP2X
ZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb0340oooo00<0
00000?ooo`3oool01@3oool01`2U[;80h=oS0>3Oh`3Pgn<0fMGE000lM03o
ool03@3Ngn`01`000000g]o/0=kOk03Ngn`000000=kOk00000000`3Ngn`0
0`000000g]o/000000030=kOk0030000003Ngn`0000000<0g]o/00<00000
0=kOk00000000P3Ngn`00`000000g]o/0=kOk00@0=kOk0030?ooo`00?7@0
inKY00L0h=oS00@075600>c/j@3_kn`0lO7_0`0QXB401P3inOP0n_[i0?cl
n`3moOd0o_kn01aAP0@0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IV
OP3ko?d0Z:Vk06IVOP2U[;80:P3oool3000000030?ooo`000000000000<0
00001P3oool01`2U[;80h=oS0>3Oh`3Pgn<0fMGE000lM03oool03@3SiO00
1`000000hnG`0>?Ul03SiO0000000>?Ul00000000`3SiO000`000000hnG`
000000030>?Ul0030000003SiO00hnG`00@0000000@0hnG`0000003SiO00
hnG`1@00000>0>?Ul0030?ooo`00?7@0inKY00L0h=oS00<075600>[ZiP3/
k>T01@0QXB401@3inOP0n_[i0?cln`3moOd0756000@0h=oS00<0IVIn0:RY
^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IVOP2U[;80;P3oool01000
0000oooo0?ooo`0000070?ooo`070:F//P3Pgn<0h=oS0>3Oh`3IeMD003ad
0?ooo`0=0>W[m@060000003YjoD0jN_e0>W[m@000000jN_e0P0000020>W[
m@030000003YjoD000000080jN_e0P0000000`3YjoD000000>W[m@020>W[
m@030000003YjoD000000080jN_e00D000000>W[m@3YjoD0jN_e0000000>
0>W[m@030?ooo`00?7@0inKY00L0h=oS00<075600>OWh`3Zj^H00P0QXB40
203alNl08J4Q026Q8@0QXB40nOWh0?[jn@3lo?/07560103Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P0_0?ooo`03
0000003oool0000000L0oooo00L0YJbb0>3Oh`3Pgn<0h=oS0=WEe@00?7@0
oooo00d0l?7l00P000000?3ao03`lO`0l?7l0000003`lO`000000?3ao080
00000`3`lO`2000000040?3ao0000000l?7l0?3ao0<0000000@0l?7l0000
0000000000000P3`lO`3000000l0l?7l00<0oooo000lM03Wi^T01`3Pgn<0
1`0LDH00iNGQ0>OWh`0QXB40k>cY0>o_k03alNl00`0QXB400`3inOP0n_[i
01aAP0040>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0YJbb02l0oooo00<000000?ooo`0000001`3oool01`2U[;80h=oS
0>3Oh`3Pgn<0fMGE000lM03oool07@3dmOd00`000000m?Gm0?Ceo@050?Ce
o@030000003dmOd0m?Gm01<0m?Gm00<0oooo000lM03Wi^T01`3Pgn<0200L
DH00hn?O0>GUh@3Win<0j^[V0>c/j@3_kn`0lO7_0P0QXB400`3gmoH0nOWh
01aAP0040>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY
^`1VIWh0YJbb0300oooo0P0000070?ooo`070:F//P3Pgn<0h=oS0>3Oh`3I
eMD003ad0?ooo`0M0?Kgo@030000003fmod0m_Om00D0m_Om00<000000?Kg
o@3fmod04`3fmod00`3oool003ad0>OVj@070>3Oh`0=01aAP03Rh]d0hn?O
0>GUh@3Win<0j^[V0>c/j@3_kn`0lO7_026Q8@3emO<0moOf01aAP0040>3O
h`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1VIWh0YJbb
0340oooo00<000000?ooo`3oool01@3oool01`2U[;80h=oS0>3Oh`3Pgn<0
fMGE000lM03oool0>`3ho?d00`3oool003ad0>OVj@070>3Oh`0=01aAP03R
h]d0h^;M0>?Sg`3UiN40inOS0>[ZiP3/k>T0kno/0?7ak`3clo40mOGc01aA
P0040>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1VIWh0nocm0:RY^`1V
IWh0YJbb03T0oooo00L0YJbb0>3Oh`3Pgn<0h=oS0=WEe@00?7@0oooo03/0
oOgm00<0oooo000lM03Wi^T01`3Pgn<03@0LDH00h^;M0>;Rg@3Rh]d0hn?O
0>GUh@3Win<0j^[V0>c/j@3_kn`0lO7_0??cl@0LDH00103Pgn<00`1VIWh0
Z:Vk0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P0i0?ooo`07
0:F//P3Pgn<0h=oS0>3Oh`3IeMD003ad0?ooo`0k0?gmo@030?ooo`00?7@0
i^KY00L0h=oS3@0LDH040>3Oh`0306IVOP2XZK/0nocm0040IVIn00001@1V
IWh0nocm0:RY^`1VIWh0YJbb03T0oooo00L0YJbb0>3Oh`3Pgn<0h=oS0=SD
e000?7@0oooo03/0oOgm00<0oooo000lM03UiNP0603Pgn<00`1VIWh0Z:Vk
0?_lo@0106IVOP0000D0IVIn0?_lo@2XZK/0IVIn0:F//P0i0?ooo`070:F/
/P3Pgn<0h=oS0>3Oh`3IeMD09EN50;o>g00k0?ooo`030;o>f`0UEhD0hN7T
01P0h=oS00<0IVIn0:RY^`3ko?d00@1VIWh0000506IVOP3ko?d0Z:Vk06IV
OP2U[;80>@3oool0202U[;80h=oS0>3Oh`3Pgn<0fMGE07VDZ@1EOJ80`<oM
>@3oool0103EgnP0EGfR07VEZ`3OgN0H0>3Oh`0306IVOP2XZK/0nocm0040
IVIn0000101VIWh0nocm0:RY^`1VIWhk0:F//P<0h=oS00@0f]OI0=oLf01i
U:T09EN5>@00?7@0100GCGh0IXJQ0>3NfP3LfmdH0>3Oh`0306IVOP2XZK/0
nocm0040IVIn0000101VIWh0nocm0:RY^`1VIWhn0>3Oh`030=oMh03JemT0
f=CD01h0em?D6@3Cc/`30=OCe0040=SDe03IeMD0f]OI0=oMh1P0h=oS00<0
IVIn0:RY^`3ko?d00@1VIWh0000306IVOP3gmoT0V9RW09T0MgNB0@2HV:L1
0?Ogn@40IVIn00000`1VIWh0moOi0;bmc@2J0;bmc@40moOi0@1VIWh00003
06IVOP3gmoT0i>?S09X0i>?S0@3gmoT106IVOP0000<0IVIn0?3am03oool0
D`3oool00`3Thn<0W:Bi06]eS`0306]eS`0406afT01[MHl0K7J@06afT0T0
JgF?00H0W:Bi0>CSh`3oool0oooo0>CSh`2LY;T406]eS`0406afT01[MHl0
K7J@06afT0T0JgF?00H0W:Bi0>CSh`3oool0oooo0>cZjP2LY;T40:HiA004
0:LjA02V>D@0YcY40:LjA0T0YSU400<0W:Bi0>cZjP3oool00`3oool10?3a
m040IVIn00005P1VIWh0h^7R0?_lo03kno`0nocm0?cko@3knod0nocm0?_l
o03lo?d0o?cl0?cko@3lo?`0o?_l0?clo03ko?`0o?cl0?_lo@3lno`0o?cm
0?_ko@3ko?`20?clo0040?clo@3lo?`0no_m0?cloB00o?_l6P3ko?`00`2L
Y;T0JgF?08F9/00@08F9/00606]eS`2LY;T0nocm0?_lo@2LY;T0JgF?4@25
RK001P1[MHl0W:Bi0?_lo03kno`0W:Bi0:HiA140ZSaE00L0YSU409bT^@3k
o?`0o?cl0?cko@3ko?d0h^7R0040IVIn0000101VIWh0h>3Q0?Kgn@3gmoT2
0?Kgn@0;0?Kgn03gmoT0moOh0?Kgn03fmoT0moOh0?Ogn@3gm_P0m_Oi0?Og
n@3fmoT00P3gmoT0103gm_P0m_Oh0?Kgn@3gmoT30?Kgn@030?Kgn03gmoT0
moOi01l0moOi6P3fmoT00`1[MHl0QHV`09bN_P0@09bN_P0608F9/01[MHl0
moOi0?Ogn@1[MHl0QHV`4@2LW[h02025RK00JgF?0?Kgn03gmoP0YSU40:Xl
E@32DU/0aUAJ3@36EE`02@36E5X0`U9K0:XlE@2V>D@0moOh0?Ogn@3gmoP0
moOi0>3Ph@0106IVOP0000H0IVIn0=kMh@3alO@0lO7d0?3am03`l_@@0000
00060?7am03`l_D0lO7d0?7bm03`l_@0lO7d>P3`lOD00`1[MHl0/[G@0:NX
`P0@0:NX`P060;:ed01[MHl0l?7d0?3am01[MHl0/[G@4@2WZ<801@2b]M00
JgF?0?3am@3al_@0YSU40080`U9K00<0beAI0<eIGP3=FEh02`3=FEh0103;
E5T0`U9K0<9BF`2V>D@20?3am0030?7am03`l_@0g]gQ0040IVIn00001`1V
IWh0g=_P0>[[l03Zjo00j^c`0>W[k`0000000P3WinL20=kNgP80inOW00<0
ikf40>OWi`3WinL00`3WinL20>o_k`040000003Zjo00j^_`0>[[k`80j^_`
00<0j^__0>[[l03Zjo007P3Zjo0J0>[/l00406]eS`2f^M40[Jk60:f^aPP0
oooo00<0[Jk60:b^aP2][/H00`2][/H00`2/[/H0][WA06]eS`020>[[k`04
06]eS`2f^M40[Jk60:f^aP`0oooo0P2][/H00`2/[/H0][WA06]eS`020>[[
l0050:HiA03=FEh0beAI0<eFF`3>FEl02`3@FUl01`3>FEl0cEIK0<]DF@3=
FEh0YSU40>[[k`3Zjo000P3Zjnl10=cKh040IVIn0000101VIWh0fMWO0>?U
jP3Si>X20>?Uj`050000002<S8`0g]kN0>OWi`3Ng]h00P3WinL00`36H`00
inOW0>OWi`020>OWi`070>o_i`3_knl0kno_0000003Si>X0hnC[0>?UjP02
0>?TjP030>?Tj`3SiN/0hnG[01h0hnG[6P3Si>X01@1[MHl0_;kD0;:bbP2b
//X0oooo00H0KVf?00<09BDf0;:bbP2b//X01@2b//X01P2l_]@0JgF?0>?U
jP3SiNX0JgF?0;bne080/[;:00<0oooo02DU=P0U9CH02@0U9CH30;:bbP05
0;bne01[MHl0hnC[0>?Tj`2V>D@00P3=FEh0103@Ff00e5aO0?ooo`3oool7
0=ALG`80oooo00X0e5aO0=1KH03=FEh0cEUN0:HiA03Si>X0hnGZ0>?TjP3S
iN/0fMWO0@1VIWh0000306IVOP3Gf=h0g=kV00<0g=kV00D000000>OWi`3W
inL0inOW0>OFcP020>OWi`050<ik003_U100inOW0>ONaP3_S1000`3_knl0
1`000000g=kV0=cNi@3Lg^D0g=kV0=cNi@3Lg^H0>P3Lg^D01@1[MHl0_l7F
0;RicP2h^Lh0oooo00H0KVf?00<09BDf0;RicP2h^Lh01@2h^Lh01P2o`MH0
JgF?0=cNi@3Lg^D0JgF?0;o1eP80^;W>00<0oooo02DU=P2h^Lh01`2h^Lh0
0`3oool09BDf0;RicP020;RicP090;o1eP1[MHl0g=kV0=cNi@2V>D@0cEUN
0=5JGP3DGF40DbDP00<0oooo1@3FGf<30?ooo`0505<U803DGF40dEYN0<eI
GP2V>D@00P3Lg^D00`3Lg^H0g=kU0=OHgP0106IVOP0000@0IVIn0=GFg@3E
f>00e]SQ0P3Ef>002@000000S8b<0>OWi`3WinL0ikF40=IJ003FQ000olh0
0<iS00020=i[00050>neS03_knl0kno_0>o_k`0000000P3Ef>40103Een00
e]SP0=KHh@3Fen4P0=KGh1X0e]SP00D0JgF?0<?5f@2l_M40_;gA0?ooo`07
02DU=PL0_;gA00H0`lGI06]eS`3Ef>40eMSQ06]eS`33aMT20;bmd@030?oo
o`0U9CH0_;gA00L0_;gA00<0oooo02DU=P2l_M400P2l_M401@33aMT0JgF?
0=KGh03Een40YSU40080eEeP00<0f61Q0=UQHP167QX00`3oool30=UQHP<0
oooo00<0AQhJ0=UQHP3HH6400P3EGF001P2V>D@0e]SP0=GHh@3Een00eMSQ
0=GFg@40IVIn00001`1VIWh0d]CM0<oBg03@d]`0d=;M0=3Bg00000000`3W
inL0303Wg/h0aTX00?O>003_[@00kkD00<i[0036FP00aV/00=j<BP3WY@00
knO>000000<0d=;L00<0cm;L0=3Bg03?d]`0803@d]`J0<oBg@0306]eS`38
bM/0`lCF0100`lCF00H0b<WK06]eS`3@d]`0d=;L06]eS`38bM/20<?4eP03
0?ooo`0U9CH0`lCF00L0`lCF00<0oooo02DU=P33a=H00P33a=H01`38bM/0
JgF?0<oBg03?d]`0YSU40=MOG`3IHF800`3LIFD01@167QX0oooo0?ooo`3o
ool0g6EU00<0oooo00P0AQhJ0=aUI@3LIFD0g6EU0=UQHP3GGel0YSU40=3B
g@80d=;L0@3?d]`10=;Dg@40IVIn0000701VIWh0d=;K0<_=f03:cMT0blkH
0<[=f0000000ilJ]0>O6S03gcQP0kkd00?O6003_[@00ijd00>NU003FS000
cV/00>O6003oeP00knoW0>o_k`000000blgH0<_=f@3:cMT0blkH0<[=f03;
cMPP0<_=fAX0blkI00<0JgF?0<_<gP38b]T02038b]T00`38bMT0b<[I0<S:
f@030<S:f@040<S9f@38b]T0blcN06]eS`80blgH00H0JgF?0<_<gP38b]T0
b<[I0?ooo`0U9CH50<S:f@0A0<S9f@38b]T0b<[I0?ooo`0U9CH0b<[I0<S9
f@38b]T0blcN06]eS`3;c]P0b/gH0:HiA03GGel0ffAT0>1WI@3PIVD00P3N
IfL00`167QX0oooo0?ooo`030?ooo`0:04HN6P3NIfL0gVMW0>1VI@3PIfD0
ffAT0=MOG`2V>D@0b/kH0<[>f@80blgI0@3@d]/106IVOP0000<0IVIn0<o?
fP35b=@00`35b=@01P000000a/K60>ONeP3>N`00ijd00>ne0080ijD000<0
eY@00<ic003FU0000P3gaP020?Ogm`0400000035b=@0aLOD0<G7e0<0aLOE
8034amDJ0<C8e00306]eS`3@dN00bl_L0100bl_L00H0d=7P06]eS`34am@0
a<OD06]eS`3@dN020<_;g0030?ooo`0U9CH0bl_L00L0bl_L00<0oooo02DU
=P3;bm`00P3;bm`01`3@dN00JgF?0<G7e034am@0YSU40=]TI03OIF@01@3P
JVP01@167QX0oooo0?ooo`3oool0AQhJ00D0h6YX00@0gfET0=]TI02V>D@0
a<SE0P34b=@10<G7e@40cloJ0@1VIWh0000406IVOP3<c]X0`/CB0<74d@80
`LCB00H000000>OWi`3WinL0inOW0=J4003_]@020>NU00080=J4003>J`00
ijd00?Ne003g_@00kno_0?Ogm`0000030<74dP030<;4d@31a=80`LCB0200
`LCA6P31a=800`1[MHl0dm?R0<o@g@0@0<o@g@060=?ChP1[MHl0`/CB0<;4
dP1[MHl0dm?R0P3?d=d00`3oool09BDf0<o@g@070<o@g@030?ooo`0U9CH0
cm3M0080cm3M00L0dm?R06]eS`32a=80`LCA0:HiA03KI6@0hFUU00D0h6aY
1@3oool50>1/J@080>5YI@3KI6@0YSU40<74dP32a=40`LCA0<74dP3<c]X1
06IVOP0000@0IVIn0<[<f02n`<l0_L3?0P2n`<h01@000000W9bL0>OWi`3W
g]H0eX`00080gY@000@0eW/00<IS002m@P00kjD00P3g[@00203g]@00oli:
0000002n`<h0_/3?0;k0cP2n`<l0_L3>8@2n`<hJ0;g0cP0306]eS`3Fe^@0
dm?P0100dm?P00H0e]KT06]eS`2n`<h0_/3>06]eS`3Fe^@20=?Ch0030?oo
o`0U9CH0oooo00P0oooo00/09BDf0=?Ch03Cdn00dm?P0=KFi01[MHl0_/3?
0;k0cP2V>D@0h6IU0>5ZJP040>=/K0<0oooo00@0AQhJ0?ooo`3oool0oooo
103SK6`0103QJVX0h6IU0:HiA02m`<l20;k0c`40_/3>0@3:c=P106IVOP00
00L0IVIn0<W:f02f^<P0^Kc;0;Zlb`2j_<`000000080kno_01<0eY`00=J<
003NU000eX@00>nU003NS000_EX00=Ic003_W000mnoW0?Ogm`3oool00000
0;Vlc02j^l`0^Kc;0;Zlb`2i_<`0^Kc;0200^Kc<6P2j_<`00`1[MHl0f=SU
0=?Ch@0@0=?Ch@060=SHi@1[MHl0^[c;0;Zlb`1[MHl0f=SU0P3Cdn400`3o
ool0KVf?06i]S`0806i]S`0>02DU=P3Cdn40dm?Q0=?Ch@3Hf>D0JgF?0;Zl
b`2j_<`0YSU40>1YJ03QKF`0i75]0>AaK`3TL6h30?ooo`0304HN6P3TL6h0
AQhJ00<0oooo0P3TL6h02@3TLFd0hFe/0>1YJ02V>D@0^[c<0;Zkc02i_</0
][S80<W:f00106IVOP0000T0IVIn0<O9e`2d]/L0][S80;Jhb@2f^LT00000
08B4Q03Wimh00P3_knl01`36J`00mlH00>ne003_W000gX`00<i[003WW000
0`3gmoL01@000000][W90;Nhb@2f^LT0]kW90080][S9802g^<TJ0;Jhb@04
06]eS`3Fe^@0f=SU0=SHiP<0f=SU1@3Hf>H30=SHi@80f=SV0P3Hf>D02@3F
e^@0JgF?0;Nhb@2g^<T0JgF?0=KFi03Hf>D0f=SV0?ooo`0:06i]S`0=02DU
=P3Hf>H0f=SU0=SHi@3Fe^@0JgF?0;Nhb@2g^LT0YSU40>A^K@3TM6l0ig5_
0>AdK`030?ooo`0504HN6P3TM6l0i7A_0>AdK`167QX00`3oool02P3TM6l0
ig5_0>AdK`3TKVd0YSU40;Jib@2f^<T0][W90;Bfa`37bML106IVOP0000<0
IVIn0<K8e`2d]/L00`2d]/L00`000000kno_0>o_k`020>o_k`0;0>N]003g
aPP0ijD00>ND003WS000knOF0=jD>@3_e[D0ooOg0?ooo`000000@02d]/L0
1@1[MHl0eMGS0=cKi`3LfnL0gM_W00h0g=_W00H0eMGS06]eS`2d]/L0];K7
06]eS`3EeN<20=cKi`030=gKi`0U9CH09BDf00T09BDf0`3LfnL02@3EeN<0
JgF?0;Bfa`2d]/L0YSU40>McK`3WMG80jWIc0>YhMP020?ooo`0304HN6P3Y
OWP0jGih00<0jGih00P0AQhJ0?ooo`3oool0jWQf0>YfL`3WMG80ig=_0:Hi
A0@0];K70@36b=L106IVOP0000<0IVIn0<K8e`2d]/L00`2d]/L01P000000
S8b<0>o_k`3_knl0ilik0>o_k`80moOg00P0ii@00?OWcP3gmoL0moOg0>oW
eP3gmoL0oooo00000400];K700<0JgF?0=GDh`3PgnX0403PgnX01P3Ee><0
JgF?0;Bfa`2d]/L0JgF?0=GDha40h=oZ00T0eMCS06]eS`2d]/L0];K70:Hi
A03ZNG<0jGah0>n1NP3bRH400P167QX01`3[V8/0jY^<0>fGRP3[V8/0jY^<
0>fGRP3[V8/00P167QX01@3bRH40kh5j0>UlN03ZNG<0YSU400@0];K70@36
b=L106IVOP0000<0IVIn0<K8e`2a/lP00`2a/lP01P000000kno_0>o_k`3_
knl0moO_0>o_k`80moOg00<0mnO60?Ogm`3oool00`3gmoL00`3oool00000
0;6cb00o0;6cb00306]eS`3]jo<0jNSa0100jNSa00H0kN_c06]eS`2a/lP0
/K?806]eS`3]jo<A0>WXl@0I0>g[l`1[MHl0/K?80;6cb02V>D@0lH1e0?24
O03eS8@0mif>0?:[UP3a/Y/0kKBK0>beW03a/Y/0kKBK0>beW03a/Y/0kKBK
0>beW03bZiH0mif>0?F<Q03`Q7`0lH1e0:HiA0040;6cb040a/SG0@1VIWh0
000306IVOP36b=L0^;O?00<0[jk700D000000:f][@3gmnl0moOg0>o_k`06
0?Ogm`80ooOg0P3oool00`000000[jk70:n^a`0n0:n^a`0306]eS`3BdN<0
l_7g0100l_7g00H0d]7S06]eS`2_[/L0[jk706]eS`3BdN<A0?;am`060=;A
h`1[MHl0[jk70:n^a`2V>D@0m8Ym0P3eT8D=0?:hWP80mI2500<0m8Ym0:Hi
A02_[/L00P2_[/L10;Rgc`40a/SG0@1VIWh0000306IVOP30`M40alOD05<0
[:_400@0Q8bR06]eS`3<bmd0no_l3@3oool0103kno`0c<_M06]eS`24S:82
0:b[a00408B<XP1[MHl0c<_M0?_ko0d0oooo00@0no_l0<c;g@1[MHl0Q8bR
0P2/Zl@01`2AV:X0YSU40?nOS@3n_j@0n]bg0?[[]`3jjKH00P3ijKH0103j
jKH0nNVf0?WY]P3jjKH20?WY]P060?[[]`3jg;L0o[nT0?nOS@2V>D@0TIRZ
0`2/Zl@10<O7e040`<7A0@1VIWh0000406IVOP30`M40d];O0;FdbE<0Y:>n
00<0Q8bR06]eS`1[MHl03`1[MHl00`24S:80Y:>n0:BS_P020:BS_P0308B<
XP1[MHl0JgF?00l0JgF?00<0Q8bR0:BS_P2TXkh00P2TXkh00`24S:80YSU4
0:HiA00?0:HiA00708B<XP2TXkh0Y:>n0:BS_P2e]<T0d];O0<31d@0106IV
OP0000H0IVIn0:RW_`3Vi^d0d];P0;blc`2a/<BC0:RW_`050;6`a02l_<l0
d];P0>KVk@2XYkl00@1VIWh0000705QGJ027Qi/0emSR0?clo03ThnP0d=3P
0<[:fP2A0;blc`060<[:fP3@d>00i>?X0?clo03Gf>80QhNK0@1HEfP00008
05QGJ01VIWh0UIB[0=OHhP3lo?`0l_7c0>c[kP3Qh^^?0=OHhP070>7Rj`3/
jnh0l_7c0?clo03Gf>80UIB[06IVOP0105QGJ0000P1HEfP00`1VIWh0UIB[
0=7AgP020?clo940oooo0P3lo?`00`3AdMh0UIB[06IVOP0205QGJ0000`1H
EfP206IVOP0308R7W@2EU:/0Z:No0900Z:No00@0UIB[08R7W@1VIWh0IVIn
0`1HEfP000D0F5MXU@1VIWh505QGJ000\
\>"], "Graphics",
  CellLabel->"From In[6]:=",
  Evaluatable->False,
  ImageSize->{159, 57},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[CellGroupData[{

Cell["Code", "SubsectionIcon"],

Cell[BoxData[
    \(Needs["\<GUIKit`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(expr = 
        Widget["\<Panel\>", {\[IndentingNewLine]WidgetGroup[{\
\[IndentingNewLine]Widget["\<TextField\>", {\[IndentingNewLine]"\<text\>" \
\[Rule] "\<0\>", \[IndentingNewLine]"\<columns\>" \[Rule] 
                      6, \[IndentingNewLine]"\<horizontalAlignment\>" \[Rule] 
                      PropertyValue["\<Right\>"], 
                    BindEvent["\<action\>", 
                      Script[\[IndentingNewLine]value = 
                          ToExpression[
                            PropertyValue[{"\<textField\>", "\<text\>"}]]\
\[IndentingNewLine]\ ]\[IndentingNewLine]]}, 
                  Name \[Rule] "\<textField\>"], \
\[IndentingNewLine]Widget["\<Button\>", {\[IndentingNewLine]"\<label\>" \
\[Rule] "\<update\>", \[IndentingNewLine]BindEvent["\<action\>", \
\[IndentingNewLine]Script[\[IndentingNewLine]buttonClicked[]\
\[IndentingNewLine]]\[IndentingNewLine]]}], \
\[IndentingNewLine]Widget["\<CheckBox\>", {}, 
                  Name \[Rule] "\<checkBox\>"]\[IndentingNewLine]}, 
              WidgetLayout \[Rule] 
                Row], \[IndentingNewLine]\[IndentingNewLine]Script[\
\[IndentingNewLine]value = 
                0; \[IndentingNewLine]buttonClicked[] := \((If[
                    PropertyValue[{"\<checkBox\>", "\<selected\>"}], \(value\
++\), \(value--\)]; \[IndentingNewLine]SetPropertyValue[{"\<textField\>", \
"\<text\>"}, ToString[value, 
                      InputForm]])\)\[IndentingNewLine]]\[IndentingNewLine]}];\
\)\)], "Input",
  CellLabel->"In[2]:=",
  InitializationCell->True],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(value\\)\\\" is similar to existing symbol \
\\\"\\!\\(Value\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[2]:="]
}, Open  ]],

Cell[BoxData[
    \(\(IncrementControlsDialog[] := GUIRunModal[expr];\)\)], "Input",
  CellLabel->"In[3]:=",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection"],

Cell[TextData[{
  "Thiis example demonstrates some simple interaction between user interface  \
controls and some ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " scripting."
}], "Text"],

Cell[BoxData[
    \(IncrementControlsDialog[]\)], "Input",
  CellLabel->"In[4]:="]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 941}},
AutoGeneratedPackage->None,
Saveable->False,
WindowSize->{488, 536},
WindowMargins->{{70, Automatic}, {Automatic, 28}},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 112, 4, 91, "Section"],
Cell[1891, 59, 14500, 241, 63, 14358, 236, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16416, 304, 30, 0, 39, "SubsectionIcon"],
Cell[16449, 306, 105, 3, 29, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[16579, 313, 1565, 29, 609, "Input",
  InitializationCell->True],
Cell[18147, 344, 387, 6, 50, "Message"]
}, Open  ]],
Cell[18549, 353, 136, 3, 29, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[18722, 361, 29, 0, 39, "Subsection"],
Cell[18754, 363, 196, 6, 42, "Text"],
Cell[18953, 371, 82, 2, 29, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

