(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4512,        145]*)
(*NotebookOutlinePosition[      5258,        171]*)
(*  CellTagsIndexPosition[      5214,        167]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  StyleBox["GUIKit",
    FontSlant->"Italic"],
  " Example: \nSimpleDialogApp"
}], "Section"],

Cell[CellGroupData[{

Cell["Code", "SubsectionIcon"],

Cell[BoxData[
    \(Needs["\<GUIKit`\>"]\)], "Input",
  CellLabel->"In[1]:=",
  InitializationCell->True],

Cell[BoxData[
    \(SimpleDialogApp[] := 
      GUIRun["\<Wolfram/Example/SimpleDialogApp\>"]\)], "Input",
  CellLabel->"In[2]:=",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["Definition", "SubsubsectionIcon"],

Cell[CellGroupData[{

Cell[BoxData[
    \(def\  = \ 
      Block[{$Path\  = \ $GUIPath}, \
\[IndentingNewLine]Get["\<Wolfram/Example/SimpleDialogApp.m\>"]]\)], "Input",
  CellLabel->"In[4]:="],

Cell[BoxData[
    \(Widget[
      "Frame", {"title" \[Rule] "Simple Dialog App", 
        Widget["TextField", {"text" \[Rule] "Initial app text"}, 
          Name \[Rule] "appTextField"], 
        Widget["Dialog", {"title" \[Rule] "Simple Dialog", 
            "modal" \[Rule] True, 
            Widget["TextField", {"text" \[Rule] "Initial dialog text"}, 
              Name \[Rule] "dialogTextField"], 
            Widget["Button", {"text" \[Rule] "Done", 
                BindEvent["action", InvokeMethod[{"myDialog", "dispose"}]]}], 
            InvokeMethod["center"]}, Name \[Rule] "myDialog"], 
        Widget["Button", {"text" \[Rule] "Run Modal Dialog", 
            BindEvent["action", 
              Script[SetPropertyValue[{"dialogTextField", "text"}, 
                  PropertyValue[{"appTextField", "text"}]]; 
                InvokeMethod[{"myDialog", "show"}]]]}], 
        BindEvent[{"myDialog", "windowClosed"}, 
          Script[\(SetPropertyValue[{"appTextField", "text"}, 
                PropertyValue[{"dialogTextField", "text"}]];\)]]}, 
      Name \[Rule] "myFrame"]\)], "Output",
  CellLabel->"Out[4]="]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Subsection"],

Cell["\<\
This example illustrates how to use modal dialogs initiated from another \
window, optionally setting up property values on widgets in the modal dialog, \
and, when the modal dialog is closed, retrieving values from the widgets in \
the modal dialog.  \
\>", "Text"],

Cell[TextData[{
  StyleBox["NOTE",
    FontWeight->"Bold"],
  ": This modal dialog will be modal to other user interface definitions, but \
 not modal to interactions with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " or the kernel. Modal interactions with the kernel are determined by using \
 ",
  StyleBox["GUI", "MR"],
  StyleBox["Run", "Output"],
  " or ",
  StyleBox["GUIRunModal", "Output"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(SimpleDialogApp[];\)\)], "Input",
  CellLabel->"In[3]:="]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
AutoGeneratedPackage->None,
Saveable->False,
WindowSize->{505, 551},
WindowMargins->{{80, Automatic}, {Automatic, 24}},
Magnification->1,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 109, 4, 91, "Section"],

Cell[CellGroupData[{
Cell[1910, 61, 30, 0, 39, "SubsectionIcon"],
Cell[1943, 63, 105, 3, 70, "Input",
  InitializationCell->True],
Cell[2051, 68, 158, 4, 70, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2234, 76, 39, 0, 70, "SubsubsectionIcon"],

Cell[CellGroupData[{
Cell[2298, 80, 170, 4, 70, "Input"],
Cell[2471, 86, 1130, 21, 70, "Output"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3662, 114, 29, 0, 39, "Subsection"],
Cell[3694, 116, 276, 5, 59, "Text"],
Cell[3973, 123, 429, 14, 61, "Text"],
Cell[4405, 139, 79, 2, 29, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

