package System.Convert;

import com.wolfram.jlink.*;
import java.io.*;
import java.util.Date;
import jxl.*;
import jxl.write.*;
import jxl.write.Number;
import jxl.write.Boolean;

public class ExcelDump {

static KernelLink link = StdLink.getLink();
static LoopbackLink loop;

/* symbolic Exprs */
static Expr $Failed = new Expr(Expr.SYMBOL, "$Failed");
static Expr True    = new Expr(Expr.SYMBOL, "True");
static Expr False   = new Expr(Expr.SYMBOL, "False");
static Expr Null    = new Expr(Expr.SYMBOL, "Null");

static Workbook open (String fn) throws MathLinkException {
  Workbook workbook;
  try {
    File file = new File(fn);
    workbook = Workbook.getWorkbook(file);
  } catch (IOException e) {
    link.message("Import::fnfnd", fn);
    link.put($Failed);
    workbook = null;
  } catch (Exception e) {
    link.message("Import::fmterr", "XLS");
    link.put($Failed);
    workbook = null;
  }
  return workbook;
}

public static void read (String fn) throws MathLinkException {
  link.beginManual();
  
  Workbook workbook = open(fn);
  if (workbook==null) return;
  
  try {
    int num = workbook.getNumberOfSheets();
    
    loop = MathLinkFactory.createLoopbackLink();
    loop.putFunction("List", num);
    for(int i=0; i<num; i++) {
      if (link.wasInterrupted()) {
        workbook.close();
        return;
      }
      ReadSheet(workbook.getSheet(i)); 
    }
    link.transferExpression(loop);
    
  } catch (Exception e){
    link.message("Import::fmterr", "XLS");
    link.put($Failed);
  } finally {
    loop.close();
    workbook.close();
  }
}

static void ReadSheet(Sheet sheet) throws MathLinkException {
  int num = sheet.getRows();
  
  loop.putFunction("List", num);
  for(int i=0; i<num; i++)
    ReadRow(sheet.getRow(i));
}

static void ReadRow(Cell[] row) throws MathLinkException {
  int num = row.length;
  
  loop.putFunction("List", num);
  for(int i=0; i<num; i++)
    ReadCell(row[i]);
}

static void ReadCell(Cell cell) throws MathLinkException {
  CellType type = cell.getType();
  
  if (type==CellType.NUMBER  || type==CellType.NUMBER_FORMULA){
    NumberCell c = (NumberCell) cell;
    loop.put(c.getValue());
  } else if (type==CellType.BOOLEAN || type==CellType.BOOLEAN_FORMULA) {
    BooleanCell c = (BooleanCell) cell;
    loop.put(c.getValue());
  } else if (type==CellType.DATE || type==CellType.DATE_FORMULA) {
    DateCell c = (DateCell) cell;
    Date date = c.getDate();
    
    /* ToDate[FromDate[d]] fixes any rollovers caused by TimezoneOffset */
    loop.putFunction("ToDate", 1);
    loop.putFunction("FromDate", 1);
    loop.putFunction("List", 6); 
      loop.put(date.getYear()+1900);
      loop.put(date.getMonth()+1);
      loop.put(date.getDate());
      loop.put(date.getHours()+date.getTimezoneOffset()/60);
      loop.put(date.getMinutes());
      loop.put(date.getSeconds());
  } else if (type==CellType.EMPTY) {
    loop.putSymbol("Null");
  } else if (type==CellType.ERROR || type==CellType.FORMULA_ERROR) {
    loop.putSymbol("$Failed");
  } else { /* LABEL, STRING_FORMULA */
    loop.put(cell.getContents());
  } 
}

public static Expr write (String fn, Expr[][][] data) 
    throws MathLinkException {
  try {
    
    File file = new File(fn);
    WritableWorkbook workbook = Workbook.createWorkbook(file);
    int num = data.length;
    
    for(int i=0; i<num; i++) {
      if (link.wasInterrupted()) {
        workbook.write();
        workbook.close();
        return $Failed;
      }
      WriteSheet(workbook.createSheet("Sheet"+(i+1), i), data[i]);
    }
      
    workbook.write();
    workbook.close();
    return new Expr(fn);
  } catch (IOException e) {
    link.message("Export::errfile", e.getMessage());
    return $Failed;
  } catch (WriteException e){
    link.message("Export::fmterr", "XLS");
    return $Failed;
  }
}

static void WriteSheet (WritableSheet sheet, Expr[][] data) 
    throws WriteException {
  int num = data.length;
  
  for(int i=0; i<num; i++)
    WriteRow(sheet, i, data[i]);
}

static void WriteRow (WritableSheet sheet, int row, Expr[] data) 
    throws WriteException {
  int num = data.length;
  
  for(int i=0; i<num; i++)
    WriteCell(sheet, row, i, data[i]);
}

static void WriteCell (WritableSheet sheet, int row, int col, Expr data) 
    throws WriteException {
/* N is applied to data before it is sent, so we can assume ints, 
   rationals, and numeric symbolic expresssions are reals */
  if (data.realQ() && !data.bigDecimalQ()) {
    try{
      Number number = new Number(col, row, data.asDouble());
      sheet.addCell(number);
    } catch (ExprFormatException e) {
      WriteLabel(sheet, row, col, data);
    }
  } else if (data.equals(True)) {
    Boolean bool = new Boolean(col, row, true);
    sheet.addCell(bool);
  } else if (data.equals(False)) {
    Boolean bool = new Boolean(col, row, false);
    sheet.addCell(bool);
  } else if (data.equals(Null)) {
    /* skip the cell */
  } else {
    WriteLabel(sheet, row, col, data);
  }
}

static void WriteLabel (WritableSheet sheet, int row, int col, Expr data)
    throws WriteException {
  String str; 
  try{
    str = data.asString();
  } catch (ExprFormatException e) {
    str = data.toString();
    /* chop off quote characters */
    str = str.substring(2, str.length()-1);
  }
  
  Label label = new Label(col, row, str);
  sheet.addCell(label);
}

}