(**************** Content-type: application/mathematica ****************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    508833,       8818]*)
(*NotebookOutlinePosition[    509718,       8849]*)
(*  CellTagsIndexPosition[    509674,       8845]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Book Pictures", "Title",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell[TextData[{
  "Programming in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "\n3rd Edition"
}], "Subtitle",
  Evaluatable->False,
  TextAlignment->Center,
  AspectRatioFixed->True],

Cell["by Roman E. Maeder", "Subsubtitle",
  TextAlignment->Center],

Cell[CellGroupData[{

Cell["Reference", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Summary", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Code for the Chapter opener pictures of ",
  StyleBox["Programming in Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notebook Version", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["2.0", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Copyright", "Subsubsection"],

Cell["\<\
\[Copyright] Copyright 2000, Roman E. Maeder

Permission is granted to distribute this file for any purpose except for \
inclusion in commercial software or program collections. This copyright \
notice must remain intact..\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["History", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Version 2.0 for ",
  StyleBox["Programming in Mathematica",
    FontSlant->"Italic"],
  ", 3rd ed., August 1996."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Keywords", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Illustrations, M\[ODoubleDot]bius, minimal surface, parametric \
surface, sphere, Van der Pol, fractal, Fourier, spiral, Barnsley, fern, \
random walk. Sierpinski.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Requirement", "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["<see below in \"Setup\">",
  FontFamily->"Times",
  FontWeight->"Plain"]], "Input",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version"
}], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["3.0", "Text",
  Evaluatable->False,
  AspectRatioFixed->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notes", "Subsubsection"],

Cell["\<\
Compared with the package BookPictures.m and the figures in the \
book some parameters have been changed to optimize display on the \
screen.\
\>", "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Setup", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["This section contains commands needed to load the packages.", "Text"],

Cell[CellGroupData[{

Cell["Read in the Packages", "Subsection",
  Evaluatable->False,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["Standard packages needed.", "Text",
  Evaluatable->False,
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
Needs[\"Graphics`ParametricPlot3D`\"]
Needs[\"Graphics`Shapes`\"]
Needs[\"Graphics`ArgColors`\"]
Needs[\"Graphics`Colors`\"]\
\>", "Input",
  InitializationCell->True],

Cell["Book packages needed.", "Text",
  InitializationCell->True],

Cell["\<\
Needs[\"ProgrammingInMathematica`ComplexMap`\"]
Needs[\"ProgrammingInMathematica`RungeKutta`\"]
Needs[\"ProgrammingInMathematica`RandomWalk`\"]
Needs[\"ProgrammingInMathematica`ChaosGame`\"]\
\>", "Input",
  InitializationCell->True],

Cell["Option settings.", "Text",
  InitializationCell->True],

Cell["\<\
SetOptions[Graphics3D, PlotRange -> All,Axes->None];
SetOptions[ParametricPlot3D, PlotRange -> All,Axes->None];\
\>", "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["The Pictures", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Note: some parameters have been changed relative to the package ",
  StyleBox["BookPictures.m", "Input"],
  " to optimize the pictures for computer screens."
}], "Text"],

Cell[CellGroupData[{

Cell["Chapter 1: M\[ODoubleDot]bius Transform", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(PolarMap[\ \((2  #\  - \ I)\)/\((#\  - \ 1\  + \ 
                0.1  I)\) &, \ {0.001, \ 5}, \ {0, \ 
          2  Pi}, \n\ \ \ \ \ \ \ \ \ \ Frame\  -> \ True, \ 
        Lines\  -> \ {20, \ 36}, \ PlotPoints\  -> \ 40\ ];\)\)], "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000fPP10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgMo000>OWifm_K`00V@00
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcool08@000?l08@000?l08@000?l08@000?l08@0002H000<100009`04
0BH00P4Y00@1;0000`40000W00817`0002H000<10000:0000`40000U0004
0@000BT000<10000;0000`40000V00040@000Ah0000N00X18P050@<000<1
000090001040004Z00030@0002P01@4W00040@000Ah0000S00040@000B/0
00<1000090001040004Z00030@0002P000@10001:0001040004N00009000
0`400@0/00030@0002<000@10001:`000`40000X00030@0102P00`4O0000
9@020BT000@100019@001040004X00040@000B/00P4Y00030@0001h0000V
00030@0002P00P4W0081:P020Bd000<10000:0020Ah0003o0240003o0240
003o0240003o0240003o0240003o0240000E0?l12@4300005@000`400@0;
00030@0000P000<1000020000`40000800030@0000P000<1000020000`40
000800030@0000@01`4900030@0000<01P4:00030@0000P000<100000`00
0`40000200030@0000P000<1000020000`40000400050@0000402P000`40
000900030@0000P000<1000020000`40000800040@000@L000<100002000
0`40000200030@000040000E00030@0000/000<10000:@000`40000H00@1
3P000`40000900<15`000`40000300030@0001X000<1000030000`40000Z
00030@0101P000<100000@0000h000<1000010000`40001?00<10`000`40
000<00030@0000`00`4C00030@00028000<10000>P000`40000F00030@00
0040000>00030@0000@000<10000C@020@H000<1000030000`40000?00<1
3`000`40000S00030@0003T000<100005`000`40000100001@050@030041
00<11@000`40001;008120000`40000<00030@0001800P4<00030@0002@0
00<10000>@000`40000G00030@000040000;00040@000@H00`5900812`00
0`40000;00030@0001@00P4900030@0002D000<10000>0000`40000F00<1
0`0000`000<100401P000`40001700813@000`40000;00030@0001H00P47
00030@0002D000<10000>0000`40000H00030@000040000=00811P000`40
001500813`000`40000;00030@0001P00P4400030@0002H000<10000=`00
0`40000I00030@000040000>00030@0000@000<10000@`020A4000<10000
2`000`40000J00040@000BX000<10000=@000`40000J00030@000040000E
00030@00048000<100004P000`40000:00030@0001/00`4Z00030@0003D0
00<100006P000`40000100005@000`40001100030@0001<000<100002P00
0`40000L0081:P000`40000d00030@0001/000<100000@0001D000<10000
?`020AH000<100002P000`40000K00040@000BT000<10000<`000`40000L
00030@000040000E00030@0003h000<100005P000`40000:00030@0001/0
00@100000P4W00030@00038000<100007@000`40000100005@000`40000m
00030@0001P000<100002@000`40000J00030@0000@000<1000090000`40
000b00030@0001d000<100000@0001D000<10000?0000`40000I00030@00
00T000<100006@000`40000600030@0002<000<10000<@000`40000N0003
0@000040000E00030@0003/000<100006P000`40000900030@0001T000<1
00001`020B<000<10000<0000`40000O00030@000040000E0081>P020Ad0
00<100002@000`40000H00030@0000X000<100008@000`40000^00030@00
01l00P4300005@000`40000h00030@0001h000<1000020000`40000H0003
0@0000/000<1000080000`40000^00030@00020000<100000@0001D000<1
0000=`000`40000O00030@0000P000<100005`000`40000=00030@0001l0
00<10000;@000`40000Q00030@000040000E00030@0003H000<100008000
0`40000800030@0001L000<100003P000`40000N00030@0002`000<10000
8P000`40000100005@000`40000e00030@00024000<1000020000`40000F
00030@0000l000<100007P000`40000[00030@0002<000<100000@0001D0
00<10000=@000`40000R00030@0000L000<100005P000`40000@00030@00
01d000<10000:`000`40000S00030@000040000E00030@0003@000<10000
8`000`40000700030@0001D000<100004P000`40000L00030@0002X000<1
000090000`40000100005@000`40000d00030@0002<000<100001`000`40
000E00030@0001<000<100006@040BX000<100009@000`40000100005@00
0`40000c00030@0002@000<100001`000`40000D00030@0001@000<10000
3`0:0@8000<100402@4O00030@0002H000<100000@0001D000<10000<P00
0`40000V00030@0000H000<1000050000`40000E00030@0000/00`4<0003
0@0000T00`4L00030@0002H000<100000@0001D000<10000<P000`40000V
00030@0000H000<100004`000`40000G00030@0000L00`4?00030@0000`0
104G00030@0002L000<100000@0001D00P4b00030@0002L000<100001P00
0`40000C00030@0001L000<1000010030A8000<1000040030A<000<10000
9`020@<0000E00030@00030000<10000:@000`40000500030@00018000<1
00006@000`4000030AD000<100004`020A0000<10000:@000`4000010000
5@000`40000`00030@0002T000<100001@000`40000B00030@0001X00P4H
00030@0001D00P4>00030@0002T000<100000@0001D000<10000;`000`40
000Z00030@0000<0404700030@0001T00P4I00030@0001L00P4;00030@00
02X000<100000@0001D000<10000;`000`40000[00D10P000`40000;00<1
0`000`40000H00810P000`40000F00030@0001T000<100001`000`40000[
00030@000040000E00030@0002h000<10000:`020@H000<100003P040AT0
00<100000P000`40000E00030@0001/00P4600030@0002`000<100000@00
01D000<10000;P000`40000X00<100<00@001@000`40000A00@15@000`40
000300030@0001D000<100007@000`40000300030@0002`000<100000@00
01D000<10000;@000`40000W00811@000`40000300030@00010000<10000
0P020A400P4700030@0001@000<100007P020@8000<10000;@000`400001
00005@000`40000]00030@0002D00P4700030@0000<000<1000040000`40
000400813P000`40000700030@0001@000<1000080020C0000<100000@00
01D000<10000;@000`40000S00812@000`40000300030@00010000<10000
1P000`40000:00030@0000T000<100004`000`40000P0081<0000`400001
00005@000`40000/00030@0002800P4<00030@00008000<100003`000`40
000800030@0000L00P4<00030@0001<000<100007`001040004_00030@00
0040000E0081;@000`40000Q00030@0000`000<100000P000`40000?0003
0@0000T00P4600030@0000`000<100004`000`40000O00050@000040;@02
0@<0000E00030@0002/000<100008@000`40000=00030@00008000<10000
3`000`40000;00030@00008000<100003P000`40000B00030@0001h000<1
00000`000`40000[00030@000040000E00030@0002/000<1000080000`40
000?00050@0000404@000`40000<00040@000A4000<100004P000`40000M
00030@0000D000<10000:P000`40000100005@000`40000Z00030@000200
00<1000040001@400001010000<100003P000`400@0A00030@00014000<1
00007@000`40000700030@0002T000<100000@0001D000<10000:P000`40
000O00030@00014000D100000@0@00030@0000l000<100004@000`40000@
00030@0001`000<100002@000`40000X00030@000040000E00030@0002X0
00<100007P000`40000C00040@000A0000<100003P0010400@4A00030@00
010000<1000070000`40000900030@0002P000<100000@0001D000<10000
:@000`40000N00030@0001@000@1000140000`40000=00030@00008000<1
00003P001040000:0@D000<100006`000`40000;00030@0002L000<10000
0@0001D000<100002`0G0@L000<100007@000`40000E00040@000A0000<1
000030000`40000400030@0000/01P4:00H170000`40000=00030@0002H0
00<100000@0001D000<100000`080AL0204N00030@0001L000<100403`00
0`40000=00030@0000D000<100001`030@<000<100003P000`400@020AP0
00<100003`000`40000U00030@000040000;00@11P060BH0104J00030@00
01P000<100401`050@<000<1000030000`40000700030@0000<00`460003
0@0000h000<100000P020AD000<100004@000`40000T00030@000040000<
00030@0000H000<10000:@00104000030AH000<100006@000`400@070@D0
1`4:00030@0000P000<100000P000`40000700030@0000h000<100001002
0A8000<100004P000`40000T00030@000040000500D10`000`40000500<1
:@000`40000400<14`000`40000J00813`00104000030@H000<100002P00
10400@4:00030@0000d000<100001`020@l000<1000050000`40000Q00<1
0`0000d000<100001@000`40000Y00030@0000L00`4?00030@0001P01@4?
00030@0000@00`4300030@0000X00P4<00030@0000d000<100002@020@d0
00<1000050000`40000S00030@000040000>00030@0000@000<10000:000
0`40000;00<12`000`40000G00810`020@l000<100001`030@`000<10040
30000`40000=00030@0000/00P4:00030@0001H000<100008P000`400001
00002`001040004600030@0002P000<100003P030@P000<100005P000`40
000400030@0000d000<100002@020@T00P4300030@0000T000<100003000
0`40000>00030@0000H000<1000060000`40000Q00030@000040000<0081
1`000`40000X00030@0001400`4400030@0001D00P4700030@0000`000<1
00002@001040004700030@0000<000<100002@000`40000<00030@0000l0
00<1000010000`40000J00030@00020000<100000@0001D000<10000:000
0`40000D00<100<00@0050020@T000<1000030000`40000900050@000040
1@000`40000500030@0000T000<100002`000`40000@00030@00008000<1
00006`000`40000P00030@000040000E00030@0002P000<100005`030A<0
00<100002@020@d000<1000020000`40000300810P000`40000600030@00
00D02P4700030@00018000@100017`000`40000O00030@000040000E0003
0@0002P000<100005`000`4000020A0000<100002P020@d000<100002000
0`40000500812P00104000030@@000<100000`050@8000<100004`020B00
00<100007`000`40000100005@000`40000X00030@0001L000<100000P02
0@d000<100002`020@d000<100001`000`40000600812P040@L000<10000
20030AD00P4Q00030@0001h000<100000@0001D000<10000:0000`40000F
00030@0000D000<100002@000`40000<00030@0100`000<100001`000`40
000500030@0100P00P400`01000800030@0000T00`4C00040@000B0000<1
00007P000`40000100005@000`40000X00030@0001H000<100001P020@P0
00<100003@000`400@0400h10`000`40000600040@000@D00P4300030@00
00L000<100002@000`4000020A0000<100000P000`40000N00030@0001d0
00<100000@0001D00P4Y00030@0001H000<1000020000`40000400030@00
00h000<10040104800030@0000<0104700030@00008000D100000@050003
0@0000L000<1000020000`40000300030@0000`000<1000010000`40000M
00030@0001`00P4300005@000`40000X00030@0001H000<100002@020@<0
00<100003`040@/000<100001P020@D000<1000010030@L000<100001P00
0`40000800030@0000@00P4;00030@0000D000<100007@000`40000M0003
0@000040000E00030@0002P000<100005@000`40000<008100<00@003`02
0@8000<100002@000`40000600040@010@<000<1000010020@P000<10040
204900030@0000H000<100001P020@T000<100007@000`40000L00030@00
0040000E0081:@000`40000E00030@0000h000<100003P000`400@020003
0@0000T000<100001@000`40000200<11P001040004500@11P000`400006
0@8000<1000020000`40000400030@0000X000<1000070000`40000L0003
0@000040000E0081:@000`40000D00030@0000h000@1004130020@8000D1
00000@0:00030@0000D000<100000`000`400@0400030@00008000<10000
0P4200030@0000D000<100001P030@/000<100000P000`40000;00030@00
01`000<1000070000`40000100005@000`400@0Y00030@0001<000<10000
3P00104000020@T000<100000P001@40000100X000<100001@000`400003
00040@000@8000<100000`030@D000<1000010000`400007008130020@03
004000h000<100006`000`40000L00030@000040000E00030@0102T000<1
00004`000`40000=00030@0000@000<100001@000`40000300030@000080
00<100001`000`40000400030@0000<000<100000P020@D00`4600030@00
00@000<100001`0010400@4<00030@0000h000<1000070000`40000K0003
0@000040000E00040@000BP000<100004`000`40000=00030@0000D000<1
00000`000`40000400030@00008000<100000`0<0@D000<100000`020@<0
00@10001100;0@L000<100000P000`40000800030@01010000<100006`00
0`40000K00030@000040000E00050@0000409`000`40000C00030@0000`0
00<100001`001@40000100L000<100000`050@@000<100000`000`400@02
0@03004000@000<100000`4400@10P000`40000400030@01008110000`40
000300030@0000H000@1000140000`40000K00030@0001/000<100000@00
01D000D100000@0W00030@0001<000<1000030000`40000800<120001040
00030@P000<100000`000`400002008110001@40000100@00`4500030@00
00@000<100000P040@L000<100000`020@@000<100003P000`40000J0003
0@0001/000<100000@0001D000<100000P000`40000U00030@00018000<1
00002`000`40000:008120001040004300030@0000D000<100000`000`40
000200060@010@010`0010400@020@8000@100001`400`01000700030@00
00H000D100000@0700030@0000d000<100006P000`40000K00030@000040
000E00810`000`40000U00030@00018000<100002`000`40000900040@00
0@L00`4400030@0000D000<100000`000`40000200040@0000<100<00@00
0P000`40000200D100<00@000`040@D000@100411`000`400@0800030@00
00h000<100006@000`40000J00810`0001D000<100000`000`40000U0003
0@00014000<100002P000`40000900030@00008000<1000010000`400004
00030@0000D000<100000`001@40000100@000<100000P4200040@010081
00<00@000`000`40000300030@0000810`001@40000100H00P4:00030@00
00d000<100006@000`40000K00030@000040000E00030@0000<000<10000
9@000`40000A00030@0000X000<100002@000`40000300030@0000800P47
00030@0000@02`4300040@00008100@00@000P4300`110030@D000<10000
0P001040004900030@0000d000<100006P000`40000201T10`0001D000<1
000010000`40000T00030@00014000<100002P000`40000800030@0000D0
00H10001004700P11@00104000030@05004000400P001`4000400@001043
00030@000080104300811P001040004400030@0000L000<100003@000`40
000B00`160000`40000100005@000`40000400030@0002@000<100004@00
0`40000:00030@0000P000<100001P020@8000<1000010030@D000<10000
0`001@40000100800P400`01000200<10P020@<020400`01000200<10P02
0@@00`4500030@0000L000<100003@000`40000;00L11`000`40000J0003
0@000040000E00030@0000D000<1000090000`40000@00030@0000X000<1
00001`000`40000600030@01008000<100000P020@8000<100000`000`40
000300050@0000400P0010400@4200050@010@001`4300040@0000<11000
0`40000200040@0000811`000`40000600030@0000d000<100001@060@h0
00<100006P000`40000100005@000`40000500030@0002@000<100004000
0`40000900030@0000P000<100001@001`40000100400`000`4000030003
0@0000<000<100000P001040004300030@0100<100<00@000P400`010@0<
0@8010400`01000300030@01008000<100001@000`40000600030@0000`0
204D00030@0001X000<100000@0001D000<100001P000`40000S00030@00
010000<100002@000`40000700030@0000H000<100000P020@03004100H0
00<100000P0;0@06004000401@4010010@0;0@0400410@800P4200030@00
008000<100000P000`40000400030@0000H000<100001P070A/000<10000
6P000`40000100005@000`40000700030@0002<000<100003`000`400009
00030@0000L000<100001@000`40000400812@040@03004000<000D10001
00050@03004000<100<00@400`4200X100<00@400P001040004200811000
0`40000400030@0000L000@10000104700030@0001P000<100006P000`40
000100005@000`40000800030@00028000<100003`000`40000900030@00
00H000<100001@000`40000500030@0000L00P4400030@00008000@10001
0P000`400@020@03004000H100<00@402@4200060@010@010`020@8000<1
00000P000`40000300030@0000L0104;00030@0001P000<100006P000`40
000100005@000`40000800030@00028000<100003`000`40000900030@00
00H000<100001@000`40000400<11P020@03004000@000D100000@020003
0@01008000<100400P400`010@0B0@06004000401@4200030@00008000<1
00000`000`40000200H13P000`40000H00030@0001X000<100000@0001D0
0P4:00030@00028000<100003P000`40000900030@0000H000<100001000
0`40000400050@0100400`020@@000<100000P0<0@0500400@005P401`01
000100400P001@40000100@000<100000`040@D000<1000030000`40000H
00030@0001T00P4300005@000`40000:00030@00024000<100003P000`40
000900030@0000H000<1000010000`40000400030@0100800`4600H10`00
1`4000400@00104200P120020@030041008100<00@000P401@0100010080
00<100000P070@P000<1000030000`40000H00030@0001X000<100000@00
01D000<100002`000`40000Q00030@0000h000<1000020000`4000050003
0@0000@000<1000010001040004200811`000`40000300040@000@8000H1
00400@040@03004100@12`030@09004100400@01008000H100000@040@D0
00<100001@000`40000<00030@0001P000<100006P000`40000100005@00
0`40000;00030@00024000<100003P000`40000800030@0000D000<10000
10000`40000300070@0000400@0200030@0000800`4500030@0000T100<0
0@400`400`010@0>00040@01008100<00@400P001@40004000<10`000`40
000300030@0000H000<100002`000`40000H00030@0001X000<100000@00
01D000<1000030000`40000Q00030@0000d000<1000020000`4000050003
0@0000@000<100000`001`40000100400P000`4000020@<000<100001P42
00040@0100/13`050@0500400@001@400`01000300030@0000<000<10000
1P000`40000;00030@0001L000<100006`000`40000100005@000`40000=
00030@00020000<100003P000`400003014100<00@0010000`4000020081
10020@D00`4200040@000@8000@100400`400`010@020@03004001000`40
10010@030@8000@1000110000`40000300030@0000H000<100002`000`40
000G00030@0001/000<100000@0001D000<100003P000`40000P00030@00
00d000@100000P4400030@0000D000<100000P050@8000<100000P000`40
000200030@0100@00`4300030@0001014`070@8000<100400`001@400001
00D000<100001P000`40000;00030@0001L000<100006`000`4000010000
5@000`40000?00030@00020000<1000030040@L000<1000010000`400003
00040@0000811@001@400001008000<100000P4200030@0000H100D00@01
00090A<01P401P0100400@<000D100000@0500030@0000H000<100002`00
0`40000G00030@0001/000<100000@0001D000<1000040020B0000<10000
2P020@03004000P000<1000010000`40000300030@0000800`4200810P00
0`40000200811@020@8000L10001004000/14`030@08004100400@020@80
00D100000@0500030@0000H000<100002P000`40000H00030@0001/000<1
00000@0000`00P4700030@00018000<100007P000`40000800030@000080
00<100001P000`40000400030@00008000<100000P00104000020@040040
0@@000<100400`020@06004000401P400`010@060AD01@40100100420004
0@000@<000<100000`000`40000500030@0000/000<100005`000`40000L
00030@000040000;00040@000@H000<100004`000`40000M00030@0000L0
00<100000`000`40000600030@0000@000<100000P000`40000200060@00
00400P400`01000200040@0000<10`000`4000020@0700400@0100080AD0
4@400`01000400030@0000D000<100002`000`40000G00030@0001`000<1
00000@0000/000@100011P000`40000D00030@0001d000<1000010020@H0
00<100001P000`40000400030@00008000<100000P001@40000100800P43
00030@0000800P4300@100<00@003P4E00D100H00@01004300030@0000P1
1`000`40000;00030@0001L000<1000070000`40000100002`0010400046
0?l12@4300002`001040004600030@0001L000<1000070001040004:0003
0@0000H000<100000`000`40000200050@0000400`000`4000020@8000<1
00000P001@40000100@01@400`0100060@03004100<14`060@0600400@01
0P001@40000100D000<100000P050@`000<100005`000`40000M00030@00
0040000;00040@000@H000<1000060000`40000L008130000`4000050003
0@0000@000D100000@0300040@000@<00P42008100<00@400P020@040040
00<10P050@03004000P14`070@05004000400P001@40000100D000<10000
1P030@X000<100005`000`40000M00030@000040000<00811`000`40000I
00816`000`400@0=00030@0000D000<100000`001@40000100<000@10001
0P001@400@0100800P4200040@0000<10P040@8000<100402P4C00@100<0
0@40104300050@0000401@000`40000500040@0000<11`000`40000G0003
0@0001d000<100000@0001D000<100006`000`40000G00050@0000403000
0`40000600030@00008000D100000@0300040@000@8000L100400@010080
0P4300<10P030@04004000<100<00@00204A00H100D00@0100020@030040
00<000<100000P000`40000600030@0000@00`4400030@0001H000<10000
7P000`40000100005@000`40000L00030@0001D000<100000`000`40000:
00030@0000D000<100000P001@40000100<000@100010P0010400@420003
0@0000810P000`4000030@8000<100400`4200/14@050@0600400@010P03
0@8000<100000`000`40000600030@0000L00P400`01000H00030@0001h0
00<100000@0001D000<100007@020A@000<100001@020@/000<100001@00
0`40000200050@0000400P001P4000400@800P402@01000100400@0200<1
0P030@04004000<100D00@4100060@h01@400`010@0200030@0100<000@1
00411@000`40000600030@0000X00P4I00030@0001h000<100000@0001D0
00<100007`000`40000@00030@0000P000<1000020000`40000500030@00
008000D100000@0200060@000@010P000`400@0200050@0000400P001P40
00400@8000<100400`42008100<00@40204;00<100D00@0100030@8000@1
00010`030@<000<100001@000`40000;00030@0100815@000`40000O0003
0@000040000E00030@00020000<100003P000`40000:00030@0000P000<1
00001@000`40000200040@000@8000H10041004200050@0100400P020@03
004100<00P4200<100@00@000`401@010@4000P12@050@0700400@010002
0@8000D100000@0300030@0100P000<100002`000`40000200814`000`40
000O00030@000040000E00030@0002400P4>00030@0000/000<100002000
0`40000400030@00008000<100003@401@01000100<00P4200030@000081
00@00@000`400`0100020@030041018100<00@400P401P010001008100<0
0@000`000`40000200811`000`40000;00030@0000D00P4@00030@000200
00<100000@0001D000<100008`000`40000:00030@0000d000<100002002
0@D000<100000P020@0600400@010P000`400@020@0400400@800P420081
0P020@<00P4200030@01008100<00@405`400`0100020@05004000401000
0`40000300030@0100H000<100002`000`40000700813P000`40000P0003
0@000040000E00819@020@T000<100003`020@X000<100000`000`400002
0@8000@100400`40200100400@010P000`4000030@0300410080104200<1
00<00@406`400`010@020@<00`4200030@00008000D100000@0400030@00
00/000<100002P020@/000<1000080020@<0000E00030@0002H00P470003
0@00014000<1000020000`40000200<10P001`4000400@000P400`010@02
0@03004000810P000`4000020@<00P4300810P000`400@020@03004101@1
0P020@0400410@8000@100000P4400030@0000<00P400`01000=00030@00
00`00P4900030@00024000<100000@0001D000<10000:0020@@000<10000
4`000`40000800810P020@<000L100010040008100<00@400`4010010002
0@8000@100400P4200@10P030@0500410@000`400`010@0B0@0700400040
0@0400810`000`40000600813@000`40000?00030@0000D000<100008P00
0`40000100005@000`40000Z00810P000`40000D00812P0010400@020@80
00<100000P4010010@030@04004100810P020@800P4300810`020@8000D1
004100030@03004101010P020@<00P4300810P000`400@0900030@0100/0
00<100004@020@@000<100008`000`40000100005@000`40000/00816@02
0@T000<100000P001`4000400@001@401P010@0100@10P020@0300410081
0P000`400@020@800P400`0100060@030040008100<00@402P400`010@02
0@800`4400030@0100P000D100000@0900030@0001@000D100000@0U0003
0@000040000E00030@0002d00`4I00811P0010400@4300050@000@002040
0`0100040@03004100800P4400<10P050@04004100@100<00@000P400`01
0@030@8000D1000100030@@00P4700030@0000H000<100000`000`400005
00030@0001H000<100409P000`40000100005@000`40000/00040@0000<1
60020@@000D100000@03008100@00@401`4010010@030@800P4200@100@0
0@000`42008100D00@000@0200050@010@000`4200P10`001P4000400@D0
0P400`01000500030@0000D000<1000010000`40000G00819P000`400001
00005@000`40000/00030@0000@0104F008100<00@0010020@<000<10040
1`400`0100020@800`43008110030@8000<100000P42008100<00@402`42
00050@0000400P040@<000<100000P4400030@00008000<100001`000`40
000200030@0001P000<100409@000`40000100005@000`40000/00030@00
00P0104D00D110020@80304200<100<00@400P400`0100050@8010400`01
0@030@03004100800P42008100<00@002@400`01000400<11`0010400@4;
00040@000AX000@100000P4S00030@000040000E00030@0002`000<10000
30020A<000@10000104200<100<00@403P4400<110030@8000<100000P43
00D10P020@800P4200030@00008000<100000P000`4000020@03004000L0
0P4=00<16P000`40000400030@00020000<100000@0001D000<10000:`00
0`40000?00P12P000`40000601810P060@8000@100000`4300<10P000`40
0@020@8000@100000P400`01000?0@<000<1000010040@d00P4J00030@00
00H000<100007`000`40000100005@020B`000<100005`060@@000<10000
2@0B0@H01@4200030@0000<11000104000020@0400410@800P4300030@00
008000<100000P000`40000400030@0000<10`000`40000:00040@000AT0
00<100001`000`40000M00810`0001D000<10000:`000`40000M010100<0
0@405@400`01000400<10P00104000020@800`4200810`030@03004000<0
00<100000P000`40000400030@0100L000<100001`020@@000<100005@00
0`40000900817P000`40000100005@000`40000[00030@00024000<10000
1`050@03004100X100<00@001P000`4000050@@00`4200810`020@800`43
00@100<00@4010000`40000200@120000`40000600030@0000D000<10000
4`000`40000<00030@0001/000<100000@0001D000<10000:`000`40000Q
00030@0000<0104200030@0000P100<00@400P0<0@@000<1004010420081
10000`400002008110000`40000<0@8000<1000020000`40000300812@00
0`40000A00030@0000h000<100006P000`40000100005@000`40000Z0003
0@0002<000<100400P4400810P060@030041008100<00@400P4800030@00
00800`4400030@01008000@100000P4300060@010@0110000`4000030003
0@0000D000<100001`00104000020@/000<1000040000`40000@00030@00
01T000<100000@0001D000<10000:P000`40000R00<11P00104000020@03
004100@100<00@000`400`010@0<0@8000<100000`000`40000200<10P04
0@<00P4400030@0000<000<100001@000`40000800<13P000`40000=0081
50000`40000H00030@000040000E00030@0002X000<100007P040@030040
00@00P4300050@010@001P400`010002008120000`40000400040@0000<1
10000`400003008110000`400@040@D000<100001@000`40000500@14@00
0`40000;00030@0001D000<100005`000`40000100005@000`40000Z0003
0@0001/00`4500030@00008000<100000P001P400@01008100H00@400@02
0@03004000811P000`40000500<10`001P4000400@@000<100400P000`40
000300D10P000`40000500030@0000<00P4400030@0000l000<100002@00
0`40000G00030@0001H000<100000@0001D000<10000:P000`40000G00@1
2@0010400@4400070@000@0100020@030041008000<100000P4300l11@03
0@<000@100410`000`400@0500030@000080404600030@0000l000<10000
1`020A/000<100005@000`40000100005@000`40000Z00030@0001401P4>
00030@0000<000X1000100400@010P020@8000<100400P4800030@0000D0
00<100000P030@D000<1000010020@@000<100001@000`40000500030@00
00T000<1000040000`40000400817@000`40000E00030@000040000E0003
0@0002X000<100002P070A800`4400040@000@8000D100400@0200030@01
008000@100000P4600030@0000D000<100000P4300070@0000400@040003
0@0000810P000`40000500030@0000D000<100002@000`40000@00030@00
00<000<100007P000`40000D00030@000040000E0081:`000`40000400H1
60001@400001008000D100000@0200030@01008000<100400P000`400@02
0@<01`4500D11@001040004300040@000@D00`4700030@0000D000<10000
2@000`40000@00040@0000818P000`40000B00810`0001D000<10000:P07
0A`00P4500810`001040004200050@000@000P4200040@0000811`060@80
00<100001P020@D00P4700<11@000`40000600030@0000T000<100004@03
0BD000<100004P000`40000100005@000`40000S00L100<00@007`000`40
000500<10P001040004200050@000@0010400`01000300811@000`400005
00030@0000@00`4700030@0000@000@100000P4300030@0000H000<10000
2P000`40000?0081:0000`40000A00030@000040000E00T12P0C0@P000<1
000070020@P000<100000P4300040@000@<00`4400030@0000<000<10000
0P000`40000600030@0000<10`000`40000300030@0100D000<100000`03
0@T000<100002P000`40000=00810P000`40000V00030@00010000<10000
0@0001D000<100001P0:0A/000<100006`000`40000700030@0000800`40
0`01000200D100<00@000`020@@01P4600@11P000`40000200050@000040
0`000`40000600@11P000`40000:00030@0000T0104400030@0002H000<1
000040000`40000100005@000`40000[00030@0001T00P4900030@000080
00@100001`4200040@000@D000<1000010000`400@060@03004000P000@1
00411@000`400@0900040@0000<10`000`40000:00030@0000@01@480003
0@0002L000<100003`000`40000100005@000`40000/00030@0001L000<1
00002@000`40000200030@00008000D100000@0300050@0000401@020@@0
00<1000020000`400006008120020@P000<100001@070@T000<10040104>
00030@0002L000<100003P000`40000100005@000`40000/00030@0001H0
00<100002@000`40000300030@00008000D100000@0300810`000`400004
00050@0000402P000`40000500030@0100P00P4800030@0000P000@10000
2`4C00030@0002L000<100003P000`40000100005@000`40000/00030@00
01@00P4;00030@0000<000<100000`000`40000200030@00008110000`40
000400<12`000`4000050@8000<100001@000`4000020@D000<100002@00
0`40000;00030@00014000<10000:0000`40000=00030@000040000;00@1
1P000`40000/00030@0001<000<100002`000`40000300030@0000<000<1
00000P001P4000400@@000<100001@050@L00`4800030@0000<000<10000
0`000`40000200030@0000T000<100002`000`40000B00030@0002P000<1
000030000`400001000030000`40000600030@0002d000<100004@000`40
000;00030@0000@000<100000`000`40000200060@000@011@000`400004
00030@000080204:00030@00008000<100001@001040004;00030@0000`0
00<100004P000`40000Y00030@0000/000<100000@0000d000<100001@03
0Bd000<100003`020@d000<1000010000`40000400030@00008000@10001
0P000`40000300810`000`40000:00030@0000T000@100412@030@/000<1
000030000`40000B00030@0002T000<100002@030@<0000=00030@0000D0
00<10000;P000`40000=00030@0000d000<1000010000`40000400030@00
008000@100010P000`400005008100<00@002`000`400009008130020@X0
00<100003@000`40000C00030@0002T000<100002P000`40000100003P00
0`40000400030@0002h000<1000030000`40000=00030@0000D000<10000
10000`40000300030@0100<000<100001P020@`000<100001`020@030040
00X000@100012@000`40000=00030@0001<000<10000:P000`4000090003
0@000040000;00040@000@H000<10000;`000`40000900813`000`400006
00030@0000@000<100000`000`400@0400030@0000D000@100412`000`40
000400810`000`40000800030@0000800P4700030@0000d000<100004`00
0`40000Z00030@0000T000<100000@0000`00P4700030@0002l000<10000
20000`40000?00030@0000H000<1000010000`40000300030@0100D000<1
00000`000`40000200<120000`4000040@H000<100001P000`4000050003
0@0000<000<100003@000`40000E00030@0002X000<1000020000`400001
00005@000`40000`00030@0000H000<100003`000`40000700030@0000@0
00<1000010020@H000<100000P000`40000500/12`000`40000400030@00
00L000<100000P000`40000=00030@0001D000<10000:`000`40000500<1
0`0001D000<10000<@000`40000300814@000`40000700030@0000D000<1
000010020@L000@1000140000`40000;00030@0000<000<100002@020@03
004000l000<100005@000`40000[00030@0000<00P4200030@000040000E
00030@00034000<100000P000`40000@00030@0000P000<100001@000`40
000500030@0000H00P4A00030@0000`000D100000@0>008140000`40000E
00030@0002`000<100000P4400030@000040000E00030@00038000@10001
4`000`40000800030@0000D000<100001@000`40000600<140000`40000=
00<13`0010400@4>00030@0001D000<10000;0030@H000<100000@0001D0
00<10000<`020A<000<100002@000`40000500030@0000D00P4700030@00
00813P000`40000<008140000`40000200812`000`40000F00030@0002/0
0`4700030@000040000E00030@0003<00P4C00030@0000T000<100001P00
0`40000400030@0100D000<100000`020@`000<100002P020@8000<10000
3@000`40000400812@000`40000F00030@0002T00P4200030@0000D000<1
00000@0001D00P4c00030@01018000<100002P000`40000600030@0000@0
00@100010`000`40000600812P000`400008008110000`40000<00030@00
00L00P4700030@0001L000<100009P020@D000<100000`020@<0000E0003
0@00034000D100000@0A00030@0000X000<100001P000`40000400040@00
0@8000<100002@040@H000<1000010040@L000<100002P000`40000:00<1
10000`40000G00030@0002@00P4700030@0000@000<100000@0001D000<1
0000<0000`40000300030@0000d000<100002P000`40000800030@0000<0
00L100000@0100l03@4;00030@0000T000<100003P020@8000<100005`00
0`40000R00812@000`40000400030@000040000E00030@0002h00P470003
0@0000`000<100002P000`40000800030@0000<000<100000P000`40000D
00030@00010000<100001`000`40000A00@160000`40000O00<130000`40
000300030@000040000E00030@0002d000<1000020000`40000;00030@00
00X000<1000020000`40000300030@00008100<00@0050000`40000@0003
0@0000H000<100004`000`4000030AD000<1000070030@l000<100000`00
0`40000100005@000`40000/00030@0000X00P4:00030@0000/000<10000
2@000`40000200030@0100@000<100004P000`40000A00030@0000@000<1
000050000`40000300<14P000`40000I00<14`000`40000200030@000040
000E00030@0002/000<100003@000`40000700030@0000/000<100002@00
0`40000200811P000`40000A00030@00018000<100000`000`40000C0003
0@0000L01P4<00030@0001D0104F00030@00008000<100000@0001D000<1
0000:P000`40000?00811P000`40000<00030@0000X000<100400P480081
4@000`40000B00030@00008000<1000050000`40000=00D11`000`40000>
00L16`001@40000100<0000E00030@0002T000<100004P020@@000<10000
30000`40000:00810P000`40000800813`000`40000C00040@010AH000<1
00004`0H0B8000D100000@0300005@000`40000X00030@0001D00P420003
0@0000d000<100001`020@050040004030000`40000<00030@0001<00P4H
00030@0001X000<10000<@001040004300005@000`40000W00030@0001P0
0P4@00030@0000@00`4400030@0100d00P4<00030@0001000`400`01000F
00030@0001/000<10000<@001040004300005@020BL000<100006P060@/0
00<10000104700030@0100l00P4:00030@0000h00P4500030@0001@000<1
00006`000`40000a00040@010@<0000E00030@0002D000<100006P000`40
000400h130020A400`4700030@0000/00`4700030@0001<000<100007000
0`40000b00030@0100<0000E00030@0002@000<100006`000`40000?0003
0@0000`00P4D00<110000`40000900812`000`40000A00030@0001`000<1
0000<`000`400@0300005@000`40000S00030@0001`000<100003`000`40
000=00030@0001D0404=00030@00010000<100007@000`40000c00030@01
00<0000E00030@00028000<100007@000`40000?00030@0000d00P4I0003
0@0001P000<100003`000`40000M00030@0003@00P4300005@000`40000P
00817`000`40000@00030@0000d000<1004060000`40000H00030@0000h0
00<100007P000`40000d00810`0001D000<100007`000`40000O00030@00
010000<100003@000`400@0H00030@0001T000<1000030000`40000N0003
0@0003D00P4300005@000`40000N00030@00020000<1000040000`40000=
00040@000AL000<100006P000`40000:00030@0001l000<10000=@020@<0
000E00030@0001d000<100008@000`40000A00030@0000`000D100000@0F
00030@0001X000<100002@000`40000P00030@0003H000<100000@0001D0
00<1000070000`40000Q00030@00018000<1000030000`40000200030@00
018000<1000070000`40000700030@00024000<10000=P000`4000010000
5@000`40000K00030@00028000<100004P000`40000<00030@0000<000<1
00004@000`40000M00030@0000D000<100008P000`40000f00030@000040
000E00816`000`40000S00030@0001<000<100002`000`40000400030@00
010000<100007@000`40000400030@00028000<10000=P020@<0000E0003
0@0001T000<100008`000`40000D00030@0000/000<100001@000`40000?
00030@0001h000<100000P000`40000S00030@0003L000<100000@0001D0
00<1000060000`40000T00030@0001@000<100002`000`40000600030@00
00d000<1000080001040004V00030@0003L000<100000@0001D000<10000
5`000`40000U00030@0001D000<100002P000`40000700813@000`40000P
00<19`000`40000g00030@000040000E00030@0001L000<100009@000`40
000E00030@0000X000<100002@000`40000:00030@0001l00`4W00030@00
03P000<100000@0001D000<100005P000`40000V00030@0001H000<10000
2@000`40000:00812P000`40000M00810`000`40000T00030@0003P000<1
00000@0001D000<100005@000`40000W00030@0001H000<100002@000`40
000<00811`000`40000L00811P000`40000R00030@0003T000<100000@00
01D000<1000050000`40000X00030@0001H000<100002@000`40000>00<1
10000`40000J008120000`40000R00030@0003T000<100000@0001D000<1
00004`000`40000Y00030@0001L000<1000020000`40000A00810P000`40
000H00812`000`40000Q00030@0003T000<100000@0000h000<100001000
0`40000B00030@0002T000<1000060000`40000800030@0001<01@4E00<1
3P000`40000O00030@0003X000<100000@0000h000<1000010000`40000A
00030@0002X000<100006@000`40000700030@0001D000<10000104;00H1
4@000`40000O00030@0003X000<100000@0000/01@4500030@00014000<1
0000:P000`40000I00030@0000L000<1000050000`40000500/160000`40
000M00030@0003/000<100000@0000/000@100011P030A0000<10000:`00
0`40000J00030@0000H000<1000050000`40000Y00030@0001`000<10000
>@030@<0000<00030@0100H000<100003`000`40000/00030@0001X000<1
00001P000`40000D00030@0002T000<100006`000`40000l00030@000040
000=00811P000`40000>00030@0002d000<100006`000`40000500030@00
01@000<10000:P000`40000I00030@0003d000<100000@0000h000<10000
10000`40000=00030@0002h000<100006`000`40000500030@0001<000<1
0000;0000`40000H00030@0003d000<100000@0001D000<1000030000`40
000_00030@0001`000<1000010000`40000C00030@0002d000<100005P00
0`40000n00030@000040000E00030@0000/000<10000<0000`40000M0003
0@0000<000<100004P000`40000^00030@0001D000<10000?`000`400001
00005@000`40000;00030@00030000<100007@000`40000300030@000180
00<10000;`000`40000D00030@0003l000<100000@0001D000<100002P00
0`40000a00030@0001h000<100000P000`40000B00030@00030000<10000
4P000`40001000030@000040000E00030@0000T000<10000<P000`40000O
00050@0000404`000`40000b00030@00010000<10000@@000`4000010000
5@000`40000800030@0003<000<1000080001040004C00030@00038000<1
00003`000`40001200030@000040000E00030@0000L000<10000=0000`40
000P00040@000A8000<10000=0000`40000>00030@00048000<100000@00
01D00P4700030@0003D000<100008@000`400@0B00030@0003D000<10000
30000`40001200810`0001D000<100001P000`40000e00030@0002800P4A
00030@0003L000<100002P000`40001400030@000040000E00030@0000D0
00<10000=P000`40000S008140000`40000g00030@0000T000<10000A@00
0`40000100005@000`40000400030@0000@000<10000:@000`4000040003
0@0002<000<100403P000`40000H00030@0001h000<100001`020B`000<1
000060000`40000100005@3o0@T10`000001
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{288, 218.75},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Chapter 2: Minimal Surface", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ParametricPlot3D[{r*Cos[phi]\  - \ \((r^2*Cos[2*phi])\)/
              2, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \(-\((r*
                  Sin[phi])\)\)\  - \ \((r^2*Sin[2*phi])\)/
              2, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \((4*r^\((3/2)\)*
                Cos[\((3*phi)\)/2])\)/
            3}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {r, \ 0.0001, \ 
          1}, \ {phi, \ 0, \ 4  Pi}, \ 
        PlotPoints\  -> \ {8, \ 60}];\)\)], "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003e000180P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgMo000>OWifm_K`00V@00
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6HcooD0002K0081F00009T00P400`010@1G0000UP030@<00P5G0000U002
0@H000<10040EP0009800P4800040@000ED0002?00<12P001040005E0000
S@020@d000D100000@1D0000RP030@l000D100000@1D0000R0020A8000<1
00000P000`40001A0000QP020A@000<100000`000`40001@0000P`030AH0
00<100000`000`40001@0000P@020AT000<1000010000`40001?0000OP03
0A/000<100001@000`40001>0000O0020Ah000<100001@000`40001>0000
NP020B4000<100001@000`40001=0000M`030B<000<100001P000`40001<
0000M@020BH000<100001P000`40001<0000LP030BP000<100001`000`40
001;0000L0020B/000<1000020000`40001:0000K@030Bd000<100002000
0`40001:0000J`020C0000<100002@000`4000190000J@020C8000<10000
2@000`4000190000IP030C@000<100002P000`4000180000I0020CL000<1
00002`000`4000170000H@030CT000<100002`000`4000170000G`020C`0
00<1000030000`4000160000G@020Ch000<100003@000`4000150000FP03
0D0000<100003@000`4000150000F0020D<000<100003P000`4000140000
E@030DD000<100003`000`4000130000D`020DP000<100003`000`400013
0000D@020DX000<1000040000`4000120000CP030D`000<100004@000`40
00110000C0020Dl000<100004@000`4000110000B@030E4000<100004P00
0`4000100000A`020E@000<100004P000`4000100000A@020EH000<10000
4`000`40000o0000@P030EP000<1000050000`40000n0000@0020E/000<1
000050000`40000n0000?@030Ed000<100005@000`40000m0000>`020F40
00<100005@000`40000l0000>0030F<000<100005@000`40000l0000=P02
0FH000<100005P000`40000k0000=0020FP000<100005`000`40000j0000
<@030FX000<100005`000`40000j0000;`020Fd000<1000060000`40000i
0000;0030Fl000<100006@000`40000h0000:P020FP0104600816P000`40
000h0000:0020FH010400c<a<`020@@00P400j@10@0I00030@0003L0000U
00<1I`020@06<c4c<C<a0P44008100BTWj@160000`40000g00008`020FP0
0P402c<1<C<a<c4c0C41008000@1Q`410j@00`40000F00030@0003H0000P
00<1J@002`4c<C<1<c4c<C<1008a00D10001X`020@03WjBO008160000`40
000e00007P020F/000`1CS=>0C<a<c4c<@43<@040@01Q`810j@00`6U0@0G
00030@0003D0000L0081K0003@4c<C<a0C4c<C<a<`400c4010400J<20@04
WjBOY08160000`40000d00006@030F`00P403DhcCS=>0C<a<c4c<@401342
0@03Q`4100BT00<1Y04060000`40000c00005`020Fh00101<C<a<c4c<@4a
<c4c<C<113420@08X`41WjBOY042Y0030@0001D000<10000<`0001D00P5_
000A0C=><dhcCS=>0C<a<c4c<@4013440@03Q`6T00:T00D1Y:FT0@0G0003
0@000380000E0081KP020@0?<c4c<C<a<c41<C<a<c4100Da10401Z<1Y9nT
0@BT00<100005@000`40000a00005@000`400@1/000B0Dh1<dhcCS=><`4a
<c4c<C<11C440@03Q`6T00:T00L1Y:FTYJ@101H000<10000<@0001D000@1
0001JP004`4cCP4c<C<a<c4c0C<a<c4c<@401C402`400@6S0JBOY9l100BT
00<100005@000`40000`000050000`40000200030@0006H001@1CU=>0C=>
<dhcCS<1<C<a<c4c0@@a1@400hL1Y003Y0070JFTYJBU0@0G00030@0002l0
000D00030@0000<000<10000I0005@4cCS<1<C<a<c4c<C<1<c4c<C<a0@04
<@030C41008100NS0JBOY9l100JT00<1000050000`40000_000050000`40
000400030@00068001H1CU=>D`5><dhcCS=><`4a<c4c<C<113450@03Qj@1
00>T00L1YJBUY:FT00815P000`40000^000050000`40000500030@000600
01H1<dhcCS<1<C<a<c4c<C<1<c4c<C<11C400`4a0@020@07XhL1WjBO0@06
Y0815P000`40000^000050000`40000600030@0005l001H1DdiCCU<1CS=>
<dhcCP4c<C<a<c411C450@03Qj@100>T00X1YJBUY:FT0JD15P000`40000]
000050000`40000700030@0005d001L1CS=><dhc0C4c<C<a<c41<C<a<c4c
0@05<@030C41008100RSQ`6OY9nT0@FT00@1YJ015P000`40000/00005000
0`40000800030@0005/00101DdiCCU=>D`5><dhcCS=>2045<@D100>70@40
0P42Y0070JBUY:FT0@02Y@030@0001@000<10000;00001@000<100002@00
0`40001I000?0DhcCS=><dhc0C4c<C<a00<11S<20@@a00<1<@401@400jBU
0@020@FT00D1YJ2U0@0F00030@0002/0000C00030@0000X000<10000F000
4`5CCU=>DdiCCU<1CS=><`4cD`401S<20@@a1P403J@1YJBUY06TYJBUY040
1:D00`40000D00030@0002X0000C00030@0000/000<10000EP003P5><dhc
CS=><dh1<c4c0P4013=><`46<`030C<1008a0P400c410@020@06S@6TYJBU
0P45Y0050J2UX0405P000`40000Z00004`000`40000<00030@0005@001D1
DdiCCU=>DdiCCP4cCP5C<e<cD`401S<02@4a<`4a0C41<@030@0>Y06UY:FT
0JD1Y:FTY@44Y@030@0001@000<10000:@0001<000<100003@000`40001B
000<0DhcCS=><dhcCS=>0`401ThcCS=>0@Hc00D1<C<a<`030@03<@410081
00Z=0JBUY:D1YJ@10j@01P6PYJ2U0AL000<10000:00001<000<100003P00
0`40001@008101A>DdiCCU=>DdiCCP4cDc=C<e<c0@Hc00D1<c4c<@020@03
<@4a00<100NT0JFTYJ@100>U00@1Y:D11JD00`40000D00030@0002P0000C
00030@0000l000<10000CP003@5C0DhcCS=><dhcCS<00P4024hcCS=><dh1
1S<01P4a<c4c<@8100<a0@400P402hd1Y:FTY@6UY:D100:T00P1X:FPYJ2U
0AH000<100009`0001<000<1000040000`40001=000G0Dh1CU=>DdiCCU=>
0Dh1<e<cDc=C<`401S<02P4c<C<a<`4a0C430@:T00D1Y:FT0@04Y@030JD1
00JU00<100005@000`40000V00004P000`40000B00030@0004/001P1CU<1
CS=><dhcCS<1CU<1CS=><dhcCP46<`060C4c<C<a0P400c410@020@0<SJ@1
YJBU0JFTYJBU0P402:2UX:FPYJ015P000`40000V00004P000`40000C0003
0@0004T001T1CVa>0DiCCU=>Ddh1CUA>0C=C<e<cDc<100Hc00L1<c4c<@4a
008100@a0@410Z@01P6TYJBU0@FU00<1YJD01ZD00`40000D00030@0002D0
000B00030@0001@000<10000A`006P5>DdiCCP4cCS=><`5>DdiC0DhcCS=>
<dh11S<02@4a<c4c0C41<@040@0=SJ@1YJBUY06TYJBUY0020@08YJ2UX:FP
Y@4F00030@0002D0000B00030@0001D000<10000AP006P5/CVa>K05CCU=>
0DiDCUA>0C=C<e<cDc<11S<01`4c<C<a0C400P4013410@42Y0060JBUY:D1
1JD20@RU00<1000050000`40000T00004P000`40000F00030@0004@001X1
DdiCCU=>0C=><`5>DdiCCU<1CS=><dhc0@Lc00T1<C<a<`4a0C400P406HL1
SJ@1YJBUY06TYJBUY06U0J2UX:FPYJ000P4F00030@0002<0000B00030@00
01L000<10000@P006`5/CVa>K4i/0E=>0DiDCUA>E4h1<e<cDc=C0@06<`08
0C4c<C<a0C420@04<@6T0@:T00H1Y:FTY@45Y@040JFU0@JU0P4F00030@00
02<0000B00030@0001P000<10000@000705CCU=>DdiCCP4c0DiCCU=>DdiC
0DhcCS=><`46<`070C<a<c4c0@02<@<101270HfT0JFTYJ@1Y:FTYJ@10ZD0
2P6UX:FPYJ013P4F00030@000280000A00030@0001X000<10000?P002P5/
CVa>K4i/CV`20@0ACUA>E4iDCUA>0C=C<e<cD`401S<01P4a<c4c0@<a0`40
2Z@1Y:@1Y:FTY@45Y@050JFUY@401JD0106UY@4F00030@000240000A0003
0@0001/000<10000?@00705>DdiCCU=>Ddh1CU=>DdiCCU=>D`5><dhcCS<4
0@<c00H1<c4c<@43<@D100>=Y0400P402JFT0JBUY:FT0@04Y@090JFPYJ01
3ZD101H000<100008@00014000<1000070000`40000k000:0Di/CVa>K4i/
CP8100mDCUA>E4iDCUA>0C=C<e<00`400e@cE0040@05<C<a<`400c450@05
Y041YBX00`45Y@030JFU00>U00@1YJD11:D00`40000D00030@000200000A
00030@0001d000<10000>@002`5>DdiCCU=>DdiC008100e>DdiCCU=>DdiC
0Dhc008100=D<`401S<20@04<C<a0@<a1@400hd10@04Y@8100FUY:FT0@05
Y@0:0J2U0JD>Y@jU0AH000<100007`00014000<100007P000`40000g000H
0Di/CVa>K4i/CV`1KE<1CUA>E4iDCUA>0`402diDCU@1E3=D<e@c008100@c
<C<113450@09Y06U:ZDZ0JT100>U00<1YJD01:D00`6U0@05Y@030@0001@0
00<100007`00014000<100007`000`40000f000P0E=>DdiCCU=>D`5CCU<1
DdiCCU=>DdiC0E@cE3=D<`46<`060C<1<c4113440@03Y:D100BU00L1YJD1
YJ@100NU0P401jD>Y@jU3P405P000`40000N00004@000`40000P00030@00
03@001P1K4i/CVa>K4i/0FeCKE<1CUA>E4iDCU@20@0=CUA>E4iD0E@cE3=D
0@03<`811C440@0>:Z@1YBZU:P6YYJT1Y@47Y@811jD00`40000D00030@00
01d0000A00030@00024000<10000<P008P5CCU=>DdiCCU=>0DiCCU<1DdiC
CU=>D`5D0E@cE3=D<`45<`040C<c<`811C440@03Y:D100BU00<1YJD00ZD2
0@RU00X1Y@jU3ZD>Y@h15@000`40000M000040000`40000S00030@000300
0P409di/CVa>K4i/CP5CKE=]D`5>E4iDCU@1KE<1CUA>E4iD0E@cE3=D0@04
<`030C4a00<a10403RZT0JDZYBX1ZJFYYJT12:D20@NU00<1000050000`40
000L000040000`40000S00030@00030001H1CP5>DdiCCU=>0DiCCU=>D`5C
CU=>0P402eA>E05D<e@cE3<100Dc00<1<c<00S<00`4a<@03<@@100>TY@40
1:D00`6UY@03Y@811jD20@093ZD>Y@jU3ZD101D000<100007000010000<1
000090000`40000^000Z0E=/0Fa>K4i/CP5CKE=]DfeCK@5DCP5CKE=]D`5>
E4iDCU@1E3=D<e@113<20@<a00<1<@400P403BZT0JDZYBX1ZJFYYJT00P46
Y@040JJU0@RU00<100004`000`40000K000040000`40000U00030@0002`0
02D1CVa>K05CCU=>D`5CCU=>DdiCCP5>0DiDCUA>E05D<e@cE3<100Dc00<1
<c<00S<20@<a1@400jBU0@03Y@030JFU00BU00<1Y@401JD03@69YHT13ZD>
Y@jU3P405P000`40000J000040000`40000V00030@0002X001D1DfaCK5<1
CVa>K05]DfeCKE=]Dfd00P405E=]DfeCKE=]0EA>E4iD0E@cE3=D0@04<`81
0c400`4a0@030@0@Y06U:ZD1YJVUZJD1YJJU0@BU00D1YZFV0@08Y@030@00
01<000<100006P00010000<100009`000`40000Y000V0Fa>K4i/CP5>D`5C
CU=>DdiCCU=>0DiDCUA>E4iDCP4cE3=D<`45<`030C<c008c00<1<`400S44
0@04Y@6U0@>U00<1YJD00jD00`6UY@02Y@0C0JFUY@69YHVU0JD>Y@jU3ZD>
0@0E00030@0001T0000@00030@0002P000<100009`005@5/DfaCK5=/0F`1
KE=]DfeCKE=]D`020@0EKE=]DfeCKE=]0EA>E4iD0E@cE3<100Dc00<1<`40
0S440@0CY06T0JDZY@6UZJFYY@6UYZFV0@03Y@060JJUYZD12:D00`40000D
00030@0001P0000?00030@0002X000<100009@002P5/CVa>K4i/CV`20@0L
CU=>DdiCCU=>D`5]0EA>E4iDCUA>0C=D<e@c0@@c00<1<c<00c<01@4c<@4a
008100Ha0JD1Y@43Y@030JFU00>U00<1YJD00jD04`6UY@69YHVUR@4>Y@jU
3ZD>Y@405@000`40000H00003`000`40000[00030@0002@002d1DfaCK5=/
DfaC0E=]DfeCKE=]Dfd1KE<1DfeCKE=]Dfd1E4iDCU@1E3=D<`4013<0104c
<c<60@0DY06T0JDZY@6UZJFYY@6UYZFVYJH20@08YJJUYZFVY@47Y@815@00
0`40000G00003`000`40000/00030@00028000X1CVa>K4i/CVa>0P406e=>
DdiCCU=>D`5]Dfd1E4iDCUA>E4h1<e@cE0070@@c00@1<C<a0P401c410@6U
0JD00`400jD1Y@04Y@030JFU00BU0P404JF9YHVURJD1Y@jU3ZD>0HT101H0
00<100005P0000l000<10000;@000`40000P000U0E=/DfaCK5=/Df`1K@5]
DfeCKE=]0FeCKE<1DfeCKE=]Dfd1E0030@06E05DDeAC0P43<`030C<c008c
1@401Z@10@6UZ@8101NUZJFYY@6UYZFVYJJU0JFVYJJUYZFV0@05Y@040JD>
0AD000<100005P0000l000<10000;P000`40000N000T0Di/CVa>K4i/CV`1
K5<1CU=>DdiCCP5CKE=]D`5>E4iDCUA>0P4035ACE5<1<e@cE04d0@8c00D1
<C<a<`070@05:P4ZYBX00P43Y@030JFU00JU0P404HVURJF9YHVU0JD>Y@6U
RJD101H000<100005@0000l000<10000;`000`40000M000S0FaCK5=/DfaC
K05]DfeC0E=]DfeC0E=]DfeCK@5]DfeCKE<00P45E00;0EACE5<1<cP1<`40
13<20@0<<@41Y@6U0JFYY@6U0P405JT1YZFVYJJUYP6V0JJUYZFVYJJU0@03
Y@060@jU3ZD15P000`40000D00003`000`40000`00030@0001/003@1K4i/
CVa>K4i/0FaCK5=/0E=>Ddh1DfeCKE=]D`5>E4iDCP5C0E=DDeAC0C=D<e@1
=3<d0P40134c<C<50@0;:P4Z0BZU:P6VYJH00P47Y@0F0HjV0JF9YHVURJF9
0@h1RJF9YHVU0AD000<10000500000h000<10000<P000`40000I000R0FaC
K5=/DfaCK5<1DfeCKE=]0FeC0E=]DfeCKE=]0FeCK@8100=DL@401E@02`5D
DeAC0C<h<cP100@c0P40;C410JD1Y@6UZJD1YJVUZ@6VYJJUYZFV0JJU0JFV
YJJUYZFV0JD1Y@jU3ZD>0@0F00030@0001<0000>00030@0003<000<10000
6000>`5>K4i/CVa>K4h1DfaCK5=/D`5>D`5]DfeCKE=]Dfd1E05]DfeCK@5D
DeAC0C=D<e@1=3<d<`4a<c4c00D100`Z0BX1:ZDZ0JJUYZD20@JU01L1SZJ>
0HVURJF9YHVU0JF9YHVURJF90@0E00030@0001<0000>00030@0003@000<1
00005P00505CK5=/DfaCK5<1DfeCKE=]DfeC0P402VeCKE=]DfeCKE<20@07
LEAaE75D0@05E0090E=DD`4c>3<h00810c<20@0^<@41Y@6U0JFYY@6UZJFY
0JT1YZFVY@6UYZFV0JJUYZFVYJH1YP6U3ZD>Y@jU0AH000<100004P0000h0
00<10000=@000`40000D000h0Di/CVa>K4i/CV`1K5=/DfaCK5=/0FeCKE=]
DfeCKE=]0FeCKE=]Dfd1E5=DDe@1E3=D0C@c=3<20@05<c4c0C400`4042X1
0JDZYBX1YZFV0JJUYP43Y@0I0JJ>YXjV0JF9YHVUR@690HVURJF9YHVU0@0F
00030@000140000>00030@0003H000<100004P008@5CK5=/DfaCK5=/0FeC
KE=]DfeCK@5a0FeCKE=]DfeCK@020@08E75DLEAaE045E00=0E=DD`4c>3<h
0C@1<`030@04<@41Y@8102ZYYJT1ZJFYY@6UZJD1YJJU0JFVYJJU0JFVYJJU
0JFVY@4>Y@jU3ZD>Y@4E00030@000140000>00030@0003L000<100004@00
?@5/CVa>K4i/CV`1K5=/DfaCK5=/D`5C0E=]DfeCKE=]D`5C0E=]DfeCK@5D
DeACE05D<e@1=3<d<`4c0C400P401C410@4Z008100jU:ZD1YJJUYP6VYJJU
0@:U01X1YXjVSZJ>0HVURJD1YHVU0JF9YHVURJF90AD00P4B00003P000`40
000h00030@0000l002`1K5=/DfaCK5=/D`5CKE=]DfeCKE<1K75/0E=]DfeC
KE<1K741LEAaE75D0@ED00`1DeAC0C<h<cP1RS<40@03<@4100<100jYYJT1
ZJFYY@6UZJFYY@8101^VYJJUYZFV0JJUYP6VYJJUYP6U3ZD>Y@jU3P404@03
0@0300400140000>00030@0003T000<100003@00?05/0@5>K4i/CVa>0E=/
DfaCK5=/Df`1KE=]D`5CKE=]D`5CKE=]0FeCKE=]0EACE5=D0E@cE04d<c@c
0@8c0`400c410@040@0[YBZU0JFVY@6UYZFVYJJU0HjVSZJ>YXjV0JD1YHVU
RJF90HVURJF9YHVU0@0>00<110000`40000@00003@000`40000k00030@00
00`002h1K6a/0E=/DfaC0E=]DfeCKE=]Dfd1LFaaK741KE=]Dfd1LFaaK05D
LEAaE74115@03@5CE5<1<cPc>04d<c@00`400c410@030@0?ZJFY0JVUZ@6Y
YJVUZJFY008101^UYZFVYJJU0JD1YJJUYZFVY@4>Y@jU3ZD>Y@402P030@L0
00<10000400000d000<10000>`000`40000;000b0Di/CVa>0Di/CP5CK5=/
DfaCK5=/D`5CKE=]Dfd1KE=]0FeCKE=]D`5CKE=]D`5CE5<40@07E04d<c@c
0@03<`8100<a0@401040;:DZY@6UYZD1YJJUYZFV0JH1YXjVSZJ>YXh1RJF9
YHVURJD1YHVURJF9YHT11`030@X000<10000400000d000<10000?0000`40
000:00030Fa/00A/0P409f`1KE=]DfeCKE=]D`5/LFaaK75/L@5]0G5/LFaa
K741LEAaE741E0020@04E05DF@8100Lc>3<h0C@c00@100<a0@401`40:JVU
Z@6YYJVUZJD1YJH1YZFVYJJU0JD1YJJUYZFVYJH1Y@jU3ZD>Y@h10080104>
00030@0000l0000=00030@0003d000<100002000;`5/CVa>K4i/CV`1K5=/
DfaCK5=/D`5CKE=]DfeCKE<1D`5CKE=]DfeC0E=]DfeC008100A]E6d10e@3
0@03=3<1008c0`400c41<@030@04ZJFYY@8102RV0JJUYZFVY@6>YXh1SZJ>
YXjV0JH1YHVURJF9YHVU0JF9YHVURJF90P4B00030@0000l0000=00030@00
03h000<100001P000`5/K008K0<1025CKE=]DfeCK@5aK75/LFaaK75/0Faa
K75/LFaaK05DLE@00P402g5DLE@1E5UD0CQD00<100DdR@41<@020@0:<@41
0JJYYP6VZ@8102NUZJFYYJT1YZFVY@6UYZFV0JJUYP6VYJJUYZFVY@4>Y@jU
3ZD>Y@404`000`40000?00003@000`40000o00030@0000D003L1CVa>K4i/
CVa>0E=/D`5CK5=/Df`1KE=]DfeCKE=]D`5/0E=]DfeCKE=]0FeC0EAa0FeD
KE@100=D00D1=e@g0@02<`<100<a0C400`40<:VUZ@6YYJT1YZFVYJH1YXjV
SZH1YXjV0JJ9YXT1RJF9YHVURJF90HVURJF9YHVU0A8000<100003`0000d0
00<10000@0000`40000300030Fa/00Q/0281KFa]K05CKE=]D`5/LFaaK75/
LFaa0G5/0FaaK75/LFaa0P4046eaK@5DLEAa0EUDF@5D>5@50@04<@41<@<1
00NVZJH1YZVV008102NYYJVU0JFVYJJUYP6V0JJUYZFVY@6UYZFVYJJUYP6U
3ZD>Y@jU3P404P000`40000?000030000`40001200030@0000800141K4i/
CVa>K4i/0FaCK5=/D`020@0UK5<1DfeCKE=]DfeCK@5aK741KE=]DfeCKE<1
E75DL@5]E6eD0@03E0040CMD=`H100<a0C400`40<JVU0JFYY@6>YP6VY@6>
YXjVSZJ>0Hh1RJJ9YXVV0JF9YHVURJF9Y@6URJF9YHVUR@404@000`40000?
000030000`40001300040@000@Y/03L1K6e/KFa]K6d1K@5aK75/LFaaK75/
0FaaK741LFaaK75/0FeaKG5]L@5aE741FEAI0E@hE04h00<100@a0@4a0P40
;j@1Z@6YYZT1ZJJY0JT1YZFVYJJUYZD1YJJUYZFVYJH1YZFVYJJUYZD13ZD>
Y@jU00<14@000`40000?000030000`400014000k0@01CVa>K4i/CVa>0E=/
DfaCK5=/Df`1KE=]DfeCKE=]D`5/LFaaK741KE=]Dfd1L@5aE75D0EA]E040
0e@01P4gE3L1<`@101Xa0@4a0HL1Y@6UZJD1SZJ>YP6VSZJ>YXjVSP8101JV
RJJ9YXVVR@69YHVURJF9YHT1RJF90P401:F9Y@4@00030@0000l0000<0003
0@0004D000<1K6`026`02`5]K6e/KFa]K6e/00<102Y/LFaaK75/0FaaK75/
LFaa0G5/L@5aKG41LFea0G5DL@5IE5T1E3QD0CP30@0A<@410C41Y06Y0JVV
0JJYYZT00P407ZFVYJJUYZD1SZH1YZFVYJJUYZD1YJJUYZFVYJH1Y@8100J9
YHVUR@4A00030@0000h0000<00030@0004@001L1CVa>K4i/CVa>K05/DfaC
K5=/DfaC0@03K081021]DfeCK@5aK75/LFaaK05CK@5aK75/0EAaE741KEA]
0@=D00<1E3L010400c410@020@03<@67008102JYYJT1YXjVSP6>0HjVSZJ>
0HVVR@69YXVVRJJ9YP6URJF9YHVUR@8100VURJF9YHVUR@4040000`40000>
000030000`40001400030Fa/00Q/03L1K6e/KFa]K6e/K@5aK75/L@5aK741
LFaaK75/LFaaK05/0FeaKG5]0FeaK@5DLE@1E5UD0CQD00H100Ha0@4a0J@2
0@08YZT1ZJJYYP42YP0J0JJUYZFV0JJ>YP6VYJJUYZFVYJH1YZFVYJH20@0;
R@69YHVURJF9Y@4040000`40000>000030000`400013000G0Fa>K4i/CVa>
K4h1DfaCK5=/DfaCK0401f`20@0MD`5/LFaaK75/LFaaK05/LFaaK741LEAa
0FeDK@400e@00`5D=`060@06<@41<@670P408ZVU0HjVSZH1YXjV0JJ>YP6V
RJJ9YP6VRJJ9YXVVR@69YHT20@0>YHVUR@69YHVURJF9Y@4?00030@0000h0
000;00030@0004@000<1K6`026`0<05]K6e/KFa]K6e/0FaaK75/LFaaK05/
LFaaK75/LFaaK05a0FeaKG5]L@5aKG41L@H100<hE0400`42<@050C<10C40
0P402:VVZ@6YYZT11:H0506UYP6VSZJ>YXh1YJJUYZFVYJJU0`4048VVRJJ9
YP6URJF9YHVUR@4?00030@0000h0000;00030@0004<001P1CVa>K4i/CVa>
K05/DfaCK5=/DfaCK049K0<101IaK75/LFaaK741LF`1K75/LF`1E75D0P40
1G41LEAa00L100@a0@4c0P4043410@6YYJJ>YP6VSZJ>YXh20@0@YXVVRJJ9
YXT1RJJ9YXVVR@8101>URJF9YHVURJD1YHVURJF9YHT100h000<100003P00
00/000<10000@P000`5/K009K00R0Fa]K6e/KFa]K6d1LFaaK75/LFaa0G5/
L@5aK75/LFaa0@Aa00H1KG5]LFd30@0:LG9aLP5bE05DFP<10c420@8c0`40
1`010JJYYP401ZH0406VSZJ>YXjVSZH1YZFVYJH20@0ER@69YXVVRJJ9YXT1
RJF9YHVURJD100h000<100003P0000/000<10000@P00605/CVa>K4i/CVa>
0E=/DfaCK5=/DfaC0@U/00D1K75/L@020@0MK75/LF`1K75/LF`1K75/L@5a
KG41LE@1E75DFE@010401S410@4c<@<100b?0Hl1SP6>YXjVSZH20@0=RJJ9
YXVVRJJ90HVVR@020@0HYXVVR@69YHVURJF9YHT1RJF9YHVURJD13@000`40
000>00002`000`40001100030Fa/00U/0281KFa]K6e/KFa]K05/LFaaK75/
LFaa0G5/LFaaK05/LF`11W405@5aKG5]0G5bLG81LP5bE79DFP4a0@03<@81
0S<30@0600400JT11JH03@6VS`6>YXjVSZJ>YXh00`406XVVRJJ9YP6VRJJ9
YXVVRJH1YHVURJF9YHT13P000`40000=00002`000`400011000H0Di/CVa>
K4i/CV`1K5=/DfaCK5=/Df`12F`02@5aK75/LFaaK0020@0=L@5aK75/LFaa
0G5/0@02L@09KG5]0EAa0G5D00H100<a0@400P400c4c0@020@0FYXnV0JJ>
YXjV0JJ>YP6VRJJ9YXVVR@8101fVRJJ9YXVVRJH1YHVURJF9YHT1RJF9YHVU
RJF90@0=00030@0000d0000;00030@0004000`49K00R0Fa]K6e/KFa]K6e/
0FaaK75/LFaaK05/LFaaK75/LFaa0@Ua00<1L@400W402@5aLW41L@5DLP03
0@03<@4a008a0`42<`<100F?006V0@03YP0<0JJ?YXnV0JJ>YXjV0P407hh1
RJJ9YXVVRJJ90HVVRJJ9YXVVR@69YHVURJF9Y@403@000`40000=00002`00
0`40001000030FaC00H100m/CP5CK5=/DfaCK5=/D`402V`02`5aK75/LFaa
K75/00<100U/LFaaK75/L@401740205]L@5aE05D1P401c410C<d0C<00`40
4ZH1YXl1SZH1YXjVSZJ>0HVVR@8102:VRJJ90HVVRJJ9YXVV0JF9YHVURJF9
Y@6URJF9YHVURJD130000`40000=00002P000`40001000030Fa/00M/1@40
8Ve/KFa]K6e/K@5aK75/LFaaK741LFaaK75/LFaaK741RW420@Ia0P44L@07
0G5b0G81LP040@<a0P4013Pc0C<40@04YXnVS`8100RVSjJ?YXnVS`<102B>
YXjVSZH1YXVVRJJ9YXVV0JJ9YXVVRJJ9YP6URJF9YHVUR@4<00030@0000d0
000:00030@00040000d1DfaCK5=/DfaCK5<1009/1P400e=/0@0:K00A0Faa
K75/LFaaK741LFaaK7400P4016aaK042L@030G5a009a00H1K@5D0E@40@03
<@4a008100<c=3<01@403HnVSjH1YXjVSZJ>YXh00P409jJ9YXVVRJJ90HVV
RJJ9YXVVR@69YHVURJF9YHT1RJF9YHVURJF90@0;00030@0000d0000:0003
0@00040000<1K6`026`02P5/LFaaK75/LF`50@0KK75/LFaaK741LFaaK75/
LFaaK05aRW6:LHYa008100Ea0HYaRP020@9a00D1LW41L@020@03<@4100<a
00D1>04c>0040@03SjJ?00<100J?YXnVSjH20@0YS`6>YXjVSZJ>YXh1RJJ9
YXVVRJH1YXVVRJJ9YXVV0JF9YHVURJF9Y@402`000`40000=00002P000`40
000o000=0FaCK5=/DfaCK5=/0@0;K0030Fa/00D10V`05`5aK75/LFaaK75/
L@5aK75/LFaaK74100Ia00D1LG41L@070@04<@4a0@8h00<1<c@00`402ZJ?
0HnVS`6>YXh20@0/YXVV0JJ9YXVVRJJ9YP6VRJJ9YXVVRJH1YHVURJF9YHVU
0JF9YHVURJF9Y@4:00030@0000d0000:00030@0003l000<1K6`02F`0505/
LFaaK75/LFaa0G5/LFaaK75/1@404faaK75/LFaaK05aRW6:LHYaRW400`40
1W6:LHYa0@9a00<1T8d00P400c410@03<@050CQJ0CP00`402J@10HnVSjH1
YP020@0^SjJ?YXnV0JJ>YXjVSZJ>0HVVRJJ9YXVVR@69YXVVRJJ9YXT1RJF9
YHVURJF90@/000<10000300000X000<10000?`00305/DfaCK5=/DfaC0@]/
00<1K6`026`00`5aK0060@0>LF`1K75/LFaaK75/L@42L@8117400`5a0@07
0@04<@4a0@<h00X1=3<1Q`6?YXnV0`40<JJ9YXVVRJJ90HVVRJJ9YXVVR@69
YXVVRJJ9YXT1RJF9YHVURJF90HVURJF9YHVUR@402P000`40000<00002P00
0`40000n00030Fa/00U/0201LFaaK75/LFaaK741LFaaK75/LFaaK05/RVb:
K8Y/RPD100f:LHYaRW6:0HYaRW6:008100EaRW41L@040@03<@4a008a00d1
FSQJ0EX1=06T0JJ?008103BV0JJ?YXnVSjJ?YP6VSZJ>YXjVSZH1YXVVRJJ9
YXVV0JJ9YXVVRJJ9YP6URJF9YHVURJD12P000`40000<00002@000`40000o
000=0E=/DfaCK5=/DfaC0@0;K0030Fa/00Q/00h1LFaaK75/LFaaK05/L@D1
00=aK0401g420@03L@4100L100Ha0@41>042>0040C<1Q`<103N:ShX1RJJ9
YXVVRJJ90HVVRJJ9YXVVR@69YXVVRJJ9YXT1RJF9YHVURJF9Y@6URJF9YHVU
RJD100T000<10000300000T000<10000?`000`5/K008K00[0FaaK75/LFaa
K75/0FaaK75/LFaaK741RVb:K8Y/RVb:K8X1RW6:LHYaRP030@0<RW6:LHYa
RW6:0I1a10400c41<@02<@070G81FSQJ>0020@0[Y041SjJ?YXl1SjJ?YXnV
SjJ?0HjVSZJ>YXjVSP69YXVVRJJ9YXT1RJJ9YP0@0@T000<10000300000T0
00<10000?P003@5/DfaCK5=/DfaCK0402f`00`5/K008K00I0FaaK75/LFaa
K75/0FaaK75/LFaaK05aRP050@9a00<1L@401`400c410@050@0J>041Qj@1
ShZ?RXl1YXVVRJJ9YXVV0JJ9YXTD0@0@3XT>R@h13XT>R@j93XT>0@T000<1
0000300000T000<10000?P000`5/K009K00e0FaaK75/LFaaK75/0FaaK75/
LFaaK741RVb:K8Y/RVb:K8X1RW6:LHYaRW6:0HYaRW6:LHX01`400c410@04
<@8100AJM`5110400j<10@0C0@0URJJ9YXT1RJJ9YXVVRJJ90HVVRJJ9YXVV
RJH1YHVURJF9YHVU0@0800030@0000`0000900030@0003d000h1DfaCK5=/
DfaCK5=/0@]/00<1K6`026`0805/LFaaK75/LFaa0G5/LFaaK75/LF`1LHYa
RW6:LHYa20400c41<@080@04>041Y08103R:ShZ?0Hn9ShV?RHn9S`6VRJJ9
YXVVRJH1YXVVRJJ9YXVV0@j93XT>R@j93XT1R@j93XT>R@j90@P000<10000
300000T000<10000?@000`5/K009K00c0G5/LFaaK75/LFaa0G5/LFaaK75/
LFaa0HY/RVb:K8Y/RV`1LHYaRW6:LHYaRP6:LHYa00X100<a0@400c4;0@0k
X`41YXnVS`6:YXZVRZJ:YXX1RJJ9YXVVRJJ90HVVRJJ9YXVVRJH1YXVVRJJ9
YXVV0JF9YHVURJF9Y@402@000`40000;00002@000`40000m000=0E=/DfaC
K5=/DfaC0@0;K0030Fa/00U/0141K75/LFaaK75/L@5aK75/L@0:0@04LHYa
RPT100<a0C400P400hX10@060@0lY06ORXn:S`6?RHn9ShV?RHl1YXVVRJJ9
YXVV0JJ9YXVVRJJ9YXT1R@j93XT>R@j90HT>R@j93XT>R@h120000`40000;
000020000`40000m00030Fa/00Y/0201LFaaK75/LFaaK741LFaaK75/LFaa
K05/RVb:K8Y/RPT100j:LHYaRP6:LHYaRW6:L@H100<a0@400c430@03SjL1
00D103bSY041SjH1YXZVRZJ:YXZVRP69YXVVRJJ9YXT1RJJ9YXVVRJJ9YP6V
RJJ9YXVVRJJ90HVURJF9YHVUR@4800030@0000/0000800030@0003d000d1
K5=/DfaCK5=/Df`100a/00<1K6`026`00`5aK0060@0ELFaa0G5/LFaaK75/
LFaa0HYaRW6:00/100Da0C41S`020@05RXn:0HX00P400jB70@020@0gRP69
ShV?RHn9ShV?0JJ9YXVVRJJ9YXT1RJJ9YXVVRJJ90HT>R@j93XT>R@h13XT>
R@j93XT>0@0800030@0000/0000800030@0003d000<1K6`02F`04P5/LFaa
K75/LFaaK05/LFaaK0T101Q/RVb:K8Y/RV`1LHYaRW6:LHYaRW41LHX90@04
<@410@@a00P1Si2?0Hl1RP@100>T0@401@40=:J:YXZVRZJ:0HVVRJJ9YXVV
RJH1YXVVRJJ9YXVV0JJ9YXVVRJJ9YXT1RJF9YHVURJF9Y@4700030@0000/0
000800030@0003`000h1DfaCK5=/DfaCK5=/0@Q/2@407VaaK75/L@5aK75/
LFaaK75/L@5aK75/LFaaK75/L@d1014a0@41<@4a0Hn:0HX1RHn9S`020@08
Q`670HX1RHl60@0^RHl1YXVVRJJ9YXVVR@69YXVVRJJ9YXVV0@j93XT>R@j9
3P4>R@j93XT>R@j90@L000<100002`0000P000<10000?0000`5/K009K004
0G5/L@H102E/RV`1K8Y/RVb:K8Y/RV`1K8Y/RVb:K8Y/RVb:0HYaRW6:LFI=
00T100=a0@400P401C41<C4100<a0P400i2?Y`020@03RZJ:008100>T0J<0
0`402:J:YXZVRZJ:1040:JJ9YXVVRJJ9YP6VRJJ9YXVVRJJ90HVVRJJ9YXVV
RJH1YHVURJF9YHVU00811P000`40000;000020000`40000l00090E=/DfaC
K5=/00L12F`07`5aK75/LFaaK75/L@5aK75/LFaaK75/LF`1K75/ITd00`40
0d`10@0:0@04<@4a0@8a0`400hX1RP020@05ShX1RHl00P400hNT0@070@08
RHn9ShV?0Hl40@0WRJJ9YXT1RJJ9YXVVRJJ9YP4>R@j93XT>R@j90HT>R@j9
3XT>R@h100H000<100002`0000P000<10000>`00105/K6`60@0]5F`E0HY/
RVb:K8Y/RVb:K05/RVb:K8Y/RVb:K05/RVb:K8Y/RVb:K8X1RTeV008100==
IP4030400c41<@020@8a00<1<@400`401hZ?0JJ:0HX00P401JBS0@6O0081
00>20H<00`402HZV0JJ9YXVVR@040@0SYP6VRJJ9YXVVRJJ90HVVRJJ9YXVV
RJH1YHVURJF9YHVUR@401`000`40000:000020000`40000k00@12F`00`5/
K00:K00J0G5/LFaaK75/LFaa0G5/LFaaK75/LFaa0FH20@08C4e<C@5=0D`;
0@03<@4100@a0P402HX1RXn:0HZ?RP030@05Qj@10H800`401H810H>200<1
00Z9ShV?RHn9ShV?104088VVRJJ9YXVV0@j93XT>R@j93XT1R@j93XT>R@j9
3XT11P000`40000:00001`000`40000l000]0F`EK1E/5F`EK1E/5@6:K8Y/
RVb:K8Y/RV`1K8Y/RVb:K8Y/RV`1K8Y/RVb:009/00UVK041CFI=ITd01040
14d10G480@04<@4a0@Da00/1ShX1RXn:0HZVRP020@03Y:<1008100>70@40
0P405:010H>P0JJ9YXVVRJJ9YXVV0JJ910407:J9YXVV0JJ9YXVVRJJ9YXT1
RJF9YHVURJF9Y@4600030@0000X0000700030@0003`000<1K6`02V`00`5/
K00:K00@0G5/LFaaK75/LFaa0G5/L@9/00==K4d00P401F`1CDa=008100A<
0@5<2`400c41<@020@Da00/1RXl1ShZ?0Hn:S`030@05Y8L10HL00`401881
Ph820@04P`68P`8100f?RHn9ShT1RHZ9RXV:00@101R90HT>R@j93XT>R@h1
3XT>R@j93XT>R@4600030@0000X0000700030@0003/002d15F`EK1E/5F`E
K1E/5@6:K8Y/RVb:K8Y/RV`1K8Y/RVb:K8Y/RVb:0HYVK6H00`401fI/IP5=
IP400Td20@03C@4100T100<a0C400P45<@8101>?RXl1ShZ?0JJ:0HX1Xj@1
Y06O00<100FJ0J22X0020@0ER0j83XP1RJJ90HVVRJJ9YXVVRJJ900@101FV
RJJ9YXVVR@69YHVURJF9YHVUR@401@000`40000:00001`000`40000k0003
0Fa/00Y/0P4<K0080G5/LFaaK742K006IV`1K4e/0P401Te/CFa=K08100=<
CD`00P400d`10@0;0@04<@4a0@Da0P404hZ?RP6:ShX1RXl1S`6TQ`670H80
0P407h81PP63PX>20H>8PhR3R06?0HZ9RXV:RHZ9RXV:R@400XT40@0AR@j9
3P4>R@j93XT>R@j93P401@000`40000:00001`000`40000k000=0AE/5F`E
K1E/5F`EK0020@0CRVb:K8Y/RVb:K8Y/RVb:K8Y/RP05K00=0FH10FaVK6I/
IVaV0@02C@040Dd1C@T100Pa0@41<@4a0@Ha00X1RP6:S`6?RXn:1@401j>T
0JBO0HL00P400h81VP020@03PZ01008101X>R0j83XP1RJJ9YXVVRJJ9YXVV
0JJ9YXVVR@@100fV0JF9YHVURJF9YHT100D000<100002P0000L000<10000
>`000`5/K00:K0030Fa/00]/00@1LFaa0V`01FI/IVaV008100U/CFa=K4e/
CF`00P401Td10D`1C0T100La0@41<@4a00811C402@6:S`6?RXl1S`030@0;
S`410JB70HNS0HL00`401881PX820@0GX8>P0HR3R8>80@j83XV:RHZ9RXV:
R@402XT30@0;3XT>R@j93XT>R@4010000`40000:00001`000`40000k000L
0AE/5F`EK1E/5F`EK05/RVb:K8Y/RVb:K8Y/0@Q/0P403V`1IVaVK6I/IV`1
K4e/0`400dd10@030@05<@410C400`401S41<@4a0@Da00D1ShX1RP040@0=
ShX10JJ:0J<1Y06OY0050@0YPP6JPP68X8RP0@j83XP>0@j93XT>RJJ9YXT1
RJJ9YXVVRJJ9YXVV0JD00`402:F9YHVURJD11@000`40000900001P000`40
000l00030Fa/00Y/00<1K6`02V`01`5VK6I/IV`00`402Va=K05/CFa=K4d2
0@04ITeV0@9=10400dd10@030@03<@4a00<100@a0C411S400`6:0@020@03
RXn:00<100F9RP6?R@020@04Y06SQ`@100FO0@41PP020@04Pj23X08100n3
R8<1R0j83XP>R0j9RP4038T00`69R@02R@@100B93XT11@000`4000090000
1P000`40000k000G0F`EK1E/5F`EK1E/5F`1K8Y/RVb:K8X016`0105/K6`3
0@I/00`1IVaVK6H1CFa=K043C@080DdaC@4a0C430@07<@410C41<@020@Da
0`4018X1RXl30@07ShZ?RP6:YP020@:T00@1Y06O0`40<9l10@6PR068X8RP
R0683P4>R@j93XT>R@j93P6VRJJ9YXVVRJJ9YP6URJF9YHVUR@<100>90@00
0`000`40000900001P000`40000k00030Fa/00]/00<1K6`02V`04@5V0@5/
CFa=K4e/CF`1K4e/008100E=ITeV0@04C@8100==0@401@402S41<@4a0C41
<@42<@X100Z:R@69RXV:R@690P401JBO0HNS008101j70H81PYl1X881Pj23
X8<1P`683XP>R0j83XP>R0h;R@030HV900V90P4400030@0000T000060003
0@0003/001<1K1E/5Fb9K1E/5F`EK05/RVb:00M/0`4;K00:0FI/0Fa=K4e/
0@A=00@1<Dda0P401c410@4a0C400`400c41<@040@<a0101RXn:0HZ?RXn:
0HZ?RXn:0P401Z@1Y06TW`81012O0@620H:P0J280HRPR:280`4098T>R@j9
3XT>R@h13XT>R@h1YXVVRJH1YHVURJF9YHVURJF90@@000<100002@0000H0
00<10000>`000`5/K00DK0<100i/0De/CFa=K4e/CFa=K0<100IVCFI=IP44
C@8100==0Dd01@400c41<@030@03<@4100811C409P69RXV:0HZ9RXV:0HZ9
RXV:R@6OY06T0J>70HNO0In20H81PZ220P406:23X8>P0@j83XP>R0j83XP1
R@j93XT>R@810XT00`69R@0:R@030@00008000<100002@0000H000<10000
>`003`5/5F`EK1E/5Fb9K8U/0@05K0<116`00`5/K00:K0080De/CFa=K044
C@070C5=<Dd1<@020@04<@41<@D100<a0@401S404P6?RXn:0HZ?RXn:0HZ?
RXn:S`810Z@20@05Wj@10HL00P403Yl1X881R:28X06PR:280`404hT>RJJ9
3XT>0@j93XT>R@j93XT00P403JF9YHVURJF9YHVUR@4010000`4000090000
1P000`40000j00030Fa/00]/00<1K6`00V`20@M/00/1CFa=K4e/CFa=K002
0@07C@5=ITeV0@05C@040Dd1C@@10S400`4a0@020@8a0P400c41<@05<@13
0HV:RHX1RXV:RHZ90HV:RHZ9RP6TWj@1XhNS0In70H:O0In20H:PPZ01X8>P
0@j80HP>R0j83XP1R@j93XT>R@j93P0>R@030@00008000<100002@0000D0
00<10000>`00404EK1E/5F`EK8U/RFb90F`30@U/00<1K6`01f`02@5/CVa>
0De/0@05C@050DdaCC400P400dda0@030@03<@4a008a00@1<@411C405@6:
ShZ?RP6:ShZ?RXl1ShZ?RXn:0@04Y0060JBO0HNO0P404H81PZ220HRPR:01
X04>R0j8008101L>R@j93XT1R@j93XT>R@j93XVURJF9Y@020@06RJJ9YHT1
1@000`40000800001@000`40000k00030Fa/00Y/0`4<K00B0De/CFa=K4e/
0Fa=K4e/0FH11Dd01P5=0Dd1C@@100Da0@4a0@04<@<11S406@6:RHZ9RP6:
RHZ9RXT1RHZ9RXV:R@6OY9l00P401J<10HNO00@100R2Wh81PZ22X08101n8
3XP>R0h13XP>R0h13XT>R@j93XT>R@h13XT>R@j900<10XT00`4000030003
0@0000P0000500030@0003/000/15F`EK8U/RFb9K0020@03K05/00e/00<1
K6`00f`20@07K4i/CVa>K0020@A=00D1CC5=<@030@06<DdaC@4a0P45<@81
1S405P6:ShZ?RXl1ShZ?RXn:0HZ?RXn:S`44Y0090Il10In70InP00810122
X881R:28X04>R0j83XP>0P406HT>R@693XT>R@j93XT>R@69YHVURJF9YHT0
104400030@0000P0000500030@0003/000<1K6`01F`30@=/00<1K6`036`0
4@5/CFa=0De/CFa=K4e/0Di=00810dd40@03<@4a00@a0`46<@030C4a00@a
01/1RHZ9RXV:R@69RXV:RHX1RXV:RHZ90InTWj@00`40=J@1W`6PQj01Wh:O
0J22X06P0@j83XP>R0j80HP>0@j93XT>R@j93XT>0@j93XT>R@j93XT>0081
10000`40000800001@000`40000k00060AE/RFb90P46K0030Fa/00a/01<1
K6a/0Di/CVa>K4i/0Fa=K4e/00@100Y=CTd1<DdaCC5=0P47<@030C4a00@a
01@1ShZ?RXn:S`6?RXn:ShX1RXn:S`<11:@02`6O0J01Qil1X9nP00<1012P
0J013XP>0@j83XP>R0j80`406HT>R@j93XT>R@j90HVURJF9YHVURJF9Y@40
10000`40000800001@000`40000j00040Fa/K0<12F`00`5/K00;K00@0F`1
0De/CFa=K4e/C@5=CP@100LaCC5=<Dd100Ha0P46<@811S404P69RXV:RHZ9
0HV:RHZ9RXT1R@8100R:RHX1Y9nTW`<100ZO0HL1Qj270HRP0`40:J28X8RP
0@j83XP>R0j83P4>R@j93XT>R@j93P4>R@j93XT>R@j93XT100@000<10000
200000D000<10000>P00105/0@4<K0030Fa/00]/0P402Va>K4i/CVa>K4h4
0@0@K4e/0Di=CTe>C@4aCC5=<@811c400`4c0@04<@0?0HZ?RXn:ShZ?0Hn:
ShZ?00@100J9ShV?R@44Y0050J@10J000P401J2OX9l100BP00l13XP>R068
3XP>R0j83XP00`405hT>R@j93XT>R@69YHVURJF9YHVURJD100@000<10000
200000D000<10000>P020@i/00<1K6`02f`02P5/CFa=K4e/CF`30@0=CTe>
CDh1CC5=<Dda0@06<@811S40104c<@44<@0;0HZ9RXV:RHZ90HT010404XZ9
0HV:RHZ9RP6TWjBO0HL1W`<103:7X8NP0J28X8P1R:28X8P1R0j83XP>R068
3XP1R@j93XT>R@h13XT>R@j93XT>R@j90@@000<10000200000@000<10000
>`000`5/K00=K0030Fa/00Y/00P1K05/CVa>K0@101I=K4e/CFa=0De>CDi=
CP5=<DdaCC411c40104a<`44<@/100n9ShV?RHn90HV?RHn9S`401:@20@03
Y:01008100FOX9nP0@04X00X0HP>R0j80HP>R0j83P6URJF90HT>R@j93XT1
RJF9YHVURJF9YHVU0@D000<100001`0000@000<10000>`000`5/K00=K003
0Fa/00Q/0P4016a>0Dd40@0CK4d1CDi=CTe>C@4aCC5=<Dda0@05<@811S40
1@4a<c4100<a0P407HZ9RXV:RHZ90HV:RHZ9RXV:0HZ9RXV:R@6OY9nT0081
00>OY9l00P407:27X8L1R:28X06PR:28X8P1R0j83XP1R0j83XP20@0C3XT>
R@h13XT>R@j93XT>R@j90@0500030@0000L0000400030@0003`000<1K6`0
36`00`5/K007K0040Fa/K0<101Y>K4i/CP5=K4e/CFa=K05>CDi=CTd1<Dda
C@8100<a0C4013401`4a<c4c<@400S420@0IRHZ9RXV:RHX1ShV?RHn9ShV?
0Hn9ShV?0@05Y0040JBPY08100JOX9nPW`44X00W0@j83XP>R0683XP1RJF9
YHVURJD13XT>R@69YHVURJF9YHVURJD100D000<100001`0000@000<10000
?0000`5/K00<K0030Fa/00I/00<1CP400P406Di/CP5=K4e/0Di=CTe>CDh1
CC5=<DdaC@400c401@5=<Dd100Da00L1<c4c<C<1008a0P408hZ9RXV:RHZ9
0HV:RHZ9RXV:R@69RXV:RHX1Y9nTW`6OY9nT00810327X8NP0J28X8RP0J28
X8RPR0683P4>R0j83XP>R0h13XT>0@j93XT>R@j93XT>R@4500030@0000L0
000400030@0003`000<1K6`036`00`5/K004K0@11f`07@5>K05/CFa=K4e/
0Di=CTe>CDh1CC5=0DhaCS4100@a00T1<c4c<C<a0C400P406hZ9RXV:RHZ9
RP6?RHn9ShV?RHn90HV?RHn90@04Y08100ZPY:2T0J2OX9l11J005@683XP>
R0h13XP1RJF9YHVURJF9Y@020@0?R@69YHVURJF9YHVURJD100D000<10000
1`0000@000<10000?0000`5/K00=K0030Fa/00@101i>K4i/CVa>K4i/0F`1
CTe>CDi=CTd1<DdaCC5=<@42<@070DdaCC5=0@04<@090C4c<C<a<`4a0081
01n9RXV:RHZ9RXT1RHZ9RXV:RHZ9RP6:RHZ9RP6TWjBO008100BTWjBO0`40
48NPQ`68X8RPR068X8RPR:020@0=R0j83XP>R0j83XP>R0020@0=3XT>R@j9
3XT>R@j90@0500030@0000L0000400030@0003`000<1K6`03F`30@03K05/
00a/0181K4e/CFa=K4d1CDi=CTe>CDh30@07CS5><Dha0@03<@090C4c<C<a
<c4c00<101b:RHZ9RXV:RHX1ShV?RHn9ShV?R@69ShV?RHl10j@0206T0JBP
Y06T0P400inP0@06X00S0HP>R0j83P6URJF9YHVURJF9YHVUR@69YHVURJF9
YHVURJD00P4400030@0000L0000300030@0003h000<1K6`02F`40@0BK041
K4i/CVa>K4i/CVa>K05/0P403Te>CDi=CP5=<DdaCC5=0P402C5=<DdaCC5=
0@02<@0e0C4c<C<a<c4c<@4E0HV:RHZ9RXV:RHX1RXV:RHZ9RXV:R@69RXV:
R@6OY9l1X06OY9nT0J000P407XNP0J28X8RP0J28X8RP0@h13XP>R0j83XP>
R0j83P8100^93XT>R@j93XT>R@020@@000<100001`0000<000<10000?P00
0`5/K006K0<10f`20@i/00D1K4i/CP020@0:K4e/0Di=CTe>C@<100TaCS5>
<DhaCP400c40:@4c<C<a<c4c<C<1RP6:RHZ9RXV:RHZ90HV?RHn9ShV?RHl1
ShV?RHl100>T00X1Y:@1X:BP0J2T1046X0030@j8008101:UX:D1YHVURJF9
YHVURJD1YHT20@09YHVURJF9YHVU00811@000`40000600000`000`40000n
00030Fa/009/1046K00G0Di/CVa>K4i/CVa>K4i/CP5=K4e/CF`00P42C@03
<@4100<100a=CP5=<DdaCC5=<@42<@0e0C<a<c4c<C<a<`6:5@69RXV:RHZ9
RXV:0HZ9RXV:RHZ9RXV:0HZ9RXV:0JBO0J2T0JBOY0400j00:`6P0@68X8RP
R0680HP>R0j83P4>R0j83XP>R0j80HT>R@h13XT>R@j93XT00P4500030@00
00H0000300030@0003h000<1K0400P49K0030F`100e/00X1CVa>K4i/CVa>
0`40>deCCE==Ddd1<DhaCS5><Dh1<@4c<C<a<c4c<C<a0HT1RHZ9RXV:RHZ9
RXT1RHn9ShV?RHn9ShT1RHn900<10Z@03P6TY:@1Y:01X:BP0J2T20408:2U
X:FPYJ01RJF9YHVURJF9Y@6URJF9Y@6URJF9YHVU0P4500030@0000H00003
00030@0003d00`4;K01F0E=/0Fa>K4i/CVa>K4i/CP5=K4e/CFa=K4e/0Di=
CTe>CDi=0C5=<DdaCC5=<@4a0C4c<C<a<c4c<@4ERP6:RHZ9RXV:RHZ9RP6:
RHZ9RXV:RHZ9RXT30@0=RHX1Y06TX:BPY06T0@04X00S0J01R:28X8RPR068
3XP>R0j80HP>R0j83XP>0@j93XT>R@h00P401XT>R@j90@H000<100001P00
00<000<10000>P030@03005/00U/0P44K0030Fa/00Q/01l1CVa>K4i/CVa>
K05CCE==DdeCCE<1CS5><DhaCS5>008100Ta<c4c<C<a<c400`405hT1RHZ9
RXV:RHZ9RXT1RHn9ShV?RHn900@100N?RHn90J@100FT0381X:@1Y:2TX06P
0J2UX:FPY@6UX:FPYJ2UX069YHVURJF90HVURJF9YHVUR@69YHVU0@H000<1
00001P0000<000<10000=P040@D000<1K6`01V`0<@5/DfaCK5=/0Fa>K4i/
CVa>K05/CFa=K4e/CFa=0De>CDi=CTe>C@4aCC5=<DdaCC400P4033<a<c4c
<C<a<`6:5@P100V:RHZ9RP6:RHX01P402HV:R@69RXV:R@020@09Y:2TX:BP
0Il100FP0P409j28X8RPR:013XP>R0j83XP1R0j83XP>0@j93XT>R@j93XT1
R@j90@0600030@0000H0000200030@0003@00`4900030Fa/00E/00<1K6`0
1V`00`5/K006K00f0Fa>K4i/CVa>K4h1CE==DdeCCE==D`5><DhaCS5><Dh1
<c4c<C<a<c4c0HZ9RXT1RHZ9RXV:2@403hZ9RXV:RHZ9RXT1RHn9S`020@JT
00T1Y06TX:BPY:000P408ZFPYJ2UX06PYJ2UX:FPYJ01RJF9YHT1RJF9YHVU
RJF9YHT20@03Y@4000D000<100001P00008000<10000<@030@`000<1K6`0
16`0<P5/DfaCK5=/DfaC0Di/CVa>K05/CFa=K4e/CFa=K05>CDi=CTe>CDh1
CC5=<DdaCC5=0P40;C4c<C<a<c4c<@4ERQF:0HXERQF:5HXERQF:0HZ9RXV:
RHZ9RXV:RHX1RXV:R@020@07Y:2TX:BPY0020@NP02D1R:28X8RPR0683XP>
R0j83XP1R0j80HT>R@j93XT>R@j93XT>00811P000`40000600000P000`40
000^00<13`000`5/K003K0030Fa/00U/00<1K6`00f`07`5/CVa>K4i/CVa>
K05CCE==DdeCCE==0C5><DhaCS400P40<Dh1<c4c<C<a<c41RHZ9RP6:RHZ9
RXV:RHZ9RXT1RHZ9RXV:RHZ9RXV:RHX1ShV?R@401j@20@07Y:2TX:BPY002
0@0UX:FPYJ2U0JFPYJ2UX:FPY@6URJD1YHVURJF9YHVURJF9YHVU0@070003
0@0000D0000200030@0002X0104B00040Fa/K08106a/DfaCK5=/DfaCK5=/
0Fa>K05/CFa=K4e/CFa=K4d1CDi=CTe>CDi=CP5=<DdaCC41<Dha0C4c<C<a
<c415HXERQD15HXERQF:5HXERQF:0HZ9RXV:RHZ9RXV:RHZ90HV:RHX1Y:2T
X:BPY:020@NP0P4098RPR:28X04>R0j83XP>R0h13XP1R@j93XT>R@j93XT>
R@j90@L000<100001@00008000<100009`030AL000<1K04046`08P5/K05>
K4i/CVa>K4i/CP5=DdeCCE==DdeCC@4aCS5><@44CP0a0C<a<c4c<C<1RXV:
RHX1RXV:RHZ9RXV:RHZ9RP6:RHZ9RXV:RHZ9RXV:R@69ShV?0@07Y08100NP
Y:2TX:BP0081016UX:FPYJ2U0JFPYJ2UX:FPY@020@0@RJF9YHVURJF9YHVU
RJF90@P000<100001@00008000<1000090030AX00P40<5=/DfaCK5=/DfaC
K5=/DfaC0Dh1CFa=K4e/CFa=K4e/0Di=CTe>CDi=CTd1<DdaC@8103laCS5>
<@4a<c4c<C<1RQF:5HXE0AF:5HXERQF:5HXERQD1RHZ9RXV:RHZ9RXV:RHX1
RXV:R@6PY:2TX:BPY0401j009@6P0J28X8RPR0683XP>R0j83XP>0@j93XT>
R@j93XT>R@j93P4020000`40000500000P000`40000Q00<17@000`5/K00A
K08101a/CVa>K4i/CVa>K05CCE==DdeCCE==D`5><Dh11dh0<P4c<C<a<`6:
RHZ9RXV:0HZ9RXV:RHZ9RXV:RHX1RXV:RHZ9RXV:RHZ9RXT1RHn9ShT11j@3
0@0ZX:BPY:2T0JD1YJ2UX:FP0J2UX:FPYJ2U0JD1YHVURJF9YHVURJF9YHT1
20000`40000500000P000`40000N00<18@005@5CK5=/DfaCK5=/DfaCK5=/
D`5>K0020@1NCFa=K4e/CFa=0De>CDi=CTe>CDi=0C5=0DhaCS5><Dha0C4c
<C<a0AF:5HXERP6:5HXERQF:5HXERQF:5@69RXV:RHZ9RXV:RHZ9RXT1RHZ9
RXT1X:BPY:2T0JFP0@FP02<1R:01X8RPR:013XP>R0j83P4>R0h13XT>R@j9
3XT>R@j90@0900030@0000D000000`01000L00@190000`5/K00?K0050FaC
K5<00P404fa>K4i/CP5=DdeCCE==DdeCCE<00`49CP0c0C<a<c41RHZ9RXV:
R@69RXV:RHZ9RXV:RHZ9RP6:RHZ9RXV:RHZ9RXV:RHX1ShV?RHl100JT00@1
X:FP0P409ZBPY:01X:D1YJ2UX:D1YJ2UX:D1Y@jU3P69YHVURJF9YHVURJD1
2@000`400005000000<00@006@030BT001P1K5=/DfaCK5=/DfaCK5=/0Fa>
K4i/CV`20@0@CFa=K05>CDi=CTe>CDi=CP8104XaCS5><DhaCS5><@4a<c41
5HXERQF:5HX1RQF:5HXERQF:5HXERQD1RHZ9RXV:RHZ9RXV:RHZ9RP6:RHZ9
RP6TX:BPY06UX:FPY@810Z008P6PR:01X8RPR0683XP>0@j83XP>R0693XT>
R@j93XT>R@4900030@0000D000000`01000F00<1;@000`5/K00;K00;0FaC
K5=/DfaCK5<00P4026`1DdeCCE==1`4<CP0a0C<a<`6:RHZ9RXV:R@69RXV:
RHZ9RXV:RHZ9RP6:RHZ9RXV:RHZ9RXV:RHZ90HV?R@030@JT02X1YJ2UX:FP
0J01X:FPY@6UX:FP0J2U0JD>Y@jU3ZD>0HVURJF9YHVUR@4;00030@0000@0
00000`01000C00<1<0006`5CK5=/DfaCK5=/DfaC0Di/CVa>K4i/CVa>K008
0@11CE==DdeC0DhaCS5><DhaCS5><@4a<`6:5HXERQF:5HX1RQF:5HXERQF:
5HXERQD1RHZ9RXV:RHZ9RXV:RHZ9RXT00`43R@0>0J2TX:BP0J2UX:FPYJ03
0@0OR:28X06PR:013P4>R0j83XP>R0j80HT>R@j93XT>0@0;00030@0000@0
00000`01000?00@1=0000`5/K009K00M0E=/DfaCK5=/DfaCK5=/0Fa>K4i/
CVa>K4i/CP4034h00`4c<@040@0URXV:RHX1RXV:RHZ9RXV:RHZ9RXV:R@69
RXV:RHZ9RXV:RHZ9RP030@07RXV:RHZ90@04Y00:0JFPYJ2UX:FPY@/101BU
3ZD>Y@jU3ZD>Y@h1RJF9YHVU0@`000<1000010000003004000`00`4i000k
0E=/DfaCK5=/D`5>K4i/CVa>K4i/CVa>K05CCE==DdeCCE==Ddd1<DhaCS5>
<DhaCS5><@4a0Fb:K8X010406aD15HXERQF:5HXERQF:5HXERP6:RHZ9RXV:
R@060@:900<1RHT018T0;P6TX:BP0J2UX:FPYJ2UX068YHRUR068YHP1R0j8
3XP>R0j83XP>0@j93XT>R@4<00030@0000@000000`01000900<1?0000`5/
K007K00M0FaCK5=/DfaCK5=/DfaC0Di/CVa>K4i/CVa>K0403Dh20@09RHZ9
RXV:RHZ900X100^:RHZ9RXV:R@69RP060@0ARHZ9RXV:RHZ90HV:RHZ9RP40
0j@0:@6UX:FPYJ2UX:FP0J2UX:FP0J2UX04>Y@jU3ZD>Y@jU3ZD1YHVURJD1
00`000<10000100000030@0000H00`50000c0FaCK5=/Df`1K4i/CVa>K4i/
CVa>K4h1CE==DdeCCE==DdeCC@4aCS5><DhaCS5><Dha008101>:K8Y/RVb:
K8Y/0AF95HTERAF900/13hT00`69R@05R@0[0JBP0J2UX:FPYJ2UX:D1YHRU
R:F80HRU0@j83XP>R0j83XP>R0h13XT>0@0=00030@0000@000000`400002
00@1A0000`5/K003K00O0FaCK5=/DfaCK5=/DfaCK05/CVa>K4i/CVa>K4i/
0@0=CP0h0HZ9RXV:RHZ9RXV:0HZ9RXV:RHZ9RXV:RHZ9RXT1RHZ9RXV:RHZ9
RXV:RHZ9RXV:0HZ9RXV:R@42Y00X0JFPYJ2UX:FPYJ01X:FPYJ2UX06PY@6U
3ZD>Y@jU3ZD>Y@jU0JF90@d000<10000100000030@010081B000<05CK5=/
D`5>K4i/CVa>K4i/CVa>K4h1CE==DdeCCE==DdeC0DhaCS5><DhaCS5><@81
01j:K8Y/RVb:K8Y/RP695HTERAF95HTERAF95HTER@4BR@030HV900F902X1
X06PYJ2UX:FPYJ2U0JF8YHRUR:F80HP1R0j83XP>R0j83XP>R0693P4=0003
0@0000@000020D`002<1K6a/0E=/DfaCK5=/DfaCK5=/D`5>K4i/CVa>K4i/
CVa>0@0;CP0l0HV:RHZ9RXV:RHZ9RXT1RHZ9RXV:RHZ9RXV:RHZ9RXT1RHZ9
RXV:RHZ9RXV:RHZ9RXV:R@69RXV:RHX10Z@0906PYJ2UX:FPYJ2U0JFPYJ2U
X:FP0J013ZD>Y@jU3ZD>Y@jU3P813`000`400003000000<00@40C000C`5C
0Di/CVa>K4i/CVa>K4i/CV`1DdeCCE==DdeCCE==D`5><DhaCS5><Dha0Fb:
K8Y/RVb:K8Y/RVb:0HTERAF95HTERAF95HTERAF95@404XT00`69R@05R@0X
0J@1YJ2UX:FPYJ2UX068YHRUR:F8Y@6U0@j83XP>R0j83XP>R0j80@l000<1
00000`0000<000<10000B@008P5/0FaCK5=/DfaCK5=/DfaCK5<1CVa>K4i/
CVa>K4i/CP48CP8103j9RXV:RHZ9RXV:RHZ9RXT1RHZ9RXV:RHZ9RXV:RHZ9
RXV:0HZ9RXV:RHZ9RXV:RHZ9RXV:RHX1RXV:RHZ9RP8102BPYJ2UX:FPYJ2U
0JFPYJ2UX:FPY@6U0JD>Y@jU3ZD>Y@jU3P4@00030@0000<0000400030@00
04T004h1K4i/CVa>K4i/CVa>K4i/CP5=DdeCCE==DdeCCE==D`5><DhaCS5>
0HY/RVb:K8Y/RVb:K8Y/RV`15HTERAF95HTERAF95HTERAF95@4CR@030HV9
00F90P405JFPYJ2UX:FPYJ01R:F8YHRUR:F8Y@020@0<R0j83XP>R0j83XP1
4@000`40000300001@020DX00P407E=/DfaCK5=/DfaCK5=/0Fa>K4i/CVa>
K4i/CV`100I>0P40FHZ9RXV:RHZ9RXV:RHZ9RXV:0HZ9RXV:RHZ9RXV:RHZ9
RXV:RHX1RXV:RHZ9RXV:RHZ9RXV:RHZ9RXT1RHZ9RXV:R@6PYJ2UX:FPYJ2U
X06PYJ2UX:FPYJ2U008100X>Y@jU3ZD>Y@h14P000`40000300001`000`40
001800<104U/CVa>K4i/CVa>K05CCE==DdeCCE==DdeCC@4aCS5><@5/RVb:
K8Y/RVb:K8Y/RVb:K8Y/0AF95HTERAF95HTERAF95HTERAD101B900<1RHT0
1XT20@0OYJ2UX:FPYJ2U0JF8YHRUR:F8YHRU0@j83XP>R0j80@0C00030@00
00<0000800030@0004P001d1RP41DfaCK5=/DfaC0Di/CVa>K4i/CVa>K4i/
0@03CP@104:9RXV:RHZ9RXV:RHZ9RXV:RHX1RXV:RHZ9RXV:RHZ9RXV:RHZ9
RP6:RHZ9RXV:RHZ9RXV:RHZ9RXV:RHX1RXV:RHX20@0PRHX1YJ2UX:FPYJ01
X:FPYJ2UX:FPYJ2U0JD>Y@jU3P4D00030@0000<000090081B@020@0QK05>
K4i/CVa>K05CCE==DdeCCE==DdeCC@4aCP69K8U/00<102A/RVb:K8Y/RVb:
K8Y/RP695HTERAF95HTERAF95HTERAF95@4ER@040HV9R@811HT20@0CX:FP
YJ2U0JF8YHRUR:F8YHRUR0020@053XP>R0405@000`40000300002`000`40
0018000I0F`10FaCK5=/0Fa>K4i/CVa>K4i/CVa>0@02CP090HZ9RXV:RHZ9
00<103N9RXV:RHZ9RXV:R@69RXV:RHZ9RXV:RHZ9RXV:RHZ9RP6:RHZ9RXV:
RHZ9RXV:RHZ9RXV:RHZ900<100V9RXV:RHZ9RXT00P404ZFPYJ2U0JFPYJ2U
X:FPYJ2UX08100>U3P405`000`400002000030020DT00P405HT10Di/CP5=
DdeCCE==DdeCCE==D`030@0<RFb9K8U/RFb9K8U/0`407fb:K8Y/RVb:0HTE
RAF95HTERAF95HTERAF95HTER@404hT30@f90181YJ2UX068YHRUR:F8YHRU
R:D20@03R04001L000<100000P0000h000<10000B0000`6:K0030@07CVa>
K4i/CP0:0@0@RXV:RHZ9RXV:RHZ9RXV:R@<102V9RXV:R@69RXV:RHZ9RXV:
RHZ9RXV:RHZ9RXT1RHZ9RXV:RHZ9RXV:R@060@0ARXV:0HZ9RXV:RHZ9RXV:
RHX00P404:2U0JFPYJ2UX:FPYJ2UX:D20AT000<100000P0000l000<10000
B0020@03K8T100L101e/RFb9K8U/R@69K8U/RFb9K8U/RFb9K8U/RFb9K003
0@0IK04ERAF95HTERAF95HTERAF95HTERAF90@08R@D12HT00`69R@0=R@0=
0J01R:F8YHRUR:F8Y@040@03004001L000<100000P0001000P5:000Z0Fb:
K8Y/RVb:K8Y/RVb:K8X1RXV:RHZ9RXV:RHZ9RXV:RHZ9RXV:RHZ93@403XV:
RHZ9RXV:RHZ90HV:1P407hV:RHZ9RXV:RHZ9RXV:R@69RXV:RHZ9RXV:RHZ9
RXT00`400j2UX0060@03X@4000<000<100005@000`40000200004P000`40
0018008103B9K8U/RFb9K8U/RFb9K05/RFb9K8U/RFb9K8U/RFb9K8U/RFb9
K8U/0Fb9K8U/RFb9K8U/3P4ER@030HV900n91046R@030@0000@000<10000
50000`40000200004`020DX00741RVb:K8Y/RVb:K8Y/0HV:RHZ9RXV:RHZ9
RXV:RHZ9RXV:RHZ9RXV:0HZ9RXV:RHZ9RXV:RHZ9RXV:RHZ9RXT1RHZ9RXV:
RHZ9RXV:RHZ9RXV:RHZ9RXV:0HZ9RXV:RHZ9RXV:RHZ9RXV:RHZ9RXV:R@02
0@P000<100004`000`40000200005@000`400018008103e/RFb9K8U/RF`1
K8U/RFb9K8U/RFb9K8U/RFb9K8U/RFb9K8T1RFb9K8U/RFb9K8U/RFb9K8U/
RFb9K8T101R900<1RHT058T20@/000<100004P000`40000200005P000`40
0019001Z0Fb:K8Y/RVb:0HZ9RXV:RHZ9RXV:RHZ9RXV:RHZ9RXV:RHZ90HV:
RHZ9RXV:RHZ9RXV:RHZ9RXV:RHZ9RP6:RHZ9RXV:RHZ9RXV:RHZ9RXV:RHZ9
RXT1RHZ9RXV:RHZ9RXV:RHZ9RXV:R@813P000`40000B00030@000040000G
0081BP020@0kRFb9K8T1RFb9K8U/RFb9K8U/RFb9K8U/RFb9K8U/RFb90HU/
RFb9K8U/RFb9K8U/RFb9K8U/RFb9K04068T00`69R@0?R@8140000`40000B
00030@000040000I00030@0004T006<1RVb:0HZ9RXV:RHZ9RXV:RHZ9RXV:
RHZ9RXV:RHZ9RXT1RHZ9RXV:RHZ9RXV:RHZ9RXV:RHZ9RXV:0HZ9RXV:RHZ9
RXV:RHZ9RXV:RHZ9RXV:RHX1RXV:RHZ9RXV:RHZ9RXT00P4C00030@000140
00<100000@0001X000<10000B@020@0hK05/RFb9K8U/RFb9K8U/RFb9K8U/
RFb9K8U/RF`1K8U/RFb9K8U/RFb9K8U/RFb9K8U/RFb9K04IR@030HV900^9
00<1000050000`40000@00030@000040000K0081B`020@1KRXV:RHZ9RXV:
RHZ9RXV:RHZ9RXV:RHZ9RXV:0HZ9RXV:RHZ9RXV:RHZ9RXV:RHZ9RXV:RHX1
RXV:RHZ9RXV:RHZ9RXV:RHZ9RXV:RHZ9RXT1RHZ9RXV:RHZ9RP020AP000<1
00003`000`40000100007@000`40001:00@1039/RFb9K8U/RFb9K8U/RFb9
K8U/RFb9K05/RFb9K8U/RFb9K8U/RFb9K8U/RFb9K8U/0AZ900<1RHT01XT2
0A/000<100003P000`40000100007P020DX000@100000`40D8V:RHZ9RXV:
RHZ9RXV:RHZ9RXV:0HZ9RXV:RHZ9RXV:RHZ9RXV:RHZ9RXV:RHZ90HV:RHZ9
RXV:RHZ9RXV:RHZ9RXV:RHZ9RXV:0HZ9RXV:0P4N00030@0000d000<10000
0@00020000<10000A`000`40000400<102e/RFb9K8U/RFb9K8U/RFb90HU/
RFb9K8U/RFb9K8U/RFb9K8U/RFb9K8U/R@406XT01069RHT20B4000<10000
30000`40000100008@000`40001600030@0000L01040A8Z9RXV:RHZ9RXV:
R@69RXV:RHZ9RXV:RHZ9RXV:RHZ9RXV:RHZ9RXT1RHZ9RXV:RHZ9RXV:RHZ9
RXV:RHZ9RXV:RHZ90`4T00030@0000`00@410040000R0081AP000`40000;
00<102J9K8U/RFb9K8T1RFb9K8U/RFb9K8U/RFb9K8U/RFb9K8U/RFb90AV9
0`4V00030@0000`00@410040000T00030@0004<000<100003P030@0fRXV:
RHZ90HV:RHZ9RXV:RHZ9RXV:RHZ9RXV:RHZ9RXV:R@69RXV:RHZ9RXV:RHZ9
RXV:RHZ91P4Z00030@0000/00@410040000U00030@00048000<100004@04
0@0OK05/RFb9K8U/RFb9K8U/RFb9K8U/RFb9K8U/RFb90@0>R@D1<@000`40
000:00410@0100009P020D8000<100005@090@0ORHZ9RXV:RHZ9RXV:RHZ9
RXV:RHZ9RP6:RHZ9RXV:R@050CL000<100002@010@400@0002P000<10000
?`000`40000N00l100Q/RFb9K8U/0@:91P4m00030@0000P00@410040000Y
0081?`000`40000]00X1A0000`40000700410@010000:`000`40000l0003
0@0007`000<100001P010@400@0002`000<10000>`000`40001m00030@00
00H00@410000;@020C/000<10000O@000`40000600410@0002l000<10000
>0000`40001n00030@0000D00@410000<0020CP000<10000O`000`400004
00410@00038000<10000=@000`40002000030@0000<00@410000<`000`40
000d00030@00084000<100000P010@40000d0081=0000`40002200050@00
00400@0003H000<10000<@000`40002300040@000@40000g00030@000300
00<10000Q0000`4000010@00>0020C0000<10000Q0000`4000010@00>P00
0`40000]00030@0008D00@410041000k0081;@000`4000260081000m0003
0@0002X000<10000Q@030@00?P000`40000Y00030@00084010430000?`02
0BT000<10000O@040@L0001100030@0002H000<10000N0050@/000120081
9P000`40001d00@1400004@000<100008`000`40001`00@1500004D000<1
00008P000`40001[00D1600004H00P4R00030@0006L0104M0000B0000`40
000O00030@0006<0104Q0000B@000`40000M00030@0005l01@4U0000BP02
0Ad000<10000F`040BX0001<00030@0001X000<10000E`040Bh0001=0081
6P000`40001B00D1<P0004l000<100005`000`40001>00@1=`00050000<1
00005P000`40001:00@1>`0005400P4F00030@0004D01@4o0000D`000`40
000C00030@00044010540000E0000`40000B00030@0003`01@580000E@02
0A8000<10000>0040Dd0001G00030@0000l000<10000=0040E40001H0081
3`000`40000_00D1E@0005X000<1000030000`40000[00@1FP0005/000<1
00002`000`40000W00@1GP0005`00P4;00030@0002801@5R0000GP000`40
000800030@0001h0105W0000G`020@P000<100006P040F/0001Q00030@00
00D000<100005@050Fl0001R00030@0000@000<100004@040G@0001S0081
10000`40000=00@1N00006D000D100000@0:00D1O00006H000@100011P04
0H40001W00<10P040HD0001Y00<1R@000001
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{245.188, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Chapter 3: Rotationally Symmetric Parametric Surface", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ParametricPlot3D[\n\ \ \ \ {r\ Cos[Cos[r]]\ Cos[psi], \ 
          r\ Cos[Cos[r]]\ Sin[psi], \ r\ Sin[Cos[r]]}, \n\ \ \ \ {r, \ 
          0.001, \ 9  Pi/2}, \ {psi, \ 0, \ 3  Pi/2}, \ 
        PlotPoints\  -> \ {72, \ 30}];\)\)], "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00013@P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgMo000>OWifm_K`00V@00
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcol800P5L0000`0020@03004105/0002m00<10`020E/0002k00811P00
0`400@1J0000^@020@P000@10001F@000;H00`4:00040@000ET0002d0081
3@001@40000105P0002a00<13`001@40000105P0002_00814P000`400002
00030@0005D0002/00<15@000`40000200030@0005@0002Z008160000`40
000200030@0005@0002W00<16P000`40000300030@0005<0002U00817@00
0`40000400030@000580002S00817`000`40000400030@000580002P00<1
8@000`40000500030@000540002N008190000`40000500030@000540002K
00<19P000`40000600030@000500002I0081:@000`40000700030@0004l0
002F00<1:`000`40000700030@0004l0002D0081;P000`40000800030@00
04h0002B0081<0000`40000900030@0004d0002?00<1<P000`4000090003
0@0004d0002=0081=@000`40000:00030@0004`0002:00<1=`000`40000;
00030@0004/000280081>P000`40000;00030@0004/0002500<1?@000`40
000;00030@0004X000230081@0000`40000;00030@0004X0002000<1@P00
0`40000<00030@0004T0001n0081A@000`40000=00030@0004P0001l0081
A`000`40000=00030@0004P0001i00<1B@000`40000>00030@0004L0001g
0081C0000`40000?00030@0004H0001d00<1CP000`40000?00030@0004H0
001b0081D@000`40000@00030@0004D0001_00<1D`000`40000@00030@00
04D0001]0081EP000`40000A00030@0004@0001Z00<1F0000`40000B0003
0@0004<0001X0081F`000`40000B00030@0004<0001V0081G@000`40000C
00030@000480001S00<1G`000`40000D00030@000440001Q0081HP000`40
000D00030@000440001N00<1I@000`40000D00030@000400001L0081J000
0`40000E00030@0003l0001I00<1JP000`40000E00030@0003l0001G0081
K@000`40000F00030@0003h0001E0081K`000`40000F00030@0003h0001B
00<1L@000`40000G00030@0003d0001@0081M0000`40000H00030@0003`0
001=00<1MP000`40000H00030@0003`0001;0081N@000`40000I00030@00
03/0001800<1N`000`40000J00030@0003X000160081OP000`40000J0003
0@0003X0001300<1P0000`40000K00030@0003T000110081P`000`40000K
00030@0003T0000o0081Q@000`40000L00030@0003P0000l00<1Q`000`40
000M00030@0003L0000j0081RP000`40000M00030@0003L0000g00<1S@00
0`40000M00030@0003H0000e0081T0000`40000N00030@0003D0000b00<1
TP000`40000N00030@0003D0000`0081U@000`40000O00030@0003@0000^
0081U`000`40000P00030@0003<0000[00<1V@000`40000P00030@0003<0
000Y0081W0000`40000Q00030@000380000V00<1WP000`40000Q00030@00
0380000T0081X@000`40000R00030@000340000Q00<1X`000`40000S0003
0@000300000O0081YP000`40000S00030@000300000L00<1Z0000`40000T
00030@0002l0000J0081Z`000`40000U00030@0002h0000H0081[@000`40
000U00030@0002h0000E00<1[`000`40000V00030@0002d0000C0081/P00
0`40000V00030@0002d0000A0081]0000`40000W00030@0002`0000A0081
]@000`40000W00030@0002/0000A00030@010;@000<100009`000`40000[
00004@001040006c00030@0002P000<10000:P00010000<100000P000`40
002`00030@0002T000<10000:@00010000<100000`000`40001S00L1A@00
0`40000Y00030@0002T0000@00030@0000@000<10000G`040@07UGL10IEg
0@1400030@0002X000<10000:000010000<100001@000`40001L00@100Al
U@4119D30D8000<10000:P000`40000X000040000`40000600030@0005T0
2@400gNEM`020@04T7H10D4000<10000:`000`40000W000040000`400007
00030@0005H01@42U@810YD30@03T9D100<1@@000`40000/00030@0002H0
000?00030@0000T000<10000D`060@06U@41MiEg0P400i1f0@030@03C@40
040000<10000;0000`40000V00003`000`40000:00030@0005001@42C0@1
0YD00`6@U@020@04L@5<C@81@@000`40000]00030@0002D0000?00030@00
00/000<10000C@060@07C0410IF@U@030@03T06:00H1@P000`40000^0003
0@0002@0000?00030@0000`000<10000@`020@H01044C0810iD20@04T9D1
T0D1A0000`40000^00030@0002@0000?00030@0000d000<10000@0020@03
K04000@010403d`1C05<0IF@U@6@MY01L@050DD000<10000;`000`40000S
00003`000`40000>00030@0003d00P40175/L@4300@11D`70@04T9D1T0<1
00=<0@00A@000`40000`00030@000280000>00030@0001000P4k00811F`0
0`4000050@03C05<008100M=0HnE0I1f008100=a0@400`5700030@000300
00<100008P0000h000<100004P000`40000f008100UaK75/LFaa0@001@40
3d`10@5/CF`1UI01T9D1T0040@03C04003802`4:00030@00030000<10000
8@0000h000<100004`000`40000c00812F`80@05ITeVCFH01@400i010@03
0@9<00<10000<@00306?0GJ@0GMaM`5bF@@11P000`40000`00030@000240
000>00030@0001@000<10000<0020@0;LFaaK75/LFaaK7401P4034e/CFa=
K4d1T001U@@100E<CDa=0@0d008100b@M`5bMg9g0GMJMeX30@@000<10000
<@000`40000P00003P000`40000E00030@0002h000<1K6`02f`50@0<CFI=
ITeVCFH1U@6@1043C081=@00106V0I040@09L@5ILUUb0EXh00810P000`40
000b00030@0001l0000>00030@0001H000<10000:`030@0=LFaaK75/LFaa
K75/L@020@9=00/1K4e/CFa=K4d1T0040@03C05=008100==0@00=@030@04
T05gLP@100AgFWL10eX30C@000<100007`0000h000<100005`000`40000Y
00040FaC0@i/00/1C@5VCFI=ITeVC@0:0@04ITeV0CH00`40276@0GMaM`5b
10401CQJ>5Xh0081=0000`40000N00003@000`40000I00030@0002H00P40
7fe/K@5aK75/LFaaK75/LFaaK05=0De/CFa=K4e/0@000`402D`10De/CFa=
0@0g00D100QbMg9g0GMJM`8115X00`4i0@0d00030@0001d0000=00030@00
01X000<100008`020@06DfaCK5<13V`02P5=0FI=ITeVCFH20@03S`4100<1
00I=ITeVC@4h00<100/h0@41Mg41FG9ILP030@06FSP10CP1<`000`40000M
00003@000`40000K00030@00024001l1KFa]K6e/K@5aK75/LFaaK75/LFaa
K05=0De/CFa=008100=/0@4010401de/CFa=K040>0020@05FP4i0GL01040
1UYgFWL1FP@100@h>@41<P000`40000L00003@000`40000L00030@0001h0
0P402FaCK5=/DfaC0@0>K0060Dd1ITeV0P400de/C@030@9=00H1ITeVCFH2
0CP00P400cP10@020@04Mg41F@8100UbF@5IFUT1>0400cP00`40000_0003
0@0001`0000=00030@0001d000<1000070006P5/KFa]K6e/KFa]0G5/LFaa
K75/LFaaK75/0P4016a=0@45K0810dd00`5=K0030@03K04003P00P400cP1
0@020@05M`5gLGL00P4035X1FEX1FP4i>3Th0C4000<100006`0000d000<1
00007P000`40000J008100]/DfaCK5=/DfaC0@0>K0@100M=K4e/CFa=0081
0Td02@5=0@5/CFa=0@0i00@100Xh0CP1M`5bFG9I0P4015YI0ET30@8h0P4a
00030@0001X0000<00030@00020000<100006000705C0Fa]K6e/KFa]K6e/
0FaaK75/LFaaK75/LF`20@U/00@1CDe=0P46K0030@0003L00P401U@1>5X1
>08100EaMg5gL@040@08FUT1>04h>@4a00030@0001X0000<00030@000240
00<100005P00405>D`5/DfaCK5=/DfaCK04=K08100]=K4e/CFa=K4d1C@03
0@08CFa=K4e/C@4i008100=I0@401P401eUbFG81LUT00P401UX1>3P1>081
<@000`40000I000030000`40000R00030@0001<00P4075=]D`5/KFa]K6e/
KFa]K05/LFaaK75/LFaaK7430@Q/00H1C@5>K046K0030@0003L000<1>040
0P401eAJ0@4h0G400P4037Ma0EUb0G81FP5J>0@1<@000`40000H00003000
0`40000S00030@00014001<1DdiCCU<1K5=/DfaCK5=/Df`100Y/0P402g41
0De/CFa=K4e/008100]=K4d1CFa=K4e/0@0i008100aD0@5I>5T1>3@1LG83
0@07LUT1FG9I0@04>0030C<1030000<10000600000`000<1000090000`40
000?000L0FeCKE=]D`5/KFa]K6e/KFa]K05/LFaaK75/L@8100=/RV`00P48
K0060Di/CV`11V`00`40000g008100IbE05DFU@20@0=>041LGMa0EUbF@5I
LP020@04>5XhFP81<@000`40000G000030000`40000U00030@0000d001D1
DdiCCU=>D`5/DfaCK5=/DfaCK0401F`30@0JLFaaK75/0De/CFa=K4e/0Fa=
K4d1CFa=K4d20CP000D1D`41F@030@03F@5D00@100=aLP400P401g81LUT1
>0400cP30C4000<100005P0000/000<100009`000`40000;000I0FeCKE=]
DfeC0Fa]K6e/KFa]K6e/0FaaK0020@0:RVb:K8Y/RVb:0@Q/00H1CVa>K043
K08100=/0@00=`020@06FG810EAb0P400cP1>0020@05Mg41LG800P402UUb
0EYD0CQJ0CP20C0000<100005P0000/000<10000:0000`400009008101I>
DdiCCU=>Ddh1DfaCK5=/DfaCK05/0P404faaK75/LFaaK75/0De/CFa=K4d0
0P401Va=K4d1C@810f`00`40000e00<100YaE741FEAI0E@h1@4035UbFG81
LUT1>5Th0@8h0`4a00030@0001D0000;00030@0002T000<100001`005`5C
0FeCKE=]DfeCK@5]K6e/KFa]K6e/008100j:K8Y/RVb:K8Y/RVb:0@E/0P40
1V`1CVa>K08100I/LFaaK04f00070G41LUUbF@020@08LU@10ETh0C<20@04
LW5bL@@100QJE5YD0CP1=081<0000`40000E00002`000`40000Z00030@00
00H001D1<`5>DdiCCU=>Ddh1DfaCK5=/Df`00`404W5/LFaaK75/LFaaK75/
0De/C@810f`00`5/C@030@I/00<10000<`00405]0G41LE@1E741F@5D0E@4
0@0=FG9ILP5bF@4hFCQI>0020@03=3<1034000<10000500000/000<10000
:`000`400004000Y0C=C0FeCKE=]DfeCK@5]K6e/KFa]0G5/0Fb:K8Y/RVb:
K8Y/RVb:0F`00P401FaaK75/00<100Y/K@5aK75/LF`1=000105a0@42L@05
0G81LUT00P4015UD0CP20@09=041LG9a0G5b008100QDFUAJE04d>081<@00
0`40000C00002`000`40000/00030@00008001@1<dhc0DiCCU=>DdiCCP5C
K5=/D`8101AaK75/0FaaK75/LFaaK75/LFaa0@M/00H1K5=/D`46K0030@00
03400P4035<1E75DL@5aE75D0@=D0P400cP10@020@0<FG81LUT1E04hFCQI
0P400c<10@0E00030@0001T000<100004`0000/000<10000;@005P40004c
Dc=C0FeCKE=]DfeCK@5]K6d20@0YK75/LFaa0HY/RVb:K8Y/RVb:K8Y/0Faa
K75/LF`1K6e/K@5aK75/LF`00P4a008100A]0G410W401P5a0G9ILP8100ID
FE@1=3P20@09L@410G5b0G9D008100IJE04h0C@20A@00P4K00030@000180
000:00030@0002l002d1005><dhc0DiCCU=>DdiCCP5CK05aK75/LFaaK05/
LFaaK75/LFaaK75/L@401f`01P5/DfaC0@I/00@1YP41;@020@0@L@41KG5]
0E@1E741L@5a0@=D0P400c<10@020@0<L@410EUDFEAI0ETh0P400c@10@0D
008170000`40000A00002P000`40000`000@0E<cDc=C0FeCKE=]DfeCK@<1
02aaK75/LFaaK741RVb:K8Y/RVb:K8Y/RV`1K75/LFaaK741KFa]0G5/LFaa
K0<100>?0@40:@020@04KG5]0@Ea00`1LG5a0ET1E741FE@40@05Y05bLG80
0P4035AbE79DLP5J0CP1>0814`000`6U0@0K00030@000140000:00030@00
02l002d1CS=><dhcCP5CCU=>DdiCCP5/LFaaK75/LFaaK741LFaaK75/LFaa
K75/L@4026`01@5CK5<100E/0P401JH10HVV00811`030A/00P400g5/0@02
0@04L@5]L@8100Y]0EAaE05DLEAa0`400e@1>0030@0;LEUa0EUDFEAIE5T0
0P400c<h0@020A<000<1Y@4070000`40000@00002P000`40000_000@0C=C
<e<cDc<1DfeCKE=]D`8102]aK75/LFaaK75/LF`1K8Y/RVb:K8Y/RVb:K05/
LFaaK75/L@5]K6d1LFaa008100E/0@6VS`030@03RP41008010400iD10@0H
008100=aRW400P401XYaRP5a0@=a00@1LG5a1`402U@h0C@1X05aLW420@08
LUAbE79DLP43>0<14@001@4ZYBX101/000<10000400000X000<10000;P02
0@0]CS=><dhcCP5CCU=>Ddh1D`5/LFaaK75/LFaaK741LFaaK75/LFaaK75/
LF`100M/00H1DfaC0F`20@03LFaa008100B:ShZ?0P400hV?0@030@04M`41
U@815@020@03RV`1008100=a0G400g40205aKG5]L@5a0`40275DLE@1=e@g
0P403Z@1LET1E741FEAIE5UD0P400cPc0@020A4000D1Y:FT0@0L00030@00
00l0000:00030@0002h00P40=c=C<e<cDc<1DfeCKE<1Dg5C0FaaK75/LFaa
K75/0Fb:K8Y/RVb:K8Y/RVb:0G5/LFaaK741KF`00`403Fb:K8Y/RP6VSjJ?
0Hl01`401Y2E0@6@0A400`400g6:L@020@06RW6:L@5a0P400hX1L@02L@@1
00I]L@5aE7420@0D>5@10J01LG81LUUb0G9DLU@1E042>0030J@1014000H1
:ZDZY@4L00030@0000h0000900030@0002l000d1<@4cCS=><dh1DdiC0081
021CKE=]0G5/LFaaK75/LFaaK05/LFaaK75/LFaaK75/0@M/0`402F`1K75/
LFaaK0020@04ShX1RP<10T`20@04M`41T0D11@0:0@045HX1RP8100=a0G40
0g420@=a10404G5]0EAaE741L@5D0E@gE06T00<100AaE75D0P402UUDF@5D
>04c0J020A0000H1Y:FTY@4L00030@0000h0000900030@0002h002h1<c<1
Dc=C<e<c0E=]0G5CLE=aD`5/LFaaK75/LFaaK741RVb:K8Y/RVb:K8Y/0P40
5g5/LFaaK741LFaa0HY/RVb:K8X1YP6V00L100^ET041T06@0HX1S`050@03
ShX100B:00<1RW402@401W6:0@5aRP@10W420@0=L@5]LFd1E05DL@5D>002
0@0=Y041FG9ILUT1E79D0@02E0030CP100:T00<100003P001`4ZYBZU:P40
6`020@l0000900030@0002h002`1<c41<dhcCS=>0E<1KE=]DfeCK@5aK75/
LFaaK75/LF`1K75/LFaaK75/L@8100=/0F`01F`20@0>K75/L@5aK75/LF`1
RXl50@03K4d100<100>@0G401@402XZ90AF:5HX1RQD50@08MY01Mg41FGL3
0@04L@410@=a0181L@5aKG41LEAaE05CE5<1=e@20@0DW`5D0EAaE75D0EAI
0E@hE04h0J@20@l000L1Y:FTYJ@101P00`400`01000>00002@000`40000^
000:0C<c0E<cDc=C<`8101eaDg5CLE=aDg41LFaaK75/LFaaK741RVb:K8Y/
RP030@08RW6:0G5/LF`20@0@RP5aK75/0Fb:K8Y/RV`1S`@100=/IV`00`40
0i01T0050@03S`4100P100F:S`41S`0<0@08RP6:LHYaRP45L@090G5]0E@1
E75D00<100^U0@5a0G9ILUUbF@020@ED0P42Y0030@0000d000L1:ZDZYBX1
01@0104400030@0000d0000900030@0002d002L1<C<a0C=><dhcCP5]DfeC
KE=]DfeC0FaaK75/LFaaK75/L@5aK7400`401g5/LFaaK740104046aaK05/
LFaa0G5/LFaaK7440@05C@5=K4d00P400i01LP030@0ACP41RXn:0G6:LHX1
RW6:LHX00P400hl10@070@05@041L@400W430@0>KG5]LFd1E741K@5DDe@3
0@0;Y@41E741LEAaE7400P401CQD>5@h008100>TX0403`001P6TYJBUY081
40030@P000<100003@0000T000<10000;@002P4c<c<1Dc=C<e<20@0IDg5C
LE=aDg5CL@5aK75/LFaaK75/LF`1K0020@0MRW6:LHYaRW6:L@5/RVb:K8X1
LFaaK05/RVb:K8X010401Dd1IVaV00X1011/0Hn:S`6?RXn:0HZ?RXn:1040
0i010@020@06LP41FP4h0P401W41LHYa0@Ea0P40275DL@5aE7410jD02P5a
LG41LUUbFG820@ED00<1Y:@00P4=00070JDZYBZU:P020@d00`4<00030@00
00`0000900030@0002d002<1<C<a0C=><dhc0E<1DfeCKE=]DfeC0FaaK75/
LFaaK75/L@020@0MK75/LFaaK75/LFaa0G5/LFaaK741LFaaK05/LF`00P40
1g410@5=0F`00P400f`10@0:0@0:ShX1LHYaRP6:L@d100Aa0@5J10405fea
KG41LFeaKG41KE=]D`5CE5<1Y:FT0081019aE05DLEAa0E@1E3QD>5@1Y:02
0@d000T1YJBUY:D1Y0402P030@l000<10000300000P000<10000;P008@4c
<c<1Dc=C<`5CE05aDg5CLE=aDg5C0FaaK75/LFaaK0030@0LLHYaRW6:LHYa
RW6:L@5/RVb:K8Y/0FaaK741RP8100=aRW400P4014h10@43K08100=g0@40
10400f`1S`0:0@03RXl100H100B@M`5a0P400g9I0@030@06RW6:LHX10g40
2@5a0G5DLE@1E0020@>U0P43L@080EUbF@5DL@44E0030JBT00813@002@6U
:ZDZY@6T0@0700<14P000`40000<000020000`40000^000n0C4c<C<1CS<1
DeAC0E=]DfeCKE=]Dfd1LFaaK75/LF`1K75/0FaaK75/LFaaK75/LF`1K75/
LFaa0G5/LF`20@06LFaaK75/0P400f`1K002K0L100m>0@41ShZ?RP5aRW6:
0HX00`400hX10@030@03T741008100Aa0@5b1@404G5]LFd1KG41LE<1DfeC
K@5D008100>TYJ@00P401g5DLE@1E0400e@20@06E3QD0JBP0P4=00090JFT
YJBU0J@100<0104E00030@0000`0000800030@0002h000<1<c<00S<06@4c
0E=DDeAC0E=aDg5CLE=aD`5/LFaaK7400P44L@0H0HYaRW6:LHYaRW6:LHX1
RVb:K8Y/0Faa0`402hYaRW6:LHX1K5<100=/00<1T9D01@402f`10HZ?RXl1
ShZ?00<100B?RXn:0`400i010@020@05T7410G800P402E@10@5aRW6:L@02
0@0<LFeaK@5DLEAa0E@10jD20@Aa00P1LP5aE75D0@=D0P42Y08130020@07
:ZDZY@6T:P030AT000<10000300000P000<10000;P00704a<c4c0Dh1E5=D
De@1KE=]DfeCKE=]0G5/LF`20@0/LFaaK75/0FaaK75/LFaaK75/LF`1K75/
LFaa0G41LFaa0G5/LFaaK05>K042K0<100>?T0401P4018n:ShX40@07RW41
LHYaRP050@06T0410GMa0P401781FCP30@0>KG5]L@5aDg5CL@5]Dfd20@0=
<`41Y@6U0G5DLEAa0@06E0030CQD008100BPY0412`00206U0JBUY:D10Z@0
0`40000I00030@0000`0000800030@0002d00P44<`8101EDDeACE5<1Dg5C
LE=aDg5CL@5aK0402G40505aRW6:LHYaRW6:LHX1RVb:K8Y/0P44L@0:0G6:
LHYaRP5/D`<100I/0@6E0I030@05L@6:0Hl00`4028n:ShZ?0Hn:1@401WJ@
0I1aT08100=aLP401P4048Ya0@5a0G5]LFea0G5D0E<30@04Y@6T0@Aa00l1
L@5aE75DLE@1E06U0J@00P4;000;0JVU0JDZY@6T:P406`000`40000<0000
20000`40000]008101La<c4c0EACE5=DDeAC0E=]DfeCKE=]D`030@0]K75/
LFaaK75/L@5aK75/LFaaK75/LF`1K75/LFaa0G5/LFaa0G5/LFaaK05>0081
0f`01@6@0I2?00<100=/0@400P4028n:0G6:LHYa2@403g410@5a0G41FG81
FE@1<`030@0AK75/0E=aDg5C0E<1De@1YZD00P402JD1LEAa0G5C0@06E0<1
00>U0J@00P4;00080JFY0JFTY@42Y0030@0001T000<10000300000L000<1
0000;P000`4a0@03<`0D0E=DDeACE5=D0G5CLE=aDg5CL@4<L@0F0G6:LHYa
RW6:LHYaRW41K8Y/RVb:0@Ea0101RW6:LHYa0F`1K75/L@6W0`401Fd10@6:
01@100UaT741LG9a0G400P400g9D0@020@Ea00H1KG5]LFd20@05KE<1YJT0
0P400j@10@02L@0;0EAaE05DLEAaE7400P400jDZ0@020@P00`402jFYYJT1
:ZD1Y2X101`000<100002`0000L000<10000;P00604a0C<a0C<1DeACE5=D
D`5CKE=]DfeCK@81035/LFaaK75/LFaaK75/0FaaK75/LFaaK75/L@5aK75/
LF`1K75/LF`1K75/LFaa0F`100A/0P400hl10@030@05L@410HT01P4016`1
0G420@05D`41Sg400P400gL10@03L@050EAaE5T00`405G5/LFaa0G5CLE=a
0EACE06VYJH1Y@020@07E05CLE=a0@06E0810ZD30@D00`4200080JVUZJD1
Y043Y0030@0001X000<100002`0000L000<10000;P000`4a0@02<`0F0E@1
E5=DDeACE05aDg5CLE=a0G5]0@aa01D1RW6:LHYaRW6:LHYa0Fb:K8Y/RP40
1G401P6:LHYaRP8100I/0FaaK7440@03<`4100h100B:0@5/1040391a0@6@
L@5a0G41F@8100AD0@411G400`5aK@030@09DfeC0JFYY@6T00<100]DLEAa
E741LEAaE0020@04:P4ZY@810P030@D000H1YJVUZJD20@04:Z@10A`000<1
00002`0000L000<10000;P005@4a0C<1E3<1DeACE5=DDe@1KE=]D`020@0S
LEAa0G5/LFaaK75/LFaaK741LFaaK75/LFaaK741LFaaK7400P4026aaK75/
L@5a0`401HX1K05/00D100>?0Dh00`42L@07RP6:0HX1RP0;0@03S`41009a
0241LG41E75D0E@1=`6P0FaaK75/0E<1DfeC0E<1YJJU0JD01040275CLE=a
Dg410e@20@06Y@6UY@6S0P4800060JVUZJFY0P42Y0030@0001/000<10000
2`0000L000<10000;P00704a0C<1<e@c0E=DDeACE5<1Dg5C0FeaKG5]L@4<
L@0@0G6:LHYaRW6:LHYaRP6:K08100>:0G4017430@05RW6:LHX01@400hX1
Y`030@05E05a0HX02@400hX1RP020@03K041008100V@0I1a0G41L@400W40
0`5b0@020@03Y@5a00Ea00d1K75/L@5]0JVUZ@6Y00<1019a0G5DLEAaE05D
L@5D0BZU0JD30@P000`1ZJFYYJVUZ@4ZY04M00030@0000/0000700030@00
02h003D1<@41<e@cE05DDeACE5=D0FeC0EAaE75DLE@1K75/LFaaK75/LFaa
0G5/LFaaK75/LFaaK0030@07K75/0FaaK0020@05L@6:LHX01P402FaaK06?
0HX1D`020@03L@6:00<100>:0HX01P402F`10JT1RW6:0@02L@0<0Fea0G5D
L@5DD`6P0P400g5/L@030@0=KE=]D`5C0JFVY@6U:P020@0>D`5CLE=aDg5C
0E@1<`43Y@@120002@6UZJFYYJVU0@02Y0030@0001/000<100002`0000H0
00<10000;`004@4a0@5D<e@c0E=DDeACE5=D008100Y]LFeaKG5]LFd13740
2`6:LHYaRW6:LHYa008100J:LHYaRW430@04LHYaRP<100f:LHYa0Fb:K8Y/
0HnW008100AIL@6@2@400hX1RP020@03YP41008100N@L@5a0G41009a00H1
L@5a0ET40@9a00X1LF`1K75/L@5]0P401JD1YJVU008100UaK@5DLEAaE740
0P401e=D0BZU:ZD00`4800070JVUZJFYY@020@03:Z@101d000<100002`00
00H000<10000;`00<@4a0E@cE3=D<`5CE5=DDeAC0EAaE75DLEAaE741LFaa
K75/LFaaK75/0FaaK75/LF`00`402G41K75/LFaa0@03L@@100IaRW6:LHX2
0@07K75/L@6?RP040@04L@41L@8100J90HT1RF`90@04LHYa0@9a00T1LFd1
E05C0E<01P404G5/LF`1DfeCK@6V0JH1:ZDZ008100iCL@5aDg5CLE=a0E@c
0@BU0`47000=0JVUZJFYYJT1:P6T0@0N00030@0000X0000600030@0002l0
0101<@4cE3=D<e@1E5=DDeAC0P40375]LFeaKG5]LFea0@]a00H1RW6:LHX2
0@0;LHYaRW41LHYaRW4010402XYaRW41LHYaRW420@07RVb:K06?Y`060@03
L@4100X100L00@41T76@00<100B:LHX10W40105DLE@20@0EY@41K75/LFaa
0G5/LF`1YZT1ZJFY008100Y]LFea0G5DLEAa0P401e=D0BZU:ZD00`47000=
0JFYYJVUZJD1Y@6T0@0N00030@0000X0000600030@0002l002`1<@5D<e@c
E3<1DeACE5=D0G41LEAaE75DLEAaE05/LFaaK75/LFaaK741L@<100^:LHYa
RW6:0G5/L@040@Ia00L1RW6:LHYa008100=a0@401P400eT10@0<0@03T041
00D10g402`5aL@5]0E<1Dfd100:U0P404W5/LFaaK05CKE<1SjJ?0JDZY@81
00iaDg5C0E=aDg41E5<1<`810ZD0106TY@47000=0JVUZJFYY@6U:P6T0@0N
00030@0000X0000600030@00030001da0@5D<e@cE05DDeACE05aE05]LFea
KG5]LFea0@0<L@8100Z:LHYaRW6:LHYa10400hYaRP020@0;LHYaRW41LHYa
RW4010402HYa0Hl1RZH1LP0>0@03T0410081016:L@5aRW41LHYa0Fea0G5D
0@02Y@<1015aK75/L@5aK741ZJJY0JVUZ@020@0<KG5]LFd1E75D0E=]0P40
1jD1YBX1:Z@00P45000;0JVUZJFYYJT1ZJD00`4N00030@0000X000060003
0@00030002La0@4cE3=D<e@1E5=D0G5DLE@1E75DLEAaE75DL@5aK75/LFaa
K7400`402HYaRW6:LHYaRP040@05K75/LF`00P46L@030G41008100]a0@5a
K741S`6?RP0D0@05RW6:L@4017430@09LE=a0Fd1Y@6U008101m/LFaaK741
K@6VSjH1Z@4Z0BX1LE=aDg41LE<1DeAC008100NVY@6U0JBU00811@00306U
ZJFYYJVU0JDZY@817P000`40000:00001P000`40000`000N<@4c0C=D<e@c
0E=D0G5DLEAa0G5]LFeaKG5]LFd11g420@09RW6:0HYaRW6:00<1016:LHX1
RW6:LHX1L@6:LHYaRP020@0?LI1aT741LHYaRP6VRZJ:00@100>@0@400P40
0hl10@050@08LHl1RW6:0HX30@=a00D1LFd1E0030@09Y@41LFaaK75/00<1
01JVZJH1YP6U0BX1KG5]LFeaE05CKE=]0P400jFYY@020@05:Z@100401002
0@0:YJVUZJD1YJVUZ@817P000`40000:00001@000`40000a000U0C<c0E@c
E3=D0EAC0EAaE75DL@5aE75DLEAaE75D0FaaK75/0@05L@030G4100<100n:
LHYaRW6:0G5/LF`1L@400g420@07L@6:LHYaRP020@0:K75/0HZ?RP6:S`81
00=g0@402@401g6:L@5aRW400P402W5/0FaaK05CLE<20@03YP6U008100E/
LFaaK0030@09SjJ?0JJYYP6U0081015aDg5CLE<1DeACE5<1YJJUYP020@03
Y:D1008001010001Z@6YYJVUZ@4ZYBZU0P4N00030@0000X0000500030@00
034000X1=3<1<e@cE3=D0P404eAaE75DLE@1KG5]LFeaKG5]L@400g420@05
LHYaRW400`404g6:LHYaRW6:LHYa0G6:LHYa0G400`402G6@L@5aT76@L@02
0@03RW4100<100NV0Hn:S`6?00P100N:ShX1LHma00@100F:LHYa0@04L@<1
00FYY@41:P020@0GK7410F`1YP6VZ@6YYZT1:P5aKG5]LFd00P403feCKE=]
0JVUZJFY0BZT0@03000?0@01YZT1ZJFYY@6UZJFY00817`000`4000090000
1@000`40000a000O0C<c<`4cE3=D<`5DLEAaE75DLE@1E75DLEAaE75DL@03
0@Aa0`42L@0E0HYaRW6:LHYaRW6:0G5/LFaa0G4100Ia00H1LHYaRW430@04
K069S`@1012:0HZ?RP5aRW41LHYaRP6:0`404HXERP5aK741LFaa0FeC0JFV
008100>=0@400P402faCK06Y0JH1ZJJY008100JU0@5aDg420@0ADfd1E5=D
D`6UYZFVY@6TY@400`020@0<SjV?Z@6YY@6U:ZDZ0P4P00030@0000T00005
00030@00034000X1=3<d0E@cE3=D0P405eAaE75DLEAa0G5]LFeaKG5]LFd1
LHYa00<101IaRW6:LHX1RW6:LHYaRW6:LHX1RW6:0`403901T76@LI1a0G6@
L@8100Z:LHX1YXZV0Hn:40402hYa0G6:L@5aRW6:00@100ECK@6YY@020@0;
:P41K6e/K@40YP000P400jJYYP050@0CKG41LFaaK05CKE<1YJVUZJD1Y@03
0@@000d1ZJJYYP6UZ@6YYJVU008180000`40000900001@000`40000a0003
0C<c008c01P1E3=D0E@1LEAaE75DLEAa0G5DLEAaE7420@04L@410@Ua00`1
LHYaRW6:LHYaRW440@03L@5a009a00<1LG400g40:P6:0@5aS`5aK741ShT1
RHn90HV:R@4ERQD15HXERP6:5HX1RQF:0G5/L@8100ECK@5]D`030@0CY@41
K05/Df`1ZHnYS`6VZJH1Y@030@0DK041KE=]Dfd1E5=D0JJUYZFV0BX30@<0
00h1Z@6YSjV?0JD1YBZU:P8180000`40000900001@000`40000a000L0C@c
=3<1<e@c0EAI0G5DLEAaE75D0FeaKG5]L@D1042:LHYaRW6:LHYaRP6:LHYa
RW6:LHYaRP6:LHYaRP6@LI01T76@LI01T76@L@5aRW41RZH1ShZ?0Hn:S`6?
RXl118X02@5aRW6:0HYaRP030@05RP5aK7400P401:H10JT20@0@K05/K@40
YP2V0JH1YZT1Z@810W404`5aK75/LF`1DfeC0JFYYJVU0JD00`4300070JJY
0JVVZ@020@07YJVUZ@4Z0@0P00030@0000T0000400030@0003800P43<`05
0E@cE0400U@03P5DLEAaE75DLE@1E75D0`44L@030G5a00Ua00d1RW6:LHYa
RW6:LHX100Aa00D1LG5a0@03L@8100J@0HmaSg440@0JS`6?RHl1RXV:R@4E
RQF:0HXERP6:5HXE0AD30@07K75/0E=]D`020@0FYZD10BX1K05/D`6?ZHl1
SjT1Z@6YY@D1019CKE=]DfeC0E<1YJJUYZD1YBX30@800141SjV?0HnYSjT1
:ZDZY@6>0@0P00030@0000T0000400030@0003<001D1<c@c=05D0EUDFE@1
E75DLEAaE7401@46L@0G0G6:LHYaRW6:LHYa0G6:LHYaRW6:LHX00P40:76:
LHX1T76@L@5a0G6@L@5aT76@0HYa0HX1RXn:0HZ?RXl1ShZ?RP43RP030G6:
00@100hERP6:K8Y/0Faa0JVVZ@8100hZ0F`1K06V0:H00@2V008101ZY0@41
K75/0FaaK75/L@5]0JVUZJFY0JVUZ@810P00206YYZVV0JJY0P401jFYYJT1
:P4080000`400009000010000`40000c00810c<00`4c0@04E0070G5DLEAa
E0050@Ua00<1LG402G40205aRW6:LHYa0P400hX1L@03L@030G5a009a0P40
2G6@LI1a0G6?L@020@03LF`100L100V:R@4ERQF:0HX01@402hY/0FaaK05/
LFaa00@100BUYP6Y0P43K00=0Hl1SjT1ZHnYS`6UZ@020@0=K75/L@5]DfeC
KE<1D`020@08YZFVY@6U:ZD20@0C006YSjV?ZHl1S`6V0JDZ0BZ>0@0P0003
0@0000T0000400030@0003<00P403S@c=3<1E5UDFEAI0G5D0`4015AaE04:
L@0A0HYaRW6:LHYaRW6:0HYaRW400`402g6@LI01RW6:L@5a008100V@L@5a
T76@0I000P400gJ@0@030@06RHn90HV:2@403hZ90AF:5HX1RQF:5@5/RP02
0@07K6d10JH1YP020@0<LF`1S`010040YP2V0P403jT10FaaK75/0FaaK75/
L@020@0:YP6UZJD1YJVUZ@8100X00JJYYZVVZJH10ZT0106YY@42:P030@00
01l000<10000200000@000<10000<`000`4c0@03<`030EAD00AD0`4025Aa
E75D0E@12W400`5aL@09L@0<0HX10G6:LHYaRW4117420@09LGMaMg41LI1a
008100J@LI1a0F`20@0KRXV:0HZ9RXT15HXERP6:5HX1RVb:K05/LFaa00<1
00Q/0F`1YXl1Y@<100e/0HnVSjH1ZHnYS`6?008101VY0G5/LFaa0FeCKE=]
Dfd1ZJD1YJH1:ZDZ008101@00HnYSjV?ZHnY0JVV0JD1SRZ>0B4000<10000
200000@000<10000=0020@03<c@c008100=IE0400P4035@1E75DLEAa0G9a
0@Ua00`1LHYaRW6:LHYaRW420@0GT76@LI1aT76@L@5aRW41L@5aT76@0I00
0P401GJ@0I1f00@101^?RHn90HV:RHX1RXV:R@69RXV:0HXERP6:5HX00P40
1faaK05/0JH00P400jT10@020@04S`2?008100JV0:H1Z@040@0GK75/LFaa
0G5/LFaa0JVVZJH1Y@6UZJD00P404001ZJJYYZVVZ@6Y0JT1Z@42:P030@00
020000<10000200000<000<10000=@020@<c1045E00:0EAaE741LEAa0@Ya
00<1LG401W420@0=L@5aRW6:LHYaRW6:0@03L@0>0GMa0G5gLGL1T76@LI02
0@0MM`410HV:RHX1RXV:R@4ERQF:0HXERQD1K8Y/0F`00P400f`1K002K081
00J?YP6Y0JT20@0RSjJ?YP40S`6?0HnYS`6C0FaaK75/LF`1DfeCKE<1YJVU
Z@8100BU:ZDZ0`403JV?ZHnYSjV?0JJY0JT00P400hhZ0@0R00030@0000P0
000300030@0003D000<1<`400`404cP1E5UDFEAI0G5DL@5bLG9aLP402G40
1`6:LHYaRW400P40691aT06@LI1aT76@LI1aT06:LHX1T741L@8100B@0@5f
0P4019D10HT40@0CShT1RHZ9RP6:RHZ90HV:RHX1RP040@09K8Y/0FaaK06V
008100>YYP400P4028l1S`0108l00P400jT0Z@040@0<LFaaK75/L@5aK75/
0P402jVVZJJY0JVUZ@4Z008100RVZJJYYZVV0@BY0P43:P030@00020000<1
0000200000<000<10000=@030@8c00<1>0401e@02`5a0G5DLEAaE74100Ua
00@1LG5a0P46L@0<0HYaRW6:LHYaRW410W420@09LGMa0G6@LI1a008100>@
0@400hT00`69R@0C0@03RF`100A/00T1K6a/0JH1ZJH00P40492?T06V0@2?
08l1SjV?0I@20@0<LFaaK75/LF`1DfeC0P406ZVUZJFYY@6U:ZD1Y@6?0HnY
SjV?0JJYYZVV0P400bZ>0@0S00030@0000P0000300030@0003800`400`01
<`020@0FE3QD0EUDFEAIE05D0G5bLG9aLW5b0@Qa01L1L@41T76@LI1aT741
LI1aT76@LI1aT0030@06RP41L@5g0P4019010I030@0WRJJ9YP6:RHZ90HV:
RHX1RXV:R@4ERQF:0HY/RP6:K8Y/0Faa0JVV00@100X0S`2?0040S`2?0P40
102Y0JT30@0SK75/LFaaK75/0F`1D`6VZJJYYP6Y0JFY0BX1006YYZVVZ@40
1JT20@8Z00<100008@000`40000800000`000`40000_00<11000204c0@4d
>3@11e@02`5DLEAaE75DLE@100Ua00<1LG402G40305aRW6:LHYaRW6:0@=a
0P40176@LI050@033P6900>900<1RHT00XT00`69R@02R@0@0Fb9K8T1RFb9
K05/RFb90@=/20401Hl1Si2?00<100J?0041S`020@0>U:T10F`1K75/LFaa
K7420@0MCP6UZJFYYJT1Z@4Z0BX1ZHnY0JV?Z@6YYZVVZJH00`400hh1000S
00030@0000L0000300030@0002`00`48000J0C<1E3QD>05DFEAIE05I0G5b
LG9aLW5bL@47L@0L0G41LI1aT76@LI1aT06@LI1aT76@LI1a0G6:L@@100>@
0ID00P400hT>0@020@0NYXVV0HZ9RXT1RHZ9RP6:RHZ90AF:5HX1RVb:K05/
0`42K0<100BET9F@0`400hl0S`020@0709@0U06Y00030@0DRP5aK75/LFaa
K05CK@6YYZVVZ@42Z@0=0JD10@2V0:H1YZVV0@05Z@050JT1:P409@000`40
000700000`000`40000Y00<12`00204a0C@h=3P11E@03P5aE05DLEAaE75D
LE@117420@9a00<1LG402G40306:LHYaRW6:LHYa0@9a00@1Mg5g10401XP1
R0h1R@8100>90HT00hT00`69R@02R@0=0Fb9K8T1RFb9K05/R@040@9/00T1
K4e/0I01T8l00P402IF?UHnE0@2?00030@0=Z@410G5/0FaaK75/L@030@0R
D`6YYJVUZJD1YJT1:P6YSjV?ZHl1S`6VZJJYYZT1Z@4Z0BD000<100001`00
008000<100009`030@h001`1<`41>5@hE05IE5T1LUUb0G9aLW5bLG9aLW41
0W406`5gLGMaM`6@LI1aT76@LI1a0G6@LI1aT76@L@020@08RW6:0I1g0I04
0@063XT1R@j92@402XV:0HZ9RXT15HX50@03RF`100=/00<1K6`01P40192E
0@020@07T06D0040U0020@0:006:K8X1LFaaK08100]]K05C0JJYYZVV0@04
Z@8100VV0:H0YP01Z@401JT00`6YZ@020@03004002<000<100001`000080
00<1000090030A800`401CPd>3@100=D0181E75DL@5aE75DLEAaE741L@47
L@030G5a00Qa00H1LHYaRW430@03LHl1009a1P401j280@4>R0400hT02064
RHB90HV42P400hU/0@04K0040Fa/K0<100QV0@5f0Hn@S`8100>ESiD00`40
4`2D0@6Y0G5/LFaa0G5/0E=/Df`00P407Xl1YJVUZ@6YYJVU0HnYSjV?ZHnY
0JVVZJJY0JTZZ@810P000`40000Q00030@0000L0000200030@0002400`4E
0081030h0E@hE3P1E05ILUUbFG81LW5bLG9aLW5b0GMaMg5gLGMaM`6@LI1a
T76@LI01T7430@0<LI1aT741LHX1T06E0P4018P>0@h30@043XT>0@B900<1
RHT00XT03`69Q8V40Fb9K8T1RFb90@03K08100A=K05=0P4027L10@6@0I00
0P403I@0U001006:K8Y/RV`00`401Fa]K6e/008100JYYP6VZ@44Z@090JH0
YP2V0:H000811JT0106YZJT20@<000<1000080000`40000700000P000`40
000N00<160007@4c0@4d>3@h0E@1LEAaE75DL@5aE75DLEAa0G4100Qa00<1
LG401g430@0:LHmaSg6?LHma0@9a00<1T7H00`401HRP0@j300<101J90HB9
Q8T1RHB9Q05/RFb90HU/RF`10f`0205/0@5/0FI=1P400iF?U@030@04U@40
U0D100E/LFaaK0020@0XK5=/DfaCK06YSjT1ZJD1YJVU0HnYSjV?ZHnY0JV?
0JJYYP4ZZBZY0@@000<1000080000`40000700000P000`40000K00<17002
0@0Z=04hE3QD0G9ILUUbFG9ILP5bLG9aLP5bL@5aMg5gLGMaMg41LI1aT76@
0P403W6@0I1aT76@LI1aT06:1@400j010@020@05R0h13XP01042R@030HV9
00:900`1RHB9Q05/RFb90HT40@05IVaV0Dd00P401Td10GL1T0<100>E09D0
0`401iD10@5/RV`00`403f`1K6e/KFa]K06VZJJY0@05Z@0=0@2V0:H0YP2V
0JT00@02Z@030JVY00>Y00<100000`000`40000O00030@0000L000020003
0@0001P00`4O008100Hd<`4d>3@20@0?LEAaE75DLEAa0G5DLE@100=a00<1
LG401g40105aLG420@0IMg5gL@5aSg6?LHmaSg6?0G41T7H1PP62X0020@08
P`h1RH<1PhTC0@06K6H1CFa=10400dd10@040@05SiD1UHl00P400`2D0002
0@04K0410@A/02L1K5=/DfaC0HnYSjV?Z@6YYJT1ZHnYSjV?ZHl1SjV?0JJY
0JTZZBX00P4600030@0001l000<100001P000003004001L00`4S000W0C@h
0E@hE05J0G9ILUUbFG9I0G5bL@5aLW5bL@5aMg5gLGMaM`6@008101AaT76@
LI1a0G6@LI1aT76@L@5aRPH100>20H<00`4078P>R063RH<1PhV3R@69Q8V4
0F^4Jh@1Q6^40F`30@03ITd100@100Ig0I2E0@030@0309D100@101A/LFaa
K75/0Fa]K6e/K@6YYZVVZ@810ZT04@40YP2V0:H0YP6Y0:T00JT100FY00<1
00001P000`40000N00030@0000H000000`01000D00<19P005P4d<c@1>3@1
E5T1LEAaE75DLE@1E047L@030G5a00Ia01@1Mg5gLGMaMg5gL@5aSg6?LHma
S`8100=a0GH01@401881PhP30@0FR@69PhT1RF^9J`5[Q6^40HA[Q05/IP@1
00AVC@5<10400e@10@050@03UHl100@100=/0F`01f`03`5/DfaCK06YSjV?
ZHl1YP020@0?006YSjV?ZHl1SjV?ZHnY008100@ZZBZY0P4800030@0001h0
00<100001P000003004001400`4Y008103Dh=04h0EAJE5X1LUUbFG9ILUT1
LG9aLW5bLG81Mg5gLGMaM`6@0I1aT76@LI1aT741LI1aT0030@04T7H1L@81
00>Y0@40104018<1PhP40@0=P`63RH>90HV4RH@1J`050@07IV`1Jdd1C@05
0@06E05g0I2E1@406iFD0Fb:0G5/LFaaK75/0Fa]K6e/0JJYYZVV0@02Z@0B
0@2?0JH0YP2V0JT0Z@2Y0:T11:T20@X000<100007@000`400006000000<0
0@003P030Bd000@1<c@c0P403EUDFEAI0G5DLEAaE7400P48L@030G5a009a
0P40479aLP5gLGMaMg5gLGL1Sg420@05T76@LI000`401I010@62008100N2
0@41PhP100:33@4026I[0F]VJ`5V20401E@10@6@00<100BE0IBE0P4016`E
K049K00N0E=/D`6?ZHnYS`6VZ@40S`2?0HnYS`6?ZHnYSjV?0P401ZTZZ@6Y
0@/000<1000070000`400006000000<00@002`030C000P40<3@h0@5DFUAJ
E5X1LUUbFG81LW41LG9aLW5bLG81Mg41LI1aT76@0I1aT76@LI1aT08100Qf
T7J@MY1fT08100>@0JH01@400h:P0@020@0DR069PhT1Q8>40HA[Q6/1JhA[
0FH40@07IP410D`1C@020@03Mi0100810iD40@0^K8Y/RP5aK75/LFaaK741
KF`1YP6VZJJY0JT108l0S`2?0JH00@2Y0:T0Z@6Y0@>Y0P4=00030@0001/0
00<100001P000003004000P00`4c00<101@c=05IE5UDFEAI0G5DLE@1FG9I
0@Ma0181L@5aLW5bLG9a0G5gLGMaMg420@09T06@LI1aT76@00@100=f0Hl0
1P400h<1P`080@08J`5[Pf/1IV/40@03C6H100<100=<0Dd010401901UI06
0@075F`EK1E/0@09K00U0E=/0JT1ZHnY0JT108l0S`2?006Y0JV?ZHnYS`6D
Z@6Y:P6C0@0=00030@0001/000<100001P0000030@0000D00`4g008102/h
=041FUAJE5YDFP5bF@5aLW5bL@5aLW5bLG9a0G6@LI1aT76@L@5aT76@0081
00UfT7J@0I1fT7H00P401YD10GL1T08100>V0@h01@400hP1P`02P`030H>3
00P100>3IP4010400dd10@030@04K@5gT0T103B:K8Y/RVb:K05/LFaaK75/
L@5]0@2V006Y0JT108l0S`2?08l00@2Y0:T0Z@6Y0:T1Z@6C0P4>00030@00
01/000<100001@0000030@0000800`4j000G0C<1=04h0EUDFEAIE5T1L@5b
FG9ILP401W403P5a0G5bLG9aLW5bL@5a0P402I1aT76@L@5aT00:0@03MY01
00@100<>0@4020401f/1IX=V0FH010400fI<0@050@07L@410I01U@060@0;
K1E/5F`EK1E/5@4026`20@06ZHnYS`6?0P402@2?08l0S`2?00020@0:SjV?
ZHnY0JVDZ@8100>CZ@4040000`40000J00030@0000D000000`400@020Ch0
0P40<3@1>5X1FUAJE5YDFP5bLG9aLW5b0G9aLW41LGMa0G6@LI1aT76@L@5f
T7J@MY1fT0@100N9YP41FUl1009g0P42T0070Hl10@h13P040@03P`6300L1
00AVP`5[1P401G410I1g00P101B:0HY/RVb:K8Y/RV`1K75/LFaaK08100H0
YP2V0:H20@0F08l0S`2?08l00@2D0JT0Z@010:T0Z@8100>Y0@404@000`40
000I00030@0000D000020D4000D1<`4c0@02>0070EUDFEAIE0020@08LUUb
FG9ILP43L@050G9aLW400P40279aLW5bL@5a0P40191aT7440@J91@42M`81
00Af0@6?0`4018T1RH<A0@065HX10GJ@0P4017L10ID20@0?K8U/0F`EK1E/
5F`EK1D100E/0P401dh1SjV?ZHl00P406ID108l0S`2?0040S`01ZHnY0JVD
ZIBY0JT00P4B00030@0001T000<100001@0000030040044002D1<`41FSQJ
0EYDFU@1FG81LW5bLG9aLP5b0GMaMg5gLGL1T76@008100IfT7J@0I020@0;
M`69YXVVRJJ9YXT00`4015X10GL20@:@2`401hT1RHB90H@00`4018Ya0G43
0@05M`41UGL0104058Y/RVb:K05/RVb:K8Y/RV`1K75/0P42K0060JH0YP2V
0P40202?0Hl0S`2?0P403@2D09@1Z@010:T0Z@000P400i<10@0C00030@00
01P000<100001@0000800P5000040C<10@<h02D1E5UDF@5bFG81LUUbFG9I
LP5bLG9aLW5bLG81LP5gLGMaMg5g00@12XT00`69R@040@=g0P400gJ@MP04
0@03S`6:00h100=f0@400P400iD10@020@0DK8U/RFb9K8T15F`EK1E/5F`E
0F`20@09CVa>0Hl1SjV?0081012ESiF?0Hl0S`6?08l0S`2?0P401JVDZIBY
008100>C0@405@000`40000G00030@0000D0000400030@0003h001P1=05J
>5Xh0EAJE05ILUUb0G9aLW5b0GL20@0ULGMaMg5gLGL1T7J@MY1fT06E0JH1
YXVVRJJ9YXVVR@69RXV:R@050@=g0P43T0X10Y000`6@0@030@03MiD100@1
01>:K8Y/RVb:K8Y/0Fb:K8Y/RVb:00<11F`08P40YP6V0Hl0S`2?0040S`6D
09@0U02D0040Z@2Y00400JT20AH000<100005P000`40000500001@000`40
000n00<113P06`5DF@5bFG9ILP5bFG9I0G5bL@5aLW5bLG81M`020@03LGMa
00D100>90HT02HT00`69R@07R@8100=00@400gL?0@03O7L100D101:9K05/
RFb9K8U/RFb90AE/5F`40@0;K05/CVa>K06YSjT00P4028nESiF?UHnE0P40
28l0S`2?08l00P401iBYU:T1ZI@00`4G00030@0001H000<100001@0000H0
0P4o00<100AJ>5Xh0P408W9ILUUbFG81LW41LGMaMg41LGMaM`6@LY1b0GH1
T069YHT40@0IYXVVRJJ9YXT1RHZ9RXV:RHZ90HT1AUm6G`0C0@0DRXV:RHZ9
RP6:K8Y/RVb:K8Y/0F`30@06K8A/Q6`11F`05P6V0:H1S`2?08l0S`2?0I@0
U02D09@20@090040Z@0109@000816@000`40000F00030@0000@000080003
0@0003`00P400cP1>003>00B0EUbFG9ILUUb0G81LW5bLG9a0P402781Mg5g
LGMa0`401XT>R@j90@:91P42R@030HV900N900<1RHT028T:0@0ER@69K8U/
RFb9K8U/0Fb9K8U/RFb900@126`0205/CVa>0HnY0P4028l1SiF?UHnE0`40
4@2?08l0S`6?08l1U:T1ZIBY00<16P000`40000E00030@0000@000090003
0@0003`00P401CP1FSQJ00<102YbFG9ILUUb0GMaMg5gLGMaM`6@LY1bT781
T069YHVURJD13XT>R@j93XT50@0[RHZ9RXV:R@69RXV:RHZ9RXV:0HZ9RXV:
RHZ9RXT1RHZ9RXV:RHZ9RP6:K0060@0=RF`1K8A/Q6b4K8A/0@04K0<101jE
T9D108l0S`0108l00@2D09@1U02D00400@2D09@20A`000<1000050000`40
000400002P020Cd000@1>3P10SP02P5DFP5bFG9ILUT30@08LG9aLW5b0GL2
0@04LGMaM`8100R93XT>R@j90@Z900<1RH@01@42R@030HV900R90141K8U/
RFb9K8U/R@69K8U/R@080@Q/00<1K6`01f`0105/CV`30@0AT8n@Si01UHnE
0@2?08l1S`000P401Hl0S`2?008100BYU:VD0P4M00030@0001@000<10000
100000`000<10000>P020@8h00H1FSP1FEX20@0AFG9ILP5gLP5aMg5gL@5b
T7800P405i010@6URJF9YHVU0@j93XT>R@j93XT100N920402hZ9RXV:0HZ9
RXV:00/101Z9K8U/R@69K8U/RFb9K8U/0Fb4K8A/Q6b40@E/0WL01`6ET9F@
0Hl00P401P2?08l0S`8100`0U02D09@00@2D09@30Ah000<100004`000`40
000400003@000`40000j000N0CPh>04h0EYDFU@1FG81LUUbF@5aLW41LGMa
Mg5g0P402hP1R@j93XT>R@h100V90101RHB9Q8V4RHB90HV4RHB92`404HU/
RFb90HU/RFb9K8U/RF`100Y/00<1K6`01V`03@5>K4i/CVag0Hn@Si000P40
3hl0S`2?08l00@2?08l0S`030@03U:VD00<180000`40000B00030@0000@0
000>0081>`00104h>3P20@05FEYIFUT00`401G9gLWMb008100Ug0I1bT7:@
0ID00`404jF9YHVURJF90HT>R@j93XT>R@402HT00`69R@08R@0[0HV4RHB9
Q8V4RH@1K8U/RFb9K8U/R@69K8U/RFb9K8U/0Fb4K8A/Q6b40@05K08100=g
0I000P4029F@0Hl0S`2?0`402Y@0U02D0I@1U0020@03U040024000<10000
4@000`400004000040000`40000h00810cP0405JE5YDFUAJ0G9ILUUbFG82
0@05LGMaMg400P403:280@4>R@j93XT>0@V902`1RHB9Q8V4RHB90HV4RHB9
Q8V4RH@1K8U/RFb9K8U/R@69K8U/RFb9K8U/0@U/00<1K6`01f`0105>K4h2
0@03K4d1008100R?UHnE0@2?008100J?U@40S`020@05U001Z@400Y@00`40
000Q00030@00018000<100000`00014000<10000>0020@<h0P401EUJFEYI
00<100MbMg9gLP5b008100V@LP6@0HP>0@h00`403jF9YHT1R@j93XT>R@j9
0@09R@030HV900R902`1RHB9Q8V4RHB9Q05/RFb9K8U/RFb90HU/RFb9K8U/
R@64K8A/Q6b4K8@1K08100a=K4e/0I01UI2ET9D30@0<09D0U@6D0040U02D
0P401:VDZ@4T00030@00014000<100000`0001800P4i00<100/h0CP1E5YD
FP5bF@020@07LUUb0GMaM`040@08R:28X069PhT30@033P6900R902`1RHB9
Q8V4RHB90HV4RHB9Q8V4RH@1K8U/RFb9K8U/R@69K8U/RFb9K8U/0@U/00<1
K6`01F`40@06K4e/CFa=0`4018nESiD20@06SiF?UHnE0`40102D09@20@>D
00<1000090000`40000@00030@0000<0000D00030@0003L000H1=04h0D02
0@07FUUJ0GMJM`030@0CMg9gLWL1U@4>R0j80HP>R0j83P040@08R@j93XT>
R@49R@030HV900R902<1RHB9Q8V4RHB9Q05/RFb9K8U/RFb90HU/RFb9K8U/
R@64K0050@0<Jf`1K4e/CFa=0Df@0P405i010ID109D0U@2E0I@0U02D006Y
U:T102P000<100003`000`40000300005@000`40000f00030CPc008100aJ
>5X1FU@1FG9ILUT20@0FMg5gL@6@0HRPR:01RH>9PhV3R@69P`D10XT0;069
Q8V4RHB9Q8T1RHB9Q8V4RHB9Q05/RFb9K8U/RFb90HU/RFb9K8U/RF`11f`5
0@0@IVaVK6I/IP5=K4e/CF`1C@@100R?UHl1SiF?U@<100@0U02D0`42U003
0@0002L000<100003`000`40000300005P000`40000f00030CPd008100=J
@5X00`401gMJMeYg0GL00P400g81T0030@0CR0j80HP>R0j83XP>0@j83XP>
R0050@N900<1RHT028T06@69Q8V4RHB9Q8V40Fb9K8U/RFb9K8T1RF`01@40
7f^40Fa[K6]/Jfa[0De/CFa=K4d1C@5g0I2ET9D109D00P402P2E0I@0U06D
0I@20B/000<100003P000`40000300005`020CL000T1>3<1>5XhFSP00P40
279ILUT1LGMa10406Z220@6PR063RH>9PhV30H>9PhV3RH>90HV31@408HB9
0HV4RHB9Q8V4RH@1K8U/RFb9K8U/R@69K8U/RFb9K0050@0GJfa[K6]/J`5V
K6I/IVaVK05/CFa=K4d010401WL1UHnES`<100Z?UHnE0@2D0IBE0`4]0003
0@0000d000<100000`0001T000<10000=@000`4h=0020@05FT1J0GL00P40
15YgFP43M`070I010J23X0030@0H3XP>R0j83P4>R0j83XP>R064RHB9Q8V4
2045R@0>0HV4RHB9Q8V4RH@1K8T60@0KK8T1Q6^4JhA[Q6^40Fa[K6]/Jfa[
0De/CFa=008100Q=0@5g0I2ET08100L0U@2E0040008100>D00400P4_0003
0@0000d000<100000P0001X000<10000=@030@08@@41>5X1FUT20@06LP5g
LGMa0`401H:PPZ22008101n9PhV3RH<1PhV3RH>9PhT1RH>9PhV3RH>90HU[
RF^901<101j4JhA[Q6^4J`5[K6]/Jfa[K6/1IVaVK6I/IV`1K4d30@04C041
C@<100ZE0@6?0HnESiF?0P4019FDUI@20C0000<100003@000`4000020000
6`020CL00P402D4h0D01FWMJM`040@9g0P402881Pj23X06P0`40B`j83XP1
R0j83XP>R064RHB9Q8V4RH@1Q8V4RHB9Q8V4R@69Q8V4RHB9Q8V40Fb9K8U/
RFb9K8T1Q6^4JhA[Q6/1Jfa[K6]/Jf`1K0020@03CFI=008100A=0@5g0P40
29F@U@40U@2E0P40102D09@20C8000<1000030000`40000200007@000`40
000e008100a1>04h0EUJFEX1MeX60@09X8:PPZ01R8>800<104F90HV3RH>9
PhV30H>9PhV3RH>90HU[RF^9JhU[RF/1JhA[Q6^4JhA[Q064JhA[Q6^4JhA[
0F]/Jfa[K6]/0FaVK6I/IV`00`404de<CDa=0Dd1C@5g0IF?U@6ESiD00`40
0iFDU@030C@000<100002`000`40000200007P000`40000e00050CQ1>440
0P401EYgFWL100=g0101U@620J23X8<1Pj23X8>P0`40?`j83XP>R0h1RHB9
Q8V4RHB90HV4RHB9Q8V4R@69Q8V4RHB9Q8V40Fb9K8U/RFb9K05[Q6^4JhA[
Q6/1Jfa[K0030@0DJ`5VCFI=IP5=0Dd1T7L1T9F@0ID20@0409D1U0@1=P00
0`40000:00030@000080000O0081=P001@4h@CQ100<100]JF@5JMeX1S`5m
PP020@0<PZ220H>8PhR3R0630`40>HV3RH<1PhV3RH>9PhV30F^9JhU[RF^9
J`5[Q6^4JhA[Q6^40HA[Q6^4JhA[Q05/Jfa[K6]/Jf`1K0030@0:ITeV0De<
CDa=C0L100>?U@400`4029BEU06D0G/1>0000`40000:00030@000080000Q
00030@0003@00P401D4h0EYO008100=J0GL00WL01P6@0H81PP8100fP0J23
X8>PPj01R8>800<1038>0HV4RHB9Q8V4R@69Q8V4RHB9Q8T1RHB9Q8V4RHB9
Q05/RFb9K8U/RF`1JhA[Q6^4J`@100a[IV]VJfH1CFI=ITd50@03Mi010081
00NE0@2E09D0008100>D0@00>@000`40000900030@000080000R00030@00
03@00`401CP1FEYI00@100=g0@400P4017d1PX830@07R8>8PhR30@06P`L1
02J9PhV30F^9JhU[RF^9J`5[Q6^4JhA[Q6^40HA[Q6^4JhA[Q05/J`D100mV
J`5VCFI=ITd1C4e<CD`01P402WMa0I2ET06DUI@20@03UG/103`000<10000
20000`40000200008`020CH00`401emJGeYO0GL00P401Y2E0@620@>20P40
4j23X8>P0HR3R8>8PhP1RH>9PhT02P4058B9Q8T1RHB9Q8V4RHB9Q05/RFb9
20404FI/IVaVK05[IV]VJfI[0FI=00T100=g0ID00YD90Ch000<100002000
0`40000100009@000`40000d000>0CP10EUJFEX1MeX1Si030@B210400hR3
0@08P`030H>300J300H1Jh=[Pf/D0@0GJfI[IV/1JfI[IV]VJfH1CFI=ITeV
0Dd00`400d`10@050@03M`4100<100>EU0400`5000030@0000P000<10000
0@0002H000<10000=0080@=g00D1T041PP020@:200@1Ph:30P40?h<1PhR3
R8>8P`63RH>9PhV3R@64PhB3Q8>4Ph@1Q6^4JhA[Q6^4J`5[Q6^4JhA[Q6/1
IVaVK6I/IV`1JfI[IP040@A<1@401WN@0@6E0@>E0P400i@1001100030@00
00L000<100000@0002L000<10000=0040@03@5X100@100>@0@401@400h81
PP03PP@11H<00`63P`06P`0Y0F^3Jh=[Pf^3J`5[Pf^3Jh=[Pf^30F]VJfI[
IV]VJ`5[IV]VJfI[0FH010401T`10D`1C0L100N@0IF@U@6E008100=f0@40
A0000`40000600030@000040000X0081=P030@05@Em10El00P400iF@0@03
0@0;PP41PX>2Ph:30H<01040;h>80HV3RH>9PhV30H>4PhB3Q8>4P`5[Q6^4
JhA[Q6/1JhA[Q6^4Jh@1K6I/IVaV00@100IVC6I<IP43C0D100@a0I010iD4
0@03N`4004H000<100001@000`4000010000:P000`40000e00<100EJ@05J
M`020@04Si01O@8100=U0@4018801P62Ph:3PPD11X<08063Jh=[Pf^3Jh<1
Pf^3Jh=[Pf/1IV]VJfI[IV]V0FI[10400d`1C005C0T100Da0I01U@040@04
N`410DP000<100001@000`4000010000:`000`40000f00D100EOMel1T00:
0@0<Ph81PX>2Ph:3PP6210406XV30H>4PhB3Q8>4P`5[Q6^4JhA[Q064JhA[
20402VIUIVEV0FI<IT`40@03C04100D100R@0@41U@6EO081B`000`400004
00030@000040000/0081>0080@03Si01008100F20@5UPP030@0=Ph:3PX>2
P`63IH=UP`0J0@0=IFIUIVD1C6I<ITaV0@02C0<100A<0@5<0`4014d10G42
0@06UGL10IEk0P5=00030@0000@00@410040000^00030@0003L00P4015X1
Mel20@03UI01008100Em0@62O@060@0^Ph:30H>2Ph:3PP5[Pf^3Jh=[Pf/1
IX=VPfJ3IX<1JfI[IV]VJfH1IFIUIVEVI@<10d`60@05C@41M`400iD00`5l
0@020E0000<100000`010@400@0002l000<10000>0050@04M`41S`L100IU
PP62IH860@0SIH=UPfD1IH=UPfF3IH<1JfE[IF]UJfD1IFIUIVEVIFH1IT`0
1P45C0@100E=0@6@L@080E8000<100000`010@400@0003000P4i00P100F@
U@41R0050@09OH9mPWf20H=U00@101N30H=[Pf^3Jh=[0FJ3IX=VPfJ30F]V
J`080@04C6E<0@A<1@401FL10GN@008100Al0@6E0P5E00030@0000800@41
0040000b00030@0003P00P401D500EYg008100>?0@400`400fD10@020@09
PVF20H9UPVF201L100]UC6E<0DaUC6E<I@050@04C041C@<100Aa0@6E1@5H
00050@0000400P0003<000<10000>@020@05@4410El00P4019D10HP30@03
OH8100D1025UPfF30H=UPfF3IH=U0FF3IH=UPfF30FIUIVEVI@5<ID`01@43
C0D100=gT0401P5L00040@000@80000d0081>`080@03T8l1008100>30@40
0P40189U0FD40@03PP5U00IU00<1IFD01FD0105UC6D80@03C6E<00L100=a
0@400P4017`10@5O00040@000@80000f00030@0003X00P401D110@5O00<1
00J@0@41P`h70@03P`4101<100MVIFIU0DaV00P100Mf0@41O9El00<1HP00
0`400@020000=`000`40000i00030@0000800`42G`8100>@MP400`401HT1
RH>900L100B2IH811fD0105UIFD<0@06L@410GMl105V00030@010040000h
0081>@000`400005008100=OMel010400i010@030@07RH>90HV3R@0F0@03
Si0100<100=l0@400`5Z00810@0003X000<10000=P000`40000800D100MO
0@5fT7J@01H100EaT741L@040@03O7L100D1K0020@40000k00030@0003D0
00<100002P050@05GgMOMel01`401hn@S`6?T8l03@400gMl0@030G400`41
0000?0000`40000d00030@0001001`4017MOMelF0G4010440000?@020C@0
00<10000WP040@P0000o00030@00034000<10000VP040@`0001000030@00
030000<10000UP040A0000110081<0000`40002B00@1500004<000<10000
;@000`40002>00@1600004@000<10000;0000`40002:00@1700004D00P4/
00030@0008H0104P0000A`000`40000Y00030@000880104T0000B0000`40
000X00030@0007d01@4X0000B@020BP000<10000N@040Bd0001;00030@00
02D000<10000M@040C40001<00030@0002@000<10000L@040CD0001=0003
0@0002<000<10000K@040CT0001>00818`000`40001Y00@1?@00050000<1
000080000`40001U00@1@@00054000<100007`000`40001Q00@1A@000580
0P4O00030@0005d010590000E0000`40000L00030@0005T0105=0000E@00
0`40000K00030@0005D0105A0000EP020A/000<10000D0050ED0001H0003
0@0001P000<10000C0040EX0001I00030@0001L000<10000B0040Eh0001J
00815`000`40001400@1HP0005`000<1000050000`40001000@1IP0005d0
00<100004P000`40000m00@1JP0005h00P4B00030@0003T0105^0000H000
0`40000?00030@0003D0105b0000H@000`40000>00030@000340105f0000
HP000`40000=00030@0002d0105j0000H`020@d000<10000:0050Gh0001U
00030@0000X000<1000090040H<0001V00030@0000T000<1000080040HL0
001W00812@000`40000L00@1R`0006T000<100001P000`40000H00@1S`00
06X000<100001@000`40000D00@1T`0006/00P4500030@000100106G0000
K@000`40000200030@0000`0106K0000KP001@40000100X0106O0000K`02
0@03004000D0106S0000L@020@80106W0000LP030J/00000
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{288, 269},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Chapter 4: J. Waldvogel's Christmas Picture", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(With[{c\  = \ Pi \((1\  + \ Sqrt[5])\)/2.0, \ 
          x\  = \ Range[
              10000]}, \n\ \ \ \ \ \ ListPlot[\({Re[#], \ Im[#]} &\)\  /@ \ 
            FoldList[Plus, \ 0, \ 
              Exp[I\ c\ x^2]], \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ PlotJoined\  \
-> \ True, \ AspectRatio\  -> \ Automatic, \ Axes\  -> \ None]];\)\)], "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003?0001HPP10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcoll0003?0000c`000<l0003?0000c`000<l0003?0000b@000`400003
0000b@000`4000030000b0000`4000040000b0000`4000040000a`000`40
00050000a@040@H0003400<120000<H000<100001P000<@010470000`@04
0@0400410@H0003000<100<00@002@000<<00`490000a0000`4000080000
`@020@03004000T0003200@12@000;/00P4010010@040@03004000L0002j
00L10P000`4000030@H0002m00<100<00@0030000;l00`400`01000:0000
_`040@`0002l00030@0000<13@000;d000@100000P4<0000_@0010400042
00030@0000T0002h00030@0000801`4;0000^0020@800P40100100020@/0
002`00<100@00@003`490000/`040@0600410@010P020@800`490000/`00
0`400@030@0400410@8000H100000@030@L0002e008100<00@000P4C0000
]@000`400@050@<00P4=0000^@070@l0002h00@100<00@4040000;@000@1
00001`4@0000]@001040004300030@000100002e00030@0000@000<10000
40000;@00`4300D100<00@003@000;@0104200D100<00@003@000:d000<1
000010030@03004100L13P000:d00P4400h13P000:L000<100000`020@@0
00@100400`4300<13`0009l00`400`01000200810`030@@020400`010@05
0@`0002O00`100<00@4040400`010@020@`0002R00030@0100@100<00@40
104200811@020@<01@4<0000Y0020@03004100L100<00@400P4300811002
0@800`4:0000Y@000`400@0;0@03004000800P4400060@0000400P490000
Y@00104000020@800`4010010@4400030@0000T010470000Z0030@030041
0080104800030@000100002X00L10P030@03004100@00P4B0000Z0020@@0
1P4200H14`000:d03@4E0000YP000`40000300h15@000:L000<100000`03
0@04004100@15`000:L000<100000P000`400@090AL0002W00810`020@@0
1`4F0000YP040@800P4400@16@000:L00`4300030@0000<00P4J0000YP02
0@03004000@00P4200<16@000:D010400`010@0400L110020A80002V00@1
00<00@4010080@800P4B0000W0000`40000700L110040@04004100<14`00
09`000<1000020050@03004100`1500009`00P4600P100<00@403@4C0000
TP000`40000700811@000`400@0=0@03004100D1500008`000<100000`02
0@L00`46008100<00@401P4200T15@0008<00`400`010@0300030@000080
0`4500D120001@400@4000D10P060@03004100@000<100003@0008H000<1
0040104300D10`090@04004000`100<00@00304?0000R@000`40000:0@80
00<100402P4200T100L00@41004000@100<00@400P4?0000R@000`400@09
0@03004000h100<00@003@400`010@070@l0002400@100<00@400P020@80
1`400`010@060@03004100<10P000`4000020@0400410@<02P4@0000R000
0`400@030@03004100P100<00@401@401P010@400@D01`4300X100<00@40
300008/000<100405@400`010@020@D00`4500h1300008/000<100400`42
00D100<00@001P400`010@030@030040008000@100011P030@<01`4<0000
SP020@800P400`010@0;0@03004100<110000`400@0600030@0100@0204;
0000S`000`400@0B0@8000<100000`000`400@0=00040@0100<100<00@00
2@0008l000@10000504700030@0000l000<1004010480000TP000`400008
0@03004100D100<00@003@000`40000<00030@0000P0002B00030@0100<1
00<00@400`4300P100<00@001P030AX0002B00040@0000P100<00@401P40
10010@030@03004100<16`0009D000<100400`0A0@03004100D16`0009D0
00<100001@400`010@070@03004100D100<00@007@00090000<100000P00
0`40000200040@0100D100<00@401`400`010@0O0000T@000`4000060003
0@0100@10P0;0@03004101h0002A00030@0000H010400`010@0:0@030041
00<17P0009000P4600<100<00@003@400`01000Q0000T@020@H05@4Q0000
T0000`400006008100<00@400`400`010@040@03004100<18@0008l00`46
00030@00008000<100000P030@040041008100<00@408@0008l000<10000
0`4300030@0000800P43008100<00@400P400`0100030B00002@00D10`00
1@40000100D02@4300030@0001h0002A00812@000`40000500030@010081
9P0008h01P4800030@0100@010400`010@0U0000S@070@/000<100000`40
0`010@0200030@000280002>00030@0000<100<00@000P4600`12P000`40
000G0000O`000`40000=008100<00@40104700T100<00@401P001@400001
01T0001o00030@0000h01`4800l10`000`4000020AT0001o00030@0000h0
00<10040104300040@0000810P0:0@03004100810P000`40000I0000K`00
0`40000<00030@0000`00P400`0100020@8000<100000P000`400@020@03
0041008100<00@403@4J0000E@030@8000D100000@0600030@0000L000<1
000030020@X01P43008100<00@000`020@03004100D100@00@410P050@04
00410A/0001H00<10`000`40000400030@0000H00P4;00@12P060@030041
00D100<00@4010400`010@040@03004100<100D00@400@0200816`0005P0
00<10040104400<11`0010400@4;00<13P080@030041018100<00@400P40
1@010@0101/0001K00030@0000<100@00@412@000`400@0:00@13P000`40
0@030@806P4200@16P0005/000<100401`400`010@0300H11P0:0@`01@42
00050@0000400P000`400@030@03004000l1700005l00P4200H10P050@T0
00@100400`4=00810P020@D000L10001004001@1700005h00P4200810`04
0@030041008100<00@401`050@0600410@011000104000070@@01P430004
0@0100X100@00@0120000`40000A0000GP020@030041008100@00@402040
0`010@020@800`401001004400<10`000`4000030@03004000/11P001040
0@080@<00P4500030@0101<0001N008110060@030041008110000`400@02
00@100<00@400`020@03004100l100@00@410P040@03004100d10P050@80
0`4C0000I0060@03004100810`0:0@801P401@010@4000<10`020@801040
0`010@0200@10P030@03004100h10P030A@0001S00H10P050@<00P401001
00040@03004100<10P020@0600410@010P001@40000100800P400`010@02
0@03004100H10P070@03004100<10P0010400@4D0000I@020@801@400`01
0@040@04004000L11@000`400@02008130080@80304200@10P060A<0001U
00030@0000@100<00@001`4400L11@020@0400400@`000@100400P401001
000I0A@0001T00811P020@0500400@003P4500@100<00@002@050@040041
0@@04P400`010@020AD0001T00811`0<0@801P4200P13@020@03004000<1
00<00@400P400`010@040@03004100T10P030@8000<100003@0006d02@42
00L100L00@41004000@100@00@400P4800811`000`400@0@0@0400410@80
0P4300030@0000d0001/00@100<00@400P4300D10P000`4000060@030041
00<12@050@03004100<100<00@401P400`010@030@03004100P100@00@41
3`0006/00`400`010@040@8000H10041004500040@000@<000<100402P04
0@H00`4500D10P050@<02@4?0000KP080@801P4500030@01008100<00@00
3@000`40000500<110020@H01@400`010@0:0@03004000/0001^00D10`00
0`4000060@<01`4>00030@0000D00P400`01000200030@0000D000<10000
2@4500030@0000812`0006d010400`010@050@0500410@000`4300@100<0
0@002`000`40000500@10`000`40000600030@0000<100<00@400`4500D1
2`0006`00P4300T100<00@4010050@05004000402`000`40000700030@00
00/000@10041100010400@020@<000@100000`490000K@020@8000<10000
0P060@@000@100000P400`010@040A<000<100003@000`40000400D11`00
0`4000020@L0001/00030@00008000<1000010001040004900H150000`40
000D00810P020@`000<10000100006`000<100002@001P400@400@H00`40
0`010@0E00030@0001@000<100000P020A80001[00813P0010400@4400L1
1@000`40000=00030@0001P000@100014@0006`000<100002`030@040041
0@<01P4600030@0002X00`4?0000K0000`40000;00030@0000h11@000`40
0003008110020@@00P4[0000K0000`40000600810P020@03004100H100<0
0@400`4300H110020@<01P4]0000J`020@X00P400`010@0300050@010040
0P030@@000<100400`4200030@0000<100D00@400@0_0000J`000`40000:
00H10P000`400@0:0@801@400`0100030@030041008000<10000;@0006X0
0P4<00030@0100<10P020@0700400@0100020@<01@400`010@040@030041
0380001Y00040@000@`000<100001`400`01000300030@01008000<10040
2@4200030@000300001/00<12P030@03004100800`4500X100<00@400P44
00030@000300001Z00D11P070@030041008000<1004010050@03004000<1
00<00@400P4g00002@020F0000<1000020080@03004000@100<00@000`03
0@04004000H1=`0000/000<10000FP050@X01P4300030@0100800P4400@1
00@00@410`020CL0000<00<1F0000`4000030@X00`4300030@0000801@43
00L11`000`40000d000030000`400@0300030@0005L00P4600D12@0=0@03
004003d0000=00D11P000`40001>008100D00@4100020@<01@48008100<0
0@400P4200810P030Cd0000>008100<00@001@000`40001?00L110020@d0
00<100000P400`010@040@03004003`0000>00030@0100<100<00@400P4:
00030@0002P000<100006@040@H000<100003P040@8000@100000P4n0000
4P050@`000<10000:0000`40000F00050@0100400P000`40000300030@00
00d02P4010010@4m00004@030@800P400`01000500@140000`40000G0003
0@0001<00P400`010@040@03004000<000<100003P000`4000050@8000@1
0001?@00014000@100000P4200810P070A0000<100005P000`40000C0003
0@0000D100<00@405@000`4000040@L000<10000>`00014000<100001042
00030@0000H13`030AL00P4H00P16@000`400@0800030@0003X0000G00`1
3`020AL0104F00040@0000H100<00@002`000`40000700030@0004D0000F
008100D00@4100020@05004000402`050@03004001<00`4I00030@000080
0P400`0100020@`000<1000010040DH0000E00L100<00@400`4200030@00
00<00P4500050@0000405@020AX000@100010P070@03004100L000<10000
10050@0300400480000G00811@000`400@050@H000<100400P040A@0104J
00P100<00@400`4900<10P070@0300400480000F00810`070@8010440081
00<00@400`4A00T16@0:0@03004000/00P401P010@01008100<00@40@`00
01D00P4300<100@00@410`040@802P4B00D160000`40000200030@010081
00@00@413@040@0500400@00105400005@020@H000<100400`400`010@03
0@03004000H150000`400@030A<000D100000@0200810P090@X010401001
0@020@0300400081@`0001l00`400`010@030@03004100L10P000`400007
00811P020@03004101000`4010010@060@8000<100400P000`400@050003
0@0000D00P400`010@060@800P5100007`090@03004100L10`000`400008
00050@010@001`4B00030@0100@100@00@410P020@<00P4600030@0000<0
1`4200030@0100@100<00@0030000`40000_00007P090@03004100L100D0
0@000@0;00@10P040@03004001800P401P01000100@100H00@0100460081
00<00@400P4400<10P060@03004000`000<10000;`0001`02`4200T10`03
0@T000@100410P070A<00`401@010@4000H100@00@411@050@04004000<1
1@000`4000040@X00`4b00007P000`400@050@03004100L100@00@410`00
1@40000100@000<10040104200H14P001@40004000D10P050@<01P4200<1
0P030@<000@100401@4600040@000C@0000N00030@01008100@00@410`02
0@0400410@H00`400`010@0400P10P000`400@0D00H100<00@400`400`01
00030@<03`4600030@00008100<00@4010040C@0000N00H11P060@@000D1
004100020@@00`401@010@40008100D00@000@0C00X10P000`400@0200l1
00<00@400`4400D10`001P4000400CH0000M00D11@0:0@@00P400`010@03
0@0400400@8000<100000P400`01000300<140070@03004000800`4200H1
00<00@401P4200<11@030@<0204f00007P000`400@0300L100<00@401043
00l10P000`400@0500030@0100<000<100000`000`40000300@10`000`40
000401<10P020@H00`4300050@010@000`4f00007@030@<000@100000P40
0`010@020@8000@100401@42008100<00@001@4400030@0100@01@450003
0@0000@00P4200@10`030@030041008100D00@4100020@802@400`010@09
0@800`400`010@0e000070020@03004000L000D100400@0200030@0100L1
00<00@000`030@03004100<000@100010`030@03004100@00P4300@11004
0@03004100D0304200810P020@03004100L100<00@400P400`01000g0000
70000`400@0:00040@010@800P400`010@030@0400400@<000@100400`42
00X100@00@401@4600@100H00@41004200030@0000<00P4200810`040@L0
204300D1>@0002`0104200L100<00@0010001`4000400@000P400`010@03
0@0500410@000`400`0100030@800P4200T11P030@0400400@@000<10000
1P030@03004100810P000`400@030CT0000[00030@0000L100<00@400P46
00L100<00@4010401@010@4000<10`050@03004100D100<00@401P400`01
00070@D000<100400P401@010@4000L10P040@03004003L0000[01011@03
0@03004100L11@040@030041008100@00@010`000`400@050@04004000@1
0P020@03004100810`000`40000200<100<00@40204200040@010CP0000[
00030@0000T100<00@000`401@010@4000D100@00@410P000`4000020004
0@0100<10P040@D00P4200030@0100800P401P010@400@8000@10041200?
0@030040008000<10000=@0002L00P42008100<00@401P401@010@4000<1
00<00@400`400`010@040@8000D100000@0200D10P020@H000<100000`05
0@801@4300@100<00@001@000`400@0=0C/0000X008100@00@410P0<0@<0
304;00040@0000811`000`40000300D10P000`400@0500810P020@@000<1
004010400`0100020@0300400081?00002T01P400`010@050@@00P4300`1
0P020@H000<100000P400`01000500030@0000<000@100000P4400040@00
008100@00@0110030@80104300030@000081?@0002/010400`010@050@@0
10400`010@030@03004100811@020@801P401001004@00030@0100<00`42
00H10P0010400@050@0400410@@00P400`01000i0000:P0010400@070@D0
0P4200h100<00@003@4C008100P00@4100400@<01P401@01004000H10`03
0@03004003T0000Y00X100<00@400`000`4000040@030041008100L00@01
004000<100<00@001P4200030@0101@000D1000100030@<00P4200H100@0
0@001040100100030CX0000W008100<00@401@4300811P050@0300410080
0P4400030@01008100<00@4010400`010@020A000P400`010@0200P11@00
0`4000030@H00`400`010@040@H000@10001;P0002P01P4200<10`000`40
000200@100<00@400P4300040@0000X10P001@40004000814@001`400@40
0@000`400`010@05008100@00@411@070@04004100<10`001040004^0000
:0040@03004100811`00104000070@03004000L000<1000010400`010007
0@03004000h01P4200050@01004010000`4000030@H000<100400`400`01
0@0700@1;`0002P00P40100100050@03004000800P43008100<00@000`47
00070@0000400@0400`130000`400@090@P00P4200<100<00@401@480081
0P000`40000^00009P050@D00P400`0100090@03004100@11`020@<000<1
00400P050@<000<100003`0010400@020@800`4800<10`020@03004100H1
00@00@40204_00009`020@H000<100400`060@04004100810P030@D02@42
00050@0000405@020@<000D1000100020@T000<100000P090@@010400`01
000a00009P020@L00P44008100D00@0100020@03004100<100<00@001`06
0@03004100<000<100004P040@T000<100001P020@<01P400`010@030@04
004100<1<P0002D000<100001`030@<000<10040104010010@4500811000
0`4000090AH0204A008100<00@4020400`010@080C40000U00030@0000D0
0`4900H12000104000030@03004100@100<00@005P040@0400410A401P40
0`010@020@03004100X1<00002D000<100001`000`400006008100H00@01
004700`10`020AH00`4D00d100<00@401`4c0000;@030@P00P400`010@03
0@X000<100401P4200030@0101H00`4D00030@0000T100<00@4010401001
0@4c0000:P040@03004100L000<100000P000`40000=00030@0100@100@0
0@000P4B00D14`00104000060@03004000800`4200040@010C<0000Y00D1
0`000`40000900810P000`40000800<10P080A@000<1000060020@030040
00810`040@@00`4b0000;0030@`01@400`01000900<100<00@002P4@0003
0@0001L01@4400030@0000800P4200P10`020BX0000/00030@0100d01P4:
00H100<00@400`400`01000A00030@0001L01@49008100<00@401@450081
:P0002X000@100011@000`400005008100D00@400@0:00H100H00@01004C
00030@0001L00`4=00030@0000D110030B/0000Z00D11@000`40000300<1
0P060@<01@400`0100050C0000<1000040020@04004100D1;00002801040
100100060@D00`401001004300@100<00@401@0;0Bh000<10000400=0B/0
000S00L10P000`400@030@<00`4300030@00008100<00@401@401`010@40
0@00104200030@0003h0304]00009P050@D000<1000010050@03004100D1
00@00@400`40100100040D801P4200D1;@0002H01`4900<10P030@<00P40
10010@42008100@00@400P400`010@040@D000<10000=0040@8000<10000
0P430081:`0002L01@4900040@0100D10`00104000040@802`4700030@00
03D000<100001P000`400@040@8000<100009@0002@000<10000104<00<1
00D00@4100020@@0104200030@0100810`020@P000<10000=0000`400009
00<110000`40000U00009@00104000030@`000<1004010400`0100030081
00<00@000`000`400@050@L00`5100L1:000020000<100000P020@030041
008100<00@001`030@03004100@11@030@800P40100100030@/00P4o00<1
00<00@400P4X000060030@030040008000@100002P4200<10P030@040041
00D100<00@403@4200<10P020@800P50008110001040004W00006`030@03
004100@010400`010@020@@00`4200@10`070@8000<100400`4010010042
00030@0000<01P4900030@0003<000<100001@001040004U00006`040@03
004100<100<00@401`4300<10P040@8010400`0100050@8000<100401`40
1`010@400@000P4010010@4500030@0103/00`400`01000T000070000`40
0@070@0500400@000`401001000:0@0400410@<00`400`01000500030@00
00<100<00@400`060@P00P4j00040@0000819@0001T03@401@01004000L1
00@00@410P060@0500410@000P4010010@4800030@0100<10P060@030040
00H00P4600030@0003H00P4T00007@060@03004100@000<100000P000`40
00020@03004100L100<00@400P4200030@0100T0104300D100<00@400P43
00030@0000@11@000`40000d00040@000B<0000N00040@0100@100D00@40
0@03008100D00@4100020@800`4500<100@00@412@040@@01`400`010@02
0@<00`4300040@000@<00P4d00030@000240000L00030@0000/11@050@03
0040008000<100401@020@03004100<1100:0@8000<100400`4300<10P05
0@03004100800`4200@100<00@40;`000`40000P000070000`4000090@L0
1P4600810`020@03004100800P4200030@0000800`4010010@4200D100<0
0@00104200P100H00@400@020@0400400E@00006008150001040004200L1
1P030@0400410@L000<100000P060@03004100D00P400`010@080@030041
00H100@00@410`050@03004100<000<10000E00000P00`4300030@0000<0
00<1000010020@D00P400`010@0500@11@000`40000;00L11`040@8000<1
00404@400`010@020@@000<10000F00000P000<100400`000`4000030003
0@0000D00P4200@10`000`40000200030@0100814@070@03004100D02042
00030@0100@01P4010010@42008110000`40001H00002P050@@00P4500<1
00@00@001042008100@00@415@040@03004100@10P060@030040008000D1
00400@03008100@00@411@020F00000:008100<00@400P401001004400T1
0P080AD000<100400`030@800P400`010@060@@0104200L11P000`40001N
00002P000`400@0:0@8000@100403`4H00D100<00@400`400`010@030@80
00<100001`43008120000`40001N00003P030@800`400`010@040@030041
008100<00@401@400`01000I00040@0000@10P020@0500410@000`420003
0@0000<100<00@40JP0000h00`4010010@4200040@0100D100<00@401042
00@100<00@005P000`4000050@<02P4700@1J@0000d00P4200@100@00@41
1@090@03004100D15@070@@01@4300040@010@P000<10040J@0000d00P40
0`010@020@03004100<10`060@03004100@100<00@400P4F008100@00@41
1@050@800`490081JP0000`000<100400`4300810P001P40000100T100<0
0@401P4B00<100<00@400P4200030@0000T100@00@4120000`40001W0000
3P001040004200@10P0010400042008100<00@400`4200810P020@030041
00D000<1000020030@80104010010@45008100@00@412P000`40001W0000
3@00104000030@0400410@800P400`010@020@8000@100400`400`010006
00030@0000<000<100001P00104000020@04004100D100@00@400`400`01
001d000030000`4000030@800`4200H11P001@400@0100l000<100003000
1@400@4000D10`050GD0000<00810P070@03004000<100<00@400P430003
0@0100<13@020@h01@4200030@0000800`4010010@5d00002@030@801040
0`010@0<0@D000<100000P000`40000;00813@040@/00`5e00002P030@05
00400@003`4200D140020@X000D100000@0300030@0000T000<10000M000
00D00`400`0100090@03004100H10P030@801@4>00@12@020@03004000<0
00<1000020020GH0000600030@0100H100<00@001`400`010@0200030@01
00810P020A4000<100400`4600D140000`40001c00001@0020400@400@01
1P070@8000@100400P401@010@0101401@4400030@0100800`4?00030@00
07@0000500030@0100@110000`4000020@800P4400030@0100<100@00@41
1@000`40000900<10P030@03004100@100<00@403`000`40001c00001002
0@040040008110040@<000<100000`030@@0104400030@0000H010400`01
0@0400030@01008100H00@01004300030@0000P000<10000L`0000D00`43
00030@0100801@4700X11P000`40000500050@000@00104020010@010040
104200<1P@0000D02`401@010@0100T000<100000P000`400@0600<12@02
0@<0104200040@0000D1P`0000L00`400`010@050@800P4700030@0000D0
0P4400@11`020@030040008000@100400P43008100<00@400P6200001`00
0`4000030@050041004010000`40000400030@0000800P401@010@4000H1
1@000`4000040@03004100<10P080@0300400840000800040@0100<100<0
0@40104300810P000`400002008100<00@402`4010010@080@800P4200<1
0`000`40002200002P040@802@4300030@0000<01@4200L10P040@8000<1
0000204010010@430081P`0000P020400`010@020@03004100@000<10000
0P070@03004100D100<00@40104600D100<00@400P060H80000800H100<0
0@402042008100<00@404@401P010@400@80204200<100@00@410`020H00
000700<10P000`4000050@0500410@000P400`010@0B0@8010401P010@01
00D1100:0H00000600030@0000L000H10001004200040@0100@10P0:0@03
004101<10`040@0300410081P@0000D000<1000020000`400@030@<00`42
00040@0000P100<00@404P4600<100<00@400P62000040040@8000<10000
0P43008100<00@0020400`010@080@0500410@00104600030@00008000@1
00411`000`40001g00003`060@802@4010010@040@03004100`10P030@80
00<100000`000`40000400<100<00@0010000`40001g00003`0:0@040041
00@10P0D0@800`4200811`00104000050@800`5j00003P000`40000300@1
0P000`400@070@0500410@000P4200050@010@00104500H11`000`400@03
00810`000`40001i000050040@H00`43008100<00@000P4400<100<00@40
0`4300@100@00@411@000`40000400D1N`0001D00`4500@10`080@802042
008100<00@400P4900040@010@8000@10041O@0001@00`400`010@0200l1
0P000`4000020@0400400@801@400`01000700H100<00@400P5m00004`02
0@800`4200030@0000D10P050@D010400`010@020@03004100<12@001040
00050@03004101800P5W000060001040004200D10`030@03004100810P02
0@<00P4400030@01008000@100410`040@0400410@8000@100011P000`40
0002008100@00@41J@0001P000<1000010001040004500D10P020@D000<1
00000P040@030041008000D1004100060@D000<100000`030@@00`5[0000
5`030@D000<100001P030@H000<100000`000`40000400@100<00@402@43
00H10P000`4000030@8000<10040J`0001T000@10000104200030@0100H1
1@000`40000300@10P0;0@03004100@10P001@400@0100<000<100400P40
0`010@1^000050000`40000200040@0000D100<00@000`050@<000<10000
10040@800P400`0100070@03004100H100<00@401@42008100<00@40KP00
01D000D10001000:0@801@401@010@4000811P040@07004100400@0200`1
00<00@400P400`010@040@<000<10000K00001D01P4200060@000@011000
1@400@4000D11`050@03004100<100<00@401P4200810`040@0300410081
L`0001D01@400`01000300<100@00@000P400`010@020@X00P400`010@06
0@801@400`01000200<100<00@400`400`010@020G80000F00H10`080@80
1P4901<10P020@03004100810P00104000030G80000F00<100<00@400P08
0@<000@100400`4800030@0100800P400`010@030@03004100<100@00@00
0`4200D10P000`40001a00005@000`400@0?0@@00P400`010@0200030@00
00`100<00@401`4400D100<00@0010020G80000G00P10P0=0@0500410@00
104010010@080@03004100H10P080GT0000G00050@010@000P4300<100<0
0@400P400`0100040@03004100D10P0A0@03004100@10P030GP0000?0081
10080@03004000L100@00@410`0010400@4200030@00008000<100401040
0`010@0;0@800`401001005h000040020@801P4200L10P000`4000020@L0
00D10001000:0@08004000400@050@<00P4010010@5i00004@030@060041
0@010P030@8000<100400P400`01000800L100<00@40204300030@0000@1
0`020@800`5h00004@040@03004100<100<00@0010000`4000030@X000<1
004010400`010@040@03004000@000<1004020400`010@020GP0000@00X1
0P000`40000300@100<00@001`040@03004000<100@00@401@400`010@02
0@030040008010440081N00001002@401001004400040@00008120002@40
00400@0100020@03004100<01@4300030@0100@11`020GL0000<008100@0
0@410P000`4000040@T00`4=00D100<00@000`020@03004100811P000`40
0@0800030@0007D0000=008100<00@400P001@40004000<120000`400@0=
00L110050@03004000D000<10000P00000d000<100400`4600812`000`40
000=00810P000`40000200040@0000811@030H80000<00050@000@000`47
00030@0000T000<100002@050@/00`4200060@010@010P000`40001l0000
2P040@D000<100004P000`40000700<100<00@002P0?0Gh0000:00040@00
0BL010400`01000700H100<00@000P400`01001n000020030BX00P440003
0@0000@01`400`0100030H00000700030@0002X00P4600<10P040@030041
00@100H00@01005m0000=P000`40000300<100@00@403`5m0000=P000`40
000300H100<00@400P400`010@050@03004107d0000f00030@0000<03`40
0`010@060G/0000f00030@00008010400`010@090@03004100D100<00@00
N@0003H00P4200H100<00@400P4010010@4800040@000@T000<10000KP00
03H00P400`010@0200T100@00@012`000`40000500030@0006l0000c0003
0@0000T10P070@0400410@<000<100002@020@@00P5/0000<0020@050041
0@002@400`010@020@800`400`01000300030@0000<01`4010010@5^0000
;`001040004200H100@00@401`4200810P001P40000100810`0010400@05
0Fl0000f01@10P000`4000040@03004000D100D00@400@1_0000<P001040
000@0@800P400`010@020@03004100L100<00@400P5a0000<`000`400@06
0@030041008100<00@000P4400H100<00@401`400`010@1b0000<`020@03
004100800`400`010@070@<00`400`010@0;0@0300410740000c00D10P00
0`4000030@8000@100403P400`010@0200050@000040L@0002l00P401@01
0040008100<00@000P030@03004100@010400`010@090@03004007D0000]
00<100@00@410P030@@000<100401`0C0GD0000]00030@0100<000<10000
0P000`40000400030@0000@00P400`010@060@0500410@00105e0000;000
0`40000A00030@00008000<100004P5e0000@0000`40000500@10`060@06
00400@01M00004P0104300L1N@0004L00`4500030@01008000<10000N000
04T000@100000P4200@100<00@00M`0004T000D1004100030@03004100<1
N00004P000<100000P090GT0001800030@0000800`400`010@050GL0001=
00`1MP0004X000<100001P400`010@040GD0001800030@0100@100@00@41
1`000`40000300030@0006`0001700030@0100T13@020Fd0001700d100<0
0@401P040Fh0001400h110020@801@5`0000@`000`40000=0@03004100X1
K`0004<01`400`0100030@<02P4200030@0006d0001200030@0000@000@1
00000P4400P100<00@00L@0004h000@100002`5b0000E0020@801P5a0000
D`020@<000<10040M00005<000<100000`000`40001c0000D`0010400@42
0081M00005<000<100001P5c0000EP070G80001C008100<00@000P430003
0@0006l0001C00L11`000`40001[0000D@090@04004100<1KP0005000P40
0`0100020@0500410@000`5`0000D0000`40000300040@0000H1K`0005T0
1@400`01001^0000FP001040005a0000FP000`4000020G00001K00D1K`00
05/00P5b0000F@050@<00P5/0000F0000`4000070Fd0001N0081K`000600
00<10000K00005h00`5^0000GP020@03004106`0001M00060@000@01K000
064000<10000J`0006000`5/0000HP000`40001Z0000HP000`40001Z0000
H`000`40001Y0000H`000`40001Y0000c`000<l0003?0000c`000<l0003?
0000c`000<l00000
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{207.062, 354.812},
  ImageMargins->{{45, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Chapter 5: Sphere With Random Holes", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[\ 
        Graphics3D[
          Select[Sphere[1, \ 72, \ 54], \ Random[] > 0.5 &]]\ ];\)\)], "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`400049000180P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgMo000>OWifm_K`00V@00
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcool02P000;000P5G0000[P020@03004105H0002/00810`020EH0002Y
00<11@000`400@1E0000Y`020@P000<10040E@000:@00`4:00040@000E@0
002R00813@001@40000105<0002P00813`001@40000105<0002M00<14@00
0`40000200030@000500002K00815@000`40000200030@0004l0002I0081
5`000`40000200030@0004l0002F00<16@000`40000300030@0004h0002D
008170000`40000300030@0004h0002B00817P000`40000400030@0004d0
002?00<180000`40000500030@0004`0002=00818`000`40000500030@00
04`0002:00<19@000`40000600030@0004/000280081:0000`4000070003
0@0004X000260081:P000`40000700030@0004X0002300<1;0000`400008
00030@0004T000210081;`000`40000800030@0004T0001o0081<@000`40
000900030@0004P0001l00<1<`000`40000:00030@0004L0001j0081=P00
0`40000:00030@0004L0001g00<1>0000`40000;00030@0004H0001e0081
>`000`40000<00030@0004D0001c0081?P000`40000;00030@0004D0001`
00<1@0000`40000<00030@0004@0001^0081@`000`40000<00030@0004@0
001/0081A@000`40000=00030@0004<0001Y00<1A`000`40000>00030@00
0480001W0081BP000`40000>00030@000480001T00<1C0000`40000?0003
0@000440001R0081C`000`40000@00030@000400001P0081D@000`40000@
00030@000400001M00<1D`000`40000A00030@0003l0001K0081EP000`40
000A00030@0003l0001I0081F0000`40000B00030@0003h0001F00<1FP00
0`40000C00030@0003d0001D0081G@000`40000C00030@0003d0001B0081
G`000`40000D00030@0003`0001?00<1H@000`40000E00030@0003/0001=
0081I0000`40000E00030@0003/0001:00<1I`000`40000E00030@0003X0
00180081JP000`40000E00030@0003X000160081K0000`40000F00030@00
03T0001300<1KP000`40000G00030@0003P000110081L@000`40000G0003
0@0003P0000o0081L`000`40000H00030@0003L0000l00<1M@000`40000I
00030@0003H0000j0081N0000`40000I00030@0003H0000g00<1NP000`40
000J00030@0003D0000e0081O@000`40000J00030@0003D0000c0081O`00
0`40000K00030@0003@0000`00<1P@000`40000L00030@0003<0000^0081
Q0000`40000L00030@0003<0000/0081QP000`40000M00030@000380000Y
00<1R0000`40000N00030@000340000W0081R`000`40000N00030@000340
000U0081S@000`40000O00030@000300000R00<1T0000`40000N00030@00
0300000P0081T`000`40000O00030@0002l0000M00<1U@000`40000P0003
0@0002h0000K0081V0000`40000P00030@0002h0000I0081VP000`40000Q
00030@0002d0000G0081W0000`40000R00030@0002`0000G0081W0000`40
000R00030@0002`0000G00030@0109/000<100008`000`40000[00005`00
1040005Y00/19P000`40000S00030@0002/0000F00030@00008000<10000
G@0M0Ad000<1000090000`40000Z00005P000`40000300030@0005P0:@4E
00030@0002D000<10000:@0001H000<1000010000`40001E018100IUC6E<
ID`30@03004101414@000`40000U00030@0002T0000F00030@0000D000<1
0000D00W0@9U304?00030@0002H000<10000:00001H000<100001P000`40
001<00h100M<ID`1C6E<00@100=lM`400`040@=U0P400emg0@090@03I@41
00@130000`40000W00030@0002L0000F00030@0000L000<10000A`050@<0
104016E<I@42I@h1100?0@03I@4100/12P000`40000W00030@0002L0000E
00030@0000T000<10000A00;0@03ID`100H10`020@D02`4300090H=UPfF3
I@5O00@100Am0@5J204800030@0002P000<100009P0001D000<100002P00
0`400010010100EUIVD100020@800P400iD100020@0<005VPfJ3IX<1Pf^3
3`401@010Emg00X11P000`40000X00030@0002H0000E00030@0000/000<1
0000?P0<0@04C05<I@H100=gU@400P040@07T7L10H=UP`080@04IH=U0@80
00D1MgL1JP080@03MeX100<100=J0@40104400030@0002P000<100009@00
01D000<1000030000`40000k00L100JE0@41C6H50@=V0P400`010@0>0@03
Pf^300h100<00H<00h<?0@0400410@8000<10000:@000`40000T00005@00
0`40000=00030@0003T010400`010@020@030041008100D00FI<IP070@0N
JfI[0F]VJfI[IV/1PfJ3IX=V0GL1M`5g0@01Jh=[1`401VZ3JP62P`D100>2
O@402@4[00030@0002@0000E00030@0000h000<10000=P040@040041U@D1
00BE0@0010403V]VJ`63IX=VPfH1Jh=[3`4017L100040@>30`400`010@03
0@B300<100402`4/00030@0002<0000D00030@00010000<10000<`030@03
N`4100H100==0@401@402F]VJfI[0F]VJ`080@0<Jh=[0F^3Jh=[Pf/10`00
0`400@0400D110080@06P`40005J0`400gd10@040B/000<100008P0001@0
00<100004@000`40000`00H100M<0@41C6I<00P100=[IV/02@404@010F^4
JhA[Q064JhA[Q6^400810`001@5g0@0100800P4200@10gL20@03R8>800<1
0P030@04PP41PPH1:@000`40000R000050000`40000B00030@0002h01@40
1d`10D`1C4d00`4400H100A[IV/10P030@05005[Pf/05@401GH10GMf0081
00=gLGL00P400g5gL@050@03P`4100<100@00H:30`4200@1:0000`40000Q
000050000`40000C00030@0002`00`42008100A=C05<2P4026`1K6I/IVaV
3P404ID1RH>9PhV3R@69PhV3RH>900D100<00@400P4300/100>3R8<00`40
18:3PP4300@19`000`40000Q000050000`40000D00030@0002T010420004
0Da<C0D100b?0@41IV]VJ`5[IV/80@05Jfa[0@000`42008100m[Q6^4JhA[
0F^4JhA[Q6/00P40291f0@5gLGL1100>0@03P`4100D10P040BL000<10000
800001@000<100005@000`40000W00D10P040@03U@0100<100IV0FI/IV`5
0@0<Q6^4J`5[Q6^4Jh@10P0J0@03T04100<10`020@03PhT100@100=g0@40
1@400gL10@090BL000<100007`0001@000<100005P000`40000U00D10P02
0@03U9D1008100IVCFI=0FH40@0<K05/IVaVK6H1Jfa[204038A[Q6/1JhA[
Q6^4J`T100B3RH>930401H>9PhV300<100II0EUg0HP40@03PP4100H19P00
0`40000O00004`000`40000H00030@0002<01@4400D100A[IV]V0`402F]/
Jfa[0F^4J`070@030041008100n9K8U/RFb90HV4RHB9Q8T02@402XV4RHB9
Q8T1RH@60@08RH>9PhV30HP40@04M`6PP`<100>2X0401P4V00030@0001h0
000C00030@0001T000<100008@050@@00P4200030FH100<100I=0FI/IV`6
0@04Jfa[0@<01@403f^4JhA[Q6/1JhA[Q6^4J`040@03T7H1008100j3RH>9
PhV30H>9PhV3R@D100V9PhT1R8>8PhP00`400hP1R0020@03PXR200D19`00
0`40000M00004`000`40000J00030@0001l01@400`01000500<100I/IVaV
0F/40@0:K6/1K8A/Q6b40@<05@400`010@0400D100^9Q8T1RHB9Q8V4R@03
0@03T04100<100L>R0j83P4>008100>30@400P401J010@4000819P000`40
000M00004`000`40000K00030@0001d01`4400<100IV0F]=Jdd30@0;IVaV
K6I/0Fa[K6/01P405XA[Q6/1JhA[Q6^4J`5[RF^9JhU[0@0:0@03004100H1
00B3RH<10P080@06PhR30H>82@400`0100020BH000<10000700001<000<1
000070000`40000K00@100<00@001P4014e/0F`40@0:J`5[K6]/Jf`1Q0@1
01b@0@69K8U/RFb90HU/RFb9K8T1RHB9Q8V4R@401`400i010@0400030HV9
00:91044008100AgLP5b0P401`h13XP1R0h00P4300070@0000620@0U0003
0@0001`0000C00030@0001d000<100006@0010400@050@06S`01ITeV0`40
2faVK6I/0FaVK6I/00<100<00I0010402f^4JhA[Q6/1JhA[01D100=a0@40
0P4300070HV3RH>9P`040@04005gL@<100=aM`400P401XP1R8<1P`811P04
0B@000<100006`00018000<100007`000`40000G00040@0000D100FE0041
C@020@0:K05/Jfa[K6/1J`@10P080@03RFb900P100B4RHB90`401Y010@40
0@B920400i010@020@N900<1LI000`401gL10@01LP400P040@04R0683P81
0`000`400@040B<000<100006P00018000<1000080000`40000E008100D0
0@41C@020@03S`4100<100U=K4d1IVaVK6H00`44008100F?0@41S`060@0<
Q6b4K05/RFb9K8U/1`403P01K8U/RFb9K064RHB92@400hV3R@020@04LGL1
M`8100>80@400P4400030@01008100B3X8<10P040@04>0410B8000<10000
6P00018000<100008@000`40000C008100<00@400Td40@0:0041K6I/IV`1
K0@100=/0@0010070@0BK8T1RFb9K8U/R@69Q8V4RHB90P400hl10@020@03
006900N900<1RHT01HT90@03L@41008100N@0@j93XT>008100<00@400P00
1P680@4>0@<000@1FP51104R00030@0001T0000B00030@00028000<10000
4@080@03C@40008100I=0De/CF`30@05K6I/IP400`060@I/00`1K8A/Q6b4
K05/RF`50@03MP4100T100i/RFb90HV4RHB9Q8T1008100Ya0G41005aM`40
0P4028R9R8V8R@4010401001R0h30@800P400eX10@040B8000<100006000
018000<100008`000`40000?00<100BD0@410Td30@06K4e/0FaV0P400f`1
K003K0D1011/Q6b40HU/RFb9K8T1RFb9204300d100<00@401`43R@070@00
005aT0020@800P42008100F93XT>R@040@08Mg410@j83XP20@03005J0081
00<h0@400`4Q00030@0001P0000B00030@0002@000<100003@030@03U041
00A=00L1CFM=I`5/008100I=K4d1IV`20@03K05/00I/00<1K6`00f`60@05
RFb9K0401@020@05T0410I000P402W6@0@5a0@01L@4400L10`020@05L@41
0G400P4200@100>90G800`401g810@4>R0h020400cP10@020B8000<10000
5`00018000<100009@000`40000;00L10Td30@03K4e/00<116`0105/0@43
K00:0HA/Q6b4K8@1R@@100Y/R@69K8U/RFb90P4400030I0100`10P000`6?
0@0500050GJ@0I000P400`01L@020@05T041LI000P4300<100Aa0@5g0`40
2Ph10HP>0G9I0ET80B4000<100005`00014000<100009`000`40000:00<1
00D00Dd1C@040@09C@41K05/CFa=00<11F`0105/K6`60@0AQ6b4K8A/0Fb9
K8U/RF`1S`400P000`6@0@0200D100Ea0@4100020@8000<1L@401@020@04
T06@L@8100>@0HT010400g5g0@0300040G9aLP8100MaLP41R0j800<100=I
FP400P401J280@6O00<18@000`40000F00004@000`40000X00030@0000P0
1@400dd10@060@04CFa=0@9/0P400`01K004K0D1011/RFb90HU/RFb9K8T1
RFb91P401Xl10@6?0@801@40190108l30@<01@401001LI020@04L@5aT081
00F93XT>R@020@@00P400gMa0@020@08L@410HT>R@h20@03FG8100810Z00
0`67X0030B4000<100005@00014000<10000:@000`40000600D100==0@40
0P4020010Fa=K4e/0`4010010@43K08100<00F`01V`01P5/Q6b4K0H100N9
K8U/0Hl100<01@4017410I020@04090100810P000`69R@02R@X100>@0HT0
1HT00`40000400@10P020@07F@413XP1F@030@03E04100L18@000`40000E
00004@000`40000Z00030@0000@00`400jT1C@030@800`4014e/CF`20@07
S`2?0Hl1K0020@<000X1RFb9K8U/R@6910403Fb:0HY/RVb:K8X1T0400P00
106?0Hl80@03004100D000d1RHZ9RXV:R@69RXV:00H100J93XT>R@4600<1
10050@09R@5ILP5J0@jP008100>P0@400P4Q00030@0001@0000A00030@00
02/000<100000P000`6C0@060@<000D1005/C@020@03K04000L110000`5/
K003K0@100j9K8U/RF`1K8U/RFb9K0810`001`6@0@400G400P400i010@08
00030HV900F900<1RHT01HT00`4000040@03R@4100D000@1R@411@000`5b
F@020@03LUT1008100J8X8P1Qj040B4000<100004`00014000<10000;000
0`4000060@03004000@00P400f`10@03K08100P00@5/0Hl00@<000<1R@40
10405@01RVb:K8Y/RP6:K8Y/RVb:0I0100050@03006@008100>?0@401044
000A0HV:RHZ9RXT1RHZ9RXV:R@401@060@<000@1Y@6U0P4400030G9a00@1
00D00@6P3P020@:P00@1004180000`40000C000040000`40000^00030@01
00D11`030@04K4e/C@@10f`0106WS`4200<100F@S`41T0020@0;K8U/RFb9
K05/RF`0204018U/RF`20@05T0400I000P44R@l11HT00`40000500030HT1
00<100L00HT1R@j900810`020@04FG9I0@800`400j010@050B4000<10000
4P00010000<10000;`050@03<@4000D00`44K0<11F`60@03RP40008100>?
Yhl00P400hY/RP080@800`401hZ9RXV:RHX010400`010@020@0BRXV:RHZ9
RXT1RHZ9RXV:R@401@400hT1000600060HVVRJJ910401:F9YHT20@<00P40
0eUb0@0200030J2U008100<00@400P400cP1000O00030@000180000@0003
0@0002l010400c410004008100E/C@5=K0020@03005/00A/0`45K0060@01
Si2?1P401I01000100L000P1K8U/RFb9K0811P000`69R@06R@030HV900F9
00H10001LHl70@<000<1RHT018T01`690@4>R@h00P4300030ET100810P00
1P4>R0h100<100BO0@417`020A<0000@00030@0002h010400c5=0@020007
0@01CVa>K0030@<000@1K6a/0P4026`1K8Y/RVb:1P400fb:0@020@03Y`40
00X000T1RXV:RHZ9RP401`004@6:RHZ9RXV:R@69RXV:RHZ900810P000`5a
T0020@04RJJ9YPD100VVRJJ9YP6V0JH00P400hT1000300050G9aLP400P03
0@08X0410CQJ0J020A`00`400`01000B000040000`40000^00@100@a0@00
0P401@01K4e/00<11000105/0@43K0030Fa/00=/0`401aE/5F`EK0400P00
0`40000:00040Fb9K1X10hT00`6?0@0200040G410@N900@1R@410hT01P69
0HT>R@<10`00105ILET20@<01@400e@h0@040AP00`4400030@000140000@
00030@0002d00`400c410@0200060JT1005>0P400f`1000300<11F`0105/
RV`40@08RVb:K8Y/RP4;00810P050@<001H1RXV:RHZ9RP6:RHZ9RXV:R@69
RXV:20403`010069YXVVRJJ90HVVR@020@0:YP6VR@69YXT1R@810P001P5a
LP5b0@@010400eX10@030AD00`4700030@000140000?00030@0002h01@40
1@010HnY00@100A>K4h10P020@03D`5/00E/00<1K0400P42S`090F`EK1E/
5F`100<01@4200050Hn:0@000P400hl1000300090AF95HTERAD100R900<1
RHT01HT00`69R@02R@D11HT00`69R@04R@<100T>0@j93P4>R@h00P401`01
0G5DL@4010000eT1E0070A400`4;00030@000100000?00030@0002d00P42
<@030@00008100T0Z@41K5=/Df`00`43K0030Fa/00=/10402XnWSjL1RVb:
K8X60@0:5HXERP400I2?0@@00P44000S0HZ9RXV:RHX1RXV:RHZ9RP6:RHZ9
RXV:R@69ShV?RHn90@0010402jH1YXVVRJJ9YP4000@100N90HVURJF900<1
00=ILUT00`42008100IDFP6T0@020@h00`4>00030@000100000?00030@00
02d00P40134100030@08S`410Di/CV`20@07DfaCK5<1K0040@@000<1Shl0
0P400f`10@020@0:RF`1K8U/RFb9K0<100>:S`401`040@085HTERAF95@47
R@030HV900J900<1RHT01HT20@04LHX1RP@11HT01@40004000@100J93XT>
0JD20@05E741YHP00P402@01E3P1X:@100020@X00`4A00030@000100000?
00030@0002`01042008100Q>0@6Y005/D`8100<00F`00f`30@P000@1Y`40
0P403Vb:K8Y/RP6:5HXERQF:0P4018l10@4601T100^:RHZ90HV?RHn9S`02
0@09L@5aT06@0JJ900@100ZV0@000@01L@690P401ZF90HVUR@<100l>Y@jU
0@01FP6TX:@100401P040A@000<10000400000l000<10000:`050@04004a
CP8100>?ZHl00`401P010@5CK08100=/0@002@006@40005/RFb9K8U/0Fb9
K8U/RF`1RXn:0HX01P4048XERQD15HXERQF:5@5aS`4400050HV:RHX02043
R@070G6:L@5aRP020@J90`400`010@02L@040JF9Y@<100^URJF9Y@6UR:F8
0@0200<100BTX0400P4200<160000`40000@00003`000`40000[00@100D0
0De>C@020@040:T10@<000<100400P400fe/K@020@@00P46000<0HY/RVb:
K8X1RQF:1@401Y2?0Hn@S`8101>:RHZ9RXV:0HZ9RXV:RHX1T8X100@000X1
RXV:RHZ9RXT10`060@0?T06@0@01YXVVRJJ9YP6V008100T00G41RJJ9YXT0
0P401:F9YHT20@04Y@jU0@<00`400j@100040A/000<10000400000l000<1
0000:P070@03CS4100800P4018nY0@020@03S`5/00A/00@1S`400P400f`1
000500060Fb9K8U/1P4078Y/RV`1RXl1ShX1004ERQF:5HXE0AF:5HXERQD4
0@@000X1RHZ9RXV:RHX110001@5a0HV:00@100<00HT01XT00`69Y@050@07
YHVURJD1L@020@04RJD1008100>80@000P020@03Y@4100@170000`40000@
00003P000`40000[00L100==0@000P00106V0:H20@0;00410Fe/KFa]0@00
0P400faaK0020@@00P400hX10@020@0:0041RQF:5HXERP@101F?T0400HZ9
RXV:RHX1RXV:RHZ9RP401`00206:RHZ9RXV:0`44008100JVRJJ9YXT30@0<
RJJ9YXT1RJJ90HVV0`402:J9YXT1LG9a0`400`0100020@<00P401J2U0@40
008170000`40000@00003P000`40000[00D100<a0@400`020@09ZHnY0JT1
K5<100A/0`45K0070Hl10@01S`030@<000/1S`5/RVb:K8Y/0@0300810P00
104ERQD=0@L01@401hV:R@5aS`400`020@07RHZ9RXV:R@060@0;R@6URJD1
YHVU0JD00P401hVU0G5I0E@00P401P010@0100<100<h0J000P4010010@4L
00030@0000l0000>00030@0002X00P42<@030Dha00810P020@03Z@4000<1
00I]K6d1KF`20@0AL@5aK75/LF`1SjN?0HnWS`4010002`6W0HXERQF:5HX1
00L01@403901T06:RHZ9RXV:0@L03@43000>0JJ9YXVVRJH1T76@0I030@0:
YXT1RJJ90HVVR@@100Ab0G9a0P400g9I0@020@8000D1FE@1X0020@030041
01`000<100003`0000h000<10000:P020@04<@41<@810P020@03ZHl10081
00ECK5=/D`030@=/00<1K6`00f`20@:?00<100400Xl01@40000100:?00@1
K8Y/1@4:00030Hl100<100LERQF:5HXE00P100>?L@401@001@69RXV:00H1
00F9RXV:R@020@9a00D1L@4100030@0EYHT1RJF9YHVU0@01LEAaE05DLE@1
00@000<1E0400`4200030@0001X000<100003`0000h000<10000:P020@0C
<@410C41005>0JJY0@01KFa]K0020@09LFaaK75/0Faa008100U/0HnW0@01
Y`400`000`6W0@050@l001T1Si01T06:RHZ9RXV:0I2:0HZ@0I2:T8X100@0
00/1ShV?RHn9S`6VR@040@07YP41LI1a0@0400<100VV0JJ9YXVVR@400P00
205bL@5a0EUb0P43008100ID>06P0@020A/000<100003`0000h000<10000
:@060@08<Dh10DiC0JT20@04005CK08100<00F`01F`30@06LFaa0Hl10`00
104000040@03K04100T00`44000K0HZ?RP6:0AF:5HXERQD1LHma0G6?0Hma
S`40008101000HV:RHZ9RXT1RHZ9RXV:0P42L@8100=a0@000`000`5a0@02
0@05YHVURJD01@401741LE@30@03E040008000<1>5@00P401:010@4K0003
0@0000l0000=00030@0002X00`402@01<Dha0DiCCP020@03ZJH100@10P00
1P5aK75/L@8100M/RVb:K8X100<000<1Y`400P401hXERQF:0JL00P470003
0Hn@00<100<00I004@40192:0HX40@0LT0400Hn9ShV?RHl1YXVVRJJ9YP6@
0I1aT74100@100>;0JH00P4018VVR@4400810g430@03E040008000D1>041
Y@030A/000<100003`0000d000<10000:@040@04005><@8100MCCP41ZHnY
008100J?YXl10043K08100P00G5/LFaaK0<100l00Hn?0HY/RVb:K8X1S`40
1`090@04RQF:5@@100V?0Hma0HV:RHX020404g6?0@69RXV:RHZ90HV:RHZ9
RXT00P400hX1L@02L@810W420@05L@69YXT00P400jD100030008L@410G5D
0HT30@<0204J00030@0000l0000=00030@0002T010400`01<@030@03CP40
008100^YYP41ZJJY0@01L@030@8000H1K8Y/RV`20@0>Yhl1SjN?0AF:5HXE
RQD20@801`4038V:RHX1RXV:RHZ9RP8100>:T040104038n9ShV?RHl1ShV?
R@P101B?RHl1YXVVRJJ90G6@LI01T741R@<100Qa0@6VRJJ9YP810`001@5a
0JFV00<10jD0104000020@03>04100<16`000`40000>00003@000`40000Y
00<10P060@03006?00<100IC0HnV0JH30@<000H1005aK7420@>?00/10041
S`6:K8Y/RP060@0CK8Y/0AF:5HXERQD15HXERQF:5@020@04ShZ?0@8001D1
RHZ9RXV:R@69RXV:RHZ90HV:RHX01`400hZ9RP020@05LHYa0G400P400hn9
S`020@080069YXVVRJH30@0>0041RJF9YHT1RJF9Y@4300P16P000`40000>
00003@000`40000X00@10P001P400JH1YP8100JY0FeCKE<20@04Z@410@D0
0P400f`10@020@04YhnW0@<00P400aD10@020@0IRQD15HXERQF:0HZ9RXV:
RHX1RXV:RHZ9RP020@04RY2:0@8001`1ShV?RHn9S`6?RHn9ShV?0Hn9ShV?
RHl1YXVV1@400i1aT0030@05YXVVRJH0104028VVRJJ90HjV0`401JJUYZFV
00810jD20@8000@1Y@40104J00030@0000h0000=00030@0002P010404001
0@01ZJJY0JT1K5=/Df`30@03KE<100H00P401hl1SjH1S`4010030@0MK8Y/
RVb:0HY/RVb:K8X1RQF:5HXE0AF:5HXERQD00P400hn:0@03000Q0HV:RHZ9
RXT1RHZ9RXV:R@69RXV:RHZ90HV?RHn9S`4000H100N9ShV?R@6900D100N9
0HVVRJJ9008100JURJF90HT20@0;Y@6U0@01Y@400C<00P4J00030@0000h0
000=00030@0002P010401`010@6Y0JT0104035=]DfeC0FaaK75/0@H000L1
YP6VSjH100800`405AD15HXERQF:5@4ERQF:5HXE0HV:R@0P0@0BShV?0Hn9
ShV?R@69YXVVRJJ91043008100V9YXVV0JH100400P030@06SZJ>YP6V0P40
1ZFV0JJUYP810ZD20@:U0P4013<10@4I00030@0000h0000<00030@0002T0
1@4013<10JD20@07Z@5CCP5CK0030@05KE=]Dfd00P4600050JJ?YXl00`40
4VaaK741RVb:K8Y/RP6:K8Y/RPH100<ERQD00P46000E0AF:5HXERQD1LHma
0G6?L@69RXV:00L100n:RHX1ShV?RHn9S`6:L@4010030@04ShT10@L00`40
1ZJ90HVVR@<100b9YHVU0JD>Y@6UX:D50AT000<100003P0000`000<10000
:0030@0=Z@5><`6VZ@6Y0FeCK@030@0;KF`1K75/LF`1S`401P005@6V0@4E
0AF:5HXERP6:5HXERQD15@040@03YP4100J:00<100001@00206?RXn:ShZ?
0P403XZ?RP6:S`6?RXn:ShZ?0P400g6?0@040@05YXVVRJH00P401G6?L@40
008100>:0@00104600040G41L@<100ZVYJJUYP6VYJJU0P42Y@810ZD50AT0
00<100003P0000`000<10000:0050@05<@41ZJD00P403E=>Ddh1DfeCKE<1
Dfd00`400jH10005008100iaK741LFaaK75/0Fb:K0H100B?RXn:0P4028XE
RQF:5HX11P00204ERQF:5HXE0P401HmaS`6?008100N9RXV:RHZ9008100B:
LHYa0P400hl10@020@06R@41RW6:0P43L@040@0000811@001P5aKG41L@81
00F9YXVVR@020@07YHVU0JD1Y@030@03Y@4000<16P000`40000=00003000
0`40000X00D100=>0@4010400e=]D`020@05KFa]K6d00`40175/0@4400<1
00/ERQF:5@4ERQF:5@050@05LHYa0@000`4018l1S`47RP030@0000@000P1
ShZ?RXn:S`L100V?0Hn:ShZ?RP400P000`6?L@030@05RZJ:YXX01P420004
0G6:L@@100>:0@000P000`5aL@03L@0@0G410JFVYJH1YP6V0JJUYP<100@0
0@40104I00030@0000d0000<00030@0002P01P401dh10@5C0E<00P403P01
DfeCKE<1K6e/KF`10P020@0:K05/LFaaK741L@H100M/RVb:K8X100@01040
28XERQF:5HX10`0A0@0;Sg41RHZ9RXV:0@00104200090Hn9ShV?R@6900@1
00<00G400W401`5aL@5a0@000P401g41LFea0@000P4028T10JH1YXVV0P44
Y@810P000`400@030AT000<100003@0000`000<100009`030@05:P41CS<0
0P4015A>0@4400030Fa]00<100EaK75/L@030@09LFaa0HXERQF:00<10`00
2`6V0HYaRW6:LHX100H000@1RXZ:204048n:S`6?RXl1ShZ?0Hn:ShX<0@03
004000<000d1RZJ:YXZV0JJ:YXZV00D100L00HX1RW4100Aa00<1L@400P00
1@6UYZFV008100^UYZFV0JJUYZD1E0020@03E04100<16@000`40000=0000
2`000`40000X00H100HcCP5CCU<30@<00`404VeC0Fa]K6e/0FaaK75/L@5a
K08100<00Hl00P403001RXl1RVb:K8Y/0@H010408aF:5HX1RQF:5HXE0HZ?
RP5aSg41RHZ9RXV:R@69RXV:RHX100L000h1ShV?RHn90HV?RHn9S`810`00
0`5a0@020@07005]LFea0@03000;0JJ9YXVV0JJ9YXT00P43Y@050E@10C<0
1@4I00030@0000d0000;00030@0002P01P401Dh10DiD008100>VZ@400P00
2@5/LFaaK05/L@030@06LFaaK75/0`4200050JJ?YXl00P402:J?0G6:LHYa
0P4600030HZ:00F:00P1RXn:ShZ?RPP100n?RXn:ShZ?0Hn:ShZ?RP401`04
0@0:YXZV0JJ:YXZVRP8110020@<000<1LG400P4400060JFVYJJU0`401jFV
0JH1YP400U@00`4cE0020@03Y04101T000<100003@0000/000<10000:004
0@03<@4c00<100M>0@6VSP40008100E]DfeCK@030@08YXl1K75/LF`20@0;
YXX1006:ShZ?0Hl00`400hX10@020@045@4000<101800HXERQF:5HX1RQF:
5HXERP46000@0HV:RHZ9RP6:RHZ9RXV:0@H00`4200D100R?RHn90G6:0@80
0`4400811P020@07RJJ9YP6VSP030@:U0`4015@c0C<20@03Y04101T000<1
00003@0000/000<10000:0040@04<`41Y@<100ACK@6Y0P401e<1K75/LF`0
0P401`01YXl1K7400P401G41SjJ?008100NVSjH1YXnV00<100J:LHYaRP42
00030HZ?00<11XX02@6:ShZ?RXn:0@06000@0Hn:ShZ?RP6:ShZ?RXn:0@<0
0`400g6?0@0400030G4100<100BV0HYa0`400g6:0@0400030@0000@000<1
LG400P402jH1YZFVYJH1YZFV00810U@20@03<`6T00816@000`40000=0000
2`000`40000X00<100<c<@400P401@01CU=>008100M]DfeC0E=]00@10P00
0`6V0@020@09LFaa0JJ:YP6?008100>:0@400P406hX1RQF:5HXERP400Hn:
ShX15HXERQF:0HXERP050@D03@4018Z9RP4300070HYaRW6:0@0300811005
0@Aa00<1000020001@5aKG5]00<100F>YXjVSP020@:U0`400c<1Y@050AX0
00<10000300000/000<10000:0030@8c1@402FeCK@5]DfeCK@030@03LF`1
00@00P402g6:LHYaRP6VS`6?00<100eaRW6:L@5aRW6:LHYa008100B?RXn:
304018n:ShX60@0=006?RXn:ShX1RXn:S`040@@000H1Sg6?L@49008100>V
0@400P40176:0@47008100=a0G400W404P400JJUYZD1YJH1YP6V0E@1:PH1
6@000`40000<00002P000`40000Y00D100<c0@000P4044iC0@5CKE=]D`5C
KE=]D`4200<100IaK75/LF`50@0@K05/RVb:K8Y/0AF:5HXERPH101@E0HZ?
RP6:S`6:5HXERQF:0Hn:0@<00101RHZ9RXV:0Hn9ShV?RHl110000`5a0@03
0@T00P401HV?RHn900@11P002`5]LFd1KG41L@40008100F>YP6VSP020@>U
0P42Y@030@0100816@000`40000<00002P000`40000Y008100@Z0@4c0P40
15A>0E<20@04KE=]D`8100EaK75/L@030@08LFd1LHYaRW430@0@LHYaRW41
LHYaRW6:0HYaRPD100F:LHYaRP020@0ARP6:ShX1RXn:ShZ?RP6:S`400`00
406?RXn:ShX1RXn:ShZ?RP4400<100>V0@400P47000:0HnVSjJ?YXl1S`81
10000`5aL@02L@<100=aK@400P030@0>YZFVY@6UYZFV0BZU0@030AT000<1
0000300000X000<10000:@040@8c00@1Dc=C0P4200030Fd100<100iCKE=]
D`5/LFaaK05/L@8100i/0FaaK75/L@6:K8Y/RPD100^:5HX1RQF:5HXERP05
0@0=ShX15HXERQF:0Hn:0@03000@0HV:RHZ9RP6?RHn9ShV?0@H000H1RHn9
ShT20@D000`1ShV?RHn90HVV0JH20@<000H1KG41YXT20@0;LE<10G5C0HjV
SZH00P43Y@8100>U0@400`4I00030@0000`0000:00030@0002T010401dh1
0DiDCP400`040@:V00<1K7400`401G5]LFea00<100f:LHYa0G6:LHYaRP6:
00<101F:0HYaRW6:L@5aRW6:LHYa0@01RXl00`402Xn:ShZ?RP6:S`43000?
0Hn:ShZ?RP6:ShZ?RXl100L000P1YXZVRZJ:0@D00P403JJ?YXnV0JJ?0HnV
S`400P003P5aL@6?YXnV0G41LFea0P402:FVY@6U0JFV0`400bX10@020AT0
00<10000300000X000<10000:@040@05<`41Dc<00P4300060@000HjV0`40
5JJ>0FaaK75/0FaaK75/L@5aK75/L@030@0CRQF:5@4ERQF:5HXE0AF:5HXE
RP030@04ShZ?RQT100B9ShT11P002@6?RHn9ShV?0@0700<100Z?0JJ9YP6V
RJH10`020@0CRJJ9YXVV0G41LE<1SP6>0JFVY@020@8000<1Y:D00`4I0003
0@0000`0000:00030@0002T01@4033=D0E@1E0400Fd1008100>V0JH00P40
1JJ?0Fea00<100V:LHYaRW6:0HX00`404hX1RW6:LHYa0G6:LHYaRP6:LHX0
10403P01RXn:S`6?RXn:ShX10P001P6?RXn:0@@000D1ShZ?RP040@H000P1
RZJ:YXZV0@P000<1LHX00`401ZJ?0HnV0@@00P401ZJ?YXnVS`<100E]0JFV
Y@020@05ZJFYY@400P000`4ZY@030AX000<100002`0000X000<10000:005
0@<c0P401UA>0@5DD`8100>V0@400P4200030JH1008100VVSP41LFaaK740
0`404G5/LF`15HXERQF:0HXERQF:00D101::5HX1006?RXn:0AF:5HXERP42
00060G6:LHX110001`5aRW6:L@4020040@04RHn90@T000D1LG41YP030@03
YXT100800P402f`10JJ9YXT1SZJ>008100ZVSZJ>0JFVYJH10P020@04Y@41
0AX000<100002`0000T000<10000:@030@0>:P5D<e@1E5=D0FeCKE<20@04
LFea0@<00P4018nVSjH20@03LHYa0081012:0HYaRW6:L@5aRW6:L@5a1040
0jH1RP05RPP100N?RXn:ShX1008000H1ShZ?RP4400030Hn:00@12000106:
YXX40@T000L1RP41SjJ?00<100=a0@400g401`6V0@6?YP401:H01@6UYZFV
008100BUZJD10P020@04Y@410AX000<100002`0000T000<10000:@030@04
Y@4c<`8100i>E041DeACE05]DfeC0@<00`401HjV0JJ900<100m/LF`1K75/
LFaa0HXERQD01@403HX1RP4ERQF:5HX1S`4010001`4ERQF:5HX0404<0008
0Hn9ShV?R@4800<100Ma0JJ9YP6V00<100QaK75/0HjVSP8100FVSZJ>YP02
0@08SZJ>0@01Y@4200030JFU00@16P000`40000;00002@000`40000Y0081
00D00JD1<`030@06D`41KE=]0P401VeaKG5]0@8001L1YXl1S`6?YP6:LHYa
RW41LHYaRW41L@030@05S`6:YXX01@45RP030HX100@000@1ShZ?3P400hZ?
0@0=00070JJ:YXZVRP020@H00P401hX1RP6VSjH00P400hl1S`020@9a00L1
SjJ?YXl100BV00H1YZH1Y@4200<10P001@6U:P4000816P000`40000;0000
2@000`40000Y00@100BU0@6U0`408e=D0E@1005]DfeCK@400JJ>YXh1RJJ9
0FaaK75/L@5aK75/00D101290HV?RHn90HV?0HXERQF:0P4200L100j?0HX1
RW6:LHYa0HZ?RPX11P001`69ShV?RHl00P44008100@ERQF:1@401jJ90@6V
RJH00`401JJ>YXjV00<100JVSP6>YXh40@03E4h100800P400jD100020AX0
00<100002`0000T000<10000:@030@0:0041Y@6U0E=DD`810`000`5aK@03
0@06006?YXnV0`402ZJ?0G6:LHYa0G430@05L@6:YXX00`4028ZVRZH1YXX1
0XX70@0OShZ?0Hn:ShX1RP6:ShZ?RXl1ShZ?RXn:0HZ?RXn:0@06008100V:
YXZVRP5a0@000P4018X1RW450@04SjJ?YP8100^?YXnVS`6?YXnV0@03YP81
1JH20@04KE=]0@800P400bX100020AX000<100002`0000T000<10000:@03
0@0;006UY@6U0EACE04010030@04Dg4100<100FV0@69YP030@04LFaaK0<1
1G401P69ShT1R@8100F?0Hn9S`030@0:RW6:0HYaRW6:L@P101B:LHYaRW41
RXn:ShZ?0Hn:ShZ?0@P00`400hT15@030@035HXE00<100<ERQD01@4028T1
0JJ9YXVV0`403JJ>0HjVSZH1YXjVSZH00P402TiD0@400JDZ0C<30AX000<1
00002`0000P000<10000:`020@8000<1Y@400P4015=D0@4400090G5]LFea
0JJ?00<100F?YXnVS`020@03RP41008100aaRW6:LHX1YXX1RZH60@0ZRP6:
ShZ?RP6:ShZ?RXn:0HZ?RP400HZ?RXn:S`6?RXn:S`6?RXn:ShX12@000`5a
0@040@09L@410G41LHYa008100B:LHYa0P402JH1YXnV0JJ?YP020@FV0`42
YP070@000E<1D`020@04ZJD1<`<16`000`40000:000020000`40000[00<1
00<00JD00P401ZD1D`5C0@800P401E=aDg5C00<100Q/LF`1RJJ9YP@100B9
0HT11W400`6?0@020@04RP6?0@800P40:8YaRW6:L@5aRW6:LHX1RXV:0@01
RW6:LHYa0HZ?RXn:0HZ?RXn:S`49008100<00HX01P400hX1RP020@07K05/
LFaaK0040@0CYXT1SZJ>YP6VSZJ>YP6VSP6>0@02008100Q>D`41YBX1<`<1
6`000`40000:000020000`40000[00<10P000`4000030@03E6d1008000P1
E05]LFea0@Ea0P400hnV0@020@0;YXl10JH1RW6:LHX00`401hYaRW41RP40
10004@6?RXn:S`6?RXn:ShX1RXl100804@4018Z?RP4200<11P030@05SjJ?
YXl010401hYaRW41LHX00P4300<100F?YXnVS`030@:V00H1ZJJYYP43000:
0E=DD`4c0JD1<`<16`000`40000:000020000`40000[00<10P000`400002
0@04DeACE08100ECK@5aD`030@06K75/LFaa0`401g5]L@6V0Hl00`403741
0@6?0HYaRW6:L@8110000`5aRP0A0@H000H1RXn:ShX20@801P400hXE0@02
00D100b?RXn:ShX15HX1LF`20@04L@410@L000D1YXjVSP070@04SZJ>YP81
00D00@5CCP020@04CP41<@@16`000`40000:000020000`40000[00<10P02
0@0<00410EA]E05DLEAa0P4016eaK@45L@0<0G6:LHYa0Hl1SjJ?0`402XZV
RP5aRW6:LHX30@8010404Hn:0@6?RXn:ShX1RXl1ShZ?00<10`001P6?RXn:
S`811@000`6:RP02RP<110003`6?YXnVSjH1RW6:0HX1YP030@H00P401G41
0HnV008110001P6YYZT1L@8100ACK@410P080A/000<100002P0000P000<1
0000:`001P4c0@01>0<101=D0EAC0@01DfeC0EAaE741LFaa00<100iaKG5]
LFd1RHn9ShT1008100Z?0@5aRW6:L@690`401W410@69S`81011aRW6:LHX1
RXT1RHZ9RXT10`001P6:ShZ?RP811@000`6:0@020@03RP4000<00`4048Z?
RXn:0AF:5@5/0HZ?RXl20@800P400faaK0050@0@K040006V0JJ>0E<1CUA>
0@801@4013<10@4K00030@0000X0000800030@0002/000L1<@400C=D0081
0U@20@8000<1LE@00P401G5]LFea00<10g403@6:LHYaRP6VSjJ?YP400`03
0@03RW4100@100MaSg6?0Hn:00D100n:ShZ?RP6:S`6?RXn:S`400`001P6?
RXn:S`8110030@03RP41008110020@09S`410Hl1LHYa00@100FVSjJ?YP04
0@05KG5]LFd00`400faa0@0200030JJY008100AC0@5]0`42008100A>0@4a
0`4K00030@0000X0000700030@0002`000/1<`400CPc0E=DD`020@<00P40
4EAa0G5DLE@1KG5]LFd1KG5]00D100>9S`401@040@0PLHYa0G6:LHYaRP6?
RHl1006:LHYaRP6:R@69RXV:R@4300060HZ?RXn:0P400`010@050@04RQF:
0@D000D1ShZ?RP050@080041ShZ?RXl20@07K75/0FaaK0060@07L@41SjJ?
YP020@03Dfd1008100IC0@6U0C<60A`000<100002@0000L000<10000;005
0@04<e@10@9D0`4200070FeaK@5]L@020@03Y@5a00Aa0`401G6:L@4000<1
0`020@0GRP6?LHmaS`6?LHmaSg41RXn:0@01RXl06P43RP030HZ:00>:00<1
00000`00206?YXnVS`6?0`403P01SjJ?YXl1LHYaRP5a0P401V`10@6?YP<1
00BYYZVV0P401FeC0JJY00<100BYYP40104M00030@0000T0000700030@00
02d00`404C<10E@1E05D0JD1005aE75D008100ZVR@41LFeaKG411G401040
00040@0CLHYaRP6:LHYaRP6:LHYaRP6?R@060@0BRW6:0HZ90HV:0HmaSg6?
L@6:0`401HX1RXn:00H100B:5HX11000306:ShZ?RP6:ShZ?RP<100V:ShZ?
0G5/LF`00P405W5/LF`1S`6?YP6VSjJ?0HnV0Fd1ZJD20@07ZJFY0@01<@02
0Ad000<100002@0000L000<10000;@030@05>041>5@00P404E@1YJH1005a
KG41YZFV0@01009a0`40276:LHYaRP400P404741LHYaRW41LHmaSg41LHl6
0@0ERXn:0HZ?RXn:0HZ?0Hn:0HZ?RXn:00<100j:ShZ?0Hn:ShZ?0Hn:S`@1
10003@6VSjJ?YP6VSjJ?YXl010401JH10G6:00<100YaK75/0HnV0JJ?0`40
4jJY0JVVZ@6YYZVV0JJYYP400C400P4M00030@0000T0000700030@0002d0
0`406S<1<e@c0E=DD`6>0@01E741L@6VR@400Fd10`000`5aL@03L@811740
2P5aRW6:0HYaRW450@0GRHX1RW6:LHX1RW6:LHYa0HT1RHZ90G400`404g41
RXn:ShX1RXn:ShX1RXn:ShX00P4400<100V:S`6?RXn:ShX00P400g5/L@05
0@<000@1LFaa0`401:H10@040@04YXnVS`8100>YYJT00P400jD1Y@050Ad0
00<100002@0000L000<10000;@030@05>041>5@00P42E0030JH100800P40
0g5]L@030@8000T10041006:LHX00`403HYaRW6:0HYaRW6:0Hl00P405741
RZH1ShX1RXn:ShZ?0Hn:ShZ?20406HZ?RXl1ShZ?RP6:ShZ?RP6:ShZ?RXl1
RP400`000`6VS`040@0;YXnVSjH1RP6:LHX00P45000D0F`10JJ?YP6V0@01
LF`1YZVV0@020@09Z@410JT1Z@6Y00817P000`40000900001P000`40000^
008100Dc0@41E0030@03E06U00810P00205aE75D0@0110000`6V0@040@04
YXVV0@Aa00D1LHYaRP030@0FRW6:L@690HV:R@5aRW6:L@5aRW6:L@D100B9
0G6?1P404XZ?0Hn:ShZ?0Hn:ShZ?0HXE0@8000P1ShZ?RXl1S`<100J?0HY/
0F`20@L00P401P01SjJ?YP@100QCKE<1SjH1008100VU0@5>0JVU0JD00P4N
00030@0000T0000600030@0002h00P4013<1<cP60@03YJH100<000H1LFea
K@4500030HVV00<100bVRJJ90G6:LHYa0G420@07S`6?LHmaS`070@03ShX1
014100J?RXl1ShX<0@03ShX100H100Z?YXnVS`6?YXnV0P4017410@4;0006
0HnVSjJ?10400g5/0@060@0:00410C<1:ZT1Z@817P000`40000900001P00
0`40000^00@100<h<`400P020@043ZD>0@<000D1E75D0@0500040HT10@9a
0`400hVV0@04L@<100maRW6:0HYaRW41R@69RXT02P406Hma0G6?LHma0G6?
LHma0HZ?RXl1ShZ?RXl01`42000>0AD1RXn:ShX1RXn:ShX30@03K04000/0
00T1YXnVS`6?YXl00`402E=/0@5>Ddh1YP030@03Y@4100@17`000`400008
00001P000`40000^00D100<h0@400P020@03YJH100<00P400fea0@050081
17400`4000040@0@RP41R@5aSg6?L@5aSg6?L@8100N?RXn:S`6?00<1022?
RXn:S`6?RXn:S`6?RXn:S`6?RXn:0HZ?RXn:0HV:0@D000<1RP400`403HnV
0JJ?YXnV0HXERP4010020@L00P404XnV0JV?ZHl1DfeC0E=]Dfd1Z@<100>Y
0@400`4P00030@0000P0000600030@0002l010400c<1X0020@04E0410@@0
0P401741Y@4400030Fd100Aa00@100000`403Hn9ShT1LHYaRW41LHX00`40
1HZ9RXV:00<102>:RHX1Sg6?L@5aSg6?L@5aSg6?0Hn:ShZ?0Hn:ShZ?0HXE
0@0500060AD1RXn:10402Xn:S`6:K8Y/0@030@03K04000@00P4036e/0@6V
SjJ?0E<1D`8100mCCU<1ZJJY0JVU0JD1SP4080000`40000800001P000`40
000_00H100NU0@5D0@0100@000H1YP6VY@4300040G5a0@Aa00H10041RW43
0@07R@41Sg6?L@040@03004100H102F9ShV?R@6:ShZ?0Hn:ShZ?0Hn:ShX1
RXn:ShX1RXn:S`6:RHX100D000X1RP6VSjJ?YP6W0P401Hl15HXE00<100I/
RVb:K044000:0G5/LF`1SjV?Z@8100aC0@000Fd1ZJJYYP42Z@050JT1:P40
80000`40000800001@000`40000`00H100>P0E@00U@00`40000300<100>9
Y@400P001P5]LFea0@=a0P44L@030@0000@100B:0@410P000`400@020@80
1P401HV:0Hma01H100N?RP4ERQD100801@402Xn:ShZ?0Hn:ShX20@0<RP41
K05/LFaaK7411@002P5]K06?0HnV0F`20@03004000@100FYYP41Z@060B00
00<10000200000D000<10000<@080@9D00<100000`000`6VY@020@<000<1
LG400W40305a0@6;0HYaRW6:0@8000<1R@400P400hT100030@/03@400hV?
0@0500060HZ90Hn@2@400hZ9RP020@0<SjJ?YXl1SjN?Y`6W0P4021F:5@5/
RVb:0P45000>0F`10JV?0Hl1K0400@030@04YP6VZ@P18@000`4000080000
1@000`40000a00D100FP0CP1E0020@<000H1YHVUR@4400060G5]LFd11740
0`5aL@02L@080@000Hn9ShT30@03004000P00`402W6?0HZ9RXV:R@4300`1
00n?RXn:0AF:5@4ERQF:5HX00P402HZ?RXl1ShZ?0@04S`8100=a0G400`46
00@100BVSjJ?0`4200<100@00JV?0P4014h10C440B4000<10000200000D0
00<10000<P050@07>5@10EAI0@0200050JFVYJH00`4200030G5a008100X0
0G6;L@5aRW6:0`400jJ90@020@05R@4000400P030@@000d1T8Z@RP69ShV?
RHl100D000L1RXV:RHX100800181Si2?T06:RHZ90HV:RHZ90Hl20@0<YP6W
SjN?0HnWSjN?1047008100M/0@01SjV?00810`000`6YYP020@05ZJJY0E<0
204R00030@0000L0000500030@0003801@4015@hE042E0810P020@05Y@5a
0JD00P400`010@0300030G5a009a00D1L@41L@040@05RHn9S`400P030@03
LHX100@000`1LHmaSg41RHZ9RP46000F0AF:5HXE0@01RXn:S`6:5HXERP6:
5@<100B:ShZ?10400hX1S`04S`8120020@=/0P401HnVSjH100@000@1SjV?
0P401:T10C480B8000<100001`0000D000<10000<`050@06E3P10EUD0P43
008100Ea0HVVR@020@@00P400h]aR`050@03T04000<100>V0@000P001`6@
LI1aT04010001@6:T8Z@00<100>?R@400P030@04006:R@@100H00I2?T8l9
0@8000H1YhnWSjL20@0900410HnWSjL100P000`1K75/LF`1006?Z@430081
00>VZJH00P400jT10@030@04Z@41:P818`000`40000700001@000`40000c
008100Dd0@01E0020@03E05D00810P002P5DLE@1RJD1L@4200040HT1L@@1
1G40104000070@05RW6:L@4010000`6?L@0:0@03Sg4100D100>?RP401`40
1XXERQF:0@@000D1RXn:S`050@06RV`10Hl12@020@A/00L10001S`400081
00E/0@6?Z@070@05ZJD1YJT00P4S00030@0000L0000400030@0003@00P40
0c<100020@0EFE@10G5D0@01F@5aLP6V0G9aLP4000D100NV0JH1T76@0081
1000106VRJH20@07LI1aT74100050@8001h1T8Z@RP6:T8Z@0HX1RXT1Si2?
T06:RHZ90HV:RHX30@8000l1SjN?Yhl1004ERQF:5HX00P4300810`000`40
S`040@@00`400fa]K0020@03Z@5/00@100H00JVY0JT30B<000<100001`00
00@000<10000=@040@0A004hE05IE5T1005aE05DL@4017440@9a00H1R@69
0G440@@000T1RHZ9RXT1LHX01040176?0@43000Q0G6?LHl1Sg6?L@690AF:
0Hn:ShX15HXERP6:5HXE0HZ?00D100>?RP400`00205/RVb:K0400`400f`1
000200060HnVSjH110020@0:K05/Df`1D`5CCP<100<00@000`400jD10@0T
00030@0000L0000400030@0003D01`403U@10G5DL@5bFG81LP5b10401W41
LG9aLP<100NVR@69YP6V00<100H00JJ9YXT40@07YXT1LI1aT0060@0DRY2:
T06@RY01RP6:R@6?T8n@0HX90@07T8n@S`6?T0030@<000<1RQD01@400fb:
K0020@8000T1S`2?00400@000P400fa]K0060@07005/0@0100080B@000<1
00001`0000@000<10000=P060@0;E0400ET1005aE7401@42L@030@0100Aa
10402741R@69RXV:1P406G41RHZ9RXT1LHma0HV:0HX1Sg6?L@5aSg401P40
18n:ShX20@0BRQF:0HY/RP6?RXn:0HZ?RXl10`040@<000H1K75/0Hl40@0A
YXnV0JJ?YP5/DfaCK06Y0@000P401Xl10@6?Z@8100H00@41SP4V00030@00
00H0000400030@0003H00`400j@1Y@020@03005D00P100IbLG81LP420004
0G5bL@<1015aT06V0JJ9YXVV0JH1T76@L@030@0;RJH1T76@L@690HT02P44
00`100b:R@6?T8n@0I2?T8l50@04SjL10@800281RVb:0JN?Y`40S`2?0Hl0
S`01KFa]0@2V0@01YP2V0JT02@4V00030@0000H0000400030@0003L03P40
2E@1R@5DLEAa0@0300030G5a009a00<1LG400W460@0;R@69RP6:LHX1RXT0
10403Hl10@6:0HX1Sg6?L@402`002@4E0HZ?RP6:S`050@0<S`6?RXn:0Fb:
K8X118l010400F`20@>?00h1K041S`6?YXnV0JH1K08100N?ZHl1SjV?0081
00FYS`4100050BL000<100001P0000<000<10000>@0:0@033ZD>008100FU
3P5aLP020@@000<1LP400`400g6@L@040@03T741008100Z9YP6@LI01YXVV
0`400hX10@040@05RY2:T0402`003P6:0I2?T06@Si2?0Hn@104038n@0HXE
RP6WSjN?0@800`404:N?Yhl1K8Y/0Hl0S`0108l30@03YP2V008100D0YP6Y
00020@06Z@41Z@4a0P4W00030@0000H0000300030@0003T01`401hP1E068
YHP0104017413XT20@<000H10001R@43L@030G5a009a0P401XT10@5aRP81
01:9RXT1RHZ9RXV:0HZ90G6?LHl=0@0>ShZ?0Hn:ShX1RXn:S`42S`<100A/
RV`118l01P400001S`8100>?0F`00`403Xl10JH1YXnVS`6?ZHl10P020@07
SjV?0HnY0@02Z@@19`000`40000600000`000`40000h00H100YJ0@5DFU@1
3ZD10P030@04RJF9Y@811000106V0I020@0;L@5aT76@0JJ9YXT01@4078VV
0HZ9RXV:R@69RP6@RY2:0HV:RHX1RXV:RHX20@0ASi2?0Hn@Si01T8n@0I2?
T8l00P400hX10@020@03SjL100@000@1SjN?0`4046aa0@2?0040S`2?0F`1
YP4300040JT0Z@8100@00@6Y10400`01000U00030@0000H0000300030@00
03H02@401U@1FEAIE0<10P002@5a0@j93XT1R@020@03006900:900<1LG40
0W401@5aLG4100F900@1RHV91P402HZ9RP6:R@5aS`030@07RXV:R@4ERP0;
0@07S`6?RXn:0@03S`040@010@@00P4400070Hn?S`5/0@02K00<0JJ?YP6V
0JJ?YP5/0`4300070JV?0Hl1S`070@8000<100008`000`40000600000`00
0`40000c00<10`050@03E041008100YDFP6U0@01LW5b0P401XT1L@69Y@D1
01J@0I1aT06@LI1a0HVVRJH1XHVQRJ410`090@0AT8X10HZ9RP6:R@6?T8l1
RHX00P400hn@0@030@07S`6?T8n@0@0:00@1016WSjL1RP5a0@2?08l1S`01
00030@9/00@100000`400jT00@030@04<@410@@000<100008P000`400006
00000`000`40000_00@11`020@03Q`4h00810P030@03R041008100=aFG40
0`42L@030HT>008117401P5aLG41L@8100Ia0@41R@45R@<10`002`5aSg6?
0HmaS`6900L100>?RXl00`401P01ShZ?0@8010400hl1000700<100=/5@40
0hl00`5/K0050@06S`6?YXnV0P4014i/CP44008100>?ZHl01`4500030@00
02<000<100001@0000<000<10000;0030@`010400cP10@0200030@010081
01MILP5bLG81LW5bL@690HT1LI1aT06@L@020@06T76@L@6920400i1a0@03
000>0HZ@RP6:T8X1RHZ9RP4200050Hn@S`400P001P6@Si2?0@<000<1Si00
0P4800060HY/RVb:0P400hl10@020@0<5F`EK06?08l00@010V`20@040040
008100@0Z@4a1P4600030@00028000<100001@00008000<10000:P030@l0
1P400j0100020@0:0041LEAa0G413P810g420@:900<1LG400W420@03LG81
00=a00<1RHT00`401g6@L@5aS`400P020@08Sg6?L@5aS`44R@080@000Hn:
S`4200060HZ?RP401043S`030@0000H000D1K1E/5@050@9/00d1K6a/0Hl1
SjH1005/008100==0@4010401`010C5=0JT00P400hh0000600030@000240
00<100001@00008000<100009`030A<01@401J2T0EYD00@100=bFG800`40
1:D10G440@04YHT1L@8100VV0I1aT06@LI000P4200080I1aT06@LI050@03
T04101010P030@0:T041RHX1T8n@0@T000<1RP400P402HX10Hl00HX15@02
0@05S`0100400P020@08K5=/0@2Y0Dd40@04C@6YZ@<12@000`40000P0003
0@0000D0000200030@0002@00`4F00<100<h0@400P402UAI0@013P5aE042
008100<00@000`050@>900D1LW41L@020@03T041008000/1T76@0Hma0HT1
00020@800101LI01T76@0I1aT06@LI011@070@:?00<1000010050@A/00D1
Si01T0040@05SjN?Y`400`00205/CF`108l0204019@10@4;00030@0001l0
00<100001@00008000<1000080040AX01@401J010EAJ008100BPY@413P03
0@05YXT1LI000P401G6@L@6900<100=aT0401P45000@0I2?0Hn@S`6?T8l1
Si2?0@D00P401I2?T06@008100<00@4010401HY/RP40008100e/0Hl0S`6?
08l1S`2?008100X00@000E=/0@2Y0P400f`1CP030@03004100<12`000`40
000O00030@0000D0000200030@0001d00`4N00H100BP0@5D0`400hP>0@0A
00D10XT01@5aT74100>90P400i1a0@040@H000h1T741LI01T76@0I1a0@H0
0P401Xn@0I2?T08100e/0@41K8U/RF`1Si2?0081016@S`6?T8l1S`6?0Hl0
S`0100030@040041C@@100BY0JVD104=00030@0001h000<100001@000080
00<100006P030B802P401UYI0J2U0A<01P402g6@0HZ9RXT1LI0100X000D1
Si01T0070@03T04000D000d1Si2?0Hn@0HY/0Hn@008100Y/RV`1S`2?0Hl0
0P403Xl0S`6?08l1S`2?00400P400i@0U0030@04C@41008100>Y0@400P4?
00030@0001h000<1000010000003004001T00`4V00L100F80EAJE0030@h0
0P4400070HV9R@6@L@040@06R@6@LI011@090@03T040008000<1T0402@40
3Xl1Si2?0Fb90I2?0Fb90P406hn@Si01T8l1K06?0Hn@S`6?0Hl00@2?0Hl0
S`030@9=0P400i@10@050A0000<100007@000`400004000000<00@005P03
0BX01P42X0030EUJ00@100<00@002P000`690@020@0500693XT01043R@<1
00>@L@400`020@0;T06@S`6?T06@S`400`00306?T06@S`6?T8l1K0<100R?
0Fb:0I2?T0@100N?0@400@2?008100j90@6?08l1S`010040S`8100D0U041
00030@060041Z@6D0`4B00030@0001`000<100001000000300400180104^
008100Hh0CP1X8P20@04FUT1R0<12`001069RHT30@04R@5aM`811HT00`5a
T0020@0@0041T741LI1a0G6@0I1a0@8000T1T741RY01T8l02`402Xn@0@5/
Q06@Si020@03S`4100810V`02P6?0Hl0S`0108l50@800P4200P14`000`40
000L00030@0000@000000`01000?00<1<`040@08FP6PX05ILUT20@04LUT1
0@P000P1L@413XT100<100=aT0401HT30@<000l1R@6@S`6?T06@S`6?T040
0P002@6?0Hn@0I2?T0020@06K8U/RF`10`020@0700690@2?00040@03K8T1
00A/00@1S`2?1P4200050@0000400P080AD000<100006`000`4000040000
00<00@0030030CH02`401UYI0EUbF@<11@001P5aLW5b0@:900<100000P40
0g5g0@020@:900<100000`001`64R@6@0I00204200L100Z@0@01RFb9K8T1
0`050@03T8n@008100M/0Hl1K05/00<100D00Hl100030@800P400hl10003
00040@01C@@15`000`40000J00030@0000@000000`01000900<1>P030@04
@@5J>08100<>0G800`40179I0HP20@8000X1L@41Mg5g0@h10P0010400G42
0@03R@4100@10P000`69R@050@T000L1S`6?T040008100<00@4020402HU/
R@690@01R@020@03S`2?00<11@050@07S`4109@00@0300030@0100D16@00
0`40000I00030@0000@000000`40000600<1?P060@03>041008101=bFG81
LP4>R0400G5bLG81LP5g00810P003@40005aT069Q064RH@01P400i1a0@0;
0@05T06@MP4010020@0<S`5/R@64K8A/Q6`10V`01P5/0@6?T08100>?T040
0`030@08K040S`0108l20@8020400i@1000I00030@0001P000<100001000
00030@000080105200@100F20@4100030@04FG81008100>80@400P4027Ma
M`6@LI010P020@080041LI01R@42R@8100>90HT00XT0106@0@46R@080HT1
T8l1S`4500080Hn@0HU/0F`20@05RFb90HT01@401`0108l00@000`401V`1
K040S`8100<00@400P020@03U00100@100>D0@006`000`40000H00030@00
00<000000`400@020DL00`401Z220CP100D10`020@03LW5b008100]a0@41
LGL1005g0@0200030G4100@101=aT0690HV4R@6@0HU/RFb9K05/00H11@00
1P6@0HU/R@8100>?T040104020010Hn@0I2?0P401YF?0FI/IP8100BE0@41
0P000`400@020@04U04100D17@000`40000H00030@0000<000020D/02@40
1:280@45008100MaMg41LGMa008100J@0I1aT04200090G410I1f0GJ@00/1
0hT02@69Q8V40Hl100050@03S`4100@100BE0@000P40100108l20@050041
S`000P402I010@6@0901IP050@04CFH10@801@4O00030@0001L000<10000
0`000003004104/00P4013P10@040@03P`4000800P42008100Ub0@41Mg5g
0GL00P40175g0@020@07L@41T741L@040@<00P400g410@080@0:T0410I1f
0Hl1008100@00I2?0`4018n@0I020@03Si2?008100VE0IF?U@6ESiD00P40
1Dd10@2?00D100<00@400P400i@1000P00030@0001H000<100000`0000<0
00<10000B0030@04>041008100AJ0@410P00105g0@42008100J80@5g0I02
0@03LP5a008100N@M`5fT06@00810P000`6@0@02008100J@0HV4R@43000<
0I01RH@1S`6?0@010Y020@05S`41UI000P401ID10900008100F@0040T002
0@0500410F`00P400iD00@030@800P400i@10@020B<000<100005@000`40
0003000010000`40001900/10P020@0CLUT10@01RH>90GMaMg41L@5aM`02
0@03L@5a00810`040@8000<1R@401@4300D100=fT0400P401P01T06@S`<1
00>?0Hl00P401Y01T06ES`8100FE0@6?U@020@04C@41U@@100==0@000P40
19FD0I@20BD000<1000050000`40000300001@020DT010400eY00@02FP03
0J0100<00P400g810@020@033XP>00<100>@LP400`401I1g0GL100D000@1
Q05g20400i01000200040I01T0L100>@0ID00`4029F@0I01T9F@0P401@01
0I00008100R@0@40T06E00@100==0@40204V00030@0001@000<100000`00
00L000<10000A`0;0@04004100@100=I0@400P400hT100020@04L@41R@81
00=a0@401@001@69P`5f00<100Mf0F^90I01008000T1MP41T0640I000`40
1I01006@00@100B?T0410P000`6ES`020@05U@41SiD01@4019D1CDd30@04
U041U@<1:0000`40000D00030@00008000080081B0060@04FP41FP8100Ag
0@6310400gL10@070@06T041P`5g0P4300H100Yg0@6@0HV40I010P020@03
T06@008100V@0@4100400ID010400i010@0400<100>@0@4010401@010ID0
00H100>E0@40104Z00030@0001<000<100000P0000X000<10000A`050@04
FP41F@8100EbF@41R0040@08L@41R@5gLGL20@0;L@63R@5g0@01T7400P40
0hT10@0D0@@00`400f`1T0040@03004100<100>?0FH00`4018l10ID30@04
U@4000P1;0000`40000B00030@000080000;0081B00<0@04FP63X08100Mb
0@5gLP63008100B@M`630`4010010I020@05Mi01RH@00P402HV40@690HV4
R@030@800`47008100>E0@400P401I01JhA[00T100JE0041U@050@03006E
0081;`000`40000A00030@000080000=00030@0004H00P400cP1>0020@04
FP41F@@100F80@5IM`040@08PhT10H>9PhT20@05L@410G400P400i010@04
0@06J`410F^40P400f/100030@03MP4100D100>?0@400P4019D10Hl90@03
S`6?008100<00@400`4014`100030C0000<100004@000`40000200003P00
0`40001600`100>3X040104017L1RH<60@07RH<10I01T0050@06T041PhV3
3@401I010HA[008100JE0@5[0I060@03004100<100<0U@40204014`10@04
0C8000<1000040000`40000200003`020DP00P400`010@070@03Ph8100L1
00>8P`400P030@03Mg4100D100>4Ji001@400i010@0300030GH1008100If
0F/1Jh@;0@8010400iD1U@020@07S`410Hl1C0090C@000<100003`000`40
000200004@000`40001700810P0F0@<00P400i010@070@03T06@01D100>4
Jh@00`400`010@020@03T041008100>E0@403P4f00030@0000h000<10000
0P0001800P5900040@0000H100=O0GL00`400h<10@040@04P`410@800P40
0gIg0@060@04T041J`T100=[P`401`400fH10@090@03C@4100T100>D0@40
104i00030@0000h000<100000@0001@000<10000B`090@03FP41008100>8
0@400`400hP1000200030I1g00@100B@0@630`4017NEMiD30@03Q6/100/1
00=[IP402`42U@8100>E0@401`4k00030@0000d000<100000@0001D000<1
0000A`020@800`400`010@050@804@400i1g0@030@08T7N@Mi1gT7L=0@03
IP4100P100BET06@2@4017/10@4m00030@0000d000<100000@0001H00P58
00<100<00@400`4200d100<00@402`402YEgUGNEMiEgUGLV0D0000<10000
30000`400001000060000`40001700@100=00@401`400fD10@0D0@08T7N@
Mi1gT7LL0@801`5300030@0000/000<100000@0001T00P5900@100=O0El0
1`4018>20H8<0@03P`4100H100=g0@400`401fJ3IP6@UI004042U@P1AP00
0`40000:00030@000040000K00030@0004P02P4200P100=U0@405`400gNE
M`020@03UGNE010100@00@41B@000`40000900030@000040000L0081BP0;
0@802`4018=ZPfX60@03004100800`400h=U0@020@03MiEg01@1B`000`40
000:00410@0100007P000`40001901@100=g0@400`400gL10@0>0@03UGNE
01@1CP000`40000900410@0100007`000`40001900030@01018100=g0@00
204016F30@42008100=gU@404P5C00030@0000P00@410040000P0081B@00
0`40000201D100=g0GL01@400gag0@0200@10P0?0ED000<100001`010@40
0@00028000<10000AP000`40000501l100AlMg`10P0=0EP000<100001P01
0@400@0002<00P5600030@0000P0:`5L00030@0000H00@410040000U0003
0@0004<000<100003@0H0@03GgaO00D1H`000`40000500410@0100009P02
0D<000<100004`0:0@801@4014EO0@5Y00030@0000D00@410000:0000`40
001000030@00098000<1000010010@40000Y00030@0003l000<10000T`00
0`40000300410@0002X00P4o00030@0009@000<100000P010@40000/0003
0@0003`000<10000U0000`40000200410@0002d00P4l00030@0009D000D1
00000@010000;`000`40000i00030@0009H000@100010@00030000<10000
>0000`40002G00030@010040000a0081=`000`40002I00410@010@00<`00
0`40000d00030@0009T00@410041000d0081=0000`40002J0081000f0003
0@00034000<10000V@030@00=`020C4000<10000U@040@<0000i00030@00
02h000<10000T0050@L0000j00030@0002d000<10000S0040@`0000k0081
;@000`40002800@1400003d000<10000:P000`40002300D1500003h00P4Z
00030@0007l0104I0000@0000`40000W00030@0007X01@4M0000@@000`40
000V00030@0007H0104R0000@P020BH000<10000LP040BH0001400030@00
02<000<10000K@050BX0001500818`000`40001Y00@1;`0004L000<10000
80000`40001T00D1<`0004P00P4P00030@000600104h0000BP000`40000M
00030@0005/01@4l0000B`000`40000L00030@0005L010510000C0020A`0
00<10000D`040DD0001>00030@0001T000<10000CP050DT0001?00816@00
0`40001:00@1CP00054000<100005P000`40001500D1DP0005800P4F0003
0@000440105G0000E0000`40000C00030@0003d0105K0000E@000`40000B
00030@0003P01@5O0000EP020A4000<10000=@040F@0001H00030@0000h0
00<10000<0050FP0001I00813P000`40000/00@1K@0005/000<100002`00
0`40000W00D1L@0005`000<100002P000`40000S00@1MP0005d00P4:0003
0@0001l0105j0000G`000`40000700030@0001X01@5n0000H0020@L000<1
00005P040H<0001R00030@0000@000<100004@050HL0001S008110000`40
000=00@1S00006D000D100000@0;00@1T00006H000@100011P050I@0001W
00<10P040IT0001Y00<1W@000001
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{265.438, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Chapter 6: Saddle Surface", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(CylindricalPlot3D[
        r^2\ Cos[2\ phi], \ {r, \ 0, \ 1/2, \ 1/20}, \ {phi, \ 0, \ 2  Pi, \ 
          2  Pi/36}];\)\)], "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000m`P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgMo000>OWifm_K`00V@00
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcol<00P5K0000`@020@03004105X0002n00<10`020EX0002l00811P00
0`400@1I0000^@030@P000@10001F0000;L00P4;00040@000EP0002d00<1
3@001@40000105L0002b008140001@40000105L0002_00<14P000`400002
00030@0005@0002]00815P000`40000200030@0005<0002Z00<160000`40
000200030@0005<0002X00816`000`40000300030@000580002U00<17@00
0`40000400030@000540002S008180000`40000400030@000540002P00<1
8P000`40000500030@000500002N00819@000`40000600030@0004l0002K
00<19`000`40000600030@0004l0002I0081:P000`40000700030@0004h0
002F00<1;0000`40000800030@0004d0002D0081;`000`40000800030@00
04d0002A00<1<@000`40000900030@0004`0002?0081=0000`4000090003
0@0004`0002<00<1=P000`40000:00030@0004/0002:0081>@000`40000;
00030@0004X0002700<1>`000`40000;00030@0004X000250081?P000`40
000<00030@0004T0002200<1@0000`40000=00030@0004P000200081A000
0`40000<00030@0004P0001m00<1AP000`40000=00030@0004L0001k0081
B@000`40000>00030@0004H0001h00<1B`000`40000>00030@0004H0001f
0081CP000`40000?00030@0004D0001c00<1D0000`40000@00030@0004@0
001a0081D`000`40000@00030@0004@0001^00<1E@000`40000A00030@00
04<0001/0081F0000`40000A00030@0004<0001Y00<1FP000`40000B0003
0@000480001V00<1G@000`40000C00030@000440001T0081H0000`40000C
00030@000440001Q00<1HP000`40000D00030@000400001O0081I@000`40
000E00030@0003l0001L00<15@050Dd000<100005@000`40000o0000FP02
0A801P401Hma0G6:00H1A`000`40000F00030@0003h0001G00<13`050@09
LHYaRW6:LHX100Qa1P5100030@0001L000<10000?@0005D00P4?00<101aa
Sg6?LHmaSg6?LHmaS`6:LHYaRW6:LHYaRW6:0`4o00030@0001H000<10000
?@0005800`4?00<1016:LHYaRW6:LHYaRW6:LHYa0@0?L@<1?@000`40000G
00030@0003`0001@008140020@0VSg6?0HmaSg6?LHmaSg6?LHmaS`6:LHYa
RW6:LHYaRW6:LHX1LW420C/000<1000060000`40000k0000C@030A4001L1
LHYaRW41LHYaRW6:LHYaRW6:LHYa0@0?L@030G5a009a0P4i00030@0001P0
00<10000>`0004/00P4B008102eaSg6?LHma0G6?LHmaSg6?LHmaSg6?L@5a
RW6:LHYaRW6:LHYaRP5bLG9aLW400P4g00030@0001T000<10000>P0004P0
0`4B008101Z:LHYaRW6:LHX1RW6:LHYaRW6:LHYaRW6:0@ia00<1LG401W40
0`40000d00030@0001T000<10000>P0004H00P4D000e0G6?LHmaSg6?LHma
0G6?LHmaSg6?LHmaSg6?L@5aRW6:LHYaRW6:LHYaRP5bLG9aLW5bLG800P4d
00030@0001X000<10000>@0004<00`4D008101eaRW6:LHYaRW6:LHYa0G6:
LHYaRW6:LHYaRW6:0@0?L@030G5a00Qa0P4b00030@0001/000<10000>000
04400P4E008103^?LHmaSg6?LHmaSg6?LHl1Sg6?LHmaSg6?LHmaSg6?0HYa
RW6:LHYaRW6:LHYa0G5bLG9aLW5bLG9aLP020C0000<100006`000`40000h
0000?P030AH002<1LHYaRW6:LHYaRW6:LHYaRW41LHYaRW6:LHYaRW6:LHYa
0@0>L@030G5a00aa0P4^00030@0001`000<10000=`0003`00P4H000Q0HX1
LHmaSg6?LHmaSg6?LHmaSg41LHmaSg6?LHmaSg6?00D101j:LHYaRW6:LHYa
RW41LG9aLW5bLG9aLW5bLG9aLP4]00030@0001d000<10000=P0003T00`4I
000M0G6?0HYaRW6:LHYaRW6:LHYaRW6:0HYaRW6:LHX01@400hYa0@02L@D1
1g400`5aL@0>L@<1:`000`40000M00030@0003H0000g00816`006P6:ShZ?
0HmaSg6?LHmaSg6?LHmaSg6?0Hma10403i1aT76@LI01T76@LI1aT0050@0G
RW41LG9aLW5bLG9aLW5bLG9aLP5bL@40:P000`40000N00030@0003D0000d
00<17@005`6?LHma0G6:LHYaRW6:LHYaRW6:LHYa00<100eaRW6:LHYaRW6:
LHX100]a104?L@050G5aL@40:@000`40000O00030@0003@0000b00817`00
5P6?RXn:ShX1LHmaSg6?LHmaSg6?LHl30@0NT76@LI1aT76@LI1aT741LI1a
T76@LI1aT76@L@5a0P404W9aLW5bLG9aLW5bLG81LW5bL@819`000`40000O
00030@0003@0000_00<180005@6?LHmaSg6?L@5aRW6:LHYaRW6:L@020@0B
RW6:0HYaRW6:LHYaRW6:LHX13G40105aLG420@]a00<1LG4017400`40000T
00030@00020000<10000<`0002d00P4R000m0Hn:ShZ?RXn:S`6?LHmaSg6?
LHma0G6@LI1a0G6@LI1aT76@LI1aT741LI1aT76@LI1aT76@LI01Rg6;L@02
0@0BLW5bLG9aLW5b0G9aLW5bLG819@000`40000Q00030@000380000Z00<1
8`00506?LHmaSg6?LHmaS`6:LHYaRW6:0P405W6:LHYaRW41LHYaRW6:LHYa
RW6:L@4=L@030G5a00Aa0P47L@030G5a00Ia0P4T00030@00020000<10000
<P0002P00P4U00130Hn:ShZ?RXn:ShZ?RP5aSg6?LHl1T76@LI1aT76@0I1a
T76@LI1aT76@LI01T76@LI1aT76@LI1aT06;LH]aRg6;L@020@0ALW5bLG81
LW5bLG9aLW5bL@408`000`40000Q00030@000340000U00<19P004`6?LHma
Sg6?LHmaSg6?L@5aRW400P406HYaRW6:LHYaRW6:0HYaRW6:LHYaRW6:L@40
3G400`5aL@08L@810g400`5aL@09L@030@00020000<100008@000`40000a
00008`020BT00141RXn:ShZ?RXn:ShZ?RXl1S`020@0eLI1aT76@LI1aT76@
L@5aT76@LI1aT76@LI01T76@LI1aT76@LI1aT06;LH]aRg6;LH]aRg400P40
3W81LW5bLG9aLW5bLG9a0P4P00030@00028000<10000<00002000`4Z000`
0G6?LHmaSg6?LHmaSg6?LHl1RW6:LHYaRW6:LHYaRW6:0HYaRW6:LHYaRW6:
LHX137400`5aL@0<L@813W400`40000M00030@0002<000<10000;`0001h0
0P4/001=0HZ?RXn:ShZ?RXn:ShZ?RXl1S`6@LI1aT76@LI1aT76@LI01T76@
LI1aT76@LI1a0G6@LI1aT76@LI1aT741LH]aRg6;LH]aRg6;LH/00`403W9a
LW5bLG9aLW5bLG817P000`40000S00030@0002l0000K00<1;@00;P5aSg6?
LHmaSg6?LHmaSg6?0Hma0G6:LHYaRW6:LHYaRW6:L@5aRW6:LHYaRW470@Ya
00<1LG403740105aL@4=L@8170000`40000T00030@0002h0000I0081<002
0@0VRXn:ShZ?RXn:ShZ?RXl1ShZ?RP5aT76@LI1aT76@LI1aT741LI060@07
LI1a0G6@L@070@0FLI1a0G6;LH]aRg6;LH]aRg6;0G9aLP8100iaLW5bLG9a
LW5bLG9a0A/000<100009@000`40000]00005P030C4002H1ShX1LHmaSg6?
LHmaSg6?0HmaSg6?0HYaRW6:LHYaRW6:LHYaRP<100^:LHYaRW6:LHYa0@09
L@D13G400`5aL@03L@030G5a00Ya0P4J00030@0002D000<10000;@0001@0
0P4d000T0HZ?0Hn:ShZ?RXn:ShZ?0Hn:ShZ?RXl1T76@LI1aT76@LI1a0`40
6g6@LI1aT76@LI1aT06@LI1aT76@LI1aT741L@020@0BRg6;LH]aRg6;LH/1
LW5bLG9a0P403G9aLW5bLG9aLP5bL@406@000`40000V00030@0002`0000A
00<1=@008`6:ShZ?0HmaSg6?LHmaSg41LHmaSg6?L@5aRW6:LHYaRW6:0081
011aSg41LHYaRW6:LHYaRW413740105aLG420@Qa00<1LG401g400`5aL@06
L@050EUaF@4060000`40000W00030@0002/0000?0081>0008@6?RXn:S`6?
RXn:ShZ?RP6:ShZ?RXn:ShX1LI1aT76@L@020@0TT8Z@RY01T76@LI1aT76@
LI1a0G6@LI1aT76@LI1aT06@LI1a0`407W6;LH]a0G5bLG9aLW5bLG81LW5b
LG9aLP5bLG9a0AL000<100009`000`40000[00003@020CT003L1ShZ?RXn:
S`6?LHmaSg41LHmaSg6?LHmaS`6:LHYaRW41LHmaSg6?L@5aRW6:LHYaRW6:
LHX100aa00<1LG401G420@=a00<1LG402G420@Aa00P1LEUaFG5I0AH000<1
0000:0000`40000Z00003@020CT001l1RXn:ShZ?RXl1ShZ?RP6:ShZ?RXn:
ShZ?RXl1T76@008102b:T8Z@RY2:T8X1LI1aT76@LI1aT741LI1aT76@LI1a
T76@0I1aT76@LI1aT08101aa0G5bLG9aLW5bLG9aLW41LG9a0G5bLG9aLW41
5@000`40000Y00030@0002T0000=00030@0103L001h1RXn:ShZ?RXn:0G6?
L@5aSg6?LHmaSg6?LHma0G420@0ISg6?LHmaSg6?LHl1RW6:LHYaRW6:LHYa
0@0;L@030G5a00Ua0P4>L@<100YILEUaFG5ILET150000`40000Y00030@00
02T0000=00040@000CH00541ShZ?RXn:ShZ?RP6:0HZ?RXn:ShZ?RXn:ShZ?
RP6:T8Z@RY2:T8Z@RY2:0G6@LI1aT76@LI1aT06@LI1aT76@LI1aT06@LI1a
T76@LI1aT7400`406W5bLG9aLW5bLG9aLW5b0G9aLW5bLG9aLW414`000`40
000Z00030@0002P0000<00030@00008000<10000<P00>P6?RXn:ShZ?RXn:
ShX1LHmaSg6?LHmaSg6?LHma0G41LHmaSg6?LHmaSg6?L@5aRW6:LHYaRW6:
L@4;L@030G5a00Ya00<1LG400P4<L@8100]aFG5ILEUaFG5I0@0B00030@00
02X000<10000:00000`000<100000`000`40000a001a0HZ?RXn:ShZ?RXn:
0HX1RXn:ShZ?RXn:ShZ?RP6:T06@RY2:T8Z@RY2:T8Z@0I1aT76@LI1aT76@
L@5aT76@LI1aT76@L@5aT76@LI1aT76@L@5aLW5b0G9aLW5bLG9aLW5b0G81
LW5bLG9aLW5bL@404@000`40000[00030@0002L0000<00030@0000@000<1
0000;`00>06:ShZ?RXn:ShZ?RXl1S`6?LHmaSg6?LHmaSg41LHmaS`6?LHma
Sg6?LHmaSg41LHYaRW6:LHYa2P45L@030G5a00Ua00<1LG400g420@Qa0101
LEUa0G5ILEUaFG5ILET14@000`40000[00030@0002H0000<00030@0000D0
00<10000;P00<P6?RXn:ShZ?RXn:S`6?RXl1ShZ?RXn:ShZ?RP6:T8Z@RP6:
T8Z@RY2:T8Z@RY2:0G6@1P402W6@L@5aT76@LI070@0BT76@LI1aT76@L@5a
LW5bLG9a0P402g9aLW5bL@5aLW5b008100YaLW5bLG9aLW4140000`40000[
00030@0002H0000<00030@0000H000<10000;000<06?RXn:ShZ?RXn:ShX1
RXn:S`6?LHmaSg6?L@5aSg6?LHma0G6?LHmaSg6?LHmaS`<101N:LHYaRW6:
LHYa0G6:LHYaRW6:LHX1L@020@Qa00<1LG401g400`5aL@03L@0B0G5ILEUa
F@5ILEUaFG5ILET13`000`40000/00030@0002D0000<00030@0000L000<1
0000:`00;P6:ShZ?RXn:ShZ?RP6:ShZ?RXl1ShZ?RXn:S`6@RY2:T8Z@0I2:
T8Z@RY2:T8X30@0KLI1aT76@LI1aT76@0I1aT76@LI1aT741LI1a00<1011a
T76@L@5aLW5bLG9aLW5b0P405W5bL@5aLW5bLG9a0G5bLG9aLW5bL@4>0003
0@0002d000<10000900000/000<100002@020BX002d1RXn:ShZ?RXn:ShZ?
0Hn:ShZ?RP5aSg6?LHl1Sg6?LHmaSg6?0HmaSg6?LHl00P406g6?L@5aRW6:
LHYaRW6:L@5aRW6:LHYaRW6:0@06L@810g400`5aL@0:L@<101AILEUaFG5I
LET1FG5ILEUaFG5I0@d000<10000;@000`40000T00002`000`40000;0003
0@0002L00581ShZ?RXn:ShZ?RXl1ShZ?RXn:ShX1RXn:S`6@RY2:T8Z@RY2:
0HZ@RY2:T06@RY2:T06@LI1aT76@LI1aT06@LI1aT76@LI1a0G6@LI1aT76@
0P409W41LG9aLW5bLG9aLW5bLG81LW5bLG9aLW5bL@5aLW5bLG9aLW413000
0`40000^00030@0002<0000;00030@0000`000<100009@00:`6?RXn:ShZ?
RXn:ShX1RXn:ShZ?RXn:0G6?0HmaSg6?LHmaSg6?L@5aSg400P407XmaSg6?
LHl1RW6:LHYaRW6:LHX1RW6:LHYaRW6:0@Ya0P4>L@8101EaFG5ILEUaFG5I
0EUaFG5ILEUaF@402`000`40000_00030@000280000;00030@0000d000<1
00009000:@6:ShZ?RXn:ShZ?RP6:ShZ?RXn:ShZ?0Hl1T8Z@RY2:T8Z@RY2:
T06@008102^:T8Z@RY2:T8X1LI1aT76@LI1aT741LI1aT76@LI1aT06@LI1a
T76@LI1a00<102AaLW5bLG9aLW5bLG81LP5bLG9aLW5bLG9a0G5bLG9aLW5b
L@4:00030@0002l000<100008P0000/000<100003P000`40000R001=0HZ?
RXn:ShZ?RXn:S`6?RXn:ShZ?RXn:S`6?LHmaSg6?LHmaSg6?LHl1Sg6?LHma
Sg6?LHma0G6:LHYaRW6:LHX1RW6:LHYaRW6:L@402W400`5aL@020@Ua00@1
LG5a0P402EUaFG5ILEUaF@020@09LEUaFG5I0ET100P00P4b00030@000240
000;00030@0000l000<100008@020@1JRXn:ShZ?RXn:S`6?RXn:ShZ?RXn:
S`6@0I2:T8Z@RY2:T8Z@RY01T06@RY2:T8Z@RY2:T06@LI1aT76@LI1a0G6@
LI1aT76@LI01T76@LI1aT76@L@5aT76@0P408W5bLG9aLW41LG9aLW41LG9a
LW5bLG9aLP5bLG9a0EUbF@4400<10P000`40000`00030@000200000:0003
0@00014000<100007`000`6?RP020@19ShZ?RXn:ShX1RXn:ShZ?RXn:ShX1
RXl1Sg6?LHmaSg6?LHl1Sg6?0HmaSg6?LHmaSg6?0HYaRW6:LHYaRW41LHYa
RW6:LHYa0@0:L@030G5a00Aa0P45L@030G5a00Aa01@1FG5ILEUaFG5IL@5a
FG41LEUaF@@11@000`40000`00030@000200000:00030@00018000<10000
7P00@@6:ShZ?0Hn:ShZ?RP6:ShZ?RXn:ShZ?RP6:T8Z@0I2:T8Z@RY2:T06@
RY2:0HZ@RY2:T8Z@RY2:0G6@LI1aT76@00P101QaT76@0I1aT76@LI1aT741
LI1aT76@LI020@0LLG9a0G5bLG9aLW41LG9aLW5bLG9aLP5b0G9ILP@12000
0`40000`00030@0001l0000:00030@0001<000<100007@00?06?RXn:S`6?
RXn:S`6?RXn:ShZ?RXn:S`6?RXn:S`6?LHmaSg6?0HmaSg6?L@5aSg6?LHma
Sg6?L@5aRPD100R?L@5aSg6?L@H12G400`5aL@08L@<12G403@5ILEUaFG5I
LEUa0G400`40175IL@4900030@0002l000<100007`0000X000<100005000
0`40000K00080Hn:ShZ?RXl20@0_RXl1ShZ?RXn:ShZ?RXl1T8Z@RY2:T06@
RY2:T06@RY2:T8Z@RP6:T8Z@RY2:T8X010404i1aT76@LI1a0G6@LI1aT76@
0I0010409W6@LI1a0G6@LI1aT76@LI1aT05bLG9aLW5bLG9a0G5bLG9aLW5b
0`40279ILUUbFG812@000`40000_00030@0001h0000:00030@0001D000<1
00006P00=`6:ShZ?RXn:ShX1RP6:ShZ?RXn:ShZ?0Hn:ShZ?RXn:S`6?LHl1
Sg6?LHmaSg6?L@5aSg6?LHl00P406g6?0HmaSg6?LHmaS`6?LHmaSg6?L@5a
LW5bL@040@03L@5a00]a0`49L@8100AaFG5I0P40379ILP5aFG5ILEUa0@P0
00<10000<0000`40000M00002P000`40000F00030@0001T003D1ShZ?RXn:
ShZ?RP6:ShZ?RXn:ShZ?RP6:T8Z@RY2:T8Z@0I01T8Z@RY2:T8Z@RY01T8Z@
RP020@0QT8Z@RP5aT76@LI1aT741LI1aT76@LI1a0G6@LI1aT76@008101Ya
T76@LI1aT76@LI01Mg41LG9aLW5bLG9aLPD100ibLG9aLP5bFG9ILUUb0@P0
00<10000;`000`40000M00002P000`40000G00030@0001L000`1ShZ?RXn:
ShZ?RXl30@0UShZ?RXn:ShX1RXn:ShZ?RXn:ShZ?0HmaSg6?LHmaSg6?LHl1
S`020@0TLHmaSg6?L@5aSg6?LHmaSg41LHmaSg6?LHl1LW5bLG9aLW5b0`49
L@060G9aLW411g440@0BL@5bFG9ILUUb0G5ILEUaFG4120000`40000_0003
0@0001`0000900030@0001T000<100005P00G@6:ShZ?RXn:ShZ?0Hn:S`6?
RXn:ShX1RY2:T8Z@RY2:T8Z@0I01T8Z@RY2:T8Z@RY2:T06@RY2:T8Z@RY01
T76@LI1aT76@0I1aT76@LI1a0G6@LI1aT76@L@5aT0020@0=LI1aT76@L@5a
Mg5gL@020@03LW41008101MaLW5b0G9aLW5bLG9aLP5bFG9ILUUb0@080003
0@0002l000<100006`0000T000<100006P000`40000E001O0Hn:ShZ?RXn:
ShX1RXn:S`6?RXn:S`6?RXn:ShZ?RXn:ShX1RXl1Sg6?LHmaSg6?LHl1S`6?
LHmaSg6?LHl1Sg6?LHmaSg41LHmaSg6?LHl1LW5bLG9aLW5b0G9aLW400P45
L@070G9aLW5bL@030@Ia01D1LP5bFG9ILUUbFG81LEUaFG5IL@401`000`40
000_00030@0001/0000900030@0001/000<1000050004@6:ShZ?RXn:ShZ?
0Hn:ShZ?008104j:S`6@RY2:T8Z@RY2:T8X1RY2:T06@RY2:T8Z@RY01T8X1
RY2:T8Z@RY2:0G6@LI1aT76@0I1aT76@LI1aT06@LI1aT76@L@5aT76@LI02
0@07LI1a0G5gL@030@0OLGL1LW5bLG81LW5b0G9aLW5bLG9aLP5bFG9ILUUb
0@0700030@0002l000<100006P0000T000<1000070000`40000B001T0HZ?
RXn:ShZ?RXl1ShZ?RXn:ShX1RP6:ShZ?RXn:ShZ?RP6:ShZ?RXl1Sg6?LHma
S`6?LHma0G6?LHmaSg6?L@5aSg6?LHmaS`6?LHmaSg6?L@5aLW5bLG9aLP5b
LG9aLW5bL@<100Ya0@41LG9aLW5b0P43L@0H0EUbFG81LUUbFG9ILUUb0G5I
LEUaFG411`000`40000_00030@0001T0000900030@0001d000<100004@00
A`6?RXn:ShZ?RXn:0HZ?RXn:ShZ?RP6:T8Z@RY2:T8Z@RY01T8Z@RY2:T06@
RY2:T06@RY2:T8X1RY2:T8Z@RY01T76@LI1a00d1015aT76@LI1a0G6@LI1a
T76@L@030@0WLGMaMg5gLGMaMg41L@5aLW5bLG81LW5bLG9aLW41FG9ILUUb
FG8100L000<10000;P000`40000I00002@000`40000N00030@00010001D1
RXn:ShZ?RXn:0HZ?RXn:ShZ?RXl00`40:hn:ShZ?RXn:S`6?RXn:ShZ?RXl1
Sg6?0HmaSg6?LHl1Sg6?LHmaSg6?0Hl010403G6@0I1aT76@LI1a0G400`40
2g5bLG81LW5bLG9a00<102Ya0@41LG9aLW5bLG9aLW41FG9ILUUbFG81LUUb
FG9ILUT1FG5ILEUaF@4700030@0002l000<10000600000P000<100008002
0@l00441RXn:ShZ?RXn:S`6?RXn:ShZ?RXl1T8n@0I2:T8Z@RY2:0HZ@RY2:
T8Z@RY01T06@RY2:T8Z@RY01T8Z@RY2:T0030@0DT76@LI1aT06@LI1aT76@
0I1aT7430@05L@5aT7400`401g6@L@5aMg400P409GMaMg5gLGMa0G41LG9a
LW5bLG81LW5bLG9aLW41FG9ILUUbF@401`000`40000_00030@0001L00008
00030@00028000<1000030006P6?RXn:ShZ?RXn:0HZ?RXn:ShZ?RP6:ShZ?
0P408hZ?RXn:0HZ?RXn:ShZ?RXn:S`6?LHmaSg6?LHmaS`6?LHma008101Z?
L@5aT76@LI1a0G6@LI1aT741LGMaMg5gL@D1039aLW5bLG81LW5bLG81LW5b
LG9a0G5bL@5ILUUbFG9ILP5bFG9ILUUbF@5ILEUaFG5I0@L000<10000;P00
0`40000G000020000`40000S00030@0000/003d1RXn:ShZ?RXn:0HZ?RXn:
ShZ?RXl1T8n@Si2?0HZ@RP6:T8Z@RY2:T8Z@RY01T06@RY2:T8Z@RY2:0HZ@
008101b:T8Z@0I1aT76@LI1a0G6@LI1aT06@LI1aT76@0P4047410I1aT76@
0GMaMg5gLGL20@0TLGMaM`5gLGMa0G5bLG9aLW5b0G9aLW5bLG9a0EUbFG9I
LUT11`000`40000^00030@0001H0000800030@0002@000<100002@007P6:
ShZ?RXn:ShZ?0Hn:ShZ?RXn:S`6?RXn:ShZ?RP8101b?0Hn:ShZ?RXn:ShZ?
RP5aS`6?LHmaSg6?LHma0P406hmaSg6?LHl1T76@LI1aT06@LI1aT76@0GMa
M`030@05M`5gLGL00P403G5bL@5aLW5bLG9aLW400P408G81LW5bLG9a0EUb
FG9ILUUb0G9ILUUbFG9I0EUaFG5IL@020@H000<10000;P000`40000F0000
20000`40000U00030@0000P005D1ShZ?RXn:ShZ?RP6:ShZ?RXn:ShX1Si2?
T8n@Si2?T06@RY2:T8Z@RY2:T8X1Si2?T06@RY2:T8Z@RP6?0HZ@RY2:T8X1
LI1aT76@LI01T76@LI1a00@100Z@LI1a0G6@LI1a0`405G5gLGMaMg5gLGMa
M`5gLGMaMg5gL@020@0CLW5bLG9aLP5bLG9aLW5bL@5ILP030@03LUT100H0
00<10000;P000`40000E000020000`40000V00030@0000L00201RXn:ShZ?
RXn:0HZ?RXn:ShZ?RXl1ShZ?RXn:ShZ?RP<1032:ShZ?RXn:ShX1LHmaSg6?
0HmaSg6?L@5aSg41LHmaSg6?L@5aT76@LI1a0G6@LI030@0gMg5gLGMaM`5g
LGMaMg5g0G9aLW5bLG9aLW5b0G81LW5bLG9aLW5b0G9ILUUbFG81LUUbFG9I
LP030@07FUAJE5YD0@0600030@0002h000<10000500000P000<100009`00
0`400005001@0HZ?RXn:ShZ?RXl1ShZ?RXn:ShZ?RP6?T8n@Si2?T8l1Si2?
0HZ@RY2:T8Z@0I2?T8n@S`6:T8Z@RP6?T8n@S`6:T8Z@RY01T76@LI1aT744
0@0BT741LI1aT76@0I1aT76@LI1a0`408G5gLGMaMg5gL@5aM`5gLGMaMg5g
LGL1LW5bLG9aLP5bL@040@0;LUT1FG9ILUUbF@401P000`40000]00030@00
01@0000700030@0002T000<1000010020@0SRXn:ShZ?RXl1ShZ?RXn:ShZ?
RP6:ShZ?RXn:ShZ?0Hn:ShX00P409hn:ShZ?0HmaSg6?LHma0G6?L@5aSg6?
LHma0G6?LHmaS`6@LI1aT00:0@0ALGMaMg41LGMaMg5gL@5aMg400P40779a
LW5bL@5aLW5b0G9aLW5bLG9aLP5bFG9ILUT30@0?FG9ILUUbF@5DFUAJE5X1
00H000<10000;P000`40000C00001`000`40000Z00030@0000<004/1S`41
ShZ?RXn:0HZ?RXn:ShZ?RXl1T8n@Si2?T8n@0I2?T8n@Si01T8Z@0I2?T8n@
Si2?T8l1RP6?T8n@Si2?T06@RY2:T8X1LI0010402GH1LI1aT741L@040@0?
T06@LI1aT76@0I1aT76@008100YaMg41LGMaMg5g0P402g5gLGMaMg5g0G9a
00<101=ILP5bFG9ILUUbF@5ILUUbFG8100H000<10000;P000`40000B0000
1`000`40000[00030@00008000@1ShZ?0P408XZ?RXl1ShZ?RXn:ShZ?RP6:
ShZ?RXn:ShX1RXn:ShZ?RXl20@0NRP5aSg6?LHmaSg6?L@5aSg6?LHmaSg6?
0HmaSg6?0`404I1aT76@L@5aT76@0I1aT76@00<100igLGMaMg41LGMaMg5g
L@81019b0G9aLW5bLG9a0G5bLG9aLW430@0GFG9ILUUb0G9ILUUbFG81FUAJ
E5YDFP401P000`40000]00030@000180000700030@0002`000@100011Xl2
0@0`S`6?RXn:ShZ?RXn:0Hn@Si2?T8n@Si01T8n@Si2?T8n@S`6?T8n@Si2?
T8n@S`6?0P402i2?T8n@Si2?T06@00<101N@S`5fT7J@MY01T76@LI01T76@
LI01T0040@0LL@5aT76@LI1aT76@0GMaMg5gLGMaMg41LGMaM`8101]aM`5b
FG9ILUUb0G9ILUUbFG81LUUbFG9ILP401@000`40000^00030@0001400007
00030@0002d000/1006:ShZ?RXn:S`030@0OShZ?RXn:ShZ?0Hn:ShZ?RXn:
S`6?RXn:ShZ?RXn:S`030@0ESg6?LHmaSg6?0HmaS`6?LHmaSg6?00@101ea
T76@0I1aT76@L@5aT76@L@5aT76@L@5aMg5gL@020@0;Mg5gLGMaMg5g0GL0
0P402g5bLG9aLW5bL@5a008101ibFG9ILP5bFG9ILUUb0G9ILUUbFG81FUAJ
E5YDFP4500030@0002h000<10000400000L000<10000;P020@V?00<1S`40
0`40<8Z?RXn:0Hn@Si2?T8n@S`6?T8n@Si2?T8n@0I2?T06@Si2?T8n@0I2?
T8n@0I2?T0<102:@0I01T8n@Si01T7J@MY1f0G6@LI01T76@LI01T76@LI1a
0`402g6@LI1aT05gLGMa008102YgLGMaMg5gL@5aMg5gLGMaM`5bFG9ILUUb
0G9ILUUbFG81LUUbFG9ILP4500030@0002d000<10000400000H000<10000
<000406:ShZ?RXn:ShX1RXn:ShX30@0ZRP6:ShZ?RXn:ShZ?0Hn:ShZ?RXn:
ShX1RXn:S`6?LHmaS`6?LHmaSg6?0`40:8ma0@6@LI01T76@LI01T76@LI01
T76@L@5aT76@L@5aMg5gL@5aMg420@0AMg5gL@5aMg5gLGL1LW5bLG800P40
8UT1FG9ILUUbFG81LUUbFG9ILP5bFG9ILUUb0EYDFUAJE04600030@0002d0
00<100003`0000H000<10000<0000`6?S`06S`030Hn?00N?0`406Xn@Si2?
T8n@0I2?T8n@Si2?T8l1Si2?T8n@0P402Hn@0I2?T8n@S`020@0]T8l1S`6?
T8n@S`6?T8n@S`5fT7J@MP5aT76@L@5aT76@0I1aT76@0I1aT76@008100Ya
0G5gLGMaMg5g0P40:7410GMbMg81LGMaMg5gLGL1LUUbFG9ILP5bFG9ILUUb
0G9ILUUbF@4500030@0002h000<100003P0000H000<10000;`005`6?RXn:
ShZ?RXl1ShZ?RXn:ShZ?RP6:00<101n:ShZ?RP6:ShZ?RXn:ShZ?0Hn:ShZ?
RXn:0G41LHma00<106IaSg6?L@5aT76@LI1a0G6@LI1a0G6@LI1a0G6@LI01
T76@L@5aMg5gL@5aMg5gLGMa0G5gLGMaMg5gLGMa0EUbFG9ILUT1FG9ILUUb
FG81LUUbFG9ILP5bFG9ILUUb0EYDFUAJE04500030@0002d000<100003P00
00H000<10000;`000`6?S`07S`030Hn?00R?00D1T8n@S`030@0GS`6?T8n@
Si2?T8n@0I2?T8n@Si2?T8l01@406Xn@Si2?T8l1S`6?T8n@Si2?0Hn@Si01
T7J@3P403G6@LI01T76@LI1a0G800P401gMaMg5gLGL00P402G81LWMbMg9g
LP020@0OMg5gLGMaM`5bFG9ILUUb0G9ILUUbFG81LUUbFG9I0@0500030@00
02d000<100003@0000H000<10000;`007@6?RXn:ShZ?RXl1ShZ?RXn:ShZ?
0Hn:ShZ?RXn:00<101>:ShZ?RXn:ShX1RXn:ShZ?RXn:00D101MaSg6?LHma
0G6@L@5aT76@LI1a0G6@L@040@0>T741LI1aT06@LI1a0G420@11M`5gLGMa
Mg41LGMaM`5gLGMaM`5gLGMa0EUbFG9ILUUb0G9ILUUbFG81LUUbFG9ILP5b
FG9ILUT1E5YDFUAJE0401@000`40000/00030@0000d0000600030@0002l0
00<1Shl01hl00`6?S`07S`0<0Hn@Si2?T8n@S`6?0`403Hn@Si2?0Hn@Si2?
T8l01040192?T8l20@0CT8n@Si01T8n@S`6?T8n@Si01T0020@0DSi01T7J@
MP5fT7H1MY1fT06@MY030@0;T76@LI01T7:@LY000P402G410GMbMg9gLP02
0@0WMg9gLWMbM`5gLGMaMg5g0G9ILUUbFG81LUUbFG9I0EUbFG9ILUT100@0
00<10000;@000`40000<00001@000`40000`000S0Hn:ShZ?RXn:0HZ?RXn:
ShZ?RXl1ShZ?RXn:ShZ?0Hn:ShX00`401hZ?0Hn:ShX00`402XZ?RP6:ShZ?
RXl20@0ZLHl1T76@LI1a0G6@LI1aT06@LI1a0G6@LI01T76@0I1aT741LI1a
T05g0P408g5g0GMaMg5gLGMa0G5gLGMaMg5gLGL1LUUbFG9ILP5bFG9I0101
00YbF@5DFUAJE5X11@000`40000]00030@0000/0000500030@0002l000<1
Shl01hl00`6?S`08S`0B0Hn@Si2?T8n@0I2?T8n@Si2?0`404hl10@6?T8n@
S`6?T8n@Si2?T8l00P40392?T8n@Si2?0Hn@S`8101b@0I2?T8l1MY1fT06@
MY01T7J@0I1fT06@Mi1g0P402Y1bT7:@LY1b0G820@0>Mg9gLWMbMg9g0GMb
Mg870@0@FWMJM`5bFW9JLUYb0G9ILPP100=ILP401@000`40000/00030@00
00/0000500030@0002l002P1RXn:ShZ?RXn:0HZ?RXn:ShZ?RP6:ShZ?RXn:
ShX1RXn:ShZ?RXn:1P4048n:ShZ?0Hn:ShZ?RXn:ShX30@0ZLI1aT76@L@5a
0G6@LI01T76@L@5aT741LI1a0G6@L@5aT741LGMaM`5g0P40175gLGL20@0=
LGMaM`5gLGMaMg5gL@050@0OFGMIM`5bFG9ILUUb0EYIFUUJFEX1FUUJFEYI
0EAJE0040@D000<10000:`020@`0000500030@0002l000<1Shl01hl00`6?
S`07S`0A0I2?T8n@Si2?T06@Si2?T8l010401I2?T8n@00<1012@0I2?T8n@
Si2?T8l1Si2?0P40:Y2?T8n@S`6?T8n@Si01T8n@S`5fT7H1MY01T7J@0I1f
T06@Mi01T7N@M`8100V@0I1bT7:@LY000P400g9g0@030@0YLWL1Mg9gLWMb
M`5gFWMJMeYg0G9JLUYbFW81LUUbFG9I0EUJFEYIFP4010000`40000X00<1
00<00@002`0000D000<10000;`008P6:ShZ?RXn:ShX1RXn:ShZ?RXn:0HZ?
RXn:ShZ?RP6:ShX30@0<RXl1ShZ?RXn:ShZ?0`405Xn:ShZ?RXn:S`6@RY2:
T06@LI1a0G420@0<T76@LI01T76@0I1a2P406901Mg5gL@5aMg5gLGL1Mg5g
LGMaMg5gL@8102igLGMaMg5g0GMIMeUgFGL1LUUbFG9ILP5JFEYIFUUJ0EYI
FUUJF@5DFUAJE5X110000`40000S00@110000`40000:00001@000`40000^
00030Hn?00N?00<1Shl028l02P6@Si2?T8n@Si040@0BSi2?T8l1Si2?T8n@
Si2?T06@0`403I2?T8n@0I2?T8n@Si000P401Xl1Si2?T08100N?T8n@0I2?
00<100Z@0GN@0I1gT06@0`40291g0GN@Mi1g0P401Y1g0@6@LP@10WL0;`5b
Mg9gLWMbM`5gLWMbMg9g0GMJMeYgFWL1LUYbFW9JLP5bFG9ILP5JFEYIFUT1
00D000<100007`030@P000<100002P0000D000<10000;P007P6?RXn:ShZ?
RXl1ShZ?RXn:ShZ?0Hn:ShZ?RXn:S`8101R:ShZ?RXn:S`6?RXn:ShZ?RXn:
0HZ?RXl30@0<ShX1RY2:T8Z@RY2:0P402i1aT76@L@5aT76@0081011fT06@
L@5aT06@L@5aT06@0P40375gLGMa0G5gLGMaM`8103IaMg5gLGMa0G5gLGMa
Mg5g0GMIMeUgFGL1LUUbFG9ILP5JFEYIFUT1FEYIFUUJ0EYDFUAJE0450003
0@0001/00`4<00030@0000T0000400030@0002l000<1Shl01hl00`6?S`07
S`070Hn@Si2?T0040@0LSi2?T8n@Si2?0Hn@Si2?T8n@S`6?T8n@Si2?T0<1
00^@Si2?T8n@Si01T0020@05Si2?T8l00P405I01T06@Si01T06@M`5gT06@
0I1gT0030@07T041Mi1gT0020@03Mi0100Qg02l1LWMbMg9gLWL1Mg9gLWMb
M`5gFWMJMeYg0G9JLUYbFP5ILUUbFG81FUUJFEYI0@0400030@0001L0104?
00030@0000T0000400030@0002l001P1ShZ?RXn:ShZ?0Hn:ShZ?RXn:S`6?
RXl30@0SShZ?0Hn:ShZ?RXn:S`6?RXn:ShZ?RXl1ShZ?RXn:ShZ?0I000`40
2Y2:T8Z@0I1fT7H20@0MT76@LI01T7J@0I1fT06@0I01T06@L@5aT06@LI00
0P400g5gL@020@0:Mg5gLGL1Mg5gLAX101UbFG81FUUJFEYI0EUJFEYIFP5J
E5YDFU@100@000<100004`030A<000<100002@0000@000<10000;`000`6?
S`07S`030Hn?00N?1040:I2?T8n@S`6?T8n@Si2?T8l1Si2?T8n@Si2?0Hn@
Si2?T8n@0I2?T8n@00<100V@S`6?T8n@Si000P4018n@0I020@0GSi01T8l1
T05g0GL1Mi01T7L1Mi01T7L00`4027N@Mi1gT7N@1045M`0E0G9gLWMbMg9g
0GMJMeYgFWL1MeYg00L101=bFW9J0EUbFG9ILP5JFEYIFUT100@000<10000
3`030AH000<100002@0000@000<10000;P004`6:ShZ?RXn:ShX1RXn:ShZ?
RXl00`40;hn:ShZ?RXn:0HZ?RXn:ShZ?RP6:ShZ?RXn:ShZ?0Hn:ShZ?RXn:
0HZ@RY2:T8Z@00@100MfT7J@MY1f00<100efT7H1MY01T7H1L@5a008100J@
0I1a0G420@08T7410I01Mg440@0WMg5g0GMbMg9gLWMb0EUgFGMIMeUg0GMI
MeUgFGL1FUUJFEYIFP5J00@1011I0EUJFEYIFP5JE5YDFU@110000`40000:
00@16@000`400009000010000`40000^00030Hn?00N?00<1Shl00hl30@0f
S`6@Si2?T8n@Si01T8n@Si2?T8n@0I2?T8n@Si2?T06@Si2?T8n@Si01T8n@
Si2?T8n@0I2?10401Y2?T06@S`8100N@S`6?T06@00T100^@0@5gT7L1Mi1g
T0020@09Mi1gT7N@Mi0100Qg01h1LWMbMg9gLP5JMeYgFWMJM`5gFWMJMeYg
0EmJGeX40@0<LUUbF@5IFUUJFEX110000`40000700<17@000`4000090000
10000`40000^02h101n?RXn:0HZ?RXn:ShZ?0I2:T8Z@RY2:T8X1Si2?T8n@
00@100AfT7J@0P401gH10I01T7H010400i01T0030@05T041MY000P4027J@
0GMaMg5g4P406eUgF@5IMeUgFGMI0EUJFEYIFUT1FEYIFUUJF@040@0:FUT1
E5YDFUAJ0@@000<100000`030B0000<100002@0000<000<10000;`002P6V
SjJ?YXnVSjH30@0QYXnVSjJ?YP6WSjN?YhnWSjL1T8n@Si2?T8n@0I2?T8n@
01<1012@Si2?0Hn@Si2?T8n@S`6?0`400hn@S`020@05T06@0I001@402901
0GN@0I1g0P401I1gT7N@00D100J@Mi1gT048M`040EmgG`T101AJMeX1FWMJ
MeYgFP5JGeYOFUmJ0@9J10401eUJFEYIFP4010050B@000<10000200000<0
00<10000;`001`6:ShZ?RXl01040=XZ?RXn:ShZ?RP6:ShZ?RXn:ShX1RXn:
ShZ?RXn:0HZ?RXn:ShZ?RP6:ShZ?RXn:S`6@Si2?T0T100Z@Si2?0GJ@MY1f
0`400gJ@0@0;0@03MP4100H100J@Mi1gT048M`0F0G9gLWMbMg9g0GMJMeYg
FWMJ0EYOFPH101=JFEYIFUT1FEYIFUUJ0EY0FT1J00<100MJE5YDFP4000<1
:0000`40000800000`000`40000_00040JJ?YP<104>VSjH1YXnVSjJ?YXnV
0JN?YhnWSjN?Y`6@Si2?T8n@Si01T8n@Si2?T8n@0I2?T8n@Si2?0Hn@Si2?
T8n@S`6?T8n@00X100>?T8l0<P403WMOMemgG`5JMeYgFWMJ1@402eYgFP5J
GeYOFUl100IJ0`401EUJFEX100<000<100009@000`40000800000`000`40
000_00@1052?RXn:ShX1RXn:ShZ?RXn:0HZ?RXn:ShZ?RP6:ShZ?RXn:ShX1
RXn:ShZ?RXn:0HZ?RXn:ShZ?0I2?T8n@Si2?T06@Si2?T8n@S`5fT7J@MRD1
1GL02`5OMemgGgMOM`5g00D100ig0EmJGeYOFUmJ0EUJF@@1011JFEYIFUUJ
0EY0FT1J@04h0`400e@1000300030@0002@000<10000200000<000<10000
;@030@18YXnVSjJ?YXnV0JJ?YXnVSjJ?YP6WSjN?YhnWSjL1T8n@Si2?T8n@
0I2?T8n@Si2?T06@Si2?T8n@S`6?T8n@Si2?T06@Si2?9`401GN@Mi0100Eg
2P43M`070EmgGgMOM`050@0<MeYgFWL1GeYOFUmJ0`401eYOFUmJG`401EX0
1@5J@5Y000<110000`40000S00030@0000P0000300030@0002/00P420010
0HZ?RXn:ShZ?RP6:ShZ?RXn:ShX1RXn:ShZ?RXn:0HZ?RXn:ShZ?0Hn:ShZ?
RXn:S`6?RXn:ShZ?RXl1T8n@S`T100f?T8n@S`5fT7J@MY1f02@117L01P5O
MemgG`L100QJMeYgFWL1G`D100UO0EYIFUUJFEX01@403eYI0D1J@5Y0FP5J
>5XhFP020@<000<100008`000`40000800000`000`40000X00<11000>@6V
SjJ?YXnVSjH1YXnVSjJ?YXnV0JN?YhnWSjN?0Hn@Si2?T8n@S`6?T8n@Si2?
T8l1Si2?T8n@S`070@0ASi2?T06@Si2?T8n@Si01T8l01@42T1D100>EMiD0
1`43M`L11gL00`5gG`050@08G`5JGeYOFUl40@0:FUmJGeYO0EY1FP@11UX0
205J@5Y0FT010`000`40000R00030@0000P0000200030@0002H00`47000d
0HZ?RXn:ShZ?RP6:ShZ?RXn:ShX1RXn:ShZ?RXl1ShZ?RXn:ShZ?0Hn:ShZ?
RXn:S`6?RPD10Xl04@6@Si2?T8n@Si01T8n@Si2?00D100=fT7H00`400hn@
0@0:0@03T04100D100=g0@400P43M`030GMg00<117L00`5OM`050@0:Mel1
FUmJGeYOFP@100QOFUmJGeX1@0@100UJF@50FT1J@5X00`403EY0FT1J0EXh
FSQJ>0400`000`40000R00030@0000L0000200030@0002<00`4:000_0JJ?
YXnVSjJ?YP6VSjJ?YXnVS`6?YhnWSjN?Yhl1Si2?T8n@Si2?0Hn@Si2?T8l0
1@4058n@Si2?T8l1Si2?T8n@Si2?0Hn@10401Hn@S`6@00<10Y020@0=T9D1
0I01T06@0I01T0040@03U@6E00<100>EM`401P400gMlM`080@=g1`401gMO
Memg0El00`402EmJGeX1@Em1G`040@07@EY1FT5J@@030@AJ00L1FT1J@5X1
00@000<100008@000`40000700000P000`40000P00<13@00:P6:ShZ?RXn:
S`6?RXn:ShZ?RXl1ShZ?RXn:ShZ?0Hn:ShZ?RXn:S`6?RPD10Xl00`6?S`07
S`090I2?T8n@Si2?00@100N@Si2?T8n@008100>?T8l00P401Y010Hl1S`T1
00AgT06@0P401GL1Mi1g00@117L70@04GgMOM`L100=OFUl01P40145O@El3
0@09G`5J@5Y0FT1J00<100QJ@5Y0FP51>0<100U00CQJ>5XhFP400`000`40
000Q00030@0000L0000200030@0001d00`4@000U0JJ?YXnVSjJ?0HnVSjJ?
YXnVS`6?YhnWSjN?Yhl1Si2?T8n@S`050@0FSjN?YhnWS`6?T8n@Si2?T8l1
Si2?T0@100N?0Hn@Si2?00<100B?T06@0P4019010ID20@0DT06@0I01T06@
0I01T9D1UGL1MiD30@03UGNE00<100=lMg`00P400gMlM`030@=g0P400gMO
M`040@05GgMO0D4010400emJG`030@08Gd5O@Em1Gd430@09@EY1FP5J@EY1
00<100M0FT1J@5X100<000<1000080000`40000700000P000`40000J00<1
4P008@6?RXn:ShZ?RXl1ShZ?RXn:ShZ?0Hn:ShZ?RXn:S`6?RP050@:?00<1
Shl01hl00`6?S`07S`030I01008100R@Si2?T8l1S`<100F?T8n@S`020@0J
T041Si01T8l1S`5f0GJ@0I01T7L1Mi01T7L30@9g1043M`H100EgGgMOM`06
0@EO1@40141O@5l30@03G`5100@100M0FT1J0D5000<100Q0FP51>44h@@81
00LhFSQJ>5X100<000<100007`000`40000700000P000`40000G00<15@00
7@6?YXnVSjJ?YXl1SjJ?YXnVSjJ?0HnWSjN?YhnW00@101Z?YhnWSjN?0HnW
SjN?YhnWSjL1T8n@Si2?T0<100V@Si2?T8n@Si000P401Hn@Si2?008100>E
T9D00P405I2E0IF@0I2E0ID1UI01T9F@U@6ET0030@03MiEg008100BEMiEg
0`401WMlMgagO0P100=OMel01`400dIOAP040@03Gd5O00@100=1Gd401040
0el1@@03@@<100M1FT5J@EY1008100EJ@5Y00@0400030@0001h000<10000
1`000003004001H00`4H000I0Hn:ShZ?RXn:S`6?RXn:ShZ?RXl1ShZ?RP04
0@03S`6?00R?00<1Shl028l00`6?S`02S`<100Z@0I2?T8n@Si2?0P401I01
T8n@008100>?T8l00P400i2?0@020@0?S`6?T06@0I1fT06@Mi1g00<100Ug
U@41MiEgU@400WL20@03O7L100<10WL20@06MemgGgMO1`400d1O@0040@03
Gd1O00D100=1@04010400d110@020@05@D11@4400`401d4h@CQ10D400P40
13QJ>04300030@0001h000<100001`000003004001<00`4K000F0HnVSjJ?
YXnVS`6?YXnVSjJ?YXl1S`<101b?YhnWS`6?YhnWSjN?Yhl1SjN?YhnWSjN?
Y`6@0`402jN?YhnW0I2?T8n@008100F?UHl1S`020@0<UI2ET06@UI2E0IF@
3`402i2E0IF@UI01MiEg00D100EgUGNEM`060@05O5mlGg`00P45G`d100=0
AP400`400d16@0040@03@@4100E10`401d5J@EX1@CP00P400eY00@030003
0@0001d000<100001`000003004001000`4N000C0Hn:ShZ?RXn:S`6?RXn:
ShZ?RP030@09RXn:ShZ?RXl100Z?00<1Shl01Xl30@0<T8n@Si2?T8l1Si2?
0P40:Y2?T8n@S`6?T8n@S`6?T8n@0I2?0HnES`6?U@6ET9D1UGL1MiEgU@6E
M`D100EgO7MlM`060@05O5mlGg`090401CQ00@4h00<100E0@@51>0020@07
@CQ10D4h@@020@03>040008000<100007@000`400006000000<00@003P02
0B4000l1SjJ?YXnVSjJ?0HnVSjH010407Hl1SjN?YhnWSjN?0HnWSjN?YhnW
SjL1YhnWSjN?008100bW0JN?YhnWSjN?Yhl30@06SiF?UHnE0P4018l10ID2
0@0JT9F@U@6ET9D1UI01T9F@0I2ET06@UI01T9D40@04MiEgU@8100=gUGL0
0P401GagO7Ml00D100AlGgaO1`4G00T100Q00@510D50@@8100M1FP51>44h
008110000`40000L00030@0000H000000`01000;00<18`00306?RXn:ShZ?
RXl1S`<1012?RXn:S`6?RXn:ShZ?RXl12Xl0106?Shl30@B?01P1T8n@Si2?
T8n@0I2?T8n@Si01T8n@Si020@0GSi2?T06@Si01UHnE0IF?0I2ET05gUGL0
10402YEgU@6EMiEgUGL40@03O7Ml00@100ANO5il1@4T00@100Q00@41@CQ1
>0<100Lh@CQ1>44100<000<1000070000`400006000000<00@0020030BH0
00T1SjJ?YXnVSjH00`407jJ?YXnVSjJ?0HnWSjN?YhnWSjL1YhnWSjN?YhnW
0JL00P403hnWSjN?Yhl1SjN?YhnWS`020@0@006ESiF?U@6ESiF?U@6ET081
01>E0IF@U@6ET9D1UI2E0IF@U@6E00810YD00`6EU@03U@030IEg00<100Al
UGbE10400gMlM`060B/00`401d010D11@4400P401cQ1>44h@@400`000`40
000K00030@0000H000000`40000500<1:@001`6?RXn:ShX00P405hl1ShZ?
RXn:ShZ?RP6:ShZ?RXn:ShX100R?0`49S`060I2?T8n@0P401hn@Si01T8l0
0P402i2?T8n@0I2?T8n@00<100R@S`6?UHl1S`P100ZET9F@0GNEMiEg0`40
17NEMiD30@04O7MlM`H1<@060@03>441008100E1>44h0@0400030@0001X0
00<100001P0000030@0000800`4/00040HnVS`<101n?YXl1SjJ?YXnVSjJ?
YP6WSjN?YhnWSjL1YhnWSjN?0081012W0JN?YhnWSjN?Yhl1SjN?0P403P2?
08l0S`6?0HnESiF?0P402IF@UI2E0IF@U@080@:E00D1UIFE0@06U@030ID1
00810YD00`6EO0020@04UGbEO0H1>0040@03@@50008100@h@CP110000`40
000I00030@0000H000000`400@020Bl00201S`41RXn:ShZ?0Hn:ShZ?RXn:
ShX1RXn:ShZ?RXn:0@B?0P44S`030Hn?00R?0`402Hn@Si2?T8n@S`020@0R
T8n@S`6?T8n@Si01UHnES`6?UHl1SiF?U@6ET9F@0I2ET0D100EgUGNEM`03
0@03Mgag00L1?@040@8h0P400d4h0@0300030@0001T000<100001P000081
<P020@0PYXnVSjJ?YXl1SjJ?YXnVSjJ?YP6WSjN?YhnWSjL1Yhl20@0KYhnW
SjN?0HnWSjN?YhnWSjL108l0S`2?08l0008100^?0041S`6@UI2ET0020@0:
UI2ET06@UI2E0@BE00@1UIFE1@44U@030ID100<100=lUG`0205200<100Hh
@041>04300030@0001T000<100001@0000030040034001l1ShZ?RXn:ShZ?
RP6:ShZ?RXn:ShX1RXn:ShZ?RXn:00<12Hl00`6?S`05S`81012@0I2?T8n@
Si01T8n@Si2?0P405Y2?T8l1SiF?UHl1SiF?U@6ESiF?0I030@08T05gUGNE
MiD30@04UGbEO0P1A`030@8h0P4400030@0001P000<100001@0000800P4`
000a0HnVSjJ?YXnVSjH1YXnVSjJ?YXnV0JN?YhnWSjN?Y`6WSjN?YhnWSjN?
Y`6WSjN?Y`020@0DSjN?Y`40S`2?0040S`2?08l1T0020@0?T06@UI2ET06@
UI2ET06E00D119D0106EUID30@:E00<1O0400P400g`10@030D`00P400cQ0
0@0300030@0001P000<100001@0000@000<10000;@007@6?RXn:ShZ?RXn:
0HZ?RXn:ShZ?RP6:ShZ?RXn:00<12hl0106?Shl20@0:T8n@Si2?0Hn@S`81
00b@Si2?T8l1SiF?UHl?0@0;SiF?0I2ET9F@0GL00P4019ElUG`30@03MP41
00D1C`020@03>040008000<100005`000`40000500001@000`40000/000/
0HnVSjJ?YXnVSjH1YXnVSjJ?YXnV0JN?YhnWS`6?Yhl1SjN?YhnWSjN?Yhl3
0@0/SjN?YhnWSjN?0Hl1S`2?08l0S`6@0900T06@0900T06E09D0U@6E09D0
U@45U@<119D20@:E0P400g/10@020E<00P4400030@0001H000<100001@00
00H000<10000;0006@6:ShZ?RXn:ShX1RXn:ShZ?RXn:S`6?RXl00P44S`03
0Hn?00V?0341T8n@Si2?T8n@Si2?0Hn@Si2?T8l1SiF?UHl1SiF?UHnE0IF?
UHnE0IF?UHnE0IF@00<100FD0GbEO0020@05UG/10ID0105L00030@0001D0
00<100001@0000L00P4/000f0JJ?YXnVSjJ?YP6VSjJ?YXnVSjJ?0HnW0JN?
YhnWSjL1YhnWSjN?YhnW0JL1YhnWSjN?YhnW0P408Xl10@2?08l1T02@0901
T02@09000@2E09D00@2E09D00ID20@BE00@1U@410YD20@03N`4100<1G@00
0`40000E00030@0000D0000900030@0002T001D1RXn:ShZ?RXn:0HZ?RXn:
ShZ?RXl00`48S`030Hn?00F?0P42S`0?0Hn@Si2?T8n@0I2?T8n@008101V?
0HnESiF?0HnESiF?U@6ESiF?U@6ESiF?00@100FEU9FDU@030@05UG^E0ID0
0`400g/1001O00030@0001D000<10000100000X000<10000:000<`6VSjJ?
YXnVSjH1YXnVSjJ?YXnVS`6?YhnWSjN?YhnW0JN?YhnWS`6?YhnWS`6?YhnW
S`020@0808l0S`2?08l30@0AT02@0I00T02@0040U@2E09D01@400iD00@04
U@8100BE0IFE1@400gH10@1R00030@0001@000<10000100000/00P4X000C
0HZ?RXn:ShZ?RP6:ShZ?RXn:S`030@^?00<1Shl00Xl00`6?S`05S`0B0Hn@
S`6?T8n@Si2?T8l1SiF?1P401iF?UHl1SiD01@4029F?UHnE0IFD0`401iBE
U05k0G/00`400gD1001T00030@0001<000<10000100000d000<100009@00
4@6VSjJ?YXnVSjJ?0HnVSjJ?0081016WSjL1YhnWSjN?YhnWS`6?Y`020@0:
SjN?YhnWSjL1Y`8101B?08l0S`2?08l1S`2?08l1T02@00L100X0U@6E09D0
U@2E0`45U@8100FE0@41N`020FH000<100004`000`40000400003P000`40
000T000A0HZ?RXn:ShZ?RXl1ShZ?RP401Hl00`6?S`09S`812hl02P6@Si2?
T8n@Si020@0JSiF?UHnE0IF?UHnES`6?UHnESiD1UHnESiD30@05UIBEU9D0
0P400i@10@020@03N`4006P000<100004P000`40000400003`000`40000S
000>0JJ?YXnVSjJ?YXl1SjH20@0PSjN?YhnW0JN?YhnWSjN?YhnW0JN?YhnW
SjN?YhnW0@020@0PS`2?08l00@2?08l0S`010900T02@0ID0U@2E0040U@03
0@03006E00>E0P401YFD0G/1MP81J`000`40000A00030@0000@0000@0081
8`002`6:ShZ?RXn:ShZ?00<12Hl00`6?S`07S`030Hl100V?0241T8n@S`6?
T8n@0IF?UHnESiD1UHnESiF?U@6ESiF?UHl010401iFDUI@1U9D00P400iBE
0@020@03NgD106h000<1000040000`40000400004P000`40000P000O0JJ?
YXnVSjJ?YXl1SjN?YhnWSjN?Yhl1SjN?YhnWS`020@0BYhl1SjN?YhnWSjL1
08l0S`2?0P405P0108l0S`2?0040T02@09000@2E09D40@0809D0U@2E0ID2
0@03UI@100@100=f0@00KP000`40000A00030@0000<0000C00030@000200
00P1ShZ?RXn:S`<138l00`6?S`03S`030Hn?00>?00<1Shl018l02P6@Si2?
T8n@Si020@0@SiF?UHnES`6?UHnESiD1U@@100V?0IBEU9FDUI@00`402IBE
0@5k0G^D0@1b00030@00010000<100000`0001@000<100007`001P6?YXnV
S`8102jVSjH1YhnWSjN?YhnWSjL1YhnWS`6?YhnWSjN?0HnWSjL108l0S`2?
08l00@2?10401@2?0I0000L100X0U@2E0040U@2E0`401YD1U9D1U@8100>D
0@40M0000`40000?00030@0000<0000E00817`001P6?RXn:0@F?00<1Shl0
2Hl00`6?S`020@V?01D1Shl1T8n@Si2?T8n@0@2?08l0S`001@403`2?006E
SiF?UHnE0IFDU@020@05U9FD0I@00P401ID1U7/107L000<100003P000`40
000300005`000`40000L00030HnV008101>?YXnVSjH1YhnWSjN?YhnWSjN?
0081032WSjN?YhnWSjN?Y`6W0@2?08l0S`2?0040S`2?08l0S`6E09D0U@2E
0ID0U@2E09D40@0509D0U@000P401YBE0IFD0GP000<100003P000`400003
000060000`40000K00<12Hl00`6?S`09S`030Hn?00^?0281T8n@Si2?T8n@
S`6?08l0S`2?0Hl0S`2?08l1SiF?UHnE0`401YFDUIBEU08100FEN`41U002
0GX000<100003@000`40000300006@000`40000J000W0HnVSjJ?YXnVSjJ?
0HnWSjN?YhnWSjL1Y`6WSjN?YhnWSjN?Y`40008101f?08l0S`2?0Hl0S`2?
08l1U@2E09D0U@0109D0U@020@070040U@2E00020@07U06D0IBE0@1m0003
0@0000`000<100000`0001X00P4J00030Hn?00V?00<1Shl01Xl20@04YXnV
0@V?00D1YXnVS`020@0HT8n@S`6?08l0S`2?0040S`2?08l00IF?0`401i@0
0IFDUI@00P4029FD0G/1Ni@1O`000`40000<00030@000080000L00030@00
01P002X1YXnVSjJ?YXnVS`6?YhnWSjN?0HnWSjN?0HnWSjN?YhnW0@2?08l0
S`020@0CS`6?08l0S`2?0040U@2E09D0U@030@08U@2E09D1U@020@07U02D
006EU0020H0000<1000030000`40000200007@000`40000G00030Hn?00V?
00<1Shl00hl02@6?YXnVSjJ?0@06S`0;0JJ?YXnVSjJ?YXl01@4028l0S`01
08l01`40202D09@0U06D0P4019FDUI@30@03N`40088000<100002`000`40
000200007P020AL00341YXnVSjJ?YXnVSjH1YhnWS`6?YhnWSjN?Yhl1SjN?
Y`40S`2?08l0S`2?0Hl0S`2?00P100d0U02D0ID0U@2E09D0008100BD09@0
0P4019@1U06500030@0000X000<100000P00020000<100005@000`6?S`08
S`030Hn?008100b?YXnVSjJ?YXnVS`42S`0U0JJ?YXnVSjJ?YXl1S`2?08l0
S`0108l0S`2?08l00@2D09@0U0020@04UIBEU08100>EU9D00P6600030@00
00X000<100000P00024000<100005000306?YXnVSjJ?YXnVS`8103>WSjN?
YhnWSjN?YhnW0JL108l0S`2?08l0S`0108l0S`2?08l1U02D09@0U00109D0
U@000`402P2D09@1U02D006900030@0000T000<100000P00028000<10000
4`000`6?S`09S`0b0JJ?YXnVSjJ?YXnVSjJ?YP6VSjJ?YXnVSjJ?YP40S`2?
08l0S`6?08l0S`2?0040U0030@0509@1U9D00P400iBEU0020H/000<10000
20000`40000200008`020A@001`1YXnVSjJ?YXnV0JL1YhnWSjN?YhnWSjN?
Y`400P407Hl0S`2?08l00@2?08l0S`2?0040U02D09@00@2E008100H0U02D
0I@20@0509@0U040SP000`40000700030@000080000U00030@00014000<1
Shl01Xl05@6VS`6?YXnVSjJ?YXnVSjH1YXnVS`020@0HYXnVSjH108l0S`2?
08l00@2?08l0S`2?0`401Y@0U02D008100BDUIBE0P6?00030@0000P000<1
00000@0002H000<100004000=@6VSjJ?YXnV0JN?Yhl1SjN?YhnWSjN?Y`40
S`2?08l00@2?08l1S`2?08l0S`0109@0U02D00@100h0U02D09@00@2D09@0
0I8000<100001`000`40000100009`000`40000?00030Hn?00B?01X1YXnV
SjJ?0HnVSjJ?YXnV0JJ?YXnVSjJ?YP8100f?0Hl0S`2?08l0S`6?00D100V?
0I@0U02D09@00`400iBEU0020I@000<100001P000`4000010000:0020A00
0281SjJ?YP6WSjN?YhnWS`6?YhnWSjN?0Hl0S`2?08l0S`2?3@4039@0U02D
0040U02D008100JD0I@0U06G00030@0000D000<100000@0002X000<10000
3@00>@6?Shl1YXnVSjJ?YXnV0JJ?YXnVS`6?YXnVSjJ?YXnVS`6?08l0S`2?
08l1S`2?08l0S`0109@0U0020@0509@00ID00P6H00030@0000D000<10000
0@0002/000<100003000=`6?YP6WSjN?YhnWSjN?Y`6WSjN?0Hl0S`2?08l0
S`2?0Hl0S`2?08l0S`0109@0U02D09@1U0000P401i@0U0010040V`000`40
000400030@000040000/00030@0000`00P40<ZJ?YXnVSjJ?YXnVSjH1YXl1
SjJ?YXnVSjJ?YXnV0@2?08l0S`2?0040S`2?08l0S`6D0P401P2D09@0U081
W@000`40000300030@000040000]00813000<P6WSjN?YhnWSjN?YhnWS`6?
0Hl0S`2?08l0S`2?0040S`2?08l0S`0109@0U02D09@00P4029@0U02D09@1
X0000`40000300410@010000;`000`40000:000?0JJ?YXnVSjJ?YXnVSjJ?
008101jVSjJ?YXnVSjJ?YP40S`2?08l0S`2?0Hl0S`2?08l20@0709@0U02D
00020J4000<100000`010@400@00030000<100002@004@6?YhnWSjN?YhnW
SjN?0Hl0008101V?08l0S`2?0040S`2?08l0S`2?0I@0U02D00@100H0U02D
09@20J@000<100000P010@400@0003400P4:000B0HnVSjJ?YXnVSjJ?0HnV
SjJ?0`404hnVSjJ?0Hl0S`2?08l0S`6?08l00`4038l0S`6D09@0U0400JD0
00D100000@020000<`000`400008000D0HnWSjN?YhnWSjL108l0S`2?08l2
0@0=08l1S`2?08l0S`2?00040@0:U02D09@1U02D00810P000`40002T0004
0@000@80000d00030@0000P001D1SjJ?YXnVSjH1YXnVSjJ?YXnVSjH03P40
2hl0S`2?08l00@2D008110000`40002T00040@000@80000e00030@0000L0
02h1YhnWSjN?Y`40S`2?08l0S`2?08l1S`2?08l0S`2?0040U02D09@0U001
09@11P000`40002U00030@010080000f00812000:P6VSjJ?YP6VSjJ?YXnV
SjJ?YXl1SjV?ZHnYSjV?ZHl1S`2?08l0S`0100811`000`40002V00030@01
0040000h00030@0000H002L1YhnW0@2?08l0S`2?08l0S`0108l0S`2?08l0
S`6D09@0U02D09@00P4900030@000:L00P410000>@000`400006000T0JJ?
0HnVSjJ?YXnVSjJ?YP6YSjV?ZHnYSjV?0Hl0S`2?08l00P4;00030@000:L0
0P410000>P000`400005000R0Hl1S`2?08l0S`2?08l00@2?08l0S`2?08l0
0@2D09@0U0813@000`40002W00810@0003/00P46008101bVSjJ?YXnVSjJ?
YP6YSjV?ZHnYSjV?Z@40S`2?0`4?00030@000:<010430000?@000`400005
008101N?08l0S`2?0040S`2?08l0S`2?0040U0030A8000<10000W`040@L0
000n00030@0000H00`404HnVSjJ?0HnYSjV?ZHnYSjV?00<15@000`40002K
00@12`0003l000<1000020020@0808l1S`2?08l80AL000<10000U`040@l0
001000812P080Al000<10000T`040A<0001200030@0002h000<10000S`04
0AL0001300030@0002d000<10000R`040A/000140081;@000`40002700@1
7`0004H000<10000:P000`40002300@18`0004L000<10000:@000`40001o
00@19`0004P000<10000:0000`40001l00<1:`0004T00P4X00030@0007P0
104^0000B`000`40000U00030@0007@0104b0000C0000`40000T00030@00
0700104f0000C@000`40000S00030@0006`0104j0000CP020B<000<10000
J0040Ch0001@00030@00020000<10000I0040D80001A00030@0001l000<1
0000H0040DH0001B00030@0001h000<10000G0040DX0001C00817P000`40
001H00@1CP0005D000<100006`000`40001D00@1DP0005H000<100006P00
0`40001A00<1EP0005L00P4J00030@0004d0105I0000F@000`40000G0003
0@0004T0105M0000FP000`40000F00030@0004D0105Q0000F`000`40000D
00030@000480105U0000G0020A@000<10000?P040FT0001N00030@000140
00<10000>P040Fd0001O00030@00010000<10000=P040G40001P00030@00
00l000<10000<P040GD0001Q00813`000`40000^00@1N@0006<000<10000
30000`40000Z00@1O@0006@000<100002`000`40000W00<1P@0006D000<1
00002P000`40000S00@1Q00006H00P4:00030@0001l010680000J0000`40
000700030@0001/0106<0000J@000`40000600030@0001L0106@0000JP02
0@H000<100004`040I@0001/00030@0000<000<100003`040IP0001]0003
0@00008000<100002`040I`0001^00050@0000402@040J00001_008100<0
0@0010040J@0001a008100<00@400P6X0000LP020J`00000
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{288, 247.5},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Chapter 7: Van-der-Pol Equation", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Module[{vdp, \ eps\  = \ 1.5, \ x, \ 
          xdot}, \n\ \ vdp\  = \ \(RKSolve[{xdot, \ 
                  eps \((1\  - \ x^2)\) xdot\  - \ x}, \ {x, \ 
                  xdot}, \ #, \ {5  Pi, \ 
                  0.05}] &\)\n\ \ \ \ \ \ \ \  /@ \ {{0.1, 0}, \ {\(-0.1\), 
                0}, \ {2, \(-2\)}, \ {\(-2\), 
                2}}; \n\ \ vdp\  = \ \(ListPlot[#, \ 
                PlotJoined\  -> \ True, \ 
                DisplayFunction\  -> \ Identity] &\)\  /@ \ vdp; \n\ \ Show[\ 
          vdp, \ AspectRatio\  -> \ Automatic, \ 
          DisplayFunction\  -> \ $DisplayFunction\ ]\n];\)\)], "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002Q000130P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcoj40002Q0000X@00054000<10000C@00054000<10000C@00054000<1
0000C@00054000<10000C@00054000<10000C@00054000<10000C@0002l0
0`4O0081CP0002`00`4300<170000`40001=0000:P020@T00P4J00030@00
04d0000Y00030@0000/00P4H00030@0004d0000W008140000`40000E0003
0@0004d0000V00030@0001400P4E00030@0004d0000U00030@0000H01P48
00030@00018000<10000C@0002@000<10000100;0@L000<100004@020Dh0
000S00030@0000<00`4800@11P020A4000<10000C@0002<000@100000`4=
00811`000`40000>00030@0004d0000R00040@0000<140020@H000<10000
3@000`40001=00008@00104000020A<00P4600030@0000`000<10000C@00
020000@100000P4F00811@000`40000200<11P000`40001=000080000`40
00020AP00P4500030@0000@000<100000`000`40001=00007`000`400003
0AT00P4200D110000`40000300030@0004d0000N00040@0000816`020@@0
00@100000P460081CP0001h000<100000P4M008110000`40000200030@00
00<000<10000C@0001d000@100000P4N008110020@8000<100000`000`40
001=00007@000`4000020B000P4400<11P000`40001=000070001@400001
02800P4400030@0000D000<10000C@0001`000<100000P4S00030@000080
00<100001@000`40001=0000700010400@4?00D14@000`40000200030@00
00@000<10000C@0001/000<100000P4<00<11@030@l000<100000P000`40
00030081CP0001/000@100412`020@/00P4=008110000`40000200030@00
04d0000J00030@0000812@020@l00P4<00810`000`40000200030@0004d0
000J00040@010@T000<100004@000`40000:00810`001@40000104l0000I
00030@00008120000`40000C00030@0000X000<100000P001040005?0000
6@0010400@4800030@0001D00P4:00810`001040005?00006@0010400@48
00030@0001L000<1000020020@<000<10040C`0001P000@1004120000`40
000I00030@0000P00P4300<1CP0001P000@100411`000`40000K00030@00
00P000<100000P000`40001=00005`0010400@4700030@0001d000<10000
1`020@<000<10000C@0001L000@100411P000`40000O00030@0000L00P42
0081CP0001L000@100411P000`40000O00030@0000P000H10001005=0000
5P0010400@4600030@00024000<100001`020@0400400Dd0000F00040@01
0@H000<100008P000`40000700<10P000`40001:00005P000`400@060003
0@0002@000<100001`020@8000<10000BP0001D000@100411@000`40000V
00030@0000H00`4200030@0004T0000E00040@010@D000<100009P000`40
000700810P000`400019000050001040004500030@0002P000<100001P03
0@8000<10000B00001@000@100011@000`40000Y00030@0000D00`430003
0@0004L0000D00030@0100D000<10000:`000`40000400040@010@8000<1
0000A`0001<000@100011@000`40000[00030@0000@000@100010`000`40
001600004`0010400@4400030@0002d000<100000`000`4000020@<000<1
0000A@0001<000<100401@000`40000^00030@0000800P4200810P000`40
001500004`000`400@0500030@0002h000<100000P000`40000200810P00
0`40001400004P001040004400030@00030000D100000@0400810`000`40
001300004P0010400@4400030@00034000@100011@020@8000<10000@`00
018000<1004010000`40000c00030@0100H000D100000@1400004P000`40
0@0400030@0002`0104300030@0100H00P4300030@000440000A00040@01
0@@000<10000;@000`40000400811`001@40000104<0000A00030@0100@0
00<100009`050@<000<1000010020@L000D100000@0l00030@0000<0000A
00030@0100@000<10000;`000`40000400811`020@<000<10000>@000`40
000300004@000`400@0400030@00030000<100000`020@P000<100000P00
0`40000g00030@0000@0000@00040@010@@000<10000;@00104000450003
0@0100P000D100000@0i00030@0000@0000@00030@0100@000<10000;`02
0@H000@100011`020@<000<10000=P000`400004000040000`400@040003
0@0003L000@1000120000`40000200030@0003@000<100001@0001000`44
00030@0003L000D100000@0800030@00008000<10000<`000`4000050000
3`0010400@4300030@0003P000<100000P000`40000500810`000`40000b
00030@0000H0000?00030@0100@000<10000>0020@<000<100001P000`40
000200030@00034000<100001P0000l000<1004010000`40000h00030@00
00<000<100001@020@<000<10000<@000`40000600003`030@<000<10000
>@000`40000300030@0000H00P4300030@0002l000<100001`0000l00`43
00030@0003T000<1000010000`40000600810`000`40000^00030@0000L0
000>00030@0100@000<10000>@000`40000500030@0000D00P4400030@00
02d000<100001`0000h000<1004010000`40000i00030@0000D000<10000
1P020@<000<10000;0000`40000800003P030@<000<10000>P000`400006
00030@0000H00P4300030@0002/000<10000200000h00`4300030@0003X0
0P4700030@0000L000<100000P000`40000Z00030@0000P0000=00040@01
0@<000<10000>P000`40000700030@0000H00P4400030@0002P000<10000
2@0000d000<1004010000`40000j00030@0000P000<100001P000`400002
00030@0002P000<100002@0000d00`4300030@0003/000<100002@000`40
000600030@00008000<100009P000`40000:00003@030@<000<10000>`00
0`40000900030@0000H00P4400030@0002D000<100002P0000d00`430003
0@0003/000<100002P000`400006008110000`40000T00030@0000X0000=
00810`000`40000l00030@0000/000<100001P020@@000<100008P000`40
000;000030000`400@0300030@0003`00P4<00030@0000L000<100000`00
0`40000Q00030@0000/0000<00<10`000`40000l00030@0000`000<10000
1P020@@000<1000080000`40000<000030030@<000<10000?0000`40000<
00030@0000L00P4400030@0001l000<10000300000`00P4300030@0003d0
00<100003@000`400007008110020Ah000<100003@0000`00P4300030@00
03d000<100003P000`40000700811@000`40000K00030@0000d0000<0081
0`000`40000m00030@0000h000<1000020000`40000400030@0001T000<1
00003P0000/000<100400`000`40000m00030@0000l000<1000020000`40
000300030@0001P000<100003`0000/00`4200030@0003h000<100004000
0`40000700811@020AL000<10000400000/00`4200030@0003h00P4A0003
0@0000P000<100001@000`40000D00030@000100000;00810`000`40000n
00030@00014000<1000020000`40000500030@00018000<100004@0000/0
0P4300030@0003h000<100004P000`40000800030@0000D00P4A00030@00
0180000;00810P000`40000o00030@00018000<100002@000`4000060081
3@020AD0000:00<10P000`40000o00030@0001<000<1000020020@T00P49
00815`0000X00`4200030@0003L00`4500030@0001@000<1000020020@X0
104300816@0000X00`4200030@0003P000<1000010000`40000D00030@00
00T00P4=00<16`0000X00P4200030@0003401@4300030@0000@00P4F0003
0@0000T00P4Z00002P020@8000<10000>@000`40000400030@0001H000<1
00002P000`40000W00002P020@8000<10000>@000`40000400030@0001H0
00<100002`000`40000V00002@030@8000<10000>0020@H000<100005`00
0`40000;00030@0002D0000900<10P000`40000i00030@0000@000<10000
60000`40000:00819P0000T00P4300030@00040000<1000060000`40000<
0081900000T00P4300030@00040000<100006@000`40000<00818`0000T0
0P4200030@00044000<100006@000`40000>00030@000200000800030@01
008000<10000@@020A/000<100003@020B40000800<10P000`4000110003
0@0001/000<100003P020Al0000800<10P000`40001100030@0001/000<1
00003`020Ah0000800810`000`40000U00T14`000`40000L00030@0000l0
0`4L000020020@<000<1000090000`40000700<140000`40000M00030@00
01000P4K00001`000`400@0300030@0002<000<100002`020@h000<10000
7P000`40000A00816@0000L000<100400`000`40000R00030@0000h000<1
00002`000`40000N00030@0001800`4G00001`000`400@0300030@000240
00<1000040020@/00P4P00030@0001<00P4F00001`030@8000<100008@00
0`40000C00030@0000P000<100007`000`40000D00<1500000L00`420003
0@00020000<100005@000`40000700030@00020000<100005@030A800007
00<10P000`40000P00030@0001H000<100001P000`40000P00030@0001L0
104?00001`020@<000<1000080000`40000G00030@0000D000<100008@00
0`40000H00@13@0000L00P4300030@0001l000<100006@000`4000040003
0@00024000<100006@040@`0000700810`000`40000N00030@0001/000<1
00000`000`40000Q00030@0001/000<100400P4900001`020@<000<10000
7P000`40000L00030@0000800P4R00030@0001/00P4010010@4800001`02
0@8000<100007P000`40000N00050@00004090000`40000L00030@010081
1`0000L00P4200030@0001h000<100007P020@8000<100008P000`40000M
00030@0100811P0000L01@4O00030@0000<17P000`400@0R00@17P000`40
0@030@D0000600@100<00@007P001@40000101l000<100408`000`400@0O
00030@0100811@0000<01P400`010@0K00D10`000`40000N00818`000`40
0@0O00030@0000811@0000H00`400`01000O00050@0000408@000`40000Q
00040@000Ah000<100000`4400001P030@03004101h000<100000P000`40
000O00030@00024000@100017`000`4000020@@0000600<100<00@407P00
104000020B400P4Q00810P000`40000M00030@000081100000H00P400`01
0@0O00030@00008000<100007`000`400@0Q00040@000Al01@4400001P02
0@8000<100007@000`40000T00030@0102@000<100007@000`4000020@@0
000600810P000`40000M00030@0002@000@100018`000`40000M00030@00
0081100000H00P4200030@0001d000<1000090001040004T00030@0001`0
00<100000P4400001P020@8000<100007@000`40000T00030@0000818`00
0`40000L00060@000@010`0000H00P4200030@0001d000<1000090001@40
000102<000<1000070001P4000400@<0000209l1000600<100<00@000`00
0`40000400030@0000D000<1000010000`40000200030@0100L000<10000
10000`40000400030@0000D000<100000P4200030@0000@000<100001@00
0`40000400030@0000D000<1000010001040004300030@0000D000<10000
10000`40000400030@00008000H10001004300001P020@8000<100007@00
0`40000Q00040@000BL000<1000070001P4000400@<0000600810P000`40
000M00030@00024000@100019`000`40000L00060@000@010`0000H00P42
00030@0001d000<100008@020@03004002D000<100007@001P4000400@<0
000600810P000`40000M00030@00028000<100409P000`40000M00060@00
0@010`0000H00`4200030@0001`000<100008P030BH000<100007@000`40
00020@@0000600030@01008000<1000070000`40000S00<19@000`40000M
00030@000081100000H000<100400P000`40000L00030@0002@000<10000
90000`40000M00030@000081100000L00P4200030@0001d000<100008`02
0BD000<100007@000`4000020@@0000700810`000`40000L00030@0002<0
0`4S00030@0001d000@100000P4400001`030@8000<1000070000`40000S
00030@0102<000<100007@00104000020@@0000800810P000`40000M0003
0@00028000@100018P000`40000M00030@0000<1100000T00P4200030@00
01`000<100008P000`4000020B4000<100007@000`4000030@@0000900<1
00<00@007P000`40000Q00030@00008000<100007@000`40000N00030@00
00<1100000X00`400`010@0M00030@0002400P4300030@0001d000<10000
7P001P4000400@@0000<00<100<00@0070000`40000P00030@0000<000<1
00006`000`40000O00060@000@01100000h0104L00030@00020000<10000
10000`40000J00030@0001l000H100010044000040040AX000<100008000
0`40000500030@0001T000<100007`001P4000400@@0000B00<16@000`40
000P00030@0000H00P4H00030@00020000<100400P45000050030AP000<1
00007`000`40000800030@0001@000<100008@000`400@020@D0000F00<1
5P000`40000O00030@0000T000<100004`000`40000P00030@0000<11@00
01P00P4F00030@0001h00P4;00030@00014000<100008@000`4000030@D0
000J00<150000`40000M00030@0000/000<100003P020B@000H100010045
000070020A@000<1000070000`40000<00<130000`40000T00060@000@01
1@0001d00`4B00030@0001`000<100003`020@P00P4V00040@0000811P00
01l00P4B00030@0001/000<100004@080BP000@100000P46000080030A00
00<100006`000`40001100030@0000<11P0002800P4@00030@0001X000<1
0000@@000`4000030@H0000S00813`000`40000J0081@P001P4000400@H0
000U00030@0000d000<100006@000`40001100030@0000811`0002D00`4=
00030@0001T000<10000@000104000020@L0000W00813@000`40000H0003
0@00040000@100000P470000:@000`40000;00030@0001L000<10000@000
0`4000030@L0000Y00813@000`40000>00<11@000`40001000030@0000<1
1`0002X00P4<00030@0000l000<1000010000`40001000060@000@011`00
02/00P4<00030@0000h000<1000010000`40001000060@000@011`0002`0
0P4;00030@0000h000<1000010020D0000L100000@0100L0000L00D13002
0@/000<100003@000`40000400030@0003l000@100000P4800006P020@D0
104900812P000`40000<00811P000`40000o00030@0000<1200001P00P4;
008120020@X000<1000030000`40000400030@0003l000H1000100480000
5`000`40000=00811`020@X000<100004P000`40000o00060@000@012000
01H000<1000040000`40000500812@000`40000B00030@0003h000L10000
0@0100P0000E00030@00018000<100001@000`40000800030@00014000<1
0000?P001`4000010040200001@000<1000050020@H000<1000020000`40
000@0081?`001`4000010040200001@000<100005P000`40000300812P00
0`40000?00030@0003h000<100000P400`01000700004`000`40000H0003
0@0000<000<100002@000`40000>00030@0003h000H10001004900004P00
0`40000J00030@0000<00P4:00030@0000d000<10000?@001`4000010040
2@00018000<100006`000`40000300812@000`40000=00030@0003d000L1
00000@0100T0000A00030@0001d000<100000`020@T000<1000030000`40
000m00070@0000400@09000040000`40000O00030@0000<000<100001`00
0`40000<00030@0003d000@100000P4:000040000`40000P00030@000080
0P4900030@0000/00P4n00030@0000<12P0000l000<100008P000`400002
00030@0000P000<100002P000`40000m00060@000@012P0000l000<10000
8`000`40000200030@0000L000<100002P000`40000l00070@0000400@0:
00003P000`40000U00030@00008000<100001`000`40000900030@0003`0
00@100000P4;00003P000`40000U00030@0000800P4900030@0000P000<1
0000?000104000020@/0000>00030@0002H000<100000P020@P000<10000
20000`40000l00040@0000812`0000d000<10000:0000`40000200812000
0`40000700030@0003/000@100000`4;00003@000`40000Y00030@000080
00<100001P000`40000700030@0003/000L100000@0100/0000=00030@00
02T000<100000P020@P000<100001P020C`000@100000P4<000030000`40
000[00030@0000800P4700030@0000H000<10000>`00104000020@`0000<
00030@0002`000@100000P4800030@0000D000<10000>P00104000030@`0
000;00030@0002h000@100000P4700030@0000D000<10000>P001`400001
0040300000/000<10000;P000`40000200030@0000H000<1000010000`40
000j00070@0000400@0<00002`000`40000_00030@00008000<100001P00
0`40000300030@0003X000<100000`4=00002P000`40000a00040@000081
20000`40000200030@0003T000@100000`4=00002P000`40000b00050@00
004020000`4000020081>P001`40000100403@0000X000<10000<P000`40
000200030@0000H000D100000@0k00070@0000400@0=00002P000`40000c
00040@00008120001040004j00040@0000<13P0000T000<10000=@001@40
000100T000<10040>P00104000030@h0000900030@0003H000D100000@08
00030@0103T000<100000P000`400@0>00002@000`40000f00040@0000H1
10020CT000@100000P400`01000=00002@000`40000g00040@0000<11P02
0CT000@100000`4?000020000`40000h00030@00008000<100401P000`40
000f00030@00008000<100403`0000P000<10000>@00104000030@H00P4g
00030@00008000<100403`0004D000@100000`450081=P000`4000020081
00<00@003P0004H000@100400P4500030@0103D000<100000P030A000016
00030@0000<11@001040004d00030@00008000<10040400004L000@10000
0P4400040@000C<000<100000P020@03004000l0001800030@0000811000
1@400001038000<100000P020@03004000l0001900030@0000810`000`40
000200030@0002h000<100000`000`400@0A0000B@00104000020@800P43
00030@0002h000<100000`000`400@0A0000BP000`4000020@8000<10000
0`000`40000]00030@0000800P400`01000@0000BP00104000020@030040
00D000<10000:`000`40000300040@000A40001;00040@0000<11P000`40
000[00030@0000<000<100404P0004/000@100000`4700030@0002T000<1
00000`020@0300400140001<00040@00008120000`40000X00030@0000<0
0P400`01000A0000C@00104000020@P000<100009P000`40000400030@01
01<0001=00040@00008120000`40000V00030@0000<00P400`01000B0000
CP000`4000030@P000<1000090000`40000400030@0101@0001?00050@01
00402@000`40000S00030@0000@000<10040500005000P400`010@090003
0@00024000<1000010020@03004001<0001@00810P020@T000<100007`00
0`40000500030@0101D0001A00030@0000812P000`40000N00030@0000D0
00<100405@0005400P4200812P000`40000L00030@0000D00P400`01000D
0000D@020@<00P4:00030@0001X000<100001P000`400@0F0000D@030@<0
00<100002@000`40000I00030@0000D00P400`01000E0000D@000`400@04
00030@0000T000<100005`000`40000600030@0101L0001A00040@000@<0
0P4;00030@0001D000<100001`000`400@0G0000D@001040004400812`00
0`40000D00030@0000H00P400`01000F0000D@001@40000100@00P4;0003
0@0001400P4900030@0101P0001A00030@00008000<100000P000`40000:
00813`020@X00P400`01000G0000D@000`40000300040@0000813@020@/0
0P4<00030@0101T0001A00811@00104000020@h00`4500<13@020@030040
01P0001A00030@0000@000<100000P020A001@4?00810P000`40000G0000
D@000`40000500030@0000800P4S008100<00@006@00054000<100001P00
104000030B400P4200030@0001P0001A00030@0000L000@100000P4Q0081
00<00@006P0004P00`4600030@0000P000@100000P4O00810P000`40000I
0000B`000`40000300030@0000P000<100000P020Ad00P4200030@0001X0
001;00030@0000<00P4:00030@0000800P4K00810`000`40000J0000B@02
0@H000<100002P000`40000200816P020@8000<100006`0004/000<10000
0`000`40000;00030@0000<000<100005P020@<000<100006`0004P000@1
00011@000`40000;00030@0000@00P4E00810`000`40000L0000B@020@H0
00<1000030000`40000400814`020@@000<100007000054000<100003@00
0`40000400<13`030@@000<100007@00054000<100003P020@H00`4<0081
1@000`40000N0000D@000`40000@00030@0000@01@4700<11P000`40000N
0000D@020A8000<100001@0;0@L000<100007`00054000<100004P000`40
000800@120020B80001A00030@0001<00P4C00030@000280001A00030@00
01D000<100003`000`40000S0000D@000`40000F00813@020BH0001A0003
0@0001P00P490081:000054000<100006P030@<00`4Z0000D@020Ah00`4]
0000D@000`40001=0000D@000`40001=0000D@000`40001=0000D@000`40
001=0000D@000`40001=0000D@000`40001=0000X@000:400000
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{161.875, 268.062},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Chapter 8: Fractal Tile", "Subsection"],

Cell["\<\
hexarotation = ArcSin[Sqrt[3/7]/2];
mids = Solve[x(x^6-1) == 0];
r7 = translation[{Re[#], Im[#]}]& /@ (x /. mids);
sr = Composition[ scale[1/Sqrt[7]], rotation[hexarotation] ];
rmaps = Composition[#, sr]& /@ r7;
hexatile = IFS[ N[rmaps] ];\
\>", "Input"],

Cell[CellGroupData[{

Cell["\<\
Module[{pts, gr},
        pts = Flatten[ Nest[hexatile, Point[{0,0}], 5] ];
        gr = Graphics[{PointSize[0.01], pts}];
        Show[gr, AspectRatio -> Automatic, PlotRange -> All]
    ];\
\>", "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003J0000b@P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6HcomX0003J0000fP000=X0003J0000A@070C/01`5<0000A0080CX0205<
0000A0080CX0205<0000?0020@800P400`010@090C000P42008100<00@40
2@5:0000>`0C0Bl04`5:0000?00B0C004P5:0000?00G0BX0504010010@55
0000>`0H0BT06@550000>P0I0@T01`4H01X12@070CD0000j01/11P080AT0
6`4600P1=@0003/06P4700P16@0J0@L01`4e0000>`0J0@800P4200X1600J
0@800P4200X1<`0003`0:@4I02T1<`0003/0:`4G02X1<`0003X0<@4A0341
;@0003X0<@4A0341;@0003800P4203D12@020@80=@4]0000<@0l0@H0>`4/
0000<@0l0@H0?04[0000<00m0@D0?@4[0000:@250B`0000X08D1;@0002T0
Q04]0000:0250Bd0000W08@1;`0002L0Q@4^0000:0250Bd0000Y08@1;@00
02T0Q04]0000:0250Bd0000W08D1;P0002L0Q@4^00009P260Bh0000U08H1
;`0002H0Q04`00009`230C00000W08D1;P0002P0Q04^0000:@230@800P4Z
0000:P000`4000240BT0000]08D1:00002h0Q04X0000;`240BL0000_08@1
9`0002h0Q@4W0000;@250BP0000]08D1:00002`0QP4X0000:`260BT0000/
08@1:P0002`0Q@4Y0000;@250BP0000^08@1:00002d0Q@4X0000;0250BT0
000]08<1:P0002`0Q04Z000090030@03004108H1:P0002<0S04[00008`2<
0B/0000K00810P020@03004108`1:P0001X0U`4Y00006`2F0BT0000K09L1
00@00@41900001X0W04T00006@2M0@T01`4D00006@2O0@H0204D00006P2N
0@L01`4D00006`2M0@800P4200X14P0001/0[@4B00006P2^0A80000I0;@1
3@0001T0]@4<00004@020@80^@4<0000402o0@/0000A0;l12P000100`04:
000020370@/000070<L1300000P0aP4<00001`370@`000060<L13@0000H0
aP4>00001`370@`000080<H1300000P0aP4<00001`370@`000060<L13@00
00H0a`4=00001@380@d000040<P13P0000D0aP4?00001P350@l000060<L1
3@0000L0aP4=000020350@800P4900002@000`4000360@P0000<0<H12000
00d0aP4700003P360@H0000>0<H11P0000d0a`46000030370@L0000<0<L1
1`0000/0b04700002`370@P0000<0<D12@0000/0aP49000030370@L0000=
0<H11`0000d0aP4700002`370@P0000<0<D12@0000/0aP4900002P300@03
004100<12P0000T0`04A00002@300A40000:00030@010;`14@0000/0]P40
0`010@0300030@000100000;0;D16P0000`000@10040/04J00004P2]0A/0
000A00/100<00@40W`4L00004P090@<000<10000W@4L00004`080@H0W`4J
00004`080@L0WP4J000050020@0400400@T0W@4J00008`2M0AX0000T00@1
00<00@40T`4L0000:02G0A/0000X09L16`0002T000<10040R`4200050@00
0040700002X0S04T0000:P2<0B@0000Y08D100<00@400P020BD0000X08D1
;@0002T0Q04]0000:0250Bd0000W08D1;P0002L0Q@4^0000:0250Bd0000Y
08@1;@0002T0Q04]0000:0250Bd0000W08D1;P0002L0Q@4^00009P260Bh0
000U08H1;`0002H0Q04`00009P240C00000W08D1;P0002P0Q04^0000:@23
0@800P4Z0000:P000`4000240BT0000]08D1:00002h0Q04X0000;`240BL0
000_08@19`0002h0Q@4W0000;@250BP0000]08D1:00002`0QP4X0000:`26
0BT0000/08@1:P0002`0Q04Z0000;@250BP0000^08@1:00002h0Q04X0000
;0250BT0000]08<1:P0002`0Q04Z0000:`110@03004103X100<00@400P40
0`01000Y0000:P0m0@8000<10000?04300030@0002`0000Z03`11P0l0C80
000[00030@0103@100@00@411`000`400@0h0C80000/038100<00@400`00
0`400007038100<00@400`000`40000a0000;00a0A40<@4k0000;@001040
0@0/0A8000@10040;04k0000<`0Y0AP0:P4l0000<P0Y0AT0:@4m0000<`09
0@<000<100006P4I00T10`000`400@0I0Cd0000d00P11P0K0AT01`4701/1
>`0003@0204701X16@070@P06P4k0000=@020@0400400@T06@4J008100<0
0@402@0J0C/0001401T1:@0I0C/0001500@100<00@403`4/00@100<00@40
3`4m0000B@0C0Bl04`4l0000B@0?0@0400410Bl04`4l0000BP000`400@07
0@8000D100000@0a00X10P001@40000103d0001;00P1>P080DD0001;00P1
>P080DD0001<00040@010081?0020@800P560000fP000=X0003J0000fP00
0001
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{218, 201.062},
  ImageMargins->{{24, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Chapter 9: Fourier Approximation of Saw Tooth", "Subsection"],

Cell["l5 = Table[ Sum[Sin[i x]/i, {i, n}], {n, 10} ];", "Input"],

Cell[CellGroupData[{

Cell["Plot[ Evaluate[l5], {x, -0.3, 2Pi+0.3} ];", "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004R0000/`P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcool08`000?l08`000?l08`0001/000<10000o`0500006`000`40003o
00D0000K00030@000?l01@0001/000<10000o`0500003`000`4000090081
i@030Ad0000?00030@0000T000<10000h`050A`0000?00030@0000T000<1
0000h@070A`0000?00030@0000T000<10000h0050@0400400A/0000?0081
2P000`40003N00@100<00@000P400`01000J00003`020@X00P7N008100@0
0@400`400`010@0K00003`020@X000<10000fP060@06004100400`4K0000
3`020@X000<10000fP020@030041008100@00@000P400`01000J00002@03
0@801@4800030@000=P00P401@01004000<100D00@0100020A/0000:0003
0@0000800P4200030@0000D000<10000eP050@03004000@100D00@010002
0A/0000300D10P000`40000200<100<00@001P030M@00P400`0100040@03
004100810P000`400@030AX0000:00030@0000<00P400`01000600030@00
0=@000L10001004000@100<00@400P000`400@030AX0000:00030@0000<0
0`4800030@000=<000H100010042000=0@010@0100400@0100020AX00009
008110030@T000<10000c`060@0>00400@0100400@010042008100<00@40
6P0000X000<100000P050@L000<10000cP001040004300<10P0010400@02
0@8000<100000P4010010@4I00003`030@T00P7>00040@000@@000D10040
0@02008100<00@000P000`4000050AT0000@00812@000`40003;00810`00
1@40000100800`401P0100400@<000<100001@4I000040030@P000<10000
bP000`40000200030@00008000T1000100400@000P401@01000100801@4I
000040030@P000<10000bP000`40000200050@0000400P002`400@010040
0@01008000<100000`400`01000H000040030@P000<10000b@000`400002
00030@00008000L10001004000<100D00@000@0200050@000@000P4I0000
40030@P00P7500X110002P40000100400@020@<000@100010P0010400@4I
00003`040@P000<10000`P020@<000<100000`000`40000200080@000@01
0042008110000`400@0200@16@0000l000@1004120000`40003000811000
0`40000300060@010@010`002@400@0100400@0400050@000@001@4H0000
3`000`400@020@L000<10000_`000`40000300030@0000@000<100400`42
00030@01008000<100400P4400050@000@001@4H000040040@L000<10000
_@020@H000<100000`030@800`40300100400@0100400@<000D100010003
0@03004001L0000@00@11`020Kd000<100001@000`40000300@10P001040
004200090@0100400@0100@000<1000010400`01000G000040040@L000<1
0000^`000`40000500030@0000<00`4200810`030@0600400@010P000`40
000200070@000@0100020AP0000@00@11`000`40002j00030@0000H000@1
00001044008100<00@000P400`0100020@@000D100000@0200030@0100<1
6000010000@100411`000`40002i00030@0000H000<100001`4200030@00
008100<00@401@4400030@00008000@10040104H00004@030@L00P6i0003
0@0000H000<100000P4010010@4200030@01008000D1004100040@H000D1
00000@0200D160000140104600030@000;L000<100001`000`400@020003
0@0100@00P4200030@0100@120001@40000100801@4H00003`000`400@03
0@H000<10000]P000`40000700H100<00@40100010400@4200D12@001040
004200<100<00@005`0000l000<100400`4600030@000;D000<100001`00
1040004200<11000104000050@<000<100001P002`40000100400@0101P0
000?00030@0100<11P000`40002d00030@0000L00P401P01000100@10P00
1@40004000811P000`40000600070@000@0100040AL0000;00H100@00@41
1P030Jl02P44008100<00@000P000`400@0300810`030@L000<100001P00
1040004200D15`00010000<100400P4600030@000:X01@4300030@0000@0
204200040@010@<01P4:00030@0000D000H100000@050AL0000@00030@01
00<11@000`40002X008120000`400003008100<00@001@40100100440004
0@010@d000<100001@001@40004000D15`0001001P4500030@000:D00`49
00030@0000800P4200060@0100401P4300030@0100l000<100001@001@40
004000D15`0001401@4500030@000:<00P4;00030@00008000<100000P02
0@8000<100001P4200<140000`40000400050@000@000`400`01000F0000
4@000`400@020@D00P6R008130000`40000200030@0000L10P000`400@03
0@0400410A8000<100001@001@40004000@15`00014000<100400P450003
0@000:0000<1000030000`40000200<100L00@01004000D10`020AD000<1
000010001@40004000@15`00014000<100400P4500030@0009h00P4>00`1
0P001040004200040@000@800P4C00030@0000@000D1000100040AL0000?
00030@0000@11@000`40002M00030@0000d00`4200@100<00@000`420004
0@000@8000<100000`000`40000A00030@0000@000<100001@4G00003`00
0`4000050@@000<10000W0000`40000=00810P020@04004000h11`000`40
000@00030@0000@000<100001P4F0000400010400@030@@00P6K00814000
1@40004000810`020@03004100@000<100002P020A4000<100000`000`40
00060AH0000@00040@0100<110000`40002I00030@0000h00P4200050@01
00400P0010400@4500030@0000d000<100003P000`40000400040@0100@1
5P00010000<10000104400030@0009P000<100003P002@400@0100400@02
00050@01004010000`40000?00030@0000h000<100000`000`4000030@03
004001D0000@00030@0000@110000`40002G00030@0000h0404400030@00
014000<100003@000`40000300030@0000D15P00014000<100400`440003
0@0009H000<100003`020@07004000400@0200<11@000`40000C00030@00
00d000<100000`000`400@040AH0000A00040@01008110020IH000<10000
2`0=0@8000<100400`030AL000<1000030000`40000300030@0100@15P00
014000@100400`4300030@0009@000<100002@030@<000D100400@0200/1
6`000`40000<00030@00008000<10000104F00004P000`400@030@<000<1
0000TP020@/000<100000`030@04004000810P000`400@0Q00030@0000/0
00<100000`000`400@030AH0000B00030@0100<10`000`40002A00030@00
00T00P4300L10P050@8000<1000080020@`000<100000P000`400@030AH0
000B00030@0100<10`020I4000<100002@000`4000060@04004100@11000
0`40000S00030@0000T000<100000P000`400@040AD0000C00D10`000`40
002?00030@0000T000<100003@4500030@0002D000<100002@000`400002
00H15@0000l000H100000@030@<000<10000SP000`40000900060@000@01
0P001@400@01008000<100000`000`40000W00030@0000P000<100000P00
0`400@030AD0000900810`060@03004100810P000`40002=00030@0000X0
00<100400P4200030@0000810P000`4000020081:`000`40000800060@00
0040104E000020001040004400050@000@00104200030@0008`000<10000
2P0010400@43008100<00@400P000`40000200030@0002`000<100001`00
1P40000100@15@0000<01P4200030@00008000<100001P4200<1R`000`40
000:00030@0000810P080@@000<10000;P000`40000700040@0000D15@00
00P000@100011@001@400@4000<10P000`40002:00030@0000X03@450081
<P000`40000600040@0000D15@0000P000@1000110030@03004000<10P00
0`40002:00030@0000H01@400`010@0300030@0100H00P4e00030@0000H0
00D1000100030AD0000800040@000@D00P4200@10P000`40002900030@00
00D03P400`010@050CL000<100001P00104000040AD0000900811P030@03
004100810P000`40002800040@0000H10P020@03004100<01P4m00030@00
00H000<10000104E00004`000`400@040@03004108P000D100000@040003
0@00008100<00@400`020@030040040000<100001@000`4000050A@0000C
00030@0000@100<00@00Q`000`400@020@@000<100000P400`0100050@03
0040048000<1000010000`4000050A@0000C00030@0000@100<00@00QP00
0`400@0600X100D00@400@1500030@0000@000<10000104D000050000`40
0@030@03004008H00P4500810P020@8000D100000@0200030@0004D000<1
00000`000`4000040A@0000D00030@0100<100<00@00Q@020@D00P420081
0P020@8000D100000@1700030@0000@000<100400`4D00003`000`400003
00030@01008100<00@40Q0020@D03@4300030@0004L000<100000`000`40
00030A@0000@00030@00008000<10040104T00<18`040B<00`4@008100<0
0@403@4400818P030BD00P4400030@0000<15000014000<100000P060BD0
00<100008`000`40000V00030@0000`01@401@010@0100800P400`010006
00030@00024000@100018`001040004400030@0100815000018000H10000
0@040BD000<1000090000`40000U00030@0000/00`43008100@00@001045
00D19@000`40000Q00030@0000810`000`400@020A@0000B00060@000040
104U00030@0002@000<100008`020@d00`4200X11`020@03004002D000<1
00008@001P4000400@<000@10041500001<000@100001P4T00030@0002D0
00<1000090000`40000900H100D00@0100030@P000D100400@0S00<19003
0@8000H100000@030A<0000D00050@000@000`4T008190001040004S0004
0@000@X010400`010@050@03004000L000@100000P4T00030@0002@000<1
00000P00104000040A<0000E00030@0000@19@000`40000S00819@020@X0
204200040@000@P000<100000`000`40000R00<19@020@<000<10000104C
00005P000`400@030Gh00`4300040@000@8000<100001@020ET000@10040
0P4C00005`000`400@020Gd00P44008100D00@000@060081G0000`400@02
0A<0000G00030@0100<1N`020@@00P401@01000100H000<10000G0000`40
0@020A<0000H00040@010G/00P44008100D00@000@050081H00010400@4C
00006@030GX00P4300<100<00@400P440081H`030A<0000J0081NP001040
00060@@00`5V00814`0000T0o`4J0@0030000`40000400030@0000D00P46
00030@0000@000<100001@000`40000500030@0000D000<1000010000`40
000500030@0000D000<100001@000`40000400030@0000D000<100001@00
0`40000500030@0000@030401@01000100L000<1000010000`4000050003
0@0000D000<100001@000`40000400030@0000D000<100001@000`400005
00030@0000@000<100001@000`40000500030@0000D000<1000010000`40
000500030@0000810`000`40000400030@0000D0000K00819@000`40000S
00030@0001P01@4200H10`000`40000P00030@0002@000<100008`000`40
000800814P0001/00`5S008110030@0400410@@00P5j00<14@0001/00P40
0`01001O00811@00104000030@@00P5k00@1400001/00`400`01001M0003
0@0000@000<1000010440081O0030@03004000h0000K00<10P000`40001J
00030@0000@000D1000100020@@00P5n008100<00@003P0001/010400`01
001I00811P001@400040008110020Gl00`400`01000=00006`040@8000<1
0000EP000`40000500030@0000/1O`030@8000<100002`0001/00`401@01
000105H000<100001@050@03004100<00`6000@10P000`40000:00006`05
0@<000<10000D@020@L03P6100@10`000`40000900006`050@@000<10000
C`000`40000500H100<00@400`000`400@22008100<00@400`000`400008
00006`040@030040008000<10000C@020@L00`4200060@0100400P400`01
002200D10`000`40000800006`060@@000<10000B`000`40000600<10`06
0@800P6300D110000`40000700006`050@03004000<000<10000B@000`40
000300h10P030H@010400`01000300030@0000H0000K00D100<00@001000
0`40001700040@0000h110000`400@2500<100<00@401@000`4000050000
6`050@03004000D000<10000AP001040004200810P020@800`4400030@01
08L010400`01000;00006`060@03004000D000<10000A000104000420081
0P020@800P4500030@0108P010400`01000;00006`060@03004000H000<1
0000@P001@40004000X11P000`400@2900<100@00@012`0001/000<10040
0`4200030@0000D000<10000@0000`400@050@800P4200030@0000<00P40
0`01002900070@0100400@0;00006`050@0400400@P000<10000?P001040
0@4200030@01008000@100010`030@8000<10000R@030@0400400@/0000K
00030@01008100D00@000@0700030@0003X01`4300810P020@03004100<1
1@000`40002900D10P000`40000800002P020@<000<100400P4700030@01
00@10P000`40000600030@0003@01@4300040@0100/120000`40002:00@1
00@00@012P0000T000@1000110001040004600030@0100@10P000`400007
00030@0003400P4600D10P020@800P4;00030@0008/010401@01000100T0
000900040@000@L000<1000010000`400@030@05004000402@000`40000^
00811P0=0@`000<10000S0040@05004000402@0000T000@100011`000`40
000400H100D00@000@0:00030@0002`000<1000010060@@00P4200030@00
00T000<10000S@020@05004000400P000`40000600002@001040004400<1
1`000`400@030@030040008000<1000020000`40000Z00030@0000@00P42
00<10P030@8000<100002@000`40002>008100D00@400@0200030@0000H0
000900040@000@D000<100001P000`400@020@0400400@8000<100002@00
0`40000X00030@0000<00P400`0100030@8000<100400P000`4000090003
0@0008l00P401@010@0100<000<100001@0000X00P4600<11P000`400@04
0@030040008000<100002@000`40000V00030@0000<000D1000100020@06
00400@010P000`40000900030@0009001@400`01000200030@0000D0000K
00L100<00@000P000`40000:00030@0002@000<10000100<0@03004100/0
00<10000T@050@8000<10000200001/000<1000010400`01000300030@00
00X000<100008P00104000060@800`400`010@0200030@0000X000<10000
T`040@8000<10000200001/000<100000`401001004300030@0000/000<1
000080000`4000050@801`4300030@0000X000<10000U0020@0500410040
2P0001/000<100000`401001004400030@0000/000<100007P0010400042
00810P001@400@0100@00P4;0081U`020@05004100402P0001/000<10000
1@400`01000300030@0000`000<10000600<0@8000<100000P4200<13000
0`40002G008100<00@400P000`40000700006`020@03004100<10P000`40
000200030@0000`000<100005P020@<000<100400`000`400@080@h000<1
0000V0020@030041008000<100001`0001/000<100001040100100440003
0@0000d000<100004`020@@01@401@010@0100800`4@00030@0009T01P40
0`01000800006`000`4000040@0400400@D000<100003@000`40000A0003
0@000080104300T140000`40002J00H10P000`40000600006`000`400004
0@0400400@D000<100003P000`40000?00030@0000800`40100100020@80
00@100014@000`40002K00<100<00@400P000`40000600006`000`400006
0@8000<100000`000`40000>00813P000`40000200050@0100400`020@05
0040004040020Ih00`400`010@0200030@0000H0000K008100<00@401042
00030@0000<000<1000040000`40000:00040@0000@100<00@000P020@05
0040004040000`40002N00<100<00@400P000`40000600006`0010400004
0@0400400@H000<1000040020@H03P4200@100<00@4040000`40002O00<1
00@00@410P000`40000500006`00104000040@05004000401@000`40000B
00030@00008000L100000@0100801@400`010@020@8000<100403P020J80
0`4010010@4200030@0000D0000K00040@0000@100D00@000@0600030@00
0180104300030@01008000H100400@070@03004000d000<10000XP001040
0@030@X0000K00040@0000@100<00@000P000`40000300030@0001<00`42
00P100@00@000`4400030@0000`000<10000Y0030@03004100X0000K0081
0P020@05004100400P000`40000400030@00010010401P010@400@801`42
00050@0000403@020JL00`401001004900006`00104000020@0500410040
0P000`40000400030@0000h010400`010@040@8000D100400@0300810`00
0`40000:0081Z@030@0400410@T0000B00<11P00104000050@0300400080
00<1000010000`40000<00810P00104000060@0400400@<000<100000`00
0`40000700<1Z`030@0400410@T0000C00030@0000D000@100001@400`01
000200030@0000@000<1000030001040004300040@0100D100<00@000P45
00030@0000D00`6^00<100D00@400@0800004`000`40000500040@0000D1
0P001040004700030@0000P01P4400030@01008000<100401`4300030@00
00H1/@030@0500410040200001<000<100001@030@030041008100@00@01
0`000`40000500030@0000D00P400`01000200070@0000400@0300040@01
0@H01`6f00<10P000`400@0800004`000`40000500030@0000800P401@01
0@0100<000<100001@000`40000300<100<00@000P0020400@400@010P00
10400@4900030@000;P00`4200<1200001800P4700030@0000800P401@01
0@0100@000<100001@00104000030@03004100<000@100000`4200040@01
0@T000<10000^@040@05004100401`0001<000<100001@000`4000020081
00<00@400P001@40000100P01040200100400@0110000`400@050@T000<1
0000^P001@400@40008100<00@001P0001/00P43008100H00@0100440003
0@0000D01@4200040@000@@000<100400P000`400@0900030@000;`00`40
0`010@0900006`000`40000200@100@00@0110000`40000300@10P030@<0
1040200100400@012P000`40002l00<100<00@402@0001/000<100000P04
0@05004000400`000`40000200810P030@800P400`01000200H10P000`40
000700030@000;d00`420081200001/000<100000P040@05004000401000
204000400@010P000`400@0200810`020@030040008000<100001`000`40
002n00<10P020@P0000K00030@0000800`401P0100400@@000<100000P42
00040@0100810P020@80104300030@0000H00P71008100<00@000P480000
6`020@<00`401P0100400@@000<100000P401P01000100810P000`400@03
0@D000<100001@000`40003100@100<00@40200001/000<100000`001P40
0@400@8000<100000P020@0600400@010P0010400@4200<11@000`400004
0081a0040@03004100P0000K00030@0000<010401@01000100@00P402001
00400@010P050@03004000@000<100000`000`40003400@100@00@011`00
01/000<100000`040@8000@100010`030@0400400@8000@100010P000`40
0@0500030@0000<000<10000a@030@03004000811`0001/000<100000`04
0@8000@100010`001`400@0100400P001040004300<10`00104000030LT0
0P400`0100020@L0000K008110020@05004100400`001@400040008100D0
0@000@0200030@00008000<100401`7<008100@00@01200001/000<10000
0`020@030041008000`1000100400@01004200040@000@@000<100000P00
0`40003>008100@00@01200001/000<100000`000`400@020@8000@10000
0P4010010@020@05004000401000104000020M4010400`01000700006`00
0`40000300@100@00@010`030@0400400@8000@1000110001040007C00<1
00<00@40200001/000<100000`030@030041008000<100000`400`010003
0@8000<100000P001040007D00<100@00@011`0001/00P4400<100<00@40
0P000`4000040@05004000400P001@400001008000<10000d`030@040040
0@L0000K00030@0000<00P4010010@4200030@00008100L00@0100400081
0`001040007F00<100@00@011`0000X00`4200030@0100811`000`400003
00030@01008100@00@010P040@0400400@801`7H00@100<00@001P0000/0
00<100000`001040004600030@0000@00`400`010@02008100L00@400@01
008000D100000@3K00@12@0000/000<100001P000`40000400030@0000@0
0`400`010@0200<100H00@41004200040@000M`00P400`010@0800002`00
0`40000600030@0000@00`44008100D00@400@02008100<00@400P420004
0@010Md00P400`010@0800002`000`40000300<11`000`40000400030@01
008100@00@000`400`0100050Ml000<100400P4800002P020@H000<10000
1P000`40000500<100<00@001P420081h`030@03004000H0000;00030@00
00@00`4600030@0000D00`400`0100060@0400410N<00P400`010@070000
6`000`40000500030@0100810P000`400@040NH00`4800006`020@L00`40
0`010@020@0300410>P00`4800006`000`40000600<100<00@40107Y0081
00<00@001P0001/000<100001P020@03004000<1j`020@03004000H0000K
00030@0000H000<10040107]0081200001/00P4800@1k`030@L0000K0003
0@0000P00P7a00811`0001/000<10000o`0500006`000`40003o00D0000K
00030@000?l01@0001/000<10000o`050000o`0S0000o`0S0000
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{290, 179.125},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Chapter 10: Spiral With Varying Radius", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ParametricPlot3D[{r\ \((1\  + \ phi/2)\)\ Cos[phi], \ 
          r\ \((1\  + \ phi/2)\)\ Sin[phi], \ \(-phi\)/2}, \n\t\ \t\ {r, \ 
          0.1, \ 1.1, \ 0.125}, \ {phi, \ 0, \ 11  Pi/2, \ 
          Pi/16}];\)\)], "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003f0000e0P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcoj800P5B0000X0020@0300410540002M00<10`020E40002K00811P00
0`400@1@0000V0030@P000@10001C`0009H00P4;00040@000Dl0002C00<1
3@001@40000104h0002A008140000`40000200030@0004/0002>00<14P00
0`40000200030@0004/0002<00815@000`40000300030@0004X0002900<1
5`000`40000400030@0004T0002700816P000`40000400030@0004T00024
00<17@000`40000400030@0004P00022008180000`40000500030@0004L0
001o00<18P000`40000500030@0004L0001m00819@000`40000600030@00
04H0001j00<19`000`40000700030@0004D0001h0081:P000`4000070003
0@0004D0001e00<1;0000`40000800030@0004@0001c0081;`000`400009
00030@0004<0001`00<1<@000`40000900030@0004<0001^0081=0000`40
000:00030@000480001[00<1=P000`40000;00030@000440001Y0081>@00
0`40000;00030@000440001V00<1>`000`40000<00030@000400001T0081
?P000`40000=00030@0003l0001Q00<1@0000`40000=00030@0003l0001O
0081@`000`40000>00030@0003h0001L00<1A@000`40000?00030@0003d0
001J0081B0000`40000?00030@0003d0001G00<1BP000`40000@00030@00
03`0001D00<1C@000`40000A00030@0003/0001B0081D0000`40000A0003
0@0003/0001?00<1DP000`40000B00030@0003X0001=008130000`400016
00030@0001<000<10000>@0004X00`4<008100>@0@00AP000`40000C0003
0@0003T0001800813@020@05T7J@MP40A`000`40000C00030@0003P00015
00<13P000`6@T005T0030@0004@000<1000050000`40000g0000@`020@l0
0P402GJ@MY1fT7J@0@1600030@0001@000<10000=`0004000`4?00812i00
0`40001300030@0001D000<10000=P0003h00P4A000@0GJ@MY1fT7J@MY1f
T7J@0D@000<100005P000`40000e0000>`030A400P4@T0030@00044000<1
00005P000`40000e0000>@020A800P40491fT7J@MY1fT7J@MY1fT7H20@03
T040044000<100005`000`40000d0000=P030A<000<1T9003Y020@B@00<1
0000?`000`40000H00030@0003<0000d00815@006P5f0@6@MY1fT7J@MY1f
T7J@0I1fT7J@MY01@0000`40000H00030@0003<0000a00<15@020@B@00<1
T90029020@R@00<10000?P000`40000I00030@000380000_00815`007P6@
MY1fT7J@0I1fT7J@MY1f0GJ@MY1fT7J@MY1f0Cl000<100006P000`40000a
0000;0030AP000<1T9001i020@B@0P4=T0030@0003`000<100006P000`40
000a0000:P020AX000l1T7J@MY1fT7J@MY1f0GH00P404I1fT7J@MY1fT7J@
MY1fT7H103d000<100006`000`40000`00009`030A/000<1T90039000`6@
T00>T08100>@0@00>`000`40000L00030@0002l0000U008170020@0@T7J@
MY1fT7J@MY1fT7H1MP8100b@MY1fT7J@MY1fT7H20@05T7J@MP40>`000`40
000L00030@0002l0000R00<17@000`6@T00=T0030I2@00:@0P48T0811i00
0`40000h00030@0001d000<10000;P0002000P4O000N0GJ@MY1fT7J@MY1f
T7J@MP5fT7J@MY1f0GJ@MY1f0P402i1fT7J@MY1fT7H103T000<100007P00
0`40000]00007@030B000P4=T0812I020@03T04100f@00<10000=P000`40
000N00030@0002d0000K00818P000`5fT0020@0ZMY1fT7J@MY1fT06@MY1f
T7J@MY1fT7J@0I1fT7J@MY1fT7J@MY1fT7H1=`000`40000O00030@0002`0
000H00<190000`6@T002T0811i000`6@T00;T0030I0100f@0P400i01000e
00030@00020000<10000:`0001H00P4V00080I1fT7J@MY020@0AMY1fT06@
MY1fT7J@MY1fT7H00P403Y1fT06@MY1fT7J@MY1f0P40191fT04f00030@00
020000<10000:`0001<00`4W00030I2@00R@0P400i01T00;T0030I2@00B@
0P47T0030I2@00B@00<10000<`000`40000Q00030@0002X0000A0081:P00
3@5fT7J@MY1fT7J@MY000P406WJ@MY1fT7J@MY1f0GJ@MY1fT7J@MP5fT7J@
0P402GJ@MY1fT7J@0@0d00030@00024000<10000:P0000h00`4[00030I2@
00Z@00<1T9000P48T0030I2@00V@00@1T0412i000`40000a00030@000280
00<10000:@0000`00P4]000C0GJ@MY1fT7J@MY1fT06@MY1fT0020@04MY1f
T08101afT7J@MY1fT7J@MY1f0GJ@MY1fT7J@MY1fT7H1=0000`40000R0003
0@0002P0000:0081;`000`6@T00:T0030I2@00F@0P400i01T00=T0030I01
00f@00<10000<@000`40000R00030@0002P0000:0081;P00=P6@MY1fT7J@
MY1fT7H1MY1fT7J@MY1fT06@MY1fT7J@MY1fT7J@MP5fT7H1MY1fT7J@MY1f
T08100=f0@00<@000`40000S00030@0002L0000:00030@0102`000<1T900
2Y000`6@T008T0040I010@Z@0P45T0811Y020@B@00<10000;`000`40000T
00030@0002H0000:00040@000B/001`1MY1fT7J@MY1fT7H1MY1fT7J@MY1f
T7H1MY1f0P407i1fT7J@MY01T7J@MY1fT7J@0I1fT7H1MY1fT7J@MP40<000
0`40000T00030@0002H0000900030@00008000<100009`020@Z@00<1T900
2I000`6@T004T08119000`6@T009T0040I010@V@00<10000;@000`40000U
00030@0002D0000900030@0000<000<100009P000`6@0@030@0KMY1fT7J@
0I1fT7J@MY1fT7H1MY1fT7J@MY1f008101f@0I1fT7J@MY1fT7J@MY01T7J@
MY1fT7J@MY1f0@0H00/12`000`40000V00030@0002@0000900030@0000@0
00<1000090000`6@T004T0<10Y000`6@T009T0030I2@00V@0P4<T0040I01
0@^@00<100003P070@>@00P1UI2ET9F@U@X100<00@009`000`40000T0000
2@000`40000500030@0002<000X1MY1fT7J@MY1f0`406GJ@MY1fT7J@MY01
T7J@MY1fT7J@MY01T7H00P40291fT7J@MY1f0P403I1fT7H1MY1fT7J@MY00
0P400gH1000800H101b@MY1fT7J@MY1f0GJ@MY1fT7J@MY1fT06@MY1f1P4U
00030@0002<0000900030@0000H000<100008P000`6@T008T0030I0100<1
1I000`6@T00:T0030I2@00:@0P45T0030I2@00F@00<1T9000i020@B@00@1
00001@42T0030I2@00^@01P1UI2ET9F@UI2ET9F@0I2ET9F@0I2ET9D50B40
00<100008P0000T000<100001`000`40000P000B0I1fT7J@MY1fT7H1MY1f
T7J@0`405Y1f0GJ@MY1fT7J@MY1f0GJ@MY1fT7H20@0<T7H1MY1fT7J@MY1f
0P402I010GJ@MY1fT0040@0bMY1fT7J@MP5fT7J@MY1fT7J@MY01T7J@MY1f
T7J@MY1f0GJ@MY1fT06@MY1fT7H1MY030Ah000<100008P0000T000<10000
20000`40000O00030I2@00R@00<1T9001i030@Z@00<1T90029020@b@00<1
T9000Y040@^@00<1T9002Y004`6@UI2ET9F@UI2ET9D1UI2ET9D00P40392E
T9F@0I2ET9F@U@<170000`40000Q000020000`40000:00817`00606@MY1f
T7J@MY01T7J@MY1fT7J@MY01T0@101=fT7J@MP5fT7J@MY1fT7J@MP5f0081
00^@MY1fT7J@MY01T0040@0FMY01T7J@MY1fT7J@MY1f0GJ@MY1fT1T1016@
MP5fT7J@0I1fT7J@MY1fT0030AX000<10000800000P000<1000030000`40
000K00030I2@00R@00<1T90029000`6@T004T0<10Y000`6@T009T0040I2@
T0811Y000`6@0@020@B@00<1T9002I080@0BUI2ET9F@0I2ET9F@UI2ET9F@
2`40492E0IF@UI2ET9F@UI2ET9D30AL000<10000800000P000<100003@00
0`40000J000P0GJ@MY1fT7J@MY01T7J@MY1fT7J@MP5fT7J@MY1fT7H30@0F
MY1fT7J@MY1fT06@MY1fT7H1MY1fT0<100n@MY1fT7J@MP5fT7J@MY001040
67H1MY1fT7J@MY1fT7J@0I1fT7J@MY1fT0<100V@MY1fT7J@MY00104047J@
MY1fT7J@MY1fT7H1MY020AH000<100007`0000P000<100003P000`40000I
00030I2@00N@00<1T90029000`6@T009T0040I010@N@00<1T9001Y020@03
T04100Z@00<1T9001045T00D0IF@UI2ET9F@UI2E0IF@UI2ET9D30@0@U@6E
T9F@UI2ET9F@U@6ET0@100NET9F@UI2E008100F@UI2ET0020AD000<10000
7P0000P000<100003`000`40000G000V0I1fT7J@MY1fT7H1MY1fT7J@MY1f
T06@MY1fT7J@MY1f0GJ@MY020@0?MY1fT06@MY1fT7J@MY1f008100b@MY1f
T7J@MY1fT7H30@0JMY1fT7J@MY1fT06@MY1fT7J@MY1f0GJ@MY030@0GT7J@
0I1fT7J@MY1fT7J@0I01T7J@MY00104037J@0I1fT7J@MY1fT0814`000`40
000N000020000`40000@00030@0001H01P44T0030I2@00R@00<1T9002I00
0`6@T004T0810Y000`6@T006T08100>@0I0029030@03T06@00Z@00H1T9F@
UI0C0@0ET9F@UI2ET9F@0I2E0IF@UI2ET9F@008100bET9F@UI2ET9F@UI02
0A8000<100007@0000L000<100004P000`40000E00060I1fT7J@1`407I1f
T7J@MY1f0GJ@MY1fT7J@MY01T7J@MY1fT7J@00<100J@MY1fT7H20@0;T7J@
MP5fT7J@MY000P403gJ@MY1f0GJ@MY1fT7J@MP070@05MY1fT7H00`402gJ@
MY1fT7H1MY1f00D100mfT7H1MY1f0GJ@MY1fT7H00P4049010GJ@MY1fT7J@
MY1fT04B00030@0001`0000700030@0001<000<1000050000`6@T007T003
0I2@00D10Y000`6@T009T0030I2@00R@00<1T0400P42T0030I2@00F@00<1
T9000`47T0030I2@00>@10402I01T9F@UI2ET0040@0BUI2ET9F@UI2E0IF@
UI2ET9F@1@403i2ET06@UI2ET06@UI2ET0020@08UI2ET9F@UI020@03U@40
010000<10000700000L000<1000050000`40000C000B0I1fT7J@MY1fT06@
MY1fT7J@1@406I1fT7J@MY1f0GJ@MY1fT7J@MY01T7J@MY000P402GJ@MY1f
T7J@MP020@0=T7J@MY1fT7J@MY01T0030@0:T7J@MY01T7J@MP<101]fT06@
MY1fT7J@MY01T7J@MY1fT7J@MP5fT7H01@4037J@0@5fT7J@MY1fT08100]f
T7J@MP5fT7J@0@0A00030@0001/0000700030@0001D000<100004P000`6@
T007T0030I2@00N@00<1T9001@43T0030I2@00R@00@1T92@0P49T08100>@
0I002I030@V@10408Y2ET9F@0I2ET9F@UI2ET06@UI2ET9F@UI01T9F@UI2E
T9D30@0<UI2ET9F@UI2ET9F@0P402ID10I2ET9F@U@020A0000<100006P00
00L000<100005P000`40000A000L0I1fT7J@MY1fT06@MY1fT7J@MY01T7J@
MY1fT0D102>@MY1fT7J@MP5fT7H1MY1fT7J@MY1fT06@MY1f0GJ@MY1fT003
0@0:T7H1MY1fT7J@MP<100AfT7J@4P403gJ@MY1f0GJ@MY1fT7J@MP020@0>
T7H10I1fT7J@MY1fT7H20@0;T7J@MY1fT7J@MP403`000`40000J00001`00
0`40000G00030@0000l000<1T90029000`6@T007T0030I2@00N@00<1T900
1@43T0060I2@0I011i020@J@00<1T9000`45T0030I2@00:@2P404YF@UI01
T9F@UI2ET06@UI2ET0H100nET9F@UI2ET06@U@6ET9D00P401Y2ET9F@U@81
00j@U@41T9F@UI2ET9F@0@l000<100006@0000L000<1000060000`40000>
000W0GJ@MY1fT7J@MP5fT7J@MY1fT7J@0I1fT7J@MY1fT06@MY1fT7J@00H1
00=fT7H00P403Y1fT7H1MY1fT7J@MY1f0P402I1fT7J@MY1fT0070@0OT7H1
MY1fT7J@MY01T7J@MY1fT06@MY1fT7J@MP5fT0040@0=MY010GJ@MY01T7J@
MP020@0ET7H10I1fT7J@MP5fT7J@MY1fT7H100l000<10000600000H000<1
00006P000`40000=00030I2@00N@00<1T9001i000`6@T008T0030I2@00N@
0`46T0040I010@R@0P400i01T006T0D102N@UI2ET9D1UI2ET9F@U@6ET9F@
UI2E0IF@UI2ET9F@0I2ET9F@UI000P403IF@UI2ET9D1UI2ET9D00P404Y2E
T9F@UI2ET06@UI2ET9F@U@813P000`40000H00001P000`40000K00030@00
00`003`1MY1fT7J@MY1f0GJ@MY1fT7J@MP5fT7J@MY1fT7J@0I1fT7J@MY1f
T06@MY1fT7J@MY01T7J@MY1fT7H20@08T7J@MP5fT7H50@0/MP5fT7J@MY1f
T06@MY1fT7H1MY1fT7J@MP5fT7J@MY1fT06@MY1fT7J@0I020@09MY1fT7H1
MY1f008100b@0I1fT7J@MY1fT7H20@03T7H100<100>@MP403P000`40000G
00001P000`40000L00030@0000/000<1T9001i000`6@T007T0030I2@00N@
00<1T9001i000`6@T007T0040I010@F@00<1T90019040@03T04100>@00d1
UI2ET9F@UI01T9F@00l100^@UI2E0IF@UI2ET0020@04UI2ET08100BET9F@
0`40192ET9D20@09T9F@UI2ET9F@00<100N@UI2ET9D100l000<100005P00
00H000<100007@000`40000:00H1032@MY1f0GJ@MY1fT7J@MP5fT7J@MY1f
T7H1MY1fT7J@MY01T7J@MY1fT7J@0I1fT7H20@09T041MY1fT7J@00<1012@
0@5fT7J@MY01T7J@MY1f1@403gJ@MP5fT7J@MY01T7J@MP070@0<MY1f0GJ@
MY1fT7J@0P404GH10@5fT7J@MY1f0GJ@MY1f00<100]fT06@MY1fT7J@0@0>
00030@0001H0000600030@0001h000<100002@000`6@T003T1@119000`6@
T005T0811i020@N@00<1T9000i030@>@00<1T9001Y000`6@U@040@0KT06@
UI2ET9D1UI2ET9D1UI2ET9F@U@6ET9F@00<101Z@UI2ET9F@UI2ET06@UI01
T9F@UI2ET06@U@8100n@UI2ET06@UI2ET9F@U@403P000`40000E00001P00
0`40000O00030@0000T001T1T7J@MY1fT7H1MY1fT7J@MY1f0GJ@MY1f00X1
00B@0I1f0P404I1fT7H1MY1fT7J@MY01T06@00<100B@MY1f0P402I01T7J@
MY1fT0030@0ST7J@MY01T7J@MY01T7J@MY1f0GJ@MY1fT06@MY1fT7H1MY00
0P401GJ@MY1f008100b@MP41T06@MY1fT7H40@0BT7J@MY1fT7H1MY1fT7J@
MY013P000`40000D00001P000`40000P00030@0000P000<1T9001i000`6@
T006T0030I2@00N@00<1T9000i020@B@0P400i01T007T0030I0100<11902
0@B@00<1T9000Y020@0QT06ET9F@UI01T9F@UI01T9F@UI01T9F@UI2E0IF@
UI2E008100F@UI2ET0020@09U@41T9F@UI2E00<100>E0@400P405Y2ET06@
UI2ET9F@U@6ET9F@UI2ET04>00030@0001@0000500030@00028000<10000
1`00:`6@MY1fT7J@MY01T7J@MY1fT7J@0I1fT7J@MY1fT06@MY1f0GJ@MY1f
T7H00P401i1fT7J@MY000`401Y1fT7H1MP8100V@MY1fT7H1MY000P403GJ@
MY01T7J@MY01T7H04P40691fT06@MY1fT7J@MY01T7J@MY1fT7J@MP8101R@
MY1fT7J@MP5fT7J@MY1fT06@MY1fT7H30@h000<100004`0000D000<10000
8`000`40000600030I2@00N@00<1T9001i000`6@T007T0050I2@T0401i00
0`6@T0020@:@0`48T0030I2@00N@0P46T0050I2ET9D010404Y2ET06@UI2E
T06@UI2E0IF@U@@100J@UI2ET9D20@09T9D10I2ET9F@008101NET041UI2E
T9F@U@6ET9F@UI2ET06@U@040@:@00<100003@000`40000B00001@000`40
000T00030@0000H002d1MY1fT7J@MY1f0GJ@MY1fT7J@0I1fT7J@MY1fT06@
MP5fT7J@MY1f0GJ@MY000`403901T7J@MY1fT7H1MP8100F@MY1fT0020@0;
MP5fT7J@MY1f0GH00P405Y01T8n@Si01T7J@MP5fT7J@0I1fT7H20@06T7H1
0I1f0P402I1fT7J@MP5fT0020@0CMY1fT7H1MY1fT7J@MY01T7J@MP060@08
T7J@MY1fT04>00030@000180000500030@0002D00P4600030I2@00N@00<1
T9001Y000`6@T007T0040I2@0@N@00<1T0400P43T0811Y020@B@0P400i01
0@04T0030I2@00>@0`407Y2ET06@UI2E0IF@UI2E0IF@UI01T9F@0I2ET9F@
U@8100V@UI2ET9F@UI000P401iF@UI2ET9D00P401Y2ET9F@U@H100F@UI2E
0@08T0030@0000d000<100004@0000D000<100009`000`400003000N0GJ@
MY1fT7J@MP5fT7J@MY1fT7H1MY1fT7J@MY1f0`401WJ@MY1fT0<100R@MY1f
T06@MP<101IfT06@MY1fT7J@MP5fT7J@MY1f0GJ@0P403Xn@0I2?T8l1Si2?
0GJ@1@401I1f0GJ@008100AfT7J@0P400gN@M`020@03T7H100<100^@M`5f
T7J@MY1fT0020@03MP41008101F@MP5fT7J@MY1fT06@MY1fT7J@MP403`00
0`40000@00001@000`40000X00030@00008000<1T9001i000`6@T007T003
0I2@00N@0P400i010@040@N@00<1T90019030@N@00<1T0401i020@B@00L1
T9F@U@6E00D100FE0IF@U@070@0;UI010IF@UI2ET9D00P40392ET9F@UI01
T9F@U@H1012@UI2ET9F@0I2ET9F@UI0129000`40000=00030@0001000004
00030@0002X000<100000P003`6@MY1fT7J@MY01T7J@MP0?0@03MY0100D1
015fT7J@MY1f0GJ@MY1fT06@MP020@08T7J@MP5fT7H20@03T7J@008100V?
0Hn@Si2?0Hl010404I2?0Hn@S`6?T8l1MY01T7N@008100EgT7N@M`030@09
Mi01T7N@Mi1g00H100B@MY1f0P406I1fT7J@MY01T7J@MY1fT06@MY1fT7J@
MP4040000`40000?000010000`40000[00050@000040190:0@B@00<1T900
1i030@B@00<1T0400`42T0030I2@00B@00<1T9000i020@03T06@00F@00<1
T04019000`6@T002T08100n@U@6ET9D1UI01T9F@0I000P402IF@0@6ET06@
U@020@08T9F@UI01T9D40@0;T9D1UI2ET9F@UI000P403iF@UI2ET06@UI2E
T9F@0@09T0030@0000h000<100003P0000@000<10000;0000`4000050@0F
T7J@MY01T7J@MY1fT7J@0I1fT7J@MP<100afT7J@MP5fT7J@MY030@0PT7J@
MY1f0GJ@MY1fT7H1MY1fT7J@MY01T8n@Si2?0Hl20@0CT06@Si01T8l1Si01
T8l1MP5gT0020@05Mi1gT7L00P40291gT7N@Mi1g0P409I1gT7N@Mi01T7J@
MY1fT06@0I1fT7J@MP5fT7J@MY1f0GJ@MY001@4@00030@0000h000040003
0@0002d000@100012I000`6@T006T0040I2@T0<100>@0I001I000`6@T005
T0030I0100810Y000`6@T005T0040I010@B@0P400i010@04T08100V@UI01
T9F@0I0030400iF@0@030@03UI2E00@101YgUGNE0IF@UI2ET9F@0I2ET9F@
UI2E0ID1UA4119000`40000?00030@0000d0000400030@0002h001H1005f
T7J@MY1fT7H1MY1fT7J@MY1f0`4067J@MY01T7J@MY1f0GJ@MY1fT06@MY1f
T0<100^@MY1fT7J@0I1fT0020@09MP5fT7J@MP6?008100R@S`6?T8l1S`<1
00b?0Hl1S`6@0GNEMiD20@03M`41008100n@Mi01T7N@Mi1gT06@Mi004@40
5Y1fT7H1MY1fT7J@MP5fT7J@MY1fT04B00030@0000`0000400030@0002l0
00<100402I000`6@T003T0@11I000`6@T005T0030I2@00B@00<1T9001900
0`6@0@030@:@00<1T90019020@0?T8n@Si2?0Hn@Si2?0I2E008100B@0I2E
0P401I010@6@00<100]gU@41MiEgUGNEM`0<0@0FUGNEM`5gUGNEMiEgU@6E
M`5gUGNE0@N@00<1T9001Y000`40000@00030@0000`0000400030@000300
0P40391fT7J@MY1fT06@MP<100UfT7J@0I1fT7H01040691fT06@MY1fT7H1
MY1fT7J@0I1fT7J@MP<100QfT7J@MP5fT08101AfT7H1S`6?T8n@0I01T8n@
0I01U@L100FEMiEgU@040@0gMi1gT06@Mi1gT7N@0I1gT7N@Mi1g0GJ@MY1f
T7H1MY1f0GJ@MP5fT7J@MY1f0GJ@MY1fT7J@0@0C00030@0000/000030003
0@0003800P48T0<11i000`6@T002T0040I2@T0D11I000`6@T004T0030I2@
00F@00<1T0400P42T0050I2?T8l00P401901T8l20@09T8n@0IF?0I2E01<1
02JEMiEg0GNEMiEgUGL1MiEgUGNEMiD1UGNEMiEgU@6EMiEg0GNE0@N@00<1
T9001I000`40000C00030@0000X0000300030@0003<00P40191fT7H30@0>
MP5fT7J@MY1fT7H1MY020@08MY1fT7J@0I030@0FT06@MY1fT7J@0I1fT7J@
MP5fT7J@MP<100IfT7J@MY020@0=Si2?T06@0I01T06@S`020@03M`4100D1
00=g0@4010400gN@M`0I0@0LMY1f0GJ@MY01T7H1MY1fT7J@MP5fT7J@MY1f
0AD000<100002P0000<000<10000=0000`6@0@020@F@00<1T9000Y070@03
T06@00F@00<1T9000Y050@>@00<1T9001I000`6@T004T0030Hl1008100F?
T06@S`020@09T8l10I2?T06E00@100Yg0GL1M`5g0GN@0`400iEg0@020@0I
MiEg0GNEMiEgUGL1MiEgUGNEMiD1T7N@M`0@0@>@00<1T9001I000`40000D
00030@0000T0000300030@0003<00`401WJ@MY1fT0L101V@MY1fT06@MP5f
T7J@MY01T7J@MY01T7J@00L1012@MY01T7J@MY1f0GJ@MY1f0`4018n@Si03
0@0AT041S`6?0G5g0GMaMg41M`400WL30@07T0410I1gT0060@0LMi1g0GN@
Mi1gT7N@0I1fT7J@MY1f0GJ@MY1fT08100AfT7J@304G00030@0000P00003
00030@0003000`4200030I2@00@10i000`6@T007T0811Y000`6@T004T003
0I2@00B@00@1T92@1`43T0090I2?T8n@S`6?00<100B?T06@0P400hl10@0>
0@03T7N@008100]gT041MiD1T7N@M`080@0DUGNEM`5gT7N@Mi1g0GN@Mi1g
T7L20@0@T7N@Mi1gT06@Mi1gT7N@0AL000<10000200000<000<10000;@03
0@H00P40<WJ@MY1fT7J@0I1fT7J@MY1fT06@MY1fT7H1MY1fT7J@0I1fT7J@
MP5fT7J@MY01T7J@1P402GJ@MP5fT7J@MP030@03Si2?008100b@0@5aT06@
MY01T7H90@03Mi1g00<100agT7N@Mi01T7N@Mi060@0>MY1fT7J@0I1fT7J@
MY020@0?MY1fT7J@0I1fT7J@MY0101P00P4900000`000`40000[00812P00
0`6@T007T0030I2@00J@00<1T90019000`6@T004T0030I2@00>@00<1T900
1I002P6?T8n@S`6?T8l70@05Si2?0Hl00`401hn@0I01T7L01`402I2ET9D1
UI2ET00:0@0>T7L1Mi1gT7N@M`5gT7L40@0KT06@Mi1gT7N@0I1g0GN@Mi1g
0GN@Mi1gT7L101D00`400`01000800000P000`40000Y00<13@004P6@MY1f
T7J@MY01T7J@MY1fT0/102:@MY01T7J@MY01T7J@MY1f0GJ@MY1fT06@MY1f
T7H1LI1a1040192:T8X70@0AMY1f0GJ@MY1fT06@MY1fT7H00P40191fT7H6
0@0?T7N@Mi1gT06@MY1fT7J@00D101J@MY1f0GJ@MP5fT7H1MY1fT7J@MY01
4@040@@000<100001`00008000<100009P030A4000<1T9001Y000`6@T005
T0030I2@00B@00@1T92@3@43T00F0I2?T8n@S`6?T8n@Si01T8n@Si01T0H1
00N@0I2ET9F@018100>ET9D00P400i2ET0050@0@Mi01T7N@Mi1gT7L1Mi1g
T0H100mgT7L1Mi01T7N@Mi1gT0403`030@P000<100001`00008000<10000
8`030AD002P1T7J@MY1fT7H1MY1fT7J@MP5fT7J@MP5fT7J@MY01T7J@MY01
T7J@5@400i1a0@030@07T7J@MY01T0040@0BMP5fT7J@MP5fT7J@MP5gT7N@
0`40291gT7N@Mi1g1@404gJ@MY1fT7H1MY1fT7J@MP5fT7H010402i01T7J@
MY1fT7H100`00`4;00030@0000L0000200030@0002000`4H00030I2@00N@
00<1T9000i020@F@00<1T90019000`6@T003T0030I2@00B@0181T8n@Si2?
0Hn@Si2?T06@Si030@07U@6ET9F@U@030@07UI2ET06@U@0<0@03T9F@0081
00>ET0400P401Y2E0@6@U@8101Qg0@6@Mi1gT06@Mi1gT7N@0I1gT7N@Mi06
0@04Mi1g0@X00`4?00030@0000H0000200030@0001d00`4L000=0GJ@MY1f
T7J@MP5fT0020@0/MP5fT7J@MY01T7J@MY1f0GJ@MY1f0GJ@MY1fT06@MY1f
T06@MY1fT7H1LI020@06MY1fT06@0`401I1f0GJ@00D100b@MY01T7J@MP5g
T7L30@07Mi1gT7N@M`020@06T7N@Mi1g0P405Y010GJ@0I1fT7J@MY01T7J@
MY1fT7H20@04T7J@MP@11`030A8000<100001P00008000<100006P030B00
00<1T9001I040@>@00<1T90019000`6@T004T0030I2@00>@00<1T9001900
2P6?T8n@S`6?T8l60@05UI2ET9D00`4019F@UI040@0AUI01T9F@U@6ET9F@
U@6ET9D00P401Y2E0@6@U@8100V@U@41T9F@UI000P400i1g0@020@0IMi1g
T7N@0I1gT7N@Mi1g0GN@0I1gT7N@0@0400@15@000`400006000000<00@00
6@030B@000<1MY00104067J@MP5fT7J@0I1fT7J@0I1fT7J@MP5fT1@100=a
T7400P401901T7H20@05T7H1MY000P4018l1Si0A0@06T7N@Mi1g0P402I1g
T7N@M`5gT0020@07Mi01T06@MP040@0DT7H1MY1fT7J@MY01T7H1MY1fT042
00<16@000`400006000000<00@005P030BP00P48T0810Y000`6@T00=0@B@
00<1T90019002`6@Si2?T06@Si2?00810i020@04T9F@U@<100>ET0400`40
3YF@0I2ET9D1UI2E0IF@0P401IF@0@6E008100>@UI000P400iF@0@030@0=
UI2ET9D1T7N@Mi1gT0030@0?T7N@Mi1gT06@Mi1g0GN@00@170000`400006
000000<00@004`030B`000d1MY1fT7J@MY1fT06@00<102J@MY1f0GJ@MY1f
T06@MY1fT06@MY1fT7H1MY1fT7H1LI1a0GJ@MP8100B@0I1f0P400i2?0@02
0@08S`6?T8n@0I0:0@0>Mi1gT7N@0I1gT7N@Mi020@03Mi1g008100n@Mi1g
0GJ@MY1fT7H1MY00104037J@0I1fT7J@MP5f0Al000<100001P0000030040
01000`4`00812I000`6@0@05T0030I2@00B@00<1T90019000`6@T004T003
0Hn@00L10Y000`6@T002T08100>@UI000P401YF@UI01T0@100BE0IF@0P40
1YF@0I2ET0<100B@UI2E0`400iEgU@020@07MiEgU@6ET0030@04Mi1gT081
00MgT7N@Mi1g00<100QgT7N@Mi1g0B0000<100001P000003004000h00P4e
000:0I1fT7J@MY1fT08101MfT7J@MY01T7J@MY1f0GJ@MY1f0GJ@MP060@03
T7J@008100MfT041MY1f008100>@0I000P4018n@0I040@05Si01T8l01040
1IEg0GNE008100EgU@6@M`020@06T7L1Mi1g2@404gN@M`5fT06@MY1fT7J@
MY01T7H01040191f0@4P00030@0000H000000`01000;00<1>0000`6@T008
T0030I2@00B@00<1T9000i00106@T9060@B@00D1T92@0@04T0050I01T040
19001@6ET9F@008100BET06@1`400i2E0@040@05UI2ET9D00P401GNEMiEg
00<1021gUGL1MiEg0GNEMiD1T06@Mi1gT7N@Mi01T7N@Mi1gT0810P000`40
000N00030@0000D000000`01000800<1?0002P6@MY1fT7J@MY020@09MY1f
T7H1MY1f00H101n@MY1f0GJ@MY1fT06@0I1fT7H1MY1f0Hn@Si01T06@00<1
00>@Si000P4028l1SiD1U@6E10400gNEM`020@04UGNEM`<1019gT7L1Mi1g
T06@Mi1g0GN@Mi020@07MY1fT7J@MP020@09T7J@MY1fT7H100@000<10000
7@000`400005000000<100001@030D000P45T08100>@0I000Y060@B@00<1
T9000i000`6@T004T0030I01008100>@0I000Y001P6@0@6@0@>@00@1UI2E
10400i2E0@0;0@04MiEgU@<100^EMiD1UGNE0IEgU@0<0@0BM`41T7N@M`5g
T7N@Mi1gT7L11P000`40000L00030@0000D000000`40000200<1A@000`5f
T0020@04MY1fT0<101N@MY1f0GJ@MY1fT06@MY1fT06@MY1fT0020@03MY1f
008100N@MP6?T8n@008100J?0@6@0I020@04Si01T08100B?0@6E0`400iEg
U@030@03UGNE00d100n@M`5gT7L1Mi1gT06@MY000P402WH1MY1fT7J@MY02
0@L000<1000070000`400005000000<100400P5900811i000`6@T004T003
0I2@00>@00<1T9000i000`6@T0030@03T06@00:@00@1T04119002`6@S`6?
T8n@0IF?00@100<00@4010401W`10IEgU@<101nEM`5gUGNE0IEgUGL1MiEg
U@6EMiEg0GNEMiD1T7N@00<100R@Mi1gT7N@0@X000<100006`000`400005
00000P5>008101MfT7J@MP5fT7J@MY1f0GJ@MY1f0GJ@MP040@0<T7J@0I1f
T06@MP5f0P402901T8l1S`6?0P401Y010@6@S`8100>E0@401P400gL10@0G
0@09Mi01T7N@M`5f008100>@MY000P401GJ@MY0100`000<100006P000`40
0005000000<00@00CP030@B@00<1T90019000`6@T003T0@10i020@:@0P42
T0070I2@0I2?T0020@0<Si01T8l1Si2?0Hl01`4017L1M`42M`@100>EM`40
0`4049EgU@6EMiEg0GNEMiD1UGL90@07Mi1gT7N@M`020@03T04000d000<1
00006@000`40000500000P020Dh001410041MY1f0GJ@MY1fT06@MP020@09
T7H1MY1fT7J@00<100>@0@4010401GJ@0I2?00<100>?T0400P401Y010Hl1
S`<100Aa0G810WL50@05M`5gM`400gL40@0LT7L1Mi1gT7L1Mi1gT06@Mi1g
0GJ@MY1fT7J@MP813`000`40000I00030@0000D0000400030@0004`000<1
00000P42T0030I2@00>@0`45T0030I2@00F@00@1T9010Y000`6?0@030@04
T8l1S`<100N?T041S`6?00X100R@M`5gT06@M`<100IgUGL1MiD50@0EUGL1
MiEgU@6EMiEg0GN@Mi1gT7N@00814P000`40000I00030@0000@000050003
0@0004`000@100000`400i1f0@020@0>MY01T7J@MY1f0GJ@MY020@0<MY01
T7J@0I1f0GJ@0`40192?0Hl20@0<T8l1S`6?0G41MWL10WL01@5gMgL1009g
0P43M`D100IgT06@Mi0:0@09Mi01T7J@MY1f00815@000`40000H00030@00
00@0000600030@0004`000<100000P030@J@0P45T0050I010I001@402i01
T8n@0I2?T06@00<100F@S`41T0040@0<Mi01T7N@0I1g0GN@0`401I1g0@6@
008100=gT7L00`403GNEMiD1UGNEM`5gUGL00`4017N@Mi020AP000<10000
5`000`40000400001`000`40001<00030@0000<00P4037J@MY1fT7H1MY1f
T08100QfT7H1MY01T0L100N@0I2?T06@00<100>@0@400Xl=0@9g0P42M`<1
00MgT7N@0I1g0081012@M`5gT7N@0I1gT06@MP5f0P4J00030@0001L000<1
0000100000P00P5=00030@0000@000<1T9001I001`6@0@6@Mi000`42T009
0Hn@0I2?T06@00<100N@0I2?T06@00D100n@Mi01T7N@M`5gT7L1Mi001040
0gN@M`020@07T06@Mi1gT0040@0:MiD1UGNEM`5gT0817@000`40000F0003
0@0000@0000:00030@0004/000<1000010001`5fT7J@MY000P405WJ@MY1f
T7H1MY01T7H1MY1f0GJ@0I070@03S`6?008100]fT7J@0I1fT05gMP040@03
T7N@008100=gT0401040291g0@6@Mi1g10400i1g0@030B0000<100005@00
0`40000400002`000`40001;00030@0000@00P42T08100V@M`41T7N@Mi00
30402Xl1Si01T8l1Si0@0@08Mi1g0GN@Mi030@05T7N@Mi000`40191gT7L2
0@03T7N@00<190000`40000D00030@0000@0000<00030@0004/000<10000
1@020@06MY1fT7J@0P403gJ@MP5fT06@MP5fT7H1L@0?0@0AMY1fT06@MY1f
0GJ@MY1f0GL00P401i1g0@6@Mi000P4037N@0@5g0GN@Mi1g0BH000<10000
50000`40000400003@020D`000<100001P020@06T7N@Mi1g0P400i010@02
T00B0I2?0Hn@0I2?0Hn@S`6?T06@1@403I1gT7L1Mi1gT7L1Mi0010403gN@
Mi1gT06@0I1gT7N@M`020@05T7N@M`40:0000`40000D00030@0000<0000?
00030@0004X00P48008100EfT7J@MP020@06T06@MP5f40400hl1S`0?0@0:
T7J@MP5gT7N@M`8100F@Mi1gT0020@06Mi010GL1:P000`40000C00030@00
00<0000@00030@0004/000<100001`020@06T041Mi1g1@403Hn@0I2?0Hn@
0I2?0Hl01P405Y01T7N@M`5gT7N@Mi01T7N@Mi01T7L30@05Mi010GL00P40
1I1gT7N@0081;0000`40000B00030@0000<0000A00030@0004/000<10000
20004P6@MY1fT7H1MY01T741LI01T0H100AaT06?0P404G6:0I1fT7H1MY1f
T7H1MY1f00D100IfT7J@MY020@05Mi1gT7L00P4^00030@00018000<10000
0`0001800P5<00030@0000T00P40191gT042T0030Hn@00D100N@S`5fT06@
00<100>@L@4040401gN@Mi01T7L010401I1g0@6@0081<@000`40000A0003
0@0000<0000D00030@0004X000<100002P020@03MY0100@100N@L@5aT06@
00D100N@L@41LP5a0081015fT7H1MY1fT7J@0I1fT7J@MP030@07MY1fT7J@
MP020C@000<1000040000`40000300005@000`40001:00030@0000/00P40
2Y01T901Si01T8l20@04T7H1MP8101F@LI01T05b0I1gT06@Mi1gT7N@0I00
104027N@0I1gT7N@0P4g00030@0000l000<100000`0001H000<10000BP00
0`40000<00<100B@0I1a0`40176@0I020@08LI1a0G5g0G8?0@0:T7J@MY1f
T06@MP81>@000`40000?00030@0000<0000G00030@0004X000<100003@05
0@05Mi010GH00P40291f0G41L@5a1@4047N@0I1gT7N@Mi1g0GN@Mi060C`0
00<100003`000`400002000060020D/000<100002@030@8000<1T7400P40
1I010G6@008100Ea0G5gL@030@0:L@410GJ@0I1fT0T1@`000`40000>0003
0@000080000J00030@0004T000<1000010040@H000<1T7L00P401I1g0@6@
008100=gT0400P400i010@090Dd000<100003@000`40000200006`000`40
001900030@0000<12`020@05LI010G400P400i1aT0020@05LGL10G402040
0`010@030DP000<100003@000`400002000070000`400019008140020@06
T7L1Mi1g1`400gL10@080@03O04100<1B0000`40000<00030@000080000M
0081B@000`40000A008100QaT041L@5aMa@1B@000`40000;00030@000080
000O00030@0004H000<1000050020@08M`410GN@0I0<0@05M`41M`40BP00
0`40000:00030@000080000P00030@0004D000<100005P00105aT7470@06
L@5bM`5g1`5;00030@0000X000<100000P00024000<10000A0000`40000I
00@100B@M`5g1P400gL10@1@00030@0000X000<100000@0002800P540003
0@0001d02`5C00030@0000T000<100000@0002@000<10000@@000`40001l
00030@0000P000<100000@0002D000<10000@0000`40001l00030@0000P0
00<100000@0002H000<10000?`000`40001m00030@0000L000<100000@00
02L000<10000?P000`40001n00030@0000H000<100000@0002P00P4n0003
0@0007l000<100001@000`4000010000:P000`40000k00030@0007l000<1
00001@000`4000010000:`000`40000j00030@00080000<100001@010@40
0@0002`000<10000>@000`40002100030@0000@00@410040000]0081>@00
0`40002200030@0000<00@410040000_00030@0003H000<10000PP000`40
000300410@010000<0000`40000d00030@0008@000<100000P010@400@00
034000<10000<`000`40002500050@0000400P0003800P4c00030@0008H0
00@100010P0003@000<10000<0000`40002600040@000@80000e00030@00
02l000<10000Q`00104000410000=P000`40000^00030@0008P000<10040
0@0003L000<10000;@000`40002900810@0003P00P4]00030@0008T00P41
0000>P000`40000Z00030@0008T00P410000>`000`40000Y00030@0008D0
10430000?0000`40000X00030@00084010470000?@020BP000<10000O@04
0@/0000o00030@0002D000<10000N@040@l0001000030@0002@000<10000
M@040A<0001100030@0002<000<10000L@040AL0001200030@00028000<1
0000K@040A/0001300818P000`40001Y00@17`0004D000<100007`000`40
001U00@18`0004H000<100007P000`40001Q00@19`0004L000<100007@00
0`40001M00@1:`0004P00P4M00030@0005T0104_0000BP000`40000J0003
0@0005D0104c0000B`000`40000I00030@000540104g0000C0000`40000H
00030@0004d0104k0000C@020AP000<10000B@040Cl0001?00030@0001D0
00<10000A@040D<0001@00030@0001@000<10000@P030DL0001A00030@00
01<000<10000?P040DX0001B00030@00018000<10000>P040Dh0001C0081
4P000`40000f00@1DP0005D000<100003P000`40000c00@1EP0005H000<1
00003@000`40000_00@1FP0005L000<1000030000`40000[00@1GP0005P0
0P4<00030@0002L0105R0000FP000`40000900030@0002<0105V0000F`00
0`40000800030@0001l0105Z0000G0000`40000700030@0001/0105^0000
G@020@L000<100005`040G80001O00030@0000@000<100004`040GH0001P
00030@0000<000<100003`040GX0001Q00030@00008000<100002`040Gh0
001R00050@0000402@040H80001S008100<00@0010040HH0001U008100<0
0@400P6:0000IP020Hh00000
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{246, 212.125},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Chapter 11: Diagonally Shaded Surface", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(SphericalPlot3D[{Sin[
            theta], \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ FaceForm[
            GrayLevel[
              0.05\  + \ 
                0.9\ Sin[
                      2  theta\  + \ 
                        phi]^2], \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ GrayLevel[
              0.05\  + \ 
                0.9\ Sin[
                      2  theta\  - \ 
                        phi]^2]]}, \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ {theta, \
\ 0, \ Pi, \ Pi/36}, \ {phi, \ 0, \ 3  Pi/2, \ Pi/18}, \ 
        Lighting -> False\ ];\)\)], "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000410000g0P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcojh00P5A0000[0020@0300410500002Y00<10`020E00002W00811P00
0`400@1?0000Y0030@P000@10001CP000:800P4;00040@000Dh0002O00<1
3@001@40000104d0002M008140000`40000200030@0004X0002J00<14`00
1@40000104`0002H00815P000`40000200030@0004T0002E00<160000`40
000300030@0004P0002B00<16`000`40000300030@0004P0002@00817P00
0`40000400030@0004L0002=00<180000`40000400030@0004L0002;0081
8`000`40000500030@0004H0002800<19@000`40000600030@0004D00026
0081:0000`40000600030@0004D0002300<1:P000`40000700030@0004@0
00210081;@000`40000800030@0004<0001n00<1;`000`40000800030@00
04<0001l0081<P000`40000900030@000480001i00<1=0000`40000:0003
0@000440001g0081=`000`40000:00030@000440001d00<1>@000`40000;
00030@000400001b0081?@000`40000;00030@0003l0001_00<1?`000`40
000;00030@0003l0001]0081@P000`40000<00030@0003h0001Z00<1A000
0`40000=00030@0003d0001X0081A`000`40000=00030@0003d0001U00<1
B@000`40000>00030@0003`0001S0081C0000`40000?00030@0003/0001P
00<1CP000`40000?00030@0003/0001M00<1D@000`40000@00030@0003X0
001K0081E0000`40000@00030@0003X0001H00<1EP000`40000A00030@00
03T0001F0081F@000`40000B00030@0003P0001C00<1F`000`40000B0003
0@0003P0001A0081GP000`40000C00030@0003L0001>00<1H0000`40000D
00030@0003H0001<0081I0000`40000C00030@0003H0001900<1IP000`40
000D00030@0003D000170081J@000`40000E00030@0003@0001400<1J`00
0`40000E00030@0003@000120081KP000`40000F00030@0003<0000o00<1
L0000`40000G00030@000380000m0081L`000`40000G00030@000380000j
00<1M@000`40000H00030@000340000h0081N0000`40000I00030@000300
000e00<1NP000`40000I00030@000300000c0081O@000`40000J00030@00
02l0000`00<1O`000`40000K00030@0002h0000^0081PP000`40000K0003
0@0002h0000[00<1Q0000`40000L00030@0002d0000Y0081Q`000`40000M
00030@0002`0000V00<1R@000`40000M00030@0002`0000S00<1S@000`40
000M00030@0002/0000Q0081?`030Dh000<100007@000`40000[00007P03
0Ch00`43DP@1BP000`40000N00030@0002X0000L0081?`030@=B0P400e81
DP030DP000<100007`000`40000Y00006@030Ch01043DP<100=B0E800`40
0e810@1600030@0001l000<10000:@0001L00P4o00@100>?0E800P400e81
DP0:0DD000<1000080000`40000X000050030Cl010400`2?0@030@03DP5B
00<100MB0E81DP5B0081A0000`40000Q00030@0002L0000B0081@0040@04
S`2?01@1@`000`40000Q00030@0002L0000?00<1@@030@0408l0S`8100=B
0E801@401E81DP5B00<100=B0E800P5200030@00028000<100009P0000d0
0P5200<100B?08l00P400hl10@0D0D8000<100008`000`40000U00002`02
0D@000@108l00`42008100UB0E81DP5B0E800`402U81DP5B0E81DP510003
0@0002<000<100009@0000/00P52008100T00@4108l0S`006@5000030@00
02@000<10000900000/000<10040?`050@H010403E81DP5B0E81DP5B0E80
1@401U81DP5B0Cl000<100009@000`40000S00002`001040004m000:0@01
0Hl0S`2?008100>?0@406@4o00030@0002D000<100008`0000X000<10000
0P000`40000h00<100<00@0010020@<000H1DP5B0E830@07DP5B0E81DP05
0@05DP5B0E800P4n00030@0002H000<100008P0000X000<100000`000`40
000e008100R?0Hl1S`2?008100F?08l0S`080@03DP4100D100=B0E802P4m
00030@0002L000<100008@0000X000<1000010000`40000c00040@010@80
00<100000P4700040E81DP<100EB0E81DP030@09DP5B0E81DP5B00<100=B
0@40?@000`40000V00030@000240000:00030@0000D00P4b00080@0108l0
0@020@09S`2?08l0S`2?00@100MB0E81DP5B008100YB0@5B0E81DP5B0`40
1581DP4m00030@0002L000<10000800000X000<100001`000`40000^00<1
10020@X01P401E81DP5B00811580105B0E830@08DP5B0E81DP4l00030@00
02P000<100007`0000X000<1000020000`40000/00<100<0S`000`402@2?
08l0S`2?00020@03S`41009B10400e810@06DP@115801`5B0E81DP40>`0=
0Ah000<100007`0000X000<100002@000`40000Z00811000104000470081
0`020@IB0P49DP030E9B00AB00@1DP5B0P4h00@100F?08l00@05S`030Hl1
008170000`40000N00002@000`40000;00030@0002P00`40302?0@40S`01
08l0S`<100J?08l0S`47DP030E8E008115820@03DP5B00EB00<1DP400`4c
00@100T0S`4108l0S`401Xl0104E5AD30AX000<100007@0000T000<10000
30000`40000V00<10P000`40000200040@00008120000`5BDP05DP030ADE
008E0P400e815@035@030E9B00AB0P43DP030@0002d00`46008100J?08l0
S`45S`060AF?5HlE0`4H00030@0001d0000900030@0000d000<100009002
0@0;S`6?0Hl0S`2?0Hl00P402`2?08l0S`2?08l100IB01015E8EDQEB5@4E
DQEB5E810e820@035@5B009B00<10000:@040@09S`0108l0S`2?008100L0
S`2?08l100F?00<15AD00QD00`4EDP020AL000<10000700000T000<10000
3P000`40000R008100@00@411P020@`01@42DP030ADE00DE0`455@030E81
00<E00<1DU800U800`40000V00811`000`4000030@09004108l0S`0100F?
00L1SaF?5Hl100<E00<1000050000`40000L00002@000`40000?00030@00
02000P402Hl00@2?08l0S`030@0<S`2?08l0S`2?08l00P40158EDQD30@07
5E8EDQEB0@035@0=0E8EDQEB0E8EDQEB0@03DP030@0002@00P402Hl1S`2?
08l0S`030@03S`0100d10Xl00`4E5@025@040E8EDP815P000`40000K0000
2@000`40000@00030@0001l000<100000P4500040Hl00@X00P400`015@04
5@030Hl100<10QD01@6?5HlE008100DE0@4E0@055@050E9BDP4090000`40
000200040@0000P100<0S`000P45S`040AF?5@@100F?5HlE0@035@815P00
0`40000J000020000`40000B00030@0001d000T1S`010040S`000P4038l0
S`6?08l0S`2?008100V?08l1DQEB5@401QD20@LE00<15AD00QD01P5B5E8E
0@9B0P4R008100D0S`2?00070@0;0040S`2?08l1S`4018l00`4E5@035@03
0AD100@100HEDQD1DP4E00030@0001X0000800030@0001<000<100006`00
1`400040S`400P001`40S`2?00401@030@0608l0S`0111D0204ESaF?5Hl1
0Xl20@0;SaF?0Hl1SaF?5@4011D20@035@40020000<100000`050@D000/1
S`2?08l0S`6?0@04S`070HlESaF?0@045@810aD00`5B0@0E00030@0001T0
000800030@0001@000<100006@020@0B0040S`6?0040S`2?08l1S`2?0P40
202?08l0S`2?20445@030Hn?00:?0P4011D1Shl20@<E00T1DP415E8EDP40
7P020@03S`6?00D101>?0Hl0S`2?08l1S`2?08l00Hl100B?00<15AD00aD0
1P5B5E8EDP<100=B0E800P4E00030@0001P0000800030@0001D000<10000
60001P400@2?00<100T0S`2?08l00@000P403hl0S`2?08l0S`01SaF?0@03
S`@11hl00`6?S`03S`090AF?5@4ESaD1008E00<100006`000`40S`030@03
004100@000<1000010001040S`070@>?00L1SaF?5Hl100DE00<1DU800`40
0e810@0D00030@0001P0000800030@0001H000<100005P030@0>08l0S`6?
08l0S`2?08l20@0=08l0S`2?08l0S`2?0@035@030Hn?00B?00@1004118l3
0@B?00D15@6?0@035@040E8E0AX01@403Xl00@6?08l0S`0108l01`43S`04
0ADE5@D111D01`5B5E8EDP4015800`5BDP020A@000<100005`0000P000<1
00005`020AH00P40102?08l20@0708l0S`2?00030@0<08l0S`2?08l0S`2?
0P4018lES`46S`040Hl0S`8100J?0@2?0044S`080Hn?S`4ES`425@030@00
01L00`400hl0S`030@H01@40102?0046S`090AF?5Hl1S`4E00@100<E0AD0
11D0105BDU820@03DP4101D000<100005P0000P000<100006@000`40000B
008100h0S`2?0Hl1S`2?08l00@:?00/1S`2?08l0S`2?00020@03S`4E008E
00<1Shl018l01P40S`2?00<100<0S`000P4018l1S`43S`070ADE0AEB0@0F
008100^?0Hl0S`6?08l1S`040@090040S`2?08l100J?00<15AD00QD0204E
0E8EDQEB0`401E8EDQD100AB1@4D00030@0001H0000700030@0001/000<1
00004@020@04S`2?0@:?00D108l0S`020@>?00T108l0S`2?08l00P44S``1
00L0S`2?0040008100R?08l1S`2?0@:?00D1SaD15@020A<01042S`040@01
0@<00`4500080Hl0S`2?0046S`060AF?5HlE0P465@040E810@8E00<1DU80
0U800`5B0@020AD000<100005@0000L000<1000070000`40000?0004S`6?
00810hl01@6?08l100J?00H108l0S`020@J?00`1Shl1S`2?08l00@040@05
S`6?08l00P401`010@40S`400Xl01P4E0@4E0A000`4200030Hn?00:?00@1
08l00P401hl1S`2?08l03043S`030ADE00@E00P1DQEB5E8E0@=B0`44DP81
00AB0@415@000`40000D00001`000`40000M00030@0000h00P400`01S`04
S`040@2?0@N?00@1S`2?0P48S`0<0Hn?S`6?08l0S`0110030@@00P420005
0@2?0Hl00P43S`035@4000/00`4400040Hn?S`<100<00@400`000`400@03
0@03S`6?00F?00@1SaF?1`400hlES`020@DE00<1DU800e820@=B00@1DP5B
0P4E00030@0001@0000700030@0001h000<100003000106?0@46S`<128l0
10400@4:S`0C0Hn?S`40S`2?08l1S`2?08l1S`030@06S`010Hl00P402Hl1
S`01S`4E0@0900<11P001`6?Shl1S`000P4018l0S`030@0608l0S`011Xl0
0`4E5@045@040AEB5@D100HEDQEB5@45DP040E810@9B00@1DP5B0P4E0003
0@0001<0000700030@0001l000<100002P040@N?00<1Shl028l20@f?3P42
00030@0000800P4200810P001@400Hl100:?00<E0@001@030@P000<15@40
0P401Xl00@0100<100P00@2?08l00@J?00T15HlESaF?5@401QD0105B0@43
5@030E9B00=B0P400e810@030@04DP410AH000<100004P0000L000<10000
80000`40000900030Hl100N?0P48S`<13Xl03P6?08l1S`2?08l1S`2?1040
102?08l30@04S`01008100F?0Hl1S`020@<00`4;00050AD108l00P402`01
0@40S`0108l000L10hl00`4E5@045@080E8EDQEB5@43DP<100<E0E801580
2P5B0E81DP5B0E830AD000<100004P0000L000<100008@000`4000070004
0Hl10@J?00<1S`401hl01@6?5Hl100b?0P40102?004600030@00008000<1
00400`401001004200090@000@01S`6?00@13@00106?0Hl20@0600410040
1`43S`040HlES`L100B?5Hl11QD00`5BDP02DP030E81008115820@03DP5B
00<100=B0@400P4F00030@000140000600030@0002<000<100001P00106?
0@45S`040ADE0@F?0P445@030Hn?00R?0P405aD1S`2?0040S`2?0040S`2?
0040S`2?00<100>?0@400P401@2?0@4000@13P000`4E0@02S`<100>?0@40
0P40102?0045S`030ADE00@E00D1DQEB5@050@065E8EDQD115801@5BDP5B
00810U801P5B0E81DPP15P000`40000@00001P000`40000T00030@0000@0
00D1S`4E0@03S`8100F?5HlE0@03S`080AF?5HlES`48S`8100N?5HlE0Hl0
01410P002@6?0@400@0100030@0400410@h00P42S`8100X00@400Hl0S`01
1Xl0204ESaF?5Hl11QD00`5BDP030@035@5B00EB0P400e81DP050@03DP5B
00<100=B0@400`4F00030@000100000600030@0002D000<100000`001@6?
0AD100:?00<15AD011D0106?S`475@030Hn?00B?0P465@<10140S`6?08l0
S`6?08l0S`6?00040@03S`0100@100D00@0100030@`00P400hl10@030@03
004100l10aD02@4EDQEB5E8E0@05DP<11U820@0;DP5B0E81DP5B0E802@4F
00030@0000l0000600030@0002H000@100000`4038lE0Hl15HlESaF?5@<1
00XESaF?5HlESaD10hl20@09SaF?5HlESaD100D000<100000`0010400006
0@03004100L100<00@00104;008100>?0@400P4010010@45S`070AF?5HlE
0@045@@11QD00`5BDP05DP040E810@AB00H1DP5B0E830@09DP5B0E81DP5B
00@15P000`40000?00001P000`40000W00030@0000<10QD20@PE00<15AD0
2AD0106?0@4:5@0:0@2?08l00@2?00H100B?08l10Xl;0@040041S`812`00
0`4E0@0?0@<E00P1DQEB5E8E0@9B10400aEB0@06DP040E81DP<100MB0E81
DP5B01815P000`40000>00001P000`40000X00@100`ESaD15HlESaF?5Hl2
0@0;5HlESaF?5HlESaD00P403XlESaF?5HlESaF?5Hl110040@@000D1S`2?
00030@>?00<1S`401P401@010@6?00X02P4011F?5Hl20@<E10465@030E9B
00AB0`46DP8100EB0E81DP030@09DP5B0E81DP5B00<100EB0E81DP050AL0
00<100003@0000H000<10000:@030@8E0P475@040AEB0@PE0`4>5@030Hl0
008100V?0040S`2?08l03P400aD10@050@03004100P010400hl10@090@06
DQEB5E810U830@035E8100MB0P400e810@03DP8100EB0E81DP050@03DP5B
01815`000`40000=00001@000`40000Z008100b?5Hl15@6?5HlES`435@07
0HlESaF?5@020@<E00d1SaF?5HlESaF?5HlE00@11@00104000060@>?0P40
0hlE0@040@055@410@00104800L100@E0ADE0P43DP810QD00`5BDP04DP<1
1U820@03DP5B00<100eB0E81DP5B0E81DP5B00<100MB0E81DP5B00<100=B
0@400`400e810@0G00030@0000`0000500030@0002X00P425@040AEB0@@E
00H15E8EDP455@070E8EDQEB0@0:5@8100YB0Hl0S`2?08l01@400`2?0002
0@:?1@400aEB5@060@04S`410@L00P400hl10@070@MB0`45DP<100AB0@41
0U820@0?DP5B0E81DP5B0E81DP5B01/160000`40000;00001@000`40000Y
00<100>?5@400QD01@6?5Hl100DE00@1SaF?0P475@070AF?5HlES`030@@E
00<100000P030@0:0041S`2?08l0S`8100F?5HlES`030@=B104018l10@46
00030Hl100@100EB0@41DP030@9B0P400e81DP020@9B00P1DP5B0E81DP<1
00UB0E81DP5B0E800`400e81DP030@05DP5B0E800`400e81DP030@03DP41
00<100=B0E800P4H00030@0000/0000500030@0002T00`401QD1DQEB0@8E
00P15E8EDQEB5@<100XEDQEB5E8EDQD111D20@075E8EDQEB5@050@0508l1
0@000P4018l0S`020@03S`4100@E00<1DQD00P400e810@0@0@0;DP5B0E81
DP5B0E800`401E81DP5B00<100MB0E81DP5B00D100EB0E81DP070@03DP41
01/16@000`40000:00001@000`40000Y00@11AD20@PE00<15AD02QD0106?
0@485@<100<00@000P45008100<00Hl018l20@035@4E00@E10400e81000=
0@03DP5B00<100EB0@41DP030@03DP5B00<100MB0@41DP5B00<100eB0@41
DP5B0E81DP5B00<100]B0E81DP5B0E81DP030@07DP410E81DP030@03DP41
00<16@000`40000900001@000`40000Y000B0E810AEB5E8E0AEB5E8EDQEB
0P4031EB5E8EDQEB5E8EDP8100LEDQEB5E8E00<1010EDP6?0040S`2?08l0
S`0128l30@04DQEB0@=B1@401Hl10@6?020100=B0@401`400e810@0V0AT0
00<100002@0000@000<10000:P000`4E0@055@811aD0105BDP495@8100=B
0AD011D20@DE0`400`01000600040@010@B?0P400aF?5@050@=B0`400hl1
0@060@03DP4100D100UB0E81DP5B0E800`40:e81DP5B0E81DP5B0E81DP5B
0E81DP5B0E81DP5B0E81DP5B0E81DP5B0E800`401E81DP5B00<100=B0E80
0`4I00812P0000@000<10000:@020@0>DP5B5E8EDP5B0E8EDQD20@=B00P1
DQEB5E8EDP810e800`4EDP030@0<DQEB5E8EDQD108l00P400hl0S`020@04
08l0S`8100>?0AD01AD0105B5E9O0AH00`400`010009000010000`40000Y
00040AD10@@E00@1DU810aD00`5BDP04DP030ADE00<E00<1DU800e830@XE
0P45000;0@01S`2?08l0S`0010401AF?5Hl100DE00@1DU9B1`403E81DP5B
0E81DP5B0E801@400e81DP030@03DP5B00<100MB0E81DP5B00<100=B0E80
0`402E81DP5B0E81DP050@05DP5B0E801@400e81DP030@03DP5B00<14P04
0@@000<10000200000@000<10000:@00204E0@5B5E810e80105B5@47DP04
0AEB5@810e830@0;DP5B5E8EDQEB5E800P40258108l0S`2?0P40202?08l0
S`0118l50@06DQEB5E810e860@03DP5B05413P030@P000<10000200000@0
00<10000:@001`4E0E815@401E820@UB0`42DP<11E800`4E5@045@811580
0`40000200030@00008100J?08l0S`46S`030HlE00<100<E0E8015860@05
DP410E801@403E81DP5B0E81DP5B0E800`407E81DP5B0E81DP5B0E81DP5B
0E81DP5B0E81DP5B00D100MB0E81DP5B00<100EB0@41DP030@03DP410081
2`030@`000<100001`0000@000<10000:@020@9B00<15@401E800`5BDP08
DP030E81008125801@4EDQEB00811U802P6?08l1S`2?08l20@0308l100N?
00<15AD00aDB0@03DP5B04<100=B0@401@4700@13`000`40000700001000
0`40000Y00810U820@EB00<1DP4025830@aB00@15@412E800`400@0800<1
1Xl02@4ESaF?5HlE0@055@@115820@0;DP5B0E81DP5B0E801@402e81DP5B
0E81DP5B00<100UB0E81DP5B0E800`401e81DP5B0E800`400e81DP030@0A
DP5B0E81DP5B0E81DP5B0E80104400<14`000`40000700000`000`40000Z
00810U800`5BDP04DP<11E840@03DP5B00]B0P4;DP<100/0S`2?08l0S`6?
00040@:?00<15AD01AD01`4EDQEB5E800`45DP8100EB0E81DP070@03DP41
03<100EB0E81DP070@0400410AH000<100001`0000<000<10000:P000`5B
DP02DP030E9B009B0P4015810E830@07DP41DP5B0@09DP@12e800`400003
0@D000L108l0S`2?00H100B?5Hl11aD30@EB00@1DP5B1@403e81DP5B0E81
DP5B0E81DP030@0;DP5B0E81DP5B0E800`401E81DP5B00D100MB0E81DP5B
00<100EB0E81DP050@03DP5B00<100AB0@416@000`40000700000`000`40
000Z00030E9B00<115800`5B0@030@=B0P401U81DP5B0@IB0P401581DP4<
DP050Hl0S`000P4038l00@2?08l0S`2?0@B?20400e8EDP030@03DP4100H1
0e802P5B0E81DP5B0E870@03DP4102X100IB0@5B0E850AX000<100001`00
00<000<10000:P001@5BDP5B00810U850@04DP5BDP8100QB0E81DP5B0@=B
0`401U81DP5B0@YB0P4600<100R?08l0S`2?0@R?00D1SaF?5@070@@E00<1
DU801E80205B0E81DP5B0`401e810@5B0E800`401E81DP5B00<100UB0E81
DP5B0E801@401E81DP5B00<100UB0E81DP5B0E800`401e81DP5B0E800P4J
00030@0000L0000300030@0002X000<1DU800P400e810@030@03DP5B0081
00YB0@5B0E81DP5B0P402U810E81DP5B0E820@QB0`402U8108l0S`2?0Hl3
0@05S`2?004028l00`4E5@055@<100IB5E8EDP47DP8100EB0E81DP050@07
DP5B0E81DP070@03DP5B00/100=B0@401`400e81DP050@04DP5BDP8100=B
0E801@4J00030@0000L0000300030@0002X000<1DP401`401E81DP5B00<1
00UB0E81DP5B0E800`402E81DP5B0E81DP020@AB0`400e81DP020@D000<1
00000`020@03006?00N?00T15HlESaF?5Hl00P465@030E9B00IB0P400e81
0@020@9B00`1DP5B0E81DP5B0E830@05DP5B0E800`400e81DP030@03DP5B
00<100eB0E81DP5B0E81DP5B00810e820@03DP4100@16`000`4000060000
0`000`40000Z00D100UB0@41DP5B0E801@401e81DP5B0E801@402U81DP5B
0E81DP42DP8100MB0E81DP5B008100b?08l00@2?08l0S`060@B?00<15AD0
1QD20@075E8EDQEB0@06DPD11e80205B0E81DP5B0`402E81DP5B0E81DP05
0@07DP5B0E81DP050@05DP5B0E801P44DP<100=B0@400`4K00030@0000H0
000200030@0002T01P400e81DP030@0?DP5B0E81DP5B0E81DP5B00<100eB
0E81DP5B0E81DP5B00<100UB0E81DP5B0E800P4200030@0000L000D108l0
S`090@045HlES`811QD00`5BDP040@8E00<1DU801e820@05DP5B0E800P42
DP0P0E81DP5B0E81DP5B0E81DP5B0E81DP5B0E81DP5B0E830@03DP5B00AB
00@1DP5B104K00030@0000H0000200030@0002H00`4200<100=B0E800`40
1E81DP5B00D100EB0E81DP070@07DP5B0E81DP050@0RDP5B0E81DP5B0E81
08l1S`2?08l0S`0108l0S`2?08l00@B?3`40258EDQEB5E812580105B0E83
0@AB0P401e81DP5B0E800`404e81DP5B0E81DP5B0E81DP5B0E800P400e81
0@07DPL16`000`40000600000P000`40000S00<11@020@03DP5B00<100EB
0E81DP030@07DP5B0E81DP030@0;DP5B0E81DP5B0E800`403E81DP5B0E81
DP5B0E801P47000:0Hl0S`2?08l00@V?0P401aF?5HlES`402AD00`5BDP07
DP040E810@MB0P401E81DP5B00810U80205B0E81DP5B0`401e81DP5B0E80
0P42DP030AD100IB0P400e81DP020A/000<100001P00008000<100008003
0@P00`400e81DP050@03DP4100L100=B0@402@400e81DP090@07DP5B0E81
DP050@0308l100<100d0S`6?08l0S`2?08l100V?0`455@0;0E8EDQEB5E8E
DP401e840@YB0P4015810@45DP060E81DP5B0P43DP8100=B0E800P42DP04
0AEB0@EB1`4L00030@0000H0000200030@0001d00`4;00@100EB0E81DP05
0@05DP5B0E801@401e81DP5B0E801@401e81DP5B0E800`400e81DP030@03
DP5B00811P050@0808l0S`2?0049S`<100N?5HlESaD100TE00<1DU801043
5@030E9B00QB00@1DP411e820@04DP5B0@IB0P400e81DP03DP050ADE5@40
15800`5B0@020@03DP4001/000<100001P00008000<100006P030@h02`40
0e810@0Q0@03DP4100P100Z?08l0S`2?0Hl010400hl00@09S`@11QD01@4E
DQEB00P100PEDQEB5E8E0@YB0P4:DP@11e800`5B0@04DP060E8EDQD10e80
0`5B0@050A`000<100001P000003004001X00P4A0081015B0E81DP5B0E81
DP5B0E81DP050@07DP5B0E81DP050@09DP5B0E81DP5B00<100UB0E81DP5B
0E800P4500030@0000D02044S`@100>?0@4020401QF?5HlE0@XE00<1DU80
1E820@035@5B00UB0P4:DP030E9B009B00<15AD011D0205B0E81DP5B0`4M
00030@0000D000000`01000G00<1500j0@0E08l0S`0108l0S`2?08l00@2?
08l000T11Hl00`4E5@085@0;0E8EDQEB5E8EDP4015830@055E8EDP401e82
0@035E8100MB0`43DP0:0E8EDQEB5E81DP8100=B0@40104M00030@0000D0
00000`01000D00<15`000`5B0@020@03DP5B00<100]B0E81DP5B0E81DP03
0@0?DP5B0E81DP5B0E81DP5B00<100=B0E800`401e81DP5B0E800`440003
0@0000L000X1S`2?08l0S`2?1@45S`0<0AF?5HlESaF?5Hl12QD0105B0@47
5@030E9B00=B0P445@030E9B00AB00T15ADE0E815@401aD20@03DP5B00<1
00=B0@0070000`400005000000<00@004@030AX0?0406@2?0Hl0S`2?08l0
S`0108l0S`2?08l00@000`45S`030ADE00PE00T1DQEB5E8EDQD010402U8E
DQEB5E8EDP43DP8100PEDQEB5E8E0@AB00D1DQEB5@020@8E00L15E8EDQEB
008100EB0E81DP050A`000<100001@000003004000h00`4M00030E8100@1
00EB0E81DP030@09DP5B0E81DP5B00<101EB0E81DP5B0E81DP5B0E81DP5B
0E800`402E810@5B0E81DP050@L000X108l0S`2?08l00`4018l10@45S`0<
0HlESaF?5HlESaD10QD50@03SaD100/E0`495@030E9B008111D01`6?5HlE
S`4011D01`5BDP5B0E801P4L00030@0000D000000`01000;00<1800m0@04
S`6?00D100`0S`6?08l0S`2?08l30@04S`410@F?00<15AD01QD50@PE00X1
DQEB5E8EDQEB0P4031EB5E8EDQEB5E8EDP8100HEDQEB5@465@060E8EDQD1
0U820@03DP4100<10P000`40000I00030@0000D000000`01000800<19004
0@09DP410E81DP5B00<1015B0E81DP5B0E81DP5B0E81DP030@03DP5B00<1
00EB0E81DP050@07DP5B0E81DP020@P020400hl0S`040@03S`01008118l0
0`6?5@060@:?00`15HlESaF?5HlES`475@8100<ES`402QD20@DE00X1SaF?
5HlESaD10QD0205BDU81DP5B104300030@0001P000<100001@0000030@00
00D00`4W03h100n?08l0S`2?08l1S`2?08l00`400e810@0=0@R?00<15AD0
21D01@5B5E8E00<111D02@5B5E8EDQEB5@020@095@5B5E8E0Hl100LE00<1
5@4015820@03DP4100<110000`40000G00030@0000D000000`40000200<1
:P040@0;DP410E81DP5B0E800`400e81DP030@05DP5B0E801@401e81DP5B
0E801@402e81DP5B0E81DP5B00<100=B0@4020000`40000500/100@0S`01
2Xl03P4ESaF?5HlESaF?5@4E0P402HlESaF?5HlE0@055@8100J?5HlE0AD2
0@:?00X15HlESaF?5Hl11U820@03DP41008110000`40000H00030@0000@0
00000`400@020Bh0@0403P2?08l0S`6?08l0S`2?2`4018l0S`4;S`030ADE
00LE0`4:5@040AEB5@811QD20@F?00<15AD011D20@IB1P4600030@0001L0
00<1000010000081<@030@07DP410E81DP030@0?DP5B0E81DP5B0E81DP5B
00D100MB0E81DP5B00D100MB0E81DP5B00<100YB0E81DP5B0E8110000`40
000500X100L00@6?08l100Z?00H1SaF?5Hl40@0>S`4ESaF?5HlESaF?5Hl3
0@09SaF?5HlESaD100J?00D1SaF?5@020@8E00<1DU800e820@04DP410@L0
00<100005P000`400004000000<00@00<00N0@03DP5B00T100=B0E802@40
0e810@090@0:08l00@2?08l0S`L100=B5@401040102?004:S`030AD100<1
1Xl00`4E5@085@812AD00`6?S`06S`090ADE0E8EDQD100AB1`4800030@00
01D000<10000100000800P4`0003DP4100<100]B0@41DP5B0E81DP050@0?
DP5B0E81DP5B0E81DP5B00<100EB0E81DP050@05DP5B0E800`400e810@03
0@05DP4100401P030@04DP410@8E0P401`010@40S`401Hl70@Z?00P1SaF?
5HlES`<100V?0HlESaF?5Hl00P400hl1S`06S`030AD100DE00@1DU9B1040
0e810@0900030@0001D000<10000100000@000<10000;@0C0@03DP4100D1
00MB0E81DP5B00D100MB0E81DP5B00<100MB0E81DP5B00D100=B0E803040
0e810@030@04DQF?00`100J?08l0S`4;S`030ADE00<E0P45S`030ADE008E
0P40102?0048S`080E8EDQEB5@42DP8100=B0@400`4:00030@0001@000<1
0000100000D000<10000;0020@07DP410E81DP030@0;DP5B0E81DP5B0E80
1@401e81DP5B0E800`401e81DP5B0E800P42DP<100=B0E800P44DPD1158G
0@0;S`2?08l0S`2?004038l00`4E0@020@N?00<15Hl00P401hl0S`2?0040
1Hl30@LE0`400e810@030@`000<100004`000`40000400001P000`40000/
00X100=B0@400`401e81DP5B0E800`401e81DP5B0E800P42DPD100=B0E80
1U850@=B0P40158EDQD70@05S`4E0E8040402hl0S`2?08l0S`0100V?104:
S`<100T0S`2?08l0S`400hl20@<E00L15E8EDQEB008100=B0@40104=0003
0@00018000<10000100000L00P4/00D100MB0E81DP5B00D100UB0E81DP5B
0E800`400e81DP020@MB0`47DP030ADE008E4@400aD10@080@035@6?0081
00<00@400`402@2?08l0S`2?0@05S`@100<0S`402Hl30@8000T108l0S`2?
08l00`401QF?5HlE0@@E0`400e81DP040@h000<100004`000`4000030000
2@000`40000Z00T100=B0E800`402581DP5B0E8115820@03DP4100QB00<1
5E801042DP080E8EDQEB5@455@<100@00@6?3P401AD1004000P100R?08l0
S`01S`@100R?08l0S`2?0@J?0P403Hl0S`2?0Hl0S`2?08l00P475@050AEB
5@400U820@03DP4100<13`000`40000B00030@0000<0000:00030@0002T0
0P402e81DP5B0E81DP5B00<100EB0E81DP020@IB0`47DP030ADE00DE1@43
5@030HlE00D100>?0@401@400aD10@040@04DP410@8E0P400`010@050@03
S`4100L100d0S`2?08l0S`2?006?00D120001@6?08l0008100Z?0AF?5HlE
SaF?0`43DP070E81DP5B0@0A00030@00014000<100000`0000/000<10000
:@040@07DP410E81DP020@9B0`400e810@08DP030AD100<10U802P4EDQEB
5E8EDP445@H10Xl50@030041008100@E0@5B1@401E810E8E008100>?0Hl0
0`4018l10Hl20@03S`4100<100J?08l0S`070@0@08l0S`6?08l0S`2?0040
S`8118l00`4E5@045@811580105B0E840A4000<100004@000`4000030000
30020BT00`402U81DP5B0E81DP44DP8100=B0E801U800`4E5@045@@11aD0
1`6?5HlES`400Xl70@0900410Hl15@4E008100=B0E801@425@:?00@00@6?
0`400`01S`020@06006?0@2?1P4400030@0000D000<1000010040@J?00D1
SaF?5@020@035@5B00=B1`4C00030@00010000<100000`0000h000<10000
9`030@03DP4100<100=B0@401U830@IB00T1DQEB5E8EDP400QD40@03DQD1
008E1`400hl0S`020@0308l100810Xl20@03DP5B00H100EB0@5B5@030@:?
0P401`010Hl00@000P400hl10@020@0D08l1S`2?08l00@2?08l0S`0108l4
0@0308l100R?00P15@41DQEB0@AB1P4E00030@0000l000<100000`0000l0
00<100009`030@04DP41DP8100=B0E801E800`4E5@040@03DP4E00LE00L1
SaF?5HlE00D10hl01@6?08l000810P020@0<006?S`6?0AD1DP5B2@402AD1
S`6?0@0100020@0800410@01S`4200L10`00104000060@07S`2?08l00@07
S`<11AD00`5BDP02DP8100AB0@415P000`40000>00030@0000<0000@0081
:0001@5B0E81009B0`46DP070AEB5E8EDP040@065E8EDQD11aD00`6?S`04
S`030Hl100<100D00@4100020@0:S`415@4E0E81DPP100AB0E8E0P42S`04
0@2?008100J?08l1S`020@08S`2?0040S`070@0>08l0S`0108l0S`2?0043
S`<100PE0AEB5E8E0@=B1`4G00030@0000h000<100000`00018000<10000
9@020@03DP4100AB0P45DP030ADE00DE00<15Hl010402QD15HlESaF?5@42
S`H110020@8000T108l00Hl15@400U840@03DP4100<10U802P4E0AD1S`6?
0@040@8000@100400`4200030@0000@000<100001@002P6?08l0S`2?0Hl2
0@05SaF?5@401AD02@5BDP5B0E81DP020AP000<100003P000`4000020000
4`000`40000U00@115800`5B0@030@0:DP4EDQEB5E8E0@HE3040202?08l1
S`2?0P401P010@40S`8100J?0@5B0E8;0@9B00D15@4E0@02S`070Hl1S`01
00020@08S`010Hl0S`060@0?S`0108l0S`2?08l1S`2?00D11QD01P4EDQEB
5@<100=B0@40104J00030@0000d000<100000P0001@000<100009@00105B
0@44DP030ADE008E0`455@0:0HlESaF?5HlE0@J?00X108l0S`2?00400P43
00050Hl0S`400Xl00`6?5@020@09DP5B0E81DP5B00@100YB0AD15Hl1S`40
0P400hl00@0200040@0100810`000`40000200l10hl02@4ESaF?5HlE0@04
5@<100EB0E81DP020A`000<1000030000`40000200005@020BH000@1DP41
0e80204EDQEB5@4E10400e815@075@030Hn?00B?00@1S`2?1P400`2?0002
0@04S`410@:?00H15AD1DQD;0@06DP5B0AEB0QD0106?0@42S`0;0Hl00@2?
0040S`000P404Xl1S`2?08l0S`6?08l0S`2?0@J?00<15AD01AD00`4E0@02
0@05DP5B0E801@4L00030@0000`000<100000P0001L000<100008`020@06
DQD10E811AD01P4ESaF?5@H100B?5Hl10hl80@@000<100000P4300080Hn?
S`6?5@425@030E9B00@100=B0E801042DP035@4100<100<ES`400Xl01`6?
00400@000P4300@11@002@40S`2?08l00@06S`060AF?5HlE1043DP040E81
DP<100=B0@007@000`40000;00030@000080000H00030@0002<000D1DP4E
DP030@06DQEB5E811AD00`6?S`02S`L100`0S`2?0Hl0S`2?08l30@03S`2?
008100@00Hl10aD0104EDP42DP030E8100/100QB0E8EDP4E0@>?00l1S`01
08l0S`6?08l1S`0010402Xl1S`2?08l0S`46S`030AD100<100=B5@401582
0@03DP4100<180000`40000:00030@000080000I00030@0002<000<1DP40
0aD20@@E00P1SaF?5HlE0@J?00X108l0S`2?08l11@020@<00P402Hl0S`01
SaF?0@025@050E9B0E800`400e81DP050@05DP5BDP400QD0106?5@43S`03
0Hl1008100f?08l1006?08l0S`2?01811AD00`5BDP03DP030E81008100=B
0@408@000`40000900030@000080000J008190030@035E8E00@100=B0AD0
1AD00`6?S`05S`0:0@2?08l0S`0100@100>?00400P403P2?08l00Hl15@4E
DQD10U8<0@0:DP5B0E815E8E0@8E00D1Shn?0@03S`8100<0S`000`401`2?
08l0S`401hl00`4E5@045@080AEB5E8EDP44DPP18P000`40000900030@00
0080000L00030@0002800P435@040AF?5@H100B?5Hl11Xl0106?08l60@H0
00H1S`2?08l20@>?00D15ADE0@02DP8100MB0E81DP5B00D100=B0@400U80
204E5@4ES`6?0P400aD1S`03S`8100B?0Hn?10400hl1S`06S`090AF?5HlE
SaD100HE00@1DU9B0`400e810@020B@000<100002@000`40000100007@00
0`40000R008100AB5E8111D0106?Shl>0@09S`2?0040S`2?008100L0S`6?
08l100B?00H15@41DP42DP030E8100`100QB0E9B0E8EDP8E0P445@030Hn?
00>?0P46S`D118l00`4E5@045@090E8EDQEB5@5B00X19P000`4000080003
0@000040000N00030@0002800`4021D1SaF?5Hl11Hl02@40S`2?08l00@07
00040@010@D000<1S`400hl20@04SaF?5@8100MB0E81DP5B00<100MB0E81
DP5B00810e825@<10QD01P6?5HlE0@>?00<15Hl00P44S`050HlESaD02040
18lES`435@D100EB0E81DP040BP000<100001`000`40000100007`020B<0
0`400aD15@035@030Hn?00B?00h108l0S`2?0Hl0S`2?00<100T0S`2?08l0
S`400hl00`4E5@035@030E8E00<100=B0@402`401581DU830@9B00D15E8E
0@045@030Hl100DE0P42S`030ADE00DE00D1DQEB5@070@9B0P400e81DP06
0BT000<100001`000`40000100008@000`40000Q008100<E0@400P400hlE
0@05S`0:0Hl0S`2?08l100@10P000`400003008100/0S`6?0AF?5HlE0@03
5@030E9B01<100=B0E800U802@4E5AD1SaF?5@020@07SaF?5HlES`030@07
SaF?5HlE0@075@030E9B00=B0P401E81DP5B00<1;0000`40000600030@00
0040000R00030@0002400P4011D1Shl70@:?00@1S`2?1@402Xl0S`2?08l1
S`020@05S`2?08l00P445@060E8EDQD10e80105B0E8=0@03DP4100AB00H1
5E8E0AD20@04DQD10@DE00<1DQD010425@080AEB5E8EDP46DP040E81DPD1
;P000`40000500030@000040000S00030@00028000@15@4118l00`6?0006
0@@000<100001@030@0708l0S`2?0@02S`8100<E0AD00aD0505BDU81DP5B
0E81DP5B0E81DP5B0`400e810@03DP030ADE008E00<15AD011D20@03SaD1
00LE1@435@030E9B00AB00<1DP401P4_00030@0000D000<100000@0002@0
0P4S008100<E0Hl00hl04P6?08l00@2?08l0S`0108l0S`8100L0S`4108l0
00811Hl20@045E8E0@AB0P400e810@0=0@04DP5B0@AB00D1DP41DP020@06
DQEB5E8E0`4021EB5E8EDQD1158B0C4000<1000010000`40000100009P00
0`40000Q00@10hl01`40S`2?00401`0010400@4600030@0100J?00<15Hl0
0P400aD1DP03DP0<0E81DP5B0E81DP5B0`401U810@5B0@AB0`45DP030ADE
008E0P42DP8111D00`5BDP04DP8100UB0E81DP5B0E80104d00030@0000@0
0@410040000W00030@00024000<1S`400`4038l108l0S`0108l0S`@100X0
S`2?08l0S`011Xl00`4E5@035@<10U80105B0E8G0@03DP4100EB0P400aD1
DP05DP8100<E0E801E820@05DP5B0E80204f00030@0000<00@410040000X
00818P020@03S`4000`110020@@00P4018l00@43S`070AF?5HlE0@035@X1
00EB0E81DP030@03DP4100<100MB0@41DP5B00811E820@UB1043DP8100UB
0E81DP5B0E80104g00030@0000<00@410040000Z00030@00024000`1S`41
S`0108l0S`020@09S`2?08l0S`6?008100T0S`2?08l1S`401AD01`5B5E8E
DP4015800`5B0@0D0@03DP5B00810U830@03DP4100EB0P400e81DP070@03
DP5B00L1>P000`40000200410@010000:`000`40000Q00060Hn?0Hl00P45
00030@0000@00P402Hl0S`2?08l0S`030@045HlE0@HE00<1DU800U820@07
DP5B0E81DP030@03DP5B00<100UB0E81DP5B0E800`401E81DP5B00<100UB
0@41DP5B0E800`400e81DP080Cd000D100000@020000;0000`40000Q00@1
00V?08l1S`2?08l00P401`2?0@40S`000P4018l0S`020@>?10401QEB5E8E
0@EB00@1DP5B4`400e810@050@05DP5B0E801@401E81DP5B00h1?`001040
00420000;@020B<01@400hl1000200D11`020@03006?00F?00<15Hl00`42
5@030E9B009B01@1DP5B0E81DP5B0E81DP5B0E81DPL100=B0E800`400e81
DP030@05DP410E800`401E81DP5B00<100AB0@41@@00104000420000;`00
0`40000R00030@0100D100F?08l0S`020@0608l0S`2?0`46S`030ADE00<E
1@42DP8100=B0E80=05400030@010080000`00030@0002<010400`010@06
00810P020@03S`2?00<10Xl0206?5HlESaD111DA0@03DP5B00<100]B0E81
DP5B0E81DP030@05DP5B0E800`400e81DP090DL000<100400@00034000<1
000090040@07S`4108l0S`040@0808l0S`2?08l30@HE00P15E8EDQEB0@EB
0P400e81DP0Z0DX00P410000<P020BL02044008100F?08l0S`020@:?0`40
0aF?0@065@030E9B00AB00H1DP5B0E830@09DP5B0E81DP5B00D100MB0E81
DP5B00D100=B0E800`4015810@5<00810@0003@000<100009P030@03S`01
008100@0S`2?0P400`2?0@07S`D100EB5E8E0@06DP8100EB0E81DP0S0Dl0
0P410000=@000`40000X00810`030@<01046S`050HlESaD02043DP040E81
DPL100=B0E800`401E81DP5B00<100MB0@41DP5B00<100=B0@400P5=00@1
0`0003H000<10000:@020@03S`2?00@100@0S`2?1042S`030ADE00DE00D1
DQEB5@070@=B00P1DP5B0E81DQ4100=B0@400P5<00@11`0003L00P4[00<1
10030@0508l0S`001P4011F?5@485@030E9B00EB00@1DP5B2@401E81DP5B
00D100AB0@41BP040@/0000i00030@0002/010400`2?00020@04S`010@F?
20401AEB5E8100=B2045DP<100=B0@400`42DP@1B@040@l0000j00030@00
02X000<100000`0:0@F?00D15HlES`080@DE00<1DU800U880@03DP4100<1
B@040A<0000k00030@0002P000<100002@0>0@DE00@1DQEB2P400aD10@06
0DX0104G0000?0020BP000<100003`030@F?505>00@16`0003h000<10000
9@000`40001e00@17`0003l000<1000090000`40001a00@18`0004000P4T
00030@0006d0104W0000@P000`40000Q00030@0006T0104[0000@`000`40
000P00030@0006D0104_0000A0000`40000O00030@000640104c0000A@02
0Al000<10000G@040CL0001700030@0001`000<10000F@040C/000180003
0@0001/000<10000E@040Cl0001900030@0001X000<10000D@040D<0001:
00816P000`40001=00@1A`0004`000<100005`000`40001900@1B`0004d0
00<100005P000`40001600<1C`0004h000<100005@000`40001200@1DP00
04l00P4E00030@0003h0105F0000D@000`40000B00030@0003X0105J0000
DP000`40000A00030@0003H0105N0000D`000`40000@00030@000380105R
0000E0020A0000<10000;P040FH0001F00030@0000d000<10000:P040FX0
001G00030@0000/000<100009`040Fh0001H00812`000`40000S00@1LP00
05X000<1000020000`40000O00@1MP0005/000<100001`000`40000K00@1
NP0005`000<100001P000`40000G00@1OP0005d00P4600030@0001<01062
0000G`000`40000300030@0000l010660000H0000`40000200030@0000/0
106:0000H@001@40000100T0106>0000HP020@03004000@0106B0000I002
0@0300410081UP0006D00P6J0000
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{257, 220.812},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Chapter 12: Barnsley's Fern", "Subsection"],

Cell["\<\
bf1 = AffineMap[ -2.5 Degree, -2.5 Degree, 0.85, 0.85, 0, 1.6];
bf2 = AffineMap[ 49. Degree, 49. Degree, 0.3, 0.34, 0, 1.6];
bf3 = AffineMap[ 120. Degree, -50. Degree, 0.3, 0.37, 0, 0.44];
bf4 = AffineMap[ 0. Degree, 0. Degree, 0, 0.16, 0, 0];\
\>", "Input"],

Cell["\<\
fern = IFS[ {bf1, bf2, bf3, bf4}, Probabilities -> {0.73, 0.13, \
0.11, 0.03} ];\
\>", "Input"],

Cell[CellGroupData[{

Cell["ChaosGame[fern, 10000];", "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002W0001I@P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6HcojL0002W0000Y`000:L0002W0000Y`000:L0002W0000Y`000:L0001<
0081F@0004d000<10000E`0004`00P5I0000C0020ET0001<0081F@0004`0
0P5I0000C0020ET0001<0081F@0004`00P5I0000C0020ET0001<0081F@00
04`00P5I0000C0020ET0001<00<1F00004`0105G0000C0020@03004005H0
001<00810P020ED0001<00810`020A<00`4n0000C0020@<0104B0081?P00
04`00P4400@13P030@0400410@@00P4f0000C0020@<01P4<00@100@00@41
0P020@0400400081<P0004`00P44008100@00@412@070@03004100<000<1
00400P4010010@4`0000C0020@D01`4800050@010@000P48008100<00@40
0P4_0000C0020@L000<100400`4600810P001040004900P1;@0004`00P40
0`010@04008100@00@411`040@<01@4500T1:`0004`00P4010010@020@80
00D100000@05014100<00@400P400`010@030B/0001<00810P050@L01P40
0`010@020@030041008100<00@401`400`010@030@03004102P0001<0081
00D00@4100040@800P4200D10`020@03004100<10`070@03004100L19P00
04`01`400`010@030@03004000801@4200P11@060@030041008100@00@41
9P0004`01@400`0100050@H0104200h100<00@000P4700819P0004`00P42
00<10P020@T010400`010@050@030041008100<00@000`000`4000060003
0@0002@0001<00810`020@03004100D00P4300@100<00@400P030@80104e
0000C0020@8010400`010@040@03004000<01P46008100D00@4100040Bl0
001<00810P040@800`400`010004008100<00@400P4700030@01008100<0
0@401@4/0000C0020@<000<100400`000`40000700030@0100<11`0=0B`0
001<00810P020@<0104:00D11`020@8010400`010@030081:00004`00P42
00T12@040@03004100H02@400`010@0200@19P0004`00P4200/110020@80
10400`010@0400<100<00@400P400`010@0:0B@0001<00810`040@030040
00<100<00@401@4200<100<00@00100:0@0500410@00204Q0000C0020@D0
00<100000`020@8000<100402@4200@10`000`400@0?0@0300400200001<
008110040@D01`400`010@040@801043008100@00@00104010010@020@03
004100800P4N0000C0020@@01@4500040@0100<100<00@400`4300811@00
0`40000300H100H00@41004300030@0001`0001<00811@040@D00P401001
0@020@03004000D020401@010@40008100@00@010P020@D00P4M0000C002
0@H00P4300<100<00@400P4200040@010@H01@4010010@020@80104;0003
0@0001/0001<00811`040@030041008100<00@400P400`010@030@<01P40
0`010@0200030@000080104200818`0004`00P4800<100<00@400P4200<1
0P020@03004000800P4010010@4200040@0000X100<00@008P0004`00P49
008100@00@4110020@803`4400H100<00@401P4P0000C0020@L01@400`01
000200@10`0010400@040@04004000811@040@03004100L100<00@407@00
04`00P48008100<00@400`4200<12@040@<01@4200H110060Ad0001<0081
2@050@04004000810`020@03004100@00`4300D10P050@800P400`010@05
0A/0001=00030@0000L01`4300040@0000810P020@03004100<110020@03
004100810P020@800`4200H16P0005P00P4300811`000`4000020@801045
00L11P020@03004100L1600004`00P4;00810`000`40000200X100@00@41
1@050@03004000T00P400`01000200030@0001H0001=00030@0000P01045
008100<00@400P400`0100050@L01043008110050Ah0001;00@12P050@@0
00D100000@0500040@01008100<00@400`040@<0104200<17`0004T01P4>
00030@0000D00`4400H10P000`40000300811@0;0A/0001800@100<00@40
3@020@L00`4300D100<00@000`020@<00P43008100@00@40204I0000A`04
0@800P4>00030@0000@00`4500040@0000/100D00@4100070@03004100D1
600002d00P4400@13`050@800P4=00<11P020@P00`400`010@020@030041
00<100@00@400P401@010@4000@100<00@400P4F0000;P0;0@`01P420081
3P030@H0104600030@0100@10`0010400@020@<00`400`010@040@030041
00815@0002L00P4200`100<00@002@070@<00P4@00030@0000<01@420081
1@050@H00`400`010@020@800P400`010@0200@1500002@00P4200<100<0
0@401@401@010040008120080@<00P4A008110001040004200@11@040@03
004100<00P4200030@0100X00`4D00009@000`400@080@03004100811000
0`40000500D100@00@010`020A8000<100002@0010400@020@03004100H1
10020@H00`4700030@000180000W00<100<00@4020400`010@0:00d16@03
0@D00`4200H11P000`40000200H10P020AL0000P00D10P060@03004100D1
00<00@400P4010010@4500`16@030@D00P4400@100<00@400P4800030@01
008100@00@415`0002401P4010010@090@<000<100401P4200D100D00@41
00030AX000<1000010020@<0104200@11@020@04004100L15P0001h00P40
0`010@070@800`400`010@020@@020400`010@040@80204H00811P020@<0
0`43008100<00@4010020@04004000<100<00@400`4C000070050@050041
0@00104300<100<00@00104200H10`000`400@050@03004100D160000`40
0005008110030@<00`4400@10`080A<0000J00X10`020@030041008100<0
0@401P4300@11P020@0400410@801`4@00<130020@@00`4200<11P030@D0
1@400`010@0A00006@040@<000<1004010020@800`4200030@0100<100<0
0@40104300810`020@@02@4=00H10`030@H000<100000`00104000040@H0
0P4200810P030@<000<100003`0001X000<100001P020@<0204400810P05
0@@000D1004100030@<02@4;00L10P050@800P4500@10`030@<00P401001
0@4200030@0000<15@0002@000D1004100050@04004000@100<00@401047
00030@0100X100<00@400`4800D10P00104000050@80104300<10P040@<0
0P4200<100<00@400P030A@0000Q00<10P080@D00P400`010@050@D00P43
00@100L00@410040008100@00@4120030@T01P400`010@0300<10`030@@0
00D1004100040@<01@4A000080050@03004100H11`040@800P4600040@00
00D100<00@4010060@T000<1000020050@800P4300<100<00@400P440081
00<00@000P030@<01@4@00007@030@03004100`11`030@D00P4300810P05
0@03004100H01@4500@100D00@41000>0@03004100<10P000`400@020@80
104200D10`050@l0000N00<100@00@002P400`010@020@@00P400`010@02
00030@0000L100@00@000P400`010@020@D000<1000020400`010@0:0@03
0041008100@00@400P43008100<00@000`400`0100080@03004100<13`00
01`00P400`010@0:0@0500410@001@44008100@00@000P4200@100<00@00
1P400`0100020@H01@401@010@4000@10`060@800`4010010@020@<01`44
00/14@0001L03P400`010@0200030@0000@030400`010@020@0500410@00
0P42008100<00@400P080@801@400`010@090@03004100<10`001@400040
008110000`400@070@030041008100<00@400`4A00005P030@03004000T1
0`040@04004100@10P030@0400400@8010400`0100050@<010401P010@01
008110040@0500410@0010400`01000300812@000`400006008100<00@40
3`4>000050060@0500410@0010400`01000300030@0100801@42008100<0
0@000`401@010@4000810`040@<00P40100100020@P01P4010010@4200<1
70040@03004100810P050@h0000E008100<00@400P00104000030@D02`43
00X10`050@0400410@800P400`010@030@@00P4300D10P020@0400410081
00<00@406@020@@0104400813@0002800P400`010@0200<100<00@400P47
00D100<00@000`060@03004100800P401@010@4000<10`000`40000200D1
1@001@40004000D13P020@03004100800`4400H10P040@/0000J00<100@0
0@410P020@03004000<01P42008100<00@400P040@H000<100400P400`01
0@02008100@00@410P020@H00P4200<11P020@03004100D10P020@X000@1
00410`040@<00P4200<100@00@412`0001/00P400`010@060@H01@400`01
0@020@03004100D11P020@03004100<10P020@800P4300030@0000D000<1
00400P4800X10P020@`000<100000P0010400@040@03004100@13@0001H0
0P400`010@020@8000<10040104500/100<00@401`4200T10`020@050041
0@00104500H100<00@400`070@03004100H100<00@400P47008120030@03
004100H12`0001H00P4200<100<00@402P4200@100<00@4010400`010006
0@800P4010010@46008100D00@4100060@06004100400`4200030@000080
10400`010@060@030041008100<00@001`000`4000070@030041008100<0
0@400P000`400009000050040@<020401@010@4000<10P050@800`400`01
0@060@<01@4600810P090@801@4010010@4200@10P000`400@0=0@030041
00H00P4200@100<00@000P030@03004000d0000C014100<00@4010400`01
0@040@80204010010@4200<100<00@001P020@@00P4300030@0000H10P02
0@801042008100<00@001P400`010@020@8000<100001@000`400@030@80
1`460081200001005@400`010@020@<000<100400`4200H120050@H00P44
00811@030@801P4300D100<00@400P400`010@0200030@0000813P030@80
204600030@0000H0000?00T100T00@4100400@002@400`010@020@801@40
0`0100050@D00`400`01000500810`040@D01P401001004300L100<00@40
0P030A@00P4300030@0100P12`0000l00`400`010@0400@11P000`400@02
0@06004000400`4200<100@00@40104500<120020@@00`4200T100@00@41
0`050@06004100400P4010010@4200814@020@800`400`010@040@X0000@
00811P070@D01P42008100<00@4010000`4000060@@0104800811P070@03
004100H110040@8000<100001@401@010@4000@13P020@800`4200D12P00
01D00P400`010@050@H00P4010010@4200040@0000811@040@L000<10040
20020@H00`400`010@0300810P080@030041008110040@03004100P13@00
0`4000030@0500410@000`4900005@080@03004100800`400`0100050@<0
0`400`010@0200@120020@P00P4600810P020@800`4500040@0100<10P04
0@801P400`010@070@d01`4200@120000140704400810P001`4000010040
1`030@P00P4600L10P020@T00`4300D100<00@400`4010010@060@/00P40
0`010@030@801@4800004@020@03004100<100<00@4020400`010@040@03
004000810P020@<00`4:00030@0000L00P4700H10P020@800P400`010@03
00<10`060@0400410@800P4200H12P000`40000300L100@00@411@0000h0
1P401P010@0100<10`020@H0104300050@0000400`050A800P4800H10P00
0`4000020@040041008100<00@4010060@H010401@01000101000`400`01
0@020@03004100D0000>00H100@00@410P020@03004100@10P070@<00`46
00040@010A<000<100001P030@03004100H02P4400@100<00@000P4400<1
5P020@03004100810P000`400003000030020@03004000<10P020@030041
00`100<00@400P4400<16`020@T00`400`01000400<100<00@001P4400<1
10090A@00`4200030@0100811P0000d000<1000010020@030041008100<0
0@400P401@010@4000L100<00@400P020@D00`4C00812P040@H000<10000
0`020@8000<100000`030@@010400`0100030A<01P400`010@0600005@00
1@40000100@00P4200810`060@030041008000@100000P400`010@0B00@1
30000`40000300<10`030@H00P4010010@4300@10P060A800`400`010003
0@D0000@008100<00@40204200<100<00@400P400`010@030@03004100H0
0`4C00D14P030@<00`4010010@060@0400410@8000@100410P030@040041
0A4000<100000`020@D0000?00@100<00@401`4300L10P000`400@040@L0
0P4B00H130020@<00`4500030@01008100<00@400P400`010@040@@01040
0`010@040A40104800003@070@8000<100401P4300<10`020@@000@10041
5`050@03004100d00P43008120030@0400410@800P401@010@4000<100<0
0@400P0010400@020A0010400`010@0500002`060@040041008100<00@40
0`400`0100050@@00P4600030@0000D00P4>00@10P020@h000@100000P40
0`010@0200810`000`400@020@03004100<01P4:00030@0000l01P450000
2@060@03004100D10P020@03004100P10P030@<00P44008100<00@40104:
00@100@00@000P4>00810`001040004200810P020@801@4400<110020@<0
0P4F00@1100000T00`4200<100D00@400@0400`10`020@<00P4300X12P04
0@@00P4?00030@0000@00P4200060@0000401@4600030@0000<01@400`01
000D008100<00@40100000X000<100002@4300X100@00@00104300@10P08
0@X00`400`01000200<15@030@@00P4200D100@00@412@060A@00`400`01
0@0400002`0;0@<00P400`010@040@04004100<100<00@000P400`010@0:
0@03004100T01P4010010@4E00<110020@<00`4300@10`020@@00P400`01
000D00050@000040100000/0304200<100<00@4010400`0100020@D000<1
00401@400`010@0<0@<00P400`0100020@03004101H00`44008110030@80
0`4300<110040@800P4@00811`0000T03`4200H100@00@410`000`400003
0@8030400`010@060@<0104200H15P000`40000300810`030@0400410@D0
0`4500810`000`40000?00811P0000X00`4200030@0000H10P060@040041
0@H01@4010010@060@03004000801P4400D100<00@40104>00<110020@@0
0P4400040@0000<10`040@@00`4F00030@0000@0000;00030@0100811@0:
0@800`4400T110050@03004100801@44008100@00@40204:00H10P030@D0
00<10000104200<10P060@@00`4F0081100000H00P4400X10P040@030041
00800`4010010@050@03004100P100<00@400P4200@10P020@800P4200X1
2@060@<0104200810`030@<00P4300030@0100H100<00@400`4D00030@00
0080000700030@00008020400`0100050@8000@100001@42008100@00@00
0`401P010@400@800`400`010@020@@00`400`010@0200D100<00@400P47
00D100<00@000`090@0400410@800`43008100<00@001@400`010@040AL0
000800`10P080@H00`4900<100@00@410P040@03004100<11@000`400@08
0@04004100<11P030@P01@400`010@0200<10P000`40000300<10P050@03
004100<15`0000T000D1004100070@801`4A00P10`020@03004100@12003
0@0400410@<000<100400P4500L100<00@403`4200810P020@8000<10040
1@4010010@4I00002`020@@01P400`010@040@h02P4500@10P0010400@42
00810P030@80104400<10`050@03004100P100<00@401@400`0100020081
00<00@400`4200@100<00@400P4I00002@020@030041008100<00@401`40
0`010@0=00d11@040@@000<100001P4300L10`000`400@030@03004100D1
0`050@0700410@0100020@<000<10000104200/15`0000P02@402@010@01
00400@0200030@0000P00`400`010@0>0@<00P400`010@0500<100<00@00
10400`0100060@8010400`010@070@<00P4800030@0000T00`400`010@06
0AL00006008100<00@401P4300811@020@T0304200<100@00@410P060@03
004100<000@1000030400`01000200H100<00@400P400`01000I00030@00
00802@4D00001@040@0300410080204600030@0000L0204010010@020@@0
0`400`010@030@04004000<10P020@04004100@100<00@400P4500@100<0
0@000`070A400P4010010@020@03004100H100<00@004`0000H020400`01
00040@800P4900@100<00@401043008100<00@001@4300030@0100D10P02
0@03004100<100<00@401P4700D11@090@800P4;00030@00008100<00@40
2@4E00002@080@0400400@800P4600T100<00@400P4300<100<00@401040
0`010@060@030040008020400`010@030@0400410@D01@4600030@0100H1
0P020@X00P4200040@0000D10P030A@0000600<100<00@000`400`010@02
00810P000`40000500030@01008100<00@400P0010400@020@0300410080
104300P11@070@03004100<10`000`40000400@11@060@0500410@001`47
00050@010@000`400`0100040@03004001<0000400D10P070@<000<10000
50020@03004000<01@400`010@0200030@0100<110070@801@400`010@02
0@<01P4600<100<00@403@45008100@00@400`4300030@0100<00P4A0000
10030@03004100T14@030@030041008100<00@4010090@801`4200L10`0A
0@03004100<00P400`010@020@03004100P10P000`40000400040@010@80
104800030@0000l0000500P100H00@41004>008100@00@410P001@400@40
008110070@04004100@100<00@000P040@H000<100401`400`0100030@05
00410@000`4400030@0000<100D00@000@0=00040@0000<100<00@40104C
00001@030@0500410@00104A00030@00008100<00@402@4300@100<00@40
10400`0100020@05004100401P020@<000<100000P040@04004100<10P09
0@0400410A@02@400`010@0B00000`020@03004000<100<00@400`4?0081
10020@03004100P100@00@400P4200H110000`4000050@@00P4400811002
0@030041008000@100001P4010010@070@l00`4200810P040A8000040003
0@0000800P4200030@0100l0504200040@000@<0204400<100<00@000`02
0@8010400`010@020@03004100D10`040@D0304;00030@0000D100<00@40
0P4A000010090A40304010010@050@0400410@800P4300H10`040@H00P43
00030@0100D100L00@41004000D100<00@400P4400H100<00@40104900P1
00<00@400P4A00001@000`400@030@0400410@d01@400`0100050@D00`40
100100040@03004000<01@43008100<00@001@020@D00`400`010@020081
10000`400@030@03004100810P070@03004000@12@000`400@030@801`4>
000010030@8000@100000P4=008100<00@400P050@H01P44008110040@H0
0`4600811@060@0400410@T00P4200T100<00@401`4=00<100D00@410002
0@h0000300@100<00@4010000`40000<00040@0000H120070@<000<10000
0`030@H00`4700811@040@<00P4010010@040@8000@100001@4500050@01
00400P000`40000<008100<00@400P4@000010070AH03@4200<100<00@40
20020@03004000H000<100001P020@H00`4400050@000@000P400`010@02
0@<01@4600814P040@0400400A00000400<100@00@014`0J0@800P4200@1
4@000`40000500@11@020@03004100@110040@<01@400`010@0@00@10P03
0@h0000400D15P090@03004100810P070@030040008000<10000104I0081
00<00@0010020@<000@100411@030@8010400`010@020@03004100l00P43
00813P0000<01P4C00@10P030@03004100D100@00@40104300811@020A40
0P4800<110030@<00`4300D110080@0400410@l0104@00000`020@030041
00814`030@03004100<100<00@40304010010@020@<00`4@00<12P000`40
000300810P060@801042008100<00@401P400`010@0?00H13P0000<00`40
10010@4E00030@00008100<00@401`400`010@040@8000@100010P040@l0
104?00<10`000`400@080@801P401@01000100<00P4>00H13@0000@01040
0`01000E008100<00@400P000`400@020@0500410@001@4800030@0000h0
1@4;00810`020@<00P400`0100040@03004100800P400`010@06008100<0
0@003P020@0400410@`0000600815@020@03004100H10P060@801P4F00<1
00<00@4030000`400003008100<00@401@030@03004000800P4400810`00
0`40000?008100@00@41300000L000<100004P040@03004100D10`050@03
004100@000<100001P020@/0104200812`020@D000D1000100020@801040
0`010@0200030@0000<000<100000P4B00040@000@d0000400<14P0A0@03
004100<10P020@/01@4800D10P020@`000<100000P030@@000@100001P45
00810`030B<00005008140070@030041008100<00@001@400`010@020@80
0`400`010@0300T11`030@03004000@14P020@<00`4300L10`030@<00`40
0`010@0?00813P0000H000<100003P020@03004100D100@00@002P4200@1
0P020@802@4800<100<00@400`4C00810`030@800`4010010@4400811002
0@8000<100003P020@d0000H00030@0000810P030@8010400`010@040@03
0041008100@00@403P4200810P030@03004100@13@020@@000<100000P02
0@<000D100000@0300@11@020A<000<100002`0001X01@400`010@030081
00@00@4010400`010@0400030@0100<100@00@400P400`010@050@<02P4=
00810P030@@000<100000`4700@10P070Ah0000I00/100@00@400P420081
0`000`4000020@<010401@010@0100801P4300P100@00@412P030@<00`42
00810`020@800P4300@100<00@401`4M00005`0=0@03004100<10P030@D0
1`400`010@030@@0104010010@030@03004100P11@050@D0204200810P00
0`40000200040@0000@100<00@400P4M000060030@060041004010400`01
0@020@<00P400`010@060@03004000800P400`010@020@03004100810P06
0@03004100L11P030@<03@40100100020@03004100D00P4300817P0001D0
0P4200L100H00@400@020@04004100810`030@040040008100D00@400@02
00<100@00@411@000`400@020@0400410@801046008100H00@400@030@80
0`400`01000400030@0000@100<00@400`4200<1700001H000@100001`40
10010@030@8000<100000`4300030@0000<01P42008100<00@400`4600@1
00<00@4010080@03004100<10`040@03004100<00P4600030@01008000<1
00400`4010010@4K00006@080@800P400`01000700030@0000D0204300@1
00@00@410P020@030041008100<00@40104300030@0100810P040@030041
00800P4700030@0000`01`4K00006P000`400@090@l00P400`010@050@@0
1`4200X100<00@001@400`010@040@030041008000<100000P4=00811002
0@03004100D16`0001T00P4300P100<00@402P0@0@800P400`01000300/1
00H00@41004200D10`090@800P4800030@0000<000<100400`400`010@0K
00005`020@030041008100<00@401@4200030@0000L02@401@010@4000H1
00@00@400`4200@100<00@400P4200030@0000@01@4300@100@00@410P02
0@800P4400D100<00@401`4K00005@020@03004100@10P0010400@020@03
004100L0104010010@050@80104010010@070@04004100T120030@@01P43
00@100<00@0010020@03004100<100H00@41004200815`0001H00P401001
0@060@H000<100000P0:0@D01@4300D100D00@000@02008100<00@001P47
00@1100>0@03004100@000<100400P4400H100<00@005P0001@01`4200T1
1P060@0400410@<00P4200@10`060@<01P4200T10P020@03004100810P0?
0@8000<100001@000`40000300L1600001D00P400`010@060@0400410081
1`030@06004000400`40100100040@04004100<100<00@400`050@801`40
100100040@04004100<100<00@000`401P010@400@d00P4300030@0100<1
600001H00P400`010@050@8000<100002@030@D00`4300P100<00@401040
0`010@030@@00P400`010@020@801P4010010@060@03004100801P4<0005
0@010@001@4H000050020@04004000H140080@D04@400`010@0400810`00
0`40000200D10P000`4000050@802P4;00d15@0001@02P400`01000>00<1
00<00@400P400`010@020@800`4200H10P000`400@040@<00P4200<100<0
0@401@4400L10P060@03004100@120050@800`400`01000D00005@060@80
0P4A00`10`020@<01P4500030@0100<00`4200L100<00@400P020@030040
00H100<00@400P401@010@4000@130050AL0000F00H10P000`40000:00<1
0P0<0@801@4200D11@020@D00P4400@100@00@410`00104000020@030041
008100@00@410P030@0400400@/00`400`010@0G00004`020@<00P400`01
000=00X100@00@400`44008100<00@000P040@H000<100000`020@<01@42
008100<00@401P4200<11`020A000`430081500001@02@4;008100<00@40
0P040@D01@4300810`040@@00`46008110040@800P4200<100@00@410`02
0@@01@400`010@0?00@100<00@004`0001D01@400`010@0;008110050@D0
1`4200030@00008000<100401@020@H00P4600@100<00@00204400<10P05
0@800`4>00<15P0001@01@4300030@0000X000@100001@400`010@0;0@80
0P4300813P000`40000400@11000104000020@<01@4300T13P060A<0000C
00L14@040@03004100<100@00@401`4300060@010@013@020@L000<10040
0`020@800P4010010@050@03004100H100<00@003`000`400@020A<0000D
00@100<00@003`0=0@03004100@10P020@@00P4=00<13@020@<000@10041
0P020@04004100D110020@h00P400`010@0C00005@040A000`401@010@40
00<100<00@400P070@03004100@00P4;00D12@020@8000@100000P401001
00020@8000<100000P4200<10P020@h000@100014`0001@01@4A00810P0:
0@801P4200030@0000<000<100002@050@X000<100000P040@@010440004
0@0000810`000`40000=0081500001<01P4B00<100H00@400@060@030041
008150030@03004101000`400`010@0200D110030@<00P400`010@0=0081
4`0001@00P4200030@0001401P4300D100D00@4100020@H00P4900<10P02
0@l00`4200<10P040@@00`4300810P000`40000<00030@000140000E0003
0@0001400`400`010@0:0@<00P4200030@0000<01@4600@100@00@414002
0@<00`400`010@030@@00P4400D18@0001H00P4B00T100H00@41004200<1
1@080@D02P4@00030@0000800P400`010@0200040@0000@100<00@400P04
0B00000D008100<00@003@030@8010400`010@080@800P4200810P070@H0
2@4<00810P020@<00P42008100<00@400P020@03004100<100<00@400P4P
00005@020@h02P4010010@020@030041008100@00@402`400`010@040@80
0`400`010@040@P0104300L10P020@030040008000@100000`4200818@00
01H000<100003@001@40004000<10`00104000040@03004100@100<00@40
1P4200D10`020@030041008100@00@411@040@D020400`0100070@801040
10010@4O00009P0:0@030041008100<00@400`000`400@030@04004100@1
0`030@03004100<10P090@@00P400`010@050@0500410@000`4200070@01
0@0100060@03004101l0000W00T100<00@400P4200030@0000801P4200<1
00D00@4100030@8000<100400P400`010@020@03004100<100<00@402`40
0`010@0300030@0000P000<100401@4O00009@040@03004000@10P040@@0
1P401P010@400@<00P4200811P0<0@04004100D110000`40000:00810P02
0@03004100D17P0002H02@42008100<00@400P020@0400400@801P4400D1
0`060@0500410@000`4200<100<00@00104200<10P020@L000@100002@4N
00008`020@80304600030@0000@01P4400H10`020@03004100P10`050@<0
0P4010010@42008100<00@4010080@0400410@800P4K000090000`40000<
0@/030400`0100050@8000<10040204500@110050@801`4300@11@060A/0
000W00/100<00@402@090@030041008010401@010@4000H100@00@411`02
0@<03@400`01000300030@0100@01P4L0000:0030@0400410@8000@10001
1@060@03004100<100@00@410P040@<000D1004100060@03004100801044
008100D00@4100030@03004000`0204K00009P060@03004100<00P4300D1
00@00@410P070@@0104200D10P070@801P400`010@0:0@800P4:00<100<0
0@40104I000090020@03004100H11000104000090@0500410@00104200@1
00<00@001P42008100@00@410`040@03004000P100<00@40204800810P03
0@03004001P0000S00H100<00@400`400`010@0600D100H00@41004300D1
00<00@400`4200@10`020@8000<100000`030@@01@4300H100@00@412`05
0AX0000T00T100D00@000@0700<10P040@80104010010@030@04004000@1
0`020@800P4010010@030@<04P4;00H16P0002<02P4<00@100@00@401@40
100100060@@00`4300810`050@03004100@000<100401P4010010@030@d0
0`4L00008`060@0400410@d00`400`010@050@801P4010010@4300811@00
104000050@04004100L10P020@<01@4?00@16@0002@01@4200030@0000P0
0`4200L100<00@400P020@04004000@10`020@D00P4300@100@00@401`43
00<10P040@800P4;00H15`0002@0104>00l10`020@<00`4400811@020@D0
0`400`0100030@03004100801@4500D130000`400@020AL0000R008100<0
0@400`4:00@10P030@@01P4200030@0000800P4500030@0000@000<10000
0P040@<00P400`010@0400T100<00@000`4<008100<00@005P0002<01@40
0`01000:00040@0100H100<00@401@43008100<00@4030020@D000<10040
0P030@8000D1004100040@06004100400P400`010@0=00030@0001L0000S
00<100<00@000P4=00l100D00@400@0200030@0000T0104:00810P020@03
0040008100<00@001P001@40004000812P040AH0000R00D10`000`400008
00T10P000`400@040@800P4200<12@050@L00P4500@10P050@<00P430081
00<00@002P000`400@0F00008`020@0400410@`00`400`010@070@030041
00@100<00@000P020@T00P400`010@0800030@0000800`400`010@0200@1
0`030@<000<10000900002@00`400`01000;00d100<00@40104?00<100<0
0@403@020@800`4010010@4300@100<00@40104S00008`050@h01P401001
0@4400D11P020@H01`4=00810`020@03004100D000@100401`4R00008`05
0A001P400`010@020@800P400`01000300D110050@0400410@X00P400`01
0@0300030@00008110020@800`4010010@4R00008`020@8000<100002`0>
0@800P4200T11@090@L0104201D10P020B40000T00<13`0=0@0400410@<0
3@401@010@4000H11P020@030041008100D00@4100030@030040008100<0
0@001`4Q00009P000`40000;00H100<00@401P4200040@0000P100<00@40
0`42008100<00@401@4400P10`001@40000100@00P4200L18@0002@00P4<
008100<00@000`4200810P000`4000020@0500410@0010401@010@4000<1
00<00@401`400`010@0:0@03004000`000@100001`400`010@0M00009@00
0`40000;00d110070@D00P4010010@4200d100@00@401044008100<00@40
20090@8000<100006`0003@0204010010@4600D11P050@802P4400D100D0
0@4100030@03004100<10`050@<01@4N0000<P050@0400410@@000<10000
0P4500D10`050@<020400`010@0300@10P0<0@@000<1004010050Ah0000c
00/11@000`40000200/100<00@400`400`0100080@@00`4400X130070A/0
000e00T12@080@04004100@100<00@40104010010@040@0400410@800P42
00<100@00@000`4<00@100<00@006P0003H0104010010@020@L00P401P01
0@0100<10P030@801@400`010@030@03004000<10`060@03004100L12@04
0Ad0000e00H100D00@000@0300<10P000`4000060@800`4300D100<00@40
0`4200D10`040@802@4800D17@0003400P400`010@050@T00P4400<100<0
0@400P400`010@030@800P4300810P080@04004100D100D00@4100030@X0
1@4L0000<@0<0@D00P400`01000200<10P020@040040008100<00@001042
00810`060@800P4200030@0100810P040@d0104K0000<0070@0600400@01
1P030@03004100@10P000`4000040@@00`4300810P040@04004100D10`02
0@801`4;00<16P000340104010010@4:00@100<00@4010400`010@030@04
00410@@000@100000P4300@100<00@401@400`010@020@@00`400`01000:
00<16P0003001P400`010@0;00L100<00@400P030@03004100810P020@@0
0P4400<10P020@0400410@800P4200810P050@/00P4J0000<@020@030041
00X01P400`0100050@800P43008110000`40000200811@020@800P420004
0@0000810`00104000040@03004100T00P4I0000<P030@X0104010010@43
00H100<00@400`4:00812P000`4000020@801@4200<10P020@03004000T0
00<100005`0003000P4010010@4:00040@0000X100P00@4100400@X00`4=
00<100<00@400P4200<10`040B<0000a00L12P090@800P4200810P020@L0
1@4;00810P020@03004100<00`4400<18`000340104200030@0000H03040
0`010@020@030040008000<100001@050@/00P42008100<00@4010020@04
004100<18`0003001P4:018110020@D00`4010010@48008100<00@400P04
0@<010400`010@040B80000a00D12`040@030041008100<00@000`400`01
000200@110030@800P4700<10P070@@02P4R0000<@040@h01@4010010@42
00810`040@03004000<100D00@4100040@H000<100000`400`010@040@<0
0P4010010@030B80000a00@12`030@03004100L10P001040000:0@030041
00P10`030@800P4200050@00004010000`4000050@800P4N0000<P000`40
000:00`100@00@000P400`010@040@0500410@0020400`010@030@030041
00811P020@H010400`010@040Ah0000o00P100@00@410P070@800`401@01
0@4000T100<00@401`401@010@4000@11@020@801P4N0000<P020@`01042
00D10`060@<01P400`010@080@<01040100100070@X01P4M0000<`000`40
000900L100@00@411@020@03004100810P050@800`400`010@030@@00`43
00<100<00@400P4;00D17@0003h00`4010010@030@04004000811@050@03
004100l100D00@4100070@03004100D11`040Ah0000o00D100@00@411@00
0`4000030@03004100<100D00@4100020@03004100L100@00@410P040@03
0040008100<00@400P4800@17@000400104010010@4800<10P040@800P42
008100<00@000`42008100<00@400P060@8000<100000P4:00040@010A`0
001200<100<00@4010040@03004000802@4010010@43008100D00@410002
0@801`4400813@020A/0001000H11P040@800P42008100<00@000`4200<1
0P020@0400410@800P400`010@020@800P4300<13@000`40000I0000?@06
0@03004100811@020@03004100@100<00@401P4200810P020@8010401001
00030@03004100@100<00@400`4900<16P0003d010400`010@020@030040
00@00`4010010@020@800`4010010@4200810P020@<010400`010@020@<0
0P400`010@02008100@00@4120020AX0000n00D100<00@0020060@030040
00<100@00@4110001@40000100@000@100400P400`010@0300<10P020@80
0`4T0000?`040@P01P400`010@070@03004100L00P4900030@0000<100@0
0@410`020@80104R0000?P020@03004000T000<100400P401@010@400081
0P000`40000700@12@020@800P400`01000200D100@00@418P0003`00P40
0`010@0;00l12@050@T00P4200<10`030@04004000818P0003d00P400`01
0@020@L02@400`010@040@P01P4700@100<00@400P4300X18@0003h01040
0`01000600h10`040@<00`400`010@0600H100@00@400P4200030@0000P1
7`0003d0104900<100<00@00204300D100@00@400P400`010@030@<00P42
00810P001040004400@100<00@400P4O0000?@040@X0204300810`040@04
00410@8020400`010@030@D00P4600<100<00@400P4O0000?P040@T00P40
0`010@060@04004000D10P020@03004100L100<00@40304500040@0000<1
7`0003l000<1004020040@04004100X100<00@400P020@03004100H10`04
0@03004100H12P020Al0001;00@100<00@400P4200P100<00@400`400`01
0@060@802P4010010@4800D17@0003l00P4900T11@000`400@030@800P40
0`010@030@04004100<100<00@400P030@03004100D11`040Ad000100003
0@0000H02@4600P100<00@400P400`010@030@801@400`010@040@040041
00812P000`40000K0000BP080@H00P400`010@030@800P401P010@0100P1
00<00@401P4300030@0002H0001;00<100@00@410`030@0500410@001040
0`010@040@<000<100400P400`010@0:0@800`4800816`0004/010400`01
0@0400810`001@400@4000D100D00@4100020@802@400`010@0200040@00
00@11`000`40000I0000B@070@H00P400`010@0300L10P020@800P4200<1
00D00@400@0200<10P020@0400410B<0001900L11P030@030041008100D0
0@4100020@<000D100000@0300810P000`400@050@801@400`010@0Q0000
BP050@D00P400`010@030@03004100812P020@P01`4200@10P020B40001;
00<11`070@03004100<120040@P00P4010010042008100<00@40104P0000
B`020@X01@4200@11`050@H00P400`010@020@05004100400P050B000018
00H11P0>0@800P43008100@00@4110050@030041008000@100000`400`01
0@020Ah0001900D11`030@03004100D10`030@04004100h10`020@D00P40
0`010@020Ah0001:00812P060@800P4200@100@00@400P400`010@030@03
004100T120020Al0001:00<11`090@8000@100000`4010010@050@D02040
10010@4700030@0001d0001:00<120080@8010400`010@030@800P400`01
0@0400`12@020A`0001;00030@0000P000<100000P40100100060@030041
00801P400`010@030@03004100<100@00@012P000`40000J0000E`020@03
004000@000<100401`401@010040008100<00@400P400`010@020@030041
00d00P4J0000BP020@L02045008100<00@400P400`010@0500810P001040
0@090@03004100<11P000`40000H0000B`000`40000600L10`020@030041
00D100<00@000`4010010@080@04004100P18@0005H0104400810`070@80
0P4200030@0000D100<00@4010400`010@050B00001E00D110040@030041
00H10P000`40000400040@000@801@4200H1800005<01`4500030@010080
00@100010P000`40000200@11P020@0500410@000P400`010@030Al0001D
00D110040@<0104700@110020@03004100<10P000`4000040Al0001G0003
0@0000@000<100400`4010010@4600D110020@<0104300L17@0005D00P46
00/10P030@803043008110000`4000030Ad0001B00H11P060@0300410080
1042008100<00@400P400`010@090@H000@100416`0005<01@4600H10P00
0`4000060@03004000<10`0:0@T000<100006@0005@00`4600P100<00@40
1`4010010@020@030041008100<00@401@4U0000E0030@L00P401P010@01
00H100<00@401P4200<10P020@03004100<00P4Q0000E@000`40000700@1
10060@040041008100<00@001@070@0300410081800005`01`4500030@01
00<100<00@002@42008100<00@40104010010@4N0000G@060@<00P400`01
0@050@800P400`0100030@H02@4N0000G`030@D02P4700030@0000D00P40
100100030Ah0001L00<100<00@401`000`400@030@03004000<00`4500D1
0`060A`0001L00D11P060@L0104600D10`020@03004101`0001M00040@00
0@D01@400`010@02008100<00@40204200@11`030AX0001N00811@090@04
00410@8000<100000`400`010@080@L000<10000600005`01@4500D100@0
0@401P4200L100@00@400`4R0000G@040@D01P400`010@0;0@0400410@@0
0`4010010@4N0000G@030@H04P401P01000100`17@0005h00P4700<10`02
0@0400410@800`4300<100D00@400@0300040@010Ad0001U00H10P090@03
004000<00P4900@1700006H00P400`010@0300<100<00@400P4400811004
0@<01P4J0000IP020@L000<100400P4500@110050@801@4J0000I0040@D0
104010010@020@03004100L100<00@400`4500816@0006D000<100401@07
0@030041008000<100400P401@010@4000@11P000`40000G0000I0050@<0
1@4010010@020@D01P4300030@0000817@0006D0104400@10P0;0@030041
00T17@0006H00P4500@10P060@030040008100<00@400P0010400@060AX0
001V00811P030@800P4010010@020@D000<100001`030AX0001W00030@00
00<0104200P10`020@<00`4500<16@0006h00`4300030@0100@110030@03
004100<11@030AL0001]00<10`050@800P4300X11P000`40000E0000KP00
0`400002008100D00@4100020@@01@400`0100040A/0001]008110040@03
004100@10`000`400@030@800`4K0000K0030@D00`400`010@050@<00`40
0`01000300@1600006d00`4300@10P060@@00P4010010@4300<1600006h0
0P4300@100D00@4100040@H01@4200@15P0007@00`4200050@010@000P43
00/10P000`40000D0000L`030@<01@400`010@0200D100H00@01004I0000
M0000`40000200<100<00@000`4200030@0100<10`040AH0001c00<10`04
0@03004100<10`020@03004100<00`4F0000M0020@<010400`010@030@@0
00<100000`4200@1500007T01`400`010@0300L100<00@400P000`40000B
0000NP001P400@0100D100<00@401@4200<15@0007h03@40100100030AD0
001i00<10`030@03004100810`000`400@070A<0001j00810P030@030041
00<11@060@0300400180001n00<10P050@800P400`010@0200<14`0007l0
00<100000P050@80104200<14`0008<01P4400H1500007h00`400`010@06
0@D000<100400`4B0000O`020@800`400`010@030@03004100810P020A80
002400030@0000D10P080A400023008100<00@401@4200<100<00@000P4@
0000Q0001040004200@10P050@03004000l0002:00H100<00@00104@0000
Q`020@8000@100000P400`010@030A00002800030@0000800P401`010@01
00404@0008h000<100000P4010010@4@0000T0040@03004100813P000940
1@4010010@4=0000T`050@03004100`0002E00@100<00@402`0009P01@4:
0000VP000`400@0:0000Y`000:L0002W0000Y`000:L0002W0000Y`000:L0
0000
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{167.688, 357},
  ImageMargins->{{44, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Appendix A: Random Walk", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(RandomWalk[1000];\)\)], "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003_0000k`P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hconl0003^0@4000000`40003Z00410@0000030@000>X00@41000000<1
0000jP010@4000000`40003Z00410@0000030@0006l00P4500030@000740
0@41000000<10000K@020@800P4010010@5c00410@0000030@0006`000<1
000010001@40000107800@41000000<10000K0000`40000800030@000700
0@41000000<10000J`000`40000700030@0107800@41000000<10000JP00
0`40000800030@0107800@41000000<10000JP000`400008008100<00@00
L0010@4000000`40001Z00030@0000P00P400`01001`00410@0000030@00
06X000<1000020020@03004007000@41000000<10000JP000`4000090003
0@0107400@41000000<10000J@000`40000:0081LP010@4000000`40001Y
00030@0000X00P5b00410@0000030@0006T000<100002P000`40001a0041
0@0000030@0006P00P4<00030@0007400@41000000<10000IP020@d000<1
0000LP010@4000000`40001?00030@0001<000<100003@000`40001b0041
0@0000030@0004l000<100004`000`40000<00030@0007<00@41000000<1
0000C`000`40000B00030@0000h000<10000LP010@4000000`40001?0081
4`000`40000>00030@0007800@41000000<10000C0000`4000020@030040
00l000<1000040000`40001a00410@0000030@0004`00`4010010@4?0081
4P000`40000200030@0006`00@41000000<10000C0000`4000020@030040
00D000<100001P020A<000D100000@1^00410@0000030@0004`000@10000
0`4600030@0000H00P4C00060@000@01K@010@4000000`40001<00040@00
00<11@020@P00P4B00<100@00@01K@010@4000000`40001;00810`020@H0
0P4800030@00014000@100410`000`40001Z00410@0000030@0004/00P43
008100<00@000`020@P00P4B00050@0000400P000`40001Z00410@000003
0@0004/000@100400`400`010@0200030@0100P00P4B00050@0000400`00
0`40001Y00410@0000030@0004/000@100400`400`010@0200030@0100P0
0P4B00050@0000400P020F/00@41000000<10000B`000`400@040@080040
0@01004800814@000`40000200<1K@010@4000000`40001;00050@000@00
1P42008120020A4000<100000P000`40001]00410@0000030@0004`000@1
00400`400`010002008120020A4000@100000P5_00410@0000030@0004`0
00@100400`400`010002008120030A0000H10001005I00030@0001<00@41
000000<10000C0000`4000040@03004000<000<100001@0010400@4=00@1
0P000`400@1I00030@0001<00@41000000<10000C0000`4000020@040040
0@<00`4600040@010@h00P40100100020ET000<100004`010@4000000`40
001=00050@010@000`4300030@0000810`001@40000101000`400`010@1I
00030@0001<00@41000000<10000C@001@400@40008110000`4000020004
0@000@<00P4>00L1F@000`40000C00410@0000030@0004d000<100001044
00030@00008000@100010`020@h00`401001005I00030@0001<00@410000
00<10000C@000`400@040@<000<100000`000`400@0400813@000`400@02
00040@000EP000<100004`010@4000000`40001=00030@0100@100@00@01
10001040004300030@0100d000<100400`000`400@1H00030@0001<00@41
000000<10000C0020@03004100H11@001040004300030@0100`000<10040
10001040005G00030@0001<00@41000000<10000C0020@03004100L11000
1040004300030@0100`000<1004010050EH000<100004`010@4000000`40
001<008100<00@400P401@010@0100@000<100400P001@400@0100`000<1
000010020@03004105H000<100004`010@4000000`40001<00T100<00@40
0`001040004200810P000`40000:00030@0000<00P4200030@0005@000<1
000050010@4000000`40001<00D100D00@4100020@<000@100010P020@80
00<100002P000`40000200<100<00@00E@000`40000E00410@0000030@00
04`01@401@010@4000810`001@400040008100@00@0130000`40000300<1
EP000`40000F00410@0000030@0004`00`400`010@030@0400400@8000D1
000100020@800P4<00030@0000<00P5G00030@0001H00@41000000<10000
C@020@03004100D100D00@000@0300<10`000`40000:00030@0000<000<1
0000E@000`40000G00410@0000030@0004d00P400`010@050@0500400040
0`030A0000<100000`000`40001E00030@0001L00@41000000<10000C@02
0@03004100D100D00@000@0300030@01010000<10000F`000`40000G0041
0@0000030@0004d00P4010010@040@0400400@@000<1004040000`40001K
00030@0001L00@41000000<10000<0000`40000J008100<00@401@401001
0@4400030@01010000<10000FP000`40000H00410@0000030@0003000P4I
00h100<00@001@020@l000<10000F@020AX00@41000000<10000;P001040
0@4I00D100<00@401@4200030@0000@00P4?00030@0005P00`4J00410@00
00030@0002h000D100400@0G00H100<00@401@4200030@0000<000@10001
3P000`40001G00@16P010@4000000`40000^00<100<00@005P030@030040
00P10`000`40000200040@000@l000<10000EP050AT00@41000000<10000
;P020@0600410@0150030@03004000P10`000`40000200040@000@l000<1
0000EP050AT00@41000000<10000;P020@03004100<150020@04004100L1
1@001@400001008000<100002@030@03004005L010400`01000G00410@00
00030@0002h01P400`01000B00810P020@03004100D11@00104000430003
0@0000/00`5H00060@010@0160010@4000000`40000^00H100<00@004P02
0@0500400@001`4600030@0100<000<100003@000`40001E00030@0000@1
60010@4000000`40000^00H100<00@004`050@030041008100<00@401P00
0`40000300030@0000`000<10000EP000`4000020@03004001L00@410000
00<10000;P020@800`4E00<100<00@0010400`010@0600030@0000<000<1
000030000`40001F00030@00008100<00@005`010@4000000`40000^0004
0@0000<150020@0500400@001`4500030@0000@000<100002`000`40001G
00D100<00@005`010@4000000`40000a00@130050@8000H10041004200L1
1@000`40000400030@0000/000<10000E`020@800`4H00410@0000030@00
0340104300030@0000H000<100000P020@800P40100100080@@000<10000
10000`40000:00030@0005`00P4I00410@0000030@00030000<100400P43
00030@0000H000<100001P001040004200H100<00@400`000`4000040003
0@0000X000<10000G0020AT00@41000000<10000<0001P400@400@800P47
00030@0000D000H100000@050@03004100810P000`40000500030@0000X0
00<10000G@000`40000G00410@0000030@0002l000<100000P4010010@02
0@L000<100001@00104000020@03004100801@4200030@0000@000<10000
30000`40001L00030@0001L00@41000000<10000;P00104000020@030040
00<120000`40000400030@0000@00P4200D100<00@001P000`40000<0003
0@0005`000<100005`010@4000000`40000^00040@00008100<00@000`48
00030@0000<00P4600<100D00@4100020@P000<1000030000`40001M0003
0@0001H00@41000000<10000;@00104000050@8000<100401`000`400003
00811@040@0600410@0120000`40000=00030@0005d000<100005P010@40
00000`40000^00030@0000@10`030@L000<100000P020@H000<100401`48
00030@0000h000<10000G@000`40000E00410@0000030@0002l000<10040
0`4300040@010@H000<100400P000`400004008100<00@401@4800030@00
00l000<10000G@000`40000E00410@0000030@0003000P400`010@020081
0P000`40000400050@0100400P000`40000200<100<00@40104700030@00
010000<10000GP000`40000D00410@0000030@000340104200810P000`40
000400040@000@800`4200050@010@001P4600030@00014000<10000GP00
0`40000D00410@0000030@0003<00P4200050@0100401P001040004200<1
0P000`400@0200@100<00@0010000`40000B00030@0005h000<100005001
0@4000000`40000d00080@000@01004600070@000@0100020@0300400080
0P400`010@050@<000<100004P000`40001N00030@0001@00@41000000<1
0000=0001@400040008100<00@001000104000050@030040008000<10040
0P400`010@0200<15@000`40001N00030@0001@00@41000000<10000=000
1@400040008100<00@0010001P40000100<100@00@000P4010010@030@<0
0P4D0081H0000`40000D00410@0000030@0003D000<100400P000`400002
0@<000@100000P400`010@020@800P4010010@040@8000<100404`020F00
00<1000050010@4000000`40000f00810P000`40000200040@000@<00`40
2P010@400@01004200030@00008100@00@014`020Dl000<100003P000`40
000D00410@0000030@0003H00P4800@10P060@0400410@8000<100001`42
00030@0001000P5?00030@0000h000<1000050010@4000000`40000g0003
0@0000P000@1004020400`01000300030@0100800P4300030@0001000P4T
00030@0002P00P4?00030@0001@00@41000000<10000=`000`40000:00X1
00<00@000`000`40000300030@00008000<100003`020B@000<10000:002
0@l000<1000050010@4000000`40000g00030@0000/02`4400030@0000<0
00<100000P000`40000?00<18`000`40000X00813`000`40000D00410@00
00030@0003L000<1000020000`4000060@03004100<10`000`4000020081
10000`40000?00<180020@03004002T00P4?00030@0001@00@41000000<1
0000=`000`40000700810P060@0600410@010`000`400002008110000`40
000?00<12@000`40000D008100<00@009P001P4000400@h000<100005001
0@4000000`40000f00030@0000P00P4200X100<00@000P000`4000020081
10000`40000?00<12@000`40000C00D19`001P4000400@h000<100001`02
0@/00@41000000<10000=P000`40000800810P060@04004100810`000`40
000200030@0100<00P4@008100<00@001P000`400@0D00D19`020@040040
0@l000<100001@000`4000020@8000<1000010010@4000000`40000f0003
0@0000P00P4200@100<00@000P400`010@0300030@00008000<100401000
0`40000>008100<00@001P000`400@0D00D19`020@0400410@l000<10000
1@001@400001008000<1000010010@4000000`40000f00030@0000P00P42
00T100@00@010P000`40000200050@0100400P000`40000>008100<00@00
1@001040004D00D19`020@030041010000<1000010000`40000300030@01
00H00@41000000<10000=P000`40000900030@0000T100@00@010P001@40
000100<00P4200030@0000h000@100011P001040004A00<100<00@400P4V
00030@0000<140000`40000400030@0000<00`4600410@0000030@0003H0
00@1000120000`40000;0@05004000400`00104000030@03004000l000<1
00401`001@40000101800`400`01000V00030@0000814@000`4000030003
0@0000@00P400`01000400410@0000030@0003H000<100000P4400040@00
0@801`401@010@40008100<00@000P000`40000300<140030@L000D10000
0@0B00<100<00@009P000`4000020@D00P4:00030@0000<000<100001@00
0`400@0500410@0000030@0003H000<100000`4200030@0100810P070@05
00410@000P400`01000200030@0000<00`4@00<11`001@40000100h000@1
00000`400`01000V00050@0000400`020@03004000P000<100000`000`40
000600030@0100D00@41000000<10000=P001@40004000<110000`400003
0@03004100D100<00@400P4300030@0000<00`4?00040@010@L000@10041
3`00104000020BX000D100000@0200050@0000402@000`40000300030@00
00D00P400`01000400410@0000030@0003H000D1000100020@D000<10000
204200<100@00@010P000`40000300<13`0010400@4700814@0010400002
0@H00P4R00070@0000400@0400030@0000L000<100000P020@L00P400`01
000400410@0000030@0003H000@100000`4600040@010@<000D100410003
0@0600400@011`020@l000@100411P000`400@0@00810P000`400@0300<1
00<00@008@00104000020@D000<100001`000`4000040@L00P400`010004
00410@0000030@0003H000L100000@0100H01043000>0@010@0100400@01
00470081400010400@4500030@0101000P4200810P020@@000<100005@00
0`40000800050@0000401P000`40000600030@0000@12@000`400@050041
0@0000030@0003H000<100400P400`010@0600030@0100<01P4020010@40
0@011`020A0000@100411@000`400@0@00040@00008100<00@001@000`40
000E00040@000@L000<1000020000`40000600030@0000800P4900<11@01
0@4000000`40000f008100@00@400P4200810P030@<01P4010010@020@03
004000H00P4@00040@010@D000<100404000104000020@03004000D000<1
000050020@800P4700030@0000L000<100001P000`40000200030@0000P0
0`4500410@0000030@0003T00P400`010@0200D100<00@400P030@050041
00400P030@P00P4?00030@0100811@020A000P4300<120020@X000@10001
1P020@800P4700030@0000L000<100001`001@40000100X00P400`010003
00410@0000030@0003T00P400`0100070@06004100400P401@0100010080
0`4800813P020@0400410@D00P4@00810`020@T00P4:008100<00@401000
0`400@0200030@0100<000@100012@000`40000700040@000@`000<10040
10010@4000000`40000i00030@0100<100<00@000`4200040@01008100<0
0@400P4200<11`030@h00P4010010@45008140030@8000<1000020030@T0
0P401001004200810P001P400@01008100@00@412@000`40000700040@00
0@`000<1004010010@4000000`40000j00@10P050@@000<100400`400`01
0@02008100<00@001@030@d000@100400`45008140040@03004000T00`48
008100<00@400P020@@00P4300030@0000<000<100001`000`40000700<1
3`000`40000200410@0000030@0003X000<100400`040@800P401@010@40
00<100D00@000@0200030@0000@00`4=00030@0100800P45008100<00@00
3@000`4000030@X00`48008100<00@4020020@<000<100003@0010400004
0@800P4:00030@0000<000<100000P010@4000000`40000j00030@0100<0
00@100410P000`400@030@0500410@001`4300H100<00@002@0010400004
0@D0104>00030@00008130030@@000<100000`400`010@0700810`000`40
000=00050@0000400P020@03004100/000D100000@0500410@0000030@00
03X000@100410P001040004200070@000@0100020@801042008100<00@40
1P400`01000900030@0000<11P040@d000@100000`4;00040@010@<00P40
1@010@4000811`020@<000<100003@001@40000100800P400`010@0;0005
0@0000401@010@4000000`40000j00040@010@8000@100010P001`400040
0@000P4200@10`030@@000D100400@0:00030@0000<11P030@h000@10000
0P400`01000900@10`030@8000<100400P4600030@01008000<100003@00
1@400001008000<100400P4<00030@0100H00@41000000<10000>P001040
0@4200030@00008100<00@0010400`010@060@<000<100001P0010400049
008100<00@400P400`01000200<13P000`40000200040@000@T00`401001
004200050@000@000`4600040@000@8000<1000030001@400001008000<1
00400P4<00030@0100H00@41000000<10000>`000`400@0200030@000081
00<00@40100010400@030@h000@100012@020@030040008100<00@000P03
0@`000<1004010001040004900<100D00@0100020@801@4600040@000@80
00<1000030001040004200030@0000<13@000`40000500410@0000030@00
03/000H10041004200030@0100810`000`4000050@X000D100000@030003
0@0000H000<100400P401@010@0100<00P4<00030@0100@000D100000@08
00<100D00@0100030@03004100811`001`40000100403P00104000420003
0@00008100<00@002`000`40000500410@0000030@0003/000@100410P00
10400@030@<000<100000`4;00050@01004010000`40000600060@010040
0P400`01000200030@0000`00`4300050@0000402@020@03004000<10`04
0@P000<100400P000`40000<00050@000@000P4300030@0100/000<10000
1P010@4000000`40000k00040@010@800P43008110000`400@020@/000@1
00411@000`40000600030@0000D100<00@000P000`40000<00030@0100<1
00D00@000@0800040@0100811P0010400@4800030@01008000<100003@04
0@030040008000<100402P000`40000700410@0000030@0003`00`420081
0`020@@000<100400P4:00030@00008110000`40000700030@0000800P42
00050@0000403@020@03004000@100<00@001`070@P00P4800815@040@<0
00<100402@000`40000800410@0000030@0003`00`4200812@000`400@02
0@X000<100000P4400030@0000L000<100000`001P400001008130001@40
0@0100800`400`01000700030@00008100<00@001`000`40000700815002
0@P000<100001P000`40000900410@0000030@0003`00`4300030@0000P0
104900030@0000800P4300030@0000L000<100000P000`400002008100<0
0@0030040@801@4700040@0000<12@000`40000700030@0001h00P460003
0@0000T00@41000000<10000?0030@<000<1000020040@P000@100010P02
0@<000<100001`030@800`4200040@000@l00P4200030@0100811`001040
00030CH000<100000P000`40000:00410@0000030@0003`00`4?00812@00
0`4000020@030040008000<1000020020@0400410@8000<100000P000`40
000=00030@0000800`4700030@0000800`4b00050@00004010000`40000:
00410@0000030@0003`000<100403P040@L000<100000P030@<000<10000
20000`40000200050@0000400`000`40000<00<10`000`400@0700060@00
00400P4b00@110000`40000;00410@0000030@0001L000<100008P000`40
0@0>00<11`000`40000300060@010@012`000`40000200050@0000400`00
0`40000;00@10`000`400@0800030@0000<1=0000`400@030@03004000`0
0@41000000<100005P020B@000<100403P030@L000<100000`000`400@03
0@/000<100000P000`400002008100<00@003@000`400@0300<12@000`40
0@020C@000<100400P000`400@0=00410@0000030@0001H00P4T00030@01
00h00P4800030@0000@000D100400@0;00050@0000401`020@d000@10001
0`030@T00P400`010@0d00030@0100<00P4=00410@0000030@0001D000<1
004090000`400@0>008120000`40000400050@0100402P020@<000<10000
50001@40000100800`4:00040@010CD000<100000P020@d00@41000000<1
000050001040004T00030@0000800P4D00030@0000H000<100402P020@<0
00<1000050001@40000100<00P4;00030@0103D000<100000P020@d00@41
000000<1000050001@40000102@000H10041004E00030@0000D000<10040
2P020@<000<100005000104000020@0400410@/000<10040>P020@d00@41
000000<1000050001@40000101/00P4800810P000`40000C00030@0000D0
00<100402P020@8000<100005P000`40000200@12`000`400@0k00030@00
00/00@41000000<1000050001@400@0101/000@100411`001040004:0003
0@0000P000<100001P000`400009008100<00@4060000`40000500030@00
00X00P4k00030@0000/00@41000000<1000050001@400@0101X000<10000
0P000`40000300810P000`40000800030@0000P000<100001P000`400009
00<16P000`40000500030@0000X00P4k00030@0000/00@41000000<10000
4P000`400@020@03004001T000<100000P000`40000300810P000`400007
00812P000`40000600030@0000T000<100006P000`40000C00030@0004L0
0@41000000<100004P000`400@020@03004001T000<100000`000`400002
00810P000`40000700812`000`40000500030@0000T000<100000`000`40
000C00815@000`40001700410@0000030@0001801@400`01000I00030@00
00<000<100000P020@8000<100001P000`400@0;00030@0000D000<10000
2@000`40000200040@0000813`020F400@41000000<100004P060AX000<1
00001@020@0400400@8000<100001P020@d000<1000010000`4000090004
0@0000810P000`4000020@d000<10000H0010@4000000`40000B00030@01
00<16P000`400007008100D00@000@0700030@0100812`000`4000040003
0@0000T000<100000P4300050@0000403@000`40001P00410@0000030@00
01<0104K00030@0000X000@100011`040@d000<100000`000`40000:0081
00D00@400@0400030@0000`000<10000G`010@4000000`40000C00040@01
0A/000<100002P001@40000100P000<1000030000`40000300030@0000`0
00@100011@000`40000:00030@0106400@41000000<100004`0010400@4K
00030@0000X000<100400P4700813P000`40000300030@0001D000<10000
2P030F400@41000000<100004`0010400@4K00030@0000X00P4200811P02
0@h000<100000`000`40000D00030@0000/00`5Q00410@0000030@0001<0
0`4L00030@0000h000<100401@020@h000<100000`000`40000D00030@00
00/000@10041H0010@4000000`40000C00@16`000`40000?00811@000`40
000=00030@0000<000<1000050000`40000;00040@010F000@41000000<1
00004`040AP000@100014@000`400@0400030@0000d000<100000P400`01
000E00030@0000`000<10040H0010@4000000`40000C008100<00@005P00
0`400@020A800P4300813`000`400@0200815P000`40000<00030@000600
0@41000000<100004`020@03004001H000D100000@0B00810`020@l000<1
00406`000`40000700050@000040HP010@4000000`40000B00<100<00@40
5@000`40000F00810P000`40000>00817@000`40000200<100<00@000P00
0`40001P00410@0000030@0001000P4200040@010A@000<100005`020@80
00<100003P000`40000L00030@0000810P000`400@0300030@0006000@41
000000<100004@001@400@4000814`040AP0104`00030@0100@00P4300<1
H0010@4000000`40000B00<100<00@004`000`400@0J00030@01030000<1
004010000`400@0200040@000El00@41000000<100004`020@03004001<0
0P4K00030@01030000<100400P030@07004000400@1P00410@0000030@00
01800`400`01000C00030@0001X000<10040<0000`400@020@0500410040
0P000`400@1P00410@0000030@0000X000<100001@0010400@4500030@00
00d000<100006P020C400P401P010001008100@00@01H@010@4000000`40
000:00030@0000@00P400`010@0500030@0000`00P4M00030@00030000<1
00400P001@400@400081HP010@4000000`40000800@11@020@0400410@<0
0P4>00<170000`40000`00030@01008000D1004100020@03004005l00@41
000000<10000200010400@4400080@010@01004200813P030A`000<10000
<0000`400@0200050@010@000P400`010@1O00410@0000030@0000P000@1
00411@070@0400400@/000<100000`5?00070@000@0100020@0400410081
G`010@4000000`40000800040@000@8000D1000100030@800P400`01000:
00030@0000<1C`020@0500400@000P4200050@010040GP010@4000000`40
000800040@000@800`4200@100D00@000@0<00030@0100<1C0002@400@40
0@0100020@8000D100400@1N00410@0000030@0000L000@100000P401001
004200040@010@8000<1004030020@0400400D/00P4020010@0100400P42
00810`000`40001K00410@0000030@0000L000@100001@401@01004000@1
0P000`40000:00<100<00@40BP000`4000030@03004100800P4200810`00
0`40001K00410@0000030@0000L000@100000P400`010@0200050@000040
10000`40000:00D1BP00104000020@03004100<00P4200810`000`40001K
00410@0000030@0000L000@100000`401@01000100<00P4300030@0000/0
0P5;00030@0000800P400`010@0300H10`000`40001K00410@0000030@00
00L000@100000`40100100020@0400400@8000<1000030000`4000190003
0@0000<00`400`01000300@110000`40001K00410@0000030@0000L000L1
00000@01008000P1004100400@8000<1000030000`40001800030@0000D0
0P400`01000400030@0000@000<10000F`010@4000000`40000700030@00
008100@00@000`401`010@0100403P020D/000<100001000104000460003
0@0000<000<10000F`010@4000000`40000700050@000@000P4200<100<0
0@400P400`01000600030@0000@00P5<00030@0000<000@100011`020@<0
00<10000F`010@4000000`40000300050@0000400P090@03004100<12003
0@@00P5<00030@0000<000@100012@001040005M00410@0000030@0000<0
00@100000P402@010@400@0100050@03004000L000@100010`000`400@1<
00030@00008000@100012P030Ed00@41000000<100000`000`4000020003
0@01008100<00@000P400`010@040@P000@100000`4200030@0004X000<1
00000`4200030@0000X000<10000F`010@4000000`40000300030@000080
1@400`0100020@0500410@000P4800030@0000<000@10001C0000`400@02
008100<00@00J@010@4000000`40000400040@0000L100@00@401P480003
0@0000H000<10000BP001`400@010040K0010@4000000`40000400030@00
00L100D00@4100060@P000<100001P000`40001;008100<00@400P5[0041
0@0000030@00008000@100400P400`010@030@800P400`010@030@T000<1
0000E0040@03004106/00@41000000<100000P030@04004100D10P080@T0
00<10000E0040@03004006/00@41000000<100000P030@03004100801P40
0`010@030@03004100P000<10000E0020@0400400F`00@41000000<10000
0P000`400@020@03004000H100<00@401@4900030@0005@000<10040K`01
0@4000000`40000200D100<00@401P400`010@020@03004100L00P5G0003
0@0106l00@41000000<100000`000`400@0300`100<00@401P000`40001G
0081L0010@4000000`40000300<110060@030041008100<00@401@000`40
001H00030@0006l00@41000000<100000`030@<0204010010@040@@000<1
0000bP010@4000000`400002008100<00@400P000`400@080@0300410081
0`000`40003;00410@0000030@0000800P400`010@0200030@01008100@0
0@400P4010010@4400030@000</00@41000000<100000P000`4000020@80
00<100400P40100100020@03004100D1cP010@4000000`400003008100H0
0@000@030@030041008000<100000P7B00410@0000030@0000<00P401`01
0@400@000`400`0100020@800P7B00410@0000030@0000<01@4010010@03
0@0400400@<00P7B00410@0000030@0000<00P401@010@4000D100@00@41
0`020M800@41000000<100000`030@04004100T10P030M800@41000000<1
000010020@03004100X10P030M800@41000000<1000010000`400@070@03
004100810P000`400@3B00410@0000030@0000D0104010010@4200D100<0
0@00d`010@4000000`40000400810P000`400@020@80207C00410@000003
0@0000@000<100400P0010400@4200L100<00@00d@010@4000000`400005
00810P050@0700410@0100020@0300400=000@41000000<100001@020@80
3@400`010@3A00410@0000030@0000H000D10001000<0@0300410=000@41
000000<100001P020@04004000@100<00@400P401001007A00410@000003
0@0000L000H100400@060@030040008100<00@00c`010@4000000`400007
00030@01008100@00@401@401001007A00410@0000030@0000T010401001
00040@0400400M400@41000000<100002@040@@01`7B00410@0000030@00
00T01044008100<00@400P7B00410@0000030@0000T00P400`01000400<1
00<00@00dP010@4000000`40000;00030@0000@01@7C00410@0000030@00
00/000<1000010050M<00@41000000<100002`000`40000400050@010040
d`010@4000000`40000;00030@0000@01@7C00410@0000030@0000/000<1
000010020@8000<10000d@010@4000000`40000;00030@0000D000@10001
d`010@4000000`40000<00030@0000<00P400`01003C00410@0000030@00
00`000<100000`020@0300400=<00@41000000<1000030000`4000030081
00<00@00d`010@4000000`40000<00030@0000<0107D00410@0000030@00
00`000<100000`000`400@3E00410@0000030@0000`000<100000`000`40
0@3E00410@0000030@0000`000<100000`0010400@7D00410@0000030@00
00`000<100000`040M@00@41000000<1000030000`40000300@1e0010@40
00000`40000=00030@00008000@10041e0010@4000000`40000=00030@00
00800P400`01003C00410@0000030@0000`00P4500040@010M<00@410000
00<1000030040@<000@10041d`010@4000000`40000=00040@000@8000@1
0041d`010@4000000`40000=00040@0000810`000`40003A00410@000003
0@0000d00P4300050@000040d`010@4000000`40000<00030@010=/00@41
000000<1000030020M`00@41000000<1000030020M`00@41000000<10000
30000`40003K00410@0000030@0000/00P7M00410@0000030@0000/000<1
0000g0010@4000000`40003Z00410@0000030@000>X00@41000000<10000
jP010@4000000`40003Z00410@000>h10@000001
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{239, 239},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Appendix B: Another Minimal Surface", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ParametricPlot3D[\n\ \ \ \ {\((r^2*Cos[2*phi])\)/2\  - \ 
            Log[r], \ \(-phi\)\  - \ \((r^2*Sin[2*phi])\)/2, \ 
          2*r*Cos[phi]}, \n\ \ \ \ {r, \ 0.0004, \ 2}, \ {phi, \ \(-2\) Pi, \ 
          3  Pi}, \ 
        PlotPoints\  -> \ {12, \ 
            80}, \n\ \ \ \ ViewPoint -> {\(-2.1\), \ \(-1.1\), \ 
            1.2}];\)\)], "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004g0000j`P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hconl00P560000k0030@03004104D0003Y00<110020DD0003U00@11`00
0`400@140000hP030@/000@10001@`000=l00`4>00040@000D<0003L00<1
4@001@4000010480003I00<150000`40000200030@0003l0003E00@16000
1@4000010440003B00<170000`40000200030@0003h0003?00<17`000`40
000300030@0003d0003<00<18P000`40000300030@0003d0003900<19@00
0`40000400030@0003`0003500@1:0000`40000500030@0003/0003200<1
;0000`40000500030@0003/0002o00<1;`000`40000600030@0003X0002l
00<1<P000`40000600030@0003X0002i00<1=@000`40000700030@0003T0
002e00@1>0000`40000800030@0003P0002b00<1?0000`40000800030@00
03P0002_00<1?`000`40000900030@0003L0002/00<1@P000`40000:0003
0@0003H0002Y00<1AP000`40000900030@0003H0002U00@1B@000`40000:
00030@0003D0002R00<1C@000`40000;00030@0003@0002O00<1D0000`40
000;00030@0003@0002L00<1D`000`40000<00030@0003<0002I00<1EP00
0`40000=00030@000380002E00@1F@000`40000=00030@000380002B00<1
G@000`40000>00030@000340002?00<1H0000`40000?00030@000300002<
00<1H`000`40000?00030@000300002900<1IP000`40000@00030@0002l0
002500@1J@000`40000A00030@0002h0002200<1K@000`40000A00030@00
02h0001o00<1L0000`40000B00030@0002d0001l00<1M0000`40000B0003
0@0002`0001i00<1M`000`40000B00030@0002`0001e00@1NP000`40000C
00030@0002/0001b00<1OP000`40000D00030@0002X0001_00<1P@000`40
000D00030@0002X0001/00<1Q0000`40000E00030@0002T0001Y00<1Q`00
0`40000<008120000`40000X0000I@040HX000<1000020030@9<00<10000
1P000`40000X0000HP030Hh000<1000010040@05IDaUC0402P000`40000W
0000G`030I4000<100001046C0<12P000`40000W0000G0030I<010401VE<
IDaUC0@100=VC0402`000`40000V0000F@030I401@4014`1C042C0@100M<
ITaVC6H100`000<100009@0005D0106?00D100IUIVEVIFH50@08ITaVC6I<
IT`30@`000<100009@0005800`6=00H100M<IDaUC6E<00D100QU0DaVC6I<
IP@100==IP403@000`40000T0000C`030HX01P4018=UPfD20@03IVEV00@1
00UVJfI[0F]V0D`010401f]VJfI[IP403P000`40000S0000C0030HL01P4;
I@@100UVIFIUIVEVIFH010402TeVCFI=ITeVC@4?00030@0002<0001900<1
Q@050@03PVF2008100QUPfF3IH=UP`@100YUP`5[IV]VJfI[10402V/1IV]V
JfI[IV/30A0000<100008P0004D0106500<100YmIGeUOFEmIGeU0P42I@@1
00Z3IH=UPfF30FIU10402F]VJ`5[IP5=IP050@03K6H1014000<100008@00
04800`67008100f2O@41PVF2IH9UPVF200@100]UPfF3IH=UPfF3I@030@09
Jh=[Pf^3J`5[00@100Q/Jfa[K6]/0A4000<100008@0003l00`68008100IU
PVF2IH820@03IGeU00@100>3IH<00P401VF3IH=UP`@100U[P`5[IV]VJfH0
0`4036^40FaVK6I/IVaV0A8000<10000800003`00`64008110020@09OH9m
PWf2OH9m00<100b2Ph:3PX>2Ph81IH<30@0:Pf^3Jh=[P`63J`<100a[0F^4
J`5[K6]/Jf`30A<000<100007`0003T00`6500<11@002@5U0@62IH9UPP02
0@0<OH810FF3IH=UPfF30`402X=[Pf^3Jh=[Pf/30@0;JhA[Q064JhA[0FH0
10400fa[0@0C00030@0001l0000e00@1QP030@03U04000@000@1PWf20P40
0gd10@06PP8100>3PP400`402XR30@63Jh=[Pf/30@0;PhT1Q6^4J`5[Q6/0
0`401fb4K8A/Q04050000`40000N0000<P030HT000D1Z@6D0@06000A0FEm
IGeU0Gf2OH9mPWf2OH800P48P`030H=[00<100Y[Q6^4J`5[Q6^410402V`1
Jfa[K6]/J`4E00030@0001d0000_00<1R`000`6YU0020@P00P400h9mPP03
0@N200/1X068PhR3R8>8P`030@0;PhV3RH>9PhV30F/00`402fb9K8U/0Fb4
K8A/00815@000`40000M0000;0030H`00P400jVD0@020@P000d1I@5mI@5m
PP62OH9m008100>3PX<00P44P`8100^3R041JhA[Q6^4J`030@0:K8@1Q6b4
K8@1K0@100=/0@005@000`40000L0000:@030Hd00P4019BYU:T20@X000<1
O@400P43PP8100^20H:PPZ22X881P`020@09RH>9PhV30H>900@100Z4R@69
K05/RFb90`401XY/RVb:0AL000<100006`0002D0106=00D100>YU:T00P4<
00090FEU0Gf2OH9m008101:3PX>2Ph:3PP63R8>8PhR3R8<20@0<RF^9JhU[
R@640HA/0P400hT1K005K0030@0001D000<100006`0002800`6?00D100BY
0IBY0P4=00050FEmI@401880206O0@62X8:P0P4028P10HV3RH>90P402hT1
Q8V4RHB9Q05/00<100/ERQD1K8Y/RVb:0@0H00030@0001X0000O00<1S`07
0@03U06D00@13P000`5UI@030@03PWd100>20P401h<1R8>8PhP00P403X<1
0HV3RH<1JhU[RF^910401Vb9K8U/0@A/0P4I00030@0001T0000L00<1S`02
0@03C04100@10ZT20@03TjT1010000D1IGd1PP020@0JPYn2Wh:O0J28X8RP
R:280HT>R@j93XT1Q8T30@0;RXT10HXERQF:0HX00`400hX1000H00030@00
01T0000I00<1SP040@9<1@402:VDZI@1TjT14P030@03IH8100J20P4048R3
R8>8P`680H>9PhV3RH<20@0;RHB9Q8V40Fb9K8T00`401G5/LF`101X000<1
0000600001D0106>00<114`40@03C06Y00>Y0P400jVC0@0C00<100YmPP41
PYn2W`6P0P4038RPR0683XP1R@j93P8100^90HV:RHZ9RP6:5@020@09RP6:
5HXERQD101X000<100005`0001800`6>00@10d`30@0:C@5<0D`1ZIBYU081
00>YT`405@020@05PVD1PP400X803`6PPZ220H<1R0j83XP1P`020@B900H1
Q8V4RH@30@0;5HXERP5aK75/L@406P000`40000G00003`030H`01@400daV
0@040@04ITaVC0@11:T0106Y0I<20AH000Hh0H9m0H830@0IR:28X8P1R0j8
3XP>R069XHVQRJ41RXV:R@020@0=S`6:RHZ90AF:5HXE0@0K00030@0001H0
000=0081RP050@04C6E<I@@100I<CDa=C4d30@09C@41U:VD0I>Y00<16000
13@10@43PP060J22X8:P0P4028P>R0j80HT11XT040690@690HT15HXERQD1
K7430A`000<100005@0000d00`6400D100E<ITaVC0040@06JfH1C6I<1040
1VH1C@400@:Y00<1ZJT00P400i<1000H0006>0410IZ20`401HRPR06P0081
01P>R0h1YHT1RJ69XHVQ0Hn9S`6?R@69RXT40@03RW4101`000<100005@00
00d000@10001OP050@06IFIU0DaU10401daVC6I<0D`00`404TeVCFH1C@6Y
U06D0I>YT`6>0A/000<d0@400X800`6OPP030@0;R:28X04>0@j93P4018T2
0@09RP6:R@69RP6:008100LE0AF:5HX101d000<10000500000d000D10000
0@1i00@100IUPfF3IH<50@08JfI[IV]VJfH30@07CFI=ITeVC@020@030:T0
00810jT20@03Z@4001/001Lh0@41VP6OPYl1YJ2UX:D1YHVURJD1X@020@0E
RJJ90HV?0Hn9S`6?RXn:0G6:LHX101`000<10000500000d000<100000P02
0G401P401VIUIVEVI@@100U[I@5<ITaVC6H0104026H1CFI=ITeV0`402JVD
ZI@1TjVCZ@030Ah000<d0H800P400h:OPP020@04X8RPR081010>R@j93P6:
RHZ9RXT1R@690`402QF:5HX1RQF:5@4M00030@0001<0000<00030@0000D0
00<10000J0060@04IH=UP`8100=UP`400`402FJ3IX=VPfH1IP040@09K6I/
IV`1ITeV00<100I/0@6Y0:T20@>Y104O008101^20In2W`6T0JFP0@jU0JF9
Y@6V0JJ9YXVV0Hl00P403HZ?RP6:ShX1LHYaRP407P000`40000B00003000
0`40000600030@0006801@402h=UPfF3IH=UPfF300<100Y[IF]UJfE[IF]U
0`402VI[IV]VJfI[0FH30@03K4e/008100ZDZI@1Z@6CZ@6Y0P4Q00@101JO
PP67X06P0JF8Y@4>0JJ9YP6:RHZ90`4038V?RHl1RQF:0HXERP817P000`40
000B000030000`4000070081GP040@03Ph:3008100MUPfF3IH=U00@10X<0
1`5VPfJ3IX<010402F/1IVaVK6I/IP040@0<K6I/IVaV0JT0Z@010ZT20@04
ZBX10B8010404il1Y:2T0JD>Y@jU0JJ9YXVV0JH00P4038ZV0Hn:ShX1RXn:
S`<100>@0@007P000`40000A000030000`40000900030@0005P00`4036F2
IH9UPVF2I@5UP`@100YZPfZ3JX=Z0FE[0`402H=[Pf^3J`5VJ`040@0?IV`1
K4e/CFa=0IBYU:T100>Y0P400i<10@0T00030C<1008100>7X8L00P401:F8
YHP20@0BYXVVRJH1ShV?RHl1ShV?R@4E0`401G6:LHX101l000<100004000
00`000<100002P000`40001F000<0H810H>2Ph:3PX>2104:P`@100R4JhA[
Q6^4J`@100Z4JhA[Q6/1IVaV0`401JT0Z@0100BY00<1:ZT00P4U000O>3@1
0JBPY06U0JD>0JFV0JJ9YP6V0JJ:YXX1RXn:S`020@08RY01T76@L@4O0003
0@000100000<00030@0000/00P5?00L100AmPWf20P400fF20@030@04PX>2
P`8100AZPfZ310402F^3J`5[Pf^3J`030@09Jh@1K6I/IVaV00D100MV0IBY
U:T100BY0P401:T1:P4U0003<cPc008101FP0JFPY@6U0JF9Y@6V0JJ90HV?
RHl00P403XT10Hl1Sg6?0HYaRW417`000`40000?000030000`40000=0003
0@0004X00`42U08128820@Z310402hV3RH>9PhV30F^4008100Y[RF^9J`5[
Q6^40P400f`1K002K0060JT1Z@011JT30@03:P4102H000<c>3@00`408j2U
X:D1YZFVYJH1YXnVS`6:YXX1RP6?T8l1RY2:0G6@LI01020000<100003P00
00`000<100003P000`400017008100BYU06C0`402Wf2OH9mPWd1PX<20@06
PX>2Ph:30P4038>80H=[Pf^3Jh=[P`<100Z4JhA[Q6^4J`5V0P43K00:0FaV
K06Y0JVD0@BY00H1Z@41SP4X00030CPc008100BUX:FP0P401:F9YHT20@07
YXVVR@69S`030@0=ShZ?RP5aSg41LHYa0@0P00030@0000h0000<00030@00
00l00P55008100VDZI@1U0400H800P44PP060H:PPZ220P42P`8100^9PhV3
R@69PhV3R@030@09RH<1JhU[RF^900@100I/RFb9K042K0040@2Y00811:T0
106YZ@42:P030@0002H000@h0CPd0P402JFPY@6U0JJU0@02YP060JJ?YP6V
0P4048nW0I2?T06@RY01T76@L@4P00030@0000d0000;00030@00018000<1
0000@0030@06U:VD0I<10P001062OH820@0:O@62Ph:3PX>2P`8100^3R8>8
PhR3R063J`020@08RH>9PhT1Q6/40@03RF`100I/00P1K041SjV?0@FY00L1
YJT1:Xh102T000<d0CP00`400jD1Y@02Y@0J0JD1YXh1RJJ9YP6?0Hn:0HZ?
RXl1Sg6?0HX30B4000<10000300000/000<100004`020Cl000L1Z@6DZIBY
00810`000`62PP03PP8101:PPZ22X8:P0J01RH>9PhV3RH<30@07PhV3RH>9
P`030@0<Q8V4RHB9Q05/RFb910401:T0Z@020@>Y00<1ZJT00P400bX10@0Z
0004>041>0<11:D00`6VYP02YP050Hl10JL00P402XnWS`6?T8l1RY030@03
T7H1024000<10000300000/000<100005@000`40000j008100JDZ@6YU:T2
0@@000P1PWf2OH81PP8100R2Ph:30HR3R08100B3R8>80P4028>90@63RH>9
0P4038B90HU/RFb9K8T1K0<101:90@6?ZHnY0JVV0JT1YJVU0JD30BX000Lc
=04h0J@100BU0P402:J>YXh1SjJ?0P401hn:S`6?RXl00`401i01T76@L@40
7`030@d0000;00030@0001H000<10000>0001`40Z@2Y0I@00P400i@10004
00030H:200:200@1PYn20P402Z01X8>PPj230H<20@083XP>R0j80H<20@F9
00H1RHB9Q8T30@0;RVb:K8X10:T0Z@400ZT00`6Y0@03Z@050JT1:P40:`00
13<10CP30@:U00@1YJT10ZH02`6?0HnWS`6?YhnW00<100Z@0I2?T06@MY01
6`040@8000<100002`0000/000<100005`020C@010401:VDZI@30@03T`41
00H00`400gd1PP05PP0B0HR3R8>8PhR30H>9PhV3RH>90P402XB9Q8V4RH@1
K8T30@0KRF`1K8U/R@6YSjV?0JJYYZT1ZJFY0JVU0Hd102/00P404cP1>06U
0JD1YZD1SP6?YP6VSjH00P404HZ?RP6?T8n@0I1a0G6@LI0101H010460003
0@0000/0000;00030@0001T000<10000;@040@0>C0410:T0Z@01ZI@1T`47
000:0Gd10In2Wh:OPP8100RPPj23X8<1R08100@>R0j80P400`j90@06R@<1
012:RHZ9RP6:K8Y/0JT0Z@011:T20@:Y00H1:ZT1:P4/00030C@1008h00l1
Y@6YYJVU0Hl0S`01Yhl00P404JL10Hl1Si2?0Hn@S`5fT7H10180104:0003
0@0000/0000;00030@0001X000<10000:0040@A<00L1U:VDZIBY008100BC
Z@4120000`62I@020@F200h1X041PhR30H>PPj01R@811HT01064RH@20@:9
00T1K8U/RFb90HT00P4038nYSjT1ZJJYYP6UZ@8100BUZ@4Z0P4/008100@d
0CPh0`400jJUYP020@0ISjJ?YP6V0JH1T8n@0I2?T8l1LI01T76@0@0>00@1
3P000`40000;00002`000`40000K008190040@06C6E<IDaU0`401@2Y0:T0
008100BDZ@412P000`62O@030@0JPYl1X8:PPP630HP>R0j83P4>R@j93XT>
0HT20@0:RHZ9RP6:RHZ9RP@100JY0:T0Z@44Z@090JVVZ@6Y:P6U0081;@00
1@4h=04h008100bY0JT1Z@40S`2?0Hl20@0B006@Si01T8n@0I2?0GJ@MY01
2@040A<000<100002P0000X000<100007P000`40000L00D100AVI@5<1`40
1Hl1U:VD008100>Y0@400P4;00040FF20@:20`403h:PPZ220H>PPj23X04>
0@07R@030HV900F900<1R@400P404XX1RP6YSjV?0JJYYZVV0JFYY@8100>Y
0BX00P4]0081010h=04h0JD1Y@6?Z@6VSjJ?0P404i2?0Hn@S`6?T8l1LI1a
0G6@L@401@040AL000<100002P0000X000<100007`000`40000G00@100AV
IFIU1@4034aVC6I<0JT0Z@6Y0@:Y0P400i<10@0<000=0Gf20IZ2VP6PPZ22
X0030@073XP>R069Y@020@03R@j9008100RV0HZ9RXV:R@8100B:RHZ90P40
1P2Y0:T00@BY00X1YZVV0JD1:P6U0P4^0004>04h0@8h00`1Y@6VZJJY0@2?
0Hl20@0B08l1Si2?0Hn@S`6?T06@MY1f1@4K00030@0000X0000:00030@00
02000P4A00H100AUIVEV10403VI[0FI<ITaVC06?ZHnY0P401iBYU06CZ@40
3P020@04PP62PP<100J2X881R:020@0:P`683XP>R0690@B900@1RHV90P40
78T15HXERQD1SjV?Z@6YYZVVZ@6YYJT1ZJD1YBX20Bh000D1=04h0@02>00;
0JH1SjV?0Hl1SiD00P4048n@S`6?T06@Si01T76@0I030Al000<100002P00
00X000<100008P000`40000800H100J3IX=V0FD40@08JfI[IV/1IT`50@06
Z@2Y0:T10jT20@03Z@4000l00`401H:JPP6200<11J006P69YHVURJF90HVV
RJJ9YP6:0Hn9S`6:RHZ90P401@2Y0:T100BY00/1ZJJYYP6UZ@4ZY@020Bh0
00P1<`4d>04h0@:Y01L1YZVV0Hl0S`0108l00I2?T06@Si01T0030@04UGNE
0Ah000<100002P0000X000<100008`020@801P402FF3IH=UPfF3I@030@08
IV]VJfI[IV/40@09CFI=0HnYSjV?008100NYU04Z0I<1014000<1I@400X80
2P6OPYl1X8RPR:020@08R0j83XP1R@46R@0<0HZ9RXV:0HXERP6Y0P403hl1
YZVVZJH1YJVUZ@6YY@030@03Y04002d00P400c<1=003>00;0JVV0Hl1S`6?
UHl00P402I2?T06@S`6?T0030@07T7L1Mi1gT00N00030@0000X0000:0003
0@0002<01043P`080H=VPfJ3IX<40@07J`5VJfI[IP040@0?Q05[IV]V0JT0
Z@2Y0JT100:Y0P400i<10@0B00030FD1008100>2Wh800P43X00?0JFP0HVU
R@69YHT1RJJ9008100RV0Hn9ShT1R@<100>V0:H00`44Z@080JVVZ@6YYJT3
0@03:P4102d000P1<cPc>3@1>0810ZT01`6?0040S`000P401Xl0S`6?T0<1
00^ET05gU@6EMiEg0@0M00030@0000X0000:00030@0001l010402fZ3JX=Z
PfZ30H=U00@100R3Jh=[Pf/1IP<101IVJfI[IP5=ITd1SjV?ZHl1YZT1Z@6Y
0`4C00040FD1PP8101j2W`6P0J280HP>R0680HVURJF90HT1RHn9S`6:RHX2
0@095@6?ZHnYS`6?008100ZY0JVUZJD1YJT10ZD0106T0@4]00<100<d0CP0
0P42>08100f?0Hl00IF?0Hl1Si2?008100nEM`5gU@6@Mi01T7N@M`407000
0`40000:00002P000`40000L00<138<30@09Jh=[Pf^3Jh=[00<100Y[Q6^4
JhA[Q05[0P401ZT0Z@2Y0@>Y0P42Z@030I<101@000X1PP620In2W`6P0P40
5J2UX:FP0HVURJF9YHT1RJJ9YXT1R@020@0=ShX10@2V0:H00JVVZ@030@09
ZJJY0JVU0JFY00<100>T0@00;0000c4d<`020@0AE05J>06D0040S`010040
0@000P404I01T9D1UI2E0IEgU@6EMiD101`000<100002P0000X000<10000
6@030@0;Ph810H=ZPfZ3JX<0104026^30H=[Pf^310402F/1IV]VJfI[IP05
0@0=SjV?ZHl1YZVVZ@6Y:P030AH000@1I@620P402X81Qj013XP>R0h30@0A
YHVUR@690HV?RHn90HV?RHl00P4038nYSjT1ZHnYSjT1YP<100BYYJT10ZD3
0@03Q`4002`00S<00`4c0@02>00:0CPh0Hl00@2?008101N?U@6ET9D1UGNE
0IEgU@6@Mi01T7N@0@0L00030@0000T0000900030@0001L00`47P`030H>3
00@100V8PhR3R8<1Jh<00`402HV3RH>9P`5[Q0040@0:K8@10JT1Z@2Y0@BY
0P400jT1:P020AL00P400h81PP020@03X9l1008100JPY@6U3ZD20@08R@6>
YXh1RJH20@0QS`6:ShZ?0@2V0:H1YZVVZJH1YZVV0JFYY@6UZ@6U0J@102d0
014a0@4h=04h0CQJ0@2D0040S`040@0FU@6ET9D1UI2E0IF@U@6EM`5gUGNE
0A/000<100002@0000T000<100005@020@0:Ph:3PX>2Ph:3PP<100U[Pf^3
Jh=[Pf/0104028A[Q6^4JhA[10401XA[Q6^4J`8100ZY0JV?0JJYYZVV0P40
0jT10@020AP00P401fD1PP67X0400Z009`680HVURJF90HVVRJH1S`6?RHl1
ShV?0JV?ZHnY0JV?ZHl1SZJ>YP040@>U00H1Y041X`4/008100@d0CP10SP0
2@4h>040S`6?00020@0HT9F@U@6ET9D1UGNE0IEg0GN@M`5gT7L16`000`40
000900002@000`40000D00030H:P00811X<20@03Pj23008100>8PhP01040
2H>9P`63RH>9P`030@09Q8T1Q6b4K8A/008100<0Z@000P45Z@050JT10JT0
0P4J00<103670@6O0J2TX04>Y@jU3P6U0HjVSZH1YXnVSjH1ShX1YP2V0:H1
YZVVZ@6YYZVV0JJY00<100FY0JD1Y0020BT01@403C<1=04hE05J>5X109@0
0P406iD10I2ET06@UI2E0IF@0I2ET05gUGL1MiEg0@0J00030@0000T00009
00030@0001<000H1PX>2Ph820@0;Ph810HR3R8>8PhP00`402hV3RH>9PhV3
0F^4008100Q[RF^9J`5[Q0D1012YSjV?0JJYYZVV0JJY0JVU0P4K00040H81
PP<10j030@0WYHVU0JF90HVV0JH1ShV?R@69S`6YSjV?Z@6YSjV?0HjVSZH1
YZD100:U0P401JBU0J@102D0104300070C<10CPc0@02>0030CPh00<101j@
0I01T06@UI01T9F@0GNEM`5gUGL1Mi01T7N@M`4I00030@0000T000090003
0@00018000T1PZ22X8:PPZ000P4028>PPj23X8>P0P402XP1PhV3RH>9PhT3
0@07RHB9Q8V4R@030@0;RFb9K06Y0:T1YP400jT00`6YZ@020@03:ZT101d0
0P402881Q`6PY:010ZD04@6U0JJUYP6V0JJ?YP6VSjJ?00<101JV0:H00JVV
ZJJY0JVVZJH1YZT1YZFV10400j@10@0O00D11`004@4c0@4d>05D>04hFSP1
T9F@008101ZE0IF@UI01T9F@0I2ET06@U@6EMiD1UGNE0AT000<100002@00
00T000<100004@020@09Ph:3PX>2P`68008100F3R8>8P`020@0:RH>9P`63
RH>9P`8100R9P`5[RF^9J`8101B90HU/RF`1SjV?Z@6YS`6VZ@6YYP8100>Y
0@407@030@03PP41008101FP0JFPY@6URJF9Y@6VRJJ90HV?RHl00P4058nY
SjV?0HnYSjT1YXjVSZH1YZD10jD01`6UY@6TX0406`040@/000P1<C<1<`4c
0@8h00P1>3Ph0IF@U@8101^@U@6ET9F@0I2ET05gUGL1MiD1T7N@0I1gT040
60000`40000900002@000`40000A000=0Il10H:PPZ01X8>PP`020@0=X041
R0j83XP>R063R@020@F900<1Q8T00P44R@0?0HU/0JT0Z@01ZJJY0JT100:Y
00<1ZJT00`4N008100F70Il1Y0020@>U0P401:JUYZD20@06YXnVS`6?0P40
6ZL10:H0YP01ZJJYYP6VZJJY0JVVZ@6VYJH10ZD50AH0104?000C0C4c0CP1
>3@1>5@1FSQJ0IF@U@020@0KT9D1UI2E0IF@UI01T9D1UI2E0IEg0GNEMiD1
01L000<100002@0000T000<100004@001062PX820@0CP`68PXR2R8:80HV3
RH>9PhV3R@030@07RH>9PhV3R@030@0MRFb9K8U/0F`1SjV?Z@6YSjV?Z@6Y
YZT1ZJD1Y@407`030@0FPP67X06UX:D1Y@6UR@6>YP6VRJJ90@>?01D1SjV?
ZHl1SjV?Z@6VSZJ>0JFVY@401:D01@6UY@6P00<14@040A<000<1<C<00S<0
104c>042>0030CPh008h0201UI2E0IF@U@6ET9D1UI2E0IEgU@6EM`5gT7L1
Mi1g0AL000<100002@0000T000<100004@00406OPYn2W`6PPj23X8>P0@h2
0@05R0j83XP00P400`j90@05R@810XT00`69R@03R@@100h0Z@2Y0JJYYZT1
Z@6Y0@>Y00<1:P4080040@0<Y9l10JD1YZFV0JH10ZH08`6?YXl1S`6?Y`40
YP2V0JJYYZVV0JJYYZT1ZJJY0JJUYZD100:U00<1YJ000`4<00@15P050@0@
>04h=04hE3P1>5Xh0I2ET08101^ET9D1UI2E0IF@U@6ET9D1UI01MiEg0GNE
M`405P000`400009000020000`40000B00030H:200>20`402H:8PXP1X8>P
P`020@0;R@41R8V8RHP1PhT00P44R@040HU/R@8101PE0@6YSjV?0HnYSjV?
0JH1YP6UZJD1Y@4Q00<100B7X06T0P44Y@0R0JJ>YXh1R@6?YP6?0JV?ZHnY
0JV?ZHl1SZJ>YXh1YJJU0@BU00X1YJFU0J@1Wh811`040AX00P400c<1<`02
0@03<cPc00<h00<1>3P00SP08@6@U@6E0IF@0I2ET9D1UI2E0IEgU@6EM`5g
T7L1Mi1g0@0F00030@0000P0000800030@00018000T1Wh:OPYl1X8800P40
4Z013XP>R0j83P4>R@j93XT>R@811hT30@0CRXV:0@2Y0:T00JVVZJH1YZVV
0@03Z@040JD10B4000dc0@41W`6TY@6VYJJU00811:H01@6?YhnW024100BU
0J2O0P400`010@020A`00P401c41<`4c0C@01P401E@hFSQJ008101n@0I01
T9F@0I2ET06@UI2E0IF@0I2ET05gU@6EMiD101H000<10000200000P000<1
00004`020@:20101X8:PPZ01X8>PPj23X04>0P4018R9R8T20@03R@4100F9
0P4051F95HTE0HnYSjT1ZHnYSjT1ZJJY0P401:FY0BX20B800`401:01Y:02
0@:U02d1YJH1YXh1S`6?YXnV0JJ?YXnV0JJ?YXl1SZJ>YXh1SZJ>0HVVRJH1
YHVU0@h0204N00@100`a<`4c0CP1E3P1>5@90@0NUI01T9F@0I2ET06@UI01
MiEg0GNE0I1gT06@Mi015@000`400008000020000`40000C00030H810081
00F2X8:PPP030@0;R0j83P4>R0j80HT00P401Pj93XT>0@:90P401XZ90HV:
R@8101@0Z@01ZJJYYZT1ZJJY0JT1Z@6YY@818`040@0OY:D1:P6V0JVVZ@6V
0JV?0HnWS`6?ZHnYS`6VZJJY0@05YP0;0JJVYP6VYJJUYP400jD02@6UX067
X8L1O@020A/01@42<`0b0C<1=04hE05IE5T1FUAJE06E0I2ET06@UI01T9F@
0I2ET06@UI01T9D1UGNE0IEgU@4D00030@0000P0000800030@0001@000`1
PX81X8:PPZ01X8<20@09X04>R0j83XP100R90P45R@050AF90JT00P403Xl1
SjV?Z@6YYZVV0JFY0P401:DZ0@4S00@100>TX0400ZD0>06VYJJUYP6VSjJ?
0HnV0JJ?YXnV0JJ?YXl1SZJ>YXh1SZJ>YP6VRJJ90HVUR@683XP1PZ220FF2
0P4F00H100@a0C410S<03`4h0E@hE05D>04hFCQI>0030@0NT9F@0I2ET06@
UI01T9F@0GNEM`5gU@6@M`5gT7L150000`400008000020000`40000D0003
0IZ200<103^2X06PR:28X04>R0j83XP1R@693XT>R@h1YP6:RHZ9RP6:0@2V
0:H1YZVVZJH1YZVV0JJYYP6UZ@4Z0@0T00H100<ZY@400P405jJY0JT1ZHnY
S`6?0HnYSjV?0JJYYZT100FV00<1YZH00ZH01P6UYZFV0@>U00@1YJ2U2`4B
00P101Dc0@41>3<1=04hE3P1E5UD0EAJE5X00P4089D1T9F@0I2E0IF@U@6E
T9F@0I2E0IF@0GNEM`5gUGL14`000`400008000020000`40000E00050H:2
0H800`401H>PPj2300<100R83XP>0@j90@>90P43R@030HV900:90`4018nY
SjT30@0;ZHl1YZVVZ@6YYJT00P400jD1Y0020B<00`400jB70@02Y@0=0JVU
0JD1SjT1YXnVS`020@0OYXnVSjH1YXnVS`6>YXjVSZH1YXjV0JJ9YXT1RJF9
Y@030@063XP1PXR20P400h9U0@050@/02@400c41<`020@8c00l1>3<1>5@1
E3QD0EThFCP00P408IF@0I2E0IF@U@6ET9D1UI2E0IEgU@6EM`5gT7L1Mi1g
0@0B00030@0000P0000800030@0001D00101PYX1Wh:O0J28X8RP0JFP0P40
4@h1YHVUR@690HVVRJJ90HV:008101J90JH0YP01ZJJY0JT1ZJJY0JVVZ@6Y
0P401:DZ0@4T008100>SY0400P402jVUZJD1YZVVZ@6Y008100j?0HnYSjV?
0JJYYZVV0@FV00`1YZJV0JFVYJJU0JD30@09R0j83XP1Pj2300<100AUPVF2
3@400d`10@030@0I<@4c<@4cCP4h<`4dE05D>05DFE@1E5YDFP020@:E01l1
UI2E0IF@U@6ET9D1UI2E0IF@U@6ET05gUGL1MiD1018000<10000200000P0
00<100005P001P62PP6OPP<10123X06PR:28X04>R@j93XT11hT20@0=RXV:
0JV?ZHl1SjJ?YP020@0=YZVV0JFYY@6UZ@6UY0020B@00`40;HL1Y06UZJD1
S`6?ZHnY0@2?006VSjJ?YP6VSjJ?YP6VSZJ>YP6VSZJ>0HVVR@030@0:R@j9
0HP>R0h1R0810X<20@03I@4100=U00D1IDaU0@02C08100M<0@41C@4a0081
00<a0C<00S<40@0?>3<1>5@1E3QD0EThFCQI0081026@U@6ET9D1UI2E0IF@
U@6ET9D1UGNE0IEg0GN@0I1gT0404@000`40000800001`000`40000G0009
0IZ20H:OPP6O00<100FPYJ2UX0020@06YHVUR@690P400jJ9YP020@0AR@69
YP40YP2V006YYZVV0JH00`401jJYYZT1ZJD00P400bX10@0T00030CP10081
01dZ0@41Z@6YYP6VZ@400@2?0HnYSjV?0JJYYZVV0@05YP030JJV00:V00l1
YP41RJH1YHVUR@683XP00P401XR3R8>8P`<100=UO@400fD0105UC6D40@==
0P406Ti=0@5><`5>E4h1=5@1E3P1E5UDF@5JE5YD0P43U@0O0IF@U@6ET9D1
UI01T9F@U@6ET06@U@6EMiD1UGNE0@0A00030@0000L0000700030@0001P0
0`40;in2W`6PPZ01X8RPR068Y@4>R@h1YHVU0HT1ShV?R@690HnYSjT1YXnV
S`6?YXnV008100RUZJD1YJT1Y@<19@020@0W=06T0JDZ0JV?ZHl1S`6?0040
0JJ?YXnV0JJ?YXnV0JJ>YXjV0JJ>00@100^VRJJ90HT>R@h13P020@04PhT1
0@>300@1Jh=[2`402deV0Dd1C@5><Dh100<c00@1E3=D1040<3QD>04hE3P1
>5ThF@6E0IF@U@6ET9D1UI01T9F@0I2ET05gUGL1MiD1T7N@0I1g0A4000<1
00001`0000L000<1000060002P620@6OPP6OX9l30@0WX:D1Y@jU0JD1YXVV
RJH1YXVVRJH1YP40YP2V0JJYYZT1ZJJYYP6V00<100JUZJD1YBX30B@000<1
<`400P400bZY:P020@09ZJJYYP6?08l0008100b?ZHnYS`6VZJJYYP44YP@1
01R?YXl1RJJ9YXT1RJF9Y@4>R@j93XT1P`44P`0?0H=[Pf/1IV]V0DeVC@5=
00<100]=CP5C0Dh1E4iD0@03E08100/hE05IE5T1FUAJE0020@03U@6E00:E
01h1UI01T9F@0I2ET06@UI01T9F@0I2E0IEg0GNEM`4@00030@0000L00007
00030@0001T000`1I@41W`6PPZ01X8P20@0WYHRUR:D1YHVURJD1YP6?RHn9
S`6YSjV?Z@6VSjJ?0HnVSjH1YXjV008100>UZ@400ZD30BD000/1<cP1:ZD1
YZT1Z@020@0DS`6?08l00JJ?YXnV0JJ?YXnV0JH30@0@YP6VRJJ9YP6VRJJ9
YP4>R@8100R90HV3RH>9P`<100Q[Pf/1IV]V0@AV00@1ITeV0P404de>C@4a
0Dh1<`4cE3<1DeAC0E@00`40;SQD>04hFCQI>06@U@6ET9D1UI01T9F@0I2E
T06@UI01MiEg0GL1Mi1g0GN@M`4?00030@0000L0000700030@0001X000<1
PP400`403:2O0J2TX04>Y@jU3P<10269YXT1SZH1YXVVR@6V0:H0YP6VZJJY
0JVVZ@6YYZVV0JD00`400jDZ0@020BD000Lc>04h0JT100>Y01@109@0U06?
08l1SjV?ZHl1YZVVZ@<1016VSjJ?YP6VSjJ?YP6VRJJ9YP020@04R@j93P81
00N93XT1Q8V400D100U[P`5[IV/1ITd00`4014e/CF`20@09CU=>0DiDCU@1
00=D00l1FEAI0EUDF@5JE5YDFP400iD08@6EUID1UI01T9F@0I2ET06@UI01
T9D1UI01MiEg0GNE0@0?00030@0000L0000700030@0001/00P42PP070H:P
PP68X0030@0?YHRU0JF90HT1RJJ9YP6?008101V?ZHnYS`6?YXnV0JJ?YXl1
SZJ>YP6VYJH100:U00@1X04190020@0I=04h0JVVZ@400@2?08l1S`01YXnV
SjH1YP030@0EYP6VRJJ9YXT1RJJ9YXT1RJJ9YXT100N900`1P`63RH>9P`5[
Q6/90@0ECF`1CTe>C@5>Ddh1CP4cE05DDe@100AD0`401cQD0EThFCP00P40
99F@U@6ET9D1UI01T9F@0I2E0IF@U@6EMiD1UGL1Mi01T7N@0@h000<10000
1`0000L000<100006`0010620HL30@07X06TX06PY@030@BU0281SZJ>YXjV
0JH10:H0YP01ZJJYYP6VZJJY0JVVZJH1YJVU10400jD10@0T00030C@c008h
0`401:T1U0020@0:U02D0Hl1SjV?Z@<101FVSjJ?YP6VSjJ?YXl1SjJ?YXl1
RJH00P406hT1R@j93XT>R@64RHB9Q8T1RFb9K05/Q6b40@04K0030De/00<1
00UCCP5CKE<1CP400e@0205DFEAI0G5D0`401eAJE5X1U@400iD08@6EU@6@
UI01T9D1UI2E0IF@U@6ET9D1U@6EMiD1UGNE0@0=00030@0000L000070003
0@0001`000H1PP620Il20@0<R:280J2UX069YHVU0P408HVVRJH1YP6YSjV?
ZHl1SjJ?YP6VSjJ?0HjVSZH1YZFV0@02Y@030J2U00817`040@0A0041<`4d
0I@1S`2?08l1S`000`408JH10@6V0JJ?YXnVS`69YXVVRJH1YXVVRJH1YP6:
RHZ90@05R@0G0H@10HV3R@64JhA[Q05/Jfa[0De/CF`00`402Fa>K05C0EA>
E0020@05DeACE0400e@01P5IE5UDF@8100<hFCP00P409ID1UI01T9F@0I2E
0IF@U@6ET9D1UI2E0IEgU@6E0I1gT06@M`403@000`40000700001`000`40
000M008100B20HNO0P401Z2T0JFPY@810ZD02@6VY@6>YXh1S`040@0I0:H1
YZVVZJH1YZVV0JJYYZT1ZJFYY@6UYP040@03W`4001T01045008c00<h0@40
0P401i@10@2D09@00P40;IF@0@6VSjJ?YP6VSjJ?YXl1SjJ?YXl1SjJ?YXnV
0JJ9YXVVR@693XT1RHZ9RP020@0=Q05/RFb90HA/Q6b40@03K08100ECK5=/
D`020@06KE=]Dfd115@0305DFE@1E75DLE@1E0D10YD0106EU@43U@0M0I2E
0IF@U@6ET9D1UI2E0IF@0I2E0IEgU@6EM`4030000`40000700001P000`40
000N00080FD1PP620HL30@0DX:FP0@h1R@69YXT1R@69YP6VSjH50@0BYXl1
SjJ?YP6VSZJ>0JFVYJH10ZD00`6PY@020@03Q`4001@0104900<100Lh0CPh
0I@0008103>?0Hl1SiD1YXnVSjJ?0HnVSjJ?YP6VRJJ9YXT1RJJ9YP6?0HZ9
RXV:R@690HB9Q8V4RH@010402XA[0F]/Jfa[0Dd20@0?K05/CVa>K05DCUA>
E05D008100=C0E@00e@02@5IE5UDF@5IE0040@0WUI2E0IF@0I2ET06@U@6E
T9D1UI01T9F@0GNEM`5gU@6@M`5gT7L100`000<100001P0000H000<10000
7`003P620@6OQ`6OX06UX:D10ZD04`6UYZFVY@6?YXl1SjV?ZHl1SjT02P40
3:JY0JVUZJD1YJJU0@:U104@00@13@030@8h00H1>041U0020@0MT9F@0I2E
0JJ?YXnVS`6?YXnVSjH1YXnVSjH1YXl00P405jJ9YP6VRJJ9YXT1RHZ9RXV:
RHX1RXB:00X101=/KF`1DfaCK05a0FeCKE<1E75D008100UIE5UD0EAaE740
104015AbE044U@040IFE0@>E01`1T9D1UI2E0IF@0I2ET06@UI01T05gUGL1
MiD130000`40000600001P000`40000P008100J20Il1WhL20@05Y@6U3ZD0
0`401:J90Hh20@0DYP6VSjJ?YP6VSjJ?0HjVSZH1YXh:0@07Y@6UX067X002
0@/0104@00<100@c0C@10SP30@06UI01SiF?0`4058nVSjJ?YP6VSjJ?YXl1
RJJ9YXVV0P403HV?RHn9S`6:RHZ90HT00P403HV4RHB90HU/RFb9K0401F`0
0`5/K003K00A0Dh10FeC0DiDCP5CE5=DD`4015@50@07F@5IE5UDF@020@0W
T9F@U@6ET06@UI01T9D1UI01T9F@0I2ET05gUGL1M`5gT7L1Mi0100/000<1
00001P0000H000<100008@030@06Qil1X06T0P43Y@060JFV0JH10jH20@0;
SjV?ZHl1SjV?Z@401:H00`6VYP02YP080JJUYZD1YJH70@04Y0410@D0104D
008100<c0@400SP0204h0I01T9F@0P40:IF@U@6VSjJ?YXl1SjJ?YXnVS`6?
YXnVS`69YXVVRJJ90HVVRJH1RXV:008101J9RXT1Q8Z4RXB:0HY/RVb:0Fe/
KFa]0P403faaK75/0E<1E75DLE@1E0050@0>E75DLE@1E79DLU@1U@43U@05
0IFEU@400iD0706@0I2ET06@UI01T9F@0I2E0IF@0GNE0IEgU@4:00030@00
00H0000600030@00024000h1<`41PP670J2T0JD>0@BU02X1YXjVSZH1YXnV
SjH1YXnVS`6>YXjV0JJ>YXh1SZJ>YP6URJD1YHRU0J030@03PP4100<16000
0`4a<`020@03=3P1008h01d1T041UI2E0IF?U@6VSjJ?YXl1SjJ?YXnV0JJ9
YP020@0CR@69ShV?RHn90HV:0HZ9RXV:R@030@08K8U/RFb9K045K0030Fa/
009/0P402e=]DfeCK@5D0EAC00D1019D0E@1E5UDFEAI0EUDFE@1MiD20@0V
T9F@0I2ET06@U@6ET06@UI01T9D1UI2E0IEgU@6E0I1gT06@M`4:00030@00
00H0000600030@00028010401HL1W`6P00@100BVYJJU0`42YP8100^?ZHnY
S`6?ZHnY0@04YP030JJV00:V00l1YZFVY@6UYZD13ZD>Y@400Z040A/000P1
<c<1=04h0@8h01X1UI2E0IF@U@6ET06?YXnVSjH1YXnVSjJ?YP<101NVRZJ:
0HVVRJJ9YXT1R@69RXV:RHZ9RP020@0>Q8Z4RX@1K8Y/RVb:0Fd30@09L@5a
K75/LFaa00@100MDL@5aE75D008100]aE75DL@5bE79DLP020@:E0P43U@04
0IFE0@>E01`1UI01T9F@0I2E0IF@U@6ET9D1U@6EMiD1UGL12@000`400006
00001P000`40000S00D100JO0J@1YJ@20@>U00D1YXh1SP020@0XYXnVSjH1
YXnVS`6>YXjVSP6>YXjV0JJ>YXh1RJF90HRUR068X8P1PP<160020@08<C<1
=04h=042>00e0IF@U@6ET9D1U@6VSjJ?YXl1SjJ?YXnVS`69ShV?RHn90HV?
RHn9ShT1RHZ9RXV:RHX1RV`010400hT1K002K0D100QaK75/L@5]D`@101ea
0EACE5<1E75DLE@1E5UDFE@1E5UDFE@1M`5gU@020@0VT9F@0I2E0IF@U@6E
T06@UI01T9D1UI2E0IEgU@6E0I1g0GN@M`4800030@0000H0000600030@00
02@00P402X810@6P0JBU0JT30@0BZJJYYP6?0HnYSjT1ZHnYSjT11JH00`6V
YP02YP0;0JFVYJH1YZFV0JD03@4D008100@a0@4c0S@013P1>042>08100NE
T9D1UI2E00<100^VSjJ?YXl1SjJ?YP020@0AS`6:YXZVRZJ:0HVVRJJ90HT0
0P403HZ9RXV:R@69RXV:RHX01@4028Y/RP5aK75/1@404F`10G5]0EAaE05D
LEAaE05D008100eaE741LUAbE781UI0100:E0P43U@040IFE0@>E01/1UI01
T9D1UI2E0IF@U@6ET06@0GNEM`5gU@4020000`40000600001@000`40000V
008100=Z0@400P400jFT0@03Y@0T0HjVSP6?0HnVSjJ?0HnVSjJ?0HjVSZJ>
0HjVSZH1YXjVSP6910402@j83P6PPj230@03PPH130060@09<`410C@c0C@1
00<h0P400iF@U@020@0TT9F@0HnVSjJ?YP6VSjH1ShZ?RP69ShV?RHn90HV?
R@69RXV:0P404hV:R@5/RVb:K8Y/RP6:K8Y/RV`01@408Faa0FeC0E=aDg5C
0E<1E75DLEAa0G5DL@5IE05DFEAIE0020@05UGL1MiD00P409I2ET06@U@6E
T9D1U@6ET9D1UI01T9F@0GNEM`5g0GN@M`5gT0401`000`40000600001@00
0`40000W000<0HL10Il1Y:D1ZJFY0`404:T1Z@6YSjV?Z@6YSjV?Z@45YP03
0JJV00:V00<1YJH0104038VVR@69YHVU0@j83P@118860@<02`401c410CP1
>0400SP01@4h>06E008100j@UI01T9D1YXnVSjJ?YP<101RVSjJ?YP6VRZJ:
YXZVRP690HV?RHn9ShT20@0=RP6:RHZ9RXV:R@5/RP050@07LFaaK75/L@02
0@0DKG5]LFea0G41LEAaE741LEAaE7430@0;LUAbE781U@6ET0400YD20@>E
00@1UID10iD06`6E0IF@U@6ET06@UI01T9F@0I01MiEg0GNE0@0700030@00
00D0000500030@0002L00`400h810@030@:U01`1ZJFY0JJ?0HnVSjJ?0HnV
SjJ?0HjVSZJ>0HjV1@403ZJ9YP6URJD13XP>R0630P401XR30@62I@8100>2
I@403`400c41<`020@07<`410C@h0@03>00^0IEg0I2ET06@U@6VSjJ?YXl1
RXn:ShZ?RXl1ShV?RHn9ShT1RHZ9RXV:RHZ9RP<100J:K8Y/RV`40@0:RVb:
K05/LFaaK0<102ICLE=aDg5CL@5aE75DLE@1E75DLEAaE05DFEAIE05gU@6E
M`5gU@8102B@UI01T9D1UI2E0ID1UI2E0IF@0I2ET05gUGL1M`5gT06@M`47
00030@0000D0000500030@0002P01@42Y08100FU0JJYYP040@0<ZHnYSjT1
ZHnYSjT10ZH60@0AYXl1SZJ>YXh1RJJ9YP6URJD00P401X<>P`j33P8100AU
PP410fD0105<I@42C0@100<a0@400`401S<1>05D>08113P03`6@UI01T9F@
0I01SjJ?YP020@0CS`6?YXnVSjJ?YP6VRZJ:YXX1RP020@0;ShV?RHn9ShT1
RHX01`402HY/RVb:K8X1L@040@0OKG41LFeaKG5]L@5a0G5DLE@1E75DLEAa
E05a0EAbE0020@07UGNE0IF@0@02U@810iD0106EU@43U@0E0ID1UI2E0IF@
0I2ET06@U@6E0IEg00D11P000`40000500001@000`40000Y00@10Z@04`6U
0JFYY@6?ZHl1SjJ?YXl1SjH01P405HVVR@69YXVVR@69YXVVR@69YHT1R002
0@06RHP1PhR30P42P`@10VD00`5<I@050@03C@41008100`a0C41<`4c0C<h
0E@40@09>041UGL1T9F@008102:VSjH1ShZ?RP6:ShZ?RXn:S`6?RHn9S`6:
RHX1RXV:RHZ91@400aF:5@0<0@0PLFaaK75/L@5aDg5CL@5aDg41LEAa0G5D
LEAaE741LE@20@0<F@6E0IEgU@6EM`5g0P406YF@U@6ET9D1UI01T9D1UI01
T9D1UI2E0IEg1@4;00030@0000D0000500030@0002T00P401XNT0J@1:P<1
00ZY0JVVZ@6YSjV?10406JJ?YP6VSjJ?YXl1SjJ?YP6VSZJ>YP6VRJH00P40
48T>R@j90H<1PhV3R@64Jh@60@03IV/1009=1@403c=>0C<1>05D>04hE05J
E0020@04U@6ET08100>ET9D00`406JJ?YXnV0JJ?YXnVSjJ?YP6VRZH1ShZ?
RXl01`407XZ9RXV:RHZ9RP6:LHYaRW6:0G5]LFeaKG5]0FeaK@8101EaKG5]
0EAa0G5DLEAaE741LW5bLG800`402YD1UGNE0IF@0ID20@>E00@1UID10iD0
306@0I2ET06@U@6ET0<140000`40000500001@000`40000Z00D10ZD00`6U
Z@020@05SjV?0Hl00`406Xl1SjJ?YXnV0JJ9YXVV0JJ9YXVV0JJ9YXVV0`42
R@060HR9R8V80P44P`0>0F^3J`5VJfH1CFI=0D`20@06CS410C<a0`40;c<h
0CP1E3P1>5@h0GNE0IEgU@6ET06:ShZ?RXn:S`6?RXn:ShZ?RP69S`6:RHZ9
00D104N9RXT15HXERQF:5HXE0Fb:K8Y/RV`1K75/LFaaK741LE<1Dg5CLE=a
D`5D0EAaE75DL@5aE75DLEAa0G`1U@6EMiD1UGL1M`020@0?UI2E0IF@0I2E
T06@0I2E00H14`000`40000500001@000`40000[00@100FU0BZY0@02Z@81
01nY0@6?YXnVS`6?YXnVS`6?YXnVS`6?YXnVS`6>YXjV008100Z9YXVVR@69
3XT10XT20@0?P`5[Q6^40H=VP`5[IP5=008100Q>CDh1CS<1<`8100/h<`4h
0CQD0EYDFP020@0MT9D10I2E0IF@0HnVSjJ?YXnV0JJ?YXnVSjJ?0HX01@40
1HZ?RXn:00<101b9RXV:RHZ9RXV:0HYaRW6:LHX1LFeaKG5]LFea0P409fea
KG5]LFeaK@5DLEAaE75D0G5bLG9aLW41MiD1U@6EMiD1UI01U@020@>E00@1
UID10YD50AT000<100001@0000D000<10000:`000c<10@030@07ZJD1YZVV
Z@020@0KSjJ?YXnV0JJ?YXnV0JJ9YXVVR@69YXVVR@69008100>?R@401HT0
20680H>9PhV30`4026^30F]VJ`5V104014d1<Dh20@0B<C<1Dc<1<cP1>05D
>5@1E3QD0`401IEg0GNE0081012@0HZ?RXn:ShZ?0Hn:ShZ?1@402hZ9RXV:
RHZ9RXV:008101XERQF:5HXERP6:K8Y/RVb:K8X1LFaaK75/L@8101UCLE=a
Dg5CLE<1K@5DLEAaE05DLEAaE75D008100ilMg`1U@6EMiD1UGL1M`8100>E
T0401@4N00030@0000D0000400030@0002d00`400j@10@030@:Y01`1006V
SjJ?YXl1SjJ?YXnV0JJ?YXnV0JJ?YXnV0P4038VVRJJ90HVVRJJ90@F900@1
Q8V42042K0080De/C@5=0Dh20@03E3=D0081020c0CQD0E@h0EAJE05gU@6E
T06@UI01T06?YXnVSjJ?YPD100BVS`6:0P4038n:ShZ?RXn:ShX1RP@101>:
RHZ90G6:LHYaRW6:L@5]LFea00<100V:0G5]LFeaKG400P42L@0O0G5DLEAa
0G9aLW5bLG81O06EMiD1U@6EMiD1UI01U@030B@000<100001@0000@000<1
0000;@002C<10JD1:P6YU0030@0IS`01YXnVSjJ?0HnVSjJ?0HVVRJJ90HVV
R@020@08S`6?RHn9S`43R@8101R90@69PhT1RF^9J`5[K6]/0FaVK05WCFL2
0@09CU<10C=C0E@c0081010h<`4hE05D>5@1UGNE0IEg0P4029Eg0@6?RXn:
1P402Hn:ShX1RXn:S`020@0>RHZ9RXV:R@4ERQF:5HX30@0=RP6:K8Y/RVb:
K8X1L@030@0MLFaaK741LE=aDg41LFeaKG41LEAa0G5DLEAaE7400P42M`09
0GagO06E0IEg00D100<00@0090000`400005000010000`40000]008d00@1
Y0410jT00`40U0030@0CSjJ?YXnV0JJ?YXnVS`6?YXnVS`030@0ORZJ:0HVV
RJJ9YP6V0HZ9RXV:0HT1RHB9Q05/RFb90@03K0040Fa=K08101E>Ddh1<e@c
0E=DD`4hE05D>05DFU@00P400iEgU@020@05T9D1UI001@408XnVSjJ?0HnV
S`6:ShZ?RXn:0HZ?RXn:S`6?RXn:ShZ?RXl=0@0>RW6:LHYaRW41KG5]L@47
L@0C0G41LW5bLG9aLW41M`5gO06EM`050@L000<100008`000`4000040000
10000`40000^008c1040:ZVD0I@0U001YXnVSjJ?0HnVSjJ?YP6VRJJ9YP6?
RHn9ShT1RHn9ShV?0@N90P403f^9JhT1K6]/J`5VK6H1C@020@0=K05CCP5>
0C=C0E@cE0020@0:<`4hE05D>5@1U@8100=gUGL01P405YD1ShZ?RXn:ShX1
RP6:ShZ?RXn:ShX20@0VRXV:0HXERQF:5HXERQF:0HXERQF:5HXERP5aK75/
LFaaK741LE<20@0ELFeaKG5]LFd1E05DLEAaE75D0Emg00H130000`40000S
00030@0000@0000400030@0002h000Hc>04Z0JT40@0EU02D0HnVSjJ?YP6V
SjJ?YXl1SjJ?008101RV0JJ:YXZVRP69YXVV0Hl1RXV:RHX1RXT20@07R@69
K8U/0@02K0@116`02`5C0FeC0C<1De@1009D0P402U@h0EAJE5X1UGL50@0L
T9D10I2E0JJ?YXnVSjJ?0HZ?RXn:ShZ?RXn:S`8102::0HZ?RXn:ShZ?RXn:
0G6:LHYaRW6:L@5aRW6:LHYaRW6:0P4;L@090G5bLG9aLW5b00<14`000`40
000R00030@0000@0000400030@0002h000X1<c@1ZI@1U02D1@403HnVSjJ?
YP6VSjJ?YXl00`404XV?R@69ShV?RHn90HV?0HZ9RP810hT01@5/RFb900T1
0V`01P5>K4i/CP8100=DCU@00P403C=D<`5CE5<1>5@h0CP01@401GL10IEg
008100jEM`5gU@6?RXn:ShX1RP8100b?RXn:ShZ?RXn:ShX30@0N5HXERQF:
5HXERP6:5HXERQF:5HXE0FaaK75/LFaa0P4056eaKG5]LFeaKG5]0Fd1E75D
LEAa0P4F00030@00024000<10000100000@000<10000;P00104c=3P70@0@
UI010JJ?YXnVS`6?YXnVS`8102ZVSjJ?YXl1RZJ:YXZV0JH1ShV?RHn90HT1
RHZ9RXV:0HY/RV`1K75/L@44K08100Y]DfeCK@5DDe@10e@60@0LE5X1U@6E
MiD1UGNE0IF@0I2E0JJ?YXl1RXn:S`8100f:ShZ?RXn:ShZ?0Hn:00@101J?
RXn:S`6:LHYaRW6:LHYaRP6:LHYa10400hYa0@08L@810g420@05LW5bL@40
60000`40000P00030@0000@0000400030@0002h00`400c<10@030@0@MiD1
0I01SjJ?YXnV0JJ?YP8101V:S`6?RHn9ShT1RHn9ShV?0HZ9RXV:RHZ90081
00b9K8U/R@69K8U/R@44K0030Di/008100eC0DiDCU@1K@5D0EAC00@100ID
0@4hE3P20@05M`41MiD00P401GNE0IEg00<100^:ShX1RXn:ShZ?RP020@0?
ShZ?RXn:S`6:LHYaRW6:00@100lE0AF:5HXERQF:5HXE0F`00`46L@0D0G5]
LFeaKG41LFeaKG5]L@5aE04J00030@0001l000<10000100000@000<10000
;P080@05T041UI000P401jJ?YXnVSjH00`407JJ?YXl1SjJ?YXnV0JJ:YXZV
0Hl1ShV?RHn90HV:008100j9RXT1K8Y/RV`1K75/L@<100YaK741KE=]0G5D
1@4035@1E75DL@5JE5X1O08100Qg0GNEM`5gU@8102>@U@41S`6:ShZ?RXn:
ShZ?0Hn:ShZ?RP6:ShZ?RXn:ShZ?RP0?0@0;LHYaRW6:LHYaRP401G400`5a
L@07L@030G8101/000<100007P000`40000400000`000`40000_008100Td
0CP1UGNEMiD00P4027L1SjJ?YXnV0P404HZ?RXn:ShX1RHn9ShV?0Hn90081
00>:RHX00P402HV:RHX1RQF:5@030@07K8U/RFb90@02K0<100QCKE=]Dfd1
E0@100MC0E=DDe@100AD0`400cQD0@02M`060GL10IEg0P401IEg0GNE0081
00b:ShZ?RXn:ShZ?RXl20@0NRXn:0G6:LHYaRW6:LHYaRW41LHYaRW6:LHYa
RW4137400`5aK@020@0<LFeaKG5]LFeaKG417@000`40000M00030@0000@0
000300030@0002d00`401C<10@4h008100^@UI2ET06@0HnVS`020@0UYXl1
SjJ?YXnVS`6?YXnVS`6:0HZ?RXn:ShX1RHl1RXV:RHZ9RP0:0@06K8X1LFaa
1@401W5DLEAa0@AD00P1E75DL@5bE0<100=gO7L00P402iD1UGNE0IEg0I2E
00<100b?RXn:ShZ?RXn:ShX20@0[S`6?RXn:ShZ?RXn:ShZ?0HYaRW6:LHYa
RW6:0HYaRW6:LHYaRW6:L@5a0@0;L@817P000`40000M00030@0000@00003
00030@0002X01P401C<10@4d00@100BEMiEg0P40=ZH10HZ?RXl1ShZ?RXn:
S`6?RHn9ShT1RHZ9RXV:RHZ90HT15HXERQF:5@5/RVb:K8X1LFaaK0@1011]
D`41KE=]Dfd1L@5DDe@10e@01P5IE5UDF@<10gL01P5g0IEgU@8100Eg0@6E
M`020@0=ShZ?RXn:ShZ?RXn:S`020@0JLHYaRW6:LHYaRW6:L@5aRW6:LHYa
RW6:L@4<L@8100a]LFeaKG5]LFeaK@4Q00030@0001d000<100000`0000<0
00<10000:0080@06<`41=04h1@400i2ET0020@0FYXnVSjJ?YP6VSjJ?YXnV
0JJ?YXl1RP8100R?RXn:ShZ?RP8100j:RHZ9RXT15HXERQF:5@D100A/0Faa
0P405fea0G5DLE@1E741E05aE75D0EAbE79D008100El0GagO0040@09MiEg
0GNE0IF@00<100f:ShZ?RXn:ShZ?RP6:00@101n?RXn:ShZ?RP5aRW6:LHYa
RW6:LHYa0G6:LHYaRW6:00<100>:0G402G400`40000Q00030@0001`000<1
00000`0000<000<100009`070@0=<@4c0C<h0CP1O7L1M`020@0UUGL1RXn:
ShZ?RXl1ShZ?RXn:S`6?R@69ShV?0HZ9RXV:R@4ERP020@085HXERP6:K8X5
0@05LFaaK7400`403G5/LF`1DfeC0E=aDg400P44E00:0EUDFEAI0GL1M`81
0gL0305g0GNEM`5gU@6EM`@100n?RXn:ShZ?RP5aRW6:LHX00`4058YaRW6:
0HYaRW6:LHYaRW6:LHX117440@Ea00P1LFeaKG5]L@819@000`40000K0003
0@0000<0000300030@0002H00P400fH1C@030@09<`41<c@1>04h008100Ag
0@6E0P408I01SjJ?YXnVS`6?YXnVSjJ?0Hl1RXn:ShZ?0Hn:ShZ?0@04RP81
00>:0@400`402HXERP6:K8Y/RP020@0NKG5]LFeaK@5D0EAaE75DL@5aE75D
0EAbE79D0Emg0P401gL1Mgag0GL00P401IEg0@6E008101J@U@6E0Hn:ShZ?
RXl1ShZ?RXn:ShZ?10404HX1LHYaRW6:LHYaRW6:L@5a00<100YaRW6:LHYa
RW411W400`40000V00030@0001X000<100000`0000<000<100009P000`5=
C0060@0:<`41<`4c0C@1008100Al0@5g0P406Hn:ShZ?RXn:0HZ?RXn:ShX1
RHn9ShV?RHl00P401hV:0HXERQD02@401Fb:K05/00@101Aa0G5/LFaaK741
K@5aDg5CL@5a0@=D00h1FEAIE05JG`5gG`5O0@=g0P403GL1UGNE0IEg0GNE
0ID00P404hZ?RXl1RW6:LHYaRW6:LHYaRW404@4=L@060FeaKG41:P000`40
000I00030@0000<0000300030@0002H000<1C@4010401C<1<`4c008100@h
0CP10`000`6EM`040@0LYXnVSjJ?YP6VSjJ?YXl1RP6:ShZ?RXn:ShX1RPD1
18X01@6:LHYa00D1021aRW6:LHX1LFeaKG5]L@5aE75DL@5aE741L@5bE79D
LP8100EOM`5gG`040@05O7Ml0ID00P4027NE0@5g0I2E0P40<i01RXn:0HZ?
RXn:ShZ?RXn:ShZ?RP5aSg6?LHmaSg6?LHma0G6:LHYaRW6:LHYaRW6:0@02
L@81;0000`40000H00030@0000<0000300030@0002D000H1C041CC420@05
<`4c0C@00P401C<h0CP100<00P400gMl0@020@0@ShZ?RXn:S`6?RXn:0HZ?
RP8100F?RHn9S`050@0NRQF:5HXERQD15HXERQF:5@5/LFaaK75/0FaaK75/
0`402U=aDg41LEAaE7420@0AE5UDFE@1FUl1GeX1GgL1M`400gL20@07M`5g
UGL1M`020@04UGL1M`<101maRW6:LHYaRW6:LHYaRW6:0HYaRW6:LHYaRW6:
LHX100ma0P4_00030@0001L000<100000`00008000<100009P020@07C@5=
CP5><`030@08<`4h0C@1>045008101FEM`41YXnVSjJ?YP6VS`6:ShZ?RXl0
1@401Hn:0HZ?00811XX0506:LHYaRW6:0HYaRW6:LHX1LFea0P43L@0A0EAa
E05DLEAaE741LUAbE7800P42G`080GMO0Emg0G`20@09Mgag0GL1MiEg0081
00>E0ID01`40:hn:ShZ?RXn:ShZ?RXn:0G6?LHmaSg6?LHmaSg41LHYaRW6:
LHYaRW6:LHX00P4`00030@0001L000<100000`00008000<100009P001@5=
K05=008100<a0C<00P400c@1>0030@03>3@100H00P403gL1RXn:ShZ?RP6:
0HZ?RP060@0:ShV?RHl1RQF:5@8101F:5HX1RQF:5HXERQD1K75/LFaaK740
0`40675/LFaa0G5C0EAaE75DL@5a0EUDFE@1@@8100]O0EmJ0EmgG`5O0@03
M`@100>EM`400`4700@101YaRW6:LHYaRW41LHYaRW6:LHYaRW6:LHYa0@Ua
104c00030@0001H000<100000`00008000<100009@00105=K4d20@0@K4h1
0E@c0C<1>04hE04h0@P00`401hnVSjJ?YXl01@401XZ?RXn:S`8100Z:S`6?
RXn:ShZ?0P404HX1LHYaRW6:LHX1RW6:LHYa00<127420@0>E75DLEAaE05a
LP5bE7820@03FUl1009O00`1GgL1Mel1M`5gO7L50@l010406hn:ShZ?0Hma
Sg6?LHmaSg6?LHmaS`6:LHYaRP040CP000<100005P000`40000200000P00
0`40000U00030Fa=008100iCCU<1Dc=C0C@1>05D>0@12@020@03RXl100H1
01J?RXn:ShZ?RXn:0HT15HXERQF:5HXE1P401hXERQD1K7401040:Faa0G5/
LFaaK75/0EAaE75DLE@1E75DL@5I0Em10D5O0EmJ0EYO0GMO00D160040@0C
L@5aRW6:LHYaRW6:LHYaRW41L@040Cd000<100005@000`40000200000P00
0`40000T000>0F`10F`1CVa>0C=D0E@20@08>04hE05JE04900@101:V0@6:
ShZ?0Hn:ShZ?RXn:ShX20@0?ShZ?RXn:ShZ?RP5aRW6:00L100N:LHYaRW41
00Ia0P403W41E75DLE@1LG9aLW5b104015X10El20@03G`4100<18@0C0D80
00<1000050000`40000200000P000`40000T008100I/Df`1Ddh20@04Dc<1
<`8100Ph<`4h0CQD0@@01@42000F0Hl1ShZ?RXn:S`6?RXn:ShZ?RXl1RP81
01lERQF:5HXE0AF:5HXERQF:5@5/LFaaK75/LF`1K75/0081015aKG41LEAa
E741LEAaE75DL@020@03@@5100D1O0000`40000C00030@00008000020003
0@0002@000<1K6`00V`01@5>0E=]008100]CE5<1>5@1E05JE0050@P000X1
ShZ?RXn:ShZ?0P402hZ?RXn:S`6?RXn:008101Z?RXn:S`6:LHYaRW6:LHX1
RW6:LHYaRW6:0@9a00<1LG4017403P5aE741LW5bLG9aLP5O106200030@00
018000<100000P00008000<1000090001@5CK5=/008100=CK5<00P400e@c
E0020@03<`4h00D13000606?RXn:ShZ?RXn:0HZ?RXn:0G6:LHYaRP8101LE
RQD15HXERQF:5HXE0FaaK75/LFaaK0030@0CKG5]LFeaKG41L@5aE75DLEAa
E0020HL000<100004@000`400002000000<00@009P00105/K6`20@08DfeC
K@5DDe@60@05>05DFP403@020@0GRXn:ShZ?RXn:0HZ?RP6:ShZ?RXn:ShX0
0`404W6:LHYaRW6:LHX1RW6:LHYaRP<12W402`5D0G5bLG9aLW4108T000<1
00004@000`400002000000<00@009P002@5C0@5]0FaCK0060@0:DeAC0CQD
0E@h0@l000X1RXn:ShZ?RXn:0P403Hl1RW6:LHYaRW6:LHX01P4021F:5HXE
0Faa1@42L@0;0FeaKG5]LFeaKG400P4025AaE75DLE@1R`000`40000@0003
0@00008000000`01000V008100=/LF`01`400e<1E003E08100Dh0EAJ0@0@
000;0HZ?RXn:ShZ?RXl00P404HZ?RXn:ShZ?RXn:0G6?LHma00P100V:LHYa
RW6:L@401g420@9a00P1LG9aLW5b0H`000<100003`000`400002000000<0
0@009P000`5/0@040@0;D`5CK@5D0EACE0400U@20@03E3P1014000`1RXn:
ShZ?RXl1Sg420@0ERW6:LHYaRW6:0HYaRW6:LHYaRW4100Ya00H1LFeaKG42
0@Aa00L1LEAaE74108h000<100003`000`400001000000<00@008`050@04
K75/L@8100EDLEAa0@04E0030EAa008100=DFP404P003@6:ShZ?RXn:0HZ?
RXl00`407Hn:ShZ?RP5aSg6?LHmaSg6?0HYaRW6:LHYaRW4100=a0P47L@05
0G9aLP40T0000`40000>00030@00004000000`01000O00@10`001@5/KFa]
008100]CKE=]D`5CE5=D0@03E0050E@hE0404P020@0=ShZ?RP5aSg6?LHma
S`020@0@LHYa0G6:LHYaRW6:LHYa0@]a0`4:L@030G41098000<100003@00
0`400001000000<00@006P050@L000<1L@400P402G41LEAaE05]0@02E005
0G5DLE@00`400e@1000C000?0Hn:0HZ?RXn:ShZ?RXn:008101R?0HmaSg6?
LHmaSg6?L@5aRW6:LHYaRW420@aa00<1L@40T`000`40000<00030@000040
00000`01000F00@130020@0?LFaaK05CKE<1Dg5C0E<100AD00<1FE@00P4E
000@0Hl1Sg6?LHmaSg6?LHmaS`D100Z:LHYaRW6:LHX11G440@03L@5a00aa
00<10000TP000`40000<00030@00004000000`01000B00@140003P5aKG5]
LFd1E05]LFea0P402UAaE741LUAbE04F008101::ShZ?RXn:ShZ?RXn:S`6?
LHl60@05LHma0G4010401hYaRW6:L@402W420IH000<100002`000`400001
000000<100003@050A@000L1K75/LFaa008100MCLE=aDg4100AD00H1E5UD
F@4H008101J?LHmaSg6?LHmaS`6:LHYaRW6:LHYa1@4:L@030G5a00Ia0P6I
00030@0000X000<100000@0000030@0000T0104J00050FeaKG400P404Vea
KG5]L@5a0G5DL@5bE79D0AX00P409HZ?RXn:ShZ?RP5aSg6?LHmaSg6?LHma
0G6:LHYaRW6:LHYaRP401G420I`000<100002@000`400001000000<10000
10050Ah000<1LF`00P40375/0E=aDg41LEAa0@9D00D1E5UD0@0M00<101Ea
Sg6?LHl1RW6:LHYaRW6:LHYaRP403740105aLG420Il000<1000020000`40
0001000000<10000104S00<117404@5aKG5]0FeaK@5D0EAbE78102000P40
88n:ShX1LHmaSg6?LHmaSg6?L@5aRW6:LHYaRW6:LHYa0`6R00030@0000L0
00<100000@0000<19`004@5aK75/LFaa0G5C0EAaE75D008100EIE5UD0@0O
00030@000081015a0G6:LHYaRW6:LHYaRW6:0@0:L@@1Y@000`4000070041
0@01000000<00@409`000`5aL@05L@0@0Fd1KG5]LFeaK@5DLUAb0Al000<1
00000P090@0;LHmaSg6?L@5aRW401`6Z00030@0000H00@41004000030081
9@00205aK75/LFaa0P403UAaE75DLE@1E05DFE@17`000`40000;00/1/@00
0`40000600410@0100001@020B@000@1LG5a0`402G41LFeaKG5]0@03L@04
0EAb0Al000<10000b0000`40000500410@0100001`020B8001H1K041LFea
KG41LEAaE05DLEAa0ET180000`40003900030@0000@00@41004000090081
80020@Ma00D1KG5]0@06L@8180000`40003:00030@0000<00@410040000;
00817P005P5]LFeaKG5]L@5aE05DLEAaE75DL@4P00030@000</000<10000
0P010@400@0000d00P4L00030G5a00Ma0P48L@030@0001l000<10000c000
1@4000010080000?00816P002@5]LFeaKG5]L@020@09E75DLEAaE7410280
00<10000c@001040004200004@020AT000<1LG400g420@03RW4100Ia00<1
00008@000`40003>00040@000@40000C00815`00105aKG420@Aa00P1LEAa
E75D0B<000<10000cP001040004100005@020AD000`1L@41RW6:LHYaRP44
L@030@00028000<10000c`000`400@0100005`020A<00P4:L@040G5D0BD0
00<10000d0020@40000I00814@003`5aRW6:LHYaRW6:L@5a0@0V00030@00
0<l00`4100006`020A0000<1LG4027420BL000<10000b@060@@0000M0081
3P00206:LHYaRW6:0`4Y00030@000<<01P4:00007`000`40000;00030G5a
00=a0P4/00030@000;d01P4@000080020@`000<1L@400P4^00030@000;L0
1P4F00008P020@X00P4a00030@000;401P4L000090020C/000<10000Z`06
0B80000V0081>0000`40002V00H1:00002P00P4f00030@000:001P4^0000
:P020C@000<10000VP060C@0000/0081<P000`40002D00H1>P0002h00P4`
00030@0008h01P500000<0020Bh000<10000R0060DH0000b0081;0000`40
002200H1C00003@00P4Z00030@0007`01P5B0000=P020BP000<10000MP06
0EP0000h00819P000`40001`00H1GP0003X00P4T00030@0006X01P5T0000
?0020B8000<10000I@050FX0000n008180000`40001O00H1K`00040000<1
00007@000`40001I00H1M@0004400P4M00030@0005<01P5k0000@`020A/0
00<10000C@060H40001500816@000`40001700H1Q`0004L00P4G00030@00
04401P6=0000B@020AD000<10000>`060I<0001;00814`000`40000e00H1
V@0004d00P4@00030@0003001P6O0000C`020@h000<10000:P060JD0001A
008130000`40000T00H1Z`0005<00P4:00030@0001h01P6a0000E@020@P0
00<1000060060KL0001G00811P000`40000B00H1_@0005T00P4400030@00
00`01P730000F`020@8000<100001P060LT0001M00<10P060Ll0001O00<1
e@000001
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{311, 235.75},
  ImageMargins->{{43, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Index: The Sierpinski Sponge", "Subsection"],

Cell["(* Order: left, right, front, back, bottom, top *)", "Input"],

Cell["\<\
cheese[0, False, False, False, __ ] := {} (* small optimization \
*)\
\>", "Input"],

Cell["\<\
cheese[0, rt_, fr_, tp_, x0_, y0_, z0_] :=
  With[{xs = x0+1, ys = y0+1, zs = z0+1},
    { If[rt, Polygon[{{xs,y0,z0}, {xs,ys,z0}, {xs,ys,zs}, {xs,y0,zs}}], {}],
      If[fr, Polygon[{{x0,y0,z0}, {xs,y0,z0}, {xs,y0,zs}, {x0,y0,zs}}], {}],
      If[tp, Polygon[{{x0,y0,zs}, {xs,y0,zs}, {xs,ys,zs}, {x0,ys,zs}}], {}]
    }]\
\>", "Input"],

Cell["\<\
cheese[n_, rt_, fr_, tp_, x0_, y0_, z0_] :=
  With[{s = 3^(n-1), t = 2 3^(n-1), n1 = n-1},
   With[{xs = x0 + s, xt = x0 + t,
         ys = y0 + s, yt = y0 + t,
         zs = z0 + s, zt = z0 + t},
   { (* bottom layer *)
    cheese[n1, False, fr, False, x0, y0, z0],
    cheese[n1, False, fr, True, xs, y0, z0],
    cheese[n1, rt, fr, False, xt, y0, z0],
    cheese[n1, True, False, True, x0, ys, z0],
    cheese[n1, rt, False, True, xt, ys, z0],
 (* cheese[n1, False, False, False, x0, yt, z0], invisible *)
    cheese[n1, False, True, True, xs, yt, z0],
    cheese[n1, rt, False, False, xt, yt, z0],
     (* middle layer *)
    cheese[n1, True, fr, False, x0, y0, zs],
    cheese[n1, rt, fr, False, xt, y0, zs],
    cheese[n1, True, True, False, x0, yt, zs],
    cheese[n1, rt, True, False, xt, yt, zs],
     (* tp layer *)
    cheese[n1, False, fr, tp, x0, y0, zt],
    cheese[n1, False, fr, tp, xs, y0, zt],
    cheese[n1, rt, fr, tp, xt, y0, zt],
    cheese[n1, True, False, tp, x0, ys, zt],
    cheese[n1, rt, False, tp, xt, ys, zt],
    cheese[n1, False, False, tp, x0, yt, zt],
    cheese[n1, False, True, tp, xs, yt, zt],
    cheese[n1, rt, False, tp, xt, yt, zt]
  }
 ]]\
\>", "Input"],

Cell["\<\
Sierpinski[n_Integer] :=
    Block[{polylist},
        polylist = {EdgeForm[],
        cheese[n, True, True, True, 0, 0, 0]};
        polylist = Flatten[ polylist ];
        Graphics3D[polylist, Boxed->False]
    ]   /; n >= 0\
\>", "Input"],

Cell["\<\
bookoptions :=
    Sequence[ViewPoint->{0.95, -3.1, 0.8},
        LightSources -> {{{1., 0., 5.}, RGBColor[1, 0, 0]}, 
                         {{1., 1., 1.}, RGBColor[0, 1, 0]}, 
                         {{0., 1., 0.4}, RGBColor[0, 0, 1]}, 
                         {{0., -1., 0.4}, RGBColor[0, 0, 1]}},
        Boxed->False, Background -> GrayLevel[0] ]\
\>", "Input"],

Cell[CellGroupData[{

Cell["Show[ Sierpinski[3], bookoptions ];", "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004^0001:`P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcool0;`000?l1;P410000o`4^0@40003o0Bh10@000?l1;P410000o`4^
0@40003o0Bh10@000?l1;P410000o`4^0@40003o0Bh10@000?l1;P410000
l0402YfQWJ6MXIfQWJ4c0@40003W0A>Q<`410000gP407IfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ5d03810@000=D19J400hh10@0`0@40003A0@0[
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dS@0a
0@40003<0BjQ00>>M8h0<0410000``40>Z6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSG@`0@40002j
0D2Q00B>M8id;`410000/@40CJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ5dSGB=02l10@000:P1A:401@2?08l000VQ00F>M8idSP0^0@40002P0@1O
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIf@Si2?T8n@Si2?XIfQWJ6MXIfQ
M8edSG@0;P410000W05;X@0:S@2?08l0S`2?00VQ00J>M8idSW@]0@40002G
0@1YXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIf>M92?T8n@
Si2?XIfQWJ6MXIfQM8edSGB=02d10@0008h1?Z402@2?08l0S`2?000BX@04
SHj=SPnQ00J>M8idSW@]0@4000260@1jWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXHf@Si2?T8n@Sj6MXIfQWJ6MXIfQWJ6MXIfQWHidT7BQWJ6MXIfQWJ6M
XIfQWJ5dSHn=M8d]0@40001m0DnQ00VCS`2?08l0S`004Z4018f>Shh?X@07
SW@0M8idSP0/0@40001e0@2=XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6?T8n@WJ6M
XIfQWJ6MXIfQWJ6MXIfQSHj?T8n@Si2?XIfQWJ6MXIfQWJ6MXIfQWJ6MSWB@
Sj6MXIfQWJ6MXIfQWJ6MXGB=WHedSGB=02/10@0006`1AJ402Hl0S`2?08l0
S`0BX@04ThjCSQNQ00Z=SXl0S`2?08l02J4028idXGB>M8id:`410000I040
WifQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSXn@Si2?T8n@WJ6M
XIfQWJ6MXIfQWJ6MXIfQSHj?SYfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXGB=WHedSGB=M00Z0@40001L0EFQ00V>Thl0S`2?
08l04Z4019>>08hZX@09SWBQM8idSWB>02X10@0005@10:nMXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MT8n@Si2?T8nQWJ6MXIfQWJ6MXIfQWJ6MXIf>SHj=SYfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6=SXn@WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQM8fMSGB=M8ed02X10@0004`1Bj4028h0
S`2?08l04Z401HjCSP2>01JQ00VCSP2?08l0S`009J402HidSWB>M8idSP0Z
0@4000180@1?WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQW@02
SP1[T8n@Si2?XIfQWJ6MXIfQWJ6MXIfQWJ6MSXf>ShjMXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXGB=M8edSGB=M8d0:@410000@`4jX@09S`2?08l0S`2?016Q
00N>:Xh0S`2?01>Q00F>Thh0S`14X@0;SWB>M8idSWB>M8h0:0410000>`40
G:6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJF?T8n@Si2?T9fQWJ6MXIfQWJ6MXIfQ
WJ6M1Hh0JIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWHj=SXn@Si2?T9fQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ5dSGB=M8edSGB=M00X0@40000c0DZQ00V>:Xl0S`2?08l0
4J401HhZSP2>05jQ00b>M8idSWB>ShidSW@W0@40000[0@1/XIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQSi2?T8n@Si2MXIfQWJ6MXIfQWJ6MXIfQWJF>YHn@Si2?T9fQWJ6MXIfQ
WJ6MXIfQWJ6M0hh0K8n@WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXGB=M8edSGB@M8edSBL10@0002@1@:402:V?
08l0S`2?4J401XhZSRZ>:QBQ00R>:Xh0S`2?05^Q00f>M8idSWB>XHidSWB>
02H10@0001`10>^MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6>YHn@Si2?
T9fQWJ6MXIfQWJ6MXIfQWJ6MYHjUSjF>XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ5dSGB=M8edXGB=M8ed02H10@0001@1D:402:V>ZHl0S`2?4J40
1XhZSP2?:U:Q00V?UHnESiF?UHl07:403XidSWB>M8jQSWB>M8id9@410000
5040m9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIf@Si2?T8n@Sj6MXIfQWJ6MXIfQWJ6MXIfQSZF>YHjU
SZ6MXIfQWJ6MXIfQWJ6MXIfQWJF>YHn@Si2?T9fQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6?T8n@Si2?T8n@Si2?T8n@Si2MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQM8edSGB=M:5dSGB=M8dU0@40000D0CNQ00RUZHl0S`2?016Q
00NYSZV?ZHjY01:Q00>>:Xh00j400hh0S`12X@0FUHnESiF?UHnESiF?UHnE
SiF?UHnESabQ00j>M8idSWB>XHidSWB>M2D10@0001@10?FMXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
YHjUSi2?T8nQWJ6MXIfQWJ6MXIfQWJ6MXHjUSY2?YHjQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MT8n@Si2?T8n@Si2?T8n@
Si2?T8n@Si2?T8n@WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXGB=M8ed
SGB=M8edSGB=M00T0@40000D0AnQ00R?08l0S`2?012Q00NUZJFYYJVU01:Q
00RYSZV?08l0SeNQ01^>UHnESiF?UHnESiF?UHnESiF?UHnESiF?UHl07:40
48idSWB>M8idSWB>M8idSW@S0@40000D0@3fWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJJ>T8n@Si2?XIfQWJ6MXIfQWJ6MXIfQWJF>YHj@SZFM
XIfQWJ6MXIfQWJ6MXIfQWJ6>YHjQWJ6>T9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWHj=T8n@Si2?T8n@SHjMXIfQWJ6MXHn@
Si2?T9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSGB=M8edSGB=M8ed
SGB=8`410000504OX@08YJVU08l0S`0@X@07YJVUZHl0Y@1aX@0=SY>?UHnE
SiF?UHnESP09X@05SiF?UHl07J4047B>M8idSWB>M8id07B>M8hR0@40000D
0@3gWJ6MXIfQWI2?T8n@Si2?XIfQWJ6MXIfQWJ6MXIfQWJJ>YXjVSZJ>XIfQ
WJ6MXIfQWJ6MXIfQWJF>YHj@Si2?XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWHj=
SXn@Si2?T8n@Si2MXIfQWJ6MXIf@Si2?T9fQWJ6MXIfQWJ6?T8n@Si2?T8nQ
WJ6MXIfQWJ6MSGB=M8edSGB=M8f?SGB=M00R0@40000D0@NQ00RUZHl0S`2?
012Q00RUZJFYSjVUZA2Q00BUZJFY0j400jVQX@1^X@0KSY>>ThnESiF?UHnE
SiF?UHnESiF?UHnESiF?00ZQ00V>T9F@UI2ET9D02Z4047B>M8idSWB>M8id
XGB>M8hR0@40000D0@3gWJ6MXIfQWJJ>YXn@Si2?XIfQWJ6MXIfQWJ6MXIfQ
WJJ>YXj@SjJ>XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWHj=SXf>Si2?T8n@Si2?T8n@Si2?T8n@Si2?T8nQWJ6MXIfQ
WJ5dSXn@Si2?T8nQWJ6MXIfQWJ6MSHn=M8f?SGB=M8fMSGB=M00R0@40000D
0@NQ00RUZJFYYJVUZA2Q00RUZJFYS`2?04ZQ00V?UHnESiF?UHl0=J4078jC
SY>>UHnESiF?UHnESiF?UHnESiF?UHnESiD9X@04SXf>S@nQ015dUGB>M9Ed
SWB>M:5dSWB>M00Q0@40000D0@3hWJ6MXIfQWJJ>YXj@SjJ>XIfQWJ6MXIfQ
WJ6MXIfQWJJ>YXjQWJ6>XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MT8n@Si2?T8n@
Si2?T8n@Si2MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWHj=SXf>SI2?T8n@Si2?T8n@Si2?T8n@Si2?XIfQ
WJ6MXIfQWJ5dSXn>WJ6MXIfQWJ6MXIfQWJ6MSHn@M8f?T7B=M8fMSGB=M8dQ
0@40000D0@NQ00RUZJFYS`2?ZE6Q01ZESiF?UHnESiF?UHnESiF?UHnESiF?
UHnEScFQ012>ThjCSY>>UHnESiF?UHnE1Z401XjCS`2?00VQ00B>SIF=3j40
4GBET8idUHnEM8idXGB>M8id02410@0001@10?VMXIfQWJ6MYXjVSY2?T8nQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6>YHn@Si2?T8n@
Si2?T8n@Si2?T8n@Si2?T9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MT8n@Si2?T8n@WJ6MXIfQWJ6MSXf>SHj=SXf>SHj=SYfQWJ6MXIfQ
WHj=XIf>Sj6MXIfQWJ6MXGB>Si2MXIfQWJ6MXIfQWJ6MXIf=WJ5dSHn@Shed
SGB=M8edSG@0804100005047X@04YJVUZEFQ00nYSZV?UHnESiF?UHlZSRX0
1Z401HnESiF?02>Q00V>UI2ET9F@UI002J403HjCSY>>ThjESY>>Thh06:40
2Hj=UI2ET9F@U@0:X@0CM:6QSWBESiF?SWB>M8id07B>M00O0@40000D0@3j
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQSZF>YHn@Si2?T8n@SjF>XIfQWJ6MXHn@Si2MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWHj=T8n@Si2?T9fQWJ6MXIfQWHj=SXf>
SHj?T8f>SHjMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSYfQM92?T8nQWJ6M
XIfQWJ6MSIfQM8f?T8n@M8edSGB=ShedSAl10@0001<1HJ403jV>ZHjYSiF?
UHnESiF?:P08X@03SiF?00VQ00R@UI2ET9F@UA:Q00V>ThjET9F@UI002J40
3HjCSY>>ThjESi>>Thh0:j4057BQXHidUHnEShidSWB>M01dSWB>7P410000
4`40o:6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6>YHjUSZF?T8n@Si2?T8nQWJ6MXIfQWI2?T9fQWJ6MXIfQ
WHj?T8n@Si2?XIfQWJ6MXIfQWJ6MXIfQWJ6MSXf>SHjMXIfQWJ6MXIfQWJ6M
SXf>Shj=SXn@Shj=SYfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIf=WJ5dSHn@Si1dSGB=M8fQSGB=M1h10@0001<1HJ406ZV>
ZHjYSZV?UHnESiF?UHnESiF?UHnESiF?2J4028hZT9F@UI2E4Z401HjCSYF>
00fQ00f>ThjET9>>UHnESi>>02^Q00EdSZ6>M005X@0:M8idSWBQM8idSQh1
0@0001<108BQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6?T8n@Si2?T8nQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQSZF>YHjUSY2?T8n@Si2?T8n@Si2?T8n@Si2MXIfQ
WJ6MXId3SP1fSi2?T8nQWJ6MXIfQWJ6MXIfQWJ6MXIf>SHj?T9fQWJ6MXIfQ
WJ6MXIf>SHjMXHf>Si2?T8f>WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWHedSGB=WJ6MXIf=M8edSJ6=M8edSAd10@0001<1
7j404IF?UHnESiF?UHnESiF?UHnE036Q01ZYSZV>ZHjYSYF?UHnESiF?UHnE
SiF?UHnES`VQ00F>:XhZSP0EX@09SY>>UI2ET9F@00VQ00>>Thh00Z4029>>
UHnESiF>:j401GB>M8id00FQ00]dSWB>M:5dSWB>M00M0@40000C0@24XIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6?T8n@Si2?T8n@Si2?T8n@Si2?T8n@Si2?
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXHjUSZF>YHjUSY2?T8n@Si2?T9fQWJ6MXIfQWJ6MXIfQWJ6M0hh0MXn>
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSXf>WJ6=T8n@WJ6MXIfQWJ6MSXf>WJ6=
SXn@Si2?SYfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIf=M8edSIfQWJ6MSGB=M8fQSGB=M8dM0@40000C0ANQ01VYYIF?UHnE
SiF?UHnESiF?UHnESiF?UHnE036Q01:YSZV>ZHjYSZV>ZHjYSZV>ZHhAX@05
SRZ>UI009j400hjCSP02X@08ThjESiF?UHl9X@06SiF?UHnE7:401GB>M8id
00FQ00adSWB>M8idSWB>M8hL0@40000C0@24XIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6>YXj@Si2?T8n@Si2>YXjVWJ6MXIfQSi2?XIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIf@Si2?T8n@Si2MXIfQWJ6MXHjUSZF>YHjUSZF?
YHjUSZF>YIfQWJ6MXIfQWJ6MXIfQWJ6M0hh0N8n@Si2?XIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSXf>WJ6=SXn@Si2?T8n@Si2?T8n@
Si2?T8n@Sj6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIf=M8edSIfQWJ6M
SGB=M8edSGB=M8edSA/10@0001<15j404:VUZJFESiF?UHnESiF?ZJD7X@03
SiFQ01nQ00V>ZI2ET9F@UI002:404ZV>ZHjYSZV>ZHjESjV>ZHjYSQ6Q00>>
:Xh00Z400bZ@U@0TX@07SY>>Tj6CSP07X@0>SiF?UHnESiF?UHnESiDLX@05
M8idSW@01J403GB>M8idSWB>M01dSW@06`4100004`40oj6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQSZJ>YXjVSi2?T8n@Si2?YYfQWJ6MXIfQSj6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MYHjUSi2?T8n@WJ6MXIfQWJ6>YHj@
SZF>YHjUSi2?YHjUSZFMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSXf>SJ6=SYfQWJ6MXIf>
Si2?T8n@Si2?SXfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIf=M8ed
SIfQWJ6MSGB=M8edSGB=ShedS@01XAX10@0001<15j406:VUZJFYYJV?UHnE
SiF?UHnESiF?UHnES`VQ00RUUI2ET9F@UA2Q00N>ZHjYSZV>00ZQ01:YSZV@
UHjYSZV>UHnESjV>ZHhmX@07SY>>ThjCSP07X@0<SYF?UHnESiF?UHnC7Z40
1GB>M8id00FQ00UdSWB>M8idSW@00Z400hidSP0J0@40000C0@3kXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6>YXjVSZJ>YXn@Si2?T8n@Si2?T8n@Si2MXIfQ
WJ6MXIfUSY2?T8n@Sj6MXIfQWJ6MXIfQWJ6MXIfUSZF>T8jUWJ6MXIfQWJ6M
XHjUSY2?T8jUSZF?T8n@SjF>YIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIf>SHj=SXf>WJ6M
XIfQWHj=T8n@WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WHedSGB=WJ6MXIf=M8edSGB=M8d00Z4017B=M8dI0@40000C0ANQ01RYYJVU
ZJFYYJVUUHnESiF?UHnESiF?UHl9X@08YJVUUI2ET9D@X@07SZV>ZI2ESP0:
X@03ZHjY00>Q00bYSZV>UHnESiF>ZHhmX@07SY>>ThjCSP0aX@05M8idSW@0
1J402GB>M8idSWB>M002X@04SWB>M1T10@0001<10?^QWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXHjVSZJ>YXjVSZJ>T8n@Si2?T8nVSZJ>XIfQWJ6MXIfQWJF>
YHjUSZFMXIfQWJ6MXIfQWJ6MXIfQWJF>YHj@Si2?T9fQWJ6MXIfQSZF>XIfQ
SZF>YHn@Si2?T8jUWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSGB=M8fM
XIfQWHf?SGB=M8edS@02X@04M8edSAT10@0001<15j405jVUZJFYYJVUZJFY
YJVUZJFYYJVUZJFY00ZQ00NUZJFET:VU016Q00B>ZHjY0j400jV@X@07X@03
ZHjY00>Q00bYSZV>UHnESiF?UHieX@05M8idSW@01J402GBET8idSWB>M002
X@05SWB>M8h0604100004`40oj6MXIfQWJ6?T8n@Si2?T9fQWJ6MXIfQSZJ>
YXjVSZJ>YXjVSjJ>YXjVSZJ>YXjQWJ6MXIfQWJ6MYHjUSi2?YIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6>YHjQWJ6>YHjUSi2?T8n@Si2?
T8n@Si2?T9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIf=M8edSIfQWJ6MSHn@M8edSGB=
M:5dS@000j6MX@0H0@40000B0@RQ00RYYIF@UI2ET0RQ01NYYJVUZJFYYJVU
ZJFESjVUZJFYYJVUZ@0:X@08YJVUUI2ET9DQX@03ZHjY00>Q00BYSZV>2:40
2:V?UHnESiF?KJ401GB>M8id00FQ011dXJ6>M8idSWB>M8id07B>60410000
4P40oifQWJ6MXIfQSZJ>T8n@Si2MXIfQWJ6MXHjVSZJ?T8jVSZJ>YXn@SjJ>
YXjVSZJ>XIfQWJ6MXIfQWJF>YIfQWJ6>XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQSZF>YIfQSZF>YIfQWJ6MXIfQSZF?T8n@Si2MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MSGB=M8fMXIfQWHfMXGB=M8edSGB=M0001IfQWJ6M01L1
0@0001812:402:VUZJFYYJVU2:405jVUZJFET9FUZJFYYIF?UHnEYJVUZJFY
03>Q00ZYSZV>ZJ6YSZV>2:402:V>ZHnESiF?FZ402YF@UI2ET9F@UI09X@06
M8idSWB>1:404WBQXHidSWB>M8idSW@0M8idSQH10@0001810?nMXIfQWJ6M
XHjVSZJ?T8jVWJ6MXIfQWJ6>YXjVSi2?T8jVSZJ?T8n@Si2>YXjVSZ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XHjUSZF>YHjUSZFMXIfQWJ6MXHjUSZF?T8n@WJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQM92?T8n@Si2?T9fQWJ6MXIfQ
WHedSGB=M8fMXIf=WJ5dSGB=M8edSG@00Id2X@03M8ed01H10@0001812:40
2:VUZJFET9FU2:401:VUZJD4X@0?ZJFYYIF?UHnESiFUZJFY03>Q00ZYSZV>
ZHjYSZV>JZ402Xj=UI2ET9F@UI09X@07M8j@SWB>M003X@0=M:6QSWB>M8j?
SWB>M002X@04SWB>M1D10@0001810?nMXIfQWJ6MXHjVSZJ?T8n@WJ6MXIfQ
WJ6>YXjVWJ6MXHjVSZJ?T8n@Si2?T8jVSZ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXHjUSZF>YHjUSZ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6?T8n@Si2?T8n@WJ6MXIfQ
WJ6MXIfQWJ6MXIfQM8idSYfQWJ6MXIfQWJ6MXIfQWHedT8n=M8edXIf=WJ5d
SGB=M92?SG@00Id2X@04M8edSAD10@0001812:401:VUZJD<X@04ZJFYY@BQ
00nYYJV?UHnESiF?UHnEYJT0S:402I2ET9F@UI2ET00BX@04SXfES@nQ00Qd
SY2EM8idSP:Q00edSZ6>M8j@SXnEM8id00:Q00F>M8idSP0D0@40000B0@3o
WJ6MXIfQWJ6>YXjVWJ6MXIfQWJ6MXIfQSZJ>YYfQWJ6>YXj@Si2?T8n@Si2?
T8n@WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWHj?T8n@Si2?T9fQWJ6MXIfQWJ6MXIfQWJ6MXGB>Si2MXIfQWJ6M
XIfQWJ6MXIf=M:6MSGB=M:6MSGB=M8edT7B@Si1d006M0Z401GB=M8ed01@1
0@0001816:401:VUZJD4X@07ZJFYSiF?U@07X@03ZJFQ06jQ00V@UI2ET9F@
UI004j4018jCSY<GX@0:SXfET9F@UI2ET0VQ01idSZ6QM8idSWBQM8idSWB>
T8j?UHn>M8jQSW@0M8hD0@40000B0@3oWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQSZJ>YYfQWJ6>YXjQWJ6MXIfQWJ6MXHjVWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MSXn@Si2?T8n@WJ6MXIfQWJ6MXIfQWJ6MXIfQWHj=T8fQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXGB>WJ5dT8n@Si2MXIfQWJ6MXIf=M:6MSGB=M8edSGB=
M8edXGB@Si1d0009WJ6MXIfQWJ6M01<10@0001816:401JVUZJFY00>Q00>Y
YJT02j400jVUX@1DX@08T9F@UI2ET9DBX@09SY>@UI2ET9F@01>Q00B>Ti2E
5j402Xj=XJ6>SIF@UI0:X@0NSZ6QM8idSWB>M8idSWB>XHj?UHnEM8idSW@0
M8id4`4100004P40oifQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXHjVSZJ>YYfQ
SZJ>XIfQWJ6MXIfQWJ6>YYfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIf>Si2?T8n@Sj6MXIfQWJ6MXIfQWJ6MXIfQWHj=SXf>WJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIf>SI2?T8n@Si2MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXGBQWHedSGB=M8edSGB=M:5dT8n@S`00
2YfQWJ6MXIfQWJ4B0@40000B0ARQ00^YYJVUZJFYYJVUZ@1RX@08SYF@UI2E
T9DBX@05SY>>UHh05j402HjCXJ6>UI2ET00VX@0OSZ6QM8idSWB>M8idSWB>
XHidUHnEM8idSWBQM8idSP0B0@40000B0@25WJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQSZJ>YXjVSZ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXHn@
Si2?T8n@Sj6MXIfQWJ6MXIfQWJ6MXIfQW@02SP1eT8n@Si2?XIfQWJ6MXIfQ
WJ6MXIfQWJ6MSXf>Si2MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWHj=XIf>SI2?
T9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQM8fMSGB=
ShedSGB=M8edXGB=00>Q00Z=M8edSJ6=M8ed4P4100004P5ZX@09:XjET9F@
UI2E01:Q00F>:XhZSP0EX@09SY>>UI2ET9F@04:Q01:>M8idSWBET8idSWB>
M8idSW@3X@0;M8idSWBQM8idSW@04@4100004P40QIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6>YHj@Si2?T8nQWJ6MXIfQWJ6MXIfQWJ6MXId00Xh0MI2>SYfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWHj=SYfQSI2?T9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXGB=
M8edSHn@M8edSGB=M8edS@03X@0;SGB=M8fQSGB=M8d04@4100004P5AX@08
T9F@UI2ET9DAX@07:XhZSRZ>:P0DX@05SRZ@UHh0H:401XidSWB>M0:Q00Z>
M8idSWB>M8id0j4037B>M8idSWB>M8idSQ010@00018108FMXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfUSi2?T8n@Sj6MXIfQWJ6MXIfQ
WJ6MXIfQSZF>YHnUSZ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M00:>07F@Si2?T8nQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ5dSGB=M8fMXGB=M8edSGB=M8d00j4038edSGB=M8edSGB=M1010@000181
DJ4028jYT9F@UI2E4J401bZ>:XjET2X05:400hhZX@02X@03:XjE05fQ00J>
M8idSW@2X@0:SWB>M8idSWB>M0>Q00adSWB>M8idSWBQM8h@0@40000B0@3l
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6?T8n@Si2?T9fQWJ6MXIfQWJ6MXIfQWJ6MYHjUSZF>YIfQ
WJ6MXIfQWJ6MXIfQWJ6MXHjUSZF?T8n@Sj6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQM8edSGB=WJ5dSGB=M8edSGB=0j403HedSGB=M8edSJ6=M8d0
3`4100004P4hX@08ZI2ET9F@UI0AX@07SZV>UHjYSP0BX@04:XhZSP>Q00>>
UJ40MZ401XidSWB>M0:Q00Z>M8idSWB>M8id1:403HidSWB>M8idXGB>M8h0
3P4100004P40o9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQSZF?T8n@Si2MXIfQWJ6MXIfQWJ6MXIfQ
WJF>YHn@SZFMXIfQWJ6MXIfQWJ6MXIfQWJ6>YHjUWJ6MYHjQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXGB=M8edSIfQM8edSGB=M8edS@BQ00edSGB=
M8edSJ6=M8ed00h10@0001817j402:FYT9F@UI2E4J401jVUZJFYYJT04Z40
28jYSYF@UI2ETJ404XidSWB>M8jQSWB>T8idSWB>M0BQ00f>M8idSWB>M:5d
SWB>00h10@0001810?bMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
YXjVSi2?T8nQWJ6MXIfQWJ6MXIfQWJ6MXHjUSY2?YHjQWJ6MXIfQWJ6MXIfQ
WJ6MXIfUSZFMXIfUSZ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSGB=M8edSGB=M91dSGB=M8d4X@0=
M91dSGB=M8edSGB@M00>0@40000B0@NQ00R@UI2ET9F@UA2Q00RUZJFYYJVU
ZA6Q00NYYJV@UI2E01:Q00>>ZHh00j400hjYX@2@X@0BSWB>M8idSWB>M8j@
SWB>M8id1:403Hj@SWB>M8idSWB>Shh03P4100004@40oJ6MXIfQWJ6MYXj@
Si2?T8nQWJ6MXIfQWJ6MXIfQWJ6MYXjVSY2?YXjQWJ6MXIfQWJ6MXIfQWJ6M
XHjUSZ6MXIfUWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5d
SGB=M8edSGB=M:6MSGB=M8d01:403GBQM8edSGB=M8edT7@03P4100004@48
X@08YJVUUI2ET9D@X@08YJVUZI2ET:TAX@03ZJFY00BQ00>UXJ40Z:402hid
SWB>M8idSWB>00:Q00EdSWB>M004X@0=SZ6>M8idSWB>M8jQSP0>0@40000A
0@3mXIfQWJ6MXIfVSZJ>YXjVSZ6MXIfQWJ6MXIfQWJ6MXIfVSZJ>T8n@Sj6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWI1fT7J@MY1fT9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXGB=M8edSGB=M8edXIf=M8edS@04X@0=M:5dSGB=M8ed
SGBQM00>0@40000A0@RQ00RUZJFYT9FUZA2Q00BUZJFYHJ404YF@UI2ET9F@
UI2ET9F@UI2ET5BQ00^>M8idSWB>M8idSP02X@06M8idSWB>0j403HjQSWB>
M8j?SWB>XHh03P4100004@40oZ6MXIfQWJ6MYXjVSY2?T8jQWJ6MXIfQWJ6M
XIfQWJ6MYXjVSZ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQMY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY2MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWI1fT7J@MY1fT7JQWJ6MXIfQWJ5dSGB=M8edSGB=M:6MSGB=
M8ed0j403GBQM8edSGB@M8edXG@03P4100004@48X@08YJVUZI2ET9ETX@0S
T9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI00@J402XfET9F@
UI2ET9D9X@0;SWB>M8idSWB>M8h00Z401WB>M8idSP>Q00f>M8idSY2>SiEd
SWB>00h10@00014108RQWJ6MXIfQWJJ>YXjQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXGJ@MY1fT7J@MY1fT7J@
MY1fT7J@MY1fT7J@MY1f0hh0M9fQWJ6MXIf@MY1fT9fQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MSWB@MY1fT7J@MZ6MXIfQWJ6MXGB=MXedSGB=M8edSIf=M8edSGB=
0Z403GB=M8edT7B@ShedSG@03P4100004@48X@04YJVUZENQ02RET9F@UI2E
T9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET2Z>2:4019F@UI0UX@09
T9F@UI2ET9F@01>Q00B=SXf>3j408hidUGB>M8idSWB>M8idSWBEM8idSZ6>
M8idSY2>SiEdSWB>00h10@0001410?nQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ5fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1f
T7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J>WJ6MXIfQWJ6MT7J@WJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWHifT7J@MY1fT9fQWJ6M
XIfQWJ6MXIfQWJ6MXIf>M91dXIfQWJ6MXIfQWJ6MXIfQM8efSGB=M8edSGB=
M8edSJ6=M8d000nQWJ6MXIfQWJ6MXIfQWJ403P4100004@59X@0XUI2ET9F@
UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI0ZSPRQ01jET9F@UI2E
T9F@UI2ET9F@UI2ET9F@UI2ET9F@UI09X@09T9F@UI2ET9F@01>Q00V>Ti2E
T9F@UI004j4018f>T9D?X@0SSWBQXHidSWB>M8idSWB>M:5dSWB>M8idSWB>
XHj?UHn>M8h03P4100004@40oj6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6>T7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7JUWJ6M
XIfQWJ6MT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY2MXIfQWJ6MXIf>
MY1fT7J@MY2MXIfQWJ6MXIfQWJ6MXIfQWJ6MSXf@SJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWHidT7J@MY1fT7JQWJ6MXIfQWJ5dSIfQM8edSGB=M8edSGB=
XHedS@002J6MXIfQWJ6MX@03X@03M8ed00h10@000141BJ403jV>UI2ET9F@
UI2ET:V>Z@06X@0iT9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@
UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@00VQ00V>Ti2ET9F@UI004j4018jC
T9DHX@0:SHjQXHfET9F@U@VQ01f>M:6QSWB>M8idSWB>M8idXGB>M8idSWB>
M8jQSP03X@03SWB>00h10@0001410?nQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQSZF>T7J@MY1fT7J@MZF>XIfQWJ6MXGJ@MY1fT7J@MY1fT7J@MY1f
T7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@WJ6MXIfQ
WJ6MSXf>SHjMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWHj=T7J@MY1fT9fQWJ6M
XIfQWJ6MXIfQWJ6MXIf>M:6MSWB@MY1fXIfQWJ6MXIfQM8fMXGB=M8edSGB=
M8edSJ6=M8d000VQWJ6MXIfQWJ400j400gB=M00>0@40000A0DVQ00nYSZV>
ZI2ET9F@UI2ET:T02:40892ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@
:XhZ0Z405HhZSZ6@UI2ET9F@UI2ET9F@UI2ET009X@05SY>>UHh05j402HjC
XJ6>UI2ET00VX@0MSWBQXHidSWB>M8idSWB>M:5dSWBEM8idSWB>M8h00j40
0hidSP0>0@40000A0@2AXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXHjU
SZF>YGJ@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7JUWJ6M
XIfQWJ6MXIfQWJ6MXIfQMY1fT7J@MY1fT002SP1eWJ6MXIfQWJ6MXIfQWHj=
SWJ@WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIf>SJ6MSXf@MY2MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXGB=WJ5dSGB=M8edSGB=M8ed
SGB=ShedSGB=M8ed00>Q00=dSG@03P4100004@59X@0/ZHjYSZV>ZI2ET9F@
UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F>ZHjYSZV>ZHhCX@0;T9F@UI2ET9F@
UHh03J402HjCSYF@UI2ET00CX@07SY>QXHjCSP0XX@0MSWB>XHidSY2>M8id
SWB>M8idSWBEM8idSWB>M8h00j400hidSP0>0@40000A0@3oXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXHjUSZF>YHjUSY1fT7J@MY1fT7J@MY1fT7J@
MY1fT7J@MY1fT7JUSZF>YHjUWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5fT7J@MY1f
T7J@WJ6MXIfQWJ6MXIfQWHj=SYfQWI1fT9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XGB=M8edSGB@MXedSGB=M8edSGB=0009XIfQWJ6MXIfQ00>Q00=dSG@03P41
0000405:X@0/ZHjYSZV>ZHjYSYF@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@
UI2YSZV>ZHhEX@0=T9F@UI2ET9F@UI2ET009X@03SY>>00>Q00>>UI00@Z40
1hidSWB>M8h00Z405GB>M8idSWB>M8idXGB>M8idSWB>M003X@03M8id00d1
0@0001010?nMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXHjUSZF>YHjU
SZF>T7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MZF>YHjUWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXGJ@MY1fT7J@MY1fT9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXGB=M8edSGBQWHedSGB=M8edSG@000^MXIfQ
WJ6MXIfQW@03X@03SGB=00d10@000101BZ406JV>ZHjYSZV>ZHjYSYF@UI2E
T9F@UI2YSZT01Z403I2ET9F@UI2ET:V>ZHh05j402i2ET9F@UI2ET9F@05BQ
00N>M8idSWB>00:Q01EdSWB>M8idSWB>M:5dSWB>M8idSW@00j400gB>M00=
0@40000@0@3oWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MYHj@MY1fT7JQWJ6MXIfQWJ6>YHjUSZF>
YHjUSZF>T7J@MY1fT7J@MZF>XIfQWJ6MXGJ@MY1fT7J@MZF>YIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXGJ@MY1fT7J@MY2MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSGB=M8edXIf=M8edSGB@M8ed000;WJ6M
XIfQWJ6MXId00j400hf?S@0=0@40000@0CVQ00RUZJFET9F@U@VQ01VYSZV@
UHjYSZV>ZHjYSZV@UI2ET9F@UI2Y00RQ00^@UI2ET9F@UI2YSP0@X@0BUI2E
T9F@UI2ET9F@UI2ET9F@EJ401WB>M8idSP:Q01EdSWB>M8j@SWB>M8idSWBE
M8idSW@00j400gBQM00=0@40000@0@3oWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ5fT7J@MY1fT9fQWJ6MXIfQWJ6MXIfQWJ6MYHjUSZF>YIfQ
WJ6MXIfQWJ6>YHj@MY2>YHjUSZF>YHjUSY1fT7J@MY1fT7J@MY1fT7J@MY1f
T7J@MY1fYIfQWJ6MXIfQMY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY2MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSGB=M8edXIf=
M8edSGB@MXed000;WJ6MXIfQWJ6MXId00j400hfQS@0=0@40000@0B2Q00RY
YIF@UI2ET16Q00NUZJFYT:VU00ZQ04jYSZV@UI2ESZV>ZHjYSZV>ZHjET9F@
UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2E
T9F@UI2ET9F@UI1EX@0MM8idSWB>M:5dSWBEM8j@UGB>M8idSWBQM8idSW@0
0j400gBQM00=0@40000@0@3oWJ6MXIfQWJ5fT7J@MY1fT9fQWJ6MXIfQWJ6M
XIfQWJ6>YXjVMY1fT9fQWJ6MXIfQWJ6MXIfQWJ6MYHjUSY1fYIfQWJ6MXIfQ
WJ6>YHjQWJ6MYHjUSZF>YHjUSZF>T7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1f
T7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY2MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQMi1gT7N@Mi1g
T9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSGB=M8edSGB=M8efSGB@
MXed000;WJ6MXIfQWJ5fT7H00j400hfQS@0=0@40000@0@RQ00RYYIF@UI2E
T12Q00RYYJVUUI2YYA6Q00RUZJFYT9F@U@VQ00>YSZT01:40<XjYSZV>ZHjY
SZV>ZHjET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI0Z1j40
3YF@UI2ET9F@UI2ET9F@9J404gNEMiEgUGNEMiEgUGNEMiEgUGL07J402gB>
M8idSWB>M8id00:Q016>T9F@SWB>M8idXGB>M8idSP02X@03M:5d00d10@00
01010?nMXIfQWJ6MXHjVSY1fT7J@WJ6MXIfQWJ6MXIfQWJ6MXHjVSZIfT7JV
WJ6MXIfQWJ6MXIfQWJ6MXIfUSZF>XIfQSZ6MXIfQWJ6MXHjUSZ6MXIfUSZF>
YHjUSZF>YHjUSZEfT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@
MZ6MXIfQWJ6MT7J@MY1fT7J@MY1fT9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ5gT7N@Mi1gT7N@Mi1gT7N@Mi1gT7N@Mi1gT7N@WJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIf=M8edSGB=M8edSIfQM91fT7H000bMXIfQWJ6M
XHjVSY02X@03SGB=00d10@0001012:402:VUZJFYYJVU4:402:VUZJFET9F@
4J401:FYYJT3X@03ZJ6Q00NQ00>YSZT01:406hjYSZV>ZHjYSZV>ZHjYSZV@
UI2ET9F@UHjYSP06X@0VUI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@
UI2ET9F@UI0LX@0LTgNEMiEgUGNEMiEgUGNEMiEgUGNEMiEgUGNEMafQ00]d
SWB>M8idSWB>M002X@0FSY2ET9F@SWB>M:5dSWB>M8idXGB>M0d10@000101
09JMXIfQWJ6MXHjVSZIfT8jVWJ6MXIfQWJ6MXIfQWJ6MXHjVSZJMXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXHjUSZ6MXIfUSZF>YHjU
SZF>YHjUSZF>YGJ@MY1fT7J@MZFMXIfQWJ6MT7J@MY1fT7J@MY1fT7J@MY1f
T7J@MY1fT7J@MY1fT7J@MY02X@1hWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXHf>Mi1gT7N@Mi1gT8f>WJ6MXIfQWJ5gT7N@Mi2MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWHedSGB=M8edSGB=WJ5dT7J@MY1dSGB=XHedSGB=
M8fQSGB=3@4100004048X@08ZJFYYIF@UI0@X@04ZJFYYBJQ00>YSZT01:40
=HjYSZV>ZI2YSZV>ZHjYSZV>ZI2ET9F@UI2ET9F@UI2ET9F@UI2ET9F@UI2E
T9F@UI2ET9F@02jQ00jCSY=gUGNEMiEgUGNESPVQ00EgUGNEM`0MX@0;M8id
SWB>M8idSW@00Z405Xj@UI2ET9EdSWB>M8idUGB>M8idSW@=0@40000@0@1o
WJ6MXIfQWJ6>YXjVWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6>YXjVWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6>YHjUWJ6MYHjUSZF>T7JU
SZF>YHjUSZF>YGJ@MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@SP0IX@1hWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXHf>SHigT7N@Mi1gT7N@Mi1gT7N@
Mi1gT7N@Mi2MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWHedSGB=Mhed
SGB=WJ5dT7J@MY1fT7B=M8edSJ6=M8edSGB=3@4100004048X@04ZJFYYCjQ
00FYSZV>Z@02X@0^SZV>ZHjYT9F@ZHjYSZV>ZHjYSZV>UI2ET9F@UI2ET9F@
UI2ET:V>ZHjYSZV>ZCFQ01bCSY>>TgNEMiEgUGNEMiEgUGNEMiEgUGNEMiEg
7J408gB>M8idUGB>M8idSZ6>T9F@UI2ET8idSWB>M:5dSWB>M8id00d10@00
010107:MXIfQWJ6MXHjVSZJMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXHjUSZF>YHjUSZF>
YHjQWJ6>YHjUSZF>YHjUSZF>YHjUSZF>YHjUSZD2X@0;SZF>YHjUSZF>YHh0
6J40N9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6=SXf>SHigT7N@Mi1g
T7N@Mi1gT7N@Mi1gXIfQWJ6MXIfQWJ6MXGN@Mi1gT7N@Mj6MXIfQWJ6MXIf=
M8edSGN@M8edSGB=M91fT7J@MY1fSGB=M8fQSGB=M8edS@d10@000101BZ40
3JV>ZHjYSZV>ZHjYSZT00j406:V>ZHjYSZV>ZHjYSZV@ZHjYSZV>ZHjYSP:Q
00^YSZV>ZHjESZV>Z@0eX@0@ThjCSY>>TgNEMiEgUGNEMaJQ00V>MiEgUGNE
MiD02Z408gB>MhidUGNEM8idSWB>T9F@UI2ET9EdSWB>M:5dSWB>M8id00d1
0@0000l1082QWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6>YHjUSZF>
YHjUSZF>XIfQSZF>YHjUSZF>YHjUSY1fYHjUSZF>YHjUSZ6>YHjUSZF?T8jU
SQVQ07RMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQSHj=SXf>SHj=SXf>
SJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSWBQWJ6MXIfQWJ6MXIfQWJ6M
SGB@M8egT7N=M8edSGB@MY1fT7J@MY1dSGB=XHedT7B=M8d=0@40000?0DZQ
00j>ZHjYSZV>ZHjYSZV>Z@>Q022YSZV>ZHjYSZV>ZHjYT9F@ZHjYSZV>ZHjY
SZV>ZHjYSP:Q00>YSZT0=J403I>>ThjCSY=gThjCSY<06J400hj=SP0@X@0S
M8igSWBEMiEgSWB>M8j@UI2ET9F@UI2>M8idSWB>T8idSW@03@4100003`40
Nj6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MYHjUSZF>YHjUSZF>YHjQ
WJ6>YHjUSZF>T8jUSZF>T7J@MZF>YHjUSZF>YHjUSZF>Y@02X@03SZF>00NQ
00N?T8n@Si2?00^Q07RMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQSHj=
SXf>SI1gSXf>SJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSWNQWJ6MXIfQ
WJ6MXIfQWJ6MSGBQWHegT7N@MhedSGB@MY1fT7J@MY1fSGB=M8edXGB=M8d=
0@40000?0DZQ00j>ZHjYSZV>ZHjYSZV>Z@>Q022YSZV>ZHjYT9F>ZHjYT9F@
UI2YSZV>ZHjYSZV>ZHjYSP:Q00>YSZT01j401jV@UI2ET9D05:402XjEMiEg
UGNEMiD9X@0=ThjCSY>>TgNEMi>>T`0IX@09SXfEMiEgUGNE00ZQ00EdSZ6Q
M005X@04M8idSP:Q01>@UI2ET9F@UGB>M8idSZ6>M8id00d10@0000l107^Q
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJF>YHjUSZF>YHjUSZF>YHjQ
SZF>YHjUSY1fT8jUSY1fT7J@MY2>YHjUSZF>YHjUSZD00Z400hjUSP07X@04
SZF>Y@jQ06>MXIfQWJ6MXIf>SI1gT7N@Mi1gXIfQWJ6MXIfQSHigSXf>SI1g
T7N>SJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSYfQMi1gT7NQWJ6MXIfQ
WJ6MSGBQWHfMXIfQWHedSG@00Z404i1fT7J@MY1fSGB=M8edXGB=M8d03@41
00003`4QX@0@UGNEMiEgUGNEMiEgUGNEMaVQ01R>ZHjYSZV>ZHjYSZV>ZHjY
SZV>ZHjYSZT3X@0FZHjYT9F@UI2ET9F>ZHjYSZV>ZHjYSP:Q00>YSZT01j40
1:V>UHhGX@06SY>>ThjC3J403I>>UGNCSY=gUGNESY<06J402Hj=XJ6>MiEg
U@0:X@05M8jQXG@01J406GB>M8j@UI2ET9F@UI2ET8idSWB>XHidSW@03@41
00003`40Nj6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWI1gT7N@Mi1gT7N@Mi1g
T7N@Mi1gT7N@Mi2MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MYHjUSZF>YHjU
SZF>YHjUSZF>YHjUSZF>XIfQSZEfT7J@MY1fT7J@MZF>YHjUSZF>Y@02X@03
SZF>00NQ00N>YHn@Si2?00^Q07RMXIfQWJ6MXIf>SHigT8fQWJ6MXIfQWJ6M
XIfQSHigT7N>SI1gT7N@SJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSYfQ
M8jMXIfQWJ6MXIfQWJ6MSGBQWHfMXIfQWHedSGB@MY1fT7J@MY1fT7J=M8ed
XGB=M8d=0@40000?0ARQ01VUZGNEMiEgUGNEMiEgUGNEMiEgUGNEMiEg01VQ
01R>ZHjYSZV>ZHjYSZV>ZHjYSZV>ZHjYSZT3X@0KZHjET9F@UI2ET9F@UI2Y
SZV>ZHjYSZVQZHjY00NQ00NYSZ6QZHjE01BQ00J>ThjEMiD=X@03ThjQ00:Q
01N>TgNEMiEgUGNEMiEgUGNEMiEgUGNEM`0MX@05M8jQXG@01J4017B>M8h<
X@09M8idSZ6>M8id00d10@0000l1082QWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfVSZJ>T7N@Mi1gT7N@MjJ>YYfQWJ6MXGN@WJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJF>YHjUSZF>YHjUSZF>YHjUSZF>YHjUSZ6MXHjUMY1fT7J@MY1f
T7J@MZF>YHjUSZF>YHjUSPNQ00N>YJ6QSZF>00^Q06>MXIfQWJ6MXIf>SHjM
XIf>Mi1gXIfQWJ6MXIfQSHjMXIf>SJ6MXIfQWJ6=T7N@Mi1gT7N@Mi1gT9fQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSGBQWHfMXIfQWHedSG@03:40
2HedSGB=M8edS@0=0@40000?0ARQ016UZJFYYJUgUGNEMiEgUGNYY@07X@03
Mj6Q01NQ01R>ZHjYSZV>ZHjYSZV>ZHjYSZV>ZHjYSZT3X@03ZHjQ00FQ01>E
T9F@UI2ET:V>ZHjYSZV>ZHjY00NQ00NYSZ6QZHjY01BQ00>>Thh00j4018jC
MiD9X@03ThjQ00:Q00>>Tj401Z4039>>UGNEMiEgUGNCSQnQ00EdSWBQM005
X@04M8idSPbQ00UdSWB>M8idSZ403@4100003`40Ij6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJJ>YXjVSZIgT7N@Mi1gT7N@Mi1gT7N@Mi2MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MYHjUSZF>YHjUSZEgT8jUSZF>YHjUSZFMXIfQSZD0
1j404I1fT7J@MY1fT8jUSZF>YHjU01ZQ06>MXIfQWJ6MXIf>SHjMXIf>SJ6M
XIfQWJ6MXIfQSHjMXIf>SJ6MXIfQWJ6=SXf@Mi1gT7N@MhjMXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSGB=M8fMXIfQWHedSG@03:402HedSGB=
M8edX@0=0@40000?0ARQ01VUZJFYYJVUZGNEMiEgUGNEMiEgUGNEMiEg01VQ
01V>ZHjYSZV>ZHjYSYEgUHjYSZV>ZHjYSZV>00:Q01ZYSYF@UI2ET9F@UI2E
T9F@UI2ESZV>ZHjYSR>Q00>>Thh00j400hjCX@0:X@03ThjQ00:Q00>>Tj40
1Z403Y>>ThjEMiEgUGNEMiEg7J401GB>M8id00FQ00EdSWB>M00;X@0:M8id
SWB>M8jQSP`10@0000l107nQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfVSZJ>
YXjVSZJ>T7N@Mi1gT7N@MjJ>YYfQWJ6MXIfQWJ5gT7N@Mi1gT7NQWJ6MXIfQ
WJF>YHjUSZF>YHjUMi1gT7NUSZF>YHjUSZF>YHjUMY1fT7J@MY1fT7J@MY1f
T7J@SZF>YHjU01ZQ06BMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQSHjM
XIf>SJ6MXIfQWJ6=SXf>Mi1gT7N@Mi1gT9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MSGB=M8fMXIfQWHedSGB=2j402XedSGB=M8edXG@<0@40000?
0ARQ01NUZJFYYJVUZJFYYJVUZJFYYJVUZJFYY@0:X@09ZJFEMiEgUGNE00RQ
03F>ZHjYMjV>ZHjYSYEgUGNEMjV>ZHjYSZV>ZHjYSYF@UI2ET9F@UI2ET9F@
UI2ET9F>ZHjYSP0fX@03ThjC00:Q00>>Tj401Z403Y>>ThjCMiEgUGNEMiEg
7J401GB>M8id00FQ00EdSWB>M00;X@0:M8idSWB>M8jQSP`10@0000l107nQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfVSZJ>YXjVSZJ>YXj@MjJ>YXjVSZJ>
YYfQWJ6MXIfQWJ6>YHjUSZF>YIfQWJ6MXIfQWJF>YHj@MjF>YHjUMi1gT7N@
Mi2>YHjUSZF>YHjUMY1fT7J@MY1fT7J@MY1fT7J@MY1fYHjU01ZQ032MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQSHj=SYf>SJ6MXIfQWJ6=SXf>SHh8
X@0/WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIf=M8edSGBQWJ6MSGB=
M8d;X@0:SGB=M8edSGB=M0`10@0000l16:405jFYYJVUZJFYYJVUZGNEMiFU
ZJFYYJVU00ZQ00RYYJVUUGNYY@VQ02F>ZHjYMiEgZHjYSYEgUGNEMiEgUHjY
SZV>ZHjYSYF@UI2ET9FU00JQ00ZET9F@UI2ET:V>=Z401i>>ThjCSY<01j40
1Y>>ThjCSRFQ00IdSWB>M8h4X@08M8igSWBET9D8X@0:M8idSWB>M8idSP`1
0@0000l106nQWJ6MXIfQWI1gT7N@Mi1gXIfQWJ6MXIfVSZJ>YXjVSZJ>YXj@
Mi1gT7NVSZJ>YYfQWJ6MXIfQWJ6>YHjUMi1gXIfQWJ6MXIfQWJF>YHjQWJ6>
YHjUMj6MXIfQWJ6MYHjUSZF>YHjUMY1fT7J@MY001j402I1fT7J@MY1fY@0?
X@0kT7J@MY1fT7J@MY2MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQSHj=
SXf>SJ6MXIfQWJ6=SXf>SHh02:40;ifQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXGB=M8edXIfQWHedT7B=MY1f00RQ00Z=M8edSGB=M8ed30410000
3`48X@08YJUgUGNEMiD8X@0GYJVUZJFYYJVUZJFYMiEgUGNEMjVUZJD02Z40
1:VUZJD3X@03YJVQ00NQ00B>ZHjY0j400jV>Z@0:X@0QSZV>ZHjYSZV>UI2E
T9F@UI2ET9F@UI2ET9F@UI2ET9F@00RQ01:ET9F@UI2ET9F@UI2ET9F@UI0L
X@07ThjCSY>>T`07X@06ThjCSY>>9Z401HidSWB>00BQ00EdSZ6>M00;X@0:
M8idSWB>M8idSP`10@0000l107RQWJ6MXIfQWJJ>YXjVSZJ>XIfQWJ6MXIfV
SZJ>T7NVSZJ>YXj@Mi1gT7N@Mi2>YYfQWJ6MXIfQWJ6>YHjUWJ6MYHjQWJ6M
XIfQWJF>YHjQWJ6>YHjQWJ6MXIfQWJ6MYHjUSZF>YHjUMY1fT7J@MY1fT7J@
MY1fT7H7X@1nSZEfT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY2MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQSHj=SXf>SJ6MXIfQWJ6=SXf>SJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXGB=M8edXIfQWHedXGB=
2j402XedSGB=M8edSG@<0@40000?0@RQ00RUZJFYMiFUZ@RQ01NUZJFYMiEg
UJFYYJUgUGNEMiEgUGNEM`0:X@04ZJFYY@>Q00>UZJ401j4018jYSZT3X@03
ZHjY00ZQ00b>ZHjYSZV>ZHjET9DEX@0<ZHjYT9F@UI2ET9F>1Z4029F@UI2E
T9F@EZ401HidSWB>00BQ00QdSZ6>M9F@U@RQ00YdSZ6>M8idSWB>30410000
3`40Ij6MXIfQWJ6MYXjVSY1gT7NQWJ6MXIfQWJJ>YXjQWJ6MYXjVSY1gT9fQ
WJ6MXIfQSY2MXIfQWJ6MXHjUSZFMXIfUWJ6MXIfQWJ6MYHjUSZ6MXHjUSZ6M
XIfQWJ6MXIfUSZF>YHjUSZD06:4038jUSZEfT7J@MY1fT0NQ06j@MY1fT7J@
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSGB=
M:6MXIf=M:5dSGJ@MPRQ00Z=M:5dSGB=M8ed304100003`48X@04YJVUZ@bQ
00BUZJFY1:401:FYYJT;X@03ZJFQ01RQ00>>ZHh01:400jV>Z@0:X@09SZV>
ZHjYSZV>01RQ01ZYSZV>ZI2ET9F@UI2ET9F@UI2ET9F@UI2ET5JQ00F>M8id
SP05X@07SZ6>M9F@U@08X@0:M8jQSWB>M8idSP`10@0000l106NQWJ6MXIfQ
WJJ>YXjQWJ6MXIfQWJ6MXIfVSZJ>XIfQWJJ>YXjQWJ6MXIfQWJ6MXHjVWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJF>YHjUWJ6>YHjQWJ6MXIfQWJ6MYHjU
SZF>YHjU01RQ086>YHjUSZF>T7J@MY1fT7J@MY1fT7J@MY1fT9fQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQM8edSGBQWJ6MXGBQ
M8efT7H02J402GBQM8edSGB=M00<0@40000?0@RQ00BUZJFY3:401:FYYJT4
X@04YJVUZ@^Q00>YYJ406:402XjYSZV>ZJ6YSZT:X@09SZV>ZHjYSZV>01RQ
01ZYSZV>ZHjYSYF@UI2ET9F@UI2ET9F@UI2ET5JQ00J>M8idSW@4X@04SWB>
M0bQ00V>XHidUGB>M8h0304100003`40Ij6MXIfQWJ6MYXjVSZ6MXIfQWJ6M
XIfQWJJ>YXjQWJ6MYXjVSZ6MXIfQWJ6MXIfQSZJMXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MYHjUSZF>YHjUSZ6MXIfQWJ6MXIfUSZF>YHjUSZD06:40OXjU
SZF>YHjUSY1fT7J@MY1fT7J@MY1fT7J@WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSGB=M8fMXIfQM8edS@bQ00UdSGB=XHed
SG@0304100003P4IX@04YJVUZ@BQ00BUZJFY2j400jVUX@0HX@0<SZV>ZHjY
SZV>ZGNE2:402HjYSZV>ZHjYSP0HX@0CZHjYSZV>ZHjYSYF@UI2ET9F@Z@1M
X@07SWB>M8idSP03X@04SWB>M0bQ00V>M8idXGB>M8h0304100003P40J9fQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfVSZJ>YXjQWJJ>YXjQWJ6MXIfQWJ6M
XHjVWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJF>YHjUSZF>YHj@Mj6MXIfQ
WJ6MYHjUSZF>YHjU2Z401gJ@MY1fT7H01j40G8jUSZF>YHjUSZF>YGJ@MY1f
T7J@MY1fT7J@WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ2WL069fQWJ6MXIfQWJ5d
SGB=M8edSIfQM8edS@bQ00UdSGB=XHedSG@0304100003P4IX@0<YJVUZJFY
YJ6UZJFY2j400jVUX@0HX@0<SZV>ZHjYSZV>ZGNE2:402HjYSYEgZHjYSP0:
X@07ZJFYT9F@U@07X@0JZHjYT:V>ZHjYSZV>ZI2ET9F@UI2ET9F@UI12X@0:
SWNEMiEgUGNEM`ZQ00R>M8idSWB>M0:Q00B>M8id3:402HidSWBQM8idSP0<
0@40000>0@1XWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJJ>YXjVSZJ>YXjV
SZ6MXIfQWJ6MXIfQSZJMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MYHjUSZF>
YHjUSZFMXIfQWJ6MXIfUSZEgT7NUSZD:X@05SZF>T8h02J40@8jUSY1fYHjU
SZF>YHjUMY1fT7J@MY1fT7J@WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ49M`0eXIfQWJ6MXIfQWJ6MXIfQWJ6MXGB>M8jMXIfQWJ6M
XIfQWJ6MXIfQM8edSGB=M8edXGB=M8d03:402GB=M8fQSGB@M00<0@40000>
0AVQ00nUZJFYYJVUZJFYYJUgUGL02:400jVUX@0HX@0:SZV>ZHjYSZV>Z@ZQ
00>>ZHh00j400hjYSP0:X@05ZJFYT9D02J400jV>Z@02X@0ESZV>ZHjYSZV>
ZI2ET9F@UI2ET9F@02JQ00VCMiEgUGNEMiD04j4018j=UHd@X@0>SWBEM8id
SWB>M8idSW@<X@09SWB>M:5dSY2>00`10@0000h106RMXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MYXjVSZJ>YXjVSZIgT7N@WJ6MXIfQWJ6>XIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfUSZF>YHjUSZF>YHjQWJ6MXIfQWJF>YIfQWJF>
Y@ZQ00>>YHh00Z400jEfX@06X@03SZF>00:Q01nUSZF>YHjUSZF>YGJ@MY1f
T7J@SZ6MXIfQWJ6MXIfQ00Ug036QWJ6MXIfQWJ6MXIfQWJ6MXIfQSHj=SYfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXGB>009g01jMXIfQWJ6MXIfQWJ6MXIfQ
M8fMSGB=M8edSGB=M8d<X@07M8edSGB=M002X@`10@0000h16J403jFYYJVU
ZJFYYJVUZJFYY@0SX@0<SZV>ZHjYSZV>ZJFY2:400hjYSP03X@03SZV>00ZQ
00>YYJT00Z400jFYX@06X@03ZHjY00:Q01B>ZHjYSZV>ZHjYSZV>UI2ET9F@
U@^Q00VCMiEgUGNEMiD04j4019>>UHhHX@0:SXfQXHigUGNEM`ZQ00j>M:5d
SWB>M8idSWB>M0bQ00N>M8idSWB>00:Q304100003P40J9fQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJF>YHjUSZF>YHjUSZ6MXIfQWJ6MYHjUWJ6M
YHjU2Z400hjUSP02X@03YHjQ00JQ00>>YHh00Z408JF>YHjUSZF>YHjUSZF>
T7J@MY1fT9fQWJ6MXIfQWJ6=SP07M`0EXIfQWJ6MXIfQWJ6MXIfQWJ6MXHf>
009g01jMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSYfQM8h4M`0HWJ6MXIfQ
WJ6MXGB=WHedSGB=M8edSGB=3:401gB=M8edSG@00Z400hd10@090@40000>
0D^Q00b>ZHjYSZV>ZHjYYJT8X@03SZV>00>Q00>>ZHh06:400jV>Z@02X@0E
SZV>ZHjET:V>ZHjYSZV>ZI2ET9F@00ZQ00FCSYEgT`0GX@09ThjQXI=gUGNE
01>Q00Z>SJ6QSXfEMiEg2Z403XidXGB>M8idSWB>M8id3:401hidSWB>M8h0
0Z400g@10@090@40000>0@1XWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MYHjUSZF>YHjUSZ6MXIfQWJ6MXIfUSZFMXIfUSZDHX@03SZF>00:Q00FU
SZF>Y@02X@09SZF>YHjUSZF>00D100bMXIfQWJ6MXIfQSHh3M`0MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6=SYfQSHh00gL06Z6MXIfQWJ6MXIfQWJ6MXIfQ
WJ5dSYfQM8id0gL069fQWJ6MXIfQWJ5dSIf=M8edMgB=M8edS@bQ00MdSGB=
M8ed00:Q00>=0@402@4100003P5;X@0<SZV>ZHjYSZV>ZHjY2:402HjYSZV>
XHjYSP0HX@0:ZHjYSZV>ZHjYSP:Q00VYSZV>ZHjYSZT01@4:X@03ThjQ00:Q
00B>UGNE4j401Y>>XJ6CSRZQ00j>M:5dSWB>MhidSWB>M0bQ00Z>M8idSWB>
M:5d2`4100003P40J9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJF>
YHjUSZF>YHjUSZFMXIfQWJ6MYHjUSZF>YHjU6:402XjUSZF>YHjUSZD2X@09
SZF>YHjUSZF>00D1016MXIfQWJ6MXIfQSHjMXIf>S@02M`1AXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXHf>WJ6=SXfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXGB=WHedSGAgM8edSGB=00bQ00YdSGB@M8edSGB=2`41
00003P5:X@0@ZHjYSZV>ZHjYSZV>ZHjYSPFQ00V>ZHjYSZV>ZHh06:402ZV>
ZHjYSZV>ZHh2X@09ZHjYSZV>ZHjY00D12Z400i>>X@02X@04SY=gUA>Q00NC
SZ6QThjC02VQ00j>M8idSWB>XHidSWB>M0bQ00Z>M8igSWB>M8id2`410000
3P40>IfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQW@09M`0VWJ6MXIfQWJ6>YHjUSZF>YHjUSZF>YHjU
SZ6MXIfUSZF>YHjUSZDHX@0:SZF>YHjUSZF>Y@:Q00V>YHjUMY1fYHh01@40
J9fQWJ6MXIfQWJ6=SYfQWHj=SXfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQM8ed
SGB=M:5dSGB=M8egT7N@2:402WB=M91gT7B=M8d;0@40000>0CVQ00VUZGNE
MiEgUGL02:404ZV>ZHjYSZV>ZHjYSZV>ZHjYSP>Q00V>ZHjYSZV>ZHh06:40
2ZV>ZHjYSZV>ZHh2X@04ZHjYSP>Q00>>Z@40104:X@03ThjQ00:Q00B>ThjC
@j404XidSWB>M8jQSWB>M8idUGNEM`RQ00Z>M8igUGNEM8id2`4100003P40
89fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ2GL05:6MXIfQWJ6M
XIfQWJ6MXIfUSZF>1GL039fQWJ6MXIfQSZF>Y@9g01R>YHjUSZF>YHjUSZF>
YIfUSZF>YHjUSZDHX@0@SZF>YHjUSZF>YHjQSZF>Y@>Q00>USP401040I9fQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQM8edSGB=
M:5dSGB=M8d<X@0:M91dT7N@MhedS@/10@0000h18:402JVUUGNEMiEgU@0@
X@08YJVUZGNEYJT9X@0NZHjYSYEgUHjYSZV>ZHjYSZV>ZHjYSZV>ZHjYSZV>
6:404:V>ZHjYSZV>ZHjYSZV>ZHh3X@03SZT100@1EZ403XidSWB>M8jQSWB>
M8id3:400hjQX@04X@03M8id00/10@0000h100RMXIfQWJ6MX@Qg01BMXIfQ
WJ6MXIfQWJ6MXIfQSZJ>YPEg01BQWJ6MXIfQWJ6MXIfQWJ6MYHjUSPAg02ZQ
WJ6MXIfQWJ6>YHjUWJ6MYHjUSZF>YHjUSZF>YHjUSZF>YHjUSZEgT7LEX@0@
SZF>YHjUSZF>YHjUSZF>Y@>Q00>USP401040J9fQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQM8edSGB=M:5dSGB=MhegT7N@2:40
0gBQX@04X@03SGB=00/10@0000d12J402:VUUGNEMiEg4:402:VUZJFEMjVU
4J401:FYYJT4X@03YJ6Q00JQ00BYSZV>0j406XjYSZV>ZHjYSZV>ZHjYSZV>
ZHjYSZV>UGNE5J404:V>ZHjYSZV>ZHjYSZV>ZHh3X@03SZT100@1EZ404Xid
SWB>M8jQSWB>M:5dUGNEM`RQ00B>XJ5d0j400gB>M00;0@40000=0@0UXIfQ
WJ6MXIfQSZJ>YXjVSZJMXIfQWJ6MXIfQWJ6MXIfQSZJ>YP04M`13WJ6MXIfQ
WJ6MXIfQWJ6MXIfUSZF>XIfQWJFMXIfQWJ6MXHjUSZFMXIfUSZF>YHjUSZF>
YHjUSZF>YHjUSZF>YGN@M`0EX@0@SZF>YHjUSZF>YHjUSZF>Y@>Q00>USP40
1040I9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
M8edSGB=M8edSGB=WHd<X@04M:6QS@>Q00>=M8d02`4100003@49X@08ZJFY
YIEgZJD@X@04ZJFYY@BQ00>YXJ403Z401:FYYJT4X@03YJ6Q00JQ00BYSZV>
0j406XjYSZV>ZHjYSZV>ZHjYSZV>ZHjYSZV>XGNE5J405JV>ZHjYSZUgUHjY
SZV>ZHjYSZV>Z@050EJQ00n>M8idSWB>M8idSWBQM8h02j4018jQXG@3X@03
M8id00/10@0000d100fQWJ6MXIfQWJ6>YXjV00Ag04RMXIfQWJ6MXIfQWJ6M
XIfQSZJ>YYfQWJ6>XIfQWJ6MXIfQWJ6MXIfQWJF>YHjQWJ6MYIfQWJ6MXIfQ
SZF>YIfQWJF>YHjUSZD2M`0ASZF>YHjUSZF>YHjUSZEgT7L05J405HjUSZF>
YHj@Mi2>YHjUSZF>YHjUSP050@1UWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ5dSGB=M8edSGB=M8fMSG@02j4017BQXHd3X@03
SGB=00/10@0000d12J401:VUZJDDX@04ZJFYY@BQ00>YXJ407j401:V>ZHh3
X@0GSZV>ZHjYSYEgUHjYSZV>ZHjYSZV>ZHh06:405JV>ZHjYSZUgUGNESZV>
ZHjYSZV>Z@050EJQ00n>M8idSWB>M8idSWBQM8h02j4018idXG@3X@03M8id
00/10@0000d106VQWJ6MXIfQWJ6>YXjVWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6>
YXjVWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6>YHjU
WJ6MYHjUSZF>YIfQWJF>YHjUSZF>YHjUSZD02Z401gN@Mi1gT7L01j405HjU
SZF>YHj@Mi1gT8jUSZF>YHjUSP050@1UWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSGB=M8edSGB=M8fMSG@02j4017B=M8d3
X@03SGB=00/10@0000d12J401:VUZJDnX@0>ZHjYSZV>XHjYSZV>ZHh3X@0=
SZV>ZHjYSZV>ZHjYSP0:X@07ZJFEMiEgU@07X@0EZHjYMjV>ZGNEMiEgUGNY
SZV>ZHjY00D1EZ403hidSWB>M8idSWB>M:5dSP0;X@04SWB>M0>Q00=dSW@0
2`4100003@40JJ6MXIfQWJ6MXHjVSZJMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXHjUSZF>
YHjUSZF>YHjUWJ6MYHjUSZF>YHjUSZF>Y@0:X@05SZEgT8h02J401hjUSY1g
YHh01j40LHjUSZ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQM8edSGB=M8edSGB=M8ed00^Q00AdSGB=0j400heg
S@0;0@40000=0D^Q00jYSZV>ZHjYSZV>ZHjYSP>Q00f>ZHjYSZV>ZHjYSZV>
00ZQ00NYYIEgUGNE00NQ00>YSZT00Z400hjYX@1XX@0?SWB>M8idSWB>M8id
SWB>00^Q00B>M8id0j400gBEM00;0@40000=0@1SXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQSZF>YHjUSZF>YHjUSZFMXIfUSZF>YHjU009g00B>
YHjU2Z40SHjUXJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXGB=
M8edSGB=M8edSGB=M00;X@04M8edS@>Q00>=XHd02`4100003@5;X@0>ZHjY
SZV>ZHjYSZV>ZHh3X@09SZV>ZHjYSYEg08bQ00n>M8idSWB>M8idSWB>M8h0
2j4018idSW@3X@03M:5d00/10@0000d10?nQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6>YHjUSZF>YHjUSZF>YIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWHed
SGB=M8edSGB=M8d00J4<X@03SGB=00>Q00>=XHd02`4100003@7NX@0:SGag
O7MlMgagO0ZQ00idSWB>M8idSWB>M8idSPbQ00=dSW@00j400gBQM00;0@40
000=0@3PXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MSW@8M`0HXIfQWJ6MXIfQWHegSGB=M8edSGB=M8ed3:400hedS@05X@03
S@4100T10@0000d1`J402Y=gO7MlMgagO7LCX@04SHigSQ2Q00idO7N>M8id
SWB>M8idSPbQ00=dSW@01:400hid0@0:0@40000=0@2UXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQ00Ug01FQWJ6MXIfQWJ6MXIfQWJ6MXIfQSHh0
27L05IfQWJ6MXIfQWJ6MXIfQWJ6MXIf>M002M`0NXIfQWJ6MXIfQWJ6MXIfQ
WHfMXGB=M8edSGB=M8ed3:400hedS@04X@03M8d100X10@0000d1YJ402I=g
O7MlMgagO00CX@05ThilMi<06:402Xf>XJ6=O7MlMg`:X@0>M:6QSWB>M8id
SWB>M8h<X@04M8idSP>Q00>>M0402P4100003@40RJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ00Ug036QWJ6MXIfQ
WJ6MXIfQWJ6MXIfQSHj=SXfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXHf>00=g
01jQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIf>M:6MSW@4M`0HXIfQWJ6MXIfQ
WHfMXGB=M8edSGB=M8ed3:401HedSGB=00:Q00=dS@402P4100003@69X@09
:XilMgagO7Ml01>Q00FCSWagT`0GX@03ThjQ00:Q00F>O7MlM`0CX@0:SHjQ
XHf>SGagO0ZQ00idXJ6>M8idSWB>M8idSPbQ00EdSWB>M002X@03SWB>00X1
0@0000d106jQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQW@Ug01:MXIfQWJ6MXIfQWJ6M
XIfQWJ46SP0HWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXHf>1gL06Z6MXIfQWJ6M
XIfQWJ6MXIfQWJ6=SYfQWHj=0gL06ifQWJ6MXIfQWJ6MXIfQWJ6MXIf>M:6M
SWB>M002M`0IXIfQWJ6MXIfQWHfMXGB=M8edSGB=M8edS@03M`RQ00Z=M8ed
SGB=M8ed2P4100003@5^X@09SRYgO7MlMgag01:Q00HZSRYgO8hFX@03ThjQ
00:Q00B>O7Ml4j400i>>X@02X@03SY>Q01FQ00V=SZ6QSHj=SWL02j404WBQ
XHidSWAlM8idSWB>M8igU@RQ00YdUGB>M8idSWB>2P4100003@40EZ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJF>1WL0;J6MXIfQ
WJ6MXIfQWJ6MXIfQWJF>YHjUSZ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MX@03SPIg
01ZQWJ6MXIfQWJ6MXIfQWJ6MXIfQSHjMXIf>S@9g05FQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQSHjMXIf>SJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWHfMXGB=M8fMSGB=M8edSGB=00VQ00Z=MhedSGB=M8ed2P41
00003@5DX@08SZV>O7MlMg`BX@06SRZ>O7Ml5J400bZ>:P03X@03:Xil01>Q
00>CSZ400Z4018jCSY<CX@03ThjQ00:Q00>>Tj40:J404WBQXHidSWBQM8id
SWB>M8idU@RQ00YdXGB>M8idSWB>2P4100003@40?:6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfU
SPIg01FQWJ6MXIfQWJ6MXIfQWJ6MXIfUSZD00WL0<8jUWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJF>YIfQWJF>MifQWJ6MXIfQWJ6MXIfQWJ6MX@>>00>QWJ400hh0
LZ6MXIfQWJ6MXIfQWJ6MXIfQWJ6=SYfQWHj=SXfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWHedXGB=M8fMSGB=M8edSGB=M0RQ00Z=XHedSGB=M8ed2P410000
3@4PX@09MgagO7MlMgag016Q00NUZJFYYJVU01>Q00J>ZHilMg`DX@03SRZ>
00>Q00>>:Xh04Z400bZ>:P03X@03:XhZ01>Q00>CSZ400Z4018jCSY=4X@0B
M8idSWB>M:5dSWB>M8idSWB>2:402WBQM8idSWB>M8h:0@40000=0@0RXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfVSPMg01BMXIfQWJ6MXIfQ
WJ6MXIfQWJF>Y@9g04Z>YIfQWJ6MXIfQWJ6MXIfQWJ6MXIfUSZFMXIfUSZ6M
XIfQWJ6MXIfQWJ6MXIfQWJF>YIfQWJF>YIfQWJ6MXIfQWJ6MXIfQWJ6MX@>>
00>QWJ400hh0M:6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWHedSGB=M8fMSGB=M8edSGB=M8ed1Z402XfQSGB=
MhedSG@:0@40000<0@RQ00VYYJUgO7MlMg`04:402:FYYJVUZJFY4Z402:FY
YGagO7Ml4Z400hjYSP03X@03SZVQ016Q00>>:Xh00j400hhZSP0BX@03:XhZ
00>Q00<ZSRX0H:405GB>M8idSWBQM8idSWN>M8idSWB>M005X@0:M:5dSWBQ
M8idSPX10@0000`100fMXIfQWJ6MXHjVSZJ>00Ag01BQWJ6MXIfQWJ6MXIfQ
WJ6MYXjVSPAg0=nQWJ6MXIfQWJ6MXIfQWJ6MXIfUSZFMXIfQSZ6MXIfQWJ6M
XIfQWJ6MXIfQWJF>YIfQWJF>XIfQWJ6MXIfQWJ6MXIfQWJ6MYHjUWJ6MYHjU
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSGB=M8edSIf=M8ed
XGB=M8edSGB=00FQ00Z=XHedSJ6=M8ed2P4100003048X@09ZJFYYJUgO:FY
012Q00BUZJFY1:400jFQX@0?X@03YJVU00BQ00>YXJ404:400hjYSP03X@03
SZVQ09FQ01IdSWB>M8idSWB>M8jQSWB>M8idSWB>1:402WB>M8idXGB>M8h:
0@40000<0@0=WJ6MXIfQWJ6>YXjVSP04M`3hXIfQWJ6MXIfQWJ6MXIfQWJJ>
YXjQWJ6MYYfQWJ6MXIfQWJ6MXIfQWJ6MYHjUWJ6MXHjQWJ6MXIfQWJ6MXIfQ
WJ6MXIfUSZFMXIfUSZ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWHedSGB=M8edSGB=M:5dSGB=
M8edSG@4X@0:SGB=M8fQSGAgM0X10@0000`12:401JVUZJFY01BQ00BUZJFY
1:400jFQX@0?X@03YJVU00BQ00>YXJ40[Z4067B>M8idSWB>M8idSZ6>M8ig
SWB>M8idSP:Q00YdSWB>M:5dSWN>2P4100003040oifQWJ6MXIfQSZJ>YXjQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJJ>YXjQWJ6MYYfQWJ6MXIfQWJ6MXIfQWJ6>
YHjUWJ6MXHjQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWHedSGB=M8edSGB=M00069fQWJ6MXIfQSZJ>YXjQWJ6MXIfQWJ6MX@X1
0@0000`12:401JVUZJFY01BQ00BUZJFYYj402WagO7MlMgagO7LMX@0@M8id
SWB>M8idSWB>XHidSP:Q019dSWB>M8idXGB>M8idXGB>XHh:0@40000<0@2i
WJ6MXIfQWJ6>YXjVSZ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXId07GL0;IfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSGB=M8ed
SGB=M8edXGB=M002X@0BSGB=M8edSGB=M8edSGB=M:5d2P4100003048X@05
ZJFYYJT0[:407HilMgagO7MlMgagO7MlMgagO7MlMgagO7MlMgag01fQ011d
SWB>M8idSWB>M8idSWB>0Z404WB>M8idSWB>M8idSWB>M8jQSPX10@0000`1
0;^MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWHj=00]g00Z=XIfQWJ6MXIfQ1WL0;IfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MSGB=M8edSGB=M8edSGB=M002X@0BSGAgM8edSGB=M8ed
SGB=M:5d2P410000306iX@0MSY>>O7MlMgagO7MlMgagO7MlMgagO7MlMgag
O7L07J4047B>M8idSWB>M8idSWB>M8h2X@0BM8igSWB>M8idSWB>M8idSZ6>
2P4100003040N9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MX@Ug03bQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWHj=SXdIM`0]WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIf=M8edSGAgM8edSGB=M8ed00:Q01:=M:6QSGB=M8edSGB=M8edSG@:0@40
000<0FJQ01]lMgagO7MlMgagO7MlMgagO7MlMgagO7MlMg`0>:4048jCSY>>
ThilMgagO7MlMg`ZX@0@M8idSWB>MgadSWB>M8idSP:Q019dSZ6QM8idSWB>
M8idSWB>M8h:0@40000<0@1XWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQSZDIM`1hXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIf>SHj=SXf>Mhj=SXf>SJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MSGB=M8ed0gL02gB=M8edSGB=M8ed00:Q00j=M8ed
SGB=M8edSGB=M0X10@0000`1IZ403jV>ZGMlMgagO7MlMgag:P09X@03O7Ml
03RQ00j>ThjCSY>>O7NCSY>>TbbQ01AdSWB>M8igO7MlM8idSWB>M8idSP:Q
00mdSWN>M8idSWB>M8idSW@02@4100003040K9fQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXHjUSZF>
YAEg03nQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWHj=SXf>SHh00gL0A8j=SXfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIegGgMOMemgGgMOXIfQWJ6MXIfQWHedSGB=M:6MXIfQM8ed
SGB=M8ed0Z403hedXJ6=M8edSGB=M8edS@090@40000<0B2Q015lMgagO7Ml
MgagO7MlMgagO00eX@0KZHjYSZV>ZHilMgagO7MlMgagO7MlMgagO7Ml03RQ
00j>ThjCSY>>O7MlMi>>TaVQ00V>MgagO7MlMg`02Z401WB>MhidSPFQ00V>
M8idSWB>M8h00Z403gB>XJ5dSWB>M8idSWB>M0090@40000<0@0JWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQSZHGM`2?XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6>YHjUSZF>YHjUSZF>
YHjUSZF>XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWHj=SXf>SHh01gL02J6MXIfQWJ6M
X@06M`0eWJ6MXIfQWJ6MXGB>M:6MXIfQWJ6MXIfQWJ6MXIf=M7MOSGBQWJ6M
XGB=M8edSGB=M8fQSG@00Z402hedSGB=M8edSGB=00T10@0000/16J404JVU
ZJElMgagO7MlMgbUZJFY00JQ00=gO:40=:404jV>ZHjYSZV>ZHilMgb>ZHjY
SZT0;J402GagO7MlMgagO00:X@07SY>>ThjCSP07X@0?SWagO7MlMgagO7Ml
Mgag00ZQ00V>SGagO7MlMg`02Z401WB>XJ5dSPFQ00f>M8idSWB>M8idSWB>
00:Q00]dSWN>M8idSWB>M0090@40000;0@0OXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXHjVSZJ>YP0:M`18WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6>YHjUSZF>YHjU
1GL0E:F>YHjQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6=SUmgGgMOMenQWJ6MXIfQWJ6MSXegGhj=SYfQWJ6MXIf>S@Yg
03R>WJ6MXIfQWJ6MXIfQM8jMXEmgGgMOXIfQWJ6MXIfQWHedXIf=M:6MXIfQ
M8edSGB=M8edSGB=M0:Q00^=M:5dSGB=M8edS@090@40000;0AVQ01VYYJVU
ZJFYYGagO7MlMgagO7MlMgagO7Ml03FQ01>YSZV>ZHjYSZV>O7MlMgagZHjY
016Q00TZSWagO7MlMg`04j401I>>TgNC00jQ00N>TgMlMi>>00NQ00n>ThjC
MgagO7MlMgagO7L02Z401Hj=XJ6>00jQ00IdSZ6QM8h5X@0=SWB>M8idSWB>
M8idSP02X@0;M8jQSWB>M8idSW@02@4100002`409J6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6>YXjVSZJ>YXjVSZH027L0A8jVSZJMXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6>YHjU
SZF>YHjU2GL04J6MXIfQWJ6MXIfQWJ6MXIfQ00J>03bMXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQSHj=MenQWJ6MXIfQWJ6MXIfQWHj=XIfQSHjMXIfQWJ6MSXf>
SHh:M`0eWJ6MXIfQWJ6MXGB>WJ5dSYfQWJ6MXIfQWJ6MXIf=M:6MSGBQWJ6M
XGB=M8edSGB=M8edSG@00Z402hedXGB=M8edSGB=00T10@0000/16J406:VU
ZJFYYJVUZJFYYGagZJFYYJVUZJFYYCJQ00ZYSZV>ZHjYSZV>2J4028jYMgag
O7Ml2J401RZ>:WMlMaJQ00>CSY<00Z4018jCMg`:X@03SY>Q00:Q00>CSZ40
1Z403hjCSY>>TgMlMgagO7MlM`0:X@06SXfQXHj=3J401WB>XJ5dSPFQ01Z>
M8idSWB>M8idSWB>M8idSZ6>M8igSWB>M0T10@0000/102FQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQSZJ>YXjVSZJ>YXjV00Ag05B>YXjVSZJ>YYfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXHjUGgMOMemgGj6MXIfQ
WJ6MXHjUSZF>YHjUSZFMXIfQWJ6MXIfUSZD5M`09XIfQWJ6MXIfQ00>>00>Q
WJ400Xh0?EnQWJ6MXIfQWJ6MXIfQWJ6MXIfQSHj=XIf>SHjMXIfQWJ6MXIfQ
WHj=XIfQSHjMXIfQWJ6MSXf>SHj=SXd01gL0@YfQWJ6MXIfQWJ5dSYfQM8jM
XIfQWJ6MXIfQWJ6MSGBQWHedXIfQWJ5dSGB=M8edSGB=M8edSGB=M:5dSGBQ
M8edS@T10@0000/16J406:VUZJFYYJVUZJFYYGagO7MlMgagZJFYY@ZQ00Ql
MgagO7MlMa:Q00NYSZV>ZHjY00^Q00ZYSZUgO7NYSZV>2J4028jYSZV>ZGMl
2J400bZ>:P03X@03:XhZ01>Q00>CSY<00Z400hjCSP0;X@03SY>Q00:Q00>C
SZ401Z403hjCSY>>ThjCSWagO7MlM`0:X@06SXfQXHj=3Z401HjQXGB>00FQ
01Z>M8idSWB>M8idSWB>M8idSZ6>M8jQSWB>M0T10@0000/102FQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQSZJ>YXjVSZJ>YXjV00]g05^QWJ6MXIfQWJ6M
XHjUSZEOMemgWJ6MXIfQWJ6MXIfQWJ6MXIfQSZF>MemgGj6MXIfQWJ6MXIfQ
SZF>XIfQSZF>YIfQWJ6MXIfQWJF>YHjUSZEgXIfQWJ6MXIfQ00>>00>QWJ40
0hh0?Z6MXIfQWJ6MXIfQWJ6MXIfQWJ6=SXfQWHj=SYfQWJ6MXIfQWJ6MSXfQ
WJ6=SYfQWJ6MXIf>SHj=SXf>SHj=1GL0@YfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXGBQWHedXIfQWJ5dSGB=M8edSGAgM8edSGB=M:5dSGBQM8ed
S@T10@0000/16J403jVUZJFYYJVUZJFYYGagO008X@03YJVQ00RQ00NYYJVU
O7NY01>Q00>YSZT01:400hjYX@08X@03ZHjY00>Q00>YSZT02Z4028jYSZV>
ZHjY2J400bZ>:P03X@03:XhZ01>Q00>CSY<00Z400hjCSP0;X@03SY>Q00:Q
00>CSZ401Z403hjCSY>>ThjCSY>>TgMlM`0NX@05SWBQM8h01J406XigSWB>
M8idSWMlM8idSWB>M8idSZ6>M7ad2@4100002`40Rj6MXIfQWJ6MYXigGgMO
MenQWJ6MXIfQWJ6>YXjVSZJ>YXjVSZJMXIfQWJ6MXIfQWJJ>XIfQWJ6MXIfQ
SZF>YEmgGgNMXIfQWJ6MXIfQWJ6MXIfQWJ6>YHjQWJ6MYHjQWJ6MXIfQWJ6>
YHjQWJ6>YHjQWJ6MXIfQWJ6MYHjUSZF>YHjQWJ6MXIfQWJ400hh00j6MX@03
SP1dXIfQWJ6MXIfQWJ6MXIfQWJ6MXHf>SJ6MSXf>WJ6MXIfQWJ6MXIf>SJ6M
XHf>WJ6MXIfQWHj=SXf>SHj=SXf>SGN=SYfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXGB=M8edXIfQWJ5dMen=M8edSG@3M`0>M8edSGB=M8edXGB=
XHd90@40000;0@RQ00RUZJFYYJVUZ@VQ00bYYJVUO7MlMjVUZJD;X@03YJVQ
00RQ00BYYJVU0j400jFQX@0@X@03ZHjY00BQ00>>ZJ402:400jV>Z@03X@03
ZHjY00ZQ00R>ZHjYSZV>Z@VQ00<ZSRX00j400bZ>:P0VX@03SY>Q00:Q00>C
SZ401Z403hjCSY>>ThjCSY>>TgMlSP0NX@05SWB>M8h01J406XjQXGB>M8id
SWMlMhidSWB>M8idSZ6>M:5d2@4100002`40e:6MXIfQWJ6MYXjVSWMOMenQ
WJ6MXIfQWJ6>YXjVWJ6MXHjVSZJMXIfQWJ6MXIfQWJJ>XIfQWJ6MXIfQSZF>
YIfQWJFMXIfQWJ6MXIfQWJ6MXIfQWJ6>YHjQWJ6MYHjQWJ6MXIfQWJ6>YHjQ
WJ6>YHjQWJ6MXIfQWJ6MYHjUSZF>YHjQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWHj=SXfQSHjMXIfQ
WJ6MSXegGhj=SXf>SHj=0gL0<IfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXGB=M8edXIfQWJ5dXIf=M8edSG@01:403HedSGB=M8edXGB=XHd02@41
00002`48X@04YJVUZ@fQ00BYYJVU1:401:VUZJD;X@03YJVQ00RQ00BYYJVU
0j400jFQX@0@X@03ZHjY00BQ00>>ZJ402:400jV>Z@03X@03ZHjY00ZQ00R>
ZHjYSZV>ZCRQ00N>ThjCSY>>00NQ00n>Tj6QSY>>ThjCSY=gO7L07Z401Hid
SWB>00FQ00V>XJ5dSWAlM8h01:403GB>M8idSWB>M8idXG@02@4100002`40
e:6MXIfQWJ6MYXjVSZ6MXIfQWJ6MXIfQWJ6>YXjVWJ6MXHjVSZJMXIfQWJ6M
XIfQWJJ>XIfQWJ6MXIfQSZF>YIfQWJFMXIfQWJ6MXIfQWJ6MXIfQWJ6>YHjQ
WJ6MYHjQWJ6MXIfQWJ6>YHjQWJ6>YHjQWJ6MXIfQWJ6MYHjUSZF>YHjQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWHj=SXf>SHjMXIfQWJ6MSXfQWHj=SXf>SHj=0j40<IfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXGB=M8edXIfQWJ5dXIf=M8eOSG@01:40
3HedSGB=M8edSGB=XHd02@4100002`48X@04YJVUZ@fQ00BYYJVU1:401:VU
ZJD;X@03YJVQ00RQ00BYYJVU0j400jFQX@0RX@03ZHjY00>Q00BYSZUg2J40
28jYSZV>ZHjY>:401hjCSY>>Thh01j4038jCXJ6>ThjCSY>>Tb6Q00F>M8id
SP05X@09SZ6QM8idXGB>00BQ00edSWB>M8idSWB>M:5d00T10@0000/10=BQ
WJ6MXIfQWJJ>YXjQWJ6MXIfQWJ6MXIfQSZJ>YYfQWJ6>YXjVWJ6MXIfQWJ6M
XIfVSZ6MXIfQWJ6MYHjUSZFMXIfUWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQSZF>YHjQSZF>XIfQWJ6MXIfQWJF>YEmgSZF>XIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIf>SHj=SXf>WJ6MXIfQWHj=XIf>SHj=Men>S@>Q036MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSGB=M:6MXIfQM:6MSGB=XHed00BQ00f=
M8edSGB=M8edSGB=00T10@0000/12:401:FYYJT=X@04ZJFYY@BQ00BYYJVU
2j400jFYX@0dX@0:ZHjYSZV>ZHjYM`VQ00>>ZHh00Z400jV>Z@0hX@07SY>>
ThjCSP07X@08SY>QXHjCSY<2X@03SY>Q022Q00F>M8idSP05X@09SZ6QM8id
XGB>00BQ00edSWB>M8idSWB>M8id00T10@0000/10=2QWJ6MXIfQWJJ>YXjQ
WJ6MXIfQWJ6MXIfVSZJ>YYfQWJ6>YXjVGgMOXIfQWJ6MXIfVSZ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
SZF>YHjUSZF>YIfQWJ6MXIfQWJF>YIfQSZF>XIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIf>SHj=SXf>
WJ6MXIfQWHj=XIf>SHj=0Z400hj=X@02X@0aWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQM8edSGBQWJ6MXGB=WHedSJ6=M004X@0=SGB=M8edSGB=
M8edS@090@40000:0AVQ00BUZJFY1J401jVUZJElMg`02:400jFYX@0dX@0:
ZHjYSZV>ZHjYSPVQ00>>ZHh00Z400jV>Z@0hX@07SY>>ThjCSP0dX@05SWB>
M8h01J402HidSWB>M:5dSP04X@0>M8idSWB>M7adSWB>M8h80@40000:0@3o
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJJ>YXjVSZJ>YXjVSZIOMenQWJ6M
XIfQWJJ>XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6>YHjUSZF>YHjUWJ6MXIfQWJ6MYHjUWJ6>YHjQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQM8edSGBQWJ6M000:WJ6MXIfQWJ6MX@BQ
00j=M8edSGB=MhedSGB=M0P10@0000X16J403JFYYJVUZJFYYJVUZJD02j40
0jFYX@0dX@0:ZHjYSZV>ZHjYSPVQ00>>ZHh00Z400jV>Z@1cX@05SWB>M8h0
1J402HidSWB>M:5dSP04X@0>M7adSWB>M7agSWB>M8h80@40000:0@3oWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJJ>YXjVSZJ>YXjVSZ6MXIfQWJ6MXIfQ
WJJ>XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6>YHjUSZF>YHjUWJ6MXIfQWJ6MYHjUWJ6>YHjQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQM8edSGB=M:6M000:WJ6MXIfQWJ6MX@BQ00N=
GhedSGB=00=g00B=M8ed204100002P4IX@0<YJVUZJFYYJVUZJFY3:400jFY
X@0cX@09SZV>ZHjYSZV>08JQ00R>M8idSWB>M0:Q00V>M8idSWB>M8h01:40
1gBQXHidSW@01:400hidSP080@40000:0@3oWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJJ>YXjVSZJ>YXjVSZ6MXIfQWJ6MXIfQWJJ>XIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQM8edSGB=M8fM000:WJ6MXIfQWJ6MX@BQ00N=XJ5dSGB=00BQ00=dSG@0
204100002P4IX@0<YJVUZJFYYJVUZJFY3:400jFYX@32X@0CSWB>M8idSWB>
M8idSWB>M8idSP04X@07M:6QSWAlM004X@03SWB>00P10@0000X10?nMXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MYXjVSZJ>YXjVSZJ>XIfQWJ6MXIfQWJ6M
YXjQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ5dSGB=M8edSG@000ZMXIfQWJ6MXIfQ1:401hfQ
XGB=XHd01:400gB=M0080@40000:0AVQ00RUZJFYYJVUZMFQ01>>M8idSWB>
M8idSWB>M8idSWB>00BQ00MdXJ6>M:5d00BQ00>>M8h0204100002P40oifQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ5d
MemgGgMOMemgWJ6MXIfQWJ6MXGB=M8edSGB=M0002YfQWJ6MXIfQWJ44X@07
SJ6QM8fQS@04X@03M8ed00P10@0000X1aJ402UmgGgMOMemgGgLCX@04SXf>
SA2Q01>>M7MOSWB>M8idSWB>M8idSWB>00BQ00MdXJ6>M:5d00BQ00>>M8h0
204100002P40oifQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXEmg
GgMOMemgGj6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSXegGgMOMemgGj6MXIfQWJ6M
XIfQWJ6MXIfQWJ5dSUmgWJ6MXIfQWJ6MXIfQWJ6MXGB=WJ5dSGB=M0002YfQ
WJ6MXIfQWJ44X@07SGB=M8fQS@04X@03M8ed00P10@0000X1Z:402I>>Temg
GgMOM`0DX@04SY=OMaVQ00Z>SJ6QSXegGgMO2Z404hidXJ6>M8idSWB>M8id
SWB>M8h01:401gB>M8idXG@01:400hidSP080@40000:0@2<WJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ43SP1j
MemgGgMOXIfQWJ6MXIfQWJ6MXIfQWJ6MXHf>SGN=XIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MSXfQWJ6=MemgGj6MXIfQWJ6MXIfQWJ6MXIfQWJ5dSYfQM8id
MemgWJ6MXIfQWJ6MXGB=WJ5dSGB=M8edSGB=M8edSG@4X@07SGB=M8fQS@04
X@03M7Md00P10@0000X1L:402BZ>MemgGgMOM`0CX@06:XhZGgN>5Z402I>>
TemgGgMOM`0DX@03SY>Q00:Q00>CSZ405J402Xj=XJ6>SHj=SXd:X@0CSWBQ
XHidSUmgM8idSWB>M8idSP04X@07M8idSWB>M004X@03SZ6>00P10@0000X1
08bMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MMemg
GgMOMemgWJ6MXIfQWJ6MXIfQWJ6MXIfQSZF>YHjUSZ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MX@>>07agGgMOMenQWJ6MXIfQWJ6MXIfQWJ6MXIfQSHj=XIf>SHiO
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIf>SJ6MXHf>WJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXGB>WJ5dSWB>GgNMXIfQWJ6MXIfQM8fMXGB=M:6MSGB=M8edSGB=M8ed
0Z401hedSGB=M8d01:400gBQM0080@40000:0C^Q00UOMemgGgMOMel04J40
28jYSZV>ZHjY4j402BZ>:XigGgMOM`0CX@03:XhZ00>Q00<ZSRX04j400i>>
T`02X@04SY>>TaBQ00>>Tj400Z400i>>X@0EX@08SXfQXHj=SXd<X@07SWBQ
XHidSP02X@0FM8idSWB>M8idSWB>M:5dSWB>M8idSP>Q00>>XHh020410000
2P40S9fQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWGMOMemgGgMO
MifQWJ6MXIfQWJ6MXIfQWJ6MYHjUSWMOMemgWJ6MXIfQWJ6MXIfQWJ6MXIfU
SZF>MemgWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6>YHjUWJ6MYHjQWJ6MXIfQWJ6M
XIfQWJ6MXIfQ0hh00j6MX@03SP20XIfQWJ6MXIfQWJ6MXIfQWJ6MXHf>SJ6M
SXf>SJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSXfQWJ6=SYfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ5dSYfQM8idSYfQWJ6MXIfQWJ6MXGB=WJ5dSGBQWHedSGB=M8ed
SGB=M8edSGB=M8edSG@3X@03M:5d00P10@0000T18Z402JFYYJUOMemgG`0A
X@07YJVUZEmgG`0CX@04SZV>Z@>Q00>YSZ404J4012Z>:Xh3X@03SRZQ01:Q
00<ZSRX00j400bZ>:P0CX@03ThjC00:Q00B>ThjC5:400hjCX@02X@03ThjQ
01FQ00R>SJ6QSXf>S@bQ00N>M:6QSWB>00:Q01IdSWAgGhidSWB>M8idSWB>
M8idSWB>0j400hjQSP080@4000090@2=XIfQWJ6MXIfQSZJ>YUmgGgNMXIfQ
WJ6MXIfQWJ6MXIfQWJJ>YXigGgMOXIfQWJ6MXIfQWJ6MXIfQWJ6MYHjUSZ6M
XHjUWJ6MXIfQWJ6MXIfQWJ6MXIfUSZF>XIfQSZFMXIfQWJ6MXIfQWJ6MXIfQ
WJ6>YHjUWJ6MYHjQWJ6MXIfQWJ6MXIfQWJ6MXIfQ00>>00>QWJ400hh0P:6M
XIfQWJ6MXIfQWJ6MXIfQWJ6=SXfQWHj=SXfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WHj=XIfQSHjMXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MSIfQM8edXIf=M8fMXGB=M8edSGB=M8edSGB=M8ed0j400gBQM008
0@4000090@VQ00RYYJVUMemgGa6Q00BUZJFY1:400jFQX@0?X@04YJVUZ@>Q
00>YYJ404:4018jYSZT3X@03ZHjQ016Q00@ZSRZ>0j400hhZX@0BX@03:XhZ
00>Q00<ZSRX04j400i>>T`02X@04SY>>TdJQ00IdSWB>M8h2X@03M8id00:Q
016>M8idSWB>M8idSWB>M8idSP03X@03SWB>00P10@0000T108fQWJ6MXIfQ
WJ6>YXjVWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MYXjVSZ6MXIfVWJ6MXIfQWJ6M
XIfQWJ6MXIfUSZF>XIfQSZFMXIfQWJ6MXIfQWJ6MXIfQWJF>YHjQWJ6>YIfQ
WJ6MXIfQWJ6MXIfQWJ6MXHjUSZFMXIfUSZ6MXIfQWJ6MXIfQWJ6MXIfQWJ40
0hh00j6MX@03SP20XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIf=M8edSGBQWHedSIfQM8edMgB=M8edSGB=
M8edSG@3X@03M8ed00P10@0000T12J401:VUZJDEX@04YJVUZ@BQ00>UXJ40
3j401:FYYJT3X@03ZJFQ012Q00B>ZHjY0j400jV>X@0AX@04:XhZSP>Q00>>
:Z40OJ401WB>M8idSP:Q00=dSW@00Z404HidSZ6>M8idSWB>M8idSWB>00>Q
00>>M8h0204100002@40oj6MXIfQWJ6MXHjVSZJMXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfVSZJ>XIfQWJJMXIfQWJ6MXIfQWJ6MXIfQWJF>YHjQWJ6>YIfQWJ6M
XIfQWJ6MXIfQWJ6MYHjUSZ6MXHjUWJ6MXIfQWJ6MXIfQWJ6MXIfQSZF>YIfQ
WJF>XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MSGB=M8ed
X@005j6MXIfQWJ6MXHjVSZJMXIfQWJ6MXIfQ00>Q00=dSG@0204100002@49
X@04ZJFYYAFQ00BUZJFY1:400jFQX@0?X@04YJVUZ@>Q00>YYJ404:4018jY
SZT3X@03ZHjQ09RQ00]dSWB>M8idSWB>M002X@0BSWB>XHidSWB>M8idSWB>
M8id0Z400hidSP080@4000090@3oXIfQWJ6MXIfQSZJ>YYfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJJ>YXjQWJ6MYYfQWJ6MXIfQWJ6MXIfQWJ6MYHjUSZ6MXHjQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIf=
M8edSGB=000MXIfQWJ6MXIfQSZJ>YYfQWJ6MXIfQWJ6MXIfQWJ4020410000
2@49X@04ZJFYYAFQ00BUZJFYdZ402gB>M8idSWB>M8id00:Q00N>M8jQSWB>
00:Q00idSWB>M8idSWB>M8idSPP10@0000T10?nQWJ6MXIfQWJJ>YXjVWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWHedSGB=M8d000fQWJ6MXIfQWJJ>YXjV00:Q00j=M8edSGB=M8ed
SGB=M0P10@0000T1n:4057B>M8idSWB>M8idSWB>M8jQSWB>0Z403WB>Ghid
SWB>M8idSWB>204100002@40i:6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWAEO01=dSGB=M8edSGB=M8edSGBQM8ed
00:Q00j=M:5dSGB=M8edSGB=M0P10@0000T1aZ408UmgGgMOMemgGgMOMemg
GgMOMemgGgMOMemgGgMOMemgSHh9X@0KMemgGgMOMemgGhidSWB>M8idSWB>
M8idSWB>00:Q00mdSZ6>M8idSWB>M8idSW@01`4100002@40ZJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ407el02hj=SYfQWJ6MXIfQ02YO
00mdSGB=M8edSGB=M8edSG@00Z403hedXGB=M7MdSGB=M8edS@070@400009
0HfQ025gGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgSY<02J4057MO
MemgGgMOMemgGgMOMemgGgMO2J40>5mgGgMOMemgGgMOMemgGgMOMemgGgMO
MemgGgMOMemgGgMOMemgGgMOMen>M8idSWB>M8idSWB>0Z403gB>XHidSZ6>
M8idSWB>M0070@4000090@1aXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ407el3
SP09WJ6MXIfQWJ6M019O00ZQWJ6MXIfQWJ6M7Ul03:6MXIfQWJ6MXIfQWAiO
01f=M8edSGB=M8edSGB=M8edXGB=M:5dSGB=M8edS@070@4000090EJQ029O
MemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgN>:XhZ2J40BGMOMemgGgMO
MemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg
GgMOMemgGgMOMemgGgMOMhjCSY<06Z402EmgGgMOMemgG`0:X@0VMemgGgMO
MemgGgMdSWB>M8idSWB>M8idSZ6>M8jQSWB>XHidSW@70@4000090@0kXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQWJ6MXIfQWJ407Ul03HjUSZFMXIfQWJ6MXId0HUl07Xj=XIfQWJ6MXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQWAiO01V=M8edSGB=M8edSGBQM8edXGB=M:5d
SGB=00L10@0000T18J408WMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg
GjVUZJD9X@0_GgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg
GgMOMemgGgMOMel05:409gMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg
GgMOMemgGgMOM`09X@0;MemgGgMOMemgGgL04j40@7MOMemgGgMOMemgGgMO
MemgGgMOMemgGgMOMemgGgMOMemgGgMOMen>M8idSWB>M8idSWB>M8jQSWB>
XHidMg@70@4000090BEO00f>YXjVSZ6MXIfQWJ6M04=O01f>YHjUSZFMXIfQ
WJ6MXIfQWJ6MXIfQWJ6MXIfQW@09G`09WJ6MXIfQWJ6M04mO00VMXIfQWJ6M
XId02el05WB=M8edSGB=M8edSGBQM8edXGB=XHd70@40000=0@0=GgMOMemg
GgMOMemgG`08X@1>MemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg
GgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgSZV>
2J402emgGgMOMemgSZV>01ZQ04=gGgMOMemgGgMOMemgGgMOMemgGgMOMemg
GgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg00VQ
03agGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMdSWB>
M8idSWB>M8jQSWB>XHidXG@70@40000A0AeO01f>YXjVSZJ>YXjVSZJMXIfQ
WJ6MXIfQWJ6MXIfQW@08G`0<YHjUSZ6MXIfQWJ6M9El02IfQWJ6MXIfQW@0L
G`>>00VMXIfQWJ6MXId04El02IfQWJ6MXIfQW@14G`0CSGB=M8edSGB=M8ed
SGBQM8fQS@070@40000F0@0TMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg
GjVUZJFYYJVU5:40AGMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMO
MemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGbZ>:P08X@1VGgMO
MemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg
GgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMO
MemgGgMOMemg2J4077MOMemgGgMOMen>M8idSWB>M8idSWB>XHidXG@70@40
000J0@aO00RMXIfQWJ6MX@QO01b>YXjVWJ6MXIfQWJ6MXIfQWJ6MXIfQWJ6M
XIfQ9el02J6MXIfQWJ6MX@0]Ga>Q2El00hj=X@07XD1O016=M8edSGB=M8ed
SGB=M8fQS@070@40000R0@0oMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg
GgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg00RQ02AOMemg
GgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgLgX@0TMemgGgMOMemg
GgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMO4j402emgGgMOMemgGhj=00RQ
01QgGgMOMemgGgMdSWB>M8idSWB>M8idXG@70@40000V0B=O00RQWJ6MXIfQ
WB=O01V>YHjUSZF>YHjUSZF>YHjUSZF>YHjUSZF>03VQ75l00hf>S@0HXA]O
00idSGB=M8edSGB=M8fQS@L10@0002T106AOMemgGgMOMemgGgMOMemgGgMO
MemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg
GgMOMemgGgMOMemgGgMOMenYSZV>ZHjYSZV>ZHjYSZV>ZHjY?:402UmgGgMO
MemgGgL8X@0:GgMOMemgGgMOTaZQ02MOMemgGgMOMemgGgMOMemgGgMOMemg
GgMOMen>M8idSWB>M8idSW@01`410000;@4SG`03SZJ>00RQ8Ul04:F>YHjU
SZF>YHjUSZF>YHi0XCeO2:49G`0;SGB=M8edSGB=M8d01`410000<@402emg
GgMOMemgGgMO00RQ04UgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg
GgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMenYSZV>ZHjYSZV>ZHjY04:Q
029OMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg2:40;EmgGgMO
MemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMgB>M8idSWB>M0070@40
000h0AYO00J>YXjVSZHAX@YO2:48G`0:YHjUSZF>YHjUSTBQ?5l00hjQX@06
X@UO00N=M8edSGB=00L10@0003/100]OMemgGgMOMjFYY@08X@0:MemgGgMO
MjFYYANQ01iOMemgGgMOMemgGgMOMemgGgMOMemgGgMOZHjYSZU6X@0SGgMO
MemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMel02:40:7MOMemgGgMO
MemgGgMOMemgGgMOMemgGgMOMemgGgMOMen>M8idSW@70@40000o0AUO2:4I
G`03YHjU00NQ25l00jF>X@0NXC9O2:4JG`VQ6El017B=M8d70@4000150@0Q
GgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMO00NQ04=OMemgGgMO
MemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemg
GgMOMemgGgMOMemgGgMO00RQ03agGgMOMemgGgMOMemgGgMOMemgGgMOMemg
GgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgN>ThhFX@0LMemgGgMO
MemgGgMOMemgGgMOMemgGgMOMgB>M0L10@0004P1DUl7XAUO2Z4PG`NQ25l0
0hjQX@0FXAQO00=dS@401P410000C0408WMOMemgGgMOMemgGgMOMemgGgMO
MemgGgMOMemgGgMOMel7X@0lGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMO
MemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgN>ZHjY5:40>UmgGgMOMemg
GgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMO
MemgGi<8X@0?GgMOMemgGgMOMemgGgMO00RQ00QgGgMOMemgG`L10@000581
7el00jJQX@0>XAmO1j49G`nQ:El7XAmO7P410000F0406WMOMemgGgMOMemg
GgMOMemgGgMOZJFYYJVU4Z40>GMOMemgGgMOMemgGgMOMemgGgMOMemgGgMO
MemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgN>:P07X@0VMemgGgMOMemg
GgMOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMem30@40001J0AQO1j4GG`03
SZFQ00JQ3Ul7XAQOI`410000H0407WMOMemgGgMOMemgGgMOMemgGgMOMemg
GgMOMemgG`NQ01iOMemgGgMOMemgGgMOMemgGgMOMemgGgMOMemgGgN:0@40
001S0AIO]0410000o`4^0@40003o0Bh10@000?l1;P410000o`4^0@40003o
0Bh10@000001
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{302, 299.375},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cover", "Subsection"],

Cell["\<\
dia = 0.08;
ex = 0.4;
{u1, u2} = {0.001, 1};
{phi1, phi2} = 2 Pi{0, 2.43};
phi3 = phi2 + 2Pi/3;\
\>", "Input"],

Cell["\<\
res = 20;
thick = 0.0015;\
\>", "Input"],

Cell["\<\
rs[u_, phi_] := dia u Exp[phi/(2Pi)]
hs[u_, phi_] := u (phi+1)^-ex\
\>", "Input"],

Cell["\<\
param[u_, phi_] :=
    { rs[u, phi] Cos[phi], rs[u, phi] Sin[phi], hs[u, phi] }\
\>", "Input"],

Cell[CellGroupData[{

Cell["\<\
Module[{surf, lns, ln, rln, p23, us, u, phi},
      surf = ParametricPlot3D[Evaluate[param[u, phi]],
               {u, u1, u2, 2(u2-u1)/res}, {phi, phi1, phi2, Pi/res},
               DisplayFunction -> Identity ];
      us = Range[-u2, -u1, 2(u2-u1)/res];
      lns = ParametricPlot3D[Evaluate[Function[u, param[u, phi]] /@ us],
               {phi, phi1, phi2, Pi/res},
               DisplayFunction -> Identity ];
      ln = ParametricPlot3D[Evaluate[param[1.001u2, phi]],
               {phi, phi1, phi3, Pi/res},
               DisplayFunction -> Identity ];
      p23 = Range[phi2, phi3, Pi/res];
      rln = ParametricPlot3D[Evaluate[Function[phi, param[u, phi]] /@ p23],
               {u, u1, 1.001u2, 2(1.001u2-u1)/res},
               DisplayFunction -> Identity ];
      Show[ Graphics3D[{EdgeForm[], Thickness[thick],
                        surf[[1]], ln[[1]], lns[[ 1]], rln[[1]]}],
            PlotRange -> All, ViewPoint -> {1.7,-2,1.2},
            Boxed -> False ]
    ];\
\>", "Input"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003U0000g@P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6HconD0003U0000i@000>D0003U0000i@0008<000<10000G`0008<000<1
0000G`0008<000<10000G`00088000<10000H000088000<10000H0000880
00<10000H000088000<10000H000088000<10000H000088000<10000H000
088000<10040H000084000@10001H000084000@10001H000084000<10040
3P0O0C@0002100040@0100d17`080B`0001m00P1=0050BL0001g00H11000
0`400@1Q0000LP050@T000@10001H@0006h0104?00030@010640001Z00@1
4`020@8000<10000G@0006L00`4G00810P000`40001M0000H`040AX00P40
0`01001O0000H0030Al000<100403@0K0CP0001M00<18P0@0A/0204`0000
F`020A`02`400`01000^00@1;00005T00P4J00@12@020@800P5M0000E`02
0AP0104=008110040ET0001E00815P040A400P4800030@0005H0001D0003
0@0001<00`4E00810P000`40000400030@0005D0001B008150020AT000@1
00011`020ED0001A00030@0001400`4K00<12P020E<0001?00814@030Ah0
00<100409`4h0000CP000`40000?00817`060@03004100X000<100005P07
0C40001<00813`030A/01P4200811@020@T000<10000C@0004/000<10000
3@020AP01P4800811`020@P000<10000C00004X000<1000030020AH0104>
00812@020@L000<10000B`0004P00P4=00815P020A<000<100002@020@H0
00<10000BP0004L000<1000030000`40000C00<15@030@H01P4600030@00
04T0001600030@0000`000<100004P020AH02`4600H100<00@00B@0004D0
00<100002`020A800`4C00D10P000`400@0200030@0000@03`560000A000
0`40000;00030@0000l00`4C00<11`0<0@D000<100000`0=0Cd000140003
0@0000X000<100003@030A@00P4300P100<00@0010020@P000<100000P00
0`40000600<100<00@40104g0000@`000`40000900813P020AD01`470081
20000`40000600050@0000402`020C`0001200030@0000T000<100003002
0AD0104=00030@0000X11P001040004=0081>P00048000<1000020000`40
000<00030@0001800`4?00D12@0<0@h00P4h0000@@000`40000800030@00
00/00P4B00<100<00@002`040@8000@100412@020@@000D1000100040@`0
0P4f0000@@000`40000700030@0000/000<100003`030@@000<100001P04
0@H000D100400@0:00030@00008000<100401@020@`00P4d0000@@000`40
000700030@0000X000<100003P020@H000<1000010030@X000<100400P03
0@P000@100000P4800<12`000`40000a0000@@000`40000600030@0000X0
00<100003@020@L000<1000010000`40000;01l10P020@X000<10000<000
040000<100001`000`40000900030@0000`00P4900030@0000<000<10000
1P070@03004100h10P000`40000800H12@000`40000_0000@0000`400006
00030@0000T000<100002`020@/000@100000P4500@100<00@401P480081
10050@l00P4800030@0002h0001000030@0000H000<1000020000`40000;
00030@0000/000@100010`040@800`4600812P000`40000200<100<00@40
0`4<00030@0000D000<10000;P00040000<100001@000`40000800030@00
00X00P4>008100<00@400P4300<12@030@X000D1004100020@H00`4:0081
1P000`40000]0000@0000`40000500030@0000L000<100002P000`40000>
00<11P000`40000:00030@0000<11`020@<000<1000020020@X000<10000
10000`40000/0000@0000`40000400030@0000L000<100002@020@l00P42
008110000`40000;00030@0000<000<100000P020@8000@1004130000`40
000800030@0000<000<10000;000040000<1000010000`40000600030@00
00T000<100003@020@D00P4200030@0000/040401001004=008120000`40
000400030@0002/0001000030@0000@000<100001P000`40000800030@00
00d000<100001@000`400@020@X00`400`010@0H0@P000<100001P000`40
000300030@0002/0001100030@0000<000<100001P000`40000700030@00
00`00P4900<100<00@400`4200/11`030@8000<100000`020@8010450081
1`000`40000200030@0002/0001100030@0000@000<1000010000`400008
00030@0000X00P4<00<110070@@00P4700<10`000`40000500<12P000`40
000400030@00008000<10000:`00048000<100000`000`40000400030@00
00L000<100002P000`40000<00030@00008100@00@412@030@<00`430004
0@010@X00P4900030@0000@000D100000@0]0000@P000`40000300030@00
00@000<100001P000`400009008140000`400@030@/000<100000`460081
00<00@002`020@P000<100000`001@40000102d0001300030@00008000<1
000010000`40000600030@0000P000<100003`030@04004001/13P000`40
000500030@0000<000@10001;P0004<000<100000`000`40000300030@00
00H000<100001`000`40000=00<10`020@L00P4400030@0000@00`440003
0@0100<12`000`40000500030@00008000@10001;P0004@000<100000P00
0`40000300030@0000D000<100001`000`40000;00<11P0010400@430081
1P000`40000300@10`020@D00`4900030@0000@000<100000P000`400@0_
0000A@000`40000200030@00008000<100001@000`40000600030@0000X0
0P4900040@0000@11`0E0@800P4800030@0000<000D100000@0200030@00
02d0001500030@00008000<100000`000`40000400030@0000D000<10000
2P000`40000:00040@000@<02P47008100<00@001P030@03004000L000<1
00000`001P4000400C00001600030@00008000<100000P000`4000040003
0@0000D000<100002@000`40000<00810P040@L020401001004<00811`00
0`40000200030@000081<@0004L00P4300030@00008000<100000`000`40
000500030@0000P000<100003P030@H04@4>00030@0000@000<100000P00
1@400@010340001900040@000@@000<100000`000`40000400030@0000P0
00<1000030040@80304200810`030@03004100@12@000`40000300050@00
00400P020C80001:008100<00@000`000`40000200030@0000@000<10000
1`000`40000:00<10`000`40000200030@0000D000<100000`000`400@02
00030@0000D00P4800030@00008000H100000@020C<0001<00030@0100@0
00<100000P000`40000300030@0000H000<100002@020@L00P400`010007
00030@0000<00`4200030@0000L00P4700050@0000400P0010400@4d0000
C@040@8000<100000P000`40000300030@0000H000<1000020000`400008
00@11`000`400@030@800`4<00030@0000@000D100000@020081=P0004l0
00<100400P000`40000200030@00008000<100001@000`40000800030@00
00T000@100005`4700811@001P4000010081=`0005000`4200810P000`40
000200030@0000D000<100001`000`40000;00030@0000<01`4400L10P02
0@L000<100000P00104000030CP0001B00<10P001040004400030@0000@0
00<100001P000`40000<008100@00@411P030@030040008000@100001047
00030@00008000<100000P4j0000E0030@03004000810`000`4000040003
0@0000D000<1000030060@H01P4200030@0000H000<1000010000`400002
00@1>`0002`000<100009`050@030041008000<100000`000`4000050003
0@0000T00`4300030@0000H100<00@000P040@T000<1000010000`400@03
0Cd0000Z0081;0050@050040004010000`40000400030@0000T000<10000
10000`40000600030@0000<00P4;00030@0000800`400`010@0n0000:002
0C401P400`01000200030@0000@000<1000020000`40000600811@0<0@P0
2@5000009P040C<01`4300030@0000<000<100001`000`40000800`10P00
1@40000100D010400`010@030D40000T008110060C002@4500030@0000D0
00<100002P020@804`4200L1@P0002<000<100002P050Bl02`4700030@00
00T01@4400810P070@03004100P1A00002400P4B00H1:`0A0@T00P400`01
0@0301L1AP0001l00P4J00D1:@0:0@8000<10040604400<10P050DL0000M
00818@060BH0:0400`010@050DT0000L00030@0002L0204Q02`1BP0001/0
00<10000<0080A/0904010010@5<00006@020C/01@4I00D100<00@405042
00@100<00@00C00001P01`4l00P15@090@H03P400`01001=00005`000`40
000500d1=`070A401@400`010@0>0@0300410081C`0001H000<100004`0J
0B@01@4>01D100<00@00D00001D000<10000;P0;0Ah01`4:00d10`030E80
000C0081?00F0@l01`4500l1E000018000<10000DP0;0@/0104400@10P05
0ED0000A00030@0005h05P4010010@5I000040000`40001L01d1F@000100
00<100007P0n0@X04@43C003ID`005D0000?0281?00<0@<03P42C006IDaU
C6E<D`0000h000<10000D00<0@T02`400`010@050@I<00=UC6D00da@0000
3P000`40001300d13P0?0@03004100L1011<0Da<IDaUC6E<IDaUC6E<C@00
00d000<10000=`0=0AD01P400`010@040@800`400`010@050@06N`410D`1
2T`01FE<IDaU009<B`0000`000<10000;P0:0A`01P4300@11@030@050041
0@000P4200D100=<0D`00d`04FE<IDaUC6E<IDaUC6E<IDaU04P0000<0003
0@0002P01P4P00H11@040@H00`4010010@4200810P060@03C05<00e<00MU
C6E<IDaU00A<A@0000/000<100007`0:0Al01`4700@11`030@0400410@<0
0P4200L100=<0D`01D`05VE<IDaUC6E<IDaUC6E<IDaUC6E<IDa300002`00
0`40000A00h18`060@X0104800<10P020@@00P42008100<00@400`400d`1
C00CC009IDaUC6E<IDaU00=<@00000X000<10000100>0BX01`4<00@12@03
0@800`4300<10P020@801@400d`1C007C00MIDaUC6E<IDaUC6E<IDaUC6E<
IDaUC6E<IDaUC6D0?00000X01`4b00H13P050@T01043008110020@@000<1
00001P400d`1C00GC00;IDaUC6E<IDaUC6D01T`i00002P000`40000_00L1
40040@X01045008110020@@00P4200H100A<0D`124`08FE<IDaUC6E<IDaU
C6E<IDaUC6E<IDaUC6E<IDaUC6E<I@02C3H0000900030@0002T01`4C00@1
2P040@H00`44008110020@801`4014`1C04JC00?IDaUC6E<IDaUC6E<IDaU
00I<<`0000T000<100008P070AD01@4:00@11`030@D00P4500040@0000D1
00I<0D`1C04:C00>IDaUC6E<IDaUC6E<ID`30@0GC6E<IDaUC6E<IDaUC6E<
IDaUC6E<ID`0<@0000T000<1000070060AP0104<00<12@020@H00P450081
0P060@06C05<0D`12d`>0@03LGMa018100=UC4`01D`^000020000`40000F
00L16P040@d00`4900<11P020@D00P4300H100M<0D`1C05<00/100f9Q8V4
RHP>R:27T7N@009g01AbMg9gLWMbMg9gFWMJMeYOFUmJG`H100=<ID`00T`[
000020000`40000?00L16`060@h00`4900<11`020@D00P430003G@4100@1
00=<0D`01P44S`0_RTe=K6^4JhA[RF^9PhR3X6YgLGMaMg5gLGMaMeUgFGMI
MeUgFEYIFUUJFEY0FT001P42C2P0000800030@0000P01`4L00H140040@T0
0`4800811@020@@01`4040010@40S`2?08nWSjN?0Dd2K00]Q6b9Q8V4RH<>
R0j8X7N@Mi1bMg9gLWMbMg9gLWMJMeYgFWMJMeYOFUm1Gd5O00A110400d`0
000S00002000104000070Ad01P4B00@12P030@T00P450081100:0@0708nY
SjJ?YP04S`0hRXlaCTe/JhA[Q6^9JhV3RH>8PYmaMg5gLGMaMg5gLGMIMeUg
FGMIMeUJFEYIFUUJFEY0FT1J@442@003>04100<18@0000P0104P00@15004
0@/00`4900<11@020@D000=k0@400`404P2Y0:T0S`2?08l0SjN?Yhn@0@9=
0V`0<hA/RHB9Q8V3RHP>R:27PWN@Mi1bMg9gLWMbMg9gLWMbMeYgFWMJMeYg
FUmJGd5O@Em1G`04@@03@44h00<17P0000T000<1000070040A@0104<00<1
2P020@H00P4600@100d0U02?08l0SjV?ZHnV00J?01B:0C5>CFa[Q6^4JhA[
RH>9PhR3X0:202eaMg5gLGMaMg5gLGMIMeUgFGMIMeUgFEYIFUUJFEYIFT1J
@5Y0@D11@44h@3P00`4K00002@000`40000G00D15@030@h00P4;00811P02
0@H00`40602D0:T0Z@2Y08l0S`2?08nWSjN?Yhn@0@9=0V`0=hA/RFb9Q8V4
RH<>R0j8X8:@Mi1gT79gLWMbMg9gLWMbMg9gFWMJMeYgFWMJMeYOFUmJGd5O
@El01T400d1100020AT0000900030@0001<0104G00<13P030@/00P460081
1P005@5k0@40U02D08l0S`2?ZHnYSjJ?YP06S`14RS5=K6I/Jfa[Q6^4JhV3
RH>9Pj23X6YgLGMaMg5gLGMaMg5gLGMIMeUgFGMIMeUJFEYIFUUJFEYIFUUJ
@5Y0@D11@442@003>00101P0000900030@0000l0104H00<13`020@`00P46
00811`030@0MU02D0:T0Z@2Y08l0S`2?08l0SjN?Yhn@S`4aCTd00V`05HA/
RFb9Q8V4RH<>R0j8X8ROPY1gT002M`0TLWMbMg9gLWMbMg9gLWMJMeYgFWMJ
MeYgFWMJGeYOFUm1Gd5O1T4014110@4F00002@000`40000:00D160040A00
0P4;00<11P020@L00P4057^DU02D09@0S`2?08l0SjV?YXnV1Xl00hZ?0@02
C@18K6I/Jfa[Q6^4JhU[RH>9PhR3X8:OLGMaMg5gLGMaMg5gLGMaMeUgFGMI
MeUgFGMIFUUJFEYIFUUJFEYIFT1J@450@D11@44h0P4D00002P000`400004
00D16@040A400`4;00811`020@P001l1U7/0U02D0:T0Z@2Y08l0S`2?08l0
SjN?YhnWSi2?008a01E>CFa/Q6b9K8V4RHB9PhV83XP>R:000X8017N@Mi02
M`0VLWMbMg9gLWMbMg9gLWMbMeYgFWMJMeYgFWMJMeYOFUmJGd5O@El8@@03
0@000140000:00030@0000@16P040A800`4;00<120000`40000700030IAk
00:D0140U02D08l0S`2?08nYSjV?YP08S`03RP4a009=04]/IVa[K6^4JhA[
RF^9PhV3R8>PPj22Mg5gLGMaMg5gLGMaMg5gLGMaMeUgFGMIMeUgFGMIFUUJ
FEYIFUUJFEYIFT1J@5Y0@D11@4400P4A00002P030A/00`4D008130020@T0
0P4800810Y@07P2D09@0Z@2Y0:T0S`2?08l0S`2?YhnWSjN?Yhn@0@9=01e/
CFa/Q6b9K8V4RHB9PhV33XP>R:28X8:@Mi1gT002M`0ZLWMbMg9gLWMbMg9g
LWMbMeYgFWMJMeYgFWMJMeYgFUmJGeYO@Em1Gd5O1D400`40000>00002`00
0`40000G00<150030@/00`4:00030@0000L001L1NiBD09@0U02D08l0S`2?
08nYSjV?YP0:S`1DRTdaCTe/IVa[K6^4JhA[RF^9PhV3RH>8Pj22X75gLGMa
Mg5gLGMaMg5gLGMaMg5gFGMIMeUgFGMIMeUgFEYIFUUJFEYIFUUJFEY0FT1J
@5Y0@D013`0000`000<100004P040A@00`4<00812`020@T002@1N`2D09@0
U02Y0:T0Z@2?08l0S`2?08nWSjN?YhnWSi2?T342C@1AK4e/K8A/RFb9Q8V4
RHB9PhV83XP>R:27WgN@Mi1gT79gLWMbMg9gLWMbMg9gLWMbMg9gFWMJMeYg
FWMJMeYgFWMJGeYOFUm1Gd5O@Em1Gd4100h0000<00030@0000l00`4E00<1
3@020@`000<1000020006@6DU9@0U02D09@0S`2?08l0SjV?ZHnVSjH028l0
0hZ?0@02C@1CCTe/IVa[K6^4JhA[RF^9PhV3RH>8Pj23X89gLGMaMg5gLGMa
Mg5gLGMaMg5gLGMIMeUgFGMIMeUgFGMIMeUJFEYIFUUJFEYIFUUJ@5Y0FT1J
@0403@0000d000<100002`030AD00`4>008130020@/002L109@0U02Y0:T0
Z@2Y08l0S`2?08l0S`2?YhnWSjN?Yhn@S`4aCTd016`0CXA/RFb9Q8V4RHB9
PhV83XP>R:27X8:@Mi1gT7N@LWMbMg9gLWMbMg9gLWMbMg9gLWMJMeYgFWMJ
MeYgFWMJMeYgFUmJGeYO@Em1Gd5O0@d0000=00030@0000P00`4E00<13`02
0@d000<1000020030@:D01D0U02D09@0S`2?08l0SjV?ZHnVSjH02Xl0FHZ?
0Di=K4e/IVa[K6^4JhA[RF^9PhV3RH>9PhR3X8:PPWMaMg5gLGMaMg5gLGMa
Mg5gLGMaMeUgFGMIMeUgFGMIMeUgFEYIFUUJFEYIFUUJFEYIFT1J@5X100`0
000>00030@0000@00`4E00<13`030@d00P4:000W0@0109@0U02Y0:T0Z@2Y
08l0S`2?08l0S`2?YhnWSjN?YhnWSi01009=00=>CF`00f`0ChA/RFb9Q8V4
RHB9PhV33XP>R0j8X8NOPY1gT7N@Mi1bMg9gLWMbMg9gLWMbMg9gLWMbMg9g
FWMJMeYgFWMJMeYgFWMJMeYOFUmJGeYO@@40300000l000<100000`4E00<1
40020@h00P4:00810P005`6D09@0U02D08l0S`2?08nYSjV?ZHnV00Z?00>:
ShX00S40Edi=K4e/IVa[K6^4JhA[Q6^9JhV3RH>9PhR3R8>PPYmaMg5gLGMa
Mg5gLGMaMg5gLGMaMg5gLGMIMeUgFGMIMeUgFGMIFUUJFEYIFUUJFEYIFUUJ
FEX00@0;000040020AH00P4A00813P020@/000<100000P009@40U02Y0:T0
Z@2Y08l0S`2?08l0S`2?08nWSjN?YhnWSi2?0C400Td00di=K003K00OQ6b9
K8V4RHB9Q8V3RH>9R0j83XRPR:22WgN@Mi1gT002M`0_LWMbMg9gLWMbMg9g
LWMbMg9gLWMbMg9gFWMJMeYgFWMJMeYgFWMJMeYOFUmJ00402`00014000<1
00004@030A400P4>00812`020@D001L1U02D09@0S`2?08l0SjV?ZHnYSjJ?
YP0:S`03RXl1008a05M>CFaVK6I/Jfa[Q6^4JhA[RF^9PhV3RH>9PhR3X8>P
PWMaMg5gLGMaMg5gLGMaMg5gLGMaMg5gLGMIMeUgFGMIMeUgFGMIMeUJFEYI
FUUJFEYIFUUJ00402`00018000<100003@030A800P4>00812`020@L002T1
0:T0Z@2Y0:T0S`2?08l0S`2?08l0SjN?YhnWSjN?Yhn@S`4aCTe/C@04K00Q
Q6b9K8V4RHB9Q8V4RH>9P`j83XP>R:27X8:@Mi1gT7N@009g02abMg9gLWMb
Mg9gLWMbMg9gLWMbMg9gLWMJMeYgFWMJMeYgFWMJMeYgFWMJ0@`0000C0003
0@0000T00`4C00813P020@`000<100001`005@6D09@0S`2?08l0S`2?ZHnY
SjJ?YP0<S`03RXl1009=05I>CFaVK6]/Jfa[Q6^4JhA[RF^9PhV3RH>9PhR3
R8>PPYlcMg5gLGMaMg5gLGMaMg5gLGMaMg5gLGMaMeUgFGMIMeUgFGMIMeUg
FGMIFUUJFEYIFUUJ0@`0000D00030@0000D00`4D00813P020@`00P4:000S
0@2Y0:T0Z@2?08l0S`2?08l0S`2?YhnWSjN?YhnWSi2?T0400S4014i=K4d2
K00UQ6b4K8U/RHB9Q8V4RHB9PhV33XP>R0j8X8RPQh9gT7N@Mi1gT002M`0Z
LWMbMg9gLWMbMg9gLWMbMg9gLWMbMg9gLWMJMeYgFWMJMeYgFWMJMeX13000
01D00P4200<15@020@h00P4=00030@0000X00P404`2?08l0S`2?08nYSjV?
ZHnVSjH02Xl00hZ?RP020@9=05I>CFaVK6]/Jfa[Q6^4JhA[RF^9JhV3RH>9
PhV3R8>PPj22<g5gLGMaMg5gLGMaMg5gLGMaMg5gLGMaMg5gFGMIMeUgFGMI
MeUgFGMIMeUgFEYIFUUJ0@`0000G00815P020@h00P4=00813000:P400@40
Z@2?08l0S`2?08l0S`2?08nWSjN?YhnWSjN?T8n@0DdaCTe/C@9/00R4K8A/
RFb9Q18103JPQj22T7N@Mi1gT7N@LWMbMg9gLWMbMg9gLWMbMg9gLWMbMg9g
LWMbMeYgFWMJMeYgFWMJM`4=000060020A<00P4?00030@0000`000<10000
2`000`400002000@0@2?08l0SjV?ZHnYSjJ?YPb?00>:S`400S402Di=K4e/
IVa[K0060@04RJAaRPQa00IDLEAIE5T30@0cX6YgLGMaMg5gLGMaMg5gLGMa
Mg5gLGMaMg5gLGMIMeUgFGMIMeUgFGMIMeUgFGMIFUT100d0000J00030@00
00d00`4?00813P000`40000;00030@0000@001l108l0S`2?08l0S`2?08nW
SjN?YhnWSjN?Yhn@S`4a009=00E>CFa=K0030@06RQF:5HY/0ZD01hmaSg6:
LHX01W4015AaE5T2E0<102n@Mi1gT7N@Mi1bMg9gLWMbMg9gLWMbMg9gLWMb
Mg9gLWMbMg9gLWMJMeYgFWMJ0@0>00006`020@/00P4@00813P020@d000<1
00001@003@6?08nYSjV?ZHnVSjH03Xl028Z?0DdaCTe/0`403hZ9RQF:5HY/
KHVULHYaRP06L@06E75DLEAI0U@2>00`=041Mg5gLGMaMg5gLGMaMg5gLGMa
Mg5gLGMaMg5gLGMIMeUgFGMIMeUgFGMIMeT13`0001d000<100001@030A00
0P4?00030@0000`000<100001`020@0J08l0S`2?08l0S`2?YhnWSjN?YhnW
Si2?T8l2<@9=01NV0JJ:ShZ?RHXERQF:K:D>Sg6?LHYaRP08L@04E75DF@9D
02ld0GN@Mi1gT7N@Mi1bMg9gLWMbMg9gLWMbMg9gLWMbMg9gLWMbMg9gLWMJ
MeYg0@0?00007P020@<00P4A008140000`40000;00812`030@08SjV?YXnV
SjH<S`03RXn:008101M=<@41YXV?RHZ9RQF:5HY/KHVUX8YaRP08L@0gE75D
FEAI>5@d>3<1LGMaMg5gLGMaMg5gLGMaMg5gLGMaMg5gLGMaMg5gFGMIMeUg
FGMIMeUg0@0@000080030A8000<100003P020@d000<100002P0010400002
0@0G08l0S`2?YhnWSjN?YhnWSjN?T8n@0C400P406:FVSZJ:ShZ?RHXERQF:
K:F9YG6?LHYaRPQa019DLEAIE5Th0GN@Mi1gT7N@Mi02M`0MLWMbMg9gLWMb
Mg9gLWMbMg9gLWMbMg9gLWMbMg800P4A00008P020@l00P4?00813P000`40
000:00030@0000<000FV0@41YP0>S`04RXn:<@8101J>YXVVRHn9RXV:5HXE
RVa]RJFPRW6:27401UAaE75DF@9D02Xh0@5gLGMaMg5gLGMaMg5gLGMaMg5g
LGMaMg5gLGMaMg5gLGMIMeUgFGL20A<0000T00812`020A0000<100003@00
0`40000:00030@0000P00P403hnWSjN?YhnWSjN?T8n@S`030@0LYJJ>YXjV
RXn:ShV:5HXERVbVRJEaSg6?LHYaRPQa019DLE@1Mi1gT7N@Mi1gT7N@Mi02
M`0JLWMbMg9gLWMbMg9gLWMbMg9gLWMbMg9gLP4D00009P020@L00P4@0081
3P020@`000<100002@00105f0@49S`0NRXn:S`4ZYJJ>YXVVRHn9RXV:5HXE
RVa]RJFPRW6:2W4015AaE5T30@0VMg5gLGMaMg5gLGMaMg5gLGMaMg5gLGMa
Mg5gLGMaMg5gLGMaMeT30AD0000X00810`020A4000<100003@000`40000;
00030@0000X000@1T92@1040:8nWSjN?T8n@S`6UZJFVSZJ:YXZ?RXn9RQF:
5HY/YXVUY8maSg6:LHX7L@<1019gT7N@Mi1gT7N@Mi1gT7N@Mi02M`0BLWMb
Mg9gLWMbMg9gLWMbMg9g0P4H0000:P030A8000<100003@000`40000;0003
0@0000X000T1T7J@MY1fT7H01@407XZ?RP6UZJFVSZJ9YXV?RHZ9RQF:5HY/
LE>UX:EaRPQa10409g5gLGMaMg5gLGMaMg5gLGMaMg5gLGMaMg5gLGMaMg5g
LGMaMg5gL@020AX0000]00<13P000`40000<00813@000`40000:00030I2@
00b@10405ZVUZJFVSZJ:YXZ?RXn9RQF:5HY/LHT2Y@03Sg6?00L102V@Mi1g
T7N@Mi1gT7N@Mi1gT7N@Mi1gT7N@Mi1bMg9gLWMbMg9gLWMbM`020A`0000`
00<12@020@h000<100003@000`40000:000[0GJ@MY1fT7J@MY1fT7J@MY1f
0JFYYJJ>YXVVRHn9RXV:5HXERVaaDjF9Y@030@0^T76@LI1aT76@LI1aMg5g
LGMaMg5gLGMaMg5gLGMaMg5gLGMaMg5gLGMaMg5gL@817P0003<00`450003
0@0000d000<100003@000`40000:00030I2@012@01L1ZJFYYJJ>YXZVRXn:
ShV:5HXERVaaR@02Y@0_T7N@Mi1gT7N@Mi1gT7N@Mi1gT7N@Mi1gT7N@Mi1g
T7N@Mi1gT7N@LWMbMg9gLWL00P4P0000=P030@03004000h000<100003@00
0`40000;001I0I1fT7J@MY1fT7J@MY1fT7J@MP6UYZFVRJJ9YXV?RHZ9RQF:
5HY/LE>URJEaT76@LI1aT76@LI1aT76@LGMaMg5gLGMaMg5gLGMaMg5gLGMa
Mg5gLGMaM`000P4R0000>@040@`000<100003@000`40000;00030I2@016@
01L1ZJFVYJJ:YXZVRXn:ShV:5HXERVaaR@02Y@0YT7N@Mi1gT7N@Mi1gT7N@
Mi1gT7N@Mi1gT7N@Mi1gT7N@Mi1gT7N@Mi00104T0000?@030@P000<10000
3@000`40000;001CMP5fT7J@MY1fT7J@MY1fT7J@MY1fT06VSZJ9YXV?RHn9
RXV:5HXERVaaDjF9YHN@LI1aT76@LI1aT76@LI1aMg5gLGMaMg5gLGMaMg5g
LGMaMg40104X0000@0040@<000<100003@000`40000<00030I2@01>@0P40
5:JUYXZVRZJ:ShZ?RHXERQF:K7690ZD08jAgT7N@Mi1gT7N@Mi1gT7N@Mi1g
T7N@Mi1gT7N@Mi1gT7L00081;00004@01@4>00030@0000/002`1MY1fT7J@
MY1fT7J@MY1fT7J@MY1fT7H1SZJ9YXV?RHZ9RXV:5HXERVaaD`:9022UX91a
T76@LI1aT76@LI1aT76@LGMaMg5gLGMaMg5g00@1;P0004T0104900030@00
00/000>@0I005i00506>YXZVRZJ:ShV?RHXERQF:K7690ZD06:AgT7N@Mi1g
T7N@Mi1gT7N@Mi1gT7N@M`L1<P0004d01P4200030@0000`001/1T7J@MY1f
T7J@MY1fT7J@MY1fT7J@MY1fT7H00P404:J9ShV:RHZ9RQF:5HY/LE<2R@0D
YJ2@LI1aT76@LI1aT76@LI1aT7450CT0001C00L12@000`6@T00JT081012V
RZJ:ShV?RHXERQF:K75/0jD02gN@Mi1gT7N@Mi1g00L1?P0005X02P40=gJ@
MY1fT7J@MY1fT7J@MY1fT7J@MY1fT7J@MY1f0HV?RHZ9RXV:5HXERVaaDff9
YJ2@LI1aT0001@550000HP0@0A2@0P404ZJ:ShV?RHXERQF:K75/YPjU<@D1
BP00074000>@0@404P4048V:RHXERQF:K75CKHVUX35?0000QP020@0>ShV:
5HXERVb:K:J9YHM?0000R0020@0<5HXERVaaK6f9YJ2SC`0008T00P402aF:
5HY/RVbVRJFT04l0002;008100F:K75/K@03R@03Y00004d0002=00070HY/
RVbVR@02YDl0002>008100=/KHT00XT00jD0001=0000T0020@05YXVUYC40
CP00098000D1RHVU0@1>0000T`0018VU3ZA>0000T`02R@03YHL004d0002C
0004RJD>Y4h0002C00:900>UX000C@0009<000B9Y@jTCP0009<00XT00jFP
0@1=0000T`001HVV3ZD104d0002C00:900>UX:@0C@0009<000F9YPjUY01=
0000T`02R@04YHVT0D`0002C0006RJH>YJ@1C00009@000F9YHVT0@1<0000
U0001JJ9YJ@104`0002D0005RJF9Y040C00009@000BVRJD1C@0009@000B9
YHT1C@0009@000BVRJD1C@0009@00hT00`40001;0000U0001:J9Y@5=0000
U003R@030@0004/0002D0004YXVU0Dd0002D00>900<10000B`0009D000>9
Y@40C@0009D00XT00`40001;0000U@000hT1001=0000U@000hT1001=0000
U@000hT1001=0000U@000hT1001=0000U@000hT1001=0000U@000hT1001=
0000U@000hT1001=0000U@000`40001=0000U@000`40001=0000U@000`40
001=0000i@000>D0003U0000i@000>D0003U0000i@000>D0003U0000i@00
0>D00000
\
\>"], "Graphics",
  Evaluatable->False,
  FormatType->StandardForm,
  ImageSize->{229.125, 221},
  ImageMargins->{{126, 0}, {0, 4}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Cover Second Edition", "Subsection"],

Cell["\<\
torus[ R_, r_, psi_, phi_, h_ ] :=
\t{ (R + r Cos[psi]) Cos[phi],
\t  (R + r Cos[psi]) Sin[phi],
\t  r Sin[psi],
\t  FaceForm[ ColorCircle[h], ColorCircle[h, 0.6] ]
\t}\
\>", "Input"],

Cell["\<\
segment[ {phi0_, phi1_, dphi_}, {psi0_, psi1_, dpsi_} ] :=
\tParametricPlot3D[
\t\tEvaluate[torus[1.2, Exp[-phi/(3Pi)], psi + phi/8, phi, psi-3Pi/4]],
\t\t{phi, phi0, phi1, dphi}, {psi, psi0, psi1, dpsi},
\t\tDisplayFunction -> Identity ]\
\>", "Input"],

Cell["\<\
Module[{glist, dphi = 2Pi/36, dpsi = 2Pi/32},
    glist = {segment[{-Pi/4,    0, dphi}, {Pi/2, 2Pi, dpsi}],
             segment[{  0,  3Pi/2, dphi}, {0, 2Pi, dpsi}],
             segment[{3Pi/2,  2Pi, dphi}, {1Pi/4, 7Pi/4, dpsi}],
             segment[{2Pi,  7Pi/2, dphi}, {0, 2Pi, 2dpsi}],
             segment[{7Pi/2,  4Pi, dphi}, {0, 6Pi/4, 2dpsi}],
             segment[{4Pi, 11Pi/2, dphi}, {0, 2Pi, 4dpsi}],
             segment[{11Pi/2, 6Pi, dphi}, {-Pi/4, 5Pi/4, 4dpsi}],
             segment[{6Pi, 17Pi/2, dphi/2}, {0, 2Pi, 4dpsi}]};
    Show[ glist, Boxed -> False, Lighting -> False, PlotRange -> \
All,DisplayFunction -> $DisplayFunction ] ];\
\>", "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Cover First Edition", "Subsection"],

Cell["\<\
t0 = 0.001; t1 = N[ Pi - t0 ];
dt = (t1 - t0)/36; dp = N[ Pi/20 ];\
\>", "Input"],

Cell["\<\
part[t0_, phi0_, phi1_] := Block[{theta, phi},
\tSphericalPlot3D[{Sin[theta] (2+Cos[phi/2]),
\t                 FaceForm[ColorCircle[phi/2, 1], ColorCircle[phi/2, 0.7]]},
\t                {theta, t0, t1, dt}, {phi, phi0, phi1, dp},
\t                DisplayFunction -> Identity] ]\
\>", "Input"],

Cell["\<\
Module[{glist},
    glist = {part[t0, 0, 3Pi/2],     part[Pi/2, 3Pi/2, 4Pi/2],
             part[t0, 4Pi/2, 7Pi/2], part[Pi/2, 7Pi/2, 8Pi/2]};
   Show[ glist, Boxed -> False, Lighting -> False,
         DisplayFunction -> $DisplayFunction ]
];\
\>", "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.1 for X",
ScreenRectangle->{{0, 1152}, {0, 864}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{555, 562},
WindowMargins->{{47, Automatic}, {91, Automatic}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->False,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 103, 3, 117, "Title",
  Evaluatable->False],
Cell[1845, 56, 195, 8, 93, "Subtitle",
  Evaluatable->False],
Cell[2043, 66, 66, 1, 53, "Subsubtitle"],

Cell[CellGroupData[{
Cell[2134, 71, 76, 2, 60, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2235, 77, 80, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[2318, 81, 194, 7, 32, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[2549, 93, 89, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[2641, 97, 67, 2, 32, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[2745, 104, 34, 0, 42, "Subsubsection"],
Cell[2782, 106, 246, 6, 86, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3065, 117, 80, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[3148, 121, 144, 5, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3329, 131, 81, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[3413, 135, 235, 6, 50, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[3685, 146, 84, 2, 42, "Subsubsection",
  Evaluatable->False],
Cell[3772, 150, 155, 4, 28, "Input",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[3964, 159, 149, 6, 42, "Subsubsection",
  Evaluatable->False],
Cell[4116, 167, 67, 2, 32, "Text",
  Evaluatable->False]
}, Open  ]],

Cell[CellGroupData[{
Cell[4220, 174, 30, 0, 42, "Subsubsection"],
Cell[4253, 176, 165, 4, 50, "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[4467, 186, 72, 2, 40, "Section",
  Evaluatable->False],
Cell[4542, 190, 75, 0, 70, "Text"],

Cell[CellGroupData[{
Cell[4642, 194, 118, 3, 70, "Subsection",
  Evaluatable->False,
  InitializationCell->True],
Cell[4763, 199, 117, 3, 70, "Text",
  Evaluatable->False,
  InitializationCell->True],
Cell[4883, 204, 177, 6, 70, "Input",
  InitializationCell->True],
Cell[5063, 212, 65, 1, 70, "Text",
  InitializationCell->True],
Cell[5131, 215, 243, 6, 70, "Input",
  InitializationCell->True],
Cell[5377, 223, 60, 1, 70, "Text",
  InitializationCell->True],
Cell[5440, 226, 164, 4, 70, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5653, 236, 79, 2, 40, "Section",
  Evaluatable->False],
Cell[5735, 240, 188, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[5948, 248, 61, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[6034, 252, 262, 4, 70, "Input"],
Cell[6299, 258, 33602, 555, 70, 33456, 550, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[39950, 819, 48, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[40023, 823, 476, 8, 70, "Input"],
Cell[40502, 833, 41167, 679, 70, 41020, 674, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[81718, 1518, 74, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[81817, 1522, 261, 4, 70, "Input"],
Cell[82081, 1528, 38369, 633, 70, 38226, 628, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[120499, 2167, 65, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[120589, 2171, 363, 6, 70, "Input"],
Cell[120955, 2179, 23583, 391, 70, 23432, 386, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[144587, 2576, 57, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[144669, 2580, 129, 3, 70, "Input"],
Cell[144801, 2585, 41647, 687, 70, 41500, 682, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[186497, 3278, 47, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[186569, 3282, 155, 3, 70, "Input"],
Cell[186727, 3287, 36297, 599, 70, 36152, 594, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[223073, 3892, 53, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[223151, 3896, 641, 11, 70, "Input"],
Cell[223795, 3909, 16604, 276, 70, 16453, 271, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[240448, 4191, 45, 0, 29, "Subsection"],
Cell[240496, 4193, 264, 7, 70, "Input"],

Cell[CellGroupData[{
Cell[240785, 4204, 215, 6, 70, "Input"],
Cell[241003, 4212, 4291, 75, 70, 4144, 70, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[245343, 4293, 67, 0, 29, "Subsection"],
Cell[245413, 4295, 64, 0, 70, "Input"],

Cell[CellGroupData[{
Cell[245502, 4299, 58, 0, 70, "Input"],
Cell[245563, 4301, 16661, 277, 70, 16514, 272, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[262273, 4584, 60, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[262358, 4588, 246, 4, 70, "Input"],
Cell[262607, 4594, 25173, 417, 70, 25026, 412, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[287829, 5017, 59, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[287913, 5021, 594, 14, 70, "Input"],
Cell[288510, 5037, 28837, 477, 70, 28690, 472, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[317396, 5520, 49, 0, 29, "Subsection"],
Cell[317448, 5522, 268, 5, 70, "Input"],
Cell[317719, 5529, 105, 3, 70, "Input"],

Cell[CellGroupData[{
Cell[317849, 5536, 40, 0, 70, "Input"],
Cell[317892, 5538, 31192, 516, 70, 31045, 511, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[349133, 6060, 45, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[349203, 6064, 54, 1, 70, "Input"],
Cell[349260, 6067, 22806, 378, 70, 22663, 373, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[372115, 6451, 57, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[372197, 6455, 377, 7, 70, "Input"],
Cell[372577, 6464, 39247, 648, 70, 39101, 643, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[411873, 7118, 50, 0, 29, "Subsection"],
Cell[411926, 7120, 67, 0, 70, "Input"],
Cell[411996, 7122, 93, 3, 70, "Input"],
Cell[412092, 7127, 346, 7, 70, "Input"],
Cell[412441, 7136, 1205, 31, 70, "Input"],
Cell[413649, 7169, 251, 8, 70, "Input"],
Cell[413903, 7179, 380, 8, 70, "Input"],

Cell[CellGroupData[{
Cell[414308, 7191, 52, 0, 70, "Input"],
Cell[414363, 7193, 72131, 1187, 70, 71984, 1182, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[486543, 8386, 27, 0, 29, "Subsection"],
Cell[486573, 8388, 120, 6, 70, "Input"],
Cell[486696, 8396, 50, 3, 70, "Input"],
Cell[486749, 8401, 91, 3, 70, "Input"],
Cell[486843, 8406, 104, 3, 70, "Input"],

Cell[CellGroupData[{
Cell[486972, 8413, 1017, 21, 70, "Input"],
Cell[487992, 8436, 18814, 313, 70, 18666, 308, "GraphicsData", "Bitmap", \
"Graphics",
  Evaluatable->False]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[506855, 8755, 42, 0, 29, "Subsection"],
Cell[506900, 8757, 193, 7, 70, "Input"],
Cell[507096, 8766, 263, 6, 70, "Input"],
Cell[507362, 8774, 679, 12, 70, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[508078, 8791, 41, 0, 29, "Subsection"],
Cell[508122, 8793, 91, 3, 70, "Input"],
Cell[508216, 8798, 306, 6, 70, "Input"],
Cell[508525, 8806, 268, 7, 70, "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

