
(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)

































































BeginPackage["ProgrammingInMathematica`ChaosGame`", "ProgrammingInMathematica`IFS`"]



ChaosGame::usage = "ChaosGame[-ifs-, n, opts..] iterates random maps applied to a point n times and plots the result."

Coloring::usage = "Coloring -> val is an option of ChaosGame. Possible values are None, Automatic, a list of color directives, or a function of two arguments so that val[i, n] is the color of the ith out of n objects."

PlotStyle::usage = PlotStyle::usage <> " PlotStyle is an option of ChaosGame that specifies the style of the points."



Options[ ChaosGame ] = {
	PlotStyle -> PointSize[0],
	Coloring -> None
};



ChaosGame::probs =
	"Probabilities `1` are not a list of nonnegative numbers of length `2`."







Begin["`Private`"]



Needs["Utilities`FilterOptions`"]





makePoints[ maps_, probs_, ntry_, colors0_ ] :=
  Module[{random, n = Length[maps], colors = colors0, next},
    With[{cumul = FoldList[Plus, 0.0, probs]},
         random := With[{rand = Random[]},
                        Position[cumul, r_ /; r > rand, {1}, 1][[1,1]] - 1] ];
    If[ colors === None || colors === False,
          NestList[ Unevaluated[maps[[random]]], Point[{0, 0}], ntry ]
        , (* else insert color directives *)
          If[ colors === Automatic, colors = Function[{i, k}, Hue[i/k]] ];
          If[ !ListQ[colors], colors = Table[colors[i, n], {i, n}] ];
          While[ Length[colors] < n, colors = Join[colors, colors] ]; (* cyclic *)
          With[{colors = colors},
               next[{_, p_}] := With[{i = random}, {colors[[i]], maps[[i]][p]}] ];
          NestList[ next, {GrayLevel[0], Point[{0, 0}]}, ntry ]
    ]
  ]





ChaosGame[ ifs[maps_List, ifsopts_], ntry_Integer?Positive, opts___?OptionQ ] :=
  Module[{pts, probs, ps},
    probs = Probabilities /. {opts} /. ifsopts;
    If[ probs === Automatic, probs = Table[1.0, {Length[maps]}] ];
    If[ Length[probs] != Length[maps] || !TrueQ[Plus@@probs > 0],
        Message[ChaosGame::probs, probs, Length[maps]]; Return[$Failed] ];
    probs = probs / Plus @@ probs; (* normalize, just in case *)
    ps = PlotStyle /. {opts} /. Options[ChaosGame];
    colorFunction = Coloring /. {opts} /. Options[ChaosGame];
    pts = makePoints[maps, probs, ntry, colorFunction];
    pts = Rest[pts]; (* drop first point *)
    Show[ Graphics[Join[Flatten[{ps}], pts]], FilterOptions[Graphics, opts],
          AspectRatio -> Automatic, PlotRange -> All ]
  ]



End[ ]







Protect[ ChaosGame, Coloring ]



EndPackage[ ]



