(**************** Content-type: application/mathematica ****************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10126,        418]*)
(*NotebookOutlinePosition[     11033,        449]*)
(*  CellTagsIndexPosition[     10989,        445]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Chaos Game Package", "Title",
  TextAlignment->Center],

Cell["by Roman E. Maeder", "Subsubtitle",
  TextAlignment->Center],

Cell["\<\
Definitions for the chaos game (randomly selected affine maps \
applied to a point).\
\>", "Text"],

Cell[CellGroupData[{

Cell["Reference", "Section"],

Cell[CellGroupData[{

Cell["Title", "Subsubsection"],

Cell["Chaos Game Package", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Author", "Subsubsection"],

Cell["Roman E. Maeder", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Summary", "Subsubsection"],

Cell["|An annotated package for the chaos game.", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Copyright", "Subsubsection"],

Cell["\[Copyright] Copyright 2000, Roman E. Maeder", "Text"],

Cell["\<\
Permission is granted to distribute this file for any purpose \
except for inclusion in commercial software or program collections. This \
copyright notice must remain intact..\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notebook Version", "Subsubsection"],

Cell["1.0", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version"
}], "Subsubsection"],

Cell["3.0", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["History", "Subsubsection"],

Cell[TextData[{
  "Version 1.0 for ",
  StyleBox["Programming in ",
    FontSlant->"Italic"],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", 3rd edition."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Keywords", "Subsubsection"],

Cell["chaos game, affine maps, IFS, iteration", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Source", "Subsubsection"],

Cell[TextData[{
  "Maeder, R. ",
  StyleBox["Programming in ",
    FontSlant->"Italic"],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", 3rd ed. Addison-Wesley, 1996."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Warnings", "Subsubsection"],

Cell[TextData[{
  "Note: all cells marked as \"InitializationCell\" will be written to the \
Auto-Save package. This package can then be read in programs that use it with\
\n",
  StyleBox["Needs[\"ProgrammingInMathematica`ChaosGame`\"]", "Input"],
  ".\nCells not intended to belong to the package should not have this \
property."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Discussion", "Subsubsection"],

Cell[TextData[{
  "See Section 12.2.3 of ",
  StyleBox["Programming in Mathematica",
    FontSlant->"Italic"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Requirements", "Subsubsection"],

Cell[TextData[StyleBox["ProgrammingInMathematica`IFS`", "Input"]], "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Interface", "Section",
  InitializationCell->True],

Cell["\<\
This part declares the publicly visible functions, options, and \
values.\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["Set up the package context, including public imports", "Subsection",
  InitializationCell->True],

Cell["\<\
BeginPackage[\"ProgrammingInMathematica`ChaosGame`\", \
\"ProgrammingInMathematica`IFS`\"]\
\>", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Usage messages for the exported functions and the context \
itself\
\>", "Subsection",
  InitializationCell->True],

Cell["\<\
ChaosGame::usage = \"ChaosGame[-ifs-, n, opts..] iterates random \
maps applied to a point n times and plots the result.\"\
\>", "Input",
  InitializationCell->True],

Cell["\<\
Coloring::usage = \"Coloring -> val is an option of ChaosGame. \
Possible values are None, Automatic, a list of color directives, or a \
function of two arguments so that val[i, n] is the color of the ith out of n \
objects.\"\
\>", "Input",
  InitializationCell->True],

Cell["\<\
PlotStyle::usage = PlotStyle::usage <> \" PlotStyle is an option of \
ChaosGame that specifies the style of the points.\"\
\>", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Options for the exported objects", "Subsection",
  InitializationCell->True],

Cell["\<\
Options[ ChaosGame ] = {
\tPlotStyle -> PointSize[0],
\tColoring -> None
};\
\>", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Error messages for the exported objects", "Subsection",
  InitializationCell->True],

Cell["\<\
ChaosGame::probs =
\t\"Probabilities `1` are not a list of nonnegative numbers of length \
`2`.\"\
\>", "Input",
  PageWidth->Infinity,
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Implementation", "Section",
  InitializationCell->True],

Cell["\<\
This part contains the actual definitions and any auxiliary \
functions that should not be visible outside.\
\>", "Text"],

Cell[CellGroupData[{

Cell["Begin the private context (implementation part)", "Subsection",
  InitializationCell->True],

Cell["Begin[\"`Private`\"]", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Read in any hidden imports", "Subsection",
  InitializationCell->True],

Cell["Needs[\"Utilities`FilterOptions`\"]", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Definition of auxiliary functions and local (static) \
variables\
\>", "Subsection",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[{
  "makePoints",
  StyleBox["[]", "Input"]
}], "Subsubsection",
  InitializationCell->True],

Cell["\<\
makePoints[ maps_, probs_, ntry_, colors0_ ] :=
  Module[{random, n = Length[maps], colors = colors0, next},
    With[{cumul = FoldList[Plus, 0.0, probs]},
         random := With[{rand = Random[]},
                        Position[cumul, r_ /; r > rand, {1}, 1][[1,1]] - 1] \
];
    If[ colors === None || colors === False,
          NestList[ Unevaluated[maps[[random]]], Point[{0, 0}], ntry ]
        , (* else insert color directives *)
          If[ colors === Automatic, colors = Function[{i, k}, Hue[i/k]] ];
          If[ !ListQ[colors], colors = Table[colors[i, n], {i, n}] ];
          While[ Length[colors] < n, colors = Join[colors, colors] ]; (* \
cyclic *)
          With[{colors = colors},
               next[{_, p_}] := With[{i = random}, {colors[[i]], \
maps[[i]][p]}] ];
          NestList[ next, {GrayLevel[0], Point[{0, 0}]}, ntry ]
    ]
  ]\
\>", "Input",
  PageWidth->Infinity,
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Definition of the exported functions", "Subsection",
  InitializationCell->True],

Cell[CellGroupData[{

Cell[TextData[{
  "ChaosGame",
  StyleBox["[]", "Input"]
}], "Subsubsection",
  InitializationCell->True],

Cell["\<\
ChaosGame[ ifs[maps_List, ifsopts_], ntry_Integer?Positive, \
opts___?OptionQ ] :=
  Module[{pts, probs, ps},
    probs = Probabilities /. {opts} /. ifsopts;
    If[ probs === Automatic, probs = Table[1.0, {Length[maps]}] ];
    If[ Length[probs] != Length[maps] || !TrueQ[Plus@@probs > 0],
        Message[ChaosGame::probs, probs, Length[maps]]; Return[$Failed] ];
    probs = probs / Plus @@ probs; (* normalize, just in case *)
    ps = PlotStyle /. {opts} /. Options[ChaosGame];
    colorFunction = Coloring /. {opts} /. Options[ChaosGame];
    pts = makePoints[maps, probs, ntry, colorFunction];
    pts = Rest[pts]; (* drop first point *)
    Show[ Graphics[Join[Flatten[{ps}], pts]], FilterOptions[Graphics, opts],
          AspectRatio -> Automatic, PlotRange -> All ]
  ]\
\>", "Input",
  PageWidth->Infinity,
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End the private context", "Subsection",
  InitializationCell->True],

Cell["End[ ]", "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Epilog", "Section",
  InitializationCell->True],

Cell["This section protects exported symbols and ends the package.", "Text"],

Cell[CellGroupData[{

Cell["Protect exported symbol", "Subsection",
  InitializationCell->True],

Cell["Protect[ ChaosGame, Coloring ]", "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["End the package context", "Subsection",
  InitializationCell->True],

Cell["EndPackage[ ]", "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Examples, Tests", "Section"],

Cell[TextData[StyleBox["Examples, tests for the use of the package can go \
here.",
  FontSlant->"Italic"]], "Text"]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.1 for X",
ScreenRectangle->{{0, 1152}, {0, 864}},
AutoGeneratedPackage->Automatic,
InitializationCellEvaluation->False,
CellGrouping->Automatic,
WindowSize->{565, 600},
WindowMargins->{{155, Automatic}, {Automatic, 77}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 60, 1, 117, "Title"],
Cell[1802, 54, 66, 1, 53, "Subsubtitle"],
Cell[1871, 57, 108, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[2004, 64, 28, 0, 60, "Section"],

Cell[CellGroupData[{
Cell[2057, 68, 30, 0, 42, "Subsubsection"],
Cell[2090, 70, 34, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2161, 75, 31, 0, 42, "Subsubsection"],
Cell[2195, 77, 31, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2263, 82, 32, 0, 42, "Subsubsection"],
Cell[2298, 84, 57, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2392, 89, 34, 0, 42, "Subsubsection"],
Cell[2429, 91, 60, 0, 32, "Text"],
Cell[2492, 93, 200, 4, 50, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2729, 102, 41, 0, 42, "Subsubsection"],
Cell[2773, 104, 19, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2829, 109, 101, 4, 42, "Subsubsection"],
Cell[2933, 115, 19, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2989, 120, 32, 0, 42, "Subsubsection"],
Cell[3024, 122, 176, 7, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3237, 134, 33, 0, 42, "Subsubsection"],
Cell[3273, 136, 55, 0, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3365, 141, 31, 0, 42, "Subsubsection"],
Cell[3399, 143, 188, 7, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3624, 155, 33, 0, 42, "Subsubsection"],
Cell[3660, 157, 343, 7, 86, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4040, 169, 35, 0, 42, "Subsubsection"],
Cell[4078, 171, 121, 4, 32, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4236, 180, 37, 0, 42, "Subsubsection"],
Cell[4276, 182, 74, 0, 31, "Text"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[4399, 188, 56, 1, 40, "Section",
  InitializationCell->True],
Cell[4458, 191, 125, 4, 70, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4608, 199, 102, 1, 70, "Subsection",
  InitializationCell->True],
Cell[4713, 202, 143, 4, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[4893, 211, 124, 4, 70, "Subsection",
  InitializationCell->True],
Cell[5020, 217, 175, 4, 70, "Input",
  InitializationCell->True],
Cell[5198, 223, 279, 6, 70, "Input",
  InitializationCell->True],
Cell[5480, 231, 174, 4, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[5691, 240, 82, 1, 70, "Subsection",
  InitializationCell->True],
Cell[5776, 243, 128, 6, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[5941, 254, 89, 1, 70, "Subsection",
  InitializationCell->True],
Cell[6033, 257, 173, 6, 70, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[6255, 269, 61, 1, 40, "Section",
  InitializationCell->True],
Cell[6319, 272, 131, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[6475, 279, 97, 1, 70, "Subsection",
  InitializationCell->True],
Cell[6575, 282, 65, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[6677, 288, 76, 1, 70, "Subsection",
  InitializationCell->True],
Cell[6756, 291, 80, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[6873, 297, 122, 4, 70, "Subsection",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[7020, 305, 106, 4, 70, "Subsubsection",
  InitializationCell->True],
Cell[7129, 311, 939, 22, 70, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8117, 339, 86, 1, 70, "Subsection",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[8228, 344, 105, 4, 70, "Subsubsection",
  InitializationCell->True],
Cell[8336, 350, 856, 18, 70, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9241, 374, 73, 1, 70, "Subsection",
  InitializationCell->True],
Cell[9317, 377, 51, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[9417, 384, 53, 1, 40, "Section",
  InitializationCell->True],
Cell[9473, 387, 76, 0, 70, "Text"],

Cell[CellGroupData[{
Cell[9574, 391, 73, 1, 70, "Subsection",
  InitializationCell->True],
Cell[9650, 394, 75, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[9762, 400, 73, 1, 70, "Subsection",
  InitializationCell->True],
Cell[9838, 403, 58, 1, 70, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[9945, 410, 34, 0, 40, "Section"],
Cell[9982, 412, 116, 2, 70, "Text"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

