(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    140716,       2750]*)
(*NotebookOutlinePosition[    151967,       3050]*)
(*  CellTagsIndexPosition[    151604,       3035]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Iterated Function Systems
Manual\
\>", "Title",
  TextAlignment->Center],

Cell["by Roman E. Maeder", "Subsubtitle",
  TextAlignment->Center],

Cell["Reference", "Section"],

Cell["Title", "Subsubsection"],

Cell[TextData[StyleBox["Package template",
  FontSlant->"Italic"]], "Text"],

Cell["Author", "Subsubsection"],

Cell["Roman E. Maeder", "Text"],

Cell["Summary", "Subsubsection"],

Cell["\<\
This notebook is a template for package and notebook development.\
\
\>", "Text"],

Cell["Copyright", "Subsubsection"],

Cell[TextData[{
  "\[Copyright] Copyright 1996, ",
  StyleBox["your name or institution",
    FontSlant->"Italic"],
  ".\n\nPermission is granted to distribute this file for any purpose except \
for inclusion in commercial software or program collections. This copyright \
notice must remain intact.."
}], "Text"],

Cell["Notebook Version", "Subsubsection"],

Cell["1.0", "Text"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version"
}], "Subsubsection"],

Cell["3.0", "Text"],

Cell["History", "Subsubsection"],

Cell[TextData[{
  "Version 1.0 for ",
  StyleBox["Programming in ",
    FontSlant->"Italic"],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", 3rd edition."
}], "Text"],

Cell["Keywords", "Subsubsection"],

Cell["programming, notebooks, packages, template", "Text"],

Cell["Source", "Subsubsection"],

Cell[TextData[{
  "Maeder, R. ",
  StyleBox["Programming in ",
    FontSlant->"Italic"],
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", 3rd ed. Addison-Wesley, 1996."
}], "Text"],

Cell["Warnings", "Subsubsection"],

Cell[TextData[StyleBox["description of global effects, incompatibilities",
  FontSlant->"Italic"]], "Text"],

Cell[TextData[{
  "Note: all cells marked as \"InitializationCell\" will be written to the \
Auto-Save package. This package can then be read in programs that use it with \
",
  StyleBox["Needs[\"Template`\"]", "Input"],
  ". Cells not intended to belong to the package should not have this \
property."
}], "Text"],

Cell["Limitation", "Subsubsection"],

Cell[TextData[StyleBox["special cases not handled, known problems",
  FontSlant->"Italic"]], "Text"],

Cell["Discussion", "Subsubsection"],

Cell[TextData[StyleBox["description of algorithm, information for experts",
  FontSlant->"Italic"]], "Text"],

Cell["Requirements", "Subsubsection"],

Cell[TextData[StyleBox["Context`Package`",
  FontFamily->"Courier",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text"],

Cell["Affine Maps", "Section",
  CellTags->"AffineMap"],

Cell[BoxData[
    \(Needs["ProgrammingInMathematica`AffineMaps`"]\)], "Input",
  CellTags->"AffineMap"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?AffineMap\)\)], "Input",
  CellTags->"AffineMap"],

Cell[BoxData[
    \("AffineMap[\[Phi], \[Psi], r, s, e, f] generates an affine map with \
rotation angles \[Phi], \[Psi], scale factors r, s, and translation \
components e, f. AffineMap[{x, y}, {fxy, gxy}] generates an affine map with \
the two components given as expressions in x and y. AffineMap[matrix] uses \
the 2x3 matrix for the affine map."\)], "Print",
  CellTags->"AffineMap"]
}, Open  ]],

Cell["Constructors", "Subsection",
  CellTags->"AffineMap"],

Cell["Rotation", "Subsubsection",
  CellTags->{"AffineMap", "rotation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?rotation\)\)], "Input",
  CellTags->{"AffineMap", "rotation"}],

Cell[BoxData[
    \("rotation[\[Alpha]] generates a rotation by \[Alpha]."\)], "Print",
  CellTags->{"AffineMap", "rotation"}]
}, Open  ]],

Cell["Scaling", "Subsubsection",
  CellTags->{"AffineMap", "scale"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?scale\)\)], "Input",
  CellTags->{"AffineMap", "scale"}],

Cell[BoxData[
    \("scale[s, t] generates a scaling map with factors s and t. scale[r] \
scales both coordinates by r."\)], "Print",
  CellTags->{"AffineMap", "scale"}]
}, Open  ]],

Cell["Translation", "Subsubsection",
  CellTags->{"AffineMap", "translation"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?translation\)\)], "Input",
  CellTags->{"AffineMap", "translation"}],

Cell[BoxData[
    \("translation[{x, y}] generates a translation by the vector {x, y}."\)], 
  "Print",
  CellTags->{"AffineMap", "translation"}]
}, Open  ]],

Cell["Functions", "Subsection",
  CellTags->"AffineMap"],

Cell["Average Contraction", "Subsubsection",
  CellTags->{"AffineMap", "AverageContraction"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?AverageContraction\)\)], "Input",
  CellTags->{"AffineMap", "AverageContraction"}],

Cell[BoxData[
    \("AverageContraction[map] gives the average area contraction factor (the \
determinant) of an affine map."\)], "Print",
  CellTags->{"AffineMap", "AverageContraction"}]
}, Open  ]],

Cell["Parameters", "Subsection",
  CellTags->"AffineMap"],

Cell["Number of Points for Circle Approximation", "Subsubsection",
  CellTags->{"AffineMap", "$CirclePoints"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?$CirclePoints\)\)], "Input",
  CellTags->{"AffineMap", "$CirclePoints"}],

Cell[BoxData[
    \("$CirclePoints is the number of vertices of the polygon approximating \
the affine image of a circle."\)], "Print",
  CellTags->{"AffineMap", "$CirclePoints"}]
}, Open  ]],

Cell["Current value:", "Text",
  CellTags->{"AffineMap", "$CirclePoints"}],

Cell[CellGroupData[{

Cell[BoxData[
    \($CirclePoints\)], "Input",
  CellTags->{"AffineMap", "$CirclePoints"}],

Cell[BoxData[
    \(24\)], "Output",
  CellTags->{"AffineMap", "$CirclePoints"}]
}, Open  ]],

Cell["Examples", "Subsection",
  CellTags->"AffineMap"],

Cell[BoxData[
    \(Needs["ProgrammingInMathematica`AffineMaps`"]\)], "Input",
  CellTags->"AffineMap"],

Cell["This map represents scaling by one half.", "Text",
  CellTags->"AffineMap"],

Cell[CellGroupData[{

Cell[BoxData[
    \(s = scale[0.5]\)], "Input",
  CellTags->"AffineMap"],

Cell[BoxData[
    \("-map-"\)], "Output",
  CellTags->"AffineMap"]
}, Open  ]],

Cell[TextData["Here is a rotation by \[Pi]/2:"], "Text",
  CellTags->"AffineMap"],

Cell[CellGroupData[{

Cell[BoxData[
    \(rot\  = \ rotation[90 \[Degree]]\)], "Input",
  CellTags->"AffineMap"],

Cell[BoxData[
    \("-map-"\)], "Output",
  CellTags->"AffineMap"]
}, Open  ]],

Cell["Maps can be composed", "Text",
  CellTags->"AffineMap"],

Cell[BoxData[
    \(\(sr = Composition[s, rot]; \)\)], "Input",
  CellTags->"AffineMap"],

Cell["\<\
To see what the map does, simply apply it to a point with symbolic \
coordinates.\
\>", "Text",
  CellTags->"AffineMap"],

Cell[CellGroupData[{

Cell[BoxData[
    \(sr[{x, y}]\)], "Input",
  CellTags->"AffineMap"],

Cell[BoxData[
    \({\(0.`\ \) + 0.`\ x - 0.5`\ y, \(0.`\ \) + 0.5`\ x + 0.`\ y}\)], 
  "Output",
  CellTags->"AffineMap"]
}, Open  ]],

Cell["Here is a test graphic", "Text",
  CellTags->"AffineMap"],

Cell[CellGroupData[{

Cell["\<\
gr1 = Show[
Graphics[{
 Line[{{-1, -1}, {1, -1}, {1, 1}}],
 Polygon[{{-1, 1}, {0.5, -1.5}, {0.7, 0.8}}],
 {PointSize[0.05], Point[{-0.7, -0.6}]},
 {Thickness[0.04], GrayLevel[0.6],
  Line[{{-1, -1.5}, {1, 1.2}}]},
 {GrayLevel[0.8], Disk[{-0.8,0.1}, 0.3]},
 {GrayLevel[0.4], Rectangle[{.8, .1}, {1.6, .5}]},
 Circle[{0, -0.8}, 0.5]
 }], AspectRatio->Automatic
];\
\>", "Input",
  PageWidth->Infinity,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->"AffineMap"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcoa4000>?0000o`0=00003`0011F?5Hoo00h0000>00065HlESaF?o`0=
00003@001aF?5HlESaD0o`0=00002`002XlESaF?5HlESaGo00`0000:000<
SaF?5HlESaF?5HlEo`0;00002@003XlESaF?5HlESaF?5HlEo`0:00002P00
3HlESaF?5HlESaF?5Hl0o`0:00002P003QF?5HlESaF?5HlESaF?T0000`40
001e00002`003QF?5HlESaF?5HlESaF?SP020GL0000<000>5HlESaF?5HlE
SaF?5Hn=0081M`0000d000dESaF?5HlESaF?5HlE08`00`5g00003@003XlE
SaF?5HlESaF?5HlERP040GL0000>000>SaF?5HlESaF?5HlESaF900@1M`00
00l000j?5HlESaF?5HlESaF?5HL01@5g000040003HlESaF?5HlESaF?5Hl0
Q`050GL0000@000>5HlESaF?5HlESaF?5Hn500H1M`00014000hESaF?5HlE
SaF?5HlESh<01`5g00004P003AF?5HlESaF?5HlESaD0P`070GL0000C000=
5HlESaF?5HlESaF?5@2100T1MP0001<000j?5HlESaF?5HlESaF?5H002@5f
000050003XlESaF?5HlESaF?5HlEOP0:0GH0000E000=SaF?5HlESaF?5HlE
S`1m00/1MP0001H000f?5HlESaF?5HlESaF?07`02`5f00005P003QF?5HlE
SaF?5HlESaF?NP0<0GH0000G000>5HlESaF?5HlESaF?5Hmi00`1MP0001P0
00dESaF?5HlESaF?5HlE07P03@5f000060003XlESaF?5HlESaF?5HlEMP0>
0GH0000I000>SaF?5HlESaF?5HlESaE501@1700>0GH0000J000>SaF?5HlE
SaF?5HlESaDo00D150050AH03`5f00006`003HlESaF?5HlESaF?5Hl0?@02
0Ah00`4C0101M@0001/000hESaF?5HlESaF?5HlEScT00`4S0081400A0GD0
000L000>5HlESaF?5HlESaF?5Hlf0081:0030@`04P5e00007@003QF?5HlE
SaF?5HlESaF?<`020Bd00P4:0181M@0001h000dESaF?5HlESaF?5HlE0340
0P4a00030@0000H04`5e00007P003XlESaF?5HlESaF?5HlE;`000`40000b
00030@0000D04`5e00007`003XlESaF?5HlESaF?5HlE;0020CH00P4401@1
M@00020000j?5HlESaF?5HlESaF?5BX000<10000>0000`40000E0GD0000Q
000=SaF?5HlESaF?5HlES`0Y00030@0003X000<10040505e00008@003QF?
5HlESaF?5HlESaF?9P020Ch05P5e00008P003QF?5HlESaF?5HlESaF?9000
0`40000n01H1M@0002<000hESaF?5HlESaF?5HlESb8000<10000?P0H0G@0
000T000=5HlESaF?5HlESaF?5@0Q00030@0003h06@5d000090003XlESaF?
5HlESaF?5HlE80000`40000n01T1M00002D000j?5HlESaF?5HlESaF?5Ah0
00<10000?P0J0G@0000V000=SaF?5HlESaF?5HlES`0M00030@0003l06P5d
00009`003HlESaF?5HlESaF?5Hl06`000`40000o01/1M00002L000hESaF?
5HlESaF?5HlESaT000<10000?`0L0G@0000X000>5HlESaF?5HlESaF?5HlG
00030@000400705d0000:@003AF?5HlESaF?5HlESaD05`000`40000o01d1
M00002X000dESaF?5HlESaF?5HlE01D000<10000@00M0G@0000Z000>SaF?
5HlESaF?5HlESaDD00030@0003l07P5d0000:`003XlESaF?5HlESaF?5HlE
4P000`40000o0201L`0002`000f?5HlESaF?5HlESaF?014000<10000@00P
0G<0000/000>5HlESaF?5HlESaF?5Hl?00030@0004008@5c0000;@003QF?
5HlESaF?5HlESaF?3P000`4000100241L`0002h000hESaF?5HlESaF?5HlE
S``000<10000@00R0G<0000_000=5HlESaF?5HlESaF?5@0<00030@0003l0
8`5c0000400O0@0>SaF?5HlESaF?5HlESaFO0D@0000`000>SaF?5HlESaF?
5HlESaD900030@0003l0904^00030@000480000a000>SaF?5HlESaF?5HlE
SaD800030@0003l0904^00030@000480000b000=SaF?5HlESaF?5HlES`07
00030@0003l09@4^00030@000480000b000>5HlESaF?5HlESaF?5Hl60003
0@0003h09P4^00030@000480000c000>5HlESaF?5HlESaF?5Hl400030@00
03l09`4]00030@000480000d000>5HlESaF?5HlESaF?5Hl300030@0003h0
:04]00030@000480000e000=5HlESaF?5HlESaF?5@0300030@0003h0:04]
00030@000480000e000>SaF?5HlESaF?5HlESaD200030@0003d0:@4]0003
0@000480000f000@SaF?5HlESaF?5HlESaD00Ch0:P4]00030@000480000g
000>SaF?5HlESaF?5HlES`4o02X1;@000`4000120000>0003HlESaF?5HlE
SaF?5@40?P0[0Bd000<10000@P0003P000hESaF?5HlESaF?5Hl1Scd0:`4]
00030@000480000i000>5HlESaF?5HlESaD15Hlk02`1;@000`4000120000
>P003QF?5HlESaF?5Hl1SaF?>@0]0Bd000<10000@P0003/000dESaF?5HlE
S`6?5HlE03T0;@4]00030@000480000k000>SaF?5HlESaD15HlESaDg02l1
;0000`4000120000?0003XlESaF?5Hl1SaF?5HlE=P0_0B`000<10000@P00
03d000f?5HlESaD15HlESaF?03D0<04/00030@000480000n000=SaF?5Hl1
SaF?5HlES`0c0341;0000`4000120000?P003QF?5HlE0AF?5HlESaF?<P0a
0B`000<10000@P0003l000hESaF?0HlESaF?5HlESc00<P4/00030@000480
0010000=5HlE0AF?5HlESaF?5@0`0381;0000`4000120000@0003XlES`6?
5HlESaF?5HlE;P0c0B`000<10000@P00044000j?5@4ESaF?5HlESaF?5B`0
=04/00030@0004800012000>S`6?5HlESaF?5HlESaD[03@1;0000`400012
0000@`003@4ESaF?5HlESaF?5Hl0:P0e0B`000<10000@P0004<000hE0AF?
5HlESaF?5HlESbT0=P4[00030@0004800014000>0HlESaF?5HlESaF?5HlW
03L1:`000`4000120000A0003`4ESaF?5HlESaF?5HlES`0U03P1:`000`40
00120000A0003`405HlESaF?5HlESaF?5@0U03P1:`000`4000120000A000
4040SaF?5HlESaF?5HlESaDS03T1:`000`4000120000A@004040SaF?5HlE
SaF?5HlESaDR03T1:`000`4000120000A@004@4008lESaF?5HlESaF?5HlE
0200>P4[00030@000480000/00L14P004@40002?5HlESaF?5HlESaF?01l0
>`4[00030@000480000[00T14@004P40000ESaF?5HlESaF?5HlESah0>`4[
00030@000480000Z00/140000`400002000>5HlESaF?5HlESaF?5HlL03`1
:`000`4000120000:@0=0A0000<100000P003QF?5HlESaF?5HlESaF?6`0l
0B/000<10000@P0002T03@4@00030@0000<000dESaF?5HlESaF?5HlE01X0
?P4Z00030@000480000Y00d14@000`400002000>SaF?5HlESaF?5HlESaDH
03l1:P000`4000120000:00>0A4000<100000`003XlESaF?5HlESaF?5HlE
5`0o0BX000<10000@P0002T03@4B00030@0000<000j?5HlESaF?5HlESaF?
5AD0@04Z00030@000480000Y00d14P000`400004000=SaF?5HlESaF?5HlE
S`0E0401:P000`4000120000:@0=0A<000<100000`003QF?5HlESaF?5HlE
SaF?4`110BX000<10000@P0002X02`4D00030@0000@000hESaF?5HlESaF?
5HlESa40@P4Z00030@000480000[00T15P000`400004000=5HlESaF?5HlE
SaF?5@0A0481:P000`4000120000;0070AL000<100001@003AF?5HlESaF?
5HlESaD03`130BX000<10000@P0002l000<100006@000`400004000>SaF?
5HlESaF?5HlESaD>04<1:P000`4000120000C0000`400004000>SaF?5HlE
SaF?5HlESaD<04@1:P000`4000120000C0000`400005000=SaF?5HlESaF?
5HlES`0;04H1:@000`4000120000C@000`400004000>5HlESaF?5HlESaF?
5Hl:04H1:@000`4000120000C@000`400005000>5HlESaF?5HlESaF?5Hl8
04L1:@000`4000120000CP000`400005000>5HlESaF?5HlESaF?5Hl704L1
:@000`4000120000C`000`400005000=5HlESaF?5HlESaF?5@0604P1:@00
0`4000120000D0000`400004000>SaF?5HlESaF?5HlESaD404T1:@000`40
00120000D@000`400004000>SaF?5HlESaF?5HlESaD304T1:@000`400012
0000DP000`400004000?SaF?5HlESaF?5HlESaD004X1:@000`4000120000
D`000`400004000>SaF?5HlESaF?5HlES`1:0BT000<10000@P0005@000<1
00000`003QF?5HlESaF?5HlESaF?BP4Y00030@000480001E00030@0000<0
00hESaF?5HlESaF?5HlESdT1:@000`4000120000EP020@@000hESaF?5HlE
SaF?5HlESdT1:0000`4000120000F0000`400002000=5HlESaF?5HlESaF?
5@190BP000<10000@P0005T001810000SaF?5HlESaF?5HlESaE80BP000<1
0000@P0005X00P42000>SaF?5HlESaF?5HlESaE70BP000<10000@P0005`0
0P403`2?5HlESaF?5HlESaF?5@160BP000<10000@P0005h00`4031F?5HlE
SaF?5HlESdH1:0000`4000120000H0003QD10HlESaF?5HlESaF?A@4X0003
0@000480001Q000>5Hl10AF?5HlESaF?5Hm40BP000<10000@P00064000@1
5HlE0`4021F?5HlESaF?@`4X00030@000480001P00<100DESaF?5@020@06
SaF?5HlE@`4X00030@000480001P00<100N?5HlESaF?04T1:0000`400012
0000G`050@0=SaF?5HlESaF?5HlES`120BP000<10000@P0005l01P403HlE
SaF?5HlESaF?5Hl0@P4W00030@000480001N00P100f?5HlESaF?5HlESaF?
04419`000`4000120000G@090@0>5HlESaF?5HlESaF?5Hm00BL000<10000
@P0005d02P403QF?5HlESaF?5HlESaF??`4W00030@000480001L00`100dE
SaF?5HlESaF?5HlE03l19`000`4000120000G00<0@0>SaF?5HlESaF?5HlE
SaDn0BL000<10000@P0005/03P403XlESaF?5HlESaF?5HlE?@4W00030@00
0480001J010100j?5HlESaF?5HlESaF?5C`19`000`4000120000FP0A0@0=
SaF?5HlESaF?5HlES`0l0BL000<10000@P0005T04P403QF?5HlESaF?5HlE
SaF?>`4W00030@000480000N00n?;00C0@0>5HlESaF?5HlESaF?5Hlj0BL0
00<10000@P0001/001F?08l0S`2?08l0S`2?08l0S`2?08l0:00E0@0>5HlE
SaF?5HlESaF?5Hlj0BH000<10000@P0001P06hlT01L100dESaF?5HlESaF?
5HlE03X19P000`40001200005`007Hl0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?02<05`403XlESaF?5HlESaF?5HlE>@4V00030@000480000E022?
8@0I0@0>SaF?5HlESaF?5HlESaDh0BH000<10000@P0001<002>?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`0P01X100j?5HlESaF?5HlE
SaF?5CL19P000`40001200004P0VSad070403HlESaF?5HlESaF?5Hl0=`4V
00030@000480000A000WS`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?01`07@403QF?5HlESaF?5HlESaF?=P4V00030@000480000@
02Z?6P0N0@0>5HlESaF?5HlESaF?5Hle0BH000<10000@P0000l002^?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?01T08040
3QF?5HlESaF?5HlESaF?=04V00030@000480000>02j?5`0Q0@0=5HlESaF?
5HlESaF?5@0d0BH000<10000@P0000d002n?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`0F028100j?5HlESaF?5HlE
SaF?5C<19P000`4000120000300bSa<090403XlESaF?5HlESaF?5HlE<`4U
00030@000480000;000cS`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?01<09@403XlESaF?5HlESaF?5HlE<P4U
00030@000480000;03B?4@0W0@0=SaF?5HlESaF?5HlES`0b0BD000<10000
@P0000/003>?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?08l04P0W0@0>5HlESaF?5HlESaF?5Hla0BD000<10000
@P0000T0=hl?02T100hESaF?5HlESaF?5HlESc019@000`40001200002@00
=hl0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?08l03P0[0@0=5HlESaF?5HlESaF?5@0`0BD000<10000@P00
00T0>8l=02`100dESaF?5HlESaF?5HlE02l19@000`40001200002@00>Hl0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`0;02d100j?5HlESaF?5HlESaF?5Bh19@000`4000120000
200jS`/0;P403XlESaF?5HlESaF?5HlE;@4U00030@0004800009000iS`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?00X0<0403HlESaF?5HlESaF?5Hl0;@4U00030@0004800007
03^?2@0a0@0>5HlESaF?5HlESaF?5Hl/0BD000<10000@P0000L003^?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`09038100hESaF?5HlESaF?5HlESb`190000`4000120000
1`0lS`L0=0403QF?5HlESaF?5HlESaF?:`4T00030@0004800007000kS`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?08l0200e0@0=5HlESaF?5HlESaF?5@0[0B@000<10000@P00
00L0?8l603H100j?5HlESaF?5HlESaF?5BX190000`40001200001`00>hl0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?00H0>0403XlESaF?5HlESaF?5HlE:@4T00030@000480
000603f?1@0i0@0>SaF?5HlESaF?5HlESaDX0B@000<10000@P0000L003^?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?08l0S`0503/100f?5HlESaF?5HlESaF?02P190000`400012
00001P0mS`@0>`403QF?5HlESaF?5HlESaF?9`4@001A5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E00P00007000kS`2?08l0S`2?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0100m0@0>5HlESaF?5HlESaF?5HlV0A00055B5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E80200000L0?8l203l100hESaF?5HlESaF?
5HlESbD14000DAEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5@0800001`00>hl0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?00<0@0403AF?5HlESaF?5HlESaD0
9@4@001ADQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB00P0
000703b?00<00@40?`403XlESaF?5HlESaF?5HlE9@4?001A5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E00P00007000kS`2?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l00P120@0>SaF?5HlESaF?5HlESaDT0@l0055B5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E80200000L0>hl00`010@120@0>SaF?
5HlESaF?5HlESaDS0@l0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQD0200000L003^?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`160@0=SaF?5HlESaF?
5HlES`0S0@l0055B5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E80200000P0>Xm60@0>5HlESaF?5HlESaF?5HlR0@l0054EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQD0200000T003V?08l0S`2?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0A`403QF?5HlESaF?5HlESaF?8@4?001ADQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB00P0000803Z?B0403QF?5HlESaF?5HlESaF?
804?001A5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E00P0
0009000hS`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?08l0S`1:0@0=5HlESaF?5HlESaF?5@0P0@l0055B5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E80200000T0>8m:0@0>
SaF?5HlESaF?5HlESaDO0@l0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQD0200000/003F?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`1<0@0>SaF?5HlESaF?5HlE
SaDN0@l0055B5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E80
200000/0=8m>0@0=SaF?5HlESaF?5HlES`0N0@l0054EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQD0200000/003B?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0C`403HlE
SaF?5HlESaF?5Hl07P4>001ADQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB00P0000<03:?D0403QF?5HlESaF?5HlESaF?7@4>001A5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E00P0000=000aS`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`1A0@0>5HlESaF?5HlESaF?5HlL0@h0055B5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E80200000`0<HmC0@0=5HlESaF?5HlESaF?5@0L
0@h0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQD02000
00d002n?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`1D0@0>SaF?5HlESaF?5HlESaDK0@h0055B5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E80200000h0;HmF0@0>SaF?5HlESaF?
5HlESaDJ0@h0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQD02000014002V?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`1H0@0>SaF?5HlESaF?5HlESaDI0@h0055B5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8020000140:8mJ0@0=SaF?5HlESaF?
5HlES`0I0@h0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQD0200001<002J?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?05X100hESaF?5HlESaF?5HlESaP13P00DE8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDP0800004`0TS`03004105X100hESaF?5HlE
SaF?5HlESaL13P00DAEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5@0800005@007hl0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
101M0@0>5HlESaF?5HlESaF?5HlF0@h0055B5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E80200001H07Hl405l100dESaF?5HlESaF?5HlE
01L13@00DAEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5@08
00006@006Hl0S`2?08l0S`2?08l0S`2?08l0S`2?08l0101P0@0>SaF?5HlE
SaF?5HlESaDF0@d0055B5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E80200001/05Hl6064100j?5HlESaF?5HlESaF?5AD13@00DAEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5@0800007`003Hl0S`2?
08l0S`2?08l02@1S0@0>SaF?5HlESaF?5HlESaDD0@d0055B5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E80200002@00hl>06@100f?5HlE
SaF?5HlESaF?01@13@00DAEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5@080000=01U0@0>5HlESaF?5HlESaF?5HlC0@d0055B5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E80200003<0I`403QF?5HlE
SaF?5HlESaF?4P4=001A5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8E00P0000c06P100hESaF?5HlESaF?5HlESa413@00DE8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDP080000<P1Z0@0=5HlESaF?
5HlESaF?5@0A0@d0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQD020000380JP403XlESaF?5HlESaF?5HlE404=001ADQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB00P0000a06`100j?5HlESaF?
5HlESaF?5@l13@00DAEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5@080000<01^0@0>SaF?5HlESaF?5HlESaD?0@`0055B5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8020000300K`403HlESaF?5HlE
SaF?5Hl03`4<001A5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8E00P0000_070100hESaF?5HlESaF?5HlES`h13000DE8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDP080000;`1a0@0>5HlESaF?5HlE
SaF?5Hl=0@`0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQD0200002h0L`403AF?5HlESaF?5HlESaD03@4P00030@000480000]07D1
00dESaF?5HlESaF?5HlE00`180000`4000120000;@1e0@0>SaF?5HlESaF?
5HlESaD;0B0000<10000@P0002`0M`403XlESaF?5HlESaF?5HlE2P4P0003
0@000480000/07P100f?5HlESaF?5HlESaF?00X180000`4000120000:`1i
0@0>5HlESaF?5HlESaF?5Hl90B0000<10000@P0002X0N`403QF?5HlESaF?
5HlESaF?204P00030@000480000Z07`100hESaF?5HlESaF?5HlES`P17`00
0`4000120000:@1n0@0=5HlESaF?5HlESaF?5@080Al000<10000@P0002T0
OP403XlESaF?5HlESaF?5HlE1`4O00030@000480000X080100j?5HlESaF?
5HlESaF?5@H17`000`40001200009`220@0>SaF?5HlESaF?5HlESaD50Al0
00<10000@P0002L0P`403HlESaF?5HlESaF?5Hl01@4O00030@000480000V
08@100hESaF?5HlESaF?5HlES`@17`000`40001200009P250@0>5HlESaF?
5HlESaF?5Hl30Al000<10000@P0002D0Q`403QF?5HlESaF?5HlESaF?0P4O
00030@000480000T08T100dESaF?5HlESaF?5HlE00817`000`4000120000
90290@0?SaF?5HlESaF?5HlESaD101l000<10000@P0002<0R`403hlESaF?
5HlESaF?5HlE0@0N00030@000480000S08`100j?5HlESaF?5HlESaF?5Ah0
00<10000@P000280SP403HlESaF?5HlESaF?5Hl07P000`40001200008@2?
0@0>5HlESaF?5HlESaF?5HlM00030@000480000Q090100hESaF?5HlESaF?
5HlESa`000<10000@P000200TP403QF?5HlESaF?5HlESaF?6`000`400012
0000802C0@0=5HlESaF?5HlESaF?5@0K00030@000480000O09@100j?5HlE
SaF?5HlESaF?5AX000<10000@P0001h0UP403XlESaF?5HlESaF?5HlE6@00
0`40001200007P2G0@0=SaF?5HlESaF?5HlES`0I00030@000480000M09T1
00f?5HlESaF?5HlESaF?01P000<10000@P0001d0V@403QF?5HlESaF?5HlE
SaF?5`000`4000120000702I0@8000hESaF?5HlESaF?5HlESaH000<10000
@P0001/0T@4<000=5HlESaF?5HlESaF?5@0F00030@000480000K08T15@00
3AF?5HlESaF?5HlESaD05@000`40001200006P210Ah000j?5HlESaF?5HlE
SaF?5A@000<10000@P0001X0N04X000>SaF?5HlESaF?5HlESaDC00030@00
0480000I0741<@003HlESaF?5HlESaF?5Hl04`000`4000120000601Y0CX0
00hESaF?5HlESaF?5HlESa8000<10000@P0001P0H054000>5HlESaF?5HlE
SaF?5HlA00030@000480000G05T1C@003QF?5HlESaF?5HlESaF?40000`40
001200005`1@0EL000dESaF?5HlESaF?5HlE010000<10000@P0001H0B05P
000>SaF?5HlESaF?5HlESaD?00030@000480000E0441J@003XlESaF?5HlE
SaF?5HlE3P000`40001200005@0h0G<000j?5HlESaF?5HlESaF?5@d000<1
0000@P0001@0<05m000=SaF?5HlESaF?5HlES`0=00030@000480000D02P1
Q@003QF?5HlESaF?5HlESaF?30000`40001200004`0P0Hl000hESaF?5HlE
SaF?5HlES`/000<10000@P000180606I000>5HlESaF?5HlESaF?5Hl:0003
0@000480000B0101XP003AF?5HlESaF?5HlESaD02P000`40001200004@08
0J/000j?5HlESaF?5HlESaF?5@T000<10000@P000<D000j?5HlESaF?5HlE
SaF?5@P000<10000@P000<H000j?5HlESaF?5HlESaF?5D`00037000=SaF?
5HlESaF?5HlES`1<0000a`003QF?5HlESaF?5HlESaF?B`000<P000hESaF?
5HlESaF?5HlESdX00039000=5HlESaF?5HlESaF?5@1:0000bP003AF?5HlE
SaF?5HlESaD0B@000<X000j?5HlESaF?5HlESaF?5DP0003;000>SaF?5HlE
SaF?5HlESaE70000c0003HlESaF?5HlESaF?5Hl0A`000<d000f?5HlESaF?
5HlESaF?04H0003=000>5HlESaF?5HlESaF?5Hm50000cP003QF?5HlESaF?
5HlESaF?A0000<l000dESaF?5HlESaF?5HlE04@0003?000>SaF?5HlESaF?
5HlESaE30000d0003XlESaF?5HlESaF?5HlE@P000=4000j?5HlESaF?5HlE
SaF?5D40003B000=SaF?5HlESaF?5HlES`110000dP003QF?5HlESaF?5HlE
SaF?@0000=<000hESaF?5HlESaF?5HlEScl0003D000>5HlESaF?5HlESaF?
5Hln0000e@003AF?5HlESaF?5HlESaD0?P000=D000j?5HlESaF?5HlESaF?
5Cd0003F000<SaF?5HlESaF?5HlE?P000=L000Z?5HlESaF?5HlE?`000=P0
00N?5HlESaF?0440003H00065HlESaF?@P000=T000@ESaF?@`000001
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"AffineMap"]
}, Open  ]],

Cell["\<\
The translation helps to separate the two images, the original on \
the left, and the transformed graphic on the right.\
\>", "Text",
  CellTags->"AffineMap"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[{gr1, \(translation[{3, 0}]\)[sr[gr1]]}]; \)\)], "Input",
  CellTags->"AffineMap"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000X0P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hco`T000N?5HlESaF?0?l04@0000L000XESaF?5HlESaF?o`0@00001P00
31F?5HlESaF?5HlESol03`0000D000hESaF?5HlESaF?5HlESol03P0000H0
00dESaF?5HlESaF?5HlE0?l03P0000H000j?5HlESaF?5HlESaF?5Dd000<1
0000_00000L000j?5HlESaF?5HlESaF?5D/00P6n000020003XlESaF?5HlE
SaF?5HlEBP020Kh00009000=SaF?5HlESaF?5HlES`1900<1_P0000T000hE
SaF?5HlESaF?5HlESdL0106n00002P003QF?5HlESaF?5HlESaF?AP040Kh0
000;000>5HlESaF?5HlESaF?5Hm400D1_P0000`000dESaF?5HlESaF?5HlE
04@01@6n000030003XlESaF?5HlESaF?5HlE@P060Kh0000=000>SaF?5HlE
SaF?5HlESaE000L1_P0000h000j?5HlESaF?5HlESaF?5B@02@4B00L1_P00
00l000f?5HlESaF?5HlESaF?02400`4900D130090Kd0000?000>5HlESaF?
5HlESaF?5HlN00814@030@T02@6m000040003QF?5HlESaF?5HlESaF?6P03
0AH000<100001@0:0Kd0000A000>5HlESaF?5HlESaF?5HlF00<16P020@@0
2`6m00004P003AF?5HlESaF?5HlESaD05@000`40000M00810P0;0Kd0000B
000>SaF?5HlESaF?5HlESaDC00030@0002003@6m00004`003XlESaF?5HlE
SaF?5HlE4@000`40000R00`1_@0001@000f?5HlESaF?5HlESaF?010000<1
00008P0=0Kd0000E000=SaF?5HlESaF?5HlES`0>00030@0002803P6m0000
5@003QF?5HlESaF?5HlESaF?30000`40000S00h1_@0001H000hESaF?5HlE
SaF?5HlES`X000<100008`0?0Kd0000G000=5HlESaF?5HlESaF?5@0:0003
0@0002<03`6m00005`003XlESaF?5HlESaF?5HlE20000`40000S0141_000
01P000j?5HlESaF?5HlESaF?5@L000<100008P0B0K`0000I000>SaF?5HlE
SaF?5HlESaD500030@0002<04P6l00006P003HlESaF?5HlESaF?5Hl01000
0`40000S01<1_00000`03P403QF?5HlESaF?5HlESaF?EP6R00006`0041F?
5HlESaF?5HlESaF?004U01@16@000`40002P000070003aF?5HlESaF?5HlE
SaF?0@0T01D16@000`40002P00007@003QF?5HlESaF?5HlESaD1900E0AT0
00<10000X00001d000j?5HlESaF?5HlESaD15B<05P4I00030@000:00000N
000>SaF?5HlESaF?5Hl1SaDQ01L16@000`40002P00007`003XlESaF?5HlE
SaD15HlE800G0AT000<10000X000020000f?5HlESaF?5Hl1SaF?01l0604I
00030@000:00000P000>5HlESaF?5HlE0AF?5HlN01T160000`40002P0000
8@003QF?5HlESaD15HlESaF?700J0AP000<10000X000028000hESaF?5Hl1
SaF?5HlESaX06`4H00030@000:00000S000=5HlESaD15HlESaF?5@0J01/1
60000`40002P00008`003XlESaF?0HlESaF?5HlE600L0AP000<10000X000
02@000j?5HlE0AF?5HlESaF?5AL0704H00030@000:00000U000>SaF?5@4E
SaF?5HlESaDE01d160000`40002P00009P003HlES`6?5HlESaF?5Hl0500N
0AP000<10000X00001/01`44000>5HlE0AF?5HlESaF?5HlC01h160000`40
002P00006P090@@000hES`6?5HlESaF?5HlESa407`4H00030@000:00000I
00/110003QD15HlESaF?5HlESaF?400O0AP000<10000X00001P03@44000=
0HlESaF?5HlESaF?5@0?02415`000`40002P0000600=0@@000j?0HlESaF?
5HlESaF?5@d08P4G00030@000:00000H00d11@003P4ESaF?5HlESaF?5HlE
300R0AL000<10000X00001L03P45000?0HlESaF?5HlESaF?5HlE00X08`4G
00030@000:00000H00d11P003P6?5HlESaF?5HlESaF?2P0S0AL000<10000
X00001P03@46000?0AF?5HlESaF?5HlESaF?00P0904G00030@000:00000H
00d11`003`4ESaF?5HlESaF?5HlES`0602D15`000`40002G00035@0000H0
000I00/12@003P4ESaF?5HlESaF?5HlE1P0U0AL000<10000J004SbX000<E
SaD01`0001X02@4;000>0AF?5HlESaF?5HlESaD402H15`000`40001U000;
S`2?08l0S`2?08l09@001AF?5HlE00H0000K00L130003`6?5HlESaF?5HlE
SaF?5@0202L15`000`40001T00b?6@000`4000070008SaF?5HlESaD50000
7P000`40000>000@0HlESaF?5HlESaF?5HlE02L15`000`40001B00030@00
010000^?08l0S`2?08l0S`0I00030@0000H000R?5HlESaF?5@H0000`000>
0HlESaF?5HlESaF?5HlX0AL000<10000DP030@h03hlG00030@0000D000R?
5HlESaF?5@L0000a000>0HlESaF?5HlESaF?5HlX0AH000<10000DP040@d0
00n?08l0S`2?08l0S`2?08l05`000`40000300095HlESaF?5HlE00P0000b
000>0HlESaF?5HlESaF?5HlW0AH000<10000DP060@X048lG00030@000080
00PESaF?5HlES`X0000c000>0HlESaF?5HlESaF?5HlV0AH000<10000DP08
0@T000n?08l0S`2?08l0S`2?08l05`00304008lESaF?5HlES`/0000d000=
0HlESaF?5HlESaF?5@0V0AH000<10000DP090@L04Hl:00@120002`40SaF?
5HlESaF?00`0000d000>S`6?5HlESaF?5HlESaDU0AH000<10000DP0;0@H0
00n?08l0S`2?08l0S`2?08l02P060@L000T1SaF?5HlESaD03P0003D000j?
0@4ESaF?5HlESaF?5B@15P000`40001B00d10`0@S`X01P4600095HlESaF?
5HlE00l0000f0003SaD1008100TESaF?5HlESaD08`4F00030@0005<03@43
000?S`2?08l0S`2?08l0S`2?00X01P4500095HlESaF?5HlE0100000g0004
SaF?5@<100HESaF?5HlS0AH000<10000D`0?0@0308n?00f?2P060@@000PE
SaF?5HlESa80000g00075HlESaF?5@0Y0AH000<10000D`0A0@0<08l0S`2?
08l0S`2?3@040@<000V?5HlESaF?5Hl04`0003P000hESaF?5HlESaF?5HlE
Sb415P000`40001C014138lC0008SaF?5HlESaDE0000>0003`4ESaF?5HlE
SaF?5HlES`0P0AH000<10000D`0C0@0808l0S`2?08lD0008SaF?5HlESaDF
0000=`030@0=5HlESaF?5HlESaF?5@0P0AH000<10000D`0E0@B?50000aF?
0@030@045HlE0AH0000f00@100j?5HlESaF?5HlESaF?5B015@000`40001C
01L15@030@04SaF?5@@15P0003H01@403XlESaF?5HlESaF?5HlE7`4E0003
0@0005<06@4A008100N?5HlESaF?00<00`4D0000=@070@0>SaF?5HlESaF?
5HlESaDN0AD000<10000E00J0@d00P4021F?5HlESaF?10000`4000020A80
000B00Z?6@080@0=SaF?5HlESaF?5HlES`0N0AD000<10000E00K0@/000T1
SaF?5HlESaD01P000`40000200030@0000l0000A000=S`2?08l0S`2?08l0
S`0F00T100hESaF?5HlESaF?5HlESad15@000`40001D01d120002@6?5HlE
SaF?5@0700030@0000<000<100003P0000h04hlB00/100hESaF?5HlESaF?
5HlESa`15@000`40001D01l11@002@6?5HlESaF?5@0800030@0000<000<1
00003P0000d001F?08l0S`2?08l0S`2?08l0S`2?08l04@0<0@0>5HlESaF?
5HlESaF?5HlK0AD000<10000E00P0@<000P1SaF?5HlES`X000<100001000
0`40000=0000300HS`h03P403AF?5HlESaF?5HlESaD06`4E00030@0005@0
8@402HlE0AF?5HlES`0;00030@0000@000<100003@0000/001V?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?00h03P403XlESaF?5HlESaF?5HlE6P4E0003
0@0005@080402HlES`6?5HlES`0<00030@0000D000<10000300000X078l;
010100j?5HlESaF?5HlESaF?5AT15@000`40001D01l100R?5Hl1SaF?5@h0
00<100001@000`40000<00002`006hl0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`0:018100j?5HlESaF?5HlESaF?5AP15@000`40001E01`100XESaF?
5@4ESaD13P000`40000500030@0000`0000901f?2P0C0@0=SaF?5HlESaF?
5HlES`0H0AD000<10000E@0K0@085HlESaF?0Hl50@`000<100001@000`40
000<00002@007Hl0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?00T05040
3QF?5HlESaF?5HlESaF?604D00030@0005D06P401aF?5HlESaD0204;0003
0@0000H000<100002`0000P088l601H100hESaF?5HlESaF?5HlESaL15000
0`40001E01P100V?5HlESaF?5Hl02P4900030@0000H000<100002`0000T0
01n?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?00H05`403QF?5HlE
SaF?5HlESaF?5P4D00030@0005D05`4028lESaF?5HlE3P4700030@0000H0
00<100002`0000L08Hl501T100dESaF?5HlESaF?5HlE01H150000`40001E
01H100R?5HlESaF?5A011P000`40000600030@0000/00007000QS`2?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?00D06@403XlESaF?5HlESaF?
5HlE5@4D00030@0005D050402AF?5HlESaF?5@0C0@@000<100001@000`40
000<00001`0QS`@06`403XlESaF?5HlESaF?5HlE504D00030@0005D04`40
21F?5HlESaF?5`4200030@0000D000<10000300000L0026?08l0S`2?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?08l00`0M0@0>SaF?5HlESaF?5HlESaDC
0A@000<10000EP0@0@09SaF?5HlESaF?01T100<00@001P000`40000<0000
1`0QS`<07P403HlESaF?5HlESaF?5Hl04`4D00030@0005H03`402HlESaF?
5HlES`0L0@H000<100003@0000L0026?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?08l00P0O0@0>5HlESaF?5HlESaF?5HlB0@T002`EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDSP03P4028lE
SaF?5HlE804400030@0000d00007026?0P0P0@0>5HlESaF?5HlESaF?5HlA
0@T002aB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5CP030402AF?5HlESaF?5@0R0@8000<100003P0000L002:?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l08P403AF?5HlESaF?5HlESaD0
4@49000/5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8h00/100TESaF?5HlESaD09P4@00001`0QSb@100dESaF?5HlESaF?
5HlE01412000;58EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8E>00:0@085HlESaF?5HlY0@l00009000OS`2?08l0S`2?08l0
S`2?08l0S`2?08l0S`2?08l0S`0T0@0>SaF?5HlESaF?5HlESaD@0@P002`E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDSP0
20402HlESaF?5HlES`0[0@h0000801n?9P403XlESaF?5HlESaF?5HlE3`48
000/DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQDh00L100R?5HlESaF?5Bl1300000T001j?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`0W0@0=SaF?5HlESaF?5HlES`0?0@P002`EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDST01@4028lESaF?
5HlE<P4:00002@0NSbP100f?5HlESaF?5HlESaF?00h12000;58EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E>@030@095HlE
SaF?5HlE03@12@0000T001f?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`0Y0@0>5HlESaF?5HlESaF?5Hl=0@P002`EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDST00P4021F?5HlESaF?;04C0000
2P0KSb/100hESaF?5HlESaF?5HlES``12000;58EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E>@002@4ESaF?5HlES`0R0@L0
00<10000500000/001V?08l0S`2?08l0S`2?08l0S`2?08l0S`2?02d100dE
SaF?5HlESaF?5HlE00`12000;1EB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB>0002HlESaF?5HlES`0H0A8000<100005000
00`05hl00`010@0[0@0>SaF?5HlESaF?5HlESaD;0@P002aB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5CL000R?5HlESaF?
5A0170000`40000D00003@005Xl0S`2?08l0S`2?08l0S`2?08l0S`0_0@0>
SaF?5HlESaF?5HlESaD:0@P002`EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDSD000TESaF?5HlESaD01P4W00030@0001@0
000>01>?00<00@40;`403XlESaF?5HlESaF?5HlE2@48000/DQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQDd00095HlESaF?
5HlE02h000<100005000014000n?08l0S`2?08l0S`2?08l00P0b0@0=SaF?
5HlESaF?5HlES`090@P002`EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDS<000PESaF?5HlESc0000<100005000018038l3
03<100hESaF?5HlESaF?5HlES`T11`00;58EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E<@002HlESaF?5HlES`0a00030@00
01@0000E0003S`2?00T0=0403QF?5HlESaF?5HlESaF?2047000/5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8`0009SaF?
5HlESaF?038000<1000050000200=P403QF?5HlESaF?5HlESaF?1`47000/
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQD_
0008SaF?5HlESaD:000;5E8EDQEB5E8EDQD07`000`40000D00007`0h0@0=
5HlESaF?5HlESaF?5@070@L002`EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDRd000TESaF?5HlESaD02`002e8EDQEB5E8E
DQEB01l000<10000500001l0>0403XlESaF?5HlESaF?5HlE1P47000/DQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQD/0008
5HlESaF?5Hl=000;5E8EDQEB5E8EDQD07`000`40000D00007P0j0@0>SaF?
5HlESaF?5HlESaD50@L002`EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDR/000PESaF?5HlES`h000]B5E8EDQEB5E8EDP0O
00030@0001@0000M03`100j?5HlESaF?5HlESaF?5@@11`00;58EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E:P002AF?5HlE
SaF?000>0@0;5E8EDQEB5E8EDQD0804F00007@0m0@0=SaF?5HlESaF?5HlE
S`040A8000<10000B@001AF?5HlE014000]B5E8EDQEB5E8EDP0f0000700n
0@0>5HlESaF?5HlESaF?5Hl30A8000<10000BP000aF?5@0B000;5E8EDQEB
5E8EDQD0=P0001`0?`403QF?5HlESaF?5HlESaF?0P4B00030@0004/000<E
00004@002e8EDQEB5E8EDQEB03H0000K044100lESaF?5HlESaF?5HlES`40
4P000`40001O000;5E8EDQEB5E8EDQD0=P0001X0@`403QF?5HlESaF?5HlE
SaD14P000`40001O000;DQEB5E8EDQEB5E80=P0001X0@`403hlESaF?5HlE
SaF?5HlE0@0A00030@0005l000/EDQEB5E8EDQEB5@0f00006@150@0>SaF?
5HlESaF?5HlESaDA00030@0005l000]B5E8EDQEB5E8EDP0f00006@160@0>
SaF?5HlESaF?5HlESaD@00030@0005l000/EDQEB5E8EDQEB5@0f00006018
0@0=SaF?5HlESaF?5HlES`0@00030@0005l000]B5E8EDQEB5E8EDP0f0000
5`190@0>5HlESaF?5HlESaF?5Hl?00030@0005l000/EDQEB5E8EDQEB5@0f
00005`1:0@0>5HlESaF?5HlESaF?5Hl>00030@0005l000]B5E8EDQEB5E8E
DP0f00005P1<0@0>5HlESaF?5HlESaF?5Hl=00030@0005l000/EDQEB5E8E
DQEB5@0f00005P1=0@0=5HlESaF?5HlESaF?5@0=00030@0005l000]B5E8E
DQEB5E8EDP0f00005@1>0@0>SaF?5HlESaF?5HlESaD<00030@0005l000/E
DQEB5E8EDQEB5@0f0000501@0@0>SaF?5HlESaF?5HlESaD;00030@0005l0
00]B5E8EDQEB5E8EDP0f0000501A0@0>SaF?5HlESaF?5HlESaD:00030@00
05l000/EDQEB5E8EDQEB5@0f00004`1C0@0=SaF?5HlESaF?5HlES`0:0003
0@0005l000]B5E8EDQEB5E8EDP0f00004`1A0@8000hESaF?5HlESaF?5HlE
S`T000<10000X0000180B@4<000>5HlESaF?5HlESaF?5Hl800030@000:00
000A04415P003AF?5HlESaF?5HlESaD020000`40002P00004@0i0Al000dE
SaF?5HlESaF?5HlE00L000<10000X0000100<@4X000>SaF?5HlESaF?5HlE
SaD600030@000:00000@02P1<P003XlESaF?5HlESaF?5HlE1@000`40002P
00003`0P0C`000f?5HlESaF?5HlESaF?00D000<10000X00000h06@54000>
5HlESaF?5HlESaF?5Hl400030@000:00000>0101CP003QF?5HlESaF?5HlE
SaF?0`000`40002P00003@080EP000hESaF?5HlESaF?5HlES`8000<10000
X00006h000dESaF?5HlESaF?5HlE008000<10000X00006h000j?5HlESaF?
5HlESaF?5J@0001_000>SaF?5HlESaF?5HlESaFS0000L0003XlESaF?5HlE
SaF?5HlEXP00074000f?5HlESaF?5HlESaF?0:80001a000>5HlESaF?5HlE
SaF?5HnQ0000LP003QF?5HlESaF?5HlESaF?X00007<000hESaF?5HlESaF?
5HlESil0001d000=5HlESaF?5HlESaF?5@2O0000M0003XlESaF?5HlESaF?
5HlEWP0007D000j?5HlESaF?5HlESaF?5Id0001f000>SaF?5HlESaF?5HlE
SaFL0000M`003HlESaF?5HlESaF?5Hl0W00007L000hESaF?5HlESaF?5HlE
Si/0001h000<5HlESaF?5HlESaF?W00007T000XESaF?5HlESaF?W@000001

\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{288, 160.312},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["Iterated Function Systems", "Section",
  CellTags->"IFS"],

Cell[BoxData[
    \(Needs["ProgrammingInMathematica`IFS`"]\)], "Input",
  CellTags->"IFS"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?IFS\)\)], "Input",
  CellTags->"IFS"],

Cell[BoxData[
    \("IFS[{maps..}, {options..}] generates an iterated function system \
(IFS)."\)], "Print",
  CellTags->"IFS"]
}, Open  ]],

Cell["Options", "Subsection",
  CellTags->"IFS"],

Cell["Probabilities", "Subsubsection",
  CellTags->{"IFS", "Probabilities"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Probabilities\)\)], "Input",
  CellTags->{"IFS", "Probabilities"}],

Cell[BoxData[
    \("Probabilities -> {pr..} is an option of IFS that gives the \
probabilities of the maps for the chaos game."\)], "Print",
  CellTags->{"IFS", "Probabilities"}]
}, Open  ]],

Cell["Option defaults", "Text",
  CellTags->{"IFS", "Probabilities"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[IFS]\)], "Input",
  CellTags->{"IFS", "Probabilities"}],

Cell[BoxData[
    \({Probabilities \[Rule] Automatic}\)], "Output",
  CellTags->{"IFS", "Probabilities"}]
}, Open  ]],

Cell["Examples", "Subsection",
  CellTags->"IFS"],

Cell[BoxData[
    \(Needs["ProgrammingInMathematica`IFS`"]\)], "Input",
  CellTags->"IFS"],

Cell["\<\
This sample IFS consists of one scaling map, an affine map given by \
rotation angles, scaling factors and translation components, and one map \
given in functional form.\
\>", "Text",
  CellTags->"IFS"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ifs0\  = \ 
      IFS[{\n\ \ \ \ scale[0.3, \ 0.8], \n\ \ \ \ 
          AffineMap[0.2, \ 0.4, \ 0.9, \ 0.5, \ 2, \ \(-2\)], \n\ \ \ \ 
          AffineMap[{x, \ y}, \ {0.9 y\  - \ 2, \ x\  - \ 0.1 y\  - \ 2}]\n
          \ \ }]\)], "Input",
  CellTags->"IFS"],

Cell[BoxData[
    \("-ifs-"\)], "Output",
  CellTags->"IFS"]
}, Open  ]],

Cell["\<\
IFS can be applied to graphics. Here is a the sample graphic from \
the previous section on affine maps again.\
\>", "Text",
  CellTags->"IFS"],

Cell[CellGroupData[{

Cell["\<\
gr1 = Show[
Graphics[{
 Line[{{-1, -1}, {1, -1}, {1, 1}}],
 Polygon[{{-1, 1}, {0.5, -1.5}, {0.7, 0.8}}],
 {PointSize[0.05], Point[{-0.7, -0.6}]},
 {Thickness[0.04], GrayLevel[0.6],
  Line[{{-1, -1.5}, {1, 1.2}}]},
 {GrayLevel[0.8], Disk[{-0.8,0.1}, 0.3]},
 {GrayLevel[0.4], Rectangle[{.8, .1}, {1.6, .5}]},
 Circle[{0, -0.8}, 0.5]
 }], AspectRatio->Automatic
];\
\>", "Input",
  PageWidth->Infinity,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->"IFS"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000180P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcoa4000>?0000o`0=00003`0011F?5Hoo00h0000>00065HlESaF?o`0=
00003@001aF?5HlESaD0o`0=00002`002XlESaF?5HlESaGo00`0000:000<
SaF?5HlESaF?5HlEo`0;00002@003XlESaF?5HlESaF?5HlEo`0:00002P00
3HlESaF?5HlESaF?5Hl0o`0:00002P003QF?5HlESaF?5HlESaF?T0000`40
001e00002`003QF?5HlESaF?5HlESaF?SP020GL0000<000>5HlESaF?5HlE
SaF?5Hn=0081M`0000d000dESaF?5HlESaF?5HlE08`00`5g00003@003XlE
SaF?5HlESaF?5HlERP040GL0000>000>SaF?5HlESaF?5HlESaF900@1M`00
00l000j?5HlESaF?5HlESaF?5HL01@5g000040003HlESaF?5HlESaF?5Hl0
Q`050GL0000@000>5HlESaF?5HlESaF?5Hn500H1M`00014000hESaF?5HlE
SaF?5HlESh<01`5g00004P003AF?5HlESaF?5HlESaD0P`070GL0000C000=
5HlESaF?5HlESaF?5@2100T1MP0001<000j?5HlESaF?5HlESaF?5H002@5f
000050003XlESaF?5HlESaF?5HlEOP0:0GH0000E000=SaF?5HlESaF?5HlE
S`1m00/1MP0001H000f?5HlESaF?5HlESaF?07`02`5f00005P003QF?5HlE
SaF?5HlESaF?NP0<0GH0000G000>5HlESaF?5HlESaF?5Hmi00`1MP0001P0
00dESaF?5HlESaF?5HlE07P03@5f000060003XlESaF?5HlESaF?5HlEMP0>
0GH0000I000>SaF?5HlESaF?5HlESaE501@1700>0GH0000J000>SaF?5HlE
SaF?5HlESaDo00D150050AH03`5f00006`003HlESaF?5HlESaF?5Hl0?@02
0Ah00`4C0101M@0001/000hESaF?5HlESaF?5HlEScT00`4S0081400A0GD0
000L000>5HlESaF?5HlESaF?5Hlf0081:0030@`04P5e00007@003QF?5HlE
SaF?5HlESaF?<`020Bd00P4:0181M@0001h000dESaF?5HlESaF?5HlE0340
0P4a00030@0000H04`5e00007P003XlESaF?5HlESaF?5HlE;`000`40000b
00030@0000D04`5e00007`003XlESaF?5HlESaF?5HlE;0020CH00P4401@1
M@00020000j?5HlESaF?5HlESaF?5BX000<10000>0000`40000E0GD0000Q
000=SaF?5HlESaF?5HlES`0Y00030@0003X000<10040505e00008@003QF?
5HlESaF?5HlESaF?9P020Ch05P5e00008P003QF?5HlESaF?5HlESaF?9000
0`40000n01H1M@0002<000hESaF?5HlESaF?5HlESb8000<10000?P0H0G@0
000T000=5HlESaF?5HlESaF?5@0Q00030@0003h06@5d000090003XlESaF?
5HlESaF?5HlE80000`40000n01T1M00002D000j?5HlESaF?5HlESaF?5Ah0
00<10000?P0J0G@0000V000=SaF?5HlESaF?5HlES`0M00030@0003l06P5d
00009`003HlESaF?5HlESaF?5Hl06`000`40000o01/1M00002L000hESaF?
5HlESaF?5HlESaT000<10000?`0L0G@0000X000>5HlESaF?5HlESaF?5HlG
00030@000400705d0000:@003AF?5HlESaF?5HlESaD05`000`40000o01d1
M00002X000dESaF?5HlESaF?5HlE01D000<10000@00M0G@0000Z000>SaF?
5HlESaF?5HlESaDD00030@0003l07P5d0000:`003XlESaF?5HlESaF?5HlE
4P000`40000o0201L`0002`000f?5HlESaF?5HlESaF?014000<10000@00P
0G<0000/000>5HlESaF?5HlESaF?5Hl?00030@0004008@5c0000;@003QF?
5HlESaF?5HlESaF?3P000`4000100241L`0002h000hESaF?5HlESaF?5HlE
S``000<10000@00R0G<0000_000=5HlESaF?5HlESaF?5@0<00030@0003l0
8`5c0000400O0@0>SaF?5HlESaF?5HlESaFO0D@0000`000>SaF?5HlESaF?
5HlESaD900030@0003l0904^00030@000480000a000>SaF?5HlESaF?5HlE
SaD800030@0003l0904^00030@000480000b000=SaF?5HlESaF?5HlES`07
00030@0003l09@4^00030@000480000b000>5HlESaF?5HlESaF?5Hl60003
0@0003h09P4^00030@000480000c000>5HlESaF?5HlESaF?5Hl400030@00
03l09`4]00030@000480000d000>5HlESaF?5HlESaF?5Hl300030@0003h0
:04]00030@000480000e000=5HlESaF?5HlESaF?5@0300030@0003h0:04]
00030@000480000e000>SaF?5HlESaF?5HlESaD200030@0003d0:@4]0003
0@000480000f000@SaF?5HlESaF?5HlESaD00Ch0:P4]00030@000480000g
000>SaF?5HlESaF?5HlES`4o02X1;@000`4000120000>0003HlESaF?5HlE
SaF?5@40?P0[0Bd000<10000@P0003P000hESaF?5HlESaF?5Hl1Scd0:`4]
00030@000480000i000>5HlESaF?5HlESaD15Hlk02`1;@000`4000120000
>P003QF?5HlESaF?5Hl1SaF?>@0]0Bd000<10000@P0003/000dESaF?5HlE
S`6?5HlE03T0;@4]00030@000480000k000>SaF?5HlESaD15HlESaDg02l1
;0000`4000120000?0003XlESaF?5Hl1SaF?5HlE=P0_0B`000<10000@P00
03d000f?5HlESaD15HlESaF?03D0<04/00030@000480000n000=SaF?5Hl1
SaF?5HlES`0c0341;0000`4000120000?P003QF?5HlE0AF?5HlESaF?<P0a
0B`000<10000@P0003l000hESaF?0HlESaF?5HlESc00<P4/00030@000480
0010000=5HlE0AF?5HlESaF?5@0`0381;0000`4000120000@0003XlES`6?
5HlESaF?5HlE;P0c0B`000<10000@P00044000j?5@4ESaF?5HlESaF?5B`0
=04/00030@0004800012000>S`6?5HlESaF?5HlESaD[03@1;0000`400012
0000@`003@4ESaF?5HlESaF?5Hl0:P0e0B`000<10000@P0004<000hE0AF?
5HlESaF?5HlESbT0=P4[00030@0004800014000>0HlESaF?5HlESaF?5HlW
03L1:`000`4000120000A0003`4ESaF?5HlESaF?5HlES`0U03P1:`000`40
00120000A0003`405HlESaF?5HlESaF?5@0U03P1:`000`4000120000A000
4040SaF?5HlESaF?5HlESaDS03T1:`000`4000120000A@004040SaF?5HlE
SaF?5HlESaDR03T1:`000`4000120000A@004@4008lESaF?5HlESaF?5HlE
0200>P4[00030@000480000/00L14P004@40002?5HlESaF?5HlESaF?01l0
>`4[00030@000480000[00T14@004P40000ESaF?5HlESaF?5HlESah0>`4[
00030@000480000Z00/140000`400002000>5HlESaF?5HlESaF?5HlL03`1
:`000`4000120000:@0=0A0000<100000P003QF?5HlESaF?5HlESaF?6`0l
0B/000<10000@P0002T03@4@00030@0000<000dESaF?5HlESaF?5HlE01X0
?P4Z00030@000480000Y00d14@000`400002000>SaF?5HlESaF?5HlESaDH
03l1:P000`4000120000:00>0A4000<100000`003XlESaF?5HlESaF?5HlE
5`0o0BX000<10000@P0002T03@4B00030@0000<000j?5HlESaF?5HlESaF?
5AD0@04Z00030@000480000Y00d14P000`400004000=SaF?5HlESaF?5HlE
S`0E0401:P000`4000120000:@0=0A<000<100000`003QF?5HlESaF?5HlE
SaF?4`110BX000<10000@P0002X02`4D00030@0000@000hESaF?5HlESaF?
5HlESa40@P4Z00030@000480000[00T15P000`400004000=5HlESaF?5HlE
SaF?5@0A0481:P000`4000120000;0070AL000<100001@003AF?5HlESaF?
5HlESaD03`130BX000<10000@P0002l000<100006@000`400004000>SaF?
5HlESaF?5HlESaD>04<1:P000`4000120000C0000`400004000>SaF?5HlE
SaF?5HlESaD<04@1:P000`4000120000C0000`400005000=SaF?5HlESaF?
5HlES`0;04H1:@000`4000120000C@000`400004000>5HlESaF?5HlESaF?
5Hl:04H1:@000`4000120000C@000`400005000>5HlESaF?5HlESaF?5Hl8
04L1:@000`4000120000CP000`400005000>5HlESaF?5HlESaF?5Hl704L1
:@000`4000120000C`000`400005000=5HlESaF?5HlESaF?5@0604P1:@00
0`4000120000D0000`400004000>SaF?5HlESaF?5HlESaD404T1:@000`40
00120000D@000`400004000>SaF?5HlESaF?5HlESaD304T1:@000`400012
0000DP000`400004000?SaF?5HlESaF?5HlESaD004X1:@000`4000120000
D`000`400004000>SaF?5HlESaF?5HlES`1:0BT000<10000@P0005@000<1
00000`003QF?5HlESaF?5HlESaF?BP4Y00030@000480001E00030@0000<0
00hESaF?5HlESaF?5HlESdT1:@000`4000120000EP020@@000hESaF?5HlE
SaF?5HlESdT1:0000`4000120000F0000`400002000=5HlESaF?5HlESaF?
5@190BP000<10000@P0005T001810000SaF?5HlESaF?5HlESaE80BP000<1
0000@P0005X00P42000>SaF?5HlESaF?5HlESaE70BP000<10000@P0005`0
0P403`2?5HlESaF?5HlESaF?5@160BP000<10000@P0005h00`4031F?5HlE
SaF?5HlESdH1:0000`4000120000H0003QD10HlESaF?5HlESaF?A@4X0003
0@000480001Q000>5Hl10AF?5HlESaF?5Hm40BP000<10000@P00064000@1
5HlE0`4021F?5HlESaF?@`4X00030@000480001P00<100DESaF?5@020@06
SaF?5HlE@`4X00030@000480001P00<100N?5HlESaF?04T1:0000`400012
0000G`050@0=SaF?5HlESaF?5HlES`120BP000<10000@P0005l01P403HlE
SaF?5HlESaF?5Hl0@P4W00030@000480001N00P100f?5HlESaF?5HlESaF?
04419`000`4000120000G@090@0>5HlESaF?5HlESaF?5Hm00BL000<10000
@P0005d02P403QF?5HlESaF?5HlESaF??`4W00030@000480001L00`100dE
SaF?5HlESaF?5HlE03l19`000`4000120000G00<0@0>SaF?5HlESaF?5HlE
SaDn0BL000<10000@P0005/03P403XlESaF?5HlESaF?5HlE?@4W00030@00
0480001J010100j?5HlESaF?5HlESaF?5C`19`000`4000120000FP0A0@0=
SaF?5HlESaF?5HlES`0l0BL000<10000@P0005T04P403QF?5HlESaF?5HlE
SaF?>`4W00030@000480000N00n?;00C0@0>5HlESaF?5HlESaF?5Hlj0BL0
00<10000@P0001/001F?08l0S`2?08l0S`2?08l0S`2?08l0:00E0@0>5HlE
SaF?5HlESaF?5Hlj0BH000<10000@P0001P06hlT01L100dESaF?5HlESaF?
5HlE03X19P000`40001200005`007Hl0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?02<05`403XlESaF?5HlESaF?5HlE>@4V00030@000480000E022?
8@0I0@0>SaF?5HlESaF?5HlESaDh0BH000<10000@P0001<002>?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`0P01X100j?5HlESaF?5HlE
SaF?5CL19P000`40001200004P0VSad070403HlESaF?5HlESaF?5Hl0=`4V
00030@000480000A000WS`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?01`07@403QF?5HlESaF?5HlESaF?=P4V00030@000480000@
02Z?6P0N0@0>5HlESaF?5HlESaF?5Hle0BH000<10000@P0000l002^?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?01T08040
3QF?5HlESaF?5HlESaF?=04V00030@000480000>02j?5`0Q0@0=5HlESaF?
5HlESaF?5@0d0BH000<10000@P0000d002n?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`0F028100j?5HlESaF?5HlE
SaF?5C<19P000`4000120000300bSa<090403XlESaF?5HlESaF?5HlE<`4U
00030@000480000;000cS`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?01<09@403XlESaF?5HlESaF?5HlE<P4U
00030@000480000;03B?4@0W0@0=SaF?5HlESaF?5HlES`0b0BD000<10000
@P0000/003>?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?08l04P0W0@0>5HlESaF?5HlESaF?5Hla0BD000<10000
@P0000T0=hl?02T100hESaF?5HlESaF?5HlESc019@000`40001200002@00
=hl0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?08l03P0[0@0=5HlESaF?5HlESaF?5@0`0BD000<10000@P00
00T0>8l=02`100dESaF?5HlESaF?5HlE02l19@000`40001200002@00>Hl0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`0;02d100j?5HlESaF?5HlESaF?5Bh19@000`4000120000
200jS`/0;P403XlESaF?5HlESaF?5HlE;@4U00030@0004800009000iS`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?00X0<0403HlESaF?5HlESaF?5Hl0;@4U00030@0004800007
03^?2@0a0@0>5HlESaF?5HlESaF?5Hl/0BD000<10000@P0000L003^?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`09038100hESaF?5HlESaF?5HlESb`190000`4000120000
1`0lS`L0=0403QF?5HlESaF?5HlESaF?:`4T00030@0004800007000kS`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?08l0200e0@0=5HlESaF?5HlESaF?5@0[0B@000<10000@P00
00L0?8l603H100j?5HlESaF?5HlESaF?5BX190000`40001200001`00>hl0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?00H0>0403XlESaF?5HlESaF?5HlE:@4T00030@000480
000603f?1@0i0@0>SaF?5HlESaF?5HlESaDX0B@000<10000@P0000L003^?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?08l0S`0503/100f?5HlESaF?5HlESaF?02P190000`400012
00001P0mS`@0>`403QF?5HlESaF?5HlESaF?9`4@001A5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E00P00007000kS`2?08l0S`2?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0100m0@0>5HlESaF?5HlESaF?5HlV0A00055B5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E80200000L0?8l203l100hESaF?5HlESaF?
5HlESbD14000DAEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5@0800001`00>hl0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?00<0@0403AF?5HlESaF?5HlESaD0
9@4@001ADQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB00P0
000703b?00<00@40?`403XlESaF?5HlESaF?5HlE9@4?001A5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E00P00007000kS`2?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l00P120@0>SaF?5HlESaF?5HlESaDT0@l0055B5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E80200000L0>hl00`010@120@0>SaF?
5HlESaF?5HlESaDS0@l0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQD0200000L003^?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`160@0=SaF?5HlESaF?
5HlES`0S0@l0055B5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E80200000P0>Xm60@0>5HlESaF?5HlESaF?5HlR0@l0054EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQD0200000T003V?08l0S`2?08l0
S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0A`403QF?5HlESaF?5HlESaF?8@4?001ADQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB00P0000803Z?B0403QF?5HlESaF?5HlESaF?
804?001A5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E00P0
0009000hS`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?08l0S`1:0@0=5HlESaF?5HlESaF?5@0P0@l0055B5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E80200000T0>8m:0@0>
SaF?5HlESaF?5HlESaDO0@l0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQD0200000/003F?08l0S`2?08l0S`2?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`1<0@0>SaF?5HlESaF?5HlE
SaDN0@l0055B5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E80
200000/0=8m>0@0=SaF?5HlESaF?5HlES`0N0@l0054EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQD0200000/003B?08l0S`2?08l0S`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0C`403HlE
SaF?5HlESaF?5Hl07P4>001ADQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB00P0000<03:?D0403QF?5HlESaF?5HlESaF?7@4>001A5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E00P0000=000aS`2?
08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`1A0@0>5HlESaF?5HlESaF?5HlL0@h0055B5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E80200000`0<HmC0@0=5HlESaF?5HlESaF?5@0L
0@h0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQD02000
00d002n?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`1D0@0>SaF?5HlESaF?5HlESaDK0@h0055B5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E80200000h0;HmF0@0>SaF?5HlESaF?
5HlESaDJ0@h0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQD02000014002V?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?08l0S`1H0@0>SaF?5HlESaF?5HlESaDI0@h0055B5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8020000140:8mJ0@0=SaF?5HlESaF?
5HlES`0I0@h0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQD0200001<002J?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
S`2?05X100hESaF?5HlESaF?5HlESaP13P00DE8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDP0800004`0TS`03004105X100hESaF?5HlE
SaF?5HlESaL13P00DAEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5@0800005@007hl0S`2?08l0S`2?08l0S`2?08l0S`2?08l0S`2?08l0
101M0@0>5HlESaF?5HlESaF?5HlF0@h0055B5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E80200001H07Hl405l100dESaF?5HlESaF?5HlE
01L13@00DAEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5@08
00006@006Hl0S`2?08l0S`2?08l0S`2?08l0S`2?08l0101P0@0>SaF?5HlE
SaF?5HlESaDF0@d0055B5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E80200001/05Hl6064100j?5HlESaF?5HlESaF?5AD13@00DAEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5@0800007`003Hl0S`2?
08l0S`2?08l02@1S0@0>SaF?5HlESaF?5HlESaDD0@d0055B5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E80200002@00hl>06@100f?5HlE
SaF?5HlESaF?01@13@00DAEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5@080000=01U0@0>5HlESaF?5HlESaF?5HlC0@d0055B5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E80200003<0I`403QF?5HlE
SaF?5HlESaF?4P4=001A5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8E00P0000c06P100hESaF?5HlESaF?5HlESa413@00DE8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDP080000<P1Z0@0=5HlESaF?
5HlESaF?5@0A0@d0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQD020000380JP403XlESaF?5HlESaF?5HlE404=001ADQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB00P0000a06`100j?5HlESaF?
5HlESaF?5@l13@00DAEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5@080000<01^0@0>SaF?5HlESaF?5HlESaD?0@`0055B5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8020000300K`403HlESaF?5HlE
SaF?5Hl03`4<001A5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8E00P0000_070100hESaF?5HlESaF?5HlES`h13000DE8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDP080000;`1a0@0>5HlESaF?5HlE
SaF?5Hl=0@`0054EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQD0200002h0L`403AF?5HlESaF?5HlESaD03@4P00030@000480000]07D1
00dESaF?5HlESaF?5HlE00`180000`4000120000;@1e0@0>SaF?5HlESaF?
5HlESaD;0B0000<10000@P0002`0M`403XlESaF?5HlESaF?5HlE2P4P0003
0@000480000/07P100f?5HlESaF?5HlESaF?00X180000`4000120000:`1i
0@0>5HlESaF?5HlESaF?5Hl90B0000<10000@P0002X0N`403QF?5HlESaF?
5HlESaF?204P00030@000480000Z07`100hESaF?5HlESaF?5HlES`P17`00
0`4000120000:@1n0@0=5HlESaF?5HlESaF?5@080Al000<10000@P0002T0
OP403XlESaF?5HlESaF?5HlE1`4O00030@000480000X080100j?5HlESaF?
5HlESaF?5@H17`000`40001200009`220@0>SaF?5HlESaF?5HlESaD50Al0
00<10000@P0002L0P`403HlESaF?5HlESaF?5Hl01@4O00030@000480000V
08@100hESaF?5HlESaF?5HlES`@17`000`40001200009P250@0>5HlESaF?
5HlESaF?5Hl30Al000<10000@P0002D0Q`403QF?5HlESaF?5HlESaF?0P4O
00030@000480000T08T100dESaF?5HlESaF?5HlE00817`000`4000120000
90290@0?SaF?5HlESaF?5HlESaD101l000<10000@P0002<0R`403hlESaF?
5HlESaF?5HlE0@0N00030@000480000S08`100j?5HlESaF?5HlESaF?5Ah0
00<10000@P000280SP403HlESaF?5HlESaF?5Hl07P000`40001200008@2?
0@0>5HlESaF?5HlESaF?5HlM00030@000480000Q090100hESaF?5HlESaF?
5HlESa`000<10000@P000200TP403QF?5HlESaF?5HlESaF?6`000`400012
0000802C0@0=5HlESaF?5HlESaF?5@0K00030@000480000O09@100j?5HlE
SaF?5HlESaF?5AX000<10000@P0001h0UP403XlESaF?5HlESaF?5HlE6@00
0`40001200007P2G0@0=SaF?5HlESaF?5HlES`0I00030@000480000M09T1
00f?5HlESaF?5HlESaF?01P000<10000@P0001d0V@403QF?5HlESaF?5HlE
SaF?5`000`4000120000702I0@8000hESaF?5HlESaF?5HlESaH000<10000
@P0001/0T@4<000=5HlESaF?5HlESaF?5@0F00030@000480000K08T15@00
3AF?5HlESaF?5HlESaD05@000`40001200006P210Ah000j?5HlESaF?5HlE
SaF?5A@000<10000@P0001X0N04X000>SaF?5HlESaF?5HlESaDC00030@00
0480000I0741<@003HlESaF?5HlESaF?5Hl04`000`4000120000601Y0CX0
00hESaF?5HlESaF?5HlESa8000<10000@P0001P0H054000>5HlESaF?5HlE
SaF?5HlA00030@000480000G05T1C@003QF?5HlESaF?5HlESaF?40000`40
001200005`1@0EL000dESaF?5HlESaF?5HlE010000<10000@P0001H0B05P
000>SaF?5HlESaF?5HlESaD?00030@000480000E0441J@003XlESaF?5HlE
SaF?5HlE3P000`40001200005@0h0G<000j?5HlESaF?5HlESaF?5@d000<1
0000@P0001@0<05m000=SaF?5HlESaF?5HlES`0=00030@000480000D02P1
Q@003QF?5HlESaF?5HlESaF?30000`40001200004`0P0Hl000hESaF?5HlE
SaF?5HlES`/000<10000@P000180606I000>5HlESaF?5HlESaF?5Hl:0003
0@000480000B0101XP003AF?5HlESaF?5HlESaD02P000`40001200004@08
0J/000j?5HlESaF?5HlESaF?5@T000<10000@P000<D000j?5HlESaF?5HlE
SaF?5@P000<10000@P000<H000j?5HlESaF?5HlESaF?5D`00037000=SaF?
5HlESaF?5HlES`1<0000a`003QF?5HlESaF?5HlESaF?B`000<P000hESaF?
5HlESaF?5HlESdX00039000=5HlESaF?5HlESaF?5@1:0000bP003AF?5HlE
SaF?5HlESaD0B@000<X000j?5HlESaF?5HlESaF?5DP0003;000>SaF?5HlE
SaF?5HlESaE70000c0003HlESaF?5HlESaF?5Hl0A`000<d000f?5HlESaF?
5HlESaF?04H0003=000>5HlESaF?5HlESaF?5Hm50000cP003QF?5HlESaF?
5HlESaF?A0000<l000dESaF?5HlESaF?5HlE04@0003?000>SaF?5HlESaF?
5HlESaE30000d0003XlESaF?5HlESaF?5HlE@P000=4000j?5HlESaF?5HlE
SaF?5D40003B000=SaF?5HlESaF?5HlES`110000dP003QF?5HlESaF?5HlE
SaF?@0000=<000hESaF?5HlESaF?5HlEScl0003D000>5HlESaF?5HlESaF?
5Hln0000e@003AF?5HlESaF?5HlESaD0?P000=D000j?5HlESaF?5HlESaF?
5Cd0003F000<SaF?5HlESaF?5HlE?P000=L000Z?5HlESaF?5HlE?`000=P0
00N?5HlESaF?0440003H00065HlESaF?@P000=T000@ESaF?@`000001
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"IFS"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[ifs0[gr1]]; \)\)], "Input",
  CellTags->"IFS"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000[@P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcool08@000?l08@000?l08@000?l08@000?l08@0003h028lK00030@00
0;`0000k000=S`2?08l0S`2?08l0S`0H0081_P0003X048lE00<1_P0000H0
00>?5@00<0004Hl0S`2?08l0S`2?08l0S`2?01<01@6n00001@0018lESaD`
016?4P060Kh000040007SaF?5HlES`0^000AS`2?08l0S`2?08l0S`2?08l0
4@070FD000<ES`00EP0000<000V?5HlESaF?5Hl0:`0DS`l0205T00045HlE
SeH00003000:5HlESaF?5HlES``000<100006`004hl0S`2?08l0S`2?08l0
S`2?08l03P0:0F8000J?5HlESaEF00000P003AF?5HlESaF?5HlESaD02P00
0`40000K01F?2`0:0F8000R?5HlESaF?5ED00000400ESaF?5HlESaF?5HlE
SaD900030@0001/001F?08l0S`2?08l0S`2?08l0S`2?08l02P0;0F8000TE
SaF?5HlESaD0E000000B08lESaF?5HlESaF?5HlESaF?1`000`40000J01J?
200=0F<000TESaF?5HlESaD0D`000080016?5HlESaF?5HlESaF?5HlES`06
00030@0001/001F?08l0S`2?08l0S`2?08l0S`2?08l01`0>0F@000TESaF?
5HlESaD0DP0000<0016?5HlESaF?5HlESaF?5HlES`0500030@0000T01P4;
01J?1P0?0F@000V?5HlESaF?5Hl0DP0000@001:?5HlESaF?5HlESaF?5HlE
SaD300030@0000L02P4:000CS`2?08l0S`2?08l0S`2?08l0S`070101I@00
2HlESaF?5HlES`1A00001P004AF?5HlESaF?5HlESaF?5HlE008000<10000
1`0:0@T05Hl40181IP002HlESaF?5HlES`1@00001`004aF?5HlESaF?5HlE
SaF?5HlES`40200<0@T001>?08l0S`2?08l0S`2?08l0S`2?00@04`5W0009
SaF?5HlESaF?04l00009000ASaF?5HlESaF?5HlESaF?5Hl0200<0@T04hl3
01@1J00028lESaF?5HlEC`0000X0016?5HlESaF?5HlESaF?5HlES`0700`1
2@0058l0S`2?08l0S`2?08l0S`2?08l05@5Y00095HlESaF?5HlE04h0000;
000BSaF?5HlESaF?5HlESaF?5HlE1@0<0@T04hlF0F<00`4400095HlESaF?
5HlE04d0000=000A5HlESaF?5HlESaF?5HlESaD0100<0@/0012?08l0S`2?
08l0S`2?08l05`5V00D100TESaF?5HlESaD02P0=0CD0000>000B5HlESaF?
5HlESaF?5HlESaF?0P0<0@/03hlH0F/000X15HlESaF?5HlE1@040@d00P4>
00818`000100016?5HlESaF?5HlESaF?5HlES`0200X13P002hl0S`2?08l0
S`2?01X1K0002XlESaF?5HlES`4200814`030@T0104S00004@004XlESaF?
5HlESaF?5HlESaF?00X13P09S`03004101T1K@002HlESaF?5HlES`050AD0
0P4500H18`00018001>?5HlESaF?5HlESaF?5HlESaD000H150000hl00002
01`1KP002HlESaF?5Hl1S`0400D14P000`4000080B<0000D000A5HlESaF?
5HlESaF?5HlESaD07@0N0FT01P402HlESaF?0HlES`0800D13P090B@0000E
000B5HlESaF?5HlESaF?5HlESaF?6P0O0FP0204028lES`6?5HlE3@050@L0
2`4T00005`004HlESaF?5HlESaF?5HlESaF?01P07`5Y00P100TESaD15HlE
SaD04@0B0B@0000H0006SaF?5HlE2P400hl0000D0201J@080@0:01F?0HlE
SaF?5A<03`4T00006@000hl10@020@0:5HlESaF?5HlES`8100<E0000400R
0FT0204200095@4ESaF?5HlE0100404U000060020@0@01F?5HlESaF?5HlE
SaF?5@81400S0FT0204300095@4ESaF?5HlE00d05P4Q00005`000`400@02
000B5HlESaF?5HlESaF?5HlES`6?3@0T0FT020430009S`6?5HlESaF?00/0
504400D1700001H000@1000110004HlESaF?5HlESaF?5HlES`6?00X09P5Z
00H11@002Hl1SaF?5HlES`0801H12@050AL0000E00050@0000401@004HlE
SaF?5HlESaF?5HlES`6?00P09`5f00090AF?5HlESaF?00D05`4?00<15000
01@000<100000P000`400004000BSaF?5HlESaF?5HlESaF?0HlE1@0X0GL0
00T15HlESaF?5Hl00P0I0A4000<100004P0001<000<100000`000`400006
000A5HlESaF?5HlESaF?5@4ESaD00`0X0GT00P401XlESaF?5A/140000`40
000C00004P000`40000400030@0000L0018ESaF?5HlESaF?5HlE0AF?5HlY
0Ed000^?08l0S`2?08l0S`0A00095Hl10AF?5HlE01X140000`40000C0000
4P000`40000400030@0000T0016?5HlESaF?5HlES`6?5HlES`0X0EX04Hl?
00035HlE008100B?5HlE604@00030@0001@0000A00030@0000D000<10000
2P004HlESaF?5HlESaF?0HlESaF?02L1F`004Hl0S`2?08l0S`2?08l0S`2?
00h000D15HlES`030@03SaD101H140000`40000D00004@000`4000050003
0@0000/001:?5HlESaF?5HlE0AF?5HlESaDU0ET05Hl:00@100HESaF?5HlI
0@l000<100005@00010000<100001P000`40000=000A5HlESaF?5HlE0AF?
5HlESaD0905I000ES`2?08l0S`2?08l0S`2?08l0S`2?00P01P402HlESaF?
5HlES`0F0@l000<100005@00010000<100001P000`40000>000B5HlESaF?
5Hl1SaF?5HlESaF?8P5I01J?1@090@09SaF?5HlESaF?01@140000`40000E
000040000`40000600030@000100016?5HlESaD15HlESaF?5HlES`0Q0ET0
01F?08l0S`2?08l0S`2?08l0S`2?08l0100<0@09SaF?5HlESaF?01<13`00
0`40000F00003`000`40000700030@0000l00P404HlESaF?0HlESaF?5HlE
SaF?0201FP0DS`803`402HlESaF?5HlES`0B0@l000<100005P0000l000<1
00001`000`40000>00@101:?5HlE0AF?5HlESaF?5HlESaDM0E`0016?08l0
S`2?08l0S`2?08l0S`02018100V?5HlESaF?5Hl04@4>00030@0001L0000?
00030@0000L000<100003@070@0A5Hl1SaF?5HlESaF?5HlESaD0705M012?
50402AF?5HlESaF?5@0@0@l000<100005`0000l000<100001`000`40000<
00T1018E0AF?5HlESaF?5HlESaF?5HlJ0F0000^?08l0S`2?08l0S`0G0@09
5HlESaF?5HlE00l13`000`40000G00003`000`40000700030@0000X03@40
4HlESaF?5HlESaF?5HlESaF?01T1I@03S`03004101P100TESaF?5HlESaD0
3P4>00030@0001P0000>00030@0000P000<100002@0?0@0ASaF?5HlESaF?
5HlESaF?5Hl0605W01d100TESaF?5HlESaD03@4>00030@0001P0000>0003
0@0000P000<10000200A0@0BSaF?5HlESaF?5HlESaF?5HlE5P5U020100PE
SaF?5HlES``13P000`40000I00003P000`40000800030@0000H05@404AF?
5HlESaF?5HlESaF?5HlE01D1H`0R0@09SaF?5HlESaF?00/13P000`40000I
00003P000`40000800030@0000D05`404QF?5HlESaF?5HlESaF?5HlESa<1
H@0U0@09SaF?5HlESaF?00X13@000`40000J00003P000`40000800030@00
00@06P404HlESaF?5HlESaF?5HlESaF?0181G`0X0@09SaF?5HlESaF?00T1
3@000`40000J00003`000`40000700030@0000<070404HlESaF?5HlESaF?
5HlESaF?0101GP0[0@09SaF?5HlESaF?00L11P001AEB5E8E00<000<10000
6P0000l000<100001`001040000O0@0BSaF?5HlESaF?5HlESaF?5HlE3P5L
02d100TESaF?5HlESaD01`46000:DQEB5E8EDQEB5A/0000?00030@0000L0
00<100008P404AF?5HlESaF?5HlESaF?5HlE00d1FP0`0@095HlESaF?5HlE
00H11@003e8EDQEB5E8EDQEB5E8EDP0G00003`000`40000700030@0102<1
018ESaF?5HlESaF?5HlESaF?5Hl;0EL0=0402AF?5HlESaF?5@050@D001@E
DQEB5E8EDQEB5E8EDQEB5E8EDQ80000?00030@0000L0:0404HlESaF?5HlE
SaF?5HlESaF?00X1GP0^0@095HlESaF?5HlE00<11P006E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5E803@00010000<100001@0Z0@0ASaF?5HlESaF?5HlE
SaF?5Hl02@5U02P100PESaF?5HlES`<11@007U8EDQEB5E8EDQEB5E8EDQEB
5E8EDQEB5E8EDQEB5@T0000@00030@0000@0;0404XlESaF?5HlESaF?5HlE
SaF?5@L1K00Q0@09SaF?5HlESaF?00811@007QEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8EDPT0000@00030@0000<0;`404AF?5HlESaF?5HlESaF?
5HlE00H1L`0K0@0:SaF?5HlESaF?0@@001lEDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5E8EDQEB5E8E00T0000A00030@000381018ESaF?5HlESaF?5HlESaF?
5Hl40GX05@402HlESaF?5HlES`09000I5E8EDQEB5E8EDQEB5E8EDQEB5E8E
DQEB5@0:00004P0f0@0ASaF?5HlESaF?5HlESaF?5Hl00P6200l100V?5HlE
SaF?5Hl02P005`4001EB5E8EDQEB5E8EDQEB5E8EDQEB00X0000B03L101:?
5HlESaF?5HlESaF?5HlES`6900P100TESaF?5HlESaD02@000`400005000@
DQEB5E8EDQEB5E8EDQEB5@X0000@03X101:?5HlESaF?5HlESaF?5HlESaF?
008100TESaF?5HlESaD020000`40000:000:DQEB5E8EDQEB5@/0000?03d1
014ESaF?5HlESaF?5HlESaF?5@2A00095HlESaF?5HlE00L000<100003`00
1E8EDQEB00/0000>03l1018ESaF?5HlESaF?5HlESaF?5Hn@00095HlESaF?
5HlE00D000<10000800000d0@P404HlESaF?5HlESaF?5HlESaF?090000PE
SaF?5HlES`D000<10000800000/0A@404HlESaF?5HlESaF?5HlESaF?08l0
00V?5HlESaF?5Hl00`000`40000Q00002P170@0BSaF?5HlESaF?5HlESaF?
5HlESP002HlESaF?5HlES`0200030@000240000904X1014ESaF?5HlESaF?
5HlESaF?5@2>000:SaF?5HlESaF?0B@0000I00030@0003P0018ESaF?5HlE
SaF?5HlESaF?5Hn=0009SaF?5HlESaF?02@0000I00030@0003X0016?5HlE
SaF?5HlESaF?5HlES`2<00095HlESaF?5HlE02@0000I00030@0003/0016?
5HlESaF?5HlESaF?5HlES`2<00095HlESaF?5HlE02<0000I00030@0003`0
01:?5HlESaF?5HlESaF?5HlESaF;00095HlESaF?5HlE0280000I00030@00
03h0014ESaF?5HlESaF?5HlESaF?5@0E00055HlESaD0L@0021F?5HlESaF?
8P0001T000<10000;0001aEB5E8EDQD030004QF?5HlESaF?5HlESaF?5HlE
Sa<000F?5HlES`1b00065HlESaF?8`0001T000<100009@003QEB5E8EDQEB
5E8EDQEB3P004HlESaF?5HlESaF?5HlESaF?018000DESaF?5@1b0004SaF?
5BD0000I00030@0002D000iB5E8EDQEB5E8EDQEB5@l0016?5HlESaF?5HlE
SaF?5HlES`0A0005SaF?5Hl03`000`40001Q0003SaD002D0000I00030@00
02D000hEDQEB5E8EDQEB5E8EDQ00016?5HlESaF?5HlESaF?5HlES`0@0006
5HlESaF?3P000`40002900006@000`40000U000>DQEB5E8EDQEB5E8EDQDB
000?5HlESaF?5HlESaF?5HlE014000DESaF?5@0>00030@0008T0000I0003
0@0002D000hEDQEB5E8EDQEB5E8EDPl010403AF?5HlESaF?5HlESaD04P00
1HlESaF?00h000<10000R@0001T000<100009@003U8EDQEB5E8EDQEB5E8E
1P090@H000Z?5HlESaF?5HlE4`001AF?5HlE00d00P6;00006@000`40000U
000>5E8EDQEB5E8EDQEB5E860A0000V?5HlESaF?5Hl050001AF?5HlE00`0
0P6;00006@000`40000U000>DQEB5E8EDQEB5E8EDQDG0007SaF?5HlES`0E
0005SaF?5Hl01P040@800P6;00006@000`40000M00P100hEDQEB5E8EDQEB
5E8EDQT000@ESaF?5P001AF?5HlE00D000<100000P0010400@6;00006@00
0`40000D00T120003U8EDQEB5E8EDQEB5E8E6P000aF?000F0006SaF?5HlE
0`000`40000300@1R`0001T000<100002`090A4000hEDQEB5E8EDQEB5E8E
DS@000F?5HlES`0300030@0000@00`6;00006@000`40000200T16P003U8E
DQEB5E8EDQEB5E8E=0001AF?5HlE008000<100001@030H/0000I00D18`00
3QEB5E8EDQEB5E8EDQEB=0001HlESaF?008000<100001@030H/00011000>
DQEB5E8EDQEB5E8EDQDd00085HlESaF?004700<1R`00044000hEDQEB5E8E
DQEB5E8EDSD000HESaF?5@4700@1R`00044000iB5E8EDQEB5E8EDQEB5CD0
00J?5HlES`4700@1R`00044000hEDQEB5E8EDQEB5E8EDS<00P401AF?5HlE
0181Q@00044000iB5E8EDQEB5E8EDQEB5CH000DESaD15@0700@11@000`40
00230000@@003QEB5E8EDQEB5E8EDQEB=P001HlES`6?00H01@4500030@00
08<00011000>DQEB5E8EDQEB5E8EDQDf00055HlE0AD01P050@D000<10000
P`00044000hEDQEB5E8EDQEB5E8EDSH000J?5Hl1SaD500D11@000`400023
0000@@003U8EDQEB5E8EDQEB5E8E=`001HlE0AF?00D01@4500030@0008<0
0011000>5E8EDQEB5E8EDQEB5E8g00055Hl1SaD01@050@D000<10000P`00
044000iB5E8EDQEB5E8EDQEB5CL000F?5@4ES`0400H11@000`4000230000
@@003QEB5E8EDQEB5E8EDQEB>0001Hl1SaF?00<01P4500030@0008<00011
000>DQEB5E8EDQEB5E8EDQDh00055@4ESaD00`070@@000<10000P`000440
00hEDQEB5E8EDQEB5E8EDSH00P401Hl1SaF?00<01`4400030@0008<00011
000>DQEB5E8EDQEB5E8EDQDe00<100LE0AF?5Hl000P110000`4000230000
@@003QEB5E8EDQEB5E8EDQEB=@050@05SaF?5@00204400030@0008<00011
000>DQEB5E8EDQEB5E8EDQDe00@100J?0HlES`080@@000<10000P`000440
00hEDQEB5E8EDQEB5E8EDSD010401QD15HlE00P110000`4000230000@@00
1e8EDQEB5E80?@030@06S`6?5HlE204400030@0008<0002900050AF?5Hl0
204400030@0008<0002900055@4ESaD0204400030@0008<000290005S`6?
5Hl0204400030@0008<0002:00050AF?5Hl01`4400030@0008<0002:0005
5@4ESaD01`4400030@0008<0002:0005S`415Hl01`4400030@0008<0002:
00055HlE0AD01`4400030@0008<0002;00055HlE0AD01P4400030@0008<0
002;0005SaF?5Hl01P4400030@0008<0002;00055HlESaD01P4400030@00
08<0002;0006SaF?5HlE1@4400030@0008<000230003S`2?00D000H1SaF?
5Hl50@@000<10000P`0008<018l400060AF?5HlE1@4400030@0008<00023
0003S`2?00@00P401XlESaF?5@@110000`4000230000PP06S`800`401HlE
SaF?00@110000`4000230000P@001hl0S`2?08l00P030@055HlESaD01044
00030@0008<0002100N?0P030@05SaF?5Hl0104400030@0008<000210007
S`2?08l0S`0200<100HESaF?5Hl30@@000<10000P`0008401hl00`010@03
0@055HlESaD0104300030@0008<000210008S`2?08l0S`050@05SaF?5Hl0
104300030@0008<0002100N?00<00@400`401AF?5HlE00@10`000`400023
0000P@0028l0S`2?08l01P401AF?5HlE00<100/05E8EDQEB5E8EDP1n0000
P@07S`L100F?5HlES`030@0;058EDQEB5E8EDQD0OP00084000N?08l0S`2?
00L100DESaF?5@030@0;01EB5E8EDQEB5E80OP0008401hl70@06SaF?5HlE
0P402`1B5E8EDQEB5E8E07h000210007S`2?08l0S`080@05SaF?5Hl00P40
2`0EDQEB5E8EDQEB07h0002200J?20401AF?5HlE008100/0DQEB5E8EDQEB
5@1n0000P`0018l0S`090@05SaF?5Hl00P402`0EDQEB5E8EDQEB07h00023
00>?00<00@401`404QF?5HlES`40DQEB5E8EDQEB5Gh0002700X1014ESaF?
5@405E8EDQEB5E8EDP1n0000Q`0:0@0ASaF?5Hl1058EDQEB5E8EDQD0OP00
08H02`404AF?5HlE0@0EDQEB5E8EDQEB07h0002600`1010ESaF?5@1B5E8E
DQEB5E8EOP0008H0304048lESaF?01EB5E8EDQEB5E9n0000QP0<0@055HlE
SaD00`000`4000230000QP0<0@06SaF?5HlE0P000`4000230000Q@0>0@05
SaF?5Hl00P000`4000230000Q@0>0@055HlESaD00P000`4000230000Q@0>
0@05SaF?5Hl00P000`4000230000Q@0>0@085HlESaF?00650000Q00@0@07
5HlESaD00@250000Q00@0@07SaF?5Hl00@250000Q00@0@075HlESaF?0@25
0000Q00@0@0701F?5HlE0@250000Q00=0@@000J?5HlES`650000P`0;0@L0
00HESaF?5@650000P`080@X000J?5HlESaF50000P`050@h000F?5HlES`25
0000P`020A4000DESaF?5@250000UP001HlESaF?08D0002G0005SaF?5Hl0
Q00009L000DESaF?5@240000U`001HlESaF?08@0002G00065HlESaF?P`00
09P000DESaF?5@230000V0001HlESaF?08<0002H00055HlESaD0P`0009P0
00F?5HlES`230000o`0Q0000o`0Q0000
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{288, 173.812},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell["\<\
Each IFS has an invariant set, which is often a fractal. \
Approximation can be found by starting with an arbitrary initial graphic and \
nesting the IFS several times.\
\>", "Text",
  CellTags->"IFS"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[Nest[ifs0, gr1, 4]]; \)\)], "Input",
  CellTags->"IFS"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000j`P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcool08@000?l08@000?l08@000?l08@000?l08@0000h000<ESaD0o`0@
000030001HlESaF?0?l0400000/000N?5HlESaF?0?l03`0000T000XESaF?
5HlESaF?3P000`40003l00002@002XlESaF?5HlESaD=0081oP0000T000/E
SaF?5HlESaF?5@0600D100<00@40oP0000X000XESaF?5HlESaF?10020@D0
0`4300<1n00000X000^?5HlESaF?5HlES`0200030@0000@01`4200030@00
0?H0000;000<SaF?5HlESaF?5Hl11@060@D000<10000mP0000`000Z?5HlE
SaF?5Hl10P040@03004100<110000`40003g0000300031F?5HlESaF?0HlE
0@@01P4400030@000?L0000=000;5HlESaF?5@4ESaD010060@@000<10000
m`0000`00P402QF?5HlE0AF?5Hl300H11@000`40000P0003S`000=@0000<
008100b?5HlES`6?5HlES`070@D000<1000080000aF?003D00002`040@0:
SaF?5@4ESaF?5@P11@000`40000O00055HlESaD0d`0000/010402aF?5Hl1
SaF?5HlE00L110000`40000P0007SaF?5HlES`0300D1b@0000/01@402aF?
5@4ESaF?5HlE00H110000`40000O0009SaF?5HlESaF?00P1b00000/01P40
2QF?0HlESaF?5Hl60@@000<100007P0038lESaF?5HlESaF?5@H10`001Hl0
S`2?0<00000;00H100R?5Hl1SaF?5@8100>?0@400`4400030@00020000`E
SaF?5HlESaF?5Hl40@0308n?00F?1@030KP0000;00L100>?5Hl0104011F?
5Hl40@@000<100008P002hlESaF?5HlESaF?00<100H0S`2?08l300H18000
0aD0002F000030070@0:SaF?5HlESaF?5@@110000`40000S00T100DESaD1
0004S`03004100H180000aF?5@2G00003@060@0;5HlESaF?5HlESaD00`43
00090@0001EB5E8E01d00101000ESaF?5HlE0AF?5Hl02`4P00055HlESaD0
UP0001@000XESaF?5HlESaF?0P42000;DQEB5E8EDQEB5E8070004@400001
08lESaF?5@4ESaF?00/18@001AF?5HlE09D0000=0003S`0000<000d1SaF?
5HlESaF?5Hl1008000/EDQEB5E8EDQEB5@0L00050@0000400P0038lESaF?
0HlESaF?5@P18@020@055HlESaD0U00000/01Hl3008100^?5HlESaF?5HlE
S`02000;DQEB5E8EDQEB5E806`001@40000100<00P4031F?0HlESaF?5HlE
S`D18P020@03SaF?00P1SP0000T000N?08l0S`2?008010402XlESaF?5HlE
SaD2000:5E8EDQEB5E8EDQd000<1000020402hlESaF?5HlESaF?00<18`03
0@05S`6?5Hl00`420081S00000T01hl00`010@030@0A5HlESaF?5HlESaD0
DQEB5E808P0<0@0=SaF?5HlESaF?5HlE0@0S00D100@ESaF?0P070HT00009
0007S`2?08l0S`070@0=5HlESaF?5HlESaD00@0Q018100`ESaF?5HlESaF?
5HlL0007S`2?08l0S`0400@100>?0@401`6800002007S`03004100H100`E
SaF?5HlESaF?004V00030@0000D01`402hlESaF?5HlESaF?01`01Xl40@04
5HlES`L10`030HD000090006S`2?08l02@4038lESaF?5HlESaF?0BH000<1
00003@0038lESaF?5HlESaF?5AL03P401AF?5HlE00@110020HH0000800J?
2`402hlESaF?5HlESaD102D030404`1B5E8EDP0ESaF?5HlESaF?5Hl00P00
0aF?5@0E00X100DESaF?5@020@@000<10000QP0000T000>?00000P0;0@0;
5HlESaF?5HlESaD0<@001@4EDQEB00@100V?5HlESaF?5Hl00`000hlES`0J
00H100DESaF?5@0400030@0008L0000=00d100/ESaF?5HlESaF?5@0`0005
5E8EDQD01@001hlESaF?5Hl010000aF?5@0O000@0HlESaF?DQEB5E8EDQEB
5H@0000<00l100XESaF?5HlESaF?<000158EDQD800055HlESaD010000hlE
S`030Ah000J?5HlES`4200055E8EDQD0Q@0000`03@42000;SaF?5HlESaF?
5Hl0;`0011EB5E840003S`0000<000>?5@0010001AF?0@4000817P001HlE
SaF?08`0000;00/11P002hlESaF?5HlESaF?02d000@EDQEB1@000aF?0004
0003S`00008000D1S`6?00040Ah000>?5Hl0S@0000X02@4:000:SaF?5HlE
SaF?5CD000DESaF?5@07008100@E0AD00P400`01000N0003S`0008`0000:
00H13@002aF?5HlESaF?5HlE03@000N?5HlESaF?00H000@1S`6?0P400`01
002^00002@040A4000XESaF?5HlESaF?7@000hl0000;0003SaF?00D000V?
5HlESaF?5Hl00P040@035@4E008100<00@00[P0000P00P4D000:SaF?5HlE
SaF?5AH000>?5@00100018l0004:00035HlE00@000b?5HlESaF?5HlESaD4
0@06S`410@01/00001l000N?5HlESaF?01H000HESaF?004200:?0P000`40
00080003SaF?00H000/ESaF?5HlESaF?5@02S`070AF?5@6?0@04Sj`0000P
0005SaF?5Hl050020@0708lESaF?0@030004S`010@X000<ESaD00P460009
SaF?5HlESaD000:?00<1SaD00Xl01P0108l0Sj`0000P00035HlE01@01042
0004SaF?5@<10Xl00`010@0:0006SaD10@011P000hl10@040@:?0P401aF?
5AEB5E800hl400D1X`0002l000J?08l0S`050@<000DESaF?5@020@800`4:
00040Hl1S`811@020@0701F?5HlES`030@09SaF?DQEB08l000T1Y00001l0
00>?5@001P040@0308n?00B?1`4400045HlES`8100B?00412P030@03SaD1
00810`002@4000015HlES`040@055HmB5E80306U00007`002aF?5HlESaF?
5HlE00810`000hl00@080@@000B?5HlE0P4010010@4;008100PES`410040
0@<000D10000S`050@05SaF?0Hl02`4T0003SaD007l0000N000:5HlESaF?
5HlES`@100LESaF?5HlE00H11P0018l10@4200<130000aD15@020@040040
0@8000<100000`4038lES`6?5HlESaF?5@P18`0011F?5Hn000007P001hlE
SaF?5Hl00`400hlES`020@0@5HlESaF?5HlESaF?5HlES`8000DE0AD10004
0@T000B?002?10400`01000;0@0;5@4ESaF?5HlESaD01P4T0005SaF?5Hl0
O`00020000<ESaD00P407hlESaF?5Hl1SaF?5HlESaF?5HlESaF?5HlE0AF?
0Hl0104900:?00D05HlES`0A0@0;SaF?5HlESaF?5Hl00`4T008100F?5HlE
S`1n00008P0010400042008101Z?0HlESaF?5HlESaF?5HlESaF?5Hl1SaD1
5@@12@002Hl00@4ESaD00@0300d100b?5HlESaF?5HlES`460003SaF?01`0
0P401AF?5HlE07h0000Q00050@000@0020420003DQEB008E012?5HlESaF?
5Hl00AF?0HlE0`4;008100F?5Hl00@0200030@0000H01`402aF?5HlESaF?
5HlE00D000<ESaD070030@035Hl100P1M`000240204600050AEB5E802000
2HlE0@015@4ES`020@/00`401AF?5@01008000<100003@00304ESaF?5HlE
SaF?5@@000>?5Hl070040@065@4ESaD00`400`010@1e00008P030@H01040
1@1B5E8E00X000T1006?0HlES`402P040@06SaF?DQEB1`4<00:?00XESaF?
5HlESaF?0`000hlES`030A801Xl40@0600415Hl0205c000090000`400004
0@D000@EDQEB2P020@0700415HlE0@0900D100HESaDEDQD700P100DEDQEB
5@02S`0>5HlESaF?5HlESaD05Hl20@03004001<000F?08l0S`040@03SaD1
00d1L00002@00`4G00D100B?5HlE3P0018lESaD?008E00AB5E8E10402AF?
5HlESaF?5@020005SaF?5Hl00P4>00l100F?5HlES`050@D00P5^0000?P05
0@045HlES`l000>?5Hl03@002XlESe8EDQEB08l20@0801F?5HlESaD20008
0AD15HlE0@020A402`4018lESaD40@D00P5_0000?P050@04SaF?5@l000<E
SaD03@001aF?DQEB5E800hl20@<000F?5HlES`0300050AF?5Hl00P400`01
000E00H100DESaF?5@020@@00P5a0000?P060@04SaF?5@h000>?5Hl03P00
1e8EDQEB0Hl00P020@D000<ES`0010000`4E0@050A/00P4011F?5Hl25@04
DQEB5G<0000n00H100@ESaF?3P000aF?5@0>0005SaF?5Hl00P4018l10@46
00035@0000800P400hl1S`030Al000DESaF?5@020@055E8EDQD0L00003l0
00<100000P001hlESaF?5Hl07@0018lESaD20@0400410@T000>?0@400P40
0hlE00040Ad000F?5HlES`0200085Hl05E8EDQE]0000?`003040000EDXlE
SaF?5Ad000HESaF?5@040@T00Xl30@035Hl100<17`0028lESaF?5HlEL`00
03h000<100000P002E8E5HlESaF?0@0M00055@410AD0104;00<100J?0@41
004P0008SaF?5HlESaEb0000?P003@4000015E805HlESaD00P4M00040Hl1
S`@12`060@035@4E020000TES`415HlESaD0L@0003h000d10041058E08lE
01F?008170001P6?5@4ES`<12@002hl00HlES`4E0AEB02<000H1SaF?5Hma
0000?P020@<000<EDP000`0018l10@4L008100B?5@4E0`4800:?0P401QF?
5@4E0BD00P400hlE0@060F`000130003DQD000<000@E0@4170020@055Hl1
SaD00P4900<100N?5HmB5E8E01h000>?08l00`030@05S`6?5Hl01`5X0000
@`000aEB00030004S`410A`00P401@0E0AF?008120040@065HmB5E8E7P07
S`H100>?5@000P030@03004106H000130003DQD000<000@E0@4170040@05
5HlES`401`050@07SaF?5HlES`0I00P100<0S`0010400aF?0@0;0FD0000F
00030@0002X000<EDP000`0018l10@4L00090@010HlESaD100D01`401aF?
5HlESaD07@000aD10@090@045HlES`P100@00@41HP00014000>?00000P00
0`40000Z0003DP0000<000<E0@407@002@400@4ESaF?5@0500035HlE00@0
00N?5Hl0SaF?01d000>?5Hl00P080@045HlES`D11P020F00000@00>?0P02
0C8000>?0@4050000aF?000600D100DESaF?5@040005SaF?5Hl00P0021F?
5@0ESaF?70000aF?5@040@8010401HlESaF?00811P020F80000?0003S`2?
00<00P4b00035@41018000B?5HlE1`060@045HlES`8000`E01F?5HlESaF?
5Hl200035HlE00<160000`6?5@020@03004100H000H1SaF?5Hl400<1I000
00l018l010010@4b0003SaD1018000DESaF?5@0600D100h0SaF?5HlESaD0
0HlES`P100<E0@400P4H00050AD15@001@46000<SaF?5HmB5E8EDQEBH`00
00/010400hl0S`0200<1<P000aF?0@0C00045HlES`801P450007SaF?5@0E
S`02008100LE0AF?5HlE00P15P020@03S`6?00<100<00@001P001QF?5HlE
0@@000IB5E8EDQEO00001@000hlE000200D118l40BD000<ES`002P000hlE
0@0C0004SaF?5@8100<00@401P401E8E5HlE00J?00@00@0040480003SaF?
00T00`400aD10@0200030@0000H000DESaF?5@1Y000010001XlESaF?00D1
00B?08l0104S0004SaF?5@/000<ESe804`00206?5Hl1S`400`4300060AEB
0AF?30401aF?5HlESaD00`4200030@0000L000@ESaF?2@000hl10@020@03
004000L000HE01F?5HmY000010001QF?5HlES`H10Xl50B<000DESaF?5@02
00@10`02S`8E50001@6?0HlE00800`4300060E8E08lE0P0018l10@4300D1
00Z?5HlESaF?0@012P001XlESaF?5@811@000aF?5@020@03004000H000DE
SaF?5@1[00000`002AF?5HlESaF?5@050@03004100<190001QF?5HlE0@<0
1040100ESe8D00060AD15HlE1042008100<EDP00100011D10@48000?S`0E
SaF?DQEB5E8EDQEB00L010401QD1002?008100DESaD00@0900H1J@0000<0
00^?5HlESaF?5HlES`090B@000B?5HlE1`4200:?0QDD008100DE0AF?5@06
0@03058E00D000B?0@412002S`08006?5HlES`4;008100<ESaD00P40102?
Shl50@03004000T00`400hlE0@020FH00004000=SaF?5HlESaF?5Hl10006
0BD000F?5Hl1S`0200<10P000`4ES`0E00<100<E0@40104200040@0EDPD0
00@1S`412P020@065HlESaD12`002@400@2?5@4ES`060@8E00=B5@001`00
0aF?0@070@035Hl00680000600065HlESaF?0`400hlE0@050BD000H1SaD1
5Hl40@8000<1SaD060001HlESaF?00810P001040DQD30004S`015@812@03
0@07SaF?5@400@0800T100>?5Hl010425@03DQD000T000<ES`4010401001
SaD3SaP000<ESaD0A@0000L000/ESaF?0HlES`6?5@050BD00P4018l1SaD3
0@<000<15Hl050002Hl0000ESaF?5@020@035@4100D100F?5HlES`020@P0
1@400hlE0@070@L000<100400`402AF?5HlE0AF?5@0<008100>?00000P03
0@04SaF?5@:?00<100004`0018lESaE400002@002hl1SaF?5@4ESaF?00<1
9@020@045@41S`<10`000`6?5@0C00>?00L00HlESaF?010100@EShn?1006
0@045HmB5@L10hl00aD00@030@<000T15HlESaF?5Hl02`040@0308n?00@0
00UB5E8EDXlESaD00`430003S`0000P0104011F?5Hm200002@00306?5HlE
S`6?5HlES`814`000`40000?00<100HES`6?5@4300030AF?018000B?08l0
10401aF?0@4ESaD01P43008100HE0@41S`030@0401F?5@8000B?5Hl11@06
0@065HlESaF?0P402E8E5HlESaF?5@0:00810P000`4E0009008100J?5HlE
SaD20003SaF?00P00`4200<100<ES`00@00000T000h1004ESaD15HlESaF?
5A<000<100004`0011F?5Hl40@0308lE01<00Xl00`010@040@03SaD100<1
00B?5@410`070@05SaF?5Hl00P0021D1000ESaF?2`000hl00@030@0;SaF?
DP01SaF?5Hl02P050@04S`410@/000D1SaF?5@020003SaD000L01@400`2?
5@030@035@4003d00009000?0@0101F?0HlESaF?5HlE01400P400aF?000=
000=S`2?006?5HlES`4EDP025@03S`00018000J?08l0S`050@0?SaF?5HlE
Se8EDQEB5E8E00@100PESaF?5HlE0@8000<ESaD02P000hlES`040003DQEB
00@000B?5HlE2@020@800P400aF?0@0?00035@0100@12@060@055HlE0AD0
?P0000T000@100400`402QF?5HlESaF?5Hl;0004S`00008100R?5HlESaF?
00@10`05S`8100Z?5HlESe8EDXlE50000`6?0@0:0@075HlESaF?5@030003
5Hl100L100DESaF?5@020003SaF?00/000>?5@006@020@8000>?5Hl04003
0@03006?00>?2@020@030041008100>?5Hl0?00000T000@100400`402hlE
SaF?5HlESaF?00X000B?00000P4031F?5HlESaF?5HlES`8000F?08l0S`04
0@06SaF?5@015P050@D000B?5HlE0P001HlESaF?00<000>?5@001@001aEB
002?5@400P000aF?5@0;00035HlE00X000>?5@003P001E8E08lE00d02040
0aD10@020@X00`401@2?5HlE00:?00<0S`00=`0000T000<100401P402aF?
5HlESaF?5HlE00L00hl03@010@6?5HlESaF?5Hl00P400aF?5@04S`D100HE
SaF?5@4P00055HlESaD00`001QF?5@2?0@8E2P000`6?0@0?00<100>?0000
2@030@0308l000<000<100000`001e8E004ESaD020000`4E000300H100>?
5@403`030@065HlESaD10Xlf00002@000`400@070@0;5HlESaF?5HlESaD0
1@000hl0S`0200<100D0SaF?5@040@09SaD10HlESaF?00H100DESaF?5@0Q
00045HlES`P000<1Se802P000`4E0@0200035@0000X00P400hl1S`090081
00<00@000`400`0E0@0:00035@0E00L000<1S`000P040@<000<ES`002`00
3P6?001B5E8EDXlESaF?1@4b00002@000`400@080@0:08lESaF?5HlES`D0
18l010010@4300<100/05HlESaD15HlES`070@06SaF?5HlE1@000aD0000H
0003SaD000P000B?0ADE2P000`6?0@0300035@4000T010400aF?S`0600H1
00B?5@000Xl40003S`0000@00`4400:?00@00@4110001aEB0@6?5Hl02P05
0@D000H1SaF?5Hl70Bl0000:00P11@001QF?5HlES`<00`4018l0S`040@80
00D1000100060@04SaF?5@@100V?5HlESaF?5Hl0100011F?5@020AL000>?
000020000`6?5@0:00030AD100<00`4900@10Xl800H100J?5@0100430081
1@030@H01@400`1B5@050003S`2?00P000F?004100020@H000J?5HlESaDd
00002P060@@000YB5@015HlESaD01P43S`@10P000`40000:0@0@0041SaF?
5HlESaF?5HlES`@000<E0@40104D0008SaF?5HlE0@03S`<100>?00002000
0aD10@0300@100>?00001P030@035Hl1008120000aD0000200<110020@D0
0P47008100B?0@4120030@L00P400hl10@030@L000@ESaF?=00000X01045
0004DQEB0@8000DESaF?5@060@0308l100@10P070@L000AB5E8E0P002AF?
5HlESaF?5@0300030Hl100D15@000hl10@040@035@0E00<100<E00002000
0hl10@0300@100>?0@4020001@6?5Hl100d01044008110000`6?0@080003
0AD000<11P040@T000@E00412P000aF?5@0d00002@040@L000=B5@000P00
1XlESaF?5@`110000`40000800050AEB5E800P4500035Hl000D00P401AD1
0@0101H010402Xl1SaF?5HlESaD900035Hl100<00P4200075Hl101D1S`05
00030HlE00h00P401Xl0002?5@810`020@035@0000P000>?DP001P02S`81
2`0018l15E8@00030AD002h0000900040@000@H000<15E800P002HlESaF?
5HlES`0;0@<000@100001`401@1B5E8E010010400`01000C00/100J?5HlE
SaD80003SaF?00<000>?00400`4018l0S`46008E00>?5@0030020@035@00
008100>?0@000P020@035@4000T000<E00001@020@035@0001h01@4]0000
30000`40000300040@1B5@8000/ESaF?5HlESaF?5@090@<0104800035E8E
014000<15Hl00P4H00H100MB5@005HlE00H000J?0000SaD300095@400580
0HlE00810`025@04DP2?S``00`401hl00001DP401@000hl0000?00<100<E
00007002S`030AD100D1:`0000`000@100000P4200035E80008000/ESaF?
5HlES`6?5@080B4000R?0@6?5@5B5Ad000LEDP00SaF?00D000>?5Hl00P02
5@<000>?0@001@030@8000PESaD1S`01S`/000D1000ES`030003S`0001P0
00<E0000800018l000040BX0000<00040@000@@000=B5@0010001hlESaF?
0Hl00P400aF?0@050B0000>?0@400P400hlE0@0S0003S`0000D000J?5Hn?
0E8300811P030@<000HES`6?0Hl<00<100>?0@000P000aD0000j0006S`41
0AEB;@0000`00`4500035E8000D000^?5HlE0AF?0HlES`050B001@400aF?
0@0Q00035@00008100<00@400P001QF?5@015@<00P4600<10`001Hl10@01
00<000>?00002P020E`000<E0000500000`000<100001@000e8E0007000;
5@4ESaF?0HlESaD00`4Q0007S`0008lES`04008100<00@400`4D00035HlE
00@100<00@000P040@045@0000<11@030@@0104200<11P000aD000020081
E@02S`<000@15HlE5@0001@000<EDP0020002`6?5HlE0AF?5HlE00818000
1hlESaF?5Hl0204300030@0001@000@E0AD00P402P010001S`6?0Hl300<1
10020@095@4008l15@4E00<000<1S`401@000`6?00020081F0000`6?0002
0@035HlE01@0000D0003DP0000L00P40302?5Hl1SaF?5HlESb0000D1SaF?
5@070@0;5HlESe8EDQEB5E804@030@03SaD1008000<100000`400aD15@03
008100<E00000P00104001D200@100B?002?0`440004S`010@800P5J00<1
00<00@400P4B00007P003`400@2?5@4ESaF?5HlES`050003SaF?01`01040
2QF?5HlESaF?5Hl4000?S`0101F?5HlESaF?5HlE00<01@4200030@0000<1
00>?5Hl00`020@03S`00008000@1002?0P030@03SaF?008100<E0@001@00
1Xl10@40Seh01`4@00007P0010400@030@0:SaF?5HlESaF?5@<000DESaD0
0@0D00B?104900035Hl100L100HE0E8EDP4;00060AF?DQEB0P030@035HlE
00<00P401AD0000E00<100<ES`0010401XlE006?DPL00`400hl1001O0003
0AD100@13P0001h000@100400`402aF?5HlESaF?5HlE008000>?5Hl00P4:
00030@0000815`000aD15@060@l000N?006?5Hl100<00`400hlES`030003
0@2?00<000>?00000P002`400@4E01F?5@0E00T00P400aD1001P0003SaF?
00D1300001h000@100401@403XlESaF?5HlESaF?08lE0P40100ESaD300H1
00<00@005P0018lESaD2S`03004100X000@100000Xl30@03SaF?00<01040
0hlE000300030@2?008000<E0@000P020@06006?DP4E0P000hl000080003
5Hl1068000>?5Hl01P4:00007P000`400@070@0=SaF?5HlESaF?5HlES`02
0@06004ESaF?1P4300030@0001H000@E0@6?0`4:00030@0000<00P420003
SaF?00<000H101DESaD30003DP0E008000>?0AD00P050A0000B?5@41HP00
1Xl0000EDP@1200001l02P40300ESaF?5HlESaF?5@@100N?5HlE0AD000@1
0P000`40000300045HlES`@100B?0@4120001P6?0HlE0@X000<100000P00
0`4000030003S`0000800P400e805@0400035@6?008000<E0@400P030@03
01D000l000<ESe80J@000e8E000900007`000`400@060@@000^?5HlESaD0
5Hl1S`020@0408lES`8100<ES`400P4300030@0000D01P4021F?5HlESaF?
0P020@055@4ESaD01P000hlES`020@03004000/000B?0@4E1P001U8008l1
S`810P000`40000E0003DP0006P000<EDP001`0001l01`4300095E8008lE
SaF?008000<E0AD00P4300035Hl1008100V?5@415E8EDQD01@080@03058E
00D00P401P01SaF?5@D000<ESaD0104700035@41008100B?5HlE1P002aD0
00400Hl101D108`0000P00D10`000aEB5@020@8000<ES`000P000hl1S`02
0@@000/101F?5HlESaD00@0G00D100B?5HlE10000hlES`040@P010401581
01D8008100L00AD108l108`0000P00<11P000aEB000800035@4E00810P03
S`0;0041SaF?5HlES`405P060@05SaF?5Hl00P000aF?5@040@T00P490003
S`2?008000P1000EDP0E0H`0000O00<11`000e8E000700<100R?0@0108l0
S`D100LESaF?5HlE01D010430004SaF?5@<000<ES`400`4A00:?00@05@0E
0P000`4000025@0308l008`0000O00030@0100H000<15E802@020@045@40
0@8000>?004010420005SaF?5Hl020020@d000T1001B5@6?5Hl00`000hlE
0@030A800P401Xl00@400@8000B?DP0ES@00024000<100000`001@40DQEB
00T000DE0@400@0400811`000aF?5@02008100<0S`000`4=00050@000E80
1`000aF?0@030A400P400hlE00020@0308l000@000>?0000R`00028000<1
00000P4200035E8E00T000F?0@4E0@0A00D100LESaF?5HlE00X00`400`0E
000700035@4E00814@020@035@41008100<05@00TP00028000<100401000
0e8EDP0:0004SaF?0@l000@E0@6?0P4011D1DQD>00050@00058020000hl1
S`020@@000>?00002P030@065@410@2?T`0002800P4500035E8E00X000@E
SaD140050AH000<E00001@000`4E0@030@800P400hl1000;00H100<05@00
TP00028000<1000010000e8EDP0900:?00@ESe8E<`0028l10AD1DP0E0`4<
00080@010@2?0HnC0000:@000aEB00090003S`6?008E00=B0000<P001Hl1
S`0E00800`4>008100@05@0ET`0003D000J?0AF?DQDd00065HlE5E800`40
0hlE000<008100<0S`00U00003D000>?0Hl00QD00e80000b0006SaF?DQD0
0`4200035@0000X00`400aD0002C0000=@001Xl10HlES`h000<100008`00
1AF?5AEB00800P400`01000<008100<0S`00U00003D000J?0@4ESaD;0003
S`0000818`001Xl05HmB0@<00P4>008100<05@00U00003H00P400hlES`08
00065@4008l00P4U0004SaF?0@<000<100003@00106?08nE0000=P020@04
5HlES`H000LESaF?5Hl000<18P001Xl05HlE0A<000@15@0EU@0003H00`40
0aF?5@0700035HlE00<100@ESaD18`00104ESaDC00030Hl009H0000f00<1
00>?5Hl02P002P6?5@4ESaF?5HlN0006S`01SaF?3`00104000030IH0000f
008100@05HlE2P020@0900415HlESaF?01l000@15HlE3`001`400001S`40
UP0003H000L100005HlE00H000@100000`420004DQD0Sb0000D1SaF?5@0>
00030@00008000<E0@00U@0003X000>?5Hl00P050@D000H10040DQDQ0081
00>?5Hl03P000`4000020003S`4009D0000j00035HlE00@10P000`400004
00050@0005808@001@405HlE00d00P4400035@4009D0000g00035HlE0080
1@4200030@0002X000D108lES`0=0003S`4000<000>?0@00U@0003L000B?
5HlE0P4010010@4200030E8E03`000<E0@000`000aD1002E0000=`001aF?
5Hl1SaD00`40100EDQDm0003S`4000@000<E0000U00003P000D1SaD15@02
0@05SaD0DQD0<@000hl0000:00811002SiH0000h00H100J?5HlES`490003
0@0002D000>?0@002P020@D000<E0000U00003T01@401aF?5HlESaD01P00
1Hl10AF?02@00`4;00811002SiH0000j00030@0100<100F?5HlES`040006
S`0ESaD190001QD10HlES`T00P4500035@0009@0000h00>?1@4200035HlE
00800`425@03DP0002D00`400`01000800811@000hl0002D0000>@000hl0
0@020@L000<E0@400`4Y008100<E0@002@020@D000<E0000U00003P000>?
00400P460003SaD100<1:`020@03DP0000T00P400aD000020003S`0009@0
000j00030@0000L00`4]008100<E00002@020@03S`00008000<E0000U000
03T000<10000>0020@`00P400aD000020003S`0009@0001d00030@0000/0
0`6K0000=@000`40001;00035@4009X0000^0003SaD000D1C@000e81002J
0000;0001aF?5Hl00@000P400`01001;00035@0009X0000/0007SaF?5Hl1
00020@03004004/000=B0000VP0002d000J?5HlE0@020@03004000T000<1
0000?`000aD0002J0000;@0011F?5Hl60@X000<10000?`000e80002J0000
;P001QF?5@4E008100<00@001P0018l00@5000035@0009X0000_00055Hl1
S`000P400`0100060004S`410Md0000_0005SaF?0Hl00P400`01000400L1
g000030000R?5@4ES`400@8000B?5HlE0`401AF?5HlE0=X0000`00065Hl1
SaD10P003P40DXlE0AF?0HlESaF?;@000`40002Z0000<0001@4ES`6?0081
00@00E8E0P050@035E8002h000<10000ZP0003000P402AD10Hl1004EDP03
00<100@00AEB;@000hl1002[0000<0020@09SaD15Hl05E8E00@00`4a0003
0@000:X0000c0008SaF?5Hl05E8500030@0002l000>?0@00Z`0003@000N?
5HlE058E03P000<10000ZP0003@000@ESaF?0QDg00030Hl10:`0000e0006
5HlESaD1=P000aD00@2/0000<P02S`0708lESaF?0@0e00035HlE0081Z`00
03<000R?006?5HlEScH000@ES`41Z`0003800Xl01`010HlESaD0=P0018l1
0@6[0000<`002Hl00@4ESaF?5@0f00<1Z`0003<00Xl30@055HlESaD0=@03
0J/0000c0003S`0000<100@ESaF?=@020@03S`000:T0000f00<100F?5HlE
S`0500030@0002`00P400aD0002Y0000=P020@8000B?5HlE1@000`40000/
008100>?5@00Z@0003H00P4200035Hl000@000>?0040;P020@035Hl00:T0
000f00812@000hl10@0^008100>?5Hl0Z@0003H000<100001`001Xl00@40
Sb`00`400hl0002X0000=P000`40000900050AF?5Hl0;0000`4E0@2Z0000
=P000`40000500@100@ESaF?;@000`400@2Z0000?@000aF?0@020@03S`41
02h000<10040ZP0003`000DESaD100020@03004002h000<10000Z@0003d0
00LE00400@1B030000<10000Z@0003l00`400`01000_00030@000:T0000o
008100<00@00<0000`40002Y0000@0030Md0001100030@000=`0003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o
0240003o0240003o0240003o0240003o0240003o0240001100030@000=`0
001100030@000=`000100003S`400=d0001200030@000=/000110003S`40
0=`000110003S`400=`0000o008100>?0@40g00003h000>?5Hl00`7L0000
?P001QF?5Hl00M`0000n0003SaF?00@1f`00040000DE0@6?5@3K0000@@00
1@6?0HlE0=X00012008100<ESaD0f@00048000H15@4ESaGH0000@P002040
0HlESaF?eP000480104018lESaGF0000@`030@0408lESmH0001300<100<0
DP40e`0004<00`400e8E0@3G0000A0020@03058E0=L0001500040@0ED]L0
001500040@015ML00016008100=B5@00e@0004H00P400aEB003E0000A`00
0`405@3F0000A`000`40DP3F0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000
o`0Q0000o`0Q0000
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{288, 235.312},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"IFS"]
}, Open  ]],

Cell["The Chaos Game", "Section",
  CellTags->"ChaosGame"],

Cell[BoxData[
    \(Needs["ProgrammingInMathematica`ChaosGame`"]\)], "Input",
  CellTags->"ChaosGame"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?ChaosGame\)\)], "Input",
  CellTags->"ChaosGame"],

Cell[BoxData[
    \("ChaosGame[-ifs-, n, opts..] iterates random maps applied to a point n \
times and plots the result."\)], "Print",
  CellTags->"ChaosGame"]
}, Open  ]],

Cell["Options", "Subsection",
  CellTags->"ChaosGame"],

Cell["Coloring", "Subsubsection",
  CellTags->{"ChaosGame", "Coloring"}],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Coloring\)\)], "Input",
  CellTags->{"ChaosGame", "Coloring"}],

Cell[BoxData[
    \("Coloring -> val is an option of ChaosGame. Possible values are None, \
Automatic, a list of color directives, or a function of two arguments such \
that val[i, n] is the color of the ith out of n objects."\)], "Print",
  CellTags->{"ChaosGame", "Coloring"}]
}, Open  ]],

Cell[TextData[{
  "Possible values for the ",
  StyleBox["Coloring", "Input"],
  " option:"
}], "Text",
  CellTags->{"ChaosGame", "Coloring"}],

Cell[BoxData[GridBox[{
        {
          StyleBox["Value",
            FontFamily->"Times",
            FontWeight->"Bold"], 
          StyleBox["Description",
            FontFamily->"Times",
            FontWeight->"Bold"]},
        {
          StyleBox["None",
            "Input"], 
          StyleBox[\("no plot style applied"\),
            "Text",
            ShowStringCharacters->False]},
        {
          StyleBox["Automatic",
            "Input"], 
          StyleBox[\("use different hues"\),
            "Text",
            ShowStringCharacters->False]},
        {
          RowBox[{"{", 
            RowBox[{
              SubscriptBox[
                StyleBox["style",
                  FontSlant->"Italic"], "1"], ",", "...", 
              RowBox[{",", 
                SubscriptBox[
                  StyleBox["style",
                    FontSlant->"Italic"], "n"]}]}], "}"}], 
          StyleBox[\("styles to use in turn"\),
            "Text",
            ShowStringCharacters->False]},
        {
          StyleBox["f",
            FontSlant->"Italic"], 
          StyleBox[\("a function of two variables."\),
            "Text",
            ShowStringCharacters->False]}
        },
      GridFrame->True,
      RowLines->True,
      ColumnLines->True]], "Text",
  CellTags->{"ChaosGame", "Coloring"}],

Cell["Examples", "Subsection",
  CellTags->"ChaosGame"],

Cell[BoxData[
    \(Needs["ProgrammingInMathematica`ChaosGame`"]\)], "Input",
  CellTags->"ChaosGame"],

Cell["Here is again the sample ifs from the previous section.", "Text",
  CellTags->"ChaosGame"],

Cell[BoxData[
    \(\(ifs0\  = \ 
      IFS[{\n\ \ \ \ scale[0.3, \ 0.8], \n\ \ \ \ 
          AffineMap[0.2, \ 0.4, \ 0.9, \ 0.5, \ 2, \ \(-2\)], \n\ \ \ \ 
          AffineMap[{x, \ y}, \ {0.9 y\  - \ 2, \ x\  - \ 0.1 y\  - \ 2}]\n
          \ \ }]; \)\)], "Input",
  CellTags->"ChaosGame"],

Cell["Here we iterate 2000 times.", "Text",
  CellTags->"ChaosGame"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ChaosGame[\ ifs0, \ 2000\ ]; \)\)], "Input",
  CellTags->"ChaosGame"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004Q000110P10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcool08P000?l08P000?l08P000?l08P000?l08P000?l08P0007`00P6S
0000O@000`40002Q0000o`0R0000o`0R0000o`0R0000o`0R0000o`0R0000
o`0R0000o`0R0000o`0R0000>`020N@0000l00030@0000`00P7D0000C000
0`40000^0081XP0007h000<10000X0000?l08P000?l08P000?l08P0007/0
0P6T0000O0000`40002R0000o`0R0000NP020JD0001k00030@000:<0001U
00810P020KH0001V00050@000040]P000?l08P0007@00P6[0000?`020C@0
00<10000Z@0003P00P4600030@0000<00P440081d`0003T000<100002`00
0`40000300030@0003X00P6E0000KP020A/000<10000T`0004d00P4P0003
0@000:l0001>00030@0002<00P6[0000K0020@L000<10000Z@0006d000<1
0000/@0005400P7>0000@@020@l000<100005@020KD0001200030@0001D0
0P4?00030@0000T00P6X0000F0020@03004001/000<100009@020Gl0000E
0081@P000`40000b00814@000`40001m00005P000`40000o0081=@000`40
002?0000F@020@d00P6g0000FP000`40000<00030@000;D0001B0081=002
0IL000050081C0000`40000B008100<00@404@020@T000<1000030020HL0
000600030@0006000P400`01000A00040@0000815000104000020H800013
00819@000`40000G00030@0001L000<10000P00004@000<10000fP0002D0
0P4H00812`040AP00P6g00009P000`40000800813@000`40000:00030@01
01T000<100003@020JH0000b00030@0002T00P4800@10`020@D00P420003
0@000:@0000g00819P000`40000700030@0100@000<1000010000`400002
008140020@l00P420081O00003P000<100009P020AX000<100001@020@P0
00<100001`020@D000D100000@0400<1M@0004400P4;00814P000`40000;
008100<00@404@000`40000A00030@0000d00P5e0000@P000`40000:0003
0@0001l000<100000`4@00819P020G00001J008140020@800`4300030@00
00@00P4200H100<00@004@020A<000<10000KP0005/000<1000010020@<0
0P4400040@0000810P020@800P4300030@00008100@00@013`020@@00`62
00009P020C/000L10041004000810`020@D000D100000@0200810`000`40
000300813@000`40000400030@0000812@020G<0000W00030@0002P00P4B
00030@00008000<100000P00104000020@P000<100000`020@<000<10000
30020@P000<100001@020@0300400780001500812@020@03004000800P40
0`010@020@03004100H00P4<00030@0000T00P4200030@0000H00P490003
0@0000l000<10000L`0001@00P400`010@0]00030@0000P000<100001000
1P4000400@800`401`010@400@000P4C00@11P020@@000<100003`020Gh0
000E00040@000CL00P4@00030@0000@10P000`40000B008100<00@401002
0AL000<100003P020F`0000`00817`000`40000<00811P000`4000030081
0P040@P00P401@01000100D01@4F00813@000`40001Z0000<@000`40000Q
00812@020@X00P400`01000200030@0100T000<100000P020@@00`400`01
0004008140000`40001h0000=`020AD00P4600030@0000P000<100000`02
0@@00`4600812P020@03004000@000<100001`001@400@4000818P020F40
000h00030@0000814P000`40000B00<100<00@001@000`40000500030@00
00T000<100004P001040004S00030@0005l0000l00030@0001L00P4=0081
00<00@401@020@800P4200817P020HP0000a00814`040@/00`4>00040@00
0@H000D100000@0300<13P020@d000<10000QP00038000<100004P000`40
0@0<00030@0000P00P4B00810P020@H00P4500<12@020@03004108P0001R
00811@020@X00P4600810`000`40000400030@0000811`000`400@020A00
0P5e0000CP020@800P4500811`020@<00P4010010@4700@110030@X00P42
00030@0000<00P43008100<00@403P000`4000020G40000P0081;@020@80
00<100000P4200030@00008110000`4000040@03004100P000<100401@00
0`40000:00040@010@<00P40100100040@03004000813`000`40001_0000
70020@<000<10000;0000`40000400030@0000@000<100001P030@800`4<
00813@040@<0104300030@0100810P030Gl0000M00030@0002`00P4G0081
0P00104000020@<00P4800@12`020@D000<100400`020@8000<100000P00
0`40001m0000?`020@`000<100005P030@<00P4500030@0000P00P4400@1
1`050@D000<100001`020A/00P5O0000<0020@h000<100007P020@<00`42
00<13`040@@000@100410P030@80104@00030@00008100<00@4010020@@0
0P4900030@0005d0000a00030@0000810`020@@00P4H00811@030@800`44
008140030@L000<100000`4500030@00018000@100011@000`4000030003
0@0006L0000e00030@0000800P4400030@0001L000<1000010030@801049
00810P020@@00P4200812@00104000020@04004100810P020@<00P4?0081
K`0002X00P45008120000`40000=00813P020@H000<100000P400`010009
00050@0000401@020@8000@100412`020@05004000400`001@400@400081
2@020@@000<1000030020El0000[00030@0000810P000`40000;00810P02
0@H000<1000010020@@010400`010@0700030@0000800P4>008100<00@00
0P040@@00P42008100<00@0020030@800P4800811@020@d000<10000G@00
02l000@100412P020@03004100<000<100001@020@D000<100000`020@<0
00<100002`000`40000600811@000`40000400030@0100810`000`400@07
0@L000<100000P000`40000700030@0000@000<100003@020E`0000b0003
0@0000T000@1000130000`40000C00<140000`40000300<10`020@<000<1
00000P4200<100@00@0160020A@000<10000FP0003X00P4200814@040@D0
0P4900811@020@03004100d00P401@010@0100D00`4R00030@0000L00P40
0`010@1S0000<P020@L000D100000@0B00030@0100H000<100003`000`40
00020@800P4900040@000@D00P4010010@030@03004100<00P4;00815000
1040004@0081D@0003<000<100000`020Ah01@4400<12`020@<000<10000
2P040@<000@100010P050@@00`4800@10`020@<0104800814P000`40001?
000040020BP00P43008150020@800P400`010@0500@12P000`4000020@03
004100<0104300050@010@000`4700030@0000810P020@H00P4010010044
00030@0000800`42008110020F@0000A00030@0001801047008120000`40
000200040@010A8000D100000@0200811`000`4000060081100010400042
00<100<00@001@000`4000020@D00P4400030@0000811`030@<00P4500<1
00@00@400P44008100<00@40H00002L000<1004010020@8000<100001`02
0@D000<100004`020@<000<100001P020@L000<100000P020@D00P4500H1
10020@03004100P000<100001`000`40000200030@0000@000D100000@02
00030@0000<000@10001H00001`00P4500812P000`40000200811`000`40
000J00030@0000L00P4200030@0000H010400`01000500040@010@801040
0`01000300810P020@03004100810`020@<00P4P0081G@0001d000<10000
10000`40000>00030@0001000P4=00<100@00@40104300030@0000800P46
00@10P020@D00P4300<11`000`4000020@8000<1004010000`4000020003
0@0000@00P4010010@020@03004101000`4H0081@@0003<00P400`010@0>
008100<00@003@020@8000D1000100040@H000<100000P020@0400410@<0
00<1000010000`400002008100<00@400P020@800`4400810P020@`000@1
00010P001040004B00030@0001L000<10000?`0003@000@100013`000`40
000I00810P020@<00P4300@10`030@@0104300030@0100T100<00@400P40
0`010@030@@0104500811@020@h00`470081E00002P00P4R00813`020@T0
00<100000P000`40000300810P040@@0104500@100<00@40204200<10P07
0@H000<100000P4200030@0000d00P4800040@000081C`0002T000<10000
4@020@800P49008140030A<000<100000`43008100<00@400P400`010@02
00030@0100800P401@010@0100800P46008100<00@000P030@@01@430081
0`020A@00P5?0000;@020@@00P4900050@0000401`020@03004000<00P40
0`010@0700<12@020@L00P43008110001P400@400@800P4200<10P000`40
00050@0500410@000P400`010@030@<00P400`010@0200040@000@801@42
00030@0000H00P4;00030@0000X00P510000;P000`40000300030@0000<0
0P4?00030@0000D000<100000`4400<10P020@L000<100001P040@<01042
00<10`00104000040@<00P400`010@0200D100<00@401@44008100<00@40
0`050@03004000812@000`4000020@<00P4@00030@0003l0000c00811P00
0`40000:00811@020@03004100@000<100000`000`40000200030@0000<0
0P400`010@0200<10`030@<000<1004010000`400004008100<00@400P42
00@100<00@40104200040@0100810P080@800`400`010@0300030@0000/0
00<100000P020@h00P510000;P040@8000<100000`020@L00P4300810`02
0@03004100812P020@X00P400`01000200@10`020@<00P400`010@0700P1
00<00@400`4200D10P020@D01`401@010@4000<100@00@40104?00@13P00
0`40000o0000;`000`400@0900030@0000800P4200030@00008000@10000
0P4200030@0100@11P030@L00P400`0100020@@00P4400030@0000H100@0
0@400`400`010@020@03004100@11`060@03004100<00P400`010@030@03
004100H10P000`400@0900811@0010400@020@@00P570000:0020AL000<1
00002P000`40000400030@0100<00P42008120000`40000200040@010@@0
1P400`010@040@03004100T100<00@402@4300030@01008100<00@001042
00T10P020@800P44008100<00@400P000`40000300810`000`4000020081
A`0001800P4E00030@0002/01040100100040@03004100<00P43008100<0
0@000P030@0400410@800`400`010@0;0@03004100@100D00@400@030081
0P000`40000200`100<00@400`4300030@0000<000<100000`4300810P00
0`40000600@1A@0001<000<10000?@020@<000@1004110030@800`420003
0@00008000<1000010030@03004100D10P090@03004100X100<00@400P40
0`010@0300d100@00@001045008110040@@000<100000P020@H000<10040
A@0003`00P4A00810P020@D00`4500030@0000<12@030@<00`401P010@40
0@H0104300D100<00@001`401@01000100@000H100400@080@80104400<1
10060@@01@420081BP0003X00P400`0100030@h000D100000@03008100<0
0@402@000`40000600L10P020@0500410@0010400`010@02008110020@03
004100l11P020@8020400`010@060@0400410@<01P4200@100@00@410P00
0`4000180000>P020@04004100@11`040@@00P4400040@0000<110050@@0
1@401001004600810P030@8000<100003`400`010@030@03004100H10`0;
0@0500410@00104300030@0000<100<00@400P4200810P030@03004104X0
000Y0081400010400@4400030@0000H01@4300030@0000D0104500040@01
0@<01@4900D10P000`40000300<100@00@403P4010010@42008100<00@00
0P400`010@090@0400410@800P4300<100<00@000P060@03004100810`00
0`40001800003P020AX000<100001P020@T000<100003`000`40000:0003
0@0000H00P4300<100<00@000P45008100<00@401P400`010@0200050@01
0@001P401@01004000L100@00@410P040@8000<1000020400`010@020081
00@00@400P400`010@0300X11`020@`00`4f00003`000`40000R00030@00
01P00P4:00812P00104000030@@00`4400040@0000@100@00@000`400`01
0@080@03004100<02P4200<100<00@400`401@010@4000<10P030@030040
008100<00@40104200H100<00@400P4200810`000`400008008100<00@40
2`020BT0000a00<13@020@d000<100000P4300810P00104000020@L01040
0`010@0300H11P000`4000040@04004000`10P050@03004100@10P020@80
1042008120000`4000070@03004100<01042008100<00@400P000`400002
00@11`000`40000=00030@0002L0000b00813P0010400@4>00<10P000`40
000300<10`020@<00P4300030@0000@0104700D100<00@400P400`010@0:
0@03004100810P050@<000<10000204<00<100<00@003@001@4000400081
1@030AD00P4Z0000=@020@d00P4500812@000`400004008100<00@000`02
0@X02@400`010@02008100<00@0010050@<01P400`0100040@801P4200D1
00H00@01004;00@100<00@404@030@800P4400810P020@03004100D00P46
00030@0002P0000/008120000`40000<00030@0000810P000`4000040081
10020@<000<1000010400`01000:00<100@00@410P040@03004100<100@0
0@4010400`010@080@8000<100400P400`010@050@03004100@140000`40
0@0200030@0001000P4300<10`030@05004000401P000`40000_0000;@00
0`40000I00030@0000P000<1004010400`010@0400030@0100P020420003
0@00008000<100400`000`400@030@<000@100002P4010010@030@040041
00L10P000`40000G00D14@000`4000020@03004000@1>00004d00P4800<1
0`020@800P4600@100D00@0100040@L00`4600030@0101<10P080@8000<1
00407@020@03004001000P4200030@0000800`4h0000B0020@@000<10000
0`4010010@040@801@400`010@050@03004000D00`4800<10`020@<000<1
0040404200<100<00@401@400`010@0b00030@000400001900030@000080
1P4200030@0000D10P030@8000D100400@03008110020@@00P4400810P03
0@800P4300030@0100L100@00@411000104000040@0500400040?P020@@0
104]0000>0020AD000<1004020001040004300030@0000L0104500811002
0@H00`400`010@020@03004100h10P030@H01P460081=`000`4000030003
0@0102d0000b00811@000`40000H00<110020@T0104200<10`020@030040
00@000@100001P4200<100D00@4100040@03004100@110020@H00`400`01
0@0300810P000`4000150081900003401@4M00D10P030@<00P400`010@05
0@0500410@000P4200030@0000P01P4300810`000`40000;0@H00P4500D1
10000`40001000@11@000`40000R0000<P001040004@00811`020@<000@1
00010`030@0500410@002P4300040@0000811`040@03004100810P000`40
0@030@03004100L12@020@D000@1004110020D8000<100402@020Al00016
008120030@800`4200@10P020@801P400`010@0800030@0000@00`400`01
0@020@03004000@000<100401@4300812P0010400@4;00030@0004d000<1
00000P020AT0000c00813P020@8000D1004100040@8000@100000P4300@1
0P020@800`400`010002008100<00@400P400`010@0600<100<00@401P02
0@03004100X13@000`40001O00030@0001L0000a008100<00@003P000`40
00020@04004100@13@070@8000@10000104200030@0100<120001@400@40
00@10P001@40004000D100<00@400P5X00817P00038000<100002@020@P0
00<100000`4200030@0000812`030@030041008110000`400@0600030@00
00@00P4400060@000@010P040@800`4300030@0100H00P5Q00030@0001`0
000N00817`020@D00P4500030@0000<00P4500810`040@<00`4C00811P03
0@<010400`010@050@X000<10000OP0001l000<100007P000`4000040003
0@0000<00P4300<10`040@<00P40100100070@@00P4200811P020@<02042
00810`040@03004008X0000l00811@020@T000<100000`4500811@001040
00040@80104010010@4300030@0000<0104300030@0100@11@040@040041
0H/0000i00810P000`40000400040@000081200010400@4200<12P020@H0
0P400`01000:00<10P040@<000<100000`040@0400410GP00P4A0000>P00
0`40000<00030@00008100<00@4010090A0000<100002P020@D00`420081
10030@0300400081NP00104000020@`0001600811@020@03004100800P40
10010@040@800P4900@100<00@401`020@0400410@@00P401@010@4000<1
00<00@000`400`01001n00030@0000X0000k00812P000`40000400030@00
00<100<00@002P000`40000800030@0100<120030@0400410@@00`4200D1
00@00@41SP0002h00P4<00<13P020@800`4400815P000`40000900030@00
008110020@800`4200@1S`0002l000<1000030000`40000=00040@000081
1@000`40000800816P000`40000300030@0000@10P030Hl0001000813`03
0@T00P4600030@0000l00P4400812`030@<00P6600811`0003D00P450081
0`030@h000<1000010020@<000<100000P4E008110000`40000900811002
0BL00P5N00030@0000D0000f00030@0000@000<100000`000`40000:0081
0P030@<000<100001@00104000020@P00P4700030@0000<00P47008100<0
0@0010000`400008008170000`40001T0000;@020B800P42008100<00@40
0P020@030041008110000`40000700030@0000`00P400`010@0400030@00
00<13P000`4000210000;P000`40000:00814`030@H000<100000P4200<1
70060@H0106B0000?0000`40000200<13@020@X00`400`010@0C00@11P02
0@03004000<00P400`010@2D000090020A`00P4>00030@0000X000@10001
50000`400@0?00040@000@<00P470081QP0002D000<100009@020@D00P49
008110020AD00P4C00030@0000H000<10000Q00003400P4K00030@0000@0
00<1000020000`40000300030@0001@000<100006`020H@0000^00810P00
0`40000O00@19@020@/00P4200<12`000`40002200007@020A0000<10000
50020@/00`400`01000;008160000`40000300811@020@800P6@00007P00
0`400008008170000`40000:00040@00008120020@03004100800P4E0081
0`000`40000400<1TP0002X000<100004@020@T00P4:00810P000`400003
0@@000@100010`000`40000500812@030@03004000/00P6A0000?`000`40
000800030@0000T00P4400<150000`400008008120040@<000<10000S`00
05400`4300030@0100@16P020@@00`4800030@0109D0001;00811@020@80
0P4200<17000104000040@X00P400`010@2A0000@@020@T000<100001@06
0@030040024000<100002`001040006A0000@P000`40000@008100<00@40
0`020A/00P4200<1X00005801042008110000`40000J00040@000081X000
04P00P4900040@0100<19P020Il0001700<12P080BD000<10000W@0004P0
00<100001`020@04004100@1a@0005<000<1000010020LD0001800814@00
0`4000330000B@000`40000400811P040Bl00P6D0000D@000`4000050003
0@01030000<10000TP0005X00P750000F`020L@0001L00030@0002000P6P
0000P0000`40002N0000A@020@X00P4600<18`030Il0001600030@0000T0
00<100001@020B@00P6O0000o`0R0000A@020AH00P720000AP000`40000?
008110000`4000300000F@000`40000S0081X00005T00`4T0081W`0005X0
0P42008180020Il0001H008100<00@400P000`40000N0081W`0005L00`42
00030@00028000<10000W@0005P000<10000aP0004/00P49008100<00@40
9@020Il0001<00030@0000P000@100418P020@8000<100001`020I@0001D
008110000`40000Q008130000`40002B0000E@000`40000200<10`020Ad0
00<10000W`0005/00P4400030@000;d0001K0081a00004d00P4900D1a000
04h000<1000020000`400@350000DP020@<00P400`010@350000D`030@80
00<100000P740000AP020@X00P400`01000500818`020Ih0001700030@00
00T000<100000P400`010@0200030@00028000<10000W00005L010760000
D`020@@000@100000P720000E0000`40000200810`000`4000300000E`02
0@0500410@000P710000F0001@400001008000<10000:P020I<0002=0003
0@000940003o0280001E0081:P020Ih0001F00030@0000800P4S00@1W@00
05D00P4500030@00028000<100402`020I00001F00030@0000H00P4_0003
0@0008h0001P00030@000;h0003o0280001O0081`000060000<10000_P00
0?l08P000?l08P0008<00P6L0000H0020B8000<10000VP00064000<10000
_@0006000P6o0000H@000`40002m0000FP020@H00P6m0000F`000`400005
00030@0001`00P490081TP0008<000<1000020000`40002@0000o`0R0000
Q0020I/0002500030@0009T0003o0280003o0280001S0081_00006@000<1
0000^P0006D00P6j0000I@020KX0001V00030@000;P0001L0081``0005d0
00<10000`@000?l08P000?l08P000?l08P0006@00P4P0081V@0006D000<1
00007`000`40002G0000o`0R0000o`0R0000o`0R0000J@020KH0001Z0003
0@000;@0003o0280003o0280003o0280003o0280003o0280003o0280003o
0280003o0280003o0280003o0280003o0280003o0280003o0280003o0280
003o0280001_0081/000070000<10000[P000?l08P000?l08P000?l08P00
0?l08P000?l08P000001
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{289.625, 260.438},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"ChaosGame"]
}, Open  ]],

Cell[TextData[{
  "Usualle we get a better picture by setting the probablilities of the maps \
proportional to their contraction factor. Here are the contraction factors of \
the three maps in ",
  StyleBox["ifs0.", "Input"]
}], "Text",
  CellTags->"ChaosGame"],

Cell[CellGroupData[{

Cell["AverageContraction /@ ifs0[[1]]", "Input",
  PageWidth->Infinity,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->"ChaosGame"],

Cell[BoxData[
    \({0.239999999999999991`, 0.441029960028558765`, 0.9`}\)], "Output",
  CellTags->"ChaosGame"]
}, Open  ]],

Cell["\<\
Here are the corresponding probabilities, normalized such that
their sum equals 1.\
\>", "Text",
  PageWidth->Infinity,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->"ChaosGame"],

Cell[CellGroupData[{

Cell["ifsprobs = % / Plus @@ %", "Input",
  PageWidth->Infinity,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->"ChaosGame"],

Cell[BoxData[
    \({0.151799779933116996`, 0.278951045317694212`, 0.569249174749188746`}
      \)], "Output",
  CellTags->"ChaosGame"]
}, Open  ]],

Cell["\<\
The points are spread out more evenly with these \
probabilities.\
\>", "Text",
  PageWidth->Infinity,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->"ChaosGame"],

Cell[CellGroupData[{

Cell["\<\
ChaosGame[ifs0, 2000, Probabilities -> ifsprobs,
Coloring->Automatic];\
\>", "Input",
  PageWidth->Infinity,
  ShowSpecialCharacters->False,
  FormatType->InputForm,
  CellTags->"ChaosGame"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P00012PP10`400001
0?ooo`000;:b/Z2PX5QHF=GEeD2P`2m?CfUYJKjn_]?Cdol009000>o_komo
Oo[j0000<]WIfNc/k:>SXk0`H7moOkoOol?3`h:2PXj>SP00oooo0=0PT:0P
l3bcLN?ShmSHf<k>c/C4a;Zj^[6a/MRof8n?SiVIVIVI07PD0?ooOn?U]ooj
nW>6VO3ol7EeMIJFUP00?l30`000O`00_`0o000o?`0oO`0o_`0oo`1o001o
?knH]RgUiKOUi@1oO`1o_`1oo`2o002o?`2oO`2o_`2oo`3o003o?`3oO`3o
_`3oocl003l0?cl0Ocl0_cl0oclo03lo?cloOclo_cloocmo03mo?cmoOcmo
_cmoocno03no?cnoOcno_cnoocoo03oo?cooOcoo_cooogl007l0?gl0Ogl0
_gl0oglo07lo?gloOglo_gloogmo07mo?gmo_gmoogno07no?gnoOgno_gno
ogoo07oo?gooOgoo_goookl00;l0?kl0Okl0_kl0oklo0;lo?kloOklo_klo
okmo0;mo?kmoOkmo_kmookno0;no?knoOkno_knookoo0;oo?kooOkoo_koo
ool0?ol0Ool0_ol0oolo0?lo?oloOolo_olooomo0?mo?omo_omooono0?no
?onoOono_onooooo?ooo_n[ZjWAdM:NWYjj^[WMgM`3`0>OWifm_Ko000000
c00c000c<`0cIP0cV@0cc00co`1V001V<`1VIP1VV@1Vc01Vo`2I002I<`2I
IP2IV@2Ic02Io`3<003<<`3<IP3<V@3<c03<o`3o<`3oIP3oV@3oc3<003<0
<c<0IS<0VC<0c3<0oc<c03<c<c<cIS<cVC<cc3<coc=V03=V<c=VIS=VVC=V
c3=Voc>I03>I<c>IIS>IVC>Ic3>Ioc?<03?<<c?<IS?<VC?<c3?<oc?o03?o
<c?oIS?oVC?oc3?oofH006H0<fH0IVH0VFH0c6H0ofHc06Hc<fHcIVHcVFHc
c6Hcool08@000?l08@000?l08@000?l08@000?l08@000?l08@0001/00P_o
00@0000L00032`000?l00P000?l08@000?l08@000?l08@0002400P_m0000
8P000`/0003k0000o`0Q0000o`0Q0000o`0Q0000o`0Q0000IP022kP0000W
008;?P000`/0002f0000:0000`/0003e0000o`0Q0000o`0Q0000<P022n`0
000c00032`000>X0003o02400006008;=P022n00000700032`0002D00P/>
00032`000=h0000`00032`000>d0003o0240000;008;F@022kP0000<0003
2`0005P000<;0000]P000?l08@0003`00P/9008;;0022jT0000m00032`00
00P000<;0000:`000`/0002W0000o`0Q00004@022bH00P_U00004P000`/0
000U00032`000><0001:008;e00004/000<;0000dP0007d00P^Q0000M`02
2`D000<;0000W`0007P000<;0000Y@0001P00P_o00L0000I00032`0002/0
0P_G0000B0022al00P^e0000@0022`L000<;00007P000`/0000Q008;T000
044000<;00004@022aL00P/7008;5P000`/0002>0000EP000`/00009008;
2`000`/0000600<;Y@0004D00P/L00032`00008;4P000`/0000B008;S`00
04H000<;00007P000`/0000V00032`0008d0002P0097OP0002400P/K008;
60022bl00P/F0003A`0007`0000R00032`0001X000<;00005`000`/0000C
008;6@000`/0002C0000L0000`/0002]00007@022ol00P0001h000<;0000
3P022bL00P/L008;Z000030000<;00009P000`/0000F008;0`000`/0002V
0000L`000`/0000:008;WP0001P00P/@008;7@022`/00`/X00032`0009`0
000I00032`0000l000<;000070000`/000026P<00P/3008;=@022i00001=
00032aX;00<000<;00003P022a@00P/?008;0P000`/000022h`0001>008;
5@000`/0000C00032`0000h000<;000010000`/0002:0000;0022b<00P/0
0`0;2`0@008;4P022a/00TN70000;@000`/0000R00042`002a4000<;0000
4@032`800P/0100;2`/B0003A`0008D0001m00052`0000/00P022iX0000X
008;E`022id0000Y00032`0002400P/00`0;2`0R008J30022`0300/;09T0
0019008;0`000`/000032aD00P/:00046P0000@;1P0010/000/5008;TP00
02800P/C008;0`022``000<;00001P022aD000@;00/;30000`/02`0@00<;
T00002<000<;00004P000`/0000200032`0001@000<;00001P022`/00P/0
0`0;000L008;0P042a800TL4008;L`0003L00P/G00@;2P022`/000<;0000
7P001@/02`/0008;4`000dL0000300032`000740000h00032`0000D00`/:
008;0P032`T00`/5008;50022a8000<;00000`022`97Q`0004400P/;0003
2`00008;2`0010/02`/400032`0001<000<;00005`000`/0A`022`H00TMm
0000>@022aL000<;000030000`/00006008;4`022`<00P/=008;1@000`/0
000500=70`022gH0000j00032`0002400P/;00032`00018000<;00000P00
0`/00003008;1`000`/0000=0003A`00008000<;0000M00003T00P/N008;
10000`/00004008;90032a400TL;0097L@0003X000<;00002P022a4000<;
00002P032`L00P/3008;3P022`<00P/00`0;000:00<;10000dL000022`P0
00=70000K`0004P000<;00004`042`800P/3008;1`000`/0000200032`00
00d00`/200032`0000`00`/700032`0000D00P]a0000:P022`T00P/O008J
1`000`/02`0300032`00008000<;00000P022`0400/;2a@000<;00004@02
2`l000<;0000K`0002/000<;000020022al000<J000020052`T000<;0000
0P/4008;6`022`H000<;00000QX4008;M`0003L000<;00002P022`L00P/D
00@;4@042a/00`/800036P0000<000<;0000M@0002l00P/D00032`0000H0
00<;00004`022`8J0`000`/J6P08008;00@02`0;20022a<000<;0000Q000
030000<;0000<P000`/06P0400032aX000P000<;00001`022`8000<;0000
0P/6008;4P022`L00P]a0000J0022`/00P/3008;1P000`/0000400032`00
00D000<;00000`02A`032`0000T000<;00001P000`/0001_0000AP022`D0
0P/2008;20022`0300/;00800P/500032`0000X000<;00000P000`/0000J
00=730022gL0001700032`0000@00`/00`0;000800042`002`<000<;0000
10022`d00P/7008;1`042`800P/2008;0`000dL0000500@;0P000`/0001e
0000AP022`P000<;000030022`<010/300032`0000`000@;00000P/30003
2`0000H000<;00/00`0010/000032`0301XJ00L000<;00/01P022`X00P]V
0000@P022`<000<;00005P000`/0000200<;4P022`<000<;00004P022`80
0P/00`0;2`026Ph000<;00000`026P@000<;0000I00004<000<;00001`02
2`801@/A00032`0000D00QX9008;4`026P@000D;00002`0200032`0J01D0
00<J0000J@0004P010/200042`0000@;2P022`0300/;008;2@0011X02`/7
008;0P022`P00QX500036P0000L00TL6008;1002AgH00016008;00@02`0;
0P022`0300/;00h000<;00000`/<008;1@032`800P/2008;1@000aX0000=
009700<02`/010000`/000030003A`0000`00P]V0000A`0010/02`/300<;
00<02`004@000`/00008008;0P000`/000036P0300/000<00QX00`0;2`0;
00@;1`000dL000022`D00QXB00032`0006@0001:008;0`022a800`/;008;
1@026PL000@J000;1P022`801@/5008J00<;00000TL600036P0007L0000i
008;40000`/0000F008;1@022`800P/0100;2`022`@00P/6008J10026P03
00/0008000<;00001`000aX;2`022`03A`0000@00QX2008JM00003X000<;
000020022bD000D;00002`0200042`002`D000<;00001@000aX000026P03
01X0008;10022`T000<;00/01`001AX0000J07@00016008;5P022`D00P/7
008;0`022`L00QX500@;0QX400032`0000<000<;A`0020022`<00P/0100;
2`022gD00013008;0P000`/000022`/00P/600032`0000@000<;00000`02
2`0300/000<00P/700036P00008;0P0010/02aX3008;10036P03A`0000P0
00<;00000P0010/000/2008;0QX5008JJ`0003l00P/300032`0000<00P/<
00032`00018000<;00000P022`0300/000D00P/300032`0000P000@;00/;
0P026PP000<J2`/02P022`0300/J00H000<JAdL0J@00040000<;00002000
0`/00009008;20022a000P/500H;3`0010/06QX5008J0P/00`0J2`0;00<;
0`02A`<00TMY0000?P022aD00P/00`0;000800032`0000l000@;01XJ0P02
2`0300/000<;3P022`036P0000@000@J00/00`/400971@022`@000=76P00
0P000dL00005008J2@022`D00QY>0000?`000`/0000>008;10000`/00007
008;5@001AX0000;00@00P/7008;1P000`/00004008J10042`<000=70000
10022`0504L;2aX00P026PP000<J000020000`/0000400036P0004`00017
008;20000`/0000=00032`0000P00P/9008;20000`/00003008;00<02`/0
0`022`800QX400036P0000D000<;00000P022`0404M7008;0P000dL;0002
008JJ@0004P000<;00002@022aL000<;000020000`/02`026PP00QX0100;
00022`<000D;00006P03008;1P022`8J0`0010]7AdL200032`0000H000<J
0000I`0005400`/01@0;2`/0008;7`022`036P/000L000<J2`/00`000`/0
000:00032`0000D000<;01X00P0011X;2dL8008;4P026UP00017008;2@02
2`<000@;000;1P022`P00P/>00032`0;00X000<;00001P032`8J0P026P03
A`0000D00P/300036P/;00T000@;00/;40000aX0001F0000B0000`/0000?
008;1P032`0300/;00@000<;00002`036PD00P/:008;0QX32`046P0000<J
00<;00000`022`X00TL600@;0P026P0301XJ05l0001E008;10032`<00P/0
1@0;000;00L00`/3008;10026P800P/200042`0;2`800P/3008;00D06P/0
2`0600036P/0008;0`000`/J0003008J0`000`]7A`03008J0P022`046P00
6P8000@J00/;G00004X00P/:00032`0000<000<J2`000`000`/0000;008;
10052`D000<;00000`001@/J6P0;00800QX00`/000022`/00P/300036P/;
00<000<J00000P000`]7000300036P0000800aX500@J0`022eD0000l008;
3@000`/00005008;200011X000022a400P/01@0J6P0;00d000@J00000P/0
0aX0000200042`0;2`970P022`<000<;00000`026P800P/6009720000aX0
000400036P0J00@000@;00/;DP0003d000<;000050000`/0000300H;0P00
10/000032`8J0`022`D00`/00aX000052`800P/900032`0000<00QX22`06
04LJ6P0;2P001QX0000;6P@00TL22`8J5P000`/0001@0000B@022`h00`/0
100;00/3008;0P032`036P00008000@;00/;10001@/06QX000H;00@02`/0
0P/<00036P/0008000=76P000`026P8014L26P=700<J00000`001DL02`0J
00D00P/800<JE`0004P00`/400<;0P022`@000<;00000P/4008;00L02`/;
00/0008;0P026P032`0000D000<J00000P032`8000@;000;3`022`0404L0
008;00<06P000P/00dL0A`022`046TM7A`8;00<0AdL01@046P8000<;0000
1`036PP00P]<00007P022ad00`/900032`00008;0P022`<000<;00000P/4
00032`0000800`/00`0;2`0400052`0001X01@022`0400/;2`8J00<02`00
0P/5008J0`022`P000<;00000`001P/J6QX02`@000@;04L00dL010/0A`/2
008;00@06P0J1`026PD000<J00000P022`<000<;0000BP0001l000<;0000
20022`d00P/3008;00<02`/02P000`/0000900032`0000L00`/B00032`00
00<;00<J00000P000`/0000400066P0001X;10022`800QX500036P0J00D0
14L30004A`/000970P022`/000<J00002@0010/06QY=0000:`022`d000<;
00001@000`/0000D008;1P022`0400/;2`h00P/500<;20022`0300/;00<;
00<J2`/00P022`0400/;6P/00P/011Y72dL2008J0`026P<000<;00002@02
2`@00P/2008J0`000aX0001;0000;0000`/0000[00<;1@001@/0000;00D0
0P/800032`00008010/26P0300/;00@00P/01@0;2`0;00800`/0100;2`03
2`@00TL500052`0J00/00`000aX0000200036P00008J0P026PP000@;00/;
0P001@/0000J0540000j008;5@042`L000<;00003P000`/000022`L00QX0
100;00026P8000<;00000`072`<000@;AdL;0`000`]7A`030003A`/000L0
0QX5009700D06QX06P0300036P0000<00P/26P800`]F0000>`000`/00005
008;3@032`800QX6008;0P022`0300/;00@00P/300032`0000D000<;6P00
10000`/00007008;00<02aX00QX40003A`00008J0dL01@0J6P0;00P00P/6
0005A`006TL011X22`D000@;01X00QX00`0;001E0000A0000`/0000=0005
2`0001X01`001@/0000;008000@;00000QX32`H00`/00`0;2`02008;2002
2`0500/;2`000QX600970QX22`800aX5009700<02`/00P046P<00TL01P0J
01X02`X000<J00000P026PL00P]90000DP022aP000@J000;0`062`8000<;
00/010/00aX;2`04008;0P0010/02`/4008;00L0A`0J00/0008;00<06P00
1@0014L000/300036P0J00@000=700002`026PL000<J00001P0010/00002
6T@0001=008;10000`/0000J008;0P000`/02`0700072`002aX02`02008;
00@02`/;0`000`/0000200036P/0008J10000aX;0003008J00<0AdL01000
10]76QX3A`@00TL00`0J6P04008J00<06QX01P026Pd000<J0000@P0003`0
0P/@00032`0001<00P/4008J00<02`/00P000`/00004008;00<02`/02002
6P0300/000800P/800056P006P000P/200036P0000800QX3A`801dL00`17
A`03A`0304L000971@0011X001X700036P0000d00QY10000>P022`0300/0
01L00P/4008;1`000`/0000300<J00<;000020022`0300/000P000<J0000
10000`/0000<00052`0;2`001QX00dL00003A`052dL004L00`000dL0A`02
A`800TL26PX00QXB00036P0003l0000k00032`0000D00P/B00032`0000<0
00<;000030022``000<;00001P022`L010/26PH00P/00`17A`022`@J00<0
6P000QX0100J6TL4008J1@022`07A`0J6TL06P0;00036P0000<00QX4008J
A`0004@000<;00008`042`/00P/2008;00H06QXJ00/200@;0P026P032`0J
00H00P/2009700D02aX06P0300=700<06P000P/26P9700<06QX00`0010/0
00036PD00QX<00036P0000<000@J01XJ3P022c@0001K008;2`022`8J00@;
00000P/800052`0000/00P026PD000<;00/00`0011X06QX3008J0TL01@/0
001700<00TL300=700L;00002`0J00970aX80003AaX000D000<J00004P02
6Pl000<;0000<P0004H00P/9008;2@022`/00P/00aX;2`022`0300/0008;
4@026P@00P/0100J6QX3008J00<0A`000QX50097100014L02`022`<000E7
000J0002A`H00QX;008J3`000aX000120000A`000`/0000800032`0000P0
0P/3008;1P001`/000/02`000P/00`0;000@008;1@022`0301X000@000DJ
01XJ00036P8;0P0014L000026P0500/;00/00`026P@00TL400<J0`026P80
1QX5008JC@0005h000@;00000P/2008;0P022`<00P/00`0;000300@;0QX4
008J0`022`H000@;00000QX500076P002aX02`0700036P0000971@000aX0
00030004A`0000<J10026P<00QX00`0J6P046P8000<J0000B`0002l00P/E
008;60022`0300/0008000@;01XJ0`/26P032`0000D000D;00/06P040003
2aX000<000D;01XJ2`0700036P0000L000@;01XJ1@04A`0404L0008J2@02
6P0301XJ008J0`026P@01AX0100J00026P0301XJ04T0000`00032`0000`0
0P/600032`0001800P/300032`0000H000HJ000;01X2008;1`026P032`00
008000<;00000QX300036P/000`00P/500<J00L06QX0A`1700D01AX60097
00@06QXJ0`026PD000@J01XJ0P026P0501XJ01X0B@0003L00P/700032`00
01400P/700032`0000P00P/900042aX;2`<00P/011X;2`022`<00P/9008J
1002A`8J00<;00001@000aX000026P0304M700<00QX200036P0J00971@00
1DLJAdL0008J0TL00aX00005008J0`0011X001X300@JA00003P000<;0000
0P022a400P/300032`0000800P/=008;2P000aX;000300042`002`8000<;
6QX00P022`8J1`0011X000026P03A`0J00@00QX400<J0P000dLJ00020003
6P0000@000=7000010026P07A`0J6P1700026PH000<J00001`036P0301X0
04<0000n008;4@0010/02`/400<;0`022`@00QX300032`0000d00P/00`0;
2`0400066P0000/00QX22`T000<J00001P000aY7A`03A`036TL0008000<J
00000P02A`800dL200970`001AX0000J00@000<J00000`026P800QX60004
6P0J6T@0000o00032`0000T00P/00`0;2`03008;0P022`0300/000<00P/5
00046P00008;1@042`8J0P/200042`002`D00QX22`<000<J2`000P022`<0
0QX8008J0TL00`176P02A`8J1P000dL06P04A`0304M7008J2002A`0301XJ
008J0P026P0301XJ008J1`000aX000120000:@022a@00P/;00042`002`<0
0P/2008;1`000`/000022`0300/;00H;10001`/02`0J00/00QX500032aXJ
008000@J00/00P/600042`17A`8J00@06QX00QX300086P17A`0J04L26P<0
0TL22`0;AaXJA`176P1701X010026P<000=700000aX300@J00<06P004002
6ST0000Z00032`0001<000<;00004@001@/0000;00H00P/300032`00008;
00D02`002`08008;0P000aX;2`036P032aX;008;0P026P0300/000@00P/2
0003A`0J008000<J00000QX2008J00@0A`/;0P026P<00QX00`0J6P026P04
A`006PH00QX00`0J0002A`<00TL26P<00aX8008J2P000aX0000400<J<000
04l00P/?00032`0000h010/200032`00008000D;01X06P042`0401XJ6PP0
11X22`0301XJ009700@06QX00QX300072`0004LJ0002A`8J00D06QXJ0002
6P<00QX014L0AaX300036TLJ00<000=701X010000aX0000800036P0000@0
0QX:008J<00003L00P/9008;30000`/0000C008;2P032`P00`/0100J6P/2
00<J0P022`036P00008000<J2aX00P/2008J00A7000J0TL00aX000060097
00DJA`0J2`026P0504M76TL00P03A`800QX3008J3P026Pd000<J0000>P00
03P000<;000020000`/0000Q00032`0000P00P/900036P/;008000@J2`00
0P/01aX0000;6P000QX4008;0`026P800QX3A`P000Q76QXJ00/06P8000=7
04L00`000dL0000200036P0000@00QX<00036P00008J1`026Sd0001I00H;
1@022`<00`/700032`0000D00P/0100J6QX3008;00<J2`000`076PP000PJ
00006P0JA`800QX700036P00008000=76QX010036P<00TL400<J1`036P@0
1AX600036P0003/0001?008;2@001@/02`0;00H000<;00000P032`<00P/2
008;1P032`0301X000<000@;01X;100011X06P026P8;0P026P8;1`001AX0
AdLJ00d000=76P000P046P800QX00dL0000300@J10086P0401X0008J0P02
6Sl00019008;0P022`0400/;2``00P/00`0;2`07008;10022`8000<;0000
1P022`P000<;00001`000aX;2`0300036P0J008J0TL60003AaXJ00d00TL3
00036P0000<000<J00001`0011X06QX200DJ00<06P0010056Q800QX[0000
BP001@/0000;00<010/:00042`002`h000<;000010022`800`/26P0300/;
00<011X5008J00@;01XJ0P046P0404L000970`02A`D00QX300970P06A`L0
0QX800036P00008J00@06QX00QX400<J00<06P0010026PD00QX500036P00
02T00011008;30022`8000<;00/03`022`@00`/00`0;2`0800<;0P0010/0
01X200052`0000/00aX00`/J6P0300066P0001X01AX50003A`0000800QX2
00@J0`02A`8;00H0A`1704L200970`026P0301XJ00T000DJ000J00026P80
0QX00`0J00026PH000<J000010036Rl0001200032`0000/000<;00004`02
2`@00P/200032`0000L00P/200<;0P026P@000@;6P000aX900036P/000<J
00<06QX0100014L;2`02A`<J1003A`800QX50004A`00008J0P0011X06QX3
00DJ10001AX0000J00@000<J00001`026P@000<J0000;@0005000P/0100;
2`022`800P/600@;00<02`001`042`800P/3008;0P022`<000<J00001`02
6PX000D;00006P0200036P0000800`/20003A`0J00970QX2A`036TL00080
00<J00000QX014LJAdL200036P0000<000<J00000P046P800QX200@J1002
6PP000<J00000P046R`0001A00032`0000@;0`0010/02`/400032`0;008;
2@000`/02`0300032`00008000<;00005@026P0301XJ00d000<J2`/00P02
A`0404M700<J00<0AdL01TL011Y701X22`d00aX300076P0001X06P0300<J
3P000aX06P0/0000EP000`/00002008;00<02`001`000`/0000<008;0P03
2`800QX;00046P/;008;00LJ000J2`0J00<00QX900036P/0008000A70017
0`000aX00004A`8J00=700000`000`/00002A`8J0P046P800QX200<J00<0
6QX01P000aX0000>008J;00005`00`/H00<;00<02`/00P001@/J000;008J
00<;00000P/200066P/000/J0`000`/0000400036TM700T00TL<0006A`00
01X00QX70003A`0J00<011X6008J0P026P`011X700036P0002X0001N00@;
0P022`P00P/700@;1@022`800`/0100;2`/2008;400014L0AdL4009700<0
AaX01002A`0304M700D00QX200036P0000=700@0AdLJ1`000aX000090003
6P0000@00QX500<J3@026RD00015008;00<02`/010022`l000<;00/00`00
10/02`/600@;0P042`0400/;2`8J0P026P8000H;00002`022`0300/000T0
0TL70003A`/;00<000=76QX00QX2008J00A76QY71002A`036P0000@00TL2
0003AaX000971@026P@00QX00`0J6P0800036P00008J00@06QXJ0P026PT0
0QXU0000@P022`8000@;000;1@000`/0000F00032`0000<00`/00`0;0002
00<;00H02`/;01X300036P0J008J10/00`0;2`026P<00QX50003A`0000<0
0TL200042`17A`8000LJAdM704LJ008000<JAdL00TL20003A`17008J00<0
AdL00`02A`<000=700000QX200036P0J00@J0P000aX0000800<J0P026P<0
00<J000010026P8000<J00008`0004<00P/6008;00<02`/050042`D00`/0
0`0;2`05008;00<02`001`022`0301X;00<;0P000`/J2`0300036P0000D0
0QX30003A`0000<000E704M76P02A`8000=700000P03A`D000E76P00A`02
6P8000A704M70`026PD000<J01X010026PT000<J000010026P0301XJ00D0
00<J00009P0004@00`/500042`002`L00P/300@;10022`0300/000D000<;
00/00P/600042`00008;1P000`/000026P0400/;2`800P/200@;1002A`@0
0QX60004AaX0A`T00TL:009710000dLJ6P0200036P0000800QX700036P00
00800QX4008J10026P8000<J0000;00004H000<;000030022`0300/000<0
00<;00/01@000`/0000900032`0000X000<;00000`032`8000DJ2`/02`02
008J0`000`/02`050003A`0000<000<J00000TL400972P001DL0000J0097
1@000dLJ00030003AaX000L000<J00002`000aX0000300036P0000<00aX6
008J9`0003l00P/E00032`0000@00`/400@;0`022aD00P/00`0;2`040003
2`00008J00<06P/01@022`T00TL200A70P000dL0000:009700<06TL00P02
6P8000@J04M70P000dL00003008J7@000aX0000500036P0002D000100003
2`0000X00P/2008;0`042`8010/2008;00@02`/;10000`/02`032`0300/;
00800P/200<;1@000`/000022`@00QX01@0J000;008J10000`/000080003
A`0000800TL00`17A`0700970`05A`800QX50004A`0J6P9700D06QX06P0W
008J0P026P@00QXJ0000@`022`T000D;00002`0200H;0P000`/0000300@;
20000`/02`0200032`00008;0`022`T000<;00/00P/00`0J6P026P<000<J
00000`026P<00QX4A`0301XJ00<00dL80003A`0000=700@0AdM70P000aX0
000600036P17008000<J0000:0000aX000026PD000<J0000600004@000<;
00003`032`0300/000T00P/6008;1P022`0300/000<000<;000010022`@0
0P/3008J1@04A`0301X000<000DJ04L0A`0200036P/000800TL7008;0`00
0dLJA`03Acl000<J00007P0005P00P/00`0;2`0900052`0;2`0010/2008;
0`022`8010/700032`0000l00dL>00032`0000800dL600032`0000<000DJ
A`1700026PT00TL2008JCP0004l00P/800042`002``000<;00000`/2008;
00D02`/02`0300@;1@042a0000=700000QX4008J30000dL0000@00036P00
00P000E700006P0;008J:@026QH0000o008;3`000`/00008008;0`022``0
00D;00002`0200032`0000800`/00`0;0002008;00@02`0;1P026P`000@J
00170aXF008J0`02Aa000TL<00036P0002P000<J00005000040000<;0000
20022`l000<;00000P0010/000022`800P/;008;0`022`800P/2008;2P00
0aX;0006008J0P02A`042`176PX00TL400971P000aX000020003A`0000/0
0TL20003A`0004`0001<00032`0000`00P/6008;00<02`000`/6008;1000
0`/000032`800P/3008;10022`@000<;00000`026P0501X000/00TL50097
1`000dL000030003A`0000@00QX00dL0000?0003A`0004l0001J00<;00<0
2`/00P032`800`/7008;20022`<000<;00000P032`<000<;00002@000aX0
000300032dL000@00dL010/0AdL@00036TM70680001K00052`0000/00`00
0`/0000200032`0000L000<;00004P000`/0000D00032`0000@00TL01@/0
04L000973`000dL0001P0000IP022`0300/;008;1P022`d00P/00`0;2`08
008J10022`0300/;01800TL00`17A`080003AaXJ06@0001L008;1@022`80
00<;00/00`/00`0;2`0400032`0000800P/800@;1`022`036P0000<000@;
000;4`0014L0AdL90003AaX005T00QX80000F`032`H000<;00000`022`80
10/800032`0000<00P/300<;1`032`<00P/900970P02A`X000=700000TLA
008J00<06QX0C0000aX000060000G0000`/000022`X000<;00/010/3008;
1P052`@00P/6008;00<02`000`000`/00003008;0`000dL00002A`T00TL3
0004A`17A`l000@J000JE@0006000P/9008;00@02`0;1@032`0300/;00D;
1P000`/000062`X00QX00`0;00060003A`0000P000=7000010000dL0001V
0000H0032`T000@;00000P/600062`002`0;0P000`/0000800042`0;008;
0P022`H000<J00002@02A`0304M700/00TL2008J0TMQ0000CP022a400P/;
008;00@02`000P/=008;2`001@/0000;01<000A704M72P04A`8000<J04L0
H@0004l000<;00003`022`0300/;00T00`/00`0;2`042`/000<;00002`02
6QL000=700002@000dL0A`1V0000HP0010/000/:008;0P000`/000022`D0
0`/3008;10022`800P/0100;2aX50097Q@0005l00P/>008;2@022`<00P/4
00032`00008;00<02`000P0010/000/70003A`0008<0001P00032`0000d0
00<;00001@022`0300/000`000<;0000U00005X00P/K00<;4@022i<0001K
00032`0000/00P/2008;10022`<000@;00000`/200@;0`052aP00TL40097
L`0006X000D;00002`0500032`0000H00P/300032`0;00@000<;00/06P00
0dL000020097L`0006000P/4008;00<02`/08P022`d00QX>0003A`000740
001Q008;10022`0300/000`00P/<008;1P000`/0000<00036P000800001R
00032`0000<000<;000020022`@00`/3008;1P000`/0000L0097N00007<0
0P/500@;0P0010/000022b000TL<00970`02AfD0001M008;1@022`<00P/9
00032`0000@00`/2008;0`000`/00005008;0P022a@00dL;0003A`000080
00=70000H`0005h000<;000010000`/00002008;1`022`0300/;00@00P/3
00032`0000800P/600042`0000<;4`02AgH0001U008;00D02`/02`0700<;
00<02`0010000`/00007008;0P022`0300/;00@000<;00003@04AgP0001Q
008;0`0010/000/5008;0`072`H00P/4008;00@02`/;0P000`/0000C0003
A`1707P0001J008;1P000`/0000;00032`00008010/00`0;000600032`00
00<000@;000;1`022h/0001K00032`0000h00`/700032`0;00@;4@022`05
00/;00/0R`0006800P/4008;0`022`D00P/400032`0;00D01@/600<;0P00
0`/0000A0097N00006<000<;00000`000`/0000900032`0000800`/200<;
00<02`000`/600032`0001H000=70000MP0007/00P/3008;1@000`/00002
2i@0001c008;30000`/0000700032`0000l00TL00`17A`0F0097IP0007@0
0`/3008;3P022a8000A700174`02A`8000=70000I00005X00P/9008;3`02
2`<000@;00/;1@042`<000<;00006P02A`X00dMY0000F`000`/000080003
2`0000h000<;0000100010/000022`0500/02`000P/N0003A`0000T000=7
0000J00008<000<;000010000`/0000N0097L`0007l00P/U009700D0AdL0
A`1c0000OP032`D00P/O0004A`00A`X00TMY0000O`000`/000022`<00P/]
0003A`0006L0001o008;0P000`/0000200032`00008;T`0006`00P/3008;
10042`D010/800032`0000<00P^<0000K@000`/0000200032`0000<000<;
00/01@042`l000<;00005002Ag@00021008;:0000dL0001b0000Z`02Ag<0
0025008;1@022ah000=70000L@0008H000<;000010000`/0002@0000R002
2iH0002900032`0009@0002:008;U00008/000<;0000TP0007/00P/>008;
7P02Ag<0001l00032`0000800P/900032`0001d000=70000L@00088000<;
0000V`0008P00`^E0000R@022iD0003o0240002;008;T`0008T00P/00`0;
002B0000RP000`/000022i40002;008;00<02`00T00007`00P/5008;1`00
0`/0002A0000O@000`/0000400032`0009T00024008;VP0008400P/20003
2`0009P0002200032`0009/0002:008;U00008/000<;0000TP000?l08@00
0?l08@0008P00P^F0000R@000`/0002D0000o`0Q0000o`0Q0000S`022hl0
002@00032`0008d0003o0240003o0240003o0240003o0240003o0240003o
0240003o0240003o0240003o0240003o0240003o0240003o0240003o0240
003o0240003o0240003o0240003o0240003o0240003o0240003o0240003o
0240002I008;Q@0009X000<;0000P`000?l08@000?l08@000?l08@000?l0
8@000?l08@000001
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{288.25, 266.75},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  CellTags->"ChaosGame"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
ScreenStyleEnvironment->"Working",
WindowSize->{623, 614},
WindowMargins->{{175, Automatic}, {135, Automatic}},
ShowCellLabel->False,
StyleDefinitions -> "HelpBrowser.nb"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "AffineMap"->{
    Cell[4232, 158, 55, 1, 73, "Section",
      CellTags->"AffineMap"],
    Cell[4290, 161, 103, 2, 35, "Input",
      CellTags->"AffineMap"],
    Cell[4418, 167, 72, 2, 39, "Input",
      CellTags->"AffineMap"],
    Cell[4493, 171, 388, 6, 98, "Print",
      CellTags->"AffineMap"],
    Cell[4896, 180, 59, 1, 56, "Subsection",
      CellTags->"AffineMap"],
    Cell[4958, 183, 72, 1, 47, "Subsubsection",
      CellTags->{"AffineMap", "rotation"}],
    Cell[5055, 188, 85, 2, 35, "Input",
      CellTags->{"AffineMap", "rotation"}],
    Cell[5143, 192, 126, 2, 34, "Print",
      CellTags->{"AffineMap", "rotation"}],
    Cell[5284, 197, 68, 1, 47, "Subsubsection",
      CellTags->{"AffineMap", "scale"}],
    Cell[5377, 202, 79, 2, 35, "Input",
      CellTags->{"AffineMap", "scale"}],
    Cell[5459, 206, 169, 3, 50, "Print",
      CellTags->{"AffineMap", "scale"}],
    Cell[5643, 212, 78, 1, 47, "Subsubsection",
      CellTags->{"AffineMap", "translation"}],
    Cell[5746, 217, 91, 2, 35, "Input",
      CellTags->{"AffineMap", "translation"}],
    Cell[5840, 221, 145, 3, 34, "Print",
      CellTags->{"AffineMap", "translation"}],
    Cell[6000, 227, 56, 1, 56, "Subsection",
      CellTags->"AffineMap"],
    Cell[6059, 230, 93, 1, 47, "Subsubsection",
      CellTags->{"AffineMap", "AverageContraction"}],
    Cell[6177, 235, 105, 2, 35, "Input",
      CellTags->{"AffineMap", "AverageContraction"}],
    Cell[6285, 239, 187, 3, 50, "Print",
      CellTags->{"AffineMap", "AverageContraction"}],
    Cell[6487, 245, 57, 1, 56, "Subsection",
      CellTags->"AffineMap"],
    Cell[6547, 248, 110, 1, 47, "Subsubsection",
      CellTags->{"AffineMap", "$CirclePoints"}],
    Cell[6682, 253, 95, 2, 35, "Input",
      CellTags->{"AffineMap", "$CirclePoints"}],
    Cell[6780, 257, 179, 3, 50, "Print",
      CellTags->{"AffineMap", "$CirclePoints"}],
    Cell[6974, 263, 74, 1, 37, "Text",
      CellTags->{"AffineMap", "$CirclePoints"}],
    Cell[7073, 268, 90, 2, 39, "Input",
      CellTags->{"AffineMap", "$CirclePoints"}],
    Cell[7166, 272, 80, 2, 34, "Output",
      CellTags->{"AffineMap", "$CirclePoints"}],
    Cell[7261, 277, 55, 1, 56, "Subsection",
      CellTags->"AffineMap"],
    Cell[7319, 280, 103, 2, 35, "Input",
      CellTags->"AffineMap"],
    Cell[7425, 284, 81, 1, 37, "Text",
      CellTags->"AffineMap"],
    Cell[7531, 289, 72, 2, 39, "Input",
      CellTags->"AffineMap"],
    Cell[7606, 293, 66, 2, 34, "Output",
      CellTags->"AffineMap"],
    Cell[7687, 298, 81, 1, 37, "Text",
      CellTags->"AffineMap"],
    Cell[7793, 303, 90, 2, 39, "Input",
      CellTags->"AffineMap"],
    Cell[7886, 307, 66, 2, 34, "Output",
      CellTags->"AffineMap"],
    Cell[7967, 312, 61, 1, 37, "Text",
      CellTags->"AffineMap"],
    Cell[8031, 315, 88, 2, 39, "Input",
      CellTags->"AffineMap"],
    Cell[8122, 319, 130, 4, 37, "Text",
      CellTags->"AffineMap"],
    Cell[8277, 327, 68, 2, 39, "Input",
      CellTags->"AffineMap"],
    Cell[8348, 331, 122, 3, 34, "Output",
      CellTags->"AffineMap"],
    Cell[8485, 337, 63, 1, 37, "Text",
      CellTags->"AffineMap"],
    Cell[8573, 342, 491, 17, 204, "Input",
      CellTags->"AffineMap"],
    Cell[9067, 361, 20743, 343, 307, 20603, 338, "GraphicsData", 
    "Bitmap", "Graphics",
      Evaluatable->False,
      CellTags->"AffineMap"],
    Cell[29825, 707, 168, 4, 37, "Text",
      CellTags->"AffineMap"],
    Cell[30018, 715, 109, 2, 39, "Input",
      CellTags->"AffineMap"]},
  "rotation"->{
    Cell[4958, 183, 72, 1, 47, "Subsubsection",
      CellTags->{"AffineMap", "rotation"}],
    Cell[5055, 188, 85, 2, 35, "Input",
      CellTags->{"AffineMap", "rotation"}],
    Cell[5143, 192, 126, 2, 34, "Print",
      CellTags->{"AffineMap", "rotation"}]},
  "scale"->{
    Cell[5284, 197, 68, 1, 47, "Subsubsection",
      CellTags->{"AffineMap", "scale"}],
    Cell[5377, 202, 79, 2, 35, "Input",
      CellTags->{"AffineMap", "scale"}],
    Cell[5459, 206, 169, 3, 50, "Print",
      CellTags->{"AffineMap", "scale"}]},
  "translation"->{
    Cell[5643, 212, 78, 1, 47, "Subsubsection",
      CellTags->{"AffineMap", "translation"}],
    Cell[5746, 217, 91, 2, 35, "Input",
      CellTags->{"AffineMap", "translation"}],
    Cell[5840, 221, 145, 3, 34, "Print",
      CellTags->{"AffineMap", "translation"}]},
  "AverageContraction"->{
    Cell[6059, 230, 93, 1, 47, "Subsubsection",
      CellTags->{"AffineMap", "AverageContraction"}],
    Cell[6177, 235, 105, 2, 35, "Input",
      CellTags->{"AffineMap", "AverageContraction"}],
    Cell[6285, 239, 187, 3, 50, "Print",
      CellTags->{"AffineMap", "AverageContraction"}]},
  "$CirclePoints"->{
    Cell[6547, 248, 110, 1, 47, "Subsubsection",
      CellTags->{"AffineMap", "$CirclePoints"}],
    Cell[6682, 253, 95, 2, 35, "Input",
      CellTags->{"AffineMap", "$CirclePoints"}],
    Cell[6780, 257, 179, 3, 50, "Print",
      CellTags->{"AffineMap", "$CirclePoints"}],
    Cell[6974, 263, 74, 1, 37, "Text",
      CellTags->{"AffineMap", "$CirclePoints"}],
    Cell[7073, 268, 90, 2, 39, "Input",
      CellTags->{"AffineMap", "$CirclePoints"}],
    Cell[7166, 272, 80, 2, 34, "Output",
      CellTags->{"AffineMap", "$CirclePoints"}]},
  "IFS"->{
    Cell[43003, 936, 63, 1, 73, "Section",
      CellTags->"IFS"],
    Cell[43069, 939, 90, 2, 35, "Input",
      CellTags->"IFS"],
    Cell[43184, 945, 60, 2, 39, "Input",
      CellTags->"IFS"],
    Cell[43247, 949, 127, 3, 34, "Print",
      CellTags->"IFS"],
    Cell[43389, 955, 48, 1, 56, "Subsection",
      CellTags->"IFS"],
    Cell[43440, 958, 76, 1, 47, "Subsubsection",
      CellTags->{"IFS", "Probabilities"}],
    Cell[43541, 963, 89, 2, 35, "Input",
      CellTags->{"IFS", "Probabilities"}],
    Cell[43633, 967, 179, 3, 50, "Print",
      CellTags->{"IFS", "Probabilities"}],
    Cell[43827, 973, 69, 1, 37, "Text",
      CellTags->{"IFS", "Probabilities"}],
    Cell[43921, 978, 83, 2, 39, "Input",
      CellTags->{"IFS", "Probabilities"}],
    Cell[44007, 982, 105, 2, 34, "Output",
      CellTags->{"IFS", "Probabilities"}],
    Cell[44127, 987, 49, 1, 56, "Subsection",
      CellTags->"IFS"],
    Cell[44179, 990, 90, 2, 35, "Input",
      CellTags->"IFS"],
    Cell[44272, 994, 213, 5, 53, "Text",
      CellTags->"IFS"],
    Cell[44510, 1003, 280, 6, 103, "Input",
      CellTags->"IFS"],
    Cell[44793, 1011, 60, 2, 34, "Output",
      CellTags->"IFS"],
    Cell[44868, 1016, 153, 4, 37, "Text",
      CellTags->"IFS"],
    Cell[45046, 1024, 485, 17, 204, "Input",
      CellTags->"IFS"],
    Cell[45534, 1043, 20737, 343, 307, 20603, 338, "GraphicsData", 
    "Bitmap", "Graphics",
      Evaluatable->False,
      CellTags->"IFS"],
    Cell[66308, 1391, 73, 2, 39, "Input",
      CellTags->"IFS"],
    Cell[78557, 1600, 211, 5, 53, "Text",
      CellTags->"IFS"],
    Cell[78793, 1609, 82, 2, 39, "Input",
      CellTags->"IFS"],
    Cell[78878, 1613, 20091, 333, 255, 19953, 328, "GraphicsData", 
    "Bitmap", "Graphics",
      Evaluatable->False,
      CellTags->"IFS"]},
  "Probabilities"->{
    Cell[43440, 958, 76, 1, 47, "Subsubsection",
      CellTags->{"IFS", "Probabilities"}],
    Cell[43541, 963, 89, 2, 35, "Input",
      CellTags->{"IFS", "Probabilities"}],
    Cell[43633, 967, 179, 3, 50, "Print",
      CellTags->{"IFS", "Probabilities"}],
    Cell[43827, 973, 69, 1, 37, "Text",
      CellTags->{"IFS", "Probabilities"}],
    Cell[43921, 978, 83, 2, 39, "Input",
      CellTags->{"IFS", "Probabilities"}],
    Cell[44007, 982, 105, 2, 34, "Output",
      CellTags->{"IFS", "Probabilities"}]},
  "ChaosGame"->{
    Cell[98984, 1949, 58, 1, 73, "Section",
      CellTags->"ChaosGame"],
    Cell[99045, 1952, 102, 2, 35, "Input",
      CellTags->"ChaosGame"],
    Cell[99172, 1958, 72, 2, 39, "Input",
      CellTags->"ChaosGame"],
    Cell[99247, 1962, 159, 3, 50, "Print",
      CellTags->"ChaosGame"],
    Cell[99421, 1968, 54, 1, 56, "Subsection",
      CellTags->"ChaosGame"],
    Cell[99478, 1971, 72, 1, 47, "Subsubsection",
      CellTags->{"ChaosGame", "Coloring"}],
    Cell[99575, 1976, 85, 2, 35, "Input",
      CellTags->{"ChaosGame", "Coloring"}],
    Cell[99663, 1980, 278, 4, 66, "Print",
      CellTags->{"ChaosGame", "Coloring"}],
    Cell[99956, 1987, 142, 5, 38, "Text",
      CellTags->{"ChaosGame", "Coloring"}],
    Cell[100101, 1994, 1329, 43, 122, "Text",
      CellTags->{"ChaosGame", "Coloring"}],
    Cell[101433, 2039, 55, 1, 56, "Subsection",
      CellTags->"ChaosGame"],
    Cell[101491, 2042, 102, 2, 35, "Input",
      CellTags->"ChaosGame"],
    Cell[101596, 2046, 96, 1, 37, "Text",
      CellTags->"ChaosGame"],
    Cell[101695, 2049, 292, 6, 103, "Input",
      CellTags->"ChaosGame"],
    Cell[101990, 2057, 68, 1, 37, "Text",
      CellTags->"ChaosGame"],
    Cell[102083, 2062, 91, 2, 39, "Input",
      CellTags->"ChaosGame"],
    Cell[102177, 2066, 16384, 272, 280, 16236, 267, "GraphicsData", 
    "Bitmap", "Graphics",
      Evaluatable->False,
      CellTags->"ChaosGame"],
    Cell[118576, 2341, 261, 6, 54, "Text",
      CellTags->"ChaosGame"],
    Cell[118862, 2351, 153, 4, 39, "Input",
      CellTags->"ChaosGame"],
    Cell[119018, 2357, 111, 2, 34, "Output",
      CellTags->"ChaosGame"],
    Cell[119144, 2362, 211, 7, 59, "Text",
      CellTags->"ChaosGame"],
    Cell[119380, 2373, 146, 4, 39, "Input",
      CellTags->"ChaosGame"],
    Cell[119529, 2379, 135, 3, 34, "Output",
      CellTags->"ChaosGame"],
    Cell[119679, 2385, 194, 7, 36, "Text",
      CellTags->"ChaosGame"],
    Cell[119898, 2396, 200, 7, 54, "Input",
      CellTags->"ChaosGame"],
    Cell[120101, 2405, 20587, 341, 286, 20441, 336, "GraphicsData", 
    "Bitmap", "Graphics",
      Evaluatable->False,
      CellTags->"ChaosGame"]},
  "Coloring"->{
    Cell[99478, 1971, 72, 1, 47, "Subsubsection",
      CellTags->{"ChaosGame", "Coloring"}],
    Cell[99575, 1976, 85, 2, 35, "Input",
      CellTags->{"ChaosGame", "Coloring"}],
    Cell[99663, 1980, 278, 4, 66, "Print",
      CellTags->{"ChaosGame", "Coloring"}],
    Cell[99956, 1987, 142, 5, 38, "Text",
      CellTags->{"ChaosGame", "Coloring"}],
    Cell[100101, 1994, 1329, 43, 122, "Text",
      CellTags->{"ChaosGame", "Coloring"}]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"AffineMap", 141403, 2769},
  {"rotation", 144898, 2858},
  {"scale", 145173, 2865},
  {"translation", 145445, 2872},
  {"AverageContraction", 145742, 2879},
  {"$CirclePoints", 146056, 2886},
  {"IFS", 146612, 2899},
  {"Probabilities", 148437, 2950},
  {"ChaosGame", 148969, 2963},
  {"Coloring", 151135, 3020}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 82, 4, 160, "Title"],
Cell[1824, 57, 66, 1, 57, "Subsubtitle"],
Cell[1893, 60, 28, 0, 60, "Section"],
Cell[1924, 62, 30, 0, 34, "Subsubsection"],
Cell[1957, 64, 75, 1, 24, "Text"],
Cell[2035, 67, 31, 0, 34, "Subsubsection"],
Cell[2069, 69, 31, 0, 24, "Text"],
Cell[2103, 71, 32, 0, 34, "Subsubsection"],
Cell[2138, 73, 91, 3, 24, "Text"],
Cell[2232, 78, 34, 0, 34, "Subsubsection"],
Cell[2269, 80, 313, 7, 88, "Text"],
Cell[2585, 89, 41, 0, 34, "Subsubsection"],
Cell[2629, 91, 19, 0, 24, "Text"],
Cell[2651, 93, 101, 4, 38, "Subsubsection"],
Cell[2755, 99, 19, 0, 24, "Text"],
Cell[2777, 101, 32, 0, 34, "Subsubsection"],
Cell[2812, 103, 176, 7, 24, "Text"],
Cell[2991, 112, 33, 0, 34, "Subsubsection"],
Cell[3027, 114, 58, 0, 24, "Text"],
Cell[3088, 116, 31, 0, 34, "Subsubsection"],
Cell[3122, 118, 188, 7, 24, "Text"],
Cell[3313, 127, 33, 0, 34, "Subsubsection"],
Cell[3349, 129, 107, 1, 24, "Text"],
Cell[3459, 132, 315, 7, 57, "Text"],
Cell[3777, 141, 35, 0, 34, "Subsubsection"],
Cell[3815, 143, 100, 1, 24, "Text"],
Cell[3918, 146, 35, 0, 34, "Subsubsection"],
Cell[3956, 148, 108, 1, 24, "Text"],
Cell[4067, 151, 37, 0, 34, "Subsubsection"],
Cell[4107, 153, 122, 3, 27, "Text"],
Cell[4232, 158, 55, 1, 73, "Section",
  CellTags->"AffineMap"],
Cell[4290, 161, 103, 2, 35, "Input",
  CellTags->"AffineMap"],

Cell[CellGroupData[{
Cell[4418, 167, 72, 2, 39, "Input",
  CellTags->"AffineMap"],
Cell[4493, 171, 388, 6, 98, "Print",
  CellTags->"AffineMap"]
}, Open  ]],
Cell[4896, 180, 59, 1, 56, "Subsection",
  CellTags->"AffineMap"],
Cell[4958, 183, 72, 1, 47, "Subsubsection",
  CellTags->{"AffineMap", "rotation"}],

Cell[CellGroupData[{
Cell[5055, 188, 85, 2, 35, "Input",
  CellTags->{"AffineMap", "rotation"}],
Cell[5143, 192, 126, 2, 34, "Print",
  CellTags->{"AffineMap", "rotation"}]
}, Open  ]],
Cell[5284, 197, 68, 1, 47, "Subsubsection",
  CellTags->{"AffineMap", "scale"}],

Cell[CellGroupData[{
Cell[5377, 202, 79, 2, 35, "Input",
  CellTags->{"AffineMap", "scale"}],
Cell[5459, 206, 169, 3, 50, "Print",
  CellTags->{"AffineMap", "scale"}]
}, Open  ]],
Cell[5643, 212, 78, 1, 47, "Subsubsection",
  CellTags->{"AffineMap", "translation"}],

Cell[CellGroupData[{
Cell[5746, 217, 91, 2, 35, "Input",
  CellTags->{"AffineMap", "translation"}],
Cell[5840, 221, 145, 3, 34, "Print",
  CellTags->{"AffineMap", "translation"}]
}, Open  ]],
Cell[6000, 227, 56, 1, 56, "Subsection",
  CellTags->"AffineMap"],
Cell[6059, 230, 93, 1, 47, "Subsubsection",
  CellTags->{"AffineMap", "AverageContraction"}],

Cell[CellGroupData[{
Cell[6177, 235, 105, 2, 35, "Input",
  CellTags->{"AffineMap", "AverageContraction"}],
Cell[6285, 239, 187, 3, 50, "Print",
  CellTags->{"AffineMap", "AverageContraction"}]
}, Open  ]],
Cell[6487, 245, 57, 1, 56, "Subsection",
  CellTags->"AffineMap"],
Cell[6547, 248, 110, 1, 47, "Subsubsection",
  CellTags->{"AffineMap", "$CirclePoints"}],

Cell[CellGroupData[{
Cell[6682, 253, 95, 2, 35, "Input",
  CellTags->{"AffineMap", "$CirclePoints"}],
Cell[6780, 257, 179, 3, 50, "Print",
  CellTags->{"AffineMap", "$CirclePoints"}]
}, Open  ]],
Cell[6974, 263, 74, 1, 37, "Text",
  CellTags->{"AffineMap", "$CirclePoints"}],

Cell[CellGroupData[{
Cell[7073, 268, 90, 2, 39, "Input",
  CellTags->{"AffineMap", "$CirclePoints"}],
Cell[7166, 272, 80, 2, 34, "Output",
  CellTags->{"AffineMap", "$CirclePoints"}]
}, Open  ]],
Cell[7261, 277, 55, 1, 56, "Subsection",
  CellTags->"AffineMap"],
Cell[7319, 280, 103, 2, 35, "Input",
  CellTags->"AffineMap"],
Cell[7425, 284, 81, 1, 37, "Text",
  CellTags->"AffineMap"],

Cell[CellGroupData[{
Cell[7531, 289, 72, 2, 39, "Input",
  CellTags->"AffineMap"],
Cell[7606, 293, 66, 2, 34, "Output",
  CellTags->"AffineMap"]
}, Open  ]],
Cell[7687, 298, 81, 1, 37, "Text",
  CellTags->"AffineMap"],

Cell[CellGroupData[{
Cell[7793, 303, 90, 2, 39, "Input",
  CellTags->"AffineMap"],
Cell[7886, 307, 66, 2, 34, "Output",
  CellTags->"AffineMap"]
}, Open  ]],
Cell[7967, 312, 61, 1, 37, "Text",
  CellTags->"AffineMap"],
Cell[8031, 315, 88, 2, 39, "Input",
  CellTags->"AffineMap"],
Cell[8122, 319, 130, 4, 37, "Text",
  CellTags->"AffineMap"],

Cell[CellGroupData[{
Cell[8277, 327, 68, 2, 39, "Input",
  CellTags->"AffineMap"],
Cell[8348, 331, 122, 3, 34, "Output",
  CellTags->"AffineMap"]
}, Open  ]],
Cell[8485, 337, 63, 1, 37, "Text",
  CellTags->"AffineMap"],

Cell[CellGroupData[{
Cell[8573, 342, 491, 17, 204, "Input",
  CellTags->"AffineMap"],
Cell[9067, 361, 20743, 343, 307, 20603, 338, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False,
  CellTags->"AffineMap"]
}, Open  ]],
Cell[29825, 707, 168, 4, 37, "Text",
  CellTags->"AffineMap"],

Cell[CellGroupData[{
Cell[30018, 715, 109, 2, 39, "Input",
  CellTags->"AffineMap"],
Cell[30130, 719, 12858, 214, 167, 12739, 210, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[43003, 936, 63, 1, 73, "Section",
  CellTags->"IFS"],
Cell[43069, 939, 90, 2, 35, "Input",
  CellTags->"IFS"],

Cell[CellGroupData[{
Cell[43184, 945, 60, 2, 39, "Input",
  CellTags->"IFS"],
Cell[43247, 949, 127, 3, 34, "Print",
  CellTags->"IFS"]
}, Open  ]],
Cell[43389, 955, 48, 1, 56, "Subsection",
  CellTags->"IFS"],
Cell[43440, 958, 76, 1, 47, "Subsubsection",
  CellTags->{"IFS", "Probabilities"}],

Cell[CellGroupData[{
Cell[43541, 963, 89, 2, 35, "Input",
  CellTags->{"IFS", "Probabilities"}],
Cell[43633, 967, 179, 3, 50, "Print",
  CellTags->{"IFS", "Probabilities"}]
}, Open  ]],
Cell[43827, 973, 69, 1, 37, "Text",
  CellTags->{"IFS", "Probabilities"}],

Cell[CellGroupData[{
Cell[43921, 978, 83, 2, 39, "Input",
  CellTags->{"IFS", "Probabilities"}],
Cell[44007, 982, 105, 2, 34, "Output",
  CellTags->{"IFS", "Probabilities"}]
}, Open  ]],
Cell[44127, 987, 49, 1, 56, "Subsection",
  CellTags->"IFS"],
Cell[44179, 990, 90, 2, 35, "Input",
  CellTags->"IFS"],
Cell[44272, 994, 213, 5, 53, "Text",
  CellTags->"IFS"],

Cell[CellGroupData[{
Cell[44510, 1003, 280, 6, 103, "Input",
  CellTags->"IFS"],
Cell[44793, 1011, 60, 2, 34, "Output",
  CellTags->"IFS"]
}, Open  ]],
Cell[44868, 1016, 153, 4, 37, "Text",
  CellTags->"IFS"],

Cell[CellGroupData[{
Cell[45046, 1024, 485, 17, 204, "Input",
  CellTags->"IFS"],
Cell[45534, 1043, 20737, 343, 307, 20603, 338, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False,
  CellTags->"IFS"]
}, Open  ]],

Cell[CellGroupData[{
Cell[66308, 1391, 73, 2, 39, "Input",
  CellTags->"IFS"],
Cell[66384, 1395, 12158, 202, 180, 12039, 198, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False]
}, Open  ]],
Cell[78557, 1600, 211, 5, 53, "Text",
  CellTags->"IFS"],

Cell[CellGroupData[{
Cell[78793, 1609, 82, 2, 39, "Input",
  CellTags->"IFS"],
Cell[78878, 1613, 20091, 333, 255, 19953, 328, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False,
  CellTags->"IFS"]
}, Open  ]],
Cell[98984, 1949, 58, 1, 73, "Section",
  CellTags->"ChaosGame"],
Cell[99045, 1952, 102, 2, 35, "Input",
  CellTags->"ChaosGame"],

Cell[CellGroupData[{
Cell[99172, 1958, 72, 2, 39, "Input",
  CellTags->"ChaosGame"],
Cell[99247, 1962, 159, 3, 50, "Print",
  CellTags->"ChaosGame"]
}, Open  ]],
Cell[99421, 1968, 54, 1, 56, "Subsection",
  CellTags->"ChaosGame"],
Cell[99478, 1971, 72, 1, 47, "Subsubsection",
  CellTags->{"ChaosGame", "Coloring"}],

Cell[CellGroupData[{
Cell[99575, 1976, 85, 2, 35, "Input",
  CellTags->{"ChaosGame", "Coloring"}],
Cell[99663, 1980, 278, 4, 66, "Print",
  CellTags->{"ChaosGame", "Coloring"}]
}, Open  ]],
Cell[99956, 1987, 142, 5, 38, "Text",
  CellTags->{"ChaosGame", "Coloring"}],
Cell[100101, 1994, 1329, 43, 122, "Text",
  CellTags->{"ChaosGame", "Coloring"}],
Cell[101433, 2039, 55, 1, 56, "Subsection",
  CellTags->"ChaosGame"],
Cell[101491, 2042, 102, 2, 35, "Input",
  CellTags->"ChaosGame"],
Cell[101596, 2046, 96, 1, 37, "Text",
  CellTags->"ChaosGame"],
Cell[101695, 2049, 292, 6, 103, "Input",
  CellTags->"ChaosGame"],
Cell[101990, 2057, 68, 1, 37, "Text",
  CellTags->"ChaosGame"],

Cell[CellGroupData[{
Cell[102083, 2062, 91, 2, 39, "Input",
  CellTags->"ChaosGame"],
Cell[102177, 2066, 16384, 272, 280, 16236, 267, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False,
  CellTags->"ChaosGame"]
}, Open  ]],
Cell[118576, 2341, 261, 6, 54, "Text",
  CellTags->"ChaosGame"],

Cell[CellGroupData[{
Cell[118862, 2351, 153, 4, 39, "Input",
  CellTags->"ChaosGame"],
Cell[119018, 2357, 111, 2, 34, "Output",
  CellTags->"ChaosGame"]
}, Open  ]],
Cell[119144, 2362, 211, 7, 59, "Text",
  CellTags->"ChaosGame"],

Cell[CellGroupData[{
Cell[119380, 2373, 146, 4, 39, "Input",
  CellTags->"ChaosGame"],
Cell[119529, 2379, 135, 3, 34, "Output",
  CellTags->"ChaosGame"]
}, Open  ]],
Cell[119679, 2385, 194, 7, 36, "Text",
  CellTags->"ChaosGame"],

Cell[CellGroupData[{
Cell[119898, 2396, 200, 7, 54, "Input",
  CellTags->"ChaosGame"],
Cell[120101, 2405, 20587, 341, 286, 20441, 336, "GraphicsData", 
"Bitmap", "Graphics",
  Evaluatable->False,
  CellTags->"ChaosGame"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

